﻿USE sofia;
DROP TABLE IF EXISTS sofia.krj_vpl;
CREATE TABLE krj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES krj_vpl WRITE;
INSERT INTO krj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Amo dya ang lista kang mga kaulangan ni Jesu-Cristo nga kaliwat ni David, kag si David kaliwat ni Abraham. ");
INSERT INTO krj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham amo ang tatay ni Isaac, si Isaac tatay ni Jacob, si Jacob tatay ni Juda kag kang anang mga kabugtoan. ");
INSERT INTO krj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda tatay nanday Fares kag Zara. Ang andang nanay kadya amo si Tamar. Si Fares tatay ni Esrom kag si Esrom tatay ni Ram, ");
INSERT INTO krj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","si Ram tatay ni Aminadab, si Aminadab tatay ni Naason, si Naason tatay ni Salmon. ");
INSERT INTO krj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon tatay ni Boaz, nga ang anang nanay kadya amo si Rahab. Si Boaz tatay ni Obed nga ang anang nanay kadya amo si Ruth. Si Obed tatay ni Jesse, ");
INSERT INTO krj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kag si Jesse tatay ni Haring David. Si David tatay ni Solomon sa asawa anay ni Urias, ");
INSERT INTO krj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","si Solomon tatay ni Roboam, si Roboam tatay ni Abias, si Abias tatay ni Asaf. ");
INSERT INTO krj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asaf tatay ni Josafat, si Josafat tatay ni Joram, si Joram tatay ni Ozias, ");
INSERT INTO krj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","si Ozias tatay ni Joatam, si Joatam tatay ni Acaz, si Acaz tatay ni Ezequias. ");
INSERT INTO krj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias tatay ni Manases, si Manases tatay ni Amos, si Amos amo ang tatay ni Josias, ");
INSERT INTO krj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kag si Josias tatay ni Jeconias kag kang anang mga kabugtoan. Amo dya ang tion kang ginbihag ang mga Israelinhun paagto sa Babilonia. ");
INSERT INTO krj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kar-on, pagkatapos nga madara bilang bihag ang mga Israelinhun sa Babilonia, amo pa gid dyaay ang mga kaulangan ni Jesus: si Jeconias amo ang tatay ni Salatiel, si Salatiel tatay ni Zorobabel. ");
INSERT INTO krj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel tatay ni Abiud, si Abiud tatay ni Eliaquim, si Eliaquim tatay ni Azor, ");
INSERT INTO krj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","si Azor tatay ni Sadoc, si Sadoc tatay ni Aquim, si Aquim tatay ni Eliud, ");
INSERT INTO krj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","si Eliud tatay ni Eleazar, si Eleazar tatay ni Matan, si Matan tatay ni Jacob, ");
INSERT INTO krj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kag si Jacob amo ang tatay ni Jose nga bana ni Maria. Kag si Maria nga dya amo ang nanay ni Jesus nga ginatawag Cristo. ");
INSERT INTO krj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gani, sa amo karia may napulo'g apat ka mga henerasyon halin kay Abraham hasta kay David, kag may napulo'g apat man ka mga henerasyon halin kay David hasta sa pagbihag sa mga Israelinhun pa-Babilonia. Kag halin sa pagbihag kananda pa-Babilonia hasta sa pagkatawo ni Cristo may napulo'g apat man ka mga henerasyon. ");
INSERT INTO krj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kar-on, amo dyaay ang mga nagkaratabo sa pagkatawo ni Jesu-Cristo. Kang ang nanay na kadya nga si Maria natalana run nga pagakaslun kay Jose, sa wara pa sanda kadya makasal nasapwan nga tana nagabusong paagi sa gahum kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose nga ana mangin bana sangka matarung nga tawo, kag indi dya malyag nga mabutang si Maria sa kahuruy-anan. Gani, nagplano tana nga bulagan si Maria sa likum nga paagi. ");
INSERT INTO krj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Samtang ginabinag-binag na ang mga bagay nga dya, may sangka anghel kang Ginoo nga nagpakita kana sa anang damgo kag nagkuon, “Jose, ikaw nga kaliwat ni David, indi ikaw magkahadluk sa pagpangasawa kay Maria hay nagabusong tana paagi sa gahum kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magabata tana kang sangka laki kag pangaranan mo dya kay Jesus, tungud hay tana kadya amo ang magaluwas kang anang mga katawhan sa andang mga kasal-anan.” ");
INSERT INTO krj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ang tanan nga dya natabo agud to nga matuman ang ginkuon kang Ginoo paagi sa anang propeta, ");
INSERT INTO krj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“May sangka ulay nga magabusong kag magabata kang sangka laki kag pagatawgun tana nga Emanuel” (kon sayudon, “Ang Dios kaimaw natun”). ");
INSERT INTO krj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kang makabugtaw si Jose, gintuman na ang ginsugo kang anghel kang Ginoo kag ginpangasawa na si Maria. ");
INSERT INTO krj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero wara tana maghulid kay Maria hasta nga nakabata dya kang sangka laki. Kag ginpangaranan na ang bata nga Jesus. ");
INSERT INTO krj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kar-on, si Jesus natawo sa banwa kang Betlehem sa probinsya kang Judea sa panahon nga si Herodes amo ang hari. Sangka adlaw kato may nag-abot sa Jerusalem nga mga mangin-aramun nga mga laki nga naghalin sa sidlangan. ");
INSERT INTO krj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Namangkot sanda, “Sa diin bala ang bata nga natawo nga mangin hari kang mga Judio? Hay nakita namun ang bituon rugto sa sidlangan nga nagapatimaan nga natawo run tana, amo gani nga nag-agto kami rugya agud magsimba kana.” ");
INSERT INTO krj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kang mabatian dya ni Haring Herodes, natublag tana kag amo man ang bilog nga katawhan kang Jerusalem. ");
INSERT INTO krj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gani, ginpatawag na ang tanan nga mga pangulo kang kaparian kag mga manunudlo kang Kasugoan kag ginpamangkot sanda kon diin matawo ang Cristo. ");
INSERT INTO krj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nagsugid sanda kana, “Sa banwa kang Betlehem nga sakup kang Judea, hay amo dya ang ginsulat kang propeta: ");
INSERT INTO krj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ikaw, Betlehem, sa lugar kang Juda, bukun ti ikaw ang pinakakubus nga lugar sa bilog nga Juda, hay rugyan kanimo magahalin ang sangka pangulo nga magadumara kang akun mga katawhan nga mga Israelinhun.” ");
INSERT INTO krj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Amo to kag likum nga ginpatawag ni Herodes ang mga mangin-aramun nga to kag pamangkuton kon ano gid oras nagtuhaw ang bituon. ");
INSERT INTO krj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatapos karia, ginpapanaw sanda ni Herodes paagto sa Betlehem kag ginbilinan, “Panaw kamo run to kag pangitaa ninyo kang maid-id ang bata, kag kon makita run gani ninyo balik kamo rugya kag sugidan ako agud to nga makaagto man ako sa pagsimba kana.” ");
INSERT INTO krj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagkatapos hambal kananda kang hari nagpanaw sanda. Kang nagapanaw run sanda nakita liwan nanda ang bituon nga amo man ang andang nakita sa sidlangan. Kag nalipay gid sanda kamayad! Gin-giyahan sanda kang amo nga bituon hasta nga nakalambot sanda sa lugar nga sa diin rugto ang bata. ");
INSERT INTO krj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kang pagsulud nanda sa balay, nakita nanda ang bata kag si Maria nga anang nanay. Nagluhod sanda sa pagsimba sa bata. Ginbuksan nanda ang andang mga regalo nga bulawan, insenso kag mahamot nga lana nga ginatawag mira, kag anda dya nga ginhalad sa bata. ");
INSERT INTO krj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pagkatapos karia, ginpaandaman sanda kang Dios paagi sa damgo nga indi run sanda magbalik kay Herodes. Gani, sa lain run nga aragyan sanda nag-agi pauli sa andang lugar. ");
INSERT INTO krj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kang nakalumbos run ang mga mangin-aramun nga to, ang anghel kang Ginoo nagpakita kay Jose paagi sa damgo nga nagakuon, “Bangon, dar-a ang bata kag ang anang nanay kag magpalagyo kamo sa Ehipto. Magtiner lang kamo anay rugto hasta kon san-o ko kamo ikun-an nga maghalin, hay ipapangita ni Herodes ang bata kag ana dya nga ipapatay.” ");
INSERT INTO krj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gani, nagbangon si Jose kag gindara na ang bata kag ang nanay na kadya nga si Maria kag nagpanaw lagi sanda kang gabii nga to paagto sa Ehipto. ");
INSERT INTO krj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nagtiner sanda rugto hasta sa tion nga napatay si Herodes. Natabo dya agud to nga matuman ang ginkuon kang Ginoo paagi sa anang propeta, “Gintawag ko ang akun bata nga laki halin sa Ehipto.” ");
INSERT INTO krj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Si Herodes tana, kang naman-an na nga ginloko tana kang mga mangin-aramun, nag-ugut gid tana kamayad. Nagmando tana nga pamatyun ang tanan nga mga bata nga laki sa banwa kang Betlehem kag sa mga iningud nga lugar—mga bata nga nagapangedadun kang darwa ka tuig panaba, suno sa tion nga naman-an na halin sa mga mangin-aramun kon kasan-o nagtuhaw ang bituon. ");
INSERT INTO krj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gani sa amo karia natuman ang ginkuon kang propeta nga si Jeremias, ");
INSERT INTO krj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May mabatian nga paghinibi kag pagpanangis sa banwa kang Rama, nagaparanangisun si Raquel para sa anang mga kabataan; indi run gid tana magpalugpay tungud nga nagkaramatay run sanda kadya.” ");
INSERT INTO krj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kar-on, kang napatay run si Herodes, ang anghel kang Ginoo nagpakita liwan kay Jose sa anang damgo rugto sa Ehipto. Ang anghel nagkuon kana nga, ");
INSERT INTO krj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bangon, dar-a ang bata kag ang anang nanay nga si Maria kag magbalik kamo sa lugar kang Israel, hay patay run ang mga tawo nga nagahingabot sa kabuhi kang bata.” ");
INSERT INTO krj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gani nagbangon si Jose kag gindara na ang bata kag ang anang nanay kag nagbalik sanda sa lugar kang Israel. ");
INSERT INTO krj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero kang pagkamaan na nga si Arquelo amo ang nagbulus sa anang tatay nga si Herodes bilang hari sa Judea, hinadlukan tana kadya mag-agto rugto. Ginpaandaman tana kadya sa anang damgo, amo gani nga sa probinsya kang Galilea run lang sanda nag-agto, ");
INSERT INTO krj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","rugto sanda nagtiner sa banwa kang Nazaret. Gani natuman ang ginkuon kang mga propeta, “Pagatawgun tana nga Nazarenhun.” ");
INSERT INTO krj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nag-abot ang tion nga si Juan nga Manugbawtiso nagpangwali sa naligwin nga logar kang Judea nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Maghinulsul kamo kag talikdan ninyo ang inyong mga sala, hay ang ginharian kang langit marapit run lang mag-abot.” ");
INSERT INTO krj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan nga dya amo ang ginatumud ni propeta Isaias kang magkuon tana, “Rugto sa kamingawan may nagahambal kang matunog gid nga nagakuon; Iaman ninyo ang dalan kang Ginoo tadlungan ninyo ang anang mga pagaagyan.” ");
INSERT INTO krj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dya si Juan nagasuksok kang panaptun nga nahuman sa bulbol kang sapat nga kamelyo kag may wagkus nga panit sa anang hawak. Ang ana kadya nga pagkaun mga apan kag dugus. ");
INSERT INTO krj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Duro nga mga tawo nga halin pa sa Jerusalem kag sa tanan nga lugar nga sakup kang probinsya kang Judea kag sa tanan nga mga lugar nga marapit sa suba kang Jordan ang nag-aragto kana. ");
INSERT INTO krj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gintoad nanda sa Dios ang andang mga kasal-anan, kag ginbawtisohan sanda ni Juan sa suba kang Jordan. ");
INSERT INTO krj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero kang makita ni Juan nga duro nga mga Fariseo kag mga Saduceo ang nag-aragto kana sa pagpabawtiso, ginkun-an na sanda, “Mga kaliwat kamo kang mga sawa! Sin-o ang nagkuon kaninyo nga makapalagyo kamo sa silot kang Dios nga magaabot? ");
INSERT INTO krj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ipakita ninyo sa inyo kabuhi nga naghinulsul kamo kag nagbiya run sa inyo nga mga kasal-anan. ");
INSERT INTO krj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Indi kamo magsarig nga indi kamo pagsilotan hay kuon ninyo mga linahi kamo ni Abraham. Sugidan ko kamo: bisan ang mga bato nga dya sarang kang Dios himuon nga mga linahi ni Abraham. ");
INSERT INTO krj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bisan gani kadya ang wasay nahanda run nga itapas sa kahoy. Ang kada kahoy nga wara nagapamunga kang mayad pagatapsun kag itablug sa kalayo.” ");
INSERT INTO krj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kag nagkuon pa gid kananda si Juan, “Ginabawtisohan ko kamo sa tubig tanda kang inyong paghinulsul kag pagtalikod sa inyong mga kasal-anan. Pero may magaabot nga labaw pa gid sangsa kanakun, nga bisan pa gani sa pagbitbit kang ana mga sandalyas bukun ako ti takus. Pagabawtisohan na kamo kang Balaan nga Ispirito kag kalayo. ");
INSERT INTO krj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pagapainun na ang mga tawo nga mayad sa mga malain, pareho kang nagatahup tana kang lamigas nga ginapain na ang timgas sa upa. Ang timgas kadya ginatipon na kag taguon sa kamarin, kag ang upa tana ginatablug sa kalayo nga sa diin wara ti katapusan ang anang pagdaba-daba.” ");
INSERT INTO krj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sa amo man to nga mga inadlaw, nag-abot si Jesus halin sa Galilea kag nag-agto kay Juan sa suba kang Jordan sa pagpabawtiso. ");
INSERT INTO krj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Indi raad gusto ni Juan nga magbawtiso kay Jesus. Nagkuon si Juan, “Andut haw nga ako ang magabawtiso kanimo? Ikaw raad tana ang dapat magbawtiso kanakun!” ");
INSERT INTO krj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero nagsabat si Jesus kana, “Sa kadya nga tion himoa ang nagakadapat himuon, agud to nga matuman natun ang kabubut-un kang Dios.” Gani nga nagpasugot si Juan. ");
INSERT INTO krj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapos nga mabawtisohan si Jesus nagtakas tana sa tubig. Dayon nagbukas ang langit kag nakita na ang Balaan nga Ispirito nga nagakunsag nga daw pating kag nagtungtong kana. ");
INSERT INTO krj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kag may nabatian nga limug halin sa langit nga nagakuon, “Amo dya ang akun hinigugma nga Anak nga akun gid nahamut-an.” ");
INSERT INTO krj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatapos nga si Jesus nabawtisohan, gin-gamhan tana kang Balaan nga Ispirito kag gindara sa kamingawan para sulayun kang Yawa. ");
INSERT INTO krj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Rugto, wara gid si Jesus magkaun sa sulud kang kap-atan ka adlaw kag kap-atan ka gabii kag gin-gutum gid tana. ");
INSERT INTO krj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nag-abot ang Yawa kag nagkuon kay Jesus, “Kon ikaw ang Anak kang Dios, abi mandoi dyang mga bato nga mangin tinapay.” ");
INSERT INTO krj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero nagsabat si Jesus, “Nasulat sa kasulatan, ‘Ang tawo indi lamang sa pagkaun mabuhi kundi sa kada pulong nga ginahambal kang Dios.’” ");
INSERT INTO krj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapos kato, gindara tana kang Yawa sa Jerusalem nga amo ang Balaan nga syudad, kag ginpatindug sa pinakamataas nga bahin kang Templo. ");
INSERT INTO krj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nagkuon ang Yawa kana, “Kon matuod nga ikaw ang Anak kang Dios, abi paglumpat halin rugya kadya. Hay nasulat sa kasulatan, ‘Suguon kang Dios ang anang mga anghel nga amligan ikaw; pagasapnayun nanda ikaw agud to nga bisan ang imong kahig indi makabunggu sa bato.’” ");
INSERT INTO krj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nagsabat si Jesus kana, “Nasulat man sa kasulatan, ‘Indi mo pagsulayun ang Ginoo nga imo Dios.’” ");
INSERT INTO krj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dayon gindara pa gid kang Yawa si Jesus sa tama gid ka taas nga bukid kag ginpakita kana ang tanan nga mga ginharian sa kalibutan kag ang andang mga kagamhanan. ");
INSERT INTO krj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kag nagkuon ang Yawa kana, “Itugro ko kanimo ang tanan nga dya kon magaluhod ikaw kag simbahun ako.” ");
INSERT INTO krj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nagsabat si Jesus, “Parayu kanakun, Satanas! Hay nasulat sa kasulatan, ‘Simbahun mo ang Ginoo nga imo Dios kag tana gid lang ang imo alagadun!’” ");
INSERT INTO krj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amo to kag ginbayaan tana kang Yawa. Nag-abot ang mga anghel kag nag-atipan kana. ");
INSERT INTO krj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kar-on, kang mabatian ni Jesus nga napriso si Juan nga Manugbawtiso, nagbalik tana sa probinsya kang Galilea. ");
INSERT INTO krj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nag-abot tana sa banwa kang Nazaret pero wara tana magtiner rugto, kundi rugto tana nagtiner sa banwa kang Capernaum. Ang banwa nga dya, makita sa binit kang linaw kang Galilea nga sakup kang teritoryo kang Zabulon kag Neftali. ");
INSERT INTO krj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Natabo dya agud matuman ang ginkuon ni propeta Isaias: ");
INSERT INTO krj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ang teritoryo kang Zabulon kag teritoryo kang Neftali, sa binit kang baybayun kag sa pihak kang suba kang Jordan, sa lugar nga ginatawag Galilea nga ginaulian man kang mga bukun ti Judio! ");
INSERT INTO krj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ang mga tawo rugyan nga nadulman kang sala nakakita kang tuman nga kasanag. Ang kasanag nga dya nagapamanagbanag sa mga tawo nga nagakahadluk sa kamatayun tungud kang sala.” ");
INSERT INTO krj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Halin kato, nag-umpisa ka pangwali si Jesus nga nagakuon, “Hinulsuli ninyo kag talikdan ang inyong mga kasal-anan, hay ang ginharian kang langit marapit run lang mag-abot.” ");
INSERT INTO krj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kang nagapanaw si Jesus sa binit kang linaw kang Galilea, nakita na ang darwa ka magbugto nga mangingisda. Dya amo sanday Simon nga ginatawag Pedro kag si Andres nga anang bugto. Nagaladlad sanda kadya kang pukot sa linaw. ");
INSERT INTO krj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nagkuon si Jesus kananda, “Dali, sunod kamo kanakun hay tudloan ko kamo nga magpangdara kang mga tawo nga magsunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lagi-lagi ginbayaan nanda ang andang mga pukot kag magsunod kana. ");
INSERT INTO krj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nagpadayon si Jesus sa pagpanaw kag sa uruonhan nakita na pa gid ang darwa ka magbugto nga sanday Santiago kag Juan nga mga bata ni Zebedeo. Rugto sanda sa andang baruto nga nagapamuna kang andang pukot imaw kang andang tatay nga si Zebedeo. Gintawag sanda kadya ni Jesus nga magsunod kana. ");
INSERT INTO krj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kag lagi-lagi kato, ginbayaan nanda ang andang baruto kag ang andang tatay kag nagsunod sanda kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ginlibot ni Jesus ang bilog nga probinsya kang Galilea, nga nagapanudlo sa mga sinagoga. Nagpangwali tana kang Mayad nga Balita nahanungud sa pagginahum kang Dios, kag nagpang-ayad kang tanan nga sahi kang masakit kag balatian kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kag ang balita nahanungud kay Jesus naglapnag sa bilog nga Siria gani ginpangdara nanda kana ang tanan nga mga masakitun, kag ang mga nagaantos sa nagkalain-lain nga mga balatian, ang mga ginagamhan kang mga demonyo, ang mga kuyapun kag ang mga paralitiko. Ginpang-ayad sanda kadya ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tungud karia, duro nga mga tawo ang nagsurunod kana nga nagharalin pa sa Galilea, sa Decapolis, sa Jerusalem, sa Judea kag sa lugar sa pihak kang Jordan. ");
INSERT INTO krj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kang nakita ni Jesus ang duro nga mga tawo, nagtukad tana sa bakulod kag nagpungko rugto. Nagparapit kana ang ana nga mga disipulo ");
INSERT INTO krj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kag nag-umpisa tana kadya sa pagpanudlo kananda nga nagakuon: ");
INSERT INTO krj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bulahan ang mga nagakilala nga wara sanda ti may mahimo kon wara ang Dios, hay sanda kadya ang mapasakup sa ginharian kang langit! ");
INSERT INTO krj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bulahan ang mga nagapangasubu, hay pagalipayun sanda kang Dios! ");
INSERT INTO krj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bulahan ang mga mapainubusun, hay sanda kadya ang makabaton kang ginsaad kang Dios! ");
INSERT INTO krj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bulahan ang mga may bahul nga handum nga mangin matarung sa panuruk kang Dios, hay itugro kang Dios kananda ang andang ginahandum! ");
INSERT INTO krj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bulahan ang mga maluloy-on, hay pagakaloy-an man sanda kang Dios! ");
INSERT INTO krj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bulahan ang mga may putli ti tagipusuon, hay makita nanda ang Dios! ");
INSERT INTO krj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bulahan ang mga tawo nga nagapangita kang pamaagi nga mangin malinung ang tanan, hay sanda pagatawgun kang Dios nga anang mga kabataan! ");
INSERT INTO krj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bulahan ang mga ginahingabot tungud kang andang pagsunod sa kabubut-un kang Dios, hay sanda kadya ang mapasakup sa ginharian kang langit! ");
INSERT INTO krj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bulahan kamo kon insultohan kamo kang mga tawo kag hingaboton kag butang-butangan kang istorya nga malain kag bukun ti matuod tungud kang inyo pagsunod kanakun. ");
INSERT INTO krj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amo man kabay ria nga paghingabot ang naaguman kang mga propeta kato anay? Gani, magkalipay kamo kag magsinadya, tungud hay bahul nga padya ang ginaaman kaninyo kang Dios rugto sa langit. ");
INSERT INTO krj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kamo daw pareho kang asin nga kinahanglanun gid kang mga tawo. Pero kon ang asin maduraan run gani kang ana nga kapait, indi run gid dya mapapait liwan. Indi run dya mapuslan gani ginapilak run lang sa gwa kag lapakun kang mga tawo.” ");
INSERT INTO krj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamo daw pareho kang sulo nga nagasanag sa mga tawo nga indi mahimo nga indi makita pareho kang syudad nga napatindug sa ibabaw kang bakulod. ");
INSERT INTO krj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wara ti may nagasindi kang sulo kag ana man lang dya nga takluban, kundi nga ginabutang na dya sa turungtongan agud to nga masanagan ang tanan nga rugyan sa sulud kang balay. ");
INSERT INTO krj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gani, kinahanglan nga ipasigahun ninyo ang inyong sulo sa mga tawo agud to nga makita nanda ang inyo mayad nga mga binuhatan kag madayaw nanda ang inyo Amay sa langit.” ");
INSERT INTO krj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Indi kamo magpinsar nga nag-abot ako para himuon nga wara ti pulos ang Kasugoan ni Moises kag ang mga sinulat kang mga propeta. Wara ako mag-abot para himuon nga wara ti pulos ang mga ria kundi agud matuman ria tanan. ");
INSERT INTO krj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tandai gid ninyo dya. Madura man ang langit kag ang lupa, wara gid ti bisan sangka letra ukon pinakagamay nga pintok kang Kasugoan kang Dios ang mangin wara ti pulos hasta nga matuman dya tanan. ");
INSERT INTO krj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gani ang bisan sin-o man nga nagalapas kang pinakagamay nga bahin kang mga Kasugoan nga dya, kag nagatudlo sa iba sa paglapas man kadya, ria nga tawo amo ang mangin pinakanaba sa ginharian kang langit. Pero ang nagatuman tana sa kasugoan kag nagatudlo sa iba sa pagtuman karia, tana ang kabigun nga dungganun sa ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sugidan ko kamo, sarang lang kamo mapasakup sa ginharian kang langit kon ang inyo pagtuman sa kabubut-un kang Dios labaw pa sa pagtuman kang mga manunudlo kang Kasugoan kag kang mga Fariseo. ");
INSERT INTO krj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an, ‘Indi ikaw magpatay kang tawo, hay ang bisan sin-o man nga makapatay magapanabat sa hukmanan.’ ");
INSERT INTO krj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero kar-on nagakuon ako kaninyo, ang bisan sin-o nga nagaugut sa ana nga isigka-tawo magapanabat sa hukmanan, kag ang bisan sin-o nga nagapakalain sa ana nga isigka-tawo sa pagkuon kana, ‘Hoy, wara timo ti pulos’ pagadar-un sa pinakamataas nga hukmanan. Kag ang bisan sin-o nga nagakuon sa anang isigka-tawo, ‘Omang kaw’ sirilotan tana sa impyerno. ");
INSERT INTO krj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gani kon magdara ikaw kang imo nga haralad sa Dios sa altar kag nadumduman mo nga ang imo gali nga isigka-tawo naglain ang anang buut kanimo, ");
INSERT INTO krj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibayai anay ang imo nga haralad sa atubangan kang altar kag magpakighusay sa imo isigka-tawo kag magbalik kag ihalad ang imo nga haralad sa Dios. ");
INSERT INTO krj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kon may tawo nga mag-akusar kanimo, magpakighusay ikaw kana sa wara pa kamo makaabot sa hukmanan. Tungud hay kon rugto run gani kamo basi kon itugyan na ikaw sa howis kag itugyan ikaw kang howis sa gwardya kag isulud ikaw sa prisohan. ");
INSERT INTO krj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ginakuon ko kanimo, sigurado gid nga magapabilin ikaw sa sulud kang prisohan hasta nga maubos mo ka bayad ang tanan nimo nga pina. ");
INSERT INTO krj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an pa gid, ‘Indi kamo magpakighilawas.’ ");
INSERT INTO krj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nagakuon ako kaninyo, ang bisan sin-o nga nagaturuk sa bayi nga may pagkaibug nakasala tana kang pagpakighilawas sa anang panghuna-huna. ");
INSERT INTO krj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gani kon ang tuo nimo nga mata amo ang kabangdanan kang imong pagpakasala lokita ria kag itablug. Mas mayad pa nga madura ang sangka bahin kang imong lawas sangsa mag-antos ang bilog nimo nga lawas sa impyerno. ");
INSERT INTO krj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kag kon ang tuo nimo nga alima amo ang kabangdanan kang imong pagpakasala utda ria kag itablug. Mas mayad pa nga madura ang sangka bahin kang imo lawas sangsa mag-antos ang bilog nimo nga lawas sa impyerno. ");
INSERT INTO krj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an man, ‘Ang laki nga magabulag sa anang asawa, dapat magtugro sa anang asawa kang kasulatan kang pagbulaganay.’ ");
INSERT INTO krj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero nagakuon ako kaninyo, ang bisan sin-o nga magabulag sa anang asawa nga wara lang man nagapanginlaki, tana mismo ang mangin kabangdanan nga makasala ang anang asawa kang pagpanginlaki kon magpamana dya liwan. Kag ang bisan sin-o nga magpangasawa sa bayi nga ginbulagan kang anang bana nakasala man kang pagpanginbayi. ");
INSERT INTO krj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nagpadayon pa gid si Jesus sa pagpanudlo, ‘Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an, Indi mo paggub-un ang imong ginsumpaan, kundi tumanun mo gid ang imong ginsumpa sa Ginoo.’ ");
INSERT INTO krj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ginakuon ko kaninyo, kon magsaad gani kamo indi gid kamo magpanumpa. Indi gid kamo magpanumpa nga ginagamit ninyo nga saksi ang langit, hay amo ria ang trono kang Dios, ");
INSERT INTO krj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ukon magpanumpa nga ginagamit ninyo nga saksi ang lupa, hay amo dya ang turungtongan kang anang mga kahig, ukon magpanumpa nga ginagamit ninyo nga saksi ang Jerusalem, hay amo ria ang syudad kang gamhanan nga Hari. ");
INSERT INTO krj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Indi man ikaw magpanumpa nga ginagamit nimo nga saksi ang imo ulo, hay bisan sangka nahut kang imong buhok indi mo mapaputi ukon mapaitum. ");
INSERT INTO krj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Magkuon lang kamo nga ‘Huud’ kon ang buut ninyo hambalun ‘huud’ kag ‘Indi’ kon ang buut ninyo hambalun ‘indi’; ang bisan ano pa nga idugang ninyo dyan karia nagahalin run sa Malaot. ");
INSERT INTO krj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an, ‘Kon ginlokat mo ang mata kang imong isigka-tawo pagalukatun man ang imo mata, kag kon ginbingaw mo ang unto kang imong isigka-tawo pagabingawun man ang imong unto.’ ");
INSERT INTO krj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero amo tana dyaay ang akun ikuon kaninyo, indi kamo magbato sa mga tawo nga nagahimo kang malain kaninyo. Kon tampaun gani ikaw sa imong sampihak nga bagiing, itaya mo man ang sampihak. ");
INSERT INTO krj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kon may magdemanda kanimo sa tuyo nga bul-un na ang imong bayo, itugro mo man kana pati ang imong kunup. ");
INSERT INTO krj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kon may magpirit kanimo nga pas-anun ang anang karga sa karayuun nga sangka kilometro, pas-ana ria kang darwa ka kilometro. ");
INSERT INTO krj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kon may magpangayo kanimo tugroi tana, kag kon may maghuram kanimo pahurama. ");
INSERT INTO krj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Naman-an ninyo nga ang atun mga kaulangan kauna ginkun-an, ‘Palanggaa ang imo mga abyan kag kaugti ang imo mga kaaway.’ ");
INSERT INTO krj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nagakuon ako kaninyo, palanggaa ang inyo kaaway kag pangamuyoi ninyo ang mga nagahingabot kaninyo. ");
INSERT INTO krj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Himoa ninyo ria agud to nga mangin takus kamo nga pagatawgun nga anak kang inyo Amay sa langit. Tungud hay pareho na nga ginapasirak ang adlaw sa mga malain kag sa mga mayad nga mga tawo, kag parareho man lang nga ginatugroan na kang uran ang mga matarung kag ang mga bukun ti matarung. ");
INSERT INTO krj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kon ang ginahigugma ninyo amo man lang ang mga tawo nga nagahigugma man kaninyo, ti, ano bay nga padya ang mabuul ninyo halin sa Dios? Bisan gani kabay ang mga manugsukot kang buwis nagahimo man karia? ");
INSERT INTO krj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kag kon ang ginabugno ninyo ang inyo man lang mga abyan, ti, ano gid bay karia ang kinalain na sa ginahimo kang iba? Bisan gani ang mga tawo nga wara nakakilala sa Dios nagahimo man karia. ");
INSERT INTO krj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gani, kamo tana, kinahanglan nga mangin himpit pareho kang inyo Amay sa langit.” ");
INSERT INTO krj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nagpadayon pa gid si Jesus sa pagpanudlo kananda, “Mag-andam kamo sa inyo pagkarelihiyoso nga bukun ti pakita-kita lang sa mga tawo. Tungud hay kon nagapakita-kita lang kamo, wara gid kamo ti padya nga mabaton halin sa inyo Amay sa langit. ");
INSERT INTO krj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Gani, kon nagatugro kamo kang limos, indi ninyo dya pagpanugid-sugid sa bisan kay sin-o, pareho kang ginahimo kang mga hipokrito sa mga sinagoga kag sa mga dalan agud makita kang mga tawo ang andang ginahimo para dayawun sanda. Pero sa pagkamatuod lang tana, ginakuon ko kaninyo nga nabaton nanda run ang andang padya. ");
INSERT INTO krj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero kamo tana, kon nagatugro kamo kang limos, indi ninyo gid pagpamaan bisan sa pinakasuud ninyo nga amigo, ");
INSERT INTO krj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agud to wara ti may makamaan kang inyong ginahimo. Kag ang inyo Amay nga nakakita kang inyo ginahimo sa sikrito amo ang magapadya kaninyo. ");
INSERT INTO krj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kag kon magpangamuyo gani kamo, indi kamo magsunod sa mga ginahimo kang mga tawo nga hipokrito. Tungud hay kon magpangamuyo sanda gusto gid nanda magtindug sa mga sinagoga kag sa mga pamusod kang karsada agud to nga makita sanda kang mga tawo. Pero sa pagkamatuod lang tana, ginakuon ko kaninyo nga nabaton nanda run ang andang padya. ");
INSERT INTO krj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero kon magpangamuyo gani kamo, magsulud kamo sa inyo kwarto kag magpanirado. Rugto kamo magpangamuyo sa inyo Amay nga indi makita. Kag pagapadyaan kamo kang inyo Amay sa langit nga nakakita kang inyo ginahimo sa sikrito. ");
INSERT INTO krj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kag kon nagapangamuyo kamo, indi kamo magsagad liwan-liwan kang mga tinaga nga wara lang man ti pulos, pareho kang ginahimo kang mga tawo nga wara nakakilala sa Dios. Amo ria ang andang ginahimo tungud hay nagapinsar sanda nga pamatian sanda tungud hay lawid ang andang pangamuyo. ");
INSERT INTO krj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gani indi ninyo pagsunda ang andang ginahimo hay naman-an run kang inyo Amay ang inyo nga mga kinahanglanun sa wara pa kamo makapangayo kana. ");
INSERT INTO krj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kon magpangamuyo gani kamo, amo dyaay: Amay namun nga rugyan sa langit, kabay nga pakabalaanun ang imo Ngaran, ");
INSERT INTO krj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kabay nga mag-abot run ang tion kang imo paghari, kabay nga matuman ang imong pagbuut rugya sa lupa pareho nga ginatuman rugyan sa langit. ");
INSERT INTO krj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tugroi kami kang pagkaun nga amun kinahanglan sa kadya nga adlaw. ");
INSERT INTO krj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawara kami kang amun mga sala, pareho nga ginapatawad namun ang mga nakasala kanamun. ");
INSERT INTO krj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kag indi nimo pag-itugot nga madaug kami kang mga pagsulay, kundi luwasun mo kami sa Malaot. Ikaw gid lang ang Hari sa tanan, ikaw ang pinakagamhanan, kag kanimo ang tanan nga kahimayaan hasta sa wara ti katapusan. Amen. ");
INSERT INTO krj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kinahanglan gid man nga patawarun ninyo ang mga nakasala kaninyo, tungud hay kon patawarun ninyo pagapatawarun man kamo kang inyo Amay nga rugto sa langit. ");
INSERT INTO krj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero kon wara ninyo ginapatawad ang iba sa andang mga sala, indi man kamo pagpatawarun kang inyo Amay.” ");
INSERT INTO krj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nagkuon pa gid si Jesus, “Kon nagapuasa gani kamo, indi ninyo pagpasubua ang inyong itsora pareho kang ginahimo kang mga hipokrito. Nagalagaw sanda nga wara nakapanghilam-os kag wara nakapanghusay agud to nga maman-an kang tanan nga nagapuasa sanda. Sa pagkamatuod lang tana, ginakuon ko kaninyo nga nabaton nanda run ang andang padya. ");
INSERT INTO krj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero kon magpuasa gani ikaw, magpanghilam-os ikaw kag magpanghusay, ");
INSERT INTO krj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agud to nga wara ti may makamaan nga nagapuasa ikaw, luwas lang sa imo Amay nga indi makita. Kag tana nga nakakita kang imo nga ginahimo sa sikrito, amo ang magapadya kanimo. ");
INSERT INTO krj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Indi kamo magsuput kang manggad para sa inyo kaugalingun rugya sa kalibutan, nga sa diin ranggaun lang man kang mga tanak kag kang tuktuk, ukon sudlun kang takawan ang inyo balay kag takawun dya. ");
INSERT INTO krj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sa baylo, magsuput kamo kang manggad rugto sa langit, nga amo ang inyo nga mayad nga buhat, hay rugto sa langit wara ti tanak kag tuktuk nga magarangga karia, kag wara ti takawan nga makasulud para magpanakaw. ");
INSERT INTO krj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tungud hay kon sa diin ang inyo manggad rugto man ang inyo panghuna-huna.” ");
INSERT INTO krj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ang mata amo ang sulo kang lawas. Gani kon masanag ang imo panuruk, masanagan man ang bug-os nimo nga lawas. ");
INSERT INTO krj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero kon dulum ang imo panuruk, madulman man ang bug-os nimo nga lawas. Gani kon ang kasanag nga rugyan kanimo dulum gali, daw ano ayhan kadulum ang imo kahimtangan!” ");
INSERT INTO krj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wara ti tawo nga makaalagad kang dungan sa darwa ka agalun, hay ang matabo karia kaugtan na ang isara kag palanggaun na ang isara, ukon alagadun na kang husto ang isara kag ang isara tana tamayun na. Indi ninyo maalagad kang dungan ang Dios kag ang manggad. ");
INSERT INTO krj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Amo gani nga nagakuon ako kaninyo nga indi kamo magsagad ka palibug sa inyo pagpangabuhi; kon ano ang inyo ikan-un ukon imnun kag kon ano ang inyo isuksok para sa inyo lawas. Indi bala nga mas importante ang kabuhi sangsa pagkaun, kag ang lawas sangsa bayo? ");
INSERT INTO krj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Turuka bala ninyo ang mga pispis nga nagalupad-lupad. Wara sanda nagatanum kag wara man sanda nagaani, kag wara man sanda nagasuput sa kamarin, pero ang inyo Amay sa langit nagapakaun kananda. Indi bala nga mas importante pa kamo sangsa mga pispis? ");
INSERT INTO krj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sin-o haw kaninyo ang makadugang kang anang kabuhi kang bisan gamay lang paagi sa anang pagpalibug? ");
INSERT INTO krj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kag andut abi nga nagapalibug pa kamo sa inyo suruksukon? Turuka bala ninyo kon paano nagatubo ang mga bulak sa latagun. Wara sanda nagapangabudlay ukon nagahimo kang andang bayo. ");
INSERT INTO krj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero ginakuon ko kaninyo, bisan pa si Solomon nga bantog kag tama ka manggaranun nga hari, wara gid makabayo kang pareho kang katahum kang bisan isara lang sa mga bulak nga dya. ");
INSERT INTO krj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kon ginapatahum kang Dios ang mga hilamon nga rugyan sa latagun nga buhi kadya kag sa sunod nga mga adlaw idap-ong lang man sa darapogan, kamo pa ayhan ang indi na pagpabayoan? Mga gamay kamo ti pagtuo! ");
INSERT INTO krj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gani indi kamo magpalibug kag magkuon, ‘Ano bay ang atun ikan-un kadya?’ ukon ‘Ano bay ang atun imnun?’ ukon maghambal pa gid kamo, ‘Ano bay ang atun isuksukon?’ ");
INSERT INTO krj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tungud hay amo ria ang ginapaligban kang mga tawo nga wara makakilala sa Dios. Ang Amay ninyo sa langit nakamaan run tana nga kinahanglan ninyo ang ria nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ang inyo tana himuon, labi kag labaw sa tanan magpasakup kamo sa pagginahum kang Dios kag sa pagtuman kang anang kabubut-un, kag itugro na gid ang tanan ninyo nga mga kinahanglanun. ");
INSERT INTO krj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gani indi kamo magpalibug kang inyo mga kinahanglanun para sa rum-an, tungud hay ang rum-an may ana man kaugalingun nga paraligban. Indi ninyo run kinahanglan nga dugangan pa ang mga paraligban nga nagaabot sa kada adlaw.” ");
INSERT INTO krj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Indi ninyo paghusgaran ang inyo isigka-tawo, agud to nga indi man kamo paghusgaran kang Dios. ");
INSERT INTO krj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tungud hay kon paano ang paghusgar ninyo sa iba nga tawo amo man karia ang paghusgar kang Dios kaninyo, kag ang taraksan nga inyo gin-gamit sa paghusgar sa iba amo man ang pagagamitun kang Dios kaninyo. ");
INSERT INTO krj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ginamulalungan mo gid haw ang gamay nga puling sa mata kang imo isigka tawo, pero wara tana nimo ginasapak ang troso nga rugyan sa imo mata? ");
INSERT INTO krj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Paano ikaw makakuon sa imong isigka-tawo, ‘Bul-un ko ang imo nga puling,’ kon sa imo mismo nga mata may troso? ");
INSERT INTO krj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mga hipokrito! Bul-a anay ang troso nga rugyan sa imo mata, agud to nga makakita ikaw ka mayad kag mabuul mo ang puling sa mata kang imo isigka tawo. ");
INSERT INTO krj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Indi ninyo pag-itugro sa mga ayam ang mga butang nga para sa Dios, tungud hay basi balikdun nanda kamo kag ikadtun. Kag indi ninyo pag-ipilak ang inyo mga perlas sa mga baboy tungud hay basi lapak-lapakun lang nanda ria.” ");
INSERT INTO krj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Magpangayo kamo sa Dios kag mabaton ninyo ang inyo ginapangayo. Magpangita kamo kag makita ninyo ang inyo ginapangita. Magpanuktok kamo kag pagabuksan ang gawang para kaninyo. ");
INSERT INTO krj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tungud hay ang bisan sin-o nga nagapangayo makabaton, kag ang bisan sin-o nga nagapangita makakita, kag ang bisan sin-o nga nagapanuktok pagabuksan ang gawang para kana. ");
INSERT INTO krj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kamo nga mga ginikanan, kon magpangayo bala kang pagkaun ang inyo mga bata tugroan ayhan ninyo kang bato? ");
INSERT INTO krj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ukon, kon magpangayo sanda kang isda tugroan bala ninyo kang sawa? ");
INSERT INTO krj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ti, kon kamo gani nga mga malaot, kamaan magtugro kang mga mayad nga butang sa inyo mga bata, ano pa gid ayhan ang inyo Amay sa langit! Itugro na gid ang mga mayad nga butang sa mga nagapangayo kana. ");
INSERT INTO krj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gani, himoa ninyo sa inyo isigka-tawo ang gusto ninyo nga himuon nanda kaninyo. Amo dya ang kahulogan kang ginatudlo sa Kasugoan ni Moises kag kang mga sinulat kang mga propeta.” ");
INSERT INTO krj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Magsulud kamo sa sipot nga pwertahan, tungud hay ang wayang nga pwertahan kag ang malapad nga dalan nagapaagto sa impyerno, kag duro ang nagaaragi dyan karia. ");
INSERT INTO krj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero ang pwertahan kag dalan nga nagapaagto sa kabuhi nga wara ti katapusan masipot kag mabudlay, kag gamay lang ang nakamaan kang amo nga dalan.” ");
INSERT INTO krj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-andam kamo sa mga tawo nga nagapakuno-kuno nga mga propeta. Ria nga mga tawo kon turukun daw mga mabuut pareho kang karnero, pero ang matuod tana karia daw pareho sanda kang mga lobo nga mapintas. ");
INSERT INTO krj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makilala ninyo sanda paagi sa andang mga buhat. Pareho bala sa mga tanum, nagapamunga haw kang ubas ang sapinit, ukon ang mga talungon kang higera? ");
INSERT INTO krj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ang kahoy nga mayad nagapamunga kang mayad. Pero ang kahoy tana nga sayud, sayud man ang anang bunga. ");
INSERT INTO krj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ang mayad nga kahoy indi makapamunga kang sayud nga bunga, kag ang sayud nga kahoy indi makapamunga kang mayad nga bunga. ");
INSERT INTO krj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ang kahoy nga wara nagapamunga kang mayad nga bunga ginatapas kag ginatablug sa kalayo. ");
INSERT INTO krj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Amo gani nga ang mga tawo nga nagapakuno-kuno nga mga propeta, makilala ninyo paagi sa andang mga buhat.” ");
INSERT INTO krj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bukun ti tanan nga mga tawo nga nagapanawag kanakun nga, ‘Ginoo, Ginoo namun,’ ang makapasakup sa ginharian kang langit, kundi ang mga tawo lang nga nagatuman sa kabubut-un kang akun Amay sa langit. ");
INSERT INTO krj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sa adlaw kang paghukum duro ang magakuon kanakun, ‘Ginoo, Ginoo namun, paagi sa imo ngaran nagpangwali kami kang imo pulong, nagapanabog man kami kang mga demonyo paagi sa imo ngaran, kag naghimo kang duro nga mga katingalahan nga mga butang paagi sa imo ngaran.’ ");
INSERT INTO krj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero amo dyaay ang isabat ko kananda, ‘Wara ako makakilala kaninyo. Parayu kamo kanakun, kamo nga nagahimo kang kalaotan!’” ");
INSERT INTO krj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Gani, ang bisan sin-o nga nagapamati kag nagatuman kang akun mga ginapanudlo nga dya, pareho tana kang tawo nga maaram nga nagpatindug kang anang balay nga ang pundasyon bato. ");
INSERT INTO krj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nagbunuk ang uran, nagbaha ang suba, kag nagwaswas ang mabaskug nga hangin sa balay, pero ang balay wara gid maiwan, tungud hay ginpatindug dya nga ang pundasyon na bato. ");
INSERT INTO krj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero ang tawo tana nga nakabati kang akun mga ginpanudlo, ogaring wara na pagtumana, pareho tana kang tawo nga mango nga nagpatindug kang anang balay sa baras. ");
INSERT INTO krj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nagbunuk ang uran, nagbaha ang suba, kag nagwaswas ang mabaskug nga hangin sa balay, narumpag dya kag sobra gid ang pagkawasdak na kadya.” ");
INSERT INTO krj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos hambal ni Jesus kang dya nga mga butang sa mga tawo, natingala gid sanda sa anang pagpanudlo, ");
INSERT INTO krj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tungud hay nagpanudlo tana nga may awtoridad, kag bukun ti pareho kang mga manunudlo kang Kasugoan. ");
INSERT INTO krj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kang makadulhog si Jesus sa bakulod, duro nga mga tawo ang nagsurunod kana. ");
INSERT INTO krj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dayon, may sangka aruon nga nagparapit kag nagluhod sa anang atubang. Nagkuon dya, “Sir, kon gustohon mo, mapaayad mo ako kag himuon nga limpyo suno sa kasugoan.” ");
INSERT INTO krj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Gintandug tana ni Jesus kag ginhambalan, “Gusto ko. Maayad ikaw kag mangin limpyo!” Lagi-lagi nag-ayad ang tawo sa anang balatian. ");
INSERT INTO krj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kag nagkuon si Jesus kana, “Indi gid ikaw magpanugid sa bisan kay sin-o, kundi agto ikaw sa pari kag magpalantaw kana. Dayon maghalad ikaw kang haralad suno sa sugo ni Moises bilang pagpamatuod sa tanan nga ayad run ikaw.” ");
INSERT INTO krj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kang nagapasulud si Jesus sa banwa kang Capernaum, ginsug-alaw tana kang sangka kapitan kang suldado nga Romanhun, kag nagpakitluoy dya kana nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sir, ang akun surugoon nagamasakit rugto sa balay. Nagabatang lang tana kag indi makahulag kag tam-an gid ang ana nga pag-antos.” ");
INSERT INTO krj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nagkuon si Jesus kana, “Sige, agtunan ko tana kag ayadun.” ");
INSERT INTO krj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nagsabat ang Kapitan kana, “Sir, indi ako takus magpasulud kanimo sa akun balay. Hambal lang ikaw kag magaayad ang akun surugoon. ");
INSERT INTO krj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ako mismo sa idalum kang awtoridad kang mga opisyal, kag may mga suldado man sa idalum kang akun awtoridad. Kon maghambal gani ako sa isara nga, ‘panaw to’, mapanaw man tana. Kon magkuon pa gid ako sa isara nga, ‘agto rugya’ maagto man tana rugya. Kag sa akun oripun tana kon magkuon ako kana nga, ‘himoa dya’, ginahimo na man.” ");
INSERT INTO krj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkabati karia ni Jesus natingala gid tana. Kag naghambal tana sa mga tawo nga nagasurunod kana, “Sugidan ko kamo, wara pa gid ako ti may nakita nga tawo sa Israel nga amo dya kabahul ang anang pagtuo. ");
INSERT INTO krj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sugidan ko kamo, duro nga mga tawo nga magahalin sa sidlangan kag kasalpan ang magakaun imaw kay Abraham, Isaac, kag Jacob sa punsyon sa ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero ang mga tawo tana nga amo raad ang napasakup sa ginharian kang Dios pagatablug sa sagwa, rugto sa madulum nga lugar nga sa diin nagahinibi sanda kag nagabinagrut ang andang mga unto.” ");
INSERT INTO krj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nagkuon si Jesus sa kapitan, “Uli run, matuman ang imo ginatuohan.” Kag sa amo gid to nga tion nag-ayad ang surugoon kang kapitan. ");
INSERT INTO krj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nag-agto si Jesus sa balay ni Pedro. Kag rugto nakita na ang ogangan ni Pedro nga bayi nga nagabatang kag may hilanat. ");
INSERT INTO krj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gintandug ni Jesus ang ana alima, kag nag-ayad tana sa anang hilanat. Nagbangon tana kag maghimus kang pagkaun para kana. ");
INSERT INTO krj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kang sirum run, duro nga mga tawo nga nasab-an kang mga demonyo ang ginpangdara kay Jesus. Ginpangtabog na ang mga malaot nga ispirito paagi sa paghambal na lang, kag ang tanan nga mga masakitun ginpang-ayad na. ");
INSERT INTO krj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ginhimo na dya agud to nga matuman ang ginkuon ni propeta Isaias, “Ginbuul na ang atun mga masakit, kag gin-ayad na ang atun mga balatian.” ");
INSERT INTO krj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kang makita ni Jesus nga duro nga mga tawo ang nagatiriripon sa anang palibot, ginsugo na ang anang mga disipulo nga magtabok sanda sa pihak kang linaw. ");
INSERT INTO krj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dayon may sangka manunudlo kang kasugoan ang nagparapit kana kag nagkuon, “Maestro, maimaw ako kanimo bisan diin ikaw maagto.” ");
INSERT INTO krj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nagkuon si Jesus kana, “Ang mga singgarong may mga buho nga ginaistaran kag ang mga pispis may mga pugad, pero ang Anak kang Tawo wara gid ti balay nga ana mapahuwayan.” ");
INSERT INTO krj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","May sangka disipulo si Jesus nga nagkuon, “Sir, mauli anay ako sa pagpalubung kang akun tatay.” ");
INSERT INTO krj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nagsabat sa Jesus kana, “Imaw ikaw kanakun kag pabay-i ang mga patay nga maglubung kang anda mga patay.” ");
INSERT INTO krj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nagsakay si Jesus sa baruto, kag nag-imaw kana ang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Samtang nagapanakayun sanda, golpi lang nagbagyo kang mabaskug sa may linaw, kag daw malunod ang andang baruto tungud kang daragkul nga mga balud. Pero si Jesus tana nagakaturog. ");
INSERT INTO krj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ginparapitan tana kang anang mga disipulo kag ginpukaw, “Ginoo, luwasa kami! Malunod kita!” ");
INSERT INTO krj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nagsabat si Jesus kananda, “Andut haw nga nahadluk gid kamo? Mga gamay kamo ti pagtuo.” Dayon nagbangon tana kag ginmandoan ang hangin kag ang mga balud nga mag-untat. Kag nagkanay dayon. ");
INSERT INTO krj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Natingala gid sanda tanan kag nagkuon, “Ano tana nga klase kang tawo dya man nga bisan ang hangin kag ang mga balud nagatuman kana?” ");
INSERT INTO krj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagtabok nanda sa pihak kang linaw, rugto sa lugar nga sakup kang Gadara, ginsug-alaw si Jesus kang darwa ka tawo nga naghalin sa mga rulubngan. Ang darwa nga dya ginasab-an kang mga demonyo. Mapintas sanda kamayad, gani nga wara gid ti may nagapangahas nga mag-agi rugto. ");
INSERT INTO krj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nagsinggit sanda kay Jesus, “Ikaw nga Anak kang Dios, ano ang imo labut kanamun? Nag-agto bala ikaw rugya agud nga silotan kami bisan wara pa mag-abot ang nagakaigo nga tion?” ");
INSERT INTO krj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Rugto sa oroonahan ayon may panung kang mga baboy nga nagakaraun. ");
INSERT INTO krj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gani nagpakitluoy kay Jesus ang mga demonyo nga nagakuon, “Kon tabugon mo gid man kami, rugto run lang kami pasudla sa mga baboy.” ");
INSERT INTO krj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nagkuon si Jesus kananda, “Sige, panaw kamo!” Gani naggwa sanda sa darwa ka tawo kag nagsulud sa mga baboy. Nagdinagusu ang mga baboy paagto sa pil-as diretso sa tubig kag nagkaralumus. ");
INSERT INTO krj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ang mga manugsagod kang mga baboy nagdaralagan paagto sa banwa kag nagpanugid kang tanan nga natabo kag sa natabo man sa darwa ka tawo nga ginsab-an kang demonyo. ");
INSERT INTO krj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gani ang tanan nga mga tawo sa banwa nag-agto kay Jesus, kag pagkakita nanda kana nagpakitluoy sanda nga maghalin tana sa andang lugar. ");
INSERT INTO krj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nagsakay liwan si Jesus sa baruto, kag nagbalik sa pihak kang linaw, kag nag-uli sa anang kaugalingun nga banwa. ");
INSERT INTO krj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kag rugto may mga tawo nga nagdara kana kang sangka paralitiko nga nagabatang sa anang baratangan. Kang makita ni Jesus kon daw ano kabahul ang andang pagtuo kana, nagkuon tana sa paralitiko, “To, magpakabakud ikaw, ang imo mga sala ginpatawad run!” ");
INSERT INTO krj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kar-on, ang mga manunudlo kang kasugoan nagkuon sa andang mga kaugalingun, “Ang dya nga tawo ginapasipalahan na ang Dios.” ");
INSERT INTO krj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naman-an ni Jesus kon ano ang andang ginapinsar, gani nagkuon tana kananda, “Andut haw nga nagapinsar kamo kang malain? ");
INSERT INTO krj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Diin haw ang mas hapus, ang magkuon nga, ‘Ginpatawad run ang imo mga sala,’ ukon ang magkuon nga, ‘Magtindug ikaw kag magpanaw?’ ");
INSERT INTO krj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kar-on pamatod-an ko kaninyo nga ang Anak kang Tawo may awtoridad rugya sa lupa sa pagpatawad kang mga sala.” Dayon nagkuon tana sa paralitiko, “Tindug, dar-a ang imo baratangan kag mag-uli.” ");
INSERT INTO krj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nagbangon dayon ang tawo kag nag-uli. ");
INSERT INTO krj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkakita kang mga tawo ka dya, hinadlukan sanda kag gindayaw nanda ang Dios tungud hay nagtugro tana kang amo karia nga awtoridad sa tawo. ");
INSERT INTO krj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Naghalin si Jesus sa lugar nga to, kag samtang nagapanaw tana, may nakita tana nga sangka manugsukot kang buwis nga ang anang ngaran si Mateo nga nagapungko sa may ginabaydan kang buwis. Nagkuon si Jesus kana, “Dali, sunod ikaw kanakun.” Nagtindug si Mateo kag nagsunod kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Samtang nagakaun si Jesus kag ang anang mga disipulo sa balay ni Mateo, duro nga mga manugsukot kang buwis kag mga makasasala ang nag-abot kag nag-imaw kaun kananda. ");
INSERT INTO krj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nakita dya kang mga Fariseo. Gani ginpamangkot nanda ang anang mga disipulo, “Andut nga nagaimaw kaun ang inyo Maestro sa mga tawo nga dya?” ");
INSERT INTO krj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nabatian dya ni Jesus, kag ginsabat na sanda paagi sa sangka paanggid, “Ang tawo nga mayad ang anang lawas wara nagakinahanglan kang doktor, kundi nga ang mga nagamasakit lang. ");
INSERT INTO krj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Osisaa ninyo kon ano ang buut hambalun kang ginakuon sa kasulatan nga, ‘Bukun ti ang inyo mga halad ang akun gusto, kundi ang inyo kaluoy sa isara kag isara.’ Wara ako nag-abot rugya sa pagtawag sa mga matarung, kundi sa mga makasasala.” ");
INSERT INTO krj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","May mga sumurunod si Juan nga Manugbawtiso nga nag-agto kay Jesus kag nagpamangkot, “Kami kag ang mga Fariseo permi nagapuasa, pero andut nga ang imo mga disipulo wara nagapuasa?” ");
INSERT INTO krj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nagsabat si Jesus kananda paagi sa paanggid, “Magapangasubu ayhan ang mga bisita samtang imaw pa nanda ang nobyo? Siyempre indi! Pero magaabot ang tion nga ang nobyo pagabul-un kananda kag amo run ria ang pagpuasa nanda.” ");
INSERT INTO krj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Wara ti may nagalunub kang bag-o nga tela sa daan nga bayo, tungud hay ang bag-o nga tela magakuru kag mas magabahul pa gid ang gisi kang daan nga bayo. ");
INSERT INTO krj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kag wara man ti nagabutang kang bag-o nga bino sa daan nga surudlan nga panit. Tungud hay kon himuon na dya mabusdik ang surudlan kag mauyang ang bino, kag ang surudlan indi run mapuslan. Sa baylo, ang bag-o nga bino ginasulud sa bag-o nga surudlan nga panit, sa amo karia ang bino kag ang surudlan magalawid.” ");
INSERT INTO krj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Samtang nagahambal pa si Jesus, nag-abot ang sangka manugdumara kang sinagoga. Nagluhod dya sa atubang ni Jesus kag nagkuon, “Ang akun bata nga bayi bag-o gid lang napatay, pero kon agtonan mo tana kag itungtong ang imong alima kana, mabuhi tana liwan.” ");
INSERT INTO krj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nagtindug si Jesus kag nag-imaw kana. Nag-imaw man ang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Samtang nagapanaw sanda, may bayi nga nagparapit sa likod ni Jesus kag nagtandug kang anang kunup. Ang bayi nga dya ginadugo sa sulud kang napulo'g darwa ka tuig. ");
INSERT INTO krj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nagkuon ang bayi sa anang kaugalingun, “Kon matandug ko lang ang anang kunup, magaayad gid ako.” ");
INSERT INTO krj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nagliso si Jesus kag pagkakita na sa bayi nagkuon tana, “Inday, magpakabakud ikaw! Ang imo pagtuo amo ang nag-ayad kanimo.” Kag ang bayi nag-ayad dayon. ");
INSERT INTO krj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kang pag-abot ni Jesus sa balay kang manugdumara, nakita na ang mga musikero para sa lubung kag ang mga tawo nga nagagirinahud. ");
INSERT INTO krj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nagkuon tana sa mga tawo, “Gorowa kamo! Bukun ti patay ang bata, nagakaturog lang.” Ginkadlawan nanda tana. ");
INSERT INTO krj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kang napagwa run ang mga tawo, nagsulud si Jesus sa kwarto kang bata. Ginkaptan na ang alima kang bata kag nagbangon dya. ");
INSERT INTO krj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kag ang balita nahanungud sa dya nga hitabo naglapnag sa tanan nga lugar sa ria nga banwa. ");
INSERT INTO krj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Naghalin si Jesus sa lugar nga to, kag samtang nagapanaw tana, may darwa ka bulag nga nagasunod kana nga nagasinggit, “Kaliwat ni David, kaluoyi man kami!” ");
INSERT INTO krj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kang pagsulud ni Jesus sa balay, nag-agto kana ang darwa ka bulag. Ginpamangkot sanda ni Jesus, “Nagapati bala kamo nga mapaayad ko kamo?” Nagsabat sanda, “Huud, sir nagapati kami!” ");
INSERT INTO krj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dayon gintandug ni Jesus ang anda mga mata kag nagkuon, “Matuman ang inyo ginatuohan.” ");
INSERT INTO krj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kang makakita run sanda. Ginpaandaman gid sanda ni Jesus nga nagakuon, “Indi gid ninyo dya pagpanugid sa bisan kay sin-o.” ");
INSERT INTO krj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero nagpanaw sanda kag ginpanugid sa bilog nga lugar ang mga ginhimo ni Jesus kananda. ");
INSERT INTO krj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pagkalumbos lang gid nanda, may gindara kay Jesus nga sangka tawo nga apa tungud hay nasab-an dya kang demonyo. ");
INSERT INTO krj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kang napagwa run ni Jesus ang demonyo, makahambal run ang apa. Natingala gid ang mga tawo kag nagkuon sanda, “Halin pa kauna wara gid kita ti may nakita nga pareho kadya sa bilog nga Israel.” ");
INSERT INTO krj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ang mga Fariseo tana nagkuon, “Ang pangulo kang mga demonyo amo ang nagtugro kana kang gahum sa pagpanabog kang mga demonyo.” ");
INSERT INTO krj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Naglibot si Jesus sa tanan nga mga kabanwahanan kag mga kabaryohanan. Nagpanudlo tana sa mga sinagoga, kag nagpangwali kang Mayad nga Balita nahanungud sa paghari kang Dios, kag nagpang-ayad kang mga tawo nga may nagkalain-lain nga mga masakit kag balatian. ");
INSERT INTO krj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kang makita na ang duro nga mga tawo, naluoy gid tana kananda tungud nga nabudlayan gid sanda kamayad kag wara ti may nagabulig kananda. Pareho sanda kang mga karnero nga wara ti manugbantay. ");
INSERT INTO krj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gani nagkuon tana sa anang mga disipulo, “Duro ang aranyun, pero gamay lang ang manug-ani. ");
INSERT INTO krj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Gani magpangamuyo kamo sa tag-iya kang aranyun nga magpadara tana kang mga manug-ani sa pag-ani kang anang aranyun.” ");
INSERT INTO krj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Gintawag ni Jesus ang napulo'g darwa na ka mga disipulo kag gintugroan na sanda kang awtoridad sa pagtabog kang mga malaot nga ispirito, kag sa pag-ayad kang bisan ano nga klase kang masakit kag balatian. ");
INSERT INTO krj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amo dyaay ang mga ngaran kang napulo'g darwa ka mga apostoles: una, si Simon (nga ginatawag Pedro), si Andres nga anang bugto, ang darwa ka mga bata ni Zebedeo nga sanday Santiago kag Juan, ");
INSERT INTO krj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe kag si Bartolome, si Tomas kag si Mateo (nga manugsukot kang buwis), si Santiago nga bata ni Alfeo, kag si Tadeo, ");
INSERT INTO krj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon (nga mapinalanggaun sa anang nasyon), kag si Judas Iscariote nga amo ang nagtraidor kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ang napulo'g darwa ka mga apostoles nga dya ginpapanaw ni Jesus kag ginbilinan nga, “Indi kamo mag-agto sa lugar kang mga bukun ti Judio ukon sa banwa kang mga Samaritanhun, ");
INSERT INTO krj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","sa baylo agto kamo sa mga katawhan kang Israel, tungud hay kaangay sanda kang mga karnero nga nagtalang. ");
INSERT INTO krj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panaw kamo kag iwali kananda nga, ‘Marapit run lang mag-abot ang ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ayada ninyo ang mga nagamarasakit, buhia ninyo ang mga patay, ang mga aruon ayada man ninyo, kag taboga ninyo ang mga demonyo. Nakabaton kamo nga wara ti bayad, gani magtugro man kamo nga indi magpabayad. ");
INSERT INTO krj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Indi kamo magbalon kang bulawan, ukon pilak, ukon saway nga kwarta sa inyo nga bulsa. ");
INSERT INTO krj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Indi man kamo magdara kang bag, ukon irislan nga bayo, ukon sandalyas, ukon sungkod. Tungud hay ang manugpangabudlay nagakabagay lang nga tugroan kang anang mga kinahanglanun. ");
INSERT INTO krj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mag-abot gani kamo sa sangka banwa ukon baryo, magpangita kamo kang tawo nga maalwan sa pagbaton kaninyo, kag magtiner kamo rugto hasta nga maghalin kamo sa ria nga lugar. ");
INSERT INTO krj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagsulud ninyo sa balay, kun-on ninyo ang mga tawo, ‘Kabay nga pakamayadun kamo kang Dios.’ ");
INSERT INTO krj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kon abi-abihun kamo kang ria nga panimalay, pakamayadun sanda karia kang Dios, pero kon indi, bawia ninyo ang inyo ginhambal kananda. ");
INSERT INTO krj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kon may panimalay ukon banwa nga indi gid magbaton kaninyo ukon indi magpamati kang inyo ginakuon, halin kamo sa ria nga lugar, kag tataka ninyo ang yab-ok sa inyo kahig. ");
INSERT INTO krj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sugidan ko kamo, sa adlaw kang paghukum ang silot nga anda maaguman mas sobra pa sa silot nga maaguman kang mga taga-Sodoma kag mga taga-Gomora.” ");
INSERT INTO krj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pamatii ninyo dyaay! Kamo ginapaagto ko sa mga tawo nga mapintas, pareho kang mga karnero sa tunga kang mga lobo. Gani mangin maaram kamo pareho kang mga sawa, kag malulo pareho kang mga pating. ");
INSERT INTO krj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-andam kamo, hay may mga tawo nga magadakup kaninyo kag magadara kaninyo sa hukmanan; kag pagahanuton nanda kamo sa andang mga sinagoga. ");
INSERT INTO krj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tungud kanakun pagadar-un nanda kamo kag pagapaatubangun sa mga gobernador kag mga hari, kag rugto magasugid kamo kang Mayad nga Balita kananda kag sa mga bukun ti Judio. ");
INSERT INTO krj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kon ginausisa run nanda kamo, indi kamo magpalibug kon ano ang inyo ihambal, ukon paano ninyo ihambal. Tungud hay sa pag-abot kang tion nga ria, pagatudloan kamo kon ano ang inyo ihambal. ");
INSERT INTO krj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tungud hay ang inyo igahambal indi kaninyo magahalin, kundi ang Ispirito kang inyo Amay amo ang magahambal paagi kaninyo. ");
INSERT INTO krj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“May mga tawo nga magaloib sa anda mga bugto para ipapatay. May mga tatay nga amo man ria ang andang himuon sa andang mga bata. Kag may mga bata nga magakontra sa andang mga ginikanan, kag ipapatay nanda sanda. ");
INSERT INTO krj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaugtan kamo kang tanan nga tawo tungud kanakun. Pero ang bisan sin-o tana nga magapadayon nga mapag-un hasta sa katapusan amo tana ang maluwas. ");
INSERT INTO krj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kon hingaboton kamo kang mga tawo sa sangka banwa, magpalagyo kamo paagto sa sangka banwa. Sugidan ko kamo, indi ninyo matapos ang inyo mga buruhatun sa tanan nga mga banwa kang Israel kag ang Anak kang Tawo magabalik. ");
INSERT INTO krj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wara ti istudyante nga labaw pa sa anang maestro, kag wara ti oripun nga labaw pa sa anang agalun. ");
INSERT INTO krj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gani tuman run sa istudyante nga mangin pareho sa anang maestro, kag sa oripun nga mangin pareho sa anang agalun. Kon ang nagapangulo sa panimalay ginatawag nanda nga Beelzebul, ano pa gid ayhan kalain ang andang itawag sa anang mga sumurunod.” ");
INSERT INTO krj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gani indi kamo magkahadluk sa mga tawo. Tungud hay wara ti tinago nga indi makita, kag wara ti sekreto nga indi maman-an. ");
INSERT INTO krj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ang mga butang nga akun ginasugid kaninyo kon kitahanun lang, isugid ninyo sa tanan. Kag ang mga butang nga akun ginahani-hani kaninyo, ibantala ninyo sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Indi kamo magkahadluk sa mga tawo nga nagapatay kang lawas pero indi makapatay kang kalag. Ang Dios amo ang dapat ninyo kahadlukan, tungud nga tana gid lang ang makalaglag kang lawas kag kang kalag sa impyerno. ");
INSERT INTO krj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Indi bala nga barato lang ang pispis nga maya? Pero wara ti bisan isara kananda ang mahulog sa lupa kon indi pag-itugot kang inyo Amay. ");
INSERT INTO krj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kon parte tana kaninyo, bisan pa gani ang inyo buhok naisip na run dya tanan. ");
INSERT INTO krj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gani indi kamo magkahadluk, tungud hay labing bilidhun pa kamo sangsa duro nga mga maya.” ");
INSERT INTO krj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ang bisan sin-o nga nagasugid sa atubang kang duro nga mga tawo nga tana nagatuo kanakun, pagakilalahun ko man tana sa atubang kang akun Amay sa langit. ");
INSERT INTO krj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ang bisan sin-o tana nga nagapanginwara nga nagatuo tana kanakun sa atubang kang duro nga mga tawo, ipangiwara ko man sa atubang kang akun Amay sa langit.” ");
INSERT INTO krj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Indi kamo magpinsar nga nag-abot ako rugya sa kalibutan agud magdara kang kalinung. Wara ako mag-abot rugya agud magdara kang kalinung, kundi nga pag-irinaway. ");
INSERT INTO krj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nag-agto ako rugya agud nga ang mga bata nga laki magakontra sa andang mga tatay, ang mga bata nga bayi magakontra sa andang mga nanay, kag amo man sa mga manugang nga bayi magakontra man sa andang ogangan nga bayi. ");
INSERT INTO krj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ang mangin kontra kang sangka tawo amo mismo ang katapo kang ana kaugalingun nga panimalay. ");
INSERT INTO krj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ang bisan sin-o nga nagapalangga kang anang tatay ukon kang anang nanay labaw pa sangsa kanakun indi takus para mangin akun disipulo. Kag ang bisan sin-o nga nagapalangga kang anang bata nga laki ukon bayi labaw pa sangsa kanakun indi takus para mangin akun disipulo. ");
INSERT INTO krj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ang bisan sin-o nga indi magpas-an kang anang kros kag magsunod kanakun indi takus para mangin akun disipulo. ");
INSERT INTO krj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ang tawo nga ginatipigan na ang anang kabuhi, maduraan tana kadya. Pero ang tawo tana nga wara nagatipig kang anang kabuhi tungud kanakun, amo ang makaangkun kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ang bisan sin-o nga nagabaton kaninyo nagabaton man kanakun. Kag ang nagabaton kanakun nagabaton man sa nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ang bisan sin-o nga nagabaton kang propeta kang Dios tungud hay tana sangka propeta kang Dios, magabaton kang padya nga para sa propeta. Kag ang nagabaton kang matarung nga tawo tungud hay tana sangka matarung nga tawo, magabaton kang padya nga para sa matarung nga tawo. ");
INSERT INTO krj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kag ang bisan sin-o nga magatugro kang bisan sangka baso lang nga tubig sa isara sa akun mga kubus nga sumurunod tungud hay tana akun sumurunod, ginasiguro ko gid kaninyo nga ria nga tawo magabaton gid kang padya.” ");
INSERT INTO krj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos ni Jesus ka tugro kang dya nga mga bilin sa anang napulo'g darwa ka mga disipulo, naghalin tana sa lugar nga ria kag nag-agto sa palibot nga mga banwa agud magtudlo kag magpangwali. ");
INSERT INTO krj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sa amo to nga mga tinion si Juan nga Manugbawtiso rugto sa prisohan. Kang nabatian na ang mga ginapanghimo ni Cristo, ginpaagto na ang anang mga disipulo kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Namangkot sanda kay Jesus, “Ikaw bala ang amun ginapaabot ukon mapaabot pa kami kang iba?” ");
INSERT INTO krj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nagsabat si Jesus, “Balik kamo kay Juan kag isugid kana ang inyong nakita kag nabatian nga ");
INSERT INTO krj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ang mga bulag makakita run, ang mga piang makapanaw run, ang mga aruon naayad run, ang mga bungul makabati run, ang mga patay nabuhi liwan, kag ang Mayad nga Balita ginawali run sa mga imol. ");
INSERT INTO krj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bulahan ang tawo nga wara nagapangduha-duha kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagkalumbos kang mga ginsugo ni Juan, naghambal si Jesus sa mga tawo nahanungud kay Juan, “Kato anay kang mag-agto kamo kay Juan rugto sa kamingawan, ano ang ginapaabot ninyo nga makita? Kugon bala nga ginahapay-hapay kang hangin? ");
INSERT INTO krj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ano bay ang gin-agto ninyo rugto nga gusto ninyo nga makita? Tawo bala nga nagabayo kang marahalun? Ang tawo tana nga nagabayo kang marahalun rugto lang makita sa palasyo! ");
INSERT INTO krj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sugidi ninyo ako, ano gid ang gin-agto ninyo rugto nga gusto ninyo makita? Propeta bala? Igsakto gid kamo, kag sobra pa gani sa propeta ang inyo nakita. ");
INSERT INTO krj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tungud hay si Juan amo ang ginatumud sa kasulatan nga kuon kang Dios, ‘Magapadara ako kang akun manugbalita nga magauna kanimo, agud nga mag-aman kang imo dalan.’ ");
INSERT INTO krj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sugidan ko kamo, sa tanan nga mga tawo rugya sa kalibutan, wara pa gid ti may makalabaw kay Juan nga Manugbawtiso. Pero ang pinakakubus tana sa ginharian kang langit amo lamang ang labaw kay Juan. ");
INSERT INTO krj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Halin kang pagpangwali ni Juan nga Manugbawtiso hasta tulad ang ginharian kang langit pirit nga ginaagaw kang mga tawo nga mapintas. ");
INSERT INTO krj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tungud hay sa wara pa mag-abot si Juan, ang tanan nga mga propeta kag ang kasugoan nagatudlo run nahanungud sa ginharian kang Dios. ");
INSERT INTO krj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kag kon patihan ninyo ang anda mga ginasugid, si Juan amo si Elias nga gintagna nga magaabot. ");
INSERT INTO krj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gani kamo nga nagaparamati, intiendiha ninyo ka mayad ang inyo nabatian. ");
INSERT INTO krj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kar-on, sa ano ko ayhan mapaanggid ang mga tawo sa kadya nga panahon? Daw pareho sanda kang mga bata nga nagapurungko sa tindahan. Ang sangka grupo nagasinggit sa iba nga, ");
INSERT INTO krj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Gintokaran namun kamo kang masadya nga sonata, pero wara kamo magsaot! Ginkantahan namun kamo kang kanta nga para sa patay, pero wara man kamo magpanangis!’ ");
INSERT INTO krj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tungud hay kang pag-abot ni Juan, nagpuasa tana kag wara nag-inum kang bino, kag nagkuon ang mga tawo nga, ‘Ginagamhan tana kang demonyo.’ ");
INSERT INTO krj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kar-on, kang pag-abot kang Anak kang Tawo, nagakaun dya kag nagainum, kag nagkuon ang mga tawo nga, ‘Turuka ninyo ang tawo nga dyaay, dalok tana kag parainum kang bino, amigo tana kang mga manugsukot kang buwis kag iba pa nga mga makasasala.’ Pero ang kaaram kang Dios mapamatod-an nga igsakto paagi sa anang mga resulta kadya.” ");
INSERT INTO krj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pagkatapos kadya, ginsukmaan ni Jesus ang mga tawo sa banwa nga sa diin naghimo tana kang duro nga mga milagro tungud nga wara sanda maghinulsul kang anda mga sala. ");
INSERT INTO krj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Nagkuon tana, “Makaluluoy gid kamo nga mga taga Corazin! Makaluluoy man kamo nga mga taga Betsaida! Tungud hay kon ang mga milagro nga ginpanghimo rugyan kaninyo, ginhimo rugto sa syudad kang Tiro kag Sidon, buhay run daad sanda nagbayo kang sako kag nagbutang kang abo sa andang ulo, patimaan nga sanda naghinulsul sa andang mga sala. ");
INSERT INTO krj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero sugidan ko kamo: sa adlaw kang paghukum ang silot nga inyo maaguman sobra pa sa maaguman kang mga taga-Tiro kag mga taga-Sidon. ");
INSERT INTO krj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kag kamo tana nga taga-Capernaum, nagapinsar bala kamo nga bayawun kamo sa langit? Pagatablug kamo sa impyerno! Tungud hay kon ang mga milagro nga ginhimo kaninyo, ginhimo rugto sa Sodoma, hasta kadya ang Sodoma rugyan pa daad! ");
INSERT INTO krj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sugidan ko kamo, sa adlaw kang paghukum ang silot nga inyo maaguman sobra pa sa maaguman kang mga taga-Sodoma.” ");
INSERT INTO krj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kag sa amo to nga tion, nagkuon si Jesus, “Amay, Ginoo kang langit kag lupa, nagapasalamat ako kanimo hay ang mga butang nga wara nimo ginpahayag sa mga tawo nga maaram kag may tinon-an, ginpahayag nimo sa mga tawo nga wara ti tinon-an. ");
INSERT INTO krj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nagapasalamat gid ako, Amay, tungud nga amo dya ang imo kabubut-un.” ");
INSERT INTO krj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nagkuon si Jesus sa mga tawo, “Ang tanan nga mga butang gintugyan kanakun kang akun Amay. Wara ti bisan sin-o nga nakakilala sa Anak magluwas lang sa Amay, kag wara man ti may nakakilala sa Amay magluwas lang sa Anak kag sa mga tawo nga pinili kang Anak nga ipahayag ang Amay.” ");
INSERT INTO krj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tanan kamo nga ginabudlayan kag ginabug-atan, parapit kamo kanakun hay pagapapahuwayun ko kamo. ");
INSERT INTO krj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magpasakup kamo kag magpatudlo kanakun, hay malulo ako kag mabuut, kag makapahuway kamo. ");
INSERT INTO krj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tungud hay ang akun mga sugo mahapus tumanun, kag bukun ti budlay ang akun ginapahimo.” ");
INSERT INTO krj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sangka Adlaw kato nga Inugpahuway, nakaagi sanday Jesus sa katrigohan. Ang anang mga disipulo nagutum, gani nga nagpangutul sanda kang mga uhay kang trigo kag magkinaun. ");
INSERT INTO krj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkakita kadya kang mga Fariseo nagkuon sanda kay Jesus, “Turuka ang ginahimo kang imo mga disipulo, Adlaw kadya nga Inugpahuway gani supak ria sa atun kasugoan ang anda ginahimo.” ");
INSERT INTO krj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nagsabat kananda si Jesus, “Wara gid ninyo haw mabasahi sa kasulatan kon ano ang ginhimo kato anay ni David kag kang anang mga tinawo kang gin-gutum sanda? ");
INSERT INTO krj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nagsulud tana sa balay kang Dios kag ginkaun imaw kang anang mga tinawo ang tinapay rugto nga nahalad sa Dios bisan pa nga supak dya sa kasugoan, tungud nga ang mga pari lang ang ginatugotan nga magkaun kang tinapay nga to. ");
INSERT INTO krj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kag wara man bala ninyo mabasahi sa kasugoan ni Moises nga ang mga pari mismo sa templo nagasupak man sa kasugoan nahanungud sa Adlaw nga Inugpahuway, pero wara sanda nakasala? ");
INSERT INTO krj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sugidan ko kamo, may rugya nga labaw pa sangsa templo. ");
INSERT INTO krj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kag kon naintiendihan ninyo daad ang ginakuon sa kasulatan nga, ‘Bukun ti ang inyo mga halad ang akun gusto, kundi ang inyo kaluoy sa isara kag isara’, kundi nga wara raad ninyo ginahusgaran ang mga tawo nga wara ti sala. ");
INSERT INTO krj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tungud hay ang Anak kang Tawo amo ang may gahum sa Adlaw nga Inugpahuway.” ");
INSERT INTO krj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naghalin si Jesus rugto, kag nag-agto sa sinagoga. ");
INSERT INTO krj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","May sangka tawo rugto nga kimay ang sambangi na nga alima. May mga tawo man rugto nga nagapangita kang paagi agud to nga maakusar nanda si Jesus. Gani ginpamangkot nanda tana, “Ginatugot bala kang kasugoan ang pagpang-ayad kang mga masakitun sa Adlaw nga Inugpahuway?” ");
INSERT INTO krj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nagsabat si Jesus kananda, “Abi kon may karnero kamo nga nahulog sa buho sa Adlaw nga Inugpahuway, indi ayhan ninyo pagbul-un ria? ");
INSERT INTO krj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas importante pa tana ang tawo sangsa karnero. Gani nga ginatugot kang kasugoan ang pagbulig sa atun isigka tawo sa Adlaw nga Inugpahuway.” ");
INSERT INTO krj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Amo to kag nagkuon tana sa tawo nga may kimay nga alima, “Untaya ang imo alima!” Gin-untay man kang tawo nga to ang anang alima, kag nag-ayad dya, kag nangin pareho run kang sa pihak na nga alima. ");
INSERT INTO krj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dayon naggurowa ang mga Fariseo kag nagplano sanda kon paano nanda patyun si Jesus. ");
INSERT INTO krj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero naman-an ni Jesus ang andang plano, gani naghalin tana sa lugar nga to. Duro nga mga tawo ang nagsurunod kana kag ginpang-ayad na ang tanan nga mga masakitun, ");
INSERT INTO krj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kag ginpaandaman na sanda nga indi magpanugid sa iba nahanungud kana. ");
INSERT INTO krj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ginhimo na dya agud to nga matuman ang ginkuon kang Dios paagi kay propeta Isaias: ");
INSERT INTO krj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Amo dya ang akun alagad, nga akun gid pinili, palangga ko gid tana, kag nahamuut gid ako kana. Pagamhun ko kana ang akun Ispirito, kag ipahayag na sa tanan nga mga tawo ang akun paghukum. ");
INSERT INTO krj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Indi tana magpakigbais ukon magsinggit, ukon maghambal kang matunog sa tunga kang dalan. ");
INSERT INTO krj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Indi na pagbariun ang nabuyok run nga kugon, kag indi na man pagpalungon ang daw mapatay run nga sulo. Indi tana mag-untat hasta nga ang katarungan magdaug, ");
INSERT INTO krj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","kag ang tanan nga mga tawo kana magalaum.” ");
INSERT INTO krj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kar-on, may gindara kay Jesus nga sangka tawo nga bulag kag apa hay ginagamhan dya kang demonyo. Gin-ayad ni Jesus ang tawo kag lagi-lagi makahambal run tana kadya kag makakita run. ");
INSERT INTO krj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ang mga tawo rugto natingala gid sa ginhimo ni Jesus, kag nagkuon sanda, “Tana run ayhan ang kaliwat ni Haring David?” ");
INSERT INTO krj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagkabati kang mga Fariseo karia, nagkuon sanda, “Ang pangulo kang demonyo nga si Beelzebul amo ang nagtugro kana kang gahum agud matabog na ang mga demonyo.” ");
INSERT INTO krj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero naman-an ni Jesus ang andang mga ginahuna-huna, gani nga nagkuon tana kananda, “Kon ang sangka pungsod magbinahin-bahin kag mag-irinaway, dya nga pungsod indi magbuhay kag mapukan. Kag kon ang sangka banwa ukon panimalay magbinahin-bahin kag mag-irinaway, magaburublag man sanda. ");
INSERT INTO krj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Gani nga kon ang mga sinakpan ni Satanas magbinahin-bahin kag mag-irinaway, ang anang ginharian indi magbuhay kag mapukan. ");
INSERT INTO krj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nagahambal kamo nga nagapanabog ako kang mga demonyo tungud nga si Beelzebul amo ang nagtugro kanakun kang gahum. Ti sin-o tana bay ang nagtugro kang gahum sa inyo mga sumurunod sa pagpanabog kang mga demonyo? Sanda run gid mismo ang magapamatuod nga sayup gid kamo! ");
INSERT INTO krj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ang Ispirito kang Dios amo ang nagatugro kanakun kang gahum sa pagpanabog kang mga demonyo, kag dya nagapamatuod lang nga magahari run ang Dios kaninyo.” ");
INSERT INTO krj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kag naghambal pa gid si Jesus, “Wara ti bisan sin-o nga basta lang magsulud sa balay kang sangka mapurus nga tawo kag ipamul-un ang mga pagkabutang na kadya kon indi na anay pag-igapuson ang tagbalay nga to. Kag kon mahimo na run gani dya, amo run to ang pagpamuul na kang tanan nga pagkabutang sa balay nga to. ");
INSERT INTO krj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ang bisan sin-o nga wara nagadampig kanakun nagakontra kanakun, kag ang wara nagabulig kanakun sa pagpanipon, nagaparapta lang dya. ");
INSERT INTO krj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Gani sugidan ko kamo: mapatawad ang mga tawo sa bisan ano nanda nga sala kag pagpasipala batok sa Dios. Pero ang bisan sin-o tana nga magpasipala sa Balaan nga Ispirito indi pagpatawarun. ");
INSERT INTO krj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kag ang bisan sin-o nga maghambal kang malain batok sa Anak kang Tawo sarang pa mapatawad. Pero ang bisan sin-o tana nga maghambal kang malain batok sa Balaan nga Ispirito indi mapatawad sa dya nga panahon kag hasta san-o. ");
INSERT INTO krj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kon ang sangka kahoy nami, nami man ang bunga na kadya; kag kon ang sangka kahoy sayud, sayud man ang ana nga bunga. Tungud nga ang kahoy makilala paagi sa anang bunga. ");
INSERT INTO krj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mga sawa kamo! Paano bay kamo makahambal kang mga mayad nga butang hay mga malaot kamo. Tungud nga kon ano ang rugyan sa tagipusuon kang tawo amo man ang nagagwa sa ana nga ba-ba. ");
INSERT INTO krj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ang tawo nga mayad nagahimo kang mga mayad nga butang tungud nga mayad man ang sulud kang anang tagipusuon. Pero ang tawo tana nga malaot, mga malaot man nga mga butang ang ana ginahimo tungud nga malaot man ang sulud kang anang tagipusuon. ");
INSERT INTO krj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Sugidan ko kamo, sa adlaw kang paghukum ang kada isara magapanabat kang anang ginpanghambal nga wara ti pulos. ");
INSERT INTO krj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tungud hay ang imo ginpanghambal amo ang pagagamitun sa paghusgar kanimo kon pagasilotan ikaw ukon indi.” ");
INSERT INTO krj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kar-on may mga manunudlo kang kasugoan kag mga Fariseo nga nagkuon kay Jesus, “Maestro, pakitai kami kang sangka milagro.” ");
INSERT INTO krj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nagsabat si Jesus kananda, “Ang mga tawo sa kadya nga panag-on tama gid ka malaot kag nagtalikod sanda sa Dios. Nagapangayo kamo nga pakitaan ko kamo kang milagro, pero wara ti igapakita kaninyo magluwas lang sa pareho kang makatiringala nga natabo kay Propeta Jonas. ");
INSERT INTO krj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kon paano nga si Jonas tatlo ka adlaw kag tatlo ka gabii sa busong kang bahul-bahul nga isda, amo man ria ang matabo sa Anak kang Tawo nga magapabilin sa rulubngan kang tatlo ka adlaw kag tatlo ka gabii. ");
INSERT INTO krj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa adlaw kang paghukum ang mga taga-Ninive magatindug sa pag-akusar kaninyo. Tungud hay kato anay kang mabatian kang taga-Ninive ang mga ginpangwali ni Jonas naghinulsul sanda sa anda mga kasal-anan. Kadya tana, kaimaw run gid ninyo ang labaw sangsa kay Jonas. ");
INSERT INTO krj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa adlaw kang paghukum ang reyna kang Seba magatindug sa pag-akusar kaninyo. Tungud hay tana gani nga naghalin pa sa marayu nga lugar, nag-agto sa pagpamati sa ginapanudlo kang maaram nga Hari nga si Solomon. Kadya tana, kaimaw run gid ninyo ang labaw sangsa kay Solomon.” ");
INSERT INTO krj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nagpadayon si Jesus sa paghambal kananda, “Kon ang malaot nga ispirito maggwa sa tawo, nagalagaw-lagaw dya sa mara nga lugar sa pagpangita kang ana maistaran. Kon wara tana ti may makita, ");
INSERT INTO krj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","makuon tana sa ana kaugalingun, ‘Mabalik run lang ako sa balay nga akun ginaistaran anay.’ Sa ana nga pagbalik makita na dya nga wara ti may nagaistar, limpyo kag hipid. ");
INSERT INTO krj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gani mapanaw tana kadya kag magdara pa gid kang pito ka mga ispirito nga mas malain pa sangsa kana. Magasulud sanda kag mag-istar rugto. Gani ang mangin kahimtangan kang tawo nga to mas sobra pa gid sangsa kauna. Amo man dya ang matabo sa mga malain nga tawo sa kadya nga panag-on.” ");
INSERT INTO krj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Samtang nagahambal pa si Jesus sa mga tawo, nag-abot ang ana nanay kag ana mga bugto. Nagahulat sanda sa sagwa kag gusto raad nanda nga magpakig-istorya kana.  ");
INSERT INTO krj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","May sangka tawo nga nagkuon kana, “Ang imo nanay kag mga bugto nagahulat kanimo rugto sa sagwa. Gusto raad nanda magpakig-istorya kanimo.”  ");
INSERT INTO krj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nagsabat si Jesus, “Naman-an mo bala kon sin-o ang akun nanay kag kon sin-o ang akun mga bugto?” ");
INSERT INTO krj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dayon gintudo na ang ana mga disipulo, “Dya sanda amo ang akun nanay kag mga bugto! ");
INSERT INTO krj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tungud hay ang bisan sin-o nga nagahimo kang kabubut-un kang akun Amay sa langit amo dya ang akun bugto nga laki, bugto nga bayi kag nanay.” ");
INSERT INTO krj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sa amo man to nga adlaw naggwa si Jesus sa balay kag mag-agto sa binit kang linaw, kag rugto nagpungko tana para magpanudlo. ");
INSERT INTO krj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tama gid kaduro nga mga tawo ang nagadurugok kana, gani nga nagsakay tana sa baruto kag rugto nagpungko, samtang ang mga tawo tana nagatirindug sa daray-ahan. ");
INSERT INTO krj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nagpanudlo tana sa mga tawo kang duro nga mga butang paagi sa mga paraanggidan. Nagkuon tana, “May sangka mangungoma nga nag-agto sa anang uma sa pagsab-og kang binhi. ");
INSERT INTO krj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa pagsab-og na kadya, may mga binhi nga nagturupa sa may aragyan. Nagdarapo ang mga pispis kag ginpanuka nanda dya. ");
INSERT INTO krj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ang iba tana nga mga binhi rugto nagturupa sa may batohon nga bahin kang taramnan sa diin nabaw lang ang lupa. Nanubo dya dayon, tungud hay manabaw lang ang lupa. ");
INSERT INTO krj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero kang nasirakan kang adlaw, nalayung lang man dya kag tungud nga wara makapanggamot kamayad nauga dya. ");
INSERT INTO krj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ang iba ruman tana nga mga binhi rugto nagturupa sa ginatuboan kang mga sapinit. Nanubo ang mga sapinit kag ginlumus na ang mga tanum. ");
INSERT INTO krj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero ang iba tana nga mga binhi nagturupa sa manami nga lupa kag nagpamunga. Ang iba kadya nakapang-uhay kang sangka gatos, ang iba kan-uman, kag ang iba tana katloan.” ");
INSERT INTO krj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gani kamo nga nagaparamati, intiendiha ninyo kamayad ang inyo nabatian. ");
INSERT INTO krj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dayon nagparapit kay Jesus ang ana mga disipulo kag nagpamangkot sanda kana, “Andut haw nga nagagamit ikaw kang paraanggidan sa pagpanudlo kananda?” ");
INSERT INTO krj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nagsabat si Jesus, “Ginpahangup run kaninyo ang mga sekreto nahanungud sa ginharian kang langit, pero kananda tana wara. ");
INSERT INTO krj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tungud hay ang tawo nga may ana run nga ginaangkun pagatugroan pa gid kag pabuganaun pa gid dya gani. Pero sa tawo tana nga wara ti may ginaangkun, pagabul-un pa gani kana ang bisan gamay nga rugyan kana. ");
INSERT INTO krj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Amo gani nga nagahambal ako kananda paagi sa mga paraanggidan, tungud hay bisan nagaturuk sanda indi man angud sanda makakita kag bisan nagapamati sanda indi man angud sanda makabati ukon makahangup. ");
INSERT INTO krj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gani natuman kananda ang ginkuon anay kang Dios paagi kay propeta Isaias nga, ‘Magsagad man kamo ka pamati, indi man angud kamo makahangup, kag magsagad man kamo ka turuk, indi man angud kamo makakita. ");
INSERT INTO krj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tungud hay mga maawut ti ulo ang mga tawo nga dya, kag ginapalapos lang nanda sa pihak nga talinga ang anda nabatian kag ginpirung nanda ang anda mga mata. Kon wara nanda dya ginhimo, kundi nga makakita raad sanda, kag makabati, kag makahangup, kag magdangup daad sanda kanakun kag aydun ko sanda.’” ");
INSERT INTO krj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nagpadayon pa gid si Jesus sa paghambal kananda, “Pero kamo tana, bulahan gid tungud hay makakita kamo kag makabati. ");
INSERT INTO krj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sugidan ko kamo, duro nga mga propeta kag matarung nga mga tawo ang naghandum gid nga makita ang inyo nakita, pero wara nanda dya makita, kag naghandum nga mabatian ang inyo nabatian, pero wara nanda dya mabatii.” ");
INSERT INTO krj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nagpadayon si Jesus sa pagkuon, “Gani pamatii ninyo kag hangpun kon ano ang buut hambalun kang paraanggidan nahanungud sa manugsab-og kang binhi. ");
INSERT INTO krj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ang tawo nga nakabati kang mensahe nahanungud sa paghari kang Dios pero wara na dya mahangpi, pareho dya kang binhi nga nagtupa sa aragyan. Nag-abot ang yawa kag ginpamuul dayon ang mensahe nga ginsab-og sa anang tagipusuon. ");
INSERT INTO krj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ang binhi tana nga nagtupa sa batohon nga bahin kang taramnan pareho kang tawo nga kang pagkabati na kang mensahe, ginbaton na dya dayon nga may kalipay. ");
INSERT INTO krj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ogaring wara gid dya magtuduk sa anang tagipusuon, gani nga wara tana nagpadayon. Pag-abot kang mga kalalat-an kag mga paghingabot tungud nga nagpati tana sa mensahe, dayon na lang man talikod sa anang pagtuo. ");
INSERT INTO krj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ang binhi ruman tana nga nagtupa sa ginatuboan kang mga sapinit pareho kang tawo nga nakabati kang mensahe. Ogaring ang anang panghuna-huna natuon gid lang sa mga paraligban sa pagpangabuhi kag sa paghanggab sa manggad, kag amo dya ang nagdaug kang mensahe nga rugyan run sa anang tagipusuon gani wara gid dya makapamunga. ");
INSERT INTO krj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kag ang binhi tana nga nagtupa sa manami nga lupa pareho kang tawo nga nakabati kang mensahe kag ginhangup na gid dya. Nagpamunga dya, kag ang iba nakapang-uhay kang sangka gatos, ang iba kan-uman, kag ang iba katloan.” ");
INSERT INTO krj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nagpadayon pa gid si Jesus sa pag-istorya sa mga tawo paagi sa paraangidan, “Ang ginharian kang langit pareho ka dyaay: may sangka tawo nga nagsab-og kang manami nga sahi kang binhi sa anang uma. ");
INSERT INTO krj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sangka gabii, samtang ang mga tawo nagakaturog, nag-abot ang anang kaaway kag nagsab-og kang mga liso kang hilamon sa katrigohan, kag maghalin. ");
INSERT INTO krj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kang nagpanubo run ang mga tanum kag nagpamunga, nakita nga may mga hilamon man nga naggurowa. ");
INSERT INTO krj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ang mga surugoon kang tawo nag-agto kana kag magkuon, ‘Sir, indi bala nga manami man nga sahi kang binhi ang imo ginpasab-og sa imong uma? Diin tana maghalin ang mga hilamon nga dya? ");
INSERT INTO krj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nagsabat tana, Kaaway ang naghimo kadya.’ Dayon namangkot ang mga surugoon kana, ‘Gusto bala nimo nga panggabuton namun ang mga hilamon?’ ");
INSERT INTO krj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nagsabat tana kananda, ‘Indi, hay basi magabot man ninyo pati ang mga trigo. ");
INSERT INTO krj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabay-i lang ninyo nga magtubo sanda imaw kang trigo hasta nga mag-abot ang tag-arani. Kag kon aranyun run gani, ikun-on ko ang mga manug-ani nga unahun nanda ka tipon ang mga hilamon, ibugkusun nanda dya kag sunugon. Ang mga trigo tana tiponon nanda kag ibutang sa akun kamarin.’” ");
INSERT INTO krj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nagpadayon pa gid si Jesus sa pagpanudlo sa mga tawo paagi sa paraanggidan, “Ang ginharian kang langit pareho kang sangka liso kang mustasa nga gintanum kang sangka tawo sa anang uma. ");
INSERT INTO krj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ang liso kang mustasa amo ang pinakagamay sa tanan nga liso. Pero kon manubo run gani dya, mangin pinakabahul dya sa tanan nga mga tanum kag mangin pareho kang kahoy, gani nga ang mga pispis nagapamugad sa mga sanga na kadya.” ");
INSERT INTO krj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nagpanudlo ruman si Jesus sa mga tawo paagi sa sangka paraanggidan, “Ang ginharian kang langit pareho kang tapay nga ginsamo kang sangka bayi sa tatlo ka sukub nga harina hasta nga ang bug-os nga ginmasa nga harina maghabok.” ");
INSERT INTO krj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ginhambal ni Jesus sa mga tawo ang tanan nga dya paagi sa mga paraanggidan. Wara gid tana nagahambal kananda nga wara tana nagagamit kang paraanggidan. ");
INSERT INTO krj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ginhimo na dya para matuman ang ginkuon kang Dios paagi sa anang propeta: “Magahambal ako kananda paagi sa mga paraanggidan. Isugid ko kananda ang mga butang nga wara pa gid mapahayag halin pa kang pagtuga kang kalibutan.” ");
INSERT INTO krj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos kato, ginbayaan ni Jesus ang mga tawo kag magsulud sa balay. Nagsunod man kana ang anang mga disipulo kag nagkuon kana, “Isugid abi kanamun kon ano ang buut hambalun kang paraanggidan nahanungud sa hilamon sa uma.” ");
INSERT INTO krj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nagsabat si Jesus, “Ang tawo nga nagsab-og kang manami nga sahi kang binhi wara ti liwan kundi ang Anak kang Tawo. ");
INSERT INTO krj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kag ang uma tana amo ang kalibutan. Ang manami nga sahi kang binhi amo ang mga tawo nga napasakup sa paghari kang Dios. Ang mga hilamon tana amo ang mga tawo nga sakup Malaot. ");
INSERT INTO krj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kag ang kaaway nga nagsab-og kang mga hilamon amo ang Yawa. Ang tag-arani amo ang katapusan kang kalibutan, kag ang mga mangangani amo ang mga anghel. ");
INSERT INTO krj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pareho nga ang hilamon gin-gabot kag ginsunog, amo man kadya ang matabo sa katapusan kang kalibutan: ");
INSERT INTO krj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ang Anak kang Tawo magapadara kang anang mga anghel para tiponon kag pagaw-un halin sa anang ginharian ang tanan nga nagahimo kang malaot kag ang tanan nga nangin kabangdanan kang pagpakasala kang iba, ");
INSERT INTO krj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kag sanda kadya pagatablug sa nagadaba-daba nga kalayo. Kag rugto magaparanangisun sanda kag magabinagrut ang andang mga unto. ");
INSERT INTO krj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ang mga matarung tana magasirak pareho kang adlaw rugto sa ginharian kang andang Amay. Gani kamo nga nagaparamati, intiendiha ninyo kamayad ang inyo nabatian.” ");
INSERT INTO krj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nagpadayon pa gid si Jesus sa paghambal kananda, “Ang ginharian kang langit pareho kang manggad nga nalubung sa uma. Nasapwan dya kang sangka tawo kag ang ginhimo na gintampukan na dya liwan. Sa anang kalipay, nag-uli tana kag ginbaligya ang tanan na nga pagkabutang kag ginbakal ang uma nga to.” ");
INSERT INTO krj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ang ginharian kang langit pareho kang sangka negosyante nga nagapangita kang pinasahi nga mga perlas, ");
INSERT INTO krj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","kag kang makakita tana kang sangka pinasahi nga perlas, nag-uli tana kag ginbaligya ang tanan na nga pagkabutang kag ginbakal ang perlas nga to.” ");
INSERT INTO krj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ang ginharian kang langit pareho pa gid ka dyaay: may mga mangingisda nga nagladlad kang pukot sa dagat kag nakadakup sanda kang nanari-sari nga mga isda. ");
INSERT INTO krj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kang mabuta ang pukot ginbutung nanda dya pabinit sa daray-ahan kag nagpurungko sanda sa pagpamili kang mga isda. Ang mga manami nga isda ginabutang nanda sa surudlan kag ang mga sayud tana ginpamilak nanda. ");
INSERT INTO krj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pareho man kadya ang matabo sa katapusan kang kalibutan. Magaabot ang mga anghel para painun ang mga tawo nga malaot sa mga tawo nga matarung. ");
INSERT INTO krj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ang mga tawo nga malaot igatablug sa nagadaba-daba nga kalayo. Kag rugto magaparanangisun sanda kag magabinagrut ang andang mga unto.” ");
INSERT INTO krj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ginpamangkot sanda ni Jesus, “Nahangpan bala ninyo ang tanan nga mga butang nga dya?” Nagsabat sanda kana, “Huud!” ");
INSERT INTO krj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nagkuon tana kananda, “Gani ang kada manunudlo kang kasugoan nga natudloan nahanungud sa ginharian kang langit daw pareho tana kang tagbalay nga nagapagwa kang daan kag bag-o nga pagkabutang sa anang taragoan.” ");
INSERT INTO krj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapos nga mahambal ni Jesus ang mga paraanggidan nga dya naghalin tana sa lugar nga to. ");
INSERT INTO krj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nag-uli tana sa anang kaugalingun nga banwa. Nagpanudlo tana sa sinagoga, kag ang mga nakabati kana natingala gid. Nagpamangkotanay sanda, “Sa diin tana nagbuul kang kaaram nga ria kag kang gahum sa paghimo kang mga milagro? ");
INSERT INTO krj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Indi bala nga ahaw bata lang man ria kang panday? Indi bala nga si Maria ang ana nanay kag ang mga bugto na nga laki amo sanday Santiago, Jose, Simon, kag si Judas? ");
INSERT INTO krj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kag indi bala nga rugya man nagaistar ang anang mga bugto nga bayi? Sa diin na bala tana naman-an ang tanan nga dya?” ");
INSERT INTO krj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wara sanda magpati kana. Nagkuon si Jesus kananda, “Ang propeta ginatahod bisan diin magluwas lang sa anang kaugalingun nga banwa kag kang anang pamilya.” ");
INSERT INTO krj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amo ria nga wara tana maghimo kang duro nga mga milagro rugto tungud hay wara sanda ti pagtuo kana. ");
INSERT INTO krj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sa amo to nga mga inadlaw, nabatian ni Herodes nga manugdumara kang Galilea ang balita nahanungud kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Gani nagkuon tana sa anang mga opisyal, “Tana amo gid si Juan nga Manugbawtiso nga nabuhi liwan. Amo ria nga may gahum tana sa paghimo kang mga milagro.” ");
INSERT INTO krj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ginkuon dya ni Herodes tungud hay kato anay tana ang nagpadakup kay Juan nga Manugbawtiso, kag ana dya ginpapriso. Ginhimo na dya tungud kay Herodias nga asawa kang anang bugto nga si Felipe. ");
INSERT INTO krj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tungud hay makapira ka beses nga ginkun-an ni Juan si Herodes, “Supak sa kasugoan nga pangasaw-un mo si Herodias.” ");
INSERT INTO krj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gusto raad nga ipapatay ni Herodes si Juan, ogaring nahadluk tana sa mga tawo tungud hay ginakabig nanda si Juan nga sangka propeta. ");
INSERT INTO krj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kang pag-abot kang kaadlawan ni Herodes, ang bata nga bayi ni Herodias nagsaot sa atubang kang mga dinapit nga bisita kag nalipay gid ka mayad si Herodes. ");
INSERT INTO krj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Amo to kag nagsaad si Herodes nga itugro na ang bisan ano nga pangayuon na kadya. ");
INSERT INTO krj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gintudloan tana kang anang nanay kon ano ang anang pangayuon, gani nagkuon dya sa hari, “Itugro kanakun kadya dayon ang ulo ni Juan nga Manugbawtiso nga nakabutang sa bandihado.” ");
INSERT INTO krj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagkabati kato kang Hari nasubuan gid tana. Pero tungud kang anang promisa nga nabatian kang anang mga bisita, nagmando tana nga itugro kana ang anang ginapangayo. ");
INSERT INTO krj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Amo to kag ginpapugotan na si Juan sa prisohan. ");
INSERT INTO krj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gindara ang ulo ni Juan nga nabutang sa bandihado kag gintugro sa bayi, kag gintugro na man dya sa anang nanay. ");
INSERT INTO krj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nag-abot ang mga disipulo ni Juan, kag ginbuul nanda ang anang bangkay kag ginlubung. Pagkatapos, nag-agto sanda kay Jesus kag ginsugid nanda ang natabo. ");
INSERT INTO krj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kang nabatian ni Jesus ang natabo kay Juan, naghalin tana rugto kag nagsakay sa baruto, kag nag-agto sa mamingaw nga lugar nga nagaisarahanun. Pero kang naman-an dya kang mga tawo, nagsunod sanda kana nga nagapanaw lang halin sa andang mga kabanwahanan. ");
INSERT INTO krj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagdungka ni Jesus sa daray-ahan nakita na ang tama gid ka duro nga mga tawo. Nangir-o tana kananda kag ginpang-ayad na ang andang mga ginadara nga mga nagamarasakit. ");
INSERT INTO krj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kang nagahinalup run ang adlaw, nagparapit kana ang anang mga disipulo kag nagkuon, “Sirum run kag mamingaw pa dya nga lugar. Papanawa run ang mga tawo agud to nga makabakal sanda kang andang pagkaun dyan sa mga baryo.” ");
INSERT INTO krj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero nagsabat si Jesus kananda, “Indi kinahanglan nga magpanaw pa sanda. Kamo ang magtugro kananda kang andang makaun.” ");
INSERT INTO krj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nagsabat sanda, “Lima gid lang kabilog nga tinapay kag darwa ka isda ang rugya.” ");
INSERT INTO krj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nagkuon si Jesus kananda, “Abi dar-a ninyo rugya kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dayon ginkun-an na ang mga tawo nga magpurungko sa kahilamonan. Ginbuul na ang lima ka tinapay kag ang darwa ka isda; nagtangra tana sa langit kag magpasalamat sa Dios. Dayon ginpamihak-pihak na ang tinapay kag ginpanugro sa anang mga disipulo, kag ginpanagtag dya kang mga disipulo sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakakaun sanda tanan kag nagkarabusog. Pagkatapos kato, ginpanipon kang mga disipulo ang mga nabilin kag napulo'g darwa ka alat nga buta ang andang natipon. ");
INSERT INTO krj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mga lima ka libo nga laki ang nakakaun wara ti labut ang mga bayi kag mga bata. ");
INSERT INTO krj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lagi-lagi, ginsugo ni Jesus ang anang mga disipulo nga magsarakay sa baruto kag mag-una rugto sa tabok kang linaw samtang ginapahalin na ang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kang mapahalin na run ang mga tawo, nagtukad si Jesus sa barabakulod nga nagaisarahanun agud magpangamuyo. Kang gabii run, rugto man gihapon tana nga nagaisarahanun. ");
INSERT INTO krj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sa amo man to nga mga tinion ang baruto rugto run sa lawud nga ginaburobalinsay kang balud tungud hay pasurong dya sa hangin. ");
INSERT INTO krj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kang kasanagun run nag-agto kananda si Jesus nga nagapanaw sa tubig. ");
INSERT INTO krj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkakita kang mga disipulo kana nga nagapanaw sa tubig gindakup sanda kang kahadluk kag nagsiringgit sanda, “Bagat!” ");
INSERT INTO krj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ginkun-an lagi sanda ni Jesus, “Magpakabakud kamo! Ako dya; indi kamo magkahadluk!” ");
INSERT INTO krj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dayon naghambal si Pedro, “Ginoo, kon ikaw gid man ria, paagtona ako rugyan kanimo nga nagapanaw sa tubig.” ");
INSERT INTO krj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nagkuon si Jesus kana, “Sige agto dya!” Gani nagpanaog si Pedro sa baruto kag nagpanaw sa tubig paagto kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero kang mabatyagan ni Pedro nga mabaskug ang hangin, hinadlukan tana kag amat-amat nga naglugdang, kag nagsinggit tana, “Ginoo, tabangi ako!” ");
INSERT INTO krj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gindawhat dayon tana ni Jesus kag ginkaptan sa alima kag nagkuon, “Kagamay kang imong pagtuo! Andut haw nga nagpangduha-duha ikaw?” ");
INSERT INTO krj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nagsakay sanda nga darwa sa baruto kag nagkanay ang hangin. ");
INSERT INTO krj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kag ang mga disipulo nga rugyan sa baruto nagsimba kana nga nagakuon, “Matuod gid nga ikaw ang Anak kang Dios!” ");
INSERT INTO krj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagkatabok nanda sa linaw, sa lugar nga Genesaret sanda nagdungka. ");
INSERT INTO krj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nakilala si Jesus kang mga tawo rugto, gani ginpamalita nanda sa mga lugar sa palibot nga rugyan tana, kag ginpangdara nanda kana ang tanan nga mga nagamarasakit. ");
INSERT INTO krj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nagpakitluoy sanda kay Jesus nga ipatandugun na ang mga masakitun bisan sa sidsid lang kang anang kunup. Kag ang tanan nga nakatandug kadya nag-arayad. ");
INSERT INTO krj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kar-on, may mga Fariseo kag mga manunudlo kang kasugoan nga nagharalin sa Jerusalem ang nag-agto kay Jesus kag nagpamangkot, ");
INSERT INTO krj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Andut haw nga ang imong mga disipulo wara pagtuman kang mga pagsurondan nga gintudlo kang atun mga kamal-aman? Sanda kadya nagakirinaun lang nga wara anay pagpanghugas kang andang mga alima.” ");
INSERT INTO krj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ginsabat sanda ni Jesus, “Andut haw nga ginalapas man ninyo ang sugo kang Dios para lang matuman ang inyo nga mga pagsurondan? ");
INSERT INTO krj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Indi bala nga nagsugo ang Dios nga, ‘Tahudon mo ang imo tatay kag nanay,’ kag ‘Ang bisan sin-o nga maghambal kang malaot sa anang tatay ukon nanay, dapat mapatay?’ ");
INSERT INTO krj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero ang inyo tana ginatudlo amo nga kon ang sangka tawo gani may sarang nga ibulig sa anang tatay ukon nanay, pero kon magkuon tana nga, ‘Ginpain ko run dya para sa Dios,’ indi run tana kinahanglan nga magbulig sa anang tatay ukon nanay. ");
INSERT INTO krj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sa paghimo ninyo karia, ginhimo ninyo nga wara ti pulos ang sugo kang Dios para lang matuman ang inyo mga pagsurondan. ");
INSERT INTO krj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga hipokrito kamo! Husto gid man ang ginkuon kang Dios paagi kay Propeta Isaias nahanungud kaninyo, ");
INSERT INTO krj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ang mga tawo nga dya nagapadungug kanakun paagi gid lang sa andang mga ginapanghambal, pero wara gid sanda ti baratyagun para kanakun. ");
INSERT INTO krj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ang andang pagsimba kanakun wara ti kapuslanan, tungud hay ginatudlo nanda ang pagturon-an nga ginhimo-himo lang kang tawo nga kuno kanakun maghalin.’” ");
INSERT INTO krj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gintawag ni Jesus ang mga tawo nga magparapit kana kag ginkun-an, “Pamati kamo kag hangpa ninyo dyaay: ");
INSERT INTO krj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bukun ti ang ginakaun kang tawo ang makadagta kana, kundi kon ano ang nagagwa sa anang ba-ba; amo ria ang makadagta kana.” ");
INSERT INTO krj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dayon nagparapit kana ang anang mga disipulo kag nagkuon, “Naman-an mo bala nga naglain ang buut kang mga Fariseo sa ginpanghambal nimo?” ");
INSERT INTO krj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nagsabat si Jesus paagi sa paanggid, “Ang kada tanum nga wara gintanum kang akun Amay sa langit pagagabuton. ");
INSERT INTO krj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabay-i lang ninyo sanda. Mga bulag sanda karia nga manugtuytoy. Kag kon ang sangka bulag magtuytoy sa sangka bulag man, pareho sanda karia nga mahulog sa buho.” ");
INSERT INTO krj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naghambal si Pedro kana, “Abi, ipaathag kanamun ang paraanggidan nga ria.” ");
INSERT INTO krj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nagkuon si Jesus kananda, “Wara man bala ninyo mahangpi? ");
INSERT INTO krj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wara haw kamo kamaan nga ang bisan ano nga nagasulud sa ba-ba nagadiretso dya sa busong kag nagagwa lang man sa lawas? ");
INSERT INTO krj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ang nagagwa tana sa ba-ba nagahalin sa tagipusuon, kag amo dya ang nagadagta sa tawo. ");
INSERT INTO krj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tungud hay sa tagipusuon kang tawo nagahalin ang mga malain nga panghuna-huna nga amo ang nagatulod sa paghimo kang mga malain nga mga butang pareho kang pagpatay, pagpanginbayi ukon pagpanginlaki, pagpakighilawas, pagpanakaw, pagtistigo kang butig, kag paghambal kang makaguba ka dungug kang iba. ");
INSERT INTO krj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Amo dya nga mga butang ang nagadagta sa tawo. Pero indi tana makadagta kana ang magkaun nga wara makapanghugas kang alima.” ");
INSERT INTO krj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naghalin si Jesus rugto kag nag-agto sa lugar nga marapit sa probinsya kang Tiro kag Sidon. ");
INSERT INTO krj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kar-on, may sangka bayi nga taga-Canaan nga nagaistar rugto ang nagparapit kay Jesus kag nagpakitluoy nga nagakuon, “Ginoo, kaliwat ni David, maluoy ikaw kanakun! Ang akun bata nga bayi ginasab-an kang demonyo kag sobra gid ang ana nga pag-antos.” ");
INSERT INTO krj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero wara gid magsabat si Jesus kana. Ang anang mga disipulo nagparapit kana kag nagpangabay nga nagakuon, “Pahalina tana run, kaina pa ang ana sunod-sunod kanatun kag kagahud kana.” ");
INSERT INTO krj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nagsabat si Jesus, “Ginpadara ako rugya para lang sa mga katawhan kang Israel nga kaangay kang mga karnero nga nagtalang.” ");
INSERT INTO krj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero ang bayi nagparapit pa gid kana kag nagluhod sa atubang na nga nagakuon, “Ginoo, buligi man ako ay!” ");
INSERT INTO krj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nagsabat si Jesus kana, “Bukun ti mayad nga ibul-un ang pagkaun kang mga bata kag itablug sa mga ayam.” ");
INSERT INTO krj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nagsabat ang bayi, “Matuod ria, Ginoo, ogaring bisan gani ang mga ayam nagakaun man kang mga uyang nga pagkaun nga nagakarahulog sa lamesa kang andang agalun.” ");
INSERT INTO krj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dayon nagkuon si Jesus kana, “Inday, kabahul kang imo pagtuo! Matuman ang imo ginapangayo.” Kag sa amo gid to nga tion nag-ayad ang anang bata. ");
INSERT INTO krj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naghalin rugto si Jesus kag nagpanaw sa binit kang linaw kang Galilea. Dayon nagtukad tana sa bakulod kag nagpungko para magtudlo. ");
INSERT INTO krj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Duro gid nga mga tawo ang nag-aragto kana nga nagadara kang mga piang, bulag, pingkaw, apa, kag duro pa gid nga mga masakitun. Ginpangbutang nanda ang mga masakitun sa may atubang ni Jesus kag ginpang-ayad na sanda. ");
INSERT INTO krj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Daw indi gid makapati ang mga tawo kang nakita nanda nga ang mga apa makahambal run, ang mga pingkaw naayad run, ang mga piang makapanaw run kag ang mga bulag makakita run; kag gindayaw nanda ang Dios kang Israel. ");
INSERT INTO krj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gintawag ni Jesus ang anang mga disipulo kag nagkuon, “Nangir-o gid ako sa mga tawo nga dya hay tatlo ka adlaw run sanda nga nagaimaw kanakun kag wara run sanda ti makaun. Indi ako gusto nga mag-uroli sanda nga wara makakaun hay basi bala kon magkaralipung sanda sa dalan.” ");
INSERT INTO krj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Namangkot ang mga disipulo kana, “Sa diin bay kita makabuul kang pagkaun rugya sa disyerto para sa amo dya kaduro nga mga tawo?” ");
INSERT INTO krj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ginpamangkot sanda ni Jesus, “Pira ka bilog ang inyo tinapay dyan?” Nagsabat sanda, “Pito ka tinapay kag pirambilog nga magagmay nga isda.” ");
INSERT INTO krj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Amo to kag ginkun-an ni Jesus ang mga tawo nga magpurungko sa lupa. ");
INSERT INTO krj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dayon ginbuul na ang pito ka bilog nga tinapay kag ang mga isda kag nagpasalamat sa Dios. Pagkatapos ginpamihak-pihak na dya kag itugro sa anang mga disipulo kag dya ginpanagtag nanda sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nakakaun sanda tanan kag nagkarabusog. Kag kang panipunon kang mga disipulo ang mga nabilin, pito ka alat nga buta ang andang natipon. ");
INSERT INTO krj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Apat ka libo nga mga laki ang nakakaun wara ti labut ang mga bayi kag mga bata. ");
INSERT INTO krj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos kato ginpapauli ni Jesus ang mga tawo. Nagsakay tana sa baruto kag nag-agto sa lugar kang Magadan. ");
INSERT INTO krj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","May mga Fariseo kag mga Saduceo nga nag-aragto kay Jesus agud tirawan tana. Ginpangayoan nanda tana kang milagro sa pagpamatuod nga ginpadara tana kang Dios. ");
INSERT INTO krj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero nagsabat si Jesus kananda, “Kon nagatunod gani ang adlaw, nagakuon kamo nga, ‘Mayad ang tiempo sa rum-an hay mapula ang langit.’ ");
INSERT INTO krj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kag sa kasanagun ruman tana, nagakuon kamo, ‘Mauran kadya hay mapula ang langit kag garagal-umun.’ Maman-an ninyo ang tiempo paagi sa pagturuk sa langit, pero andut haw nga indi ninyo maman-an ang buut hambalun kang mga nagakaratabo sa kadya nga panag-on. ");
INSERT INTO krj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ang mga tawo sa kadya nga panag-on tama gid malaot kag nagtalikod sanda sa Dios. Nagapangayo kamo nga pakitaan ko kamo kang milagro, pero wara ti igapakita kaninyo magluwas lang sa makatiringala nga natabo kay Propeta Jonas.” Amo to kag nagpanaw tana kag ginbayaan na sanda. ");
INSERT INTO krj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kang nakatabok run ang mga disipulo sa pihak kang linaw, nalipat sanda magdara kang tinapay. ");
INSERT INTO krj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nagkuon si Jesus kananda, “Mag-andam gid kamo sa tapay kang mga Fariseo kag mga Saduceo.” ");
INSERT INTO krj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagkabati kang mga disipulo kato, nag-inistoryahanay sanda, “Ginhambal na to tungud hay wara kita makadara kang tinapay.” ");
INSERT INTO krj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Naman-an ni Jesus kon ano ang anda ginaistoryahan, gani namangkot tana kananda, “Andut haw nga ginaistoryahan ninyo nga wara kamo makadara kang tinapay? Mga gamay kamo ti pagtuo! ");
INSERT INTO krj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wara pa gid bala kamo makahangup? Nalipatan ninyo run haw ang pagpakaun ko kang lima ka tinapay sa lima ka libo ka laki? Pira ka alat nga buta ang sobra nga inyo natipon kato? ");
INSERT INTO krj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amo man sa pito ka tinapay nga ginpakaun ko sa apat ka libo, pira ka alat nga buta ang sobra nga inyo natipon kato? ");
INSERT INTO krj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Andut haw nga wara ninyo mahangpi nga bukun ti tinapay ang akun buut hambalun? Pero kar-on, mag-andam kamo sa tapay kang mga Fariseo kag mga Saduceo.” ");
INSERT INTO krj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Amo to kag nahangpan nanda nga ginpaandaman sanda gali, indi sa tapay nga ginagamit sa tinapay kundi sa mga ginapanudlo kang mga Fariseo kag mga Saduceo. ");
INSERT INTO krj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kar-on, kang pag-abot ni Jesus sa lugar nga sakup kang Cesarea Filipos, ginpamangkot na ang anang mga disipulo, “Para sa mga tawo, sin-o bala ang Anak kang Tawo?” ");
INSERT INTO krj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nagsabat sanda, “Ang kuon kang iba si Juan nga Manugbawtiso. Ang iba tana nagakuon nga si Elias. May iba man nga nagakuon nga si Jeremias. Kag ang iba pa gid nagakuon nga isara sa mga propeta.” ");
INSERT INTO krj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ginpamangkot sanda ni Jesus, “Ti, para kaninyo tana bay, sin-o ako?” ");
INSERT INTO krj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nagsabat si Simon Pedro, “Ikaw amo ang Cristo, ang Anak kang Dios nga buhi.” ");
INSERT INTO krj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nagkuon si Jesus kana, “Bulahan ikaw, Simon nga bata ni Jonas! Tungud hay bukun ti tawo ang nagpahayag kang kamatuoran nga dya kanimo, kundi ang akun Amay sa langit. ");
INSERT INTO krj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kag kar-on, ihambal ko kanimo: ikaw si Pedro. Kag sa dya nga bato pagatukudon ko ang akun iglesia nga bisan ang gahum kang kamatayun indi makadaug kadya. ");
INSERT INTO krj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kanimo ko itugro ang yabi sa ginharian kang langit. Ang bisan ano nga indi mo pag-itugot rugya sa lupa, indi man pag-itugot kang Dios sa langit, kag ang bisan ano nga itugot nimo rugya sa lupa, itugot man kang Dios sa langit.” ");
INSERT INTO krj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dayon ginpaandaman gid kamayad ni Jesus ang ana mga disipulo nga indi pagpanugid sa bisan kay sin-o nga tana amo ang Cristo. ");
INSERT INTO krj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Umpisa kato ginasugid run ni Jesus kang maathag sa anang mga disipulo nga kinahanglan maagto tana sa Jerusalem kag magbatas kang tuman nga pag-antos sa alima kang mga kamal-aman kang mga Judio, mga pangulo kang kaparian, kag mga manunudlo kang kasugoan. Ipapatay nanda tana, pero sa ikatlo nga adlaw pagabanhawun tana! ");
INSERT INTO krj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagkabati kato ni Pedro ginkaptan na si Jesus kag gindara sa oro-onhan kag ginsabdung, “Ginoo, kabay nga indi ria pag-itugot kang Dios! Indi gid ria matabo kanimo.” ");
INSERT INTO krj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nag-atubang si Jesus kana kag ginkun-an, “Parayu kanakun, Satanas! Ginasablagan mo lang ako, tungud hay ang imong mga panghuna-huna nga ria bukun ti sa Dios maghalin kundi ana ria kang tawo.” ");
INSERT INTO krj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dayon nagkuon si Jesus sa ana mga disipulo, “Ang bisan sin-o nga gusto magsunod kanakun kinahanglan nga indi na pagpasulabihun ang anang kaugalingun, kag magpas-an kang anang kros kag magsunod kanakun. ");
INSERT INTO krj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ang bisan sin-o nga nagatipig kang anang kabuhi, maduraan kadya. Pero ang bisan sin-o tana nga handa nga magdura kang anang kabuhi tungud kanakun, amo tana ang makaangkun kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hay ano gid bala ang mabuul kang sangka tawo kon maangkun na ang bilog nga kalibutan pero maduraan man tana kang kabuhi? Ano bay ang sarang na ibaylo agud nga maangkun na liwan ang anang kabuhi? ");
INSERT INTO krj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tungud hay ang Anak kang Tawo magabalik rugya sa kalibutan nga nagasidlak sa himaya kang anang Amay, kag kaimaw na ang anang mga anghel, kag tana magatugro kang balus sa kada isara suno sa andang hinimoan. ");
INSERT INTO krj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sugidan ko kamo, may iba rugya kaninyo nga indi mapatay hasta nga makita nanda ang Anak kang Tawo nga magabalik rugya bilang Hari.” ");
INSERT INTO krj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkaligad kang anum ka adlaw, gin-imaw ni Jesus sanday Pedro kag ang magbugto nga si Santiago kag si Juan, kag nagtukad sanda sa sangka mataas nga bukid nga sandahanun lang. ");
INSERT INTO krj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Samtang nagaturuk sanda kay Jesus, nakita nanda nga nagbaylo ang anang dagway. Ang anang pungyahun nagsirak nga daw pareho kang adlaw, kag ang anang bayo nagbanaag sa kaputi. ");
INSERT INTO krj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hinali lang, nakita nanda si Moises kag si Elias nga nagapakig-istorya kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dayon nagkuon si Pedro kay Jesus, “Ginoo mayad gid nga rugya kami! Kon gusto mo mahimo ako rugya kang tatlo ka karakamalig, ang isara para kanimo, ang isara tana para kay Moises, kag ang isara pa gid tana para kay Elias.” ");
INSERT INTO krj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Samtang nagahambal pa tana, ginlikupan sanda kang makasirilaw nga panganod kag may limug halin sa panganod nga naghambal, “Amo dya ang akun hinigugma nga Anak nga akun gid nahamut-an. Pamatii ninyo tana!” ");
INSERT INTO krj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagkabati kang mga disipulo kato, hinadlukan gid sanda kamayad gani nga nagharapaun sanda sa lupa. ");
INSERT INTO krj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ginparapitan sanda ni Jesus kag gintandug nga nagakuon, “Tindug kamo! Indi kamo magkahadluk!” ");
INSERT INTO krj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kang pagtangra nanda wara run sanda ti iba nga nakita magluwas gid lang kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kag kang nagapadulhog sanda sa bukid ginmandoan sanda ni Jesus, “Indi gid kamo magpanugid sa bisan kay sin-o nahanungud sa inyo nakita samtang ang Anak kang Tawo wara pa mabanhaw.” ");
INSERT INTO krj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ginpamangkot kang mga disipulo si Jesus, “Andut haw nga nagakuon ang mga manunudlo kang kasugoan nga magauna ka abot si Elias?” ");
INSERT INTO krj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nagsabat si Jesus, “Matuod gid man nga magauna ka abot si Elias para iaman ang tanan nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero sugidan ko kamo nga, nag-abot run si Elias, ogaring wara tana nakilala kang mga tawo kag ginhimo nanda kana ang anda luyag nga himuon. Kag amo man ria ang matabo sa Anak kang Tawo, pagapaantuson man nanda tana.” ");
INSERT INTO krj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Amo to kag nahangpan kang mga disipulo nga si Juan nga Manugbawtiso ang anang ginatumud. ");
INSERT INTO krj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kang nakabalik sanday Jesus sa duro nga mga tawo, may sangka laki nga nagparapit kag nagluhod sa atubang na nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Sir, maluoy man ikaw sa akun bata nga laki. Kuyapun tana kadya kag kon aboton gani tam-an gid ang anang pag-antos. Masami tana nagakatumba sa kalayo ukon indi gani sa tubig. ");
INSERT INTO krj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gindara ko tana sa imo mga disipulo pero indi sanda makasarang magpaayad kana.” ");
INSERT INTO krj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nagkuon si Jesus, “Kamo nga mga tawo sa kadya nga panag-on, mga wara kamo ti pagtuo kag balingag! Hasta san-o pa ayhan ako magapakig-imaw kaninyo? Hasta san-o pa ang akun pag-agwanta kaninyo? Abi, dar-a ninyo rugya kanakun ang bata!” ");
INSERT INTO krj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dayon ginmandoan ni Jesus ang demonyo nga magwa sa bata, kag nag gwa dya. Kag sa amo gid to nga tion nag-ayad ang bata. ");
INSERT INTO krj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nagparapit ang mga disipulo kay Jesus kag nagpamangkot kana nga sandahanun lang, “Andut haw nga indi namun matabog ang demonyo nga to?” ");
INSERT INTO krj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nagsabat si Jesus kananda, “Tungud hay kulang ang inyo pagtuo. Sugidan ko kamo, kon may pagtuo kamo nga bisan pareho lang kagamay sa liso kang mustasa, sarang kamo makakuon sa bukid nga dya nga, ‘Saylo rugto’ kag ang bukid masaylo man. Wara gid ti butang nga indi ninyo mahimo.  ");
INSERT INTO krj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ang dya nga sahi kang demonyo indi ninyo matabog kon indi kamo magpangamuyo kag magpuasa.” ");
INSERT INTO krj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kar-on kang magtiriripon ang tanan nga mga disipulo rugto sa Galilea nagkuon si Jesus kananda, “Ang Anak kang Tawo igatugyan sa mga tawo, ");
INSERT INTO krj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nga amo ang magapatay kana. Pero pagkatapos kang tatlo ka adlaw pagabanhawun tana.” Nagkasubu gid ang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kar-on, kang pag-abot nanda sa Capernaum, nagparapit kay Pedro ang mga manugsukot kang buwis para sa templo kag namangkot kana, “Nagabayad bala ang inyo maestro kang buwis para sa templo?” ");
INSERT INTO krj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nagsabat si Pedro, “Huud, nagabayad tana.” Kang pag-abot ni Pedro sa balay, ginpamangkot tana dayon ni Jesus, “Simon, sa banta mo, sin-o bala ang ginasukot kang mga hari rugya sa kalibutan kang buwis, ang mga tawo bala nga sakup nanda ukon ang mga pangayaw?” ");
INSERT INTO krj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nagsabat si Pedro, “Ang mga pangayaw.” Nagkuon si Jesus kana, “Kon amo, nagakahulogan lang nga ang mga tawo nga sakup indi kinahanglan nga magbayad. ");
INSERT INTO krj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ogaring indi kita gusto nga maglain ang andang buut kanatun. Gani agto ikaw sa linaw kag itawtaw ang imo bunit. Bul-un mo ang una nimo nga dawi kag abrihan ang anang ba-ba kag may makita ikaw rugto nga kwarta. Ibul-un mo ria kag ibayad para sa atun buwis nga darwa.” ");
INSERT INTO krj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa amo to nga tion nagparapit kay Jesus ang ana mga disipulo kag nagpamangkot, “Sin-o gid bala ang labaw sa tanan nga mga nasakup sa ginharian kang langit?” ");
INSERT INTO krj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nagtawag si Jesus kang sangka bata kag ginpatindug sa tunga nanda. ");
INSERT INTO krj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Dayon nagkuon tana, “Sugidan ko kamo, kon indi ninyo pagbag-uhon ang inyo panghuna-huna kag mangin pareho kang dya nga bata, indi gid kamo makaimaw sa mga tawo nga makapasakup sa ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ang sin-o man nga mapainubusun pareho kang bata nga dya, amo tana ang labaw sa tanan nga mga nasakup sa ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ang sin-o man nga tungud kanakun magabaton kang bata nga pareho kadya, nagabaton man kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ang bisan sin-o nga mangin kabangdanan nga makasala ang isara sa mga kabataan nga dya, mas mayad pa nga ipamatohan ang anang liug kang bahul nga garalingan nga bato kag itagbung tana sa tunga kang dagat. ");
INSERT INTO krj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Makaluluoy ang mga tawo rugya sa kalibutan tungud kang pagsulay nga makasala sanda. Indi gid malikawan nga ang mga pagsulay magaabot. Pero makaluluoy gid ang tawo nga amo ang mangin kabangdanan kang pagpakasala kang ana isigka-tawo. ");
INSERT INTO krj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Gani kon ang imo alima ukon kahig amo ang mangin kabangdanan kang imong pagpakasala, utda dya kag ipilak. Mas mayad pa nga utod ang imo alima ukon kahig pero makaagum ikaw kang kabuhi nga wara ti katapusan sangsa darwa ang imong alima ukon kahig pero idap-ong lang man ikaw sa kalayo nga wara nagakapalung. ");
INSERT INTO krj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kag kon ang imo mata amo ang mangin kabangdanan kang imong pagpakasala, lokita dya kag ipilak! Mas mayad pa nga isara lang ang imong mata pero makaagum ikaw kang kabuhi nga wara ti katapusan sangsa darwa ang imong mata pero idap-ong lang man ikaw sa kalayo sa impyerno.” ");
INSERT INTO krj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nagpadayon pa gid si Jesus sa pagkuon, “Mag-andam kamo nga indi ninyo pagtamayun ang bisan isara sa mga bata nga dya. Sugidan ko kamo, rugto sa langit, ang mga anghel nga nagabantay kananda rugyan pirme sa atubang kang akun Amay sa Langit.  ");
INSERT INTO krj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tungud hay ang Anak kang Tawo nag-abot rugya sa kalibutan agud luwasun ang mga nadura tungud sa sala. ");
INSERT INTO krj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ano sa banta ninyo ang himuon kang sangka tawo nga may sanggatos ka mga karnero kag nadura ang isara kadya? Indi na ayhan pagbayaan ang kasyaman kag syam nga nagaharab rugto sa bakulod kag sagapun ang isara nga nadura nga to? ");
INSERT INTO krj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kag kon makita na run gani dya sugidan ko kamo nga mas bahul gid nga kalipay ang ana mabatyagan tungud sa isara nga dya sangsa kasyaman kag syam nga wara nadura. ");
INSERT INTO krj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Amo man ria ang inyo Amay sa Langit, indi tana gusto nga malaglag ang bisan isara sa mga bata nga dya.” ");
INSERT INTO krj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nagpadayon pa gid si Jesus, “Kar-on kon ang imo isigka-tumuluo nakasala kanimo, agtonan mo tana kag istoryahun nga kamohanun lang parte sa anang sala. Kon magpamati tana kanimo, napanombalik mo ang mayad ninyo nga pagtamdanay. ");
INSERT INTO krj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero kon indi tana magpamati kanimo, mag-imaw ikaw kang isara ukon darwa pa gid agud to nga, ‘Ang kada butang nga inyo pagahambalan mapamatod-an kang darwa ukon tatlo ka mga saksi.’ ");
INSERT INTO krj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kag kon indi pa gid tana magpamati kananda, isugid dya sa katiringban. Kon indi pa gid tana magpamati sa katiringban, kabiga tana nga pareho kang tawo nga wara nakakilala sa Dios ukon manugsukot kang buwis.” ");
INSERT INTO krj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sugidan ko kamo: ang bisan ano nga indi ninyo pag-itugot rugya sa lupa, indi man pag-itugot kang Dios sa langit. Kag ang bisan ano nga itugot ninyo rugya sa lupa, itugot man ria kang Dios sa langit. ");
INSERT INTO krj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kag sugidan ko pa gid kamo: kon ang darwa kaninyo rugya sa lupa maghisugot parte sa bisan ano nga inyo pangayuon sa pangamuyo, himuon dya kaninyo kang akun Amay sa langit. ");
INSERT INTO krj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tungud hay kon diin ang darwa ukon tatlo nga nagatipon tungud kanakun, kaimaw nanda ako.” ");
INSERT INTO krj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nagparapit si Pedro kay Jesus kag nagpamangkot, “Ginoo, makapira ka beses ko gid bala patawarun ang akun isigka-tumuluo nga pirme lang nagahimo kang sala kanakun? Hasta bala sa pito ka beses?” ");
INSERT INTO krj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nagsabat si Jesus kana, “Wara ako magkuon nga pito ka beses, kundi pito ka pilo kang kapitoan. ");
INSERT INTO krj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tungud hay ang ginharian kang langit pareho kang sangka hari nga nagpamat-ud nga sukton ang utang kang anang mga surugoon. ");
INSERT INTO krj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kang nagaumpisa run tana kapanukot, may gindara kana nga sangka surugoon nga ang anang utang minilyon. ");
INSERT INTO krj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tungud nga indi dya makabayad kang ana utang, nagmando ang hari nga ibaligya tana pati ang ana asawa, kag ang ana mga bata, kag tanan na nga mga pagkabutang para ibayad sa ana utang. ");
INSERT INTO krj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nagluhod ang surugoon sa atubang kang hari kag nagpakitluoy nga nagakuon, ‘Tugroi lang ako anay ka tion, hay ibaydan ko gid ikaw kang tanan ko nga utang!’ ");
INSERT INTO krj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naluoy ang hari kana, gani wara run tana ginpabayad kang anang utang kag ginpapauli lamang. ");
INSERT INTO krj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pero kang nagapauli run ang surugoon nga to, nasug-alaw na ang anang isigka-surugoon nga may utang man kana nga bali pira lang ka gatos. Gindakup na dya kag ginkuga kag ginkun-an nga, ‘Baydi ang utang mo kanakun!’ ");
INSERT INTO krj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nagluhod dya kag nagpakitluoy kana nga nagakuon, ‘Tugroi lang ako anay ka tion, hay ibaydan ko gid ikaw!’ ");
INSERT INTO krj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero wara gid tana nagpasugot. Sa baylo ginpapriso na gid dya hasta nga mabaydan na ang anang utang. ");
INSERT INTO krj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kang makita kang iba pa gid nga mga surugoon ang natabo nga dya, naglain gid ang andang buut. Dayon nag-agto sanda sa hari kag ginsugid ang tanan nga natabo. ");
INSERT INTO krj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Amo to kag ginpatawag kang hari ang surugoon nga to kag ginkun-an dya nga, ‘Ikaw, sobra kaw gid kalain! Wara ko run kabay ikaw ginpabayad kang imo utang kanakun tungud hay nagpakitluoy ikaw? ");
INSERT INTO krj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Indi bala dapat nga maluoy ikaw sa imo isigka-surugoon, pareho kang akun pagkaluoy kanimo?’ ");
INSERT INTO krj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sa kaugut kang hari kana, ginpapriso na ang surugoon nga dya kag ginpasilotan hasta nga mabaydan na ang tanan na nga utang.” ");
INSERT INTO krj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kag nagkuon si Jesus kananda, “Amo man dya ang himuon kaninyo kang akun Amay sa langit kon indi ninyo pagpatawarun ang inyo isigka-tawo kang bug-os sa inyo tagipusuon.” ");
INSERT INTO krj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos hambal ni Jesus kang mga butang nga to, naghalin tana sa Galilea kag nag-agto sa lugar nga sakup kang Judea sa pihak kang suba kang Jordan. ");
INSERT INTO krj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Duro gid nga mga tawo ang nagsurunod kana, kag rugto ginpang-ayad na ang mga nagamarasakit. ");
INSERT INTO krj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","May mga Fariseo nga nagparapit kay Jesus agud tirawan tana. Ginpamangkot nanda tana nga nagakuon, “Ginatugot bala sa kasugoan nga bulagan kang bana ang ana asawa sa bisan ano nga kabangdanan?” ");
INSERT INTO krj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nagsabat si Jesus, “Wara ninyo haw nabasa sa kasulatan nga kang umpisa pa lang ginhimo kang Manunoga ang tawo nga laki kag bayi? ");
INSERT INTO krj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kag naghambal tana, ‘Tungud ka dya ang laki magabiya sa anang tatay kag nanay kag magtingub sa anang asawa, kag sanda nga darwa mangin isara.’ ");
INSERT INTO krj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gani nga bukun run sanda ti darwa kundi isara run lang. Kon amo karia, ang gintingub run kang Dios indi dapat nga ibulagun kang bisan sin-o.” ");
INSERT INTO krj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nagpamangkot ang mga Fariseo kana, “Ti, andut haw nga nagtugro si Moises kang kasugoan nga ang laki dapat magtugro sa anang asawa kang kasulatan kang pagbulaganay kag dayon pahalinun tana?” ");
INSERT INTO krj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nagsabat si Jesus, “Gintugotan kamo Moises nga bulagan ang inyo mga asawa tungud hay tama gid ka awut ang inyo ulo. Pero bukun ti amo karia ang plano kang Dios kang primero. ");
INSERT INTO krj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kar-on, sugidan ko kamo: ang bisan sin-o nga magabulag sa anang asawa magluwas lang nga nagpanginlaki dya, kag mangasawa liwan nakasala tana kadya kang pagpanginbayi.” ");
INSERT INTO krj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nagkuon ang mga disipulo kana, “Kon magtulad lang man karia ang pag-asawahay, mayad pa nga indi run lang mangasawa.” ");
INSERT INTO krj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nagsabat si Jesus, “Ang pagturon-an nga dya bukun ti para sa tanan, kundi para lang sa mga gintugroan nga daan. ");
INSERT INTO krj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tungud hay may iba nga natawo nga indi makapangasawa, ang iba tana ginkapon, kag ang iba pa gid tana wara nagpangasawa tungud ginpasulabi na ang pag-alagad para sa ginharian kang langit. Ang sin-o man nga makasarang magsunod kang pagturon-an nga dya, sundon na.” ");
INSERT INTO krj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","May mga magagmay nga mga bata nga gindara kay Jesus para itungtong ang anang alima kananda kag ipangamuyoan sanda. Pero ginsaway kang mga disipulo ang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ginkun-an sanda ni Jesus, “Pabay-i ninyo ang mga bata nga magparapit kanakun; indi ninyo sanda pagpunggi tungud hay ang mga tawo nga pareho kananda ang makapasakup sa ginharian kang langit.” ");
INSERT INTO krj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kag gintungtong ni Jesus kananda ang anang alima, kag pagkatapos kato nagpanaw tana. ");
INSERT INTO krj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kar-on, may sangka laki nga nagparapit kay Jesus kag namangkot, “Maestro, ano bala ang mayad nga buhat nga akun dapat himuon para makaagum ako kang kabuhi nga wara ti katapusan?” ");
INSERT INTO krj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nagsabat si Jesus, “Andut haw nga ginapamangkot mo ako kon ano ang mayad? Isara gid lang ang mayad. Tumana ang mga kasugoan kon gusto mo nga makaagum kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Namangkot ang laki, “Ano bay nga mga sugo?” Nagsabat si Jesus, “Indi ikaw magpatay, indi ikaw magpakighilawas, indi ikaw magpanakaw kag indi ikaw magbutig sa imo pagtistigo, ");
INSERT INTO krj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tahoda ang imo tatay kag imo nanay, kag palanggaa ang imo isigka-tawo pareho kang imo kaugalingun.” ");
INSERT INTO krj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ang pamatan-un nga laki nagsabat, “Natuman ko run ria nga mga sugo, ano pa bay ang akun dapat himuon?” ");
INSERT INTO krj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nagkuon si Jesus kana, “Kon gusto mo nga mangin himpit, panaw kag ibaligya ang imong mga pagkabutang kag ang kwarta ipanagtag mo sa mga pobre. Kon himuon mo ria, makaangkun ikaw kang manggad sa langit. Pagkatapos balik ikaw rugya kag magsunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagkabati kadya kang pamatan-un, nagpanaw tana nga nagakasubu, tungud hay tama gid tana ka manggaranun. ");
INSERT INTO krj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nagkuon si Jesus sa anang mga disipulo, “Sugidan ko kamo, mabudlay sa sangka manggaranun ang magpasakup sa ginharian kang langit. ");
INSERT INTO krj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kag ginakuon ko pa gid kaninyo nga mas mahapus pa sa kamelyo ang mag-agi sa buho kang dagum sangsa manggaranun nga magpasakup sa ginharian kang Dios.” ");
INSERT INTO krj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagkabati kadya kang mga disipulo natingala gid sanda kamayad. Gani nagpamangkot sanda, “Ti kon amo karia, sin-o run lang bay ang maluwas?” ");
INSERT INTO krj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ginturuk sanda ni Jesus kag naghambal, “Kon sa mga tawo lang indi gid dya mahimo, pero sa Dios tana ang tanan nga butang mahimo na.” ");
INSERT INTO krj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dayon nagkuon si Pedro kana, “Amun tana, ginbayaan namun ang tanan kag nagsunod kanimo, ano kar-on ang amun mabaton?” ");
INSERT INTO krj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nagkuon si Jesus kananda, “Sugidan ko kamo, kon bag-ohon run kang Dios ang kalibutan nga dya kag ang Anak kang Tawo magapungko run sa anang mahimayaun nga trono, kamo nga nagsunod kanakun magapungko man sa napulo'g darwa ka trono sa paghukum sa napulo'g darwa ka tribo kang Israel. ");
INSERT INTO krj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kag ang sin-o man nga nagbiya kang anang balay, anang mga bugto nga laki, mga bugto nga bayi, tatay, nanay, kag kabataan, ukon kang anang lupa tungud kanakun, magabaton tana kadya kang ginatos ka pilo kag makaangkun pa gid tana kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero duro nga mga nahauna ang mangin urihi, kag duro nga mga naurihi ang mangin una.” ");
INSERT INTO krj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Naghambal pa gid si Jesus kananda paagi sa paraanggidan, “Ang ginharian kang langit pareho kang sangka tawo nga tag-iya kang ubasan nga aga pa nagpanaw sa pagpangita kang mga tawo nga maobra sa anang orubasan. ");
INSERT INTO krj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kang magsugtanay run sanda sa suhol nga sangka kwarta nga pilak sa sangka adlaw, ginpaagto na sanda sa anang ubasan. ");
INSERT INTO krj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kang mga alas nuwebe run ti aga naggwa ruman tana kag may nakita tana nga mga tawo nga nagaduruyu rugto sa may tindahan kag wara ti obra. ");
INSERT INTO krj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nagkuon tana kananda, ‘Agto man kamo to kag mag-obra sa akun ubasan hay suholan ko kamo kang igsakto.’ ");
INSERT INTO krj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gani nagpanaw man sanda rugto. Naggwa ruman tana kang mga alas dose kag kang mga alas tres ti hapon kag amo man angud ang anang ginhimo. ");
INSERT INTO krj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kag kang mga alas singko run ti hapon nagpanaw ruman tana sa tindahan kag may nakita pa gid tana nga nagaduruyu rugto. Ginpamangkot na sanda kadya, ‘Andut haw nga nagaduruyu lang kamo rugya sa bilog nga adlaw kag wara ti ginaobra?’ ");
INSERT INTO krj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nagsabat sanda kana, ‘Ano abi hay, wara man ti may mapaobra kanamun!’ Ginkun-an na sanda, ‘Kon amo, agto kamo kag mag-obra sa akun ubasan.’ ");
INSERT INTO krj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kang sirum run, nagkuon ang tag-iya sa anang manugdumara, ‘Tawga run ang mga manug-obra kag sulhi sanda umpisa sa mga urihi nga nag-obra hasta sa mga nauna.’ ");
INSERT INTO krj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ang mga nag-urobra kang mga alas singko ti hapon ginsuholan kang tag-sangka kwarta nga pilak. ");
INSERT INTO krj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kag kang ang mga nauna nga nag-urobra amo run ang suholan, nagpinsar sanda nga mas bahul tana ang andang mabaton, pero ang kada isara kananda ginsuholan man kang tag-sangka kwarta nga pilak. ");
INSERT INTO krj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkabaton nanda kato, nagreklamo sanda sa tag-iya. ");
INSERT INTO krj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nagkuon sanda, ‘Ang mga urihi nga nag-arabot, sangka oras lang ang anda obra. Kami tana bilog nga adlaw nga nagpabalhas ka obra sa nagatagi-ti nga init kang adlaw. Pero andut haw nga pareho lang ang imo ginsuhol kanamun tanan?’ ");
INSERT INTO krj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nagsabat ang tag-iya sa isara kananda, ‘Amigo, wara ko ikaw gindayaan. Indi bala nga nagsugtanay kita nga suholan ko ikaw kang sangka kwarta nga pilak? ");
INSERT INTO krj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bul-a ang imo suhol kag mag-uli. Gusto ko nga tugroan ang tawo nga urihi nga nag-obra pareho kang gintugro ko kanimo. ");
INSERT INTO krj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wara haw ako ti kinamatarung kon ano ang akun himuon sa akun kwarta? Ukon nagasabit lang ikaw tungud hay maalwan ako?’” ");
INSERT INTO krj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dayon nagkuon si Jesus kananda, “Gani ang mga naurihi mangin una, kag ang mga nahauna ang mangin urihi.” ");
INSERT INTO krj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kar-on, kang nagapaagto si Jesus sa Jerusalem, ginpain na ang napulo'g darwa na ka mga disipulo kag ginkun-an samtang nagapanaw sanda, ");
INSERT INTO krj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nagapatukad kita sa Jerusalem nga sa diin ang Anak kang Tawo itugyan sa mga pangulo kang mga kaparian kag sa mga manunudlo kang kasugoan. Pagasentensyahan nanda tana kang kamatayun, ");
INSERT INTO krj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kag igatugyan sa mga bukun ti Judio agud yagotaun, hanuton kag ilansang sa kros; pero sa ikatlo nga adlaw pagabanhawun tana.” ");
INSERT INTO krj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kar-on, ang asawa ni Zebedeo nagparapit kay Jesus imaw kang anang darwa ka bata, nagluhod sa atubang na kag may ginpangabay kana. ");
INSERT INTO krj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Namangkot si Jesus kana, “Ano raad haw ang gusto mo?” Nagsabat ang bayi, “Ginapangabay ko nga kon maghari run gani ikaw, papungkuon mo ang akun darwa ka bata nga dya sa ingud nimo, ang isara sa imo tuo kag ang isara tana sa wala.” ");
INSERT INTO krj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nagsabat si Jesus kananda, “Wara kamo kamaan kon ano ang inyo ginapangayo. Masarangan bala ninyo atubangun ang mga pag-antos nga akun pagaantuson?” Nagsabat sanda, “Huud, masarangan namun.” ");
INSERT INTO krj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nagkuon si Jesus kananda, “Magaantos gid man kamo pareho kang akun pag-antos. Pero wara ako ti kinamatarung nga magpili kon sin-o ang magapungko sa akun tuo kag sa akun wala. Dya nga mga purungkoan para lang sa ginatigan-an kang akun Amay.” ");
INSERT INTO krj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kang mabatian dya kang napulo nga mga disipulo, nag-ugut sanda sa darwa ka magbugto. ");
INSERT INTO krj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gani, gintawag sanda tanan ni Jesus kag ginhambalan, “Naman-an ninyo nga ang mga manugdumara kang mga bukun ti Judio amo ang nagagahum kananda, kag ang nagapangulo kananda amo ang ginasunod nanda. ");
INSERT INTO krj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero kaninyo tana bukun ti amo ria ang dapat nga matabo. Sa baylo, kon sin-o man ang gusto nga mangin dungganun kaninyo kinahanglan nga mangin surugoon tana kang tanan. ");
INSERT INTO krj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kag ang sin-o man nga gusto mangin pangulo, kinahanglan nga mangin oripun tana kang tanan. ");
INSERT INTO krj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pareho kang Anak kang Tawo nga wara mag-agto rugya para alagadun kundi para mag-alagad kag magtugro kang anang kabuhi sa pagtubos kang duro.” ");
INSERT INTO krj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kar-on, kang nagapagwa run sa Jerico si Jesus kag ang anang mga disipulo, duro nga mga tawo ang nagsurunod kana. ");
INSERT INTO krj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","May darwa rugto ka tawo nga bulag nga nagapungko sa binit kang dalan kag kang pagkabati nanda nga si Jesus nagaagi nagsinggit sanda, “Kaliwat ni David, kaluoyi man kami!” ");
INSERT INTO krj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ginsaway sanda kang mga tawo kag ginkun-an nga maghipus. Pero gintudohan pa gid gani nanda ka singgit, “Sir, kaliwat ni David, kaluoyi man kami!” ");
INSERT INTO krj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nagpundo si Jesus kag gintawag na sanda kag ginpamangkot, “Ano ang gusto ninyo nga himuon ko kaninyo?” ");
INSERT INTO krj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nagsabat sanda, “Sir, gusto raad namun nga makakita!” ");
INSERT INTO krj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naluoy gid si Jesus kananda, kag ginhikap na ang andang mga mata, kag kato lagi nakakita sanda kag nagsunod kana. ");
INSERT INTO krj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kang nagahinamput run sanda sa Jerusalem, kag kang pag-abot nanda sa baryo kang Betfage rugto sa bukid kang mga Olibo, ginpauna ni Jesus ang darwa na ka mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ginkun-an na sanda, “Agto kamo rugto sa sunod nga baryo, pagsulud ninyo rugto may makita kamo nga sangka asno nga nahigot imaw kang ana tinday. Hubadi ninyo sanda kag dar-a rugya kanakun. ");
INSERT INTO krj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kon may maghambal gani kaninyo kang bisan ano, kon-on ninyo, ‘Kinahanglan ang mga dya kang Ginoo,’ kag ipadara na ria dayon.” ");
INSERT INTO krj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Natabo dya para matuman ang ginkuon kang propeta, ");
INSERT INTO krj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sugidi ninyo ang mga taga-Sion, ‘Rugya run ang inyo hari nga nagaabot, Mapainubusun tana kag nagasakay sa sangka asno sa tinday nga asno.’” ");
INSERT INTO krj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nagpanaw ang mga disipulo nga to kag ginhimo nanda ang ginkuon kananda ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gindara kang mga disipulo ang asno imaw kang ana tinday, kag ginhapinan nanda kang andang mga kunup ang likod kang mga dya, kag dayon nagsakay si Jesus. ");
INSERT INTO krj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Duro gid nga mga tawo ang naghurumlad kang andang mga kunup sa dalan kag ang iba tana nagtapas kang mga sanga kang kahoy kag ginladlad sa dalan. ");
INSERT INTO krj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ang mga tawo nga nagauna kay Jesus kag ang mga nagasurunod kana nagasiringgit, “Dayawun ta ang kaliwat ni David! Pakamayadun ang nagaabot sa ngaran kang Ginoo! Dayawun ta ang Dios!” ");
INSERT INTO krj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagsulud ni Jesus sa Jerusalem ang mga tawo sa bilog nga syudad naggirinoal kag nagpinamangkot, “Sin-o ria haw?” ");
INSERT INTO krj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nagsabat ang mga tawo, “Amo dya ang propeta nga si Jesus nga taga-Nazaret sa Galilea.” ");
INSERT INTO krj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kar-on, nagsulud si Jesus sa templo kag ginpanabog na pagwa ang mga tawo nga nagapamakal kag nagabaligya rugto. Ginpamaliskad na ang mga lamesa kang mga manugbaylo kang kwarta kag ang mga purungkoan kang mga manugbaligya kang pating. ");
INSERT INTO krj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nagkuon tana kananda, “Nasulat sa kasulatan, nga ang Dios nagkuon, ‘Ang akun balay pagatawgun nga Balay-Parangamuyoan. Pero ginahimo tana ninyo dya nga paranagoan kang mga takawan!’” ");
INSERT INTO krj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ang mga bulag kag mga piang nag-aragto kana rugto sa templo kag gin-ayad na sanda. ");
INSERT INTO krj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ang mga pangulo kang mga kaparian kag ang mga manunudlo kang kasugoan tana nag-ugut kang makita nanda ang mga makatiringala nga mga butang nga ginhimo ni Jesus, kag kang mabatian nanda ang mga kabataan rugto sa templo nga nagasinggit, “Dayawun ang kaliwat ni David!” ");
INSERT INTO krj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Gani ginpamangkot nanda si Jesus, “Nabatian mo bala ang ginakuon nanda?” Nagsabat si Jesus, “Huud. Wara ninyo haw mabasahi sa kasulatan, ‘Bisan ang mga magagmay nga mga bata kag ang mga lapsag ginatudloan nimo nga magdayaw kanimo kang himpit?’” ");
INSERT INTO krj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagkatapos kato, ginbayaan na sanda kag nagwa tana sa syudad kag nagpa-Betania. Rugto tana nagpaligad kang gabii. ");
INSERT INTO krj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkaaga kato, samtang nagapabalik tana sa syudad, gin-gutum tana. ");
INSERT INTO krj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nakakita tana kang kahoy nga higera sa binit kang dalan, kag ginparapitan na dya. Pero wara gid tana ti may nakita nga bunga kundi puro lang dahon. Gani ginhambalan na ang kahoy, “Indi run gid ikaw magpamunga liwan!” Kag kato lagi nalaya ang higera. ");
INSERT INTO krj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kang makita dya kang anang mga disipulo natingala gid sanda kag namangkot, “Paano nga nalaya dayon ang kahoy nga higera?” ");
INSERT INTO krj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nagsabat si Jesus, “Sugidan ko kamo: kon magtuo kamo kag wara gid nagapangduha-duha, mahimo man ninyo ang ginhimo ko sa kahoy nga higera nga dya. Kag indi lang ria, sarang pa ninyo makon-an ang bukid nga dya, ‘Paghalin rugya, kag magsaylo sa dagat,’ kag matabo man dya. ");
INSERT INTO krj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kon nagatuo kamo, mabaton ninyo ang bisan ano nga inyo pangayuon sa inyo pangamuyo.” ");
INSERT INTO krj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kar-on, nagsulud si Jesus sa templo kag nagpanudlo. Nagparapit kana ang mga pangulo kang mga kaparian kag ang mga kamal-an kang mga Judio kag namangkot, “Ano ang imo awtoridad sa paghimo kang dya nga mga butang, kag sin-o ang nagtugro kanimo kang ria nga awtoridad?” ");
INSERT INTO krj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nagsabat si Jesus kananda, “May pamangkot man ako kaninyo; kon masabat ninyo dya, isugid ko kaninyo kon ano ang akun awtoridad sa paghimo kang dya nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sa diin bala naghalin ang awtoridad ni Juan sa pagbawtiso, sa Dios bala ukon sa tawo?” Amo to kag nagbinaisay sanda nga nagakuon, “Kon magkuon kita nga halin sa Dios, makuon tana kanatun, ‘Ti, andut nga wara kamo magpati kana?’ ");
INSERT INTO krj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero kon magkuon man kita nga halin sa tawo, nahadluk man kita nga basi kon ano ang himuon kang mga tawo kanatun, tungud hay ginakilala nanda si Juan nga sangka propeta.” ");
INSERT INTO krj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amo to kag nagsabat sanda kay Jesus, “Ambay, wara kami makamaan!” Nagkuon si Jesus kananda, “Ti, kon amo, indi ko man pag-isugid kaninyo kon ano ang akun awtoridad sa paghimo kang dya nga mga butang.” ");
INSERT INTO krj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nagpadayon pa gid si Jesus sa paghambal kananda paagi sa paraanggidan, “Ano ang pag-intiendi ninyo sa istorya nga dyaay: may sangka tawo nga may darwa ka bata nga laki. Gin-agtonan na ang magurang kag ginkun-an, ‘To, panaw ikaw kag mag-obra rugto sa ubasan kadya nga adlaw.’ ");
INSERT INTO krj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nagsabat ang bata, ‘Indi ako.’ Pero kang urihi run nagbaylo ang anang pinsar kag nag-agto sa ubasan. ");
INSERT INTO krj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dayon gin-agtonan man kang Tatay ang libayun kag amo man ang ginkuon na kana. Nagsabat ang bata, ‘Huud, Tay.’ Pero wara dya magpanaw. ");
INSERT INTO krj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kar-on, sin-o bay sa darwa ang nagtuman sa gusto kang andang Tatay?” Nagsabat sanda, “Ang magurang!” Nagkuon si Jesus kananda, “Sugidan ko kamo, naunahan pa kamo ka pasakup sa paghari kang Dios kang mga manugsukot kang buwis kag kang mga bayi nga nagabaligya kang anda dungug. ");
INSERT INTO krj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tungud hay nag-abot kaninyo si Juan nga Manugbawtiso para tudloan kamo kang paagi para mangin matarung pero wara kamo magpati kana. Ang mga manugsukot tana kang buwis kag ang mga bayi nga nagabaligya kang anda dungug amo ang nagpati kana. Bisan pa nga nakita run ninyo dya, wara man angud kamo maghinulsul kag magpati kana.” ");
INSERT INTO krj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nagpadayon pa gid si Jesus sa paghambal kananda, “Pamatii pa gid ninyo ang sangka paraanggidan nga dya. May sangka tawo nga nagtanum kang ubas sa anang uma. Ginkudalan na dya palibot kag nagkutkot kang buho para purugaan kang ubas. Nagpatindug man tana kang mataas nga barantayan. Pagkatapos, ginpaagsa na ang anang taramnan, kag nagpanaw sa iba nga lugar. ");
INSERT INTO krj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kang pag-abot kang tag-arani kang ubas, ginpaagto na ang anang mga surugoon sa mga agsador para magbuul kang anang huray. ");
INSERT INTO krj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ginpangdakup kang mga agsador ang mga surugoon nga to. Dayon ginbakol nanda ang isara, ang isara tana ginpatay nanda, kag ang isara pa gid tana ginbato nanda. ");
INSERT INTO krj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ginpaagto liwan kang tag-iya ang iba na nga mga surugoon nga mas duro sangsa una. Pero amo man gihapon ang ginhimo kang mga agsador kananda. ");
INSERT INTO krj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kang urihi run, ang bata na nga laki run gid ang anang ginpaagto tungud hay hambal na sa anang kaugalingun, ‘Tahudon nanda ang akun bata.’ ");
INSERT INTO krj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero kang makita kang mga agsador ang bata kang tag-iya, naghambalanay sanda, ‘Dyaay ang manunobli. Dali kamo patyun natun tana para nga mabuul natun ang anang paranubliun.’ ");
INSERT INTO krj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Amo to kag gindakup nanda tana kag gindara sa gwa kang ubasan kag ginpatay.” ");
INSERT INTO krj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dayon namangkot si Jesus, “Kar-on, kon mag-abot run ang tag-iya kang ubasan, ano ayhan ang himuon na sa mga agsador nga to?” ");
INSERT INTO krj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nagsabat sanda, “Pamatyun na gid ang mga malain nga tawo nga to, kag ipaagsa ang anang ubasan sa iba nga mga agsador nga makatugro kana kang anang huray sa kada patubas.” ");
INSERT INTO krj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kag nagkuon si Jesus kananda, “Wara gid ninyo haw mabasahi sa kasulatan nga: ‘Ang bato nga wara maluyagi kang mga manughimo kang balay, amo pa ang nangin pinakapamusod nga bato. Ang Ginoo ang naghimo kadya kag tama gid dya ka makatiringala!’ ");
INSERT INTO krj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Gani sugidan ko kamo nga bukun run kamo ang pagaharian kang Dios kundi ang mga tawo nga nagahimo kang anang kabubut-un.  ");
INSERT INTO krj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ang bisan sin-o nga mahulog sa bato nga dya marupsak gid, kag ang mahulogan na kadya makarapusa gid nga daw binukbok. ” ");
INSERT INTO krj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kang mabatian kang mga pangulo kang kaparian kag kang mga Fariseo ang mga paanggid ni Jesus nga dya, nasat-uman nanda nga sanda ang anang ginapatungdan. ");
INSERT INTO krj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gani, gintinguhaan nanda nga idakpun tana, pero nahadluk sanda sa mga tawo tungud hay ginakilala nanda tana nga sangka propeta. ");
INSERT INTO krj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naghambal pa gid si Jesus kananda paagi sa mga paraanggidan: ");
INSERT INTO krj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ang ginharian kang langit pareho kang sangka hari nga naghanda kang sangka tabad para sa kasal kang anang bata nga laki. ");
INSERT INTO krj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dayon, ginsugo na ang ana mga surugoon nga panawgun ang mga tawo nga ginpang-imbitar, pero ang mga ginpang-imbitar nga dya indi gusto nga mag-agto. ");
INSERT INTO krj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gani nagsugo ruman tana kang iba pa gid nga mga surugoon kag ginkun-an, ‘Ikun-on ninyo ang mga ginpang-imbitar nga handa run ang akun tabad. Ang akun mga baka kag mga tinday nga pinatambuk naihaw run kag ang tanan handa run. Gani agto run kamo dya sa tabad!’ ");
INSERT INTO krj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero wara magsapak ang mga gin-imbitar nga to; nagpadayon lang sanda sa andang buruhatun. Ang isara nag-agto sa anang uma; ang isara tana sa anang negosyo. ");
INSERT INTO krj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ang iba tana nga gin-imbitar ginpangdakup nanda ang mga surugoon, ginpintasan nanda kag ginpamatay. ");
INSERT INTO krj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naugut gid ang hari. Amo to kag ginsugo na ang anang mga suldado nga pamatyun ang mga nagpamatay kang anang mga surugoon kag sunugon ang andang syudad. ");
INSERT INTO krj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dayon ginkun-an na ang iba pa nga anang mga surugoon nga, ‘Handa run ang tabad, pero ang mga tawo nga gin-imbitar indi takus nga magtambong. ");
INSERT INTO krj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kar-on, agto kamo sa mga karsadahun kag imbitara ninyo ang tanan nga tawo nga inyo makita.’ ");
INSERT INTO krj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gani ang mga surugoon nag-aragto sa mga karsadahun kag gintipon nanda ang tanan nga tawo nga anda nakita, ang mga mayad kag ang mga malain; kag ang karan-an sa tabad nabuta kang mga bisita. ");
INSERT INTO krj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Pero kang pagsulud kang hari para agtonan ang mga bisita, may nakita tana nga sangka tawo rugto nga wara nakasuksok kang bayo para sa tabad. ");
INSERT INTO krj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ginpamangkot tana kang hari, ‘Amigo, paano ikaw nakasulud rugya nga wara nakasuksok kang bayo nga para sa tabad?’ Ang tawo wara makasabat. ");
INSERT INTO krj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dayon nagkuon ang hari sa anang mga surugoon, ‘Gaposa ninyo ang ana alima kag kahig kag itablug sa sagwa rugto sa madulum nga lugar, sa diin rugto magahiribiun tana kag magabagrut ang anang unto.’ ");
INSERT INTO krj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Tungud hay duro ang mga gin-imbitar, pero gamay lang ang ginpili.” ");
INSERT INTO krj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naghalin ang mga Fariseo kag nagplano kon paano nanda madakup si Jesus paagi sa anang ginahambal. ");
INSERT INTO krj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Gani ginpaagto nanda kay Jesus ang iba nanda nga mga sumurunod imaw kang pira ka mga sinakpan ni Herodes. Kag nagkuon sanda kadya, “Maestro, naman-an namun nga wara ikaw nagabutig, kag nagatudlo ikaw kang kamatuoran nahanungud sa kabubut-un kang Dios. Kag wara ikaw nagapadara-dara sa mga tawo bisan sin-o pa sanda tungud hay wara ikaw ti pinilian. ");
INSERT INTO krj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kar-on, sugidi abi kami kon ano sa banta mo: Ginatugot bala kang kasugoan ang pagbayad kang buwis sa emperador kang Roma, ukon wara?” ");
INSERT INTO krj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero naman-an ni Jesus ang anda malain nga tuyo, gani nagkuon tana, “Mga hipokrito kamo, andut haw nga ginatinguhaan ninyo ako nga idakup-dakupun? ");
INSERT INTO krj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abi, pakitai ninyo ako kang kwarta nga ginagamit sa pagbayad kang buwis.” Gintugroan nanda tana kang sangka kwarta nga pilak. ");
INSERT INTO krj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dayon ginpamangkot na sanda, “Kay sin-o itsora kag ngaran ang nakabutang rugya?” ");
INSERT INTO krj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nagsabat sanda, “Ana kang emperador.” Amo to kag nagkuon si Jesus kananda, “Kon amo karia, itugro ninyo sa emperador ang para sa emperador kag itugro ninyo sa Dios ang para sa Dios.” ");
INSERT INTO krj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagkabati nanda karia, natingala gid sanda. Dayon nanda halin kag ginbayaan tana. ");
INSERT INTO krj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sa amo man to nga adlaw, may mga Saduceo nga nag-aragto kay Jesus. Sanda kadya amo ang nagakuon nga kon mapatay ang sangka tawo indi run dya mabanhaw. Nagkuon sanda kana, ");
INSERT INTO krj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestro, nagkuon si Moises kato nga kon mapatay ang laki nga wara sanda ti bata kang anang asawa, dapat nga pangasaw-un kang anang bugto nga laki ang nabalo agud to nga makapamata sanda para sa napatay. ");
INSERT INTO krj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kar-on, may pito rugya anay ka magburugto nga laki. Ang kagurangnan nagpangasawa kag napatay, kag tungud nga wara tana ti bata ang ana asawa ginpangasawa dya kang ana bugto. ");
INSERT INTO krj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Amo man to ang natabo sa ikarwa, kag sa ikatlo, kag hasta gid sa ikapito nga bugto. ");
INSERT INTO krj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kang urihi run, napatay man ang bayi. ");
INSERT INTO krj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kar-on, sa adlaw nga ang mga patay banhawun, kay sin-o bay tana asawa tungud hay tanan sanda nakapangasawa kana?” ");
INSERT INTO krj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nagsabat si Jesus, “Nagsayup gid kamo tungud hay wara kamo nakamaan kang ginakuon sa kasulatan ukon kang gahum kang Dios. ");
INSERT INTO krj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tungud hay sa adlaw nga ang mga patay banhawun indi run mag-arasawahay; mangin pareho run sanda kang mga anghel sa langit. ");
INSERT INTO krj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kon nahanungud tana sa pagkabanhaw, wara ninyo haw mabasa ang ginkuon kang Dios kaninyo? Nagkuon tana, ");
INSERT INTO krj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ako ang Dios ni Abraham, ang Dios ni Isaac, kag ang Dios ni Jacob.’ Dios tana kang mga buhi kag bukun ti kang mga patay.” ");
INSERT INTO krj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagkabati kang mga tawo kadya, natingala gid sanda sa anang pagpanudlo. ");
INSERT INTO krj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kar-on, kang nabatian kang mga Fariseo nga napahipus ni Jesus ang mga Saduceo, nagtiripon sanda kag nag-agto kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ang isara kananda, sangka mangin-aramun sa kasugoan. Nagpamangkot dya kay Jesus agud dakup-dakupun tana. ");
INSERT INTO krj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nagkuon dya, “Maestro, ano gid bay ang labaw sa tanan nga sugo sa kasugoan?” ");
INSERT INTO krj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nagsabat si Jesus kana, “Higugmaa ang Ginoo nga imo Dios sa bug-os nimo nga tagipusuon, sa bug-os nimo nga kalag kag sa bug-os nimo nga panghuna-huna. ");
INSERT INTO krj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Amo dya ang pinaka-importante kag labaw sa tanan nga mga sugo. ");
INSERT INTO krj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kag ang ikarwa nga sugo pareho man dyan karia: ‘Palanggaa ang imo isigka-tawo pareho kang pagpalangga nimo sa imo kaugalingun.’ ");
INSERT INTO krj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sa darwa ka mga sugo nga dya nasandig ang bug-os nga Kasugoan ni Moises kag ang mga ginsulat kang mga propeta.” ");
INSERT INTO krj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kar-on, kang nagatiriripon ang mga Fariseo, namangkot si Jesus kananda: ");
INSERT INTO krj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ano ang inyo naman-an nahanungud sa Mesias? Kay sin-o tana linahi?” Nagsabat sanda, “Linahi tana ni David.” ");
INSERT INTO krj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nagkuon si Jesus kananda, “Ti, andut haw nga paagi sa pagtuytoy kang Balaan nga Ispirito gintawag tana ni David nga Ginoo? Amo dyaay ang ana ginhambal, ");
INSERT INTO krj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ang Ginoo nagkuon sa akun Ginoo: Pungko ikaw sa akun tuo nayon, hasta nga mapierde ko ang imong mga kaaway.’ ");
INSERT INTO krj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Kar-on, kon gintawag tana ni David nga Ginoo, paano nga nangin linahi tana ni David?” ");
INSERT INTO krj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wara gid ti bisan isara kananda nga nakasabat kana, kag umpisa kato nga adlaw wara run ti may nangahas magpamangkot kana. ");
INSERT INTO krj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkatapos karia, naghambal si Jesus sa mga tawo kag sa anang mga disipulo, ");
INSERT INTO krj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ang mga manunudlo kang kasugoan kag ang mga Fariseo amo ang may awtoridad sa pagpaathag kang kasugoan ni Moises. ");
INSERT INTO krj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gani kinahanglan nga tumanun ninyo sanda kag sundon ang andang ginakuon kaninyo. Pero indi ninyo pagsundon ang andang ginahimo, tungud hay wara nanda ginahimo ang andang ginapanudlo. ");
INSERT INTO krj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ginatugroan nanda ang mga tawo kang mga mabudlay nga mga turumanun kag ipapas-an kananda. Pero sanda mismo wara nagabulig bisan gamay lang para nga masarangan dya idar-un kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ang tanan nanda nga ginahimo pakita-kita lang sa mga tawo. Ginapalapad nanda ang andang mga pilakterya Kag ginapalabug nanda ang mga kaway-kaway sa sidsid kang andang mga kunup. ");
INSERT INTO krj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa mga tabadan gusto-gusto gid nanda nga magpungko sa purungkoan kang mga dungganun kag sa mga sinagoga gusto nanda sa mga importante nga purungkoan. ");
INSERT INTO krj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kag sa mga tindahan gusto-gusto gid nanda nga tahudon sanda kang mga tawo kag tawgun, ‘Maestro.’ ");
INSERT INTO krj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero kamo tana, indi kamo dapat magpatawag nga ‘Maestro,’ tungud hay magbururugto kamo tanan kag isara lang ang inyong maestro. ");
INSERT INTO krj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kag indi ninyo pag-itawgun ang bisan sin-o rugya sa lupa nga ‘Amay,’ tungud hay isara lang ang inyo Amay nga rugto sa langit. ");
INSERT INTO krj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Indi man kamo magpatawag nga ‘Agalun,’ tungud hay isara gid lang ang inyo agalun, nga amo ang Cristo. ");
INSERT INTO krj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ang dungganun kaninyo kinahanglan nga mangin alagad ninyo. ");
INSERT INTO krj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ang bisan sin-o nga nagapadayaw kang anang kaugalingun pagapakanabaun, kag ang bisan sin-o nga nagapaubus kang anang kaugalingun pagapadunggan.” ");
INSERT INTO krj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Makaluluoy man kamo nga mga manunudlo kang kasugoan kag mga Fariseo! Kamo nga mga hipokrito! Ginabalabagan ninyo ang mga tawo nga magpasakup sa ginharian kang langit. Indi run nga daan kamo magpasakup ginabalabagan pa ninyo ang nagatinguha nga magpasakup! “ ");
INSERT INTO krj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Makaluluoy man kamo nga mga manunudlo kang kasugoan kag mga Fariseo! Kamo nga mga hipokrito! Ginapamuul ninyo ang mga pagkabutang kang mga bayi nga balo kag ginatabon-tabonan lang ninyo ang inyo mga hinimoan kang mga malawid nga pagpangamuyo! Tungud kadya tama gid kabudlay nga silot ang inyo maaguman. ");
INSERT INTO krj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Makaluluoy man kamo nga mga manunudlo kang kasugoan kag mga Fariseo! Kamo nga mga hipokrito! Ginalibot ninyo ang bilog nga kalibutan sa paghaylo kang bisan sangka tawo lang nga bukun ti Judio nga magsunod sa inyo relihiyon. Kag kon mahaylo run ninyo gani, ginahimo ninyo tana nga sobra pa kaninyo nga nagakabagay itablug sa impyerno. ");
INSERT INTO krj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makaluluoy man kamo nga mga bulag nga manugtuytoy! Gintudlo ninyo nga kon ang tawo magpanumpa nga ginagamit na nga saksi ang templo, indi kinahanglan nga tumanun na ang anang ginsaad nga to. Pero kon magpanumpa tana nga ginagamit na nga saksi ang bulawan nga rugyan sa templo, kinahanglan nga tumanun na ang anang ginsumpa. ");
INSERT INTO krj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga bulag kamo kag mga buang-buang! Sa diin bala ang mas importante, ang bulawan ukon ang templo nga nagapakabalaan sa bulawan? ");
INSERT INTO krj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kag ginatudlo pa gid ninyo nga kon ang tawo magpanumpa nga ginagamit nga saksi ang altar, indi kinahanglan nga tumanun na ang anang ginsumpa. Pero kon magpanumpa tana nga ginagamit nga saksi ang halad nga rugyan sa ibabaw kang altar, kinahanglan nga tumanun na gid ang anang ginsumpa. ");
INSERT INTO krj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga bulag gid kamo! Sa diin bala ang mas importante, ang halad ukon ang altar nga nagapakabalaan sa halad? ");
INSERT INTO krj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gani nga kon ang tawo magpanumpa sa altar, nagasumpa tana sa altar kag sa tanan nga halad nga rugyan sa altar. ");
INSERT INTO krj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kag kon magpanumpa tana sa templo, nagasumpa tana sa templo kag sa Dios nga nagaestar rugto. ");
INSERT INTO krj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kag kon magpanumpa tana sa langit, nagasumpa tana sa trono kang Dios, kag sa Dios nga nagapungko rugto. ");
INSERT INTO krj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Makaluluoy man kamo nga mga manunudlo kang kasugoan kag mga Fariseo! Kamo nga mga hipokrito! Ginatugro ninyo ang inyong ikanapulo nga bahin kang mga laswa pareho kang herbabuena, anis, kag komino pero ginapasapayan lang ninyo ang labing importante nga ginatudlo kang kasugoan nga pareho kang pagkabig sa mga tawo nga wara ti ginapasulabi, ang pagkamaluluy-on kag ang mangin matinuohon sa Dios. Kinahanglan nga himuon ninyo dya nga wara man ninyo ginapatumbayaan ang iba nga bagay. ");
INSERT INTO krj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mga bulag kamo nga manugtuytoy! Ginasara ninyo ang mga hanluk sa inyo irimnun, pero ginatulun tana ninyo ang kamelyo! ");
INSERT INTO krj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Makaluluoy gid kamo nga mga manunudlo kang kasugoan kag mga Fariseo. Kamo nga mga hipokrito! Ginahugasan ninyo ang sagwa kang inyo tasa kag likod kang pinggan, pero ang sa sulud nanda kadya amo ang mga butang nga inyo naangkun tungud kang inyo pagkahanggab kag pagpamintaha. ");
INSERT INTO krj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bulag kamo nga mga Fariseo! Limpyohi ninyo anay ang sulud kang tasa kag pinggan, kag ang sagwa nanda kadya mangin limpyo man. ");
INSERT INTO krj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Makaluluoy kamo nga mga manunudlo kang Kasugoan kag mga Fariseo. Kamo nga mga hipokrito! Pareho kamo kang mga rulubngan nga ginpintahan kang puti kag manami turukun sa sagwa, pero sa sulud puro lang tul-an kang mga patay kag tama gid kahigku. ");
INSERT INTO krj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pareho gid kamo karia, tungud hay sa panuruk kang mga tawo mga matarung kamo, pero ang matuod mga hipokrito kamo kag mga malaot.” ");
INSERT INTO krj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Makaluluoy kamo nga mga manunudlo kang kasugoan kag mga Fariseo. Kamo nga mga hipokrito! Ginahimoan ninyo kang rulubngan ang mga propeta kag ginapanami ang mga pantyon kang mga matarung nga tawo, ");
INSERT INTO krj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kag nagakuon kamo, ‘Kon rugto kami kato sa tiempo kang amun mga kaulangan, indi kami mag-imaw kananda sa pagpamatay kang mga propeta.’ ");
INSERT INTO krj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sa ginahambal ninyo nga ria, ginaako ninyo nga mga linahi kamo kang mga tawo nga nagpamatay kang mga propeta! ");
INSERT INTO krj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sige, tapusa ninyo ang gin-umpisahan kang inyo mga kaulangan! ");
INSERT INTO krj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mga kaliwat kamo kang mga sawa. Indi gid kamo makapalagyo sa silot sa impyerno! ");
INSERT INTO krj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gani, magapadara ako kaninyo kang mga propeta kag maaram nga mga tawo kag mga manunudlo kang kasugoan. Ang iba kananda pagapamatyun ninyo kag ang iba tana igalansang ninyo sa kros. Kag ang iba pa gid tana pagahanuton ninyo sa inyong mga sinagoga. Kag bisan diin nga mga lugar sanda magpalagyo pagalagsun ninyo sanda. ");
INSERT INTO krj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tungud karia, kamo ang magapanabat sa kamatayun kang tanan nga mga matarung rugya sa kalibutan, umpisa sa kamatayun kang matarung nga si Abel hasta sa kamatayun ni Zacarias nga bata ni Baraquias, nga inyo ginpatay sa tunga kang templo kag kang altar. ");
INSERT INTO krj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sugidan ko kamo: ang mga tawo sa kadya nga panag-on amo ang magapanabat sa tanan nga dya.” ");
INSERT INTO krj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kamo nga mga taga-Jerusalem ginapamatay ninyo ang mga propeta kag ginapangbato ninyo ang mga ginpadara kang Dios kaninyo. Makapira ka beses nga ginhandum ko nga tiponon kamo kag atipanun pareho kang munga nga nagatipon kang anang mga pisu sa idalum kang anang pakpak, pero indi kamo gusto! ");
INSERT INTO krj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gani kar-on, ginpatumbayaan run kang Dios ang inyo nga templo kag ana run dya ginpabay-an nga daw kamingawan. ");
INSERT INTO krj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sugidan ko kamo, indi run gid ninyo ako makita hasta sa pag-abot kang adlaw nga magakuon kamo, ‘Pakamayadun ang nagaabot sa ngaran kang Ginoo.’” ");
INSERT INTO krj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Naggwa si Jesus sa templo kag samtang nagapanaw tana nagparapit kana ang anang mga disipulo kag gintudo nanda kana ang mga kabalayan sa templo. ");
INSERT INTO krj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nagkuon si Jesus kananda, “Nakita ninyo dya tanan? Sugidan ko kamo: magakararumpag dya tanan kag wara gid ti may mabilin nga mga bato nga nagasarampawanay.” ");
INSERT INTO krj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Samtang nagapungko si Jesus sa pagpanudlo rugto sa bukid kang mga Olibo, nagparapit kana ang anang mga disipulo nga sandahanun lang. Nagkuon sanda, “Sugidi kami kon san-o matabo ang mga butang nga imo ginhambal? Kag ano bala ang mga paratandaan nga ikaw dali run lang magbalik rugya kag kon san-o ang katapusan kang kalibutan?” ");
INSERT INTO krj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nagsabat si Jesus kananda, “Mag-andam kamo nga indi kamo mapatalang ni bisan sin-o! ");
INSERT INTO krj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tungud hay duro nga mga tawo ang magaturohaw kag magapakuno-kuno nga sanda amo ako kag magakuon, ‘Ako amo ang Cristo,’ kag duro ang andang mapatalang. ");
INSERT INTO krj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makabati kamo kang mga gyera kag mga balita nga may mga gyera sa nagkalain-lain nga logar. Pero indi kamo magkahadluk. Matabo gid ang mga butang nga dya, pero bukun pa ti amo ria ang katapusan kang tanan. ");
INSERT INTO krj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tungud hay magairinaway ang mga nasyon kag amo man ang mga ginharian. Magaabot ang kagutum kag linog sa nagkalain-lain nga mga lugar. ");
INSERT INTO krj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dya tanan umpisa pa lang kang mga kabudlayan nga magaabot nga daw pareho kang pagpasakit kang sangka bayi nga manugbata.” ");
INSERT INTO krj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sa amo to nga mga inadlaw pagadakpun kamo kag itugyan sa mga tawo agud silotan kag pamatyun. Pagadumtan kamo kang tanan nga mga tawo tungud kanakun. ");
INSERT INTO krj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Duro ang magatalikod sa andang pagtuo kag magatraidor sanda sa isara kag isara, kag magadumtanay sanda. ");
INSERT INTO krj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Duro man ang magaturoaw nga mga nagapakuno-kuno nga propeta kag duro ang andang mapatalang. ");
INSERT INTO krj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Magaluntad ang kalaotan, gani nga ang gugma kang duro nga mga tawo magatahaw. ");
INSERT INTO krj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ang bisan sin-o tana nga magapadayon nga mapag-un sa anang pagtuo hasta sa katapusan, maluwas. ");
INSERT INTO krj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kag ang Mayad nga Balita nga dya nahanungud sa paghari kang Dios igawali sa bilog nga kalibutan agud to nga ang tanan nga mga tawo makabati; amo run to kag magaabot ang katapusan kang kalibutan.” ");
INSERT INTO krj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gani, kon makita ninyo nga nagatindug sa balaan nga lugar ang makangiril-ad nga butang nga ginkuon kang propeta nga si Daniel kauna (sa mga nagabasa kadya, intiendiha gid ninyo ang inyo ginabasa), ");
INSERT INTO krj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ang mga tawo nga rugyan sa Judea dapat magpalagyo sa kabukidan. ");
INSERT INTO krj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ang tawo tana nga nataboan nga rugyan sa tapan nga atup kang anang balay, indi run dapat nga magpanaog sa pagbuul kang anang pagkabutang. ");
INSERT INTO krj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ang tawo nga mataboan nga rugto sa anang uma indi run dapat mag-uli sa pagbuul kang anang kunup. ");
INSERT INTO krj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sa amo to nga mga inadlaw makaluluoy gid ang mga nagabusong kag ang mga nagapatiti. ");
INSERT INTO krj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Magpangamuyo kamo nga ang inyo pagpalagyo indi matuon sa tagraramig ukon sa Adlaw kang Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tungud hay sa tion nga ria, tuman gid kabudlay ang mga kalalat-an nga wara pa gid maaguman kang mga tawo halin kang pagtuga kang kalibutan hasta kadya, kag wara run ti may matabo nga pareho karia sa paraabuton. ");
INSERT INTO krj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pero ginpabugu run kang Dios ang tion nga ria, tungud hay kon wara na ginhimo ria, wara gid ti tawo nga mabilin. Pero tungud gid lang sa anang mga pinili, pabuguun kang Dios ang tion nga ria. ");
INSERT INTO krj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gani kon may magkuon kaninyo, ‘Dya run ang Cristo!’ ukon ‘Rugto tana!’ indi kamo magpati. ");
INSERT INTO krj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tungud hay may magaturohaw nga mga bukun ti matuod nga Cristo kag mga nagapakuno-kuno nga propeta. Magahimo sanda kang mga milagro kag mga makatiringala nga mga butang sa katuyoan nga patalangun, kon mahimo pa lang bisan ang mga pinili kang Dios. ");
INSERT INTO krj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tandai gid ninyo dya! Ginasugid ko run nga daan kaninyo ang dya nga mga butang sa wara pa matabo. ");
INSERT INTO krj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Gani nga kon may magkuon kaninyo, ‘Rugto tana sa kamingawan,’ indi kamo mag-agto rugto; ukon magkuon pa gid sanda, ‘Dyan tana sa sulud,’ indi gid kamo magpati. ");
INSERT INTO krj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tungud hay ang pag-abot kang Anak kang Tawo, mangin pareho sa kirab kang kilat nga makita halin sa sidlangan hasta sa kasalpan.” ");
INSERT INTO krj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“May hurubatun nga nagakuon, ‘Kon sa diin ang patay nga lawas, rugto man nagatiripon ang mga pispis nga buwitre.’” ");
INSERT INTO krj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Lagi-lagi, pagkatapos kang mga kalalat-an sa tion nga ria, ang adlaw magadulum, ang bulan indi run magsanag, kag ang mga bituon sa langit magakarahulog. Ang mga butang dyan sa kahawaan pagauyugun. ");
INSERT INTO krj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dayon magatuhaw sa langit ang tanda kang pag-abot kang Anak kang Tawo, kag ang tanan nga mga tawo sa kalibutan magahibi. Makita nanda ang Anak kang Tawo nga nagaabot nga ginadara kang panganod, gamhanan tana kag tuman gid ang anang pagkamahimayaun. ");
INSERT INTO krj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa mabaskug nga paghuni kang trumpeta, pagasuguon na ang anang mga anghel nga mag-agto sa tanan nga bahin kang kalibutan kag pagatiponon nanda ang mga pinili nga katawhan sa bug-os nga kalibutan.” ");
INSERT INTO krj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Turuka ninyo ang kahoy nga higera kag hangpa ninyo kon ano ang inyo maton-an dyan karia. Kon nagapanglumbay run gani dya, maman-an ninyo nga dali run lang ang tag-irinit. ");
INSERT INTO krj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sa amo man nga bagay, kon makita ninyo nga nagakaratabo run dya tanan nga mga butang, maman-an ninyo nga dali run lang tana mag-abot, kag tama run gid dya karapit. ");
INSERT INTO krj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sugidan ko kamo, magakaratabo dya tanan nga mga butang sa wara pa mapatay ang mga tawo sa dya nga panag-on. ");
INSERT INTO krj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Madura ang langit kag ang lupa, pero ang akun mga pulong magapabilin hasta san-o.” ");
INSERT INTO krj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Wara gid ti may nakamaan kon ano nga adlaw ukon oras magakaratabo ang tanan nga dya, bisan ang mga anghel sa langit ukon ang Anak, kundi ang Amay gid lang. ");
INSERT INTO krj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ang pag-abot kang Anak kang Tawo mangin pareho sa panag-on ni Noe. ");
INSERT INTO krj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tungud hay sa wara pa mag-abot ang anaw ang mga tawo nagapinagusto lang ka kaun, ka inum, kag pangasawa, hasta sa adlaw nga si Noe nagsulud sa arka. ");
INSERT INTO krj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wara gid sanda ti hinalung-ung kon ano ang matabo hasta nga nag-abot ang anaw kag nagkaralumus sanda tanan. Pareho man kadya ang matabo sa pag-abot kang Anak kang Tawo. ");
INSERT INTO krj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sa ria nga mga tinion, kon may darwa ka laki nga nagaobra sa uma; ang isara pagabul-un kag ang isara tana mabilin. ");
INSERT INTO krj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kon may darwa ka bayi nga nagagaling; ang isara pagabul-un, ang isara tana mabilin. ");
INSERT INTO krj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Gani magbantay kamo, tungud hay wara kamo kamaan kon san-o magaabot ang inyo Ginoo. ");
INSERT INTO krj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandai ninyo dyaay: kon naman-an kang tagbalay kon ano oras sa gabii magaabot ang takawan, magapulaw gid tana sa pagbantay agud to nga indi makasulud ang takawan sa anang balay. ");
INSERT INTO krj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gani dapat nga handa kamo pirme, tungud hay ang Anak kang Tawo magaabot sa oras nga wara ninyo ginapaabot.” ");
INSERT INTO krj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ang masarigan kag maaram nga surugoon amo ang ginatugyanan kang anang agalun nga magdumara sa anang kaimaw nga mga surugoon. Tana ang nagatugro kananda kang andang pagkaun sa nagakaigo nga tion. ");
INSERT INTO krj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bulahan ang surugoon nga to, kon sa pagbalik kang anang agalun makita tana nga nagahimo kang mga buruhatun nga gintugyan kana. ");
INSERT INTO krj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sugidan ko kamo nga, ipadumara kana kang anang agalun ang tanan na kadya nga mga pagkabutang. ");
INSERT INTO krj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero kon malain ang surugoon nga to, magahambal tana sa anang kaugalingun, ‘Buhay pa man magbalik ang akun agalun,’ ");
INSERT INTO krj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kag pamintasan na ang anang kaimaw nga mga surugoon kag magaimaw tana kaun kag inum sa mga paralingin. ");
INSERT INTO krj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Magaabot ang anang agalun sa adlaw nga wara na ginapaabot kag sa oras nga wara na maman-an. ");
INSERT INTO krj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sobra gid nga silot ang anang pagaagumun. Ibutang tana sa lugar nga imaw kang mga tawo nga hipokrito, rugto magahinibi sanda kag magabinagrut ang andang mga unto.” ");
INSERT INTO krj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Sa amo to nga mga tinion, ang ginharian kang langit pareho kang napulo ka mga daraga nga nagdara kang andang mga sulo sa pagsug-alaw kang nobyo nga karaslun. ");
INSERT INTO krj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ang lima kananda mga mango kag ang lima pa gid tana mga maaram. ");
INSERT INTO krj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ang mga mango nagdara kang andang mga lampara, ogaring wara sanda nagdara kang reserba nga lana. ");
INSERT INTO krj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ang mga maaram tana nagdara kang lana sa surudlan imaw kang andang mga lampara. ");
INSERT INTO krj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kag tungud nga nabuhayan ka abot ang nobyo, gintuyo sanda tanan kag naturogan. ");
INSERT INTO krj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kang tunga gabii run may nagsinggit, ‘Rugya run ang nobyo! Dali kamo, sug-alawa ninyo tana!’ ");
INSERT INTO krj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ang napulo ka mga daraga nagbugtaw kag gin-aman nanda ang andang mga lampara. ");
INSERT INTO krj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dayon ang mga mango nagkuon sa mga maaram, ‘Tugroi ninyo kami kang inyo lana hay nagakiraw run ang amun mga lampara.’ ");
INSERT INTO krj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nagsabat ang mga maaram, ‘Indi mahimo, tungud hay kon tugroan namun kamo pareho kita nga kulangun. Agto run lang kamo sa mga tyanggi kag magbakal kang para kaninyo.’ ");
INSERT INTO krj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pagkahalin kang mga mango sa pagbakal kang lana, amo man ang pag-abot kang nobyo. Ang lima nga nakaaman run nag-imaw kana nga nagsulud sa punsyon, kag ginsarado ang gawang. ");
INSERT INTO krj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wara lang gid magbuhay kag nag-abot man ang lima ka mga mango nga daraga, kag nagpanawag sanda, ‘Sir, sir, pasudla kami.’ ");
INSERT INTO krj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero nagsabat ang nobyo, ‘Ginakuon ko kaninyo, wara ako makakilala kaninyo.’” ");
INSERT INTO krj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dayon nagkuon si Jesus, “Amo gani nga kinahanglan gid nga magbantay kamo tungud hay wara kamo makamaan kon ano nga adlaw ukon oras.” ");
INSERT INTO krj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nagkuon pa gid si Jesus, “Ang ginharian kang langit pareho kang sangka tawo nga manugpanaw sa iba nga lugar. Gintawag na ang anang mga surugoon kag gintugyan kananda ang anang pagkabutang. ");
INSERT INTO krj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ang kada isara kananda gintugroan na suno sa andang masarangan. Ang isara gintugroan na kang lima ka libo nga kwarta nga bulawan, ang isara darwa ka libo nga kwarta nga bulawan kag ang isara pa gid tana gintugroan na kang sangka libo nga kwarta nga bulawan. Dayon nagpanaw tana. ");
INSERT INTO krj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ang surugoon nga nagakabaton kang lima ka libo nagpanaw kag nagnegosyo dayon kag nakaginansya tana kang lima pa gid ka libo. ");
INSERT INTO krj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amo man ang ginhimo kang nakabaton kang darwa ka libo, kag nakaginansya tana kang darwa pa gid ka libo. ");
INSERT INTO krj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ang nakabaton tana kang sangka libo nagpanaw kag nagkutkot sa lupa, kag ginlubung na ang kwarta nga gintugro kana kang anang agalun. ");
INSERT INTO krj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagkaligad kang lawid nga mga inadlaw, nagbalik ang andang agalun kag gintawag na ang mga surugoon agud sukton. ");
INSERT INTO krj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ang surugoon nga nakabaton kang lima ka libo nagparapit sa anang agalun kag nagkuon, ‘Agalun, dyaay ang lima ka libo nga gintugro nimo kanakun, kag dyaay pa gid ang lima ka libo nga akun naganansya!’ ");
INSERT INTO krj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nagkuon kana ang anang agalun, ‘Mayad ikaw kag masarigan nga surugoon! Kag tungud nga masarigan ikaw sa gamay nga kantidad, ipadumarahun ko ikaw kang mas bahul pa gid nga kantidad. Dali, magkalipay ikaw imaw kanakun!’ ");
INSERT INTO krj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ang surugoon nga nakabaton kang darwa ka libo nagparapit man kag nagkuon sa anang agalun, ‘Agalun, dyaay ang darwa ka libo nga gintugro nimo kanakun, kag dyaay pa gid ang darwa ka libo nga akun naganansya!’ ");
INSERT INTO krj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nagkuon kana ang anang agalun, ‘Mayad ikaw kag masarigan nga surugoon! Kag tungud nga masarigan ikaw sa gamay nga kantidad, ipadumarahun ko ikaw kang mas bahul pa gid nga kantidad. Dali, magkalipay ikaw imaw kanakun!’ ");
INSERT INTO krj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nagparapit man ang surugoon nga nakabaton kang sangka libo kag nagkuon sa anang agalun, ‘Agalun, naman-an ko nga wara ikaw ti kaluoy nga tawo, hay ginagarab mo ang bukun ti imo tinamnan kag ginaani mo ang bukun ti imo pinanggasan. ");
INSERT INTO krj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nahadluk ako, gani nga ginlubung ko run lang sa lupa ang imo kwarta. Dyaay run ang imo nga sangka libo.’ ");
INSERT INTO krj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nagkuon ang anang agalun, ‘Malain ikaw kag tamad nga surugoon. Naman-an nimo gali nga ginagarab ko ang bukun ti akun tinamnan kag ginaani ko ang bukun ti akun pinanggasan. ");
INSERT INTO krj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ti daad ginbutang nimo sa bangko ang akun kwarta agud nga sa akun pagbalik mabuul ko dya pati run ang anang saka.’ ");
INSERT INTO krj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dayon nagkuon ang agalun sa iba na mga surugoon, ‘Ibul-a ninyo kana ang kwarta kag itugro sa isara nga to nga may napulo ka libo. ");
INSERT INTO krj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tungud hay ang tawo nga may ana run nga ginaangkun pagatugroan pa gid kag pabuganaun pa gid dya gani. Pero sa tawo tana nga wara ti may ginaangkun, pagabul-un pa gani kana ang bisan gamay nga rugyan kana. ");
INSERT INTO krj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kag ang tawo tana nga dya nga wara ti pulos, itablug ninyo sa sagwa rugto sa madulum nga lugar, sa diin magahibi tana kag magabinagrut ang anang mga unto.’” ");
INSERT INTO krj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Naghambal pa gid si Jesus, “Kon ang Anak kang Tawo mag-abot run bilang Hari, nga ginaimawan kang tanan nga mga anghel, magapungko tana sa mahimayaun nga trono. ");
INSERT INTO krj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ang tanan nga mga tawo sa kalibutan pagatiponon sa atubang na. Dayon painun na sanda sa darwa ka grupo pareho kang pagpain kang manugbantay sa mga karnero kag mga kanding. ");
INSERT INTO krj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ang mga tawo nga matarung kaangay kang karnero ibutang na sa anang tuo kag ang mga malaot nga tawo kaangay kang kanding ibutang na sa anang wala. ");
INSERT INTO krj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kag ang Hari magakuon sa mga tawo sa anang tuo nayon, ‘Kamo nga mga ginpakamayad kang akun Amay, batona ninyo ang pagginahum kang Dios nga anang gin-aman para kaninyo halin pa kang pagtuga kang kalibutan. ");
INSERT INTO krj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tungud hay kang gin-gutum ako ginpakaun ninyo ako, kang gin-uhaw ako ginpainum ninyo ako; kang nangin pangayaw ako gin-abi-abi ninyo ako sa inyo balay. ");
INSERT INTO krj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kang wara ako ti bayo ginpabayoan ninyo ako; kang nagamasakit ako gin-atipan ninyo ako; kag kang rugto ako sa prisohan ginbisitahan ninyo ako.’ ");
INSERT INTO krj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dayon magasabat ang mga matarung, ‘Ginoo, kasan-o ikaw haw namun nakita nga nagutum kag ginpakaun namun, ukon nauhaw kag ginpainum namun? ");
INSERT INTO krj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kasan-o ikaw haw namun nakita nga nangin pangayaw kag gin-abi-abi namun sa amun balay, ukon wara ti bayo kag ginpabayoan namun? ");
INSERT INTO krj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kasan-o ikaw haw namun nakita nga nagamasakit ukon napriso kag ginbisitahan namun?’ ");
INSERT INTO krj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Magasabat ang Hari, ‘Sugidan ko kamo, kang ginhimo ninyo dya sa akun pinakakubus nga mga bugto, pareho lang nga ginhimo man ninyo dya kanakun.’” ");
INSERT INTO krj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dayon magakuon tana sa mga tawo sa ana wala nayon, ‘Parayu kamo kanakun, kamo nga mga ginpakamalaot! Rugto kamo sa kalayo nga wara nagakapalung nga gin-aman para sa Yawa kag sa anang mga sinakpan. ");
INSERT INTO krj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tungud hay kang gin-gutum ako wara ninyo ako ginpakaun, kang gin-uhaw ako wara ninyo ako ginpainum. ");
INSERT INTO krj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kang nangin dumaray-o ako wara ninyo ako gin-abi-abi sa inyo balay; kang wara ako ti bayo wara ninyo ako ginpabayoan; kang nagamasakit ako kag kang rugto ako sa prisohan wara ninyo ako gin-atipan.’ ");
INSERT INTO krj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Magasabat man sanda, ‘Ginoo, kasan-o ikaw haw namun nakita nga ginagutum ukon ginauhaw, ukon nangin dumaray-o, ukon wara ti bayo, ukon nagamasakit, ukon rugto sa prisohan kag wara namun ikaw ginbuligan?’ ");
INSERT INTO krj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kag ang Hari magasabat, ‘Sugidan ko kamo, kang wara ninyo buligi ang bisan isara sa mga pinakakubus nga dya, wara man ninyo ako ginbuligan.’ ");
INSERT INTO krj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kag sanda kadya pagapahalinun kag silotan sa wara ti katapusan. Pero ang mga matarung tana makaagum kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos hambal ni Jesus kang tanan nga mga butang nga dya, nagkuon tana sa anang mga disipulo, ");
INSERT INTO krj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Naman-an ninyo nga darwa run lang ka adlaw kag Pista run kang Paglampowas. Kag ang Anak kang Tawo igatugyan para ilansang sa kros.” ");
INSERT INTO krj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sa amo man to nga mga tinion, ang mga pangulo kang mga kaparian kag ang mga kamal-aman kang mga Judio nagtiripon sa palasyo ni Caifas nga amo ang pinakamataas nga pari, ");
INSERT INTO krj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kag ginplanohan nanda nga ipadakup si Jesus sa sekreto nga paagi kag ipapatay. ");
INSERT INTO krj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero nagkuon sanda, “Indi natun dya paghimuon sa adlaw kang pista, hay basi maggirinamo ang mga tawo.” ");
INSERT INTO krj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kang rugto si Jesus sa Betania, sa balay ni Simon nga aruon anay, ");
INSERT INTO krj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","may sangka bayi nga nagparapit kana. May dara dya nga surudlan nga alabastro nga buta kang marahalun nga agwa. Ginbu-bo na dya sa ulo ni Jesus samtang nagakaun dya. ");
INSERT INTO krj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kang makita dya kang mga disipulo naugut sanda kag nagkuon, “Ay abaw kanugon! Andut nga gin-uyangan na lang ria? ");
INSERT INTO krj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kon ginbaligya run lang raad ria sa bahul nga kantidad kag ang bayad ipanugro sa mga imol!” ");
INSERT INTO krj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naman-an ni Jesus kon ano ang andang ginhambal, gani nagkuon tana kananda, “Andut haw nga ginapahilabtan ninyo ang bayi nga dya? Mayad ang ana ginahimo nga dya kanakun. ");
INSERT INTO krj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ang mga imol kaimaw ninyo pirme. Pero ako tana, maabot ang tion nga indi run ninyo makaimaw. ");
INSERT INTO krj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ang ginhimo na nga pagbu-bo kang agwa sa akun lawas amo nga para iaman ako sa akun lubung. ");
INSERT INTO krj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sugidan ko kamo, bisan diin man iwali sa bilog nga kalibutan ang Mayad nga Balita nga dya, ang anang ginhimo nga dya isambitun man bilang pagdumdum kana.” ");
INSERT INTO krj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kar-on, si Judas Iscariote nga isara sa mga napulo'g darwa ka mga disipulo nag-agto sa mga pangulo kang kaparian. ");
INSERT INTO krj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nagkuon tana kananda, “Kon buligan ko kamo nga madakup si Jesus, ano bay ang inyo itugro kanakun?” Gintugroan nanda tana kang 30 ka bilog nga pilak. ");
INSERT INTO krj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Umpisa kato, nagpangita si Judas kang kahigayonan sa pagloib kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kar-on, kang nahauna nga adlaw kang Pista kang Tinapay nga wara ti Tapay, nagparapit kay Jesus ang anang mga disipulo kag nagpamangkot, “Sa diin mo gusto nga mag-aman kami kang yapon para sa Pista kang Paglampowas?” ");
INSERT INTO krj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ginkun-an sanda ni Jesus, “Agto kamo sa sangka tawo sa syudad, kag kon-an ninyo tana, ‘Ang maestro nagkuon, nga ang anang tion nag-abot run. Tana kag ang anang mga disipulo sa imo balay magasaulog kang Pista kang Paglampowas.’” ");
INSERT INTO krj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gintuman kang mga disipulo ang ginkuon ni Jesus kananda, kag nag-aman sanda kang panihapon para sa Pista. ");
INSERT INTO krj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kang gabii run, si Jesus kag ang anang napulo'g darwa ka mga disipulo nag-ayapon. ");
INSERT INTO krj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Samtang nagakaun sanda, nagkuon si Jesus, “Sugidan ko kamo, ang isara kaninyo magaloib kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nasubuan gid sanda kamayad kag nagmansig pamangkot sanda kana, “Ginoo, ako bala ang imo ginatumud?” ");
INSERT INTO krj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nagsabat si Jesus, “Ang isara kaninyo nga nagasawsaw kang tinapay sa yahong imaw kanakun amo ang magaloib kanakun. ");
INSERT INTO krj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ang Anak kang Tawo magataliwan suno sa ginakuon sa kasulatan, pero makaluluoy lang ang tawo nga magaloib kana! Mas mayad pa nga wara run lang matawo ang tawo nga to.” ");
INSERT INTO krj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Si Judas, nga amo ang magaloib kana, nagkuon man, “Maestro, ako bala ang imo ginatumud?” Nagsabat si Jesus, “Ikaw karia ang nagkuon.” ");
INSERT INTO krj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Samtang nagakaun sanda, nagbuul si Jesus kang tinapay, kag nagpangamuyo sa pagpasalamat. Dayon ginpamihak-pihak na dya kag gintugro sa anang mga disipulo kag nagkuon, “Batona ninyo, kag kan-a. Amo dya ang akun lawas.” ");
INSERT INTO krj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dayon nagbuul tana kang kopa kag nagpangamuyo sa pagpasalamat, kag gintugro na dya sa anang mga disipulo kag nagkuon, “Tanan kamo mag-inum kadya. ");
INSERT INTO krj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tungud hay dya ang akun dugo nga nagaparig-un kang kasugtanan kang Dios; ang akun dugo nga gin-ula para sa duro nga mga tawo para sa kapatawaran kang mga kasal-anan. ");
INSERT INTO krj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sugidan ko kamo, indi run ako liwan mag-inum ka dya nga bino nga halin sa ubas hasta sa adlaw nga mag-inum ako kang bag-o nga bino imaw ninyo sa ginharian kang akun Amay.” ");
INSERT INTO krj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dayon nagkanta sanda kang sangka karantahun kag pagkatapos nag-agto sanda sa Bukid kang mga Olibo. ");
INSERT INTO krj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kar-on, ginkun-an sanda ni Jesus, “Kadya nga gabii tanan kamo magaparalagyo kag magabiya kanakun, tungud hay nagkuon ang Dios sa kasulatan, ‘Pagapatyun ko ang manugbantay, kag magaharaplaag ang panung kang mga karnero.’ ");
INSERT INTO krj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero pagkatapos nga banhawun ako, mauna ako kaninyo rugto sa Galilea.” ");
INSERT INTO krj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nagkuon si Pedro kay Jesus, “Bisan tanan sanda magbiya kanimo, ako tana indi gid!” ");
INSERT INTO krj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nagkuon si Jesus kana, “Sugidan ko ikaw, sa kadya nga gabii antes magpamalo ang sulog, ipanginwara mo ako kang tatlo ka beses.” ");
INSERT INTO krj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nagsabat si Pedro, “Indi ko gid ikaw pag-ipanginwara bisan patyun pa nanda ako imaw kanimo!” Amo man dya ang ginkuon kang tanan nga mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dayon nag-agto si Jesus sa lugar nga ginatawag Getsemane imaw kang anang mga disipulo kag nagkuon tana kananda, “Pungko kamo rugya hay maagto ako rugto sa uruonahan para magpangamuyo.” ");
INSERT INTO krj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gin-imaw na si Pedro kag ang darwa ka bata ni Zebedeo. Nagbatyag tana kang kasubu kag natublag gid tana. ");
INSERT INTO krj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nagkuon tana kananda, “Sobra gid nga kasubu ang akun nabatyagan nga daw sa mapatay ako. Rugya lang kamo kag indi kamo magturog!” ");
INSERT INTO krj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dayon nag-agto tana sa uruonahan nayon, nagharapaun tana kag nagpangamuyo, “Amay ko, kon mahimo ilikaw kanakun ang pag-antos nga dya nga akun pagaagumun! Pero bukun ti akun kabubut-un ang matuman kundi ang imo.” ");
INSERT INTO krj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dayon, nagbalik tana sa tatlo ka mga disipulo kag nakita na sanda nga nagakaraturog. Nagkuon tana kay Pedro, “Indi gid kamo haw makapulaw imaw kanakun bisan sangka oras lang? ");
INSERT INTO krj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpulaw kamo kag magpangamuyo, agud to nga indi kamo madaug kang pagsulay. Buut ninyo maghimo kang mayad pero ang inyo lawas maluya.” ");
INSERT INTO krj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nagparayu liwan si Jesus kag nagpangamuyo, “Amay ko, kon ang dya nga pag-antos indi malikaw kanakun, kundi nga pagaagumun ko gid dya, ang imo kabubut-un amo ang matuman.” ");
INSERT INTO krj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nagbalik liwan tana kag nakita na ang anang mga disipulo nga nagakaraturog, tungud hay sobra gid ang andang katoyo. ");
INSERT INTO krj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ginbayaan sanda liwan ni Jesus, nagparayu tana kag nagpangamuyo sa ikatlo nga bes, kang amo man angud nga pangamuyo. ");
INSERT INTO krj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dayon nagbalik tana sa anang mga disipulo kag nagkuon, “Nagakaturog man angud kamo kag nagapahuway-huway? Dya run! Nag-abot run ang tion nga ang Anak kang Tawo igatugyan sa alima kang mga tawo nga makasasala. ");
INSERT INTO krj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangon kamo dyan, mapanaw run kita. Sulnga ninyo, rugya run ang tawo nga magaloib kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nagahambal pa si Jesus kag nag-abot si Judas nga isara sa mga napulo'g darwa ka mga disipulo. May imaw tana nga duro nga mga tawo nga nagadara kang mga espada kag mga ralampus. Sanda kadya ginsugo kang mga pangulo kang mga kaparian kag mga kamal-aman kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ginkun-an run sanda nga daan kang traidor kon ano ang anang isenyas. Kuon na, “Ang tawo nga akun iharkan amo ria tana! Dakpa ninyo dayon.” ");
INSERT INTO krj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nagparapit dayon si Judas kay Jesus kag nagkuon, “Kamusta ikaw, Maestro!” dayon ginharkan na si Jesus. ");
INSERT INTO krj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nagsabat si Jesus kana, “Amigo, himoa lagi ang gusto nimo himuon.” Dayon nagparapit sanda kag gindakup si Jesus, kag ginsiguro nga indi gid tana makapalagyo. ");
INSERT INTO krj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ang isara sa mga imaw ni Jesus naggabot kang anang espada kag ginlabo ang oripun kang pinakamataas nga Pari kag nautas ang talinga na kadya. ");
INSERT INTO krj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ginkun-an tana ni Jesus, “Itagub ang imong espada, tungud hay ang nagagamit kang espada sa espada man mapatay. ");
INSERT INTO krj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wara ikaw haw nakamaan nga sarang ako makapangayo kang bulig sa akun Amay kag lagi-lagi magapadara tana kang napulo'g darwa ka batalyon nga mga anghel? ");
INSERT INTO krj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ogaring kon himuon ko ria, paano bay matuman ang ginakuon sa kasulatan nga kinahanglan gid nga amo dya ang matabo?” ");
INSERT INTO krj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dayon nagkuon si Jesus sa mga tawo, “Buyung ako haw nga kinahanglan gid nga magdara pa kamo kang mga espada kag mga ralampus sa pagdakup kanakun? Adlaw-adlaw nagatudlo ako rugto sa templo, pero wara man ninyo ako pagdakpa. ");
INSERT INTO krj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ang tanan nga dya natabo para matuman ang mga ginsulat kang mga propeta sa kasulatan.” Dayon ginbayaan tana kang mga disipulo, kag nagparalagyo sanda tanan. ");
INSERT INTO krj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kar-on, gindara si Jesus kang mga nagdakup kana rugto kay Caifas, ang pinakamataas nga pari. Rugto nagtiriripon ang mga manunudlo kang kasugoan kag ang mga kamal-aman kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro tana nagsunod man, pero rayu ang anang antad kay Jesus. Nagsunod tana hasta sa lagwerta kang balay kang pinakamataas nga Pari. Dayon nagsulud tana, kag nagpungko imaw kang mga gwardya sa paghulat kon ano ang matabo. ");
INSERT INTO krj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ang mga pangulo kang mga kaparian kag ang bilog nga katapo kang konseho nagapangita kang bukun ti matuod nga mga ebidensya batok kay Jesus para nga may rason sanda nga ipapatay tana. ");
INSERT INTO krj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero wara gid sanda ti may nakita, bisan pa nga duro ang nagparapit kag nagsugid kang butig kontra kana. Kang urihi run, may nagparapit nga darwa ka tawo ");
INSERT INTO krj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kag nagkuon, “Dya nga tawo nagkuon, ‘Sarang ko gub-un ang templo kang Dios kag sa sulud kang tatlo ka adlaw patindugun ko dya liwan.’” ");
INSERT INTO krj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ang pinakamataas nga pari nagtindug kag nagkuon kay Jesus, “Wara bala ikaw ti isabat sa akusasyon nanda kontra kanimo?” ");
INSERT INTO krj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero wara gid maglimug si Jesus. Ang pinakamataas nga pari nagkuon kana, “Sa ngaran kang Dios nga buhi magsugid ikaw, kon ikaw gid man ang Cristo, ang Anak kang Dios.” ");
INSERT INTO krj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nagsabat si Jesus kana, “Ginkuon mo run. Pero sugidan ko kamo: halin kadya makita ninyo ang Anak kang Tawo nga nagapungko sa tuo nayon kang makagagahum nga Dios, kag makita man ninyo nga nagaabot nga ginadara kang panganod!” ");
INSERT INTO krj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagkabati kadya kang pinakamataas nga pari, gin-gisi na ang anang kunup sa kaugut kag nagkuon, “Ginpasipalahan na ang Dios! Indi run natun kinahanglan kang mga testigo. Nabatian run ninyo ang anang pagpasipala sa Dios. ");
INSERT INTO krj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ti, ano bay ang inyo desisyon?” Nagsabat sanda, “Dapat tana mapatay!” ");
INSERT INTO krj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dayon gindupraan nanda ang anang pungyahun kag ginsumbag nanda tana. Kag ang iba tana, gintampa tana ");
INSERT INTO krj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kag nagkuon sanda, “Cristo, lat-a kon sin-o ang nagtampa kanimo!” ");
INSERT INTO krj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kar-on, si Pedro tana nagapungko rugto sa lagwerta. Nagparapit kana ang sangka surugoon nga bayi kag nagkuon, “Indi bala nga imaw man ikaw ni Jesus nga taga-Galilea?” ");
INSERT INTO krj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero ginpanginwara na dya sa atubang nanda tanan nga nagakuon, “Wara ako kamaan kon ano ang imo ginapanghambal nga ria.” ");
INSERT INTO krj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dayon nag-agto tana sa pwertahan. Nakita pa gid tana kang sangka surugoon nga bayi kag nagkuon dya, “Dya nga tawo imaw man ni Jesus nga taga-Nazaret.” ");
INSERT INTO krj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ginpanginwara liwan dya ni Pedro nga nagakuon, “Ginasumpa ko nga wara ako makakilala sa tawo nga ria.” ");
INSERT INTO krj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Burubuhay kato, ang mga tawo nga nagatirindug rugto nagparapit kay Pedro kag nagkuon, “Matuod gid nga isara man ikaw kananda. Maman-an gid sa imo panghambal!” ");
INSERT INTO krj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dayon nagkuon si Pedro, “Ginasumpa ko, wara ako makakilala sa tawo nga ria, bisan silotan pa ako kang Dios.” Sa amo man to nga tion namalo ang sulog, ");
INSERT INTO krj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kag nadumduman ni Pedro ang ginkuon ni Jesus, “Antes magpamalo ang sulog, ipanginwara mo ako kang tatlo ka beses!” Naggwa si Pedro kag naghiribiun gid kamayad. ");
INSERT INTO krj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aga pa gid kang masunod nga adlaw, nagsapol ang mga pangulo kang kaparian kag ang mga kamal-aman kang mga Judio kon ano ang anda himuon para ipapatay si Jesus. ");
INSERT INTO krj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gin-gapos nanda tana kag gindara kag gintugyan kay Pilato nga gobernador. ");
INSERT INTO krj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kar-on, kang naman-an kang traidor nga si Judas, nga ginsentensyahan run si Jesus kang kamatayun, nangusul tana kag ginbalik na ang 30 ka bilog nga pilak sa mga pangulo kang mga kaparian kag sa mga kamal-aman kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nagkuon tana, “Nakasala ako tungud hay ginloiban ko ang tawo nga wara ti sala.” Nagsabat sanda, “Ti, ano ang labut namun, imo tana ria problema!” ");
INSERT INTO krj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ginpilak ni Judas ang kwarta sa sulud kang templo. Dayon nagpanaw tana kag nagbitay kang anang kaugalingun. ");
INSERT INTO krj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ginpamurot kang mga pangulo kang kaparian ang kwarta kag nagkuon, “Dya nga kwarta gin-gamit bilang bayad sa kabuhi kang tawo, kag supak sa atun kasugoan nga ibutang dya sa taragoan kang kwarta kang templo.” ");
INSERT INTO krj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kag nagsugtanay sanda nga ang kwarta nga to itaba nanda kang lupa kang manug-koron agud himuon nga rulubngan kang mga dumaray-o. ");
INSERT INTO krj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Amo ria nga hasta kadya ang lupa nga to gintawag nga “Lupa kang Dugo.” ");
INSERT INTO krj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gani nga natuman ang ginkuon ni Propeta Jeremias, “Ginbuul nanda ang 30 ka bilog nga pilak nga ginkasugtan kang mga katawhan kang Israel nga bili para kana, ");
INSERT INTO krj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kag gintaba nanda dya kang lupa kang manug-koron. Amo dya ang ginkuon kang Ginoo kanakun.” ");
INSERT INTO krj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kar-on, ginpaatubang si Jesus kay Pilato nga gobernador kag ginpamangkot na si Jesus, “Ikaw bala ang hari kang mga Judio?” Kag nagsabat si Jesus, “Ginkuon mo run.” ");
INSERT INTO krj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pero wara tana magsabat sa mga akusasyon kang mga pangulo kang kaparian kag kang mga kamal-aman kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Amo to kag ginkun-an tana ni Pilato, “Wara mo haw mabatii ang andang mga akusasyon batok kanimo?” ");
INSERT INTO krj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero wara gid magsabat si Jesus bisan sangka tinaga lang, gani natingala gid ang gobernador. ");
INSERT INTO krj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kar-on, kada Pista kang Paglampowas kinabatasan kang gobernador nga maghilway kang sangka priso nga ginapangayo kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa amo man to nga tion may sangka bantog nga priso nga ginahingaranan kay Jesus Barabas. ");
INSERT INTO krj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gani kang nagtiripon run ang mga tawo, namangkot si Pilato kananda, “Sin-o ang gusto ninyo nga ihilwayun ko, si Jesus Barabas ukon si Jesus nga ginatawag Cristo?” ");
INSERT INTO krj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Naman-an ni Pilato nga gintugyan nanda kana si Jesus tungud hay nahisa sanda. ");
INSERT INTO krj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Samtang nagapungko si Pilato sa purungkoan kang hukum, nagpadara kana kang mensahe ang anang asawa nga nagakuon, “Indi paghilabti ang tawo nga ria; wara tana ti sala. Kabii, natublag gid ako kang akun damgo nahanungud kana.” ");
INSERT INTO krj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ang mga pangulo kang mga kaparian kag ang mga kamal-aman kang mga Judio tana, ginasutsot nanda ang mga tawo nga si Barabas ang anda pangayuon nga ihilwayun, kag si Jesus tana ipapatay. ");
INSERT INTO krj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ginpamangkot sanda liwan ni Pilato, “Sin-o bala kananda nga darwa ang gusto ninyo nga akun ihilwayun?” Nagsabat sanda, “Si Barabas!” ");
INSERT INTO krj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Namangkot kananda si Pilato, “Ti, ano tana bay ang akun himuon kay Jesus nga ginatawag Cristo?” Nagsabat sanda, “Ilansang tana sa kros!” ");
INSERT INTO krj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pero namangkot si Pilato, “Andut haw? Ano haw ang nahimo na nga sala?” Pero gintudohan pa gid gani nanda ka singgit, “Ilansang tana sa kros!” ");
INSERT INTO krj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kang makita ni Pilato nga wara run tana ti sarang mahimo, kag basi maggirinamo pa ang mga tawo, nagpabuul tana kang tubig kag manghugas kang anang alima sa atubang kang mga tawo kag nagkuon, “Wara ako ti sarabtun sa kamatayun kang tawo nga ria. Inyo tana ria sarabtun!” ");
INSERT INTO krj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nagsabat ang tanan nga mga tawo, “Kami kag ang amun mga kabataan ang magapanabat kang anang kamatayun!” ");
INSERT INTO krj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Amo to kag ginhilway ni Pilato si Barabas para kananda. Si Jesus tana ginpahanot na kag gintugyan sa mga suldado agud ilansang sa kros. ");
INSERT INTO krj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kar-on, gindara kang mga suldado kang gobernador si Jesus sa palasyo, kag gintiponan tana kang sangka batalyon nga mga suldado. ");
INSERT INTO krj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gin-ubahan nanda tana, kag ginpasuksokan kang kapa nga kolor granati. ");
INSERT INTO krj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dayon naghimo sanda kang koro-korona nga puro tunuk kag ginbutang dya sa ulo ni Jesus, kag ginpakaput nanda sa anang tuo nga alima ang surusungkod, kag nagluhod-luhod sanda sa atubang na kag ginyagota nanda tana nga nagakuon, “Dayawun ikaw nga Hari kang mga Judio!” ");
INSERT INTO krj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gindupraan nanda tana kag ginbuul ang anang ginakaptan nga surusungkod kag ginpakdol dya sa anang ulo. ");
INSERT INTO krj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos nanda ka yagota kana, gin-uba nanda ang kapa kag ginpasuksok nanda liwan kana ang anang bayo. Dayon gindara nanda tana sa sagwa agud ilansang sa kros. ");
INSERT INTO krj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kar-on kang nagapagwa sanda sa syudad, may nasug-alaw sanda nga sangka tawo nga taga-Cirene nga ginahingaranan kay Simon. Ginpirit tana kang mga suldado nga magpas-an kang kros ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagkaabot nanda sa lugar nga ginatawag Golgota (nga kon sayudon Logar kang Bagol), ");
INSERT INTO krj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","gintugroan nanda si Jesus kang bino nga nasimbogan kang apdo, pero kang madimdiman na dya, wara na dya gin-inum. ");
INSERT INTO krj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ginlansang nanda tana sa kros, kag ginhururay nanda ang anang bayo paagi sa paggabot-gabot. ");
INSERT INTO krj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagkatapos nagpungko sanda kag ginbantayan tana. ");
INSERT INTO krj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa anang ulohan nayon gintapik nanda ang karatula nga nasulat rugto ang andang akusasyon kontra kana, nga nagakuon, “Dya si Jesus, ang Hari kang mga Judio.” ");
INSERT INTO krj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","May darwa ka takawan nga ginlansang man rugto imaw kay Jesus, ang isara sa anang tuo nayon, kag ang isara tana sa anang wala. ");
INSERT INTO krj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ang mga tawo tana nga nagaaragi rugto nagaulung-ulung kang anda mga ulo kag nagyagota kana nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Indi bala nga pagagub-un mo ang templo, kag sa sulud lang kang tatlo ka adlaw patindugun mo dya liwan? Luwasa ang imo kaugalingun! Kon ikaw ang Anak kang Dios, panaog dyan sa kros!” ");
INSERT INTO krj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ginyagota man tana kang mga pangulo kang kaparian, kang mga manunudlo kang kasugoan kag kang mga kamal-aman kang mga Judio. Kuon nanda, ");
INSERT INTO krj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ginluwas na ang iba, pero ang kaugalingun na tana indi na maluwas! Indi bala nga tana ang Hari kang Israel? Kon magpanaog tana kadya sa kros, matuo kami kana! ");
INSERT INTO krj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nagasarig tana sa Dios kag nagakuon nga tana ang Anak kang Dios! Ti, turukun ta kon gusto kang Dios nga iluwasun tana!” ");
INSERT INTO krj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bisan ang mga takawan nga ginlansang imaw kay Jesus amo man karia ang pagyagota nanda kana. ");
INSERT INTO krj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Umpisa kang udto adlaw hasta mag-alas tres ti hapon nagdulum ang bilog nga kalibutan. ");
INSERT INTO krj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kang mga alas tres run ti hapon nagsinggit si Jesus sa mabaskug nga limug, “Eli, Eli, lema sabactani?” nga buut hambalun, “Dios ko, Dios ko, andut haw nga ginpabay-an mo ako?” ");
INSERT INTO krj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nabatian dya kang iba nga mga nagatirindug rugto kag nagkuon sanda, “Ginatawag na si Elias!” ");
INSERT INTO krj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lagi-lagi ang isara kananda nagdalagan kag nagbuul kang espongha. Gintusmog na dya sa maaslum nga bino, kag ginbutang sa punta kang sanga kang kahoy kag gintunghol dya sa ba-ba ni Jesus para ipainum kana. ");
INSERT INTO krj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ang iba tana nagkuon, “Dali lang, turukun ta kon maabot si Elias para luwasun tana!” ");
INSERT INTO krj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nagsinggit liwan si Jesus kang mabaskug kag nabugto ang anang ginhawa. ");
INSERT INTO krj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa amo gid to nga tion, ang kurtina sa templo napihak sa tunga, halin sa ibabaw paidalum. Naglinog kag nagkarabuka ang mga bato; ");
INSERT INTO krj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ang mga rulubngan nagburokas, kag duro nga mga katawhan kang Dios nga nagkaramatay kauna ang nabuhi liwan. ");
INSERT INTO krj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Naggurowa sanda sa rulubngan, kag kang pagkabanhaw ni Jesus nag-agto sanda sa Balaan nga Syudad kag duro nga mga tawo ang nakakita kananda. ");
INSERT INTO krj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ang kapitan kag ang anang mga suldado nga nagabantay kay Jesus, kang mabatyagan nanda ang linog kag nakita ang tanan nga nagkaratabo, hinadlukan gid sanda kag nagkuon, “Matuod gid man nga tana Anak kang Dios!” ");
INSERT INTO krj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Duro man nga mga bayi rugto sa uruonahan ang nagalantaw. Sanda kadya nagsunod kay Jesus halin pa sa Galilea kag nagbulig kana. ");
INSERT INTO krj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Abay run kananda sanday Maria Magdalena, si Maria nga nanay nanday Santiago kag Jose, kag ang nanay kang mga bata ni Zebedeo. ");
INSERT INTO krj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kang sirum run, nag-abot ang sangka tawo nga manggaranun nga taga-Arimatea. Ang ngaran na kadya amo si Jose kag sangka sumurunod man ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nag-agto tana kay Pilato kag ana ginpangayo ang bangkay ni Jesus. Dayon nagmando si Pilato nga itugro dya kana. ");
INSERT INTO krj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gani ginbuul man ni Jose ang bangkay kag ginbarahosan kang bag-o nga tela nga lino. ");
INSERT INTO krj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kag ginbutang na dya sa anang kaugalingun nga rulubngan, nga bag-o lang gin-giab sa bato. Dayon ginpaligid na ang bahul nga bato sa pwertahan kang rulubngan kag pagkatapos kato nagpanaw tana. ");
INSERT INTO krj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena kag ang sangka Maria pa gid rugto man nga nagapungko nga nagaatubang sa rulubngan. ");
INSERT INTO krj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kang masunod nga adlaw kato, nga bali amo run ang Adlaw nga Inugpahuway, nag-agto kay Pilato ang mga pangulo kang kaparian kag ang mga Fariseo. ");
INSERT INTO krj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nagkuon sanda, “Sir, nadumduman namun nga kang buhi pa ang impostor nga to nagkuon tana nga mabanhaw tana pagkaligad kang tatlo ka adlaw. ");
INSERT INTO krj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gani mayad gid nga pabantayan mo ka mayad ang anang rulubngan hasta sa ikatlo nga adlaw. Basi bala haw nga maagto ang anang mga disipulo kag takawun ang anang bangkay kag magpanugid sanda sa mga tawo nga nabanhaw tana. Kon matabo dya, ang pagpangluko nanda nga dya mas sobra pa sangsa una.”s ");
INSERT INTO krj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nagkuon si Pilato kananda, “Sige, dara kamo kang gwardya! Panaw kamo, kag pabantayi ninyo ka mayad ang rulubngan.” ");
INSERT INTO krj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Amo to kag nagpanaw sanda kag ginsilyohan nanda ang bato nga nagatakup sa rulubngan, kag pagkatapos ginpabantayan dya sa mga gwardya. ");
INSERT INTO krj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkatapos kang Adlaw nga Inugpahuway, aga-aga pa gid kang nahauna nga adlaw kang semana, si Maria Magdalena kag ang sangka Maria pa gid, nagpanaw para lantawun ang rulubngan. ");
INSERT INTO krj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Golpi lang nga naglinog kang mabaskug; tungud hay may anghel kang Ginoo nga nagkunsad halin sa langit. Ginpaligid na ang bato nga nagatakup sa rulubngan kag ginpungkoan na dya. ");
INSERT INTO krj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ang anang dagway makasirilaw nga pareho kang kilat, kag ang anang bayo tama gid kaputi. ");
INSERT INTO krj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nagkurudug sa kahadluk ang mga gwardya kag nagkaratumba sanda nga daw mga patay. ");
INSERT INTO krj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nagkuon ang anghel sa mga bayi, “Indi kamo magkahadluk. Naman-an ko nga ginapangita ninyo si Jesus nga ginlansang sa kros. ");
INSERT INTO krj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wara tana rugya. Ginbanhaw tana, pareho kang anang ginkuon. Dali kamo rugya kag sulnga ninyo ang lugar nga ginhamyangan kana. ");
INSERT INTO krj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Panaw kamo lagi, kag sugidan ang anang mga disipulo nga nabanhaw tana kag magauna kaninyo sa Galilea. Rugto ninyo tana makita! Indi gid ninyo paglipati ang ginkuon ko kaninyo.” ");
INSERT INTO krj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gani nagdali-dali sanda nga naghalin sa rulubngan. Nagabatyag sanda kang tuman nga kahadluk pero nagakalipay man, kag nagdalagan sanda agud sugidan ang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Golpi lang nga ginsug-alaw sanda ni Jesus nga nagakuon, “Magkalipay kamo!” Dayon nagparapit sanda kana kag ginkupkupan ang anang kahig kag ginsimba nanda tana. ");
INSERT INTO krj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nagkuon si Jesus kananda, “Indi kamo magkahadluk. Panaw kamo kag sugidi ninyo ang akun mga kabugtoan nga mag-agto sanda sa Galilea kag rugto nanda ako makita.” ");
INSERT INTO krj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Samtang ang mga bayi nagapaagto sa mga disipulo, ang iba nga mga gwardya nag-agto sa syudad kag nagpanugid sa mga pangulo kang kaparian kang tanan nga mga natabo. ");
INSERT INTO krj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Amo to kag nagsinapol ang mga pangulo kang kaparian kag ang mga kamal-aman kang mga Judio. Kag naghisugot sanda nga tugroan kang bahul nga kantidad ang mga suldado, ");
INSERT INTO krj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kag ginkun-an sanda, “Ipanugid ninyo nga ang anang mga disipulo nag-abot kang kagab-ihun kag gintakaw ang anang bangkay samtang nagakaturog kamo. ");
INSERT INTO krj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kag kon mabatian man dya kang gobernador, kami lang ang maaram mag-istorya kana, kag indi run kamo magpalibug.” ");
INSERT INTO krj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ginbaton kang mga gwardya ang kwarta kag ginhimo nanda kon ano ang ginkuon kananda. Halin kato hasta kadya amo ria ang istorya nga ginapanugid kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kar-on, ang napulo'g isara ka mga disipulo nag-agto sa Galilea rugto sa bakulod nga sa diin ginkuon ni Jesus nga mag-agto sanda. ");
INSERT INTO krj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kang makita nanda si Jesus, ginsimba nanda tana, bisan pa nga ang iba kananda nagapangduha-duha. ");
INSERT INTO krj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nagparapit si Jesus kananda kag nagkuon. “Ang tanan nga awtoridad sa langit kag sa lupa gintugro run kanakun. ");
INSERT INTO krj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gani, panaw kamo kag himoa ninyo nga akun sumurunod ang tanan nga mga tawo sa kalibutan. Bawtisohi ninyo sanda sa ngaran kang Amay, kang Anak kag kang Balaan nga Ispirito, ");
INSERT INTO krj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kag tudlo-i ninyo sanda nga magtuman kang tanan nga ginsugo ko kaninyo. Dumduma gid ninyo nga kaimaw ninyo ako pirme hasta sa katapusan kang kalibutan.”");
INSERT INTO krj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Amo dya ang Mayad nga Balita nahanungud kay Jesu-Cristo nga Anak kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nag-umpisa dya katong matuman ang ginsulat ni propeta Isaias: “Kuon kang Dios, ‘Ipadara ko una kanimo ang akun manugbalita sa pag-aman kang imong aragyan.’ ");
INSERT INTO krj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","May nagasinggit rugto sa naligwin nga lugar, ‘Iaman ninyo ang dalan kang Ginoo, kag tadlunga ninyo ang anang mga pagaagyan.’” ");
INSERT INTO krj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gani nag-abot si Juan rugto sa naligwin nga lugar nga nagapangbawtiso kag nagapangwali, “Maghirinulsul kamo kag magbiriya sa inyong mga sala kag magpabawtiso agud to nga patawarun kamo sa inyo mga sala.” ");
INSERT INTO krj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Duro-duro gid nga mga tawo halin sa probinsya kang Judea kag sa Jerusalem ang nag-aragto kay Juan. Ginpangtuad nanda ang andang mga kasal-anan kag ginbawtisohan sanda ni Juan sa suba kang Jordan. ");
INSERT INTO krj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ang panaptun ni Juan nahuman sa bulbol kang sapat nga kamelyo kag may wagkus nga panit sa anang hawak. Ang anang ginakaun apan kag dugus nga naghalin sa talon. ");
INSERT INTO krj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ginabantala na sa mga tawo, “May magaabot sunod kanakun nga mas gamhanan pa kanakun. Bukun ako ti takus bisan sa paghubad lang kang higot kang anang sandalyas. ");
INSERT INTO krj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ginabawtisohan ko kamo sa tubig, pero pagabawtisohan na kamo sa Balaan nga Ispirito.” ");
INSERT INTO krj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kang mga tinion man nga to, nag-abot si Jesus halin sa banwa kang Nazaret nga sakup kang probinsya kang Galilea, kag ginbawtisohan tana ni Juan sa suba kang Jordan. ");
INSERT INTO krj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kang nakatakas run si Jesus sa suba, nakita na nga nagabukas ang langit kag nagkunsad kana nga daw pating ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kag may limug nga nabatian halin sa langit nga nagakuon, “Ikaw ang akun hinigugma nga Anak, nga akun gid nahamut-an.” ");
INSERT INTO krj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lagi-lagi ginpaagto si Jesus kang Balaan nga Ispirito sa kamingawan ");
INSERT INTO krj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","nga sa diin rugto tana kang kap-atan ka adlaw nga ginasulay ni Satanas. May mga sapat man rugto nga talonon, kag gin-atipan tana kang mga anghel. ");
INSERT INTO krj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kar-on, kang ginpriso si Juan, nag-agto si Jesus sa Galilea nga nagapangwali kang mayad nga balita nga naghalin sa Dios. ");
INSERT INTO krj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nagkuon tana, “Nag-abot run ang nagakaigo nga tion kag nagahirapit run ang paghari kang Dios. Maghirinulsul kamo sa inyong mga sala kag magpati sa Mayad nga Balita.” ");
INSERT INTO krj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Samtang nagapanaw si Jesus sa binit kang Linaw kang Galilea, nakita na ang magbugto nga sanday Simon kag Andres nga nagaladlad kang pukot tungud hay mga mangingisda sanda ka dya. ");
INSERT INTO krj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ginkun-an sanda ni Jesus, “Sunod kamo kanakun kag tudloan ko kamo nga magpangdara kang mga tawo nga magasunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lagi-lagi ginbayaan nanda ang andang mga pukot kag magsunod kana. ");
INSERT INTO krj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nagpadayon pa gid si Jesus sa pagpanaw kag sa uruunahan may nakita pa gid tana nga magbugto nga sanday Santiago kag Juan nga mga bata ni Zebedeo. Sa andang baruto sanda ka dya nga nagapamuna kang andang pukot. ");
INSERT INTO krj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pagkakita kananda ni Jesus, gintawag na dayon sanda; ginbayaan nanda ang andang tatay nga si Zebedeo sa baruto imaw kang mga tawo nga andang ginasuholan, kag magsunod kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nag-agto sanday Jesus sa banwa kang Capernaum. Pag-abot kang Adlaw nga Inugpahuway, nag-agto si Jesus sa sinagoga kag nagpanudlo sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Natingala gid ang mga tawo sa anang pagpanudlo, tungud hay nagapanudlo tana nga may awtoridad, kag bukun ti pareho kang mga manunudlo kang kasugoan. ");
INSERT INTO krj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa hinali lang, may nagsulud sa sinagoga nga sangka laki nga nasab-an kang malaot nga ispirito ");
INSERT INTO krj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","kag nagsinggit, “Jesus nga taga-Nazaret! Ano ang labut mo kanamun? Nag-abot bala ikaw rugya sa pagpapas kanamun? Kilala ko ikaw! Ikaw ang Balaan nga ginpadara kang Dios!” ");
INSERT INTO krj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ginmandoan ni Jesus ang malaot nga ispirito, “Hipus dyan! Gwa sa tawo nga ria!” ");
INSERT INTO krj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ginpakudug kang malaot nga ispirito ang tawo, kag nagsinggit kang matunog kag naggwa sa tawo. ");
INSERT INTO krj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Natingala gid ka mayad ang tanan nga mga tawo. Gani nga nagmunohay sanda, “Ano bala dya? Bag-o bala dya nga sahi kang pagturon-an? May awtoridad tana sa pagmando bisan sa mga malaot kag nagatuman man sanda kana.” ");
INSERT INTO krj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Gani ang balita nahanungud kay Jesus madasig nga naglapnag sa bilog nga Galilea. ");
INSERT INTO krj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Naghalin lagi sanday Jesus sa sinagoga kag nag-agto sa balay nanday Simon kag Andres. Imaw man nanda sanday Santiago kag Juan. ");
INSERT INTO krj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kang tion man nga to ang ugangan nga bayi ni Simon nagabatang hay ginahilanat dya. Kag kang pag-abot dayon ni Jesus, ginsugid nanda dya kana. ");
INSERT INTO krj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Gani ginparapitan dya ni Jesus kag ginkaptan sa alima kag pabangonon. Nadura ang anang hilanat kag nagsirbe tana kananda. ");
INSERT INTO krj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagkasirum, pagkatunod kang adlaw, ginpangdara kang mga tawo kay Jesus ang tanan nga mga masakitun kag ang mga nasab-an kang malaot nga ispirito. ");
INSERT INTO krj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ang haros tanan nga mga pumuloyo kang banwa nagtiriripon sa atubang kang balay. ");
INSERT INTO krj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ginpang-ayad ni Jesus ang duro nga mga tawo nga nagabatyag kang nagkalain-lain nga mga balatian, kag ginpanabog na man ang duro nga mga demonyo. Wara na ginatugotan nga makahambal ang mga demonyo kang bisan ano tungud hay kilala nanda kon sin-o gid tana. ");
INSERT INTO krj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagkaaga, dulum-dulum pa, nagbangon run si Jesus kag maggwa sa balay. Nag-agto tana sa kamingawan kag rugto magpangamuyo. ");
INSERT INTO krj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kag ginpangita tana ni Simon kag kang anang mga kaibahan. ");
INSERT INTO krj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kang makita nanda si Jesus, nagkuon sanda, “Ang tanan nga mga tawo nagapangita kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero nagsabat si Jesus, “Kinahanglan nga maagto man kita sa iba nga mga kaingud nga banwa, agud to nga makapangwali man ako rugto, tungud hay amo ria ang katuyoan nga nag-abot ako rugya.” ");
INSERT INTO krj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gani ginlibot na ang bilog nga Galilea nga nagapangwali sa mga sinagoga kag nagapanabog kang mga demonyo. ");
INSERT INTO krj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kar-on, may sangka aruon nga nagparapit kay Jesus. Nagluhod dya kag nagpakitluoy kana nga nagakuon, “Kon gustohon mo, sarang mo ako maayad kag himoon nga limpyo suno sa kasugoan.” ");
INSERT INTO krj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nangir-o gid si Jesus kana. Dayon gindawhat na dya kag tandugun, kag nagkuon, “Huud, gusto ko gid; ayad run!” ");
INSERT INTO krj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kato lagi, nadura ang aru kang tawo, kag nag-ayad run tana. ");
INSERT INTO krj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ginpaandaman gid tana ka mayad ni Jesus kag ginpapanaw lagi. ");
INSERT INTO krj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nagkuon si Jesus kana, “Sigurohon mo gid nga indi ikaw magpanugid sa bisan kay sin-o nahanungud sa butang nga dya, pero ang himoon mo agto ikaw sa pari kag magpaturuk kana. Dayon maghalad ikaw kang haralad nga suno sa kasugoan ni Moises para mapamatud-an mo sa mga tawo nga nag-ayad run ikaw.” ");
INSERT INTO krj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ang tawo nagpanaw kag ginpanugid-sugid ang natabo kana, hasta nga maglapnag ang balita nga dya. Tungud ka dya, indi run mahimo nga makasulud kang hayag si Jesus sa banwa. Gani rugto run lang tana nagtiner sa kamingawan, kag nag-aragto kana ang mga tawo nga nagharalin sa mga nagkalain-lain nga mga lugar. ");
INSERT INTO krj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagkatapos kang pira ka adlaw, nagbalik si Jesus sa Capernaum. Kag naglapnag ang balita nga rugyan run tana sa anang balay. ");
INSERT INTO krj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gani duro gid nga mga tawo ang nagtiripon kag wara run gid ti lugar nga nabilin bisan pa sa atubang kang gawang. Nagawali si Jesus kananda kang Mayad nga Balita, ");
INSERT INTO krj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","kang mag-abot ang apat ka mga tawo nga may ginayayungan nga sangka paralitiko. ");
INSERT INTO krj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero tungud gani kang kadurohon kang mga tawo, indi nanda mapaparapit ang paralitiko kay Jesus. Gani nga gin-ukaban nanda ang atup sa ibabaw nayon ni Jesus. Kag kang maluhotan run ang atup, gintunton nanda ang paralitiko nga nagabatang sa anang baratangan. ");
INSERT INTO krj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kang makita ni Jesus ang kahugut kang andang pagtoo, ginkun-an na ang paralitiko, “Anak, ginapatawad run ang imong mga sala.” ");
INSERT INTO krj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kar-on, may mga manunudlo kang kasugoan nga nagapurungko rugto kag nagapanghuna-huna sa andang kaugalingun, ");
INSERT INTO krj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Andut haw nga nagahambal tana kang pareho karia? Ginapasipalahan na ang Dios! Ang Dios gid lang kabay ang sarang makapatawad kang mga sala?” ");
INSERT INTO krj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naman-an lagi ni Jesus ang andang mga ginapanghuna-huna sa andang kaugalingun. Gani nagkuon tana kananda, “Andut haw nga nagapanghuna-huna kamo kang amo karia? ");
INSERT INTO krj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Indi bala nga mas hulas, ang magkuon sa paralitiko nga dya nga, ‘Napatawad run ang imong mga sala’ sangsa magkuon nga, ‘Bangon ikaw, darha ang imong baratangan kag magpanaw?’ ");
INSERT INTO krj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero pamatud-an ko kaninyo nga ang Anak kang Tawo may awtoridad sa kalibutan sa pagpatawad kang mga sala.” Dayon, ginkun-an na ang paralitiko, ");
INSERT INTO krj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ginakun-an ko ikaw, bangon, darha ang imong baratangan kag mag-uli!” ");
INSERT INTO krj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dayon man bangon kang paralitiko kag dali-dali nga gindara na ang anang baratangan kag maghalin sa tunga kang tanan nga mga tawo. Natingala gid ang tanan nga nakakita ka dya, kag gindayaw nanda ang Dios nga nagakuon, “Wara pa gid kami ti nakita nga pareho kang natabo nga dya!” ");
INSERT INTO krj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nagbalik liwan si Jesus sa binit kang Linaw kang Galilea, kag duro nga mga tawo ang nag-arabot kag magtiripon kana kag gintudloan na sanda. ");
INSERT INTO krj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapos kato, kang nagapanaw tana, nakita na ang sangka manugsukot kang buwis nga ginahingaranan kay Levi nga bata ni Alfeo. Nagapungko tana ka dya sa may ginabaydan kang buwis. Ginkun-an tana ni Jesus, “Dali, sunod ikaw kanakun!” Amo to kag nagtindug man si Levi kag magsunod kana. ");
INSERT INTO krj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Samtang nagakaun si Jesus sa balay ni Levi, duro nga mga manugsukot kang buwis kag mga makasasala ang nagakaun imaw kana kag sa anang mga disipulo, tungud hay duro sanda ka dya nga nagsurunod kana. ");
INSERT INTO krj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","May mga manunudlo kang kasugoan nga mga Fariseo ang nakakita nga nagadungan si Jesus sa pagkaun imaw sa mga manugsukot kang buwis kag sa mga makasasala. Gani nga ginpamangkot kang mga manunudlo kang kasugoan ang mga disipulo ni Jesus, “Andut haw nga nagadungan tana magkaun sa mga tawo nga ria?” ");
INSERT INTO krj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagkabati ka dya ni Jesus, nagsabat tana, “Ang mga tawo nga wara ti balatian wara man nagakinahanglan kang doktor, kundi ang mga nagamarasakit lang. Wara ako mag-agto rugya sa pagtawag kang mga matarung nga mga tawo, kundi kang mga makasasala.” ");
INSERT INTO krj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sangka bes, ang mga disipulo ni Juan nga Manugbawtiso kag ang mga Fariseo nagapuasa. May mga tawo nga nagparapit kay Jesus kag namangkot kana, “Andut nga nagapuasa tana ang mga disipulo ni Juan nga Manugbawtiso kag ang mga disipulo kang mga Fariseo, pero ang imo tana mga disipulo wara haw pagpuasa?” ");
INSERT INTO krj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nagsabat si Jesus kananda, “Mahimo bala nga magpuasa ang mga bisita sa kasal samtang kaimaw pa nanda ang nobyo? Indi gid! Samtang kaimaw pa nanda ang nobyo, indi nanda mahimo ria. ");
INSERT INTO krj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero magaabot ang adlaw nga ang nobyo pagabul-un kananda, kag amo run to ang tion kang andang pagpuasa. ");
INSERT INTO krj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kag wara ti bisan sin-o nga nagagamit kang bag-o nga tela agud ilunub sa daan nga bayo. Tungud hay kon himoon na dya, ang bag-o nga lunub nga dya magakuru kag gisiun na ang daan nga bayo nga ginlumban kag tapat pa gid gani nga magabahul ang gisi. ");
INSERT INTO krj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wara man ti bisan sin-o nga nagabutang kang bag-o nga bino sa daan nga surudlan nga panit. Tungud hay kon himoon na dya, busdikun kang bag-o nga bino ang daan nga surudlan nga panit, kag maula ang bino kag ang daan nga surudlan nga panit indi run man mapuslan. Ang bag-o nga bino angay lang nga ibutang sa bag-o nga surudlan nga panit.” ");
INSERT INTO krj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sangka Adlaw nga Inugpahuway, samtang nagaagi sanday Jesus sa katrigohan, ang anang mga disipulo nagpangutul kang mga inuhay. ");
INSERT INTO krj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gani ginkun-an kang mga Fariseo si Jesus, “Turuka bala, supak sa atun Kasugoan ang ginahimo kang imo mga disipulo tungud hay Adlaw kadya nga Inugpahuway!” ");
INSERT INTO krj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero nagsabat si Jesus, “Wara gid bala ninyo mabasahi kon ano ang ginhimo ni David kato anay kang sanda kang anang mga tinawo gin-gutum gid kag nagakinahanglan kang pagkaun? ");
INSERT INTO krj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nagsulud tana sa balay kang Dios katong si Abiatar amo ang Pinakamataas nga Pari, kag ginkaun ni David ang tinapay nga nahalad sa Dios. Suno sa atun kasugoan, ang mga pari lang ang sarang makakaun kang tinapay nga to, pero ginkaun tana to ni David kag ginapanugroan na man ang anang mga tinawo.” ");
INSERT INTO krj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kag nagkuon pa gid si Jesus, “Ang Adlaw nga Inugpahuway ginhimo para sa kaaraydan kang tawo, bukun ti nga ang tawo ang gintuga para sa pagtuman kang pagsurondan kang Adlaw nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gani ang Adlaw nga Inugpahuway sa idalum kang gahum kang Anak kang Tawo.” ");
INSERT INTO krj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sangka bes, nagbalik si Jesus sa sinagoga kag may tawo rugto nga kimay ang sambangi na nga alima. ");
INSERT INTO krj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","May mga tawo rugto nga nagapangita gid kang paagi nga maakusar nanda si Jesus, gani ginapanilagan gid nanda tana kon aydun na ang tawo nga kimay ang alima sa Adlaw nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ginkun-an ni Jesus ang tawo nga kimay, “Dali, parapit rugya sa unahan.” ");
INSERT INTO krj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dayon ginpamangkot ni Jesus ang mga tawo, “Ano bala ang ginatugot kang atun Kasugoan nga himoon sa Adlaw nga Inugpahuway? Ang magbulig bala ukon ang maghalit? Ang magluwas bala kang kabuhi ukon ang magpatay?” Pero wara gid sanda maglimug. ");
INSERT INTO krj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ginturuk ni Jesus nga may kaugut ang tanan nga mga tawo sa palibot pero nagkasubu man tana tungud kang andang pagkaawut ti ulo. Dayon nagkuon tana sa tawo nga kimay, “Untaya ang imong alima!” Gin-untay man kang tawo ang anang alima, kag nag-ayad dya. ");
INSERT INTO krj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dayon nagharalin ang mga Fariseo sa sinagoga kag magpakigsapol lagi sa mga sumuronod ni Herodes, kag nagplano sanda kon paano nanda patyun si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kar-on, nag-agto si Jesus imaw kang anang mga disipulo sa Linaw kang Galilea. Kag tama ka duro nga mga tawo ang nagsurunod kana. Nagharalin sanda sa Galilea, sa Judea, ");
INSERT INTO krj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","sa Jerusalem, sa Idumea, kag sa nasidlangan nga bahin kang Jordan, kag sa palibot kang Tiro kag Sidon. Sanda tanan nag-aragto kay Jesus tungud hay nabatian nanda ang tanan nga anang mga ginapanghimo. ");
INSERT INTO krj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tungud sa kadurohon kang mga tawo, nagsugo si Jesus sa anang mga disipulo nga mag-aman kang baruto para kana agud to nga indi tana pagdukdukan kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Duro nga mga tawo ang anang ginpang-ayad gani nga ang mga masakitun nagapanagil-ut gid para nga makatandug kana. ");
INSERT INTO krj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kada makita tana kang mga tawo nga nasab-an kang malaot nga ispirito, nagaharapa sanda ka dya sa anang atubang kag nagasinggit, “Ikaw ang Anak kang Dios!” ");
INSERT INTO krj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ginmandoan sanda ni Jesus nga indi gid maghambal kon sin-o tana. ");
INSERT INTO krj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dayon nagtukad si Jesus sa barabakulod kag gintawag na ang mga tawo nga anang gusto itawgun, kag nagparapit sanda kana. ");
INSERT INTO krj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nagpili tana kang napulo'g darwa ka mga tawo kag gintawag na nga mga apostoles kag gintangduan na nga mag-imaw kana kag para sugoon nga magpangwali, ");
INSERT INTO krj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kag gintaw-an na man sanda kang awtoridad sa pagtabog kang mga demonyo. ");
INSERT INTO krj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Amo dya ang napulo'g darwa nga anang ginpili: si Simon nga ginhingaranan ni Jesus nga Pedro; ");
INSERT INTO krj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago kag ang anang bugto nga si Juan, nga mga kabataan ni Zebedeo (Ginhingaranan man sanda ni Jesus nga Boanerges, nga kon sayudon, “mga Bata kang daguub”); ");
INSERT INTO krj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago nga bata ni Alfeo, si Tadeo, si Simon nga mapinalanggaun sa anang nasyon, ");
INSERT INTO krj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kag si Judas Iscariote nga amo ang nagluib kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatapos kato nag-uli si Jesus. Kag tama ka duro ruman nga mga tawo ang nagtiripon kana nga bisan gani sanda kang anang mga disipulo wara run ti tion nga magkaun. ");
INSERT INTO krj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kang mabatian kang anang panimalay nga ang mga tawo nagakuon, “Nagaumang tana”, gin-agtonan nanda tana agud ibul-un. ");
INSERT INTO krj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kag ang mga manunudlo kang Kasugoan nga naghalin sa Jerusalem nagkuon, “Nasab-an tana ni Beelzebul nga pangulo kang mga demonyo. Kag amo dya ang nagatao kana kang gahum sa pagpanabog kang mga demonyo.” ");
INSERT INTO krj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gani gintawag sanda ni Jesus kag ginhambalan paagi sa mga paraanggidan, “Ano bay ang pagtabog ni Satanas sa anang kaugalingun? ");
INSERT INTO krj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pareho abi sa sangka ginharian, kon ang mga sinakpan na ka dya magbinahin-bahin, ang ginharian nga ria indi run magpadayon. ");
INSERT INTO krj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Amo man ria sa sangka panimalay, kon magbinahin-bahin man sanda ka dya, ang ria nga panimalay indi man magpadayon. ");
INSERT INTO krj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Gani kon kontrahun ni Satanas ang anang kaugalingun kag magbinahin-bahin ang anang mga sinakpan, ang anang ginharian indi magpadayon kundi nga maguba dya. ");
INSERT INTO krj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Wara man ti bisan sin-o nga makasulud sa balay kang sangka mapagrus nga tawo kag pamul-un ang pagkabutang na ka dya, kon indi na anay paggaposon ang tagbalay nga to. Kag kon nagapos na run gani dya, sarang na run masaid ka pamuul ang tanan nga pagkabutang sa balay nga to. ");
INSERT INTO krj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sugidan ko kamo, ang tawo sarang mapatawad sa bisan ano na nga sala, kag sa bisan ano nga pagpasipala nga anang mahambal. ");
INSERT INTO krj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero ang bisan sin-o nga magpasipala sa Balaan nga Ispirito indi gid pagpatawarun, tungud hay nakahimo tana kang sala nga indi mapatawad hasta san-o.” ");
INSERT INTO krj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ginhambal dya ni Jesus tungud hay may nagakuon nga ginagamhan tana kang malaot nga ispirito. ");
INSERT INTO krj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kar-on, nag-abot ang nanay kag mga bugto nga laki ni Jesus. Nagatindug sanda sa gwa kang balay kag ginpatawag nanda si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Duro nga mga tawo ang nagapurungko sa palibot ni Jesus. Nagkuon sanda kana, “Rugyan sa gwa ang imong nanay kag mga bugto nga nagapangita kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nagsabat si Jesus, “Sin-o gid bala ang akun nanay kag mga bugto?” ");
INSERT INTO krj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dayon ginturuk na ang mga tawo nga nagapurungko sa anang palibot kag magkuon, “Amo dya sanda ang akun nanay kag mga bugto. ");
INSERT INTO krj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tungud hay ang bisan sin-o nga nagahimo kang kabubut-un kang Dios amo ang akun bugto nga laki, bugto nga bayi kag nanay.” ");
INSERT INTO krj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kar-on, nag-umpisa ruman ka panudlo si Jesus sa binit kang Linaw kang Galilea. Tama gid ka duro ang mga katawhan nga nagtiripon palibot kana, gani nga nagsakay tana sa baruto nga rugto sa tubig kag magpungko. Ang mga tawo tana rugto sa daray-ahan nagatirindug. ");
INSERT INTO krj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kag nagpanudlo tana kananda kang duro nga mga butang paagi sa mga paraanggidan nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pamati kamo! May sangka mangunguma nga nagpanaw sa pagsab-og kang binhi. ");
INSERT INTO krj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Samtang nagasab-og tana, ang iba nga mga binhi nagturupa sa aragyan, kag nagdarapo ang mga pispis kag gintuka nanda dya. ");
INSERT INTO krj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ang iba tana nga mga binhi rugto nagturupa sa batohon nga bahin kang taramnan nga sa diin manabaw lang ang lupa. Wara mabuhayi nag-urulhot ang mga tubo na ka dya, tungud hay manabaw lang ang lupa. ");
INSERT INTO krj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kag kang pagsirak kang adlaw, nalayung dya kag nag-uga tungud nga wara dya makapanggamot ka mayad. ");
INSERT INTO krj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ang iba ruman tana nga mga binhi rugto nagturupa sa ginatuboan kang sapinit. Kag nagturubo ang mga sapinit kag ginlumus na ang mga binhi nga nagturubo, gani nga wara dya makapamunga. ");
INSERT INTO krj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kag ang iba pa gid tana nga mga binhi nagturupa sa manami nga lupa. Nagparamuhi dya kag nagralambo hasta nga nakapamunga. Ang iba ka dya nakapatubas kang katloan ka pilo, ang iba tana kan-uman ka pilo kag ang iba pa gid tana sanggatos ka pilo.” ");
INSERT INTO krj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pagkatapos nagkuon si Jesus, “Kamo nga mga nagaparamati, intiendiha ninyo ka mayad ang inyo nabatian.” ");
INSERT INTO krj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kang nagaisarahanun run lang si Jesus, nagparapit kana ang iba nga nakabati imaw kang napulo'g darwa ka mga disipulo kag nagpamangkot kana nahanungud sa mga paraanggidan. ");
INSERT INTO krj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gani nagkuon si Jesus, “Gintugro run kaninyo ang kaaram sa paghangup kang mga likum nga mga kamatuoran nahanungud sa paghari kang Dios. Pero sa iba tana pagatudloan sanda paagi sa mga paraanggidan, ");
INSERT INTO krj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agud to nga, ‘Bisan magsagad sanda ka turuk, indi man angud sanda makakita; bisan magsagad sanda ka pamati, indi man angud sanda makahangup. Tungud hay kon ginhimo nanda ria, magadangup sanda sa Dios, kag patawarun na sanda.’” ");
INSERT INTO krj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gani ginpamangkot sanda ni Jesus, “Indi kamo haw makahangup kang paraanggidan nga dya? Paano pa bay ang paghangup ninyo kang iba nga mga paraanggidan? ");
INSERT INTO krj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ang ginsab-og amo ang pulong kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ang mga binhi nga nagturupa sa aragyan pareho kang mga tawo nga nakabati kang pulong kang Dios, dayon nag-abot si Satanas kag ginbuul ang mga mensahe nga ginsab-og sa andang tagipusoon. ");
INSERT INTO krj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ang iba ruman tana nga mga binhi nga nagturupa sa batohon nga lugar pareho kang mga tawo nga nakabati kang pulong kang Dios kag ginbaton lagi nanda dya nga may kalipay. ");
INSERT INTO krj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ugaring wara dya magtuduk sa andang tagipusoon, gani nga wara dya magpabilin. Pag-abot kang mga kalalat-an kag paghingabot tungud kang pulong, dayon lang man nanda talikod. ");
INSERT INTO krj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ang iba ruman tana nga mga binhi nga nagturupa sa dugihun nga lugar, pareho kang mga tawo nga nakabati kang pulong kang Dios, ");
INSERT INTO krj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ugaring ang andang mga panghuna-huna nabuhos sa mga paraligban sa pagpangabuhi kag sa paghanggab sa manggad kag sa paghandum kang iba pa gid nga mga butang, gani gindaug ang pulong nga rugyan run sa andang tagipusoon kag wara dya makapamunga. ");
INSERT INTO krj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ang iba tana nga mga binhi nga nagturupa sa manami nga lupa pareho kang mga tawo nga nakabati kang pulong kang Dios kag ginbaton nanda dya kag nagpamunga sanda ka dya ka duro, ang iba katloan ka pilo, ang iba tana kan-uman ka pilo kag ang iba pa gid tana sanggatos ka pilo.” ");
INSERT INTO krj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nagpadayon pa gid si Jesus sa paghambal, “May sulo bala nga ginadara para lang takluban ukon ibutang sa idalum kang katre? Indi bala nga ginabutang dya sa anang turungtongan? ");
INSERT INTO krj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wara ti tinago nga indi maman-an, kag wara ti sekreto nga indi maman-an. ");
INSERT INTO krj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kamo nga nagaparamati intiendiha ninyo ka mayad ang inyo nabatian!” ");
INSERT INTO krj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kag nagkuon pa gid tana kananda, “Talupangda ninyo ang inyo nabatian. Ang taraksan nga inyo gin-gamit sa paghusgar nga inyo ginhimo sa iba amo man ang pagagamitun kang Dios sa paghusgar kaninyo, kag sobra pa gani. ");
INSERT INTO krj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tungud hay ang tawo nga may ginaangkun pagatugroan pa gid kang duro, pero ang tawo tana nga wara ti ginaangkun pagabul-un pa gani kana ang bisan gamay nga rugyan kana.” ");
INSERT INTO krj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kag nagpadayon pa gid si Jesus sa pagkuon, “Ang Paghari kang Dios pareho kang sangka tawo nga nagsab-og kang binhi sa anang uma. ");
INSERT INTO krj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Adlaw kag gabii nagaobra tana kag nagaturog samtang ang binhi tana nagaurulhot kag nagatubo nga wara na maman-i kon paano dya nagakatabo. ");
INSERT INTO krj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ang lupa mismo ang nagapatubo kag nagapabunga kang tanum. Una anay nga nagaulhot amo ang ugdo, madason amo ang uhay kag ang urihi amo ang uhay nga buta kang matimgas nga bunga. ");
INSERT INTO krj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kag kon gurang run ang mga bunga na ka dya, ginagarab dya dayon tungud hay aranyun run.” ");
INSERT INTO krj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kar-on, nagpamangkot si Jesus, “Sa ano bala natun mapaanggid ang paghari kang Dios ukon ano nga paraanggidan ang atun gamitun sa pagpaathag ka dya? ");
INSERT INTO krj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kaangay dya kang liso kang mustasa nga pinakagamay nga liso sa kalibutan kang gintanum dya. ");
INSERT INTO krj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero kon manubo run gani dya, mangin pinakabahul dya sa tanan nga puno kang laswa kag mananga dya kang daragkul nga mga sanga, gani ang mga pispis makapamugad sa anang mga sanga nga maharon.” ");
INSERT INTO krj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nagapanudlo si Jesus sa mga katawhan paagi sa mga paraanggidan pareho ka dya. Ginatudloan na sanda kutub sa andang masarangan ka hangup. ");
INSERT INTO krj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wara tana nagahambal kananda kon indi paagi sa mga paraanggidan, pero kon sandahanun lang kang anang mga disipulo ginapaathag na ang tanan kananda. ");
INSERT INTO krj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagkasirum kang adlaw nga to, nagkuon si Jesus sa anang mga disipulo, “Matabok kita sa pihak kang linaw.” ");
INSERT INTO krj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gani ginbilin nanda ang mga tawo. Ang mga disipulo nagsakay sa baruto nga sa diin rugto run nga daan nagapungko si Jesus, kag gindara nanda tana. Kag may mga baruto man nga nagtarawas kananda. ");
INSERT INTO krj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gulpi lang nga naghuyup ang mabaskug nga hangin, kag nagwaswas ang daragkul nga mga balud gani nga daw mabuta run kang tubig ang baruto. ");
INSERT INTO krj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero si Jesus tana rugto sa likod nayon kang baruto nagakaturog nga nagaulon sa ulonan. Ginpukaw nanda tana, “Maestro, wara bala ikaw nagakabalaka nga malunod run kita?” ");
INSERT INTO krj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gani, nagbangon si Jesus kag ginmandoan ang hangin nga magpuut, kag ginhambalan ang mga balud nga magkanay. Nagpuut ang hangin kag naglinung ang tanan. ");
INSERT INTO krj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dayon nagkuon si Jesus sa anang mga disipulo, “Andut haw nga nahadluk kamo? Wara angud kamo haw ti pagtoo?” ");
INSERT INTO krj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero gindakup sanda kang tuman nga kahadluk kag nagmunohay, “Sin-o gid tana dya nga tawo man nga bisan pa ang hangin kag mga balud nagatuman kana?” ");
INSERT INTO krj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nag-abot si Jesus kag ang anang mga disipulo sa tabok kang Linaw kang Galilea sa lugar kang mga Gerasanhun. ");
INSERT INTO krj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkapanaog ni Jesus sa baruto, ginsug-alaw tana kang sangka tawo nga naghalin sa rulubngan. Ang tawo nga dya nasab-an kang malaot nga ispirito. ");
INSERT INTO krj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nagaistar tana ka dya sa rulubngan. Wara run gid ti bisan sin-o nga makagapos kana bisan pa nga kadenahan. ");
INSERT INTO krj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pira run ka beses nga ginagapos tana sa anang alima kag kahig, pero ginabugras na lang ang mga kadena kag ginapang-irintuk ang mga salsalun sa anang kahig. Tama gid tana ka purus nga wara ti bisan sin-o nga makadaug kana. ");
INSERT INTO krj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Adlaw kag gabii, nagalagaw tana sa rulubngan kag sa kabukidan nga nagasagad ka tiyabaw, kag ginapilasan na ang anang lawas kang mga bato. ");
INSERT INTO krj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kang makita na si Jesus sa marayu, nagdalagan tana kag magluhod sa atubang ni Jesus, ");
INSERT INTO krj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kag nagsinggit kang matunog, “Jesus nga Anak kang Dios nga Labing Mataas, ano gid bala ang tuyo mo kanakun? Nagapakitluoy ako kanimo sa ngaran kang Dios, indi ako pagpaantosa!” ");
INSERT INTO krj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ginkuon na dya tungud hay ginamandoan run tana ni Jesus, “Malaot nga ispirito, gwa dyan sa tawo nga ria!” ");
INSERT INTO krj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ginpamangkot tana ni Jesus, “Sin-o ngaran mo?” Nagsabat tana, “Linibo, tungud hay raku kami!” ");
INSERT INTO krj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nagsige gid tana ka pakitluoy ka mayad kay Jesus nga indi na sanda pag-tabogon pagwa sa lugar nga ria. ");
INSERT INTO krj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kar-on, may panung kang mga baboy rugto sa bakulod nga nagapanginaun. ");
INSERT INTO krj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nagpakitluoy kay Jesus ang mga malaot nga ispirito, “Paagtona kami sa mga baboy; kananda mo run lang kami pasudlun.” ");
INSERT INTO krj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gintugotan sanda ni Jesus, kag naggurowa sanda sa tawo kag magsaraylo sa mga baboy. Amo to kag ang bilog nga panung kang baboy nga mga darwa ka libo, nagharaguyon padulhog sa pil-as kag nagkarahulog sa linaw kag nagkaralumus. ");
INSERT INTO krj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ang mga manugsagod tana kang baboy nagparalagyo kag ginpanugid ang natabo nga dya sa banwa kag sa kaumahan. Gani nag-aragto ang mga tawo agud turukun kon ano gid ang natabo. ");
INSERT INTO krj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kang mag-agto sanda kay Jesus, nakita nanda ang tawo nga nasab-an anay kang duro nga mga malaot nga ispirito. Nagapungko dya nga may bayo run kag igsakto run ang paminsarun; kag hinadlukan gid sanda. ");
INSERT INTO krj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ang mga tawo tana nga nakasaksi kang hitabo nga to nagpanugid sa mga nag-arabot kon ano ang natabo sa tawo nga nasab-an anay kang malaot nga ispirito kag sa mga baboy. ");
INSERT INTO krj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gani ginsige nanda ka pangabay si Jesus nga maghalin sa andang banwa. ");
INSERT INTO krj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kang manugsakay run si Jesus sa baruto, ang tawo nga nasab-an anay kang malaot nga ispirito nagpangabay kana, “Patawsa ako kanimo!” ");
INSERT INTO krj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero wara tana gintugotan ni Jesus, kundi nga ginkun-an na dya, “Uli lang to sa inyo kag isugid sa imong panimalay kag abyan kon paano ikaw ginbuligan kang Ginoo kag kon daw ano ang anang kaluoy kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kag nagpanaw ang tawo kag ginpanugid na sa Decapolis ang nahanungud sa ginhimo ni Jesus kana. Kag natingala gid ang tanan nga nakabati kana. ");
INSERT INTO krj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pagbalik ruman ni Jesus sa tabok kang linaw, tama ruman ka duro nga mga katawhan nga nagtiripon kana samtang rugto tana sa binit kang linaw. ");
INSERT INTO krj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dayon nag-abot si Jairo nga sangka opisyal kang sinagoga. Pagkakita na kay Jesus, nagharapaun tana sa kahig nayon ni Jesus ");
INSERT INTO krj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kag nagpakitluoy kana nga nagakuon, “Tagumatayun ang akun bata nga dalagita. Agtoni anay tana kag tungtongan kang imong alima agud to nga mag-ayad tana kag mabuhi pa!” ");
INSERT INTO krj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nagtawas kana si Jesus. Tama man ka duro nga mga tawo ang nagsurunod kana kag nagadinus-uganay sa anang palibot. ");
INSERT INTO krj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","May sangka bayi man rugto nga ginadugo sa sulud kang napulo'g darwa ka tuig. ");
INSERT INTO krj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tam-an gid ang anang pag-antos bisan pa nga nagpabulong run man tana sa duro nga mga doktor hasta nga naubos na run ka gasto ang anang kwarta pero wara man angud ti alibyo, tapat pa gani nga naglala dya. ");
INSERT INTO krj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nakabati tana kang nahanungud kay Jesus, gani nga nagpanagil-ut gid tana sa karak-an kag mag-agto sa likod nayon ni Jesus kag gintandug ang bayo na ka dya, ");
INSERT INTO krj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tungud hay nagkuon tana sa anang kaugalingun, “Kon matandug ko lang bisan ang anang bayo, maayad gid ako.” ");
INSERT INTO krj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nagpuut lagi ang anang pagdugo kag nabatyagan na sa anang lawas nga naayad run tana sa anang balatian. ");
INSERT INTO krj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nabatyagan ni Jesus nga may gahum nga naggwa kana, gani nagbalikid tana dayon sa karak-an kag namangkot, “Sin-o ang nagtandug kang akun bayo?” ");
INSERT INTO krj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nagsabat ang anang mga disipulo, “Nakita mo run nga nagadinagusu ang mga tawo kanimo, andut nga mamangkot pa ikaw kon sin-o ang nagtandug kang imong bayo?” ");
INSERT INTO krj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero nagpanghulung-hulung si Jesus sa palibot agud turukun kon sin-o gid ang naghimo ka dya. ");
INSERT INTO krj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ang bayi tana, kang matalupangdan na ang natabo kana, nagkurudug tana sa kahadluk nga nagparapit kay Jesus. Nagharapaun tana sa kahig nayon ni Jesus kag magsugid kang bug-os nga kamatuoran. ");
INSERT INTO krj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kag nagkuon si Jesus kana, “Inday, ang imong pagtoo amo ang nag-ayad kanimo. Panaw nga may kalinung, naayad run gid ikaw!” ");
INSERT INTO krj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Samtang nagahambal pa ka dya si Jesus, may mga nag-arabot nga halin sa balay ni Jairo nga nagkuon, “Patay run ang imong bata. Indi run pagdistorboha ang Maestro.” ");
INSERT INTO krj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero wara magsapak si Jesus sa andang ginkuon nga dya kundi naghambal tana kay Jairo, “Indi ikaw magkahadluk, magtuo lang ikaw.” ");
INSERT INTO krj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wara tana ti gintugotan nga magtawas kana magluwas kanday Pedro, Santiago kag Juan nga bugto ni Santiago. ");
INSERT INTO krj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kar-on pag-abot nanda sa balay nanday Jairo, nakita ni Jesus nga nagagirinoal ang mga tawo; nagahirinibi sanda kag nagaparanangisun. ");
INSERT INTO krj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagsulud na, nagkuon tana kananda, “Andut haw nga nagagirinoal kamo kag nagahirinibi? Bukun ti patay ang bata; nagakaturog lang.” ");
INSERT INTO krj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero ang mga tawo tana, ginkadlawan lang nanda si Jesus. Gani ginpagwa na sanda tanan kag gindara na ang tatay kag nanay kang bata imaw kang anang tatlo ka mga disipulo kag nagsulud sanda sa kwarto nga sa diin nahamyang ang bata. ");
INSERT INTO krj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ginkaptan ni Jesus ang bata sa alima kag ginkun-an nga, “Talitha koum!” nga kon sayudon, “Inday, ginakun-an ko ikaw, magbangon kaw!” ");
INSERT INTO krj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lagi-lagi nagbangon ang bata kag magpanaw-panaw (tana ka dya nagapang-edadun kang napulo'g darwa ka tuig). Natingala gid sanda ka mayad sa natabo nga dya. ");
INSERT INTO krj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero gindumilian gid sanda ni Jesus nga indi pagpanugid sa bisan kay sin-o ang natabo nga dya. Kag ginkun-an na sanda nga ipakan-un ang bata. ");
INSERT INTO krj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dayon naghalin si Jesus sa lugar nga to imaw kang anang mga disipulo kag nag-uli sa anang kaugalingun nga banwa. ");
INSERT INTO krj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pag-abot kang Adlaw nga Inugpahuway, nagpanudlo tana sa sinagoga. Duro nga mga tawo ang natingala gid kang mabatian nanda tana. Nagkuon sanda, “Sa diin na ginpamuul ang tanan nga mga ginapanghambal na nga ria? Ano nga klase kang kaaram ang gintao kana? Paano tana makahimo kang mga milagro? ");
INSERT INTO krj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Indi bala nga ahaw panday lang man ria nga bata ni Maria? Indi bala nga bugto tana nanday Santiago, Jose, Judas kag Simon? Rugya man kabay nagauli ang anang mga bugto nga bayi?” Gani nga wara ginbaton si Jesus kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ginkun-an sanda ni Jesus, “Ang propeta ginatahod bisan diin magluwas lang sa anang kaugalingun nga banwa kag kang anang mga himata kag pamilya.” ");
INSERT INTO krj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gani nga wara tana makahimo kang mga milagro rugto magluwas lang sa pag-ayad kang pira ka bilog nga mga masakitun paagi sa pagtungtong kang anang alima kananda. ");
INSERT INTO krj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Natingala gid si Jesus tungud hay wara sanda ti pagtoo kana. Amo to kag nag-agto si Jesus sa palibot nga mga baryo kag magpanudlo sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dayon, gintipon na ang napulo'g darwa ka mga disipulo kag ginpapanaw nga tag darwa-darwa. Gintugroan na sanda kang gahum sa pagpanabog kang mga malaot nga ispirito. ");
INSERT INTO krj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ginbilinan na sanda, “Indi kamo magdara kang bisan ano sa inyo nga pagpanaw magluwas lang sa baston; indi man kamo magbalon kang pagkaun ukon puyo-puyo ukon kwarta. ");
INSERT INTO krj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Magsuksok kamo kang sandalyas pero indi kamo magdara kang inyong irislan nga bayo.” ");
INSERT INTO krj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ginkun-an na pa gid sanda, “Kon sa diin nga balay kamo batonon, rugyan kamo tiner hasta nga maghalin kamo sa lugar nga ria. ");
INSERT INTO krj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kon may mga lugar nga indi magbaton kaninyo kag indi magpamati kaninyo, tataka ninyo ang yab-ok sa inyo mga kahig sa inyong paghalin, bilang patimaan nga wara run kamo ti sarabtun kananda.” ");
INSERT INTO krj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gani nagpanaw sanda kag nagpangwali nga ang mga tawo kinahanglan maghinulsul sa andang mga sala. ");
INSERT INTO krj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Duro nga mga demonyo ang andang ginpanabog kag ginpanghaplasan nanda kang lana ang mga nagamarasakit nga mga tawo kag ginpang-ayad sanda. ");
INSERT INTO krj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kar-on, nabatian ni Haring Herodes ang tanan nga dya, tungud hay ang ngaran ni Jesus nabantog run. May mga nagkuon, “Nabanhaw si Juan nga Manugbawtiso, gani nga may gahum tana sa paghimo kang mga milagro.” ");
INSERT INTO krj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero may iba man tana nga nagakuon, “Si Elias tana ria!” Kag may iba pa gid nga nagakuon, “Propeta tana nga pareho kang mga propeta kauna.” ");
INSERT INTO krj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kang mabatian dya ni Herodes, nagkuon tana, “Si Juan nga Manugbawtiso ria nga ginpapugotan ko, pero nabanhaw!” ");
INSERT INTO krj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tungud hay si Herodes nga dya amo ang nagpadakup kay Juan, kag nagpagapos kag nagpapriso kana. Ginhimo dya ni Herodes tungud kay Herodias nga ana ginpangasawa bisan pa nga asawa dya kang anang bugto nga si Felipe. ");
INSERT INTO krj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pirme nagakuon si Juan kay Herodes, “Bukun ti husto nga agawun nimo ang asawa kang imong bugto!” ");
INSERT INTO krj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Gani gindumtan gid ni Herodias si Juan kag gusto na raad nga ipapatay dya, ugaring indi na mahimo ");
INSERT INTO krj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tungud hay nahadluk si Herodes kay Juan hay naman-an na nga si Juan matarung kag balaan gani nga ginpabantayan na gid dya agud indi maiwan. Nanamian gid si Herodes nga magpamati kay Juan bisan pa nga natublag tana magpamati kana. ");
INSERT INTO krj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero nag-abot gid man ang kahigayonan nga ginahulat ni Herodias. Kaadlawan kato ni Herodes, kag nagpatabad tana para sa tanan nga mga matag-as nga opisyales kang gobyerno, kag sa mga opisyales kang suldado kag sa mga bantog nga mga tawo sa Galilea. ");
INSERT INTO krj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kang magsulud ang bata ni Herodias nga daraga kag magsaot, nanamian gid si Herodes kag ang anang mga dinapit nga bisita. Gani nagkuon si Herodes sa daraga, “Pangayo ikaw kanakun kang bisan ano nga gusto nimo kag itao ko kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dayon nagsaad si Herodes kana, “Itao ko kanimo ang bisan ano nga imo pangayoon, bisan pa ang katunga kang akun ginharian.” ");
INSERT INTO krj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gani naggwa ang daraga kag namangkot sa anang nanay, “Ano bay ang pangayoon ko?” Nagsabat ang anang nanay, “Ang ulo ni Juan nga Manugbawtiso!” ");
INSERT INTO krj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lagi-lagi nagdali-dali balik kay Herodes ang daraga kag nagkuon, “Gusto ko nga itao mo kadya lagi kanakun ang ulo ni Juan nga Manugbawtiso nga nakabutang sa bandihado.” ");
INSERT INTO krj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nasubuan gid ka mayad si Herodes pero indi na run mabaribadan ang daraga tungud kang anang mga ginsaad sa atubang kang mga bisita. ");
INSERT INTO krj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lagi-lagi ginsugo ni Herodes ang sangka suldado nga idar-un kana ang ulo ni Juan. Gani nag-agto ang suldado sa prisohan kag ginpugotan si Juan. ");
INSERT INTO krj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Dayon, nagbalik ang suldado nga dara ang ulo ni Juan nga nabutang sa bandihado kag gintao na dya sa daraga, kag gintao man dya kang daraga sa anang nanay. ");
INSERT INTO krj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kang mabatian dya kang mga disipulo ni Juan, nag-agto sanda rugto kag ginbuul ang anang bangkay kag ginlubung. ");
INSERT INTO krj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nagbaralik ang mga apostoles nga ginsugo ni Jesus. Ginsugid nanda kana ang tanan nanda nga mga ginhimo kag ginpanudlo. ");
INSERT INTO krj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tungud nga duro ang mga tawo nga nagaarabot-abot kag nagaharalin sa lugar nga sa diin rugto sanday Jesus, nga haros wara run sanda ti tyempo magkaun. Gani nagkuon tana sa anang mga disipulo, “Dali, maagto kita sa kamingawan nga kitahanun lang kag magpahuway-huway kang makadali.” ");
INSERT INTO krj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gani naghalin sanda rugto sakay sa baruto nga sandahanun lang kag nag-agto sa mamingaw nga lugar. ");
INSERT INTO krj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero duro nga mga tawo ang nakakita kang paghalin nanda kag nakilala sanda. Gani nagdinalagan ang mga tawo halin sa andang mga kabanwahanan paagto sa lugar nga pagaagtonan nanday Jesus. Kag una pa gani sanda kaabot rugto. ");
INSERT INTO krj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kang pagtakas ni Jesus nakita na ang tama ka duro nga mga tawo kag naluoy gid tana kananda, tungud hay daw pareho lang sanda kang mga karnero nga wara ti manugbantay. Amo to kag nag-umpisa tana sa pagpanudlo kananda kang duro nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kang nagahinalup run ang adlaw, nagparapit kana ang anang mga disipulo kag nagkuon, “Sirum run gid dya kag mamingaw dya nga lugar. ");
INSERT INTO krj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Papanawa run ang mga tawo agud to nga makaagto sanda sa mga marapit nga uma kag sa mga baryo para makabakal kang bisan ano nga anda makaun.” ");
INSERT INTO krj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero nagsabat si Jesus, “Kamo mismo ang magtugro kananda kang andang makaun.” Nagpamangkot sanda kana, “Mapanaw bala kami kag magbakal kang pagkaun nga nagabili kang darwa ka gatos ka kwarta nga pilak para ipakaun kananda?” ");
INSERT INTO krj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ginpamangkot sanda ni Jesus, “Ano ka duro ang dara ninyo nga tinapay? Abi, usisaa ninyo.” Kang mausisa run nanda, nagkuon sanda kay Jesus, “Lima ka bilog nga tinapay kag darwa ka bilog nga isda.” ");
INSERT INTO krj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dayon ginsugo ni Jesus sanda tanan nga magpurungko kang grupo-grupo sa hilamon. ");
INSERT INTO krj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gani nagpirinungko ang mga tawo nga nagagrupo-grupo. May rugyan nga tag-sanggatos kag may rugyan man nga tagkalim-an. ");
INSERT INTO krj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ginbuul ni Jesus ang lima ka tinapay kag ang darwa ka bilog nga isda kag nagtangra tana sa langit agud magpasalamat sa Dios, kag ginpamihak-pihak na ang tinapay kag ginpanugro sa anang mga disipulo agud nga ipanagtag sa mga tawo. Ginhururay na man ang darwa ka bilog nga isda kananda tanan. ");
INSERT INTO krj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nakakaun sanda tanan kag nagkarabusog. ");
INSERT INTO krj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kang tiponon kang mga disipulo ang nabilin nga mga ginpamihak-pihak nga tinapay kag isda, napulo'g darwa pa ka alat ang andang nabuta. ");
INSERT INTO krj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ang kadurohon kang mga laki nga nakakaun lima ka libo. ");
INSERT INTO krj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lagi-lagi ginsugo ni Jesus ang anang mga disipulo nga magsakay sa baruto kag mag-una sa tabok kang linaw, rugto sa Betsaida, samtang ginapapauli na ang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kang makahalin run sanda, nagtukad si Jesus sa bakulod para magpangamuyo. ");
INSERT INTO krj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkagabii, ang baruto rugto run sa tunga kang linaw, samtang si Jesus tana rugto sa takas nga nagaisaranhun. ");
INSERT INTO krj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nalantawan na nga nalisdan gid ang anang mga disipulo sa pagbugsay kang baruto tungud hay pasug-alaw kananda ang hangin. Kang nagakasanagun run, nag-abat si Jesus kananda nga nagapanaw sa tubig. Lubsan na lang raad sanda, ");
INSERT INTO krj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ugaring kang makita nanda tana nga nagapanaw sa tubig, abi nanda nga bagat dya. Gani nagsiringgit sanda, “Bagat!” ");
INSERT INTO krj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tungud hay sanda tanan nakakita kana kag gindakup sanda kang tuman nga kahadluk. Pero ginkun-an lagi sanda ni Jesus, “Magpakabakud kamo. Ako dya. Indi kamo magkahadluk.” ");
INSERT INTO krj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dayon nagsakay si Jesus sa baruto kag nag-imaw kananda, kag nagkanay ang hangin. Natingala gid sanda ka mayad ");
INSERT INTO krj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tungud hay wara nanda mahangpi ang kahulogan kang pagpamuad ni Jesus kang mga tinapay; nadulman pa ang andang mga panghuna-huna. ");
INSERT INTO krj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagkatabok nanda sa linaw, sa Genesaret sanda nagdungka kag rugto nanda gin-gaid ang andang baruto. ");
INSERT INTO krj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkatakas nanda, nakilala dayon kang mga tawo si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gani nagdinalagan ang mga tawo sa bilog nga rehiyon kag ginadara nanda ang mga masakitun sa andang baratangan sa bisan diin nga lugar nga mabatian nanda nga rugto si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kag bisan diin mag-agto si Jesus, sa mga baryo, sa mga syudad, ukon sa mga uma man, ginadara nanda ang mga masakitun sa mga tindahan, kag nagapakitluoy sanda kana nga patandugun ang mga masakitun bisan sa sidsid lang kang anang bayo. Kag ang tanan nga nakatandug ka dya nag-arayad. ");
INSERT INTO krj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kar-on may mga Fariseo kag mga manunudlo kang Kasugoan nga nagharalin pa sa Jerusalem ang nagtiripon kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Napanilagan nanda nga ang iba sa mga disipulo ni Jesus nagakaun nga wara makapanghugas kang andang alima suno sa paagi nga gintudlo kang mga Fariseo. ");
INSERT INTO krj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tungud hay ang mga Fariseo, kag ang tanan nga mga Judio wara nagakaun kon wara makapanghugas kang andang alima nga suno sa gintudlo kang andang mga kamal-aman. ");
INSERT INTO krj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kag kon mag-abot sanda halin sa tindahan wara sanda pagkaun kon indi nanda mahugasan ang andang lawas. Duro pa gid nga mga turumanun ang andang ginasunod pareho kang husto nga paghugas kang mga tasa, kuron, kag mga surudlan nga saway.) ");
INSERT INTO krj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Gani ginpamangkot kang mga Fariseo kag mga manunudlo kang Kasugoan si Jesus, “Andut haw nga ang imo mga disipulo wara pagtuman kang mga turumanun nga gintudlo kang atun mga kamal-aman? Nagakirinaun lang sanda nga wara makapanghugas kang andang mga alima.” ");
INSERT INTO krj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nagsabat si Jesus, “Husto gid man ang ginkuon ni propeta Isaias nahanungud kaninyo nga mga hipokrito. Pareho kang anang ginsulat, Kuon kang Dios, ‘Ang mga katawhan nga dya nagapadungug kanakun sa andang mga pulong pero ang andang mga tagipusoon marayu gid kanakun. ");
INSERT INTO krj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wara ti pulos ang pagsimba nanda kanakun, tungud hay ginatudlo nanda ang pagturon-an nga ginhimo kang tawo nga kuno kanakun maghalin.’” ");
INSERT INTO krj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nagkuon pa gid si Jesus, “Ginpatumbayaan ninyo ang mga Kasugoan kang Dios, kag ginsunod ninyo ang mga turumanun nga ginhimo kang tawo.” ");
INSERT INTO krj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Padayon pa gid si Jesus sa pagkuon, “Nami gid kamo maghimo kang mga padihut sa pagsikway kang kasugoan kang Dios agud to nga matuman ninyo ang inyo turumanun. ");
INSERT INTO krj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pareho kang ginsugo ni Moises, ‘Tahoda ninyo ang inyo tatay kag nanay’ kag, ‘ang bisan sin-o nga magpasipala sa anang tatay ukon nanay kinahanglan nga mapatay.’ ");
INSERT INTO krj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero ang ginatudlo tana ninyo amo nga kon ang sangka tawo may burolig sa anang tatay ukon nanay, pero kon magkuon tana nga, ‘Korban dya’ (kon sayudon, ana run dya kang Dios) ");
INSERT INTO krj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","indi run tana kinahanglan nga magbulig sa anang tatay ukon nanay. ");
INSERT INTO krj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sa paghimo ninyo ka dya, ginabalewara ninyo ang pulong kang Dios, paagi sa pagpasulabi ninyo kang mga turumanun nga inyo ginapaalinton sa mga tawo. Kag duro pa gid nga mga butang nga pareho ka dya ang inyo ginahimo.” ");
INSERT INTO krj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ginpanawag ruman ni Jesus ang mga tawo nga magparapit kana kag magkuon kananda, “Pamati kamo tanan kanakun, kag hangpa ninyo dya: ");
INSERT INTO krj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bukun ti ang ginakaun kang tawo ang makadagta kana, kundi ang nagagwa kana. ");
INSERT INTO krj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kamo nga mga nagaparamati, intiendiha ninyo ka mayad ang inyo nabatian.” ");
INSERT INTO krj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kang ginbayaan ni Jesus ang mga tawo kag nagsulud sa balay, ginpamangkot tana kang anang mga disipulo nahanungud sa paraanggidan nga dya. ");
INSERT INTO krj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nagsabat tana kananda, “Pareho man bala kamo kang iba nga wara ti panghangup? Wara bala kamo kamaan nga ang bisan ano nga ginakaun kang tawo indi makadagta kana? ");
INSERT INTO krj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tungud hay wara dya nagasulud sa anang tagipusoon kundi sa anang busong kag nagagwa lang man sa anang lawas.” (Sa paghambal na ka dya, ginakabig ni Jesus nga ang tanan nga mga pagkaun pwede ikan-un.) ");
INSERT INTO krj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nagpadayon pa gid si Jesus sa pagkuon, “Ang nagagwa sa tawo amo ang nagadagta kana. ");
INSERT INTO krj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tungud hay sa tagipusoon kang tawo nagahalin ang mga malain nga panghuna-huna nga amo ang nagatulod sa paghimo kang mga malain nga mga butang pareho kang pagpakighilawas, pagpanakaw, pagpatay, pagpanginbayi ukon pagpanginlaki, ");
INSERT INTO krj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pagkahanggab, pagkamalaot, pagpangdaya, paghimo kang mga mahigku nga buhat, pagkahisa, paghambal kang malain batok sa iba, pagpahambog kag pagbinuang. ");
INSERT INTO krj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ang tanan nga mga malaot nga mga butang nga dya nagahalin sa tagipusoon kang tawo kag amo ang nagadagta kana.” ");
INSERT INTO krj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Halin rugto nag-agto si Jesus sa lugar nga sakup kang Tiro kag Sidon. Nagdayon tana sa sangka balay rugto kag indi tana malyag nga maman-an kang bisan sin-o nga rugyan tana, pero indi na gid dya matago sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","May sangka bayi rugto nga ang anang bata nga bayi nasab-an kang malaot nga ispirito. Pagkabati na nahanungud kay Jesus, nag-agto tana dayon kag nagharapaun sa kahig nayon ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ang bayi nga dya bukun ti Judio nga natawo sa Fenicia nga sakup kang Siria. Nagpakitluoy tana kay Jesus nga tabogon ang malaot nga ispirito paggwa sa anang bata. ");
INSERT INTO krj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero nagsabat si Jesus, “Kinahanglan nga unahun anay ka pakaun ang mga kabataan. Tungud hay bukun ti mayad ria nga bul-un ang pagkaun kang mga bata kag itablug sa mga ayam.” ");
INSERT INTO krj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero nagsabat ang bayi, “Huud, Ginoo, pero bisan gani ang mga ayam sa idalum kang lamesa nagakaun man kang uyang nga pagkaun kang mga kabataan.” ");
INSERT INTO krj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Gani nagkuon si Jesus kana, “Tungud kang sabat mo nga dya, makauli run ikaw. Naggwa run ang malaot nga ispirito sa imong bata.” ");
INSERT INTO krj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nag-uli ang bayi kag nakita na ang anang bata nga nagabatang sa katre kag ang malaot nga ispirito naggwa run. ");
INSERT INTO krj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dayon, naghalin si Jesus sa mga lugar nga sakup kang Tiro kag nag-agi tana sa Sidon kag sa mga lugar nga sakup kang Decapolis paagto sa Linaw kang Galilea. ");
INSERT INTO krj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","May mga tawo nga nagdara kana kang sangka tawo nga bungul kag pukol maghambal kag nagpakitluoy sanda kay Jesus nga tungtongan na dya kang anang alima. ");
INSERT INTO krj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Gani gindara ni Jesus ang tawo nga dya parayu sa karak-an nga sandahanun lang. Ginbutang na ang anang mga tudlo sa talinga kang tawo nga dya kag nagdupra tana kag ginpalhit ang anang dura sa dila kang tawo. ");
INSERT INTO krj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nagtangra si Jesus sa langit, nanghayhay kag nagkuon kana, “Effata,” nga kon sayudon, “Magbukas kaw!” ");
INSERT INTO krj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lagi-lagi nag-anting ang paramatin-an kang tawo nga dya kag nabuul ang anang pagkapukol kag maathag run tana maghambal. ");
INSERT INTO krj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dayon, ginmandoan sanda ni Jesus nga indi gid nanda dya pagpanugid bisan kay sin-o. Pero kon diin pa nga gindumilian sanda, tapat pa gani nga ginpanugid nanda dya. ");
INSERT INTO krj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kag ang tanan nga mga nakabati ka dya natingala gid ka mayad nga nagakuon, “Mayad gid ang tanan nga anang mga ginpanghimo. Maayad na bisan ang bungul kag mapahambal na ang apa!” ");
INSERT INTO krj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sa amo man to nga mga inadlaw tama ruman ka duro nga mga tawo ang nagtiriripon. Kang nawad-an run kang pagkaun ang mga tawo, gintawag ni Jesus ang anang mga disipulo nga magparapit kana kag nagkuon, ");
INSERT INTO krj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nangir-o gid takun sa mga tawo nga dya tungud hay tatlo run ka adlaw nga nagsagad sanda ka imaw kanakun, kag kar-on wara run sanda ti makaun. ");
INSERT INTO krj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ti kon pauliun ko sanda nga wara ti sulud ang andang busong, magakaralipung sanda sa dalanun tungud hay ang iba kananda ka dya rayu pa ang andang ginhalinan.” ");
INSERT INTO krj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagsabat ang anang mga disipulo, “Sa diin bay kita mabuul kang pagkaun rugya sa kayanakan para ipakaun sa mga tawo nga dya?” ");
INSERT INTO krj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Namangkot si Jesus kananda, “Pira ka bilog ang inyo tinapay dyan?” Nagsabat nanda, “Pito!” ");
INSERT INTO krj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ginsugo ni Jesus ang mga tawo nga magpurungko sa lupa, kag ginbuul na ang pito ka bilog nga tinapay. Nagpasalamat tana sa Dios, dayon ginpamihak-pihak na dya kag gintugro sa anang mga disipulo para ipanagtag sa mga tawo. Ginhimo man nanda dya. ");
INSERT INTO krj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","May pirambilog man sanda nga mga magagmay nga isda. Ginpasalamatan na man dya kag nagsugo nga ipanagtag dya sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nakakaun sanda tanan kag nagkarabusog. Ginpanipon kang mga disipulo ang nabilin nga ginpamihak-pihak kag pito ka mga alat nga buta ang andang natipon. ");
INSERT INTO krj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mga apat ka libo ka mga tawo ang nagkaun. ");
INSERT INTO krj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagkatapos kato, ginpapanaw ni Jesus ang mga tawo, kag lagi-lagi nagsakay tana sa baruto imaw kang anang mga disipulo kag mag-agto sa lugar nga ginatawag Dalmanuta. ");
INSERT INTO krj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","May mga Fariseo nga nag-aragto kay Jesus kag nagpakigbais kana. Gusto gid nanda nga tirawan si Jesus, gani nga nagpangayo sanda nga maghimo tana kang milagro sa pagpamatuod nga sa Dios tana maghalin. ");
INSERT INTO krj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nagpanghayhay si Jesus kag nagkuon, “Andut nga ang mga tawo sa kadya nga panag-on nagapangita kang milagro? Sa pagkamatuod, sugidan ko kamo, indi gid pagpakitaan kang milagro ang henerasyon nga dya.” ");
INSERT INTO krj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ginbayaan sanda ni Jesus kag nagsakay sa baruto kag magtabok sa pihak kang linaw. ");
INSERT INTO krj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kar-on, ang mga disipulo ni Jesus nalipat magdara kang tinapay kag sambilog lang ang dara nanda sa baruto. ");
INSERT INTO krj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ginpaandaman sanda ni Jesus, “Mag-andam gid kamo sa tapay kang mga Fariseo kag sa tapay ni Herodes.” ");
INSERT INTO krj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naghambalanay ang mga disipulo, “Ginhambal na ria tungud hay wara kita ti dara nga tinapay!” ");
INSERT INTO krj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naman-an ni Jesus ang andang ginahambalan gani nga ginpamangkot na sanda, “Andut nga ginahambalan ninyo nga wara kamo ti dara nga tinapay? Wara pa gihapon haw kamo makamaan ukon makaintiende? Kulang pa gihapon haw ang inyo paghangup? ");
INSERT INTO krj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","May mga mata man kabay kamo, andut haw nga indi kamo makakita? Kag may mga talinga man kabay kamo, ti andut haw nga indi kamo makabati? Nalipat run kamo haw? ");
INSERT INTO krj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kang ginpamihak-pihak ko ang lima ka bilog nga tinapay para sa lima ka libo, pira pa haw ka alat nga buta kang sobra nga ginpamihak-pihak nga pagkaun ang natipon ninyo?” Nagsabat sanda, “Napulo'g darwa!” ");
INSERT INTO krj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Kag kang ginpamihak-pihak ko ang pito ka bilog nga tinapay para sa apat ka libo, pira pa ka alat nga buta kang sobra nga ginpamihak-pihak nga pagkaun ang natipon?” Kuon nanda, “Pito!” ");
INSERT INTO krj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gani ginpamangkot sanda ni Jesus, “Ti, andut sa ano haw nga indi pa angud kamo makahangup?” ");
INSERT INTO krj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nagdungka sanday Jesus sa Betsaida. May mga tawo nga nagdara kana kang sangka bulag kag nagpakitluoy sanda kana nga itandugun na ang bulag nga dya. ");
INSERT INTO krj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Gindapit ni Jesus ang bulag kag tuytoyan paggwa sa baryo. Gindupraan na ang mga mata kang bulag kag gintungtongan na dya kang anang alima, kag ginpamangkot, “Ti, may makita kaw run?” ");
INSERT INTO krj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naglantaw ang tawo kag magsabat, “Huud, makita ko ang mga tawo pero daw pareho sanda kang mga kahoy nga nagaparanaw.” ");
INSERT INTO krj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ginbutang liwan ni Jesus ang anang alima sa mga mata kang bulag nga dya. Kag nagmulalung gid tana ka mayad kag nagbalik ang anang panuruk kag makita na run gid ka athag ang tanan. ");
INSERT INTO krj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ginpauli tana ni Jesus kag ginkun-an, “Indi kaw run magbalik rugto sa baryo!” ");
INSERT INTO krj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nag-agto si Jesus kag ang anang mga disipulo sa mga kabaryohanan kang Cesarea Filipos. Sa dalanun, ginpamangkot ni Jesus ang anang mga disipulo, “Abi, sugidi ninyo ako, para sa mga tawo sin-o ako?” ");
INSERT INTO krj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nagsabat sanda, “May mga nagakuon nga ikaw si Juan nga Manugbawtiso. Ang iba ruman tana nagakuon nga ikaw si Elias. Kag ang iba pa gid tana nagakuon nga isara ikaw sa mga propeta.” ");
INSERT INTO krj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ginpamangkot sanda ni Jesus, “Para tana kaninyo, sin-o ako?” Nagsabat si Pedro, “Ikaw amo ang Cristo!” ");
INSERT INTO krj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dayon ginmandoan sanda ni Jesus, “Indi gid ninyo pagpanugid sa bisan kay sin-o ang nahanungud kanakun!” ");
INSERT INTO krj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dayon nagpanudlo si Jesus kananda nga ang Anak kang Tawo kinahanglan nga mag-agum kang duro nga mga pag-antos, pagasikwayun tana kang mga kamal-aman kag kang mga pangulo kang kaparian kag kang mga manunudlo kang Kasugoan. Pagapatyun tana pero pagkatapos kang tatlo ka adlaw mabanhaw tana. ");
INSERT INTO krj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Maathag gid ang paghambal ni Jesus ka dya kananda. Gani gindara tana ni Pedro sa uruunahan kag ginsabdung. ");
INSERT INTO krj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero nagbalikid si Jesus kag ginturuk na ang iba nga mga disipulo kag ginsabdung si Pedro, “Parayu ikaw kanakun, Satanas! Ang imong panghuna-huna bukun ti sa Dios maghalin kundi sa tawo!” ");
INSERT INTO krj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dayon, gintawag ni Jesus ang mga tawo imaw kang anang mga disipulo kag nagkuon, “Ang bisan sin-o nga gusto magsunod kanakun kinahanglan nga indi na pagpasulabihun ang anang kaugalingun, kag magpas-an kang anang kros kag magsunod kanakun. ");
INSERT INTO krj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tungud hay ang bisan sin-o nga nagatipig kang anang kabuhi, maduraan ka dya. Pero ang bisan sin-o tana nga magdura kang anang kabuhi tungud kanakun kag sa Mayad nga Balita amo ang makaangkun kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tungud hay ano gid bala ang pulos kon maangkun kang tawo ang bilog nga kalibutan pero maduraan tana kang kabuhi? ");
INSERT INTO krj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ano ang mabaylo kang tawo agud nga maangkun na liwan ang anang kabuhi? Wara gid. ");
INSERT INTO krj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gani, ang bisan sin-o nga magakahuya kanakun kag kang akun mga pulong sa mga tawo nga nagtalikod sa Dios kag malaot sa kadya nga panag-on, ikahuya man tana kang Anak kang Tawo sa anang pagbalik nga may himaya kang anang Amay imaw kang balaan nga mga anghel.” ");
INSERT INTO krj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kag nagkuon pa gid si Jesus, “Sa pagkamatuod sugidan ko kamo, may iba nga nagatirindug rugya nga indi mapatay hasta nga makita nanda ang paghari kang Dios nga may gahum.” ");
INSERT INTO krj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkaligad kang anum ka adlaw, gin-imaw ni Jesus sanday Pedro kag ang magbugto nga si Santiago kag Juan kag nagtukad sanda sa sangka mataas nga bukid nga sandahanun lang. Samtang nagaturuk sanda kay Jesus, nakita nanda nga nagbaylo ang anang dagway. ");
INSERT INTO krj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ang anang bayo nagbanaag sa ka puti nga tama ka makasirilaw nga wara ti bisan sin-o sa kalibutan nga makapaputi kang pareho ka dya. ");
INSERT INTO krj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nakita nanda si Elias imaw ni Moises nga nagapakig-istorya kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kag nagkuon si Pedro kay Jesus, “Maestro, mayad gid nga rugya kita! Mahimo kami kang tatlo ka karakamalig, ang isara para kanimo, ang isara tana para kay Moises kag ang isara pa gid para kay Elias.” ");
INSERT INTO krj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wara tana kamaan kon ano ang anang hambalun tungud hay sobra gid ang andang kahadluk. ");
INSERT INTO krj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dayon, ginlikupan sanda kang panganod, kag may limug nga halin sa panganod nga nagakuon, “Amo dya ang akun hinigugma nga Anak, pamatii ninyo tana.” ");
INSERT INTO krj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sa hinali, kang magturuk sanda sa palibot, wara run sanda ti nakita nga imaw nanda magluwas lang kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kang nagapadulhog run sanda sa bukid, ginmandoan sanda ni Jesus nga indi gid nanda pagpanugid sa bisan kay sin-o ang andang nakita, hasta nga ang Anak kang tawo mabanhaw halin sa mga minatay. ");
INSERT INTO krj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gani ginhipsan lang nanda dya. Pero nagpinamangkotanay sanda kon ano ang buut hambalun kang anang ginkuon nga pagkabanhaw halin sa mga minatay. ");
INSERT INTO krj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kag ginpamangkot nanda si Jesus, “Andut haw nga nagakuon ang mga manunudlo kang Kasugoan nga kinahanglan magauna ka abot si Elias?” ");
INSERT INTO krj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nagsabat tana kananda, “Matuod gid man nga magauna ka abot si Elias sa pag-aman kang tanan nga mga butang. Kag andut haw nga ginakuon sa Kasulatan nga ang Anak kang Tawo kinahanglan nga mag-agum kang duro nga mga pag-antos kag pagasikwayun? ");
INSERT INTO krj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero ginakuon ko kaninyo nga nag-abot run si Elias kag ginhimo nanda kana kon ano ang gusto nanda himoon, suno sa nasulat sa kasulatan nahanungud kana.” ");
INSERT INTO krj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kang nakabalik run sanday Jesus sa iba nga mga disipulo, nakita nanda nga napalibotan sanda kang tama ka duro nga mga tawo, kag nagapakigbais kananda ang mga manunudlo kang kasugoan. ");
INSERT INTO krj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkakita kang mga tawo kay Jesus, natingala gid sanda ka mayad, kag nagdinalagan sanda sa pag-abi-abi kana. ");
INSERT INTO krj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nagpamangkot si Jesus sa anang mga disipulo, “Ano ang ginapakigbais ninyo kananda?” ");
INSERT INTO krj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nagsabat ang sangka tawo halin sa karak-an, “Maestro, gindara ko ang akun bata nga laki rugya kanimo tungud hay nasab-an tana kang malaot nga ispirito nga amo ang nagpaapa kana. ");
INSERT INTO krj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada aboton tana, ginalampus tana kang malaot nga ispirito. Dayon, nagaburora ang anang ba-ba kag nagabagrut ang anang mga unto kag nagatiskug tana. Ginpangabay ko ang imong mga disipulo nga paggwaun nanda ang malaot nga ispirito, ugaring indi man sanda makasarang.” ");
INSERT INTO krj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nagkuon si Jesus kananda, “Kamo nga mga tawo sa kadya nga panag-on wara gid kamo ti pagtoo! Hasta san-o pa ayhan nga magapakig-imaw ako kaninyo? Hasta san-o pa ayhan ang akun pag-agwanta kaninyo? Dar-a rugya kanakun ang bata!” ");
INSERT INTO krj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kag gindara nanda kana ang bata. Kang makita kang malaot nga ispirito si Jesus, ginpakudug na lagi ang bata. Natumba dya sa lupa kag nagligid-ligid nga nagaburora ang anang ba-ba. ");
INSERT INTO krj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ginpamangkot ni Jesus ang tatay kang bata, “Halin pa kan-o nga nagatulad tana karia?” Nagsabat ang tatay, “Halin pa ria kang bata pa tana. ");
INSERT INTO krj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Masami nga ginatablug na dya sa kalayo kag itagbung sa tubig agud nga mapatay. Gani kon makasarang ikaw, maluoy ikaw kanamun, kag buligi man kami.” ");
INSERT INTO krj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nagsabat si Jesus, “Ano ang buut mo hambalun kang, ‘kon makasarang kaw?’ Ang tanan nga butang mahimo gid sa tawo nga may pagtoo.” ");
INSERT INTO krj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lagi-lagi nagsinggit ang tatay kang bata, “Nagatuo ako pero kulang pa. Buligi ako sa kakulangan ko nga dya.” ");
INSERT INTO krj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kag kang matalupangdan ni Jesus nga ang mga tawo nagadinagusu run paagto kananda, ginmandoan na ang malaot nga ispirito, “Ikaw nga malaot nga ispirito nga nagapabungul kag nagapaapa, ginamandoan ko ikaw nga maggwa kana kag indi run gid magbalik liwan kana!” ");
INSERT INTO krj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nagsinggit ang malaot nga isipirito kag ginpakudug ka mayad ang bata kag naggwa. Ang bata daw sa bangkay run kon turukun, gani nga ang kalabanan sa mga tawo nagkuon, “Patay run ria!” ");
INSERT INTO krj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ginkaptan ni Jesus sa alima ang bata kag ginbuligan dya nga makatindug, kag nagtindug dya. ");
INSERT INTO krj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kang makasulud run sanday Jesus sa balay kag kang sandahanun run lang, ginpamangkot tana kang anang mga disipulo, “Andut nga indi tamun haw ka sarang magtabog kang malaot nga ispirito nga to?” ");
INSERT INTO krj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nagsabat si Jesus kananda “Indi nyo gid man masarangan nga itabogon ang amo to nga sahi kang malaot nga ispirito kon bukun ti paagi sa pangamuyo.” ");
INSERT INTO krj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naghalin sanday Jesus sa lugar nga to kag nag-agi sa Galilea. Indi malyag si Jesus nga may makamaan kon diin tana, ");
INSERT INTO krj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tungud hay nagapanudlo tana sa anang mga disipulo nga ang Anak kang Tawo igatugyan sa alima kang mga tawo. Pagapatyun nanda tana pero sa ikatlo nga adlaw mabanhaw tana. ");
INSERT INTO krj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero wara nanda mahangpi ang buut hambalun kang ginapanudlo na nga dya kag nahadluk man sanda mamangkot kana. ");
INSERT INTO krj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nag-abot sanda sa Capernaum. Kag kang sa balay run si Jesus ginpamangkot na ang anang mga disipulo, “Ano ang ginabaisan ninyo sa dalanun?” ");
INSERT INTO krj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero naghipus lang sanda tungud hay kang rugto sanda sa dalanun nagabinaisay sanda kon sin-o gid kananda ang labaw sa tanan. ");
INSERT INTO krj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nagpungko si Jesus kag gintawag na ang napulo'g darwa na ka disipulo kag nagkuon kananda, “Ang bisan sin-o nga gusto mangin una, kinahanglan nga mangin urihi tana sa tanan kag mangin alagad kang tanan.” ");
INSERT INTO krj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dayon, nagbuul tana kang sangka bata kag ginpatindug sa tunga nanda. Ginsabak na dya kag nagkuon kananda, ");
INSERT INTO krj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ang bisan sin-o nga magabaton sa sangka bata nga pareho ka dya tungud sa akun ngaran, nagabaton kanakun. Kag ang bisan sin-o nga nagabaton kanakun, bukun ti ako ang anang ginabaton kundi ang nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nagkuon si Juan kay Jesus, “Maestro, may nakita kami nga tawo nga nagapanabog man kang demonyo nga ginagamit ang imo ngaran kag gintapna namun tana tungud hay bukun tana ti kaimaw natun.” ");
INSERT INTO krj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero nagsabat si Jesus, “Indi ninyo tana pagtapnaa tungud hay wara ti bisan sin-o nga nagahimo kang makatiringala nga butang sa akun ngaran kag dayon maghambal kang sayud nahanungud kanakun. ");
INSERT INTO krj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tungud hay ang bisan sin-o nga wara nagakontra kanatun kadampig natun. ");
INSERT INTO krj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sugidan ko kamo, ang bisan sin-o nga magapainum kaninyo kang tubig tungud hay ana kamo ni Cristo magabaton gid tana kang padya.” ");
INSERT INTO krj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ang bisan sin-o nga mangin kabangdanan nga makasala ang isara sa mga kabataan nga dya, mas mayad pa nga pamatohan ang anang liug kang bahul nga garalingan nga bato kag itagbung sa dagat. ");
INSERT INTO krj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Gani kon ang imong alima amo ang mangin kabangdanan kang imong pagpakasala, utda dya. Mayad pa nga makaagum ikaw kang kabuhi nga wara ti katapusan nga sampihak ang imong alima sangsa darwa ang imong alima kag sa impyerno ikaw maagto, rugto sa kalayo nga wara ti katapusan ang anang pagdaba-daba, ");
INSERT INTO krj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nga sa diin ang mga ulod wara nagakapatay kag ang kalayo wara ti katapusan ang anang pagdaba-daba. ");
INSERT INTO krj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kag kon ang imong kahig amo ang mangin kabangdanan kang imong pagpakasala, utda dya. Mayad pa nga makaagum ikaw kang kabuhi nga wara ti katapusan nga sampihak ang imong kahig sangsa darwa ang imong kahig kag itablug ikaw sa impyerno, ");
INSERT INTO krj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nga sa diin ang mga ulod wara nagakapatay kag ang kalayo wara ti katapusan ang anang pagdaba-daba. ");
INSERT INTO krj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kag kon ang imong mata amo ang mangin kabangdanan kang imong pagpakasala, lukita dya. Mayad pa nga magpasakup ikaw sa paghari kang Dios nga sampihak ang imong mata sangsa timbang ang imong mata kag itablug ikaw sa impyerno, ");
INSERT INTO krj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nga sa diin ang mga ulod wara nagakapatay kag ang kalayo wara ti katapusan ang anang pagdaba-daba. ");
INSERT INTO krj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tungud hay ang kada isara pagapaputliun paagi sa kalayo pareho kang haralad nga ginaasinan. ");
INSERT INTO krj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mapuslanun ang asin pero kon madura run gani ka dya ang anang kapait, paano mo pa dya maggamit sa pag-unaw? “Mangin pareho kamo kang asin nga mapuslanun; magpakighidait kamo sa isara kag isara.” ");
INSERT INTO krj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pagkatapos karia, naghalin si Jesus sa lugar nga to kag mag-agto sa mga lugar nga sakup kang Judea kag sa tabok kang suba kang Jordan. Tama ruman ka duro nga mga tawo ang nagtiripon kana kag ginpanudloan na sanda suno sa anang kinaandan. ");
INSERT INTO krj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","May mga Fariseo nga nagparapit kay Jesus agud tirawan tana. Nagpamangkot sanda kana, “Sugidi kami, ginatugot bala sa kasugoan nga bulagan kang bana ang anang asawa?” ");
INSERT INTO krj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nagsabat si Jesus, “Ano haw ang sugo ni Moises kaninyo?” ");
INSERT INTO krj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nagkuon sanda, “Nagtugot si Moises nga ang bana maghimo kang kasulatan kang pagbulaganay sa anang asawa, kag dayon pahalinun na.” ");
INSERT INTO krj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pero nagkuon si Jesus kananda, “Ginsulat ni Moises ang sugo nga dya tungud hay mga awut kamo ti ulo. ");
INSERT INTO krj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero halin kang pagtuga kang kalibutan, ‘ang Dios nagtuga kananda nga laki kag bayi.’ ");
INSERT INTO krj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tungud ka dya ang laki magabiya sa anang tatay kag nanay kag magtingub sa anang asawa, ");
INSERT INTO krj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kag sanda nga darwa mangin isara.’ Gani bukun run sanda ti darwa kundi isara run lang. ");
INSERT INTO krj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Gani, ang gintingub run kang Dios indi dapat nga ibulagun kang bisan sin-o.” ");
INSERT INTO krj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kang sa balay sanda run, namangkot ang mga disipulo kana nahanungud sa mga butang nga dya. ");
INSERT INTO krj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nagkuon tana kananda, “Ang bisan sin-o nga magabulag sa anang asawa kag mangasawa liwan kang iba, dya nga tawo nakasala kang pagpanginbayi batok sa anang una nga asawa. ");
INSERT INTO krj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sa amo man, ang bayi nga magabulag sa anang bana kag mamana liwan kang iba, nakasala man tana kang pagpanginlaki.” ");
INSERT INTO krj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kar-on, may mga tawo nga nagpangdara kay Jesus kang mga magagmay nga mga bata agud nga matungtongan na sanda kang anang alima. Pero ginsaway sanda kang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ugaring kang makita dya ni Jesus, nag-ugut tana kag ginhambalan na ang mga disipulo, “Pabay-i lang ninyo ang mga bata nga magparapit kanakun kag indi ninyo sanda pagpunggi, tungud hay ang pagaharian kang Dios amo ang mga tawo nga pareho kananda. ");
INSERT INTO krj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sugidan ko kamo, ang bisan sin-o nga indi magbaton kang paghari kang Dios pareho kang mga bata nga dya indi makapasakup rugya ka dya.” ");
INSERT INTO krj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kag ginpangsabak na ang mga bata kag gintungtongan na kang anang alima ang kada isara kananda kag ginbindisyonan. ");
INSERT INTO krj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kang manugpanaw run si Jesus, may sangka tawo nga nagdalagan parapit kana kag nagluhod sa anang atubang kag nagpamangkot, “Mayad nga Maestro, ano bala ang akun dapat himoon agud to nga makaangkun ako kang kabuhi nga wara ti katapusan?” ");
INSERT INTO krj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nagkuon si Jesus kana, “Andut haw nga ginatawag mo ako nga mayad? Wara gid ti iba nga mayad kundi ang Dios gid lang. ");
INSERT INTO krj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Naman-an mo run kon ano ang ginakuon sa kasugoan: ‘Indi ikaw magpatay, indi ikaw magpakighilawas, indi ikaw magpanakaw, indi ikaw magbutig sa imo pagtistigo, indi ikaw magpangdaya, kag tahuda ang imong tatay kag nanay.’” ");
INSERT INTO krj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nagsabat ang tawo, “Maestro, natuman ko run ang tanan nga ria halin pa kang bata ako.” ");
INSERT INTO krj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ginturuk tana ni Jesus nga may pagpalangga, kag magkuon, “May sangka bagay pa nga nakulang kanimo. Panaw kag ibaligya ang imong mga pagkabutang kag ang kwarta ipanugro sa mga imol, kag makaangkun ikaw kang manggad sa langit, pagkatapos, balik ikaw rugya kag magsunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagkabati kang tawo ka dya, nasubuan gid tana ka mayad kag nagpanaw nga masinurub-un tungud nga tama gid tana ka manggaranun. ");
INSERT INTO krj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dayon, nagturuk si Jesus sa palibot kag nagkuon sa anang mga disipulo, “Daw ano ka budlay para sa mga manggaranun nga tawo ang magpasakup sa paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Natingala gid ang mga disipulo sa mga ginpanghambal na nga dya. Pero nagkuon liwan si Jesus kananda, “Mga anak, tama gid ka budlay ang magpasakup sa paghari kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas mahapus pa sa kamelyo ang mag-agi sa buho kang dagum sangsa manggaranun nga magpasakup sa paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tungud ka dya, labi pa gid nga natingala ang mga disipulo, kag nagpinamangkotanay sanda, “Kon amo, sin-o run lang bay ang maluwas?” ");
INSERT INTO krj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ginturuk sanda ni Jesus kag nagkuon, “Kon sa tawo indi gid dya mahimo, pero lain tana sa Dios, tungud hay ang tanan nga butang mahimo na.” ");
INSERT INTO krj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dayon nagkuon si Pedro, “Kami tamun, ginbayaan namun ang tanan kag nagsunod kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nagsabat si Jesus, “Sugidan ko kamo, wara ti bisan sin-o nga nagbiya kang anang balay ukon mga kabugtoan ukon nanay ukon tatay ukon mga kabataan ukon mga kalupaan tungud kanakun kag sa Mayad nga Balita, ");
INSERT INTO krj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nga indi makabaton kang balus nga sanggatos ka pilo sa kadya nga mga panag-on—mga balay, mga kabugtoan, mga nanay, mga kabataan, kag mga kalupaan, imaw man ang mga paghingabot. Kag sa paraaboton nga mga panag-on makaangkun tana kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero duro nga mga dungganun kadya ang mangin kubus sa urihi kag duro nga mga kubus kadya ang mangin dungganun sa urihi.” ");
INSERT INTO krj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa dalanun sanday Jesus patukad sa Jerusalem, kag nagauna si Jesus sa anang mga disipulo. Natingala sanda, kag ang iba tana nga mga nagasurunod nahadluk. Gintipon ruman ni Jesus ang anang mga disipulo kag naghambal tana kananda nahanungud sa anang ginapaabot nga matabo kana. ");
INSERT INTO krj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nagkuon tana, “Pamati kamo, nagatukad kita paagto sa Jerusalem nga sa diin ang Anak kang Tawo igatugyan sa mga pangulo kang Kaparian kag sa mga manunudlo kang kasugoan, kag sintensyahan nanda tana kang kamatayun kag itugyan sa mga bukun ti Judio. ");
INSERT INTO krj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pagayagutaun nanda tana, dupraan kag hanoton kag pagapatyun; pero pagkatapos kang tatlo ka adlaw mabanhaw tana.” ");
INSERT INTO krj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nagparapit kay Jesus ang mga bata ni Zebedeo nga sanday Santiago kag Juan kag magkuon kana, “Maestro, may ipangabay raad kami kanimo nga himoon mo para kanamun.” ");
INSERT INTO krj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nagsabat si Jesus, “Ano raad haw ang gusto ninyo nga himoon ko para kaninyo?” ");
INSERT INTO krj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nagsabat sanda, “Papungkoa kami sa tupad nimo kon maghari run ikaw; ang isara sa tuo nayon kag ang isara tana sa wala nayon.” ");
INSERT INTO krj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero nagkuon si Jesus kananda, “Wara kamo kamaan kon ano ang inyo ginapangayo. Masarangan bala ninyo atubangun ang mga pag-antos nga akun pagaantoson? Masarangan man bala ninyo atubangun ang kamatayun nga akun pagaagumun?” ");
INSERT INTO krj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nagsabat sanda, “Huud, masarangan namun!” Nagkuon si Jesus kananda, “Magaantos gid man kamo pareho kang akun pag-antos kag mapatay gid man kamo pareho kanakun. ");
INSERT INTO krj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero wara ako ti kinamatarung nga magpili kon sin-o ang magapungko sa akun tuo ukon wala, kundi ang Dios amo ang magatugro ka dya sa mga tawo nga anang gintigan-an.” ");
INSERT INTO krj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kang mabatian dya kang napulo ka disipulo, nag-ugut sanda kanday Santiago kag Juan. ");
INSERT INTO krj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gani gintipon sanda ni Jesus kag ginkun-an, “Nakamaan kamo nga ang mga tawo nga ginakabig nga mga manugdumara kang mga bukun ti Judio, amo ang nagagahum kananda, kag ang nagapangulo kananda amo ang ginasunod nanda. ");
INSERT INTO krj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero bukun tana ti amo ria kaninyo. Sa baylo, kon sin-o kaninyo ang gusto nga mangin dungganun, kinahanglan nga mangin surugoon tana kang tanan, ");
INSERT INTO krj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","kag kon sin-o man nga gusto mangin pangulo, kinahanglan nga mangin uripun tana kang tanan. ");
INSERT INTO krj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tungud hay bisan ang Anak kang Tawo wara mag-abot sa kalibutan para alagadun kundi para mag-alagad kag magtugro kang anang kabuhi sa pagtubos kang duro.” ");
INSERT INTO krj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kar-on, nakaabot sanda sa Jerico, kag kang nagapagwa run si Jesus sa syudad nga to imaw kang anang mga disipulo kag kang tama ka duro nga mga tawo, may sangka bulag rugto nga nagapungko kag nagapakilimos sa binit kang dalan. Tana ka dya si Bartimeo nga bata ni Timeo. ");
INSERT INTO krj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kang mabatian na nga si Jesus nga taga-Nazaret ang nagaagi, nagsinggit tana, “Jesus nga kaliwat ni David, maluoy ikaw kanakun!” ");
INSERT INTO krj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Duro nga mga tawo ang nagsaway kana kag ginkun-an tana nga maghipus. Pero gintudohan na pa gid gani nga singgit, “Kaliwat ni David, maluoy ikaw kanakun!” ");
INSERT INTO krj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nagpundo si Jesus kag magkuon, “Tawga ninyo tana!” Kag gintawag nanda ang bulag kag ginkun-an, “Magkalipay ikaw; tindug dyan, hay ginapatawag na ikaw.” ");
INSERT INTO krj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gintablug na ang anang kunup kag magtindug dayon kag magparapit kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ginpamangkot tana ni Jesus, “Ano haw ang gusto mo nga himoon ko kanimo?” Nagsabat ang bulag, “Maestro, gusto ko nga makakita.” ");
INSERT INTO krj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nagkuon si Jesus kana, “Panaw run. Ang imong pagtoo amo ang nag-ayad kanimo.” Kato lagi makakita run tana kag nagsunod tana kay Jesus sa dalanun. ");
INSERT INTO krj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kang nagahinamput run sanday Jesus sa Jerusalem marapit sa mga banwa kang Betfage kag Betania, rugto sa Bukid kang mga Olibo, ginsugo ni Jesus ang darwa na ka mga disipulo ");
INSERT INTO krj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nga nagakuon, “Agto kamo sa sunod nga baryo. Pag-abot ninyo rugto, may makita kamo nga sangka tinday nga asno nga nabangut kag wara pa gid masakyi. Hubadi ninyo dya kag dar-un rugya. ");
INSERT INTO krj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kon may mamangkot gani kaninyo kon andut nga ginahimo ninyo ria, sabtun ninyo nga, ‘Kinahanglan dya kang Ginoo kag ibalik na man dayon.’” ");
INSERT INTO krj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gani nagpanaw sanda kag nakita nanda sa dalan ang sangka tinday nga asno nga nabangut sa pwertahan kang sangka balay, kag ginhubadan nanda dya. ");
INSERT INTO krj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ang mga tawo rugto nga nagatirindug namangkot kananda, “Andut nga ginahubadan ninyo ang tinday nga ria?” ");
INSERT INTO krj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nagsabat sanda suno sa ginkuon ni Jesus kananda, kag ginpabay-an sanda nga maghalin. ");
INSERT INTO krj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gindara nanda ang tinday nga asno kay Jesus kag ginhapinan nanda kang andang mga kunup ang likod na ka dya kag nagsakay si Jesus rugya ka dya. ");
INSERT INTO krj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Duro nga mga tawo ang naghurumlad kang andang mga kunup sa dalan, samtang ang iba tana nagpanapas kang mga marabong nga sanga sa kaumahan kag ginpangladlad sa dalan. ");
INSERT INTO krj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ang mga tawo nga nagauna kay Jesus kag ang mga nagasurunod kana nagasiringgit, “Hosanna! Pakamayadun ang nagaabot nga ginpadara kang Ginoo! ");
INSERT INTO krj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pakamayadun ang magaabot nga ginharian kang atun ulang nga si David. Dayawun ang Dios sa kalangitan!” ");
INSERT INTO krj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nagsulud si Jesus sa Jerusalem kag nag-agto tana sa templo kag nagpanghulung-hulung sa palibot. Tungud hay sirum run, naggwa si Jesus kag nag-agto sa Betania imaw kang napulo'g darwa ka mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkadason nga adlaw, samtang nagapabalik sanday Jesus halin sa Betania, nakabatyag tana kang gutum. ");
INSERT INTO krj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","May nakita tana sa unahan nga kahoy nga higera nga marabong ang anang mga dahon. Gin-agtonan na dya kag turukun kon may bunga. Pero kang maparapitan na run dya, nasapwan na nga puro lang man dya dahon tungud hay bukun pa ti tagburunga kang higera. ");
INSERT INTO krj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Gani ginkun-an na ang kahoy nga higera, “Halin kadya wara run gid ti may magkaun kang imong bunga.” Ang ginkuon na nga dya nabatian kang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagkaabot nanda sa Jerusalem, nagsulud si Jesus sa templo kag ginpanabog na ang mga nagapamaligya kag nagapamakal. Ginpamaliskad na ang mga lamesa kang mga manugbaylo kang kwarta kag ang mga purongkoan kang mga manugbaligya kang pating. ");
INSERT INTO krj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gindumilian na ang bisan sin-o nga magdara kang bisan ano nga mag-agi sa templo. ");
INSERT INTO krj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gintudloan na ang mga tawo, “Indi bala nga nasulat sa kasulatan nga nagkuon ang Dios ‘Ang akun balay pagatawgun nga balay-parangamuyoan para sa tanan nga mga katawhan halin sa nagkalain-lain nga mga nasyon?’ Pero ginhimo ninyo dya nga paranagoan kang mga takawan.” ");
INSERT INTO krj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nabatian dya kang mga pangulo kang kaparian kag kang mga manunudlo kang Kasugoan. Gani, nagpangita sanda kang paagi nga mapatay si Jesus. Nahadluk sanda kana tungud hay ang tanan nga mga tawo nanamian gid sa anang mga ginapanudlo. ");
INSERT INTO krj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagkasirum, naggwa sanday Jesus sa syudad. ");
INSERT INTO krj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkaaga, samtang nagapanaw sanda sa dalanun, nakita nanda ang kahoy nga higera nga laya run hasta gid sa anang mga gamot. ");
INSERT INTO krj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadumduman ni Pedro ang natabo kag nagkuon tana kay Jesus, “Maestro, turuka bala, ang kahoy nga higera nga imo ginsumpa laya run!” ");
INSERT INTO krj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nagkuon si Jesus kananda, “Magtoo kamo sa Dios! ");
INSERT INTO krj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sugidan ko kamo, ang bisan sin-o nga magkuon sa bukid nga dya nga maghalin kag magsaylo sa dagat, kag wara nagapangduha-duha sa anang tagipusoon kundi nagatuo nga ang anang ginkuon matabo gid, matuman gid dya. ");
INSERT INTO krj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gani ginakuon ko kaninyo nga kon mangamuyo gani kamo sa pagpangayo kang bisan ano nga butang, magtuo kamo nga inyo run dya nabaton kag maangkun gid ninyo dya. ");
INSERT INTO krj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sa tion nagapangamuyo kamo, kon may ginalainan kamo kang buut patawara anay ninyo tana agud to nga ang inyo Amay sa langit magapatawad man kaninyo sa inyo mga kasal-anan. ");
INSERT INTO krj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero kon indi gani kamo magpatawad sa iba, indi man kamo pagpatawarun kang inyo Amay sa langit.” ");
INSERT INTO krj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nag-abot ruman sanday Jesus sa Jerusalem kag kang nagapanaw tana sa templo, ginparapitan tana kang mga pangulo kang kaparian, mga manunudlo kang Kasugoan kag kang mga kamal-aman. ");
INSERT INTO krj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ginpamangkot nanda si Jesus, “Ano ang imo awtoridad sa pagpanghimo kang dya nga mga butang? Kag sin-o ang nagtugro kanimo kang awtoridad sa paghimo ka dya?” ");
INSERT INTO krj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nagkuon si Jesus kananda, “May pamangkot man ako kaninyo; sabta ninyo ako, kag isugid ko kaninyo kon ano ang akun awtoridad sa paghimo kang dya nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sugidi ninyo ako, sa diin naghalin ang awtoridad ni Juan sa pagpangbawtiso, sa Dios bala ukon sa tawo?” ");
INSERT INTO krj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kag nagbinaisay sanda nga nagakuon, “Kon magkuon kita nga sa Dios maghalin, makuon tana nga, ‘Andut nga wara kamo magpati kana?’ ");
INSERT INTO krj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero kon magkuon kita nga ‘Sa tawo maghalin…’” (Nahadluk sanda sa mga tawo tungud hay ginakilala kang mga tawo nga si Juan matuod nga propeta.) ");
INSERT INTO krj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gani nagsabat sanda kay Jesus, “Wara tamun kamaan.” Kag ginkun-an man sanda ni Jesus, “Indi ko man pag-isugid kaninyo kon ano ang akun awtoridad sa paghimo kang dya nga mga butang.” ");
INSERT INTO krj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Naghambal si Jesus sa mga tawo paagi sa mga paraanggidan, “May sangka tawo nagtanum kang ubas sa anang uma. Ginkudalan na dya palibot kag nagkutkot tana kang buho para purugaan kang ubas. Nagpatindug man tana kang mataas nga barantayan. Pagkatapos, ginpaagsa na ang anang ubasan kag nagpanaw sa iba nga lugar. ");
INSERT INTO krj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kang pag-abot kang tag-arani kang ubas, nagpadara tana kang anang surugoon sa mga agsador sa pagbuul kang anang huray sa patubas. ");
INSERT INTO krj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero gindakup kang mga agsador ang surugoon kag ginbakol nanda dya kag ginpabalik nga wara gid ti dara. ");
INSERT INTO krj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dayon nagsugo liwan ang tag-iya kang lain nga surugoon. Ginlampusan dya kang mga agsador sa ulo kag ginpakahuy-an. ");
INSERT INTO krj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nagsugo pa gid tana kang sangka surugoon pero ginpatay nanda dya. Amo man dya ang natabo sa iba pa gid nga mga surugoon nga anang ginpadara. Ang iba ginpamakol nanda kag ang iba tana ginpamatay. ");
INSERT INTO krj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Isara run lang ang nabilin nga sarang na mapadara; ang anang pinalangga nga bata. Kang urihi, ginpadara na ang anang bata kananda. Nagkuon tana sa anang kaugalingun, ‘Tahaun gid nanda ang akun bata!’ ");
INSERT INTO krj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero nagmunohay ang mga agsador, ‘Dyaay ang manunubli! Dali, patyun natun tana agud to nga mangin atun run ang anang paranubliun!’ ");
INSERT INTO krj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gani gindakup nanda dya kag ginpatay, kag gintablug sa gwa kang ubasan. ");
INSERT INTO krj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kar-on, ano bay ang himoon kang tag-iya kang ubasan? Agtonan na kag pamatyun ang mga agsador kag ipaagsa na sa iba ang anang ubasan. ");
INSERT INTO krj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wara bala ninyo mabasa ang bahin kang kasulatan nga dya? ‘Ang bato nga wara maluyagi kang mga manughimo kang balay, amo pa ang nangin pinakapamusod nga bato. ");
INSERT INTO krj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ang Ginoo ang naghimo ka dya kag tama gid dya ka makatiringala!’” ");
INSERT INTO krj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gintinguhaan kang mga pangulo kang mga Judio nga dakpun si Jesus tungud hay naman-an nanda nga sanda ang ginatumud sa paraanggidan nga dya. Pero nahadluk sanda sa mga tawo gani ginbayaan nanda tana kag maghalin. ");
INSERT INTO krj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","May mga Fariseo kag mga sumuronod ni Herodes nga ginpaagto nanda kay Jesus agud dakup-dakupun tana paagi sa anang mga hambal. ");
INSERT INTO krj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nagparapit sanda kana kag nagkuon, “Maestro, naman-an namun nga nagahambal ikaw kang matuod kag wara ikaw nagapadara-dara sa tawo tungud hay wara ikaw ti pinilian. Kag ginatudlo mo kon ano ang kabubut-un kang Dios sa tawo. Kar-on, ginatugot bala kang Kasugoan ang magbayad kang buwis sa Emperador kang Roma, ukon wara? ");
INSERT INTO krj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dapat bala nga magbayad kita ukon indi?” Pero naman-an ni Jesus nga nagapakuno-kuno lang sanda, gani nagkuon tana kananda, “Andut haw nga ginadakup-dakup ninyo ako? Taw-i ninyo ako kang sangka kwarta nga pilak, kag turukun ko.” ");
INSERT INTO krj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gintugroan nanda tana. Kag ginpamangkot sanda ni Jesus, “Kay sin-o itsura kag ngaran ang nabutang rugya?” Nagkuon sanda kana, “Ana kang Emperador!” ");
INSERT INTO krj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Gani nagkuon si Jesus kananda, “Itugro ninyo sa Emperador ang para sa Emperador kag itugro ninyo sa Dios ang para sa Dios.” Kag natingala gid sanda kana. ");
INSERT INTO krj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","May mga Saduceo nga nag-agto kay Jesus. Sanda ka dya wara nagapati nga may pagkabanhaw. Namangkot sanda kay Jesus, ");
INSERT INTO krj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maestro, nagsulat si Moises para kanatun nga, ‘Kon mapatay ang sangka tawo kag mabilin ang anang asawa nga wara sanda ti bata, kinahanglan nga pangasaw-un kang bugto kang napatay ang balo agud to nga makapamata sanda para sa napatay.’ ");
INSERT INTO krj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","May pito ka magburugto nga laki. Nangasawa ang kagurangnan kag napatay nga wara ti bata. ");
INSERT INTO krj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ginpangasawa kang ikarwa nga bugto ang balo, kag napatay man dya nga wara sanda ti bata. Amo man ria ang natabo sa ikatlo nga bugto. ");
INSERT INTO krj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tanan sanda nga pito nagpangasawa sa bayi kag napatay nga wara sanda ti bata. Kang urihi run, napatay man ang bayi. ");
INSERT INTO krj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kar-on, sa adlaw nga ang mga patay banhawun, sa kay sin-o tana asawa tungud hay sanda nga pito nakapangasawa kana?” ");
INSERT INTO krj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nagkuon si Jesus kananda, “Nagsayup gid kamo tungud hay wara kamo nakamaan kang ginakuon sa kasulatan ukon kang gahum kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tungud hay kon banhawun run gani ang mga patay, indi run sanda ka dya mag-arasawahay; mangin pareho run sanda kang mga anghel sa langit. ");
INSERT INTO krj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kar-on, kon parte ruman tana sa pagkabanhaw kang mga patay, wara ninyo haw mabasahi sa libro ni Moises sa mga dinalan nahanungud sa nagadaba-daba nga purongpong? Nasulat rugto nga naghambal ang Dios kay Moises, ‘Ako ang Dios ni Abraham, ang Dios ni Isaac, kag ang Dios ni Jacob.’ ");
INSERT INTO krj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bukun tana ti Dios kang mga patay kundi kang mga buhi. Gani, sayup gid kamo.” ");
INSERT INTO krj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","May sangka manunudlo kang kasugoan rugto nga nakabati kang andang pagbinaisay. Natalupangdan na nga mayad ang pagsabat ni Jesus kananda. Gani nagparapit tana kay Jesus kag namangkot, “Ano bala nga sugo ang labing importante sa tanan?” ");
INSERT INTO krj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nagsabat si Jesus, “Amo dyaay ang labing importante nga sugo, ‘Pamati, Israel, ang Ginoo nga atun Dios, tana gid lang ang Ginoo; ");
INSERT INTO krj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","higugmaun mo ang Ginoo nga imo Dios sa bug-os nimo nga tagipusoon, sa bug-os nimo nga kalag, sa bug-os nimo nga panghuna-huna kag sa bug-os nimo nga ikasarang.’ ");
INSERT INTO krj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ang ikarwa amo dyaay, ‘Higugmaun mo ang imo isigka-tawo pareho kang imo paghigugma sa imong kaugalingun.’ Wara run ti iba pa nga sugo nga makalabaw sa darwa nga dya.” ");
INSERT INTO krj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nagsabat ang manunudlo kang kasugoan, “Igsakto ikaw, Maestro. Matuod gid ang imong ginkuon nga isara lang ang Dios kag wara run gid ti iba magluwas kana. ");
INSERT INTO krj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kag higugmaun tana sa bug-os nga tagipusoon, sa bug-os nga panghuna-huna kag sa bug-os nga ikasarang. Kag higugmaun man kang tawo ang anang isigka-tawo pareho kang anang paghigugma sa anang kaugalingun. Dya tanan labing importante sangsa paghalad kang mga sinunog nga sapat kag kang iba pa nga mga haralad sa Dios.” ");
INSERT INTO krj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nakita ni Jesus nga maaram tana magsabat, gani ginkun-an na dya, “Marapit run ikaw nga magpasakup sa paghari kang Dios.” Pagkatapos ka dya wara run ti nangahas nga magpamangkot kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Samtang nagapanudlo si Jesus sa templo, namangkot tana, “Paano makakuon ang mga manunudlo kang Kasugoan nga ang Mesias kaliwat ni David? ");
INSERT INTO krj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si David mismo nagkuon paagi sa pagtuytoy kang Balaan nga Ispirito, ‘Ang Ginoo nagkuon sa akun Ginoo, Pungko ikaw sa akun tuo nayon hasta nga mapyerde ko ang imong mga kaaway.’ ");
INSERT INTO krj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Si David mismo nagtawag kana nga Ginoo, gani paano bay nga nangin kaliwat tana ni David?” Malipayun nga nagpamati kana ang tama ka duro nga mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa anang pagpanudlo nagkuon si Jesus, “Mag-andam kamo sa mga manunudlo kang kasugoan. Nanamian sanda ka dya maglagaw-lagaw nga nagabayo kang malabug, kag bugnohon nga may pagtahod kang mga tawo sa tindahan. ");
INSERT INTO krj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gusto gid nanda magpungko sa mga importante nga purongkoan sa mga sinagoga kag sa mga purongkoan sa tabadan nga gintigana para sa mga dungganun nga tawo. ");
INSERT INTO krj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ginapamuul nanda ang mga pagkabutang kang mga bayi nga balo kag ginatabon-tabonan lang nanda ang andang mga malain nga ginahimo kang mga malawid nga pagpangamuyo. Mas tama gid ka budlay nga silot ang andang maaguman.” ");
INSERT INTO krj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nagpungko si Jesus sa atubang kang burutangan kang kwarta sa templo. Ginaturuk na ang raku nga mga tawo nga nagahulog kang andang kwarta sa burutangan. Raku nga mga manggaranun ang naghurulog kang daragkul nga kantidad. ");
INSERT INTO krj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dayon may nag-abot nga sangka imol nga bayi nga balo kag naghulog kang darwa ka metal nga sinsilyo nga nagatumbas kang gamay nga kwarta. ");
INSERT INTO krj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gintawag ni Jesus ang anang mga disipulo kag nagkuon kananda, “Sugidan ko kamo nga mas bahul pa ang ginhulog kang imol nga bayi nga dya sangsa tanan nga naghulog kang kwarta. ");
INSERT INTO krj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tungud hay ang iba nga to naghulog kang sobra sa andang manggad pero ang bayi tana nga dya bisan sa anang kaimolon gintugro na ang anang tanan, nga amo run lang ang nabilin nga anang pangabuhian.” ");
INSERT INTO krj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Samtang nagapagwa si Jesus sa templo, ang isara sa anang mga disipulo nagkuon kana, “Turuka bala Maestro, tama gid ka nami gid kang mga bato kag ka daragkul kang mga balay!” ");
INSERT INTO krj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nagsabat si Jesus kana, “Nakita mo ang daragkul nga mga balay nga dya? Wara gid ti bisan sangka bato nga mabilin nga nagasampaw sa isara; marumpag gid dya tanan.” ");
INSERT INTO krj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kang nagapungko si Jesus sa pagpanudlo rugto sa Bukid kang mga Olibo nga sa diin lantawun ang templo, nagparapit kana sanday Pedro, Santiago, Juan kag Andres kag nagpamangkot nga sandahanun lang, ");
INSERT INTO krj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sugidi kami, san-o bala dya matabo kag ano bala ang mga paratandaan nga matuman run ang tanan nga dya?” ");
INSERT INTO krj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nagkuon si Jesus kananda, “Mag-andam kamo nga indi kamo mapatalang ni bisan sin-o. ");
INSERT INTO krj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Duro nga mga tawo ang magaturohaw nga magapakuno-kuno nga sanda amo ang Cristo kag duro ang mapatalang. ");
INSERT INTO krj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kon makabati gani kamo kang mga ginahud kang gyera kag kang mga balita nga may gyera sa marayu, indi kamo magkahadluk. Ang mga butang nga dya kinahanglan nga matabo gid, pero bukun pa ti amo ria ang katapusan kang tanan. ");
INSERT INTO krj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tungud hay magairinaway ang mga nasyon kag amo man ang mga ginharian. May mga linog sa nagkalain-lain nga lugar kag magaabot ang taggurutum. Pero dya umpisa pa lang nga daw pareho kang una nga pagpakutuy kang manugbata. ");
INSERT INTO krj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kamo mismo mag-andam man tungud hay pagadakpun kamo kag itugyan sa mga hukmanan. Pagahanoton kamo sa mga sinagoga, kag pagapaatubangun kamo sa mga gobernador kag sa mga hari tungud kanakun agud to nga magapanaksi kamo kananda. ");
INSERT INTO krj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kag kinahanglan nga mawali gid anay ang Mayad nga Balita sa tanan nga mga nasyon. ");
INSERT INTO krj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kag kon dakpun gani nanda kamo kag dar-un sa hukmanan, indi kamo magpalibug kon ano ang inyo ihambal. Kon mag-abot ang tion nga to ihambal ninyo kon ano ang ginatugro kaninyo, tungud hay bukun kamo ang nagahambal kundi ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","May mga tawo nga magatugyan kang andang bugto para patyun, kag may mga tatay nga magahimo man ka dya sa andang mga kabataan, kag may mga kabataan nga magabato sa andang mga ginikanan kag ipapatay nanda dya. ");
INSERT INTO krj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaugtan kamo kang tanan tungud kanakun pero ang bisan sin-o tana nga magapadayon nga mapag-un hasta sa katapusan amo tana ang maluwas.” ");
INSERT INTO krj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kon makita run gani ninyo ang makangiril-ad nga butang nga nagatindug sa indi na dapat tindugan (sa mga nagabasa ka dya, intiendiha gid ninyo ang inyo ginabasa), dapat ang mga tawo rugyan sa Judea magparalagyo run sa kabukidan. ");
INSERT INTO krj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ang bisan sin-o nga rugto sa tapan nga atup kang anang balay, indi run magpanaog sa pagsulud sa anang balay para magbuul kang bisan ano. ");
INSERT INTO krj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kag ang bisan sin-o nga rugto sa uma, indi run dapat mag-uli sa pagbuul kang anang kunup. ");
INSERT INTO krj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Makaluluoy sa amo ria nga mga inadlaw ang mga nagabusong kag ang mga nagapatiti. ");
INSERT INTO krj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipangamuyo ninyo sa Dios nga indi dya matabo sa tagraramig. ");
INSERT INTO krj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tungud hay sa amo to nga mga inadlaw tama gid ka budlay ang mga kapipit-an nga magaabot nga wara pa maagumi kang mga tawo halin kang pagtuga kang Dios kang kalibutan hasta kadya kag wara run ti may matabo nga pareho karia sa paraaboton. ");
INSERT INTO krj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kag kon wara ginpabugu kang Ginoo ang tion nga ria wara gid ti tawo nga mabilin. Pero tungud gid lang sa anang mga pinili, ginpabugu na ang tion nga ria. ");
INSERT INTO krj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Gani kon may magkuon kaninyo nga ‘Dya run ang Cristo’ ukon ‘Rugto tana’ indi kamo magpati. ");
INSERT INTO krj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tungud hay may magaturohaw nga mga bukun ti matuod nga Cristo, kag mga nagapakuno-kuno nga propeta. Magahimo sanda kang mga milagro kag mga makatiringala nga mga butang sa katuyoan nga patalangun, kon mahimo pa lang, bisan ang mga pinili kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gani mag-andam kamo. Ginsugid ko run kaninyo ang tanan nga mga butang samtang wara pa dya matabo.” ");
INSERT INTO krj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sa mga inadlaw nga to, pagkatapos kang mga kapipit-an, ang adlaw magadulum, kag ang bulan indi run magsanag. ");
INSERT INTO krj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ang mga bituon magakarahulog halin sa langit kag ang mga butang sa kahawaan pagauyugun. ");
INSERT INTO krj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kag dayon makita kang mga tawo ang Anak kang Tawo nga nagaabot nga ginadara kang panganod; tuman gid ang anang gahum kag pagkamahimayaun. ");
INSERT INTO krj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dayon sugoon na ang anang mga anghel nga tiponon ang anang mga pinili halin sa tanan nga bahin kang kalibutan.” ");
INSERT INTO krj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Magtuon kamo halin sa kahoy nga higera. Kon nagapanglumbay run gani dya, maman-an ninyo nga dali run lang ang tag-irinit. ");
INSERT INTO krj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sa amo man nga bagay, kon makita gani ninyo nga nagakaratabo run ang mga butang nga dya, maman-an ninyo nga dali run lang tana mag-abot kag nagahinamput run. ");
INSERT INTO krj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sugidan ko kamo, magakaratabo ang tanan nga mga butang nga dya sa wara pa mapatay ang mga tawo sa dya nga panag-on. ");
INSERT INTO krj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Madura ang langit kag ang lupa, pero ang akun mga pulong magapabilin hasta san-o. ");
INSERT INTO krj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Wara gid ti bisan sin-o nga nakamaan kon ano nga adlaw ukon oras dya magakaratabo, bisan ang mga anghel sa langit ukon ang Anak; ang Amay gid lang ang nakamaan. ");
INSERT INTO krj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mag-andam kamo kag magbantay tungud hay wara kamo makamaan kon san-o magaabot ang tion nga ria. ");
INSERT INTO krj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Daw pareho dya kang sangka tawo nga nagpanaw sa marayu. Ginbayaan na ang anang balay kag gintugyan sa anang mga surugoon nga ang kada isara kananda may anang orobrahun. Ginbilinan na man ang manugbantay kang pwertahan nga magbantay gid. ");
INSERT INTO krj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gani magbantay gid kamo tungud hay wara kamo kamaan kon san-o magabalik ang agalun kang balay, kon sa kasisidmun ukon sa tungang gabii ukon sa tagparamalo kang sulog ukon sa kasanagun man. ");
INSERT INTO krj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Basi hinali lang mag-abot tana, kag masapwan na kamo nga nagakaraturog. ");
INSERT INTO krj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ang ginakuon ko kaninyo, ginakuon ko man sa tanan: Magbantay gid kamo.” ");
INSERT INTO krj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Darwa run lang ka adlaw kag amo run ang Pista kang Paglampuwas kag kang Tinapay nga Wara ti Tapay. Ang mga pangulo kang kaparian kag ang mga manunudlo kang Kasugoan nagapangita kang padihut sa pagpadakup kay Jesus sa tago kag sa pagpapatay kana. ");
INSERT INTO krj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nagkuon sanda, “Indi natun dya paghimoon sa adlaw kang pista hay basi maggirinamo ang mga tawo.” ");
INSERT INTO krj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Samtang rugto si Jesus sa Betania, sa balay ni Simon nga aruon, kag kang nagakaun tana, may sangka bayi nga nagparapit kana nga nagadara kang surudlan nga alabastro nga buta kang agwa nga puro nardo, kag tama gid dya ka mahal. Ginbuka na ang surudlan kag ginbu-bo ang agwa sa ulo ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ang iba nga mga tawo rugto nag-ugut kag nagmunohay, “Andut nga gin-uyangan lang ang agwa nga ria? ");
INSERT INTO krj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mabaligya pa raad dya kang sobra sa tatlo ka gatos ka kwarta nga pilak, kag ang bayad ipanugro sa mga imol!” Kag ginkaraan nanda ang bayi. ");
INSERT INTO krj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ginhambalan sanda ni Jesus, “Pabay-i lang ninyo tana; indi ninyo tana pagpahilabti. Mayad ang anang ginhimo nga dya kanakun. ");
INSERT INTO krj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kaimaw ninyo pirme ang mga imol kag bisan ano oras sarang ninyo sanda mabuligan kon gustohon ninyo. Pero ako tana indi ninyo kaimaw pirme. ");
INSERT INTO krj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginhimo na ang anang masarangan; ginbu-boan na kang agwa ang akun lawas sa pag-aman sa akun lubung. ");
INSERT INTO krj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sugidan ko kamo, bisan diin sa bug-os nga kalibutan iwali ang mayad nga balita, ang anang ginhimo nga dya isambitun man bilang pagdumdum kana.” ");
INSERT INTO krj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Si Judas Iscariote tana nga isara sa napulo'g darwa ka mga disipulo, nag-agto sa mga pangulo kang kaparian agud itugyan si Jesus kananda. ");
INSERT INTO krj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kang mabatian nanda dya, nalipay gid sanda kag ginsaadan nanda tana nga tugroan kang kwarta. Gani, umpisa kato, nangita si Judas kang kahigayonan sa pagluib kay Jesus. ");
INSERT INTO krj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sa nahauna nga adlaw kang Pista kang Tinapay nga wara ti Tapay nga amo ang adlaw nga ginaihaw ang tinday nga karnero para sa Pista kang Paglampuwas, ang mga disipulo nagpamangkot kay Jesus, “Sa diin mo gusto nga ihanda namun para kanimo ang pagkaun para sa Pista kang Paglampuwas?” ");
INSERT INTO krj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dayon ginsugo ni Jesus ang darwa sa anang mga disipulo kag ginkun-an, “Agto kamo sa syudad kag sug-alawun kamo kang sangka laki nga nagadara kang sangka tibud nga may tubig. Sundon ninyo tana, ");
INSERT INTO krj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kag kon sa diin nga balay tana magsulud, hambalan ninyo ang tagbalay, ‘Nagapamangkot ang Maestro kon sa diin nga kwarto tana kag ang anang mga disipulo magakaun sa Pista kang Paglampuwas.’ ");
INSERT INTO krj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kag ipakita na kaninyo ang sangka bahul nga kwarto sa ibabaw nga naaman run nga daan kag nasangkapan run. Rugto kamo maghimus para kanatun.” ");
INSERT INTO krj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nagpanaw ang mga disipulo kag mag-agto sa syudad kag nakita nanda ang tanan suno sa ginkuon kananda ni Jesus. Kag naghimus sanda rugto kang pagkaun para sa Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkagabii, nag-abot si Jesus imaw kang anang napulo'g darwa ka mga disipulo. ");
INSERT INTO krj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kang nagakaraun run sanda sa lamesa, nagkuon si Jesus, “Sugidan ko kamo, nga ang isara kaninyo magaluib kanakun, tana nga nagakaun imaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nasubuan gid ang mga disipulo kag kada isara kananda nagpamangkot kana, “Ako bala, Ginoo?” ");
INSERT INTO krj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nagsabat si Jesus, “Isara kaninyo nga napulo'g darwa kag kaimaw ko nga nagasawsaw kang tinapay sa yahong. ");
INSERT INTO krj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tungud hay ang Anak kang Tawo mapatay suno sa nasulat run nga daan. Pero makaluluoy gid ang madangatan kang tawo nga magaluib sa Anak kang Tawo. Mayad pa nga wara run lang tana matawo sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Samtang nagakaun sanda, nagbuul si Jesus kang tinapay kag nagpangamuyo sa pagpasalamat. Ginpamihak-pihak na dya kag ginpanugro kananda kag magkuon, “Batona ninyo; amo dya ang akun lawas.” ");
INSERT INTO krj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dayon nagbuul tana kang kupa kag nagpangamuyo sa pagpasalamat, kag gintugro kananda, kag tanan sanda nag-inum rugto. ");
INSERT INTO krj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nagkuon si Jesus kananda, “Amo dya ang akun dugo nga nagaparig-un kang kasugtanan kang Dios; ang akun dugo nga gin-ula para sa duro nga mga tawo para sa kapatawaran kang mga kasal-anan. ");
INSERT INTO krj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sugidan ko kamo, indi run ako liwan mag-inum kang bino nga halin sa ubas hasta sa adlaw nga mag-inum ako kang bag-o nga bino sa tion kang paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagkatapos nanda ka kanta kang pagdayaw, naggwa sanda kag mag-agto sa Bukid kang mga Olibo. ");
INSERT INTO krj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nagkuon si Jesus kananda, “Tanan kamo magaparalagyo kag magabiya kanakun, tungud hay nagkuon ang Dios sa kasulatan, ‘Pagapatyun ko ang manugbantay, kag magaharaplaag ang mga karnero.’ ");
INSERT INTO krj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero pagkatapos nga banhawun ako, magauna ako kaninyo rugto sa Galilea.” ");
INSERT INTO krj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nagkuon si Pedro, “Bisan magbiya sanda tanan kanimo, ako tana indi gid.” ");
INSERT INTO krj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nagkuon si Jesus kana, “Sugidan ko ikaw, kadya nga gabii antes makapamalo ang sulog kang darwa ka beses, tatlo ka beses mo ako nga ipanginwara.” ");
INSERT INTO krj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero nagpamirit gid si Pedro, “Bisan mapatay pa ako kaimaw nimo indi ko gid ikaw pag-ipanginwara.” Kag amo man dya ang ginhambal kang tanan. ");
INSERT INTO krj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nag-abot sanda sa lugar nga ginatawag Getsemane. Nagkuon si Jesus sa anang mga disipulo, “Pungko kamo rugya samtang nagapangamuyo ako.” ");
INSERT INTO krj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Gin-imaw na sanday Pedro, Santiago kag Juan, kag natublag gid tana ka mayad kag nagbatyag kang tuman nga kasubu. ");
INSERT INTO krj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nagkuon tana kananda, “Daw mapatay ako sa sobra nga kasubu. Pabilin lang kamo rugya kag magbantay.” ");
INSERT INTO krj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nag-agto si Jesus sa uruunhan nayon kag nagharapaun sa lupa kag magpangamuyo nga kon sarang pa lang mahimo mapaiway ang tion kang pag-antos nga anang ginapaabot. ");
INSERT INTO krj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nangamuyo tana, “Amay, Amay ko, mahimo nimo ang tanan nga butang. Ipaiway kanakun ang pag-antos nga dya, pero bukun ti akun kabubut-un ang matuman kundi ang imo.” ");
INSERT INTO krj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ginbalikan na ang tatlo ka mga disipulo kag nakita na sanda nga nagakaraturog. Ginkun-an na si Pedro, “Simon, nagakaturog bala ikaw? Indi kaw gid haw makapulaw bisan sangka oras lang? ");
INSERT INTO krj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpulaw kamo kag magpangamuyo agud to nga indi kamo masulay. Buut man ninyo ang maghimo kang mayad pero ang inyo lawas maluya.” ");
INSERT INTO krj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naghalin ruman si Jesus kag nangamuyo kang amo man angud nga mga tinaga. ");
INSERT INTO krj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ginbalikan na liwan ang anang mga disipulo kag nakita na sanda nga nagakaturog tungud hay tam-an gid sanda ka tuyo. Kag indi sanda kamaan kon ano ang andang isabat kana. ");
INSERT INTO krj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kang ikatlo na nga pagbalik kananda, nagkuon tana, “Nagakaturog kag nagapahuway pa angud kamo? Husto run ria! Nag-abot run ang tion nga ang Anak kang Tawo igatugyan sa alima kang mga tawo nga makasasala. ");
INSERT INTO krj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangon kamo, mapanaw kita. Rugya run ang tawo nga magaluib kanakun.” ");
INSERT INTO krj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Samtang nagahambal pa si Jesus, lagi-lagi nag-abot si Judas nga isara sa napulo'g darwa ka mga disipulo. Imaw na ang duro nga mga tawo nga nagadara kang mga espada kag ralampus. Ginpadara sanda ka dya kang mga pangulo kang kaparian, kang mga manunudlo kang Kasugoan kag kang mga kamal-aman. ");
INSERT INTO krj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nagkuon run nga daan kananda ang traidor, “Ang tawo nga akun iharkan, amo tana. Dakpun ninyo tana kag dar-un kag gwardyahan gid ka mayad.” ");
INSERT INTO krj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gani nga kang pag-abot ni Judas, ginparapitan na lagi si Jesus kag magkuon, “Maestro!” kag dara haruk kana. ");
INSERT INTO krj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dayon gindakup nanda si Jesus kag ginsiguro nga indi makapalagyo. ");
INSERT INTO krj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero may isara rugto nga nagatindug nga naghunos kang anang espada kag ginlabo ang surugoon kang pinakamataas nga pari kag nautas gid ang talinga na ka dya. ");
INSERT INTO krj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nagkuon si Jesus kananda, “Buyung ako haw nga kinahanglan pa nga magdara kamo kang mga espada kag ralampus sa pagdakup kanakun? ");
INSERT INTO krj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Adlaw-adlaw nagapanudlo ako sa templo kag rugto man kamo, kag wara man ninyo ako pagdakpa. Pero kinahanglan nga matuman ang ginakuon sa Kasulatan.” ");
INSERT INTO krj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dayon ginbayaan si Jesus kang tanan nga mga disipulo kag nagparalagyo sanda. ");
INSERT INTO krj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May sangka pamatan-un nga laki nga nagasunod kay Jesus. Nagatampi lang tana kang tela nga lino kag gindakup man nanda tana ka dya ");
INSERT INTO krj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero nakapanginpadlos tana kag nabilin ang anang ginatampi kag nagdalagan tana nga hublas. ");
INSERT INTO krj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gindara nanda si Jesus sa balay kang Pinakamataas nga Pari nga sa diin nagtiripon ang tanan nga mga pangulo kang kaparian, ang mga kamal-aman kag ang mga manunudlo kang Kasugoan. ");
INSERT INTO krj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro tana, nagasunod kana pero rayu ang anang antad, kag nagsulud man tana sa lagwerta kang balay kang Pinakamataas nga Pari. Rugto nagapungko tana kaimaw kang mga gwardya nga nagpainit-init marapit sa kalayo. ");
INSERT INTO krj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kar-on, ang mga pangulo kang kaparian kag ang bilog nga katapo kang Konseho nagtinguha gid sa pagpangita kang mga ebidensya batok kay Jesus agud nga mapapatay tana. Pero wara gid sanda ti makita. ");
INSERT INTO krj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Duro ang nagpanaksi kang bukun ti matuod batok kay Jesus pero wara man nagasirinanto ang andang mga ginasugid. ");
INSERT INTO krj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","May mga nagtirindug kag nagpanaksi kang bukun ti matuod batok kana nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nabatian namun tana nga naghambal nga igub-un na ang templo nga dya nga ginhimo kang tawo kag sa sulud kang tatlo ka adlaw mapatindug tana kang lain nga bukun ti hinimoan kang tawo.” ");
INSERT INTO krj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero bisan amo pa kato wara man angud pagsirinanto ang andang mga ginasugid. ");
INSERT INTO krj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nagtindug ang Pinakamataas nga Pari sa tunga nanda kag namangkot kay Jesus, “Wara gid bala ikaw ti isabat sa mga akusasyon nanda kontra kanimo?” ");
INSERT INTO krj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero wara gid maglimug si Jesus kag wara gid magsabat. Ginpamangkot liwan tana kang Pinakamataas nga Pari, “Ikaw gid bala ang Cristo nga Anak kang darayawun nga Dios?” ");
INSERT INTO krj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nagsabat si Jesus, “Huud, kag makita ninyo ang Anak kang Tawo nga nagapungko sa tuo nayon kang makagagahum nga Dios, kag makita man ninyo nga nagaabot nga ginadara kang panganod.” ");
INSERT INTO krj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gin-gisi kang Pinakamataas nga Pari ang anang bayo kag nagkuon, “Indi run natun kinahanglan kang mga testigo! ");
INSERT INTO krj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nabatian run man ninyo ang anang pagpasipala sa Dios. Ano ang inyo desisyon?” Kag ginpamatbatan nanda tana kang kamatayun. ");
INSERT INTO krj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gindupraan tana kang iba, ginpuyungan, kag ginsumbag kag ginkun-an, “Lat-a kon sin-o ang nagsumbag kanimo?” Ginbuul tana kang mga gwardya kag ginsagi ka tampa. ");
INSERT INTO krj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Si Pedro tana rugto angud sa idalum, sa lagwerta kang balay kang mag-abot ang isara sa mga surugoon nga bayi kang Pinakamataas nga Pari. ");
INSERT INTO krj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kang makita na si Pedro nga nagapainit-init marapit sa kalayo, ginturuk na dya kag nagkuon, “Kaimaw man ikaw ni Jesus nga taga-Nazaret.” ");
INSERT INTO krj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ginpanginwara dya ni Pedro, “Wara takun kamaan kag wara ako ka hangup kang ginakuon mo nga ria.” Kag nagpanaw tana paggwa sa pwertahan. Amo man to ang pagpamalo kang sulog. ");
INSERT INTO krj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nakita tana rugto kang surugoon nga bayi kag ginliwan na ang anang ginkuon nga ria sa mga nagatirindug rugto, “Ang tawo nga dya isara man kananda!” ");
INSERT INTO krj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ginpanginwara ruman dya ni Pedro. Wara magbuhay, ang mga nagatirindug rugto nagkuon ruman kay Pedro, “Sigurado gid nga isara ikaw kananda tungud hay Galileanhun man ikaw.” ");
INSERT INTO krj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero nagsabat si Pedro, “Bisan silotan pa ako kang Dios, matuod gid ang akun ginakuon kaninyo. Wara gid ako ka kilala kang tawo nga ginakuon ninyo nga ria.” ");
INSERT INTO krj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lagi-lagi kato, nagpamalo ang sulog sa ikarwa nga bes. Kag nadumduman ni Pedro ang ginkuon ni Jesus kana nga, “Antes ang ikarwa nga pagpamalo kang sulog, ipanginwara mo ako kang makatlo ka bes.” Kag naghiribiun si Pedro. ");
INSERT INTO krj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aga pa gid kang masunod nga adlaw, nagsinapol ang mga pangulo kang kaparian imaw kang mga kamal-aman kag mga manunudlo kang Kasugoan kag kang tanan nga mga katapo kang Konseho. Gin-gapos nanda si Jesus kag gindara kag gintugyan kay Pilato. ");
INSERT INTO krj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ginpamangkot tana ni Pilato, “Ikaw bala ang hari kang mga Judio?” Nagsabat si Jesus, “Ginhambal mo run.” ");
INSERT INTO krj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gin-akusar kang mga pangulo kang kaparian si Jesus kang duro nga mga butang. ");
INSERT INTO krj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gani ginpamangkot liwan tana ni Pilato, “Wara gid bala ikaw ti isabat kananda? Nabatian mo kon ano ka duro ang andang akusasyon batok kanimo.” ");
INSERT INTO krj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero wara run magsabat si Jesus, gani natingala gid si Pilato. ");
INSERT INTO krj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kar-on, kada pista kang paglampuwas kinabatasan ni Pilato nga maghilway kang sangka priso nga ginapangayo kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","May sangka priso rugto nga ginahingaranan kay Barabas. Tana ka dya napriso imaw kang mga rebelde nga nakapatay kang magpakigbato sanda sa gobyerno. ");
INSERT INTO krj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nag-abot ang duro nga mga tawo kag ginpangayo nanda kay Pilato nga himoon para kananda ang anang kinabatasan nga ginahimo. ");
INSERT INTO krj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ginpamangkot sanda ni Pilato, “Gusto bala ninyo nga hilwayun ko para kaninyo ang Hari kang mga Judio?” ");
INSERT INTO krj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tungud hay nasat-uman na nga gintugyan kana kang mga pangulo kang kaparian si Jesus tungud sa kahisa. ");
INSERT INTO krj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ginsudyot kang mga pangulo kang kaparian ang mga tawo nga si Barabas ang pangayoon nga hilwayun para kananda. ");
INSERT INTO krj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nagkuon liwan si Pilato kananda, “Ano bay ang akun himoon sa tawo nga ginatawag ninyo nga Hari kang mga Judio?” ");
INSERT INTO krj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nagsinggit sanda, “Ilansang tana sa kros!” ");
INSERT INTO krj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nagkuon si Pilato kananda, “Andut haw? Ano gid haw nga sala ang nahimo na?” Pero gintudohan pa gid nanda ka singgit, “Ilansang tana sa kros!” ");
INSERT INTO krj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tungud hay gusto ni Pilato nga malipay ang mga tawo, gani ginhilway na si Barabas para kananda. Si Jesus tana, ginpahanot na kag gintugyan kananda agud ilansang sa kros. ");
INSERT INTO krj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gindara kang mga suldado si Jesus sa sulud kang palasyo kang gobernador, nga ginatawag pretoryo, kag gintipon nanda ang bilog nga batalyon kang mga suldado. ");
INSERT INTO krj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ginkunupan nanda tana kang kunup nga kolor granate kag naghimo sanda kang koro-korona nga puro tunuk kag ginbutang dya sa anang ulo. ");
INSERT INTO krj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dayon ginasaludohan nanda tana nga nagakuon, “Dayawun ikaw nga Hari kang mga Judio!” ");
INSERT INTO krj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ginapakdol nanda tana sa ulo kang surusungkod, ginadupraan kag ginaluhod-luhodan nga nagapakuno-kuno nga ginasimba nanda tana. ");
INSERT INTO krj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatapos nanda ka yaguta kana, gin-uba nanda ang kunup nga granate kag ginpasuksok nanda liwan kana ang anang bayo. Dayon gindara nanda sa gwa agud ilansang sa kros. ");
INSERT INTO krj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa dalanun nasug-alaw nanda ang sangka tawo nga ginahingaranan kay Simon nga nagapasulud sa syudad halin sa uma. Tana ka dya taga-Cirene kag tatay ni Alejandro kag Rufo. Ginpirit tana kang mga suldado nga magpas-an kang kros ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gindara nanda si Jesus sa lugar nga ginatawag Golgota (nga kon sayudon, Lugar kang Bagol). ");
INSERT INTO krj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gintugroan nanda tana kang bino nga nasimbugan kang mira pero wara na dya gin-inum. ");
INSERT INTO krj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dayon, ginlansang nanda tana sa kros kag ginhururay ang anang bayo kag naggabot-gabot sanda para maman-an kon ano nga parte ang mabuul kang kada isara kananda. ");
INSERT INTO krj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas-nwebe ti aga kang ginlansang nanda si Jesus sa kros. ");
INSERT INTO krj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nasulat sa ibabaw nayon kang kros ang andang akusasyon batok kana, “Ang Hari kang mga Judio.” ");
INSERT INTO krj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","May darwa man ka kriminal nga andang ginlansang rugto imaw kay Jesus, ang isara sa anang tuo nayon kag ang isara tana sa anang wala. ");
INSERT INTO krj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gani natuman ang ginakuon sa Kasulatan nga, “Ginkabig tana nga isara man sa mga kriminal.” ");
INSERT INTO krj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ang mga nagaaragi rugto nagaulung-ulung kang anda mga ulo nga nagayaguta kana, “Gub-un mo gali ang templo kag patindugun dya sa sulud kang tatlo ka adlaw! ");
INSERT INTO krj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Panaog dyan sa kros kag luwasa ang imong kaugalingun.” ");
INSERT INTO krj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ginyaguta man tana kang mga pangulo kang kaparian imaw kang mga manunudlo kang Kasugoan nga nagakinun-anay, “Ginluwas na ang iba pero indi na maluwas ang anang kaugalingun. ");
INSERT INTO krj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Turukun ta nga magpanaog kadya sa kros ang Cristo nga hari kang Israel, agud to nga mapati kita kana.” Ang darwa nga ginlansang imaw kay Jesus nagpasipala man kana. ");
INSERT INTO krj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pagkaudto-adlaw, nagdulum ang bilog kalibutan hasta mag-alas tres sa hapon. ");
INSERT INTO krj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pagka alas-tres ti hapon, nagsinggit si Jesus sa mabaskug nga limug, “Eloi, Eloi, lema sabactani?” nga kon sayudon, “Dios ko, Dios ko, andut haw nga ginpabay-an mo ako?” ");
INSERT INTO krj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kang mabatian dya kang mga nagatirindug rugto, nagkuon sanda, “Pamatii ninyo, ginatawag na si Elias.” ");
INSERT INTO krj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","May sangka tawo nga nagdalagan kag nagtusmaw kang espongha sa langgaw kag ginbutang dya sa punta kang sanga kang kahoy kag gintunghol sa ba-ba ni Jesus kag magkuon, “Turukun ta kon maabot gid man si Elias sa pagbuul kana sa kros.” ");
INSERT INTO krj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nagsinggit kang matunog si Jesus kag nabugto ang anang ginhawa. ");
INSERT INTO krj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ang kurtina sa templo napihak sa tunga, halin sa ibabaw paidalum. ");
INSERT INTO krj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ang kapitan kang mga suldado nga nagatindug sa atubang ni Jesus, kang makita na kon paano nabugto ang ginhawa ni Jesus, nagkuon tana, “Matuod gid man nga ang tawo nga dya Anak kang Dios!” ");
INSERT INTO krj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","May mga bayi man sa uruunahan nga nagaturuk kang nagakaratabo nga dya. Ang iba kananda amo sanday Salome, Maria Magdalena kag si Maria nga nanay nanday Santiago nga bataun kag Jose. ");
INSERT INTO krj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sanda ka dya nagsunod kay Jesus kag nag-alagad kana kang rugto pa tana sa Galilea. May iba pa gid nga mga bayi rugto nga nag-imaw kay Jesus paagto Jerusalem. ");
INSERT INTO krj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pagkagabii, tungud hay adlaw to kang pag-aman ukon bisperas kang Adlaw nga Inugpahuway, ");
INSERT INTO krj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","si Jose nga taga-Arimatea nga sangka dungganun nga katapo kang konseho, nga nagahulat man nga mag-abot ang adlaw nga maghari ang Dios, nangisug nga magparapit kay Pilato kag ginpangayo ang bangkay ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Natingala gid si Pilato kang mabatian na nga patay run si Jesus. Gani ginpatawag na ang kapitan kag ginpamangkot kon patay run gid man si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagkamaan ni Pilato sa kapitan nga patay run gid man si Jesus, nagpasugot tana nga ibul-un ni Jose ang bangkay ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nagbakal si Jose kang tela nga lino kag gintaltal ang bangkay ni Jesus sa kros. Ginputos na dya kang tela nga lino kag ginbutang sa rulubngan nga gin-giab sa bato; dayon nagpaligid tana kang bato nga magatakup sa pwertahan kang rulubngan. ");
INSERT INTO krj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nakita nanday Maria Magdalena kag ni Maria nga nanay ni Jose kon sa diin ginlubung si Jesus. ");
INSERT INTO krj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagkatapos kang Adlaw nga Inugpahuway, nagbakal kang pahamot sanday Maria Magdalena, Maria nga nanay ni Santiago, kag si Salome agud ihaplas sa bangkay ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aga-aga pa gid kang nahauna nga adlaw kang semana, pagbutlak kang adlaw, nag-agto sanda sa rulubngan. ");
INSERT INTO krj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sa dalanun, nagapamangkotanay sanda kon sin-o ang magapaligid para kananda kang bato nga nagatakup sa gawang kang rulubngan. ");
INSERT INTO krj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kang paglantaw nanda, nakita nanda nga napaligid run ang bato; tama gid dya ka bahul. ");
INSERT INTO krj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pagsulud nanda sa rulubngan may nakita sanda nga pamatan-un nga laki nga nagapungko sa tuo nayon nga nagasuksok kang bayo nga puti, kag hinadlukan gid sanda. ");
INSERT INTO krj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nagkuon ang laki kananda, “Indi kamo magkatingala! Ginapangita ninyo si Jesus nga taga-Nazaret nga ginlansang sa kros; nabanhaw run tana, wara tana rugya. Turuka ninyo ang ginhamyangan kana. ");
INSERT INTO krj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pero, panaw kamo kag isugid ninyo sa anang mga disipulo kag kay Pedro nga magauna si Jesus kaninyo sa Galilea. Makita ninyo tana rugto pareho kang anang ginkuon kaninyo.” ");
INSERT INTO krj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gani naggwa ang mga bayi nga dya sa rulubngan kag nagparalagyo. Nagakurudug sanda sa kahadluk kag natingala gid. Wara gid sanda ti ginsugidan tungud hay hinadlukan gid sanda.  ");
INSERT INTO krj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pagkabanhaw ni Jesus, aga pa gid kang nahauna nga adlaw kang semana, nagpakita tana una kay Maria Magdalena nga nasab-an anay kang pito ka demonyo pero gintabog dya ni Jesus. ");
INSERT INTO krj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nagpanaw si Maria kag ginsugid na ang anang nakita sa mga kaimaw anay ni Jesus; nagapangasubu sanda kag nagaparanangisun. ");
INSERT INTO krj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero kang mabatian nanda nga buhi si Jesus kag nakita pa ni Maria, wara gid sanda magpati. ");
INSERT INTO krj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatapos ka dya, nagpakita man si Jesus sa lain nga dagway sa darwa ka mga sumuronod samtang nagapanaw sanda paagto sa uma. ");
INSERT INTO krj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nagbalik sanda kag ginsugidan ang iba nanda nga mga kaimaw pero wara man sanda magpati kananda. ");
INSERT INTO krj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kang urihi, nagpakita si Jesus sa napulo'g isara ka mga disipulo mismo samtang nagakaraun sanda. Ginkaraan na sanda tungud nga wara sanda magpati kag tungud nga mga awut sanda ti ulo. Tungud hay wara gid sanda magpati sa mga ginpanugid kang mga nakakita kana pagkatapos nga nabanhaw tana. ");
INSERT INTO krj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nagkuon si Jesus kananda, “Panaw kamo sa bug-os nga kalibutan kag iwali ang mayad nga balita sa tanan nga mga tawo. ");
INSERT INTO krj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ang bisan sin-o nga magatuo kag magapabawtiso maluwas. Pero ang bisan sin-o nga indi magtuo pagasintensyahan kang kamatayun. ");
INSERT INTO krj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kag amo dya ang mga paratandaan nga makita sa mga tawo nga magatuo kanakun: paagi sa akun ngaran magapanabog sanda kang mga demonyo; magahambal sanda sa nagkalain-lain nga linggwahe nga wara nanda maton-i; ");
INSERT INTO krj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","magapurot sanda kang mga sawa ukon makainum kang hilo, pero indi sanda maiwan; magatungtong sanda kang andang alima sa mga nagamarasakit kag magaarayad dya.” ");
INSERT INTO krj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatapos nga nakapakighambal si Ginoong Jesus sa anang mga sumuronod, gindara tana palangit kag nagpungko sa tuo kang Dios. ");
INSERT INTO krj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nagpanaw ang mga sumuronod kag nagpangwali sa bisan diin nga lugar. Nagpanghikot ang Ginoo paagi kananda kag ginpamatud-an na ang andang ginapangwali paagi sa mga milagro nga nagakatabo.");
INSERT INTO krj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Halangdun nga Teofilo, Duro run nga mga tawo ang nagtinguha nga magsulat kang bug-os nga istorya nahanungud sa mga butang nga nagkaratabo rugya kanamun. ");
INSERT INTO krj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ginsulat nanda ang mga ginpanugid kanamun kang mga tawo nga nakasaksi gid kang mga nagkaratabo halin kang pag-umpisa na kadya, kag sanda man ang nagbantala kang dya nga balita. ");
INSERT INTO krj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gani, halangdun nga Teofilo, tungud nga akun man nausisaan kang maid-id ang tanan nga mga butang nga dya halin sa ana ginsugodan, ginpakamayad ko man nga isulat dya kang paaragisud para kanimo. ");
INSERT INTO krj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Sa amo dya nga paagi imo maman-an ang bug-os nga kamatuoran nahanungud sa mga butang nga gintudlo run kanimo. ");
INSERT INTO krj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Katong tyempo nga si Herodes amo ang hari kang Judea, may sangka pari anay rugto nga ginahingaranan kay Zacarias, kag tana ka dya isara sa mga pari sa hubun ni Abias. Si Zacarias may asawa nga ginahingaranan kay Elisabet, nga sa linahi man ni Aaron maghalin. ");
INSERT INTO krj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sanda nga mag-asawa pareho nga nagakabuhi ka matarung sa panuruk kang Dios. Ginatuman nanda kang maid-id ang tanan nga mga sugo kag iba pa nga mga ginapatuman kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ugaring wara sanda ti bata tungud nga si Elisabet baw-as kag luwas pa dyan karia, mal-am run sanda nga darwa. ");
INSERT INTO krj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kar-on, samtang nagahimo tana kang anang hirikoton bilang pari, kang ang andang hubun amo ang nagapangalagad sa templo, ");
INSERT INTO krj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kang maggabot-gabot sanda nga suno sa kinabatasan kang mga kaparian, tana ang natuonan nga magsulud sa templo kang Ginoo kag magsunog kang insinso sa altar. ");
INSERT INTO krj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Samtang ginasunog ang insinso, sa gwa tana duro ka raku nga mga tawo ang nagaparangamuyo. ");
INSERT INTO krj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sa hinali, may nagpakita kana nga sangka anghel kang Ginoo nga nagatindug sa tuo nayon kang altar nga ginasunogan kang insinso. ");
INSERT INTO krj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kang makita ni Zacarias ang anghel, naurongan tana kag gindakup kang kahadluk. ");
INSERT INTO krj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero nagkuon kana ang anghel, “Zacarias, indi ikaw magkahadluk. Ginsabat run kang Dios ang imo pangamuyo, si Elisabet nga imo asawa magabata kang sangka laki, kag pagahingaranan nimo tana kay Juan. ");
INSERT INTO krj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magakalipay ikaw kag magakasadya, kag duro ang magakalipay sa tion nga tana matawo. ");
INSERT INTO krj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tungud hay mangin dungganun tana sa panuruk kang Ginoo. Indi tana mag-inum kang bino ukon bisan ano nga makarilingin nga irimnun. Bisan gani nga wara pa tana matawo nagamhan run tana kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Duro nga mga Israelenhun ang ana pagapabalikun sa anda nga pagtoo sa Ginoo nga anda Dios. ");
INSERT INTO krj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Magauna tana sa Ginoo nga may Ispirito kag gahum nga pareho kang ana ni propeta Elias. Pagapanumbalikun na ang paghiripathaay kang mga tatay kag mga kabataan, kag ang mga tawo nga malalisun pabalikun na man sa matarung nga pagbinatasan, agud to sa pag-aman kang mga tawo sa pag-abot kang Ginoo.” ");
INSERT INTO krj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pero nagkuon si Zacarias sa anghel, “Ano bay ang pagkamaan ko kon matuod ang ginahambal mo hay mal-am run ako kag ang akun asawa amo man?” ");
INSERT INTO krj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nagsabat ang anghel, “Ako si Gabriel nga nagaalagad sa prisensya kang Dios, kag ginsugo na ako sa paghambal kag pagsugid kanimo kang mayad nga balita nga dya. ");
INSERT INTO krj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kar-on, tungud hay wara ikaw magpati sa akun ginpanugid kanimo, magaapa ikaw hasta sa adlaw nga matuman dya, tungud nga ang akun ginpanugid nga dya kanimo matuman gid sa pag-abot kang gintalana nga tion.” ");
INSERT INTO krj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Rugto tana sa gwa, ang mga tawo naghinulat kay Zacarias, kag natingala sanda kon andut nga buhay tana sa sulud kang templo. ");
INSERT INTO krj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Paggwa na, indi run tana makahambal sa mga tawo, kag nasat-uman nanda nga may nakita tana nga paranan-awun sa sulud kang templo. Kag tungud nga indi run tana makamitlang, nagsenyas run lang tana sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagkatapos kang tion kang anang pagpangalagad sa Templo, nag-uli tana sa andang balay. ");
INSERT INTO krj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Magpira ka adlaw, nagbusong si Elisabet nga anang asawa kag sa sulud kang lima ka bulan wara gid tana maggwa sa balay. ");
INSERT INTO krj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nagkuon si Elisabet sa anang kaugalingun, “Ginbuligan run ako kang Ginoo kag sa dya nga paagi ginbuul na ang akun kahuruy-anan sa mga tawo!” ");
INSERT INTO krj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kang anum run ka bulan ang pagbusong ni Elisabet, ginsugo kang Dios ang anghel nga si Gabriel nga mag-agto sa Nazaret nga sangka banwa sa Galilea, ");
INSERT INTO krj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","sa sangka ulay nga ginahingaranan kay Maria. Dya si Maria natangdu run nga pagakaslun kay Jose nga isara sa mga kaliwat ni Haring David. ");
INSERT INTO krj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ang anghel nag-agto kay Maria kag nagkuon, “Magkalipay ikaw! Ang Ginoo nagaimaw kanimo, kag ginakahamut-an na ikaw!” ");
INSERT INTO krj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Natublag gid si Maria sa ginhambal kang anghel kag ana nga ginpaminsar kon ano gid ang gusto hambalun ka dya. ");
INSERT INTO krj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dayon nagkuon ang anghel kana, “Maria indi ikaw magkahadluk. Ang Dios nahamuut kanimo. ");
INSERT INTO krj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pamati. Magabusong ikaw kag magabata kang sangka lapsag nga laki, kag imo tana pagahingaranan kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mangin dungganun tana kag pagatawgun nga Anak kang Dios nga Labing Mataas. Pagahimoon tana kang Ginoong Dios nga hari pareho ni David nga ana ulang. ");
INSERT INTO krj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Magahari tana kang nasyon nga Israel hasta san-o kag ang anang ginharian magapadayon sa wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nagkuon si Maria sa anghel, “Paano bay dya matabo hay ako sangka ulay nga daraga?” ");
INSERT INTO krj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nagsabat ang anghel, “Ang Balaan nga Ispirito magapanaog rugya kanimo kag pagalikupan ikaw kang gahum kang Labing Mataas nga Dios. Gani ang bata nga imo igabataun, balaan kag pagatawgun nga Anak kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bisan gani ang imo himata nga si Elisabet nga ginakuon nga indi makapamata nagabusong run kadya kang anum ka bulan, bisan pa nga mal-am tana run. ");
INSERT INTO krj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tungud hay sa Dios tana, wara ti bisan ano nga butang nga indi na mahimo.” ");
INSERT INTO krj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kag nagsabat si Maria, “Surugoon lang ako kang Ginoo. Kabay pa nga matuman dya kanakun, suno sa imo ginhambal.” Kag dayon naghalin ang anghel. ");
INSERT INTO krj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sa wara magbuhay naghimus si Maria kag nagdali-dali sa pag-agto sa sangka banwa sa barabakulodon nga parte kang Judea. ");
INSERT INTO krj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nagdiretso tana sa balay ni Zacarias. Pag-abot na rugto, gintamyaw na si Elisabet. ");
INSERT INTO krj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kang mabatian ni Elisabet ang pagtamyaw ni Maria, nagkibo ang bata sa busong ni Elisabet kag gin-gamhan tana kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dayon naghambal tana sa mabaskug nga limug, “Bulahan ikaw sa tanan nga mga bayi, kag amo man ang lapsag nga imo igabataun. ");
INSERT INTO krj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Daw ano dya nga kadungganan nga duawun ako ka nanay kang akun Ginoo! ");
INSERT INTO krj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tungud hay kang pagkabati ko kang imo nga pagtamyaw, ang bata sa akun busong nagkibo sa kalipay. ");
INSERT INTO krj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bulahan gid ikaw tungud hay nagpati ikaw nga ang ginpamaan kang Ginoo kanimo matuman gid!” ");
INSERT INTO krj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nagkuon si Maria, “Nagadayaw gid ako sa Ginoo, ");
INSERT INTO krj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kag nagakalipay ang akun tagipusoon tungud kang Dios nga akun Manluluwas. ");
INSERT INTO krj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tungud hay gindumdum na ako nga anang kubus nga surugoon. Halin kadya ang tanan nga tawo magakuon nga bulahan ako ");
INSERT INTO krj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tungud kang dungganun nga mga butang nga ginhimo kanakun kang Makagagahum nga Dios. Balaan ang ana nga ngaran! ");
INSERT INTO krj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sa mga nagasurondanay nga henerasyon ginkaluy-an na ang mga tawo nga nagakahadluk kana. ");
INSERT INTO krj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Paagi sa ana mga hinimoan ginpakita na ang anang pagkagamhanan. Ang mga tawo nga matinaas-taasun sa anda paminsarun ana nga ginpaharaplaag. ");
INSERT INTO krj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ginpahalin na ang gamhanan nga mga hari sa andang mga trono. Kag ang mga kubus tana ana nga ginbayaw. ");
INSERT INTO krj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ginbusog na kang mayad nga mga butang ang mga gutum. Kag ang mga manggaranun tana ginpalayas na nga wara gid ti bisan ano nga dara. ");
INSERT INTO krj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gintuman na ang anang ginsaad sa atun mga kaulangan, kag nag-abot tana sa pagbulig kang anang pinili nga nasyon nga Israel. ");
INSERT INTO krj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Wara na nalipatan nga kaluy-an si Abraham kag ang anang mga linahi sa wara ti katapusan!” ");
INSERT INTO krj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nagpabilin si Maria kanday Elisabet kang mga tatlo ka bulan kag mag-uli sa andang balay. ");
INSERT INTO krj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nag-abot ang tion nga magabata run si Elisabet, kag nagbata tana kang sangka lapsag nga laki. ");
INSERT INTO krj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nabalitaan kang anang mga iningud kag mga himata kon daw ano ka makatiringala nga kaluoy ang ginhimo kang Ginoo kana, gani nagkinasadya sanda imaw kana. ");
INSERT INTO krj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kang walo run ka adlaw ang bata, nag-abot sanda sa pagsirkom kana. Pangaranan raad nanda dya nga Zacarias pareho kang ngaran kang anang tatay. ");
INSERT INTO krj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ugaring nagkuon ang anang nanay, “Bukun ti Zacarias ang ipangaran kana kundi Juan!” ");
INSERT INTO krj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nagkuon sanda kana, “Pero wara man kamo ti paryente nga amo karia ang ngaran na!” ");
INSERT INTO krj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dayon nagsenyas sanda sa tatay kang bata agud pamangkoton kon ano ang gusto na nga ipangaran sa bata. ");
INSERT INTO krj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kag nangayo si Zacarias kang surulatan, kag nagsulat, “Ang ngaran na karia si Juan.” Kag natingala sanda tanan. ");
INSERT INTO krj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kag lagi-lagi nakahambal liwan si Zacarias, kag nag-umpisa tana sa pagdayaw sa Dios. ");
INSERT INTO krj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hinadlukan gid ang andang mga iningud, kag bisan sa diin nga hilit-hilit kang barabakulodon nga lugar kang Judea, ang natabo nga dya amo run lang ang ginaistoryahan kang tanan. ");
INSERT INTO krj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ang tanan nga nakabati kang dya nga mga butang nagbinag-binag kag namangkot sa andang kaugalingun, “Mangin ano ayhan ang bata nga dya kon magbahul?” Tungud hay makita gid nga ang gahum kang Ginoo rugyan kana. ");
INSERT INTO krj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Zacarias nga tatay ni Juan gin-gamhan kang Balaan nga Ispirito kag nagpanagna: ");
INSERT INTO krj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawun natun ang Ginoong Dios kang Israel! Nag-abot tana kag ginhilway ang anang katawhan. ");
INSERT INTO krj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nagtugro tana kang gamhanan nga Manluluwas para kanatun nga linahi kang ana surugoon nga si David. ");
INSERT INTO krj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pareho kang anang ginsaad paagi sa anang mga balaan nga propeta kauna, ");
INSERT INTO krj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nga hilwayun na kita sa atun mga kaaway, kag sa gahum kang tanan nga nagadumut kanatun. ");
INSERT INTO krj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nagkuon tana nga kaluy-an na ang atun mga kaulangan kag tumanun na ang anang balaan nga kasugtanan. ");
INSERT INTO krj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nagsumpa tana sa atun ulang nga si Abraham, ");
INSERT INTO krj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nga hilwayun na kita sa atun mga kaaway, agud to nga makapangalagad kita kana nga wara ti ginakahadlukan, ");
INSERT INTO krj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kag mangin balaan kita kag matarung sa anang panuruk samtang nagakabuhi kita. ");
INSERT INTO krj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Kag ikaw tana, anak, pagatawgun ikaw nga propeta kang Dios nga Labing Mataas. Tungud hay magaabot ikaw una sa Ginoo sa paghanda kang anang mga aragyan. ");
INSERT INTO krj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Magapamaan ikaw sa anang mga katawhan nga maluwas sanda paagi sa pagpatawad kang Dios kang andang mga kasal-anan, ");
INSERT INTO krj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","tungud kang pagkamaluloy-on kag pagkamahigugmaun kang atun Dios. Ang pagluwas nga ana pagahimoon pareho kang nagabutlak nga adlaw nga nagasirak kanatun halin sa langit, ");
INSERT INTO krj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","agud nga magtugro kang kasanag sa mga tawo nga rugyan sa madulum nga haron kang kamatayun tungud kang sala. Magatuytoy man dya kanatun agud to nga makaagum kita kang kalinungan.” ");
INSERT INTO krj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kar-on, ang bata nga si Juan nagbahul kag naghamtung sa anang ispiritohanun nga pagkabuhi. Nagtiner tana sa kamingawan hasta sa adlaw nga magpahayag tana sa mga katawhan kang Israel. ");
INSERT INTO krj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Katong mga panag-on nga si Agusto amo ang emperador, nagpapanaog tana kang mando nga ang tanan nga mga pumuloyo nga nasakpan kang Roma magparehistro. ");
INSERT INTO krj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Amo dya ang una nga pagpangrehistro, kag ginhimo dya kang si Quirinio amo ang gobernador kang Siria. ");
INSERT INTO krj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gani ang tanan nga mga tawo nag-aragto sa andang kaugalingun nga banwa sa pagparehistro. ");
INSERT INTO krj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Jose, halin sa Nazaret nga banwa kang Galilea, nagtukad sa Judea, rugto sa sangka banwa nga ginatawag Betlehem nga sa diin natawo si Haring David, tungud hay si Jose nga dya linahi man ni David. ");
INSERT INTO krj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nag-agto tana rugto agud magparehistro imaw ni Maria nga natangdu run nga pagakaslun kana. Sa amo to nga tion, nagabusong si Maria. ");
INSERT INTO krj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kag kang rugto sanda sa Betlehem, nag-abot ang tion nga si Maria magabata run. ");
INSERT INTO krj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nagbata tana kang anang panganay nga laki. Ginbarahosan na dya ka lampin kag ginbutang sa pasungan, tungud hay wara run ti lugar para kananda sa balay nga darayonan. ");
INSERT INTO krj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sa amo man to nga lugar may mga manugbantay kang karnero sa kapatagan nga nagapamulaw bantay kang andang mga panung. ");
INSERT INTO krj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dayon may sangka anghel kang Ginoo nga nagpakita kananda, kag ang makasirilaw nga kasidlak kang Ginoo nagsanag sa andang palibot, kag hinadlukan gid sanda ka mayad. ");
INSERT INTO krj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero naghambal kananda ang anghel, “Indi kamo magkahadluk! May mayad ako nga balita nga isugid kaninyo nga amo ang magatugro kang tuman nga kalipay sa tanan nga mga katawhan. ");
INSERT INTO krj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sa amo gid dya nga adlaw rugto sa Betlehem nga banwa ni David natawo ang inyo Manluluwas, tana ang Cristo nga Ginoo. ");
INSERT INTO krj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Amo dya ang paratandaan ninyo: makita ninyo ang sangka bata nga nabarahosan ka lampin nga nabutang sa pasungan.” ");
INSERT INTO krj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sa hinali, nag-imaw kana ang duro pa gid karaku nga mga anghel nga naghalin sa langit. Nagadayaw sanda sa Dios, nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Padunggan ang Dios rugto sa kahitaasan! Kag rugya sa lupa ang kalinung maaguman kang mga tawo nga anang nahamut-an!” ");
INSERT INTO krj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pagkahalin kang mga anghel kananda nga nagbalik sa langit, ang mga manugbantay tana kang karnero nagkinun-anay, “Dali maagto kita sa Betlehem kag sulngun ang hitabo nga dya nga ginpamaan kanatun kang Ginoo!” ");
INSERT INTO krj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gani nagdali-dali sanda nga maghalin, kag nakita nanda si Maria kag si Jose kag ang lapsag nga nabutang sa pasungan. ");
INSERT INTO krj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kang makita nanda ang lapsag, ginsugid nanda ang ginkuon kananda kang anghel nahanungud sa lapsag. ");
INSERT INTO krj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ang tanan nga nakabati kang mga ginpanugid kang mga manugbantay kang karnero natingala gid. ");
INSERT INTO krj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero ang mga butang nga dya gintipigan ni Maria sa anang tagipusoon kag ana gid ginapaino-ino. ");
INSERT INTO krj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nagbalik sa andang mga panung ang mga manugbantay kang karnero nga nagapadungug kag nagadayaw sa Dios tungud sa tanan nga butang nga anda nabatian kag nakita nga suno gid sa ginsugid kananda kang anghel. ");
INSERT INTO krj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kang ikawalo run nga adlaw ginsirkom ang bata kag ginpangaranan nga Jesus. Amo dya ang ngaran nga ginkuon kang anghel nga ipangaran kana kang wara pa tana ginpanamkun. ");
INSERT INTO krj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kang mag-abot ang adlaw nga himoon run nanday Jose kag Maria ang turumanun nga nabutang sa Kasugoan ni Moises tuhoy sa seremonya kang pagpakatinlo, gindara nanda ang bata sa Jerusalem para nga ipaatubang sa Ginoo, ");
INSERT INTO krj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","hay amo dya ang nasulat sa Kasugoan kang Ginoo, “Ang kada panganay nga laki mangin ana kang Ginoo.” ");
INSERT INTO krj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nagtugro man sanda kang andang haralad nga sangka paris nga salampati ukon darwa ka palabugsayan nga pating, tungud hay amo ria ang ginakuon sa Kasugoan kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","May sangka tawo rugto kato nga nagauli sa Jerusalem nga ginahingaranan kay Simeon. Matarung dya nga tawo kag diosnon, kag nagahulat tana kang tion nga ang nasyon nga Israel hilwayun kang Dios. Ginagamhan tana kang Balaan nga Ispirito, ");
INSERT INTO krj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","kag ginpahayag kana kang Balaan nga Ispirito nga indi tana mapatay hasta nga makita na ang Mesias nga ginsaad kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gintuytoyan tana kang Balaan nga Ispirito nga mag-agto sa Templo. Kag kang gindara kang mga ginikanan ang bata nga si Jesus sa Templo para himoon kana ang ginakuon sa Kasugoan, ");
INSERT INTO krj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ginbuul ni Simeon ang bata kag kungkungun kag nagdayaw tana sa Dios, kag nagkuon: ");
INSERT INTO krj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kar-on, Ginoo, natuman mo run ang imo ginsaad. Ako nga imo surugoon papahuwayun mo run ka malinung. ");
INSERT INTO krj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tungud hay nakita ko run mismo ang Manluluwas ");
INSERT INTO krj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nga imo gintigana nga makita kang tanan nga katawhan. ");
INSERT INTO krj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tana kadya sulo nga magatugro kang kasanagan sa mga panghuna-huna kang mga bukun ti Judio, kag magadara kang kadungganan sa imo katawhan nga mga Israelenhun.” ");
INSERT INTO krj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Natingala gid ang tatay kag nanay kang bata tungud sa mga ginpanghambal nga dya ni Simeon nahanungud sa bata. ");
INSERT INTO krj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ginbindisyonan sanda ni Simeon kag nagkuon tana kay Maria nga nanay kang bata, “Ang bata nga dya gintangdu kang Dios agud paagi kana raku nga mga Israelenhun ang magaparayu sa Dios, pero raku man ang magaparapit sa Dios. Paratandaan tana halin sa Dios nga pagapakalainun kang mga katawhan, ");
INSERT INTO krj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","agud maman-an ang ginalikman kang mga tawo sa andang mga panghuna-huna. Kag ikaw, Maria, tungud sa bata nga dya, magakalisud ikaw nga daw ginapilas kang matarum nga espada ang imo tagipusoon.” ");
INSERT INTO krj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kar-on may sangka bayi nga propeta rugto nga ang anang ngaran si Ana. Bata tana ni Fanuel nga naghalin sa tribo ni Aser. Si Ana nga dya mal-am run gid katama. Pito lang ka tuig ang pag-imaway nanda ka anang bana ");
INSERT INTO krj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kag nabalo tana. Kar-on, nagapang-edadun run tana kang kawaloan kag apat ka tuig. Wara gid tana paghalin-halin sa Templo, ang obra na lang amo nga adlaw kag gabii nagasimba tana sa Dios, nagapuasa kag nagapangamuyo. ");
INSERT INTO krj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kag sa amo man to nga oras nagparapit tana kanday Maria kag nagpasalamat sa Dios kag naghambal tana nahanungud sa bata sa tanan nga nagahulat kang tion nga hilwayun kang Dios ang Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kang matuman run nanday Jose kag Maria ang tanan nga ginapahimo kang Kasugoan kang Ginoo, nagbalik sanda sa Galilea, rugto sa Nazaret nga amo ang banwa nga anda natawhan. ");
INSERT INTO krj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nagbahul ang bata kag nangin mapagrus, tama gid ka maaram kag ginabugayan gid tana kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada tuig ang ginikanan ni Jesus nagaagto sa Jerusalem para sa Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kang nagapang-edadun run si Jesus kang napulo'g darwa, nag-agto sanda rugto hay amo dya ang andang kinabatasan. ");
INSERT INTO krj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatapos kang Pista, nag-uli sanda, pero ang bata tana nga si Jesus nagpabilin sa Jerusalem. Wara dya maman-i kang anang mga ginikanan. ");
INSERT INTO krj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Abi nanda kon nagaimaw man tana sa andang mga kaibahan, gani nagpadayon lang sanda ka panaw sa bilog nga adlaw. Kang matalupangdan nanda wara tana gali nagaimaw sa andang mga kaibahan, dayon nanda sagap kana sa andang mga himata kag mga kakilala. ");
INSERT INTO krj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kag kang wara nanda tana makita nagbalik sanda sa Jerusalem nga sige man angud ang anda nga sagap kana. ");
INSERT INTO krj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatlo run nga adlaw kag makita nanda tana sa Templo nga nagapungko imaw sa mga manunudlo kang Kasugoan nga nagapamati kananda kag nagapamangkot man. ");
INSERT INTO krj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ang tanan nga nakabati kana daw indi makapati sa ana nga kaaramun sa pagsabat. ");
INSERT INTO krj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kang makita tana kang anang ginikanan, natingala gid sanda, kag ang anang nanay nagkuon kana, “Anak, andut haw nga ginhimo mo dya kanamun? Nagakabalaka kag naayawan gid kami ni Tatay mo ka sagap kanimo!” ");
INSERT INTO krj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nagsabat si Jesus kananda, “Andut haw nga ginsagap ninyo ako? Wara bala kamo kamaan nga kinahanglan rugya ako sa balay kang akun Amay?” ");
INSERT INTO krj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ugaring wara nanda mahangpi ang gusto hambalun kang ginkuon ni Jesus. ");
INSERT INTO krj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nag-imaw si Jesus kananda nga nag-uli sa Nazaret, kag matinumanun tana kananda. Ang tanan nga mga butang nga dya gintipigan ni Maria sa anang tagipusoon. ");
INSERT INTO krj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kag naghanggud pa gid si Jesus sa lawas kag sa kinaaram. Padayon tana nga ginakahamut-an kang Dios kag kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sa ikanapulo kag lima ka tuig nga pagdumara ni Tiberius bilang emperador, si Ponsio Pilato amo ang gobernador kang Judea, si Herodes tana amo ang nagadumara kang Galilea, kag ang anang bugto nga si Felipe amo ang nagadumara sa mga nasakpan kang Iturea kag Traconite, kag si Lisanias amo ang nagadumara kang Abilinia. ");
INSERT INTO krj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ang pinakamataas tana nga mga pari amo sanday Anas kag Caifas. Sa amo man dya nga tion, rugto sa naligwin nga lugar, si Juan nga bata ni Zacarias nakabaton kang mensahe halin sa Dios. ");
INSERT INTO krj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gani naglibot si Juan sa tanan nga lugar nga nasakpan kang Suba kang Jordan. Nagapangwali tana nga nagakuon, “Maghirinulsul kamo kag magbiriya sa inyo mga sala kag magpabawtiso agud patawarun kamo sa inyo mga sala!” ");
INSERT INTO krj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Amo dya ang katumanan kang ginsulat anay ni Propeta Isaias nga, “May sangka tawo nga nagahambal sa matunog nga limug rugto sa kamingawan. ‘Iaman ninyo ang dalan kang Ginoo; tadlunga ninyo ang anang mga pagaagyan. ");
INSERT INTO krj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tampukan ang kada lugar nga manaba, kag tapanun ang kada bakulod kag kabukidan, tadlungun ang mga tiko-tiko nga dalan, kag panamiun ang mga batsihun nga aragyan. ");
INSERT INTO krj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kag makita kang tanan nga mga katawhan ang pagluwas nga pagahimoon kang Dios.’” ");
INSERT INTO krj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ginkun-an ni Juan ang tama ka duro nga mga tawo nga nag-aragto kana sa pagpabawtiso, “Mga sawa kamo! Sin-o ang nagpamaan kaninyo nga makapalagyo kamo sa silot kang Dios nga magaabot? ");
INSERT INTO krj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kon matuod nga naghinulsul kamo sa inyo mga sala, maghimo kamo kang mga butang nga makapamatuod nga naghinulsul kamo, kag indi kamo magkuon sa inyo kaugalingun nga mga linahi kamo ni Abraham. Tungud hay sugidan ko kamo, sarang himoon kang Dios ang mga bato nga dya nga mangin linahi ni Abraham. ");
INSERT INTO krj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bisan gani kadya ang wasay nahanda run nga itapas sa kahoy; ang kada kahoy nga wara nagapamunga kang mayad pagatapsun kag itablug sa kalayo.” ");
INSERT INTO krj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nagpamangkot ang mga tawo kana, “Ti, ano bay ang amun himoon?” ");
INSERT INTO krj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nagsabat tana, “Kon sin-o kaninyo ang may darwa ka panid nga bayo, kinahanglan itugro na ang isara sa tawo nga wara ti ginasuksok, kag kon sin-o man ang may pagkaun, paambitun na man ang iba.” ");
INSERT INTO krj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","May mga manugsukot man kang buwis nga nag-agto kay Juan para magpabawtiso. Nagpamangkot sanda kana, “Maestro, ano ang amun himoon?” ");
INSERT INTO krj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nagsabat si Juan kananda, “Indi kamo magsukot kang sobra sa inyo surokton.” ");
INSERT INTO krj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","May mga suldado man nga nagpamangkot kana, “Ti, kami tamun bay, ano tana ang amun himoon?” Nagsabat si Juan kananda, “Indi kamo magbuul kang kwarta kang iba paagi sa pirit ukon magbutang-butang kang sala sa bisan kay sin-o. Magkuntinto lang kamo sa ginasweldo kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ang mga tawo nakabatyag kang makaharawat-hawat nga paglaum. Ginhaum-haum nanda nga si Juan amo run ang Cristo nga anda ginapaabot. ");
INSERT INTO krj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ginkun-an sanda tanan ni Juan, “Ginabawtisohan ko kamo sa tubig, pero may magaabot nga labaw pa gid kanakun, nga bisan pa gani ang paghubad kang higot kang anang sandalyas bukun ako ti takus. Pagabawtisohan na kamo kang Balaan nga Ispirito kag kalayo. ");
INSERT INTO krj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pagabulagun na ang mga tawo nga mayad sa mga malain, pareho kang nagatahup tana kang lamigas nga ginapain na ang timgas sa upa. Ang timgas pagatipunon na sa kamarin, kag ang upa tana itablug na sa kalayo nga wara ti katapusan ang ana nga pagdaba-daba.” ");
INSERT INTO krj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sa nagkalain-lain nga paagi gintudloan ni Juan ang mga tawo kag ginwali na man kananda ang Mayad nga Balita. ");
INSERT INTO krj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pero ginsabdung ni Juan si Herodes nga gobernador tungud kang anang relasyon kay Herodias nga ana bayaw, kag tungud man sa iba pa nga mga malain nga ana ginahimo. ");
INSERT INTO krj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kag naghimo pa gid si Herodes ka mas malain nga butang nga amo ang pagpapriso kay Juan. ");
INSERT INTO krj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pagkatapos nga mabawtisohan ang tanan nga mga tawo, si Jesus ginbawtisohan man. Samtang nagapangamuyo tana, nagbukas ang langit, ");
INSERT INTO krj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kag nagkunsad kag nagtungtong kana ang Balaan nga Ispirito sa dagway kang pating. Kag may limug nga naghalin sa langit nga nagakuon, “Ikaw ang akun hinigugma nga Anak; nahamuut gid ako kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nagapang-edadun si Jesus kang mga katloan ka tuig kag mag-umpisa tana kang anang buruhatun. Ang pagkamaan kang mga tawo bata tana ni Jose nga bata ni Eli. ");
INSERT INTO krj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli bata ni Matat, si Matat bata ni Levi, si Levi bata ni Melqui, si Melqui bata ni Janai, si Janai bata ni Jose, ");
INSERT INTO krj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","si Jose bata ni Matatias, si Matatias bata ni Amos, si Amos bata ni Nahum, si Nahum bata ni Esli, si Esli bata ni Nagai, ");
INSERT INTO krj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","si Nagai bata ni Maat, si Maat bata ni Matatias, si Matatias bata ni Semei, si Semei bata ni Jose, si Jose bata ni Joda, ");
INSERT INTO krj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","si Joda bata ni Joanan, si Joanan bata ni Resa, si Resa bata ni Zorobabel, si Zorobabel bata ni Salatiel, si Salatiel bata ni Neri, ");
INSERT INTO krj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","si Neri bata ni Melqui, si Melqui bata ni Adi, si Adi bata ni Cosam, si Cosam bata ni Elmadam, si Elmadam bata ni Er, ");
INSERT INTO krj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","si Er bata ni Josue, si Josue bata ni Eliezer, si Eliezer bata ni Jorim, si Jorim bata ni Matat, si Matat bata ni Levi, ");
INSERT INTO krj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Levi bata ni Simeon, Simeon bata ni Juda, si Juda bata ni Jose, si Jose bata ni Jonam, si Jonam bata ni Eliaquim, ");
INSERT INTO krj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","si Eliaquim bata ni Melea, si Melea bata ni Mena, si Mena bata ni Matata, si Matata bata ni Natan, si Natan bata ni David, ");
INSERT INTO krj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","si David bata ni Jesse, si Jesse bata ni Obed, si Obed bata ni Boaz, si Boaz bata ni Salmon, si Salmon bata ni Naason, ");
INSERT INTO krj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","si Naason bata ni Aminadab, si Aminadab bata ni Admin, si Admin bata ni Arni, si Arni bata ni Ezron, si Ezron bata ni Fares, si Fares bata ni Juda, ");
INSERT INTO krj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","si Juda bata ni Jacob, si Jacob bata ni Isaac, si Isaac bata ni Abraham, si Abraham bata ni Tera, si Tera bata ni Nahor, ");
INSERT INTO krj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","si Nahor bata ni Serug, si Serug bata ni Reu, si Reu bata ni Peleg, si Peleg bata ni Eber, si Eber bata ni Sela, ");
INSERT INTO krj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","si Sela bata ni Cainan, si Cainan bata ni Arfaxad, si Arfaxad bata ni Sem, si Sem bata ni Noe, si Noe bata ni Lamec, ");
INSERT INTO krj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamec bata ni Metusela, si Metusela bata ni Enoc, si Enoc bata ni Jared, si Jared bata ni Mahalaleel, si Mahalaleel bata ni Cainan, ");
INSERT INTO krj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","si Cainan bata ni Enos, si Enos bata ni Set, si Set bata ni Adam, kag si Adam bata kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Naghalin si Jesus sa Jordan nga nagamhan kang Balaan nga Ispirito, kag gindara tana kang Ispirito sa kamingawan ");
INSERT INTO krj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","nga sa diin ginsulay tana kang Yawa sa sulud kang kap-atan ka adlaw. Wara gid tana magkaun sa sulud kang amo to nga mga tinion, gani pagkatapos kato, gin-gutum tana. ");
INSERT INTO krj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dayon nagkuon kana ang Yawa, “Kon ikaw ang Anak kang Dios, abi mandoi dyang bato agud mangin tinapay.” ");
INSERT INTO krj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nagsabat si Jesus, “Nasulat sa kasulatan, ‘Ang tawo indi lamang sa pagkaun mabuhi.’” ");
INSERT INTO krj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dayon gindara tana kang Yawa sa mataas nga lugar kag sa sangka pisuk ginpakita kang Yawa kana ang tanan nga mga ginharian sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kag nagkuon ang Yawa kana, “Itugro ko kanimo ang tanan nga gahum sa pagdumara kananda kag ang manggad nanda kadya, tungud hay ang tanan nga dya natugyan run kanakun kag sarang ko matao sa bisan kay sin-o nga akun gusto itaw-an. ");
INSERT INTO krj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gani, ang tanan nga dya mangin imo kon magsimba ikaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero nagsabat si Jesus, “Nasulat sa Kasulatan, ‘Simbahun mo ang Ginoo nga imo Dios kag tana gid lang ang imo alagadun.’” ");
INSERT INTO krj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dayon gindara pa gid si Jesus kang Yawa sa Jerusalem kag ginpatindug sa pinakamataas nga bahin kang Templo. Nagkuon ang Yawa kana, “Kon ikaw ang Anak kang Dios, abi paglumpat halin rugya ka dya. ");
INSERT INTO krj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tungud hay nasulat sa Kasulatan nga, ‘Sugoon kang Dios ang anang mga anghel nga bantayan ikaw.’ ");
INSERT INTO krj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kag, ‘Pagasapnayun nanda ikaw sa andang mga alima agud indi makasagaid ang imo mga kahig sa mga bato.’” ");
INSERT INTO krj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero nagsabat si Jesus kana, “Nasulat sa Kasulatan, ‘Indi mo pagsulayun ang Ginoo nga imo Dios.’” ");
INSERT INTO krj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kang matapos sulayun kang Yawa si Jesus, ana anay dya nga ginbayaan. ");
INSERT INTO krj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagkatapos kato, nagbalik si Jesus sa Galilea nga nagamhan kang Balaan nga Ispirito. Kag ang balita nahanungud kana naglapnag sa bilog nga lugar. ");
INSERT INTO krj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nagpanudlo tana sa mga Sinagoga, kag gindayaw tana kang tanan. ");
INSERT INTO krj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dayon nag-agto si Jesus sa Nazaret nga sa diin rugto tana nagbahul. Pareho kang ana naandan, nag-agto tana sa Sinagoga sa Adlaw nga Inugpahuway. Nagtindug tana sa pagbasa kang Kasulatan, ");
INSERT INTO krj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kag gindawu kana ang libro ni Propeta Isaias. Ginbilad na dya kag nakita na ang bahin nga sa diin amo dya ang nasulat: ");
INSERT INTO krj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ang Ispirito kang Ginoo rugya kanakun, tungud nga ako ang anang ginpili nga magwali kang mga mayad nga balita sa mga imol. Ginsugo na ako nga ibantala sa mga bihag ang anda nga kahilwayan, kag sa mga bulag nga sanda makakita run. Ginsugo man ako nga luwasun ang mga tawo nga ginapigus. ");
INSERT INTO krj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kag ginsugo man ako nga ibantala nga amo run dya ang tion nga pagaluwasun kang Ginoo ang ana katawhan.” ");
INSERT INTO krj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatapos nga mabasa ni Jesus ang kasulatan, ginbaruron na dya kag gin-uli sa manugbulig, kag nagpungko tana. Ang tanan nga mga tawo sa sinagoga nagtururuk kana, ");
INSERT INTO krj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","kag nagkuon tana kananda, “Dya nga bahin kang Kasulatan nga inyo nabatian natuman gid kadya nga adlaw.” ");
INSERT INTO krj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nanamian gid sanda kana kag natingala sanda sa mga manami nga ana ginapanghambal. Nagkuon sanda, “Indi bala nga bata ria ni Jose?” ");
INSERT INTO krj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naghambal si Jesus kananda, “Naman-an ko nga sambitun gid ninyo kanakun ang hurubatun nga nagakuon, ‘Doktor, abi, bulnga anay ang imong kaugalingun.’ Kag ayhan makuon man kamo kanakun nga, ‘Abi himoa man rugya sa imo kaugalingun nga banwa ang amun nabatian nga imo mga ginpanghimo rugto sa Capernaum.’” ");
INSERT INTO krj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nagkuon pa gid si Jesus, “Sugidan ko kamo, ang propeta wara ginabaton sa ana mismo kaugalingun nga banwa. ");
INSERT INTO krj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pamati kamo, matuod ria nga kang tion pa anay ni Propeta Elias tatlo kag tunga ka tuig nga wara gid mag-uran. Tuman gid nga kagutum ang nag-abot sa bilog nga lugar, kag raku nga mga bayi nga balo sa Israel ang nagakinahanglan kang bulig, ");
INSERT INTO krj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero wara ginsugo kang Dios si Elias nga magbulig sa bisan kay sin-o kananda, kundi nga ginsugo tana sa sangka balo nga bayi nga nagauli sa Zarepta nga sakup kang tiritoryo kang Sidon. ");
INSERT INTO krj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Amo man ria ang natabo sa tion anay ni Propeta Eliseo. Raku ang mga aruon kato sa Israel, pero wara gid ti bisan isara kananda nga gin-ayad magluwas lang kay Naaman nga taga-Siria.” ");
INSERT INTO krj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kar-on, nag-ugut gid ang mga tawo sa Sinagoga pagkabati nanda kadya. ");
INSERT INTO krj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nagtirindug sanda kag ginpagwa si Jesus sa banwa. Gindara nanda tana sa ibabaw kang bakulod nga sa diin nahamtang ang andang banwa, agud nga itiklod nanda tana sa pil-as. ");
INSERT INTO krj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero nag-agi lang si Jesus sa tunga nanda kag magpanaw. ");
INSERT INTO krj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nag-agto si Jesus sa banwa kang Capernaum nga sakup kang Galilea, kag rugto nagpanudlo tana sa mga tawo sa Adlaw nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Natingala sanda tanan sa anang mga pagpanudlo tungud hay may awtoridad tana kon maghambal. ");
INSERT INTO krj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Rugto sa sinagoga may tawo nga ginsudlan kang demonyo. Nagasinggitan tana nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus nga taga-Nazaret, ano ang labut mo kanamun? Nag-agto bala ikaw rugya sa pagpapas kanamun? Kilala ko ikaw, ikaw ang Balaan nga ginpadara kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ginsabdung ni Jesus ang demonyo, “Paghipus dyan, kag magwa sa tawo nga ria!” Dayon ginlampus kang demonyo ang tawo sa atubang kang mga katawhan kag nagwa tana nga wara man maiwan ang tawo. ");
INSERT INTO krj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Natingala gid ang mga tawo kag nagkinun-anay sanda, “Ano tana nga mga tinaga dya man? May awtoridad kag gahum tana sa pagmando sa mga demonyo nga magwa kag nagatuman sanda kana!” ");
INSERT INTO krj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kag ang balita nahanungud kay Jesus naglapnag sa bisan diin nga lugar sa palibot. ");
INSERT INTO krj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagkatapos kato, naghalin si Jesus sa sinagoga kag nag-agto sa balay ni Simon. Nataboan nga ang ugangan nga bayi ni Simon nagamasakit kag taas ang anang hilanat. Gani ginpangabay nanda si Jesus nga aydun tana. ");
INSERT INTO krj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nagparapit kag nagtindug si Jesus sa kilid kag ginmandoan ang hilanat nga maghalin. Nadura ang hilanat kang bayi kag lagi-lagi nagbangon tana kag ginsirbihan na sanda. ");
INSERT INTO krj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagkasirum, ang tanan nga mga may amigo nga nagamasakit kang mga nagkalain-lain nga mga balatian gindara nanda kay Jesus. Gintandug ni Jesus kang anang alima ang kada isara kananda kag gin-ayad sanda tanan. ");
INSERT INTO krj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Naggurowa man ang mga demonyo sa duro nga mga tawo nga nagasinggitan, “Ikaw ang Anak kang Dios!” Ginpangsabdung sanda ni Jesus kag wara na gintugotan nga maghambal, tungud hay naman-an nanda nga tana amo ang Cristo. ");
INSERT INTO krj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagkaaga, nagwa si Jesus sa banwa kag nag-agto sa sangka mamingaw nga lugar. Ginsagap tana kang mga tawo kag kang makita nanda tana, ginpangabay nanda tana nga indi anay magpanaw. ");
INSERT INTO krj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero nagsabat tana kananda, “Kinahanglan iwali ko man sa iba nga banwa ang Mayad nga Balita nahanungud sa paghari kang Dios tungud nga amo ria ang tinutuyo kang Dios kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gani nagpangwali si Jesus sa mga sinagoga sa bilog nga Judea. ");
INSERT INTO krj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sangka adlaw nagaturutindug si Jesus sa binit kang linaw kang Genesaret. Ang mga tawo tana nagadinus-uganay sa pagparapit kana agud magpamati kang pulong kang Dios nga ana ginawali. ");
INSERT INTO krj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","May nakita tana nga darwa ka mga baruto sa binit kang linaw nga ang mga mangingisda na kadya nakapanaog run kag nagahugas kang andang mga pukot. ");
INSERT INTO krj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nagsakay si Jesus sa isara sa dya nga mga baruto nga ana ni Simon, kag ginpangabay na si Simon nga itulod na dya parayu-rayu gawa sa binit ka baybay. Dayon nagpungko tana sa baruto kag nagpanudlo sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapos na ka hambal sa mga tawo, nagkuon tana kay Simon, “Abi, ipalawud mo pa gid ang baruto kag iladlad ninyo ang inyo mga pukot agud makabuul kamo kang isda.” ");
INSERT INTO krj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nagsabat si Simon, “Ay abaw, Agalun, bilog nga gabii gid kami nga nagpamukot pero wara gid kami ti nabuul. Pero hay amo ria ang kuon nimo, ti sige eh, iladlad ko ang mga pukot.” ");
INSERT INTO krj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kag ginladlad nanda ang mga pukot kag duro gid karaku nga isda ang anda nga nabuul nga daw sa masi-si run gid ang andang mga pukot. ");
INSERT INTO krj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gani nagsinyas sanda sa anda mga kaibahan sa pihak nga baruto nga mag-agto kag buligan sanda. Nag-agto sanda kag ginbuta nanda ka isda ang darwa ka baruto hasta nga daw sa malunod run dya. ");
INSERT INTO krj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kang makita ni Simon Pedro ang natabo nga dya, nagluhod tana sa atubang ni Jesus kag nagkuon, “Ginoo, parayu kanakun tungud hay makasasala ako nga tawo!” ");
INSERT INTO krj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Daw indi makapati si Simon kag ang tanan na nga mga kaibahan sa karakuun kang isda nga anda nabuul, ");
INSERT INTO krj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","kag amo man ang mga anang imaw nga sanday Santiago kag Juan nga mga kabataan ni Zebedeo. Pagkatapos karia, nagkuon si Jesus kay Simon, “Indi ikaw magkahadluk. Umpisa kadya magapangdara run ikaw kang mga tawo nga magsunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ginpatakas nanda ang mga baruto sa baybayun kag ginbayaan nanda ang tanan kag nagsunod sanda kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sangka bes, kang rugto si Jesus sa sangka banwa, may tawo nga naputos gid ang anang lawas ka aru. Kang makita na si Jesus, naghapa tana sa atubang ni Jesus kag nagpakitluoy, “Ginoo, kon gustohon mo, sarang mo ako mapaayad kag himoon nga limpyo suno sa kasugoan.” ");
INSERT INTO krj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dayon gindawhat kag gintandug ni Jesus ang masakitun kag nagkuon, “Huud, gusto ko. Sige, maayad run ikaw!” Kag lagi-lagi nag-ayad ang tawo nga aruon. ");
INSERT INTO krj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ginbilinan tana ni Jesus, “Indi mo dya pag-ipanugid-sugid bisan kay sin-o, kundi ang himoon mo, agto ikaw sa pari kag magpasulung kana. Dayon maghalad ikaw kang haralad suno sa ginasugo ni Moises bilang pamatuod sa tanan nga naayad run ikaw.” ");
INSERT INTO krj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ang balita nahanungud kay Jesus mas pa gid nga naglapnag, gani pinanung nga mga tawo ang nag-arabot sa pagpamati kana, kag agud magpaayad sa andang mga balatian. ");
INSERT INTO krj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero si Jesus nagaagto sa mga naligwin nga lugar sa pagpangamuyo. ");
INSERT INTO krj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sangka adlaw nga nagapanudlo si Jesus, may mga Fariseo kag mga manunudlo kang Kasugoan nga nagapurungko rugto nga nagharalin pa sa mga kabanwahanan kang Galilea kag Judea kag sa Jerusalem. Ang gahum kang Ginoo sa pagpang-ayad kang mga masakitun rugyan kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Burubuhay may nag-arabot nga mga tawo nga nagayayong kang sangka paralitiko sa anang baratangan. Ginatinguhaan raad nanda nga pasudlun dya sa balay kag dar-un sa atubang ni Jesus. ");
INSERT INTO krj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ugaring sa kadurohon kang mga tawo wara gid sanda ti maagyan pasulud. Ang ginhimo nanda, ginyayongan nanda ang paralitiko pasaka sa atup. Dayon gin-ukaban nanda ang atup nga tisa kag gintunton nanda ang masakitun sa ana baratangan sa tunga kang mga tawo sa atubang mismo ni Jesus. ");
INSERT INTO krj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kang makita ni Jesus ang andang pagtoo, ginkun-an na ang tawo nga masakitun, “Amigo, ang imong mga sala ginpatawad run!” ");
INSERT INTO krj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ang mga manunudlo kang Kasugoan kag ang mga Fariseo nag-umpisa ka muno sa andang kaugalingun nga nagakuon, “Sin-o bala ang tawo nga dya nga nagapasipala sa Dios? Dios lang kabay kag wara run ti bisan sin-o pa ang makapatawad kang sala?” ");
INSERT INTO krj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nasat-uman ni Jesus kon ano ang anda nga ginapinsar, gani nagkuon tana kananda, “Andut haw nga nagapaminsar kamo kang amo ria? ");
INSERT INTO krj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sa diin bala ang mas mahapus? Ang magkuon ako nga, ‘Ginpatawad run ang imo mga sala,’ ukon magkuon ako nga, ‘Bangon dyan kag magpanaw?’ ");
INSERT INTO krj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kar-on pamatud-an ko kaninyo nga ang Anak kang Tawo may gahum rugya sa lupa sa pagpatawad kang sala.” Dayon ginkun-an na ang paralitiko, “Ginakun-an ko ikaw, bangon dyan, dar-a ang imong baratangan kag mag-uli sa inyo balay!” ");
INSERT INTO krj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lagi-lagi nagbangon ang tawo nga nakita gid kang tanan. Gindara na ang anang baratangan kag nag-uli nga nagadayaw sa Dios. ");
INSERT INTO krj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Natingala gid sanda tanan, kag gindayaw nanda ang Dios, nga nagabatyag kang kahadluk nga nagakuon, “Daw ano nga katingalahan nga butang ang atun nakita sa kadya nga adlaw!” ");
INSERT INTO krj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos ka dya, nagwa si Jesus kag nakita na ang sangka manugsukot kang buwis nga ang anang ngaran ka dya si Levi, nga nagapungko sa lugar kang ginabaydan kang buwis. Ginkun-an tana ni Jesus, “Sunod ikaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nagtindug si Levi kag ginbayaan na ang tanan kag nagsunod kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nagpatabad si Levi sa anang balay para kay Jesus, kag raku nga mga manugsukot kang buwis kag iba pa gid nga mga tawo ang nag-imaw kananda sa pagkaun sa lamesa. ");
INSERT INTO krj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kar-on, ang mga Fariseo kag ang mga manunudlo kang Kasugoan nga mga kaimaw man nanda, nagkurumodon sa mga disipulo ni Jesus, “Andut haw nga nagapakig-imaw kamo kaun kag inum sa mga manugsukot kang buwis kag sa iba pa nga mga tawo nga makasasala?” ");
INSERT INTO krj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ginsabat sanda ni Jesus, “Ang tawo nga mayad ti lawas wara nagakinahanglan kang doktor kundi ang tawo lamang nga nagamasakit. ");
INSERT INTO krj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wara ako mag-abot agud itawgun ang mga matarung nga tawo, kundi ang mga makasasala nga maghirinulsul sanda.” ");
INSERT INTO krj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","May mga tawo nga nagkuon kay Jesus, “Ang mga disipulo ni Juan nga Manugbawtiso masami nagapuasa kag nagapangamuyo, kag amo man ang ana kang mga Fariseo. Pero ang imo tana nagakaun kag nagainum.” ");
INSERT INTO krj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nagsabat si Jesus kananda, “Mahimo mo ayhan nga indi pagpakan-un ang mga bisita sa kasal samtang kaimaw pa nanda ang nobyo? Indi gid. ");
INSERT INTO krj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero magaabot ang adlaw nga ibul-un kananda ang nobyo, kag sa amo nga tion indi mahimo nga indi sanda magpuasa.” ");
INSERT INTO krj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nagsugid si Jesus kananda kang paanggid. Kuon na, “Wara ti nagagisi halin sa ana bag-o nga bayo agud nga ilunub sa daan nga bayo. Tungud hay kon himoon na dya, gin-gisi na run ang bag-o nga bayo kag labut pa, ang ginlunub nga to nga naghalin sa bag-o nga bayo indi man mag-angay sa daan nga bayo. ");
INSERT INTO krj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kag wara man ti nagabutang kang bag-o nga bino sa daan nga surudlan nga panit. Tungud hay kon himoon na dya mabusdik ang surudlan kag mauyang ang bino, kag ang surudlan indi run mapuslan. ");
INSERT INTO krj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sa baylo, ang bag-o nga bino kinahanglan isulud sa bag-o man nga surudlan nga panit. ");
INSERT INTO krj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kag wara man ti nagainum kang daan nga bino ang mangita kang bag-o nga bino, tungud hay kuon na, ‘Mas manamit tana ang daan nga bino.’” ");
INSERT INTO krj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sangka Adlaw nga Inugpahuway, samtang si Jesus kag ang anang mga disipulo nagaagi sa taramnan kang trigo, ang anang mga disipulo nagpangutul kang bunga na ka dya kag ginpiripis sa andang mga alima kag magkinaun. ");
INSERT INTO krj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pero ang iba tana sa mga Fariseo nagkuon, “Andut haw nga ginahimo ninyo ang ginadumilian kang atun Kasugoan nga himoon sa Adlaw nga Inugpahuway?” ");
INSERT INTO krj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ginsabat sanda ni Jesus, “Wara bala ninyo mabasahi ang ginhimo anay ni David kang tana kag ang anang mga kaibahan gin-gutum? ");
INSERT INTO krj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nagsulud tana sa balay kang Dios. Dayon ginbuul na kag ginkaun ang tinapay nga ginhalad sa Dios kag ginpanugroan na man ang anang mga kaibahan, wara ti sapayan nga ang Kasugoan nagadumili sa pagkaun ka dya, magluwas lamang sa mga pari.” ");
INSERT INTO krj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nagkuon si Jesus kananda, “Ang Anak kang Tawo amo ang may gahum sa Adlaw nga Inugpahuway.” ");
INSERT INTO krj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sangka Adlaw ruman nga Inugpahuway, nag-agto si Jesus sa sinagoga kag nagpanudlo. May sangka tawo rugto nga kimay ang tuo na nga alima. ");
INSERT INTO krj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kar-on, may mga manunudlo kang Kasugoan kag mga Fariseo nga nagabantay ka maid-id kon bala mang-ayad si Jesus sa Adlaw nga Inugpahuway agud to nga may rason sanda sa pag-akusar kana. ");
INSERT INTO krj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero naman-an ni Jesus ang andang ginapinsar. Gani nagkuon tana sa tawo nga kimay, “Tindug ikaw dyan kag mag-agto rugya sa unahan.” Nagtindug ang tawo kag nag-agto sa unahan. ");
INSERT INTO krj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dayon nagkuon si Jesus kananda, “May ipamangkot ako kaninyo: ano ang ginatugot kang atun Kasugoan nga himoon sa Adlaw nga Inugpahuway? Ang magbulig bala ukon ang maghalit? Ang magluwas bala kang kabuhi ukon magpatay?” ");
INSERT INTO krj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dayon ginturuk na sanda tanan sa anang palibot kag nagkuon tana sa tawo nga kimay, “Untaya ang imong alima.” Gin-untay man kang tawo ang anang alima kag nag-ayad dya. ");
INSERT INTO krj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tungud kadya naugut gid sanda ka mayad kag nagsapol kon ano ang andang himoon kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa amo to nga tinion nagtukad si Jesus sa bakulod agud magpangamuyo, kag bilog gid nga gabii ang ana nga pagpangamuyo sa Dios. ");
INSERT INTO krj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkaaga, ginpanawag na ang anang mga disipulo kag halin kananda nagpili tana kang napulo'g darwa kag gintawag na sanda nga mga apostoles. ");
INSERT INTO krj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sanda kadya amo sanday Simon (nga ana man ginhingaranan Pedro) kag ang bugto ni Pedro nga si Andres; si Santiago kag si Juan, si Felipe kag si Bartolome, ");
INSERT INTO krj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo kag si Tomas, si Santiago nga bata ni Alfeo kag si Simon (nga mapinalanggaun sa anang nasyon), ");
INSERT INTO krj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas nga bata ni Santiago, kag si Judas Iscariote nga amo ang nangin traidor. ");
INSERT INTO krj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nagdulhog si Jesus imaw kang ana nga mga apostoles, kag nagtindug tana sa may patag. Tama ka duro ang anang mga disipulo rugto kag duro man ang tawo nga nagharalin pa sa bilog nga Judea, kag sa Jerusalem, kag sa syudad kang Tiro kag Sidon nga nahamtang marapit sa baybay. Nag-agto sanda rugto para nga magpamati kay Jesus kag para ayadun sa andang mga masakit. ");
INSERT INTO krj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gin-ayad na man ang mga tawo nga ginatublag kang mga malaot nga ispirito. ");
INSERT INTO krj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ang tanan nga tawo rugto nagatinguha nga makatandug kay Jesus tungud nga may gahum nga nagagwa kana kag nagapaayad kananda tanan. ");
INSERT INTO krj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dayon ginturuk ni Jesus ang ana nga mga disipulo kag nagkuon tana kananda, “Bulahan kamo nga mga imol, tungud hay kamo ang pagagamhan kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bulahan kamo nga ginagutum sa tulad, tungud nga pagabusgon kamo. Bulahan kamo nga nagaparanangisun sa tulad, tungud nga magakadlaw kamo sa kalipay. ");
INSERT INTO krj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Bulahan kamo kon kaugtan kamo kang mga tawo kag sikwayun, kag yagutaun, kag pakalainun tungud kang inyo pagsunod sa Anak kang Tawo. ");
INSERT INTO krj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa tion nga himoon nanda dya kaninyo, magkalipay kamo kag magsinadya, tungud hay bahul ang padya nga ginaaman kaninyo rugto sa langit. Amo man gani karia ang ginhimo kang anda mga kaulangan sa mga propeta katong una. ");
INSERT INTO krj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero makaluluoy kamo nga mga manggaranun sa tulad, tungud nga naaguman run ninyo ang mahulas nga pagpangabuhi. ");
INSERT INTO krj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Makaluluoy kamo nga mga busog sa tulad, tungud nga pagagutumun kamo. Makaluluoy kamo nga nagakinadlaw sa tulad, tungud nga magakasubu kamo kag magaparanangisun. ");
INSERT INTO krj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Makaluluoy lang kamo, kon dayawun kamo kang tanan nga mga tawo tungud nga amo man ria ang ginhimo kang mga kaulangan nanda sa mga nagpakuno-kuno nga mga propeta.” ");
INSERT INTO krj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nagkuon pa gid si Jesus, “Kamo nga nagaparamati kanakun, amo dyaay ang akun ikuon kaninyo: palanggaa ninyo ang inyo mga kaaway kag maghimo kamo kang mayad sa mga tawo nga nagadumut kaninyo. ");
INSERT INTO krj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pangayoa ninyo sa Dios nga kaluy-an ang mga tawo nga nagapasipala kaninyo, kag ipangamuyoi ninyo ang mga tawo nga nagapigus kaninyo. ");
INSERT INTO krj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kon tampaun ikaw sa sampihak nimo nga bagiing, itaya mo man ang sampihak. Kon ang imo kunup bul-un kanimo, itugro mo man pati ang imong bayo. ");
INSERT INTO krj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tugroi ang bisan sin-o nga nagapangayo kanimo, kag indi run pagbawia ang bisan ano nga imo pagkabutang nga ginbuul kanimo. ");
INSERT INTO krj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Himoa ninyo sa inyo isigka-tawo ang gusto ninyo nga himoon man nanda kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kon ang inyo ginapalangga amo lamang ang mga tawo nga nagapalangga man kaninyo, ano pa nga balus ang paabuton ninyo? Tungud hay bisan gani ang mga tawo nga makasasala nagapalangga man sa mga nagapalangga kananda! ");
INSERT INTO krj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kag kon nagahimo kamo kang mayad sa mga tawo nga nagahimo man kang mayad kaninyo, ano pa nga balus ang paabuton ninyo? Tungud hay bisan gani ang mga tawo nga makasasala nagahimo man kadya! ");
INSERT INTO krj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kag kon nagapahuram lang kamo sa mga tawo nga makasarang man magbayad, ano pa nga balus ang paabuton ninyo? Bisan gani ang mga makasasala nagapahuram man sa pareho nanda nga makasasala nga nagapaabot nga baydan kang amo man nga bili. ");
INSERT INTO krj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero kamo tana, palanggaa ninyo ang inyo mga kaaway kag maghimo kamo kang mayad kananda. Magpahuram kamo kag indi magpaabot kang bayad. Kon amo dya ang inyo himoon, bahul nga padya ang inyo mabaton kag nagapakita nga kamo mga anak kang Dios nga Labing Mataas, tungud hay tana mayad sa tanan nga tawo - sa mga di-mapinasalamatun kag sa mga malaot. ");
INSERT INTO krj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mangin maluloy-on kamo pareho kang inyo Amay nga maluloy-on.” ");
INSERT INTO krj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Indi ninyo paghusgaran ang inyo isigka-tawo, agud to nga indi man kamo paghusgaran kang Dios. Indi kamo magkuon nga ang sangka tawo dapat nga silotan agud to nga ang Dios indi man magkuon nga kamo sirilotan. Patawara ninyo ang mga nakasala kaninyo agud to nga patawarun man kamo kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Magpanugro kamo sa iba agud to nga ang Dios magatugro man kaninyo. Ang inyo nga mabaton indi lang nga ginsukub ka mayad, kundi gin-uyug kag gindasuk kag nagaarawas pa sa surukban antes ibu-bo sa inyo nga surudlan. Tungud hay kon ano ang pagtugro ninyo sa iba amo man ang pagtugro kang Dios kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naghambal kananda si Jesus kang dya nga paraanggidan: “Ang sangka tawo nga bulag indi makadapit kang pareho na nga bulag. Tungud hay kon himoon na dya pareho sanda nga mahulog sa kalog. ");
INSERT INTO krj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wara ti estudyante nga labaw pa sa anang maestro. Pero kon ang estudyante makatapos run kang ana nga pagtuon, mangin pareho run man tana kang ana maestro. ");
INSERT INTO krj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ginamulalungan mo gid haw ang gamay nga puling sa mata kang imo isigka-tawo, pero wara tana nimo ginasapak ang troso nga rugyan sa imo mata? ");
INSERT INTO krj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Paano ikaw makakuon sa imong isigka-tawo nga, ‘Amigo, bul-un ko ang imo nga puling,’ kon indi gani nimo makita ang troso nga rugyan sa imong mata? Mga hipokrito! Bul-anay ang troso nga rugyan sa imo mata, agud to nga makakita ikaw ka mayad kag mabuul mo ang puling sa mata kang imo isigka-tawo. ");
INSERT INTO krj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ang mayad nga kahoy wara nagapamunga kang sayud nga bunga, kag ang sayud nga kahoy wara man nagapamunga kang mayad nga bunga. ");
INSERT INTO krj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ang kada kahoy makilala mo paagi sa anang bunga. Wara kamo nagapamu-po kang higera sa talongon kag wara man kamo nagapamu-po ka bunga kang ubas sa sapinit. ");
INSERT INTO krj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amo man ria sa tawo. Ang tawo nga mayad nagahimo kang mayad nga mga butang tungud hay mayad man nga mga butang ang rugyan sa ana nga tagipusoon. Samtang ang malaot tana nga tawo malaot nga mga butang ang ana ginahimo, tungud hay malaot man nga mga butang ang rugyan sa ana nga tagipusoon. Tungud hay kon ano ang rugyan sa tagipusoon kang tawo amo man ang nagagwa sa anang ba-ba.” ");
INSERT INTO krj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Andut nga ginatawag ninyo ako nga ‘Ginoo’ pero wara man kamo pagtuman kang akun ginakuon kaninyo? ");
INSERT INTO krj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ipakita ko kaninyo kon ano nga klase ka tawo ang sin-o man nga nagaparapit kanakun kag nagapamati sa akun mga pulong kag ana dya ginatuman. ");
INSERT INTO krj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pareho tana kang tawo nga nagkutkot kang madalum kag nagpatindug kang anang balay sa pundasyon nga bato. Nag-abot ang baha, kag nag-arawas ang suba, kag ginlalas ang amo nga balay, pero wara gid dya matay-ug tungud hay mapag-un gid ang pagpatindug ka dya. ");
INSERT INTO krj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ang tawo tana nga nagapamati kang akun mga pulong, pero wara na dya pagtumana, pareho lang tana kang tawo nga nagpatindug kang balay sa lupa nga wara na butangi kang pundasyon. Dayon ginlalas dya kang baha kag lagi-lagi narumpag kag sobra gid ang pagkawasdak na ka dya!” ");
INSERT INTO krj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapos nga mahambal ni Jesus ang tanan nga dya sa mga tawo, nag-agto tana sa Capernaum. ");
INSERT INTO krj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","May sangka kapitan kang suldado nga Romanhun rugto nga ang anang nahamut-an nga surugoon nagamasakit kag tagumatayun run. ");
INSERT INTO krj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kang mabatian kang kapitan ang nahanungud kay Jesus, nagpasugo tana sa mga kamal-aman kang mga Judio nga pangabayun si Jesus nga mag-agto anay sa anang balay agud nga aydun ang ana surugoon. ");
INSERT INTO krj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nagpanaw ang mga ginsugo kang kapitan, kag pag-abot nanda kay Jesus, nagpakitluoy gid sanda kana, “Ang tawo nga dya nagakabagay gid nga buligan mo, ");
INSERT INTO krj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tungud hay palangga na ang atun nasyon, kag tana mismo ang nagpatindug kang sinagoga para kanatun.” ");
INSERT INTO krj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dayon nagtawas si Jesus kananda. Kang nagahinamput run tana sa balay, nagsugo ang kapitan kang anang mga amigo agud sug-alawun tana kag kun-an, “Ginoo, indi run pagpabudlayi ang imong kaugalingun, tungud hay indi ako takus nga magbaton kanimo sa akun balay. ");
INSERT INTO krj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Amo gani nga wara run ako magpakigkita kanimo tungud hay indi ako takus. Pero maghambal lang ikaw kag maayad ang akun surugoon. ");
INSERT INTO krj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Naman-an ko ria hay ako man sa idalum kang awtoridad kang mga opisyal, kag may mga suldado man sa idalum kang akun awtoridad. Kon maghambal ako sa isara, ‘Panaw to!’ mapanaw man tana. Kon magkuon ako sa isara, ‘Agto rugya!’ maagto man tana rugya. Sa akun surugoon tana, kon magkuon ako nga, ‘Himoa dya!’ ginahimo na man.” ");
INSERT INTO krj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Natingala si Jesus kang mabatian na dya. Nagbalikid tana sa duro nga mga tawo nga nagasurunod kana kag nagkuon, “Sugidan ko kamo: wara pa gid ako makakita kang tawo nga amo dya kabahul ang anang pagtoo; wara gid bisan rugya sa Israel!” ");
INSERT INTO krj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kang pagbalik kang mga ginsugo kang kapitan sa balay, nakita nanda nga mayad run ang surugoon. ");
INSERT INTO krj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pagkatapos ka dya, nag-agto si Jesus sa banwa nga ginatawag Nain. Nag-imaw man kana ang anang mga disipulo kag ang duro nga mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kang nagahinamput run tana sa pwertahan kang banwa, nataboan nga nagapagwa man ang mga tawo sa amo nga banwa nga nagakumpanyar sa patay. Ang patay nga dya bugtong nga bata nga laki kang sangka balo nga bayi. ");
INSERT INTO krj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kang makita ni Jesus ang nanay kang napatay, naluoy gid tana kag ginkun-an na dya, “Indi ikaw magpanangis.” ");
INSERT INTO krj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dayon nagparapit si Jesus kag gintungtong na ang anang alima sa lungon kag ang mga tawo nga nagayayong ka dya nagpundo. Nagkuon si Jesus sa patay, “Nonoy, ginakun-an ko ikaw, bangon dyan!” ");
INSERT INTO krj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ang patay nagbangon kag nagpungko kag dayon nag-umpisa ka hambal. Gintugyan tana ni Jesus sa anang nanay. ");
INSERT INTO krj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gindakup kang kahadluk ang tanan nga mga tawo rugto, kag gindayaw nanda ang Dios, “Sangka gamhanan nga propeta ang nagpakita kadya kanatun!” Kag nagkuon pa gid sanda, “Ang Dios nag-abot sa pagbulig sa anang mga katawhan!” ");
INSERT INTO krj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ang balita nga dya nahanungud kay Jesus naglapnag sa bilog nga Judea kag sa tanan nga mga lugar sa palibot. ");
INSERT INTO krj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ang tanan nga mga butang nahanungud kay Jesus ginpanugid kay Juan nga Manugbawtiso kang anang mga disipulo. Gani, ginpatawag na ang darwa sa anang mga sumuronod ");
INSERT INTO krj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kag ginsugo nga mag-agto sa Ginoo agud pamangkoton tana kon bala tana amo run ang ginakuon ni Juan nga maabot, ukon mapaabot pa gid sanda kang iba. ");
INSERT INTO krj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kang pag-abot nanda kay Jesus, nagkuon sanda, “Ginsugo kami ni Juan nga Manugbawtiso agud mamangkot kanimo kon bala ikaw amo run ang amun ginapaabot, ukon mapaabot pa kami kang iba.” ");
INSERT INTO krj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nataboan man nga kang amo gid to nga tion duro nga mga tawo ang gin-ayad ni Jesus sa andang mga masakit kag balatian. Ang mga malaot nga ispirito ginapagwa na sa mga tawo nga nasudlan ka dya, kag duro nga mga bulag ang ana nga ginpang-ayad kag makakita run. ");
INSERT INTO krj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nagsabat si Jesus sa mga ginsugo ni Juan, “Balik kamo kay Juan kag isugid ninyo kana ang inyong mga nakita kag nabatian, nga ang mga bulag makakita run, ang mga piang makapanaw run, ang mga aruon ayad run, ang mga bungul makabati run, ang mga patay nabuhi liwan, kag ang Mayad nga Balita ginawali run sa mga imol. ");
INSERT INTO krj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kag bulahan gid ang tawo nga wara pagduha-duha kanakun!” ");
INSERT INTO krj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagkalumbos kang mga ginsugo ni Juan, naghambal si Jesus sa mga tawo nahanungud kay Juan. Kuon na, “Kato anay kang mag-agto kamo sa kamingawan, ano ang ginapaabot ninyo nga makita? Kugon bala nga ginahapay-hapay lang kang hangin? ");
INSERT INTO krj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ano bay ang gin-agto ninyo rugto nga gusto ninyo makita? Tawo bala nga nagasuksok kang marahalun nga bayo? Ang nagasuksok kang amo ria kag nagapatuyang sa pagpangabuhi, sa mga palasyo lang tana ninyo ria makita! ");
INSERT INTO krj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kar-on, ano gid ang gin-agto ninyo rugto para sulngun? Propeta bala? Huud, propeta matuod, kag sobra pa gani sa propeta ang inyo nakita. ");
INSERT INTO krj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tungud nga si Juan nga dya amo run ang ginatumud sa Kasulatan nga kuon kang Dios, ‘Magapadara ako kang akun manugbalita nga magauna kanimo agud nga mag-aman kang imong dalan.’” ");
INSERT INTO krj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sugidan ko kamo, “Wara pa gid ti natawo sa kalibutan nga makalabaw pa kay Juan. Pero ang pinakakubus sa ginharian kang Dios mas labaw pa kana.” ");
INSERT INTO krj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nabatian dya kang tanan nga mga tawo kag kang mga manugsukot kang buwis, kag sanda ka dya amo ang nagpati nga matarung ang Dios sa anang ginahimo, tungud hay nagpabawtiso sanda kay Juan. ");
INSERT INTO krj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ang mga Fariseo tana kag ang mga manunudlo kang Kasugoan ginsikway nanda ang tinutuyo kang Dios kananda tungud hay wara sanda magpabawtiso kay Juan. ");
INSERT INTO krj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Sa ano ko ayhan mapaanggid ang mga tawo sa kadya nga panag-on? Daw ano sanda ayhan? ");
INSERT INTO krj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Daw pareho sanda kang mga bata nga nagapurungko sa tindahan kag nagasinggitanay, ‘Gintukaran namun kamo kang masadya nga sonata, pero wara man kamo magsaot; ginkantahan namun kamo kang masubu nga kanta, pero wara man kamo magpanangis!’ ");
INSERT INTO krj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tungud hay kang mag-abot si Juan nga Manugbawtiso, nagapuasa tana kag wara nagainum kang bino, kag nagkuon kamo, ‘Ginagamhan tana kang demonyo.’ ");
INSERT INTO krj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kar-on, nag-abot ang Anak kang Tawo nga nagakaun tana kag nagainum, kag nagkuon kamo, ‘Turuka bala ninyo ang tawo nga dya! Parakaun kag parainum! Amigohay pa sanda kang mga manugsukot kang buwis kag kang mga makasasala!’ ");
INSERT INTO krj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ang kaaram kang Dios ginapamatud-an kang tanan nga nagabaton ka dya.” ");
INSERT INTO krj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kar-on, may sangka Fariseo nga nag-agda kay Jesus nga magkaun imaw kana. Gani nag-agto si Jesus sa balay kang Fariseo kag nagpungko para magkaun. ");
INSERT INTO krj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sa amo nga banwa, may sangka bayi nga mahigku ang anang pagkabuhi. Kang mabalitaan na nga si Jesus nagakaun sa balay kang Fariseo, nag-agto tana rugto nga nagadara kang agwa nga nasulud sa surudlan nga alabastro. ");
INSERT INTO krj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nagtindug tana sa may likod, sa kahig nayon ni Jesus, nga nagahiribiun. Ginabasa na kang anang luha ang mga kahig ni Jesus, kag ginatrapohan na dya kang anang buhok, ginaharukan na kag bu-boan kang agwa. ");
INSERT INTO krj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kang makita dya kang Fariseo nga nag-agda kay Jesus, nagmuno tana sa anang kaugalingun, “Kon propeta gid man ang tawo nga dya, maman-an na kon ano nga klase ka bayi ang nagahikap kana, nga dya nga klase ka bayi mahigku ang anang pagkabuhi.” ");
INSERT INTO krj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nagkuon si Jesus kay Simon, “Simon, may ikuon ako kanimo.” Nagsabat si Simon, “Sige, Maestro, ikuon kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nagkuon si Jesus, “May darwa ka tawo nga nag-utang kang kwarta sa manugpautang. Ang isara nag-utang kang 500 ka kwarta nga pilak, kag ang isara tana 50. ");
INSERT INTO krj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kang indi run gid sanda makabayad, ginkun-an sanda kang manugpautang nga indi run lang nanda pagbaydan ang utang nanda nga darwa. Kar-on, sin-o sa darwa nga dya ang labi nga magapalangga kana?” ");
INSERT INTO krj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nagsabat si Simon, “Sa banta ko, ang tawo nga mas bahul ang anang utang nga ginpatawad.” Nagkuon ni Jesus, “Igsakto ang sabat mo, Simon.” ");
INSERT INTO krj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dayon nagbalikid si Jesus sa bayi kag nagkuon kay Simon, “Nakita mo ang bayi nga dya? Pagsulud ko kaina sa imong balay, wara ikaw magtugro kanakun kang tubig nga ipanghugas sa akun mga kahig, pero ang bayi tana nga dya, ginhugasan na kang anang mga luha ang akun mga kahig, kag gintrapohan na kang anang buhok. ");
INSERT INTO krj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wara mo ako haruki sa pag-abi-abi kanakun, pero ana tana, umpisa nga magsulud ako wara ti untat ang anang pagharuk sa akun mga kahig. ");
INSERT INTO krj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wara mo ginhisoan kang lana ang akun ulo sa pag-amuma kanakun, pero ang bayi tana nga dya, agwa pa gani ang anang ginbu-bo sa akun kahig. ");
INSERT INTO krj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gani sugidan ko ikaw, Simon, nga ang anang hanggud nga paghigugma nga ginpakita nagapatimaan nga ang duro na nga mga sala ginpatawad run. Tungud hay ang tawo nga gamay lang ang anang sala kag ginpatawad, gamay man nga gugma ang anang ipakita.” ");
INSERT INTO krj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dayon nagkuon si Jesus sa bayi, “Ginpatawad run ang imong mga sala.” ");
INSERT INTO krj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ang iba nga imaw nanda nga nagakaraun nagmuno sa andang kaugalingun, “Sin-o gid bala ang tawo nga dya, nga bisan ang mga sala ginapatawad na?” ");
INSERT INTO krj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero nagkuon si Jesus sa bayi, “Ang imong pagtoo ang nagluwas kanimo. Panaw run nga may kalinung.” ");
INSERT INTO krj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wara magbuhay, naglibot si Jesus sa mga kabanwahanan kag kabaryohanan nga nagawali kang Mayad nga Balita nahanungud sa Paghari kang Dios. Ang napulo'g darwa ka mga disipulo nagtawas man kana ");
INSERT INTO krj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kag may iba man nga mga kababainhan nga ginhilway ni Jesus sa mga malaot nga ispirito kag gin-ayad sa andang mga balatian: si Maria nga kilala man nga Maria Magdalena, nga nasudlan anay ka pito ka mga demonyo, pero ginpagwa sanda ni Jesus; ");
INSERT INTO krj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana nga asawa ni Cusa nga amo ang mayordomo sa palasyo ni Herodes; si Susana, kag ang iba pa gid nga mga kababainhan. Sanda ka dya amo ang nagtatap kay Jesus kag sa anang mga disipulo halin sa andang kaugalingun nga mga pagkabutang. ");
INSERT INTO krj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Padayon nga nagatiriripon ang mga tawo kay Jesus nga nagharalin pa sa nagkalain-lain nga mga kabanwahanan. Kang duro run ang mga tawo nga nagtiriripon, nag-istorya si Jesus kananda kang paanggid nga dya: ");
INSERT INTO krj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May mangunguma nga nagsab-og kang binhi sa ana uma. Kar-on, kang nagasab-og run tana kang binhi, ang iba kadya nagtupa sa may aragyan. Ginlapakan dya kang mga tawo kag gintuka kang mga pispis. ");
INSERT INTO krj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ang iba nga binhi nagtupa sa batohon nga lupa. Nagtubo man dya pero nauga lang man tungud nga mara ang lupa. ");
INSERT INTO krj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kag ang iba tana nga binhi nagtupa sa ginatuboan kang sapinit, kag nagtubo man dungan sa sapinit, pero ginlumus dya kang sapinit kag napatay. ");
INSERT INTO krj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero may iba man nga mga binhi nga nagtupa sa manami nga lupa. Nagtubo dya kag nagpang-uhay kang pilo.” Pagkatapos, nagkuon si Jesus, “Kamo nga nagaparamati, intiendiha ninyo ka mayad ang inyo nabatian!” ");
INSERT INTO krj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dayon namangkot kay Jesus ang anang mga disipulo kon ano ang kahulogan kang dya nga paraanggidan. ");
INSERT INTO krj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kag nagsabat si Jesus, “Kamo ang ginapaman-an kang mga kamatuoran nahanungud sa paghari kang Dios. Pero ang iba tana kinahanglan nga sugidan paagi sa mga paraanggidan, agud to nga bisan magturuk sanda, indi man angud sanda makakita, kag bisan magpamati sanda, indi man angud sanda makahangup.” ");
INSERT INTO krj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Amo dyaay nga kahulogan kang paraanggidan: ang binhi amo ang pulong kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ang aragyan nga gintup-an kang binhi amo ang mga tawo nga nakabati kang pulong kang Dios, pero nag-abot ang Yawa kag gin-agaw ang pulong nga dya sa andang mga tagipusoon agud to nga indi sanda magtuo kag maluwas. ");
INSERT INTO krj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ang batohon nga lupa nga gintup-an kang binhi amo ang mga tawo nga nakabati man kang pulong kang Dios kag ginbaton nanda dya nga may kalipay. Pero wara dya manggamot sa andang tagipusoon. Agi lang ang andang pagpati, tungud hay pag-abot kang mga pagsulay dayon lang man nanda talikod. ");
INSERT INTO krj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ang lupa nga may sapinit nga gintup-an kang binhi amo ang mga tawo nga nakabati. Ang pulong nga anda nabatian gindaug kang mga problema, kag kang andang handum sa pagmanggad, kag kang mga kalipayan rugya sa kalibutan, gani wara maluto ang andang bunga. ");
INSERT INTO krj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ang nami tana nga lupa nga gintup-an kang binhi amo ang mga tawo nga nakabati kang pulong kang Dios kag ginbaton nanda dya kang hugut sa andang tagipusoon kag gintuman. Gani sa andang kaukud namunga dya sa andang kabuhi.” ");
INSERT INTO krj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wara ti nagasindi kang sulo kag takluban dya ukon ibutang sa idalum kang katre, kundi ginatungtong dya sa anang burutangan agud masanagan ang mga tawo nga magasulud sa balay. ");
INSERT INTO krj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wara ti ginatago nga indi maman-an, kag wara ti likum nga indi maluntad kag mabuyagyag. ");
INSERT INTO krj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gani, mag-amlig kamo sa inyong pagpamati, tungud hay ang tawo nga may ana run nga ginaangkun pagatugroan pa gid kang duro. Pero ang tawo tana nga wara ti may ginaangkun, pagabul-un pa gani kana ang ginakabig na nga ana.” ");
INSERT INTO krj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kar-on, nag-agto kay Jesus ang anang nanay kag mga libayun nga laki, pero wara sanda makaparapit kana tungud sa kadurohon kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","May nagkuon kay Jesus, “Ang imong Nanay kag ang imong mga bugto rugto nagatindug sa gwa kag gusto nanda magsalongkita kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero nagkuon si Jesus kananda, “Ang akun nanay kag mga kabugtoan amo ang mga nagapamati sa pulong kang Dios kag nagatuman ka dya.” ");
INSERT INTO krj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sangka adlaw nagsakay si Jesus sa baruto imaw kang anang mga disipulo. Nagkuon tana kananda, “Dali, matabok kita rugto sa pihak kang linaw.” Gani nagpanakayun sanda. ");
INSERT INTO krj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Samtang nagapanakayun sanda, naturogan si Jesus. Burubuhay, nagbaskug ang hangin sa linaw kag amat-amat nga nabuta ka tubig ang baruto kag tam-an run gid ka makataragam ang anda nga kahimtangan. ");
INSERT INTO krj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dayon ginparapitan nanda si Jesus kag ginpukaw, “Maestro, Maestro! Malunod run kita!” Nagbugtaw si Jesus kag nagtindug. Ginmandoan na ang hangin kag ang daragkul nga mga balud nga magpuut. Nagpuut ang bagyo kag naglinung ang tanan. ");
INSERT INTO krj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dayon nagkuon si Jesus kananda, “Diin run ang inyong pagtoo?” Natingala gid sanda kag nahadluk, kag nagkinun-anay, “Ano tana nga klase ka tawo dya man! Ginamandoaan na ang hangin kag mga balud kag nagapati sanda kana!” ");
INSERT INTO krj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kar-on, nagdungka sanda sa lugar kang mga Gerasanhun, nga nahamtang sa tabok kang Galilea. ");
INSERT INTO krj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagtakas ni Jesus, ginsug-alaw tana kang sangka tawo nga nagauli sa amo ria nga banwa. Ang tawo nga dya ginsudlan kang mga demonyo, gani buhay run nga wara tana nagasuksok kang bayo kag wara run nagauli sa balay kundi sa mga lungib nga rulubngan. ");
INSERT INTO krj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kang makita na si Jesus, nagsiyagit tana kag naghapa sa atubang ni Jesus kag nagsinggit, “Jesus nga Anak kang Dios nga Labing Mataas! Ano gid bala ang tuyo mo kanakun? Nagapakitluoy ako kanimo nga indi ako pagsakita!” ");
INSERT INTO krj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ginkuon na dya tungud nga ginmandoan run ni Jesus ang demonyo nga magwa sa tawo. Pira run ka beses halin pa kang una nga ginagamhan tana ka dya, bisan bantayan tana ka dya ka mayad kag gapuson kang kadena ang anang alima kag kahig, mabugto na man angud ang kadena, kag ginaguyod tana kang demonyo sa kamingawan. ");
INSERT INTO krj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ginpamangkot tana ni Jesus, “Sin-o ngaran mo?” Nagsabat ang tawo, “Ang akun ngaran linibo,” tungud hay duro matuod nga mga demonyo ang nagsurulud kana. ");
INSERT INTO krj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ang mga demonyo nagpakitluoy kay Jesus nga indi lang sanda pagmandoan nga mag-agto sa kadadalman. ");
INSERT INTO krj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kar-on, rugto sa may marapit nga bakulod, may panung kang mga baboy ang nagapanginaun. Ang mga demonyo nagpakitluoy kay Jesus nga pasudlun lang sanda sa lawas kang mga baboy nga to, kag gintugotan sanda ni Jesus, ");
INSERT INTO krj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","gani ang mga demonyo nagwa sa tawo kag nagsurulud sa mga baboy. Ang bilog nga panung kang mga baboy nagdinalagan sa pil-as kag nagkarahulog sa linaw kag nagkaralumus. ");
INSERT INTO krj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kang makita kang mga manugsagod kang mga baboy ang natabo nga dya, nagdinalagan sanda kag ginsugid nanda dya sa mga tawo sa banwa kag sa mga kaumahan. ");
INSERT INTO krj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Naggurowa ang mga tawo agud turukun kon ano ang natabo kag nag-agto sanda kay Jesus kag nasapwan nanda ang tawo nga ginsudlan anay kang demonyo nga nagapungko sa may kahig nayon ni Jesus. Nagasuksok run tana kang bayo kag mayad run ang anang paminsarun. Kag hinadlukan gid sanda tanan. ");
INSERT INTO krj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ang mga nakakita kadya nga hitabo amo man ang nagpanugid sa mga tawo kon paano naayad ang tawo nga nasudlan anay kang demonyo. ");
INSERT INTO krj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dayon, ang tanan nga mga tawo sa bilog nga lugar kang Gergesa nagpangabay kay Jesus nga maghalin tana rugto, tungud hay nahadluk gid sanda ka mayad. Gani nagsakay si Jesus sa baruto kag maghalin. ");
INSERT INTO krj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kar-on, ang tawo tana nga ginsudlan anay kang mga demonyo, nagpakitluoy kay Jesus, “Patawsa ako kanimo.” Pero wara tana ginpatawas ni Jesus kundi nga ginpapanaw tana kag ginkun-an, ");
INSERT INTO krj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uli to sa inyo balay kag ipanugid kon ano ang ginhimo kang Dios kanimo.” Gani naglibot ang tawo sa bilog nga banwa nga nagapanugid kon ano ang ginhimo ni Jesus kana. ");
INSERT INTO krj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagbalik ni Jesus sa pihak nga bahin kang linaw, gin-abi-abi tana kang duro nga mga tawo, tungud hay tanan sanda nagahurulat kana. ");
INSERT INTO krj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Burubuhay may sangka tawo nga nag-abot nga ginahingaranan kay Jairo. Tana ka dya sangka opisyal sa sinagoga rugto. Nagluhod tana sa atubang ni Jesus nga nagapakitluoy nga raad maagto si Jesus sa anang balay ");
INSERT INTO krj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tungud nga tagumatayun ang anang bugtong nga bata nga bayi. Nagapang-edadun dya kang napulo'g darwa ka tuig. Kang nagapanaw run si Jesus paagto sa balay ni Jairo, nagadinus-uganay ang mga tawo sa anang palibot. ");
INSERT INTO krj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","May sangka bayi rugto nga sa sulud kang napulo'g darwa ka tuig wara gid pagpuut ang anang pagdugo. Naubos lang ang anang mga pagkabutang sa pagpabulong, pero wara gid ti nakaayad kana. ");
INSERT INTO krj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nagparapit tana sa may likod nayon ni Jesus kag gintandug na ang sidsid kang bayo ni Jesus, kag lagi-lagi nagpuut ang anang pagdugo. ");
INSERT INTO krj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dayon namangkot si Jesus, “Sin-o ang nagtandug kanakun?” Tanan nga tawo rugto nagsabat nga wara tanda magtandug. Dayon nagkuon si Pedro, “Maestro, duro nga mga tawo ang nagapalibot kag nagadinagusu kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero nagkuon si Jesus, “Pero may dyan gid nga nagtandug kanakun tungud hay nabatyagan ko nga may gahum nga naggwa kanakun!” ");
INSERT INTO krj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kar-on, naman-an kang bayi nga indi tana makalikaw sa anang ginhimo, gani nagparapit tana nga nagakurudug kag nagluhod sa atubang ni Jesus. Kag rugto sa tunga kang tanan ginsugidan na si Jesus kon andut gintandug na dya kag kon paano tana nag-ayad lagi. ");
INSERT INTO krj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nagkuon si Jesus kana, “Inday, ang imo pagtoo amo ang nag-ayad kanimo. Kar-on, panaw run nga may kalinung.” ");
INSERT INTO krj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Samtang nagahambal pa si Jesus, may tawo nga nag-abot halin sa balay kang opisyal nga si Jairo, kag ginkun-an na si Jairo nga indi na run lang pagdistorbohon ang Maestro hay patay run ang anang bata. ");
INSERT INTO krj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero nabatian dya ni Jesus kag nagkuon tana kay Jairo, “Indi ikaw magkahadluk; magtuo lang ikaw, kag ang imo bata maayad.” ");
INSERT INTO krj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pag-abot ni Jesus sa balay ni Jairo, wara tana ti iba nga gintugotan nga magsulud imaw kana magluwas lang kanday Pedro, Juan kag Santiago kag ang mga ginikanan kang bata. ");
INSERT INTO krj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tanan nga tawo rugto nagaparanangisun kag nagaparanambitun tungud sa bata. Nagkuon si Jesus kananda, “Indi kamo maghirinibi. Bukun ti patay ang bata; nagakaturog lang.” ");
INSERT INTO krj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ginkadlawan lang nanda si Jesus, tungud hay naman-an gid nanda nga patay run ang bata. ");
INSERT INTO krj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ginkaptan na ang bata sa alima kag gintawag, “Inday, magbangon kaw!” ");
INSERT INTO krj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nagbalik ang ginhawa kang bata kag lagi-lagi nagbangon dya. Dayon ginsugo sanda ni Jesus nga tugroan ang bata kang pagkaun. ");
INSERT INTO krj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Natingala gid ang mga ginikanan kang bata. Pero ginbilinan sanda ni Jesus nga indi gid nanda pag-ipanugid bisan kay sin-o ang natabo nga dya. ");
INSERT INTO krj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Gintipon ni Jesus ang napulo'g darwa ka mga disipulo kag gintugroan kang gahum kag awtoridad sa pagpanabog kang tanan nga mga demonyo kag sa pag-ayad kang mga balatian. ");
INSERT INTO krj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ginsugo na sanda nga magpanaw para magpangwali kang nahanungud sa paghari kang Dios kag magpang-ayad kang mga masakitun. ");
INSERT INTO krj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ginkun-an na sanda, “Indi kamo magbalon kang bisan ano sa inyo nga pagpanaw: bisan baston, ukon puyo-puyo, ukon pagkaun, ukon kwarta, kag bisan gani irislan nga bayo. ");
INSERT INTO krj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kon sa diin nga balay kamo batonon, sa amo man nga balay kamo magtiner hasta sa tion nga maghalin kamo sa amo nga banwa. ");
INSERT INTO krj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kon may mga tawo nga indi magbaton kaninyo, tataka ninyo ang yab-ok sa inyong mga kahig sa inyong paghalin, bilang patimaan nga wara run kamo ti sarabtun kananda.” ");
INSERT INTO krj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nagpanaw ang mga disipulo kag naglibot sa tanan nga mga kabaryohanan nga nagawali kang Mayad nga Balita kag nagapang-ayad kang mga nagamarasakit sa tanan nga mga lugar. ");
INSERT INTO krj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Si Herodes nga amo ang manugdumara kang Galilea, nakabati kang tanan nga nagakaratabo nga dya. Naglibug gid ang anang ulo tungud hay may iba nga nagakuon nga kuno nabuhi liwan si Juan nga Manugbawtiso! ");
INSERT INTO krj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","May iba man tana nga nagakuon nga si Elias kuno nagpakita, kag may iba pa gid tana nga nagakuon nga nabuhi liwan ang isara sa mga propeta katong una. ");
INSERT INTO krj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nagkuon si Herodes, “Ginpautdan ko run kang ulo si Juan, pero sin-o tana dya nga tawo nga raku ang akun nabatian nahanungud kana?” Kag ginatinguhaan na gid nga makita si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pagkabalik kang mga apostoles nga ginsugo ni Jesus, ginsugid nanda kana ang tanan nanda nga mga hinimoan. Gindara sanda ni Jesus kag nag-agto sanda sa banwa nga ginatawag Betsaida nga sandahanun lang. ");
INSERT INTO krj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pagkamaan kang raku nga mga tawo, nagsurunod sanda kana. Ginbaton sanda ni Jesus kag naghambal tana kananda nahanungud sa paghari kang Dios. Ginpang-ayad na man ang mga nagakinahanglan nga ayadun. ");
INSERT INTO krj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kang maghinunod run ang adlaw, ang napulo'g darwa ka mga apostoles nagparapit kay Jesus kag nagkuon, “Papanawa run ang mga tawo agud makaagto sanda sa mga kabaryohanan kag sa mga kaumahan rugya sa palibot kag makakita sanda kang pagkaun kag lugar nga anda mahinggaan, tungud hay rugya kita sa kamingawan.” ");
INSERT INTO krj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero nagkuon si Jesus kananda, “Kamo mismo ang magtugro kananda kang andang makaun!” Nagsabat sanda, “Ang atun pagkaun lima lang ka bilog nga tinapay kag darwa ka bilog nga isda. Indi dya makahusto, magluwas lang kon magpanaw kami kag magbakal kang pagkaun para sa tanan nga mga tawo nga dya!” ");
INSERT INTO krj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Mga lima ka libo ka mga laki ang rugto kato.) Nagkuon si Jesus sa anang mga disipulo, “Abi, papungkoa ninyo ang mga tawo sa grupo nga mga tagkalim-an.” ");
INSERT INTO krj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ginsunod man nanda ang sugo ni Jesus kag ginpapungko sanda tanan. ");
INSERT INTO krj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ginbuul ni Jesus ang lima ka bilog nga tinapay kag ang darwa ka isda, kag nagtangra sa langit kag ginpasalamatan na dya sa Dios. Pagkatapos, ginpamihak-pihak na dya kag ginpanugro sa mga disipulo agud ipanagtag nanda sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nakakaun sanda tanan kag nagkarabusog. Kang paniponon run kang mga disipulo ang nabilin nga ginpamihak-pihak, napulo'g darwa pa ka alat ang nabuta. ");
INSERT INTO krj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sangka tion nga nagaisarahanun si Jesus nga nagapangamuyo, ang ana nga mga disipulo rugyan man. Ginpamangkot na sanda, “Kon para sa mga tawo, sin-o kuno ako?” ");
INSERT INTO krj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nagsabat sanda, “May nagakuon nga ikaw kuno si Juan nga Manugbawtiso, ang iba nagakuon nga ikaw kuno si Elias. Ang iba nagakuon man nga ikaw kuno isara sa mga propeta kato anay nga nabuhi liwan.” ");
INSERT INTO krj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Namangkot si Jesus kananda, “Kon para tana kaninyo, sin-o ako?” Nagsabat si Pedro, “Ikaw ang Cristo nga ginpadara kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ginpaandaman gid sanda ka mayad ni Jesus nga indi gid nanda pag-ipanugid bisan kay sin-o ang nahanungud kana. ");
INSERT INTO krj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kag nagkuon pa gid si Jesus kananda, “Ang Anak kang Tawo kinahanglan nga mag-agum kang duro nga mga pag-antos, kag sikwayun kang mga kamal-aman kag kang mga pangulo kang kaparian kag kang mga manunudlo kang Kasugoan. Pagapatyun tana pero sa ikatlo nga adlaw pagabanhawun.” ");
INSERT INTO krj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dayon nagkuon tana kananda tanan, “Ang bisan sin-o nga malyag magsunod kanakun, kinahanglan nga indi na run pagpasulabihun ang anang kaugalingun kag magpas-an tana kang anang kros adlaw-adlaw, kag magsunod kanakun. ");
INSERT INTO krj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ang bisan sin-o nga nagatipig kang anang kabuhi maduraan ka dya, kag ang bisan sin-o tana nga handa maduraan kang kabuhi tungud kanakun, amo tana ang makaangkun ka dya. ");
INSERT INTO krj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tungud hay ano gid bala ang mabuul kang sangka tawo kon maangkun na ang bilog nga kalibutan pero maduraan tana kang kabuhi? ");
INSERT INTO krj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gani ang bisan sin-o man nga magkahuya kanakun kag kang akun mga pulong, ikahuya man tana kang Anak kang Tawo sa anang pagbalik nga may himaya, dara man ang himaya kang Dios nga Amay kag kang balaan nga mga anghel. ");
INSERT INTO krj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sugidan ko kamo: may iba rugya kaninyo nga indi mapatay hasta nga makita na ang paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga walo ka adlaw matapos ginhambal ni Jesus ang mga butang nga dya, gindara na sanday Pedro, Juan kag Santiago, kag nagtukad sanda sa bakulod agud magpangamuyo. ");
INSERT INTO krj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Samtang nagapangamuyo tana, nagbaylo ang dagway kang anang pungyahun kag ang anang bayo nagbanaag sa kaputi. ");
INSERT INTO krj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hinali lang may darwa ka tawo nga nagapakig-istorya kana. Dya amo sanday Moises kag Elias ");
INSERT INTO krj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","nga nagpakita sa andang langitnun nga himaya. Nagpakighambal sanda kay Jesus nahanungud sa anang kamatayun nga magahanabo sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Pedro tana kag ang anang mga kaibahan nahamuukan gid ka turog. Kang makabugtaw sanda nakita nanda ang himaya ni Jesus kag ang darwa ka tawo nga kaimaw na nga nagatindug. ");
INSERT INTO krj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kang nagaparayu run ang darwa ka tawo kay Jesus, nagkuon si Pedro kay Jesus, “Ginoo, mayad gid hay rugya kita. Mapatindug kami kang tatlo ka karakamalig. Ang isara para kanimo, ang isara para kay Moises kag ang isara pa gid tana para kay Elias.” (Ginkuon dya ni Pedro hay wara tana kamaan kon ano ang anang ihambal.) ");
INSERT INTO krj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Samtang nagahambal pa si Pedro, may panganod nga nag-abot kag ginlikupan sanda ka dya. Ginhadlukan gid sanda samtang ginalikupan sanda kang panganod. ");
INSERT INTO krj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","May limug halin sa panganod nga naghambal, “Amo dya ang akun Anak nga akun ginpili; pamatii ninyo tana!” ");
INSERT INTO krj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagpuut kang limug, nakita nanda nga nagaisarahanun run lang si Jesus. Pero ang tanan nga dya ginhipsan lang kang mga disipulo, kag kato nga tinion wara gid nanda ginpanugid bisan kay sin-o ang andang nakita. ");
INSERT INTO krj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kang masunod nga adlaw, nagdulhog sanda halin sa bukid kag raku nga mga tawo ang nag-alaw-alaw kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Halin sa karak-an, may tawo nga nagsinggit nga nagakuon, “Maestro! Nagapakitluoy ako kanimo, sulnga anay ang akun bata nga laki, bugtong ko gid lang dya nga bata! ");
INSERT INTO krj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","May ispirito nga sagad ka tublag kana, kon dakpun gani tana ka dya, gulpi lang tana magsiyagit, kag nagakurudug tana hasta nga magburora ang anang ba-ba. Ginasagi na ka sakit ang akun bata kag haros indi na pagbuy-an! ");
INSERT INTO krj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagpakitluoy run ako sa imong mga disipulo nga pagaw-un nanda dya, pero indi sanda makasarang!” ");
INSERT INTO krj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nagsabat si Jesus, “Kamo nga mga tawo sa kadya nga panag-on, mga wara kamo ti pagtoo kag balingag! Hasta san-o pa ayhan ako magapakig-imaw kaninyo kag magaagwanta kaninyo? Dar-a rugya ang imong bata.” ");
INSERT INTO krj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bisan pa gani nga nagaparapit ang bata kay Jesus ginalampus dya kang demonyo sa lupa kag ginapakudug. Ginmandoan ni Jesus ang malaot nga ispirito nga magwa sa bata, kag gin-ayad na ang bata kag ginbalik sa anang tatay. ");
INSERT INTO krj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ang tanan nga mga tawo rugto daw indi makapati sa andang nakita nga pagkagamhanan kang Dios. Kar-on, samtang ang mga tawo natingala pa gihapon sa tanan nga mga hinimoan ni Jesus, nagkuon tana sa anang mga disipulo, ");
INSERT INTO krj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Indi gid ninyo paglipati ang akun igasugid kaninyo: ang Anak kang Tawo pagatugyan sa gahum kang mga tawo.” ");
INSERT INTO krj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ugaring wara nanda dya mahangpi, tungud hay ginlikum kananda ang kahulogan agud nga indi nanda dya mahangpan. Nahadluk man sanda nga magpamangkot kana nahanungud sa butang nga dya. ");
INSERT INTO krj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sangka bes, nagbinaisay ang mga disipulo kon sin-o gid kananda ang labaw sa tanan. ");
INSERT INTO krj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero naman-an ni Jesus kon ano ang andang ginapinsar, gani nagbuul tana kang sangka bata kag ginpatindug na dya sa anang kilid. ");
INSERT INTO krj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dayon nagkuon tana kananda, “Ang sin-o man nga magabaton sa bata nga dya tungud kanakun nagabaton man kanakun, kag ang nagabaton kanakun nagabaton man sa nagpadara kanakun; tungud hay kon sin-o kaninyo ang pinakakubus sa tanan, tana amo ang labaw sa tanan.” ");
INSERT INTO krj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Naghambal si Juan, “Ginoo, may nakita kami nga tawo nga nagapanabog kang mga demonyo kag ginagamit na ang imong ngaran. Pero gintapna namun tana tungud hay bukun tana ti kaimaw natun.” ");
INSERT INTO krj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nagsabat si Jesus kana, “Indi tana pagtapnaa, tungud hay ang tawo nga wara nagakontra kaninyo, nagadampig kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kang nagahinamput run ang mga inadlaw nga pagadar-un si Jesus sa langit, nagpamat-ud tana nga magpanaw paagto sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gani nagsugo tana kang mga tawo nga mag-una kana. Nagpanaw sanda ka dya kag nag-agto sa sangka baryo kang Samaria agud nga iaman ang tanan nga kinahanglanun sa anang pag-abot. ");
INSERT INTO krj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ang mga tawo rugto indi magbaton kana tungud hay naman-an nanda nga sa Jerusalem tana maagto. ");
INSERT INTO krj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kang naman-an dya kang mga disipulo nga sanday Santiago kag Juan, nagkuon sanda kay Jesus, “Ginoo, gusto mo bala nga mangayo kami kang kalayo sa langit agud to nga papasun sanda?” ");
INSERT INTO krj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero ginbalikid sanda ni Jesus kag ginsabdung. ");
INSERT INTO krj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kag nagpanaw run lang sanda paagto sa iba nga baryo. ");
INSERT INTO krj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Samtang nagapanaw sanda, may sangka tawo nga nagkuon kay Jesus, “Masunod ako kanimo bisan diin ikaw mag-agto!” ");
INSERT INTO krj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nagkuon si Jesus kana, “Ang mga singgarong may mga buho nga ginaistaran kag ang mga pispis may mga pugad, pero ang Anak kang Tawo wara gid ti balay nga ana mapahuwayan.” ");
INSERT INTO krj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nagkuon pa gid tana sa isara, “Sunod ikaw kanakun!” Ugaring ang tawo nga dya nagsabat, “Ginoo, tugoti anay ako nga mag-uli sa balay sa paglubung kang akun tatay.” ");
INSERT INTO krj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nagsabat si Jesus kana, “Pabay-i ang mga patay nga maglubung kang andang mga patay. Pero ikaw timo, panaw kag ibantala ang nahanungud sa paghari kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","May isara pa gid nga nagkuon kay Jesus, “Ginoo, masunod ako kanimo, pero tugoti anay ako nga mag-uli kag maglisensya sa akun panimalay.” ");
INSERT INTO krj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ginsabat tana ni Jesus, “Ang tawo nga nagaarado kag sagi lang man ka balikid indi takus sa pagpasakup sa paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos ka dya, ang Ginoo nagpili pa gid kang kapitoan kag darwa ka mga tawo kag ginsugo na sanda sa tag darwa-darwa nga mag-una kana sa kada banwa kag lugar nga ana pagaagtonan. ");
INSERT INTO krj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nagkuon tana kananda, “Duro ang aranyun, pero gamay lang ang manug-ani. Gani magpangamuyo kamo sa tag-iya kang aranyun nga magpadara tana kang mga manug-ani sa pag-ani kang anang aranyun.” ");
INSERT INTO krj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Panaw kamo. Ginapaagto ko kamo pareho kang mga karnero sa tunga kang mga lobo nga mapintas. ");
INSERT INTO krj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Indi kamo magdara kang puyo-puyo, ukon libon, ukon sandalyas. Indi man kamo magpundo sa dalan sa pagtamyaw sa bisan kay sin-o. ");
INSERT INTO krj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kon magsulud gani kamo sa sangka balay, magkuon anay kamo kananda nga, “Kabay nga magluntad ang kalinung sa panimalay nga dya.” ");
INSERT INTO krj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kon ang nagaistar sa panimalay nga ria maluyagun sa kalinung, maaguman nanda ang kalinung. Pero kon bukun, mabalik lang man kaninyo ang inyo ginkuon. ");
INSERT INTO krj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pabilin kamo sa balay nga inyo ginatineran. Kan-a ninyo kag imna ang bisan ano nga itugro kaninyo tungud hay ang nagapangabudlay nagakadapat lang nga pagasuholan. Indi kamo magsaylo-saylo kang balay nga inyo ginadayonan. ");
INSERT INTO krj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kon mag-agto gani kamo sa sangka banwa kag batonon kamo rugto, kan-a ninyo ang bisan ano nga ginhimus para kaninyo, ");
INSERT INTO krj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kag ayada ninyo ang mga masakitun sa amo nga banwa, kag hambalun ninyo ang mga tawo rugto nga, “Ang Dios marapit run lang maghari kaninyo!” ");
INSERT INTO krj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero kon mag-agto kamo sangka banwa kag indi kamo pagbatonon, magwa kamo sa mga karsada kag amo dya ang ikuon ninyo sa mga tawo, ");
INSERT INTO krj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bisan ang yab-ok kang inyo nga banwa nga nagtapik sa amun nga mga kahig tatakun pa namun, bilang paandam kaninyo. Pero tandaan ninyo dya, ang Dios marapit run lang maghari.” ");
INSERT INTO krj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nagkuon pa gid si Jesus, “Sugidan ko kamo, ‘Sa adlaw nga ang Dios maghukum, mas sobra pa nga silot ang maaguman kang mga tawo sa amo ria nga banwa sangsa mga taga-Sodoma!’” ");
INSERT INTO krj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Makaluluoy gid kamo nga mga taga-Corazin! Makaluluoy man kamo nga mga taga-Betsaida! Tungud hay kon ang mga milagro nga ginpanghimo rugyan kaninyo, ginhimo rugto sa syudad kang Tiro kag Sidon, buhay run daad sanda nagbayo kang sako kag nagbutang kang abo sa andang mga ulo, patimaan kang andang paghinulsul. ");
INSERT INTO krj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sa adlaw kang paghukum, sobra pa nga silot ang maaguman ninyo sangsa mga taga-Tiro kag Sidon. ");
INSERT INTO krj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kamo tana nga mga taga-Capernaum, nagapinsar bala kamo nga bayawun kamo sa langit? Pagatablug kamo sa impyerno.” ");
INSERT INTO krj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nagkuon si Jesus sa anang mga disipulo, “Ang sin-o man nga nagapamati kaninyo nagapamati man kanakun. Ang nagasikway kaninyo, nagasikway man kanakun, kag ang sin-o man nga nagasikway kanakun, ginasikway na man ang nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nagbalik ang kapitoan kag darwa nga malipayun kag nagkuon sanda, “Ginoo, bisan ang mga demonyo nagapati kanamun kon mandoan namun sanda nga ginagamit ang imong ngaran!” ");
INSERT INTO krj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nagsabat si Jesus, “Nakita ko si Satanas nga nahulog halin sa langit nga daw kilat. ");
INSERT INTO krj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gintugroan ko kamo kang awtoridad nga bisan lapakun ninyo ang mga sawa kag mga iwi-iwi kag pyerdehun ninyo ang gahum kang kaaway, wara gid ti bisan ano nga makahalit kaninyo. ");
INSERT INTO krj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero indi kamo magkalipay tungud hay nagapati kaninyo ang mga demonyo, kundi magkalipay kamo tungud hay ang inyong mga ngaran nasulat run rugto sa langit.” ");
INSERT INTO krj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa amo man to nga tion, ginlipay ka mayad si Jesus kang Balaan nga Ispirito, kag nagakuon tana, “Nagapasalamat ako kanimo Amay, nga Ginoo kang langit kag lupa, tungud hay ang mga butang nga wara nimo ginpahayag sa mga tawo nga maaram kag may tinun-an, ginpahayag nimo sa mga tawo nga wara ti tinun-an. Huud, Amay, nagapasalamat ako tungud hay amo dya ang nahamut-an nimo nga matabo. ");
INSERT INTO krj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ang tanan nga mga butang gintugyan kanakun kang akun Amay. Wara ti nakakilala kon sin-o ang Anak kundi ang Amay. Kag wara man ti nakakilala kon sin-o ang Amay kundi ang Anak, kag ang mga tawo nga ginpili kang Anak nga ipahayag ang Amay.” ");
INSERT INTO krj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dayon nag-atubang si Jesus sa mga disipulo kag nagkuon kananda nga sandahanun lang, “Bulahan kamo hay nakakita kamo kang mga butang nga inyo makita tulad. ");
INSERT INTO krj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sugidan ko kamo: duro nga mga propeta kag mga hari kato anay ang naghandum nga makita ang mga butang nga inyo nakita, pero wara nanda makita, kag mabatian ang mga butang nga inyo nabatian, pero wara nanda mabatian.” ");
INSERT INTO krj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","May sangka manunudlo kang Kasugoan nga nagparapit kay Jesus para tirawan tana, nagpamangkot dya, “Maestro, ano ang akun himoon agud nga makaangkun ako kang kabuhi nga wara ti katapusan?” ");
INSERT INTO krj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nagsabat si Jesus, “Ano haw ang ginakuon sa Kasulatan? Kag ano ang imo paghangup karia?” ");
INSERT INTO krj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nagsabat ang tawo, “Higugmaun mo ang Ginoo nga imo Dios sa bug-os mo nga tagipusoon, sa bug-os mo nga kalag, sa bug-os mo nga ikasarang, sa bug-os mo nga panghuna-huna. Kag palanggaun mo man ang imo isigka-tawo pareho kang pagpalangga mo kang imo kaugalingun.” ");
INSERT INTO krj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nagkuon si Jesus, “Husto ang imo sabat. Kar-on, himoa dya kag makaangkun ikaw kang kabuhi.” ");
INSERT INTO krj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero gusto pa gid ipakita kang manunudlo kang Kasugoan nga husto tana, gani namangkot pa gid tana kay Jesus, “Ti, sin-o bay ang akun isigka-tawo?” ");
INSERT INTO krj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ginsabat tana ni Jesus, “May sangka tawo nga nagdulhog halin sa Jerusalem paagto sa Jerico. Ginbanggaan tana kang mga takawan, gin-ubahan nanda tana kag ginbakol kag ginbayaan nga tagumatayun run. ");
INSERT INTO krj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nataboan nga may sangka pari nga nagdulhog sa amo man ria nga dalan. Pagkakita na kang tawo nga nagahamyangan sa dalan, ginlubsan na lang dya kag rugto tana sa binit ka karsada nag-agi. ");
INSERT INTO krj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Amo man ria ang ginhimo kang Levita. Pag-abot na sa amo ria nga lugar, nakita na man ang tawo sa dalan, pero ginlubsan na lang man dya kag sa binit tana ka karsada nag-agi. ");
INSERT INTO krj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero may sangka Samaritanhun nga nagapanglakatun nga nakaagi sa amo ria nga dalan. Pagkakita na kang tawo, nangir-o gid tana. ");
INSERT INTO krj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ginparapitan na kag ginbutangan kang lana kag bino ang pilas kang tawo kag ginbugkusan. Dayon ginpasakay na sa anang kaugalingun nga sapat kag gindara sa sangka balay-darayonan, kag rugto na gintatap ang tawo nga dya. ");
INSERT INTO krj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkasunod nga adlaw, gintaw-an na kang darwa ka kwarta nga pilak ang manugdumara kang balay-darayonan kag ginkun-an, ‘Atipanun mo tana kag kon pira ang imo magasto kana ulian ko ikaw sa akun pagbalik rugya!’” ");
INSERT INTO krj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dayon namangkot si Jesus sa manunudlo kang Kasugoan, “Kar-on, sa banta mo, sin-o bala sa tatlo ka tawo nga dya ang nagpakita nga tana isigka-tawo kang tawo nga ginbanggaan kang mga takawan?” ");
INSERT INTO krj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nagsabat ang manunudlo kang Kasugoan, “Ang tawo nga nagpakita kang kaluoy kana!” Nagkuon si Jesus kana, “Panaw kag himoa man ang anang ginhimo.” ");
INSERT INTO krj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Samtang nagpadayon si Jesus kag ang anang mga disipulo sa pagpanaw, nakadangat sanda sa sangka baryo, kag rugto gin-abi-abi tana sa balay kang bayi nga ginahingaranan kay Marta. ");
INSERT INTO krj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Si Marta nga dya may libayun nga ginahingaranan kay Maria. Nagpungko tana ka dya sa kahig nayon kang Ginoo kag nagpamati sa anang mga ginapanudlo. ");
INSERT INTO krj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Si Marta tana nagapalibug gid kang tanan na nga mga hirimsun. Gani nagparapit tana kay Jesus kag nagkuon, “Ginoo, mayad bala ayhan dya kanimo nga ginpabay-an lang ako kang akun libayun nga ako lang isara ang mag-obra kang tanan? Abi, kun-i man tana nga buligan na ako!” ");
INSERT INTO krj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nagsabat ang Ginoo kana, “Marta, nagapalibug gid ikaw kag nagasinaku sa duro nga mga butang, ");
INSERT INTO krj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nga ang matuod isara lang man ang kinahanglan gid. Ang napilian ni Maria amo ang mas mayad kag wara gid ti bisan sin-o nga makabuul karia kana.” ");
INSERT INTO krj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sangka tion, nagapangamuyo si Jesus sa sangka lugar. Pagkatapos na pangamuyo, ang isara sa ana mga disipulo nagkuon kana, “Ginoo, tudloi man kami magpangamuyo, pareho nga ginatudloan ni Juan ang anang mga disipulo.” ");
INSERT INTO krj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nagkuon si Jesus kananda, “Kon magpangamuyo gani kamo, amo dyaay ang inyo ikuon: ‘Amay, kabay nga pakabalaanun ang imo ngaran, kabay nga mag-abot run ang tion kang imo paghari; ");
INSERT INTO krj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tugroi kami kang amun pagkaun sa kada adlaw; ");
INSERT INTO krj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","patawara kami kang amun mga sala tungud hay ginapatawad man namun ang tanan nga mga nakasala kanamun. Kag indi nimo pag-itugot nga sulayun kami.’” ");
INSERT INTO krj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dayon nagkuon si Jesus sa anang mga disipulo, “Halimbawa, may amigo ikaw, kag sa tungang gabii nag-agto ikaw sa ana balay kag nagkuon, ‘Abi amigo, pahurama anay ako dyan kang tatlo ka panid nga tinapay, ");
INSERT INTO krj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tungud hay may amigo ako nga nagapanglakatun nga nakahapit sa balay kag wara gid ako ti mapakaun kana!’ ");
INSERT INTO krj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ang amigo mo tana magasabat rugto sa sulud, ‘Indi run ako pagtublaga! Natrangkahan run ang pwertahan kag kami kang akun mga kabataan nagabaratang run. Indi run ako makabangon kag magtugro kanimo ka bisan ano!’ ");
INSERT INTO krj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sugidan ko kamo, kon indi man tana magbangon sa pagtugro kanimo kang bisan ano sa rason nga amigohay kamo, magabangon run lang gid tana kag tugroan ikaw kang tanan mo nga kinahanglan tungud nga wara ikaw magmayha ka sagad pangayo kana. ");
INSERT INTO krj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Gani ginakun-an ko kamo, magpangayo kamo kag mabaton ninyo ang inyo ginapangayo; magpangita kamo kag makita ninyo ang inyo ginapangita; magpanuktok kamo kag pagabuksan kaninyo ang gawang. ");
INSERT INTO krj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tungud hay ang kada isara nga nagapangayo magabaton, ang nagapangita makakita, kag ang nagapanuktok pagabuksan kana ang gawang. ");
INSERT INTO krj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kamo nga mga tatay, kon mangayo kang isda ang inyo bata, tugroan bala ninyo tana kang sawa? ");
INSERT INTO krj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ukon, kon mangayo tana kang itlog, tugroan bala ninyo tana ka iwi-iwi? ");
INSERT INTO krj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kon kamo gani nga mga malaot kamaan magtugro kang mayad nga mga butang sa inyo mga kabataan, sobra pa gid ang inyo Amay sa langit, itugro na ang Balaan nga Ispirito sa mga nagapangayo ka dya kana.” ");
INSERT INTO krj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sangka bes, ginatabog ni Jesus ang demonyo nga nagpaapa sa sangka tawo. Pagkagwa na ka dya, ang tawo nga to makahambal run. Kag ang mga tawo rugto daw indi makapati sa anda nga nakita. ");
INSERT INTO krj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero ang iba tana nga mga tawo nagkuon, “Nagatabog tana ka dya kang mga demonyo paagi sa gahum ni Beelzebul nga amo ang pangulo kang mga demonyo.” ");
INSERT INTO krj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ang iba tana nga mga tawo rugto gusto nanda itirawan si Jesus, gani ginkun-an nanda tana nga maghimo kang milagro sa pagpamatuod nga tana ginpadara kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero naman-an ni Jesus ang anda mga ginapinsar gani nagkuon tana kananda, “Kon ang sangka ginharian magbinahin-bahin kag mag-irinaway, dya nga ginharian indi magbuhay kag mapukan. Kag kon ang sangka panimalay magbinahin-bahin man, magaburublag man sanda ka dya. ");
INSERT INTO krj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gani kon ang mga sinakpan ni Satanas magbihanin-bahin, indi magbuhay kag mapukan ang anang ginharian. Nagakuon kamo nga nagapanabog ako kang mga demonyo paagi sa gahum ni Beelzebul. ");
INSERT INTO krj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kon nagapanabog ako kang mga demonyo paagi sa anang gahum, sin-o tana ang nagtugro kang gahum sa inyo mga sumuronod nga magpanabog kang mga demonyo? Sanda gid tana mismo ang magapamatuod nga sayup kamo! ");
INSERT INTO krj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero kon paagi sa gahum kang Dios nagapanabog ako kang mga demonyo, dya nagapamatuod nga ang paghari kang Dios nag-abot run kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kon ang mapurus nga tawo kumpleto ang anang armas sa pagbantay kang anang balay, marayu sa katalagman ang anang pagkabutang. ");
INSERT INTO krj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero kon salakayun tana kag pyerdehun kang tawo nga mas mapurus sangsa kana, pagabul-un kana ang anang armas nga ginasarigan kag ipanagtag ang mga pagkabutang nga gin-agaw kana.” ");
INSERT INTO krj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ang wara nagadampig kanakun kontra kanakun, kag ang wara nagabulig kanakun sa pagpanipon, nagaparapta lang.” ");
INSERT INTO krj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kon ang malaot nga ispirito maggwa sa tawo, nagalagaw-lagaw dya sa mara nga lugar sa pagpangita kang ana mapahuwayan. Kar-on, kon wara tana ti makita, makuon tana sa ana kaugalingun, ‘Mabalik run lang ako sa balay nga akun ginaistaran anay.’ ");
INSERT INTO krj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sa ana nga pagbalik makita na dya nga limpyo kag hipid. ");
INSERT INTO krj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gani, mapanaw tana kag magdara pa gid kang pito ka mga ispirito nga mas malaot pa sangsa kana. Magasulud sanda kag magaistar rugto. Gani ang kahimtangan kang tawo nga dya mas sobra pa gid sangsa kauna.” ");
INSERT INTO krj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Samtang nagahambal pa si Jesus, may sangka bayi sa tunga kang karak-an nga naghambal sa matunog nga limug, nga nagakuon, “Daw ano ka bulahan ang bayi nga nagbata kag nagbatiti kanimo!” ");
INSERT INTO krj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero nagsabat si Jesus, “Huud, pero bulahan pa gid ang nagapamati kang pulong kang Dios kag nagatuman kadya!” ");
INSERT INTO krj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kang nagaduro run ang mga tawo, nagkuon si Jesus, “Ang mga tawo sa kadya nga panag-on tama gid ka malaot. Nagapangayo sanda nga pakitaan kang milagro, pero wara ti igapakita kananda magluwas lang sa makatiringala nga natabo kay Jonas kauna. ");
INSERT INTO krj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tungud nga ang natabo kauna kay Jonas nangin paratandaan sa mga taga-Ninive, sa amo man ang Anak kang Tawo mangin paratandaan sa mga tawo sa kadya nga mga panag-on. ");
INSERT INTO krj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sa adlaw kang paghukum, ang reyna kang Seba magatindug sa pag-akusar sa mga tawo sa kadya nga panag-on. Tungud hay tana gani nga naghalin pa sa marayu nga lugar, nag-agto sa pagpamati sa ginapanudlo kang maaram nga si Solomon. Kadya tana, kaimaw run gid ninyo ang labaw pa sangsa kay Solomon. ");
INSERT INTO krj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sa adlaw kang paghukum, ang mga taga-Ninive magatindug sa pag-akusar kaninyo, tungud hay kato anay kang mabatian nanda ang mga ginpangwali ni Jonas, naghinulsul sanda sa anda mga kasal-anan. Kadya tana, kaimaw run gid ninyo ang labaw pa sangsa kay Jonas.” ");
INSERT INTO krj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Wara ti may nagasindi kang sulo kag dayon tagoon ukon takluban lang man dya. Kundi nga ginabutang na dya sa turungtongan agud to nga ang mga nagasulud sa balay masanagan. ");
INSERT INTO krj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ang imong mata amo ang sulo kang imong lawas. Gani kon masanag ang imong panuruk masanagan man ang bug-os nimo nga lawas. Pero kon dulum ang imong panuruk, madulman man ang imong bug-os nga lawas. ");
INSERT INTO krj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gani siguroha ninyo nga ang kasanag nga rugyan kaninyo bukun ti kadulum. ");
INSERT INTO krj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gani nga kon ang bug-os nimo nga lawas napuno kang kasanag kag wara gid ti kadulum, masanagan gid dya kang bug-os, daw pareho lang nga ginaiwagan ikaw kang kasanag kang sulo.” ");
INSERT INTO krj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapos hambal ni Jesus, may sangka Fariseo nga nag-agda kana nga magkaun sa anang balay. Nagtawas man si Jesus para magkaun rugto. ");
INSERT INTO krj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Natingala ang Fariseo kang makita na nga wara nanghugas si Jesus kang anang alima antes magkaun. ");
INSERT INTO krj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dayon nagkuon ang Ginoo kana, “Kamo tinyo nga mga Fariseo, ginahugasan ninyo ang sagwa kang inyo tasa kag likod kang pinggan pero ang sa sulud ninyo buta kang pagpamintaha kang kalainan. ");
INSERT INTO krj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga buang kamo! Ang Dios kabay nga amo ang naghimo kang lawas amo man ang naghimo kang panghuna-huna? ");
INSERT INTO krj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pero magtugro kamo sa mga imol halin sa inyo baratyagun, kag ang tanan nga mga butang mangin limpyo para kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makaluluoy gid kamo nga mga Fariseo! Ginatugro ninyo ang inyong ikanapulo nga bahin kang mga laswa, pareho kang herbabuena kag ruda kag iba pa gid nga mga laswa, pero wara ninyo ginataw-an kang kabilyanan ang pagkabig sa mga tawo nga wara ti ginapasulabi kag ang paghigugma sa Dios. Daad ginahimo ninyo dya nga wara man ninyo ginapatumbayaan ang iba nga mga bagay. ");
INSERT INTO krj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makaluluoy kamo nga mga Fariseo! Gusto gid ninyo nga magpungko sa mga importante nga purongkoan sa sinagoga kag gusto man ninyo nga tahudon kamo sa mga tindahan. ");
INSERT INTO krj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Makaluluoy gid kamo! Pareho kamo kang mga rulubngan nga wara ti tanda nga ginalapak-lapakan lang kang mga tawo, tungud nga wara sanda kamaan.” ");
INSERT INTO krj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kar-on, ang isara sa mga manunudlo kang Kasugoan rugto nagkuon kana, “Maestro sa ginapanghambal nimo nga ria, ginainsultohan mo man kami!” ");
INSERT INTO krj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nagsabat si Jesus, “Makaluluoy man kamo nga mga manunudlo kang Kasugoan! Ginatugroan ninyo ang mga tawo kang mga mabudlay nga turumanun kag ipapas-an kananda, pero kamo mismo wara nagabulig bisan gamay lang para nga masarangan dya idar-un kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Makaluluoy gid kamo, tungud hay ginapahimoan ninyo kang rulubngan ang mga propeta nga ginpamatay kang inyo mga kaulangan! ");
INSERT INTO krj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sa ginhimo ninyo nga ria, nagapamatuod lang nga nagapasugot kamo sa mga hinimoan kang inyo mga kaulangan; sanda ang nagpamatay kang mga propeta, kag kamo tana amo ang nagpahimo kang andang mga rulubngan. ");
INSERT INTO krj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tungud karia, ang Dios sa anang kaaram nagkuon, ‘Magapadara ako kananda kang mga propeta kag mga apostoles, nga ang iba pagapatyun nanda kag ang iba pagahingaboton nanda!’ ");
INSERT INTO krj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gani, ang mga tawo sa kadya nga panag-on amo ang magapanabat sa kamatayun kang tanan nga mga propeta nga ginpamatay katong una, halin pa kang pagtuga kang kalibutan ");
INSERT INTO krj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","umpisa sa kamatayun ni Abel hasta sa kay Zacarias nga ginpatay sa tunga kang altar kag kang Templo. Ginakuon ko kaninyo, nga ang mga tawo sa kadya nga panag-on amo ang magapanabat sa tanan nga dya. ");
INSERT INTO krj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Makaluluoy kamo nga mga manunudlo kang Kasugoan! Ginabalabagan ninyo ang mga tawo sa paghangup kang kamatuoran. Indi run nga daan kamo magsunod sa kamatuoran, ginabalabagan pa ninyo ang iba nga gusto magsunod.” ");
INSERT INTO krj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagkahalin ni Jesus rugto kato, ang manunudlo kang Kasugoan kag ang mga Fariseo nag-umpisa ka ugut kang sobra gid kana, kag ginapamangkot nanda tana kang duro nga mga butang, ");
INSERT INTO krj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sa tuyo nga dakpun tana sa anang mga ginapanghambal. ");
INSERT INTO krj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kar-on, samtang nagadinus-uganay ang linibo nga mga tawo hasta nga nagalinapakay run sanda, nagkuon anay si Jesus sa anang mga disipulo, “Mag-andam kamo sa tapay kang mga Fariseo, nga amo ang pagkahipokrito. ");
INSERT INTO krj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tungud hay wara ti tinago nga indi mapahayag, kag wara ti sekreto nga indi maman-an sa urihi. ");
INSERT INTO krj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gani, kon ano ang ginhambal ninyo sa dulum, mabatian sa adlawun, kag kon ano ang ginahani-hani ninyo sa sarado nga hulut igapahayag sa mga katawhan.” ");
INSERT INTO krj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Sugidan ko kamo, mga amigo, indi kamo magkahadluk sa mga nagapatay kang lawas, pero pagkatapos karia wara run sanda ti sarang mahimo. ");
INSERT INTO krj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ipamaan ko kaninyo kon sin-o ang inyo dapat kahadlukan: kahadluki ninyo ang Dios, nga sa tapos mapatay na ang lawas, may gahum pa tana sa pagtagbung kang kalag sa impyerno. Ginakun-an ko kamo, kahadluki ninyo tana. ");
INSERT INTO krj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Indi bala nga ang lima ka bilog nga pispis nga maya mabakal sa darwa ka pesetas? Pero bisan amo pa karia, bisan isara kananda wara gid ginapabay-an kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bisan ang inyo buhok naman-an na kon pira ka bilog. Gani indi kamo magkahadluk. Mas marahalun pa kamo sangsa duro nga mga maya?” ");
INSERT INTO krj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Sugidan ko kamo, ang sin-o man nga nagasugid nga tana nagatoo kanakun sa atubang kang mga katawhan, pagakilalahun man tana kang Anak kang Tawo sa atubang kang mga anghel kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero ang sin-o man nga nagapanginwara kanakun sa atubang kang mga katawhan, ipanginwara man tana sa atubang kang mga anghel kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ang bisan sin-o nga maghambal kang malain kontra sa Anak kang Tawo, sarang pa mapatawad. Pero ang sin-o man nga magpasipala sa Balaan nga Ispirito indi run gid mapatawad. ");
INSERT INTO krj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kon dar-un nanda gani kamo sa mga sinagoga, ukon sa mga manugdumara kag sa mga may awtoridad, indi kamo magpalibug kon paano ukon ano ang inyo isabat, ukon ano ang inyo ihambal, ");
INSERT INTO krj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tungud hay ang Balaan nga Ispirito amo ang magatudlo kaninyo sa amo gid to nga tion kon ano ang inyo dapat ihambal.” ");
INSERT INTO krj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Halin sa karak-an may sangka tawo nga nagkuon kay Jesus, “Maestro, hambali ang akun bugto nga laki nga ihurayan na man ako kang amun paranubliun!” ");
INSERT INTO krj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nagsabat si Jesus, “Amigo, sin-o ang nagkuon nga ako ang mapatunga kaninyo nga darwa ukon maghuray kang inyo pagkabutang?” ");
INSERT INTO krj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kag nagkuon si Jesus kananda tanan, “Mag-andam kamo nga indi kamo magdinalok sa bisan ano nga butang sa kalibutan. Tungud hay ang kabuhi kang tawo wara nasandig sa kadurohon kang manggad nga ana naangkun.” ");
INSERT INTO krj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dayon nagsugid si Jesus kang dya nga paraanggidan: “May sangka manggaranun nga ang anang lupa nagpatubas kang bugana. ");
INSERT INTO krj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kag nagkuon tana sa anang kaugalingun, ‘Ano ang himoon ko hay wara run ako ti mabutangan kang akun patubas?’ ");
INSERT INTO krj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dayon nagkuon tana, ‘A, amo gali dya ang akun himoon: igub-un ko ang akun mga kamarin, kag dayon mapatindug ako kang mas daragkul pa gid kag rugto ko ipamutang ang tanan nakun nga mga patubas kag iba pa nakun nga mga pagkabutang! ");
INSERT INTO krj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dayon makuon ako sa akun kaugalingun, duro run nga mga butang ang imong natipon para sa mga tinuig nga magaabot. Kar-on, mapatawhay run lang ikaw kag magpagusto kaun, inum, kag magpangalipay!’ ");
INSERT INTO krj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero nagkuon ang Dios kana, ‘Buang-buang! Kadya gid nga gabii bawian ikaw kang kabuhi! Kag sin-o kar-on ang mapulos kang mga butang nga imo gintigana para sa imo kaugalingun?’” ");
INSERT INTO krj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gintapos ni Jesus ang paraanggidan nga nagakuon, “Amo dya ang matabo sa tawo nga nagatipon kang manggad para sa anang kaugalingun, pero imol man sa panuruk kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dayon nagkuon si Jesus sa anang mga disipulo, “Gani, nagakuon ako kaninyo, indi kamo magsagad palibug sa inyo pagpangabuhi, kon ano ang inyo kan-un, ukon ano ang inyo isuksok para sa inyo lawas. ");
INSERT INTO krj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tungud hay ang kabuhi mas importante pa sangsa pagkaun, kag ang lawas mas importante pa sangsa panaptun. ");
INSERT INTO krj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Turuka lang bala ninyo ang mga uwak, wara sanda nagatanum ukon nagaani, wara man sanda ti kamalig ukon mga kamarin pero ginapakaun sanda kang Dios. Indi bala nga mas importante pa kamo sangsa mga pispis? ");
INSERT INTO krj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wara gid ti bisan sin-o kaninyo nga makadugang kang anang kabuhi paagi sa anang pagpalibug. ");
INSERT INTO krj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Indi gani ninyo masarangan himoon ang mga gamay nga mga butang nga ria, andut nga ginapaligban pa tana ninyo ang iba nga mga butang? ");
INSERT INTO krj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Turuka bala ninyo kon paano nagatubo ang mga bulak sa latagun. Wara sanda nagaobra ukon nagahimo kang andang bayo. Pero sugidan ko kamo nga bisan pa si Solomon, sa anang pagkatam-an ka manggaranun, wara gid makabayo kang pareho kang katahum kang bisan isara sa mga bulak nga dya. ");
INSERT INTO krj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kon ginapatahum kang Dios ang mga hilamon nga rugyan sa latagun nga buhi kadya, kag sa masunod nga adlaw idap-ong lang man sa darapogan, kamo pa ayhan ang indi na pagpabayoan? Mga gamay kamo ti pagtoo! ");
INSERT INTO krj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Gani, indi kamo magsagad palibug kon ano ang inyo ikan-un kag kon ano ang inyo imnun. ");
INSERT INTO krj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tungud hay amo gid lang dya ang ginapaligban kang mga tawo nga wara makakilala sa Dios. Pero kamo tinyo, naman-an gid kang inyo Amay nga kinahanglan ninyo ang dya nga mga butang. ");
INSERT INTO krj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ang himoon ninyo, magpasakup kamo sa pagginahum kang Dios, kag ang tanan nga mga butang nga dya itugro na kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Indi kamo magkahadluk bisan pira lang kamo ka bilog. Tungud hay nahamuut ang inyo Amay nga maghari kamo imaw kana. ");
INSERT INTO krj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ang himoon ninyo, ibaligya ninyo ang inyo mga pagkabutang kag ang bayad na ka dya ipanugro ninyo sa mga imol. Maghimo kamo kang puyo-puyo nga wara nagakadaan, kag suptun ninyo ang inyo manggad rugto sa langit nga sa diin indi mabuhinan tungud hay wara ti takawan nga makaparapit ukon tanak nga makarangga ka dya. ");
INSERT INTO krj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tungud hay kon sa diin ang inyo manggad rugto man ang inyo panghuna-huna.” ");
INSERT INTO krj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Maghanda kamo kag sindihan ninyo ang inyo mga sulo, ");
INSERT INTO krj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","pareho kang mga tawo nga nagahulat sa andang agalun nga mag-uli halin sa tabad kang kasal, agud to nga handa lagi sanda sa pagbukas kang pwertahan kon mag-abot run tana kag manuktok. ");
INSERT INTO krj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bulahan ang mga surugoon nga maabotan kang andang agalun nga nakabugtaw kag handa. Sugidan ko kamo, magaaman ang agalun nga dya kag magasirbe kananda kang pagkaun sa lamesa. ");
INSERT INTO krj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bulahan ang mga surugoon nga maabotan kang anda agalun nga handa sanda bisan mag-uli pa tana kang tunga gabii ukon kasanagun. ");
INSERT INTO krj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandai ninyo dyaay: kon naman-an kang tagbalay, kon ano oras maabot ang takawan, magabantay gid tana agud to nga indi makasulud ang takawan sa anang balay. ");
INSERT INTO krj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kamo man kinahanglan nga maghanda, tungud hay ang Anak kang Tawo magaabot sa oras nga wara ninyo ginapaabot.” ");
INSERT INTO krj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Naghambal si Pedro, “Ginoo, para lang bala kanamun ang dya nga paraanggidan, ukon para man sa tanan?” ");
INSERT INTO krj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nagsabat ang Ginoo, “Sin-o bala ang masarigan kag maaram nga surugoon? Indi bala tana ang ginatugyanan kang anang agalun sa pagdumara kang anang panimalay kag sa pagpanagtag kang pagkaun sa iba nga mga surugoon sa nagakaigo nga tion? ");
INSERT INTO krj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bulahan ang surugoon nga ria kon pag-abot kang anang agalun masapwan tana nga nagahimo kang hirikoton nga gintugyan kana. ");
INSERT INTO krj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sugidan ko kamo, ipadumara kana kang anang agalun ang tanan na ka dya nga mga pagkabutang. ");
INSERT INTO krj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero kon ang surugoon nga ria magkuon sa anang kaugalingun nga, ‘Buhay pa man magbalik ang akun agalun,’ kag pamintasan na ang iba nga mga surugoon nga laki kag bayi, kag magsagi run tana ka kaun, inum, kag palingin. ");
INSERT INTO krj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dayon, magaabot ang anang agalun sa adlaw nga wara na ginapaabot kag sa oras nga wara na maman-an. Ang himoon kang anang agalun, pagasilotan gid tana ka mayad kag idapun sa mga indi masarigan. ");
INSERT INTO krj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ang surugoon tana nga nakamaan kon ano ang luyag kang anang agalun pero wara maghanda ukon maghimo ka dya, pagahanoton gid tana ka mayad. ");
INSERT INTO krj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ang surugoon tana nga wara nakamaan kang luyag kang anang agalun kag naghimo kang butang nga nagakadapat tana nga hanoton, magabaton kang pira lang ka hanot. Tungud hay ang tawo tana nga gintugyanan kang duro nga mga butang, duro man ang ginapaabot nga himoon na. Kag ang tawo tana nga mas duro pa gid ang gintugyan kana, mas duro man ang ginapaabot kana.” ");
INSERT INTO krj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nag-agto ako rugya sa kalibutan sa pagdara kang kalayo, kag daad nagasadlab run dya! ");
INSERT INTO krj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","May arantoson ako nga pagaagumun, kag indi gid ako mapahamtang hasta nga wara pa dya matabo. ");
INSERT INTO krj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Indi kamo magpinsar nga nag-abot ako rugya sa kalibutan agud magdara kang kalinung. Sugidan ko kamo, bukun ti kalinung ang akun ginadara kundi pagbinahin-bahin. ");
INSERT INTO krj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Umpisa kadya ang panimalay nga may lima ka bilog nga katapo magabinahin-bahin: ang tatlo batok sa darwa, kag ang darwa batok sa tatlo. ");
INSERT INTO krj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ang tatay mangin kaaway kang anang bata nga laki, kag ang bata nga laki mangin kaaway kang anang tatay. Ang nanay mangin kaaway kang anang bata nga bayi, kag ang bata nga bayi mangin kaaway sa ana nanay. Ang ugangan nga bayi mangin kaaway kang anang umagad nga bayi, kag ang umagad nga bayi mangin kaaway kang anang ugangan nga bayi.” ");
INSERT INTO krj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nagkuon si Jesus sa mga katawhan, “Kon makita gani ninyo ang damul nga gal-um sa kasalpan, makuon dayon kamo, ‘Magauran tulad’ kag nagauran man. ");
INSERT INTO krj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kon mabatyagan gani ninyo nga maghuyup ang hangin nga habagat, makuon kamo, ‘Magasingkal kadya ang init,’ kag amo gid man ang nagakatabo. ");
INSERT INTO krj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mga hipokrito! Kamaan kamo maglatu kang tyempo pinaagi sa pagturuk kang langit kag lupa, pero andut haw nga indi kamo kamaan kang buut hambalun kang nagakaratabo sa kadya nga mga panag-on?” ");
INSERT INTO krj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Andut bala nga indi kamo makamaan magdesisyon kon ano ang mayad? ");
INSERT INTO krj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kon may tawo nga mag-akusar kanimo sa hukmanan, himoa gid ang tanan nga magpakighusay kana sa wara pa kamo makaabot rugto. Tungud hay basi itugyan na ikaw sa huwis kag itugyan ikaw kang huwis sa gwardya kag isulud ikaw sa prisohan. ");
INSERT INTO krj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sugidan ko ikaw, indi gid ikaw makagwa sa prisohan hasta nga maubos mo ka bayad ang tanan nimo nga pina.” ");
INSERT INTO krj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sa amo man to nga mga tinion, may mga tawo nga nag-aragto kay Jesus kag nagsugid kana nahanungud sa mga taga-Galilea nga ginpapatay ni Pilato samtang nagahalad sanda kang mga sapat nga haralad sa Dios. ");
INSERT INTO krj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nagsabat si Jesus kananda, “Abi bala ninyo nga ang mga taga-Galilea nga dya mas makasasala sangsa iba nga mga taga-Galilea tungud hay amo to ang natabo kananda? ");
INSERT INTO krj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sugidan ko kamo, bukun ti amo karia, kon indi kamo maghirinulsul kang inyo mga sala, tanan kamo magakaramatay man pareho kananda. ");
INSERT INTO krj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pareho man anay ria kang napulo'g walo ka mga tawo sa Siloe nga nagkaramatay katong matumbahan sanda kang tore. Abi ninyo natabo to kananda hay sobra gid sanda ka makasasala sangsa iba nga mga taga-Jerusalem? ");
INSERT INTO krj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sugidan ko kamo, bukun ti amo karia, kon indi kamo maghirinulsul kang inyo mga sala magakaramatay man kamo pareho kananda.” ");
INSERT INTO krj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dayon nag-istorya si Jesus kananda kang dya nga paraanggidan: “May sangka tawo nga may tanum nga higera sa anang urubasan. Sangka bes, gin-agtonan na kag ginbisitahan dya nga higera kon may bunga, pero wara gid tana ti nakita. ");
INSERT INTO krj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gani nagkuon tana sa hardinero, ‘Sulnga bala, ikatlo run nakun ka tuig dya nga balik-balik rugya nga nagasulung kon may bunga ang dya nga higera, pero wara gid ako ti nakita. Pukana run lang gani dya! Kanugon lang ang lupa nga ginasagad na ka usar!’ ");
INSERT INTO krj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero nagsabat ang hardinero, ‘Agalun, pabay-i lang anay kadya nga tuig, hay kutkoton ko ang anang palibot kag ibutangan kang abuno. ");
INSERT INTO krj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kon mamunga gani dya sa sunod nga tuig, ti kundi nga mayad. Pero kon indi gani mamunga, amo run to ang pagpukan ta!’” ");
INSERT INTO krj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sangka Adlaw nga Inugpahuway, nagapanudlo si Jesus sa sinagoga. ");
INSERT INTO krj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","May sangka bayi rugto nga buhay run nga ginagamhan kang malaot nga ispirito, nga amo ang nagpabalatian kana sa sulud kang napulo'g walo ka tuig. Buktot tana kag indi na gid matadlung ang anang lawas. ");
INSERT INTO krj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kang makita tana ni Jesus, gintawag na dya nga magparapit kana, kag ginkun-an, “Inday, hilway run ikaw sa imong balatian!” ");
INSERT INTO krj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dayon gintungtong ni Jesus ang anang alima sa bayi kag lagi-lagi nagtadlung ang anang lawas, kag gindayaw na ang Dios. ");
INSERT INTO krj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ang pangulo tana kang sinagoga nag-ugut tungud nga nagpang-ayad si Jesus sa Adlaw nga Inugpahuway. Gani naghambal tana sa mga tawo, “Sa sangka semana may anum ka adlaw nga makaobra kita; sa amo ria nga mga adlaw kamo mag-agto rugya sa pagpabulong, bukun ti sa Adlaw nga Inugpahuway!” ");
INSERT INTO krj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero ginsabat tana kang Ginoo, “Mga hipokrito kamo! Bisan sin-o kabay kaninyo ginabuy-an ninyo sa turil ang inyo mga baka ukon mga asno sa Adlaw nga Inugpahuway kag dar-un sanda sa irimnan? ");
INSERT INTO krj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","May sangka bayi rugya nga kaliwat ni Abraham nga sa sulud run kang napulo'g walo ka tuig nga ginagapos ni Satanas. Indi bala nagakadapat lang nga hilwayun tana sa gahum ni Satanas bisan sa Adlaw nga Inugpahuway?” ");
INSERT INTO krj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sa ginhambal nga dya ni Jesus, ang mga nagakontra kana nahuy-an gid, kag ang mga tawo tana nagkinalipay tungud sa tanan na nga mga makatiringala nga hinimoan. ");
INSERT INTO krj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dayon nagpamangkot si Jesus, “Ano ang kaangay kang Ginharian kang Dios? Sa ano natun dya mapaanggid? ");
INSERT INTO krj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Daw pareho dya kang liso kang mustasa nga ginpanggas kang tawo sa anang uma, kag nagtubo dya kag nagbahul hasta nga nangin kahoy, kag ang mga pispis namugad sa anang mga sanga.” ");
INSERT INTO krj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nag-istorya ruman si Jesus, “Sa diin ko mapaanggid ang Ginharian kang Dios? ");
INSERT INTO krj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pareho dya kang tapay nga ginsamo kang sangka bayi sa tatlo ka sukub nga harina hasta nga ang bug-os nga ginmasa nga harina maghabok.” ");
INSERT INTO krj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Samtang nagapaagto si Jesus sa syudad kang Jerusalem, nagapanudlo tana sa mga kabaryohanan kag kabanwahanan nga anang maagyan. ");
INSERT INTO krj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","May sangka tawo nga nagpamangkot kana, “Ginoo, gamay lang ayhan nga mga tawo ang maluwas?” Nagkuon si Jesus kananda, ");
INSERT INTO krj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tinguhai gid ninyo nga makasulud sa masipot nga pwertahan. Tungud hay sugidan ko kamo, duro nga mga tawo ang magatinguha sa pagsulud pero indi sanda makasulud. ");
INSERT INTO krj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tungud hay sa tion nga ang tagbalay magtindug kag magpanirado kang pwertahan, kamo tinyo rugto lang sa gwa magapanuktok kag magakuon, ‘Sir, pasudla man kami!’ Magasabat tana kaninyo, ‘Wara takun kamaan kon taga-diin tinyo!’ ");
INSERT INTO krj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kag magasabat man kamo, ‘Irimaw anay kita kato nga nagakaun kag nagainum, kag nagpanudlo pa gani ikaw sa amun banwa.’ ");
INSERT INTO krj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero magasabat ruman tana kaninyo, ‘Wara gid takun kamaan kon taga-diin tinyo. Haralin kamo rugya, kamo nga ang inyo ginahimo puro kalaotan!’ ");
INSERT INTO krj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Magaparanangisun kamo kag magabinagrut ang inyong mga unto, kon makita ninyo sanday Abraham, Isaac, Jacob, kag ang tanan nga mga propeta rugto sa ginharian kang Dios, kag kamo tinyo wara ginpasulud. ");
INSERT INTO krj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","May mga tawo man rugto nga magaharalin sa tanan nga bahin kang kalibutan, kag magapungko sanda sa pagkaun sa tabad rugto sa ginharian kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dumduma ninyo dya, ang mga tawo nga kubus sa tulad mangin dungganun sa urihi, kag ang mga dungganun sa tulad mangin kubus sa urihi.” ");
INSERT INTO krj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa amo gid to nga tion, may mga Fariseo nga nagparapit kay Jesus kag nagkuon, “Kinahanglan nga maghalin gid ikaw rugya kag mag-agto sa iba nga lugar tungud hay gusto ikaw patyun ni Herodes.” ");
INSERT INTO krj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero nagsabat si Jesus kananda, “Panaw kamo kag hambalan ninyo ang singgarong nga ria, ‘Padayon ako nga magapanabog kang mga demonyo kag magapamulong kang mga masakitun hasta sa adlaw nga matapos ko ang akun hirikoton. ");
INSERT INTO krj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero kinahanglan gid nga padayonon ko ang akun nga pagpanaw hasta nga makadangat ako sa Jerusalem, tungud hay bukun ti angay nga ang sangka propeta mapatay sa iba nga lugar kundi nga sa Jerusalem gid.’ ");
INSERT INTO krj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kamo nga mga taga-Jerusalem ginapamatay ninyo ang mga propeta kag ginapangbato ninyo ang mga ginpadara kang Dios kaninyo. Makapira ka beses nga ginhandum ko nga tiponon kamo kag atipanun pareho kang munga nga nagatipon kang anang mga pisu sa idalum kang anang pakpak, pero indi kamo gusto! ");
INSERT INTO krj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gani kar-on, ginpatumbayaan run kang Dios ang inyo templo. Kag sugidan ko kamo, nga indi run gid ninyo ako makita liwan hasta nga mag-abot ang adlaw nga magakuon kamo, ‘Pakamayadun ang nagaabot nga ginpadara kang Ginoo.’” ");
INSERT INTO krj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sangka Adlaw nga Inugpahuway, nag-agto si Jesus para magkaun sa balay kang sangka pangulo kang mga Fariseo. Kang rugto run tana, ginpanilagan gid tana ka mayad kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","May sangka tawo rugto nga nagparapit kay Jesus nga nagaparamanug ang anang batiis kag mga butkun. ");
INSERT INTO krj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nagkuon si Jesus sa mga manunudlo kang Kasugoan kag sa mga Fariseo, “Ginatugot bala kang atun Kasugoan nga magpang-ayad sa Adlaw nga Inugpahuway ukon wara?” ");
INSERT INTO krj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero naghipus lang sanda. Dayon ginkaptan ni Jesus ang tawo, gin-ayad na dya kag ginkun-an nga mag-uli. ");
INSERT INTO krj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dayon nagkuon si Jesus kananda, “Abi, kon may rugyan kaninyo nga ang anang bata ukon baka nahulog sa bubon sa Adlaw nga Inugpahuway, indi ninyo ayhan dya pagbul-un lagi bisan Adlaw pa nga Inugpahuway?” ");
INSERT INTO krj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero wara angud sanda makasabat ka dya. ");
INSERT INTO krj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kar-on, nasat-uman ni Jesus nga ginapili kang mga inagda ang mga purungkoan nga gintigana para sa dungganun lang nga mga tawo. Gani nag-istorya tana kananda kang paraanggidan nga dya: ");
INSERT INTO krj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pananglitan nga gin-agda ikaw sa sangka tabad kang kasal, indi pagpilia ang purungkoan nga gintigana para sa mga dungganun nga mga tawo. Tungud hay basi kon may gin-agda man sanda nga mas dungganun pa sangsa kanimo, ");
INSERT INTO krj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kag ang nag-agda nga to kaninyo nga darwa magaparapit kanimo kag magakuon, ‘Abi, itugro anay kana ang purungkoan nga dya.’ Ti, kundi nga mahuy-an ikaw kag mapiritan nga magpungko run lang sa pinakakubus nga purungkoan. ");
INSERT INTO krj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gani nga kon agdahun ikaw, piliun mo ang purungkoan nga gin-aman sa labing kubus, agud to nga sa pag-abot kang nag-agda kanimo magakuon tana kanimo, ‘Amigo, rugto ikaw pungko imaw kang mga dungganun!’ Ti, kundi nga mapadunggan pa ikaw sa atubang kang tanan nga mga gin-agda. ");
INSERT INTO krj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tungud nga ang bisan sin-o nga nagapataas kang anang kaugalingun pagapakanabaun, kag ang nagapaubus tana kang anang kaugalingun pagabayawun.” ");
INSERT INTO krj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dayon nagkuon si Jesus sa tawo nga nag-agda kana, “Kon magpaigma gani ikaw, ukon magpayapon, indi mo pag-agdahun ang imo mga amigo, kabugtoan, mga himata ukon mga kaingud nga manggaranun. Tungud hay basi agdahun man nanda ikaw kag mabaslan ikaw sa imong ginhimo. ");
INSERT INTO krj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero kon magpatabad gid man ikaw, ang agdahun nimo amo ang mga imol, mga pingkaw, mga piang, kag ang mga bulag, ");
INSERT INTO krj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kag pakamayadun ikaw tungud hay indi sanda ka dya makabalus kanimo. Sa baylo, ang Dios amo ang magabalus kanimo sa tion nga banhawun ang mga matarung.” ");
INSERT INTO krj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ang isara sa mga tawo nga nagakaun sa lamesa imaw ni Jesus nakabati ka dya kag nagkuon, “Bulahan ang tawo nga makakaun sa tabad sa ginharian kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero nagkuon si Jesus kana, “May sangka tawo nga naghanda kang sangka bahul nga tabad, kag duro ang anang ginpang-agda. ");
INSERT INTO krj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kang tagkaraun run, ginsugo na ang ana surugoon nga kun-an ang mga gin-agda nga mag-agto run tungud hay handa run ang tanan. ");
INSERT INTO krj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero ang kada isara kananda mansig pamaribad. Ang isara nagkuon sa surugoon, ‘Nakataba ako kang lupa. Kinahanglan agtonan ko anay kag turukun dya, gani kon mahimo pasensyaha anay ako.’ ");
INSERT INTO krj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kag ang isara ruman tana nagkuon, ‘Nakabakal ako kang napulo ka baka nga inug-arado, kag agtonan ko gani to kag itirawan. Kon mahimo pasensyaha anay ako.’ ");
INSERT INTO krj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kag ang isara pa gid tana nagkuon, ‘Bag-o lang ako makasal, gani indi ako makaagto.’ ");
INSERT INTO krj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nag-uli run lang ang surugoon kag ginsugid na sa anang amo ang tanan nga andang ginkuon. Nag-ugut ang amo kag nagkuon sa anang surugoon, ‘Agto ikaw sa mga karsada, kag mga aragyan kang banwa kag dar-a rugya nga mga imol, mga pingkaw, mga bulag, kag ang mga piang.’ ");
INSERT INTO krj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pagkatapos nga mahimo dya kang surugoon, nagbalik tana sa anang amo, kag nagkuon, ‘Agalun, natuman run ang imo sugo, pero duro pa gihapon ang lugar sa karan-an.’ ");
INSERT INTO krj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kag nagkuon ang agalun sa surugoon, ‘Agto pa gid ikaw sa mga karsada kag mga dalanun sa gwa kang banwa kag piritun mo ang mga tawo nga mag-agto rugya agud nga mabuta ang akun balay. ");
INSERT INTO krj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sugidan ko kamo, wara gid ti bisan isara sa mga ginpang-agda nga to ang makatiraw kang pagkaun sa tabad nga akun ginhanda!’” ");
INSERT INTO krj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kar-on, duro nga mga tawo ang nagtarawas kay Jesus, nagbalikid tana kag nagkuon kananda, ");
INSERT INTO krj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ang sin-o man nga nagahigugma sa anang tatay kag nanay, sa anang asawa kag mga kabataan, sa anang bugto nga laki kag bugto nga bayi, kag bisan sa anang kaugalingun, labaw pa sa anang paghigugma kanakun, indi takus nga mangin akun disipulo. ");
INSERT INTO krj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ang bisan sin-o nga indi magpas-an kang anang kaugalingun nga kros kag magsunod kanakun indi takus nga mangin akun sumuronod. ");
INSERT INTO krj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ang sin-o man kaninyo nga gusto magpatindug kang tore, indi bala nga nagapungko kamo anay kag nagabinag-binag kon bala makaigo ang inyo kwarta sa pagpatapos kadya? ");
INSERT INTO krj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tungud hay kon mapatindug ninyo ang pundasyon na ka dya pero indi ninyo mapatapos, ang tanan nga makakita ka dya magayaguta kaninyo, ");
INSERT INTO krj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nga nagakuon, ‘Ano tana ang tawo nga dya man! Nag-umpisa ka patindug nga wara na man mapatapos!’ ");
INSERT INTO krj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ukon pareho kang sangka hari nga may napulo ka libo ka mga suldado, magapungko anay tana sa pagbinag-binag kon makasarang tana sa pagpakigbato sa sangka hari nga nagasurong kana nga may darwa ka napulo ka libo ka mga suldado. ");
INSERT INTO krj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kon indi tana makasarang, samtang rayu pa ang anang kaaway nga hari, magasugo tana kang anang tinawo nga magapakighusay. ");
INSERT INTO krj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Amo man ria kaninyo, ang bisan sin-o kaninyo nga indi magtalikod sa tanan na nga ginaangkun indi takus nga mangin akun sumuronod.” ");
INSERT INTO krj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ang asin manami, pero kon madura run gani ang anang kapait, indi run gid dya mapapait liwan. ");
INSERT INTO krj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Indi run dya mapuslan bisan pa kang lupa ukon kang tinumpokan kang arabuno. Gani ginapilak run lang dya sa gwa. Kamo nga mga nagaparamati, intiendiha ninyo ka mayad ang inyo ginapamatian.” ");
INSERT INTO krj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kar-on, duro nga mga manugsukot kang buwis kag iba pa nga mga makasasala ang nag-aragto kay Jesus para mamati kana. ");
INSERT INTO krj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kang makita dya kang mga Fariseo kag mga manunudlo kang Kasugoan, nagkurumodon sanda nga nagakuon, “Dya nga tawo nagabaton kang mga makasasala kag nagakaun pa imaw kananda!” ");
INSERT INTO krj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gani gin-istoryahan sanda ni Jesus kang paraanggidan nga dya: ");
INSERT INTO krj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Abi, kon ang isara kaninyo may sangka gatos ka mga karnero, kag nadura ang isara ka dya kananda. Indi na ayhan pagbayaan ang kasyaman kag syam sa hararban kag sagapun ang isara nga nadura nga to hasta nga makita na? ");
INSERT INTO krj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kag kon makita na run gani dya, masadyahan gid tana nga magapas-an ka dya. ");
INSERT INTO krj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sa anang pag-uli, panawgun na ang anang mga amigo kag mga kaingud kag magakuon, ‘Magkalipay kamo imaw kanakun, tungud hay nakita ko run ang akun karnero nga nadura!’ ");
INSERT INTO krj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sugidan ko kamo, amo man ria sa langit, sobra gid ang andang kalipay rugto tungud sa sangka makasasala nga naghinulsul sangsa kasyaman kag syam nga matarung kag indi run kinahanglan nga maghinulsul.” ");
INSERT INTO krj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kag abi kon may sangka bayi nga may napulo ka sinsilyo kag nadura ang isara ka dya, indi tana ayhan magsindi kang sulo kag silhigan ang anang balay, kag sagapun gid ka mayad hasta nga makita na dya? ");
INSERT INTO krj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kag kon makita na run gani dya, ipanawgun na ang anang mga amiga kag mga kaingud kag magakuon, ‘Magkalipay kamo imaw kanakun tungud hay nakita ko run ang akun sinsilyo nga nadura.’ ");
INSERT INTO krj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sugidan ko kamo, magakinalipay ang mga anghel kang Dios tungud kang sangka makasasala nga nagahinulsul.” ");
INSERT INTO krj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nagpadayon pa gid si Jesus sa pag-istorya, “May sangka tawo nga may darwa ka bata nga laki. ");
INSERT INTO krj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ang libayun nagkuon sa anang tatay, ‘Tay, itao run kanakun ang akun huray sa paranubliun.’ Gani ginhuray kang tatay ang anang pagkabutang sa anang darwa ka bata. ");
INSERT INTO krj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Magpira ka adlaw, ginbaligya kang libayun ang anang huray kag magpanaw nga dara ang anang kwarta. Nag-agto tana sa marayu nga lugar kag rugto nagpatuyang tana kang anang kwarta sa wara ti pulos nga pagpangabuhi. ");
INSERT INTO krj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nasaid na gid ka gastos ang tanan, kag nag-abot man ang sobra nga gutum sa amo nga lugar, kag wara run gid ti nabilin kana. ");
INSERT INTO krj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Gani ang anang ginhimo, nagpamugon tana sa sangka tumanduk kang amo nga lugar kag ginsugo tana sa uma sa pagdamog kang mga baboy. ");
INSERT INTO krj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa sobra na nga kagutum, gusto na run nga ikan-un ang ginadamog sa mga baboy, pero wara gid ti nagtugro kana kang bisan ano nga makaun. ");
INSERT INTO krj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kang makamarasmas tana kang anang kahimtangan, nagkuon tana sa anang kaugalingun, ‘Ang tanan nga nagapamugon kay tatay may makaun kag nagasorobra pa. Akun tana rugya daw mapatay run ako sa kagutum! ");
INSERT INTO krj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mapanaw ako kag mag-uli kay tatay, kag amo dya ang akun ikuon kana, “Tay, nakasala ako sa Dios kag kanimo. ");
INSERT INTO krj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Indi run ako takus nga itawgun pa nga imong bata. Kabiga run lang ako nga isara sa imo mga mamumugon.”’ ");
INSERT INTO krj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dayon, nagtindug tana kag magpanaw pauli sa anang tatay. Samtang marayu pa tana, nalantawan run tana kang anang tatay, kag dinakup kang kangir-o ang tagipusoon kang anang tatay kag dayon na nga dalagan kag haksun ang anang bata kag harkan. ");
INSERT INTO krj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nagkuon ang bata, ‘Tay, nakasala ako sa Dios kag kanimo. Indi run ako takus nga itawgun pa nga imo bata.’ ");
INSERT INTO krj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero gintawag kang tatay ang anang mga surugoon kag ginkun-an, ‘Dalia ninyo, dar-a ninyo rugya ang bayo nga pinakanami sa tanan kag ipasuksok kana. Pasuksokan man tana kang singsing kag sandalyas. ");
INSERT INTO krj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dayon panaw kamo kag bul-un ang pinatambuk nga tinday kang baka kag ihawun. Mapatabad kita kag magsinadya, ");
INSERT INTO krj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tungud hay ang akun bata nga dya, laum ko patay run, gali hay buhi lang man. Nadura tana, pero tulad rugya run!’ Kag nag-umpisa sanda ka sinadya. ");
INSERT INTO krj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kar-on, ang magurang tana nga bata rugto sa uma. Kang nagapauli run tana kag nagahinamput sa balay, may nabatian tana nga sonata kag sinaot. ");
INSERT INTO krj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gani gintawag na ang isara sa mga surugoon kag ginpamangkot, ‘May ano rugyan haw?’ ");
INSERT INTO krj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nagsabat ang surugoon, ‘Ang imo libayun nag-uli kag ginpaihaw kang imong tatay ang pinatambuk nga tinday kang baka tungud hay nakauli ang imong libayun nga mayad man!’ ");
INSERT INTO krj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nag-ugut ang magurang nga bata kag indi run magsulud sa balay. Gani naggwa ang anang tatay kag gin-ulo-ulohan tana. ");
INSERT INTO krj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero nagsabat tana sa anang tatay, ‘Sulnga bala, sa sulud kang malawid nga mga tinuig nagpangalagad ako kanimo. Wara gid ako maglapas kang imo mga sugo. Pero wara gid ikaw ti gintugro kanakun bisan sangka tinday lang kang kanding agud nga magsinadya kami kang akun mga amigo! ");
INSERT INTO krj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero kang pagbalik kang bata mo nga ria nga nag-uyang lang kang imong pagkabutang sa malain nga klase kang mga bayi, ginpaihawan mo pa tana kang pinatambuk nga tinday kang baka!’ ");
INSERT INTO krj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nagsabat ang anang tatay, ‘Anak, ikaw tana kaimaw ko pirme rugya sa balay, kag ang tanan nga akun imo man. ");
INSERT INTO krj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nagakabagay lang nga magpatabad kita kag magsinadya tungud hay ang libayun mo nga dya nga laum natun patay run, buhi man gali; nadura tana, pero kadya rugya tana run!’” ");
INSERT INTO krj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nag-istorya si Jesus sa anang mga disipulo, “May sangka tawo nga manggaranun nga may surugoon nga amo ang nagadumara kang anang mga pagkabutang. May nakamuno sa manggaranun nga dya nga ginausikan lang ka anang manugdumara ang anang mga pagkabutang. ");
INSERT INTO krj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gani ginpatawag na ang manugdumara nga dya kag ginkun-an, ‘Ano dya ang akun nabatian nahanungud kanimo? Abi, taw-i ako kang lista kang imo pagdumara kang akun mga pagkabutang, tungud hay umpisa ka dya bukun run ikaw ti akun manugdumara.’ ");
INSERT INTO krj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nagkuon ang manugdumara sa anang kaugalingun, ‘Maiwan run lang ako kadya tungud hay pahalinun run ako kang akun amo sa akun katungdanan? Indi man ako kasarang magpangalog, kag mayha man ako magpakilimos. ");
INSERT INTO krj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naman-an ko run gali kon ano ang akun himoon, agud to nga kon wara run ako ti obra may mga amigo man angud ako nga mabaton kanakun sa andang mga balay!’ ");
INSERT INTO krj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Gani ang ginhimo na, ginpatawag na ang tanan nga tawo nga may mga utang sa anang amo. Nagkuon tana sa nahauna, ‘Sang ano ang utang mo sa akun amo?’ ");
INSERT INTO krj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nagsabat ang tawo, ‘Walo ka gatos ka galon nga lana kang olibo.’ Dayon nagkuon kana ang manugdumara, ‘Dyaay ang lista kang imong utang; pungkoi dya kag himoa nga apat ka gatos.’ ");
INSERT INTO krj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dayon nagkuon man tana sa isara, ‘Ikaw tana, pira ang imong utang sa akun amo?’ Nagsabat ang tawo, ‘Sangka gatos ka sako nga trigo.’ Dayon, nagkuon kana ang manugdumara, ‘Dyaay ang lista kang imong utang, himoa run lang nga walo ka napulo.’ ");
INSERT INTO krj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kag ang dayaun nga manugdumara nga dya gindayaw kang anang amo tungud sa anang kaabtik sa pagpahito. Sa dya nga kalibutan ang mga tawo nga wara nagatuo sa Dios mas abtik pa magpahito sangsa mga tawo nga nagatuo sa Dios.” ");
INSERT INTO krj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nagpadayon pa gid si Jesus sa paghambal, “Gamita ninyo ang kalibutanun nga manggad sa pagpakig-amigo, agud to nga kon indi run dya magamit, pagabatonon kamo sa iristaran nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ang bisan sin-o nga masarigan sa garagmay nga mga butang, masarigan man sa daragkul; kag ang bisan sin-o nga nagadaya sa garagmay nga mga butang, nagadaya man sa daragkul nga mga butang. ");
INSERT INTO krj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kon indi kamo masarigan sa pagkaput kang manggad rugya sa kalibutan, sin-o pa ang magasarig sa pagpakaput kaninyo kang matuod-tuod nga manggad? ");
INSERT INTO krj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kag kon indi kamo masarigan sa mga butang nga ginpakaput lang kaninyo kang iba, sin-o pa ang magatugro kaninyo kang mga butang nga mangin inyo run gid!” ");
INSERT INTO krj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wara ti surugoon nga makaalagad sa darwa ka agalun, tungud hay ang matabo karia kaugtan na ang isara kag palanggaun na ang isara, ukon alagadun na kang husto ang isara kag ang isara tana tamayun na. Indi ninyo maalagad kang dungan ang Dios kag ang manggad.” ");
INSERT INTO krj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kang mabatian ang tanan nga dya kang mga Fariseo nga tama ka makigkwarta, ginyaw-yaw nanda si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ginkun-an sanda ni Jesus, “Kamo gid ang nagapakita-kita sa mga tawo nga matarung gid kamo, pero naman-an kang Dios ang sulud kang inyong tagipusoon. Ang ano man nga ginaali-ali kang mga tawo, ginakangil-adan kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ang Kasugoan ni Moises kag ang sinulat kang mga propeta ginabantala hasta sa tion ni Juan nga Manugbawtiso. Umpisa sa tion nga ria ang Mayad nga Balita nahanungud sa Paghari kang Dios amo run ang ginapanudlo kag ang kada isara nagapamirit nga magpasakup rugya ka dya. ");
INSERT INTO krj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero mahapus pa nga madura ang langit kag ang lupa sangsa mangin wara ti pulos ang bisan pinakagamay nga pintok kang Kasugoan. ");
INSERT INTO krj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ang sin-o man nga magabulag sa anang asawa kag magpangasawa liwan, nakasala kang pagpanginbayi, kag ang laki nga magpangasawa kang sangka bayi nga ginbulagan kang anang bana, nakasala man kang pagpanginbayi.” ");
INSERT INTO krj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“May sangka manggaranun nga nagasuksok kang marahalun nga panaptun kag nagapagusto ka kaun adlaw-adlaw. ");
INSERT INTO krj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sa pwertahan kang anang balay may ginabutang nga imol nga tawo nga ginahingaranan kay Lazaro, nga ang lawas na ka dya naputos kang katul. ");
INSERT INTO krj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Si Lazaro nga dya nagahandum nga makakaun kang mga uyang halin sa lamesa kang manggaranun. Luwas pa dyan karia, ginaparapitan tana kang mga ayam kag ginadilapan ang anang mga katul. ");
INSERT INTO krj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Napatay ang tawo nga imol kag gindara kang mga anghel sa ingud ni Abraham. Napatay man ang tawo nga manggaranun kag ginlubung. ");
INSERT INTO krj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Rugto tana sa lugar kang mga patay nga nagaantos kag kang pagtangra na nakita na sa marayu si Abraham, kag si Lazaro sa ingud na ka dya. ");
INSERT INTO krj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gani nagpanawag tana, ‘Amay nga Abraham, maluoy man ikaw kanakun kag sugoa si Lazaro nga itum-uy ang punta kang anang tudlo sa tubig kag ipaturoan ang akun dila tungud hay sobra gid ang akun pag-antos rugya sa kalayo nga dya!’ ");
INSERT INTO krj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero nagsabat si Abraham, ‘Panumduma, anak, nga katong buhi pa ikaw naangkun mo run ang tanan nga mga mayad nga butang, kag ang kay Lazaro tana puros lang mga malain. Kadya tana, tana ang nagakalipay rugya kag ikaw timo nagaantos rugyan. ");
INSERT INTO krj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Luwas pa dyan karia, sa ulut natun may kadadalman nga ang bisan sin-o rugya nga malyag mag-agto rugyan indi makatabok, ukon ang bisan sin-o rugyan nga gusto mag-agto rugya indi man makatabok.’ ");
INSERT INTO krj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nagsabat ang manggaranun nga tawo, ‘Kon amo karia, Amay, nagapangabay ako nga kon mahimo ipaagtonon mo si Lazaro rugto sa balay kang akun tatay, ");
INSERT INTO krj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tungud hay may lima pa ako ka mga bugto nga laki rugto. Kun-on mo tana nga paandaman na sanda agud to nga indi man sanda makaagto rugya sa lugar nga puro lang pag-antos.’ ");
INSERT INTO krj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero nagkuon si Abraham kana, ‘Rugto man kananda ang kasugoan ni Moises kag ang mga sinulat kang mga propeta. Pabay-i sanda nga magpamati rugyan karia.’ ");
INSERT INTO krj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nagkuon ang manggaranun, ‘Kulang pa to, Amay nga Abraham. Pero kon may sangka tawo nga napatay kag mabuhi liwan kag mag-agto rugto kananda magahinulsul gid sanda kang anda mga sala.’ ");
INSERT INTO krj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero nagkuon si Abraham kana, ‘Indi gani sanda mamati sa ginakuon sa kasugoan ni Moises kag sa mga sinulat kang mga propeta, indi man sanda magpati bisan sa patay pa nga mabuhi liwan.’” ");
INSERT INTO krj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nagkuon si Jesus sa anang mga disipulo, “Indi gid malikawan nga magaabot ang mga butang nga mangin kabangdanan sa pagpakasala. Pero makaluluoy lang ang tawo nga amo ang mangin kabangdanan kang pagkasala kang anang isigka-tawo. ");
INSERT INTO krj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas mayad pa nga ipamatohan ang anang liug kang garalingan nga bato kag itagbung tana sa tunga kang dagat sangsa tana ang mangin kabangdanan nga makasala ang isara sa mga kabataan nga dya. ");
INSERT INTO krj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gani mag-andam kamo! “Kon makasala ang imo isigka-tumuluo, sawaya tana. Kag kon maghinulsul tana, patawara tana. ");
INSERT INTO krj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kon makapito tana ka beses nga makasala kanimo sa sulud kang sangka adlaw, kag makapito man tana ka beses nagaagto kanimo kag nagakuon, ‘Ginahinulsulan ko ang ginhimo ko nga sala,’ kinahanglan patawarun mo tana.” ");
INSERT INTO krj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nagkuon ang mga apostoles sa Ginoo, “Dugangi pa gid ang amun pagtoo!” ");
INSERT INTO krj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nagsabat ang Ginoo, “Kon may pagtoo kamo nga bisan pareho lang ka gamay sa liso kang mustasa, sarang kamo makakuon sa kahoy nga sicamoro nga dya, ‘Gabuta kag itanum ang imo kaugalingun sa dagat!’ kag dya magatuman kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pananglitan may surugoon ikaw nga nagaarado ukon nagabantay kang mga karnero. Sa anang pag-uli halin sa uma, ginakun-an mo bala tana nga magdali kag magkaun run? ");
INSERT INTO krj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wara, sa baylo, nagakuon ikaw kana, ‘Himusi ako ka akun yapon, dayon mag-ilis ikaw kag sirbihan ako rugya samtang nagakaun ako. Kag pagkatapos nga makakaun ako pwede run ikaw makakaun.’ ");
INSERT INTO krj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ang surugoon wara ginapasalamatan sa paghimo kang ginasugo kana tungud hay amo dya ang anang katungdanan. ");
INSERT INTO krj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Amo man ria kaninyo. Sa tapos nga mahimo ninyo ang tanan nga ginsugo kaninyo, makuon kamo, ‘Mga surugoon lang man kami; ginhimo lang namun ang amun katungdanan.’” ");
INSERT INTO krj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Samtang nagapaagto si Jesus sa Jerusalem, nag-agi tana sa may dulonan kang Samaria kag Galilea. ");
INSERT INTO krj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kang nagapasulud tana sa sangka baryo, ginsug-alaw tana kang napulo ka mga tawo nga aruon. Nagatirindug sanda rugto sa marayu ");
INSERT INTO krj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kag nagasiringgitan nga nagakuon, “Jesus! Agalun! Maluoy ikaw kanamun!” ");
INSERT INTO krj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kang makita sanda ni Jesus nagkuon tana kananda, “Panaw kamo kag mag-agto sa mga pari kag magpaturuk kananda.” Samtang nagapanaw sanda, nag-arayad sanda. ");
INSERT INTO krj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ang isara kananda, kang matalupangdan na nga nag-ayad run tana, nagbalik nga nagadayaw sa Dios sa mabaskug nga limug. ");
INSERT INTO krj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nagluhod tana sa may kahig nayon ni Jesus kag nagpasalamat kana. Ang tawo nga dya Samaritanhun. ");
INSERT INTO krj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Namangkot si Jesus, “Napulo kabay kamo nga nag-arayad? Ang syam tana sa diin run? ");
INSERT INTO krj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wara gid ti nagbaralik sa pagpasalamat sa Dios magluwas lang sa pangayaw nga dya?” ");
INSERT INTO krj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kag nagkuon si Jesus sa tawo, “Tindug run kag magpanaw. Ang imong pagtoo amo ang nag-ayad kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sangka tion, may mga Fariseo nga namangkot kay Jesus kon san-o magaumpisa ang paghari kang Dios. Nagsabat si Jesus kananda, “Ang pag-umpisa kang paghari kang Dios indi maman-an paagi sa mga butang nga makita. ");
INSERT INTO krj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wara man ti makakuon nga, ‘Sulnga, dyaay run!’ ukon, ‘Rugto run!’ tungud hay ang paghari kang Dios rugyan mismo kaninyo.” ");
INSERT INTO krj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dayon nagkuon si Jesus sa mga disipulo, “Magaabot ang tion nga magahandum kamo nga raad sangka adlaw makita ninyo liwan ang Anak kang Tawo, pero indi dya matabo. ");
INSERT INTO krj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","May mga magakuon kaninyo, ‘Rugto tana run!’ ukon ‘Dyaay tana run!’ Indi kamo maggwa sa pagsunod kananda. ");
INSERT INTO krj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tungud hay ang pag-abot kang Anak kang Tawo, mangin pareho sa kirab kang kilat nga nagasanag sa kalangitan halin sa pihak paagto sa pihak. ");
INSERT INTO krj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero kinahanglan anay nga mag-agum tana kang duro nga mga pag-antos kag sikwayun kang mga tawo sa ka dya nga panag-on. ");
INSERT INTO krj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ang kahimtangan kang kalibutan sa pag-abot kang Anak kang Tawo, mangin pareho sa panag-on ni Noe. ");
INSERT INTO krj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ang mga katawhan kato nagapinagusto lang ka kaun, ka inum kag pangasawa kag pamana, hasta nga mag-abot ang adlaw nga nagsulud si Noe sa arka kag nag-abot ang anaw kag nagkaramatay ang tanan nga mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amo man karia sa panag-on ni Lot. Ang mga tawo nagapinagusto lang ka kaun kag inum, nagabinaklanay kag nagabinaligyaanay, nagapananum kag nagapatindug kang mga balay. ");
INSERT INTO krj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero katong adlaw nga maghalin si Lot sa Sodoma, ginpauranan dya kang Dios kang kalayo kag asupre kag nagkarapapas ang tanan nga tawo rugto. ");
INSERT INTO krj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Amo gid ria ang kahimtangan kang kalibutan sa adlaw nga ang Anak kang Tawo magpahayag. ");
INSERT INTO krj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Sa amo to nga adlaw, ang tawo nga nataboan nga rugyan sa atup kang anang balay indi run magnaog kag magbuul kang anang mga pagkabutang sa sulud kang balay. Kag ang tawo tana nga rugto sa uma, indi run man mag-uli sa balay. ");
INSERT INTO krj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Panumduma ninyo ang natabo sa asawa ni Lot. ");
INSERT INTO krj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ang tawo nga nagatinguha nga luwasun ang anang kabuhi maduraan tana ka dya, pero ang tawo tana nga maduraan kang kabuhi, amo ang makaangkun ka dya. ");
INSERT INTO krj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sugidan ko kamo, sa amo to nga gabii, kon may darwa ka tawo nga nagaturog sa sangka baratangan, ang isara pagabul-un, ang isara tana mabilin. ");
INSERT INTO krj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kon may darwa ka bayi nga nagagaling, ang isara pagabul-un, kag ang isara tana mabilin.  ");
INSERT INTO krj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kag kon may darwa man ka tawo nga nagaobra sa uma, ang isara pagabul-un kag ang isara tana mabilin.” ");
INSERT INTO krj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dayon namangkot kana ang mga disipulo, “Sa diin bay, Ginoo?” Nagsabat si Jesus, “Kon sa diin gani ang patay nga lawas, rugto man nagatiripon ang mga pispis nga buwitre.” ");
INSERT INTO krj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gin-istoryahan ni Jesus ang anang mga disipulo kang paraanggidan para nga magpangamuyo sanda pirme kag indi magdura kang paglaum. ");
INSERT INTO krj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nagkuon tana, “Sa sangka banwa may sangka hukum nga wara nagakahadluk sa Dios ukon nagatahod sa anang isigka-tawo. ");
INSERT INTO krj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kag sa amo man nga banwa may sangka balo nga bayi nga pirme nagabalik-balik sa amo nga hukum nga nagapangayo kang bulig nga nagakuon, ‘Buligi man ako sa akun pangontra.’ ");
INSERT INTO krj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wara tana ginbuligan kang hukum sa sulud kang malawid nga tion, pero kang urihi run nagkuon tana sa anang kaugalingun, ‘Matuod nga wara ako nagakahadluk sa Dios ukon nagatahod sa akun isigka-tawo, ");
INSERT INTO krj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero buligan ko run lang ang bayi nga dya tungud hay pirme na lang ako ginatublag. Basi mapukros run lang ang akun ginhawa sa sobra na ka balik-balik.’” ");
INSERT INTO krj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kag nagkuon ang Ginoo, “Pamatii ninyo ang ginkuon kang malaot nga hukum nga to? ");
INSERT INTO krj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Indi ayhan pagbuligan kang Dios ang anang mga pinili nga adlaw kag gabii nagapangayo kang bulig kana? Pabuyan-buyanan na lang bala ang pagbulig kananda? ");
INSERT INTO krj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sugidan ko kamo, pagabuligan na sanda lagi-lagi. Ugaring sa pagbalik kang Anak kang Tawo rugya sa kalibutan, may masapwan tana ayhan nga nagatuo kana?” ");
INSERT INTO krj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nag-istorya si Jesus kang paraanggidan nga dya sa mga tawo rugto nga nagasarig nga matarung sanda kag ang iba tana ginatamay nanda. ");
INSERT INTO krj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kuon na, “May darwa ka laki nga nag-agto sa Templo para magpangamuyo. Ang isara ka dya Fariseo, kag ang isara tana manugsukot kang buwis. ");
INSERT INTO krj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kar-on, ang Fariseo nagtindug kag nagpangamuyo sa anang kaugalingun. ‘Dios ko, nagapasalamat ako kanimo nga bukun ako ti pareho kang iba nga tawo nga nagapamuul kang pagkabutang kang iba, bukun ti matarung, nagapakighilawas, ukon pareho kang manugsukot kang buwis nga ria. ");
INSERT INTO krj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Darwa ako ka beses nga nagapuasa sa sulud kang sangka semana, kag ginatao ko ang ikanapulo nga bahin kang tanan ko nga kinitaan.’ ");
INSERT INTO krj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sa pihak tana nga bahin, ang manugsukot kang buwis rugto sa marayu nagatindug kag indi gani makatangra sa langit kundi nagasagad lang ka pamukpok kang anang dughan, nga nagakuon, ‘O Dios, maluoy ikaw kanakun, tungud hay ako makasasala.’ ");
INSERT INTO krj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sugidan ko kamo, ang manugsukot kang buwis nga dya kag bukun ti ang Fariseo nga to ang nag-uli nga ginpakamatarung kang Dios. Tungud hay ang tawo nga nagapakataas kang anang kaugalingun pagapakanabaun, pero ang tawo tana nga nagapaubus amo ang pagabayawun.” ");
INSERT INTO krj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ginadara kang mga tawo kay Jesus ang andang mga lapsag agud to nga itungtongan na kang anang alima. Kang makita dya kang mga disipulo ni Jesus, ginsabdung nanda ang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ginpanawag sanda ni Jesus nga mag-agto kana, kag nagkuon, “Pabay-i ninyo ang mga kabataan nga magparapit kanakun kag indi ninyo sanda pagpunggi, tungud hay ang mga tawo nga pareho kananda amo ang makapasakup sa paghari kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sugidan ko kamo, ang sin-o man nga indi magbaton sa paghari kang Dios pareho kang bata, indi makapasakup sa paghari na ka dya.” ");
INSERT INTO krj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","May sangka manugdumara nga namangkot kay Jesus, “Mayad nga Maestro, ano ang dapat nakun himoon agud to nga makaangkun ako kang kabuhi nga wara ti katapusan?” ");
INSERT INTO krj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nagsabat si Jesus, “Andut haw nga ginatawag mo ako nga mayad? Wara run ti iba nga mayad, kundi ang Dios gid lang. ");
INSERT INTO krj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Naman-an mo ang kasugoan, ‘Indi ikaw magpakighilawas; indi ikaw magpatay; indi kaw magpanakaw; indi ikaw magbutig sa imong pagtistigo; kag tahuda ang imo tatay kag nanay.’” ");
INSERT INTO krj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nagsabat ang tawo, “Ang tanan nga ria natuman ko run halin pa kang bata ako.” ");
INSERT INTO krj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kang mabatian dya ni Jesus nagkuon tana sa tawo, “May sangka butang pa ikaw nga wara mahimo. Ibaligya ang tanan nimo nga mga pagkabutang kag ang kwarta ipanagtag sa mga imol, kag makaangkun ikaw kang manggad sa langit. Dayon magsunod ikaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero kang mabatian dya kang tawo, nasubuan gid tana ka mayad, tungud hay tama gid tana ka manggaranun. ");
INSERT INTO krj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nakita ni Jesus nga nasubuan ang tawo, gani nagkuon tana, “Daw ano ka budlay sa manggaranun ang magpasakup sa paghari kang Dios! ");
INSERT INTO krj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas mahapus pa sa kamelyo ang mag-agi sa buho kang dagum sangsa manggaranun nga magpasakup sa paghari kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ang mga nakabati ka dya nagpamangkot, “Sin-o run lang bay ang maluwas?” ");
INSERT INTO krj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nagsabat si Jesus, “Ang mga butang nga indi mahimo kang tawo mahimo kang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nagkuon si Pedro kana, “Amun tana, ginbayaan namun ang tanan kag nagsunod kami kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nagkuon si Jesus kananda, “Sugidan ko kamo, ang bisan sin-o nga nagbiya kang anang panimalay, asawa, kabugtoan, ginikanan, ukon kabataan tungud gid lang sa pagpasakup sa paghari kang Dios, ");
INSERT INTO krj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ang magabaton kang sobra pa gid sangsa anang mga ginbayaan sa kadya nga panag-on, kag sa paraaboton makaangkun tana kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ginpain ni Jesus ang napulo'g darwa ka disipulo kag nagkuon tana kananda, “Pamati kamo! Maagto kita sa Jerusalem, kag rugto matuman ang tanan nga ginsulat kang mga propeta nahanungud sa Anak kang Tawo. ");
INSERT INTO krj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Igatugyan tana sa mga bukun ti Judio; yagutaun nanda tana, pakahuy-an, dupraan, ");
INSERT INTO krj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hanoton kana kag patyun, pero sa ikatlo nga adlaw mabanhaw tana.” ");
INSERT INTO krj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero sa mga ginpanghambal na nga dya wara gid ti may nahangpan ang mga disipulo. Ginlikum kananda ang kahulogan kang mga pulong nga dya, kag wara sanda kamaan kon ano ang anang ginapanghambal. ");
INSERT INTO krj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kang nagahinamput run si Jesus sa Jerico, may sangka bulag nga nagapungko sa binit kang dalan nga nagapakilimos. ");
INSERT INTO krj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kang mabatian na ang panung kang mga tawo nga nagaagi, namangkot tana kon ano ang nagakatabo. ");
INSERT INTO krj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ginkun-an nanda tana nga nagaagi si Jesus nga taga-Nazaret. ");
INSERT INTO krj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nagsinggit tana, “Jesus nga kaliwat ni David, maluoy ikaw kanakun!” ");
INSERT INTO krj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pero ginsaway tana kang mga tawo sa unahan kag ginkun-an nga maghipus. Pero gintudohan na pa gid gani ang pagsinggit, “Kaliwat ni David, maluoy ikaw kanakun!” ");
INSERT INTO krj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nagpundo si Jesus kag nagsugo nga idar-un kana ang bulag. Kang makaparapit run ang bulag kay Jesus, ginpamangkot tana ni Jesus, ");
INSERT INTO krj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ano ang gusto mo nga himoon ko kanimo?” Nagsabat ang bulag, “Ginoo, gusto ko nga makakita liwan.” ");
INSERT INTO krj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dayon nagkuon si Jesus kana, “Makakita ikaw run; ang imong pagtoo ang nag-ayad kanimo.” ");
INSERT INTO krj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kag lagi-lagi makakita run ang bulag kag nagsunod tana kay Jesus nga nagadayaw sa Dios. Kang makita kang mga tawo ang natabo nga dya, gindayaw man nanda ang Dios. ");
INSERT INTO krj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nagsulud si Jesus sa banwa kang Jerico kag nagapanaw tana rugto. ");
INSERT INTO krj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","May sangka tawo rugto nga ginahingaranan kay Zaqueo. Pangulo tana ka dya kang mga manugsukot kang buwis, kag manggaranun tana. ");
INSERT INTO krj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nagatinguha raad tana nga magsulung kon sin-o gid si Jesus, pero indi tana makakita tungud sa kadurohon kang mga tawo kag labut pa putot tana. ");
INSERT INTO krj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gani nagdalagan tana kag mag-una kag magsaka sa kahoy nga sicamoro agud to nga makita na si Jesus tungud hay rugto sa dalan nga to tana maagi. ");
INSERT INTO krj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kang rugto run si Jesus sa amo nga lugar, nagtangra tana kag naghambal kay Zaqueo, “Zaqueo, panaog dyan lagi tungud hay kadya nga adlaw rugto ako madayon sa imo balay!” ");
INSERT INTO krj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nagdali-dali man nga nagpanaog si Zaqueo kag malipayun gid tana nga ginbaton si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kang makita dya kang mga tawo, nagkurumodon sanda, “Nagdayon tana sa balay kang tawo nga makasasala.” ");
INSERT INTO krj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nagtindug si Zaqueo kag nagkuon sa Ginoo, “Ginoo, ang katunga kang akun mga pagkabutang ipanugro ko sa mga imol, kag kon may gindayaan ako, baydan ko kang apat ka pilo.” ");
INSERT INTO krj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nagkuon si Jesus kay Zaqueo, “Kadya gid nga adlaw ginluwas kang Dios ang panimalay nga dya, tungud hay ang tawo nga dya kaliwat man ni Abraham. ");
INSERT INTO krj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tungud hay ang Anak kang Tawo nag-abot agud pangitaun kag iluwasun ang mga nadura tungud kang sala.” ");
INSERT INTO krj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Samtang nagapamati ang mga tawo ka dya, nagpadayon si Jesus kag gin-istoryahan na sanda kang sangka paraanggidan. Ginhimo na dya tungud hay nagahinamput run sanda sa Jerusalem kag nagapinsar ang mga tawo nga madali run lang maghari ang Dios. ");
INSERT INTO krj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gani nagkuon tana kananda, “May sangka dungganun nga tawo nga nag-agto sa marayu nga lugar para himoon tana rugto nga hari, kag dayon karia mabalik man tana. ");
INSERT INTO krj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sa wara pa tana makapanaw, gintawag na ang anang napulo ka surugoon kag gintugroan kang tag sangka bulawan nga kwarta kag ginkun-an, ‘Patikanga ninyo dya hasta sa akun pagbalik.’ ");
INSERT INTO krj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero ang anang mga kasimanwa nagaugut kana, gani pagkahalin na, nagpasugo sanda kang mga tawo agud magkuon, ‘Indi kami gusto nga tana ang magahari kanamun.’ ");
INSERT INTO krj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pero ang dungganun nga tawo nga dya ginhimo man angud nga hari, kag nagbalik tana sa ana nga banwa. Ginpatawag na ang anang mga surugoon nga ginpanugroan na kang kwarta agud to nga maman-an na kon pira ang anda nga naginansya. ");
INSERT INTO krj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ang una nga nag-abot nagkuon kana, ‘Agalun, nakaginansya takun kang napulo ka pilo sa kwarta nga imo gintugro kanakun.’ ");
INSERT INTO krj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nagkuon ang anang agalun kana, ‘Nami gid, mayad gid ikaw nga surugoon! Tungud nga masarigan ikaw sa mga garagmay nga butang, ipadumarahun ko ikaw kang napulo ka mga banwa.’ ");
INSERT INTO krj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ang ikarwa tana nga surugoon nag-abot man kag nagkuon, ‘Agalun, nakaginansya takun kang lima ka pilo sa kwarta nga imo gintugro kanakun.’ ");
INSERT INTO krj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nagkuon ang agalun kana, ‘Ikaw tana, ipadumarahun ko kang lima ka mga banwa.’ ");
INSERT INTO krj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ang isara pa gid tana nga surugoon nag-abot man kag nagkuon, ‘Agalun, dyaay ang imo kwarta. Ginputos ko ria sa panyo kag gintago! ");
INSERT INTO krj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nahadluk ako kanimo tungud hay istrikto ikaw nga tawo. Ginabuul nimo ang bukun ti imo kag ginaani nimo ang bukun ti imo pinanggasan!’ ");
INSERT INTO krj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nagsabat ang agalun, ‘Malain gid ikaw nga surugoon! Husgaran ko ikaw suno sa imong ginhambal nga ria. Naman-an mo gali nga istrikto ako nga tawo; ginabuul ko ang bukun ti akun, kag ginaani ko ang bukun ti akun sinab-ogan. ");
INSERT INTO krj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Andut haw nga wara nimo ginbutang sa bangko ang akun kwarta agud to nga pagbalik ko mabuul ko ang akun kwarta nga may saka?’ ");
INSERT INTO krj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dayon nagkuon ang agalun sa mga tawo nga nagatirindug rugto, ‘Sige, bul-a ninyo kana ang kwarta kag itugro sa tawo nga nakaginansya kang napulo ka pilo!’ ");
INSERT INTO krj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pero nagsabat sanda kana, ‘Agalun, may ana run tana nga napulo ka bulawan nga kwarta!’ ");
INSERT INTO krj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nagkuon ang agalun, ‘Sugidan ko kamo, ang tawo nga may ana run nga ginaangkun pagatugroan pa gid. Pero ang tawo tana nga wara ti ginaangkun, pagabul-un pa gani kana ang bisan gamay nga rugyan kana. ");
INSERT INTO krj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kon parte tana sa akun mga kaaway nga to nga indi gusto nga mangin hari nanda ako, dar-a ninyo sanda rugya kag pamatyun sa akun atubangan!’” ");
INSERT INTO krj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagkatapos ni Jesus kuon ka dya, nag-una tana panaw paagto sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kang nagahinamput run tana sa may Betfage kag Betania, rugto sa may bukid nga ginatawag Bukid kang mga Olibo, nagsugo tana kang darwa sa anang mga disipulo nga mag-una kana, ");
INSERT INTO krj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nagkuon tana kananda, “Agto kamo sa sunod nga baryo. Sa pagsulud ninyo rugto, may makita kamo nga sangka tinday kang asno nga nahigtan nga wara pa gid masakyi, hubadi ninyo kag dar-un rugya. ");
INSERT INTO krj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kon may mamangkot gani kaninyo, ‘Andut nga ginahubadan ninyo ria?’ kun-an ninyo nga, ‘Kinahanglan dya kang Ginoo.’” ");
INSERT INTO krj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nagpanaw ang darwa ka ginsugo, kag kon ano ang ginkuon ni Jesus kananda amo gid ang andang nakita. ");
INSERT INTO krj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kang ginahubadan run nanda ang tinday kang asno, ginpamangkot sanda kang mga tag-iya, “Andut nga ginahubadan ninyo ria?” ");
INSERT INTO krj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nagsabat sanda, “Kinahanglan dya kang Ginoo.” ");
INSERT INTO krj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kag gindara nanda dya kay Jesus. Ginhapinan nanda ang likod na ka dya kang andang mga kunup kag ginpasakay rugya si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Samtang nagasakay tana, ginpanghumlad kang mga tawo ang andang mga kunup sa dalan. ");
INSERT INTO krj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kar-on, kang nagahinamput run tana sa may kunsadan kang Bukid kang Mga Olibo, ang tanan nga anang mga sumuronod nagkinasadya kag nagadayaw sa Dios sa matunog nga limug, tungud kang tanan nga makatiringala nga butang nga andang nakita. ");
INSERT INTO krj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kuon nanda, “Pakamayadun ang hari nga nagaabot sa ngaran kang Ginoo! Paghidait sa langit kag himaya sa Dios!” ");
INSERT INTO krj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Halin sa karak-an may mga Fariseo nga naghambal kay Jesus, “Maestro, sawaya ang imong mga sumuronod!” ");
INSERT INTO krj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nagsabat si Jesus, “Sugidan ko kamo, kon maghipus sanda, ang mga bato nga dya amo ang magasinggit.” ");
INSERT INTO krj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kang marapit run gid si Jesus sa Jerusalem kag makita na ang syudad, ginhibian na dya, ");
INSERT INTO krj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nga nagakuon, “Kon naman-an mo lang raad tulad kadya kon ano ang paagi nga makaangkun ikaw kang kalinung! Pero kadya indi mo dya makita! ");
INSERT INTO krj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tungud hay magaabot ang adlaw nga palibotan ikaw kang kuta kang imong kaaway, kibunon nanda ikaw kag bisan diin ikaw mag-agi indi gid ikaw makalusot. ");
INSERT INTO krj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Papasun gid nanda ikaw kag ang tanan nimo nga katawhan nga rugyan sa sulud nimo, kag wara gid ti mabilin nga bato nga nagasampawanay, tungud hay wara mo gintalupangud ang tion nga luwasun ikaw kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pag-abot nanda sa Jerusalem, nagsulud si Jesus sa Templo kag ginpanabog ang mga manugbaligya rugto. ");
INSERT INTO krj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ginkun-an na sanda, “Ginakuon sa kasulatan, ‘Ang akun balay mangin balay-parangamuyoan,’ pero ginhimo ninyo dya nga paranagoan kang mga takawan!” ");
INSERT INTO krj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kada adlaw nagapanudlo si Jesus sa Templo. Ang mga pangulo kang mga kaparian, kag ang mga manunudlo kang Kasugoan, kag ang mga manugdumara kang mga katawhan nagatinguha gid sa pagpatay kana. ");
INSERT INTO krj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero wara gid sanda ti may makita nga kahigayonan sa pagpatay kana tungud hay ang mga tawo nanamian gid mamati kang anang mga pulong. ");
INSERT INTO krj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sangka adlaw, samtang nagapanudlo si Jesus sa mga tawo rugto sa Templo kag nagawali kang Mayad nga Balita, nagparapit kana ang mga pangulo kang kaparian, kag ang mga manunudlo kang Kasugoan, kag ang mga kamal-aman. ");
INSERT INTO krj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nagkuon sanda kana, “Sugidi kami kon ano ang imong awtoridad sa paghimo kang mga butang nga dya, kag sin-o ang nagtugro kanimo kang awtoridad nga ria?” ");
INSERT INTO krj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ginsabat sanda ni Jesus, “May pamangkot man ako kaninyo. Sugidi ninyo ako: ");
INSERT INTO krj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","sa diin maghalin ang awtoridad ni Juan sa pagpangbawtiso? Sa Dios bala ukon sa tawo?” ");
INSERT INTO krj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Amo to kag nag-istoryahanay sanda nga nagakuon, “Kon magkuon kita nga sa Dios maghalin, makuon tana kanatun, ‘Ti, andut nga wara kamo magpati kana?’ ");
INSERT INTO krj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero kon magkuon man kita nga sa tawo maghalin, ibatwun kita kang tanan nga mga tawo tungud hay ginakilala nanda nga si Juan sangka propeta.” ");
INSERT INTO krj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gani, nagsabat sanda, “Wara kami kamaan kon diin maghalin ang anang awtoridad.” ");
INSERT INTO krj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nagkuon si Jesus kananda, “Indi ko man pag-isugid kaninyo kon ano ang akun awtoridad sa paghimo kang dya nga mga butang.” ");
INSERT INTO krj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nag-istorya liwan si Jesus sa mga tawo kang dya nga paraanggidan, “May sangka tawo nga nagpananum kang ubas sa anang uma, kag ginpaagsa na dya, kag nagpanaw tana sa marayu nga lugar nga sa diin nagbuhay tana. ");
INSERT INTO krj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kang pag-abot kang tag-arani kang ubas, ginpaagto na ang anang surugoon sa mga agsador para magbuul kang anang huray. Pero ginbakol kang mga agsador ang surugoon nga dya kag ginpabalik nga wara gid ti dara. ");
INSERT INTO krj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nagsugo ruman tana kang isara pa gid ka surugoon. Ginbakol man kang mga agsador ang surugoon nga dya kag ginpakahuy-an, kag ginpabalik nga wara man ti dara. ");
INSERT INTO krj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nagsugo pa gid tana kang ikatlo nga surugoon. Ginsakit nanda tana ka mayad kag gintabog. ");
INSERT INTO krj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dayon, ang tag-iya nagkuon sa anang kaugalingun, ‘Ano run lang bay ang akun himoon kadya? Mayad siguro ang akun pinalangga nga bata ang akun isuguon, basi tahudon nanda tana.’ ");
INSERT INTO krj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero kang makita kang mga agsador ang bata, naghambalanay sanda, ‘Dyaay run ang manunubli! Patyun natun tana para mabuul natun ang anang paranubliun!’ ");
INSERT INTO krj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gani gindara nanda tana sa gwa kang ubasan kag ginpatay. “Ano kar-on ang himoon kang tag-iya kang ubasan sa mga agsador? ");
INSERT INTO krj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Agtonan na sanda kag ipamatyun, kag ang ubasan ipaagsa na run lang sa iba.” Pagkabati ka dya kang mga tawo nagkuon sanda, “Kabay pa nga indi dya matabo!” ");
INSERT INTO krj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dayon ginturuk sanda ni Jesus kag ginpamangkot, “Kar-on, ano ang kahulogan kang ginakuon sa Kasulatan nga, ‘Ang bato nga wara maluyagi kang mga manughimo kang balay amo pa ang nangin pinakapamusod nga bato?’ ");
INSERT INTO krj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ang kada isara nga mahulog sa bato nga dya marupsak gid, kag ang mahulogan na ka dya makarapusa gid nga daw binukbok.” ");
INSERT INTO krj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ang mga manunudlo kang kasugoan kag ang mga pangulo kang kaparian nagtinguha gid nga idakpun si Jesus sa amo gid to nga tion tungud hay nasat-uman nanda nga sanda ang ginatumud ni Jesus sa paraanggidan nga dya, ugaring hay nahadluk sanda sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gani naghulat sanda kang nagakaigo nga kahigayonan. Nagpadara sanda kang mga tawo nga magpanilag kana, nga magapakuno-kuno nga matuod-tuod ang andang tuyo. Nagalaum sanda nga madakpan si Jesus paagi sa anang ginapanghambal agud to nga may rason sanda nga itugyan tana sa gahum kag awtoridad kang gobernador. ");
INSERT INTO krj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Namangkot ang mga ginsugo nga dya kay Jesus, “Maestro, naman-an namun nga husto ang imong ginapanghambal kag ginapanudlo, kag wara ikaw ti pinilian, kag nagatudlo ikaw kang kamatuoran nahanungud sa kabubut-un kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ginatugot bala kang kasugoan ang magbayad kang buwis sa Emperador kang Roma, ukon wara?” ");
INSERT INTO krj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero nasat-uman ni Jesus ang andang tuyo nga mangloko, gani nagkuon tana kananda, ");
INSERT INTO krj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Abi, pakitai ninyo ako kang sangka kwarta nga pilak. Kay sin-o itsura kag ngaran ang nakabutang rugya?” Nagsabat sanda, “Ana kang emperador!” ");
INSERT INTO krj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nagkuon si Jesus kananda, “Kon amo, itugro ninyo sa emperador ang para sa emperador, kag itugro ninyo sa Dios ang para sa Dios!” ");
INSERT INTO krj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kag wara gid sanda makadakup kana sa atubang kang karak-an sa anang mga ginpanghambal, naghipus run lang sanda nga natingala sa anang mga sabat. ");
INSERT INTO krj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kar-on, may mga Saduceo nga nagparapit kay Jesus. Sanda ka dya ang mga tawo nga wara nagapati nga may pagkabanhaw. Namangkot sanda kay Jesus ");
INSERT INTO krj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","nga nagakuon, “Maestro, nagsulat si Moises para kanatun sa kasugoan nga kon ang sangka laki nga may asawa mapatay nga wara ti kabataan, ang balo kinahanglan ipangasaw-un kang bugto nga laki agud to nga magpamata sanda para sa napatay. ");
INSERT INTO krj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","May pito ka mga magburugto nga laki. Ang magurang nagpangasawa kag napatay nga wara ti bata. ");
INSERT INTO krj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kar-on, ang balo ginpangasawa kang nagasunod nga bugto nga laki. Pero napatay man dya. ");
INSERT INTO krj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Amo man ang natabo sa ikatlo nga bugto nga laki, hasta nga sanda tanan nga pito nga magburugto nakapangasawa sa amo nga bayi kag nagkaramatay nga wara gid makapamata. ");
INSERT INTO krj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kang urihi, napatay man ang bayi. ");
INSERT INTO krj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kar-on, sa adlaw nga ang mga patay banhawun, kay sin-o tana nga asawa, tungud hay sanda tanan nga pito nakapangasawa kana?” ");
INSERT INTO krj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ginsabat sanda ni Jesus, “Ang mga katawhan sa kadya nga panag-on nagaarasawahay. ");
INSERT INTO krj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ang mga katawhan tana nga ginakabig nga takus banhawun kag magkabuhi sa paraaboton nga panahon, wara run nagaarasawahay. ");
INSERT INTO krj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tungud hay kaangay run sanda kang mga anghel kag indi run sanda mapatay. Mga kabataan run sanda kang Dios tungud hay ginbanhaw run sanda. ");
INSERT INTO krj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ginpamatud-an ni Moises nga ang mga patay ginabanhaw. Sa bahin kang kasulatan nahanungud sa nagadaba-daba nga purongpong gintawag na ang Ginoo nga Dios ni Abraham, Dios ni Isaac, kag Dios ni Jacob. ");
INSERT INTO krj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kon sayudon, Dios tana kang mga buhi kag bukun ti kang mga patay. Tungud sa anang panuruk ang tanan buhi.” ");
INSERT INTO krj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ang iba sa mga manunudlo kang kasugoan rugto nagkuon, “Maestro, igsakto ang imong sabat!” ");
INSERT INTO krj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kag wara run ti nangahas nga magpamangkot kana liwan kang bisan ano. ");
INSERT INTO krj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kar-on, namangkot si Jesus kananda, “Andut nga ginakuon kang mga tawo nga ang Cristo kaliwat ni David? ");
INSERT INTO krj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tungud hay si David mismo nagkuon sa libro kang mga Salmo, nga, ‘Ang Ginoo nagkuon sa akun Ginoo, Pungko ikaw sa akun tuo nayon ");
INSERT INTO krj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hasta nga mapyerde ko ang imong mga kaaway.’ ");
INSERT INTO krj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gintawag tana ni David nga Ginoo, paano nga nangin kaliwat tana ni David?” ");
INSERT INTO krj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Samtang nagapamati ang tanan nga mga tawo, nagkuon si Jesus sa anang mga disipulo, ");
INSERT INTO krj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-andam kamo sa mga manunudlo kang Kasugoan, nga nanamian gid maglagaw-lagaw nga nagabayo kang malabug, kag sa mga tindahan gusto gid nanda nga tahudon sanda kang mga tawo, kag gusto gid nanda magpungko sa importante nga purongkoan sa mga sinagoga, kag sa mga tabadan gusto gid nanda nga magpungko sa mga purongkoan nga gintigana para sa mga dungganun nga mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ginapamuul nanda ang mga pagkabutang kang mga bayi nga balo kag ginatabon-tabonan lang nanda ang andang mga hinimoan kang mga malawid nga pagpangamuyo. Mas tama gid ka budlay nga silot ang andang maaguman.” ");
INSERT INTO krj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kang paglantaw ni Jesus nakita na ang mga manggaranun nga nagabutang kang andang mga halad sa burutangan kang kwarta sa templo. ");
INSERT INTO krj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nakita na man ang sangka imol nga bayi nga balo nga nagabutang kang darwa ka metal nga sinsilyo. ");
INSERT INTO krj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nagkuon si Jesus, “Sugidan ko kamo, ang bayi nga balo nga imol nga dya nagbutang kang sobra sangsa kananda tanan! ");
INSERT INTO krj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tungud hay tanan sanda nagbutang halin sa sobra kang andang manggad, pero ang bayi tana nga ria bisan pa nga imol tana, gintao na pa ang kwarta nga amo lang ang makabuhi kana.” ");
INSERT INTO krj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ang iba sa mga disipulo nagmuno kon daw ano kanami ang Templo nga nahuman sa mga manami nga mga bato kag napunihan kang manami nga mga butang nga ginhalad sa Dios. Nagkuon si Jesus, ");
INSERT INTO krj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kon nahanungud sa mga butang nga dya nga inyo makita sa tulad, magaabot ang tion nga wara gid ti mabilin rugya bisan sangka bato nga nagasampaw sa isara. Marumpag gid dya tanan!” ");
INSERT INTO krj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ginpamangkot nanda si Jesus, “Maestro, san-o bay dya mabato? Kag ano ang paratandaan nga marapit run lang dya matabo?” ");
INSERT INTO krj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nagsabat si Jesus, “Mag-andam kamo nga indi kamo mapatalang. Tungud hay duro nga mga tawo ang magaturohaw kag magapakuno-kuno nga sanda amo ako, kag magakuon, ‘Ako amo tana’ kag ‘Amo run dya ang katapusan nga tion!’ Pero indi gid kamo magsunod kananda. ");
INSERT INTO krj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kon may mabatian kamo gyera kag kinagamo, indi kamo magkahadluk. Ang dya nga mga butang kinahanglan nga matabo anay, pero wara dya nagakahulogan nga amo run ria ang katapusan kang tanan.” ");
INSERT INTO krj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kag nagkuon tana kananda, “Magairinaway ang mga nasyon kag amo man ang mga ginharian. ");
INSERT INTO krj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Magaabot man ang tama ka baskug nga mga linog, gutum kag nanari-sari nga mga balatian sa nagkalain-lain nga mga lugar. May magatuhaw nga makakurugmat kag daragkul nga paratandaan nga makita sa kalangitan. ");
INSERT INTO krj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero sa wara pa magkaratabo ang tanan nga dya, pagadakpun kamo kag pagahingaboton. Pagadar-un kamo sa mga sinagoga kag ipapriso. Paatubangun kamo sa mga hari kag sa mga gobernador tungud kanakun. ");
INSERT INTO krj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Amo run dya ang inyo kahigayonan nga makapanugid kamo nahanungud kanakun. ");
INSERT INTO krj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ibutang gid ninyo sa inyo panghuna-huna nga indi kamo magpalibug kon paano kamo magsabat, ");
INSERT INTO krj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tungud hay tugroan ko kamo kang inyo inughambal kag kaaram agud to nga wara ti bisan isara sa inyo mga kaaway ang makasabat ukon makasupok kaninyo. ");
INSERT INTO krj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pagatraidoran kamo kang inyong mga ginikanan, mga kabugtoan, mga himata, kag mga kaabyanan, kag ang iba kaninyo pagapatyun. ");
INSERT INTO krj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaugtan kamo kang tanan nga mga tawo tungud kanakun. ");
INSERT INTO krj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero wara gid ti may madura kaninyo bisan isara sa inyong mga buhok. ");
INSERT INTO krj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Magpakarig-un kamo, kag maluwas ninyo ang inyo kaugalingun.” ");
INSERT INTO krj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kon makita run gani ninyo nga nalibutan run kang mga sudado ang Jerusalem, maman-an ninyo nga sa indi magbuhay pagagub-un run dya. ");
INSERT INTO krj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gani ang mga katawhan sa Judea magparalagyo run sa kabukidan, ang sa sulud kang syudad magparalagyo man, kag ang rugto tana sa mga kaumahan indi run mag-uyang ka tyempo sa pagsulud sa syudad. ");
INSERT INTO krj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tungud hay amo run dya ang, ‘Adlaw kang Pagsilot,’ nga amo ang katumanan kang ginakuon sa Kasulatan. ");
INSERT INTO krj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa amo to nga mga inadlaw makaluluoy gid ang nagabusong kag mga nagapatiti. Tungud hay tuman gid ang kalisud nga maaguman kang lugar nga dya, kag ang kasingkal kang Dios maaguman gid kang mga katawhan nga dya. ");
INSERT INTO krj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ang iba pagapatyun paagi sa espada, kag ang iba tana pagabihagun kag dar-un sa tanan nga mga nasyon. Ang Jerusalem pagagub-un kang mga bukun ti Judio hasta sa adlaw nga matapos ang andang pagginahum.” ");
INSERT INTO krj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“May mga makatiringala nga paratandaan nga matabo sa adlaw, sa bulan kag sa mga bituon. Rugya tana sa lupa, ang mga nasyon magabatyag kang tuman nga kahadluk tungud sa kagahud kag hinagunus kang daragkul nga mga balud sa dagat. ");
INSERT INTO krj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Magakapunaw ang mga tawo sa kahadluk sa pagpaminsar kon ano pa gid ang matabo sa kalibutan, tungud hay ang mga butang dyan sa kahawaan pagauyugun. ");
INSERT INTO krj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kag dayon makita nanda ang Anak kang Tawo nga nagaabot nga ginadara kang panganod, gamhanan tana kag tuman gid ang anang pagkamahimayaun. ");
INSERT INTO krj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kon ang ria nga mga butang mag-umpisa run nga magkaratabo, magkalipay kamo kag magbantay tungud hay marapit run lang kamo nga hilwayun.” ");
INSERT INTO krj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nag-istorya si Jesus kang dya nga paraanggidan, “Turuka bala ninyo ang kahoy nga higera kag ang iba pa gid nga mga kahoy. ");
INSERT INTO krj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kon magpanglumbay run gani dya, maman-an ninyo nga dali run lang ang tag-irinit. ");
INSERT INTO krj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sa amo man nga bagay, kon makita ninyo gani nga nagakaratabo run ang mga butang nga dya, maman-an man ninyo nga marapit run lang ang paghari kang Dios. ");
INSERT INTO krj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sugidan ko kamo, magakaratabo dya tanan nga mga butang sa wara pa mapatay ang mga tawo sa dya nga panag-on. ");
INSERT INTO krj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Madura ang langit kag ang lupa, pero ang akun mga pulong magapabilin hasta san-o.” ");
INSERT INTO krj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mag-andam kamo nga indi kamo mawili sa pagpatuyang kag sa pagpalingin kag sa pagpalibug kang inyo pagpangabuhi, tungud hay basi gulpi lang mag-abot ang adlaw nga ria kaninyo, nga daw siud. ");
INSERT INTO krj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tungud hay maabot dya sa tanan nga mga tawo rugya sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gani, magpangaman kamo kag magpangamuyo nga maagum ninyo ang kabaskug nga malampuwasan ninyo ang tanan nga mga butang nga dya nga magakaratabo, kag makapangatubang kamo sa Anak kang Tawo.” ");
INSERT INTO krj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kada adlaw nagapanudlo si Jesus sa Templo, pero kon maggabii nagagwa tana kag mag-agto sa Bukid kang mga Olibo, kag bilog nga gabii tana rugto. ");
INSERT INTO krj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kag ang tanan nga mga tawo aga pa nga nagaagto sa templo sa pagpamati kana. ");
INSERT INTO krj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kar-on, marapit run lang ang Pista kang Tinapay nga wara ti Tapay, nga ginatawag man nga Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ang mga pangulo kang kaparian kag ang mga manunudlo kang Kasugoan nagapangita gid kang paagi nga mapapatay nanda si Jesus, tungud hay nahadluk sanda sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kar-on, nagsulud si Satanas kay Judas nga ginatawag Iscariote, nga isara sa napulo'g darwa ka mga disipulo. ");
INSERT INTO krj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gani, nagpanaw si Judas kag nagpakig-istorya sa mga pangulo kang kaparian kag sa mga gwardya kang templo kon paano na matugyan si Jesus kananda. ");
INSERT INTO krj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nalipay gid sanda kag nagpasugot nga baydan nanda tana kang kwarta. ");
INSERT INTO krj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nagpasugot man si Judas, kag nagpangita tana kang kahigayonan kon paano na maluiban si Jesus kananda nga indi maman-an kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nag-abot run ang adlaw kang Pista kang Tinapay nga wara ti Tapay, nga ang karnero para sa Pista kang Paglampuwas kinahanglan nga ihawun kag ihalad. ");
INSERT INTO krj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ginsugo ni Jesus si Pedro kag si Juan kag ginkun-an, “Panaw kamo kag ihanda ninyo ang pagkaun nga atun ikan-un sa pista kang paglampuwas.” ");
INSERT INTO krj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Namangkot sanda, “Diin mo bay gusto nga ihanda namun ang pagkaun?” ");
INSERT INTO krj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nagsabat si Jesus, “Pagsulud ninyo sa syudad, sug-alawun kamo kang sangka laki nga nagadara kang sangka tibud nga may tubig. Sunda ninyo tana hasta sa balay nga anang pagasudlan, ");
INSERT INTO krj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","kag hambalan ninyo ang tagbalay, ‘Nagapamangkot ang Maestro kon diin ang kwarto nga pagakan-an nanda kang anang mga disipulo sa pista kang paglampuwas.’ ");
INSERT INTO krj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ipakita na kaninyo ang sangka bahul nga kwarto sa ibabaw nga nasangkapan run. Rugto ninyo himsun ang tanan.” ");
INSERT INTO krj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nagpanaw sanda, kag pag-abot nanda rugto, nakita nanda ang tanan suno sa ginhambal kananda, kag ginhimus nanda ang pagkaun para sa Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pag-abot kang tion, nagpungko si Jesus para magkaun sa lamesa imaw kang anang mga apostoles. ");
INSERT INTO krj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nagkuon tana kananda, “Bahul gid ang akun handum nga mag-imaw kaninyo sa pagkaun sa pista kang paglampuwas sa wara pa ako mag-antos. ");
INSERT INTO krj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sugidan ko kamo, indi run ako magkaun ka dya liwan hasta nga matuman ang anang kahulogan ka dya sa tion nga maghari ang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dayon nagbuul si Jesus kang kupa kag nagpasalamat sa Dios kag nagkuon, “Batona ninyo dya kag huray-hurayun. ");
INSERT INTO krj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sugidan ko kamo, umpisa kadya indi run ako liwan mag-inum kang bino nga halin sa ubas hasta nga mag-abot ang adlaw nga maghari ang Dios.” ");
INSERT INTO krj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dayon nagbuul tana kang tinapay, kag nagpasalamat sa Dios, kag ginpamihak-pihak dya kag gintugro kananda nga nagakuon, “Amo dya ang akun lawas nga gintugro kaninyo. Himoa ninyo dya sa pagdumdum kanakun.” ");
INSERT INTO krj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kag pagkatapos nga makayapon sanda, nagbuul si Jesus kang kupa kag nagkuon, “Ang kupa nga dya amo ang bag-o nga kasugtanan kang Dios nga ginparig-un paagi sa akun dugo nga gin-ula para kaninyo. ");
INSERT INTO krj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Pero sugidan ko kamo, ang tawo nga magaluib kanakun kaimaw nakun sa lamesa! ");
INSERT INTO krj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tungud nga ang Anak kang Tawo mapatay gid suno sa natalana run, pero makaluluoy gid ang madangatan kang tawo nga magaluib kana!” ");
INSERT INTO krj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pagkabati nanda ka dya, nag-umpisa sanda ka pamangkotanay kon sin-o gid kananda ang magahimo ka dya. ");
INSERT INTO krj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nagbinais-bais ang mga disipulo kon sin-o gid bala kananda ang kilalahun nga labaw sa tanan. ");
INSERT INTO krj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nagkuon si Jesus kananda, “Ang mga hari kang mga bukun ti Judio amo ang nagagahum sa andang mga sinakpan, kag ang mga may awtoridad gusto nga itawgun nga mga ‘Manugbulig kang mga Tawo.’ ");
INSERT INTO krj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero kaninyo tana, bukun ti amo karia. Sa baylo, kon sin-o ang labaw kaninyo tanan, amo ang magpaubus pareho kang libayun, kag kon sin-o ang pangulo amo ang mangin pareho kang surugoon. ");
INSERT INTO krj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tungud hay sin-o bala ang labaw, ang nagapungko kag nagakaun sa may lamesa, ukon ang nagasirbe kana? Indi bala ang nagapungko? Pero ako tana kaimaw ninyo nga nagasirbe.” ");
INSERT INTO krj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kamo amo ang nag-unong kanakun sa mga kalisdanan nga akun gin-agyan. ");
INSERT INTO krj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pareho nga ako gintugyanan kang Amay nga maghari, kamo man ginatugyanan ko nga maghari, ");
INSERT INTO krj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kag magakaun kamo kag magainum kaimaw nakun sa akun lamesa sa akun ginharian. Magapungko kamo sa mga trono sa paghukum kang napulo'g darwa ka mga tribo kang Israel.” ");
INSERT INTO krj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nagkuon si Jesus kay Simon, “Pamati, Simon, nagpangayo si Satanas ka pahanugot nga tirawan na kamo, pareho kang pag-ayag kang trigo nga amo ang pagbulag kang timgas sa upa. ");
INSERT INTO krj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero nagpangamuyo ako para kanimo, Simon, nga ang imong pagtoo indi magluya. Kag kon magpanumbalik run gani ang imong karig-un, parig-unun mo man ang imong mga kabugtoan.” ");
INSERT INTO krj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nagsabat si Pedro, “Ginoo, handa ako mag-imaw kanimo sa prisohan kag bisan sa kamatayun!” ");
INSERT INTO krj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero nagsabat si Jesus, “Sugidan ko ikaw, Pedro, antes magpamalo ang sulog kadya nga gabii ipanginwara mo ako kang tatlo ka beses.” ");
INSERT INTO krj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dayon nagkuon si Jesus kananda, “Kang ginsugo ko kamo anay nga magpanaw nga wara ti dara nga puyo-puyo, libon ukon sandalyas, may nakulang bala kaninyo?” Nagsabat sanda, “Wara gid.” ");
INSERT INTO krj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kag nagkuon si Jesus kananda, “Pero kar-on tana, kon sin-o kaninyo ang may puyo-puyo ukon libon kinahanglan dar-un na dya, kag ang wara ti espada ibaligya na ang ana nga kunup kag magbakal. ");
INSERT INTO krj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sugidan ko kamo, dapat matuman kanakun ang ginakuon sa Kasulatan nga, ‘Ginkabig tana nga isara sa mga malinapasun,’ tungud hay kon ano ang ginakuon sa kasulatan nahanungud kanakun nagakatuman run.” ");
INSERT INTO krj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nagkuon ang mga disipulo, “Ginoo, may darwa kami rugya ka espada.” Nagsabat si Jesus, “Igsakto run ria!” ");
INSERT INTO krj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pareho kang naandan ni Jesus nagwa tana sa syudad kag mag-agto sa Bukid kang mga Olibo. Nag-imaw man kana ang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pag-abot na rugto, nagkuon tana kananda, “Magpangamuyo kamo agud to nga indi kamo madaug kang pagsulay.” ");
INSERT INTO krj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dayon nagparayu-rayu tana gawa kananda kag nag-agto sa uruunahan, kag nagluhod tana kag nagpangamuyo. ");
INSERT INTO krj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nagkuon tana, “Amay, kon pagbuut nimo, bul-a kanakun ang dyang kupa kang pag-antos. Pero bukun ti akun kabubut-un ang matuman kundi ang imo.”  ");
INSERT INTO krj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","May sangka anghel nga naghalin sa langit ang nagpakita kay Jesus kag nagpabakud kana. ");
INSERT INTO krj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tungud sa tuman nga kalisud nga ana ginabatyag, nagpangamuyo pa gid tana kang tuduk sa anang tagipusoon kag ang mga balhas daw mga dugo nga nagatinuro sa lupa. ");
INSERT INTO krj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatapos ka pangamuyo ni Jesus nagtindug tana kag nagbalik sa anang mga disipulo kag naabotan na sanda nga nagakaturog tungud sa sobra nga kasubu. ");
INSERT INTO krj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nagkuon si Jesus kananda, “Andut nga nagaturog kamo? Bangon kamo kag magpangamuyo agud to nga indi kamo madaug kang pagsulay.” ");
INSERT INTO krj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Samtang nagahambal pa si Jesus nag-abot ang sangka hubun kang mga tawo, nga ginapangunahan ni Judas, nga isara sa napulo'g darwa ka mga disipulo. Nagparapit tana kay Jesus sa pagharuk kana. ");
INSERT INTO krj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero nagkuon si Jesus kana, “Judas, pagaluiban mo bala ang Anak kang Tawo paagi sa haruk?” ");
INSERT INTO krj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kang makita kang mga disipulo nga imaw ni Jesus kon ano run ang matabo, nagkuon sanda, “Ginoo, ipanglabuon bala namun sanda kang amun mga espada?” ");
INSERT INTO krj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kag ang isara kananda ginlabo na ang surugoon kang Pinakamataas nga Pari kag nautas gid ang tuo na nga talinga ka dya. ");
INSERT INTO krj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero nagkuon si Jesus, “Husto run ria!” Kag dayon gintandug na ang talinga kang tawo kag gin-ayad dya. ");
INSERT INTO krj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dayon nagkuon si Jesus sa mga pangulo kang kaparian kag sa mga gwardya kang Templo kag sa mga kamal-aman kang mga Judio nga nag-agto rugto sa pagdakup kana, “Buyung ako haw nga kinahanglan pa ninyo nga magdara kang mga espada kag ralampus sa pagdakup kanakun? ");
INSERT INTO krj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaimaw ninyo ako adlaw-adlaw sa Templo pero wara man ninyo ako pagdakpa. Ugaring inyo dya nga tion, kag amo man dya ang tion nga magagahum ang kadulum.” ");
INSERT INTO krj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dayon gindakup nanda si Jesus kag gindara sa balay kang Pinakamataas nga Pari. Si Pedro nagsunod man pero sa marayu lang. ");
INSERT INTO krj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Rugto sa tunga kang lagwerta kang palasyo nagdabok sanda kag nagpurungko. Si Pedro nagpungko man kaimaw nanda. ");
INSERT INTO krj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","May sangka surugoon nga bayi nga nakakita kay Pedro nga nagapungko marapit sa may kalayo. Ginhimutadan na ka mayad si Pedro kag nagkuon, “Ang dya nga tawo kaimaw man kang tawo nga to!” ");
INSERT INTO krj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ginpanginwara dya ni Pedro, “Inday, indi takun ka kilala kana!” ");
INSERT INTO krj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Burubuhay may sangka laki man nga nakakita kay Pedro, kag nagkuon, “Isara man ikaw kananda!” Pero nagsabat si Pedro, “To, bukun takun!” ");
INSERT INTO krj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","May sangka oras ang nagligad kag may sangka tawo liwan nga nagainsister nga nagakuon, “Wara gid ti pangduha-duha nga ang tawo nga dya imaw kang tawo nga to, tungud hay Galileanhun man tana!” ");
INSERT INTO krj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero nagsabat si Pedro kana, “To, wara gid takun kamaan kon ano ang imong ginapanghambal!” Kag lagi-lagi, samtang nagahambal pa si Pedro, namalo ang sulog. ");
INSERT INTO krj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nagbalikid ang Ginoo kag ginturuk si Pedro. Dayon nadumduman ni Pedro ang mga ginkuon kang Ginoo kana, “Antes magpamalo ang sulog kadya nga gabii, ipanginwara mo ako kang makatlo ka beses.” ");
INSERT INTO krj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kag nagwa si Pedro nga nagahiribiun ka mayad. ");
INSERT INTO krj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kar-on, ginayaguta kag ginabunal si Jesus kang mga tawo nga nagagwardya kana. ");
INSERT INTO krj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ginpuyungan nanda tana kag pamangkoton, “Lat-a kon sin-o ang nagtampa kanimo!” ");
INSERT INTO krj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kag duro pa gid ang andang mga ginpanghambal nga pagyaguta kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkaaga, nagsapol ang mga katapo kang konseho nga amo ang mga kamal-aman, ang mga pangulo kang kaparian, kag ang mga manunudlo kang Kasugoan. Kag gindara nanda si Jesus kag ginpaatubang sa konseho. ");
INSERT INTO krj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nagkuon sanda kana, “Sugidi kami, kon bala ikaw amo ang Cristo.” Pero nagsabat si Jesus, “Bisan sugidan ko kamo indi man kamo gihapon magpati, ");
INSERT INTO krj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kag kon pamangkoton ko kamo indi man kamo magsabat. ");
INSERT INTO krj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero umpisa kadya, ang Anak kang Tawo magapungko run sa tuo nayon kang makagagahum nga Dios.” ");
INSERT INTO krj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kag nagkuon sanda tanan kana, “Kon amo, Anak ikaw gali kang Dios?” Nagsabat tana kananda, “Kamo mismo ang nagkuon nga ako amo ria.” ");
INSERT INTO krj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kag nagkuon sanda, “Ti, ano pa nga mga pamatuod ang atun kinahanglan? Nabatian run natun mismo sa anang kaugalingun nga ba-ba ang anang ginkuon!” ");
INSERT INTO krj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dayon nagtindug ang bilog nga katapo kang konseho kag gindara nanda si Jesus kag ginpaatubang kay Pilato. ");
INSERT INTO krj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Rugto nag-umpisa sanda ka akusar kana nga nagakuon, “Nadakpan namun ang tawo nga dya nga ginahaylo na ang amun mga kasimanwa nga magpakigbato kontra sa gobyerno, kag ginadili na ang pagbayad kang buwis sa emperador kang Roma, kag ginakuon na nga tana amo ang Cristo, nga sangka hari!” ");
INSERT INTO krj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ginpamangkot tana ni Pilato, “Ikaw bala ang hari kang mga Judio?” Nagsabat si Jesus, “Ginhambal mo run!” ");
INSERT INTO krj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gani nagkuon si Pilato sa mga pangulo kang kaparian kag sa mga tawo rugto, “Wara ako ti nakita nga sala sa tawo nga dya.” ");
INSERT INTO krj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero nagpamirit pa gid sanda nga nagakuon, “Paagi sa anang mga ginapanudlo ginahaylo na ang mga tawo sa bilog nga Judea nga manggamo. Nag-umpisa tana sa Galilea kag kar-on nakalambot run rugya!” ");
INSERT INTO krj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kang mabatian dya ni Pilato, nagpamangkot tana kananda kon si Jesus taga-Galilea. ");
INSERT INTO krj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kag kang naman-an na nga naghalin si Jesus sa lugar nga nasakpan kang pagdumarahan ni Herodes, ginpadara na si Jesus kay Herodes nga sa amo man to nga tion rugto sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nalipay gid si Herodes pagkakita na kay Jesus, tungud hay nabatian na run ang nahanungud kana, kag buhay run gid ang anang handum nga makita si Jesus. Nagalaum si Herodes nga makita na nga maghimo si Jesus kang mga milagro. ");
INSERT INTO krj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gani ginpamangkot ni Herodes si Jesus kang duro nga mga pamangkot, pero wara gid magsabat si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ang mga pangulo kang kaparian kag ang mga manunudlo kang Kasugoan nagtirindug kag gin-akusar nanda si Jesus kang tam-an ka bug-at nga mga akusasyon. ");
INSERT INTO krj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ginmulay kag ginyaguta ni Herodes kag kang anang mga suldado si Jesus; dayon ginpasuksokan nanda tana kang manami nga panaptun kag ginpadara pabalik kay Pilato. ");
INSERT INTO krj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sa amo gid to nga adlaw si Pilato kag si Herodes nag-amigohay, tungud hay kato anay kontrahanay sanda nga darwa. ");
INSERT INTO krj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dayon ginpatawag ni Pilato ang mga pangulo kang kaparian kag ang mga manugdumara kag ang mga katawhan. ");
INSERT INTO krj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kag nagkuon tana kananda, “Gindara ninyo dya nga tawo kanakun tungud hay kuon ninyo ginapatalang na ang katawhan. Gin-usisa nakun tana sa atubangan ninyo mismo, kag wara gid ako ti nakita nga sala bisan isara sa inyo mga akusasyon kontra kana. ");
INSERT INTO krj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Amo man si Herodes, wara gid tana ti nakita nga sala sa tawo nga dya, tungud hay ginpabalik na tana rugya kanatun. Ang tawo nga dya wara ti sala nga nahimo agud nga sintensyahan kang kamatayun. ");
INSERT INTO krj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ipahanot nakun tana kag pagkatapos hilwayun.”  ");
INSERT INTO krj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kada pista kinahanglan gid nga maghilway si Pilato kang sangka priso para sa katawhan. ");
INSERT INTO krj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero ang katawhan nagasinggitan, “Patyun tana! Si Barabas amo ang imo hilwayun para kanamun!” ( ");
INSERT INTO krj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabas nga dya napriso tungud sa sala nga pagpakigbato kontra sa gobyerno nga ginhimo na sa syudad kag tungud man sa sala nga pagpatay.) ");
INSERT INTO krj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gusto tana ni Pilato nga buy-an si Jesus, gani naghambal tana liwan sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero nagsinggitan sanda, “Ilansang tana sa kros! Ilansang tana sa kros!” ");
INSERT INTO krj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sa ikatlo nga bes nagkuon si Pilato kananda, “Wanhaw? Ano ang nahimo na nga sala? Wara man ako ti nakita nga sala kana nga nagakadapat tana ipatyun. Ipahanot lang nakun tana, kag pagkatapos buy-an.” ");
INSERT INTO krj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero tudo pa gid ang andang singgit nga nagapamirit nga ilansang si Jesus sa kros. Kag sa urihi nagdaug gid man ang andang ginasinggitan. ");
INSERT INTO krj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gani nagpapanaog si Pilato kang anang pamatbat nga anda ginapangayo. ");
INSERT INTO krj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ginbuy-an na ang tawo nga andang ginapangayo nga napriso tungud sa sala nga pagpakigbato kontra sa gobyerno kag pagpatay. Pero si Jesus tana gintugyan na kananda agud to nga himoon nanda ang andang gusto himoon kana. ");
INSERT INTO krj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kar-on, gindara nanda si Jesus pagwa sa syudad, kag nasug-alaw nanda ang sangka tawo nga naghalin sa uma nga nagapasulud sa syudad nga ginahingaranan kay Simon nga taga-Cirene. Ginhawidan nanda tana kag gintungtong ang kros sa anang abaga kag papas-an kana nga nagasunod kay Jesus. ");
INSERT INTO krj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tama gid ka duro nga mga tawo ang nagsurunod kay Jesus. Imaw man ang mga kababainhan nga nagaparanangisun kag nagaparanambutin tungud kana. ");
INSERT INTO krj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ginbalikid sanda ni Jesus kag ginkun-an, “Kamo nga mga bayi nga taga-Jerusalem, indi kamo maghibi para kanakun. Ang inyo kaugalingun kag inyo mga kabataan ang inyo hibian. ");
INSERT INTO krj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tungud hay magaabot ang adlaw nga magakuon ang mga tawo, ‘Bulahan ang mga bayi nga indi makapamata, kag ang mga wara gid makapamata, kag ang wara makapasuso.’ ");
INSERT INTO krj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa amo man to nga mga adlaw magakuon ang mga tawo sa mga bukid nga, ‘Tiphagi kami!’ kag magakuon sa mga bakulod nga, ‘Taboni kami!’ ");
INSERT INTO krj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tungud hay kon amo dya ang anda ginahimo kanakun nga wara ti sala, sobra pa gid ang himoon nanda sa tawo nga may sala.” ");
INSERT INTO krj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","May darwa man ka tawo nga mga kriminal nga gindara nanda agud patyun imaw ni Jesus. ");
INSERT INTO krj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kang pag-abot nanda sa lugar nga ginatawag “Bagol” rugto nanda tana ginlansang sa kros, kag amo man ang darwa ka kriminal, ang isara sa tuo nayon ni Jesus kag ang isara tana sa anang wala.  ");
INSERT INTO krj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Naghambal si Jesus, “Amay, patawara sanda hay wara sanda kamaan kang andang ginahimo!”  Ang mga suldado tana naggabot-gabot sa paghururay kang anang mga bayo. ");
INSERT INTO krj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ang mga tawo rugto nagatirindug lang kag nagalantaw samtang ginayaguta si Jesus kang mga pangulo kang mga Judio, nga nagakuon, “Ginluwas na ang iba; luwasun na man ang anang kaugalingun kon tana amo ang Cristo, ang pinili kang Dios!” ");
INSERT INTO krj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ginyaguta man si Jesus kang mga suldado. Nagparapit sanda kana kag gintungholan nanda tana kang langgaw, ");
INSERT INTO krj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nga nagakuon, “Luwasa ang imo kaugalingun kon ikaw ang hari kang mga Judio!” ");
INSERT INTO krj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sa may ulohan nayon ni Jesus may nasulat nga mga pulong, “Amo dya ang Hari kang mga Judio.” ");
INSERT INTO krj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ang isara sa mga kriminal nga nalansang man sa kros, gin-insultohan na si Jesus, “Indi bala ikaw ang Cristo? Luwasa ang imo kaugalingun kag pati kami!” ");
INSERT INTO krj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ginsabdung tana kang isara nga kriminal nga nagakuon, “Wara bala ikaw mahadluk sa Dios? Ginasilotan man ikaw pareho kana. ");
INSERT INTO krj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kita nga darwa nagakadapat lang nga silotan tungud sa atun mga ginhimo, pero ang tawo tana nga dya wara makahimo kang sala!” ");
INSERT INTO krj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kag nagkuon tana kay Jesus, “Jesus, dumduma man ako kon maghari run ikaw!” ");
INSERT INTO krj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nagsabat si Jesus kana, “Sugidan ko ikaw, kadya lagi nga adlaw mangin kaimaw nakun ikaw sa Paraiso!” ");
INSERT INTO krj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kang mga udto adlaw run, nagdulum ang bug-os nga lugar hasta sa alas tres ti hapon, ");
INSERT INTO krj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","tungud hay nag-untat sa pagsirak ang adlaw kag ang kurtina kang templo napihak sa darwa. ");
INSERT INTO krj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dayon nagsinggit si Jesus sa matunog nga limug, “Amay, sa imo mga alima ginatugyan ko ang akun ispirito!” Pagkatapos nga makuon na dya nabugto ang anang ginhawa. ");
INSERT INTO krj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kar-on kang makita kang kapitan kang mga suldado ang natabo nga dya, nagdayaw tana sa Dios kag nagkuon, “Matuod gid nga matarung ang tawo nga dya!” ");
INSERT INTO krj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ang mga katawhan nga nagtiriripon para maglantaw kang dya nga hitabo, kang makita nanda dya, nagparauli sanda nga nagapamukpok kang andang dughan. ");
INSERT INTO krj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero ang tanan nga mga nakakilala kay Jesus kag ang mga bayi nga nagtawas kana halin pa sa Galilea, nagatirindug rugto sa unahan sa pagturuk kang mga nagakaratabo nga dya. ");
INSERT INTO krj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kar-on, may sangka tawo rugto nga ginahingaranan kay Jose nga taga-Arimatea nga sangka banwa kang mga Judio. Mayad tana kag tarahudon nga tawo kag sangka katapo kang konseho, ");
INSERT INTO krj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","pero wara tana nagpasugot sa andang plano kag ginhimo nga pagpatay kay Jesus. Kag nagahulat tana ka dya kang tion nga magahari ang Dios. ");
INSERT INTO krj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ang ginhimo ni Jose, nag-agto tana kay Pilato kag ginpangayo na nga ibul-un ang bangkay ni Jesus sa kros. ");
INSERT INTO krj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Gintaltal na ang bangkay kag ginputos kang tela nga lino kag ginsulud sa rulubngan nga gin-giab sa bato. Ang rulubngan nga dya wara pa gid malubngi. ");
INSERT INTO krj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Byernes kato nga adlaw kag burubuhay karia, Adlaw run nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ang mga kababainhan nga nagtarawas anay kay Jesus halin pa sa Galilea, nagsunod man kay Jose kag nakita nanda ang rulubngan kag kon paano ang pagbutang kang anang bangkay rugto. ");
INSERT INTO krj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dayon nagparauli sanda kag naghanda kang mga pahamot kag inughaplas sa lawas ni Jesus. Pag-abot kang Adlaw nga Inugpahuway, nagpahuway sanda, suno sa ginakuon sa Kasugoan. ");
INSERT INTO krj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aga-aga pa gid kang primero nga adlaw kang semana, ang mga bayi nag-agto sa rulubngan nga nagadara kang andang ginhanda nga mga pahamot. ");
INSERT INTO krj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pag-abot nanda rugto, nakita nanda nga ginpaligid run ang bato nga gintakup sa gawang kang rulubngan. ");
INSERT INTO krj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pero kang pagsulud nanda, wara nanda makita ang bangkay ni Ginoong Jesus. ");
INSERT INTO krj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Samtang natingala sanda nahanungud sa mga butang nga dya, hinali lang nga may nagtindug nga darwa ka laki sa ingud nanda, nga nagabayo kang makasirilaw. ");
INSERT INTO krj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gindakup sanda kang kahadluk kag nagkuub run lang sanda. Naghambal ang darwa ka laki kananda, “Andut nga ginapangita ninyo ang buhi rugya sa mga patay? ");
INSERT INTO krj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wara tana rugya. Nabanhaw tana run! Panumduma ninyo ang anang ginkuon kaninyo kang rugto pa tana sa Galilea, ");
INSERT INTO krj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nga ang Anak kang Tawo kinahanglan itugyan sa alima kang mga tawo nga makasasala, igalansang nanda tana sa kros, pero sa ikatlo nga adlaw mabanhaw tana.” ");
INSERT INTO krj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kag nadumduman kang mga bayi ang mga ginpanghambal ni Jesus. ");
INSERT INTO krj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pagkapauli nanda halin sa rulubngan ginsugid nanda ang tanan nga mga butang nga dya sa napulo'g isara ka mga disipulo kag sa iba pa nga mga kaimaw nanda. ");
INSERT INTO krj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ang mga kababainhan nga to amo sanday Maria Magdalena, Juana kag Maria nga nanay ni Santiago. Sanda ka dya kag ang iba pa nga mga kababainhan amo ang nagpanugid kang mga butang nga dya sa mga apostoles. ");
INSERT INTO krj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero abi kang mga apostoles nga lango-lango lang ang mga ginapanghambal kang mga bayi, gani nga wara sanda magpati. ");
INSERT INTO krj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero si Pedro tana nagtindug kag magdalagan paagto sa rulubngan. Pag-abot na rugto, nagkuub tana kag naglingling kag wara tana ti iba nga nakita magluwas lang sa panaptun nga lino. Gani nag-uli tana nga natingala kon ano ang natabo. ");
INSERT INTO krj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sa amo gid to nga adlaw, ang darwa sa mga disipulo ni Jesus nagapanaw paagto sa baryo nga ginatawag Emaus - mga napulo'g isara ka kilometro ang karayuun na ka dya sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nagaistoryahanay sanda ka dya nga darwa nahanungud sa tanan nga mga butang nga nagkaratabo. ");
INSERT INTO krj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Samtang nagaistoryahanay sanda, si Jesus mismo nagparapit kag nag-imaw kananda sa pagpanaw. ");
INSERT INTO krj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nakita man nanda tana, pero wara nanda tana makilala. ");
INSERT INTO krj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ginpamangkot sanda ni Jesus, “Ano bala ang ginaistoryahan ninyo nga darwa samtang nagapanaw kamo?” Nagduyu sanda nga masinurub-un ang andang pungyahun. ");
INSERT INTO krj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ang isara kananda nga ginahingaranan kay Cleopas nagkuon kay Jesus, “Daw ikaw lang bay siguro ang dumaray-o rugya sa Jerusalem nga wara makamaan kang mga nagkaratabo sa kadya nga mga inadlaw.” ");
INSERT INTO krj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Namangkot liwan si Jesus, “Nahanungud sa ano nga mga butang?” Nagsabat ang darwa, “Ang mga natabo nahanungud kay Jesus nga taga-Nazaret, nga sangka propeta nga gamhanan sa pulong kag sa buhat, sa atubang kang Dios kag sa tawo. ");
INSERT INTO krj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gintugyan tana kang amun mga pangulo kang kaparian kag kang mga manugdumara agud sintensyahan kang kamatayun kag ginlansang nanda tana sa kros. ");
INSERT INTO krj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nagalaum daad kami nga tana amo ang magahilway sa Israel. Magluwas pa dyan karia, amo run dya ang ikatlo nga adlaw halin nga natabo ang mga butang nga dya. ");
INSERT INTO krj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kag natingala pa gid kami sa ginkuon kang mga bayi nga imaw namun. Tungud hay aga pa gid nga nag-agto sanda sa rulubngan, ");
INSERT INTO krj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero wara nanda makita ang bangkay ni Jesus. Kag nagpauli sanda nga nagakuon nga may mga anghel kuno sanda nga nakita nga nagkuon kananda nga buhi si Jesus. ");
INSERT INTO krj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ang iba sa amun mga kaibahan nag-agto man sa rulubngan, kag kon ano ang ginsugid kang mga bayi amo man ang andang nakita, pero wara nanda makita si Jesus rugto.” ");
INSERT INTO krj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pagkatapos, nagkuon si Jesus kananda, “Mga mango kamo! Andut nga indi lagi kamo magpati sa mga ginkuon kang mga propeta! ");
INSERT INTO krj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Indi bala nga kinahanglan mag-antos anay ang Cristo kang dya nga mga butang antes na maangkun ang anang himaya?” ");
INSERT INTO krj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kag ginpaathag ni Jesus kananda ang tanan nga ginakuon sa Kasulatan nahanungud sa anang kaugalingun, umpisa sa mga libro nga sinulat ni Moises hasta sa tanan nga mga sinulat kang mga propeta. ");
INSERT INTO krj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kang nagahinamput run sanda sa baryo nga anda pagaagtonan, nagpakita si Jesus nga daw sa magapadayon lang tana sa pagpanaw. ");
INSERT INTO krj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero ginhawidan nanda tana nga nagakuon, “Imaw run lang ikaw kanamun, tungud hay sirum run, kag burubuhay gabii run.” Gani nagdayon tana sa balay imaw kananda. ");
INSERT INTO krj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kang kaimaw nanda tana sa lamesa, nagbuul tana kang tinapay kag nagpasalamat sa Dios, kag dayon ginpamihak-pihak na dya kag gintugro kananda. ");
INSERT INTO krj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amo to kag nakamaradmad sanda kag nakilala nanda tana, pero nadura tana sa andang panuruk. ");
INSERT INTO krj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nagkinun-anay sanda nga darwa, “Amo gali to nga kanami kang atun pamatyag samtang nagapakighambal tana kanatun sa may dalanun kag nagapaathag kang kasulatan kanatun!” ");
INSERT INTO krj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nagtindug sanda dayon kag nagpanaw pabalik sa Jerusalem. Naabotan nanda rugto ang napulo'g isara ka mga disipulo nga nagatiriripon kag ang iba pa gid nanda nga mga kaibahan ");
INSERT INTO krj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","nga nagakuon, “Matuod gid nga nabanhaw ang Ginoo! Nagpakita tana kay Simon!” ");
INSERT INTO krj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dayon ginsugid man kang darwa nga dya ang natabo kananda sa may dalanun, kag kon paano nga nakilala nanda si Jesus paagi sa pagpamihak-pihak na kang tinapay. ");
INSERT INTO krj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Samtang nagahambal pa sanda nahanungud ka dya, hinali lang nga nagtindug si Jesus sa tunga nanda kag nagkuon kananda, “Ang kalinung mangin rugyan kaninyo!” ");
INSERT INTO krj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nangusyan sanda kag nahadluk tungud hay abi nanda murto ang anda nga nakita. ");
INSERT INTO krj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero nagkuon tana kananda, “Andut bala nga natublag kamo, kag andut nga nagapangduha-duha kamo? ");
INSERT INTO krj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sulnga ninyo ang akun mga alima kag mga kahig; ako gid dya! Hikapa ninyo ako kag maman-an ninyo, tungud hay ang murto tana wara ti kusug kag tul-an, akun tana may kusug kag tul-an takun nga makita ninyo.” ");
INSERT INTO krj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pagkakuon na ka dya ginpakita na kananda ang anang mga alima kag kahig. ");
INSERT INTO krj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Indi gihapon sanda makapati tungud sa andang kalipay kag katingala. Dayon nagpamangkot si Jesus kananda, “May pagkaun kamo rugya?” ");
INSERT INTO krj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gintugroan nanda tana kang sinugba nga isda. ");
INSERT INTO krj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ginbuul na dya kag ginkaun samtang nagasulung sanda kana. ");
INSERT INTO krj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dayon nagkuon tana kananda, “Amo run dya nga mga butang ang akun ginkuon kaninyo katong kaimaw pa ninyo ako, nga ang tanan nga nasulat nahanungud kanakun sa kasugoan ni Moises kag sa mga sinulat kang mga propeta, kag sa mga Salmo kinahanglan nga matuman gid.” ");
INSERT INTO krj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dayon, ginbuksan ni Jesus ang andang panghuna-huna agud to nga mahangpan nanda ang kasulatan. ");
INSERT INTO krj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nagkuon tana kananda, “Amo dyaay ang ginakuon sa Kasulatan: ang Cristo kinahanglan nga mag-antos kag sa ikatlo nga adlaw mabanhaw halin sa mga minatay. ");
INSERT INTO krj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Paagi sa anang ngaran, ang paghinulsul kag ang pagpatawad kang sala kinahanglan iwali sa tanan nga nasyon, umpisa sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo amo ang mga manugpamatuod sa mga butang nga dya. ");
INSERT INTO krj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ako mismo ang magapadara kaninyo kang ginsaad kang akun Amay. Pero indi anay kamo maghalin rugya sa Jerusalem, hasta nga maaaguman ninyo ang gahum nga magahalin sa langit.” ");
INSERT INTO krj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagkatapos ka dya, gindara na sanda sa gwa kang syudad hasta sa may Betania, kag ginbayaw na ang anang mga alima kag ginbindisyonan na sanda. ");
INSERT INTO krj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Samtang ginabindisyonan na sanda, nagpahamulag tana kananda kag gindara tana palangit. ");
INSERT INTO krj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dayon ginsimba nanda tana, kag nagbalik sanda sa Jerusalem nga tuman ang andang kalipay, ");
INSERT INTO krj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","kag pirme gid sanda sa Templo nga nagadayaw sa Dios.");
INSERT INTO krj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sa umpisa, kang wara pa matuga ang tanan, ang Pulong dyan run nga daan. Ang Pulong nga dya kaimaw kang Dios, kag ang Pulong Dios. ");
INSERT INTO krj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sa umpisa ang Pulong nga dya kaimaw run nga daan kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paagi kana gintuga kang Dios ang tanan. Kon wara tana wara gid ti bisan ano nga tinuga nga natuga. ");
INSERT INTO krj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tana kadya amo ang ginhalinan kang kabuhi, kag ang kabuhi nga dya amo ang nagatugro kang kasanagan sa mga katawhan. ");
INSERT INTO krj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ang kasanag nga dya nagasanag sa kadulum, kag ang kadulum wara gid makadaug sa kasanag. ");
INSERT INTO krj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","May ginpadara ang Dios nga sangka tawo; ang ngaran na kadya amo si Juan. ");
INSERT INTO krj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tana kadya nag-abot para magsugid sa mga katawhan nahanungud sa kasanag, agud to nga paagi sa anang pagsugid ang tanan nga tawo magatoo. ");
INSERT INTO krj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bukun ti si Juan ang kasanag. Nag-abot tana para magsugid nahanungud sa kasanag. ");
INSERT INTO krj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dya amo ang matuod nga kasanag nga nagatugro kang kasanagan sa tanan mga katawhan kag nagaabot run sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nag-abot tana sa kalibutan, kag bisan pa nga ang kalibutan gintuga paagi kana, ang mga katawhan sa kalibutan wara makakilala kana. ");
INSERT INTO krj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nag-abot tana sa anang kaugalingun nga lugar, pero ang anang mga kasimanwa wara magbaton kana. ");
INSERT INTO krj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ang mga nagbaraton tana kana, sanda nga mga nagtoroo kana, gintaw-an na kang kinamatarung nga mangin kabataan kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nangin kabataan sanda kadya kang Dios, indi sa kinaandan nga pamaagi ukon sa tawhanun nga pagbuut, kundi suno gid lang sa pagbuut kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ang Pulong nangin tawo kag nag-istar kaimaw natun. Wara gid ti nakulang sa anang pagkamaalwan, kag tana ang nagapahayag kang bug-os nga kamatuoran nahanungud sa Dios. Nakita namun ang anang pagkagamhanan—ang anang pagkagamhanan bilang Bugtong nga Anak kang Amay. ");
INSERT INTO krj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Juan nagsugid nahanungud sa Pulong. Naghambal tana ka tunog gid, “Tana kadya ang akun ginatumud kang maghambal ako nga, ‘Ang tawo nga nagasunod kanakun mas gamhanan sangsa kanakun tungud nga wara pa ako matawo dyan run tana nga daan.’” ");
INSERT INTO krj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tama gid kabugana kang anang kaluoy gani nga kita tanan wara gid ti untat ang atun pagbaton kang anang bugay nga ginapasagahay kanatun. ");
INSERT INTO krj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ang kasugoan gintugro kang Dios paagi kay Moises kauna; pero paagi kay Jesu-Cristo ginpakita kang Dios kon daw ano tana ka maalwan kag ginpahayag na man ang kamatuoran nahanungud sa anang kauagalingun. ");
INSERT INTO krj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wara gid ti bisan sin-o nga nakakita sa Dios. Pero ang Bugtong nga Anak kang Dios nga ginahigugma na gid kamayad kag tana mismo Dios man amo ang nagpahayag kanatun nahanungud sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kar-on, amo dya ang ginsugid ni Juan kang ang mga pangulo kang mga Judio sa Jerusalem magsugo kang mga pari kag mga Levita nga mag-agto kana agud pamangkoton kon sin-o gid tana. ");
INSERT INTO krj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wara gid mangalag-ag si Juan sa pagsabat kananda, kundi nga ginsugid na kon ano ang matuod. Ginhambal na kananda nga, “Bukun ti ako ang Cristo.” ");
INSERT INTO krj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Namangkot ruman sanda kana, “Ti, kon amo, sin-o bay ikaw? Ikaw bala si Elias?” Nagsabat si Juan, “Bukun takun si Elias.” “Ah ti siguro ikaw ang propeta nga amun ginapaabot ay.” Kag nagsabat ruman si Juan, “Bukun!” ");
INSERT INTO krj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kang urihi nagkuon sanda kana, “Sin-o gid ikaw bay? Sugidi abi kami agud to nga may isabat kami sa mga nagsugo kanamun. Ano ang imo mahambal parte sa imong kaugalingun?” ");
INSERT INTO krj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ginsabat sanda ni Juan kang mga tinaga nga ginhambal ni Isaias kauna, “Ako ang nagasinggitan sa may kamingawan nga nagakuon sa katawhan, ‘tadlunga ninyo ang dalan nga pagaagyan kang Ginoo.’” ");
INSERT INTO krj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ang mga tawo nga dya nga ginsugo kang mga Fariseo, ");
INSERT INTO krj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nagpamangkot pa gid kay Juan, “Ti, kon bukun ikaw ang Cristo ukon si Elias kag bukun man ikaw ang propeta, andut nga nagapangbawtiso ikaw haw?” ");
INSERT INTO krj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nagsabat si Juan kananda, “Ako nagapangbawtiso sa tubig. Pero dyan sa inyo tunga may sangka tawo nga wara ninyo makilala. ");
INSERT INTO krj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Amo dya tana ang magasunod kanakun nga bisan pa gani ang paghubad kang higot kang anang sandalyas indi ako takus.” ");
INSERT INTO krj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dya tanan natabo sa Betania, rugto sa pihak kang suba kang Jordan nga sa diin si Juan nagapangbawtiso. ");
INSERT INTO krj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kang masunod nga adlaw nakita ni Juan si Jesus nga nagapaagto kana. Nagkuon tana kadya, “Sulnga ninyo, dyaay ang karnero kang Dios nga nagabuul kang kasal-anan kang mga katawhan sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amo dya tana ang akun ginatumud kang maghambal ako nga, ‘May sangka tawo nga nagasunod kanakun nga mas gamhanan sangsa kanakun tungud nga wara pa ako matawo dyan run tana nga daan.’ ");
INSERT INTO krj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ako mismo wara makakilala kana. Amo ria nga nagapangbawtiso ako sa tubig agud to nga sa amo dya nga paagi mapahayag tana sa mga Israelenhun.” ");
INSERT INTO krj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kag ginsugid ni Juan ang anang nakita, “Nakita ko ang Balaan nga Ispirito nga nagkunsad nga daw pating halin sa langit kag nagtiner kana. ");
INSERT INTO krj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Wara ko tana makilala kang primero, pero ang Dios nga amo ang nagsugo kanakun sa pagpangbawtiso sa tubig nagkuon nga daan kanakun nga, ‘ang tawo nga imo makita nga sa diin magakunsad kag magapabilin kana ang Balaan Ispirito, amo dya tana ang magapangbawtiso sa mga tawo kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nakita ko gid dya kag nagasugid ako nga tana ang Anak kang Dios.’” ");
INSERT INTO krj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kang masunod nga adlaw kato, rugyan ruman si Juan imaw kang darwa na ka mga disipulo. ");
INSERT INTO krj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kang makita na si Jesus nga nagalubas, nagkuon si Juan, “Dyaay ang karnero kang Dios!” ");
INSERT INTO krj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kang mabatian tana kang darwa na ka disipulo nga naghambal kang amo dya, nagsunod sanda kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nagbalikid si Jesus kag nakita na nga nagasunod sanda kana. Nagkuon tana kananda, “Maiwan raad kamo?” Nagsabat sanda, “Rabbi, sa diin ikaw nagaistar?” (Ang gusto hambalun kang tinaga nga Rabi, “Maestro.”) ");
INSERT INTO krj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nagkuon si Jesus, “Dali bala kamo, kag makita ninyo.” Amo to kag nagtawas sanda kana kag nakita nanda ang anang ginaistaran, kag nag-imaw sanda kana kang adlaw nga to. Mga alas kwatro run to ti hapon. ");
INSERT INTO krj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres nga bugto ni Simon Pedro isara sa darwa nga nakabati sa ginhambal ni Juan kag nagsunod kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ang una nga ginhimo ni Andres ginsagap na ang anang bugto nga si Simon, kag kang nakita na si Simon nagkuon tana kadya, “Nakita run namun ang Mesias!” (Ang gusto hambalun kang tinaga nga dya Cristo.) ");
INSERT INTO krj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Amo to kag gindara ni Andres si Simon kay Jesus. Ginturuk ni Jesus si Simon kag nagkuon, “Ikaw si Simon nga bata ni Juan. Pagatawgun run ikaw kadya nga Cefas.” (Ang ngaran nga Cefas pareho man kang Pedro, nga kon sayudon bato.) ");
INSERT INTO krj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kang masunod nga adlaw, nagpamat-ud si Jesus nga mag-agto sa probinsya kang Galilea. Nakita na rugto si Felipe kag ginkun-an na dya, “Sunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe nga dya pareho man nanday Andres kag Pedro nga taga-Betsaida. ");
INSERT INTO krj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kang makita ni Felipe si Natanael ginkun-an na dya nga, “Nakita namun ang tawo nga amo ang ginatumud ni Moises sa anang sinulatan sa Kasugoan, kag amo man ang ginatumud kang mga propeta sa andang mga sinulat. Tana amo si Jesus nga taga-Nazaret, nga bata ni Jose!” ");
INSERT INTO krj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nagsabat si Natanael, “May mayad bala haw nga magahalin sa banwa kang Nazaret?” Kag nagkuon si Felipe kana, “Dali bala kag sulnga.” ");
INSERT INTO krj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kang makita ni Jesus si Natanael nga nagapaagto kana, nagkuon tana nahanungud kay Natanael, “Dyaay ang matuod-tuod nga Israelenhun nga wara gid pagpangloko!” ");
INSERT INTO krj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nagkuon si Natanael kay Jesus, “Paano mo ako nakilala man?” Nagsabat si Jesus kana, “Antes ikaw itawgun ni Felipe, nakita ko run ikaw rugto sa may idalum kang kahoy nga higera.” ");
INSERT INTO krj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kag nagkuon si Natanael, “Maestro, ikaw ang Anak kang Dios! Ikaw ang Hari kang Israel!” ");
INSERT INTO krj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nagkuon si Jesus kana, “Nagtoo ikaw tungud nga nagkuon ako kanimo nga nakita ko ikaw rugto sa may idalum kang kahoy nga higera. Mas makatiringala pa gid nga mga butang sangsa dya ang imo makita.” ");
INSERT INTO krj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kag nagkuon pa gid si Jesus kananda, “Sugidan ko kamo: makita ninyo nga magabukas ang langit kag makita man ninyo ang mga anghel kang Dios nga nagasaka-panaog sa Anak kang Tawo!” ");
INSERT INTO krj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagkaligad kang darwa ka adlaw, may ginhiwat nga kasal sa banwa kang Cana, sa probinsya kang Galilea. Rugto kato ang nanay ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Jesus kag ang anang mga disipulo gin-agda man sa kasal. ");
INSERT INTO krj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kag natabo nga naubos ang bino. Dayon nagkuon ang nanay ni Jesus kana, “Naubosan sanda kang bino.” ");
INSERT INTO krj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nagsabat si Jesus, “Indi mo run kinahanglan nga hambalan pa ako kang akun dapat himoon. Wara pa bay mag-abot ang akun tion?” ");
INSERT INTO krj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dayon nagkuon ang nanay ni Jesus sa mga surugoon, “Himoa lang ninyo ang bisan ano nga anang ikuon.” ");
INSERT INTO krj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ang mga Judio may pagsurondan sa andang relihiyon parte sa paghugas kang alima kag kahig, gani nga may nabutang rugto kato nga anum ka tadyaw nga bato kag ang kada tadyaw sarang masudlan kang darwa ka napulo hasta tatlo ka napulo ka galon nga tubig. ");
INSERT INTO krj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nagkuon si Jesus sa mga surugoon, “Abi, butaa ninyo ka tubig ang mga tadyaw nga dya.” Kag anda dya nga ginbuta hasta sa may bibig. ");
INSERT INTO krj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dayon nagkuon pa gid si Jesus kananda, “Kar-on, sarok kamo kag dar-un sa manugdumara kang punsyon.” Kag ginhimo nanda dya. ");
INSERT INTO krj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gintirawan kang manugdumara kang punsyon ang tubig nga nangin bino run. Wara tana kamaan kon diin dya maghalin (pero ang mga surugoon tana nga nagsarok nakamaan). Amo to kag gintawag kang manugdumara ang nobyo ");
INSERT INTO krj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kag nagkuon tana, “Ang naman-an ko, ang manamit nga bino amo ang una nga ginapagwa kag ginapainum sa mga dinapit nga bisita, kag kon duro run gani ang andang nainum, amo run to ang pagpagwa kang ordinaryo nga klase ka bino. Pero ikaw tana, hasta kadya may ginapagwa pa ikaw nga manamit nga bino.” ");
INSERT INTO krj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Amo dya ang primero gid nga milagro nga ginhimo ni Jesus. Natabo dya sa banwa kang Cana sa Galilea. Sa ginhimo na nga dya, ginpahayag na ang anang pagkagamhanan, kag ang anang mga disipulo nagtoroo kana. ");
INSERT INTO krj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatapos ka dya, nagdulhog si Jesus sa Capernaum, imaw kang anang nanay kag mga bugto kag kang anang mga disipulo. Kag nagtiner sanda rugto kang may pira ka adlaw. ");
INSERT INTO krj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pira run lang ka adlaw kag Pista run kang Paglampuwas gani nagtukad si Jesus sa syudad kang Jerusalem. ");
INSERT INTO krj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kang pag-agto na sa may templo, naabotan na rugto ang mga tawo nga nagabaligya kang mga baka, mga karnero, kag mga pating, kag rugto man ang mga nagapangbaylo kang kwarta sa andang mga pwesto. ");
INSERT INTO krj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ang ginhimo ni Jesus, nagbuul tana kang lubid kag ginhimo nga haranot, kag gintabog na sanda tanan, pati ang mga karnero kag mga baka. Ginpangwas-ag na ang mga kwarta kang mga manugbaylo kang kwarta kag ginpamaliskad ang andang mga lamesa. ");
INSERT INTO krj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dayon nagkuon tana sa mga nagabaligya kang mga pating, “Pamul-a ninyo dya tanan! Indi ninyo paghimoon nga baraligyaan ang balay kang akun Amay!” ");
INSERT INTO krj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nadumduman kang anang mga disipulo ang ginakuon sa kasulatan nga, “Ang akun tuman nga pagkabalaka sa imong balay amo ang magapatay kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dayon nagkuon kana ang mga pangulo kang mga Judio, “Ano haw nga katingalahan ang imo mapakita kanamun bilang paratandaan nga may poder ikaw sa paghimo ka dya?” ");
INSERT INTO krj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nagsabat si Jesus kananda, “Gub-a ninyo ang templo nga dya kag tukodon ko liwan sa sulud kang tatlo ka adlaw!” ");
INSERT INTO krj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nagsabat ang mga Judio, “Araw-araw ta man ka imo nga ria! Gintukod ang dya nga templo sa sulud kang kap-atan kag anum ka tuig; kar-on tukodon mo liwan mo sa sulud lang kang tatlo ka adlaw!” ");
INSERT INTO krj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ang templo tana nga ginatumud ni Jesus amo ang anang lawas. ");
INSERT INTO krj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gani nga kang mabanhaw tana halin sa mga minatay nadumduman kang anang mga disipulo ang ginkuon na nga dya. Kag nagtoo sanda sa ginkuon sa Kasulatan kag sa mga ginkuon nga to ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kang si Jesus rugto sa Jerusalem katong Pista kang Paglampuwas, raku nga mga tawo ang nagtoroo kana tungud kang mga milagro nga andang nakita nga anang ginpanghimo. ");
INSERT INTO krj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero wara na ginbutang ang anang pagsarig kananda, tungud nga kilala na ang tanan nga tawo. ");
INSERT INTO krj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wara run ti kinahanglan nga may magsugid pa kana parte sa tawo tungud hay tana mismo nakamaan gid kon ano ang sa sulud kang andang tagipusoon. ");
INSERT INTO krj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kar-on, may sangka tawo rugto kato nga ginahingaranan kay Nicodemo. Dya tana katapo kang grupo kang mga Fariseo, kag isara man sa mga nagapangulo sa mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sangka gabii kato, nag-agto tana kay Jesus kag nagkuon, “Maestro, nakamaan kami nga ikaw manunudlo nga ginpadara kang Dios, tungud nga wara ti bisan sin-o ang sarang makahimo kang mga makatiringala nga mga butang nga imo ginapanghimo luwas lang kon rugyan kana ang Dios.” ");
INSERT INTO krj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nagsabat si Jesus, “Sugidan ko ikaw: ang sangka tawo makaagum lang kang paghari kana kang Dios kon tana matawo liwan.” ");
INSERT INTO krj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nagkuon si Nicodemo kana, “Paano bay matawo liwan ang sangka tawo kon mal-am run tana? Makabalik pa tana haw sa busong kang anang nanay kag ibataun liwan?” ");
INSERT INTO krj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nagsabat si Jesus kana, “Sugidan ko ikaw: ang sangka tawo makaagum lang kang paghari kana kang Dios kon tana matawo paagi sa tubig kag sa gahum kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ang ginabata paagi sa tawo may tawhanun nga kabuhi, kag ang ginabata paagi sa gahum kang Balaan nga Ispirito may ispiritohanun nga kabuhi. ");
INSERT INTO krj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Indi ikaw magkatingala sa akun ginkuon nga ‘kamo kinahanglan nga matawo liwan.’ ");
INSERT INTO krj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pareho bala kang hangin, nagahuyup dya sa bisan diin na gusto maghuyup. Mabatian mo ang huni na kadya, pero wara mo maman-i kon sa diin dya maghalin ukon sa diin nagapaagto. Amo man karia ang nagakatabo sa tawo nga natawo paagi sa gahum kang Balaan nga Ispirito.” ");
INSERT INTO krj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Namangkot si Nicodemo, “Paano ria matabo bay?” ");
INSERT INTO krj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nagkuon si Jesus kana, “Sangka manunudlo ikaw kang mga Israelenhun, pero andut nga wara ikaw makahangup kang mga butang nga dya? ");
INSERT INTO krj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sugidan ko ikaw: nagahambal kami parte sa mga butang nga amun naman-an, kag kon ano ang amun nakita amo dya ang amun ginasugid, pero bisan amo pa karia wara kamo sa gihapon nagapati kang amun ginasugid. ");
INSERT INTO krj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ginasugidan ko kamo kang nahanungud sa mga butang nga rugya sa kalibutan pero wara kamo nagapati, paano pa kamo bay makapati kon isugidan ko kamo kang mga butang nga langitnun? ");
INSERT INTO krj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wara ti bisan sin-o nga nakasaka sa langit luwas lang sa Anak kang Tawo nga nanaog halin sa langit. ");
INSERT INTO krj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pareho nga ginbayaw ni Moises ang saway nga sawa rugto sa kayanakan kato anay, ang Anak kang Tawo kinahanglan man nga bayawun ");
INSERT INTO krj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agud to nga ang bisan sin-o nga nagatoo kana makaagum kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tungud nga ginhigugma gid ka mayad kang Dios ang katawhan sa kalibutan, gani nga ginpadara na ang anang bugtong nga Anak agud to nga ang bisan sin-o nga magatoo kana indi pagsilotan kang kamatayun kundi nga makaagum kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hay ang Dios wara magpadara kang ana nga Anak sa kalibutan para husgaran nga silotan ang mga katawhan kundi nga paagi sa anang Anak luwasun na ang mga katawhan sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ang bisan sin-o nga nagatoo sa Anak kang Dios indi run paghusgaran nga silotan. Pero ang bisan sin-o nga wara nagatoo nahusgaran run nga silotan tungud nga wara tana nagatoo sa bugtong nga Anak kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Amo dyaay ang rason nga pagasilotan sanda: nag-abot ang kasanag rugya sa kalibutan, pero mas naluyagan pa kang mga katawhan ang kadulum sangsa kasanag tungud nga malaot ang andang mga ginahimo. ");
INSERT INTO krj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ang bisan sin-o nga nagahimo kang malaot nagakaugut sa kasanag, kag nagalikaw dya sa kasanag tungud sa anang kahadluk nga makita ang mga malaot nga anang ginapanghimo. ");
INSERT INTO krj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ang bisan sin-o tana nga nagahimo kang suno sa kamatuoran wara nagapangalag-ag magparapit sa kasanag agud to nga makita ka athag nga ang mayad na nga ginabuhat nahimo na suno gid sa naluyagan kang Dios.” ");
INSERT INTO krj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos kang mga hitabo nga to, si Jesus kag ang anang mga disipulo nag-agto sa probinsya kang Judea. Mga pira ka semana nga nagpabilin tana rugto imaw nanda kag nagpangbawtiso kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan tana, nagapangbawtiso man rugto sa may Enon nga marapit sa Salim tungud hay duro ang tubig rugto. Nagasurunod-sunod nga nagaaragto ang mga tawo kana agud to nga magpabawtiso. ");
INSERT INTO krj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sa amo dya nga mga tinion wara pa mapriso si Juan. ");
INSERT INTO krj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kar-on, ang iba nga mga disipulo ni Juan nagpakigbais sa sangka Judio nahanungud sa pagsurondan sa andang relihiyon parte sa paghugas. ");
INSERT INTO krj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ang mga disipulo ni Juan nag-agto kana kag nagkuon, “Maestro, may tawo anay kabay rugto sa pihak kang Jordan nga ginhambal mo pa gani kanamun ang parte kana? Nagapangbawtiso bala tana kadya, kag haros ang tanan nga tawo nagaaragto kana!” ");
INSERT INTO krj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nagsabat si Juan, “Pabay-i lang ninyo tana. Wara ti bisan sin-o nga makaangkun kang bisan ano nga butang kon indi dya pag-itugro kang Dios kana. ");
INSERT INTO krj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo makapamatuod nga naghambal ako nga bukun ti ako ang Cristo. Ginsugo lang ako kang Dios nga mag-abot una para magpamaan nga tana magaabot. ");
INSERT INTO krj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pareho bala kon may kasal. Ang nobya para lang sa nobyo. Ang amigo kang nobyo rugyan lang nga nagatindug kag nagpamati, kag nagakasadya tana kon mabatian na nga maghambal ang nobyo. Amo man karia nga kasadya ang akun nabatyagan; tuman gid ang akun kasadya hay makita ko ang mga tawo nagaparapit kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kinahanglan nga mas makilala tana nga labing importante, kag ako tana dapat nga malipatan run.” ");
INSERT INTO krj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tana nga halin sa langit amo ang gamhanan sa tanan. Kag ang sa kalibutan halin kalibutanun, kag ang anang mga ginapanghambal parte lang sa mga butang nga rugya sa kalibutan. Gani nga ang naghalin sa langit mas labaw sa tanan. ");
INSERT INTO krj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nagapamatuod tana parte sa mga butang nga ana nakita kag nabatian, pero wara ti may nagapati sa anang ginpanghambal. ");
INSERT INTO krj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ang nagapati sa anang mga ginakuon nagapamatuod nga ang mga ginapanghambal kang Dios matuod gid. ");
INSERT INTO krj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Hay tana nga ginpadara kang Dios nagahambal kon ano ang ginahambal kang Dios, tungud nga gintugro kang Dios kana ang Balaan nga Ispirito kang bug-os. ");
INSERT INTO krj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ginahigugma kang Amay ang anang Anak, kag ana nga gintugyan sa Anak ang tanan nga butang. ");
INSERT INTO krj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ang bisan sin-o nga nagatoo sa Anak makaangkun kang kabuhi nga wara ti katapusan. Pero ang wara tana nagatuman sa Anak indi makaangkun kang kabuhi nga wara ti katapusan, kundi nga nagapabilin kana ang kaugut kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kar-on, nabatian kang mga Fariseo nga mas raku ang nadara ni Jesus nga mangin anang disipulo kag ginabawtisohan sangsa kay Juan, ");
INSERT INTO krj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","bisan pa nga sa pagkamatuod karia, bukun tana si Jesus gid ang nagapangbawtiso kundi ang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kang naman-an dya ni Jesus, naghalin tana sa Judea kag nagbalik liwan sa Galilea. ");
INSERT INTO krj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sa pag-agto na sa Galilea kinahanglan gid nga mag-agi tana sa probinsya kang Samaria. ");
INSERT INTO krj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kang nagaagi run tana sa Samaria, nag-abot tana sa sangka banwa nga ginatawag Sicar. Ang Sicar nga dya marapit sa sangka puna nga lupa nga gintugro kato anay ni Jacob sa anang bata nga si Jose. ");
INSERT INTO krj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Rugto man sa Sicar ang bubon ni Jacob, kag tungud nga nalapyo gid si Jesus sa ana nga pagpanglakatun, nagpungko tana sa may kilid kang bubon. Mga udto adlaw run kato. ");
INSERT INTO krj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Burubuhay, may sangka bayi nga Samaritanhun nga nag-abot para magsag-ub. Nagkuon si Jesus kana, “Pwede mo ako itaw-an kang tubig nga akun mainum?” ");
INSERT INTO krj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ang anang mga disipulo kato nagpanaw sa syudad para magbakal ka pagkaun.) ");
INSERT INTO krj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nagsabat ang bayi, “Judio kabay ikaw kag ako takun bayi nga Samaritanhun, andut haw nga nagapangayo ikaw kanakun kang tubig para imnun?” (Ginkuon na dya tungud nga ang mga Judio wara nagapakig-impon sa mga Samaritanhun.) ");
INSERT INTO krj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nagkuon si Jesus kana, “Kon naman-an mo lang raad kon ano ang ginatugro kang Dios nga wara ti bayad kag kon sin-o ang nagapangayo kanimo kang tubig, ikaw pa raad ang magapangayo kana kag pagataw-an na ikaw kang tubig nga nagatugro kang kabuhi.” ");
INSERT INTO krj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nagkuon ang bayi, “Sir, ano bay pagbuul mo ka tubig hay wara ikaw ti timba kag dalum pa ang bubon? Sa diin bay ikaw mabuul kang tubig nga dya nga nagatugro kang kabuhi? ");
INSERT INTO krj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labaw pa bala ikaw sangsa atun ulang nga si Jacob nga amo ang nagtugro kanamun kang bubon nga dya? Tana mismo kag anang mga kabataan rugya nagsag-ub kang andang gin-inum. Rugya man sanda nagbuul kang tubig para sa andang mga kasapatan.” ");
INSERT INTO krj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nagsabat si Jesus, “Ang bisan sin-o nga magainum kang tubig nga dya pagauhawun liwan, ");
INSERT INTO krj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero ang bisan sin-o tana nga magainum kang tubig nga akun igatugro kana, indi run gid pag-ohawun tungud nga ang tubig nga akun igatugro kana mangin pareho kang tubodan sa anang kabuhi nga magatugro kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nagkuon ang bayi kay Jesus, “Sir, tugroi man ay ako kang tubig nga imo ginatumud nga dya, agud to nga indi run gid ako pag-ohawun liwan, kag indi run man ako magsagad balik rugya sa pagsag-ub.” ");
INSERT INTO krj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nagkuon si Jesus kana, “Panaw kag itawgun ang imo bana, kag magbalik dayon rugya.” ");
INSERT INTO krj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nagsabat ang bayi, “Wara takun ti bana!” Nagkuon si Jesus kana, “Husto ikaw sa paghambal mo nga wara ikaw ti bana. ");
INSERT INTO krj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hay ang matuod karia, may lima anay ikaw ka bana. Kag ang laki nga imo ginaimaw kadya bukun man ti imo bana. Matuod gid man ang imo ginkuon.” ");
INSERT INTO krj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nagkuon ruman ang bayi, “Sir, sa banta ko sangka propeta ikaw! ");
INSERT INTO krj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ang amun mga kaulangan rugya anay sa bukid nga dya nagsimba sa Dios. Pero inyo tana nga mga Judio, nagakuon kamo nga sa Jerusalem dapat magsimba sa Dios ang mga tawo.” ");
INSERT INTO krj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dayon nagkuon si Jesus sa bayi, “Magpati ikaw sa akun igakuon, Inday: magaabot ang tion nga indi sa bukid nga dya ukon sa syudad kang Jerusalem kamo magasimba sa Dios nga Amay. ");
INSERT INTO krj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamo nga mga Samaritanhun nagasimba pero wara ninyo makilala kon sin-o ang inyo ginasimba. Kami tamun nga mga Judio nakakilala kon sin-o ang amun ginasimba, hay sa mga Judio maghalin ang kaluwasan. ");
INSERT INTO krj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Magaabot ang tion, kag nag-abot run kadya, nga ang mga matuod nga manugsimba sa Dios nga Amay magasimba kana sa ispirito kag sa kamatuoran. Amo dya nga sahi kang pagsimba ang naluyagan kang Amay. ");
INSERT INTO krj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ang Dios, Ispirito gani ang mga nagasimba kana kinahanglan magsimba kana sa ispirito kag sa kamatuoran.” ");
INSERT INTO krj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nagkuon ang bayi, “Nakamaan ako nga magaabot ang Mesias nga ginatawag Cristo. Kon mag-abot tana, isugid na kanatun ang tanan nga mga butang.” ");
INSERT INTO krj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nagsabat si Jesus, “Ako ria; ako nga nagapakig-istorya kanimo kadya.” ");
INSERT INTO krj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa amo man to nga mga tinion, nag-abot ang mga disipulo ni Jesus. Natingala sanda kang makita nanda tana nga nagapakigsugidanun sa sangka bayi. Pero wara gid ti bisan isara kananda nga namangkot nga, “Ano haw ang imo kinahanglan?” ukon, “Andut haw nga nagapakig-istorya ikaw sa bayi nga dya?” ");
INSERT INTO krj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dayon, ang bayi tana, ginbilin na ang anang tibud kag nagbalik sa banwa kag nagkuon sa mga tawo rugto nga, ");
INSERT INTO krj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dali bala kamo, sulnga ninyo ang tawo nga nagsugid kanakun kang tanan ko nga mga ginhimo! Tana run ayhan ang Cristo?” ");
INSERT INTO krj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amo to kag naggurowa ang mga tawo sa banwa kag nag-agto kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa pihak tana nga bahin, ginahambalan kang mga disipulo si Jesus nga magkaun. Kuon nanda, “Sige, Maestro, kaun run.” ");
INSERT INTO krj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero nagkuon si Jesus kananda, “May pagkaun ako nga wara gid ninyo maman-i.” ");
INSERT INTO krj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Amo to kag nagpamangkotanay ang mga disipulo. Kuon nanda, “May nagdara haw kang pagkaun para kana?” ");
INSERT INTO krj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Si Jesus nagkuon kananda, “Ang ginatumud ko nga akun pagkaun amo ang akun pagtuman sa kabubut-un kang nagpadara kanakun, kag ang pagtapos kang hirikoton nga anang gintugyan kanakun. ");
INSERT INTO krj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Indi bala may ginahambal kamo nga, ‘Apat run lang ka bulan kag tag-arani run.’ Pero amo dyaay ang ikuon ko kaninyo: turuka bala ninyo ang kaumahan. Aranyun run ang mga paray. ");
INSERT INTO krj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bisan gani kar-on, ang inyong halimbawa pareho kang mga mangarani nga nagabaton run kang andang suhol kag nagatipon kang patubas nga nagatugro kang kabuhi nga wara ti katapusan. Amo gani nga ang manugpanggas kag ang manug-ani pareho nga magakalipay. ");
INSERT INTO krj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gani nga matuod gid man ang hurubatun nga nagakuon, ‘Lain ang nagtanum, lain man ang nagaani.’ ");
INSERT INTO krj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kamo pareho kang mga manug-ani nga akun ginsugo nga anihun ang bunga kang tanum nga bukun ti kamo ang nagpangabudlay. Lain nga tawo ang nagpangabudlay, pero kamo ang nagpulos kang bunga kang andang ginpangabudlayan.” ");
INSERT INTO krj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Duro nga mga Samaritanhun sa amo to nga banwa ang nagtoo kay Jesus tungud sa ginhambal kang bayi parte kana nga kuon na, “Ginsugid na kanakun ang tanan ko nga mga hinimoan.” ");
INSERT INTO krj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Amo to nga kang mag-agto ang mga Samaritanhun kay Jesus, ginpangabay nanda tana nga magtiner anay kananda, kag nagtiner si Jesus kananda kang darwa ka adlaw. ");
INSERT INTO krj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kag tungud kang anang mga ginpanudlo, duro pa gid nga mga Samaritanhun ang nagtoo kana. ");
INSERT INTO krj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nagkuon sanda kadya sa bayi, “Kar-on nagtoo kami kana indi tungud kang imong ginhambal kanamun kundi tungud nga kami gid mismo ang nakabati kana. Kag naman-an run namun nga tana amo gid ang Manluluwas kang mga katawhan sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagkatapos kang darwa ka adlaw nga tiner ni Jesus rugto sa Samaria, nagpanaw tana paagto sa Galilea. ");
INSERT INTO krj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tana mismo naghambal nga ang sangka propeta wara ginakilala bilang propeta sa anang kaugalingun nga banwa. ");
INSERT INTO krj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kang pag-abot na sa Galilea, gin-abi-abi tana kang mga tawo rugto, tungud nga ang dya nga mga tawo nag-agto man sa Jerusalem katong Pista kang Paglampuwas kauna kag nakita nanda ang tanan nga mga ginpanghimo ni Jesus rugto. ");
INSERT INTO krj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kar-on, nag-agto ruman si Jesus sa Cana sa probinsya kang Galilea, nga sa diin ang tubig ginhimo na nga bino. Kag rugya kadya may sangka opisyal nga ang anang bata nga laki nagamasakit rugto sa Capernaum. ");
INSERT INTO krj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kang pagkabati kang opisyal nga dya nga si Jesus nag-abot sa Galilea halin sa Judea, nag-agto tana kay Jesus kag ginpangabay na dya nga mag-agto sa Capernaum agud ayadun ang anang bata nga laki hay sa amo to nga mga tinion tagumatayun run dya. ");
INSERT INTO krj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nagkuon si Jesus kana, “Indi gid kamo tinyo haw magtoo kon indi kamo makakita kang mga katingalahan nga nagakaratabo kag mga milagro?” ");
INSERT INTO krj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nagkuon ang opisyal, “Ginoo, tawas anay kanakun rugto samtang buhi pa ang akun bata.” ");
INSERT INTO krj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nagsabat si Jesus, “Uli run to, ang imo nga bata maayad.” Nagpati ang tawo sa ginkuon ni Jesus kag nagpanaw tana. ");
INSERT INTO krj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Samtang sa dalanun pa lang tana, ginsug-alaw run tana kang anang mga surugoon kag ginkun-an nga magaayad ang anang bata. ");
INSERT INTO krj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ginpamangkot na sanda kon ano oras nag-umpisa nga mag-ayad ang anang bata, kag nagkuon ang mga surugoon kana, “Kahapon mga ala una ti hapon nadura ang anang hilanat.” ");
INSERT INTO krj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kag nadumduman kang opisyal nga amo gid to nga oras nagkuon si Jesus nga ang anang bata magaayad. Gani tana kag ang bug-os na nga panimalay nagtoo kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Amo dya ang ikarwa nga milagro nga ginhimo ni Jesus sa Galilea kang nagbalik tana rugto halin sa Judea. ");
INSERT INTO krj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkatapos kang mga hitabo nga to, nagtukad si Jesus sa Jerusalem para sa Pista kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kar-on, rugto sa Jerusalem, sa Pwertahan kang mga Karnero, may tubig nga pararigosan nga ginatawag sa hambal nga Hebreo nga Betesda. Dya nga pararigosan napalibotan kang lima ka parasirongan. ");
INSERT INTO krj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sa mga parasirongan nga dya raku gid nga mga masakitun ang nagabaratang - mga bulag, mga piang kag mga paralitiko. Nagahulat sanda nga maghulag ang tubig ");
INSERT INTO krj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","hay kon kaisa kuno may anghel kang Ginoo nga nagapanaog kag ginatandug na ang tubig. Ang una nga makalusong sa tubig pagkatapos nga labugayun dya kang anghel nagaayad kuno bisan ano man ang anang balatian. ");
INSERT INTO krj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kar-on, may sangka tawo rugto kato nga katloan run kag walo ka tuig nga nagamasakit. ");
INSERT INTO krj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kang nakita tana ni Jesus nga nagabatang rugto kag naman-an na nga buhay run tana rugto, nagkuon si Jesus kana, “Gusto mo bala nga mag-ayad sa imong masakit?” ");
INSERT INTO krj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nagsabat ang tawo, “Sir, wara bay ti may magabutang kanakun sa tubig pagkatapos nga matandug dya? Nagatinguha pa lang gani ako sa pagpanaog, ginaunahan run ako kang iba.” ");
INSERT INTO krj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dayon nagkuon si Jesus kana, “Bangon, dar-a ang imong banig kag magpanaw.” ");
INSERT INTO krj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lagi-lagi kato nag-ayad ang tawo. Gindara na ang anang banig kag nagpanaw. Natabo dya sa Adlaw nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gani ang mga pangulo kang mga Judio nagkuon sa tawo nga naayad, “Adlaw kabay kadya nga Inugpahuway? Gani supak sa Kasugoan nga magdara ikaw kang imong banig.” ");
INSERT INTO krj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nagsabat tana kananda, “Ang tawo nga nag-ayad kanakun amo ang nagkuon nga dar-un ko ang akun banig kag magpanaw.” ");
INSERT INTO krj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gani nagpamangkot sanda kana, “Sin-o to nga tawo ang nagkuon kanimo nga himoon mo ria?” ");
INSERT INTO krj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ang tawo nga gin-ayad nga dya wara nakamaan kon sin-o ang nag-ayad kana, tungud nga wara na run makita si Jesus sa kadurohon kang mga tawo rugto. ");
INSERT INTO krj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kang urihi run kato nakita ni Jesus sa templo ang tawo nga anang gin-ayad, kag nagkuon tana sa tawo, “Ti, mayad run ikaw kadya. Gani indi run ikaw magpakasala hay basi mas malain pa gid ang matabo kanimo.” ");
INSERT INTO krj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dayon nagpanaw ang tawo kag nagsugid sa mga pangulo kang mga Judio nga si Jesus amo ang nag-ayad kana. ");
INSERT INTO krj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kag tungud nga nagapanghimo si Jesus kadyang mga butang sa Adlaw nga Inugpahuway, amo to nga ginhingabot tana kang mga pangulo kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero nagkuon si Jesus kananda, “Ang akun Amay nagapadayon sa anang hirikoton hasta tulad, gani ako kinahanglan man nga magpadayon sa akun hirikoton.” ");
INSERT INTO krj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tungud sa ginhambal nga dya nga Jesus, nagdugang pa gid ang pagtinguha kang mga pangulo kang mga Judio nga patyun tana tungud nga para kananda wara na lang ginlapas ang kasugoan nahanungud sa Adlaw nga Inugpahuway, kundi nga ginatawag na pa ang Dios nga anang kaugalingun nga Amay, nga kon sayudon nagapakigtupung tana sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Amo to kag nagsabat si Jesus sa mga pangulo kang mga Judio, “Sugidan ko kamo, ang Anak wara gid ti may mahimo kon sa ana kaugalingun lang. Kon ano ang makita kang Anak nga ginahimo kang Amay amo man ang anang ginahimo. Gani ang ginahimo kang Amay amo man ang ginahimo kang Anak. ");
INSERT INTO krj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tungud nga ang Amay nagahigugma gid sa Anak, kag ginapakita na sa Anak ang tanan na nga ginahimo. Sobra pa gid gani sa mga butang nga dya ang ana nga igapakita sa Anak agud to nga matingala kamo ");
INSERT INTO krj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kon ang Amay nagabanhaw kang patay kag ginataw-an na sanda kadya kang kabuhi, ang Anak nagatugro man kang kabuhi sa bisan sin-o nga luyag na tugroan. ");
INSERT INTO krj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Luwas pa dyan karia, ang Amay wara nagahusgar sa bisan kay sin-o, kundi nga gintugyan na sa Anak ang bug-os nga awtoridad sa paghusgar, ");
INSERT INTO krj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","agud to nga padunggan man ang Anak kang tanan nga mga tawo pareho kang pagpadungug nanda sa Amay. Ang bisan sin-o nga wara nagapadungug sa Anak, wara man nagapadungug sa Amay nga nagpadara kana. ");
INSERT INTO krj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sugidan ko kamo: Ang bisan sin-o nga nagatuman sa akun nga ginakuon kag nagatoo sa Dios nga amo ang nagpadara kanakun rugya, makaangkun tana kang kabuhi nga wara ti katapusan. Indi run tana paghukman, tungud nga wara run tana nagapaagto sa kamatayun kundi sa kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sugidan ko pa gid kamo: magaabot ang tion, kag sa pagkamatuod nag-abot run gani dya, nga ang mga tawo nga patay makabati kang limug kang Anak kang Dios kag ang bisan sin-o nga nagatuman makaagum kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ang Amay amo ang nagatugro kang kabuhi, kag ang Anak gintugroan na man kang gahum sa pagtugro kang kabuhi. ");
INSERT INTO krj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ang Anak gintugroan na man kang awtoridad sa paghusgar tungud nga tana ang Anak kang Tawo. ");
INSERT INTO krj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Indi kamo matingala sa mga butang nga ria, hay magaabot ang tion nga ang tanan nga mga patay sa andang rulubngan makabati kang anang limug ");
INSERT INTO krj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kag magabarangon sanda kadya. Ang mga nakahimo kang mayad mabanhaw kag magakabuhi, pero ang to tana nga nakahimo kang malain mabanhaw man para silotan.” ");
INSERT INTO krj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nagpadayon pa gid sa paghambal si Jesus, “Kon sa akun kaugalingun lang tana, wara ako ti sarang mahimo. Ang akun nga paghukum suno gid lang sa ginakuon kanakun kang akun Amay, gani nga akun nga paghukum matarung, tungud nga bukun ang akun kaugalingun nga luyag ang akun ginahimo kundi ang luyag kang akun Amay nga nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kon ako magsugid ako nahanungud sa akun kaugalingun, ang akun ginasugid indi mabaton nga matuod. ");
INSERT INTO krj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero may dyan nga nagasugid nahanungud kanakun kag naman-an ko nga ang anang ginakuon parte kanakun matuod. ");
INSERT INTO krj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nagsugo kamo kang mga tawo para magpamangkot kay Juan nahanungud kanakun. Kag ginsugid ni Juan kon ano ang matuod. ");
INSERT INTO krj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero bukun ti kuon nga kinahanglan ko ang pagpamatuod kang tawo nahanungud kanakun, kundi nga ginkuon ko lang dya agud to nga basi pa lang nga maluwas man kamo. ");
INSERT INTO krj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Dya si Juan daw kaangay kang sulo nga nagasiga kag nagaiwag, kag sa mabugu nga tinion nagkalipay kamo sa kasanag nga anang gintao sa inyo nga panghuna-huna. ");
INSERT INTO krj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Pero may nagasugid pa gid nahanungud kanakun nga labi pa sa ginasugid ni Juan. Amo dyaay: ang akun mga ginapanghimo nga gintugyan kanakun kang Amay nga akun taposon ang nagapamatuod nga ako ginpadara kang akun Amay. ");
INSERT INTO krj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kag ang Amay mismo nga amo ang nagpadara kanakun rugya nagapamatuod man nahanungud kanakun. Pero wara kamo makabati kang anang limug ukon nakakita kon ano ang anang itsura. ");
INSERT INTO krj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kag wara man nagapabilin ang anang mga Pulong sa inyo mga tagipusoon tungud nga wara kamo nagapati kanakun nga anang ginpadara. ");
INSERT INTO krj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ginaton-an gid ninyo kamayad ang Kasulatan hay nagpinsar kamo nga paagi kadya makaangkun kamo kang kabuhi nga wara ti katapusan. Ang Kasulatan nga dya mismo ang nagapamatuod nahanungud kanakun, ");
INSERT INTO krj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero indi kamo gusto magparapit kanakun agud to nga makaangkun kamo kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nagpadayon pa gid si Jesus sa paghambal nga nagakuon, “Wara takun nagatinguha nga dayawun ako kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero nakilala ko gid kamo. Naman-an ko nga sa inyo tagipusoon wara gid ti paghigugma sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nag-abot ako rugya sa kalibutan nga may awtoridad nga naghalin sa akun Amay, pero indi ninyo ako pagbatonon. Pero kon may tawo gani nga mag-abot nga sa ana lang kaugalingun nga awtoridad, ginabaton man ninyo tana. ");
INSERT INTO krj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Paano bay kamo makatoo kanakun, hay ang inyo tana nga ginapangita amo nga dayawun kamo kang inyo nga isigka-tawo, kag wara kamo nagatinguha nga ang Dios amo ang magdayaw kaninyo? ");
INSERT INTO krj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Indi kamo magpaminsar nga ako ang magaakusar kaninyo sa akun Amay. Si Moises tana nga amo ang inyo ginasarigan, amo ang magaakusar kaninyo sa akun Amay. ");
INSERT INTO krj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kon matuod nga nagapati kamo kay Moises, magapati man kamo kanakun hay nagsulat tana nahanungud kanakun. ");
INSERT INTO krj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tungud gani nga wara kamo nagapati sa anang ginkuon sa anang mga sinulat, ano pa bay karia ang pagpati ninyo sa akun ginakuon?” ");
INSERT INTO krj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkaligad kang mga inadlaw, nagtabok si Jesus sa pihak nga bahin kang Linaw kang Galilea. Dya ginatawag man nga Linaw kang Tiberias. ");
INSERT INTO krj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kag duro gid nga mga tawo ang nagsurunod kana tungud kang makatiringala nga mga milagro nga andang nakita nga ginhimo ni Jesus sa anang pagpang-ayad kang mga masakitun. ");
INSERT INTO krj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dayon nagtukad si Jesus sa sangka bakulod kag nagpungko tana rugto imaw kang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dali run lang kag Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nagpanghulung-hulung si Jesus kag nakita na nga duro gid nga mga tawo ang nagaarabot paagto kana. Amo to kag namangkot tana kay Felipe, “Sa diin bay kita makabakal kang pagkaun agud makakaun ang mga tawo nga dya?” ");
INSERT INTO krj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ginpamangkot na dya agud to nga tirawan si Felipe kon ano abi ang isabat na kadya, hay si Jesus tana nakamaan run kon ano ang anang himoon. ");
INSERT INTO krj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nagsabat si Felipe, “Abu! Sa kadurohon kang mga tawo nga dya, bisan taw-an sanda kadya kang gamay lang nga pagkaun, ang 200 ka kwarta nga pilak kulang pa nga ibakal kang andang pagkaun.” ");
INSERT INTO krj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ang isara tana sa mga disipulo ni Jesus nga si Andres nga bugto ni Simon Pedro nagkuon, ");
INSERT INTO krj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“May gamay nga bata nga laki rugya nga may dara nga lima ka bilog nga tinapay kag darwa ka bilog nga isda. Pero sang-ano gid ria sa kadurohon kang mga tawo man?” ");
INSERT INTO krj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pero nagkuon si Jesus sa anang mga disipulo, “Abi, papungkoa ninyo ang mga tawo nga ria.” Kag tungud nga hilamonon rugto kato nga lugar, gani nga nagpurungko man ang mga tawo. Mga lima ka libo ang mga laki rugto. ");
INSERT INTO krj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Amo to kag ginbuul ni Jesus ang tinapay, kag pagkatapos nga magpasalamat tana sa Dios, ginpanagtag dya sa mga tawo nga nagapurungko rugto. Amo man kadya ang ginhimo na sa isda. Ang tanan nakapagusto ka kaun. ");
INSERT INTO krj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kag kang nabusog run ang mga tawo, nagkuon si Jesus sa anang mga disipulo, “Abi, tipona ninyo ang mga nabilin agud to nga wara ti may mausik.” ");
INSERT INTO krj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gani nga gintipon man nanda dya kag napulo'g darwa ka alat ang nabuta kang andang natipon nga halin sa 5 ka tinapay nga ginkaun kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kang makita kang mga tawo ang katingalahan nga natabo nga dya, nagkuon sanda, “Amo run gid dya ang Propeta nga manug-abot sa kalibutan!” ");
INSERT INTO krj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nasat-uman ni Jesus nga tuyo nanda nga ibul-un tana kang pirit agud himoon nga hari. Gani ang ginhimo na, naghalin tana liwan kag nagtukad sa bakulod nga nagaisarahanun lang. ");
INSERT INTO krj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kang sirum run, ang anang mga disipulo nagdulhog paagto sa linaw ");
INSERT INTO krj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kag nagsakay sa sangka baruto kag nagtabok pa-Capernaum. Gabii run kato kag si Jesus wara pa gihapon makaimaw kananda. ");
INSERT INTO krj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Samtang nagatabok sanda, nagdulus ang hangin kag nagdaragkul ang balud. ");
INSERT INTO krj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pagkaantad nanda ka mga lima ukon anum ka kilometro, nakita nanda si Jesus nga nagapanaw sa tubig nga nagapaagto sa andang baruto, kag kinulbaan gid sanda kamayad. ");
INSERT INTO krj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero nagkuon si Jesus kananda, “Ako dya; indi kamo magkahadluk.” ");
INSERT INTO krj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Malipayun sanda nga nagpasakay kana sa baruto, kag lagi-lagi kato nag-abot sanda sa andang aragtonan. ");
INSERT INTO krj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kang masunod nga adlaw kato, ang mga tawo rugto man gihapon sa tabok kang linaw. Natalupangdan nanda nga sangka baruto lang ang rugto kato, kag naman-an man nanda nga si Jesus wara magsakay rugto imaw kang anang mga disipulo, kundi nga sandahanun lang tana ang naghalin. ");
INSERT INTO krj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","May mga baruto man nga naghalin sa Tiberias nga nagdungka marapit sa lugar nga sa diin ginpakaun kang tinapay ang mga tawo pagkatapos nga mapasalamatan dya kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gani kang naman-an kang mga tawo nga dya nga si Jesus kag ang anang mga disipulo wara run rugto, nagsarakay sanda sa mga baruto kag mag-agto sa Capernaum para sagapun si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kang makita kang mga tawo si Jesus rugto sa tabok kang linaw, nagkuon sanda kana, “Maestro, kasan-o pa ikaw nag-abot rugya?” ");
INSERT INTO krj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nagsabat si Jesus, “Sugidan ko kamo: ginasagap ninyo ako indi tungud kang makatiringala nga buhat nga inyo nakita, kundi tungud nga ginpakaun ko kamo kang tinapay kag nabusog. ");
INSERT INTO krj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Indi kamo magpangabudlay para sa pagkaun nga nagakapan-us. Magpangabudlay kamo para sa pagkaun nga wara nagakapan-us kag nagatugro kang kabuhi nga wara ti katapusan. Amo dya nga pagkaun ang igatugro kaninyo kang Anak kang Tawo, tungud nga gintugroan tana kang Dios nga Amay kang awtoridad sa paghimo kadya.” ");
INSERT INTO krj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dayon namangkot sanda kana, “Ano bay ang amun himoon para nga masunod namun ang ginapahimo kang Dios?” ");
INSERT INTO krj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nagsabat si Jesus, “Amo dyaay ang luyag kang Dios nga inyo himoon: magtoo kamo sa ana nga ginpadara rugya.” ");
INSERT INTO krj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nagkuon ruman ang mga tawo kana, “Ano bay nga katingalahan nga buhat ang imo nga igapakita kanamun agud to nga magtoo kami kanimo? Ano bay ang imo himoon? ");
INSERT INTO krj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ang atun mga kaulangan kato anay nagkaun kang mana kang sanda nagapanglakatun sa may kayanakan. Amo man dya ang nasulat sa Kasulatan nga, ‘Gintaw-an na sanda kang pagkaun nga naghalin sa langit.’” ");
INSERT INTO krj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nagkuon si Jesus kananda, “Sugidan ko kamo kang matuod: bukun ti si Moises ang nagtao kaninyo kang pagkaun nga naghalin sa langit. Ang akun tana Amay amo ang nagatao kaninyo kang matuod nga pagkaun nga naghalin sa langit. ");
INSERT INTO krj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tungud nga ang pagkaun nga ginatao kang Dios wara ti iba kundi ang nagpanaog rugya halin sa langit, kag nagatugro kang kabuhi nga wara ti katapusan sa mga katawhan sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amo to kag nagkuon ang mga tawo kana, “Sir, taw-i man ay kami pirme kang pagkaun nga dya.” ");
INSERT INTO krj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nagsabat si Jesus kananda, “Ako amo ang pagkaun nga nagatugro kang kabuhi. Ang bisan sin-o nga nagaparapit kanakun indi run gid paggutumun, kag ang bisan sin-o nga nagatoo kanakun indi run gid pag-uhawun. ");
INSERT INTO krj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero pareho kang ginkuon ko kaninyo kato anay, bisan nakita run ninyo ako pero wara kamo sa gihapon nagatoo kanakun. ");
INSERT INTO krj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ang tanan nga tawo nga ginatugyan kanakun kang akun Amay magaparapit kanakun, kag indi gid nakun pagsikwayun ang bisan sin-o nga nagaparapit kanakun. ");
INSERT INTO krj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tungud nga wara ako nanaog rugya halin sa langit para tumanun ang akun kaugalingun lang nga kabubut-un, kundi agud nga himoon ang kabubut-un kang akun Amay nga amo ang nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kag ang kabubut-un kang akun Amay nga nagpadara kanakun amo dyaay: nga indi ko pagpabay-an nga madura ang bisan isara nga anang gintugyan kanakun, kundi nga pagabanhawun ko sanda tanan sa urihi nga adlaw. ");
INSERT INTO krj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tungud nga ang kabubut-un kang akun Amay amo nga ang bisan sin-o nga nagakilala sa Anak kag nagatoo kana makaangkun kang kabuhi nga wara ti katapusan, kag pagabanhawun ko sanda sa urihi nga adlaw.” ");
INSERT INTO krj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kar-on, ang mga Judio nag-umpisa ka kirimodon parte kay Jesus tungud sa anang ginkuon nga tana ang pagkaun nga naghalin sa langit. ");
INSERT INTO krj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nagkuon sanda nga, “Si Jesus kabay dya nga bata ni Jose? Kilala man bay natun ang tatay kag nanay na kadya? Andut haw nagakuon tana nga sa langit tana naghalin?” ");
INSERT INTO krj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nagsabat si Jesus kananda, “Indi kamo magsagad kirimodon dyan. ");
INSERT INTO krj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wara ti bisan sin-o nga makaparapit kanakun luwas lang kon ipaparapitun tana kang akun Amay nga amo ang nagpadara kanakun rugya, kag akun tana banhawun sa urihi nga adlaw. ");
INSERT INTO krj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nagkuon kabay ang mga propeta sa andang mga sinulat nga, ‘Ang tanan nga tawo pagatudloan kang Dios?’ Gani nga ang tanan nga nagapamati sa ginatudlo kang akun Amay kag nagatuon kana magaparapit kanakun. ");
INSERT INTO krj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wara ako nagakuon nga may tawo nga nakakita sa Amay. Tungud nga wara ti iba nga nakakita sa Amay magluwas lang kana nga naghalin sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sugidan ko kamo: ang bisan sin-o nga nagatoo kanakun may kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ako amo ang pagkaun nga nagatao kang kabuhi. ");
INSERT INTO krj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Matuod nga ang inyo mga kaulangan kato anay nagkaun kang mana rugto sa may kayanakan, pero nagkaramatay man sanda sa gihapon. ");
INSERT INTO krj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Rugya kar-on ang pagkaun nga halin sa langit; ang sin-o man nga magkaun kang pagkaun nga dya indi tana mapatay. ");
INSERT INTO krj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako amo ang pagkaun nga nagatugro kang kabuhi; ako naghalin sa langit. Ang bisan sin-o nga magakaun kadya nga pagkaun magakabuhi sa wara ti katapusan. Tungud nga ang pagkaun nga dya amo ang akun lawas mismo nga akun igatao para sa mga katawhan sa kalibutan agud makaangkun sanda kang kabuhi nga wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Amo to kag nagbirinaisay ang mga Judio nga nagakuon, “Paano bay ang pagtugro kang tawo nga dya kanatun kang anang lawas para ikan-un ta?” ");
INSERT INTO krj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nagkuon si Jesus kananda, “Sugidan ko kamo: kon indi ninyo pagkan-un ang lawas kang Anak kang Tawo kag imnun ang anang dugo indi kamo makaangkun kang kabuhi. ");
INSERT INTO krj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ang bisan sin-o nga magakaun kang akun lawas kag magainum kang akun dugo may kabuhi tana nga wara ti katapusan, kag sa urihi nga adlaw akun sanda nga ibanhawun. ");
INSERT INTO krj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tungud nga ang akun lawas amo gid ang matuod nga pagkaun kag ang akun dugo amo gid ang matuod nga irimnun. ");
INSERT INTO krj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ang bisan sin-o nga nagakaun kang akun lawas kag nagainum kang akun dugo nagapabilin ang anang kaangtanan kanakun kag nagapabilin man ang akun kaangtanan kana. ");
INSERT INTO krj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Buhi ang Amay nga nagpadara kanakun, kag tungud kana nagakabuhi ako. Amo man karia ang tawo nga nagakaun kanakun, magakabuhi man tana tungud kanakun. ");
INSERT INTO krj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Amo dya ang pagkaun nga naghalin sa langit. Bukun dya ti pareho kang pagkaun nga ginkaun kang inyo nga mga kaulangan kato anay nga nagkaramatay man sanda sa gihapon. Ang nagakaun tana kang pagkaun nga dya magakabuhi sa wara ti katapusan.” ");
INSERT INTO krj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ginhambal dya tanan ni Jesus kang nagapanudlo tana sa sinagoga rugto sa syudad kang Capernaum. ");
INSERT INTO krj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pagkabati kang anang mga disipulo sa mga ginpanghambal na nga dya, raku kananda ang nagkuon, “Kabudlay man tana intiendihun ang mga ginapanudlo na nga dya man. Sin-o abi bay ang sarang makabatas sa pagpamati kadya?” ");
INSERT INTO krj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Naman-an ni Jesus nga nagakirimodon ang anang mga disipulo tungud sa anang mga ginpanghambal, gani nga nagkuon tana, “Naglain bala ang inyo buut tungud kang akun ginpanghambal nga dya? ");
INSERT INTO krj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ano pa gid ayhan ang inyo mabatyagan kon makita ninyo ang Anak kang Tawo nga nagakayab pabalik sa lugar nga anang ginhalinan. ");
INSERT INTO krj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ang Balaan nga Ispirito amo ang nagatugro kang kabuhi; ang lawas tana wara ti may mahimo. Ang pulong nga akun ginhambal kaninyo halin sa Ispirito nga nagatugro kang kabuhi. ");
INSERT INTO krj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ogaring ang iba kaninyo wara nagapati kanakun.” Ginkuon dya ni Jesus hay naman-an na nga daan kon sin-o ang wara nagatoo kana kag kon sin-o ang magaluib kana. ");
INSERT INTO krj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kag nagkuon pa gid tana, “Amo ria nga nagkuon ako kaninyo nga wara ti may makaparapit kanakun kon indi pag-itugot kang Amay nga makaparapit tana kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Umpisa kato, duro sa anang mga sumuronod ang nagbiya kag wara run gid magsurunod kana. ");
INSERT INTO krj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kag ginpamangkot ni Jesus ang anang napulo'g darwa ka mga disipulo, “Kamo bala gusto man magbiya kanakun?” ");
INSERT INTO krj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nagsabat si Simon Pedro, “Ginoo, kay sin-o pa bay kami maagto hay rugyan kanimo ang mga pulong nga nagatugro kang kabuhi nga wara ti katapusan? ");
INSERT INTO krj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nagatoo kami kag nakamaan nga ikaw ang Balaan nga ginpadara kang Dios!” ");
INSERT INTO krj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dayon nagkuon si Jesus, “Ako kabay ang nagpili kaninyo nga napulo'g darwa? Pero ang isara kaninyo dyan yawa!” ");
INSERT INTO krj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ang ginatumud ni Jesus amo si Judas nga bata ni Simon Iscariote. Si Judas nga dya bisan pa nga isara tana sa napulo'g darwa ka mga disipulo, tana amo ang magaluib kay Jesus.) ");
INSERT INTO krj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos kang mga hitabo nga to, nagpang-agto si Jesus sa mga banwa kang Galilea. Indi tana gusto mag-agto sa Judea hay ang mga pangulo kang mga Judio rugto nagatinguha nga patyun tana. ");
INSERT INTO krj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kang nagahinamput run ang Pista kang mga Judio nga ginatawag Pista kang mga Torda, ");
INSERT INTO krj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","nagkuon kana ang anang mga libayun nga laki, “Panaw bala rugto sa Judea agud to nga makita kang imong mga sumuronod ang mga butang nga imo ginapanghimo. ");
INSERT INTO krj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ang tawo nga nagatinguha nga mangin bantog, wara na ginatago ang anang ginapanghimo. Hay nagahimo run lang man ikaw kang mga milagro nga dya, ipakilala mo run lang ang imo kaugalingun sa tanan.” ");
INSERT INTO krj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Tungud hay bisan gani ang anang libayun nga laki wara nagapati kana.) ");
INSERT INTO krj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Gani nga nagkuon si Jesus kananda, “Inyo tana bisan ano oras pwede kamo ka himo kon ano gusto ninyo himoon, pero akun tana bukun pa dya ang igsakto nga tion nga himoon ko ang akun dapat himoon. ");
INSERT INTO krj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ang mga tawo sa kalibutan indi makadumut kaninyo, pero ako tana ginadumtan nanda hay ginapahayag ko kananda nga ang andang mga ginapanghimo mga malaot. ");
INSERT INTO krj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sige, kamo lang to agto sa Pista. Indi takun mag-agto sa Pista nga dya hay wara pa gid mag-abot ang akun tion.” ");
INSERT INTO krj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pagkahambal kadya ni Jesus, nagpabilin tana sa Galilea. ");
INSERT INTO krj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero kang malumbos run ang anang mga libayun nga laki paagto sa Pista, nag-agto man si Jesus rugto, pero sa likum lang kag wara tana magpakita sa mga tawo. ");
INSERT INTO krj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Rugto sa Pista, nagasagap ang mga pangulo kang mga Judio kay Jesus. Nagaparapamangkot sanda kadya kon sa diin tana run. ");
INSERT INTO krj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Raku sa mga tawo ang nagahinuring-huring nahanungud kana. Ang iba nagakuon nga, “Mayad tana nga tawo!” Ang iba tana nagakuon man nga, “Bukun ria ti matuod. Ginapatalang na lang ang mga tawo!” ");
INSERT INTO krj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero wara gid ti may naghambal ka tampad nahanungud kana, hay nahadluk sanda sa andang mga pangulo. ");
INSERT INTO krj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kang naglambot run sa tunga-tunga ang paghiwat kang Pista nag-agto si Jesus sa templo kag nagpanudlo. ");
INSERT INTO krj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ang mga pangulo kang mga Judio natingala gid. Nagkuon sanda kadya nga, “Paano nangin mainaramun ang tawo nga dya man nga wara gani makaeskwela?” ");
INSERT INTO krj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nagsabat si Jesus kananda, “Ang akun ginapanudlo bukun ti kanakun maghalin kundi sa Dios nga amo ang nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kon ang sangka tawo gusto nga maghimo kang kabubut-un kang Dios, maman-an na kadya kon ang akun ginapanudlo sa Dios maghalin ukon akun-akun lang. ");
INSERT INTO krj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ang tawo nga nagapanudlo kang ana-ana lang, gusto lang nga mapadunggan ang anang kaugalingun. Pero ang tawo tana nga gusto nga mapadunggan ang nagpadara kana, dya nga tawo nagahambal kang matuod gid kag bukun ti butigun. ");
INSERT INTO krj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Indi bala nga gintugro ni Moises kaninyo ang Kasugoan? Pero wara ti bisan isara kaninyo nga nagatuman kang Kasugoan. Ti, andut haw nga gusto ninyo ako ipatyun?” ");
INSERT INTO krj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nagsabat ang mga tawo, “Nasudlan ikaw kang yawa ay! Sin-o haw ang nagatinguha nga magpatay kanimo?” ");
INSERT INTO krj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nagsabat si Jesus kananda, “Naghimo ako kang sangka milagro, kag tanan kamo natingala. ");
INSERT INTO krj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero pinsara bala ninyo dyaay: gintudloan kamo ni Moises nga isirkomon ninyo ang inyo nga mga bata nga laki. (Pero sa pagkamatuod karia bukun si Moises ang una nga nagtudlo kang dya nga turumanun, kundi ang inyo mga kaulangan kato anay.) Tungud sa gintudlo nga to ni Moises, ginasirkom ninyo ang inyo mga bata nga laki bisan sa Adlaw nga Inugpahuway. ");
INSERT INTO krj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kar-on, kon ang bata ginasirkom ninyo bisan pa sa Adlaw nga Inugpahuway agud nga indi malapas ang Kasugoan ni Moises, andut sa ano nga nagaugut kamo kanakun hay gin-ayad ko sa Adlaw nga Inugpahuway ang bug-os nga lawas kang tawo nga masakitun? ");
INSERT INTO krj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Indi kamo magsagad husgar suno sa makita ninyo lang, kundi nga maghusgar kamo sa matarung nga paagi.” ");
INSERT INTO krj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sa amo to nga tion, ang iba tana nga mga tawo sa Jerusalem nagkuon, “Indi bala nga amo dya ang tawo nga ginatinguhaan nanda nga patyun? ");
INSERT INTO krj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero dya man tana, nagahambal sa atubangan kang mga katawhan, pero wara man ti may nagahambal batok kana. Naman-an run ayhan kang atun mga pangulo nga tana amo ang Cristo? ");
INSERT INTO krj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ogaring kon ang Cristo tana mag-abot, wara ti may nakamaan kon sa diin tana maghalin. Pero ang tawo tana nga dya, naman-an natun kon sa diin tana maghalin.” ");
INSERT INTO krj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Si Jesus tana, nagapanudlo gihapon sa templo Naghambal tana kang matunog nga nagakuon, “Nakilala matuod ninyo ako, kag naman-an man ninyo kon sa diin ako maghalin. Wara ako mag-abot rugya sa akun lang kaugalingun nga awtoridad. Ang nagpadara kanakun rugya masarigan gid. Wara kamo makakilala kana. ");
INSERT INTO krj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero ako nakakilala kana, hay kana ako maghalin kag tana amo ang nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tungud sa ginhambal na nga to, gintinguhaan nanda tana nga idakpun pero wara gid ti bisan isara nga nangahas, tungud hay wara pa mag-abot ang anang tion. ");
INSERT INTO krj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bisan amo pa karia ang natabo, duro gihapon sa mga tawo ang nagtoo kana. Nagkuon sanda, “Kon mag-abot ang Cristo, sobra pa gid ayhan nga mga milagro ang anang pagahimoon sangsa ginahimo kang tawo nga dya?” ");
INSERT INTO krj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kar-on, nabatian kang mga Fariseo ang mga hinuring-huring nga dya kang mga tawo parte kay Jesus. Gani sanda kag imaw kang mga pangulo kang kaparian nagsugo kang mga gwardya kang templo sa pagdakup kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nagkuon si Jesus, “Gamay run lang nga tinion ang akun pagpakig-imaw kaninyo, kag pagkatapos karia mabalik run ako sa nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pagasagapun ninyo ako, pero indi ninyo ako makita, kag kon sa diin man ako indi kamo makaagto.” ");
INSERT INTO krj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ang mga pangulo tana kang mga Judio nagpinamangkotanay, “Sa diin bala maagto ang tawo nga dya nga indi run natun tana makita? Maagto tana ayhan sa syudad kang mga bukun ti Judio nga sa diin may mga Judio nga nagairistar kag rugto manudlo sa mga bukun ti Judio? ");
INSERT INTO krj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ano bay ang buut na hambalaun kang nagkuon tana nga, ‘pagasagapun ninyo ako pero indi ninyo ako makita,’ kag nagkuon pa gid tana nga, ‘kon sa diin man ako indi kamo makaagto.’” ");
INSERT INTO krj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Katong nag-abot run ang katapusan kag pinakaimportante nga adlaw kang Pista, nagtindug si Jesus kag naghambal sa matunog nga limug nga nagakuon, “Ang bisan sin-o kaninyo nga ginauhaw, magparapit tana kanakun kag mag-inum. ");
INSERT INTO krj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ang bisan sin-o nga nagatoo kanakun, suno sa ginakuon sa Kasulatan, halin sa anang kabuhi magailig ang nagasaragahay nga tubig nga nagatugro kang kabuhi.” ");
INSERT INTO krj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ang ginatumud ni Jesus sa ginkuon na nga dya amo ang Balaan nga Ispirito nga mabaton kang mga nagatoo kana. Sa mga tinion nga to wara pa matugro kananda ang Balaan nga Ispirito tungud hay wara pa si Jesus mabayaw kag mahimaya. ");
INSERT INTO krj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kang mabatian kang iba nga mga tawo sa karak-an ang ginkuon nga dya ni Jesus, nagkuon sanda nga, “Amo run gid dya ang Propeta!” ");
INSERT INTO krj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ang iba tana nagkuon man nga, “Tana amo run gid ang Cristo!” Pero ang iba tana nagkuon man, “Sa Galilea haw magahalin ang Cristo? ");
INSERT INTO krj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ginakuon kabay sa Kasulatan nga ang Cristo magahalin sa linahi ni Haring David, kag tana ibataun sa banwa kang Betlehem nga amo man ang lugar ni Haring David?” ");
INSERT INTO krj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gani nga wara nagsirinanto ang pagpati kang mga tawo tungud kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ang iba kananda gusto nga idakpun tana, pero wara gid ti bisan isara kananda nga nagtandug kana. ");
INSERT INTO krj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kar-on, nagbalik ang mga gwardya kang templo sa mga pangulo kang kaparian kag mga Fariseo. Ginpamangkot nanda kadya ang mga gwardya, “Andut haw nga wara ninyo tana dar-a rugya?” ");
INSERT INTO krj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nagsabat ang mga gwardya, “Kadya pa lang gid kami nakabati kang tawo nga amo karia ka nami maghambal!” ");
INSERT INTO krj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nagkuon ang mga Fariseo nga, “Hasta bala kamo nainto na man? ");
INSERT INTO krj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","May naman-an kamo nga atun mga pangulo ukon kanamun nga mga Fariseo nga nagtoo kana haw? ");
INSERT INTO krj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kon parte tana sa mga tawo nga nagadurugok kana, wara sanda ti hinalung-ung nahanungud sa Kasugoan ni Moises. Pakamalaoton gid sanda kang Dios!” ");
INSERT INTO krj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Isara sa mga pangulo amo si Nicodemo. Tana kadya amo ang nagpakigkita kay Jesus kato anay. Naghambal tana nga, ");
INSERT INTO krj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wara kabay nagatugot ang atun Kasugoan nga ang sangka tawo husgaran nga silotan nga wara pa tana maimbistigar kag maman-an kon ano gid ang anang ginahimo?” ");
INSERT INTO krj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nagkuon sanda kay Nicodemo, “Daw sa taga-Galilea man ikaw e! Usisaa bala sa Kasulatan kon indi mo masapwan rugto nga wara ti propeta nga taga Galilea.” ");
INSERT INTO krj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos kato, ang kada isara kananda nagparauli sa andang mga balay. ");
INSERT INTO krj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero si Jesus tana nag-agto sa Bukid kang mga Olibo. ");
INSERT INTO krj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kang masunod nga adlaw, aga-aga pa gid nga nagbalik si Jesus sa templo. Kag rugto gintiriponan tana kang duro gid karaku nga mga tawo. Gani nagpungko tana kag nagpanudlo kananda. ");
INSERT INTO krj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sa wara lang gid magbuhay nag-abot ang mga manunudlo kang Kasugoan kag ang mga Fariseo. May ginadara sanda nga sangka bayi nga nadakpan nga nagapakighilawas. Ginpatindug nanda tana kadya sa tunga kang mga katawhan ");
INSERT INTO krj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kag nagkuon sanda kay Jesus, “Maestro, ang dya nga bayi nadakpan sa akto nga nagapakighilawas. ");
INSERT INTO krj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Suno kabay sa Kasugoan naghambal si Moises nga ang amo dya nga sahi kang bayi dapat batwun hasta nga mapatay? Ano kar-on bay ang imo makuon?” ");
INSERT INTO krj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ginpamangkot nanda si Jesus kang amo dya agud to nga tirawan tana kon ano ang anang isabat para nga may basehan sanda sa pag-akusar kana. Pero ang ginhimo tana ni Jesus, nagduko tana kag nagsulat sa lupa paagi sa anang tudlo. ");
INSERT INTO krj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sa sige nanda ka pamangkot kana, nagtungkaaw tana kag nagkuon kananda, “Kon sin-o kaninyo ang wara ti sala, amo tana ang una nga magpakug kang bato sa bayi nga dya.” ");
INSERT INTO krj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kag dayon nagduko ruman si Jesus kag nagsulat sa lupa. ");
INSERT INTO krj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kang pagkabati nanda sa ginkuon nga dya ni Jesus, sara-sara sanda nga nagharalin umpisa sa mga mal-am, hasta nga si Jesus run lang ang nabilin kag ang bayi nga nagatindug man angud rugto. ");
INSERT INTO krj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nagtungkaaw si Jesus kag nagkuon sa bayi, “Inday, sa diin sanda run? Wara bala ti bisan isara kananda nga naghusgar kanimo?” ");
INSERT INTO krj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nagsabat ang bayi, “Wara gid bisan isara, Sir.” Kag nagkuon si Jesus kana, “Bisan ako wara man nagahusgar kanimo. Panaw run to kag indi run gid ikaw magpakasala liwan.” ");
INSERT INTO krj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Naghambal liwan si Jesus sa mga tawo. Kuon na, “Ako amo ang sulo sa kalibutan. Ang bisan sin-o nga nagasunod kanakun indi run gid magkabuhi sa kadulum kundi makaangkun tana kang kasanag nga nagatao kang kabuhi.” ");
INSERT INTO krj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nagkuon ang mga Fariseo kana, “Ikaw lang man ang nagapamatuod nahanungud sa imong kaugalingun, gani nga ang imo ginapanghambal indi mapatihan.” ");
INSERT INTO krj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nagsabat si Jesus, “Bisan ako ang nagapamatuod nahanungud sa akun kaugalingun ang akun ginapanghambal matuod gid, tungud nga nakamaan ako kon sa diin ako maghalin kag kon sa diin ako magapaagto. Pero kamo tinyo, wara kamo nakamaan kon sa diin ako naghalin ukon diin ako mapaagto. ");
INSERT INTO krj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ang inyo nga paghusgar suno gid lang sa kon ano ang inyo nga pamaagi bilang mga tawo. Ako tana wara nagahusgar sa bisan kay sin-o. ");
INSERT INTO krj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero kon maghusgar gid man ako matarung ang akun paghusgar, tungud nga bukun lang ti ako ang nagahusgar, kundi nga kaimaw ko ang akun Amay nga amo ang nagpadara kanakun rugya. ");
INSERT INTO krj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sa inyo kabay Kasugoan nasulat rugto nga kon nagasinanto ang pamatuod kang darwa ka tawo ang andang ginasugid matuod gid? ");
INSERT INTO krj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ako nagapamatuod nahanungud sa akun kaugalingun, kag ang isara pa gid nga nagapamatuod nahanungud kanakun amo ang akun Amay nga nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ginpamangkot kang mga Fariseo si Jesus, “Sa diin haw ang imong Amay?” Nagsabat si Jesus, “Wara ninyo ako nakilala ukon ang akun Amay. Kon nakilala ninyo ako nakilala man ninyo raad ang akun Amay.” ");
INSERT INTO krj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ginpanghambal dya tanan ni Jesus kang nagapanudlo tana sa templo, rugto nayon sa ginatagoan kang kwarta. Pero wara gid ti may nagdakup kana tungud hay wara pa mag-abot ang anang tion. ");
INSERT INTO krj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nagkuon ruman si Jesus kananda, “Magahalin ako kag pagasagapun ninyo ako, pero magakaramatay kamo nga wara mapatawad ang inyo nga mga kasal-anan. Kag indi kamo makaagto sa akun pagaagtonan.” ");
INSERT INTO krj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dayon nagkuon ang mga pangulo kang mga Judio, “Mapakamatay tana ayhan hay nagkuon tana nga indi kita makaagto sa anang pagaagtonan?” ");
INSERT INTO krj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nagkuon pa gid si Jesus kananda, “Kamo taga-rugya sa idalum; ako takun taga-rugto sa ibabaw. Kamo taga-rugya sa kalibutan, pero ako bukun ti taga-rugya sa kalibutan nga dya. ");
INSERT INTO krj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amo ria gani nga nagkuon ako kaninyo nga magakaramatay kamo nga wara mapatawad ang inyo nga mga kasal-anan. Kon indi kamo magtoo nga ‘Ako amo gid ria Ako’ magakaramatay gid kamo nga wara mapatawad ang inyo nga mga kasal-anan.” ");
INSERT INTO krj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ginpamangkot nanda tana, “Sin-o gid ikaw haw?” Nagsabat si Jesus, “Kon ano ang ginsugid ko kaninyo halin pa kang umpisa amo gid ria ako. ");
INSERT INTO krj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Duro raad ang akun mahambal nahanungud kaninyo kag duro man ang akun ihusgar kaninyo. Pero ang nagpadara kanakun masarigan gid, kag kon ano ang akun nabatian kana, amo man ang akun ginasugid sa mga katawhan sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wara makahangup ang mga nagaparamati nga ang ginahambal ni Jesus amo ang nahanungud sa Amay. ");
INSERT INTO krj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Gani nga nagkuon si Jesus kananda, “Sa tion nga ang Anak kang Tawo ibayawun run ninyo, amo to kag maman-an ninyo nga kon ano ang akun ginsugid amo gid ria ako. Kag maman-an man ninyo nga wara ako nagahambal sa akun lang kaugalingun nga awtoridad kundi nga kon ano ang ginatudlo kanakun kang akun Amay amo lang ang akun ginahambal. ");
INSERT INTO krj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ang nagpadara kanakun rugya kaimaw ko pirme, kag wara na gid ako pagbayai tungud nga sa tanan nga tion ginahimo ko ang bisan ano nga makapahamuut kana.” ");
INSERT INTO krj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kang ginahambal dya ni Jesus raku nga mga tawo ang nagtoo kana. ");
INSERT INTO krj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nagkuon si Jesus sa mga Judio nga nagtoo kana, “Kon padayon kamo nga magtuman sa akun ginapanudlo matuod gid nga mga disipulo ko kamo, ");
INSERT INTO krj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","kag maman-an ninyo kon ano ang kamatuoran kag paagi sa dya nga kamatuoran mahilway kamo.” ");
INSERT INTO krj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nagsabat sanda kana, “Mga kaliwat kami ni Abraham, kag wara gid kami nangin uripun ni bisan sin-o. Andut haw nga naghambal ikaw timo nga mahilway kami?” ");
INSERT INTO krj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nagsabat si Jesus kananda, “Sugidan ko kamo kang matuod: ang bisan sin-o nga nagapakasala uripun tana kang sala. ");
INSERT INTO krj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pareho bala kang uripun sa sangka panimalay, tana kadya bukun ti permanente sa dya nga panimalay. Pero ang bata tana kang tagbalay permanente sa dya nga panimalay. ");
INSERT INTO krj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kar-on, kon ang Anak amo ang magahilway kaninyo, kundi nga matuod run gid tana nga hilway kamo! ");
INSERT INTO krj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakamaan ako nga mga kaliwat kamo ni Abraham. Pero ginatinguhaan pa gid ninyo ako nga ipatyun, tungud hay indi kamo gusto magbaton kang akun mga ginapanudlo. ");
INSERT INTO krj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ginasugid ko kaninyo kon ano ang ginpakita kanakun kang Amay. Kamo tana, kon ano ang ginakuon kang inyo tatay amo man ang inyo ginahimo.” ");
INSERT INTO krj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nagsabat sanda, “Si Abraham amo ang amun ulang.” Nagkuon si Jesus kananda, “Kon matuod nga mga kaliwat kamo ni Abraham, pagahimoon man ninyo raad ang mga ginpanghimo na kato anay. ");
INSERT INTO krj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero kar-on, ginatinguhaan ninyo ako nga ipatyun - ako nga nagsugid lang man kaninyo kang kamatuoran nga akun nabatian sa Dios. Wara naghimo si Abraham kang ginahimo ninyo nga ria. ");
INSERT INTO krj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inyo tana, kon ano ang ginahimo kang inyo nga tatay amo man ang inyo ginahimo.” Nagsabat ang mga Judio, “Bukun tamun ti bata sa luwas! Ang Dios mismo amo gid lang ang amun Tatay.” ");
INSERT INTO krj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nagkuon si Jesus kananda, “Kon matuod nga ang Dios amo ang inyo Tatay, pagahigugmaun ninyo ako hay kana ako maghalin, kag tulad rugya run ako. Wara ako mag-abot rugya sa akun lang kaugalingun nga kabubut-un, kundi nga tana ang nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Andut sa ano nga indi kamo makahangup kang akun ginapanghambal? Hay tungud nga indi kamo makaagwanta sa pagpamati ka akun mga pulong. ");
INSERT INTO krj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kamo, ang inyo nga tatay amo ang Yawa. Kag kon ano ang gusto kang inyo tatay amo man ang inyo gusto nga himoon. Manugpatay tana nga daan halin pa kang una. Wara tana ti labut sa kamatuoran, hay wara gid ti kamatuoran nga masapwan kana. Ang tanan nga ginapanghambal na puro lang binutig. Amo gid ria ang anang kinaugali hay butigun tana kag tana ang ginahalinan kang tanan nga kabutigan. ");
INSERT INTO krj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ako tana nagasugid kaninyo kang kamatuoran, amo ria nga wara kamo nagapati kanakun. ");
INSERT INTO krj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sin-o abi kaninyo ang makapamatuod nga ako nakasala? Kar-on bisan pa nga nagahambal ako kang matuod, andut haw nga indi kamo magpati kanakun? ");
INSERT INTO krj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ang tawo nga ana kang Dios nagapamati sa ginahambal kang Dios. Ang kabangdanan nga wara kamo nagapamati sa anang ginapanghambal amo nga bukun kamo ti ana.” ");
INSERT INTO krj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nagsabat ang mga Judio kana, “Husto gid man kami sa pagkuon nga ikaw Samaritanhun kag nasab-an kang panulay!” ");
INSERT INTO krj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nagkuon si Jesus, “Wara takun nasudlan kang panulay. Ginapadunggan ko lang ang akun Amay, pero kamo, ginainsultohan ninyo ako. ");
INSERT INTO krj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wara takun nagahandum nga mapadunggan ako. Pero may dyan nga nagahandum nga mapadunggan ako kang mga tawo. Kag tana ang nagahusga. ");
INSERT INTO krj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sugidan ko kamo: ang bisan sin-o nga nagatuman kang akun ginahambal indi run gid tana makaagum kang kamatayun.” ");
INSERT INTO krj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dayon nagkuon ang mga Judio kay Jesus, “Kar-on napat-ud run gid namun nga nasab-an ikaw kang panulay. Indi bala nga si Abraham napatay, kag amo man ang mga propeta? Pero kar-on tana nagakuon ikaw nga ang bisan sin-o nga nagatuman kang imong mga ginahambal indi run gid makaagum kang kamatayun. ");
INSERT INTO krj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Labaw pa ikaw haw sangsa amun ulang nga si Abraham? Tana gani napatay, kag ang mga propeta amo man. Sin-o run gid timo haw?” ");
INSERT INTO krj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nagsabat si Jesus, “Kon ako lang ang magpadungug kang akun kaugalingun, wara ti pulos ang dungug ko nga ria. Ang akun Amay nga ginakilala ninyo nga inyo Dios, amo tana ang nagapadungug kanakun. ");
INSERT INTO krj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bisan wara ninyo tana nakilala, ako takun kilala ko tana. Kon magkuon ako nga wara nakun tana nakilala magagwa nga butigun ako pareho kaninyo. Pero kilala ko gid tana kag ginatuman ko ang anang mga pulong. ");
INSERT INTO krj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ang inyo ulang nga si Abraham nalipay ka mayad kang naman-an na nga ako magaabot rugya sa kalibutan. Nakita na gid man kag nasadyahan gid tana.” ");
INSERT INTO krj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nagkuon ang mga Judio kana, “Wara pa gani magsingkwenta ang edad mo, nakita mo run si Abraham?” ");
INSERT INTO krj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nagsabat si Jesus, “Sugidan ko kamo: wara pa matawo si Abraham dya run ako nga daan.” ");
INSERT INTO krj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Amo to kag namurot sanda ka mga bato para batwun si Jesus. Pero si Jesus nagpanago kag maghalin sa templo. ");
INSERT INTO krj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Samtang nagapanaw si Jesus, may nakita tana nga sangka tawo nga bulag halin pa kang anang pagkatawo. ");
INSERT INTO krj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ginpamangkot tana kang anang mga disipulo, “Maestro, andut haw nga natawo tana nga bulag? Sin-o bala ang nakasala, tana ukon ang anang mga ginikanan?” ");
INSERT INTO krj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nagsabat si Jesus, “Natawo nga bulag ang tawo nga dya, indi tungud sa anang sala ukon sa sala kang anang mga ginikanan kundi agud to nga paagi kana mapakita ang gahum kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Samtang adlaw pa kinahanglan gid nga himoon natun ang ginapahimo kang nagpadara kanakun rugya. Hay magaabot ang gabii nga wara run gid ti may makaobra. ");
INSERT INTO krj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Samtang rugya ako sa kalibutan ako ang nagatugro kang kasanag sa mga katawhan sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagkatapos na hambal kadya, nagdupra tana sa lupa, kag naghimo kang lao kag ginhampul dya sa mata kang bulag. ");
INSERT INTO krj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dayon, nagkuon tana sa bulag, “Agto ikaw sa tubig nga pararigosan sa Siloam kag magpanghilam-os.” (Ang buut hambalun kang pulong nga Siloam “Ginpadara.”) Amo to kag nag-agto ang bulag sa Siloam kag nagpanghilam-os, kag kang pagbalik na makakita tana run. ");
INSERT INTO krj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ang anang mga kaingud kag mga tawo nga nakakita kauna kana nga nagapakilimos nagkuon, “Amo bay dya ang tawo nga nagasagi pungko kag nagapakilimos?” ");
INSERT INTO krj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ang iba tana nagkuon nga tana gid man. Pero ang iba tana nagkuon, “Bukun ti tana ria. Anggid lang tana sa tawo nga to.” Pero ang tawo tana mismo nagkuon, “Ako gid tana to.” ");
INSERT INTO krj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ginpamangkot nanda tana, “Ti, paano bay nga makakita run ikaw?” ");
INSERT INTO krj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nagsabat tana, “Ang tawo bala nga ginatawag nanda nga si Jesus naghimo kang lao kag ginhampul na dya sa akun mata. Pagkatapos ginkun-an na ako nga maagto sa Siloam kag magpanghilam-os. Gani nga nag-agto man ako kag magpanghilam-os, kag dayon makakita run ako!” ");
INSERT INTO krj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ginpamangkot pa gid nanda tana, “Sa diin run bay tana?” Nagsabat ang tawo, “Ambay, wara ako kamaan.” ");
INSERT INTO krj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pagkatapos kato, gindara kang mga tawo sa mga Fariseo ang tawo nga kato anay bulag. ");
INSERT INTO krj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Adlaw gali nga Inugpahuway katong si Jesus maghimo kang lao kag ayadun ang tawo nga bulag. ");
INSERT INTO krj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Amo to kag ginpamangkot man kang mga Fariseo ang tawo kon paano nga makakita run tana. Nagsabat tana kananda, “Ginhampulan na kang lao ang akun mata dayon nagpanghilam-os ako, kag makakita run ako.” ");
INSERT INTO krj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ang iba sa mga Fariseo nagkuon, “Ang tawo nga dya bukun ti pinadara kang Dios, tungud hay wara tana nagatuman kang kasugoan nahanungud sa Adlaw nga Inugpahuway.” Pero ang iba tana nagkuon, “Imposible man tana nga ang sangka tawo nga makasasala makahimo kang milagro pareho kadya.” Amo to kag wara sanda magsirinanto. ");
INSERT INTO krj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ginpamangkot liwan nanda ang tawo nga kato anay bulag, “Ikaw tana, ano bay makuon nimo nahanungud sa tawo nga to hay ikaw tana ang anang gin-ayad sa pagkabulag.” Nagsabat ang tawo, “Propeta tana!” ");
INSERT INTO krj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ang mga pangulo kang mga Judio indi magpati sa gihapon nga tana bulag anay kag tulad makakita run. Gani nga ginpatawag nanda ang anang mga ginikanan, ");
INSERT INTO krj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kag ginpamangkot, “Bata ninyo dya tana nga hambal ninyo natawo nga bulag? Ti, andut haw nga makakita run tana tulad?” ");
INSERT INTO krj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nagsabat ang anang mga ginikanan, “Nakamaan kami nga tana bata namun, kag tana natawo nga bulag. ");
INSERT INTO krj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero kon paano nga makakita run tana kadya, kag kon sin-o ang nag-ayad kana wara tamun kamaan karia. Pamangkota ninyo tana. May buut run man tana karia; makasarang run man tana karia sa paghambal para sa anang kaugalingun.” ");
INSERT INTO krj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ginhambal dya kang anang mga ginikanan hay nahadluk sanda sa mga pangulo kang mga Judio. Tungud nga ang mga pangulo kang mga Judio nga dya nagsurogtanay run nga daan nga ang bisan sin-o nga magkilala kay Jesus bilang Cristo pagasikwayun sa sinagoga. ");
INSERT INTO krj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Amo gani ria nga nagkuon sanda nga, “Pamangkota ninyo tana. May buut run man tana karia.” ");
INSERT INTO krj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gintawag ruman nanda ang tawo nga kato anay bulag kag nagkuon sanda kana, “Magsugid ikaw kang matuod sa atubangan kang Dios, hay kon kanamun lang tana, nakamaan kami nga ang tawo nga to makasasala.” ");
INSERT INTO krj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nagsabat ang tawo, “Wara takun kamaan kon makasasala man tana ukon bukun. Ang naman-an ko lang tana, amo nga bulag ako anay, pero tulad makakita run ako.” ");
INSERT INTO krj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ginpamangkot ruman nanda tana, “Ano haw ang ginhimo na kanimo? Paano na ikaw bay gin-ayad?” ");
INSERT INTO krj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nagsabat tana, “Ginsugidan ko run kamo; wara man kamo nagapamati mong. Andut haw nga gusto ruman ninyo mabatian? Gusto ninyo man haw nga mangin anang disipulo?” ");
INSERT INTO krj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Amo to kag gin-insultohan nanda tana, “Disipulo ikaw kang tawo nga to! Kami tamun mga disipulo ni Moises. ");
INSERT INTO krj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nakamaan kami nga ang Dios nagpakighambal kay Moises. Pero kon parte tana sa tawo nga to, wara gani tamun kamaan kon sa diin tana maghalin!” ");
INSERT INTO krj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nagsabat ang tawo, “Abu, katingalahan ba! Gin-ayad na ako sa akun pagkabulag pero makuon kamo nga wara kamo kamaan kon sa diin tana maghalin. ");
INSERT INTO krj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Naman-an bay natun nga ang Dios wara nagasabat sa tawo nga makasasala? Pero ginasabat na ang tawo nga nagatahod kana kag nagatuman sa anang kabubut-un. ");
INSERT INTO krj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Halin pa kauna wara pa gid kita makabati nga may nag-ayad sa tawo nga halin pa sa anang pagkatawo bulag run nga daan. ");
INSERT INTO krj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon ang tawo nga to bukun ti pinadara kang Dios, wara gid tana ti may mahimo.” ");
INSERT INTO krj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ginsabat tana kang mga pangulo kang mga Judio, “Ikaw nga makasasala run nga daan halin pa kang pagkatawo nimo, ikaw pa tulad ang magatudlo kanamun!” Pagkatapos kato ginpalayas nanda tana sa balay-tiriponan kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kar-on, nabatian ni Jesus nga ginpalayas kang mga pangulo kang mga Judio ang tawo nga kato anay bulag. Kang makita na dya, ginkun-an na, “Nagatoo bala ikaw sa Anak kang Tawo?” ");
INSERT INTO krj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nagpamangkot ang tawo, “Sin-o bay tana, Sir? Sogidi ako agud to nga magatoo ako kana.” ");
INSERT INTO krj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nagsabat si Jesus, “Nakita mo run tana. Ang nagapakigsugidanun kanimo tulad kadya amo tana.” ");
INSERT INTO krj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nagkuon ang tawo, “Ginoo, nagatoo ako!” Dayon nagluhod tana sa atubang ni Jesus sa pagsimba kana. ");
INSERT INTO krj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nagkuon si Jesus kana, “Nag-abot ako sa kalibutan para maghusga agud to nga ang mga tawo nga bulag amo sanda ang makakita kag ang mga tawo nga bukun ti bulag amo sanda ang mabulagan.” ");
INSERT INTO krj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ang iba nga mga Fariseo nga rapit kana nakabati sa anang ginkuon, kag nagkuon sanda kana, “Ano ang gusto mo hambalun, nga hasta kami mga bulag man sa kamatuoran?” ");
INSERT INTO krj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nagkuon si Jesus, “Kon mga bulag raad kamo kundi nga wara kamo ti sala. Pero tungud hay nagakuon kamo nga bukun kamo ti bulag sa kamatuoran, nagakahulogan lang nga ang inyo sala rugyan sa gihapon kaninyo.” ");
INSERT INTO krj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nag-istorya si Jesus kang paraanggidan. Kuon na, “Sugidan ko kamo: ang tawo nga nagasulud sa toril kang mga karnero pero wara tana nagaagi sa pwertahan na kadya, kundi nga nagatakras tana sa lain nga aragyan, ria nga tawo takawan kag bandido. ");
INSERT INTO krj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ang tawo tana nga nagaagi sa pwertahan kang toril amo ang manugbantay kang karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ginapasulud tana kang bantay kang pwertahan; ang mga karnero nagapamati sa anang limug. Ginatawag na ang mga karnero sa andang mga ngaran kag ginatuytoyan na sanda pagwa sa toril. ");
INSERT INTO krj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kon mapagwa na run ang tanan na nga mga karnero, nagauna tana kananda sa pagpanaw kag nagasunod sanda kana tungud nga kilala nanda ang anang limug. ");
INSERT INTO krj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ang mga karnero indi gid magsunod sa tawo nga wara nanda makilala. Magaparalagyo sanda kana tungud nga indi nanda makilala ang anang limug.” ");
INSERT INTO krj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gin-istorya kananda ni Jesus ang paraanggidan nga dya pero wara nanda mahangpi kon ano gid ang buut na ipahangup kananda. ");
INSERT INTO krj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gani nga nagkuon ruman si Jesus, “Sugidan ko kamo: ako ang pwertahan nga ginaagyan kang mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ang mga nag-abot una kanakun mga takawan kag bandido. Pero wara magsapak kananda ang mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako amo ang pwertahan. Ang bisan sin-o nga nagaagi kanakun maluwas. Pagusto tana sa pagsulud kag sa paggwa kag makakita tana kang anang hararban. ");
INSERT INTO krj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ang takawan tana nagaabot para lang magpanakaw, magpatay kag magpangguba. Ako tana nag-abot agud to nga paagi kanakun makaangkun sanda kang kabuhi kag maaguman nanda ang mabinungahun nga pagkabuhi. ");
INSERT INTO krj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako ang mayad nga manugbantay kang karnero. Ang mayad nga manugbantay handa magtaya kang anang kabuhi para sa mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ang tawo tana nga ginasuholan lang nga magbantay, ginabayaan na ang mga karnero kag magpalagyo kon makita na nga may lubo nga nagaabot hay bukun tana ti manugbantay kag bukun ti tana ang nagapanag-iya kang mga karnero. Gani ang mga karnero pagatukbun kang lubo kag magahirinuplaag sanda kadya. ");
INSERT INTO krj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ang tawo nga dya magapalagyo tungud nga tana ginasuholan lang kag wara tana nagakabalaka sa mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ako ang mayad nga manugbantay kang karnero. Kilala ko ang akun mga karnero kag kilala man nanda ako, ");
INSERT INTO krj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","pareho nga ako kilala kang akun Amay kag tana kilala ko man. Kag handa ako nga itaya ang akun kabuhi para sa akun mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","May iba pa ako nga mga karnero nga wara rugya sa toril nga dya. Kinahanglan man nga dar-un ko sanda rugya kag sanda magapamati kang akun limug. Kag mangin isara run lang sanda ka panung nga may isara ka manugbantay. ");
INSERT INTO krj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ginahigugma ako kang akun Amay tungud nga ginahalad ko ang akun nga kabuhi agud to nga angkunun dya liwan. ");
INSERT INTO krj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wara ti may makabuul kang akun kabuhi, kundi nga ginatao ko dya kang bulontad. May gahum ako sa pagtao kang akun kabuhi, kag may gahum man ako sa pagbawi kadya. Amo dya ang sugo kanakun kang akun Amay.” ");
INSERT INTO krj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tungud sa mga ginpanghambal nga dya ni Jesus, nagbinahin-bahin ruman ang mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Duro kananda ang nagkuon, “Nasudlan tana kang panulay kag nagaumang. Andut sagad kamo ka pamati kana?” ");
INSERT INTO krj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ang iba tana nagkuon, “Ang tawo nga nasudlan kang panulay indi makahambal kang pareho karia. Kag isara pa, ang panulay indi makaayad kang tawo nga bulag.” ");
INSERT INTO krj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kar-on, nag-abot ang tion nga ang mga Judio nagasaulog sa Jerusalem kang andang Pista nahanungud sa Paghalad kang Templo. Tagraramig run kato, ");
INSERT INTO krj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","kag si Jesus nagapanaw-panaw sa Balkon ni Solomon rugto sa templo. ");
INSERT INTO krj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sa wara lang gid magbuhay kato, may mga Judio nga nagpalibot kana kag nagkuon sanda, “Hasta san-o bay ang imo pagpahawat-hawat kanamun? Kon ikaw amo ang Cristo, sugidi kami kang maathag.” ");
INSERT INTO krj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nagsabat si Jesus, “Ginsugidan ko run kamo, ugaring wara kamo nagapati. Ang mga milagro nga akun ginpanghimo paagi sa awtoridad kang akun Amay amo ang nagapamatuod nahanungud kanakun. ");
INSERT INTO krj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero wara gid man kamo nagapati, tungud nga bukun kamo ti akun mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ang akun mga karnero nagapamati kanakun. Kilala ko sanda kag nagasunod sanda kanakun. ");
INSERT INTO krj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ginatugroan ko sanda kang kabuhi nga wara ti katapusan kag sanda kadya indi gid mapatay. Wara ti bisan sin-o nga makaagaw kananda sa akun alima. ");
INSERT INTO krj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ang akun Amay gamhanan sa tanan, tana ang nagtugyan kananda kanakun. Wara ti bisan sin-o nga makaagaw kananda sa alima kang akun Amay. ");
INSERT INTO krj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako kag ang akun Amay isara gid lamang.” ");
INSERT INTO krj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagkabati kang mga pangulo kang mga Judio sa ginhambal ni Jesus nga to, namurot sanda kang mga bato agud batwun tana. ");
INSERT INTO krj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dayon nagkuon si Jesus kananda, “Naghimo ako kang duro nga mga mayad nga buhat kag nakita ninyo dya. Ginpahimo dya kanakun kang akun Amay. Diin bay sa akun nga mga ginbuhat ang kabangdanan nga batwun ninyo ako?” ");
INSERT INTO krj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nagsabat sanda, “Bukun ti sa mga mayad nimo nga buhat nga batwun ikaw namun, kundi sa kabangdanan nga ginainsultohan nimo ang Dios tungud nga ikaw tawo lang pero ginakabig mo ang imo kaugalingun nga Dios.” ");
INSERT INTO krj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nagkuon si Jesus kananda, “Nasulat kabay sa inyo Kasugoan nga ang Dios naghambal sa mga tawo nga sanda mga dios? ");
INSERT INTO krj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kar-on, kon sanda nga mga gintugyanan kang pulong kang Dios gintawag na nga mga dios—kag ang kasulatan indi pwede baliwaraun— ");
INSERT INTO krj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ako takun ginpili kang Amay mismo kag ginpadara rugya sa kalibutan. Andut haw nga pasibangdan ninyo ako nga ginainsultohan ko ang Dios hay nagkuon ako nga ako anang Anak? ");
INSERT INTO krj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kon wara ako nagahimo kang hirikoton kang Dios, indi kamo magpati kanakun! ");
INSERT INTO krj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero kon ako nagahimo kang hirikoton kang Dios, bisan pa nga indi kamo magpati kanakun mismo, patihi lang ninyo ang akun mga ginapanghimo agud to nga maman-an gid ninyo kamayad nga ang Amay rugya kanakun, kag ako rugyan kana.” ");
INSERT INTO krj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tungud sa ginhambal nga to ni Jesus gintinguhaan ruman nanda tana nga idakpun, pero nakalikaw tana kananda. ");
INSERT INTO krj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Naghalin tana kag nagtabok liwan sa suba kang Jordan, rugto sa lugar nga sa diin si Juan nagpangbawtiso kato anay. Kag nagtiner si Jesus rugto. ");
INSERT INTO krj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Duro nga mga tawo ang nag-aragto kana. Nagkuon sanda, “Wara maghimo kang makatiringala nga buhat si Juan, pero ang tanan nga anang ginpanghambal nahanungud sa tawo nga dya puros matuod.” ");
INSERT INTO krj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kag duro nga mga tawo sa lugar nga to ang nagtoroo kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","May sangka tawo nga ginahingaranan kay Lazaro kag dya tana nagamasakit. Nagaistar tana sa Betania imaw kang anang mga bugto nga sanday Maria kag Marta. ");
INSERT INTO krj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Si Maria nga dya amo ang nagbu-bo anay ka pahamot sa kahig kang Ginoo kag gintrapohan na dya kang anang buhok. Ang ana kadya nga bugto nga si Lazaro amo ang nagamasakit.) ");
INSERT INTO krj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Amo to kag nagpasugo ang magbugto nga sanday Maria kag Marta kay Jesus nga nagakuon, “Ginoo, ang imong suud nga amigo nagamasakit.” ");
INSERT INTO krj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagkabati ni Jesus kadya, nagkuon tana, “Ang masakit nga dya ni Lazaro indi magresulta sa kamatayun, kundi agud to nga mapadunggan ang Dios kag paagi kadya mapadunggan man ang Anak kang Dios.” ");
INSERT INTO krj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Palangga gid ni Jesus si Marta kag ang anang bugto nga si Maria, kag amo man ang andang libayun nga si Lazaro. ");
INSERT INTO krj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero pagkabati ni Jesus nga si Lazaro nagamasakit, nagpaligad pa gid tana kang darwa ka adlaw sa lugar nga anang ginatiniran. ");
INSERT INTO krj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagkatapos karia, nagkuon tana sa anang mga disipulo, “Dali, mabalik ta sa Judea.” ");
INSERT INTO krj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nagsabat sanda, “Maestro, kasan-o lang bay to nga gintinguhaan ikaw nga batwun kang mga Judio, tapos kar-on, mabalik pa ikaw rugto?” ");
INSERT INTO krj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nagsabat si Jesus kananda, “May napulo'g darwa kabay ka oras sa sangka adlaw? Gani kon magpanaw ang tawo samtang may adlaw pa indi tana makasandad, hay masanag pa ang kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero kon sa gabii tana magpanaw, makasandad tana hay madulum ang anang ginapanawan.” ");
INSERT INTO krj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagkahambal na kadya, nagkuon pa gid tana kananda, “Ang atun amigo nga si Lazaro nagakaturog. Maagto ako rugto agud pukawun tana.” ");
INSERT INTO krj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nagsabat ang anang mga disipulo, “Ginoo, kon nagakaturog tana, maayad tana karia.” ");
INSERT INTO krj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abi tana nanda nga nagakaturog matuod sa Lazaro. Pero ang buut tana hambalun ni Jesus nga si Lazaro napatay run. ");
INSERT INTO krj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Gani nga ginsugid lamang ni Jesus kang maathag. Nagkuon tana, “Patay run si Lazaro. ");
INSERT INTO krj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pero tungud kaninyo, nalipay ako nga wara ako rugto, agud to nga magatoo kamo kanakun. Dali kamo run, maagto ta kana.” ");
INSERT INTO krj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas nga ginatawag “Kapid” nagkuon sa anang mga kaimawan nga mga disipulo, “Sige, mapanaw man kita agud to nga mapatay kita imaw kana.” ");
INSERT INTO krj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kang pag-abot ni Jesus sa Betania naman-an na nga si Lazaro apat run ka adlaw nga nalubung. ");
INSERT INTO krj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ang Betania mga tatlo ka kilometro ang anang karayuun sa Jerusalem, ");
INSERT INTO krj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","gani nga raku nga mga Judio ang nag-aragto kanday Marta kag Maria agud lipayun sanda tungud kang pagkapatay kang andang bugto. ");
INSERT INTO krj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kang mabatian ni Marta nga si Jesus nagapaabot, naggwa tana sa pagsug-alaw kana. Pero si Maria tana nagpabilin sa balay. ");
INSERT INTO krj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pag-abot ni Marta kay Jesus, nagkuon tana kadya, “Ginoo, kon rugya ikaw raad, wara mapatay ang akun bugto. ");
INSERT INTO krj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero nakamaan ako nga bisan kadya, ang bisan ano nga imo pangayoon sa Dios igatugro na kanimo.” ");
INSERT INTO krj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nagkuon si Jesus kana, “Ang imong bugto mabuhi liwan.” ");
INSERT INTO krj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nagsabat si Marta, “Huud, naman-an ko nga mabuhi tana liwan kon banhawun run ang mga patay sa urihi nga mga inadlaw.” ");
INSERT INTO krj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dayon nagkuon si Jesus kana, “Ako amo ang nagabanhaw kag ang nagatugro kang kabuhi. Ang bisan sin-o nga nagatoo kanakun, bisan mapatay tana, mabuhi tana liwan. ");
INSERT INTO krj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kag ang bisan sin-o nga buhi pa nga nagatoo kanakun indi run gid mapatay. Nagapati bala ikaw sa ginkuon ko nga dya?” ");
INSERT INTO krj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nagsabat si Marta, “Huud, Ginoo, nagapati ako nga ikaw amo ang Cristo, ang Anak kang Dios, nga magaabot sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkahambal ni Marta kadya, nagbalik tana sa balay kag gintawag si Maria kag ginhani-hanihan, “Rugya ang Maestro, ginapatawag na ikaw.” ");
INSERT INTO krj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagkabati ni Maria kadya, nagdali-dali tana tindug kag mag-agto kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Si Jesus tana wara pa makadangat sa banwa, kundi nga rugto pa tana sa lugar nga ginsug-alawan kana ni Marta. ");
INSERT INTO krj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ang mga Judio tana nga imaw ni Maria sa balay nga nagalipay kana, kang pagkakita nanda nga nagdali-dali tana tindug kag maggwa, nagsunod man sanda kana, hay abi nanda maagto tana sa rulubngan para rugto magparanangisun. ");
INSERT INTO krj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kang pag-abot ni Maria sa lugar nga rugto si Jesus kag pagkakita ni Maria kana, nagluhod tana sa may kahig nayon ni Jesus kag nagkuon, “Ginoo, kon rugya gid ikaw raad, wara mapatay ang akun bugto.” ");
INSERT INTO krj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kang makita ni Jesus si Maria nga nagahibi kag amo man ang mga Judio nga nagtarawas kana, natandug ang anang baratyagun kag natublag gid tana. ");
INSERT INTO krj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dayon nagkuon tana, “Diin ninyo tana ginlubung?” Nagsabat sanda, “Dali bala, Ginoo, kag sulnga.” ");
INSERT INTO krj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Naghibi si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Dayon ang mga Judio nagkuon, “Turuka lang bala ninyo kon daw ano na gid ka palangga si Lazaro!” ");
INSERT INTO krj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero ang iba tana kananda nagmuno, “Gin-ayad na kabay ang tawo nga bulag? Indi na ayhan mahimo nga mapunggan ang pagkamatay kang tawo nga ria?” ");
INSERT INTO krj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Natandug ruman ang baratyagun ni Jesus. Kag nag-agto tana sa may rulubngan. Dya sangka kweba nga anang ba-ba natakpan ka bato. ");
INSERT INTO krj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nagkuon si Jesus, “Bul-a ninyo ang bato!” Si Marta tana nga bugto kang napatay nagkuon, “Pero Ginoo, sa tulad nagapanimaho run tana karia, hay apat run kabay ka adlaw nga napatay tana?” ");
INSERT INTO krj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naghambal si Jesus kana, “Nagkuon kabay ako kanimo nga kon magatoo lang ikaw makita nimo ang pagkagamhanan kang Dios?” ");
INSERT INTO krj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Amo to kag ginbuul nanda ang bato. Dayon nagtangra si Jesus kag naghambal, “Amay, nagapasalamat ako nga ginpamatian mo ako. ");
INSERT INTO krj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naman-an ko nga nagapamati ikaw pirme kanakun. Pero ginakuon ko dya tungud lang kang mga tawo nga nagatirindug rugya kadya agud to nga sanda magapati nga ikaw ang nagpadara kanakun rugya sa kalibutan.” ");
INSERT INTO krj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkakuon kadya ni Jesus, nagsinggit tana, “Lazaro, gwa rugyan!” ");
INSERT INTO krj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kag naggwa ang patay. Ang anang mga alima kag kahig nabarahosan kang panaptun, kag ang anang itsura naputos man kang panaptun. Dayon nagkuon si Jesus kananda, “Badbadi ninyo tana kag papanawa.” ");
INSERT INTO krj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gani, duro sa mga Judio nga nagbisita kanday Maria kag nakakita kang ginhimo ni Jesus ang nagtoroo kana. ");
INSERT INTO krj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ang iba tana kananda nag-agto sa mga Fariseo kag nagsugid kang ginhimo ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gani ang mga pangulo kang kaparian kag ang mga Fariseo nagpatawag kang pagtiriripon kang konseho. Nagkuon sanda, “Ano bay ang himoon ta kadya? Raku run nga mga milagro ang ginahimo kang tawo nga dya. ");
INSERT INTO krj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kon pabay-an lang natun tana nga magpadayon sa ginahimo na nga dya, magatoroo kana ang tanan nga mga tawo. Kag ang matabo, surongon kita kang mga Romanhun kag ranggaun ang atun templo kag ang bug-os natun nga nasyon!” ");
INSERT INTO krj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ang isara kananda kadya nga ginahingaranan kay Caifas, nga amo ang pinakamataas nga pari kang tuig nga to naghambal sa konseho. Kuon na, “Mga wara gid kamo ti naman-an! ");
INSERT INTO krj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wara ninyo haw mapinsari nga mas mayad para kaninyo nga may isara nga mapatay para sa katawhan sangsa malaglag ang bug-os nga nasyon?” ");
INSERT INTO krj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ang matuod karia, wara maghambal si Caifas kang dya nga mga purulongon nga ana-ana lang, kundi nga bilang pinakamataas nga pari kang tuig nga to nagpanagna tana nga si Jesus mapatay para sa nasyon kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kag bukun lang para sa nasyon kundi nga para man tiponon nga mangin isara run lang ang mga kabataan kang Dios nga nagrinapta sa bilog nga kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gani umpisa kang adlaw nga to nagplano ang mga pangulo kang mga Judio nga patyun si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Amo to kag si Jesus wara run nagpasayang-sayang sa mga Judio. Ang ginhimo na, nag-agto tana sa banwa nga ginatawag Efraim, sangka lugar nga marapit sa disyerto. Kag rugto nagtiner tana imaw kang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kar-on, marapit run lang ang Pista kang mga Judio parte sa Paglampuwas Kag raku nga mga tawo ang nagturukad sa Jerusalem halin sa mga kabanwahanan agud himoon ang seremonya parte sa pagpakalimpyo antes ang Pista. ");
INSERT INTO krj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ginasagap nanda si Jesus kag nagapamangkotanay samtang nagatiritindug sanda sa templo. Kuon nanda, “Ano sa banta ninyo, maagto tana ayhan sa Pista?” ");
INSERT INTO krj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pero ang mga pangulo kang kaparian kag ang mga Fariseo nagmando run nga daan nga ang bisan sin-o nga nakamaan kon sa diin si Jesus magsugid kananda agud to nga idakpun nanda si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anum ka adlaw antes ang Pista, nag-abot si Jesus sa Betania, ang lugar nga ginaistaran ni Lazaro, ang tawo nga anang ginbuhi liwan. ");
INSERT INTO krj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kag rugto naghimus sanda kang rayaponon para kay Jesus. Si Marta ang nagasirbe, kag si Lazaro tana isara sa mga nagakaun kaimaw ni Jesus sa lamisa. ");
INSERT INTO krj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria tana nagbuul kang tama gid ka marahalun nga agwa nga puro nardo nga ang anang karakuun kadya mga tunga sa litro. Pagkatapos ginbu-bo na dya sa kahig ni Jesus, kag gintrapohan kang anang buhok. Gintugub ka hamot kang agwa ang bilog nga balay. ");
INSERT INTO krj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Si Judas Iscariote nga isara man sa mga disipulo ni Jesus (nga amo ang magatraidor kana sa urihi), nagkuon, ");
INSERT INTO krj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Andut haw nga wara run lang ginbaligya ang agwa nga dya sa bili nga 300 ka kwarta nga pilak kag ang bayad ipanagtag sa mga pobre?” ");
INSERT INTO krj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ginhambal na dya indi kuon nga nagakabalaka tana sa mga pobre, kundi tungud nga takawan tana. Si Judas nga dya ang nagakaput kang surudlan kang andang kwarta, kag pirme na dya ginabul-an. ");
INSERT INTO krj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nagsabat si Jesus, “Pabay-i lang tana! Pabay-i tana nga itigana dya sa akun lubung. ");
INSERT INTO krj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ang mga imol kaimaw ninyo pirme. Pero ako tana, maabot ang tion nga indi run ninyo makaimaw.” ");
INSERT INTO krj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kar-on, kang nabalitaan kang duro-duro nga mga Judio nga si Jesus rugto sa Betania, nag-aragto sanda rugto. Indi lang tungud kay Jesus kundi nga gusto man nanda makita si Lazaro nga anang ginbuhi liwan halin sa minatay. ");
INSERT INTO krj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Amo to kag nagplano ang mga pangulo kang kaparian nga pati si Lazaro patyun man nanda ");
INSERT INTO krj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","hay tungud kana raku nga mga Judio ang nagbiriya kananda kag nagtoroo kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kang masunod nga adlaw, nabatian kang duro-duro nga mga tawo nga nag-aragto sa Pista nga si Jesus nagapaabot run sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ang ginhimo nanda, nagpamuul sanda kang mga dahon kang palma kag naggurowa sa syudad sa pagsug-alaw kay Jesus. Nagasininggitan sanda nga nagakuon, “Dayawun ta ang Dios!” Pakamayadun ang nagaabot nga ginpadara kang Ginoo; Pakamayadun kang Dios ang Hari kang Israel! ");
INSERT INTO krj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nakakita si Jesus kang sangka tinday nga asno, kag nagsakay tana rugya kadya. Amo gid dya ang ginatumud kang ginakuon sa Kasulatan nga, ");
INSERT INTO krj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Indi kamo magkahadluk, Kamo nga mga taga-Sion; Ang inyo nga hari nagaabot run nga nagasakay sa tinday nga asno!” ");
INSERT INTO krj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sa mga tinion nga to wara mahangpi kang mga disipulo ang kahulogan kang mga nagakaratabo nga to. Pero kang si Jesus nabanhaw run kag ginhimaya, amo to kag nadumduman nanda nga ang nagkaratabo nga dya nasulat run sa Kasulatan parte kana, kag amo dya ang ginhimo kang mga tawo kana. ");
INSERT INTO krj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Duro nga mga tawo ang nakakita katong itawgun ni Jesus si Lazaro sa rulubngan kag ginbuhi na liwan dya halin sa minatay kag dya sanda ang nagsige ka panugid kang andang nakita nga to. ");
INSERT INTO krj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gani nga raku gid nga mga tawo ang nagsug-alaw kay Jesus, hay nabatian nanda nga naghimo tana kang dya nga milagro. ");
INSERT INTO krj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amo to kag ang mga Fariseo nagkinun-anay, “Ti, kita ninyo, wara gid tatun ti may mahimo. Sulnga lang bala ninyo, ang tanan nga tawo nagasurunod run kana!” ");
INSERT INTO krj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kar-on, ang iba sa mga nagturukad sa Jerusalem para magsimba katong Pista, mga Griego. ");
INSERT INTO krj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nagparapit sanda kay Felipe nga taga-Betsaida sa Galilea. Kag nagkuon ang mga Griego kana, “Sir, gusto namun raad makigkita kay Jesus.” ");
INSERT INTO krj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ginsugid dya ni Felipe kay Andres. Kag sanda nga darwa nag-agto kag magsugid kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nagsabat si Jesus kananda, “Nag-abot run ang tion nga ang Anak kang Tawo pagahimayaun. ");
INSERT INTO krj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sugidan ko kamo: ang sangka binhi kang trigo, kon indi magtupa sa lupa kag mapatay, mapabilin lang dya nga sangka binhi gihapon. Pero kon ang dya nga binhi mapatay, magapamunga dya kang duro-duro. ");
INSERT INTO krj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ang tawo nga ginapalabi na gid ka mayad ang anang kabuhi, maduraan tana ka dya. Pero ang tawo tana nga wara nagapasulabi kang anang kabuhi sa kalibutan nga dya, amo tana ang makaangkun kang kabuhi nga wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ang bisan sin-o nga malyag mag-alagad kanakun kinahanglan magsunod tana kanakun, kag kon sa diin ako rugto man ang akun alagad. Ang nagaalagad kanakun pagapadunggan kang akun Amay.” ");
INSERT INTO krj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nagkuon pa gid si Jesus, “Kar-on, natublag gid ang akun baratyagun. Ano bay? mahambal bala ako nga, ‘Amay, luwasa ako sa mga pag-antos nga akun pagaatubangun’? Indi ako makakuon karia, hay amo gid ria ang kabangdanan kang akun pag-abot rugya.” ");
INSERT INTO krj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pagkatapos nagkuon tana, “Amay, padunggi ang imong ngaran.” Dayon may limug nga naghambal halin sa langit nga nagakuon, “Ginpadunggan ko run, kag pagapadunggan ko pa gid liwan.” ");
INSERT INTO krj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nabatian dya kang mga tawo nga nagatirindug rugto kato, kag nagkuon sanda, “Nagpangdaguub!” Ang iba tana nagkuon, “May nagpakighambal kana nga anghel!” ");
INSERT INTO krj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nagkuon si Jesus, “Ang limug nga to naghambal para sa inyo kaaraydan kag bukun para kanakun. ");
INSERT INTO krj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kadya run ang tion nga pagahukman kang Dios ang mga katawhan sa kalibutan. Kag kadya man ang tion nga mapyerde si Satanas nga amo ang nagagahum sa kalibutan nga dya. ");
INSERT INTO krj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ako takun, kon ibayawun run gani ako halin sa lupa, ipaparapitun ko ang tanan nga tawo kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ginhambal dya ni Jesus agud ipamaan kon ano nga sahi kang kamatayun ang anang pagaagumun. ");
INSERT INTO krj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nagsabat ang mga tawo, “Suno sa amun Kasugoan, ang Cristo indi mapatay hasta san-o. Andut haw nga nagakuon ikaw nga ang Anak kang Tawo kinahanglan nga ibayawun? Sin-o dya haw ang Anak kang Tawo nga dya nga imo ginatumud?” ");
INSERT INTO krj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nagsabat si Jesus kananda, “Indi run lang magbuhay kag madura ang kasanag kaninyo. Magtoo kamo sa sulo samtang rugyan pa kaninyo ang kasanag, agud to nga indi kamo maabotan kang kadulum. Ang tawo nga nagapanaw sa kadulum indi tana kamaan kon sa diin tana nagapaagto. ");
INSERT INTO krj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gani magtoo kamo sa sulo samtang rugya pa dya kaninyo agud to nga mangin mga tawo kamo nga nasanagan run.” Pagkahambal ni Jesus kadya, ginbayaan na sanda kag wara run magpakita. ");
INSERT INTO krj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan pa nga nakita run kang mga Judio ang tanan nga mga milagro nga ginhimo ni Jesus wara gihapon sanda magtoo kana. ");
INSERT INTO krj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Natabo dya agud matuman ang ginkuon anay ni propeta Isaias sa anang sinulat nga, “Ginoo, sin-o lang gid ayhan ang nagpati sa amun nga mensahe, Kag kay sin-o ginpahayag kang Ginoo ang anang gahum?” ");
INSERT INTO krj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Indi sanda makatoo hay pareho kang ginkuon man anay ni Isaias, ");
INSERT INTO krj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ginbulag sanda kang Dios kag ginsarado na ang andang mga panghuna-huna agud to nga ang andang mga mata indi makakita kag ang andang mga paminsarun indi makahangup, kag kuon kang Dios, indi man sanda magliso kanakun para nga ayadun ko sanda.” ");
INSERT INTO krj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ginkuon dya ni Isaias tungud hay nakita na run nga daan ang pagkagamhanan ni Jesus, kag naghambal man tana nahanungud kay Jesus. ");
INSERT INTO krj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wara ti sapayan karia, bisan sa mga manugdumara kang mga Judio raku kananda ang nagtoroo kay Jesus. Pero wara nanda ginapanugid ang andang pagtoo tungud hay nahadluk sanda nga isikwayun kang mga Fariseo sa andang sinagoga. ");
INSERT INTO krj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hay mas ginapasulabi nanda nga dayawun sanda kang mga tawo sangsa dayawun sanda kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dayon naghambal si Jesus ka tunog nga nagakuon, “Ang tawo nga nagatoo kanakun bukun lang ti ako ang anang ginatoohan kundi nagatoo man tana sa nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kag ang nakakita kanakun nakakita run man sa nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nag-abot ako rugya sa kalibutan para magtugro kang kasanag sa mga tawo agud to nga ang bisan sin-o nga magatoo kanakun indi run magpabilin sa kadulum. ");
INSERT INTO krj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ang tawo nga nakabati run kang akun mga ginpanghambal pero wara na dya pagtumana, bukun ti ako ang magahusgar kana, hay wara ako mag-abot rugya sa kalibutan agud nga manghusgar sa katawhan, kundi para nga iluwasun ko sanda. ");
INSERT INTO krj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","May magahusgar tana sa tawo nga wara nagabaton kanakun kag wara nagapati sa akun mga ginpanghambal. Ang mga pulong nga akun ginpanghambal amo ang magahusgar kana nga silotan tana sa urihi nga adlaw. ");
INSERT INTO krj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tungud nga wara ako naghambal sa akun lang kaugalingun nga awtoridad; ang akun Amay nga amo ang nagpadara kanakun amo tana ang nagsugo kanakun kon ano ang akun dapat ihambalun ");
INSERT INTO krj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kag nakamaan ako nga ang anang sugo nagatugro kang kabuhi nga wara ti katapusan. Kon ano ang akun ginakuon amo ria ang ginsugo kanakun kang Amay nga akun ikuon.” ");
INSERT INTO krj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kar-on, bisperas run kang Pista kang Paglampuwas. Naman-an ni Jesus nga nag-abot run ang tion nga tana magataliwan sa dya nga kalibutan kag magabalik sa Amay. Halin kauna ginhigugma na gid ang anang mga sumuronod rugya sa kalibutan kag ginhigugma na gid sanda hasta sa katapusan. ");
INSERT INTO krj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pagkagabii kato, si Jesus kag anang mga disipulo nagarayapon. Si Judas Iscariote tana, nga bata ni Simon, ginbutang run nga daan kang yawa sa anang panghuna-huna nga luiban si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Naman-an ni Jesus nga gintugyan run kang Amay ang tanan nga butang sa anang gahum, kag naman-an na man nga tana sa Dios maghalin kag magabalik man sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Samtang nagayapon sanda, nagtindug tana, gin-uba na ang anang kunup, kag pagkatapos nagbuul tana ka twalya kag ginwagkus sa anang hawak. ");
INSERT INTO krj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagkatapos karia, nagbutang tana kang tubig sa labador kag ginhugasan ang mga kahig kang mga disipulo. Kag pagkatapos ginatrapohan na dya kang twalya nga nawagkus sa anang hawak. ");
INSERT INTO krj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pag-abot na kay Simon Pedro, nagkuon dya kana, “Ginoo, hugasan mo haw ang akun kahig?” ");
INSERT INTO krj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nagsabat si Jesus, “Tulad kadya indi mo pa maman-an ang buut hambalun kang ginahimo ko nga dya, pero sa urihi mahangpan mo man.” ");
INSERT INTO krj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nagkuon si Pedro, “Indi gid ikaw maghugas kang akun kahig!” Nagsabat si Jesus, “Kon indi ko paghugasan ang imong kahig, wara ikaw ti kaangtanan kanakun!” ");
INSERT INTO krj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dayon nagkuon si Pedro, “Ti, kon mag-amo karia, Ginoo, bukun lang ti akun kahig ang imo nga hugasan, pati man ang akun alima kag ulo!” ");
INSERT INTO krj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nagsabat si Jesus kana, “Ang tawo nga nakaparigos run, limpyo run ang bilog na nga lawas, gani nga indi run kinahanglan nga manghugas pa tana, luwas lang kang anang kahig. Kamo mga limpyo run, pero bukun ti tanan kamo.” ");
INSERT INTO krj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hay naman-an ni Jesus kon sin-o ang magaluib kana, amo ria nga nagkuon tana nga limpyo run sanda, pero bukun ti tanan. ");
INSERT INTO krj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagkatapos na ka hugas kang andang kahig, ginsuksok na liwan ang anang kunup kag magbalik sa anang ginapungkoan. Kag namangkot tana sa anang mga disipulo, “Nahangpan bala ninyo kon ano ang buut hambalun kang akun ginhimo kaninyo? ");
INSERT INTO krj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ginatawag ninyo ako nga ‘Maestro’ kag ‘Ginoo’ kag husto gid man kamo, hay amo gid man ria ako. ");
INSERT INTO krj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kar-on, kon ako nga inyo Maestro kag Ginoo naghugas kang inyo nga kahig, kinahanglan man nga maghinugasay kamo kang inyo nga mga kahig. ");
INSERT INTO krj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gintaw-an ko kamo kang halimbawa nga inyo dapat himoon kon ano ang akun ginhimo kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sugidan ko kamo: wara ti surugoon nga labaw pa sa anang agalun, kag wara ti tawo nga ginsugo nga labaw pa sa nagsugo kana. ");
INSERT INTO krj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kar-on, hay naman-an run ninyo ang mga kamatuoran nga dya, malipayun kamo kon inyo dya nga himoon.” ");
INSERT INTO krj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Pero bukun ti kamo tanan ang akun ginatumud. Kilala ko ang akun mga ginpili. Ogaring kinahanglan gid nga matuman ang ginakuon sa Kasulatan nga, ‘Ang tawo nga nagasaro kanakun amo pa ang nagkontra kanakun.’ ");
INSERT INTO krj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ginasugid ko nga daan dya kaninyo sa wara pa matabo, agud to nga kon matabo run gani dya magatoo kamo nga ang ginakuon ko nahanungud sa akun kaugalingun amo gid ria ako. ");
INSERT INTO krj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sugidan ko kamo: ang bisan sin-o nga magabaton sa tawo nga akun ginapadara nagabaton man kanakun. Kag ang nagabaton kanakun, nagabaton man sa nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkahambal ni Jesus kadya, natublag gid ang anang baratyagun, kag nagsugid kang bunayag nga, “Sugidan ko kamo: ang isara kaninyo magaluib kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nagtinurukay ang mga disipulo nga nagalibug ang andang ulo kon sin-o kananda ang ginatumud ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ang isara kananda, ang disipulo nga palangga gid ka mayad ni Jesus, nagapungko sa ingud na. ");
INSERT INTO krj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ginsenyasan tana kadya ni Simon Pedro nga pamangkoton si Jesus kon sin-o ang anang ginatumud. ");
INSERT INTO krj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gani nagsandiay tana sa dughan ni Jesus kag namangkot, “Ginoo, sin-o ang ginatumud mo?” ");
INSERT INTO krj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nagsabat si Jesus, “Ang akun pagatugroan kang tinapay nga dya pagkatapos nga isawsaw ko, amo ria tana.” Gani nga pagkasawsaw ni Jesus kang tinapay, gindawu na dya kay Judas Iscariote nga bata ni Simon. ");
INSERT INTO krj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagkabaton ni Judas kang tinapay, nagsulud dayon si Satanas kana. Nagkuon si Jesus kana, “Himoa dayon kon ano ang imo nga pagahimoon.” ");
INSERT INTO krj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wara ti bisan isara kananda rugto nga nagapurungko ang nakamaan kon andut nga ginkuon dya ni Jesus kay Judas. ");
INSERT INTO krj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tungud gani nga si Judas ang nagakaput kang surudlan kang andang kwarta, nagpinsar ang iba nga ginsugo tana ni Jesus nga magbakal kang andang mga kinahanglan para sa Pista, ukon magtugro kang limos sa mga pobre. ");
INSERT INTO krj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gani, kang pagkabaton ni Judas kang tinapay naggwa tana dayon. Kag gabii pa abi kato. ");
INSERT INTO krj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagkahalin ni Judas, nagkuon si Jesus, “Kar-on, ang Anak kang Tawo ginpadunggan run, kag paagi kana pagapadunggan man ang Dios. ");
INSERT INTO krj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kag kon ang Dios pagapadunggan paagi kana, pagapadunggan man tana kang Dios. Kag dya pagahimoon kang Dios lagi-lagi. ");
INSERT INTO krj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kamo nga mga ginakabig ko nga akun mga kabataan, indi run lang buhay ang pagpakig-imaw ko kaninyo. Pagasagapun ninyo ako pero pareho kang akun ginkuon sa mga pangulo kang mga Judio, ikuon ko man dya kaninyo nga, ‘Indi kamo makaagto sa akun pagaagtonan.’ ");
INSERT INTO krj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kar-on, may sangka bag-o ako nga sugo kaninyo: maghigugmaanay kamo. Hay ginhigugma ko kamo, dapat kamo man maghigugmaanay. ");
INSERT INTO krj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kon kamo nagahigugmaanay, dyan karia maman-an kang tanan nga tawo nga kamo akun mga disipulo.” ");
INSERT INTO krj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ginpamangkot tana ni Simon Pedro, “Ginoo, sa diin bay ikaw maagto?” Nagsabat si Jesus, “Kon sa diin man ako maagto, indi ikaw makasunod kanakun sa tulad. Pero sa pira ka adlaw masunod man ikaw.” ");
INSERT INTO krj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Namangkot si Pedro, “Ginoo, andut haw nga indi ako makasunod kanimo sa tulad? Handa ako mapatay para kanimo!” ");
INSERT INTO krj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nagsabat si Jesus, “Handa gid bala ikaw magbuwis kang imong kabuhi para kanakun? Sugidan ko ikaw: antes magpamalo ang sulog, ipanginwara mo ako kang tatlo ka beses.” ");
INSERT INTO krj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nagkuon si Jesus kananda, “Indi kamo magpalibug. Magtoo kamo sa Dios, kag magtoo man kamo kanakun. ");
INSERT INTO krj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Rugto sa balay kang akun Amay raku ang mga iristaran. Kon bukun dya ti matuod indi ko dya pag-isugid kaninyo. Magaagto ako rugto para maghanda kang lugar para kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kag kon makahanda run gani ako kang lugar para kaninyo, magabalik ako rugya kag ibul-un ko kamo para mag-imaw kanakun, agud to nga bisan diin ako rugto man kamo. ");
INSERT INTO krj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Naman-an man ninyo ang dalan paagto sa akun pagaagtonan.” ");
INSERT INTO krj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nagkuon si Tomas kana, “Ginoo, wara tamun kamaan kon sa diin ikaw maagto, paano bay namun maman-an ang dalan paagto rugto?” ");
INSERT INTO krj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nagsabat si Jesus, “Ako amo ang dalan, ang kamatuoran, kag ang kabuhi. Wara ti bisan sin-o nga makaagto sa Amay kon indi paagi kanakun. ");
INSERT INTO krj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kon nakilala ninyo ako kilala run man ninyo ang Amay. Umpisa kadya nakilala run ninyo tana kag nakita run man.” ");
INSERT INTO krj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nagkuon si Felipe, “Ginoo, ipakita kanamun ang Amay, kag tuman run ria para kanamun.” ");
INSERT INTO krj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nagsabat si Jesus, “Ay Felipe, buhay run ang akun pagpakig-imaw kaninyo, pero hasta tulad wara mo pa gihapon ako makilala? Ang bisan sin-o nga nakakita kanakun, nakakita run man sa Amay. Andut haw nga makuon pa ikaw nga ipakita ko kaninyo ang Amay? ");
INSERT INTO krj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wara ikaw haw nagapati nga ako may suud nga kaangtanan sa Amay kag ang Amay may suud nga kaangtanan man kanakun? Ang mga pulong nga akun ginapanghambal kaninyo bukun sa akun kaugalingun naghalin. Ang Amay nga rugya kanakun amo ang nagahimo kang anang hirikoton. ");
INSERT INTO krj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Magpati kamo kanakun kon magkuon ako nga ako may kaangtanan sa Amay kag ang Amay may kaangtanan man kanakun. Ukon indi, magpati kamo kanakun tungud kang mga makatiringala nga buhat mismo nga inyo nakita. ");
INSERT INTO krj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sugidan ko kamo: ang nagatoo kanakun magahimo man kang mga butang nga akun ginapanghimo. Kag mas pa gani ang anang pagahimoon tungud nga mabalik run ako sa Amay. ");
INSERT INTO krj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kag ang bisan ano nga inyo pangayoon sa akun ngaran, pagahimoon ko, agud to nga ang Amay mapadunggan paagi sa Anak. ");
INSERT INTO krj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kon mangayo kamo kang bisan ano sa akun ngaran, himoon ko gid ang inyo ginapangayo.” ");
INSERT INTO krj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nagkuon pa gid si Jesus, “Kon ginahigugma ninyo ako, pagatumanun ninyo ang akun mga sugo. ");
INSERT INTO krj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kag magapangayo ako sa Amay, kag pagataw-an na kamo kang isara pa gid nga Manugbulig nga magapabilin rugyan kaninyo hasta sa wara ti katapusan. ");
INSERT INTO krj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Amo dya ang Balaan nga Ispirito nga magatudlo kaninyo kang kamatuoran. Ang mga tawo sa kalibutan nga dya indi makabaton kana tungud hay indi nanda dya makita ukon makilala. Pero kamo tana, kilala ninyo tana tungud nga nagaistar tana kag rugyan mismo kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Indi ko gid kamo pagbayaan nga daw mga ilo kamo. Magabalik ako kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Indi run lang buhay kag indi run ako makita kang mga tawo rugya sa kalibutan nga wara makakilala sa Dios. Pero kamo, makita ninyo ako. Kag tungud nga ako buhi, kamo magakabuhi man. ");
INSERT INTO krj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sa pag-abot kang adlaw nga to, maman-an run gid ninyo nga ako may suud nga kaangtanan sa Amay kag kamo may suud nga kaangtanan kanakun, kag ako may suud man kaangtanan kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ang tawo nga nakabaton kag nagatuman kang akun mga sugo amo tana ang nagahigugma kanakun. Ang nagahigugma kanakun, pagahigugmaun man kang akun Amay. Higugmaun ko man tana kag ipahayag ko ang akun kaugalingun kana.” ");
INSERT INTO krj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Si Judas tana (bukun dya ti si Judas Iscariote) nagkuon, “Ginoo, andut nga kanamun lang ikaw magapahayag kang imong kaugalingun, kag bukun ti sa mga tawo sa kalibutan?” ");
INSERT INTO krj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nagsabat si Jesus, “Ang bisan sin-o nga nagahigugma kanakun magatuman kang akun mga ginapanudlo. Higugmaun tana kang akun Amay, kag kami kang akun Amay magasulud kag magaistar kana. ");
INSERT INTO krj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pero ang tawo tana nga wara nagahigugma kanakun wara man nagatuman kang akun mga ginapanudlo. Ang mga pulong nga inyo nabatian nga akun ginapanudlo bukun ti sa akun kaugalingun naghalin kundi sa Amay nga amo ang nagpadara kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tanan nga dya ginsugid ko run kaninyo samtang ako kaimaw pa ninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero ang Manugbulig nga amo ang Balaan nga Ispirito nga igapadara kang Amay kaninyo sa akun ngaran, tana ang magatudlo kaninyo kang tanan nga butang kag magapahanumdum kaninyo kang tanan nakun nga ginkuon kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ginataw-an ko kamo kang kalinung. Ang kalinung nga rugya kanakun mismo amo ang igatao ko kaninyo. Ang dya nga kalinung bukun ti pareho kang ginatao kang mga tawo rugya sa kalibutan. Indi kamo magpalibug ukon magkahadluk. ");
INSERT INTO krj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nabatian run ninyo ako nga nagkuon nga ‘magahalin ako pero magabalik man ako kaninyo.’ Kon ginahigugma ninyo ako, magakalipay kamo raad nga ako magabalik sa Amay tungud nga labaw tana sangsa kanakun. ");
INSERT INTO krj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kar-on ginasugid ko dya tanan kaninyo sa wara pa matabo, agud to nga kon matabo run dya gani magatoo kamo kanakun. ");
INSERT INTO krj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Indi ko run pagpalawidun ang akun paghambal kaninyo, hay nagaabot run si Satanas nga amo ang nagagahum sa kalibutan nga dya. Wara tana ti gahum kanakun, ");
INSERT INTO krj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero kinahanglan gid nga maman-an kang katawhan sa kalibutan nga ako nagahigugma sa Amay, gani nga ginatuman ko ang tanan na nga ginasugo kanakun. Dali kamo run! Panaw ta!” ");
INSERT INTO krj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Naghambal pa gid si Jesus, “Ako amo ang matuod nga puno kang ubas, kag ang akun Amay tana amo ang manugtatap. ");
INSERT INTO krj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ang kada sanga nakun nga wara nagapamunga ginatapas na. Kag ang kada sanga tana nga nagapamunga ginahawanan na agud to nga magpamunga pa gid kang duro. ");
INSERT INTO krj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamo ginlimpyohan run paagi sa mga pulong nga akun ginhambal kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Magpabilin kamo nga suud ang inyo kaangtanan kanakun, kag ako magapabilin man nga suud ang akun kaangtanan kaninyo. Hay ang sanga indi makapamunga sa anang kaugalingun lang kon wara dya naangut sa puno. Kamo amo man karia. Indi man kamo makapamunga kon wara nagapabilin nga suud ang inyo kaangtanan kanakun. ");
INSERT INTO krj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ako amo ang puno kang ubas, kag kamo tana ang mga sanga. Ang sin-o man nga nagapabilin nga suud ang anang kaangtanan kanakun, kag ako amo man kana, magapamunga tana kang duro-duro gid, hay luwas kanakun wara kamo ti sarang mahimo. ");
INSERT INTO krj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ang bisan sin-o nga wara nagapabilin nga suud ang anang kaangtanan kanakun daw pareho kang sanga nga gintablug kag nagakalayung. Dya nga sanga ginatipon kag ginapilak sa kalayo kag ginasunog. ");
INSERT INTO krj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kon magapabilin kamo nga suud ang inyo kaangtanan kanakun, kag ang akun mga pulong nagapabilin man sa inyo nga mga tagipusoon, pangayo kamo kang bisan ano nga gusto ninyo kag inyo dya nga mabaton. ");
INSERT INTO krj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ang akun Amay ginapadunggan paagi sa inyo nga pagkabuhi nga nagabunga kang duro-duro, kag paagi dyan karia mapamatud-an nga kamo mga disipulo nakun. ");
INSERT INTO krj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kon paano nga ako ginhigugma kang Amay, kamo man ginhigugma ko. Magpabilin kamo sa akun paghigugma. ");
INSERT INTO krj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kon nagatuman kamo kang akun mga sugo magapabilin kamo sa akun gugma pareho kanakun nga nagtuman ako sa sugo kang akun Amay kag nagapabilin sa anang paghigugma kanakun. ");
INSERT INTO krj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ginsugid ko kaninyo ang mga butang nga dya agud to nga maaguman ninyo ang akun kalipay kag mangin bug-os gid ang inyo kalipay. ");
INSERT INTO krj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Amo dyaay ang akun sugo kaninyo, nga maghigugmaanay kamo pareho kang akun paghigugma kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wara ti paghigugma nga makalabaw pa sa paghigugma kang sangka tawo nga magatugro kang anang kabuhi para sa anang mga amigo. ");
INSERT INTO krj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kag kamo mga amigo nakun kon nagatuman kamo kang akun mga sugo kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wara ko run kamo ginatawag nga mga surugoon, tungud nga ang surugoon wara nakamaan kon ano ang ginahimo kang anang agalun. Sa baylo, ginatawag ko run kamo nga mga amigo, hay ang tanan nga ginsugid kang akun Amay kanakun ginpamaan ko man kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bukun ti kamo ang nagpili kanakun, kundi nga ako amo ang nagpili kaninyo, kag ginpili ko kamo nga magkabuhi nga nagapamunga kang bunga nga magapabilin hasta san-o. Kon amo dya ang inyo himoon, itugro kang Amay ang bisan ano nga pangayoon ninyo sa akun ngaran. ");
INSERT INTO krj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gani amo dya ang akun sugo kaninyo, nga maghigugmaanay gid kamo.” ");
INSERT INTO krj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Naghambal pa gid si Jesus, “Kon ang kalibutan nga dya nga nagakontra sa Dios nagadumut kaninyo, panumdumun ninyo nga ako ang una na nga gindumtan. ");
INSERT INTO krj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kon kamo bahin kang kalibutan nga dya nga nagakontra sa Dios pagapalanggaun na kamo hay kamo mga kaimaw na. Pero tungud nga bukun kamo ti bahin kang kalibutan nga dya hay ginpili ko run kamo halin kana, amo ria nga ginadumtan na kamo. ");
INSERT INTO krj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Panumduma ninyo ang ginkuon ko anay kaninyo nga wara ti surugoon nga labaw pa sangsa anang agalun. Gani nga kon ginhingabot ako kang kalibutan nga nagakontra sa Dios, kamo man pagahingaboton nanda. Kon nagtuman sanda kang akun mga ginpanudlo, tumanun man nanda ang inyo nga igatudlo. ");
INSERT INTO krj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amo dya ang himoon nanda kaninyo tungud kang inyo kaangtanan kanakun hay sanda kadya wara makakilala sa Amay nga amo ang nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kon wara ako mag-abot kag maghambal kananda, wara raad sanda ti sarabtun sa andang kasal-anan, pero kadya wara run gid sanda ti may ibaribad sa andang mga kasal-anan. ");
INSERT INTO krj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ang tawo nga nagadumut kanakun, nagadumut man sa akun Amay. ");
INSERT INTO krj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kon wara ako maghimo sa tunga nanda kang mga katingalahan nga indi mahimo ni bisan sin-o, wara raad sanda ti sarabtun sa andang mga kasal-anan. Kar-on hay nakita nanda dya nga mga butang, gindumtan nanda ako sa gihapon kag ang akun Amay. ");
INSERT INTO krj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sa ginhimo nanda nga dya natuman ang ginakuon sa andang kasulatan nga, ‘Gindumtan nanda ako nga wara ti kabangdanan.’” ");
INSERT INTO krj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Naghambal pa gid si Jesus sa anang mga disipulo, “Magapadara ako kaninyo kang Manugbulig nga magahalin sa Amay. Tana amo ang Ispirito nga nagatudlo kang kamatuoran, kag tana kadya sa Amay magahalin. Sa anang pag-abot, magapamatuod tana nahanungud kanakun. ");
INSERT INTO krj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kag kamo magapamatuod man nahanungud kanakun, tungud nga sa umpisa pa lang kaimaw ko run kamo.” ");
INSERT INTO krj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ginsugid ko dya tanan kaninyo agud to nga indi madura ang inyo nga pagsarig kanakun. ");
INSERT INTO krj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pagasikwayun nanda kamo sa mga sinagoga. Luwas dyan karia, magaabot ang tion nga ang magapatay kaninyo magahuna-huna nga nagaalagad tana sa Dios. ");
INSERT INTO krj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Himoon nanda dya tungud hay wara nanda makilala ang Amay ukon ako. ");
INSERT INTO krj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ginsugid ko run dya kaninyo agud to nga sa pag-abot kang tion nga himoon nanda dya kaninyo madumduman ninyo nga ginpaandaman ko run kamo.” “Wara nakun dya ginsugid kaninyo sa umpisa pa lang hay kaimaw pa ninyo ako. ");
INSERT INTO krj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kar-on tana magabalik run ako sa nagpadara kanakun. Pero wara ti bisan isara kaninyo nga nagpamangkot kanakun kon sa diin ako maagto. ");
INSERT INTO krj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Anay hay ginsugid ko dya kaninyo, nagpangasubu gid kamo. ");
INSERT INTO krj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero ginasugid ko kaninyo ang matuod: ang akun nga paghalin para sa inyo kaaraydan, hay kon indi ako maghalin indi man mag-abot kaninyo ang Manugbulig. Pero kon maghalin ako ipadara ko tana kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sa anang pag-abot ipamatud-an na sa mga katawhan sa kalibutan nga sayup ang andang pagpati nahanungud sa sala, nahanungud sa pagkamatarung, kag nahanungud sa paghukum kang Dios. ");
INSERT INTO krj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sayup sanda sa andang ginapatihan nahanungud sa sala tungud nga wara sanda nagatoo kanakun. ");
INSERT INTO krj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Sayup man sanda nahanungud sa pagkamatarung tungud hay magabalik ako sa Amay kag indi run ninyo ako makita. ");
INSERT INTO krj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kag kon parte sa paghukum kang Dios, sayup man sanda tungud hay ang nagagahum sa kalibutan nga dya nahukman run nga pagasilotan. ");
INSERT INTO krj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Duro pa daad ang akun igasugid kaninyo, pero indi pa ninyo dya mahangpan sa tulad. ");
INSERT INTO krj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kon mag-abot run gani ang Ispirito nga amo ang nagapahayag kang kamatuoran, tuytoyan na kamo para mahangpan ninyo ang tanan nga kamatuoran. Indi tana maghambal sa ana lang kaugalingun nga awtoridad, kundi nga kon ano ang anang mabatian amo lang ang anang igahambal. Isugid na kaninyo ang mga matabo sa paraaboton. ");
INSERT INTO krj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pagapadunggan na ako hay ang ana ipahayag kaninyo kanakun magahalin. ");
INSERT INTO krj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ang tanan nga ana kang Amay akun, amo ria gani nga nagkuon ako nga ang igapahayag kaninyo kang Balaan nga Ispirito kanakun magahalin.” ");
INSERT INTO krj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Indi run lang buhay kag indi run ninyo ako makita. Pagkatapos, sa indi magbuhay makita ruman ninyo ako.” ");
INSERT INTO krj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ang iba sa mga disipulo nagkinun-anay, “Ano bay ang buut hambalun kang anang ginakuon nga indi run lang buhay kag indi run natun tana makita, kag pagkatapos, sa indi magbuhay makita ruman natun tana, kag nagkuon pa gid tana nga ‘tungud nga magabalik ako sa akun Amay?’” ");
INSERT INTO krj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nagsige sanda ka pamangkotanay, “Ano ang buut hambalun kang anang ginakuon nga indi run lang buhay man? Indi natun mahangpan ang anang ginakuon haw!” ");
INSERT INTO krj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nasat-uman ni Jesus nga gusto nanda mamangkot kana, gani nga nagkuon tana kananda, “Nagapinamangkotanay kamo kon ano ang buut hambalun kang akun ginakuon nga indi run lang buhay kag indi run ninyo ako makita kag pagkatapos, sa indi magbuhay makita ruman ninyo ako? ");
INSERT INTO krj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sugidan ko kamo: magaparanangisun kamo kag magapangasubu samtang ang katawhan sa kalibutan magakalipay. Magakasubu kamo pero ang kasubu ninyo nga ria mabaylohan kang kalipay. ");
INSERT INTO krj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pareho bala kang bayi nga manugbata. Nagabatyag tana kang kasakit hay nag-abot run ang tion kang anang pag-antos. Pero kon makabata run gani tana malipatan na ang anang pagpasakit tungud sa anang kalipay nga may sangka bata nga natawo sa kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Amo man ria kaninyo: tulad kadya nagakasubu kamo. Pero makitaay kita liwan kag sa amo to nga tion magakalipay gid kamo kag wara gid ti bisan sin-o nga makaagaw kang inyo kalipay. ");
INSERT INTO krj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Sa amo to nga tion indi run kamo magpamangkot kanakun kang bisan ano. Sugidan ko kamo: bisan ano ang inyo nga pangayoon sa Amay sa akun ngaran, igatugro na ria kaninyo. ");
INSERT INTO krj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta tulad wara pa kamo makapangayo kang bisan ano sa akun ngaran. Pangayo bala kamo kag mabaton ninyo ang inyo ginapangayo, agud to nga ang inyo kalipay mangin bug-os run gid.” ");
INSERT INTO krj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ang mga butang nga dya ginsugid ko run kaninyo paagi sa mga paraanggidan. Pero magaabot ang tion nga indi run gid ako maggamit kang mga paraanggidan kundi nga ihambal ko run kaninyo kang maathag ang nahanungud sa Amay. ");
INSERT INTO krj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pag-abot kang amo to nga tion magapangayo kamo sa akun ngaran. Wara ako nagakuon kaninyo nga ako ang magapangayo sa Amay para kaninyo; ");
INSERT INTO krj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","hay ang Amay mismo nagahigugma kaninyo, tungud nga kamo nagahigugma man kanakun kag nagapati nga ako sa Dios naghalin. ");
INSERT INTO krj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sa Amay ako maghalin kag nag-abot rugya sa kalibutan. Kar-on magahalin run ako sa kalibutan kag magabalik sa Amay.” ");
INSERT INTO krj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dayon nagkuon ang anang mga disipulo, “Kar-on, maathag run ang imo nga ginakuon kag wara ikaw nagagamit kang paanggid! ");
INSERT INTO krj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naman-an run namun kadya nga ikaw nakamaan kang tanan nga butang kag bisan indi ikaw pagpamangkoton naman-an mo run ang ginapinsar ni bisan sin-o. Tungud kadya nagatoo run gid kami nga ikaw sa Dios maghalin.” ");
INSERT INTO krj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nagsabat si Jesus, “Ti, kadya nagatoo run kamo? ");
INSERT INTO krj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pamatii bala ninyo, magaabot ang tion; sa pagkamatuod, nag-abot run gani, nga kamo magaburublag. Kada isara kaninyo magauli sa inyo mga balay, kag bayaan ninyo ako nga nagaisarahanun. Pero wara gid ako nagaisarahanun, tungud nga kaimaw ko ang Amay. ");
INSERT INTO krj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ginsugid ko dya kaninyo agud to nga paagi sa inyo suud nga kaangtanan kanakun makaagum kamo kang kalinung. Rugya sa kalibutan nagaagi kamo kang mga pag-antos. Pero magpakarig-un kamo, hay gindaug ko run kalibutan nga kontra sa Dios!” ");
INSERT INTO krj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkatapos ni Jesus ka hambal kadya, nagtangra tana sa langit kag nagkuon, “Amay, nag-abot run ang tion. Ipakita mo kon daw ano kagamhanan nga imo Anak, agud to nga ipakita man kang Anak kon daw ano ikaw kagamhanan. ");
INSERT INTO krj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tungud nga gintaw-an mo tana kang awtoridad sa paggahum sa tanan nga tawo, agud to nga magtugro kang kabuhi nga wara ti katapusan sa tanan nga mga tawo nga imo gintugyan kana. ");
INSERT INTO krj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kag ang kabuhi nga wara ti katapusan amo dyaay: ang kilalahun nanda ikaw nga amo gid lang ang matuod nga Dios, kag kilalahun man nanda si Jesu-Cristo nga imo ginpadara. ");
INSERT INTO krj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ginpakita ko run rugya sa lupa kon daw ano ikaw ka gamhanan paagi sa pagtapos kang hirikoton nga imo gintugyan kanakun. ");
INSERT INTO krj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kadya Amay, ipakita kon daw ano ako kagamhanan sa imo prisensya - ang gahum nga akun anay kang ako kaimaw pa nimo sa wara pa matuga ang kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ginpakilala ko kon sin-o gid ikaw sa mga tawo nga imong gintao kanakun halin sa kalibutan. Imo sanda kadya, kag gintugro mo sanda kanakun kag nagtuman sanda kang imo pulong. ");
INSERT INTO krj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kar-on, naman-an run nanda nga ang tanan nga imong gintao kanakun kanimo gid maghalin. ");
INSERT INTO krj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ang mga mensahe nga imong gintao kanakun ginpaalinton ko man kananda, kag ginbaton nanda dya. Naman-an nanda nga matuod gid nga ako rugyan kanimo maghalin, kag nagapati sanda nga ikaw ang nagpadara kanakun rugya. ");
INSERT INTO krj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nagapangamuyo ako para kananda. Wara ako nagapangamuyo para sa kalibutan nga nagakontra sa Dios kundi para sa mga tawo nga imong gintao kanakun, hay imo sanda kadya. ");
INSERT INTO krj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ang tanan nga akun imo, kag ang tanan nga imo akun man, kag paagi kananda nakita ang akun pagkagamhanan. ");
INSERT INTO krj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kag kar-on magahalin run ako sa kalibutan, kag magabalik run ako kanimo. Pero sanda magapabilin pa sa kalibutan. Amay, Balaan gid ikaw. Amligi sanda paagi sa gahum kang imo ngaran nga imo gintao kanakun, agud to nga mangin isara man sanda pareho nga ikaw kag ako isara. ");
INSERT INTO krj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kang ako kaimaw pa nanda, gin-amligan ko sanda paagi sa gahum kang imo ngaran nga imong gintugro kanakun. Ginbantayan ko sanda kag wara ti bisan isara kananda nga nadura luwas lang sa isara nga to nga natalana run nga pagalaglagun, agud to nga matuman ang ginakuon sa kasulatan. ");
INSERT INTO krj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kag kar-on tana, magabalik run ako kanimo. Ginasugid ko ang mga butang nga dya samtang rugya pa ako sa kalibutan agud to nga maaguman man nanda kang bug-os ang kalipay nga akun naaguman. ");
INSERT INTO krj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ginpaalinton ko run kananda ang imong mensahe kag nagdumut kananda ang kalibutan nga nagakontra sa Dios, tungud hay bukun sanda ti ana kang ria nga kalibutan pareho man kanakun nga bukun ti ana kang ria nga kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Wara ako nagapangamuyo nga ibul-un mo sanda sa kalibutan nga ria nga nagakontra sa Dios, kundi nga amligan mo sanda sa yawa. ");
INSERT INTO krj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bukun sanda ti ana kang ria nga kalibutan nga nagakontra sa Dios pareho man kanakun nga bukun ti ana kang ria nga kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Paagi sa kamatuoran ipain mo para sa imong tinutuyo ang mga tawo nga nagatoo kanakun. Ang imong Pulong amo ang kamatuoran. ");
INSERT INTO krj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kon paano nga ginpadara nimo ako sa kalibutan nga nagakontra sa Dios, sanda man ginapadara ko nga magpanudlo sa mga katawhan sa kalibutan nga dya. ");
INSERT INTO krj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Para gid lang kananda gintugyan ko ang akun kaugalingun para sa imong tinutuyo, agud to nga sanda man magatugyan kang bug-os para sa imong tinutuyo. ");
INSERT INTO krj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bukun lang para sa mga tawo nga dya ako nagapangamuyo, kundi para man sa mga magatoo kanakun paagi sa mensahe nga ginapanugid kang mga tawo nga dya. ");
INSERT INTO krj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ginapangamuyo ko nga sanda tanan mangin isara lang, pareho nga ikaw, Amay, kag ako may kaangtanan sa isara kag isara. Kabay pa nga sanda man mangin suud ang andang kaangtanan kanatun agud to ang katawhan sa kalibutan magapati nga ikaw ang nagpadara kanakun rugya. ");
INSERT INTO krj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ginpakita ko kon daw ano sanda kagamhanan pareho kang pagpakita nimo kon daw ano ako kagamhanan, agud to nga sanda man mangin isara lang pareho natun nga isara lang: ");
INSERT INTO krj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","buut hambalun nga ako may suud nga kaangtanan kananda, kag ikaw may suud nga kaangtanan kanakun. Kabay pa nga mangin isara run lang gid sanda agud to nga maman-an kang kalibutan nga dya nga nagakontra sa Dios nga ikaw ang nagpadara kanakun, kag ginahigugma mo ang mga sumuronod pareho kang paghigugma mo kanakun. ");
INSERT INTO krj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amay, gusto ko nga ang mga tawo nga imo gintugyan kanakun makaimaw ko kon sa diin man ako agud to nga makita nanda ang akun pagkagamhanan. Dya nga gahum gintao mo kanakun hay ginhigugma mo ako sa wara pa matuga ang kalibutan. ");
INSERT INTO krj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Amay, matarung gid ikaw. Bisan nga ang katawhan sa kalibutan wara makakilala kanimo, ako tana kilala ko ikaw kag ang mga tawo nga dya nga nagtoo kanakun nakamaan nga ikaw ang nagpadara kanakun. ");
INSERT INTO krj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ginpakilala ko run kananda kon sin-o ikaw, kag ipakilala ko pa gid ikaw, agud to nga makahigugma man sanda sa iba nga pareho kang paghigugma mo kanakun, kag agud to nga ako mismo magapabilin nga suud ang akun kaangtanan kananda.” ");
INSERT INTO krj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagkatapos ni Jesus ka pangamuyo kadya, nagpanaw tana imaw kang anang mga disipulo kag nagtabok sa sapa kang Kedron. May hardin rugto kato kag si Jesus nagsulud rugto imaw kang anang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kar-on, si Judas nga amo ang nagaluib kay Jesus nakamaan man kang lugar nga to hay si Jesus kag ang anang mga disipulo masami magtiripon rugto kato. ");
INSERT INTO krj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amo to kag nag-agto si Judas sa hardin nga may dara nga sangka hubun kang mga suldado nga Romanhun imaw kang mga gwardya sa templo nga ginpadara kang mga pangulo kang kaparian kag kang mga Fariseo. Sanda kadya may dara nga mga mitsa, mga lampara kag mga armas. ");
INSERT INTO krj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Naman-an nga daan ni Jesus ang tanan nga mahanabo kana, gani ginsug-alaw na sanda kag nagpamangkot, “Sin-o ang inyo ginasagap?” ");
INSERT INTO krj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nagsabat sanda, “Si Jesus nga taga-Nazaret.” Nagkuon si Jesus, “Ako amo tana.” Si Judas nga amo ang nagluib kana rugto man nga nagatindug imaw nanda. ");
INSERT INTO krj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kang pagkakuon ni Jesus, “Ako amo tana,” nag-irisol sanda kag nagkaratumba sa lupa. ");
INSERT INTO krj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nagpamangkot ruman si Jesus kananda, “Sin-o ang inyo ginasagap?” Nagsabat sanda, “Si Jesus nga taga-Nazaret.” ");
INSERT INTO krj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kag nagkuon si Jesus kananda, “Nagkuon bay ako kaninyo nga ako amo tana? Kar-on, kon ako amo ang inyo ginasagap, pabay-i ninyo ang akun mga kaibahan nga dya nga makahalin.” ");
INSERT INTO krj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa natabo nga dya natuman ang anang ginkuon anay nga, “Wara ako ti may gindura bisan isara sa mga tawo nga imo gintugyan kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Si Simon Pedro tana may dara nga espada. Gin-gabot na dya kag ginlabo ang surugoon kang pinakamataas nga pari, kag nautas ang tuo nga talinga na kadya. Ang ngaran kang surugoon nga dya si Malco. ");
INSERT INTO krj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ginkun-an ni Jesus si Pedro, “Itagub ang imong espada! Abi mo haw nga indi ko pag-antoson ang mga ginapaantos kanakun kang Amay?” ");
INSERT INTO krj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dason karia, ang hubun kang mga suldado nga Romanhun, imaw kang andang kapitan kag kang mga gwardya sa templo, gindakup nanda si Jesus kag gin-gapos. ");
INSERT INTO krj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gindara nanda tana una kay Anas nga ugangan ni Caifas. Si Caifas nga dya amo ang pinakamataas nga pari kang amo to nga tuig. ");
INSERT INTO krj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas man nga dya ang nagkuon sa mga Judio nga mas mayad nga may sangka tawo nga mapatay para sa mga katawhan. ");
INSERT INTO krj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro kag ang isara pa gid ka disipulo nagasunod kay Jesus. Ang disipulo nga dya kilala kang pinakamataas nga pari, gani nga nagsulud tana imaw kay Jesus hasta gid sa may lagwerta kang palasyo kang pinakamataas nga pari. ");
INSERT INTO krj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero si Pedro tana, rugto sa gwa sa may pwertahan. Ang ginhimo kang disipulo nga kilala kang pinakamataas nga pari, naggwa dya kag ginhambalan na ang bayi nga nagabantay sa may pwertahan, kag pagkatapos gindara kang disipulo nga dya si Pedro pasulud. ");
INSERT INTO krj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ang bayi nga dya sa may pwertahan nagkuon kay Pedro, “Indi bala nga isara man ikaw sa mga disipulo kang tawo nga to?” Nagsabat si Pedro, “Bukun mong!” ");
INSERT INTO krj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Maramig kato, gani ang mga surugoon kag ang mga gwardya sa templo nagdabok kang kalayo kag nagtindug sa palibot na kadya agud magpainit-init. Si Pedro tana nag-imaw man kananda nga nagatindug kag magpainit-init. ");
INSERT INTO krj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sa pihak tana nga bahin, si Jesus gin-usisa kang pinakamataas nga pari nahanungud sa anang mga disipulo kag sa anang mga ginapanudlo. ");
INSERT INTO krj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nagsabat si Jesus, “Naghambal ako kang hayag sa mga katawhan. Pirme ako nagapanudlo sa mga sinagoga kag sa templo nga sa diin nagatiripon ang mga Judio. Wara ako ti may ginhambal sa likum. ");
INSERT INTO krj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ti, andut haw nga ako tana ang imo ginausisa? Pamangkota ang mga tawo nga nakabati kanakun kon ano ang akun ginhambal hay naman-an gid tana nanda kon ano ang akun ginkuon.” ");
INSERT INTO krj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pagkahambal ni Jesus kadya, ginhuyapan tana kang isara sa mga gwardya nga nagatindug marapit kana, kag nagkuon dya, “Amo ria ikaw haw magsabat sa pinakamataas nga pari?” ");
INSERT INTO krj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nagsabat si Jesus, “Kon naghambal ako kang sayup, isugid abi. Pero kon matuod, andut haw nga ginhuyapan mo ako?” ");
INSERT INTO krj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pagkatapos kato, si Jesus nga nagapos sa gihapon ginpadara ni Anas kay Caifas nga amo ang pinakamataas nga pari. ");
INSERT INTO krj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Simon Pedro tana nagatindug pa gihapon rugto kag nagapainit-init. Ginpamangkot tana kang iba rugto, “Indi bala nga isara ikaw sa anang mga disipulo?” Ginpanginwara ruman dya ni Pedro nga nagakuon, “Bukun a.” ");
INSERT INTO krj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ang isara sa mga surugoon kang pinakamataas nga pari nga himata kang tawo nga ang anang talinga gin-utas ni Pedro, namangkot kana, “Hindi bala nga nakita ko ikaw nga kaimaw na rugto sa may hardin?” ");
INSERT INTO krj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ginpanginwara ruman dya ni Pedro. Kag amo man to ang pagpamalo kang manok. ");
INSERT INTO krj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Halin sa balay ni Caifas gindara nanda si Jesus paagto sa palasyo kang Romanhun nga gobernador. Kasanagun run kato. Ang mga Judio wara magsulud sa palasyo hay indi sanda gusto nga mangin higku suno sa andang pagsurondan, kag agud to nga makakaun sanda kang yapon sa Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gani si Pilato nga gobernador amo ang naggwa kananda kag namangkot, “Ano ang inyo akusasyon sa tawo nga dya?” ");
INSERT INTO krj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nagsabat sanda, “Kon wara tana maghimo kang sala indi namun tana pagdar-un rugya kanimo.” ");
INSERT INTO krj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nagkuon si Pilato kananda, “Dar-a ninyo tana kag kamo mismo ang maghusgar kana suno sa inyo kaugalingun nga kasugoan!” Nagkuon ang mga Judio, “Wara kami ti gahum nga sentensyahan kang kamatayun ang bisan sin-o.” ");
INSERT INTO krj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Natabo dya agud matuman ang ginkuon anay ni Jesus parte sa kon ano nga sahi kang kamatayun ang anang pagaagumun. ");
INSERT INTO krj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nagbalik si Pilato sa sulud kang palasyo. Ginpatawag na si Jesus kag ginpamangkot dya, “Ikaw bala ang hari kang mga Judio?” ");
INSERT INTO krj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nagsabat si Jesus, “Imo bala ria kaugalingun nga pamangkot ukon may nagsugid kanimo nahanungud kanakun?” ");
INSERT INTO krj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nagsabat si Pilato, “Ano ako, Judio? Ang imong mga kasimanwa kag ang mga pangulo kang inyo kaparian amo ang nagtugyan kanimo rugya kanakun. Ano haw ang imong ginhimo?” ");
INSERT INTO krj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nagkuon si Jesus, “Ang akun gahum bilang hari bukun ti sa kalibutan nga dya. Hay kon ang akun gahum bilang hari rugya sa kalibutan nga dya, ang akun mga sumuronod magapakig-away agud to nga indi ako matugyan sa mga Judio. Pero bukun ti sa kalibutan nga dya ang akun gahum bilang hari.” ");
INSERT INTO krj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nagkuon si Pilato, “Kon amo, hari gid man gali ikaw eh!” Nagsabat si Jesus, “Igsakto ikaw sa imo ginkuon nga ako hari. Amo ria ang kabangdanan nga ako natawo kag nag-abot rugya sa kalibutan agud to nga magsugid nahanungud sa kamatuoran. Ang tanan nga gusto makamaan kang kamatuoran nagapamati kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nagpamangkot si Pilato, “Ano haw ang kamatuoran?” Pagkahambal ni Pilato kadya, naggwa ruman tana sa pag-atubang sa mga Judio kag nagkuon kananda, “Wara ako ti may makita nga sala kana. ");
INSERT INTO krj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero kamo nga mga Judio may kinabatasan nga nagapangayo kanakun nga maghilway ako kang sangka priso sa adlaw kang Pista kang Paglampuwas. Gusto bala ninyo nga hilwayun ko para kaninyo ang inyo hari?” ");
INSERT INTO krj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nagsabat ang mga tawo nga nagasinggitan, “Bukun! Bukun ti tana kundi si Barabas amo ang imo hilwayun!” Si Barabas nga dya sangka rebelde. ");
INSERT INTO krj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dayon ginbuul ni Pilato si Jesus kag ginpahanot. ");
INSERT INTO krj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagkatapos, ang mga suldado naghimo kang korona nga puro tunuk kag anda dya nga ginbutang sa ulo ni Jesus. Ginpasuksokan man nanda tana kang kapa nga kolor granate ");
INSERT INTO krj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","kag sige-sige nanda yaguta nga nagakuon, “Dayawun ikaw nga Hari kang mga Judio!” Kag ginahuyapan nanda tana. ");
INSERT INTO krj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Si Pilato tana naggwa liwan kag nagkuon sa mga tawo, “Sulnga ninyo, ipaatubangun ko tana rugya kaninyo agud to nga maman-an ninyo nga wara ako ti may nakita nga sala kana.” ");
INSERT INTO krj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dayon naggwa si Jesus nga nagasuksok kang koro-korona nga puro tunuk sa anang ulo kag kapa nga kolor granate. Nagkuon si Pilato sa katawhan, “Dya ang tawo!” ");
INSERT INTO krj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkakita kay Jesus kang mga pangulo kang kaparian kag kang mga gwardya, nagsinggitan sanda nga nagakuon, “Ilansang tana sa kros! Ilansang tana sa kros!” Nagkuon si Pilato, “Kamo mismo ang magdara kana kag maglansang sa kros. Hay ako takun wara ti may nakita nga sala kana.” ");
INSERT INTO krj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nagsabat ang mga Judio, “May kasugoan kami kag suno sa amo nga kasugoan nagakadapat nga tana mapatay tungud hay nagakuon tana nga Anak tana kang Dios!” ");
INSERT INTO krj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagkabati ni Pilato kadya, mas hinadlukan pa gid tana. ");
INSERT INTO krj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nagsulud ruman tana sa palasyo kag gin-usisa si Jesus, “Diin ikaw haw maghalin?” Pero wara magsabat si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Gani nagkuon si Pilato kana, “Andut nga indi ikaw magsabat kanakun haw? Wara ikaw haw kamaan nga may awtoridad ako sa paghilway kanimo ukon sa pagpalansang kanimo sa kros?” ");
INSERT INTO krj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nagsabat si Jesus, “Wara ikaw ti awtoridad kanakun kon wara ikaw gintaw-an kang Dios. Gani mas bug-at ang sala kang tawo nga nagtugyan kanakun rugya kanimo.” ");
INSERT INTO krj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagkabati ni Pilato ka dya gintinguhaan na gid nga hilwayun si Jesus. Pero ang katawhan nagsinggitan gid nga nagakuon, “Kon hilwayun mo ang tawo nga ria bukun ikaw ti amigo kang emperador! Ang bisan sin-o nga nagapakahari nagakontra sa emperador!” ");
INSERT INTO krj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagkabati ni Pilato ka dya gindara na si Jesus sa sagwa, kag ana tana nagpungko sa purungkoan kang hukum rugto sa lugar nga ginatawag Plataporma nga Bato. (Sa hambal nga Hebreo ginatawag dya nga Gabata.) ");
INSERT INTO krj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bisperas run kang Pista kang Paglampuwas, kag mga udto adlaw run kato. Dayon nagkuon si Pilato sa mga Judio, “Dyaay ang inyo nga hari!” ");
INSERT INTO krj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero nagsinggitan sanda nga nagakuon, “Patyun tana! Patyun tana! Ilansang tana sa kros!” Nagkuon si Pilato, “Ipalansang ko bala sa kros ang inyo hari?” Nagsabat ang mga pangulo kang kaparian, “Wara kami ti may ginakilala nga hari kundi ang emperador lang!” ");
INSERT INTO krj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gani gintugyan ni Pilato si Jesus kananda agud ilansang sa kros. Kag gindara nanda si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Naggwa tana nga nagapas-an kang anang kros paagto sa lugar nga ginatawag Bagol. (Sa hambal nga Hebreo ginatawag dya nga Golgota.) ");
INSERT INTO krj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Rugto nanda tana ginlansang sa kros. May darwa pa gid ka tawo nga andang ginlansang sa kros dungan kana. Ang isara sa tuo nayon, kag ang isara sa anang wala; si Jesus sa tunga nanda. ");
INSERT INTO krj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nagpahimo si Pilato kang karatula kag ana dya nga ginpaangut sa kros ni Jesus. Amo dyaay ang nasulat sa karatula: “Si Jesus nga taga Nazaret; ang Hari kang mga Judio.” ");
INSERT INTO krj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Raku sa mga Judio ang nakabasa kang nasulat sa karatula nga dya hay ang lugar nga sa diin ginlansang si Jesus sa kros marapit sa syudad. Kag dya nasulat sa mga hambal nga Hebreo, Latin kag Griego. ");
INSERT INTO krj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ang mga pangulo kang kaparian kang mga Judio nag-agto kay Pilato kag nagkuon, “Bukun ti ‘Ang Hari kang mga Judio’ ang imong isulat, kundi, ‘Ang tawo nga dya nagakuon nga tana ang Hari kang mga Judio.’” ");
INSERT INTO krj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nagsabat si Pilato, “Kon ano ang akun ginsulat indi ko run pagbag-ohon.” ");
INSERT INTO krj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ang mga suldado tana, pagkatapos nanda ka lansang kay Jesus sa kros, ginbuul nanda ang anang mga bayo kag ginhuray nanda dya sa apat ka parte - sangka parte sa kada isara kananda. Ginbuul man nanda ang anang pangsulud nga bayo; dya wara ti sinugponan hay nahabul nga bilog halin sa ibabaw hasta sa sidsid. ");
INSERT INTO krj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Naghambalanay sanda, “Indi natun dya paggisiun; ipagabot-gabotan lang natun dya kon sin-o ang makabuul.” Natabo dya agud matuman ang ginkuon sa Kasulatan, “Ginhuray nanda ang akun mga bayo Kag gin-gabot-gabotan nanda ang akun pangsulud nga bayo.” Kag amo gid man dya ang ginhimo kang mga suldado. ");
INSERT INTO krj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Marapit rugto sa kros ni Jesus nagatirindug ang anang nanay, ang bugto nga bayi kang anang nanay, kag amo man si Maria nga asawa ni Cleopas, kag si Maria Magdalena. ");
INSERT INTO krj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kang nakita ni Jesus ang anang nanay kag ang disipulo nga ana ginapalangga nga nagatindug sa ingud na kadya, nagkuon si Jesus sa anang nanay, “Dyaay ang imong bata.” ");
INSERT INTO krj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kag nagkuon man tana sa disipulo, “Dyaay ang imong nanay.” Umpisa kato, ginpaistar tana kang disipulo nga dya sa anang balay. ");
INSERT INTO krj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagkatapos kato, naman-an run ni Jesus nga natapos run ang tanan, gani agud to nga matuman ang ginakuon sa kasulatan, nagkuon tana, “Ginauhaw ako.” ");
INSERT INTO krj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","May sangka surudlan rugto nga buta kang maaslum nga bino. Gani gintusmog nanda rugya kadya ang sangka espongha kag ginbutang sa punta kang malabug nga sanga kang tanum nga isopo kag gintunghol nanda dya sa ba-ba ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagkasupsup ni Jesus kadya nagkuon tana, “Natapos run!” Dayon nagduko tana kag nabugto ang anang ginhawa. ");
INSERT INTO krj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Byernes kato kag ang masunod nga adlaw amo run ang pinasahi nga Adlaw nga Inugpahuway. Tungud nga ang mga Judio indi gusto nga mabilin sa kros sa Adlaw nga Inugpahuway ang mga lawas kang mga ginlansang, gani ginpangabay nanda kay Pilato nga ipabalbag ang mga batiis kang mga tawo nga ginlansang sa kros, kag ibul-un ang andang mga bangkay. ");
INSERT INTO krj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Gani nag-agto rugto ang mga suldado kag ginbalbag nanda ang mga batiis kang darwa ka tawo nga ginlansang imaw ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero kang pagparapit nanda kay Jesus, nakita nanda nga patay run dya, gani nga wara run lang nanda ginbalbag ang anang mga batiis. ");
INSERT INTO krj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero ang ginhimo tana kang isara sa mga suldado, ginbuno na kang bangkaw ang kilid ni Jesus, kag lagi-lagi nag-agay ang dugo kag tubig. ");
INSERT INTO krj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ang tawo nga nakakita kang hitabo nga dya nagapamatuod kadya, kag ang anang pagpamatuod matuod gid. Naman-an na nga nagasugid tana kang matuod agud to nga hasta kamo magatoo man. ");
INSERT INTO krj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Natabo dya agud matuman ang ginakuon sa kasulatan nga, “Wara ti bisan isara sa anang mga tul-an ang pagabariun.” ");
INSERT INTO krj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kag may ginakuon pa gid sa iba nga bahin kang kasulatan, “Pagaturukun nanda ang tawo nga andang ginbuno.” ");
INSERT INTO krj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagkatapos kadya, si Jose nga taga-Arimatea nag-agto kay Pilato kag gin-ayo na nga ibul-un ang bangkay ni Jesus. Si Jose nga dya sumuronod man ni Jesus pero sa likum lang, hay nahadluk tana sa mga pangulo kang mga Judio. Gintugotan tana ni Pilato, gani nag-agto tana rugto kag ginbuul ang bangkay ni Jesus. ");
INSERT INTO krj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Si Nicodemo nag-imaw man kana. Tana kadya ang nagpakigkita kay Jesus sangka gabii kato anay. Nagdara tana kang pahamot nga sinamo nga mira kag aloe, mga 45 ka kilo kadya ang anang kabug-atun. ");
INSERT INTO krj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dayon, ginbuul nanda ang bangkay ni Jesus kag ginbutangan kang mga pahamot samtang ginaputos sa tela nga lino, hay amo dya ang kinabatasan kang mga Judio kon nagalubung sanda kang patay. ");
INSERT INTO krj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Rugto sa lugar nga sa diin ginlansang si Jesus may hardin, kag sa hardin nga dya may bag-o nga rulubngan nga wara pa gid malubngi. ");
INSERT INTO krj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tungud hay bisperas run kang Adlaw nga Inugpahuway, kag tungud nga marapit lang man ang rulubngan, rugto nanda kato ginlubung si Jesus. ");
INSERT INTO krj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Aga pa kang nahauna nga adlaw kang semana, kag madulum-dulum pa, si Maria Magdalena nag-agto run sa rulubngan. Kag nakita na nga wara run ang bato nga nagatakup sa pwertahan kang rulubngan. ");
INSERT INTO krj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gani, nagdalagan tana kag mag-agto kay Simon Pedro kag sa disipulo nga palangga ni Jesus. Nagkuon si Maria kananda, “Ginbuul nanda ang Ginoo sa rulubngan kag wara kami kamaan kon sa diin nanda tana ginbutang!” ");
INSERT INTO krj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dayon si Pedro kag ang disipulo nga to nag-agto sa rulubngan. ");
INSERT INTO krj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nagdalagan sanda nga darwa, pero naunahan kang disipulo nga to si Pedro, gani nga una tana mag-abot sa rulubngan. ");
INSERT INTO krj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kang pag-abot na rugto, nagkuub tana kag magsid-ing sa sulud kag nakita na ang mga tela nga lino rugto, pero wara tana magsulud. ");
INSERT INTO krj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Si Simon Pedro tana nga nagasunod kana, nag-abot man kag nagdiretso sulud sa rulubngan. Nakita na rugto ang tela nga lino, ");
INSERT INTO krj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kag amo man ang tela nga ginsambud sa ulo ni Jesus. Nabaroron dya kag wara madapun sa panaptun nga lino. ");
INSERT INTO krj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ang disipulo tana nga una mag-abot rugto nagsulud man. Nakita na dya kag nagpati tana nga si Jesus nabanhaw. ");
INSERT INTO krj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Hay sa amo dya nga mga tinion nga dya wara pa nanda mahangpi ang ginakuon sa Kasulatan nga si Jesus kinahanglan nga mabanhaw.) ");
INSERT INTO krj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pagkatapos kato, ang darwa ka disipulo nga dya nag-uli sa andang balay. ");
INSERT INTO krj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Si Maria Magdalena tana nagatindug rugto sa sagwa kang rulubngan nga nagaparanangisun. Samtang nagapanangis tana, nagkuub tana kag nagsid-ing sa sulud kang rulubngan. ");
INSERT INTO krj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kag nakita na nga may darwa ka anghel rugto nga puti ang andang bayo. Nagapungko sanda sa lugar nga ginbutangan kang lawas ni Jesus. Ang isara sa may ulohan nayon, kag ang isara tana sa may sikwayan. ");
INSERT INTO krj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nagkuon sanda kay Maria, “Inday, iwanhaw nga nagahibi ikaw?” Nagsabat si Maria, “Ginbuul nanda ang akun Ginoo, kag wara ako kamaan kon sa diin nanda tana ginbutang.” ");
INSERT INTO krj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagkakuon na kadya, nagbalikid tana, kag nakita na si Jesus nga nagatindug rugto, pero wara tana kamaan nga si Jesus gali to. ");
INSERT INTO krj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nagkuon si Jesus kana, “Inday, wanhaw nga nagahibi ikaw? Sin-o ang imo ginapangita?” Abi ni Maria nga tana ang hardinero. Gani nagkuon si Maria kana, “Sir, kon ikaw ang nagbuul kana, isugid kanakun ay kon sa diin mo tana ginbutang hay ibul-un ko tana.” ");
INSERT INTO krj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kag nagkuon si Jesus kana, “Maria!” Nag-atubang si Maria kana kag nagkuon sa hambal nga Hebreo, “Raboni!” (nga kon sayudon “Maestro.”) ");
INSERT INTO krj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nagkuon si Jesus kana, “Indi ako pagkapti hay wara pa ako makabalik sa akun Amay. Ang himoon mo, agto ikaw sa akun mga kabugtoan kag sugidan mo sanda nga magabalik ako sa akun Amay, ‘nga inyo man Amay, kag sa akun Dios, nga inyo man Dios.’” ");
INSERT INTO krj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Gani nag-agto si Maria Magdalena sa mga disipulo kag ginsugid na kananda nga nakita na ang Ginoo, kag ginsugid na man kananda ang ginkuon kang Ginoo kana. ");
INSERT INTO krj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkagabii kang nahauna nga adlaw nga ria kang semana, nagtiripon ang mga disipulo. Napintalan ang mga pwertahan kang lugar nga andang ginatiponan hay nahadluk sanda sa mga pangulo kang mga Judio. Dayon nag-abot si Jesus kag nagtindug sa andang tunga. Nagkuon tana kananda, “Ang kalinung mangin rugyan kaninyo!” ");
INSERT INTO krj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkakuon na kadya ginpakita na kananda ang anang mga alima kag anang kilid. Nalipay gid ang mga disipulo kang makita nanda ang Ginoo. ");
INSERT INTO krj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kag nagkuon liwan si Jesus kananda, “Ang kalinung mangin rugyan kaninyo! Kon paano nga ginpadara ako kang Amay rugya, kamo man ginapadara ko.” ");
INSERT INTO krj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagkatapos kadya, ginhuyupan na sanda kag nagkuon, “Batona ninyo ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ang bisan sin-o nga patawarun ninyo sa andang mga sala, ginpatawad run ria, kag ang bisan sin-o nga wara ninyo pagpatawara sa andang mga sala, wara man ria mapatawad.” ");
INSERT INTO krj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kar-on, si Tomas tana nga ginatawag Kapid, kag isara sa napulo'g darwa ka mga disipulo, wara nanda makaimaw kang magpakita si Jesus kananda. ");
INSERT INTO krj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gani ang iba sa mga disipulo nagkuon kana, “Nakita namun ang Ginoo!” Nagsabat si Tomas, “Kon indi ko makita ang agi kang lansang sa anang mga alima, kag ibutang ang akun tudlo sa agi kang mga lansang, kag makaptan kang akun alima ang anang kilid, indi ako magpati.” ");
INSERT INTO krj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pagkaligad kang sangka semana, ang anang mga disipulo nagtiripon ruman. Kag kar-on tana kaimaw run nanda si Tomas. Napintalan ang mga pwertahan, pero si Jesus nag-abot kag nagtindug sa tunga nanda. Nagkuon tana kananda, “Ang kalinung mangin rugyan kaninyo!” ");
INSERT INTO krj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dayon nagkuon tana kay Tomas, “Ibutang ang imo tudlo rugya. Sulnga ang akun mga alima. Idab-ot ang imong alima kag ibutang sa akun kilid. Magpati ikaw kag indi magpangduha-duha.” ");
INSERT INTO krj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kag nagkuon si Tomas kana, “Ikaw ang akun Ginoo, ikaw ang akun Dios!” ");
INSERT INTO krj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nagkuon si Jesus kana, “Nagpati bala ikaw tungud nga nakita mo run ako? Daw ano ka malipayun ang mga tawo nga nagatoo kanakun bisan wara sanda makakita kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Raku pa gid nga mga makatiringala nga milagro ang ginhimo ni Jesus nga nakita kang anang mga disipulo nga wara masulat sa libro nga dya. ");
INSERT INTO krj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero kon ano ang nasulat sa libro nga dya ginsulat agud to nga magtoo kamo nga si Jesus amo ang Cristo, ang Anak kang Dios. Kag agud to nga sa inyo nga pagtoo makaangkun kamo kang kabuhi paagi kana. ");
INSERT INTO krj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagkatapos kang mga hitabo nga dya, si Jesus nagpakita liwan sa anang mga disipulo rugto sa Linaw kang Tiberias. Amo dyaay ang natabo: ");
INSERT INTO krj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nagairirimaw sanday Simon Pedro, Tomas, (nga ginatawag Kapid), si Nataniel nga taga Cana sa Galilea, ang mga bata nga laki ni Zebedeo, kag darwa pa gid ka sumuronod. ");
INSERT INTO krj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nagkuon si Simon Pedro kananda, “Mangisda takun.” Nagsabat sanda kana, “Matawas kami kanimo.” Amo to kag nagpanaw sanda kag magsakay sa baruto, pero kang gabii nga to wara gid sanda ti may nabuul. ");
INSERT INTO krj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pagka kasanagun, nagtindug si Jesus rugto sa may binit kang baybay, pero ang mga disipulo wara kamaan nga tana to. ");
INSERT INTO krj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nagkuon si Jesus kananda, “Mga amigo, wara kamo haw ti may nabuul?” Nagsabat sanda, “Wara.” ");
INSERT INTO krj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nagkuon tana kananda, “Iladlad ang inyo pukot sa tuo nayon kang baruto kag makabuul kamo karia.” Amo to kag ginladlad nanda dya, kag indi run nanda dya masarangan ka batak tungud sa kadurohon kang isda nga andang nabuul. ");
INSERT INTO krj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kar-on, ang disipulo nga palangga ni Jesus nagkuon kay Pedro, “Ang Ginoo to!” Pagkabati ni Simon Pedro nga ang Ginoo to, dayon na suksok kang anang bayo (hay gin-uba na dya) kag maglukso sa tubig. ");
INSERT INTO krj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ang iba tana nga mga disipulo nagpabinit nga nagasakay sa baruto samtang ginabutung ang pukot nga buta kang isda. Bukun gid man sanda ti rayu sa binit kang baybay, mga 90 ka metro ang andang karayuun. ");
INSERT INTO krj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagkatakas nanda, may nakita sanda nga uring nga nagabaga kag may isda nga ginasugba sa ibabaw na kadya, kag may tinapay man. ");
INSERT INTO krj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nagkuon si Jesus kananda, “Dara kamo rugya kang pirambilog nga isda nga bag-o lang ninyo nabuul.” ");
INSERT INTO krj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Gani nagsaka si Simon Pedro sa baruto kag ginbutung na pabinit ang pukot nga buta kang daragkul nga isda - 153 tanan. Pero bisan pa nga amo to karaku ang isda, wara magisi ang pukot. ");
INSERT INTO krj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nagkuon si Jesus kananda, “Dali kamo kag mamahaw.” Wara gid ti bisan isara sa mga disipulo ang nagpangahas mamangkot kon sin-o tana tungud hay naman-an gid nanda nga tana ang Ginoo. ");
INSERT INTO krj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nagparapit si Jesus kananda, ginbuul na ang tinapay kag ginpanaw-an sanda. Amo man dya ang anang ginhimo sa isda. ");
INSERT INTO krj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Amo run dya ang ikatlo nga bes nga nagpakita si Jesus sa mga disipulo pagkatapos nga nabanhaw tana. ");
INSERT INTO krj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkatapos nanda ka pamahaw, nagkuon si Jesus kay Simon Pedro, “Simon nga bata ni Juan, ginahigugma mo bala ako labaw sangsa mga dya?” Nagsabat si Pedro “Huud, Ginoo, naman-an mo nga ginahigugma ko ikaw.” Nagkuon si Jesus kana, “Pakan-a ang akun mga karnero.” ");
INSERT INTO krj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nagkuon ruman si Jesus kana, “Simon nga bata ni Juan, ginahigugma mo bala ako?” Nagsabat si Pedro, “Huud, Ginoo, naman-an mo nga ginahigugma ko ikaw.” Nagkuon si Jesus, “Atipana ang akun mga karnero.” ");
INSERT INTO krj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sa ikatlo nga bes nagkuon si Jesus kana, “Simon nga bata ni Juan, ginahigugma mo bala ako?” Nagsakit ang buut ni Pedro hay namangkot kana si Jesus sa ikatlo nga bes kon ginahigugma na si Jesus. Nagkuon tana, “Ginoo, nakamaan ikaw kang tanan. Naman-an mo nga ginahigugma ko ikaw.” Nagkuon si Jesus kana, “Pakan-a ang akun mga karnero. ");
INSERT INTO krj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sugidan ko ikaw: kang bataun pa ikaw, ikaw mismo ang nagasuksok kang imong bayo kag mag-agto sa bisan diin mo gusto. Pero magmal-am run gani ikaw, iuntayun mo ang imong mga butkun kag lain run ang magapasuksok kanimo kang bayo kag magadara kanimo sa lugar nga indi mo gusto agtonan.” ");
INSERT INTO krj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ginhambal dya ni Jesus agud ipamaan kon ano nga sahi kang kamatayun ang pagaagumun ni Pedro nga mahimaya na ang Dios.) Kag dayon nagkuon si Jesus kana, “Sunod ikaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nagbalikid si Pedro kag nakita na nga nagasunod kananda ang disipulo nga ginapalangga ni Jesus. (Amo man dya nga disipulo ang nagsandiay anay sa dughan ni Jesus katong nagarayapon sanda kag namangkot nga, “Ginoo, sin-o bala ang magaluib kanimo?”) ");
INSERT INTO krj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kang makita tana ni Pedro, nagpamangkot si Pedro kay Jesus, “Ginoo, ana tana bay?” ");
INSERT INTO krj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nagsabat si Jesus, “Kon gusto ko nga buhi pa tana hasta sa pagbalik nakun rugya, ano tana ang ginakabalak-an mo? Sunod ikaw kanakun.” ");
INSERT INTO krj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tungud sa ginhambal nga dya ni Jesus nabalahuba sa mga sumuronod ni Jesus nga ang disipulo nga dya indi mapatay. Pero si Jesus wara magkuon nga indi dya mapatay, kundi nga kuon na tana, “Kon gusto ko nga buhi pa tana hasta sa pagbalik nakun rugya, ano tana ang ginakabalak-an mo?” ");
INSERT INTO krj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Amo dya nga disipulo ang nagasugid nga ang mga butang nga dya matuod, kag tana man ang nagsulat ka dya. Naman-an natun nga ang anang mga ginapanugid matuod. ");
INSERT INTO krj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Duro pa gid nga mga butang ang ginpanghimo ni Jesus. Kon sara-sarahun dya ka sulat, sa banta ko ang mga libro nga pagasulatun indi mag-igo sa bilog nga kalibutan.");
INSERT INTO krj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Halangdun nga Teofilo, Sa una nga libro nga akun ginsulat, ginsaysay ko ang nahanungud sa tanan nga mga butang nga ginpanghimo kag ginpanudlo ni Jesus, halin kang pag-umpisa na kang anang hirikoton ");
INSERT INTO krj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta sa adlaw nga gindara tana palangit. Sa wara pa tana gindara palangit, paagi sa Balaan nga Ispirito ginbinlan na kang mga sugo ang anang pinili nga mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa tapos nga mapatay tana, nagpakita tana kananda sa raku nga mga beses sa sulud kang 40 ka adlaw. Ginpamatud-an na kananda sa paagi nga indi gid mapanginwara nga tana buhi, kag naghambal tana kananda kang nahanungud sa pagginahum kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Samtang nagairirimaw sanda, ginbinlan na sanda nga nagakuon, “Indi anay kamo maghalin sa Jerusalem. Hulatun ninyo ang akun ginkuon kaninyo nga ginsaad kang akun Amay nga igatao kaninyo. ");
INSERT INTO krj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Si Juan nagbawtiso kang mga katawhan sa tubig, pero pira run lang ka adlaw kag pagabawtisohan run kamo sa Balaan nga Ispirito.” ");
INSERT INTO krj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kang mag-iririmaw si Jesus kag ang anang mga apostoles, ginpamangkot nanda tana, “Ginoo, kadya run haw nimo ipatindugun liwan ang Ginharian kang Israel?” ");
INSERT INTO krj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nagsabat si Jesus kananda, “Ang akun Amay amo ang nagpat-ud kang mga panahon kag mga tinion sa ana kaugalingun nga gahum, kag indi ninyo dya kinahanglan nga maman-an! ");
INSERT INTO krj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero pag-abot kang Balaan nga Ispirito kaninyo, makabaton kamo kang gahum, kag magapanugid kamo sa katawhan nahanungud kanakun, indi lang rugya sa syudad kang Jerusalem kundi sa bug-os man nga probinsya kang Judea kag sa Samaria kag hasta pa gid sa tanan nga duuk kang kalibutan.” ");
INSERT INTO krj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkahambal ni Jesus ka dya, samtang nagaturuk sanda, nakita nanda nga gindara tana pa langit, kag ginlikupan tana kang panganod kag nadura sa andang panuruk. ");
INSERT INTO krj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nalansang pa angud ang panuruk kang mga apostoles sa langit samtang nagaparayu si Jesus kananda kag hinali lang may nagtindug sa ingud nanda nga darwa ka laki nga nagasuksok ka puti. ");
INSERT INTO krj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nagkuon dya kananda, “Kamo nga mga Galileanhun, andut haw nga nagatirindug kamo dyan kag nagatangra sa langit? Ang Jesus nga dya nga ginbuul kaninyo kag gindara palangit magabalik man. Kon ano ang nakita ninyo nga pagpalangit na amo man karia ang ana nga pagbalik.” ");
INSERT INTO krj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pagkatapos kato, ang mga apostoles nagbalik sa syudad kang Jerusalem halin sa bukid kang Mga Olibo nga ginabanta nga sangka kilometro ang karayuun halin sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pag-abot nanda rugto, nagsaka sanda sa ibabaw nga kwarto nga anda ginadayonan. Sanda kadya amo sanday, Pedro, Juan, Santiago, Andres, Felipe kag Tomas, si Bartolomeo kag Mateo, si Santiago nga bata ni Alfeo, si Simon nga isganan, kag si Judas nga bata ni Santiago. ");
INSERT INTO krj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tanan sanda masami nga nagatingub sa pagpangamuyo kaimaw kang mga kababainhan kag si Maria nga nanay ni Jesus kag ang mga laki nga bugto ni Jesus. ");
INSERT INTO krj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pagkaligad kang pira ka adlaw, may mga 120 ka mga tumuluo ang nagtiriripon. Nagtindug si Pedro sa tunga nanda kag naghambal, ");
INSERT INTO krj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kabugtoan, kinahanglan gid nga matuman ang ginakuon sa Kasulatan nga ginhambal kang Balaan nga Ispirito katong una paagi kay David nahanungud kay Judas, nga amo ang naggiya sa mga nagdakup kay Jesus. ");
INSERT INTO krj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Imaw man anay natun tana kag may bahin man sa atun hirikoton.” ");
INSERT INTO krj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Si Judas nga dya nakabaton kang kwarta tungud sa kadu na nga hinimoan, kag gintaba na ka lupa sa diin nahulog tana pabaliskad. Nawasdak kadya ang anang lawas kag nag-aragay ang tanan na nga dinaut. ");
INSERT INTO krj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ang natabo nga dya nabalahuba sa tanan nga mga taga-Jerusalem, gani sa kaugalingun nanda nga hambal ang lupa nga to gintawag nanda nga Akeldama, nga kon sayudon “Lupa kang Dugo.”) ");
INSERT INTO krj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Tungud hay nasulat sa libro kang mga Salmo, nga ‘Pabay-an run lang ang anang balay kag indi run dya pagpaistaran bisan kay sin-o.’ Kag nasulat pa gid nga, ‘Itao run lang sa iba ang anang hirikoton.’ ");
INSERT INTO krj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Gani ang isara sa atun mga kaibahan sa bug-os nga panahon nga kita anay nagpakig-imaw pa kay Ginoong Jesus, ");
INSERT INTO krj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","umpisa kang mga inadlaw nga magpangbawtiso si Juan hasta sa adlaw nga si Jesus ginbuul kanatun palangit, kinahanglan nga mangin kaimaw natun sa pagpanugid nahanungud sa pagkabanhaw ni Ginoong Jesus.” ");
INSERT INTO krj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Gani nagpili sanda kang darwa ka laki, nga amo sanday Jose nga ginahingaranan man kay Barsabas (kag ginatawag man Justo), kag si Matias. ");
INSERT INTO krj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dayon nangamuyo sanda, “Ginoo, naman-an mo ang tagipusoon kang tanan nga tawo. Ipahayag kanamun kadya kon sin-o sa darwa nga dya ang imo napilian ");
INSERT INTO krj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nga magbulus nga mag-alagad bilang apostol nga ginbayaan ni Judas, kag kadya rugto run tana sa lugar nga amo gid ang angay kana.” ");
INSERT INTO krj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapos nanda ka pangamuyo, naggabot-gabot sanda kag ang ngaran nga anda nagabotan amo ang kay Matias, gani gindugang nanda tana sa napulo'g isara ka mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kang mag-abot ang adlaw nga ginatawag Pentecostes, ang tanan nga mga tumuluo nagatiriripon sa sangka lugar. ");
INSERT INTO krj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kag hinali lang may ginahud halin sa langit nga daw mabaskug nga hangin nga nagabagrong, kag gintugban na kadya ang bilog nga balay sa diin nagapurungko sanda. ");
INSERT INTO krj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dayon may nakita sanda nga daw mga dila nga kalayo kag nagrinapta dya kag nagtungtong sa kada isara kananda rugto. ");
INSERT INTO krj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kag gin-gamhan sanda tanan kang Balaan nga Ispirito kag nagharambal sa lain-lain nga mga linggwahe suno sa ginapahambal kananda kang Ispirito. ");
INSERT INTO krj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Rugto kato sa may syudad kang Jerusalem may nagairistar nga mga Judio nga diosnon nga nagharalin sa tanan nga kapungsodan kang kalibutan. ");
INSERT INTO krj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagkabati nanda kang ginahud nga dya, nagdinurugok ang raku nga mga tawo. Natingala sanda tungud hay kada isara kananda nakabati nga ang ana kaugalingun nga hambal ginahambal kang mga tumuluo rugto kato. ");
INSERT INTO krj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa sobra nanda nga katingala, nagkuon sanda, “Mga taga-Galilea kabay ang tanan nga mga nagaharambal nga dya? ");
INSERT INTO krj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ti, andut nga ang kada isara kanatun, mabatian natun tanan nga nagaharambal sanda sa atun mismo kaugalingun nga linggwahe? ");
INSERT INTO krj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ang iba kanatun taga-Partia, taga-Media, kag taga-Elam! Ang iba tana mga taga-Mesopotamia, taga-Judea kag taga-Capadocia. Ang iba ruman tana taga-Punto kag taga-Asia. ");
INSERT INTO krj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","May mga taga-Frigia, taga-Panfilia, kag taga-Ehipto man, kag ang iba nagharalin sa mga lugar nga nasakpan kang Libya, nga marapit sa Cirene. May dyan man nga nagharalin pa sa Roma: ");
INSERT INTO krj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mga Judio kag mga bukun ti Judio nga nadara sa relihiyon kang mga Judio. Kag ang iba pa gid kanatun mga taga-Creta kag taga-Arabia. Pero mabatian natun tanan nga nagaharambal sanda sa atun mismo kaugalingun nga linggwahe kang nahanungud sa mga makatiringala nga hinimoan kang Dios!” ");
INSERT INTO krj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sa sobra nanda nga katingala nga daw indi sanda makapati, nagpamangkotanay sanda, “Ano ang buut hambalun kadya man?” ");
INSERT INTO krj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero ang iba tana, ginyaguta nanda ang mga tumuluo nga nagkuon, “Mga lingin ang mga tawo nga ria!” ");
INSERT INTO krj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Amo to kag nagtindug si Pedro, imaw kang napulo'g isara ka apostoles kag sa matunog nga limug naghambal sa katawhan, “Mga kapareho ko nga mga Judio, kag kamo tanan nga nagauroli sa Jerusalem, pamati kamo hay isugid ko kaninyo ang buut hambalun kang nagakaratabo nga dya. ");
INSERT INTO krj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bukun ti lingin ang mga tawo nga dya nga pareho kang pagdumdum ninyo, tungud hay alas nwebe pa lang dya ti aga. ");
INSERT INTO krj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ang hitabo nga dya amo run ang gintagna kato anay kang propeta nga si Joel, nga nagakuon, ");
INSERT INTO krj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nagkuon ang Dios, ‘Sa urihi nga mga inadlaw amo dya ang akun himoon: itao ko ang akun Ispirito sa tanan nga tawo. Dayon, ang inyo kabataan nga laki kag bayi magasugid kang mensahe kang Dios. Ang inyo mga pamatan-un nga laki makakita kang mga paranan-awun, Kag ang inyo mga mal-am nga mga laki magadamgo. ");
INSERT INTO krj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sa amo man to nga mga inadlaw itao ko ang akun Ispirito sa akun mga surugoon nga laki kag bayi. Kag magasugid man sanda kang mensahe kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magapakita ako kang milagro sa langit, Kag magapakita ako kang mga katingalahan rugya sa lupa pareho kang dugo, kalayo kag aso nga nagatub-ok. ");
INSERT INTO krj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ang adlaw magadulum kag ang bulan magapula nga daw dugo. Dya mahanabo sa wara pa mag-abot ang indi matupungan kag mahimayaun nga adlaw nga ang Ginoong Dios magahukum. ");
INSERT INTO krj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kag ang bisan sin-o nga magapanawag sa Ginoo maluwas.’” ");
INSERT INTO krj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nagpadayon pa gid si Pedro sa paghambal, “Mga kapareho ko nga mga Israelenhun, pamatii ninyo ako! Si Jesus nga taga-Nazaret sangka tawo nga ginsugo kang Dios, kag dya ginpamatud-an na kaninyo paagi sa mga milagro, mga katingalahan kag mga paratandaan nga ana ginhimo paagi kay Jesus. Kamo mismo nakamaan man kadya hay rugya gid dya natabo kaninyo. ");
INSERT INTO krj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naman-an run nga daan kang Dios katong una pa gid nga si Jesus igatugyan kaninyo hay amo man nga daan ria ang plano kang Dios. Ginpalansang ninyo tana sa kros kag ginpapatay sa mga tawo nga makasasala. ");
INSERT INTO krj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ginbanhaw tana kang Dios kag ginhilway halin sa gahum kang kamatayun, tungud hay bisan pa ang kamatayun indi sarang makapugung kana. ");
INSERT INTO krj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tungud nga nagkuon anay si David nahanungud kay Jesus nga, ‘Nakita ko nga ang Ginoo nagaimaw pirme kanakun kag tungud nga wara tana nagabiya kanakun, indi gid ako maano. ");
INSERT INTO krj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amo ria nga nagakalipay gid ang akun tagipusoon, kag masinadyahun ako nga nagadayaw sa Dios. Kag magataliwan ako nga nagapabilin ang akun paglaum. ");
INSERT INTO krj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tungud hay indi mo pagpabay-an ang akun kalag sa lugar kang mga patay, kag indi man ikaw magtugot nga madunot ang lawas kang imong balaan nga surugoon. ");
INSERT INTO krj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ginpamaan mo kanakun ang mga dalan paagto sa kabuhi, kag ang imong presensya magatugro kanakun kang tuman nga kalipay.’” ");
INSERT INTO krj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga kabugtoan, makahambal ako kaninyo nga may kasigurohan nahanungud sa atun ulang nga si David, nga tana napatay kag ginlubung kag ang ginlubngan kana rugyan hasta sa kadya nga mga inadlaw. ");
INSERT INTO krj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Si David sangka propeta, kag naman-an na nga ang Dios nagsaad kana. Nagsumpa ang Dios nga ang isara sa mga linahi ni David magapanubli kang anang ginharian. ");
INSERT INTO krj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ginapanuruk nga daan ni David ang matabo gani naghambal tana nahanungud kang pagkabanhaw ni Cristo katong nagkuon tana, ‘Wara tana ginpabay-an sa lugar kang mga patay, kag wara madunot ang ana nga lawas.’ ");
INSERT INTO krj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Si Jesus nga dya ginbanhaw kang Dios kag kami tanan mga manugpamatuod ka dya. ");
INSERT INTO krj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kang ginbayaw tana sa tuo kang Dios, kag nabaton na halin sa Dios nga anang Amay ang ginsaad nga Balaan nga Ispirito, gintugro na man dya kanamun pareho kang inyo nakita kag nabatian tulad kadya. ");
INSERT INTO krj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wara magpalangit si David, pero amo dya ang kuon na, ‘Ang Ginoong Dios nagkuon sa akun nga Ginoo, Rugya ikaw pungko sa akun tuo. ");
INSERT INTO krj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Hasta nga paampoon ko kanimo ang imo nga mga kaaway.’” ");
INSERT INTO krj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kag nagpadayon pa gid si Pedro sa paghambal, “Gani, kinahanglan nga maman-an kang tanan nga mga Israelenhun nga ang Jesus nga dya nga inyo ginlansang sa kros ginhimo kang Dios nga Ginoo kag Cristo!” ");
INSERT INTO krj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kang mabatian kang katawhan ang mga ginpanghambal nga dya ni Pedro, natandug gid ang anda baratyagun, kag nagkuon sanda kana kag sa iba pa nga mga apostoles, “Ti, mga kabugtoan, ano bay kadya ang amun himoon?” ");
INSERT INTO krj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nagsabat si Pedro, “Maghinulsul kamo kang inyo mga sala kag magpabawtiso sa ngaran ni Jesu-Cristo, agud nga ang Dios magapatawad kaninyo kag inyo mabaton ang anang regalo nga amo ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tungud hay ang ginsaad nga dya kang Dios para gid kaninyo kag sa inyo mga kabataan, kag para sa tanan nga rugto sa marayu—dya para gid sa tanan nga ginaagda kang atun Ginoong Dios nga magaparapit kana.” ");
INSERT INTO krj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Raku pa gid ang ginkuon ni Pedro sa pagpamatuod kang ana mga ginpanghambal. Kag ginpanghangkat na sanda nga nagakuon, “Luwasa ninyo ang inyo kaugalingun sa silot nga magaabot sa mga tawo sa kadya nga panag-on nga nagahimo kang malaot.” ");
INSERT INTO krj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Amo to kag ang mga nagtoo sa ginpanghambal ni Pedro ginpangbawtisohan, kag sa amo gid to nga adlaw mga tatlo ka libo ka tawo ang nadugang sa anda nga grupo. ");
INSERT INTO krj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nagmaukud sanda sa pagtuon kang mga ginapanudlo kang mga apostoles, sa pagpakig-imaw sa kapareho nanda nga tumuluo kay Cristo, sa pagpamihak-pihak kang tinapay kag sa pagpangamuyo. ");
INSERT INTO krj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Duro nga mga milagro kag mga katingalahan nga butang ang ginapanghimo kang Dios paagi sa mga apostoles, gani ang katawhan may toman nga pagtahod sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nagairimaway ang tanan nga tumuluo kag nagapaambitanay sanda tanan kang andang mga pagkabutang. ");
INSERT INTO krj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ginabaligya nanda ang anda mga propedad kag mga pagkabutang kag ang bayad ka dya ginahururay nanda sa tanan, suno sa kinahanglan kang tagsa-tagsa. ");
INSERT INTO krj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Adlaw-adlaw nagatiripon sanda sa templo, kag nagakaraun sanda kang tingub sa andang mga balay. Malipayun kag maalwan ang andang mga tagipusoon nga nagaambitanay sa pagkaun. ");
INSERT INTO krj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nagadayaw sanda sa Dios kag nahamut-an kang tanan nga tawo. Kag kada adlaw ginadugang kang Ginoo sa andang grupo ang mga nagakaraluwas. ");
INSERT INTO krj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sangka adlaw, alas tres ti hapon nga amo ang oras nga inugpangamuyo, nag-agto si Pedro kag si Juan sa templo. ");
INSERT INTO krj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kar-on, sa gawang kang templo nga ginatawag “Manami nga Gawang” may sangka tawo nga lupog halin pa kang ana pagkatawo. Kada adlaw ginadara tana kag ginabutang sa gawang nga dya agud magpakilimos sa mga tawo nga nagasurulud sa templo. ");
INSERT INTO krj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pagkakita na kay Pedro kag Juan nga nagapasulud sa templo, dayon na nga pakilimos kananda. ");
INSERT INTO krj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ginturuk tana kang tampad ni Pedro kag ni Juan kag nagkuon si Pedro kana, “Turuk rugya kanamun!” ");
INSERT INTO krj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nagturuk man tana kananda nga nagapaabot-abot nga may mabaton tana kananda. ");
INSERT INTO krj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dayon nagkuon si Pedro kana, “Wara gid ako ti kwarta, pero itugro ko kanimo kon ano ang rugya kanakun. Sa ngaran ni Jesu-Cristo nga taga-Nazaret, tindug kag magpanaw!” ");
INSERT INTO krj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amo to kag ginkaptan ni Pedro ang tawo nga lupog sa tuo na nga alima kag patindugun, kag lagi-lagi kato nagbaskug ang anang kahig kag buko-buko. ");
INSERT INTO krj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nagtumbo tana kag nagtindug kag magpanaw-panaw. Dayon, nagtawas tana kanday Pedro nga nagsulud sa templo nga nagapanaw kag nagatumbo-tumbo nga nagadayaw sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakita tana kang tanan nga mga tawo rugto nga nagapanaw kag nagadayaw sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kang matalupangdan nanda nga tana amo ang manugpakilimos nga nagapungko anay sa Manami nga Gawang kang templo, natingala gid sanda kag daw indi makapati sa natabo nga dya kana. ");
INSERT INTO krj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Samtang nagadapit-dapit ang tawo kay Pedro kag Juan rugto sa lugar nga ginatawag Balkon ni Solomon, ang tanan nga mga tawo, sa sobra nanda nga katingala, nagdinalagan parapit kananda. ");
INSERT INTO krj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kang makita dya ni Pedro, ginkun-an na sanda, “Mga kapareho ko nga mga Israelenhun, andut haw nga natingala gid kamo kadya, kag andut haw nga ginaturuk gid ninyo kami nga daw sa kami ang nagpapanaw sa tawo nga dya paagi sa amun kaugalingun nga gahum ukon pagkadiosnon? ");
INSERT INTO krj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ang Dios ni Abraham, ni Isaac, kag ni Jacob—ang Dios kang atun mga kamal-aman amo ang nagpadungug sa anang surugoon nga si Jesus. Tana kadya amo ang inyo nga gintugyan sa mga may awtoridad, kag ginsikway ninyo sa atubang ni Pilato bisan pa nga nakapamat-ud run si Pilato nga hilwayun tana. ");
INSERT INTO krj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Si Jesus balaan kag matarung, pero ginsikway ninyo tana, kag sa baylo ginpangayo ninyo nga hilwayun ang manugpatay. ");
INSERT INTO krj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ginpatay ninyo ang Ginahalinan kang kabuhi, pero ginbanhaw tana kang Dios kag kami makapamatuod ka dya. ");
INSERT INTO krj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tungud sa gahum kang ngaran ni Jesus nakaagum kang kabaskug ang tawo nga dya nga inyo nakita kag nakilala. Ang pagtoo paagi kay Jesus amo ang nag-ayad kana kang bug-os, pareho kang inyo makita sa tulad. ");
INSERT INTO krj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kar-on, mga kabugtoan, naman-an ko nga kamo kag ang inyo mga manugdumara wara kamaan kang inyo ginhimo. ");
INSERT INTO krj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ginpamaan nga daan kato anay kang Dios paagi sa tanan nga mga propeta nga ang anang Cristo kinahanglan nga mag-antos. Gintuman na dya paagi sa natabo nga dya. ");
INSERT INTO krj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gani kar-on, maghinulsul kamo kang inyo mga sala kag magparapit sa Dios agud patawarun na kamo sa inyo mga sala, ");
INSERT INTO krj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","agud to nga makaagum kamo kang katawhayan nga magahalin sa Ginoo. Kag ipadara na kaninyo si Jesus nga amo ang Cristo nga ana ginpili nga daan para kaninyo. ");
INSERT INTO krj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kinahanglan magpabilin anay tana sa langit hasta sa tion nga bag-ohon kang Dios ang tanan nga mga butang, tungud hay amo gid ria ang anang ginkuon paagi sa anang balaan nga mga propeta katong una pa gid. ");
INSERT INTO krj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pareho kang ginkuon ni Moises, ‘Ang Ginoo nga inyo Dios magapili para kaninyo kang sangka propeta nga rugyan mismo kaninyo magahalin, pareho kang ginhimo na kanakun. Kinahanglan pamatian ninyo ang tanan nga anang ihambal kaninyo. ");
INSERT INTO krj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ang bisan sin-o nga indi magpamati sa propeta nga ria pagapainun sa katawhan kang Dios kag pagalaglagun.’ ");
INSERT INTO krj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ang tanan nga mga propeta nga may mensahe halin sa Dios, umpisa kay Samuel kag sa mga propeta nga nagasurunod kana, sanda tanan nagpanagna man kang nagakaratabo sa kadya nga mga inadlaw. ");
INSERT INTO krj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ang mga ginsaad kang Dios paagi sa anang mga propeta para gid kaninyo kag naabay kamo sa kasugtanan kang Dios kag kang inyo mga kaulangan. Tungud hay nagkuon tana kay Abraham, ‘Paagi sa imo mga linahi, pakamayadun ko ang tanan nga mga tawo sa kalibutan.’ ");
INSERT INTO krj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amo ria nga nagpili ang Dios kang anang surugoon kag ginpadara una kaninyo agud pakamayadun na kamo paagi sa pagpaliso kang kada isara kaninyo sa malaot ninyo nga mga ginahimo.” ");
INSERT INTO krj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nagahambal pa sa katawhan si Pedro kag si Juan kang parapitan sanda kang mga pari, kag kang kapitan kang mga gwardya sa templo kag kang mga Saduceo. ");
INSERT INTO krj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Naugut sanda tungud hay ang darwa ka apostoles nga dya nagapanudlo sa katawhan nga si Jesus nabanhaw, kag dya nagapamatuod nga ang mga patay mabanhaw. ");
INSERT INTO krj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gani gindakup nanda ang darwa kag ginsulud sa prisohan hasta sa masunod nga adlaw tungud hay sirum run kato. ");
INSERT INTO krj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero raku sa mga nakabati kang Pulong kang Dios ang nagtoroo; kag ang kadurohon nanda nagdangat sa mga lima ka libo. ");
INSERT INTO krj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagkasunod nga adlaw, nagtiripon sa Jerusalem ang mga manugdumara kang mga Judio, ang mga kamal-aman, kag ang mga manunudlo kang Kasugoan. ");
INSERT INTO krj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kaimaw man nanda si Anas nga amo ang Pinakamataas nga Pari, kag rugto man si Caifas, si Juan, si Alejandro, kag ang iba pa nga katapo kang panimalay kang Pinakamataas nga pari. ");
INSERT INTO krj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ginpaatubang nanda si Pedro kag si Juan kananda kag ginpamangkot, “Kay sin-o gahum kag ngaran ang inyo gin-gamit sa paghimo kang butang nga dya?” ");
INSERT INTO krj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Si Pedro nga nagamhan kang Balaan nga Ispirito nagsabat kananda, “Kamo nga mga manugdumara kang katawhan kag mga kamal-aman, ");
INSERT INTO krj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tungud ginausisa ninyo kami tulad nahanungud sa mayad nga buhat nga ginhimo sa tawo nga lupog nga dya, kag kon sa ano nga paagi nga naayad tana kadya, ");
INSERT INTO krj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dapat ninyo tanan maman-an kag kang tanan nga mga Israelenhun, nga ang tawo nga dya nga nagatindug sa inyo tunga naayad tungud sa gahum kang ngaran ni Jesu-Cristo nga taga-Nazaret nga inyo ginpalansang sa kros pero ginbanhaw kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tana amo ‘Ang bato nga wara ninyo maluyagi, kamo nga mga manughimo kang balay, amo pa ang nangin pamusod nga bato.’ ");
INSERT INTO krj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Magluwas kay Jesus wara run ti bisan sin-o nga makaluwas kanatun sa sala. Tungud nga sa bug-os nga kalibutan, ang ngaran gid lang ni Jesus ang gintao kang Dios, agud paagi ka dya maluwas kita.” ");
INSERT INTO krj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Natingala gid ang mga katapo kang konseho kang makita nanda ang kaisug ni Pedro kag ni Juan sa pagsabat, kag matalupangdan nanda nga sanda ka dya mga ultimo lang man nga tawo kag wara ti tinun-an. Kag naman-an nanda nga kaimaw anay sanda ni Jesus. ");
INSERT INTO krj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pero kang makita nanda ang tawo nga naayad nga nagatindug sa tupad nanday Pedro kag Juan, wara run sanda ti makuon kontra kananda. ");
INSERT INTO krj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gani ginpagwa anay nanda ang darwa halin sa lugar nga ginatiponan kang konseho, kag naghinon-anun sanda, ");
INSERT INTO krj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nga nagakuon, “Ano ang himoon natun sa darwa nga dya tulad karia nga nabalahuba run sa bilog nga syudad kang Jerusalem ang makatiringala nga milagro nga nahimo paagi kananda kag indi man natun dya mapanginwara? ");
INSERT INTO krj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero amo dyaay ang himoon ta agud nga ang bagay nga dya indi run gid magrapta sa mga katawhan: ipaandaman ta sanda nga indi run magliwan ka hambal bisan kay sin-o nahanungud sa ngaran nga dya.” ");
INSERT INTO krj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Amo to kag gintawag nanda si Pedro kag si Juan nga magbalik sa sulud kag ginkun-an nga indi run gid maghambal ukon magpanudlo sa ngaran ni Jesus. ");
INSERT INTO krj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero nagsabat si Pedro kag si Juan kananda, “Kamo mismo ang maghusgar kon igsakto bala sa panuruk kang Dios ang magsunod kami kaninyo ukon kana. ");
INSERT INTO krj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tungud hay indi gid mahimo nga indi kami maghambal kang nahanungud sa amun nakita kag nabatian.” ");
INSERT INTO krj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ginpaandaman pa gid sanda ka mayad kang konseho antes buy-an. Wara sanda ti makita nga paagi nga silotan ang darwa nga dya tungud hay ang tanan nga mga tawo nagadayaw sa Dios tungud kang natabo. ");
INSERT INTO krj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tungud hay ang tawo nga naayad nga dya sa makatiringala nga paagi nagapang-edadun run kang kapin sa kap-atan ka tuig. ");
INSERT INTO krj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kang mabuy-an run sanday Pedro kag Juan, nagbalik sanda sa andang mga kaimaw, kag ginsugid nanda ang ginpanghambal kang mga pangulo kang kaparian kag kang mga kamal-aman. ");
INSERT INTO krj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagkabati nanda ka dya, naghugpong sanda sa pagpangamuyo sa Dios nga nagakuon, “Ginoo nga makagagahum sa tanan, ikaw ang nagtuga kang langit, lupa kag dagat, kag kang tanan nga rugyan kananda! ");
INSERT INTO krj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sa paggiya kang Balaan nga Ispirito, naghambal ikaw paagi kay David nga imong surugoon nga amun ulang, kang magkuon tana, ‘Andut haw nga nagabalingaso ang kaugut kang mga bukun ti Judio; Kag nagahumun ang mga tawo kang mga butang nga wara ti pulos? ");
INSERT INTO krj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ang mga hari sa lupa nagaharanda sa pagpakig-away, kag ang mga manugdumara nagtiripon sa pagpakigbato sa Ginoo kag sa anang Pinili.’ ");
INSERT INTO krj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Amo gid ria ang natabo, sa dya nga syudad nagtipon sanday Herodes kag Poncio Pilato imaw kang mga bukun ti Judio kag kang bilog nga katawhan kang Israel agud kontrahun si Jesus nga imong Balaan nga Surugoon nga imong Pinili. ");
INSERT INTO krj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ginhimo nanda ang mga butang nga imo ginplano kag ginbuut kauna pa nga daan nga dapat matabo. ");
INSERT INTO krj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kar-on, Ginoo, talupangda ang andang pagpamahug kanamun. Buligan mo kami nga imong mga surugoon nga makahambal kang imong pulong nga may tuman nga kaisug. ");
INSERT INTO krj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipakita ang imong gahum sa pagpang-ayad kag itugot nga makahimo kami kang mga milagro kag katingalahan nga mga butang paagi sa ngaran kang imong Balaan nga Surugoon nga si Jesus.” ");
INSERT INTO krj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapos nanda ka pangamuyo, nag-uyug ang lugar nga andang ginatiponan. Gin-gamhan sanda tanan kang Balaan nga Ispirito kag nagharambal kang pulong kang Dios nga may kaisug. ");
INSERT INTO krj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nagasinantoanay ang panghuna-huna kag baratyagun kang mga tumuluo. Wara ti bisan isara nga nagaangkun kang bisan ano nga pagkabutang nga ginakabig na nga ana, kundi nga ginapaambit nanda dya sa iba. ");
INSERT INTO krj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","May tuman nga gahum ang mga apostoles sa pagpamatuod kang nahanungud sa pagkabanhaw ni Ginoong Jesus, kag ginpasagahay kang Dios ang anang bugay kananda tanan. ");
INSERT INTO krj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wara ti may nalisdan bisan isara kananda, tungud hay ang may mga lupa ukon mga balay, ginabaligya nanda dya kag ang bayad na ka dya ginadara nanda ");
INSERT INTO krj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kag itugyan sa mga apostoles. Dayon, ang kwarta ginapanagtag suno sa kinahanglan kang kada isara. ");
INSERT INTO krj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amo ria ang ginhimo ni Jose nga taga-Cipro, nga sangka Levita, nga ginatawag man kang mga apostoles nga Bernabe (nga kon sayudon, manugparig-un kang baratyagun). ");
INSERT INTO krj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ginbaligya na ang anang uma, kag ang bayad na kadya gindara na kag gintugyan sa mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero may sangka tawo rugto nga ginahingaranan kay Ananias imaw kang anang asawa nga si Safira nga nagbaligya kang sangka puna kang andang propedad. ");
INSERT INTO krj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ginhawidan ni Ananias ang iba nga bayad ka dya, kag naman-an man kang anang asawa, kag ang nabilin amo lang ang gintugyan na sa mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero nagkuon si Pedro kana, “Ananias, andut haw nga ginpabay-an mo lang si Satanas nga gamhan ang imong panghuna-huna nga magbutig ikaw sa Balaan nga Ispirito paagi sa paghawid kang bahin kang bayad kang imong lupa? ");
INSERT INTO krj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kang wara pa nimo mabaligya, indi bala nga imo man dya nga daan? Kag kang mabaligya mo run dya, ikaw man kabay ang may kinamatarung kon iwanun mo ang bayad? Andut haw nga nakapinsar ikaw nga maghimo kang amo dya? Wara ikaw nagbutig sa tawo kundi sa Dios!” ");
INSERT INTO krj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pagkabati ni Ananias ka dya, natumba tana nga patay. Kag hinadlukan gid ang tanan nga nakabati kang hitabo nga dya. ");
INSERT INTO krj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dayon, ang mga pamatan-un nga laki nagparapit kag ginbarahosan ang bangkay ni Ananias kag gindara sa gwa kag ginlubung. ");
INSERT INTO krj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagkaligad kang mga tatlo ka oras nagsulud si Safira nga anang asawa nga wara nakamaan kon ano ang natabo. ");
INSERT INTO krj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nagkuon si Pedro kana, “Sugidi ako, amo gid bala dya ang bayad kang lupa nga inyo ginbaligya?” Nagsabat tana, “Huud, amo ria ang bayad.” ");
INSERT INTO krj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kag nagkuon si Pedro kana, “Andut haw nga nagsugtanay kamo nga mag-asawa nga tirawan ang Ispirito kang Ginoo? Sulnga, dyan run sa gawang ang mga laki nga naglubung kang imong bana, kag ikaw run ang isunod nanda.” ");
INSERT INTO krj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kag lagi-lagi natumba si Safira nga patay sa atubang ni Pedro. Pagsulud kang mga pamatan-un nga laki nakita nanda nga patay run dya. Gindara nanda ang anang bangkay sa gwa kag ginlubung sa ingud kang anang bana. ");
INSERT INTO krj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hinadlukan gid ka mayad ang bug-os nga iglesia kag ang tanan nga nakabati kang hitabo nga dya. ");
INSERT INTO krj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Duro nga mga milagro kag mga katingalahan ang nahimo kang mga apostoles sa katawhan. Tanan nga mga tumuluo nagatiripon sa lugar nga ginatawag Balkon ni Solomon. ");
INSERT INTO krj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ang mga tawo nga bukun pa ti tumuluo wara gid magpangahas nga mag-intra kananda, wara ti sapayan nga bahul gid ang pagtahod nanda sa mga tumuluo. ");
INSERT INTO krj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero nagaduro pa gid ang mga kalalakin-an kag kababainhan nga nagtoroo sa Ginoo, kag ginadugang sa andang grupo. ");
INSERT INTO krj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gani ginadara kang mga tawo ang andang mga masakitun sa mga karsada kag ginapamutang sa mga baratangan kag sa mga banig agud nga pag-agi ni Pedro, bisan maharonan na lang ang iba ka dya kananda. ");
INSERT INTO krj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nagtiripon man ang tama ka duro nga mga tawo nga nagharalin pa sa mga kabanwahanan sa palibot kang Jerusalem nga nagadara kang andang mga masakitun kag mga nasab-an kang malaot nga ispirito, kag nag-arayad sanda tanan. ");
INSERT INTO krj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kar-on, ang Pinakamataas nga Pari kag ang tanan nga anang mga kaimaw nga katapo kang sekta kang mga Saduceo nahisa gid ka mayad sa mga apostoles. Gani ang ginhimo nanda, ");
INSERT INTO krj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ginpadakup nanda ang mga apostoles kag ginluput sa prisohan. ");
INSERT INTO krj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero pagkagabii ginbuksan kang anghel kang Ginoo ang mga gawang kang prisohan kag ginpagwa sanda. Nagkuon dya kananda, ");
INSERT INTO krj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Agto kamo sa templo kag isugid sa mga katawhan ang nahanungud sa bag-o nga sahi kang Kabuhi nga dya.” ");
INSERT INTO krj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pagkabati nanda ka dya, nagsulud sanda sa templo pagkakasanagun kag nagpanudlo sa mga tawo. Sa pihak tana nga bahin, nag-abot ang Pinakamataas nga Pari kag anang mga kaibahan, kag ginpatawag nanda ang tanan nga katapo kang konseho kag mga kamal-aman. Dayon nagpasugo sanda sa prisohan nga ibul-un ang mga apostoles kag ipaatubang kananda. ");
INSERT INTO krj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero pag-abot kang mga ginsugo sa prisohan wara run rugto ang mga apostoles, gani nagbalik run lang sanda kag ginsugid dya sa konseho. ");
INSERT INTO krj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kuon nanda, “Pag-abot namun rugto hugut man ang pagkasarado kang mga gawang kag ang mga gwardya rugto man sa mga gawang nagatirindug, pero pagbukas namun, wara kami ti nakita nga tawo sa sulud!” ");
INSERT INTO krj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kang mabatian dya kang kapitan kang mga gwardya sa templo kag kang mga pangulo kang kaparian, naburung sanda kag naminsar kon ano pa gid ang mangin resulta na ka dya. ");
INSERT INTO krj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dayon may sangka tawo nga nag-abot kag nagkuon, “Ang mga laki nga inyo ginpriso, nagapanudlo sa mga tawo rugto sa templo!” ");
INSERT INTO krj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Amo to kag ang kapitan, imaw kang anang mga tinawo nag-agto sa templo kag ginbuul ang mga apostoles, pero wara nanda ginpaagi sa pwersa ang pagdara kananda tungud hay nahadluk sanda nga batohon kang mga tawo. ");
INSERT INTO krj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kag gindara nanda ang mga apostoles kag ginpaatubang sa konseho. Gin-usisa sanda kang Pinakamataas nga Pari, ");
INSERT INTO krj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nga nagakuon, “Ginpaandaman gid namun kamo ka mayad nga indi magpanudlo sa ngaran kang tawo nga to. Pero gintugub run ninyo ang bilog nga Jerusalem kang mga ginapanudlo ninyo, kag gusto pa ninyo nga ipapanabat kanamun ang kamatayun kang tawo nga to!” ");
INSERT INTO krj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nagsabat si Pedro kag ang iba pa nga mga apostoles, “Ang Dios ang dapat namun tumanun kag indi ang tawo. ");
INSERT INTO krj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ang Dios kang atun mga kaulangan amo ang nagbanhaw kay Jesus nga inyo ginpapatay paagi sa paglansang kana sa kros. ");
INSERT INTO krj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ginbayaw tana kang Dios sa anang tuo nga alima bilang Pangulo kag Manluluwas, sa pagtugro sa mga Israelenhun kang kahigayonan nga maghinulsul agud mapatawad ang andang mga sala. ");
INSERT INTO krj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami makapamatuod sa mga butang nga dya, kag amo man ang Balaan nga Ispirito, nga gintao kang Dios sa mga nagatuman kana.” ");
INSERT INTO krj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kang mabatian dya kang mga katapo kang konseho, nagbalingaso ang andang kaugut kag gusto run nanda nga ipapatay ang mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero nagtindug ang sangka Fariseo nga katapo kang konseho nga ginahingaranan kay Gamaliel. Manunudlo tana kang Kasugoan kag ginataha kang tanan nga tawo. Nagsugo tana nga pagaw-un anay ang mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pagkatapos nagkuon tana sa konseho, “Mga kasimanwa ko nga mga Israelenhun, mag-andam kamo sa ginatuyo ninyo nga himoon sa mga tawo nga dya. ");
INSERT INTO krj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kauna may sangka tawo anay nga nagtuhaw nga ginahingaranan kay Teudas nga nagapabugal nga daw si sin-o gid tana. Mga apat ka gatos nga mga tawo ang nagpasakup kana. Pero ginpatay tana kag ang anang mga sinakpan nagrinapta kag nangin wara lang man ti pulos ang andang gin-umpisahan. ");
INSERT INTO krj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos ka dya, si Judas ruman nga Galileanhun ang nagtuhaw kang panahon kang pagpangrehistro kang katawhan. Nakadara man tana kang mga tawo nga magsunod kana, pero ginpatay man tana kag ang tanan nga anang mga sinakpan nagrinapta lang man. ");
INSERT INTO krj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gani, kadya tana ginakun-an ko kamo nga indi ninyo paghilabti ang mga tawo nga dya. Pabay-i lang ninyo sanda. Tungud hay kon ang plano ukon tinutuyo nanda nga dya ana lang kang tawo, indi dya magmadinarag-un. ");
INSERT INTO krj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero kon ana dya kang Dios, indi ninyo sanda madaug. Masapwan lang ninyo ang inyo kaugalingun nga nagabato sa Dios.” Nagpati man ang konseho sa ginhambal ni Gamaliel. ");
INSERT INTO krj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ginpatawag nanda liwan ang mga apostoles nga magsulud kag ginpahanot. Dayon ginkun-an nga indi run magliwan ka hambal sa ngaran ni Jesus, kag pagkatapos ginbuy-an sanda. ");
INSERT INTO krj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Naghalin ang mga apostoles sa konseho nga nagakalipay tungud hay ginkabig kang Dios sanda nga takus nga mag-antos kang kahuruy-anan tungud lang sa ngaran ni Jesus. ");
INSERT INTO krj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kada adlaw nagaagto sanda sa templo kag sa mga kabalayan nga nagapadayon sa pagpanudlo kag pagpangwali kang Mayad nga Balita nahanungud kay Jesus nga amo ang Cristo. ");
INSERT INTO krj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sa mga inadlaw nga to, nga ang kadurohon kang mga gintuton-an nagadugang, ang mga Judio nga nagahambal kang Griego nagkurumodon kontra sa mga tumanduk nga mga Judio hay ang mga balo nga bayi sa anda nga grupo wara matatapi sa pagtugro kang rasyon kada adlaw. ");
INSERT INTO krj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Gani ginpatawag kang napulo'g darwa ka mga apostoles ang tanan nga mga gintuton-an kag nagkuon, “Bukun ti igsakto nga pabay-an namun ang pagpangwali kang Pulong kang Dios para lang matatapan namun ang pagpanagtag kang rasyon. ");
INSERT INTO krj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gani mga kabugtoan, pili kamo kang pito ka laki kaninyo nga kilala nga mga mayad, kag nagamhan kang Balaan nga Ispirito kag mangin-aramun. Sanda ka dya amo ang amun tugyanan kang buruhatun nga dya. ");
INSERT INTO krj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kag kami tamun, gamitun namun ang bug-os namun nga tion sa pagpangamuyo kag pagpangwali kang pulong kang Dios.” ");
INSERT INTO krj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Naluyagan kang bug-os nga katiringban ang ginhambal kang mga apostoles. Gani ginpili nanda si Esteban; tana kadya marig-un ti pagtoo kag nagamhan kang Balaan nga Ispirito, amo man sanday Felipe, Procoro, Nicanor, Timon, Parmenas, kag si Nicolas nga taga-Antioquia. Tana ka dya bukun ti Judio nga nadara sa relihiyon kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sanda ka dya ginprisentar kang bug-os nga katiringban sa mga apostoles, nga amo ang nagpangamuyo kag nagtungtong kang andang alima kananda. ");
INSERT INTO krj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ang Pulong kang Dios naglapnag pa gid, kag nagduro pa gid ang mga gintuton-an sa Jerusalem, kag tama man ka duro nga mga kaparian ang nagtoroo. ");
INSERT INTO krj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban, nga ginabugayan ka mayad kag ginatugroan kang Dios kang tuman nga gahum, naghimo kang daragkul nga mga milagro kag mga katingalahan nga mga butang sa katawhan. ");
INSERT INTO krj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero may mga tawo nga nag-upang kana nga halin sa mga katapo kang sinagoga nga ginatawag Mga Hinilway. Ang mga katapo na ka dya mga Judio nga taga-Cirene kag taga-Alejandria. Sanda kadya kag ang iba pa gid nga mga Judio nga taga-probinsya kang Cilicia kag Asia nagpakigbais kay Esteban. ");
INSERT INTO krj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero ang Balaan nga Ispirito nagtao kay Esteban kang kaaram nga kon maghambal tana indi gid sanda makadaug kana. ");
INSERT INTO krj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Gani, likum nga ginsutsot nanda ang pira ka mga tawo nga magkuon, “Nabatian namun tana nga naghambal kang malain kontra kay Moises kag sa Dios!” ");
INSERT INTO krj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kag ginpaugut nanda ang katawhan kag ang mga kamal-aman kag ang mga manunudlo kang Kasugoan. Gindakup nanda si Esteban kag ginpaatubang sa konseho. ");
INSERT INTO krj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dayon nagbuul sanda kang pira ka tawo nga maghambal kang butig kontra kay Esteban. Nagkuon sanda, “Ang tawo nga dya wara nagauntat sa paghambal kang malain kontra sa balaan nga templo kag sa Kasugoan ni Moises. ");
INSERT INTO krj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tungud hay nabatian namun tana nga nagkuon nga gub-un kang Jesus nga dya nga taga-Nazaret ang templo kag islan ang mga kinabatasan nga ginpapanubli ni Moises kanatun!” ");
INSERT INTO krj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ang tanan nga nagapurungko rugto sa konseho nagturuk gid ka mayad kay Esteban kag nakita nanda nga ang anang pungyahun daw pareho kang pungyahun kang anghel. ");
INSERT INTO krj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ginpamangkot si Esteban kang Pinakamataas nga Pari, “Matuod bala ang tanan nga ria?” ");
INSERT INTO krj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nagsabat si Esteban, “Mga kabugtoan kag mga ginikanan, pamatii ninyo ako. Ang mahimayaun nga Dios nagpakita sa atun ulang nga si Abraham kang rugto pa tana nagaistar sa Mesopotamia, antes tana magsaylo sa Haran. ");
INSERT INTO krj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nagkuon kana ang Dios, ‘Maghalin ikaw sa lugar nga dya kag bayai ang imong mga himata, kag mag-agto ikaw sa lugar nga akun itudo kanimo.’ ");
INSERT INTO krj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Amo to kag naghalin si Abraham sa lugar kang mga Caldeo kag nag-istar sa Haran. Kang napatay ang anang tatay, ginpasaylo tana kang Dios sa lugar nga dya nga amo run ang inyo ginaistaran kadya. ");
INSERT INTO krj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wara tana gintugroan kang Dios bisan sandapal nga lupa nga makuon na nga ana. Pero nagsaad ang Dios nga itugro dya kana nga mangin ana kag kang anang mga linahi, bisan pa kato nga tinion wara pa tana ti bata. ");
INSERT INTO krj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Amo dya ang ginkuon kang Dios kana, ‘Ang imo mga linahi magaistar sa iba nga pungsod, kag pagahimoon sanda nga mga uripun kag pagapaantoson sa sulud kang 400 ka tuig. ");
INSERT INTO krj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero pagasilotan ko ang pungsod nga magauripun kananda, kag pagkatapos, magahalin sanda sa lugar nga to kag magasimba sanda kanakun sa lugar nga dya.’ ");
INSERT INTO krj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naghimo ang Dios kang kasugtanan kay Abraham, kag ang tanda kang kasugtanan nga dya amo ang pagsirkom. Gani, kang may bata run si Abraham nga amo si Isaac, ginsirkom na dya sa ikawalo nga adlaw sa tapos dya mabata. Amo man to ang ginhimo ni Isaac sa anang bata nga si Jacob, kag amo man ang ginhimo ni Jacob sa anang napulo'g darwa ka mga kabataan nga atun mga kaulangan. ");
INSERT INTO krj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ang atun mga kaulangan nga to nahisa sa andang bugto nga si Jose. Gani ginbaligya nanda tana bilang uripun sa Ehipto. Pero ang Dios nagaimaw gid kana ");
INSERT INTO krj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kag ginhilway tana sa tanan na nga mga kabudlayan. Gintaw-an tana kang Dios kang mayad nga panimuut kag kaaram sa atubang ni Faraon nga hari kang Ehipto. Kag ginhimo tana ni Faraon bilang manugdumara kang bilog nga Ehipto kag kang anang bug-os nga panimalay. ");
INSERT INTO krj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kar-on, nag-abot ang taggurutum sa bilog nga Ehipto kag sa Canaan, nga nagdara kang tuman nga kabudlayan. Ang atun mga kaulangan wara gid ti mabul-an kang pagkaun. ");
INSERT INTO krj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kang pagkabati ni Jacob nga may pagkaun sa Ehipto, ginsugo na rugto ang anang kabataan nga atun mga kaulangan. Amo dya amo ang una nanda nga pag-agto sa Ehipto. ");
INSERT INTO krj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sa ikarwa nanda nga pag-agto, nagpakilala kananda si Jose nga anda bugto, kag nakilal-an man ni Faraon ang panimalay ni Jose. ");
INSERT INTO krj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dayon ginpaabat ni Jose si Jacob nga anang tatay kag ang anang bug-os nga panimalay; kapitoan kag lima sanda tanan. ");
INSERT INTO krj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Amo to kag nag-agto si Jacob sa Ehipto. Rugto tana napatay kag amo man ang atun mga kaulangan. ");
INSERT INTO krj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gindara ang andang mga lawas pabalik sa Sikem. Rugto sanda ginlubung sa rulubngan nga ginbakal anay ni Abraham sa mga kabataan ni Hamor. ");
INSERT INTO krj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kang marapit run lang ang tion nga tumanun kang Dios ang anang ginsaad kay Abraham, tama run gid ka duro ang linahi kang atun mga kaulangan sa Ehipto. ");
INSERT INTO krj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kang urihi, lain run ang hari nga naggahum sa Ehipto, nga wara makakilala kay Jose. ");
INSERT INTO krj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gindayaan na ang atun mga kasimanwa kag nangin mapintas tana sa atun mga kaulangan. Ginpirit na sanda nga itapok ang andang mga lapsag agud to nga magkaramatay. ");
INSERT INTO krj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sa amo man to nga tion, natawo si Moises, sangka lapsag nga nahamut-an kang Dios. Sa sulud kang tatlo ka bulan ginbatiti tana kang anang panimalay. ");
INSERT INTO krj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kang gintapok tana kang anang mga ginikanan, ginbuul tana kang bayi nga bata ni Faraon kag ginpabahul kag ginkabig nga ana kaugalingun nga bata. ");
INSERT INTO krj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ang tanan nga kinaaram kang taga-Ehipto gintudlo kay Moises, gani nangin sampatun tana, indi lamang sa paghambal kundi sa buhat man.” ");
INSERT INTO krj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kang magpang-edadun run tana kang kap-atan ka tuig, napinsaran na nga magbisita sa anang mga kapareho nga Israelenhun. ");
INSERT INTO krj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nakita na ang isara kananda nga ginasakit kang sangka Ehiptohanun, gani nga gin-apinan na dya kag ginpatay na ang Ehiptohanun bilang pagtimalus. ");
INSERT INTO krj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Abi na nga mahangpan kang anang mga kapareho nga Israelenhun nga tana amo ang pagagamitun kang Dios sa paghilway kananda, pero wara nanda dya mahangpi. ");
INSERT INTO krj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kang masunod nga adlaw, may nakita tana nga darwa ka Israelenhun nga nagaaway. Pasag-uliun na raad sanda nga nagakuon, ‘Mga amigo, pareho lang man kamo nga mga Israelenhun, andut nga nagaaway kamo?’ ");
INSERT INTO krj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero gintiklod si Moises kang isara nga amo ang nagaaway sa isara kag ginkun-an, ‘Sin-o ang naghimo kanimo nga magdumara kag maghukum kanamun? ");
INSERT INTO krj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Patyun mo man bala ako pareho kang imong ginhimo sa Ehiptohanun kahapon?’ ");
INSERT INTO krj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagkabati ni Moises ka dya nagpalagyo tana paagto sa Madian. Nagpangasawa tana rugto kag nangin tatay kang darwa ka bata nga laki. ");
INSERT INTO krj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pagkaligad kang kap-atan ka tuig, nagpakita kay Moises ang sangka anghel sa nagadaba-daba nga purongpong, rugto sa kamingawan marapit sa Bukid kang Sinai. ");
INSERT INTO krj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Natingala gid tana sa anang nakita. Kang ginaparapitan na run dya agud himutadan ka mayad, nabatian na ang limug kang Ginoo: ");
INSERT INTO krj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako ang Dios kang imong mga kaulangan, ang Dios ni Abraham, Isaac, kag Jacob.’ Nagkurudug si Moises sa kahadluk kag wara run ti kaisug sa pagturuk. ");
INSERT INTO krj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nagkuon ang Ginoo kana, ‘Huksa ang imo sandalyas tungud hay ang lugar nga dya nga imo ginatindugan balaan. ");
INSERT INTO krj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakita ko gid ang sobra nga pagpigus sa akun mga katawhan sa Ehipto, kag nabatian ko man ang anda nga pag-ugayung. Amo ria nga nag-abot ako sa paghilway kananda. Dali, sugoon ko ikaw nga mag-agto sa Ehipto.’ ");
INSERT INTO krj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Si Moises nga dya nga anda ginsikway kang magkuon sanda, ‘Sin-o ang naghimo kanimo nga magdumara kag maghukum kanamun?’ Tana man ang ginsugo kang Dios nga mangin manugdumara kag manughilway paagi sa pagbulig kang anghel nga nagpakita kana sa purongpong. ");
INSERT INTO krj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tana ang nagpangulo kananda paggwa sa Ehipto. Naghimo tana kang mga milagro kag katingalahan nga mga butang sa Ehipto, kag sa Dagat nga Pula, kag sa kamingawan sa sulud kang 40 ka tuig. ");
INSERT INTO krj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Moises man nga dya ang naghambal sa mga katawhan kang Israel, ‘Ang Dios magapili para kaninyo kang sangka propeta nga rugyan mismo kaninyo magahalin, pareho kang ginhimo na kanakun.’ ");
INSERT INTO krj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Moises nga dya ang kaimaw kang katiringban kang Israel sa kamingawan, kag kang anghel nga nagpakighambal kana sa bukid kang Sinai, kag imaw man kang atun kaulangan. Tana ang nagbaton kang mga buhi nga Pulong kang Dios agud ipaalinton kanatun. ");
INSERT INTO krj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero ang atun mga kaulangan indi gid magtuman kana. Ginsikway nanda tana, kag ang anda tana nga handum amo ang magbalik sa Ehipto. ");
INSERT INTO krj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nagkuon sanda kay Aaron, ‘Himoi kami kang mga dios-dios nga amo ang magapanguna kanamun. Tungud hay kon parte tana kay Moises nga to nga nagdara kanamun paggwa sa Ehipto, wara kami kamaan kon naiwan run tana.’ ");
INSERT INTO krj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Amo run to ang tion nga naghimo sanda kang ribulto sa dagway kang tinday nga baka. Ginhaladan nanda dya kang inihaw nga mga sapat, kag nagsinadya sanda sa pagpadungug kang andang kaugalingun nga inobrahan. ");
INSERT INTO krj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Gani gintalikdan sanda kang Dios kag ginpabay-an run lang nga magsimba sa mga butang sa kahawaan. Amo gid dya ang nasulat sa libro kang mga propeta nga nagakuon, ‘Kamo nga mga Israelenhun, bukun ti para kanakun ang ginhalad ninyo nga mga gin-ihaw nga sapat, rugto sa kamingawan sa sulud kang kap-atan ka tuig. ");
INSERT INTO krj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ginadara-dara ninyo ang torda kang inyo dios-dios nga si Moloc kag ang bituon nga imahen kang inyo dios-dios nga si Refan. Ang mga rebulto nga dya ginhimo ninyo agud simbahun. Gani tabugon ko kamo hasta sa pihak pa gid kang Babilonia.’ ");
INSERT INTO krj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kang rugto pa sa kamingawan ang atun mga kaulangan may torda sanda nga rugyan ang presensya kang Dios. Ang torda nga dya ginhimo suno sa ginsugo kang Dios kay Moises, kag suno man sa surondan nga ginpakita kana. ");
INSERT INTO krj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kang urihi, ginpanubli dya kang andang mga kabataan, kag gindara nanda dya kang si Josue amo run ang nagapangulo kananda samtang ginabuul nanda ang mga kalupaan kang mga nasyon nga ginapanabog kang Dios. Ang torda nga dya nagpabilin rugto hasta sa tion ni David. ");
INSERT INTO krj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nahamut-an gid kang Dios si David. Ginpangayo na nga tugotan tana nga magpatindug kang balay para sa Dios ni Jacob. ");
INSERT INTO krj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero si Solomon amo ang nagpatindug kang balay para sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ugaring ang Labing Mataas nga Dios wara nagaistar sa mga balay nga hinimoan kang tawo. Pareho kang ginkuon anay kang Dios paagi sa anang propeta, ");
INSERT INTO krj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ang langit amo ang akun trono, kag ang lupa turongtongan kang akun mga kahig. Gani ano nga klase ka balay ang inyo patindugun para kanakun? Ukon sa diin ako magapahuway? ");
INSERT INTO krj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ako kabay ang naghimo kang tanan nga mga butang nga dya?’ ");
INSERT INTO krj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mga awut gid kamo ti ulo. Pareho gid kamo kang mga tawo nga wara nakakilala sa Dios. Indi gid kamo magpati kag wara kamo nagapamati sa anang mga Pulong. Pirme lang ninyo ginabatoan ang Balaan nga Ispirito. Kon ano ang ginhimo kang inyo mga kaulangan, amo man ang inyo ginahimo. ");
INSERT INTO krj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sin-o lang bala nga propeta kauna nga wara ginhingabot kang inyo mga kaulangan? Ginpatay man gani nanda ang mga nagpanagna nahanungud kang pag-abot kang Matarung nga Surugoon kang Dios, nga inyo man tulad gintraidoran kag ginpatay. ");
INSERT INTO krj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo ang nagbaton kang Kasugoan kang Dios nga gintao paagi sa mga anghel, pero wara man ninyo dya pagtumana.” ");
INSERT INTO krj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagkabati ka dya kang mga katapo kang konseho nagkurudug sanda sa tuman nga kaugut kana. ");
INSERT INTO krj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero si Esteban nga nagamhan kang Balaan nga Ispirito, nagtangra sa langit kag nakita na ang himaya kang Dios nga nagasidlak kag nakita na man si Jesus nga nagatindug sa tuo kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nagkuon si Esteban, “Turuka ninyo! Makita ko nga bukas ang langit kag ang Anak kang Tawo nagatindug sa tuo kang Dios!” ");
INSERT INTO krj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Gintakpan nanda ang andang mga talinga kag magsinggit kang matunog kag nagdinagusu sanda tanan paagto kay Esteban. ");
INSERT INTO krj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Dayon gin-guyod nanda tana pagwa sa syudad kag rugto ginpurolihan ka libag ka bato. Ang mga testigo kontra kana ginbilin nanda ang andang panaptun sa sangka pamatan-un nga ginahingaranan kay Saul. ");
INSERT INTO krj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Samtang ginabato nanda si Esteban, nagpangamuyo tana sa Ginoo nga nagakuon, “Ginoong Jesus, batona ang akun ispirito!” ");
INSERT INTO krj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dayon nagluhod tana kag nagsinggit kang matunog, “Ginoo, indi sanda pagsukta kang sala nanda nga dya!” Sa tapos nga mahambal na dya, napatay tana. ");
INSERT INTO krj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nagpasugot man si Saulo sa pagpatay kay Esteban. Kang amo gid to nga adlaw, tuman gid ang paghingabot sa iglesia sa Jerusalem. Ang tanan nga mga tumuluo, magluwas sa mga apostoles, nagraplaag sa mga probinsya kang Judea kag Samaria. ");
INSERT INTO krj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Si Esteban tana, ginlubung kang mga tawo nga nagahigugma sa Dios kag ginhibian gid nanda tana ka mayad. ");
INSERT INTO krj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero si Saulo tana, nagahimurat gid nga laglagun ang iglesia. Nagapang-agto tana sa mga kabalayan kag ginapangguyod ang mga laki kag mga bayi kag isulud sa prisohan. ");
INSERT INTO krj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ang mga tumuluo tana nga nagraplaag nga to nakalambot sa bisan diin nga lugar nga nagapangwali ka Pulong kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nag-agto Felipe sa syudad kang Samaria kag rugto nagpanugid sa katawhan nahanungud kay Cristo. ");
INSERT INTO krj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kang mabatian kang duro nga mga tawo kag makita ang mga milagro nga ginapanghimo ni Felipe, nagpamati pa gid sanda kamayad sa anang ginapanghambal. ");
INSERT INTO krj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ang mga malaot nga ispirito nagasinggitan nga nagagwa halin sa mga tawo nga andang ginasab-an; kag duro man nga mga paralitiko kag mga piang ang nag-arayad. ");
INSERT INTO krj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Gani bahul gid ang kalipay kang mga katawhan sa syudad nga to. ");
INSERT INTO krj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","May sangka tawo rugto nga ginahingaranan kay Simon, nga buhay na run nga ginapadayaw ang mga taga-Samaria kang anang madyik. Ginapabugal na nga tana sangka tawo nga pinasahi, ");
INSERT INTO krj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","kag ginapamatian gid tana ka mayad kang tanan nga taga-Samaria, kubus man ukon dungganun. Kuon nanda, “Ang tawo nga dya amo ang gahum kang Dios nga ginatawag ‘Bahul nga Gahum.’” ");
INSERT INTO krj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lawid run nga tion nga ginapadayaw ni Simon ang mga tawo paagi sa anang madyik, gani nga nagapamati gid sanda ka mayad kana. ");
INSERT INTO krj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero kang magtoo sanda katong ginwali ni Felipe ang Mayad nga Balita nahanungud sa pagginahum kang Dios kag kay Jesu-Cristo, ginbawtisohan sanda—mga laki kag mga bayi. ");
INSERT INTO krj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati si Simon nagtoo man kag ginbawtisohan. Pagkatapos kato, nagsagad run tana ka imaw kay Felipe, kag natingala gid tana kang makita na ang mga katingalahan kag mga milagro nga nagakaratabo. ");
INSERT INTO krj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kang mabalitaan kang mga apostoles sa Jerusalem nga ginbaton kang mga taga-Samaria ang Pulong kang Dios, ginpaagto nanda sanday Pedro kag Juan rugto. ");
INSERT INTO krj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kang pag-abot nanda rugto, nagpangamuyo sanda para sa mga tumuluo nga mabaton nanda ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tungud hay kang amo to nga tion wara pa magkunsad ang Balaan nga Ispirito bisan kay sin-o kananda. Ginbawtisohan pa lang sanda sa ngaran ni Ginoong Jesus. ");
INSERT INTO krj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dayon gintungtong nanday Pedro kag Juan ang andang mga alima sa mga tumuluo kag nabaton nanda ang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kar-on, kang nakita ni Simon nga madyikero nga ang Balaan nga Ispirito gali ginatugro paagi sa pagtungtong kang alima kang mga apostoles, gin-alay-ayan na sanda kang kwarta ");
INSERT INTO krj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kag nagkuon, “Tugroi man ninyo ako ay kang gahum nga dya, agud to nga ang bisan sin-o nga tungtongan ko kang akun alima, makabaton kang Balaan nga Ispirito.” ");
INSERT INTO krj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pero ginsabat tana ni Pedro, “Kabay nga malaglag ikaw kaimaw kang imong kwarta sa impyerno, tungud hay naghuna-huna ikaw nga mabakal mo kang kwarta ang abilidad nga ginatugro kang Dios! ");
INSERT INTO krj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wara gid ikaw ti labut ukon bahin sa buruhatun nga dya, tungud hay bukun ti matarung ang imong panghuna-huna sa panuruk kang Dios! ");
INSERT INTO krj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hinulsuli ang malain nimo nga tuyo nga dya, kag magpangamuyo ikaw sa Ginoo nga kabay pa daad nga patawarun na ikaw sa malain nimo nga panghuna-huna. ");
INSERT INTO krj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tungud hay nakita ko nga tama gid ikaw ka mahisaun kag nagapos kang sala.” ");
INSERT INTO krj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nagsabat si Simon, “Pangamuyo kamo sa Ginoo para kanakun nga ang bisan ano sa inyo ginpanghambal indi matabo kanakun.” ");
INSERT INTO krj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kar-on, pagkatapos nga makapamatuod sanda nahanungud sa Ginoo kag makapanugid kang anang pulong, nagbalik sanda sa Jerusalem, nga nagapangwali kang Mayad nga Balita sa mga kabaryohanan kang Samaria. ");
INSERT INTO krj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sangka adlaw, may sangka anghel kang Ginoo nga nagkuon kay Felipe, “Panaw ikaw kag mag-agto sa bagatnan, sa dalan nga nagapadulhog halin sa Jerusalem paagto sa Gaza.” (Ang dalan nga dya wara run ginaagyan.) ");
INSERT INTO krj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gani nagpanaw tana kag nag-agto rugto. Sa dalan nga to, may sangka tawo nga mataas ang anang katungdanan sa Etiopia. Tana ka dya amo ang ginasarigan kang tanan nga manggad kang Kandake ukon rayna kang Etiopia. Nag-agto tana ka dya sa Jerusalem agud magsimba, ");
INSERT INTO krj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","kag tulad nagapauli run nga nagasakay sa anang karwahe kag nagabasa kang libro nga sinulat ni Propeta Isaias. ");
INSERT INTO krj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nagkuon ang Balaan nga Ispirito kay Felipe, “Parapit ikaw rugto kag magdungan sa karwahe.” ");
INSERT INTO krj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gani nagdalagan si Felipe parapit sa karwahe kag nabatian na ang tawo nga nagabasa kang libro nga sinulat ni Propeta Isaias. Ginpamangkot na dya, “Naintiendihan mo bala ang imong ginabasa?” ");
INSERT INTO krj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nagsabat ang opisyal, “Paano ko bay dya maintiendihan kon wara ti may magpaathag kanakun?” Dayon gin-agda na si Felipe nga magsakay sa karwahe kag magtupad kana. ");
INSERT INTO krj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Amo dyaay ang bahin kang kasulatan nga anang ginabasa: “Pareho kang karnero nga ginadara sa irihawan, Ukon pareho kang tinday kang karnero nga nagahipus lang kon ginaguntingan ang anang bulbol, wara gid tana nagalimug. ");
INSERT INTO krj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ginpakahuy-an tana kag bukun ti matarung ang paghusgar kana; Kag wara gid ti may makasugid nahanungud sa anang mga linahi, tungud hay gin-utas run ang anang kabuhi rugya sa lupa.” ");
INSERT INTO krj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Namangkot ang opisyal kay Felipe, “Sugidi ako kon sin-o ang ginatumud kang propeta nga dya. Ana bala kaugalingun ukon lain nga tawo?” ");
INSERT INTO krj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dayon ginsaysay ni Felipe sa opisyal nga dya ang Mayad nga Balita nahanungud kay Jesus umpisa sa bahin kang Kasulatan nga dya. ");
INSERT INTO krj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Samtang nagapadayon sanda sa andang dalanun, may naagyan sanda nga lugar nga may tubig, kag nagkuon ang opisyal, “May tubig dyaay! Ano pa ang nagapugung agud bawtisohan ako?” ");
INSERT INTO krj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nagsabat si Felipe, “Pwede run ikaw mabawtisohan kon nagatoo ikaw kay Jesus kang tuduk sa imong tagipusoon.” Nagkuon ang opisyal, “Huud, nagatoo ako nga si Jesu-Cristo amo ang anak kang Dios.” ");
INSERT INTO krj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nagsugo ang opisyal nga papundohon ang karwahe, kag naglusong sanda nga darwa ni Felipe sa tubig kag ginbawtisohan tana ni Felipe. ");
INSERT INTO krj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kang makatakas run sanda, hinali lang nga ginbuul si Felipe kang Ispirito kang Ginoo, kag wara run tana makita liwan kang opisyal, gani nagdiretso run lang tana sa anang dalanun nga malipayun. ");
INSERT INTO krj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Si Felipe tana, nasapwan na nga rugto run tana sa Azoto. Kag halin rugto nagpangwali tana kang Mayad nga Balita sa tanan nga kabanwahanan nga ana maagyan hasta nga makalambot tana sa Cesarea. ");
INSERT INTO krj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sa pihak nga bahin, si Saulo tana, wara gid ti untat ang anang pamahug nga pamatyun ang mga sumurunod kang Ginoo. Nag-agto tana sa Pinakamataas nga Pari ");
INSERT INTO krj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kag nagpangayo kang mga sulat nga magapakilala kana sa mga sinagoga sa Damasco. Agud to nga kon may makita tana nga mga sumurunod kang Dalan kang Ginoo, laki man ukon bayi, panggapuson na sanda kag dar-un sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Samtang nagapaagto tana kag nagahinamput sa Damasco, gulpi lang nga may nagkirab nga kasanag sa anang palibot nga naghalin sa langit. ");
INSERT INTO krj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nahulog tana sa lupa kag may nabatian tana nga limug nga nagkuon kana, “Saulo, Saulo, andut nga ginahingabot mo gid ako?” ");
INSERT INTO krj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nagsabat si Saulo, “Sin-o ikaw, Ginoo?” Nagkuon ang limug, “Ako si Jesus nga amo ang imo ginahingabot. ");
INSERT INTO krj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kar-on, tindug kag magsulud sa syudad kag rugto ikaw pagasugidan kon ano ang imo dapat himoon.” ");
INSERT INTO krj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ang mga kaimaw tana ni Saulo sa anang pagpanglakatun nagtirindug lang nga naurongan. Nabatian man nanda ang limug, pero wara sanda ti may nakita nga tawo. ");
INSERT INTO krj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nagtindug si Saulo kag pagmukra na, indi run tana makakita. Gani gindapit run lang nanda tana kag tuytoyan pasulud sa Damasco. ");
INSERT INTO krj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa sulud kang tatlo ka adlaw indi gid tana makakita, kag wara man tana magkaun ukon mag-inum kang bisan ano. ");
INSERT INTO krj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kar-on, rugto sa Damasco, may sangka sumurunod nga ginahingaranan kay Ananias. Sa paranan-awun naghambal ang Ginoo kana, “Ananias!” Nagsabat tana, “Ano daad, Ginoo?” ");
INSERT INTO krj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nagkuon ang Ginoo kana, “Mag-agto ikaw sa dalan nga ginatawag Matadlung, kag rugto sa balay ni Judas pamangkot ikaw parte sa tawo nga taga-Tarso nga ginahingaranan kay Saulo. Nagapangamuyo tana tulad kadya, ");
INSERT INTO krj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","sa paranan-awun may nakita tana nga tawo nga ginahingaranan kay Ananias, nga nagsulud kag nagtungtong kang anang alima kana para makakita tana liwan.” ");
INSERT INTO krj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nagsabat si Ananias, “Pero Ginoo, raku ang nagsugid kanakun parte sa tawo nga dya, nga ginapabudlayan na gid ka mayad ang mga nagatoroo kanimo sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Amo gani nga nag-abot tana rugya sa Damasco nga may awtoridad nga naghalin sa mga pangulo kang kaparian agud panggapuson ang tanan nga nagapanawag sa imong ngaran.” ");
INSERT INTO krj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero nagkuon ang Ginoo kana, “Panaw to, tungud hay ang tawo nga dya ginpili ko agud nga paagi kana mapakilala ko ang akun ngaran sa mga bukun ti Judio kag sa mga hari kag sa mga Israelenhun. ");
INSERT INTO krj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kag ipakita ko kana kon ano nga pag-antos ang anang pagaagumun tungud gid lang kang kanakun.” ");
INSERT INTO krj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Gani nagpanaw si Ananias kag mag-agto sa balay nga ginadayonan ni Saulo. Pagsulud na, gintungtongan na kang anang alima si Saulo kag nagkuon, “Saulo, bugto ko, ginpaagto ako ni Ginoong Jesus rugya kanimo. Tana amo ang nagpakita kanimo sa dalanun kang nagapaagto ikaw rugya. Ginsugo na ako kanimo agud to nga makakita ikaw liwan kag magamhan kang Balaan nga Ispirito.” ");
INSERT INTO krj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kag kato lagi nagkaradagdag halin sa mga mata ni Saulo ang daw mga himbis, kag makakita run tana liwan. Dayon, nagtindug tana kag nagpabawtiso. ");
INSERT INTO krj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nagkaun tana kag nagbalik ang anang kabaskug. Nagpakig-imaw tana kang mga pira ka adlaw sa mga sumurunod rugto sa Damasco. ");
INSERT INTO krj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nagpangwali tana dayon sa mga sinagoga nga si Jesus ang Anak kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ang tanan nga nakabati kana natingala gid kag nagkuon, “Indi bala nga amo man dya nga tawo ang nagpamatay sa Jerusalem kang mga nagapanawag sa ngaran ni Jesus? Kag amo man gani nga nag-agto tana rugya sa rason nga dar-un sanda nga nakagapos kag paatubangun sa mga pangulo kang kaparian.” ");
INSERT INTO krj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Si Saulo tana, mas nangin gamhanan pa gid ang anang pagpangwali, kag ang anang mga pagpamatuod nga si Jesus amo ang Cristo indi gid mahimutig gani ang mga Judio nga nagauli sa Damasco indi makasabat kana. ");
INSERT INTO krj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagkaligad kang duro nga mga inadlaw, naghumun ang mga Judio nga ipatyun nanda si Saulo. ");
INSERT INTO krj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero may nakasugid kana kang humun nanda nga dya. Adlaw kag gabii nagabantay ang mga Judio sa pwertahan kang syudad agud pag-agi na ka dya patyun nanda tana. ");
INSERT INTO krj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero sangka gabii, ginbuul si Saulo kang anang mga sumurunod kag ginbutang sa sangka kaing, dayon gintunton nanda dya paagi sa rulotsan sa pader. ");
INSERT INTO krj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kar-on, nag-agto si Saulo sa Jerusalem, kag gintinguhaan na nga magpakig-imaw sa mga disipulo rugto. Pero nahadluk sanda tanan kana tungud hay indi sanda magpati nga sangka sumurunod run man tana. ");
INSERT INTO krj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero gindara tana ni Bernabe sa mga apostoles kag ginsaysay kananda kon paano nagpakita ang Ginoo kay Saulo sa dalanun kag nagpakighambal kana, kag kon paano nagpangwali si Saulo nga may kaisug sa ngaran ni Jesus sa Damasco. ");
INSERT INTO krj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gani, nagpakig-imaw tana kananda bisan diin sanda mag-agto sa Jerusalem, kag may kaisug tana nga nagapangwali sa ngaran kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nagpakighambal tana kag nagpakigbais sa mga Judio nga nagahambal kang Griego, pero gintinguhaan nanda tana nga patyun. ");
INSERT INTO krj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kang maman-an dya kang mga tumuluo, gindara nanda tana sa Cesarea kag ginpapanaw pa Tarso. ");
INSERT INTO krj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gani, ang iglesia sa bilog nga Judea, kag Galilea, kag Samaria nakaagum kang kalinung; nagrig-un pa gid ang andang pagtoo. Tungud nga may kahadluk sanda sa Ginoo kag tungud sa bulig kang Balaan nga Ispirito, nagdugang pa gid ang andang kadurohon. ");
INSERT INTO krj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kar-on, si Pedro ruman tana, nagapang-agto sa nagkalain-lain nga mga lugar. Sangka bes, nagbisita tana sa mga tumuluo nga nagauli sa Lida. ");
INSERT INTO krj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Rugto nakilala na ang tawo nga ginahingaranan kay Eneas. Walo run dya ka tuig nga nagasagad lang ka batang tungud hay paralitiko tana. ");
INSERT INTO krj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nagkuon si Pedro kana, “Eneas, ginaayad ikaw ni Jesu-Cristo. Gani, bangon dyan kag himsun ang imong ginabatangan.” Kag lagi-lagi kato nagbangon si Eneas. ");
INSERT INTO krj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pagkatapos kato, nakita tana kang tanan nga taga-Lida kag taga-Saron, kag nagtoroo man sanda sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Rugto tana sa Jope, may sangka tumuluo man nga bayi nga ginahingaranan kay Tabita. (Ang ngaran na sa hambal nga Griego, Dorcas, nga kon sayudon, usa.) Tana ka dya, puro mayad ang anang ginahimo, kag mabinuligun tana sa mga imol. ");
INSERT INTO krj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kang tinion nga to, nagmasakit tana kag napatay. Ang anang bangkay ginsibinan nanda kag ginhaya sa ibabaw nga kwarto. ");
INSERT INTO krj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ang Jope indi gid man rayu sa Lida. Gani, pagkabati kang mga sumurunod sa Jope nga rugto si Pedro sa Lida, nagsugo sanda kang darwa ka laki nga mag-agto kana agud pangabayun nga mag-agto tana lagi kananda rugto sa Jope. ");
INSERT INTO krj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Naghimus lagi si Pedro kag nagtawas kananda. Pag-abot na rugto, gindara nanda tana sa ibabaw nga kwarto. Ginlibotan tana kang mga bayi nga balo nga nagahiribi kag ginapakita kana ang mga bayo kag mga kunup nga tinahian ni Dorcas kang buhi pa tana. ");
INSERT INTO krj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ginpagwa sanda tanan ni Pedro. Dayon, nagluhod tana kag nangamuyo, kag nag-atubang tana sa bangkay kag nagkuon, “Tabita, bangon ikaw!” Nagmukra si Tabita kag pagkakita na kay Pedro nagpungko tana sa anang ginabatangan. ");
INSERT INTO krj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ginkaptan tana ni Pedro sa anang alima kag ginbuligan sa pagtindug. Dayon, ginpanawag ni Pedro ang mga tumuluo kag ang mga bayi nga balo kag ginpakita na si Tabita kananda nga buhi run. ");
INSERT INTO krj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ang natabo nga dya nabalahuba sa bilog nga Jope, kag duro ang nagtoroo sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nagtiner si Pedro kang malawid nga mga inadlaw sa Jope, kag rugto tana nagdayon kay Simon nga manuglugum kang panit ka sapat. ");
INSERT INTO krj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Rugto sa Cesarea, may sangka tawo nga ginahingaranan kay Cornelio. Tana kadya sangka kapitan kang batalyon kang mga suldado Romanhun nga ginatawag Batalyon Italyano. ");
INSERT INTO krj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tana ka dya diosnon, kag ang anang bug-os nga panimalay nagasimba sa Dios. Pirme tana nagatugro kang bulig sa mga imol nga tawo kag pirme man tana nagapangamuyo sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sangka adlaw, kang mga alas tres ti hapon, nakita na kang maathag sa anang paranan-awun ang anghel kang Dios nga nag-abot kag naghambal kana, “Cornelio!” ");
INSERT INTO krj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Sa anang kahadluk, ginturuk na ka mayad ang anghel kag nagsabat, “Ano raad, Ginoo?” Nagkuon ang anghel kana, “Nahamuut ang Dios sa imong mga pangamuyo kag pagbulig sa mga imol, kag wara na gid ikaw nalipatan. ");
INSERT INTO krj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gani kar-on, magsugo ikaw kang pira ka mga laki nga mag-agto sa Jope kag ipaabat ang sangka tawo nga ginahingaranan kay Simon nga ginatawag man Pedro. ");
INSERT INTO krj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nagadayon tana kay si Simon nga manuglugum kang panit ka sapat, nga ang balay na ka dya sa binit kang baybay.” ");
INSERT INTO krj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pagkahalin kang anghel nga nagpakighambal kana, nagtawag tana kang darwa na ka bulig kag sangka suldado nga diosnon nga isara sa mga nagaalagad kana. ");
INSERT INTO krj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ginsugid na kananda ang tanan nga natabo, kag pagkatapos ginpapanaw na sanda sa Jope. ");
INSERT INTO krj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagkasunod nga adlaw, samtang nagapanaw sanda kag nagahinamput sa Jope, si Pedro tana nagsaka sa tapan nga atup agud magpangamuyo; mga udto adlaw kato. ");
INSERT INTO krj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Gin-gutum tana kag gusto na raad magkaun. Samtang ginahimus ang pagkaun, may nakita tana nga paranan-awun. ");
INSERT INTO krj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nakita na nga nagbukas ang langit kag may butang nga nagapapanaog nga daw sangka malapad nga kapay nga ginahigtan sa apat ka pamusod kag ginatunton sa lupa. ");
INSERT INTO krj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nabutang rugto ang tanan nga sahi kang sapat, pareho kang mga sapat nga nagaparanaw, mga nagakaramang, kag mga pispis. ");
INSERT INTO krj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dayon, may nabatian tana nga limug nga nagkuon kana, “Tindug Pedro, ihaw kag magkaun!” ");
INSERT INTO krj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero nagsabat si Pedro, “Indi gid mahimo, Ginoo! Wara pa gid ako makakaun kang bisan ano nga suno sa amun relihiyon indi dapat kan-un ukon mahigku.” ");
INSERT INTO krj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ang limug nga to naghambal liwan kay Pedro sa ikarwa nga bes nga nagakuon, “Indi pagkabiga nga mahigku ang bisan ano nga butang nga ginlimpyohan run kang Dios.” ");
INSERT INTO krj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tatlo gid dya ka beses natabo kag ang bagay nga to ginbatak lagi pabalik sa langit. ");
INSERT INTO krj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Samtang nagapalibug pa si Pedro kon ano ang buut hambalun kang paranan-awun nga to, ang mga tawo tana nga ginsugo ni Cornelio, sa anda nga pagpuropamangkot, nakita nanda ang balay ni Simon kag nagatindug sanda sa pwertahan kang kudal. ");
INSERT INTO krj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nagpanawag sanda kag namangkot kon may nagadayon rugto nga tawo nga ginahingaranan kay Simon nga ginatawag man nga Pedro. ");
INSERT INTO krj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Samtang ginapaino-ino pa gid ni Pedro ang nahanungud sa paranan-awun nga to, ang Balaan nga Ispirito nagkuon kana, “May tatlo ka laki nga nagasagap kanimo. ");
INSERT INTO krj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Panaog rugto, kag indi magpangalag-ag magtawas kananda tungud hay ako ang nagsugo kananda.” ");
INSERT INTO krj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Gani nagpanaog si Pedro kag nagkuon sa mga tawo, “Ako ang inyo ginapangita. Ano raad haw ang kinahanglan ninyo?” ");
INSERT INTO krj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nagsabat sanda, “Ginsugo kami rugya ni Kapitan Cornelio. Mayad tana nga tawo kag nagasimba sa Dios, kag ginatahod kang tanan nga mga Judio. Ginkun-an tana kang anghel kang Dios nga ipaabat ikaw nga mag-agto sa anang balay, agud to nga makabati tana kon ano ang imo ihambal.” ");
INSERT INTO krj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dayon gin-agda sanda ni Pedro nga magsulud sa balay kag rugto na sanda ginpaturog kang gabii nga to. Pagkaaga, naghimus si Pedro kag nagtawas kananda. Ang iba nga mga tumuluo nga taga-Jope nag-imaw man kana. ");
INSERT INTO krj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkasunod pa gid nga adlaw, nag-abot sanda sa Cesarea. Ginapaabot sanda ni Cornelio, imaw kang anang mga himata kag kang anang suud nga mga amigo nga ana ginpang-agda. ");
INSERT INTO krj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kang manugsulud run si Pedro sa balay, ginsug-alaw tana ni Cornelio kag nagluhod sa anang atubang sa pagsimba kana. ");
INSERT INTO krj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ginpatindug tana ni Pedro kag ginkun-an, “Tindug, tungud hay tawo lang man ako.” ");
INSERT INTO krj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Padayon si Pedro nga nagaistorya kay Cornelio samtang nagapasulud sanda sa balay, kag nakita na ang duro nga mga tawo nga nagtiripon. ");
INSERT INTO krj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nagkuon si Pedro kananda, “Kamo mismo nakamaan nga kami nga mga Judio ginadumilian kang amun relihiyon nga magpakig-angut ukon magbisita sa mga bukun ti Judio. Pero ginpakita kang Dios kanakun nga indi ko dapat pagkabigun ang bisan sin-o nga tawo nga mahigku ukon indi dapat pagpakig-angutan. ");
INSERT INTO krj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gani nga kang ginpaabat mo ako, nag-abot ako nga wara run ti pamaribad. Kar-on gusto ko maman-an kon andut nga ginpaabat mo ako.” ");
INSERT INTO krj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nagsabat si Cornelio, “Apat run ka adlaw kadya, amo man kadya nga oras, mga alas tres ti hapon; nagapangamuyo ako sa balay kag gulpi lang nga may sangka laki nga nagtindug sa akun atubang nga nagasuksok ka bayo nga makasirilaw ");
INSERT INTO krj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kag nagkuon kanakun, ‘Cornelio, ginpamatian kang Dios ang imong pangamuyo kag nakita na ang imong pagbulig sa mga imol. ");
INSERT INTO krj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Gani, magsugo ikaw kang pira ka tawo sa Jope kag ipaabat ang sangka tawo nga ginahingaranan kay Simon nga ginatawag man Pedro. Nagadayon tana ka dya sa balay ni Simon nga manuglugum kang panit ka sapat, nga nagaistar sa binit kang baybay.’ ");
INSERT INTO krj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Amo ria nga ginpaabat ko ikaw lagi kag mayad man nga nagtawas ikaw. Kar-on, rugya kami tanan sa presensya kang Dios, nagahulat sa pagpamati kang tanan nga ginkuon kang Ginoo kanimo nga imo ihambal kanamun.” ");
INSERT INTO krj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dayon nag-umpisa si Pedro sa paghambal, “Kadya nasiguro ko run nga matuod gid man nga ang Dios wara ti may ginapasulabi. ");
INSERT INTO krj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ang bisan sin-o nga nagakahaduk kana kag nagahimo kang mayad, ginabaton na bisan ano pa ang andang lahi. ");
INSERT INTO krj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nakamaan man kamo kang mensahe kang Dios para sa mga katawhan kang Israel nga nagapahayag kang Mayad nga Balita nga ang tawo makapasag-uli run kana paagi kay Jesu-Cristo nga amo ang Ginoo kang tanan. ");
INSERT INTO krj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nakamaan man kamo kon ano ang natabo anay sa bilog nga probinsya kang Judea. Nag-umpisa dya sa banwa kang Galilea pagkatapos nga magpangwali si Juan nahanungud sa pagbawtiso. ");
INSERT INTO krj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kag nakamaan man kamo nahanungud kay Jesus nga taga-Nazaret nga gintaw-an kang Dios kang Balaan nga Ispirito kag gahum. Tungud hay ang Dios kaimaw na, nagpang-agto tana sa nagkalain-lain nga mga lugar nga nagahimo kang mayad sa katawhan kag nagapang-ayad kang mga tawo nga nasab-an kang yawa. ");
INSERT INTO krj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kami mismo nakakita gid kang tanan nga anang hinimoan sa mga lugar kang mga Judio kag amo man sa Jerusalem. Pagkatapos ginpatay nanda tana paagi sa paglansang kana sa kros. ");
INSERT INTO krj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero ginbanhaw tana kang Dios sa ikatlo nga adlaw, kag ginpakita tana kanamun. ");
INSERT INTO krj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bukun ti tanan nga tawo ang nakakita kana, kundi kami lang nga ginpili run nga daan kang Dios bilang manugpamatuod. Nagpakig-imaw kami kana sa pagkaun kag pag-inum sa tapos nga mabanhaw tana. ");
INSERT INTO krj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ginsugo na kami nga magpangwali sa mga katawhan, kag sa pagpamatuod nga tana amo ang gintangdu kang Dios nga maghusgar sa tanan nga mga tawo, buhi man ukon patay. ");
INSERT INTO krj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ang tanan nga mga propeta nagpamatuod man nahanungud kana, nga ang sin-o man nga magatoo kana pagapatawarun ang andang mga sala paagi sa anang ngaran.” ");
INSERT INTO krj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Samtang nagahambal pa si Pedro nagkunsad ang Balaan nga Ispirito sa tanan nga nagapamati sa anang mensahe. ");
INSERT INTO krj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Natingala gid ang mga tumuluo nga mga Judio nga nagtarawas kay Pedro, tungud hay nakita nanda nga gintugro man kang Dios ang Balaan nga Ispirito sa mga bukun ti Judio. ");
INSERT INTO krj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tungud hay nabatian nanda nga ang mga tawo nga dya nagharambal kang lain nga sahi kang mga linggwahe kag nagadayaw sa Dios. Nagkuon si Pedro, ");
INSERT INTO krj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Dya nga mga tawo pareho run man kanatun nga nakabaton kang Balaan nga Ispirito. Sin-o pa ang makapugung nga bawtisohan sanda sa tubig?” ");
INSERT INTO krj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gani nagsugo tana nga bawtisohan sanda sa ngaran ni Jesu-Cristo. Dayon ginpangabay nanda si Pedro nga magpabilin anay kananda kang pira ka adlaw. ");
INSERT INTO krj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kar-on, ang mga apostoles kag ang iba pa gid nga mga tumuluo sa bilog nga Judea, nakabati nga ang mga bukun ti Judio nagbaton man kang Pulong kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Gani kang magtukad si Pedro sa Jerusalem, ginsukmaan tana kang mga tumuluo nga mga Judio. Nagkuon sanda kana, ");
INSERT INTO krj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Andut nga nag-agto ikaw sa balay kang mga bukun ti Judio kag nagpakig-imaw kaun kananda?” ");
INSERT INTO krj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Amo to kag ginsaysay ni Pedro kananda ang tanan nga natabo halin sa umpisa. ");
INSERT INTO krj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Nagkuon tana, “Kang rugto ako sa Jope, sangka tion nga nagapangamuyo ako, may nakita ako nga paranan-awun. May nakita ako nga sangka butang nga daw sangka malapad nga kapay nga ginahigtan sa apat ka pamusod nga ginatunton halin sa langit, kag sa atubang ko gid nagtupa. ");
INSERT INTO krj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ginmulalungan ko gid dya kag nakita ko rugto ang nagkalain-lain nga sahi kang mga sapat, ang mga nagaparanaw kag ang mga mapintas nga sapat, ang mga nagakaramang, kag ang mga pispis. ");
INSERT INTO krj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dayon, may nabatian ako nga limug nga nagkuon kanakun, ‘Tindug Pedro, ihaw kag magkaun.’ ");
INSERT INTO krj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero nagsabat ako, ‘Indi gid mahimo, Ginoo! Wara pa gid ako makakaun kang bisan ano nga suno sa amun relihiyon indi dapat kan-un ukon ginadumilian.’ ");
INSERT INTO krj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kag sa ikarwa nga bes naghambal ruman ang limug nga to nga naghalin sa langit, ‘Indi pagkabiga nga mahigku ang bisan ano nga butang nga ginlimpyohan run kang Dios.’ ");
INSERT INTO krj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tatlo gid dya ka beses natabo kag pagkatapos, ang bagay nga to ginbatak pabalik sa langit. ");
INSERT INTO krj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kang amo man to nga tion nag-abot sa balay nga akun gindayonan ang tatlo ka laki nga ginpaagto kanakun nga naghalin sa Cesarea. ");
INSERT INTO krj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nagkuon man kanakun ang Balaan nga Ispirito nga magtawas ako kananda kag indi magpangalag-ag. Nag-imaw man kanakun ang anum ka mga isigka-tumuluo nga dya, kag nagsulud kami sa balay kang tawo nga si Cornelio. ");
INSERT INTO krj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ginsaysay na kanamun nga nakakita tana kang anghel nga nagatindug sa sulud kang anang balay, kag nagkuon dya kana, ‘Pasugo ikaw sa Jope kag ipaabat ang tawo nga ginahingaranan kay Simon Pedro. ");
INSERT INTO krj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Magahambal tana kanimo kang mga pulong nga amo ang mangin paraagyan nga ikaw kag ang bug-os mo nga panimalay maluwas.’ ");
INSERT INTO krj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nagaumpisa pa lang ako sa paghambal, kang ang Balaan nga Ispirito nagkunsad run kananda pareho kang pagkunsad na ka dya kanatun kauna. ");
INSERT INTO krj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kag nadumduman ko ang ginkuon anay kang Ginoo nga, ‘Si Juan nagbawtiso sa tubig, pero kamo pagabawtisohan sa Balaan nga Ispirito.’ ");
INSERT INTO krj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kar-on kon ang Dios nagtugro sa mga bukun ti Judio kang pareho nga regalo nga anang gintugro kanatun kang kita magtoo kay Ginoong Jesu-Cristo, sin-o gid takun nga magapamalabag sa pagbuut kang Dios?” ");
INSERT INTO krj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kang mabatian dya kang mga tumuluo nga mga Judio, nagpuut sanda ka sukma kana kag nagdayaw sa Dios nga nagakuon, “Kon amo, ang Dios nagatugro run man sa mga bukun ti Judio kang kahigayonan sa paghinulsul agud to nga makaangkun man sanda kang kabuhi nga wara ti katapusan!” ");
INSERT INTO krj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kar-on, ang mga tumuluo nga nagrinaplaag tungud kang paghingabot nga natabo katong ginpatay si Esteban, nakadangat hasta sa Fenicia, Cipro kag Antioquia nga nagapanugid kang mensahe nahanungud kay Cristo pero sa mga Judio lang. ");
INSERT INTO krj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero ang iba kananda nga mga taga-Cipro kag taga-Cirene, nag-agto sa Antioquia kag nagpanugid man sa mga bukun ti Judio, nga nagawali kananda kang Mayad nga Balita nahanungud kay Ginoong Jesus. ");
INSERT INTO krj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ang Ginoo nagtao kananda kang gahum, kag duro gid nga mga tawo ang nagtoroo kag nagsunod sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ang natabo nga dya nabalitaan kang iglesia sa Jerusalem, gani ginpaagto nanda si Bernabe sa Antioquia. ");
INSERT INTO krj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kang pag-abot na rugto kag nakita na kon daw ano ka mayad ang Ginoo sa mga tawo rugto nalipay gid tana. Ginlaygayan na sanda tanan nga magmatutum kag tuduk sa tagipusoon ang pagsunod sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Bernabe nga dya mayad nga tawo. Nagamhan tana kang Balaan nga Ispirito kag marig-un ti pagtoo, gani duro gid nga mga tawo ang anang nadara nga magtoo sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dayon nag-agto si Bernabe sa Tarso agud pangitaun si Saulo. ");
INSERT INTO krj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kang makita na dya gindara na dya sa Antioquia, kag sa bilog nga tuig nagpakig-imaw sanda sa mga katapo kang iglesia kag nagpanudlo sa duro gid nga mga tawo. Rugya sa Antioquia una nga gintawag nga Cristohanun ang mga disipulo. ");
INSERT INTO krj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kang mga inadlaw man nga to, may mga propeta nga nagdurulhog sa Antioquia halin sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ang isara kananda ginahingaranan kay Agabo. Nagtindug tana kag paagi sa gahum kang Balaan nga Ispirito nagpanagna nga magaabot ang sobra nga kagutum sa bilog nga kalibutan. (Natabo dya katong si Claudio amo ang emperador.) ");
INSERT INTO krj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Gani ang mga gintuton-an nagpamat-ud nga suno sa masarangan kang kada isara kananda magapadara ka bulig sa mga isigka-tumuluo nga nagaistar sa Judea. ");
INSERT INTO krj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Amo gid dya ang andang ginhimo kag ginpadara nanda ang andang bulig sa mga kamal-aman sa iglesia paagi kanday Bernabe kag Saulo. ");
INSERT INTO krj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kang amo man dya nga mga tinion, ang iba nga mga katapo kang iglesia ginhingabot ni Haring Herodes. ");
INSERT INTO krj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ginpapatay na paagi sa espada si Santiago nga bugto ni Juan. ");
INSERT INTO krj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kang makita ni Herodes nga nalipay ang mga Judio sa anang ginhimo, ginpadakup na man si Pedro. (Natabo dya katong Pista kang Tinapay nga Wara ti Tapay.) ");
INSERT INTO krj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagkatapos nga mapadakup na si Pedro, ginpapriso na dya kag gintugyan para gwardyahan kang apat ka hubun kang mga suldado nga kada hubun may apat ka suldado. Ang tuyo ni Herodes, pagapaatubangun na sa mga katawhan si Pedro pagkaligad kang Pista kang Paglampuwas. ");
INSERT INTO krj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gani si Pedro ginabantayan sa prisohan; pero ang mga katapo kang iglesia nagapangamuyo gid sa Dios kang hugut sa andang tagipusoon para kana. ");
INSERT INTO krj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kang gabii antes paatubangun ni Herodes si Pedro sa katawhan, nagakaturog tana sa tunga kang darwa ka suldado. Nagapos tana kang darwa ka kadena kag may mga gwardya man nga nagabantay sa pwertahan kang prisohan. ");
INSERT INTO krj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hinali lang nga may nagtuhaw nga anghel kang Ginoo kag nagsanag ang sulud kang selda. Gintapik kang anghel sa kilid si Pedro kag pukawun nga nagakuon, “Dali, bangon!” Lagi-lagi kato, nagkarahukas ang mga kadena sa alima ni Pedro. ");
INSERT INTO krj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nagkuon pa gid ang anghel kana, “Iwagkus ang imong paha kag isuksok ang imo sandalyas.” Ginhimo man dya ni Pedro kag nagkuon pa gid ang anghel kana, “Isuksok ang imong kunup kag magsunod kanakun.” ");
INSERT INTO krj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nagsunod si Pedro sa anghel paggwa sa prisohan. Pero wara tana kamaan nga ang ginahimo kang anghel matuod. Abi na nga nakakita lang tana kang paranan-awun. ");
INSERT INTO krj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ginlubsan nanda ang primero nga grupo kang mga gwardya, kag amo man ang Ikarwa, kag nag-abot sanda sa salsalun nga pwertahan nga aragyan paagto sa syudad. Nagbukas lang dya kang ana para kananda, kag naggwa sanda. Nagpanaw sanda sa sangka kalye, kag hinali lang nga ginbayaan kang anghel si Pedro. ");
INSERT INTO krj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dayon nakamaradmad si Pedro sa natabo kana, kag nagkuon, “Kadya nasiguro ko run gid nga ang Ginoo nagsugo kang anang anghel, kag naghilway kanakun sa gahum ni Herodes kag sa tanan nga ginapaabot kang mga Judio nga matabo kanakun.” ");
INSERT INTO krj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kang matalupangdan dya ni Pedro, nag-agto tana sa balay ni Maria nga nanay ni Juan nga ginatawag man nga Marcos, nga sa diin duro nga mga tawo ang nagtiripon kag nagapangamuyo. ");
INSERT INTO krj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nanuktok si Pedro sa gwa nga pwertahan, kag ang surugoon nga si Roda naggwa sa paglantaw kon sin-o dya. ");
INSERT INTO krj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nakilala na ang limug ni Pedro kag sa sobra na nga kakunyag, nagdalagan tana pabalik sa sulud nga wara na mabuksan ang pwertahan, kag nagkuon kananda nga si Pedro rugto sa gwa nagatindug. ");
INSERT INTO krj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nagkuon sanda kana, “Umang-umang kaw!” Pero nagpamirit tana nga si Pedro gid to. Kag nagkuon sanda, “Anang anghel ria!” ");
INSERT INTO krj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero si Pedro tana sige ang anang panuktok, kag kang buksan nanda ang pwertahan nakita nanda tana kag natingala gid sanda. ");
INSERT INTO krj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ginsenyasan na sanda nga maghipus kag dayon ginsaysay na kananda kon ano ang ginhimo kang Ginoo sa pagpagwa kana sa prisohan. Kag nagkuon pa gid tana kananda, “Isugid ninyo dya kay Santiago kag sa iba pa nga mga isigka-tumuluo.” Pagkatapos, naghalin tana kag mag-agto sa lain nga lugar. ");
INSERT INTO krj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagkaaga, sobra gid ang pagkinaran-karan kang mga gwardya tungud hay indi nanda maman-an kon ano ang natabo kay Pedro. ");
INSERT INTO krj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nagsugo si Herodes nga sagapun tana pero wara gid nanda tana makita. Gani ginpaimbistigar na ang mga gwardya kag pagkatapos nagsugo tana nga pamatyun sanda. Dayon, naghalin tana sa Judea kag mag-agto sa Cesarea kag rugto tana nagtiner. ");
INSERT INTO krj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kar-on, sobra gid ang kaugut ni Herodes sa mga taga-Tiro kag taga-Sidon. Gani nagbuylog sanda sa pagpakigkita kana. Primero ginhaylo nanda si Blasto nga mayordomo kang hari agud magbulig kananda. Dayon, nag-agto sanda kay Herodes agud magpakigsag-uli kana, tungud hay sa lugar kang hari nagabuul kang pagkaun ang andang pungsod. ");
INSERT INTO krj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pag-abot kang gintalana nga adlaw, nagsuksok si Herodes kang anang harianun nga bayo, kag nagpungko sa anang trono kag nagpamulong-pulong sa katawhan. ");
INSERT INTO krj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Naghinugyaw ang mga tawo, “Bukun ti tawo ang nagahambal nga ria, kundi dios!” ");
INSERT INTO krj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lagi-lagi gintugroan kang anghel kang Ginoo si Herodes kang balatian tungud hay wara na ginpadunggan ang Dios. Gin-uk-uk tana kang ulod kag napatay. ");
INSERT INTO krj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero ang pulong kang Dios padayon pa gid nga naglapnag kag nagduro pa gid ang mga nagtoroo. ");
INSERT INTO krj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sa pihak tana nga bahin, natapos run nanday Bernabe kag Saulo ang andang hirikoton. Nagbalik sanda halin sa Jerusalem nga dara si Juan nga ginatawag man Marcos. ");
INSERT INTO krj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Rugto tana sa iglesia sa Antioquia, may mga propeta kag mga manunudlo nga amo sanday Bernabe, Simeon nga gintawag nga Negro, Lucio nga taga-Cirene, Saulo, kag si Manaen nga ginpabahul imaw ni Herodes nga gobernador. ");
INSERT INTO krj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Samtang nagasimba sanda sa Ginoo kag nagapuasa, naghambal ang Balaan nga Ispirito, “Paina ninyo si Bernabe kag si Saulo para kanakun. Ginpili ko sanda para sa hirikoton nga akun gintigana kananda.” ");
INSERT INTO krj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Dayon, pagkatapos nanda ka puasa kag pangamuyo, gintungtong nanda ang andang mga alima kay Bernabe kag Saulo, kag ginpapanaw sanda. ");
INSERT INTO krj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Si Bernabe kag si Saulo nga ginsugo kang Balaan nga Ispirito, nag-agto sa Seleucia. Halin rugto nagpanakayun sanda paagto sa Cipro. ");
INSERT INTO krj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pagkaabot nanda sa Salamina, ginpangwali nanda ang pulong kang Dios sa mga sinagoga kang mga Judio. Kaimaw nanda si Juan Marcos bilang manugbulig nanda. ");
INSERT INTO krj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ginlibot nanda ang bilog nga isla hasta nga makadangat sanda sa Pafos. May nakita sanda rugto nga sangka madyikero nga ginahingaranan kay Bar-Jesus. Sangka Judio tana ka dya nga nagapakuno-kuno nga propeta kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo tana kang gobernador nga si Sergio Paulo nga sangka maaram nga tawo. Ginpatawag kang gobernador nga dya si Bernabe kag si Saulo tungud hay gusto na mabatian ang Pulong kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero ginbalabagan sanda ni Elimas nga madyikero (amo dya ang anang ngaran sa Griego). Gintinguhaan na nga punggan ang gobernador agud indi magtoo. ");
INSERT INTO krj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Si Saulo tana nga ginatawag man nga Pablo, nagamhan kang Balaan nga Ispirito. Ginturuk na kang tampad ang madyikero ");
INSERT INTO krj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kag ginkun-an, “Ikaw nga bata kang yawa! Kaaway ikaw kang tanan nga matarung. Rugyan kanimo ang tanan nga pagkadayaun kag pagpangloko. Indi gid ikaw haw magpuut sa pagpatiko kang kamatuoran nahanungud sa Ginoo? ");
INSERT INTO krj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kar-on, silotan ikaw kang Ginoo. Mabulag ikaw kang pira ka adlaw kag indi mo makita ang sirak kang adlaw.” Lagi-lagi kato nagdulum ang anang panuruk, kag indi run gid tana makakita. Nagpangapkap tana nga nagasagap kang magadapit kana. ");
INSERT INTO krj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kang makita kang gobernador ang natabo nga dya, nagtoo tana tungud hay natingala gid tana sa mga ginapanudlo nahanungud sa Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kar-on, halin sa Pafos, si Pablo kag ang anang mga kaimaw nagpanakayun hasta sa Perga nga sakup kang Panfilia. Ginbayaan sanda rugto ni Juan Marcos kag nagbalik tana sa Jerusalem. ");
INSERT INTO krj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Halin sa Perga, nagpadayon sanda kag nag-abot sa Antioquia nga sakup kang Pisidia. Kang Adlaw nga Inugpahuway nag-agto sanda sa sinagoga kag nagpungko rugto. ");
INSERT INTO krj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pagkatapos nga mabasa ang pira ka bahin kang Kasugoan ni Moises kag mga sinulat kang mga propeta, ang mga manugdumara kang sinagoga nagpasugo kanday Pablo nga nagakuon, “Mga kabugtoan, kon may inughambal kamo sa katawhan para sa kaaraydan nanda, hambal lang kamo.” ");
INSERT INTO krj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Gani, nagtindug si Pablo kag nagsenyas, kag nagkuon: “Mga kapareho ko nga mga Israelenhun, kag kaninyo man nga mga bukun ti Judio nga nagasimba sa Dios, pamatii ninyo ako. ");
INSERT INTO krj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ang Dios natun nga mga Israelenhun amo ang nagpili kang atun mga kaulangan, kag ginpauswag na samtang mga pangayaw sanda sa Ehipto, kag paagi sa anang wara ti tupung nga gahum ginpagwa na sanda sa Ehipto. ");
INSERT INTO krj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sa sulud kang mga kap-atan ka tuig, ginbatas na sanda rugto sa kamingawan. ");
INSERT INTO krj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pagkatapos nga ginpierde na ang pito ka nasyon sa Canaan, gintugro na ang andang mga lupa sa atun mga kaulangan bilang anda run gid ");
INSERT INTO krj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","sa sulud kang mga 450 ka tuig.” Pagkatapos ka dya, gintugroan sanda kang Dios kang mga manughukum nga amo ang magadumara kananda hasta sa tion ni Samuel nga propeta. ");
INSERT INTO krj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Dayon nagpangayo sanda nga taw-an sanda kang hari, kag ang gintugro kananda amo si Saulo nga bata ni Kis nga naghalin sa tribo ni Benjamin. Naghari si Saulo kananda sa sulud kang 40 ka tuig. ");
INSERT INTO krj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kang ginbuul kang Dios si Saulo bilang andang hari, si David amo ang anang ginbulus. Amo dya ang ginkuon kang Dios nahanungud kay David, “Nakita ko nga si David nga bata ni Jesse amo gid ang tawo nga akun nahamut-an. Magatuman tana kang tanan nakun nga kabubut-un.” ");
INSERT INTO krj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kag sa linahi ni David nga dya maghalin si Jesus nga amo ang Manluluwas kang Israel nga ginsaad kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sa wara pa tana mag-abot, nagpangwali run nga daan si Juan sa tanan nga mga Israelenhun nga maghinulsul sanda kag magpabawtiso. ");
INSERT INTO krj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kang nagahingapos run ang hirikoton ni Juan, nagkuon tana sa katawhan, “Sin-o ako para kaninyo? Bukun ti ako ang Cristo nga inyo ginapaabot. Pero magaabot tana sunod kanakun; indi ako takus sa paghubad kang higot kang anang sandalyas.” ");
INSERT INTO krj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nagpadayon pa gid si Pablo, “Mga kabugtoan, kamo nga mga linahi man ni Abraham, kag kamo nga mga bukun ti Judio nga nagasimba sa Dios, kanatun ginpamaan ang mensahe nga dya nahanungud sa kaluwasan. ");
INSERT INTO krj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ang mga katawhan sa Jerusalem kag ang andang mga manugdumara wara makakilala nga si Jesus amo ang Manluluwas kag wara man nanda mahangpi ang mga sinulat kang mga propeta nga ginabasa kada Adlaw nga Inugpahuway. Pero gintuman nanda ang mga gintagna kang mga propeta kang ginsentensyahan nanda tana kang kamatayun. ");
INSERT INTO krj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan pa nga wara sanda ti nakita nga kabangdanan nga dapat tana sentensyahan kang kamatayun, ginpangayo pa gihapon nanda kay Pilato nga ipapatay tana. ");
INSERT INTO krj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pagkatapos nga mahimo nanda kana ang tanan nga nasulat sa Kasulatan nahanungud kana, ginbuul nanda ang anang lawas sa kros kag ginlubung. ");
INSERT INTO krj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero ginbanhaw tana kang Dios, ");
INSERT INTO krj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kag sa sulud kang duro nga mga inadlaw nagpakita tana sa mga tawo nga nag-imaw kana kato anay kang mag-agto tana sa Jerusalem halin sa Galilea. Sanda run ka dya ang nagapamatuod nahanungud kana sa mga Israelenhun. ");
INSERT INTO krj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kag rugya kami nga nagasugid kaninyo kang Mayad nga Balita, nga ang ginsaad kato anay kang Dios sa atun mga kaulangan ");
INSERT INTO krj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","gintuman na run kanatun nga andang mga linahi paagi sa pagbanhaw kay Jesus. Pareho kang nasulat sa ikarwa nga Salmo: ‘Ikaw ang akun Anak, kadya nga adlaw nangin Amay mo ako.’ ");
INSERT INTO krj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kon parte sa pagbanhaw kang Dios kana kag indi run madunot ang anang lawas, amo dya ang ginkuon kang Dios, ‘Itugro ko kaninyo ang balaan kag masarigan gid ninyo nga pagpakamayad nga akun ginsaad kay David kato anay.’ ");
INSERT INTO krj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Kag ginakuon man sa isara pa gid nga bahin kang Kasulatan, ‘Indi mo pag-itugot nga madunot ang lawas kang imo Balaan nga Surugoon.’ ");
INSERT INTO krj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Si David tana, kang buhi pa tana, gintuman na ang ginapahimo kang Dios kana. Pagkatapos napatay tana kag ginlubung sa rulubngan kang anang mga kamal-aman kag nadunot ang anang lawas. ");
INSERT INTO krj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero si Jesus tana nga ginbanhaw kang Dios, wara gid madunot ang anang lawas. ");
INSERT INTO krj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Gani mga kabugtoan, dapat ninyo maman-an nga paagi kay Jesus ginawali run kaninyo kadya nga ang Dios nagapatawad kang mga sala. ");
INSERT INTO krj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kag ang bisan sin-o nga nagatoo kana sarang mapatawad sa tanan na nga kasal-anan, nga sa pagtuman kang Kasugoan ni Moises indi kamo mapatawad. ");
INSERT INTO krj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gani, mag-andam kamo agud nga indi matabo kaninyo ang ginhambal kang mga propeta: ");
INSERT INTO krj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Pamati kamo nga mga nagayaguta. Magkatingala kamo kag magkaramatay! Tungud hay may pagahimoon ako sa inyo nga panahon; nga indi gid ninyo pagpatihan bisan pa nga may magpaathag ka dya kaninyo!’” ");
INSERT INTO krj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kang nagapagwa run sa sinagoga sanday Pablo kag Bernabe, ginpangabay sanda kang mga tawo nga magbalik sa madason nga Adlaw nga Inugpahuway kag maghambal liwan kang nahanungud sa mga butang nga dya. ");
INSERT INTO krj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pagkaburublaganay kang mga tawo, duro nga mga Judio kag mga bukun ti Judio nga nadara sa relihiyon kang mga Judio ang nagsurunod kanday Pablo kag Bernabe. Ginhambalan sanda nanday Pablo kag ginhangkat nga magpadayon nga nagasarig sa bugay kang Dios. ");
INSERT INTO krj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pagkasunod nga Adlaw nga Inugpahuway, haros ang tanan nga mga pumuluyo sa syudad nag-agto sa sinagoga sa pagpamati ka pulong kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero kang makita kang mga Judio ang duro nga mga tawo, nahisa gid sanda ka mayad kag ginsupak nanda ang mga ginapanghambal ni Pablo kag gin-insultohan nanda tana. ");
INSERT INTO krj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pero si Pablo kag si Bernabe may kaisug nga naghambal, “Nagakadapat lang nga ang pulong kang Dios iwali primero kaninyo. Pero tungud gani nga ginsikway ninyo dya kag ginakabig ninyo ang inyo kaugalingun nga indi takus sa pagbaton kang kabuhi nga wara ti katapusan, kar-on, sa mga bukun ti Judio kami magaagto. ");
INSERT INTO krj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tungud hay amo dya ang sugo kang Ginoo kanamun, kang magkuon tana, ‘Ginhimo ko ikaw nga pareho kang sulo nga magatugro kang kasanag sa mga bukun ti Judio, agud paagi kanimo ang bug-os nga kalibutan maluwas.’” ");
INSERT INTO krj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kang mabatian dya kang mga bukun ti Judio, nalipay gid sanda kag gindayaw ang pulong kang Ginoo; kag ang tanan nga ginpili run nga daan nga makaangkun kang kabuhi nga wara ti katapusan nagtoroo. ");
INSERT INTO krj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kag ang pulong kang Ginoo naglapnag sa bisan diin nga sakup kang lugar nga to. ");
INSERT INTO krj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero ang mga Judio tana, ginsudyot nanda ang mga halangdun nga mga bayi nga nagasimba sa Dios kag ang dungganun nga mga laki sa syudad. Ginhingabot nanda sanday Pablo kag Bernabe kag gintabog pagwa sa andang lugar. ");
INSERT INTO krj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Gani gintatak kang darwa ka apostoles ang yab-ok sa andang mga kahig kontra sa mga tawo nga ria kag nag-agto sanda sa Iconio. ");
INSERT INTO krj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ang mga sumurunod tana sa Antioquia nalipay gid ka mayad kag ginagamhan kang Balaan nga Ispirito. ");
INSERT INTO krj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Amo man ka dya ang natabo sa Iconio. Nag-agto sa sinagoga kang mga Judio sanday Pablo kag Bernabe, kag nagpangwali sanda sa paagi nga duro gid nga mga Judio kag mga bukun ti Judio ang nagtoo. ");
INSERT INTO krj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero ang mga Judio tana nga indi magtoo, ginsudyot nanda ang mga bukun ti Judio kag ginsulsolan nga kaugtan nanda ang mga tumuluo. ");
INSERT INTO krj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nagpabilin pa gid kang malawid sanday Pablo kag Bernabe sa Iconio nga nagahambal nga may kaisug nahanungud sa Ginoo. Ginpamatud-an kang Ginoo nga matuod ang andang ginapanudlo nahanungud sa anang bugay paagi sa gahum nga gintugro kananda sa paghimo kang mga milagro kag mga katingalahan nga mga butang. ");
INSERT INTO krj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ang mga katawhan sa syudad nahuray sa darwa. Ang iba kananda nagsunod sa mga Judio, kag ang iba tana nagsunod sa mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kar-on, ang mga bukun ti Judio kag ang mga Judio, imaw kang andang mga pangulo, nagbuko nga sakitun kag batwun ang darwa nga dya. ");
INSERT INTO krj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero kang maman-an nanda dya, nagpalagyo sanda kag mag-agto sa Listra kag Derbe nga mga syudad kang Licaonia, kag sa mga lugar sa palibot. ");
INSERT INTO krj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kag ginwali nanda rugto ang Mayad nga Balita. ");
INSERT INTO krj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Rugto sa Listra may sangka tawo nga lupog halin pa kang anang pagkatawo, kag wara gid makapanaw. ");
INSERT INTO krj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nagapungko tana rugto nga nagapamati kay Pablo nga nagahambal. Nakita ni Pablo nga nagatoo tana nga maayad tana, gani ginturuk na dya ka mayad ");
INSERT INTO krj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kag ginkun-an sa matunog nga limug, “Tindug kang matadlung!” Nagtumbo ang tawo kag nagpanaw-panaw. ");
INSERT INTO krj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kang makita kang karak-an ang ginhimo nga dya ni Pablo, nagsinggit sanda sa hambal nga Licaonianhun nga nagakuon, “Nanaog kanatun ang mga dios sa dagway kang tawo!” ");
INSERT INTO krj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gintawag nanda si Bernabe nga Zeus, kag si Pablo tana gintawag nanda nga Hermes, tungud hay tana ang manughambal. ");
INSERT INTO krj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ang templo ni Zeus rugyan lang sa gwa kang syudad, kar-on, ang anang pari nagdara kang mga toro nga baka kag mga kulintas nga bulak sa pwertahan kang syudad sa tuyo nga tana kag ang mga tawo magahalad sa mga apostoles. ");
INSERT INTO krj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero kang mabatian dya nanday Bernabe kag Pablo, gin-gisi nanda ang andang mga bayo kag nagdalagan sa tunga kang karak-an nga nagasinggitan, ");
INSERT INTO krj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mga amigo, andut nga ginahimo ninyo dya? Mga tawo lang man kami nga pareho ninyo. Rugya kami agud magsugid kaninyo kang Mayad nga Balita, agud to nga magbiriya kamo sa mga butang nga wara ti pulos nga dya, kag magparapit sa Dios nga buhi, nga amo ang nagtuga kang langit, kag kang lupa, kag kang dagat, kag kang tanan nga mga butang nga rugyan kananda. ");
INSERT INTO krj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Katong una nga mga panag-on, ginpabay-an kang Dios ang tanan nga mga tawo nga maghimo kang bisan ano nga luyag nanda. ");
INSERT INTO krj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wara ti sapayan karia, ang Dios wara gid mag-untat sa pagpamatuod kang anang kaugaligun paagi sa paghimo kang mayad, pareho kang pagtugro na kaninyo kang uran kag mayad nga patubas sa nagakaigo nga tyempo, kag ginatugroan na kamo kang bugana nga pagkaun kag tuman nga kalipay.” ");
INSERT INTO krj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bisan amo pa ka dya ang ginhambal kang mga apostoles, nabudlayan gihapon sanda sa pagpugung sa mga tawo nga maghalad para kananda. ");
INSERT INTO krj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kar-on, may mga Judio nga nag-arabot halin sa Antioquia nga sakup kang Pisidia kag halin sa Iconio. Nahaylo nanda ang mga tawo sa Listra nga magdampig kananda, dayon ginbato nanda si Pablo kag gin-guyod pagwa sa syudad tungud hay abi nanda patay run tana. ");
INSERT INTO krj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero kang ginlibotan tana kang mga tumuluo, nagtindug tana kag nagbalik sa syudad. Kang masunod nga adlaw, nag-agto sanda ni Bernabe sa Derbe. ");
INSERT INTO krj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ginwali nanday Pablo kag Bernabe ang Mayad nga Balita rugto, kag duro gid ang andang nadara nga mangin sumurunod. Dayon, nagbalik sanda sa Listra, kag sa Iconio, kag sa Antioquia nga sakup kang Pisidia. ");
INSERT INTO krj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ginparig-un nanda ang mga gintuton-an kag ginalaygayan nga magpabilin nga mapag-un ang andang pagtoo, kag ginkun-an, “Kinahanglan gid nga mag-agi kita kang duro nga mga kabudlayan sa atun pagpasakup sa pagginahum kang Dios.” ");
INSERT INTO krj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sa kada iglesia, nagpili sanday Pablo kang mga kamal-aman nga amo ang magadumara. Nagapangamuyo sanda kag nagapuasa, kag ginatugyan nanda ang mga manugdumara sa Ginoo nga andang gintoohan. ");
INSERT INTO krj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pagkatapos nga maagtunan nanda ang mga lugar nga sakup kang Pisidia, nag-abot sanda sa Panfilia. ");
INSERT INTO krj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ginwali nanda ang pulong kang Dios sa Perga kag pagkatapos nagdulhog sanda sa Atalia. ");
INSERT INTO krj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Halin rugto nagpanakayun sanda pabalik sa Antioquia, ang lugar nga sa diin gintugyan sanda sa Dios nga tipigan sanda sa hirikoton nga natapos run nanda ka dya. ");
INSERT INTO krj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pag-abot nanda sa Antioquia, gintipon nanda ang tanan nga mga katapo kang iglesia kag ginsugid ang tanan nga mga ginhimo kang Dios paagi kananda, kag kon paano gintugroan kang Dios ang mga bukun ti Judio kang kahigayonan nga magtoo. ");
INSERT INTO krj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kag nagpabilin pa gid sanda ka malawid rugto imaw sa mga tumuluo. ");
INSERT INTO krj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kar-on, may mga tawo nga naghalin sa Judea nga nag-abot sa Antioquia, kag nagapanudlo sa mga tumuluo nga nagakuon, “Indi kamo maluwas kon wara kamo nasirkom suno sa ginakuon sa Kasugoan ni Moises.” ");
INSERT INTO krj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pero ginpamatukan dya nanday Pablo kag Bernabe kag sobra gid ang pagpakigbais nanda sa mga tawo nga to. Gani napamat-udan nga paagtonon sa Jerusalem sanday Pablo kag Bernabe kag ang iba pa gid nga mga tumuluo agud magpakighinun-anun sa mga apostoles kag sa mga kamal-aman nahanungud sa butang nga dya. ");
INSERT INTO krj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ginpapanaw sanda kang iglesia, kag pag-agi nanda sa Fenicia kag Samaria, ginsugid nanda rugto nga ang mga bukun ti Judio nagtoroo sa Dios, kag nagtugro dya kang tuman nga kalipay sa iglesia. ");
INSERT INTO krj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kang pag-abot nanda sa Jerusalem, gin-abi-abi sanda kang iglesia kag kang mga apostoles kag kang mga kamal-aman. Kag ginsugid nanday Pablo ang tanan nga ginhimo kang Dios paagi kananda. ");
INSERT INTO krj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero ang iba nga mga tumuluo nga katapo kang grupo kang mga Fariseo nagtindug kag nagkuon, “Kinahanglan nga sirkomon ang mga bukun ti Judio kag kun-an nga magtuman sa Kasugoan ni Moises!” ");
INSERT INTO krj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nagsapol ang mga apostoles kag ang mga kamal-aman sa paghinun-anun nahanungud sa bagay nga dya. ");
INSERT INTO krj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pagkatapos kang malawid nga paghinon-anun, nagtindug si Pedro kag naghambal kananda, “Mga kabugtoan, nakamaan kamo nga kato anay ako ang ginpili kang Dios sa kanatun tanan nga magwali kang Mayad nga Balita sa mga bukun ti Judio agud to nga makabati sanda kag magtoo. ");
INSERT INTO krj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ang Dios nga nakamaan kang tagipusoon kang tawo ang nagpamatuod nga ang mga bukun ti Judio ginbaton na man paagi sa pagtugro kananda kang Balaan nga Ispirito pareho kang ginhimo na kanatun kauna. ");
INSERT INTO krj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wara tana ti pinasulabi kanatun nga mga Judio kag sa mga bukun ti Judio, tungud hay ginlimpyohan na man ang andang tagipusoon paagi sa andang pagtoo. ");
INSERT INTO krj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kar-on, andut nga gusto pa ninyo tirawan ang Dios paagi sa pagtugro kang mga mabug-at nga turumanun sa mga sumurunod nga ang atun mga kaulangan gani ukon kita wara man makasarang sa pagtuman? ");
INSERT INTO krj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pero nagapati kita nga paagi sa bugay kang atun Ginoong Jesus maluwas kita, kag amo man sanda nga mga bukun ti Judio.” ");
INSERT INTO krj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Naghipus ang bilog nga kasapulanan kag namati kanday Bernabe kag Pablo nga nagapanaysayun kang mga milagro kag iba pa nga mga katingalahan nga ginhimo kang Dios paagi kananda sa tunga kang mga bukun ti Judio. ");
INSERT INTO krj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pagkatapos nanda ka panaysayun, naghambal si Santiago, “Mga kabugtoan ko, pamati kamo kanakun. ");
INSERT INTO krj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ginsaysay kanatun ni Simon ang una nga pagpakita kang Dios kang anang pagkabalaka sa mga bukun ti Judio paagi sa pagpili halin kananda kang mga tawo nga mangin ana. ");
INSERT INTO krj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nagsanto gid dya sa ginkuon kang mga propeta kauna. Pareho kang nasulat sa kasulatan, ");
INSERT INTO krj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pagkatapos ka dya magabalik ako, Kag ibalayun ko liwan ang ginaharian ni David nga narumpag. Ipatindugun ko dya liwan halin sa anang pagkaguba, kag papag-unun. ");
INSERT INTO krj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Agud to nga ang iba nga mga nasyon magapangita sa Ginoo, kag ang tanan nga mga bukun ti Judio nga ginpili ko nga mangin akun katawhan. ");
INSERT INTO krj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Amo ria ang ginkuon kang Ginoo, nga amo man ang nagpamaan kang mga butang nga dya halin pa kauna.’” ");
INSERT INTO krj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Gani amo dyaay ang akun nga panghuna-huna: indi run natun pagpalisdan ang mga bukun ti Judio nga nagaparapit sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sa baylo, sulatan natun sanda nga indi sanda magkaun kang bisan ano nga ginhalad sa mga dios-dios, kag indi man sanda magpakighilawas, kag indi man sanda magkaun kang kusug ka sapat nga ginpatay nga wara mapaturo ang anang dugo, kag indi man sanda magkaun kang dugo. ");
INSERT INTO krj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tungud hay kauna pa nga daan ang kasugoan ni Moises ginabasa run sa sinagoga kada Adlaw nga Inugpahuway, kag ginawali sa kada syudad.” ");
INSERT INTO krj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Gani nagpamat-ud ang mga apostoles kag ang mga kamal-aman kag ang bilog nga iglesia nga magapili kang mga laki sa andang grupo nga paagtonon sa Antioquia kaimaw nanday Pablo kag Bernabe. Ginpili nanda si Judas nga ginatawag man Barsabas kag si Silas, sanda ka dya amo ang nagapangulo sa andang katiringban. ");
INSERT INTO krj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Amo dya ang ginakuon sa sulat nga andang ginpadara: “Kami nga mga apostoles, kag mga kamal-aman nga mga kabugtoan ninyo, nagapangamusta kaninyo nga mga tumuluo nga mga bukun ti Judio rugyan sa Antioquia, Siria, kag Cilicia. ");
INSERT INTO krj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nabalitaan namun nga may pira ka mga tawo nga naghalin rugya kanamun nga nagtublag kaninyo nga nagpalibug kang inyo paminsarun tungud kang andang mga sayup nga ginapanudlo kaninyo, pero wara namun sanda karia ginsugo. ");
INSERT INTO krj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gani ginkasugtan namun tanan nga magpili kang mga tawo kag ipadara rugyan kaninyo imaw kang atun pinalangga nga sanday Bernabe kag Pablo. ");
INSERT INTO krj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Sanda ka dya nagtaya kang andang kabuhi tungud gid lang sa pagpangalagad sa atun Ginoong Jesu-Cristo. ");
INSERT INTO krj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gani ginpadara namun kaninyo sanday Judas kag Silas; sanda gid mismo ang magasugid kaninyo nahanungud kang mga butang nga amun ginkuon kaninyo sa sulat. ");
INSERT INTO krj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ginpakamayad namun kag kang Balaan nga Ispirito nga indi run kamo pagpalisdan pa, magluwas lang sa mga butang nga dya nga dapat gid ninyo tumanun: ");
INSERT INTO krj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","indi kamo magkaun kang bisan ano nga ginhalad sa mga dios-dios; indi man kamo magkaun kang dugo kag kang kusug ka sapat nga ginpatay nga wara mapaturo ang anang dugo; kag indi man kamo magpakighilawas. Mayad gid dya kaninyo kon likawan ninyo ang mga bagay nga dya. Hasta run lang rugya.” ");
INSERT INTO krj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ginpapanaw ang mga ginsugo nga to kag nag-agto sanda sa Antioquia. Pag-abot nanda rugto gintipon nanda ang tanan nga mga tumuluo kag gintugro kananda ang sulat. ");
INSERT INTO krj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pagkabasa nanda kato, nalipay gid sanda sa mga ginakuon sa sulat nga nagaparig-un kananda. ");
INSERT INTO krj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sanday Judas kag Silas nga mga propeta man, nagpakigsugidanun kang malawid kananda para parig-unun ang andang baratyagun kag pabakudun ang andang pagtoo. ");
INSERT INTO krj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pagkatapos nga nakatiner sanda rugto kang mabugu nga tinion, ang mga tumuluo rugto nagpangamuyo kananda nga mangin mayad lang ang andang pagpanaw pabalik sa mga nagsugo kananda.  ");
INSERT INTO krj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero si Silas tana nagpamat-ud nga magpabilin rugto. ");
INSERT INTO krj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Sanday Pablo kag Bernabe tana nagpabilin pa gid sa Antioquia. Sanda kag imaw kang duro pa gid nga mga tumuluo nagpanudlo kag nagpangwali kang Pulong kang Ginoo. ");
INSERT INTO krj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagkaligad kang pira ka adlaw, nagkuon si Pablo kay Bernabe, “Balikan natun kag bisitahan ang mga tumuluo sa kada syudad nga ginwalihan natun kang Pulong kang Ginoo. Sulngun ta kon paiwan sanda run.” ");
INSERT INTO krj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ang gusto tana ni Bernabe imawun nanda si Juan Marcos. ");
INSERT INTO krj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero para kay Pablo tana, bukun ti mayad nga imawun nanda si Juan Marcos nga nagbiya kananda sa Panfilia kag wara run nagpadayon sa pagbulig kananda sa hirikoton. ");
INSERT INTO krj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sobra gid ang pagsuayay nanday Pablo kag Bernabe, gani nagbulagay run lang sanda. Gin-imaw ni Bernabe si Juan Marcos kag nagpanakayun sanda paagto sa Cipro. ");
INSERT INTO krj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Pablo tana, ginpili na si Silas kag naghalin pagkatapos nga gintugyan sanda kang mga tumuluo sa Ginoo nga tipigan sanda. ");
INSERT INTO krj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ginpang-agtonan na ang mga lugar kang Siria kag Cilicia kag ginparig-un na ang pagtoo kang mga tumuluo sa mga iglesia. ");
INSERT INTO krj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nag-agto man si Pablo sa Derbe kag sa Listra, nga sa diin may sangka tumuluo nga ginahingaranan kay Timoteo. Ang nanay na kadya sangka tumuluo nga Judio, pero ang tatay na tana Griego. ");
INSERT INTO krj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ang mga tumuluo sa Listra kag sa Iconio nagakuon nga si Timoteo nga dya mayad nga tawo. ");
INSERT INTO krj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gusto ni Pablo nga imawun si Timoteo, gani ginsirkom na dya tungud kang mga Judio sa mga lugar nga dya, kag nakamaan man sanda nga Griego ang tatay ni Timoteo. ");
INSERT INTO krj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sa kada syudad nga anda ginaagtonan, ginapaalinton nanda sa mga tumuluo ang mga ginkasugtan kang mga apostoles kag mga kamal-aman rugto sa Jerusalem, kag ginkun-an nga tumanun gid nanda dya. ");
INSERT INTO krj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Gani nagrig-un pa gid ang pagtoo kang mga tumuluo, kag nagaduro pa gid sanda kada adlaw. ");
INSERT INTO krj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nag-agto sanda sa mga lugar nga sakup kang Frigia kag Galacia tungud hay wara sanda tugoti kang Balaan nga Ispirito nga magpangwali sa probinsya kang Asia. ");
INSERT INTO krj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pag-abot nanda sa dulonan kang Misia gintinguhaan nanda nga mag-agto sa probinsya kang Bitinia, pero wara sanda tugoti kang Ispirito ni Jesus. ");
INSERT INTO krj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Gani naglubas lang sanda sa Misia kag nagdulhog sa Troas. ");
INSERT INTO krj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kang gabii nga ria, nakita ni Pablo sa anang paranan-awun ang sangka tawo nga taga-Macedonia nga nagatindug kag nagapangabay kana nga nagakuon, “Agto ikaw rugya sa Macedonia kag tabangi kami!” ");
INSERT INTO krj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pagkakita na kang paranan-awun nga to, naghimus kami lagi agud mag-agto sa Macedonia, tungud hay nasiguro namun nga ginapaagto kami kang Dios agud iwali ang Mayad nga Balita rugto kananda. ");
INSERT INTO krj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Halin sa Troas nagpanakayun kami diretso sa Samotracia, kag kang masunod nga adlaw nagpadayon kami sa Neapolis. ");
INSERT INTO krj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Halin rugto nagpanaw kami paagto sa Filipos nga amo ang nagapanguna nga syudad sa distrito nga to kang Macedonia kag sakup kang pagginahum kang Roma. Nagpabilin kami sa syudad nga dya kang pira ka adlaw. ");
INSERT INTO krj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pag-abot kang Adlaw nga Inugpahuway, naggwa kami sa syudad kag nag-agto sa binit kang suba nga sa pagbanta namun may lugar nga parangamuyoan kang mga Judio. Nagpungko kami kag nagpakig-istorya sa mga kababainhan nga nagtiriripon rugto. ");
INSERT INTO krj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ang isara sa mga nagapamati kanamun amo si Lydia nga taga-Tiatira. Manugbaligya tana ka dya kang tela nga granati, kag nagasimba man tana sa Dios. Ginbuksan kang Ginoo ang anang tagipusoon agud magpati tana sa mga ginapanghambal ni Pablo. ");
INSERT INTO krj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pagkatapos nga nabawtisohan tana kag ang bilog na nga panimalay, gin-agda na kami nga nagakuon, “Kon nagapati kamo nga nagtoo matuod ako sa Ginoo, rugto kamo sa balay magdayon.” Kag nagpasugot kami sa anang pang-agda. ");
INSERT INTO krj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sangka adlaw, kang nagapaagto kami sa lugar nga parangamuyoan, nasug-alaw namun ang sangka dalagita nga surugoon nga nasab-an kang malaot nga ispirito, gani nga makalatu tana kang paraaboton. Makapangwarta kang bahul ang anang mga agalun tungud kang anang pagpanglatu. ");
INSERT INTO krj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nagasunod-sunod tana kanamun kag nagasinggitan, “Ang mga tawo nga dya surugoon kang Labing Mataas nga Dios; ginapahayag nanda kaninyo kon paano kamo maluwas!” ");
INSERT INTO krj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ginhimo na dya sa duro nga mga inadlaw. Kang urihi natak-an run si Pablo, gani gin-atubang na ang dalagita kag ginhambalan ang malaot nga ispirito, “Sa ngaran ni Jesu-Cristo, ginamandoan ko ikaw nga maggwa sa dalagita nga ria!” Kag kato lagi, naggwa ang malaot nga ispirito sa lawas kang dalagita. ");
INSERT INTO krj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kang maman-an kang anang mga agalun nga wara run sanda ti paglaum nga makapangwarta pa, gindakup nanda si Pablo kag si Silas kag gin-guyod hasta sa may tindahan kag ginpaatubang sa mga may awtoridad. ");
INSERT INTO krj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ginpaatubang sanda sa mga opisyales nga Romanhun kag nagkuon, “Ang mga laki nga dya mga Judio. Nagadara sanda kang gamo sa atun nga syudad. ");
INSERT INTO krj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nagapanudlo sanda kang mga pagbinatasan nga kontra sa atun kasugoan, kag bilang mga Romanhun indi nagakadapat nga patihan natun ukon sundon!” ");
INSERT INTO krj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ang mga katawhan nagpuroli man sa pagsakit kay Pablo kag Silas. Ginpabuklas kang mga opisyales ang mga bayo nanday Pablo kag Silas hasta nga magisi dya kag dayon ginpahanot sanda. ");
INSERT INTO krj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pagkatapos nga nahanot sanda ka mayad, ginpriso sanda, kag ang manugbantay kang prisohan ginmandoan nga gwardyahan gid sanda ka mayad. ");
INSERT INTO krj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pagkabati kang manugbantay kang mando nga dya, ginbutang na sanday Pablo sa sulud gid nga selda kang prisohan, kag ginpandugan ang andang mga kahig. ");
INSERT INTO krj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kang mga tungang-gabii run, sanday Pablo kag Silas nagapangamuyo kag nagakanta nga nagadayaw sa Dios, kag ang iba nga mga priso nagapamati kananda. ");
INSERT INTO krj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hinali lang nga naglinog kang mabaskug kag ang prisohan nag-uyug hasta sa anang pundasyon. Lagi-lagi nagburokas ang tanan nga mga gawang kag nagkarahukas ang mga kadena kang tanan nga mga priso. ");
INSERT INTO krj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nakabugtaw ang bantay kag pagkakita na nga bukas ang mga gawang, gin-gabot na ang anang espada agud manginmatay run daad tungud hay abi na nakapalagyo run ang mga priso. ");
INSERT INTO krj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero nagsinggit si Pablo, “Indi kaw magpanginmatay! Rugya kami tanan!” ");
INSERT INTO krj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nangayo kang sulo ang manugbantay kag dali-dali nga nagsulud, kag nagakurudug sa kahadluk nga nagluhod sa atubang nanday Pablo kag Silas. ");
INSERT INTO krj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dayon gindara na sanday Pablo sa gwa kang prisohan kag namangkot, “Mga sir, ano ang akun dapat himoon agud maluwas ako?” ");
INSERT INTO krj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nagsabat sanda, “Magtoo ikaw kay Ginoong Jesus kag maluwas ikaw, kag pati ang imo panimalay.” ");
INSERT INTO krj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ginsugid nanda kana ang Pulong kang Ginoo kag sa tanan nga rugyan sa anang balay. ");
INSERT INTO krj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kang amo gid to nga oras kang kagab-ihun gindara na sanday Pablo kag ginhugasan ang andang mga pilas. Ginbawtisohan tana lagi kag amo man ang anang bilog nga panimalay. ");
INSERT INTO krj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pagkatapos, gindara na sanday Pablo kag Silas sa anang balay kag ginpahimsan kang pagkaun. Tana kag ang anang bilog nga panimalay nalipay gid ka mayad tungud hay nagatoo run sanda kadya sa Dios. ");
INSERT INTO krj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagkaaga, ang mga opisyales nga Romanhun nagsugo kang mga pulis nga buy-an run sanday Pablo. ");
INSERT INTO krj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ang mga butang nga dya ginsugid kang manugbantay kanday Pablo kag Silas. Nagkuon tana, “Nagpasugo ang mga opisyales nga buy-an run kamo. Gani makagwa run kamo kag kabay nga mayad lang ang inyo nga pagpanaw.” ");
INSERT INTO krj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero nagkuon si Pablo sa mga pulis, “Ginpahanot nanda kami sa atubang kang katawhan nga wara kami maimbistigar, bisan pa nga mga Romanhun man kami, dayon ginpapriso pa nanda kami. Kar-on gusto pa nanda nga buy-an kami nga wara ti makamaan. Indi ria mahimo! Sanda mismo ang mag-agto rugya kag magdara kanamun pagwa.” ");
INSERT INTO krj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ang mga ginkuon nanda nga dya, ginsugid man kang mga pulis sa mga opisyales nga Romanhun, kag pagkamaan nanda nga mga Romanhun sanday Pablo kag Silas, hinadlukan gid sanda. ");
INSERT INTO krj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Gani nag-agto sanda sa prisohan kag nangayo kang pasaylo kanday Pablo, kag gin-imawan sanda pagwa sa prisohan kag ginpangabay nga maghalin sa syudad. ");
INSERT INTO krj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pagkagwa nanday Pablo kag Silas sa prisohan, nagderetso sanda sa balay ni Lydia. Nagpakigkita sanda rugto sa mga tumuluo, kag ginlaygayan nga magpakarig-un sa andang pagtoo. Dayon naghalin sanda. ");
INSERT INTO krj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nag-agi sanday Pablo kag Silas sa Anfipolis kag Apolonia, hasta nga makadangat sanda sa Tesalonica nga sa diin may sinagoga kang mga Judio. ");
INSERT INTO krj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pareho kang naandan ni Pablo, nag-agto tana sa sinagoga kag sa sulud kang tatlo ka Adlaw nga Inugpahuway nagpakigdiskusyon tana sa mga tawo nga ginabasehan na ang Kasulatan. ");
INSERT INTO krj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ginapaathag na kag ginapamatud-an kananda nga si Cristo kinahanglan gid nga mag-antos kag mabanhaw. Nagkuon tana, “Si Jesus nga dya nga akun ginasugid kaninyo, amo ang Cristo.” ");
INSERT INTO krj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ang iba kang mga Judio nagpati kag nagsunod kanday Pablo kag Silas, amo man ang tama ka duro nga mga Griego nga nagasimba sa Dios kag duro nga mga halangdun nga kababainhan. ");
INSERT INTO krj_vpl VALUES ("AC17_5