﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqw_vpl;
CREATE TABLE kqw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqw_vpl WRITE;
INSERT INTO kqw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iri a risan a kabotaro tagun numugu ra o Iesu Karisito i wanpat tagun det. O Iesu, i a nutun o Dewid, o Dewid i a nutun o Abaram. ");
INSERT INTO kqw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","O Abaram i o taman o Aisak, O Aisak i o taman o Jekop, ma o Jekop i o taman o Juda ma a kum tistisino. ");
INSERT INTO kqw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","O Juda i o taman o Peres der nam o Sera, ra a nander o Tamar. O Peres i o taman o Esrom, o Esrom i o taman o Ram, ");
INSERT INTO kqw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ma o Ram i o taman o Aminadap, o Aminadap i o taman o Nason, ma o Nason i o taman o Salmon, ");
INSERT INTO kqw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","o Salmon i o taman o Boas, ma o nano a risano o Reap. O Boas i o taman o Obed, ma o nano a risano o Rut. O Obed i o taman o Jesi, ");
INSERT INTO kqw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ma o Jesi i o taman o Dewid, i ra a king. O Dewid i o taman o Solomon, ma o nano a ino ra i nolin pas nam o Uria. ");
INSERT INTO kqw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","O Solomon i o taman o Roboam, o Roboam i o taman o Abia, o Abia i o taman o Asa, ");
INSERT INTO kqw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","o Asa i o taman o Josapat, o Josapat i o taman o Joram, ma o Joram i o taman o Usia, ");
INSERT INTO kqw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","o Usia i o taman o Jotam, o Jotam i o taman o Akas, ma o Akas i o taman o Esekia, ");
INSERT INTO kqw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","o Esekia i o taman o Manase, o Manase i o taman o Amon, ma o Amon i o taman o Josaia, ");
INSERT INTO kqw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","o Josaia i ulabo o Jekonia tomo nama kum tistisino. Numur tano, a taro Babilon det dat pas a taro Israel utong o Babilon sur det in kis na karabus. ");
INSERT INTO kqw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Numur tan a inawan utong o Babilon: O Jekonia i ulabo o Salatiel, o Salatiel i o taman o Serubabel, ");
INSERT INTO kqw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","o Serubabel i o taman o Abiut, o Abiut i o taman o Eliakim, ma o Eliakim i o taman o Asor, ");
INSERT INTO kqw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","o Asor i o taman o Sadok, o Sadok i o taman o Akim, ma o Akim i o taman o Eliut, ");
INSERT INTO kqw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","o Eliut i o taman o Eliaser, o Eliaser i o taman o Matan, ma o Matan i o taman o Jekop, ");
INSERT INTO kqw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","o Jekop i o taman o Josep, i ra i nolin nam o Maria. O Maria i usus o Iesu, ra di watungi a Karisito, i ra o God i tulu ru i. ");
INSERT INTO kqw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A kum taun taro turpasi tagun o Abaram tuk un o Dewid i elar nama noino ma wat det, ma tagun o Dewid tuk una inawan na karabus tong o Babilon a noino ma wat kai det, ma tagun a inawan na karabus tong o Babilon tuk un o Karisito a noino ma wat na taun taro kai. ");
INSERT INTO kqw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Di usus pas o Iesu Karisito lenri: O nano, o Maria, di sa ubek bat tari sur anun o Josep, ikut numugu tan anunder a nolin o Maria i sa tasmani lena i tianan tan a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","O Josep ra di sa ubek bat tar o Maria toromi, i a tene tokodos, ma ke nemi sur in ban umaimai o Maria umatan a taro. Ra i nuki lena in kutus eno ru anunder a liliman sur a nolin. ");
INSERT INTO kqw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ra i nuknuk utmakai una utna ri, a ensel anun a Labino i wanpat toromi una ririon ra i watungi lena, “Josep, a nutun o Dewid, gong u wur nuknuk un o Maria, un ben pasi kut sur anum a ino. Uni a nat ra i tianan pasi, i wanpat tagun a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","In usus pas a nat na musano ma un pasor a risano nam o Iesu, uni in ulaun pas anun a taro gusun anundet a kum sakino petutna.” ");
INSERT INTO kqw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A kum utna rop ri i wanpat sur din pam sot pas a kum wasiso anun a Labino ra anun a poropet i sa upuaso tari lenri, ");
INSERT INTO kqw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tama i, a toraro na ino in tianan ma in usus pas a nat na musano ra din watungi nam o Emanuel,” a kukuraino lena, “O God i kis tomo nam dat.” ");
INSERT INTO kqw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ra o Josep i tuangun, i muri lenutra a ensel anun a Labino i sa inanos tari nami, ra i ben pas o Maria sur anun a ino. ");
INSERT INTO kqw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ikut ka der inep tomo pas tuk ra o Maria i usus pas a nat na musano. Ma o Josep i pasor a risano nam o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Di usus o Iesu una tamon Betliem tiro una papor Judia, una kilalo ra o Erod i king. Numur a ramano kum tene mananos tagun a kum nangnang det wan tagitiro una nubual ra in matanas i pusu pat iai, ra det wanpat sapat o Jerusalem. ");
INSERT INTO kqw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ra det iting lena, “Awai i a nat ra di ususi, sur in king anun a taro Juda? Uni met tama anun in nangnang tiro una nubual ra in matanas i pusu pat iai, ra iri met wan urin sur met in lotu toromi.” ");
INSERT INTO kqw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ra o king Erod i longoro i, i talara a nuknukino ma a nuknukin a taro Jerusalem rop kai. ");
INSERT INTO kqw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Numur i ben tomo rop pas a kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai. Ra i ting det lena, “A Karisito ra o God in tulu ru i, din usus i awai?” ");
INSERT INTO kqw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Det balu i lena, “Tong o Betliem una papor Judia, uni a poropet i sa tumus tari lenri, ");
INSERT INTO kqw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ma ui o Betliem una piso anun a kabotaro Juda, Ui ko natino bing tan a kum mugumugu anun a kabotaro Juda, Uni a mugumugu in nanpat tagun ui, ra in mugu anung a taro Israel elar nama tene tamtamabat anun a kum sipsip.’” ");
INSERT INTO kqw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Numur o Erod i itula eno pas a kum tene mananos tagun a kum nangnang sur in talapor pas tandet lena, nangisin mulus ra in nangnang i wanpat. ");
INSERT INTO kqw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I tulu ru det utong o Betliem nama wasiso lenri, “Mot nan ma mot in sisio wakak sur a natlik. Ma ra mot sa sio pasi, mot in inanos iau, sur iau bulung an nan ma an lotu toromi.” ");
INSERT INTO kqw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Det sa longoro tar a king ra det wan. Det tama melet pas in nangnang ra det sa tama tari una nubual ra in matanas i pusu pat iai. I mugu nanan det tuk i tur sapat una nubual ra a natlik kura iai. ");
INSERT INTO kqw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ra det tama in nangnang ra, det taramo a labino gasgas. ");
INSERT INTO kqw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Det ruk una rumu ra det tama pas a natlik, ma o nano o Maria. Det kis butkeke ra det lotu torom a natlik. Numur det papos pas anundet a kum bek ma det tabori nama kum etabor lenri: a gol, ma a paura di tuni ra a mis ino i sangnain wakak ra di watungi nama insens, ma a torok sangsangnain kai ra di watungi nama mira. ");
INSERT INTO kqw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","O God i sa utumarong tar det una ririon, sur gong det milet taru sur o Erod. Ra det milet sur anundet a tamon una se kisapi mukut. ");
INSERT INTO kqw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ra det sa wan taru, a ensel anun a Labino i wanpat torom o Josep una ririon ra i watungi lena, “Un katutur, un ben pas o nader nano, ma motul in kalabor eno utong o Ijip. Ma motul in kis tong iai tuk una bung ra an inanos ui melet, uni o Erod in sisio sur a natlik sur in um doko i.” ");
INSERT INTO kqw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ra i katutur, i ben pas nader nano una mirum, ma detul wan utong o Ijip. ");
INSERT INTO kqw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Detul kis tiro iai tuk o Erod i mat. Una anundetul a kinkinis tiro, di pam sot pas a wasiso anun a Labino, ra a poropet i sa wasiso mugu taru uni lenri, “A kabo pas a nutunglik tagitong o Ijip.” ");
INSERT INTO kqw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ra o Erod i tama i lena a kum tene mananos tagun a kum nangnang det sa toro tari, i kankan doko ra i itula sur din um doko rop ru a kum nat musano tong o Betliem ma una kum tamon kai ra det kis milau. I pitar a warkurai sur din um doko det ra aru kilalo anundet, ma det kai ra ke ru kilalo utmakai anundet, uni a kum tene mananos det sa inanos tari una kilalo anun a natlik. ");
INSERT INTO kqw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ra di sa pam sot pasi maragom a wasiso ra o Jeremaia a poropet i wasiso mugu taru uni lena, ");
INSERT INTO kqw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tong o Rama di longoro in nalngan ara, a tintinangis ma a ungugaia, O Rakel i domos a kum nutnutunu liklik, uni det sa mat rop, ma ka di umarip lar pasi.” ");
INSERT INTO kqw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","O Erod i sa mat, ra a ensel anun a Labino i wanpat torom o Josep una ririon tiro o Ijip. ");
INSERT INTO kqw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma i watungi tano lena, “Un katutur, un ben pas der nano, ma motul in nan utong o Israel, uni det ra det nem na um doko a natlik det sa mat.” ");
INSERT INTO kqw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Numur i katutur, i ben pas der nano, ra detul wan utong o Israel. ");
INSERT INTO kqw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ikut i longoro i lena, o Akelaus i keles o tamano o Erod, sur i bulung in king tong una papor Judia, ra o Josep i ngara sur in nan utong o Judia. Ra detul wan mukut utong una papor Galili, uni o God i turbat tar o Josep una ririon, sur gong detul wan utong una papor Judia. ");
INSERT INTO kqw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ra detul wan ma detul kis una tamon a risano o Nasaret. Una anundetul a kinkinis tiro, di pam sot pas a wasiso anun a kum poropet lena, “Din watungi lena i a te Nasaret.” ");
INSERT INTO kqw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A ramano kum kilalo numur, o Jon a Tene Baptaiso i wanpat, ma i warawai una nubual kalako taro uni una papor Judia, ");
INSERT INTO kqw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ra i watungi lena, “Mot in nukpukus, uni a matanitu tagisapat una langit i sa milau.” ");
INSERT INTO kqw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","O Jon ut ra, ra a poropet Aisaia i sa wasiso puaso mugu taru uni lena, “Una nubual kalako taro uni, in nalngan ara i kakabo lena, ‘Mot in pam saro a kisapi anun a Labino, mot in pam kodos anun a kum kisapi.’” ");
INSERT INTO kqw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","O Jon i ser emar nam in namalu di pami nama iwu na kamel, ma i ser ker wati nam in pino bulumakau. I ser wan a kum ko ma a polono tatos. ");
INSERT INTO kqw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A taro tagisapat o Jerusalem, ma tagun a kum tamtamon rop una papor Judia, ma tagun a kum tamon ra det kis milau a danim Jodan, det wan toromi. ");
INSERT INTO kqw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Det watung puaso anundet a kum sakino petutna, ra i baptaiso det una danim Jodan. ");
INSERT INTO kqw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","O Jon i tama a susut na Parisi tomo nama kum Sadusi det wan sur in baptaiso det, ra i watungi tandet lena, “Ai, mot a kum nutnutun a kum sui! Osi i inanos mot sur mot in kalabor eno gusun a warkurai na minabalu anun o God, ra in nanpat? ");
INSERT INTO kqw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mot in pam a kum utna ra in upuaso i lena, mot sa nukpukus. ");
INSERT INTO kqw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma gong mot nuki lena, o God ken warkurai mot uni mot a kabotaro anun o Abaram. A inanos mot lena, o God in pet lari sur in pam pat pas a kabotaro anun o Abaram tagun a kum watat ri. ");
INSERT INTO kqw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Di sa ubek tar a nawu nisan a kum kibino duwai, ma a kum duwai rop ra ka det wu lako wakak na windet, din tau ru det, ma din woro tar det una sungun. ");
INSERT INTO kqw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iau, a baptaiso mot nama danim sur in upuaso i lena mot sa nukpukus. Ikut i ra in mur tang a dekdekino i labo tan a dekdeking. Ka elar sur an los anun aru su, uni a natino sakit tano. In baptaiso mot nama Tokodos na Nion ma a sungun. ");
INSERT INTO kqw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I pam pas anun a pok nam aru lamano sur in lakro suaro a pino wit gusun a wino wit. Ra i sa timilo rop tari, in ubek tomo anun a wino wit una nuna rumu na wit, ra in tun ru a kum pinino una sungun ra ke ser mat.” ");
INSERT INTO kqw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","O Iesu i wan tagitong una papor Galili utiro una danim Jodan torom o Jon sur in baptaiso i. ");
INSERT INTO kqw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","O Jon i nem na turbati, ra i watungi tano lena, “Ilai ra u wan torom iau sur an baptaiso ui? In wakak sur ui un baptaiso iau.” ");
INSERT INTO kqw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ra o Iesu i balu i lena, “Un baptaiso iau kut. I wakak ra un pami, sur dar in pam sot pas asau rop ra i tokodos umatan o God.” Ra o Jon i tarom tano. ");
INSERT INTO kqw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ra i baptaiso tari. Uniutra o Iesu i saur gusun a danim, ra a langit i tapapos, ma i tama a Nion o God i wan pirso elar namin natabun ma i kis taru netes uni. ");
INSERT INTO kqw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Numur in nalngan ara tagisapat una langit i watungi lena, “Iri a Nutunglik, a nat na wakak, a gas doko nami.” ");
INSERT INTO kqw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Numur a Tokodos na Nion i mugu o Iesu usa una nubual kalako taro uni sur o Satan in lari. ");
INSERT INTO kqw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ra i sa wewel pas a wat na noino bung na mirum ma a wat na noino bung na waspi, i murak. ");
INSERT INTO kqw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ra a tene ululam i wanpat toromi, ma i watungi tano lena, “Ra ui a Nutun o God, un inanos a kum watat ri sur det in nanpat a beret.” ");
INSERT INTO kqw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","O Iesu i balu i lena, “Di sa tumus tari una Buk Tabu lena, ‘A taro ka det ser laun nama utna na inangon kut, det ser laun nama kum wasiso rop ra i pirso gusun a wan o God.’” ");
INSERT INTO kqw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Numur o Satan i ben pasi usapat o Jerusalem, a tamon anun o God, ra i utur tari sapat netes sakit una rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma i watungi tano lena, “Ra ui a Nutun o God, un sirok pirso, uni di sa tumus tari una Buk Tabu lena, ‘In tulu ru anun a kum ensel sur det in tamtamabat ui. Det in pam pas ui nama kum lamandet, sur gong u tuka a kikim un tu wat.’” ");
INSERT INTO kqw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","O Iesu i balu i lena, “Di sa tumus tari kai una Buk Tabu lena, ‘Gong u lar a Labino anum a God.’” ");
INSERT INTO kqw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","O Satan i ben melet pasi usapat netes una labino tangai, ra i ese tar a kum matanitu rop una rakrakon bual tomo nama kum minamar indet rop kai tano. ");
INSERT INTO kqw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ra i watungi tano lena, “ Ra un kis butkeke ma un lotu torom iau, a kum utna rop ri an pitar tari tam.” ");
INSERT INTO kqw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","O Iesu i watungi tano lena, “Satan, un nan gisen, uni di sa tumus tari una Buk Tabu lena, ‘Un lotu torom a Labino anum a God, ma un tarom kut toromi.’” ");
INSERT INTO kqw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Numur o Satan i wan pas gusuni, ra a kum ensel det wan toromi, ma det waruti. ");
INSERT INTO kqw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","O Iesu i longoro i lena, di sa uruk tar o Jon una karabus, ra i milet melet utong una papor Galili. ");
INSERT INTO kqw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ra i wan tagitong o Nasaret, i kis tiro o Kapernaum, a tamon ra i kis una usalin nisan a du tasi Galili, una piso anun a kabotaro Sebulon ma a kabotaro Naptali, ");
INSERT INTO kqw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","sur in pam sot pas a wasiso anun o God ra o Aisaia a poropet i sa wasiso mugu taru uni lena, ");
INSERT INTO kqw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A piso anun a kabotaro Sebulon ma a piso anun a kabotaro Naptali, milau a kisapi ra i wan unago utasi, una papor danim Jodan utong, der kis una papor Galili, ra a taro ra ausur a taro Juda det kis iai. ");
INSERT INTO kqw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A taro ra det kis una dumirum det sa tama a labino talapor, ma det ra a dumirum na minat i pulus bat det, a talapor i sa wanpat torom det.” ");
INSERT INTO kqw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Turpasi una kilalo ra, o Iesu i warawai lena, “Mot in nukpukus, uni a matanitu tagisapat una langit i sa milau.” ");
INSERT INTO kqw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ara bung o Iesu i usal una usalin ina du tasi Galili, ra i tama pas o Saimon, di watungi kai nam o Pita, ma a tisino o Endru. Der woro a bene sa utasi, uni der aru tene woro bene. ");
INSERT INTO kqw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I watungi tander lena, “Mur in mur iau, sur an ususer mur sur mur aru tene ben taro.” ");
INSERT INTO kqw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Uniutra, der katutur pas gusun anunder a kum bene, ma der muri. ");
INSERT INTO kqw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ra i wan tagitiro, i tama pas o Jems ma o Jon dersino, aru nutnutun o Sebedi. Detul tamano kis taru una pot ma detul mabon anundetul a kum bene. Ra o Iesu i kabo der. ");
INSERT INTO kqw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Uniutra, der katutur pas ma der wan gusun a pot ma a tamander, ra der mur o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","O Iesu i wan tuptupukus una papor Galili rop, ma i ususer a taro una nundet a kum rumu na lotu. I warawai nama Wakak na Wasiso una matanitu anun o God. Ma i ulangolango pas a taro gusun a kum wur ngas na misait. ");
INSERT INTO kqw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma a wasiso un o Iesu i wan sarara una papor Siria rop. Ra det ben rop pas a taro ra a kum wur ngas na misait i banlaulau det, a taro ra a dekdek na ngunungut i banlaulau det, ma det ra a kum laulau na nion kura un det, det kai ra det ser mat lalang ma det ra a pinpinindet i mat. Ra o Iesu i ulangolango pas det rop. ");
INSERT INTO kqw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma a labino kunur na taro taginin una papor Galili ma tagitiro una papor Dekapolis, ma tagisapat o Jerusalem, ma tagun a papor Judia ma tagitong una ara papor danim Jodan det mur o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","O Iesu i tama pas a kunur na taro, ra i wan toto una tangai, ma i kis. Anun a taro na ususer det wan toromi. ");
INSERT INTO kqw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma i ususer det lena, ");
INSERT INTO kqw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Det ra det tasmani lena det sibo una niondet, det dan, uni anundet a matanitu tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Det ra a balandet i tangis nama tupunuk, det dan, uni o God in umarom det. ");
INSERT INTO kqw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Det ra det unatino pas det, det dan, uni det in los pas a rakrakon bual sur anundet. ");
INSERT INTO kqw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Det ra det murak ma det muruk sur a tokodos na petutna, det dan, uni numur det in masur. ");
INSERT INTO kqw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Det ra a kum tene marmaris, det dan, uni o God in maris det kai. ");
INSERT INTO kqw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Det ra a nuknukindet i talapor ma katu dur, det dan, uni det in tama o God. ");
INSERT INTO kqw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Det ra det ser umolmol a taro, det dan, uni o God in watung det a kum nutnutunu. ");
INSERT INTO kqw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Det ra di banlaulau det uni det mur a tokodos na petutna, det dan, uni anundet a matanitu tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mot dan ra di watung laulau mot, ma di banlaulau mot, ma di watung a kum torotoro na wasiso un mot lena mot pam a kum sakino petutna, kibino un iau. ");
INSERT INTO kqw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mot in gas, uni i labo sakit anumot a ikul sapat una langit. Uni di sa banlaulau mugu a kum poropet ra det laun mugu tamot, lenkut kai ra di pami un mot. ");
INSERT INTO kqw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mot a sol una rakrakon bual rop. Ikut, ra makasman ino i sa rop, din umakasman meleti mo pepetlai? Katu utna mo i gas uni. Din woro upirso ru i unago utamon, ma a taro det in papapas mukut netes uni. ");
INSERT INTO kqw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mot a talapor una rakrakon bual rop. Tu tamon ra i kis netes una tangai, ken parau lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Katutaio in ungangon tar tu lam ra in wop bat tari nama paket, awu. Din ubek tari ut netes una nuna turtur, sur in talapor torom det rop ra det kis una rumu. ");
INSERT INTO kqw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lenkai ra, anumot a talapor in upuaso i umatan a taro, sur det in tama anumot a kum wakak na pinapam, ma det in watung ulabo pas a Tamamot ra i kis sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gong mot nuki lena a wanpat sur an rakon ru a kum Warkurai anun o Moses ma a kum etowo anun a kum poropet, awu. Ka wanpat sur an rakon ru det, a wanpat sur an pam sot pas det. ");
INSERT INTO kqw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A inanos mot nama lingmulus, katu nat na tumtumus lik o tu ukinalong lik tagun a kum Warkurai ri in rop, tuk ra a bakut ma a rakrakon bual der in rop. A kum Warkurai det in kis ut, tuk ra din pam sot pasi. ");
INSERT INTO kqw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Osi ra in lakai tu nat na warkurai tagun a kum Warkurai ri, ma in ususer raro a taro sur det kai det in lakai i, din watungi lena, i natino doko una matanitu sapat una langit. Ikut osi ra in tarom una kum Warkurai ri, ma in ususer a taro uni, din watungi lena, i labo una matanitu sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lenra, a watungi tamot, ra anumot a tokodos na petutna ken wakak tan a tokodos na petutna anun a kum tene ususer tagun a Warkurai ma a kum Parisi, mot in lagano ruk una matanitu sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mot sa longoro tari ra numugu di sa watung tari tan a taro lena, ‘Gong u um doko taio. Osi ra in um doko taio din warkurai i.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ikut iau, an watungi tamot lena, osi ra in kankan torom tu tisinolik, din warkurai i, ma osi ra in watungi un tu tisinolik lena, ‘Katin lorim,’ din warkurai i umatan a taro na kiwung. Ma osi ra in watungi un tu musano lena, ‘A longlong ui,’ kutiro a warkurai toromi, ra din woro i una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ra un nan sur un pitar anum a etabor una kabulu na tuntun etabor, ma u nuk pas tu utna ra o tisimlik i takun ui uni, ");
INSERT INTO kqw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","un ubek tar anum a etabor tiro nisan a kabulu na tuntun etabor. Un nan munung, ma mur in emarom mugu pas nam o tisimlik. Numur un milet melet, ma un pitari maragom anum a etabor. ");
INSERT INTO kqw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ra taio in ubek tar ui una warkurai, mur in emarom mugu ra mur wan nanan utmakai una kisapi, sako in pitar tar ui torom a tene warkurai. Ma a tene warkurai in mulaot ru ui torom a tene tamtamabat ra in uruk tar ui una karabus. ");
INSERT INTO kqw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A inanos ui nama lingmulus, kon pirso lar pas tuk ut ra un pitar rop ru a tintinip na toia ina num a kunukul. ");
INSERT INTO kqw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mot sa longoro tari ra di sa watung tari lena, ‘Gong u pam a sakino un tu ino anun taio.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ikut iau, an watungi tamot lena, ra tu musano in tama tar tu ino ma a nuknukino i laulau toromi, una nuknukino, i sa pam tar a sakino petutna una ino ra. ");
INSERT INTO kqw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ra in nosot na matam in ben raro ui sur a sakino, liok ru i, ma un woro gisen ru i. In wakak ra ara du pinim kut din woro ru i, sur gong di woro a pinim rop una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ra a sot na lamam in ben raro ui sur a sakino, kutus ru i, ma un woro gisen ru i. In wakak ra ara du pinim kut din woro ru i, sur gong di woro a pinim rop una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Di sa watung tari kai lena, ‘Osi ra i lakro ru anun a ino, in pitar tari kai a dono buk na kutus nolin tano.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ikut iau, a watungi tamot lena, ra a ino ke pam a sakino nam tu musano, ma anun a musano i lakro oros ru i kut, ma a ino i nolin melet, i pam a sakino. Ikut anun a musano, i kibino una sakino ra. Ra tu musano in nolin nam tu ino ra anun a musano i lakro ru i, i kai i sa pam a sakino, uni a ino ra, i nolin ut. ");
INSERT INTO kqw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mot sa longoro tari kai ra numugu di sa watung tari tan a taro lena, ‘Gong u liliman torotoro. A utna ra u sa liliman taru uni torom a Labino, un pam sot i ut.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ikut iau, a watungi tamot lena, gong mot udekdek a liliman nam tu ngas na wasiso kai. Gong mot liliman nama langit, uni a langit i a kiskis na king anun o God. ");
INSERT INTO kqw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Gong mot liliman nama rakrakon bual, uni a rakrakon bual a nubual ra i ubek aru kikino uni. Gong mot liliman nam o Jerusalem, uni o Jerusalem a tamon anun a labino King. ");
INSERT INTO kqw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gong u liliman nam in lorim, uni kon pam pukus lar pas tin iwu na lorim sur in kabang, o in mirum. ");
INSERT INTO kqw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mot in watungi kut lena ‘ma’ o ‘awu’. Uni, ra mot in watung tu ngas na wasiso melet, i ra i wanpat mukut gusun a Tene Sakino. ");
INSERT INTO kqw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mot sa longoro tari ra di sa watung tari lena, ‘Ra taio in liok ru tin matan taio, din balu i kai toromi, din liok ru i kai tin matano. Ma ra taio in tubul pak ru tin lokon taio, din balu i kai toromi, din tubul pak ru i kai tin lokono.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ikut iau, an watungi tamot lena, gong mot balu a sakino anun taio ra i pami torom mot. Ra taio i pasor tar a papor sot na wam, un pukus ara papor bulung toromi. ");
INSERT INTO kqw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ra taio i nemi sur in dat tar ui una warkurai ma din pitar a warkurai tam sur un pitar anum a siot tano, un pitar tari kai anum in namalu ra u ser rakup bat anum a ememar nami. ");
INSERT INTO kqw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ra taio i ungongos pas ui sur mur in nan tomo sur tu tamon ra i milau kut, io un nan tomo nami sur a tamon ra i kis bakbak lilik. ");
INSERT INTO kqw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Un tabor taio ra i saring ui. Ma ra taio in saring ui sur in los pasi munung tu utna gusun ui, un pitari kut munung tano. ");
INSERT INTO kqw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mot sa longoro tari ra di sa watung tari lena, ‘Un nem a pasam, ma un nget anum a ebar.’ ");
INSERT INTO kqw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ikut iau, an watungi tamot lena, mot in nem anumot a kum ebar, ma mot in wararing un det ra det banlaulau mot. ");
INSERT INTO kqw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ra mot in pami lenra in ese i lena mot a kum nutnutun a Tamamot, ra i kis sapat una langit. Uni i pitar tar a suan sur in talapor una kum sakino taro ma a kum wakak na taro kai, ma i pitar tar a bato torom a kum tene tokodos ma torom det kai ra ka det tokodos. ");
INSERT INTO kqw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ra mot nem det kut ra det nem mot, asau mo anumot a ikul? A kum tene los takis, ra ka det lason una marmaris det pampami kai lenra, niko? ");
INSERT INTO kqw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ra mot gas pasi kut sur a kum paspasamot, mot in wakak pepetlai? A taro kai ra ka det nurnur det gasgas pasi kut sur a kum paspasandet, niko? ");
INSERT INTO kqw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikut, mot in tokodos mulus, elar nama Tamamot ra i kis sapat una langit, i tokodos mulus. ");
INSERT INTO kqw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mot in tumarong mot sur gong mot pam anumot a wakak na pinapam umatan a taro kut, sur det in tama i ma det in watung ulabo pas mot. Ra mot pami lenra, katu ikul anumot tan a Tamamot ra i kis sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ra un tabor a kum sibo na taro, gong u wasiso mugu sur a taro det in tama ui. A taro ra ka det etabor nama lingmulus una balandet, det ser wasiso mugu nam anundet a etabor una kum rumu na lotu ma una kum kisapi kai, sur a taro det in watung ulabo pas det uni. Gong mot pami elar nam det. A inanos mot nama lingmulus, ra a taro det ulabo pas det, i ut ra anundet a kudulano ikul. ");
INSERT INTO kqw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ra un tabor a kum sibo na taro, gong taio i tasman a utna ra u pami, un pam eno i kut. ");
INSERT INTO kqw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ra u pami lenra, o Tamam ra i tama a utna ra u pam eno i, in pitar a ikul tam. ");
INSERT INTO kqw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ra mot in wararing, gong mot elar nama kum tene torotoro. Det nem doko i sur det in tur ma det in wararing una kum rumu na lotu, ma una kum nubual ra a taro det wanan tomo iai, sur a taro det in tama det ma det in watung ulabo pas det. A inanos mot nama lingmulus, ra a taro det ulabo pas det, i ut ra anundet a kudulano ikul. ");
INSERT INTO kqw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ikut ui, ra un wararing, un ruk una num a rumu ma un tagar bat pas ui, ma un wararing torom o Tamam ra ka taio i tama i. Ma o Tamam ra i tama a utna ra u pam eno i, in pitar anum a ikul. ");
INSERT INTO kqw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ra mot in wararing, gong mot wasiso oros kut, elar nama kum niaring anun a taro ra det lotu torom a kum toktok. Uni det nuki lena din longoro det ra det watung a susut na wasiso. ");
INSERT INTO kqw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gong mot elar nam det, uni a Tamamot i sa tasman tar asau rop ra mot sibo suri, ra ka mot wararing utmakai. ");
INSERT INTO kqw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mot in wararing lenri, ‘Tamamet sapat netes una langit, i wakak ra din ru a risam. ");
INSERT INTO kqw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I wakak ra anum a matanitu in nanpat. I wakak ra din mur anum a nemnem nin una rakrakon bual, elar nami ra di ser muri sapat netes una langit. ");
INSERT INTO kqw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A bung ri un tabor met nam amet a utna na inanangon. ");
INSERT INTO kqw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Un dumano ru anumet a kum sakino petutna, elar nam met dumano ru anundet a kum sakino petutna torom met. ");
INSERT INTO kqw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gong u ben met una ululam. Un ulaun met gusun a Tene Sakino. Amen.’ ");
INSERT INTO kqw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ra mot in dumano ru a kum sakino petutna ra a taro det pami torom mot, a Tamamot, ra i kis sapat una langit, in dumano ru anumot a kum sakino petutna kai. ");
INSERT INTO kqw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ikut, ra ka mot dumano ru a kum sakino petutna, ra a taro det pam tari torom mot, a Tamamot kai ken dumano ru anumot a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ra mot in wewel sur mot in wararing, gong mot tamtama tumtumul elar nama kum tene torotoro, uni det tamtama tumtumul sur a taro det in tama i lena det wewel. A inanos mot nama lingmulus, ra a taro det ulabo pas det lena det a kum tene lotu mulus, i ut ra anundet a kudulano ikul. ");
INSERT INTO kqw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ra un wewel, un kom in lorim, ma un gos in masarim, ");
INSERT INTO kqw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sur gong a taro det tasmani lena u wewel. O Tamam kut, ra ka taio i tama i, in tasmani. Ma o Tamam ra i tama a utna ra u pam eno i, in pitar anum a ikul. ");
INSERT INTO kqw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gong mot ubek tomo a kum wakak na ululeng nin upiso, uni a koropos ma a moroto der in banlaulau ru det kut, ma a kum tene wolong kai det in rege pas anumot a kum rumu ma det in los a kum ututna. ");
INSERT INTO kqw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mot in mur a kum tokodos na petutna sur in elar nama wakak na ululeng sapat una langit, uni a koropos ma a moroto ka der in banlaulau i, ma a kum tene wolong kai ka det in wolong lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Uni anum a nilaun in kis una nubual ra anum a wakak na ululeng i kis iai. ");
INSERT INTO kqw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Arin matandat der elar nama lam una pinindat. Ra arin matam der wakak, a pinim rop in bukus nama talapor. ");
INSERT INTO kqw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ikut, ra arin matam der laulau, a pinim rop in bukus nama dumirum. Ra anum a talapor i dumirum kut, a dumirum ra in labo sakit! ");
INSERT INTO kqw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Katu tultul in pet lar pasi sur in papam torom lako ru mugumugu. In nget ara pasander, ma in gas sur ara pasander, in tarom torom ara, ma in rosumur gusun ara. Ka mot in papam lar pasi torom o God ma torom a mani kai. ");
INSERT INTO kqw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Uniri an watungi tamot lena, gong mot nuknuk doko una numot a nilaun sur asau mot in nani, ma asau mot in inumi. Ma gong mot nuknuk doko una pinimot kai sur asau mot in emar nami. A nilaun i labo tan a utna na inangon, niko? Ma a pinindi kai i labo tan a malu, niko? ");
INSERT INTO kqw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mot in tama a kum piko. Ka det marut tu utna, ma ka det pasong tomo lako utna, ma ka det umubek tomo un tu rumu, ikut a Tamamot ra i kis sapat una langit, i ser tabor det. Ra mot, mot labo sakit tandet. ");
INSERT INTO kqw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Osi tamot ra i nuknuk doko una nuna nilaun, ken pet lari sur in tugus walos melet tu du bung lik uni. Awu. ");
INSERT INTO kqw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ilai ra mot nuknuk doko sur a malmalu? Mot in tama a kum purpur tagisa ubual, ra det lubung pepetlai. Ka det ser papam ma ka det ser pam malu. ");
INSERT INTO kqw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ikut a watungi tamot, a minamar rop anun o King Solomon ut i tamtama wakak bing, ikut ke tamtama wakak elar nama kum purpur ra. ");
INSERT INTO kqw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","O God i mar a kum wuliso sa ubual nama kum wakak na purpurindet, ra i puspus uniri, ra markan din tun ru i una sungun. Ra i pami lenra una kum wuliso, pepetlai, ken mar mot kai? I natino doko anumot a nurnur. ");
INSERT INTO kqw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Gong mot nuknuk doko ma mot watungi lena, ‘Asau dat in nani?’, o ‘Asau dat in inumi?’, o ‘Asau ra dat in emar nami?’ ");
INSERT INTO kqw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Uni a taro ra ka det nurnur det nemnem doko sur a kum utna rop ri, ikut a Tamamot ra i kis sapat una langit i tasmani lena mot sibo sur a kum utna rop ri. ");
INSERT INTO kqw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mot in nuknuk mugu sur anun a matanitu ma anun a tokodos na petutna, ra in tabor mot kai nama kum utna rop ri. ");
INSERT INTO kqw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ra gong mot nuknuk doko sur a bung markan, uni markan in nuknuk ut suri. A ninunuk sur ara bung taktakai i to pasi ut a bung ra. ");
INSERT INTO kqw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gong mot takun tar taio, sur gong kai o God i takun tar mot. ");
INSERT INTO kqw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Uni a warkurai ra mot takun taio nami, i ut ra o God in takun mot melet nami. Asi na ngas na warkurai ra mot takun taio nami, ra i tokodos o ke tokodos, i ut ra o God kai in takun mot melet nami. ");
INSERT INTO kqw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ilai ra u tama pasi kut a burbururup kura un in matan o tisimlik, ma ko nuk pas a nuduwai pi kura ut un in matam? ");
INSERT INTO kqw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ra a nuduwai pi kura kut un in matam, un watung petlani torom o tisimlik lena, ‘An rakon ru a burbururup gusun in matam’? ");
INSERT INTO kqw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ui a tene torotoro, un los mugu ru a nuduwai pi gusun in matam, ra un tamtama wakak, sur un rakon ru a burbururup gusun in matan o tisimlik. ");
INSERT INTO kqw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gong mot tabor a kum pap nama utna anun o God, sako det in tupukus ma det in karot ginogino mot. Ma gong mot woro anumot a dusaro tan a kum boro, sako det in pas ginogino i kut nama kum kikindet. ");
INSERT INTO kqw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mot in sasaring, ra din tabor mot, mot in sisio, ra mot in sio pasi, mot in pinpidik, ra din papos saro mot. ");
INSERT INTO kqw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Uni det rop ra det sasaring din tabor det, ma i ra i sisio in sio pasi, ma i ra i pinpidik, din papos saro i. ");
INSERT INTO kqw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Osi na pasamot, ra a nutunulik in saringi sur tu beret, in tabori kut nama wat? ");
INSERT INTO kqw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma ra in saringi kai sur tin kiripo, in tabori kut nam in nusui? ");
INSERT INTO kqw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mot a kum sakino taro, ikut mot tasmani ut a kum wakak na etabor sur mot in tabor a kum nutnutumot nami. Ra mot ser pami lenra, i lingmulus sakit lena, ra osi in saring a Tamamot ra i kis sapat una langit, in tabori ut nama kum wakak na utna. ");
INSERT INTO kqw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","A kibin a wasiso na Warkurai anun o Moses, ma a kum etowo anun a kum poropet i lenri: A kum utna rop ra mot nemi sur a taro det in pami torom mot, mot kai, mot in ser pami torom det. ");
INSERT INTO kqw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mot in ruk una nat na matansako lik. Uni a matansako ma a kisapi ra i wan sur a iniru tukum, i perere ma i langolango, ma a susut na taro doko det ser ruk uni. ");
INSERT INTO kqw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ikut a matansako ma a kisapi ra i wan sur a nilaun, i natino, ma a pak na taro kut det ser sio pasi. ");
INSERT INTO kqw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mot in tumarong mot gusun a kum torotoro na poropet. Det ser wan torom mot nama wakak na magirandet elar nama kum sipsip, ikut tiro ubalandet, det nem na banlaulau mot elar nama kum ngalngalia na pap. ");
INSERT INTO kqw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mot in tama lele a kum torotoro na poropet tagun a windet ut. Pepetlai, din git pas in niwino wain tagun in kandas, ma in niwino fig tagun in suksuk? Awu, ken elar! ");
INSERT INTO kqw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lenkutkai ra a kum wakak na duwai rop det ser wu a wakak na windet, ikut in laulau na duwai i ser wu a kum laulau na wino. ");
INSERT INTO kqw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","In wakak na duwai ken wu lako laulau na wino, ma in laulau na duwai kai ken wu lako wakak na wino. ");
INSERT INTO kqw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A kum duwai rop ra ka det wu a wakak na windet, din tau ru det, ma din woro tar det una sungun. ");
INSERT INTO kqw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ra mot in tama lele a kum torotoro na poropet tagun a windet ut. ");
INSERT INTO kqw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Det ra det watung iau lena, ‘Labino, Labino,’ ausur det rop det in ruk una matanitu sapat una langit. Det sot kut, ra det ser mur a nemnem anun o Tita, ra i kis sapat una langit, det in ruk una nun a matanitu. ");
INSERT INTO kqw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Una bung na warkurai a susut det in watungi tang lena, ‘Labino, Labino, met wasiso na poropet nama risam, ma met lakro ru a kum laulau na nion kai nama risam, ma met pam a susut na utna na ukisin nama risam.’ ");
INSERT INTO kqw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","An balu det lena, ‘Ka tasman mot. Mot a kum tene sakino, mot in nan gisen gusun iau.’ ");
INSERT INTO kqw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Det rop ra det longoro anung a kum wasiso ri, ma det tarom uni, det elar nama tene mananos, ra i pam tar anun a rumu netes una wat. ");
INSERT INTO kqw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A bato i puku, ra a lomom i wanpat, ma a wuwu i ragoti ra i um a rumu ra, ikut ke toropo lar pas, uni di utur tari netes una wat. ");
INSERT INTO kqw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Det rop ra det longoro anung a kum wasiso ri, ikut ka det muri, det elar nama longlong, ra i pam tar anun a rumu netes kut una woio, ma ke por dekdek a kum pagopago. ");
INSERT INTO kqw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A bato i puku, ra a lomom i wanpat, ma a wuwu i ragoti ra i um a rumu ra, i toropo, ma i terege laulau mut.” ");
INSERT INTO kqw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ra o Iesu i sa watung rop tar a kum wasiso ri, a kunur na taro det kisin una nuna kum etowo, ");
INSERT INTO kqw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","uni i ususer det elar nam ara, ra a warkurai kura ut tano. Ke ususer det elar nam anundet a kum tene ususer tagun a Warkurai. ");
INSERT INTO kqw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ra o Iesu i wan pirso tagisapat una tangai, a susut na taro det muri. ");
INSERT INTO kqw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ara musano, i misait nama lepra, i wan toromi, i kis butkeke nisano, ma i watungi lena, “Labino, ke ngangitin torom ui. Ra u nemi un ulangolango pas iau.” ");
INSERT INTO kqw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","O Iesu i kodos a lamano, ma i pam a pinino, ra i watungi tano lena, “A nemi ut, un langolango.” Uniutra a misait i rop gusuni. ");
INSERT INTO kqw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ra o Iesu i watungi tano lena, “Gong u inanos tar taio nami. Un nan ma un ese mugu tar ui torom a tene etabor torom o God, ma un pitar a etabor torom o God elar nami ra o Moses i sa watung tari. Ra un pami lenra, in talapor torom a taro lena u sa langolango.” ");
INSERT INTO kqw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ra o Iesu i sa wanpat tong o Kapernaum, ara mugumugu anun a kum tene inaim tagitong o Rom i wan toromi, ra i inanosi sur in waruti. ");
INSERT INTO kqw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I watungi lena, “Labino, ara tultul anung kurong ut una rumu i inep, a pinino rop i mat, ma i taramo a dekdek na ngunungut doko.” ");
INSERT INTO kqw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","O Iesu i watungi tano lena, “An nan ma an ulangolango pasi.” ");
INSERT INTO kqw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A mugumugu ra i balu i lena, “Labino, ka tokodos sur un ruk una nung a rumu. Un watung tu wasiso kut, ra anung a tultul in langolango. ");
INSERT INTO kqw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Uni iau a musano ra a ser tarom una warkurai anundet ra det labo tang, ma di pitar tar a warkurai kai tang sur a taro na inaim. Ra an watungi tan taio lena, ‘Un nan,’ in nan kut. Ma torom taio kai lenri, ‘Un nan urin,’ in nan kut urin. Ma torom anung a tultul lena, ‘Un pam a utna ri,’ in pami kut.” ");
INSERT INTO kqw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","O Iesu i longoro anun a wasiso, ra i kisin doko uni, ma i watungi torom a taro ra det muri lena, “A inanos mot nama lingmulus, ka tama tar tu te Israel ra anun a nurnur i labo elar nama musano ri. ");
INSERT INTO kqw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A watungi tamot lena kura munung a susut na taro det in nan tagitiro na matmatano tobar ma a matmatano lubur, ra det in kis tomo nam o Abaram, o Aisak ma o Jekop una labino bung na lotu una matanitu sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ikut, a taro Israel ra numugu o God i pilok pas det sur det in kis una nuna matanitu, in lu pirso ru a susut gusun det utiro una dumirum. Ra det in tangtangis ma det in ungingit lokondet iai.” ");
INSERT INTO kqw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ra o Iesu i watungi tan a mugumugu anun a kum tene inaim lena, “Un nan kut. Din pam a utna ut ra u nurnur suri.” Una du bung ut ra anuna tultul i langolango mut. ");
INSERT INTO kqw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","O Iesu i ruk una rumu anun o Pita, ra i tama a ino, a inumun o Pita, i misait nama pino mararong, kura i inep una kabulu. ");
INSERT INTO kqw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O Iesu i pam a lamano, ra a mararong i rop mut gusuni. A ino ra i katutur, ra numur i tabor o Iesu nama utna na inangon. ");
INSERT INTO kqw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ra in matanas i sa sup taru, di ben pat a susut na taro torom o Iesu ra a kum laulau na nion kura un det. I lakro ru a kum laulau na nion nama wasiso kut, ma i ulangolango pas det rop, ra det misait. ");
INSERT INTO kqw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A utna ri i wanpat sur din pam sot pas a kum wasiso, ra a poropet Aisaia i sa wasiso taru uni lenri, “I ut i los pas anundat a kum misait, ma i rakon ru anundat a kum ngunungut.” ");
INSERT INTO kqw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ra o Iesu i tama a kunur na taro ra det tur talilis pasi, i watungi tan anun a kum nat na ususer lena, “Dat nan utong una ara papor tasi.” ");
INSERT INTO kqw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma ara tene ususer tagun a Warkurai i wan toromi, ra i watungi tano lena, “Tene Ususer, an mur ui una kum tamtamon rop ra un nan iai.” ");
INSERT INTO kqw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ra o Iesu i watungi tano lena, “A kum kuabor na pap anundet a kum tung ut, ma a kum piko kai anundet a kum pios ut, ikut a Nutun a Musano katu rumu na ininep.” ");
INSERT INTO kqw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma ara musano kai, tagun anun a taro na ususer i watungi tano lena, “Labino, un mulaot ru iau munung sur an nan, sur an por ru tar o tita.” ");
INSERT INTO kqw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ikut o Iesu i watungi tano, “Un mur iau, ma un madek ru a kum minat det in por anundet a kum minat.” ");
INSERT INTO kqw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ra o Iesu i kas una pot, anuna kum nat na ususer det kas numurunu. ");
INSERT INTO kqw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Numur a dekdek na wuwu doko i wanpat kisin ma i ragoti un det una du tasi. A top i tapak sapat netes una pot. Ikut o Iesu i inep dumun, ");
INSERT INTO kqw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ra det wan toromi, det wangun pasi, ma det inanosi lena, “Labino, un ulaun dat. Dat na iru.” ");
INSERT INTO kqw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma i watungi tandet lena, “Anumot a nurnur i natino doko. Sur asau ra mot ngara?” I katutur ra i turbat a wuwu ma a top, ra i mililo rop. ");
INSERT INTO kqw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ra a kum nat na ususer det kisin uni, ma det watungi lena, “Osi na ngas na musano mulus ri? A wuwu ma a top der tarom tano!” ");
INSERT INTO kqw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","O Iesu i sot una ara papor tasi, una papor anun a taro Gadara. Aru musano ra a kum laulau na nion kura un der, der wan gusun a kum kulam na minat, ra der wan barato i. Der ngalngalia doko, ma kataio i ser wan sakit tiro una kisapi ra. ");
INSERT INTO kqw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Der woiwoi lena, “Nutun o God, asau u nem na pami un mir? Pepetlai, u wan urin sur un ukadik met? Ke sot utmakai a bung na warkurai.” ");
INSERT INTO kqw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A kabo liur na boro det wangon milau kut tiro iai. ");
INSERT INTO kqw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ra a kum laulau na nion det inanos dekdek o Iesu lena, “Ra un lakro ru met, un tulu ruk tar met utiro una kum boro.” ");
INSERT INTO kqw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O Iesu i watungi tandet lena, “Mot nan!” Ra a kum laulau na nion det pirso gusun aru musano ra, ma det ruk una kum boro. A kum boro det kalabor pirso una palis sur a du tasi, ra det kongo rop. ");
INSERT INTO kqw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A taro ra det ser tabor a kabo liur na boro ra, det kalabor tupukus melet sur anundet a tamon. Ra det wanpat, det inanos una kum utna rop ra i wanpat, ma un der kai, ra a kum laulau na nion numugu det kis taru un der. ");
INSERT INTO kqw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A taro rop tagun a tamon ra, det wan sur det in tama o Iesu. Ra det tama pasi, det inanosi sur in nan gisen gusun anundet a papor. ");
INSERT INTO kqw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","O Iesu i kas una pot, ra i wan kutus utiro una ara papor du tasi sur anuna tamon. ");
INSERT INTO kqw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ra a ramano kum musano det los pat ara musano toromi, a pinino i mat ma i inep taru kut una bat. O Iesu i tama anundet a nurnur, ra i inanos a musano ra lena, “Nutunglik, gong u ngara, di sa dumano ru anum a kum sakino petutna.” ");
INSERT INTO kqw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A ramano kum tene ususer tagun a Warkurai det wasiso etalai torom det ut lena, “A musano ri i watung laulau o God, uni i wasiso lenra i nuki lena i o God.” ");
INSERT INTO kqw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma o Iesu i tasman a nuknukindet, ra i ting det lena, “Sur asau ra mot nuknuk laulau? ");
INSERT INTO kqw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Asi na ngas na wasiso an watungi, sur an ese a dekdeking nami torom mot? Pepetlai, an watungi lena, ‘Di sa dumano ru anum a kum sakino petutna,’ o, an lena, ‘Un katutur, ma un nan’? ");
INSERT INTO kqw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","An watungi lenri, sur mot in tasmani lena, o God i pitar a warkurai torom a Nutun a Musano, sur in dumano ru a kum sakino petutna nin upiso.” Ra i watungi torom a musano a pinino i mat lena, “Un katutur, un los anum a bat, ra un nan sur anum a rumu.” ");
INSERT INTO kqw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I katutur mut, ra i wan sur anun a rumu. ");
INSERT INTO kqw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A kunur na taro det tama i, ra det kisin doko uni, ma det rakon lekeleke pas a risan o God, uni i pitar a dekdek lenri torom a musano ri. ");
INSERT INTO kqw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","O Iesu i wan tagitiro iai, ra i tama pas ara musano, a risano o Matiu, i kis una rumu na los takis. O Iesu i inanosi lena, “Un mur iau.” Ra o Matiu i katutur ma i muri. ");
INSERT INTO kqw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Numur o Iesu ma anun a kum nat na ususer, det wangon tiro una rumu anun o Matiu. A susut na tene los takis ma a kum tene sakino det wan torom o Iesu, ra det wangon tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ra a kum Parisi det tama i, det ting anuna kum nat na ususer lena, “Sur asau ra anumot a tene ususer i wangon tomo nama kum tene los takis ma a kum tene sakino?” ");
INSERT INTO kqw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","O Iesu i longoro i ra i watungi lena, “A dokta ke wanpat sur det ra det langolango. Awu! I wanpat sur det kut ra det misait. ");
INSERT INTO kqw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mot in nan, ma mot in ususer sur mot in tasman a kukuraina wasiso ri tagun a Buk Tabu, ‘A nem a marmaris, ma ka nem a etabor ra di ser tuni.’ Uni ka wanpat sur an kabo pas a kum tene tokodos, awu. A wanpat sur an kabo pas a kum tene sakino.” ");
INSERT INTO kqw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A kum nat na ususer anun o Jon det wan torom o Iesu, ra det tingi lena, “Sur asau ra met ma a kum Parisi met wewel, ikut anum a kum nat na ususer awu?” ");
INSERT INTO kqw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O Iesu i balu det lena, “A kum paspasan a musano ra i nem na nolin det in domos pepetlai ra kura utmakai i tomo nam det? Tu bung in nanpat, ra din ben ru i gusun det, ra det in wewel maragom. ");
INSERT INTO kqw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Katutaio in mabon a du matok na malu tomo nama turaino ra i tararos, sako a du matok na malu in raros a turai na malu, ra in tararos bing. ");
INSERT INTO kqw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kataio in titior a matok na wain utiro un in turai na koto ra di pami nam in pino meme, sako in nokoto in tupurus ma in laulau, ra a wain in tilingis. Din titior a matok na wain ut utiro un in matok na koto na wain, sur der rop der in kis wakak.” ");
INSERT INTO kqw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ra o Iesu i wasiso utmakai torom det, ara mugumugu i wan toromi, ra i kis butkeke sa numugu tano, ra i watungi lena, “A nutunglik a ino, unikutri i mat. Aiap, dar in nan ma un ubek a lamam sapat netes uni, sur in laun.” ");
INSERT INTO kqw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ra o Iesu i katutur ra der wan, det tomo nam anun a kum nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ara ino ra i misait nama gap elar nama noino ma aru kilalo i nuki lena, “Ra an tuki kut anun a kolos, an langolango.” Ra i wan numur tan o Iesu, ma i tuk tar a sinisir na kolos anunu. ");
INSERT INTO kqw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O Iesu i tur tupukus ra i tama a ino ra, ra i watungi tano lena, “Nutunglik, gong u ngara, anum a nurnur i sa ulangolango pas ui.” Ra una du bung ut ra a ino ra i langolango mut. ");
INSERT INTO kqw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","O Iesu i wanpat una rumu anun a mugumugu, ra i tama a taro ra det ese anundet a tupunuk una minat. Det wup a kum tulal, ma a susut na taro kai det domos. ");
INSERT INTO kqw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I watungi tandet lena, “Mot in pirso saro i. A ino lik ri ausur i mat, i inep dumun kut.” Ra det nongoni kut. ");
INSERT INTO kqw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ra o Iesu i sa tulu pirso ru a taro, i ruk ra i pam a laman a ino lik, ra i katutur mut. ");
INSERT INTO kqw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A wasiso una utna ri i wan sarara una papor rop ra. ");
INSERT INTO kqw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","O Iesu i wan tagitiro, ra aru musano, aru pulu, der muri, der kakabo dekdek lena, “Nutun o Dewid, un maris mir.” ");
INSERT INTO kqw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ra i ruk una rumu, aru pulu der wan toromi, ma i ting der lena, “Pepetlai, mur nurnur ut un iau sur an pam sot pas a utna ri?” Der balu i lena, “Ma, Labino.” ");
INSERT INTO kqw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ra i pam arin matander ma i watungi lena, “Din pami torom mur elar nami, ra mur nurnur suri.” ");
INSERT INTO kqw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ra der tamtama mut. Ra o Iesu i sakbat dekdek tar der lena, “Gong mur inanos tar taio nami.” ");
INSERT INTO kqw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ikut, der wan ra der inanos nanan nam o Iesu una papor rop ra. ");
INSERT INTO kqw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ra aru pulu der wan nanan utmakai gusun o Iesu, di ben tar ara musano bulung toromi, i ngat, ma a laulau na nion kura uni. ");
INSERT INTO kqw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O Iesu i lakro ru a laulau na nion gusuni, ra a musano ra i wasiso maragom. Ma a kunur na taro det kisin, ra det watungi lena, “Telek ri di tama a utna lenri nin o Israel.” ");
INSERT INTO kqw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ikut a kum Parisi det watungi lena, “I ser lakro ru a kum laulau na nion nama dekdek ina labino anun a kum laulau na nion.” ");
INSERT INTO kqw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","O Iesu i wan una kum lamlabino tamon ma a kum natnat na tamon rop. Ra i ususer a taro una nundet a kum rumu na lotu, ma i warawai nama Wakak na Wasiso una matanitu anun o God, ma i ulangolango pas a taro gusun a kum wur ngas na misait. ");
INSERT INTO kqw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ra i tama a kunur na taro, i maris doko det, uni i talara a nuknukindet, ma det pot na marmaris, elar kut nama kum sipsip ra katu tene tamtamabat anundet. ");
INSERT INTO kqw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ra i watungi tan anun a kum nat na ususer lena, “A kinobot i sa makus, ma i sa labo doko, ikut ke susut a kum tene pasong. ");
INSERT INTO kqw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mot in saring a Labino, i ra a taman a kinobot, sur in tulu ru a kum tene pasong sur ana kinobot.” ");
INSERT INTO kqw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","O Iesu i kabo pas anun a noino ma aru nat na ususer ra i pitar a dekdek tandet sur det in lakro ru a kum laulau na nion, ma sur det in ulangolango pas a taro gusun a wur ngas na misait. ");
INSERT INTO kqw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iri a kum risan a noino ma aru aposel: A mugano, o Saimon ara risano kai ra o Pita, dersino nam o Endru, o Jems ma o Jon der sino, aru nutnutun o Sebedi, ");
INSERT INTO kqw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","o Pilip, o Batolomiu, o Tomas, o Matiu a tene los takis, o Jems a nutun o Alpius, ma o Tadius, ");
INSERT INTO kqw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma o Saimon ara tagun a taro Silot, ma o Judas Iskariot, i ra i usobor tar o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","O Iesu i tulu ru a noino ma aru nat na ususer, ra i watungi tandet lena, “Gong mot wan torom a taro ra ausur a taro Israel, ma gong mot wan una kum tamon anun a kum te Samaria. ");
INSERT INTO kqw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mot in nan kut torom a taro Israel, ra det raro elar nama kum sipsip. ");
INSERT INTO kqw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ra mot nan, mot in warawai nanan lenri, ‘A matanitu tagisapat una langit i sa milau.’ ");
INSERT INTO kqw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mot in ulangolango pas a kum misait, ma mot in ulaun pas a kum minat, mot in ulangolango pas a kum lepra, ma mot in lakro ru a kum laulau na nion. Di tabor oros mot kut, lenkai ra, mot in etabor oros kut. ");
INSERT INTO kqw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gong mot silapo tu mani una numot a kum malu. ");
INSERT INTO kqw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gong mot los tu rat una numot a inawan, gong tin namalu na kelkeles, gong tu su, ma gong tin nubuku. Uni i tokodos sur din tabor a tene pinapam nama ana utna. ");
INSERT INTO kqw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ra mot in nan una kum lamlabino tamon, ma a kum natnat na tamon, mot in sisio sur taio ra i wakak, ma mot in kis nisano tuk una bung ra mot in nan gusun a tamon ra. ");
INSERT INTO kqw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ra mot in ruk un tu rumu, mot in wasiso na ugasgas pas det. ");
INSERT INTO kqw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ra a taro tagun a rumu ra det in gas pas mot, mot in ruk ma mot in watungi lena, ‘A malmal in kis torom mot.’ Ikut ra ka det in gas pas mot, anumot a malmal mot in los melet pasi. ");
INSERT INTO kqw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ra taio ke gas pas mot, ma ke longoro anumot a wasiso, ra mot in nan gusun anun a rumu, o a tamon ra, mot in tang ru a kubus gusun a kikimot. ");
INSERT INTO kqw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A inanos mot nama lingmulus, una bung na warkurai, a warkurai torom o Sodom ma o Gomora in dekdek, ikut torom a tamon ra, in laulau doko. ");
INSERT INTO kqw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tama i, iri a tulu ru mot elar nama kum sipsip epotor tan a kum ngalngalia na pap. Mot in mananos wakak elar nama kum sui, sur gong taio i ben raro mot, ma mot in tokodos elar nama kum tabun, sur gong taio i takun mot. ");
INSERT INTO kqw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mot in tumarong mot, uni a taro det in pitar mot ulaman a kum tene warkurai, ma det in miras mot una nundet a kum rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma din dat mot utiro una kum warkurai numugu umatan a kum lamlabino mugumugu ma a kum king, i kibino un iau. Mot in wasiso talapor un iau torom det ma torom a taro ra ausur a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ra din dat pas mot, gong mot nuknuk bing sur asau mot in watungi, ma mot in wasiso pepetlai, uni una du bung ut ra, o God in unuk tar mot nama wasiso ra mot in watungi. ");
INSERT INTO kqw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ausur mot ra mot in wasiso, a Nion a Tamamot ut in unuk tar mot nam asau ra mot in watungi. ");
INSERT INTO kqw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Taio in mulaot ru tu tisino sur din um doko i, ma tu musano in mulaot ru tu nutunu sur din um doko i. Ma a kum nat det in tur na inaim torom a tamandet ma a nandet ma det in mulaot ru a tamandet ma a nandet sur din um doko der. ");
INSERT INTO kqw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma a taro rop det in nget mot kibino una risang, ikut osi ra in tur dekdek tuk anun a nilaun in rop, o God in ulauni. ");
INSERT INTO kqw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ra det in banlaulau mot un tu tamon, mot in kalabor utiro un tu tamon gisen. A inanos mot nama lingmulus, ra ka mot in nan rop utmakai utiro una kum tamtamon nin o Israel, a Nutun a Musano in nanpat. ");
INSERT INTO kqw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A nat na ususer ke labo taun anun a tene ususer, ma a tultul kai ke labo taun anun a labino. ");
INSERT INTO kqw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I to pasi sur a nat na ususer in elar kut nam anun a tene ususer ma a tultul in elar nam anun a labino. Ra di sa watung iau nam o Belsebul, mot kai ra mot kis tomo nam iau, din watung mot nama kum rising i sakino taun a rising ra. ");
INSERT INTO kqw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gong mot ngaran a taro. A kum utna rop ra di munu tari, numur in kis taltalapor, ma a kum utna rop ra i kis eno, numur in nanpat pupuaso. ");
INSERT INTO kqw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A wasiso ra a inanos mot nami una dumirum, mot in inanos nami una waspi, ma a wasiso ra di wasisik kut nami torom mot, mot in tur sapat netes una rumu, ma mot in watung puaso i. ");
INSERT INTO kqw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gong mot ngaran det ra det um doko i kut a pinindi, ikut ka det in um doko lar pas a niondi. Mot in ngaran o naro ra in pet lar pasi sur in banlaulau a pinindi ma a niondi kai una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di ser kul arin nipiko liklik nama kabano toia kut, niko? Ikut ka tino lik tagun der in iru, ra a Tamamot ke mulaot uni. ");
INSERT INTO kqw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I lingmulus sakit, o God i sa luk tar a kum iwu na lorimot, ma i sa tasman rop tari. ");
INSERT INTO kqw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ra gong mot ngara, uni mot labo sakit umatan o God, taun a susut na piko. ");
INSERT INTO kqw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Osi ra in watung puaso i umatan a taro lena, i tagun iau, iau kai an watung puaso i umatan o Tita ra i kis sapat una langit lena, i tagun iau. ");
INSERT INTO kqw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ikut osi ra in ipul ru iau umatan a taro, iau kai an ipul ru i umatan o Tita, ra i kis sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gong mot nuki lena a wanpat sur an pitar a molmol una rakrakon bual. Awu, ka wanpat sur an pitar a molmol, a wanpat nama totok na inaim. ");
INSERT INTO kqw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A wanpat sur a taro det in kis na inaim, kibino un iau. ‘A nat na musano in nget o tamano, ma a nat na ino in nget o nano, ma a nolin na ino in nget o tubunu. ");
INSERT INTO kqw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Det tamano det in ebar etetalai tomo nam det.’ ");
INSERT INTO kqw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Osi ra i nem doko o tamano ma o nano, ikut anun a marmaris torom iau ke labo, ke to pasi sur i anung a nat na ususer. In wakak ra anun a marmaris torom iau in labo taun anun a marmaris torom o tamano ma o nano. Ma osi ra i nem doko o nutunulik, a nat na musano o a ino, ikut anun a marmaris torom iau ke labo, ke to pasi sur i anung a nat na ususer. In wakak ra anun a marmaris torom iau in labo taun anun a marmaris torom o nutunulik. ");
INSERT INTO kqw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Osi ra ke rakon pas anun in nanai kutus sur in murmur iau, ke to pasi sur i anung a nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Osi ra i maris bat anun a nilaun, in iru, ma osi ra i nuk pas iau ra ke maris bat anun a nilaun, in laun. ");
INSERT INTO kqw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Osi ra in gas pas mot, i gas pas iau utkai, ma osi ra i gas pas iau, i gas pasi utkai o naro ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Osi ra in gas pas a poropet uni i tasmani lena, i a poropet, in losi utkai a ngas na ikul elar nama poropet in losi. Ma osi ra in gas pas a tene tokodos, uni i tasmani lena, i a tene tokodos, in losi utkai a ngas na ikul elar nama tene tokodos in losi. ");
INSERT INTO kqw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Osi ra in tabor anung tu nat na ususer, ra ke sot umatan a taro, nam lakalik kotokoto na danim, uni i tasmani lena, i anung a nat na ususer, a inanos mot nama lingmulus, i kai in losi ut anun a ikul.” ");
INSERT INTO kqw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ra o Iesu i sa wasiso rop taru torom anun a noino ma aru nat na ususer, i wan tagitiro sur in ususer a taro ma in warawai una kum tamon, tong una papor Galili. ");
INSERT INTO kqw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","O Jon i kis una karabus ma i longoro a kum pinapam anun o Karisito. Ra i tulu ru anun a kum nat na ususer sur det in tingi lena, ");
INSERT INTO kqw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ui mo, ra di wasiso mugu taru un ui lena, un nanpat, o met in kis langlang utmakai sur taio?” ");
INSERT INTO kqw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ra o Iesu i balu det lena, “Mot in milet melet, ma mot in inanos o Jon una kum utna ri mot sa longoro i ma mot sa tama tari: ");
INSERT INTO kqw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","A kum pulu det sa tamtama, det ra a kikindet i mat det sa wan tokodos, a kum lepra det sa langolango, a kum kutkut det sa longoro, a kum minat det sa laun, ma di warawai nama Wakak na Wasiso torom a kum sibo na taro. ");
INSERT INTO kqw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Osi ra i tama a kum utna ri a pami, ma anun a nurnur ke puku, i sa dan.” ");
INSERT INTO kqw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ra a kum nat na ususer anun o Jon det wan, o Iesu i inanos a kunur na taro un o Jon lena, “Urabung ra mot wan una nubual kalako taro uni torom o Jon, asau ra mot tamtama suri? Kutiro in nere ra i erere una wuwu? Awu. ");
INSERT INTO kqw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Asau ra mot wan sur mot in tama i? A musano ra i emar nama kum wakak na malu? Awu. Tama i, det ra det ser emar nama kum wakak na malu det ser kis una kum rumu na king. ");
INSERT INTO kqw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Asau ra mot wan sur mot in tama i? A poropet? Ma! A watungi tamot, o Jon i labo sakit ut taun a kum poropet. ");
INSERT INTO kqw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Di sa tumtumus taru uni una Buk Tabu lena, ‘Tama i, an tulu ru anung a tene los wasiso sur in mugu tam, ra in pam saro anum a kisapi numugu tam.’ ");
INSERT INTO kqw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A inanos mot nama lingmulus, o Jon a Tene Baptaiso i labo sakit taun a taro rop taginin upiso. Ikut osi ra i natino sakit una matanitu tagisapat una langit, i labo taun o Jon. ");
INSERT INTO kqw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Turpasi una kilalo ra o Jon a Tene Baptaiso i turpas a warawai ma tuk uniri, a dekdek na taro det waim dekdek nama matanitu tagisapat una langit, ma det dekdek doko nama inaim sur det in turbati. ");
INSERT INTO kqw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A kum poropet ma a kum Warkurai anun o Moses det upuaso a wasiso anun o God, tuk una kilalo ra o Jon i turpas anun a pinapam uni. ");
INSERT INTO kqw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Det wasiso una poropet Elaija ra in nanpat. Ra mot nem na nurnur una wasiso ra, uniri, o Jon i sa pam sot pasi, uni i a poropet Elaija ra in nanpat. ");
INSERT INTO kqw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Osi ra arin talngano kura, i wakak sur in longoro nami. ");
INSERT INTO kqw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“An elaro a taro tagun uniri nama sau? Det elar nama kum nat liklik ra det kis una balano tamon ma det kakabo torom a kum paspasandet lena, ");
INSERT INTO kqw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Met pasor kudu, ikut ka mot lagor uni, ma met kele a kelekele na tupunuk, ikut ka mot tangis uni.’ ");
INSERT INTO kqw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","O Jon i wanpat, ke wan tu wakak na utna ma ke inum a wain, ra det watungi uni lena, ‘A laulau na nion kura uni.’ ");
INSERT INTO kqw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Nutun a Musano i wanpat, i wangon ma i inum, ra det watungi uni lena, ‘Tama i, a musano ri a tene inangon ma a tene ininum, a pasan a kum tene los takis ma a kum tene sakino.’ Ikut a kum pinapam anun o God i upuaso i lena, anun a mananos i a mananos mulus.” ");
INSERT INTO kqw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","O Iesu i wasiso na kankan torom a taro una kum tamon ra i sa pam tar anun a susut na utna na ukisin doko tiro iai, uni ka det nukpukus. ");
INSERT INTO kqw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I watungi lena, “In laulau torom mot a taro Korasin, ma in laulau kai torom mot a taro Betsaida. Ra gunuk di sa pam tar a kum utna na ukisin ri torom a taro Tair ma a taro Saidon, elar nami ra di sa pam tari torom mot, kanapi det in nukpukus lakit ma det in tobo, det in emar nama kum malu na tupunuk ma det in talus a pinpinindet nama kubus na sungun. Ikut mot, ka mot nukpukus. ");
INSERT INTO kqw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A watungi tamot lena, una bung na warkurai, a warkurai torom mot a taro Korasin ma a taro Betsaida, in laulau doko taun a warkurai torom a taro Tair ma a taro Saidon. ");
INSERT INTO kqw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma mot kai a taro Kapernaum, pepetlai, mot nuki lena din ulabo pas mot usapat netes? Awu, din woro upirso ru mot kut una labino sungun. Gunuk ra di sa pam tar a kum utna na ukisin torom a taro Sodom, elar nami ra di sa pam tari torom mot, kanapi o Sodom kuri utmakai i. ");
INSERT INTO kqw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A watungi tamot lena, una bung na warkurai, a warkurai torom mot a taro Kapernaum in laulau doko taun a warkurai torom a taro Sodom.” ");
INSERT INTO kqw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Una du bung ra, o Iesu i watungi lena, “Tita, ui a Labino tagun a langit ma a rakrakon bual rop. A watung ulabo pas ui, uni u munu a kum utna ri tan a kum tene mananos ma det ra det tastasman, ma u upuaso i kut, torom det ra det elar nama kum nat liklik. ");
INSERT INTO kqw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A lingmulus, Tita, uni anum a nemnem i lenutra. ");
INSERT INTO kqw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“O Tita i sa pitar tar a kum utna rop torom iau. Katutaio i tasman o Nutunu, o Tamano kut, ma kataio kai i tasman o Tamano, o Nutunu kut, ma det kai ra o Nutunu i nemi sur in upuaso o Tamano torom det. ");
INSERT INTO kqw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mot rop ra mot pino ngoro ma a kum mamaut i monong mot, mot in nan torom iau, sur an umana mot. ");
INSERT INTO kqw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mot in los anung in nikip, ma mot in ususer gusun iau, uni a magirang i wowowon ma a ser unatino pas iau. Mot in los in nikip ri sur a niomot in mana. ");
INSERT INTO kqw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Uni in nikip ri an pitari tamot ke ngangitin, ma a nilolos ino ke maut.” ");
INSERT INTO kqw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Numur, un ara Bung na Sabat, o Iesu i wan epotor una kum kinobot na wit. Anun a kum nat na ususer det murak, ra det turpas a kumut a ramano kum turunu wit ma det wani. ");
INSERT INTO kqw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ra a kum Parisi det tama i, det watungi tano lena, “Tama i, anum a kum nat na ususer det pam a utna ri, ra ke tokodos elar nama warkurai tagun a Bung na Sabat.” ");
INSERT INTO kqw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","O Iesu i balu det lena, “Pepetlai, ka mot luk utmakai asau ra o Dewid i pami? Det nama taro ra det wan tomo det murak, ");
INSERT INTO kqw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ra i ruk una rumu anun o God, ra i wan a beret ra di sa pitar tari torom o God. Ma det kai ra det wan tomo nami det wangon taguni. A beret ra, a warkurai taguni, i lenri, a kum tene etabor torom o God kut det in nangon taguni, ma a taro ororos gong. ");
INSERT INTO kqw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pepetlai, ka mot luk utmakai a wasiso tagun a Buk na Warkurai? I watungi lena, a kum tene etabor torom o God det ser papam una rumu na etabor una Bung na Sabat, ikut ka det raro uni. ");
INSERT INTO kqw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A watungi tamot lena, ara kuri nin i labo taun a rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Di sa tumtumus tari una Buk Tabu lenri, ‘A nem a marmaris, ma ka nem a etabor ra di ser tuni,’ Ra gunuk mot sa tasman a kukurain a wasiso ri, ka mot in takun det ra ka det raro. ");
INSERT INTO kqw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Uni a Nutun a Musano i a Labino tagun a Bung na Sabat.” ");
INSERT INTO kqw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Numur o Iesu i wan tagitiro, ra i ruk una nundet a rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ara musano kura iai, a lamano i kong. Det sisio sur tu utna det in takun o Iesu nami, ra det tingi lena, “Pepetlai, i tokodos ut elar nam anundat a kum Warkurai sur din ulangolango pas taio una Bung na Sabat o awu?” ");
INSERT INTO kqw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma i balu det lena, “Ra taio tagun mot anunu tu sipsip in puku taru un tin nutung una Bung na Sabat, pepetlai, ken pam ukai pasi, ma ken dat toto melet pasi? ");
INSERT INTO kqw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A musano i ngatngat taun a sipsip. Lenra i tokodos sur din pam a wakakino una Bung na Sabat.” ");
INSERT INTO kqw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ra i inanos a musano ra lena, “Kodos a lamam.” I kodosi, ra a lamano i tokodos melet, elar nam ara lamano ra i wakak. ");
INSERT INTO kqw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A kum Parisi det pirso, ma det epak pas sur tu kisapi sur det in um doko o Iesu uni. ");
INSERT INTO kqw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ra o Iesu i tasmani lena det epak sur det in um doko i, i wan gisen tagitiro iai. A susut na taro det muri, ma i ulangolango pas det rop ra det misait. ");
INSERT INTO kqw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma i turbat det, sur gong det inanos tar taio lena, i osi. ");
INSERT INTO kqw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I watungi lenra sur in pam sot pas a wasiso anun o God ra o Aisaia a poropet i sa wasiso mugu taru uni lena, ");
INSERT INTO kqw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iri i anung a tultul ra a sa pilok pasi, anung a nat na wakak, a gas doko nami. An uruk tar a Niong uni, ra in upuaso a warkurai ra i tokodos torom a taro ra ausur a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ken wasiso na kankan, ma ken ugaia, ma ka din longoro in nalngano una kum kisapi. ");
INSERT INTO kqw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ken pak in nere ra i tulukun, ma ken wup doko a lam ra ke kunabor wakak. In pami lenra tuk a tokodos na warkurai in uwia. ");
INSERT INTO kqw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A taro ra ausur a taro Juda det in nurnur una risano ma det in kis langlang sur in ulaun det.” ");
INSERT INTO kqw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Det ben pat ara musano torom o Iesu, i ngat ma i pulu, ma a laulau na nion kura uni. O Iesu i ulangolango pasi, ra a musano ra i wasiso ma i tamtama kai. ");
INSERT INTO kqw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ra a taro rop det kisin, ma det iting lena, “Kutiro a Nutun o Dewid ut ri?” ");
INSERT INTO kqw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ikut a kum Parisi det longoro i ra det watungi lena, “A musano ri, i ser lakro ru a kum laulau na nion nama dekdekin o Belsebul, a labino anun a kum laulau na nion.” ");
INSERT INTO kqw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","O Iesu i sa tasman a nuknukindet, ra i watungi tandet lena, “Ra tu gapman det melet ut det in waim etalai, a gapman ra in rop kut. Ra tu tamon, o lako taro tagun tu rumu, det in waim etalai melet kut, ka det in kis tomo melet mo. ");
INSERT INTO kqw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ra o Satan in lakro ru anun a kum tultul, ka det in tur tomo melet mo, det in nan sarara. Ra i lenra, anun a gapman in tur dekdek pepetlai? ");
INSERT INTO kqw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ra iau a lakro ru a kum laulau na nion nama dekdekin o Belsebul, anumot a taro det ser lakro ru a kum laulau na nion nama dekdekin osi? Anundet a pinapam ut in upuaso i lena anumot a etakun i raro. ");
INSERT INTO kqw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ikut, ra a lakro ru a kum laulau na nion nama dekdek in a Nion o God, mot in tasmani lena a matanitu anun o God i sa wanpat torom mot. ");
INSERT INTO kqw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kataio in pet lar pasi sur in ruk una rumu anun tu dekdek na musano, ma in los pas a kum utna tagitiro una nun a rumu, ra ken ker ukai mugu tari. Ra ut in ker ukai mugu tari, in los a kum utna maragom anun a musano ra. ");
INSERT INTO kqw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“I ra ke warut iau, i turbat iau kut. Ma i ra ke warut iau u eben, i lu sarara ru det kut. ");
INSERT INTO kqw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ra a watungi tamot lena, din dumano ru a kum sakino petutna rop anun a taro, ma anundet a kum sakino wasiso kai un o God, ikut a wasiso laulau una Tokodos na Nion ka din unus lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Osi kai ra in watung tar tu sakino wasiso una Nutun a Musano, din dumano ru i kut, ikut osi ra in wasiso laulau una Tokodos na Nion, ka din unus lar pasi, una nilaun uniri ma una nilaun numur kai. ");
INSERT INTO kqw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“In nanai ra i wakak, i ser wu a wakak na wino, ma in nanai ra i laulau, i ser wu a laulau na wino. Din tama lele in nanai tagun a wino. ");
INSERT INTO kqw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mot a kum nutnutun a kum sui! Mot ra a laulau na taro, mot in watung petlan tu wakak na wasiso? Uni a wan a taro i watung puaso a petutna ra i bukus una nundet a nilaun. ");
INSERT INTO kqw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A wakak na musano i ese anun a wakak na petutna tagun a wakakino ra i kis una nun a nilaun, ma a sakino musano kai, i ese anun a sakino petutna tagun a sakino ra i kis una nun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A watungi tamot lena, a kum wasiso laulau rop ra a taro det sa watung tatari, kura munung din ting det uni una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ra una bung ra, anum a wasiso ut in ulangolango ui, o in banlaulau ui.” ");
INSERT INTO kqw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Numur ara taro tagun a kum tene ususer tagun a Warkurai ma a kum Parisi det watungi tano lena, “Tene Ususer, un pam tu ukinalong sur met in tama i.” ");
INSERT INTO kqw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I balu det lena, “A taro tagun uniri, a sakino taro, anundet a nilaun i bakbak gusun o God. Det sasaring sur tu ukinalong, ikut ka din pam taio torom det. Din pam a ukinalong kut elar nam i ra di pam tari un o Jona a poropet. ");
INSERT INTO kqw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Elar nam o Jona i laun a tulu bung un in balan a labino kiripo, lenkut kai ra a Nutun a Musano in inep pas a tulu bung ubalan a piso. ");
INSERT INTO kqw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Una bung na warkurai, a taro Niniwe det in tur ma det in takun dekdek a taro tagun uniri, uni det nukpukus una warawai anun o Jona, ma ikut, ara ra i labo taun o Jona kuri ut nin. ");
INSERT INTO kqw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Una bung na warkurai, a kwin tagitong una matmatano tobar in tur ma in takun dekdek a taro tagun uniri, uni i wan ut tagitiro bakbak sur in longoro a mananos anun a King Solomon, ma ikut ara ra i labo taun o Solomon kuri ut nin. ");
INSERT INTO kqw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ra tu laulau na nion in pirso pas gusun tu musano, in nan una kum nubual ra kalako danim iai, sur in mana, ikut ken sio pas tu nubual ra in mana uni. ");
INSERT INTO kqw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ra in watungi lena, ‘An milet melet sur anung a rumu, ra a pirso pas gusuni.’ Ra in nanpat, in tama i ra i sa belbel, di sa surupu tari, ma di sa ukodos tari. ");
INSERT INTO kqw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Numur in nan ra in ben melet pas a wonomawit na laulau na nion, ra det laulau sakit tano, ma det in ruk rop taru una rumu ra, ma det in kis uni. Ma a nilaun anun a musano ra i laulau sakit mo tan a nilaun ra i utur ukai i numugu. In lenkutkai ra torom a laulau na taro tagun uniri.” ");
INSERT INTO kqw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ra o Iesu i wasiso utmakai torom a kunur na taro, o nano ma a kum tistisino det wanpat, ma det tur taru kut nago upiso, uni det nem na wasiso tomo nami.  ");
INSERT INTO kqw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma ara musano i inanos o Iesu lena, “O nam ma a kum tistisim, kunago det upiso. Det nem na wasiso tomo nam ui.” ");
INSERT INTO kqw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ra i balu i lena, “Osi o nang, ma osi det a kum tistising?” ");
INSERT INTO kqw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ra i kodos a lamano torom anun a taro na ususer ma i watungi lena, “Tama i, det ri o nang ma a kum tistising! ");
INSERT INTO kqw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uni osi ra i ser mur a nemnem anun o Tita ra i kis sapat una langit, i ra a tising a musano, ma a tising a ino, ma o nang.” ");
INSERT INTO kqw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Una bung ra, o Iesu i pirso gusun a rumu ra i wan ma i kis tiro nisan a du tasi Galili. ");
INSERT INTO kqw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A labino kunur na taro det tur talilis pasi. Ra i kas una pot ra i kis taru uni, ma a taro rop det tur nago una usalin. ");
INSERT INTO kqw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I wasiso torom det una susut na utna nama kum wasiso elelar. I watungi lena, “A tene minarut i wan sur in sapro a kum pitino wit. ");
INSERT INTO kqw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ra i sapro nanan a kum pitino wit, a ramano det puku una kisapi, ra a kum piko det ro pat ma det wan ru i. ");
INSERT INTO kqw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A ramano kai det puku una nubual na watat, ra kalako susut na piso uni. Det sibul pat lakit, uni a piso ke but. ");
INSERT INTO kqw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ikut ra a suan i sisio pat, i rang det ra det main ma det marang rop, uni kalako wakakor indet. ");
INSERT INTO kqw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A ramano kum pitino wit det puku epotor una kum kuikui, ra a kum kuikui det lubung ma det rau bat pas det. ");
INSERT INTO kqw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ikut a ramano kum pitino kai det puku una wakak na piso ra det wu. A ramano det wu ara mar na windet, a ramano kai a wonom na noino, ma a ramano a tulu noino. ");
INSERT INTO kqw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Osi ra arin talngano kura, i wakak sur in longoro nami.” ");
INSERT INTO kqw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anun a kum nat na ususer det wan toromi ma det tingi lena, “Sur asau ra u ususer a taro nama kum wasiso elelar?” ");
INSERT INTO kqw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma i balu det lena, “O God i sa pitar tar a mananos tamot, sur mot in talapor una kum wasiso na pidik una matanitu tagisapat una langit. Ikut, ke pitari torom a taro rop. ");
INSERT INTO kqw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Uni osi ra i utur ukai a mananos uni, din tabor meleti nama labino, ma in mananos bing. Ma osi ra ke pam ukai tu mananos uni, din rakon ru i utkai asau lik ra kura i utur ukai i. ");
INSERT INTO kqw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A ususer det nama kum wasiso elelar, uni det tamtama, ikut ka det tama lele i, det longlongoro, ikut ka det longoro lele i, ma ka det mananos uni. ");
INSERT INTO kqw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A wasiso na poropet anun o Aisaia i sa sot un det, ra i watungi lena, ‘Mot in longlongoro, ikut ka mot in longoro lele i, mot in tamtama, ikut ka mot in tama lele i. ");
INSERT INTO kqw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uni a taro ri a kum balandet i dekdek, a kum taltalngandet i kutkut, ma a kum matmatan det i pulu. Ra gunuk det in tamtama lele nama kum matmatandet, ma det in longoro lele nama kum taltalngandet, ma det in mananos nama kum nuknukindet, ma det in tupukus, ma, iau ut an ulaun pas det.’ ");
INSERT INTO kqw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ikut mot, mot dan, uni mot tamtama ut nama kum matmata mot, ma mot longlongoro ut nama kum taltalngamot kai. ");
INSERT INTO kqw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A inanos mot nama lingmulus, numugu a susut na poropet ma a susut na tene tokodos det kalkal doko sur det in tama a kum utna ri a pami umatamot, ikut ka det tama i. Ma det kalkal doko kai sur det in longoro a kum utna ri mot longoro i, ikut ka det longoro i. ");
INSERT INTO kqw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mot in longoro a kukurai na wasiso elelar ina tene minarut. ");
INSERT INTO kqw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Osi ra i longoro a wasiso una matanitu tagisapat una langit, ma ke mananos uni, i elar nama kum pitino wit ra det puku una kisapi. A Laulau na Musano i wanpat ra i rakon ru i melet a wasiso ra di sa marut tari un in balano. ");
INSERT INTO kqw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma a kum pitino ra det puku una nubual na watat, det elar nama musano ra i longoro a wasiso, ra uniutra, i pam ukai i nama gasgas. ");
INSERT INTO kqw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ikut a wasiso ke kis un in balano, ma a musano ra ken tur suano i, elar nam in wit ra kalako wakakor ino. Ra a kum mamaut in nanpat, ma din banlaulau i, uni i nurnur una wasiso anun o God, in puku lakit. ");
INSERT INTO kqw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A kum pitino ra det puku epotor una kum kuikui, i elar nam ara musano ra i longoro a wasiso, ikut a labino nuknuk sur a wakak na kinkinis nin upiso, ma a kum usobor tagun a kum ululeng taginin una rakrakon bual, i rau bat a wasiso anun o God, ra ke wu lako wino. ");
INSERT INTO kqw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ikut a kum pitino ra det lubung sapat una wakak na piso, det elar nam ara musano ra i longoro a wasiso, ma i mananos uni. In wu ara mar, o a wonom na noino, o a tulu noino wino.” ");
INSERT INTO kqw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","O Iesu i watung ara wasiso elelar bulung torom det lena, “A matanitu tagisapat una langit i elar nama musano ra i sapro a kum pitino wit una nun a kinobot. ");
INSERT INTO kqw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ra a taro det inep, anun a ebar i wanpat ra i sapro tar a kum pitino karapa ubalan a kum wit, ra i wan. ");
INSERT INTO kqw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A pitino wit i lubung pat ma i ling na wu, ra di tama i utkai a karapa i lubung ubalano. ");
INSERT INTO kqw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A kum tultul anun a taman a kinobot det wan toromi, ma det watungi tano lena, ‘Labino, pepetlai, a kum pitino wit rop kut ra u sapro tari una num a kinobot? Tagai kai a kum karapa?’ ");
INSERT INTO kqw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I balu det lena, ‘A ebar i pam a petutna ra.’ Ra det tingi lena, ‘U nemi sur met in nan, ma met in gat rop ru det?’ ");
INSERT INTO kqw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I turbat det lena, ‘Gong munung, sako mot in gat tomo ru i nama kum wit. ");
INSERT INTO kqw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Madek ru i, der in lubung tomo tuk una kalang na pasong. Una bung ra, an watungi tan a kum tene pasong lena: Mot in rakon mugu ru a kum karapa, mot in ker tomo tar a kum kamkabino sur din tun ru det una sungun. Ra numur mot in los tomo i bulung a kum wit una nung a rumu na ululeng.’” ");
INSERT INTO kqw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","O Iesu i watung ara wasiso elelar bulung tandet lena, “A matanitu tagisapat una langit i elar nam in pitino mastad, ra ara musano i los pasi, ma i marut tari una nun a kinobot. ");
INSERT INTO kqw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I natino taun a kum pitino duwai rop, ikut ra i lubung, i labo taun a kum duwai na inangon rop. Ma a kum piko det ser pam pios una kum kanokano.” ");
INSERT INTO kqw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O Iesu i watung ara wasiso elelar bulung tandet lena, “A matanitu tagisapat una langit i elar nama is, ra ara ino i rakon pasi, ma i pam tomo tari nama labino palawa, ra a palawa rop i mubus nami.” ");
INSERT INTO kqw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","O Iesu i ususer a kunur na taro nama kum wasiso elelar, ma ke wasiso torom det nam tu se wasiso, a wasiso elelar rop kut. ");
INSERT INTO kqw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I watungi lenra sur din pam sot pas a wasiso anun a poropet lena, “An wasiso nama kum wasiso elelar, an watung a kum utna ra i kis eno, turpasi numugu utmakai, ra o God i ukis a rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Numur o Iesu i wan gusun a kunur na taro, ra i ruk una rumu. Anun a kum nat na ususer det ruk toromi ma det inanosi lena, “Un palos a kukurai na wasiso elelar ri ta met una karapa ra i lubung ubalan a kinobot.” ");
INSERT INTO kqw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I balu det lena, “O naro ra i sapro a kum pitino wit i a Nutun a Musano. ");
INSERT INTO kqw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A kinobot, i a rakrakon bual, ma a kum pitino wit, det a taro tagun a matanitu tagisapat una langit, ma a kum karapa, det a kum nutnutun a Laulau na Musano, ");
INSERT INTO kqw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ma a ebar ra i sapro det, i o Satan. A kalang na pasong, i a tintinip ina rakrakon bual, ma a kum tene pasong, a kum ensel. ");
INSERT INTO kqw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A kum tene pasong det los tomo a kum karapa ra det tun ru det una sungun. In lenkutkai ra din pami una tintinip ina rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A Nutun a Musano in tulu ru anun a kum ensel, ma det in rakon rop ru a kum utna ra i ben raro a taro, ma det kai ra det ser pam a sakino. ");
INSERT INTO kqw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma det in woro det una labino sungun. Det in tangtangis ma det in ungingit lokondet iai. ");
INSERT INTO kqw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma a kum tene tokodos det in sisio elar nam in nusuan una matanitu anun a Tamandet. Osi ra arin talngano kura, i wakak sur in longoro nami. ");
INSERT INTO kqw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A matanitu tagisapat una langit i elar nama utna ra a matano i ka doko, ra di munu tari una kinobot. Ma ara musano i sio pasi ma i munu melet tari. Ra i wan nama gasgas, ma i siuru rop ru anun a kum utna, ra i kul pas a kinobot ra nami. ");
INSERT INTO kqw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A matanitu tagisapat una langit i elar kai nam ara tene siuru, i sisio sur a kum ngatngat na wat ra i ser kis ubalan a kabokabol. ");
INSERT INTO kqw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ra i sio pas ara wat ra i ngatngat doko a matano, i siuru rop ru anun a kum utna, ma i kul pas a ngatngat na wat ra nami. ");
INSERT INTO kqw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A matanitu tagisapat una langit i elar kai nama bene, ra di woro tari sa u tasi, ma a wur ngas na kiripo det iru taru uni. ");
INSERT INTO kqw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ra i bukus a bene, a kum tene woro bene det dat mamaso tari una usalin. Det kis ra det timilo ru a kum kiripo utiro una kum rat, ma a kum laulau ino det woro ru det. ");
INSERT INTO kqw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Una tintinip ina rakrakon bual din pami ut lenri: A kum ensel det in nanpat ma det in isuaro ru a kum tene sakino gusun a kum tene tokodos. ");
INSERT INTO kqw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ra det in woro ru a kum tene sakino una labino sungun. Det in tangtangis ma det in ungingit lokondet iai. ");
INSERT INTO kqw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Pepetlai, mot sa mananos una kum kukurai na kum utna rop ri, o awu?” Anun a kum nat na ususer det balu i lena, “Ma! Met sa tasmani.” ");
INSERT INTO kqw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ra o Iesu i watungi tandet lena, “A kum tene ususer rop tagun a Warkurai, ra det sa ususer pas una matanitu tagisapat una langit, det elar nam ara musano ra i uleng a kum wakak na utna una nun a rumu. Ra i upirso a kum wakak na utna ra, gusun anun a rumu sur in papam nami, a ramano kum utna, a kum matokino, ma a ramano kai, a kum turaino.” ");
INSERT INTO kqw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ra o Iesu i sa watung rop tar a kum wasiso elelar ri, i wan tagitiro iai, ");
INSERT INTO kqw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ra i wanpat una nun a tamon, tong o Nasaret. I tur pasi sur in ususer a taro tiro una nundet a rumu na lotu, ma det kisin doko ra det watungi lena, “A musano ri i los a mananos tagai? Ma tagai kai a dekdek ra i pam a kum utna na ukisin ri nami? ");
INSERT INTO kqw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","O Tamano a tene pam rumu kut, ma o nano o Maria. A kum tistisino kai, o Jems, o Josep, o Saimon ma o Judas ");
INSERT INTO kqw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ma a kum bunu kai ano kuri ut dat laun tomo nin. Ma tagai a dekdek ra a musano ri i pam a kum utna ri nami?” ");
INSERT INTO kqw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ra ka det nemi ut mo. Ra o Iesu i watungi tandet lena, “Di ser ru a poropet una kum se tamon, ikut det ut una nun a tamon ma anun a rumu ka det ru i.” ");
INSERT INTO kqw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ra ke pam lako susut na utna na ukisin tiro iai, uni ka det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Una kilalo ra, o Erod a mugumugu i longoro a wasiso un o Iesu, ");
INSERT INTO kqw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ra i watungi tan anun a kum tultul lena, “A musano ra, i o Jon a Tene Baptaiso, i sa laun melet gusun a minat. I mo ra i pam a kum utna na ukisin.” ");
INSERT INTO kqw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Numugu o Erod i tulu ru anun a kum tene inaim sur det in dat pas o Jon. Ra det dat pasi, det ker pasi, ma det uruk tari una karabus. O Erod i pami lenri, uni o Jon i inanosi lena, “Ke tokodos ra u nolin nam o Erodias, a urim.” I watungi lenri, uni o Erod i sa sal pas o Erodias, a ino anun o tisino, o Pilip, ra i nolin nami. ");
INSERT INTO kqw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ma o Erod i nemi sur din um doko o Jon, ikut i ngaran a taro, ra det tasmani lena o Jon a poropet. ");
INSERT INTO kqw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Una bung ra di ukinalong a bung na usus anun o Erod, a nutun o Erodias a ino, i lagor nisan det. O Erod i gas doko nami, ");
INSERT INTO kqw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ma i uliliman dekdek tar a nutun o Erodias lena, “Asau mukut ra un saringi tang an pitari ut tam.” ");
INSERT INTO kqw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ra i inanosi lena, “Un pitar kut in lorin o Jon a Tene Baptaiso tang un tu pelet.” I watungi lenri uni o nano i sa inanos tari nami. ");
INSERT INTO kqw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A king i tupunuk doko. Ikut i tulu a kum tene inaim sur det in tarom una sasaring anun a toraro ra, uni i sa uliliman tari lena asau mukut ra in saringi tano in tabori ut nami, ma a taro ra det kis tomo nami una inangon, det sa longoro tar anun a wasiso. ");
INSERT INTO kqw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A kum tene inaim det wan utong una karabus ma det tau kutus pas in lorin o Jon. ");
INSERT INTO kqw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Det ubek pas in lorino una pelet ma det pitari torom a toraro, ra i losi torom o nano. ");
INSERT INTO kqw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ra a kum nat na ususer anun o Jon det wanpat ma det los pas a minatino, ra det pori. Numur det wan torom o Iesu ra det inanosi nami. ");
INSERT INTO kqw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ra o Iesu i longoro i lena o Jon i sa mat, i kas taru una pot ra i wan tagitiro sur a nubual kalako taro uni, sur i sot kut in kis. Ra a taro tagun a kum tamon det longoro i, det wan murmuri una kisapi sur a nubual ra. ");
INSERT INTO kqw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ra i sot, i tama a labino kunur na taro. I maris doko det, ma i ulangolango pas det rop ra det misait. ");
INSERT INTO kqw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ra i sa lirop anun a kum nat na ususer det wan toromi, ra det watungi tano lena, “A nubual ri i bakbak gusun a kum tamon, ma i sa lirop kai. Un tulu ru a kunur na taro sur det in nan sur a kum tamon, sur det in kul pas andet lako utna na inangon.” ");
INSERT INTO kqw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","O Iesu i balu det lena, “Det in nan sur asau? Mot ut mot in tabor det.” ");
INSERT INTO kqw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Det watungi tano lena, “A limanin beret sot kut, ma arin kiripo kuri met losi.” ");
INSERT INTO kqw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I watungi tandet lena, “Mot in losi urin torom iau.” ");
INSERT INTO kqw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ra i itula sur a kunur na taro det in kis una wuliso. I los pas a limanin beret ma aru kiripo, i tamtama usapat una langit, i watung wakak pas torom o God uni, i tibik a limanin beret, ra i pitari tan anun a kum nat na ususer. Ra det tibo a kunur na taro nami. ");
INSERT INTO kqw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Det rop det wangon ma det masur. Numur det song bukus pas a noino ma aru rat nama utna ra det wan kopos tari. ");
INSERT INTO kqw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A wardain ma a kum nat liklik ma a kum musano det rop det wangon. Ikut a niluluk ina kum musano kut, i elar nama limo na arip. ");
INSERT INTO kqw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Uniutra, o Iesu i tulu ru anun a kum nat na ususer, sur det in kas una pot, ma det in mugu utong sur ara papor tasi. Ma i, i kis utmakai sur in tulu ru a taro. ");
INSERT INTO kqw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ra i sa tulu rop ru det, i sot mukut i wan tito usapat una tangai sur in wararing. Ra i sa lirop matano mirum i sot mukut i kis. ");
INSERT INTO kqw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A pot i sa wan potor ra i tinako nanan una top, uni a wuwu i waim tagisa numugu. ");
INSERT INTO kqw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Una lar, o Iesu i wan sapat netes una du tasi torom det. ");
INSERT INTO kqw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ra anun a kum nat na ususer det tama pasi ra i wan netes una du tasi, det ngara doko ma det watungi lena, “A nion kut ra!” Ra det woiwoi nama nginara. ");
INSERT INTO kqw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Uniutra o Iesu i watungi tandet lena, “A kosom taru tamot, iau kut ri. Gong mot ngara.” ");
INSERT INTO kqw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","O Pita i watungi tan o Iesu lena, “Labino, ra ui ut ra, un inanos iau sur iau kai an nan sapat netes una du tasi torom ui.” ");
INSERT INTO kqw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O Iesu i inanosi lena, “Un nan urin.” Ra o Pita i sirok gusun a pot, ra i wan sapat netes una tasi torom o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ikut, ra i tama a kum lamlabino top, i ngara. Ra i murung nanan, i kakabo lena, “Labino, un ulaun iau.” ");
INSERT INTO kqw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Uniutra, o Iesu i kodos a lamano toromi, i dat toto pasi, ra i watungi tano lena, “Anum a nurnur i natino doko. Ilai ra u nuknuk larlar?” ");
INSERT INTO kqw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ra der kas una pot, a wuwu i mana mut. ");
INSERT INTO kqw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ra det kis tomo una pot, a kum nat na ususer det lotu torom o Iesu, ma det watungi lena, “I lingmulus ut ra ui a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ra det sa wan kutus un ara papor tasi, det sot tiro una papor Genesaret. ");
INSERT INTO kqw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ra a taro tagitiro det tama lele pas o Iesu, det pitar wasiso utiro una kum tamon. Numur det ben rop pas a kum misait toromi. ");
INSERT INTO kqw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma det saringi sur a kum misait det in pami kut a sinisir ina nun a kolos. Ra det rop ra det pami, det langolango mut. ");
INSERT INTO kqw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A ramano kum Parisi ma a kum tene ususer tagun a Warkurai det wan tagisapat o Jerusalem torom o Iesu, ma det tingi lena, ");
INSERT INTO kqw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ilai sur anum a kum nat na ususer ka det ser mur a kum etowo anun anundat a taro tagun numugu? Ra det wangon, ka det gos mugu pas a lamandet.” ");
INSERT INTO kqw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma i balu det lena, “Sur asau ra ka mot mur a Warkurai anun o God? Mot muri kut a kum etowo anun anumot a taro tagun numugu. ");
INSERT INTO kqw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uni o God i watungi lena, ‘Un ru o tamam ma o nam,’ ra i watungi kai lena, ‘Osi ra in wasiso laulau un o tamano ma o nano, din um doko i.’ ");
INSERT INTO kqw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ikut mot, mot ususer a taro lena, i wakak kut ra taio in watungi tan o tamano ma o nano lena, ‘Asau ra an warut mur nami, a sa tabor tar o God nami.’ ");
INSERT INTO kqw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ikut ra ke warut o tamano, ke ru i. Ra mot pami lenra, mot unatino pas a wasiso anun o God sur mot in muri kut a kum etowo anun anumot a taro tagun numugu. ");
INSERT INTO kqw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mot a kum tene torotoro. A wasiso anun o Aisaia i lingmulus ut, ra i wasiso na poropet mugu taru un mot lena, ");
INSERT INTO kqw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A taro ri det ru iau kut nama wandet, ikut a balandet i bakbak doko gusun iau. ");
INSERT INTO kqw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Det lotu oros kut torom iau, uni det ususer kut nama kum warkurai anun a taro.’” ");
INSERT INTO kqw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","O Iesu i kabo pas a kunur na taro toromi, ra i watungi tandet lena, “Mot in longoro iau ma mot in tasman lele anung a wasiso. ");
INSERT INTO kqw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asau ra in ruk una wan tu musano, ken uduri umatan o God. Ikut, asau ra i watungi nama wano, i ra in uduri umatan o God.” ");
INSERT INTO kqw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Numur anun a kum nat na ususer det wan toromi ra det tingi lena, “Pepetlai, u sa tasmani lena a kum Parisi det balano mamaut una num a wasiso?” ");
INSERT INTO kqw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","I balu det lena, “A kum duwai ra o Tita, ra i kis sapat una langit, ke marut det, din gat rop ru det. ");
INSERT INTO kqw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mot in madek ru a kum Parisi. Det a kum pulu na mugumugu. Ra tu pulu in ben tu pulu, der rop der in puku dorong un in nutung.” ");
INSERT INTO kqw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma o Pita i tingi lena, “Un palos a wasiso elelar ri torom met.” ");
INSERT INTO kqw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ra o Iesu i watungi lena, “Mot kai ka mot talapor utmakai? ");
INSERT INTO kqw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ka mot tasmani lena, a kum utna rop ra i ruk una wan a musano, i ruk un in balano ma i upirso melet ru i? ");
INSERT INTO kqw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ikut a kum wasiso rop ra i watungi nama wano, i wanpat gusun a nuknukino, i ra in uduri. ");
INSERT INTO kqw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iri a kum utna ra i ser wanpat tagun a nuknukino: a kum sakino nuknuk, um doko a taro, di sal pas a ino anun taio gisen, a kum petutna na pamuk, a wolong, a etakun torotoro, ma di mang laulau ara. ");
INSERT INTO kqw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A kum utna ri det udur a taro. Ikut ra det wangon ma ka det gos mugu pas a lamandet, ausur in udur det umatan o God.” ");
INSERT INTO kqw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","O Iesu i wan tagitiro, ra i wanpat milau a tamon Tair ma o Saidon. ");
INSERT INTO kqw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ara ino Kanan tagitiro una papor ra, i wanpat ma i kabo o Iesu lena, “Labino, a Nutun o Dewid un maris iau. A nutunglik a ino, a laulau na nion kura uni, ra i ser banlaulau i.” ");
INSERT INTO kqw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ikut o Iesu ke balu i. Anun a kum nat na ususer det wan toromi, ma det inanos dekdeki lena, “Un tulu ru i mukut, uni i woiwoi numur un dat.” ");
INSERT INTO kqw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","O Iesu i watungi lena, “O God i tulu ru iau urin sur a taro Israel kut, ra det raro elar nama kum sipsip.” ");
INSERT INTO kqw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ikut a ino ra i wan torom o Iesu, i kis butkeke numugu tano ra i watungi tano lena, “Labino, un warut iau.” ");
INSERT INTO kqw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ra o Iesu i balu i lena, “Ke tokodos sur din los a utna ana kum nat, ma din woro i tan a kum pap.” ");
INSERT INTO kqw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A ino ra i balu i lena, “Labino, a lingmulus ut ra. Ikut, a kum pap kai det ser wan a kum mumumut na utna ra i ser puku tagun a kabulu na inangon anun a kum tamtamandet.” ");
INSERT INTO kqw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ra o Iesu i balu i lena, “Le, i labo doko anum a nurnur! A utna ra u nemi, an pami ut torom ui.” Ma una du bung ut ra, a nutunulik i langolango. ");
INSERT INTO kqw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","O Iesu i wan tagitiro, ma i usal nanan una usalin una du tasi Galili. Numur i wan toto una tangai ra i kis sapat. ");
INSERT INTO kqw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma a labino kunur na taro det wan toromi. Det los det ra a kikindet i mat, ma det ben a kum pulu, a kum pio, a kum ngat, ma a susut na misait utkai toromi. Ma det uinep tar det nisano, ra i ulangolango pas det. ");
INSERT INTO kqw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A kunur na taro det tama a kum ngat det wasiso, ma a kum pio det tur, ma det ra a kikindet i mat det wan tokodos, ma a kum pulu kai det tamtama. Det kisin doko ra det watung ulabo pas a God anun a taro Israel. ");
INSERT INTO kqw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","O Iesu i kabo pas anun a kum nat na ususer toromi ma i watungi tandet lena, “A maris doko a taro ri, uni det sa kis tomo nam iau nin a tulu bung, ma kalako utna na inangon sur det in nani. Ka nemi sur an tulu ru det kut nama munurak, sako det in bengbeng nanan una kisapi.” ");
INSERT INTO kqw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Anun a kum nat na ususer det inanosi lena, “A nubual ri, kalako taro uni. Tagai mo lako utna na inangon sur dat in tabor a kunur na taro ri nami?” ");
INSERT INTO kqw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O Iesu i ting det lena, “A isin beret kura mot losi?” Det balu i lena, “A wonomawit na beret ma a kabanin natnat na kiripo.” ");
INSERT INTO kqw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ra i inanos a taro rop sur det in kis piso. ");
INSERT INTO kqw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I los pas a wonomawit nin beret ma a kabanin kiripo ra, i watung wakak pas uni torom o God, i tibiki ma i pitari torom a kum nat na ususer sur det in tabor a taro nami. ");
INSERT INTO kqw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A taro rop det wangon ma det masur. Numur det song bukus pas a wonomawit na rat nama kum utna ra det wangon kopos pas uni. ");
INSERT INTO kqw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A kum ino tomo nama kum nat liklik ma a kum musano det rop det wangon. A niluluk ina kum musano kut i elar nama wat na arip. ");
INSERT INTO kqw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Numur o Iesu i tulu ru a kunur na taro, i kas una pot, ra i wan sur a papor Magadan. ");
INSERT INTO kqw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A kum Parisi ma a kum Sadusi det wan torom o Iesu, ra det saringi sur in pam tu ukinalong umatandet, sur in ese i lena i tagisapat una langit.  ");
INSERT INTO kqw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ra i watungi tandet lena, “Ra i ser lirop mot ser watungi lena, ‘A bakut i sa merek rop, markan ken bato.’ ");
INSERT INTO kqw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma una kobot mot ser watungi kai lena, ‘Uniri in bato, uni a bakut i sa merek, ma i sa bagubagu rop.’ Mot mananos sur mot in palos a tamtama ina bakut, ikut ka mot mananos sur mot in palos a kukurai na kum ukinalong tagun uniri. ");
INSERT INTO kqw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A taro tagun uniri, a sakino taro, anundet a nilaun i bakbak gusun o God. Det nem na tama tu ukinalong, ikut ka din pam taio torom det. Din pam a ukinalong kut elar nam i ra di pam tari un o Jona.” Ra o Iesu i wan gusun det. ");
INSERT INTO kqw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","O Iesu tomo nam anun a kum nat na ususer det wan kutus a du tasi, ma a kum nat na ususer ka det los lako beret, det dumano ru i kut. ");
INSERT INTO kqw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","O Iesu i watungi tandet lena, “Mot in tumarong mot una is anun a kum Parisi ma a kum Sadusi.” ");
INSERT INTO kqw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ra det wasiso etetalai torom det una kukurai na wasiso anun o Iesu, ma det lena, “I watungi lenra uni ka dat los lako beret.” ");
INSERT INTO kqw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","O Iesu i tasman anundet a wasiso ra i watungi tandet lena, “I natino doko anumot a nurnur. Ilai ra mot wasiso etalai un mot ra ka mot los lako beret? ");
INSERT INTO kqw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Pepetlai, ka mot mananos utmakai? Ka mot nuk pas a limanin beret ra a tibiki torom a limo na arip na musano? Ma ka mot nuk pasi kai aiso rat ra mot song bukus pasi? ");
INSERT INTO kqw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ka mot nuk pas a wonomawit na beret ra a tibiki torom a wat na arip na musano? Ma ka mot nuk pasi kai aiso rat ra mot song bukus pasi? ");
INSERT INTO kqw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ilai ra ka mot mananos? Ka wasiso una beret. Mot in tumarong mot una is anun a kum Parisi ma a kum Sadusi.” ");
INSERT INTO kqw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ra det tasmani maragom lena ke turbat det gusun a is ra i kis una beret, ikut i watungi lenra, sur det in tumarong det una etowo anun a kum Parisi ma a kum Sadusi. ");
INSERT INTO kqw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","O Iesu i wanpat milau a tamon Sisaria Pilipai. Ra i ting anun a kum nat na ususer lena, “A taro det watung a Nutun a Musano nam osi?” ");
INSERT INTO kqw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Det balu i lena, “Ara taro det watung ui o Jon a Tene Baptaiso. Ara taro det watung ui o Elaija, ara taro det watung ui o Jeremaia, ma ara taro kai det watung ui ara tagun a kum poropet.” ");
INSERT INTO kqw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I ting det lena, “Ma mot, mot watung iau nam osi?” ");
INSERT INTO kqw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ra o Saimon Pita i balu i lena, “Ui a Karisito, a Nutun o God ra i laun.” ");
INSERT INTO kqw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ra o Iesu i watungi tano lena, “Saimon, a nutun o Jon, u sa dan, uni kataio i inanos ui nama wasiso ra. O Tita ut ra i kis sapat una langit i unuk tar ui nami. ");
INSERT INTO kqw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ra a watungi tam lena, ui o Pita, a wat kis. An utur anung a taro na lotu una wat ri. A dekdek ina minat ken turus pas anung a taro na nurnur. ");
INSERT INTO kqw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","An pitar a kum ki tagun a matanitu tagisapat una langit torom ui, ma asau ra u kubusi nin upiso, din kubusi kai sapat netes una langit, ma asau ra u palosi nin upiso, din palosi kai sapat netes una langit.” ");
INSERT INTO kqw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ra o Iesu i turbat anun a kum nat na ususer lena gong det inanos tar taio lena i a Karisito. ");
INSERT INTO kqw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tur pasi una bung ra, o Iesu i utalapor anun a kum nat na ususer lena, in nan ut usapat o Jerusalem. Ra in taramo a susut na mamaut ulaman a kum mugumugu, a kum lamlabino tene etabor torom o God, ma a kum tene ususer tagun a Warkurai, ma din um doko i. Ra a tulu bung in rop in laun pat melet. ");
INSERT INTO kqw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ra o Pita i ben gisen pas o Iesu ma i turbat dekdeki lena, “Gong Labino! Gong ut di pam tar a utna ri un ui.” ");
INSERT INTO kqw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","O Iesu i tupukus torom o Pita ra i watungi tano lena, “Satan, un nan unago numur tang! U ubatbat iau, uni, u muri kut a nuknukin a taro, ma ko mur a nuknukin o God.” ");
INSERT INTO kqw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ra o Iesu i watungi tan anun a kum nat na ususer lena, “Osi ra i nemi sur in mur iau, gong i mur a nuknukino. In los pas anun in nanai kutus ma in mur iau. ");
INSERT INTO kqw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Osi ra i maris bat anun a nilaun, in iru, ikut osi ra ke maris bat anun a nilaun sur iau, in laun. ");
INSERT INTO kqw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Osi ra in utur ukai a kum ututna rop taginin una rakrakon bual, ma a niono in iru, in wakak pepetlai toromi? In kul keles a niono nam asau? ");
INSERT INTO kqw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Uni a Nutun a Musano in nanpat nama minamar anun o Tamano, det nam anun a kum ensel, ma in pitar a ikul torom ara ra taktakai elar nam anun a pinapam. ");
INSERT INTO kqw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A inanos mot nama lingmulus, lako taro tagun mot ri mot tur nin, ka mot in mat utmakai, ra mot in tama a Nutun a Musano in nanpat tomo nam anun a matanitu.” ");
INSERT INTO kqw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Numur tan a wonom na bung, o Iesu i ben pas o Pita, o Jems ma o Jon, i ra a tisin o Jems, ra i ben gisen pas detul usapat una tangai ra i tur toto bing. ");
INSERT INTO kqw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tiro iai, detul tama a pinin o Iesu i wanpat senene. In masarino i sisio elar nam in matanas, ma anun a kum malu kai i kabang doko elar nama talapor. ");
INSERT INTO kqw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Uniutra, a tulu nat na ususer detul tama pas o Moses ma o Elaija der wanpat ra detul wasiso tomo nam o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","O Pita i watungi tan o Iesu lena, “Labino, i wakak ra dat kis nin. Ra u nemi, an pam lako tulu turturup, ara anumi, ara anun o Moses, ma ara anun o Elaija.” ");
INSERT INTO kqw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ra i wasiso utmakai, a du bakut ra i talapor doko i pulus bat pas det. Ma in nalngan ara tagisapat una du bakut ra, i watungi lena, “Iri i a Nutunglik, a nat na wakak, a gas doko nami. Mot in longoro i.” ");
INSERT INTO kqw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ra a tulu nat na ususer detul longoro i, detul ngara doko, ra detul puku pirso nama matandetul una piso. ");
INSERT INTO kqw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ikut o Iesu i wan torom detul, ra i pam detul ma i watungi lena, “Motul katutur, gong motul ngara.” ");
INSERT INTO kqw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ra detul tamtama toto, ka detul tama melet mo taio, o Iesu sot mukut kura i tur. ");
INSERT INTO kqw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ra det wan pirso nanan tagisapat una tangai, o Iesu i turbat tar detul lena, “Gong motul inanos tar taio un asau ri motul sa tama tari, tuk una bung ra a Nutun a Musano in katutur gusun a minat.” ");
INSERT INTO kqw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma anun a tulu nat na ususer detul tingi lena, “Sur asau ra a kum tene ususer tagun a Warkurai det watungi lena o Elaija in nanpat mugu?” ");
INSERT INTO kqw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I balu detul lena, “A lingmulus ut, o Elaija in nanpat mugu ma in ukodos melet a kum utna rop. ");
INSERT INTO kqw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ikut uniri a watungi torom motul lena, o Elaija i sa wanpat taru, ma ka det tasman lele i, det pam a kum sakino petutna uni, elar ut nam anundet a nemnem. Lenkutkai ra torom a Nutun a Musano, in taramo a ngunungut una laman a taro.” ");
INSERT INTO kqw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ra a tulu nat na ususer detul tasmani maragom lena, i wasiso torom detul un o Jon a Tene Baptaiso. ");
INSERT INTO kqw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","O Iesu ma a tulu nat na ususer det wanpat nisan a kunur na taro, ra ara musano i wan torom o Iesu, i kis butkeke numugu nisano, ");
INSERT INTO kqw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma i watungi lena, “Labino, un maris a nutunglik a musano, i ser mat lalang, ma i ser taramo a labino ngunungut. A susut na bung i ser puku una sungun, o una danim. ");
INSERT INTO kqw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A sa ben tari munung torom anum a kum nat na ususer, ikut ka det pet lar pasi sur det in ulangolango i.” ");
INSERT INTO kqw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","O Iesu i balu i lena, “Mot a taro tagun uniri, ka mot nurnur ma mot a kum tene sakino. A sa kis suano i torom mot. Nangisin mo mot in nurnur? Mot in ben a nat ra urin torom iau.” ");
INSERT INTO kqw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","O Iesu i wasiso dekdek torom a laulau na nion, ra a nion i pirso pas gusun a natlik. Ra una du bung utra i langolango. ");
INSERT INTO kqw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Numur a kum nat na ususer det wan torom o Iesu, ma det ting eno i lena, “Ilai ra ka met lakro lar pas a laulau na nion gusuni?” ");
INSERT INTO kqw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma i balu det lena, “Uni anumot a nurnur i natino doko. A inanos mot nama lingmulus, ra anumot a nurnur in natino elar nam in pitino mastad, mot in pet lar pasi sur mot in watungi tan a tangai ri, ‘Un karai taginin utong,’ ra in karai kut. Katu utna in ngangitin torom mot.” ");
INSERT INTO kqw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","O Iesu ma anun a kum nat na ususer det wan tomo tong una papor Galili, ra i watungi tandet lena, “Din pitar a Nutun a Musano ulaman a taro ");
INSERT INTO kqw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ma det in um doko i. Numur tan a tulu bung o God in ulaun melet pasi.” Ra a kum nat na ususer det longoro i, det tupunuk doko uni. ");
INSERT INTO kqw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","O Iesu ma anun a kum nat na ususer det wanpat tong o Kapernaum, ra det ra det ser los takis sur a rumu na etabor, det wan torom o Pita ma det tingi lena, “Anumot a tene ususer i ser pitar a takis sur a rumu na etabor o awu?” ");
INSERT INTO kqw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ra i mulaot lena, “Ma.” O Pita i ruk una rumu, ra o Iesu i wasiso mugu mut, ra i tingi lena, “Saimon, asau u nuki, a kum king taginin upiso det ser los a takis ma a ikul tan osi? Tan a kum nutnutundet o tan a taro gisen?” ");
INSERT INTO kqw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ra i balu i lena, “Tan a taro gisen.” O Iesu i watungi tano lena, “Ra i lenra, a kum nutnutundet, det langolango, ka det ser kul a takis. ");
INSERT INTO kqw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ikut, sur gong dar ban ukankan det, un nan usa utasi ma un boko. In mugano kiripo ra un dat pasi, un pagom a wano, ra un los pas a mani gusuni. Ma un los tari torom det sur a takis anundar rop.” ");
INSERT INTO kqw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Una du bung ra, anun a kum nat na ususer det wan torom o Iesu, ma det tingi lena, “Osi ra i labo sakit una matanitu tagisapat una langit?” ");
INSERT INTO kqw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","I kabo pas ara natlik toromi, i utur tari epotor tandet, ");
INSERT INTO kqw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma i watungi lena, “A inanos mot nama lingmulus, ra ka mot in nukpukus sur mot in elar nama kum nat liklik, ka mot in ruk lar pas una matanitu tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Osi ra i unatino pasi, elar nama natlik ri, i ut ra i labo sakit una matanitu tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Osi ra in gas pas tu natlik lenri una risang, i gas pas iau ut. ");
INSERT INTO kqw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ikut, osi ra in ben raro ara tagun a kum nat liklik ri, ra det nurnur un iau, a warkurai toromi, in laulau doko tan taio, ra din kubus tar tu labino wat un in kabarano, ma din woro murungi sa umadu. ");
INSERT INTO kqw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“In laulau torom a taro tagun a rakrakon bual, kibino una kum utna ra i dat a taro sur det in puku una sakino. A kum utna ra in nanpat ut, ikut in laulau doko torom o naro ra i pam pat pasi. ");
INSERT INTO kqw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ra a lamam, o a kikim i ben raro ui, kutus ru i ma un woro gisen ru i. In wakak ra un ruk una nilaun tukum a tumul kut ui, sur gong di woro ui tomo nama ru lamam, o aru kikim rop, una labino sungun ra ke ser rop. ");
INSERT INTO kqw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ra in matam i ben raro ui, liok ru i ma un woro gisen ru i. In wakak ra un ruk una nilaun tukum nam in teken matam kut, sur gong di woro ui tomo nam arin matam rop una labino sungun ra ke ser rop. ");
INSERT INTO kqw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Gong mot nuk natino pas taio tagun a kum nat liklik ri. A inanos mot, anundet a kum ensel sapat una langit det ser tama in masarin o Tita ra i kis sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Asau a nuknukimot? Ra tu musano anunu tu mar na sipsip, ma taio tagun det i raro. Pepetlai, ken nan pas gusun a lisu na noino ma lisu tiro una kum tangai, ma in sisio sur ara ra i raro? ");
INSERT INTO kqw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A inanos mot nama lingmulus, ra i sa sio pasi, anun a gasgas uni, in labo taun anun a gasgas una lisu na noino ma lisu ra ka det raro. ");
INSERT INTO kqw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lenkutkai ra, a Tamamot ra i kis sapat una langit, ke nemi sur taio tagun det a kum nat liklik ri in iru. ");
INSERT INTO kqw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ra o tisim i pam a sakino torom ui un nan toromi, ma mur kut mur in kis. Ra un watung puaso anun a niraro toromi. Ra in longoro ui, u sa umarom melet pasi. ");
INSERT INTO kqw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ra ken longoro ui, un ben melet pas taio o lako ru sur der in warut ui. Uni a Buk Tabu i watungi lenri, ‘Ra lako ru o lako tul anundetul a wasiso i takai kut un tu utna, anundetul a wasiso i lingmulus.’ ");
INSERT INTO kqw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ra ken longoro der, un upuaso i torom a taro na lotu. Ra ken longoro bulung a taro na lotu, i wakak sur un tama i elar nam o naro ra ausur a tene nurnur, o elar nam o naro ra a tene los takis. ");
INSERT INTO kqw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A inanos mot nama lingmulus, asau ra mot kubus i nin upiso, din kubus i kai sapat netes una langit, ma asau ra mot palos i nin upiso, din palos i kai sapat netes una langit. ");
INSERT INTO kqw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A watungi kai tamot, ra lako ru tagun mot nin upiso der mulaot un tu utna ra der sasaring suri, o Tita ra i kis sapat una langit in pam soti ut torom der. ");
INSERT INTO kqw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ra lako ru o lako tul detul kis tomo una risang, iau an kis tomo nam detul.” ");
INSERT INTO kqw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","O Pita i wan torom o Iesu, ra i tingi lena, “Labino, an man iso udumano ru a sakino ra o tising i pami torom iau? Lako wonomawit na dino ut?” ");
INSERT INTO kqw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","O Iesu i balu i lena, “Ausur a watungi tam lena a wonomawit na dino kut. A watungi lena a wonomawit na noino ma wonomawit na dino. ");
INSERT INTO kqw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tama i, a matanitu tagisapat una langit i elar nam ara king, ra i nemi sur anun a kum tultul det in ukodos a mani ra det los papasi tano. ");
INSERT INTO kqw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ra i turpas a iting, di ben pat ara tultul toromi. A tultul ra i los pas a noino arip na kina, ");
INSERT INTO kqw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ikut katu mani sur in balu i nami. Ra anun a labino i pitar a warkurai sur din siuru pas a musano ra, tomo nam anun a ino, ma a kum nutnutunu, ma anun a kum ututna rop, sur din balu a mani ra nami. ");
INSERT INTO kqw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ra a tultul ra i kis butkeke umatan anun a labino, ra i saringi lena, ‘Un madek ru iau munung, numur an balu rop tar anum a kum mani.’ ");
INSERT INTO kqw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma a labino anun a tultul ra i marisi, ra i watungi tano lena, ‘Un nan. Gong mukut u balu i.’ ");
INSERT INTO kqw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“A tultul ra i pirso unago utamon, ra i barato pas ara tultul ra numugu i los pas a noino kina kut tano. I pam ukai pasi, i bing in kabarano, ra i watungi tano lena, ‘Un balu tar anung a mani ra u los pasi.’ ");
INSERT INTO kqw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A pasano ra i kis butkeke umatano ra i saringi lena, ‘Un madek ru iau munung, numur an balu melet tar anum a mani.’ ");
INSERT INTO kqw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ikut ke longoro pasi. I beni kut ra i uruk tari una karabus, tuk una bung ra in balu tar a mani ra i los pasi. ");
INSERT INTO kqw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ra a kum paspasano det tama a kum petutna ra, det taramo laulau i. Det wan torom anundet a labino, ra det inanosi una kum utna ra a tultul ra i sa pam tari. ");
INSERT INTO kqw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Anun a labino i kabo pasi, ma i watungi tano lena, ‘Ui, a sakino tultul ui. A madek ru ui sur gong mo u balu a mani ra u los pasi tang, uni u saring iau. ");
INSERT INTO kqw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ilai ra ko nem a pasam elar nam iau a nem ui?’ ");
INSERT INTO kqw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anun a labino i kankan toromi, ra i pitar tari tan a kum tene tamtamabat tagun a karabus sur det in ukadik laulau i tuk in balu tari ut a mani ra i los pasi. ");
INSERT INTO kqw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ra ka mot in dumano ru a sakino petutna ra a kum tistisimot det pam tari torom mot, o Tita ra i kis sapat una langit in pami kai lenra torom mot taktakai. ” ");
INSERT INTO kqw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ra o Iesu i sa watung rop tar a kum wasiso ri, i wan tagitong o Galili, utong una papor Judia, un ara papor danim Jodan. ");
INSERT INTO kqw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma a labino kunur na taro det muri, ma i ulangolango pas a kum misait tiro iai. ");
INSERT INTO kqw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A ramano kum Parisi det wan toromi sur det in lari. Det tingi lena, “I tokodos ut elar nam anundat a kum Warkurai sur a musano in lakro ru anun a ino un tu utna oros kut, o awu?” ");
INSERT INTO kqw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I balu det lena, “Pepetlai, ka mot luk utmakai a wasiso una Buk Tabu? I watungi lenri: Una turturkibin a ukukis, a Tene Ukukis ‘i ukis a taro, sur det in musano ma det in ino,’ ");
INSERT INTO kqw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma i watungi lena, ‘Iri a kibino ra a musano in nan gusun o tamano ma o nano, ma in kis tomo nam anun a ino, sur der in takai mukut.’ ");
INSERT INTO kqw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ra ausur mo der aru, der takai mukut. Asau ra o God i sa kubus tomo tari, gong melet mo taio i kutusi.” ");
INSERT INTO kqw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Det ting meleti lena, “Ilai sur o Moses i pitar a warkurai sur a musano in pitar a dono buk na kutus nolin torom anun a ino, sur din palos ru a kinkinis na nolin?” ");
INSERT INTO kqw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I balu det lena, “O Moses i mulaot ru mot sur mot in lakro ru anumot a kum wardain, uni a balamot i dekdek doko. Ikut una turturkibin a ukukis ausur i lenra. ");
INSERT INTO kqw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A watungi tamot, osi ra in lakro ru anun a ino ra ke pam tu sakino tomo nam tu musano gisen, ma a musano ra i nolin melet nam tu ino, a musano ra i pam a sakino.” ");
INSERT INTO kqw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ra anun a kum nat na ususer det watungi tano lena, “Ra i lenra, i wakak sur gong di nolin.” ");
INSERT INTO kqw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I balu det lena, “Ausur a taro rop ka det in nolin. Det kut ra o God i sa pitar tar a dekdek tandet. ");
INSERT INTO kqw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iri a kum kibino ra lako taro ka det in nolin: Ara taro di usus det lenutra. Ara taro, a taro det banlaulau det, ma ara taro kai, ka det nolin uni det balon una pinapam una matanitu tagisapat una langit. Osi ra in pet lar pasi, in mur a wasiso ri.” ");
INSERT INTO kqw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Di ben a kum nat liklik torom o Iesu sur in ubek aru lamano netes un det ma in wararing un det. Ikut anun a kum nat na ususer det sakbat det. ");
INSERT INTO kqw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","O Iesu i watungi lena, “Mot in madek ru a kum nat liklik sur det in nan torom iau. Gong mot turbat det, uni a matanitu tagisapat una langit anundet ra det lenri.” ");
INSERT INTO kqw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ra i ubek tar aru lamano netes un det, numur i wan tagitiro. ");
INSERT INTO kqw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ara barman i wan torom o Iesu, ra i tingi lena, “Tene Ususer, osi na wakak na utna ra an pami sur an rakon a nilaun tukum?” ");
INSERT INTO kqw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","O Iesu i balu i lena, “Sur asau ra u ting iau un asau ra i wakak? Ara sot kut i wakak. Ra u nemi sur un ruk una nilaun tukum, un tarom una kum Warkurai.” ");
INSERT INTO kqw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ra i tingi lena, “Osi na kum Warkurai?” O Iesu i balu i lena, “‘Gong u um doko taio, gong u pam a sakino un tu ino anun taio, gong u wolong, gong u etakun torotoro, ");
INSERT INTO kqw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","un ru o tamam ma o nam,’ ma ‘un nem a pasam elar nam i ra u nem ui ut.’” ");
INSERT INTO kqw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A barman ra i watungi tano lena, “A kum Warkurai rop ri a sa mur sot pasi. Asau melet mo an pami?” ");
INSERT INTO kqw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","O Iesu i balu i lena, “Ra u nemi sur un nanpat tokodos mulus, un nan ma un siuru ru anum a kum ululeng rop, ra a mani taguni, un tabor a kum sibo na taro nami. Ra un pami lenra, anum a wakak na ululeng kusapat una langit. Numur un nan urin ma un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ra a barman i longoro a wasiso ri, i wan ma ikut ke gasgas, uni i labo doko anun a ululeng. ");
INSERT INTO kqw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ra o Iesu i watungi tan anun a kum nat na ususer lena, “A inanos mot nama lingmulus, i ngangitin doko torom a tene gongon sur in ruk una matanitu tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A watungi kai tamot lena, in ngangitin sur a kamel in ruk una mato na sur na susuk, ikut, i ngangitin doko sur a tene gongon in ruk una matanitu anun o God.” ");
INSERT INTO kqw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ra anun a kum nat na ususer det longoro i, det kisin doko ma det watungi lena, “Ra i lenra, osi mo ra din ulauni?” ");
INSERT INTO kqw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O Iesu i tamtama torom det ra i watungi lena, “A taro ka det in pet lar pasi, ikut o God sot kut in pet lar pas a kum utna rop.” ");
INSERT INTO kqw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","O Pita i balu i lena, “Tama i, met sa wan gusun anumet a kum utna rop, ra met mur ui. Asau ra met in rakoni numur?” ");
INSERT INTO kqw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","O Iesu i watungi tandet lena, “A Nutun a Musano in kis na king una nun a kiskis na minamar ra din umatok a kum utna rop. A inanos mot nama lingmulus, una du bung ra, mot ra mot sa mur iau, mot in kis una noino ma aru kiskis na king, ma mot in kuro a noino ma aru kabotaro Israel. ");
INSERT INTO kqw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma det rop taktakai ra det sa wan gusun anundet a kum rumu, o gusun a kum tistisindet a kum musano ma a kum ino, o gusun a kum tamtamandet, o a kum nanandet, o a kum nutnutundet, o gusun anundet a kum piso, kibino un iau, din pitar a marmar na utna lenri tandet, ma det in rakoni kai a nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ikut a susut ra det mugu uniri, numur det in mur, ma det ra det mur uniri, numur det in mugu.” ");
INSERT INTO kqw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“A matanitu tagisapat una langit i elar nama taman a kinobot na wain, i pirso una kobot raut sur in iting sur lako kum tene pinapam sur det in papam una nun a kinobot na wain. ");
INSERT INTO kqw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Det kubus wasiso tomo pas nama kum tene pinapam sur det in los a ikul tagun ara bung na pinapam, ra i tulu det sur anun a kinobot na wain. ");
INSERT INTO kqw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Una lisu na pakano bung, i wan melet ra i tama pas ara taro bulung det tur ororos kut una nubual na inawan tomo. ");
INSERT INTO kqw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ra i watungi tandet lena, ‘Mot kai, mot in nan, ma mot in papam una nung a kinobot na wain, ma an tokom mot nam asau ra i tokodos.’ ");
INSERT INTO kqw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ra det wan. “Una labino suan i wan ra i iting melet sur lako kum tene pinapam, ma una tulu pakano bung una lirop i wan melet sur lako taro. ");
INSERT INTO kqw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Una limo na pakano bung una lirop i wan melet, ma i tama pas ara taro bulung det tur ororos kut. Ra i watungi tandet lena, ‘Ilai ra mot tur ororos kut nin, a kudulano bung rop ri?’ ");
INSERT INTO kqw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Det balu i lena, ‘Katutaio i ben met sur tu pinapam.’ I watungi tandet lena, ‘Mot kai mot in nan ma mot in papam una nung a kinobot na wain.’ ");
INSERT INTO kqw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ra i sa lirop matano mirum, a taman a kinobot na wain, i watungi tan a mugumugu tagun anun a kum tene pinapam lena, ‘Kabo pas a kum tene pinapam urin, ma un tokom det. Det ra det wanpat murmur sakit un tokom mugu det. Numur un tokom imurmur a kum tene pinapam tuk un det ra det mugu pat.’ ");
INSERT INTO kqw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A kum tene pinapam ra di ben pas det una limo na pakano bung det wanpat, ra di tokom det taktakai nama ikul tagun ara bung na pinapam. ");
INSERT INTO kqw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Det ra di ben mugu pas det det wanpat. Det nuki lena det in los a labino ikul. Ikut, awu! Det kai di tokom det taktakai nama ikul tagun ara bung na pinapam kut. ");
INSERT INTO kqw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ra det sa lolos pas, det ururai torom a taman a kinobot na wain, ");
INSERT INTO kqw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","det watungi lena, ‘Det ri ka det papam suanoi, ma met, met pam a dekdek na pinapam ma a suan i rang met, ikut u tokom det utkai elar nam met.’ ");
INSERT INTO kqw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ra i balu ara tandet lena, ‘Pasang, ausur a banlaulau ui. Pepetlai, ka dar kubus pas a wasiso sur a ikul tagun ara bung na pinapam? ");
INSERT INTO kqw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Los pas anum a mani, ma un nan. Iau ut a nemi sur an tokom det ra det wanpat murmur elar nam ui ra u mugu. ");
INSERT INTO kqw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Pepetlai, ke sot sur an pam asau ra a nemi nam anung a mani? U nuknuk laulau un iau, uni a maris a taro ri?’ ");
INSERT INTO kqw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","I lenri, det ra uniri det mur, det in mugu, ma det ra uniri det mugu, det in mur.” ");
INSERT INTO kqw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ra o Iesu i wan nanan usapat o Jerusalem, i ben gisen pas anun a noino ma aru nat na ususer, ma i watungi tandet lena, ");
INSERT INTO kqw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tama i, iri dat wan nanan usapat o Jerusalem. Din pitar a Nutun a Musano torom a kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai. Det in warkurai i sur in iru, ");
INSERT INTO kqw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ma det in pitar tari torom det, ra ausur a taro Juda sur det in urongon laulau uni, det in taktakalo i, ma det in sak wati un in nanai kutus. Ra a tulu bung in rop in laun pat melet.” ");
INSERT INTO kqw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Numur a nan aru nutnutun o Sebedi i wan torom o Iesu nam aru nutnutunu. I kis butkeke umatano ma i saringi sur in tarom una nun a nemnem. ");
INSERT INTO kqw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma o Iesu i tingi lena, “Asau ra u nemi?” Ra i balu i lena, “Un mulaot sur aru nutnutung ri, der in kis tomo nam ui una num a matanitu, ara una sot na lamam, ma ara pasander una kair, ma motul in warkurai tomo.” ");
INSERT INTO kqw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","O Iesu i balu i lena, “Ka motul tasman asau ra motul sasaring suri. Pepetlai, in elar sur mur kai mur in inum una kap na mamaut ra an inum uni?” Der balu i lena, “Mir in pet lar pasi kut.” ");
INSERT INTO kqw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I watungi tander lena, “A lingmulus ut, a kap na mamaut ra an inum uni, mur kai mur in inum uni. Ikut a kinkinis una sot na lamang ma una kair, ausur iau, a warkurai sur an pitari. O Tita in pitari torom det ra i sa waninar tari sur det.” ");
INSERT INTO kqw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ra a noino nat na ususer det longoro i, det kankan torom dersino ra. ");
INSERT INTO kqw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","O Iesu i kabo tomo pas det, ra i watungi lena, “Mot tasmani lena a kum tene warkurai anun a taro ra ausur a taro Juda, det kuro laulau a taro. Ma anundet a kum mugumugu kai det pitar a kum dekdek na warkurai torom anundet a taro. ");
INSERT INTO kqw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ikut torom mot ken lenra. Osi ra i nemi sur in labo tamot, in unatino pasi sur in tultul anumot. ");
INSERT INTO kqw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma osi ra i nemi sur in mugumugu anumot, in papam oros kut torom mot ma ka din kuli. ");
INSERT INTO kqw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lenkutkai ra a Nutun a Musano ke wanpat sur din papam toromi. I wanpat sur i ut in papam torom a taro, ma in pitar tar anun a nilaun, a ikul, sur in kul langolango pas a susut na taro.” ");
INSERT INTO kqw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","O Iesu ma anun a kum nat na ususer det wan tagitong o Jeriko, a labino kunur na taro det mur det. ");
INSERT INTO kqw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aru musano aru pulu der kis taru una papor ina kisapi. Ra der longoro i lena o Iesu i wan nanan milau, der kakabo dekdek lena, “Labino, a Nutun o Dewid, un maris mir.” ");
INSERT INTO kqw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma a kunur na taro det turbat der sur der in kis wowowon. Ikut der kakabo dekdek makai usapat, “Labino, a Nutun o Dewid, un maris mir.” ");
INSERT INTO kqw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","O Iesu i tur sikot, ra i kabo pas der, ma i ting der lena, “Asau ra mur nemi sur an pami un mur?” ");
INSERT INTO kqw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Der balu i lena, “Labino, mir nemi sur mir in tamtama.” ");
INSERT INTO kqw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","O Iesu i maris doko der, ra i pam arin matander. Uniutra der tamtama, ma der muri. ");
INSERT INTO kqw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ra det wan milau o Jerusalem, det wanpat tiro o Betpage una Tangai na Oliw, o Iesu i tulu aru nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","I watungi tander lena, “Mur in nan sur a tamon kura numugu tamur. Ra mur in nanpat mur in tama ara dongki kura di ker ukai tari, tomo nama nutunulik. Mur in palos pas der, ma mur in ben der urin torom iau. ");
INSERT INTO kqw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ra taio in ting mur un der, mur in watungi lena, ‘A Labino i nem der,’ ra uniutra in madek ru der torom mur.” ");
INSERT INTO kqw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Di pam a utna ri sur din pam sot pas a wasiso anun o God ra a poropet i sa watung tari numugu lena, ");
INSERT INTO kqw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mot in inanos a taro Saion lena, ‘Tama i, anumot a king uniri i wanpat torom mot, i unatino pasi, ma i kas una dongki, a barman na dongki.’” ");
INSERT INTO kqw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aru nat na ususer der wan, ma der pami elar nama wasiso ra o Iesu i sa watung tari tander. ");
INSERT INTO kqw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Der ben pas a dongki tomo nama nutunu, der rakon ru anunder aru saket, ma der ubek tari netes una aru dongki, ra o Iesu i kas un der. ");
INSERT INTO kqw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A labino kunur na taro kai det rakon ru anundet a kum saket, ma det languni una kisapi. Ma ara taro kai det tau pas a kum turunu duwai ma det ubek tari una kisapi. ");
INSERT INTO kqw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A kunur na taro ra det mugu tano, ma det kai ra det mur, det kukukuk lena, “Osana torom a Nutun o Dewid! Dat in watung ulabo pas o naro ra i wanpat nama risan a Labino!” “Osana usapat netes sakit!” ");
INSERT INTO kqw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ra o Iesu i wanpat sapat o Jerusalem, a taro Jerusalem rop det kisin ra det iting lena, “Osi ra?” ");
INSERT INTO kqw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ra a taro ra det wan tomo nam i det watungi lena, “A musano ri i o Iesu, a poropet tagitong o Nasaret una papor Galili.” ");
INSERT INTO kqw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","O Iesu i ruk una ara dino tagun a rumu na etabor, ra i lu ru pirso det rop ra det siuru, ma det kai ra det kukul tiro iai. I woro bulus ru a kum kabulu anun a kum tene keles mani, ma a kum kiskis anundet ra det siuru a kum tabun. ");
INSERT INTO kqw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma i watungi tandet lena, “Di sa tumus tari una Buk Tabu lena, ‘Din watung anung a rumu nama rumu na niaring.’ Ikut mot sa pam pukus pasi sur in elar mukut nama ‘rumu anun a kum tene wolong.’” ");
INSERT INTO kqw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A kum pulu ma det ra a kikindet i mat det wan toromi una rumu na etabor ma i ulangolango pas det. ");
INSERT INTO kqw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ra a kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai det tama a wakak na utna sakit ri i pami, ra det longoro i kai a kum nat liklik det kukukuk una dino na rumu na etabor lena, “Osana torom a Nutun o Dewid,” det kankan doko. ");
INSERT INTO kqw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ra det ting o Iesu lena, “U sa longoro tar a kum wasiso ri anun a kum nat liklik?” O Iesu i balu det lena, “Ma! Pepetlai, ka mot luki utmakai a wasiso tagun a Buk Tabu? I watungi lena, ‘U sa ususer tar a kum nat liklik sur det in watung ulabo pas ui.’” ");
INSERT INTO kqw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ra i wan gusun det tiro iai, ra i wan utong o Betani ra i inep pas ara bung na mirum tong. ");
INSERT INTO kqw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Una kobot raut o Iesu i milet melet usapat o Jerusalem, ra i murak. ");
INSERT INTO kqw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I tama pas in nanai na fig i tur taru una papor ina kisapi, ra i wan milau i. Ikut ke tama lako wino, a dondono rop kut. Ra i watungi torom in nanai ra lena, “Turpasi uniri ma numur, kon wu melet mo.” Uniutra, in nanai i marang. ");
INSERT INTO kqw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ra a kum nat na ususer det tama i, det kisin, ra det tingi lena, “In nanai na fig ri, i marang lakit lai?” ");
INSERT INTO kqw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","O Iesu i balu det lena, “A inanos mot nama lingmulus, ra mot nurnur, ma ka mot in wur nuknuk, mot in pam a pinapam ri a pami un in nanai na fig. Ausur i kut ri ra mot in pami, awu. Ra mot in watungi kai torom a tangai ri lena, ‘Un taragot ma un sirok losop usa utasi,’ in pami kut. ");
INSERT INTO kqw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ra mot nurnur, a kum utna rop ra mot wararing suri, din pitari ut torom mot.” ");
INSERT INTO kqw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","O Iesu i ruk una rumu na etabor, ma i ususer a taro. A kum lamlabino tene etabor torom o God ma a kum mugumugu anun a taro det wan toromi. Ra det tingi lena, “Asi na ngas na dekdek ra u pam a kum utna ri nami? Osi ra i pitar tar a dekdek ri torom ui?” ");
INSERT INTO kqw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ra o Iesu i balu det lena, “Iau kai an ting mot nam ara iting. Ra mot in balu i, an inanos mot una dekdek ra a ser pam a kum utna ri nami. ");
INSERT INTO kqw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tagai a baptais ra o Jon i baptaiso a taro nami? Tan o God, o tan a taro kut?” Ra det wasiso eno pas lena, “Ra dat in watungi lena, ‘Tan o God,’ in balu dat kut lena, ‘Sur asau ra ka mot nurnur uni?’ ");
INSERT INTO kqw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ikut ra dat in watungi lena, ‘Tan a taro,’ dat in ngaran a taro, sako det in kankan torom dat, uni det rop det nurnur un o Jon lena, i a poropet.” ");
INSERT INTO kqw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ra det balu o Iesu kut lena, “Ka met tasmani.” Numur o Iesu i watungi tandet lena, “Iau kai, kan inanos mot una dekdek ra a ser pam a kum utna ri nami.” ");
INSERT INTO kqw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","O Iesu i inanos det lena, “Asau mot nuki? Ara musano aru nutnutunu, aru nat musano. I wan torom a mugano, ra i watungi tano lena, ‘Nutunglik, uniri un nan sur a kinobot na wain ma un papam.’ ");
INSERT INTO kqw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ra o nutunulik i watungi lena, ‘Iau kan nan,’ ikut numur i pukus melet a nuknukino, ra i wan. ");
INSERT INTO kqw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ra o tamano i wan bulung torom ara pasander, ra i inanosi utkai lenra, ra a nutunulik i balu i lena, ‘I wakaak kut tita, an nan ut,’ ikut ke wan. ");
INSERT INTO kqw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Osi na pasander ra i tarom tan a tamander?” Det balu i lena, “A mugano.” O Iesu i watungi tandet lena, “A inanos mot nama lingmulus, a kum tene los takis ma a kum pamuk na ino, kuri det ruk mugu nanan tamot, una matanitu anun o God. ");
INSERT INTO kqw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","O Jon i wanpat ra i ususer mot una tokodos na petutna, ra ka mot nurnur uni, ikut a kum tene los takis ma a kum pamuk na ino det nurnur uni. Mot tama tar det ut, ikut ka mot nukpukus kai sur mot in nurnur uni.” ");
INSERT INTO kqw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mot in longoro ara wasiso elelar bulung ri: Ara musano i marut tar a kinobot na wain, ra i pam bat tari nam in noworo. Tiro ubalan a kinobot, i kil tar in nutung sur din pas ginogino a wain uni sur a polono in nanpat. Ma i pam tar a nat na rumu lekeleke sur a tene tamtamabat. Numur i pitar tar a kinobot munung tan a ramano kum tene pinapam sur det in tamtamabati, ra i wan sur ara tamon gisen. ");
INSERT INTO kqw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ra i milau a kalang sur din git tomo a wino wain, i tulu ru anun a kum tultul torom a taro na pinapam, sur det in los pas anunu lako wino wain. ");
INSERT INTO kqw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A taro na pinapam ra, det pam ukai pas anun a kum tultul, det um ara, det um doko ara ma ara kai det duku doko i nama kum watat. ");
INSERT INTO kqw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","I tulu melet anun a ramano kum tultul, det susut tandet ra det mugu, ikut a taro na pinapam det pam meleti kut lenra un det. ");
INSERT INTO kqw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Numur i tulu ru ut a nutunulik torom det, uni i nuki lena det in urur uni. ");
INSERT INTO kqw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikut, ra a taro na pinapam det tama pas o nutunulik det wasiso tomo pas lena, ‘I ra in keles o tamano, i mo ri i wan urin. Mot iap, dat in um doko i, sur anundat mo a kinobot na wain.’ ");
INSERT INTO kqw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ra det pam ukai pasi, det woro pirso ru i tagun a kinobot, ma det um doko ru i.” ");
INSERT INTO kqw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Numur o Iesu i ting a taro lena, “Ra a taman a kinobot na wain in nanpat, asau ra in pami torom a taro na pinapam?” ");
INSERT INTO kqw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Det balu i lena, “In um doko rop ru a sakino taro ra, ma in pitar tar anun a kinobot na wain torom lako taro na pinapam gisen, sur det in tamtamabati. A taro na pinapam maragom ra, det in pitar tar anunu lako wino wain toromi una kalang na ngigit.” ");
INSERT INTO kqw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","O Iesu i watungi tandet lena, “Pepetlai, ka mot luk a wasiso ri una Buk Tabu? I watungi lena, ‘A wat ra a kum tene pam rumu det lakro ru tari, i ut ra, a wakak na wat ra i udekdek a rumu. A utna ri, a Labino ut i sa pam tari, ma i wakak sakit una numet a tamtama.’ ");
INSERT INTO kqw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","I mo ra a watungi tamot lena, din rakon ru a matanitu anun o God gusun mot, ma din pitar tari tan ara taro ra det in wu a wakak na windet.”  ");
INSERT INTO kqw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Osi ra in puku taru una wat ri, in tiginogino, ma osi ra a wat ri in puku taru uni, in tiginogino elar nama kubus. ");
INSERT INTO kqw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ra a kum lamlabino tene etabor torom o God ma a kum Parisi det longoro a kum wasiso elelar anun o Iesu, det tasmani ut lena i wasiso kut un det. ");
INSERT INTO kqw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ra det sisio sur tu kisapi sur det in pam ukai i uni, ikut det ngaran a kunur na taro, uni a taro det nurnur uni lena i a poropet. ");
INSERT INTO kqw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","O Iesu i wasiso melet torom det nama wasiso elelar lenri, ");
INSERT INTO kqw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A matanitu tagisapat una langit i elar nama king ra i sa waninar tar a lukaro na unolin sur o nutunu, a musano. ");
INSERT INTO kqw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ra i tulu ru anun a kum tultul torom det, ra di sa inanos mugu tar det, sur det in ben pas det sur a lukaro. Ikut det putut rop kut. ");
INSERT INTO kqw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","I tulu ru i bulung anun a ramano kum tultul gisen nama wasiso lena, ‘Mot in inanos det ra di sa inanos mugu tar det lena, “A sa waninar rop tar a utna na inangon. A sa um doko tar a kum bulumakau ma a kum matok na butbut na bulumakau, a kum utna i sa waninar rop. Mot in nan urin una lukaro na unolin.” ’ ");
INSERT INTO kqw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ikut ka det tarom, det wan gisgisen kut. Ara i wan sur ana kinobot, ara kai sur anun a rumu na siuru. ");
INSERT INTO kqw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma ara taro kai ra di wan sur det, det pam ukai pasi kut a kum tultul, ma det banlaulau det ma det um doko det. ");
INSERT INTO kqw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A king ra, in balano i sungun doko, i tulu ru anun a taro na inaim, ra det um doko ru a kum tene umum doko taro ra, ma det tun ru anundet a tamon. ");
INSERT INTO kqw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“I watungi melet tan anun a kum tultul lena, ‘Di sa waninar tar a lukaro na unolin, ikut det ra di sa inanos mugu tar det, ka det tokodos sur det in kis una lukaro. ");
INSERT INTO kqw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mot nan una kum kisapi ma osi ra mot in etoromi, mot in inanosi lena in nan urin sur a lukaro.’ ");
INSERT INTO kqw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ra a kum tultul det wan una kum kisapi, ma det ben tomo det rop ra det etorom det, a kum sakino taro ma a kum wakak na taro kai, ma a lukaro na unolin i bukus nam det. ");
INSERT INTO kqw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ra a king i ruk sur in tama a taro, i tama torom pas ara musano ra ke emar nam tin namalu na lukaro na unolin. ");
INSERT INTO kqw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma i tingi lena, ‘Le, u ruk lai taru urin? Uni ka num tin namalu na lukaro na unolin.’ A musano ra ke balu i. ");
INSERT INTO kqw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ra a king i watungi tan anun a kum tultul lena, ‘Mot in ker pas aru kikino ma aru lamano ma mot in woro pirso ru i unago utamon una dumirum. Tiro iai di tangtangis ma di ungingit lokondi iai.’ ");
INSERT INTO kqw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Di sa kabo pas a susut, ikut di pilok pas a pak na taro mukut.” ");
INSERT INTO kqw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Numur a kum Parisi det wan tomo taru, ra det epak pas lena det in lar o Iesu sur tu wasiso anunu, ra det in takuni nami. ");
INSERT INTO kqw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Det tulu ru anundet a kum nat na ususer tomo nama kum paspasan o Erod torom o Iesu, ma det watungi lena, “Tene Ususer, met tasmani lena ui a tokodos na musano, ma u ususer a taro una kisapi anun o God nama lingmulus. Ko nuknuk bing un asau ra a taro det watungi un ui, uni a magiram i takai kut torom a taro rop. ");
INSERT INTO kqw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Un inanos met, asau a nuknukim? I tokodos sur din pitar a takis torom a Sisa o awu?” ");
INSERT INTO kqw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ikut, o Iesu i tasmani lena, a nuknukindet i laulau, ra i watungi tandet lena, “Mot a kum tene torotoro, ilai ra mot nemi sur mot in lar iau? ");
INSERT INTO kqw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mot in ese iau un tu mani na takis.” Ra det pitar tar a mani tano. ");
INSERT INTO kqw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma i ting det lena, “In masarin osi ri, ma a tumtumus ri uni anun osi?” ");
INSERT INTO kqw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Det balu i lena, “Anun a Sisa.” Ra i watungi tandet lena, “Asau ra anun a Sisa, mot in pitari torom a Sisa. Ma asau ra anun o God, mot in pitari torom o God.” ");
INSERT INTO kqw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ra det longoro i, det kisin doko ma det wan gusuni. ");
INSERT INTO kqw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Una bung ut ra a kum Sadusi, ra det ser ipul kut lena katu nilaun melet gusun a minat, det wan torom o Iesu, ma det tingi lena, ");
INSERT INTO kqw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tene Ususer, o Moses i watungi lena, ra tu musano in mat pas gusun anun a ino, ma katu nutunder, o tisinolik in ben pasi ra in nolin nami, sur in ulabo tar lako kum nat una risan o tisino ra i sa mat. ");
INSERT INTO kqw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","26","Ara kabo tisino a wonomawit na musano det, det kis epotor tamet. A mugano i nolin, ra i mat pas gusun anun a ino, ma katu nutunder. Ra a murmur tano bulung i nolin nama ino ra, ma i bulung i mat kut gusuni. Numur a mantul na tisino bulung. Ra i lenra torom a wonomawit, det rop det nolin nami, ikut katu nutun tu pasandet. ");
INSERT INTO kqw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ra numur a ino bulung i mat. ");
INSERT INTO kqw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Una nilaun melet gusun a minat, a ino ra, anun osi na pasandet mo? Uni det rop det sa nolin pas nami.” ");
INSERT INTO kqw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","O Iesu i balu det lena, “Mot raro doko, uni ka mot tasman a Buk Tabu ma a dekdekin o God kai. ");
INSERT INTO kqw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Una nilaun melet gusun a minat, ka det in nolin melet mo, det in elar mukut nama kum ensel sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ra mot ipul lena a kum minat ka det in laun melet gusun a minat, pepetlai, ka mot luki utmakai a wasiso ra o God i sa watung tari tamot? I watungi lena, ");
INSERT INTO kqw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iau a God anun o Abaram, a God anun o Aisak ma a God anun o Jekop.’ O God ausur a God anun a kum minat, i a God anundet ra det laun.” ");
INSERT INTO kqw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ra a kunur na taro det longoro i, det kisin doko una nun a ngas na etowo. ");
INSERT INTO kqw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","A kum Parisi det longoro i lena, o Iesu i sa duku sot pas a kum Sadusi, ra det wan tomo toromi. ");
INSERT INTO kqw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma ara pasandet, a tene mananos una Warkurai, i lari nama iting lena, ");
INSERT INTO kqw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tene Ususer, asi na warkurai ra i labo sakit tandet rop?” ");
INSERT INTO kqw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma i balu i lena, “‘Un nem a Labino anum a God nam in balam rop, a niom rop, ma a nuknukim rop.’ ");
INSERT INTO kqw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A warkurai ri i labo sakit tandet rop, ma i a mugano warkurai. ");
INSERT INTO kqw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma iri i a manru na warkurai, ra i ling na elar nami, ‘Un nem a pasam elar nami, ra u nem ui ut.’ ");
INSERT INTO kqw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aru warkurai ri, der a kimkibin a kum wasiso na Warkurai rop anun o Moses ma a kum etowo anun a kum poropet.” ");
INSERT INTO kqw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ra a kum Parisi det kis tomo, o Iesu i ting det lena, ");
INSERT INTO kqw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Asau ra mot nuki una Karisito? I a nutun osi?” Det balu i lena, “A nutun o Dewid.” ");
INSERT INTO kqw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","O Iesu i watungi tandet lena, “Ra in lenra, ilai ra a Tokodos na Nion i mugu o Dewid ra i watung a Karisito lena ‘anung a Labino’? Uni o Dewid i watungi lena, ");
INSERT INTO kqw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A Labino i watungi torom anung a Labino, “Un kis una papor sot na lamang, tuk ra an turus pas anum a kum ebar sur det in kis utuntudu ina num a warkurai.” ’ ");
INSERT INTO kqw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","O Dewid i watung a Karisito lena i anun a Labino. Ra i lenra, der tamano pepetlai?” ");
INSERT INTO kqw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma kataio i nuk pas tu wasiso melet sur in balu i nami. Turpasi una bung ra, kataio melet mo i wan toromi nam tu iting, uni det ngara. ");
INSERT INTO kqw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Numur o Iesu i watungi tan a kunur na taro ma anun a kum nat na ususer lena, ");
INSERT INTO kqw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“A kum tene ususer tagun a Warkurai ma a kum Parisi det ususer a taro nama kum Warkurai elar nami ra o Moses i pami. ");
INSERT INTO kqw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A kum utna rop ra det ususer mot uni, mot in tarom uni, ma mot in pami. Ikut, gong mot mur anundet a ngasino, uni det watung tari kut, ma det ut, ka det pami. ");
INSERT INTO kqw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Det pitar tar a kum dekdek na warkurai sur a taro det in muri, ikut det ut, ka det warut det uni. ");
INSERT INTO kqw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Anundet a kum pinapam rop, det pami kut, sur a taro det in tama det. I perere bing anundet a kum bok liklik ra det ser uruk tar a kum du Buk Tabu uni ma det keri una kum masmasaridet. I walos bing anundet a kum kulo ra kura una sinisir ina nundet a kum malu na niaring. ");
INSERT INTO kqw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Det nem a kinkinis na labino sa numugu una kum lukaro, ma a kinkinis kai sa numugu una kum rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma det nemi sur a taro det in pitar a labino urur torom det una kum nubual na inawan tomo, ma det in watung det kai nama kum tene ususer. ");
INSERT INTO kqw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ikut, gong di watung mot a kum tene ususer, uni ara Tene Ususer sot kut anumot. Ma mot, mot nisnisino. ");
INSERT INTO kqw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ra gong mot tar tamamot un taio taginin upiso, uni ara Tamamot sot kut, ra i kis sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma gong di watung mot kai a kum mugumugu, uni ara sot kut anumot a mugumugu, a Karisito kut. ");
INSERT INTO kqw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma osi ra i labo tamot, in unatino pasi, ma in tarom lu mot. ");
INSERT INTO kqw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uni osi ra i ulabo pasi, din unatino i. Ma osi ra i unatino pasi, din ulabo i.” ");
INSERT INTO kqw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","O Iesu i watungi lena, “In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot tagar bat a taro sur gong det ruk una matanitu tagisapat una langit. Ma mot ut, ka mot ruk uni, ma ka mot madek a taro ra det nem na ruk, sur det in ruk. ");
INSERT INTO kqw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot wan tuptupukus sa utasi ma sa ubual, sur mot in dat pukus taio, sur in nanpat a nat na ususer anumot. Ra i sa tarom, mot tarai taru uni, sur in nan una labino sungun, ma anun a sakino petutna in labo tan anumot a sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“In laulau doko torom mot a kum pulu na mugumugu, uni mot watungi lena, ‘Ra taio i liliman nama rumu na etabor, ke maut, ikut ra taio i liliman nama gol una rumu na etabor, i ra i lingmulus.’ ");
INSERT INTO kqw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mot a kum longlong na pulu! Asau ra i labo tander? A gol, o a rumu na etabor? A rumu na etabor! Uni a gol ra i kis una rumu na etabor in nanpat a utna anun o God, uni a rumu na etabor i utalapori. ");
INSERT INTO kqw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mot watungi kai lena, ‘Ra taio i liliman nama kabulu na tuntun etabor, ke maut, ikut ra taio i liliman nama etabor ra di ubeki uni, i ra i lingmulus.’ ");
INSERT INTO kqw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mot a kum pulu! Asau ra i labo tander? A etabor, o a kabulu na tuntun etabor? A kabulu na tuntun etabor! Uni a etabor ra i kis una kabulu na tuntun etabor in nanpat a utna anun o God, uni a kabulu na tuntun etabor i utalapor i. ");
INSERT INTO kqw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ra taio i liliman nama kabulu na tuntun etabor, i liliman utkai nama kum utna rop ra kura uni. ");
INSERT INTO kqw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Osi ra i liliman nama rumu na etabor, i liliman utkai nam o God ra i kis uni. ");
INSERT INTO kqw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ra taio i liliman nama langit, i liliman ut nama kiskis na king anun o God, ma i liliman utkai nam o naro ra i kis uni. ");
INSERT INTO kqw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot nuknuk doko una kum natnat na warkurai, lenri mot pitar in tekteken nanai tagun a noino natnat na duwai ra i sangsangnain wakak, ikut ka mot nuk pas a kum lamlabino utna una kum warkurai. Iri a kum lamlabino utna: a tokodos na warkurai, ma a marmaris torom a taro, ma a lingmulus na petutna. I wakak sur mot in pam a kum utna ra, ma gong kai mot dumano ru in tektekene tagun a noino, sur mot in pitari torom o God. ");
INSERT INTO kqw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mot a kum pulu na mugumugu! Ra mot inum, mot rakon ru in nalang gusun a kap, ikut, a kamel ra kura una kap, mot inumi kut! ");
INSERT INTO kqw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot gosgos pasi kut a surun a kap ma a pelet, ikut a balander i bukus nama petutna na ungongos pas a utna tan taio, ma a ngasino ra ara i nuk pasi ut. ");
INSERT INTO kqw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ui a pulu na Parisi! Un dur mugu pas a balan a kap ma a pelet, sur in talapor kai a surunder. ");
INSERT INTO kqw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot elar nama kum kulam na minat ra di pen tar det. Ra di tama det taginago upiso det wakak, ikut tiro ubalandet i bukus nama kum sursur na minat ma a kum utna rop ra i dur. ");
INSERT INTO kqw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lenkutkai ra, a taro det tama a pinimot lena, mot a kum tene tokodos, ikut a balamot i bukus nama torotoro, ma a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“In laulau doko torom mot a kum tene ususer tagun a Warkurai ma a kum Parisi, mot a kum tene torotoro. Mot utur a kum aim nisan a kum kulam na minat anun a kum poropet, ma mot mar a kum tung na minat anun a kum tene tokodos. ");
INSERT INTO kqw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma mot watungi lena, ‘Gunuk ra met sa laun tomo numugu nama kum tumtubumet, ka met in warut det ra det um doko a kum poropet.’ ");
INSERT INTO kqw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ikut uniri mot upuaso mot ut lena, mot a kum tumtubundet ra det um doko a kum poropet. ");
INSERT INTO kqw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mot mo, mot in urop a kum sakino petutna ra a kum tumtubumot det sa ukatutur tari numugu. ");
INSERT INTO kqw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mot a kum sui! Mot a kum nutnutun a kum laulau na sui! Mot in kalabor eno pepetlai gusun a warkurai na minabalu una labino sungun? ");
INSERT INTO kqw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Uniri an tulu ru a kum poropet, a kum tene mananos, ma a kum tene ususer torom mot. Lako taro tagun det, mot in um doko det, ma lako taro, mot in sak wat det una kum nanai kutus, ma lako taro kai, mot in um det una numot a kum rumu na lotu, ma mot in lu ru det gusun anumot a kum tamon, ma det in kalabor sur a kum tamon gisen. ");
INSERT INTO kqw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Din pitar a warkurai na minabalu torom mot, una gapin a kum tene tokodos rop, ra di sa um doko tar det. Turpasi ra di um doko o Abel, a tene tokodos, ma i wan tuk ra di um doko o Sekaraia, a nutun o Berekia, i ra mot um doko i epotor nisan a kabulu na tuntun etabor ma a nubual ra i Tabu, tiro urumu una rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A inanos mot nama lingmulus, din pitar a warkurai na minabalu torom a taro tagun uniri una kum utna rop ri. ");
INSERT INTO kqw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, ui ra u um doko a kum poropet, ma det ra di tulu ru det torom ui, u duku doko ru det kut nama watat. A susut na dino a nem na rakup bat tomo a kum nutnutum elar nama kereke ra i rakup bat tomo a kum nutnutunu utuntudu ina ru mebene, ikut ka mot nemi. ");
INSERT INTO kqw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tama i! O God i sa wan gusun anumot a tamon. ");
INSERT INTO kqw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Uni a inanos mot lena, ka mot in tama melet iau mo tuk una bung ra mot in watungi lena, ‘Dat in watung ulabo pas o naro ra i wanpat nama risan a Labino.’” ");
INSERT INTO kqw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","O Iesu i pirso gusun a rumu na etabor. Ra i wan nanan, anun a kum nat na ususer det wan toromi, ma det inanosi sur in tama a kum rumu nisan a rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ra i watungi tandet, “Mot tama i ut a kum rumu ri, niko? A inanos mot nama lingmulus, numur din rege ginogino det rop, ma a kum watat det in inep sarsarara.” ");
INSERT INTO kqw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ra o Iesu i kis sapat netes una Tangai na Oliw, a kum nat na ususer det wanpat eno toromi, ma det watungi tano lena, “Un inanos met, nangisin a kum utna ri in nanpat? Ma asau a ukinalong ra in ese anum a milmilet ma a tintinip ina rakrakon bual?” ");
INSERT INTO kqw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","O Iesu i balu det lena, “Mot in tumarong, sako taio in toro pas mot. ");
INSERT INTO kqw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Uni a susut det in nanpat nama risang, ma det in warango det lena, ‘Iau a Karisito,’ ra det in toro lako susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mot in longoro a kum inaim ma a kum inarang na inaim, ikut gong mot lai taru. A kum utna lenri det in nanpat, ikut a tintinip ina rakrakon bual kura utmakai. ");
INSERT INTO kqw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ara kabotaro in tur na inaim torom ara kabotaro, ma ara gapman in tur na inaim torom ara gapman. A kum lamlabino munurak, ma a kum guri in nanpat una kum tamon. ");
INSERT INTO kqw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A kum utna rop ri, i elar nama kum mugano ngunungut, ra i ser wanpat una ino ra i ling na usus. ");
INSERT INTO kqw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kura numur, din pitar mot sur din banlaulau mot, ma din um doko mot, ma a kum kabotaro rop det in nget mot, i kibino una risang. ");
INSERT INTO kqw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Una kum bungbung ra, a susut det in nan gisen gusun a nurnur. Det in pitar etetalai det torom a kum ebar, ma det in nget etetalai det. ");
INSERT INTO kqw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A susut na torotoro na poropet kai det in nanpat, ma det in toro pas a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A marmaris anun lako susut in rop, uni a kum sakino petutna in labo doko mo. ");
INSERT INTO kqw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ikut osi ra in tur dekdek tuk una tintinipino, o God in ulauni. ");
INSERT INTO kqw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Din warawai nama Wakak na Wasiso una matanitu anun o God torom a taro tagun a rakrakon bual rop, sur a wasiso talapor in nan torom a kum kamkabo taro rop, numur a tintinip na bung in nanpat maragom. ");
INSERT INTO kqw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mot in tama ara sakino utna sakit in nanpat, in tur una rumu anun o God ra in ban udur a rumu ra. A utna ra, o Daniel a poropet i sa wasiso mugu taru uni numugu utmakai. Osi ra in luk a kum wasiso ri, i wakak sur in mananos uni. ");
INSERT INTO kqw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Una bung ra, det ra det kis una papor Judia, det in kalabor eno usapat una kum tangai. ");
INSERT INTO kqw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ra taio in kis sapat netes una nun a rumu, ra in pirso, gong i ruk sur in los pas tu utna tagisa urumu. ");
INSERT INTO kqw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ra taio in kis sa ukinobot, gong melet mo i milet utiro utamon sur anuna saket. ");
INSERT INTO kqw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Una kum bungbung ra, in laulau doko torom a kum tianan, ma torom a kum ino kai ra a kum nutnutundet, det sus utmakai. ");
INSERT INTO kqw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mot in wararing sur gong mot kalabor song una kum kalang na kotokoto, o una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Uni una kum bungbung ra, in labo sakit a ngunungut. In labo taun a kum ngunungut ra i ser wanpat una rakrakon bual. Turpasi una turturkibin ina rakrakon bual tuk uniri, ma numur kai, katu ngunungut in elar nami. ");
INSERT INTO kqw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ra gunuk o God ken kutus pirso a kum bungbung ra, ka taio ut in laun. Ikut in kutus pirso ru i sur det ra i sa pilok pas det, det in laun. ");
INSERT INTO kqw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Una kum bungbung ra, ra taio in watungi torom mot lena, ‘Tama i, a Karisito kuri i,’ o ‘Kurong i,’ gong mot nurnur. ");
INSERT INTO kqw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Uni lako kum torotoro na Karisito, ma lako kum torotoro na poropet det in nanpat. Det in pam lako kum labino ukinalong ma lako kum utna na ukisin sur det in toro pas a taro ra o God i sa pilok pas det, ra ut ko det in pet lar pasi. Ikut ka det in pet lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tama i, a sa inanos mugu tar mot uni. ");
INSERT INTO kqw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ra det in watungi tamot lena, ‘Kura i kis una nubual kalako taro uni,’ gong mot wan suri, ma ra det in watungi kai lena, ‘Kuri una rumu,’ gong mot nurnur. ");
INSERT INTO kqw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Uni una bung na inawan pat anun a Nutun a Musano, a taro rop det in tama i. In elar nam in nememe, ra i meme i tagitong una matmatano tobar, tuk una matmatano lubur. ");
INSERT INTO kqw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A nubual ra a minat i inep uni, a kum kotkot det in nan tomo iai. ");
INSERT INTO kqw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Uniutra, ra i sa rop a kum mamaut ma ngunungut una kum bungbung ra, ‘in matanas in dumirum, a kalang ken talapor, a kum nangnang det in puku pirso tagisapat una bakut, ma a kum utna sapat netes una bakut det in tugunugunu.’ ");
INSERT INTO kqw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Una bung ra, a ukinalong ina Nutun a Musano in nanpat una bakut. Ma a kum kamkabo taro rop una rakrakon bual det in domos. Ma det in tama a Nutun a Musano in nanpat sapat netes una kum du bakut, nama dekdek ma a labino minamar. ");
INSERT INTO kqw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","In tuwuru in tangis ra a Nutun a Musano in tulu pirso anun a kum ensel, sur det in ben tomo anun a taro na pipilok tagun a wat na matmatano wuwu, tagun ara papor rakrakon bual tuk tong una ara papor rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mot in ususer tagun in nanai na fig. Ra a kum kanokano in sibul pat melet, ma a dondono in tapalos, mot tasmani lena a kum kalang na mararong i sa milau. ");
INSERT INTO kqw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lenkutkai, ra mot tama a kum utna rop ra a wasiso taru uni in nanpat, mot in tasmani lena, a du bung i sa milau. ");
INSERT INTO kqw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A inanos mot nama lingmulus, a kum utna rop ri in nanpat ra a taro tagun uniri det laun utmakai. ");
INSERT INTO kqw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A langit ma a rakrakon bual der in rop, ikut anung a kum wasiso ken rop. ");
INSERT INTO kqw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Katutaio i tasman a bung o a du bung ra a kum utna ri in nanpat. A kum ensel sapat una langit ka det tasmani, ma a Nutunu kai ke tasmani, o Tamano sot kut i tasmani. ");
INSERT INTO kqw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A inawan pat melet anun a Nutun a Musano, in elar nama kum bungbung anun o Noa. ");
INSERT INTO kqw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Una kum bungbung ra in nolomom ke wanpat utmakai, det wangon, det inum, ma det unolin det, tuk una bung ra o Noa i kas una sip. ");
INSERT INTO kqw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma ka det tasman asau ra in nanpat, tuk in nolomom i wanpat, ra i los rop ru det. In lenkutkai ra una inawan pat melet anun a Nutun a Musano. ");
INSERT INTO kqw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Una bung ra, ra lako ru musano der in papam sa ukinobot, din los pas tu pasander kut, ma ara pasander awu. ");
INSERT INTO kqw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ra lako ru ino kai der in gino a wit, din los pasi kut tu pasander, ma ara pasander awu. ");
INSERT INTO kqw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mot in tumarong mot, uni ka mot tasman a bung ra anumot a Labino in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mot in tama i: Ra a taman a rumu in tasman a du bung una mirum ra a tene wolong in nanpat uni, in kis ma in tamtamabat anun a rumu. Ken madek ru anun a rumu sur din wolongi. ");
INSERT INTO kqw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mot kai, mot in koikoi taru, uni a Nutun a Musano in nanpat una du bung ra ka mot nuki lena in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A tultul ra i lingmulus una nun a pinapam ma i mananos kai, anun a labino in ukis tari sur in tene warkurai una nun a rumu, ma in tamtabor a kum tultul kai, nama andet a utna na inangon una kum du bung na inangon. ");
INSERT INTO kqw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A tultul ra, in dan ra anun a labino in nanpat ma in tama i ra i pam sot pas anun a pinapam. ");
INSERT INTO kqw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A inanos mot nama lingmulus, anun a labino in ubek tari sur in tene warkurai una nun a kum utna rop. ");
INSERT INTO kqw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ikut ra a tultul ra, i a sakino tultul, ma i nuki lena, anun a labino ken nanpat lakit, ");
INSERT INTO kqw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","in turpasi sur in um a kum tultul ra det papam tomo nami. Ma in nangon ma in inum tomo nama kum tene ininum. ");
INSERT INTO kqw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Anun a labino in nanpat un tu bung o tu du bung ra a tultul ke tasmani, ma ke nuki lena in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ra a labino in tau kutkutusi, ma in pitar tar a warkurai na minabalu toromi, sur in kis tomo nama kum tene torotoro, una nubual ra di tangtangis ma di ungingit lokondi iai. ");
INSERT INTO kqw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Una du bung ra, a matanitu tagisapat una langit in elar nama noino toraro, ra det los pas anundet a kum lam, ma det wan sur det in barato a matok na nolin. ");
INSERT INTO kqw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A limo tagun det, det mananos, ma a limo kai tandet, ka det mananos. ");
INSERT INTO kqw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Det ra ka det mananos det los anundet a kum lam, ikut ka det los lako kum koto na wel kai tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ikut, det ra det mananos det los anundet a kum lam ma det los i utkai a kum koto na wel tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A matok na nolin ke wanpat lakit, ra a matan det i sunu, ma det inep dumun rop. ");
INSERT INTO kqw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ra una labino mirum di kakabo lena, ‘Wo, a matok na nolin mo! Mot iap, mot in barato i.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A kum toraro rop det tuangun, ma det waninar anundet a kum lam. ");
INSERT INTO kqw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Det ra ka det mananos, det saring a kum mananos ino lena, ‘Mot in tabor met nam lakalik wel, uni anumet a kum lam det sa ling na mat.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Det balu det lena, ‘Awu, sako ken elar nam dat rop. Mot in nan torom det ra det siuru wel ma mot in kukul pas.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ikut ra det wan sur det in kukul, a matok na nolin i wanpat. A limo ra det sa waninar, det wan tomo nam i sur a lukaro na unolin, ra di tagar bat a matansako. ");
INSERT INTO kqw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Numur a limo ra ka det mananos det wanpat, ma det kakabo lena, ‘Labino, labino, un papos pas met.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","I balu det lena, ‘A inanos mot nama lingmulus, ka tasman mot.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ra i lenra, mot in tumarong mot, uni ka mot tasman a bung o a du bung ra a Labino in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A matanitu tagisapat una langit i elar utkai nam ara musano ra i waninar sur in nan utiro una ra tamon gisen. I kabo pas anun a tulu tultul, ra i isuaro tar anun a kum ululeng tandetul sur detul in papam nami. ");
INSERT INTO kqw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I pitar tar a limo na arip na kina tan ara, ma aru arip na kina tan ara, ma ara arip na kina kai tan ara. I pitar tari torom detul taktakai elar ut nam anundetul a mananos. Ra numur i wan una nun a inawan. ");
INSERT INTO kqw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O naro ra di pitar tar a limo na arip na kina tano, i wan lakit ma i papam nami, ma i ulabo melet pas a limo na arip na kina taguni. ");
INSERT INTO kqw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lenkutkai ra torom o naro i ra di pitar tar aru arip na kina tano, i ulabo melet pas aru arip na kina taguni. ");
INSERT INTO kqw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ikut, o naro i ra di pitar tar ara arip na kina tano, i wan, i kil pas in nutung, ma i por eno tar a mani anun anun a labino. ");
INSERT INTO kqw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ra i sa suano i, a labino anun a tulu tultul, i wanpat ma i kabo pas detul sur detul in inanos kapo i una nun a mani. ");
INSERT INTO kqw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","O naro ra di pitar tar a limo na arip na kina tano i wan toromi nama limo na arip melet, ra i watungi tano lena, ‘Labino, u pitar tar a limo na arip na kina tang. Tama i, a sa pam pat pas a limo na arip melet taguni.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Anun a labino i balu i lena, ‘Wakak sakit, ui a wakak na tultul, u lingmulus una num a pinapam. An ubek tar ui sur un warkurai un lako susut na utna, uni u lingmulus una nat na utna ri. Ra uniri dar in nan ma dar in gas tomo.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“O naro ra di pitar tar aru arip na kina tano i wan toromi, ma i watungi lena, ‘Labino u pitar tar aru arip na kina tang. Tama i, a sa pam pat pas aru arip melet taguni.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Anun a labino i balu i lena, ‘Wakak sakit, ui a wakak na tultul, u lingmulus una num a pinapam. An ubek tar ui sur un warkurai un lako susut na utna, uni u lingmulus una nat na utna ri. Ra uniri dar in nan ma dar in gas tomo.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Numur, i ra di pitar tar ara arip na kina tano i wan toromi, ra i watungi lena, ‘Labino, a tasmani lena ui a tene ngalngalia. U pasong pas a utna ra ko marut tari, ma u git pasi kai, a win a utna ra ko marut tari. ");
INSERT INTO kqw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","A ngaran ui, ra a wan, a por eno tar anum a mani. Iri melet mi anum a mani.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Anun a labino i balu i lena, ‘Ui a sakino tultul, a tabalamat na musano ui. U sa tasmani lena, a pasong a utna ra ka marut tari, ma a git pasi kai a wino utna ra ka marut tari. ");
INSERT INTO kqw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ilai ra ko ubek tar anung a mani una beng sur an los pas anung a mani ma tu sibano kai una bung ra an nanpat uni? ");
INSERT INTO kqw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mot in los ru a mani gusuni, ma mot in pitar tari toromi ra anun a noino arip na kina. ");
INSERT INTO kqw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uni, osi ra i utur ukai a labino, din tabor meleti sur anun a utna in labo bing, ma osi ra ke utur ukai tu utna, din rakon ru anun a nat na utnalik gusuni. ");
INSERT INTO kqw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ra a tultul ri ra ke gas un tu utna, mot in woro pirso ru i una dumirum, a nubual ra di tangtangis ma di ungingit lokondi iai.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“A Nutun a Musano in nanpat nama nun a minamar, tomo nama nun a kum ensel, ra in kis una nun a kiskis na king. A kiskis ra a labino minamar ino. ");
INSERT INTO kqw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A kum kamkabo taro rop una rakrakon bual det in nan tomo umatano, ma in isuaro det, elar nama tene tamtamabat anun a kum sipsip i isuaro a kum sipsip gusun a kum meme. ");
INSERT INTO kqw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In tulu a kum sipsip sur a papor sot na lamano, ma a kum meme sur a papor kair. ");
INSERT INTO kqw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A king in watungi tandet ra kura una papor sot na lamano lena, ‘Mot wan urin, mot ra o Tita i sa watung udan tar mot. Mot in rakon pas a matanitu di sa waninar tari sur anumot, tagun numnumugu utmakai una turturkibin ina rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Uni a murak ra mot tabor iau, a muruk ra mot uinum iau, a usiro ra mot ben ruk iau una rumu. ");
INSERT INTO kqw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka tin namalu anung ra mot pitar in namalu tang, a misait ra mot tamtamabat iau, ma a kis una karabus ra mot lumu iau.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“A kum tene tokodos det in tingi lena, ‘Labino, nangisin met tama ui ra u murak ma met tabor ui, o u muruk ra met uinum ui? ");
INSERT INTO kqw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nangisin met tama ui ra u usiro ra met ben ruk ui una rumu, o ka tin namalu anum ra met pitar in namalu tam? ");
INSERT INTO kqw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nangisin met tama ui ra u misait, o u kis una karabus, ra met lumu ui?’ ");
INSERT INTO kqw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“A king in balu det lena, ‘A inanos mot nama lingmulus, asau ra mot sa pam tari torom tu musano oros kut tagun a kum tistising ri, mot sa pam tari ut un iau.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“In watungi bulung torom det una papor kair na lamano lena, ‘Mot wan gisen gusun iau. A dekdek ina warkurai na minabalu i sa kis un mot. Mot nan una labino sungun ra ken mat, ra di sa waninar tari sur o Satan ma anun a kum ensel. ");
INSERT INTO kqw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Uni a murak ra ka mot tabor iau, a muruk ra ka mot uinum iau. ");
INSERT INTO kqw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A usiro ra ka mot ben ruk iau una rumu, ka tin namalu anung ra ka mot pitar tin namalu tang, a misait ma a kis una karabus ra ka mot lumu iau.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Det bulung det in tingi lena, ‘Labino, nangisin met tama ui ra u murak, o u muruk, o u usiro, o ka tin namalu anum, o u misait, o u kis una karabus, ra ka met warut ui?’ ");
INSERT INTO kqw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“In balu det lena, ‘A inanos mot nama lingmulus, asau ra ka mot pam tari torom tu musano oros kut, ka mot pami kai un iau.’ ");
INSERT INTO kqw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ra det in nan sur a warkurai na ngunungut tukum. Ikut a kum tene tokodos det in nan sur a nilaun tukum.” ");
INSERT INTO kqw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ra o Iesu i sa watung rop tar a kum wasiso ri, i inanos anun a kum nat na ususer lena, ");
INSERT INTO kqw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mot tasmani ut, ra aru bung in rop, din turpas a labino bung na lotu na Wanlakai, ra din pitar tar a Nutun a Musano sur din sak wati un in nanai kutus.” ");
INSERT INTO kqw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Una du bung ut ra a kum lamlabino tene etabor torom o God ma a kum mugumugu anun a taro, det kis tomo una labino rumu anun o Kaiapas, a mugumugu na tene etabor. ");
INSERT INTO kqw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Det wasiso tomo pas sur det in pam ukai eno pas o Iesu, ma det in um doko i. ");
INSERT INTO kqw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Det watungi lena, “Gong dat pami una labino bung na lotu, sako a taro det in kankan ma det in ukatutur tu inaim. ");
INSERT INTO kqw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","O Iesu i kis tong o Betani, una rumu anun o Saimon, i ra numugu i misait nama lepra. ");
INSERT INTO kqw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ara ino i wan torom o Iesu nam in polo sangsangnain, a matano i ka doko, ra i kis un in nokoto ra di pami nama wat. I lingisi un in lorin o Iesu, ra kura utmakai o Iesu i wangon. ");
INSERT INTO kqw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A kum nat na ususer det tama i, ra det kankan doko uni, ma det watungi lena, “Sur asau ra di lingis orosi kut in polo sangsangnain ri? ");
INSERT INTO kqw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ilai ra ka di siuru pasi sur lako labino mani sur din tabor a kum sibo na taro nami?” ");
INSERT INTO kqw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","O Iesu i sa tasman asau ra det wasiso uni, ra i watungi tandet lena, “Ilai ra mot pitar a maut torom a ino ri? I sa pam tar a wakak na pinapam sakit un iau. ");
INSERT INTO kqw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A kum sibo na taro det in laun bolbolos tomo ut nam mot. Ikut iau, kan kis tukum nisamot. ");
INSERT INTO kqw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I sa lingis tar in polo sangsangnain ri una pining sur in waninar iau sur a bung an mat ma din uruk a minating una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A inanos mot nama lingmulus, una kum tamtamon una rakrakon bual, ra din warawai nama Wakak na Wasiso iai, din inanos utkai un asau ra a ino ri i sa pam tari, sur a risano in tur na aim.” ");
INSERT INTO kqw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","O Judas Iskariot, ara tagun a noino ma aru nat na ususer, i wan torom a kum lamlabino tene etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma i ting det lena, “Ra an pitar tar o Iesu torom mot, asau mot in tokom iau nami?” Ma det pitar tar a tulu noino silwa tano. ");
INSERT INTO kqw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Turpasi una bung ra i nuknuk sur tu wakak na du bung ra in pitar tar o Iesu torom det. ");
INSERT INTO kqw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Una mugano bung una kum lamlabino bung na lotu na beret ra kalako is uni, a kum nat na ususer det wan torom o Iesu, ma det tingi lena, “U nemi sur met in waninar andat a utna sur a labino bung na lotu na Wanlakai awai?” ");
INSERT INTO kqw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ra i balu det lena, “Mot in ruk usapat o Jerusalem, mot in barato ara musano, ra mot in watungi tano lena, ‘A Tene Ususer i watungi lena: Anung a bung i sa milau. Met nam anung a kum nat na ususer met in ukinalong a labino bung na lotu na Wanlakai munung una num a rumu.’” ");
INSERT INTO kqw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A kum nat na ususer det pami ut asau ra o Iesu i sa watung tari tandet, ma det waninar a utna na Wanlakai. ");
INSERT INTO kqw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ra i sa lirop, o Iesu tomo nama nuna noino ma aru nat na ususer det kis una inangon. ");
INSERT INTO kqw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Det wangon ra i watungi lena, “A inanos mot nama lingmulus, ara tagun mot in pitar tar iau ulaman a kum ebar.” ");
INSERT INTO kqw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Det tupunuk doko ra det rop taktakai det tur pas a iting toromi lena, “Labino, ausur iau niko?” ");
INSERT INTO kqw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O Iesu i balu det lena, “I ra mir puk tomo amir aru du beret una dis, i ut ra in pitar tar iau ulaman a kum ebar. ");
INSERT INTO kqw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A Nutun a Musano in iru elar nami ra di sa tumus tari una Buk Tabu. Ikut in laulau sakit torom a musano ra in pitar tari torom a kum ebar. In wakak toromi ra ka din ususi, sur gong i taramo a dekdek na warkurai ra uni.” ");
INSERT INTO kqw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","O Judas, i ra in pitar tari torom a kum ebar, i tingi lena, “Tene Ususer, ausur iau niko?” I balu i lena, “Ui ut ra.” ");
INSERT INTO kqw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Det wangon utmakai, ra o Iesu i los pas a beret, i watung wakak pas uni, i tibiki, ma i tabor anun a kum nat na ususer nami, ra i watungi lena, “Mot in rakoni ma mot in nani. Iri a pining.” ");
INSERT INTO kqw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Numur i los pas a kap, i watung wakak pas uni ra i pitari tandet. I watungi lena, “Mot rop mot in inum taguni. ");
INSERT INTO kqw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iri a gaping, a kunubus ra i dat tomo tar o God nama taro. A gaping ri, i tilingis sur in dumano ru a kum sakino petutna anun a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A watungi tamot lena, kan inum melet mo lako wain, tuk ra dat in inum a matok na wain una matanitu anun o Tita.” ");
INSERT INTO kqw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ra det sa kele tar a kelekele na lotu, det wan tito usapat una Tangai na Oliw. ");
INSERT INTO kqw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","O Iesu i watungi tandet lena, “Miri umirum, mot rop mot in nan pas kut gusun iau, i kibino una kum utna ra in nanpat un iau. Uni di sa tumus tari una Buk Tabu lena, O God i watungi lena, ‘An um a tene tamtamabat anun a kum sipsip, ra a kum sipsip det in kalabor sarara.’ ");
INSERT INTO kqw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ikut ra a sa katutur melet gusun a minat, an mugu utong o Galili.” ");
INSERT INTO kqw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","O Pita i watungi tano lena, “Ra det rop det in nan pas gusun ui, ikut iau awu.” ");
INSERT INTO kqw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","O Iesu i watungi tano lena, “A inanos ui nama lingmulus, miri umirum, ra a kereke ken kurkurakuk utmakai, un ipul a tulu dino lena ko tasman iau.” ");
INSERT INTO kqw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","O Pita i watungi tano lena, “Kan ipul ru ui. Iau kai an iru tomo nam ui, i wakak kut.” Ma a kum nat na ususer rop kai det watungi lenutra. ");
INSERT INTO kqw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","O Iesu tomo nam anun a kum nat na ususer det wanpat una nubual a risano Getsemani, ra i watungi tandet lena, “Mot in kis kut nin, ma iau an nan lilik utong, sur an wararing pas.” ");
INSERT INTO kqw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ra i ben pas o Pita tomo nama ru nutnutun o Sebedi. Una du bung ut ra, i tupunuk ma i maut doko a nuknukino. ");
INSERT INTO kqw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I watungi tandetul lena, “Anung a nilaun i mamaut doko nama tupunuk, milau mo an mat nami. Motul in kis kut nin, ma motul in koikoi taru ut tomo nam iau.” ");
INSERT INTO kqw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I wan lilik taru usa numugu, i puku tuntudung taru una piso, ma i wararing lena, “Tita, ra gunuk in sot, un los ru a kap na mamaut ri gusun iau. Ikut gong u mur anung a nemnem, un muri ut anum a nemnem.” ");
INSERT INTO kqw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","I milet melet torom a tulu nat na ususer, ra i tama detul, detul sa inep dumun. I ting o Pita lena, “Pepetlai, ka motul in pet lari sur motul in koikoi tomo nam iau un tu du bunglik kut? ");
INSERT INTO kqw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Motul in koikoi, ma motul in wararing, sur gong motul puku una ululam. A niomotul i nem na tarom, ikut a pinimotul i tungulu kut.” ");
INSERT INTO kqw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A manru dino melet i wan gusun detul, ma i wararing lena, “Tita, ra ken sot sur un los ru a kap na mamaut ri gusun iau, an inumi ut. An muri ut anum a nemnem.” ");
INSERT INTO kqw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I milet melet, ra i tama detul, detul sa inep dumun melet, uni a matandetul i sa sunu doko. ");
INSERT INTO kqw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ra i wan melet gusun detul, i mantul u wararing, ra i watung melet a niaring ra i sa watung tari munung. ");
INSERT INTO kqw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ra i milet melet torom a tulu nat na ususer, i watungi tandetul lena, “Motul in inep liklik mukut ma motul in mana? Tama i, a du bung i sa milau, ra din pitar tar a Nutun a Musano ulaman a kum tene sakino. ");
INSERT INTO kqw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Motul katutur, dat na wan! Tama i, a musano ra in pitar tar iau ulaman a kum ebar, i sa wanpat.” ");
INSERT INTO kqw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ra o Iesu i wasiso utmakai, o Judas, ara tagun a noino ma aru nat na ususer, i wanpat, det nama kunur na taro. Det los a kum totok na inaim ma a kum nalnal. A kum lamlabino tene etabor torom o God ma a kum mugumugu anun a taro, det tulu ru det. ");
INSERT INTO kqw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","I ra in pitar tar o Iesu ulaman a kum ebar i sa inanos mugu tar a kunur na taro una ukinalong ra in pami lenri, “I ra an gom a pangpagor na wano, i ut ra. Mot in pam ukai pasi.” ");
INSERT INTO kqw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Uniutra o Judas i wan torom o Iesu ra i watungi lena, “Wakak na mirum, Tene Ususer!” Ra i gom a pangpagor na wano. ");
INSERT INTO kqw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","O Iesu i watungi tano lena, “Pasang, un pami kut a utna ra u wan urin suri.” Ma a taro ra, det wan torom o Iesu, det pam ukai pasi ma det dati. ");
INSERT INTO kqw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ara tagun det ra det wan tomo nam o Iesu, i dat pas anun in totok na inaim, ra i tau kutus ru in talngan a tultul anun a mugumugu na tene etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","O Iesu i watungi tano lena, “Uruk melet anum in totok una bano, uni det rop ra det etawu nama kum totok na inaim, det in iru nama kum totok na inaim. ");
INSERT INTO kqw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Pepetlai, u nuki lena, in ngangitin sur an saring o Tita sur lako susut na arip na ensel, ra uniutri in tulu ru det torom iau? ");
INSERT INTO kqw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ikut, ra an pami lenra, ka din pam sot pas a kum wasiso na Buk Tabu una kum utna ri ra i sot sur din pami un iau.” ");
INSERT INTO kqw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Una du bung ra, o Iesu i watungi tan a kunur na taro lena, “Pepetlai, kutiro iau a tene inaim ma a tene wolong, sur i mo ri mot wanpat nama kum totok na inaim ma a kum nalnal sur mot in pam ukai iau? Una kum bungbung rop a ser kis una rumu na etabor, a ser ususer a taro, ma ka mot pam ukai iau. ");
INSERT INTO kqw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ikut a kum utna rop ri i wanpat sur din pam sot pas a kum tumtumus anun a kum poropet.” Numur anun a kum nat na ususer rop det kalabor sarara pas gusuni. ");
INSERT INTO kqw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Det ra det sa pam ukai pas o Iesu, det beni sur a rumu anun o Kaiapas a mugumugu na tene etabor torom o God. A kum tene ususer tagun a Warkurai ma a kum mugumugu kura det sa wan tomo. ");
INSERT INTO kqw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","O Pita i mur nanan o Iesu, ikut i bakbak ut gusuni, tuk una nubual anun a mugumugu na tene etabor torom o God. I ruk una nubual ra, ma i kis tomo nama kum tene tamtamabat sur in tama asau ra din pami un o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A kum lamlabino tene etabor torom o God, tomo nama taro na kiwung rop, det sisio sur tu torotoro na wasiso un tu sakino utna ra o Iesu i sa pam tari, sur det in takuni nami, ma det in um doko i uni. ");
INSERT INTO kqw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A susut na tene torotoro det wanpat, ikut ka det sio lar pas tu utna ra det in takuni nami. Aru ra der wanpat murmur, ");
INSERT INTO kqw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","der watungi lena, “A musano ri i watungi lena, ‘An rege ru a rumu na etabor ri anun o God, ma an pam melet pasi una tulu bung kut.’” ");
INSERT INTO kqw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A mugumugu na tene etabor torom o God i tur, ra i ting o Iesu lena, “Pepetlai, kon balu det? Asau ra un balu a kum wasiso na etakun ri nami?” ");
INSERT INTO kqw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ikut o Iesu ke wasiso. A tene etabor ra, i watungi tano lena, “Una risan o God, a lalaun ino, un inanos met ra ui a Karisito a Nutun o God, o awu.” ");
INSERT INTO kqw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O Iesu i watungi tano lena, “I ut ra u sa watungi. Ma a watungi tamot lena, turpasi uniri, mot in tama a Nutun a Musano in kis una papor sot na laman o God, i ra i dekdek sakit, ma numur mot in tama i ra in nanpat una kum du bakut tagisapat una langit.” ");
INSERT INTO kqw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A mugumugu na tene etabor i kankan ra i raros anun in namalu ut, ra i watungi lena, “Uniri i sa wasiso laulau un o God. Dat nem melet lako wasiso na etakun sur asau? Mot sa longoro tar anun a kum wasiso laulau un o God. ");
INSERT INTO kqw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Asau mot nuki?” Ra det balu i lena, “I wakak sur in iru.” ");
INSERT INTO kqw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma det ibis in masarino, ma det tubuli, ra ara taro det pasori, ");
INSERT INTO kqw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ra det watungi lena, “Karisito, ui a poropet, un inanos met, osi ra i tubul ui.” ");
INSERT INTO kqw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ra o Pita i kis utmakai nago upiso una rumu ra, ara toraro, a tultul i wan toromi ra i watungi lena, “Ui kai ara tagun det ra mot ser wan tomo nam o Iesu a te Galili.” ");
INSERT INTO kqw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ikut i ipul umatan det rop, i watungi lena, “Ka tasman asau ra u wasiso uni.” ");
INSERT INTO kqw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ra i wan utong nisan a matansako ina in noworo, ara toraro bulung i tama pasi, ra i watungi tan a taro tiro iai lena, “A musano ri, der ut nam o Iesu a te Nasaret.” ");
INSERT INTO kqw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma i ipul melet, i liliman lena, “A lingmulus ut, ka tasman a musano ra.” ");
INSERT INTO kqw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Numur lilik, det ra det tur tiro iai det wan torom o Pita, det watungi tano lena, “A lingmulus ut ra ui kai ara tagun det. Met longoro lele ui kut una num a liu na wasiso.” ");
INSERT INTO kqw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma i liliman torom det, i watungi lena, “O God in warkurai laulau iau ra an toro. Ka tasman a musano ra.” Ra uniutra a kereke i kurkurakuk mut. ");
INSERT INTO kqw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma o Pita i nuk pas a wasiso ra o Iesu i sa watung tari tano lena, “Ra a kereke ken kurkurakuk utmakai, un ipul a tulu dino lena, ko tasman iau.” Ra i pirso gusun a nubual ra, ma i tangis doko i. ");
INSERT INTO kqw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Una kobot raut, a kum lamlabino tene etabor rop torom o God ma a kum mugumugu anun a taro, det wasiso tomo un o Iesu sur din um doko i. ");
INSERT INTO kqw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Det ker pas aru lamano, det beni ra det pitar tari torom o Pailat, a labino mugumugu anun a gapman. ");
INSERT INTO kqw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","O Judas, i ra i pitar tar o Iesu ulaman a kum ebar, i tasmani lena di sa warkurai tar o Iesu sur in mat, ra a labino tupunuk i losi. I milet nama tulu noino silwa torom a kum lamlabino tene etabor torom o God ma a kum mugumugu. ");
INSERT INTO kqw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma i watungi lena, “A sa pam tar a sakino petutna, uni a sa usobor tari ra ke pam tu sakino.” Ra det balu i lena, “Met, met lai? Ui ut!” ");
INSERT INTO kqw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","I woro ru a tulu noino silwa una rumu na etabor, ra i wan ma i popos. ");
INSERT INTO kqw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A kum lamlabino tene etabor torom o God det los pas a kum silwa, ra det watungi lena, “Ke tokodos una kum Warkurai sur dat in ubek a mani ri una ululeng na mani, uni a mani ri a ikul tagun a musano ra di um doko i.” ");
INSERT INTO kqw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ra det wasiso tomo pas uni, ma det kul pas a du piso gusun a tene pampam kuro nama piopap, sur din porpor a kum minat ina kum usiro tiro iai. ");
INSERT INTO kqw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I mo ra di watung a nubual ra nam “A piso na gap,” ma a taro det watungi ut lenra tuk uniri. ");
INSERT INTO kqw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lenra di pam sot pas a wasiso ra o Jeremaia a poropet i sa watung tari numugu lena, “Det los pas a tulu noino silwa, a matano ra a taro Israel det ubek tari una musano ra. ");
INSERT INTO kqw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma a tulu noino silwa ra di kul pas a du piso anun a tene pam kuro nama piopap, elar nama Labino i watung tari tang.” ");
INSERT INTO kqw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","O Iesu i tur umatan o Pailat, a mugumugu tagun a gapman, ma a mugumugu i tingi lena, “Ui a king anun a taro Juda?” Ra o Iesu i balu i lena, “I ut ra u sa watungi.” ");
INSERT INTO kqw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A kum lamlabino tene etabor torom o God ma a kum mugumugu det takuni, ikut ke balu det. ");
INSERT INTO kqw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ra o Pailat i tingi lena, “Ko longoro a susut na utna ri det takun ui nami?” ");
INSERT INTO kqw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ke balu det un tu etakun ra det takuni nami, awu ut. Ra a mugumugu tagun a gapman i kisin doko uni. ");
INSERT INTO kqw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Una kum kilkilalo rop una kum lamlabino bung na lotu na Wanlakai, a mugumugu tagun a gapman i ser palos ru ara karabus ra a taro det sasaring suri. ");
INSERT INTO kqw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Una kilalo ra, ara musano a risano o Barabas i kis una karabus una nun a kum lamlabino sakino petutna, ma a taro rop det tasmani. ");
INSERT INTO kqw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A kunur na taro det wanpat tomo torom o Pailat, ra i ting det lena, “Osi ra mot nemi sur an palos ru i torom mot? O Barabas o o Iesu, i ra di watungi nama Karisito?” ");
INSERT INTO kqw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I watungi lenri, uni i sa tasmani lena, det pitar tar o Iesu toromi una sakino nuknukindet. ");
INSERT INTO kqw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ra o Pailat kura utmakai i pam a warkurai, anun a ino i pitar ru a wasiso toromi lena, “Gong u pam tu utna una tene tokodos ra, katu niraro anunu. Uni nanganong mirum, a ririon, ma a kum utna a tama i una musano ra, i banlaulau anung a nilaun.” ");
INSERT INTO kqw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ikut a kum lamlabino tene etabor torom o God ma a kum mugumugu det ukatutur a balan a kunur na taro sur det in sasaring sur o Barabas, ma sur din um doko o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A mugumugu tagun a gapman i ting det lena, “Osi na pasander ra mot nemi sur an palos ru i torom mot?” Det balu i lena, “O Barabas.” ");
INSERT INTO kqw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","O Pailat i ting det lena, “Asau ra an pami un o Iesu, i ra di watungi nama Karisito?” Det rop det balu i lena, “Sak wati un in nanai kutus!” ");
INSERT INTO kqw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma i ting det lena, “Sur asau? Asi na sakino utna ra i sa pam tari?” Ikut det kukukuk dekdek lena, “Sak wati un in nanai kutus!” ");
INSERT INTO kqw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","O Pailat i tama i lena, ke pet lar pas tu utna mo, ma a labino purpuruon milau in nanpat. Ra i los pas a danim, i gos pas aru lamano umatan a kunur na taro, ra i watungi lena, “A langolango gusun a gapin a tene tokodos ri. Mot ut din warkurai mot uni.” ");
INSERT INTO kqw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A taro rop det balu i lena, “I wakak kut, a warkurai na minabalu una gapino in kis un met ma una kum nutnutumet kai.” ");
INSERT INTO kqw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","O Pailat i palos ru o Barabas torom det. Ra di sa takalo tatar o Iesu, i pitar tari tan a kum tene inaim sur det in sak wati un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A kum tene inaim anun a mugumugu tagun a gapman det dat pas o Iesu utiro urumu una labino rumu anun anundet a mugumugu. Ra det ben tomo pas a kum tene inaim rop toromi. ");
INSERT INTO kqw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Det palos ru anun a kum malu, ma det mar tari nam in merek na malu. ");
INSERT INTO kqw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ra det liko pas in narus a loklokono ma det ubek tari un in lorino elar nama kukup anun a king. Det upampam tari nam in nubuku una sot na lamano ma det kis butkeke umatano, ma det urongon laulau uni lena, “Ui a king anun a taro Juda!” ");
INSERT INTO kqw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma det ibisi, det rakon pas in nubuku ra gusuni, ma det raprapus in lorino nami. ");
INSERT INTO kqw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ra det sa urongon laulau papas uni, det palos ru in merek na malu gusuni. Det mar tari melet nama nun a kum malu, ma det ben pirso i sur din sak wati un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Det pirso ra det barato pas ara te Sairini, a risan o Saimon, ma det ungongos tari sur in los in nanai kutus anun o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Det wanpat una nubual di watungi nam o Golgota, a kukuraino a “Nubual na Lor na Minat.” ");
INSERT INTO kqw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Det pitar tar a wain tan o Iesu, ra di sa pam tomo tari nam ara utna ra i mapak. I inum tama i, ikut ke nemi sur in inumi. ");
INSERT INTO kqw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ra det sa sak wat tari un in nanai kutus, det pilai laki sur det in isuaro anun a kum malu torom det taktakai. ");
INSERT INTO kqw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Numur det kis ma det tamtamabat o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sapat netes tan in lorin o Iesu un in nanai kutus, det ubek tar a wasiso na etakun uni, di tumus tari lena, ");
INSERT INTO kqw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma di sak wati kai aru tene wolong tomo nami una arin nanai kutus, ara una papor sot, ma ara una kair. ");
INSERT INTO kqw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Det ra det wanan sakit o Iesu, det watung laulau i ma det lele lorindet toromi. ");
INSERT INTO kqw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ma det watungi lena, “Ui mo ra u watungi lena un rege ru a rumu na etabor ma un pam melet pasi una tulu bung kut, uniri un ulaun pas ui mo. Ra ui a Nutun o God, un pirso gusun in nanai kutus.” ");
INSERT INTO kqw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","A kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai ma a kum mugumugu, det kai det urongon laulau un o Iesu, det watungi lena, ");
INSERT INTO kqw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I ulaun pas a taro gisen, ikut ken ulaun lar pasi ut. Ra i a King anun a taro Israel, uniutri in pirso gusun in nanai kutus ma dat in nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I nurnur ut un o God. Ra o God i nemi, uniutri in ulaun melet pasi, uni i ut i sa watung tari lena, ‘Iau a Nutun o God.’” ");
INSERT INTO kqw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aru tene wolong ra der kete tomo nami, der kai der watung laulau i. ");
INSERT INTO kqw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tur pasi una noino ma ru pakano bung una suan, tuk una tulu pakano bung una lirop, a bual rop i dumirum. ");
INSERT INTO kqw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ra i tulu pakano bung, o Iesu i kukukuk dekdek lena, “Eloi, Eloi, lema sabakatani?” A kukuraina wasiso ra i lenri, “Anung a God, anung a God, ilai ra u wan gusun iau?” ");
INSERT INTO kqw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ara taro tagun det ra det tur milau det longoro i, ra det watungi lena, “O naro ri i kakabo sur o Elaija.” ");
INSERT INTO kqw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A iapiap kut, ara tagun det i kalabor, ra i los pas ara utna ra i ser dop a polo. I puk pasi una wain ra i mititir, i ubek pasi un in nanai ra i tulsu toto i usapat sur o Iesu in inumi. ");
INSERT INTO kqw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ara taro kai tagun det, det watungi lena, “Te, dat in madek tari munung. Dat in tama i ra o Elaija in nan pirso sur in ulaun pasi, o awu.” ");
INSERT INTO kqw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","O Iesu i kukuk dekdek melet pas, ra i ubek ru anun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Una du bung ut ra, in namalu na minabat kutus sa urumu una rumu na etabor i tararos potor, turpasi tagisapat netes tuk unago piso. A guri i wanpat, ma a kum watat det tapagol. ");
INSERT INTO kqw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A kum kulam na minat det papos, ma a susut na taro anun o God ra det sa mat, det katutur melet. ");
INSERT INTO kqw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Det pirso gusun a kum kulam na minat. Ma numur tan a katkatutur melet anun o Iesu, det wanpat sapat o Jerusalem, a tamon anun o God, ma det tur pat torom a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A mugumugu anun a kum tene inaim, ma det kai ra kura tomo nam i sur det in tamtamabat o Iesu, det taramo a guri, ma det tama a kum utna ra i wanpat, ra det ngara doko. Det watungi lena, “I lingmulus ut, a musano ri a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A susut na wardain kai ra det mur o Iesu tagitong o Galili sur det in waruti, det tur bakbak taru ut ma det tama a kum utna ri. ");
INSERT INTO kqw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kura epotor tandet, a tulu ino kai ri, o Maria Magdalen, ma o Maria a nan o Jems ma o Josep, ma a nan aru nutnutun o Sebedi. ");
INSERT INTO kqw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ra i sa lirop, ara tene gongon, a te Arimatia, a risano o Josep, i kai ara nat na ususer anun o Iesu, ");
INSERT INTO kqw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","i wan torom o Pailat ma i saring pas a minatin o Iesu tano. Ra o Pailat i itula sur din pitar tari tano. ");
INSERT INTO kqw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O Josep i los pas a minatino, ma i pulus pasi nam in wakak na matok na malu, ");
INSERT INTO kqw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ra i uinep tari una nun a matok na kulam na minat, ra i sa kil tari una papor wat. I bulus bat tar a matansako na kulam na minat nama labino wat, ra i wan gusuni. ");
INSERT INTO kqw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","O Maria Magdalen ma o Maria kai, a nan o Jems ma o Josep, der kis taru numugu tan a kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Una bung numur, a Bung na Sabat, a kum lamlabino tene etabor torom o God ma a kum Parisi det wan tomo torom o Pailat. ");
INSERT INTO kqw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Det watungi tano lena, “Labino, met nuk pas a wasiso anun a tene torotoro ri. Ra i laun utmakai, i watungi lena, ra a tulu bung in rop, in laun pat melet. ");
INSERT INTO kqw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Un tulu ru lako taro sur det in tamtamabat wakak a kulam na minat, elar nama tulu bung, sako anun a taro na ususer det in nanpat ma det in wolong pas a minatino, ra det in inanos a taro lena i sa laun melet gusun a minat. Ra a torotoro ri anundet, in labo tan a torotoro ra numugu o Iesu i sa watung tari.” ");
INSERT INTO kqw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","O Pailat i watungi tandet lena, “Uniutri mot in ben pas a kum tene tamtamabat ma mot in nan. Mot in tamtamabat wakak a kulam na minat elar ut nam anumot a mananos.” ");
INSERT INTO kqw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ra det wan, ma det udekdek bat tar a kulam na minat. Det ubek a ngas na ukinalong sur det in tasman pasi kut ra taio i sa papos tari. Ma det utur tar a kum tene tamtamabat sur det in tamtamabati. ");
INSERT INTO kqw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Numur tana Bung na Sabat, una lar una mugano bung una wik, o Maria Magdalen, ma ara Maria kai der wan sur der in tama a kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma a labino guri i wanpat, uni ara ensel anun a Labino i wan pirso tagisapat una langit sur a kulam na minat, ma i bulus gisen ru a wat, ra i kis taru netes uni. ");
INSERT INTO kqw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In masarino i talapor elar nam in nememe, ma anun in namalu i kabang elar nama busu na top. ");
INSERT INTO kqw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A kum tene tamtamabat det ngaran doko i, det neneder, ra det elar mukut nama kum minat. ");
INSERT INTO kqw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A ensel i watungi tan a aru ino ra lena, “Gong mur ngara. A tasmani lena, mur sisio sur o Iesu, i ra di sak wat tari un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ke kis mo nin. I sa laun melet elar nama nun a wasiso. Mur wan urin, mur in tama a nubual ra i inep taru uni. ");
INSERT INTO kqw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Numur mur in nan lakit, ma mur in inanos anun a kum nat na ususer lena, ‘I sa laun melet gusun a minat. Uniri in mugu utong o Galili. Mot in tama i tong.’ Iri a sa inanos mur uni.” ");
INSERT INTO kqw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Der wan lakit gusun a kulam na minat. Der ngara, ikut a labino gasgas kai i los der. Der kalabor sur anun a kum nat na ususer sur der in inanos det. ");
INSERT INTO kqw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ra der wan nanan, o Iesu i wanpat kisin torom der. Ma i watungi tander lena, “Wakak na kobot torom mur.” Der wan toromi, der pam aru kikino ma der lotu toromi. ");
INSERT INTO kqw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma o Iesu i watungi tander lena, “Gong mur ngara. Mur in nan ma mur in inanos a kum tistising liklik, sur det in nan utong o Galili, ma det in tama iau tong.” ");
INSERT INTO kqw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ra aru ino der sa wan taru, a ramano kum tene inaim ra det tamtamabat a kulam na minat, det wan usapat o Jerusalem. Ma det inanos a kum lamlabino tene etabor torom o God una kum utna rop ra i wanpat tong una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ra a kum lamlabino tene etabor ma a kum mugumugu det kis tomo, ma det wasiso tomo sur tu kisapi ra det in muri. Numur det pitar tar a labino mani torom a kum tene inaim, ");
INSERT INTO kqw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ra det watungi lena, “Mot in watungi kut lenri, ‘Una mirum ra met inep dumun, anun a kum nat na ususer det wanpat, ma det wolong pas a minatino.’ ");
INSERT INTO kqw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ra a mugumugu tagun a gapman in longoro a utna ri, ra in iting uni, met in warut mot, ma met in palos pas mot gusun a warkurai.” ");
INSERT INTO kqw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ra a kum tene inaim det los pas a mani, ma det pami elar nami ra di sa inanos tar det uni. Ma a wasiso ri i wan sarara torom a taro Juda tuk uniri. ");
INSERT INTO kqw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A noino ma ra nat na ususer anun o Iesu det wan utong o Galili una tangai ra o Iesu i sa inanos tar det uni. ");
INSERT INTO kqw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Det tama o Iesu, ra det lotu toromi, ikut ara taro tagun det ka det nurnur. ");
INSERT INTO kqw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O Iesu i wan milau torom det, ma i watungi tandet lena, “O God i sa pitar rop tar a warkurai tang, sur an warkurai a kum utna rop sapat una langit ma nin kai upiso. ");
INSERT INTO kqw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ra mot in nan, mot in ususer a kum kamkabo taro rop, sur det kai anung a kum nat na ususer. Mot in baptaiso det nama risan o Tita, ma o Nutunu, ma a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma mot in ususer det sur det in mur a kum wasiso rop ra a sa watung tari tamot. Ma a lingmulus lena iau, an kis tomo nam mot tuk una tintinipino.” ");
INSERT INTO kqw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iri a Wakak na Wasiso un o Iesu Karisito, a Nutun o God. ");
INSERT INTO kqw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","I turpasi elar nama wasiso anun o God ra a poropet Aisaia i sa tumus tari lena, “Tama i, an tulu ru anung a tene los wasiso sur in mugu tam, i ra in pam saro anum a kisapi. ");
INSERT INTO kqw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Una nubual kalako taro uni, in nalngan ara i kakabo lena, ‘Mot in pam saro a kisapi anun a Labino, mot in pam kodos anun a kum kisapi.’” ");
INSERT INTO kqw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A musano ra, i o Jon a Tene Baptaiso. I kis una nubual kalako taro uni, ra i ser warawai lena, a taro det in nukpukus ma din baptaiso det, sur o God in unus ru anundet a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A taro rop tagisapat o Jerusalem ma tagun a kum tamtamon rop kai una papor Judia, det wan toromi. Det watung puaso anundet a kum sakino petutna, ra i baptaiso det una danim Jodan. ");
INSERT INTO kqw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","O Jon i ser emar nam in namalu di pami nama iwu na kamel, ma i ser ker wati nam in pino bulumakau. I ser wan a kum ko ma a polono tatos. ");
INSERT INTO kqw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I ser watungi lena, “O naro ra in mur tang, a dekdekino i labo tan a dekdeking. Ka elar sur an par piso, ma an palos aru su gusun aru kikino, uni a natino sakit tano. ");
INSERT INTO kqw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iau, a baptaiso mot nama danim, ikut i, in baptaiso mot nama Tokodos na Nion.” ");
INSERT INTO kqw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Una ara bung, o Iesu i wanpat tagitong o Nasaret una papor Galili, ra o Jon i baptaiso i una danim Jodan. ");
INSERT INTO kqw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","O Iesu i saur gusun a danim, ra i tama a langit i papos, ma a Tokodos na Nion i wan pirso toromi elar namin natabun. ");
INSERT INTO kqw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","In nalngan ara tagisapat una langit i watungi lena, “Ui a Nutunglik, a nat na wakak, a gas nam ui.” ");
INSERT INTO kqw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Uniutra a Tokodos na Nion i tulu ru o Iesu usa una nubual kalako taro uni, ");
INSERT INTO kqw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ra i kis tiro a wat na noino bung, ra o Satan i lari. I kis tomo nama kum kuabor ma a kum ensel det waruti. ");
INSERT INTO kqw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ra di sa uruk tar o Jon una karabus, o Iesu i wanpat tiro una papor Galili, i warawai nama Wakak na Wasiso anun o God. ");
INSERT INTO kqw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I watungi lena, “A du bung i sa sot, ma a matanitu anun o God i sa milau. Mot in nukpukus, ma mot in nurnur una Wakak na Wasiso.” ");
INSERT INTO kqw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","O Iesu i usal una usalin ina du tasi Galili, ra i tama pas o Saimon der sino nam o Endru. Der woro a bene sa utasi, uni der aru tene woro bene. ");
INSERT INTO kqw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I watungi tander lena, “Mur in mur iau, sur an ususer mur sur mur aru tene ben taro.” ");
INSERT INTO kqw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Uniutra der katutur pas gusun anunder a kum bene, ma der muri. ");
INSERT INTO kqw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","I wan lilik melet, ra i tama pas o nandersino bulung, o Jems ma o Jon, aru nutnutun o Sebedi. Der kis taru una pot ma der mabon anunder a kum bene. ");
INSERT INTO kqw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Uniutra, o Iesu i kabo der, ra der wan gusun a tamander ma a kum tultul kura una pot, ma der muri. ");
INSERT INTO kqw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Det wan utong o Kapernaum. Ra una Bung na Sabat o Iesu i ruk utiro una rumu na lotu, ma i ususer a taro. ");
INSERT INTO kqw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ra det kisin una nuna kum etowo, uni i ususer det elar nam ara, ra a warkurai kura ut tano. Ke ususer det elar nama kum tene ususer tagun a Warkurai. ");
INSERT INTO kqw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Uniutra ara musano, a laulau na nion kura uni, i ruk utiro una nundet a rumu na lotu, ma i kakabo lena, ");
INSERT INTO kqw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu, ui a te Nasaret u ling na pam asau un met? U wanpat sur un banlaulau met? A tasman ui, ui a Tene Tokodos anun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","O Iesu i sakbati lena, “Gong u wasiso! Pirso gusun a musano ra!” ");
INSERT INTO kqw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma a laulau na nion i gunu dekdek tari, ra i kukukuk ma i pirso gusuni. ");
INSERT INTO kqw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A taro rop det kisin doko, ra det ting etetalai det lena, “Asau ri? A matok na ususer. A musano ri i ususer nama dekdek, ma a warkurai kura ut tano. I ser wasiso, ra a kum laulau na nion det ser tarom tano.” ");
INSERT INTO kqw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ra a wasiso un o Iesu i wan sarara lakit utiro una kum tamon rop una papor Galili. ");
INSERT INTO kqw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","O Iesu tomo nama nun a kum nat na ususer, det pirso tagun a rumu na lotu. Uniutra, det wan tomo nam o Jems ma o Jon ra det wan utiro una rumu anun o Saimon der nam o Endru. ");
INSERT INTO kqw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A ino a inumun o Saimon, i misait nama pino mararong, kura i inep. Uniutra det inanos o Iesu uni. ");
INSERT INTO kqw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ra o Iesu i wan toromi, i pam a lamano, ma i ukatutur pasi, ra a mararong i rop mut gusuni. Numur a ino ra i tabor det mo nama utna na inangon. ");
INSERT INTO kqw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ra in matanas i sa sup taru, a taro det ben pat a kum misait rop torom o Iesu, ma det kai ra a kum laulau na nion kura un det. ");
INSERT INTO kqw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A taro rop tagun a tamon ra, det wanpat ma det bukus una matansako. ");
INSERT INTO kqw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ra i ulangolango a susut ra det misait nama kum wur matano misait. I lakro ru a susut na laulau na nion gusun det, ma i turbat a kum laulau na nion sur gong det wasiso, uni det tasmani ut o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Una lar, o Iesu i tuangun ra i pirso. I wan sur a nubual kalako taro uni, ma i wararing tiro iai. ");
INSERT INTO kqw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","O Saimon ma det ra det wan tomo nami, det sisio suri. ");
INSERT INTO kqw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ra det sa sio pasi, det inanosi lena, “A taro rop det sisio sur ui.” ");
INSERT INTO kqw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ra o Iesu i balu det lena, “Dat in nan gisen bulung utiro un lako kum tamon milau, sur an warawai kai torom det. Uni i kut ra, a kibino ra a wanpat suri.” ");
INSERT INTO kqw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ra i wan tuptupukus una papor Galili rop. I warawai una nundet a kum rumu na lotu, ma i lakro ru a kum laulau na nion gusun a taro. ");
INSERT INTO kqw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ara musano, i misait nama lepra, i wan torom o Iesu, ra i kis butkeke, ma i saring dekdeki lena, “Ke ngangitin torom ui, ra u nemi, un ulangolango pas iau.” ");
INSERT INTO kqw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","O Iesu i maris doko i. I kodos a lamano, ma i pam a pinino ra i watungi tano lena, “A nemi ut, un langolango.” ");
INSERT INTO kqw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Uniutra, a lepra i rop mut gusuni, ra i langolango melet. ");
INSERT INTO kqw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Uniutra, o Iesu i tulu ru i, ma i pak bat tari lena, ");
INSERT INTO kqw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gong u inanos tar taio nami. Un nan ma un ese mugu tar ui torom a tene etabor torom o God, ma un pitar a kum etabor torom o God elar nami ra o Moses i sa watung tari. Ra un pami lenra, in talapor torom a taro lena u sa langolango.” ");
INSERT INTO kqw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ikut a musano ri, i wan ma i wasiso tuptupukus, ra a wasiso uni, i wan sarara. I mo ra, o Iesu ke wan puaso melet un tu tamon. I wan ra i ser kis tuptupukus mukut tiro una kum nubual kalako taro uni. Ikut a taro tagun a kum tamon det ser wan toromi. ");
INSERT INTO kqw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A iso bung bat tari, ra o Iesu i wanpat melet tiro una tamon Kapernaum. A taro det longoro i lena i sa wanpat tiro urumu. ");
INSERT INTO kqw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","A susut det wanpat, ra katu kolo sa urumu ma tiro upiso una matansako, ra i warawai torom det nama wasiso anun o God. ");
INSERT INTO kqw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ra a wat na musano det los ara musano a pinino i mat. Det losi torom o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ikut ka det pet lar pasi, uni a taro det bukus doko. Ra det wan tito usapat una lur na rumu, ra det papok saro pas a nubual taltalai nam o Iesu i tur iai, ra det unoro pirso a misait tomo nama bat ra i inep uni. ");
INSERT INTO kqw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","O Iesu i tama anundet a nurnur, ra i inanos a musano a pinino i mat lena, “Nutunglik, di sa unus ru anum a kum sakino petutna.” ");
INSERT INTO kqw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A ramano kum tene ususer tagun a Warkurai kura det kis taru, a nuknukindet i lena, ");
INSERT INTO kqw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ilai sur a musano ri i wasiso lenra? I watung laulau o God uni i elaro i nami. Osi i elar sur in unus ru a kum sakino petutna? O God kut takai.” ");
INSERT INTO kqw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Uniutra, o Iesu i tasman asau ra det nuknuk uni. Ra i ting det, “Ilai ra a nuknukimot i lenra? ");
INSERT INTO kqw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Asi na ngas na wasiso an len tan a musano ri, sur an ese a dekdeking nami torom mot? Pepetlai, an watungi lena, ‘Di sa unus ru anum a kum sakino petutna,’ o, an lena, ‘Un katutur, un los anum a bat ma un nan’? ");
INSERT INTO kqw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","An watungi lenri sur mot in tasmani lena, o God i pitar a warkurai torom a Nutun a Musano, sur in unus ru a kum sakino petutna nin upiso.” Ra o Iesu i watungi torom a musano a pinino i mat lena, ");
INSERT INTO kqw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A inanos ui, un katutur, un los anum a bat, ra un nan sur anum a rumu.” ");
INSERT INTO kqw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I katutur, ma i los anun a bat, ra i wan pirso umatan det rop. A taro rop det kisin ra det rakon lekeleke pas a risan o God lena, “Uni maragom ri, met tama a ngas na utna lenri.” ");
INSERT INTO kqw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","O Iesu i wan melet utiro una papor ina du tasi Galili. A labino kunur na taro det wanpat toromi, ra i ususer det. ");
INSERT INTO kqw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ra i wan nanan, i tama pas o Liwai a nutun o Alpius, i kis una rumu na los takis. O Iesu i inanosi lena, “Un mur iau.” Ra o Liwai i katutur ma i muri. ");
INSERT INTO kqw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Numur o Iesu ma anun a kum nat na ususer, det wangon tiro una rumu anun o Liwai. A susut na tene los takis, ma a kum tene sakino kai det wangon tomo nam det, uni a susut na taro lenri det ser mur o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A kum tene ususer tagun a Warkurai ra det Parisi utkai, det tama o Iesu i wangon tomo nama kum tene sakino ma a kum tene los takis, ra det ting anun a kum nat na ususer lena, “Sur asau o Iesu i wangon tomo nama kum tene los takis ma a kum tene sakino?” ");
INSERT INTO kqw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","O Iesu i longoro i, ra i watungi lena, “A dokta ke wanpat sur det ra det langolango. Awu! I wanpat sur det kut ra det misait. Ka wanpat sur an kabo pas a kum tene tokodos, awu. A wanpat sur an kabo pas a kum tene sakino.” ");
INSERT INTO kqw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A kum nat na ususer anun o Jon ma a kum Parisi det wewel. Ara taro det wanpat torom o Iesu ra det tingi lena, “Sur asau ra a kum nat na ususer anun o Jon ma a kum nat na ususer anun a kum Parisi det wewel, ikut anumi awu?” ");
INSERT INTO kqw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O Iesu i balu det lena, “A kum paspasan a matok na nolin, det in wewel pepetlai ra kura i utmakai tomo nam det? Ke sot sur det in wewel, uni a matok na nolin kura utmakai i tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ikut tu bung in nanpat, ra din ben ru a matok na nolin gusun det, ra det in wewel maragom. ");
INSERT INTO kqw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Katutaio in mabon a du matok na malu tomo nama turaino ra i tararos. Ra in lenra a du matok na malu in raros a turai na malu, ra in tararos bing. ");
INSERT INTO kqw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma kataio in titior a matok na wain utiro un in turai na koto, ra di pami nam in pino meme, sako a wain in purus in nokoto na wain, ra a wain ma in nokoto der in laulau. Din titior a matok na wain ut utiro un in matok na koto na wain. ");
INSERT INTO kqw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ara dubung una Bung na Sabat, o Iesu i wan nanan epotor una kum kinobot na wit. Anun a kum nat na ususer det wan tomo nami, ra det turpas a kumut a ramano kum turunu wit. ");
INSERT INTO kqw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A kum Parisi det inanos o Iesu lena, “Tama i! Ilai sur anum a kum nat na ususer det pam a utna ri, ra ke tokodos elar nama warkurai tagun a Bung na Sabat?” ");
INSERT INTO kqw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","O Iesu i balu det lena, “Pepetlai, ka mot luk utmakai asau ra o Dewid i pami? Una kilalo ra o Abiata i mugumugu na tene etabor torom o God, o Dewid tomo nama kum paspasano det murak, ma kalako utna. O Dewid i ruk tiro una rumu anun o God, ra i wan a beret di sa pitar tari torom o God. Ma i tabor kai a kum paspasano nami. Ikut a beret ra, a warkurai taguni, i lenri, a kum tene etabor torom o God kut det in nangon taguni, ma a taro ororos gong.” ");
INSERT INTO kqw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ra o Iesu i len tandet, “A Bung na Sabat di pami sur in warut a taro. Ka di pami sur a taro det in warut a Sabat. ");
INSERT INTO kqw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lenkutkai ra, a Nutun a Musano i a Labino utkai tagun a Bung na Sabat.” ");
INSERT INTO kqw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Numur o Iesu i ruk melet utiro una rumu na lotu. Ara musano kura iai, a lamano i kong. ");
INSERT INTO kqw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ara taro kura det sisio sur tu utna det in takun o Iesu nami. Ra det tamtama wakak taru ut uni, ra in ulangolango pas a musano ra una Bung na Sabat, o awu. ");
INSERT INTO kqw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ra o Iesu i inanos a musano ra a lamano i kong lena, “Un tur tiro numugu tan a taro rop.” ");
INSERT INTO kqw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Numur o Iesu i ting det lena, “Asau i tokodos sur din pami una Bung na Sabat? Din pam a wakakino, o a laulau ino? Din ulaun taio, o din um doko taio?” Ikut det kis wowowon ma ka det balu i. ");
INSERT INTO kqw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","O Iesu i nas pukpukus det, i balano sungun nam det, ikut i maris det, uni a balandet i dekdek doko. I inanos a musano ra a lamano i kong lena, “Kodos a lamam.” Ra i kodosi, ma a lamano i tokodos melet. ");
INSERT INTO kqw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Uniutra a kum Parisi det pirso ra det wasiso tomo nama taro anun o Erod, sur tu kisapi det in um doko o Iesu uni. ");
INSERT INTO kqw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","O Iesu tomo nam anun a kum nat na ususer, det wan utiro una papor ina du tasi Galili. Ma a labino kunur na taro taginin una papor Galili det muri. ");
INSERT INTO kqw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","A taro det longoro a kum sau ra i pami, ra a susut det wanpat toromi tagitong una ru papor Judia ma Idumea ma tagisapat o Jerusalem, ma tagitong una ara papor danim Jodan ma tagitong o Taia ma o Saidon. ");
INSERT INTO kqw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ra a kunur na taro det sa bukus, i inanos anun a kum nat na ususer, sur det in sio tar tu pot. Ra a taro det in bukus talilis pasi, in kas uni. ");
INSERT INTO kqw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I sa ulangolango tar a susut munung, ra a ramano kum misait bulung, det sugut saro det utiro toromi, sur det in pam a pinino. ");
INSERT INTO kqw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A taro ra a kum laulau na nion kura un det, ra det in tama i, det in puku piso sa numugu tano, ma det in woiwoi lena, “Ui a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ikut i turbat dekdek det, sur gong det inanos tar taio lena, i osi. ");
INSERT INTO kqw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","O Iesu i wan usapat una tangai, ra i kabo pas ara taro ra i ling sur det, ra det wan toromi. ");
INSERT INTO kqw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I pilok pas a noino ma aru musano, ra i urising det nama kum aposel. I pilok det sur det in nan tomo nami, ma sur in tulu det sur det in warawai. ");
INSERT INTO kqw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma i pitar a dekdek torom det, sur det in lakro ru a kum laulau na nion. ");
INSERT INTO kqw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iri a kum risan a noino ma aru musano ra i pilok pas det: O Saimon, i ra o Iesu i urisingi nam o Pita, ");
INSERT INTO kqw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","o Jems ma o Jon der sino, aru nutnutun o Sebedi, der ra o Iesu i urising der nam o Boanerges, i kukuraino, aru nutnutun a pungpugur, ");
INSERT INTO kqw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ma o Endru, o Pilip, o Batolomiu, o Matiu, o Tomas, o Jems a nutun o Alpius, o Tadius, o Saimon ara tagun a kabotaro Silot, ");
INSERT INTO kqw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma o Judas Iskariot, i ra i usobor tar o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Numur ra o Iesu i sa ruk taru una rumu, ara kunur na taro bulung det wanpat toromi, ra katu du bung sur o Iesu ma anun a kum nat na ususer det in nangon uni. ");
INSERT INTO kqw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A kum kukunu det longoro a wasiso ra uni, ra det wanpat sur det in ben pasi, uni a taro det watungi uni lena ke tokodos mo a nuknukino. ");
INSERT INTO kqw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ra a kum tene ususer tagun a Warkurai, ra det wan tagisapat o Jerusalem, det watungi lena, “O Belsebul, a labino anun a kum laulau na nion, i sisiop taru un o Iesu, ra i ser lakro ru a kum laulau na nion nama dekdekin o Belsebul.” ");
INSERT INTO kqw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ra o Iesu i kabo pas det toromi, ma i wasiso torom det nama kum wasiso elelar lenri, “Pepetlai sur o Satan in lakro melet ru o Satan? ");
INSERT INTO kqw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ra tu gapman det melet ut det in waim etalai, a gapman ra in tur dekdek pepetlai? ");
INSERT INTO kqw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma ra lako taro tagun tu rumu det in waim etalai melet kut, det in nan sarara. ");
INSERT INTO kqw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ra o Satan in tur na inaim melet kut nam anun a kum tultul, ma ka det in tur tomo, o Satan ken tur dekdek, in rop kut. ");
INSERT INTO kqw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kataio in pet lar pasi sur in ruk una rumu anun tu dekdek na musano, ma in los pas a kum utna tagitiro una nun a rumu, ra ken ker ukai mugu tar a musano. Ra ut in ker ukai mugu tari, ra in los a kum utna maragom anun a musano ra. ");
INSERT INTO kqw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A inanos mot nama lingmulus, din unus ru a kum sakino petutna rop anun a taro, ma anundet a kum sakino wasiso kai un o God. ");
INSERT INTO kqw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ikut ra taio in wasiso laulau una Tokodos na Nion, katutaio melet mo in unus lar pasi. Anun a sakino petutna ra, in kis tukum.” ");
INSERT INTO kqw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","O Iesu i wasiso lenri, uni det watungi uni lena, “A laulau na nion i sisiop taru uni.” ");
INSERT INTO kqw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Numur o nan o Iesu ma a kum tistisino det wanpat. Det tur taru kut nago upiso ra det tulu ara sur in ben pasi torom det. ");
INSERT INTO kqw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A kunur na taro kura det kis talilis pasi, det inanosi lena, “O nam ma a kum tistisim kunago det upiso. Det nem na tama ui.” ");
INSERT INTO kqw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ra i ting det lena, “Mot nuki osi o nang, ma osi det a kum tistising?” ");
INSERT INTO kqw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Numur i tamtama torom det rop ra det kis talilis pasi, ra i watungi lena, “Tama i, det ri o nang ma a kum tistising! ");
INSERT INTO kqw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Osi ra i ser mur a nemnem anun o God, i ra a tising a musano, ma a tising a ino, ma o nang.” ");
INSERT INTO kqw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Numur o Iesu i tur melet pas a etowo tiro nisan a du tasi Galili. A kunur na taro det bukus doko ma det tur talilis pasi. I kas una pot ra i kis taru uni sa utasi, ma a taro rop det tur nago korot una usalin. ");
INSERT INTO kqw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I ususer det una susut na utna nama kum wasiso elelar. I ususer det lena, ");
INSERT INTO kqw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mot longoro i! A tene minarut i wan sur in sapro a kum pitino wit. ");
INSERT INTO kqw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ra i sapro nanan a kum pitino wit, a ramano det puku una kisapi, ra a kum piko det ro pat ma det wan ru i. ");
INSERT INTO kqw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A ramano kai det puku una nubual na watat, ra kalako susut na piso uni. Det lubung pat lakit, uni a piso ke but. ");
INSERT INTO kqw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ikut ra a suan i sisio pat, i rang det ra det main ma det marang rop, uni kalako wakakor indet. ");
INSERT INTO kqw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A ramano kum pitino wit det puku epotor una kum kuikui, ra a kum kuikui det lubung ma det rau bat pas det. Ra ka det wu lako windet. ");
INSERT INTO kqw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ikut a ramano kum pitino det puku una wakak na piso. Det lubung pat, det labo ra det wu. A ramano det wu a tulu noino, a ramano kai a wonom na noino, ma a ramano ara mar na windet.” ");
INSERT INTO kqw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ra o Iesu i len tandet, “Osi ra arin talngano kura, i wakak sur in longoro nami.” ");
INSERT INTO kqw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","O Iesu mukut kura i kis taru, ra a noino ma aru nat na ususer ma ara taro kai det tingi una kum wasiso elelar. ");
INSERT INTO kqw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ra i inanos det lena, “O God i utalapor a wasiso na pidik una nun a matanitu torom mot. Ikut torom det a taro gisen, a ususer det una ututna rop nama wasiso elelar, ");
INSERT INTO kqw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sur, ‘det in tamtama ma det in tamtama, ikut ka det in tama lele i, ma det in longoro ma det in longoro, ikut ka det in tasman lele i. Ra gunuk det in tasman lele i, sako det in tupukus torom o God ma in unus ru anundet a kum sakino.’” ");
INSERT INTO kqw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O Iesu i inanos det lena, “Pepetlai, ka mot talapor una wasiso elelar ri? Mot in talapor lai un tu wasiso elelar kai? ");
INSERT INTO kqw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A tene minarut i elar nam ara musano ra i ususer det nama wasiso anun o God. ");
INSERT INTO kqw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A kum pitino wit ra det puku una kisapi, det elar nam ara taro det longoro a wasiso anun o God, ra a iapiap kut, o Satan i wanpat ma i rakon ru i. ");
INSERT INTO kqw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A kum pitino ra det puku una nubual na watat det elar nam ara taro det longoro a wasiso anun o God, ra uniutra det pam ukai i nama gasgas. ");
INSERT INTO kqw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ikut a wasiso anun o God ke kis ubalandet, ra ka det in tur suano i, elar nama wit ra kalako wakakor indet. Ra a kum mamaut in nanpat, ma din banlaulau det, uni det nurnur una wasiso anun o God, det in puku lakit. ");
INSERT INTO kqw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A kum pitino ra det puku epotor una kum kuikui, det elar nama taro ra det longoro a wasiso, ");
INSERT INTO kqw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ikut a labino nuknuk sur a wakak na kinkinis nin upiso, ma a kum usobor tagun a kum ululeng taginin una rakrakon bual, ma a nemnem kai sur a ramano kum utna, i rau bat a wasiso anun o God, ra ka det wu lako windet. ");
INSERT INTO kqw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ikut a ramano taro det elar nama kum pitino, ra det lubung sapat una wakak na piso. Det longoro a wasiso ma det muri, ra det wu. A ramano det wu a tulu noino, a ramano a wonom na noino, ma a ramano ara mar na windet.” ");
INSERT INTO kqw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O Iesu i len tandet, “Katutaio in los pas tu lam ma in wop bat tari nama paket, o in ubek tari kai nago utuntudu ina kabulu. Awu, din ubek tari ut netes una nuna turtur. ");
INSERT INTO kqw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A kum utna rop ra i kis eno, numur in nanpat pupuaso. Ma a kum utna rop ra di munu tari, numur in kis taltalapor, ma din tasmani. ");
INSERT INTO kqw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ra taio arin talngano kura, i wakak sur in longoro nami.” ");
INSERT INTO kqw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O Iesu i wasiso liklik utmakai ra i lena, “Mot nuknuk wakak un asau ra mot longoro i. Ra mot in longoro wakak, o God in pitar a labino tastasman torom mot. Mot in utur ukai a tastasman ra i labo sakit. ");
INSERT INTO kqw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Osi ra i longoro anung a kum etowo, o God in pitar a labino tastasman toromi. Ikut osi ra ke longoro, din rakon ru utkai asi na nat na tastasman lik ra kura i utur ukai i.” ");
INSERT INTO kqw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O Iesu i watungi kai lena, “A matanitu anun o God i elar nam ara musano ra i sapro a kum wino wit una piso. ");
INSERT INTO kqw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","I ser inep una mirum ma i ser ungalo una waspi, ra a kum wino wit det lubung pat ma det labo, ikut a musano ke tasmani ra det lubung pepetlai. ");
INSERT INTO kqw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A piso ut i ser ulubung a kum wit lenri: Numugu in ubek in gomono, numur in nanaino in labo tito, ra numur in ubek in gilino tomo nama wino. ");
INSERT INTO kqw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ra kut a kum wino det sa taka, a musano ra, in nan tomo nam anun in totok, ma in pirat pas det, uni a kalang sur din pasong a wit i sa sot.” ");
INSERT INTO kqw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O Iesu i watungi lena, “A matanitu anun o God i elar nam asau? Ma asi na wasiso elelar ra an utalapori nami? ");
INSERT INTO kqw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I elar nam in pitino mastad. I natino taun a kum pitino duwai rop, ra di maruti una piso. ");
INSERT INTO kqw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ikut ra di sa marut tari, ma i lubung, i labo taun a kum duwai na inangon rop. I ubek a kum lamlabino kanokano, ma a kum piko det ser pam pios una kum kanokano ra kura una kabosoro ino.” ");
INSERT INTO kqw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","O Iesu i ususer det nama susut na wasiso elelar kai, ra i elar nam anundet a tastasman. ");
INSERT INTO kqw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ke wasiso torom det nam tu se wasiso, a wasiso elelar rop kut. Ikut, ra i mukut tomo nam anun a kum nat na ususer det kis, i utalapori maragom a kukurai na kum wasiso elelar. ");
INSERT INTO kqw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Una bung na lirop ut ra, o Iesu i inanos anun a kum nat na ususer lena, “Dat nan utong una ara papor tasi.” ");
INSERT INTO kqw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A kum nat na ususer det kas utiro una pot ra o Iesu kura uni, ra det wan gusun a kunur na taro. A ramano kum pot utkai det wan tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A dekdek na wuwu doko i ragoti, ma a toptop i tapak sapat netes una pot, ra i milau sur in bukus nama tasi. ");
INSERT INTO kqw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","O Iesu i inep taru nago numur una pot, ma i ulalong una pilo. A kum nat na ususer det wanguni ma det inanosi lena, “Tene ususer, dat na iru. Ko nuk pas met mo?” ");
INSERT INTO kqw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I katutur, i turbat a wuwu ma i len tan a top, “Mana, un mililo.” Ra a wuwu i rop ma i mililo mut. ");
INSERT INTO kqw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Numur i len tan a kum nat na ususer lena, “Sur asau ra mot ngara? Awai kuti anumot a nurnur?” ");
INSERT INTO kqw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Det ngara doko ma det ting etetalai det lena, “Osi na ngas na musano mulus ri? A wuwu ma a top der tarom tano!” ");
INSERT INTO kqw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","O Iesu tomo nam anun a kum nat na ususer det wan kutus una du tasi Galili utong una ara papor sur a papor anun a taro Gerasa. ");
INSERT INTO kqw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ra o Iesu i sirok gusun a pot, ara musano, a laulau na nion kura uni, i wan gusun a kum kulam na minat sur in nan barato i. ");
INSERT INTO kqw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A musano ra, i ser kis una kum kulam na minat. Ma kataio ut i pet lar pasi sur in pam ukai i, ma a sen kai ke sot sur din ker ukai i nami. ");
INSERT INTO kqw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A susut na dino mo, di ser ker ukai aru lamano ma aru kikino nama sen, ikut i ser rubut a sen ma i ser sak ginogino a kum sen gusun aru kikino. Katutaio ut i dekdek sur in umarom lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Una mirum ma a waspi, i ser kukukuk abit tiro una kum kulam na minat ma una kum tangai, ma in toktok a pinpinino nama watat. ");
INSERT INTO kqw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ra i bakbak utmakai, i tama o Iesu, i kalabor ma i kis butkeke nama urur numugu tano. ");
INSERT INTO kqw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A musano ra i kukukuk nam in labino walngano lena, “Iesu, a Nutun o God, a Labino Sakit, asau u nem na pami un iau? Un liliman umatan o God sur gong u banlaulau iau.” ");
INSERT INTO kqw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I wasiso lenri, uni o Iesu i sa watung tari lena, “A laulau na nion, un pirso gusun a musano ri.” ");
INSERT INTO kqw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Numur o Iesu i tingi lena, “Osi a risam?” Ma i balu i lena, “A risang A Kabo Liur, uni a susut met.” ");
INSERT INTO kqw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ra i saring liklik o Iesu sur gong i lakro ru tar det gusun a nubual ra. ");
INSERT INTO kqw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A kabo liur na boro kura det wangon tiro milau kut una tangai. ");
INSERT INTO kqw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ra a kum laulau na nion det inanos dekdek o Iesu lena, “Un tulu met utiro torom a kabo liur na boro, sur met in ruk utiro un det.” ");
INSERT INTO kqw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O Iesu i longoro det, ra i tulu det. A kum laulau na nion det pirso gusun a musano, ma det ruk una kum boro. Ra a kum boro det kalabor pirso una palis sur a du tasi, ma det kongo rop. Det rop det elar nama ru arip. ");
INSERT INTO kqw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A taro ra det ser tamtabor a kabo liur na boro ra, det kalabor ma det inanos tiro utamon ma tiro utkai una kum natnat na tamon. Ra numur a taro det wan sur det in tama asau ra i wanpat. ");
INSERT INTO kqw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ra det wanpat torom o Iesu, det tama a musano ra a kabo liur na laulau na nion numugu det sisiop taru uni. Kura mukut i kis taru, i sa pipis pas ma a nuknukino i sa talapor melet. Det tama i ra det ngara doko. ");
INSERT INTO kqw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Det ra det tama tari, det inanos a taro una kum utna ra i wan pat una musano ra a kum laulau na nion det sisiop tari, ma una kum boro kai. ");
INSERT INTO kqw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Numur a taro det saring dekdek o Iesu sur in nan gisen gusun anundet a papor. ");
INSERT INTO kqw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","O Iesu i kas utiro una pot, ra a musano ra numugu a kum laulau na nion det sisiop tari, i saring ngongos o Iesu sur in nan tomo nami. ");
INSERT INTO kqw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","O Iesu ke tarom tano, ikut i lena, “Un nan utiro una num a tamon torom a kum kukum, ma un inanos det una labino utna ra a Labino i sa pam tari un ui, ma una nuna marmaris torom ui.” ");
INSERT INTO kqw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ra a musano ra i wan, ma i inanos a taro tiro o Dekapolis, una labino utna ra o Iesu i sa pam tari uni. Ra a taro rop det kisin. ");
INSERT INTO kqw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","O Iesu i kas una pot ma i wan melet utiro una ara papor du tasi. A kunur na taro det wan tomo ma det tur talilis pasi tiro una usalin. ");
INSERT INTO kqw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ara mugumugu tagun a rumu na lotu, a risano o Jairus, i wanpat tiro. I tama o Iesu, ra i kis butkeke sa numugu tano, ");
INSERT INTO kqw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma i saring dekdeki lena, “A nutunglik, a ino, i sa ling na mat. Aiap, dar in nan ma un ubek a lamam sapat netes uni, sur in langolango ma in laun.” ");
INSERT INTO kqw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ra o Iesu i wan tomo nami, a kunur na taro det muri, ma det bukus talilis pasi. ");
INSERT INTO kqw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma ara ino kura, i misait nama gap elar nama noino ma aru kilalo. ");
INSERT INTO kqw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I taramo a labino ngunungut ulaman a kum dokta, ma i urop tar anun a kum utna ra i ulengi un det. Ikut ke langolango, a misait i labo nanan kut. ");
INSERT INTO kqw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","I longoro a saksak utna un o Iesu, ra i wan tiro ubalan a kunur na taro, numur tan o Iesu, ma i tuk anun a kolos. ");
INSERT INTO kqw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","I pami lenra, uni i nuki lena, “Ra an tuki kut anun a kolos, an langolango.” ");
INSERT INTO kqw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Uniutra a gap i tuk, ra a ino i taramo a pinino i langolango ma ke taramo melet a ngunungut. ");
INSERT INTO kqw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Uniutra, o Iesu i taramo a dekdek i wan gusuni, i tupukus torom a kunur na taro ra i iting lena, “Osi ra i tuk anung a kolos?” ");
INSERT INTO kqw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anun a kum nat na ususer det balu i lena, “U tama a kunur na taro det talilis bat ui, ra u iting pepetlai lena, ‘Osi ra i tuk iau?’” ");
INSERT INTO kqw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ikut o Iesu i tamtama utmakai sur osi ra i tuk tari. ");
INSERT INTO kqw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A ino ra i tasman a misait i sa rop gusuni, i wan ra i puku sa numugu tan o Iesu. I ngara ma i neneder, ra i inanosi nam asau ra i sa pam tari. ");
INSERT INTO kqw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","O Iesu i watungi tano lena, “Nutunglik, anum a nurnur i sa ulangolango pas ui. Un nan, ma in balam in molmol. Anum a misait i sa rop gusun ui.” ");
INSERT INTO kqw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ra o Iesu i wasiso utmakai, a ramano kum musano ra det wan tagitiro una rumu anun o Jairus, a mugumugu tagun a rumu na lotu, det wanpat. Det lena, “O nutumlik i sa mat. Gong mo u ubalon a tene ususer.” ");
INSERT INTO kqw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","O Iesu ke nuk pas asau ra det watungi, ikut i inanos a mugumugu tagun a rumu na lotu lena, “Gong u ngara. Un nurnur kut.” ");
INSERT INTO kqw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ke madek taio sur in muri, ikut i mulaot sur o Pita, ma o Jems der sino nam o Jon detul in muri. ");
INSERT INTO kqw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ra det wanpat tiro una rumu anun a mugumugu ra, o Iesu i tama det ra det tala, det ugaia ma det domos. ");
INSERT INTO kqw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I ruk ra i watungi tandet lena, “Ilai ra mot tala ma mot ugaia nama tinangis? A ino lik ri ausur i mat, i inep dumun kut.” ");
INSERT INTO kqw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ra det nongoni kut. I tulu pirso ru det rop, ikut i ben pas a taman a ino lik ma o nano ma anun a tulu nat na ususer, ra detul wan tomo nami. Ra det ruk torom a ino lik. ");
INSERT INTO kqw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O Iesu i pam a laman a ino lik ra i inanosi lena, “Talita koum!” A kukuraino i lenri, “A ino lik, a watungi tam, un katutur!” ");
INSERT INTO kqw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Uniutra, a ino lik i katutur ma i wan. Det tama i ra det kisin doko. I elar nama noino ma aru kilalo anunu. ");
INSERT INTO kqw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","O Iesu i turbat dekdek det sur gong det inanos tar taio un asau ra i sa pam tari. Ma i inanos det sur det in tabor a ino lik ra, nam lako utna na inangon. ");
INSERT INTO kqw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","O Iesu tomo nam anun a kum nat na ususer det wan tagitong o Kapernaum, ra det wanpat tong o Nasaret, a tamon anun o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Una Bung na Sabat, i turpasi sur in ususer a taro tiro una rumu na lotu. A susut na taro ra det longoro i, det kisin doko, ra det watungi lena, “A musano ri i tasman lan a kum utna ri? A ngas na mananos sau ri di pitari tano, ra i pam a kum lamlabino utna na ukisin nami? ");
INSERT INTO kqw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I a tene pam rumu kut, a nutun o Maria. A kum tistisino kai, o Jems, o Josep, o Judas ma o Saimon, ma a kum bunu kai ano kuri ut dat laun tomo nin.” Ra a taro ka det nemi ut mo. ");
INSERT INTO kqw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","O Iesu i watungi tandet lena, “Di ser ru a poropet una kum se tamon, ikut det ut una nun a tamon, a kum kukunu ma det kai una nun a rumu ka det ru i.” ");
INSERT INTO kqw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","O Iesu ke pam lar pas lako susut na utna na ukisin tiro iai, ikut i ubek aru lamano una pak na misait, ra i ulangolango pas det. ");
INSERT INTO kqw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I kisin, uni ra ka det nurnur uni. Numur o Iesu i wan tuptupukus una kum tamon, ra i ususer a taro. ");
INSERT INTO kqw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I kabo pas a noino ma aru nat na ususer, ra i tulu ru det a ruru, ma i pitar a dekdek tandet sur det in lakro ru a kum laulau na nion. ");
INSERT INTO kqw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I watungi tandet lena, “Gong mot los tu utna una numot a inawan, mot in losi kut in nubuku. Gong mot los lako utna na inangon, gong tu rat ma gong mot silapo tu mani una numot a kum malu. ");
INSERT INTO kqw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mot in pas aru su, ikut gong mot los tar tin namalu na kelkeles. ");
INSERT INTO kqw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ra mot in ruk un tu rumu, mot in kis ut tiro iai tuk una bung ra mot in nan gusun a tamon ra. ");
INSERT INTO kqw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ra a taro tagun tu tamon ka det in gas pas mot, ma ka det in longoro anumot a wasiso, ra mot in nan gusun a tamon ra, mot in tang ru a kubus gusun a kikimot. Mot in tang ru a kubus sur a ukinalong na utumarong torom det.” ");
INSERT INTO kqw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ra det wan ma det warawai torom a taro, sur det in nukpukus. ");
INSERT INTO kqw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma det lakro ru a susut na laulau na nion, ma det talus a susut na misait nama wel, ma det ulangolango pas det. ");
INSERT INTO kqw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A King Erod i longoro a wasiso un o Iesu, uni a taro rop det sa tasmani. Ara taro det watungi uni lena, “A musano ra, i o Jon a Tene Baptaiso, i sa laun melet gusun a minat. I mo ra, i pam a kum utna na ukisin.” ");
INSERT INTO kqw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ara taro kai det watungi un o Iesu lena, “I, a poropet Elaija.” Ara taro kai det watungi uni lena, “O Iesu, i ara poropet elar nama kum poropet tagun numugu.” ");
INSERT INTO kqw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","O Erod i longoro a kum wasiso ri un o Iesu, ra i lena, “A sa tau kutus ru tar in lorin o Jon, ra uniri i sa laun pat melet gusun a minat!” ");
INSERT INTO kqw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Numugu o Erod i tulu ru anun a kum tene inaim sur det in dat pas o Jon, ma det in ker pasi, ra det in uruk tari una karabus. O Erod i pami lenri, uni o Jon i inanosi lena, “Ke tokodos ra u nolin nam o Erodias, a urim.” I watungi lenri, uni o Erod i sa sal pas o Erodias, a ino anun o tisino, o Pilip, ra i nolin nami. ");
INSERT INTO kqw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","O Erodias i nget laulau o Jon ma i nemi sur in um doko i. Ikut ke pet lar pasi, ");
INSERT INTO kqw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","uni o Erod i ngaran o Jon ra i tamtamabati. I pami lenra uni i tasmani lena, o Jon a tene tokodos ma a musano anun o God. O Erod i gas sur in longoro anun a kum wasiso, ikut a nuknukino i ser talara nami. ");
INSERT INTO kqw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Numur o Erodias i nuk pas ara kisapi sur din um doko o Jon. Una bung ra di ukinalong a bung na usus anun o Erod, o Erod i pam a labino inangon sur a kum mugumugu tagun anun a gapman, ma a kum mugumugu anun a kum tene inaim, ma a kum mugumugu tagitong una papor Galili. ");
INSERT INTO kqw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ra det kis una inangon, a nutun o Erodias a ino, i ruk ra i lagor nisan det. O Erod ma a taro ra det wangon tomo nami, det gas doko nami. Numur i len tan a toraro ra lena, “Asau ra u nemi tang, an tabor ui nami.” ");
INSERT INTO kqw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ra i liliman dekdek tari lena, “Asau mukut ra un saringi tang, an pitari tam. Ra un saring iau kai sur tu kukur tagun a kum utna ra a warkurai suri, an pitari ut tam.” ");
INSERT INTO kqw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ra i wan torom o nano ma i tingi lena, “Asau ra an saringi tano?” O nano i balu i lena, “Un saringi sur in lorin o Jon a Tene Baptaiso.” ");
INSERT INTO kqw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Uniutra, a toraro ra i wan lakit torom a king, ra i watungi tano lena, “Uniutri, un tabor iau nam in lorin o Jon a Tene Baptaiso un tu pelet.” ");
INSERT INTO kqw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A king i tupunuk doko. Ikut ke nemi mo sur in ipul, uni i sa liliman taru lena asau mukut ra in saringi tano in tabori ut nami, ma a taro ra det kis tomo nami una inangon, det sa longoro tar anun a wasiso. ");
INSERT INTO kqw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Uniutra, i tulu ru a tene inaim sur in los tar in lorin o Jon toromi. A tene inaim i ruk una karabus, ra i tau kutus pas in lorin o Jon. ");
INSERT INTO kqw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I ubek pasi una pelet, ra i pitari torom a toraro, ra i bulung i pitari torom o nano. ");
INSERT INTO kqw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A kum nat na ususer anun o Jon det longoro i, ra det wan ma det los pas a minatino, ma det uruk tari una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A kum aposel det kis tomo nam o Iesu, ra det inanosi una kum utna rop ra det sa pam tari, ma det sa ususer tar a taro kai nami. ");
INSERT INTO kqw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ra o Iesu i watungi tandet lena, “Dat in nan sur tu nubual kalako taro uni, sur mot in mana pas.” I watungi lenri, uni a susut na taro det wanpat liklik kut, ma katu du bung sur o Iesu tomo nam anun a kum aposel det in nangon uni. ");
INSERT INTO kqw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ra det kut det kas una pot ra det wan sur a nubual kalako taro uni. ");
INSERT INTO kqw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A susut na taro ra det tama det ra det soi, det tama lele pas o Iesu tomo nam anun a kum aposel. Det kalabor gusun a kum tamon ra det mugu pat una nubual ra o Iesu det in sot iai. ");
INSERT INTO kqw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ra det sot, o Iesu i tama a labino kunur na taro. I maris doko det, uni det elar mukut nama kum sipsip ra katu tene tamtamabat anundet. Ra i tur pas a towo det nama susut na utna. ");
INSERT INTO kqw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ra i sa lirop, anun a kum nat na ususer det wan toromi, ra det watungi tano lena, “A nubual ri i bakbak gusun a kum tamon, ma i sa lirop kai. ");
INSERT INTO kqw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Un tulu ru a taro sur det in nan sur a kum natnat na tamon milau, ma a kum lamlabino tamon kai. Det in kul pas lako utna sur det in nani.” ");
INSERT INTO kqw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O Iesu i balu det lena, “Mot ut mot in tabor det.” Det watungi tano lena, “Kalako ru mar na denari sur dat in kul tabor det nami.” ");
INSERT INTO kqw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ra o Iesu i ting det, “Lako isin beret kura mot losi? Mot in nan ma mot in tamtama.” Ra det sa tama tari, det inanos o Iesu lena, “A limanin beret kut kuri ma aru kiripo kai.” ");
INSERT INTO kqw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ra o Iesu i tulu anun a kum nat na ususer sur det in tibo susuaro a taro sur det in kis un in wuliso. ");
INSERT INTO kqw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","A ramano det kis arara mar, ma a ramano kai a limlimo na noino. ");
INSERT INTO kqw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ra o Iesu i los pas a limanin beret, ma aru kiripo, i tamtama usapat una langit, i watung wakak pas torom o God uni, ra numur i tibik a limanin beret, ra i pitari tan anun a kum nat na ususer sur det in tibo a taro nami. I tibo det rop kai nam aru kiripo. ");
INSERT INTO kqw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Det rop det wangon ma det masur. ");
INSERT INTO kqw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Numur det song bukus pas a noino ma aru rat nama beret ma a kiripo ra det wan kopos tari. ");
INSERT INTO kqw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A kunur na taro ra det wangon, a niluluk ina kum musano sot kut i elar nama limo na arip. ");
INSERT INTO kqw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Uniutra, o Iesu i tulu ru anun a kum nat na ususer, sur det in kas una pot, ma det in mugu utong o Betsaida una ara papor tasi. Ma i, i kis utmakai sur in tulu ru a taro. ");
INSERT INTO kqw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ra i wan gusun det, i wan tito usapat una tangai sur in wararing. ");
INSERT INTO kqw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ra i sa lirop matano mirum, a pot i sa wan potor una du tasi, ma o Iesu mukut i kis nago una usalin. ");
INSERT INTO kqw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I tama det ra i sa tekes det a ulusu, uni a wuwu i waim tagisa numugu. Una lar, o Iesu i wan sapat netes una tasi torom det, ra i ling na wan sakit det. ");
INSERT INTO kqw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Det tama pasi ra i wan sapat netes una du tasi, det nuki lena a nion. Ra det woiwoi, ");
INSERT INTO kqw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","uni det rop det tama i, ra det ngara doko. Uniutra o Iesu i watungi tandet lena, “A kosom taru tamot, iau kut ri. Gong mot ngara.” ");
INSERT INTO kqw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ra o Iesu i kas torom det una pot, ra a wuwu i mana mut. Det kisin doko, ");
INSERT INTO kqw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","uni ka det tasman wakak a utna na ukisin ra o Iesu i sa pam tari una beret ma a kiripo. Uni a balandet i dekdek doko. ");
INSERT INTO kqw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ra det sa wan kutus un ara papor tasi , det sot tiro una papor Genesaret, det ega tar a pot. ");
INSERT INTO kqw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Det sirok gusun a pot, ra uniutra, a taro det tama lele pas o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Det kalabor una kum tamon una papor ra sur det in los a kum misait torom o Iesu. Det los det una kum lu sur utiro toromi, un asi na tamon ra det longoro i lena, i kura iai. ");
INSERT INTO kqw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","O Iesu i wan utiro una kum natnat na tamon ma a kum lamlabino tamon kai, ra a taro det los pat a kum misait ma det uinep det tiro una nubual ra a taro det ser wan tomo uni. A kum misait det saringi sur det in pami kut a sinisir ina nun a kolos. Ra det rop ra det pami, det langolango mut. ");
INSERT INTO kqw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A kum Parisi ma a kum tene ususer tagun a Warkurai ra det wan tagisapat o Jerusalem, det wan tomo torom o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Det tama a ramano kum nat na ususer anunu ra det wangon kut nama dur na lamandet, ma ka det gos mugu pas a kum lamandet. ");
INSERT INTO kqw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A kum Parisi tomo nama taro Juda rop det mur a wasiso anun a taro tagun numugu, lena ka det nangon, ra ka det gos mugu pas a kum lamandet. ");
INSERT INTO kqw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ra det in milet tagitiro una nubual na siuru, det in gos lamandet mugu pas ut, numur det in nangon. A ramano utna utkai tagun numugu ra det ser pami, i lenri, det ser gos a kum kap, a kum kuro, ma a kum ketel. ");
INSERT INTO kqw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A kum Parisi ma a kum tene ususer tagun a Warkurai det ting o Iesu lena, “Ilai ra anum a kum nat na ususer ka det ser mur a kum etowo anun anundat a taro tagun numugu? Det ser wangon kut nama kum dur na lamandet.” ");
INSERT INTO kqw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ra o Iesu i balu det lena, “A wasiso anun o Aisaia i lingmulus ut, ra i wasiso na poropet mugu taru un mot a kum tene torotoro. I tumusi un mot lena, ‘A taro ri det ru iau kut nama wandet, ikut a balandet i bakbak doko gusun iau. ");
INSERT INTO kqw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Det lotu oros kut torom iau, uni det ususer nama kum warkurai anun a taro kut.’ ");
INSERT INTO kqw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mot sa wan gusun a kum Warkurai anun o God, ma mot mur mukut a kum etowo anun a taro.” ");
INSERT INTO kqw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","O Iesu i watungi tan a kum Parisi ma a kum tene ususer tagun a Warkurai lena, “A lingmulus ut, mot sa rosumur gusun a Warkurai anun o God, sur mot in muri kut a kum etowo anun anumot a taro tagun numugu. ");
INSERT INTO kqw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Uni o Moses i watungi lena, ‘Un ru o tamam ma o nam,’ ra i watungi kai lena, ‘Osi ra in wasiso laulau un o tamano ma o nano, din um doko i.’ ");
INSERT INTO kqw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ikut mot, mot ususer a taro lena, i wakak kut, ra taio in watungi tan o tamano ma o nano lena, ‘Asau ra an warut mur nami, a sa tabor tar o God nami.’ ");
INSERT INTO kqw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mot turbati kut sur gong i warut o tamano ma o nano. ");
INSERT INTO kqw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ra mot pami lenra, mot unatino pas a wasiso anun o God, ma mot muri kut a kum etowo ra mot los pasi gusun anumot a taro tagun numugu. Ma a susut na utna kai lenri ra ke tokodos, mot ser pami.” ");
INSERT INTO kqw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","O Iesu i kabo melet pas a kunur na taro toromi, ra i watungi tandet lena, “Mot rop mot in longoro iau, ma mot in tasman lele anung a wasiso. ");
INSERT INTO kqw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tu utna ra taio in nan pasi ma in ruk un in balano, ken uduri umatan o God. Ikut, a kum utna ra in pirso gusun a nuknukino, i ra in uduri umatan o God.” ");
INSERT INTO kqw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","O Iesu i wan gusun a kunur na taro, ma i ruk una rumu. Anun a kum nat na ususer det tingi una wasiso elelar ri. ");
INSERT INTO kqw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ra i watungi tandet lena, “Mot kai, ka mot talapor utmakai? Ka mot tasmani lena a kum utna rop ra i ruk un in balan taio, ken uduri umatan o God? ");
INSERT INTO kqw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Uni ke ruk una nuknukino, i ruk pas kut un in balano ra i pirso melet.” Ra una nun a wasiso ra, i upuaso i lena, a kum utna na inangon rop i wakak. ");
INSERT INTO kqw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I watungi kai lena, “A utna ra in pirso gusun a nuknukin a taro, i ra in udur det. ");
INSERT INTO kqw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iri a kum utna ra i ser wanpat tagun a nuknukin a taro: a kum sakino nuknuk, a kum petutna na pamuk, a wolong, um doko a taro, di sal pas a ino anun taio gisen, ");
INSERT INTO kqw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a nemnem sur a susut na utna, a kum sakino petutna, a kum torotoro, a kum sakino nemnem na pinindi, a nuknuk laulau un ara, di mang laulau ara, taio ra i ulabo pasi ut, ma a kum tuptup na petutna. ");
INSERT INTO kqw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A kum sakino utna rop ri, det wanpat gusun a nuknukin a taro, ma i udur det umatan o God.” ");
INSERT INTO kqw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","O Iesu i wan tagitiro, ra i wanpat milau a tamon Tair, ma i ruk un ara rumu. Ke nemi sur taio in tasmani ra kura i, ikut ke pet lar pasi sur gong det tasmani. ");
INSERT INTO kqw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ara ino, a nutunu a inolik, a laulau na nion kura uni. I longoro a wasiso un o Iesu, uniutra i wan ra i kis butkeke nisan a kikino. ");
INSERT INTO kqw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A ino ra, a ino Ponisia tagun a papor Siria, i ausur a ino Juda. I saring o Iesu sur in lakro ru a laulau na nion gusun a nutunulik. ");
INSERT INTO kqw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ra o Iesu i watungi tano lena, “Din tabor masur mugu tar a kum nat. Ke tokodos sur din los a utna ana kum nat, ma din woro i tan a kum pap.” ");
INSERT INTO kqw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ra a ino i balu i lena, “Labino, a lingmulus ut ra. Ikut, a kum pap kai det ser wan a kum mumumut na utna nago utuntudu ina kabulu na inangon ana kum nat.” ");
INSERT INTO kqw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ra o Iesu i watungi tan a ino ra lena, “Una num a wakak na minabalu, un nan kut. A laulau na nion i sa pirso gusun a nutumlik.” ");
INSERT INTO kqw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A ino i milet melet, ra i tama a nutunu kura i inep taru una bano. A laulau na nion i sa pirso taru gusuni. ");
INSERT INTO kqw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","O Iesu i wan gusun a tamon Tair ma i wan sakit o Saidon sur a du tasi Galili, ra i wanpat una papor Dekapolis. ");
INSERT INTO kqw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ara taro det ben ara musano i kutkut ma i ngat torom o Iesu, ma det saringi sur in ubek aru lamano netes uni. ");
INSERT INTO kqw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","O Iesu i ben gisen pasi kut gusun a kunur na taro, ra i ubek arin kaskas na lamano una arin talngan a musano ra. I ibis taru ra i pam in karmen a musano. ");
INSERT INTO kqw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I tatado usapat una langit, i los wuwu pas, ra i watungi tano lena, “Epata!” a kukuraino lena: “Un papos!” ");
INSERT INTO kqw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Uniutra, in talngano i talapor, ma in karmene i tapalos ra i wasiso pat. ");
INSERT INTO kqw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ra o Iesu i turbat dekdek a taro sur gong det inanos taio uni. Ikut ka det longoro i, ma a wasiso uni, i wan sarara kut. ");
INSERT INTO kqw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Det ra det longoro a utna ri, det kisin doko uni, ma det watungi lena, “O Iesu i pam wakak pas a kum utna rop. I uwakak pas a kum kutkut sur det in longoro, ma a kum ngat sur det in wasiso!” ");
INSERT INTO kqw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ara bung ubalan a kum bungbung ra, a labino kunur na taro det wan pat tomo, ma kalako utna na inangon sur det in nani. O Iesu i kabo pas anun a kum nat na ususer toromi, ma i watungi tandet lena, ");
INSERT INTO kqw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A maris doko a taro ri, uni det sa kis tomo nam iau nin, a tulu bung, ma kalako utna na inangon sur det in nani. ");
INSERT INTO kqw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ra an tulu ru det sur anundet a kum tamon nama munurak, det in bengbeng nanan una kisapi, uni ara taro tagun det, det wan ut tagitiro bakbak.” ");
INSERT INTO kqw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Anun a kum nat na ususer det inanosi lena, “A nubual ri, kalako taro uni. Tagai mo lako utna na inangon sur dat in tabor det nami?” ");
INSERT INTO kqw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ra o Iesu i ting det lena, “A isin beret kura mot losi?” Det balu i lena, “A wonomawit ino mukut.” ");
INSERT INTO kqw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","O Iesu i inanos a taro rop sur det in kis. I los pas a wonomawit nin beret, i watung wakak pas uni torom o God, i tibiki ma i pitari torom anun a kum nat na ususer sur det in tabor a taro nami. Ra det pami lenutra. ");
INSERT INTO kqw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Det los pas a kabanin natnat na kiripo kai, ra i watung wakak pas uni, ma i pitari sur det in tibo a taro nami. ");
INSERT INTO kqw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A taro det wangon ma det masur. Numur det song bukus pas a wonomawit na rat nama kum utna ra det wangon kopos pas uni. ");
INSERT INTO kqw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A kum ino tomo nama kum nat liklik ma a kum musano, det rop det wangon. A niluluk ina kum musano kut, i elar nama wat na arip. Ra numur o Iesu i tulu ru det. ");
INSERT INTO kqw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I kas una pot tomo nam anun a kum nat na ususer, ma det wan sur a papor Dalmanuta. ");
INSERT INTO kqw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A kum Parisi det wanpat torom o Iesu, ma det wasiso na engaras tomo nami. Det ling sur det in lari. Ra det saringi lena, in pam tu ukinalong sur in ese i lena i tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","O Iesu i taramo a mamaut ma i rungasotuk, ra i watungi lena, “Ilai ra a taro tagun uniri, det sasaring sur tu ukinalong? A inanos mot nama lingmulus, ka din pam tu ukinalong torom mot.” ");
INSERT INTO kqw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ra i kas melet una pot, ra i wan gusun det utong un ara papor tasi. ");
INSERT INTO kqw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A kum nat na ususer det dumano i sur det in los lako beret. In tekene sot kut ra det losi tomo nam det una pot. ");
INSERT INTO kqw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ra o Iesu i utumarong det lena, “Mot in tumarong una is anun a kum Parisi, ma anun o Erod.” ");
INSERT INTO kqw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ra det wasiso tomo una kukurain a wasiso anun o Iesu, ra det lena, “I watungi lenra uni ka dat los lako beret.” ");
INSERT INTO kqw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","O Iesu i tasman anundet a wasiso ra i watungi tandet lena, “Ilai ra mot wasiso lena ka mot los lako beret? Ka mot mananos ma ka mot talapor utmakai? Pepetlai, a balamot i dekdek? ");
INSERT INTO kqw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A kum matmata mot i kis, ikut ka mot tamtama nami. Ma a kum taltalngamot i kis, ikut ka mot longoro nami. Pepetlai, ka mot nuk pas asau ra asa pam tari? ");
INSERT INTO kqw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ra a tibik a limanin beret torom a limo na arip na musano, aiso rat ra mot song bukus pasi nama utna na inangon ra di wangon kopos pas uni?” Det balu i lena, “A noino ma aru.” ");
INSERT INTO kqw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma i kai, ra a tibik a wonomawit na beret torom a wat na arip na musano, aiso rat ra mot ubukus pasi nama utna ra di wangon kopos pas uni?” Ra det balu i lena, “A wonomawit.” ");
INSERT INTO kqw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ra i ting det lena, “Ka mot talapor utmakai?” ");
INSERT INTO kqw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","O Iesu tomo nam anun a kum nat na ususer det wanpat tong o Betsaida, ra ara taro det ben pat ara pulu toromi, ma det saringi sur in ubek a lamano uni sur in tamtama. ");
INSERT INTO kqw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I pam a laman a pulu, ra i ben gisen pasi gusun a tamon, i ibis tar arin matan a pulu, ma i ubek aru lamano uni, ra i tingi lena, “U sa tama tu utna?” ");
INSERT INTO kqw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A musano ra i tamtama tokodos, ra i lena, “A tama a taro det elar kut nama kum duwai ra det wan nanan.” ");
INSERT INTO kqw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","O Iesu i ubek melet aru lamano una arin matan a pulu, ra arin matano der talapor wakak maragom, ra i tama a kum utna rop. ");
INSERT INTO kqw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","O Iesu i tulu ru a musano ra, ma i watungi tano lena, “Un nan tokodos sur anum a rumu. Gong u wan ubalan a tamon.” ");
INSERT INTO kqw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","O Iesu tomo nam anun a kum nat na ususer det wan sur a kum tamon milau o Sisaria Pilipai. Ra det wan nanan, i ting det lena, “A taro det watung iau nam osi?” ");
INSERT INTO kqw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Det balu i lena, “Ara taro det watung ui o Jon a Tene Baptaiso. Ara taro det watung ui o Elaija, ma ara taro kai det watung ui, ara tagun a kum poropet.” ");
INSERT INTO kqw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ra i ting det lena, “Ma mot, mot watung iau nam osi?” Ra o Pita i balu i lena, “Ui a Karisito.” ");
INSERT INTO kqw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ra i turbat det lena gong det inanos tar taio uni.” ");
INSERT INTO kqw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","O Iesu i tur pasi sur in towo anun a kum nat na ususer lena, “A Nutun a Musano in taramo a susut na mamaut. A kum mugumugu, a kum lamlabino tene etabor torom o God, ma a kum tene ususer tagun a Warkurai det in rosumur gusuni ma din um doko i. Ra a tulu bung in rop, in laun pat melet.” ");
INSERT INTO kqw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A wasiso ri anun o Iesu i talapor kut. Ra o Pita i ben gisen pasi ma i turbat dekdeki. ");
INSERT INTO kqw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","O Iesu i tupukus, ma i tamtama torom anun a kum nat na ususer, ra i wasiso dekdek torom o Pita lena, “Satan, un nan unago numur tang! Uni u muri kut a nuknukin a taro, ma ko mur a nuknukin o God.” ");
INSERT INTO kqw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","O Iesu i kabo pas a kunur na taro tomo nam anun a kum nat na ususer toromi, ma i watungi tandet lena, “Osi ra i nemi sur in mur iau, gong i mur a nuknukino. In los pas anun in nanai kutus ma in mur iau. ");
INSERT INTO kqw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Osi ra i maris bat anun a nilaun, in iru, ikut osi ra i nuk pas iau ma a Wakak na Wasiso, ma ke maris bat anun a nilaun, in laun. ");
INSERT INTO kqw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Osi ra i utur ukai a kum ututna rop taginin una rakrakon bual, ma a niono in iru, in wakak pepetlai toromi? ");
INSERT INTO kqw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","In kul keles a niono nam asau? ");
INSERT INTO kqw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A taro tagun uniri, anundet a nilaun i bakbak gusun o God, ma det a kum tene pam sakino. Osi ra in maimai un iau ma una nung a kum wasiso epotor tan a taro ri, a Nutun a Musano kai in maimai uni, ra in nanpat tomo nam anun a kum ensel ma a minamar anun o Tamano.” ");
INSERT INTO kqw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma i watungi tandet lena, “A inanos mot nama lingmulus, lako taro tagun mot ri mot tur nin, ka mot in mat utmakai, ra mot in tama a matanitu anun o God ra in nanpat nama dekdek.” ");
INSERT INTO kqw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Numur tan a wonom na bung, o Iesu i ben pas o Pita, o Jems ma o Jon, ra i ben gisen pas detul usapat una tangai ra i tur toto bing. Tiro iai detul tama a pinin o Iesu i wanpat senene. ");
INSERT INTO kqw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Anun a kum malu i kabang doko ma i pilpil, ra kataio taginin upiso in gos talapor pas tin namalu lenra. ");
INSERT INTO kqw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma a tulu nat na ususer detul tama pas o Elaija der nam o Moses der wanpat, ra detul wasiso tomo nam o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","A tulu nat na ususer detul ngara doko, ma o Pita ke tasman asau ra in watungi. Ra i watungi mukut tan o Iesu lena, “Tene Ususer, i wakak ra dat in kis nin. Metul in pam lako tulu turturup, ara anumi, ara anun o Moses, ma ara anun o Elaija.” ");
INSERT INTO kqw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ra a du bakut i pulus bat pas det. Ma in nalngan ara tagisapat una bakut i watungi lena, “Iri a Nutunglik, a nat na wakak. Mot in longoro i.” ");
INSERT INTO kqw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Uniutra, detul tamtama tuptupukus, ikut ka detul tama melet mo taio, o Iesu sot mukut kura i tur tomo nam detul. ");
INSERT INTO kqw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ra det wan pirso nanan tagisapat una tangai, o Iesu i turbat tar detul sur gong detul inanos tar taio un asau ra detul sa tama tari, tuk una bung ra a Nutun a Musano in katutur gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Detul mur a wasiso ra, ma ka detul inanos taio nami, ikut detul ting etalai detul lena, “Asau a kukurai na katutur gusun a minat?” ");
INSERT INTO kqw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ra detul ting o Iesu lena, “Sur asau ra a kum tene ususer tagun a Warkurai det watungi lena, o Elaija in nanpat mugu?” ");
INSERT INTO kqw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I balu detul lena, “A lingmulus ut, o Elaija in nanpat mugu ma in ukodos melet a kum utna rop. Ma ilai ra di sa tumus tari una Buk Tabu lena, a Nutun a Musano in taramo a susut na ngunungut ma din ipul ru i? ");
INSERT INTO kqw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ikut uniri a watungi torom motul lena, o Elaija i sa wanpat taru, ma det pam a kum sakino petutna uni, elar ut nam anundet a nemnem. A kum utna ri un o Elaija, i elar nama wasiso ra di sa tumus tari una Buk Tabu.” ");
INSERT INTO kqw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","O Iesu tomo nama tulu nat na ususer det wanpat nisan a kum nat na ususer. Det tama a labino kunur na taro kura det tur talilis pas a kum nat na ususer, ma a kum tene ususer tagun a Warkurai kura det engaras tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A taro det tama pas o Iesu, ra det kisin doko, ma det kalabor ra det gas pasi. ");
INSERT INTO kqw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ra o Iesu i ting det lena, “Asau ra mot engaras uni?” ");
INSERT INTO kqw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ara musano tagun a taro ra, i balu i lena, “Tene Ususer, a ben a nutunglik a nat musano torom ui, uni a laulau na nion kura uni ma ke wasiso. ");
INSERT INTO kqw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A laulau na nion ri i ser umi, i ser woro puku i utiro upiso. A wano i ser busu ma i ser ungingit a kabo lokono ma i ser udekdek a pinpinino. A saring anum a kum nat na ususer sur det in lakro ru a laulau na nion gusuni, ikut ka det pet lar pasi.” ");
INSERT INTO kqw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","O Iesu i balu i lena, “Mot a taro tagun uniri, ka mot nurnur! A sa kis suano i tomo nam mot. Nangisin mo mot in nurnur? Mot in ben a nat ra urin torom iau.” ");
INSERT INTO kqw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Det beni torom o Iesu. Ra a laulau na nion i tama pas o Iesu, uniutra i woro pirso tar a natlik. Ra a natlik i puku piso, i tubulus tuptupukus, ma i busubusu a wano. ");
INSERT INTO kqw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ra o Iesu i ting a taman a nat lena, “Nangisin ra i turpasi?” Ma i balu i lena, “Ra i natlik utmakai. ");
INSERT INTO kqw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A susut na bung, a laulau na nion i ser woro tari una sungun, o una danim sur in um doko i. Ra un pet lari sur un lakro ru a laulau na nion gusuni, un maris mir, ma un warut mir.” ");
INSERT INTO kqw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","O Iesu i len tano, “Ilai ra u watung lenri, ‘Ra un pet lari’? Osi ra i nurnur, in pet lar pas a kum utna rop.” ");
INSERT INTO kqw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Uniutra a taman a natlik i balu i lena, “A nurnur! Warut iau una nung a lik nurnur.” ");
INSERT INTO kqw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","O Iesu i tama a kunur na taro ra det kalabor tomo torom det, ra i wasiso dekdek torom a laulau na nion lena, “Ui a laulau na nion, u ngat ma u kutkut. A sak bat ui, un pirso gusun a natlik, ma gong melet mo u sisiop uni.” ");
INSERT INTO kqw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A laulau na nion i woiwoi pas, i gunu dekdek tar a natlik, ra i pirso gusuni. A natlik ra, i tamtama mukut elar nama minat, ma a susut na taro det lena i sa mat. ");
INSERT INTO kqw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ikut, o Iesu i pam pas a laman a natlik, ra i dat ukatutur pasi, ma i tur. ");
INSERT INTO kqw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Numur det ruk un ara rumu, ra anun a kum nat na ususer det ting eno i lena, “Ilai ra ka met lakro lar pas a laulau na nion gusuni?” ");
INSERT INTO kqw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O Iesu i balu det lena, “A ngas na laulau na nion lenri, in pirso kut una niaring.” ");
INSERT INTO kqw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Det wan tagitiro iai, ma det wan sakit potor una papor Galili. O Iesu ke nemi sur taio in tasman a nubual ra det in kis iai, ");
INSERT INTO kqw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","uni i nemi sur in ususer anun a kum nat na ususer. Ra i watungi tandet lena, “Din pitar a Nutun a Musano ulaman a taro ma det in um doko i. Numur tan a tulu bung, in laun melet.” ");
INSERT INTO kqw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka det talapor una kukurai na wasiso ri, ma det ngara sur det in tingi. ");
INSERT INTO kqw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Det wanpat tong o Kapernaum. Ra det ruk una rumu, o Iesu i ting det lena, “Asau ra mot engaras uni ra mot wan nanan una kisapi?” ");
INSERT INTO kqw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ikut ka det balu i, uni det engaras sur osi ra i labo sakit tandet. ");
INSERT INTO kqw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","O Iesu i kis ra i kabo pas anun a noino ma aru nat na ususer, ra i watungi tandet lena, “Ra taio i nemi sur in labo sakit, i wakak sur in unatino pasi kut, ma in tultul kut anun a taro rop.” ");
INSERT INTO kqw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ra i los pas ara natlik, ma i utur tari epotor tandet. Numur i romo pasi, ma i watungi tandet lena, ");
INSERT INTO kqw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Osi ra in gas pas tu natlik lenri una risang, i gas pas iau ut. Ma osi ra in gas pas iau, ausur i gas pas iau kut, i gas pas o naro ut ra i tulu ru iau urin.” ");
INSERT INTO kqw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","O Jon i watungi tan o Iesu lena, “Tene Ususer, met tama ara musano i lakro ru a kum laulau na nion nama risam, ra met turbati, uni i ausur tagun dat.” ");
INSERT INTO kqw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","O Iesu i balu i lena, “Gong mot turbati. Ra taio in pam tu utna na ukisin nama risang, ken watung lakit tu sakino wasiso un iau. ");
INSERT INTO kqw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uni osi ra ke turbat dat, i warut dat kut. ");
INSERT INTO kqw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A inanos mot nama lingmulus, osi ra in tabor mot nam lakalik danim uni mot anun o Karisito, in losi ut anun a ikul. ");
INSERT INTO kqw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Osi ra in ben raro ara tagun a kum nat liklik ri, ra det nurnur un iau, a warkurai toromi in laulau doko tan taio ra din kubus tar tu labino wat un in kabarano, ma din woro murungi usa utasi. ");
INSERT INTO kqw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ra a lamam i ben raro ui, kutus ru i. In wakak ra un ruk una nilaun tukum a tumul kut ui, sur gong di woro ui tomo nama ru lamam rop una labino sungun ra ke ser mat. ");
INSERT INTO kqw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ra a kikim i ben raro ui, kutus ru i. In wakak ra un ruk una nilaun tukum a tumul kut ui, sur gong di woro ui tomo nama ru kikim rop una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ra in matam i ben raro ui, liok ru i. In wakak ra un ruk una matanitu anun o God nam in teken matam kut, sur gong di woro ui tomo nam arin matam rop una labino sungun. ");
INSERT INTO kqw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tiro iai ‘a kum suisui liklik ka det ser mat, ma a sungun kai ke ser mat.’ ");
INSERT INTO kqw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Din umatok a taro rop nama sungun elar nama sol i umatok a etabor ra di pitari torom o God. ");
INSERT INTO kqw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A sol i wakak, ikut ra a makasman ino i sa rop, mot in umakasman meleti mo pepetlai? Ken elar! I wakak sur a sol in kis un mot, ma mot in kis na emarom tomo.” ");
INSERT INTO kqw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","O Iesu i wan tagitiro utong una papor Judia, un ara papor danim Jodan. A kunur na taro det wan melet toromi, ra i ususer melet det elar nama ngasino anunu. ");
INSERT INTO kqw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A ramano kum Parisi det wan toromi sur det in lari. Det tingi lena, “I tokodos ut elar nam anundat a kum Warkurai sur a musano in lakro ru anun a ino, o awu?” ");
INSERT INTO kqw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ra o Iesu i balu det lena, “Asi na warkurai ra o Moses i pitar tari tamot?” ");
INSERT INTO kqw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma det balu i lena, “O Moses i mulaot tari kut sur a musano in tumus a dono buk na kutus nolin, sur din palos ru a kinkinis na nolin.” ");
INSERT INTO kqw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","O Iesu i watungi tandet lena, “O Moses i tumus a warkurai ra sur mot, uni a balamot i dekdek doko. ");
INSERT INTO kqw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ikut una turturkibin a ukukis, O God ‘i ukis a taro, sur det in musano ma det in ino’. ");
INSERT INTO kqw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Iri a kibino ra a musano in nan gusun o tamano ma o nano, ma in kis tomo nam anun a ino, ");
INSERT INTO kqw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sur der in takai mukut.’ Ra ausur mo der aru, der takai mukut. ");
INSERT INTO kqw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Asau ra o God i sa kubus tomo tari, gong melet mo taio i kutusi.” ");
INSERT INTO kqw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ra det kis sa urumu, a kum nat na ususer det ting melet o Iesu una wasiso ri. ");
INSERT INTO kqw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma i watungi tandet lena, “Osi ra in lakro ru anun a ino, ma in nolin melet nam tu ino, a musano ra i pam a sakino torom anun a mugano ino. ");
INSERT INTO kqw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ra tu ino in nan gusun anun a musano, ma in nolin melet nam tu taio, a ino ra, i kai i pam a sakino.” ");
INSERT INTO kqw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A taro det ben a kum nat liklik torom o Iesu sur in ubek aru lamano netes un det. Ikut a kum nat na ususer det turbat det. ");
INSERT INTO kqw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","O Iesu i tama i, i kankan ra i watungi tandet lena, “Mot in madek ru a kum nat liklik sur det in nan torom iau. Gong mot turbat det, uni a matanitu anun o God anundet ra det lenri. ");
INSERT INTO kqw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A inanos mot nama lingmulus, ra taio ken ruk una matanitu anun o God elar nama natlik, ken ruk lar pas uni.” ");
INSERT INTO kqw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ra i romo pas a kum nat liklik, ma i ubek aru lamano netes un det, ma i wasiso udan det. ");
INSERT INTO kqw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ra o Iesu i wan nanan melet, ara musano i kalabor pat toromi, i kis butkeke umatano, ma i tingi lena, “Wakak na Tene Ususer, asau ra an pami sur an rakon a nilaun tukum?” ");
INSERT INTO kqw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","O Iesu i balu i lena, “Sur asau ra u watung iau lena a wakak? Katutaio i wakak, o God sot kut. ");
INSERT INTO kqw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U tasman a kum Warkurai: ‘Gong u um doko taio, gong u pam a sakino un tu ino anun taio, gong u wolong, gong u etakun torotoro, gong u toro pas tu utna anun taio ma u los pasi, un ru o tamam ma o nam.’” ");
INSERT INTO kqw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A musano ra i balu i lena, “Tene Ususer, tur pasi ra a natlik utmakai tuk uniri, a ser mur a kum Warkurai rop ri.” ");
INSERT INTO kqw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","O Iesu i tamtama toromi, i marisi ra i len tano lena, “Ara utna mukut ra kabaut u pami. Un nan ma un siuru ru anum a kum utna rop, ra a mani taguni, un tabor a kum sibo na taro nami. Ra un pami lenra, anum a wakak na ululeng kusapat una langit. Numur un nan urin ma un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","I longoro a wasiso ri, ra i tamtama tumtumul, ra i wan ma ikut ke gasgas, uni i labo doko anun a ululeng. ");
INSERT INTO kqw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","O Iesu i ger tuptupukus torom anun a kum nat na ususer ra i watungi tandet lena, “I ngangitin doko torom a kum tene gongon sur det in ruk una matanitu anun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A kum nat na ususer det kisin doko una wasiso ri. O Iesu i watung meleti tandet lena, “A kum nutnutung liklik, in ngangitin doko torom a taro sur det in ruk una matanitu anun o God. ");
INSERT INTO kqw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","In ngangitin sur a kamel in ruk una mato na sur na susuk, ikut, i ngangitin doko, sur a tene gongon in ruk una matanitu anun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A kum nat na ususer det kisin doko, ra det ting etalai det lena, “Ra i lenra, osi mo ra din ulauni?” ");
INSERT INTO kqw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O Iesu i tamtama torom det ra i watungi lena, “A taro ka det in pet lar pasi, ikut o God sot kut in pet lar pas a kum utna rop.” ");
INSERT INTO kqw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","O Pita i watungi tan o Iesu lena, “Tama i, met sa wan gusun anumet a kum utna rop, ra met mur ui.” ");
INSERT INTO kqw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O Iesu i watungi lena, “A inanos mot nama lingmulus: Ra taio in nan gusun anun a rumu, o gusun a kum tistisino a kum musano ma a kum ino, o gusun o nano, o gusun o tamano, o gusun a kum nutnutunu o gusun anun a piso, kibino un iau ma a Wakak na Wasiso, ");
INSERT INTO kqw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","una nilaun ri, din pitar ara ra mar tagun a kum ututna ri tano: a kum rumu, a kum tistisino a kum musano ma a kum ino, a kum nanano, a kum nutnutunu ma a piso, ma a kum ngunungut utkai. Ma una nilaun numur din tabori nama nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ikut a susut ra det mugu uniri, numur det in mur, ma det ra det mur uniri, numur det in mugu.” ");
INSERT INTO kqw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","O Iesu tomo nam anun a kum nat na ususer det wan nanan usapat o Jerusalem. O Iesu i mugu nanan tandet, ra a kum nat na ususer det nuknuk doko, ma a taro kai ra det muri det ngara. O Iesu i ben gisen melet pas anun a noino ma aru nat na ususer, ra i inanos det una kum utna ra in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I watungi lena, “Tama i, iri dat wan nanan usapat o Jerusalem. Din pitar a Nutun a Musano torom a kum lamlabino tene etabor torom o God, ma a kum tene ususer tagun a Warkurai. Det in warkurai i sur in iru, ma det in pitar tari torom det ra ausur a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Det in urongon laulau uni, det in ibisi, det in taktakalo i ma det in um doko i. Ra a tulu bung in rop in laun pat melet.” ");
INSERT INTO kqw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aru nutnutun o Sebedi, o Jems ma o Jon, der wan torom o Iesu ra der inanosi lena, “Tene Ususer, mir saring ui sur un pam asau ra mir nemi tam.” ");
INSERT INTO kqw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ra i ting der lena, “Asau ra mur nemi tang?” ");
INSERT INTO kqw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Der balu i lena, “Un ukis mir una num a minamar, ma datul in warkurai tomo, ara pasamir una sot na lamam ma ara una kair.” ");
INSERT INTO kqw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O Iesu i inanos der lena, “Ka mur tasman asau ra mur sasaring suri. Pepetlai, in elar sur mur kai mur in inum una kap na mamaut ra an inum uni? Ma in elar kai sur din baptaiso mur nama baptais na maut ra din baptaiso iau nami?” ");
INSERT INTO kqw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma der balu i lena, “Mir in pet lar pasi kut.” O Iesu i watungi tander, “A kap na mamaut ra an inum uni, mur kai mur in inum uni, ma a baptais ra din baptaiso iau nami, din baptaiso mur kai nami. ");
INSERT INTO kqw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ikut a kinkinis una sot na lamang ma una kair, ausur iau, a warkurai sur an pitari. O God ut in pitari torom det ra i sa waninar tari sur det.” ");
INSERT INTO kqw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A noino nat na ususer det longoro i, ra det kankan torom o Jems ma o Jon. ");
INSERT INTO kqw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","O Iesu i kabo tomo pas det, ra i watungi lena, “Mot tasmani lena, det ra di watung det a kum tene warkurai anun a taro ra ausur a taro Juda, det kuro laulau a taro. Ma anundet a kum mugumugu kai det pitar a kum dekdek na warkurai torom anundet a taro. ");
INSERT INTO kqw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ikut torom mot ken lenra. Osi ra i nemi sur in labo tamot, in unatino pasi sur in tultul anumot. ");
INSERT INTO kqw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma osi ra i nemi sur in mugumugu anumot, in papam oros kut torom a taro rop ma ka din kuli. ");
INSERT INTO kqw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A Nutun a Musano kai, ke wanpat sur din papam toromi. I wanpat sur i ut in papam torom a taro, ma in pitar tar anun a nilaun, a ikul, sur in kul ulangolango pas a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Det wanpat tiro o Jeriko. Numur, o Iesu tomo nam anun a kum nat na ususer ma a kunur na taro det wan tagitiro. Ara musano kura i kis taru una papor ina kisapi, a musano ra a pulu, a risano o Batimaias (a kukuraino a nutun o Timaias) ma i ser saring utna. ");
INSERT INTO kqw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","I longoro i lena o Iesu a te Nasaret i wan sakit, ra i tur pas a kakabo lena, “Iesu, a Nutun o Dewid, un maris iau!” ");
INSERT INTO kqw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A susut na taro det turbati sur in kis wowowon. Ikut i kakabo dekdek makai usapat, “Nutun o Dewid, un maris iau!” ");
INSERT INTO kqw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","O Iesu i tur sikot ra i lena, “Mot kabo i urin.” Ra det kabo pas a pulu, ma det watungi tano lena, “Katutur! Un gas! O Iesu i kabo ui.” ");
INSERT INTO kqw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O Batimaias i woro pirso ru anun a saket, i katutur, ra i wan torom o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","O Iesu i tingi lena, “Asau ra u nemi sur an pami un ui?” A pulu i balu i lena, “Tene Ususer, a nemi sur an tamtama.” ");
INSERT INTO kqw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","O Iesu i watungi lena, “Un nan! Anum a nurnur i sa ulangolango pas ui.” Uniutra i tamtama, ma i mur o Iesu una kisapi. ");
INSERT INTO kqw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ra det wan milau o Jerusalem, det wanpat tiro o Betpage ma o Betani una Tangai na Oliw, o Iesu i tulu aru tagun anun a kum nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma i inanos der lena, “Mur in nan sur a tamon kura numugu tamur. Ra mur in nanpat, mur in tama a barman na dongki kura di ker ukai tari, ma kataio utmakai i kas taru uni. Mur in palos pasi ma mur in beni urin. ");
INSERT INTO kqw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ra taio in ting mur lena, ‘Ilai ra mur pami lenra?’ mur in watungi lena, ‘A Labino i nemi kut munung, ra numur in tulu melet tari urin.’” ");
INSERT INTO kqw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ra der wan, der sio pas a matok na dongki ra di ker tari nisan a matansako ina ra rumu, milau a kisapi, ra der palos pasi. ");
INSERT INTO kqw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ara taro kura det tur taru tiro iai, det ting der lena, “Ai, mur palos a dongki ra sur asau?” ");
INSERT INTO kqw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Der balu det nama wasiso ra o Iesu i sa watung tari, ra det mulaot ru i tander. ");
INSERT INTO kqw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Der ben tar a barman na dongki torom o Iesu, ma der rakon ru anunder aru saket, ma der ubek tari netes uni, ra o Iesu i kas uni. ");
INSERT INTO kqw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A susut na taro kai det rakon ru anundet a kum saket, ma det languni una kisapi. Ma ara taro kai det tau pas a kum turunu duwai sa ubual ma det ubek tari una kisapi. ");
INSERT INTO kqw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Det ra det mugu ma det ra det mur, det kukukuk lena, “Osana! Dat in watung ulabo pas o naro ra i wanpat nama risan a Labino!” ");
INSERT INTO kqw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Dat in watung ulabo pas a matanitu anun a tamandat o Dewid ra in nanpat! Osana usapat netes sakit!” ");
INSERT INTO kqw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ra o Iesu i wanpat sapat o Jerusalem, i ruk una rumu na etabor. Ra i sa tama tar a kum utna rop, i milet melet utong o Betani tomo nam anun a noino ma aru nat na ususer, uni i sa lirop. ");
INSERT INTO kqw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Una bung numur, ra det wan tagitong o Betani, o Iesu i murak. ");
INSERT INTO kqw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I tama in nanai na fig tagitiro bakbak i lubulubu wakak. I wan sur in tama i sur lako wino. Ra i wan pat tiro, ke tama lako wino, a dondono rop kut, uni ke taun fig utmakai. ");
INSERT INTO kqw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ra i watungi torom in nanai ra lena, “Turpasi uniri ma numur, kataio melet mo in nan tin niwim.” Ma anun a kum nat na ususer det longoro anun a wasiso ri. ");
INSERT INTO kqw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ra det wanpat sapat o Jerusalem, o Iesu i ruk una ara dino tagun a rumu na etabor, ma i lu ru pirso det ra det siuru, ma det kai ra det kukul tiro iai. I woro bulus ru a kum kabulu anun a kum tene keles mani ma a kum kiskis anundet ra det siuru a kum tabun. ");
INSERT INTO kqw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma ke madek tar taio sur in los a kum utna na siuru epotor una rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ra i ususer det, i watungi lena, “Di sa tumus tari una Buk Tabu lena, ‘Din watung anung a rumu nama rumu na niaring sur a kum kamkabo taro rop una rakrakon bual.’ Ikut mot sa pam pukus pasi sur in elar mukut nama ‘rumu anun a kum tene wolong.’” ");
INSERT INTO kqw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai det longoro i, ra det nuknuk sur tu kisapi sur det in um doko o Iesu uni, uni det ngarani. Det ngara uni a taro rop det kisin una a kum etowo anunu. ");
INSERT INTO kqw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ra i sa lirop, o Iesu tomo nam anun a kum nat na ususer det wan melet gusun a tamon Jerusalem. ");
INSERT INTO kqw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Una kobot raut, det milet melet usapat o Jerusalem, ra det tama in nanai na fig i sa marang, tagisapat netes tuk unago una wakakor ino. ");
INSERT INTO kqw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma o Pita i nuk pas a wasiso anun o Iesu, ra i watungi tano lena, “Tama i! Tene Ususer, in nanai na fig ra u bor tari, i sa marang rop.” ");
INSERT INTO kqw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma o Iesu i balu i lena, “Mot in nurnur un o God. ");
INSERT INTO kqw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A inanos mot nama lingmulus, ra taio in watungi tan a tangai ri lena, ‘Un taragot ma un sirok losop usa utasi,’ ma ke nuknuk larlar, i nurnur kut lena din pam a utna ra i sa watung tari, din pam soti ut. ");
INSERT INTO kqw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lenra, a inanos mot, a kum utna rop ra mot wararing suri, mot in nurnur kut lena di sa pitar tari tamot, ma din pitari ut torom mot. ");
INSERT INTO kqw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Ra mot tur ma mot wararing, ma mot nuk torom tu utna ra taio i pam sako tari un mot, mot in dumano ru i, sur a Tamamot kusapat una langit in dumano ru anumot a kum sakino petutna kai.” ");
INSERT INTO kqw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Det wanpat melet sapat o Jerusalem. Ra o Iesu i wan nanan una rumu na etabor, a kum lamlabino tene etabor torom o God, ma a kum tene ususer tagun a Warkurai, ma a kum mugumugu det wan toromi. ");
INSERT INTO kqw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ra det tingi lena, “Asi na ngas na dekdek ra u pam a kum utna ri nami? Osi ra i pitar tar a dekdek ri torom ui sur un pam a kum utna ri?” ");
INSERT INTO kqw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","O Iesu i balu det lena, “Iau kai an ting mot nam ara iting. Ra mot in balu i, an inanos mot una dekdek ra a ser pam a kum utna ri nami. ");
INSERT INTO kqw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tan osi a baptais ra o Jon i baptaiso a taro nami? Tan o God, o tan a taro kut? Mot in inanos iau.” ");
INSERT INTO kqw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ra det wasiso eno pas lena, “Ra dat in watungi lena, ‘Tan o God,’ in balu dat kut lena, ‘Sur asau ra ka mot nurnur uni?’ ");
INSERT INTO kqw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ikut ra dat in watungi lena, ‘Tan a taro,’ a taro det in kankan torom dat.” Det ngaran a taro, uni det rop det nurnur un o Jon lena i a poropet. ");
INSERT INTO kqw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma det balu o Iesu kut lena, “Ka met tasmani.” Ra o Iesu i watungi tandet lena, “Iau kai kan inanos mot una dekdek ra a ser pam a kum utna ri nami.” ");
INSERT INTO kqw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","O Iesu i ususer det nama wasiso elelar lena, “Ara musano i marut tar a kinobot na wain, ra i pam bat tari nam in noworo. Tiro ubalan a kinobot, i kil tar in nutung sur din pas ginogino a wain uni, sur a polono in nanpat. Ma i pam tar a nat na rumu lekeleke sur a tene tamtamabat. Numur i pitar tar a kinobot munung tan a ramano kum tene pinapam sur det in tamtamabati, ra i wan sur ara tamon gisen. ");
INSERT INTO kqw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ra a kalang i sa sot sur din git tomo a wino wain, i tulu ru ara tultul torom a taro na pinapam, sur lako wino tagun anun a kinobot sur anunu kai. ");
INSERT INTO kqw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A taro na pinapam ra, det pam ukai pasi ma det umi, ra det tulu oros melet ru i kut. ");
INSERT INTO kqw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ra i tulu melet ara tultul torom det, det rapus in lorino, ma det umaimai i. ");
INSERT INTO kqw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma a taman a kinobot i tulu i bulung ara tultul, det um doko i kut. Ra i tulu melet a susut, det um ara taro tagun det ma det um doko ara taro kai. ");
INSERT INTO kqw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ara sot mukut i kis toromi, a nutunu lik ut, a nat na wakak. I tulu ru i bulung torom det, uni i nuki lena det in urur uni. ");
INSERT INTO kqw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ikut a taro na pinapam ra, det wasiso tomo pas lena, ‘I ra in keles o tamano, i mo ri i wan urin. Mot iap, dat in um doko i sur anundat mo a kinobot na wain.’ ");
INSERT INTO kqw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ra det pam ukai pasi ma det um doko ru i, ra det woro pirso ru i tagun a kinobot. ");
INSERT INTO kqw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Asau mo a taman a kinobot na wain ra in pami? In nanpat ma in um doko a taro na pinapam, ma in pitar a kinobot ra torom lako taro bulung, sur det in tamtamabati. ");
INSERT INTO kqw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pepetlai, ka mot luk a wasiso ri una Buk Tabu? I watungi lena, ‘A wat ra a kum tene pam rumu det lakro ru tari, i ut ra, a wakak na wat ra i udekdek a rumu. ");
INSERT INTO kqw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A utna ri a Labino ut i sa pam tari, ma i wakak sakit una numet a tamtama.’” ");
INSERT INTO kqw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A kum mugumugu anun a taro Juda det sisio sur tu kisapi sur det in pam ukai o Iesu uni, uni det tasmani lena i watung a wasiso elelar ri un det. Ikut det ngaran a kunur na taro. Ra det wan mut gusuni. ");
INSERT INTO kqw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Det tulu a kum Parisi, ma a kum paspasan o Erod torom o Iesu, sur det in lari sur tu wasiso anunu, ra det in takuni nami. ");
INSERT INTO kqw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ra det wanpat toromi, det watungi lena, “Tene Ususer, met tasmani lena ui a tokodos na musano. Ko nuknuk bing un asau ra a taro det watungi un ui, uni a magiram i takai kut torom a taro rop, ma u ususer det una kisapi anun o God nama lingmulus. Pepetlai, i tokodos sur din pitar a takis torom a Sisa o awu? ");
INSERT INTO kqw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dat in pitari, o gong?” I tasman lele anundet a torotoro, ra i ting det, “Ilai ra mot nemi sur mot in lar iau? Tu mani urin sur an tama i.” ");
INSERT INTO kqw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ra det pitar tar a mani tano. Ma i ting det lena, “In masarin osi ri, ma a tumtumus ri uni anun osi?” Ra det balu i lena, “Anun a Sisa.” ");
INSERT INTO kqw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","O Iesu i watungi tandet lena, “Asau ra anun a Sisa, mot in pitari torom a Sisa. Ma asau ra anun o God, mot in pitari torom o God.” Ra det longoro i, det kisin doko uni. ");
INSERT INTO kqw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A kum Sadusi, ra det ser ipul kut lena katu nilaun melet gusun a minat, det wan torom o Iesu, ma det tingi lena, ");
INSERT INTO kqw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tene Ususer, o Moses i tumus tari tandat lena, ra tu musano in mat pas gusun anun a ino, ma katu nutunder, o tisinolik in ben pasi ma in nolin nami, sur in ulabo tar lako kum nat una risan o tisino ra i sa mat. ");
INSERT INTO kqw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ara kabo tisino a wonomawit na musano det. A mugano i nolin, ra i mat pas gusun anun a ino, ma katu nutunder. ");
INSERT INTO kqw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ra a murmur tano bulung i nolin nama ino ra. I bulung i mat kut gusuni, ma katu nutunder. I lenkutkai lar ara pasandetul sino. ");
INSERT INTO kqw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Det rop a wonomawit det, ra det nolin nami, ikut a ino ra, ke usus tar tu nat un det. Ra numur tandet rop a ino bulung i mat. ");
INSERT INTO kqw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Una nilaun melet gusun a minat, a ino ra, anun osi na pasandet mo? Uni a wonomawit rop, det sa nolin pas nami.” ");
INSERT INTO kqw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","O Iesu i balu det lena, “Mot raro doko, uni ka mot tasman a Buk Tabu ma a dekdekin o God kai. ");
INSERT INTO kqw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ra a taro det in laun melet gusun a minat, ka det in nolin melet mo, det in elar mukut nama kum ensel sapat una langit. ");
INSERT INTO kqw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ra mot ipul lena, a kum minat ka det in laun melet gusun a minat, pepetlai, ka mot luki utmakai a Buk anun o Moses, ra i wasiso un in nanai ra i kunabor? O God i watungi torom o Moses lena, ‘Iau a God anun o Abaram, a God anun o Aisak ma a God anun o Jekop.’ ");
INSERT INTO kqw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mot raro doko. O God ausur a God anun a kum minat, i a God anundet ra det laun.” ");
INSERT INTO kqw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ara tagun a kum tene ususer tagun a Warkurai i wanpat torom o Iesu, ma i longoro i ra i wasiso tomo nama kum Sadusi. I longoro o Iesu ra i balu wakak det, ma i tingi lena, “Asi na warkurai ra i labo sakit tandet rop?” ");
INSERT INTO kqw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","O Iesu i balu i lena, “Iri a warkurai ra i labo sakit, ‘Mot a taro Israel, mot in longoro i! A Labino anundat a God, i ara sot kut. ");
INSERT INTO kqw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mot in maris a Labino anumot a God nama balamot rop, a niomot rop, a nuknukimot rop, ma a dekdekimot rop.’ ");
INSERT INTO kqw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma a manru warkurai i lenri, ‘Un maris a pasam elar nami, ra u maris ui ut.’ Katu warkurai melet mo i labo tan aru warkurai ri.” ");
INSERT INTO kqw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A tene ususer tagun a Warkurai i watungi tan o Iesu lena, ‘A lingmulus ut, Tene Ususer! I tokodos anum a wasiso lena o God i ara sot kut, ma kataio melet mo. ");
INSERT INTO kqw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dat in maris o God nama balandat rop, a nuknukindat rop ma a dekdekindat rop, ma dat in maris a kum paspasandat elar nami ra dat maris dat ut. Ra dat in mur aru warkurai ri, i labo taun a kum etabor ma a kum etabor kai ra di tuntun det torom o God.” ");
INSERT INTO kqw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ra o Iesu i tama i ra i wasiso na mananos, i watungi tano lena, “Ko bakbak mo gusun a matanitu anun o God.” Numur kataio melet mo i wan toromi nam tu iting, uni det ngara. ");
INSERT INTO kqw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ra o Iesu i ususer det una rumu na etabor, i watungi lena, “Ilai ra a kum tene ususer tagun a Warkurai det watungi lena, a Karisito i a nutun o Dewid? ");
INSERT INTO kqw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Tokodos na Nion i mugu o Dewid ra i watungi lena, ‘A Labino i watungi torom anung a Labino, “Un kis una papor sot na lamang, tuk ra an turus pas anum a kum ebar sur det in kis utuntudu ina num a warkurai.” ’ ");
INSERT INTO kqw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","O Dewid ut i watung a Karisito lena, i anun a Labino. Ra i lenra, der tamano pepetlai?” A labino kunur na taro det gas doko ra det longoro a wasiso anun o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ra i ususer det, i watungi lena, “Mot in tumarong mot gusun a kum tene ususer tagun a Warkurai. Det nemi sur det in nan tuptupukus nama kum wakak na ememar, ma det nemi kai sur a taro det in pitar a labino urur torom det una kum nubual na inawan tomo. ");
INSERT INTO kqw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma det nem a kinkinis sa numugu una kum rumu na lotu, ma a kinkinis na labino sa numugu una kum lukaro. ");
INSERT INTO kqw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Det ser urop a kum ululeng anun a kum ula, ma det ser pam a kum walalos na niaring sur a taro det in tama det. In labo doko a warkurai na minabalu anun o God torom det.” ");
INSERT INTO kqw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","O Iesu i kis milau taru nisan a dino, ra di ser woro mani uni tiro na rumu na etabor. I tama a taro ra det woro anundet a kum mani. A susut na tene gongon kai, det woro a labino mani. ");
INSERT INTO kqw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ikut, ara sibo na ula, i woro tar aru toia kut. ");
INSERT INTO kqw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ra o Iesu i kabo pas anun a kum nat na ususer toromi, ma i watungi tandet lena, “A inanos mot nama lingmulus, a sibo na ula ri, i woro a labino mani taun det rop ra det woro anundet a kum mani. ");
INSERT INTO kqw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Det pitar tari kut a sibano tagun anundet a kum mani, ikut a sibo na ula ri, i sa pitar rop ru asau ra in topas anun a kinkinis. ");
INSERT INTO kqw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ra o Iesu i pirso gusun a rumu na etabor, ara pasan anun a kum nat na ususer i inanosi lena, “Tama i, Tene Ususer! A kum wakak na rumu ri, di pami nama kum lamlabino watat!” ");
INSERT INTO kqw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","O Iesu i balu i lena, “U tama i ut a kum lamlabino rumu ri, niko? Numur din rege ginogino det rop, ma a kum watat det in inep sarsarara.” ");
INSERT INTO kqw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","O Iesu i kis sapat netes una Tangai na Oliw una papor ra i tamtama lakai sur a rumu na etabor. O Pita, Jems, Jon ma o Endru det ting eno i lena, ");
INSERT INTO kqw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Un inanos met, nangisin a kum utna ri in nanpat? Ma asau a ukinalong ra in ese i lena milau sur det in nanpat?” ");
INSERT INTO kqw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","O Iesu i inanos det lena, “Mot in tumarong, sako taio in toro pas mot. ");
INSERT INTO kqw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A susut det in nanpat nama risang, ma det in warango det lena, ‘Iau a Karisito,’ ra det in toro lako susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ra mot in longoro a kum inaim ma a kum inarang na inaim, gong mot lai taru. A kum utna lenri det in nanpat, ikut a tintinip ina rakrakon bual kura utmakai. ");
INSERT INTO kqw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ara kabotaro in tur na inaim torom ara kabotaro, ma ara gapman in tur na inaim torom ara gapman. A kum guri ma a kum lamlabino munurak in nanpat una kum tamon. A kum utna ri i elar nama kum mugano ngunungut ra i ser wanpat una ino ra i ling na usus. ");
INSERT INTO kqw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mot in tumarong mot. A taro det in pitar mot ulaman a kum tene warkurai, ma det in um mot una kum rumu na lotu. Mot in tur una kum warkurai numugu umatan a kum lamlabino mugumugu ma a kum king, i kibino un iau. Mot in wasiso talapor un iau torom det. ");
INSERT INTO kqw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Din warawai mugu nama Wakak na Wasiso torom a kum kamkabo taro rop una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ra din dat pas mot sur a warkurai, gong mot nuknuk mugu sur asau mot in watungi. Una du bung ra, mot in watungi kut a wasiso ra di sa unuk tar mot nami. Uni ausur mot ut ra mot in wasiso, a Tokodos na Nion ut. ");
INSERT INTO kqw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Taio in mulaot ru tu tisino sur din um doko i, ma tu musano in mulaot ru tu nutunu sur din um doko i. Ma a kum nat det in tur na inaim torom a tamandet ma a nandet, ma det in mulaot ru a tamandet ma a nandet sur din um doko der. ");
INSERT INTO kqw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma a taro rop det in nget mot kibino una risang, ikut osi ra in tur dekdek tuk anun a nilaun in rop, o God in ulauni. ");
INSERT INTO kqw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mot in tama ara sakino utna sakit in nanpat, in kis una dino ra ke to pasi sur in kis iai, ma in ban udur a dino ra. Osi ra in luk a kum wasiso ri, i wakak sur in mananos uni. Una bung ra, det ra det kis una papor Judia, det in kalabor eno usapat una kum tangai. ");
INSERT INTO kqw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ra taio in kis sapat netes una nun a rumu, ra in pirso, gong i ruk sur in los pas tu utna tagisa urumu. ");
INSERT INTO kqw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ra taio in kis sa ukinobot, gong melet mo i milet utiro utamon sur anuna saket. ");
INSERT INTO kqw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Una kum bungbung ra, in laulau doko torom a kum tianan, ma torom a kum ino kai ra a kum nutnutundet, det sus utmakai. ");
INSERT INTO kqw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mot in wararing sur gong a utna ri i wanpat una kum kalang na kotokoto. ");
INSERT INTO kqw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Uni una kum bungbung ra, in labo sakit a ngunungut. In labo taun a kum ngunungut ra i ser wanpat una rakrakon bual. Turpasi ra o God i ukis a rakrakon bual tuk uniri, ma numur kai, katu ngunungut in elar nami. ");
INSERT INTO kqw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ra gunuk a Labino ken kutus pirso a kum bungbung ra, kataio ut in laun. Ikut in kutus pirso ru i sur det ra i sa pilok pas det, det in laun. ");
INSERT INTO kqw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Una kum bungbung ra, ra taio in watungi torom mot lena, ‘Tama i, a Karisito kuri i,’ o ‘Kurong i,’ gong mot nurnur. ");
INSERT INTO kqw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Uni lako kum torotoro na Karisito, ma lako kum torotoro na poropet det in nanpat. Det in pam lako kum ukinalong ma lako kum utna na ukisin sur det in toro pas a taro ra o God i sa pilok pas det, ra ut ko ra det in pet lar pasi. Ikut, ka det in pet lar pasi. ");
INSERT INTO kqw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mot in tumarong mot! A sa inanos mugu tar mot una kum utna rop ra in nanpat. ");
INSERT INTO kqw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ra i sa rop a kum mamaut ma ngunungut una kum bungbung ra, ‘in matanas in dumirum, a kalang ken talapor, ");
INSERT INTO kqw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","a kum nangnang det in puku pirso tagisapat una bakut, ma a kum utna sapat netes una bakut det in tugunugunu.’ ");
INSERT INTO kqw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Una bung ra, a taro det in tama a Nutun a Musano in nanpat una kum du bakut nama labino dekdek ma a minamar. ");
INSERT INTO kqw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma in tulu pirso anun a kum ensel sur det in ben tomo anun a taro na pipilok tagun a wat na matmatano wuwu, tagun ara papor rakrakon bual tuk tong una ara papor rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mot in ususer tagun in nanai na fig. Ra a kum kanokano in sibul pat melet, ma a dondono in tapalos, mot tasmani lena a kum kalang na mararong i sa milau. ");
INSERT INTO kqw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lenkutkai, ra mot tama a kum utna ra a wasiso taru uni in nanpat, mot in tasmani lena a du bung i sa milau. ");
INSERT INTO kqw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A inanos mot nama lingmulus, a kum utna rop ri in nanpat ra a taro tagun uniri det laun utmakai. ");
INSERT INTO kqw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A langit ma a rakrakon bual der in rop, ikut anung a kum wasiso ken rop. ");
INSERT INTO kqw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Katutaio i tasman a bung o a du bung ra a kum utna ri in nanpat. A kum ensel sapat una langit ka det tasmani, ma a Nutunu kai ke tasmani, o Tamano sot kut i tasmani. ");
INSERT INTO kqw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mot in nuknuk wakak, ma mot in tumarong mot, uni ka mot tasmani ra nangisin a kum utna ri in nanpat. ");
INSERT INTO kqw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I elar nam ara musano ra i waninar sur in nan utiro una ra tamon gisen. I pitar tar anun a rumu tan anun a kum tultul, sur det in tamtamabati. I tibo susuaro a kum pinapam tandet rop taktakai, ma i inanos tar ara musano sur in tamtamabat a matansako. ");
INSERT INTO kqw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Mot in tumarong mot, uni ka mot tasmani ra nangisin a taman a rumu in milet, una lirop, o una labino mirum, o una lar ra a kum kereke det kurkurakuk, o una kobot, ");
INSERT INTO kqw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sako in nanpat kisin, ra in nan taru un mot ra kura mot inep dumun kut. ");
INSERT INTO kqw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Asau ra a watungi tamot, a watungi kai torom a taro rop lena, mot in tumarong mot.” ");
INSERT INTO kqw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aru bung numugu tan a labino bung na lotu na Wanlakai, ma a labino bung na lotu na beret ra kalako is uni, a kum lamlabino tene etabor torom o God, ma a kum tene ususer tagun a Warkurai det nuknuk sur tu ngas na kisapi sur det in pam ukai eno pas o Iesu, ma det in um doko i. ");
INSERT INTO kqw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Det watungi lena, “Gong dat pami una labino bung na lotu, sako a taro det in kankan ma det in ukatutur tu inaim.” ");
INSERT INTO kqw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","O Iesu i kis tong o Betani, una rumu anun o Saimon, i ra numugu i misait nama lepra. Ra o Iesu i kis una inangon, ara ino i wan toromi nam in polo sangsangnain ra di watungi nama nad. A matano i ka doko, ma i kis un in nokoto, ra di pami nama wat. I sak kutus ru in kabarano koto, ra i lingisi un in lorin o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A ramano taro ra det kis tiro iai det kankan ma det wasiso etalai lena, “Sur asau ra di lingis orosi kut in polo sangsangnain ri? ");
INSERT INTO kqw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ilai ra ka di siuru pasi sur lako tulu mar na denari sur din tabor a kum sibo na taro nami?” Ma det wasiso na kankan torom a ino ra. ");
INSERT INTO kqw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ra o Iesu i watungi tandet lena, “Mot in madek ru a ino ri. Ilai ra mot pitar a maut toromi? I sa pam tar a wakak na pinapam sakit un iau. ");
INSERT INTO kqw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A kum sibo na taro det in laun bolbolos tomo ut nam mot. Ma nangisin mot nem na pam a wakakino torom det, mot in pami kut. Ikut iau, kan kis tukum nisamot. ");
INSERT INTO kqw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A ino ri i sa pam sot pas a utna ra i elar sur in pami. I sa lingis tar in polo sangsangnain ri una pining sur in waninar mugu iau sur a bung ra an mat ma din uruk a minating una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A inanos mot nama lingmulus, una kum tamtamon una rakrakon bual, ra din warawai nama Wakak na Wasiso iai, din inanos utkai un asau ra a ino ri i sa pam tari, sur a risano in tur na aim.” ");
INSERT INTO kqw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","O Judas Iskariot, ara tagun a noino ma aru nat na ususer, i wan torom a kum lamlabino tene etabor torom o God, sur in pitar tar o Iesu torom det. ");
INSERT INTO kqw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ra det longoro i, det gas, ma det uliliman tari sur det in kuli nam lako mani. Ra o Judas i nuknuk sur tu wakak na du bung ra in pitar tar o Iesu ulamandet. ");
INSERT INTO kqw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Una mugano bung una kum lamlabino bung na lotu na beret ra kalako is uni, ra di ser um doko a kum sipsip uni sur a labino bung na lotu na Wanlakai, a kum nat na ususer anun o Iesu det tingi lena, “U nemi sur met in nan urai, ma met in waninar andat a utna sur a labino bung na lotu na Wanlakai?” ");
INSERT INTO kqw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I tulu aru tagun anun a kum nat na ususer, ma i watungi tander lena, “Mur in ruk usapat o Jerusalem. Ra mur sa wanpat, mur in etorom nam ara musano i los in labino koto na danim, ra mur in muri. ");
INSERT INTO kqw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ra in ruk un tu rumu, mur in watungi tan a taman a rumu lena, ‘A Tene Ususer i watungi lena: Awai i a kukur rumu ra met nam anung a kum nat na ususer, met in nan a utna na Wanlakai iai?’ ");
INSERT INTO kqw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma in ese tar mur una labino kukur rumu sapat netes, ra di sa waninar tari. Mur in waninar andat a utna tiro iai.” ");
INSERT INTO kqw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aru nat na ususer der wanpat sapat o Jerusalem, ma der tama i ut a kum utna rop ra o Iesu i watung tari tander. Ra der waninar a utna na Wanlakai. ");
INSERT INTO kqw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ra i sa lirop, o Iesu tomo nama nuna noino ma aru nat na ususer det wanpat. ");
INSERT INTO kqw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Det wangon ra i watungi lena, “A inanos mot nama lingmulus, ara tagun mot ri dat wangon tomo, in pitar tar iau ulaman a kum ebar.” ");
INSERT INTO kqw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ra det tupunuk, det rop taktakai det tingi lena, “Ausur iau, niko?” ");
INSERT INTO kqw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ra o Iesu i balu det lena, “Ara tagun mot ut a noino ma aru, ra mir puk tomo amir aru du beret una dis. ");
INSERT INTO kqw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A Nutun a Musano in iru elar nami ra di sa tumus tari una Buk Tabu. Ikut in laulau sakit torom a musano ra in pitar tari torom a kum ebar. In wakak toromi ra ka din ususi, sur gong i taramo a dekdek na warkurai ra uni.” ");
INSERT INTO kqw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Det wangon utmakai, ra o Iesu i los pas a beret, i watung wakak pas uni, i tibiki, ma i tabor anun a kum nat na ususer nami, ra i watungi lena, “Mot in rakoni, iri a pining.” ");
INSERT INTO kqw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Numur i los pas a kap, i watung wakak pas uni, ra i pitari tandet, ma det rop det inum taguni. ");
INSERT INTO kqw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ra i watungi tandet lena, “Iri a gaping, a kunubus ra i dat tomo tar a taro nam o God. A gaping ri, i tilingis sur a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A inanos mot nama lingmulus, kan inum melet mo lako wain, tuk ra an inum a matok na wain una matanitu anun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ra det sa kelekele pas, det wan tito usapat una Tangai na Oliw. ");
INSERT INTO kqw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","O Iesu i watungi tandet lena, “Mot rop mot in nan pas kut gusun iau, uni di sa tumus tari una Buk Tabu lenri, O God i watungi lena, ‘An um a tene tamtamabat anun a kum sipsip, ra a kum sipsip det in kalabor sarara.’ ");
INSERT INTO kqw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ikut, ra a sa katutur melet gusun a minat, an mugu utong o Galili.” ");
INSERT INTO kqw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","O Pita i watungi tano lena, “Ra det rop det in nan pas gusun ui, ikut iau awu.” ");
INSERT INTO kqw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","O Iesu i watungi tano lena, “A inanos ui nama lingmulus, miri umirum, ra a kereke ken manru kurkurakuk utmakai, un ipul a tulu dino lena, ko tasman iau.” ");
INSERT INTO kqw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ra o Pita i wasiso dekdek toromi lena, “Kan ipul ru ui. Ra iau kai an iru tomo nam ui, i wakak kut.” Ma a kum nat na ususer rop kai det watungi lenutra. ");
INSERT INTO kqw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","O Iesu tomo nam anun a kum nat na ususer det wanpat una nubual a risano Getsemani, ra i watungi tandet lena, “Mot in kis kut nin, ma iau an wararing pas.” ");
INSERT INTO kqw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ra i ben pasi kut o Pita, Jems ma o Jon ra detul wan tomo nami. Una du bung ut ra, i turpas a taramo a labino tupunuk ma i maut doko a nuknukino. ");
INSERT INTO kqw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I watungi tandetul lena, “Anung a nilaun i mamaut doko nama tupunuk, milau mo an mat nami. Motul in kis kut nin, ma motul in koikoi taru ut.” ");
INSERT INTO kqw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I wan lilik taru usa numugu, i puku na urur tiro una piso, ma i wararing sur a du bung na minat in nan sakiti, raut a nemnem anun o God. ");
INSERT INTO kqw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I wararing lena, “Tita, Tita, a kum utna rop i to pas ui un pami, un los ru a kap na mamaut ri gusun iau. Ikut gong u mur anung a nemnem, un muri ut anum a nemnem.” ");
INSERT INTO kqw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I milet melet torom a tulu nat na ususer, ra i tama detul, detul sa inep dumun. I ting o Pita lena, “Saimon, pepetlai, u inep dumun kut? Kon pet lari sur un koikoi un tu du bunglik kut? ");
INSERT INTO kqw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Motul in koikoi, ma motul in wararing, sur gong motul puku una ululam. A niomotul i nem na tarom, ikut a pinimotul i tungulu kut.” ");
INSERT INTO kqw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ra i wan gusun detul, i wararing melet nama niaring ra i sa watung tari numugu. ");
INSERT INTO kqw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I milet melet, ra i tama detul, detul sa inep dumun melet, uni a matandetul i sa sunu doko. Ka detul tasman asau ra detul in balu i nami. ");
INSERT INTO kqw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ra i mantul u milet torom detul, i watungi lena, “Motul in inep liklik mukut, ma motul in mana? Gong mo! A du bung i sa sot. Tama i, di sa pitar tar a Nutun a Musano ulaman a kum tene sakino. ");
INSERT INTO kqw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Motul katutur, dat na wan! Tama i, a musano ra in pitar tar iau ulaman a kum ebar, i sa wanpat.” ");
INSERT INTO kqw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ra o Iesu i wasiso utmakai, o Judas, ara tagun a noino ma aru nat na ususer, i wanpat, det nama kunur na taro. Det los a kum totok na inaim, ma a kum nalnal. A kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai ma a kum mugumugu det tulu ru det. ");
INSERT INTO kqw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","I ra in pitar tar o Iesu ulaman a kum ebar, i sa inanos mugu tar a kunur na taro una ukinalong ra in pami lena, “I ra an gom a pangpagor na wano, i ut ra. Mot in pam ukai pasi, mot in ben gisen pasi ma mot in tamtamabat wakaki.” ");
INSERT INTO kqw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Uniutra o Judas i wan torom o Iesu ra i watungi lena, “Tene Ususer!” Ra i gom a pangpagor na wano. ");
INSERT INTO kqw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ra a taro ra, det pam ukai o Iesu ma det dat pasi. ");
INSERT INTO kqw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ara tagun det ra det tur milau, i dat pas anun in totok na inaim, ra i tau kutus ru in talngan a tultul anun a mugumugu na tene etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ra o Iesu i watungi tandet lena, “Pepetlai, kutiro iau a tene inaim ma a tene wolong, sur i mo ri mot wanpat nama kum totok na inaim, ma kum nalnal sur mot in pam ukai iau? ");
INSERT INTO kqw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Una kum bungbung rop dat ser kis tomo una rumu na etabor, a ser ususer a taro, ma ka mot pam ukai iau. Ikut di pami lenri sur din pam sot pas a wasiso na Buk Tabu.” ");
INSERT INTO kqw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Numur a taro na ususer rop anun o Iesu det kalabor sarara pas gusuni. ");
INSERT INTO kqw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma ara barman ra i ser mur o Iesu, i rakup pasi kut nam in namalu. Det pam ukai pasi, ");
INSERT INTO kqw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ra i kabalor gusun anun in namalu, ma i mengere mukut. ");
INSERT INTO kqw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Det ben pas o Iesu torom a mugumugu na tene etabor torom o God. Ma a kum lamlabino tene etabor rop torom o God, a kum mugumugu, ma a kum tene ususer tagun a Warkurai det wanpat tomo tiro iai. ");
INSERT INTO kqw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","O Pita i mur nanan o Iesu, ikut i bakbak ut gusuni. I ruk una nubual anun a mugumugu na tene etabor torom o God, ra i minor nisan a sungun tomo nama kum tene tamtamabat. ");
INSERT INTO kqw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A kum lamlabino tene etabor torom o God, tomo nama taro na kiwung rop det sisio sur tu sakino utna ra o Iesu i sa pam tari, sur det in takuni nami, ma det in um doko i uni, ikut ka det sio lar pas tu utna. ");
INSERT INTO kqw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A susut det watung a kum torotoro na wasiso un o Iesu, ikut anundet a kum wasiso ke takai. ");
INSERT INTO kqw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A ramano taro det tur ma det watung a kum torotoro na wasiso uni lena, ");
INSERT INTO kqw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Met longoro i, i watungi lena, ‘An rege ru a rumu na etabor ri, ra a taro det pam tari, ma una tulu bung kut, an pam pas taio ra ausur a taro det pami.’” ");
INSERT INTO kqw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ikut anundet a kum wasiso kai ke takai. ");
INSERT INTO kqw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A mugumugu na tene etabor torom o God i tur taru numugu tandet ra i ting o Iesu lena, “Pepetlai, kon balu det? Asau ra un balu a kum wasiso na etakun ri nami?” ");
INSERT INTO kqw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ikut o Iesu ke wasiso. A tene etabor ra, i ting meleti lena, “Ui a Karisito, a Nutun o God ra i dan tukum, o awu?” ");
INSERT INTO kqw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ra o Iesu i watungi lena, “Iau ut ra. Ra numur mot in tama a Nutun a Musano in kis una papor sot na laman o God, i ra i dekdek sakit, ma mot in tama i ra in nanpat una kum du bakut tagisapat una langit.” ");
INSERT INTO kqw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A mugumugu na tene etabor i kankan ra i raros anun in namalu ut ma i iting lena, “Dat nem melet lako wasiso na etakun sur asau? ");
INSERT INTO kqw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uniri mot sa longoro tar anun a kum wasiso laulau un o God. Asau mot nuki?” Ra det rop det mulaot sur o Iesu in iru. ");
INSERT INTO kqw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ara taro, det turpas a ibis o Iesu, det pulus bat arin matano, det tubuli ma det watungi tano lena, “Ui a poropet, un inanos met, osi ra i tubul ui!” Ra a kum tene tamtamabat det ben pasi ma det umi. ");
INSERT INTO kqw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ra o Pita i kis utmakai nago upiso una rumu ra, ara ino, a tultul anun a mugumugu na tene etabor torom o God i wanpat. ");
INSERT INTO kqw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ra i tama o Pita kura i minor, i nas dekdeki ra i lena, “Ui kai u ser wan tomo nam o Iesu a te Nasaret.” ");
INSERT INTO kqw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ikut, i ipul lena, “Ka tasman asau ra u wasiso uni, ma ka talapor uni.” I wan utong nisan a matansako ina in noworo, ra a kereke i kurkurakuk mut. ");
INSERT INTO kqw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A ino i tama melet pasi, ra i inanos det ra det tur tiro iai lena, “A musano ri, i kai ara ut tagun det ri.” ");
INSERT INTO kqw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","O Pita i ipul melet. Numur lilik tano, det ra det tur milau torom o Pita, det watungi tano lena, “A lingmulus ut ra ui kai ara tagun det, uni ui a te Galili.” ");
INSERT INTO kqw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ra i liliman torom det, i watungi lena, “O God in warkurai laulau iau ra an toro. Ka tasman a musano ra mot wasiso uni.” ");
INSERT INTO kqw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ra uniutra a kereke i manru kurkurakuk mut. O Pita i nuk pas a wasiso ra o Iesu i sa watung tari tano lena, “Ra a kereke ken manru kurkurakuk utmakai, un ipul a tulu dino lena ko tasman iau.” Ra i tangis sakit pas mut. ");
INSERT INTO kqw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Una kobot raut, a kum lamlabino tene etabor torom o God, a kum mugumugu, ma a kum tene ususer tagun a Warkurai ma a taro na kiwung rop, det kubus wasiso pas. Det ker aru laman o Iesu, ma det beni, ra det pitar tari torom o Pailat. ");
INSERT INTO kqw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","O Pailat i tingi lena, “Ui a king anun a taro Juda?” Ra o Iesu i balu i lena, “I ut ra u sa watungi.” ");
INSERT INTO kqw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A kum lamlabino tene etabor torom o God det takun o Iesu una susut na utna. ");
INSERT INTO kqw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","O Pailat i ting melet o Iesu lena, “Ilai, katu minabalu anumi? Tama i, a susut na utna ri det takun ui nami.” ");
INSERT INTO kqw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ikut, o Iesu ke balu i nam tu wasiso, ra o Pailat i kisin doko uni. ");
INSERT INTO kqw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Una kum kilkilalo rop una kum lamlabino bung na lotu na Wanlakai, o Pailat i ser palos ru ara karabus ra a taro det sasaring suri. ");
INSERT INTO kqw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Una kilalo ra, ara musano a risano o Barabas i kis una karabus. I ara tagun det ra det waim nama gapman. Det ukatutur a inaim, ra det um doko ara taro. ");
INSERT INTO kqw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ra a kunur na taro det wanpat torom o Pailat, ma det saringi sur in palos melet ru tu karabus. ");
INSERT INTO kqw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ra o Pailat i ting det lena, “Mot nemi sur an palos ru a ‘king anun a taro Juda’ torom mot?” ");
INSERT INTO kqw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I watungi lenri uni i sa tasmani lena, a kum lamlabino tene etabor torom o God det pitar tar o Iesu toromi una sakino nuknukindet. ");
INSERT INTO kqw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ikut a kum lamlabino tene etabor torom o God det ukatutur a balan a kunur na taro sur det in saring o Pailat, sur in palos ru o Barabas torom det. ");
INSERT INTO kqw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","O Pailat i ting det lena, “Asau ra an pami un o naro ra mot watungi nama king anun a taro Juda?” ");
INSERT INTO kqw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ra det kukukuk kut lena, “Sak wati un in nanai kutus!” ");
INSERT INTO kqw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","O Pailat i ting det lena, “Sur asau? Asi na sakino utna ra i sa pam tari?” Ikut det kukukuk dekdek lena, “Sak wati un in nanai kutus!” ");
INSERT INTO kqw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","O Pailat i nemi sur in ugasgas a taro, ra, i palos ru o Barabas torom det. Ra di sa takalo tatar o Iesu, o Pailat i pitar tari tan a kum tene inaim sur det in sak wati un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A kum tene inaim det dat pas o Iesu utiro urumu una labino rumu anun anundet a mugumugu, ra det kabo tomo pas a kum tene inaim rop. ");
INSERT INTO kqw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Det mar tari nam in merek na malu, det liko pas in narus a loklokono, ma det ubek tari un in lorino elar nama kukup anun a king. ");
INSERT INTO kqw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Det kakabo toromi lena, “Ui a king anun a taro Juda!” ");
INSERT INTO kqw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Det raprapus in lorino nam in nubuku, det ibisi, det kis butkeke nisano, ma det urur toromi. ");
INSERT INTO kqw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ra det sa urongon laulau papas uni, det palos ru in merek na malu gusuni. Det mar tari melet nama nun a kum malu, ma det ben pirso i sur din sak wati un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tiro una kisapi a kum tene inaim det etorom pas ara te Sairini, a risan o Saimon, a taman o Aleksanda mo Rupus, i wan gusun ara tamon sur in nan usapat o Jerusalem. Det ungongos tari sur in los in nanai kutus anun o Iesu. ");
INSERT INTO kqw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Det ben o Iesu sur a nubual di watungi nam o Golgota, a kukuraino a “Nubual na Lor na Minat.” ");
INSERT INTO kqw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Det pitar tar a wain tano ra di sa pam tomo tari nama mira, ikut ke nemi sur in inumi. ");
INSERT INTO kqw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Det sak wat tari un in nanai kutus, ra det pilai laki sur anun a kum malu sur osi tagun det in los tin namalu. ");
INSERT INTO kqw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ra i lisu na pakano bung una kobot, det sak wati un in nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Det tumus tar a wasiso na etakun uni, netes un in nanai kutus lena, ");
INSERT INTO kqw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Det sak wati kai, aru tene wolong tomo nami una arin nanai kutus, ara una papor sot, ma ara una kair. ");
INSERT INTO kqw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Det ra det wanan sakit o Iesu, det watung laulau i ma det lele lorindet toromi. Ma det watungi lena, “Ui mo ra u watungi lena un rege ru a rumu na etabor, ma un pam melet pasi una tulu bung kut, ");
INSERT INTO kqw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","uniri un ulaun pas ui mo, ma un pirso gusun in nanai kutus.” ");
INSERT INTO kqw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","A kum lamlabino tene etabor torom o God ma a kum tene ususer tagun a Warkurai det kai det urongon laulau un o Iesu, det wasiso etalai torom det lena, “I ulaun pas a taro gisen, ikut ken ulaun lar pasi ut. ");
INSERT INTO kqw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ra i a Karisito, a King anun a taro Israel, uniutri in pirso gusun in nanai kutus, sur dat in tama i, ma dat in nurnur uni.” Ma der ra der kete tomo nami, der kai, der watung laulau i. ");
INSERT INTO kqw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ra i noino ma ru pakano bung una suan, a bual rop i dumirum tuk una tulu pakano bung una lirop. ");
INSERT INTO kqw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ra i tulu pakano bung, o Iesu i kukukuk dekdek lena, “Eloi, Eloi, lema sabakatani?” A kukuraina wasiso ra i lenri, “Anung a God, anung a God, ilai ra u wan gusun iau?” ");
INSERT INTO kqw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ara taro tagun det ra det tur milau, det longoro i, ra det watungi lena, “Tama i, i kakabo sur o Elaija.” ");
INSERT INTO kqw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ara tagun det i kalabor ra i los pas ara utna ra i ser dop a polo. I puk pasi una wain ra i mititir, i ubek pasi un in nanai ra i tulsu toto i usapat sur o Iesu in inumi. Ma i inanos det lena, “Te, dat in madek tari munung. Dat in tama i ra o Elaija in nan pirso sur in los pirso pasi, o awu.” ");
INSERT INTO kqw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","O Iesu i kukuk dekdek pas, ra i ubek ru anun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ra in namalu na minabat kutus sa urumu una rumu na etabor i tararos potor, turpasi tagisapat netes tuk unago piso. ");
INSERT INTO kqw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A mugumugu anun a kum tene inaim ra i tur taru nisan in nanai kutus, i longoro o Iesu ra i kakabo ma i tama a ngas na minat ra i pami, i watungi lena, “I lingmulus ut, a musano ri a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A ramano wardain kai det tur bakbak taru ut ma det tama a kum utna ri. Kura epotor tandet rop, a tulu ino kai ri, o Maria Magdalen, ma o Salomi ma o Maria kai a nan o Joses ma o Jems ra a barman. ");
INSERT INTO kqw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Detul ri, detul ser murmur o Iesu ra i kis sa o Galili, ma detul ser waruti. Ma a susut na wardain, ra det wan tomo nami usapat o Jerusalem, kura det kai iai. ");
INSERT INTO kqw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ara musano tagitiro o Arimatia, a risano o Josep. I ara tagun a taro na kiwung, a labino musano ra a taro det ser ru i, ma i ser kis langlang sur a matanitu anun o God. Ra i sa lirop una bung na waninar, a bung numugu tan a Bung na Sabat, i wan torom o Pailat, ke ngara, ra i saring pas a minatin o Iesu tano. ");
INSERT INTO kqw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ra o Pailat i kisin ra i longoro i lena o Iesu i sa mat. I kabo pas a mugumugu anun a kum tene inaim, ra i tingi lena, “Pepetlai, o Iesu i sa mat?” ");
INSERT INTO kqw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ra i sa mananos pas tan a mugumugu ri, i mulaot ru a minatin o Iesu torom o Josep. ");
INSERT INTO kqw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ra o Josep i kul pas in wakak na malu, i los pirso pas a minatin o Iesu, ra i pulus pasi nam in namalu ra. Numur i uinep tari una kulam na minat ra di sa kil tari una papor wat, ra i bulus bat tar a matansako na kulam ra nama labino wat. ");
INSERT INTO kqw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","O Maria Magdalen ma o Maria, o nan o Joses, der tama tar a nubual ra di uinep o Iesu uni. ");
INSERT INTO kqw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ra a Bung na Sabat i sa rop, o Maria Magdalen, ma o Salomi ma o Maria a nan o Jems, detul kul pas a kum utna ra i sangsangnain sur detul in mar a minatin o Iesu nami. ");
INSERT INTO kqw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ra in nusuan i wanpat una kobot raut una mugano bung una wik, detul wan sur a kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ra detul wan nanan, detul ting etalai detul, “Osi mo in warut datul sur in bulus gisen ru a wat gusun a matansako na kulam na minat?” ");
INSERT INTO kqw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ikut ra detul tamtama tokodos usa, detul tama i ra di sa bulus gisen ru tar a labino wat ra. ");
INSERT INTO kqw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ra detul ruk una kulam, detul tama ara barman, i kis taru una papor sot na lamandetul, i emar pas nam in kabang na malu. Ra detul tama pasi, detul kisin ma detul ngara. ");
INSERT INTO kqw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A musano ra i watungi lena, “Gong motul ngara. A tasmani lena, motul sisio sur o Iesu a te Nasaret, i ra di sak wat tari un in nanai kutus. I sa katutur melet, ma ke kis mo nin. Motul in tama a nubual ra di uinep tari uni. ");
INSERT INTO kqw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Motul nan, ma motul in inanos anun a kum nat na ususer ma o Pita kai lena, ‘O Iesu in mugu utong o Galili. Mot in tama i tong, elar nami ra i sa inanos mugu tar mot.’” ");
INSERT INTO kqw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Detul kisin ma detul neneder, ra detul kalabor gusun a kulam na minat. Ma ka detul inanos taio nam tu wasiso, uni detul ngara doko.  ");
INSERT INTO kqw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","O Iesu i katutur gusun a minat una kobot raut una mugano bung una wik. Ra i wanpat mugu torom o Maria Magdalen, i ra o Iesu i lakro ru tar a wonomawit na laulau na nion gusuni. ");
INSERT INTO kqw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","O Maria Magdalen i wan ra i inanos det ra det ser mur o Iesu, kura det balano marmaris ma det tangtangis suri. ");
INSERT INTO kqw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ra det longoro i lena, o Iesu i sa laun melet gusun a minat ma o Maria i sa tama tari, ka det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Numur o Iesu i wanpat torom aru nat na ususer ra der wan nanan una kisapi, ma a pinino i tamtama senene. ");
INSERT INTO kqw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Der milet melet, ra der inanos a kum nat na ususer rop. Ikut, ka det nurnur kai un der. ");
INSERT INTO kqw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Numur i wanpat torom a noino ma ra nat na ususer ra det kis na inangon. Ra i bor det, uni a balandet i dekdek ma ka det nurnur un det ra det sa tama tari ra i sa laun melet. ");
INSERT INTO kqw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma i watungi tandet lena, “Mot in nan una rakrakon bual rop, ma mot in warawai nama Wakak na Wasiso torom a taro rop. ");
INSERT INTO kqw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Osi ra i nurnur ma di baptaiso i, din ulauni. Ikut i ra ke nurnur, din pitar a dekdek na warkurai na minabalu toromi. ");
INSERT INTO kqw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A kum tene nurnur det in pam a kum utna na ukisin ri: Det in lakro ru a kum laulau na nion nama risang, ma det in wasiso nama kum matok na ngas na wasiso, ");
INSERT INTO kqw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","det in pam a kum sui ra i ser karot doko a taro, ikut ken banlaulau det, ma ra det in inum a sangsagor, ken banlaulau det, ma det in ubek a kum lamandet una kum misait, ra det in langolango.” ");
INSERT INTO kqw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ra a Labino o Iesu i sa wasiso taru tandet, o God i los toto pasi usapat una langit, ma o Iesu i kis una papor sot na laman o God. ");
INSERT INTO kqw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anun a kum nat na ususer det wan, ma det warawai tuptupukus. Ma a Labino i papam tomo nam det, ma i ulingmulus anun a wasiso nama kum utna na ukisin. ");
INSERT INTO kqw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Un narnarap utmakai ra ka di ukis utmakai a rakrakon bual, a Wasiso i sa kis mugu taru. A Wasiso i kis tomo nam o God, ma a Wasiso i ut a God. ");
INSERT INTO kqw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Un narnarap utmakai i kis tomo nam o God. ");
INSERT INTO kqw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Una Wasiso kut, o God i ukis a kum utna rop. Katu utna o God i ukis tari, ra ke ukisi nama Wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A nilaun i kis uni, ma a nilaun ra, i a talapor anun a taro rop. ");
INSERT INTO kqw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A talapor i sisio una dumirum, ma a dumirum ke turus lar pasi. ");
INSERT INTO kqw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","O God i tulu ru ara musano, a risano o Jon. ");
INSERT INTO kqw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I wanpat sur in wasiso puaso una talapor, sur a taro rop det in nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I ut ausur a talapor, i wanpat kut sur in wasiso puaso una talapor. ");
INSERT INTO kqw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A talapor mulus, ra i ser utalapor a taro rop, in nanpat mo urin una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A Wasiso i kis una rakrakon bual. Ma una Wasiso, o God i ukis a rakrakon bual, ikut a taro una rakrakon bual ka det tama lele pasi. ");
INSERT INTO kqw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I wanpat sur anun a taro, ikut anun a taro ut ka det gas pasi. ");
INSERT INTO kqw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ikut, torom det ra det gas pasi, ma det nurnur una risano, i mulaot pas det sur det a kum nutnutun o God. ");
INSERT INTO kqw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ausur di watung det a kum nutnutun o God kibino una usus na kabotaro, o una nuknukin tu musano taginin upiso, o una nemnem na nolin. Awu, di usus det una nion, una nemnem ut anun o God. ");
INSERT INTO kqw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Wasiso i wanpat a musano mulus, ma i kis epotor ta met. Met sa tama tar anun a minamar, a minamar anun a Nutunu, ara sot kut, ra i wan gusun o Tamano, i bukus nama marmaris ma a lingmulus. ");
INSERT INTO kqw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","O Jon i wasiso talapor uni, ma i watungi nam in labino walngano lena, “I ut ri, ra a wasiso mugu uni lena, ‘I ra in mur tang, i labo tang, uni i laun raut numugu tang.’” ");
INSERT INTO kqw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I bukus nama marmaris, ma gusun anun a labino marmaris i udan dat nama susut na wakak na utna ra i wanan pat torom dat. ");
INSERT INTO kqw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Un o Moses, o God i pitar tar a kum Warkurai torom dat, ikut un o Iesu Karisito i pitar tar a marmaris ma a lingmulus torom dat. ");
INSERT INTO kqw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kataio utmakai i tama tar o God. Ikut ara Nutunu kut, ra i kis tomo nam o Tamano, i ut i ese o God torom dat. Ma i ut a God. ");
INSERT INTO kqw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A kum mugumugu anun a taro Juda tagisapat o Jerusalem, det tulu ru a ramano kum tene etabor torom o God, ma a ramano taro tagun a kabotaro Liwai, torom o Jon sur det in tingi lena, “Ui osi?” ");
INSERT INTO kqw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O Jon ke wasiso batbati, i wasiso talapor ut uni lena, “Ausur iau a Karisito.” ");
INSERT INTO kqw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Det ting meleti lena, “Osi ui? Ui o Elaija?” Ra i balu det lena, “Awu, ausur iau o Elaija.” Det ting meleti lena, “Ui a poropet ra di len taru in nanpat?” I balu det lena, “Awu.” ");
INSERT INTO kqw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Numur det tingi lena, “Osi ui? Un inanos met sur met in inanos det ra det tulu ru met urin. Asau un watungi un ui ut?” ");
INSERT INTO kqw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O Jon i balu det, “Iau a musano ra a poropet Aisaia i wasiso mugu uni lena, ‘Una nubual kalako taro uni, in nalngan ara i kakabo lena: Mot in pam kodos a kisapi anun a Labino.’” ");
INSERT INTO kqw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A kum Parisi ra di tulu tar det torom o Jon, ");
INSERT INTO kqw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","det tingi lena, “U watungi lena, ausur ui a Karisito, ma ausur ui kai o Elaija, o a poropet, ra di len taru in nanpat. Io, ra i lenra, ilai sur u baptaiso a taro?” ");
INSERT INTO kqw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","O Jon i balu det lena, “Iau, a baptaiso mot nama danim, ikut ara kura i tur epotor tamot, ra ka mot tasman lele pasi. ");
INSERT INTO kqw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I ra, in mur tang. Ka elar sur an palos aru su gusun aru kikino, uni a natino sakit tano.” ");
INSERT INTO kqw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A kum utna ri, i wanpat tong o Betani una ara papor danim Jodan, ra o Jon i baptaiso a taro iai. ");
INSERT INTO kqw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ara bung numur, o Jon i tama o Iesu i wan nanan toromi, ra i watungi uni lena, “Mot tama i, a Sipsip anun o God, i ra in lakro ru a sakino petutna anun a rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A musano kut ri, i ra a wasiso mugu uni lena, ‘A musano ra in mur tang, i labo tang, uni i laun raut numugu tang.’ ");
INSERT INTO kqw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iau kai numugu ka tasmani. Ikut a baptaiso nama danim sur an upuaso a musano ri torom a taro Israel.” ");
INSERT INTO kqw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ma o Jon i watungi lena, “Ka tasmani lena osi a Karisito. Ikut o God, ra i tulu ru iau sur an baptaiso nama danim, i inanos iau lena, ‘Un tama a Tokodos na Nion in nan pirso ma in kis un ara musano. I ra a musano ra in baptaiso nama Tokodos na Nion.’ Ma a tama a Tokodos na Nion i wan pirso tagisapat una langit, i elar namin natabun ma i kis taru netes un o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A sa tama tar a utna ri i wanpat, ra a inanos uni lena, i a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ara bung palu melet, o Jon ma aru nat tagun anun a kum nat na ususer detul tur taru melet tiro. ");
INSERT INTO kqw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I tama pas o Iesu i wan sakit detul, ra i watungi uni lena, “Tama i, a Sipsip anun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aru nat na ususer der longoro a wasiso ra, ma der mur mut o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","O Iesu i tur tupukus, i tama der ra der muri, ra i ting der lena, “Asau ra mur nemi?” Der balu i lena, “Rabai,” (a kukuraino lena Tene Ususer), “kura u kis awai?” ");
INSERT INTO kqw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O Iesu i balu der lena, “Mur iap sur mur in tama i.” Io, der muri, ma der tama a dino ra o Iesu i kis iai. Ra detul wanpat, i sa wat na pakano bung pas, ma detul kis mukut tiro iai a kudulano lirop ra. ");
INSERT INTO kqw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ara tagun aru musano ra der longoro a wasiso anun o Jon ma der mur o Iesu, a risano o Endru, a tisino Saimon Pita. ");
INSERT INTO kqw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A mugano utna ra o Endru i pami, i sio pas o Saimon a tisinolik, ra i inanosi lena, “Met sa sio pas a Mesaia!” (a kukuraino a Karisito). ");
INSERT INTO kqw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O Endru i ben pas o Saimon torom o Iesu. O Iesu i tama i, ra i watungi tano lena, “Ui o Saimon, a nutun o Jon, din watung a risam nam o Kepas.” (Una wasiso Grik di watungi nam o Pita, a kukuraino a wat.) ");
INSERT INTO kqw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ara bung palu melet, o Iesu i nem na wan utong o Galili. I barato pas o Pilip, ra i watungi tano lena, “Un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","O Pilip, i tagitong o Betsaida, a tamon anun o Endru ma o Pita. ");
INSERT INTO kqw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","O Pilip i sio pas o Natanael, ra i inanosi lena, “Met sa sio pas a musano ra o Moses i tumtumus mugu taru uni una Buk na Warkurai, ma a kum poropet kai det sa tumtumus mugu taru uni. I ra, o Iesu a te Nasaret, a nutun o Josep.” ");
INSERT INTO kqw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ikut o Natanael i balu i lena, “O Nasaret! Pepetlai, tu wakak na utna ut in nanpat tagitiro iai?” O Pilip i balu i lena, “Un nan urin ma dar in nan sur un tama i.” ");
INSERT INTO kqw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","O Iesu i tama pas o Natanael i wan nanan toromi, ra i watungi lena, “A te Israel mulus ut ri, ke tasman a torotoro.” ");
INSERT INTO kqw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","O Natanael i ting o Iesu lena, “U tasman lan iau?” I balu i lena, “Ra o Pilip ke ben pat ui utmakai urin, a sa tama mugu tar ui ra u kis taru nago utuntudu in nanai na fig.” ");
INSERT INTO kqw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","O Natanael i watungi tano lena, “Tene ususer, ui a Nutun o God, ui a King anun a taro Israel.” ");
INSERT INTO kqw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","O Iesu i watungi tano lena, “Pepetlai u nurnur un iau, uni a inanos ui lena u kis taru nago utuntudu in nanai na fig? Numur un tama a kum lamlabino utna sakit in nanpat, in labo tan a utna ri u tama i.” ");
INSERT INTO kqw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","O Iesu i watung meleti lena, “A inanos mot nama lingmulus, mot in tama a langit in tapapos, ma a kum ensel anun o God det in nanan toto ma det in nanan pirso torom a Nutun a Musano.” ");
INSERT INTO kqw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Numur, ra aru bung i rop, di pam a lukaro na unolin tong o Kana, una papor Galili. O nan o Iesu i wan una lukaro ra. ");
INSERT INTO kqw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Di saring o Iesu ma anun a kum nat na ususer kai sur det in nan una lukaro na unolin. ");
INSERT INTO kqw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ra a wain i sa rop, o nan o Iesu i inanosi lena, “A wain i sa rop.” ");
INSERT INTO kqw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","O Iesu i balu i lena, “Nang, ilai ra u inanos iau uni? Anung a du bung ke sot utmakai.” ");
INSERT INTO kqw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","O nan o Iesu i inanos a kum tultul lena, “Mot in pami kut asau ra in watungi tamot.” ");
INSERT INTO kqw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tiro iai, a wonomnin lamlabino koto na wat kura di utur tari sur a nginigis, elar ut nama warkurai tagun a lotu anun a taro Juda. Unin tekteken nokoto ri, di ser ubukusi nama ru noino galen na danim o a tulu noino. ");
INSERT INTO kqw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","O Iesu i watungi tan a kum tultul lena, “Mot in ubukus tar a kum koto nama danim.” Ra numur det titior bukus rop tar det. ");
INSERT INTO kqw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Io, o Iesu i tulu det lena, “Mot in itup pas lako danim tagun a kum koto, ma mot in losi torom a mugumugu na lukaro.” Ra det pami ut lenra. ");
INSERT INTO kqw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A mugumugu na lukaro i inum tama a danim ra, ra i sa wain rop. Ke tasmani lena a wain ri i wan tagai. A kum tultul kut ra det itupi det tasmani. Ra i kabo gisen pas a musano ra di unolini una bung ra, ");
INSERT INTO kqw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma i watungi tano lena, “A taro rop det ser tabor mugu a taro nama wakak na wain. Ra det sa inum pas a susut na wain, io, det in tabor det mukut nama wain ra ke wakak bing. Ikut ui, u etabor maragom nama wain ra i wakak sakit.” ");
INSERT INTO kqw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iri a mugano ukinalong ra o Iesu i pami. I pami tong o Kana una papor Galili. A ukinalong ra, i ese puaso anun a minamar, ma anun a kum nat na ususer det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Numur, ra a lukaro na unolin i sa rop, i wan utong o Kapernaum. Det wan tomo nam o nano, a kum tistisino ma anun a kum nat na ususer. Det kis tiro iai a kabano bung ut. ");
INSERT INTO kqw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ra a labino bung na lotu na Wanlakai anun a taro Juda i sa milau, o Iesu i wan usapat o Jerusalem. ");
INSERT INTO kqw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I ruk un ara dino tagun a rumu na etabor, ra i tama a taro ra det siuru a kum bulumakau, a kum sipsip, ma a kum tabun. I tama i kai a kum tene keles mani, kura det kis nisan anundet a kum kabulu. ");
INSERT INTO kqw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Io, i iris pas a kum warus sur in pam in narus na inaim, ra i lu pirso ru det rop nami. I lu pirso ru a kum bulumakau ma a kum sipsip, ma i woro sarara ru a kum mani anun a kum tene keles mani, ma i woro bulus ru anundet a kum kabulu. ");
INSERT INTO kqw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma i watungi tandet ra det siuru a kum tabun, “Mot in los pirso ru det taginin! Gong mot pukus a rumu anun o Tita sur a rumu na siuru!” ");
INSERT INTO kqw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Anun a kum nat na ususer det nuk pas a wasiso una Buk Tabu lena, “An iru uni anung a labino marmaris sur anum a rumu.” ");
INSERT INTO kqw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A taro Juda det wanpat melet torom o Iesu ma det tingi lena, “Asi na ukinalong un ese met uni, sur met in tasmani lena u utur ukai a warkurai ra u pam a kum utna ri nami?” ");
INSERT INTO kqw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","O Iesu i balu det lena, “Mot in rege ru a rumu ri anun o God, ma an utur melet pasi kut un lako tulu bung.” ");
INSERT INTO kqw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Det ting o Iesu lena, “Di pam tar a rumu ri una wat na noino ma wonom na kilalo, ra ui, un pam melet pasi kut un lako tulu bung?” ");
INSERT INTO kqw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","O Iesu i wasiso una rumu anun o God, i wasiso elelar ut una pinino. ");
INSERT INTO kqw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Numur, ra o Iesu i sa laun pat melet gusun a minat, anun a kum nat na ususer det nuk melet pas a wasiso ri. Io, det nurnur maragom una Buk Tabu, ma una wasiso ra o Iesu i sa watung tari. ");
INSERT INTO kqw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","O Iesu i kis sapat o Jerusalem una labino bung na lotu na Wanlakai, ra a susut na taro det tama a kum ukinalong ra i pami, ma det nurnur una risano. ");
INSERT INTO kqw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ikut o Iesu ke nurnur un taio, uni i tasman a taro rop. ");
INSERT INTO kqw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ke sibo sur taio ra in inanosi una petutna anun a taro, uni i ut i tasman wakak a balandet. ");
INSERT INTO kqw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ara musano tagun det a kum Parisi, a risano o Nikodimas, i ara mugumugu anun a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I wan torom o Iesu una ra bung na mirum ma i watungi tano lena, “Tene ususer, met tasman ui ra ui a tene ususer, ra o God i tulu ru ui. Katu musano in pam lar pas a kum ukinalong ra u ser pami, ra o God ke kis tomo nami.” ");
INSERT INTO kqw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","O Iesu i balu i lena, “A inanos ui nama lingmulus, osi ra ka di usus matoki, ken tama lar pas a matanitu anun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","O Nikodimas i tingi lena, “Din usus matok petlan pas taio ra i sa takano? Pepetlai, in ruk melet un in balan o nano sur in usus meleti?” ");
INSERT INTO kqw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ra o Iesu i balu i lena, “A inanos ui nama lingmulus, osi ra ka di usus matoki una danim ma una nion, ken ruk lar pas una matanitu anun o God. ");
INSERT INTO kqw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Osi ra di ususi una pinindi, i ra a pinindi ut, ma osi ra di ususi una nion, i ra a nion ut. ");
INSERT INTO kqw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gong u kisin ra a watungi tam lena din usus melet mot. ");
INSERT INTO kqw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A wuwu i wan tuptupukus elar nam anun a nemnem, u longoro a ungu ino, ikut, ko tasmani lena i wan tagai, ma i wan urai. Lenkaira torom det rop ra a Nion i usus matok det.” ");
INSERT INTO kqw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ra o Nikodimas i tingi lena, “In pepetlai a utna ri?” ");
INSERT INTO kqw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","O Iesu i balu i lena, “Ui a labino tene ususer anun a taro Israel, ma ilai ra ko tasman a kum utna ri? ");
INSERT INTO kqw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A inanos ui nama lingmulus, met watung asau ra met tasmani, ma met wasiso un asau ra met sa tama tari, ikut ka mot nurnur un asau ra met wasiso uni. ");
INSERT INTO kqw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A inanos mot una kum utna taginin upiso ma ka mot nurnur uni. Io, mot in nurnur pepetlai ra an inanos mot una kum utna tagisapat una langit? ");
INSERT INTO kqw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kataio i wan pas usapat netes una langit, a Nutun a Musano sot kut ra i wan pirso tagisapat netes una langit. ");
INSERT INTO kqw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Numugu, o Moses i ukete in nusui un in nanai una nubual kalako taro uni. Lenkutkai ra din ukete a Nutun a Musano usapat, ");
INSERT INTO kqw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sur det rop, ra det nurnur uni, det in laun tukum. ");
INSERT INTO kqw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“O God i maris a rakrakon bual, ra i pitar tar a Nutunu ara sot kut, sur osi ra in nurnur uni, in laun tukum ma ken iru. ");
INSERT INTO kqw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","O God ke tulu tar a Nutunu urin una rakrakon bual sur in pitar a warkurai na minabalu torom a rakrakon bual. I tulu tari kut sur in ulaun a rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Osi ra i nurnur uni, ka din pitar a warkurai na minabalu toromi. Ikut, osi ra ke nurnur, i sa tur una dekdek na warkurai na minabalu uni ke nurnur un ara Nutun o God sot kut. ");
INSERT INTO kqw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iri a warkurai anun o God: A talapor i sa wanpat una rakrakon bual, ikut a taro det nem a dumirum kut ma a talapor awu, uni det pam a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Det rop ra det ser pam a kum sakino petutna, det nget a talapor, ma ka det wan suri, sako din tama pupuaso pas anundet a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ikut, osi ra i murmur a lingmulus, i ser wanpat una talapor, sur din tama pupuaso i lena anun a kum pinapam i kibino ut tan o God.” ");
INSERT INTO kqw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Numur, o Iesu tomo nam anun a kum nat na ususer det wan tagisapat o Jerusalem sur ara tamon lik kura una papor Judia. Det kis tiro iai, ma i baptaiso a taro. ");
INSERT INTO kqw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","O Jon kai i baptaiso tong o Ainon milau o Saleim, uni a susut na danim kura iai. A taro det wanan toromi sur in baptaiso det. ");
INSERT INTO kqw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A utna ri i wanpat, ra kabaut di uruk o Jon una karabus. ");
INSERT INTO kqw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A ramano kum nat na ususer anun o Jon det wasiso na engaras tomo nama ara te Juda una nirurus keles, elar nama petutna una lotu Juda. ");
INSERT INTO kqw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Det wan torom o Jon ra det inanosi lena, “Tena ususer, a musano ra mur kis tomo pas nami tong un ara papor danim Jodan, i ra u inanos taru uni, uniri kurong mo kai i baptaiso. Ra a taro rop det wan mukut toromi.” ");
INSERT INTO kqw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","O Jon i watungi tandet lena, “Kataio in pam pas tu utna ra o God ke pitar tari tano. ");
INSERT INTO kqw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mot ut mot sa longoro tari ra a watungi lenri, ‘Ausur iau a Karisito. O God i tulu ru iau kut sur an mugu tano.’ ");
INSERT INTO kqw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tu musano ra i nolin nam tu ino, anun a ino ut ra. A pasano a musano ra i nolin, in tur ma in longoro suri. Ra in longoro in nalngano, in gas doko. Uniri, anung a gasgas i elar nam anun a gasgas, ra anung a gasgas i sot maragom. ");
INSERT INTO kqw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","O Iesu ut in labo nanan ma iau an natino nanan.” ");
INSERT INTO kqw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“O naro ra i wan pirso tagisapat una langit, i labo sakit taun a taro rop. A musano ra taginin upiso, taginin ut i upiso, ma i wasiso kut una kum utna taginin upiso. I ra i wan tagisapat una langit, i labo sakit taun a taro rop. ");
INSERT INTO kqw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ma i inanos una kum utna ra i tama tari ma i longoro tari, ikut kataio i nurnur una nuna wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ikut det ra det nurnur una nuna wasiso, det mulaot lena o God i a lingmulus. ");
INSERT INTO kqw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I ra o God i tulu ru i, i wasiso nama wasiso anun o God, uni o God i pitar rop tar a Tokodos na Nion toromi. ");
INSERT INTO kqw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O Tamano i maris a Nutunu, ra i pitar rop tar a kum utna ulamano. ");
INSERT INTO kqw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Osi ra i nurnur una Nutun o God, i sa utur ukai a nilaun tukum. Ikut, osi ra ke ser tarom tan a Nutunu, ken utur ukai a nilaun, uni a kankan anun o God ken rop gusuni.” ");
INSERT INTO kqw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A kum Parisi det longoro i lena o Iesu i ben pas a susut na taro na ususer, det susut tan a taro na ususer anun o Jon, ma i bapitaiso det. ");
INSERT INTO kqw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ikut o Iesu ut ke baptaiso taio, anun a kum nat na ususer kut det baptaiso. ");
INSERT INTO kqw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ra o Iesu i sa tasmani lena a kum Parisi det sa longoro i, i wan tagitiro una papor Judia ra i milet melet utong una papor Galili. ");
INSERT INTO kqw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Una nuna inawan i wan potor tong una papor Samaria. ");
INSERT INTO kqw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tiro una papor Samaria, i wanpat una tamon Sikar, i milau kut una du piso ra, un ra bung ut, o Jekop i tabor tar a nutunu, o Josep nami. ");
INSERT INTO kqw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","In nutung na danim, ra o Jekop i sa kil tari, kura tiro iai. O Iesu i taramo a pinino i tungulu una nun a walos na inawan, ra i kis mo tiro nisan in nutung na danim ra. Una du bung ra, in matanas i sa kis lekeleke. ");
INSERT INTO kqw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Io, ara ino Samaria i wanpat sur in itup, ra o Iesu i watungi tano lena, “Un tabor iau nam lako danim.” ");
INSERT INTO kqw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Anun a kum nat na ususer det sa wan taru utiro una tamon, sur det in kul utna na inangon. ");
INSERT INTO kqw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A ino Samaria i balu o Iesu lena, “Ui a te Juda, ma iau a ino Samaria. Sur asau ra u saring iau sur lako danim?” Uni a kum te Juda ka det emarom nama kum te Samaria. ");
INSERT INTO kqw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ikut o Iesu i balu i lena, “Ra u tasman a etabor anun o God, ma u tasman osi kai ra i saring ui sur lako danim, un saringi, ma in tabor ui nama danim na nilaun.” ");
INSERT INTO kqw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A ino i watungi tano lena, “Labino, katu utna na ititup anum, sur un itup danim nami. In nutung na danim ri i dordorong doko. Ma tagai a danim na nilaun ra? ");
INSERT INTO kqw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","U nuki lena u labo tan a tubundat o Jekop ra i tabor met nam in nutung na danim ri? Det tomo nama kum nutnutunu ma anun a kum wewegua kai, det rop det ininum taguni.” ");
INSERT INTO kqw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O Iesu i balu i lena, “Det rop ra det inum a danim ri, det in muruk melet kut. ");
INSERT INTO kqw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ikut det ra det in inum a danim ra an tabor det nami, ka det in muruk melet mo. A danim ra an tabor det nami, in elar nam ara matmatano danim una nundet a nilaun, ra in burburak pat ma in tabor det nama nilaun tukum.” ");
INSERT INTO kqw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A ino i watungi tano lena, “Labino, un tabor iau nama danim ra, sur gong melet mo a muruk, ma gong mo a wan liklik urin sur an itup.” ");
INSERT INTO kqw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ra o Iesu i watungi tano lena, “Un nan ma un ben pas anum a musano ra mur in milet melet urin.” ");
INSERT INTO kqw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A ino ra i balu i lena, “Katu musano anung.” O Iesu i watungi tano lena, “A lingmulus ut ra u watungi lena katu musano anum. ");
INSERT INTO kqw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","U sa nolin pas nama limo na musano, ma ara ra u kis tomo nami uniri, ausur anum a musano. A lingmulus ut ra u watungi tang.” ");
INSERT INTO kqw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","A ino i balu i lena, “Labino, uniri, a tasmani lena ui a poropet. ");
INSERT INTO kqw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A kum tumtubumet tagun numugu det ser lotu torom o God una tangai ri, ikut mot a taro Juda mot watungi lena, din lotu torom o God sapat kut o Jerusalem.” ");
INSERT INTO kqw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ra o Iesu i watungi tano lena, “Tama i, a lingmulus ino ri an watungi tam, a du bung in nanpat, ra ka mot in lotu mo torom o Tita una tangai ri, ma sapat kai o Jerusalem, awu. ");
INSERT INTO kqw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mot a kum te Samaria ka mot tasman osi ra mot ser lotu toromi, ma met a taro Juda met tasman ut osi ra met ser lotu toromi, uni a ululaun i wanpat ut tagun a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A du bung in nanpat ma iri i sa wanpat, ra a kum tene lotu mulus det in lotu torom o Tita una nion ma una lingmulus. A kum ngas na tene lotu lenra, o Tita i nem doko det. ");
INSERT INTO kqw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","O God a nion. Det ra det lotlotu toromi, det in lotu ut una nion ma una lingmulus.” ");
INSERT INTO kqw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ra a ino i watungi tano lena, “A tasmani lena a Mesaia ra di watungi nama Karisito, in nanpat, ma in upuaso a kum utna rop torom met.” ");
INSERT INTO kqw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma o Iesu i balu i lena, “Iau ut ri a wasiso torom ui.” ");
INSERT INTO kqw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Una du bung ut ra, a kum nat na ususer anun o Iesu det milet melet. Det tama o Iesu i wasiso tomo nam ara ino, ra det kisin. Ikut katutaio tagun det i iting lena, “U nem asau?” o lenri, “Sur asau ra u wasiso tomo nami?” ");
INSERT INTO kqw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A ino ra i wan pas gusun anun in nadanim, i milet melet sur a tamon, ra i inanos a taro tiro iai lena, ");
INSERT INTO kqw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ai, mot iap, sur mot in tama ara musano, i inanos iau una kum utna rop ra a sa pam tari numugu. Kutiro i mo ra a Mesaia?” ");
INSERT INTO kqw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Io, a taro ra, det wan pas gusun a tamon, ma det wan torom o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ra a ino i sa wan taru, a kum nat na ususer det inanos dekdeki lena, “Tene ususer, un nangon pas.” ");
INSERT INTO kqw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ikut o Iesu i balu det lena, “A nga utna na inangon kuri ut, ka mot tasmani.” ");
INSERT INTO kqw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A kum nat na ususer det ting etetalai det lena, “Kutiro taio i sa tabor tari nam lako utna na inangon?” ");
INSERT INTO kqw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","O Iesu i watungi tandet lena, “A nga utna na inangon iri i, an tarom una nemnem anun o naro ra i tulu ru iau urin, ma an pam rop pas anun a pinapam. ");
INSERT INTO kqw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mot ser watungi lenri, ‘A watnin kalang utmakai kura ra din pasong maragom.’ Ikut a watungi tamot lena: Mot in tamtama tokodos usa numugu, ma mot in tama a kum kinobot, det sa taka rop, ma i sa sot sur din pasong. ");
INSERT INTO kqw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Uniri a musano ra i pasong i los anun a ikul. Ma a wina nun a pasong, a utna sur a nilaun tukum, sur osi ra i marmarut ma osi ra i pasong, der in gas tomo. ");
INSERT INTO kqw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A wasiso ra a taro det ser watungi, i lingmulus ut lenri, ‘Ara i marmarut, ma ara i pasong.’ ");
INSERT INTO kqw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Io, a tulu mot sur mot in pasong una kinobot ra mot ut ka mot marut tari. Ara taro gisen ut det pam tari, ma mot, mot los a tinibo mukut tagun anundet a pinapam.” ");
INSERT INTO kqw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A susut na te Samaria tagun a tamon ra, det nurnur un o Iesu. Det nurnur kibino una wasiso anun a ino, ra i watungi tandet lena, ‘I inanos iau una kum utna rop ra a sa pam tari numugu.” ");
INSERT INTO kqw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Io, a taro Samaria det wan torom o Iesu ra det saringi sur in kis nisan det, ra i kis pas aru bung tiro iai. ");
INSERT INTO kqw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A susut melet det nurnur, kibino una nuna wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Det watungi tan a ino ra lena, “Uniri met sa nurnur, ausur una wasiso kut ra u watungi un o Iesu, awu. Met ut, met sa longoro i ma met sa tasman mulusi lena, i a Tene Ulaun anun a rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ra aru bung i sa rop, o Iesu i wan utong o Galili. ");
INSERT INTO kqw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","O Iesu ut i sa watung tar a wasiso lenri, “A poropet, a taro tagun anun a tamon ka det ser ru i.” ");
INSERT INTO kqw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","A taro tagitong o Galili det sa wan pas una labino bung na lotu na Wanlakai sapat o Jerusalem, ma det sa tama tar a kum utna ra o Iesu i pami tiro iai. Io, o Iesu i wanpat tong o Galili, ra a taro det gas pasi. ");
INSERT INTO kqw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O Iesu i wan melet utong o Kana una papor Galili, a tamon ra i pukus tar a danim sur a wain iai. Ara mugumugu anun a gapman, a nutunu lik a musano i misait tong o Kapernaum. ");
INSERT INTO kqw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","I longoro i lena o Iesu i wan tagitiro o Judia utong o Galili, ra i wan toromi, ma i saringi sur in nan utong o Kapernaum sur in ulangolango pas a nutunu lik a musano, i milau mo sur in mat. ");
INSERT INTO kqw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","O Iesu i watungi tano lena, “Ra ka mot tama a kum utna na ukisin ma lako kum ukinalong, ka mot in nurnur mut.” ");
INSERT INTO kqw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ra a mugumugu anun a gapman i watungi lena, “Labino, dar in nan lakit sako a nutung lik in mat.” ");
INSERT INTO kqw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","O Iesu i watungi tano lena, “Un nan kut, a nutum lik in laun.” A musano ra i nurnur una wasiso anun o Iesu, ra i wan. ");
INSERT INTO kqw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ra ke wanpat utmakai, anun a kum tultul det wan barato i ra det inanosi lena, “A nutum lik i sa langolango.” ");
INSERT INTO kqw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I ting det lena, “Asi na du bung mulus ra a nutunglik i langolango melet uni?” Det balu i lena, “Nubung, una ara pakano bung una lirop a mararong i rop gusuni.” ");
INSERT INTO kqw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A taman a nat i nuk melet pas a du bung ra o Iesu i watungi toromi lena, “A nutum lik in laun.” Ra i tasman lele i lena a du bung ut ra o Iesu i wasiso uni, a mararong i rop. Io, det tamtamano rop det nurnur maragom un o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A utna ri, i a manru na ukinalong o Iesu i pami tong o Galili, ra i wan tagitong o Judia. ");
INSERT INTO kqw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Numur, o Iesu i wan usapat o Jerusalem sur a labino bung na lotu anun a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ara kabopolo, di watungi nam o Besata una wasiso Ibru, i kis sapat o Jerusalem, milau una labino matansako ra di watungi nama “Matansako na sipsip”. Ma a limo na parada det tur talilis pas a kabopolo ra. ");
INSERT INTO kqw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","A susut na taro ra det misait nama kum ngas na misait, det ser kis tiro iai, a kum pulu, det ra ka det ser wan ma det ra a pinpinindet i mat. ");
INSERT INTO kqw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ara musano i kis tiro iai i misait pas a tulu noino ma tiwal na kilalo. ");
INSERT INTO kqw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","O Iesu i tama pas a musano ra i inep taru tiro iai. I tasmani lena a musano ra i sa suano i a misait uni, ra i tingi lena, “Pepetlai, u nemi sur un langolango?” ");
INSERT INTO kqw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A musano ra i balu i lena, “Labino, kataio i ser warut iau sur in los tar iau una du bung ra a danim i tonton uni. Ra a nem na wan sur an rurus, ara gisen kut in kalabor mugu batbat pas iau.” ");
INSERT INTO kqw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","O Iesu i watungi tano lena,“Un katutur, un los anum a bat ra un nan.” ");
INSERT INTO kqw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Uniutra a musano ra i langolango, i tur, ma i los pas anun a bat, ra i wan. A utna ri i wanpat una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","A ramano kum te Juda det watungi tan a musano ra o Iesu i ulangolango pasi lena, “A Sabat ri! I tabu sur din los a bat uni.” ");
INSERT INTO kqw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ra i balu det lena, “A musano ra i ulangolango pas iau, i watungi tang lena, an los pas anung a bat ra an nan.” ");
INSERT INTO kqw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Det tingi lena, “Osi na musano ra i watungi tam lena un los pas anum a bat ma un nan?” ");
INSERT INTO kqw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ikut a musano ra ke tasman osi ra i ulangolango pasi, uni o Iesu i wan epotor tan a kunur na taro. ");
INSERT INTO kqw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Numur ut, o Iesu i barato pas a musano ra una rumu na etabor. I watungi tano lena, “Tama i, uniri u sa langolango. Gong melet mo u pam tu sakino, sako tu laulau na utna sakit in nanpat un ui numur.” ");
INSERT INTO kqw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A musano ra i wan ma i inanos a kum te Juda lena, “O Iesu ut i ulangolango pas iau.” ");
INSERT INTO kqw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Io, uniri, a kum te Juda det turpasi sur det in pam a kum sakino petutna torom o Iesu, uni i pam a kum utna ri una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","O Iesu i watungi tandet lena, “O Tita ke mana nama pinapam na warut, lenkutkai ra iau kan mana nama pinapam na warut torom a taro.” ");
INSERT INTO kqw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iri, a kibino ra a kum te Juda det nem doko i sur det in um doko o Iesu. Det kankan torom o Iesu, ausur a kibino kut ra i papam una Bung na Sabat. A kibino utkai ra o Iesu ut i watung o God lena o Tamano, ma una wasiso ri, ra i elaro i ut nam o God. ");
INSERT INTO kqw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","O Iesu i balu det lena, “A inanos mot nama lingmulus, a Nutun o God ken pam oros pas tu utna elar nam anun a nemnem, in pami kut a kum utna ra i tama o Tamano i ser pami. Uni a kum utna rop ra o Tamano i pami o Nutunu kai in pami. ");
INSERT INTO kqw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","O Tamano i maris o Nutunu, ma i ese i una kum utna rop ra i ser pami. Ma in ese i kai una kum utna ra i labo taun a kum utna ri, sur mot in kisin uni. ");
INSERT INTO kqw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A Nutunu in tabor det ra i nemi sur in tabor det nama nilaun, elar nam o Tamano i ukatutur pas a kum minat, ma i tabor det nama nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","O Tamano ken kuro taio, ikut i pitar tar a warkurai rop tan o Nutunu, sur in warkurai nami, ");
INSERT INTO kqw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sur a taro rop det in ru a Nutunu elar nam det ru o Tamano. Osi ra ke ru a Nutunu ke ru i kai o Tamano, i ra i tulu ru i urin. ");
INSERT INTO kqw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“A inanos mot nama lingmulus, osi ra i longoro anung a kum wasiso ma i nurnur un o naro ra i tulu ru iau urin, i sa utur ukai a nilaun tukum, ma ken iru una warkurai. I sa wan gusun a minat sur a nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A inanos mot nama lingmulus, a du bung in nanpat, ma iri i sa wanpat, ra a kum minat det in longoro in nalngan a Nutun o God, ma det ra det longoro i det in laun. ");
INSERT INTO kqw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","O God a kimkibin a nilaun, ma i pitari kai torom o Nutunu sur i kai a kimkibin a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O God i pitar tar a dekdek tano sur in warkurai a taro nami, uni, i a Nutun a Musano. ");
INSERT INTO kqw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Gong mot kisin una wasiso ri. A du bung in nanpat, ra det rop ra det inep una kum tung na minat det in longoro in nalngano. ");
INSERT INTO kqw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Det in katutur gusun a kum tung na minat. Det ra det sa pam tar a wakak na petutna det in katutur gusun a minat sur a nilaun tukum. Ma det kai ra det sa pam tar a sakino petutna, det in katutur gusun a minat sur a iniru tukum.” ");
INSERT INTO kqw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","O Iesu i wasiso utmakai torom a kum te Juda lena, “Ka pam oros tu utna elar nam anung a nemnem. A warkurai nama utna a longoro i. Ma anung a warkurai i tokodos, ma ka mur a nuknuking, a ser mur ut a nuknukin o naro ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ra an wasiso talapor un iau ut melet, anung a wasiso talapor ken maut. ");
INSERT INTO kqw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ikut ara gisen ut i wasiso talapor un iau, ra a tasmani lena anun a wasiso talapor un iau i lingmulus sakit. ");
INSERT INTO kqw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mot tulu ru ara taro torom o Jon a Tene Baptaiso, ra i wasiso talapor torom det un iau. Ma anun a wasiso i lingmulus. ");
INSERT INTO kqw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka sibo sur lako taro det in wasiso talapor un iau, ikut a watungi lenri sur din ulaun mot. ");
INSERT INTO kqw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","O Jon i elar nama lam, ra i kunabor ma i talapor, ma mot gas ra mot tamtama lilik pas kut una talapor ino. ");
INSERT INTO kqw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ikut an inanos mot una wasiso talapor un iau, ra i labo taun a wasiso talapor anun o Jon un iau. A kum pinapam ra a ser pami, det wasiso talapor un iau lena, o Tita i tulu ru iau urin. O Tita i pitar tar a kum pinapam ra tang, sur an pami. ");
INSERT INTO kqw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma o Tita, i ra i tulu ru iau urin, i sa wasiso talapor taru un iau. Ka mot longoro in nalngano, ma ka mot tama tar kai in matano. ");
INSERT INTO kqw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma ka mot utur ukai anun a wasiso una kum balamot, uni ka mot nurnur un o naro ra di tulu ru i urin. ");
INSERT INTO kqw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mot ser lukluki ut a Buk Tabu, uni mot nuki lena mot in los a nilaun tukum uni. Ikut a Buk Tabu kai i wasiso ut un iau! ");
INSERT INTO kqw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ikut, mot a kum te Juda, ka mot nem na wan torom iau sur mot in los a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ka ling sur a taro det in ulabo pas iau. ");
INSERT INTO kqw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ikut a tasman mot ut lena, ka mot maris o God nama balamot mulus. ");
INSERT INTO kqw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A wanpat nama risan o Tita, ma ka mot gas pas iau. Ikut ra taio gisen in nanpat nama risano ut, io, mot in gas pasi. ");
INSERT INTO kqw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Mot, mot nemi kut sur a taro det in ulabo pas mot, ma ka mot tiktikin sur a wasiso na ululabo anun o God torom mot, o God i ara sot kut. Ra i lenra, ka mot nurnur un iau. ");
INSERT INTO kqw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gong mot nuki lena iau an takun mot tan o Tita, awu. O Moses ra mot nurnur uni lena in warut mot, i ut in takun mot. ");
INSERT INTO kqw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ra gunuk mot nurnur un o Moses, io, mot in nurnur utkai un iau, uni anun a kum tumtumus i wasiso ut un iau. ");
INSERT INTO kqw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ikut ka mot nurnur una kum tumtumus anun o Moses, io, mot in nurnur pepetlai una anung a kum wasiso?” ");
INSERT INTO kqw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Io, numur, o Iesu i wan kutus una du tasi Galili, ra di watungi kai nama du tasi Taiberias. ");
INSERT INTO kqw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A labino kunur na taro det muri, uni det sa tama tar a kum ukinalong ra i pami, ra i ulangolango pas det ra det misait. ");
INSERT INTO kqw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","O Iesu i wan toto usapat una du tangai lik ma i kis tomo nam anun a kum nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma a labino bung na lotu na Wanlakai anun a taro Juda i sa milau sur in nanpat. ");
INSERT INTO kqw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","O Iesu i tamtama tokodos, ra i tama pas a labino kunur na taro det wan toromi, i watungi tan o Pilip lena, “Dat in kul lako utna na inangon awai sur dat in tabor a taro ri nami?” ");
INSERT INTO kqw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O Iesu i watungi lenri sur in lar kut o Pilip. Uni i ut i sa tasman asau ra in pami. ");
INSERT INTO kqw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ra o Pilip i balu i lena, “Lako utna na inangon ra din kul pasi nam lako ru mar na denari, ken elar nam det, a lililik kut ra det in nani.” ");
INSERT INTO kqw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ara melet tagun anun a kum nat na ususer a risano o Endru, a tisin o Saimon Pita, i watungi tan o Iesu lena, ");
INSERT INTO kqw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ara nat lik kuri i los a limanin beret kut ra di pami nama bali, ma arin natnat na kiripo. Ikut pepetlai, in elar ut nama kunur na taro ri?” ");
INSERT INTO kqw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A dino ra, in wuliso rop kut, io, o Iesu i tulu anun a kum nat na ususer sur det in ukis a taro tiro iai. A kunur na taro ra, a nilulukin a kum musano kut i elar nama limo na arip. ");
INSERT INTO kqw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","O Iesu i los pas a limanin beret, i watung wakak pas uni torom o God, ma i tibo a taro nami, ra det kis tiro iai. I tibo det kai nama kiripo, elar nam anundet a nemnem. ");
INSERT INTO kqw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ra det sa masur rop, i watungi tan anun a kum nat na ususer lena, “Mot in ubek tomo wakak a utna rop ra det wan kopos tari, sur gong di banlaulau a utna na inangon.” ");
INSERT INTO kqw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Io, det ubek tomo rop pas a utna ra a taro det wan kopos tari, ma det song bukus pas a noino ma aru rat tagun a limanin beret ra. ");
INSERT INTO kqw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A taro det tama a ukinalong ri i pami, ra det watungi lena, “I lingmulus ut, a musano ri, i a poropet ra di watungi lena in nanpat urin una rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ra o Iesu i sa tasmani lena det nem na wan toromi sur det in ungongos pasi sur in king, io i wan gisen pas gusun det usapat netes una tangai. ");
INSERT INTO kqw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ra i sa lirop matano mirum, a kum nat na ususer anun o Iesu det wan piso unago una du tasi Galili. ");
INSERT INTO kqw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Det kas taru una pot, ra det turpasi sur det in nan kutus una du tasi Galili sur o Kapernaum. I sa mirum, ma o Iesu ke wanpat utmakai torom det. ");
INSERT INTO kqw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A dekdek na wuwu i wanpat ma a top i umenene det. ");
INSERT INTO kqw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ra det sa ulusu bakbak, i elar nama limo na kilomita, det tama pas o Iesu i wan sapat netes una du tasi torom det una pot. Ra det ngara doko. ");
INSERT INTO kqw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ikut o Iesu i lena, “Gong mot ngara, iau kut ri.” ");
INSERT INTO kqw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Io, det gas pasi sur in kas una pot, ra uniutra, det sot una nubual ra det wan suri. ");
INSERT INTO kqw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Una bung numur, a kunur na taro ra det kis tong una ra papor tasi, det tasmani lena ara pot sot kut i kis tiro iai. Det tasmani lena, a kum nat na ususer kut det wan, ikut o Iesu ut ke kas tomo nam det. Det kut det wan tagitiro iai. ");
INSERT INTO kqw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","A ramano kum pot tagitong o Taiberias det sot milau una nubual ra a Labino i watung wakak una beret, ma a kunur na taro det wangon iai. ");
INSERT INTO kqw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ra a kunur na taro det sa tasmani lena, o Iesu ma anun a kum nat na ususer ka det kis tiro iai, det kas una kum pot ma det wan utong o Kapernaum ra det sisio sur o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A taro det sio pas o Iesu tong una ara papor du tasi Galili, ra det tingi lena, “Tene Ususer, nangisin kut ra u wan taru urin?” ");
INSERT INTO kqw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","O Iesu i balu det lena, “A inanos mot nama lingmulus, ausur mot sisio sur iau uni mot tama a kum ukinalong ra a pami, awu. Mot sisio kut sur iau uni mot wan a beret ma mot masur nami. ");
INSERT INTO kqw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gong mot papam kut sur a utna na inangon ra i ser mereseng. Mot in papam sur a utna ra in kis tukum sur a nilaun kura numur, ra a Nutun a Musano in tabor mot nami. Uni o Tamano, o God i sa ese tari lena i mulaot un asau ra a Nutun a Musano i pami.” ");
INSERT INTO kqw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Det tingi lena, “Asau met in pami sur met in pam a pinapam anun o God?” ");
INSERT INTO kqw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O Iesu i balu det lena, “Iri i a pinapam anun o God, ra mot in nurnur un o naro ra di tulu ru i urin.” ");
INSERT INTO kqw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ra det ting meleti lena, “Asi na ukinalong un pami sur met in tama i, ma met in nurnur un ui? Asau un pami? ");
INSERT INTO kqw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A kum tumtubumet tagun numugu, det wan a mana una nubual kalako taro uni, elar ra di sa tumus tari una Buk Tabu lena, ‘I tabor det nama beret tagisapat una langit ma det wani.’” ");
INSERT INTO kqw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","O Iesu i watungi tandet lena, “A inanos mot nama lingmulus, ausur o Moses ra i tabor det nama beret tagisapat una langit, o Tita ut i tabor det nami. Ra uniri, i tabor mot nama beret mulus tagisapat una langit. ");
INSERT INTO kqw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","I ra i wan pirso tagisapat una langit, i ut a beret anun o God, ma i pitar a nilaun torom a taro una rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Det watungi tano lena, “Labino, un tabor met nama beret ra, una kum bungbung rop.” ");
INSERT INTO kqw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","O Iesu i balu det lena, “Iau ut a beret na nilaun. Osi ra in nan torom iau ken murak, ma osi ra in nurnur un iau ken muruk melet mo. ");
INSERT INTO kqw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","A sa watung tari tamot lena mot sa tama tar iau, ikut ka mot nurnur. ");
INSERT INTO kqw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Det rop ra o Tita i pitar tar det tang, det in nan torom iau, ma osi ra in nan torom iau kan lu ru i. ");
INSERT INTO kqw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uni a wan pirso tagisapat una langit, ausur sur an mur a nuknuking, awu, a wan sur an mur ut a nemnem anun o Tita, i ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iri i a nemnem anun o Tita, i ra i tulu ru iau urin, lena, gong taio tagun det ra i sa pitar tar det tang in iru. An ukatutur pas det rop melet gusun a minat una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Una nemnem anun o Tita, det rop ra det tamtama torom a Nutunu ma det nurnur uni, det in laun tukum, ma iau an ukatutur pas det gusun a minat una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A ramano kum te Juda det wasiso na ururai eno un o Iesu, uni i watungi lena, “Iau a beret ra i wan pirso tagisapat una langit.” ");
INSERT INTO kqw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ra det watungi uni lena, “O Iesu a nutun o Josep kut. Dat tasman o tamano ma o nano. Io, ilai ra i watungi lena i wan pirso tagisapat una langit?” ");
INSERT INTO kqw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","O Iesu i watungi tandet lena, “Gong mot wasiso na ururai eno. ");
INSERT INTO kqw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","O Tita i tulu ru iau urin. Kataio in pet lar pasi sur in nan torom iau, ra o Tita ken ben tari torom iau. Ra o Tita in ben tari torom iau, iau ut an ukatutur pasi gusun a minat una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A kum poropet det sa tumus tari lena, ‘O God in ususer det rop.’ Io, det rop ra det longoro o Tita ma det ususer tano, det in nan torom iau. ");
INSERT INTO kqw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kataio i tama tar o Tita. Ikut, i ut ra i wan pas gusun o God, i tama tar o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A inanos mot nama lingmulus, osi ra i nurnur un iau, i sa los pas a nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Iau a beret na nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A kum tumtubumot tagun numugu det wan a mana una nubual kalako taro uni, ikut det sa mat. ");
INSERT INTO kqw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ikut a beret ri, i wan tagisapat una langit. Osi ra in nani, ken mat. ");
INSERT INTO kqw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iau ut a beret a laun ino, ra i wan pirso tagisapat una langit. Osi ra in nangon tagun a beret ri, in laun tukum. A lingmulus, a beret ra an etabor nami, i a pining. A pitari sur a taro una rakrakon bual det in laun uni.” ");
INSERT INTO kqw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A ramano kum te Juda det engaras etetalai, ra det watungi lena, “A musano ri in tabor petlan dat nama pinino sur dat in nani?” ");
INSERT INTO kqw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ra o Iesu i watungi tandet lena, “A inanos mot nama lingmulus, ra ka mot in nan a pinin a Nutun a Musano ma ka mot in inum a gapino, katu nilaun mulus in kis un mot. ");
INSERT INTO kqw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Osi ra in nan a pining ma in inum a gaping, i sa los a nilaun tukum, ma iau an ukatutur pasi gusun a minat una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Uni a pining, i a utna na inangon mulus, ma a gaping, i a danim na ininum mulus. ");
INSERT INTO kqw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Osi ra in nan a pining ma in inum a gaping, in laun un iau, ma iau an laun uni. ");
INSERT INTO kqw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","O Tita ra i kimkibino una nilaun, i tulu ru iau, ma i tabor iau nama nilaun. Lenkutkai ra torom osi ra i wan a pining, an tabori nama nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iri a beret ra i wan tagisapat una langit, ausur i elar nam ara ra a kum tumtubundat tagun numugu det wani, ma det sa mat. Osi ra in wangon tagun a beret ri, in laun tukum.” ");
INSERT INTO kqw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","O Iesu i ususer a taro una rumu na lotu tong o Kapernaum ra i watung a kum wasiso ri. ");
INSERT INTO kqw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A susut tagun anun a taro na ususer det longoro a kum wasiso ri, ra det watungi lena, “A etowo ri i ngangitin doko. Osi mo in gas suri?” ");
INSERT INTO kqw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","O Iesu i tasmani lena anun a taro na ususer det wasiso na ururai eno uni. Ra i ting det lena, “Pepetlai, a wasiso ri i banlaulau mot? ");
INSERT INTO kqw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","In pepetlai torom mot, ra mot in tama a Nutun a Musano ra in milet melet usapat sur a tamon ra numugu i kis pas iai? ");
INSERT INTO kqw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Nion, i ra i pitar a nilaun. A dekdekin a pinin a musano katu utna i gas uni. A kum wasiso ra a watungi tamot, i a Nion ma i a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ikut ara taro tagun mot ka det nurnur.” Numugu ut o Iesu i sa tasman det ra ka det nurnur uni, ma i kai ra in usobor tari. ");
INSERT INTO kqw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma i watungi kai lena, “Iri i a kibino ra a watungi tamot lena, kataio in nan torom iau ra o Tita ken pitar a dekdek tano, sur in mur iau.” ");
INSERT INTO kqw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Io, a susut tagun anun a taro na ususer det tupukus pas gusuni, ma ka det muri mo. ");
INSERT INTO kqw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","O Iesu i watungi tan anun a noino ma aru nat na ususer lena, “Pepetlai, mot kai, mot nemi sur mot in nan tupukus mo gusun iau?” ");
INSERT INTO kqw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","O Saimon Pita i balu i lena, “Labino, met in nan mo torom osi? Uni anumi kut, a kum wasiso na nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Met sa nurnur ma met tasmani lena ui a Tene Tokodos anun o God. ");
INSERT INTO kqw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","O Iesu i watungi tandet lena, “A sa pilok pas mot, a noino ma aru, niko? Ikut ara tagun mot, i a turangon kut!” ");
INSERT INTO kqw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I wasiso un o Judas, a nutun o Saimon Iskariot, i ara tagun a noino ma aru nat na ususer, i ra in usobor tar o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Io, numur o Iesu i wan tuptupukus una kum tamtamon tong una papor Galili. Ke nem na wan tuptupukus tong una papor Judia, uni a ramano kum te Juda det epak sur det in um doko i. ");
INSERT INTO kqw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A kum bung na lotu anun a taro Juda, ra di watungi nama kum lamlabino bung na lotu na rumu na turturup, i sa milau. ");
INSERT INTO kqw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Io, a kum tistisin o Iesu det watungi tano lena, “I wakak sur un nan taginin ma un nan utong o Judia sur anum a taro na ususer det in tama a kum utna na ukisin ra un pami. ");
INSERT INTO kqw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kataio i ser pam eno a kum utna, ra i nemi sur a taro det in tasmani. U ser pam a kum utna ri, in wakak ra un pam puaso i sur a taro una rakrakon bual rop det in tasman ui!” ");
INSERT INTO kqw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A kum tistisino det wasiso lenri, uni det kai ka det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","O Iesu i watungi tandet lena, “Anung a du bung ke sot utmakai, sur an nan una kum lamlabino bung na lotu, ikut torom mot, anumot a kum du bung i langolango kut. ");
INSERT INTO kqw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A taro tagun a rakrakon bual ka det in nget mot, ikut det nget iau, uni a inanos det una nundet a kum sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mot, mot in nan usapat una kum lamlabino bung na lotu. Ikut iau, kan nan lakit sur a kum lamlabino bung na lotu ri, uni anung a du bung ke sot utmakai.” ");
INSERT INTO kqw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ra i sa wasiso taru, io, i kis sikot tong o Galili. ");
INSERT INTO kqw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ra a kum tistisin o Iesu det sa wan sur a kum lamlabino bung na lotu, io, numur o Iesu i mur det, ikut ke upuaso i torom a taro. I wan eno nanan kut. ");
INSERT INTO kqw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A ramano kum te Juda det sisio sur o Iesu una kum lamlabino bung na lotu, det iting lena, “A musano ri awai i?” ");
INSERT INTO kqw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A susut na taro det wasiso eno un o Iesu. Ara taro det watungi uni lena, “I ara wakak na musano,” ma ara taro kai det watungi lena, “Awu, i ben raro a taro.” ");
INSERT INTO kqw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ikut kataio i wasiso puaso uni, uni det ngaran a ramano kum taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ra det sa kis epotor una kum lamlabino bung na lotu, o Iesu i turpasi sur in ususer a taro una rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A ramano kum te Juda det kisin doko ra det watungi lena, “A musano ri ke etowo pas. Ikut i tasman petlan a kum utna ri?” ");
INSERT INTO kqw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","O Iesu i balu det lena, “Anung a kum etowo, ra a ususer a taro nami, ausur anung, anun o naro ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Osi ra i nem na mur a nemnem anun o God, in tasmani lena anung a kum etowo i wan tagai. I wan tagisapat tan o God, o a nuknuking kut. ");
INSERT INTO kqw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Osi ra i wasiso kut nama nuknukino, i nemi kut sur din ulabo pasi. Ikut iau, a nemi sur din ulabo pas o God ra i tulu ru iau urin. A wasiso nama lingmulus, ma katu torotoro i kis un iau. ");
INSERT INTO kqw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","O Moses i sa pitar tar a kum Warkurai tamot, ikut kataio tagun mot i tarom uni. Sur asau ra mot nem na um doko iau?” ");
INSERT INTO kqw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A kunur na taro det balu i lena, “A laulau na nion kura un ui. Osi i nem na um doko ui?” ");
INSERT INTO kqw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","O Iesu i balu det lena, “A pam ara utna na ukisin, ma mot rop mot kisin uni. ");
INSERT INTO kqw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O Moses i pitar tar a warkurai tamot sur mot in tok talilis a kum nat musano. Ikut a warkurai ri, ausur anun o Moses, a taro ut tagun numugu det turpasi. Ma a ramano kum du bung utkai mot tok talilis una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mot ser tok talilis una Bung na Sabat, sur gong di kutus a warkurai anun o Moses. Ra mot pami lenra, sur asau ra mot kankan torom iau ra a ulangolango pas a kudulano musano una Bung na Sabat? ");
INSERT INTO kqw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gong mot warkurai kut nama matamot, mot in warkurai nama warkurai ra i tokodos.” ");
INSERT INTO kqw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ara taro tagisapat o Jerusalem det iting lena, “I mo ri a musano ra det nem na um doko i? ");
INSERT INTO kqw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tama i, iri i tur ma i wasiso umatan a taro, ma ka det wasiso balu i. Kutiro a kum mugumugu det sa tasmani lena i a Karisito? ");
INSERT INTO kqw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ra a Karisito in nanpat, ka din tasmani lena in nanpat tagai. Ikut a musano ri dat tasmani kut anun a tamon.” ");
INSERT INTO kqw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","O Iesu i ususer utmakai una rumu na etabor, i wasiso nam in labino walngano ma i watungi lena, “Pepetlai, mot tasman mulus iau ut, ma a tamon kai a wan taguni? Ka wanpat urin una nuknuking. O naro ra i tulu ru iau, i watung a lingmulus ino. Ma mot, ka mot tasman o naro ra. ");
INSERT INTO kqw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ikut iau, a tasmani, uni a wan ut tagisapat tano, ma i ut i tulu ru iau.” ");
INSERT INTO kqw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Io, a kum te Juda det nemi lena det in pam ukai pasi, ikut kataio i pami, uni anun a du bung ke sot utmakai. ");
INSERT INTO kqw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A susut tagun a kunur na taro det nurnur uni, ra det watungi lena, “A musano ri i pam tar a susut na utna na ukisin. Kutiro a Karisito ut ri?” ");
INSERT INTO kqw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A kum Parisi det longoro a taro det waswasiso eno lenri un o Iesu, ra a kum lamlabino tene etabor torom o God, ma a kum Parisi, det tulu ru a kum tene tamtamabat tagun a rumu na etabor, sur det in pam ukai pasi. ");
INSERT INTO kqw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ra o Iesu i watungi tandet lena, “Iau kan kis suano i nin nisamot, an nan melet torom o naro ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mot in sisio sur iau, ikut ka mot in sio pas iau, ma ka mot in nan lar pasi kai una tamon ra an kis iai.” ");
INSERT INTO kqw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A ramano kum te Juda det ting etetalai det lena, “A musano ri in nan mo urai, ra ka dat in sio lar pasi? Pepetlai, in nan sur a kum tamon anun a taro Grik ra anundat a taro det kis iai? Kutiro in ususer mo a taro Grik? ");
INSERT INTO kqw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uni i watungi lena dat in sisio suri ma ka dat in sio pasi, ma ka dat in nan lar pasi kai una tamon ra in kis iai. Asau a kukuraina nun a wasiso ri?” ");
INSERT INTO kqw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A tintinip na bung ina kum lamlabino bung na lotu, i a labino bung sakit. Una bung ra, o Iesu i tur ma i wasiso nam in labino walngano, i watungi lena, “Osi ra i muruk, i wakak ra in nan torom iau ma in inum. ");
INSERT INTO kqw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Osi ra i nurnur un iau, ‘a kum danim na nilaun det in sal pat tagun anun a nilaun,’ elar nami ra di sa tumus tari una Buk Tabu.” ");
INSERT INTO kqw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Una wasiso ri, o Iesu i wasiso una Tokodos na Nion. Ka di pitar utmakai a Tokodos na Nion, uni o Iesu ke los utmakai anun a minamar. Numur, det ra det nurnur un o Iesu, din tabor det nami. ");
INSERT INTO kqw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ara taro tagun a kunur na taro ra det longoro a wasiso ri, det watungi lena, “A lingmulus ut, a musano ri, i a poropet ra o God i tulu ru i urin.” ");
INSERT INTO kqw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ara taro kai det watungi lena, “I, a Karisito.” Ma ara taro kai det watungi lena, “Awu. A Karisito ken nanpat tagitong o Galili. ");
INSERT INTO kqw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A Buk Tabu i watungi lena, a Karisito in nanpat tagun a kabotaro anun o Dewid. In nanpat tong o Betilem, a tamon ra numugu o Dewid i kis iai.” ");
INSERT INTO kqw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma a nuknukin a taro uni, ke takai. ");
INSERT INTO kqw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ara taro det nem na pam ukai i, ikut katu pasan det i pam sikoti. ");
INSERT INTO kqw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A kum tene tamtamabat tagun a rumu na etabor det milet melet, ra a kum lamlabino tene etabor torom o God det ting det lena, “Sur asau ra ka mot dat pas o Iesu urin?” ");
INSERT INTO kqw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A kum tene tamtamabat tagun a rumu na etabor det balu det lena, “Katutaio utmakai i ser wasiso elar nama musano ri!” ");
INSERT INTO kqw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","A kum Parisi det ting det lena, “Pepetlai, mot kai i sa ben raro pas mot? ");
INSERT INTO kqw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pepetlai, mot nuki lena taio tagun met a kum mugumugu ma a kum Parisi, i sa nurnur uni? Kalako! ");
INSERT INTO kqw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A kunur na taro ri, ra det nurnur un o Iesu, ka det tasman a kum Warkurai anun o Moses. A kankan anun o God i sa kis un det.” ");
INSERT INTO kqw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ara Parisi tagun det, a risano o Nikodimas, i ra numugu i wanpat pas torom o Iesu, i watungi tandet lena, ");
INSERT INTO kqw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Una nundat a Warkurai, ka dat in takun oros pas taio ra ka di longoro i utmakai. Din longoro mugu tari sur din tasman asau i pami.” ");
INSERT INTO kqw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Det balu i kut lena, “Ni, ui kai a te Galili ui? Un ususer una Buk Tabu ma un mananos uni lena a poropet ken nanpat tagitong o Galili.”  ");
INSERT INTO kqw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ra a taro rop det wan susuaro sur anundet a kum tamtamon. ");
INSERT INTO kqw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","O Iesu i wan toto usapat una Tangai na Oliw. ");
INSERT INTO kqw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Una kobot raut una bung numur, o Iesu i milet melet sur a rumu na etabor, ra a taro rop det wan tomo toromi. Ra i kis ma i ususer det. ");
INSERT INTO kqw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A kum tene ususer tagun a Warkurai, ma a kum Parisi det ben ruk ara ino torom o Iesu. A ino ra di pastorom pasi ra i pam a sakino tomo nam ara musano. Det ungongos pas a ino ra, sur in tur numugu umatan a taro. ");
INSERT INTO kqw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Det watungi tan o Iesu lena, “Tene Ususer, a ino ri di pastorom pasi ra i pam a sakino nam ara musano. ");
INSERT INTO kqw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Una Warkurai anun o Moses, ra tu ino in pami lenra, din duku doko i nama kum watat. Io ui, asau ra un watungi uni?” ");
INSERT INTO kqw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Det watungi lenri, uni det nem na lari kut o Iesu ra in watung tar tu wasiso, sur det in takuni nami. Ikut o Iesu i tudung piso, ra i tumtumus nam in kaskas na lamano una piso. ");
INSERT INTO kqw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Det iting liklik lenra, ra i tur ma i watungi tandet lena, “Osi tagun mot ra ke pam tar tu sakino petutna, io, in duku mugu a ino ri nam tu wat.” ");
INSERT INTO kqw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O Iesu i tudung piso melet, ra i tumtumus una piso. ");
INSERT INTO kqw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Det longoro tar a wasiso ri anun o Iesu, ra det rop det pirso. A kum takano det pirso mugu. Ra numur det rop det pirso taktakai. O Iesu mukut i kis tiro iai, der nama ino ra di utur tari nisano. ");
INSERT INTO kqw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","O Iesu i tur, ra i watungi tan a ino lena, “Le, det ra det takun ui, awai det mo? Kataio tagun det i takun ui?” ");
INSERT INTO kqw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A ino i balu i lena, “Awu.” Ra o Iesu i watungi tano lena, “Iau kai kan takun ui. Un nan kut, ma gong melet mo u pam a sakino.” ");
INSERT INTO kqw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","O Iesu i wasiso melet torom a taro, ra i watungi lena, “Iau a talapor anun a rakrakon bual. Osi ra i mur iau, in pam ukai a talapor na nilaun, ma ken nan melet una dumirum.” ");
INSERT INTO kqw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A kum Parisi det watungi tano lena, “Anum a wasiso talapor ke maut, uni ui ut, u wasiso talapor melet un ui.” ");
INSERT INTO kqw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ra o Iesu i balu det lena, “Ra iau ut an wasiso talapor un iau, anung a wasiso i lingmulus, uni a tasman a tamon ra a wan gusuni, ma a tamon ra an nan suri. Ikut mot, ka mot tasman a tamon ra a wan gusuni, ma a tamon ra an nan suri. ");
INSERT INTO kqw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mot, mot warkurai kut nama warkurai anun a taro, ma iau ka warkurai taio. ");
INSERT INTO kqw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ikut ra an warkurai taio, anung a warkurai i tokodos, uni, ausur iau kut a pami, mir ut nam o Tita, i ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Di sa tumus tari una numot a Warkurai lenri, ‘Ra lako ru anunder a wasiso i elar kut un tu utna, anunder a wasiso i lingmulus.’ ");
INSERT INTO kqw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iau ri a wasiso talapor un iau, ma o Tita ra i tulu ru iau urin, i kai i wasiso talapor un iau.” ");
INSERT INTO kqw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Det tingi lena, “Awai i o tamam?” O Iesu i balu det lena, “Ka mot tasman iau ma ka mot tasman kai o Tamang. Ra gunuk mot in tasman iau, io, mot in tasman o Tita kai.” ");
INSERT INTO kqw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","O Iesu i watung a wasiso ri tiro una rumu na etabor, una nubual ra di ser ubek a mani na etabor iai. Kataio i pam ukai i, uni anun a du bung ke sot utmakai. ");
INSERT INTO kqw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","O Iesu i watung meleti tan a taro lena, “An nan gusun mot, mot in sisio sur iau, ma mot in mat nam anumot a kum sakino petutna. A tamon ra an nan suri, ka mot in nan lar pas iai.” ");
INSERT INTO kqw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A ramano kum te Juda det lena, “Sur asau ra i watungi lena, ‘A tamon ra an nan suri, ka mot in nan lar pas iai’? Kutiro in um doko i duk?” ");
INSERT INTO kqw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","O Iesu i balu det lena, “Mot taginin ut mot upiso, ma iau, a wan ut tagisapat netes. Mot tagun a rakrakon bual, iau ausur tagun a rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iri a kibino ra a watungi tamot lena, mot in mat nam anumot a kum sakino petutna. Ra ka mot nurnur un iau lena iau ut i, ri iau, io, mot in mat nam anumot a kum sakino petutna.” ");
INSERT INTO kqw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma det tingi lena, “Osi ui?” O Iesu i balu det, “A sa inanos tar mot turpasi una nung a pinapam, tuk uniri. ");
INSERT INTO kqw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A susut na utna an watungi un mot ra an warkurai mot uni, uni i ra i tulu ru iau i lingmulus, ma iau, a inanos kut a taro una rakrakon bual una kum utna a longoro i gusuni.” ");
INSERT INTO kqw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ka det tasmani lena, o Iesu i wasiso torom det un o Tamano. ");
INSERT INTO kqw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ma o Iesu i watungi lena, “Ra mot in utur toto a Nutun a Musano usapat netes, mot in tasmani lena iau ut i ri iau, ma mot in tasmani kai lena ausur iau sot kut a papam, o Tita i ususer iau un asau a watungi. ");
INSERT INTO kqw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","I ra i tulu ru iau, i kis torom iau, ke wan gusun iau, uni a ser pam a kum utna ra i gas nami.” ");
INSERT INTO kqw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A susut ra det longoro a kum wasiso ri, det nurnur un o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","O Iesu i watungi torom a kum te Juda ra det nurnur uni lena, “Ra mot in tarom una nung a etowo, io, mot anung a taro na ususer mulus. ");
INSERT INTO kqw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma mot in tasman a lingmulus ino, ma a lingmulus ino in ulangolango mot.” ");
INSERT INTO kqw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Det balu o Iesu lena, “Met a kum nutnutun o Abaram, tuk uniri ka met papam na karabus torom taio. Sur asau ra u watungi lena a lingmulus ino in ulangolango met?” ");
INSERT INTO kqw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O Iesu i balu det lena, “A inanos mot nama lingmulus, osi ra i pam a sakino, i a karabus anun a sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A musano ra i papam na karabus kut torom tu kabo tamano, ken kis tukum torom det, ikut a nat ra o tamano ma o nano der usus pasi, i ra tagun der mulus. ");
INSERT INTO kqw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Io, ra a Nutun o God in ulangolango mot, mot in langolango mulus. ");
INSERT INTO kqw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A tasmani ut lena, mot a kum nutnutun o Abaram, ikut uniri mot lari sur mot in um doko iau, uni anung a wasiso ke kis un mot. ");
INSERT INTO kqw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A wasiso un asau ra a tama i tan o Tita, ma mot kai, mot pam asau ra mot longoro i tan a tamamot.” ");
INSERT INTO kqw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Det balu i lena, “Met, met tamano nam o Abaram.” O Iesu i balu det lena, “Ra mot tamano mulus nam o Abaram, io, mot in pam a kum utna ra o Abaram i pami. ");
INSERT INTO kqw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ikut mot nem na um doko iau, uni a inanos mot nama lingmulus ino ra a longoro i tan o God. O Abaram ke pam tu utna lenri. ");
INSERT INTO kqw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mot, mot pam ut a kum pinapam ra a tamamot i pami.” Det watungi tan o Iesu lena, “Ausur di usus oros tar met kut, a tamamet ut ra o God.” ");
INSERT INTO kqw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","O Iesu i watungi tandet lena, “Ra gunuk mot tamano mulus nam o God, io, mot in maris iau, uni a wan tagisapat tan o God, ra iri a kis nin. Ka wanpat urin una nung a nemnem, i ut i tulu ru iau. ");
INSERT INTO kqw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sur asau ra ka mot tasman lele anung a wasiso? Uni ka mot longoro lar pasi. ");
INSERT INTO kqw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A tamamot ra o Satan, ma mot nemi ut lena mot in mur anun a nemnem. Tagun numugu utmakai, i a tene um doko a taro, ma ke tasman a lingmulus ino, uni katu lingmulus i kis uni. Ra i watung a torotoro, i wasiso nam anun a wasiso mulus ut, uni i ut a tene torotoro ma a taman a torotoro. ");
INSERT INTO kqw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","A watung a lingmulus ino, iri i a kibino ra ka mot nurnur un iau. ");
INSERT INTO kqw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Osi tagun mot in takun sot pas iau un tu sakino petutna? A watung a lingmulus ino, ra ilai ra ka mot nurnur un iau? ");
INSERT INTO kqw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Osi ra anun o God i ser longoro a kum wasiso anun o God. Ikut mot, ka mot longoro i, uni ausur mot anun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A ramano kum te Juda det watungi tan o Iesu lena, “Met tasman mulusi lena ui a te Samaria, ma a laulau na nion kura un ui.” ");
INSERT INTO kqw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ra o Iesu i balu det lena, “Katu laulau na nion kuri un iau. A urur torom o Tita, ma mot, ka mot urur torom iau. ");
INSERT INTO kqw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ka pam a kum utna ri sur a taro det in ulabo pas iau uni, ikut ara sot kut, a tene warkurai, i ulabo pas iau. ");
INSERT INTO kqw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A inanos mot nama lingmulus, osi ra i tarom una nung a wasiso, ken mat.” ");
INSERT INTO kqw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A ramano kum te Juda det watungi tano lena, “Uniri met tasman mulus ui lena a laulau na nion kura un ui! O Abaram i sa mat, ma a kum poropet kai det sa mat, ikut ui, u watungi lena osi ra i tarom una num a wasiso ken mat. ");
INSERT INTO kqw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Pepetlai, u nuki lena ui u labo taun a tamamet o Abaram? O Abaram i sa mat, ma a ramano kum poropet kai det sa mat. U nuki lena ui osi na ngas na musano ui?” ");
INSERT INTO kqw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O Iesu i balu det lena,“Ra an ulabo melet pas iau ut, anung a wasiso na ulabo ri ke gas un tu utna. Ikut o Tita ut i ulabo pas iau, i ra mot watungi lena i anumot a God. ");
INSERT INTO kqw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mot, ka mot tasman o God, ikut iau, a tasmani. Ra an watungi lena ka tasmani, iau kai an tene torotoro elar nam mot. A tasman o God, ma a tartarom una nun a wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A tamamot o Abaram i gas sur in tama anung a inawan pat. I tama i, ra i gas doko uni.” ");
INSERT INTO kqw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A kum te Juda det watungi tano lena, “Ke limo na noino kilalo utmakai una nilaun anum. Ilai ra u watungi lena, u sa tama tar o Abaram?” ");
INSERT INTO kqw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O Iesu i balu det lena, “A inanos mot nama lingmulus, numugu ra ka di usus utmakai o Abaram, iau a sa kis mugu taru.” ");
INSERT INTO kqw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ra det los watat pas sur det in dukuduku o Iesu nami, ikut i parau ra i wan gusun a rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ra o Iesu i wan nanan, i tama pas ara musano a pulu. O nano i usus pasi, i sa pulu taru. ");
INSERT INTO kqw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A kum nat na ususer det tingi lena, “Tene Ususer, sur asau ra di usus pasi, i sa pulu? Osi mo i pam a sakino petutna, i ut, o, o tamano ma o nano?” ");
INSERT INTO kqw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","O Iesu i balu det lena, “A musano ri ke pam tar tu sakino petutna, o tamano ma o nano kai awu. I pulu kut sur a taro det in tama a dekdekin o God uni. ");
INSERT INTO kqw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I wakak sur dat in pam ut a kum pinapam anun o naro ra i tulu ru iau urin ra i waspi utmakai. Ra i sa mirum, kataio melet mo in pet lar pasi sur in papam. ");
INSERT INTO kqw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ra a kis nin upiso, iau a talapor anun a rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O Iesu i sa watung tari lenri, ra i ibis taru una piso, i gisgis pas a ibisino tomo nama piso, ra i talus arin matan a pulu nami. ");
INSERT INTO kqw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O Iesu i watungi tano lena, “Un nan, ma un gos pas arin matam una kabopolo Siloam. ” (Siloam a kukuraino di tulu i.) Io, i wan, ra i gos pas arin matano. Ra i milet, arin matano der sa tamtama. ");
INSERT INTO kqw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A kum paspasano, ma a taro ra det tamtama i ra i ser sarsaring utna det iting lena, “Kutiro a musano ra i kiskis ma i ser sarsaring utna, niko?” ");
INSERT INTO kqw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ara taro det watungi lena, “I ut ra.” Ara taro kai det watungi lena, “Awu, i tamtama elar kut nama musano ra.” Io, i ut i watungi lena, “Iau ut ri.” ");
INSERT INTO kqw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Det tingi lena, “Di utamtama petlan pas arin matam?” ");
INSERT INTO kqw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I balu det lena, “A musano ra di watungi lena o Iesu i gisgis pas a ibisino nama piso ra i talus tar arin matang nami. Io, i tulu ru iau ra i watungi lena, ‘Un nan utong una kabopolo Siloam sur un gos pas arin matam.’ Io, a wan ma a gos pas arin matang, ra a tamtama mut.” ");
INSERT INTO kqw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Det tingi lena, “Ma i, awai i?” A musano ra i balu det lena, “Ka tasmani.” ");
INSERT INTO kqw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Det ben pas a musano ra numugu i pulu torom a kum Parisi, ");
INSERT INTO kqw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","uni o Iesu i gisgis pas a ibisino nama piso ma i utamtama pas a pulu una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A kum Parisi det ting melet a musano lena, “Di utamtama petlan pas ui?” I balu det lena, “I talus tar arin matang nama piso ra i gisgis tari nama ibisino, a gos pasi, ra a tamtama mut.” ");
INSERT INTO kqw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A ramano kum Parisi det watungi lena, “A musano ra i pam a utna ri, i ausur tagun o God, uni i papam una Bung na Sabat.” A ramano kai det watungi lena, “Ra a musano ri a sakino musano, in pam petlan a kum utna na ukisin ri?” Ra a nuknukindet ke takai uni. ");
INSERT INTO kqw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ara dino melet a kum Parisi det ting a musano ra lena, “Asau un watungi una musano ra i utamtama pas ui?” I balu det lena, “I ara poropet.” ");
INSERT INTO kqw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A ramano kum te Juda ka det nurnur lena a musano ri numugu i pulu ma di sa utamtama pasi. Ra det itula pasi ut o tamano ma o nano, ma det ting der lena, ");
INSERT INTO kqw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“A nutumur ut ri? I ra mur watungi lena mur usus pasi, i sa pulu? I tamtama pepetlai?” ");
INSERT INTO kqw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","O tamano ma o nano der balu det lena, “Mir tasmani lena a nutumir ut ri, ma mir tasmani lena mir usus pasi, i sa pulu. ");
INSERT INTO kqw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ikut ka mir tasmani ra i tamtama pepetlai, ma ka mir tasmani kai osi ra i utamtama pasi. I sa tarai na musano, mot in tingi, i ut in wasiso talapor uni.” ");
INSERT INTO kqw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","O tamano ma o nano der wasiso lenri, uni der ngaran a kum te Juda, ra det watungi lena, ra taio in nurnur un o Iesu lena i a Karisito, din turbat ru i gusun a rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iri i a kibino ra o tamano ma o nano der watungi lena, “I sa tarai na musano, mot in tingi.” ");
INSERT INTO kqw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Det ben melet pas a musano ra di usus pasi, i sa pulu, ma det watungi tano lena, “Un liliman umatan o God ra anum a wasiso i lingmulus ut! Met tasmani lena a musano ra i utamtama pas ui, a tene sakino.” ");
INSERT INTO kqw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","I balu det lena, “Ka tasmani ra i a tene sakino, o awu. Ara utna kut ra a tasmani: Numugu a pulu, ma uniri a sa tamtama.” ");
INSERT INTO kqw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Det tingi lena, “Asau ra i pami un ui? Ma i utamtama petlan pas ui?” ");
INSERT INTO kqw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I balu det lena, “A sa watung tari tamot, ma ka mot longoro i. Sur asau ra mot nem na longoro meleti? Kanapi mot kai mot nemi sur mot anun a kum nat na ususer?” ");
INSERT INTO kqw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Det watung laulau i, ma det watungi uni lena, “Ui anun a nat na ususer, ikut met a kum nat na ususer anun o Moses. ");
INSERT INTO kqw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Met, met tasmani lena o God i wasiso torom o Moses, ikut a musano ra, ka met tasmani ra i wan tagai.” ");
INSERT INTO kqw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A musano i balu det lena, “Ai, a utna na ukisin! Ka mot tasmani ra i wan tagai, ikut i sa utamtama pas iau. ");
INSERT INTO kqw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dat tasmani lena o God ken longoro a niaring anun a kum tene sakino, in longoro det kut ra det ru i ma det tartarom una nun a nemnem. ");
INSERT INTO kqw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Turpasi una turturkibin a rakrakon bual tuk uniri, ka di tasman tar taio ra in utamtama pas arin matan tu pulu, ra di usus pasi, i sa pulu. ");
INSERT INTO kqw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ra a musano ri ausur tagun o God ken pam lar pas tu utna.” ");
INSERT INTO kqw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Det balu i lena, “Di usus pas ui una sakino petutna, ma ui, u nemi lena un ususer met!” Io, det lakro ru i mut gusun a rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","O Iesu i longoro i lena, di sa lu ru tar a musano ra, ra i sisio suri, ma i sio pasi ra i tingi lena, “U nurnur ut una Nutun a Musano?” ");
INSERT INTO kqw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I balu i lena, “Labino, un inanos iau, osi ra a Nutun a Musano, sur an nurnur uni.” ");
INSERT INTO kqw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O Iesu i watungi tano lena, “Iri u sa tama i, iau ut ri a wasiso tam.” ");
INSERT INTO kqw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A musano ra i watungi lena, “Labino, a nurnur un ui!” I kis butkeke ma i lotu toromi. ");
INSERT INTO kqw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","O Iesu i watungi lena, “A wanpat urin una rakrakon bual nama warkurai, sur det ra det pulu det in tamtama, ma det ra det tamtama det in pulu.” ");
INSERT INTO kqw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A ramano kum Parisi ra det tur tomo nami, det longoro a wasiso ri, ra det tingi lena, “U nuki lena met kai met pulu?” ");
INSERT INTO kqw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I balu det lena, “Ra gunuk mot pulu, kataio in takun mot un tu sakino petutna. Ikut iri mot watungi lena mot tamtama, io, anumot a sakino petutna i kis utmakai.” ");
INSERT INTO kqw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","O Iesu i watungi lena, “A inanos mot nama lingmulus, i ra ke ruk una matansako tagun in noworo na sipsip, ma i ka tito kut unarumu, i a tene wolong ma a tene ras oros kut a kum utna. ");
INSERT INTO kqw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ikut a musano ra i ruk tokodos una matansako, i a tene tamtamabat mulus anun a kum sipsip. ");
INSERT INTO kqw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A tene tamtamabat ina matansako in papos saro tari sur in ruk. A kum sipsip det longoro lele in nalngano. I ser kabo det nama kum risandet ma i ser ben pirso det. ");
INSERT INTO kqw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","In ben pirso rop pas anun a kum sipsip, ra in mugu pas det ma det in muri, uni det longoro lele in nalngano. ");
INSERT INTO kqw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ka det in mur tu usiro, det in kalabor gisen kut gusuni, uni ka det longoro lele in nalngano.” ");
INSERT INTO kqw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","O Iesu i watung a wasiso elelar ri tandet, ikut ka det tasman asau ra i wasiso uni. ");
INSERT INTO kqw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Io, o Iesu i watung meleti lena, “A inanos mot nama lingmulus, iau a matansako anun a kum sipsip. ");
INSERT INTO kqw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Det rop ra det wanpat mugu tang, a kum tene wolong ma a kum tene ras oros pas a kum utna, ma a kum sipsip ka det longoro det. ");
INSERT INTO kqw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iau a matansako, osi ra i ruk uni, din ulauni. In ruk ma in pirso ma in etorom kut ana utna na inangon. ");
INSERT INTO kqw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A tene wolong i ruk kut sur in wolong, ma in um doko a kum sipsip ma in banlaulau det. Ikut iau, a wanpat sur det in utur ukai a nilaun, a nilaun ra i bukus nama wakakino. ");
INSERT INTO kqw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iau a wakak na tene tamtamabat anun a kum sipsip. A pitar anung a nilaun sur an matbat det. ");
INSERT INTO kqw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","A musano ra di doki kut, ausur a tene tamtamabat mulus anun a kum sipsip, ma a kum sipsip ausur anunu. Ra in tama pas a ngalngalia na pap in nanpat, in kalabor pas gusun a kum sipsip, uni i papam kut sur a mani, ma ke maris a kum sipsip. Ma a ngalngalia na pap in karkarot det ma in lu sarara ru det. ");
INSERT INTO kqw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iau a wakak na tene tamtamabat anun a kum sipsip. A tasman anung a kum sipsip, ma anung a kum sipsip kai det tasman iau, ");
INSERT INTO kqw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","elar nam o Tita i tasman iau, ma a tasman o Tita, ma a pitar anung a nilaun sur an matbat det. ");
INSERT INTO kqw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anung a ramano kum sipsip kai, ka det kis un in noworo na sipsip ri. An ben pas det utkai, ma det in longoro in nalngang, sur det rop det in kis kut un in teken noworo, ma ara sot kut in tene tamtamabat anundet. ");
INSERT INTO kqw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“O Tita i maris mulus iau, uni iau ut a pitar anung a nilaun, sur numur an los melet pasi. ");
INSERT INTO kqw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kataio in rakon ru anung a nilaun, iau ut an pitari. Iau ut a pam a warkurai sur an pitari, ma iau ut a pam a warkurai sur an los melet pasi. Iri i a pinapam ra o Tita i tulu ru iau sur an pami.” ");
INSERT INTO kqw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A kum te Juda det tapagol una kum wasiso ri anun o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A susut gusun det, det watungi lena, “A laulau na nion kura uni, ma i sa toboroboro. Asau ra mot longoro i suri?” ");
INSERT INTO kqw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ikut ara taro det watungi lena, “Ausur a ngas na wasiso ri anun taio ra a laulau na nion kura uni. Pepetlai, a laulau na nion in pet lar pasi sur in utamtama a taro ra det pulu?” ");
INSERT INTO kqw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Io, numur det ukinalong a labino bung na lotu sur det in nuk melet pas a bung ra det papos a rumu na etabor uni. Det ukinalong a labino bung na lotu ri sapat o Jerusalem epotor una kum kalang na kotokoto. ");
INSERT INTO kqw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","O Iesu i wan nanan una parada ra di watungi nama parada anun o Solomon, una rumu na etabor. ");
INSERT INTO kqw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A kum te Juda det tur talilis pas o Iesu, ma det tingi lena, “Un nangisin mo un inanos mulus met? Ra ui a Karisito, un inanos kapo met.” ");
INSERT INTO kqw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ra o Iesu i balu det lena, “A sa watung tari tamot, ikut ka mot nurnur. A kum pinapam ra a pami una risan o Tita, det wasiso talapor un iau. ");
INSERT INTO kqw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ikut ka mot nurnur, uni ausur mot anung a kum sipsip. ");
INSERT INTO kqw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Anung a kum sipsip det ser longoro in nalngang. A tasman det, ma det murmur iau. ");
INSERT INTO kqw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma a pitar a nilaun tukum tandet, ma ka det in iru. Ma kataio in ras ru det gusun a lamang. ");
INSERT INTO kqw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","O Tita ra i pitar tar det tang, i labo taun a kum utna rop, ma kataio in ras ru det gusun a laman o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mir nam o Tita, mir takai kut.” ");
INSERT INTO kqw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A kum te Juda det los watat melet sur det in duku doko o Iesu nami. ");
INSERT INTO kqw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","O Iesu i watungi tandet lena, “A sa pam ese tar a susut na utna na ukisin umatamot, ra o Tita i pitar tari tang sur an pami. Asi na utna tagun a kum utna na ukisin ri mot nem na duku iau uni?” ");
INSERT INTO kqw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Det balu i lena, “Met nem na duku ui, ausur un tu utna na ukisin ra u pami, ikut met nem na duku ui uni u watung laulau o God! Ui a musano kut ui, ra u watungi lena ui o God.” ");
INSERT INTO kqw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O Iesu i watungi tandet lena, “Mot sa tasmani ut lena di sa tumus tari una numot a kum Warkurai ra o God i lena, ‘Mot a kum god’. ");
INSERT INTO kqw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","I watung det lena det a kum god, det ra di pitar tar a wasiso anun o God tandet. Ma kataio in pet lar pasi sur in rakon ru a wasiso na Buk Tabu. ");
INSERT INTO kqw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma iau, o Tita ut i pilok pas iau, ma i tulu ru iau urin una rakrakon bual. Io, ilai ra mot takun iau lena a watung laulau o God uni a watungi lena iau a Nutun o God? ");
INSERT INTO kqw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ra kan pam a kum pinapam anun o Tita, io, gong mot nurnur un iau. ");
INSERT INTO kqw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Uniri a pam ut anun a kum pinapam, ikut ka mot nurnur un iau. Mot in nurnur una kum pinapam a pami, sur mot in tasmani lena o Tita kuri un iau, ma iau kura un o Tita.” ");
INSERT INTO kqw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ara dino melet det nem na pam ukai o Iesu, ikut i wan eno pas kut gusun det. ");
INSERT INTO kqw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O Iesu i wolos melet a danim Jodan sur a nubual ra numugu o Jon i baptaiso iai, ra i kis tiro. ");
INSERT INTO kqw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A susut na taro det wan torom o Iesu ma det wasiso etetalai torom det lena, “O Jon ke pam tu utna na ukisin, ikut a kum wasiso rop i sa watung tari una musano ri, i lingmulus sakit.” ");
INSERT INTO kqw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma a susut na taro tiro iai det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ara musano tagitong o Betani, a risano o Lasarus, i misait. Detul tisino nam o Maria mo Mata. O Maria ri, i ra i lingis tar in nokoto na polo sangsangnain una aru kikin a Labino, ma i us sengesenge der nama iwu na lorino. ");
INSERT INTO kqw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","O Maria der sinoino nam o Mata der pitar ru a wasiso sur o Iesu lenri, “Labino, a pasam, ra u ser maris doko i, i misait.” ");
INSERT INTO kqw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","O Iesu i longoro i, ra i watungi lena, “Ausur o Lasarus in mat una misait ri. I misait kut, sur din tama a minamar anun o God, ma sur din mar kai a Nutun o God nami.” ");
INSERT INTO kqw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","O Iesu i maris o Mata ma a tisinoino o Maria ma a tisinder o Lasarus. ");
INSERT INTO kqw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ikut ra i longoro i lena o Lasarus i misait, i kis melet pas ut aru bung una tamon ra i kis iai. ");
INSERT INTO kqw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Numur o Iesu i inanos a kum nat na ususer lena, “Dat in milet melet utong una papor Judia.” ");
INSERT INTO kqw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma det watungi tano lena, “Ai, Tene Ususer, urabung kut a kum te Juda det nem na duku doko ui, ra uniri u nem na milet melet kut utong?” ");
INSERT INTO kqw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","O Iesu i watungi lena, “Ara bung i elar nama noino ma aru du bung, niko? Ra taio i wanan una suan ken tutuka, uni i tamtama una talapor ina rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ikut ra taio i wanan una mirum in tutuka, uni kalako talapor.” ");
INSERT INTO kqw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","O Iesu i watung tar a wasiso ri tandet, ra numur i lena, “A pasandat o Lasarus i sa inep dumun, ma an nan sur an wangun pasi.” ");
INSERT INTO kqw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A kum nat na ususer det balu i lena, “Labino, ra i inep dumun kut, in langolango melet.” ");
INSERT INTO kqw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","O Iesu i wasiso una minat ino Lasarus, ikut a kum nat na ususer det nuki lena o Lasarus i inep dumun kut. ");
INSERT INTO kqw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Io, o Iesu i watung palosi maragom tandet lena, “O Lasarus i sa mat. ");
INSERT INTO kqw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ra iau, a gas un mot ra ka kis tong, sur mot in nurnur. Io, uniri dat in nan mo toromi.” ");
INSERT INTO kqw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","O Tomas ra di watungi kai nama kasango i watungi tan a kum nat na ususer lena, “Dat in nan tomo sur dat kai dat in mat tomo nami.” ");
INSERT INTO kqw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","O Iesu i wanpat, ra i longoro i lena di sa uruk ru tar a minat ino Lasarus una kulam na minat, ma i sa wat na bung bat tari. ");
INSERT INTO kqw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A tamon ra, o Betani, i milau kut o Jerusalem, i elar kut nama tulu kilomita, ");
INSERT INTO kqw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ra a susut na te Juda det wanpat torom o Mata ma o Maria sur det in kis umaut der una tisinder ra i mat. ");
INSERT INTO kqw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","O Mata i longoro i lena o Iesu kura mo i wan nanan urin, ra i pirso, i wan barato i. Ikut o Maria i kis utmakai tiro urumu. ");
INSERT INTO kqw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","O Mata i watungi tan o Iesu lena, “Labino, ra gunuk un kis ut nin, o tisinglik ken mat. ");
INSERT INTO kqw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ikut a tasmani lena, ra un saring o God sur tu utna uniri, in pitari kut tam.” ");
INSERT INTO kqw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","O Iesu i watungi tano lena, “O tisimlik in laun melet kut.” ");
INSERT INTO kqw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","O Mata i balu i lena, “A tasmani lena in laun melet una bung ra o God in ukatutur melet pas a taro gusun a minat.” ");
INSERT INTO kqw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","O Iesu i watungi tano lena, “Iau a nilaun melet gusun a minat, ma iau a nilaun mulus. I ra i nurnur un iau, ra in mat, in laun melet, ");
INSERT INTO kqw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma i ra i laun ma i nurnur un iau, ken mat. U nurnur ut una wasiso ri?” ");
INSERT INTO kqw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","O Mata i balu i lena, “Ma Labino, a nurnur lena ui a Karisito a Nutun o God, i ra o God i tulu ru i urin una rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Numur ra o Mata i sa watung tari lenri, i milet melet ma i kabo eno pas a tisinoino o Maria, ma i inanosi lena, “A Tene Ususer i sa wanpat ma i iting sur ui.” ");
INSERT INTO kqw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","O Maria i longoro i lenri, ra i pirso lakit ma i wan toromi. ");
INSERT INTO kqw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","O Iesu ke wanpat utmakai una tamon, i kis utmakai una nubual ra o Mata i barato pasi iai. ");
INSERT INTO kqw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A kum te Juda ra det kis tomo nam o Maria tiro urumu sur det in umaromi, det tama i ra i pirso lakit pas gusun det unago utamon, ra det muri. Uni det nuki lena in nan sur a kulam na minat sur in domos iai. ");
INSERT INTO kqw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","O Maria i wanpat una nubual ra o Iesu i kis iai, ra i tama pasi, i kis butkeke taru numugu nisano, ma i watungi lena, “Labino, ra gunuk un kis ut nin, a tisinglik ken mat.” ");
INSERT INTO kqw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","O Iesu i tama o Maria tomo nama kum te Juda ra det wan tomo nami det domos nanan, ra i nuknuk doko una niono ma in balano i tupunuk. ");
INSERT INTO kqw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O Iesu i ting det lena, “Kura mot ubek tar a minatino awai?” Det balu i lena, “Labino, wan urin sur un tama i.” ");
INSERT INTO kqw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Io, o Iesu i tangis. ");
INSERT INTO kqw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A kum te Juda det watungi lena, “Mot tama i, i maris doko i!” ");
INSERT INTO kqw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ikut ara taro tagun det, det watungi lena, “I utamtama pas a matan a pulu, ilai ra ke ulangolango pasi kai a musano ri, sur gong i mat?” ");
INSERT INTO kqw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","In balano Iesu i maut doko, ra i wanpat nisan a kulam na minat. A kulam na minat ra, a mato kura tiro una papor wat, ma di ubek bat tari nama labino wat. ");
INSERT INTO kqw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O Iesu i watungi tandet, “Mot in bulus karai ru a wat.” Ra o Mata, a tisin a musano ra i mat, i balu i lena, “Labino, i sa singino, uni i sa wat na bung bat tari!” ");
INSERT INTO kqw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","O Iesu i watungi tano lena, “Pepetlai, ka watung tari tam lena, ra un nurnur un tama a minamar anun o God?” ");
INSERT INTO kqw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Io, det bulus karai ru a wat. O Iesu i tatado usapat netes, ra i watungi lena, “Tita, a watung wakak torom ui, uni u sa longoro iau. ");
INSERT INTO kqw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A tasmani lena u ser longoro iau, ikut a wasiso lenri, kibino una taro ri, sur det in nurnur lena ui u tulu ru iau.” ");
INSERT INTO kqw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","I sa watung tari lenri, ra i kakabo nam in labino walngano lena, “Lasarus, un pirso!” ");
INSERT INTO kqw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","O Lasarus i pirso, tomo nama kum malu ra di rau tar aru lamano ma aru kikino nami, ma ara du malu kai ra di pulusbat tar in masarino nami. O Iesu i watungi tandet lena, “Mot in palos ru a kum malu na minat gusuni sur in nan.” ");
INSERT INTO kqw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A susut na te Juda ra det kis nisan o Maria, det tama a utna ri o Iesu i pami, ma det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ikut ara taro gusun det ka det nurnur, ra det wan torom a kum Parisi ma det inanos det una utna ri o Iesu i pami. ");
INSERT INTO kqw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A kum lamlabino tene etabor torom o God, ma a kum Parisi det kabo tomo a taro na kiwung, ma det watungi lena, “Asau dat in pami? A musano ri i pam a susut na utna na ukisin. ");
INSERT INTO kqw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ra dat in madek ru i, a taro rop det in nurnur uni, ma a kum taro na inaim tagitong o Rom det in nanpat ma det in rege ru anundat a rumu na etabor ma det in rakon ru anundat a gapman kai.” ");
INSERT INTO kqw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ara tagun det a risano o Kaiapas, a mugumugu na tene etabor torom o God una kilalo ra, i watungi lena, “Ai, ka mot mananos. ");
INSERT INTO kqw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ka mot tasmani lena in wakak torom mot ra taio in matbat a taro, sur gong dat a taro Juda rop dat in iru.” ");
INSERT INTO kqw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ausur i watung orosi kut. I wasiso na poropet lenra, uni i a mugumugu na tene etabor anun o God una kilalo ra. I wasiso un o Iesu lena in mat una taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma ausur in mat un det kut, una taro rop utkai anun o God ra det kis una ramano kum tamon gisen, sur in ben tomo pas det ma det in takai kut. ");
INSERT INTO kqw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Una bung ut ra, a kum mugumugu anun a taro Juda det turpas a wasiso sur lako kum kisapi sur det in um doko o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lenra o Iesu ke ser wan mo umatandet. I wan pas tagitiro, sur a tamon Eparaim ra i milau una nubual kalako taro uni, ra det kis tiro nam anun a kum nat na ususer. ");
INSERT INTO kqw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A labino bung na lotu na Wanlakai anun a taro Juda i sa milau, ra a susut na taro tagun a kum tamon det mugu usapat o Jerusalem, sur det in utalapor mugu pas det umatan o God ra ka di pam utmakai a labino bung na lotu, elar nama ngasino tagun anundet a lotu. ");
INSERT INTO kqw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tiro iai, det sisio sur o Iesu. Det tur tomo taru una rumu na etabor, ra det ting etetalai det lena, “Asau mot nuki, in nan ut urin una labino bung na lotu, o awu?” ");
INSERT INTO kqw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A kum lamlabino tene etabor ma a kum Parisi det sa itula taru lena, ra taio i sa tama tar o Iesu, in inanos lakit uni ra kura i kis awai, sur det in pam ukai pasi. ");
INSERT INTO kqw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A wonom na bung utmakai numugu tan a labino bung na lotu na Wanlakai, o Iesu i wanpat utong o Betani, a tamon anun o Lasarus, a musano ra o Iesu i ulaun melet pasi gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ra det pam a inangon tiro sur u ugasgas o Iesu. O Mata i wapor utna torom det, ma o Lasarus i ara tagun det ra det kis tomo nam o Iesu una inangon. ");
INSERT INTO kqw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ra o Maria i los pas in nokoto na polo sangsangnain di watungi nama nad, ra a matano i ka doko. I lingisi una ru kikin o Iesu ma i usi nama iwu na lorino. Ma a sangnain ino, i ubukus pas a rumu ra. ");
INSERT INTO kqw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ara gusun a kum nat na ususer anun o Iesu, o Judas Iskariot, i ra in usobor tar o Iesu, i watungi lena, ");
INSERT INTO kqw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sur asau ra ka di siuru in nokoto na polo sangsangnain ri sur lako tulu mar na denari sur din tabor a kum sibo na taro nami?” ");
INSERT INTO kqw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O Judas ke maris a sibo na taro, awu. I watungi lenri uni i ser tamtamabat anundet a mani ma i ser loslos eno i, uni i a tene wolong. ");
INSERT INTO kqw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","O Iesu i longoro a wasiso anun o Judas, ra i watungi lena, “Madek ru a ino ri, uni i sa pam tar a pinapam ri un iau sur a bung ra an mat ma din uruk a minating una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A kum sibo na taro det in laun bolbolos tomo ut nam mot. Ikut iau, kan kis tukum nisamot. ");
INSERT INTO kqw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A kunur na taro tagun a taro Juda det longoro i lena o Iesu kurong i o Betani, ra det wan utong. Ausur det wan sur det in tama o Iesu kut, det wan utkai sur det in tama o Lasarus, i ra o Iesu i sa ulaun pasi gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Io, a kum lamlabino tene etabor det epak sur det in um doko o Lasarus utkai. ");
INSERT INTO kqw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Uni a susut na te Juda det wan gusun det ma det nurnur un o Iesu, i kibino un o Lasarus. ");
INSERT INTO kqw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Una bung numur, a labino kunur na taro ra det wanpat sur a labino bung na lotu na Wanlakai, det longoro i lena o Iesu kai i sa wan nanan usapat o Jerusalem. ");
INSERT INTO kqw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Io, det los pas a kum turunu baibai ma det wan sur det in barato o Iesu nami. Ra det kukukuk lena, “Osana! Dat in watung ulabo pas o naro ra i wanpat nama risan a Labino! Dat in watung ulabo pas a king anun a taro Israel!” ");
INSERT INTO kqw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","O Iesu i sio pas a dongki, ra i kis taru netes uni, elar nama Buk Tabu i sa watung tari uni lena, ");
INSERT INTO kqw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“A taro Sion, gong mot ngara. Tama i, anumot a king i wanpat nanan, i kis una matok na dongki.” ");
INSERT INTO kqw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A kum nat na ususer anun o Iesu ka det tasman lele i lena a kum utna ri di sa tumus mugu tari una Buk Tabu. Ikut ra o Iesu i sa kis una nuna minamar, io det tasmani maragom lena di sa tumus tar a kum utna ri un o Iesu, ma di sa pam tari kai a kum utna ri uni. ");
INSERT INTO kqw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A susut na taro ra det tur tomo nam o Iesu una bung ra i kabo pirso pas o Lasarus tagun a kulam na minat ma i ulaun pasi, det inanos nanan nami. ");
INSERT INTO kqw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ra a susut na taro det wan sur det in barato o Iesu, uni det sa longoro tar a wasiso una utna na ukisin ri. ");
INSERT INTO kqw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A kum Parisi det wasiso etetalai torom det lena, “Mot tama i, ka dat in pam lar pas tu utna ra dat nem na pami uni. Uni a taro rop det sa muri.” ");
INSERT INTO kqw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A ramano kum te Grik kai det wan usapat o Jerusalem una labino bung na lotu na Wanlakai, sur det in lotu. ");
INSERT INTO kqw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ra det wan torom o Pilip, a te Betsaida. O Betsaida ara tamon una papor Galili. Ma det watungi tano lena, “Le, met nemi sur met in tama o Iesu.” ");
INSERT INTO kqw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","O Pilip i wan ra i inanos o Endru. Io, der wan ma der inanos tar o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ra o Iesu i watungi tander lena, “A du bung i sa wanpat sur o God in mar a Nutun a Musano. ");
INSERT INTO kqw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A inanos mot nama lingmulus, ra in niwino wit ken puku taru una piso, ma ken mat pas, in kis len taru ut ra, in rene kut. Ikut ra in mat pas, in wu lako susut na wino. ");
INSERT INTO kqw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","I ra i maris anun a nilaun, in iru, ma i ra ke maris bat anun a nilaun nin una rakrakon bual, in utur ukai a nilaun sur a nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ra taio i nemi sur iau anun a Labino, i wakak sur in mur iau, ma i anung a tultul ra in kis tomo nam iau una dino ra an kis iai. Osi ra i papam torom iau, o Tita in ulabo pasi. ");
INSERT INTO kqw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Uniri in balang i maut doko. Asau mo ra an len? Pepetlai, an watungi lena, ‘Tita, un ulaun iau gusun a du bung ri’? Awu, kan wararing lenri, uni, i kutri, i a kibino ra a wan suri urin, sur an taramo a ngunungut una bung ri. ");
INSERT INTO kqw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tita, un ulabo pas a risam!” Io, in nalngan ara tagisapat una lagit i watungi lena, “A sa ulabo tari, ma an ulabo meleti ut.” ");
INSERT INTO kqw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A kunur na taro ra det tur taru tiro det longoro i. Ara taro det watungi lena a pungpugur, ma ara taro kai det watungi lena, “Ara ensel i wasiso toromi.” ");
INSERT INTO kqw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ikut o Iesu ut i watungi lena, “In nalngan ara ri, ausur i wasiso sur in warut iau, awu, i wasiso sur in warut mot ut. ");
INSERT INTO kqw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A du bung ri din warkurai a rakrakon bual. Uniri din lakro ru a labino anun a rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ikut iau, ra din utur toto pas iau taginin upiso usapat netes, an dat pas a taro rop torom iau.” ");
INSERT INTO kqw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I watungi lenri sur in utalapori lena in mat pepetlai. ");
INSERT INTO kqw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A kunur na taro ra, det watungi tano lena, “Met longoro i tagun a Buk na Warkurai lena, a Karisito in kis tukum. Sur asau ra u watungi lena din utur toto pas a Nutun a Musano usapat netes? Osi ra a Nutun a Musano?” ");
INSERT INTO kqw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","O Iesu i watungi tandet lena, “A talapor ken kis siun mo torom mot. Ra a talapor i kis utmakai torom mot, mot nan tuptupukus. Numur a dumirum in pulusbat mot. I ra i wanan una dumirum, ken tasmani lena in nan urai. ");
INSERT INTO kqw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ra a talapor i kis utmakai torom mot, mot in nurnur uni, sur mot a kum nutun a talapor.” Ra o Iesu i sa watung rop tar a wasiso ri, i wan eno pas gusun det. ");
INSERT INTO kqw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","O Iesu i sa pam tar a susut na utna na ukisin umatandet, ikut ka det nurnur uni, ");
INSERT INTO kqw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","sur a wasiso ra a poropet Aisaia i wasiso taru uni in nanpat mulus. I watungi lena, “Labino, osi i nurnur una kum wasiso ra met watungi? Ma osi ra di sa ese tar a dekdekin a Labino tano?” ");
INSERT INTO kqw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Ma o Aisaia i sa watung tari kai lena, “O God i sa upulu bat ru a kum matmatandet, ma i sa udumun bat ru a kum nuknukindet, sur gong det tamtama nama kum matmatandet, ma gong det tasman lele i una kum nuknukindet, ma ka det in tupukus torom iau, sur an ulaun pas det.” Iri i a kibino ra ka det nurnur. ");
INSERT INTO kqw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","O Aisaia i watungi lenri uni i sa tama mugu a minamar anun o Iesu, ra i wasiso uni. ");
INSERT INTO kqw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","A susut na taro det nurnur un o Iesu. A ramano kum mugumugu kai tagun a taro Juda det nurnur, ikut ka det wasiso puaso uni, sako a kum Parisi det in turbat ru det gusun a kum rumu na lotu. ");
INSERT INTO kqw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ka det wasiso talapor, uni det nemi kut a wasiso na ululabo anun a taro torom det, ma ka det nuk pas a wasiso na ululabo anun o God torom det. ");
INSERT INTO kqw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","O Iesu i wasiso nam in labino walngano lena, “I ra i nurnur un iau, ausur i nurnur kut un iau, i nurnur utkai uni ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma i ra i tama iau, i sa tama tari ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A sa wanpat urin una rakrakon bual elar nama talapor, suri ra i nurnur un iau, ken kis una dumirum. ");
INSERT INTO kqw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ra taio i longoro anung a kum wasiso ma ke muri, iau kan kuro i. Uni ka wanpat sur an kuro a rakrakon bual, a wanpat kut sur an ulauni. ");
INSERT INTO kqw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","I ra ke nem iau ma ke tarom una nung a kum wasiso, anung a kum wasiso ut ra, det in kuro i una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uni a kum wasiso ra a sa watung tatari, ausur anung, o Tita ut i tulu ru iau nami urin, sur an wasiso kut nami. ");
INSERT INTO kqw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma a tasmani lena anun a warkurai i pitar a nilaun tukum. A kum wasiso a watungi, o Tita i tulu ru iau nami sur an watungi. ");
INSERT INTO kqw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A labino bung na lotu na Wanlakai i sa milau, ra o Iesu i tasmani lena i sa milau sur in nan mo gusun a rakrakon bual, ma in nan torom o Tamano. I maris doko anun a taro ra det kis una rakrakon bual, ra uniri i ese anun a labino marmaris torom det, a marmaris ra katu tuktukino. ");
INSERT INTO kqw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Una mirum, o Iesu tomo nam anun a kum nat na ususer det wangon tomo. Numugu tan anundet a inangon, o Satan i sa unuknuk tar o Judas Iskariot, a nutun o Saimon, sur in usobor tar o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","O Iesu i tasmani lena o Tamano i sa pitar rop tar a dekdek toromi, sur in warkurai a kum utna rop nami. Ma i tasmani lena i wan pas ut gusun o God, ma in milet melet torom o God. ");
INSERT INTO kqw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Io, i katutur pas gusun a inangon, i rakon ru anun in teken namalu ra i rakup bat anun a ememar nami, ra i los pas a tawol ma i ker pasi uni. ");
INSERT INTO kqw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","I lingis pas a danim una besen ra i gos a kum kikin anun a kum nat na ususer nami, ma i us sengesenge det nama tawol ra i ker pasi uni. ");
INSERT INTO kqw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I wan torom o Saimon Pita, ra o Pita i tingi lena, “Ai, Labino, ui un gos aru kiking?” ");
INSERT INTO kqw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","O Iesu i balu i lena, “A utna ri a pami ko tasmani, ikut numur un tasmani.” ");
INSERT INTO kqw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","O Pita i watungi lena, “Gong! Gong u gos aru kiking.” O Iesu i balu i lena, “Ra kan gos aru kikim, ui ausur ara tagun iau.” ");
INSERT INTO kqw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","O Saimon Pita i balu i lena, “Labino, gong u gos kut aru kiking, un gos utkai aru lamang ma in loring!” ");
INSERT INTO kqw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","O Iesu i watungi tano lena, “I ra i sa rurus pas, a pinino rop i sa talapor, din gos tar aru kikino mukut. Mot, mot sa talapor, ikut, ausur mot rop.” ");
INSERT INTO kqw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","O Iesu i sa tasman tar o naro ra in usobor tari. I ra a kibino ra i watungi lena, “Ausur mot rop mot talapor.” ");
INSERT INTO kqw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","I sa gos tar a kum kikindet, ra i ubek melet pas anun in namalu ra i rakon ru tari, i kis melet ma i ting det lena, “Mot tasmani ut a utna ri a pami un mot? ");
INSERT INTO kqw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mot watung iau nama ‘Tene Ususer’ ma a ‘Labino’. I tokodos ut anumot a wasiso, uni a risang ut ra. ");
INSERT INTO kqw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iau anumot a Labino ma a Tene Ususer, ma a sa gos tar a kum kikimot. I wakak sur mot kai mot in ser gos etetalai a kum kikimot. ");
INSERT INTO kqw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A sa pam tar a larlar ri torom mot, i wakak sur mot kai mot in pami lenri a pami. ");
INSERT INTO kqw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A inanos mot nama lingmulus, a tultul ke labo taun anun a labino. Ma i ra di tultulu i, ke labo taun i ra i itula. ");
INSERT INTO kqw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ra mot tasman a kum utna ri, ma mot in pami, mot in dan. ");
INSERT INTO kqw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ausur a wasiso un mot rop, a tasman det ut ra a pilok pas det. Ikut din pam sot pasi ut a wasiso ra di sa tumus tari una Buk Tabu lena, ‘A musano ra mir wangon tomo nami, in tupukus taru melet sur iau, ma in pas pispiso iau.’ ");
INSERT INTO kqw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A inanos mugu tar mot una utna ri ra in nanpat. Io, ra in nanpat, mot in nurnur lena iau a Karisito. ");
INSERT INTO kqw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A inanos mot nama lingmulus, osi ra i gas pas o naro ra a tulu i, i gas pas iau ut. Ma osi ra i gas pas iau, i gas pasi utkai o naro ra i tulu ru iau urin.” ");
INSERT INTO kqw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","O Iesu i sa watung tari lenri, ra i taramo a labino mamaut una niono, ra i watung puaso i lena, “A inanos mot nama lingmulus, ara tagun mot in pitar tar iau ulaman a kum ebar.” ");
INSERT INTO kqw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A kum nat na ususer det tama etetalai det, ikut ka det tasmani lena osi tagun det ra i watung a wasiso ri uni. ");
INSERT INTO kqw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ara nat na ususer i kis milau o Iesu. A nat na ususer ri o Iesu i nemnem doko i. ");
INSERT INTO kqw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","O Saimon Pita i pet ukinalong pas a nat na ususer ra, ma i watungi lena, “Un ting o Iesu lena, osi ra i watung a wasiso ri uni.” ");
INSERT INTO kqw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A nat na ususer ra, i ere torom o Iesu ra i tingi lena, “Labino, osi ra u watung a wasiso ri uni?” ");
INSERT INTO kqw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","O Iesu i balu i lena, “An puk pas a du beret una besen, ma osi ra an pitari tano, i ut ra.” Io, i puk pas a du beret, ma i pitari tan o Judas Iskariot, a nutun o Saimon. ");
INSERT INTO kqw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","O Judas i rakon pas a du beret gusun o Iesu, ra o Satan i ruk taru mut uni. Ra o Iesu i watungi tan o Judas lena, “A utna ra u nem na pami, un pam lakiti.” ");
INSERT INTO kqw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ikut kataio tagun det ra det kis tomo una inangon i tasmani lena sur asau ra o Iesu i watungi lenra toromi. ");
INSERT INTO kqw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","O Judas i ser tamtamabat anundet a mani. Io, iri a kibino ra a ramano kum nat na ususer det nuki lena o Iesu i inanosi sur in kul lako utna ra det sibo suri una labino bung na lotu. A ramano kum nat na ususer kai det nuki lena o Iesu i inanosi, sur in tabor a kum sibo na taro nam tu utna. ");
INSERT INTO kqw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ra o Judas i sa rakon pas a du beret, i pirso pas mut. Ma a bual i sa mirum. ");
INSERT INTO kqw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ra o Judas i sa wan taru, o Iesu i watungi tandet lena, “Uniri din mar a Nutun a Musano, ma o God kai in los a minamar uni. ");
INSERT INTO kqw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","O God in los a minamar uni, ma o God in pitar a minamar torom a Nutun a Musano. Uniutra o God in pitari tano. ");
INSERT INTO kqw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“A kum paspasang, uniri kan kis siun mo torom mot. Mot in sisio sur iau. Ikut, a wasiso ra a sa watung tari tan a kum te Juda, uniri an watungi bulung tamot lena, ‘Ka mot in nan lar pas una tamon ra an nan iai.’ ");
INSERT INTO kqw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Uniri a pitar a matok na warkurai torom mot lena, mot in maris etetalai mot. Mot in maris etetalai mot elar nam iau ra a maris mot. ");
INSERT INTO kqw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ra mot in maris etetalai mot, a taro rop det in tasmani lena mot anung a kum nat na ususer.” ");
INSERT INTO kqw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","O Saimon Pita i tingi lena, “Labino, un nan urai?” O Iesu i balu i lena, “A tamon ra an nan suri, kon nan lar pas iai uniri, ikut numur un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","O Pita i tingi lena, “Labino, sur asau ra kan mur ui uniri? Ka ngara ra an matbat ui.” ");
INSERT INTO kqw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ra o Iesu i balu i lena, “Pepetlai, a lingmulus ut ra un matbat iau? A inanos ui nama lingmulus, ra a kereke ken kurkurakuk utmakai, un ipul a tulu dino lena ko tasman iau.” ");
INSERT INTO kqw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","O Iesu i watungi tandet lena, “Gong i mamaut a balamot, mot in nurnur un o God, ma mot in nurnur kai un iau. ");
INSERT INTO kqw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A rumu anun o Tita, a susut na kukur rumu kura uni. Ma ra awu, an inanos mot ut uni. An nan sur an waninar tar a dino sur mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ra a sa waninar tar a dino sur mot, an milet melet, ma an ben pas mot torom iau sur mot kai mot in kis una tamon ra a ser kis iai. ");
INSERT INTO kqw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mot tasmani ut a kisapi sur a tamon ra an nan suri.” ");
INSERT INTO kqw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","O Tomas i watungi tano lena, “Labino, ka met tasman a tamon ra un nan suri, io, met in tasman petlan a kisapi suri?” ");
INSERT INTO kqw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","O Iesu i balu i lena, “Iau a kisapi, ma iau a lingmulus, ma iau a nilaun. Kataio in nan torom o Tita un tu kisapi gisen, un iau kut. ");
INSERT INTO kqw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ra mot in tasman mulus iau, mot in tasman kai o Tita. Io, iri mot sa tasmani, ma mot sa tama i. ");
INSERT INTO kqw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","O Pilip i watungi tano lena, “Labino, un ese tar o Tamam torom met, i kut ra met nemi.” ");
INSERT INTO kqw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","O Iesu i balu i lena, “Pilip, a sa kis siun tomo namot, pepetlai, ko tasman iau utmakai? Osi ra i tama iau, i sa tama tar o Tita. Sur asau u watungi lena an ese tar o Tita torom mot? ");
INSERT INTO kqw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ko nurnur lena iau kura un o Tita, ma o Tita kuri un iau, niko? A kum wasiso ra a watungi tamot, ausur anung. O Tita ra kuri un iau i pam anun a pinapam. ");
INSERT INTO kqw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mot in nurnur un iau ra a watungi lena kura iau un o Tita, ma o Tita kuri un iau. Ma ra ka mot nurnur una nung a wasiso, io, mot in nurnur kut un iau, kibino una kum utna na ukisin ra a pami. ");
INSERT INTO kqw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“A inanos mot nama lingmulus, o naro ra i nurnur un iau, in pam a kum pinapam elar nami ra iau a ser pami. Ma in pam a kum lamlabino pinapam tan a kum pinapam ra a sa pam tari, uni an nan torom o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma a kum utna rop ra mot saringi nama risang, an pam sot pasi, sur o Tita in los a minamar un o Nutunu. ");
INSERT INTO kqw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ra mot in sasaring sur tu utna nama risang, an pam sot pasi. ");
INSERT INTO kqw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ra mot in maris iau, mot in tarom una anung a kum warkurai. ");
INSERT INTO kqw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma an saring o Tita, ra in tulu ru ara Tene Warut bulung torom mot, sur in kis tukum torom mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I a Tokodos na Nion, ra in upuaso a lingmulus. A taro tagun a rakrakon bual ka det in nemi, uni ka det in tama lele i ma ka det in tasmani. Ikut mot, mot tasman a Tene Warut, uni i kis tomo nam mot ma in kis un mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ra an nan gusun mot, ka mot in kis na nat na soi, uni an milet melet kut torom mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Ken suano i kut, ra a taro tagun a rakrakon bual ka det in tama iau mo. Ikut mot, mot in tama iau. Ma mot in laun, uni a laun. ");
INSERT INTO kqw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A bung ra an katutur melet gusun a minat, mot in tasmani lena kura iau un o Tita, ma mot kai kuri un iau, ma iau kura un mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Osi ra i utur ukai anung a kum warkurai ma i tarom uni, i ra i maris iau. O Tita in marisi, ma iau kai an marisi, ma an ese iau toromi.” ");
INSERT INTO kqw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","O Judas (ausur o Judas Iskariot) i ting o Iesu lena, “Labino, sur asau ra un ese tar ui torom met kut, ma ausur torom a taro una rakrakon bual?” ");
INSERT INTO kqw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","O Iesu i balu i lena, “Ra taio i maris iau, in tarom una anung a kum etowo. Io, o Tita in marisi, ma mir nam o Tita mir in nan toromi, ma mir in kis tomo nami. ");
INSERT INTO kqw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","I ra ke maris iau, ken tarom una nung a kum etowo. A kum wasiso ra mot longoro i ausur anung, anun o Tita, i ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A watung a kum wasiso ri torom mot, ra a kis utmakai tomo nam mot. ");
INSERT INTO kqw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A Tene Warut, a Tokodos na Nion ra o Tita in tulu ru i una risang. In ususer mot una kum utna rop, ma in unuk tar mot melet nama kum wasiso ra a sa watung tari tamot. ");
INSERT INTO kqw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A pitar a malmal torom mot. Anung a malmal ra, a tabor mot nami. Ka tabor mot elar nama rakrakon bual i etabor. Gong a balamot i mamaut, ma gong mot ngara. ");
INSERT INTO kqw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mot sa longoro tari, ra a sa watung tari torom mot lena, ‘An nan pas ma an milet melet torom mot.’ Ra mot in maris iau, mot in gas ra an nan torom o Tita, uni i, i labo tang. ");
INSERT INTO kqw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A sa inanos mugu tar mot una kum utna ra numur in nanpat, ma ra i sa wanpat, mot in nurnur. ");
INSERT INTO kqw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Kan wasiso liklik mo torom mot, uni a labino taginin una rakrakon bual milau mo in nanpat. Kalako dekdek ino sur in turus pas iau nami, ");
INSERT INTO kqw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ikut an pam sot rop pas ut a kum pinapam ra o Tita i tulu ru iau sur an pami, sur a rakrakon bual in tasmani lena a maris o Tita. Mot tur ma dat in nan.” ");
INSERT INTO kqw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O Iesu i watungi lena, “Iau ut in nanai na wain mulus, ma o Tita i a tene tamtamabat una kinobot na wain. ");
INSERT INTO kqw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I ser tau ru a kum kanokano rop nin un iau ra ka det ser wu, ma i ser burup det ra det ser wu, sur det in wu a susut na wino. ");
INSERT INTO kqw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mot sa talapor, kibino una wasiso ra a sa watung tari tamot. ");
INSERT INTO kqw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mot in laun un iau, ma iau an laun un mot. Ka mot in wu ra ka mot lalaun un iau, elar nama kano wain ken wu oros ra ken patop un in nanai ino. ");
INSERT INTO kqw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iau ut in nanai na wain, ma mot a kum kanokano. I ra i lalaun un iau, ma iau a lalaun uni, in wu a susut na wino. Ikut ra mot lalaun gisen gusun iau, ka mot in pam lar pas tu utna. ");
INSERT INTO kqw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ra taio ken lalaun un iau, i elar nama kano duwai, ra di woro ru i ra numur in marang. Din ubek tomo det, ma din woro det una sungun, sur det in nangon rop tiro iai. ");
INSERT INTO kqw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ra mot in laun un iau, ma anung a wasiso in laun un mot, io, mot in saring iau sur tu utna ra mot nemi, ra din pitari ut tamot. ");
INSERT INTO kqw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Ra mot in wu a susut na wimot, o Tita in los a minamar, ma a wimot in ese i lena mot anung a kum nat na ususer mulus. ");
INSERT INTO kqw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","O Tita i maris iau, lenkaira a maris mot. Mot in lalaun una nung a marmaris. ");
INSERT INTO kqw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ra mot in tarom una nung a kum warkurai, mot in lalaun una nung a marmaris, elar nam iau, a tarom una kum warkurai anun o Tita, ra a lalaun una nun a marmaris. ");
INSERT INTO kqw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“A watung a kum wasiso ri tamot, sur anung a gasgas in kis un mot, ma anumot a gasgas in bukus una numot a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iri i anung a warkurai torom mot lena, mot in maris etetalai mot, elar nam iau a maris mot. ");
INSERT INTO kqw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ra taio in pitar ru anun a nilaun sur in mat una kum paspasano, anun a marmaris i labo sakit. Katu marmaris anun taio i elar nami. ");
INSERT INTO kqw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ra mot in tarom una nung a kum warkurai, io, mot a kum paspasang. ");
INSERT INTO kqw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kan watung mot melet mo lena a kum tultul, uni a tultul ke tasman a utna ra anun a labino i pami. Ikut a watung mot lena a kum paspasang, uni a sa watung rop tar a kum wasiso tamot ra a longoro i gusun o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ausur mot pilok pas iau, iau ut a pilok pas mot. Ra a pitar a pinapam tamot sur mot in nan ma mot in wu a wimot, ma a wimot in kis tukum. Ma o Tita in tabor mot nama kum utna rop ra mot sasaring suri nama risang. ");
INSERT INTO kqw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mot in maris etetalai mot. Iri anung a warkurai torom mot. ");
INSERT INTO kqw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ra a taro tagun a rakrakon bual det in nget mot, mot in nuk pasi lena det sa nget mugu tar iau. ");
INSERT INTO kqw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ra mot anun a rakrakon bual, io, a rakrakon bual in maris mot elar nam mot anunu. Ikut mot ausur anun a rakrakon bual, a sa pilok pas mot gusuni. Iri a kibino ra i nget mot. ");
INSERT INTO kqw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mot in nuk pas a wasiso ra a sa watung tari tamot lena, ‘A tultul ke labo taun anun a labino.’ Ra det banlaulau iau, det in banlaulau mot kai. Ra det tarom una nung a wasiso, det in tarom kai una numot a wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Det in banlaulau mot kibino una risang, uni ka det tasman o naro ra i tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ra gunuk kan nanpat ma kan wasiso torom det, io, ka din takun det una nundet a kum sakino petutna, ma det in langolango ut. Ikut uniri, ka nundet tu wasiso sur det in watungbat det nami gusun anundet a sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","I ra i nget iau, i nget utkai o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A sa pam tar a kum utna na ukisin ra ka taio in pam lar pasi. Ra gunuk kan pam tar a kum utna na ukisin ra nisandet, ka din takun det una nundet a kum sakino petutna, ma det in langolango ut. Ma iri, det sa tama tar a kum utna na ukisin ra a sa pam tari, ikut det nget mir rop nam o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Di pami lenri, sur din pam sot pas a wasiso ra di sa tumus tari una Buk na Warkurai lena, ‘Det nget iau, ma katu kibino.’ ");
INSERT INTO kqw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“An tulu ru a Tene Warut torom mot tagisapat gusun o Tita, i a Tokodos na Nion ra in upuaso a lingmulus. Ra in nanpat in wasiso puaso un iau. ");
INSERT INTO kqw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma mot kai mot in wasiso puaso un iau, uni mot kis tomo nam iau tagun a turturkibin na nung a pinapam tuk uniri. ");
INSERT INTO kqw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“A watung a kum utna ri tamot, sur gong anumot a nurnur i puku. ");
INSERT INTO kqw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Det in turbat mot gusun a kum rumu na lotu. Numur a du bung in nanpat, ra a taro ra det um doko mot, det in nuki lena det pam ut a pinapam anun o God. ");
INSERT INTO kqw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A taro det in pam a kum utna ri torom mot, uni ka det tasman mir nam o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A sa watung tar a kum wasiso ri tamot, sur ra a du bung ra in nanpat, mot in tasmani lena a sa utumarong mugu tar mot uni. “Ka watung a kum wasiso ri tamot una turturkibin na nung a pinapam, uni a kis utmakai tomo namot. ");
INSERT INTO kqw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Io uniri, an nan torom o naro ra i tulu ru iau urin. Ikut ka taio tagun mot i ting iau lena, ‘Un nan urai?’ ");
INSERT INTO kqw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mot tupunuk doko uni a watung a kum wasiso ri torom mot. ");
INSERT INTO kqw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A inanos mot nama lingmulus lena, in wakak torom mot ra an nan. Ra ka nan, a Tene Warut ken nanpat torom mot. Ikut ra an nan, io, an tulu ru i urin torom mot. ");
INSERT INTO kqw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ra in nanpat, in ese a taro una rakrakon bual una nundet a sakino petutna, ma in ese det kai una tokodos na petutna ma una warkurai anun o God. ");
INSERT INTO kqw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","In ese det lena, ra ka det in nurnur un iau, i ra anundet a sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma in ese det kai una tokodos na petutna, uni an nan torom o Tita ma ka mot in tama melet iau mo. ");
INSERT INTO kqw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma in ese det kai lena o God i sa pitar tar a warkurai na minabalu tan a labino tagun a rakrakon bual, ma i sa upuku ru tari. ");
INSERT INTO kqw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A susut na wasiso ra an watungi tamot, ikut ke to pas mot utmakai. ");
INSERT INTO kqw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A Tokodos na Nion, ra i ser upuaso a lingmulus ino, in nanpat, ma in utalapor mot una kum lingmulus ino rop un o God. A kum wasiso ra in watungi ausur anunu, in watungi kut a kum wasiso ra i longoro i, ma in inanos mot una kum utna ra in nanpat numur. ");
INSERT INTO kqw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In pitar a minamar torom iau, ra in los pas anung a wasiso, ma in inanos mot nami. ");
INSERT INTO kqw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A kum utna rop ra anun o Tita, anungi. I ra a kibino ra a watungi lena, a Tokodos na Nion in los pas anung a wasiso ma in inanos mot nami. ");
INSERT INTO kqw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ken suano i kut, ra ka mot in tama iau mo. Ma ken suano meleti kut, mot in tama melet iau.” ");
INSERT INTO kqw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Anun a ramano kum nat na ususer det ting etetalai det lena, “Asau a kukuraina nun a wasiso ri ra i watungi lena, ken suano i kut ra ka dat in tama i mo, ma ken suano meleti kut dat in tama meleti? Ma i watungi kai lena, ‘Uni an nan torom o Tita’. ");
INSERT INTO kqw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Asau a kukuraino ra i watungi lena, ‘ken suano i’? Ka dat tasman a utna ri i wasiso uni!” ");
INSERT INTO kqw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","O Iesu i tasmani lena det nem na tingi, ra i watungi torom det lena, “A watungi lena, ‘Ken suano i kut ra ka mot in tama iau mo, ma ken suano meleti kut mot in tama melet iau.’ Iri a wasiso ra mot ting etetalai mot uni, niko? ");
INSERT INTO kqw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A inanos mot nama lingmulus, mot in tupunuk ma mot in tangis, ikut a rakrakon bual in gas. Mot in tupunuk, ikut numur anumot a tupunuk in tupukus sur a gasgas, ");
INSERT INTO kqw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","elar nama ino ra i milau sur in usus, in taramo a ngunungut, ikut, ra i sa usus pas, in dumano a ngunungut ma in gas. In gas uni i sa usus tar a nat urin una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lenkaira torom mot, uniri mot tupunuk, ikut an tama melet mot, ra mot in gas. A ngas na gas ri, kataio in pet lar pasi sur in rakon ru i gusun mot. ");
INSERT INTO kqw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Una bung ra, ka mot in ting melet iau mo un tu utna. A inanos mot nama lingmulus, o Tita in tabor mot nama kum utna ra mot saringi nama risang. ");
INSERT INTO kqw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuk uniri, ka mot sasaring utmakai sur tu utna nama risang. Mot in sasaring ma din tabor mot, sur a gasgas in bukus una numot a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“A watung a kum utna ri tamot una kum wasiso elelar, ikut a du bung in nanpat ra kan wasiso melet mo torom mot nama wasiso elelar, an inanos talapor mulus mot mo un o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Una kum bung ra, mot in sasaring nama risang. Ka watungi lena iau an saring o Tita sur in warut mot, ");
INSERT INTO kqw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","uni o Tita ut in maris mot. I maris mot uni mot maris iau, ma mot nurnur lena a wanpat tagun o God. ");
INSERT INTO kqw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A wan pas gusun o Tita, ra a wan urin una rakrakon bual. Uniri, an nan mo gusun a rakrakon bual, ma an milet melet torom o Tita.” ");
INSERT INTO kqw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Anun a kum nat na ususer det watungi tano lena, “Uniri ko wasiso mo nama wasiso elelar, u wasiso talapor mulus maragom. ");
INSERT INTO kqw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uniri met tasmani lena u tasman a kum utna rop. Ko sibo sur taio in ting ui nam tu iting, uni u sa tasman a nuknukimet rop. Io, met nurnur maragom lena u wan pas ut gusun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","O Iesu i watungi tandet lena, “Ilai, mot nurnur maragom? ");
INSERT INTO kqw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","A du bung in nanpat, ma iri i sa wanpat, ra din lu susuaro ru mot gusun iau, ra mot in nan susuaro sur anumot a kum tamon taktakai, ra iau mukut an kis. Ikut ausur iau kut ra an kis, mir ut nam o Tita. ");
INSERT INTO kqw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“A watung a kum wasiso ri tamot sur mot in laun un iau, ma a balamot in bukus nama malmal. Nin una rakrakon bual, mot in taramo a mamaut. Ikut gong mot ngara, uni a sa turus pas a rakrakon bual.” ");
INSERT INTO kqw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ra o Iesu i sa watung rop tar a kum wasiso ri, i tamtama tito usapat una langit, ra i watungi lena, “Tita, a du bung i sa wanpat, un pitar a minamar torom a Nutum, sur a Nutum in pitar a minamar torom ui. ");
INSERT INTO kqw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","U pitar tar a warkurai tang sur a taro rop, sur an pitar a nilaun tukum torom det rop ra u pitar tar det tang. ");
INSERT INTO kqw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A nilaun tukum i lenri: A taro det in tasman ui, ra ui kut a God mulus, ma det in tasman o Iesu Karisito kai, i ra u tulu ru i urin. ");
INSERT INTO kqw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A sa pam sot pas a kum pinapam ra u pitar tari tang sur an pami. Ma una pinapam ra, a sa ese tar a minamarim nin una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tita, uniri, ra an kis tomo melet nam ui, un pitar a minamar tang. A minamar ra numugu a kis uni tomo nam ui, ra ka di ukis utmakai a rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Det ra u sa pilok pas det gusun a rakrakon bual, ma u pitar tar det tang, a sa watung puaso tar ui tandet. Det anum ra u pitar tar det tang, ma det sa tarom una num a kum wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Uniri, det sa tasmani lena a kum utna rop ra u pitar tari tang, i wanpat mulus ut gusun ui. ");
INSERT INTO kqw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A sa inanos tar det nama kum wasiso ra u pitar tari tang, ma det sa tarom uni. Ma det tasman mulusi lena a wan ut gusun ui, ma det sa nurnur lena ui ut u tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“A wararing un det. Ausur a wararing una taro tagun a rakrakon bual, ikut a wararing un det ra u pitar tar det tang, uni det anum. ");
INSERT INTO kqw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Det rop ra anung, anum utkai, ma det rop ra anum, anung utkai. Ma anung a minamar din tama i un det. ");
INSERT INTO kqw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Uniri an nan torom ui, kan kis siun melet mo una rakrakon bual, ikut det, kuri utmakai det una rakrakon bual. Tita, u tokodos sakit, un tamtamabat det nama dekdekin a risam, a rising ra u pitar tari tang. Un tamtamabat det sur det in takai kut, elar nam ui ma iau, dar takai kut. ");
INSERT INTO kqw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A kis tomo nam det, ra a tamtamabat det nama dekdekin a risam, a rising ra u pitar tari tang. A tamtamabat det, ma kataio tagun det i iru. Ara sot kut in iru, o Judas, i ra i wan sur a iniru tukum. Io, i lenra, sur a wasiso ra di sa tumus tari una Buk Tabu in nanpat mulus. ");
INSERT INTO kqw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Iri an nan torom ui, ikut a watung a kum wasiso ri ra a kis utmakai nin una rakrakon bual, sur anung a labino gasgas in ubukus anundet a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A sa watung tar anum a kum wasiso tandet, ma a rakrakon bual i nget det, uni ausur det taginin una rakrakon bual, elar nam iau kai, ausur iau taginin una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka saring ui sur un rakon ru det gusun a rakakon bual, awu. Ikut a saring ui sur un tamtamabat det gusun a Tene Sakino. ");
INSERT INTO kqw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ausur iau taginin una rakrakon bual, ma det kai ausur det taginin una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anum a kum wasiso i lingmulus. Un utalapor det nam anum a lingmulus na wasiso, sur det anum a taro mulus. ");
INSERT INTO kqw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","U tulu ru iau urin una rakrakon bual, lenkutkai ra iau, a tulu ru det una rakrakon bual. ");
INSERT INTO kqw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A pitar tar iau ut torom ui, sur det kai, det anum a taro mulus una num a lingmulus na wasiso. ");
INSERT INTO kqw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ausur a wararing kut un det, a wararing utkai una taro ra numur det in nurnur un iau, a taro ra a kum tene nurnur det in wasiso puaso un iau torom det. ");
INSERT INTO kqw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tita, a wararing lena det rop ra det nurnur un iau, det in takai kut, elar nam ui kuri un iau ma iau kura un ui. A nemi sur det in lalaun un dar, sur a taro una rakrakon bual det in nurnur lena ui u tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A sa pitar tar a minamar tandet, a minamar ra u pitar tari tang, sur det in takai kut, elar nam dar, ra dar takai kut. ");
INSERT INTO kqw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iau kura un det, ma ui kai kuri un iau, sur det ara mukut, sur a taro una rakrakon bual det in tasmani lena, u tulu ru iau urin, ma det in tasmani kai lena, u maris det elar nami ra u maris iau. ");
INSERT INTO kqw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tita, a nemi lena, det ra u sa pitar tar det tang, det in kis tomo nam iau una tamon ra an kis iai, sur det in tama anung a minamar, a minamar ra u pitar tari tang, uni u maris iau numugu ra ka di ukis a rakrakon bual utmakai. ");
INSERT INTO kqw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tita, ui a tene tokodos, a taro una rakrakon bual ka det tasman ui. Ikut iau, a tasman ui, ma anung a taro na ususer kai det tasmani lena ui, u tulu ru iau urin. ");
INSERT INTO kqw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A sa watung ese tar ui torom det, ma kan mana nama wasiso talapor un ui torom det, sur det in tasman ui, sur a marmaris ra u maris iau nami, in kis un det ma iau utkai an laun un det.” ");
INSERT INTO kqw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ra o Iesu i sa wararing pas, i ben pas anun a kum nat na ususer, ra det wanlakai in nala na danim Kidron. Det wanlakai, ra det wan ruk utiro una ara kinobot na duwai na oliw. ");
INSERT INTO kqw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","O Judas, i ra i usobor tar o Iesu i tasman a kinobot ra, uni a susut na dino o Iesu ma anun a kum nat na ususer det ser wan tomo iai. ");
INSERT INTO kqw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ra o Judas i mugu pas a kum tene inaim tagitiro o Rom, ma a kum tene tamtamabat tagun a rumu na etabor. A kum lamlabino tene etabor torom o God, ma a kum Parisi det tulu ru det. Det los a kum utna na inaim, a kum lam ma a kum utna ra i kunabor ra det sulu saro det nami. ");
INSERT INTO kqw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ikut o Iesu i sa tasman a kum utna rop ra in nanpat toromi, ra i wan torom det ma i ting det lena, “Osi ra mot sisio suri?” ");
INSERT INTO kqw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Det balu i lena, “O Iesu a te Nasaret.” I balu det lena, “Iau kut ri.” O Judas, i ra a tene usobor, kura ut i tur tomo nam det. ");
INSERT INTO kqw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Una du bung ra o Iesu i watungi lena, “Iau kut ri,” det tur isu unago numur, ra det puku una piso. ");
INSERT INTO kqw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","O Iesu i ting melet det lena, “Osi ra mot sisio suri?” Det balu i lena, “O Iesu a te Nasaret.” ");
INSERT INTO kqw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","O Iesu i balu det lena, “A sa watung tari tamot lena, iau kut ri. Ra mot sisio ut sur iau, io, mot in madek ru det ri det in nan.” ");
INSERT INTO kqw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O Iesu i watungi lenri, sur in pam sot pas a wasiso ra i sa watung tari lena, “Det rop ra u pitar tar det tang, kataio tagun det in iru.” ");
INSERT INTO kqw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","O Saimon Pita i losi ut anunu in totok na inaim. I dat pasi ra i tau kutus ru in nosot na talngan o Malkus, a tultul anun a mugumugu na tene etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ra o Iesu i watungi tan o Pita lena, “Uruk melet anum in totok una bano. Pepetlai, kan inum tagun a kap na mamaut ra o Tita i pitar tari tang?” ");
INSERT INTO kqw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A kum tene inaim tagitong o Rom tomo nam anundet a mugumugu, ma a kum tene tamtamabat tagun a rumu na etabor anun a taro Juda, det pam ukai pas o Iesu, ma det ker pas aru lamano. ");
INSERT INTO kqw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Det ben mugu i torom o Anas i ra der inumunu nam o Kaiapas, a mugumugu na tene etabor torom o God una kilalo ra. ");
INSERT INTO kqw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kaiapas, i ra i watungi torom a kum te Juda lena, in wakak ra taio in matbat a taro rop. ");
INSERT INTO kqw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","O Saimon Pita ma ara nat na ususer kai der wan nanan numurun o Iesu. A mugumugu na tene etabor i tasman wakak a nat na ususer ra der wan tomo nam o Pita. A nat ra, i ruk tomo nam o Iesu utiro una nubual anun a tene etabor ra. ");
INSERT INTO kqw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","O Pita kura utmakai i tur taru nago utamon nisan a matansako. Ra a nat na ususer ra a mugumugu i tasmani, i milet melet, ma i wasiso torom a ino ra i tamtamabat a matansako, sur in papos saro pas o Pita. ");
INSERT INTO kqw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","A ino ra i tamtamabat a matansako i ting o Pita lena, “Ai, ui utkai ara nat na ususer anun a musano ri, ni?” O Pita i balu i lena, “Awu, iau awu.” ");
INSERT INTO kqw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A bung na mirum ra, i kotokoto doko. Io, a kum tultul ma a kum tene tamtamabat tagun a rumu na etabor det sur tomo pas a kabo lakit na sungun, det tur talilis pasi ma det minori. O Pita kai i tur tomo nam det sur in minor. ");
INSERT INTO kqw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","O Anas, a mugumugu na tene etabor torom o God i ting o Iesu una nuna kum nat na ususer, ma una kum wasiso ra i ser ususer a taro nami. ");
INSERT INTO kqw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","O Iesu i balu i lena, “A sa waswasiso talapor umatan a taro rop, ma a ser ususer det una kum rumu na lotu ma una rumu na etabor, ra a taro Juda det ser wan tomo iai. Ka inanos eno tar det un tu utna. ");
INSERT INTO kqw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gong u ting iau. Un ting a taro ra det ser longoro iau. Det ra, det tasman a kum utna ra a waswasiso uni.” ");
INSERT INTO kqw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ra o Iesu i sa watung tari lenra, ara tagun a kum tene tamtamabat i pasor in masarino, ma i watungi tano lena, “Sur asau ra u balu a wasiso anun a mugumugu na tene etabor lenra?” ");
INSERT INTO kqw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","O Iesu i balu i lena, “Ra a sa watung tar tu utna i raro, un watung talapori torom a taro rop ri. Ikut ra a utna ri a watungi i lingmulus ut, sur asau ra u pasor iau?” ");
INSERT INTO kqw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ra ka di palos utmakai a kineker gusun aru lamano, o Anas i tulu ru i torom o Kaiapas, i kai a mugumugu na tene etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ra o Pita kura utmakai i minor liklik, det tingi lena, “Ai, ui utkai ara tagun anun a kum nat na ususer, ni?” O Pita i ipul, ra i watungi lena, “Awu, iau awu.” ");
INSERT INTO kqw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ara tultul anun a mugumugu na tene etabor, a kukun o naro ra o Pita i tau kutus ru in talngano, i watungi lena, “Lar kut ui kut, ra a tama tomo tar mur nam o Iesu sapat una kinobot na duwai na oliw?” ");
INSERT INTO kqw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","O Pita i ipul melet lena, “Awu.” Ra uniutra, a kereke i kurkurakuk mut. ");
INSERT INTO kqw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Una kobot raut, di ben pas o Iesu gusun a rumu anun o Kaiapas sur a labino rumu anun o Pailat, ara mugumugu tagun a gapman Rom. A kum te Juda ka det nem na ruk una nun a rumu, uni det sa utalapor pas det sur det in nangon una labino bung na lotu na Wanlakai. Uni osi ra in ruk torom taio, ra ausur a te Juda, in dur umatano God. ");
INSERT INTO kqw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Io, o Pailat i pirso torom det ra i ting det lena, “Asau ra mot takun a musano ri uni?” ");
INSERT INTO kqw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma det balu i lena, “Ra gunuk a musano ri ken pam tu niraro, ka met in pitari torom ui sur un warkurai i.” ");
INSERT INTO kqw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","O Pailat i watungi torom det lena, “Mot in ben pasi, ma mot ut mot in warkurai i elar nam anumot a warkurai.” A kum te Juda det watungi tano lena, “Torom met i tabu sur met in um doko taio.” ");
INSERT INTO kqw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A utna ri i wanpat sur din pam sot pas a wasiso anun o Iesu, ra i sa watung mugu tari una nuna ngas na minat. ");
INSERT INTO kqw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Io, numur o Pailat i ruk melet ra i kabo pas o Iesu, ma i tingi lena, “Ui a king anun a taro Juda?” ");
INSERT INTO kqw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","O Iesu i balu meleti kut nama iting lena, “Ilai, anum ut a wasiso ra u watungi lenra un iau, o det inanos tar ui kut un iau?” ");
INSERT INTO kqw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O Pailat i balu i lena, “Ausur iau a te Juda. Anum a taro ut tomo nama kum lamlabino tene etabor torom o God, det ut ra det pitar tar ui tang sur an warkurai ui. Asau ra u sa pam tari?” ");
INSERT INTO kqw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","O Iesu i balu i lena, “Anung a matanitu ausur taginin una rakrakon bual. Ra gunuk anung a matanitu taginin una rakrakon bual, anung a kum tultul det in waim bat iau, sur gong a tur una warkurai anun a taro Juda. Ikut anung a matanitu ausur taginin.” ");
INSERT INTO kqw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Io, o Pailat i tingi lena, “I lingmulus ut, ui a king?” O Iesu i balu i lena, “I lingmulus ut ra u watungi lena iau a king. Di usus iau, ra a wanpat nin una rakrakon bual, sur an wasiso una lingmulus. Det rop ra det murmur a lingmulus, det longoro in nalngang.” ");
INSERT INTO kqw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ra o Pailat i tingi lena, “Asau a lingmulus?” Ra o Pailat i sa ting tari lenri, i pirso melet torom a taro Juda. I watungi tandet lena, “Ka pastorom anunu tu niraro. ");
INSERT INTO kqw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ikut, ara ngasino a ser pami torom mot, una kum kilkilalo rop una kum lamlabino bung na lotu na Wanlakai, a ser palos ru ara karabus torom mot. Pepetlai, mot nemi sur an palos ru a ‘king anun a taro Juda’ torom mot?” ");
INSERT INTO kqw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Det balu i nama labino walngandet lena, “Gong! Ka met nem o Iesu. Palos ru o Barabas!” O Barabas i a tene sakino sakit. ");
INSERT INTO kqw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ra o Pailat i itula sur din ben gisen pas o Iesu ma din taktakalo i nam in narus na inaim. ");
INSERT INTO kqw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A kum tene inaim det liko pas in narus a loklokono ma det ubek tari un in lorino elar nama wat na kukup anun a king, ma det mar tari nam in merek na malu. ");
INSERT INTO kqw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Det wanan toromi, ma det watungi lena, “Ui a king anun a taro Juda!” Ra det in kubu pasor in masarino. ");
INSERT INTO kqw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","O Pailat i pirso melet, ra i watungi tandet lena, “Mot tama i, iri a ben pirso tari umatamot, sur mot in tasmani lena, ka sio pas anunu tu niraro.” ");
INSERT INTO kqw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ra o Iesu i pirso, di sa mar tari nam in narus a loklokono un in lorino, ma in merek na malu. O Pailat i watungi tandet lena, “Mot tama a musano ri!” ");
INSERT INTO kqw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ra a kum lamlabino tene etabor torom o God, ma a kum tene tamtamabat tagun a rumu na etabor det tama o Iesu, det kukukuk lena, “Sak wati un in nanai kutus! Sak wati un in nanai kutus!” Ra o Pailat i watungi tandet lena, “Mot in ben pasi, sur mot ut, mot in sak wati un in nanai kutus. Iau ka sio pas anunu tu niraro.” ");
INSERT INTO kqw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A kum te Juda det balu i lena, “Anumet a warkurai i lenri, din um doko i, uni i watungi lena i a Nutun o God.” ");
INSERT INTO kqw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","O Pailat i longoro a wasiso ri, ra i ngara doko. ");
INSERT INTO kqw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","I ruk melet usa urumu, ra i ting o Iesu lena, “Ui tagai ui?” Ikut o Iesu ke balu i. ");
INSERT INTO kqw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","O Pailat i watungi tano lena, “Sur asau ra ko balu iau? Ko tasmani lena, a utur ukai a warkurai sur an ulangolango ui, o an sak wat ui un in nanai kutus?” ");
INSERT INTO kqw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","O Iesu i balu o Pailat lena, “Ra gunuk o God ken pitar tar a warkurai tam, kalako dekdekim sur un pam tu utna un iau. Ikut, o naro ra i pitar tar iau torom ui sur un warkurai iau, anun a sakino i laulau sakit. Anun a sakino i laulau sakit tan anum a sakino.” ");
INSERT INTO kqw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","O Iesu i watung tari lenra, ra o Pailat i lari sur in ulangolango ru i. Ikut a kum te Juda det kukukuk toromi lena, “Ra un palos ru i, ka mur pasano nama Sisa! Uni taio ra i ulabo pasi lena i a king, i kutus a warkurai anun a Sisa.” ");
INSERT INTO kqw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","O Pailat i longoro a kum wasiso ri, ra i ben pirso pas o Iesu unago upiso. Numur o Pailat i kis taru una kiskis na warkurai, kura una dino ra di watungi o Gabata una wasiso Ibru. A kukuraino i lena, di ubekbat a piso nama kum watat. ");
INSERT INTO kqw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ra in matanas i sa kis lekeleke, o Pailat i watungi tan a taro Juda lena, “Mot tama i, anumot a king iri i.” A utna ri, i wanpat una bung na waninar, a bung numugu tan a labino bung na lotu na Wanlakai. ");
INSERT INTO kqw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","A taro Juda det kukukuk dekdek lena, “Sak doko i! Sak doko i! Sak wati un in nanai kutus!” O Pailat i ting det lena, “Mot nemi lena an sak wat anumot a king un in nanai kutus?” A kum lamlabino tene etabor torom o God det balu i lena, “A Sisa sot kut i anumet a king!” ");
INSERT INTO kqw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ra o Pailat i pitar tar o Iesu torom a kum tene inaim, sur det in sak wati un in nanai kutus. Ra det ben pas o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","O Iesu i pirso gusun a tamon Jerusalem, i los pas anun in nanai kutus ra i wan sur a nubual di watungi nama “Nubual na Lor na Minat,” ma una wasiso Ibru di watungi lena o Golgota. ");
INSERT INTO kqw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tiro iai, di sak wati un in nanai kutus. Ma di sak wat aru musano kai tomo nami, una ru papor ino, ma o Iesu i kete epotor tander. ");
INSERT INTO kqw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma o Pailat i pitar a wasiso sur din tumus a tumtumus, sur din ubeki sapat un in nanai kutus. A tumtumus ra i lena: ");
INSERT INTO kqw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A susut na taro Juda det luk a tumtumus ri, uni a nubual ra di sak wat o Iesu un in nanai kutus iai, i milau kut o Jerusalem, ma di tumus a tumtumus ri una tulu ngas na wasiso, a wasiso Ibru, Latin ma Grik. ");
INSERT INTO kqw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","A kum lamlabino tene etabor torom o God det watungi tan o Pailat lena, “Gong u tumusi lena, ‘A King anun a taro Juda.’ Un tumusi kut lena, ‘A musano ri i watungi lena i a king anun a taro Juda.’” ");
INSERT INTO kqw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","O Pailat i balu det lena, “A tumtumus ra a sa tumus tari in lenutra.” ");
INSERT INTO kqw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ra a kum tene inaim det sa sak wat tar o Iesu un in nanai kutus, det los pas anun a kum malu ra i rakupbat anun a ememar nami, ma det isuaro pasi una a wat na tinibo, a rara tene inaim anun ara tinibo. Det los pasi kai anun in namalu ra i pipisi. In namalu ra, katu sunusuk uni, in teken kudulano malu kut. ");
INSERT INTO kqw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","A kum tene inaim det wasiso etetalai torom det lena, “Gong dat rarosi, dat in pilai laki sur osi na pasandat in losi.” Det pami lenra sur din pam sot pas a wasiso na Buk Tabu. I watungi lena, “Det isuaro anung a kum malu un det, ma det pilai laki suri.” Iri a kum utna ra a kum tene inaim det pami. ");
INSERT INTO kqw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","O nan o Iesu i tur milau nisan in nanai kutus anun o Iesu. I tur tomo nama tisino a ino, ma o Maria kai a ino anun o Kilopas, ma o Maria Magdalen. ");
INSERT INTO kqw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","O Iesu i tama o nano det tur tomo nam ara nat na ususer ra o Iesu i nem doko i, ra i watungi tan o nano lena, “Nang, i ra i, a nutum lik.” ");
INSERT INTO kqw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I watungi kai tan a nat na ususer ra lena, “I ra i, o nam.” Turpasi ut una bung ra, a nat na ususer ra, i ben pas o nan o Iesu, sur in kis una nun a rumu. ");
INSERT INTO kqw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","O Iesu i tasmani lena i sa pam rop ru tar a kum pinapam, ra i watungi lena, “A muruk.” I watungi lenri sur in pam sot pas a wasiso ra di sa tumus tari una Buk Tabu. ");
INSERT INTO kqw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","In teken nokoto na wain ra i mititir kura tiro. Det los pas ara utna ra i ser dop a polo, ra det puk pasi una wain ra. Det ubek pasi un in nanai ra di watungi namin isop, ra det tulsu toto i usapat sur a wan o Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ra o Iesu i sa dop pas a wain ra, i watungi lena, “I sa rop.” I lukun pirso in lorino, ra i ubek ru anun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A kum te Juda det saring o Pailat sur din sak pakpak tar a kum kikindetul, sur detul in mat lakit, ma din los pirso ru a pinindetul gusun a tulin nanai kutus, uni a bung ra, i a bung na waninar, a bung numugu tan ara labino Bung na Sabat, ma ka det nemi lena a pinindetul in kete una tulin nanai kutus una Bung na Sabat. ");
INSERT INTO kqw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Io, a kum tene inaim det wan, ma det sak pakpak aru kikin a mugano musano, ra numur ara pasander bulung, ra di sak wat tomo detul nam o Iesu una tulin nanai kutus. ");
INSERT INTO kqw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ikut ra det wanpat torom o Iesu, det tama i ra i sa mat, io, ka det sak pakpak aru kikino mo. ");
INSERT INTO kqw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ara tene inaim i so mukut a papor ino Iesu nama bele, ra a gap ma a danim i sal pirso mut. ");
INSERT INTO kqw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A musano ra i tama a kum utna ri, i wasiso uni sur mot kai mot in nurnur. A utna ri i wasiso uni, i lingmulus, ma i ut i tasmani lena i lingmulus. ");
INSERT INTO kqw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Di pam a kum utna ri sur din pam sot pas a wasiso ra di sa tumus tari una Buk Tabu lena, “Ka din sak pakpak tu sur ino.” ");
INSERT INTO kqw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Di pam sot pas a wasiso na Buk Tabu kai lena, “Det in tama i ra det so tari.” ");
INSERT INTO kqw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Numur, o Josep a te Arimatia i saring o Pailat sur a minat ino Iesu. I kai ara nat na ususer ra i ser murmur eno kut o Iesu, uni i ngaran a kum te Juda. Ra o Pailat i mulaot tari sur in nan ma in palos pirso pas a minat ino Iesu. ");
INSERT INTO kqw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","O Nikodimas, i ra numugu i wan torom o Iesu una ara bung na mirum, i kai i wanpat. I los pas ara utna ra i sangsangnain wakak, ra di pami tagun a mira ma a alo. A maut inder i elar nama tulunoino ma wat na kilogrem. ");
INSERT INTO kqw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Der los pas a minat ino Iesu, numur der ubek a kum utna ra i sangsangnain uni, ma der pulusi nama kum wakak na malu. A pinapam ra i elar nama ngasino anun a taro Juda, ra det ser pami una kum minat. ");
INSERT INTO kqw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ara kinobot kura milau nisan a nubual ra di sak wat o Iesu un in nanai kutus iai. Ara matok na kulam na minat kura tiro, ra ka di uinep utmakai tu minat uni. ");
INSERT INTO kqw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Det uinep tar a minat ino Iesu una kulam na minat ra, uni i milau kut. Det pami lenra uni a bung ra, i a bung na waninar, a bung numugu tan a Bung na Sabat anun a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Una komkobot raut una mugano bung una wik, ra i dumdumirum utmakai, o Maria Magdalen i wanpat tiro una kulam na minat. I tama i lena di sa ukarai ru tar a wat gusun a matansako na kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","I kalabor torom o Saimon Pita der nama nat na ususer ra o Iesu i ser nem doko i, ma i watungi tander lena, “Di sa los ru pas a Labino gusun a kulam na minat, ma ka met tasmani, ra kura di uinep tari awai.” ");
INSERT INTO kqw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Io, o Pita der nama nat na ususer ra, der wan sur a kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Der rop der kalabor, ikut ara pasander i kalabor pas gusun o Pita, ma i kalabor pat mugu tiro nisan a kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I par pirso, ma i kiet, ra i tama a kum malu, ikut ke ruk. ");
INSERT INTO kqw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","O Saimon Pita i wanpat murmur tano, ra i ruk una kulam na minat, ma i tama i mukut a kum malu det inep taru tiro iai. ");
INSERT INTO kqw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ikut in namalu ra di rau tar in lorin o Iesu nami, ke kis tomo nama kum malu. Di sa pul tari, ma di ubek gisen tari ut. ");
INSERT INTO kqw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Io, a nat na ususer, ra i mugu pat taru nisan a kulam na minat, i kai i ruk. I tama i ra i nurnur. ");
INSERT INTO kqw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ka der talapor utmakai una wasiso na Buk Tabu ra i lena, o Iesu in katutur melet gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Io, aru nat na ususer der milet melet sur a tamon. ");
INSERT INTO kqw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","O Maria Magdalen i tur nago utamon nisan a kulam na minat ma i tangis. Ra kura utmakai i tangis, i par pirso ma i kiet ruk una kulam na minat. ");
INSERT INTO kqw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","I tama pas aru ensel kura der tiro, der emar nama kum kamkabang na malu ma der kis taru una nubual ra di uinep tar a minat ino Iesu iai. Ara i kis una ulalong, ma ara pasander i kis una papadus. ");
INSERT INTO kqw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Der tingi lena, “Le, ulai ra u tangis?” I balu der lena, “Det sa los gisen ru anung a Labino, ma ka tasmani ra kura mo di uinep tari awai.” ");
INSERT INTO kqw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ra i tupukus, i tama pas o Iesu kura i tur taru, ikut ke tasmani lena o Iesu ut ra. ");
INSERT INTO kqw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","O Iesu i tingi lena, “Le, ulai ra u tangis? Osi ra u sisio suri?” O Maria i nuki lena a musano ra, i a tene tamtamabat a kinobot, ra i watungi tano lena, “Ra ui u los gisen ru a minat ino Iesu, un inanos iau ra kura u uinep tari awai, sur an nan ma an los pasi.” ");
INSERT INTO kqw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","O Iesu i watungi tano lena, “Maria!” Ra o Maria i tupukus ma i watungi tano nama wasiso Ibru lena, “Raboni!” a kukuraino lena tene ususer. ");
INSERT INTO kqw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","O Iesu i watungi tano, “Gong u pam a pining, uni ka wan toto utmakai torom o Tita. Ikut un nan torom a kum tistising, ra un inanos det lena, an nan usapat netes torom o Tita, i ra a Tamamot kai, torom anung a God, i ra anumot a God kai.” ");
INSERT INTO kqw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Io, o Maria Magdalen i wan torom a kum nat na ususer ra i inanos det lena, “A sa tama tar a Labino.” Ma i inanos det kai una kum utna ra o Iesu i sa watung tari tano. ");
INSERT INTO kqw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ra i mirum una mugano bung una wik, a kum nat na ususer det kis tomo, ma det ukaibat pas det tagisa urumu, uni det ngaran a ramano kum te Juda. O Iesu i wanpat ma i tur epotor tandet, ra i watungi tandet lena, “A malmal torom mot.” ");
INSERT INTO kqw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ra i sa watung tari lenri, i ese aru lamano ma a paporino tandet. A kum nat na ususer det gas doko, ra det tama a Labino. ");
INSERT INTO kqw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","O Iesu i watung meleti tandet lena, “A malmal torom mot. O Tita i tulu ru iau, lenkutkai ra a tulu mot.” ");
INSERT INTO kqw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ra i sa watung tari lenri, i wup det nama wuwu na wano, ma i watungi tandet lena, “A Tokodos na Nion ri, mot in utur ukai i una nilaun anumot. ");
INSERT INTO kqw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ra mot in dumano ru a kum sakino petutna anun taio, o God kai in unus ru i gusuni. Ra ka mot in dumano ru tu sakino petutna anun taio, o God kai ken unus ru i.” ");
INSERT INTO kqw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","O Tomas, ra di watungi kai nama kasango, i ara gusun det a noino ma aru nat na ususer, ke kis tomo nam det ra o Iesu i wanpat pas torom det. ");
INSERT INTO kqw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","A kum nat na ususer ka det mana nama inanosi lena, “Met sa tama tar a Labino!” O Tomas i watungi kut tandet lena, “Ra kan tama a kinan a nil una aru lamano, ma kan uruk in kaskas na lamang uni, ma ra kan uruk a lamang una kinan a bele una papor ino, iau kan nurnur.” ");
INSERT INTO kqw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ra i sa ra wik bati, a kum nat na ususer det kis tomo melet tiro urumu, det tomo nam o Tomas. Det ukaibat pas det ut tagisa urumu. Ikut o Iesu i tur puaso epotor tandet, ra i watungi tandet lena, “A malmal torom mot!” ");
INSERT INTO kqw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Numur i watungi tan o Tomas lena, “Uruk in kaskas na lamam nin, ma un tama aru lamang. Tulsu a lamam urin, ma un uruki una paporing. Ra gong mo u ur nuknuk, un nurnur kut.” ");
INSERT INTO kqw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","O Tomas i watungi tano lena, “Anung a Labino ma anung a God!” ");
INSERT INTO kqw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","O Iesu i inanosi lena, “U nurnur maragom uni u tama iau, niko? Det ra ka det tama iau, ikut det nurnur, det dan.” ");
INSERT INTO kqw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","O Iesu i pam a susut na ukinalong kai umatan anun a kum nat na ususer, ra ka di tumus ukai det una buk ri. ");
INSERT INTO kqw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ikut di tumus ukai pas a ramano kum utna ri, sur mot in nurnur lena o Iesu i a Karisito, a Nutun o God. Ra mot in nurnur uni, mot in laun nama risano. ");
INSERT INTO kqw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","O Iesu i wanpat melet torom anun a kum nat na ususer una usalin ina du tasi Tiberias. ");
INSERT INTO kqw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","I lenri: Ara bung o Saimon Pita ma o Tomas, ra di watungi kai nama kasango, ma o Natanael a te Kana tagun a papor Galili, ma aru nutun o Sebedi, ma aru kai tagun a kum nat na ususer, det kis tomo. ");
INSERT INTO kqw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ra o Saimon Pita i watungi tandet lena, “An nan, an woro a bene.” Det balu i lena, “Dat tomo.” Io, det kas pas una pot ra det wan. Ikut una bung na mirum ra, ka det dat lako kiripo. ");
INSERT INTO kqw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Una komkobot raut, o Iesu i tur taru nago una usalin, ikut a kum nat na ususer ka det tasmani lena o Iesu ut ra. ");
INSERT INTO kqw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ra o Iesu i kakabo torom det lena, “A kum nat, mot dat pas lako kiripo ut?” Det ipul kut lena, “Awu.” ");
INSERT INTO kqw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O Iesu i watungi tandet lena, “Mot in woro a bene una papor sot na lamamot, sur mot in dat lako kiripo.” Det woro i lari ra i watungi. Io, det lagano datdat tar a bene, uni i bukus nama kum kiripo. ");
INSERT INTO kqw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A nat na ususer ra o Iesu i nem doko i, i watungi tan o Pita lena, “A Labino ut nago!” O Saimon Pita i longori lena a Labino ut nago, ra i pipis melet pas in namalu ra i palos tari ra i woro a bene, ma i sirok losop utiro utasi. ");
INSERT INTO kqw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A kum nat na ususer det mur nama pot unago una usalin. Ma det dat piso pas a bene ra i bukus nama kum kiripo, uni ka det bakbak gusun a usalin, i elar kut nama limo na noino sinanga. ");
INSERT INTO kqw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Det sirok gusun a pot, ra det tama a lakit na sungun ma a kiripo kusapat netes uni, ma det tama kai a beret. ");
INSERT INTO kqw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","O Iesu i watungi tandet lena, “Mot in los lako kiripo urin tagun a kum kiripo ra uniutri mot bene pasi.” ");
INSERT INTO kqw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Io, o Pita i kas una pot, ra i dat pirso a bene unago una usalin, ma i ulit ru a kum kiripo gusuni. I bukus nama kum lamlabino kiripo, a niluluk indet i elar nam ara mar ma limo na noino ma tul. Det susut doko, ikut a bene ke tararos. ");
INSERT INTO kqw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","O Iesu i watungi tandet lena, “Mot wan urin ma mot in nangon.” Kataio tagun anun a kum nat na ususer i pet lar pasi sur in tingi lena, “Ui osi?” Det sa tasmani lena i a Labino ut ra. ");
INSERT INTO kqw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","O Iesu i los pas a beret ma i tabor det nami, ra numur i tabor det bulung nama kiripo. ");
INSERT INTO kqw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iri i, a mantulu dino ra o Iesu i wanpat torom anun a kum nat na ususer, numur tan anun a katkatutur melet gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ra det sa wangon rop, o Iesu i watungi tan o Saimon Pita lena, “Saimon, nutun o Jon, u nem doko iau taun det ri, niko?” I balu i lena, “Lingmulus, Labino, u tasmani lena a nem ui.”O Iesu i watungi tano lena, “Un tabor anung a kum nat na sipsip.” ");
INSERT INTO kqw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","O Iesu i manru iting toromi lena, “Saimon, nutun o Jon, pepetlai, u nem doko iau?” I balu i lena, “Lingmulus, Labino, u tasmani lena a nem ui.” Ma o Iesu i watungi tano lena, “Un tamtamabat anung a kum sipsip.” ");
INSERT INTO kqw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ra o Iesu i mantulu dino u watungi tano lena, “Saimon, nutun o Jon, pepetlai, u nem iau?” O Pita i tupunuk, uni o Iesu i tingi a tulu dino lena, “U nem iau?” I watungi tano lena, “Labino, u tasman a kum utna rop. U tasmani lena a nem ui.” Ma o Iesu i watungi tano lena, “Un tabor anung a kum sipsip. ");
INSERT INTO kqw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“A inanos ui nama lingmulus, ra u barman, ui ut u ser mar pas ui, ma u ser wan una kum nubual ra u nem na wan iai. Ikut ra un takano, un kodos aru lamam, ma ara gisen ut in mar ui, ma in ben tar ui una nubual ra ko nem na wan iai.” ");
INSERT INTO kqw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","O Iesu i watung lenri, sur in ese a ngas na iniru ra in los o Pita. Un anun a iniru ra, in ulabo pas o God. Ra i sa watung tari lenri, i inanosi lena, “Un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","O Pita i tur tupukus ma i tama a nat na ususer ra o Iesu i ser nem doko i, kura i mur der. A nat na ususer ra, i ra i ere torom o Iesu una nundet a tintinip na inangon, ra i ting o Iesu lena, “Labino, osi ra in usobor tar ui?” ");
INSERT INTO kqw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","O Pita i tama i, ra i ting o Iesu uni lena, “Labino, pepetlai un o naro ri?” ");
INSERT INTO kqw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","O Iesu i balu o Pita lena, “Ra a nemi lena in laun tuk an milet, ausur a utna anumi. Ikut ui, un mur iau.” ");
INSERT INTO kqw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A wasiso i wanpat torom det ra det nurnur, lena a nat na ususer ri ken mat. Ikut o Iesu ke watungi lena ken mat, awu, i watungi kut lena, “Ra a nemi lena in laun tuk an milet, ausur a utna anumi.” ");
INSERT INTO kqw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A nat na ususer ri, i ra i wasiso puaso una kum utna ri, ma i tumus ukai i. Ma dat tasmani lena a kum utna ri i wasiso puaso uni, i lingmulus sakit. ");
INSERT INTO kqw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A susut na utna utkai o Iesu i sa pam tari. Ra gunuk din tumus rop pas det taktakai, a nuki lena a rakrakon bual ke labo sur din ubek a kum buk rop uni. ");
INSERT INTO kqw_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Iau o Pol, o Sailas, ma o Timoti, metul tumtumus torom mot a taro na lotu tong o Tesalonaika, mot ra mot laun un o God a Tamandat ma a Labino o Iesu Karisito. A marmaris ma a malmal torom mot. ");
INSERT INTO kqw_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Metul ser watung wakak torom o God un mot rop, ma metul ser pitar tar mot torom o God una numetul a kum niaring. ");
INSERT INTO kqw_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Ra metul wararing torom anundat a God a Tamandat, metul nuk pas anumot a kum pinapam i kibino una numot a nurnur, ma metul nuk pas a kum pinapam i kibino una numot a marmaris, ma metul nuk pasi kai, anumot a tuntunur dekdek, i kibino una numot a kinkinis langlang nama nurnur una Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","A kum tistisimetul, mot ra o God i maris mot, metul tasmani lena i sa pilok pas mot, ");
INSERT INTO kqw_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","uni a Wakak na Wasiso ra metul upuaso i, ausur i wanpat torom mot elar nama wasiso kut, awu. I wanpat tomo nam a dekdek ma a Tokodos na Nion, ma mot longoro lele i ra mot pam ukai i una balamot. Ra metul laun nisamot, mot tasman wakak a magirametul, ra metul ser upuaso i sur in pet wakak mot. ");
INSERT INTO kqw_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Mot sa mur pas a magirametul ma a magiran a Labino. A taro det banlaulau mot, ikut mot pam ukai a wasiso nam a gasgas, ra a Tokodos na Nion i pitar tari tamot. ");
INSERT INTO kqw_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Mot wanpat a wakak na larlar torom a taro na nurnur rop tiro una aru papor, o Masedonia ma o Akaia. ");
INSERT INTO kqw_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","A wasiso anun a Labino ra mot upuaso i, i sa wan sarara, elar nam a tinangis ina garamut, ra i wan bakbak. Ausur tiro kut o Masedonia ma o Akaia, awu. A kum tamon rop det sa tasman anumot a nurnur un o God. Asau melet mo ra metul in watungi? ");
INSERT INTO kqw_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Uni det ut det wasiso talapor una numot a wakak na petutna ra mot gas pas metul. Ma det wasiso talapor kai un mot, lena mot sa tupukus torom o God, ma ka mot lotu mo torom a kum toktok. Mot papam mo torom o God, i ra a lingmulus ino ma a lalaun ino. ");
INSERT INTO kqw_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Ra mot kis langlang sur a Nutunu, ra in nan pirso tagisapat una langit, i ra o God i sa ukatutur melet pasi gusun a minat. O naro ra o Iesu, ra i ulaun pas dat gusun a kankan anun o God, ra in nanpat. ");
INSERT INTO kqw_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","A kum tistisimetul, mot ut mot tasmani lena, anumetul a inawan pat torom mot ke utna oros, ikut, i wu ut a wino. ");
INSERT INTO kqw_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Mot tasmani lena numugu tana numetul a inawan pat torom mot, a taro det banlaulau metul ma det ban umaimai metul tong o Pilipai. Ikut anundat a God i warut metul, ra metul dekdek ut sur metul in wasiso puaso una nuna Wakak na Wasiso torom mot, ma ka metul ngaran det ra det lari sur det in sakbat metul. ");
INSERT INTO kqw_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Ra metul saring mot sur mot in nukpukus, ausur anumetul a wasiso i raro, ausur kai metul wasiso nam tu sakino nuknuk, ma ausur metul toro pas mot. ");
INSERT INTO kqw_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Awu! Metul wasiso puaso nam a Wakak na Wasiso, uni o God i sa lar tar metul, ma i nurnur un metul lena metul in pami. Ka metul wasiso puaso sur metul in ugasgas a taro nami, awu, sur o God ut in gas uni, i ra i sa lar tar metul. ");
INSERT INTO kqw_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Mot sa tasmani lena ka metul ugasgas mot nam tu wasiso na umarom, ma ka metul nemnem eno sur tu mani gusun mot. O God i tama i ma i tasman metul. ");
INSERT INTO kqw_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Ka metul nemi sur mot o taio gisen kai in watung ulabo pas metul. ");
INSERT INTO kqw_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","I tokodos sur metul in saring mot sur tu ikul, uni metul a tulu aposel anun o Karisito. Ikut ka metul pami lenra. Metul upuaso a balano wakak epotor tamot, elar nam a ino ra i tamtamabat a kum nutnutunu. ");
INSERT INTO kqw_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Metul nem doko mot, ra metul gas doko sur metul in inanos mot una Wakak na Wasiso anun o God. Ausur i kut ra, awu, metul gas utkai sur metul in pitar anumetul a nilaun kai torom mot, uni mot ngatngat doko umatametul. ");
INSERT INTO kqw_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","A kum tistisimetul, mot sa tasman anumetul a dekdek na pinapam. Una kum mirum ma a waspi, metul papam nama lamametul sur u warut metul una numetul a kinkinis. Metul pami lenri, sur metul in warawai torom mot nama Wakak na Wasiso anun o God ma gong metul pitar a mamaut torom mot sur mot in kul metul. ");
INSERT INTO kqw_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Mot ut, ma o God kai, mot tama a magirametul ra metul kis epotor tamot, a kum tene nurnur. A magirametul i talapor ma i tokodos, ma katu etakun i los metul un tu utna. ");
INSERT INTO kqw_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Mot tasmani lena anumetul a petutna torom mot rop taktakai, i elar nam a petutna ra ara musano i pami torom a kum nutnutunu. ");
INSERT INTO kqw_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Metul udekdek mot, metul wasiso na emarom torom mot, ma metul inanos mot sur mot in laun nam a ngas na nilaun ra i ugasgas o God, i ra i kabo pas mot sur anun a matanitu ma anun a minamar. ");
INSERT INTO kqw_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Ara kibino kai ra metul ser watung wakak torom o God i lenri: Ra mot rakon ukai a wasiso anun o God, ra mot longoro i gusun metul, mot mulaot pasi. Ausur mot mulaot pasi elar nam a wasiso kut anun a taro, awu, mot mulaot pasi uni a wasiso ra, i a wasiso ut anun o God. A wasiso ra, kura i papam una nilaun anumot ra mot sa nurnur. ");
INSERT INTO kqw_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","A kum tistisimetul, mot elar nama taro na lotu anun o God una Karisito o Iesu, ra det kis tong una papor Judia. Uni, mot kai, mot taramo a ngunungut tan a taro tagun anumot a tamon ut, i elar nama taro na lotu tong o Judia det taramo i tan anundet a taro ut, a taro Juda, ");
INSERT INTO kqw_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","det ra det um doko a Labino o Iesu ma a kum poropet, ma det lu ru metul kai. O God ke gas nam det, ma det kis na ebar nama taro rop, ");
INSERT INTO kqw_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","uni det lari sur det in turbat metul, sur gong metul warawai torom a taro ra ausur a taro Juda sur gong o God i ulaun pas det. Ma una nundet a petutna ra, det pam tomotomo i kut anundet a kum sakino petutna. Ikut a kankan anun o God i sa wanpat maragom torom det. ");
INSERT INTO kqw_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","A kum tistisimetul, ra a taro Juda det ukis sarara ru metul gusun mot, anundat a kinkinis sarara ke suano i. Dat kis sarara kut una pinindat, ikut una nuknukimetul metul nuk mot ut. Metul nem doko i sur metul in tama mot, ra metul dekdek sur metul in pam sot pasi. ");
INSERT INTO kqw_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Metul nem doko i sur metul in milet melet torom mot. Iau, o Pol, a lari a susut na dino sur an nan torom mot, ikut o Satan i turbat metul. ");
INSERT INTO kqw_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Metul nem doko i sur metul in tama mot melet, uni metul nurnur un mot lena mot sa tur dekdek, ma mot, mot kibino una numetul a gasgas, ma mot kibino una numetul a kunukul tagun anumetul a pinapam, una bung ra anundat a Labino o Iesu in nanpat, ma dat in tur umatano. ");
INSERT INTO kqw_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","I lingmulus sakit ra mot ut a numetul a minamar ma a numetul a gasgas. ");
INSERT INTO kqw_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Una numetul a nuknuk na nginara un mot, ka metul nem na kis liklik mo. Metul nuki lena i wakak sur mir kut nam o Sailas, mir in kis nin o Atens. ");
INSERT INTO kqw_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Ra mir sa tulu ru o Timoti a tisindat, ma a tene pinapam anun o God tomo nam mir, ra metul ser wasiso talapor nam a Wakak na Wasiso una Karisito. Mir sa tulu ru i torom mot, sur in udekdek mot, ma in warut mot una numot a nurnur, ");
INSERT INTO kqw_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","sur gong taio tagun mot a nuknukino i talara kibino una kum mamaut ra i monong mot. Uni mot tasmani ut lena a kum mamaut in monong dat. ");
INSERT INTO kqw_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Ra dat kis tomo utmakai, metul ser inanos mot lena din banlaulau dat. Ma mot sa tasmani lena, a kum mamaut ra, i sa wanpat ut. ");
INSERT INTO kqw_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","I mo ra a tulu ru o Timoti torom mot. A tulu ru i torom mot sur an mananos una numot a nurnur, uni a ngara doko un mot ma ka nem na kis liklik mo. A ngara, sako a Tene Ululam i sa ulam pas mot, ma sako anumetul a pinapam torom mot in utna oros kut. ");
INSERT INTO kqw_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Uniri o Timoti i sa milet melet gusun mot tagitiro urin sur mir. I los a wakak na wasiso talapor un mot torom mir, una numot a nurnur ma anumot a marmaris. I inanos mir lena, mot ser gas ra mot ser nuk melet pas anundat a kum kinkinis tomo numugu, ma mot nem doko i sur mot in tama metul, elar nam metul kai metul nem doko sur metul in tama mot. ");
INSERT INTO kqw_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","A kum tistisimetul, anumot a nurnur i udekdek metul una numetul a kinkinis ubalan a kum mamaut, ma a kum petutna ra a taro det banlaulau metul nami. ");
INSERT INTO kqw_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Uniri anumetul a nilaun i wakak doko, uni mot tur dekdek una Labino. ");
INSERT INTO kqw_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Metul gas doko nam mot umatan anundat a God, ma metul watung wakak toromi. Metul in watung wakak pepetlai toromi? Uni anumetul a gasgas i labo doko. ");
INSERT INTO kqw_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Una kum mirum ma a waspi, metul pitar rop tar anumetul a nilaun una niararing sur mot. Metul wararing sur metul in tama melet mot, ma metul in ususer mot un lako kum utna ra mot sibo utmakai suri una numot a nurnur. ");
INSERT INTO kqw_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Metul wararing lena, o God ut a Tamandat ma anundat a Labino o Iesu, in papos anumetul a kisapi sur metul in nan torom mot. ");
INSERT INTO kqw_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Ma metul wararing kai sur a Labino in ulabo anumot a marmaris ma in bukus ma in tilingis epotor tamot ma torom a taro gisen kai, elar nama numetul a marmaris kai torom mot. ");
INSERT INTO kqw_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Ma metul wararing kai sur in udekdek mot sur mot in tokodos, ma katu etakun in los mot, ra mot in tur umatan o God a Tamandat, una bung ra anundat a Labino o Iesu in nanpat, tomo nam anun a tokodos na taro rop. ");
INSERT INTO kqw_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","A kum tistisimetul, metul sa ususer tar mot una ngas na nilaun ra mot in laun nami sur in ugasgas o God, lar ut ra mot sa muri. Ra uniri metul saring mot, ma metul udekdek mot una risan a Labino o Iesu, sur anumot a nilaun in lubung dekdek lenutra. ");
INSERT INTO kqw_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Uni mot sa tasman a kum etowo ra metul sa ususer tar mot nami. A kum etowo ra, det wanpat ut tana Labino o Iesu. ");
INSERT INTO kqw_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","O God i nemi lena, anumot a nilaun gong i dur umatano, ra mot in nan gisen gusun a kum pamuk na petutna. ");
INSERT INTO kqw_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Ara ra tagun mot in dekdek sur in turbat a nemnem na pinino, sur a petutna na urur in kis una nun a nilaun ma gong i dur. ");
INSERT INTO kqw_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Ma gong mot mur a dekdek na nemnem ina pamuk na petutna, elar nam det ra ka det tasman o God. ");
INSERT INTO kqw_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Gong tu pasamot i pam a sakino una ino anun tu tisino ra i nurnur. Ra in pami lenra i usobor o tisino. Metul sa watung tari, ma metul sa utumarong tar mot lena, a Labino in pitar a warkurai na minabalu torom det, ra det ser pam a kum petutna lenri. ");
INSERT INTO kqw_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Uni, o God ke kabo pas dat sur a dur na petutna, i kabo pas dat sur dat in mur a tokodos na nilaun. ");
INSERT INTO kqw_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Osi ra i rosumur gusun a etowo ri, ausur i rosumur gusun a taro, awu. I rosumur ut gusun o God, i ra i tabor dat nam a Niono, a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Ka metul in tumtumus melet mo torom mot una numot a marmaris torom a kum tistisimot, uni, o God i sa ususer tar mot sur mot in nem etetalai mot. ");
INSERT INTO kqw_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","A lingmulus ut, mot nem a kum tistisimot rop tiro una papor Masedonia rop. Ikut, metul saring mot sur anumot a marmaris in lubung dekdek ut. ");
INSERT INTO kqw_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Mot in dekdek sur anumot a nilaun in lenri: Mot in kis na malmal, ma gong mot uruk lorimot sur tu utna anun taio. Mot in papam nama lamamot sur a amot a utna na inangon, elar nami ra metul sa watung tari tamot. ");
INSERT INTO kqw_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Ra mot in pami lenra, a taro ra ka det nurnur det in ru mot, ma ka mot in nura taio sur in tabor mot. ");
INSERT INTO kqw_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","A kum tistisimetul, metul nemi lena mot in mananos un det ra det sa mat, ma gong mot tupunuk dekdek elar nam a taro ra ka det nurnur una katkatutur melet gusun a minat. ");
INSERT INTO kqw_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Dat nurnur lena o Iesu i mat, ma i laun melet. I mo ra dat nurnur lena, det ra det nurnur un o Iesu, ma det sa mat, o God in ukatutur det ma det in nan tomo nam o Iesu, ra in milet melet. ");
INSERT INTO kqw_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","A wasiso ri ra metul watungi tamot, a wasiso ut anun a Labino. I lenri: Dat ra dat sa laun tuk una bung ra a Labino in nanpat melet, ka dat in mugu tandet ra det sa mat. ");
INSERT INTO kqw_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Uni a Labino ut in nan pirso tagisapat una langit, in nalngan ara in kakabo, a mugumugu anun a kum ensel in wasiso, in tuwuru anun o God in tangis, ra det ra det sa mat nama nurnur un o Karisito, det in katutur mugu. ");
INSERT INTO kqw_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Numur dat ra dat laun utmakai, din los tomo pas dat nam det usapat una kum du bakut sur dat in etorom nama Labino una maino. Ra dat in kis tukum tomo nama Labino. ");
INSERT INTO kqw_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Mot in udekdek etetalai mot nama kum wasiso ri. ");
INSERT INTO kqw_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","A kum tistisimetul, ka metul in tumtumus torom mot una du bung ma a bung ra a Labino in nanpat uni. ");
INSERT INTO kqw_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Uni mot sa tasman wakaki lena, a bung anun a Labino in nanpat kisin, elar nama tene wolong una mirum. ");
INSERT INTO kqw_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Ra a taro det in watungi lenri, “Ai, ka dat taramo tu maut. A wakak na nilaun kut ri dat taramo i,” a iniru in nanpat kisin torom det, elar nama ngunungut ra a ino i taramo i ra i milau sur in usus. Ka det in kalabor eno pas gusun a iniru. ");
INSERT INTO kqw_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Ikut mot, a kum tistisimetul, a bung ra ken ukisin mot, elar nama tene wolong, uni ausur mot kis una dumirum. ");
INSERT INTO kqw_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Mot rop a kum nutnutun a talapor ma a kum nutnutun a waspi. Ausur dat tagun a mirum o tagun a dumirum. ");
INSERT INTO kqw_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Ra gong dat elar nam ara taro ra det inep dumun. Dat in koikoi ma dat in warkurai wakak anundat a nilaun. ");
INSERT INTO kqw_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Uni det ra det inep dumun, det ser inep una mirum, ma det ra det ininum, det ser inum una mirum. ");
INSERT INTO kqw_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Ikut dat tagun a waspi, i wakak sur dat in warkurai wakak anundat a nilaun. Dat in mar dat nama nurnur ma a marmaris sur in tamtamabat dat, elar nama tene inaim ra i ubek bat a romrobono nama du aen. Ma dat in mar dat kai nama kinkinis langlang nama nurnur sur a ululaun, elar nama tene inaim i ubek bat in lorino nama kukup tagun a inaim. ");
INSERT INTO kqw_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Uni o God ke pilok pas dat sur dat in taramo a ngunungut ubalan anun a kankan, awu. I pilok pas dat sur dat in los a ululaun una nundat a Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","I mat un dat sur dat in laun tomo nami, ra in nanpat melet. Dat rop, det ra det laun utmakai ma det ra det sa mat. ");
INSERT INTO kqw_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","I mo ra, mot in wasiso na warut torom mot etetalai, ma mot in udekdek mot, lenutra mot ser pami. ");
INSERT INTO kqw_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","A kum tistisimetul, metul saring mot sur mot in pitar a urur torom anumot a kum mugumugu, ra det papam dekdek epotor tamot, ma det ususer mot. ");
INSERT INTO kqw_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Mot in ese a labino urur ma a marmaris torom det, kibino una nundet a pinapam. Ma mot in kis na malmal etetalai. ");
INSERT INTO kqw_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","A kum tistisimetul, metul saring mot sur mot in tumarong a kum tubunu wok na taro, mot in udekdek det ra det ser ngara, mot in warut det ra ka det dekdek una nurnur, ma mot in ese a wowowon na petutna torom a taro rop. ");
INSERT INTO kqw_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Gong mot balu a sakino nama sakino. Mot in dekdek sur mot in pam a wakakino etetalai torom mot, ma torom a taro rop kai. ");
INSERT INTO kqw_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Mot in ser gasgas. ");
INSERT INTO kqw_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Gong mot mana nama niaring. ");
INSERT INTO kqw_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Mot in watung wakak torom o God un asau rop ra i wanpat torom mot, uni iri a nemnem ut anun o God torom mot, a taro anun a Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Gong mot turbat a pinapam anun a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Gong mot nuk penpen una kum wasiso na poropet. ");
INSERT INTO kqw_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Mot in lar rop a kum wasiso ma a kum petutna, ra mot in utur ukai a wakak ino. ");
INSERT INTO kqw_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Ma mot in nan gisen gusun a kum sakino rop. ");
INSERT INTO kqw_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Metul wararing sur o God ut, a God na malmal, in uwakak pas anumot a nilaun, sur mot in tokodos rop umatano. Metul wararing kai sur o God in tamtamabat a niomot, a nuknukimot ma a pinimot, sur gong tu etakun in los mot una bung ra anundat a Labino o Iesu Karisito in milet uni. ");
INSERT INTO kqw_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","O naro ra i kabo pas mot in pami lenutra, uni i lingmulus. ");
INSERT INTO kqw_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","A kum tistisimetul, mot in wararing sur metul. ");
INSERT INTO kqw_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Mot in nem a kum tistisimot nama egom na marmaris, ma mot in pami elar nama tokodos na petutna. ");
INSERT INTO kqw_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","A saring mot nama risan a Labino sur mot in luk a pas ri torom a kum tistisindat rop. ");
INSERT INTO kqw_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","A marmaris anun anundat a Labino o Iesu Karisito in kis tomo nam mot. ");
INSERT INTO kqw_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Iau o Pol, o Sailas ma o Timoti, metul tumtumus torom mot a taro na lotu tong o Tesalonaika, mot ra mot laun uno God a Tamandat ma a Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","A marmaris ma a malmal torom mot tan o God a Tamandat ma a Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","A kum tistisimetul, i wakak sur metul in ser watung wakak torom o God un mot. I tokodos lenra, uni anumot a nurnur i lubung dekdek, ma a marmaris torom mot etetalai kai i lubung nanan. ");
INSERT INTO kqw_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","I mo ra, metul ut metul ser watung ulabo pas mot torom a taro na lotu anun o God una kum tamon. Metul ser watung ulabo pas mot una numot a tuntunur dekdek ma anumot a nurnur, ubalan a kum mamaut ra mot taramo i ma a kum ngunungut ra a taro det banlaulau mot nami. ");
INSERT INTO kqw_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","A kum utna rop ri, i upuaso i lena, a warkurai anun o God i tokodos. Mot taramo a ngunungut, uni mot ulabo anun a matanitu. Uni ra, o God in watung mot lena, mot tokodos sur anun a matanitu. ");
INSERT INTO kqw_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","O God i tokodos, ma in ukadik det ra det ukadik mot, ");
INSERT INTO kqw_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ma in pitar a mana torom mot ra mot taramo a ngunungut, ma lenkutkai ra torom metul. O God in pami lenra, una bung ra a Labino o Iesu in nanpat tagisapat una langit nama kunabor na sungun ma anun a kum dekdek na ensel. ");
INSERT INTO kqw_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","In ukadik det ra ka det tasman o God, ma ka det longoro a Wakak na Wasiso anun anundat a Labino o Iesu. ");
INSERT INTO kqw_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Det in taramo a warkurai na minabalu ra ken rop, i a iniru tukum, ma det in kis gisen gusun a Labino ma a minamar ina dekdekino. ");
INSERT INTO kqw_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","A warkurai ri in nanpat una bung ra a Labino in nanpat sur din ulabo pasi kibino una nun a tokodos na taro, ma det rop ra det nurnur uni det in ru i. Mot kai tomo nam det, uni mot nurnur una numetul a wasiso talapor torom mot. ");
INSERT INTO kqw_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","I mo ra metul ser wararing sur mot torom anundat a God, sur in watung mot lena mot tokodos sur a ngas na nilaun ra i kabo pas mot suri. Ma una dekdekino in warut mot, sur mot in pam sot pas a kum wakak na pinapam ra mot nem na pami, ma a kum petutna rop ra anumot a nurnur i pam pati. ");
INSERT INTO kqw_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Metul wararing lenra, sur din ulabo pas a risan anundat a Labino o Iesu kibino un mot, ma o God kai in pitar a minamar torom mot. A kum utna rop ri, in nanpat kibino una marmaris anun anundat a God, ma a Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","A kum tistisimetul, metul nem na inanos mot una inawan pat melet anun anundat a Labino o Iesu Karisito, ma una nundat a inawan tomo toromi. Metul inanos mot, ");
INSERT INTO kqw_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","gong a nuknukimot i talara lakit ma i lokolokor ra mot longoro i lena, a bung anun a Labino i sa wanpat. Ra tu wasiso na poropet, o tu inarang, o tu pas in wasiso lenra, ma din watungi kai lena taginin tametul, gong mot nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Gong mot madek tar taio sur in toro mot nam tu wasiso o tu kisapi sur mot in muri. Uni a bung ra, ken nanpat utmakai, tuk ut ra, lako susut na taro det in rosumur gusun o God, ma a tene lakai warkurai in nanpat pupuaso, i ra, numur in iru. ");
INSERT INTO kqw_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","In ebar torom a kum utna rop ra a taro det watung det a kum god ma det lotlotu torom det, ma in ulabo pasi ut, sur in kis una rumu na etabor anun o God, ma in watung puaso i lena, i ut o God. ");
INSERT INTO kqw_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Ra a kis tomo nam mot, a ser inanos mot nama kum utna ri. Pepetlai, ka mot nuk melet pasi mo? ");
INSERT INTO kqw_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Mot sa tasman asau ra i turbat a tene lakai warkurai, sur in nanpat puaso una du bung ra in sot. ");
INSERT INTO kqw_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","A dekdek ina lakai warkurai kuri i sa papam eno nanan una rakrakon bual. Ikut, i ra i turbat tari, in turbati utmakai, tuk una bung ra din rakon ru i. ");
INSERT INTO kqw_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Numur a tene lakai warkurai in nanpat puaso, ma a Labino o Iesu in kamar ru i nam a wuwu na wano, ma in banlaulau i nam a minamar ina nun a inawan pat. ");
INSERT INTO kqw_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","A tene lakai warkurai in nanpat nama dekdek ino Satan, ma in ese a kum ngas na torotoro na dekdek, ma a kum torotoro na ukinalong ma a kum torotoro na utna na ukisin. ");
INSERT INTO kqw_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Una kum ngas na sakino rop ra in pami, in toro a taro ra det wanan sur a iniru. Det in iru uni, ka det mulaot sur det in nem a lingmulus ino, sur o God in ulaun det. ");
INSERT INTO kqw_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Iri i, a kibino ra o God i ulokolokor a nuknukindet sur det in nurnur mukut una torotoro. ");
INSERT INTO kqw_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","I mo ra, det ra ka det nurnur una lingmulus ino, ma det gas kut una sakino, det rop det in iru una warkurai anun o God. ");
INSERT INTO kqw_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","A kum tistisimetul, mot ra a Labino i maris mot, i wakak sur metul in ser watung wakak torom o God un mot, uni o God i sa pilok pas mot tagun a turturkibino sur in ulaun mot. I ulaun pas mot una nirurus talapor ra a Tokodos na Nion i pami un mot, ma una numot a nurnur una lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Una Wakak na Wasiso ra metul warawai nami, o God i kabo pas mot sur in ulaun mot, sur mot in los a tinibo kai tagun a minamar anun anundat a Labino o Iesu Karisito. ");
INSERT INTO kqw_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","I mo ra, a kum tistisimetul, mot in tur dekdek, ma mot in utur ukai a kum etowo ra metul sa ususer tar mot nami. A kum etowo ra metul sa watung tari ma metul sa tumus tari kai, torom mot. ");
INSERT INTO kqw_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","O God a Tamandat, i maris dat, ma una nun a marmaris i tabor dat nama wasiso na umarom ra ken rop, ma i warut dat sur dat in kis langlang nama nurnur sur a wakak ino ra in pami. Ra metul wararing sur anundat a Labino o Iesu Karisito ma o God a Tamandat ");
INSERT INTO kqw_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","in ukarik mot ma in udekdek mot una numot a kum wakak na pinapam ma a kum wakak na wasiso kai. ");
INSERT INTO kqw_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","A kum tistisimetul, iri i a tintinip na wasiso anumetul, mot in wararing un metul, sur a wasiso anun a Labino in nan sarara lakit ma a taro det in ru i elar nam mot, mot ru i. ");
INSERT INTO kqw_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Ma mot in wararing un metul sur o God in ulaun metul gusun a sakino taro, uni ausur a taro rop a kum tene nurnur. ");
INSERT INTO kqw_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Ikut a Labino i lingmulus, ma in udekdek mot ma in tamtamabat mot kai gusun o Satan. ");
INSERT INTO kqw_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Metul nurnur una Labino lena kura ut mot mur a kum wasiso ra metul sa inanos tar mot uni, ma mot in ser muri lenutra. ");
INSERT INTO kqw_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Metul wararing sur a Labino in mugu a nuknukimot sur mot in tasman mulus a marmaris anun o God, ma mot in tasmani kai a tuntunur dekdek una kum mamaut ra o Karisito i sa ese tari torom dat. ");
INSERT INTO kqw_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","A kum tistisimetul, metul saring dekdek mot nama risan a Labino o Iesu Karisito lena, mot in nan gisen gusun a kum tubunu wok na tistisindat ra ka det ser mur a kum etowo ra metul inanos tar mot nami. ");
INSERT INTO kqw_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Mot ut mot sa tasmani lena, i wakak ra mot in mur a ngasino ra metul sa pam tari umatamot. Ra metul kis tomo nam mot, ausur metul kis oros kut. ");
INSERT INTO kqw_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Ka metul wan oros pas tu utna na inangon tan taio ra ka metul kuli, awu. Una kum mirum ma a waspi, metul papam dekdek nama lamametul sur u warut metul una numetul a kinkinis, sur gong metul pitar a maut torom tu pasamot sur in kul metul. ");
INSERT INTO kqw_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","I tokodos sur metul in saring mot sur mot in warut metul, ikut ka metul nemi. Metul pam a pinapam sur metul in ese a ngasino ra i wakak sur mot in muri. ");
INSERT INTO kqw_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Ra metul kis nisamot, metul pitar a warkurai ri torom mot: Ra taio ke nemi sur in papam, gong kai i wangon. ");
INSERT INTO kqw_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Metul longoro i lena, a ramano taro tagun mot, a kum tubunu wok na taro. Ka det papam, det balon kut una uruk lorindet una utna ra ausur anundeti. ");
INSERT INTO kqw_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Una risan a Labino o Iesu Karisito metul turbat a ngas na taro ra, ma metul saring det, sur det in kis wowowon ma det in papam sur andet lako utna na inangon ra det in laun nami. ");
INSERT INTO kqw_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Ma torom mot, a kum tistisimetul, gong mot pino ngoro nama pam a kum tokodos na petutna. ");
INSERT INTO kqw_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ra taio ke mur anumetul a wasiso una pas ri, mot in nuk ukai i. Gong mot lason tomo nami, sur in maimai una magirano. ");
INSERT INTO kqw_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ikut gong mot tama i elar nam anumot a ebar, mot in utumarong pasi kut elar nam a tisimot. ");
INSERT INTO kqw_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Metul wararing sur a Labino ra i pitar a malmal, i ut in tabor mot nama malmal una kum du bung rop ma una kum ngas na kinkinis na nilaun rop. A Labino in kis tomo nam mot rop. ");
INSERT INTO kqw_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Anung a wasiso na marmaris ri, iau ut o Pol, a tumusi torom mot, nama lamang. Iri i, a ukinalong ina nung a kum pas rop. A ser tumtumus ut lenri. ");
INSERT INTO kqw_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","A marmaris anun anundat a Labino o Iesu Karisito in kis tomo nam mot rop. ");
INSERT INTO kqw_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Iau o Pol, a aposel anun a Karisito Iesu, una itula anun o God, anundat a Tene Ulaun, ma a Karisito Iesu, o naro ra dat kis langlang suri nama nurnur. ");
INSERT INTO kqw_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","A tumus a pas ri torom ui Timoti, a nutunglik mulus una nurnur. A marmaris ma a wakak na petutna ma a balano molmol, tan o God a Tamandat ma a Karisito Iesu anundat a Labino in kis torom ui. ");
INSERT INTO kqw_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Uniri a udekdek ui melet sur un kis ut tiro iai o Epesus, elar nami ra a sa watung tari tam ra a wan utong o Masedonia. Un kis sur un turbat det ra det ususer a taro un lako kum torotoro na etowo. ");
INSERT INTO kqw_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Ma gong det balon una kum etowo ororos kut, nama saksakutna na kabotaro, ra katu tintinipino. I ulabo i kut a wasiso na engaras, ma ke warut a pinapam anun o God. A pinapam anun o God i lubung kut una nurnur. ");
INSERT INTO kqw_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","A watungi lenra, sur a marmaris in lubung epotor tandat etetalai. A marmaris ra i wan tagun a tokodos na balandat, ma a wakak na nuknukindat ma a lingmulus na nurnur. ");
INSERT INTO kqw_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","A ramano taro det sa wan gisen gusun a kum wakak na petutna ri, ma det mur a kum wasiso ororos mukut. ");
INSERT INTO kqw_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Det nemi sur det in ususer a taro una kum Warkurai anun o God, ra det nuki lena det tasman wakaki, ikut ka det tasman mulus asau ra det wasiso uni. ");
INSERT INTO kqw_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Dat tasmani lena a kum Warkurai det wakak, ra din papam wakak nami. ");
INSERT INTO kqw_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Dat tasmani lena a kum Warkurai ausur di pitari sur a kum tene tokodos, awu. Di pitari kut sur a ngas na taro lenri: det ra det lakai a kum warkurai, a kum tene rosumur, det ra ka det lotu torom o God, a kum tene sakino, det ra ka det mur a nemnem anun o God, det ra ka det ser ru o God, det ra det um doko a taro, det ra det um doko a kum tamtamandet o a kum nanandet, ");
INSERT INTO kqw_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","det ra det pam a kum petutna na pamuk, a kum musano ra det nolin melet kut nama kum musano, det ra det pam sikot pas a taro sur det in siuru det, a kum tene torotoro, det ra det liliman torotoro, ma det rop ra det pam a kum utna ra ke elar nama tokodos na etowo anun o God. ");
INSERT INTO kqw_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","A tokodos na etowo i kis una Wakak na Wasiso, ra o God i pitar tari tang sur an wasiso talapor nami. A Wakak na Wasiso ri i wan tagisapat tan o God, a God na minamar ra i dan tukum. ");
INSERT INTO kqw_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","A watung wakak torom a Karisito Iesu anundat a Labino, ra i pitar tar a dekdek tang. A watung wakak toromi uni i nurnur un iau, ma i ubek tar iau sur an papam toromi. ");
INSERT INTO kqw_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Numugu a ser watung laulau o Iesu, a banlaulau a taro na nurnur ma a ukadik det. Ikut o God i maris iau, uni ka tasman asau ra a pami, ma ka nurnur utmakai. ");
INSERT INTO kqw_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Anundat a Labino i ese anun a labino marmaris torom iau, ra i pitar tar a nurnur ma a wakak na petutna torom iau. A etabor ri, i kibino una Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","I wan pirso urin una rakrakon bual sur in ulaun a kum tene sakino. A wasiso ri i lingmulus sakit, ma dat in nurnur uni. Ma iau, a laulau sakit tan a kum tene sakino rop. ");
INSERT INTO kqw_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Ikut o God i maris iau, sur a Karisito Iesu in ese anun a wowowon na petutna torom iau, ra a laulau sakit tan a kum tene sakino rop. I ulaun iau ma i dumano ru anung a kum sakino petutna. Lenra, a wanpat a wakak na larlar, sur a taro det in tama asau ra o Iesu i pami un iau, ma det in nurnur un o Iesu, ma det in rakon a nilaun tukum. ");
INSERT INTO kqw_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Dat in pitar a wariru ma a wasiso na ululabo torom a King ra i laun tukum, ma ken mat, i ra ka dat tama i, ra i sot kut a God. A wasiso na ululabo toromi ken rop ma ken rop. Amen. ");
INSERT INTO kqw_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timoti a nutunglik, a kum etowo ri ra a pitari tam, i elar nama wasiso na poropet ra di sa watung tari un ui ra det wararing un ui. Ra un mur a kum etowo ri, ui ara wakak na tene inaim nama Wakak na Wasiso. ");
INSERT INTO kqw_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Un tur dekdek una num a nurnur, ma un mur a wakak na nuknuk. A ramano taro ka det pami lenri, ra anundet a nurnur i puku elar nama sip ra a top i rapus rege ru i. ");
INSERT INTO kqw_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","O Emineus ma o Aleksanda aru tagun det, ma a sa pitar tar der una laman o Satan, sur der in tasmani lena gong melet mo der watung laulau o God. ");
INSERT INTO kqw_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","A mugano utna, a nemi lena a taro na nurnur det in wararing, nama niaring sur a utna det sibo suri, a niaring una taro, ma a niaring na watung wakak torom o God. Mot in wararing lenra una taro rop, ");
INSERT INTO kqw_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ma una kum king ma a kum mugumugu rop, sur dat in kis wowowon nama malmal, ma dat in mur a petutna ra o God i nemi ma dat in urur torom o God. ");
INSERT INTO kqw_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Ra mot in pami lenri, in wakak sakit ra o God, anundat a Tene Ulaun, in gas nami. ");
INSERT INTO kqw_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","I nemi sur in ulaun a taro rop, ma det in tasman a lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Uni ara God sot kut, ma ara sot kut kai ra i dat tomo o God ma a taro, a musano ri a Karisito Iesu, ");
INSERT INTO kqw_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","i ra i pitar tar anun a nilaun sur in kul ulangolango pas a taro rop. Una du bung ra o God i sa kubus tari, o Iesu i ulingmulus a nemnem anun o God lena i nem na ulaun a taro rop. ");
INSERT INTO kqw_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Iri a kibino ra o God i pilok pas iau sur an aposel ma an warawai nama Wakak na Wasiso, ma an ususer a taro ra ausur a taro Juda nama nurnur mulus. A watung a lingmulus, ausur a torotoro. ");
INSERT INTO kqw_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","A nemi sur a kum musano una kum tamon det in wararing ma det in tulsu a kum lamandet usapat netes, det in pitar tar det torom o God, ma gong det kankan ma gong det engaras. ");
INSERT INTO kqw_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","A nemi kai sur a wardain det in emar nama malu ra i sot nama ememar anun a wardain. Det in emar nama ememar i upuaso a urur ma a wakak na ninunuk. Gong det iris a lorindet, gong det emar nama kum ngatngat na kamkabaran ra di pami nama gol o a kum ngatngat na wat, ma gong kai det emar nama kum malu na ememar ra a matandet i ka. ");
INSERT INTO kqw_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","A wardain ra det watungi lena det lotu torom o God, det in emar nama kum wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Ra a wardain det in los a etowo tagun a Buk Tabu, i wakak sur det in kis wowowon ma det in unatino pas det. ");
INSERT INTO kqw_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Ka madek tar tu ino sur in ususer tu musano, ma ka madek tari kai sur tu ino in mugu tu musano. I wakak sur in kis wowowon kut. ");
INSERT INTO kqw_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Uni o God i ukis mugu o Adam ra numur o Iwa. ");
INSERT INTO kqw_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Ausur o Adam ra o Satan i lari. Awu! O Iwa kut ra o Satan i lari ra i puku, ra i pam a sakino. ");
INSERT INTO kqw_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Din ulaun a wardain kibino una usus. Din ulaun det ra det ser tur dekdek una nurnur, ma una marmaris. Det ra det ser mur a petutna ra o God i nemi, ma a petutna ra i sot sur a wardain det in muri. ");
INSERT INTO kqw_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","A wasiso ri i lingmulus sakit, lenri: Ra taio i nemi sur in mugumugu na lotu, i nem a wakak na pinapam sakit. ");
INSERT INTO kqw_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","A magiran a mugumugu na lotu in lenri: gong tu etakun i kis uni, in nolin kut nam ara ino, in tumarong a magirano, in warkurai bat anun a nilaun, i a ngas na musano ra a taro det urur uni, in ser gas pas a taro una nun a rumu, ma i a wakak na tene ususer. ");
INSERT INTO kqw_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Ma gong i tene ininum, gong i tene inaim, in tene malmal, ma gong i tene wasiso na kankan, ma gong i nem doko a mani. ");
INSERT INTO kqw_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","I wakak sur in mugu wakak det tamtamano, ma in ususer a kum nutnutunu sur det in tarom toromi nama urur. ");
INSERT INTO kqw_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","A musano ra ke lason sur in mugu wakak det tamtamano, ken pet lar pasi kai sur in tamtamabat a taro na lotu anun o God. ");
INSERT INTO kqw_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Gong taio i mugumugu na lotu ra i nukpukus matok taru kut, sako in umuman labino, ra in puku, ma din warkurai i elar nam o Satan. ");
INSERT INTO kqw_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","I wakak sur a mugumugu i a ngas na musano ra a taro kai ra ka det ser lotlotu, det ser ru i. Ra awu, det in watung suri, ma in iru un in nukun anun o Satan. ");
INSERT INTO kqw_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Lenkutkai ra torom a kum tene warut una lotu, i wakak sur det a kum ngas na musano ra a taro det ser urur un det, det in lingmulus una nundet a wasiso, gong det tene ininum ma gong det nemnem sur a labino mani. ");
INSERT INTO kqw_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Det in utur ukai a nurnur mulus ma a tokodos na ninunuk. ");
INSERT INTO kqw_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Din lar mugu tar det, ra numur, ra kataio in takun det un tu utna, din utur det maragom una pinapam na tene warut una lotu. ");
INSERT INTO kqw_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Torom anundet a wardain kai in lenra, det a kum ngas na wardain ra a taro det ser ru det. Gong det wasiso eno, det in tumarong a magirandet, ma det in lingmulus una kum pinapam rop. ");
INSERT INTO kqw_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","A tene warut una lotu in nolin kut nam ara ino, ma in mugu wakak a kum nutnutunu, ma det rop una nun a rumu. ");
INSERT INTO kqw_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Det ra det papam wakak una pinapam na tene warut una lotu, a risandet in wakak, ma ka det in ngara sur det in wasiso puaso una nundet a nurnur una Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","A nem na wanpat lakit torom ui, ikut a nuki lena in wakak ra an tumtumus mugu torom ui. ");
INSERT INTO kqw_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Ra kan nanpat lakit, u sa tasman a kum ngas na petutna ra a taro anun o God det in pami epotor tandet. A taro na lotu anun o God, a laun ino, det elar nama kum pos ma a kibin a rumu ra det udekdek a lingmulus. ");
INSERT INTO kqw_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","A lingmulus, o God i upuaso mulusi lena, a etowo ra dat nurnur uni i labo sakit. I lenri: A Karisito i wanpat a musano, a Tokodos na Nion i upuaso i lena a Karisito i tokodos umatan o God, a kum ensel det tama i, a wasiso puaso uni i wan sarara torom a kum kamkabo taro rop, ma a susut una rakrakon bual det nurnur uni, i wan usapat ma i kis una minamar. ");
INSERT INTO kqw_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","A Tokodos na Nion i watung puaso i lena, una kum tintinip na bung, lako taro det in nan gisen gusun a lingmulus na nurnur, ma det in mur a kum nion ra det ser torotoro, ma det in mur a kum etowo anun a kum laulau na nion. ");
INSERT INTO kqw_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","A kum etowo ri i wan tagitiro tan a kum tene torotoro, a taro ra ka det tama lele i mo a tokodos na petutna, uni a tokodos na ninunuk una nuknukindet i sa mat. ");
INSERT INTO kqw_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","A ngas na taro ri, det turbat a nolin ma det turbat a taro sur gong det wan lako kum ngas na utna na inangon. A kum utna na inangon ra, o God i ukis tari sur din nani, ra a taro na nurnur ra det tasman a lingmulus ino, det in watung wakak torom o God uni ma det in nani. ");
INSERT INTO kqw_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Uni a kum utna rop ra o God i ukis tar det, det wakak, ra gong dat ngaran ru det. Dat in watung wakak torom o God uni, ra dat in nani. ");
INSERT INTO kqw_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Uni a wasiso anun o God ma a niaring der uwakak a utna na inangon sur in wakak umatan o God. ");
INSERT INTO kqw_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ra un ususer a kum tistisim nama kum etowo ri, ui a wakak na tultul anun a Karisito Iesu. Una pinapam ri in talapor lena u labo pat una nurnur mulus, ma a wakak na etowo ra u muri. ");
INSERT INTO kqw_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Un nan gisen gusun a kum saksak utna ororos, ma a wasiso ra ke warut ui una nilaun torom o God. Un ulason ui sur a magiram in wakak umatan o God. ");
INSERT INTO kqw_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Ra dat ulason a pinindat una wap, i warut a pinindat. Ikut ra dat ulason dat sur a magirandat in wakak umatan o God, i warut dat una kum utna rop. Ausur una nilaun kut ri, i warut kai una nilaun kura numur. ");
INSERT INTO kqw_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","A wasiso ri a watungi, i lingmulus sakit, i wakak sur dat in nurnur uni ma dat in muri. ");
INSERT INTO kqw_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","I mo ri dat papam dekdek, uni dat kis langlang nama nurnur sur o God, i ra a lalaun ino ma a Tene Ulaun anun a taro rop, ra det nurnur uni. ");
INSERT INTO kqw_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Un inanos det ma un ususer det una kum utna ri. ");
INSERT INTO kqw_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Gong u madek tar taio sur in pas tataun tar ui, uni u barman utmakai. Una num a wasiso, anum a petutna, anum a marmaris, anum a nurnur ma anum a tokodos na nilaun, un elar nama wakak na malalar, sur a kum tene nurnur det in pam murmuri. ");
INSERT INTO kqw_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Un dekdek nama luk a Buk Tabu torom a kum tene nurnur, ma nama warawai ma a etowo torom det, tuk an nanpat. ");
INSERT INTO kqw_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Gong u madek ru a etabor na Nion, ra di pitar tari tam, una du bung ra a kum poropet det wasiso na poropet, ma a kum mugumugu det ubek tar a kum lamandet sapat netes un ui. ");
INSERT INTO kqw_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Un ulason ui una kum pinapam ri. Un pitar tar anum a nilaun uni, sur a taro rop det in tama ui lena u lubung una num a nilaun torom o God. ");
INSERT INTO kqw_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Un tumarong anum a nilaun ma anum a etowo. Un tur dekdek un der, uni, ra un pami lenra, un ulaun pas ui ut, ma det kai ra det longoro ui. ");
INSERT INTO kqw_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ra un ukodos tu musano ra a mugano tam, gong u wasiso na kankan, un wasiso wowon kut elar nam i ra u pami torom o tamam. Un pam a wakak na petutna torom a kum barman elar nam i ra u pami torom a kum tistisim. ");
INSERT INTO kqw_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Un papam torom a kum ino ra a kum mugano tam, elar nam i ra u pami torom o nam, ma un papam torom a kum toraro, nama tokodos na petutna, elar nami ra u pami torom a kum tistisim a kum ino. ");
INSERT INTO kqw_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Un warut a kum ula ra kataio i tamtamabat det ma det sibo. ");
INSERT INTO kqw_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Ikut, ra tu ula a kum nutnutunu o a kum tumtubunu kura, i wakak ra det in upuaso mugu anundet a nurnur nama warut torom a kum kukundet, sur det in balu a marmaris anun a tamandet ma a nandet ma a kum tumtubundet. Ra det in pami lenra, o God in gas. ");
INSERT INTO kqw_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","A ula, ra kataio i tamtamabati ma i sibo mulus, i nurnur kut un o God ma i kis langlang sur in waruti. Una kum mirum ma a waspi, i ser wararing sur o God in waruti. ");
INSERT INTO kqw_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Ikut, a ula, ra i nemi lena in gasgas oros kut, i laun, ikut a niono i sa mat. ");
INSERT INTO kqw_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Un ususer a taro nama kum etowo ri, sur gong tu etakun i los det. ");
INSERT INTO kqw_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ra taio ke warut a kum kukunu, ma det kai ra tagun anun a rumu, i sa wan gisen gusun a nurnur. I ra i laulau sakit tan a taro ra ka det nurnur. ");
INSERT INTO kqw_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Un tumus ukai kut a risan a kum ula ra a wonom na noino kilalo anundet, ma usapat, sur a taro na lotu det in warut det. Det in warut a ngas na ino ra i nolin pas kut nam ara musano, ");
INSERT INTO kqw_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ra a taro rop det tasman anun a kum wakak na pinapam lenri: i ugu wakak a kum nat, i ser gas pas a taro una nun a rumu, i ser gis ru a kubus gusun a kikin a taro anun o God, i ser warut a taro ra a kum mamaut i los det, ma i pitar tar anun a nilaun sur a kum wakak na pinapam rop. ");
INSERT INTO kqw_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Ikut a kum ula ra ke wonom na noino kilalo utmakai, gong u tumus ukai a kum risandet. Uni, ra anundet a nemnem na nolin in katutur melet, det in nan gisen gusun o Karisito. ");
INSERT INTO kqw_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Ra a warkurai anun o God in los det, uni det sa kutus anundet a mugano liliman torom o Karisito. ");
INSERT INTO kqw_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Det in ukio anundet a kum du bung nama inawan tuptupukus una kum rumu. Ma det in wasiso eno, det in wasiso una utna ra ausur anundet, ma det in watung a kum wasiso ra ke wakak sur det in watungi. ");
INSERT INTO kqw_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","A nemi lena, a kum ula, ra det dekdek utmakai, det in nolin melet, det in usus melet, ma det in tamtamabat anundet a kum rumu, sur gong det pam tu utna ra anundat a kum ebar det in watung laulau dat uni. ");
INSERT INTO kqw_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","A ramano kum ula, det sa wan gisen ma det mur mukut o Satan. ");
INSERT INTO kqw_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Ra tu ino a tene nurnur, ma tu ula kura una nuna kabotaro, i wakak sur in tamtamabati, sur gong a taro na lotu det balon uni. A taro na lotu det in balon kut una kum ula ra kataio sur in tamtamabat det ma det sibo mulus. ");
INSERT INTO kqw_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","I wakak sur din pitar a urur ma a wakak na ikul torom a kum mugumugu na lotu ra det pam wakak a pinapam. Din pami lenra torom det ra det papam dekdek una warawai ma a etowo. ");
INSERT INTO kqw_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Uni a Buk Tabu i watungi lena, “Gong u ker bat a wan a karabau ra i pas rumrum a wit, i kai in nangon ut.” Ma i watungi kai lena, “I wakak sur a tene pinapam in los ut anun a ikul.” ");
INSERT INTO kqw_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Gong u longoro tu etakun un tu mugumugu ra ara kut i takuni. Ra lako ru o lako tul detul in takuni, un longoro a etakun ra. ");
INSERT INTO kqw_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Ra tu mugumugu in pam a sakino petutna, un ukodosi umatana taro na lotu rop, sur in utumarong lako taro kai tagun det. ");
INSERT INTO kqw_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","A wasiso dekdek torom ui umatan o God ma a Karisito Iesu ma a kum ensel ra o God i pilok pas det, sur un mur a kum itula ri, ma un pam a takano petutna kut torom a taro rop, ma gong u tur takano papor. ");
INSERT INTO kqw_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Gong u ubek lakit aru lamam netes un taio ma u wasiso udani sur a pinapam anun a Labino. Ma gong u mur a taro una sakino petutna. Un tumarong anum a nilaun sur in tokodos. ");
INSERT INTO kqw_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Gong u inum a danim kut, un inumi kai lakalik wain sur in warut ui una misait ra kura un in balam, uni u misait liklik nami. ");
INSERT INTO kqw_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","A sakino petutna anun a ramano taro din tama lele i, ra ka det in nanpat utmakai una kinkinis na warkurai. Ikut a sakino petutna anun ara taro kai kataio in tama lele lakiti, numur ut in nanpat talapor. ");
INSERT INTO kqw_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Lenkutkai ra, una kum wakak na pinapam. A kum wakak na pinapam anun a ramano taro i sa wanpat talapor. Ikut, anun ara taro kai, ka din tama lele i uniri, numur ut in nanpat talapor. ");
INSERT INTO kqw_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Det ra a kum tene ititula, det in urur torom anundet a kum mugumugu, sur gong taio i watung laulau a risan o God ma anundat a etowo. ");
INSERT INTO kqw_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Ma det ra anundet a mugumugu a tene nurnur, gong det rosumur toromi, uni det tasmani lena det tar tistisino una nurnur. Det in ser tarom wakak toromi, uni anundet a pinapam in warut a tene nurnur, ra det ser nemi. Timoti, un ususer det ma un udekdek det nama kum etowo ri. ");
INSERT INTO kqw_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Ra taio in ususer a taro nam tu etowo gisen, ra ke elar nama etowo mulus anun anundat a Labino o Iesu Karisito, ma ke elar nama kum etowo ra i warut det, sur a magirandet in wakak umatan o God, ");
INSERT INTO kqw_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","a ngas na musano ra, i ulabo pasi ut, ma ke tasman tu utna. Anun a laulau na nemnem sur a wasiso na engaras, ma a inaim na wasiso, i elar nama misait toromi. Anun a petutna ra, i pam pat a kum ngasino lenri: a sakino nuknuk eno sur a utna anun taio, a engaras, a emang, a nuknuk laulau torom a taro. ");
INSERT INTO kqw_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","A ngas na taro ri, det ser pam pat a purpuruon, a nuknukindet ke tokodos, ma det rosumur gusun a lingmulus ino. Det nuki lena anundet a kinkinis una lotu in pam pat a mani sur det in tene ululeng. ");
INSERT INTO kqw_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Ikut ra dat mur a petutna anun o God, tomo nama gasgas una sau ra o God i etabor nami, i ra a ululeng mulus. ");
INSERT INTO kqw_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Ra dat wanpat nin una rakrakon bual ka dat los tu utna, ma ra dat in milet, ka dat in los tu utna kai taginin. ");
INSERT INTO kqw_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Ra andat a utna na inangon ma anundat a malu kai kuri i kis, asau ra dat in nuknuk melet suri? A nuknukindat in mana. ");
INSERT INTO kqw_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Ma det ra det nem a labino mani, det in puku una ululam, ma det in iru un in nukun, ma a kum nemnem ororos kut, ma a nemnem sur a utna ra, in banlaulau det. Ra in woro pirso a susut na taro una minat ma a iniru tukum. ");
INSERT INTO kqw_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Uni a nemnem sur a mani, i a kimkibina wur matano sakino petutna. Ma a ramano taro ra det ngara suri, det sa wan gisen gusun a nurnur, ma det banlaulau anundet a nilaun nama susut na mamaut. ");
INSERT INTO kqw_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Ikut ui, Timoti, ui a musano anun o God, un nan gisen gusun a kum utna ri. Un dekdek sur un mur a tokodos na petutna, ma a petutna ra i wakak umatan o God, a nurnur mulus, a marmaris, a tuntunur dekdek, ma a wowowon na petutna. ");
INSERT INTO kqw_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Un tur dekdek una nurnur elar nama wakak na tene inaim. Ma un pam ukai a nilaun tukum. A nilaun ra o God i kabo pas ui suri, ra u wasiso talapor uni umatan a susut na taro. ");
INSERT INTO kqw_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","A inanos ui umatan o God, i ra i pitar a nilaun torom a kum utna rop, ma umatan a Karisito Iesu i ra i wasiso talapor un i ut umatan o Pontias Pailat. A inanos ui lenri: ");
INSERT INTO kqw_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Un tarom mulus una kum itula, ma gong u pam tu utna ra taio in takun ui uni, tuk una bung ra anundat a Labino o Iesu Karisito in nanpat melet. ");
INSERT INTO kqw_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Ra a bung in sot, o God ut in tulu ru i sur in nanpat melet. O God ara sot kut, a labino Tene Warkurai ma i dan tukum, a King anun a kum king, ma a Labino anun a kum lamlabino. ");
INSERT INTO kqw_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","I sot kut i laun tukum, ra i kis una labino talapor ra kataio in nan milau nisano. Kataio utmakai i tama tari ma ka din tama lar pasi. Din pitar tar a labino urur toromi, ma i utur ukai a labino dekdek ra ken rop ma ken rop. Amen. ");
INSERT INTO kqw_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Un utumarong det ra det ululeng nin una rakrakon bual sur gong det ulabo pas det ut, ma gong det nurnur una mani ra i ser rop kut. Det in nurnur kut un o God, ra i ser tabor dat nama kum wakak na utna rop sur dat in gas nami. ");
INSERT INTO kqw_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Un inanos det sur det in pam a wakakino, ma det in bukus nama kum wakak na pinapam, det in etetabor, ma det in ser isuaro a utna kai torom lako taro. ");
INSERT INTO kqw_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Ra det in pami lenri, det in utur ukai a ululeng mulus. I ra a wakak na kibina nundet a nilaun numur, sur det in los a nilaun ra a nilaun mulus. ");
INSERT INTO kqw_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timoti, un tamtamabat wakak a pinapam ra o God i pitar tari tam. Un nan gisen gusun a kum wasiso ororos kut, ra ke elar nama nemnem anun o God, ma gusun a wasiso na engaras una utna di watungi nama “mananos”, ikut ausur a mananos mulus. ");
INSERT INTO kqw_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","A ramano taro det watungi lena det tasmani ut a mananos ra, ra det sa wan gisen pas gusun a nurnur un o Iesu. A marmaris anun o God torom mot. ");
INSERT INTO kqw_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Iau o Pol, a aposel anun a Karisito Iesu una nemnem anun o God, sur an wasiso talapor una nilaun ra i sa uliliman tari torom dat una Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","A tumus a pas ri torom ui Timoti, a wakak na nutunglik una nurnur. A marmaris ma a wakak na petutna ma a malmal, anun o God a Tamandat ma a Karisito Iesu anundat a Labino, in kis torom ui. ");
INSERT INTO kqw_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Una kum mirum ma a waspi, a ser wararing un ui, ma a ser watung wakak torom o God. I ra a papam toromi nama tokodos na ninunuk, elar nama kum tumtubung tagun numugu. ");
INSERT INTO kqw_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","A nuk melet pasi ra u tangis iau, ma a nem doko i lena an tama ui sur an bukus nama gasgas. ");
INSERT INTO kqw_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","A nuk pas anum a lingmulus na nurnur, ra i elar nama nurnur anun aru ino ri, o tubum o Lois ma o nam o Unis. A tasmani lena a ngas na nurnur ra, kura kai un ui. ");
INSERT INTO kqw_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","I mo ra a inanos ui melet sur un ukatutur melet anum a etabor, elar nama sungun ra di wupi ra i kunabor. A etabor ra, o God i tabor ui nami una bung ra a ubek aru lamang netes un ui. ");
INSERT INTO kqw_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Uni o God ke tabor dat nama nion na nginara, awu. I tabor dat nama Tokodos na Nion ra i pitar a dekdek torom dat, ma a marmaris ma a petutna ra ara taktakai in warkurai wakak anun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Gong u maimai sur un wasiso talapor una nundat a Labino, ma gong u maimai un iau, ra uniri a kis una karabus una risano. Ikut, un waninar sur ui kai, un taramo a ngunungut una Wakak na Wasiso tomo nam iau. Ra un taramo a ngunungut, o God ut in pitar a dekdek torom ui. ");
INSERT INTO kqw_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","I ut i sa ulaun pas dat, ma i kabo pas dat sur a tokodos na nilaun. Ausur i kibino una nundat a kum wakak na pinapam, awu. I kibino ut una nun a nemnem, ma anun a marmaris, ra i pitar tari torom dat una Karisito Iesu. Unarap utmakai ra ke ukis utmakai a rakrakon bual i maris mugu dat. ");
INSERT INTO kqw_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Ra uniri, dat sa tama a marmaris anun o God torom dat, una inawan pat anun anundat a Tene Ulaun a Karisito Iesu, i ra i urop ru a minat. Ma una Wakak na Wasiso, i upuaso a nilaun tukum sur in nanpat taltalapor. ");
INSERT INTO kqw_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","O God i sa pilok pas iau sur an tene warawai nama Wakak na Wasiso, an aposel ma an tene ususer kai uni. ");
INSERT INTO kqw_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Iri i a kibino ra a taramo a ngunungut lenri. Ikut, ka maimai, uni a tasman o naro ra a nurnur uni, ma a tasman mulusi lena, in pet lar pasi sur in tamtamabat a pinapam, ra i sa pitar tari tang, tuk una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","A tokodos na etowo ra a sa ususer tar ui nami, i elar nama wakak na malalar sur un muri. Un muri tomo nama nurnur ma a marmaris. A nurnur ma a marmaris anundat, ra kura dat una Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Una dekdek ina Tokodos na Nion ra i kis un dat, un tamtamabat wakak a Wakak na Wasiso ra o God i sa pitar tari tam. ");
INSERT INTO kqw_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","U tasmani lena a taro rop, ra det kis una papor Asia, det sa wan pas gusun iau. O Pigelus ma o Emogenes aru tagun det. ");
INSERT INTO kqw_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","A wararing sur o God in maris o Onesiporus det tamtamano, uni i ser ugasgas iau, ma ke maimai un iau ra a kis una karabus. ");
INSERT INTO kqw_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Ra i wanpat tong o Rom i sisio nanan ut sur iau, tuk i sio pas iau. ");
INSERT INTO kqw_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","A wararing sur a Labino in maris o Onesiporus una bung na warkurai. U sa tasman wakak a kum pinapam na warut ra i sa pam tari torom iau tiro o Epesus. ");
INSERT INTO kqw_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Timoti, a nutunglik una nurnur, un tur dekdek una marmaris anun o God torom dat, ra kura dat una Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","A kum etowo ra u sa longoro pasi gusun iau umatan a susut na taro, un ususer lako taro nami. A taro ra u nurnur un det lena det in pet lar pasi sur det in ususer lako taro kai nami. ");
INSERT INTO kqw_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Un tur tomo nam met una kum mamaut, elar nama wakak na tene inaim anun a Karisito Iesu. ");
INSERT INTO kqw_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","A wakak na tene inaim ken balon una kum pinapam anun a taro oros kut, awu. In pam ut anun a pinapam sur in ugasgas anun a mugumugu. ");
INSERT INTO kqw_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Lenkutkai ra, a tene kinalabor ra i kalabor una ililu, ken los tu ikul ra ke mur a kum warkurai ina ililu. ");
INSERT INTO kqw_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","A tene minarut ra i papam dekdek, i ut in pasong mugu a wina ana kinobot ra in taka. ");
INSERT INTO kqw_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Un ser nuk pas a kum wasiso ri a tumusi torom ui, uni a Labino ut in utalapor a kukuraino torom ui. ");
INSERT INTO kqw_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Un nuk pas o Iesu Karisito, i ra tagun a kabotaro anun o Dewid, ra i katutur melet gusun a minat. Iri a Wakak na Wasiso ra a warawai nami. ");
INSERT INTO kqw_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","A taramo a ngunungut, ma di ker iau elar nama tene sakino, uni a warawai nama Wakak na Wasiso. Ikut, a wasiso anun o God ka din turbat lar pasi. ");
INSERT INTO kqw_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Kuri a taramo a kum ngunungut, ikut a tur dekdek ut, sur det ra o God i sa pilok pas det, det kai det in los a ululaun ra i kis una Karisito Iesu, tomo nama minamar tukum. ");
INSERT INTO kqw_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","A wasiso ri an watungi tam, i lingmulus sakit: Ra dat in mat tomo nama Karisito Iesu, dat in laun tomo kai nami. ");
INSERT INTO kqw_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Ra dat in taramo a ngunungut tomo nami, dat in warkurai tomo utkai nami una nun a matanitu. Ra dat in ipul ru i, i kai in ipul ru dat kut. ");
INSERT INTO kqw_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Ra ka dat in pam sot pas anundat a liliman sur dat in mur a Karisito Iesu, i ut in tur dekdek una nun a liliman, uni ken pet lari sur in kutus anun a liliman. ");
INSERT INTO kqw_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Gong u mana nama wasiso torom anum a taro nama kum etowo ri. Un utumarong det umatan o God lena, gong det engaras una kum wasiso, uni ke gas un tu utna, ma in banlaulau det ra det longoro i. ");
INSERT INTO kqw_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Un pitar tar ui ut torom o God ma un dekdek sur ui a lingmulus na tene pinapam, ra o God in gas nami. A tena pinapam ra ke ser maimai una nun a pinapam, ma i palos kodos a lingmulus na wasiso. ");
INSERT INTO kqw_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Un nan gisen gusun a kum wasiso ra ke sot nama nemnem anun o God, uni a taro ra det balon nama ngas na wasiso lenra, det in nan bakbak ma det in bakbak doko gusun o God. ");
INSERT INTO kqw_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Anundet a etowo in nan sarara elar nama laulau na inangon ra i tangangos nanan. O Emeneus ma o Piletus aru tagun det, ");
INSERT INTO kqw_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","ra der sa wan raro gusun a lingmulus. Der watungi lena, dat sa katutur melet gusun a minat. A wasiso ri anunder, i banlaulau a nurnur anun a ramano taro. ");
INSERT INTO kqw_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Ikut, o God i sa ubek tar a kibina nurnur ra ken tugunu, ma di sa tumus tar a wasiso uni lena, “A Labino i tasman det ra anunu.” Ma di sa tumus tari kai lena, “I ra i watungi lena i anun a Labino, in nan gisen gusun a sakino petutna.” ");
INSERT INTO kqw_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Un ara labino rumu, a kum ngas na dis kura det kis. A ramano di pam det nama silwa ma nama gol, ma a ramano kai di pam det nama duwai ma nama piopap. A ramano kum dis sur a kum lamlabino bung kut ma a ramano kai sur a kum durdur na utna kut. ");
INSERT INTO kqw_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Ra taio in utalapor pas anun a nilaun gusun a kum durdur na petutna, in elar nama dis tagun a kum lamlabino bung. Uni, i, anun a Labino, ra a Labino in papam una nun a nilaun sur in pam a pinapam anuna Labino, ma i sa kis waninar sur in pam a kum wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Un nan gisen gusun a kum nuknuk na barman, ma un mur a tokodos na petutna, ma a nurnur, ma a marmaris ma a malmal, tomo nam det ra det ser wararing torom a Labino nama tokodos na nuknukindet. ");
INSERT INTO kqw_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Un nan gisen gusun a kum wasiso ororos ra katu kukuraino, uni det in ukatutur a kum wasiso na engaras. ");
INSERT INTO kqw_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","A tultul anun a Labino gong i ser engaras, ikut in wakak na tene ususer, in pam a wakakino torom a taro rop, ma in ese anun a wowowon na petutna torom a taro ra i ukodos det. ");
INSERT INTO kqw_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Det ra ka det nem anun a etowo, in ukodos wowowon det, sako o God in mulaot pas det sur det in nukpukus, ma det in tasman a lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Numur det in nuknuk wakak, ra det in pirso gusun in nukun anun o Satan, ra det sa iru taru uni, ma det ser muri. ");
INSERT INTO kqw_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Un nuk ukai a kum wasiso ri: Una kum tintinip na bung, a kum dekdek na mamaut in nanpat. ");
INSERT INTO kqw_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","A taro det in nuk pas det ut, ma det in nemnem sur a mani, ma det in umuman labino, ma det in watung ulabo pas det ut, ma det in emang, ma det in pitarngat torom a kum tamtamandet ma a kum nanandet, ma ka det in lason sur det in watung wakak torom o God ma torom a taro kai, ma ka det in mur a nemnem anun o God. ");
INSERT INTO kqw_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Ma ka det in marmaris, ma ka det in nuk dumano a sakino anun ara, ma det in banlaulau a risan ara, ma ka det in warkurai wakak anundet a nilaun, ma det in waim ma det in banlaulau a taro, ma ka det in nem a wakakino. ");
INSERT INTO kqw_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Det in usobor a kum paspasandet, det in pam a kum tuptup na petutna, det in ulabo pas det ut, det in nem doko a gasgas tagun a rakrakon bual, ma ka det in nem o God. ");
INSERT INTO kqw_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Det in mur a petutna anun o God una pinindet kut, ikut ka det in nem a dekdekino. Un nan gisen gusun a ngas na taro ra. ");
INSERT INTO kqw_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","A kum ngas na musano lenra, det in ruk oros kut una kum rumu, ma det in ungongos oros pas a wardain sur det in mur det. A wardain ra, katu wakak na nuknukindet, ra det pot na marmaris una nundet a kum sakino petutna, ma anundet a kum sakino nemnem i ben raro det. ");
INSERT INTO kqw_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","A wardain ri det ser los a etowo a bungbung rop, ikut ka det tasman lar pas a lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","A kum ngas na musano lenra, det turbat a lingmulus na etowo, elar nam o Janes ma o Jambres der turbat o Moses. A nuknukindet i laulau doko ma anundet a nurnur ausur i lingmulus. ");
INSERT INTO kqw_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Ikut anundet a pinapam ken lubung, uni anundet a tuptup na petutna in talapor umatan a taro rop, elar nami ra a taro numugu, det tama lele pas a tuptup na petutna anun o Janes ma o Jambres. ");
INSERT INTO kqw_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Ui Timoti, u sa tasman rop anung a kum etowo, a magirang, a kum utna ra a ngara suri, anung a nurnur, anung a kinkinis wowowon, anung a marmaris, anung a tuntunur dekdek una kum ngunungut, ");
INSERT INTO kqw_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","anung a kum mamaut, ma a kum ngunungut a taramo i. U tasman rop a kum lamlabino ngunungut ra a taramo i tong una tulu tamon ri: o Antiok, Aikoniam ma o Listra. Ikut a Labino ut i ulaun pas iau gusun a kum utna ri. ");
INSERT INTO kqw_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Ma i lingmulus, det rop ra det laun una Karisito Iesu ma det nem na mur a nilaun elar nama nemnem anun o God, a taro det in banlaulau det ut. ");
INSERT INTO kqw_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","A sakino taro ma a kum tene torotoro det in laulau, ma det in laulau sakit. Det in toro a taro, ma det in toro pas det utkai. ");
INSERT INTO kqw_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Ikut ui, Timoti, un tur dekdek una etowo ra di sa ususer tar ui uni, ma u sa nurnur dekdek uni, uni u tasman wakak anum a kum tene ususer, ");
INSERT INTO kqw_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","ma u tasman a Buk Tabu turpasi ra u natlik utmakai. A Buk Tabu i utalapor a nuknukim, sur un nurnur una Karisito Iesu, ra o God in ulaun pas ui. ");
INSERT INTO kqw_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","A kum du wasiso rop una Buk Tabu i kimkibino ut tan o God, ma i wakak sur in towo a taro, ma sur in upuaso a sakino anun taio toromi ut, ma in ukodos a kum niraro, ma in ususer a taro una tokodos na petutna. ");
INSERT INTO kqw_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","A Buk Tabu i waninar a taro anun o God sur det in pam a kum ngas na wakak na pinapam rop. ");
INSERT INTO kqw_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","A Karisito Iesu in nanpat urin nama nun a matanitu, ra in warkurai elar nama king. In warkurai det ra det laun, ma det ra det sa mat. Lenra, a saring ui umatan o God ma a Karisito Iesu lena: ");
INSERT INTO kqw_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Un warawai nama Wakak na Wasiso. Un dekdek uni, una kum bung ra a taro det nem na longoro ui, ma a kum bung ra ka det nemi. Un ukodos wakak a taro, un upuaso anundet a kum niraro torom det ma un udekdek det. Un pam a kum utna ri nama wowowon na petutna torom det ma un ususer wakak det. ");
INSERT INTO kqw_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Uni, a bung in nanpat, ra a taro ka det in nem mo a tokodos na etowo. Ma una nundet a kum nemnem, det in ben tomo a susut na tene ususer torom det, sur det in ususer det una sau ra det nem na longoro i. ");
INSERT INTO kqw_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Ka det in longoro a lingmulus ino mo, det in longoro mukut a kum wasiso ororos kut. ");
INSERT INTO kqw_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Un nuknuk wakak una kum bungbung rop. Ra un taramo a kum mamaut, un tur dekdek ut. Un dekdek nama warawai una Wakak na Wasiso, ma un pam sot pas anum a kum pinapam rop, ra o God i sa pitar tari tam. ");
INSERT INTO kqw_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Uni i sa milau mo sur an mat ma a gaping in tilingis. In elar nama wain ra di lingisi una utna ra di tuni sur a etabor torom o God. ");
INSERT INTO kqw_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","A sa pam sot pas anung a wakak na inaim ma anung a kinalabor una ililu, ma a sa mur sot pas a lingmulus na nurnur. ");
INSERT INTO kqw_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","O God i sa ubek tar anung a kunukul, uni anung a nilaun i tokodos umatano. A Labino, a tokodos na Tene Warkurai in pitari tang una bung na warkurai. Ma ausur torom iau kut, in pitari kai torom det rop ra det kis langlang nama labino nemnem sur anun a inawan pat melet. ");
INSERT INTO kqw_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Un dekdek sur un nan lakit urin torom iau, ");
INSERT INTO kqw_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","uni o Demas i sa wan pas gusun iau, uni i nem a kum utna tagun a rakrakon bual, ra i sa wan utong o Tesalonaika. O Kresens i wan utong una papor Galesia ma o Taitus i wan utong una papor Dalmatia. ");
INSERT INTO kqw_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","O Luk mukut kuri nisang. Un ben pas o Mak ra mur in nan urin, uni in warut iau una nung a pinapam. ");
INSERT INTO kqw_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","A sa tulu ru o Tikikus utiro o Epesus. ");
INSERT INTO kqw_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Ra un nan urin, un los anung a saket, kura a wan gusun tari nisan o Karpus tong o Troas. Un losi utkai anung a kum buk, ma gong u dumano a ramano ra di pami nama pinin a wewegua. ");
INSERT INTO kqw_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","O Aleksanda, a tene pam ututna nama aen, i pam a susut na sakino petutna torom iau. A Labino ut in balu i toromi. ");
INSERT INTO kqw_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Un tumarong ui gusuni, uni i turbat dekdek anundat a etowo. ");
INSERT INTO kqw_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","A mugano du bung ra a tur una warkurai ma a wasiso bat iau, kataio i tur warut iau, det wan rop pas kut gusun iau. A wararing lena o God gong i balu anundet a petutna. ");
INSERT INTO kqw_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Ikut a Labino i warut iau, ma i udekdek iau sur an pam sot pas a warawai nama Wakak na Wasiso, ma a taro rop ra ausur a taro Juda det in longoro i. Det nem na um doko iau, ikut a Labino i ulaun pas iau. ");
INSERT INTO kqw_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","A Labino in ulaun iau gusun a kum sakino utna rop ra det nem na pami un iau, ma in ukis iau una nun a matanitu sapat una langit. Dat in watung ulabo pasi, ken rop ma ken rop. Amen. ");
INSERT INTO kqw_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Un pitar anung a marmaris torom o Pirisila ma o Akuila, ma det ra kura det kis tomo una rumu anun o Onesiporus. ");
INSERT INTO kqw_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","O Erastus munung i kis sikot tong o Korin, ra a wan pas bulung gusun o Tropimus tong o Miletus, uni i misait. ");
INSERT INTO kqw_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Un dekdek sur un nan urin ra ken kalang na kotokoto utmakai. O Iubulus, o Pudens, o Linus, o Kaludia ma a kum tistisindat rop una nurnur, det pitar anundet a marmaris torom ui. ");
INSERT INTO kqw_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","A Labino in kis una niom. A marmaris anun o God in kis torom mot. ");
INSERT INTO kqw_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Iau o Pol, a tultul anun o God ma a aposel anun o Iesu Karisito, sur an warut a nurnur anun a taro na pipilok anun o God, ma an ususer det sur det in tasman a lingmulus ino. A lingmulus ino ra in ben det sur det in mur a petutna anun o God. ");
INSERT INTO kqw_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","A nurnur ra, ma a tastasman ra, i wanpat tagun a kinkinis langlang nama nurnur sur a nilaun tukum. A nilaun tukum ra o God i uliliman taru nami, ra ke ukisi utmakai a rakrakon bual. Ma o God ke ser torotoro. ");
INSERT INTO kqw_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Ra a du bung i sa sot, i upuaso anun a wasiso ra met warawai nami. O God a Tene Ulaun anundat i pitar tar a pinapam na warawai tang elar ut nama nun a itula. ");
INSERT INTO kqw_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","A tumtumus torom ui Taitus, a nutunglik ra anundar a nurnur i elar. A marmaris ma a malmal anun o God a Tamandat, ma o Karisito Iesu anundat a Tene Ulaun, in kis tomo nam ui. ");
INSERT INTO kqw_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","A wan gusun ui tiro una ailan Krit, sur ui mo un urop a kum pinapam ra ke rop utmakai, ma un pilok pas lako kum mugumugu tagun a lotu, una kum tamon rop, elar nami ra a sa watung tari tam. ");
INSERT INTO kqw_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Ra un pipilok, un pilok pas taio ra katu etakun kura uni, i nolin kut nam ara ino, ma a kum nutnutunu det a kum tene nurnur, ma katu wasiso i los det un tu petutna, ma ka det ser pitarngat. ");
INSERT INTO kqw_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","I wakak ra a mugumugu tagun a lotu, i a ngas na musano ra katu etakun kura uni, uni i ut a tene tamtamabat una kum pinapam anun o God. Gong i ulabo pasi, gong i ser kankan lakit, gong i tene ininum, gong i tene inaim, ma gong i nemnem sur a susut na mani. ");
INSERT INTO kqw_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","In ser gas pas a taro una nun a rumu, ma in nemnem sur a wakak na petutna, in warkurai bat anun a nilaun, in tene tokodos, in tokodos umatan o God, ma in tamtamabat wakak anun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","In pam ukai a lingmulus na wasiso ra di sa ususer tari nami, sur in udekdek a taro una tokodos na etowo, ma in watung puaso a niraro anundet ra det turbat a Wakak na Wasiso. ");
INSERT INTO kqw_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Un pilok pas lako kum mugumugu tagun a lotu, uni a susut na taro a kum tene pitarngat. Det waswasiso una kum utna oros kut, ma det ben raro a nuknukin a taro. Ara taro tandet ra an utumarong ui un det, det ra det watungi lena, din tok talilis a pinin a taro ra ausur a taro Juda. ");
INSERT INTO kqw_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Un turbat anundet a kum wasiso, uni det ser upurpuruon a nurnur anun a susut na kamkabo tamano nam a kum etowo, ra ke wakak sur din ususer det nami. Det ser ususer det kut lenri sur det in toro pas a mani gusun det. ");
INSERT INTO kqw_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Ara poropet tagun a taro Krit ut, i watungi lenri, “A taro Krit, a kum tene torotoro mulus, a kum laulau na kuabor, a kum tubunu wok ra tagun a inangon kut.” ");
INSERT INTO kqw_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","A wasiso ri un det i lingmulus ut. Un wasiso dekdek torom det una nundet a kum niraro, sur det in pam ukai a tokodos na nurnur, ");
INSERT INTO kqw_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","ma gong mo det mur a kum etowo oros kut anun a taro Juda, ma a kum warkurai anun a taro ra ka det nem a lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","A kum utna rop i tokodos torom det ra det tokodos, ikut torom det ra ka det tokodos ma ka det nurnur, a kum utna rop kai ken tokodos. A balandet in laulau doko, ma katu tokodos ino tiro una nuknukindet. ");
INSERT INTO kqw_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Det watungi lena, det tasman o God, ikut anundet a kum pinapam ut i upuaso i lena, ka det tasmani. Det a kum sakino taro doko, a kum tene pitarngat, ma ka det in pam lar pas tu wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Ikut ui, un ususer det nam asau ra i mur wakak a tokodos na etowo. ");
INSERT INTO kqw_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Un ususer a kum musano ra a kum mugano tam, sur det in tumarong a magirandet, det in los a ngas na nilaun ra a taro det in ru det uni, det in warkurai bat anundet a nilaun, det in lingmulus una nundet a nurnur, anundet a marmaris ma anundet a tuntunur dekdek ra det etorom a mamaut. ");
INSERT INTO kqw_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Lenkutkai ra, un ususer a kum wardain ra a kum mugano tam, sur det in lason una kisapi na urur una nundet a nilaun, gong det emang, gong det tene ininum, ikut det in ususer a taro nam asau ra i wakak. ");
INSERT INTO kqw_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Det in pami lenra sur det in ususer a kum wardain numur tandet, sur det in nem anundet a kum musano ma a kum nutnutundet, ");
INSERT INTO kqw_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","det in tamtamabat wakak anundet a nilaun, det in mur a tokodos na petutna, det in lason una pam a kum pinapam tiro una rumu, det in lason sur det in pam a wakakino torom a taro, ma det in ru anundet a kum musano, sur gong taio i watung laulau a wasiso anun o God. ");
INSERT INTO kqw_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Lenkutkai ra, un udekdek a kum barman, sur det in tamtamabat wakak anundet a nilaun. ");
INSERT INTO kqw_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Una kum utna rop ra u pami, un pam a wakakino, sur a wakak na larlar torom det. Ra u ususer det, un papam nama lingmulus, ma a urur. ");
INSERT INTO kqw_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Un watung a tokodos na wasiso ra ka taio in pukus ui uni, sur det ra det turbat ui det in maimai, uni ka dat pam tu sakino sur det in watung laulau dat uni. ");
INSERT INTO kqw_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Un inanos a kum tene ititula sur det in taromlu anundet a kum mugumugu una kum utna rop, ma det in ugasgas det nama kum pinapam rop ra det in pami, ma gong det balu wasiso. ");
INSERT INTO kqw_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Gong det wolong anundet a kum mugumugu. Det in upuaso anundet a wakak na petutna, sur anundet a kum mugumugu det in nurnur un det, sur in upuaso i lena, a etowo un o God a Tene Ulaun anundat i wakak. ");
INSERT INTO kqw_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Uni a marmaris anun o God sur a ululaun anun a taro rop, i sa wanpat taltalapor. ");
INSERT INTO kqw_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","A marmaris ri i ususer dat, sur dat in nan gisen gusun a kum petutna ra ke sot nama nuknukino God, ma gusun a kum nemnem sur a kum utna tagun a rakrakon bual, ma dat in tamtamabat wakak anundat a nilaun, dat in tokodos, ma dat in laun murmur a nuknukin o God una nilaun ri, ");
INSERT INTO kqw_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ra dat kis langlang nama nurnur sur a bung na gasgas ra in nanpat. A bung ra anundat a Labino o God, o Iesu Karisito, a Tene Ulaun anundat in nanpat nama nun a minamar. ");
INSERT INTO kqw_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","I pitar tar anun a nilaun un dat, sur in kul ulangolango pas dat gusun anundat a kum sakino petutna rop, ma in utalapor pas dat, sur dat anun a taro mulus ut, ra dat nem doko i sur dat in pam a kum wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Un ususer det nama kum wasiso ri. Un udekdek a taro, ma un watung puaso anundet a niraro umatandet. Un pami nama dekdek ra kura torom ui. Ma gong u madek tar taio sur in nuki lena ui a musano oros kut. ");
INSERT INTO kqw_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Un inanos melet anum a taro sur det in urur torom a kum mugumugu tagun a gapman, ma torom det rop ra a warkurai kura un det. Det in tarom, ma det in kis na waninar sur det in pam a kum wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Gong det emang, det in balano molmol, det in pam a wakakino torom a taro, ma det in unatino pas det. ");
INSERT INTO kqw_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Uni dat kai numugu, ka dat mananos, dat a kum tene pitarngat, dat wan raro, dat kis na kineker una nundat a kum laulau na nemnem, ma a wur ngas na utna rop ra dat gas suri. Una nundat a kinkinis na nilaun dat pam a kum sakino, ma dat sakino nuknuk eno sur a utna anun taio, ma dat nget etetalai dat. ");
INSERT INTO kqw_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Ikut, ra a wakak na petutna ma a marmaris anun o God, a Tene Ulaun anundat i wanpat, ");
INSERT INTO kqw_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","i ulaun dat. Ausur un lako kum tokodos na pinapam ra dat sa pam tari, awu. I ulaun dat uni i maris dat. I ulaun dat ma i rus talapor dat. A utalapor ra, a Tokodos na Nion i pami una nundat a nilaun, ra i usus matok dat, ma anundat a nilaun i wanpat matok uni. ");
INSERT INTO kqw_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","O God i tabor dat nama Tokodos na Nion, ra i lingis orosi kut sapat netes un dat, kibino una pinapam anun o Iesu Karisito, anundat a Tene Ulaun. ");
INSERT INTO kqw_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","I ulaun dat, sur dat in rakon a nilaun tukum, ra dat kis langlang suri nama nurnur. Ra i ulaun dat, i watung dat lena dat tokodos umatano, kibino una nun a marmaris. ");
INSERT INTO kqw_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","A kum wasiso ri i lingmulus sakit. Ma a nemi sur un papam dekdek nami, sur a taro ra det nurnur un o God, det in pitar mulus tar det una wakak na pinapam una nundet a kum bung na nilaun. A kum wasiso ri i wakak ma i warut a taro rop. ");
INSERT INTO kqw_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Un nan gisen gusun a kum tuptup na wasiso, ma a kum saksak utna na kabotaro, ma a engaras, ma a inaim na wasiso una kum Warkurai anun o Moses, uni ka det gas un tu utna, ra ken warut ui. ");
INSERT INTO kqw_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Ra taio in ser pagol a taro na nurnur, un wasiso na utumarong toromi sur in mana. Ra ken longoro ui, un wasiso na utumarong melet toromi. Ra ken longoro mo, un nan gisen gusuni. ");
INSERT INTO kqw_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Ra taio i pami lenra, un tasmani kut lena, i sa raro, ma i sa bukus nama sakino petutna. Anun a sakino petutna ut ra, i beni utiro una iniru tukum. ");
INSERT INTO kqw_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Ra an tulu ru o Artemas o, o Tikikus torom ui, un dekdek sur un nan torom iau tong o Nikopolis, uni an kis ru a kum kalang na kotokoto tong. ");
INSERT INTO kqw_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Un tulu ru o Apolos ma o Senas, i ra a tene mananos tagun a kum warkurai, ma un warut der sur gong der sibo sur tu utna. ");
INSERT INTO kqw_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Anundat a taro, det in lason sur det in pitar mulus tar det una wakak na pinapam, sur det in wu a wakak na windet una anundet a nilaun, ma det in warut a sibo na taro. ");
INSERT INTO kqw_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Det rop ra det kis tomo nam iau, det pitar anundet a marmaris torom ui. Un pitar anumet a marmaris torom a kum paspasamet una nurnur. A marmaris anun o God in kis torom mot rop. ");
INSERT INTO kqw_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Iau, o Pol, a karabus, uni a nurnur un a Karisito Iesu. Mir nam o Timoti a tisindat, mir tumus a pas ri torom ui Pilimon, a wakak na pasamet una pinapam, ");
INSERT INTO kqw_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ma torom o Apia a ino a tisindat, ma torom o Arkipus a pasandat una inaim nama Wakak na Wasiso, ma torom a taro na lotu ra mot ser wan tomo una num a rumu. ");
INSERT INTO kqw_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","A marmaris ma a malmal anun o God a Tamandat, ma a Labino o Iesu Karisito in kis torom ui. ");
INSERT INTO kqw_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ra a wararing, a ser nuk pas ui, ma a watung wakak torom o God un ui. ");
INSERT INTO kqw_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","Uni a longoro i lena, u nem a taro rop anun o God, ma u nurnur una Labino o Iesu. ");
INSERT INTO kqw_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","A wararing lena, un upuaso anum a nurnur una Karisito torom a taro ma un ususer det uni. Ra un pami lenri, in warut ui sur un mananos una kum wakak na utna rop anundat ra i kis una Karisito. ");
INSERT INTO kqw_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Tisinglik, anum a marmaris torom a taro anun o God i sa pitar tar a labino gasgas tang, ma i udekdek iau, uni u ugasgas a nilaun anundet. ");
INSERT INTO kqw_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Ara utna a nem doko i sur un pami. I topas iau sur an wasiso dekdek torom ui uni, uni dar tar tisino una Karisito. ");
INSERT INTO kqw_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Ikut, a saring wakak ui, uni a nem ui. Iau, o Pol, a sa takano, ma uniri a kis na karabus, uni a nurnur una Karisito Iesu, ");
INSERT INTO kqw_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","a saring pas anum a nimulaot un o Onesimus, a nutunglik una nurnur. I wanpat torom iau ra a kis una karabus, ma i nukpukus. Ra iri i elar nama nutunglik mulus ut una nurnur. ");
INSERT INTO kqw_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Numugu ke gas matano sur in papam torom ui, ikut uniri, i a wakak na tene pinapam mo, torom ui ma iau. ");
INSERT INTO kqw_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Uniri a tulu ru i milet mo torom ui. Ra i wan gusun iau, i elar nam ara kukur tagun anung a nilaun i wan tomo nami. ");
INSERT INTO kqw_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","A nemi sur in kis mukut tomo nam iau, sur in keles ui Pilimon, ma in warut iau, ra a kis una karabus uni a warawai nama Wakak na Wasiso. ");
INSERT INTO kqw_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Ikut ka nemi sur an ungongos pas ui sur un warut iau, ui ut un pami elar nama num a gasgas. Kan pam tu utna, tuk ui ut un mulaot. ");
INSERT INTO kqw_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Kutiro o Onesimus i kis gisen lilik pas kut gusun ui, sur i mo ri, in kis tukum tomo nam ui. ");
INSERT INTO kqw_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Uniri ken elar melet mo nama tene ititula, in elar nam a tisimlik mulus una nurnur. A marisi, ikut a tasmani lena, anum a marmaris toromi i labo taun a marmaris ra a marisi nami, uni, i anum a tene pinapam ma a tisimlik kai una Labino. ");
INSERT INTO kqw_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Ra u nuki lena dar pasano, un gas melet pas o Onesimus, elar nami ra un gas pas iau ut. ");
INSERT INTO kqw_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Ra i sa pam tar tu sakino torom ui, o i sa los pas anum tu utna, iau mukut an balu i. ");
INSERT INTO kqw_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Iau o Pol, iau ut a tumus a wasiso ri nama lamang: an balu asau ra torom ui. Kan watung tu utna tam, ui ut u sa tasman tari lena, a matok na nilaun ra u sa los pasi, i kibino ut un iau, ma i elar nama dinau torom ui. ");
INSERT INTO kqw_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","A lingmulus, tisinglik, una risan a Labino, a nemi sur un gas melet pas o Onesimus. Ui a tisinglik una Karisito, un ugasgas anung a nilaun. ");
INSERT INTO kqw_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Ra a tumus a pas ri, a tasman mulusi lena, un tarom ut una nung a sasaring torom ui, ma a tasmani kai lena un pam a utna in labo taun asau ra a saring ui suri. ");
INSERT INTO kqw_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Ara utna kai: A saring ui sur un waninar tu kukur rumu sur iau, uni a nurnur lena, o God in upirso ru iau gusun a karabus sur an milet melet torom mot. Iri i a win anumot a kum niaring. ");
INSERT INTO kqw_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","O Epapras, i ra i karabus tomo nam iau, uni i nurnur una Karisito Iesu, i pitar ru anun a marmaris torom ui. ");
INSERT INTO kqw_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Ma det kai ri, o Mak, o Aristakus, o Demas ma o Luk. Met paspasano tomo una pinapam. ");
INSERT INTO kqw_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","A marmaris anun a Labino o Iesu Karisito in kis una niomot. ");
INSERT INTO kqw_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Iau o Jems a tultul anun o God ma anun a Labino o Iesu Karisito, a tumus a pas ri torom mot a noino ma aru kabotaro Israel. Mot kis sarara una kum tamon una rakrakon bual, uni det nem na um doko mot. A marmaris torom mot. ");
INSERT INTO kqw_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","A kum tistising, ra lako kum ngas na maut in nanpat torom mot, mot in gas, ");
INSERT INTO kqw_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","uni mot tasmani lena, a kum maut, ra di lar anumot a nurnur nami, i ra, in ulabo anumot a tuntunur dekdek. ");
INSERT INTO kqw_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Ra mot in tur dekdek, mot in tokodos sakit una numot a nilaun rop, ma ka mot in sibo sur tu wakak na petutna. ");
INSERT INTO kqw_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Ra taio tagun mot i sibo sur a mananos, in saring o God suri. Ra o God in tabori nami, uni i ser tabor dat rop, ma ke ser bitan tu utna. Ma ke ser kankan torom taio ra i sasaring. ");
INSERT INTO kqw_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Ikut ra in wararing, in wararing nam a nurnur, ma gong i wur nuknuk. Uni osi ra i wur nuknuk, i elar kut nama top, ra a wuwu i wup tuptupukusi. ");
INSERT INTO kqw_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","A musano ra i wur nuknuk, gong i nuki lena, in rakon tu utna tan a Labino. ");
INSERT INTO kqw_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Uni aru nuknukino, ra ken tur dekdek una nun a kum pinapam rop. ");
INSERT INTO kqw_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Ra tu tisindat una nurnur i sibo, i wakak ra in gas kut, uni o God ut i sa ulabo pasi. ");
INSERT INTO kqw_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Ra taio a tene gongon, in gas kut ra o God in unatino i. Uni, anun a nilaun i elar kut nam a puspus na duwai, in rop oros kut. ");
INSERT INTO kqw_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Uni in matanas in pusu pat nama labino mararong ino, ra in rang in nanai, ma a puspus ino in puku, ra a wakak na tamtama ino in rop. Lenkutkai lar a tene gongon in rop tomo nam anun a kum ululeng. ");
INSERT INTO kqw_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","O naro ra i tur dekdek una kum ululam, i dan. Uni o naro ra i turus pas a kum larlar ra di lar anun a nurnur nami, in rakon a kukup na nilaun tukum, ra o God i sa liliman taru sur in pitari tandet ra det nemi. ");
INSERT INTO kqw_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Ra a ululam in nanpat torom taio, gong i watungi lena o God i pitari. Uni a sakino ken ulam lar pas o God, ma o God ut ken ulam taio. ");
INSERT INTO kqw_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","A taro rop, taktakai, anundet a kum laulau na nemnem ut i ulam pas det, ma i dat pas det, sur det in pam a sakino. ");
INSERT INTO kqw_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Numur, ra anundet a laulau na nemnem in labo, in usus pat pas a sakino petutna. Ra a sakino petutna in labo, in usus pat pas a minat. ");
INSERT INTO kqw_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","A kum wakak na tistising, gong mot madek tar taio sur in toro pas mot. ");
INSERT INTO kqw_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","A kum wakak na etabor rop, ra det tokodos sakit, det wan pirso tagisapat una langit. Det wanpat tan o Tita, i ra i ukis in matanas, a kalang ma a kum nangnang. Ikut o Tita ke ukukeles, ma ke pukpukus anun a ngasino elar nam in matanas, ra in sisio pas una waspi ma una mirum awu. ");
INSERT INTO kqw_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Una nun a nemnem ut, o God i usus matok dat nam anun a lingmulus na wasiso. I pilok pas dat gusun a kum utna na ukukis rop, sur dat elar nam a kum mugano wino duwai ra di ser etabor nami torom o God. ");
INSERT INTO kqw_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","A kum wakak na tistising, mot in tasman a utna ri: I wakak ra mot rop, mot in longoro lakit, ikut gong mot wasiso lakit, ma gong mot kankan lakit. ");
INSERT INTO kqw_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Uni a kankan anun taio ken waruti, sur in pam a tokodos na petutna ra o God i nemi. ");
INSERT INTO kqw_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Mot in mana gusun a kum dur na petutna, ma a kum sakino, ra kuri i bukus una rakrakon bual. Ra mot in unatino pas mot, ma mot in mur a wasiso ra di sa marut tari una balamot, a wasiso anun o God ra in ulaun mot. ");
INSERT INTO kqw_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Mot in mur a wasiso anun o God, ra gong mot longoro oros tari kut, sako mot in toro pas mot melet ut. ");
INSERT INTO kqw_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Osi ra i longoro oros tari kut a wasiso anun o God, ma ke muri, i elar kut nam a musano ra i tama in masarino una galas. ");
INSERT INTO kqw_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Ra in nan gisen, uniutra in dumano ru in masarino ra i tamtama pepetlai. ");
INSERT INTO kqw_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Ikut, ra taio in longoro wakak a tokodos na warkurai anun o God, a warkurai ra i ser ulangolango a taro, ma in ser muri, ma ke dumano i, a musano ra, in dan una nun a kum pinapam. ");
INSERT INTO kqw_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ra taio in nuki lena, i sa lingmulus na tene lotu, ikut, ra ke tumarong in karmene, i toro pasi ut, ma anun a lotu in utna oros kut. ");
INSERT INTO kqw_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Ikut, ra dat warut a kum nat na soi, ma a kum ula, ra det pot na marmaris, ma dat tumarong dat kai gusun a kum dur na petutna tagun a rakrakon bual, iri a lingmulus na lotu, ra i tokodos, ma katu utna i raro uni umatan o God a Tamandat. ");
INSERT INTO kqw_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","A kum tistising, mot ra mot nurnur una nundat a Labino o Iesu Karisito, ra i bukus nama minamar, gong mot ru ara taro kut, ma ara taro awu. ");
INSERT INTO kqw_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Ra lako ru musano der in ruk una numot a kiwung na lotu, ra ara pasander i ubek a ring na gol, ma i emar nama kum wakak namalu, ma ara kai, a sibo na musano i emar kut nam in turai na malu. ");
INSERT INTO kqw_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ikut, ra mot urur kut torom i ra i emar nam a wakak na malu ma mot watungi tano lena, “Un kis nin una wakak na kiskis,” ma mot watungi kut torom a sibo na musano lena, “Un tur ut tiro iai,” o “Un kis kut nin upiso nisan aru kiking,” ");
INSERT INTO kqw_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","ke takai anumot a ngasino torom a taro rop, ma mot warkurai kut nam a sakino nuknukimot. ");
INSERT INTO kqw_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","A kum wakak na tistising, mot in longoro iau: Pepetlai, ka mot tasmani lena, o God i pilok pas a kum sibo na taro nin upiso, sur det in tene gongon una nurnur? Det in rakon pas a matanitu ra o God i sa liliman tari, sur in pitari tandet ra det nemi. ");
INSERT INTO kqw_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ikut mot, mot ban umaimai i kut a kum sibo na taro. A kum tene gongon, det ser ukis laulau mot nam a dekdek ra det utur ukai i, niko? Ra det dat pas mot sur mot in tur una warkurai. ");
INSERT INTO kqw_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","O God i pitar tar a wakak na rising anun a Karisito torom mot. Ma osi ra i ser watung laulau a rising ri? A kum tene gongon kut. ");
INSERT INTO kqw_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Mot in pam sot pas a warkurai ra i labo sakit una Buk Tabu. I lenri, “Un nem a pasam elar nami ra u nem ui ut.” Ra mot pami lenra, mot pam a tokodos na petutna. ");
INSERT INTO kqw_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ikut, ra mot ru ara taro kut, ma ara taro awu, mot pam a sakino petutna. Ra a kum Warkurai anun o God i takun sot pas mot lena, mot a kum tene lakai warkurai. ");
INSERT INTO kqw_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Uni osi ra i mur a kum Warkurai rop, ikut i kutus ara tagun a kum Warkurai, din warkurai i elar nam o naro ra i lakai a kum Warkurai rop. ");
INSERT INTO kqw_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","O God i watungi lena, “Gong u pam a sakino un tu ino,” ma i watungi kai lenri, “Gong u um doko taio.” Ra ko pam a sakino un tu ino, ikut u um doko taio, ui a tene lakai warkurai. ");
INSERT INTO kqw_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Mot in wasiso ma mot in papam elar nam det ra o God in kuro det nam a warkurai ra i ser ulangolango pas a taro nami. ");
INSERT INTO kqw_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Uni, osi ra ke lason una marmaris, o God kai ken marisi una bung na warkurai. Ikut, o naro ra i lason una marmaris, o God in marisi una bung na warkurai. ");
INSERT INTO kqw_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","A kum tistising, in wakak pepetlai ra taio in watungi lena i nurnur, ikut ke pam tu wakak na pinapam? Pepetlai, a ngas na nurnur ra, in ulauni o awu? ");
INSERT INTO kqw_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Ra taio tagun a kum tistisindat, tu ino o tu musano, ka tin namalu anunu, ma kalako utna na inangon, ");
INSERT INTO kqw_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ra taio tagun mot in watungi tano lena, “Un nan nam a malmal, un emar ma un masur,” ikut, ra ken tabori nam tu utna ra i sibo suri, anun a wasiso ra in warut petlan o naro ra i sibo? ");
INSERT INTO kqw_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Lenkutkai lar a nurnur, ra ke wan tomo nam tu wakak na pinapam, a nurnur ra, a minatino. ");
INSERT INTO kqw_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Ra taio kai in watungi lena, “Ui u nurnur, ma iau, a pam a kum wakak na pinapam.” Un upuaso anum a nurnur torom iau, ra ke wan tomo nam a wakak na pinapam. Ra iau, an upuaso anung a nurnur tam, nam anung kum wakak na pinapam. ");
INSERT INTO kqw_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","U nurnur lena o God i ara kut. I wakak. A kum laulau na nion kai det nurnur lenra, ma det ngara suri, ra det neneder. ");
INSERT INTO kqw_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Ui a longlong ui! A nurnur ra katu wakak na pinapam tomo nami, i utna oros kut. Pepetlai, u nemi sur an upuaso a wasiso ra tam? ");
INSERT INTO kqw_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","A tamandat o Abaram i pitar tar a nutunulik, o Aisak, elar nam a etabor torom o God netes una kabulu na tuntun etabor, ra i pami nama kum watat. Una nuna pinapam ra, di watungi lena, i a tene tokodos umatan o God. ");
INSERT INTO kqw_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Un tama i, anun a nurnur i wan tomo nam anun a kum wakak na pinapam. Anun a nurnur ra i wan tomo nam a pinapam, i pam sot pas anuna nurnur, sur in kudulano. ");
INSERT INTO kqw_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Ra di pam sot pas a wasiso una Buk Tabu ra i watungi lenri, “O Abaram i nurnur un o God, ma o God i watungi lena, i a tene tokodos umatano.” Ra o God i watungi kai lena der pasano. ");
INSERT INTO kqw_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Mot tama i, o God i watung a musano lena i a tene tokodos, kibino una nun a kum wakak na pinapam, ra ausur una nun a nurnur kut. ");
INSERT INTO kqw_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Ra lenkutkai lar o Reap, a pamuk na ino. O God i watungi lena i tokodos umatano, kibino una nun a wakak na pinapam ra i tamtamabat aru tene tamtama eno anun a taro Israel, ra i tulu eno ru der melet una ara kisapi gisen. ");
INSERT INTO kqw_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Taio ra a niono i wan gusuni, i a minatino. Lenkutkai lar a nurnur, ra ke wan tomo nam lako wakak na pinapam, a nurnur ra, a minatino kut. ");
INSERT INTO kqw_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","A kum tistising, gong lako susut tagun mot det wanpat a kum tene ususer tagun a lotu, uni mot tasmani lena, a warkurai anun o God torom met, a kum tene ususer, in dekdek sakit tan a warkurai torom a taro gisen. ");
INSERT INTO kqw_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Dat rop dat raro una susut na utna. Ikut, ra taio ke raro un tu utna una nun a wasiso, i ra i tokodos sakit, ma in pet lar pasi sur in ukodos pas anun a nilaun rop. ");
INSERT INTO kqw_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Ra dat in ubek a nat na du aen una wan a os sur in tarom tandat, dat in pet lari sur dat in dat pukus pas a kudulano os nami. ");
INSERT INTO kqw_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Mot in tama i kai a sip sel. I labo doko, ma a kum dekdek na wuwu det ukalabori, ikut din ukodosi kut nam a nat na stia ino, sur in mur a nemnem anun a kiapten. ");
INSERT INTO kqw_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Lenkutkai lar in karmendat, i ara nat na dino kut tagun a pinindat, ikut i ulabo pasi nam a kum lamlabino utna ra i ser pami. Mot tama i, tin na nat na lakit ina sungun kut in pet lari sur in tun rop ru tu labino lokor. ");
INSERT INTO kqw_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","In karmendat i elar nam a sungun. I ara dino tagun a pinindat, ra i bukus nam a laulau ino, ra i udur a kudulano pinindat rop. I ungangon anundat a kudulano nilaun nam a sungun tagun a labino sungun, ra ke ser mat. ");
INSERT INTO kqw_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","A taro det sa umarom pas a kum wewegua, a kum piko, ma a kum utna ra det kaukawar una piso, ma a kum utna ra det laun sa utasi. ");
INSERT INTO kqw_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Ikut in karmendat, kataio in ulason lar pasi, ma katutaio kai in ukodos lar pasi. I laulau sakit, ma i bukus nam a sangsagor. ");
INSERT INTO kqw_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Dat watung ulabo pas a Labino a Tamandat nam a karmendat, ma dat watung laulau i kai a taro nami, det ra o God i ukis tar det elar nam a malalar ino. ");
INSERT INTO kqw_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","A wasiso na watung ulabo a Labino, ma a wasiso ra i banlaulau taio, der rop, der ser pirso kut gusun a wandat. A kum tistising, ke tokodos lenra. ");
INSERT INTO kqw_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","A danim ra i mapak, ma a danim ra i wakak, der in sal tomo pepetlai gusun in teken matmatano danim kut? ");
INSERT INTO kqw_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","A kum tistising, in nanai na fig ken wu in wino oliw, ma in nanai na wain kai ken wu a wino fig. Lenkutkai lar a wakak na danim ken nanpat tagun a mapak na danim. ");
INSERT INTO kqw_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Osi na pasamot i mananos, ma i tastasman? I wakak ra in upuaso i una nun a wakak na nilaun, una nuna kum wakak na pinapam, tomo nam a ngasino ra i unatino pasi ut. A ngasino ra i unatino pasi ut, i wanpat tagun a mananos mulus. ");
INSERT INTO kqw_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Ikut, ra mot nuknuk laulau sur a utna anun taio, ma mot nuknuk sur tu kisapi sur mot in ulabo pas mot nami, gong mot watung ulabo pas mot uni, ma gong mot toro bat pas a lingmulus ino. ");
INSERT INTO kqw_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","A mananos ra, ausur tagisapat netes una langit, a mananos kut taginin upiso. I wanpat kut tan o Satan, ma ausur tagun a Tokodos na Nion. ");
INSERT INTO kqw_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Uni, osi ra i nuknuk laulau sur a utna anun taio, ma i nuknuk sur tu kisapi sur in ulabo pasi nami, anun a nilaun in lokolokor ma i bukus nama wur sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Ikut osi ra i utur ukai a mananos tagisapat una langit, a mugano utna in tokodos, ma in tene malmal, ma in ser nuk pas a taro gisen, ma in lason una tinorom, in bukus nam a marmaris, ma in wu a wakak na wino una nun a nilaun, ma a petutna in pami in elar torom a taro rop, ma katu torotoro tiro una nun a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","A tene malmal ra i ser papam nam a malmal, i elar nam a tene minarut. Ma a utna ra in pasong pasi, i a tokodos na petutna. ");
INSERT INTO kqw_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Asau a kibino ra mot waim ma mot engaras etetalai? I kibino una numot a kum laulau na nemnem ra det waim una numot a nilaun. ");
INSERT INTO kqw_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Mot nem a kum utna, ikut ka mot utur ukai i. Mot um doko a taro, ma mot nuknuk laulau sur a utna anundet, ikut ka mot pam ukai a utna ra mot nemi. Mot engaras ma mot waim. Ka mot pam ukai a kum utna ra mot nemi, uni ka mot saring o God suri. ");
INSERT INTO kqw_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ra mot wararing, ka mot utur ukai a utna ra mot sasaring suri, uni a nuknukimot ke tokodos. Mot sasaring kut sur a utna ra in ugasgas mot ut. ");
INSERT INTO kqw_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Mot sa wan gusun o God, elar nam a ino ra i wan pas gusun anun a musano, ra i nolin tomo nama ara musano bulung. Ka mot tasmani lena, ra mot nem a petutna tagun a rakrakon bual, mot a kum ebar anun o God? Osi ra i pilok pas a rakrakon bual sur der pasano, i a ebar anun o God. ");
INSERT INTO kqw_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Mot nuki lena a Buk Tabu i wasiso oros kut? I watungi lena, “A Nion o God, ra o God i pitar tari tandat, i nem dat sur dat anunu ut.” ");
INSERT INTO kqw_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Ra a marmaris ra o God i pitar tari tandat i labo sakit. A Buk Tabu i watungi lenri, “O God i unatino pas det ra det ser ulabo pas det, ikut i maris det ra det ser unatino pas det.” ");
INSERT INTO kqw_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Mot in unatino pas mot, ma mot in mur o God. Mot in turbat ru o Satan, sur in nan gusun mot. ");
INSERT INTO kqw_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Mot in nan milau torom o God, ra o God in nan milau torom mot. Ma mot a kum tene sakino, mot in gos a kum lamamot, ma mot ra aru nuknukimot, mot in utalapor a balbalamot. ");
INSERT INTO kqw_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Mot in tupunuk, mot in domos, ma mot in tangis una numot a kum sakino petutna. Mot in pukus anumot a ninongon sur a tinangis, ra mot in pukus anumot a gasgas sur a tupunuk. ");
INSERT INTO kqw_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Mot in unatino pas mot umatana Labino, ra i ut in ulabo pas mot. ");
INSERT INTO kqw_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","A kum tistising, gong mot mang etalai mot. Osi ra i mang tu tisino, o i warkurai i, i watung laulau a kum Warkurai anun o God ma i kuro a kum Warkurai ra. Ma ra un kuro a kum Warkurai, ausur u muri, u nuki kut lena ui ut u labo tano. ");
INSERT INTO kqw_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","O God kut i pitar a Warkurai, ma i sot kut a Tene Warkurai. O God kut i warkurai a taro sur a nilaun, o sur a iniru. Ra ui osi, sur un warkurai a pasam? ");
INSERT INTO kqw_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Mot longoro, mot ra mot ser watungi lena, “Uniri o markan met in nan sur tu tamon, ma met in kis iai ara kilalo. Met in kukul ma met in siuru sur met in pam pat lako mani.” ");
INSERT INTO kqw_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ikut ka mot tasman asau ra in nanpat torom mot markan. Anumot a nilaun i elar nam asau? Mot elar kut nam in nawal, ra i wanpat pas kut, ra i rorom melet. ");
INSERT INTO kqw_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Ikut, i wakak sur mot in watungi lenri, “Ra a Labino i nemi, met in laun ma met in pami lenri o lenra.” ");
INSERT INTO kqw_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Ikut uniri, mot sa ulabo pas mot melet nam anumot a kum wasiso. A ngasino lenra ke wakak. ");
INSERT INTO kqw_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","O naro ra i tasman a wakakino sur in pami, ikut ke pami, i pam a sakino petutna. ");
INSERT INTO kqw_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Mot a kum tene gongon, mot in longoro: Mot in tangtangis, ma mot in kukukuk, uni a kum ngunungut in nanpat torom mot. ");
INSERT INTO kqw_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Anumot a kum ululeng det sa moroto, ma a koropos i sa banlaulau ru anumot a kum malu. ");
INSERT INTO kqw_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Anumot a gol ma a silwa der sa ros, ma a ros inder in takun mot, ma in nan a pinimot elar nam a sungun. Una kum tintinip na bung ri, mot sa ubek tomo pas anumot a kum ululeng. ");
INSERT INTO kqw_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Tama i, ka mot tokom tar a taro ra det papam una amot a kum kinobot, ra a ikul anundet i takun mot. Ra o God a Dekdek na Labino i sa longoro tar a tinangis anundet ra det pasong. ");
INSERT INTO kqw_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Una numot a nilaun nin una rakrakon bual, mot ukio a labino mani, una kum lukaro un mot ut, ma un asau ra i ugasgas mot. Mot tabor butbut a pinimot, ra milau mo mot in iru, elar nama kum wewegua, ra di tabor butbut det sur din um doko det. ");
INSERT INTO kqw_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Mot ben tar a kum tene tokodos una warkurai, ra mot um doko det, ikut ka det balu mot. ");
INSERT INTO kqw_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","A kum tistising, gong mot pino ngoro lakit, ra mot kis langlang sur a inawan pat melet anun a Labino. Mot tama a tene marut, ke pino ngoro lakit, ra i kiskis langlang sur a bato in puk a piso, ma sur a wakak na makus tagun a ana kinobot. ");
INSERT INTO kqw_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Mot kai, gong mot pino ngoro lakit, mot in tur dekdek una nurnur, uni a inawan pat melet anun a Labino i sa milau. ");
INSERT INTO kqw_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","A kum tistising, gong mot ururai etetalai, surko o God in warkurai mot. Tama i, a Tene Warkurai i sa tur nisan a matansako. ");
INSERT INTO kqw_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","A kum tistising, mot in nuk pas a kum poropet tagun numugu, ra det waswasiso nama risan a Labino. Det etorom a kum ngunungut, ikut ka det pino ngoro, det tur dekdek una nurnur. Ra anundet a nilaun, i a wakak na larlar torom mot, sur mot in muri. ");
INSERT INTO kqw_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Tama i, ara taro tagun numugu det etorom a kum mamaut, ikut det tur dekdek una nurnur. Dat watung det lena det dan. Mot tasman a nilaun anun o Jop, i etorom a kum mamaut, ikut i tur dekdek una nurnur. Ra numur, a Labino i udan meleti. A Labino i bukus nama marmaris ma i a tene warut. ");
INSERT INTO kqw_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","A kum tistising, iri i a utna ra i labo sakit, gong mot udekdek anumot a kum uliliman nam tu ngas na wasiso kai. Gong mot liliman nam a langit, o a rakrakon bual, o tu utna gisen kai. Ra mot mulaot, mot in lena “ma,”. Ra mot ipul mot in lena “awu,” i kut ra, sur gong mot iru una warkurai anun o God. ");
INSERT INTO kqw_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Ra taio tagun mot i taramo a maut, i wakak sur in wararing. Ra taio i gasgas, i wakak sur in kele a kum kelekele na ulabo torom o God. ");
INSERT INTO kqw_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Ra taio tagun mot i misait, in itula sur a kum mugumugu na lotu, sur det in wararing uni, ma det in talusi nam a wel, nama risan a Labino. ");
INSERT INTO kqw_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","A niaring ra i wan tomo nam a nurnur, in ulangolango i ra i misait, ma a Labino ut, in ulangolango melet pasi. Ma ra i sa pam tar a sakino petutna, a Labino in dumano ru i gusuni. ");
INSERT INTO kqw_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Mot in wasiso puaso etetalai torom mot una numot a kum sakino petutna, ra mot in wararing un mot etalai, sur a Labino in ulangolango pas mot. A niaring anun a tene tokodos i dekdek sakit, ma i wu pat a wino. ");
INSERT INTO kqw_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","O Elaija, a poropet, i a musano i elar kut nam dat. I wararing sur gong i bato, ra a tulu kilalo ma wonom na kalang ke bato. ");
INSERT INTO kqw_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Numur i wararing melet sur in bato, ra in nabato i puku, ma a kum utna i lubung melet, ma det wu. ");
INSERT INTO kqw_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","A kum tistising, ra taio tagun mot in nan raro gusun a lingmulus ino, mot in ben pukus melet pasi. ");
INSERT INTO kqw_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","A watungi tamot, ra taio in ben pukus pas a tene sakino gusun anun a kum niraro, i sa ulaun pas a nion a musano ra gusun a minat, ra a Labino in dumano ru a susut na sakino petutna. ");
ALTER TABLE kqw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
