﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqp_vpl;
CREATE TABLE kqp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqp_vpl WRITE;
INSERT INTO kqp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tô môɲ wo Jésu wo na *kuŋga kelma Dabid wo na kuŋga *Abraham a men hen a na: ");
INSERT INTO kqp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham yê Isak, Isak yê Jakwôb, Jakwôb yê Juda naɲ yênêri. ");
INSERT INTO kqp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda yê Parês naɲ Jara wo yori na Tamar hen, Parês yê Esrôm, Esrôm yê Aram, ");
INSERT INTO kqp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram yê Aminadab, Aminadab yê Nasôn, Nasôn yê Salmôn, ");
INSERT INTO kqp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmôn yê Bohoj wo yori na Rahab hen, Bohoj yê Obêd wo yori na Rut hen, Obêd yê Jésé, ");
INSERT INTO kqp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jésé yê kelma Dabid. Dabid yê Salomôn wo yori na tam Uri hen, ");
INSERT INTO kqp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomôn yê Roboham, Roboham yê Abiya, Abiya yê Asap, ");
INSERT INTO kqp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asap yê Josapat, Josapat yê Joram, Joram yê Ojiyas, ");
INSERT INTO kqp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojiyas yê Johatam, Johatam yê Akaj, Akaj yê Ejékiyas, ");
INSERT INTO kqp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejékiyas yê Manasé, Manasé yê Amôn, Amôn yê Josiyas, ");
INSERT INTO kqp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiyas yê Jékwoniyas naɲ yênêri. Na elê bi wo hen aɲa bay ré pôriɲ balêrji ôriɲ Babilôn a lemnare hen. ");
INSERT INTO kqp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kam *Israyêl ka bay yêji Babilôn a tô lemnare a a na: Jékwoniyas yê Salatiyêl, Salatiyêl yê Jorobabêl, ");
INSERT INTO kqp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabêl yê Abiyud, Abiyud yê Eliyakim, Eliyakim yê Ajôr, ");
INSERT INTO kqp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajôr yê Sadôk, Sadôk yê Akim, Akim yê Eliyud, ");
INSERT INTO kqp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud yê Eléyajar, Eléyajar yê Matan, Matan yê Jakwôb, ");
INSERT INTO kqp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakwôb yê Josêp woɲ ôbi kurô Mari to yê Jésu wo bay uwôgeri *Krist, kwo Emen dôri hen hen. ");
INSERT INTO kqp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ayiɲ tôri sa Abraham a kwôy saɲ sa kelma Dabid a na, na tô môɲ môj kibi pôrbu, men, hena sa kelma Dabid kwôy sa to bay pôrji lemnare hen na, na tô môɲ môj kibi pôrbu men, hena wulê wo bay pôrji lemnare Babilôn a hen kwôy saɲ sa Krist a na, na tô môɲ môj kibi pôrbu a men. ");
INSERT INTO kqp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na derêŋge kwôli yê wo bay yê Jésu Krist. Mari toɲ yori na, na hendi gusô Josêp, niɲba, bay yiɲ né tô, menba, hende yi kwoo naɲ néé wo Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josêp woɲ ôbi gusôre bi wo hen na, na gawra woɲ derôre, ôbi genge ɗiré kaɲêre jegê mera ɗiba ɗiré kelê kwôli ta bi tayre ré duru ré. ");
INSERT INTO kqp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kiriɲa ôbi erem bôri a hen iyôŋ ba ya tô, menba, *mana wo derômaraŋ a sa kôli bô wônê a iyôŋ ba: «Josêp kuŋga kelma Dabid, meremné ré, niɲba, ju bô Mari mega tamnem iyôŋ, ");
INSERT INTO kqp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","wôsa kwoo wo hende yi hen na, na naɲ néé wo Tunu toɲ hendi bô bôrê, aɲ hende a yê kema iba aɲ já uwôgeri Jésu, wôsa na ôbi a gôliɲ naɲ balêri sa têriɲ lêreji a hen.» ");
INSERT INTO kqp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Are bay ka hen yi hen iyôŋ bi kwôlo Emen na biɲ ôbi kibri na kôl hen na, ariri ré liɲ. Ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Môni temale a yé kwoo aɲ a yê kema iba aɲ bay a uwôgeri Emanuwêl.» Hini bi wo hen iyayriri na, «Emen naɲ na.» ");
INSERT INTO kqp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kiriɲa Josêp eŋgiɲ tô kum a menba, ôbi li mega bi wo mana wo Kelma kôli hen iyôŋ. Ôbi gô naɲ Mari. ");
INSERT INTO kqp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Niɲba, bay yiɲ né kwôy wo hende yêɲ kema iba aɲ ôbi uwôgeri Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bay yê Jésu Bêteléhêm môni iyére to bô emê wo Judé a, wulê bi wo hen a na, na *Hérôd a na na ôbi emê sa iyére. Kiriɲ bay ka hen na, bay henê are henaji si tô emen iyôŋ saji Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Menba, bay eŋgere iyôŋ ba: «Kelma wo Jubɲê wo bay yêri na ba, na si yôŋ ba? Wôsa nini gelo têbêŋne tori hena si tô emen iyôŋ aɲa niné era bi niné tibéri hen.» ");
INSERT INTO kqp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kiriɲa kelma Hérôd toy hen iyôŋ menba, ôbi sun men, ɓiɲé ka Jérusalêm a kêm kôba sun a men. ");
INSERT INTO kqp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Menba, ôbi dayrê damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen aɲ eŋgeriji iyôŋ ba: «Kiriɲ ka bay a yêɲ *Krist kwo Emen dôri hen ba na yôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Menba, bay uwôli sara iyôŋ ba: «Bay a yêri Bêteléhêm a emê wo Judé a wôsa *ôbi kibi Emen na kôl kwôli tumô kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Mini Bêteléhêm, to Judé perê iyére to damné kêm bô emê wo Juda a hen na, muna to ɗê ré, wôsa Kelma wo a derê tumô *Israyêl ɓiɲé kaɲê môɲ ôbi gemé gamgê iyôŋ hen na, a hena na bôrê a.› » ");
INSERT INTO kqp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Menba, Hérôd uwôga bay henê are bay ka hen naɲ ɲalê aɲ sa eŋgeriji bay ré kôli wulê têbêŋne ré siɲ ya hen. ");
INSERT INTO kqp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Menba, ôbi jéji Bêteléhêm a aɲ kôlji iyôŋ ba: «Erêŋge ken ô eŋgeré kiriɲ ka kema bi wo hen yiɲ ya hen, aɲ kiriɲa ken uɲari niɲ na, ken hera sa kôlen bi nôbi kôba na erê tibéri men.» ");
INSERT INTO kqp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiriɲa bay toy kwôlo ôbi kôlji hen iyôŋ niɲ menba, bay ôrji haji niɲ. Têbêŋne to bay ré gelore si tô emen hen na, dô tumôrji, menba, kiriɲa hende biɲ sa kiriɲ ka kema bi wo hen yiɲ ya hen menba, hende ɗebu tôŋ hare niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kiriɲa bay gel têbêŋne hende to hen iyôŋ menba, yirji dôrji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bay siji bô ira aɲ gelji kema bi wo hen naɲ yori Mari menba, bay cubu gubarji tôŋ tumôri a aɲ tibri men, bay tô magela woji nô aɲ biri aŋga gararji damaŋ damaŋ bay a na: lôr men, weŋ wo ɗiɲé dô wo bay uwôgeri peraŋkens hen men, kwoɲ hana wo bay uwôgeri *miir hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Menba, Emen kôliɲ bay henê are bay ka hen bô wônê a iyôŋ ba bay ré hôrji uɲé Hérôd ré menba, bay ré ay geré wo ɗaŋgi a ré hô iɲ. ");
INSERT INTO kqp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kiriɲa bay henê are bay ka hen ôrji ta niɲ menba, *mana wo derômaraŋ a wo Kelma si sa Josêp a naɲ wônê kôli iyôŋ ba: «Hena ta ay kema bi wo hen naɲ yori ju geriɲ ôriɲ Ejipt a aɲ ju môriɲ naɲ ɗi ya kwôy wo na kôlem dema jeré heraɲ naɲ ɗi tô, ré ba Hérôd woge geré ɗiré deréri.» ");
INSERT INTO kqp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Menba, Josêp hena naɲ yoyre hende to hen ay kema naɲ yori geriɲ ôriɲ Ejipt a. ");
INSERT INTO kqp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ôbi mô ya hende to hen kwôy wo Hérôd maɲ. Are bay ka hen yi hen iyôŋ mega kwôlo Kelma na biɲ ôbi kibri na kôl tumô kôl iyôŋ ba: «En uwôge Keman ré so aɲ Ejipt a niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kiriɲa Hérôd hôn wo bay henê are ré lamni na lamê menba, bôri tari damaŋ aɲ ôbi ay tôô bi bay ré duu kamrê kaɲ imɲê ayiɲ tôri sa ka bay yê haw a kwôy ɗi sa ka elêrji wôô wôô a ka sa iyé Bêteléhêm a men, ka sa kam iyére to méére ta hen a men. Ôbi li hen iyôŋ wô kwôlo bay henê are na kôli gengiɲ sa wulê wo têbêŋne ré siɲ. Ayiɲ tôri wulê bi wo hen kwôy saɲ sa wulê wo bay deriɲ kamrê hen na, li elê wôô ré tô. ");
INSERT INTO kqp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na ôbi á, are bay ka hen ré biɲ naɲ kwôlo ôbi kibi Emen Jérémi na kôl hen: ");
INSERT INTO kqp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Sômê ôm gôr kiriɲ Rama a, Rasêl sôm wô kamne, aɲ bay waare kôba hende toy ré wô kamne ka bay duu kêm hen.» ");
INSERT INTO kqp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kiriɲa Hérôd ma niɲ menba, *mana wo derômaraŋ a wo Kelma si sa Josêp a Ejipt a naɲ wônê aɲ ");
INSERT INTO kqp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kôli iyôŋ ba: «Hena ta ju ay kema naɲ yori ju heraɲ naɲ ci sa iyé Israyêl a wôsa ka na woge ciré deréri hen na, maji niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Menba, Josêp hena ay kema naɲ yori heraɲ sa iyé Israyêl a. ");
INSERT INTO kqp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Niɲba, kiriɲa ôbi toy wo ré na Arkélawus a ré na kelma wo Judé hôlmê ibari Hérôd a na, ôbi kemna herê ô merê bô emê wo Judé a. Menba, Emen yêge mari bô wônê a menba, ôbi ô bô emê wo Galilé a. ");
INSERT INTO kqp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aɲ ô merê sa iyé Najarêt a. Yi hen iyôŋ bi ré biɲ naɲ kwôlo *ôbi kibi Emen na kôl iyôŋ ba: «Bay a uwôgeri kema Najarêt hen.» ");
INSERT INTO kqp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wulê bi wo hen na, Ja ôbi lê batêm so derô gwôlê wo Judé aɲ uwôl béré kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Beléŋge cêgerŋge biɲ têriɲ toŋge wôsa *emê iyére to derômaraŋ a ba ɗa niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na Ja bi a *ôbi kibi Emen *Esay na ré kôl kwôli kôl iyôŋ ba: «Na tôô gawra wo ôm derô gwôlê kôl iyôŋ ba: ‹Ɲanêŋge geré wo Kelma men, ɲanêŋge kam geré kari bi ô derôre a men.› » ");
INSERT INTO kqp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja tôbe bargay ka bay li naɲ gusiri jambal men, ôbi ha tô bôri naɲ ariɲ a men. Ari emêri na céré men, timne men. ");
INSERT INTO kqp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓiɲé kêm ôrji sa pôn pôn ligiri a: ka Jérusalêm men, ka Judé men, ka kam iyére to mér sa cér wo Jurdê ta hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ɓiɲé bay ka hen tô tô têriɲ toji ta aɲ ôbi liji batêm bô cér wo Jurdê bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kiriɲa Ja gel Parisiɲêɲê naɲ *Sadusiɲêɲê kwône era ligiri a bi ɗiré liji batêm, menba, ôbi kôlji iyôŋ ba: «Kenbay ka ken yi môɲ jênêre iyôŋ hen, na i a geléŋge bi kené geriɲ uwoŋge wo Emen wo a era hen ba? ");
INSERT INTO kqp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iyôŋ ba, bi jé lêreŋge gel wo kené bul cêgerŋge biɲ têriɲ toŋge niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɗiba ken mô wô kelê ‹*Abraham na ibarni, Abraham na ibarni› mera ré, wôsa en kelêŋge jerew wo yi hen na, Emen a nêmê belé liɲ kamrê biɲ Abraham. ");
INSERT INTO kqp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Haw hen na, tigre yi tô gurô pôn pôn niɲ aɲ gurô wo yôŋ yôŋ wo yêri dô ré ba a diɲ jôriɲ aɲ uwôliɲ tare a. ");
INSERT INTO kqp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nôbi ba, en lêŋge batêm na naɲ kam gengiɲ sa belé wo kené bul cêgerŋge biɲ têriɲ toŋge hen, niɲba, kwo a era cêgena hen na, ôbi a lêŋge tori naɲ Tunu toɲ hendi bô bôrê men, naɲ tare a men, wôsa nééri gôliɲ kuɲê men, en nêm terê garbê kaɲ têri ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Men, ôbi ôriɲ naɲ gwore tori toɲ péé kaw wô labiɲ kiriɲ kaɲ péé kaw ya aɲ ôbi a péé kaw kari bay ka hen aɲ a perê gusiɲniji bê a bô béér a a men. Menba, kurmérji ba ôbi a uwoyé aɲ bô tare to eŋge bariɲ né yôd hen.» ");
INSERT INTO kqp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na ôbi á, Jésu ré hena Galilé ô ligi Ja kibi cér wo Jurdê a bi ré liri batêm men hen. ");
INSERT INTO kqp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ja li ɗa kaɲê aɲ kôliɲ Jésu iyôŋ ba: «Nôbi a ré erê bi jeré lên batêm, menba, li iyeŋ a jôbi jeré hô era bi ené lêm batêm ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Menba, Jésu uwôli sara iyôŋ ba: «Kwo haw hen ba en gey bi ré yi hen iyôŋ hari, na hen iyôŋ a nana liɲ aŋga Emen gey hen.» Menba, Ja gey naɲ ɗi aɲ liri batêm. ");
INSERT INTO kqp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kiriɲa Ja liɲ Jésu batêm aɲ ôbi so bô kam a niɲ na, kiriɲ bay ka hen derômaraŋ bôliɲ aɲ ôbi gel Tunu toɲ hendi bô bôrê herbo mega derare iyôŋ sari a. ");
INSERT INTO kqp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Menba, tô kwôni ema derômaraŋ a kôl iyôŋ ba: «Kwo ɗebu na na, na Keman, en piri damaŋ. Men, en li yi derê wô sari damaŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kiriɲa ôbi so bô kam a niɲ menba, Tunu toɲ hendi bô bôrê ôriɲ naɲ ɗi derô gwôlê bi Sidan ré ô séléri. ");
INSERT INTO kqp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lê wo Jésu li wulê tôre pôrbu yoyre naɲ tu tare baa emê ani hen na, kurôŋ liri. ");
INSERT INTO kqp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Menba, Sidan era ligiri a aɲ kôli iyôŋ ba: «Hena jeré na Kema Emen ba ju bi jerew wo yi na bi biliɲ kwô bem ju ôm.» ");
INSERT INTO kqp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Menba, Jésu uwôli sara iyôŋ ba: «Liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Na kwô mera a gawra ré emê gôliɲ né niɲba, kwôlo si kibi Emen a gawra ré môriɲ geɲ ɗi.› » ");
INSERT INTO kqp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Menba, Sidan hô ôriɲ naɲ ɗi Jérusalêm iyére to yi naɲ jeŋgêre a hen aɲ ôriɲ naɲ ɗi ô ɗiri ta yeŋ sa *iyéy Emen a, ");
INSERT INTO kqp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","aɲ kôli iyôŋ ba: «Hena jeré na Kema Emen tiri ba ju deraɲ kuriɲ tôŋ na gelé wôsa na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Ôbi a ayê tôô biɲ *manê ka derômaraŋ a gengiɲ sam› men, ‹Bay a ayem kôbriji a bi têm ré di keram wôni ré.› » ");
INSERT INTO kqp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jésu hô uwôli sara kôl iyôŋ ba: «Magtubu hende to hen kôba hô kôl iyôŋ ba: ‹Kelma Emen wom na, já séléri ré.› » ");
INSERT INTO kqp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Menba, Sidan hô ôriɲ naɲ ɗi sa keram wo yêŋgi a aɲ gili emê iyére to sa terare a na naɲ aŋga dôri dôri ka yi ya. ");
INSERT INTO kqp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aɲ ôbi kôliɲ Jésu iyôŋ ba: «Hena jeré jubu gubam tumôn a aɲ teben ba na bem are bay ka kêm ka ju gel hen.» ");
INSERT INTO kqp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Menba, Jésu ône Sidan aɲ kôli iyôŋ ba: «Sidan, erêɲ wôsa liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Kelma woɲ Emen wom pôn nêŋ hari a jeré jebé gubam tumôri a men, na ôbi a jeré tibéri a men.› » ");
INSERT INTO kqp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kiriɲ bay ka hen menba, Sidan erêɲ ɗiri hari niɲ, menba, manê ka derômaraŋ a era ligi Jésu a aɲ biri aŋgaɲ emê. ");
INSERT INTO kqp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bay ɓu Ja uwôl daŋgay a. Kiriɲa Jésu toy wo bay ré ɓu Ja hen iyôŋ menba, ôbi hena ô Galilé. ");
INSERT INTO kqp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ôbi ɗi sa iyére tori to Najarêt hen aɲ ô merê Kapêrnayôm kibi cér wo bô emê wo Jabulôn naɲ kwo Nêptali a. ");
INSERT INTO kqp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ôbi li hen iyôŋ bi ré biɲ naɲ kwôlo *ôbi kibi Emen *Esay na kôl kwôli tumô kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Terare to Jabulôn naɲ to Nêptali, To yi si kwa cér wo dami, si cêgi Jurdê hen, Na hende to ɓiɲé ka na Jubɲê ré hen mô ya hen. ");
INSERT INTO kqp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɓiɲé ka na mô bô kiriɲ ka hendi a hen na, haw hen bay gel kiriɲ ka peraŋgi ka dami men, ka yi môɲ ciré ma iyôŋ gengiɲ sa tiniji hen kôba bay gel kiriɲ ka peraŋgi a men.» ");
INSERT INTO kqp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Menba, Jésu ay tô derêji kwôlê kôl iyôŋ ba: «Beléŋge cêgerŋge biɲ têriɲ toŋge wôsa *emê iyére to derômaraŋ a era ɗa hen ya niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jésu ô têm têm kibi cér wo Galilé a, menba, ôbi gel gawrê wôô tô yêniɲare a ka na bay uré, bay a na si Simô wo bay uwôgeri Piyêr hen, naɲ yêni André, bay urji kuyê naɲ bera. ");
INSERT INTO kqp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Menba, Jésu kôlji iyôŋ ba: «Eraŋge tôn a aɲ na béŋge ken yi bay uré ɓiɲé ben.» ");
INSERT INTO kqp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Menba, kiriɲ bay ka hen na, bay ɗéɲ bera toji aɲ, aɲ ôrji tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ôbi ô sem, menba, ôbi hô gel gawrê wôô tô yêniɲare a, na si *Jak naɲ yêni Ja kaɲ kami gawra wo bay uwôgeri Jébédé hen, bay môrji bô bato a naɲ ibarji ɲanji bera toji menba, Jésu uwôgeji menba, ");
INSERT INTO kqp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kiriɲ bay ka hen na, bay ɗi ibarji naɲ bato aɲ ôrji tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jésu gôr bô emê wo Galilé hen kêm aɲ giliɲ ɓiɲé are bô *iyéy daɲare a men, dô Kwôlo Dôri wo gengiɲ sa emê iyére to derômaraŋ a men, berare ɓiɲé kêm ka ômɲare to gay gay liji hen men, berare bay merayê ka gay gay a men. ");
INSERT INTO kqp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kwôli Jésu ôm gôr bô emê wo Siri a kêm aɲ li wo bay eraɲ naɲ bay ômɲare to gay gay men, ka tunu to habiɲ yi bôrji a men, bay gesemem men, bay merayê a men bi ôbi ré berareji. ");
INSERT INTO kqp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Menba, kwônê ɓiɲé ka hena Galilé men, ka hena emê iyére to tôre môj hen men, ka hena Jérusalêm a men, ka hena Judé naɲ kam iyére kêm ka yi si cêgi cér wo Jurdê a hen a men ôrji tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kiriɲa Jésu gel kwônê ɓiɲé bay ka hen era ligiri a menba, ôbi ɗay ô merê sa keram a menba, bay tôri era ligiri a ");
INSERT INTO kqp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","menba, ôbi ay tô derêji kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ɓiɲé ka erem wo ciré nêm lê ani sa kibriji ré hen na, yirji a sa dôrji wôsa *emê iyére to derômaraŋ a na toji. ");
INSERT INTO kqp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɓiɲé ka mô naɲ bô emê haw hen na, yirji a sa dôrji wôsa Emen a sa jalê bôrji. ");
INSERT INTO kqp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɓiɲé ka kalêrji jal hen na, yirji a sa dôrji wôsa bay a merê derê sa terare a na sem. ");
INSERT INTO kqp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɓiɲé ka doy lê aŋgaɲ derôre liji damaŋ hen na, yirji a sa dôrji wôsa Emen a sa biji aŋga bay ôriɲ doyriji bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɓiɲé ka bô tu ɲa to megêrji hen na, yirji a sa dôrji wôsa Emen a sa berê tu ɲa toji men. ");
INSERT INTO kqp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɓiɲé kaɲ bay bô bôrê hen na, yirji a sa dôrji wôsa bay a sa gelé tu Emen. ");
INSERT INTO kqp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓiɲé kaɲ bay ɲanê megêrji bi ré biɲ pôn hen na, yirji a sa dôrji wôsa bay a uwôgêji kam Emen. ");
INSERT INTO kqp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɓiɲé ka bay gelji gusiɲ wô kibi aŋgaɲ derôre ka bay li hen na, yirji a sa dôrji wôsa emê iyére to derômaraŋ a na toji. ");
INSERT INTO kqp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Hena bay ré tiréŋge men, geléŋge gusiɲ men, pôy kwôlo gay gay ɗéŋge sarŋge a wô wo kené na bay tôn na, ");
INSERT INTO kqp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","sêŋge peré men, ken li yi derê a men wôsa ka uɲé sa kôbreŋge damaŋ derômaraŋ wôsa na hen iyôŋ a bay na ré geliɲ tu bay kibi Emen ka tumô gusiɲ men hen.» ");
INSERT INTO kqp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Kenbay kena ɗôre to ɓiɲé ka sa terare a na, a hena ɗôre hende to hen ré geraŋ ré ba bay a lere iyeŋ a ré herê geraŋgê hôriɲ ba? Ani ka kwôni a liɲ naɲ tu ba naɲ niɲ. Bêre aɲ bi ɓiɲé ré ɗiirê naɲ têrji a ba mera. ");
INSERT INTO kqp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kenbay kena kiriɲ ka peraŋgi ka ɓiɲé ka sa terare a na, wôsa hena kwôni ré ɗi iyére tori sa keram a ba ôbi a uwôbêre nêmê sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Men kwôni a ɗé tare bô lampa aɲ erê uwôbê bô gwore a sôŋ ba? Hena tare ré ɗiɲ bô lampa a ba na wô teré ta gurô pal a aɲ bi ré berare kiriɲ bi ɓiɲé ka mô bô ira hen kêm ré geliɲ kiriɲ. ");
INSERT INTO kqp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iyôŋ ba, kenbay kôba ken bi kiriɲ ka peraŋgi kaŋge peraŋge bi ɓiɲé geliɲ kiriɲ dema bay ré geliɲ jé lêreŋge wo dôri menba, bay a ayiɲ kibi Ibareŋge Emen wo mô derômaraŋ a hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ma ka ermé yaŋ ba ené era na wô mênê tôô naɲ kwôlo bay kibi Emen na kôl hen niɲba, en era na wô lê bi aririrji ré liɲ ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Menba, Jésu hô kôl iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen hena derômaraŋ naɲ sa terare ré yi ba ya tô na, ani ka tôô ka dê iyôŋ ley, kam aŋga cibiɲ dê dê sara hen ley, ka a dôriɲ aɲ ba naɲ kwôy wo sa terare a mêniɲ. ");
INSERT INTO kqp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na ôbi á, kwôni wo ré ɗage tôô to dê dê hende to hen aɲ geliɲ ɓiɲé ré ɗage hen iyôŋ a men na, ôbi a yé kema wo dê bô iyére to derômaraŋ a. Niɲba, hena kwôni ré bi kwôlê sa tôô hende to hen aɲ geliɲ ɓiɲé ré li hen iyôŋ a men na, ôbi a yé kwo dami bô emê iyére to derômaraŋ a a. ");
INSERT INTO kqp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","En kelêŋge waŋ ta, hena kené li aŋgaɲ derôre ɗê ka bay derê tô tôô to Emen naɲ ka Parisiɲêɲê ré ba ka nêmê sé bô emê iyére to derômaraŋ a ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Na ken toy kwôlo bay na kôliɲ môɲêrŋge iyôŋ ba: ‹Já deré gawra ré wôsa kwôni wo duu megari ba, bay a jerê kwôlê sari a.› ");
INSERT INTO kqp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Niɲba, nôbi en kelêŋge, kwôni wo bôri tari sa yêni a ba, bay a jerê kwôlê sari a men, kwo tôbiɲ yêni galê ba, bay a ôriɲ naɲ ɗi tumô bay jerê kwôlê ka damné a men, kwo tiiré yêni ré yêmiɲ ba, a erê bô tare to eŋge bariɲ né hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Hena jeré ô jeré erê biɲ Emen aŋgaɲ baliyare kini bê kwôbe a aɲa jeré erem si sa kwôlo yênem ôriɲ naɲ ju na, ");
INSERT INTO kqp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ju ɗi aŋgam kaɲ baliyare bay ka hen tôŋ jan aɲ ju ô uɲé yênem ken ô biɲ tôŋ pa dema, jeré hera sa ay aŋgam bay ka hen biɲ Emen tô. ");
INSERT INTO kqp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hena ôbi barem ré kaŋgem aɲa kené ô ɓem kini jerê kwôlê na, ken ɲan kwôlê woŋge naɲ ɗi ca tumô geré ré ba ôbi a uwôlem kôbi ôbi jerê kwôlê a aɲ ôbi jerê kwôlê bi wo hen a ôriɲ naɲ ju biɲ asgarɲê aɲ iyeŋ né ba bay uwôlem daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","En kôlem, já têbê kerê iyôŋ iyôŋ dema jeré sé daŋgay a tô.» ");
INSERT INTO kqp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Na ken toy bay na kelêŋge tumô kôl iyôŋ ba: ‹Já wogé tam megam né.› ");
INSERT INTO kqp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Niɲba, nôbi en kelêŋge waŋ a ta: kwôni wo bô tami megari naɲ tu bôriyare na, bôri a ba ôbi yiɲ naɲ tu niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hena ré na tum toɲ gusurô a lê aɲa jeré li têriɲ na, ju dôre uléɲ kelaŋ naɲ ju, ju meray a jeré uwôɲ gelê ba dô ɗê erê bô *géhên a naɲ tum wôô kêm. ");
INSERT INTO kqp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A hena ré na kôm woɲ gusurô a lê aɲa jeré li têriɲ na, ju wali uléɲ kelaŋ naɲ ju, ju meray a jeré gôl ba dô ɗê erê bô géhên a naɲ kôm wôô kêm.» ");
INSERT INTO kqp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Bay na kôl tumô kôl iyôŋ ba: ‹Kwôni wo dage tamni ba bi ré bure magtubu toɲ bê tôre kôbre a.› ");
INSERT INTO kqp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Niɲba, nôbi en kelêŋge hena kwôni ré dage tamni to yiɲ na kwôni ré tô aɲa hende ré ô eŋgé iba wo ɗaŋgi na, na ôbi lere aɲa hende ré wôniɲ wôniɲare toɲ têriɲ hen men, kwôni wo eŋge iyore to bay dagere hen kôba li na têriɲ naɲ tu a men.» ");
INSERT INTO kqp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Na ken toy kwôlo bay na kôliɲ môɲêrna ka tumô iyôŋ ba: ‹Aŋga ju dusu yem sara ba ju ɗi baa ré. Niɲba, ka ju ay tôm sara naɲ hini Kelma ba, ju li môj môj.› ");
INSERT INTO kqp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Niɲba, nôbi en kelêŋge bi kwôni dusu yiri ré. Bi ôbi dusu yiri naɲ derômaraŋ ré wôsa na kini merê Emen men, ");
INSERT INTO kqp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bi kwôni dusu yiri naɲ sa terare ré wôsa na kini sêlê tê Emen men, naɲ Jérusalêm ré wôsa hende na iyére to Kelma wo dami men, ");
INSERT INTO kqp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","bi kwôni dusu yiri naɲ sam né wôsa ju nêm lê bi ré béé ré men, bi ré hendu ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Niɲba, hena kwôlê woŋge ré na tiri ba ken kôl ré na tiri men, hena ré na tiri ré ba ken kôl ré na tiri ré aɲ kwo ka kelê cêgê hen na, hena na ligi Sidan.» ");
INSERT INTO kqp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Na ken toy bay na kôl tumô iyôŋ ba: ‹Tu ba, na tu hôriɲ men, kaɲnem ba, na kaɲnem hôriɲ men.› ");
INSERT INTO kqp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Niɲba, nôbi en kelêŋge iyôŋ ba: Dêŋge bayi habrê wo kwôni lêŋge hen né, hena kwôni ré di tô mam woɲ gusurô ba ju bul kwoɲ ma biri di a. ");
INSERT INTO kqp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A hena kwôni ré kaŋgem tumô bay jerê kwôlê a wô eŋgiɲ bargay kam kaɲ kabrêm na, ju jôri derê kaɲ kelanê a ré. ");
INSERT INTO kqp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Men, hena ôbi néé wôni ré ɓerem ereŋ jeré ayri ani ôriɲ naɲ ɗi kelaŋ nêm têê dubu ba ju ôriɲ naɲ ɗi têê dubu sara. ");
INSERT INTO kqp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kwo uwôlem are ba ju biri men, hena ôbi ré gey jeré gwôyri ani kôba ju jôri ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na ken toy bay na kôl iyôŋ ba: ‹Yênem ba, jeré piri niɲba, ôbi barem ba jeré dôri ham.› ");
INSERT INTO kqp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Niɲba, nôbi en kelêŋge bay bareŋge kôba ken pirji men, ken uwôl Emen wô sa ka geliɲ turŋge gusiɲ hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hen iyôŋ dema kené yiɲ kami Ibareŋge Emen wo mô derômaraŋ a wo bi tare tori berare sa bay bô habrê a men, sa bay lê derê a hen a men hen. Men, ôbi bi emen uwôŋge sa bay lê aŋgaɲ derôre a men, sa bay lê aŋgaɲ derôre ré hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hena kené pur na ɓiɲé ka peréŋge hen mera ba wô mi a kené mô gem sa kôbi wo Emen ba? ");
INSERT INTO kqp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wôsa *bay eŋgé wôgê kôba li na hen iyôŋ hende to hen men, hena ré na yênêrŋge dema kené liji dosé mera ba na aŋga ɗê kiriɲ a kené li hen ba? Ɓiɲé ka hôn Emen né kôba li na hen iyôŋ men ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Derêŋge cerêd mega Ibareŋge wo derômaraŋ a dôriɲ cerêd hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Berêŋge dô wô wo ma kena gelé derê woŋge tu ɓiɲé, hena kené li hen iyôŋ ba ka uɲé sa kôbreŋge ligi Ibareŋge wo mô derômaraŋ a hen né. ");
INSERT INTO kqp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kiriɲa jera ɓeré baliyare naɲ bay nimré na, bi yilé ôm sara môɲ kwo bay gelé yirji tu ɓiɲé a lêrê bô *iyéy daɲare a men, tô geré a men hen iyôŋ né. Bay li hen iyôŋ bi ɓiɲé ré heramiji. En kelêŋge na tu kwôlê bay uwôɲ sa kôbriji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Niɲba, jôbi na, kiriɲa ju gey ɓeré baliyare naɲ bay nimré na, ju li bi megam hôn né. ");
INSERT INTO kqp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aɲ aŋgaɲ baliyare bay ka hen bi yi kini uwôbêrji a aɲ ibam Emen wo gel aŋga ju li jegê hen a sa têbem sa kôm tô.» ");
INSERT INTO kqp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Kiriɲa ken uwôl Emen na, ken li mega kwo bay gelé yirji tu ɓiɲé li hen iyôŋ né, wôsa bay gey uwôlê Emen ɗibiɲ ta bô iyéy daɲare a men, jêrê geré a men, bi ɓiɲé ré gelji. Ôbi a ené kelêŋge bay uwôɲ aŋgaɲ sa kôbriji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Niɲba, jôbi ba, kiriɲa ju uwôl Emen ba, ju si bô iyére tom a aɲ ju lugu kermiɲ sam a aɲ ju uwôl ibam wo mô kiriɲ ka yi naɲ kini uwôbêrji hen, aɲ ôbi wo gel aŋga ju li jigê hen a bem arirji. ");
INSERT INTO kqp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kiriɲa ken uwôl Emen ba ken deŋsêrê kwôlo kwôni môɲ kwo bay henê Emen né lêrê hen iyôŋ né, wôsa bay erem iyôŋ ba yaŋ ba kelê wo ciré kôl damaŋ hen iyôŋ a Emen né toyé lew. ");
INSERT INTO kqp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niɲba, kenbay ba, ken li môɲ kwo bay li hen iyôŋ né. Wôsa Ibareŋge Emen na, hôn aŋga ken gey hen tumô niɲ dema kené eŋgeriri hen tô. ");
INSERT INTO kqp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kiriɲa ken gey uwôlê Emen ba ken kôl iyôŋ ba: ‹Ibarni wo derômaraŋ a bi ɓiɲé kêm hôn wo jeré yi naɲ jeŋgêrem men, ");
INSERT INTO kqp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","bi emê iyére tom era men, bi nibay ka sa terare a na nini li bô geyé wom mega wo ka derômaraŋ a liɲ hen iyôŋ men, ");
INSERT INTO kqp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","béni aŋgaɲ emê ka nini ôriɲ doyriji kemnêŋ hen men. ");
INSERT INTO kqp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɗi bôm jal sa habrê woni a mega wo nibay kôba nini ɗiɲ bôrni jal sa ka lêni habrê a hen iyôŋ men, ");
INSERT INTO kqp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Geméni aɲ ju bi bi niné heriɲ bô aŋga séléni hen ré, niɲba, ju derêni kibi habrê a. Wôsa na jôbi a na ôbi emê iyére men, ju na ôbi ibé iyêrê a men, wôsa ayê kibi na yi wô sam kwôy naɲ kwini a men. *Amên, bi yi geliɲ hen iyôŋ.› ");
INSERT INTO kqp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","En kelêŋge, hena kené ɗi bôrŋge jal sa habrê wo megêrŋge lêŋge a hen na, Ibareŋge wo mô derômaraŋ a kôba a ɗé bôri jalê sarŋge a men. ");
INSERT INTO kqp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Men, hena kené ɗi bôrŋge jal sa habrê wo megêrŋge a ré ba, Ibareŋge wo mô derômaraŋ a a ɗé bôri jalê sarŋge a ré hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Hena kené jô yerŋge sa emê a ba, ken li ɲa mega wo bay henêre Emen né liɲ hen iyôŋ né, bay sêmnê hen iyôŋ bi ɓiɲé ré gel wo ciré jô yirji sa emê a, iyôŋ ba, na tu kwôlê a ené kelêŋge hen, yi mega wo bay ré uwôɲ sa kôbriji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Niɲba, jôbi ba kiriɲa ju jô yem sa emê na, ju pul tum men, ju surge sam a men ");
INSERT INTO kqp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ɗiba bi ɓiɲé hôn wo jeré jô yem sa emê a hen ya ré. Aɲ Ibam wo hôn aŋga yi kini uwôbêrji a hen bi ôbi pôn nêŋ ré hôn aŋga ju li jigê hen aɲ bi bem arirji.» ");
INSERT INTO kqp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Dayrêŋge aŋgaɲ uɲé ka sa terare a na ré wôsa na kiriɲ ka téére naɲ gur ɓu are ya men, gemsê kôba pôy kibi iyére gômsiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Niɲba, ken dayrê aŋgaɲ uɲé ka derômaraŋ a ka téére naɲ gur a mênê ré hen men, na kiriɲ ka gemsê a nêmê piyê kibi iyére ré men, a gemsê are ya ré hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wôsa kiriɲ ka cirarem yiɲ ya na, na kiriɲ bay ka hen a ermé wom kôba ré yé ya men.» ");
INSERT INTO kqp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Tum a na lampa to yem, hena tum né dô ba, yem kêm kôba peraŋge men. ");
INSERT INTO kqp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A hena tum né meray ba, yem kêm kôba kiriɲ hendu sari a men, a hena kiriɲ ka peraŋgi ka yi yem a ré hendu a sôŋ ba, kiriɲ a hendé na culum sa yem a.» ");
INSERT INTO kqp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Gawra pôn nêŋ a lê jé biɲ bay iyéyri wôô ré: dô ré ba ôbi a tôrɲê kwo pôn aɲ periɲ kwo pôni, réba a ɗé yiri yi kwo pôni a aɲ kaɲê kwo pôni. Ka nêmê lê jé biɲ Emen men, yé limé ka gursu a men né.» ");
INSERT INTO kqp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Geléŋge, na ôbi a, ené kelêŋge kené sun wô aŋga kené emê gôliɲ ré men wô aŋga kené tôbê yerŋge a ré men. Wôsa merê tu geɲ na gôliɲ aŋgaɲ emê men, yi gôliɲ bargay a men ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Erméŋge sa ciré ka uwôŋge ta a hen ken gel, bay ci kaw kani ré men, bay wal kaw kani bi a bô béér a ré a men, niɲba, na Ibareŋge wo mô derômaraŋ a hen a biji aŋgaɲ emêrji. A hena ré na hen iyôŋ ba, kenbay ba ken dô ɗê ciré bay ka hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Perêrŋge a hen i a nêmê ulê wulê pôn a sa megari a wô wo ɗiré sun gaɲ ba? ");
INSERT INTO kqp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A hen iyôŋ ba, ken eremnéré sa bargay ka kené tôbê a ré. Kebêŋge sa gesela wo miirê bô yagê a hen ken gel bay li jé ré men, bay li bargay kani ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Niɲba, en kelêŋge, kelma Salomôn naɲ hini emê wori hen kôba na tôbe bargay ɗê kwo pôni wôni perêrji a hen né tô. ");
INSERT INTO kqp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hena kalmê ka nono ka kemnêŋ yi hen aɲ kiya bay a uwoyé aɲ hen kôba Emen tôbiji bargay yirji a men na, kenbay dema ôbi ré lê are béŋge ré ba? Ayi! gawrê ka ayê bôô woji naɲ hen. ");
INSERT INTO kqp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hen na, ken kôl iyôŋ ba: na mi a niné emê ba ré men, na mi a niné yê ba ré men, na mi a niné tôbê ba ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Are bay ka kêm hen na, bay henê Emen né a wogéji yôd yôd merênê liji tô ré hen ɗiba kenbay ba, Ibareŋge wo mô derômaraŋ a hôn aŋga ken ôriɲ doyriji hen. ");
INSERT INTO kqp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iyôŋ ba, ken woge *emê iyére to derômaraŋ a naɲ lê aŋgaɲ derôre kari pa tumô menba, are bay ka kêm hen ôbi a béŋge a sara. ");
INSERT INTO kqp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sunéŋge sa wulê wo kiyay a ré, wôsa kiya môriɲ naɲ kwôli bôri a. Ken gel, wulê wo yôŋ yôŋ kôba naɲ gusiɲ tori tori.» ");
INSERT INTO kqp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Jerêŋge kwôlê sa megêrŋge a ré, menba, Emen kôba a jerê kwôlê sarŋge a ré men. ");
INSERT INTO kqp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wôsa Emen a jerê kwôlê sarŋge a mega wo ken jôriɲ sa megêrŋge a hen iyôŋ men. Gway wo ken ay gengiɲ are bi hen a, Emen né gengiɲ béŋge hôriɲ. ");
INSERT INTO kqp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wô mi a jeré ô wô berê kalmê ka dê ka yi tu yênem a hen ba? A yibré wo dami ka yi tum a hen ba ju gel ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hen ba já lê iyeŋ a jeré kôliɲ yênem: ‹Ben na dôrem sa kalmê ka yi tum a hen› menba, jôbi ba na yibré gurô yôd a yé tum a hen men ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jôbi woɲ ôbi kelê kwôlê kem wôô wôô hen, dô yibré gurô wo tum a hen aɲ dema jeré geliɲ kiriɲ sélé a jeré dôriɲ kalmê ka yi tô tu yênem a hen tô. ");
INSERT INTO kqp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Aŋga yi naɲ jeŋgêrji na, ken biɲ garê ré wô wo bay maa bulo aɲ gidéréŋge men, mériɲ woŋge kôba ken bi tumô gwôsiɲô a ré men, wô wo bay maa ɗiirê naɲ têrji.» ");
INSERT INTO kqp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Eŋgeréŋge menba, bay a béŋge, wogéŋge menba, ka uɲé, dêŋge kibi iyére menba, bay a belê béŋge. ");
INSERT INTO kqp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wôsa kwôni wo eŋgere ba bay a biri, men, kwo woge ba a uɲé men, kwo di kibi kermiɲ ba bay a belê biri men. ");
INSERT INTO kqp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Perêrŋge a hen kwôni wo kemari eŋgeriri kwô menba, a ayê keram biri hen ya ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Réba eŋgereri kuyê menba, a ayê kalaw biri hen ya ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kenbay kaɲ bay bô habrê ka ken hôn biɲ kamneŋge aŋga dôri dôri hen ba, Ibareŋge wo mô derômaraŋ a hen dema ré biɲ ka uwôli are hen ka dôri ɗê aɲ ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Are kêm ka ken gey bi megêrŋge ré li béŋge hen na, kenbay kôba ken li hen iyôŋ biji hen iyôŋ men, wôsa tôô to *Moyis naɲ kwôlo bay kibi Emen na kôl na hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Séŋge si kibi geré wo yêêri hen ɗi, wôsa kibi geré wo woli na, wol beŋ beŋ dô hari niɲba, na geré wo ô na kini mênê. Aɲ ɓiɲé kwône ô si ya. ");
INSERT INTO kqp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Niɲba, kibi geré wo iyêrmiɲ na, séri dôy men, kiriɲ kôba yêr a men hari, niɲba, kwôni ô si ya ba, a gelê. Aɲ ɓiɲé ka si si ya ba, na côb iyôŋ mera.» ");
INSERT INTO kqp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Berêŋge bay kibi Emen kaɲ bay benare hen dô wôsa bay tôba na ariɲ gamgê a ré eraɲ yerŋge a niɲba, bôrji na bô heŋ. ");
INSERT INTO kqp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aɲ na sa kibi jé lêreji a kené hôniɲji. Kwôni a kaarê yê tiɲaɗor sa cébriɲ a sa pôn ba? Laba kwôni a kaarê yê tôgôre sa gaara a sa pôn ken gel ba? ");
INSERT INTO kqp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gurô wo lêri ba yêri lêre men, kwo ɗaɲi ba yêri ɗaɲ men. ");
INSERT INTO kqp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gurô wo dôri a yê kwo habiɲ né men, kwo habiɲ a yê kwo dôri ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gurô wo yôŋ yôŋ wo yêri habiɲ ba, bay a dêri jerê ulê bô tare a. ");
INSERT INTO kqp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na hen iyôŋ a kené hôniɲ bay kibi Emen kaɲ bay benare bay ka hen sa kibi jé lêreji a hen.» ");
INSERT INTO kqp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ɓiɲé ka uwôgeren ‹Kelma, Kelma› hen a sé bô *emê iyére to derômaraŋ a kêm né niɲba, na ka li bô geyé wo Iban wo derômaraŋ a hen a sé bô a ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ôbi a Wulê woɲ jerê kwôlê a na, ɓiɲé kwône a kelê iyôŋ ba: ‹Kelma, na nini dôriɲ ɓiɲé kwôlo Emen naɲ henem ré ba? Na nini dage tunu to habiɲ sa ɓiɲé ka pôni a naɲ henem ré ba? Men, na nini li giɲê wo gay gay hen naɲ henem a men ré ba?› ");
INSERT INTO kqp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Menba, na sa kôlji iyôŋ ba: ‹Erêŋge yeŋ, en henêŋge ré men, tun kôba na kuriɲ sarŋge a dê iyôŋ ré kwôy a men, wôsa na kena bay lê têriɲ.› » ");
INSERT INTO kqp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Na ôbi á, kwôni wo ré toy kwôlê wo en kôl hen aɲ liɲ ariri a men na, yi mega ôbi ré erem kwôlê wô ɗé tô iyére tori sa keram a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Emen uwôŋge aɲ kam bôy tô iyére hende to hen a men, kal ge naɲ néri sa iyére hende to hen a men, niɲba, hende kuriɲ né wôsa tôre ɗiɲ na sa keram a. ");
INSERT INTO kqp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Niɲba, kwo toy kwôlê wo en dô hen aɲ liɲ ariri ré na, yi mega kubera wo ɗi tô iyére tori sa hal a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Emen uwôŋge aɲ kam bôy tôre a men, kal ge naɲ néri a men menba, hende tiɲ kerôm kerôm wôsa tôre na ɗiɲ na sa hal a.» ");
INSERT INTO kqp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kiriɲa Jésu gel kwôlê bi wo hen iyôŋ kô niɲ na, kwônê ɓiɲé ka mô ya hen tiniji ge kay sa derê kwôlê wori bi wo hen ");
INSERT INTO kqp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","wôsa ôbi dô na mega *bay derê tô tôô to Emen dôôriɲ hen iyôŋ né. ");
INSERT INTO kqp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jésu herbo sa keram a menba, kwônê ɓiɲé ô tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Menba, ôbi terbare wo pôni ô ligiri a aɲ jubu gubari tumôri a aɲ kôli iyôŋ ba: «Kelma, hena jeré gey ba já beraren.» ");
INSERT INTO kqp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jésu jé kôbri hebiɲni aɲ kôl iyôŋ ba: «Ew, en gey bi terbare tom hende to hen ré dôriɲ sam a.» Menba, kiriɲ ba ka hen na, terbare ɓegiɲ yi gawra bi wo hen a aɲ. ");
INSERT INTO kqp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Menba, Jésu kôli iyôŋ ba: «Kôliɲ kwôni kwôli berarê wom bi wo hen né pa pa niɲba, ju ô geliɲ ôbi bê kwôbe yem aɲ ju li sarga naɲ tôô to *Moyis na ay hen aɲ bi bay ré gel wo jeré na kwo séli tumô Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kiriɲa ka Jésu biɲ Kapêrnayôm, menba, dami wo asgarɲê ka Rôm era ligiri a ");
INSERT INTO kqp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aɲ uwôli kôl iyôŋ ba: «Kelma, mana wuɲê ômɲare merayri aɲ yiri liri damaŋ yi sa kalaŋ a ira yaŋ ya.» ");
INSERT INTO kqp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Menba, Jésu kôli iyôŋ ba: «Na erê berarêri hen ya.» ");
INSERT INTO kqp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Menba, ôbi sa asgarɲê bi wo hen kôli iyôŋ ba: «En nêm wo jeré ô sé bô iyére tiɲê a ré, ay tôm mera, menba, mana wuɲê bi wo hen a berarê seŋge. ");
INSERT INTO kqp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nôbi kôba bay san ya men, ena ôbi sa asgarɲê ka ba hen men, aɲ hena ené kôliɲ kwo pôni iyôŋ ba: ‹Ô› ba, ôbi ô men, hena ené kôli ‹Era› ba, ôbi era men, en kôliɲ lema wuɲê li aŋga na ba, ôbi li men, li ka hen ba, ôbi li a men.» ");
INSERT INTO kqp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kiriɲa Jésu toy kwôlo dami wo asgarɲê bi wo hen kôli hen iyôŋ menba, ɗê sari aɲ ôbi kôliɲ ɓiɲé ka mééri ta hen iyôŋ ba: «Na tu kwôlê a ené ena kelêŋge hen, kiriɲ ka en môriɲ môriɲ na, en uwôɲ kwôni wo ayê bôô wori yi môɲ kwo gawra wo na ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na tu kwôlê a ené ena kelêŋge hen, ɓiɲé a hena si tô emen men, si kini kuriɲay tare a men a daɲji naɲ si *Abraham, Isak naɲ Jakwôb kibi gwoy emê a bô *emê iyére to derômaraŋ a a. ");
INSERT INTO kqp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Menba, ka emê iyére to derômaraŋ a na toji ca hen na, bay a biji cêgi haba a aɲ kiriɲ ka hendi a, kiriɲ bay ka hen na, bay a sômnê men, a emê kaɲniji mêêrê mêêrê a men.» ");
INSERT INTO kqp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Menba, Jésu kôliɲ ôbi sa asgarɲê bi wo hen iyôŋ ba: «Ô iɲ wôsa aŋga ju bi bôm sara hen na, bay liɲ bem niɲ.» Kiriɲ bay ka Jésu kôliɲ gawra bi wo hen kwôlê hen iyôŋ menba, ôbi merayê bi wo hen berare yaŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Menba, Jésu ô iyé Piyêr a menba, uwôɲ mari Piyêr kal dere aɲ yere lere yi sa kalaŋ a. ");
INSERT INTO kqp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ôbi hebe kôbre menba, hende berare aɲ hena li aŋgaɲ emê biji. ");
INSERT INTO kqp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kiriɲa tare kuriɲ niɲ menba, bay eraɲ naɲ ɓiɲé ka tunu to habiɲ geliɲ tirji gusiɲ, menba, Jésu dage tunu hende to hen sarji a aɲ naɲ kwôlo si kibri a men, berare bay ômɲare kêm a men. ");
INSERT INTO kqp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ôbi li hen iyôŋ bi ré biɲ naɲ kwôlo *ôbi kibi Emen *Esay na kôl kôl iyôŋ ba: «Ôbi tô merayê wona men, ômɲare to lêna hen kôba ôbi tô yerna a aɲ a men hen.» ");
INSERT INTO kqp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jésu bô wo kwônê ɓiɲé mééri ta, menba, ôbi ay tôri biɲ bay tôri bi ciré ɗay tera cér wo dami hen. ");
INSERT INTO kqp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Menba, ôbi lê magtubu wo pôni uso ligiri a aɲ eŋgereri iyôŋ ba: «*Rabi, kiriɲ ka yôŋ yôŋ ka já erê ya hen na, na erê tôm a.» ");
INSERT INTO kqp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Menba, Jésu kôli iyôŋ ba: «Heŋɲê naɲ iyomniji men, ciré naɲ gwonérji a men, niɲba, nôbi *Kema Gawra ba kiriɲ ka a dôbiɲ san ya ba naɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Menba, gawra wo pôni perê bay tôri a kôli iyôŋ ba: «Kelma, ɗi jan, ɗén na erê emé iban dem.» ");
INSERT INTO kqp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Menba, Jésu uwôli sara iyôŋ ba: «Era tôn a na, aɲ ju ɗi ɓiɲé ka yi môɲ temare iyôŋ hen bi em megare temare.» ");
INSERT INTO kqp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jésu ɗay bô bato a naɲ bay tôri. ");
INSERT INTO kqp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Menba, kebrena wo nana kôl na na, kal wo dami ge sa cér aɲ li wo mêw di kam bêêrê bô bato menba, Jésu yiɲ kum ta men. ");
INSERT INTO kqp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bay tôri eŋni aɲ kôli iyôŋ ba: «Kelma, gôliɲ naɲ ni men réba naa mêniɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Menba, Jésu uwôlji sara iyôŋ ba: «Wô mi a kené hare hen iyôŋ ba? Wô mi a kené bi bôrŋge sa Emen a ré ba?» Menba, ôbi hena ône kal naɲ kam menba, kiriɲ iyer iyêêr. ");
INSERT INTO kqp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gawrê ka mô bô bato hen na, tiniji ge kay aɲ bay kôl perêrji a iyôŋ ba: «Gawra wo na ba, na kwo iyeŋgi a kal naɲ cér kôba ré biri kwôlê hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kiriɲa Jésu era sa biɲ cêgi cér wo Galilé bô emê wo Gadaréniɲê a menba, ɓiɲé wôô ka tunu to habiɲ kuriɲ sarji a soji si sa kamɲê aɲ eraji ligiri a. Bay li aŋga li harê aɲ kwôni nêm ayê geré wo bay môriɲ ya hen né. ");
INSERT INTO kqp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Menba, kiriɲ bay ka hen na, bay karê kula kôl iyôŋ ba: «Ju gey na mi yirni a jôbi woɲ Kema Emen, ju era na wô geléni gusiɲ pa dema wulê woni ré nêm tô ba?» ");
INSERT INTO kqp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kiriɲ bay ka hen na, gwôsiɲô ka pôni ɗubu kwa cér a sêd wolé ôm are. ");
INSERT INTO kqp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Menba, tunu to habiɲ hende to hen kôliɲ Jésu iyôŋ ba: «Nini uwôlem dagêni bi a bô gwôsiɲô ka ɗebe hen a ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jésu kôlji ré ô menba, tunu hende to hen si bô ɓiɲé bay ka wôô hen a aɲ ôrji siji bô gwôsiɲô aɲ li wo bay yêseraji ta sa keram a heriɲji bô kam a ma kêm. ");
INSERT INTO kqp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Menba, bay gemé gwôsiɲô bay ka hen gerji ô kôliɲ ɓiɲé derô ira kwôli are bay ka ré li are hen men, aŋga ré sa sa ɓiɲé ka wôô ka tunu to habiɲ yi bôrji a hen men. ");
INSERT INTO kqp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Menba, bay sooro ciré sa uɲéri aɲ kiriɲa bay uwoɲni niɲ menba, bay kôli ré si erêɲ bô emê woji a. ");
INSERT INTO kqp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jésu ɗay bato ô tera sa iyére tori a. ");
INSERT INTO kqp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Menba, bay eraɲ naɲ ôbi merayê wo yi sa jaare a, kiriɲa ôbi gel ayê bôô woji bi wo hen iyôŋ menba, ôbi kôliɲ ôbi merayê bi wo hen iyôŋ ba: «Baa kam, melaɲnen, têriɲ tom dôriɲ sam a.» ");
INSERT INTO kqp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Menba, bay derê tô tôô to Emen kôl bôrji a kôl iyôŋ ba: «Gawra bi wo hen tiiré na Emen hen.» ");
INSERT INTO kqp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jésu hôn ermé woji aɲ kôlji iyôŋ ba: «Wô mi a kené erem kwôlê wo habiɲ hen iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kelê iyôŋ ba: ‹Têriɲ tom dôriɲ sam a› a derê kelê lew, laba kelê: ‹Hena ta ju ô› a derê kelê lew ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Haw hen ka henê mega wo nôbi *Kema Gawra ené ôriɲ naɲ néé sa terare a na wô dôriɲ têriɲ sa ɓiɲé.» Menba, ôbi kôliɲ ôbi merayê na iyôŋ ba: «En kôlem, hena ta ay jaare tom ôriɲ iɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Menba, ôbi hena ta aɲ ay jaare tori ôriɲ iɲ. ");
INSERT INTO kqp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kiriɲa kwônê ɓiɲé gel hen iyôŋ menba, harê liji aɲ bay ay kibi Emen woɲ ôbi biɲ ɓiɲé néé hen. ");
INSERT INTO kqp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jésu ô aɲ kiriɲ bay ka hen menba, ôbi gel gawra wo pôni wo bay uwôgeri Matiyé mô kini eŋgé wôgê. Menba, Jésu kôli iyôŋ ba: «Era tôn a.» Menba, kiriɲ bay ka hen ôbi hena ô tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jésu ôm are iyé Matiyé a menba, kwônê ɓiɲé kaɲ *bay eŋgé wôgê naɲ bay lêre aŋga habiɲ men era sa ôm are naɲ Jésu naɲ bay tôri. ");
INSERT INTO kqp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisiɲêɲê gel hen iyôŋ menba, bay kôliɲ bay tôri iyôŋ ba: «Wô mi a *Rabi woŋge ré ôm are naɲ bay eŋgé wôgê men, bay lê habrê a men hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kiriɲa Jésu toy hen iyôŋ menba, ôbi kôlji waŋ a ta kôl iyôŋ ba: «Na ɓiɲé ka berari a geyé dôktôr ré, niɲba, na bay ômɲare a geyri ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Erêŋge ken hô ô tô kwôlo bay na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹En gey na wo kené bô tu ɲa to megêrŋge ɗiba na bê kwôbe wo naɲ lari hen né.› Wôsa nôbi kôba en era sa terare a na wô uwôgê ɓiɲé ka dôrɲê ré, niɲba, en era na wô uwôgê bay lê têriɲ ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bay tô Ja ôbi lê batêm era ligi Jésu a aɲ eŋgereri iyôŋ ba: «Wô mi a nibay naɲ Parisiɲêɲê niné jôriɲ bôrni kurôŋ kwôy kwôy menba, bay tôm jôbi ba li hen iyôŋ né wô mi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Menba, Jésu uwôlji sara iyôŋ ba: «Ɓiɲé ka era kini kurô hen ka bé bi bay ré jôriɲ bôrji kurôŋ kiriɲa ôbi iyéy kurô ba ya naɲ ci tô hen ba? Eŋ eŋ, wulê wo bay a derê ôbi kurô perêrji a aɲ hen na, na wulê bi wo hen a bay ré jôriɲ bôrji kurôŋ tô. ");
INSERT INTO kqp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kwôni a ulê tu bargay ka ôli naɲ ka kôrbi ré wôsa ka kôrbi bay ka hen a yêgerê ka ôli hen tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kwôni a bê care to kôrbi bô gwolé woɲ ariɲ wo ôli a ré, wôsa ôbi a kariɲ aɲ care hende to hen a uwôsiɲ, wôsa care to né haw ba biɲ na bô gwolé ariɲ wo kôrbi a men, hen dema care men, gwolé men, ré merê sem.» ");
INSERT INTO kqp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kiriɲa Jésu kôlji kwôlê bi wo hen ba ya tô menba, dami wo Jubɲê wo pôni era sa jubu gubari tumôri a aɲ kôli iyôŋ ba: «Môɲnen ma haw hen, era ju ô ulê kôm a sara bi bér ben men.» ");
INSERT INTO kqp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Menba, Jésu naɲ bay tôri henaji ôrji tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Iyore to pôni to kwôbe ô yere a li elê môj kibi wôô hen era si cêgeri aɲ hebe kibi bargay kari. ");
INSERT INTO kqp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hende erem bôre a iyôŋ ba: «Hena ené hebe bargay kari mera kôba na berarê seŋge.» ");
INSERT INTO kqp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jésu bare gele aɲ kôle iyôŋ ba: «Baa karê yêren, ayê bôô woré gôliɲ naɲ mu.» Kiriɲ bay ka hen na, hende berare. ");
INSERT INTO kqp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kiriɲa Jésu biɲ iyé dami wo Jubɲê bi wo hen a menba, ôbi gel bay iberé are men, bay karê kula a men. ");
INSERT INTO kqp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Menba, ôbi kôliɲ ɓiɲé iyôŋ ba: «Séŋge nô, wôsa mône hende to hen yi na kum ɗiba ma ré.» Menba, bay ayrêri. ");
INSERT INTO kqp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kiriɲa bay si nô kêm niɲ menba, ôbi si bô ira aɲ ɓu kôbi mône hende to hen ta menba, hende hena ta. ");
INSERT INTO kqp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aɲ kwôli béré wo ôbi bér mône hende to hen ôm gôre tô emê iyére hende to hen kêm. ");
INSERT INTO kqp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kiriɲa Jésu ɗa erê ta niɲ menba, bay tu tiɲ ka pôni wôô tô gura ôriɲ tôri a kôl iyôŋ ba: «*Kuŋga kelma Dabid, bô tu ɲa toni men.» ");
INSERT INTO kqp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kiriɲa Jésu sa biɲ iyére menba, bay tu tiɲ bay ka hen era ligiri a menba, ôbi eŋgeriji iyôŋ ba: «Ken hôn wo ené nêmê lê are bay ka hen ba?» Menba, bay hô kôli iyôŋ ba: «Ju nêm lê Kelma.» ");
INSERT INTO kqp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Menba, Jésu hebe tirji aɲ kôlji iyôŋ ba: «Bi are bay ka hen liɲ béŋge wô bôrŋge bi wo ken bi san a hen.» ");
INSERT INTO kqp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kiriɲ bay ka hen na, bay gel kiriɲ sél daŋ daŋ. Menba, Jésu ɓaŋji kôl iyôŋ ba: «Bi kwôni pôn iyôŋ kôba toy kwôli ré pa pa.» ");
INSERT INTO kqp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Niɲ na, kiriɲa bay ô niɲ menba, bay kôl kwôli Jésu gôriɲ tô iyére kêm mera. ");
INSERT INTO kqp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kiriɲa Jésu naɲ bay tôri ca erê ta niɲ menba, bay eraɲ naɲ gawra wo tunu to habiɲ jôôri iyêl kwôlê hen sa biri. ");
INSERT INTO kqp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jésu dage tunu to habiɲ hende to hen aɲ menba, gawra bi wo hen iyêl men. Menba, kwônê ɓiɲé ka ɗebu ya hen na, ɗê sarji aɲ bay kôl iyôŋ ba: «Nini gel ani kani ka hen iyôŋgi sa pôn sa iyé *Israyêl a ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Menba, Parisiɲêɲê kôl iyôŋ ba: «Na naɲ néé wo kelma woɲ ôbi sa tunu to habiɲ hende to hen a ôbi ré dagiɲ tunu to habiɲ hende to hen hen.» ");
INSERT INTO kqp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jésu ô naɲ sa iyére iyére to damné a men, to dê dê a a men geliɲ ɓiɲé are bô *iyéy daɲare a men, uwôliɲ béré Kwôlo Dôri wo gengiɲ sa *emê iyére to derômaraŋ a men, berariɲ bay ômɲare to gay gay men, bay lôrê ka gay gay a men. ");
INSERT INTO kqp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kiriɲa Jésu gel kwônê ɓiɲé ka era ligiri a hen iyôŋ menba, tirji liri ɲa wôsa bay yi môɲ gamgê ka ôbi abêrji naɲ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Menba, ôbi kôliɲ bay tôri gwosoy kwôlê kôl iyôŋ ba: «Kaw kaɲ walê mê gaɲ niɲba, bay walêrji dê. ");
INSERT INTO kqp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Uwôliɲge ôbi iyéy kaw na bi jéɲ naɲ ɓiɲé bô kaw kari a.» ");
INSERT INTO kqp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jésu uwôge bay tôri ka môj kibi wôô hen, aɲ biji néé bi bay ré dagiɲ tunu to habiɲ men, ré berariɲ bay ômɲare to gay gay hen naɲ bay merayê ka gay gay a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hini bay tôri bay ka môj kibi wôô hen a na: Simô wo bay uwôgeri Piyêr hen naɲ yêni André men, si *Jak naɲ yêni Ja kaɲ kam Jébédé hen men. ");
INSERT INTO kqp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip men Bartélémi men, Tomas men Matiyé woɲ *ôbi eŋgé wôgê hen men, Jak woɲ kema Alpé hen men, Tadé men, ");
INSERT INTO kqp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simô woɲ kema iyére hen men, Judas Iskariyôt woɲ ôbi desé Jésu hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jésu jé bay tôri bay ka môj kibi wôô hen aɲ halji kôl iyôŋ ba: «Erêŋge sa iyé ɓiɲé ka na Jubɲê ré hen ré men, ken ô sa iyé Samari a ré a men, ");
INSERT INTO kqp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","niɲba, ken ô kebê gamgê ka ge kay ka na kam *Israyêl hen pa dem. ");
INSERT INTO kqp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Erê wo ka erê hen na, ken kôliɲ ɓiɲé wo *emê iyére to derômaraŋ a ré ba ɗa niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Men, ken berare bay ômɲare to gay gay hen men, ken bér ka ma men, ken dô *terbare yi ɓiɲé a men, ken dage tunu to habiɲ bô ɓiɲé a a men. Mega wo ken uwôɲ seŋge hen na, kenbay kôba ken bi seŋge hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Erê wo ka erê hen na, ayêŋge lôr ley gursu tôni ley bô magela woŋge a ré men, ");
INSERT INTO kqp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ken ay magela woɲ kergare kôbreŋge a ré men, bargay kaɲ kabrêrŋge wôô wôô ré men, ken tôbe garbê ré men, ken pô kwoore wôni ré a men wôsa kwôni wo li jé ba a uɲé ari emêri. ");
INSERT INTO kqp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hena kené biɲ sa iyére to damné ley sa kam iyére a ley na, ken eŋgere kwôni wo a nêmê ɓeréŋge yiri a ya ba ken mô ya hende to hen kwôy wo ken ôriɲ ta. ");
INSERT INTO kqp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Men, kiriɲa kena sé bô iyé kwôni bi wo hen a na, ken liri dosé pa dem. ");
INSERT INTO kqp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A hena ɓiɲé ka bô iyére hende to hen ré nêm ɓeréŋge yirji a ba, bi bô jalê woŋge ba naɲ ci, a hena bay ré nêm ɓeréŋge yirji a ré ba, bi bô jalê woŋge a hera uɲéŋge. ");
INSERT INTO kqp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A hena bay ré ɓeréŋge yirji a ré men, bay toy kwôlê woŋge ré a men aɲa kené kena sé sa iyére hende to hen aɲ na, ken gage beni têrŋge aɲ dema kené ô ta tô. ");
INSERT INTO kqp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na tu kwôlê a ené kelêŋge hen: Wulê wo bay a sa jerê kwôlê sa ɓiɲé a hen na, sa iyé *Sodôm naɲ *Gwomôr kôba are a sa liji lôg sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Toyéŋge, en jéŋge môɲ gamgê iyôŋ perê heŋɲê a, iyôŋ ba ken melên môɲ kalaw iyôŋ men, ken ô lôm lôm mega derare iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Henêŋge bôrŋge a wo ɓiɲé ré ôriɲ naɲ ken tumô bay jerê kwôlê men, bay a yêmnêŋge bô *iyéy daɲare toji a a men.» ");
INSERT INTO kqp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","«Men, bay a ôriɲ naɲ ken tumô bay emê iyére a men, tumô kilmé a a men hen iyôŋ wô keben nôbi aɲ bi Jubɲê naɲ ɓiɲé ka na Jubɲê ré hen ré toyiɲ béré Kwôlê Dôri kebreŋge a a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kiriɲa bay ôriɲ naɲ ken kini jerê kwôlê a na, ken sun wô gwosoy kwôlo ma kené sa kelê ré men, wô kwôlo ma kené sa kelê ré a men wôsa kwôlo ka kelê hen na, na Tunu a béŋge kiriɲ bay ka ken ɗibiɲ hen a men seŋge. ");
INSERT INTO kqp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wôsa kwôlê bi wo hen na, na kenbay a kelêri ré niɲba, na Tini Ibareŋge a béŋge a kené kelê hen. ");
INSERT INTO kqp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Gawra a desé sa yêni a bi bay ré diri men, iba kema a liɲ kemari hen iyôŋ hende to hen men, kamrê kôba a perê sa balêrji bi bay ré dirji a men, ");
INSERT INTO kqp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ɓiɲé kêm a kaɲêŋge yôd wô kibi henen niɲba, kwôni wo ɓu bôri iyêre kwôy deriɲ kibi ba, ôbi a gelê. ");
INSERT INTO kqp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A hena bay ré geléŋge gusiɲ sa iyére tôni a ley ba ken ge sa to ɗaŋgi a. Na tu kwôlê a ené kelêŋge hen ka gerê tô iyé Israyêl kêm né tô a men, menba, nôbi *Kema Gawra na bulo hera men. ");
INSERT INTO kqp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ôbi dôyrê are na, gôliɲ sa dami wori ré men, paja gôliɲ sa kelmari ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ôbi dôyrê are yi môɲ dami wori iyôŋ men, paja yi môɲ kelmari iyôŋ a men. Hena bay na ré uwôge ôbi iyéreŋge *Béyêljébul ba kenbay dema bay ré kelê kené na ka Béyêljébul ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Kemnaɲge gawrê ré, wôsa ani ka uwôbe ka ba geliɲ ba naɲ men, ka bô kwôni a ka a ba hôniɲ ba naɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iyôŋ ba, kwôlo en kelêŋge bô dilemne ba, ken kôl tu tare a waŋ a ta men, kwo bay kelêŋge naɲ gwôsiɲare hen na, ken ɗay ta sa ira dema kené uwôliɲ béréri. ");
INSERT INTO kqp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hariɲge ka a deré kurôŋgi yerŋge mera ɗiba a nêmê deré tunuŋge ré hen né niɲba, ken hariɲ kwo a bê kurôŋgi yerŋge naɲ tunuŋge bô tare toɲ *géhên a hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bay daɲ diya wôô dema ré na tu selé pôn tô hen ba, ken gel ré ba? Niɲba, diya bi wo hen kwo pôn nêŋ wo a ma aɲ bi Ibareŋge Emen ré hôn né ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kenbay ba, gusuri sarŋge kôba Emen dêŋse. ");
INSERT INTO kqp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iyôŋ ba, ken hare ré wôsa ken dami tu Emen gôliɲ diya bi wo kwône hen. ");
INSERT INTO kqp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hena kwôni ré kôl waŋ ta tu ɓiɲé ɗiré na kuɲê na, nôbi kôba na sa kelê waŋ ta tu Iban wo derômaraŋ a ôbi ré na kuɲê men. ");
INSERT INTO kqp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A hena kwôni ré uwôser tu ɓiɲé ɗiré hônen ré na, nôbi kôba na sa uwôserê tu Iban wo derômaraŋ a ené hôni ré men.» ");
INSERT INTO kqp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ma ka kelê yaŋ ba ené era sa terare a na na naɲ bô jalê, en eraɲ na naɲ yebere to dami ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","En era bi kariɲare ré yi perê gawra naɲ ibari men, perê iyore a naɲ yore men, perê môni iyore a naɲ maare a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Men, bay bayi gawra ba na ɓiɲé ka bô iyére tori a ɗi men. ");
INSERT INTO kqp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Hena kwôni ré gey ibari naɲ yori gôlen nôbi ba ôbi na kuɲê ré tô men, hena kwôni ré gey kemari réba môɲni gôlen nôbi ba ôbi na kuɲê ré tô a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hena kwôni ré ay gurô tagelê wori kôbiɲ tôn né ba, na kuɲê ré tô a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ôbi a, kwôni wo ré gem yiri ba, kay na yiri men, kwo kay yiri wô san ba gem na yiri hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kwôni wo ɓeréŋge yiri ba, ɓuren na nôbi yiri hen men, kwo ɓuren nôbi yiri a ba, ɓu na kwo joon hen yiri a hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hena kwôni ré ɓu *ôbi kibi Emen wôni yiri wô wo ôbi ré na ôbi kibi Emen na, ôbi a uɲé sa kôbi wo gengiɲ sa ôbi kibi Emen men, kwo ɓu gawra woɲ ôbi lê aŋgaɲ derôre yiri a wô wo ôbi ré na ôbi lê aŋgaɲ derôre na, a uɲé sa kôbi wo gengiɲ sa lê aŋgaɲ derôre a men. ");
INSERT INTO kqp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na tu kwôlê a ené kelêŋge hen, hena kwôni ré ay kam ka jali bô môni gwore a biɲ kwo dê wo perê megêri a hen wô wo ôbi ré na ôbi tôn na, ôbi a ba uɲé sa kôbri ré.» ");
INSERT INTO kqp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kiriɲa Jésu hal bay tôri ka môj kibi wôô hen kô niɲ menba, ôbi ô naɲ sa iyére iyére wô geléji kwôlê men, derêji Kwôlo Dôri a men. ");
INSERT INTO kqp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kiriɲa Ja yiɲ daŋgay a menba, toy kwôli aŋga Jésu Krist ré li hen menba, ôbi jé bay tôri ré ô eŋgeréri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Jôbi a na kwo a era hen bi laba kwo nini mô gemni hen ba ya tô ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Menba, Jésu kôlji iyôŋ ba: «Herêŋge ken ô kôliɲ Ja kwôli aŋga ken toy men, ka ken gel men hen. ");
INSERT INTO kqp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wôsa bay tu tiɲ gel kiriɲ men, bay moré ô ta dô men, bay *terbare berare men, meŋɲê toy kwôlê men, ɓiɲé ka ma béér men, béré Kwôlo Dôri uwôliɲ biɲ bay nimré a men. ");
INSERT INTO kqp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yi derê yi wô sa kwôni wo ɗi ayê bôô wori aɲ né wô san.» ");
INSERT INTO kqp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kiriɲa bay tô Ja ôrji ta niɲ menba, Jésu kôliɲ ɓiɲé kwôli iyôŋ ba: «Na ken ô gelé na mi derô gwôlê hen ba? Gusura wo kal yebageri hen ba? ");
INSERT INTO kqp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A ken ô gelé na mi pôn ɗi ba? Ken ô gelé na gawra wo tôbe bargay ka dôri hen ba? Wôsa ɓiɲé ka tôbe bargay ka dôri dôri hen na, mô na bô iyé kilmé a ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A niɲba, na mi a kené ô gelé ɗi ba? Ken ô gelé na *ôbi kibi Emen wôni ba? Na tu kwôlê a ené ena kelêŋge hen, na ôbi kibi Emen bi, aɲ ôbi gôliɲ ôbi kibi Emen aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wôsa bay na kôl kwôli Ja ôbi jé bô magtubu to Emen a kôl iyôŋ ba: ‹Toy, en jé mana wuɲê tumôm a bi ré ɲanê geré wom.› ");
INSERT INTO kqp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na tu kwôlê a ené kelêŋge hen. En kelêŋge perê gawrê ka yébé a yêji hen na, en gel kwôni wo a damɲê môɲ Ja ôbi lê batêm iyôŋ ba naɲ, niɲba, kwo bay bôri môɲ ani ré iyôŋ bô *emê iyére to derômaraŋ a hen na, na kwo dami ɗêri. ");
INSERT INTO kqp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ayiɲ tôri sa Ja ôbi lê batêm a kwôy saɲ kemnêŋ na, emê iyére to derômaraŋ a na bay lere ɓégerem menba, na bay lere ɓégerem bay ka hen a ayê ciré liɲ toji. ");
INSERT INTO kqp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Wôsa kwôlo gengiɲ sa emê iyére hende to hen na, tôô to *Moyis naɲ bay kibi Emen na kôl kwôle kwôy saɲ sa Ja ôbi lê batêm a. ");
INSERT INTO kqp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hena kené gey henê wo ré na tiri ba, ôbi a na *Eli wo bay na kôl ré sa hen. ");
INSERT INTO kqp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kwôni wo mari ya aɲa ré gey toyé kwôlê bi wo hen ba bi toy. ");
INSERT INTO kqp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kenbay gawrê ka kemnêŋ hen na ayêŋge gengiɲ naɲ kamrê ka mô tu wolé uwôgeriɲ megêrji kaŋ ta kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Nini ibéŋge têgê menba, ken wôô sara ré men, nini kebe kurôŋ temare dôô kôba ken sôm ré a men.› ");
INSERT INTO kqp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wôsa kiriɲa Ja ôbi lê batêm saɲ na ôbi ôm mapa ré men, yi care ré a men, menba, bay kôl iyôŋ ba: ‹Tunu to habiɲ yi bôri a.› ");
INSERT INTO kqp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nôbi *Kema Gawra en sa aɲ ôm men, yi men, menba, ken kôl iyôŋ ba: ‹Geléŋge ôbi lamê naɲ ôbi kwoyé wo na, ôbi na melaɲ *bay eŋgé wôgê naɲ bay têriɲ a men.› Niɲba, jé lê woɲ derôre na, gel tu melênê wo Emen.» ");
INSERT INTO kqp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na ôbi á, Jésu ré nay ɓiɲé ka sa iyére to ôbi na liɲ kwônê geɲê wori ya hen wôsa bay ɗi tô têriɲ toji ba ré. ");
INSERT INTO kqp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ayi, ɓiɲé ka Kworajin, bô emê yi wô sarŋge! Ayi, ɓiɲé ka Bêtsayda bô emê yi wô sarŋge! Hena aŋgaɲ giɲê ka liɲ sa iyére toŋge a hen na, henaŋ né liɲ na Tir a ley Sidôn a ley na, na ca yeŋ a bay henaŋ né haarê bargay ka yêgeriɲ men, loberé bunu yirji a a men bi ciré gelé wo ciré bul cêgeriji biɲ têriɲ toji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na ôbi á, ené kelêŋge hen, Wulê wo bay a jôriɲ kwôlê sa ɓiɲé a hen na, si Tir naɲ Sidôn kwôlê a jôriɲ sarji a lôg gôliɲ kwoŋge. ");
INSERT INTO kqp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A mini Kapêrnayôm, mu kôl bay ré ayêrê kwôy ôriɲ ta derômaraŋ a ba? Ma herbé kwôy ɗogé iyom temare a ka na kiriɲ ka habiɲ hen. Wôsa geɲê wo na liɲ perêrŋge a hen hena henaŋ ré liɲ na perê ɓiɲé ka Sodôm a na, bay henaŋ né ba ya tô. ");
INSERT INTO kqp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ôbi a, ené kelêŋge waŋ ta, Wulê wo bay a jerê kwôlê sa ɓiɲé a hen na, kwoŋge a ɗê kwo Sodôm aɲ tô.» ");
INSERT INTO kqp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kiriɲ bay ka hen na, Jésu ay tô iyêlê kôl iyôŋ ba: «En ay kem Iban Kelma wo derômaraŋ a naɲ kwo sa terare a na, wôsa ju uwôbiɲ bay tu melênê naɲ bay tu jôriɲare are bay ka hen aɲ ju yêge sarji geliɲ ɓiɲé ka bay bôrji mega ani ré hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Na iyôŋ a Iban na jeré genge naɲ bô derê wom.» ");
INSERT INTO kqp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Iban bên are kêm kôben a, kwôni wo hôn Kema ba naɲ, na Ibari pôn ɗô men, kwôni wo hôn Iban ba, naɲ niɲba, na nôbi Kemari pôn nêŋ haɲê men, ka en yêge sari nô biji hen a men mera. ");
INSERT INTO kqp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Eraŋge legen a kenbay kêm ka ken pô aŋga néy aɲ merênêŋge hen na sa eŋgé sarŋge a aɲ ken dô bul. ");
INSERT INTO kqp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ulêŋge jug wuɲê tôrŋge a men, ken toy halê wuɲê a men, wôsa ena gawra wo kalêren jal men, en dôbe san a men, aɲ ka uɲé kini derê bul woŋge. ");
INSERT INTO kqp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wôsa jug wuɲê na kwo ayêri ôm né men, ari perê kaɲê kôba gwa a men.» ");
INSERT INTO kqp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sem cêgê menba, Jésu naɲ bay tôri ôrji si bô yagê kaw bay uwôgeji blé hen naɲ *sa merê ta, kurôŋ li bay tôri menba, bay pôy sa kaw bay ka hen wuray ôm. ");
INSERT INTO kqp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kiriɲa Parisiɲêɲê gel hen iyôŋ menba, bay kôliɲ Jésu iyôŋ ba: «Wô mi a bay tôm ré li aŋga tôô to *Moyis jô lê naɲ sa merê ta a hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Menba, Jésu kôlji iyôŋ ba: «Na ken dêŋse kwôli aŋga kelma Dabid na li kiriɲa kurôŋ na liji naɲ ɓiɲé kari hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ôbi na si bô *iyéy Emen a, aɲ pô mapa wo bay tibiɲ Emen wo na yi gengiɲ sarji ré hen. Mapa bi wo hen tôô tona na ɗi biɲ na bay bê kwôbe mera hen ômji. ");
INSERT INTO kqp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Laba na ken dêŋse kwôlo tôô to Moyis na kôl iyôŋ ba: ‹Kwôni ré li jé naɲ sa sa merê ta ré hen né ba?› Menba, bay bê kwôbe ka li jé woji bô iyéy Emen a naɲ sa sa merê ta hen ba kwôlê ɓu sarji ré men. ");
INSERT INTO kqp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Niɲba, en kelêŋge, aŋga gôliɲ iyéy Emen hen na, yi na ya. ");
INSERT INTO kqp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hena ré kené hôn bô kwôlo liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹En gey na wo kené bô tu ɲa to megêrŋge ɗiba na bê kwôbe wo naɲ lari hen né.› Hen ba ré kené perê ɓiɲé ka kwôlê wôni ɓu sarji ré hen né. ");
INSERT INTO kqp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wôsa nôbi *Kema Gawra a na Kelma sa sa merê ta.» ");
INSERT INTO kqp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kiriɲa Jésu ɗi kiriɲ bay ka hen aɲ ô aɲ menba, ô bô *iyéy daɲare toji to pôni a. ");
INSERT INTO kqp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kiriɲ bay ka hen na, gawra wo pôni wo kôbri ma ɗebu ya men. Menba, Parisiɲêɲê eŋgere Jésu iyôŋ ba: «Berarê kwôni sa merê ta a ba dô hari ba?» Bay eŋgereri hen iyôŋ bi ciré uwôli kwôlê sari a. ");
INSERT INTO kqp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Menba, Jésu uwôlji sara iyôŋ ba: «I a perêrŋge a hen a demaŋne tori ré pôn aɲ kuriɲ bô iyom a sa merê ta aɲ ôbi a erê sa ô ayêre ta ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A hen ba, gawra gôliɲ demaŋne ré ba? Iyôŋ ba lê derê sa merê ta a kôba tôô tona jôô lê ré men.» ");
INSERT INTO kqp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Menba, Jésu kôliɲ gawra bi wo hen iyôŋ ba: «Jé kôm.» Menba, ôbi ay kôbri ta aɲ kôbri bi wo hen hô berare môɲ megari hen iyôŋ hôriɲ. ");
INSERT INTO kqp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Menba, Parisiɲêɲê siji nô aɲ ô erméji kwôlê sa aŋga ciré lê aɲa ciré deriɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jésu hôn wo bay ré gey deréri menba, ôbi ɗi kiriɲ bay ka hen aɲ ô ta, menba, ɓiɲé kwône ô tôri a aɲ ôbi berare bay ômɲare kêm. ");
INSERT INTO kqp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Menba, ôbi ɓaŋji dô bi bay ré li bi bay ré hôn wo ré na nôbi ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aɲ bi kwôlo *ôbi kibi Emen *Esay na kôl hen na, ariri ré liɲ, ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Emen kôl iyôŋ ba: ‹Geléŋge, na mana wuɲê wo en dôri bi a na men, en piri men, wo yen dôren sari a men. Na bé tunun a ba naɲ ɗi aɲ ôbi a kelê kwôli lê aŋgaɲê kaɲ derôre biɲ tô yê ɓiɲé kêm men. ");
INSERT INTO kqp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ôbi a nàɲ náɲ kwôni ré men, a ulê gura ré men, kwôni a toyé tôri kaŋ ta tô geré ré men. ");
INSERT INTO kqp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ôbi a biyê gusera wo laɲ niɲ hen né men, a barê lampa to eŋge jêê hen né a men, kwôy wo aŋgaɲ derôre a eŋgiɲ kiriɲ. ");
INSERT INTO kqp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aɲ tô yê ɓiɲé kêm a biɲ bôrji sari a.› » ");
INSERT INTO kqp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kiriɲ bay ka hen na, bay eraɲ naɲ gawra wo tunu to habiɲ yi bôri a aɲ liri ôbi gel kiriɲ né men, iyêl kwôlê ré a men, menba, Jésu berari aɲ ôbi iyêl men, gel kiriɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɓiɲé kêm ka ɗebu ya hen na, harê liji menba, bay kôl iyôŋ ba: «Ôbi na *kuŋga kelma Dabid ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kiriɲa Parisiɲêɲê toy hen iyôŋ menba, bay kôl iyôŋ ba: «Jésu dage tunu to habiɲ na naɲ néé wo *Béyêljébul woɲ ôbi sa tunu to habiɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jésu hôn ermé woji kêm niɲ menba, ôbi kôlji iyôŋ ba: «Hena ɓiɲé ka bô emê iyére to pôn a ré sêɲji ba, bô emê bi wo hen, a mêniɲ men, hena ɓiɲé ka sa iyére a pôn ley tô baliyare a ley a ré sêɲji ba hende a yé sem né men. ");
INSERT INTO kqp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A hena Sidan ré dage yiri gaŋ ba, emê iyére tori a soderiɲ, a hena ré na hen iyôŋ ba, emê iyére tori a yé kwôy hare ba? ");
INSERT INTO kqp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A hena nôbi ené dage tunu to habiɲ naɲ néé wo Béyêljébul ba, bay tôrŋge kenbay ba, dage tunu to habiɲ na naɲ néé wo i men ba? Na bi wo hen a aŋga bay tôrŋge bay ka hen li men hen a gelé wo kwôlê woŋge ré tiri ré hen. ");
INSERT INTO kqp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A hena ré na naɲ néé wo Tini Emen a ené dagiɲ tunu to habiɲ hende to hen ba, *emê iyére to Emen era kwôy uɲéŋge niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Men, kwôni a lê iyeŋ a ré sé bô iyé ôbi néé a aɲ pôriɲ aŋgari baa ɓeréri harê tumô ba? Ôbi a harêri tumô pa dem aɲa ré ɗiɲ yiri pôriɲ aŋgari tô. ");
INSERT INTO kqp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iyôŋ ba, kwôni wo na naɲ en ré ba na ôbi baren men, kwôni woɲ ôbi dayê sa are naɲ en ré ba na ôbi userérji men. ");
INSERT INTO kqp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na tôri bi wo hen a, ené kelêŋge, têriɲ kêm naɲ tiiré hare kêm na, Emen a ɗé bôri jalê bay lêre a, niɲba, kwôni wo tiiré Tunu toɲ hendi bô bôrê na, Emen a ɗé bôri jalê sari a ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Men, kwôni wo kôl kwôlo habiɲ gengiɲ san nôbi *Kema Gawra ba, Emen a ɗé bôri jalê sari a tô, niɲba, kwo kôl kwôlo habiɲ gengiɲ sa Tunu toɲ hendi bô bôrê na, Emen a ɗé bôri jalê sari a haw hen ré men, tôre to cêgê ré a men.» ");
INSERT INTO kqp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kiriɲ ka pôni a ba ken kôl gurô wo hen ré dô men, yêri ré dô a men. Men kwo pôni ken kôl gurô wo pôni ré habiɲ men, yêri ré habiɲ a men. Wôsa na yê gurô a lê a jeré hôniɲ derêri naɲ habrêri. ");
INSERT INTO kqp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kenbay ka ken yi môɲ jênêre iyôŋ men ken habiɲ tiri a men hen ka kelê Kwôlo Dôri na si iyeŋ ba? Wôsa na aŋga wôn bô gawra dema ré si kibri a hen tô. ");
INSERT INTO kqp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gawra wo dôri siɲ na naɲ aŋgari ka dôri men, kwo habiɲ kôba siɲ na naɲ aŋga ka habiɲ men. ");
INSERT INTO kqp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ôbi a, ené kelêŋge Wulê woɲ jerê kwôlê a na, kwôlê woɲ iyôŋ a tôŋ wo ɓiɲé na kilêrê hen na, bay a derê tôri ta lêm lêm. ");
INSERT INTO kqp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aɲ na kwôlo si kem a a bay ré dôriɲ kwôlê sam a men, na kwo si kem a a bay ré ɓurem a men.» ");
INSERT INTO kqp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bay derê tô tôô to Emen ka pôni naɲ Parisiɲêɲê eŋgeriɲ Jésu iyôŋ ba: «Kelma, nini gey bi jeré li aŋgaɲ gelé bi niɲa gelé dema niné hônem.» ");
INSERT INTO kqp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Menba, Jésu uwôlji sara iyôŋ ba: «Ɓiɲé kaɲ bay bô habrê ka haw hen men, bay belé cêgeriji biɲ Emen hen kôba kôl ciré gey gelé men ɗê? Ka baɲ na naɲ aŋgaɲ gelé ka *ôbi kibi Emen Jonas bi wo hen mera ɗiba ka gelé ka ɗaŋgi kani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Môɲ kwo Jonas na li sa subu yoyre men, sa subu tu tare a men bô kuyê a hen na, nôbi Kema Gawra kôba na lê sa subu yoyre men, sa subu tu tare a men bô kamɲê a hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa jerê kwôlê a na, ɓiɲé ka Ninibé a ulêji kwôlê sa ɓiɲé bay ka haw hen wôsa bay dô tô têriɲ lêriji ta sa kibi béré wo Jonas uwôl a. Aɲ kwo na ba hô ɗê Jonas aɲ tô. ");
INSERT INTO kqp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Men, Wulê woɲ jerê kwôlê a na, tôlômne to Séba a hena aɲ a ulê kwôlê sa gawrê ka haw hen wôsa hende hena na kelaŋ aɲ era na wô toyé gwosoy kwôlê woɲ tu melênê wo Salomôn. Niɲba, nà ná, kwôni wo gôliɲ Salomôn aɲ hen kôba nà ya.» ");
INSERT INTO kqp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jésu hô kôl iyôŋ ba: «Kiriɲa tunu to habiɲ séɲ bô kwôni a na, hende kayrê derô gwôlê woge kiriɲ kaɲ derê bul, hena hende ré uwoɲ ré na, ");
INSERT INTO kqp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","hende erem kôl iyôŋ ba: ‹Na herê kiriɲ ka na en soɲ ya hen gelé sôŋ.› Kiriɲa tunu hende to hen hera aɲa ré uwôɲ kiriɲ bay ka hen yi seŋge men, sél dô men, are kêm yi naɲ kiniji a men na, ");
INSERT INTO kqp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","hende hô ô pera tunu to habiɲ to ɗaŋgi jurgem to habiɲ ɗê aɲ sa jôgiɲ naɲ tu. Bay siji bô kiriɲ bay ka hen aɲ môrji ya aɲ gawra bi wo hen na, yiri habiɲ ɗê kwo tumô aɲ tô. Kwo ɓiɲé ka haw hen kôba a yé na hen iyôŋ hende to hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kiriɲa Jésu iyêl naɲ kwônê ɓiɲé ba ya tô menba, yori naɲ yênêri saji ɗebu nô hen aɲ gey bi ciré iyêlê naɲ ɗi.  ");
INSERT INTO kqp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Menba, kwôni wo pôni kôli iyôŋ ba: «Ju toy, yom naɲ yênên ɗibiji nô hen ya aɲ bay gey ciré iyêlê naɲ ju.» ");
INSERT INTO kqp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Menba, Jésu hô kôliɲ gawra bi wo hen sara iyôŋ ba: «Na i a na yon men, na si i a na yênên men ba?» ");
INSERT INTO kqp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Menba, ôbi ay kôbri gel sa bay tôri a aɲ kôl iyôŋ ba: «Gel, na yon naɲ yênên a na. ");
INSERT INTO kqp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wôsa i i wo li bô geyé wo Iban wo mô derômaraŋ a hen na, ôbi a na, yênen men, yêren men, yon a men hen.» ");
INSERT INTO kqp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wulê wo ôbi kôliɲ kwôlê bi wo hen na, ôbi ji si bô ira aɲ ô merê kibi cér a. ");
INSERT INTO kqp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kiriɲ bay ka hen na, kwônê ɓiɲé era sa daɲ ligiri a, aɲ li wo ôbi ɗay mô bô bato a aɲ ɗiji kibi cér a. ");
INSERT INTO kqp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Menba, ôbi iyêlji kwôlê naɲ gwosore ɗé, ɗé gengiɲ sa are kwône kôl iyôŋ ba: «Gawra wo pôni si ô ɗiré wusé kaw. ");
INSERT INTO kqp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kiriɲa ôbi wuse kaw kari bay ka hen bô yagê a menba, ka pôni sa heriɲ bêŋgê geré menba, ciré sa gôl ôm ");
INSERT INTO kqp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","men, ka pôni heriɲ kiriɲ kaɲ jerew a menba, si dô hare niɲba, terare to wurôbi to hanêre ré ôriɲ tôŋ ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kiriɲa tare jôriɲ menba, bay hay lew wôsa terare to bay ré biɲ hanêre tôŋ ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Men, ka pôni heriɲ perê gesem a menba, gesem bi wo hen yêrji duu. ");
INSERT INTO kqp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Men, ka pôni heriɲ terare to dôri a aɲ yê dô, sarji ka pôni yê arew men, ka pôni yê tôre jii men, ka pôni yê tôre subu men. ");
INSERT INTO kqp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kwôni wo mari ya ba bi toy.» ");
INSERT INTO kqp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Menba, bay tôri usoji ligiri a aɲ eŋgeriri iyôŋ ba: «Wô mi a jeré iyêliɲ ɓiɲé bay ka hen kwôlê naɲ gwosore ba?» ");
INSERT INTO kqp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Menba, Jésu uwôlji sara iyôŋ ba: «Kwoŋge kenbay ba Emen béŋge ken hôn aŋga yi naɲ kini uwôbêrji ka bô *emê iyére to derômaraŋ a hen niɲ, niɲba, bay ba ôriɲ naɲ kuni pelalê bi wo hen né. ");
INSERT INTO kqp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wôsa kwôni wo naɲ uɲé bay a hô biri a sara aɲ ôbi a uɲé damaŋ a. Niɲba, kwo ari uɲé kari lôg hen na, bay a derê bay ka lôg hen kôbri a aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ôbi á, ené iyêlji naɲ gwosore hen, wôsa bay bô kiriɲ niɲba, gel ani ré men, bay li môɲ ciré toy kwôlê niɲba, bay toy ré men, hôn bôri ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwôlo ôbi Emen *Esay na kôl hen na, ariri liɲ gengiɲ sarji, ôbi na kôl iyôŋ ba: ‹Ka toyé kwôlê naɲ marŋge niɲba, ka henê bôri ré men, Ka berê kiriɲ naɲ turŋge niɲba, ka gelé ani ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wôsa ɓiɲé bay ka hen na, bôrji deŋgel men, bay tôbe gurô marji a men, bay luge tirji ta a men, wô wo ma ciré gelé naɲ tirji men, ma ciré toyé naɲ marji aɲ ma ciré bê bôrji sara aɲ ma ciré belé uɲen aɲ bi ené berarêji.› ");
INSERT INTO kqp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Niɲba, kwoŋge kenbay ba yerŋge a derêŋge wôsa ken gel naɲ turŋge men, ken toy naɲ marŋge a men. ");
INSERT INTO kqp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na tu kwôlê a ené kelêŋge hen: bay kibi Emen naɲ ɓiɲé kaɲ bay lê aŋgaɲ derôre kwône na gey bi ciré gelé aŋga ken gel hen men, niɲba, bay gel ré men, bay gey ciré toyé kwôlo ken toy hen niɲba, bay toy ré a men.» ");
INSERT INTO kqp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Iyôŋ ba haw hen ken toy bô gwosore to ôbi wusé gusiɲ kaw bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kiriɲa kwôni toy kwôlo gengiɲ sa *emê iyére to derômaraŋ a aɲa ré hôn bôri ré na, ôbi bare era sa mêne kwôlo gawra bi wo hen ré toy hen aɲ aɲ ôbi yi môɲ gusiɲ kaw ka heriɲ bêŋgê geré hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kwo yi môɲ gusiɲ kaw to heriɲ kiriɲ kaɲ jerew a hen na, na kwo toy kwôlê bi wo hen aɲ eŋge naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Niɲba, kwôni bi wo hen hanêri naɲ wôsa ôbi ɗebe sa têri a sem ré menba, kiriɲa aŋgaɲ bô emê kuriɲ sari a ley bay gili gusiɲ ley wô kibi kwôlê bi wo hen na, ôbi ɓeriɲ kôbri aɲ hôriɲ cêgê. ");
INSERT INTO kqp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kwo yi môɲ gusiɲ kaw ka heriɲ perê gesem a hen na, na kwo toy kwôlê bi wo hen hari niɲba, ermé kwôlo sa terare a na men, kwôli aŋgaɲ uɲé a men na, yêr kwôlê bi wo hen duu aɲ li ani ré. ");
INSERT INTO kqp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kwo yi môɲ gusiɲ kaw ka heriɲ kiriɲ ka dôri a hen na, na kwo toy kwôlê bi wo hen aɲ hôn bôri dô men, liɲ ariri a men aɲ ôbi yi môɲ kaw ka yê arew men, tôre jii men, tôre subu men hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «*Emê iyére to derômaraŋ a na, yi mega gawra wo ré ô wusé kaw ka dôri bô yagê wori a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Niɲba, kiriɲa yoyre wo ɓiɲé yi kum kêm niɲ menba, ôbi bayriri era sa wusu siwil a bô yagê bi wo hen a aɲ ɗiɲ yiri ô. ");
INSERT INTO kqp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Menba, kiriɲa kaw ɗebu aɲ tô sarji menba, siwil kôba gel yere men. ");
INSERT INTO kqp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Manê ka gawra bi wo hen era sa kôli iyôŋ ba: ‹Kelma, na ju wusu na kaw ka dôri bô yagê wom a ré ba? Menba, li iyeŋ a siwil ré sa si perê ba?› ");
INSERT INTO kqp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Menba, ôbi uwôlji sara iyôŋ ba: ‹Na ôbi bare a lê are bay ka hen.› Menba, manê kari bay ka hen kôli iyôŋ ba: ‹A iyôŋ ba niɲa erê terê aɲ.› ");
INSERT INTO kqp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Menba, ôbi uwôlji sara iyôŋ ba: ‹Eŋ eŋ, terêŋge aɲ né wô wo ma ka terê kaw ka dôri naɲ tu men, ");
INSERT INTO kqp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ɗéŋgeji bi bay ɗebu ɓem kwôy kini walêrji a. Aɲ na sa kôliɲ bay walê kaw bi ré ɲôr siwil tumô harê aɲ uwoy aɲ, aɲ kaw ka dôri hen ba ken wala sa bi bô béér a men.› » ");
INSERT INTO kqp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Emê iyére to derômaraŋ a yi môɲ gusiɲ iluw wo gawra ay ô cé bô yagê wori a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gusiɲ iluw bi wo hen na, dê ɗê gusiɲ are kêm niɲba, kiriɲa ôbi si ta niɲ na, dami ɗê tô gurô wo ba hen kêm aɲ ciré ka derômaraŋ era sa li gwoné woji ya.» ");
INSERT INTO kqp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Emê iyére to derômaraŋ a yi môɲ wubere to dê to iyore ay poliɲ naɲ kurmaŋ kuré kwôrô subu menba, liji sôr iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jésu iyêliɲ ɓiɲé kwôlê bi wo kêm hen naɲ gwosore aɲ kwo ôbi ba kelê naɲ gwosore ré ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aɲ bi kwôlo *ôbi kibi Emen na kôl hen na, ariri ré liɲ. Ôbi na kôl iyôŋ ba: «Na kelê kwôlê kêm naɲ gwosore yêgiɲ sa aŋga yi naɲ kini uwôbêrji ca wo tô terare na ɗiɲ yeŋ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Menba, Jésu ɗi kwônê ɓiɲé bay ka hen ré ô haji niɲ menba, ôbi herbo hera ira menba, bay tôri eraji ligiri a aɲ kôli iyôŋ ba: «Derêni bô gwosore to gengiɲ sa siwil to bô yagê hen bi niɲa toyé.» ");
INSERT INTO kqp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Menba, ôbi kôlji iyôŋ ba: «Ôbi cé kaw ka dôri bay ka hen na, na nôbi *Kema Gawra. ");
INSERT INTO kqp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Men, bô yagê ba na sa terare men, kay cé ka dôri ba na ɓiɲé ka emê iyére to derômaraŋ a men, siwil ba na ɓiɲé ka Sidan men. ");
INSERT INTO kqp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Men, ôbi cé siwil hende to hen bô yagê a hen na, na ôbi bare woɲ Sidan bi men, tay walê kaw ba, na sa to sa terare a kerê hen men, bay walê kaw bay ka hen ba, na *manê ka derômaraŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Môɲ kwo bay ɲôriɲ siwil aɲ harê bê a bô tare a hen iyôŋ na, a yé na hen iyôŋ hende to hen sa to sa terare a kerê a men. ");
INSERT INTO kqp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nôbi Kema Gawra na jo manê kaɲê ré era sa pô ɓiɲé kaɲ bay bê megêrji bô têriɲ a naɲ bay lê têriɲ kêm aɲ bô emê iyére tori a. ");
INSERT INTO kqp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aɲ biji bô tare to dami a, kiriɲa ɓiɲé bay ka hen a sômniɲ men, ômniɲ kaɲniji mêêrê mêêrê a men ya. ");
INSERT INTO kqp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Niɲba, bay lê aŋgaɲ derôre ba bay a peraŋgê môɲ tare iyôŋ bô emê iyére to Ibarji a. Kwôni wo mari ya aɲa ré gey toyé kwôlê bi wo hen ba bi toy.» ");
INSERT INTO kqp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi sôŋ kôl iyôŋ ba: «Emê iyére to derômaraŋ a yi môɲ aŋgaɲ uɲé ka uwôbe bô yagê iyôŋ. Kwôni wo uwôɲ hen na, ô uwôbê tôŋ, yiri dôri damaŋ a aɲ ô sa ô perê ari uɲéri kêm keléɲ aɲ ɗi larirji sa ô kiliɲ yagê bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Emê iyére to derômaraŋ a yi môɲ ôbi lê jeŋga wo ôriɲ doy mériɲ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kiriɲa ôbi uwôɲ mériɲ wo lariri damaŋ hen menba, ô sa ô perê ari uɲéri kêm keléɲ aɲ ɗi larirji sa ô kiliɲ mériɲ bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Emê iyére to derômaraŋ a yi môɲ bera to bay uwôl bô cér a aɲ pera kuyê ka tirji gay gay hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kiriɲa bera hende to hen wôn niɲ menba, bay uré bay wurore soɲ nô kwoŋgé cér a aɲ cobe kuyê bay ka hen. Ka dami ba bay uwôl bô ɗuŋne toji a men, ka dê ba bay bêɲ men. ");
INSERT INTO kqp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sa to sa terare a kerê hen na, a yé na hen iyôŋ hende to hen men. Manê ka derômaraŋ a a era sa derê tu ɓiɲé ka dôri naɲ ka habiɲ. ");
INSERT INTO kqp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aɲ ka habiɲ bay ka hen na, bay a biji bô tare to dami a, na kiriɲ ka ɓiɲé a sômê men emnê kaɲniji mêêrê mêêrê ya a men hen.» ");
INSERT INTO kqp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jésu hô eŋgeriɲ bay tôri iyôŋ ba: «Ken hôn bô kwôlê bi wo hen kêm niɲ ba?» Menba, bay uwôli sara iyôŋ ba ciré hôn bôri kêm niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Menba, ôbi hô kôlji iyôŋ ba: «Ôbi lê magtubu wo yôŋ yôŋ wo tiri jôriɲ sa aŋga ôbi gel a hen na, emê iyére to derômaraŋ a yi môɲ ôbi iyéy iyére wo pô ari uɲé kari ka kôrbi naɲ ka ôli bô béér wori iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kiriɲa Jésu gelji kwôlê naɲ gwosore hende to hen kô niɲ menba, ôbi ɗi kiriɲ bay ka hen aɲ ô. ");
INSERT INTO kqp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aɲ ô sa iyére tori a ô geliɲ ɓiɲé are bô *iyéy daɲare a toji a aɲ ɓiɲé kêm ka toy kwôlê bi wo ôbi dô hen na, tiniji ge kay aɲ bay kôl iyôŋ ba: «Na i a biri tu melênê men, néé woɲ liɲ aŋga ɗê sa kiriɲ bay ka hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Menba, bay kôl iyôŋ ba: «Ôbi na kema Josêp woɲ ôbi albê gurô hen men, Mari a na yori men, *Jak men Josêp men Simô men Jud a men a na yênêri. ");
INSERT INTO kqp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yênêri kaɲ yébé kôba môrji perêrna na ya a men. Menba, tu melênê naɲ néé bi wo kêm hen ba i a biri ba?» ");
INSERT INTO kqp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kiriɲ bay ka hen na, ermé woji liji kwôy aɲ bay kaɲni. Niɲba, Jésu kôlji iyôŋ ba: «Ôbi kibi Emen na, kiriɲ ka ɗaŋgi a ba bay a biri kwôlê haji niɲba, sa iyére tori men, perê balêri a men na, bay biri kwôlê ré.» ");
INSERT INTO kqp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aɲ kiriɲ bay ka hen na, ôbi li geɲê wôni gaɲ ré wô bê wo bay bi bôrji sari a ré hen. ");
INSERT INTO kqp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wulê bi wo hen na, *Hérôd ôbi emê iyére to Galilé toy kwôli Jésu wo ôm gôr kiriɲ hen. ");
INSERT INTO kqp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Menba, ôbi kôliɲ manê kari iyôŋ ba: «Gawra bi wo hen na, na Ja ôbi lê batêm a so perê ɓiɲé ka ma a bulo hera hen, na ôbi a, ôbi ré ôriɲ naɲ néé woɲ liɲ aŋgaɲ geɲê hen.» ");
INSERT INTO kqp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wôsa Hérôd na bi bay na ɓu Ja haarê uwôl daŋgay a wô kibi *Hérodiyad toɲ tami yêni Pilip to ôbi eŋne hen. ");
INSERT INTO kqp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Wôsa Ja na kôli iyôŋ ba: «Dé wo ré jeré ayê Hérodiyad liɲ tamnem ré.» ");
INSERT INTO kqp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gengiɲ sa kwôlê bi wo hen na, ôbi na gey ɗiré deréri, niɲba, ôbi na kemnaɲ na kwônê ɓiɲé wôsa bay na bô Ja môɲ *ôbi kibi Emen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kiriɲa bay li geserê sa yê *Hérôd, menba, môni Hérodiyad wô tumô ɓiɲé ka Hérôd uwôgeraji hen, aɲ wôrê wore bi wo hen dôri. ");
INSERT INTO kqp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Menba, ôbi ay tôô desiɲ yiri kôl iyôŋ ba: «Na mi, mi a hende ré eŋgeren kôba, na bure.» ");
INSERT INTO kqp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Menba, yore gwôsere aɲ môni temale hende to hen kôli iyôŋ ba: «Ben sa Ja ôbi lê batêm lew bô subra.» ");
INSERT INTO kqp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tu Hérôd mêne, niɲba, wô tôô to ôbi ré ay hen men, wô tu kwônê kergê kari hen a men na, ôbi ay tôô bi bay ré bure sa Ja bi. ");
INSERT INTO kqp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Menba, ôbi kôlji bay ré ô jera sa Ja ôbi lê batêm daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bay aya sa Ja bô subra eraɲ sa biɲ môni temale hende to hen, aɲ hende ôriɲ biɲ yore. ");
INSERT INTO kqp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bay tô Ja era sa ay temayri ô emé, menba, bay ô kôliɲ Jésu kwôli. ");
INSERT INTO kqp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kiriɲa Jésu toy kwôli temay Ja hen iyôŋ menba, ôbi ɗay bô bato a ô sêd wolé naɲ iyére derô gwôlê, kiriɲa ɓiɲé toy wo ôbi ré ɗay bô bato a ô ta menba, bay sooro naɲ sa iyére iyére ôrji kibi cér a têm têm tôri a naɲ têrji. ");
INSERT INTO kqp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kiriɲa ôbi herbo tôŋ bô bato menba, ôbi gel kwônê ɓiɲé menba, tirji liri ɲa damaŋ menba, ôbi berare bay ômɲare. ");
INSERT INTO kqp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na perare niɲ, menba, bay tô Jésu era ligiri a aɲ kôli iyôŋ ba: «Kiriɲ ka na na, kelaŋ men, kiriɲ kôba kô a men hen na, kôliɲ ɓiɲé bi ré ô perê ira ô wogé ani kelé emê.» ");
INSERT INTO kqp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Menba, Jésu uwôlji sara iyôŋ ba: «Nana ôriɲ doy bi bay ré ô ré, kenbay ken biji aŋgaɲ emê.» ");
INSERT INTO kqp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Menba, bay hô uwôli sara iyôŋ ba: «Nini naɲ mapa bay naɲ kuyê wôô a men mera.» ");
INSERT INTO kqp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Menba, Jésu kôlji iyôŋ ba: «Eraɲge ben na.» ");
INSERT INTO kqp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Men, ôbi biɲ ɓiɲé mô tôŋ sa kalmê a hen aɲ pô mapa wo bay naɲ kam kuyê ka wôô hen aɲ bô kiriɲ si derômaraŋ aɲ liɲ Emen dosé menba, ɓiilê aɲ biɲ bay tôri bi ré céɲ ɓiɲé bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓiɲé bay ka hen, ôm uyirê aɲ tôri wo ba na, bay tô Jésu pô gwaɲê môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kwônê ɓiɲé bay ka ôm mapa bi wo hen na, imɲê na dubu bay. Yébé naɲ kamrê ba kwôni dêŋsiji ré. ");
INSERT INTO kqp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kiriɲa bay biɲ ɓiɲé emê kô niɲ menba, ôbi bi bay tôri ɗay bato ré ô tera aɲ ɗôbi ɗiré kôliɲ ɓiɲé ré irê iɲ niɲ dema ɗiré erê tôrji a tô. ");
INSERT INTO kqp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kiriɲa ôbi bi ɓiɲé ô niɲ menba, ôbi ɗay sa keram a sêd wolé ô uwôlê Emen, kiriɲ bay ka hen na, kiriɲ yoy niɲ menba, ôbi na pini nêŋ hari. ");
INSERT INTO kqp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bato wo bay tôri ré ɗay hen na, na bôb a derô cér a niɲ, menba, mêw liji damaŋ wôsa kal guro si sarji. ");
INSERT INTO kqp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Menba, kiriɲa kwôrê ka tumô yel niɲ menba, Jésu era sa kam a si ligirji. ");
INSERT INTO kqp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kiriɲa bay tôri gili wo ôbi era sa kam a si ligirji hen iyôŋ menba, harê liji aɲ bay kôl iyôŋ ba: «Na kamɲê a era hen.» Menba, harê liji damaŋ a menba, bay bi gura. ");
INSERT INTO kqp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Menba, Jésu kôlji iyôŋ ba: «Harêŋge ré, na nôbi Jésu, ɗéŋge bôrŋge jal.» ");
INSERT INTO kqp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Menba, Piyêr kôli iyôŋ ba: «Kelma, hena ré na jôbi tiri ba, ju ay tôm bi na erê sa kam a legem a.» ");
INSERT INTO kqp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Menba, Jésu kôli iyôŋ ba: «Era.» Menba, Piyêr herbo bô bato a aɲ ô sa kam a si ligi Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Niɲba, kiriɲa ôbi bô wo kal ge damaŋ hen, menba, harê liri menba, ôbi ay tô erê tô kam a menba, ôbi dô tôri kôliɲ Jésu iyôŋ ba: «Kelma, gôliɲ naɲ en men.» ");
INSERT INTO kqp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Menba, Jésu jé kôbri ɓeriɲni ta aɲ kôli iyôŋ ba: «Ju meremné na wô ayê bôô wom wo dê bi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Menba, kiriɲa bay ɗay bô bato a menba, kal iyer men. ");
INSERT INTO kqp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɓiɲé kêm ka bô bato a hen gel hen iyôŋ, menba, cubu gubarji tôŋ tumô Jésu a aɲ kôl iyôŋ ba: «Ju na Kema Emen bi tiri a men.» ");
INSERT INTO kqp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kiriɲa bay ɗay tera menba, bay saji bô emê wo Génésarêt a. ");
INSERT INTO kqp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɓiɲé ka sa iyére hende to hen gelji Jésu hôn menba, bay jé kôliɲ ɓiɲé naɲ sa iyére iyére menba, bay eraɲ naɲ bay ômɲare kêm sa biri. ");
INSERT INTO kqp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Men, bay uwôlêri bi ré ɗiji ciré hebé kibi bargay kari ka yi serem serem hen mera aɲ ɓiɲé kêm ka hebiri hen na, bay berare. ");
INSERT INTO kqp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisiɲêɲê naɲ *bay derê tô tôô to Emen henaji Jérusalêm a era uɲé Jésu aɲ kôli iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Wô mi a bay tôm ré ɗage sa hara wo môɲêrna ba? Wôsa bay pul kôbriji ré menba, bay ôm are mera.» ");
INSERT INTO kqp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Menba, Jésu uwôlji sara iyôŋ ba: «A kenbay, wô mi a kené ɗage tôô to Emen aɲ wô liɲ hara woŋge ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wôsa Emen kôl iyôŋ ba: ‹Biɲ ibam naɲ yom kwôlê men, kwôni wo kôliɲ ibari naɲ yori kwôlo habiɲ ba bi bay diri.› ");
INSERT INTO kqp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Menba, kenbay ken kôl iyôŋ ba: ‹Kwôni wo kôliɲ ibari naɲ yori iyôŋ ba: «Aŋga ré ené béŋge hen na, na bay a ené biɲ Emen hen.» ");
INSERT INTO kqp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hen iyôŋ na, kwôni bi wo hen li naɲ ibari naɲ yori ré niɲ.› Aɲ turŋge a ba, na aŋga dôri. Na hen iyôŋ a, kené mêniɲ kwôlo Emen aɲ liɲ hara woŋge hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kenbay kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, *ôbi kibi Emen *Esay na kôl kwôleŋge tumô kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Gawrê bay ka hen na, bay ay keben na naɲ kibriji na mera ɗiba bôrji ba kelaŋ naɲ en. ");
INSERT INTO kqp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bay teben hen na ɗéɲ iyôŋ men, aŋga bay geliɲ ɓiɲé hen, kôba na tôô to gawrê a men.› » ");
INSERT INTO kqp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jésu hô uwôga kwônê ɓiɲé ligiri a aɲ kôlji iyôŋ ba: «Toyéŋge kwôlo na kelê hen dô aɲ ken hôn bôri. ");
INSERT INTO kqp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na aŋga gawra ôm hen a lê a ôbi ré *kagemiɲ hen né, niɲba, na kwôlo soo kibri a lê a ôbi ré kagemiɲ hen ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Menba, bay tô Jésu uso ɗa ligiri a aɲ kôli iyôŋ ba: «Kwôlo ju kôl hen tariɲ Parisiɲêɲê hen ba ju hôn ham ba?» ");
INSERT INTO kqp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Menba, Jésu uwôlji sara iyôŋ ba: «Gurô wo yôŋ yôŋ wo na Iban wo derômaraŋ a a dôbê ré na, bay a derêri aɲ naɲ hanêri. ");
INSERT INTO kqp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɗéŋgeji, na bay tu tiɲ ka ɓeriɲ megêrji bay tu tiɲ tô jemna, hena ôbi tu tiɲ ré ɓeriɲ megari ôbi tu tiɲ tô jemna ba, bay wôô kêm a heriɲji bô iyom a.» ");
INSERT INTO kqp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Menba, Piyêr kôliɲ Jésu iyôŋ ba: «Derêni bô gwosore hende to hen niɲa toyé.» ");
INSERT INTO kqp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Menba, Jésu uwôli sara iyôŋ ba: «Kenbay kôba ken nêm henê bô gwosore hende to hen né men ba? ");
INSERT INTO kqp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ken hôn mega wo aŋga ré hena kibi gawra ô bôri a ba, ôbi têriɲ na kaɲ aɲ ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Niɲba, kwôlo soo kibri a na, na kwôlo ôbi eremnéré kwôli gaŋ gaŋ, aɲ na ôbi bi wo hen a lê a bôri ré kagemiɲ hen. ");
INSERT INTO kqp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aŋga hena bô gawra bay a na: ermé kwôlo habiɲ wo yi bô gawra a liri aɲa ôbi ré deriɲ temare men, yiɲ naɲ yébé ɓiɲé men, yiɲare toɲ iyôŋ a tôŋ hen men, gômsiɲ men, piyê kwôlê men, tiiré megari a a men hen. ");
INSERT INTO kqp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Na aŋga li a bô gawra ré kagemiɲ bay a hen ɗiba emê are naɲ kôbi woɲ kworiɲ na a lê a bô gawra ré kagemiɲ hen né.» ");
INSERT INTO kqp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jésu ɗi kiriɲ bay ka hen aɲ ô bô emê wo Tir a men Sidôn a men. ");
INSERT INTO kqp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Menba, iyore to tô môɲ wo Kanan to bô emê iyére hende to hen era ligiri a sa kôli kaŋ ta kôl iyôŋ ba: «Kelma, *kuŋga kelma Dabid, bô tu ɲa tiɲê men, wôsa tunu to habiɲ geliɲ tu môɲnen gusiɲ aɲ yere lere damaŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Niɲba, Jésu uwôle kwôlê wôni sara ré. Menba, bay tôri era ligiri aɲ kôli iyôŋ ba: «Dagere, wôsa hende kaarê kula tôrna gaɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Menba, Jésu kôl iyôŋ ba: «Emen joon, na wô ɓiɲé ka *Israyêl ka yi mega gamgê ka ge kay hen mera.» ");
INSERT INTO kqp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Niɲba, hende era sa cubu gubare tumôri a aɲ kôli iyôŋ ba: «Kelma, en uwôlem li naɲ en men.» ");
INSERT INTO kqp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Menba, Jésu hô kôle iyôŋ ba: «Dé wo kwôni ré ay kwô wo kamrê uwôliɲ garê ré.» ");
INSERT INTO kqp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Menba, hende kôli iyôŋ ba: «Na tiri hari Kelma, niɲba, gaŋ gaŋ ba garê emnê habelê kwô wo heriɲ tô kibi bay iyérji a hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Menba, Jésu kôle iyôŋ ba: «Iyore, ayê bôô woré damaŋ, ô, ariri liɲ béré môɲ bi wo me gey hen iyôŋ.» Kiriɲ bay ka hen menba, môɲne berare men. ");
INSERT INTO kqp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jésu ɗi kiriɲ bay ka hen aɲ ô ɗa naɲ kibi cér wo Galilé. Kiriɲ bay ka hen na, ôbi ɗay ô merê sa keram a. ");
INSERT INTO kqp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Menba, kwônê ɓiɲé era ligiri a naɲ bay lôrê men, bay tu tiɲ men, bay merayê men, ɓiɲé ka iyêl kwôlê ré men, bay ômɲare to gay gay sa ɗiri tumôri a men aɲ ôbi berareji. ");
INSERT INTO kqp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɓiɲé bay ka hen gel aŋga dôri ka ɗê kiriɲ bay ka Jésu li hen: meŋɲê iyêl men, bay merayê berare men, bay lôrê ô ta men, bay tu tiɲ gel kiriɲ a men, menba, bay ay kibi Emen wo Israyêl. ");
INSERT INTO kqp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jésu uwôge bay tôri aɲ kôlji iyôŋ ba: «Tu ɓiɲé ka na lên ɲa damaŋ wôsa na sa subu niɲ wo bay li naɲ en na, aɲ aŋga bay ré ôm ba naɲ. Na ɗiji bi bay ré ô naɲ kurôŋ bôrji ré, wôsa nérji ma naɲê tô geré, aɲ ka pôni ma biɲ iyére ré.» ");
INSERT INTO kqp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Menba, bay tôri kôli iyôŋ ba: «Naa lê iyeŋ derô gwôlê na a nana uɲé aŋgaɲ emê aɲa kwônê ɓiɲé bay ka hen ré emnê uyirê ba?» ");
INSERT INTO kqp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Menba, Jésu eŋgeriji iyôŋ ba: «Ken ôriɲ naɲ mapa iyeŋ ba?» Bay uwôli sara iyôŋ ba: «Nini naɲ mapa jurgem naɲ kam kuyê dê iyôŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Menba, Jésu bi bay biɲ ɓiɲé bay ka hen mô tôŋ terare a. ");
INSERT INTO kqp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jésu eŋge mapa wo jurgem naɲ kam kuyê bay ka hen aɲ liɲ Emen dosé aɲ ɓiilê tôŋ aɲ biɲ bay tôri ré céɲ ɓiɲé bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bay kêm ôm uyirê aɲ bay pô tôri wo ba hen wiinê gwaɲê jurgem. ");
INSERT INTO kqp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓiɲé bay ka ôm mapa bi wo hen na, imɲê na dubu pôrbu, yébé naɲ kamrê ba kwôni dêŋsiji ré. ");
INSERT INTO kqp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Menba, ôbi kôlji bay ré ô iɲ haji niɲ, menba, ôbi ɗay bô bato a ô bô emê wo Magadan a. ");
INSERT INTO kqp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisiɲêɲê naɲ *Sadusiɲêɲê jô kwini Jésu eŋgeriri kwôlê wô séliɲni kôl iyôŋ ba: «Li aŋgaɲ gelé kani ka hena derômaraŋ a béni niɲa gelé.» ");
INSERT INTO kqp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Menba, Jésu uwôlji sara iyôŋ ba: «Perare ba, ken kôl iyôŋ ba, kiya kiriɲ a berarê wô wo tare kuriɲ aɲ li derômaraŋ sê hen ");
INSERT INTO kqp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","men, tô kiriɲ ba, ken kôl emen né uwôŋgê kemnêŋ wô wo gelbarê têl tu kiriɲ dê. Ken hôn gengé kiriɲ hen iyôŋ menba, wô mi a kené hôn bô aŋga ken gel kemnêŋ hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɓiɲé kaɲ bay bô habrê ka haw hen men, bay belé cêgeriji biɲ Emen hen kôba, kôl ciré gey gelé aŋgaɲ gelé men ɗê? Ka baɲ na naɲ aŋgaɲ gelé ka Jonas bi wo hen mera ɗiba ka gelé ka ɗaŋgi kani ré kwôy.» Menba, ôbi ɗiji aɲ ô ta. ");
INSERT INTO kqp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kiriɲa si Jésu naɲ bay tôri ɗay ô tera niɲ, menba, bay tôri gerbaɲ pera mapa kôbriji a tô. ");
INSERT INTO kqp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Menba, Jésu kôlji iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a wô wubere to Parisiɲêɲê naɲ to Sadusiɲêɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Menba, bay tôri eŋgeriɲ yirji kwôlê kôl iyôŋ ba: «Na wô wo nana gerbaɲ pera mapa kôbrena bi aɲa ôbi ré kôliɲ hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jésu toy kwôlê wo bay kôl hen menba, ôbi eŋgeriji iyôŋ ba: «Wô mi a kené erem sa mapa wo ken ôriɲ né hen ba? Kenbay ka ayê bôô woŋge dê hen, ");
INSERT INTO kqp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","kenbay kôba ken hôn né tô sôŋ ba? Ken erem sa mapa wo na bay mera aɲ ɓiɲé dubu bay na ôm hen a ré ba? Men, tôri na ba na ken pô gway iyeŋ men ba? ");
INSERT INTO kqp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Men, ken erem sa mapa wo na jurgem aɲ ɓiɲé dubu pôrbu na ôm hen a ré ba? Men, tôri na ba na ken pô gway yere iyeŋ men ba? ");
INSERT INTO kqp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kamaŋ, ken li iyeŋ a kené hôn wo kwôlo ené kelêŋge hen ré gengiɲ na sa mapa ré, kiriɲa na en kelêŋge iyôŋ ba: ‹Berêŋge wubere to Parisiɲêɲê naɲ to Sadusiɲêɲê hen dô.› » ");
INSERT INTO kqp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hen dema bay ré hôn wo kwôlo Jésu ré kôlji hen na, ré gengiɲ na sa wubere ré niɲba, ré gengiɲ na sa ari gelé ka Parisiɲêɲê naɲ ka Sadusiɲêɲê hen tô. ");
INSERT INTO kqp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kiriɲa Jésu sa biɲ Sésaré Pilip a menba, ôbi eŋgeriɲ bay tôri iyôŋ ba: «Nôbi *Kema Gawra ba, ɓiɲé kôl ené na i ba?» ");
INSERT INTO kqp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Menba, bay uwôli sara iyôŋ ba: «Ka pôni kôl jeré na Ja ôbi lê batêm men, ka pôni kôl jeré na *ôbi kibi Emen *Eli men, ka pôni kôl jeré na ôbi kibi Emen Jérémi men, ka pôni kôl jeré na ôbi kibi Emen wo pôni perê megêri a men.» ");
INSERT INTO kqp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Menba, ôbi hô kôlji iyôŋ ba: «A kenbay ba ken kôl ené na i men ba?» ");
INSERT INTO kqp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Menba, Simô Piyêr kôli iyôŋ ba: «Ju na *Krist Kema Emen wo mô tu geɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Menba, Jésu uwôli sara iyôŋ ba: «Simô kema Jonas, li yi derê wôsa na gawra a yêgê sa kwôlê bi wo hen bem hen né, niɲba, na Iban wo derômaraŋ a a yêgê sari bem hen. ");
INSERT INTO kqp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nôbi en kôlem, Piyêr, ju na keram aɲ na sa keram bi wo hen a ené ɗiɲ tô églis tiɲê ya. Na églis to temare a nêmê mênêre ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na bem lakêêlê ka *emê iyére to derômaraŋ a kôm a aɲ aŋga ju ha sa terare a na ba, a hariɲ ta derômaraŋ a men, ka ju busur sa terare a na ba, a beseriɲ ta derômaraŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Menba, Jésu yêge maa bay tôri bi bay ré kôliɲ kwôni ɗiré na Krist, kwo Emen dôri hen ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ayiɲ tôri kiriɲ bay ka hen na, Jésu kôliɲ bay tôri iyôŋ ba: «Na erê kwôy Jérusalêm a, aɲ surɲê naɲ damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen a gelen gusiɲ damaŋ, aɲ bay a deren, niɲba, sa wôô, subu tori menba, na jê sé kamɲê men.» ");
INSERT INTO kqp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyêr ɓiri ôriɲ wolé nayri aɲ kôli iyôŋ ba: «Kelma, bi aŋga iyôŋgi hen sa sam a ré men, bi Emen ayji aɲ sam a.» ");
INSERT INTO kqp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Niɲba, Jésu bul uɲéri aɲ kôli iyôŋ ba: «Ô kelaŋ naɲ en, Sidan, wôsa ju gey dôben harê bôn a. Ermé wom némiɲ naɲ kwo Emen ré. Ermé wom na kwo gawrê.» ");
INSERT INTO kqp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Hena kwôni ré gey era tôn a ba, bi uwôl yiri aɲ men, ay gurô tagelê wori woɲ temare sari a aɲ era tôn a. ");
INSERT INTO kqp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wôsa kwôni wo gey gemé yiri ba, yiri a mêniɲ, niɲba, kwôni wo uwôl yiri aɲ wô san na, ôbi a sa uɲéri hôriɲ men. ");
INSERT INTO kqp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hena kwôni ré uwoɲ aŋga sa terare a na kêm aɲa ré mêne merê tu geɲ wori ba, na mi a ôbi ré uwoɲ bô a ba? Men, na mi a kwôni ré bé aɲa ré keraŋgiɲ merê tu geɲ wori bi wo hen ba? ");
INSERT INTO kqp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wôsa nôbi Kema Gawra na hera sa terare a na naɲ damɲare to Iban men, naɲ *manê ka derômaraŋ a a men, aɲ i i ba, na sa têbêri sa kôbri naɲ jé lêri, jé lêri. ");
INSERT INTO kqp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na tu kwôlê a ené ena kelêŋge hen, perê ɓiɲé ka na na, ka pôni a ma ré tô aɲ bay a gelen nôbi Kema Gawra na bulo hera naɲ damɲare tiɲê wô emê iyére tiɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wulê jii cêgê menba, Jésu tô si Piyêr naɲ *Jak naɲ yêni Ja aɲ ôriɲ naɲ ci sêd wolé naɲ ɓiɲé ta sa keram wo yêŋgi a. ");
INSERT INTO kqp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kiriɲ bay ka hen na, tu Jésu biliɲ yi gay tirji a, wôsa tiri jeraɲnê môɲ tare to tay iyôŋ men, bargay kari kôba biliɲ bôrê môɲ kiriɲ ka peraŋgi iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kiriɲ bay ka hen na, bay tôri ka subu naɲ ɗi hen gel si *Moyis naɲ *Eli era sa iyêl naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Menba, Piyêr kôliɲ Jésu iyôŋ ba: «Kelma, dô wo na merêŋge na mera. Hena jeré gey ba na lê iyéy gergé subu, pôn tom men, pôn to Moyis men, pôn to Eli a men.» ");
INSERT INTO kqp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piyêr iyêl ba ya tô menba, kiriɲ ka geri ka peraŋge kiriɲ so sa têlji ta, menba, tôô gawra ôm bô a kôl iyôŋ ba: «Kwo ɗebe hen na, na Keman, en piri damaŋ men, ôbi a na yi derê wuɲê a men, toyéŋge kwôlê kibri a.» ");
INSERT INTO kqp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kiriɲa bay tôri bay ka subu naɲ ɗi hen toy tô gawra bi wo hen menba, bay heriɲ aɲ di kwiniji tôŋ wôsa harê liji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jésu uso ligirji a sa hebeji aɲ kôlji iyôŋ ba: «Harêŋge ré, henaŋge ta.» ");
INSERT INTO kqp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kiriɲa bay pô sarji ta menba, bay gel na Jésu a ɗebé pini mera. ");
INSERT INTO kqp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bay herbo tôŋ sa keram a menba, Jésu yêge marji kôlji iyôŋ ba: «Kôliɲge kwôni kwôli pelal wo kené gelo hen né kwôy wo nôbi *Kema Gawra na jiɲ siɲ kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Menba, bay tôri eŋgeriri iyôŋ ba: «Wô mi a *bay derê tô tôô to Emen ré kôl Eli a ré hera tumô *Krist kwo Emen dôri hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Menba, ôbi uwôlji sara iyôŋ ba: «Na tiri, Eli a hera sa ɲanê are kêm hôriɲ naɲ kiniji kiniji. ");
INSERT INTO kqp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Niɲba, en kelêŋge Eli na hera niɲ, niɲba, bay na hôni ré men, bay na liri aŋga bôrji gey a men, na hen iyôŋ a, bay ré giliɲ tun nôbi Kema Gawra gusiɲ men hen.» ");
INSERT INTO kqp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hen dema bay tôri ré hôn wo ôbi ré kôlji na kwôli Ja ôbi lê batêm hen tô. ");
INSERT INTO kqp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kiriɲa Jésu naɲ bay tôri saji ɗa naɲ kwônê ɓiɲé niɲ menba, gawra wo pôni so sa jubu gubari tôŋ tumôri a. ");
INSERT INTO kqp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aɲ kôli iyôŋ ba: «Kelma, bô tu ɲa to keman men, wôsa gesemem liri aɲ geliɲ tiri gusiɲ damaŋ men, liri aɲ ôbi heriɲ bô tare a men, bô kam a a men kwôy kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na en ôriɲ naɲ ɗi ô biɲ bay tôm niɲba, bay nêm berarêri ré.» ");
INSERT INTO kqp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Menba, Jésu kôl iyôŋ ba: «Kenbay ka ayê bôô woŋge naɲ aɲ ken mô wô lê habrê hen na, na merê na wô lê naɲ ken yôd ba? Men, na têê iyeŋ a ené ulê bôn jalê sarŋge a ba? Eraɲge naɲ kema bi ben na.» ");
INSERT INTO kqp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Menba, Jésu ône tunu to habiɲ hende to hen naɲ nééri menba, hende séɲ bô kema bi wo hen a, aɲ ôbi berare kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Menba, bay tôri dôra ligiri a aɲ kôli iyôŋ ba: «Wô mi a na niné nêm dagê tunu to habiɲ hende to hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Menba, Jésu uwôlji sara iyôŋ ba: «Na wô ayê bôô woŋge wo ɗê mera, wôsa na tu kwôlê a ené kelêŋge hen, hena ayê bôô woŋge henaŋ né dê mega gusiɲ siwre iyôŋ hari kôba, kené kôliɲ keram wo hen: ‹Dôriɲ ju ô wolé kiriɲ ka na› kôba ôbi henaŋ ré dôriɲ ɗiba ani ka ré gelêŋge ba ré naɲê.  ");
INSERT INTO kqp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Niɲba, tunu to habiɲ to hen iyôŋgi hen na, na uwôlê Emen men, jerê yi sa emê a men mera a nêmê dagêre.» ");
INSERT INTO kqp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kiriɲa bay tô Jésu daɲ Galilé menba, ôbi kôli bay tôri iyôŋ ba: «Bay a ɓeren nôbi Kema Gawra biɲ ɓiɲé, ");
INSERT INTO kqp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aɲ bay a deren, aɲ sa wôô, aɲ sa subu tori menba, na jê sé kamɲê.» Kiriɲ bay ka hen na, tirji li ɲa damaŋ wô kwôlo ôbi kôlji hen. ");
INSERT INTO kqp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kiriɲa bay sa biɲ Kapêrnayôm a menba, *bay eŋgé wôgê ka iyéy Emen a hen era sa ligi Piyêr a aɲ kôli iyôŋ ba: «*Rabi woŋge ba, têbe wôgê wo *iyéy Emen a ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Menba, Piyêr uwôli sara iyôŋ ba: «Ôbi têbe.» Kiriɲa bay ô ira menba, Jésu ay kwôlê aɲ kôliɲ Piyêr iyôŋ ba: «Na kwôli mi a jeré erem ba? Kilmé ka sa terare a na ba, na si i a têbêji wôgê ba? Na kamniji laba, na kergê ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Menba, Piyêr uwôli sara iyôŋ ba: «Na kergê.» Menba, Jésu kôli iyôŋ ba: «Iyôŋ ba kam iyére ba têbe ré. ");
INSERT INTO kqp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Niɲba, bi bô ɓiɲé ré mêne ré na, ô ju ô ulê kuyi bô cér a aɲ kuyê ka tumô ka já ɓeré hen na, ju bôl kayriji aɲ já uɲé selé to a nêmê têbê wôgê wom men, kuɲê men. Ay, ju ôriɲ têbiɲ wôgê wona.» ");
INSERT INTO kqp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kiriɲ bay ka hen na, bay tô Jésu uso ɗa jôb a ligiri a aɲ eŋgereri iyôŋ ba: «I a na kwo dami bô *emê iyére to derômaraŋ a ba?» ");
INSERT INTO kqp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Menba, Jésu uwôga kema wo dê sa ɗiri derôrji a, ");
INSERT INTO kqp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aɲ kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: hena kené bul ermé woŋge ré aɲ ken yi môɲ kema wo dê bi wo na hen né a men na, ka ulê têrŋge bô emê iyére to derômaraŋ a ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na ôbi á, kwôni wo ermé wori ré yi môɲ kwo kema wo dê bi wo na hen na, ôbi a yé kwo dami bô emê iyére to derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Men, i i wo ɓu kema wo dê mega kwo na hen, yiri a wô kibi henen na, na nôbi a ôbi ré ɓeren a yiri a hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Kwôni wo li aɲ ɓiɲé ka iya ka bi bôrji san a aɲ yi môɲ kamrê iyôŋ ré heriɲ na, hena bay ré hari keram wo dami a tôri a aɲ bay ré uwôli a bô cér a kôba na aŋga dê gôliɲ gusiɲ to Emen a gili hen hena ôbi ré li kwo iya wôni ré kuriɲ. ");
INSERT INTO kqp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɓiɲé ka sa terare a na, mô bô bô emê a wô kibi aŋgaɲ lamê ka gay gay hen. Aŋgaɲ lamê ba, a naɲê ré haji, niɲba, bô emê a kuriɲ sa ôbi lamê gawrê bê a bô têriɲ a hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Hena kôm ley, têm ley a ca lê aɲa jeré li têriɲ na, karji ju bêɲ kelaŋ aɲ ju mô tu geɲ naɲ kunum naɲ merayê dô ɗê wo jeré ô bô tare to yi naɲ kunu hen naɲ kôbem wôô men, têm wôô men hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A hena ré na tum a lê aɲa jeré li têriɲ na, dôre ju uléɲ kelaŋ, ju mô tu geɲ naɲ kunum naɲ tum pôn dô ɗê wo jeré ô bô géhên a to na tare to eŋge bariɲ ré hen naɲ tum wôô hen.» ");
INSERT INTO kqp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Berêŋge dô wô wo kwôni maa kelê ɗiré berê ɓiɲé ka yi môɲ kamrê iyôŋ hen môɲ ani ré, wôsa en kelêŋge, *manê ka derômaraŋ a ka gemji hen na, yi kibi Iban wo derômaraŋ a ta ta wô sarji.  ");
INSERT INTO kqp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wôsa nôbi *Kema Gawra en era sa terare a na, na wô gôliɲ naɲ ɓiɲé ka ge kay hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Na kwôli mi a kené ermé ba? Hena kwôni ré ôriɲ naɲ gamgê arew aɲ kwo pôn ge kay ba, ôbi a ɗé tô ka ba tôre deŋgêse kibi deŋgêse hen sa keram a biɲ kwôni gemé aɲ ɗiɲ yiri ô wogiɲ kwo pôn bi wo ge kay hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na tu kwôlê a ené kelêŋge hen, hena ôbi ré uwoɲni na, ôbi a lê yi derê damaŋ wô sari ɗê tô ka ba tôre deŋgêse kibi deŋgêse hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na ôbi á, Ibareŋge wo mô derômaraŋ a hen kôba, ré gey bi kema pôn nêŋ perê kamrê bay ka hen ré kay ré hen.» ");
INSERT INTO kqp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Hena jeré gel yênem ré li têriɲ ba, ju ô kôli pini. Hena ôbi ré toy kwôlê kem a ba, ju hô bôri mega yênem. ");
INSERT INTO kqp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A hena ôbi ré toy ré ba, ju hô wogé megam wôni pôn réba wôô naɲ ju aɲ mega wo magtubu to Emen kôliɲ hen iyôŋ ná, bi kwôlê kêm ɲaniɲ tumô ɓiɲé wôô réba subu a. ");
INSERT INTO kqp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A hena ôbi ré hô toy ré a sôŋ ba, ken ôriɲ naɲ ɗi tumô églis a. A hena ôbi ré hô toy ré a sôŋ ba, ken bôri na mega ôbi henê Emen né men, môɲ *bay eŋgé wôgê iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na tu kwôlê a ené kelêŋge hen, aŋga ken ha sa terare a na ba, Emen a harê derômaraŋ a men, ka ken buser sa terare a na ba, Emen a beseré derômaraŋ a a men.» ");
INSERT INTO kqp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«En kelêŋge hena ɓiɲé wôô perêrŋge a hen sa terare a na, bi bôrji pôn eŋgeriɲ ani kani na, Iban wo mô derômaraŋ a hen a biji are bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wôsa kiriɲa ɓiɲé wôô ley subu ley daɲji naɲ henen na, nôbi ena perêrji a ya men.» ");
INSERT INTO kqp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyêr uso ɗa ligi Jésu a aɲ kôli iyôŋ ba: «Kelma, hena yênên ré lên habiɲ ba, na ɗé bôn jalê sari a têê iyeŋ ba? Têê jurgem ba?» ");
INSERT INTO kqp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Menba, Jésu uwôli sara iyôŋ ba: «Na têê jurgem mera ré, niɲba, na têê tôre jurgem kini jurgem ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na ôbi á, emê iyére to derômaraŋ a na, yi môɲ kelma wo gey bi manê kari ré dêŋseri aŋgari ka ré yi kôbriji a hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kiriɲa ôbi ay tô deŋsê ari uɲé kari bay ka hen menba, bay eraɲ naɲ gawra wo ré têbê na miliɲôn arew bay. ");
INSERT INTO kqp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ani ka gawra bi wo hen ré têbiɲ ba naɲ menba, kelma bi wo hen ay tôô bi bay ré pôrji keléɲ ôbi naɲ tamni naɲ kamni naɲ ari uɲéri kêm aɲ bay ré eraɲ naɲ larirji sa têbiɲ telare hende to hen kêm. ");
INSERT INTO kqp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Menba, gawra bi wo hen kuriɲ tiɲare tumôri a aɲ kôli iyôŋ ba: ‹Kelma, bô tu ɲa tiɲê men aɲ na têbem kerê seŋge.› ");
INSERT INTO kqp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Menba, kelma bi wo hen bô tiri tô lê ɲa a menba, dô telare hende to hen sari a aɲ aɲ ɗiri ô sari seŋge. ");
INSERT INTO kqp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kiriɲa gawra bi wo hen so iyé kelma hen iyôŋ menba, ôbi jimiɲ naɲ megari wo ré biri gursu sak môj menba, ôbi ɓiri yêêri tu temare a aɲ kôli iyôŋ ba: ‹Já têben telare tiɲê kemnêŋ kemnêŋ.› ");
INSERT INTO kqp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Menba, megari bi wo hen kuriɲ tôŋ tumôri a aɲ uwôlêri kôl iyôŋ ba: ‹Bô tu ɲa tiɲê men aɲ na têbem kerê seŋge.› ");
INSERT INTO kqp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Niɲba, ôbi gey toyé biri ré, aɲ ôriɲ naɲ ɗi ô uwôli daŋgay a kwôy wo ôbi eŋgiɲ telare tori hende to hen kô. ");
INSERT INTO kqp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Menba, kiriɲa megêri gel aŋga ôbi liɲ megari bi wo hen iyôŋ na, yi tu ɲa aɲ bay ô dôriɲ kelma woji aŋga megarji ré la hen. ");
INSERT INTO kqp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Menba, kelma uwôgari aɲ kôli iyôŋ ba: ‹Ôbi bô habrê, wô sômê wo ju sôm san a aɲ en dô telare tiɲê sam a hen na, ");
INSERT INTO kqp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","jôbi kôba ré jeré berê tu ɲa to megam bi wo hen môɲ kwo nôbi en bôriɲ tu ɲa tom hen iyôŋ men ré ba?› ");
INSERT INTO kqp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bô kelma tari aɲ ôbi bi bay ɓiri uwôl daŋgay a kwôy wo ôbi têbiɲ telare tori hende to hen kô. ");
INSERT INTO kqp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iyôŋ ba, hena kené ɗi bôrŋge jal sa megêrŋge a naɲ bôô pôn ré ba, na hen iyôŋ hende to hen a Iban wo derômaraŋ a hen ré ɗé bôri jalê sarŋge a ré men.» ");
INSERT INTO kqp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kiriɲa Jésu dôriɲ ɓiɲé kwôlê hen iyôŋ kô niɲ, menba, ôbi hena emê wo Galilé a ô emê wo Judé a cêgi cér wo Jurdê a. ");
INSERT INTO kqp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kwônê ɓiɲé ô tôri a menba, kiriɲ bay ka hen, ôbi berare bay ômɲare. ");
INSERT INTO kqp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Menba, Parisiɲêɲê ka pôni jô kwini aɲ eŋgeriri kwôlê wô séliɲ bôri kôl iyôŋ ba: «Tôô tona kôl wo iba ré dagê tamni naɲ bô geyé wori hari ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Menba, Jésu uwôlji sara iyôŋ ba: «Na ken dêŋse kwôlo na liɲ bô magtubu to Emen a kôl iyôŋ ba, ayiɲ tôri kiriɲa Emen ɗiɲ tô terare na, ôbi ɗi gawrê iba naɲ iyore ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aɲ ôbi kôl iyôŋ ba: ‹Na wôsa bi wo hen aɲa iba ré ɗé ibari naɲ yori aɲ aɲ ɗé yiri naɲ tamni. Aɲ bay wôô hen na, a yiji na gawra wo pôni.› ");
INSERT INTO kqp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mega hen iyôŋ na, bay na ɓiɲé wôô ré niɲ, niɲba, bay yi mega gawra pôn. Na tôri bi wo hen aɲa kwôni ré bisiré aŋga Emen day liɲ kurôŋgi yi wo pôn hen né hen.» ");
INSERT INTO kqp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Menba, bay hô uwôli sara iyôŋ ba: «A hena ré na hen iyôŋ menba, wô mi a tôô to *Moyis na ré kôl kiriɲa kwôni ré dage tamni ba, ré buru magtubu toɲ bê tôre kôbre a ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Menba, ôbi uwôlji sara iyôŋ ba: «Na wô bô deŋgelé woŋge aɲa Moyis na ré ayiɲ tôô bi kené dage yébérŋge hen ɗiba tumô ba na hen iyôŋ né. ");
INSERT INTO kqp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niɲba, nôbi, en kelêŋge, hena iyore to ré yiɲ naɲ kwôni ré tô aɲa kurôre ré dagere aɲ eŋgiɲ to ɗaŋgi na, ôbi yiɲ na yiɲare toɲ têriɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Menba, bay tôri kôli iyôŋ ba: «A hena kwôli eŋgé wo iba naɲ iyore ré ôm hen iyôŋ ba, bi eŋgé yi naɲ mera ta?» ");
INSERT INTO kqp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Menba, Jésu uwôlji sara iyôŋ ba: «Na ɓiɲé kêm a nêmê henê bô kwôlê bi wo hen iyôŋ né, niɲba, na ka Tunu yêge sari biji hen a henê. ");
INSERT INTO kqp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wôsa aŋga a jôriɲ gawra eŋgé iyore na, tôrji kwône, mamê ka pôni na mamê bô yorji men, ka pôni na gawrê a lê a bay ré yiɲ mamê men, ka pôni yi mamê naɲ bô geyé woji aɲ ayiɲ yirji uwôliɲ béré wô *emê iyére to derômaraŋ a a men. Kwôni wo nêm bê bôri sa kwôlê bi wo hen ba, bi bi.» ");
INSERT INTO kqp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bay eraɲ naɲ kamrê bi Jésu ré uwôl kôbri sarji a men, ré uwôl Emen wô sarji a men. Niɲba, bay tôri nay ɓiɲé bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Menba, Jésu kôlji iyôŋ ba: «Ɗéŋge kamrê bi era yen a ɗiba ken jôreŋgeji ré, wôsa emê to derômaraŋ a yi gengiɲ sa ɓiɲé ka yi mega kamrê bay ka hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Menba, ôbi uwôl kôbri sa kamrê bay ka hen menba, ôbi ô ta hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kema mana wo pôni uso ligi Jésu a aɲ eŋgereri iyôŋ ba: «*Rabi, na mi ka dôri a ené lê aɲa ené môriɲ tu geɲ naɲ kunun ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Menba, Jésu uwôli sara iyôŋ ba: «Wô mi a jeré eŋgeren gengiɲ sa aŋga dôri ba? Emen pôn nêŋ hari a na gawra wo dôri. Hena jeré gey merê tu geɲ ba, ju bi kwôlê sa tôô to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Menba, ôbi kôliɲ Jésu iyôŋ ba: «Na tôô to yôŋ ba?» Menba, Jésu uwôli sara iyôŋ ba: «Já deré gawra ré men, já yiɲ yiɲare toɲ têriɲ né men, já gemsê ré men, já piyê kwôlê ré men, ");
INSERT INTO kqp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","já biɲ ibam naɲ yom kwôlê men, já geyé megam mega wo ju geyiɲ yem hen iyôŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Menba, kema mana bi wo hen hô kôliɲ Jésu iyôŋ ba: «Tôô hende to hen en li kêm niɲ. A na mi a hô ban a sôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Menba, Jésu hô kôli iyôŋ ba: «Hena jeré gey yé gawra wo dôri cerêd ba, ju ô perê ari uɲérem kêm, ju keléɲ aɲ ju ɗi larirji céɲ bay nimré, aɲ já uɲé ari uɲé derômaraŋ a aɲ jôbi ju era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kiriɲa ôbi toy hen iyôŋ menba, tiri mêne aɲ ôbi kuriɲ ô ta wôsa ari uɲé kari mê gaɲ. ");
INSERT INTO kqp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, bi ôbi uɲé ré si bô emê iyére to derômaraŋ a na, iyêre gaɲ. ");
INSERT INTO kqp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","En kelêŋge, jambal a sé lew si tu iyom libra gôliɲ ôbi uɲé bi ré si bô *emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kiriɲa bay tôri toy hen iyôŋ menba, ɗê sarji aɲ bay kôl iyôŋ ba: «Hen iyôŋ ba, i a uɲé gelê ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Menba, Jésu bôrji aɲ kôlji iyôŋ ba: «Tu gawrê ba, na aŋga gawra a nêmê lê ré, niɲba, Emen nêm lê are kêm.» ");
INSERT INTO kqp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Menba, Piyêr kôli iyôŋ ba: «Ju gel, nini ɗéɲ ari uɲérni kêm aɲ nini era tôm, a hen ba, kwoni nibay ba a yé iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Menba, Jésu uwôli sara iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, kiriɲa nôbi *Kema Gawra na sa erê merê sa gagay kenare woɲ hini emê wuɲê sa terare to kôrbi a hen na, kenbay ka môj kibi wôô ka na ken ô tôn a hen kôba, ka sa merê sa gagay kenare woŋge a hen iyôŋ men, wô jerê kwôlê sa tô môɲ wo *Israyêl wo môj kibi wôô hen men. ");
INSERT INTO kqp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aɲ i i wo ɗoɲ iyére tori men, yênêri kaɲ yébé naɲ kaɲ imɲê men, ɗoɲ ibari naɲ yori men, kamni men, sa terare tori men aɲ a men wô san na, ôbi a hô uɲé are bay ka hen têê arew hôriɲ men, a merê tu geɲ naɲ kwini a men. ");
INSERT INTO kqp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɓiɲé kwône ka nà ná ka tumô hen na, haw hen, na bay a yé bay cêgê men, bay cêgê ka haw hen, a herê yé bay tumô men.» ");
INSERT INTO kqp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«*Emê iyére to derômaraŋ a yi némiɲ môɲ ôbi iyéy yagê tiɲaɗor wo jô kiriɲ ô wogé ɓiɲé bi ré ô liri jé iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bay biɲ naɲ bay jé kari bay ka hen mega wulê pôn ba, ré na naɲ selé pôn a men, menba, ôbi biji bay ô bô yagê haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tare uwoy dê menba, ôbi si tu wolé menba, gel ɓiɲé kaɲ bay wogé jé ka ɗaŋgi ka uwoɲji jé ré aɲ môrji seŋge ɗéɲ iyôŋ hen. ");
INSERT INTO kqp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Menba, ôbi kôlji iyôŋ ba: ‹Erêŋge tô megêrŋge bay jé a yaŋ aɲ na sa têbêŋge naɲ tô geréri.› ");
INSERT INTO kqp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Menba, bay ô tô megêrji bay jé a haji niɲ. Ôbi iyéy yagê bi wo hen hô so nô naɲ tu tare men, tare to bôy kôbre a men menba, ôbi uwôɲ ɓiɲé menba, kôlji na mega wo ré kôliɲ ka tumô hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kiriɲa ôbi hô so naɲ perare burgôm menba, ôbi uwôɲ ɓiɲé ka pôni ka môrji seŋge ɗéɲ iyôŋ menba, ôbi eŋgeriji iyôŋ ba: ‹Wô mi a kené ô lê jé kemnêŋ né ba?› ");
INSERT INTO kqp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Menba, bay uwôli sara iyôŋ ba: ‹Nini uwôɲ jé ré aɲa niné ɗebiɲ seŋge hen.› Menba, ôbi hô uwôlji sara iyôŋ ba: ‹Erêŋge bô tiɲaɗor tiɲê.› » ");
INSERT INTO kqp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Kiriɲa tare ta kuriɲ niɲ menba, ôbi iyéy tiɲaɗor hende to hen uwôga mana wori woɲ ôbi berê sa jé hen, bi ré uwôgaji aɲ ré têbiji ayiɲ tô sa ka ré sa cêgê kwôy saɲ sa ka ré sa tô kiriɲ a. ");
INSERT INTO kqp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɓiɲé ka ré era bô yagê perare burgôm hen kôba bay têbiji selé pôn pôn. ");
INSERT INTO kqp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka ré era tô kiriɲ hen na, erem mega wo ciré uɲé ɗê ka ré sa tu tare hen, niɲba, bay têbiji na selé pôn pôn hende to hen men. ");
INSERT INTO kqp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kiriɲa bay uwôɲ selé pôn pôn hen iyôŋ menba, bôrji mêne sa ôbi iyéy tiɲaɗor a. ");
INSERT INTO kqp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Aɲ bay kôl iyôŋ ba: ‹Kamaŋ ka era cêgê hen li jé na tare pôn nêŋ hare menba, ju têbiji némiɲ naɲ nibay ka niné era tô kiriɲ aɲ tare uwoyéni men, nini merêne damaŋ a men hen ba?› ");
INSERT INTO kqp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Menba, ôbi uwôliɲ kwo pôni sara iyôŋ ba: ‹Melaɲnen, nôbi en lêm habiɲ né, wôsa nana biɲ sara wo ené têbêŋge tu tare pôn ba selé ré selé pôn pôn ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eŋge selé tom to pôn hen aɲ ju ô erê wom ham niɲ. Kwo era cêgê hen kôba, na biri na selé pôn môɲ kwo en bem hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aŋga en gey lê naɲ ari uɲéren ba na liɲ né ba? Wô mi a jeré li terbére sa aŋga dôri ka en li hen ba? ");
INSERT INTO kqp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na ôbi á, ka era cêgê ré yé bay tumô men, bay tumô a yé bay cêgê men hen.› » ");
INSERT INTO kqp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kiriɲa Jésu ô ɗiré erê Jérusalêm a naɲ bay tôri ka môj kibi wôô hen menba, ôbi kôlji geré iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ken toy, nana erêŋge na Jérusalêm a hen, aɲ bay a ɓeren nôbi *Kema Gawra biɲ damné kaɲ bay bê kwôbe men, bay derê tô tôô to Emen a men, aɲ bay a ɗén kwôlê woɲ temare san a. ");
INSERT INTO kqp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Men, bay a nôgen biɲ ɓiɲé ka na Jubɲê ré hen men, bay a ayren men, bay a sên naɲ tinêre men, bay a ɓéren sa gurô tagelê aɲ na ma aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yoo kam Jébédé era ligi Jésu a naɲ kamne aɲ hende cubu gubare tumôri a aɲ eŋgereri kwôlê. ");
INSERT INTO kqp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Menba, ôbi kôle iyôŋ ba: «Me gey na mi ba?» Menba, hende uwôli sara iyôŋ ba: «Kamnen ka wôô na na, en gey bi kwo pôn ré sa mô sa kôm woɲ gusurô a men, kwo pôn ré sa mô sa kôm woɲ maa a men bô emê iyére tom a.» ");
INSERT INTO kqp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Menba, Jésu uwôlji sara iyôŋ ba: «Aŋga ken eŋgere hen ba, ken hôn dô bi ba? Ka nêmê yê kam kaɲ bô emê ka na yê hen ba?» Menba, bay uwôli sara iyôŋ ba: «Niɲa nêmê yê seŋge.» ");
INSERT INTO kqp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Menba, ôbi uwôlji sara iyôŋ ba: «Ka yê kam kaɲ bô emê ka na yê hen haŋge, niɲba, kwoɲ merê sa kôbi woɲ gusurô a men, kwoɲ ma a a men na, na nôbi a gengé ré, niɲba, na Iban a gengé kiriɲ wô ɓiɲé kari ka ôbi na ɓu sa têrji niɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kiriɲa bay tôri ka ba môj hen toy kwôlê bi wo hen menba, bôrji tarji sa megêrji bay ka wôô hen. ");
INSERT INTO kqp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Menba, Jésu uwôgeji ɗa kwari a aɲ kôlji iyôŋ ba: «Ken toy, kilmé ka sa terare a na ôm sa ɓiɲé kaji men, ɓiɲé ka damné kôba gôliɲ sarji a men. ");
INSERT INTO kqp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Niɲba, kenbay ba bi yi hen iyôŋ perêrŋge a ré. Perêrŋge a hen aɲa kwôni ré gey yé kwo dami ba, bi yi mana woŋge men, ");
INSERT INTO kqp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","kwo gey yé kwo tumô ba, bi yi lema woŋge men. ");
INSERT INTO kqp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na hen iyôŋ a, nôbi Kema Gawra ené era sa terare a na, na wo ɓiɲé ré yi manê kaɲê ré, niɲba, na wô yé mana woji men, ayê yen biɲ temare têbiɲ sa ɓiɲé ka kwôni a men.» ");
INSERT INTO kqp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kiriɲa Jésu naɲ bay tôri ɗi Jériko aɲ ô ta menba, kwônê ɓiɲé kôbe tôri. ");
INSERT INTO kqp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bay tu tiɲ wôô mô bêŋgê geré aɲ toy wo ré na Jésu a ré erê hen, menba, bay kôl kaŋ a iyôŋ ba: «Bô tu ɲa toni men, Kelma, *kuŋga kelma Dabid.» ");
INSERT INTO kqp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kwônê ɓiɲé nayji aɲ kôlji ré wôm tôŋ, menba, bay hô kôl naɲ néérji a iyôŋ ba: «Bô tu ɲa toni men, Kelma, kuŋga kelma Dabid.» ");
INSERT INTO kqp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Menba, Jésu ɗebu tôŋ, aɲ uwôgaji aɲ kôlji iyôŋ ba: «Na mi a kené gey bi ené li béŋge ba?» ");
INSERT INTO kqp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Menba, bay uwôli sara iyôŋ ba: «Kelma, niné gey gelé kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Menba, Jésu bô tu ɲa toji aɲ hebe tirji aɲ kiriɲ bay ka hen na, bay gel kiriɲ sél aɲ ô tôri a. ");
INSERT INTO kqp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kiriɲa Jésu naɲ bay tôri saji ɗa naɲ Jérusalêm menba, bay sa biɲji Bêtpajé si kwa Keram wo Olibiyé, ");
INSERT INTO kqp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","menba, Jésu jé bay tôri wôô aɲ kôlji iyôŋ ba: «Erêŋge iyére to tumôrŋge a hen aɲ ka uɲé kura hariɲ tôŋ naɲ kemare kware a, bisiréŋgeji ken eraɲ ben. ");
INSERT INTO kqp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hena kwôni ré eŋgeréŋge ba, ken kôli iyôŋ ba: ‹Na Kelma a geyé.› Menba, bay a ɗéŋge ka eraɲ seŋge.» ");
INSERT INTO kqp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Are bay ka hen yi hen iyôŋ, bi kwôlo *ôbi kibi Emen na kôl hen na, ariri ré liɲ. Ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Kôliɲge ɓiɲé ka Siɲô iyôŋ ba: Gel, Kelma woŋge era uɲéŋge hen ya. Na gawra wo kalêri jal aɲ ɗaya sa kura naɲ kemare tôre a.» ");
INSERT INTO kqp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Menba, bay ô aɲ liji mega wo Jésu ré kôlji hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bay ô eraɲ naɲ kura hende to hen naɲ kemare menba, bay bi bargay kaji cêgere a aɲ Jésu ɗay merê sara. ");
INSERT INTO kqp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Menba, ɓiɲé kwône tô bargay kaji bi tô geré wo ôbi ɗa ôriɲ ya hen men, ka pôni piya kôbi gurô sa bi ya a men. ");
INSERT INTO kqp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kwônê ɓiɲé bay ka hen ka pôni ka ge tumô men, ka ba cêgê men aɲ bay kaarê gura ôm iyôŋ ba: «Hosana, heramê yi wô sa *kuŋga kelma Dabid, terê kibi yi wô sa kwo era naɲ hini Kelma hen men, heramê yi wô sa kwo mô ta ɗêŋ derômaraŋ a hen a men.» ");
INSERT INTO kqp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kiriɲa Jésu sa biɲ Jérusalêm menba, ɓiɲé ka Jérusalêm a kêm sun aɲ bay eŋgere iyôŋ ba: «Gawra bi wo hen na i ba?» ");
INSERT INTO kqp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Menba, kwônê ɓiɲé ka ré bari hen uwôlji sara iyôŋ ba: «Na Jésu woɲ ôbi kibi Emen wo Najarêt bô emê wo Galilé a.» ");
INSERT INTO kqp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jésu si derô haba wo *iyéy Emen a menba, ôbi dage ɓiɲé kêm ka eraɲ naɲ aŋgaɲ gara hen men, ka era wô kelé are a men hen. Men, ôbi nôgerê tabel to bay keraŋgê gursu naɲ ari merê ka bay ɗére derare gara hen hee a men. ");
INSERT INTO kqp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Menba, ôbi kôlji iyôŋ ba: «Bay li bô magtubu to Emen a kôl iyôŋ ba: ‹Iyére tiɲê a yé iyéy uwôlê Emen.› Menba, kenbay ken ayre liɲ kini merê bandi.» ");
INSERT INTO kqp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kiriɲ bay ka hen na, bay tu tiɲ naɲ bay moré eraji ligiri a bô iyéy Emen a aɲ ôbi berariji. ");
INSERT INTO kqp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Niɲba, damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen gelji aŋga ɗê sa kiriɲ ka Jésu li kêm hen men, toy kamrê ka bi gura bô iyéy Emen a kôl iyôŋ ba: «Hini emê yi wô sa kuŋga kelma Dabid» hen a men, menba, bôrji mêne. ");
INSERT INTO kqp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Menba, bay kôliɲ Jésu iyôŋ ba: «Ju toy kwôlo bay kôl hen ba?» Menba, ôbi uwôlji sara iyôŋ ba: «Ew, en toy dô. Niɲba, na ken dêŋse kwôlo na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Na ju li aɲ kamrê ka dê dê naɲ kaɲ kibi kuba na heramem hen né ba?› » ");
INSERT INTO kqp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Menba, ôbi ɗiji aɲ, aɲ si ô, aɲ ô wulê Bétani. ");
INSERT INTO kqp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tô kiriɲ wo bay hena Bétani ciré hera Jérusalêm a menba, kurôŋ li Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ôbi gel tôgôre to ɗebe bêŋgê geré menba, ôbi ô ɗa ɗiré karê yêre emê niɲba, ôbi uwôɲ na mare mera. Menba, ôbi kôliɲ tôgôre hende to hen iyôŋ ba: «Ma yê cêgê ré niɲ yôd.» Menba, kiriɲ bay ka hen na, tôgôre hende to hen hay. ");
INSERT INTO kqp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kiriɲa bay tôri gel hen iyôŋ menba, tiniji ge kay aɲ bay kôl iyôŋ ba: «Na iyeŋ a tôgôre hende ré hay lew hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Menba, Jésu uwôlji sara iyôŋ ba: «En kelêŋge na tu kwôlê: hena kené meremné sa ayê bôô woŋge a ré ba, na aŋga ken gel sa tôgôre a hen, a kené lê mera ré niɲba, hena kené kôliɲ keram wo hen ‹Dô yem ju ô kuriɲ bô cér a› kôba, ariri a liɲ. ");
INSERT INTO kqp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hena kené bi bôrŋge sa Emen a ba, aŋga yôŋ yôŋ ka ken uwôli ba, ka uɲé.» ");
INSERT INTO kqp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jésu ô derô haba wo iyéy Emen a ô dôriɲ ɓiɲé kwôlê menba, damné kaɲ bay bê kwôbe naɲ surɲê eraji ligiri a aɲ kôli iyôŋ ba: «Na i a bem tôô hende to ju liɲ are kêm hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Menba, ôbi uwôlji sara iyôŋ ba: «Nôbi kôba na eŋgeréŋge kwôlê pôn men, hena kené uwôlen sara dema ené kelêŋge na ba i a ben tôô hende to en liɲ are bay ka kêm hen ba men. ");
INSERT INTO kqp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Batêm to Ja na liɲ ɓiɲé hen na, na hena na derômaraŋ a laba, na ligi gawrê a ɗi ba?» Menba, bay nariɲ perêrji a kôl iyôŋ ba: «Hena nana kôl ré hena na derômaraŋ a ba, ôbi a kelê wô mi a na nana bi bôrna sari a ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A hena nana kôl ré hena na ligi gawrê ba, nana hôn dô wo ɓiɲé ré geyé ré, wôsa bay bô Ja mega ôbi kibi Emen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Menba, bay kôliɲ Jésu iyôŋ ba: «Nini hôn né.» Menba, ôbi kôlji iyôŋ ba: «Iyôŋ ba, nôbi kôba, na kelêŋge na naɲ tôô to yôŋ a ené liɲ are bay kêm hen né men.» ");
INSERT INTO kqp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jésu hô kôlji iyôŋ ba erméŋge sa kwôlo na kelê hen: «Gawra wo pôni naɲ kamni wôô, menba, ôbi kôliɲ kwo suri iyôŋ ba: ‹Keman, kemnêŋ jôbi ju ô bô tiɲaɗor a.› ");
INSERT INTO kqp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Menba, kemari bi wo hen kôli iyôŋ ba: ‹Na erê ré, baba.› Sem cêgê menba, ôbi hô erem sa kôli bi wo hen a, menba, ô bô tiɲaɗor a. ");
INSERT INTO kqp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ibarji kôliɲ ôbi cêgeri na mega bi wo ôbi ré kôliɲ kwo suri hen iyôŋ men. Niɲba, kemari wo cêgê hen kôli iyôŋ ba: ‹Na erê, baba.› Menba, ôbi ô ré men. ");
INSERT INTO kqp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hen ba, kami gawra bay ka wôô hen na, na kwo yôŋ a lê tôô ibari ba?» Menba, bay uwôli sara iyôŋ ba: «Na kwo tumô hen.» Menba, Jésu hô uwôlji sara iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, *bay eŋgé wôgê naɲ bay yiɲ yiɲare toɲ têriɲ a sé bô *emê iyére to Emen a tumôrŋge. ");
INSERT INTO kqp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wôsa Ja ôbi lê batêm era sa geléŋge geré woɲ derôre, menba, ken bi bôrŋge sari a ré niɲba, na bay eŋgé wôgê naɲ bay yiɲ yiɲare toɲ têriɲ a bê bôrji sari a ɗi. Ken hôn are bay ka hen dô a men, niɲba, ken bul cêgerŋge biɲ têriɲ ré wô biɲ bôrŋge sari a ré.» ");
INSERT INTO kqp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na hô kelêŋge gwosoy kwôlo ɗaŋgi a sôŋ: «Gawra wo pôni na ôbi iyéy yagê tiɲaɗor, ôbi ay haba woɲ gerem sara men, pi iyom wô uwôriɲ yêre men, li iyére toɲ gemé yagê bi wo hen sara. Ôbi biɲ bay yagê tiɲaɗor yagê wori bi wo hen aɲ bay têbri naɲ geserê geserê aɲ ɗiɲ yiri ôriɲ kergare. ");
INSERT INTO kqp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kiriɲa kibi kelanê terê tiɲaɗor hende to hen, ba ɗa niɲ menba, ôbi jé manê kari ligi ɓiɲé bay ka hen a bi ré ô eŋgé kwa yê tiɲaɗor hende to hen eraɲ biri. ");
INSERT INTO kqp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kiriɲa bay jé bay ka hen saji menba, bay gemé yagê tiɲaɗor hen, pôrji manê ka ôbi iyéy tiɲaɗor hende to hen, aɲ bay sê kwo tumô men, bay duu kwo jôgiɲ wôô men, bay gôbe kwo subi duu naɲ keram men. ");
INSERT INTO kqp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Menba, ôbi iyéy tiɲaɗor hende to hen hô jé manê kari ka ɗaŋgi kwône ɗê ka ré tumô hen aɲ menba, ɓiɲé bay ka hen pôrji sê men, duu ka pôni a men mega wo bay ré liɲ ka tumô hen iyôŋ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Gerɲéri menba, ôbi iyéy tiɲaɗor bi wo hen jé kemari woɲ bôri yirji a aɲ kôl iyôŋ ba: ‹Ôbi ba, bay a kemnaɲ tini tô.› ");
INSERT INTO kqp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Niɲba, ɓiɲé bay ka hen gelji kemari menba, bay kôl iyôŋ ba: ‹Na ôbi emê cibré ibari ôbi a na, eraŋge na deréŋgeri aɲ na baɲge naɲ aŋga cibré ibari a hen kêm.› ");
INSERT INTO kqp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Menba, bay ɓiri ôriɲ kelaŋ naɲ yagê tiɲaɗor aɲ diiri. ");
INSERT INTO kqp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hen ba, kiriɲa ôbi iyéy tiɲaɗor hende to hen hera ba, a liɲ ɓiɲé bay hen iyeŋ niɲ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Menba, bay uwôli sara iyôŋ ba: «Ôbi a deré ɓiɲé kaɲ bay bô habrê bay ka hen aɲ ôbi a biɲ ka ɗaŋgi yagê bi wo hen aɲ kini terêre a ba, bay a biri yêre men.» ");
INSERT INTO kqp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Menba, Jésu kôlji iyôŋ ba: «Na ken dêŋse kwôlo na liɲ bô magtubu to Emen a hen né ba? Bay na kôl iyôŋ ba: ‹Keram bi wo bay ɗé iyére na kaɲni hen na, ôbi a hô yé keram woɲ ɗé tô iyére. Na Kelma a lê are bay ka hen aɲ na aŋga dami gaɲ.› ");
INSERT INTO kqp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na ôbi wo hen aɲa ené kelêŋge, emê iyére to Emen, a dôriɲ kôbreŋge a aɲ aɲ bay a biɲ tô yê wo ɗaŋgi wo a bê kwôlê sa aŋga gengiɲ sa emê iyére hende to hen.  ");
INSERT INTO kqp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kwôni wo yôŋ yôŋ wo kuriɲ sa keram bi wo hen na, gerɲéri a tiɲ men kwo keram bi wo hen kuriɲ sari a ba, a hederéri men.» ");
INSERT INTO kqp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kiriɲa damné ka bay bê kwôbe naɲ Parisiɲêɲê toy gwosoy kwôlê bi wo hen iyôŋ menba, bay hôn wo Jésu ré kôl gengiɲ na sarji. ");
INSERT INTO kqp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Menba, bay woge geré wo ciré ɓeréri, niɲba, bay hariɲ kwônê ɓiɲé wôsa ɓiɲé bay ka hen, bô Jésu mega ôbi kibi Emen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jésu hô ay gwosoy kwôlo ɗaŋgi aɲ kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«*Emê iyére to derômaraŋ a yi môɲ kelma wo ɓu sa tê gerê iyére to kemari iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ôbi jé bay jé kari ré ô uwôgera ɓiɲé ka ré era kini gerê iyére hende to hen a menba, ɓiɲé bay ka ôbi jé uwôgêji hen kaɲ era. ");
INSERT INTO kqp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ôbi hô jé bay jé ka ɗaŋgi ré hô ô kôliɲ ɓiɲé ka ré era kini gerê iyére a hen, iyôŋ ba, emê ré liɲ kô tôŋ niɲ, wôsa en duu na kelbê naɲ uré ka uwoseré aɲ emê liɲ kô tôŋ niɲ, eraŋge bi na sa emêŋge. ");
INSERT INTO kqp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ɓiɲé ka bay jé uwôgêji hen na, bay kaɲ uwôgê bi wo hen kibi bay jé aɲ kwo pôni ô bô yagê wori a men, kwo pôni ô wô lê jeŋga tori men. ");
INSERT INTO kqp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka pôni pôrji bay jé bay ka hen sêji aɲ derji. ");
INSERT INTO kqp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bô kelma bi wo hen tari aɲ ôbi jé asgarɲê kari ô deré bay deré temare bay ka hen men, uwoyriɲ sa iyérji a men. ");
INSERT INTO kqp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Menba, ôbi kôliɲ bay jé kari iyôŋ ba: ‹Emê liɲ kô niɲ, niɲba, ɓiɲé ka ené uwôgeji hen kaɲ sa. ");
INSERT INTO kqp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Erêŋge jêrê geré aɲ ɓiɲé ka, ka uɲéji ba, ken kôlji ré era kini gerê iyére a na.› ");
INSERT INTO kqp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Menba, bay jé ôrji tô geré aɲ kôliɲ ɓiɲé kêm ka bay uwoɲji hen ré eraji kini gerê iyére a aɲ bô iyére wôn jê jê ta. Perê ɓiɲé bay ka bay uwôgaji hen na, bay bô habrê ya men, bay bô derê kôba ya men.» ");
INSERT INTO kqp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Kelma era ira ɗiré sa gelé ɓiɲé ka ré mô kibi emê kini gerê iyére a hen, menba, ôbi gel gawra wo pôni wo dôba bargay kari kaɲ erê kini gerê iyére a ré hen, ");
INSERT INTO kqp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","menba, kelma kôli iyôŋ ba: ‹Melaɲnen, ju dôba bargay kam kaɲ erê kini gerê iyére a ré menba, ju li iyeŋ a jeré sa na ba?› Menba, gawra bi wo hen uwôɲ kwôlê woɲ kelê ré. ");
INSERT INTO kqp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Menba, kelma kôliɲ manê kari iyôŋ ba: ‹Ɓeréŋgiri ken haarê têri naɲ kôbri aɲ ken ôriɲ ô ulê nô dilemne a. Na kiriɲ ka ɓiɲé sômniɲ men, ômiɲ kaɲniji mêêrê mêêrê ya men hen.› ");
INSERT INTO kqp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na ôbi á, bay ré uwôgê ɓiɲé kwônê, niɲba, bay a perê na côb iyôŋ mera.» ");
INSERT INTO kqp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Menba, Parisiɲêɲê ô ermé na ba, ciré lê iyeŋ a, ciré ɓeré Jésu sa kwôli kelêri a ba? ");
INSERT INTO kqp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Menba, bay jé ɓiɲé kaji naɲ ka *Hérôd ô ligi Jésu a aɲ kôli iyôŋ ba: «*Rabi, nini hôn wo kwôlo jeré kôl hen na, ré na tu kwôlê men, ju geliɲ ɓiɲé kwôlê woɲ tiri wo Emen gey hen a men, wôsa jôbi na, ju hariɲ kwôlo bay kôl gengiɲ sam hen né men, ju dô tu kwôni ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iyôŋ ba, ju kelêni kwôlo bôm a niɲa toyé: Têbiɲ kelma wo dami Sésar wôgê ba tôô tona gey hare ba?» ");
INSERT INTO kqp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jésu hôn ermé woji wo habiɲ bi wo hen tumô niɲ aɲ uwôlji sara iyôŋ ba: «Kenbay ka kebreŋge wôô wôô hen, wô mi a kené sélen hen iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Benge selé to bay têbiɲ wôgê hen pôn na na gelé.» Menba, bay eraɲ naɲ selé pôn sa gili. ");
INSERT INTO kqp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Menba, ôbi kôlji iyôŋ ba: «Sa gawra naɲ aŋga bay ɗi yi selé hende to hen to na ba, gengiɲ na sa i ba?» ");
INSERT INTO kqp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Menba, bay uwôli sara iyôŋ ba ré gengiɲ na sa kelma wo dami Sésar. Menba, ôbi kôlji iyôŋ ba: «Iyôŋ ba, aŋga na ka Sésar ba, ken biɲ Sésar men, ka na ka Emen ba, ken biɲ Emen.» ");
INSERT INTO kqp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kwôlo Jésu kôlji hen na, ɗê sarji aɲ bay ɗiri aɲ ô ta. ");
INSERT INTO kqp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","*Sadusiɲêɲê kôl ɓiɲé ka ma ré jê sé kamɲê ré. Wulê bi wo hen na, bay eraji ligi Jésu a aɲ eŋgeriri kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Rabi, tôô to *Moyis na kôl iyôŋ ba: ‹Hena ɓiɲé ré wôô tô yêniɲare a aɲa kwo pôni ré ma ɗi tamni cêgeri a baa yê kema naɲ tu ba bi yêni wo ré baa cêgeri a hen ré eŋne aɲ ré yêɲ kamrê biɲ yêni wo ma hen.› ");
INSERT INTO kqp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aɲ mega wo sa iyére toni a na, ɓiɲé ka pôni na jurgem tô yêniɲare a, menba, kwo iyêri eŋge iyore bay yê ré tô menba, ôbi ma ɗere cêgiri a, yêni woɲ ôbi cêgeri eŋne. ");
INSERT INTO kqp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Menba, ôbi kôba ma ɗere cêgeri a men, ôbi cêgeri wori kôba, na hen iyôŋ hende to hen kwôy wo ɓiɲé bay ka jurgem tô yêniɲare a hen maji kêm. ");
INSERT INTO kqp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sem cêgeriji a menba, iyore hende to hen kôba, ma men. ");
INSERT INTO kqp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mega wo yi hen iyôŋ hen ba, wulê wo ɓiɲé ka ma a sa jê sé kamɲê hen na, kwo yôŋ a na kurôre pôn ba? Wôsa bay jurgem toji hende to hen, na na kwôrɲêre.» ");
INSERT INTO kqp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Menba, Jésu uwôlji sara iyôŋ ba: «Kwôli kelêrŋge saŋgiɲ naɲ ken nono. Wôsa ken hôn kwôlo yi bô magtubu to Emen a hen ré men, ken hôn ibé iyêrê wo Emen né a men. ");
INSERT INTO kqp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wôsa wulê wo ɓiɲé ka ma a sa jê sé kamɲê hen na, imɲê a eŋgé yébé ré men, yébé a eŋgé imɲê ré a men, wôsa bay a yé môɲ manê ka Emen derômaraŋ a iyôŋ mera. ");
INSERT INTO kqp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kwôlo gengiɲ sa jê sé kamɲê wo ɓiɲé ka ma hen ba, ken dêŋse kwôlo Emen na kelêŋge hen né ba? Ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Ena Emen wo si *Abraham, Isak naɲ Jakwôb tebe hen.› Ɓiɲé ka ma na, tebe Emen né, niɲba, na ka mô tu geɲ a tibri ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓiɲé ka ɗebu ya aɲ toy kwôlo Jésu kôl hen na, ɗê sarji. ");
INSERT INTO kqp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kiriɲa Parisiɲêɲê toy wo Jésu ré ɓu kibi Sadusiɲêɲê hen iyôŋ menba, bay daɲ sarji aɲ ôrji uɲé Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aɲ kwo pôni perêrji a na ôbi derê tô tôô to Emen wo pôni eŋgeriɲ Jésu kwôlê wô séliɲ bôri kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Rabi, tôô to dami ɗê megêre ba na to yôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Menba, Jésu uwôli sara iyôŋ ba: «Já peré Kelma wom Emen naɲ bôô pôn men, naɲ tunum kêm men, naɲ ermé wom kêm a men. ");
INSERT INTO kqp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Na tôô to tumô to ɗê megêre a hen. ");
INSERT INTO kqp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","To ɗaŋgi to némiɲ naɲ to tumô hen a na: Gey megam mega wo ju geyiɲ yem hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tôô hende to wôô hen na, ay tô tôô to ba hen naɲ kwôlo bay kibi Emen na kôl hen kêm bô niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cêgê menba, Jésu eŋgeriɲ Parisiɲêɲê ka daɲ kwari a hen kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Na kwôli mi a kené erem sa *Krist, kwo Emen dôri hen a ba? Ôbi na kuŋga i ba?» Menba, bay uwôli sara iyôŋ ba: «Ôbi na *kuŋga kelma Dabid.» ");
INSERT INTO kqp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Menba, Jésu kôlji iyôŋ ba: «Iyôŋ ba, wô mi a Tunu toɲ hendi bô bôrê na ré biɲ kelma Dabid uwôgeri ‹Kelma›, aɲ kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Kelma Emen na kôliɲ Kelma wuɲê iyôŋ ba: «Sa mô kôben woɲ gusurô. Kwôy wo na biɲ bay barem a yé aŋgaɲ sêlê têm.» › ");
INSERT INTO kqp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","A hena kelma Dabid ré uwôgeri ‹Kelma› ba, a lê iyeŋ a ôbi ré yé kuŋgari sôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Menba, kwôni nêm ulêri kwôlê wôni sara ré. Ayiɲ tôri wulê bi wo hen na, kwôni woge wô eŋgeriɲ Jésu kwôlê ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jésu kôliɲ kwônê ɓiɲé naɲ bay tôri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«*Bay derê tô tôô to Emen naɲ Parisiɲêɲê na, na bay derê tô tôô to Emen to *Moyis. ");
INSERT INTO kqp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iyôŋ ba, ken biŋgeji kwôlê men, kwôlê kêm wo bay kelêŋge hen na, ken li ariri a men, niɲba, bi jé lêreŋge yi môɲ kwoji hen iyôŋ né, wôsa bay kôl kwôlê menba, bay ba, li ariri ré men. ");
INSERT INTO kqp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bay pô aŋga néy néy ɗiɲ ɓiɲé sarji a, menba, bay ba, hebe ani naɲ kema kôbriji iyôŋ né kwôy. ");
INSERT INTO kqp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Men, are kêm ka bay li hen na, na wô geliɲ yirji tu ɓiɲé a mera. Aɲ aŋga bay ha wô uwôliɲ Emen hen na, bay li dami ɗê ka ɓiɲé kêm. Men, bargay kaji ka bay tôbe hen kôba, bay ɗi kibriji yêŋnê ɗê ka ɓiɲé kêm a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kini emê are a men, bô *iyéy daɲare a a men na, bay gey na merê tumô ɓiɲé ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Men, bay gey na wo ɓiɲé ré liji dosé tu wolé a men, bay ré uwôgerêji ‹*Rabi› men hen. ");
INSERT INTO kqp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Niɲba, kenbay ba, ken ɗi kwôni uwôgêŋge ‹Rabi› ré, wôsa Rabi woŋge na pôn hari, aɲ kenbay kêm kena yênê. ");
INSERT INTO kqp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Men, kwôni wo sa terare a na ba, ken uwôgeri ‹ibarni› ré, wôsa Ibareŋge na pôn nêŋ hari ôbi a merê derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Men, ken bi kwôni uwôgêŋge ‹ôbi derê tumôrni› ré, wôsa ôbi derê tumôrŋge na pôn nêŋ hari, ôbi a na *Krist, kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kwôni wo na kwo dami perêrŋge a na, ôbi a na mana woŋge. ");
INSERT INTO kqp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wôsa kwôni wo gey derê sari ta ba, bay a heraɲ naɲ ɗi tôŋ, niɲba, kwo dôbe sa ba, bay a biri a derê sari ta men.» ");
INSERT INTO kqp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge, wôsa ken lugu kibi geré *emê iyére to derômaraŋ a jôriɲ ɓiɲé, menba, ken gey erê bô ré men, ken jôriɲ ka ɗaŋgi sé bô a a men.»  ");
INSERT INTO kqp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge wôsa ken lam yébé kaɲ mamê eŋgiɲ iyére toji men, ken uwôl Emen ta ta na ɗéɲ iyôŋ wô tu ɓiɲé mera a men. Na ôbi á, bay ré jerê kwôlê sarŋge a damaŋ hen.» ");
INSERT INTO kqp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge wôsa ken gôr bô cér naɲ sa terare wô wogé ɓiɲé bi ré bi bôrji sa tôô toŋge a, aɲ kiriɲa ken uwôɲ kwôni niɲ menba, ken liri ôbi yi na kwo a erê bô tare a gelêŋge aɲ sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Kenbay bay derê tumô kiriɲ kaɲ bay tu tiɲ hen gusiɲ yi wô sarŋge, wôsa ken kôl iyôŋ ba: ‹Hena kwôni ré dusu yiri naɲ *iyéy Emen ba, ré li ani ré, niɲba, hena kwôni ré dusu yiri naɲ lôr wo bô iyéy Emen a hen dema ariri ré liɲ tô hen.› ");
INSERT INTO kqp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kwôbrê naɲ bay tu tiɲ, lôr a ɗê iyéy Emen to li aɲ lôr bi wo hen yiɲ naɲ jeŋgêri hen ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Men, ken hô kôl iyôŋ ba: ‹Hena kwôni ré dusu yiri naɲ kini gusulé gesamne ba, ré li ani ré, niɲba, hena kwôni ré dusu yiri naɲ aŋgaɲ bé ka yi sara hen dema ariri ré liɲ tô.› ");
INSERT INTO kqp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bay tu tiɲ aŋgaɲ bé a ɗê kini gusulé gesamne ka li aɲ aŋgaɲ bé bay ka hen yiɲ naɲ jeŋgêrji hen ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na ôbi á, kwôni wo ré dusu yiri naɲ kini gusulé gesamne ba, ré dusu yiri na naɲ aŋga yi sara hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Men kwôni wo ré dusu yiri naɲ iyéy Emen ba, ré dusu yiri na naɲ kwo mô bôre a hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A hena kwôni ré dusu yiri naɲ derômaraŋ a ba, ôbi dusu yiri na naɲ gagay kenare wo Emen men, na naɲ kwo mô sara hen a men.» ");
INSERT INTO kqp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge, wôsa ken bi kibi aŋga môj kaŋge kaɲ aŋgaɲ ɲa kiliɲ ka na si tamla men, uu men, têrêre aɲ ken kaɲ lê aŋga dôri ka yi bô tôô a hen, bay a na: lê aŋgaɲ derôre men, lê ka dôri men, lê are naɲ bôô pôn a men hen. Na are bay ka hen a ré kené lê men, liɲ tô ka ɗaŋgi ka ba hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kenbay bay tu tiɲ ka ken dô tumô megêrŋge hen, ken irge kam wô pôriɲ kam aŋga dê dê ka yi bô a hen aɲ dema kené yê menba, ken soy jamal naɲ yere kêm ta men.» ");
INSERT INTO kqp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge wôsa ken pul cêgi karbé toɲ yê are men, cêgi dasa kaŋge mera menba, bôrji ba ken bi na aŋga ken gômse hen men, ka ken li tu bôriyare sara hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","*Parisiɲê woɲ ôbi tu tiɲ, pul bô dasa naɲ asêt wom sél, menba, cêgeriji kôba, ré sélé men tô.» ");
INSERT INTO kqp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge wôsa ken geliɲ môɲ sa kamɲê ka bay liji bôrê nô aɲ dô gelé haji niɲba, bôrji ba, na ibé men, aŋga uyêy a yé ya hen. ");
INSERT INTO kqp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kenbay kôba, tu ɓiɲé a ba ken li yerŋge môɲ ɓiɲé kaɲ derôre iyôŋ, niɲba, bôrŋge a ba, kena bay kelê kwôlê kebreŋge wôô wôô men, bay bô habrê a men.» ");
INSERT INTO kqp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kenbay bay derê tô tôô to Emen naɲ Parisiɲêɲê kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, gusiɲ yi wô sarŋge wôsa ken ɲan kamɲê ka bay kibi Emen men, ken ɲan sa kamɲê ɓiɲé kaɲ bay lê aŋgaɲ derôre hen dô a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aɲ ken kôl iyôŋ ba: ‹Hena na niné ya wulê wo balêrni na deriɲ bay kibi Emen hen na, na niné biɲ naɲ ci sara ré.› ");
INSERT INTO kqp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hen iyôŋ ba, ken uwôl kwôlê sarŋge a kenbay gaŋ men, ken gel wo kené na kwôŋgê ɓiɲé kaɲ bay deré bay kibi Emen bay ka hen men. ");
INSERT INTO kqp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dô, lêŋge hen iyôŋ yôd yôd bi gôliɲ kwo môɲêrŋge aɲ. ");
INSERT INTO kqp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kenbay ka ken yi môɲ jênêre iyôŋ hen, ka lê iyeŋ a, kené ba erê bô tare toɲ *Géhên a ba? ");
INSERT INTO kqp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na tôri bi wo hen aɲa ené jéɲ naɲ bay kibi Emen men, naɲ bay tu melênê men, bay derê tô tôô to Emen béŋge aɲ ka deré ka pôni men, ka ɓéré ka pôni kabrê gurô men, ka yêmnê ka pôni ré tinêre bô iyéy daɲare toŋge a men, ka derê sa tê ka pôni naɲ sa iyére iyére a men. ");
INSERT INTO kqp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aɲ bi kwôlê ré ɓu sarŋge wô kwôbri ɓiɲé kaɲ bay lê aŋgaɲ derôre wo bay na bi sa terare a na, ayiɲ tôri sa kwo Abêl ôbi lê aŋgaɲ derôre hen kwôy saɲ sa kwo Jakari woɲ kema Baraki wo na ken diri perê iyéy Emen naɲ kini bê kwôbe hen. ");
INSERT INTO kqp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na tu kwôlê a ené ena kelêŋge hen are bay ka kêm ka na ken li hen na, kwôliji a ɓeré sa ɓiɲé ka haw hen.» ");
INSERT INTO kqp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Ɓiɲé ka Jérusalêm, ɓiɲé ka Jérusalêm, kenbay ka ken duu bay kibi Emen men, ken gôbe ka bay jéji legerŋge a hen, duu naɲ jerew a men hen, têê kwône en woge ené dayêŋge môɲ tôôre daɲ sa kamne tô mesérére a iyôŋ, niɲba, ken gey ré. ");
INSERT INTO kqp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dô haw hen na, Emen a derê kôbri aɲ ɗéŋge sa iyére toŋge kôbreŋge a. ");
INSERT INTO kqp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na tu kwôlê a ené ena kelêŋge hen, ka gelen ré niɲ kwôy wo wulêri a nêmê aɲ ka kelê iyôŋ ba: ‹Terê kibi yi sa kwo era naɲ hini Kelma hen.› » ");
INSERT INTO kqp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jésu so bô *iyéy Emen a ɗa erê ta niɲ, menba, bay tôri uso ligiri a aɲ gili iyéy Emen to ré jibiɲ yi kêm hen. ");
INSERT INTO kqp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Menba, ôbi kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: iyére hende to ken gel kêm yi hen na, keram wôni wo a ba ta sa megari a ba naɲ, bay kêm a mêniɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jésu mô sa Keram wo Olibiyé, menba, bay tôri era ligiri a aɲ ɓiri ôriɲ wolé aɲ eŋriri kwôlo ɓu bôrji kôli iyôŋ ba: «Kelêni, wulê wo yôŋ a, are bay ka kêm hen ré sa ba men, mi a gelé wo herarem ré ba ɗa niɲ men, sa terare ré ta kerê niɲ ba a men.» ");
INSERT INTO kqp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Menba, Jésu uwôlji sara iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a, ɗiba ken ɗi kwôni lamêŋge ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wôsa ɓiɲé kwône a era naɲ henen, a kelê iyôŋ ba: ‹Na nôbi a na *Krist, kwo Emen dôri hen.› Aɲ bay a lamiɲ ɓiɲé kwônê. ");
INSERT INTO kqp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka toyé néé kumbul naɲ kwôli kumbul wo ôm ɗa, niɲba, ken ɗi tu melênê sa yerŋge a, ɗiba ken ɗi bôrŋge hare ré, wôsa are bay ka hen a sa môj môj dem, niɲba, na gerɲé wulê bi wo hen né tô. ");
INSERT INTO kqp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tô yê pôn a lê kumbul naɲ tô yê wo ɗaŋgi men, sa iyére pôn a séɲ naɲ to ɗaŋgi men, terare a yebagiɲ naɲ sa iyére gay gay men, kurôŋ a lê kiriɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Niɲba, are bay ka kêm hen na, yi mega yê wo ay tô lê iyore iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Bay a ôriɲ naɲ ken tumô kilmé bi bay ré geléŋge gusiɲ men, bay a deré ka pôni men, bay a tôrɲêŋge naɲ kiriɲ kiriɲ a men, wô kibi henen. ");
INSERT INTO kqp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na ôbi á, ɓiɲé kwône ré ɗéɲ ayê bôô woji men, bay a pôriɲ sarji men, bay a tôrɲiɲ yirji a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bay kibi Emen kaɲ bay benare kwône a soo, aɲ bay a lamê ɓiɲé kwônê. ");
INSERT INTO kqp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Men, ɓiɲé a lê habrê sa megari a megari a kwôy wo peré wo yi bô ɓiɲé ka kwôni a hen a jalê. ");
INSERT INTO kqp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Niɲba, kwôni wo ɓu bôri iyêre kwôy deriɲ kibi ba, ôbi a gelê. ");
INSERT INTO kqp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bay a ulê béré Kwôlo Dôri wo gengiɲ sa *emê iyére to derômaraŋ a hen naɲ kiriɲ kiriɲ sa terare a na, biɲ tô yê ɓiɲé kêm dema sa terare ré kerê tô.» ");
INSERT INTO kqp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ka gelé aŋga habiɲ ka mêne kiriɲ hen, mega wo *ôbi kibi Emen Daniyêl na kôl kwôliji ca tumô ré yé kiriɲ ka yi naɲ jeŋgêrji hen. (Kwôni wo dêŋse kwôlê bi wo hen na, bi hôn bô kwôlê bi wo hen dô.) ");
INSERT INTO kqp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Iyôŋ ba, bi ɓiɲé ka Judé ba, ge sa keram a men, ");
INSERT INTO kqp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","kwôni wo mô tô tunu a nô ba, bi era ira wô erê ayê ani bô iyére tori a ré niɲ men, ");
INSERT INTO kqp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","kwôni wo ɗebe bô yagê wori ba, a uɲé kini hera ira wô ayê bargay kari ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wulê bi wo hen na, bô emê wo dami a lê yébé kaɲ bay kwoo men, ka kamniji yi kuba ba ya tô hen a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Uwôlêŋge Emen bi wulê bi wo ka geriɲ hen na, bi yi naɲ terbére a ré men, naɲ sa *sa merê ta a ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wôsa wulê bi wo hen na, bô emê wo ɓiɲé a uɲé hen na, na bô emê wo dami wo kwôni gel sa pôn né ayiɲ tôri wo tô terare na ɗiɲ kwôy kemnêŋ men, kwôni a herê gelé bô emê bi wo hen iyôŋ ré niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wôsa hena Emen henaŋ ré kôl ɗiré jô kibi wulê bi wo hen ta ré na, kwôni pôn nêŋ iyôŋ wo henaŋ ré gelê ba ré naɲê, niɲba, wô kibi ɓiɲé ka Emen ka ôbi tôrji hen na, ôbi ré jerê kibi wulê bi wo hen ta hen. ");
INSERT INTO kqp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Iyôŋ ba, hena kwôni ré kelêŋge *Krist, kwo Emen dôri hen ré na na ley, ré na yaŋ ley na, ken bi bôrŋge sa kwôlê wori a ré. ");
INSERT INTO kqp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wôsa Kristɲê kaɲ bay benare hen naɲ bay kibi Emen kaɲ bay benare hen a soji aɲ a lê aŋgaɲ gelé naɲ kaɲ giɲê ka ɗê kiriɲ wô lamiɲ ɓiɲé men, ɓiɲé ka Emen kôba, bay a masê wo ciré lamêji a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iyôŋ ba, ken toy, en kelêŋge kwôliji ca tumô niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Hena bay ré kelêŋge Krist, kwo Emen dôri hen na derô gwôlê na, ba ken ô ré men, ôbi ré na bô ira na kôba ken bi bôrŋge sara ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wôsa mega wulaɲê emen hena si tô emen aɲ ô kwôy si kini kuriɲay tare a iyôŋ hen na, wulê wo nôbi *Kema Gawra na saɲ hen kôba, a yé na hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na kiriɲ ka temay are yi ya hen a, dunu ré daɲ ya men.» ");
INSERT INTO kqp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Cêgi bô emê bi wo kêm hen na, tare to tay a berarê kiriɲ ré niɲ men, geserê a ené ré niɲ men, têbêŋne a heriɲ ta men, aŋgaɲ néé ka derômaraŋ a a yebagiɲ tiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kiriɲ bay ka hen na, aŋgaɲ gelé kaɲê nôbi Kema Gawra a gelé yirji derômaraŋ a aɲ tô yê ɓiɲé ka sa terare a na sômnê men, menba, bay a gelen nôbi Kema Gawra hera perê kiriɲ ka geri a naɲ néé wo dami men, damɲare to dami a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kiriɲ bay ka hen na, ôbi a jé manê kari ka derômaraŋ a naɲ buruɲju to iyel damaŋ dayrê sa ɓiɲé kari ka ôbi tôrji ka sa terare a na kêm aɲ kiriɲ ka a baa ba naɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ayêŋge tôgôre ken gengiɲ kiriɲ, kiriɲa tôgôre jubu aɲ libé hen na, ken kôl kami emen ré ba ɗa niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kenbay kôba, kiriɲa ken gel wo are bay ka kêm hen sa niɲ na, ken hôn wo nôbi Kema Gawra ené ɗa kibi geré niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na tu kwôlê a ené ena kelêŋge hen, gawrê ka haw hen na, ka pôni a ba geɲ kiriɲa are bay ka hen a saɲ. ");
INSERT INTO kqp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Derômaraŋ naɲ sa terare a naɲê niɲba, kwôlê wuɲê na, a naɲê ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Kwôlo gengiɲ sa wulêri naɲ tayriri na, kwôni pôn nêŋ iyôŋ hôn né men, *manê ka derômaraŋ a hôn né men, Kema kôba hôn né a men, niɲba, na Ibari pôn nêŋ hari a henê mera. ");
INSERT INTO kqp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aŋga na li are bô wulê wo Nowé a hen na, a yé na hen iyôŋ hende to hen wulê wo nôbi Kema Gawra na heraɲ hen. ");
INSERT INTO kqp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wôsa pa dema kami bélem na ré ay kiriɲ tô na, ɓiɲé na ôm men, na yi men, na eŋgeji yébé men, eŋgiɲ kamniji yébé men, hen iyôŋ kwôy wulê wo Nowé siɲ bô bato tori a. ");
INSERT INTO kqp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bay erem sa ani a ré kwôy, kwôy wo kami bélem sa derji kêm aɲ, a yé na mega bi wo hen iyôŋ wulê wo nôbi Kema Gawra na heraɲ. ");
INSERT INTO kqp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɓiɲé wôô a ɗebé bô yagê ba, bay a ayê kwo pôn aɲ, bay a ɗéɲ kwo pôni men. ");
INSERT INTO kqp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yébé wôô a ɗebé uwoyé kuré menba, to pôn a ayiɲ menba, to pôni a ba tôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ɗéŋge tu melênê sa yerŋge a, wôsa ken hôn wulê wo Kelma woŋge a saɲ hen né. ");
INSERT INTO kqp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ken hôn, hena ôbi iyéy iyére henaŋ ré hôn wulê wo gemsa ré saɲ ba, ôbi henaŋ né merê sa têri a ɗiba gemsa henaŋ né gemsêri ré. ");
INSERT INTO kqp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kenbay kôba, ken mô sa têrŋge a, wôsa ken hôn, nôbi Kema Gawra na sa naɲ wulê wo ken bi bôrŋge sara hen né.» ");
INSERT INTO kqp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«I a na mana woɲ ôbi bê kwôlê men, ôbi tu melênê a men ba? Na kwo ôbi iyéyri a ɗiri ré bô sa ari uɲéri men, sa bay jé kari men, ré biji emê wo sa pôn pôn kêm naɲ wulêri men, tayriri men ba? ");
INSERT INTO kqp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yi derê yi wô sa mana bi wo hen wo ôbi iyéyri sa aɲ uwoɲni li jé wori bi wo hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na tu kwôlê a ené ena kelêŋge hen, ôbi a ɗiri berê sa ari uɲéri kêm. ");
INSERT INTO kqp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Niɲba, hena ôbi ré na mana wo habiɲ aɲ erem iyôŋ ba: ‹Ôbi iyéyren ba aɲê tô.› ");
INSERT INTO kqp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aɲ sê megêri bay jé bay ka hen men, ôm men, yi naɲ bay kwoyé a men. ");
INSERT INTO kqp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ôbi iyéyri a sa naɲ wulê wo ôbi ɓu sa têri ré hen. ");
INSERT INTO kqp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aɲ ôbi a liri ɓisiɲne men, a gili gusiɲ a men mega wo bay giliɲ bay kelê kwôlê kibriji wôô wôô gusiɲ hen iyôŋ. Kiriɲ bay ka hen na, ɓiɲé a sômnê ya men, a emnê kaɲniji mêêrê mêêrê ya a men.» ");
INSERT INTO kqp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Iyôŋ ba, emê iyére to derômaraŋ yi mega kam kalmê ka môj ka pô lampa toji jôriɲ kwini ôbi kurô iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Perê kam kalmê bay ka môj hen na, ka bay na bay tu melênê men, ka bay na bay galê men. ");
INSERT INTO kqp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kaɲ bay galê hen na, eraɲji naɲ weŋ wo ɗaŋgi kôbriji a ré. ");
INSERT INTO kqp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Niɲba, kaɲ bay tu melênê hen na, eraɲ naɲ weŋ lampa toji bô gwolé a kôbriji a. ");
INSERT INTO kqp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mega wo tê ôbi kurô bi wo hen ba geré tô menba, bay yederiɲ kum aɲ yiji kum kêm. ");
INSERT INTO kqp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sa kiriɲ ka jali menba, tô kwôni ôm kaŋ a ta kôl iyôŋ ba: ‹Geléŋge ôbi kurô bi era hen ya, séŋge ken jô kwini.› ");
INSERT INTO kqp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Menba, kam kalmê bay ka môj hen eŋgeji tô kum a, aɲ ɲanji lampa toji. ");
INSERT INTO kqp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kaɲ bay galê hen, kôliɲ kaɲ bay tu melênê hen iyôŋ ba: ‹Béniŋge weŋ lampa toŋge dê men, wôsa lampa toni bariɲ.› ");
INSERT INTO kqp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Menba, kaɲ bay tu melênê hen uwôlji sara iyôŋ ba: ‹Niɲa béŋge ré wôsa nêm wo naa sodiriɲge ré. Erêŋge ken ô kelé iyé bay garare a yaŋ ɗi.› ");
INSERT INTO kqp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kiriɲa bay ô wô kelé weŋ lampa toji hende to hen menba, ôbi kurô bi wo hen sa cêgeriji a, aɲ kam kalmê ka ré ɓu sa têrji hen, ôrji naɲ ɗi ira kini gerê iyére a menba, bay luge kibi iyére ta. ");
INSERT INTO kqp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kiriɲa kam kalmê kaɲ bay galê bay ka hen buloji hera menba, bay di kermiɲ aɲ kôl iyôŋ ba: ‹Kelma, Kelma, bôl kermiɲ béni men ɗéy.› ");
INSERT INTO kqp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Menba, ôbi uwôlji sara iyôŋ ba: ‹Na tu kwôlê a ené kelêŋge hen, en henêŋge ré.› » ");
INSERT INTO kqp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Menba, Jésu kôlji iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a, wôsa sa heraren na, ken hôn wulêri ré men, tayriri ré a men.» ");
INSERT INTO kqp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«*Emê iyére to derômaraŋ a yi mega gawra wo ɗa erê kergare menba, uwôge manê kari aɲ céji ari uɲé kari bi bay ré gem. ");
INSERT INTO kqp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kwo tumô, ôbi biri lari woɲ lôr miliɲôn bay men, ôbi cêgeri ba ôbi biri lari woɲ lôr miliɲôn wôô men, kwo subi ba ôbi biri lari woɲ lôr miliɲôn pôn men. Ôbi céji hen iyôŋ nêm sa néé woji néé woji menba, ɗiɲ yiri ô hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kwo tumô wo bay ré biri lari woɲ lôr dubu bay hen na, ô liɲ jeŋga aɲ uwôɲ kamne dubu bay a sara. ");
INSERT INTO kqp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ôbi cêgeri wo bay ré biri lari woɲ lôr miliɲôn wôô hen kôba, ô liɲ jeŋga aɲ uwôɲ kamne dubu wôô a sara men. ");
INSERT INTO kqp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Niɲba, kwo subi wo bay ré biri lari woɲ lôr miliɲôn pôn hen na, ô kergé iyom aɲ emiɲ kwori tôŋ uwôbe. ");
INSERT INTO kqp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Wulê kwône niɲ menba, ôbi iyérji na uwo tô kergare tori a menba, uwôgeji eŋgeriji tô lari wo na ɗiré céji gemé hen. ");
INSERT INTO kqp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kwo tumô wo ôbi na biri lari woɲ lôr miliɲôn bay hen, era ligiri a aɲ kôli iyôŋ ba: ‹Kelma, na ju ben lari woɲ lôr na bay aɲ ju gel, en hô uwôɲ miliɲôn bay a sara.› ");
INSERT INTO kqp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Menba, kelma wori kôli iyôŋ ba: ‹Dô damaŋ, ju na mana wo dôri woɲ ôbi bôô pôn. Aŋga dê ka na en bem hen aɲ ju cubu tum tô a hen na, na hô bêm megêrji mê a sara, era sa li yi derê naɲ en.› ");
INSERT INTO kqp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ôbi cêgeri wo ôbi ré biri lari woɲ lôr miliɲôn wôô hen na, era ligiri a aɲ kôli iyôŋ ba: ‹Kelma, na ju ben lari woɲ lôr na wôô aɲ ju gel en hô uwôɲ miliɲôn wôô a sara.› ");
INSERT INTO kqp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Menba, kelma wori kôli iyôŋ ba: ‹Dô damaŋ, ju na mana wo dôri wo bôm pôn. Aŋga dê ka na en bem hen aɲ ju cubu tum tô a hen na, na hô bêm megêrji mê a sara, era sa li yi derê naɲ en.› ");
INSERT INTO kqp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kwo subi wo ôbi na biri lari woɲ lôr miliɲôn pôn hen era ligiri a aɲ kôli iyôŋ ba: ‹Kelma, en hôn wo jeré na kwôni wo ré li iyêre men, jeré na kwôni wo ré ci dema ré wal ré a men, kwo ré wusu dema ré pô ré a men. Na ôbi á, ené merên yen né hen. ");
INSERT INTO kqp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","En kemnam aɲ en kerge iyom emiɲ lari wom bi wo hen tôŋ aɲ gel, ôbi a na.› ");
INSERT INTO kqp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Menba, kelma wori kôli iyôŋ ba: ‹Jôbi ju na mana wo habiɲ woɲ kuy. Ju hôn dô iyôŋ wo ené ci dema ené wal ré men, ené wusu dema ené pô ré a men. ");
INSERT INTO kqp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iyôŋ ba, ré jeré erê biɲ bay lê jeŋga aɲ kiriɲa ré ené hera na ba, ré ené uɲé kamne a sara ré ba? ");
INSERT INTO kqp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Iyôŋ ba, ken dô lari wo kôbri a hen aɲ ken biɲ kwo kwori môj hen a sara. ");
INSERT INTO kqp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","En kelêŋge kwôni wo naɲ uɲé bay a hô biri a sara. Aɲ ôbi a ôriɲ damaŋ a. Niɲba, kwo ari uɲé kari lôg hen na, bay a derê bay ka lôg hen kôbri a aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mana wo habiɲ woɲ kuy hen na, ɓeréŋgeri ken uwôli nô bô dilemne a, na kiriɲ ka ɓiɲé a sômê men, ômniɲ kaɲniji mêêrê mêêrê ya a men hen.› » ");
INSERT INTO kqp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Kiriɲa nôbi *Kema Gawra na heraɲ naɲ damɲare tiɲê hen na, *manê ka derômaraŋ a a banji aɲ na sa merê sa gagay kenare wuɲê. ");
INSERT INTO kqp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aɲ tô yê ɓiɲé ka sa terare a na kêm a daɲ tumôn a aɲ na a derê tirji mega wo ôbi abê gamgê dôriɲ tu gamgê gay naɲ uré hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na bê gamgê sa kôben gusurô men, uɲé sa kôben ma men. ");
INSERT INTO kqp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Menba, na kôliɲ ka sa kôben gusurô hen iyôŋ ba: ‹Eraŋge kenbay ka Iban tô kibri a sarŋge a hen, ken sa mô bô emê iyére tori to bay ɲan wô kwôleŋge ca tumô kiriɲa ka tô terare na ɗiɲ yeŋ hen. ");
INSERT INTO kqp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wôsa, kiriɲa kurôŋ na lên ba, na ken ben aŋgaɲ emê men, kam na dên ba, na ken ben en yi men, na ena kerga ba, na ken lên kergare men. ");
INSERT INTO kqp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na en ô tôn seŋge ba, na ken ben bargay en têliɲ tôn men, na en ômiɲ ba, na ken kôrben men, na en yi daŋgay a ba, na ken ô gelen a men.› ");
INSERT INTO kqp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Menba, bay lê aŋgaɲ derôre bay ka hen a uwôlen sara iyôŋ ba: ‹Kelma, kiriɲa yôŋ a na niné gelem kurôŋ na ré lêm a, na niné bem aŋgaɲ emê men, kam na dêm a, na niné bem ju yi men ba? ");
INSERT INTO kqp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Men, kiriɲa yôŋ a, na jeré na kerga aɲa na niné lêm kergare men, na jeré ô tôm seŋge a, na niné bem bargay ju têliɲ tôm men ba? ");
INSERT INTO kqp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Men, kiriɲa yôŋ a, na jeré ômiɲ men, na ju yi daŋgay a a men a, na niné ô gelem ba?› ");
INSERT INTO kqp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Menba, na uwôlji a sara iyôŋ ba: ‹Na tu kwôlê a ené kelêŋge hen are bay ka kêm ka ken li naɲ yênên ka bay bôrji mega ani ré hen na, na nôbi bi a na kené lên hen.› » ");
INSERT INTO kqp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Menba, na kôliɲ ka sa kôben ma hen iyôŋ ba: ‹Erêŋge wolé, kenbay ka mênê yi wô sarŋge, erêŋge bô tare to eŋge kwôy naɲ kunu to yi gengiɲ sa Sidan naɲ ɓiɲé kari hen. ");
INSERT INTO kqp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wôsa, kiriɲa kurôŋ na lên ba, na ken ben aŋgaɲ emê ré men, kam na dên ba, na ken ben en yi ré men. ");
INSERT INTO kqp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na ena kerga ba, na ken lên kergare ré men, na en ô tôn seŋge ba, na ken ben bargay bi ené têliɲ tôn ré men, na en ômiɲ men, na en yi daŋgay a men menba, na ken ô gelen ré a men.› ");
INSERT INTO kqp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Menba, bay a uwôlen sara iyôŋ ba: ‹Kelma, kiriɲa yôŋ a, na niné gelem kurôŋ na ré lêm men, kam na ré dêm men, na jeré na kerga men, na jeré ô tôm seŋge men, na jeré ômiɲ men, na jeré yi daŋgay a a men, a na niné li naɲ ju ré ba?› ");
INSERT INTO kqp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Menba, na uwôlji sara iyôŋ ba: ‹Na tu kwôlê a ené kelêŋge hen, are bay ka kêm ka ken li naɲ yênên ka bay bôrji mega ani ré hen na, na nôbi bi a na kené li naɲ en né hen.› ");
INSERT INTO kqp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Menba, bay lê habrê bay ka hen a erê kiriɲ kaɲ gusiɲ ka yi naɲ kuniji hen, wô jé lêreji wo habiɲ bi wo hen men, kaɲ bay lê aŋgaɲ derôre ba, bay a erê kini gelê wo yi naɲ kwini a hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kiriɲa Jésu dô kwôlê wori bi wo hen kô niɲ menba, ôbi kôliɲ bay tôri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ken hôn wo geserê *Pak ré ba na wulê wôô mera. Sa hende to hen na, bay a ɓeren nôbi *Kema Gawra bé aɲ bay a erê ɓéren sa gurô tagelê.» ");
INSERT INTO kqp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Menba, damné kaɲ bay bê kwôbe naɲ surɲê ka *Israyêl daɲji iyé *dami wo damné kaɲ bay bê kwôbe Kayib a. ");
INSERT INTO kqp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bay woge gwosore toɲ ɓeriɲ Jésu jegê aɲ ciré diri. ");
INSERT INTO kqp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Niɲba, bay kôl bi ciré ɓiri bôb naɲ sa geserê Pak ré, wô wo ɓiɲé ma ré liɲ kwôlê naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jésu mô Bétani a iyé Simô wo *terbare liri hen na, ");
INSERT INTO kqp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","iyore to pôni eraɲ naɲ ider wo garari mê bô murda wo bay li naɲ *albatre hen kôbre a. Hende usoɲ ligi Jésu a aɲ sa wuseri sari a kiriɲa bay mô tôŋ kibi emê a hen. ");
INSERT INTO kqp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kiriɲa bay tôri gel hen iyôŋ menba, bôrji tarji aɲ bay kôl iyôŋ ba: «Wô mi a hende ré mêne ider bi wo garari mê hen, hen iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ré nana keléɲ ba nana uɲé lari mê aɲ céɲ bay nimré ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jésu hôn ermé woji bi wo hen menba, ôbi kôlji iyôŋ ba: «Wô mi a kené dôyrê iyore hende to hen iyôŋ ba? Aŋga hende lên hen na, na aŋga dôri. ");
INSERT INTO kqp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bay nimré ba, a merê naɲ ken sa pôn pôn, niɲba, nôbi ba, na merê naɲ ken naɲ wulê wulê ré. ");
INSERT INTO kqp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ider wo hende bên san a hen na, na wo bi bay ré sa emen.» ");
INSERT INTO kqp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Menba, ôbi hô kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, naɲ kiriɲ kêm sa terare a na ka bay a ulê béré Kwôlo Dôri ya hen na, bay a derê kwôli aŋga iyore hende to hen li hen ermiɲ sara.» ");
INSERT INTO kqp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ôbi tô Jésu wo pôni perê ka môj kibi wôô hen hini na Judas Iskariyôt, ôbi ô uɲé damné kaɲ bay bê kwôbe ");
INSERT INTO kqp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aɲ kôlji iyôŋ ba: «Hena ené ay sa Jésu béŋge ba, na mi a kené ben ba?» Menba, bay biri selé tôre subu. ");
INSERT INTO kqp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ayiɲ tôri wulê bi wo hen na, Judas woge geré wo ɗiré ayiɲ sa Jésu biɲ damné kaɲ bay bê kwôbe. ");
INSERT INTO kqp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wulê woɲ ayê tô lê geserê mapa wo wubere naɲ bô hen na, bay tô Jésu era sa eŋgeriri iyôŋ ba: «Na yôŋ a jeré gey bi niné ô ɓerem sa tê lê geserê Pak ya ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Menba, ôbi uwôlji sara iyôŋ ba: «Erêŋge derô ira iyé kini a aɲ ken kôli iyôŋ ba: ‹*Rabi, kôl iyôŋ ba: «Wulê wuɲê ba ɗa niɲ, aɲ nôbi naɲ bay tôn niɲa lê geserê Pak iyére tom a.» › » ");
INSERT INTO kqp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bay tô Jésu li na mega bi wo ôbi ré kelaji hen iyôŋ menba, bay ɓu sa tê Pak ya. ");
INSERT INTO kqp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kiriɲa tare kuriɲ niɲ menba, Jésu mô tôŋ kibi emê naɲ bay tôri ka môj kibi wôô hen. ");
INSERT INTO kqp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kiriɲa bay ôm emê môriɲ hen iyôŋ menba, Jésu kôl iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, kwôni wo pôni perêrŋge a hen a sa ayê san.» ");
INSERT INTO kqp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bay kêm bôrji mêne damaŋ menba, i i ba eŋgeriri iyôŋ ba: «Kelma, na nôbi ɓa? Kelma, na nôbi ɓa?» ");
INSERT INTO kqp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Menba, ôbi uwôlji sara iyôŋ ba: «Na kwo ré dôbe kôbri naɲ en bô gwore a hen, ôbi a ayê san. ");
INSERT INTO kqp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na tiri, nôbi Kema Gawra na erê, na mega wo na liɲ bô magtubu to Emen a gengiɲ san hen iyôŋ. Niɲba, bô emê a kuriɲ sa kwôni wo ay san nôbi Kema Gawra hen. Bay henaŋ ré yêri ré kôba ré dô sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas wo a sa ayê sa Jésu eŋgeriri iyôŋ ba: «Rabi, na nôbi ré rê?» Menba, Jésu uwôli sara iyôŋ ba: «Na tiri na jôbi.» ");
INSERT INTO kqp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kiriɲa bay mô ômji emê menba, Jésu ay mapa aɲ tô kibri sara menba, ɓiilê aɲ biɲ bay tôri aɲ kôlji iyôŋ ba: «Eŋgéŋge ken ôm ôbi yi mega kurôŋgi yen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Men, ôbi hô ay gwoy care toɲ yê tiɲaɗor aɲ liɲ Emen dosé, aɲ ôbi biji aɲ kôl iyôŋ ba: «Eŋgéŋge ken yi pôn pôn kêm.» ");
INSERT INTO kqp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aɲ ôbi kôlji iyôŋ ba: «Kwo nà ná, yi môɲ kwôbren woɲ biɲare wo biɲ tôŋ wô kibi ɓiɲé kwône aɲ bi têriɲ toji ré dôriɲ sarji a. ");
INSERT INTO kqp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","En kelêŋge, na hô yê care toɲ yê tiɲaɗor hende to hen ré niɲ, kwôy wulê wo na sa yiɲ to kôrbi naɲ ken bô emê iyére to Iban a.» ");
INSERT INTO kqp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kiriɲa bay kebe kurôŋ menba, Jésu naɲ bay tôri ôrji sa Keram wo Olibiyé. ");
INSERT INTO kqp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Menba, Jésu kôlji iyôŋ ba: «Bô yoyre to kemnêŋ hen na, kenbay kêm ka ɗén aɲ wôsa liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Na deré ôbi abê gamgê menba, bay a useriɲ kêm.› ");
INSERT INTO kqp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Niɲba, cêgê menba, kiriɲa na jê sé kamɲê na, na erê tumôrŋge a Galilé a.» ");
INSERT INTO kqp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Menba, Piyêr kôliɲ Jésu iyôŋ ba: «Kiriɲa megên kêm a ɗém aɲ ba, nôbi na ɗém aɲ né.» ");
INSERT INTO kqp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Menba, Jésu uwôli sara iyôŋ ba: «Na tu kwôlê a ené kôlem hen, bô yoyre to kemnêŋ hende to hen na, pa dema kura ré yelé tô ba, já uwôserê têê subu jeré hônen né.» ");
INSERT INTO kqp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Niɲba, Piyêr hô kôli iyôŋ ba: «Hena ré na wo ené ma naɲ ju kôba, na kelê ené hônem né ré.» Menba, bay tôri kêm kôl mega wo Piyêr kôliɲ hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Menba, Jésu ôriɲ naɲ ci kiriɲ ka bay uwôgeji *Gêtsémané hen, aɲ kôlji iyôŋ ba: «Merêŋge tôŋ na, aɲ nôbi na derê tôn wolé erê uwôlê Emen.» ");
INSERT INTO kqp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jésu ôriɲ naɲ si Piyêr naɲ kam Jébédé ka wôô hen naɲ ɗi. Menba, tiri li ɲa men, ôbi aŋge damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Menba, ôbi kôlji iyôŋ ba: «Tun li ɲa môɲ teré dun iyôŋ, merêŋge na, aɲ ken yi kum né.» ");
INSERT INTO kqp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jésu dô tôri dê wolé menba, jubu gubari diɲ kwini tôŋ aɲ uwôl Emen iyôŋ ba: «Iban, hena ré yi iyeŋ ba, ju ɗi gusiɲ hende to hen lên né. Hen iyôŋ hari kôba, ju li bô geyé wom, ɗiba bô geyé wuɲê nôbi ré.» ");
INSERT INTO kqp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ôbi bulo hera ligi bay tôri a, menba, uwoɲji tô kum a. Menba, Jésu kôliɲ Piyêr ba: «Ken mô tu geɲ naɲ en sem iyôŋ né ba? ");
INSERT INTO kqp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Merêŋge tu geɲ aɲ ken uwôl Emen bi kené heriɲ bô aŋgaɲ lamê ré. Ken gey merê tu geɲ haŋge niɲba, na néérŋge a nêmê ré ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jésu hô dô tôri wolé dê aɲ jôgiɲ têê wôô wori aɲ uwôl Emen kôl iyôŋ ba: «Iban, hena ré yi iyeŋ ba, ju ɗi gusiɲ hende to hen lên né. Hen iyôŋ hari kôba, ju li bô geyé wom ɗiba, bô geyé wuɲê nôbi ré.» ");
INSERT INTO kqp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ôbi hô bulo hera menba, uwoɲji tô kum a wôsa bay nêm merê geɲ né. ");
INSERT INTO kqp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ôbi hô dô tô wolé aɲ uwôl Emen wo jôgiɲ têê subu aɲ na kwôlo ôbi ré kôl tumô hen a ôbi ré hô kôl sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ôbi hera ligi bay tôri a aɲ kôlji iyôŋ ba: «Yéŋge kum aɲ ken dô bul haŋge niɲ. Kô niɲ. Tayriri sa wo bay a uwôlen nôbi Kema Gawra kôbi bay têriɲ a niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Henaŋge ta, na erêŋge gel, ôbi ayê san biɲ ɓiɲé bi, sa niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kiriɲa Jésu iyêl ba ya tô hen iyôŋ menba, Judas ôbi tô Jésu wo pôn perê ka môj kibi wôô hen so naɲ kwônê ɓiɲé ka ôriɲ naɲ yebere toɲ kaskar men, ka naɲ kwore a men. Na damné kaɲ bay bê kwôbe naɲ bay sa Jubɲê a joji. ");
INSERT INTO kqp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas woɲ ôbi ayê sa Jésu hen, ré kelaɲ kwônê ɓiɲé bay ka hen iyôŋ ba: «Kwôni wo na ibé tô mari liri dosé hen na, na ôbi a kené ɓiri.» ");
INSERT INTO kqp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kiriɲa bay sa niɲ menba, Judas era ligi Jésu aɲ kôl iyôŋ ba: «Dosé tom Rabi.» Menba, ôbi ibe tô maa Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Menba, Jésu kôli iyôŋ ba: «Melaɲnen, aŋga ju era wô lê hen na, ju li mera.» Menba, kwônê ɓiɲé bay ka hen selam Jésu ɓu. ");
INSERT INTO kqp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Menba, ôbi tô Jésu wo pôni perê ka ɗebu naɲ ɗi hen, dô yebere toɲ kaskar tori aɲ diɲ maa mana wo *dami wo damné kaɲ bay bê kwôbe jô. ");
INSERT INTO kqp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Menba, Jésu kôli iyôŋ ba: «Dôbe yebere tom toɲ kaskar hôriɲ bô iyéyrere a wôsa ɓiɲé ka pô yibiɲê kaɲ kaskar ba, na temay yebere toɲ kaskar a bay ré ma men, ");
INSERT INTO kqp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ju hôn wo henaŋ ené eŋgeriɲ Iban ba, ôbi henaŋ ré ben asgarɲê nêmê sak tôre jurgem kibi wôô kiriɲ bay ka nana ɗibiɲ hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hena henaŋ ré na hen iyôŋ ba, kwôlo yi bô magtubu to Emen a to kôl iyôŋ ba: Ré na hen iyôŋ, a ré liɲ hen ba, ariri henaŋ ré liɲ na iyeŋ iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jésu kôliɲ kwônê ɓiɲé bay ka hen iyôŋ ba: «Ken eraɲ naɲ si yebere toɲ kaskar men, kwore men kôberŋge a wô ɓerenare mega wo kené kena ɓeré na gemsa iyôŋ. En mô perêrŋge a na sa pôn pôn giliɲ ɓiɲé are derô haba wo *iyéy Emen a hen ba, na ken era sa ɓeren ré wô mi ba? ");
INSERT INTO kqp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Niɲba, yi hen iyôŋ bi kwôlo bay kibi Emen na li bô magtubu to Emen a hen na, bi ariri ré liɲ.» Menba, bay tôri kêm gerji ɗiri aɲ. ");
INSERT INTO kqp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bay ɓeré Jésu bay ka hen ôriɲ naɲ ɗi tumô Kayib a wo na dami wo damné kaɲ bay bê kwôbe hen. Kiriɲ bay ka hen na, *bay derê tô tôô to Emen naɲ surɲê ka Jubɲê kôba, daɲji ya men. ");
INSERT INTO kqp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyêr ô tô Jésu a tôŋ tôŋ kwôy ôriɲ karaŋ derô haba wo dami wo damné kaɲ bay bê kwôbe a, aɲ ô merê naɲ bay gemé kibi iyé dami wo damné kaɲ bay bê kwôbe bi wo hen aɲ ɗiré gelé aŋga bay ré lê. ");
INSERT INTO kqp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Damné kaɲ bay bê kwôbe naɲ *Sanédrên kêm woge geré wo ciré ɗiri kwôlo dami sari a aɲ ciré deriɲni. ");
INSERT INTO kqp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɓiɲé kwône era sa pôy kwôlê ɗiri sari a, niɲba, bay uwôɲ kwo nêm deréri ré. Ka pôni wôô era cêgê aɲ ");
INSERT INTO kqp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kôl iyôŋ ba: «Gawra bi wo hen kôl iyôŋ ba: Ɗiré té iyéy Emen hen aɲ ɗiré hô ɗé hôriɲ sa subu dêj.» ");
INSERT INTO kqp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Menba, dami wo damné kaɲ bay bê kwôbe hena ta, aɲ kôliɲ Jésu iyôŋ ba: «Ju uwôl kwôlê sa kwo gawrê bay ka hen kôl gengiɲ sam hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Niɲba, Jésu uwôli kwôlê wôni sara ré. Menba, dami wo damné kaɲ bay bê kwôbe bi wo hen kôliɲ Jésu iyôŋ ba: «En uwôlem naɲ hini Emen woɲ ôbi merê tu geɲ hen, bi jeré kelêni na ba, ju na *Krist, kwo Emen dôri hen wo na Kemari bi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Menba, Jésu kôli iyôŋ ba: «Ôbi a jeré kôl kem a hen. En kelêŋge ka sa gelen nôbi *Kema Gawra na merê sa kôbi gusurô wo Emen woɲ ôbi néé a a men, na bulo hera perê kiriɲ ka geri ka derômaraŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Menba, dami wo damné kaɲ bay bê kwôbe yêgerê bargay yiri a aɲ kôl iyôŋ ba: «Ôbi tiiré Emen ôm hen iyôŋ niɲ menba, ken kôl nana hô gem na i ré kelêna kwôli sôŋ ba? Mega ken toy tiiré wo ôbi tiiré Emen ôm hen niɲ na, ");
INSERT INTO kqp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kwôli mi a kené erem niɲ ba?» Menba, bay uwôli sara iyôŋ ba: «Ôbi na kwoɲ deré.» ");
INSERT INTO kqp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kiriɲ bay ka hen na, bay tibriri kalê tiri a men, ka pôni esuge kôbriji cibiɲni men, ka pôni sê tô mari a men. ");
INSERT INTO kqp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aɲ bay kôli iyôŋ ba: «Krist, kwo Emen dôri hen li yem môɲ *ôbi kibi Emen iyôŋ aɲ ju kelêni na i a dêm hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kiriɲ bay ka hen na, Piyêr mô nô derô haba menba, hende jé to dami wo damné kaɲ bay bê kwôbe to pôni uso ɗa ligiri a aɲ kôli iyôŋ ba: «Jôbi kôba, na ju ô naɲ Jésu wo Galilé bi wo hen ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Niɲba, ôbi uwôser tu ɓiɲé a kêm kôl iyôŋ ba: «Kwôlo mu kôl hen na, en hôn né.» ");
INSERT INTO kqp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ôbi hena ô si kibi geré iyôŋ menba, hende jé to ɗaŋgi gili aɲ kôliɲ ɓiɲé ka ɗebe ya hen iyôŋ ba: «Gawra wo na, kôba na ô naɲ Jésu wo Najarêt bi wo hen men.» ");
INSERT INTO kqp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Menba, Piyêr hô uwôser desiɲ yiri kôl iyôŋ ba: «En hôn gawra bi wo hen né.» ");
INSERT INTO kqp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sem cêgê menba, ɓiɲé ka ré mô ya hen usoji ligi Piyêr a aɲ kôli iyôŋ ba: «Jôbi kôba, ju na kwo ɓiɲé bay ka hen men, wôsa kwôli kelêrem gel wo jeré na kwoji.» ");
INSERT INTO kqp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Menba, Piyêr dusu yiri kôl iyôŋ ba: «En hôn gawra bi wo hen né. A hena ené kôl benare ba, bi Emen deren.» Kiriɲ bay ka hen menba, kura yel men. ");
INSERT INTO kqp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Menba, bô Piyêr jibri sa kwôlo Jésu na kôli kôl iyôŋ ba: «Já uwôserê jeré hônen né têê subu dema kura ré yilé tô hen.» Menba, ôbi si nô aɲ sôm ɓugerôg ɓugerôg. ");
INSERT INTO kqp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tô kiriɲ cud menba, damné kaɲ bay bê kwôbe kêm naɲ surɲê daɲji aɲ gengiji kwôli deré Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bay bi bay harêri aɲ ôriɲ naɲ ɗi ô biɲ *Pilat ôbi emê sa iyére woɲ Rômê. ");
INSERT INTO kqp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kiriɲa Judas wo ay sa Jésu hen gel wo bay uwôl kwôlê sa Jésu a hen iyôŋ menba, bôri tari sa aŋga ɗiré li hen menba, ôbi heraɲ naɲ selé to tôre subu hen biɲ damné kaɲ bay bê kwôbe naɲ surɲê hôriɲ, ");
INSERT INTO kqp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","aɲ kôlji iyôŋ ba: «Ayê wo en ay sa kwo li ani ré hen na, en li na têriɲ hen.» Menba, bay kôli iyôŋ ba: «Na kwôlê wom jôbi ɗiba kwo hen dôlêni nibay ré.» ");
INSERT INTO kqp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas bêɲ selé hende to tôre subu hen bô *iyéy Emen a aɲ si ô ulê gaŋne diriɲ yiri. ");
INSERT INTO kqp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Damné kaɲ bay bê kwôbe pô selé hende to hen, aɲ kôlji iyôŋ ba: «Selé to na na, dé wo nana bi bô magela wo yi naɲ jeŋgêri hen né, wôsa na lari kwôbe.» ");
INSERT INTO kqp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kiriɲa bay nariɲ kwôlê sara menba, bay genge ciré keliɲ kiriɲ ka gawra woɲ ôbi jibé hen, aɲ bi ré yi sa kamɲê kergê. ");
INSERT INTO kqp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ôbi a bay ré uwôge kiriɲ bay ka hen, kiriɲ kaɲ kwôbe kwôy kemnêŋ kemnêŋ hen. ");
INSERT INTO kqp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na ôbi á, kwôlo *ôbi kibi Emen Jérémi na kôl hen, ariri ré liɲ. Ôbi na kôl iyôŋ ba: «Bay pô lari tôre subu aɲ lari bi wo hen, na kwo kam *Israyêl biɲ sara wô kiliɲni. ");
INSERT INTO kqp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aɲ bay keliɲ kiriɲ ka gawra woɲ ôbi jibé hen, mega wo Kelma na ayiɲ tôô ben hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kiriɲa bay ôriɲ naɲ Jésu tumô ôbi emê sa iyére Pilat a, menba, ôbi eŋgeriri kôl iyôŋ ba: «Ju na kelma ôbi emê sa iyé Jubɲê bi ba?» Menba, Jésu uwôli sara iyôŋ ba: «Jôbi a kelê hen.» ");
INSERT INTO kqp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kiriɲa damné kaɲ bay bê kwôbe naɲ surɲê pôy kwôlê ɗiri Jésu sari a hen iyôŋ na, ôbi uwôlji kwôlê wôni sara ré. ");
INSERT INTO kqp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Menba, Pilat kôli iyôŋ ba: «Ju toy kwôlo bay pôy kêm bêm sam a hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Niɲba, Jésu uwôli kwôlê wôni pôn nêŋ iyôŋ sa kwo bay pôy ɗiri sari a hen né. Menba, tini kelma ge kay damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Elê elê naɲ sa geserê *Pak ba, ôbi emê iyére ôriɲ naɲ hara woɲ ulê daŋgay wo gawrê gey hen pôn ta ta. ");
INSERT INTO kqp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wulê bi wo hen na, Barabas na daŋgay wo hini ôm gaɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Menba, Pilat eŋgeriɲ ɓiɲé iyôŋ ba: «Na i a kené gey bi ené uwôli ta béŋge ba? Barabas laba Jésu wo bay uwôgeri *Krist hen ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wôsa ôbi hôn wo ré na terbére a ré liji aɲa bay ré ɓeriɲ Jésu bi hen. ");
INSERT INTO kqp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kiriɲa Pilat ba kini jerê kwôlê a tô menba, tamni jé kwôli iyôŋ ba: «Jôbi ju jô kwôlê sa gawra woɲ derôre bi wo hen na ré, wôsa yoyre hen na, wônê gelen gusiɲ gaɲ gengiɲ sari.» ");
INSERT INTO kqp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Damné kaɲ bay bê kwôbe naɲ surɲê gwôsiji ɓiɲé bi ré eŋgere bi ôbi emê sa iyére ré uwôl Barabas ta, aɲ Jésu a ré diri ɗi. ");
INSERT INTO kqp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ôbi emê sa iyére kôlji iyôŋ ba: «Daŋgayɲê ka wôô na na, na kwo yôŋ a kené gey bi ené uwôli ta béŋge ba?» Menba, bay uwôli sara iyôŋ ba: «Uwôl Barabas ta ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ôbi emê sa iyére Pilat hô eŋgereji iyôŋ ba: «Jésu wo bay uwôgeri Krist hen ba, en liri iyeŋ ba?» Menba, bay kêm uwôli sara iyôŋ ba: «Ɓééri sa gurô tagelê béni.» ");
INSERT INTO kqp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ôbi emê sa iyére hô eŋgereji iyôŋ ba: «Na mi ka habiɲ a ôbi ré li ba?» Menba, bay kêm kôl kaŋ ta iyôŋ ba: «Ɓééri sa gurô tagelê, ɓééri sa gurô tagelê.» ");
INSERT INTO kqp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat bô wo ɗiré nêm lê ani ré niɲ men, heragê kôba ôm gaɲ a men na, ôbi ay kam piliɲ kôbri tu ɓiɲé kêm aɲ kôl iyôŋ ba: «En naɲ tô bê kwôbri gawra woɲ derôre bi wo hen a, na kwôlê woŋge kenbay haŋge niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Menba, bay kêm uwôli sara iyôŋ ba: «Bi kwôbriri ɓu sarni naɲ sa kwôŋgêrni.» ");
INSERT INTO kqp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Menba, Pilat uwôl Barabas ta, menba, ôbi bi bay yêmnê Jésu naɲ tinêre aɲ nôgiri biɲ asgarɲê bi ré ô ɓééri haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Asgarɲê ka ôbi emê sa iyére ôriɲ naɲ Jésu kini merê ôbi emê iyére a, aɲ asgarɲê kêm ka bô ira hen na, méérji Jésu ta kumôj. ");
INSERT INTO kqp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aɲ, bay tô bargay kari yiri a aɲ, aɲ dôbri bargay ka dami ka sêy ka ɓiɲé ka damné hen yiri a. ");
INSERT INTO kqp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Men, bay gaa jabga woɲ kenare naɲ gesem dôbri sari a men, bay dôbri celaŋ woɲ kenare kôbri woɲ gusurô aɲ cibiji gubarji tôŋ tumôri a aɲ bay ayrêri kôl iyôŋ ba: «Nini lêm dosé, kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Men, bay tibiri kalê tiri a men, bay dô celaŋ woɲ kenare bi wo kôbri a hen, sêɲ sari a men. ");
INSERT INTO kqp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kiriɲa bay sili hen iyôŋ niɲ, menba, bay dô bargay ka bay ré dôbri yiri a hen aɲ aɲ hô tôbri kari hôriɲ aɲ ôriɲ naɲ ɗi ciré erê ɓééri sa gurô tagelê haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kiriɲa bay so nô naɲ derô iyére menba, bay uwôɲ Simô wo na gawra wo Sirên hen, bay ɓiri ereŋ biri ay gurô tagelê wo Jésu. ");
INSERT INTO kqp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kiriɲa bay ô biɲ kiriɲ ka bay uwôgeji Gwôlgwota hen, bôri na ibé sa gawra hen. ");
INSERT INTO kqp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kiriɲ bay ka hen na, bay biɲ Jésu care to poliɲ naɲ aŋga ɗaɲ bi ré yi, kiriɲa ôbi yi gel menba, ôbi kaɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aɲ bay ɓééri sa gurô tagelê. Kiriɲa bay ɓééri sa gurô tagelê kô niɲ menba, bay pô bargay kari céɲji naɲ geré wo jalaw terê. ");
INSERT INTO kqp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Menba, bay mô gemni haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bi ɓiɲé ré hôn wô mi a bay ré diri ba na, bay li are di sa gurô ta sari a kôl iyôŋ ba: «Gawra bi wo hen, na Jésu kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Men, bay ɓére bay bô habrê ka pôni wôô naɲ Jésu, kwo pôni sa kôbri maa men, kwo pôni sa kôbri gusurô men. ");
INSERT INTO kqp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓiɲé ka ô tô geré hen na, bay tiiré Jésu men, bay li sarji ômiɲ ya ya ");
INSERT INTO kqp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aɲ kôl iyôŋ ba: «Jôbi wo na ju kôl jeré téé iyéy Emen aɲ jeré hô ɗé hôriɲ sa subu dêj hen na, gôliɲ naɲ yem ta. Hena jeré na kema Emen ba, ju herbo tôŋ sa gurô tagelê niɲa gelé.» ");
INSERT INTO kqp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen naɲ surɲê kôba sili kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ôbi gôliɲ naɲ ɓiɲé menba, nêm gôliɲ naɲ yiri ré, hena ôbi ré na Kelma wo Israyêl ba, bi dera yiri tôŋ sa gurô tagelê pa dema niné bê bôrni sari a. ");
INSERT INTO kqp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ôbi bi bôri sa Emen, aɲ kôl ɗiré na kema Emen. A hena Emen ré geyri ba, bi sa dôri uwôl ta hari niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bay bô habrê ka bay ɓéérji sa gurô tagelê kwari hen kôba tiréri hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ayiɲ tôri tu tare kwôy tare to yébé ayiɲ sa tôɲne ta hen na, kiriɲ hendu sa terare a na kêm. ");
INSERT INTO kqp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naɲ tare hende to yébé ayiɲ sa tôɲne ta hen, menba, Jésu jô gura wo dami kôl iyôŋ ba: «Eli, Eli lema sabaktani.» Bôri na: «Emen wuɲê, Emen wuɲê wô mi a jeré ɗén aɲ hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɓiɲé ka pôni ka ɗebe ya hen na, kiriɲa bay toy tôri hen iyôŋ, menba, bay kôl iyôŋ ba: «Ôbi uwôge *Eli.» ");
INSERT INTO kqp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kwo pôni ô lew ô ayê kibi bargay dôbê bô kam tiɲaɗor ka bay uwôgeji binêger hen, aɲ dôbe kibi gurô aɲ eraɲ sa dôbri kibri a, bi ré yi. ");
INSERT INTO kqp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Menba, ka pôni kôli iyôŋ ba: «Ɗi jan, naa gelé na ba, Eli a sa gôliɲ naɲ ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Menba, Jésu hô dô gura wo dami menba, kibri wôm hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kiriɲ bay ka hen, menba, bargay ka bay ha jôriɲ bô *iyéy Emen hen na, yêgiɲ derôre a wôô ayiɲ tôri ta kwôy uwôl tôŋ men, sa terare yebagiɲ men, keram wayriɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kamɲê wayriɲ aɲ ɓiɲé kaɲ bay lê aŋgaɲ derôre tu Emen a ka na ma hen na, ji si kamɲê. ");
INSERT INTO kqp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kiriɲa bay so bô kamɲê hen iyôŋ menba, cêgi jê sé wo Jésu a ná, bay ô derô iyére to yi naɲ jeŋgêre to na Jérusalêm hen, aɲ ɓiɲé kwône gilji hôn. ");
INSERT INTO kqp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Dami wo asgarɲê naɲ asgarɲê ka ré ɗebe wô gemé Jésu hen, gel sa terare to yebagiɲ hen men, are kêm ka li are hen a men na, harê liji damaŋ aɲ bay kôl iyôŋ ba: «Gawra bi wo hen na, na Kema Emen bi tiri a men.» ");
INSERT INTO kqp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kiriɲ bay ka hen na, yébé ka pôni kwône ka na ô naɲ Jésu hen kôba, ɗebe ya sêd wolé gel are bay ka hen men. Na bay a na lêrê jé biri hen kiriɲa ôbi na ayiɲ tô jé wori Galilé a kwôy saɲ nà hen. ");
INSERT INTO kqp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Perê yébé bay ka hen na, na si Mari to Magdala naɲ toɲ yoo si *Jak naɲ Josêp men, yoo kam Jébédé a men. ");
INSERT INTO kqp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pa dema tare ré ta kuriɲ na, gawra woɲ ôbi uɲé wo bay uwôgeri Josêp, ôbi na gawra wo Arimaté. Ôbi na na ôbi tô Jésu men. ");
INSERT INTO kqp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ôbi ô uɲé Pilat aɲ eŋgeriri temay Jésu, menba, Pilat ay tôô bi bay ré ɗiri ré ay. ");
INSERT INTO kqp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josêp ay temay Jésu aɲ lêgere naɲ kibi bargay ka bôri ka kôrbi a. ");
INSERT INTO kqp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aɲ ôriɲ emé bô kamɲê kari kaɲ yiri ka ôbi bi bay kerge haw bô keram a aɲ ôbi gereŋge kulmaŋ keram wo dami ɗé kibi a aɲ ô hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari to Magdala naɲ to pôni hen môrji wor kwiniji si sa kamɲê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cêgi ɓeré sa têê sa merê ta a hen, menba, damné kaɲ bay bê kwôbe naɲ Parisiɲêɲê ôrji ô uɲé Pilat. ");
INSERT INTO kqp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aɲ kôli iyôŋ ba: «Kelma, bôrni jibéni sa kwôlo ôbi benare bi wo hen na kôl kiriɲa ôbi na baɲ ta tô hen, ôbi na kôl iyôŋ ba: ‹Sa wôô, subu tori menba, na jê sé kamɲê.› ");
INSERT INTO kqp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iyôŋ ba, ay tôô bi bay gem sa kamɲê kwôy wulê subu, wô wo bay tôri maa sa derêri ôriɲ, aɲ a kelê ôbi a ré jê sé kamɲê hen, menba, kwôlê woɲ benare bi wo hen, a emê ɗê kwo tumô hen aɲ sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Menba, Pilat kôlji iyôŋ ba: «Geléŋge, en béŋge asgarɲê hen, erêŋge ken ô gemé mega wo ken geyiɲ hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Menba, bay ô seriɲé kibi kamɲê bay ka hen ta, aɲ ɗi asgarɲê mô gem haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cêgi *sa merê ta a naɲ sa demas naɲ tô kiriɲ kiriɲa kiriɲ ba hendu ɗurum ɗurum tô menba, Mari to Magdala naɲ to pôni hen eraji sa kamɲê ciré sa gelé. ");
INSERT INTO kqp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kiriɲ bay ka hen menba, terare yebagiɲ deɲ deɲ wôsa mana wo Kelma hena derômaraŋ a herbo era sa gerŋge kulmaŋ keram wolé aɲ ɗay mô sara. ");
INSERT INTO kqp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yiri jeraɲnê mega wulaɲê emen iyôŋ men, bargay kari kôba, bôrê môɲ wôbgê iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kemnare li asgarɲê kaɲ bay gemé sa kamɲê hen, aɲ bay wuderé jag jag aɲ bay yi mega temay ɓiɲé iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mana wo Emen kôliɲ yébé bay ka hen iyôŋ ba: «Kemnaŋge ré, en hôn wo kené woge na Jésu wo bay na ɓééri sa gurô tagelê hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ôbi naɲ na, ôbi ji si kamɲê mega wo ôbi na kôliɲ hen iyôŋ. Eraŋge ken sa gel kiriɲa bay na uwôliɲni ya hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aɲ ken ô lew ô kôliɲ bay tôri wo ôbi ré ji si kamɲê, aɲ ré ô tumôrŋge a Galilé yaŋ niɲ aɲ na yaŋ a kené erê geléri. Ôbi a, ené kelêŋge hen.» ");
INSERT INTO kqp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yébé bay ka hen henaji sa kamɲê gerji naɲ kemnare men, naɲ yi derê men, ô kôliɲ bay tô Jésu kwôlê bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Menba, Jésu jô kwiniji aɲ kôlji iyôŋ ba: «En lêŋge dosé.» Menba, bay uso ɗa ligiri a ɓu têri aɲ heramiri. ");
INSERT INTO kqp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Menba, Jésu kôlji iyôŋ ba: «Harêŋge ré, erêŋge ken ô kôliɲ yênên ré ôrji Galilé wôsa na yaŋ a bay ré sa gelen.» ");
INSERT INTO kqp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kiriɲa yébé bay ka hen, baa tô geré tô menba, asgarɲê ka ré gem sa kamɲê hen, ka pôni heraji perê ira sa ô kôliɲ damné kaɲ bay bê kwôbe kwôli are bay ka ciré gelo hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Damné kaɲ bay bê kwôbe uwôge surɲê aɲ daɲji aɲ gengeji bi ciré biɲ asgarɲê bay ka hen lari mê. ");
INSERT INTO kqp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aɲ bay kôl iyôŋ ba: «Kelêŋge iyôŋ ba, bay tôri ré era yoyre sa gômse temayri ôriɲ kiriɲa nini ba tô kum a tô hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A hena ôbi emê sa iyére ré toy ba, niɲa henê kwôlo niɲa kôli aɲ niɲa derêŋge kibi kwôlê a seŋge.» ");
INSERT INTO kqp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asgarɲê bay ka hen, eŋge lari bi wo hen, aɲ kôlji na mega bi wo bay ré kelaji hen iyôŋ. Aɲ kwôlê bi wo hen ôm naɲ kiriɲ kiriɲ perê Jubɲê kwôy kemnêŋ kemnêŋ. ");
INSERT INTO kqp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bay tô Jésu ka môj kibi pôn hen, ôrji Galilé sa keram wo Jésu gelji hen. ");
INSERT INTO kqp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kiriɲa bay gel Jésu menba, bay heramiri, niɲba, ka pôni meremné bôrji a. ");
INSERT INTO kqp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Menba, Jésu uso ɗa ligirji a aɲ kôlji iyôŋ ba: «Emen ben néé woɲ gôliɲ sa aŋga sa terare men, sa ka derômaraŋ a a men. ");
INSERT INTO kqp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Erêŋge yi tô yê ɓiɲé ka sa terare a na kêm aɲ ken beléŋgeji bi bay yi bay tôn aɲ ken liji batêm naɲ hini Iba ɓiɲé men, hini Kemari men, hini Tunu toɲ hendi bô bôrê a men. ");
INSERT INTO kqp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aɲ ken gelji bê kwôlê sa are kêm ka na en ayiɲ tôô béŋge a hen. Aɲ ken hôn wo ené baa naɲ ken naɲ wulê wulê kwôy wo tô terare a kerê.»");
INSERT INTO kqp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kwôlê wo Dôri wo gengiɲ sa Jésu Krist Kema Emen ayiɲ tôri mega hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mega *ôbi kibi Emen *Esay na li bô magtubu to Emen a tumô kôl iyôŋ ba: «Toy, nôbi Emen en jé mana wuɲê tumôm a bi ré ô ɲanê geré wom. ");
INSERT INTO kqp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Na tôô ôbi ulê béré wo ôm derô gwôlê kôl iyôŋ ba: ‹Ɲanêŋge geré wo Kelma men, ɲanêŋge kam geré kari bi ô derôre a men.› » ");
INSERT INTO kqp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na hen iyôŋ a Ja ré so aɲ ôbi liɲ ɓiɲé batêm derô gwôlê men, uwôliɲ béré kôl iyôŋ ba: «Beléŋge cêgerŋge biɲ têriɲ aɲ ken li batêm aɲ bi Emen né ɗiɲ bôri jalê sa têriɲ toŋge a.» ");
INSERT INTO kqp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓiɲé ka bô emê wo Judé kêm naɲ ka Jérusalêm ôrji sa pôn pôn ligiri a. Ɓiɲé bay ka hen tô tô têriɲ toji ta aɲ ôbi liji batêm bô cér wo Jurdê bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ja tôbe bargay ka bay li naɲ gusiri jambal men, ôbi ha tô bôri naɲ ariɲ a men. Ari emêri na céré men, timne a men. ");
INSERT INTO kqp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ôbi uwôl béré kôl iyôŋ ba: «Kwo a era cêgen a hen na, néé wori gôliɲ kuɲê men, en nêm deŋgé terê gaŋgi garbê kaɲ têri ré a men. ");
INSERT INTO kqp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nôbi, en lêŋge batêm na naɲ kam niɲba, ôbi ba a lêŋge batêm naɲ Tunu toɲ hendi bô bôrê.» ");
INSERT INTO kqp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na iyôŋ a, Jésu ré hena Najarêt bô emê wo Galilé aɲ biɲ Ja liri batêm bô cér wo Jurdê. ");
INSERT INTO kqp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kiriɲa Jésu so bô kam a na, ôbi gel derômaraŋ bôliɲ aɲ Tunu toɲ hendi bô bôrê yi mega derare iyôŋ herbo sari a. ");
INSERT INTO kqp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aɲ tô kwôni ôm derômaraŋ a kôl iyôŋ ba: «Ju na Keman, en purem damaŋ men, en li yi derê wô sam damaŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kiriɲ bay ka hen na, Tunu toɲ hendi bô bôrê dô tumô Jésu ôriɲ naɲ ɗi derô gwôlê. ");
INSERT INTO kqp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ôbi li wulê tôre pôrbu derô gwôlê menba, Sidan era sa séli. Jésu mô perê tanare to noni niɲba, *manê ka derômaraŋ a sa li naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kiriɲa bay ɓu Ja uwôl daŋgay a na, Jésu ô bô emê wo Galilé. Ôbi uwôl béré Kwôlo Dôri wo hena ligi Emen a. ");
INSERT INTO kqp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aɲ ôbi kôl iyôŋ ba: «Kiriɲ kô niɲ aɲ *emê iyére to Emen era ɗa niɲ. Ɗéŋge jé lêreŋge wo habiɲ hen ba, aɲ ken bêŋge bôrŋge sa Kwôlo Dôri a.» ");
INSERT INTO kqp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kiriɲa Jésu ô kibi cér wo Galilé na, ôbi gel Simô naɲ yêni André ka na bay uré hen urji kuyê naɲ bera. ");
INSERT INTO kqp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Menba, Jésu kôlji iyôŋ ba: «Eraŋge tôn a aɲ na béŋge ka yé bay uré ɓiɲé ben.» ");
INSERT INTO kqp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kiriɲ bay ka hen na, bay ɗéɲ bera toji aɲ, aɲ ôrji tôri a. ");
INSERT INTO kqp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kiriɲa Jésu ô kelaŋ dê menba, ôbi gel si *Jak naɲ yêni Ja kaɲ kami gawra wo bay uwôgeri Jébédé môrji bô bato ɲanji bera toji. ");
INSERT INTO kqp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kiriɲ bay ka hen na, ôbi uwôgeji menba, bay ɗéɲ ibarji Jébédé hen naɲ bay jé kari bô bato a aɲ ôrji tô Jésu a. ");
INSERT INTO kqp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bay ôrji a sa iyé Kapêrnayôm. Aɲ naɲ sa *sa merê ta a menba, Jésu ô bô *iyéy daɲare a ô geliɲ ɓiɲé are. ");
INSERT INTO kqp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tiniji ge kay sa derê kwôlê wo Jésu dô hen wôsa ôbi iyêl mega kelma ɗiba yi mega *bay derê tô tôô to Emen hen né. ");
INSERT INTO kqp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kiriɲ bay ka hen na, bô iyéy daɲare hende to hen na, gawra wo pôni wo tunu to habiɲ yi bôri a hen soo ira. ");
INSERT INTO kqp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Aɲ hende kôl iyôŋ ba: «Wuge! ju gey na mi yirni a ba? Jésu wo Najarêt. Ju era na wô mênêni. En hôn ju na i ba, ju na kwôni wo yi naɲ jeŋgêri gay wo Emen a jori.» ");
INSERT INTO kqp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jésu ône kôl iyôŋ ba: «Wôm tôŋ aɲ mu séɲ bô gawra bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Menba, tunu to habiɲ hende to hen séɲ bôri a aɲ liri ôbi ka kula men, gwôrêri men. ");
INSERT INTO kqp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɓiɲé kêm hare gaɲ, aɲ bay eŋgeriɲ yirji na ba ré na mi a ré yé hen iyôŋ ba. Derê kwôlê wo kôrbi wo na ba, ré na kwo naɲ néé. Wôsa gawra bi wo hen ay tôô biɲ tunu to habiɲ menba, hende biri kwôlê. ");
INSERT INTO kqp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aɲ hini emê wo Jésu ôm gôriɲ kiriɲ kêm bô emê wo Galilé. ");
INSERT INTO kqp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kiriɲa Jésu men, Simô men, André men, soji bô iyéy daɲare a na, bay ôrji iyé si Simô naɲ André aɲ si Jak naɲ Ja kôba naɲ ci men. ");
INSERT INTO kqp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wulê bi wo hen na, mari Simô kal dere aɲ yi ira menba, bay kôliɲ Jésu kwôle. ");
INSERT INTO kqp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jésu ô kiriɲ ka hende yiɲ ya hen, aɲ ɓu kôbre buru hena ta, menba, hende berare aɲ hende li aŋgaɲ emê biji. ");
INSERT INTO kqp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kiriɲa tare kuriɲ niɲ menba, ɓiɲé ka sa iyére hende to hen eraɲji naɲ bay ômɲare kêm men ɓiɲé ka tunu to habiɲ yi bôrji a hen a men biɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aɲ ɓiɲé kêm ka sa iyére hende to hen daɲji tumô iyére to Jésu môriɲ ya hen. ");
INSERT INTO kqp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jésu berare ɓiɲé kêm ka naɲ ômɲare to gay gay to geliɲ tirji gusiɲ hen men, ôbi dage tunu to habiɲ bô ɓiɲé ka pôni a a men. Niɲba, Jésu jôriɲ tunu to habiɲ iyêlê wôsa hende hôni dô. ");
INSERT INTO kqp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kiriɲa kiriɲ ba hende ɗurum ɗurum tô na, Jésu hena si nô ô wolé derô gwôlê ô uwôbê aɲ uwôl Emen. ");
INSERT INTO kqp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simô naɲ ɓiɲé ka mô naɲ ɗi hen siji ô wogeri, ");
INSERT INTO kqp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","aɲ uwoɲni. Bay kôli iyôŋ ba: «Ɓiɲé kêm wogem.» ");
INSERT INTO kqp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Menba, Jésu kôlji iyôŋ ba: «Na erêŋge naɲ sa iyére iyére bi na erê ulê béré yaŋ men. Na wô bi wo hen a ené soɲ nô wolé hen.» ");
INSERT INTO kqp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aɲ Jésu ô gôr bô emê wo Galilé uwôliɲ béré bô iyéy daɲare a men, dagiɲ tunu to habiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gawra wo pôni wo *terbare liri era ligi Jésu a aɲ kuriɲ tôŋ di tiɲare tumôri a aɲ uwôli ré bô tu ɲa tori aɲ kôli iyôŋ ba: «Hena jeré gey ba já beraren.» ");
INSERT INTO kqp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jésu jé kôbri hebiɲni aɲ kôl iyôŋ ba: «Ew, en gey bi terbare tom hende to hen ré dôriɲ sam a.» ");
INSERT INTO kqp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kiriɲa Jésu kôli hen iyôŋ na, terbare dôriɲ sa gawra bi wo hen, lew, menba, ôbi berare. ");
INSERT INTO kqp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jésu dageri aɲ nayri aɲ kôli kwôlê wo iyêre kôli iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Kôliɲ kwôni kwôlê wôni ré, niɲba, ju ô geliɲ ôbi bê kwôbe yem aɲ ju li sarga naɲ tôô to *Moyis na ay hen aɲ bi bay ré gel wo jeré na kwo séli tumô Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Niɲba, kiriɲa ôbi terbare ô na, ôbi ay tô kôliɲ ɓiɲé kêm, aɲ li wo Jésu nêm erê sa iyére tôni a ba wo ɓiɲé ré hôn né ba naɲ. Jésu ɗubu sêd nono aɲ ɓiɲé sooro gay gay era ligiri a. ");
INSERT INTO kqp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wulê sem cêgê menba, Jésu bulo hera Kapêrnayôm. Ɓiɲé toy mega wo ôbi ré ira hen ya. ");
INSERT INTO kqp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Menba, kwônê ɓiɲé daɲji aɲ li wo kiriɲ dê iyôŋ kôba naɲ men, já uɲé kibi iyére to ôbi môriɲ ya hen né a men. Menba, Jésu ay tô derê tô kwôlo Emen biji. ");
INSERT INTO kqp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bay eraɲ naɲ gawra wo meray biɲ Jésu, ɓiɲé pôrbu a ayari eraɲ. ");
INSERT INTO kqp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Niɲba, bay nêm saɲ naɲ ɗi ligi Jésu a ré, sa kibi kwônê ɓiɲé. Menba, bay surge sa iyére ɗéɲ a kiriɲ ka Jésu ɗibiɲ ya hen aɲ herbiɲji ôbi merayê naɲ jaare to ôbi yi sara hen. ");
INSERT INTO kqp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kiriɲa Jésu gel ayê bôô woji hen iyôŋ menba, ôbi kôliɲ ôbi merayê bi wo hen iyôŋ ba: «Melaɲnen, têriɲ tom dôriɲ sam a.» ");
INSERT INTO kqp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kiriɲ bay ka hen na, *bay derê tô tôô to Emen kôba môrji ya men. Bay erem kwôlê bôrji a ");
INSERT INTO kqp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","iyôŋ ba: «Wô mi a gawra wo hen ré iyêl hen iyôŋ ba? Ôbi tiiré na Emen. I a na ôbi ɗé bôri jalê sa têriɲ a ba? Emen pôn nêŋ a na ôbi ɗé bôri jalê sa têriɲ lê gawra.» ");
INSERT INTO kqp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kiriɲa bay erem hen iyôŋ na, Jésu hôn kwôlo yi bôrji a niɲ aɲ kôlji iyôŋ ba: «Wô mi a kené erem kwôlê wo hen iyôŋ bôrŋge a ba? ");
INSERT INTO kqp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kôliɲ ôbi merayê ‹Têriɲ tom dôriɲ sam a› a derê kelê lew, laba kôli ‹Hena ta ay jaare tom aɲ ju ô› a derê kelê lew ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Haw hen, ka henê wo nôbi *Kema Gawra ené ôriɲ naɲ néé sa terare a nà, wô dôriɲ têriɲ sa ɓiɲé.» Menba, ôbi kôliɲ ôbi merayê na iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«En kôlem, hena ta ay jaare tom ôriɲ iɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Menba, kiriɲ bay ka hen, ôbi hena ta aɲ ay jaare tori lew siɲ nô. Kiriɲ bay ka hen tu ɓiɲé kêm na sari a. Tiniji ge kay aɲ bay ay kibi Emen kôl iyôŋ ba: «Sa pôn nini gel aŋga geliɲ hen iyôŋ né kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jésu si nô si kwa cér wo dami a. Ɓiɲé kêm era yiri a aɲ ôbi halji. ");
INSERT INTO kqp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kiriɲa Jésu ô tô geré menba, ôbi gel Lébi, woɲ kema Alpé, mô kini eŋgé wôgê sa gasugo a menba, Jésu kôli iyôŋ ba: «Era tôn a.» Menba, ôbi hena ô tôri a. ");
INSERT INTO kqp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jésu naɲ bay tôri ômji are iyé Lébi a menba, *bay eŋgé wôgê kwône naɲ bay lê têriɲ môrji ya naɲ ci men. Sa hende to hen na, bay kwône kôbji tôri. ");
INSERT INTO kqp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bay derê tô tôô to Emen kaɲ bay tô Parisiɲêɲê gelji wo Jésu ôm are naɲ bay eŋgé wôgê men, naɲ bay lê têriɲ a men, menba, bay kôliɲ bay tôri iyôŋ ba: «Wô mi a Jésu ré ôm are naɲ ɓiɲé bay ka iyôŋgi hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kiriɲa Jésu toy kwôlê wo bay kôl hen menba, ôbi kôlji iyôŋ ba: «Na ɓiɲé ka ômiɲ a geyé dôktôr ɗiba na ka berari a geyé dôktôr ré. En era sa terare a nà, na wô uwôgê ɓiɲé ka dôrɲê ré, niɲba, en era na wô uwôgê bay lê têriɲ ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kiriɲ bay ka hen na, bay tô Ja ôbi lê batêm naɲ bay tô Parisiɲêɲê jôriɲ bôrji kurôŋ wôsa ayê bôô woji. Ɓiɲé ka pôni era sa eŋgeriɲ Jésu iyôŋ ba: «Wô mi a bay tô Ja ôbi lê batêm naɲ bay tô Parisiɲêɲê ré jôriɲ bôrji kurôŋ wô sa ayê bôô woji menba, bay tom jôbi ba, li hen iyôŋ né wô mi ba?» ");
INSERT INTO kqp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jésu uwôlji sara iyôŋ ba: «Ɓiɲé ka era kini kurô hen ba ka ɗé bi bay ré jôriɲ bôrji kurôŋ kiriɲa ôbi iyéy kurô ba ya naɲ ci tô hen ba? Hena ôbi ré mô naɲ ci ba ya tô na, bay a nêmê kaɲê emê ré. ");
INSERT INTO kqp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wulê wo bay a derê ôbi kurô perêrji a aɲ hen na, na wulê bi wo hen a bay ré jôriɲ bôrji kurôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Kwôni ayrê bargay ka kôrbi uwôliɲ tu ka ôli sa pôn ba? Hena kwôni ré ay bargay ka kôrbi uwôliɲ tu ka ôli na, bargay ka ôli hen na, a yêgiɲ a tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kwôni a bê care to kôrbi bô gwolé woɲ ariɲ wo ôli a ba? Hena ré na iyôŋ na, care hende to hen a anê gwolé bi wo hen. Aɲ care men gwolé a men na, na aŋga a mêniɲ kêm. Dô wo care to a wubé tô hen na, bi biɲ bô gwolé wo kôrbi a.» ");
INSERT INTO kqp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sa to pôni a na sa *sa merê ta menba, Jésu naɲ bay tôri ôrji si bô yagê kaw ka bay uwôgeji blé hen, menba, bay tôri pôy sa kaw bay ka hen kôbriji a ôriɲ ta. ");
INSERT INTO kqp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Menba, Parisiɲêɲê kôliɲ Jésu iyôŋ ba: «Wô mi a, bay tôm ré li aŋga tôô to *Moyis jô lê naɲ sa merê ta hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Menba, Jésu kôlji iyôŋ ba: «Na ken dêŋse kwôli aŋga kelma Dabid na li kiriɲa bay ôriɲ naɲ aŋgaɲ emê ré aɲ kurôŋ na liji naɲ ɓiɲé kari hen né ba? ");
INSERT INTO kqp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ôbi na si bô *iyéy Emen a wulê wo Abiyatar na na ôbi bê kwôbe wo dami hen, aɲ kelma Dabid naɲ ɓiɲé kari ômji mapa bi wo bay tibiɲ Emen hen. Mapa bi wo hen, na yi gengiɲ sa bay bê kwôbe mera hen ba, na li iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Menba, Jésu hô kôlji iyôŋ ba: «Na Emen a biɲ gawra sa sa merê ta ɗiba, Emen na ɗi gawra bi ré uwôl hini emê sa sa merê ta a ré. ");
INSERT INTO kqp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hen iyôŋ na, nôbi Kema Gawra ena Kelma sa sa merê ta men.» ");
INSERT INTO kqp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jésu hô bô *iyéy daɲare. Gawra wo pôni wo kôbri ma mô ya. ");
INSERT INTO kqp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɓiɲé ka mô ya hen bô Jésu ciré gelé sé ôbi ré berarê gawra bi wo hen naɲ sa *sa merê ta wô uwôliɲ kwôlê sari a. ");
INSERT INTO kqp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Menba, Jésu kôliɲ gawra wo kôbri ma bi wo hen iyôŋ ba: «Hena ta ju era sa ɗebe derôre a na.» ");
INSERT INTO kqp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Menba, Jésu eŋgeriɲ ɓiɲé ka ɗebe naɲ ɗi hen iyôŋ ba: «Lê derê men, lê habrê men naɲ sa sa merê ta a ba, na kwo yôŋ a derê ba? Berarê kwôni laba deréri ɗi ba?» Menba, bay mô wôm sidiŋ. ");
INSERT INTO kqp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jésu bôrji pôn pôn naɲ bô tarê men, naɲ tu ɲa a men, wô kibi bô deŋgelé woji. Menba, Jésu kôliɲ ôbi kôbi ma bi wo hen iyôŋ ba: «Jé kôm.» Menba, ôbi ay kôbri ta menba, kôbri bi wo hay hen hô dô hôriɲ kini a. ");
INSERT INTO kqp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kamaŋ Parisiɲêɲê siji nô bô iyéy daɲare a aɲ wogéji geré naɲ ɓiɲé ka kelma *Hérôd wô deré Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jésu naɲ bay tôri dôrji yirji wolé kibi cér wo Galilé. Ɓiɲé kwône ka hena sa iyére to Galilé men, ka hena sa iyére to Judé biri ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ka hena Jérusalêm men, ka hena sa iyé Idumé men, ka hena si cêgi cér wo bay uwôgeri Jurdê hen naɲ ka hena sa iyé Tir a naɲ sa iyé Sidôn. Ɓiɲé kwône era ligiri a wôsa bay toy kwôli are kêm ka ôbi li. ");
INSERT INTO kqp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jésu kôliɲ bay tôri bay ré ɓu sa tê bato biri wô wo kwônê ɓiɲé ma ré ɗirêri. ");
INSERT INTO kqp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jésu li hen iyôŋ wôsa ôbi berare ɓiɲé gaɲ niɲ, aɲ ka ôriɲ naɲ ômɲare yirji a hen nôgeriɲ yirji si ligiri wô hebé yiri aɲ ciré uwôɲiɲ gelé. ");
INSERT INTO kqp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kiriɲa tunu to habiɲ gel Jésu, menba, cibji gubarji tumôri a aɲ kôl kaŋ a ta kôl iyôŋ ba: «Ju na Kema Emen na tiri.» ");
INSERT INTO kqp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Menba, Jésu ɓaŋji dô bi bay ré li bi ɓiɲé ré hôn wo ɗiré na i ba ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jésu hena ô si sa keram a. Ôbi uwôge ɓiɲé ka ôbi tôrji aɲ bay eraji ligiri a. ");
INSERT INTO kqp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aɲ tô môj kibi wôô perêrji a aɲ uwôgeji bay jé men, bay ré ba naɲ ɗi aɲ ôbi jéji ô ulê béré. ");
INSERT INTO kqp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Men, bi bay ré uwôɲ néé wô dagiɲ tunu to habiɲ. ");
INSERT INTO kqp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Imɲê ka môj kibi wôô ka Jésu tôrji hen na, heniji a na: Simô, Jésu biri hini wo ɗaŋgi ré na Piyêr. ");
INSERT INTO kqp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Si *Jak naɲ yêni Ja kaɲ kam Jébédé Jésu biji hini ré na Bowanêrjês, iyayriri na «enê emen». ");
INSERT INTO kqp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Jésu uwôge André, Pilip, Bartélémi, Matiyé, Tomas, Jak woɲ kema Alpé, Tadé, Simô woɲ kema iyére hen ");
INSERT INTO kqp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","naɲ Judas Iskariyôt wo a sa derê tumô bay bayi Jésu aɲ bi bay ré sa ɓiri hen. ");
INSERT INTO kqp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Menba, Jésu bulo hera ô ira menba, kwônê ɓiɲé hô daɲji sôŋ aɲ li wo Jésu naɲ bay tôri uwoɲji kini emê ani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kiriɲa bay gel yi hen iyôŋ na, balê Jésu sa dôri ôriɲ wôsa bay kôl iyôŋ ba: «Ôbi gal.» ");
INSERT INTO kqp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Menba, bay derê tôô to Emen ka hena Jérusalêm kôlji iyôŋ ba: «*Béyêljébul mô bôri a, na kelma wo tunu to habiɲ hende to hen a biri nééri aɲa ôbi ré dagiɲ tunu to habiɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jésu uwôge ɓiɲé ligiri a aɲ kôlji kwôlê naɲ gwosore kôl iyôŋ ba: «Sidan sa pôn dagerê yiri sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hena ɓiɲé ka bô emê iyére tôni a ré kariɲji aɲ sêɲji ba, emê iyére hende to hen a yé sem né. ");
INSERT INTO kqp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hena ɓiɲé ka pôn bô ira kariɲji aɲ sêɲji ba, bô iyére hende to hen a yé sem né. ");
INSERT INTO kqp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hena Sidan né sêɲ naɲ yiri gaŋ na, néé wori a naɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«I a nêmê wô piyê kibi geré wo ôbi néé aɲ siɲ ira ô pôriɲ aŋgari ba? Hena kwôni ré gey lê hen iyôŋ na, ôbi a harêri tumô pa dem aɲa ré ɗiɲ yiri pôriɲ aŋgari tô.» ");
INSERT INTO kqp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Na tu kwôlê a ené ena kelêŋge hen, têriɲ to ɓiɲé kêm men kiriɲa bay a kelê kwôlo habiɲ gengiɲ sa Emen a men na, têriɲ toji hende to hen a dôriɲ sarji a. ");
INSERT INTO kqp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Niɲba, i i wo kôl kwôlo habiɲ gengiɲ sa Tunu toɲ hende bô bôre na, têriɲ tori hende to hen a dôriɲ né yôd. Wôsa na têriɲ to yi naɲ kunu a ôbi ré li hen.» ");
INSERT INTO kqp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jésu kôl hen iyôŋ, wôsa bay kôl tunu to habiɲ ré yi bôri a. ");
INSERT INTO kqp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yoo Jésu naɲ yênêri saji aɲ ɗibiji nô, bay jé uwôge Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kwônê ɓiɲé mô mééri ta menba, bay kôli: «Ju toy, yom naɲ yênêm ɗibiji nô hen ya. Bay geyem.» ");
INSERT INTO kqp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Menba, Jésu kôlji iyôŋ ba: «Ɓiɲé ka yôŋ a na yon men, yênên men ba?» ");
INSERT INTO kqp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Menba, Jésu bô kwônê ɓiɲé ka mô tôŋ kwari a hen aɲ kôbji, menba, ôbi kôl iyôŋ ba: «Berêŋge nà, ken gel kwônê ɓiɲé ka yi hen na, bay a yé mega yon men, yênên men iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kwôni wo li aŋga Emen gey hen na, ôbi a na yênen men, yêren men, yon men.» ");
INSERT INTO kqp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jésu hô ay tô geliɲ ɓiɲé are kibi cér wo Galilé. Kwônê ɓiɲé era sa daɲ ligiri a, aɲ li wo ôbi ɗay mô bô bato wo yi bô cér a hen, aɲ tô kwônê ɓiɲé ka ba hen ɗibiji terare a ɗa kwa cér a. ");
INSERT INTO kqp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jésu geliɲ kwônê ɓiɲé are ɗé ɗé naɲ gwosoy kwôlê gay gay. Ôbi kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Toyéŋge, sa to pôni gawra wo pôni si ô wô wusé kaw bô yagê wori a. ");
INSERT INTO kqp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kiriɲa ôbi wuse kaw bay ka hen iyôŋ na, kwa ka pôni heriɲ bêŋgê geré aɲ ciré sa gôl ôm. ");
INSERT INTO kqp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kwa ka pôni heriɲ kiriɲ kaɲ jerew a niɲba, terare to wurôbi to hanêre ré ôriɲ tôŋ ba naɲ. Menba, bay si lew haji, ");
INSERT INTO kqp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","niɲba, kiriɲa tare jôriɲ, menba, jubu gaɲ aɲ kaw bay ka ré heriɲ kiriɲ kaɲ jerew a hen na, ma wôsa hanêrji ô kelaŋ né. ");
INSERT INTO kqp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kwa ka pôni heriɲ perê gesem a. Kiriɲa bay si, menba, gesem bi wo hen yêrji aɲ sarji si ré. ");
INSERT INTO kqp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kwa ka pôni heriɲ terare to dôri a aɲ si dô men, ɗebe dô men, yê dô a men. Sa ka pôni gusiɲniji ô tôre subu, ka pôni tôre jii men, ka pôni ô arew men.» ");
INSERT INTO kqp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Menba, Jésu kôl iyôŋ ba: «Kwôni wo mari ya wô toyiɲ kwôlê bi wo hen ba, bi toy.» ");
INSERT INTO kqp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kiriɲa kwônê ɓiɲé ôrji ta niɲ menba, bay tô Jésu ka môj kibi wôô hen naɲ ka ɗaŋgi ka mééri hen, eŋgeriri kwôlê gengiɲ sa gwosore to ôbi ré iyêlji hen. ");
INSERT INTO kqp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Menba, Jésu kôlji iyôŋ ba: «Kwoŋge kenbay ba, Emen béŋge ken hôn aŋga gengiɲ sa emê iyére tori ka yi kini uwôbêrji a hen. Niɲba, ɓiɲé ka ba nô hen ba, toy na bô gwosore a. ");
INSERT INTO kqp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Are bay ka hen yi hen iyôŋ aɲ bi ‹kiriɲa bay ré bô kiriɲ ba, bay ré gel ani ré men, kiriɲa bay ré toy kwôlê ba, bay ré hôn bôri ré men. Yi hen iyôŋ wô wo bay ma ré ayê bôrji aɲ bi têriɲ toji ré dôriɲ iyôŋ né.› » ");
INSERT INTO kqp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jésu hô kôlji iyôŋ ba: «Ken hôn bô gwosoy kwôlê wo hen né ba? Ka lê iyeŋ a kené henê tô gwosore to ɗaŋgi to ba hen ba? ");
INSERT INTO kqp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ôbi wusé kaw, wuse kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓiɲé ka yi mega bêŋgê geré ka kaw heriɲ ya hen na, na ɓiɲé ka toy kwôlê bi wo hen menba, Sidan era lew sa mêne kwôlê wo bay ré toy hen bôrji a aɲ. ");
INSERT INTO kqp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɓiɲé ka yi mega kiriɲ kaɲ jerew ka kaw heriɲ ya hen na, na ɓiɲé ka toy kwôlê bi wo hen, menba, eŋge naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Niɲba, ɓiɲé bay ka hen na, hanêrji naɲ men, bay ɗebe sa têrji a sem né a men. Aɲ kiriɲa aŋgaɲ bô emê kuriɲ sarji a ley, bay gilji gusiɲ ley, wô kibi kwôlê bi wo hen na, bay heriɲ. ");
INSERT INTO kqp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ɓiɲé ka yi mega kiriɲ kaɲ gesem ka kaw heriɲ ya hen na, na ɓiɲé ka toy kwôlê bi wo hen, ");
INSERT INTO kqp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","niɲba, ermé kwôlo sa terare a nà men, kwôli aŋgaɲ uɲé men, ermé sa doy aŋga gay gay a men na, yêr kwôlê bi wo hen duu aɲ li ani ré. ");
INSERT INTO kqp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ɓiɲé ka yi mega kiriɲ ka dôri ka kaw heriɲ ya hen na, na ɓiɲé ka toy kwôlê bi wo hen aɲ ay liɲ jé sara, bay yi mega kaw ka uwoɲ kiriɲ ka dôri iyôŋ. Bay toy kwôlê bi wo hen men, bay eŋge aɲ liɲ ariri a men. Aɲ ka pôni gusiɲniji ô tôre subu men, ka pôni tôre jii men, ka pôni ô arew men.» ");
INSERT INTO kqp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jésu hô eŋgeriji iyôŋ ba: «Kwôni ɗi tare bô lampa aɲ emné gwore sara réba ɗéré tô kalaŋ a sa pôn ken gel ba? Hena ôbi ré ɗi tare a bô lampa ba, na wô teré ta gurô pal a ré ba? ");
INSERT INTO kqp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wôsa aŋga yi kini uwôbêrji a ba, a sa yé tu wolé men, ka kwôni hôn né tô ba, a sa yé tu tare a nô men. ");
INSERT INTO kqp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hena kwôni ré naɲ mari wô toyiɲ kwôlê wo en kôl hen na, bi toy.» ");
INSERT INTO kqp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jésu hô kôlji iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a wôsa kwôlê wo ken toy a. Gway wo ken ay gengiɲ are bi hen a Emen né hô gengiɲ béŋge hôriɲ, dô réba a ɗê kwo na ken liɲ megêrna hen sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wôsa kwôni wo naɲ uɲé ba, bay a hô biri a sara. Niɲba, kwo ari uɲé kari lôg hen na, bay a derê bay ka lôg hen kôbri a aɲ sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jésu hô kôlji iyôŋ ba: «*Emê iyére to Emen na, yi mega gawra wo ô wusé kay cé bô yagê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kiriɲa ôbi yi kum yoyre men, hena ta tô kiriɲ men na, ôbi hôn na ba kaw ka ɗiré wusu hen ré si iyeŋ ba men, ré ɗubu iyeŋ ba a men ba, ôbi hôn né. ");
INSERT INTO kqp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Terare bi kay cé gwôbe aɲ ɗubu cêgeri wori ba, kaw si sa, cêgeri wori sôŋ sa kaw bay ka hen yi gusiɲ. ");
INSERT INTO kqp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aɲ kiriɲa sa kaw né niɲ na, bay jé bay walêrji sa wal wôsa na tay walêrji niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jésu hô kôl iyôŋ ba: «Emê iyére to Emen na, na gengére naɲ mi pôn ba? Na mi a nana ayê gengiɲ ba? ");
INSERT INTO kqp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Emê sa iyére to Emen na, yi mega gusiɲ iluw iyôŋ. Kiriɲa kwôni ciji na, bay dê gôliɲ gusiɲ aŋga kêm ka terare a na. ");
INSERT INTO kqp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Niɲba, kiriɲa kwôni ciji na, bay si aɲ ɗubu aɲ yi gurô wo dami gôliɲ sa gurô ka ɓiɲé ban hen, aɲ kôbri gaɲné aɲ li wo ciré ka derômaraŋ a kêm sa li gwoné woji ya.» ");
INSERT INTO kqp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na naɲ gwosoy kwôlo gay gay bi wo hen a Jésu uwôliɲ béré. Ôbi kôl hen iyôŋ aɲ bi ka ɗebe toy hen, ré hôn dô. ");
INSERT INTO kqp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jésu kôlji kwôlê wôni ba ulê gwosore bô ré. Niɲba, kiriɲa ôbi na pini naɲ bay tôri na, ôbi dôrji tô gwosore hende to gay gay hen. ");
INSERT INTO kqp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wulê bi wo hen na, Jésu kôliɲ bay tôri iyôŋ ba: «Na ɗayêŋge tera cér wo dami hen.» ");
INSERT INTO kqp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bay ɗéɲ kwônê ɓiɲé menba, bay tôri ôriɲ naɲ ɗi bô bato a wo ôbi môriɲ hen, bato ka ɗaŋgi kwône kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kiriɲ bay ka hen na, kal wo dami ge aɲ di kam bi a bô bato aɲ li wo kam wôn bôri. ");
INSERT INTO kqp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Menba, kiriɲ bay ka hen Jésu gesel sari yiɲ kum si tô bato yaŋ. Bay tôri eŋni aɲ kôli iyôŋ ba: «*Rabi, ju gel wo naa mêniɲ hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jésu eŋgiɲ tô kum a aɲ ône kal naɲ nééri men, kôliɲ cér iyôŋ ba: «Cér wôm tôŋ.» Menba, kal ɗi geré ba men, kiriɲ iyer iyêêr a men. ");
INSERT INTO kqp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Wô mi a kené hare hen iyôŋ ba? Wô mi a kené bi bôrŋge sa Emen a ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kiriɲ bay ka hen na, harê wo dami liji men, tiniji ge kay a men aɲ bay kôl perêrji a iyôŋ ba: «Gawra wo nà, ná kwo iyeŋgi a kal naɲ cér kôba, ré biri kwôlê hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bay era sa biɲ cêgi cér wo bô emê wo Géraséniɲê. ");
INSERT INTO kqp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Menba, Jésu herbe tôŋ menba, gawra wo pôni so si sa kamɲê iyôŋ, aɲ era ligiri a. Na gawra wo tunu to habiɲ mô bôri a. ");
INSERT INTO kqp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gawra bi wo hen na, kini merêri na sa kamɲê aɲ kwôni nêm ɓeréri harêri naɲ gaŋgi musure ré. ");
INSERT INTO kqp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wôsa bay ulêri gaŋgi musure têri a men kôbri a men. Niɲba, ôbi ka gaŋgi musure hende to hen aɲ. Aɲ kwôni nêm wo a ɓeréri biɲ né. ");
INSERT INTO kqp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sa pôn pôn ôbi mô sa kamɲê men, sa keramɲê men, karê kula men, walê yiri naɲ jerew a men. ");
INSERT INTO kqp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kiriɲa ôbi gel Jésu kelaŋ menba, guro aɲ sa cubu gubari tumôri a. ");
INSERT INTO kqp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Menba, ka kula naɲ néri kôl iyôŋ ba: «Ju gey mi yen a ba, Jésu Kema Emen wo ta, en uwôlem naɲ hini Emen, gelen gusiɲ né.» ");
INSERT INTO kqp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ôbi kôl hen iyôŋ wôsa Jésu kôl iyôŋ ba: «Tunu to habiɲ si aɲ bô gawra bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Menba, Jésu eŋgeriri iyôŋ ba: «Henem na i ba?» Menba, ôbi kôli iyôŋ ba: «Henen na kwônê ɓiɲé, wôsa nini kwône.» ");
INSERT INTO kqp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Menba, ôbi kôliɲ Jésu iyôŋ ba: «En uwôlem dage tunu to habiɲ hende to hen aɲ bô emê woni a.» ");
INSERT INTO kqp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kiriɲ bay ka hen na, ɗa kwa keram a na, kwônê gwôsiɲô ka ôm are ɗebiji ya. ");
INSERT INTO kqp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tunu to habiɲ hende to hen uwôliɲ Jésu kôl iyôŋ ba: «Nini uwôlem dagêni bê bô gwôsiɲô ka ɗubu hen.» ");
INSERT INTO kqp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jésu gey naɲ ci sara. Aɲ tunu to habiɲ hende to hen siji ôrji bô gwôsiɲô bay ka hen, aɲ li wo gwôsiɲô bay ka sak wôô hen yêseraji ta sa keram a heriɲji bô kam a, aɲ yiji kam maji kêm. ");
INSERT INTO kqp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bay gemé gwôsiɲô bay ka hen ge ô kôliɲ ɓiɲé derô ira men, kôliɲ ɓiɲé nono men, kwôli are bay ka hen, aɲ ɓiɲé kêm ôrji gelé. ");
INSERT INTO kqp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bay era ligi Jésu a aɲ gel gawra wo na ôriɲ naɲ tunu to habiɲ bôri a hen. Ôbi mô tôŋ men, tôbe bargay men, tiri iyer dô a men. Kiriɲa bay gel hen iyôŋ, menba, harê liji. ");
INSERT INTO kqp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓiɲé ka ré gel aŋga sa sa gawra bi wo tunu to habiɲ na bôri a hen men, aŋga sa sa gwôsiɲô hen a men hen na, bay ô dôriɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Menba, ɓiɲé kêm ay tô eŋgeré Jésu ré si erêɲ bô emê woji a. ");
INSERT INTO kqp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kiriɲa Jésu ɗay bô bato a menba, gawra wo tunu to habiɲ na bôri a hen, eŋgeriri ɗiré erê naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jésu jôri aɲ kôli iyôŋ ba: «Ô iɲ tom ligi balêm a aɲ ju kôlji kwôli aŋga Kelma li naɲ ju hen men, na iyeŋ a ôbi ré bô tu ɲa tom ba men.» ");
INSERT INTO kqp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ôbi ô aɲ kôliɲ ɓiɲé naɲ sa iyére iyére to tôre môj hen kwôli aŋga Jésu ré li naɲ ɗi hen aɲ ɓiɲé kêm tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jésu ɗay naɲ bato ô si cêgi cér menba, kwônê ɓiɲé hô daɲji ligiri a. Jésu mô na kibi cér a. ");
INSERT INTO kqp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kiriɲ bay ka hen menba, gawra wo pôni kwo bay uwôgeri Jayrus. Ôbi na kelma woɲ sa *iyéy daɲare to pôni. Kiriɲa ôbi gel Jésu menba, ôbi cubu gubari tumôri a, ");
INSERT INTO kqp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aɲ uwôli kôl iyôŋ ba: «Môɲnen to dê ta ma, era ju sa uwôl kôm sara bi hende gôl ben, aɲ bi hende wôl sum sa terare a na.» ");
INSERT INTO kqp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jésu hena ô naɲ ɗi menba, kwônê ɓiɲé ô tôri a aɲ nôgeriɲ yirji. ");
INSERT INTO kqp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kiriɲ bay ka hen na, iyore to pôni kwôbe ô yere a li elê môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hende li tu ɲa gaɲ kiriɲa ɓiɲé gay gay woge geré ciré berarêre men, hende mêne kôbre gaɲ a men, niɲba, hende berare ré. Yere hô lere ôriɲ tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iyore hende to hen toy kwôli Jésu naɲ aŋga ôbi li hen menba, hende era perê kwônê ɓiɲé si cêgeri aɲ hende hebe bargay kari. ");
INSERT INTO kqp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wôsa hende kôl bôre a iyôŋ ba: «Hena ené hebe bargay kari mera kôba, na berarê seŋge.» ");
INSERT INTO kqp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kiriɲ bay ka hen na, kwôbe wo na ô yere a hen na, naɲ aɲ yere gware aɲ hende berare. ");
INSERT INTO kqp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jésu bô mega kwa nééri ré dôri menba, ôbi bul hô perê kwônê ɓiɲé aɲ kôl iyôŋ ba: «Na i a hebé bargay kaɲê ba?» ");
INSERT INTO kqp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Menba, bay tôri kôli iyôŋ ba: «Ju gel kwônê ɓiɲé ka nôgerem hen né aɲ jeré kôl: ‹Na i heben ba?› » ");
INSERT INTO kqp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Menba, Jésu bô kwari ɗiré gelé i a ré heberi hen ba. ");
INSERT INTO kqp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iyore hende to hen na, hare aɲ wuré wôsa hende hôn aŋga sa sara hen. Menba, hende era sa cubu gubare tumô Jésu a aɲ kôli aŋga ré li are hen. ");
INSERT INTO kqp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Menba, ôbi kôle iyôŋ ba: «Yêren, ayê bôô woré gôliɲ naɲ mu, ô naɲ bô jalê aɲ bi ômɲare toré hende to hen dôriɲ sarê yôd.» ");
INSERT INTO kqp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kiriɲa Jésu iyêl ba ya tô menba, ɓiɲé ka bô iyé kelma woɲ ôbi sa iyéy daɲare hen saji sa kôliɲ kelma bi wo hen iyôŋ ba: «Môɲnem na ma niɲ, menba, ju dôyrê *Rabi wô mi sôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Niɲba, Jésu toy kwôlê bi wo bay kôl hen menba, ôbi kôliɲ kelma woɲ sa iyéy daɲare hen iyôŋ ba: «Hare ré, bi bôm san a.» ");
INSERT INTO kqp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jésu jô wo kwôni ré biri niɲba, ɓiɲé ka ô naɲ ɗi a na Piyêr men, *Jak naɲ yêni Ja men. ");
INSERT INTO kqp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bay saji iyé kelma woɲ ôbi sa iyéy daɲare a. Kiriɲ bay ka hen Jésu gel wo ɓiɲé herage men, ka pôni sôm men, karêji kula a men. ");
INSERT INTO kqp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ôbi si bô ira aɲ kôlji iyôŋ ba: «Wô mi a kené herage gaɲ men, sômnê a men iyôŋ ba? Mône to nà ná, ma ré, hende yi na kum.» ");
INSERT INTO kqp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Menba, bay ayrêri. Kiriɲ bay ka hen na, Jésu dageji kêm nô aɲ ay iba mône naɲ yore men, ɓiɲé ka ré biri hen men, ôriɲ naɲ ci bô iyére to mône hende to hen yiɲ ya hen. ");
INSERT INTO kqp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jésu ɓu kôbi mône aɲ kôl iyôŋ ba: «Talita kum.» (Iyayriri na: «Mône hena ta, en kôlê.») ");
INSERT INTO kqp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kiriɲ bay ka hen na, hende hena aɲ ô ta. Mône hende to hen na elêre na môj kibi wôô. Ɓiɲé ka ɗubu ya hen na, tiniji ge kay damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jésu kôlji iyôŋ ba, kwôlê wo hen na, bay ré kôliɲ kwôni ré pa pa. Menba, ôbi kôlji bay ré bure aŋgaɲ emê. ");
INSERT INTO kqp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jésu erêɲ kiriɲ bay ka hen aɲ hô sa iyére tori a aɲ bay tôri ôrji naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kiriɲa sa *sa merê ta nêm menba, Jésu ay tô geliɲ ɓiɲé are bô *iyéy daɲare a. Kwônê ɓiɲé ka mô ya hen na, toy kwôlo ôbi kôl hen menba, tiniji ge kay aɲ bay kôl iyôŋ ba: «Gelé aŋga na ba, hena na yôŋ sôŋ ba? Tu melênê wo na ba, i a biri ba? Iyeŋ a ôbi ré li giɲê wo yi iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jésu na ôbi albê gurô ré ba? Mari a na yori ré ba? *Jak men, Josês men, Jud men, Simô a men a na yênêri ré ba? Yênêri kaɲ yébé môrji perêrna nà ya ré ba?» Kiriɲ bay ka hen na, ermé woji liji kwôy aɲ bay kaɲni. ");
INSERT INTO kqp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Menba, Jésu kôlji iyôŋ ba: «*Ôbi kibi Emen na, kiriɲ ka ɗaŋgi a ba bay a biri kwôlê haji, niɲba, sa iyére tori men, perê balêri a men na, bay biri kwôlê ré.» ");
INSERT INTO kqp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kiriɲ bay ka hen na, Jésu li aŋgaɲ giɲê kani pôn né kwôy, niɲba, ôbi berare bay ômɲare ka pôni uwôliɲ kôbri sarji a. ");
INSERT INTO kqp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bê wo bay bi bôrji sari a ré hen na, ɗê sari. Jésu ô naɲ sa iyére ɗa ɗa hen wô geliɲ ɓiɲé are. ");
INSERT INTO kqp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na hen iyôŋ a, ôbi ré uwôge bay tôri ka môj kibi wôô aɲ jéji wôô wôô aɲ biji néé bi bay ré dagiɲ tunu to habiɲ. ");
INSERT INTO kqp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jésu kôlji iyôŋ bay ré ay ani kani pôn kôbriji a ré. Bay ré ay saade wôni ré men, magela wôni ré men, selé tôni ré men, niɲba bay ré ay na kwoore kôbriji a mera. ");
INSERT INTO kqp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bay ré dôbe garbê têrji a, niɲba, bay ré tôbe bargay wôô wôô ré. ");
INSERT INTO kqp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jésu hô kôlji iyôŋ ba: «Kiriɲa ken si bô iyére tôni a na, ken mô ya kwôy jéɲ kiriɲa ken ôriɲ ta. ");
INSERT INTO kqp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kiriɲ ka yôŋ yôŋ ka ken ô ya aɲa bay ré ɓeréŋge yirji a ré men, bay toy kwôlê kebreŋge a ré a men na, ken gage beni têrŋge. Ôbi a na aŋgaɲ gelé ka a ulê kwôlê sarji a.» ");
INSERT INTO kqp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bay tô Jésu ôrji aɲ uwôlji béré biɲ ɓiɲé aɲ bi bay ré bul cêgeriji biɲ têriɲ toji. ");
INSERT INTO kqp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bay dage tunu to habiɲ kwône men, bay ɓu sa bay ômɲare kwône naɲ weŋ aɲ bay berare. ");
INSERT INTO kqp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kelma *Hérôd toy kwôlê wo ɓiɲé kôl hen wôsa wulê bi wo hen na, hini Jésu ôm gôriɲ kiriɲ. Aɲ bay kôl ôbi ré na Ja ôbi lê batêm a ré so hera perê ɓiɲé ka ma a na wô bi wo hen a ôbi ré ôriɲ naɲ néé woɲ liɲ aŋgaɲ geɲê kêm hen. ");
INSERT INTO kqp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Men, ka pôni kôl iyôŋ ba: «Na *Eli», ka ɗaŋgi kôl iyôŋ ba: «Na ôbi kibi Emen mega ka ca tumô hen.» ");
INSERT INTO kqp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kiriɲa Hérôd toy kwôli aŋga Jésu li hen menba, ôbi kôl iyôŋ ba: «Na Ja ôbi lê batêm wo na en bi bay naa, jô sari hen a hô hera sôŋ hen.» ");
INSERT INTO kqp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wôsa Hérôd naɲ yiri a na bé bay na ɓu Ja ôbi lê batêm aɲ bay harêri naɲ gaŋgi musure aɲ bay uwôli daŋgay a. Ôbi li hen iyôŋ wô kibi *Hérodiyad toɲ tami yêni Pilip to ôbi ayre liɲ tamni hen. ");
INSERT INTO kqp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ja ôbi lê batêm na kôliɲ Hérôd iyôŋ ba: «Dé wo jeré ayê tam yênem liɲ tamnem ré.» ");
INSERT INTO kqp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hérodiyad bôre tare gaɲ sa kwôlo Ja ôbi lê batêm kôl hen aɲ hende gey teré deréri, niɲba, hende nêm né. ");
INSERT INTO kqp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hérôd kemnaɲ Ja ôbi lê batêm gaɲ. Wôsa ôbi ré na kwôni wo ré li are naɲ gerérji men, ôbi ré na ôbi bô bôrê a men. Menba, Hérôd jô sari. Kiriɲa Ja ôbi lê batêm kôliɲ Hérôd kwôlê hen iyôŋ na, Hérôd dôbe mari dô toyiɲ men, kwôlê wori bi wo hen dôyrêri damaŋ a men, niɲba, ôbi toyri naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sa to pôni a na Hérodiyad uwoɲ geré. Sa hende to hen na, na sa lê yi derê gengiɲ geserê sa yê Hérôd. Hérôd li aŋgaɲ emê uwôgeriɲ ɓiɲé ka li jé naɲ ɗi hen men, dami ka asgarɲê men, bay uɲé ka damné damné ka bô emê wo Galilé a men. ");
INSERT INTO kqp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kiriɲ bay ka hen na, môni Hérodiyad soo bô ira naɲ wôrê. Menba, wôrê wore bi wo hen dôriɲ Hérôd gaɲ men, dôriɲ kergê kari gaɲ a men. Menba, kelma Hérôd kôliɲ môni temale hende to hen iyôŋ ba: «Eŋgeren aŋga mu gey mera aɲ na béré.» ");
INSERT INTO kqp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hérôd dusu yiri buru kôl iyôŋ ba: «Aŋga yôŋ yôŋ ka mu gey na, na béré, hena ré na soré kwa emê iyére tiɲê bi meré emê kôba na béré.» ");
INSERT INTO kqp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hende si kiriɲ ka hende ré wôriɲ hen aɲ, aɲ ô eŋgeré yore iyôŋ ba: «Na mi a ené eŋgere ba?» Menba, yore uwôle sara iyôŋ ba: «Eŋgere sa Ja ôbi lê batêm.» ");
INSERT INTO kqp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hende hô bul hô lew bô iyére to kelma Hérôd môriɲ ya hen. Hende ô ligiri a aɲ kôli iyôŋ ba: «En gey bi jeré ben sa Ja ôbi lê batêm lew bô subra.» ");
INSERT INTO kqp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Menba, tiri mêne damaŋ. Niɲba, wô tôô to ôbi ré ay hen men, wô tu kwônê kergê kari a men na, ôbi gey jôriɲ mône hende to hen aŋga hende eŋgere hen né. ");
INSERT INTO kqp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kelma Hérôd bi asgar pôn era lew aɲ kôli ré ô jera sa Ja ôbi lê batêm daŋgay a eraɲ. Asgar bi wo hen ô jerê sa Ja ôbi lê batêm daŋgay a, ");
INSERT INTO kqp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","aɲ ula bô subra eraɲ aɲ biɲ môni temale hende to hen aɲ hende ôriɲ biɲ yore. ");
INSERT INTO kqp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kiriɲa bay tô Ja toy hen iyôŋ na, bay era sa ay temayri ô emé. ");
INSERT INTO kqp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bay jé daɲji ligi Jésu a aɲ bay kôli kwôli aŋga ciré la hen men, kwôli gelé wo ciré geloɲ ɓiɲé are hen a men. ");
INSERT INTO kqp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Menba, Jésu kôlji iyôŋ ba: «Eraŋge naɲ en na erêŋge wolé sêd aɲ derô gwôlê aɲ ken dô bul dê.» Ôbi kôlji hen iyôŋ wôsa ɓiɲé kwône era ligirji a men, hôrji aɲ bay uwoɲ kiriɲ kaɲ emê ani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jésu naɲ bay tôri ɗayji bô bato wô erê wolé derô gwôlê kelaŋ naɲ iyére. ");
INSERT INTO kqp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɓiɲé kwône gelji wo bay ô hen menba, ɓiɲé kwône hônji aɲ ɓiɲé naɲ sa iyére iyére gerji naɲ têrji saji tumô kiriɲ ka Jésu naɲ bay tôri ca erê ya hen. ");
INSERT INTO kqp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kiriɲa Jésu herbo tôŋ bô bato a menba, ôbi gel kwônê ɓiɲé menba, tirji liri ɲa wôsa bay yi môɲ gamgê ka ôbi abêrji naɲ iyôŋ. Menba, ôbi ay tô halêji gengiɲ sa are kwône. ");
INSERT INTO kqp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kiriɲa kiriɲ kô gaɲ niɲ, menba, bay tô Jésu era ligiri a aɲ kôli iyôŋ ba: «Kiriɲ ka nà ná, kelaŋ men, kiriɲ kôba kô a men, ");
INSERT INTO kqp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","dô wo ju kôliɲ ɓiɲé bi bay ô sa kam iyére ka ɗa ɗa na ô wogé ani kelé emê.» ");
INSERT INTO kqp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Menba, Jésu uwôlji sara iyôŋ ba: «Kenbay ken biji aŋgaɲ emê.» Menba, bay kôli iyôŋ ba: «Hen ba, niɲa erê kelé mapa na tu *déniyé arew wôô dema niné biji a bay ré emê ba?» ");
INSERT INTO kqp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Menba, Jésu eŋgeriji iyôŋ ba: «Ken naɲ mapa iyeŋ ba? Erêŋge ken ô gelé.» Menba, bay ô gelé aɲ kôli iyôŋ ba: «Mapa na bay naɲ kuyê wôô.» ");
INSERT INTO kqp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kiriɲ bay ka hen Jésu kôliɲ bay tôri iyôŋ ba: «Biɲge ɓiɲé ré mô tôŋ naɲ gwogelérji gwogelérji sa kalmê ka geɲ a hen.» ");
INSERT INTO kqp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Menba, ɓiɲé mô naɲ gwogelérji, gwogelérji hen iyôŋ. Ka pôni na arew men ka pôni tôre bay men. ");
INSERT INTO kqp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jésu pô mapa wo bay hen naɲ kuyê ka wôô hen kôbri a aɲ ôbi bô kiriɲ si derômaraŋ aɲ liɲ Emen dosé aɲ ɓiilê mapa kôbri a aɲ biɲ bay tôri ré céɲ ɓiɲé. Ôbi hô ka kuyê ka wôô hen aɲ biji bi bay ré céɲ ɓiɲé kêm a sara. ");
INSERT INTO kqp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓiɲé bay ka hen ôm uyirê. ");
INSERT INTO kqp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aɲ tô mapa wo ba naɲ tô kuyê ka ba hen na, bay pô wiinê gwaɲê môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Perê ɓiɲé ka ôm mapa bi wo hen na, imɲê na dubu bay. ");
INSERT INTO kqp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kiriɲa ɓiɲé ôm mapa kô hen iyôŋ niɲ na, Jésu bi bay tôri ɗay bato a ré ôrji tera tumô si kwa wo Bêtsayda aɲ ɗôbi ɗiré ba cêgê wô kôliɲ ɓiɲé ré irê iɲ niɲ, dema ɗiré erê tôrji a tô. ");
INSERT INTO kqp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kiriɲa Jésu kôliɲ ɓiɲé ré irê iɲ niɲ, menba, liji dosé aɲ ɗiɲ yiri ô sa keram a wô uwôlê Emen. ");
INSERT INTO kqp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kiriɲa tare kuriɲ na, bato wo bay tô Jésu ɗubu derô cér a bôb menba, Jésu ɗubu terare a pini. ");
INSERT INTO kqp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jésu bô wo bay tôri geliɲ gusiɲ sa jibé bato bô cér a wôsa kal ge si tumôrji menba, kiriɲa kwôrê ka tumô yel niɲ hen menba, ôbi era sa kam a si ligirji menba, ô mega ɗiré dêji jerê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kiriɲa bay tôri gili wo ôbi era sa kam a hen iyôŋ menba, bay erem yaŋ ba ré na, kamɲê menba, harê liji aɲ bay bi gura. ");
INSERT INTO kqp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wôsa bay geli kêm aɲ harê liji gaɲ. Kiriɲ bay ka hen, menba, Jésu iyêlji kwôlê kôl iyôŋ ba: «Harêŋge ré, na nôbi Jésu ɗéŋge bôrŋge jal.» ");
INSERT INTO kqp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Menba, ôbi ɗay naɲ ci bô bato a menba, kal iyer men. Menba, tiniji ge kay damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wôsa bay na hôn bô geɲê wo gengiɲ sa mapa wo na tumô hen né wô kibi bô deŋgolé woji. ");
INSERT INTO kqp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kiriɲa bay di cér jô menba, bay saji bô emê wo Génésarêt menba, bay wuro bato sa ha kwoŋgé cér a. ");
INSERT INTO kqp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kiriɲa bay herbe tôŋ bô bato a menba, ɓiɲé bô Jésu hôn. ");
INSERT INTO kqp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Menba, bay guroji naɲ sa iyére iyére peraji bay ômɲare naɲ jaare ôriɲji kiriɲ ka yôŋ yôŋ ka bay toy wo Jésu ré ô ya hen. ");
INSERT INTO kqp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kiriɲ ka yôŋ yôŋ ka Jésu ô ya na, ré na sa iyére to dê, ré na to dami a kôba ɓiɲé eraɲ naɲ bay ômɲare bô gêgêre a aɲ bay uwôli bi ré ɗiji ciré hebé kibi bargay kari ka yi serem serem hen. Kiriɲ bay hen na, ɓiɲé kêm ka hebiri menba, berare. ");
INSERT INTO kqp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Si Parisiɲêɲê naɲ *bay derê tô tôô to Emen ka pôni henaji Jérusalêm sa daɲji ligi Jésu a. ");
INSERT INTO kqp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bay gel wo bay tô Jésu ka pôni ômji emê naɲ kôbriji wo *kagemi wôsa bay pul ré. ");
INSERT INTO kqp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisiɲêɲê naɲ tô Jubɲê ka ba hen kêm a men na, bay ôm emê ba pelé kôbriji derê ré ré, wôsa bay bi kwôlê sa hara wo balêrji a. ");
INSERT INTO kqp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hena bay ré hena bô gêgêr a hera ba, bay pul kôbriji dema bay ré ôm are. Bay bi kwôlê sa hara wo ɗaŋgi a mega kwoɲ pelé karbé toɲ yê are men, pelé téwre men, naɲ pelé karbé to bay iyege hen a men. ");
INSERT INTO kqp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Menba, Parisiɲêɲê naɲ bay derê tô tôô to Emen eŋgeriji Jésu iyôŋ ba: «Wô mi a bay tôm ré liji hara wo môɲêrna né men, biji kwôlê sa hara wo balêrji a ré men ba? Bay ôm mapa naɲ kôbriji wo kagemi.» ");
INSERT INTO kqp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Menba, Jésu uwôlji sara iyôŋ ba: «*Ôbi kibi Emen *Esay na kôl ca tumô gengiɲ sarŋge kenbay kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, kôl iyôŋ ba: ‹Gawrê bay ka hen na, bay ay keben na naɲ kibriji na mera ɗiba bôrji ba kelaŋ naɲ en men. ");
INSERT INTO kqp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bay teben hen na ɗéɲ iyôŋ men, aŋga bay geliɲ ɓiɲé hen kôba na tôô to gawrê a men.› ");
INSERT INTO kqp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ken ɗi tôô to Emen aɲ ken gem na hara wo gawrê hen ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jésu hô kôl iyôŋ ba: «Ken li dô gaɲ sa jibé tôô to Emen ɗéɲ wô gemiɲ hara woŋge. ");
INSERT INTO kqp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wôsa *Moyis na kôl iyôŋ ba: ‹Biɲ ibam naɲ yom kwôlê men, kwôni wo kôliɲ ibari naɲ yori kwôlo habiɲ ba bi bay diri.› ");
INSERT INTO kqp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Niɲba, kenbay ken kôl iyôŋ ba: ‹Hena kwôni ré kôliɲ ibari naɲ yori iyôŋ ba: «Aŋga ré ené béŋge hen na, na bay a ené biɲ Emen hen», ");
INSERT INTO kqp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","iyôŋ na, ôbi ôriɲ doy biɲ ibari naɲ yori ani ré niɲ.› ");
INSERT INTO kqp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na hen iyôŋ a, kené mêne kwôlo Emen wo kôl hen naɲ hara wo balêrŋge wo na ɗi cêgeriji a béŋge hen. Aɲ ken li aŋga ɗaŋgi ka geliɲ hen iyôŋ a sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jésu hô uwôga kwônê ɓiɲé sôŋ aɲ kôlji iyôŋ ba: «Toyéŋge dô aɲ ken hôn kwôlê wo na kelêŋge hen. ");
INSERT INTO kqp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aŋga hena nô ô bô gawra na, na aŋga li bi bôri *kagemiɲ hen né, niɲba, aŋga soo bô gawra a lê a ôbi ré kagemiɲ hen ɗi.  ");
INSERT INTO kqp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hena kwôni wo ré naɲ mari wô toyiɲ kwôlê bi wo en kôl hen na, bi toy» ");
INSERT INTO kqp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kiriɲa Jésu ô bô ira menba, kiriɲa kwônê ɓiɲé naɲji niɲ menba, bay tôri eŋgeri gengiɲ sa bô kwôlê wo ôbi ré kôl hen. ");
INSERT INTO kqp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jésu kôlji iyôŋ ba: «Kenbay kôba ken hôn bô kwôlê bi wo hen né men ba? Ken hôn wo aŋga hena nô ô si kibi gawra na, na aŋga liri ôbi *kagem né. ");
INSERT INTO kqp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wôsa aŋgaɲ emê na, ô na sa têmrê gawra ré niɲba, ô na bôri a. Menba, hô so aɲ.» Jésu kôl hen iyôŋ wô wo aŋgaɲ emê kêm ré dô emê. ");
INSERT INTO kqp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jésu kôl iyôŋ ba: «Aŋga soo bô gawra na, na aŋga liri ôbi kagem. ");
INSERT INTO kqp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wôsa na aŋga hena bô gawra a biri ermé kwôlê wo habiɲ mega yiɲare toɲ iyôŋ tôŋ hen men, gemsare men, deré temare a men. ");
INSERT INTO kqp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Na ôbi á, bay ré yi bay yiɲ naɲ yébé ɓiɲé men, bay ré yiɲ bay geyére gursu men, bay bô hendé men, bay lamêre ɓiɲé men, bay lê aŋga bôrji gey men, bay tu bôriyare men, bay kelê kwôlê wo habiɲ gengiɲ sa megêrji men, bay lêre geɲ men, bay kelêre kwôlê iyôŋ a tôŋ ba henê tô geréri a men hen. ");
INSERT INTO kqp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aŋgaɲ lê bay ka hen na, hena na bô gawra aɲa gawra ré li aɲa ôbi ré kagemiɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jésu ô aɲ kiriɲ bay ka hen aɲ ô kiriɲ ka sa iyé Tir yiɲ ya hen. Jésu si bô iyére to ôbi gey merê ya hen. Ôbi gey wo kwôni ré hôn né, niɲba, ôbi a merê kiriɲ kani a ba wo ɓiɲé ré hôn né ré. ");
INSERT INTO kqp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kiriɲ bay ka hen na, iyore to pôni to tunu to habiɲ yi bô môɲne a toy kwôli Jésu menba, era sa cubu gubare tumôri a. ");
INSERT INTO kqp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iyore hende to hen na, na môni sa iyére hende to Jésu môriɲ ya hen, hende iyêl kibi grêk. Hende uwôliɲ Jésu ré dage tunu to habiɲ hende to hen bô môɲne a aɲ. ");
INSERT INTO kqp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jésu kôle iyôŋ ba: «Ɗi kamrê bi ôm are dem wôsa dé wo kwôni ré ay kwô wo kamrê uwôliɲ garê ré.» ");
INSERT INTO kqp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Menba, iyore hende to hen uwôli sara iyôŋ ba: «Na tiri, Kelma, niɲba, kam garê ôm habelê kwô wo heriɲ tô kibi kamrê ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Menba, Jésu kôle iyôŋ ba: «Sa kibi kwôlê woré wo me kôlen hen na, ô iɲ harê niɲ, wôsa tunu to habiɲ hende to hen dôriɲ bô môɲnê niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kiriɲa hende ô iɲ, menba, hende uwoɲ môɲne yi sa kalaŋ a aɲ hende hôn wo tunu to habiɲ na ré dôriɲ bô môɲne a niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jésu hena sa iyé Tir a aɲ so si Sidôn si kwa cér wo Galilé aɲ sê sa iyére to tôre môj hen kara. ");
INSERT INTO kqp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bay eraɲ naɲ gawra woɲ meŋ men, iyêlê kwôlê kôba gôli a men, aɲ bay uwôliɲ Jésu ré uwôl kôbri a sari a aɲ bi ôbi ré berare. ");
INSERT INTO kqp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jésu ɓiri ôriɲ wolé kelaŋ naɲ kwônê ɓiɲé. Jésu tôbe kôbri bô mari a men, tebe kalê aɲ hebiɲ kôli gawra bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Menba, Jésu ay tiri ta aɲ bô kiriɲ si derômaraŋ aɲ dô bul wo dami aɲ kôl iyôŋ ba: «Epata» iyayriri na: «Maa bôliɲge.» ");
INSERT INTO kqp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kiriɲ bay ka hen na, bô maa gawra na bôliɲ men kôli kôba beseriɲ aɲ ôbi iyêl kwôlê dô yarara. ");
INSERT INTO kqp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jésu kôlji bay ré kôliɲ kwôni ré pa pa. Niɲba, kiriɲa ôbi kôlji bay ré kôliɲ kwôni ré na, kiriɲ bay ka hen dema bay ré kôliɲ ɓiɲé kwôli aŋga Jésu li hen tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tini ɓiɲé ge kay sa aŋga Jésu li hen aɲ bay kôl iyôŋ ba: «Aŋga kêm ka ôbi li hen na, ôbi li dô, ôbi li bi meŋɲê toy kwôlê men, ɓiɲé ka iyêl kwôlê dô ré, kôba iyêl men.» ");
INSERT INTO kqp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kiriɲ bay ka hen na, kiriɲa kwônê ɓiɲé hô daɲji a sôŋ menba, kiriɲ bay ka hen na bay ôriɲ naɲ aŋgaɲ emê kani ré kwôy menba, Jésu uwôge bay tôri aɲ kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Tu ɓiɲé ka na lên ɲa damaŋ wôsa na sa subu niɲ wo bay li naɲ en na, aɲ aŋga bay ré ôm ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hena ené kôlji bay ré ô iɲ naɲ kurôŋ bôrji na, ka pôni a heriɲ tô geré wôsa ka pôni henaji kelaŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bay tô Jésu kôli iyôŋ ba: «Na lê na iyeŋ a nana biɲ ɓiɲé emê uyê bôrji kiriɲa na ɗibiɲ derô gwôlê na ba?» ");
INSERT INTO kqp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jésu eŋgeriji iyôŋ ba: «Ken ôriɲ naɲ mapa iyeŋ ba?» Bay uwôli sara iyôŋ ba: «Nini ôriɲ naɲ mapa jurgem.» ");
INSERT INTO kqp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Menba, ôbi kôliɲ kwônê ɓiɲé ré mô tôŋ terare a. Ôbi pô mapa wo jurgem hen aɲ kiriɲa ôbi liɲ Emen dosé menba, ôbi ɓiilê tôŋ aɲ biɲ bay tôri bi bay ré cé. Menba, bay céɲ kwônê ɓiɲé bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bay tô Jésu ôrji naɲ kam kuyê dê. Jésu liɲ Emen dosé wô kuyê bay ka hen aɲ biɲ bay tôri bi bay ré cé a men. ");
INSERT INTO kqp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kwônê ɓiɲé bay ka hen na, ôm mapa uyirê dô aɲ bay pô tôri wo ba gwaɲê jurgem. ");
INSERT INTO kqp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kwônê ɓiɲé bay ka hen na nêm ɓiɲé dubu pôrbu. Menba, Jésu ɗiji ôrji haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kiriɲ bay ka hen menba, Jésu ɗay bô bato naɲ bay tôri aɲ ôrji emê wo Dalmanuta a. ");
INSERT INTO kqp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Parisiɲêɲê soji aɲ nariɲji kwôlê naɲ Jésu wô séliɲ bôri na, bay kôli ré li aŋgaɲ gelé ka ré gel wo néé wori ré hena na derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jésu dô bul wo dami aɲ kôl iyôŋ ba: «Wô mi a kenbay ɓiɲé na kemnêŋ hen kené eŋgere aŋgaɲ giɲê ba? Na tu kwôlê a ené ena kelêŋge hen, aŋgaɲ gelé kani pôn iyôŋ kôba a liɲ béŋge ka gelé haw hen né.» ");
INSERT INTO kqp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Menba, ôbi erêɲ kibi Parisiɲêɲê aɲ hô ɗay bô bato ô si cêgi cér iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bay tôri gerbaɲ pera mapa aɲ mapa na pôn nêŋ kôbriji a bô bato. ");
INSERT INTO kqp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jésu yêge marji kôl iyôŋ ba: «Berêŋge dô wôsa wubere to Parisiɲêɲê naɲ to *Hérôd.» ");
INSERT INTO kqp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bay tô Jésu nariɲ kwôlê perêrji a kôl iyôŋ ba: «Na wô wo nana ôriɲ naɲ mapa ré hen aɲa ôbi ré kôl hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jésu toy kwôlê wo bay kôl aɲ ôbi eŋgeriji iyôŋ ba: «Wô mi a kené erem sa mapa wo ken ôriɲ né hen ba? Kenbay kôba ken hôn né tô sôŋ ba? Bô deŋgelé woŋge ba ya ba? ");
INSERT INTO kqp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ken naɲ turŋge niɲba, ken gel kiriɲ né, ken naɲ marŋge niɲba, ken toy kwôlê wôni ré ba? Bôrŋge ôliɲ sa sa to ");
INSERT INTO kqp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kiriɲa na en ɓiilê mapa wo na bay aɲ biɲ ɓiɲé ka dubu hen né ba? Tôri wo ba ba, na pôriɲ gway iyeŋ ba?» Bay tôri kôli iyôŋ ba ré na gway môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Men, kiriɲa na en ɓiilê mapa wo jurgem biɲ ɓiɲé ka dubu pôrbu hen né ba? Hen ba, na ken pô tôri wo ba na gway iyeŋ ba?» Bay kôli sara iyôŋ ba ré gway jurgem. ");
INSERT INTO kqp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Menba, Jésu hô kôlji iyôŋ ba: «Ken hôn né tô ba?» ");
INSERT INTO kqp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jésu naɲ bay tôri ôrji Bêtsayda. Bay eraɲ naɲ gawra wo tiri tiɲ biɲ Jésu. Bay uwôli bi ôbi ré uwôl kôbri a sari a. ");
INSERT INTO kqp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jésu ɓu kôbi ôbi tu tiɲ bi wo hen aɲ ôriɲ naɲ ɗi kelaŋ naɲ iyére. Menba, Jésu liri kalê tiri a aɲ ôbi uwôl kôbri a sari a menba, ôbi eŋgeri iyôŋ ba: «Ju gel ani ba?» ");
INSERT INTO kqp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ôbi tu tiɲ bi wo hen bôl tiri aɲ kôl iyôŋ ba: «En gel ɓiɲé niɲba, bay yi mega gurôɲê ka ô ta iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Menba, Jésu hô ɗi kôbri a tiri a menba, kiriɲa ôbi tu tiɲ bi wo hen bô kiriɲ ɗééɲ menba, tiri bôliɲ ôbi gel are kêm dô. ");
INSERT INTO kqp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Menba, Jésu kôli ré ô iɲ niɲba, ré hô si bô iyére ré. ");
INSERT INTO kqp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jésu ô naɲ bay tôri ôrji sa kam iyére to ɗa naɲ bô emê wo Sésaré Pilip a menba, tô geré na, ôbi eŋgeriji iyôŋ ba: «Ɓiɲé kôl ené na i ba?» ");
INSERT INTO kqp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Menba, bay kôli iyôŋ ba: «Ka pôni kôl jeré na Ja ôbi lê batêm, ka pôni kôl jeré na *Eli, ka ɗaŋgi kôl jeré na *ôbi kibi Emen wo pôni.» ");
INSERT INTO kqp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Niɲba, Jésu eŋgeriji iyôŋ ba: «A kenbay ken kôl ené na i ba?» Menba, Piyêr kôli iyôŋ ba: «Ju na *Krist, kwo Emen dôri hen.» ");
INSERT INTO kqp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Menba, Jésu kôlji naɲ tôri to maɲ bi bay ré kôliɲ kwôni ɗiré na Krist, kwo Emen dôri hen, ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jésu ay tô gelji are kôl iyôŋ ba: «Dé wo nôbi *Kema Gawra ené geliɲ gusiɲ damaŋ aɲ, surɲê men, damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen, bay a kaɲen men, bay a deren a men, aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jésu kôl kwôlê bi wo hen dad a ta. Menba, Piyêr ɓiri ôriɲ wolé aɲ nayri. ");
INSERT INTO kqp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Menba, Jésu hô bul bô bay tôri ka ba hen aɲ kôliɲ Piyêr iyôŋ ba: «Ô kelaŋ naɲ en, Sidan, wôsa ermé wom némiɲ naɲ kwo Emen ré. Ermé wom na kwo gawrê.» ");
INSERT INTO kqp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Menba, Jésu uwôge kwônê ɓiɲé naɲ bay tôri aɲ kôlji iyôŋ ba: «Hena kwôni ré gey yé ôbi tôn ba, bi uwôl yiri aɲ men, bi ay gurô tagelê wori woɲ temare sari a aɲ era tôn a. ");
INSERT INTO kqp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwôni wo gey gemé yiri ba a mênêri, niɲba, kwôni wo uwôl yiri aɲ wô san men, wô sa Kwôlo Dôri a men na, a gôliɲ naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hena kwôni ré uwoɲ aŋga sa terare a na kêm aɲa ré mêne merê tu geɲ wori ba, derêri yôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Na mi a kwôni ré bé aɲa ré keraŋgiɲ merê tu geɲ wori bi wo hen ba? ");
INSERT INTO kqp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na wô bi wo hen a hena kwôni ré dii tayre san a men, sa kwôlê wuɲê men, perê ɓiɲé sa terare a na ka yi mega bay wogé yébé megêrji hen men, bay têriɲ a men hen na, nôbi Kema Gawra na déé tayre sari a kiriɲa na buloɲ hera naɲ *manê ka derômaraŋ a ka yi naɲ jeŋgêrji hen naɲ hini emê wo Iban.» ");
INSERT INTO kqp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jésu hô kôlji sôŋ iyôŋ ba: «Na tu kwôlê a ené ena kelêŋge hen, perê ɓiɲé ka na na, ka pôni a gelé damɲay *emê iyére to Emen naɲ tirji dema ré maji tô.» ");
INSERT INTO kqp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wulê jii cêgê menba, Jésu tô si Piyêr naɲ *Jak naɲ Ja aɲ ôriɲ naɲ ci sêd wolé naɲ ɓiɲé ta sa keram wo yêŋgi a. Kiriɲ bay ka hen na, tu Jésu biliɲ yi gay tirji a men, ");
INSERT INTO kqp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bargay kari biliɲ bôri terij aɲ jeraɲnê wo ôbi pelé bargay wôni wo a pelé selé hen iyôŋ na naɲ. ");
INSERT INTO kqp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Si *Eli naɲ Moyis soji aɲ iyêlji naɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Menba, Piyêr kôliɲ Jésu iyôŋ ba: «*Rabi, dô wo na merêŋge na, niɲa lê iyéy gergé subu pôn tom men, pôn to Eli men, pôn to *Moyis a men.» ");
INSERT INTO kqp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyêr hôn kwôlê wo ɗa kelê ré wôsa harê liji. ");
INSERT INTO kqp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kiriɲ bay ka hen na, kiriɲ ka geri so sa têlji ta, menba, tôô gawra ôm bô a kôl iyôŋ ba: «Kwo ɗebe hen na, na Keman, en piri damaŋ, toyéŋge kwôlê kibri a.» ");
INSERT INTO kqp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Menba, kiriɲ bay ka hen na, bay tô Jésu bô kwarji niɲba, gel kwôni ré, niɲba, Jésu a ɗebé pini naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kiriɲa bay herbo tôŋ sa keram a menba, Jésu kôlji bay ré kôliɲ kwôni kwôli aŋga bay gel hen né kwôy wo ɗôbi *Kema Gawra ɗiré jiɲ siɲ kamɲê. ");
INSERT INTO kqp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Si Piyêr naɲ Jak naɲ Ja gem kwôlê bi wo hen bôrji a menba, bay nariɲ kwôlê perêrji a kôl iyôŋ ba: «Kwôlê wo Jésu kôl wô jê sé perê ɓiɲé ka ma a hen na, bôri na iyeŋ pôn ba?» ");
INSERT INTO kqp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Menba, bay eŋgeriri iyôŋ ba: «Wô mi a *bay derê tô tôô to Emen ré kôl iyôŋ ba ré na Eli a ré hera tumô *Krist, kwo Emen dôri hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Menba, Jésu uwôlji sara iyôŋ ba: «Na Eli a hera tumô wô ɲanê are kêm naɲ kiniji kiniji ba? A hen iyôŋ ba, wô mi a ré liɲ bô magtubu to Emen a wo nôbi Kema Gawra ené geliɲ gusiɲ men, bay ré tôrɲen a men ba? ");
INSERT INTO kqp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Niɲba, en kelêŋge, Eli na sa aɲ bay na liri aŋga bôrji gey mega wo bay na li bô magtubu to Emen a gengiɲ sari.» ");
INSERT INTO kqp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kiriɲa Jésu naɲ Piyêr naɲ Jak naɲ Ja heraji ɗa ligi tô bay tôri ka ba hen menba, bay gel kwarji a kwônê ɓiɲé naɲ bay derê tô tôô to Emen wo nariɲji kwôlê. ");
INSERT INTO kqp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kiriɲa kwônê ɓiɲé gelji Jésu menba, tiniji ge kay aɲ bay guro wô liri dosé. ");
INSERT INTO kqp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jésu eŋgeriji iyôŋ ba: «Na kwôli mi a kené nariɲ na ba?» ");
INSERT INTO kqp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Menba, gawra wo pôni perê kwônê ɓiɲé uwôli sara iyôŋ ba: «Rabi, en eraɲ naɲ keman bem wôsa tunu to habiɲ jôri iyêlê kwôlê. ");
INSERT INTO kqp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Men, kiriɲ ka yôŋ yôŋ ka ôbi ɗibiɲ ya na, tunu to habiɲ hende to hen dôri ku men, wôbre si kibri a men, ôbi gederé kaɲni men, yiri kêm seŋgal a men. En uwôliɲ bay tôm ré dage tunu hende to hen, niɲba, bay nêm né.» ");
INSERT INTO kqp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Menba, Jésu uwôli sara iyôŋ ba: «Kenbay ka ayê bôô woŋge naɲ hen na, na merê na wô lê naɲ ken yôd ba? Men, na têê iyeŋ a ené ulê bôn jalê sarŋge a ba? Eraɲge naɲ kema bi ben na.» ");
INSERT INTO kqp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bay eraɲ naɲ kema bi wo hen biri. Menba, kiriɲa tunu to habiɲ hende to hen gel Jésu menba, ay kema ku aɲ ôbi gerŋge men, wôbre si kibri a a men. ");
INSERT INTO kqp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jésu eŋgere iba kema iyôŋ ba: «Sa iyeŋ a are bay ka hen né liri iyôŋ ba?» Menba, iba kema kôli ré na ca naɲ kamɲêri yeŋ. ");
INSERT INTO kqp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","«Têê kwône tunu to habiɲ hende to hen dôri uwôl tare a, réba bô kam a biɲ teré diri. Niɲba, hena jeré nêm lê ani ba, ju li naɲ ni men, ju bô tu ɲa toni men.» ");
INSERT INTO kqp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jésu kôli iyôŋ ba: «Wô mi a jeré kôl: ‹Hena jeré nêm ba?› Ani a gôliɲ kwôni wo bi bôri sa Emen a ré.» ");
INSERT INTO kqp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kiriɲ bay ka hen menba, iba kema na kôl naɲ tôri to dami kôl iyôŋ ba: «En bi bôn sa Emen a, li naɲ en aɲ bi ayê bôô wuɲê ré ô tumô men.» ");
INSERT INTO kqp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jésu bô wo kwônê ɓiɲé daɲ menba, ôbi ône tunu to habiɲ hende to hen aɲ kôle iyôŋ ba: «Tunu to jôriɲ ɓiɲé iyêlê kwôlê men to biɲ ɓiɲé yi meŋɲê a men hen, en ay tôô béré séɲ bô kema wo hen, aɲ mu hô hô ré niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Menba, tunu hende to hen séɲ aɲ li kema kaarê kula men, yêsirê naɲ nééri a men. Aɲ ôbi yi mega ré ma iyôŋ, aɲ ɓiɲé ka pôni kôba kôl ôbi ré ma. ");
INSERT INTO kqp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Menba, Jésu ɓu kôbi kema aɲ jôgeri hena ta aɲ ôbi ɗubu ta. ");
INSERT INTO kqp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kiriɲa Jésu ô iɲ niɲ menba, bay tôri eŋgeriri pini iyôŋ ba: «Wô mi a, na niné nêm dagê tunu to habiɲ hende to hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Menba, ôbi uwôlji sara iyôŋ ba: «Tunu to habiɲ to hen iyôŋ na, séére nô na naɲ uwôlê Emen.» ");
INSERT INTO kqp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jésu naɲ bay tôri ôrji aɲ kiriɲ bay ka hen aɲ siji si bô emê wo Galilé a aɲ bay ɗibiji tôŋ né wôsa Jésu gey bi kwôni ré hôn né. ");
INSERT INTO kqp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wôsa ôbi hal bay tôri kôl iyôŋ ba: «Bay a ɓeren nôbi Kema Gawra biɲ ɓiɲé aɲ bay a deren aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Niɲba, bay hôn bô kwôlo ôbi kôl hen né. Men né bay hare eŋgeréri men. ");
INSERT INTO kqp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jésu naɲ bay tôri saji biɲ Kapêrnayôm, menba, kiriɲa bay sa biɲ iyére niɲ menba, Jésu eŋgereji iyôŋ ba: «Kené naraɲ na kwôli mi kiriɲa nana eraɲ tô geré hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Menba, bay tôri wômji sidiŋ wôsa tô geré bay nariɲ kwôlê sa i a ré na kwo dami perêrji a ba. ");
INSERT INTO kqp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Menba, Jésu mô tôŋ, aɲ uwôga bay tôri ka môj kibi wôô hen aɲ kôlji iyôŋ ba: «Hena kwôni ré gey yé kelma ba, bi yi ôbi cêgi megêri kêm men, bi yi ôbi lê jé biji a men.» ");
INSERT INTO kqp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Menba, Jésu ay kema wo dê sa ɗiri derôrji a aɲ ôbi ayri kaberêri a aɲ kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«I, i wo ɓu kema wo dê mega kwo na yiri a naɲ henen na, ôbi ɓeren na nôbi yiri a hen. Men, kwôni wo ɓeren a yiri a na, ɓeren na nôbi mera yiri a hen ré niɲba, na Iban wo joon hen a, ôbi ré ɓiri a yiri a hen men.» ");
INSERT INTO kqp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ja kôli iyôŋ ba: «Rabi, nini gel gawra wo pôni dage tunu to habiɲ naɲ henem menba, nini jôri sara wôsa ôbi era tôrna ré.» ");
INSERT INTO kqp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Menba, Jésu kôl iyôŋ ba: «Jôreŋgiri ré, wôsa kwôni li are naɲ henen na, a kelê kwôlen habiɲê ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na ôbi á, kwôni wo na ôbi barena ré ba, na kwona. ");
INSERT INTO kqp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Hena kwôni wo ré béŋge kam kaɲ yê bô môni gwore a wô wo kené ay hini *Krist, kwo Emen dôri hen na, na tu kwôlê a ené ena kelêŋge hen, ôbi a ba uɲé sa kôbri ré.» ");
INSERT INTO kqp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Hena kwôni ré li aɲa kwo iya tô ayê bôô wori a hen ré kuriɲ na, hena bay ré hari keram wo dami a tôri a aɲ bay ré uwôli a bô cér a kôba na aŋga dê gôliɲ gusiɲ to Emen a gili hen. ");
INSERT INTO kqp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hena ré na kôm a lê aɲa jeré li têriɲ na, dô wo ju jôri aɲ. Dô wo ju mô tu geɲ naɲ kunum naɲ kôm pôn dô ɗê, erê bô géhên to na tare to eŋge bariɲ né hen naɲ kôm wôô.  ");
INSERT INTO kqp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na kiriɲ ka wôŋne kôba ma ré men, tare kôba bariɲ né men. ");
INSERT INTO kqp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hena têm né lêm wo ju li têriɲ na, dô wo ju jôre aɲ. Dô wo ju meray aɲ môriɲ tu geɲ naɲ kunum dô ɗê wo ju ôriɲ naɲ têm wôô aɲ ju ôriɲ bô géhên a.  ");
INSERT INTO kqp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na kiriɲ ka wôŋne kôba ma ré men, tare kôba bariɲ né men. ");
INSERT INTO kqp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A hena ré na tum a lê aɲa jeré li têriɲ na, dôre aɲ, dô wo ju si bô *emê iyére to Emen a naɲ tum pôn dô ɗê wo jeré ô bô géhên a naɲ tum wôô. ");
INSERT INTO kqp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na kiriɲ ka wôŋne kôba ma ré men tare kôba bariɲ né men. ");
INSERT INTO kqp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wôsa kwôni wo yôŋ yôŋ kôba tare a biɲ sari a mega wo bay biɲ ɗôre sa kiliɲ a iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Ɗôre na aŋga dôri, niɲba, hena hende ré geraŋ né ba, bay a lere iyeŋ a ré herê geraŋgê hôriɲ ba? Yéŋge mega ɗôre iyôŋ aɲ ken mô naɲ bô jalê perêrŋge a.» ");
INSERT INTO kqp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jésu ay geré ô bô emê wo Judé a cêgi cér wo Jurdê a. Ɓiɲé kwône hô daɲji ligiri a. Ôbi gelji are gaŋ gaŋ, menba, tê pôn a sôŋ ôbi gelji are. ");
INSERT INTO kqp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Parisiɲêɲê ka pôni ay tô iyêlê naɲ Jésu wô séliɲ bôri, bay eŋgeriri iyôŋ ba: «Tôô tona kôl wo iba ré dagê tamni hari ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Menba, Jésu uwôlji sara iyôŋ ba: «Na kwôli mi a *Moyis na ré kelêŋge kené li ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bay kôli iyôŋ ba: «Moyis na kelêni iyôŋ ba: ‹Kwôni wo ré dage tamni ba, ré buru magtubu toɲ bê tôre kôbre a.› » ");
INSERT INTO kqp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Menba, Jésu kôlji iyôŋ ba: «Na wô bô deŋgelé woŋge aɲa Moyis na ré ayiɲ tôô hende to hen béŋge hen. ");
INSERT INTO kqp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Niɲba, kiriɲa Emen na ay tô ɗé tô terare na, ôbi ɗi gawrê iba naɲ iyore. ");
INSERT INTO kqp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na wô bi wo hen aɲa iba ré ɗé ibari naɲ yori aɲ, aɲ ɗé yiri naɲ tamni ");
INSERT INTO kqp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aɲ bay wôô hen a yiji na gawra wo pôn. Mega hen iyôŋ na, bay na ɓiɲé wôô ré niɲ, niɲba, bay yi mega gawra pôn. ");
INSERT INTO kqp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na tôri bi wo hen aɲa kwôni ré nêmê bisiré aŋga Emen day liɲ kurôŋgi yi wo pôn hen né.» ");
INSERT INTO kqp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kiriɲa bay ré baɲ iɲ tô na, bay tô Jésu hô eŋgereri gengiɲ sa kwôlê woɲ dagê iyore wo ôbi ré kôl hen. ");
INSERT INTO kqp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Menba, Jésu kôlji iyôŋ ba: «Kwôni wo dage tamni aɲ eŋgiɲ to ɗaŋgi na, ôbi li têriɲ naɲ tamni to tumô hen. ");
INSERT INTO kqp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A hena iyore ré dage kurôre aɲ eŋgiɲ iba wo ɗaŋgi na, hende li têriɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɓiɲé eraɲ naɲ kamrê ka dê biɲ Jésu bi ôbi ré uwôl kôbri sarji a, niɲba, bay tôri nayji. ");
INSERT INTO kqp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jésu gel wo bay tôri li hen iyôŋ menba, bôri tari, aɲ ôbi kôlji iyôŋ ba: «Ɗéŋge kamrê bi era legen a ɗiba ken jôreŋgeji ré. Wôsa *emê iyére to Emen yi gengiɲ sa ɓiɲé ka yi mega kamrê ka dê dê bay ka hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na tu kwôlê a ené kelêŋge hen, kwôni wo gey bi Emen né yi kelma wori mega kema wo dê liɲ hen iyôŋ ré na, ôbi a ulê têri bô emê iyére tori a ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Menba, Jésu ɓu kamrê a kabrêri a aɲ tô kibri a sarji a aɲ uwôl kôbri a sarji a a men. ");
INSERT INTO kqp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kiriɲa Jésu ô tô geré na, gawra wo pôni guro aɲ sa cubu gubari tumôri a aɲ eŋgereri iyôŋ ba: «*Rabi wo dôri, na mi a ené lê aɲa ené môriɲ tu geɲ naɲ kunun ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Menba, Jésu kôli iyôŋ ba: «Wô mi a jeré uwôgen kwo dôri ba? Kwôni wo dôri naɲ, Emen pôn nêŋ a na kwo dôri. ");
INSERT INTO kqp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ju hôn tôô to Emen na ay kôl iyôŋ ba: ‹Duu temare ré men, yiɲ yiɲare toɲ têriɲ ré men, gômse ré men, kôl kwôlê woɲ benare ɗi sa ɓiɲé ré men, liɲ kwôni aŋga habiɲ né men, biɲ ibam naɲ yom kwôlê a men.› » ");
INSERT INTO kqp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ôbi hô kôliɲ Jésu iyôŋ ba: «Rabi, tôô hende to hen en li kêm naɲ kamɲên yeŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jésu piri aɲ bôri aɲ, kôli iyôŋ ba: «Aŋga pôni bam ya. Ô perê ari uɲé kam kêm ju keléɲ aɲ larirji na, ju céɲ bay nimré. Aɲ ari uɲé ka kwôni yi derômaraŋ a gemem ligi Emen a ya. Menba, jôbi ju era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Niɲba, kiriɲa ôbi toy kwôlê bi wo hen iyôŋ na, tiri mêne aɲ ôbi kuriɲ ô ta naɲ tu ɲa wôsa aŋgaɲ uɲé kari mê gaɲ. ");
INSERT INTO kqp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jésu bô kwari aɲ kôliɲ bay tôri iyôŋ ba: «Bi ɓiɲé kaɲ bay uɲé ré si bô emê iyére to Emen a na, iyêre gaɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kwôli kelê Jésu liɲ bay tôri harê. Ôbi hô kôlji iyôŋ ba: «Milɲén, sé bô emê iyére to Emen a na, iyêre gaɲ. ");
INSERT INTO kqp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jambal a sé lew si tu iyom libra gôliɲ ôbi uɲé ré si bô emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bay tô Jésu hen deŋgôri tiji damaŋ a aɲ bay kôl perêrji a iyôŋ ba: «Niɲba, i a uɲé gelê ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jésu bôrji aɲ kôl iyôŋ ba: «Uɲé gelê na, gawra nêm né, niɲba, Emen nêm. Wôsa Emen nêm lê are kêm.» ");
INSERT INTO kqp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyêr kôli iyôŋ ba: «Gel, nini ɗéɲ are kêm aɲ nini era tôm a.» ");
INSERT INTO kqp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Menba, Jésu uwôli sara iyôŋ ba: «Na tiri, en kelêŋge, hena kwôni ré ɗéɲ iyére tori, yênêri, yori, ibari, kamni naɲ yagê wori wô san men, wô sa Kwôlo Dôri a men na, ");
INSERT INTO kqp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ôbi a uɲé haw hen kiriɲ bay ka hen têê arew iyére men, yênê men, yori men, kamrê naɲ yagê a men, aɲ are bay ka hen kêm a era naɲ bô emê, aɲ tôre to cêgi na, ôbi a merê tu geɲ naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɓiɲé kwône ka nà ná ka tumô hen na, haw hen na bay a yé bay cêgê men, bay cêgê ka haw hen a herê yé bay tumô men.» ");
INSERT INTO kqp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jésu naɲ bay tôri ôrji geré wô erê Jérusalêm, menba, Jésu ô tumôrji a. Bay tôri deŋgôrji tiji men, tô ɓiɲé ka ô tôrji a hen na, harê liji men. Têê pôn a sôŋ Jésu uwôge bay tôri ka môj kibi wôô hen ligiri a aɲ ay tô kelêji kwôli aŋga ré sa sari a hen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Ken toy, nana erêŋge na Jérusalêm a hen, aɲ bay a ɓeren nôbi *Kema Gawra biɲ damné kaɲ bay bê kwôbe men, bay derê tô tôô to Emen a men, aɲ bay a ɗén kwôlê woɲ temare san a men, bay a nôgen biɲ ɓiɲé ka na Jubɲê ré hen a men. ");
INSERT INTO kqp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aɲ bay a ayren men, bay a teben kalê san a men, bay a sên men, aɲ bay a deren aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kam Jébédé ka wôô Jak naɲ Ja eraji ligi Jésu aɲ kôli iyôŋ ba: «Rabi, nini gey bi jeré li aŋga nini eŋgerem hen béni.» ");
INSERT INTO kqp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Menba, Jésu kôlji iyôŋ ba: «Na mi a kené gey bi ené li béŋge ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bay uwôli sara iyôŋ ba: «Béni bi niné sa ô merê kwo pôn sa kôm woɲ gusurô a men, kwo pôn sa kôm woɲ maa a men bô emê iyére tom a.» ");
INSERT INTO kqp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Menba, Jésu uwôlji sara iyôŋ ba: «Aŋga ken eŋgere hen ba, ken hôn dô bi ba? Ka nêmê yê kam kaɲ bô emê ka na yê hen ba? Men batêm to bay a lên hen na, ka nêmê lê ba?» ");
INSERT INTO kqp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bay hô kôliɲ Jésu iyôŋ ba: «Niɲa nêmê yê seŋge.» Menba, ôbi uwôlji sara iyôŋ ba: «Ka yê kam kaɲ bô emê ka na yê hen men, batêm to bay ka lên hen kôba ka lê a men haŋge, ");
INSERT INTO kqp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","niɲba, kwoɲ merê sa kôbi woɲ gusurô a men, kwoɲ maa a men na, na nôbi a gengé ré, niɲba, na Iban a gengé kiriɲ wô ɓiɲé kari ka ôbi na ɓu sa têrji niɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Menba, bay tô Jésu ka ba môj hen, kiriɲa toy hen iyôŋ na, bôrji tarji sa si Jak naɲ Ja. ");
INSERT INTO kqp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jésu uwôgeji kêm aɲ kôlji iyôŋ ba: «Ken toy, kilmé ka sa terare a na ôm sa ɓiɲé kaji men, ɓiɲé ka damné kôba gôliɲ sarji a men. ");
INSERT INTO kqp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Niɲba, kenbay ba bi yi hen iyôŋ perêrŋge a ré. Perêrŋge a hen aɲa kwôni ré gey yé kwo dami ba, bi yi mana woŋge men, ");
INSERT INTO kqp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","kwo gey yé kwo tumô ba, bi yi lema woŋge men. ");
INSERT INTO kqp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na hen iyôŋ a, nôbi Kema Gawra ené era sa terare a nà na wo ɓiɲé ré yi manê kaɲê ré, niɲba, na wô yé mana woji men, ayê yen biɲ temare têbiɲ sa ɓiɲé kwône a men.» ");
INSERT INTO kqp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jésu naɲ bay tôri men naɲ kwônê ɓiɲé a men saji sa iyé Jériko. Kiriɲa bay ca sé aɲ Jériko na, ôbi tu tiɲ kwo pôni hini ôm Bartimé kema Timé mô bêŋgê geré wô uwôlê are. ");
INSERT INTO kqp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ôbi toy wo ré na Jésu wo Najarêt menba, ôbi uwôgiri kaŋ a ta: «Jésu, *kuŋga kelma Dabid, bô tu ɲa tiɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Menba, ɓiɲé kwône nayri bi ôbi ré wôm tôŋ, niɲba, ôbi hô ôm naɲ nééri a: «Kuŋga kelma Dabid, bô tu ɲa tiɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Menba, Jésu ɗebu tôŋ aɲ kôl iyôŋ ba: «Uwôgaŋgiri na.» Bay uwôga ôbi tu tiɲ bi wo hen aɲ kôli iyôŋ ba: «Uwôl bôm pô, aɲ ju hena ta era uɲéri wôsa ôbi uwôgem.» ");
INSERT INTO kqp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ôbi tu tiɲ bi wo hen uwôl bargay kari kaɲ kelanê aɲ, aɲ hena kerêd sa têri a era ligi Jésu a. ");
INSERT INTO kqp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jésu ay kwôlê aɲ eŋgeriri iyôŋ ba: «Na mi a jeré gey bi ené li bem ba?» Ôbi tu tiɲ bi wo hen kôli iyôŋ ba: «*Raboni, en gey gelé kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Menba, Jésu kôli iyôŋ ba: «Ô, ayê bôô wom gôliɲ naɲ ju.» Menba, kiriɲ bay ka hen na, ôbi gel kiriɲ hôriɲ aɲ ôbi ay geré ô tô Jésu a. ");
INSERT INTO kqp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kiriɲa bay eraji ɗa naɲ Jérusalêm na, bay siji si kwa Bêtpajé men, Bétani men, kwa Keram wo Olibiyé a, menba, Jésu jé bay tôri wôô, ");
INSERT INTO kqp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aɲ kôlji iyôŋ ba: «Erêŋge iyére to tumôrŋge hen, kiriɲa ka biɲ na, ka uɲé kema kura hariɲ tôŋ wo kwôni dayri ré tô, bisiréŋgeri ken eraɲ. ");
INSERT INTO kqp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aɲ hena kwôni ré eŋgeréŋge iyôŋ ba: ‹Wô mi a kené busereri ba?› ba, ken kôli: ‹Na Kelma a geyé.› Aɲ kiriɲ bay ka hen ôbi a ɗéŋge ka eraɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bay ôrji menba, bay uwôɲ kema kura hariɲ nô bêŋgê geré ɗa kibi ira. Aɲ bay dôri. ");
INSERT INTO kqp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɓiɲé ka pôni ka ɗibiji ya hen eŋgereji: «Wô mi a kené buser kema kura wo hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Menba, bay tô Jésu uwôlji sara mega ôbi ré kôlji iyôŋ, menba, bay ɗiji ô. ");
INSERT INTO kqp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bay eraɲ naɲ kema kura na biɲ Jésu aɲ bay bi bargay kaji cêgi kura aɲ Jésu ɗay mô sara. ");
INSERT INTO kqp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɓiɲé kwônê bi bargay kaji tô geré, ka pôni pôy germé nono sa biji tô geré a men. ");
INSERT INTO kqp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ka pôni ô tumôri a men, ka pôni ba cêgeri a men aɲ bay ka gura ôm: «Hosana, terê kibi yi gengiɲ sa kwôni wo era naɲ hini Kelma. ");
INSERT INTO kqp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bi terê kibi yi gengiɲ sa emê iyére to era hen, na emê iyére to môyrena kelma Dabid. Hosana yi derômaraŋ a ta.» ");
INSERT INTO kqp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jésu sa Jérusalêm, aɲ ôbi ô bô *iyéy Emen a. Kiriɲa ôbi kôbe kiriɲ gel kêm na, ôbi ô Bétani naɲ bay tôri ka môj kibi wôô hen wôsa tare pôô gaɲ niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sa pôn cêgê kiriɲa Jésu naɲ bay tôri henaji Bétani hen na, kurôŋ li Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ôbi bô kiriɲ kelaŋ dê menba, gel tôgôre to mare lebé ôbi ô gelé yaŋ ba ɗiré uɲé yêre, niɲba, kiriɲa ôbi era ɗa menba, uwôɲ na mare mera wôsa na geserêre ré tô. ");
INSERT INTO kqp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Menba, Jésu kôliɲ tôgôre hende to hen iyôŋ ba: «Kwôni a emê yêrê cêgê ré niɲ.» Bay tôri toy kwôlê wo ôbi kôl hen. ");
INSERT INTO kqp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bay sa biɲ Jérusalêm, menba, Jésu ô derô haba wo iyéy Emen a menba, ôbi dage ɓiɲé kêm ka eraɲ naɲ aŋgaɲ gara men, ka era wô kelé are a men hen. Men, ôbi nôgerê tabel to bay keraŋgê gursu naɲ to bay ɗére derare gara hen hee a men. ");
INSERT INTO kqp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ôbi ɗi kwôni ay ani kani pôn iyôŋ siɲ si bô iyéy Emen ré. ");
INSERT INTO kqp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Menba, Jésu halji kôl iyôŋ ba: «Liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Iyére tiɲê a yé na iyére to tô môɲ wo ɓiɲé a era wô uwôlê Emen ya ré ba?› Menba, kenbay ken ay liɲ kini merê bandi.» ");
INSERT INTO kqp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Damné kaɲ bay bê kwôbe men, *bay derê tô tôô to Emen men na, toy kwôlê bi wo hen iyôŋ menba, wogéji geré wô deré Jésu. Bay hareri wôsa gelé are kari ɗê sa kwônê ɓiɲé men, dôrji a men. ");
INSERT INTO kqp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kiriɲa tare kuriɲ menba, Jésu naɲ bay tôri siji sa iyére hende to hen ôrji aɲ. ");
INSERT INTO kqp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tô kiriɲ, kiriɲa bay ré ôrji tô geré na, bay tô Jésu gelji tôgôre hay kwôy ɗi hanêre a. ");
INSERT INTO kqp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyêr erem sa kwôlê wo Jésu na kôliɲ tôgôre tumô hen menba, ôbi kôliɲ Jésu iyôŋ ba: «*Rabi, gel tôgôre to na ju tômne hen hay.» ");
INSERT INTO kqp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jésu ay kwôlê kôlji iyôŋ ba: «Bêŋge bôrŋge sa Emen a. ");
INSERT INTO kqp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na tu kwôlê a ené kelêŋge hen, hena kwôni ré kôliɲ keram wo hen iyôŋ ba: ‹Dô yem wolé aɲ ju ô kuriɲ a bô cér a› aɲa ôbi ré bi bôri sara na, are bay ka a liɲ ôbi a gelé naɲ tiri, wôsa ôbi gaanê ré, niɲba, bi bôri sa kwôlê wo ôbi kôl hen. ");
INSERT INTO kqp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na bi wo hen aɲa ené kelêŋge, aŋga yôŋ yôŋ ka ken uwôliɲ Emen na, dô wo ken bi bôrŋge sara mega wo kené uwoɲ niɲ, menba, are bay ka hen a liɲ béŋge. ");
INSERT INTO kqp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Men, sa pôn pôn kiriɲa ken hena wô uwôlê Emen aɲa kené ôriɲ naɲ kwôlê wôni naɲ kwôni na, ɗéŋge bôrŋge jal sara aɲ bi Ibareŋge Emen wo mô derômaraŋ a kôba bi ɗi bôri jal sa têriɲ lêreŋge a men.  ");
INSERT INTO kqp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Niɲba, hena kené ɗi bôrŋge jal ré na, Ibareŋge Emen wo mô derômaraŋ a kôba a ɗé bôri jalê sa têriɲ lêreŋge a ré men.» ");
INSERT INTO kqp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jésu naɲ bay tôri hô heraji Jérusalêm menba, kiriɲa Jésu ô derô haba wo iyéy Emen a menba, damné kaɲ bay bê kwôbe naɲ bay derê tô tôô to Emen naɲ surɲê eraji ligiri a. ");
INSERT INTO kqp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aɲ bay eŋgeriri iyôŋ ba: «Na naɲ tôô to yôŋ a jeré liɲ are bay ka kêm hen ba? I a bem tôô hende to hen a jeré liɲ are bay ka hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Menba, Jésu hô uwôlji sara iyôŋ ba: «En gey eŋgeréŋge kwôlê pôn aɲ ken uwôlen sara. Aɲ na kelêŋge naɲ tôô to yôŋ a ené liɲ are bay ka kêm hen. ");
INSERT INTO kqp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Batêm to Ja na liɲ ɓiɲé hen na, hena na derômaraŋ a laba na ligi gawrê ba? Uwôlenge sara.» ");
INSERT INTO kqp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niɲba, bay kôl perêrji a kôl iyôŋ ba: «Hena nana kôl ré na batêm to ré hena na derômaraŋ a na, ôbi a kelê wô mi a na nana bi bôrna sari a ré ba? ");
INSERT INTO kqp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hena nana kôl batêm to Ja liɲ ɓiɲé hen ré hena na ligi gawrê na, ɓiɲé a lên kwôlê.» (Bay hare wôsa kwônê ɓiɲé bô Ja mega *ôbi kibi Emen na tiri.) ");
INSERT INTO kqp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Menba, bay uwôli sara iyôŋ ba: «Nini hôn né.» Menba, Jésu kôlji iyôŋ ba: «Hen iyôŋ na, nôbi kôba na kelêŋge na naɲ tôô to yôŋ ené liɲ are bay ka hen né men.» ");
INSERT INTO kqp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jésu kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Gawra wo pôni yage tiɲaɗor. Ôbi ay haba woɲ gerem a sara. Ôbi pi iyom wô uwôriɲ yêre ya. Aɲ ôbi li iyére to dami toɲ gemé yagê bi wo hen sara. Menba, ôbi biɲ bay yagê tiɲaɗor yagê wori bi wo hen aɲ bay têbri naɲ geserê geserê aɲ ɗiɲ yiri ôriɲ kergare. ");
INSERT INTO kqp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kiriɲa geserê né tiɲaɗor sa niɲ na, ôbi jé mana wori ô uɲé bay gemé tiɲaɗor hende to hen bi ôbi ré ô eŋgé kwa yêre wori eraɲ biri. ");
INSERT INTO kqp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bay gemé tiɲaɗor hende to hen na, ɓerji mana bi wo sê aɲ dageri hô kôbri seŋge. ");
INSERT INTO kqp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ôbi iyé tiɲaɗor na hô jé mana wori kwo ɗaŋgi menba, bay gemé tiɲaɗor bay ka hen hô sêri biri iyare sari a men, tiréri a men. ");
INSERT INTO kqp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ôbi iyé tiɲaɗor na hô jé mana wo ɗaŋgi sôŋ menba, bay gemé tiɲaɗor na diri. Menba, ôbi hô jé ka ɗaŋgi kwône menba, bay liji na mega bi wo bay na liɲ ka tumô hen iyôŋ. Bay sê ka pôni men, bay duu ka pôni men. ");
INSERT INTO kqp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Niɲba, kemari wo ôbi piri hen a ba. Ôbi jéri ligirji a mega gerɲé jé aɲ kôl iyôŋ ba: ‹Ôbi ba, bay a kemnaɲ tini tô.› ");
INSERT INTO kqp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Niɲba, bay gemé tiɲaɗor na kôliɲ yirji iyôŋ ba: ‹Na ôbi emê cibré ibari bi a na, eraŋge, na deréŋgeri aɲ aŋga cibré ibari a kêm na na baɲge.› ");
INSERT INTO kqp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Menba, bay ɓiri diiri aɲ uwôl temayri kelaŋ wolé naɲ yagê tiɲaɗor.» ");
INSERT INTO kqp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Ôbi iyéy tiɲaɗor a lê iyeŋ niɲ ba? Ôbi a sa deré bay gemé tiɲaɗor aɲ a biɲ ka ɗaŋgi gemé. ");
INSERT INTO kqp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ken dêŋse kwôlê bi wo hen bô magtubu a ré ba? ‹Keram bi wo bay ɗé iyére na kaɲni hen na, ôbi a hô yé keram woɲ ɗé tô iyére. ");
INSERT INTO kqp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na Kelma a lê hen iyôŋ aɲ na aŋga dami gaɲ.› » ");
INSERT INTO kqp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bay sa Jubɲê woge geré ciré ɓeré Jésu niɲba, bay hariɲ kwônê ɓiɲé, wôsa bay hôn dô wo gwosore to ôbi ré kôl hen na, ré gengiɲ na sarji. Menba, bay ôrji wolé aɲ ligiri a. ");
INSERT INTO kqp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bay jé *Parisiɲêɲê ka pôni naɲ ɓiɲé ka *Hérôd ligi Jésu a wô ɓeréri sa kwôli kelêri a. ");
INSERT INTO kqp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bay sa kôli iyôŋ ba: «*Rabi, nini hôn wo kwôli kelêrem kêm na, na kwôlê woɲ tiri men, kwôlê bi wo pôn hen a jeré kôliɲ ɓiɲé kêm a men. Wôsa ju dô tu kwôni ré men, ju gelji naɲ geré wo Emen naɲ tu kwôlê a men. Hen iyôŋ na, têbê wôgê wo kelma wo dami *Sésar na, na aŋgaɲ lê laba, na aŋgaɲ lê ré ba? Niné têbri laba, niné têbri ré ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jésu hôn gwosore toji hende to hen dô aɲ kôlji iyôŋ ba: «Wô mi a kené sél bôn iyôŋ ba? Ayêŋge selé pôn ben na na gelé.» ");
INSERT INTO kqp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bay aya selé hende to hen biri. Menba, Jésu eŋgereji iyôŋ ba: «Sa kwôni wo yi yé na naɲ aŋga bay ɗi yé na ba, gengiɲ na sa i ba?» Menba, bay uwôli sara ré na to kelma wo dami Sésar. ");
INSERT INTO kqp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Menba, Jésu kôlji iyôŋ ba: «Aŋga na ka Sésar ba, ken biɲ Sésar, aŋga na ka Emen ba, ken biɲ Emen.» Menba, tiniji ge kay sa kwôlê wo Jésu kôl hen. ");
INSERT INTO kqp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadusiɲêɲê ka kôl iyôŋ ba ɓiɲé ka ma ré jê sé kamɲê ré kwôy hen, eraji ligi Jésu aɲ eŋgeriri kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Rabi, tôô to *Moyis na kelêna iyôŋ ba: ‹Hena kwôni ré ma aɲa ré ɗi tamni mamare aɲa hende ré yê ré tô na, yêni kwôni wo ma hen na ré eŋge turgôri aɲ ré yêɲ kamrê biɲ yêni wo ma hen.› ");
INSERT INTO kqp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Niɲ na ɓiɲé ka pôni na jurgem tô yêniɲare a. Kwo iyêri eŋge iyore menba, ma baa yê kema. ");
INSERT INTO kqp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ôbi cêgeri eŋge turgôri menba, ôbi ma baa yê kema. Are bay ka hen sa sa kwo subi a a men. ");
INSERT INTO kqp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Are bay ka hen sa sa ɓiɲé bay ka jurgem hen kêm ba wo bay ré yê kamrê. Menba, cêgeriji a kêm na, iyore hende to hen ma a men. ");
INSERT INTO kqp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kiriɲa ɓiɲé ka ma a jê sé kamɲê hen na, na i perê yênê ka jurgem hen a na kurô iyore na ba? Wôsa bay kêm na na kwôrɲêre.» ");
INSERT INTO kqp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Menba, Jésu kôlji iyôŋ ba: «Kwôli kelêrŋge saŋgiɲ naɲ ken nono, wôsa ken hôn kwôlo yi bô magtubu to Emen a hen ré men, ken hôn ibé iyêrê wo Emen né a men. ");
INSERT INTO kqp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kiriɲa ɓiɲé ka ma a jê sé kamɲê na, imɲê a eŋgé yébé ré niɲ men, yébé kôba a eŋgeji imɲê ré a men. Niɲba, bay a yé mega *manê ka derômaraŋ a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwôlê wo gengiɲ sa ɓiɲé ka ma na sé bay ré jê sé laba, ré jê sé ré ba ba, na ken dêŋse bô magtubu to *Moyis a kiriɲa Emen siɲ sari a kwa kam gurôɲê hen né ba? Emen na kôli iyôŋ ba: ‹Nôbi ena Emen wo *Abraham, kwo Isak naɲ kwo Jakwôb.› ");
INSERT INTO kqp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Emen na Emen wo ɓiɲé ka mô tu geɲ ɗiba ôbi na Emen wo ka ma hen né. Ermé kwôlê woŋge geriɲ naɲ ken kay damaŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ôbi derê tô tôô to Emen wo pôni toyji wo bay nariɲ menba, ôbi hôn wo Jésu ré uwôlji sara dô. Ôbi uso ɗa aɲ eŋgere Jésu iyôŋ ba: «Tôô to yôŋ a na to dami ɗê megêre ba?» ");
INSERT INTO kqp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jésu uwôli sara iyôŋ ba: «Gel, tôô to tumô a na: ‹Toy *Israyêl, Kelma Emen wona na Kelma pôn nêŋ. ");
INSERT INTO kqp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Aɲ já peré Kelma wom Emen naɲ bôô pôn men, naɲ tunum kêm men, naɲ ermé wom kêm men, naɲ néém kêm a men.› ");
INSERT INTO kqp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gel kwo jôgiɲ wôô wori a na: ‹Gey megam mega ju geyiɲ yem hen iyôŋ. Tôô to ɗaŋgi to dami ɗê ka wôô hen ba naɲ.› » ");
INSERT INTO kqp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ôbi derê tô tôô to Emen kôliɲ Jésu iyôŋ ba: «Rabi wo dôri, ju kôl na tiri kiriɲa ju kôl Emen ré na pôn nêŋ hari aɲ Emen wôni wo ɗaŋgi ré naɲ. ");
INSERT INTO kqp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aɲ bi jeré piri naɲ ermé wom men, naɲ néé wom men, jeré gey megam mega yem iyôŋ a men, na aŋga dô ɗê sargaɲê ka gay gay kêm hen.» ");
INSERT INTO kqp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jésu gel wo ôbi ré uwôli sara dô hen iyôŋ naɲ tu melênê menba, ôbi kôli iyôŋ ba: «Ju kelaŋ naɲ *emê iyére to Emen né.» Menba, kwôni wo ɗaŋgi erem wôsa eŋgeriri kwôlê ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jésu ay tô geliɲ ɓiɲé are bô *iyéy Emen a kôl iyôŋ ba: «Wô mi a bay derê tô tôô to Emen ré kôl *Krist, kwo Emen dôri hen, ré na *kuŋga kelma Dabid ba? ");
INSERT INTO kqp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kelma Dabid naɲ yiri kôba Tunu toɲ hendi bô bôrê wôn bôri aɲ biri kôl iyôŋ ba: ‹Kelma Emen na kôliɲ Kelma wuɲê iyôŋ ba: «Sa mô sa kôben woɲ gusurô, kwôy wo na biɲ bay barem a yé aŋgaɲ sêlê têm.» › ");
INSERT INTO kqp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kelma Dabid naɲ yiri kôba uwôge gawra bi wo hen Kelma menba, iyeŋ a ôbi ré yé kuŋgari sôŋ ba?» Aɲ kwônê ɓiɲé toy kwôlê wori bi wo hen naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kiriɲa Jésu gelji menba ôbi kôl iyôŋ ba: «Berêŋge dô wô bay derê tô tôô to Emen ka gey palê naɲ bargay ka yêŋnê wo ré gel wo ciré na ka damné hen men, gey bi bay ré liji dosé yôd yôd tu wolé men, ");
INSERT INTO kqp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ka gey kiriɲ ka tumô bô *iyéy daɲare a men, kini emê are a hen a men. ");
INSERT INTO kqp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Men, bay na bay mênêre are bô iyé yébé kaɲ mamê, aɲ wôsa lamiɲ tu ɓiɲé na, bay uwôl Emen ɗé ɗé ɗé, na ɗéɲ iyôŋ. Ɓiɲé bay ka hen na, kwôlê wo Emen a ulêji sarji a hen na, na kwôlê wo dami.» ");
INSERT INTO kqp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jésu mô bul kwini si kiriɲ ka bay ɗiɲ sunugu lari ya hen aɲ ôbi bô kwônê ɓiɲé iyeŋ a bay ré bi lari ba. Ɓiɲé ka ôriɲ mê na, bay bi mê. ");
INSERT INTO kqp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iyore to pôni toɲ hende tu ɲa kôba era men, aɲ bi kam sélé wôô to nêm gursu pôn né hen. ");
INSERT INTO kqp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Menba, Jésu uwôge bay tôri aɲ kôlji iyôŋ ba: «Na tu kwôlê a ené ena kelêŋge hen, mamne toɲ hendi nimré hende to hen na, bi ɗê ɓiɲé kêm ka ré sa bi hen. ");
INSERT INTO kqp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wôsa ɓiɲé bay ka hen kêm hen bi na gursu to bay ôriɲ doyre ré niɲ hen, niɲba, hende na, bi na lari kêm wo hende ôriɲ doyre wô keliɲ aŋgaɲ emêre hen.» ");
INSERT INTO kqp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kiriɲa Jésu so bô *iyéy Emen a na, ôbi tôri wo pôni kôli iyôŋ ba: «Ca! *Rabi, gel keram naɲ iyére ka hen.» ");
INSERT INTO kqp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Menba, Jésu kôl iyôŋ ba: «Ju gel iyére hende to damné hen ba? Keram wôni wo a ba ta sa megari a ba naɲ, bay kêm a mêniɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jésu mô sa Keram wo Olibiyé aɲ biliɲ kwini si sa iyé iyéy Emen. Menba, Piyêr, *Jak, Ja naɲ André eŋgeriri kwôlê kiriɲa bay ré môriɲ piniji naɲ ɗi hen. ");
INSERT INTO kqp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bay kôli iyôŋ ba: «Kelêni, kiriɲa yôŋ a are bay ka kêm hen ré sa ba? Men na mi a gelé mega are bay ka hen ré ca kerê niɲ ba?» ");
INSERT INTO kqp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Menba, Jésu kôlji iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a bi kwôni lamêŋge naɲ kwôlê woɲ benare ré. ");
INSERT INTO kqp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wôsa ɓiɲé kwône a ayêji henen aɲ a kelêji: ‹Na nôbi a na *Krist, kwo Emen dôri hen.› Aɲ bay a lamiɲ ɓiɲé kwônê. ");
INSERT INTO kqp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kiriɲa ka toyé kwôli kumbul ôm ɗa réba kelaŋ naɲ ken na, ɗéŋge bôrŋge hare ré wôsa are bay ka hen a sa môj môj dem, niɲba, na gerɲé wulê bi wo hen né tô. ");
INSERT INTO kqp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tô yê pôn a lê kumbul naɲ tô yê wo ɗaŋgi men, emê iyére pôn a séɲ naɲ to ɗaŋgi men, terare a yebagiɲ naɲ sa iyére gay gay men, kurôŋ a lê kiriɲ a men, niɲba, are bay ka kêm hen na, yi mega yê wo ay tô lê iyore iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ɗéŋge tu melênê sa yerŋge a wôsa bay a ôriɲ naɲ ken tumô bay jerê kwôlê men, bay a sêŋge naɲ tinêre bô *iyéy daɲare a men, bay a ôriɲ naɲ ken tumô kilmé men, tumô bay emê iyére a men, wô san, aɲ bi kené uwôliɲ béré Kwôlo Dôri. ");
INSERT INTO kqp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na mi mi kôba béré Kwôlo Dôri wo Emen a uwôliɲ naɲ kiriɲ kiriɲ bi tô yê ɓiɲé kêm toy dema are bay ka hen ré sa tô. ");
INSERT INTO kqp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kiriɲa bay ôriɲ naɲ ken tumô bay jerê kwôlê a na, ken sun tumô wô kwôlê wo kené erê kelê hen né, niɲba, ken kôl kwo Emen a béŋge kiriɲ bay ka hen. Wôsa na kenbay a iyêlê ré, niɲba, na Tunu toɲ hendi bô bôrê a bêŋge kwôlê kebreŋge a. ");
INSERT INTO kqp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gawra a desé sa yêni aɲ bi bay ré diri men, iba kema a liɲ kemari hen iyôŋ hende to hen men, kamrê kôba a perê sa balêrji bi bay ré derji a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɓiɲé kêm a tôrɲêŋge wô kibi henen, niɲba, kwôni wo ɓu bôri iyêre kwôy deriɲ kibi ba, ôbi a gelê.» ");
INSERT INTO kqp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Kiriɲa ken gel aŋga habiɲ ka mêne kiriɲ, ɗi yirji kiriɲ ka bay ré merê ya ré hen, kwôni wo dêŋse na bi hôn dô. Kiriɲ bay ka hen na, bi ɓiɲé ka Judé ba, ge sa keram a men, ");
INSERT INTO kqp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","kwôni wo mô tô tunu a nô ba, bi era ira wô erê ayê ani bô iyére tori a ré niɲ men, ");
INSERT INTO kqp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","kwôni wo ɗebe bô yagê ba, bi hera uwo wô ayê bargay kari ré a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wulê bi wo hen na, bô emê wo dami a lê yébé kaɲ bay kwoo men, ka kamniji yi kuba ba ya tô hen a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Uwôlêŋge Emen bi are bay ka kêm hen bi sa terbére a ré. ");
INSERT INTO kqp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wôsa wulê bi wo hen na, bô emê wo ɓiɲé a lê hen na, na bô emê wo dami wo kwôni gel sa pôn né ayiɲ tôri wo Emen na ɗiɲ tô terare kwôy kemnêŋ hen men, kwôni a herê gelé bô emê bi wo iyôŋgi hen ré niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aɲ hena Emen né jô kibi sa hende to hen ta ré na, kwôni pôn nêŋ iyôŋ kôba a uɲé gelê ré. Niɲba, ôbi ɓu kibi kiriɲ dê wôsa ɓiɲé kari ka ôbi tôrji hen. ");
INSERT INTO kqp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hena kwôni ré kelêŋge iyôŋ ba: ‹*Krist, kwo Emen dôri hen ré ná nà› ley, ‹ré ná yaŋ› ley na, ken bi bôrŋge sa kwôlê wori a ré. ");
INSERT INTO kqp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wôsa Kristɲê kaɲ bay benare hen naɲ bay kibi Emen kaɲ bay benare kwône a lê aŋgaɲ gelé naɲ kaɲ giɲê wô lamiɲ ɓiɲé men, ɓiɲé ka Emen kôba bay a masê wo ciré lamêji a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kenbay kôba ken berêŋge dô wôsa en kelêŋge kêm kô tumô niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Menba, kiriɲ bay ka hen na, cêgi bô emê bi wo a lê ɓiɲé hen na, tare to tay a berarê ré niɲ men, geserê a ené ré niɲ men, ");
INSERT INTO kqp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","têbêŋne a heriɲ ta men, aŋgaɲ néé ka derômaraŋ a a yebagiɲ mêniɲ a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Menba, bay a gelen nôbi *Kema Gawra hera perê kiriɲ ka geri a naɲ néé wo dami men, naɲ damɲare to dami a men. ");
INSERT INTO kqp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kiriɲ bay ka hen na, na jé manê kaɲê ka derômaraŋ a dayrê sa ɓiɲé ka na en tôrji hen sa terare a na kêm a men.» ");
INSERT INTO kqp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ayêŋge tôgôre ken gengiɲ kiriɲ, kiriɲa tôgôre jubu aɲ libé hen na, ken kôl kami emen ré ba ɗa niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kenbay kôba kiriɲa ken gel wo are bay ka hen sa niɲ na, ken hôn wo nôbi Kema Gawra ené ɗa kibi geré niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na tu kwôlê a ené ena kelêŋge hen, gawrê ka haw hen na, ka pôni a ba geɲ kiriɲa are bay ka hen a saɲ. ");
INSERT INTO kqp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Derômaraŋ naɲ sa terare a naɲê niɲba, kwôlê wuɲê na, a naɲê ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Kwôlo gengiɲ sa wulêri naɲ tayriri na, kwôni pôn nêŋ iyôŋ hôn né men, *manê ka derômaraŋ a hôn né men, Kema kôba hôn né a men, niɲba, na Ibari pôn nêŋ hari a henê mera. ");
INSERT INTO kqp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Berêŋge dô, yéŋge kum né wôsa ken hôn kiriɲa yôŋ a are bay ka hen ré saɲ né. ");
INSERT INTO kqp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yi mega gawra wo ɗa erê kergare iyôŋ. Ôbi ɗéɲ iyére tori aɲ biɲ manê kari jé a kôbriji a. I ba naɲ lê jéri. Ôbi ay tôô biɲ ôbi gemé kibi iyére ré yi kum né. ");
INSERT INTO kqp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Merêŋge tu geɲ wôsa ken hôn kiriɲa yôŋ a kelma ôbi iyé iyére ré saɲ né. Na perare, na sa kiriɲ ka jali, na yelé kwôrê, na tô kiriɲ ba, kwôni hôn né. ");
INSERT INTO kqp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Merêŋge tu geɲ bi kiriɲa ôbi sa dus ba, uɲéŋge tô kum a ré. ");
INSERT INTO kqp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kwôlê wo en kelêŋge hen na, en kôliɲ na ɓiɲé kêm: merêŋge sa têrŋge a.» ");
INSERT INTO kqp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ba sa wôô wo bay a lê geserê wo bay uwôgeri *Pak hen men, wô liɲ geserê wo mapa wo wubere naɲ bô a hen a men menba, damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen woge geré gwosore wô ɓeriɲ Jésu aɲ diiri. ");
INSERT INTO kqp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Niɲba, bay kôl bi ciré ɓiri bôb naɲ sa geserê ré, wô wo ɓiɲé ma ré liɲ kwôlê naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kiriɲa Jésu mô Bétani a iyé Simô wo *terbare liri hen, menba, iyore to pôni eraɲ naɲ ider wo ɗiɲê dô wo bay li naɲ kalmê ka bay uwôgeji nar wo garari mê hen, bô murda wo bay li naɲ *albatre hen kôbre a. Hende usoɲ ligi Jésu a aɲ hende ti kibi murda bi wo hen aɲ wuseri sari a kiriɲa bay mô tôŋ kibi emê a hen. ");
INSERT INTO kqp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ɓiɲé ka pôni bôrji tarji sara aɲ bay ɲamnê kwôlê kôl iyôŋ ba: «Wô mi a hende ré mêne ider wo ɗiɲé dô hen iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hena bay ré keléɲ na keléɲare kôba, bay ré uɲé *déniyé arew subu lay aɲ céɲ bay nimré ré ba?» Menba, bay nay iyore hende to hen damaŋ. ");
INSERT INTO kqp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Menba, Jésu kôlji iyôŋ ba: «Ɗéŋgere ɗê iyôŋ. Wô mi a kené dôyrêre hen iyôŋ ba? Aŋga hende lên hen na, na aŋga dôri. ");
INSERT INTO kqp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wôsa bay nimré a merê perêrŋge a naɲ wulê wulê aɲ ka lê derê naɲ ci kiriɲa ken gey, niɲba, nôbi ba na merê naɲ ken naɲ wulê wulê ré. ");
INSERT INTO kqp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hende li aŋga hende nêm lê. En ma ré tô, niɲba, hende sa bên ider san a gemiɲ temayren.» ");
INSERT INTO kqp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Menba, ôbi hô kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, naɲ kiriɲ kêm sa terare a na ka bay a ulê béré Kwôlo Dôri ya hen na, bay a derê kwôli aŋga iyore hende to hen li hen ermiɲ sara.» ");
INSERT INTO kqp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariyôt ôbi tô Jésu wo pôni perê ka môj kibi wôô hen ô uɲé damné kaɲ bay bê kwôbe wô geléji geré ɓeré Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yi damné kaɲ bay bê kwôbe dôrji gaɲ kiriɲa bay toy kwôlê wo ôbi kôlji hen aɲ bay genge ciré biri gursu. Menba, Judas woge geré wo ɗiré ayiɲ sa Jésu biɲ damné kaɲ bay bê kwôbe. ");
INSERT INTO kqp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wulê woɲ ayê tô lê geserê mapa wo wubere naɲ bô hen na, na sa to bay diriɲ gamgê wô liɲ geserê Pak, bay tô Jésu kôli iyôŋ ba: «Na yôŋ a jeré gey bi niré ô ɓerem sa tê lê geserê Pak ya ba?» ");
INSERT INTO kqp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jésu jé bay tôri wôô aɲ kôlji iyôŋ ba: «Erêŋge bô iyére to dami a hen. Ka uɲé gawra wo pôni ay kam naɲ téwre sari a eraɲ si tumôrŋge. Erêŋge tôri a. ");
INSERT INTO kqp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aɲ bô iyére to ôbi a sé bô hen na, ken kôliɲ ôbi iyéy iyére iyôŋ ba: ‹*Rabi kôl iyôŋ ba, bô iyére to yôŋ, a ɗiré ômiɲ emê woɲ Pak naɲ bay tôri ya ba?› ");
INSERT INTO kqp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Menba, ôbi a geléŋge bô iyére to dami ta to bay ɲan bôre kô niɲ. Na ya hende to hen a kené ɓeré sa tê Pak ya.» ");
INSERT INTO kqp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bay tô Jésu ka wôô hen ôrji aɲ sa biɲji derô ira menba, uwoɲji are bay kêm hen mega wo Jésu ré kôlji hen iyôŋ, menba, bay ɓu sa tê Pak ya. ");
INSERT INTO kqp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kiriɲa tare kuriɲ menba, Jésu naɲ bay tôri ka môj kibi wôô hen saji. ");
INSERT INTO kqp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kiriɲa bay mô kibi aŋgaɲ emê menba, Jésu kôl iyôŋ ba: «Na tiri, en kelêŋge, kwôni pôn perêrŋge a wo ôm naɲ en hen a sa ayê san.» ");
INSERT INTO kqp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tu bay tô Jésu ay tô lê ɲa, aɲ i ba eŋgeriɲ Jésu iyôŋ ba: «Na nôbi ré rê?» ");
INSERT INTO kqp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Menba, ôbi uwôlji sara iyôŋ ba: «Kwôni pôn perêrŋge kenbay bay ka môj kibi wôô kwo dôbe kôbri naɲ en bô gwore a hen. ");
INSERT INTO kqp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nôbi *Kema Gawra na erê na mega wo na liɲ bô magtubu to Emen a gengiɲ san hen iyôŋ. Niɲba, bô emê a kuriɲ sa kwôni wo ay san nôbi Kema Gawra hen. Bay henaŋ ré yêri ré kôba ré dô sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kiriɲa bay mô ômji emê menba, Jésu ay mapa aɲ tô kibri sara menba, ɓiilê aɲ biɲ bay tôri aɲ kôlji iyôŋ ba: «Eŋgéŋge, ôbi yi mega kurôŋgi yen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Menba, ôbi hô ay gwoy care toɲ yê tiɲaɗor aɲ ôbi liɲ Emen dosé, menba, ôbi biji aɲ bay yi kêm. ");
INSERT INTO kqp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Menba, Jésu kôlji iyôŋ ba: «Kwo nà ná, yi môɲ kwôbren woɲ biɲare naɲ Emen wo biɲ tôŋ wô kibi ɓiɲé kwône. ");
INSERT INTO kqp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na tiri, en kelêŋge, na hô yê care toɲ yê tiɲaɗor ré niɲ, kwôy wulê wo na sa yiɲ to kôrbi naɲ ken bô *emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kiriɲa bay kebe kurôŋ menba, Jésu naɲ bay tôri ôrji sa Keram wo Olibiyé. ");
INSERT INTO kqp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jésu kôlji iyôŋ ba: «Ka juben ɗéɲ kêm wôsa liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Na deré ôbi abê gamgê menba, bay a useriɲ kêm.› ");
INSERT INTO kqp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Niɲba, cêgê menba, kiriɲa na jê sé kamɲê na, na erê tumôrŋge a Galilé a.» ");
INSERT INTO kqp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Menba, Piyêr kôliɲ Jésu iyôŋ ba: «Kiriɲa megên a ɗém aɲ na, nôbi na ɗém aɲ né.» ");
INSERT INTO kqp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Menba, Jésu kôli iyôŋ ba: «Na tu kwôlê a ené kôlem hen, kemnêŋ bô yoyre hende to hen kura a yelé têê wôô ré aɲ já kelê jeré hônen né têê subu.» ");
INSERT INTO kqp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Niɲba, Piyêr hô kôli iyêre kôl iyôŋ ba: «Hena ré na wo ené ma ré ju kôba, na kelê ené hônem né ré.» Menba, bay kêm kôl mega wo Piyêr kôliɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Menba, Jésu naɲ bay tôri ôrji kiriɲ ka bay uwôgeji *Gêtsémané, aɲ Jésu kôliɲ bay tôri iyôŋ ba: «Merêŋge tôŋ na, aɲ nôbi na erê uwôlê Emen.» ");
INSERT INTO kqp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jésu ôriɲ naɲ Piyêr, *Jak naɲ Ja naɲ ɗi. Ôbi sun men, ôbi aŋge damaŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ôbi kôlji iyôŋ ba: «Tun li ɲa môɲ teré dun iyôŋ, merêŋge na, aɲ ken yi kum né.» ");
INSERT INTO kqp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Menba, Jésu usu dê tumô, aɲ cubu gubari diɲ kwini tôŋ aɲ uwôl Emen mega wo hena ré nêm wo aŋga ré sa sari a hen na, ré sa ré. ");
INSERT INTO kqp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ôbi kôl iyôŋ ba: «Aba, Iban, ju nêm lê are kêm. Li bi en yi gwoy kam toɲ gusiɲ hende to hen né. Iyôŋ hari kôba, li aŋga bôm gey hen ɗiba ka bôn nôbi a geyé hen né.» ");
INSERT INTO kqp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ôbi bulo hera ligi bay tôri a, menba, ôbi uwoɲji tô kum a. Menba, Jésu kôliɲ Piyêr ba: «Simô, ju yi kum! Ju nêm merê tu geɲ sem né ba? ");
INSERT INTO kqp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Merêŋge tu geɲ aɲ ken uwôl Emen bi kené heriɲ bô aŋgaɲ lamê ré. Ken gey merê tu geɲ haŋge niɲba, na néérŋge a nêmê ré ɗi.» ");
INSERT INTO kqp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jésu hô dô tôri aɲ ligi bay tôri ka subu hen aɲ uwôl Emen mega wo tumô iyôŋ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jésu hô bulo hera menba, uwoɲji tô kum a wôsa bay nêm merê geɲ né. Menba, bay hôn kwôlê woɲ kelêri ré. ");
INSERT INTO kqp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jésu hô bulo hera jôgiɲ têê subu wori menba, ôbi kôlji iyôŋ ba: «Yéŋge kum aɲ ken dô bul haŋge niɲ. Kô niɲ. Gel, tayriri sa wo nôbi Kema Gawra na uwôliɲ kôbi bay têriɲ a. ");
INSERT INTO kqp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Henaŋge ta, na erêŋge, gel ôbi ayê san biɲ ɓiɲé bi, sa niɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jésu iyêl ba ya tô menba, Judas ôbi tô Jésu perê ka môj kibi wôô hen so naɲ kwônê ɓiɲé ka naɲ yebere toɲ kaskar men, ka naɲ kwore a men. Damné kaɲ bay bê kwôbe men, *bay derê tô tôô to Emen naɲ surɲê a joji. ");
INSERT INTO kqp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas woɲ ôbi ayê sa Jésu hen na, na kôliɲ kwônê ɓiɲé bay ka hen iyôŋ ba: «Kwôni wo na ibé tô mari liri dosé hen na, na ôbi a kené ɓiri, aɲ ken ôriɲ naɲ ɗi men, ken bôri dô a men.» ");
INSERT INTO kqp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kiriɲa bay sa menba, Judas era ligi Jésu a aɲ uwôgeri «Rabi» aɲ ibe tô mari. ");
INSERT INTO kqp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Menba, kwônê ɓiɲé bay ka hen selam Jésu ɓu. ");
INSERT INTO kqp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kwôni wo pôni perê ɓiɲé ka ɗebe ya hen na, dô yebere toɲ kaskar tori aɲ diɲ maa mana wo *dami wo damné kaɲ bay bê kwôbe jô. ");
INSERT INTO kqp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Menba, Jésu ay kwôlê kôlji iyôŋ ba: «Ken eraɲ naɲ yebere toɲ kaskar men, kwore men kôberŋge a wô ɓerenare mega wo kené kena ɓeré na gemsa iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","En mô perêrŋge a sa pôn pôn geliɲ ɓiɲé are bô *iyéy Emen a menba, ken era sa ɓeren né wô mi ba? Niɲba, yi hen iyôŋ bi kwôlo na liɲ bô magtubu to Emen a hen na, ariri ré liɲ.» ");
INSERT INTO kqp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Menba, bay tô Jésu kêm gerji ɗiri aɲ. ");
INSERT INTO kqp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kema mana wo pôni bi Jésu. Kema mana bi wo hen dôbe bargay ka lebari a yiri a. Asgarɲê ka ɓu Jésu hen na, sa heriɲ sa mana bi wo hen aɲ ɓiri. ");
INSERT INTO kqp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Niɲba, ôbi ɲu bargay kari aɲ, aɲ ge yiri seŋge. ");
INSERT INTO kqp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bay ôriɲ naɲ Jésu iyé dami wo damné kaɲ bay bê kwôbe menba, damné kaɲ bay bê kwôbe ka ɗaŋgi men, surɲê men, bay derê tô tôô tô Emen a men, saji wô daɲare. ");
INSERT INTO kqp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyêr ô tô Jésu a dôriɲ tôri baɲ cêgê dê dê kwôy ôriɲ karaŋ derô haba wo dami wo damné kaɲ bay bê kwôbe a. Ôbi mô iyêbe tare naɲ bay gemé kibi iyé dami wo damné kaɲ bay bê kwôbe bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Damné kaɲ bay bê kwôbe naɲ *Sanédrên kêm woge geré wo ciré ɗiri kwôlo dami sari a aɲ ciré deriɲni, niɲba, bay uwoɲ geréri ré. ");
INSERT INTO kqp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wôsa ka pôni kôl kwôlê woɲ benare gengiɲ sari. Niɲba, kwôlê woji bi wo hen biɲ pôn né. ");
INSERT INTO kqp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka pôni hena aɲ kôl kwôlê woɲ benare gengiɲ sari kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nini toy wo ôbi kôl iyôŋ ba: ‹Na té iyéy Emen to gawrê a ɗé naɲ kôbriji hen aɲ sa subu na herê ɗé to ɗaŋgi hôriɲ aɲ na to gawrê a ɗé naɲ kôbriji ré.› » ");
INSERT INTO kqp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gengiɲ sa kwôlê wo iyére bi wo hen kôba, kwôlê woji biɲ pôn né. ");
INSERT INTO kqp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Menba, dami wo damné kaɲ bay bê kwôbe hena ta perê kwônê ɓiɲé aɲ eŋgere Jésu iyôŋ ba: «Ju uwôl kwôlê sa kwo gawrê bay ka hen kôl gengiɲ sam hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jésu wôm tôŋ. Ôbi uwôl kwôlê wôni sara ré. Menba, dami wo damné kaɲ bay bê kwôbe hô eŋgeri kôl iyôŋ ba: «Ju na *Krist, kwo Emen dôri hen, Kema Emen wo nêm ayê kibi hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Menba, Jésu uwôli sara iyôŋ ba: «Ena ôbi bi a merê hen. Aɲ ka gelen nôbi Kema Gawra na merê sa kôbi gusurô wo Emen woɲ ôbi néé hen men, ka gelen na hera perê kiriɲ ka geri a derômaraŋ a.» ");
INSERT INTO kqp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Menba, dami wo damné kaɲ bay bê kwôbe yêgerê bargay ka yiri a hen aɲ aɲ kôl iyôŋ ba: «Nana hô gem na i dema ré kelêna kwôli sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ken toy tiiré wo ôbi tiiré Emen ôm hen niɲ na, kwôli mi a kené erem niɲ ba?» Menba, bay kêm uwôli kwôlê sari a kôl iyôŋ ba: «Ôbi na kwoɲ deré.» ");
INSERT INTO kqp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Menba, ɓiɲé ka pôni ay tô tibéri kalê a sari a men, bay ha tiri ta aɲ bay esuge kôbriji cibiɲni aɲ bay kôli iyôŋ ba: «Li yem môɲ jeré na *ôbi kibi Emen iyôŋ aɲ ju kelêni i a dêm hen ba?» Menba, bay gemé kibi iyé dami wo damné kaɲ bay bê kwôbe hen kôba, sêri tô mari a a men. ");
INSERT INTO kqp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kiriɲa Piyêr ré môriɲ tôrji a tôŋ derô haba hen na, hende lê jé iyé dami wo damné kaɲ bay bê kwôbe to pôni a sa. ");
INSERT INTO kqp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hende gel Piyêr wo iyêbe tare môriɲ hen menba, hende bôri ɗééɲ aɲ kôli iyôŋ ba: «Jôbi kôba na ju ô naɲ Jésu wo Najarêt men ré ba?» ");
INSERT INTO kqp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Menba, Piyêr uwôser kôl iyôŋ ba: «En hôn né. En hôn bô kwôlê wo me kôl hen né.» Menba, ôbi si ô si kibi geré nô. ");
INSERT INTO kqp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hende gili menba, hô kôliɲ ɓiɲé ka ɗebe ya hen iyôŋ ba: «Ôbi na kwo gawrê bay ka hen men.» ");
INSERT INTO kqp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyêr hô uwôser têê pôn a sôŋ. Sem cêgê menba, ɓiɲé ka ɗebe ya hen na, kôliɲ Piyêr iyôŋ ba: «Na tiri wo jôbi kôba ju na kwo ɓiɲé bay ka hen wôsa ju na kwo Galilé men.» ");
INSERT INTO kqp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Menba, Piyêr dusu yiri kôl iyôŋ ba: «Hena ené kôl ya ré ba, bi Emen deren. Gawra wo ken kôl kwôli hen na, en hôni ré.» ");
INSERT INTO kqp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kiriɲ bay ka hen têê wôô wori menba, kura yel. Menba, bô Piyêr jibri sa kwôlo Jésu na kôli kôl iyôŋ ba: «Já uwôserê jeré hônen né têê subu dema kura ré yilé têê wôô.» Menba, ôbi si nô aɲ sôm. ");
INSERT INTO kqp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tô kiriɲ cud menba, damné kaɲ bay bê kwôbe daɲji naɲ surɲê men, *bay derê tô tôô to Emen naɲ *Sanédrên kêm ka ba hen a men. Kiriɲa bay harê Jésu menba, bay ôriɲ naɲ ɗi ô biɲ Pilat. ");
INSERT INTO kqp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat eŋgereri iyôŋ ba: «Ju na kelma ôbi emê sa iyé Jubɲê bi ba?» Menba, Jésu uwôli sara iyôŋ ba: «Jôbi a kelê hen.» ");
INSERT INTO kqp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Damné kaɲ bay bê kwôbe karê kwôlê wo kwôni ɗiɲ Jésu a sari a. ");
INSERT INTO kqp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Menba, Pilat hô eŋgereri iyôŋ ba: «Ju uwôli kwôlê wôni sa kwôlê wo bay kôl kêm hen né ba? Toy kwôlê wo bay pôy ɗém kem a hen.» ");
INSERT INTO kqp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Menba, Jésu uwôli kwôlê wôni sara ré aɲ li wo tini Pilat ge kay. ");
INSERT INTO kqp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Elê elê naɲ sa geserê *Pak ba, Pilat uwôl kwôni pôn ta bô daŋgay a. Na kwôni wo ɓiɲé gey bi bay ré uwôli ta. ");
INSERT INTO kqp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gawra wo pôni bay uwôgeri Barabas yi daŋgay a naɲ bandiɲê wôsa bay na gey bi kelma ré ômji ré, menba, bay na duu gawra pôn. ");
INSERT INTO kqp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kwônê ɓiɲé eraji si iyé Pilat aɲ bay kôliɲ Pilat ré li aŋga kwo ré lêrê gaŋ gaŋ hen biji. ");
INSERT INTO kqp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Menba, Pilat uwôlji sara iyôŋ ba: «Ken gey bi ené ulêŋge kelma wo Jubɲê ta ba?» ");
INSERT INTO kqp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wôsa ôbi hôn wo ré na terbére a ré liji aɲa damné kaɲ bay bê kwôbe ré ɓeriɲ Jésu bi hen. ");
INSERT INTO kqp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Menba, damné kaɲ bay bê kwôbe gwôsiji ɓiɲé ré kôliɲ Pilat ré uwôl Barabas ta ɗi. ");
INSERT INTO kqp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat hô eŋgereji iyôŋ ba: «Na mi a ené lê naɲ kwo bay uwôgeri kelma wo Jubɲê hen ba?» ");
INSERT INTO kqp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Menba, bay kêm kôli kibriji pôn iyôŋ ba: «Diri aɲ ju ɓééri sa gurô tagelê.» ");
INSERT INTO kqp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat eŋgereji iyôŋ ba: «Na mi ka habiɲ a ôbi ré li ba?» Menba, bay hô kôli kêm iyôŋ ba: «Ɓééri sa gurô tagelê.» ");
INSERT INTO kqp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat gey lê aŋga bôrji gey hen aɲ ôbi uwôl Barabas ta men, ôbi bi bay yêmnê Jésu naɲ tinêre aɲ nôgiri biɲ asgarɲê bi ré ô ɓééri haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asgarɲê ôriɲ naɲ Jésu kini merê Pilat a menba, bay uwôge tô kwônê ɓiɲé kaji ka ba hen. ");
INSERT INTO kqp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bay dôbiɲ Jésu bargay ka hendi silim silim men, bay gaa jabga woɲ kenare naɲ gesem dôbri sari a a men. ");
INSERT INTO kqp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Menba, bay liri dosé kôl iyôŋ ba: «Dosé tom, kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Menba, bay sêri sari a naɲ gusera men, bay tibiri kalê a sari a men, bay cubu gubarji tumôri a mega wo ciré biri kwôlê iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kiriɲa bay sili hen iyôŋ niɲ na, bay dô bargay ka hendi silim silim ka bay ré dôbri yiri a hen men, bay hô tôbri bargay kari hôriɲ aɲ bay siɲ naɲ ɗi nô wô erê ɓééri sa gurô tagelê. ");
INSERT INTO kqp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simô wo na gawra wo Sirên uwo tô nonore a ô erê wori. Ôbi na iba si Alêksander naɲ Rupus. Menba, asgarɲê ɓiri ereŋ biri ay gurô tagelê wo Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Menba, asgarɲê ôriɲ naɲ Jésu kiriɲ ka bay uwôgeji Gwôlgwota. Gwôlgwota na, iyayriri na ibé sa gawra. ");
INSERT INTO kqp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bay gey ciré biɲ Jésu care toɲ kam tiɲaɗor naɲ kalmê ka bay uwôgeji *miir hen bô bi ôbi ré yi, niɲba, Jésu kaɲ. ");
INSERT INTO kqp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Asgarɲê ɓér Jésu sa gurô tagelê aɲ pôrji bargay kari céɲji naɲ geré wo jalaw terê. ");
INSERT INTO kqp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kiriɲa bay ɓééri sa gurô tagelê hen iyôŋ na, tare na deŋgêse toɲ tô kiriɲ. ");
INSERT INTO kqp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sa gurô wo bay ɓééri ya hen na, bay li magtubu di ya uwôliɲ kwôlê sari a kôl iyôŋ ba: «Kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bay ɓér bay gemsare ka pôni wôô naɲ Jésu, kwo pôni sa kôbri maa men, kwo pôni sa kôbri gusurô men.  ");
INSERT INTO kqp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na hen iyôŋ a kwôlo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «Bay dayri pôn naɲ bay gemsare» hen ré ô naɲ geréri têrê têrê. ");
INSERT INTO kqp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓiɲé ka ô tô geré hen kôba, tiiré Jésu aɲ liɲ sarji ômiɲ ya ya aɲ bay kôl iyôŋ ba: «Jôbi ju kôl jeré té *iyéy Emen aɲ jeré hô ɗé hôriɲ sa subu dêj hen na, ");
INSERT INTO kqp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","gôliɲ naɲ yem aɲ ju herbo tôŋ sa gurô tagelê niɲa gelé.» ");
INSERT INTO kqp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Damné kaɲ bay bê kwôbe naɲ bay derê tô tôô to Emen ayrê Jésu kôliɲji perêrji a iyôŋ ba: «Ôbi gôliɲ naɲ ɓiɲé menba, ôbi nêm gôliɲ naɲ yiri ré. ");
INSERT INTO kqp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ôbi wo na *Krist, kwo Emen dôri hen, Kelma wo *Israyêl bi herbo sa gurô tagelê tôŋ bi niɲa gelé aɲ niɲa bê bôrni sari a.» Ɓiɲé ka bay ɓéérji kwari a hen kôba, tiréri a men. ");
INSERT INTO kqp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kiriɲa tare ɗubu ɗiŋne na, kiriɲ hendu sa terare a nà kêm kwôy tare tô yébé ayiɲ sa tôɲne ta hen. ");
INSERT INTO kqp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kiriɲa tare to yébé ayiɲ sa tôɲne ta hen nêm menba, Jésu jô gura wo dami kôl iyôŋ ba: «Elwa, Elwa lema sabaktani?» (Bôri na: «Emen wuɲê, Emen wuɲê wô mi a jeré ɗén aɲ hen iyôŋ ba?») ");
INSERT INTO kqp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ɓiɲé ka pôni ka ɗebe ya hen na, kiriɲa bay toy tôri hen iyôŋ, menba, bay kôl iyôŋ ba: «Toyéŋge, ôbi uwôge *Eli.» ");
INSERT INTO kqp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Menba, kwo pôni ge ô dôbê kibi bargay bô kam tiɲaɗor ka bay uwôgeji binêger hen aɲ dôbe kibi gurô biɲ Jésu bi ôbi ré yi, aɲ kôl iyôŋ ba: «Ɗi jan, naa gelé sé Eli a so sa herberi sa gurô tagelê ba?» ");
INSERT INTO kqp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Menba, Jésu jô gura naɲ tôri to dami menba, kibri wôm men. ");
INSERT INTO kqp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bargay ka bay ha jôriɲ bô iyéy Emen a hen na, yêgiɲ derôre a wôô ayiɲ tôri ta kwôy uwôl tôŋ. ");
INSERT INTO kqp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Dami wo asgar wo ɗebe si tumô gel temayri hen na, kôl iyôŋ ba: «Gawra bi wo hen na, na Kema Emen bi tiri a men.» ");
INSERT INTO kqp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kiriɲ bay ka hen na, yébé ka pôni ɗebe ya sêd wolé gel. Perêrji a na Mari to Magdala men, Mari toɲ yo si *Jak wo dê naɲ Josês men, Salomé men. ");
INSERT INTO kqp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yébé bay ka hen na ôrji tô Jésu a men, na li aŋgaɲ emê biri a men, kiriɲa ôbi na baɲ Galilé. Men, yébé ka ɗaŋgi kwône ka na ôrji naɲ Jésu Jérusalêm a hen ya men. ");
INSERT INTO kqp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kiriɲa tare kuriɲ niɲ na, mega wo na sa ɓéré sa tê sa *sa merê ta menba, ");
INSERT INTO kqp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josêp wo Arimaté sa, ôbi na Sanédrên wo dami wo bay biri kwôlê perê megêri a men, ôbi mô gem *emê iyére to Emen ta a era hen. Ôbi ay harê uwôl aɲ ô iyé *Pilat a ô eŋgéreri temay Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tini Pilat ge kay wo Jésu ré ma niɲ. Menba, ôbi jé uwôga dami wo asgarɲê aɲ eŋgeri séé Jésu ré ma na ca yeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kiriɲa dami wo asgarɲê kôli mega wo Jésu ré ma na tiri na, Pilat ay tôô bi bay ré ɗi Josêp ré ayê temayri. ");
INSERT INTO kqp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josêp kelo kibi bargay ka bôri aɲ, dô temay Jésu tôŋ sa gurô tagelê aɲ lêgeriri naɲ bargay ka bôri aɲ ô eméri bô iyom wo bay kerge bô keram a, menba, gerŋge kulmaŋ keram legiɲ kibi kamɲê ta. ");
INSERT INTO kqp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari to Magdala naɲ Mari toɲ yo Jak gelji kiriɲ ka bay emiɲ Jésu ya hen. ");
INSERT INTO kqp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kiriɲa sa *sa merê ta di jô niɲ menba, Mari to Magdala men, Mari yo *Jak men, Salomé men, kelji ider wo ɗiɲé dô bi ciré erê wusé sa temay Jésu a. ");
INSERT INTO kqp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sa pôn cêgi sa sa merê ta a naɲ sa demas menba, yébé bay ka hen ôrji tô kiriɲ pulôl sa kamɲê kiriɲa tare aya gubeŋ hen. ");
INSERT INTO kqp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bay kôliɲ yirji iyôŋ ba: «I a gerŋgé kulmaŋ keram wo yi kibi kamɲê hen béna ba?» ");
INSERT INTO kqp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bay ay tirji menba, gelji kulmaŋ keram wo dami bi wo hen kwôni gerŋgeri wolé. ");
INSERT INTO kqp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bay si bô kamɲê aɲ gelji kema mana pôn mô si sa kôbi gusurô sa kamɲê. Kema mana bi wo hen dôbe bargay ka bôri aɲ yêŋge. Menba, yébé bay ka hen harê liji. ");
INSERT INTO kqp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Menba, ôbi kôlji iyôŋ ba: «Harêŋge né. Ken woge na Jésu wo Najarêt wo bay na ɓééri hen né ba? Ôbi ji si kamɲê. Ôbi naɲ na. Geléŋge kiriɲ ka bay emiɲni ya hen a nà. ");
INSERT INTO kqp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Herêŋge ken ô kôliɲ bay tôri men, Piyêr a men, mega wo Jésu ré ô tumôrŋge a Galilé. Na yaŋ a kené erê geléri mega wo ôbi na kelêŋge hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yébé bay ka hen soji bô kamɲê gerji men, bay wuré men, harê liji a men. Bay kôliɲ kwôni kwôlê wôni ré wôsa harê liji gaɲ.  ");
INSERT INTO kqp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jésu ji si kamɲê tô kiriɲ cud sa pôn cêgi sa sa merê ta menba, ôbi si sa Mari to Magdala to ôbi na dage tunu to habiɲ jurgem a yere a. ");
INSERT INTO kqp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari to Magdala ô kôliɲ megêre ka na naɲ ɗi hen ka uwôbe aɲ sôm hen mega wo teré uɲa Jésu. ");
INSERT INTO kqp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kiriɲa bay toy wo Jésu ré ji si kamɲê men, hende gelori a men na, bay nare sara. ");
INSERT INTO kqp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cêgeri wori menba, Jésu gel yiri gay biɲ bay tôri ka wôô perêrji a ka ôrji nono hen. ");
INSERT INTO kqp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Menba, bay heraji a Jérusalêm a sa kôliɲ tô megêrji ka ba hen, ciré uɲa Jésu menba, megêrji bay ka hen na naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cêgê menba, Jésu si sa bay tôri ka môj kibi pôn hen kiriɲa bay mô ôm emê menba, Jésu nayji wôsa bô deŋgelé woji men, wô wo bay bi bôrji sa kwôlê wo ɓiɲé ka uwoɲni tô jê sé kamɲê hen na ré a men. ");
INSERT INTO kqp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Menba, ôbi kôlji iyôŋ ba: «Erêŋge naɲ sa iyére iyére sa terare a nà aɲ ken uwôl béré Kwôlo Dôri biɲ gawrê kêm. ");
INSERT INTO kqp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kwôni wo bi bôri sa Kwôlo Dôri bi wo hen a men, li batêm a men ná, a uɲé gelê. Niɲba, kwôni bi bôri sara ré na kwôlê a ɓeré sari. ");
INSERT INTO kqp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Geléŋge aŋgaɲ giɲê ka a uɲé ɓiɲé ka bi bôrji sa Kwôlo Dôri a a nà: naɲ henen ná, bay a dagê tunu to habiɲ men, bay iyêlê kibi kwôlê wo ɗaŋné a men. ");
INSERT INTO kqp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hena bay ré ɓu kalaw naɲ kôbriji ley, yiji hana wo maɲ a men kôba, ani kani a liji ré. Hena bay ré uwôl kôbriji sa bay ômɲare a ná, bay a berarê.» ");
INSERT INTO kqp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kelma Jésu kiriɲa ôbi kôliɲ bay tôri hen iyôŋ menba, Emen ayri ôriɲ ta derômaraŋ a aɲ ôbi ô merê sa kôbri woɲ gusurô. ");
INSERT INTO kqp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Menba, bay tôri ôrji ulê béré naɲ kiriɲ kêm. Kelma li naɲ ci aɲ ôbi bi bay li aŋgaɲ giɲê biɲ tô kwôlê wo bay kôl hen mega wo ré na tu kwôlê. Menba, Mari to Magdala men, Mari toɲ yo Jak men, naɲ Salomé a men, ôrji lew ô kôliɲ Piyêr naɲ megêri kwôlê wo kema mana wo ré kelaji hen. Cêgeri wori menba, Jésu naɲ yiri jéji si tô emen men, si kini kuriɲare tare a men, ulê béré kwôlo yi naɲ jeŋgêri hen men, kwo a mêniɲ né hen men, kwo kwôni a uwôɲiɲ gelé wo naɲ kwini hen a men hen.");
INSERT INTO kqp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dami wuɲê Téwpil, mega wo ɓiɲé kwône na li magtubu kôliɲ kwôli aŋga li sa iyére toni a hen men, ");
INSERT INTO kqp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","bay kôl kwôli are bay ka hen têj têj mega wo kamaŋ ka tumô ka na gel naɲ tirji aɲ bay yi bay ulê béré kwôlê bi wo hen iyôŋ men hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na ôbi á, nôbi kôba, kiriɲa en kôbe tô are bay ka bay na kôl kwôliji hen ayiɲ tôri tô hanêrji a yeŋ hen na, dami wuɲê Téwpil, ");
INSERT INTO kqp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","en gey bi ené lê magtubu dôrem kwôliji bi jeré hôn mega wo kwôli are bay ka kêm ka na ju toy hen na, ré na kwôlê woɲ tiri, ɗiba benayri ré naɲ. ");
INSERT INTO kqp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kiriɲa *Hérôd a nà ná kelma wo Judé hen na, ôbi bê kwôbe wo bay uwôgeri Jakari hen mô ya, ôbi na gwogelé jé wo ca ba nà ná Abiya a nà ná ôbi sari hen. Tamni Elijabêt na tô môɲ wo Arôn wo na *dami wo damné kaɲ bay bê kwôbe hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bay wôô ɓem na ɓiɲé kaɲ derôre tumô Emen a men, bay li tôô to Kelma kêm men, bay bi kwôlê sara a men naɲ tô geréri. ");
INSERT INTO kqp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Niɲba, bay ôriɲ naɲ kamrê ré wôsa Elijabêt yê wore naɲ. Aɲ haw hen bay kôba haal niɲ men. ");
INSERT INTO kqp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sa to pôni a ná, Jakari ô wô lê jé wo bay bê kwôbe tumô Emen a wôsa na wulê woji. ");
INSERT INTO kqp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mega wo bay lêrê gaŋ gaŋ hen iyôŋ na, bay dô Jakari naɲ jalatirê bi ré ô uwoyé gindiriw bô ira kiriɲ ka yi naɲ jeŋgêrji ka gengiɲ sa Kelma hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kwônê ɓiɲé uwôl Emen nô tay uwoyé gindiriw bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kiriɲ bay ka hen na, mana wo Kelma si sa Jakari kini uwoyé gindiriw bi wo hen a aɲ ɗebu si sa kôbi gusurô. ");
INSERT INTO kqp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kiriɲa Jakari gel mana wo Kelma hen iyôŋ menba, tini ge kay men, harê kôba liri damaŋ a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Niɲba, *mana wo Kelma bi wo hen kôli iyôŋ ba: «Hare ré, Jakari, wôsa Emen toy uwôlê wom. Tamnem Elijabêt a yêm kema iba aɲ já uwôgeri Ja. ");
INSERT INTO kqp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Já uɲé yi derê damaŋ men, ɓiɲé kwône a lê yi derê wô sa yêri a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wôsa ôbi a yé gawra wo dami tumô Kelma men, ôbi a yê care to bay li naɲ yê tiɲaɗor hen né men, aŋga maaɲ ka ɗaŋgi kani ré a men, aɲ Tunu toɲ hendi bô bôrê a wunê bôri ayiɲ tôri kiriɲa ôbi baɲ bô yori a tô. ");
INSERT INTO kqp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ôbi a heraɲ naɲ kam *Israyêl kwône biɲ Kelma Emen woji. ");
INSERT INTO kqp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Men, ôbi a yé ôbi ulê béré wo Kelma naɲ Tini Emen to *Eli na ôriɲ hen men, naɲ néé wo ôbi na ôriɲ hen a men, wô lê bi balê kamrê kaɲ imɲê ré gey kamniji men, derê tumô bay narê kwôlê bi bay ré erem kwôlê woɲ derôre aɲ ré yiɲ gawrê ka ôbi ɓu sa têrji wô sa wo Kelma hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari kôliɲ *mana wo derômaraŋ a iyôŋ ba: «Na ba na henê na iyeŋ pôn mega wo kwôlê bi wo hen ré na tiri ba? Wôsa ena kwo iyêri niɲ men, tamnen kôba haal niɲ a men.» ");
INSERT INTO kqp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mana wo derômaraŋ a uwôli sara iyôŋ ba: «Ena Gabriyêl wo ɗebu tumô Emen. Ôbi a joon bi ené iyêlem men, ené kôlem kwôli Kwôlo Dôri bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mega wo ju bi bôm sa kwôlê wo en kôlem a hen né bi wo wulêri nêm ba ariri a liɲ hen na, já iyêlê kwôlê ré kwôy jéɲ wulê are bay ka hen a liɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kiriɲa Jakari ba bô ira tô menba, ɓiɲé gemni nô aɲ bay sun wo ôbi ré yo gaɲ kiriɲ ka yi naɲ jeŋgêrji a. ");
INSERT INTO kqp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kiriɲa ôbi so nô na, ôbi nêm iyêlêji kwôlê wôni ré menba, bay hôn mega wo pelal ré jerari kiriɲ ka yi naɲ jeŋgêrji a hen, ôbi liji kôbri mera aɲ mô meneŋ. ");
INSERT INTO kqp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kiriɲa wulê jé bê kwôbe wori kô niɲ na, ôbi hô iɲ hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cêgeri wori menba, Elijabêt yi kwoo, menba, hende uwôbe kwôy li geserê bay, aɲ kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Geléŋge, aŋga Kelma li ben wulê wo ôbi uwôliɲ tiri san a aɲ aŋga na yén tayre tu ɓiɲé hen na, ôbi dôren kibi a niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Geserê jii cêgi kwôli kwooy Ja ôbi lê batêm a menba, Emen jé mana wori wo bay uwôgeri Gabriyêl hen Najarêt a bô emê wo Galilé. ");
INSERT INTO kqp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ligi môni temale to bay môɲne biɲ Josêp wo na kuŋga kelma Dabid hen. Môni temale hende to hen hene na Mari. ");
INSERT INTO kqp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mana wo derômaraŋ a ô iyé Mari a aɲ kôle iyôŋ ba: «En lêrê dosé, mini to Emen li dô naɲ mu hen, Kelma baa naɲ mu.» ");
INSERT INTO kqp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kiriɲa Mari toy hen iyôŋ menba, tuunu ge kay aɲ hende erem iyôŋ ba dosé to na ba bôre ré na iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Menba, *mana wo derômaraŋ a kôle iyôŋ ba: «Hare ré Mari, Emen genge lê derê naɲ mu. ");
INSERT INTO kqp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mu toy, ma yé kwoo aɲ ma yê kema iba aɲ ma uwôgiri Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ôbi a yé kwôni wo dami men, bay a uwôgiri Kema Emen woɲ ôbi gôliɲ sa are kêm hen men, Kelma Emen a biri merê sa gagay kenare to môyri Dabid a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ôbi a merê sa tô môɲ wo Jakwôb a yôd aɲ emê iyére tori a kerê ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari kôliɲ mana wo derômaraŋ a iyôŋ ba: «En yiɲ naɲ iba wôni ré menba, na yé kwoo na iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Menba, mana wo derômaraŋ a uwôle sara iyôŋ ba: «Tunu toɲ hendi bô bôrê a herbé sarê aɲ néé wo Emen woɲ ôbi gôliɲ sa are kêm hen a têlê sarê naɲ tunuru. Na ôbi á, kema wo ré yêɲ hen ré yiɲ naɲ jeŋgêri hen men, bay a uwôgiri Kema Emen a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elijabêt toɲ gôbrerê hen kôba yi kwori kema iba naɲ halêre hen li geserê jii niɲ, hende to bay na kôl yê wore ré naɲ bi. ");
INSERT INTO kqp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wôsa ani gôliɲ Emen né.» ");
INSERT INTO kqp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Menba, Mari kôl iyôŋ ba: «Ena hende jé to Kelma. Bi are bay ka hen yi mega wo ju kôliɲ hen iyôŋ.» Menba, mana wo derômaraŋ a ɗure aɲ ô. ");
INSERT INTO kqp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sem cêgê menba, Mari hena kerêd ô lew môni iyére to bô emê wo Juda to keram yi ya gaɲ hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hende si bô iyé Jakari a aɲ liɲ Elijabêt dosé. ");
INSERT INTO kqp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kiriɲa Elijabêt toy dosé to Mari lere hen menba, kema wo bôre a hen li yiri menba, Tunu toɲ hendi bô bôrê wôn bôre ta. ");
INSERT INTO kqp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hende jô gura wo dami aɲ kôl iyôŋ ba: «Terê kibi wo Emen yi sarê gôliɲ kwo yébé kêm men, terê kibi wo Emen yi sa kema wo yi bôrê a hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yo Kelma wuɲê, eni to na a meré era kwôy sa gelen hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wôsa kiriɲa en toy dosé menba, kema wo yi bôn a hen li yiri liɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yi derê yi wô sa to bi bôre sa kwôlo hende na toy a kibi mana wo Kelma aɲ hôn mega wo ariri a liɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Menba, Mari kôl iyôŋ ba: «En kebe kurôŋ naɲ yi derê ayiɲ kibi damɲare to Kelma. ");
INSERT INTO kqp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","En sê perê sa kibi Emen woɲ ôbi gôliɲ naɲ en. ");
INSERT INTO kqp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bi wo ena hendi jé tori to ena ani ré hen kôba ôbi ɗi tiri san a. Na tiri, tô yê ɓiɲé kêm a kelê kwôy kwôy wo yi derê ré yi wô san. ");
INSERT INTO kqp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wôsa kwo nééri gôliɲ sa are kêm hen li aŋga dami wô san. Hini yi naɲ jeŋgêri. ");
INSERT INTO kqp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bô derê wori yi wô sa ka hareri a hen naɲ tô môɲ môɲ. ");
INSERT INTO kqp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ôbi eraɲ naɲ néé wori aɲ useriɲ ɓiɲé ka ôriɲ naɲ ermé woɲ uwôyrê yi hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ôbi dage bay néé ka tôŋ na sa gagay kenare toji a aɲ henaɲ naɲ ka bay bôrji môɲ ani ré hen taa. ");
INSERT INTO kqp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ôbi biɲ ka kurôŋ liji hen ari uɲé kwôy nêmji men, bay uɲé ba ôbi tô ari uɲé kaji bay ka hen aɲ aɲ dageji kôbriji seŋge men. ");
INSERT INTO kqp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ôbi era sa li naɲ ɓiɲé ka Israyêl ka na manê kari hen wôsa ôbi gôrbiɲ sa bô derê wo ôbi na li naɲ *Abraham hen né men, ");
INSERT INTO kqp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwôy kemnêŋ kôba, ôbi li naɲ kwôŋgêri mega wo ôbi na ayiɲ tôri biɲ môɲêrna hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari mô iyé Elijabêt a kwôy geserê subu dema ré hô iɲ tô. ");
INSERT INTO kqp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wulê wo Elijabêt a yêɲ nêm menba, hende yê kema iba. ");
INSERT INTO kqp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bay kware naɲ balêre toy wo Kelma ré li dô naɲ tu hen iyôŋ na, bay kôba li yi derê naɲ tu men. ");
INSERT INTO kqp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wulê jurgem cêgi yê Ja ôbi lê batêm a menba, bay ôriɲ naɲ ɗi ciré erê walêri keŋ men, bay gey uwôgiri Jakari mega hini ibari iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Niɲba, yori kôl iyôŋ ba: «Eŋ eŋ, bay ré uwôgeri Ja ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Menba, bay kôle iyôŋ ba kwôni woɲ gôbrerê wo hini ôm iyôŋ ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bay liɲ Jakari kôbriji na ba ôbi ré gey uwôgiri iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ôbi eŋgere are ɗiré ɗiɲ are aɲ ɗi iyôŋ ba: «Hini na Ja.» Menba, bay kêm tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kiriɲ bay ka hen menba, kibri naɲ kôli beseriɲ aɲ ôbi iyêl kwôlê uwôliɲ hini emê sa Emen a. ");
INSERT INTO kqp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kiriɲ bay ka hen na, harê li ɓiɲé kêm ka mô kwa kwa hen men, ka merê sa kam iyére to sa iyé Judé to keram yi ya gaɲ hen a men na, kôl kwôli are bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓiɲé kêm ka toy kwôli are bay ka hen na, ɓu bôrji a aɲ bay ɲamniɲ iyôŋ ba: «Kema bi wo hen a yé iyeŋ?» Na tiri kôbi Kelma na sari a. ");
INSERT INTO kqp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tunu na wôn bô Jakari iba kema bi wo hen aɲ na kôliɲ ɓiɲé kwôlo Emen na kôl hen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Heramê yi gengiɲ sa Kelma wo na Emen wo Israyêl, wôsa ôbi era sa li naɲ ɓiɲé kari a men, ôbi dôrji kôbi bay bareji a a men, ");
INSERT INTO kqp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ôbi soɲ naɲ ôbi néé woɲ ôbi gôliɲ naɲ na perê kwôŋgê mana wori kelma Dabid a. ");
INSERT INTO kqp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Na hen iyôŋ a ôbi na ré kôl ca tumô naɲ bay kibri ka na yi jeŋgêrji hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mega wo ôbi ɗiré derêna kôbi bay barena men, kôbi ɓiɲé kêm ka tôrɲêna hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ôbi gel bô derê wori wo sa môɲêrna men, hô erem sa tôô toɲ biɲare to yi naɲ jeŋgêre to ôbi na ay hen men, ");
INSERT INTO kqp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sa tôri to ôbi na ay biɲ *Abraham ibarna, ");
INSERT INTO kqp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɗiré derêna kôbi bay barena aɲ nana tibri naɲ harê ré niɲ ");
INSERT INTO kqp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","men, bi nana yiɲ naɲ jeŋgêrna men, nana yiɲ kaɲ derôre a men kwôy wo nana baɲ sa terare a na tô hen. ");
INSERT INTO kqp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aɲ jôbi kema na, bay a uwôgem *ôbi kibi Emen woɲ ôbi gôliɲ sa are kêm hen wôsa já erê tumô Kelma a wô ɲanê geré wori ");
INSERT INTO kqp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","men, bi ɓiɲé kari ré hôn ɗiré sa gôliɲ naɲ ci aɲ ɗiré ɗiɲ bôri jal sa têriɲ toji a. ");
INSERT INTO kqp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Emen wona na ôbi berê tu ɲa wo dami men, na ôbi bô derê wo dami a men. Na hen iyôŋ aɲa, ôbi réé bé kiriɲ ka peraŋgi ka hena derômaraŋ a geliɲ mega tare to aya hen iyôŋ peraŋge kiriɲ sarna. ");
INSERT INTO kqp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aɲ kiriɲ ka peraŋgi bay ka hen na, peraŋge si sa ɓiɲé ka mô dilemne a hen men, ka mô tini temare a hen a men hen wô derê tumôrji ôriɲ naɲ ci tô geré bô jalê a.» ");
INSERT INTO kqp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kema bi wo hen kwori ba, ôbi a ɗebé men, suriyare uwôgeri a men. Aɲ kiriɲa tiri melên niɲ menba, ôbi a erê merê derô gwôlê kwôy wulê wo ôbi a geliɲ yiri tumô *Israyêl a. ");
INSERT INTO kqp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wulê bi wo hen na, kelma wo dami *Sésar Ogust ay tôô bay ré dêŋse ɓiɲé ka sa terare a nà kêm ka bô emê wori a hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tôô to tumô toɲ deŋsê ɓiɲé hende to hen na, na bô elê wo Kirinus kelma wo Sésar Ogust na ɗiri ôm sa iyé Siri hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓiɲé kêm ô ɗé hiniji i ba tô môɲ wori a, wori a. ");
INSERT INTO kqp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na hen iyôŋ a Josêp kôba ré hena Najarêt bô emê wo Galilé aɲ hera Bêteléhêm sa iyé kelma Dabid a bô emê wo Judé wôsa balêri naɲ tô môɲ wori na kwo kelma Dabid. ");
INSERT INTO kqp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ôbi ô wô ɗé hini naɲ tamni Mari. Hende yi kwoo a men. ");
INSERT INTO kqp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sa hende to bay môriɲ Bêteléhêm a wô ɗiɲ hiniji hen na, sa yê wo Mari nêm a men. ");
INSERT INTO kqp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Menba, hende yê kema woɲ kalmare bi wo hen aɲ lêgeriri naɲ bargay uwôli sa kiriɲ ka bay biɲ lari emê ya hen wôsa kiriɲ ka bay ré yiɲ naɲ bô iyéy kergê. ");
INSERT INTO kqp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bô nono sa iyére hende to hen a na, bay abê gamgê môrji nono gem gamgê kaji bô yoyre a. ");
INSERT INTO kqp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Menba, mana wo Kelma si sarji a aɲ kiriɲ ka peraŋgi ka Kelma peraŋge kiriɲ sarji a menba, kiriɲ bay ka hen na, harê liji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Menba, *mana wo Kelma bi wo hen kôlji iyôŋ ba: «Harêŋge né wôsa en era na wô kelêŋge Kwôlo Dôri wo a yé yi yé wo dami wo ɓiɲé kêm hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kemnêŋ bay yêŋge sa iyé kelma Dabid a ôbi gôliɲ naɲ ken ôbi a na *Krist wo Emen na dôri men, na Kelma a men hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aŋga a geléŋge ré na kema bi wo hen a ré nà a nà: ka uɲé kema wo bay yêri haw aɲ lêgeriɲ naɲ bargay uwôliɲ kiriɲ ka bay biɲ lari emê ya hen.» ");
INSERT INTO kqp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kiriɲ bay ka hen na, kwônê *manê ka derômaraŋ a soji ɗebiji kwa kwo tumô hen aɲ kibji kurôŋ ayiɲ kibi Emen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Hini emê yi derômaraŋ a ta mereg wô sa Emen men, bô jalê yi sa terare a nà, wô sa kibi ɓiɲé ka ôbi li dô naɲ ci hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiriɲa manê ka derômaraŋ a bay ka hen ɗiji aɲ aɲ belji hô ta niɲ menba, bay gemé gamgê kôl iyôŋ ba: «Na erêŋge kwôy Bêteléhêm a ô geléŋge are bay ka li are ka Kelma kelêna kwôliji hen.» ");
INSERT INTO kqp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bay iyêlbeji ô menba, uwôɲji Mari naɲ Josêp men kema wo dê bi wo hen, yi a sa kiriɲ ka bay biɲ lari emê ya hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kiriɲ ka bay gili hen iyôŋ niɲ menba, bay dô kwôlo ciré toya gengiɲ sa kema bi wo hen hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Menba, ɓiɲé kêm ka toy kwôlo bay gemé gamgê dô hen na, tiniji ge kay kêm. ");
INSERT INTO kqp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kwo Mari ba hende gem kwôlê bi wo kêm hen bôre a aɲ woge wô henê bôri. ");
INSERT INTO kqp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Menba, bay abê gamgê belji hô iɲ naɲ kebé kurôŋ ayê kibi naɲ heramê Emen wô kwôli aŋga ciré toy men, ciré gel a men hen wô wo ré biɲ naɲ kwôlo *mana wo derômaraŋ a na ré kôlji hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wulê jurgem cêgi yêri a menba, kiriɲa sa waliɲ kema bi wo hen keŋ nêm menba, bay uwôgeri Jésu mega wo mana wo derômaraŋ a na uwôgiɲni pa dema bay na ré yiɲ kwoyri tô hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kiriɲa wulê wo si Josêp naɲ Mari ré lôɲiɲ yirji nêm mega wo tôô to *Moyis na kôliɲ hen iyôŋ menba, bay ôriɲ naɲ Jésu Jérusalêm a ciré erê geliɲ Kelma. ");
INSERT INTO kqp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mega wo liɲ bô magtubu tôô to Kelma kôl iyôŋ ba: «Kema iba wo yôŋ yôŋ wo na yê kalmare na, a yé gay biɲ Kelma» ");
INSERT INTO kqp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","men, wô biɲ kwôbe mega wo tôô to Kelma kôliɲ iyôŋ ba ré na «biɲjalo wôô réba kam derare ré na wôô men hen.» ");
INSERT INTO kqp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kiriɲ bay ka hen na, gawra wo pôni mô Jérusalêm a ya hini na Siméɲôn. Na kwôni woɲ derôre men, li tôô Emen dô a men. Ôbi mô gem bi ɗiré gelé kwo ré gôliɲ naɲ *Israyêl hen aɲ Tunu toɲ hendi bô bôrê ba naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tunu toɲ hendi bô bôrê kôli ôbi ré ma ré kwôy wo ôbi ré geliɲ Krist wo Kelma Emen dôri aɲ jori hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tunu toɲ hendi bô bôrê jubu tô bôri menba, ôbi era bô *iyéy Emen a menba, kiriɲa balê Jésu eraɲ naɲ ɗi ciré liɲ gengiɲ sari aŋga tôô kôl ré liɲ hen menba, ");
INSERT INTO kqp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ôbi ayri kabrêri a aɲ ay kibi Emen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Haw hen Kelma ɗi mana wom ô naɲ bô jalê hari niɲ wôsa ju li tôm to na ju ay hen niɲ, ");
INSERT INTO kqp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","wôsa en gel gelê wom bi naɲ tun niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Gelê bi wo na ju ɓu sa têêri tu ɓiɲé a kêm hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ôbi na kiriɲ ka peraŋgi ka a lê aɲ ɓiɲé ka sa terare a na kêm ka na Jubɲê ré hen a hônem men, ôbi a yé hini emê wo Israyêl ɓiɲé kari a men.» ");
INSERT INTO kqp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kiriɲ bay ka hen na, balê kema na tiniji ge kay sa kwôlo Siméɲôn kôl gengiɲ sari hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siméɲôn tô kibri sarji a aɲ kôliɲ Mari yo kema na iyôŋ ba: «Sa kibi kema bi wo Emen dôri hen na, ɓiɲé kwône Israyêl a a heriɲ men, ka a hena ta. Ôbi a yé aŋgaɲ gelé ka Emen ka ɓiɲé a kaɲê. ");
INSERT INTO kqp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na ôbi a lê bi ermé wo uwôbe bô ɓiɲé hen réé hôniɲ. Kworé mini Mari ba, ma geliɲ gusiɲ môɲ yebere a réé wayê kabrêrê iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kiriɲ bay ka hen na, hendi kibi Emen to pôni hene na Aan mô ya, hende na môni Panuwêl wo tô yê wo Asêr. Hende na iyore to haal gaɲ niɲ. Hende na gô iyére elê jurgem naɲ kurôre woɲ ôbi biyêre. ");
INSERT INTO kqp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Menba, hende mô mamare aɲ elêre na, tôre marge kibi pôrbu. Hende ba erê bô iyéy Emen a sa pôn né kwôy yoyre naɲ tu tare men, hende tebe Emen men, jôriɲ bôre kurôŋ men, uwôli a men. ");
INSERT INTO kqp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hende sa ya têj kiriɲa balê Jésu eraɲ naɲ ɗi wô geliɲ Emen hen menba, hende liɲ Emen dosé aɲ dô kwôli kema bi wo hen biɲ ɓiɲé kêm ka mô gem wo Emen né dô Jérusalêm kôbi Rômêɲê a hen. ");
INSERT INTO kqp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kiriɲa Jésu naɲ balêri liji tôô to Kelma hende to hen kô niɲ menba, bay belji hô sa iyérji a Najarêt a bô emê wo Galilé. ");
INSERT INTO kqp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jésu ɗebu men, ibéri gese men, tu melênê wôn bôri men, bô derê wo Emen baa naɲ ɗi a men. ");
INSERT INTO kqp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naɲ elê elê ba balê Jésu ô Jérusalêm a kwôy kwôy wô lê geserê *Pak. ");
INSERT INTO kqp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jésu elêri na môj kibi wôô niɲ menba, bay ôriɲ naɲ ɗi mega wo hara woji kôl hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kiriɲa bay li geserê bi wo hen kô niɲ menba, balê Jésu bul hô Najarêt a menba, ôbi baa tôŋ Jérusalêm a menba, bay hôn né. ");
INSERT INTO kqp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bay kôl yaŋ ba ôbi ré ô aɲê perê ɓiɲé ka bay uwo ɓem hen ya ya, aɲ bay ô kwôy li wulê pôn geré. Menba, bay ay tô wogéri perê milɲérji a men, perê balêrji a a men. ");
INSERT INTO kqp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Niɲba, bay uwôɲni ré. Menba, bay wogeri kwôy hôriɲ Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bay wogeri hen iyôŋ kwôy sa subu dema bay ré ô uɲéri mô tôŋ bô iyéy Emen a perê bay geliɲare ɓiɲé tôô to Emen a. Ôbi toy kwôlo bay kôl hen men, ôbi eŋgeriji kwôlê sara men. ");
INSERT INTO kqp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓiɲé kêm ka toy kwôlo ôbi kôl hen men, tu melênê wori men, kwôlo ôbi uwôlji sara hen a men na, tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kiriɲa balêri gili kiriɲ bay ka hen a ná, tiniji ge kay aɲ yori kôli iyôŋ ba: «Keman, wô mi a jeré lêni aŋga hen iyôŋ ba? Nibay naɲ ibam nini sun kwôlem gaɲ aɲ nini wogem kebiɲ kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Menba, Jésu uwôlji sara iyôŋ ba: «Wô mi a kené wogen ba? Ken hôn mega wo enéé cibé tun tô aŋga Iban a iyôŋ né ba?» ");
INSERT INTO kqp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Niɲba, bay hôn bô kwôlo ôbi kôlji hen né kwôy. ");
INSERT INTO kqp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ôbi bul hô naɲ ci Najarêt a. Men, ôbi biji kwôlê sa are kêm a a men. Yori gem are bay ka kêm hen bôre a dô. ");
INSERT INTO kqp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jésu ɗebu men, tu melênê wori kôba erê tumô tumô men, ôbi dé tu Emen men, tu gawrê a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bô elê môj kibi bay wo emê iyére to Tibêr *Sésar kelma wo dami wo Rômêɲê hen na, Pos *Pilat wo Sésar na ɗiri ôm iyére to Judé men, *Hérôd na na kelma sa terare to Galilé men, yêni Pilip na na kelma sa terare to Ituré men, to Trakwonitid a men, Lisaniya na na kelma sa terare to Abilên a a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Si Aan naɲ Kayib ná damné ka damné kaɲ bay bê kwôbe. Bô elê bi wo hen a ná, Emen biɲ Ja kema Jakari kwôli a kibri a derô gwôlê. ");
INSERT INTO kqp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Menba, Ja hena ô gôr sa iyére kêm to yi têm têm kibi cér wo Jurdê hen. Aɲ kôl iyôŋ ba: «Beléŋge cêgerŋge biɲ têriɲ aɲ ken li batêm aɲ bi Emen né ɗiɲ bôri jalê sa têriɲ toŋge a.» ");
INSERT INTO kqp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ôbi a, kwôlo *ôbi kibi Emen *Esay na kôl bô magtubu tori a hen ré ô ya têj têj hen. Ôbi na kôl iyôŋ ba: «Bay toy tôô kwôni wo uwôl gura derô gwôlê kôl iyôŋ ba: ‹Ɲanêŋge geré wo Kelma men, ɲanêŋge kam geré kari bi ô derôre a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tu ɗogé kêm a ligiɲ men, keram naɲ sa gôserew a hera némiɲ naɲ sa terare men, geré wo kwôŋgi a yé derôre men, geré wo yi jerew ba ɲaniɲ némiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aɲ ɓiɲé kêm a gelé gelê wo Emen biɲ ɓiɲé hen.› » ");
INSERT INTO kqp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ja kôliɲ kwônê ɓiɲé ka era bi ôbi ré liji batêm hen iyôŋ ba: «Kenbay ka ken yi môɲ jênêre iyôŋ hen, na i a geléŋge bi kené geriɲ uwoŋge wo Emen wo a era hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bi jé lêreŋge gel wo kené bul cêgerŋge biɲ têriɲ toŋge, aɲ ken ɗi kelê ‹*Abraham na ibarni, Abraham na ibarni› hen baa niɲ, wôsa en kelêŋge, jerew wo yi hen na, Emen a nêmê belé liɲ kamrê biɲ Abraham. ");
INSERT INTO kqp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Haw hen na, tigre yi tô gurô pôn pôn niɲ aɲ gurô wo yôŋ yôŋ wo yêri dô ré ba, a diɲ jôriɲ aɲ uwôliɲ tare a.» ");
INSERT INTO kqp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kwônê ɓiɲé eŋgere Ja iyôŋ ba: «Na mi a niné lê ba?» ");
INSERT INTO kqp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Menba, ôbi uwôlji sara iyôŋ ba: «Hena kwôni ré naɲ bargay wôô ba, bi biɲ kwo ôriɲ né hen pôn men, kwo ôriɲ aŋgaɲ emê ba, bi biɲ kwo naɲni hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Bay eŋgé wôgê kôba era sa li batêm men, aɲ eŋgeriɲji Ja iyôŋ ba: «Rabi, na mi a niné lê ba?» ");
INSERT INTO kqp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Menba, ôbi kôlji iyôŋ ba: «Wôgê bi wo bay genge hen a kené eŋgé, ɗiba ken eŋge ani kani a sara ré.» ");
INSERT INTO kqp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asgarɲê kôba era sa eŋgeriri iyôŋ ba: «A nibay ba, niné li iyeŋ ba?» Menba, ôbi uwôlji sara iyôŋ ba: «Eŋgéŋge gursu kôbi kwôni a naɲ kabrê iyêrê ré men, piyêŋge kwôlê ɗiɲ kwôni sari a wô uwôɲiɲ gursu toni ré a men. Niɲba, ken cebe turŋge a sa sa kôbreŋge wo bay têbêŋge hen mera.» ");
INSERT INTO kqp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓiɲé mô gem aɲ i ba erem bôri a kôl iyôŋ ba: «Ôbi a na *Krist, kwo Emen dôri hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Menba, Ja uwôlji sara kêm kôl iyôŋ ba: «Nôbi ba, en lêŋge batêm na naɲ kam, niɲba, ôbi wo era hen na, na kwo nééri ɗê kuɲê aɲ en nêm beseré gaŋgi garbê kaɲ têri ré. Ôbi a lêŋge batêm naɲ Tunu toɲ hendi bô bôrê men, naɲ tare a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ôbi ɓu gwore toɲ péé kaw kôbri a wô labiɲ kiriɲ kaɲ péé kaw kari ya, aɲ a pera kaw kari eraɲ bê a bô béér a. Kurmérji ba, ôbi a uwoyé aɲ bô tare to eŋge bariɲ né yôd hen.» ");
INSERT INTO kqp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na hen iyôŋ men, naɲ gelé kwôlo ɗaŋgi a men, a Ja ré uwôliɲ béré Kwôlo Dôri biɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Men, ôbi na nay kelma Hérôd wô *Hérodiyad toɲ tami yêni to ôbi na eŋge hen men, wô aŋga habiɲ kêm ka ôbi li hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wôsa nôm a sa têriɲ tori hende to kêm hen na, Hérôd bi bay ɓu Ja uwôli daŋgay a a sôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kiriɲa Ja na liɲ ɓiɲé kwône batêm hen na, Jésu kôba li batêm men. Ôbi uwôl Emen menba, kiriɲ bay ka hen, derômaraŋ bôliɲ, ");
INSERT INTO kqp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aɲ Tunu toɲ hendi bô bôrê herbo mega derare iyôŋ sari a aɲ tô kwôni hena derômaraŋ a kôl iyôŋ ba: «Ju na Keman, en purem damaŋ men, en li yi derê wô sam damaŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kiriɲa Jésu ayiɲ tô lê jé wori hen na, elêri na tôre subu ley. Ɓiɲé kêm erem wo ôbi ré na kema Josêp wo tô môɲ wori a nà hen: Josêp woɲ kema Éli, ");
INSERT INTO kqp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","kema Matat, kema Lébi, kema Mêlki, kema Iyanay, kema Josêp, ");
INSERT INTO kqp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","kema Matatiyas, kema Amôs, kema Nayum, kema Êsli, kema Nagay, ");
INSERT INTO kqp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","kema Maat, kema Matatiyas, kema Séméyin, kema Iyôsêk, kema Iyôda, ");
INSERT INTO kqp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","kema Iyôwanan, kema Résa, kema Jorobabêl, kema Salatiyêl, kema Néri, ");
INSERT INTO kqp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","kema Mêlki, kema Adi, kema Kwosam, kema Êlmadam, kema Er, ");
INSERT INTO kqp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kema Jésu, kema Eliyêsêr, kema Iyôrim, kema Matat, kema Lébi, ");
INSERT INTO kqp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","kema Siméɲôn, kema Juda, kema Josêp, kema Iyônam, kema Eliyakim, ");
INSERT INTO kqp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kema Méléya, kema Ména, kema Matata, kema Natan, kema Dabid, ");
INSERT INTO kqp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kema Jesé, kema Obêd, kema Bohoj, kema Sala, kema Nasôn, ");
INSERT INTO kqp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","kema Aminadab, kema Admin, kema Arni, kema Esrôm, kema Parês, kema Juda, ");
INSERT INTO kqp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kema Jakwôb, kema Isak, kema Abraham, kema Tara, kema Nakôr, ");
INSERT INTO kqp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kema Séruk, kema Rago, kema Palêk, kema Ebêr, kema Sala, ");
INSERT INTO kqp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kema Kaynam, kema Arpasad, kema Sêm, kema Nowé, kema Lamêk, ");
INSERT INTO kqp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kema Matusala, kema Énôk, kema Iyarêt, Maléléyêl, kema Kaynam, ");
INSERT INTO kqp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kema Enôs, kema Sêt, kema Adam, kema Emen. ");
INSERT INTO kqp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tunu wôn bô Jésu menba, ôbi hena kibi cér wo Jurdê a bulo hera. Hende ôriɲ naɲ ɗi derô gwôlê. ");
INSERT INTO kqp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Sidan séli wulê tôre pôrbu, wulê bi wo hen na, ôbi ôm ani ré kwôy aɲ kiriɲa wulê bi wo tôre pôrbu hen kô niɲ, menba, kurôŋ liri. ");
INSERT INTO kqp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kiriɲ bay ka hen na, Sidan kôliɲ Jésu iyôŋ ba: «Hena jeré na Kema Emen ba, ju kôliɲ jerew wo yi hen ré beliɲ kwô.» ");
INSERT INTO kqp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Menba, Jésu uwôli sara iyôŋ ba: «Liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Na kwô mera a gawra ré emê gôliɲ né.› » ");
INSERT INTO kqp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Menba, Sidan ôriɲ naɲ ɗi sa keram a ta aɲ turna to nana kôliɲ na menba, ôbi gili emê iyére to sa terare a nà kêm. ");
INSERT INTO kqp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aɲ kôli iyôŋ ba: «Na bem néé woɲ emê iyére hende to hen naɲ hini emê wo yi ya hen wôsa bay na ben na nôbi aɲ na biɲ kwôni wo bôn gey. ");
INSERT INTO kqp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iyôŋ ba, hena jeré jubu gubam tumôn a ba, na bem kêm.» ");
INSERT INTO kqp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Menba, Jésu uwôli sara iyôŋ ba: «Liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Kelma woɲ Emen wom pôn nêŋ hari a jeré jebé gubam tumôri a men, na ôbi a jeré tibéri a men.› » ");
INSERT INTO kqp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Menba, Sidan hô ôriɲ ɗi Jérusalêm a aɲ ayri ɗiri ta yeŋ sa *iyéy Emen a aɲ kôli iyôŋ ba: «Hena jeré na Kema Emen ba ju deraɲ kuriɲ tôŋ na gelé, ");
INSERT INTO kqp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","wôsa na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Ôbi a ayê tôô biɲ *manê ka derômaraŋ a gengiɲ sam bi bay ré sa gemem› ");
INSERT INTO kqp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","men, ‹Bay a ayem kôbriji a bi têm ré di keram wôni ré.› » ");
INSERT INTO kqp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Menba, Jésu uwôli sara iyôŋ ba: «Na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Kelma Emen wom na, já séléri ré.› » ");
INSERT INTO kqp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kiriɲa gwosore to ɗiré séliɲ Jésu naɲ niɲ menba, Sidan dô yiri yi Jésu a kwôy gemiɲ wulê wo ɗaŋgi. ");
INSERT INTO kqp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jésu bulo hera Galilé naɲ néé wo Tunu aɲ hini emê wori ôm gôriɲ kiriɲ kêm sa ira. ");
INSERT INTO kqp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ôbi geliɲ ɓiɲé are bô *iyéy daɲare a naɲ sa iyére iyére aɲ bay kêm ay kibri. ");
INSERT INTO kqp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jésu hera Najarêt kiriɲ ka ôbi na iyêriɲ ya hen, menba, mega wo ôbi lêrê gaŋ gaŋ hen iyôŋ na, ôbi ô bô iyéy daɲare a naɲ sa *sa merê ta aɲ hena ta wô dêŋse magtubu tôô to Emen. ");
INSERT INTO kqp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bay biri magtubu to lêgeriɲ to *Esay *ôbi kibi Emen, kiriɲa ôbi bôl menba, uwoɲ kiriɲ ka bay na li kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Tini Kelma yi san a wôsa ôbi a dôren bi ené uwôliɲ béré Kwôlo Dôri biɲ bay nimré men, wô kôliɲ daŋgayɲê kwôli bêreji ta men, kôliɲ bay tu tiɲ ré geléji kiriɲ hôriɲ men, ka bay geliɲ tirji gusiɲ hen kôba kwôli derêji bô gusiɲ men, ");
INSERT INTO kqp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ulê béré kwôli elê woɲ bô derê wo Kelma biɲ gawrê hen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jésu lêgere magtubu hende to hen ta aɲ biɲ ôbi jé wo pôni aɲ mô tôŋ ɓiɲé kêm ka bô iyéy daɲare a hen na, tirji yi sari a. ");
INSERT INTO kqp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Menba, ôbi kôlji iyôŋ ba: «Kemnêŋ na, kwôlê bi wo en dêŋse aɲ ken toy hen na, ariri liɲ béŋge niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓiɲé kêm ka mô ya hen na, kôl kwôli dô men, tiniji ge kay sa kwôli bô derê wo ôbi kôlji hen aɲ bay kôl iyôŋ ba: «Ôbi na kema Josêp ré ba?» ");
INSERT INTO kqp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Menba, ôbi kôlji iyôŋ ba: «En hôn kena kôlen gwosoy kwôlo kôl iyôŋ ba: ‹Dôktôr berare yem pa dem.› Ka kelê iyôŋ ba: ‹Bay kelêni kwôli aŋga ju li Kapêrnayôm a. A iyôŋ ba, ju li sa iyére tom a hen iyôŋ men.› » ");
INSERT INTO kqp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Menba, ôbi uwôlji sara iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, kwôni wo na ôbi kibi Emen na, sa iyére tori a na, bay a geyé kwôlê wori ré. ");
INSERT INTO kqp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na tu kwôlê a ené ena kelêŋge hen, yébé kaɲ mamê na kwône sa iyé *Israyêl bô wulê *Eli a. Bô elê bi wo hen a na, emen uwôŋge ré li elê subu naɲ geserê jii aɲ kurôŋ wo dami li ɓiɲé sa ira kêm. ");
INSERT INTO kqp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hen iyôŋ hari kôba Emen jé Eli uɲé yébé bay ka hen né kwôy, niɲba, ôbi jéri ligi mamne to pôni to mô Sérêpta, emê iyére to Sidôn a hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Menba, ɓiɲé kaɲ bay *terbare na kwône sa Israyêl bô wulê wo ôbi kibi Emen Elijé a, niɲba, kwôni pôn perêrji a hen kôba berare ré, niɲba, na Nama wo Siri hen a Elijé ré berari ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kiriɲa bay toy kwôlê bi wo hen iyôŋ na, bay kêm bô iyéy daɲare bôrji tarji. ");
INSERT INTO kqp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Menba, bay hena naɲ bô tarê ɓu Jésu siɲ naɲ ɗi nô wolé sa ira aɲ. Bay ôriɲ naɲ ɗi kwôy ta sa keram wo bay na ɗiɲ tô sa iyére toji ya hen bi ciré nôgêri kuré aɲ tôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Niɲba, ôbi wuɲ perêrji aɲ ô erê wori. ");
INSERT INTO kqp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jésu ô Kapêrnayôm a to na iyére to ɗaŋgi sa terare to Galilé. Ôbi geliɲ ɓiɲé are naɲ sa sa merê ta. ");
INSERT INTO kqp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓiɲé ka mô ya toy kwôlê kibri a hen na, tiniji ge kay sa derê kwôlê wori bi wo hen, wôsa ôbi iyêl mega kwôni wo ôriɲ naɲ tôô iyôŋ men, naɲ néé iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bô iyéy daɲare hende to hen na, gawra wo pôni wo tunu to habiɲ yi bôri a hen mô ya. Ôbi kôl naɲ tôri to dami kaŋ a ta kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Wuge! ju gey na mi yirni a ba, Jésu wo Najarêt? Ju era na wô mênêni ba? En hôn ju na i ba, ju na kwôni wo yi naɲ jeŋgêri gay wo Emen a jori.» ");
INSERT INTO kqp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jésu ône kôl iyôŋ ba: «Wôm tôŋ aɲ mu séɲ bô gawra bi wo hen a.» Tunu to habiɲ hende to hen dô gawra na ku tôŋ perêrji a aɲ séɲ bôri a niɲba, liri ani ka habiɲ né. ");
INSERT INTO kqp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tini ɓiɲé kêm ge kay aɲ bay kôliɲ perêrji a kôl iyôŋ ba: «Kwôlo na ba, na kwo yôŋ sôŋ ba? Ôbi ône tunu to habiɲ naɲ néé menba, hende séɲ a men.» ");
INSERT INTO kqp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Menba, hini emê wori ôm naɲ kiriɲ kiriɲ kêm gôriɲ sa iyére to méér Kapêrnayôm ta hen. ");
INSERT INTO kqp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jésu hena bô iyéy daɲare a era iyé Simô a. Yi mari Simô uwoy damaŋ aɲ hende yi tôŋ menba, bay uwôli ré bô tu ɲa tore men. ");
INSERT INTO kqp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ôbi deŋge sara aɲ ône yi uwoyé bi wo hen, menba, hende berare aɲ hena kerêd li aŋgaɲ emê biji. ");
INSERT INTO kqp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kiriɲa tare kuriɲ niɲ menba, ɓiɲé kêm ka ôriɲ naɲ bay ômɲare to gay gay iyére toji a hen na, bay eraɲ naɲ ci biri. Ôbi uwôl kôbri sarji a aɲ berareji. ");
INSERT INTO kqp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tunu to habiɲ séɲ bô ɓiɲé kwône aɲ kiriɲa bay séɲ bô ɓiɲé hen iyôŋ menba, bay kôl kaŋ a ta iyôŋ ba: «Ju na Kema Emen.» Niɲba, Jésu ôneji bi bay ré wôm tôŋ, wôsa bay hôn wo ôbi ré na *Krist kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kiriɲa kiriɲ wôl menba, Jésu si ô wolé derô gwôlê. Kwônê ɓiɲé wogeri aɲ kiriɲa bay uwôɲni niɲ menba, bay gey bi ôbi ré ɗebu naɲ ci wô wo ôbi ma ré erê aɲê sôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Niɲba, ôbi kôlji iyôŋ ba: «Yi gengiɲ san bi ené ô ulê béré Kwôlo Dôri wo *emê iyére to Emen sa iyére to ɗaŋgi a wôsa na wô bi wo hen a, Emen né joon hen.» ");
INSERT INTO kqp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aɲ ôbi ô ulê béré bô iyéy daɲare a sa terare to Judé. ");
INSERT INTO kqp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wulê wo pôni kiriɲa Jésu ɗibiɲ kibi cér wo dami wo Génésarêt a menba, ɓiɲé nôgeriɲ yirji si ligiri wô toyiɲ kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Menba, ôbi gel bato wôô yi kibi cér wo dami bi wo hen na. Bay uré ka li jé bô a hen herbe tôŋ wô ɲanê bura toji. ");
INSERT INTO kqp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bato bi wo wôô hen na, kwo pôni na kwo Simô. Jésu ɗay mô bô aɲ kôli ôbi ré ôriɲ naɲ ɗi dê iyôŋ si bô cér. Menba, ôbi mô tôŋ bô bato bi wo hen a aɲ geliɲ kwônê ɓiɲé Kwôlo Dôri. ");
INSERT INTO kqp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kiriɲa ôbi dôriɲ kwônê ɓiɲé kwôlo Emen kô niɲ na, ôbi kôliɲ Simô iyôŋ ba: «Ôriɲ naɲ bato dê iyôŋ a bô ɗogé cér a aɲ ken bi bura toŋge bô kam a uriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simô uwôli sara iyôŋ ba: «*Rabi, nini ur kwôy kiriɲ wôl sarni a aɲ nini ɓu ani ré niɲba, na jôbi a kelê hen na, na hô bê bura kam a gelé sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kiriɲa bay bi bura kam a menba, bay pô kuyê wôn ɓerêj aɲ yêgerê bura toji hende to hen. ");
INSERT INTO kqp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bay liɲ megêrji ka bô bato wo pôni a hen kôbriji ré era sa li naɲ ci men. Bay pô kuyê wôn bato bi wo wôô hen ɓerêj ɓerêj aɲ li wo bato ɗa dermiɲ. ");
INSERT INTO kqp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kiriɲa Simô Piyêr gel hen iyôŋ na, ôbi kuriɲ tôŋ cubu gubari tumô Jésu a aɲ kôl iyôŋ ba: «Kelma, dô tôm aɲ yen a wôsa ena ôbi têriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ôbi kôl hen iyôŋ wôsa bay naɲ megêri tiniji ge kay aɲ harê liji sa uré woɲ geɲê ka bay ur a hen. ");
INSERT INTO kqp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Si *Jak naɲ Ja kam Jébédé kaɲ megêri bay uré hen kôba, tiniji ge kay aɲ harê liji men. Menba, Jésu kôliɲ Simô iyôŋ ba: «Hare ré wôsa ayiɲ tôri kemnêŋ na, na gawrê a jeré uré niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bay heraɲ naɲ bato sa haarê tôŋ kibi cér men, bay ɗi aŋgaji kêm aɲ a men aɲ ôrji tô Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wulê wo pôni kiriɲa Jésu ô sa iyére to ɗaŋgi menba, gawra wo pôni wo *terbare elemné yiri kêm so. Kiriɲa ôbi gel Jésu menba, bôy meremne tumôri a aɲ uwôli kôl iyôŋ ba: «Kelma, hena jeré gey ba, já beraren.» ");
INSERT INTO kqp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jésu jé kôbri hebiɲni aɲ kôl iyôŋ ba: «Ew, en gey bi terbare tom hende to hen ré dôriɲ sam a.» Kiriɲ bay ka hen na, terbare naɲ yiri a. ");
INSERT INTO kqp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jésu kôli iyôŋ ba: «Kôliɲ kwôni ré pa pa. Niɲba, ô ju ô gelé yem tumô ôbi bê kwôbe a aɲ ju li sarga naɲ tôô to *Moyis na ay hen aɲ bi bay ré gel wo jeré na kwo séli tumô Emen a.» ");
INSERT INTO kqp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bay kôl kwôli Jésu naɲ kiriɲ kiriɲ men, ɓiɲé kwône era wô toyé kwôlê wori men, ka era bi ôbi ré berareji men. ");
INSERT INTO kqp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Niɲba, ôbi ba, dô yiri wolé kwôy kwôy derô gwôlê aɲ uwôl Emen. ");
INSERT INTO kqp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wulê wo pôni Jésu mô wô geliɲ ɓiɲé are menba, *Parisiɲêɲê naɲ *bay derê tô tôô to Emen kôba mô ya men. Bay hena sa iyé Galilé a kêm men, sa iyé Judé a kêm naɲ sa iyé Jérusalêm a kêm a men. Aɲ néé wo Kelma baa naɲ ɗi aɲ ôbi berare ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɓiɲé ka pôni aya gawra sa jaare a soɲ, na gawra woɲ ôbi merayê, bay woge ciré siɲ naɲ ɗi kiriɲ ka Jésu môriɲ ya hen aɲ uwôli tumôri a. ");
INSERT INTO kqp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Niɲba, bay uwoɲ geré ré sa kibi kwônê ɓiɲé. Bay ɗayiɲ naɲ ɗi ta sa ira aɲ kergeji sa iyére hende to hen aɲ herbiɲni naɲ jaare tori hende hen ɗéɲ tumô Jésu a kiriɲ ka ôbi môriɲ ya hen. ");
INSERT INTO kqp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kiriɲa Jésu gel wo bay bi bôrji sari a hen iyôŋ menba, ôbi kôl iyôŋ ba: «Melaɲnen, têriɲ tom dôriɲ sam a.» ");
INSERT INTO kqp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bay derê tô tôô to Emen naɲ Parisiɲêɲê erem bôrji a kôl iyôŋ ba: «Na i bi a tiiré Emen hen iyôŋ ba? Hena ré na Emen mera ré ba, i wo ɗaŋgi a na ôbi derê têriɲ sa gawra ba?» ");
INSERT INTO kqp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jésu hôn ermé woji menba, uwôlji sara iyôŋ ba: «Wô mi a kené erem kwôlo hen iyôŋ bôrŋge a ba? ");
INSERT INTO kqp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kelê iyôŋ ba: ‹Têriɲ tom dôriɲ sam a› a derê kelê lew, laba kelê ‹Hena ta ju ô› a derê kelê lew ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Haw hen ka henê wo nôbi *Kema Gawra ené ôriɲ naɲ néé sa terare a nà wô dôriɲ têriɲ sa ɓiɲé.» Menba, ôbi kôliɲ ôbi merayê na iyôŋ ba: «En kôlem, hena ta ay jaare tom ôriɲ iɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kiriɲ bay ka hen na, ôbi hena tu ɓiɲé kêm aɲ ay jaare tori ôriɲ iɲ aɲ ayiɲ kibi Emen. ");
INSERT INTO kqp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓiɲé kêm tiniji ge kay. Menba, bay heram Emen naɲ harê aɲ bay ɲamniɲ kôl iyôŋ ba: «Naa gel aŋgaɲ geɲê kemnêŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cêgeri wori menba, Jésu si ô menba, gel gawra wo pôni wo bay uwôgeri Lébi ôbi eŋgé wôgê hen mô kini eŋgé wôgê wori a. Menba, Jésu kôli iyôŋ ba: «Era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Menba, ôbi ɗéɲ aŋgari kêm aɲ hena ô tôri a. ");
INSERT INTO kqp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ôbi li emê wo mêy uwôgiɲ Jésu iyére tori a men, *bay eŋgé wôgê kêm men, ɓiɲé ka ɗaŋgi kôba sa ômji are naɲ ci a men. ");
INSERT INTO kqp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Menba, Parisiɲêɲê naɲ bay derê tô tôô to Emen kaji ɲamniɲ aɲ kôliɲ bay tô Jésu iyôŋ ba: «Wô mi a kené ôm men, yi men naɲ bay eŋgé wôgê men, bay têriɲ men ba?» ");
INSERT INTO kqp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Menba, Jésu kôlji iyôŋ ba: «Na ɓiɲé ka berari a geyé dôktôr ré, niɲba, na bay ômɲare ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","En era na wô uwôgê ɓiɲé ka bô yirji môɲ bay lê aŋgaɲ derô hen né, niɲba, en era na wô bay têriɲ aɲ bi bay ré ɗi tô lê têriɲ ba.» ");
INSERT INTO kqp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Parisiɲêɲê naɲ bay derê tô tôô to Emen kôliɲ Jésu iyôŋ ba: «Bay tô Ja naɲ kamaŋ kani jôriɲ bôrji kurôŋ men, uwôliji Emen a men ta ta niɲba, bay tôm jôbi ba ômji men yiji men.» ");
INSERT INTO kqp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jésu kôlji iyôŋ ba: «Ɓiɲé ka era kini kurô hen ba ka ɗé bi bay ré jôriɲ bôrji kurôŋ kiriɲa ôbi iyéy kurô ba ya naɲ ci tô hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wulê wo bay a derê ôbi kurô perêrji a aɲ hen na, na wulê bi wo hen a bay ré jôriɲ bôrji kurôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jésu kôlji gwosoy kwôlo pôni kôl iyôŋ ba: «Sa pôn kwôni yêge kibi bargay ka kôrbi wô uwôliɲ tu ka ôli ba? Hena ré na iyôŋ na, bargay ka kôrbi hen yêgiɲ men, kibriji wo kôrbi bi wo yêgiɲ hen kôba a biɲ naɲ ka ôli hen né a men. ");
INSERT INTO kqp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Men, sa pôn kwôni bêêrê care to kôrbi bô gwolé woɲ ariɲ wo ôli a ba? Hena ré na iyôŋ ba, care to kôrbi hende to hen a anê gwolé wo ôli bi wo hen aɲ care a uwôsiɲ men, gwolé bi kôba a mêniɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iyôŋ ba, bi care to kôrbi biɲ bô gwolé wo kôrbi a men. ");
INSERT INTO kqp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kwôni wo yi care to ôli hende to hen na, gey to kôrbi hen né niɲ, wôsa ôbi erem mega wo care to ôli hen a ré na to dôri ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sa to pôni a na, na sa *sa merê ta menba, Jésu ay geré si bô kaw menba, bay tôri pôy sa kaw na aɲ wuray ôm. ");
INSERT INTO kqp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Menba, *Parisiɲêɲê ka pôni kôl iyôŋ ba: «Wô mi a kené li aŋga tôô to *Moyis jô lê naɲ sa merê ta hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Menba, Jésu uwôlji sara iyôŋ ba: «Ken dêŋse kwôli aŋga kelma Dabid na li kiriɲa kurôŋ na liji naɲ ɓiɲé kari hen né ba? ");
INSERT INTO kqp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ôbi na si bô *iyéy Emen a aɲ pô mapa wo bay tibiɲ Emen hen, ôm men, biɲ ɓiɲé kari ôm men. Mapa bi wo hen na, kwôni wo ɗaŋgi wo a emê ba naɲ, na bay bê kwôbe a na bay emêri mera.» ");
INSERT INTO kqp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Menba, Jésu kôlji iyôŋ ba: «Nôbi *Kema Gawra a na Kelma sa sa merê ta.» ");
INSERT INTO kqp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sa sa merê ta wo ɗaŋgi Jésu ô bô *iyéy daɲare a aɲ geliɲ ɓiɲé are, kiriɲ bay ka hen na, gawra wo kôbri woɲ gusurô ma mô ya men. ");
INSERT INTO kqp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Bay derê tô tôô to Emen naɲ Parisiɲêɲê bô ciré gelé na ba Jésu ré berarêri naɲ sa merê ta ba ciré ɓeriɲ tô kôbri aɲ uwôliɲ kwôlê sari a. ");
INSERT INTO kqp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Niɲba, Jésu hôn ermé woji menba, ôbi kôliɲ ôbi kôbi ma bi wo hen iyôŋ ba: «Hena ta ju era sa ɗebe derôre a na.» Menba, ôbi hena ɗebe ta. ");
INSERT INTO kqp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Menba, Jésu kôlji iyôŋ ba: «Na eŋgeréŋge kwôlê pôn: Tôô tona gey bi kwôni ré li derê laba li habrê naɲ sa merê ta a ba? Men, ré gôliɲ naɲ gawra réba ré mêêni naɲ sa sa merê ta a ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ôbi bôrji mériɲ menba, kôliɲ ôbi kôbi hayê bi wo hen iyôŋ ba: «Jé kôm.» Ôbi li mega bi wo Jésu kôli hen iyôŋ menba, kôbri hô dô hôriɲ. ");
INSERT INTO kqp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Menba, tu Parisiɲêɲê naɲ bay derê tô tôô to Emen sêêrê sari a aɲ bay ɲamniɲ kwôli aŋga ciré liɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sa hende to hen na, Jésu ô wulê sa keram a wô uwôlê Emen kwôy kiriɲ wôl sari a. ");
INSERT INTO kqp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kiriɲa kiriɲ wôl menba, ôbi uwôge bay tôri aɲ tô môj kibi wôô perêrji a aɲ uwôgeji bay jé. ");
INSERT INTO kqp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simô ba ôbi uwôgeri Piyêr, naɲ yêni André, Jak, Ja, Pilip, Bartélémi, ");
INSERT INTO kqp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyé, Tomas, *Jak kema Alpé, Simô woɲ kema iyére hen men, ");
INSERT INTO kqp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud kema Jak men naɲ Judas Iskariyôt wo a sa ayê sa Jésu hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jésu herbo naɲ bay tôri ka môj kibi wôô hen sa keram a tôŋ aɲ ɗebiɲ naɲ ci tôŋ kiriɲ ka beray a naɲ kwônê bay tôri ka ba hen men, kwônê ɓiɲé ka Judé men, ka Jérusalêm a men, ka hena kibi cér wo Tir naɲ kwo Sidôn a a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bay era wô toyé kwôlê wori men, bi ôbi ré berareji men, ɓiɲé ka tunu to habiɲ bôrji a kôba, ôbi berareji men. ");
INSERT INTO kqp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓiɲé kêm woge bi ciré heberi wôsa néé wo ôbi ôriɲ yiri a hen si aɲ berareji kêm. ");
INSERT INTO kqp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jésu ay tiri bôriɲ bay tôri aɲ kôl iyôŋ ba: «Kenbay kaɲ bay nimré, yi derê yi wô sarŋge, wôsa *emê iyére to Emen yi wô sarŋge ");
INSERT INTO kqp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","kenbay ka kurôŋ lêŋge haw hen, yi derê yi wô sarŋge, wôsa kena uyirê, kenbay ka ken sôm haw hen, yi derê yi wô sarŋge, wôsa ka merê bô yi derê a.» ");
INSERT INTO kqp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Yi derê yi wô sarŋge, kiriɲa ɓiɲé derêŋge men, kaɲêŋge men, tiréŋge men, uwôgerê heneŋge wo habiɲ a men, wô san nôbi Kema Gawra. ");
INSERT INTO kqp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lêŋge yi derê wulê bi wo hen men, ken neŋréré naɲ yi derê a men, wôsa sa kôbi wo dami yi derômaraŋ a ya, wôsa na hen iyôŋ a môɲêrji na ré liɲ bay kibi Emen. ");
INSERT INTO kqp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Niɲba, kenbay kaɲ bay uɲé na, bô emê yi wô sarŋge, wôsa haw hen ken uwôɲ bô jalê woŋge niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kenbay ka ken uyê haw hen na, bô emê yi wô sarŋge, wôsa kurôŋ a lêŋge tôre to cêgê, kenbay ka ken ayrê haw hen, bô emê yi wô sarŋge, wôsa ka merê bô tu ɲa a men, ka sômnê men.» ");
INSERT INTO kqp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Kenbay ka ɓiɲé kêm dô kwôleŋge wo dôri hen na, tu ɲa yi wô sarŋge, wôsa na hen iyôŋ a môɲêrji na ré li naɲ ɓiɲé ka na li yirji môɲ ciré bay kibi Emen men hen.» ");
INSERT INTO kqp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kenbay ka ken mô toy kwôlê keben a hen na, en kelêŋge peréŋge bay bareŋge men, lêŋge derê naɲ ka derêŋge hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Terêŋge kebreŋge sa ka tômêŋge hen men, uwôlêŋge Emen wô sa ka lêŋge habiɲ hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kwo di tô mam ba, ju hô bul kwo si hen biri a men, kwo ay bargay kam kaɲ kabrêm ba, ju jôri kaɲ kelanê né men, ");
INSERT INTO kqp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","kwo uwôlem are ba, ju biri men, kwo pô aŋgam ereŋ ba, ju hô eŋgereri ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aŋga ken gey bi megêrŋge ré li béŋge hen na, kenbay kôba, ken li hen iyôŋ naɲ ci men.» ");
INSERT INTO kqp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Hena kené pur na ka peréŋge ba, ɓiɲé a kelê kené li derê na iyeŋ ba? Wôsa bay lê têriɲ kôba, pur na ka pirji men. ");
INSERT INTO kqp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hena kené li derê naɲ ka li dô naɲ ken ba, ɓiɲé a kelê kené li derê na iyeŋ ba? Wôsa bay lê têriɲ kôba, li na hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hena kené gwôyiɲ na ka ken hôn wo bay ré herê têbêŋge hôriɲ ta ba, ɓiɲé a kelê kené li derê na iyeŋ ba? Wôsa bay lê têriɲ kôba, gwôyiɲ na bay lê têriɲ ka a herê têbêji hôriɲ hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Niɲba, kenbay ba, ken pur bay bareŋge men, lêŋge derê naɲ ci men, gwôyiɲge aɲ bi bôrŋge wo kené uɲé hôriɲ né. Hen iyôŋ na, aŋgaɲ têbê sa kôbreŋge a mê men, ka yiɲ kam Emen wo ta men. Wôsa ôbi li derê naɲ bay bô hendé men, naɲ bay bô habrê a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Berêŋge tu ɲa to ɓiɲé mega Ibareŋge Emen bôriɲ hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Jerêŋge kwôlê sa megêrŋge a ré menba, Emen kôba, a jerê kwôlê sarŋge a ré men, ken dô kwôlê sa kwôni a ba, Emen a derê kwôlê sarŋge a men, ken ɗi bôrŋge jal sa megêrŋge a ba, Emen kôba, a ɗé bôri jalê sarŋge a men. ");
INSERT INTO kqp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ken biɲ ɓiɲé are ba, bay a hô béŋge men. Bay a tôŋgê men, tôbê dema a hô béŋge wôsa gway wo ken ay gengiɲ are bi hen a, Emen né gengiɲ béŋge hôriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jésu hô kôlji naɲ gwosore kôl iyôŋ ba: «Ôbi tu tiɲ a ɓeré jemna biɲ megari ôbi tu tiɲ ba? Hena ré na iyôŋ ba, bay wôô kêm a heriɲji bô iyom a ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ôbi tô kwôni na, a gôliɲ dami wori ré niɲba, hena ôbi ré ɗi tiri dô tô aŋga ôbi geli hen na, ôbi a yé môɲ ôbi sari iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Wô mi a jeré ô wô berê kalmê ka dê ka yi tu yênem a hen ba? A yibré wo dami ka yi tum jôbi a hen ba, ju gel ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wô mi a jeré kôliɲ yênem: ‹Yênen, ɗi jan na derê kalmê ka dê ka yi tum a hen aɲ›, aɲ jôbi ba, ju gel yibré wo dami wo yi tum a hen né ba? Jôbi woɲ ôbi kelê kwôlê kem wôô wôô hen, dô yibré wo dami wo yi tum hen aɲ dema jeré gelé kiriɲ sélé wô dôriɲ ka yi tu yênem a hen tô.» ");
INSERT INTO kqp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Gurô wo dôri na, yêri wo habiɲ ba naɲ men, kwo habiɲ wo yêri dô ba naɲ men. ");
INSERT INTO kqp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gurô wo yôŋ yôŋ ba, naɲ yêri yêri ɗiba kwôni a karê tôgôre sa cébriɲ a ré men, kwôni a karê yê tiɲaɗor sa gariyaŋ a ré men. ");
INSERT INTO kqp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gawra woɲ ôbi lê derê na, lê derê wori bi wo hen hena na bôri a men, ôbi habrê kôba, habrê wori bi wo hen hena na bôri a men. Wôsa na aŋga wôn bô gawra dema ré si kibri a tô.» ");
INSERT INTO kqp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Wô mi a kené uwôgen ‹Kelma, Kelma› menba, ken li aŋga en kelêŋge kené li hen né ba? ");
INSERT INTO kqp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kwôni wo era legen a aɲ toy kwôlê wuɲê men, liɲ ariri a men na, na geléŋge séé ôbi geliɲ na naɲ i ba? ");
INSERT INTO kqp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ôbi yi mega gawra woɲ ôbi ɗé iyére iyôŋ: Ôbi pi iyom ɗoge aɲ ɗi tôre sa keram a kam kaɲ biyê ka ge naɲ néérji hen kôba, lere ani ré wôsa tôre ɗiɲ dô. ");
INSERT INTO kqp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Niɲba, kwo toy aɲ liɲ ariri ré na, geliɲ naɲ gawra wo ɗi iyére tori dô ré aɲ ɗi na sa hal a iyôŋ. Kam kaɲ biyê ge naɲ néérji menba, tere aɲ, aɲ ani kare kani pôn iyôŋ kôba, ba ta ré.» ");
INSERT INTO kqp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kiriɲa Jésu dôriɲ ɓiɲé kwôlê kô niɲ menba, ôbi ô Kapêrnayôm a. ");
INSERT INTO kqp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ya hende to hen na, dami wo asgar kaɲ Rômêɲê ka arew hen, mana wori ômiɲ tu temare a men, na lema wo ôbi geyri gaɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ôbi toy kwôli Jésu menba, jé surɲê kaɲ Jubɲê yiri a ré ô uwôli bi ré era sa berare mana wori bi wo hen biri men. ");
INSERT INTO kqp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiriɲa bay sa ligi Jésu a menba, bay maseri aɲ kôli iyôŋ ba: «Ôbi dé wo jeré li aŋga ôbi gey hen biri. ");
INSERT INTO kqp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wôsa ôbi geyéna nabay kaɲ Jubɲê men, ôbi a ɗé *iyéy daɲare hen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jésu hena ô naɲ ci. Kiriɲa bay ba ɗa naɲ iyére menba, dami wo asgarɲê bi wo hen jé milɲéri ô kôliɲ Jésu iyôŋ ba: «Kelma, merên yem iyôŋ né, wôsa en nêm wo jeré uwôl têm kibi iyére tiɲê ré. ");
INSERT INTO kqp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na ôbi á, ené nêm erê naɲ yen ô uɲem né hen. Ay tom menba, mana wuɲê a berarê mera. ");
INSERT INTO kqp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nôbi bay san ya men, ena ôbi sa asgarɲê ka ba hen men. Aɲ hena ené kôliɲ kwo pôni iyôŋ ba: ‹Ô› ba, ôbi ô men, hena ené kôli ‹Era› ba, ôbi era men, en kôliɲ mana wuɲê ‹Li aŋga na› ba, ôbi li men, ‹Li ka hen› ba, ôbi li a men.» ");
INSERT INTO kqp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kiriɲa Jésu toy kwôlo ôbi kôl hen menba, yiri dôri sari a aɲ ôbi bul uɲé kwônê ɓiɲé ka ô tôri a hen aɲ kôl iyôŋ ba: «En kelêŋge sa iyé *Israyêl kôba, en uwôɲ kwôni wo ayê bôô wori yi môɲ kwo gawra wo na ba, naɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiriɲa bay jé heraji uwo menba, bay uwôɲ mana wori na berare niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Menba, Jésu hena Kapêrnayôm ô sa iyére to bay uwôgere Nên hen. Bay tôri naɲ kwônê ɓiɲé ôrji naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kiriɲa bay ba ɗa naɲ iyére menba, bay uwôɲ ɓiɲé ka ay temare ôriɲ ciré erê emé. Kema mana bi wo ma hen na, na pôn nêŋ hari kôbi yori a. Hende na mamne. Ɓiɲé kwône bure ôriɲ sa kamɲê. ");
INSERT INTO kqp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kiriɲa Kelma bôre menba, ture liri ɲa menba, ôbi kôle iyôŋ ba: «Sôm né.» ");
INSERT INTO kqp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ôbi uso ɗa aɲ hebe jaare to bay ayiɲ temare hen, ɓiɲé bay ka ay temare hen ɗebe tôŋ menba, ôbi kôl iyôŋ ba: «Kema mana, en kôlem hena ta.» ");
INSERT INTO kqp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Menba, ôbi temare bi wo hen hena mô ta aɲ iyêl kwôlê. Menba, Jésu ɓiri biɲ yori. ");
INSERT INTO kqp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓiɲé kêm tiniji ge kay men, harê liji a men aɲ bay ay kibi Emen kôl iyôŋ ba: «*Ôbi kibi Emen wo dami hena perêrna men, Emen uwôl tiri sa gawrê kari a men.» ");
INSERT INTO kqp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kwôlo bay kôl gengiɲ sa Jésu hen na, ôm naɲ kiriɲ kiriɲ sa iyé Judé men, sa iyére to kwa kwa hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bay tô Ja ô dôriɲ ôbi iyére toji kwôli are bay ka kêm hen menba, ôbi uwôge bay tôri wôô. ");
INSERT INTO kqp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aɲ jéji ligi Kelma eŋgeriri iyôŋ ba: «Jôbi a na kwo a era hen bi, laba kwo nini mô gemni hen ba ya tô ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bay jé bay ka hen sa biɲ ligi Jésu aɲ kôli iyôŋ ba: «Ja ôbi lê batêm a joni yem a bi niné eŋgerem iyôŋ ba, jeré na kwo ré era hen bi, laba kwo niné mô gemni hen ré ba ya tô ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kiriɲ bay ka hen na, Jésu berare bay ômɲare kwône men, ɓiɲé ka ômɲare to gay gay liji hen men, ka tunu to habiɲ bôrji a hen men, bay tu tiɲ kwône gel kiriɲ dô a men. ");
INSERT INTO kqp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Menba, ôbi uwôliɲ bay jé bay ka hen sara iyôŋ ba: «Herêŋge ken ô kôliɲ Ja kwôli aŋga ken toy men, ka ken gel men hen, bay tu tiɲ gel kiriɲ men, bay moré ô ta dô men, bay *terbare berare men, meŋɲê toy kwôlê men, ɓiɲé ka ma béér men, béré Kwôlo Dôri uwôliɲ biɲ bay nimré a men. ");
INSERT INTO kqp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yi derê yi wô sa kwôni wo ɗi ayê bôô wori aɲ né wô san.» ");
INSERT INTO kqp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kiriɲa bay jé ka Ja hôrji niɲ menba, Jésu kôliɲ ɓiɲé kwôli iyôŋ ba: «Na ken ô gelé na mi derô gwôlê hen ba? Gusura wo kal yebageri hen laba, ");
INSERT INTO kqp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ken ô gelé na mi ba? Gawra wo tôbe bargay ka dôri laba? Ɓiɲé ka tôbe bargay ka dôri aɲ mô bô derê na, bay mô na iyé kilmé a ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Niɲba, na mi a kené ô gelé na mi ɗi ba? Ken ô gelé na ôbi kibi Emen wôni ba? Na tu kwôlê a ené ena kelêŋge hen, na ôbi kibi Emen bi, aɲ ôbi gôliɲ ôbi kibi Emen aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Na wô sari ôbi a, na ré liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Toy, en jé mana wuɲê tumôm a bi ré ɲanê geré wom.› ");
INSERT INTO kqp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","En kelêŋge perê gawrê ka yébé a yêji hen na, en gel kwôni wo a damɲê môɲ Ja iyôŋ ba naɲ, niɲba, kwo bay bôri môɲ ani ré iyôŋ bô *emê iyére to Emen a hen na, na kwo dami ɗêri.» ");
INSERT INTO kqp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kiriɲa ɓiɲé kêm naɲ *bay eŋgé wôgê toy kwôlo Jésu kôl hen menba, bay hôn wo Emen ré na kwôni woɲ derôre aɲ bay biɲ Ja liji batêm. ");
INSERT INTO kqp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Niɲba, *Parisiɲêɲê naɲ *bay derê tô tôô to Emen kaɲji aŋga Emen genge wô sarji hen aɲ kaɲiɲ bi Ja ré liji batêm. ");
INSERT INTO kqp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jésu hô kôlji iyôŋ ba: «Ɓiɲé bay ka haw hen, na ayêji gengiɲ na naɲ i ba, en hôn né. Bay geliɲ naɲ i ba, en hôn né. ");
INSERT INTO kqp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bay yi mega kamrê ka li wôrê tô geré aɲ kôliɲ yirji iyôŋ ba: ‹Nini ibéŋge têgê menba, ken wôô sara ré men, nini kebe kurôŋ temare menba, ken sôm sara ré a men.› ");
INSERT INTO kqp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wôsa kiriɲa Ja ôbi lê batêm saɲ na, ôbi ôm mapa ré men, yi care ré a men, menba, ken kôl iyôŋ ba: ‹Tunu to habiɲ yi bôri a.› ");
INSERT INTO kqp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nôbi *Kema Gawra en sa aɲ ôm men, yi men, menba, ken kôl iyôŋ ba: ‹Geléŋge ôbi lamê naɲ ôbi kwoyé wo na, ôbi na melaɲ bay eŋgé wôgê naɲ bay têriɲ a men.› ");
INSERT INTO kqp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Niɲba, ɓiɲé ka bi bôrji sa tu melênê wo Emen hen na, bay hôn wo tu melênê bi wo hen ré na kwoɲ derôre.» ");
INSERT INTO kqp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","*Parisiɲê wo pôni uwôge Jésu ré ô emê are naɲ ɗi menba, Jésu gey aɲ ô merê kibi emê a naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kiriɲ bay ka hen na, iyore to pôni to sa iyére hende to hen to bay hône gaɲ wô jé lêre wo habiɲ hen so. Hende toy wo Jésu ré mô ôm are iyé Parisiɲê hen ya. Hende aya ider bô murda wo bay li naɲ *albatre hen. ");
INSERT INTO kqp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hende ɗebu si cêgi Jésu si têri. Hende sôm aɲ ɲôm têri naɲ cémne aɲ mô aɲ naɲ gusiri sare men, ibe aɲ wusu ider bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kiriɲa Parisiɲê bi wo uwôga Jésu hen gel hen iyôŋ menba, ôbi kôl bôri a iyôŋ ba: «Hena gawra wo hen henaŋ ré na ôbi kibi Emen ba, ôbi réé henê wo ré na iyore to yôŋ a ré hebiri hen ba men, ôbi réé henê wo hende ré na hendi têriɲ men.» ");
INSERT INTO kqp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Menba, Jésu kôli iyôŋ ba: «Simô, na kôlem kwôlê pôn.» Menba, Simô kôli iyôŋ ba: «Kelma kôlen.» ");
INSERT INTO kqp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Menba, Jésu kôli iyôŋ ba: «Gawra wo pôni ôriɲ naɲ telare tori sa ɓiɲé wôô, kwo pôni naɲ dubu arew men, kwo pôni naɲ dubu môj men. ");
INSERT INTO kqp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ôbi gel wo bay ôriɲ naɲ ani kaɲ têbêri ré menba, ôbi ɗiji telare hende to hen mera. Perê ɓiɲé bay ka wôô hen na, kwo yôŋ a geyé gawra bi wo hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simô uwôli sara iyôŋ ba: «Na kwo telare tori mê gaɲ hen a geyéri damaŋ.» Menba, Jésu kôli iyôŋ ba: «Ju kôl na tiri.» ");
INSERT INTO kqp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ôbi bul si ligi iyore hende to hen aɲ kôliɲ Simô iyôŋ ba: «Ju gel, iyore hende to hen ba? En era iyére tom a menba, ju bên kam sa tên a ré, niɲba, hende pulen tên naɲ cémne men, mô naɲ gusiri sare a men. ");
INSERT INTO kqp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ju ibe tô man ré hen na, gel wo jeré ɓeren yem a ré, niɲba, kiriɲa hende saɲ yeŋ a ré ibe tên baɲ hen. ");
INSERT INTO kqp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ju bên weŋ san a ré, niɲba, hende bên ider sa tên a. ");
INSERT INTO kqp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","En kôlem, têriɲ tore to kwôni hende to hen dôriɲ sara niɲ, na ôbi a, hende ré puren damaŋ hen. Kwôni wo bay ɗi bôrji jal sa têriɲ tori to dê hen na, ôbi pur dê iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jésu kôliɲ iyore hende to hen iyôŋ ba: «Têriɲ toré dôriɲ sarê.» ");
INSERT INTO kqp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓiɲé ka mô ôm are naɲ ci hen ɲamniɲ kôl iyôŋ ba: «Gawra wo yôŋ a erê kwôy ɗé bôri jalê sa têriɲ to ɓiɲé hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jésu kôliɲ iyore hende to hen iyôŋ ba: «Ayê bôô woré gôliɲ naɲ mu, ô naɲ bô jalê.» ");
INSERT INTO kqp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sem cêgê menba, Jésu ô naɲ sa iyére to dami men, to dê men, wô ulê béré Kwôlo Dôri wo gengiɲ sa *emê iyére to Emen, aɲ bay tôri ka môj kibi wôô hen ô naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yébé ka ôbi dage tunu to habiɲ bôrji a hen men, ka ômɲare to gay gay na liji aɲ ôbi na berareji hen kôba ôrji tôri a men. Perê yébé bay ka hen na, Mari to Magdala to ôbi na dage tunu to habiɲ jurgem bôre a hen kôba, ya men, ");
INSERT INTO kqp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jan tami Suja ôbi berê sa aŋga kelma *Hérôd men, Sujan naɲ yébé ka ɗaŋgi kwône li naɲ Jésu naɲ bay tôri sa aŋga naɲji a hen. ");
INSERT INTO kqp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓiɲé kwônê hena naɲ sa iyére iyére era sa daɲji ligi Jésu a menba, ôbi kôl kwôlê naɲ gwosore kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Sa to pôni gawra wo pôni ô wusé kay cé. Kiriɲa ôbi wuse hen iyôŋ na, ka pôni heriɲ bêŋgê geré menba, tê ɓiɲé ɗiirê men, ciré gôl ôm men. ");
INSERT INTO kqp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka pôni heriɲ perê jerew a, bay si menba, ma lew wôsa bay uwôɲ kiriɲ ka jôbi ré. ");
INSERT INTO kqp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka pôni heriɲ perê gesem a, bay ɗebu naɲ gesem na ɓem haji niɲba, gesem na yêrji duu. ");
INSERT INTO kqp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Niɲba, ka pôni heriɲ terare to dôri aɲ sarji si dô. Sa ka pôni gusiɲniji ô arew.» Menba, Jésu kôl iyôŋ ba: «Kwôni wo mari ya wô toyiɲ kwôlê bi wo hen ba, bi toy.» ");
INSERT INTO kqp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Menba, bay tôri eŋgeriri iyôŋ ba gwosore hende to hen bôre na iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Menba, ôbi kôlji iyôŋ ba: «Kwoŋge kenbay ba Emen béŋge ken hôn aŋga gengiɲ sa emê iyére tori ka yi kini uwôbêrji a hen, niɲba, ka ɗaŋgi ba, a kôliɲji na naɲ gwosore. Na hen iyôŋ a, bay ré bô kiriɲ niɲba, bay gel ani ré men, bay ré toy kwôlê niɲba, ré hôn bôri ré a men hen. ");
INSERT INTO kqp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bô gwosoy kwôlê bi wo hen a na: kaw ba, na kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kaw bay ka hen na, ka heriɲ tô geré hen na, na ɓiɲé ka toy kwôlê bi wo hen menba, Sidan era sa mêne kwôlê bi wo hen aɲ bôrji a wôsa bay ma ré bê bôrji sara aɲ ma ré gôliɲ. ");
INSERT INTO kqp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka heriɲ perê jerew a hen na, na ɓiɲé ka toy kwôlê bi wo hen menba, bi bôrji sara naɲ yi derê niɲba, hanêrji naɲ, bay bi bôrji sara sem iyôŋ niɲba, kiriɲa aŋgaɲ lamê uwoɲji menba, bay ɗéɲ mera. ");
INSERT INTO kqp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka heriɲ perê gesem a hen na, na ɓiɲé ka toy kwôlê bi wo hen niɲba, ermé kwôlê men, kwôli ari uɲé men, yi derê wo tôŋ sa terare a nà liji aɲ bay gese tô ayê bôô woji a ré. ");
INSERT INTO kqp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Niɲba, ka heriɲ kiriɲ ka dôri hen na, na ɓiɲé ka toy kwôlê bi wo hen naɲ bôô wo dôri aɲ ɓeriɲ bôrji iyêre liɲ aŋga dôri.» ");
INSERT INTO kqp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jésu hô eŋgeriji iyôŋ ba: «Kwôni ɗi tare bô lampa aɲ emné baɲa sara réba ɗéré tô kalaŋ a sa pôn ken gel ba? Hena ôbi ré ɗi tare a bô lampa ba, na wô teré ta gurô pal a aɲ bi ɓiɲé ka era ira ba, ré gel peraŋgêre ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wôsa ani ka yi naɲ kini uwôbêrji a ka a ba gelé yirji nô ba, naɲ men, kwôlo ken kôl tô gwôsiɲare a hen na, a hôniɲ men, a yé tu wolé ɗéɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɗéŋge tu melênê sa yerŋge a sa kwôlê wo ken toy a hen. Kwôni wo hôn are ba, Emen a herê biri bi ré hôn ka ɗaŋgi a sara a niɲba, kwo hôn né hen na, ka dê bay ka ôbi hôn aɲ bô mega ré na aŋga ɗiré hôn hen na, Emen a lê aɲ ôbi a henê bay ka ôbi hôn hen ré niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yoo Jésu naɲ yênêri eraji ciré erê ligiri a niɲba, bay nêm erê ɗa yiri a ré wôsa kwône ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bay ô kôli iyôŋ ba: «Yom naɲ yênêm ɗibiji nô hen ya, bay gey gelem.» ");
INSERT INTO kqp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Niɲba, ôbi kôliɲ ɓiɲé iyôŋ ba: «Ɓiɲé ka toy kwôlo Emen aɲ liɲ ariri na, bay a na yon men, yênên men.» ");
INSERT INTO kqp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wulê wo pôni Jésu ɗay bô bato a naɲ bay tôri menba, ôbi kôlji iyôŋ ba: «Na ɗayêŋge tera cér wo dami hen.» Menba, bay ɗay ô. ");
INSERT INTO kqp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kiriɲa bay tôri ô wô jibé bato hen iyôŋ menba, Jésu ba yi kum men. Kiriɲ bay ka hen na, kal wo dami ay tô geré aɲ di kam bê a bô bato a. Aɲ bay mô kibi temare a wôsa bato toji hende to hen ta dermiɲ. ");
INSERT INTO kqp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bay era sa eŋni aɲ kôli iyôŋ ba: «*Rabi, Rabi, naa mêniɲ.» Ôbi eŋgiɲ tô kum a, menba, ône kal naɲ mêw, menba, kiriɲ iyer iyêêr mera. ");
INSERT INTO kqp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Menba, ôbi kôlji iyôŋ ba: «Ayê bôô woŋge na yôŋ niɲ ba?» Kiriɲ bay ka hen na, harê liji men, tini ge kay a men aɲ bay kôl perêrji a kôl iyôŋ ba: «Ôbi na i aɲa kal naɲ mêw kôba, ré biri kwôlê hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bay era sa biɲ kibi cér wo bô emê wo Géraséniɲê si tera naɲ sa terare to Galilé. ");
INSERT INTO kqp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kiriɲa ôbi herbe tôŋ bô bato a menba, gawra wo pôni wo iyére hende to bay herbiɲ ya era ligiri a, na gawra wo tunu to habiɲ bôri a. Aɲ ca yeŋ na, ôbi tôbe bargay ré men, yi bô ira ré a men. Kini yéri na sa kamɲê ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kiriɲa ôbi gel Jésu menba, era sa kuriɲ sa têri a kôl kaŋ a ta kôl iyôŋ ba: «Ju gey mi yen a ba, Jésu Kema Emen wo ta, en uwôlem gelen gusiɲ né.» ");
INSERT INTO kqp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ôbi kôl hen iyôŋ wôsa Jésu ône tunu hende to hen ré si aɲ bô gawra bi wo hen a. Wôsa têê kwône wo tunu hende to hen geliɲ tiri gusiɲ. Bay harêri naɲ gaŋgi musure men, bay uwôli musure têri a men, wô geméri niɲba, ôbi ka musure hende to hen aɲ, aɲ tunu to habiɲ hende to hen tôri ôriɲ derô gwôlê. ");
INSERT INTO kqp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jésu eŋgeri iyôŋ ba: «Henem na i ba?» Menba, ôbi kôli iyôŋ ba: «Henen na kwônê ɓiɲé.» Wôsa tunu to habiɲ kwône mô bôri a. ");
INSERT INTO kqp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Menba, tunu to habiɲ hende to hen uwôliɲ Jésu ré dageji bê a bô iyom wo ɗogi a ré. ");
INSERT INTO kqp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kiriɲ bay ka hen na, gwôsiɲô kwône ômji are ɗibiɲ sa keram a menba, tunu to habiɲ hende to hen uwôliɲ Jésu ré ɗiji ciré sééré bô gwôsiɲô bay ka hen menba, ôbi gey naɲ ci sara. ");
INSERT INTO kqp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tunu hende to hen si bô gawra bi wo hen a aɲ aɲ ôrji bô gwôsiɲô bay ka hen, aɲ li wo bay yêseraji ta sa keram a heriɲji bô cér a aɲ yiji kam maji kêm. ");
INSERT INTO kqp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kiriɲa bay gemé gwôsiɲô gel hen iyôŋ na, bay ge ô kôliɲ ɓiɲé derô ira men, kôliɲ ɓiɲé nono men, kwôli are bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓiɲé guro wô gelé are bay ka hen. Bay sa ligi Jésu a menba, bay gel gawra wo tunu to habiɲ na bôri a hen mô tôŋ tê Jésu a. Ôbi tôbe bargay men, tiri iyer dô a men, menba, harê liji. ");
INSERT INTO kqp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓiɲé ka ré ɗebu ya gel wo tunu hende to hen séɲ bôri a hen na, dôrji kwôli gawra bi wo hen biɲ ka era cêgê hen. ");
INSERT INTO kqp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kiriɲ bay ka hen na, ɓiɲé ka bô emê wo Gêrgéséniɲê uwôliɲ Jésu ré ô aɲ sa iyére toji a wôsa harê liji damaŋ menba, ôbi ɗay bô bato a bul hô Galilé. ");
INSERT INTO kqp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Gawra wo Jésu ré dage tunu to habiɲ bôri a hen si ô eŋgeré Jésu ɗiré erê naɲ ɗi, niɲba, Jésu dageri aɲ kôli iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Hô iɲ aɲ ju ô kôliɲ ɓiɲé kwôli aŋga Emen li naɲ ju.» Menba, ôbi ô aɲ kôliɲ ɓiɲé kêm kwôli aŋga Jésu ré li naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kiriɲa Jésu hera Galilé menba, ɓiɲé kêm jô kwini wôsa bay mô gemni. ");
INSERT INTO kqp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kiriɲ bay ka hen na, Jayrus kelma sa *iyéy daɲare sa. Ôbi cubu gubari tumôri a aɲ uwôli ré era iyére tori a, ");
INSERT INTO kqp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wôsa môɲni to pôn nêŋ to elêre môj kibi wôô hen ômiɲ ta ma. Kiriɲa Jésu ô naɲ ɗi menba, ɓiɲé kwône nôgeriɲ yirji ligiri. ");
INSERT INTO kqp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kiriɲ bay ka hen na, iyore to pôni mô ya, kwôbe ô yere a li elê môj kibi wôô. Hende mêne ari uɲére kêm iyé bay kerbê a, niɲba, kwo pôn wo berare ba naɲ. ");
INSERT INTO kqp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hende era si cêgê aɲ hebe kibi bargay kari, menba, kiriɲ bay ka hen na, kwôbe wo na ô yere a hen na, naɲ aɲ hende berare. ");
INSERT INTO kqp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jésu eŋgere iyôŋ ba: «Na i a heben na ba?» Bay kêm uwôser menba, Piyêr kôli iyôŋ ba: «Kelma, na ɓiɲé ka nôgeriɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Menba, Jésu kôl iyôŋ ba: «Kwôni heben wôsa néé wo en ôriɲ hen kwari dôriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iyore hende to hen bô wo Jésu ré hôn hen iyôŋ na, harê lere aɲ wuré aɲ era sa cubu gubare tumô Jésu a aɲ kôli tu ɓiɲé wô mi a teré heberi ba, men, kwôli berarê wo teré berare peraŋ hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Menba, Jésu kôle iyôŋ ba: «Yêren, ayê bôô woré gôliɲ naɲ mu, ô naɲ bô jalê.» ");
INSERT INTO kqp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kiriɲa Jésu iyêl ba ya tô menba, gawra wo iyé kelma sa iyéy daɲare hen era sa kôli iyôŋ ba: «Môɲnem ma niɲ ɗiba ju dôyrê Rabi ré.» ");
INSERT INTO kqp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kiriɲa Jésu toy hen iyôŋ menba, ôbi kôliɲ kelma ôbi sa iyéy daɲare hende to hen iyôŋ ba: «Hare ré, bi bôm san a mera aɲ môɲnen a béré.» ");
INSERT INTO kqp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kiriɲa ôbi sa biɲ iyé kelma ôbi sa iyéy daɲare hende to hen na, ôbi jôriɲ ɓiɲé erê ira naɲ ɗi niɲba ɗi si Piyêr Ja naɲ Jak men, yo mône naɲ ibare a men a erê naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ɓiɲé kêm sôm men, ɓar men sare a. Menba, Jésu kôl iyôŋ ba: «Sômêŋge ré hende ma ré, niɲba, yi na kum.» ");
INSERT INTO kqp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bay ayrêri wôsa bay hôn wo hende ré ma. ");
INSERT INTO kqp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Niɲba Jésu ɓu kôbre aɲ uwôgere «Môɲnen eŋgiɲ ta.» ");
INSERT INTO kqp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kiriɲ bay ka hen na, tune uwo yere a aɲ hende hena ta. Aɲ Jésu kôlji bay ré buru aŋgaɲ emê. ");
INSERT INTO kqp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Balê mône tiniji ge kay, menba, Jésu kôlji bay ré kôliɲ kwôni ré pa pa. ");
INSERT INTO kqp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jésu day bay tôri ka môj kibi wôô hen aɲ biji néé naɲ damɲare bi bay ré dagiɲ tunu to habiɲ kêm men, ôbi biji bi bay ré berare bay ômɲare a men. ");
INSERT INTO kqp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ôbi jéji ulê béré *emê iyére to Emen men, bi bay ré berare ɓiɲé a men. ");
INSERT INTO kqp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aɲ ôbi kôlji iyôŋ ba: «Ayêŋge ani kani kôbreŋge a ré: kwoore ré men, magela ré men, kwô ré men, gursu ré a men. Perêŋge bargay wôô wôô ré men. ");
INSERT INTO kqp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Iyére to yôŋ yôŋ to ken ô ya aɲa bay ré ɓeréŋge yirji a na, ken mô kiriɲ bay ka hen kwôy ken ôriɲ ta. ");
INSERT INTO kqp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kiriɲ ka yôŋ yôŋ ka ken ô ya aɲa ɓiɲé ré ɓeréŋge yirji a ré na, kiriɲa ken ô ta ba, ken gage beni têrŋge aɲ. Ôbi a na aŋgaɲ gelé ka a ulê kwôlê sarji a.» ");
INSERT INTO kqp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Menba, bay tô Jésu ô naɲ sa iyére iyére uwôliɲ béré Kwôlo Dôri men, berariɲ ɓiɲé naɲ kiriɲ kiriɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","*Hérôd ôbi emê iyére to Galilé toy kwôli are bay ka li are hen kêm niɲba, ôbi hôn aŋgaɲ lê ré. Wôsa ka pôni kôl ré na Ja ré a so perê ɓiɲé ka ma bulo hera hen. ");
INSERT INTO kqp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ka pôni kôl ré na *Eli a ré hera hen men, ka pôni kôl ré na *ôbi kibi Emen wo cay a ré jê sé hen men. ");
INSERT INTO kqp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hérôd kôl iyôŋ ba: «Ja na, nôbi a na bé bi bay na jô sari na, menba, kwôni wo en toy kwôli jé lêri na ba, na i ba?» Menba, ôbi woge ɗiré geléri. ");
INSERT INTO kqp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kiriɲa bay jé ka Jésu bulo hera menba, bay dôriɲ Jésu kwôli aŋga ciré la hen. Ôbi ôriɲ naɲ ci wolé piniji si kwa iyére to bay uwôgere Bêtsayda. ");
INSERT INTO kqp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kiriɲa kwônê ɓiɲé hôn wo bay ré ô si Bêtsayda menba, bay ô tôrji a. Jésu ɓerji a yiri a aɲ dôrji kwôli emê iyére to Emen men, ôbi berare ka ômiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kiriɲ kô niɲ menba, bay tô Jésu ka môj kibi wôô hen eraji ligiri a sa kôli iyôŋ ba: «Kôliɲ ɓiɲé bi bay ré erê sa kam iyére to dê dê hen ô wogé kiriɲ kaɲ yé men, wogeré aŋgaɲ emê a men, wôsa kiriɲ ka nà ná, na derô gwôlê.» ");
INSERT INTO kqp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Niɲba Jésu kôlji iyôŋ ba: «Kenbay ken biji aŋgaɲ emê.» Menba, bay kôli iyôŋ ba: «Nini ôriɲ naɲ mapa bay men, kuyê wôô a men mera. Hena ré na hen iyôŋ ba, niɲa erê kelé a dema ré nêmê kwônê ɓiɲé bay ka hen ɗê?» ");
INSERT INTO kqp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɓiɲé bay ka hen na, na imɲê dubu bay. Jésu kôliɲ bay tôri iyôŋ ba: «Biŋgeji bi bay mô tôŋ naɲ gwogelérji gwogelérji tôre bay bay.» ");
INSERT INTO kqp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bay li mega bi wo ôbi kôlji hen iyôŋ aɲ biji mô tôŋ kêm. ");
INSERT INTO kqp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jésu pô mapa wo bay naɲ kuyê ka wôô hen aɲ bô kiriɲ si derômaraŋ, liɲ Emen dosé wô sa mapa naɲ kuyê bay ka hen aɲ ɓiilê mapa bi wo hen aɲ biɲ bay tôri ré céɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓiɲé bay ka hen ôm uyirê aɲ tôri wo baa na, bay tô Jésu pô gwaɲê môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wulê pôni Jésu ô uwôlê Emen wolé aɲ bay tôri ô naɲ ɗi menba, ôbi eŋgeriji iyôŋ ba: «Ɓiɲé kôl ené na i ba?» ");
INSERT INTO kqp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bay uwôli sara iyôŋ ba: «Ka pôni kôl jeré Ja ôbi lê batêm men, ka pôni jeré na *Eli men, ka pôni jeré ôbi kibi Emen wo cay a jê sé hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ôbi kôlji iyôŋ ba a kenbay ba, ken kôl ené na i ba? Menba, Piyêr kôli iyôŋ ba: «Ju na *Krist, kwo Emen dôri hen.» ");
INSERT INTO kqp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ôbi ay tôô biji bay ré kôliɲ kwôni ré pa pa, ");
INSERT INTO kqp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","aɲ kôlji iyôŋ ba: «Dé wo nôbi *Kema Gawra ené geliɲ gusiɲ damaŋ men, surɲê men, damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen a kaɲen men, bay a deren a men, aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Menba, Jésu uwôge bay tôri kêm aɲ kôlji iyôŋ ba: «Hena kwôni ré gey yé ôbi tôn ba, bi tôrɲê yiri men, bi ay gurô tagelê wori woɲ temare sari a naɲ wulê wulê aɲ era tôn a. ");
INSERT INTO kqp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwôni wo gey gemé yiri ba, a mênêri, niɲba, kwôni wo uwôl yiri aɲ wô san na, a gôliɲ naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hena kwôni ré uwoɲ aŋga sa terare a na kêm, aɲa ré mêne merê tu geɲ wori ba, derêri yôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wôsa hena kwôni ré dii tayre san a men, sa kwôlê wuɲê a men na, nôbi Kema Gawra na déé tayre sari kiriɲa na buloɲ hera naɲ hini emê wuɲê men, kwo Iban men, naɲ kwo *manê ka derômaraŋ a ka yi naɲ jeŋgêrji hen. ");
INSERT INTO kqp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na tu kwôlê a ené ena kelêŋge hen perê ɓiɲé ka nà ná, ka pôni a gelé emê iyére to Emen naɲ tirji dema ré maji tô.» ");
INSERT INTO kqp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wulê marge cêgê menba, Jésu uwôge Piyêr, *Jak naɲ Ja aɲ ôriɲ sa keram wô uwôlê Emen. ");
INSERT INTO kqp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kiriɲa ôbi uwôl Emen hen iyôŋ menba, tiri biliɲ yi gay men, bargay kari kôba, beliɲ bôrê terij men, jeraɲnê a men. ");
INSERT INTO kqp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Menba, gawrê wôô so sa ɗebu iyêl naɲ ɗi. Na si *Moyis naɲ Eli, ");
INSERT INTO kqp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","a soji bô peraŋgê wo derômaraŋ a aɲ iyêlji naɲ ɗi kwôli jé wori wo ôbi ré deré kibri naɲ temare Jérusalêm a hen. ");
INSERT INTO kqp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyêr naɲ megêri hen na, kum layrêji aɲ kiriɲa bay eŋgeɲji tô kum a menba, bay gel peraŋgê wo Jésu naɲ imɲê ka wôô ka ɗebu naɲ ɗi hen. ");
INSERT INTO kqp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kiriɲa ɓiɲé bay ka hen ô ta niɲ menba, Piyêr kôliɲ Jésu iyôŋ ba: «*Rabi dô wo na merêŋge na, na lêŋge iyéy gergé subu pôn tom men, pôn to Moyis men, pôn to Eli a men.» Wôsa ôbi hôn kwôlo ôbi kôl hen né. ");
INSERT INTO kqp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kiriɲa Piyêr iyêl ba ya tô menba, kiriɲ ka geri so sa têlji ta aɲ kiriɲa bay gel wo kiriɲ ka geri bay ka hen têlji ta hen iyôŋ menba, harê liji. ");
INSERT INTO kqp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Menba, tô kwôni ôm bô kiriɲ ka geri bay ka hen kôl iyôŋ ba: «Kwo nà ná, ná Keman. En dôôri, toyéŋge kwôlê kibri a.» ");
INSERT INTO kqp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kiriɲa tô kwôni bi wo hen wôm niɲ menba, bay gel na Jésu a ɗebé pini. Menba, bay wôm cêgêgê aɲ bô wulê bi wo hen na, bay kôliɲ kwôni kwôli aŋga bay gelo hen né. ");
INSERT INTO kqp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kiriɲ wôl pôn cêgê menba, bay herboji tôŋ sa keram a menba, kwônê ɓiɲé era ligi Jésu a. ");
INSERT INTO kqp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Menba, gawra wo pôni perê kwônê ɓiɲé bay ka hen kôl iyôŋ ba: «Rabi, en uwôlem gel keman wo nà ná ôbi a pôn nêŋ hen hari. ");
INSERT INTO kqp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kiriɲ ka pôni a na, tunu to habiɲ henaɲ naɲ ɗi aɲ liri ôbi tô gura men, seŋgalêêri men, wôbre era kibri a men, hende séɲ yiri a lew ré a men. Aɲ kiriɲa hende séɲ menba, ôbi merên tulôg tulôg. ");
INSERT INTO kqp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","En uwôliɲ bay tôm ré dage tunu to habiɲ hende to hen, niɲba, bay nêm né.» ");
INSERT INTO kqp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jésu kôlji iyôŋ ba: «Kenbay ka ayê bôô woŋge naɲ aɲ ken mô wô lê habrê hen na, na merê na wô lê naɲ ken yôd ba? Men, na têê iyeŋ a ené ulê bôn jalê sarŋge a ba? Eraɲ naɲ kemam bi ben na.» ");
INSERT INTO kqp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kiriɲa bay eraɲ naɲ kema bi wo hen biri menba, tunu to habiɲ hende to hen ayri ku terare a aɲ seŋgaliri. Niɲba Jésu ône tunu hende to hen aɲ berare kema bi wo hen aɲ ayri biɲ ibari. ");
INSERT INTO kqp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Menba, ɓiɲé kêm tiniji ge kay sa damɲare to Emen a. Mega wo ɓiɲé kêm tiniji ge kay sa are kêm ka Jésu li a hen menba, ôbi kôliɲ bay tôri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Dôbêŋge marŋge dô ken toyiɲ kwôlo na kelêŋge hen: ‹Bay a ɓeren nôbi Kema Gawra biɲ ɓiɲé.› » ");
INSERT INTO kqp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Niɲba bay hôn bô kwôlo ôbi kôl hen né, wôsa ôbi bi kwôlê bi wo hen yi kini uwôbêri a hen iyôŋ bi bay ré hôn bôri ré. Men, né bay hare eŋgeréri men. ");
INSERT INTO kqp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bay tô Jésu nariɲ na ba, i a ré kwo dami perêrji a ba? ");
INSERT INTO kqp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jésu hôn ermé woji menba, ɓu kema wo dê sa ɗi kwari a ");
INSERT INTO kqp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aɲ kôlji iyôŋ ba: «Kwôni wo ɓu kema wo dê mega kwo na yiri a naɲ henen na, ôbi ɓeren na nôbi yiri a hen men, kwo ɓeren yiri a ba, ɓu na kwo joon hen yiri a hen men. Niɲba henêŋge mega wo kwôni wo na kwo dê perêrŋge a kêm hen na, ôbi a na kwo dami.» ");
INSERT INTO kqp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Menba, Ja kôli iyôŋ ba: «Rabi, nini gel gawra wo pôni dage tunu to habiɲ naɲ henem menba, nini jôri sara, wôsa ôbi na ôbi tôm mega nibay iyôŋ né.» ");
INSERT INTO kqp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Menba, Jésu kôl iyôŋ ba: «Jôreŋgiri ré, wôsa kwôni wo na ôbi bareŋge ré ba, na kwoŋge.» ");
INSERT INTO kqp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kiriɲa wulê wo ôbi a ɗéɲ sa terare ba ɗa menba, Jésu ay geré ré na mi mi kôba ɗiré erê Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ôbi jé ɓiɲé tumôri a. Bay ô menba, biɲ môni iyére to Samari a wô ɓeré sa tê saari. ");
INSERT INTO kqp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Niɲba ɓiɲé ka Samari ɓiri yirji a ré, wôsa ôbi ô na wô erê Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kiriɲa si *Jak naɲ Ja bay tô Jésu gel hen iyôŋ menba, bay kôl iyôŋ ba: «Kelma, ju gey bi niné kôliɲ tare ré hena derômaraŋ a sa uwoyréji aɲ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Menba, Jésu bul uɲéji aɲ nayji damaŋ. Aɲ kôl iyôŋ ba: «Ken hôn tunu to yi bôrŋge a aɲ lêŋge ken kôl kwôlê bi wo hen né. Wôsa nôbi Kema Gawra en era sa terare a nà, ná wô mênê gawrê ré niɲba, ná wô gôliɲ naɲ ci ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kiriɲ bay ka hen na, bay ô sa iyére to ɗaŋgi a. ");
INSERT INTO kqp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kiriɲa bay baɲ geré tô menba, gawra wo pôni era sa kôliɲ Jésu iyôŋ ba: «Kiriɲ ka yôŋ yôŋ ka já erê ya hen na, na erê tôm a.» ");
INSERT INTO kqp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Menba, Jésu kôli iyôŋ ba: «Heŋɲê naɲ iyomniji men, ciré naɲ gwonérji a men, niɲba, nôbi Kema Gawra ba kiriɲ ka na dôbiɲ san ya ba, naɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Men, Jésu hô kôliɲ kwo ɗaŋgi «Era tôn a.» Menba, gawra bi wo hen kôli iyôŋ ba: «Kelma, ɗi jan, ɗén na erê emé iban dem.» ");
INSERT INTO kqp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Menba, Jésu kôli iyôŋ ba: «Ɗi ɓiɲé ka yi môɲ temare iyôŋ hen bi em megare temare aɲ jôbi ju ô ulê béré *emê iyére to Emen.» ");
INSERT INTO kqp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gawra wo ɗaŋgi kôliɲ Jésu iyôŋ ba: «Nôbi en gey erê tôm a Kelma niɲba, ɗén na erê liɲ kamaŋ ka iyére tiɲê dosé dem.» ");
INSERT INTO kqp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jésu kôli iyôŋ ba: «Kwôni wo ɓu tô mire to kelbê yagiɲ aɲa ré bare cêgeri ba, na kwôni wo dô wô jé wo emê iyére to Emen né.» ");
INSERT INTO kqp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cêgeri wori menba, Kelma tô bay tôri ka ɗaŋgi tôre jurgem kibi wôô aɲ jéji wôô wôô tumôri a sa iyére to kêm men, kiriɲ kêm ka ôbi ɗa sé si ya hen. ");
INSERT INTO kqp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aɲ ôbi kôlji iyôŋ ba: «Kaw kaɲ walê mê gaɲ niɲba, bay walêrji dê. Uwôliɲge ôbi iyéy kaw na bi jéɲ naɲ ɓiɲé bô kaw kari a. ");
INSERT INTO kqp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Erêŋge, en jéŋge môɲ kam gamgê iyôŋ perê heŋɲê. ");
INSERT INTO kqp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayêŋge magela gursu tôni ré men, saŋne toɲ bê bargay ré men, garbê ka ɗaŋgi a ré men, ɗebéŋge tôŋ geré wô liɲ ɓiɲé dosé ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bô iyére to yôŋ yôŋ to ken ô ya ba, ken kôliɲ ɓiɲé ka mô bô iyére hende to hen iyôŋ ba: ‹Bô jalê baa naɲ ken.› ");
INSERT INTO kqp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hena kwôni woɲ ôbi geyé bôô jalê wôni ré bô iyére hende to hen a ya na, terê kibi woŋge bi wo hen a baa naɲ ɗi, a hena ôbi bôô jalê wôni ré naɲ ba terê kibi woŋge bi wo hen a hera sarŋge a. ");
INSERT INTO kqp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bô iyére to yôŋ yôŋ to ken ô ya ba, merêŋge ya hende to hen. Emêŋge men, ken yi men aŋgaɲ kergare ka bay lêŋge hen wôsa kwôni wo li jé ba, nêm uɲé sa kôbri. Ɗiba ken ô naɲ kibi iyére iyére ré. ");
INSERT INTO kqp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sa iyére to yôŋ yôŋ to ken ô ya aɲa bay ré ɓeréŋge yirji a na, emêŋge aŋga bay béŋge hen. ");
INSERT INTO kqp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Berarêŋge bay ômɲare kiriɲ bay ka ya hen men, ken kôlji iyôŋ ba: ‹*Emê iyére to Emen era kwôy uɲéŋge.› ");
INSERT INTO kqp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Niɲba sa iyére to yôŋ yôŋ to ken ô ya aɲa bay ré ɓeréŋge yirji a ré na, séŋge tu wolé tô geré wo dami a aɲ ken iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Bunu to sa iyére toŋge a to ɓu têrni hen kôba, niɲa gagêre hôriɲ béŋge. Niɲba, ken hôn wo emê iyére to Emen ré ɗa niɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na tu kwôlê a ené ena kelêŋge hen Wulê woɲ jerê kwôlê a na, ɓiɲé ka *Sodôm a bay a jerê kwôlê sarji a lôg gôliɲ ɓiɲé ka sa iyére hende to hen sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Ayi! ɓiɲé ka Kworajin, bô emê yi wô sarê. Ayi! ɓiɲé ka Bêtsayda bô emê yi wô sarê. Hena aŋgaɲ giɲê ka liɲ sa iyére toŋge a hen na, henaŋ né liɲ na Tir a ley Sidôn a ley na, na ca yeŋ a bay henaŋ né haarê bargay ka yêgeriɲ men, loberé bunu yirji a a men, bi ciré gelé wo ciré bul cêgerji biɲ têriɲ toji niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na ôbi á, wulê wo bay a jôriɲ kwôlê sa ɓiɲé a hen na, si Tir naɲ Sidôn kwôlê a jôriɲ sarji a lôg gôliɲ kwoŋge. ");
INSERT INTO kqp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A mini Kapêrnayôm, mu kôl bay ré ayêrê kwôy ôriɲ ta derômaraŋ a ba? Ma herbé kwôy ɗogé iyom temare a ka na kiriɲ ka habiɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jésu kôliɲ bay tôri iyôŋ ba: «Kwo toy kwôlê woŋge ba, toy na kuɲê nôbi hen men, kwo kaɲêŋge ba, kaɲen na nôbi hen men, kaɲ na kwo joon hen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bay tô Jésu ka tôre jurgem kibi wô hen heraji naɲ yi derê aɲ kôl iyôŋ ba: «Kelma, tunu to habiɲ kôba, kiriɲa nini ay tôô buru naɲ henem na, hende bêni kwôlê.» ");
INSERT INTO kqp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Menba, Jésu kôlji iyôŋ ba: «En gel Sidan hena derômaraŋ a kuriɲ môɲ wulaɲê emen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Na en béŋge néé bi kené ɗôdiriɲ kalaw men, ɗôdiriɲ tiigre men, ɗôdiriɲ néé wo ôbi bare kêm men, ani ka a lêŋge ba, naɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lêŋge yi derê wô wo tunu to habiɲ kôba, ré dôbe sare béŋge hen mera ré, niɲba, ken li yi derê wô wo heneŋge ɗiɲ derômaraŋ a ya.» ");
INSERT INTO kqp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kiriɲ bay ka hen na, Tunu toɲ hendi bô bôrê ay Jésu naɲ yi derê aɲ ôbi kôl iyôŋ ba: «En ay kem Iban Kelma wo derômaraŋ a naɲ kwo sa terare a nà, wôsa ju uwôbiɲ bay tu melênê naɲ bay tu jôriɲare are bay ka hen aɲ ju yêge sarji geliɲ ɓiɲé ka bay bôrji mega ani ré hen ɗi. Na iyôŋ a, Iban na jeré genge naɲ bô derê wom.» ");
INSERT INTO kqp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Iban bên are kêm kôben a, kwôni wo hôn Kema ba, naɲ, na Ibari pôn ɗô men, kwôni wo hôn Iban ba, naɲ niɲba, na nôbi Kemari pôn nêŋ haɲê men, ka en yêge sari nô biji hen a men mera.» ");
INSERT INTO kqp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Menba ôbi bul si ligi bay tôri kôlji piniji iyôŋ ba: «Yi derê yi wô sarŋge kenbay ka ken gel are bay ka hen naɲ turŋge hen. ");
INSERT INTO kqp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wôsa en kelêŋge bay kibi Emen kwône naɲ kilmé kwône na gey bi ciré gelé aŋga ken gel hen men, niɲba, bay gel ré men, bay gey ciré toyé kwôlo ken toy hen niɲba, bay toy ré a men.» ");
INSERT INTO kqp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ôbi derê tô tôô to Emen wo pôni hena ta aɲ kôliɲ Jésu wô séliɲ bôri kôl iyôŋ ba: «*Rabi, na mi a ené lê aɲa ené uwôɲiɲ gelê wo naɲ kwini ba?» ");
INSERT INTO kqp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Menba, Jésu uwôli sara iyôŋ ba: «Liɲ bô magtubu tôô tona kôl iyeŋ ba? Ju dêŋse ba, kôl iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ôbi uwôli sara iyôŋ ba: «Já peré Kelma wom Emen naɲ bôô pôn men, naɲ tunum kêm men, naɲ néém kêm men, naɲ ermé wom kêm men, gey megam mega wo ju geyiɲ yem hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Menba, Jésu kôli iyôŋ ba: «Ju kôl na tiri. Li are bay ka hen kêm menba, já uɲé gelê.» ");
INSERT INTO kqp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Niɲba, ôbi gey gelé mega wo eŋgeré kwôlê wori bi wo hen ré na ya menba, ôbi hô kôliɲ Jésu iyôŋ ba: «I a na megan ba?» ");
INSERT INTO kqp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Menba, Jésu uwôli sara iyôŋ ba: «Sa to pôni gawra wo pôni hena Jérusalêm wô erê Jériko, kiriɲa ôbi si sa bay bô habrê na, bay ɓiri tôriɲ aŋgari kêm men, sêri tu temare aɲ ɗiɲ yirji ô. ");
INSERT INTO kqp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ôbi bê kwôbe ay geré bi wo hen men, kiriɲa ôbi gel gawra bi wo hen iyôŋ menba, saŋge ta ô erê wori. ");
INSERT INTO kqp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","*Lébit wo pôni kôba sa biɲ kiriɲ bay ka hen men, ôbi gel gawra bi wo hen a men, menba, saŋge ta ô erê wori. ");
INSERT INTO kqp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Niɲba gawra wo Samari wo pôni wo ô kergare tori menba, sa biɲ ɗa kwa gawra bi wo hen a, ôbi gili menba, tiri liri ɲa. ");
INSERT INTO kqp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ôbi uso ɗa ligiri a aɲ liri weŋ tu iyare a men, biri care toɲ kam tiɲaɗor a a men, aɲ ha ta naɲ kibi bargay aɲ ayri ɗé sa kura tori toɲ yiri a aɲ ôriɲ naɲ ɗi iyéy kergare a aɲ kôrbiri. ");
INSERT INTO kqp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kiriɲ wôl menba, ôbi tô selé wôô biɲ ôbi iyéy iyére hende to hen aɲ kôli iyôŋ ba: ‹Gemni dô ben aɲ hena jeré mêne gursu tôni a ba kiriɲa en hera ba na sa têbem.› » ");
INSERT INTO kqp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Menba, Jésu kôli iyôŋ ba: «Perê ɓiɲé bay ka subu hen na, i a na mega gawra bi wo bay bô habrê ré sari hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Menba, ôbi derê tô tôô to Emen bi wo hen kôli iyôŋ ba: «Na kwo li dô naɲ ɗi hen a na megari.» Menba, Jésu kôli iyôŋ ba: «Ô aɲ jôbi kôba ju li hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kiriɲa bay ɓu geré ô menba, Jésu saŋge sa iyére to dê to pôni a menba, iyore to pôni bay uwôgere Mart ɓerji kergare iyére tore a. ");
INSERT INTO kqp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hende ôriɲ naɲ yêêre to dê to bay uwôgere Mari mô kwa Jésu a tôŋ terare a wô toyé kwôlê wori. ");
INSERT INTO kqp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mart giiré si na si na wô lê aŋgaɲ emê. Hende era ligi Jésu a aɲ kôli iyôŋ ba: «Kelma, yêren to dê ɗén en li jé punen hen ba ju gel ré ba? Kôle ré sa jôgen lê men.» ");
INSERT INTO kqp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Menba, Kelma uwôle sara iyôŋ ba: «Mart, Mart, mu sun men, mu geré si na si na wô sa are kwône. ");
INSERT INTO kqp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Niɲba, are pôn nêŋ a na ka dôri. Na bay a Mari ré ay hen, kwôni a derê aɲ kôbre a ré.» ");
INSERT INTO kqp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wulê wo pôni Jésu uwôl Emen kiriɲ ka pôni a. Kiriɲa ôbi uwôl Emen kô menba, ôbi tôri pôn kôli iyôŋ ba: «Kelma, geléni uwôlê Emen môɲ kwo Ja ôbi liɲ ɓiɲé batêm na geliɲ bay tôri hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Menba, Jésu kôlji iyôŋ ba: «Kiriɲa ken uwôl Emen ba, ken kôl iyôŋ ba: ‹Ibarni, bi ɓiɲé kêm hôn wo jeré yi naɲ jeŋgêrem men, bi bi emê iyére tom era men. ");
INSERT INTO kqp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Béni aŋgaɲ emê ka nini ôriɲ doyriji kemnêŋ hen. ");
INSERT INTO kqp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɗi bôm jal sa têriɲ lêreni a men wôsa nibay kôba nini ɗi bôrni jal sa ka lêni habrê a men. Geméni aɲ ju bi bi niné heriɲ bô aŋga séléni hen né a men.› » ");
INSERT INTO kqp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Menba, ôbi hô kôlji iyôŋ ba: «Hena kwôni pôn perêrŋge a hen ré naɲ melaɲni aɲa melaɲni bi wo hen ré ô uɲéri yoyre aɲ kôli iyôŋ ba: ‹Melaɲnen gwôyen mapa subu ");
INSERT INTO kqp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wôsa melaɲnen wo pôni sa aɲ ani ka ené biri ré ôm naɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aɲ hena melaɲni wo bô ira hen ré kôli iyôŋ ba: ‹Ɗén ɗê! Kermiɲ ligiɲ niɲ men, nibay naɲ kamnen nini yi tôŋ niɲ a men, ɗiba na hena ta wô bem mapa ré.› ");
INSERT INTO kqp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","En kelêŋge hena ôbi ré hena biri mapa bi wo hen kôba, na wô wo ôbi ré na melaɲni ré niɲba, na wô wo ôbi dôyrêri aɲ ôbi a hena biri mapa bi wo ôbi gey hen. ");
INSERT INTO kqp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Niɲba, nôbi en kelêŋge: Eŋgeréŋge menba, bay a béŋge, wogéŋge menba, ka uɲé, dêŋge kibi iyére menba, bay a belê béŋge. ");
INSERT INTO kqp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wôsa kwôni wo eŋgere ba, bay a biri, men, kwo woge ba, a uɲé men, kwo di kibi kermiɲ ba, bay a belê biri men. ");
INSERT INTO kqp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","I a na iba kema perêrŋge a hen aɲa hena kiriɲa kemari ré eŋgereri kuyê ba, ôbi a biri kalaw ré na kuyê ba? ");
INSERT INTO kqp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Réba hena ôbi ré eŋgereri cera ba, ôbi a biri tiigre ba? ");
INSERT INTO kqp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hena kenbay kaɲ bay bô habrê hen kôba, ken hôn biɲ kamneŋge aŋga dôri aɲa Ibareŋge wo derômaraŋ a dema hena kené eŋgereri Tunu toɲ hendi bô bôrê a ôbi ré biɲ ka uwôli hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sa to pôni Jésu dage tunu to habiɲ to jôriɲ gawra wo pôni iyêlê hen. Kiriɲa tunu hende to hen séɲ niɲ na, gawra bi wo tunu hende to hen ré jôôri iyêlê hen na, iyêl dô hari niɲ, menba, kwônê ɓiɲé ka ɗebu ya hen na, tiniji ge kay kêm. ");
INSERT INTO kqp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Niɲba, ka pôni perêrji a hen kôl iyôŋ ba: «Na naɲ néé wo *Béyêljébul kelma wo tunu to habiɲ aɲa ôbi ré dagiɲ tunu to habiɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka pôni ka gey sélé bô Jésu menba, kôli ré li aŋgaɲ gelé ka hena derômaraŋ a ciré gelé. ");
INSERT INTO kqp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Niɲba, ôbi hôn ermé woji menba, kôlji iyôŋ ba: «Hena kumbul ré kuriɲ perê ɓiɲé ka sa terare to pôn nà ba, sa terare hende to hen a mêniɲ, iyére a tiiriɲ kerôm kerôm a men. ");
INSERT INTO kqp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ken kôl ré na naɲ néé wo Béyêljébul aɲa ené dagiɲ tunu to habiɲ hen. Iyôŋ ba, hena Sidan ré li kumbul naɲ Sidan ba emê iyére tori a erê derê sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A hena ré na naɲ néé wo Béyêljébul a ené dagiɲ tunu to habiɲ ba, bay tôrŋge kenbay ba, dage na naɲ néé wo i men ba? Iyôŋ ba, bay a yé bay jerê kwôlê sarŋge a. ");
INSERT INTO kqp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A hena ré na naɲ néé wo Emen a ené dagiɲ tunu to habiɲ hende to hen na, iyôŋ ba, emê iyére to Emen era uɲéŋge niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Kiriɲa gawra woɲ ôbi néé gem kini merêri naɲ aŋgaɲ maɲê kari na, ari uɲéri kêm yi naɲ kiniji. ");
INSERT INTO kqp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Niɲba, hena kwo néri ré gôliɲ kwori sa ɓiri tôriɲ aŋgaɲ maɲê kari bay ka ôbi na bi bôri sara hen menba, kwo gôliɲ sari bi wo hen pô aŋgari kêm cé aɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Kwôni wo naɲ en ré ba, na ôbi baren men, kwo day ɓiɲé naɲ en ré ba, usuréji na usuré ɗi men.» ");
INSERT INTO kqp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jésu hô kôl iyôŋ ba: «Kiriɲa tunu to habiɲ séɲ bô kwôni a na, hende kayrê derô gwôlê woge kiriɲ kaɲ derê bul, hena hende ré uwôɲ ré na, hende erem kôl iyôŋ ba: ‹Na herê kiriɲ ka na en soɲ ya hen gelé sôŋ.› ");
INSERT INTO kqp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kiriɲa tunu hende to hen hera aɲa ré uwôɲ kiriɲ na sél dô men, are kêm yi naɲ kiniji a men na, ");
INSERT INTO kqp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","hende hô ô pera tunu to habiɲ to ɗaŋgi jurgem to habiɲ ɗê aɲ sa jôgiɲ naɲ tu. Bay siji bô kiriɲ bay ka hen aɲ môrji ya aɲ gawra bi wo hen na, yiri habiɲ ɗê kwo tumô aɲ tô.» ");
INSERT INTO kqp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kiriɲa ôbi iyêl hen iyôŋ menba, iyore to pôni perê kwônê ɓiɲé kôli iyôŋ ba: «Yi derê baa naɲ iyore to yêm aɲ ju yi kubare hen.» ");
INSERT INTO kqp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Niɲba, ôbi kôl iyôŋ ba: «Yi derê baa naɲ kwôni wo toy kwôlo Emen aɲ li ariri hen ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kiriɲa kwônê ɓiɲé dayriɲ ligi Jésu a hen iyôŋ menba, Jésu kôl iyôŋ ba: «Ɓiɲé ka haw hen na, na ɓiɲé ka habiɲ, bay gey na aŋgaɲ gelé mera niɲba, bay a baɲ na naɲ aŋgaɲ gelé ka Jonas bi wo hen mera, ɗiba bay a gelé ka ɗaŋgi kani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mega wo Jonas na yi aŋgaɲ gelé biɲ ɓiɲé ka Ninibé a hen iyôŋ na, nôbi *Kema Gawra na yé aŋgaɲ gelé biɲ ɓiɲé ka haw hen men. ");
INSERT INTO kqp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wulê woɲ jerê kwôlê a na, tôlômne to Séba a hena aɲ a ulê kwôlê sa imɲê ka haw hen, wôsa hende hena na kelaŋ aɲ era na wô toyé gwosoy kwôlê woɲ tu melênê wo Salomôn. Niɲba nà ná, kwôni wo gôliɲ Salomôn aɲ hen kôba nà ya. ");
INSERT INTO kqp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wulê woɲ jerê kwôlê a na, ɓiɲé ka Ninibé a henaji tumô ɓiɲé ka haw hen aɲ ulê kwôlê sarji a, wôsa derê kwôlo wo Jonas li aɲ bay bul hal woji. Niɲba nà ná, kwôni wo gôliɲ Jonas aɲ hen kôba nà ya.» ");
INSERT INTO kqp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Kwôni ɗi tare bô lampa ba na wô uwôbê ré men, na wô emé gwore sara ré a men, niɲba, hena ôbi ré ɗi tare a bô lampa ba, na wô ɗé ta gurô pal a aɲ bi ɓiɲé ka ré era ira hen ré gel peraŋgêre. ");
INSERT INTO kqp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tum na lampa to yem. Hena tum né dô ba, tô yem wo baa kêm hen mô na bô kiriɲ ka peraŋgi a men, niɲba, kiriɲa tum ômiɲ ley na, tô yem wo baa kêm hen kôba, mô na bô dilemne a men. ");
INSERT INTO kqp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bô dô ré ba, kiriɲ ka peraŋgi ka yi yem a hen ma yé kiriɲ kaɲ dilemne. ");
INSERT INTO kqp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hena yem kêm ré na kiriɲ ka peraŋgi a, ɗiba kwari wo pôni baa bô dilemne a ré na, ôbi a merê bô kiriɲ ka peraŋgi a mega lampa peraŋgem naɲ berarê wore hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jésu iyêl ba ya tô menba, *Parisiɲê wo pôni uwôgeri ré ô emê are iyére tori a. Menba, ôbi ô emê are bay ka hen naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisiɲê bi wo hen tini ge kay diɲaŋ wôsa Jésu ôm are ba pelé kôbri mega wo tôô toji kôl hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jésu bô ti Parisiɲê bi wo hen iyôŋ menba, kôli iyôŋ ba: «Kenbay Parisiɲêɲê na, na cêgi karbé toɲ yê are men, cêgi dasa men, a kené pul niɲba, bôrŋge wo bôô na, na ermé kwôlê woɲ gemsare men, habrê men. ");
INSERT INTO kqp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bay galê, ken hôn wo kwôni wo li cêgi are hen a lê bôrji a men né ba? ");
INSERT INTO kqp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ɓeréŋge baliyare naɲ bay nimré naɲ aŋga yi bô karbé toŋge a hen men, naɲ ka yi bô dasa woŋge a hen a men aɲ ka yé ka séli yôd.» ");
INSERT INTO kqp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Gusiɲ yi wô sarŋge, kenbay Parisiɲêɲê, ken ay kibi aŋgaɲ ɲa kiliɲ kaŋge ka môj kêm ka na tamla men, uu men, têrêre a men hen biɲ Emen niɲba lê aŋgaɲ derôre naɲ peré Emen ka ken ɗi aɲ hen na, bay a na aŋgaɲ dami ka kené lê sa ka ken li hen a.» ");
INSERT INTO kqp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Gusiɲ yi wô sarŋge kenbay Parisiɲêɲê, wôsa ken gey kini merê ka tumô bô *iyéy daɲare a men, ken gey bi ɓiɲé ré lêŋge dosé tu wolé naɲ bê kwôlê a men hen. ");
INSERT INTO kqp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gusiɲ yi wô sarŋge, wôsa ken yi môɲ kamɲê ka kwôni li ani sara ré ka kwôni ô sara ba henê iyôŋ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Menba, ôbi derê tô tôô to Emen wo pôni kôliɲ Jésu iyôŋ ba: «Kelma, mega wo ju kôliɲ hen na, na nibay a jeré tiréni hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Menba, Jésu uwôli sara iyôŋ ba: «Kenbay kaɲ bay derê tô tôô to Emen kôba, gusiɲ yi wô sarŋge, wôsa ken pô aŋga néy néy ɗééré sa ɓiɲé menba, kenbay ba, kema kôbreŋge iyôŋ kôba, hebe ani ré. ");
INSERT INTO kqp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gusiɲ yi wô sarŋge, kenbay ka ken ɲan kamɲê bay kibi Emen dô hen menba, nà ná balêrŋge a na diréji. ");
INSERT INTO kqp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ôbi a, kené gel mega wo kené dege sa jé lê balêrŋge a, wôsa bay na duu bay kibi Emen men, kenbay ken ɲan sa kamɲêrji dô men. ");
INSERT INTO kqp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na ôbi á, Emen naɲ tu melênê wori hen na ré kôl iyôŋ ba: ‹Na jéɲ naɲ bay kibi Emen men, bay jé a men, niɲba, bay a deré ka pôni men, bay a geliɲ tu ka pôni gusiɲ men.› ");
INSERT INTO kqp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ôbi a, gawrê ka haw hen, kwôlê réé ɓeré sarji wô kibi bay kibi Emen ka bay na derji ca kiriɲa tô terare na ɗiɲ yeŋ. ");
INSERT INTO kqp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ayiɲ tô sa kwôbri Abêl a kwôy saɲ sa kwo Jakari a wo bay diri derô to kini bê kwôbe a naɲ *iyéy Emen hen. Na tu kwôlê a ené ena kelêŋge hen, kwôlê a ɓeré sa gawrê ka hawi hen, wô sa temayriji.» ");
INSERT INTO kqp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Gusiɲ yi wô sarŋge, kenbay bay derê tô tôô to Emen ka ken ay lakêêlê henê are kôbreŋge a. Aɲ kenbay ken kaɲ henê Emen men, ken jôriɲ ka ɗaŋgi ka gey henêri hen ré hôni ré a men.» ");
INSERT INTO kqp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kiriɲa Jésu ɗa sé erê ta menba, Parisiɲêɲê naɲ bay derê tô tôô to Emen eŋgereri kwôlê si na si na naɲ bô tarê ");
INSERT INTO kqp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sébiɲ kibri ciré gelé aɲ hena kwôlê wôni ré si kibri habiɲ ba, ciré uwôliɲ kwôlê sari a. ");
INSERT INTO kqp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kiriɲ bay ka hen na, ɓiɲé dayriɲ naɲ kwônêrji aɲ li wo bay ɗôriɲ sa têrji. Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a ɗiba ken yi bay kelê kwôlê kibriji wôô wôô môɲ kwo *Parisiɲêɲê iyôŋ né. Wôsa lamê tu kiriɲ kaji bay ka hen na, yi môɲ wubere iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ani ka uwôbe ka baa geliɲ ba, naɲ men, ka bô kwôni a ka a baa hôniɲ ba, naɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wôsa kwôlo kêm wo ken kôl bô dilemne a hen na, a toyiɲ tu tare ɗéɲ ɗéɲ men, kwo ken gwôsiɲ marŋge a bô ira hen kôba bay a ɗayê ta sa ira dema ré kelê kaŋ a ta a men.» ");
INSERT INTO kqp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«En kelêŋge milɲên, hariɲge ka a deré kurôŋgi yerŋge aɲ cêgeri wori ba, a lê ani ré niɲ hen né. ");
INSERT INTO kqp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na geléŋge kwôni wo ken hareri. Hariɲge kwo a deré kurôŋgi yi aɲ nêm ulêŋge bô tare toɲ *géhên a hen a men. Na tiri, ôbi a kené hareri ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Bay daɲ diya bay dema ré na tu selé wôô tô hen ba, ken gel ré ba? Niɲba, Emen ba, hônji pôn pôn kêm. ");
INSERT INTO kqp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Gusuri sarŋge kôba Emen dêŋse. Niɲba, ken hare ré, wôsa ken dami tu Emen gôliɲ diya bi wo kwône hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«En kelêŋge kwôni wo kôl tu ɓiɲé kêm ɗiré na kuɲê na, nôbi *Kema Gawra na kelê tumô manê ka Emen a ôbi ré na kuɲê men. ");
INSERT INTO kqp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Niɲba, kwôni wo uwôser ɗiré hônen né tu ɓiɲé na, nôbi Kema Gawra na kelê ené hôni ré tumô manê ka Emen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Men, kwôni wo kôl kwôlo habiɲ gengiɲ san nôbi Kema Gawra na, Emen a ɗé bôri jalê sari a, niɲba, kwo tiiré Tunu toɲ hendi bô bôrê na, Emen a ɗé bôri jalê sari a ré kwôy yôd.» ");
INSERT INTO kqp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Kiriɲa bay ôriɲ naɲ ken bô *iyéy daɲare a ley, tumô bay sa kiriɲ a ley, tumô kilmé ley na, ken sun wô kwôlo kené erê kelê wô jôriɲ sarŋge ré. ");
INSERT INTO kqp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wôsa Tunu toɲ hendi bô bôrê a geléŋge kiriɲ bay ka hen, kwôlo kené kôl.» ");
INSERT INTO kqp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Menba, kwôni pôn perê ɓiɲé kôliɲ Jésu iyôŋ ba: «Kelma, kôliɲ yênen bi niné céɲ ari cibré kani.» ");
INSERT INTO kqp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Menba, Jésu kôli iyôŋ ba: «I a ɗén bi ené yi ôbi jerê sarŋge a men, ôbi cé are kaŋge men ba?» ");
INSERT INTO kqp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Menba, Jésu hô kôli iyôŋ ba: «Ɗéŋge tu melênê sa yerŋge a, ɗiba ken yi limé ka aŋgaɲ uɲé ré. Na wô wo kwôni uwôɲ are gaɲ aɲa ré môriɲ tu geɲ né.» ");
INSERT INTO kqp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Gawra wo pôni na ôbi uɲé wo uwoɲ are gaɲ bô yagê wori a. ");
INSERT INTO kqp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Menba, gawra bi wo hen kôl iyôŋ ba: ‹Na lê iyeŋ a, kiriɲ ka ené biɲ kaw kaɲê ré naɲ niɲ na ba?› ");
INSERT INTO kqp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Menba, ôbi hô kôl iyôŋ ba: ‹Aŋga na lê a na: Na téé béér wo cay hen aɲ, aɲ na hô ɗé kwo damné damné aɲ na dayê kaw naɲ ari uɲé kaɲê kêm bô. ");
INSERT INTO kqp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aɲ na kelê iyôŋ ba: «Bô ari uɲé kaam kêm ka yi hen, na ka a lê elê kwônê, dô bul aɲ ju ôm men, yi men, liɲ yi derê.» › ");
INSERT INTO kqp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Niɲba, Emen kôli iyôŋ ba: ‹Ôbi galê, bô yoyre hende to hen, na derê bul wom aɲ aɲ aŋga ju dayrê kêm hen ba i a baɲ niɲ ba?› » ");
INSERT INTO kqp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Menba, Jésu kôl iyôŋ ba: «Na aŋga sa sa ɓiɲé ka dayrê ari uɲé kaji ɗiba biɲ kwôni men ré hen aɲ kaɲji wogé ari uɲé ka ligi Emen a.» ");
INSERT INTO kqp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jésu kôliɲ bay tôri iyôŋ ba: «Geléŋge, na ôbi a, ené kelêŋge kené sun wô aŋga kené emê gôliɲ ré men, wô aŋga kené tôbê yerŋge a ré men hen. ");
INSERT INTO kqp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wôsa merê tu geɲ na, gôliɲ aŋgaɲ emê men, yi gôliɲ bargay a men ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Berêŋge haŋga ken gel, bay ci ani ré men, wal ani ré men, kini bê aŋgaji naɲ men, béér woji naɲ a men, niɲba, Emen abeji hen ba, kenbay ba, ken gôliɲ ciré ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Perêrŋge a hen i a nêmê ulê wulê pôn a sa megari a wô wo ɗiré sun gaɲ ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hena nérŋge ré naɲ wô liɲ aŋga dê, dê bay ka hen iyôŋ ba, wô mi a kené sun wô sa tô ka baa hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Berêŋge béé gesela ken gel, bay li jé ré men, bay li bargay kani ré a men, niɲba en kelêŋge kelma Salomôn naɲ hini emê wori hen kôba, tôbe bargay ɗê kwo pôni wôni perêrji a hen né. ");
INSERT INTO kqp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hena kalmê ka nono ka kemnêŋ yi hen aɲ kiya bay a uwoyé aɲ hen, Emen tôbiji bargay aɲ kenbay dema ôbi ré lê are béŋge ré ba? Ayi! gawrê ka ayê bôô woji naɲ hen. ");
INSERT INTO kqp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sunéŋge wô ari emêrŋge ré men, wô aŋgaɲ yêreŋge a ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Are bay ka kêm hen na, bay henê Emen né a wogéji yôd yôd merênê liji tô ré hen, ɗiba kenbay ba, Ibareŋge hôn aŋga ken ôriɲ doyriji hen. ");
INSERT INTO kqp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wogéŋge emê iyére tori tumô ɗi aɲ are bay ka kêm hen ôbi a béŋge a sara a.» ");
INSERT INTO kqp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Kenbay ka ken yi môɲ gamgê kaɲê iyôŋ ka lôg tumôn a hen, harêŋge ré wôsa Ibareŋge genge wo ɗiré béŋge emê iyére tori. ");
INSERT INTO kqp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Keléŋge aɲ ari uɲé kaŋge kêm aɲ ken ɓiriɲ baliyare naɲ larirji. Ɲanêŋge magela gemé lari woŋge wo a mêniɲ né hen men, aŋgaɲ uɲé ka derômaraŋ a ka a naɲê ré hen men, wôsa kiriɲ bay ka hen na, ôbi gemsare a erê biɲ ya ré men, a ɓeré kar ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wôsa kiriɲ ka cirarem yiɲ ya na, ermé wom kôba, na kiriɲ bay ka hen men.» ");
INSERT INTO kqp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Tôbêŋge bargay kaɲ jé men, ken ɗi lampa toŋge eŋge yôôd a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yéŋge mega manê ka mô gem hera wo ôbi iyére toji kiriɲa ôbi a uwo tô kurô aɲa ré di kibi geré menba, bay bôl lew biri iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yi derê yi wô sa manê bay ka ôbi iyére toji sa aɲ uwoɲji geɲ. Na tu kwôlê a ené ena kelêŋge hen ôbi a tôbê bargay kaɲ jé aɲ biji bay merê tôŋ aɲ ôbi biji aŋgaɲ emê pôn pôn kêm. ");
INSERT INTO kqp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hena ôbi ré sa na sa kiriɲ ka jali, kibi kiriɲ ka wôli a aɲa ré uwoɲji tu geɲ sa têrji a na, yi derê yi wô sarji. ");
INSERT INTO kqp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ken hôn wo hena ôbi iyéy iyére henaŋ né hôn wulê wo gemsa ré era wô gemsêri na, ôbi henaŋ ré ɗéri sé bô ira ré. ");
INSERT INTO kqp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kenbay kôba, ken mô sa têrŋge a wôsa ken hôn, nôbi Kema Gawra na sa naɲ wulê wo ken bi bôrŋge sara hen né». ");
INSERT INTO kqp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Menba, Piyêr kôl iyôŋ ba: «Kelma, ju kôl gwosoy kwôlê bi wo hen iyôŋ na wô sarni laba, na wô sa ɓiɲé kêm ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Menba, Kelma kôli iyôŋ ba: «I a na ôbi gemé are woɲ ôbi bê kwôlê men, ôbi tu melênê a men wo ôbi iyéyri a ɗiri ré bô sa ari uɲéri men, sa bay jé kari men, ré biji emê wo sa pôn pôn kêm naɲ wulêri men, tayriri men ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yi derê yi wô sa mana bi wo hen wo ôbi iyéyri sa aɲ uwoɲni li jé wori bi wo hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na tu kwôlê a ené ena kelêŋge hen, ôbi a ɗiri berê sa ari uɲéri kêm. ");
INSERT INTO kqp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Niɲba, hena mana bi wo hen ré kôl iyôŋ ba: ‹Gel, ôbi iyéyren baa aɲê tô› aɲ sê manê naɲ kalmê kaɲ bay jé men, ôm men, yi men aɲ kwoyiɲ a men na, ");
INSERT INTO kqp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ôbi iyéyri a sa naɲ wulê wo ôbi ɓu sa têri ré hen aɲ ôbi a liri ɓisiɲne men, ôbi a gili gusiɲ a men, mega bay giliɲ bay lê are naɲ bôô pôn né gusiɲ hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Mana wo hôn bô geyé wo ôbi iyéyri aɲa ré ɓu sa têri ré men, li are biɲ naɲ bô geyé wo ôbi iyéyri bi wo hen né men na, a uɲé sêê damaŋ. ");
INSERT INTO kqp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Niɲba, kwo hôn né aɲa ré li aŋga nêm sêê na, bay a sêri lôg. Kwôni wo bay biri are gaɲ ba bay a hô eŋgereri damaŋ a men, kwo bay biri are gemé damaŋ ba, bay a hô eŋgeré damaŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Menba, Jésu kôl iyôŋ ba: «En era sa terare a na, na naɲ tare. Aɲ en deŋga damaŋ bi hende ré eŋge niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na batêm to bay a lên, batêm hende to hen na gusiɲ to lên. Aɲ en aŋge kwôy wo bay a lên batêm hende to hen. ");
INSERT INTO kqp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ken erem yaŋ ba, ré na bô jalê a ené eraɲ sa terare a nà? Eŋ eŋ, na bô jalê a ené eraɲ sa terare a nà ré, niɲba na kariɲare. ");
INSERT INTO kqp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wôsa ayiɲ tôri haw hen, hena ɓiɲé ré bay bô ira ba, bay a kariɲ ka subu hen a biɲ tôrji men, ka wôô hen kôba a biɲ tôrji. ");
INSERT INTO kqp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iba kema a kariɲ naɲ kemari men, kema a kariɲ naɲ ibari men, yo mône a kariɲ naɲ môɲne men, môni iyore a kariɲ naɲ yore men, kariɲare a yé perê iyore a naɲ maare a a men, perê maare a naɲ tu a men.» ");
INSERT INTO kqp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jésu hô kôliɲ kwônê ɓiɲé iyôŋ ba: «Kiriɲa ken gel emen yé si kini kuriɲare tare ba, ken kôl iyôŋ ba: ‹Emen a uwôŋgê› menba, yi hen tiri a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Men, kiriɲa ken gel kal guro si tô emen menba, ken kôl iyôŋ ba: ‹Kiriɲ né uwoyé› menba, kiriɲ bay ka hen uwoy tiri a men. ");
INSERT INTO kqp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kenbay bay kelê kwôlê kibriji wôô wôô hen, ken hôn gengé aŋga sa terare a nà naɲ ka derômaraŋ a hen iyôŋ menba, wô mi a kené hôn wulê wo ken mô ya hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Men, wô mi a kené hôn derê tu aŋgaɲ derôre ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hena jeré ôriɲ naɲ ôbi barem kibi bay jerê kwôlê a na, li bi kwôlê woŋge biɲ pa dema kené biɲ ligi bay jerê kwôlê a tô. Réba ôbi a ôriɲ naɲ ju kibi ôbi jerê kwôlê wo dami a men, ôbi jerê kwôlê wo dami bi wo hen a ôriɲ naɲ ju biɲ asgarɲê aɲ bay a uwôlem daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","En kôlem, hena ré na selé a baa kôba, já têbê kerê iyôŋ iyôŋ dema bay réé uwôlam ta tô.» ");
INSERT INTO kqp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wulê bi wo hen na, ɓiɲé ka pôni era sa kôliɲ Jésu kwôli ɓiɲé ka Galilé ka pôni ka *Pilat na bi bay na dirji sa wulê wo bay liɲ sarga woji hen. ");
INSERT INTO kqp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Menba, Jésu kôlji iyôŋ ba: «Ken erem mega wo ɓiɲé ka Galilé bay ka hen ré li têriɲ ɗê ka baa kêm hen, aɲa bay ré liji hen iyôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eŋ eŋ, na iyôŋ né, niɲba, en kelêŋge hena kené bul hal woŋge ré ba, ka mênê hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Men, ɓiɲé ka môj kibi marge ka iyére to dami to Silowé tiɲ aɲ dirji kêm hen ba, bay li têriɲ ɗê tô ɓiɲé ka Jérusalêm a kêm ka baa hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eŋ eŋ, na iyôŋ né, en kelêŋge hena kené bul hal woŋge ré ba kenbay kôba, ka mênê kêm geliɲ hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Menba, Jésu kôlji gwosoy kwôlo pôni kôl iyôŋ ba: «Gawra wo pôni ôriɲ naɲ gurô tôgôre bô yagê tiɲaɗor tori a, ôbi era ɗiré sa karê yêre menba, ôbi uwôɲ né. ");
INSERT INTO kqp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Menba, ôbi kôliɲ ôbi gemé yagê tiɲaɗor na iyôŋ ba: ‹Elê subu niɲ wo en era wô karê yê tôgôre hende to hen niɲba, en uwôɲ né. Dere jô aɲ. Wô mi a hende ré mênê néé terare aɲ ba?› ");
INSERT INTO kqp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Niɲba, ôbi gemé yagê tiɲaɗor na kôli iyôŋ ba: ‹Kelma, ɗere hen iyôŋ elê wo na a, aɲ na beré tôre men, na bê kaɲ lari a a men. ");
INSERT INTO kqp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dô ré ba, elê wo era hen hende a yê tô. A hena hende ré yê ré niɲ ba, ju dere jô ham niɲ.› » ");
INSERT INTO kqp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wulê wo pôni a na, na sa merê ta a, menba, Jésu geliɲ ɓiɲé are bô *iyéy daɲare to pôni a. ");
INSERT INTO kqp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kiriɲ bay ka hen na, iyore to pôni to tunu to habiɲ lere meray li elê môj kibi marge deŋge tôŋ kwôy ɗiba nêm derê sare ta ré. ");
INSERT INTO kqp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kiriɲa Jésu gele menba, uwôgere aɲ kôle iyôŋ ba: «Iyore merayê woré dôriɲ sarê.» ");
INSERT INTO kqp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ôbi uwôl kôbri sara menba, kiriɲ bay ka hen na, hende dô sare ta aɲ heram Emen. ");
INSERT INTO kqp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kelma ôbi sa iyéy daɲare hende to hen, bôri tari sa aŋga Jésu li a naɲ sa merê ta a hen, menba, ôbi kôliɲ kwônê ɓiɲé iyôŋ ba: «Wulê woɲ liɲ jé na, na jii, na bô wulê bi wo hen a kené era bi bay ré berarêŋge ɗiba na naɲ sa merê ta a ré.» ");
INSERT INTO kqp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Menba, Kelma uwôli sara iyôŋ ba: «Kenbay kaɲ bay kelê kwôlê kebreŋge wôô wôô hen, kwôni pôn perêrŋge a hen, naɲ sa merê ta a dô kelba wori réba kura wori tô gwogel a ôriɲ biri kam né ba? ");
INSERT INTO kqp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iyore hende to hen kôba, na kuŋga *Abraham to Sidan gele gusiɲ kwôy elê môj kibi marge hen ba, ken gey bi ené dôre bô lemnare to Sidan a ré wôsa ré na merê ta a ba?» ");
INSERT INTO kqp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kwôlê bi wo Jésu kôl hen na, bay bayriri kêm tayre diji menba, tô kwônê ɓiɲé ka baa hen, li yi derê wô sa aŋga dô ɗê kiriɲ ka ôbi li kêm hen. ");
INSERT INTO kqp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jésu kôl iyôŋ ba: «*Emê iyére to Emen ba, na gengére naɲ mi pôn ba? Na ba, na ayê na mi geliɲ ba? ");
INSERT INTO kqp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Emê sa iyére to Emen na yi mega gusiɲ iluw iyôŋ. Kiriɲa kwôni ci bô yagê wori a na, ôbi si men, ɗubu aɲ yi gurô aɲ ciré ka derômaraŋ a kêm sa li gwoné woji ya.» ");
INSERT INTO kqp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jésu kôl iyôŋ ba: «Emê iyére to Emen ba, na gengére naɲ mi pôn ba? ");
INSERT INTO kqp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Emê iyére to Emen hende to hen yi môɲ wubere to dê to iyore ay poliɲ naɲ kurmaŋ kuré kwôrô subu menba, liji sôr iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jésu ô naɲ sa iyére men, sa kam iyére men, geliɲ ɓiɲé are aɲ ɓu geré na wô erê Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kwôni wo pôni kôli iyôŋ ba: «Kelma, hen ba, ɓiɲé côb iyôŋ a uɲé gelê ɗê?» Menba, ôbi kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Masêŋge ken si ira si kibi geré wo yêêri, wôsa en kelêŋge ɓiɲé kwône a wogé ciré sé ira niɲba, bay a nêmê ré.» ");
INSERT INTO kqp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Kiriɲa ôbi iyéy iyére a hena legé kermiɲ na, hena kené baa nô ba, ken hôn wo ka dê kermiɲ dô dô aɲ ka uwôlêri kelê iyôŋ ba: ‹Kelma, Kelma bôl béni men.› Menba, ôbi ulêŋge sara iyôŋ ba: ‹En hôn kiriɲ ka ken henaɲ ya hen né.› ");
INSERT INTO kqp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Menba, ka kelê iyôŋ ba: ‹Na nini ôm men, yii a men naɲ ju ré ba? Na ju geliɲ ɓiɲé are perê iyére toni a ré ba?› ");
INSERT INTO kqp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Menba, ôbi a ulêŋge sara iyôŋ ba: ‹En kelêŋge ené hôn kiriɲ ka kené henaɲ ya hen né. Erêŋge yeŋ kenbay bay lê habrê.› ");
INSERT INTO kqp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ka sômê men, emnê kaɲneŋge mêêrê, mêêrê a men, kiriɲa ka gelé Abraham, Isak, naɲ Jakwôb naɲ bay kibi Emen kêm bô emê iyére to Emen a menba, kenbay bay a bêŋge aɲ nô. ");
INSERT INTO kqp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aɲ gawrê a hena si tô emen men, kini kuriɲay tare a men, sa kôbi maa naɲ sa kôbi gusurô aɲ a daɲji kibi gwoy emê a bô emê iyére to Emen a. ");
INSERT INTO kqp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Men, ken hôn wo ɓiɲé ka pôni ka ɗebe tumô haw hen na, a yé ka cêgi men, ka ɗebe cêgê haw hen a yé ka tumô men.» ");
INSERT INTO kqp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kiriɲ bay ka hen na, *Parisiɲêɲê ka pôni era ligi Jésu a kôli iyôŋ ba: «Erêɲ kiriɲ ka na, wôsa *Hérôd gey ɗiré derem.» ");
INSERT INTO kqp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Menba, ôbi kôlji iyôŋ ba: «Ô ken ô kôliɲ mungôre bi wo hen iyôŋ ba: ‹Kemnêŋ en dage tunu to habiɲ bô ɓiɲé men, en berare bay ômɲare men, kiya na lê hen iyôŋ a menba, ɗaŋ to hen, na deré kibi jé wuɲê.› ");
INSERT INTO kqp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Niɲba, kemnêŋ en ɓu na geré wuɲê men, kiya men, ɗaŋ to hen a men, wôsa bi *ôbi kibi Emen na, dé wo bay ré diri wolé ré niɲba, Jérusalêm a ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Ɓiɲé ka Jérusalêm, ɓiɲé ka Jérusalêm, kenbay ka ken duu bay kibi Emen men, ken gôbe ka bay jéji legerŋge a hen duu naɲ jerew a men, têê kwône en woge ené dayêŋge môɲ tôôre daɲ sa kamne tô mesérére a iyôŋ niɲba, ken gey ré. ");
INSERT INTO kqp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dô, haw hen na, Emen a derê kôbri aɲ ɗéŋge sa iyére toŋge kôbreŋge a. Na tu kwôlê a ené ena kelêŋge hen, ka gelen ré niɲ kwôy wo wulêri a nêmê aɲ ka kelê: ‹Terê kibi yi sa kwo era naɲ hini Kelma.› » ");
INSERT INTO kqp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wulê wo pôni a na *sa merê ta a menba, bay uwôge Jésu ré ô emê are iyé ôbi sa Parisiɲêɲê wo pôni a. Ka mô kibi gwore a naɲ ɗi hen na, bôri jê jê. ");
INSERT INTO kqp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kiriɲ bay ka hen na, gawra wo pôni mô ya, na kwôni wo yiri uwôyrê. ");
INSERT INTO kqp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Menba, Jésu eŋgere *bay derê tô tôô to Emen naɲ *Parisiɲêɲê iyôŋ ba: «Tôô kôl kwôni ré berare kwôni sa merê ta a, laba iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Menba, bay uwôli kwôlê wôni sara ré. Menba, Jésu ay ôbi ômɲare bi wo hen berareri aɲ kôli ré ô iɲ. ");
INSERT INTO kqp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Menba, ôbi bul si ligi ɓiɲé aɲ eŋgereji iyôŋ ba: «I a naɲ kemari réba kelba wori kuriɲ a kelma aɲa ré erê ayêri lew ré, wôsa ré na sa merê ta ba?» ");
INSERT INTO kqp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Menba, bay nêm ulêri kwôlê wôni sara ré. ");
INSERT INTO kqp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jésu kôliɲ megêri kergê bay ka hen gwosoy kwôlo pôni, wôsa ôbi gel wo kwôni wo era ba, say na kiriɲ ka tumô a dema ré môriɲ menba, ôbi kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kiriɲa kwôni uwôgem kini gerê na, say kini merê ka tumô dema jeré môriɲ a ré, wôsa bay ma uwôgê kwôni wo dami wo ɗêm tô. ");
INSERT INTO kqp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aɲ ôbi wo uwôgêŋge hen a kôlem iyôŋ ba: ‹Ɗiri kiriɲ.› Menba, já hena naɲ tayre hen erê merê gerɲé. ");
INSERT INTO kqp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Niɲba, hena kwôni ré uwôgem kini gerê ley na, ô ju ô merê gerɲé kelôg aɲ bi kwo uwôgem hen era sa kôlem iyôŋ ba: ‹Melaɲnen, hena ju era tumô a na ɗi.› Hen iyôŋ na, a yé yi yéé wom tu ɓiɲé kêm ka ôbi uwôgaraji hen. ");
INSERT INTO kqp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wôsa kwôni wo dô sari ta ba, bay ɗeréri tôŋ niɲba, kwo dôbe sari ba, bay a biri derê sari ta men.» ");
INSERT INTO kqp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Menba, Jésu kôliɲ gawra wo uwôgaji hen iyôŋ ba: «Kiriɲa ju uwôge ɓiɲé wo emê na, uwôge milɲêm ré men, yênêm ré men, balêm ré men, bay uɲé kaɲ bay kwam hen né a men, wôsa bay kôba, a herê uwôgem gôɲiɲ tu uwôgê wo ju uwôgeji hen, aɲ hô têbem merênê wom ta. ");
INSERT INTO kqp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Niɲba, kiriɲa ju uwôge ɓiɲé wô emê naɲ sa geserê na, uwôge bay nimré men, bay merayê men, bay moré men, bay tu tiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aɲ já uɲé yi derê wôsa bay nêm uwôgemare gôɲiɲ tu ré, aɲ Emen a sa têbem sa kôm wulê wo ɓiɲé ka li are derôre a jiɲ kiriɲ sé kamɲê hen.» ");
INSERT INTO kqp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kiriɲa Jésu kôl hen menba, gawra wo pôni perê ɓiɲé ka ôbi uwôgeji hen kôli iyôŋ ba: «Yi derê yi wô sa kwôni wo ôm emê bi wo hen bô *emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Menba, Jésu kôli iyôŋ ba: «Gawra wo pôni ɗa lê aŋgaɲ emê menba, ôbi ré uwôgerê ɓiɲé kwône. ");
INSERT INTO kqp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kiriɲa tay emê nêm menba, ôbi jé mana wori ré ô kôliɲ ɓiɲé ka ôbi uwôgeji hen iyôŋ ba: ‹Eraŋge haŋge niɲ, wôsa emê na kô niɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Menba, ɓiɲé bay ka hen, kaɲji pôn pôn kêm. Kwo tumô kôli iyôŋ ba: ‹En kel yagê wo kerbay aɲ na erê ô gelé ɗiba na biɲ né, ɗi bôm jal.› ");
INSERT INTO kqp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kwo ɗaŋgi kôl iyôŋ ba: ‹En kelo kelbê môj aɲ na erê séléji gelé ɗiba, na biɲ né, ɗi bôm jal.› ");
INSERT INTO kqp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kwo ɗaŋgi kôl iyôŋ ba: ‹En gô iyére haw ɗiba, na erê ré.› ");
INSERT INTO kqp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mana bi wo hen bulo hera sa kôliɲ ôbi iyéyri kwôlo bay kelari hen. Menba, bôri tari menba, ôbi kôliɲ mana wori iyôŋ ba: ‹Ô haw hen gêgêr a men, tô geré a a men ju ô uwôgera bay nimré men, bay merayê men, bay tu tiɲ men, bay moré a men.› ");
INSERT INTO kqp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mana bi wo hen ô aɲ hera sa kôli iyôŋ ba: ‹Kelma, nini uwôgeraji mega wo ju kelêni hen iyôŋ, niɲba, kiriɲ hô baa ya sôŋ.› ");
INSERT INTO kqp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ôbi kôli iyôŋ ba: ‹Hô hô geré wo ô si nono hen men, ô si bô yagê hen uwôla ɓiɲé bi ré era aɲ bi bô iyére tiɲê ré wôn dô. ");
INSERT INTO kqp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wôsa en kelêŋge kwôni pôn perê ka na en uwôgeji tumô hen, a hebé emê wuɲê bi wo hen kibri a ré.› » ");
INSERT INTO kqp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kwônê ɓiɲé ɓu geré naɲ Jésu menba, ôbi bul kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Hena kwôni ré gey era legen a aɲa ré gey ibari ɗên men, gey yori ɗên men, gey tamni ɗên men, gey kamni ɗên men, gey yênêri ɗên men, gey yiri gaŋ ɗên a men na, a nêmê yé ôbi tôn biɲ né. ");
INSERT INTO kqp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kwôni wo ay gurô tagelê wori aɲ ôriɲ tôn a ré na, a nêmê yé ôbi tôn biɲ né. ");
INSERT INTO kqp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na i a perêrŋge a hen, hena ré gey ɗé iyére to dami ba, a merê tôŋ gengé ari lêêre kêm gelé hena ré nêm lê kerê dema ré ay tôre tô ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hen iyôŋ né ba, tôre a ɗiɲ mera menba, ɗére a gelê taa aɲ ɓiɲé gel hen iyôŋ menba, bay a ayrêri. ");
INSERT INTO kqp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Aɲ bay a kelê iyôŋ ba: ‹Gel, gawra ay tô ɗé iyére menba, nêm ɗé kerê ré yi hen!› ");
INSERT INTO kqp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Réba kelma wo yôŋ a kiriɲa ɗa lê kumbul naɲ kwo ɗaŋgi ba, a gelé na ba, naɲ gawrê dubu môj ba, ré nêmê lê kumbul naɲ gawrê dubu tôre wôô ba, ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A hena ôbi ré bô mega ɗiré nêmê ré na, kiriɲa kwoɲ ôbi bayri hen ba, kelaŋ tô ba, ôbi jé gawrê kari ô eŋgeré bi ciré biɲ tôŋ né ba? ");
INSERT INTO kqp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iyôŋ na, hena kwôni perêrŋge a hen, né ɗéɲ ari uɲéri kêm né ba, a nêmê yé ôbi tôn né.» ");
INSERT INTO kqp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ɗôre na aŋga dôri, niɲba, hena hende to hen ré geraŋ ré ba, bay a lere iyeŋ a ré herê geraŋgê hôriɲ ba? ");
INSERT INTO kqp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kwôni a liɲ ani ré niɲ, dô wô terare ré men, wô bê a sa kaɲ lari a ré a men, bay a bêɲ na bêɲare ɗô mera. Kwo mari ya, aɲa ré gey toyé kwôlê bi wo hen ba, bi toy.» ");
INSERT INTO kqp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","*Bay eŋgé wôgê naɲ ɓiɲé kaɲ bay lê têriɲ eraji ligi Jésu a kêm wô toyé kwôlê wori. ");
INSERT INTO kqp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Menba *Parisiɲêɲê naɲ bay derê tô tôô to Emen ɲamniɲ kôl iyôŋ ba: «Gawra wo hen, ɓu bay têriɲ yiri a men, ôm are naɲ ci a men!» ");
INSERT INTO kqp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Menba Jésu kôlji gwosoy kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«I a perêrŋge a hen aɲa ré naɲ gamgê arew aɲa kwo pôni ré ge kay aɲa ôbi ré ɗé ka tôre deŋgêse kibi deŋgêse hen nono aɲ erê wogé kwo pôn bi wo ge kay hen kwôy wo ôbi a uwôɲiɲni ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kiriɲa ôbi uwoɲni na, ôbi ayari da a tôri a naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aɲ kiriɲa ôbi eraɲ uwoɲ ba, dayrê milɲéri men, bay kwari a men, aɲ kôlji iyôŋ ba: ‹Lêŋge yi derê naɲ en, wôsa en uwôɲ gemga wuɲê wo na ge kay hen niɲ.› » ");
INSERT INTO kqp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Menba, Jésu kôlji iyôŋ ba: «En kelêŋge, na hen iyôŋ a yi derê ré yé derômaraŋ a wô kibi ôbi têriɲ pôn nêŋ wo bul cêgeri biɲ têriɲ tori, ɗê ka tôre deŋgêse kibi deŋgêse kaɲ bay lê aŋgaɲ derôre ka ôriɲ doy belé cêgereji biɲ têriɲ toji ré hen.» ");
INSERT INTO kqp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Iyore to yôŋ a naɲ selé môj aɲa ré to pôni ré kuriɲ kay aɲa hende ré ɗé tare bô lampa a men, labê bô iyére men, kibê kiriɲ kwôy wo hende uwôɲiɲ selé tore hende to hen né ba? ");
INSERT INTO kqp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kiriɲa hende uwôɲ menba, dayrê milɲére naɲ bay kware aɲ kôlji iyôŋ ba: ‹Lêŋge yi derê naɲ en wôsa en uwôɲ selé tiɲê to na kuriɲ kay hen niɲ.› » ");
INSERT INTO kqp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Menba, Jésu kôlji iyôŋ ba: «En kelêŋge, na hen iyôŋ a manê ka Emen ré lê yi derê wô kibi ôbi têriɲ pôn nêŋ wo bul cêgeri biɲ têriɲ tori.» ");
INSERT INTO kqp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jésu hô kôl gwosoy kwôlo ɗaŋgi kôl iyôŋ ba: «Gawra wo pôni naɲ kamni kaɲ imɲê wôô. ");
INSERT INTO kqp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kwo dê kôliɲ ibari iyôŋ ba: ‹Iban, ben aŋgaɲ cibré ka ju genge lê jeré ben kiriɲa tum né naɲ hen.› Menba, ibarji céji are bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sem cêgi are bay ka ôbi uwôɲ hen menba, ôbi keléɲ aŋgari bay ka hen aɲ henaɲ naɲ larirji ôriɲ kelaŋ sa iyére to ɗaŋgi a ô mênê are bay ka hen kaŋ aɲ sa aŋgaɲ iyôŋ tôŋ a. ");
INSERT INTO kqp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kiriɲa ôbi mêne are bay ka hen kaŋ kô niɲ na, kurôŋ wo dami kuriɲ sa terare hende to ôbi ô ya hen, menba, nimrére kuriɲ uɲéri hare niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ôbi ô eŋgeré jé, iyé gawra wo pôni wo sa terare hende to hen a menba, gawra bi wo hen jéri ô gemé gwôsiɲô nono. ");
INSERT INTO kqp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bôri gey emê aŋga gwôsiɲô ôm hen niɲba, kwôni biri ré. ");
INSERT INTO kqp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ôbi erem ɗé ɗé aɲ kôl iyôŋ ba: ‹Bay lê jé na yere iyeŋ iyé iban a ôm emê gôlji tôŋ aɲa nôbi kurôŋ ré deren na men ba? ");
INSERT INTO kqp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na erê ligi iban a, aɲ na kôli iyôŋ ba: «Iban, en li têriɲ naɲ Emen men, naɲ ju a men. ");
INSERT INTO kqp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","En nêm wo jeré uwôgen kemam ré niɲ. Niɲba, ju bôren mega ôbi lê jé wom iyôŋ ɗi.» › ");
INSERT INTO kqp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ôbi hena ô ligi ibari a.» «Kiriɲa ôbi baa kelaŋ tô menba, ibari gili menba, bô tu ɲa tori aɲ ge jô kwini aɲ ɓiri pêb a kabrêri a. ");
INSERT INTO kqp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Menba, kemari kôli iyôŋ ba: ‹Iban, en li têriɲ naɲ Emen men, naɲ ju a men. En nêm wo jeré uwôgen kemam ré niɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Niɲba, ibari kôliɲ manê kari iyôŋ ba: ‹Eraɲge naɲ bargay ka dôri lew ken tôbri men, dôbêŋgeri gamaŋ kôbri a men, garbê têri a a men. ");
INSERT INTO kqp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɓuroŋge kema kelba wo uwor dô hen, ken duu na emêŋge liɲ yi derê, ");
INSERT INTO kqp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","wôsa keman wo nà ná, yi mega na ré ma iyôŋ aɲa ré hô gôl hen men, ôbi na ge kay niɲba, en uwoɲni.› Menba, bay ay tô lê yi derê.» ");
INSERT INTO kqp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Kemari wo iyêri ré baa nono. Kiriɲa ôbi uwo ɗa naɲ iyére menba, toy né deré men, wôrê men. ");
INSERT INTO kqp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ôbi uwôge mana wo pôni eŋgereri mi a ré lê are ba? ");
INSERT INTO kqp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Menba, mana bi wo hen kôli iyôŋ ba: ‹Na yênem a uwo aɲa ibam né duu kema kelba wo uwori hen, wôsa ôbi ré uwo naɲ derêri.› ");
INSERT INTO kqp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Menba, bôri tari aɲ ôbi gey erê ira ré. Niɲba, ibari so sa uwôlêri. ");
INSERT INTO kqp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Menba, ôbi kôliɲ ibari iyôŋ ba: ‹En li jé naɲ ju elê kwône, niɲba, sa pôn iyôŋ kôba, en na kwôlê kem a ré. Men, kema kwa wôni iyôŋ kôba, ju ben en duu liɲ yi derê naɲ milɲên né a men. ");
INSERT INTO kqp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Niɲba, kiriɲa kemam wo hen wo na pô aŋgam ô mênê aɲ sa yébé hera menba, ju duu kema kelba wo uwori hen biri.› ");
INSERT INTO kqp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Menba, ibari kôli iyôŋ ba: ‹Keman, jôbi ju mô naɲ en kwôy kwôy men, aŋgaɲê kêm na kam a men. ");
INSERT INTO kqp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Niɲba, dô bi na emêŋge men, na lêŋge yi derê wôsa yênem wo nà ná, na ma aɲa ré hô gôl hen men, ôbi na ge kay aɲ en hô uwoɲni.› » ");
INSERT INTO kqp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Gawra woɲ ôbi uɲé wo pôni ôriɲ naɲ ôbi gemé uɲé wori bi wo hen. Bay ô kôli ôbi gemé uɲé wori bi wo hen ré mênê aŋgari. ");
INSERT INTO kqp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Menba, ôbi jé uwôgari aɲ kôli iyôŋ ba: ‹En toy kwôlê gaɲ gengiɲ sam. Gelen tô aŋgaɲê na gelé wôsa já yé ôbi gemé aŋgaɲê ré niɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Menba, ôbi gemé aŋgari bi wo hen, kôl bôri a iyôŋ ba: ‹Na lê iyeŋ a ôbi iyéren ré dagen kini jé na ba? Yagê ré néén nêm né. Erê dôsê ré dii tayre. ");
INSERT INTO kqp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","En hôn aŋga na lê, aɲ kiriɲa ôbi dagen bô jé ba, bi ɓiɲé ka pôni ɓeren a yirji a.› ");
INSERT INTO kqp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ôbi jé uwôgerê ɓiɲé ka telare sarji a hen pôn pôn aɲ ôbi eŋgeriɲ kwo tumô hen iyôŋ ba: ‹Telare to gawra wuɲê na iyeŋ sam a ba?› ");
INSERT INTO kqp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ôbi uwôli sara iyôŋ ba: ‹Na todeleŋ weŋ olibiyé arew.› Ôbi gemé are bay ka hen kôli iyôŋ ba: ‹Gel, magtubu tom a nà, mô tôŋ lew aɲ ju mêne kwo cay hen aɲ ju ɗi ré na tôre bay.› ");
INSERT INTO kqp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ôbi hô eŋgere kwo ɗaŋgi iyôŋ ba: ‹A jôbi tom na iyeŋ ba?› Ôbi uwôli sara iyôŋ ba: ‹Na sewal kaw arew.› Ôbi gemé are bay ka hen kôli iyôŋ ba: ‹Gel, magtubu tom a nà, mô tôŋ lew ju mêne kwo cay hen aɲ ju ɗi ré na tôre marge.› ");
INSERT INTO kqp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Menba, ôbi iyéy are na, den ôbi gemé are woɲ ôbi benare bi wo hen, wôsa ôbi li are naɲ gwosore. Ôbi a, ɓiɲé ka sa terare a nà ré melên naɲ megêrji ɗê ka mô kiriɲ ka peraŋgi a hen.» ");
INSERT INTO kqp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Hena kené ôriɲ naɲ ari uɲé ka sa terare a nà ná, ken ɓeriɲ baliyare naɲ ɓiɲé aɲ kiriɲa ari uɲé bay ka hen naɲ niɲ ná, bay a ɓeréŋge yirji a kiriɲ ka yi naɲ kwiniji hen. ");
INSERT INTO kqp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kwôni wo cube tiri sa aŋga dê ka yi kôbri a hen na, ka mêêy kôba, ôbi a cibé tiri tôre a hen iyôŋ men. Niɲba, kwo cube tiri tô ka dê dê a naɲ geréri ré na, ka mêêy kôba, ôbi a lê naɲ tô geréri ré iyôŋ a. ");
INSERT INTO kqp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hena aŋgaɲ uɲé ka sa terare a na kôba, ken li naɲ gerérji ré hen ba, i a béŋge gemé aŋgaɲ uɲé kaɲ tiri hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hena kené gem aŋga kwôni wo ɗaŋgi dô ré hen ba, i a béŋge kaŋge kaɲ yerŋge ba?» ");
INSERT INTO kqp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Mana pôn nêŋ a lê jé biɲ bay iyéyri wôô ré: dô ré ba, ôbi a tôrɲê kwo pôn aɲ periɲ kwo pôni, réba a ɗé yiri yi kwo pôni a aɲ kaɲê kwo pôni. Ka nêmê lê jé biɲ Emen men, gursu a men né.» ");
INSERT INTO kqp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Parisiɲêɲê ka gey gursu gaɲ hen toy kwôlê bi wo kêm hen iyôŋ menba, ayrêji Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Menba, Jésu kôlji iyôŋ ba: «Kenbay ken li yerŋge môɲ ɓiɲé kaɲ derôre iyôŋ tu gawrê niɲba, Emen hôn bôrŋge, aŋga gawra bô mega aŋga dami hen na, tu Emen a ba, na aŋgaɲ iɲamê.» ");
INSERT INTO kqp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Menba, Jésu hô kôlji iyôŋ ba: «Tôô to *Moyis naɲ kwôlo bay kibi Emen na, na aŋga ɓiɲé na liɲ jé mera kwôy saɲ sa Ja ôbi lê batêm a. Aɲ ayiɲ tôri kiriɲ bay ka hen na, béré kwôli *emê iyére to Emen uwôliɲ aɲ gawra wo yôŋ yôŋ ba, woge sé bôô naɲ néri. ");
INSERT INTO kqp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Derômaraŋ naɲ sa terare a dêji jerê lew, niɲba ani ka tôô ka dê iyôŋ ley, kam aŋga cibiɲ dê dê sara hen ley, ka a dôriɲ aɲ ba naɲ kwôy.» ");
INSERT INTO kqp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Kwôni wo dage tamni aɲ eŋgiɲ to ɗaŋgi na, ôbi yiɲ na yiɲare toɲ têriɲ hen men, kwôni wo eŋge iyore to kurôre dagere hen kôba, ôbi yiɲ na yiɲare toɲ têriɲ hen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Sa pôn gawra wo pôni na ôbi uɲé. Ôbi tôbe bargay ka gararji mê mê men, sôŋriɲ dô a men. Sa pôn pôn bô iyére tori a na, na emê naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lajar na ôbi nimré wo yiri kêm yi iyare men, kini merêri na kibi iyé ôbi uɲé bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ôbi gey emê habelê kwô wo heriɲ tô kibi ôbi uɲé hen, niɲba, ôbi uwôɲ né. Garê kôba era sa lê tu iyare tori hende to hen men. ");
INSERT INTO kqp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ôbi nimré bi wo hen ma aɲ bay emni menba, manê ka derômaraŋ sa ay tini ôriɲ ligi *Abraham a. Ôbi uɲé kôba ma men aɲ bay emni. ");
INSERT INTO kqp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kini merê bay temare a, kiriɲa ôbi mô bô gusiɲ a menba, ay tiri menba, gel Abraham naɲ Lajar kwari a. ");
INSERT INTO kqp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Menba, ôbi jô gura kôl iyôŋ ba: ‹Iban Abraham, bô tu ɲa tiɲê aɲ jé Lajar ô dôbê kema kôbri bô kam a aɲ era sa jaliɲ tôn wôsa en geliɲ gusiɲ bô tare a na.› ");
INSERT INTO kqp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Menba, Abraham kôli iyôŋ ba: ‹Keman, erem mega wo na jeré mô bô ari uɲé a, kiriɲa na ju baɲ sa terare a nà, menba, Lajar ba, na môriɲ bô nimrére a aɲ haw hen, bay jal bôri nà, menba, jôbi ju mô bô gusiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Men, perêrŋge kenbay a naɲ nibay na, iyom wo dami yi ya aɲ kwôni wo gey hena si ligirni wô erê uɲéŋge ba, a nêmê ré men, kwo hena si legerŋge wô era si ligirni kôba, a nêmê ré a men.› ");
INSERT INTO kqp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ôbi uɲé na, kôli iyôŋ ba: ‹En uwôlem iban, jé Lajar iyé iban a ");
INSERT INTO kqp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wôsa yênên baa bay ya, bi ré ô kôlji bi bay ré era kiriɲ kaɲ gusiɲ ka en môriɲ ya nà ré.› ");
INSERT INTO kqp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Menba, Abraham kôli iyôŋ ba: ‹Magtubu to Moyis naɲ to bay kibi Emen yaŋ ya, bi bay bi kwôlê sara.› ");
INSERT INTO kqp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ôbi hô kôli iyôŋ ba: ‹Eŋ eŋ, nêm né tô iban Abraham, hena kwôni wo ma ré hô ligirji a ba, bay a uwôlê bô jalê sa têriɲ lêreji a.› ");
INSERT INTO kqp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Menba, Abraham kôli iyôŋ ba: ‹Hena bay ré toy kwôlê kibi Moyis a naɲ kibi bay kibi Emen ré ná, hena kwôni wo may ré ji si kamɲê kôba, bay a toyé kwôlê kibri a ré.› » ");
INSERT INTO kqp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jésu kôliɲ bay tôri iyôŋ ba: «Are kwône ka a lê aɲ gawra a liɲ têriɲ môj môj. Niɲba, gusiɲ yi wô kwôni wo li aɲa megari ré kuriɲ hen. ");
INSERT INTO kqp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hena bay ré hari keram wo dami a tôri a, aɲ bay ré uwôli a bô cér a, kôba, na aŋga dê gôliɲ gusiɲ to Emen a sa gili hena ôbi ré li kwo iya wôni ré kuriɲ. ");
INSERT INTO kqp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɗebéŋge sa têrŋge a.» «Hena yênem ré li têriɲ naɲ ju ba, ju kôli, hena ôbi ré uwôlem bô jalê ba, ju ɗi bôm jal sari a. ");
INSERT INTO kqp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Men, hena tu tare pôn a ôbi ré li têriɲ naɲ ju têê jurgem aɲa têê jurgem iyôŋ a ôbi ré uwôlem bô jalê na, ju ɗi bôm jal sari a.» ");
INSERT INTO kqp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bay jé kôliɲ Kelma iyôŋ ba: «Bi bi ayê bôô woni ô tumô.» ");
INSERT INTO kqp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kelma kôl iyôŋ ba: «Hena henaŋ ayê bôô woŋge ré dê mega gusiɲ siwre iyôŋ aɲa henaŋ kené kôliɲ gurô wo hen iyôŋ ba: ‹Dôriɲ naɲ hanêm ju ô ɗebé bô cér a› na, ôbi a bê kwôlê sara.» ");
INSERT INTO kqp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«I a perêrŋge hen a, ré ôriɲ naɲ mana wo uwo tô yagê ley, tô gemé lari a ley ba, a kôli iyôŋ ba: ‹Era lew ju sa ôm are ba?› ");
INSERT INTO kqp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ôbi a kôli na iyôŋ ba: ‹Ô ju ô lê emê ben, tôbe bargay kaɲ cé emê aɲ kiriɲa na emê men, yê men, niɲ na, jôbi ju ô emê men, yê men, ham niɲ ré ba?› ");
INSERT INTO kqp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hen ba, bay diini wô jé bi wo bay kôli ré li hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kenbay kôba, kiriɲa ken li aŋga kêm ka Emen kelêŋge kené li hen na, kelêŋge iyôŋ ba: ‹Nina bay jé ɗéɲ iyôŋ nini li aŋga Emen kelêni niné li mera.› » ");
INSERT INTO kqp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jésu ay si jeŋgê Samari naɲ Galilé wô erê Jérusalêm. ");
INSERT INTO kqp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kiriɲa ôbi biɲ sa iyére to pôni a menba, bay *terbare môj jôrji kwini. Bay ɗebu sêd wolé. ");
INSERT INTO kqp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bay kôli kaŋ a ta kôl iyôŋ ba: «Rabi, Jésu, bô tu ɲa toni men.» ");
INSERT INTO kqp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Menba, Jésu gelji menba, kôlji iyôŋ ba: «Ô ken ô geliɲ bay bê kwôbe yerŋge bi ôbi hôn wo kené berare.» Kiriɲa bay ô menba, bay berare. ");
INSERT INTO kqp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kiriɲa kwo pôni gel wo ɗiré berare hen iyôŋ menba, bulo hera heram Emen naɲ tôri to dami. ");
INSERT INTO kqp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ôbi jubu gubari diɲ kwini tôŋ tumô Jésu a liri dosé, gawra bi wo hen na, na kwo Samari. ");
INSERT INTO kqp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Menba, Jésu eŋgereri iyôŋ ba: «Ken berare môj kêm né ba? Menba, ka deŋgêse hen yôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kwôni pôn iyôŋ perê ka deŋgêse a hen erem wô heramê Emen né: aɲ na kerga wo nà, a hera mera!» ");
INSERT INTO kqp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Menba Jésu kôli iyôŋ ba: «Hena ta ju ô. Ayê bôô wom berarem.» ");
INSERT INTO kqp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Menba, *Parisiɲêɲê eŋgereriɲ Jésu iyôŋ ba: «Wulê wo yôŋ a emê iyére to Emen hende to hen ré saɲ ba?» Menba, Jésu kôlji iyôŋ ba: «Emê iyére to Emen a sa mega aŋga ken gel naɲ turŋge hen né. ");
INSERT INTO kqp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kwôni a kelê: ‹Gel, ôbi a nà›, ‹ôbi a yaŋ› hen iyôŋ né. Henêŋge wo emê iyére to Emen ré perêrŋge a nà niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Menba, Jésu kôliɲ bay tôri iyôŋ ba: «Wulê wo era hen na, ka ôriɲ doyi gelen nôbi *Kema Gawra sa pôn nêŋ iyôŋ haŋge kôba, ka gelen ré. ");
INSERT INTO kqp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Menba, bay a kelêŋge iyôŋ ba: ‹Ôbi ná nà›, ‹ôbi ná yaŋ.› Erêŋge ré men, ken jaar ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wôsa kiriɲa emen wulaɲ ba, berare derômaraŋ kêm aɲ ɓiɲé kêm gel hen iyôŋ na, wulê wuɲê nôbi Kema Gawra kôba, a geliɲ na hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Niɲba, pa dema wulê bi wo hen ré sa tô ná, na geliɲ gusiɲ damaŋ men, ɓiɲé ka haw hen a kaɲen a men. ");
INSERT INTO kqp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Wulê wo nôbi Kema Gawra na heraɲ hen na, are a yé mega na yiɲ bô wulê wo Nowé a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɓiɲé na ôm men, yi men, eŋgiɲ yirji men, ɗi kamniji kaɲ yébé eŋge imɲê a men, kwôy wulê wo Nowé siɲ bô bato tori a menba, kam bélem sa ay kiriɲ aɲ ɓiɲé kêm ma. ");
INSERT INTO kqp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Men, mega wulê wo Lôt iyôŋ na, ɓiɲé na ôm men, na yi men, ka na kel men, ka na ɗi gara men, ka na ban men, ka na ɗi iyére men. ");
INSERT INTO kqp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Niɲba, wulê wo Lôt siɲ aɲ *Sodôm a menba, Emen bi tare naɲ pudur mega to bunu a iyôŋ hena derômaraŋ a uwôŋge aɲ derji kêm aɲ. ");
INSERT INTO kqp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","A yé geliɲ hen iyôŋ wulê wo nôbi Kema Gawra na gelé yen nô.» ");
INSERT INTO kqp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Wulê bi wo hen na, kwôni wo mô tô tunu a nô ba, bi era ira wô erê ayê ani bô iyére tori a ré niɲ men, kwôni wo ɗebe bô yagê ba bi hera uwo ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Erméŋge sa aŋga na sa sa tami Lôt a hen. ");
INSERT INTO kqp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kwôni wo gey gemé yiri ba, a mênêri men, kwo mênêri ba, a gôliɲ naɲ ɗi men. ");
INSERT INTO kqp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","En kelêŋge bô yoyre hende to hen na, ɓiɲé wôô yi sa kalaŋ a ɓem ba, kwo pôn a ayiɲ menba, kwo pôni a baa tôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yébé wôô a ɗebé uwoyé kuré ɓem menba, to pôn a ayiɲ menba, to pôni a baa tôŋ.  ");
INSERT INTO kqp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Imɲê wôô a ɗebé yagê ɓem menba, kwo pôn a ayiɲ menba, kwo pôni a baa tôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Menba, bay tôri eŋgereri iyôŋ ba: «Na yôŋ a are bay ka hen ré yé ya ba?» Menba, ôbi uwôlji sara iyôŋ ba: «Na kiriɲ ka temay are yi ya a, dunu ré daɲ ya men.» ");
INSERT INTO kqp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Menba, Jésu hô kôlji gwosoy kwôlo ɗaŋgi wô geléji bi bay ré uwôl Emen ta ta ɗiba, bi bay ré ɗi bôrji mêne ré. ");
INSERT INTO kqp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ôbi kôlji iyôŋ ba: «Sa iyére to pôni a na, ôbi jerê kwôlê wo pôni mô ya, ôbi hariɲ Emen né men, erem sa kwôni a ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mamne to pôni mô sa iyére hende to hen men, hende era sa pôn pôn sa kôli iyôŋ ba: ‹Jerêni kwôlê woni nibay naɲ ôbi baren wo na.› ");
INSERT INTO kqp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Têê kwône ôbi kaɲ menba, ôbi kôl iyôŋ ba: ‹Hena ené hariɲ Emen né men, erem sa kwôni a ré a men, kôba, ");
INSERT INTO kqp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wô dôyrê wo mamne hende to hen dôyren hen na, naa jerê kwôlê bi wo hen biji aɲ bi hende hera sa dôyren ré niɲ.› » ");
INSERT INTO kqp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kelma hô kôlji iyôŋ ba: «Toyéŋge dô kwôlo ôbi jerê kwôlê bi wo habiɲ hen kôl hen. ");
INSERT INTO kqp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hen ba, Emen dem a ré jerê kwôlê biɲ ɓiɲé ka ôbi tôrji ka sôm uwôgeri yoyre naɲ tu tare hen bi ôbi ré lê naɲ ci hen ré ba? ");
INSERT INTO kqp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","En kelêŋge, ôbi a hena lew jerê kwôlê bi wo biɲ biji. Niɲba, kiriɲa nôbi *Kema Gawra na bulo hera ba, na uɲé ayê bôô wôni sa terare a nà pa pa ba?» ");
INSERT INTO kqp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jésu hô kôl gwosore to ɗaŋgi wô sa ɓiɲé ka bô yirji môɲ ciré na kaɲ derôre tu Emen a aɲ bô megêrji môɲ ani ré hen. ");
INSERT INTO kqp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ôbi kôl iyôŋ ba: «Ɓiɲé wôô ôrji bô *iyéy Emen a wô uwôlê Emen, kwo pôni na *Parisiɲê men, kwo pôni na *ôbi eŋgé wôgê men. ");
INSERT INTO kqp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kwoɲ Parisiɲê hen, ɗebu ta aɲ uwôl Emen kôl iyôŋ ba: ‹Emen, en lêm dosé wôsa en yi mega tô gawrê ka baa hen ka na bay gemsare men, bay bô habrê men, bay wôniɲ wôniɲare toɲ iyôŋ a tôŋ hen né men, en yi môɲ ôbi eŋgé wôgê wo hen né a men. ");
INSERT INTO kqp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","En jôriɲ bôn kurôŋ têê wôô bô demas a men, en bi kibi aŋga môj kaɲê kêm ka en uwôɲ hen a men.› ");
INSERT INTO kqp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Menba, ôbi eŋgé wôgê dô tôri sêd aɲ, aɲ berê kiriɲ si derômaraŋ kôba, ôbi gey ré, niɲba, sê deŋgôri ɓera ɓera kôl iyôŋ ba: ‹Emen, bô tu ɲa tiɲê wôsa ena ôbi têriɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","En kelêŋge, ôbi hô iɲ sari seŋge wôsa têriɲ tori dôriɲ sari a, niɲba, kwoɲ Parisiɲê hen na, tori dôriɲ sari a ré, wôsa kwôni wo dô sari ta ba, bay a ɗeréri tôŋ men, kwo dôbe sari ba, bay a biri derê sari ta men.» ");
INSERT INTO kqp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɓiɲé eraɲ naɲ kamrê ka dê dê bi Jésu ré uwôl kôbri sarji a. Kiriɲa bay tôri gel hen iyôŋ menba, bay nay ɓiɲé bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Niɲba, Jésu biji bay eraɲ naɲ ci aɲ kôl iyôŋ ba: «Ɗéŋge kamrê era yen a, ɗiba, ken jôreŋgeji ré, wôsa *emê iyére to Emen yi gengiɲ sa ɓiɲé ka yi mega kamrê bay ka hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na tu kwôlê a ené kelêŋge hen, kwôni wo gey bi Emen né yi kelma wori mega kema wo dê liɲ hen iyôŋ ré na, ôbi a ulê têri bô emê iyére tori a ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Menba, kelma wo Jubɲê wo pôni eŋgeriɲ Jésu iyôŋ ba: «*Rabi wo dôri, na mi a ené lê aɲa ené môriɲ tu geɲ naɲ kunun ba?» ");
INSERT INTO kqp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Menba, Jésu kôli iyôŋ ba: «Wô mi a jeré uwôgen kwo dôri ba? Kwôni wo dôri naɲ Emen pôn nêŋ a na kwo dôri. ");
INSERT INTO kqp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ju hôn tôô to Emen na ay kôl iyôŋ ba: ‹Yiɲ yiɲare toɲ têriɲ ré men, duu temare ré men, gômse ré men, kôl kwôlê woɲ benare ɗi sa ɓiɲé ré men, biɲ ibam naɲ yom kwôlê a men.› » ");
INSERT INTO kqp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Menba, ôbi uwôli sara iyôŋ ba: «En li tôô hende to kêm hen naɲ kamɲên yeŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kiriɲa Jésu toy hen iyôŋ menba, kôli iyôŋ ba: «Aŋga pôni bam ya, kel are uɲé kam aɲ, aɲ larirji ba, ju céɲ bay nimré aɲ já uɲé ari uɲé derômaraŋ a menba, jôbi ju era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kiriɲa ôbi toy hen iyôŋ menba, tiri mêne damaŋ, wôsa ari uɲé kari mê gaɲ. ");
INSERT INTO kqp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jésu bôri aɲ kôl iyôŋ ba: «Sé bô emê iyére to Emen a na, iyêre naɲ bay uɲé. ");
INSERT INTO kqp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jambal a sé lew si tu iyom libra, gôliɲ ôbi uɲé bi ré si bô emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓiɲé ka mô ya toy hen, kôl iyôŋ ba: «Iyôŋ niɲ ba, i a uɲé gelê ba?» ");
INSERT INTO kqp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jésu kôl iyôŋ ba: «Aŋga gawra nêm lê ré ba, Emen nêm lê.» ");
INSERT INTO kqp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyêr kôl iyôŋ ba: «A nibay ka nini ɗéɲ ari uɲérni kêm aɲ eraɲ tôm a hen ba, kwoni ba, a yé iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jésu uwôli sara iyôŋ ba: «Na tu kwôlê a ené ena kelêŋge hen, hena kwôni ré ɗéɲ iyére tori, tamni, yênêri, balêri, naɲ kamni wô sa emê iyére to Emen na, ");
INSERT INTO kqp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a uɲé ɗê ka hen haw hen kiriɲ bay ka hen, aɲ wulê wo ɗaŋgi a ba, ôbi a merê tu geɲ naɲ kwini a men.» ");
INSERT INTO kqp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jésu ôriɲ naɲ bay tôri ka môj kibi wôô hen wolé aɲ kôlji iyôŋ ba: «Nana erêŋge na Jérusalêm a hen aɲ kwôlo bay kibi Emen na li bô magtubu a gengiɲ san nôbi Kema Gawra hen na, ariri a liɲ. ");
INSERT INTO kqp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wôsa bay a nôgen biɲ ɓiɲé ka na Jubɲê ré hen aɲ bay a ayren men, teren men, teben kalê tun a a men. ");
INSERT INTO kqp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kiriɲa bay a sên menba, bay a deren aɲ sa wôô, subu tori menba, na jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Menba, bay tôri hôn bô kwôlo ôbi kôlji hen né, wôsa bô kwôlê hen iyêre naɲ ci aɲ bay hôn kwôlo Jésu ɗa kelê hen né. ");
INSERT INTO kqp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jésu era ba ɗa naɲ Jériko menba, ôbi tu tiɲ pôni mô bêŋgê geré wô uwôlê are. ");
INSERT INTO kqp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ôbi toy né kwônê ɓiɲé ka ô hen menba, ôbi eŋgere ré na mi ba? ");
INSERT INTO kqp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Menba, bay kôli iyôŋ ba: «Na Jésu wo Najarêt a erê hen.» ");
INSERT INTO kqp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Menba, ôbi uwôgiri kaŋ a ta kôl iyôŋ ba: «Jésu, kuŋga *kelma Dabid, bô tu ɲa tiɲê.» ");
INSERT INTO kqp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓiɲé ka ô tumô hen ôni bi ôbi ré wôm tôŋ, niɲba, ôbi hô ôm naɲ néri a, kôl iyôŋ ba: «Kuŋga kelma Dabid, bô tu ɲa tiɲê». ");
INSERT INTO kqp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jésu ɗebu tôŋ aɲ kôl bay ré eraɲ naɲ ɗi. Kiriɲa ôbi era ɗa menba, Jésu eŋgereri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Na mi a jeré gey bi ené li bem ba?» Menba, ôbi kôli iyôŋ ba: «Kelma, en gey gelé kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Menba, Jésu kôli iyôŋ ba: «Gel kiriɲ. Ayê bôô wom gôliɲ naɲ ju.» ");
INSERT INTO kqp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Menba, kiriɲ bay ka hen na, ôbi gel kiriɲ aɲ ô tô Jésu a heramiɲ Emen. Ɓiɲé kêm ka gel hen iyôŋ menba, bay heram Emen men. ");
INSERT INTO kqp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jésu sa biɲ Jériko menba, way perê iyére ôriɲ hen iyôŋ menba, ");
INSERT INTO kqp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kiriɲ bay ka hen na, gawra wo pôni bay uwôgeri Jasé ôbi na ôbi sa *bay eŋgé wôgê men, na ôbi uɲé a men. ");
INSERT INTO kqp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ôbi woge ɗiré gelé i a ré na Jésu ba, niɲba, ôbi nêm né, wô kwônê ɓiɲé wôsa ôbi na menay. ");
INSERT INTO kqp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ôbi ge tumô ô ɗayê bô ɓôliɲ a wô gelé Jésu, wôsa ôbi a ayê na si kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kiriɲa Jésu sa kiriɲ bay ka hen menba, ay tiri gili menba, kôli iyôŋ ba: «Jasé, herbo tôŋ lew, na erê wulê iyére tom a kemnêŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jasé herbo tôŋ lew aɲ ɓu Jésu yiri a naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kiriɲa ɓiɲé gel hen iyôŋ, menba, bay ɲamniɲ kôl iyôŋ ba: «Na iyé ôbi têriɲ a, ôbi ré ô yé ya.» ");
INSERT INTO kqp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Menba, Jasé hena ɗebu ta kôliɲ Kelma iyôŋ ba: «Na biɲ bay nimré kwa ari uɲéren men, hena na ené ôm aŋga kwôni wugem ba, na hô têbri hôriɲ têê pôrbu.» ");
INSERT INTO kqp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Menba, Jésu kôlji iyôŋ ba: «Kemnêŋ ɓiɲé ka bô iyére to na uwôɲ gelê wo Emen, wôsa ôbi kôba, na kuŋga *Abraham men. ");
INSERT INTO kqp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na iyôŋ a, nôbi *Kema Gawra ené era na wô wogé ka ge kay hen wô gôliɲ naɲ ci.» ");
INSERT INTO kqp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mega wo ɓiɲé toy kwôlê bi wo hen iyôŋ na, Jésu kôlji gwosoy kwôlo ɗaŋgi. Ôbi baa ɗa naɲ Jérusalêm menba, bay kôl yaŋ ba *emê iyére to Emen ré gelé yere tirji a haw hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ôbi kôl iyôŋ ba: «Gawra wo pôni balêri na kilmé ô sa iyére to kelaŋgi bay ré ô dôbri kenare sari a dema ɗiré hera tô. ");
INSERT INTO kqp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pa dema ôbi ré ô tô na, ôbi uwôga manê kari môj aɲ céji lari woɲ lôr pôn pôn aɲ kôlji iyôŋ ba: ‹Liɲge jeŋga kwôy wo na uwoɲ.› Menba, ôbi ô hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Niɲba, kelma bi wo hen na, ɓiɲé geyri ré, menba, bay jé ɓiɲé tôri a kôl iyôŋ ba: ‹Nini gey bi ôbi ré emêni ré niɲ.› » ");
INSERT INTO kqp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Menba, kiriɲa ôbi bulo hera tô eŋgé kenare tori hende to hen na, ôbi jé uwôga manê ka ôbi na biji lari hen, ɗiré gelé mi a bay ré liɲ naɲ gursu hende to hen ba. ");
INSERT INTO kqp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kwo tumô era aɲ kôli iyôŋ ba: ‹Kelma, lôr wom bi wo pôn hen na, en hô uwoɲ megari môj a sara.› ");
INSERT INTO kqp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Menba, ôbi kôli iyôŋ ba: ‹Dô ju na mana wo dôri. Mega wo ju cubu tum dô sa aŋga dê a dô hen iyôŋ na, na bem iyére môj ju ôm.› ");
INSERT INTO kqp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kwo jôgiɲ wô era aɲ kôli iyôŋ ba: ‹Kelma lôr wom bi wo na ju ben hen na, en hô uwôɲ kamni bay a sara.› ");
INSERT INTO kqp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Menba, ôbi kôli mega wo ré kôliɲ kwo tumô hen kôl iyôŋ ba: ‹Jôbi ju ôm iyére bay.› ");
INSERT INTO kqp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kwo ɗaŋgi era aɲ kôli iyôŋ ba: ‹Kelma gel lôr wom bi a na, en uwôbere wolé bô kibi bargay a. ");
INSERT INTO kqp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wôsa en hare wôsa ju na kwôni wo maɲi: lôr wo ju bi gem né kôba, ju uwôɲ men, ju ci ré kôba, ju wal a men.› ");
INSERT INTO kqp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Menba, ôbi kôli iyôŋ ba: ‹Na kwôlo si kem a, a ené jôriɲ kwôlê sam a, jôbi wo habiɲ bi wo hen. Ju hôn wo ené na gawra wo maɲi men, lôr wo ené bi gemé ré kôba, ené uwôɲ men, ené ci ré kôba, ené wal a men. ");
INSERT INTO kqp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Hen iyôŋ ba, wô mi a jeré ô bê lari wuɲê iyéy geméri a ré ba? Aɲ heraren na ba, ené eŋgé naɲ kamne a sara a ré ba?› ");
INSERT INTO kqp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Menba, ôbi kôliɲ ɓiɲé ka ɗube kiriɲ bay ka hen iyôŋ ba: ‹Eŋgéŋge lôr bi wo hen kôbri a aɲ, ken biɲ kwo ôriɲ môj hen a.› ");
INSERT INTO kqp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bay kôli iyôŋ ba: ‹Kelma, ôbi ôriɲ môj niɲ.› ");
INSERT INTO kqp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kelma na kôlji iyôŋ ba: ‹En kelêŋge kwôni wo naɲ uɲé bay a hô biri a sara. Niɲba, kwo ari uɲé kari lôg hen na, bay a derê bay ka lôg hen kôbri a aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kwo bay baren ka na gey bi ené ômji ré hen na, eraɲge naɲ ci na, ken derji tun a nà.› » ");
INSERT INTO kqp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kiriɲa Jésu kôl kwôlê bi hen iyôŋ niɲ menba, ôbi dô tumô ɓiɲé na wô erê Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kiriɲa ôbi ba ɗa naɲ Bêtpajé naɲ Bétani a men ka yi si kwa Keram wo Olibiyé a hen menba, Jésu jé bay tôri wôô, ");
INSERT INTO kqp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aɲ kôlji iyôŋ ba: «Erêŋge iyére to tumôrŋge hen, kiriɲa ken biɲ na, ka uɲé kema kura hariɲ tôŋ wo kwôni dayri sa pôn né tô, bisiréŋgeri ken eraɲ. ");
INSERT INTO kqp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aɲ hena kwôni ré kelêŋge iyôŋ ba: ‹Wô mi a kené busereri ba?› Ba ken kôl iyôŋ ba: ‹Na Kelma a geyé.› » ");
INSERT INTO kqp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bay jé bay ka hen ôrji menba, uwoɲji are kêm mega bi wo Jésu ré kôliɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kiriɲa bay ca buseré kema kura bi wo hen menba, bay iyéri eŋgeriji iyôŋ ba: «Wô mi a kené buser kema kura wo hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Menba, bay uwôlji sara iyôŋ ba: «Na Kelma a geyé.» ");
INSERT INTO kqp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Menba, bay eraɲ naɲ kema kura bi wo hen biɲ Jésu aɲ bay bi bargay kaji cêgeri a aɲ Jésu ɗay sara. ");
INSERT INTO kqp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aɲ geré wo ôbi ay hen na, ɓiɲé bi bargay kaji tôŋ tô geré tumôri a. ");
INSERT INTO kqp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ôbi ba ɗa naɲ Jérusalêm kiriɲa ôbi herbo sa Keram wo Olibiyé a menba, bay tôri kêm naɲ kwônêrji ayji kibi Emen kaŋ a ta naɲ yi derê wô aŋgaɲ giɲê kêm ka bay gel hen. ");
INSERT INTO kqp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Menba, bay kôl iyôŋ ba: «Bi terê kibi yi wô sa Kelma wo era naɲ hini Kelma Emen hen. Bi bô jalê yi derômaraŋ a men, bi ayê kibi yi wô sa Emen men.» ");
INSERT INTO kqp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","*Parisiɲêɲê ka pôni perê kwônê ɓiɲé hen kôliɲ Jésu iyôŋ ba: «Kelma nay bay tôm bi bay ré wôm karê gura tôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ôbi uwôlji sara iyôŋ ba: «En kelêŋge, hena bay ré wôm tôŋ ba, na jerew a karê gura.» ");
INSERT INTO kqp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kiriɲa ôbi ba ɗa naɲ Jérusalêm aɲ kiriɲa ôbi ay tiri gele menba, ôbi sôm wô sare. ");
INSERT INTO kqp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Aɲ ôbi kôl iyôŋ ba: «Mini kôba, henaŋ meré hôn wo wulê bi wo hen aŋga ré béré bô jalê hen, niɲba Emen bi teré tiɲ sara haw hen. ");
INSERT INTO kqp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kworé mini ba, wulê wo era hen na, bay bare karê a méré sarê men, bay a gasererê si na si na a men. ");
INSERT INTO kqp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bay a mênêŋge yôd aɲ mini naɲ ɓiɲé ka bôrê a men, bay a ɗé keram wôni baa ta sa megari a sa iyére toré ré, wôsa me hôn wulê wo Emen eraɲ wô sarê hen né.» ");
INSERT INTO kqp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Menba, Jésu ô derô haba wo *iyéy Emen a aɲ dage ɓiɲé ka ɗi gara hen. ");
INSERT INTO kqp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ôbi kôlji iyôŋ ba: «Liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Iyére tiɲê a yé iyéy uwôlê Emen› menba, kenbay ken ay liɲ kini merê bandi.» ");
INSERT INTO kqp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ôbi geliɲ ɓiɲé are sa pôn pôn iyéy Emen a. Damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen wogeji geré bi ciré diiri, men kilmé kaɲ bay sa ɓiɲé kôba, na hen iyôŋ men, ");
INSERT INTO kqp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","niɲba, bay uwôɲ kwôlê wôni woɲ ɗiri sari a ré, wôsa ɓiɲé kêm dôbe marji toyiɲ kwôlê wori. ");
INSERT INTO kqp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wulê wo pôni a na, Jésu geliɲ ɓiɲé are derô haba wo *iyéy Emen a aɲ uwôliɲ béré Kwôlo Dôri menba, damné kaɲ bay bê kwôbe men, *bay derê tô tôô to Emen naɲ bay sa ɓiɲé saji. ");
INSERT INTO kqp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aɲ bay kôli iyôŋ ba: «Kelêni na naɲ tôô to yôŋ a jeré liɲ are bay ka hen men, i a bem tôô hende to hen a men, ba?» ");
INSERT INTO kqp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Menba, ôbi kôlji iyôŋ ba: «Nôbi kôba na eŋgeréŋge kwôlê pôn men. Kôlenge: ");
INSERT INTO kqp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","batêm to Ja na liɲ ɓiɲé hen na, hena na derômaraŋ a laba hena na ligi gawrê ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bay kôliɲ perêrji a iyôŋ ba: «Hena nana kôl: ‹Hena na derômaraŋ a› ba, ôbi a kelê: ‹Wô mi a na kené bi bôrŋge sari a ré ba?› ");
INSERT INTO kqp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A hena nana kôl na to gawrê ba, ɓiɲé a gôbêna deré wôsa bay hôn wo Ja ré na *ôbi kibi Emen.» ");
INSERT INTO kqp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Menba, bay kôli ciré hôn kiriɲ ka tôô tori hende to hen ré henaɲ ya hen né. ");
INSERT INTO kqp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Menba, Jésu kôlji iyôŋ ba: «Nôbi kôba, na kelêŋge na naɲ tôô to yôŋ a ené liɲ are bay ka hen né men.» ");
INSERT INTO kqp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Menba, Jésu kôliɲ ɓiɲé gwosoy kwôlo pôni kôl iyôŋ ba: «Gawra wo pôni yage tiɲaɗor, ôbi biɲ bay yagê tiɲaɗor yagê wori bi wo hen aɲ bay têbri naɲ geserê geserê aɲ ɗiɲ yiri ôriɲ kergare to kelaŋgi aɲ wula gaɲ. ");
INSERT INTO kqp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kiriɲa wulê néére nêm niɲ menba, ôbi jé mana wori ô uɲé bay yagê tiɲaɗor hende to hen bi bay ré biri kwa yêre tori men. Niɲba bay sê mana bi wo hen aɲ dageri hô kôbri seŋge. ");
INSERT INTO kqp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ôbi hô jé mana wo ɗaŋgi menba, ôbi kôba, bay sêri men, tiréri a men aɲ bay dageri hô kôbri seŋge. ");
INSERT INTO kqp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ôbi hô jé mana wo ɗaŋgi wo jôgiɲ têê subu sôŋ menba, ôbi kôba, bay sêri iyare aɲ dageri. ");
INSERT INTO kqp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ôbi iyéy tiɲaɗor na kôl iyôŋ ba: ‹Na ba, na lê iyeŋ ba? Na jé keman wo en geyri hen. Dô ré ba, ôbi ba, bay a kemnaɲ tini tô.› ");
INSERT INTO kqp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Niɲba, kiriɲa bay gili hen iyôŋ menba, bay kôl iyôŋ ba: ‹Na ôbi emê cibré ibari ôbi a na. Na deréŋgeri aɲ na baɲge naɲ aŋgaɲ cibré bay ka hen.› ");
INSERT INTO kqp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bay ɓiri bô yagê ôriɲ wolé aɲ bay diiri.» «Hen ba, ôbi iyéy tiɲaɗor hende to hen a liji iyeŋ niɲ ba? ");
INSERT INTO kqp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ôbi a era naɲ yiri sa deré bay yagê bay ka hen aɲ biɲ ka ɗaŋgi yagê bi wo hen.» Kiriɲa kwônê ɓiɲé toy hen iyôŋ menba, bay kôl iyôŋ ba: «Eŋ eŋ, a yé hen iyôŋ né kwôy.» ");
INSERT INTO kqp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jésu bôrji tirji a aɲ kôlji iyôŋ ba: «Kwôlo kôl iyôŋ ba: ‹Keram bi wo bay ɗé iyére na kaɲni hen na, ôbi a hô yé keram woɲ ɗé tô iyére› hen ba, bôri na iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kwôni wo yôŋ yôŋ wo kuriɲ sa keram bi wo hen a na, gerɲéri a tiɲ men, kwo keram bi wo hen kuriɲ sari a ba, a hederéri men.» ");
INSERT INTO kqp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bay derê tô tôô to Emen naɲ damné kaɲ bay bê kwôbe woge bi ciré ɓeré Jésu kiriɲ bay ka hen, niɲba, bay hariɲ ɓiɲé. Bay hôn dô wo gwosore to ôbi ré kôl hen na, ré gengiɲ na sarji. ");
INSERT INTO kqp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ayiɲ tôri wulê bi wo hen na, bay bôri jô jô menba, bay jé ɓiɲé ka li yirji môɲ ciré na kaɲ bay lê are naɲ gerérji hen ligi Jésu a wô ɓeréri sa kwôli kelêri a ô biɲ bay emê sa iyére. ");
INSERT INTO kqp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bay eŋgereri kwôlê kôl iyôŋ ba: «*Rabi, nini hôn wo kwôli kelêrem men, gelé aŋgam men na, na kwôlê woɲ tiri men, ju dô tu kwôni ré men, ju geliɲ ɓiɲé are naɲ geré kwôlo Emen woɲ tiri a men. ");
INSERT INTO kqp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A têbê wôgê wo kelma wo dami *Sésar ba, tôô kôl niné têbe laba, niné têbe ré ɗiba?» ");
INSERT INTO kqp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jésu hôn gwosore toji hende to hen menba, ôbi kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Benge selé pôn nà na gelé. Sa kwôni wo yi hen men, aŋga bay ɗi yéé hen a men ba, na ka i ba?» Menba, bay uwôli sara iyôŋ ba: «Na to kelma wo dami Sésar.» ");
INSERT INTO kqp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Menba, Jésu kôlji iyôŋ ba: «Dô, aŋga na ka Sésar ba, ken biɲ Sésar, aŋga na ka Emen ba, ken biɲ Emen.» ");
INSERT INTO kqp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bay nêm ɓeréri tu ɓiɲé sa kwôlo ôbi kôl a hen né men, tiniji ge kay aɲ bay wôm tôŋ mera. ");
INSERT INTO kqp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɓiɲé ka pôni bay uwôgeji *Sadusiɲêɲê. Bay na ɓiɲé ka bi bôrji sa jê sé wo ɓiɲé ka ma a ré. Menba, ka pôni eraji ligi Jésu a eŋgeriri kwôlê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Rabi, *Moyis na kelêna iyôŋ ba: ‹Hena kwôni wo yêni ré ma aɲa ré ɗi tamni mamare aɲa hende ré yê ré tô na, ôbi eŋne yêɲ kamrê biɲ yêni wo ma hen.› ");
INSERT INTO kqp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Niɲ na, ɓiɲé ka pôni na jurgem tô yêniɲare a. Kwo iyêri eŋge iyore yê ré tô menba, ma. ");
INSERT INTO kqp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kwo têê wôô men, ");
INSERT INTO kqp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kwo subi eŋji turgôrji hende to hen iyôŋ kwôy jurgem toji hende to hen niɲba bay yêɲ ré tô menba, maji kêm. ");
INSERT INTO kqp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cêgerji kelôg menba, iyore hende to hen ma a men. ");
INSERT INTO kqp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iyore hende to hen na, kiriɲa ɓiɲé ka ma a jê sé ba hende yé tami i pôn ba? Wôsa bay jurgem toji hende to hen na na kwôrɲêre.» ");
INSERT INTO kqp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Menba, Jésu kôlji iyôŋ ba: «Gawrê ka sa terare a na, eŋgiɲ yirji. ");
INSERT INTO kqp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Niɲba, ka Emen bôrji mega ɓiɲé ka ɗiré biji gelê wo a era hen na, kiriɲa ɓiɲé ka ma a jê sé kamɲê hen na, bay a eŋgiɲ yirji ré. ");
INSERT INTO kqp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bay a ma ré niɲ a men, wôsa bay yi mega *manê ka derômaraŋ a iyôŋ. Bay na kam Emen wôsa Emen biji ji si kamɲê niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wô jê sé wo ɓiɲé ka ma na, Moyis kôba, na gel wo bay ré sa jê sé. Kwôlo ôbi na li bô magtubu a gengiɲ sa kwôli germé ka yi môɲ tare iyôŋ hen, aɲ ôbi uwôge Kelma Emen na kwo *Abraham, kwo Isak naɲ kwo Jakwôb. ");
INSERT INTO kqp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hena Emen ré na Emen wo kwôni na, gel wo kwôni bi wo hen ré mô tu geɲ, ɗiba, ôbi na Emen wo ka ma hen né. Wôsa tiri a na ɓiɲé kêm mô tu geɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bay derê tô tôô to Emen ka pôni kôli iyôŋ ba: «Kelma ju kôl dô.» ");
INSERT INTO kqp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aɲ bay hare eŋgeréri kwôlê sa ani kani a niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Menba, Jésu kôlji iyôŋ ba: «Ɓiɲé li iyeŋ aɲa kené kôl Krist, kwo Emen dôri hen ré na kuŋga *kelma Dabid ba? ");
INSERT INTO kqp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wôsa Dabid naɲ yiri kôba kôl bô magtubu toɲ kurôŋ to cay a kôl iyôŋ ba: ‹Kelma Emen na kôliɲ Kelma wuɲê iyôŋ ba: «Sa mô sa kôben woɲ gusurô a, ");
INSERT INTO kqp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kwôy wo na biɲ bay barem a yé aŋgaɲ sêlê têm.» › ");
INSERT INTO kqp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A hena Dabid ré uwôgeri Kelma, ba a lê iyeŋ a ôbi ré yé kuŋgari sôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jésu kôliɲ bay tôri tu ɓiɲé ka mô toy kwôlê hen iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Berêŋge dô wô *bay derê tô tôô to Emen ka gey palê naɲ bargay ka yêŋnê ka ré gel wo ciré na ka damné hen men, gey bi ɓiɲé ré liji dosé yôd yôd tu wolé men, kiriɲ ka tumô bô *iyéy daɲare a men, kini emê are a a men hen. ");
INSERT INTO kqp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Men, bay gey emê yébé kaɲ mamê men, uwôlji Emen jô kibi ré hen a men na, Emen a ulê kwôlo dami sarji a.» ");
INSERT INTO kqp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jésu bô kiriɲ kwari a menba, ay tiri geliɲ ɓiɲé ka eraɲ naɲ aŋgaɲ baliyare kaji sa bi kiriɲ ka bay biɲ lari a hen. Ɓiɲé bay ka hen na, na bay uɲé kêm. ");
INSERT INTO kqp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ôbi gel iyore to pôni to na mamne toɲ hende nimré kôba, era sa bi kam selé tore wôô to nêm ani ré hen men. ");
INSERT INTO kqp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Menba, Jésu kôl iyôŋ ba: «Na tu kwôlê a ené ena kelêŋge hen, mamne toɲ hende nimré hende to hen na, bi ɗê ɓiɲé bay ka hen kêm. ");
INSERT INTO kqp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wôsa ɓiɲé bay ka hen kêm hen, bi na gursu to bay ôriɲ doyre ré niɲ hen, niɲba, hende ba, bi na lari kêm wo hende ôriɲ doyri wô keliɲ aŋgaɲ emêre hen.» ");
INSERT INTO kqp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kiriɲa ɓiɲé ka pôni kôl kwôli *iyéy Emen naɲ keram wo dôri wo bay ɗiɲ hen men, are kêm ka bay bi wô ɲaniɲ bôre hen a men ré dô menba, Jésu kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Are bay ka ken gel hen na, wulê wo era hen na, keram wôni wo a ba, ta sa megari a ba, naɲ, bay kêm a mêniɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bay eŋgereri iyôŋ ba: «Kelma, kelêni kiriɲ ka yôŋ a are bay ka kêm hen ré sa ba? Men, na mi a gelé mega wo are bay ka hen ré ca sa niɲ ba men.» ");
INSERT INTO kqp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Menba, Jésu kôl iyôŋ ba: «Berêŋge dô, bi kwôni lamêŋge ken ge kay ré, wôsa ɓiɲé kwône a ayê henen aɲ a kelê: ‹Na nôbi a na *Krist, kwo Emen dôri hen› men, ‹Wulêri sa niɲ› a men na, ken ô tôrji a ré. ");
INSERT INTO kqp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kiriɲa ken toy kwôli kumbul naɲ kwôli ɓiɲé ka kaɲ Kelma woji ôm na, ɗéŋge bôrŋge hare ré, wôsa are bay ka hen a sa môj môj dem niɲba, na gerɲé wulê bi wo hen né tô.» ");
INSERT INTO kqp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Menba, ôbi kôlji iyôŋ ba: «Tô yê pôn a lê kumbul naɲ kwo ɗaŋgi men, emê iyére to pôn a sêɲ naɲ to ɗaŋgi men, ");
INSERT INTO kqp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","yebagiɲare terare to dami dami a yé men, kurôŋ naɲ ômɲare a yé naɲ sa iyére iyére men, aŋga li harê harê naɲ aŋgaɲ giɲê ka li harê harê a yé derômaraŋ a men.» ");
INSERT INTO kqp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Niɲba, pa dema are bay ka hen ré sa tô na, bay a perêŋge men, bay a geléŋge gusiɲ men, bay a ôriɲ naɲ ken tumô bay jerê kwôlê ka bô *iyéy daɲare a men, bay a ôriɲ naɲ ken daŋgay a men, tumô kilmé ka damné a men, tumô bay emê sa iyére a men, wô kibi henen. ");
INSERT INTO kqp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Are bay ka kêm hen a béŋge na geré ulê béré Kwôlo Dôri. ");
INSERT INTO kqp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kiriɲa bay ôriɲ naɲ ken tumô bay jerê kwôlê na, ken erem wô kwôlo kené erê kelê wô jôriɲ sarŋge ré. ");
INSERT INTO kqp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wôsa nôbi, na béŋge kwôlê woɲ kelê naɲ tu melênê wo kwôni perêrji a hen a nêmê narê naɲ ken né. ");
INSERT INTO kqp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Balêrŋge kaɲ bay yêreŋge naɲ yênêrŋge men, balê ka kwôni naɲ milɲérŋge a ayê sarŋge men, bay a lê aɲ ka pôni kwône perêrŋge a hen bay a derji. ");
INSERT INTO kqp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɓiɲé kêm a tôrɲêŋge wô kibi henen, ");
INSERT INTO kqp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","niɲba, gusiri sarŋge pôn iyôŋ kôba, a kayê ré. ");
INSERT INTO kqp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na wô lêŋnê wo ken lêŋnê hen aɲa kené ôriɲ biɲ kini gelê woɲ tiri hen.» ");
INSERT INTO kqp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Kiriɲa ken gel wo asgarɲê mér Jérusalêm ta niɲ na, ken hôn wo tay mênêre na ré sa niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iyôŋ ba, bi ɓiɲé ka Judé ba, ge sa keram a men, ka mô Jérusalêm a ba, bi siji nô men, ka bô nono ba, bi heraji uwo ré niɲ men. ");
INSERT INTO kqp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Na hen iyôŋ hende to hen a, Emen réé geliɲ ɓiɲé gusiɲ wô kibi têriɲ mega wo na kôliɲ bô magtubu tori a hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wulê bi wo hen na, bô emê wo dami a lê yébé kaɲ bay kwoo men, ka kamniji yi kuba baa ya tô hen a men, wôsa gusiɲ to dami a lê ɓiɲé men, bô Emen a tari sarji a a men. ");
INSERT INTO kqp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓiɲé ka na Jubɲê ré hen, a deréji naɲ yebere men, bay a pôrji ôriɲ perê tô yê ɓiɲé ka sa terare a nà kêm men, bay a herédé Jérusalêm têrji a kwôy wo wulê wo Emen na biji hen a kôriɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Aŋgaɲ giɲê a yé sa tare a men, sa geserê a men, sa têbêŋne a a men, aɲ sa terare a nà ná, harê a deré ɓiɲé wô néé mêw wo dami wo cér men, ");
INSERT INTO kqp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","harê a deré ɓiɲé wô aŋgaɲ gusiɲ ka a era sa terare a nà hen, wôsa aŋgaɲ néé ka derômaraŋ a a yebagiɲ tiɲ. ");
INSERT INTO kqp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Menba, bay a gelen nôbi Kema Gawra hera perê kiriɲ ka geri a, naɲ néé wo dami men, damɲare to dami a men. ");
INSERT INTO kqp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kiriɲa ken gel are bay ka hen sa niɲ na, ɲanêŋge yerŋge aɲ ken dô sarŋge ta haŋge niɲ, wôsa merê sa seŋge woŋge ba ɗa niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Menba, Jésu ay aŋgaɲ gelé gelji kôl iyôŋ ba: «Geléŋge tôgôre naɲ gurô wo ɗaŋgi kêm. ");
INSERT INTO kqp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kiriɲa bay ay tô jebé menba, ken hôn wo kami emen ré baa ɗa niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kenbay kôba, kiriɲa ken gel wo are bay ka hen sa niɲ na, ken hôn wo emê iyére to Emen ré ɗa niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na tu kwôlê a ené ena kelêŋge hen, gawrê ka haw hen na, ka pôni a ba geɲ kiriɲa are bay ka hen a saɲ hen. ");
INSERT INTO kqp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Derômaraŋ naɲ sa terare a naɲê, niɲba, kwôlê wuɲê na, a naɲê ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ɗéŋge tu melênê sa yerŋge a bi emê naɲ aŋgaɲ yê naɲ suné aŋga sa terare a nà, ma lê aɲ bôrŋge a gôrbiɲ sa wulê wo nôbi Kema Gawra na heraɲ hen, réba na sé sarŋge a dus. ");
INSERT INTO kqp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wôsa wulê bi wo hen, a sa mega bera iyôŋ sa ɓiɲé ka sa terare a nà kêm. ");
INSERT INTO kqp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Merêŋge geɲ sa uwôlê Emen a yôd yôd bi Emen béŋge néé bi ken gôliɲ sa aŋga kêm ka a sa sarŋge a hen aɲ bi ken ɗibiɲ ta tumôn nôbi Kema Gawra.» ");
INSERT INTO kqp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tu tare ba, Jésu geliɲ ɓiɲé are derô haba wo iyéy Emen a, aɲ perare ba, ôbi si ô wulê sa Keram wo Olibiyé a kwôy kwôy. ");
INSERT INTO kqp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Menba, ɓiɲé kêm era ligiri a naɲ tô kiriɲ cud wô toyé kwôlê wori bô iyéy Emen a. ");
INSERT INTO kqp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Geserê wo bay li naɲ mapa wo wubere naɲ bô wo na *Pak hen ba ɗa. ");
INSERT INTO kqp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Menba, damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen woge geré wô deré Jésu, niɲba, bay hariɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Menba, Sidan ô bô Judas wo bay uwôgeri Iskariyôt wo na ôbi tô Jésu wo pôni perê ka môj kibi wôô hen. ");
INSERT INTO kqp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ôbi ô iyêlê naɲ damné kaɲ bay bê kwôbe men, bay gemé *iyéy Emen men, wô wogé geré woɲ ɓeré Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bay li yi derê damaŋ aɲ bay genge ciré biri gursu. ");
INSERT INTO kqp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ôbi gey naɲ ci aɲ woge geré wo ɗiré ɓeré Jésu biji wolé ɗiba tu ɓiɲé a ré. ");
INSERT INTO kqp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Naɲ sa geserê wo bay li naɲ mapa wo wubere naɲ bô hen baa ya tô menba, sa nêm kemnêŋ wo bay ré duu kam gamgê wô liɲ geserê Pak bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jésu jé Piyêr naɲ Ja aɲ kôlji iyôŋ ba: «Erêŋge ken ô ɓeré sa tê Pak wo naa emêŋge hen.» ");
INSERT INTO kqp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bay kôli iyôŋ ba: «Na yôŋ a jeré gey bi niné ô ɓeré sa tê Pak na ya ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ôbi uwôlji sara iyôŋ ba: «Kiriɲa ka erê biɲ perê ira na, ka uɲé gawra wo pôni ay téwre sari a eraɲ si tumôrŋge. Erêŋge tôri a kwôy derô haba wo ôbi a siɲ ya. ");
INSERT INTO kqp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aɲ ken kôliɲ ôbi iyéy iyére bi wo hen iyôŋ ba: ‹*Rabi kôl iyôŋ ba, bô iyére to yôŋ, a ɗiré ômiɲ emê woɲ Pak naɲ bay tôri ya ba?› ");
INSERT INTO kqp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Menba, ôbi a geléŋge bô iyére to dami ta to bay ɲan bôre kô niɲ. Na ya hende to hen a kené ɓeré sa tê Pak ya.» ");
INSERT INTO kqp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bay ô menba, uwoɲji are kêm mega wo Jésu ré kelaji hen iyôŋ menba, bay ɓu sa tê Pak ya. ");
INSERT INTO kqp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kiriɲa tayreri nêm menba, Jésu mô ôm emê naɲ bay tôri. ");
INSERT INTO kqp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Menba, ôbi kôlji iyôŋ ba: «En ôriɲ doy bi ené emê Pak bi wo hen môj môj naɲ ken dema ené geliɲ gusiɲ tô. ");
INSERT INTO kqp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wôsa en kelêŋge, na emê kwo ɗaŋgi ré niɲ kwôy wo merê sa seŋge wo geserê woɲ Pak bi wo hen kôl kwôli hen na, kibri a deriɲ bô *emê iyére to Emen a.» ");
INSERT INTO kqp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Menba, ôbi ay gwoy care toɲ yê tiɲaɗor aɲ liɲ Emen dosé sara menba, kôl iyôŋ ba: «Eŋgéŋge ken céɲ. ");
INSERT INTO kqp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wôsa en kelêŋge na hô yê care toɲ yê tiɲaɗor hende to hen ré niɲ kwôy wo emê iyére to Emen a saɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Men, ôbi hô ay mapa aɲ kiriɲa liɲ Emen dosé sara menba, ɓiilê biɲ bay tôri aɲ kôl iyôŋ ba: «Kwo nà ná, yi mega kurôŋgi yen wo na ayê bé wô sarŋge, lêŋge hen iyôŋ iyôŋ ken ermiɲ san a.» ");
INSERT INTO kqp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Men, ôbi biji care toɲ yê tiɲaɗor mega wo ôbi ré biji mapa hen iyôŋ cêgi emê a aɲ ôbi kôl iyôŋ ba: «Gwoy care toɲ yê tiɲaɗor to nà ná, na gwore to gel biɲare to kôrbi to Emen naɲ ɓiɲé naɲ geré wo kwôbren wo a biɲ tôŋ wô sarŋge hen.» ");
INSERT INTO kqp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Gel, kwo a ayê san hen ôm emê naɲ en. ");
INSERT INTO kqp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nôbi *Kema Gawra, na erê naɲ geré wo Emen na genge. Niɲba, bô emê a kuriɲ sa kwôni wo ay san nôbi Kema Gawra hen.» ");
INSERT INTO kqp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Menba, bay ɲamniɲ kôl iyôŋ ba: «I a lê hen iyôŋ perêrna nà ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bay tô Jésu nariɲ naɲ néérji wô sa i a ré yé kwo dami perêrji a hen ba? ");
INSERT INTO kqp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Menba, Jésu kôlji iyôŋ ba: «Kilmé ka sa terare a nà ná, ôm sa ɓiɲé kaji men, ka naɲ kenare tôni ba, li bay uwôgeji bay lê derê men. ");
INSERT INTO kqp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dô wo kenbay ken li hen iyôŋ né. Niɲba, bi kwo dami perêrŋge a ba, bi yi kwo dê men, kwo ôm sa kiriɲ ba, bi yi mega mana iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Turŋge kenbay a ba, i a na kwo dami ba? Kwo mô tôŋ wô emê hen laba, kwo li jé hen ɗi ba? Na kwo mô tôŋ wô emê hen né ba? Niɲba, nôbi en mô perêrŋge a môɲ mana iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kenbay kena ɓiɲé ka lêŋnê naɲ en perê gusiɲ a. ");
INSERT INTO kqp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ôbi a, mega wo Iban né ben emê iyére tori hen iyôŋ na, nôbi kôba, en béŋge hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka emê men, yê men, naɲ en bô emê iyére tiɲê a men, ka merê sa gagay kenare a wô emê tô môɲ wo *Israyêl wo môj kibi wôô hen a men.» ");
INSERT INTO kqp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kelma kôl iyôŋ ba: «Simô, Simô, bô dô réba Sidan eŋgere ɗiré yéŋge mega wo bay yéɲ kaw ciré dôriɲ kalmê ka habiɲ aɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Niɲba, nôbi en uwôl Emen wô sam, bi ayê bôô wom ré mêniɲ né. Aɲ wulê wo já buloɲ heraɲ yen a hen na, já yé ôbi dôbiɲ yênêm ibiyare bôrji a.» ");
INSERT INTO kqp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyêr kôli iyôŋ ba: «Kelma, nôbi naɲ jôbi na, ré na daŋgay, ré na temare kôba, na ba cêgê ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jésu kôli iyôŋ ba: «En kôlem, Piyêr, kura a yilé ré tô menba, já kelê têê subu jeré hônen né.» ");
INSERT INTO kqp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Menba, ôbi kôlji iyôŋ ba: «Kiriɲa na en jéŋge aɲ na ken ay gursu ré men, magela woɲ bê bargay wôni ré men, garbê ré a men, hen ba, mi a naɲêŋge ba?» Bay uwôli sara iyôŋ ba: «Ani na naɲêni ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ôbi kôlji iyôŋ ba: «Haw hen na, kwôni wo naɲ gursu ba, bi ay men, kwo naɲ magela woɲ bê bargay ya ba, bi ay men, kwo yebere tori toɲ kaskar naɲ ba, bi ay bargay kari keléɲ aɲ keliɲ yebere toɲ kaskar men. ");
INSERT INTO kqp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wôsa en kelêŋge, na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Bay dôŋseri naɲ bay ɗagê sa tôô.› Aɲ kwo gengiɲ san ba, ariri a liɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bay kôl iyôŋ ba: «Kelma, gel yebere toɲ kaskar wôô yi na.» Ôbi uwôlji sara iyôŋ ba: «Nêm iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Menba, Jésu si aɲ ô sa Keram wo Olibiyé mega wo ôbi lêrê gaŋ gaŋ hen iyôŋ menba, bay tôri ô naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kiriɲa bay ô biɲ menba, ôbi kôlji iyôŋ ba: «Uwôlêŋge Emen bi ken kuriɲ bô aŋgaɲ lamê ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Menba, Jésu dô tori wolé kelaŋ dê naɲ ci aɲ cubu gubari tôŋ aɲ uwôl Emen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Iban, hena jeré gey ba, ju nôgê gwoy kam toɲ gusiɲ hende to hen wolé. Iyôŋ hari kôba, bi bô geyé wuɲê nôbi a liɲ ré, niɲba, kwom jôbi ɗi.»  ");
INSERT INTO kqp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Menba, *mana wo derômaraŋ a si sari a aɲ dôbri ibiyare bôri a. ");
INSERT INTO kqp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aŋgê liri menba, ôbi uwôl Emen yôd yôd naɲ néri aɲ eŋjeléri biliɲ yi môɲ kumi kwôbe iyôŋ heriɲ tôŋ terare a. ");
INSERT INTO kqp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kiriɲa ôbi uwôl Emen hen niɲ, menba, ôbi hena hera ligi bay tôri a menba, uwoɲji tô kum a wôsa tu ɲa ɗê sarji. ");
INSERT INTO kqp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ôbi kôlji iyôŋ ba: «Kamaŋ! wô mi a kené yi kum ba? Henaŋge ta ken uwôl Emen bi ken heriɲ bô aŋgaɲ lamê ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jésu iyêl baa ya tô menba, kwônê ɓiɲé soji. Judas ôbi tô Jésu perê ka môj kibi wôô hen dera tumôrji, menba, ôbi era ligi Jésu a wô ibé tô mari wô liri dosé. ");
INSERT INTO kqp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Menba, Jésu kôli iyôŋ ba: «Judas, na naɲ ibé tô maa liɲ dosé aɲa jeré ayiɲ san nôbi Kema Gawra hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kiriɲa bay tôri ka mééri hen gel hen iyôŋ menba, kôlji iyôŋ ba: «Kelma niné sêji naɲ yebere toɲ kaskar ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Menba, kwo pôni di maa mana wo *dami wo damné kaɲ bay bê kwôbe woɲ gusurô jô. ");
INSERT INTO kqp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Menba, Jésu jôrji aɲ kôl iyôŋ ba: «Ɗéŋgeji bay li.» Menba, ôbi hebe maa mana bi wo aɲ ji. ");
INSERT INTO kqp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jésu kôliɲ damné kaɲ bay bê kwôbe naɲ bay sa bay gemé *iyéy Emen naɲ bay sa ɓiɲé ka era wô ɓeréri hen iyôŋ ba: «Ken ayen liɲ gemsa laba, wô mi a kené eraɲ naɲ yebere toɲ kaskar men, kwore men, ba? ");
INSERT INTO kqp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kiriɲa na en mô naɲ ken sa pôn pôn bô iyéy Emen hen ba, na ken ɓuren né wô mi ba? Niɲba, haw hen na tare toŋge men, kiriɲ ka hendi a gelé néé woji nô men hen.» ");
INSERT INTO kqp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bay ɓiri ôriɲ siɲ iyé *dami wo damné kaɲ bay bê kwôbe a. Piyêr ô tôri dôriɲ tôri cêgê. ");
INSERT INTO kqp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bay lam tare dami derô haba a aɲ môrji iyêbe aɲ Piyêr kôba mô perêrji a men. ");
INSERT INTO kqp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hende jé to pôni gel Piyêr mô iyêbe tare menba, hende bôri ɗééɲ aɲ kôl iyôŋ ba: «Gawra wo nà kôba, na ô naɲ ɗi men ré ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Menba, ôbi uwôsur kôl iyôŋ ba: «Iyore, en hôni ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sem cêgê menba, kwo ɗaŋgi gili aɲ kôli iyôŋ ba: «Jôbi kôba, ju na kwoji men ré ba?» Menba, ôbi uwôsur kôl iyôŋ ba: «Ena kwoji ré.» ");
INSERT INTO kqp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tare pôn cêgê menba, kwo ɗaŋgi kôl iyôŋ ba: «Na tiri yôd, gawra bi wo hen, na ô naɲ ɗi men, wôsa ôbi na kwo Galilé.» ");
INSERT INTO kqp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Menba, Piyêr uwôli sara iyôŋ ba: «En hôn bô kwôlo ju kôl hen né.» Kiriɲa ôbi iyêl baa ya tô menba, kura yel men. ");
INSERT INTO kqp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kiriɲ bay ka hen na, Kelma bul bô Piyêr ɗéɲ menba, Piyêr erem sa kwôlo Kelma na kôli hen: «Pa dema kura ré yel tô ba, já uwôserê têê subu jeré hônen né.» ");
INSERT INTO kqp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ôbi si nô aɲ sôm ɓugerôg ɓugerôg. ");
INSERT INTO kqp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gawrê ka gem Jésu hen ayrêri men, sêri men. ");
INSERT INTO kqp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bay ha tiri ta aɲ eŋgereri iyôŋ ba: «Li yem môɲ *ôbi kibi Emen iyôŋ, aɲ ju kelêni i a dêm hen ba?» ");
INSERT INTO kqp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Menba, bay tiréri damaŋ. ");
INSERT INTO kqp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kiriɲa kiriɲ wôl menba, daɲare to surɲê men, damné kaɲ bay bê kwôbe men, *bay derê tô tôô to Emen a men daɲji. Aɲ bay ôriɲ naɲ Jésu tumô bay jerê kwôlê sa Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aɲ bay kôli iyôŋ ba: «Hena jeré na *Krist, kwo Emen dôri hen ba, ju kelêni.» Menba, ôbi uwôlji sara iyôŋ ba: «Hena ené kelêŋge kôba, ka bê bôrŋge sara ré, ");
INSERT INTO kqp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","men, hena ené eŋgeréŋge kwôlê kôba, ka uwôlen sara ré a men. ");
INSERT INTO kqp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Niɲba, ayiɲ tôri haw hen na, nôbi Kema Gawra na merê sa kôbi gusurô wo Emen woɲ ôbi néé a.» ");
INSERT INTO kqp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bay kêm kôli iyôŋ ba: «Iyôŋ ba, ju na Kema Emen ta!» Menba, ôbi uwôlji sara iyôŋ ba: «Ôbi a kené kôl hen, ena Kema Emen.» ");
INSERT INTO kqp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Menba, bay kôl iyôŋ ba: «Nana gey bi kwôni wo ɗaŋgi ré derêna kwôli sôŋ ba? Nana toy naɲ marna kibri a niɲ.» ");
INSERT INTO kqp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Menba, bay jerê kwôlê sa Jubɲê hena kêm ôriɲ naɲ ɗi tumô ôbi emê iyére *Pilat a. ");
INSERT INTO kqp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bay ɗiri kwôlê sari a kôl iyôŋ ba: «Gawra wo nà ná, nini uwôɲni sa mênê ɓiɲé kani a men, jôrji bi bay ré têbe wôgê wo kelma wo dami *Sésar men, kôl ɗiré na *Krist, kwo Emen dôri hen wo na kelma ôbi emê sa iyére hen.» ");
INSERT INTO kqp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Menba, Pilat eŋgeriri iyôŋ ba: «Ju na kelma ôbi emê sa iyé Jubɲê bi ba?» Menba, Jésu uwôli sara iyôŋ ba: «Jôbi a kelê hen.» ");
INSERT INTO kqp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Menba, Pilat kôliɲ damné kaɲ bay bê kwôbe naɲ kwônê ɓiɲé iyôŋ ba: «En uwôɲ kwôlê wôni woɲ ɓeréri ré.» ");
INSERT INTO kqp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Niɲba, bay kôl môj kôl iyôŋ ba: «Ôbi sôge tô ɓiɲé men, gelji are ayiɲ tôri Galilé, sa iyé Judé kêm aɲ kwôy saɲ tôŋ na.» ");
INSERT INTO kqp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kiriɲa bay kôl hen iyôŋ menba, Pilat eŋgere na ba, ôbi ré na kwo Galilé ba? ");
INSERT INTO kqp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Menba, kiriɲa ôbi hôn wo Jésu ré na bô emê wo *Hérôd a menba, ôbi jéɲ naɲ ɗi biɲ Hérôd wôsa wulê bi wo hen na, ôbi na Jérusalêm a ya men. ");
INSERT INTO kqp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kiriɲa Hérôd gel Jésu menba, yiri dôri gaɲ wôsa ôbi ôriɲ doy geléri na ca yeŋ wô kwôlo ôbi toy gengiɲ sari hen men, ôbi gey gelé aŋgaɲ giɲê ka ôbi li hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ôbi eŋgereri kwôlê kwône niɲba, Jésu uwôli kwôlê wôni sara ré. ");
INSERT INTO kqp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Damné kaɲ bay bê kwôbe naɲ *bay derê tô tôô to Emen ɗibiji kiriɲ bay ka hen ya men, aɲ ɗiri kwôlo dami dami sari a naɲ bô tarê. ");
INSERT INTO kqp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hérôd naɲ asgarɲê kari bôri mega ani ré iyôŋ men, ayrêri men, bay dôbri bargay ka eŋné aɲ dageri hôriɲ biɲ Pilat. ");
INSERT INTO kqp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sa hende to hen na, si Hérôd naɲ Pilat ɓirji milɲare hôriɲ wôsa bay na na janê tumô. ");
INSERT INTO kqp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat jé uwôga damné kaɲ bay bê kwôbe men, kilmé men, kwônê ɓiɲé a men. ");
INSERT INTO kqp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aɲ kôlji iyôŋ ba: «Ken eraɲ naɲ gawra wo na ben aɲ ken kôl iyôŋ ba, ôbi ré mêne ɓiɲé, niɲba, kiriɲa en eŋgeriri turŋge a nà ná, en uwôɲ perê kwôlo kêm wo ken ɗiri sari hen kwo nêm ɓeréri ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hérôd kôba, na iyôŋ hende to hen, na ôbi a, ôbi ré joɲ naɲ ɗi heraɲ ben hen. Iyôŋ ba, ani ka ôbi li ka nêm deréri ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na béé bi bay sêri naɲ tinêre aɲ na uwôli ta mera.»  ");
INSERT INTO kqp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Elê elê naɲ sa geserê *Pak na, Pilat ulêrê daŋgay pôn ta ta. ");
INSERT INTO kqp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Menba, bay kôl kibriji pôn kag kôl iyôŋ ba: «Diri aɲ ju uwôl Barabas ta béni ɗi.» ");
INSERT INTO kqp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bay na ɓu Barabas wôsa bay na sôge tô ɓiɲé derô ira bi bay ré kaɲ kelma woji men, ôbi na duu temare a men. ");
INSERT INTO kqp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat hô eŋgereji wôsa ôbi gey ulê Jésu ta. ");
INSERT INTO kqp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Niɲba, bay kaɲ aɲ kôl naɲ nérji kôl iyôŋ ba: «Ɓééri sa gurô tagelê, ɓééri sa gurô tagelê.» ");
INSERT INTO kqp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Têê subu wori Pilat eŋgereji iyôŋ ba: «Gawra bi wo hen, li na mi ka habiɲ ba? En gel ani yiri a ka nêm deréri ré. Na béé bay a sêri naɲ tinêre aɲ na ulêri ta mera.» ");
INSERT INTO kqp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Niɲba, bay uwôli bay ré ɓééri ta môj môj aɲ bay kôl ba, kelê, kôl ba, kelê. ");
INSERT INTO kqp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Menba, are bay ka bay eŋgere hen na, Pilat gey naɲ ci sara. ");
INSERT INTO kqp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ôbi uwôl kwo yi daŋgay a wôsa ôbi na sôge tô ɓiɲé bi bay ré kaɲ kelma woji hen men, wô sa deré temare men hen ta. Ôbi wo bay eŋgereri bi, menba, ôbi nôge Jésu biji bi bay ré liɲ aŋga bôrji ré gey. ");
INSERT INTO kqp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kiriɲa bay ɓu Jésu ôriɲ menba, gawra wo pôni bay uwôgeri Simô, ôbi na kwôni wo Sirên uwo nono menba, asgarɲê ɓiri biri ay gurô tagelê wo Jésu ôriɲ tôri a. ");
INSERT INTO kqp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kwônê ɓiɲé ô tôri a, aɲ perê ɓiɲé bay ka hen na, yébé ka pôni ɓar sêɲ deŋgôrji. ");
INSERT INTO kqp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jésu bul uɲéji aɲ kôlji iyôŋ ba: «Kenbay yébé ka Jérusalêm, sômêŋge san a ré, niɲba, ken sôm wô sarŋge kenbay men, wô sa kamneŋge a men ɗi. ");
INSERT INTO kqp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wôsa wulê wo era hen na, bay a kelê iyôŋ ba: ‹Yi derê yi wô sa yébé ka yê woji naɲ hen men, ka na ba yê tô hen men, ka sa pôn iyôŋ biɲ kamrê kuba ré hen a men.› ");
INSERT INTO kqp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aɲ ɓiɲé a kôliɲ keram iyôŋ ba: ‹Heriɲge sarni a› men, bay a kôliɲ gôserew ‹Uwôbêni› men. ");
INSERT INTO kqp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wôsa hena bay ré lên nôbi wo en yi môɲ gurô wo geɲ iyôŋ hen, hen iyôŋ ba, kwoŋge kenbay ka ken yi môɲ gurô wo hay hen ba, a sa yé iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bay ôriɲ naɲ ɓiɲé ka ɗaŋgi wôô ka na bay bô habrê wô deréji naɲ Jésu men. ");
INSERT INTO kqp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kiriɲa bay sa kiriɲ ka bay uwôgeji ibé sa gawra hen menba, bay ɓér Jésu sa gurô tagelê naɲ bay bô habrê ka wôô kwo pôni bay ɓééri sa gurô tagelê wori a sa kôbi Jésu woɲ gusurô men, kwo pôni bay ɓééri sa gurô tagelê wori a sa kôbi Jésu ma men. ");
INSERT INTO kqp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jésu kôl iyôŋ ba: «Iban, ɗi bôm jal sarji a, wôsa aŋga bay li hen na, bay hôn né.» Aɲ bay pô bargay kari céɲji naɲ geré wo jalaw terê. ");
INSERT INTO kqp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kwônê ɓiɲé ɗubu ya gel. Bay sa Jubɲê ba, ayrêri aɲ kôl iyôŋ ba: «Ôbi gôliɲ naɲ ɓiɲé menba, bi gôliɲ naɲ yiri hari niɲ ta, ôbi wo kôl ɗiré na Krist, kwo Emen dôri hen, hen!» ");
INSERT INTO kqp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asgarɲê kôba ayrêri aɲ eraɲji naɲ kam ka tayi ciré biri aɲ bay kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Hena jeré na kelma wo Jubɲê ba, ju gôliɲ naɲ yem.» ");
INSERT INTO kqp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bay li are di yi gurô a ta sari a ta kôl iyôŋ ba: «Gawra bi wo hen, na kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ôbi bô habrê wo pôni wo bay ɓééri naɲ ɗi hen tiréri kôl iyôŋ ba: «Ju na Krist, kwo Emen dôri hen ré ba? Iyôŋ ba, ju gôliɲ naɲ yem men, ju gôliɲ naɲ ni men.» ");
INSERT INTO kqp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kwo pôni hen, kôliɲ megari na iyôŋ ba: «Ju hariɲ Emen né kwôy ba? Jôbi kôba, ju geliɲ gusiɲ hende to hen men. ");
INSERT INTO kqp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwona nabay ba, na jé lêrena wo habiɲ a nana geliɲ gusiɲ hen, niɲba ôbi ba, li ani kani ka habiɲ né.» ");
INSERT INTO kqp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Menba, ôbi kôl iyôŋ ba: «Jésu erem san a kiriɲa já hera wô emê kenare.» ");
INSERT INTO kqp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Menba, Jésu uwôli sara iyôŋ ba: «En kôlem na tiri, kemnêŋ hende to hen já merê naɲ en *Paradis a ka na kiriɲ ka dôri hen.» ");
INSERT INTO kqp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kiriɲa tare ɗubu ɗiŋne menba, kiriɲ hendu sa terare a nà kêm kwôy wo yébé ayiɲ sa tôɲne ta. ");
INSERT INTO kqp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aɲ tu tare têliɲ ta. Menba, bargay ka bay ha jôriɲ bô *iyéy Emen a hen yêgiɲ derôre a. ");
INSERT INTO kqp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Menba, Jésu jô gura wo dami kôl iyôŋ ba: «Iban, en bem tunun a kôm a.» Kiriɲa ôbi kôl hen iyôŋ menba, kibri wôm hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kiriɲa dami wo asgarɲê ɗebu gel hen iyôŋ menba, ôbi heram Emen kôl iyôŋ ba: «Gawra bi wo hen na, na gawra woɲ derôre tiri a men.» ");
INSERT INTO kqp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kiriɲ bay ka hen, ɓiɲé kêm ka ɗubu ya, gelji are bay ka hen na, bay sêêrê deŋgôrji hôriɲ iɲ. ");
INSERT INTO kqp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Milɲéri kêm ɗebu sêd wolé naɲ yébé ka era tôri a ca yeŋ Galilé hen, kôba, ɗebu ya, gel men. ");
INSERT INTO kqp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gawra wo pôni hini na Josêp, ôbi na perê bay jerê kwôlê sa Jubɲê hen. Ôbi na kwôni wo dôri men, kwoɲ derôre a men. ");
INSERT INTO kqp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ôbi na biɲ naɲ megêri sa ermé woji a ré men, sa jé lêreji a ré a men, wo bay na li naɲ Jésu hen. Ôbi na gawra wo sa iyé Arimaté bô emê wo Judé. Ôbi na mô gem *emê iyére to Emen. ");
INSERT INTO kqp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ôbi ô uɲé Pilat aɲ eŋgereri temay Jésu. ");
INSERT INTO kqp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ôbi dô temay Jésu tôŋ sa gurô tagelê aɲ lêgeriri naɲ kibi bargay aɲ ô emé kamɲê ka bay kerge bô keram a ka kwôni emiɲ ya tumô ré tô hen. ");
INSERT INTO kqp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na wulê wo bay ɓeriɲ sa têrji, wôsa *sa merê ta ba ɗa. ");
INSERT INTO kqp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yébé ka ré era tôri ca Galilé yeŋ hen na, ôrji tô Josêp a, bay gel sa kamɲê men, ulê wo bay uwôliɲ temay Jésu hen a men. ");
INSERT INTO kqp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Menba, bay belji hô ô ɲanê sa tê weŋ wo ɗiɲé hen men, ider a men hen wô bê sa temay Jésu a. Menba, dôrji bul naɲ sa merê ta mega tôô kôl hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aɲ naɲ sa demas tô kiriɲ cud menba, yébé ka henaŋ dôrji bul naɲ *sa merê ta hen heraji sa kamɲê naɲ weŋ men, ider wo ɗiɲé dô hen men wo bay henaŋ ɓu sa têri hen. ");
INSERT INTO kqp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bay gel kulmaŋ keram wo luge kibi kamɲê hen gerŋgiɲ yi wolé. ");
INSERT INTO kqp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Menba, bay si bô kamɲê, menba, bay gel temay Kelma Jésu ré. ");
INSERT INTO kqp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kiriɲa bay ɲamniɲ na ba, mi a ré yé hen iyôŋ ba tô menba, gawrê wôô ka bargay kaji bôderê terij terij siji ɗibiji tumôrji a. ");
INSERT INTO kqp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Menba, harê li yébé bay ka hen aɲ bay di kuniji tôŋ, gawrê bay ka hen kôlji iyôŋ ba: «Wô mi a kené woge kwôni wo mô geɲ perê ka ma a ba? ");
INSERT INTO kqp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ôbi ji si ɗiba ôbi naɲ na. Erméŋge sa kwôlo ôbi na kelêŋge kiriɲa ôbi na baɲ Galilé tô hen. ");
INSERT INTO kqp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ôbi na kôl iyôŋ ba: ‹Nôbi *Kema Gawra na uwôliɲ kôbi bay lê têriɲ a, bay a ɓéren sa gurô tagelê aɲ sa wôô, subu tori menba, na jê sé kamɲê.› » ");
INSERT INTO kqp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kiriɲ bay ka hen menba, bay hô erem sa kwôlo Jésu bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bay heraji sa dôriɲ bay tô Jésu ka môj kibi pôn hen kwôlê bi wo hen men, bay kôliɲ ka ɗaŋgi kêm a men. ");
INSERT INTO kqp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yébé bay ka hen na, na Mari to Magdala men, Jan men, Mari toɲ yoo *Jak naɲ megêrji ka na ô naɲ ci hen kôba, kôliɲji bay tô Jésu men. ");
INSERT INTO kqp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Niɲba, bay bô kwôlê bi wo hen yi mega dilemne iyôŋ tirji a, ɗiba, bay bi bôrji sa kwôlo yébé bi wo hen a ré. ");
INSERT INTO kqp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Niɲba, Piyêr ge ô sa kamɲê, ôbi doŋge niɲba, gel na bargay ka bay na lêgeriɲ Jésu hen mera, menba, ôbi bul hô aɲ tini ge kay sa are bay ka li are hen. ");
INSERT INTO kqp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wulê bi wo hen na, bay tôri wôô perêrji a hen ôrji ca erê Emayus a. Emayus na, na kilomêter môj kibi wôô naɲ Jérusalêm. ");
INSERT INTO kqp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bay dô kwôli are bay ka kêm ka ré li are hen. ");
INSERT INTO kqp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kiriɲa bay iyêl hen iyôŋ menba, Jésu si sarji a aɲ ô naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Niɲba, ani jôrji bi bay ré hôni. ");
INSERT INTO kqp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ôbi kôlji iyôŋ ba: «Na kwôli mi a, kené iyêl ôriɲ hen ba?» Menba, bay ɗebu tôŋ, menba, tirji mêne. ");
INSERT INTO kqp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kwo pôni perêrji a hen bay uwôgeri Kléyopas uwôli sara iyôŋ ba: «Jôbi pôn nêŋ ham Jérusalêm a hen a henê aŋga li are bô wulê bi wo hen a ré!» ");
INSERT INTO kqp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Menba, ôbi kôlji iyôŋ ba: «Na mi a lê are ba?» Menba, bay uwôli sara iyôŋ ba: «Kwôlo gengiɲ sa Jésu wo Najarêt wo na *ôbi kibi Emen woɲ ôbi néé men, ôbi kôl kwôlê men, li are a men, naɲ néé tumô Emen a men, tumô gawrê a men. ");
INSERT INTO kqp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Damné kaɲ bay bê kwôbe kana naɲ kilmé ɓiri ɗiri kwôli temare sari a aɲ bay ɓééri sa gurô tagelê. ");
INSERT INTO kqp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nibay ba, nini kôl yaŋ ba ôbi a ré derê *Israyêl bô lemnare a. Niɲba, sa are bay ka kêm hen na, li sa subu niɲ wo are bay ka kêm li are. ");
INSERT INTO kqp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Niɲba, yébé kani ka pôni li tinini ge kay wôsa bay ô sa kamɲê naɲ tô kiriɲ cud menba, ");
INSERT INTO kqp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bay uwôɲ temayri ré menba, bay hera sa kôl iyôŋ ba *manê ka derômaraŋ a ré jôrji aɲ ré kôlji ôbi ré mô geɲ. ");
INSERT INTO kqp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Megêrni ka pôni ô sa kamɲê menba, uwoɲji are bay ka hen mega yébé ré kôliɲ iyôŋ niɲba, ôbi ba, bay gili ré.» ");
INSERT INTO kqp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Menba, Jésu kôlji iyôŋ ba: «Ayi! gawrê ka henê aŋgaji naɲ hen, ken jal sa bê bôrŋge sa kwôlo bay kibi Emen na kôl, kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","*Krist, kwo Emen dôri hen ré geliɲ gusiɲ dema ré merê bô derê a tô ré ba?» ");
INSERT INTO kqp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ôbi dôrji bô magtubu to Emen to kôl gengiɲ sari. Aɲ ayiɲ tôri sa magtubu to *Moyis a kwôy saɲ sa magtubu to bay kibi Emen a. ");
INSERT INTO kqp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kiriɲa bay ba ɗa naɲ iyére to bay ca erê ya hen menba, ôbi li môɲ ɗiré erê kelaŋgê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Menba, bay jôri môj môj kôl iyôŋ ba: «Mô naɲ ni wôsa tare kuriɲ niɲ men, kiriɲ kô niɲ a men.» Menba, ôbi ô ira naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kiriɲa ôbi mô emê naɲ ci menba, ôbi ay mapa aɲ liɲ Emen dosé menba, ɓôl aɲ biji. ");
INSERT INTO kqp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kiriɲ bay ka hen menba, tirji yêgiɲ aɲ bay hôni menba, bay gili ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Menba, bay kôl iyôŋ ba: «Ani ré uwoy bôrna môɲ tare iyôŋ kiriɲa ôbi ré derêna bô magtubu tô geré hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kiriɲ bay ka hen na, bay bul hô Jérusalêm a, bay uwôɲ bay tôri ka môj kibi pôn hen naɲ ka ɗaŋgi daɲji. ");
INSERT INTO kqp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aɲ ka daɲji hen, kôliɲ ka uwo Emayus a hen iyôŋ ba: «Kelma ji si kamɲê na tiri, aɲ ôbi si sa Simô a.» ");
INSERT INTO kqp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Menba, bay dô kwôli aŋga ré li are tô geré hen men, jôriɲare to tirji ré jôriɲ sari a kiriɲa ôbi ré ɓôl mapa biji hen men. ");
INSERT INTO kqp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bay iyêl hen iyôŋ baa ya tô menba, Jésu si ɗebu derôrji a aɲ kôlji iyôŋ ba: «Bi bô jalê wo Emen ba, naɲ ken.» ");
INSERT INTO kqp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Harê duu bay tô Jésu aɲ bay kôl yaŋ ba ciré gel na kamɲê kani. ");
INSERT INTO kqp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Menba, ôbi kôlji iyôŋ ba: «Ken hare wô mi ba? Wô mi a kené meremné ba? ");
INSERT INTO kqp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Geléŋge kôben naɲ têên, na nôbi naɲ yen. Hebenge ken gel, tunu ôriɲ naɲ kurôŋgi ré men, ibé ré men, mega wo ken gel yen a hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ôbi kôl hen iyôŋ menba, gelji kôbri naɲ têêri. ");
INSERT INTO kqp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yirji dôrji derê wo bay nêm bê bôrji sara ré men, tiniji ge kay baa ya a men, aɲ ôbi kôlji iyôŋ ba: «Ken ôriɲ naɲ ani kaɲ emê ré ba?» ");
INSERT INTO kqp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Menba, bay biri kuyê kaɲ payê. ");
INSERT INTO kqp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ôbi eŋge aɲ ôm tirji a. ");
INSERT INTO kqp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Menba, ôbi kôlji iyôŋ ba: «Na kwôlo na en kelêŋge kiriɲa na en baɲ naɲ ken ôbi a hen: kwôlo na kôliɲ gengiɲ san bô magtubu tôô to Moyis a men, bay kibi Emen naɲ kurôŋ kibé a men, hen a ariri ré liɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kiriɲ bay ka hen menba, ôbi bi tirji jôriɲ bi bay ré hôn bô magtubu to Emen. ");
INSERT INTO kqp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aɲ kôlji iyôŋ ba: «Na mega wo na liɲ kôl iyôŋ ba: Krist, kwô Emen dôri hen, a geliɲ gusiɲ aɲ sa wôô, subu tori menba, ôbi a jê sé kamɲê. ");
INSERT INTO kqp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Men, bay a ulê béré biɲ tô yê ɓiɲé ré ɗi tô têriɲ lêreji baa aɲ bi Emen ré ɗiɲ bôri jal sarji a kêm, ayiɲ tôri Jérusalêm a tumô. ");
INSERT INTO kqp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na ken gel are bay ka hen naɲ turŋge aɲ kenbay a yé bay dôriɲ ɓiɲé kwôliji. ");
INSERT INTO kqp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nôbi na joɲ naɲ aŋga Iban na ayiɲ tôô ben hen. Kenbay ba, ken mô na hende to hen kwôy wo ka uwôɲiɲ néé wo hena derômaraŋ a.» ");
INSERT INTO kqp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Menba, ôbi ôriɲ naɲ ci si Bétani iyôŋ aɲ pô kôbri ta tôriɲ kibri a sarji a. ");
INSERT INTO kqp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kiriɲa ôbi tô kibri sarji a baa ya tô menba, Emen ayri ôriɲ ta derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kwoji bay ba, kiriɲa bay di kwiniji tôŋ aɲ heramiri menba, bay bul hô Jérusalêm a naɲ yi derê wo dami. ");
INSERT INTO kqp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aɲ sa pôn pôn bay mô derô haba wo *iyéy Emen a ayiɲ kibi Emen.");
INSERT INTO kqp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pa dema, Emen ré ayiɲ tô ɗé are tô na, Gawra wo bay uwôgeri Kwôlê hen, na ya niɲ, ôbi na mô naɲ Emen ca yeŋ men, Kwôlê bi wo hen na na Emen a men. ");
INSERT INTO kqp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kwôlê bi wo hen, na mô naɲ Emen pa dema, ôbi na ré ayiɲ tô ɗé are. ");
INSERT INTO kqp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aɲ are kêm ka na ɗiɲ hen na, na na naɲ geré wo Kwôlê bi wo hen men, are bay ka kêm hen, ka ôbi ré baa lêreji ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na Kwôlê bi a, merê tu geɲ ré yi bôri a men, merê tu geɲ bi wo hen, a na kiriɲ ka peraŋgi ka ɓiɲé ka sa terare a nà a men. ");
INSERT INTO kqp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kiriɲ ka peraŋgi bay ka hen, peraŋge bô dilemne a, niɲba, dilemne kaɲ kiriɲ ka peraŋgi bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Menba, Emen jé gawra wo bay uwôgeri Ja. ");
INSERT INTO kqp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ôbi era na wô derê kwôli Kiriɲ ka Peraŋgi bay ka hen, aɲ bi ɓiɲé ré bi bôrji sarji a, sa kibi kwôlê wo ɗiré dô hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ôbi na Kiriɲ ka Peraŋgi bay ka hen né, niɲba, ôbi era na wô kelê kwôliji ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kiriɲ ka Peraŋgi bay ka hen na, na kaɲ tiri, ka era sa terare a nà, aɲ peraŋge kiriɲ aɲ ɓiɲé kêm gel kiriɲ. ");
INSERT INTO kqp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gawra bi wo na Kwôlê hen na, sa mô sa terare a nà ya, aɲ ná sa kibri aɲa Emen na ré ɗiɲ terare naɲ are kêm ka yi sara hen, menba, gawrê bay ka sa terare a nà, tirji jôriɲ sari a ré. ");
INSERT INTO kqp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ôbi era sa iyére tori a niɲba, kari kaɲ ɗéɲ ɗéɲ bay ka hen kaɲni. ");
INSERT INTO kqp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Niɲba, ka pôni perê ka geyri aɲ bi bôrji sari a hen na, ôbi biji geré bi bay ré biliɲ yi kam Emen. ");
INSERT INTO kqp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓiɲé bay ka hen yi kam Emen na, mega wo gawra yêɲ kamni hen iyôŋ né men, na naɲ bô geyé wo gawra wôni ré a men, niɲba, na Emen a beléji a, bay ré yiɲ kamni hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Men, Kwôlê bi wo hen biliɲ yi gawra aɲ sa mô perêrna nà, aɲ bô derê naɲ tu kwôlê yi yiri damaŋ men, nana gel damɲare tori a men, damɲare tori hende to hen, na to Iba Kema a biɲ Kemari wo pôn nêŋ nêŋ hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja na kôl kwôli kaŋ a ta kôl iyôŋ ba: «Na wô sari ôbi aɲa na ené kelêŋge iyôŋ ba: ‹Ôbi ré era cêgen a hen ya men, damɲare tori ré gôliɲ tiɲê a men hen›, wôsa ôbi na mô ca tumôn yeŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sa kibi bô derê wori aɲa nana uwôɲ terê kibi wo gay gay hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ca ba, Emen na bi *Moyis a na geléna tôô, niɲba, bô derê naɲ tu kwôlê na, na Jésu Krist a saɲ béna. ");
INSERT INTO kqp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wôsa kwôni wo gel Emen ba, naɲ tô, niɲba, na Kemari wo pôn nêŋ nêŋ wo na Emen wo mô naɲ Ibari hen, a gelénari aɲa nana hôni hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bay sa Jubɲê ka Jérusalêm jéji bay bê kwôbe naɲ kam *Lébi ligi Ja a eŋgeri iyôŋ ba: «Jôbi ju na i ba?» ");
INSERT INTO kqp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Menba, ôbi uwôsirji ré, aɲ kôlji waŋ ta kôl iyôŋ ba: «Na nôbi a na *Krist, kwo Emen dôri hen, bi ré tô.» ");
INSERT INTO kqp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Menba, bay eŋgeriri iyôŋ ba: «Niɲba, ju na i ɗi ba? Ju na *Eli *ôbi kibi Emen laba?» Menba, Ja uwôlji sara iyôŋ ba: «Ena ôbi ré.» Menba, bay hô eŋgeriri iyôŋ ba: «Niɲba, ju na ôbi kibi Emen wo bay na kôl kwôli hen ɗê?» Menba, Ja kôlji iyôŋ ba: «Ena ôbi ré tô a men.» ");
INSERT INTO kqp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Menba, bay hô eŋgeriri iyôŋ ba: «A nà niɲba, ju na i ɗi a jeré kelêni kwôlo gengiɲ sam ba, niɲa herê ô kôliɲ ka joni hen ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Menba, Ja uwôlji sara iyôŋ ba: «Ena tôô kwo ôm derô gwôlê aɲ kôl iyôŋ ba: ‹Ɲanêŋge geré wo Kelma bi ô derôre.› Na mega wo ôbi kibi Emen *Esay na kôl hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Perê ɓiɲé ka bay jéji yi Ja a hen na, Parisiɲêɲê kôba ya men. ");
INSERT INTO kqp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aɲ bay eŋgeriri iyôŋ ba: «Ju na Krist, kwo Emen dôri hen ré men, *Eli ré men, ôbi kibi Emen ré a men menba, wô mi a jeré liɲ ɓiɲé batêm ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Menba, Ja hô uwôlji sara iyôŋ ba: «Nôbi ba, en lêŋge batêm na naɲ kam, niɲba, gawra wo pôni mô perêrŋge a hen ya, wo ken hôni ré. ");
INSERT INTO kqp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ôbi era cêgena hen ya aɲ ena ani wo na beseré gaŋgi garbê kari ré.» ");
INSERT INTO kqp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Are bay ka kêm hen liɲ na sa iyé Bétani a, cêgi cér wo Jurdê kiriɲ ka Ja liɲ ɓiɲé batêm ya hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wulê pôn cêgê menba, Ja gel Jésu era ligiri a, menba, ôbi kôl iyôŋ ba: «Geléŋge na Kema Kwormo wo Emen wo dô têriɲ sa ɓiɲé ka sa terare a nà bi a na. ");
INSERT INTO kqp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na ôbi á, na ené kôl kwôli kôl iyôŋ ba: ‹Gawra wo pôni era cêgena hen na, damɲare tori gôliɲ tiɲê wôsa ôbi na mô ya ca tumôn yeŋ a men.› ");
INSERT INTO kqp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na en hôn mega ôbi a ré na Kema Kwormo wo Emen né. Aɲ en liɲ ɓiɲé batêm naɲ kam aɲ bi kam *Israyêl ré hôniɲni.» ");
INSERT INTO kqp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja dô kwôli kôl iyôŋ ba: «En gel Tini Emen herbo ta derômaraŋ a mega derare iyôŋ sari a. ");
INSERT INTO kqp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na en hôn wo ôbi ré na i ba, ré niɲba, na Emen wo na joon bi ené liɲ ɓiɲé batêm naɲ kam hen na, na ôbi a kôlen iyôŋ ba: ‹Kwôni wo já gelé Tunu herbe aɲ ɗebe sari a hen na, na ôbi a liɲ ɓiɲé batêm naɲ Tunu toɲ hendi bô bôrê.› ");
INSERT INTO kqp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ôbi a, kiriɲa ené gel hen iyôŋ menba, en kôl ôbi ré na Kema Emen bi hen.» ");
INSERT INTO kqp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wulê pôn cêgê menba, Ja naɲ bay tôri ka wôô hen hô heraji kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aɲ kiriɲa ôbi gel Jésu wo ô hen menba, ôbi kôl iyôŋ ba: «Geléŋge na Kema Kwormo wo Emen bi a nà.» ");
INSERT INTO kqp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kiriɲa bay tô Ja bay ka wôô hen, toy kwôlo ôbi kôl hen menba, bay ô tô Jésu a. ");
INSERT INTO kqp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kiriɲa Jésu bare cêgeri gelji wo bay era tôri a menba, ôbi kôlji iyôŋ ba: «Ken woge na mi ba?» Menba, bay eŋgereri iyôŋ ba: «*Rabi, (hini bi wo hen bôri ôbi geliɲ ɓiɲé are) iyére tom na yôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Menba, ôbi kôlji iyôŋ ba: «Eraŋge ka sa gelé» menba, bay ô, ô gelé kiriɲ ka ôbi môriɲ ya hen, menba, bay mô naɲ ɗi sem. Kiriɲa tare pôô niɲ menba, bay ô ta. ");
INSERT INTO kqp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","André woɲ yêni Simô Piyêr na kwo pôni perê bay tô Ja bay ka wôô ka na toy kwôlo Ja aɲ na ô tô Jésu a hen. ");
INSERT INTO kqp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na André bi a erê uɲé yêni Simô tumô aɲ kôli iyôŋ ba: «Nini uɲa *Mési» (hini bi wo hen bôri na Krist, kwo Emen dôri hen). ");
INSERT INTO kqp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Menba, ôbi ôriɲ naɲ Simô ligi Jésu a, Jésu bô Simô aɲ kôli iyôŋ ba: «Ju na Simô kema Jonas, niɲba, haw hen bay uwôgem Képas.» (Bôri na «keram.») ");
INSERT INTO kqp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wulê pôn cêgê menba, Jésu genge ɗiré erê Galilé. Ôbi uwôɲ Pilip aɲ kôli iyôŋ ba: «Era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip na kwôni wo Bêtsayda mega si André naɲ yêni Piyêr hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip uwôɲ Nataniyêl aɲ kôli iyôŋ ba: «Nini uwôɲ kwo Moyis na kôl kwôli bô magtubu tôô a hen men, bay kibi Emen kôba, na kôl kwôli bô magtubu toji a hen men. Na Jésu wo Najarêt woɲ kema Josêp.» ");
INSERT INTO kqp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Menba, Nataniyêl kôli iyôŋ ba: «Sa iyé Najarêt a ba, ani ka dôri a hena ya pa pa ba?» Menba, Pilip kôli iyôŋ ba: «Era já sa erê gelé hen tô.» ");
INSERT INTO kqp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kiriɲa Jésu gel Nataniyêl era ligiri a menba, ôbi kôl iyôŋ ba: «Gel, na Israyêl woɲ ɗéɲ wo ermé wôni wo habiɲ naɲ bôri a.» ");
INSERT INTO kqp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Menba, Nataniyêl eŋgereri iyôŋ ba: «Ju hônen na yôŋ ba?» Menba, Jésu uwôli sara iyôŋ ba: «Pa dema, Pilip ré uwôgem tô na, en gelem kiriɲa ju môriɲ tô tôgôre a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Menba, Nataniyêl uwôli sara iyôŋ ba: «Rabi, ju na Kema Emen, ju na Kelma wo Israyêl.» ");
INSERT INTO kqp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jésu kôli iyôŋ ba: «Wô wo en kôlem ené gelem tô tôgôre a bi a, jeré bi bôm sara hen ba? Já gelé aŋga dami ka ɗê ka hen aɲ tô.» ");
INSERT INTO kqp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Menba, Jésu kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen, haw hen ka gelé derômaraŋ a bôliɲ aɲ manê ka Emen a herbé men, ɗayê herê men, san nôbi *Kema Gawra a.» ");
INSERT INTO kqp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wulê wôô cêgê menba, gerê iyére yi Kana emê wo Galilé a. Menba, yoo Jésu ô ya men. ");
INSERT INTO kqp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jésu kôba, bay uwôgeri kini gerê iyére hende to hen a naɲ bay tôri. ");
INSERT INTO kqp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Care toɲ kam tiɲaɗor yê ɓiɲé menba, yoo Jésu kôli iyôŋ ba: «Care toɲ kam tiɲaɗor to ɓiɲé ré yi naɲ niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Menba, Jésu kôle iyôŋ ba: «Yoon, mini a kôlen kwôli aŋga ené li ré. Tare tiɲê nêm ré tô.» ");
INSERT INTO kqp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Menba, yori kôliɲ bay cé emê hen iyôŋ ba: «Aŋga ôbi a kelêŋge kené li ba, ken li mera.» ");
INSERT INTO kqp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kiriɲ bay ka ya hen, téwɲê ka bay li naɲ keram jii yi ya, na téwɲê ka Jubɲê lôɲniɲ yirji wô séliɲ tumô Emen a. Téwɲê bay ka hen na, pôn ba, ay tawa subu subu. ");
INSERT INTO kqp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Menba, Jésu kôlji iyôŋ ba: «Kebéŋge kam ken bi wiinê téwɲê bay ka hen ta.» Menba, bay kebe kam bi wiinê téwɲê bay ka hen telêj telêj ta. ");
INSERT INTO kqp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Menba, Jésu kôlji iyôŋ ba: «Kebéŋge ken biɲ ôbi sa bay cé emê na haŋge niɲ.» Menba, bay kebe ôriɲ biri. ");
INSERT INTO kqp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kiriɲa ôbi sa bay cé emé bi wo hen yi gel menba, kam bay ka ré beliɲ care toɲ kam tiɲaɗor hen, niɲba, ôbi hôn kiriɲ ka care toɲ kam tiɲaɗor hende to hen henaɲ ya ré, niɲba, bay jé ka ré kebe kam hen na, bay hôn dô menba, ôbi uwôge ôbi kurô bi wo hen ");
INSERT INTO kqp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aɲ kôli iyôŋ ba: «Ɗôd ba, ɓiɲé céré na care toɲ kam tiɲaɗor to dôri tumô aɲ kiriɲa ɓiɲé ka bay uwôgerêji hen kwoyré niɲ dema bay ré cé to melaŋgi cêgê tô menba, jôbi ba, ju gem care toɲ kam tiɲaɗor tom to dôri na yôŋ aɲa jeré soɲ naɲ tu nà tô ba?» ");
INSERT INTO kqp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na sa iyé Kana bô emê wo Galilé a Jésu ré li giɲê wori wo tumô cog cog, aɲ geliɲ damɲare tori aɲ bay tôri biɲ bôrji sari a. ");
INSERT INTO kqp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cêgi gerê iyére hende to hen menba, bay ôrji Kapêrnayôm naɲ yori men, yênêri men, bay tôri a men, niɲba, bay wôl ya gaɲ né. ");
INSERT INTO kqp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sa lê geserê *Pak wo Jubɲê baa ɗa menba, Jésu ô Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ôbi uwôɲ derô haba wo *iyéy Emen a, kelbê ka bay eraɲ gara men, gamgê men, derare naɲ bay keraŋgê lari ka môrji tôŋ hen. ");
INSERT INTO kqp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Menba, Jésu gwôje gaŋne liɲ sera aɲ ôbi dageji kêm bô iyéy Emen a naɲ gamgê men, kelbê kaji men, ôbi nôgerê tabel to bay keraŋgê lari wo gay gay hen hee aɲ useré lari woji bi wo hen a men, ");
INSERT INTO kqp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","aɲ ôbi kôliɲ bay eraɲ naɲ derare gara na iyôŋ ba: «Ôriɲge naɲ derare toŋge hen ken siɲ nô, ka ayê iyé Iban liɲ kini lê gara woŋge né.» ");
INSERT INTO kqp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Menba, bay tôri erem sa kwôlo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «En gey iyére tom gaɲ. Geyé bi wo en gey iyére hende to hen, hen na, payren môɲ tare to uwoy gawra iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Menba, Jubɲê kôli iyôŋ ba: «Na mi kaɲ giɲê a jeré lê geléni aɲ bi niné hôniɲ wo jeré nêm lê mega wo ju liɲ hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Menba, Jésu uwôlji sara iyôŋ ba: «Téŋge iyéy Emen hende to hen aɲ, aɲ na hô ɗé hôriɲ sa subu dêj.» ");
INSERT INTO kqp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jubɲê kôl iyôŋ ba: «Iyéy Emen to yi hen na, li elê tôre pôrbu kibi jii dema niné li kô tô menba, jôbi ju kôl sa subu dêj menba, jeré ɗé kerê ba?» ");
INSERT INTO kqp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Niɲba, Jésu kôl na kwôli iyéy Emen to na kurôŋgi yiri hen. ");
INSERT INTO kqp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na ôbi á, kiriɲa Jésu ré ji si kamɲê menba, bay tôri erem sa kwôlê bi wo ôbi na kôl hen, aɲ bay bi bôrji sa kwôlo Emen a men, sa kwôlo Jésu na kôl a hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kiriɲa Jésu baɲ Jérusalêm a tô lê geserê Pak a na, ɓiɲé kwône bi bôrji sari a wô giɲê wo gay gay wo ôbi li. ");
INSERT INTO kqp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Niɲba, ôbi bi bôri sarji a ré wôsa ôbi hônji pôn pôn kêm. ");
INSERT INTO kqp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ôbi ôriɲ doy bi bay ré dôri kwôli kwôni ré a men, wôsa ôbi hôn bô gawrê kêm. ");
INSERT INTO kqp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Perê *Parisiɲêɲê a na, gawra wo pôni bay uwôgeri Nikwodêm. Ôbi na kelma perê kilmé ka Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ôbi era ligi Jésu a yoyre aɲ kôli iyôŋ ba: «*Rabi, nini hôn wo jeré na dami woɲ ôbi giliɲare ɓiɲé tôô to Emen wo hena ligi Emen a. Wôsa hena Emen né baa naɲ kwôni ré ba, ôbi a nêmê lê aŋgaɲ giɲê mega wo ju liɲ hen iyôŋ né.» ");
INSERT INTO kqp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Menba, Jésu uwôli sara iyôŋ ba: «Na tu kwôlê a ené kôlem hen, hena gawra ré hô yêɲ ɗaŋ ré ba, ôbi a gelé *emê iyére to Emen né.» ");
INSERT INTO kqp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikwodêm uwôli sara iyôŋ ba: «Hena gawra ré na kwo iyêri niɲ ba, a hô yêɲ ɗaŋ na iyeŋ ba? Ôbi a hô herê bô yori a dema bay ré yêri hôriɲ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Menba, Jésu uwôli sara iyôŋ ba: «Na tu kwôlê a ené kôlem hen, hena gawra ré yêɲ naɲ geré wo kam men, kwo Tunu a men ré na, ôbi a gelé emê iyére to Emen né. ");
INSERT INTO kqp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aŋga kurôŋgi yi a yê ba, na kurôŋgi yi men, ka Tunu a yê ba, na Tunu men. ");
INSERT INTO kqp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bi deŋgôm tém wô kelê wo en kôlem jeré hô yêɲ ɗaŋ hen né. ");
INSERT INTO kqp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kal ge na kiriɲ ka bôri gey a men, ju toy na néri mera, ɗiba, ju hôn na ba, ôbi hena na yôŋ ba, ré men, ôbi ô na yôŋ ba, ré a men. Gawra wo Tunu a yêri kôba, a yé na mega bi wo hen iyôŋ men. Wôsa já gelé Tunu ré, niɲba, na jé wo hende li yi gawra a jeré gelé.» ");
INSERT INTO kqp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Menba, Nikwodêm kôli iyôŋ ba: «Hen ba, a liɲ na iyeŋ iyeŋ pôn ba?» ");
INSERT INTO kqp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Menba, Jésu uwôli sara iyôŋ ba: «Ju na dami ôbi geliɲare kam *Israyêl are menba, ju hôn are bay ka hen, ré wô mi ba? ");
INSERT INTO kqp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na tu kwôlê a ené kôlem hen, nini kôl kwôli aŋga nini hôn men, nini dô kwôli aŋga nini gel naɲ tirni a men, menba, ken kaɲ bê bôrŋge sa kwôli are bay ka nini derêŋge hen. ");
INSERT INTO kqp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hen aɲa kené bi bôrŋge sa kwôli aŋga sa terare a nà, ka en derêŋge hen ré ba, ka lê iyeŋ a kené bê bôrŋge sa ka derômaraŋ a ka na derêŋge kwôliji hen ba? ");
INSERT INTO kqp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aɲ kwôni wo ɗay ô derômaraŋ a ba, naɲ, niɲba, na kwo na hena derômaraŋ a bi pôn hari. Ôbi a na nôbi *Kema Gawra. ");
INSERT INTO kqp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mega wo *Moyis na iyege lari liɲ kalaw aɲ dôbe kibi gurô a ta hen iyôŋ na, gel wo nôbi Kema Gawra kôba, bay a ayen ɗé ta hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aɲ bi i i wo ré bi bôri san a ba, ré mô tu geɲ naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wôsa Emen gey ɓiɲé ka sa terare a nà, damaŋ aɲa ré joɲ naɲ Kemari wo pôn nêŋ nêŋ hari hen sa terare a nà, bi i i wo ré bi bôri sari a ba, ré mêne ré, niɲba, ré mô naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wôsa Emen joɲ naɲ Kemari sa terare a nà na wô jerê kwôlê sa ɓiɲé ré, niɲba, bi bay ré uwôɲiɲ gelê sa kibri ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na ôbi á, kwôni wo ré bi bôri sari ba, bay a jerê kwôlê sari a ré niɲ. Niɲba, kwo kaɲ bê bôri sari a ba, bay jô kwôlê sari a niɲ, wôsa ôbi bi bôri sa hini Kema Emen wo pôn nêŋ nêŋ hari hen né. ");
INSERT INTO kqp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jerê kwôlê bi wo hen na, na wo kiriɲ ka peraŋgi era sa terare a nà, niɲba, gawrê kaɲji aɲ wô kiriɲ ka hendi ɗi, wôsa jé lêreji na kwo habiɲ. ");
INSERT INTO kqp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ôbi a, i i wo ré li habrê ba, kaɲ na kiriɲ ka peraŋgi aɲ, ôbi era tu kiriɲ ka peraŋgi bay ka hen a ré, wô wo jé lêri wo habiɲ hen ma ré yé tu wolé. ");
INSERT INTO kqp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Niɲba, ôbi lêre aŋgaɲ tiri na, ôbi era kiriɲ ka peraŋgi a, aɲ ari lêri ka dôri hen na, ɓiɲé gel wôsa bay biɲ naɲ tôô to Emen.» ");
INSERT INTO kqp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cêgeri wori menba, Jésu naɲ bay tôri ôrji bô emê wo Judé aɲ môrji ya. Aɲ liɲ ɓiɲé batêm. ");
INSERT INTO kqp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja kôba liɲ ɓiɲé batêm kiriɲ ka kam ya, ka bay uwôgeji Enôn ka ɗa naɲ Salim hen. Wôsa kiriɲ bay ka hen na, kam yi ya damaŋ aɲ ɓiɲé era bi ôbi ré liji batêm. ");
INSERT INTO kqp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wôsa wulê bi wo hen na, bay uwôl Ja daŋgay a ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kiriɲ bay ka hen na, bay tô Ja nariɲ kwôlê naɲ Jub wo pôni gengiɲ sa lôɲê yi wô séliɲ tumô Emen a wo na hara wo Jubɲê hen. ");
INSERT INTO kqp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bay era sa uwôɲ Ja aɲ kôli iyôŋ ba: «Rabi, gawra wo na ɗebe naɲ ju cêgi Jurdê, aɲ na ju dô kwôli hen na, gel ôbi liɲ ɓiɲé batêm aɲ ɓiɲé kêm ô ligiri a.» ");
INSERT INTO kqp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Menba, Ja uwôlji sara iyôŋ ba: «Hena Emen ré biɲ kwôni are ré ba, ôbi a nêmê uɲé ani sa kibri ré. ");
INSERT INTO kqp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kenbay, na ken toy kwôlo na en kôl kôl iyôŋ ba: ‹Ena *Krist, kwo Emen dôri hen ré, niɲba, bay joon tumôri a ɗi.› ");
INSERT INTO kqp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yi mega kwôni wo eŋge iyore na, hende na tori niɲba, ôbi tô kibri ba, ɗebu na ɗa kwari a. Ôbi toy tôri to ôbi dôriɲ kwôlê hen menba, yiri dôri. Ôbi a, yen ré dôren damaŋ hen. ");
INSERT INTO kqp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bi damɲare tori ô tumô tumô aɲ bi tiɲê nôbi hera cêgê men.» ");
INSERT INTO kqp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kwôni wo hena derômaraŋ a era ba, ôbi gôliɲ sa are kêm, niɲba, kwo na kwo sa terare a nà ba, na kwo sa terare a men. Ôbi kôl na kwôli aŋga sa terare a nà a men, niɲba, kwo hena derômaraŋ a ba, gôliɲ sa are kêm. ");
INSERT INTO kqp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kwo hena derômaraŋ a bi wo hen, dô na kwôli aŋga ôbi na gel men, na toy a men, niɲba, kwôni bi bôri sa kwôli bi wo ôbi dô hen né. ");
INSERT INTO kqp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kwôni wo bi bôri sa kwôli bi wo ôbi dô hen na, ôbi gel na wo Emen ré kôl na tu kwôlê. ");
INSERT INTO kqp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wôsa kwo Emen jori hen na, kôl na kwôli aŋga Emen kôl wôsa Emen biri Tini damaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba Emen gey Kemari aɲ ôbi biri are kêm kôbri a. ");
INSERT INTO kqp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ôbi a, kwôni wo bi bôri sa Kema ba, a merê naɲ kwini, niɲba, kwo kaɲ bê bôri sari a kwôy ba, a merê naɲ kwini ré, niɲba, bô tarê wo Emen baa sari a. ");
INSERT INTO kqp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","*Parisiɲêɲê toy wo ɓiɲé kwône ré bi bôrji sa Jésu a damaŋ men, ôbi ré liji batêm a men ɗê ka Ja. ");
INSERT INTO kqp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tiri wori ba, Jésu naɲ yiri liɲ kwôni batêm ré, niɲba, na bay tôri a liɲ ɓiɲé batêm ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kiriɲa Jésu toy kwôlo bay kôl hen iyôŋ, menba, ôbi hena bô emê wo Judé bulo hera kwo Galilé a. ");
INSERT INTO kqp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mega wo ôbi a sé si Samari môj môj hen iyôŋ, menba, ");
INSERT INTO kqp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ôbi sa biɲ môni iyére to Samari to bay uwôgere Sikar ɗa naɲ yagê wo Jakwôb na biɲ kemari Josêp ca yeŋ hen. ");
INSERT INTO kqp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kiriɲ bay ka hen, ôbi uwôɲ kelmá wo Jakwôb. Tare ɗebe ɗiŋne niɲ, menba, ôbi merên tô kergare tori hende to hen, aɲ mô dô bul kibi kelmá bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Menba, iyore to Samari era wô gebé kam menba, Jésu kôle iyôŋ ba: «Ben kam na yê men.» ");
INSERT INTO kqp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wôsa bay tôri naɲ naɲ ɗi, wôsa bay ô derô ira wô kelé aŋgaɲ emê. ");
INSERT INTO kqp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Menba, iyore to Samari hende to hen kôli iyôŋ ba: «Wô mi a jôbi woɲ Jub jeré eŋgeren eni toɲ Samari kam kaɲ yê ba?» Wôsa Jubɲê biɲji naɲ Samari ré. ");
INSERT INTO kqp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Menba, Jésu uwôle sara iyôŋ ba: «Hena ré meré hôn aŋgaɲ bé seŋge ka Emen men, ré meré hôn kwo eŋgeréré kam kaɲ yê hen a men na, ré na mini a ré eŋgereri kam kaɲ yê ɗi, aɲ ôbi a ré béré kam ka kwôni yi ba, a gôliɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Menba, hende kôli iyôŋ ba: «Kelma, kelmá ɗoge men, ju ôriɲ naɲ gaŋgi jelaŋgê ré a men, menba, já lê iyeŋ a jeré uɲé kam kaɲ gelê bay ka hen ba? ");
INSERT INTO kqp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jôbi ju gôliɲ môyrini Jakwôb wo na béni kelmá bi wo hen wo ôbi na yi kamni men, kamni naɲ ari abê kari kôba, na yi a men hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Menba, Jésu kôle iyôŋ ba: «I i wo yi kami kelmá bi wo hen na, kam a hô diri hôriɲ. ");
INSERT INTO kqp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Niɲba, kwôni wo yi kam ka na biri hen na, kam a diri cêgê ré niɲ, aɲ kam bay ka na biri hen na, a yé tu kam ka sederiɲ ka a yé yiri a kwôy, aɲ ôbi a merê naɲ kwini.» ");
INSERT INTO kqp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Iyore hende to hen kôli iyôŋ ba: «Kelma, ben kam bay ka hen na yê aɲ bi kam dên cêgê ré niɲ men, bi en hera sa gebe kam na ré niɲ a men.» ");
INSERT INTO kqp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jésu kôle iyôŋ ba: «Ô mu ô uwôga kurôrê ken hera na.» ");
INSERT INTO kqp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Menba, iyore hende to hen kôli iyôŋ ba: «Eni na, kurôn naɲ.» Menba, Jésu kôle iyôŋ ba: «Kwôlo mu kôl kurôrê ré naɲ hen na, na tiri. ");
INSERT INTO kqp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wôsa kwôrɲêrê ka tumô na bay, aɲ kwo mu mô tumôri a haw hen na, na kurôrê ré. Kwo hen ba, mu kôl na tiri.» ");
INSERT INTO kqp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iyore hende to hen kôli iyôŋ ba: «Kelma, ju na *ôbi kibi Emen bi tiri. ");
INSERT INTO kqp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Môɲêrni na tebe Emen sa keram wo na. Menba, kenbay kaɲ Jubɲê ken kôl kini tibé Emen ré na Jérusalêm a mera.» ");
INSERT INTO kqp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jésu kôliɲ iyore hende to hen iyôŋ ba: «Bi bôrê sa kwôlo na kelê hen. Era baa tumô a hen na, kiriɲ ka ɓiɲé a tibiɲ Emen Iba ɓiɲé hen na, na sa keram a na ré men, na Jérusalêm a ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kenbay kaɲ Samaritên ken tebe Emen niɲba, ken hôni ré, niɲba, nibay kaɲ Jub na, nini tibri men, nini hôni a men. Wôsa tô gelê hena na yi Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wulêri nêm niɲ wo ɓiɲé ka tebe Emen Iba ɓiɲé hen na, bay a tibéri na tibé woɲ tiri hen men, naɲ tunu a men. Wôsa na bay tibé Emen bay ka hen iyôŋgi hen a Emen né wogeji. ");
INSERT INTO kqp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Emen na Tunu aɲ ka tibri hen na, bi tibri naɲ tunu men, naɲ bôô pôn a men.» ");
INSERT INTO kqp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Iyore hende to hen kôli iyôŋ ba: «En hôn wo *Mési (wo na *Krist, kwo Emen dôri hen) ré sa sa, aɲ kiriɲa ôbi ré sa na, ôbi ré sa derêni tô are kêm.» ");
INSERT INTO kqp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Menba, Jésu kôle iyôŋ ba: «Na nôbi Krist, kwo Emen dôri hen bi a iyêlê naɲ mu hen.» ");
INSERT INTO kqp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kiriɲ bay ka hen, menba, bay tôri heraji men, aɲ tiniji ge kay wô iyêlê wo ôbi iyêl naɲ iyore hen. Niɲba, kwôni pôn iyôŋ perêrji a hen eŋgereri na ba, ju eŋgere ani ba, ré men, na kwôli mi a, jeré iyêl naɲ tu ba, ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aɲ iyore hende to hen ɗi téwre tore aɲ kibi kelmá aɲ ge hô derô ira ô kôliɲ ɓiɲé iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Eraŋge ken sa gel gawra wo kôlen kwôli are kêm ka na en lêrê hen. Ôbi a yé na Krist, kwo Emen dôri hen bi ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Menba, ɓiɲé sooro derô ira aɲ eraji uwoɲni. ");
INSERT INTO kqp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Menba, bay tôri kôli ré ôm are aɲ bay kôl iyôŋ ba: «*Rabi, ôm are dem.» ");
INSERT INTO kqp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Niɲba, ôbi uwôlji sara iyôŋ ba: «Aŋgaɲ emêren ya a men niɲba, na kenbay a henê ré hen.» ");
INSERT INTO kqp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bay tôri kôl perêrji a kôl iyôŋ ba: «Na ba, kwôni eraɲ naɲ aŋgaɲ emê sa biri ba?» ");
INSERT INTO kqp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Menba, Jésu kôlji iyôŋ ba: «Lê aŋga kwo joon hen men, deré kibi jé wori a men na, ôbi a na emê wuɲê. ");
INSERT INTO kqp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kwoŋge kenbay ba, ken kôl ré baa geserê pôrbu a dema kaw ré yé walê tô. Niɲba, nôbi en kelêŋge, ayêŋge turŋge ta ken geliɲ kaw ka né yi walê niɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kwôni wo wal kaw ba, uwôɲ sa kôbri niɲ aɲ dayrê na kaw ka dôri wô merê tu geɲ wo naɲ kwini. Iyôŋ ba, ôbi cé men, ôbi walê kaw a men na, bi ré liji yi derê ɓem. ");
INSERT INTO kqp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gwosoy kwôlo bay na kôl kôl iyôŋ ba: ‹Kwo pôni ré ci men, kwo pôni ré wal men› hen na, na tu kwôlê. ");
INSERT INTO kqp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","En jéŋge ken ô walê kaw ka, ka ɗaŋgi a na lê jériji, aɲ ken ô na dilmirji.» ");
INSERT INTO kqp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Menba, kamaŋ ka Samari ka sa iyére hende to hen kwône bi bôrji sa Jésu, sa kibi kwôlo iyore hende to hen. Hende kôl iyôŋ ba: «Ôbi dôren tô aŋga kêm ka na en lêrê hen.» ");
INSERT INTO kqp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Menba, kiriɲa kamaŋ ka Samari sa uwoɲni menba, bay uwôli bi ôbi ré wôl naɲ ci sem, menba, ôbi wôl naɲ ci wulê wôô. ");
INSERT INTO kqp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɓiɲé kwône damaŋ bi bôrji sari a, sa kibi kwôlo ôbi kôl hen. ");
INSERT INTO kqp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Menba, bay kôliɲ iyore hende to hen iyôŋ ba: «Nini bi bôrni sari a na wô kibi kwôlo mu kelêni hen mera ré, niɲba, na wôsa nini toy kwôlo ôbi kôl hen naɲ marni, aɲa niné hôn wo ôbi ré na ôbi gôliɲ naɲ ɓiɲé ka sa terare a nà, tiri a men.» ");
INSERT INTO kqp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kiriɲa wulê wo wôô bi wo hen kô niɲ, menba, Jésu ô bô emê wo Galilé a. ");
INSERT INTO kqp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wôsa ôbi na kôl tumô kôl iyôŋ ba: «*Ôbi kibi Emen na, balêri a biri kwôlê ré.» ");
INSERT INTO kqp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kiriɲa ôbi sa biɲ Galilé na, ɓiɲé ka Galilé ɓiri yirji a wôsa ka pôni ka na ô lê geserê Jérusalêm a hen na, bay na gelo are kêm ka ôbi na la hen. ");
INSERT INTO kqp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jésu hô bul hô Kana bô emê wo Galilé a, kiriɲ ka ôbi na li kam biliɲ care toɲ kam tiɲaɗor hen. Sa iyé Kapêrnayôm a na, gawra wo dami wo kelma kemari ômiɲ. ");
INSERT INTO kqp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aɲ kiriɲa ôbi toy wo Jésu ré hena Judé sa biɲ Galilé na, ôbi ô ligiri a ô uwôli bi ré era iyére tori a sa berare kemari wo ômiɲ ɗa ma hen biri men. ");
INSERT INTO kqp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Menba, Jésu kôli iyôŋ ba: «Hena kené gel aŋgaɲ giɲê ré men, aŋgaɲ gelé ré a men na, ka bê bôrŋge san a ré.» ");
INSERT INTO kqp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Menba, dami wo kelma bi wo hen, kôli iyôŋ ba: «Kelma era lew wô wo keman maa ma.» ");
INSERT INTO kqp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jésu kôli iyôŋ ba: «Ô ham niɲ, wôsa kemam berare niɲ.» Ôbi bi bôri sa kwôlo Jésu kôli hen, aɲ kuriɲ ô hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kiriɲa ôbi baa tô geré tô menba, manê kari jô kwini aɲ kôli iyôŋ ba: «Kemam berare niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Menba, ôbi eŋgeriji iyôŋ ba, ré na naɲ tare iyeŋ a ôbi ré berare ba? Menba, bay kôli iyôŋ ba: «Henaŋ naɲ tare to sugi aɲa yiri ré jal.» ");
INSERT INTO kqp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Menba, ôbi hôn wo henaŋ ré na naɲ tare hende to hen, aɲa Jésu henaŋ né kôli iyôŋ ba: «Kemam berare niɲ» hen, menba, ôbi naɲ ɓiɲé ka bô iyére tori a kêm biji bôrji sa Jésu a. ");
INSERT INTO kqp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jésu li giɲê wo têê wôôy bi wo hen, na kiriɲa ôbi henaɲ bô emê wo Judé heraɲ kwo Galilé a hen. ");
INSERT INTO kqp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cêgê giɲê bi wo hen, menba, wulê lê geserê wo Jubɲê wo pôni nêm menba, Jésu ô Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jérusalêm a na, ɗa naɲ kibi geré wo bay uwôgeri ré na kibi geré wo gamgê hen na, iyom wo dami wo bay pi biɲ kam bô liɲ tagare toɲ pelé to bay uwôgere Bêtjata naɲ kibi hébre hen. Kibi tagare hende to hen na, bay li pal bay ya. ");
INSERT INTO kqp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tô pal bi wo pôn pôn hen na, bay ômɲare men, bay tu tiɲ men, bay merayê ka gay gay hen môrji ya. Bay gem bi kam né pelasiɲ. ");
INSERT INTO kqp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wôsa *mana wo derômaraŋ a wo pôni herbo bô tagare hende to hen a ta ta aɲ pelase kam. Aɲ kwôni wo herbe bô a tumô kiriɲa kam pelasiɲ hen na, ômɲare tori hende to hen, na toɲ mi mi kôba, dôriɲ yiri a. ");
INSERT INTO kqp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kiriɲ bay ka hen na, gawra wo pôni wo ômɲare liri li elê tôre subu kibi marge yi ya men. ");
INSERT INTO kqp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jésu gili wo ôbi yi tôŋ hen iyôŋ men, ôbi hôn wo gawra bi wo hen ré ômiɲ elê kwône a men na, Jésu kôli iyôŋ ba: «Ju gey berarê ba?» ");
INSERT INTO kqp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ôbi ômɲare bi wo hen uwôli sara iyôŋ ba: «Kelma, kiriɲa kam pelasiɲ na, kwôni wo ré ayen uwôl bô tagare a naɲ, aɲ kiriɲa en masa bi ené kuriɲ bô a, menba, ôbi ômɲare wo ɗaŋgi kuriɲ bô a tumôn niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Menba, Jésu kôli iyôŋ ba: «Hena ta ay jaare tom ôriɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kiriɲ bay ka hen na, ôbi berare aɲ ay jaare tori ôriɲ. Na naɲ sa *sa merê ta, ");
INSERT INTO kqp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","menba, bay sa Jubɲê kôli iyôŋ ba: «Na sa sa merê ta, ɗiba ré jeré ayê kwoy wom né.» ");
INSERT INTO kqp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Menba, ôbi uwôlji sara iyôŋ ba: «Kwo beraren hen kôlen iyôŋ ba: ‹Ay kwoy wom ju ôriɲ.› » ");
INSERT INTO kqp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Menba, bay eŋgereri iyôŋ ba: «Na i bi a kôlem: ‹Ay kwoy wom ju ôriɲ hen ba?› » ");
INSERT INTO kqp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Niɲba, ôbi hôn kwôni wo kôli kwôlê bi wo hen né, wôsa Jésu kay perê ɓiɲé ka kwôni ka ɗebe ya hen. ");
INSERT INTO kqp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cêgê menba, Jésu uwoɲni derô haba wo *iyéy Emen a, menba, kôli iyôŋ ba: «Ju berare niɲ niɲba, ju hô li têriɲ ré niɲ wô wo aŋga ɗê ka hen, maa hô lêm sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Menba, gawra bi wo hen, ô kôliɲ bay sa Jubɲê iyôŋ ba, ré na Jésu a na ré berarêri hen. ");
INSERT INTO kqp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na ôbi á, Jubɲê ré woge Jésu wôsa ôbi ré berare gawra naɲ sa merê ta. ");
INSERT INTO kqp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Niɲba, Jésu kôlji iyôŋ ba: «Iban na li jé aɲ ôbi li na hen iyôŋ yôôd. Aɲ nôbi kôba, en li hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na wô ôbi wo hen, aɲa bay sa Jubɲê ré woge damaŋ a ciré deréri wô wo ôbi ré ɗage sa tôô to gengiɲ sa sa merê ta hen mera ré niɲba, wô wo ôbi ré uwôge Emen Ibari men, ôbi ré li yiri ɗiré na Emen iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jésu hô kôlji iyôŋ ba: «Na kelêŋge na tu kwôlê: Kema na nêmê lê ani kani sa kibri ré, niɲba, ôbi li na aŋga ôbi gel yi Ibari a men, na aŋga Ibari li kêm hen, na bay a, ôbi ré li hen men. ");
INSERT INTO kqp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wôsa Baba Emen gey Kemari aɲa ré gili aŋga ôbi li hen kêm men, ôbi a hô gili ka dami ɗê ka ken gel hen a men, aɲ bi tunuŋge ré ge kay damaŋ a. ");
INSERT INTO kqp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mega Baba Emen béér ɓiɲé ka ma aɲ biji bay mô tu geɲ hen na, Kemari kôba, a biɲ i i wo bôri gey na, ôbi a biri merê tu geɲ men. ");
INSERT INTO kqp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ôbi a, Baba Emen ba, ré jô kwôlê sa kwôni a ré, niɲba, ôbi day tôô toɲ jerê kwôlê kêm biɲ Kemari kôbri a. ");
INSERT INTO kqp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aɲ bi ɓiɲé ré ay kibi Kema môɲ kwo bay ayiɲ kibi Ibari hen iyôŋ men. Wôsa kwôni wo ay kibi Kema ré ba, Ibari wo jori hen kôba ôbi ay kibri ré a men.» ");
INSERT INTO kqp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Na tu kwôlê a ené kelêŋge hen: kwôni wo toy kwôlê wuɲê, aɲ bi bôri sa kwo joon a hen na, ôbi a merê naɲ kwini men, ôbi a erê kini jerê kwôlê a ré niɲ a men, niɲba, ôbi yi mega kwôni wo na ma iyôŋ, aɲ haw hen ôbi mô tu geɲ. ");
INSERT INTO kqp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na tu kwôlê a ené kelêŋge hen: wulê nêm niɲ wo ɓiɲé ka ma a toyé tôô Kema Emen aɲ ka toy tôri hen na, bay a merê tu geɲ. ");
INSERT INTO kqp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mega wo Iba Kema na hanê merê tu geɲ hen iyôŋ na, Kemari kôba, ôbi biri yi hanê merê tu geɲ men. ");
INSERT INTO kqp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Men, ôbi biri tôô bi ré jôriɲ kwôlê sa ɓiɲé a men, wôsa ôbi na *Kema Gawra. ");
INSERT INTO kqp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bi kwôlê wo en kelêŋge hen li tunuŋge ge kay ré, wôsa kiriɲa wulêri nêm na, ɓiɲé ka ma ma hen a toyé tôri. ");
INSERT INTO kqp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Menba, bay a jê sé kamɲê. Aɲ kaɲ bay lê derê hen na, bay a jê sé kamɲê wô merê tu geɲ men, kaɲ bay lê habrê ba, bay a jê sé kamɲê bi bay ré jô kwôlê sarji a men.» ");
INSERT INTO kqp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Ani ka en nêm lê sa keben ba, naɲ. En jô kwôlê sa ɓiɲé a na naɲ kwôlo Emen kôlen hen. Aɲ jerê kwôlê wuɲê bi wo hen, na naɲ geréri wôsa en woge na bô geyé wuɲê ré, niɲba, bô geyé wo kwo joon hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Hena ré na nôbi a derê kwôlen naɲ keben wuɲê ba, ka bê bôrŋge san a ré. ");
INSERT INTO kqp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Niɲba, kwôni wo ɗaŋgi wo dô kwôlen hen ya, aɲ en hôn wo kwôlen wo ôbi ré dô hen na, ré na tiri. ");
INSERT INTO kqp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ken jé yi Ja a aɲ kwôlo ôbi dô gengiɲ san hen na, na kwôlê woɲ tiri. ");
INSERT INTO kqp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kuɲê nôbi ba, na gawra a derê kwôlen ré, niɲba, en kôl kwôli Ja hen iyôŋ bi kené uwôɲiɲ gelê. ");
INSERT INTO kqp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja na yi môɲ tare toɲ tô deɲere to berare kiriɲ, aɲ na ken li yi derê sem wô kiriɲ ka peraŋgi bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Niɲba, nôbi ba, ôbi derê kwôlen ya, aɲ kwôlen bi wo ôbi dô hen na, damaŋ gôliɲ kwo Ja aɲ, wôsa aŋga en li hen na, na Iban a ben a ené li hen, aɲ na bay a derê kwôlen men, gel wo Iban a ré joon hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Men, Iban bi wo joon hen na, ôbi naɲ yiri dô kwôlen, niɲba, ken toy tôri ré men, ken gili ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kwôlê wori yi bôrŋge a ré, wôsa ken bi bôrŋge sa kwo ôbi jori hen né. ");
INSERT INTO kqp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Men, ken dêŋse men, kôbe tô magtubu to Emen a men, wôsa ken erem mega ré na sa kebre aɲa kené môriɲ naɲ kunuŋge hen. Aɲ na magtubu hende to hen, a na hende derê kwôlen. ");
INSERT INTO kqp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bi wo hen, kôba, ken kaɲ era yen a bi kené mô naɲ kunuŋge.» ");
INSERT INTO kqp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Hini emê wuɲê na, hena na ligi gawrê a ré. ");
INSERT INTO kqp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Niɲba, en henêŋge men, en hôn wo geyé Emen na, ré naɲ bôrŋge a a men. ");
INSERT INTO kqp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","En era naɲ hini Iban menba, ken kaɲen, niɲba, kwo era sa kibri wori menba, na ôbi a kené geyri ɗi men. ");
INSERT INTO kqp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kenbay ka ken gey ayiɲ kibi yerŋge ɗiba, ken woge ayê kibi wo hena ligi Emen a mera ré hen, menba, ka lê iyeŋ a kené bê bôrŋge san a ba? ");
INSERT INTO kqp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma ka ermé yaŋ ba, ené ulêŋge kwôlê sarŋge a tumô Iban a. Niɲba, ôbi ulêŋge kwôlê sarŋge a ba, na *Moyis wo ken ɗi bôrŋge sari a hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wôsa hena, na kené bi bôrŋge sa Moyis a ba, ré kené bê bôrŋge san a men, wôsa ôbi na li magtubu to kôl kwôlen. ");
INSERT INTO kqp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Niɲba, hena kené bi bôrŋge sa magtubu to Moyis a ré ba, ka lê iyeŋ a kené bê bôrŋge sa kwôlê wuɲê a ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cêgi kwôlo Jésu kôl hen menba, ôbi ô si cêgi cér wo Galilé wo bay uwôgere Tibériyad hen. ");
INSERT INTO kqp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɓiɲé kwône kôbe tôri wôsa bay gel giɲê wo ôbi li sa ɓiɲé kaɲ bay ômɲare a hen. ");
INSERT INTO kqp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Menba, Jésu naɲ bay tôri ɗayji ô merê sa keram a. ");
INSERT INTO kqp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wulê bi wo hen na, sa lê geserê *Pak wo Jubɲê hen kôba, baa ɗa men. ");
INSERT INTO kqp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Menba, kiriɲa Jésu ay tiri ta menba, gel kwônê ɓiɲé ka era ligiri a hen, menba, ôbi eŋgeriɲ Pilip iyôŋ ba: «Naa erê kelé mapa na yôŋ a nana biɲ ɓiɲé bay ka hen ré ôm ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ôbi kôl hen iyôŋ, bi ɗiré hôniɲ kwôlo bô Pilip a. Wôsa Jésu hôn aŋga ɗa lê niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Menba, Pilip uwôli sara iyôŋ ba: «Bi i i ba ré uwôɲ dê dê ôm na, hena nana kel mapa na tu *déniyé arew wôô kôba, a yêji ba ya.» ");
INSERT INTO kqp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Menba, ôbi tô Jésu wo pôni wo bay uwôgeri André woɲ yêni Simô Piyêr hen kôli iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Kema wo pôni ôriɲ naɲ mapa bay wo bay li naɲ ôrj men kuyê wôô nà ya a men, niɲba, kwônê ɓiɲé ka hen ba, mapa wo bay naɲ kuyê ka wôô hen, a liji mi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Menba, Jésu kôl iyôŋ ba: «Biŋgeji bi bay mô tôŋ.» Kalmê yi gaɲ kiriɲ bay ka hen. Bay mô tôŋ aɲ bay kêm na imɲê dubu bay. ");
INSERT INTO kqp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Menba, Jésu pô mapa bi wo hen, aɲ kiriɲa liɲ Emen dosé menba, céɲ ɓiɲé bay ka hen men, ôbi pô kuyê liɲ mega ôbi wo hen iyôŋ aɲ céji a sara mega wo bôrji gey. ");
INSERT INTO kqp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kiriɲa ɓiɲé bay ka hen uyirêji niɲ, menba, Jésu kôliɲ bay tôri iyôŋ ba: «Perêŋge tô mapa wo baa hen ɗiba, ken ɗi mêne aɲ né.» ");
INSERT INTO kqp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Menba, bay tôri dayrê tô mapa wo bay hen gwaɲê môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kiriɲa ɓiɲé gel giɲê wo Jésu li hen iyôŋ menba, bay kôl iyôŋ ba: «Gawra wo hen na, *ôbi kibi Emen wo Emen kôl ré sa sa terare a nà, bi na tiri.» ");
INSERT INTO kqp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jésu hôn wo bay ré sa dôri ereŋ wô biri kenare hen iyôŋ menba, ôbi dô yiri pini hô sa keram a. ");
INSERT INTO kqp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kiriɲa kiriɲ yi burgem menba, bay tôri ôrji kibi cér a. ");
INSERT INTO kqp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bay ɗay bô bato a ciré erê tera Kapêrnayôm a. Kiriɲ yoy niɲ menba, Jésu sa uwoɲji ré tô tô. ");
INSERT INTO kqp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Menba, kal wo dami ge aɲ mêw tôriɲ damaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kiriɲa bay tô Jésu jubu bato nêm kilomêter jii ley menba, bay gel Jésu era sa kam a aɲ sa ɗa kwarji a menba, harê liji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Menba, Jésu kôlji iyôŋ ba: «Harêŋge ré, na nôbi.» ");
INSERT INTO kqp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bay gey ciré ayêri bô bato a niɲba, bay biɲ kiriɲ ka bay ca erê ya hen, jigê mera. ");
INSERT INTO kqp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wulê pôn cêgê menba, kiriɲa kwônê ɓiɲé ka baa cêgi cér a hen, gel wo bato ré baa pôn aɲ bay tô Jésu ré ay ôriɲ na piniji aɲ Jésu ré ɗay naɲ ci ré. ");
INSERT INTO kqp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bay gel kwônê bato to ɗaŋgi wo hena si Tibériyad sa ɗubu ɗa naɲ kiriɲ ka Jésu henaŋ pôriɲ mapa aɲ liɲ Emen dosé pa dema ré biji ôm tô hen. ");
INSERT INTO kqp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kiriɲa bay gel wo Jésu naɲ bay tôri naɲji menba, bay ɗayji bô kwônê bato bi wo hen a aɲ ôrji Kapêrnayôm ciré ô wogé Jésu. ");
INSERT INTO kqp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kiriɲa bay uwoɲni cêgi cér a menba, bay kôli iyôŋ ba: «*Rabi, ju sa nà ná kiriɲ ka yôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Menba, Jésu uwôlji sara iyôŋ ba: «Na kelêŋge na tu kwôlê, ken wogen na wô giɲê wo ken gel en li hen né niɲba, na wô mapa wo na ken ôm uyirê hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lêŋge jé na wô aŋgaɲ emê ka kiya a uyê hen né niɲba, ken li jé wô ka a yé yôd aɲ a lê aɲ ka merê naɲ kunuŋge a men hen ɗi. Aŋgaɲ emê bay ka hen na, na nôbi *Kema Gawra a béŋge. Wôsa na Ibarna Emen a ben tôô hende to hen bi ené liɲ hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Menba, ɓiɲé bay ka hen eŋgeriɲ Jésu iyôŋ ba: «Na ba, niɲa lê iyeŋ a niné lê aŋga Emen gey niné li hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Menba, Jésu uwôlji sara iyôŋ ba: «Jé wo Emen gey bi wo hen na, na wo kené bi bôrŋge sa kwo ôbi jori a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Menba, bay kôli iyôŋ ba: «Aŋgaɲ giɲê kaɲ gelé ka yôŋ a jeré lê béni bi niné gel aɲ bi niné biɲ bôrni sam a ba? ");
INSERT INTO kqp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Môɲêrni na ôm aŋgaɲ emê ka bay uwôgeri *man ka na hena derômaraŋ a derô gwôlê hen, mega wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: ‹Ôbi na biji emê wo hena derômaraŋ a bay na ôm.› » ");
INSERT INTO kqp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Menba, Jésu kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: *Moyis a na béŋge emê bi wo na hena derômaraŋ a hen né, niɲba, nà ná Iban a na béŋge emê woɲ tiri bi wo hena derômaraŋ a hen ɗi.» ");
INSERT INTO kqp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wôsa emê wo Emen na, na kwo hena derômaraŋ a aɲ ôbi a lê a ɓiɲé ré mô tu geɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Menba, ɓiɲé bay ka hen uwôli sara iyôŋ ba: «Kelma, béni emê bi wo hen kwôy kwôy.» ");
INSERT INTO kqp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Menba, Jésu kôlji iyôŋ ba: «Na nôbi, a na emê woɲ merê tu geɲ bi wo hen, aɲ kwôni wo era yen a ba, kurôŋ a liri ré niɲ men, kwo bi bôri san a ba, kam a diri ré niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Niɲba, ré ené kelêŋge ken gelen naɲ turŋge hen niɲ, kôba, ken kaɲ bê bôrŋge san a a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓiɲé kêm ka Iban ben hen na, a era legen a men, kwôni wo era legen a ba, na dagêri nô ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wôsa en hena derômaraŋ a era sa terare a, na wô lê bô geyé wuɲê ré, niɲba, bô geyé wo kwo joon hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bô geyé wo kwo joon bi wo hen na, na bi ené gem ka ôbi ben hen dô, ɗiba, ené ɗi pôn iyôŋ kôba, ré kay ré men, bi ené biji ré ji si kamɲê Wulê woɲ jerê kwôlê a a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bô geyé wo Iban na, na wo i i wo ré gel Kemari aɲ bi bôri sari a na, ré mô naɲ kwini men, bi ené sa biri ré ji si kamɲê Wulê woɲ jerê kwôlê a a men.» ");
INSERT INTO kqp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sa kwôlo Jésu na kôl hen Jubɲê kôl perêrji a kôl iyôŋ ba: «Ena emê wo hena derômaraŋ a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Menba, bay kôl iyôŋ ba: «Ôbi a na Jésu woɲ kema Josêp na ré ba? Men, nana hôn ibari naɲ yori a men ré ba? Menba, ôbi uwôɲ na yôŋ a ré kôl iyôŋ ba: ‹Ena emê woɲ merê tu geɲ wo hena derômaraŋ a hen ba?› » ");
INSERT INTO kqp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Menba, Jésu uwôlji sara iyôŋ ba: «Ɲamniɲge perêrŋge a ré. ");
INSERT INTO kqp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hena Iban wo joon hen, ré wuro kwôni ben ré na, ôbi nêm wo a era uɲen sa kibri ré, aɲ nôbi, na sa biri jê sé kamɲê Wulê woɲ jerê kwôlê a. ");
INSERT INTO kqp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bay kibi Emen na li bô magtubu a kôl iyôŋ ba: ‹Ɓiɲé kêm na, Emen a sa geléji kwôlê.› Aɲ kwo sa toy kwôlo Iban aɲ bi bôri sara hen na, a era uɲen. ");
INSERT INTO kqp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kwôni wo sa terare a nà wo gel Emen naɲ tiri ba, naɲ tô, niɲba, na kwo hena ligi Emen a hen a gelé Ibarna Emen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na kelêŋge na tu kwôlê: kwôni wo bi bôri san a na, a merê naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nôbi a na emê woɲ merê tu geɲ. ");
INSERT INTO kqp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Môɲêrŋge na ôm man derô gwôlê kôba, bay na ma. ");
INSERT INTO kqp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Niɲba, emê wo hena derômaraŋ a hen bi a nà, aɲ i i wo ôm ba, a ma ré. ");
INSERT INTO kqp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ena emê woɲ merê tu geɲ wo hena derômaraŋ a, aɲ hena kwôni ré ôm emê bi wo hen na, ôbi a merê naɲ kwini. Emê wo na bé hen na, na kurôŋgi yen wo na bé wô merê tu geɲ wo ɓiɲé sa terare a nà.» ");
INSERT INTO kqp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kwôlo Jésu kôl hen na, bay sa Jubɲê kôl perêrji a kôl iyôŋ ba: «Ôbi a lê iyeŋ a ré béna kurôŋgi yiri nana emê ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Menba, Jésu uwôlji sara iyôŋ ba: «Na kelêŋge na tu kwôlê: hena kené ôm kurôŋgi yen nôbi Kema Gawra ré men, ken yi kwôbreren ré a men na, ka merê tu geɲ woɲ tiri hen né. ");
INSERT INTO kqp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kwôni wo ôm kurôŋgi yen men, yi kwôbreren a men na, ôbi a merê naɲ kwini, aɲ na sa biri jê sé kamɲê Wulê woɲ jerê kwôlê a. ");
INSERT INTO kqp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wôsa kurôŋgi yen a na emê woɲ tiri woɲ emê men, kwôbreren na aŋgaɲ yê kaɲ tiri kaɲ yê a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kwôni wo ôm kurôŋgi yen men, yi kwôbreren a men na, ôbi biɲ naɲ en men, nôbi kôba, na biɲ naɲ ɗi men. ");
INSERT INTO kqp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mega Iban woɲ ôbi jonare mô geɲ hen iyôŋ na, nôbi kôba, na sa kibri aɲa ené môriɲ geɲ men hen. Ôbi a, kwôni wo ré ôm kurôŋgi yen ba, a merê tu geɲ wô keben men hen. ");
INSERT INTO kqp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na emê wo hena derômaraŋ a bi a nà, ôbi na mega kwo môɲêrŋge na ôm kôba, na maɲ hen né. Niɲba, kwôni wo ôm emê bi wo hen na, ôbi a merê naɲ kwini.» ");
INSERT INTO kqp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jésu geliɲ ɓiɲé kwôlê bi wo hen na *iyéy daɲare a Kapêrnayôm a. ");
INSERT INTO kqp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bay tôri toy kwôlê bi wo hen menba, ka pôni kwône kôl iyôŋ ba: «Kwôlo ôm hen na, iyêre gaɲ hen ba, i a geyé ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jésu hôn wo bay tôri ré kôl kwôlê sa kwôlê bi wo hen a menba, ôbi kôlji iyôŋ ba: «Kwôlê bi wo hen mêne bôrŋge ba? ");
INSERT INTO kqp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A hen ba, hena kené sa gelen nôbi Kema Gawra hena hô kiriɲ ka en na henaɲ ya hen ba, ka sa kelê iyeŋ niɲ ba? ");
INSERT INTO kqp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na Tunu toɲ hendi bô bôrê a na hendi bé merê tu geɲ ɗiba, kurôŋgi yi nêm ani ré. Kwôlo ené kôl hen na, na kwôlê woɲ Tunu men, hende a bé merê tu geɲ a men. ");
INSERT INTO kqp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Niɲba, ɓiɲé ka pôni perêrŋge a hen na, bi bôrji san a ré.» Jésu na kôl hen iyôŋ wôsa ôbi na hôn ka ré bê bôrji sari a ré hen men, kwo ré sa ayê sari hen a men niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Menba, Jésu hô kôlji iyôŋ ba: «Na ôbi á, na ené kelêŋge iyôŋ ba: Hena Emen né biɲ kwôni geré ré ba, ôbi naɲ yiri a era bê bôri san a ré.» ");
INSERT INTO kqp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kiriɲ bay ka hen na, bay tôri ka pôni dô yirji yiri a aɲ. ");
INSERT INTO kqp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Menba, Jésu kôliɲ bay tôri ka môj kibi wôô hen iyôŋ ba: «A kenbay, kôba ka derê yerŋge yen a aɲ men ba?» ");
INSERT INTO kqp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Menba, Simô Piyêr uwôli sara iyôŋ ba: «Kelma, niɲa erê uɲé na i men ba? Wôsa na jôbi pôn nêŋ a naɲ kwôlo a biɲ ɓiɲé merê wo naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nini bi bôrni sam a men, nini hôn wo jeré na Kwo yi naɲ jeŋgêri wo Emen jori hen men.» ");
INSERT INTO kqp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Menba, Jésu uwôlji sara iyôŋ ba: «Na nôbi a terêŋge kenbay ka môj kibi wôô hen ré ba? Niɲba, kwo pôni perêrŋge a hen na Sidan.» ");
INSERT INTO kqp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ôbi kôl hen iyôŋ na wô Judas Iskariyôt kema Simô, wôsa ôbi a na kwo perê bay tô Jésu ka môj kibi wôô hen wo a sa ayê sari. ");
INSERT INTO kqp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kiriɲa Jésu iyêliɲ bay tôri kwôlê kô niɲ hen iyôŋ menba, ôbi ô gôr emê wo Galilé wôsa ôbi gey erê emê wo Judé a ré, wôsa bay sa Jubɲê woge wo ciré deréri. ");
INSERT INTO kqp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wulê bi wo hen na, sa lê geserê wo Jubɲê wo bay uwôgeri kwoɲ iyéy gergé hen baa ɗa. ");
INSERT INTO kqp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Menba, yênêri kôli iyôŋ ba: «Hena ta, ju ô Judé aɲ bi bay tôm ô gelé are kêm ka ju li hen men. ");
INSERT INTO kqp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Hena kwôni ré gey bi ɓiɲé ré hôni ba, a lê ani naɲ ɲalê ré, mega wo ju li aŋga geliɲ hen iyôŋ na, liji aɲ bi tu ɓiɲé gel.» ");
INSERT INTO kqp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yênêri kaɲ ɗéɲ ɗéɲ bay kôba, kaɲ bê bôrji sari a men. ");
INSERT INTO kqp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Menba, Jésu kôlji iyôŋ ba: «Wulê wuɲê nôbi nêm ré tô, niɲba, kenbay ba, wulê kêm na kwo dôri. ");
INSERT INTO kqp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kenbay ba, ɓiɲé a derêŋge ré, niɲba, nôbi ba, bay a dôren, wôsa en dô kwôli jé lêreji wo habiɲ hen ta. ");
INSERT INTO kqp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kenbay ken ô lê geserê bi wo hen haŋge, niɲba, nôbi ba, na erê ré, wôsa wulê wuɲê nêm ré tô.» ");
INSERT INTO kqp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kiriɲa Jésu kôlji hen iyôŋ menba, ôbi ba, tôŋ Galilé. ");
INSERT INTO kqp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kiriɲa yênêri ôrji lê geserê bi wo hen niɲ, menba, Jésu ô men, niɲba, ôbi ô naɲ ɲalê ɗiba, kwôni hôn né. ");
INSERT INTO kqp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bay sa Jubɲê wogeri kini lê geserê bi wo hen a, aɲ eŋgereji iyôŋ ba: «Ôbi yôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɓiɲé kôl kwôlê damaŋ gengiɲ sari aɲ ka pôni kôl iyôŋ ba: «Ôbi na gawra wo dôri» men, ka pôni kôl iyôŋ ba: «Ôbi na gawra wo habiɲ wôsa ôbi bi ɓiɲé kay damaŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Niɲba, kwôni wo ré kôl kwôli Jésu kaŋ ta ba, naɲ wôsa bay hariɲ bay sa Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kiriɲa bay li geserê kwôy sa bôb derôre a niɲ menba, Jésu ô derô haba wo *iyéy Emen a ô geliɲ ɓiɲé are. ");
INSERT INTO kqp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Derê kwôlê wori bi wo ɗê kiriɲ menba, bay sa Jubɲê kôl iyôŋ ba: «Ôbi dôyrê magtubu to Emen né menba, li iyeŋ a ôbi ré hôn tôô to Emen hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Menba, Jésu uwôlji sara iyôŋ ba: «Aŋga en geliɲ ɓiɲé hen na, na kaɲê ré, niɲba, na ka kwo joon hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hena kwôni wo ré gey lê bô geyé wo Emen dema ré henê na ba, gelé aŋgaɲê bay ka hen, ré na ka Emen laba, ené iyêl na sa keben ɗi ba tô. ");
INSERT INTO kqp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kwôni wo kôl kwôlê sa kibri na, ôbi woge na hini emê wo gengiɲ sari niɲba, kwo woge hini emê wo kwo jori hen na, na ôbi a kelê kwôlê woɲ tiri. Kwôni bi wo iyôŋgi hen na, na ôbi lê aŋgaɲ lamê tu kiriɲ né. ");
INSERT INTO kqp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","*Moyis na béŋge tôô niɲba, kwôni na bi kwôlê sa tôô hende to hen a ré, menba, wô mi a kené gey kené deren ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Menba, kwônê ɓiɲé uwôli sara iyôŋ ba: «Ba, ju yé? I a geyé ɗiré derem ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Menba, Jésu uwôlji sara iyôŋ ba: «En li giɲê na pôn tô naɲ *sa merê ta menba, tunuŋge ge kay mera ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyis na béŋge tôô toɲ walê keŋ. Ôbi a, hena ré na naɲ sa merê ta, a wulê woɲ waliɲ gawra keŋ ré nêm ba, ken wali keŋ hen. (Tiri wori ba, tôô hende to hen, hena na yi Moyis a ré, niɲba, hena na yi môɲêrŋge a ɗi.) ");
INSERT INTO kqp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Hena kené waliɲ kema wo dê keŋ naɲ sa merê ta bi tôô to Moyis ré ɗagiɲ ré ba, wô mi a kené ɗi bôrŋge tarêŋge san a, kiriɲa en berare yi gawra yôd sa merê ta a ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jerêŋge kwôlê naɲ kini ɗiba, ken jô kwôlê woɲ bôd a tôŋ hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɓiɲé ka pôni ka Jérusalêm kôl iyôŋ ba: «Na gawra wo bay wogeri ciré deréri bi a na ré ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ôbi iyêl ɗibiɲ tu wolé hen iyôŋ menba, bay kôl kwôlê wôni ré, wô mi ba? Na ba, kilmérna hôn wo ôbi ré na *Krist, kwo Emen dôri hen niɲ ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wôsa gawra wo hen na, nana hôn kiriɲ ka ôbi henaɲ ya hen, niɲba, kiriɲa Krist, kwo Emen dôri hen a sa na, kwôni a henê kiriɲ ka ôbi henaɲ ya hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Menba, Jésu geliɲ ɓiɲé kwôlê derô haba wo iyéy Emen a aɲ iyêl kaŋ ta kôl iyôŋ ba: «Ken hôn kiriɲ ka en henaɲ ya hen dô men, ken hônen a men, en era na sa keben né, niɲba, kwo joon hen na, na gawra woɲ ôbi bôô pôn niɲba, ken hôni ré. ");
INSERT INTO kqp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Niɲba, nôbi ba, en hôni wôsa en hena na ligiri a, aɲ na ôbi a joon hen.» ");
INSERT INTO kqp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bay woge ciré ɓeréri niɲba, bay nêm ɓeréri ré, wôsa wulê woɲ ɓeréri nêm ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɓiɲé kwône bi bôrji sari a aɲ bay kôl iyôŋ ba: «Kiriɲa Krist, kwo Emen dôri hen a sa sa ba, ôbi a lê giɲê ɗê kwo gawra hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kiriɲa *Parisiɲêɲê toy kwôlo ɓiɲé kôl gengiɲ sa Jésu hen, menba, damné kaɲ bay bê kwôbe naɲ Parisiɲêɲê jé bay gemé iyéy merê ré ô ɓerori eraɲ. ");
INSERT INTO kqp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jésu kôl iyôŋ ba: «Na merê naɲ ken sem a, dema ené herê ligi kwo joon a hen tô. ");
INSERT INTO kqp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aɲ ka sa wogen niɲba, ka uɲen né, wôsa ka nêmê biɲ kiriɲ ka na môriɲ ya hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sa kwôlo ôbi kôl hen menba, Jubɲê kôl kôl iyôŋ ba: «Kiriɲ ka yôŋ a ôbi ré erê ya a nana uwoɲni ré ba? Ôbi a erê uɲé na Jubɲê ka useriɲ sa iyé Grêkɲê hen aɲ a erê geliɲ Grêkɲê are ɗê. ");
INSERT INTO kqp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Bô kwôlo ôbi kôl iyôŋ ba: ‹Ka sa wogen niɲba, ka uɲen né, wôsa ka nêmê biɲ kiriɲ ka na môriɲ ya hen né hen ba, na iyeŋ ba?› » ");
INSERT INTO kqp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gerɲé wulê lê geserê wo na wulê wo dami hen na, Jésu hena ɗebu ta aɲ iyêl kaŋ a ta kôl iyôŋ ba: «Hena kwôni wo kam ré diri ba, bi era uɲen aɲ sa yi kam ka na biri hen. ");
INSERT INTO kqp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kwôni wo bi bôri san a ba, hanê kam kaɲ gelê a geré bôri a, mega wo magtubu to Emen kôliɲ hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jésu kôl hen iyôŋ gengiɲ na sa Tunu to ka bi bôrji sari a hen ré sa uɲé, wôsa Tunu hende to hen na biɲ ré tô, wôsa Jésu uwôɲ damɲare tori ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɓiɲé toy kwôlo ôbi kôl hen menba, bay kôl iyôŋ ba: «Gawra wo hen, na *ôbi kibi Emen wo nana mô gemni bi tiri.» ");
INSERT INTO kqp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Men, ka pôni kôl iyôŋ ba: «Na Krist, kwo Emen dôri hen» men, ka pôni kôl iyôŋ ba: «Krist, kwo Emen dôri hen bi a hena na Galilé men ba? Eŋ eŋ. ");
INSERT INTO kqp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Magtubu to Emen kôl ôbi réé hena na tô môɲ wo kelma Dabid a men, sa iyé kelma Dabid to bay uwôgere Bêteléhêm hen a men ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Menba, ɓiɲé kariɲ sa kibi Jésu. ");
INSERT INTO kqp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ka pôni perê gey ciré ɓeréri niɲba, kwôni ɓiri ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kiriɲa bay gemé iyéy Emen hen bulo hera menba, damné kaɲ bay bê kwôbe naɲ Parisiɲêɲê eŋgeriji iyôŋ ba: «Wô mi a kené ɓurori ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Menba, bay uwôlji sara iyôŋ ba: «Nini gel gawra wo iyêl môɲ kwo hen sa pôn né.» ");
INSERT INTO kqp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisiɲêɲê kôlji iyôŋ ba: «Kenbay kôba, ken ɗo bay lamaŋge men ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ken gelo dami wona wôni ley, *Parisiɲê ley ba bôrji sari a men ba? ");
INSERT INTO kqp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kwônê ɓiɲé bay ka hen na, bay hôn tôô to Moyis dô ré, aɲ tômê ɓu sarji.» ");
INSERT INTO kqp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisiɲê wo pôni wo bay uwôgeri Nikwodêm wo na era sa uwôɲ Jésu yoyre hen kôliɲ megêri iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Tôô tona jôô wo nana ɓu gawra naɲ kwôlê pa dema ôbi ré dô kwôli aŋga ôbi li hen tô.» ");
INSERT INTO kqp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Menba, bay uwôli sara iyôŋ ba: «Jôbi ju na kwo Galilé men ba? Kôbe bô magtubu to Emen a aɲ já gelé wo ôbi kibi Emen wôni ré hena Galilé ré kwôy.»  ");
INSERT INTO kqp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Menba, i i kôba hô iɲ iɲ. ");
INSERT INTO kqp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kiriɲa i i kôba, ô iɲ niɲ menba, Jésu ô sa Keram wo Olibiyé. ");
INSERT INTO kqp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tô kiriɲ cud menba, ôbi bul hô derô haba wo *iyéy Emen a menba, ɓiɲé kêm uso ɗa ligiri a. Ôbi mô tôŋ aɲ dôrji kwôlê. ");
INSERT INTO kqp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Menba, *bay derê tô tôô to Emen naɲ *Parisiɲêɲê eraɲ naɲ iyore to bay jerare sa wôniɲare toɲ têriɲ hen. Aɲ bay ɗere ɗebe tumô ɓiɲé kêm. ");
INSERT INTO kqp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Menba, bay kôliɲ Jésu iyôŋ ba: «*Rabi, iyore to nà ná, nini jerare sa wôniɲare toɲ têriɲ a. ");
INSERT INTO kqp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tôô to *Moyis na kelêni mega wo yébé bay ka iyôŋgi hen na, bi niné gôbiji deréɲ naɲ jerew. Niɲba, kwom jôbi ba, ju kôl iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bay eŋgereri hen iyôŋ bi ciré séliɲni bi ciré ɗiɲ kwôlê sari a. Niɲba, Jésu he sari tôŋ aɲ ɗi ani terare naɲ kema kôbri. ");
INSERT INTO kqp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mega wo bay eŋgereri têê kwône hen iyôŋ menba, Jésu dô sari ta, aɲ kôlji iyôŋ ba: «Bi kwôni wo perêrŋge a hen wo li têriɲ ré ba, ay jerew uwôliɲ iyore hende to hen tumô na gelé.» ");
INSERT INTO kqp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Menba, ôbi hô he sari tôŋ aɲ ɗi ani terare a. ");
INSERT INTO kqp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kiriɲa bay toy hen iyôŋ menba, bôrji dôyrêji aɲ bay ɲal pôn pôn ô, ayiɲ tôri sa surɲê a kwôy sa sa kaɲ kamrê. Menba, Jésu naɲ iyore hende to ré ɗebu derôrji a hen a baji mera. ");
INSERT INTO kqp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kiriɲa Jésu dô sari ta aɲ gel na iyore hende to hen a ɗebé baa hen mera menba, ôbi kôle iyôŋ ba: «Bay ô yôŋ ba? Kwôni jô kwôlê wôni sarê ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Menba, hende uwôli sara iyôŋ ba: «Kelma, kwôni jô kwôlê wôni san a ré.» Menba, Jésu kôle iyôŋ ba: «Nôbi kôba, en ɓiré naɲ kwôlê ré men, ô harê niɲ, niɲba, mu hô li têriɲ ré niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jésu hô kôlji iyôŋ ba: «Ena kiriɲ ka peraŋgi ka sa terare a nà. Kwôni wo era tôn a ba, a erê kiriɲ ka hendi a ré niɲ, niɲba, ôbi a uɲé kiriɲ ka peraŋgi ka a biri ôbi a merê tu geɲ hen.» ");
INSERT INTO kqp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sa kwôlo ôbi kôl hen menba, Parisiɲêɲê kôli iyôŋ ba: «Ju dô kwôlem naɲ kem hen na, kwôlê wom bi wo hen na tiri ré.» ");
INSERT INTO kqp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Menba, Jésu uwôlji sara iyôŋ ba: «Hena ené dô kwôlê wuɲê naɲ keben kôba, na tu kwôlê wôsa en hôn kiriɲ ka en henaɲ ya men, ka na ôriɲ ya hen a men, niɲba, kenbay ken hôn kiriɲ ka en henaɲ ya hen né men, ka na ôriɲ ya hen né a men. ");
INSERT INTO kqp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kenbay ba, jerê kwôlê woŋge na mega gawrê jôriɲ hen iyôŋ niɲba, nôbi en jô kwôlê sa kwôni a ré. ");
INSERT INTO kqp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A hena ené jô kwôlê sa kwôni a ba, jerê kwôlê wuɲê bi wo hen na, biɲ naɲ tu kwôlê wôsa ena penen ré, niɲba, Iban wo joon hen na naɲ en. ");
INSERT INTO kqp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Men liɲ bô magtubu tôô toŋge a kôl iyôŋ ba: ‹Hena ɓiɲé wôô ré dô kwôli kwôni na, na tu kwôlê a bay ré kôl hen.› ");
INSERT INTO kqp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","En dô kwôlen naɲ keben men, Iban wo joon hen kôba, dô kwôlen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Menba, bay kôli iyôŋ ba: «A Ibam bi yôŋ ba?» Menba, Jésu uwôlji sara iyôŋ ba: «Ken hônen ré men, ken hôn Iban ré a men. Hena kené hônen ba, ka henê Iban men.» ");
INSERT INTO kqp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jésu kôlji kwôlê bi wo hen, na kiriɲa ôbi geliɲ ɓiɲé are bô iyéy Emen a kwa kiriɲ ka kini bê gursu yiɲ ya hen niɲba, kwôni pôn iyôŋ kôba, ɓiri ré wôsa wulê wori nêm ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jésu hô kôlji iyôŋ ba: «Na erê aɲ ka wogen aɲ ka maɲ tô têriɲ toŋge a. Ka nêmê erê kiriɲ ka na erê ya hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sa kwôlê bi wo hen a na, damné ka Jubɲê kôl iyôŋ ba: «Ôbi a deré yiri naɲ kôbri a ré kôl iyôŋ ba: ka nêmê erê kiriɲ ka na erê ya ré hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Menba, Jésu kôlji iyôŋ ba: «Kena ka tôŋ nà, niɲba, nôbi ena kwo ta. Ken ô tô aŋga sa terare a nà, niɲba, nôbi ba, en ô tô aŋga sa terare nà ré. ");
INSERT INTO kqp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na ôbi á, ré ené kelêŋge kené ma tô têriɲ toŋge a hen, wôsa hena kené bi bôrŋge sa kwo en kôl ené na ôbi hen ré ba, ka ma tô têriɲ toŋge a.» ");
INSERT INTO kqp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bay eŋgereri iyôŋ ba: «Ju na i ba?» Menba, Jésu uwôlji sara iyôŋ ba: «Ôbi a ré ené kelêŋge tumô niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kwôlo ré ené kelê men, jerê men gengiɲ sarŋge na, yi damaŋ niɲba, kwo joon hen na, kôl na tu kwôlê aɲ na kwôlo en toya kibri a a ené kôliɲ ɓiɲé ka sa terare a nà hen.» ");
INSERT INTO kqp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Niɲba, bay hôn wo ré gengiɲ na sa Ibari a ôbi ré kôlji hen né. ");
INSERT INTO kqp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jésu hô kôlji iyôŋ ba: «Wulê wo ka sa ɗén nôbi *Kema Gawra ta sa gurô tagelê hen dema kené henê kwo en kôl ené na ôbi hen, ené li ani kani sa keben ré niɲba, ré na aŋga Iban na ré gelen hen a ené kôl kwôliji hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ôbi wo na joon hen, na naɲ en ɗiba, ôbi ɗén aɲ né, wôsa en li na aŋga bôri ôbi gey hen.» ");
INSERT INTO kqp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jésu iyêl hen iyôŋ menba, ɓiɲé kwône bi bôrji sari a. ");
INSERT INTO kqp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Menba, ôbi kôliɲ Jubɲê ka bi bôrji sari a hen iyôŋ ba: «Hena kené gem kwôlê wuɲê bôrŋge a na, kena bay tôn tiri. ");
INSERT INTO kqp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Men, ka henê tu kwôlê men, tu kwôlê bi wo hen a derêŋge bô lemnare a a men.» ");
INSERT INTO kqp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Menba, bay uwôli sara iyôŋ ba: «Nibay nina kwôŋgê *Abraham men, kwôni na lêni lemnare ré a men, menba, wô mi a jeré kôl iyôŋ ba: ‹Ka merê sarŋge seŋge ba?› » ");
INSERT INTO kqp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Menba, Jésu hô uwôlji sara iyôŋ ba: «Na kelêŋge na tu kwôlê, hena kwôni ré ay yiri biɲ têriɲ na, ôbi na lema wore. ");
INSERT INTO kqp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lema a merê bô ira kwôy ré, niɲba, kema iyére a merê ya kwôy ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hena nôbi Kema Gawra ené derêŋge bô lemnare to têriɲ a ba, ka merê sarŋge seŋge tiri a men. ");
INSERT INTO kqp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","En hôn wo kené na kwôŋgê Abraham a men, niɲba, ken gey bi kené deren wôsa ken gey kwôlê wuɲê ré. ");
INSERT INTO kqp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nôbi en kôl na kwôli aŋga en gel yi Iban a, niɲba, kenbay ken li na aŋga na toy kwôliji kibi ibareŋge a.» ");
INSERT INTO kqp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Menba, bay uwôli sara iyôŋ ba: «Nibay ibarni na Abraham.» Niɲba, Jésu uwôlji sara iyôŋ ba: «Hena henaŋ kené na kam Abraham ba, henaŋ kené lê aŋga Abraham na li hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Haw hen ken gey kené deren nôbi woɲ ôbi kelêŋge tu kwôlê wo en toy kibi Emen a hen, niɲba, Abraham wo na ibareŋge bi hen na, na li hen iyôŋ né. ");
INSERT INTO kqp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kenbay ken li na aŋga ibareŋge na li.» Menba, bay kôli iyôŋ ba: «Nibay niɲa lamnaɲê ré, wôsa Emen pôn nêŋ hari a na Ibarni.» ");
INSERT INTO kqp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Menba, Jésu kôlji iyôŋ ba: «Hena Emen henaŋ a ré na Ibareŋge na, henaŋ kené geyen, wôsa en hena na ligi Emen a a ené sa hen men, en era na sa keben ré, niɲba, na ôbi a joon hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Menba, wô mi a kené hôn bô kwôlê wuɲê ré ba? Wôsa ken nêm toyé kwôlê wuɲê ré. ");
INSERT INTO kqp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ibareŋge na Sidan aɲ ken gey lê na aŋga bô ibareŋge gey hen. Ôbi na na ôbi deré temare ca tumô yeŋ men, na ôbi benare a men ɗiba kwôlê woɲ tiri naɲ yiri a. Kiriɲa ôbi gey lê benare na, ôbi kôl kwôlê naɲ sa yiri, wôsa ôbi na ôbi lê benare men, ôbi na iba benare a men. ");
INSERT INTO kqp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Niɲba, na wô wo en kôl tu kwôlê hen aɲa kené kaɲ bê bôrŋge sara hen. ");
INSERT INTO kqp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","I a perêrŋge a hen a gelé wo ené li têriɲ ba? A hena ené kôl na tu kwôlê ba, wô mi a kené kaɲ bê bôrŋge san a ba? ");
INSERT INTO kqp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kwôni wo na kwo Emen na, toy kwôlo Emen kôl hen, niɲba, kenbay ken toy ré, wôsa kena ka Emen né.» ");
INSERT INTO kqp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Menba, Jubɲê uwôli sara iyôŋ ba: «Kwôlo na nini kôl jeré na gawra wo Samari men, tunu to habiɲ ré yi bôm a a men hen na, na na benare ré.» ");
INSERT INTO kqp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Menba, Jésu uwôlji sara iyôŋ ba: «Tunu to habiɲ yi bôn a ré, niɲba, en ay na kibi Iban menba, ken ay keben né. ");
INSERT INTO kqp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","En woge na hini emê wuɲê ré, niɲba, ôbi a wogé hini emê wo gengiɲ san men, ôbi jerê kwôlê a men na, hen ya. ");
INSERT INTO kqp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na tu kwôlê a ené kelêŋge hen: kwôni wo gem kwôlê wuɲê bôri a na, temare a deréri ré niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Menba, Jubɲê kôli iyôŋ ba: «Haw hen nini hôn wo tunu to habiɲ ré yi bôm a niɲ. Wôsa *Abraham ma men, bay kibi Emen kôba maji a men, menba, jôbi ju kôl iyôŋ ba: ‹Hena kwôni ré gem kwôlê wuɲê ba, temare a deréri ré niɲ.› ");
INSERT INTO kqp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Jôbi ju na kwo dami ɗê Abraham wo na ma hen ba? Bay kibi Emen kôba, maji menba, jôbi ju li yem môɲ i iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Menba, Jésu uwôlji sara iyôŋ ba: «Hena ené ay kibi yen ba, ayê kibi yi wuɲê bi wo hen na ani ré. Na Iban wo ken kôl ré na Emen woŋge hen a ayê keben. ");
INSERT INTO kqp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ken hôni ré, niɲba, nôbi ba, en hôni. Hena ené kôl ené hôni ré na, réé ené yé ôbi benare môɲ kenbay iyôŋ men, niɲba, en hôni men, en gem kwôlê wori a men. ");
INSERT INTO kqp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ibareŋge Abraham na sê peré wo ɗiré gelé wulê wuɲê bi wo hen. Ôbi na gel aɲ na li yi derê.» ");
INSERT INTO kqp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Menba, Jubɲê kôli iyôŋ ba: «Elêrem nêm tôre bay ré tô menba, na ju gel Abraham niɲ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Menba, Jésu uwôlji sara iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: pa dema Abraham na ré yêɲ tô na, na en ya niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kiriɲa bay toy hen iyôŋ menba, bay pô jerew ciré gôbiɲni menba, Jésu uwôbe aɲ séɲ derô haba wo *iyéy Emen a aɲ ô. ");
INSERT INTO kqp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wulê wo pôni Jésu ô tô geré menba, ôbi gel gawra wo pôni wo tiri na toɲ bô yori a. ");
INSERT INTO kqp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Menba, bay tôri eŋgereri iyôŋ ba: «*Rabi, gawra wo nà ba, na wô kibi têriɲ tori laba to balêri a lê aɲa tiri ré tiɲ bô yori a hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Menba, Jésu uwôlji sara iyôŋ ba: «Na wô sa têriɲ tori ré men, to balêri ré a men, niɲba, tiri tiɲ bi néé wo Emen ré gel yiri nô sari a. ");
INSERT INTO kqp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mega wo kiriɲ ka peraŋgi baa nà tô hen na, bi na lêŋge jé wo kwo joon hen. Wôsa yoyre baa ɗa niɲ aɲ kwôni a nêmê lê jé ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mega wo en baa sa terare a nà tô hen na, ena kiriɲ ka peraŋgi ka ɓiɲé ka sa terare a nà.» ");
INSERT INTO kqp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kiriɲa ôbi kôl kwôlê bi wo hen iyôŋ kô niɲ menba, ôbi tebe kalê tôŋ aɲ bulôɲiɲ terare. Ôbi ay terare hende to ôbi bulôɲ hen aɲ li tu ôbi tu tiɲ bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aɲ Jésu kôli iyôŋ ba: «Ô ju ô pelé tum bô kam tagare ka bay uwôgeji Silowé hen.» (Silowé bôri na ôbi jé.) Ôbi ô pelé tiri bô kam tagare hende to hen menba, ôbi gel kiriɲ dô aɲ bulo hera. ");
INSERT INTO kqp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bay kwari men, ɓiɲé ka na hôni tumô tumô môɲ ôbi uwôlê are hen na, bay kôl iyôŋ ba: «Kamaŋ, na gawra wo na miirê uwôl are na hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Menba, ka pôni kôl ré na ôbi men, ka pôni kôl ré na kwôni wo geliɲ naɲ ɗi ɗi men. Menba, ôbi naɲ kibri kôlji iyôŋ ba: «Na nôbi.» ");
INSERT INTO kqp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Menba, bay kôli iyôŋ ba: «Ju li iyeŋ a jeré gel kiriɲ hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Menba, ôbi kôlji iyôŋ ba: «Gawra wo bay uwôgeri Jésu hen a bulôɲê terare aɲ lên tun a, aɲ kôlen iyôŋ ba: ‹Ô ju ô pelé tum bô kam tagare to Silowé.› Menba, en ô pelé tun menba, en gel kiriɲ mera.» ");
INSERT INTO kqp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Menba, bay hô eŋgereri iyôŋ ba: «Gawra bi wo hen na yôŋ ba?» Menba, ôbi kôlji iyôŋ ba: «En hôn né.» ");
INSERT INTO kqp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Menba, bay ôriɲ naɲ gawra bi wo tiri na tiɲ ligi *Parisiɲêɲê. ");
INSERT INTO kqp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na na naɲ *sa merê ta a aɲa Jésu na ré bulôɲ terare li a tu gawra bi wo hen aɲ biri gel kiriɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Menba, Parisiɲêɲê kôba hô eŋgereri men, ôbi ré li na iyeŋ a ré gel kiriɲ hen ba? Menba, ôbi kôlji iyôŋ ba: «Ôbi bulôɲ terare lên tun a aɲ en ô pelé menba, en gel kiriɲ mera.» ");
INSERT INTO kqp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sa kwôlê bi wo hen a na, Parisiɲêɲê ka pôni kôl iyôŋ ba: «Gawra wo hen na, hena na ligi Emen a ré, wôsa ôbi bi kwôlê sa sa merê ta a ré.» Men, ka pôni kôl iyôŋ ba: «Gawra woɲ ôbi têriɲ ba, a lê iyeŋ a ré lêrê giɲê wo hen iyôŋ ba?» Menba, kariɲare yi perêrji a. ");
INSERT INTO kqp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Menba, bay hô eŋgere ôbi tu tiɲ na iyôŋ ba: «Kiriɲa ôbi li aɲ ju gel kiriɲ hen iyôŋ na, jôbi ba, na kwôli mi a jeré kôl gengiɲ sari ba?» Menba, ôbi uwôlji sara iyôŋ ba: «Ôbi na *ôbi kibi Emen.» ");
INSERT INTO kqp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bay sa Jubɲê na wo ôbi na ré na ôbi tu tiɲ aɲa ré gel kiriɲ hen iyôŋ né kwôy wo bay ô eraɲ naɲ balêri. ");
INSERT INTO kqp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Menba, bay eŋgereji iyôŋ ba: «Na kemarŋge wo ken kôl tiri ré tiɲ bô yori a bi a nà ba? Menba, li iyeŋ a ôbi ré gel kiriɲ haw hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Menba, bay uwôlji sara iyôŋ ba: «Nini hôn wo ré na kemarni men, nini hôn wo tiri na ré tiɲ na bô yori a a men. ");
INSERT INTO kqp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Niɲba, ôbi li iyeŋ a ré gel kiriɲ ba, ba nini hôn né. Men, i a lê a ôbi ré gel kiriɲ hen ba, ba a men ba, nini hôn ré niɲ. Eŋgeréŋgeri, tiri sur niɲ hen na, ôbi a kelê kwôlo gengiɲ sari.» ");
INSERT INTO kqp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na ôbi á, balêri ré kôl hen iyôŋ wôsa bay hariɲ bay sa Jubɲê wôsa bay na genge mega wo hena kwôni wo ré hôn Jésu ré na *Krist, kwo Emen dôri hen na, bay réé dagêri bô *iyéy daɲare a. ");
INSERT INTO kqp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Na ôbi á, balêri ré kôl iyôŋ ba: «Tiri sur niɲ hen na, eŋgeréŋgeri ôbi hen.» ");
INSERT INTO kqp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Parisiɲêɲê hô uwôgeji gawra bi wo tiri na tiɲ hen aɲ kôli iyôŋ ba: «Kôl kwôlê woɲ tiri tumô Emen a wôsa nini hôn wo gawra bi wo ju kôl ré berarem hen na, na ôbi têriɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Menba, ôbi uwôlji sara iyôŋ ba: «Hena ôbi ré na ôbi têriɲ ba, en hôn né, niɲba, aŋga pôn ka en hôn na, tumô ba, tun na tiɲ niɲba, haw hen en gel kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Menba, Parisiɲêɲê hô eŋgereri iyôŋ ba: «Ôbi lêm na mi ba? Ôbi li na iyeŋ a ré bôl tum hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Menba, ôbi uwôlji sara iyôŋ ba: «Ré ené kelêŋge niɲ menba, kené toy ré wô mi ba? Wô mi a kené hô gey toyé a sôŋ ba? Kenbay kôba, ken gey yé bay tôri men ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bay tiréri aɲ kôl iyôŋ ba: «Jôbi a na ôbi tôri ɗi terô, nibay niɲa bay tô *Moyis. ");
INSERT INTO kqp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nini hôn mega wo Emen na ré iyêl naɲ Moyis. Niɲba, gawra wo nà ná, nini hôn kiriɲ ka ôbi henaɲ ya hen ré.» ");
INSERT INTO kqp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Menba, ôbi uwôlji sara iyôŋ ba: «Kwôlo hen na, en hôn né, ôbi li aɲ en gel kiriɲ hen na, ré kené henê kiriɲ ka gawra bi wo hen henaɲ ya hen. Menba, ken hôn kiriɲ ka ôbi henaɲ ya hen né. ");
INSERT INTO kqp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nana hôn wo Emen ré toy uwôlê wo bay têriɲ ré hari niɲba, hena kwôni ré biri kwôlê men, li aŋga ôbi gey hen a men na, na kwôni bi wo hen a ôbi ré toy uwôlê wori. ");
INSERT INTO kqp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wôsa nini toy tumô mega wo kwôni na ré bôl tu kwôni wo tiɲ bô yori a iyôŋ sa pôn né. ");
INSERT INTO kqp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hena gawra bi wo hen ré hena na ligi Emen a ré na, ôbi ré nêmê lê ani ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Menba, Parisiɲêɲê kôli iyôŋ ba: «Ju yêɲ bô têriɲ a menba, ju gey geléni are ba?» Menba, bay dageri bô iyéy daɲare a. ");
INSERT INTO kqp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kiriɲa Jésu toy wo bay ré dage gawra bi wo hen menba, ôbi ô uɲéri aɲ kôli iyôŋ ba: «Ju bi bôm sa *Kema Gawra ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Menba, gawra bi wo hen uwôli sara iyôŋ ba: «Kelma, ôbi na i a ené bê bôn sari a ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jésu kôli iyôŋ ba: «Ju gili. Kwôni wo iyêl naɲ ju hen na, na ôbi.» ");
INSERT INTO kqp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Menba, ôbi kôliɲ Jésu iyôŋ ba: «Kelma, en bi bôn sam a.» Aɲ ôbi cubu gubari tumôri a. ");
INSERT INTO kqp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Menba, Jésu kôl iyôŋ ba: «En era sa terare a nà ná wô jerê kwôlê aɲ bi bay tu tiɲ ré gel kiriɲ men, ka gel kiriɲ hen ré hô gase yi bay tu tiɲ men.» ");
INSERT INTO kqp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisiɲêɲê ka pôni ka ɗebu naɲ ɗi hen toy kwôlê bi wo hen, aɲ kôli iyôŋ ba: «Nibay kôba, niɲa bay tu tiɲ men ba?» ");
INSERT INTO kqp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Menba, Jésu uwôlji sara iyôŋ ba: «Hena henaŋ turŋge ré tiɲ na, henaŋ kwôlê têriɲ henaŋ né ɓeré sarŋge ré. Niɲba, haw hen wo ken kôl iyôŋ ba nini gel kiriɲ, na ôbi a, kwôli têriɲ toŋge ré ɓu sarŋge a baa ya hen.» ");
INSERT INTO kqp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Na tu kwôlê a ené kelêŋge hen: kwôni wo si si kibi geré wo iyéy gamgê ré, niɲba, si si tu telare aɲa ré ô bô a na, na ôbi gemsare men, na bandi a men. ");
INSERT INTO kqp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Niɲba, kwôni wo si si kibi geré ba, ôbi a na ôbi abê gamgê hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ôbi gemé kibi iyé gamgê hen bôl kibi iyére biri aɲ gamgê toy tôri hôn men, ôbi uwôge ka na kari hen, naɲ heniji heniji aɲ ôbi siɲ naɲ ci nô. ");
INSERT INTO kqp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kiriɲa ôbi siɲ naɲ gamgê kari bay ka hen kêm nô niɲ na, ôbi a derê tumôrji men, bay a erê tôri a a men, wôsa bay hôn tôri. ");
INSERT INTO kqp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gamgê bay ka hen ô tô kwôni wo ɗaŋgi a ré, niɲba, bay a geréri ɗi wôsa bay hôn tôri ré.» ");
INSERT INTO kqp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jésu kôlji gwosoy kwôlê bi wo hen niɲba, bay hôn kwôlo ôbi kôlji hen ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Menba, Jésu hô kôlji iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: en yi mega kibi geré wo iyéy gamgê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓiɲé kêm ka na era tumôn hen na, na bay gemsare men, na bandi a men aɲ gamgê na toy tôrji ré. ");
INSERT INTO kqp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ena kibi geré. Hena kwôni ré si legen na, ôbi a uɲé gelê men, ôbi a era ira men, a sé men, ôbi a uɲé kalmê kaɲ emê ka lebé dô a men. ");
INSERT INTO kqp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ôbi gemsare ba era na wô gemsare men, deré temare men, mênê kiriɲ a men. Niɲba, nôbi en era bi ɓiɲé ré mô tu geɲ men, ré uwôɲ terê kibi wo gay gay wo bô a hen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ena ôbi abê gamgê wo dôri. Ôbi abê gamgê wo dôri na, ay yiri uléɲ wô gamgê kari. ");
INSERT INTO kqp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Niɲba, kwôni wo abe gamgê wô uwôɲiɲ gursu mera ɗiba na ôbi abêrji ré men, gamgê kôba na kari ré a men hen na, kiriɲa ôbi gel heŋ era menba, ôbi ge ɗiji aɲ, aɲ heŋɲê waserêji. ");
INSERT INTO kqp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ôbi li hen iyôŋ wôsa ôbi li jé na wô uwôɲiɲ gursu mera, ɗiba, erem sa gamgê a ré. ");
INSERT INTO kqp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ena ôbi abê gamgê wo dôri. Mega wo Iban hônen men, nôbi kôba, en hôni men hen iyôŋ na, en hôn gamgê kaɲê men, bay kôba hônen men. En ay yen uléɲ wô sa gamgê kaɲê. ");
INSERT INTO kqp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","En ôriɲ naɲ gamgê ka pôni ka naɲ bô ira nà tô. Gamgê bay ka hen na, na erê eraɲ naɲ ci, aɲ bay a toyé tôn aɲ bay kêm a sa daɲ kiniji pôn men, ôbi gemérji kôba, a pôn a men.» ");
INSERT INTO kqp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Iban geyen na wôsa en ay yen uléɲ dema ené sa uɲé hôriɲ tô hen. ");
INSERT INTO kqp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aɲ yen bi wo en ay uléɲ hen na, na kwôni a ɓeren ereŋ né, niɲba, na nôbi a ayê bé naɲ bô geyé wuɲê. En nêm ɗé yen biɲ temare men, en nêm derê yen kebre a a men. Na tôô Iban to kelan a ené li hen.» ");
INSERT INTO kqp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sa kwôlê bi wo ôbi kôl hen na, kariɲare hô yi perê Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ka pôni perê kwône kôl iyôŋ ba: «Tunu to habiɲ bôri a men, na kubra a men, menba, wô mi a kené toy kwôlê kibri a ba?» ");
INSERT INTO kqp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Men né, ka pôni kôl iyôŋ ba: «Kwôni wo tunu to habiɲ bôri ba, a kelê kwôlê hen iyôŋ né men, tunu to habiɲ ba, a belê tu ôbi tu tiɲ ba men». ");
INSERT INTO kqp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bay li geserê woɲ belê kibi *iyéy Emen Jérusalêm a kibi kelanê a. ");
INSERT INTO kqp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Menba, Jésu ô palê derô haba wo iyéy Emen a si tô pal wo uwôgeri ré na kwo Salomôn hen. ");
INSERT INTO kqp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Menba, Jubɲê sa mééri ta aɲ kôli iyôŋ ba: «Kiriɲa yôŋ a jeré bé bôrni kuriɲ tôŋ ba? Hena jeré na Krist, kwo Emen dôri hen ba, ju kelêni waŋ ta niɲa toyé.» ");
INSERT INTO kqp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Menba, Jésu uwôlji sara iyôŋ ba: «Na en kelêŋge niɲba, na ken kaɲ bê bôrŋge sara. Wôsa aŋga en li naɲ hini Iban hen na, na bay a derê kwôlen. ");
INSERT INTO kqp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Niɲba, ken bi bôrŋge sara ré, wôsa kena gamgê kaɲê ré. ");
INSERT INTO kqp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Gamgê kaɲê na, toy tôn men, en hônji men, bay era tôn a a men. ");
INSERT INTO kqp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Men, nôbi en biji bay mô tu geɲ naɲ kwiniji men, bay a mênê ré yôd men, kwôni a dôrji kôben a ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iban bi wo na ben ɓiɲé bay ka hen na, gôliɲ sa are kêm aɲ kwôni nêm derêji kôbri a ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nibay naɲ Iban niɲa gawrê ka pôn.» ");
INSERT INTO kqp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Menba, Jubɲê hô pô jerew ciré gôbiɲ Jésu deré. ");
INSERT INTO kqp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Menba, ôbi kôlji iyôŋ ba: «En li aŋga dôri ka hena yi Iban a kwône geléŋge niɲba, na wô ka yôŋ pôn aɲa kené kena gôben deré kwôliji hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Menba, Jubɲê uwôli sara iyôŋ ba: «Na wô lê aŋga dôri a niné gôbem deré hen mera ré, niɲba, wô tiiré wo ju tiiré Emen men, wô wo jôbi ju na gawra menba, ju li yem môɲ Emen iyôŋ a men hen.» ");
INSERT INTO kqp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Menba, Jésu uwôlji sara iyôŋ ba: «Liɲ bô magtubu tôô toŋge a kôl Emen na ré kôl iyôŋ ba: ‹Kena emen men.› ");
INSERT INTO kqp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nini hôn kwôlo magtubu to Emen ré kôl hen na, kwôni a mênê ré wôsa na ɓiɲé bay ka bay na uwôl béré kwôlê wori biji hen a, Emen ré uwôgeji emen men hen. ");
INSERT INTO kqp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wôsa kuɲê nôbi ba, na Iban a dôren aɲ joon sa terare a menba, ken kôl ené tiiré na Emen wô kelê wo en kôl ené na Kema Emen hen. ");
INSERT INTO kqp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hena ené li aŋga Iban li hen men né, ken bi bôrŋge san a ré men. ");
INSERT INTO kqp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Niɲba, hena ené li aŋga Iban li hen aɲa kené gey bê bôrŋge san a ré na, ken bi bôrŋge sa aŋga Iban li bay ka en li hen. Hen iyôŋ hari kôba, ken bi bôrŋge sa are bay ka hen a bi ken hôn dô mega wo Iban ré biɲ naɲ en men, nôbi kôba, ené biɲ naɲ ɗi men.» ");
INSERT INTO kqp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sa kwôlê bi wo hen a na, Jubɲê hô woge ciré ɓeréri, niɲba, ôbi si selay ô. ");
INSERT INTO kqp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Menba, Jésu hô ô cêgi cér wo Jurdê kiriɲ ka Ja ôbi lê batêm na liɲ ɓiɲé batêm ya hen, aɲ ô merê ya. ");
INSERT INTO kqp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɓiɲé kwône era ligiri a aɲ kôl iyôŋ ba: «Ja ôbi lê batêm na li giɲê wôni pôn nêŋ iyôŋ né, niɲba, kwôlo ôbi na kôl kêm gengiɲ sa gawra bi wo hen na, na kwôlê woɲ tiri.» ");
INSERT INTO kqp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Menba, kiriɲ bay ka hen na, ɓiɲé kwône bi bôrji sari a. ");
INSERT INTO kqp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gawra wo pôni bay uwôgeri Lajar mô Bétani a, ôbi ômiɲ. Sa iyére hende to hen na, si Mari naɲ yêre Mart môrji ya. ");
INSERT INTO kqp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mari hende to hen na na, na to na wusiɲ Kelma ider sa têri a men, na mô naɲ guseri sare men hen. Aɲ Lajar bi wo ômiɲ hen na yêêne.) ");
INSERT INTO kqp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Si Mari naɲ Mart jé kôliɲ Jésu iyôŋ ba: «Kelma, gel kwo ju geyri gaɲ hen ômiɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kiriɲa Jésu toy hen iyôŋ menba, ôbi kôl iyôŋ ba: «Ômɲare to hen na, na to a diri ré, niɲba, na to a gelé hini emê wo Emen men, na to bay ayiɲ kibi Kema Emen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jésu gey Mari naɲ yêre Mart men, yêneji Lajar a men damaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wulê bi wo ôbi toy wo Lajar ré ômiɲ hen na, ôbi hô wôl sa wôô cêgê a, kiriɲ ka ôbi môriɲ ya hen. ");
INSERT INTO kqp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Menba, ôbi kôliɲ bay tôri iyôŋ ba: «Na herêŋge Judé.» ");
INSERT INTO kqp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Menba, bay tôri kôli iyôŋ ba: «*Rabi, Jubɲê na gey ciré gôbem deré naɲ keram haw hen menba, já hô herê Judé sôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Menba, Jésu uwôlji sara iyôŋ ba: «Wulê pôn ba, na tare môj kibi wôô ré ba? Hena kwôni ré ô kiriɲ tu tare ba, a hebiriɲ né, wôsa ôbi gel kiriɲ ka peraŋgi ka sa terare a nà. ");
INSERT INTO kqp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Niɲba, hena kwôni ré ô kiriɲ yoyre na, ôbi a hebiriɲ wôsa kiriɲ ka peraŋgi ka ôbi ré geliɲ kiriɲ naɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cêgi kwôlê bi wo hen na, ôbi kôlji iyôŋ ba: «Melaɲnena Lajar yi kum, aɲ na erê eŋgéri.» ");
INSERT INTO kqp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Menba, bay tôri kôli iyôŋ ba: «Kelma, hena ôbi ré yi na kum ba, ôbi a berarê seŋge.» ");
INSERT INTO kqp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jésu kôlji na kwôli temay Lajar niɲba, bay kôl yaŋ ba ôbi ré kôlji na kwôli kum. ");
INSERT INTO kqp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Menba, Jésu kôlji waŋ a ta iyôŋ ba: «Lajar ma. ");
INSERT INTO kqp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yen dôren gaɲ wô sarŋge wô naɲê wo en naɲ kiriɲ bay ka hen, wôsa ôbi wo hen a lê dema kené bê bôrŋge san a. Na erêŋge uɲéri.» ");
INSERT INTO kqp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sa kwôlê bi wo hen a na, Tomas wo bay uwôgeri Kerma hen kôliɲ megêri bay tô Jésu ka baa hen iyôŋ ba: «Nabay kôba, na erêŋge men. Hena ré temare hende kôba, na maŋge naɲ ɗi.» ");
INSERT INTO kqp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kiriɲa Jésu sa menba, toy wo Lajar ré emiɲ li wulê pôrbu kamɲê niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bétani naɲ Jérusalêm na, perêrji ɗa seŋge, na kilomêter subu mera. ");
INSERT INTO kqp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na hen iyôŋ a, Jubɲê kwône ré eraji temare ligi si Mari naɲ Mart a wô jalê bôrji wô yêniji wo ma hen. ");
INSERT INTO kqp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kiriɲa Mart toy wo Jésu era hen ya, menba, hende hena jô kwini aɲ Mari ba, mô baa ira. ");
INSERT INTO kqp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mart kôliɲ Jésu iyôŋ ba: «Kelma, hena henaŋ jeré ná nà ba, yênini henaŋ ré ma ré tô. ");
INSERT INTO kqp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Niɲba, haw hen kôba, en hôn wo aŋga yôŋ yôŋ ka jeré eŋgeriɲ Emen ba, ôbi ré bem.» ");
INSERT INTO kqp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Menba, Jésu kôle iyôŋ ba: «Yênê a jê sé kamɲê.» ");
INSERT INTO kqp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mart uwôli sara iyôŋ ba: «En hôn wo ôbi ré jê sé kamɲê kiriɲa ɓiɲé ka ma ré jê sé Wulê woɲ jerê kwôlê a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Menba, Jésu kôle iyôŋ ba: «Nôbi, ena ôbi biɲ ɓiɲé jê sé kamɲê men, ena ôbi biji merê tu geɲ a men. Hena kwôni ré bi bôri san a ba, ré ma na ma kôba, a merê tu geɲ. ");
INSERT INTO kqp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Men, i i wo mô tu geɲ aɲ bi bôri san a ba, a ma ré kwôy. Mu bi bôrê sara ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mart kôli iyôŋ ba: «En bi bôn sam a Kelma, wo jeré na *Krist kwo Emen dôri hen, Kema Emen wo ré era sa terare a nà bi.» ");
INSERT INTO kqp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kiriɲa hende kôl hen iyôŋ menba, kuriɲ ô ta. Aɲ uwôge yêre Mari jigêd aɲ kôle iyôŋ ba: «Rabi ɗebu hen ya uwôgerê.» ");
INSERT INTO kqp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kiriɲa Mari toy hen iyôŋ menba, hende hena kerê jô kwini. ");
INSERT INTO kqp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wôsa Jésu sa biɲ sa iyére hende to hen ré tô niɲba, ôbi baa na kiriɲ ka Mart ré uwoɲni ya hen. ");
INSERT INTO kqp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Menba, Jubɲê ka ré mô bô ira naɲ Mari wô jalê bôre hen, kiriɲa bay gel wo hende hena kerêd si nô hen iyôŋ na, bay hena ô tôre a aɲ kôlji iyôŋ ba: «Yaŋ ba, hende ô na sa kamɲê ta erê sômê.» ");
INSERT INTO kqp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kiriɲa Mari sa biɲ kiriɲ ka Jésu ɗebiɲ ya hen na, kiriɲa hende gili menba, hende kuriɲ tôŋ têri a aɲ kôli iyôŋ ba: «Kelma, hena henaŋ jeré ná nà ba, yênen henaŋ ré ma ré.» ");
INSERT INTO kqp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jésu gel wo hende sôm men, Jubɲê ka ré bare hen kôba, sôm a men na, bôri erem kwôlê gaɲ aɲ cémni uwôsiɲ. ");
INSERT INTO kqp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Menba, Jésu eŋgere Mari iyôŋ ba: «Ken emni yôŋ ba?» Menba, hende kôli iyôŋ ba: «Kelma, era ju sa gel.» ");
INSERT INTO kqp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Menba, Jésu sôm. ");
INSERT INTO kqp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kiriɲa Jubɲê gel wo Jésu sôm hen iyôŋ menba, bay kôl iyôŋ ba: «Geléŋge geyé wo ôbi geyri kêm hen.» ");
INSERT INTO kqp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aɲ ka pôni perêrji a kôl iyôŋ ba: «Ôbi wo na bôl tu ôbi tu tiɲ hen, henaŋ ré nêmê lê aɲ bi Lajar ré ma ré ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Menba, bôri erem kwôlê damaŋ a sôŋ aɲ ôbi ô sa kamɲê. Kamɲê bay ka hen, na uwormo keram a aɲ kulmaŋ keram ɗiɲ kibé. ");
INSERT INTO kqp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Menba, Jésu kôl iyôŋ ba: «Nôgêŋge kulmaŋ keram hen aɲ.» Menba, Mart yêri ôbi temare bi wo hen, kôli iyôŋ ba: «Kelma, ôbi emiɲ li wulê pôrbu aɲ ɗiɲé niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Menba, Jésu kôle iyôŋ ba: «Na en kôlê hena meré bi bôrê san a ba, meré gelé néé wo Emen ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Menba, bay nôge kulmaŋ keram wo yi kibi kamɲê a hen aɲ, aɲ Jésu ay tiri bôriɲ kiriɲ si ta aɲ kôl iyôŋ ba: «Iban, en lêm dosé wô kwôlo ju toy keben a niɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kuɲê nôbi ba, en hôn wo jeré toy kwôlê keben a kwôy kwôy haɲê, niɲba, en kôl na wô kwônê ɓiɲé ka ɗebu méren ta hen ɗi, bi bay ré bi bôrji san a mega wo ré na jôbi a ré joon hen.» ");
INSERT INTO kqp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kiriɲa ôbi kôl hen iyôŋ menba, kôl naɲ tôri to dami kôl iyôŋ ba: «Lajar, so nô.» ");
INSERT INTO kqp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Menba, ôbi temare bi wo hen nuŋgero so. Têri naɲ kôbri lêgeriɲ ta naɲ kibi bargay men, tiri hariɲ naɲ kibi bargay a men, menba, Jésu kôlji iyôŋ ba: «Beseréŋgeri aɲ ken ɗiri ô.» ");
INSERT INTO kqp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jubɲê ka kwôni ka era temare uɲé Mari hen gel aŋga Jésu li hen, menba, bay bi bôrji sari a. ");
INSERT INTO kqp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Niɲba, ka pôni perêrji a ôrji uɲé *Parisiɲêɲê aɲ kôlji kwôli aŋga Jésu ré la hen. ");
INSERT INTO kqp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Menba, damné kaɲ bay bê kwôbe naɲ Parisiɲêɲê uwôgeji daɲare to *Sanédrên aɲ kôl iyôŋ ba: «Na lêŋge na iyeŋ ba? Wôsa gawra wo hen na, li giɲê kwône. ");
INSERT INTO kqp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hena nana ɗéŋgeri li hen iyôŋ na, ɓiɲé kêm a bê bôrji sari a, menba, Rômêɲê a eraji sa mênê *iyéy Emen tona men, tô yê wona a men.» ");
INSERT INTO kqp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Menba, kwo pôni perêrji a bay uwôgeri Kayib na *dami wo damné kaɲ bay bê kwôbe elê bi wo hen a, ôbi kôlji iyôŋ ba: «Ken hôn ani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bi gawra pôn nêŋ ré ma wô sa ɓiɲé kêm a derê laba, bi sa iyére ré mêniɲ derê ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ôbi kôl hen iyôŋ na sa kibri ré, wôsa elê bi wo hen na, ôbi na dami wo damné kaɲ bay bê kwôbe aɲ ôbi kôlji ta mega wo Jésu ré sa ma wô sa iyére. ");
INSERT INTO kqp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na wô sa iyére pôn mera ré, niɲba, na wô hô dayê ɓiɲé ka Emen ka useriɲ hen liɲ kurôŋgi yi wo pôn. ");
INSERT INTO kqp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ayiɲ tôri wulê bi wo hen na, bay way kwôli ciré deréri. ");
INSERT INTO kqp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na ôbi aɲa Jésu ré gel yiri waŋ waŋ tu Jubɲê ré hen, aɲ ô sa iyére to kwa derô gwôlê to bay uwôgere Eperêm hen ô merê ya naɲ bay tôri. ");
INSERT INTO kqp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mega wo geserê lê *Pak wo Jubɲê baa ɗa menba, ɓiɲé ka naɲ sa iyére iyére kwône ôrji Jérusalêm a tumô Pak a dê ciré erê lôɲê yirji wô séliɲ tumô Emen. ");
INSERT INTO kqp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bay woge Jésu aɲ bay eŋgeriɲ perêrji a derô haba wo iyéy Emen a iyôŋ ba: «Ken erem mega wo ôbi ré era kini geserê na ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wulê bi wo hen na, damné kaɲ bay bê kwôbe naɲ Parisiɲêɲê na kôliɲ ɓiɲé iyôŋ ba: «Hena kwôni wo ré hôn kiriɲ ka Jésu môriɲ ya ba, ré kôl ta aɲ bi ciré erê ɓeréri.» ");
INSERT INTO kqp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Baa wulê jii dema geserê *Pak ré liɲ tô menba, Jésu hera Bétani sa iyé Lajar wo ôbi na biri ji si kamɲê a hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kiriɲ bay ka hen na, Mart li aŋgaɲ emê biɲ Jésu menba, perê kwônê ɓiɲé bay ka mô ôm are hen na, Lajar kôba, ya men. ");
INSERT INTO kqp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Menba, Mari ay kwa gaasa woɲ ider wo ɗiɲé dô wo garari mê wo bay li naɲ kalmê ka bay uwôgeji nar hen, eraɲ sa wuse sa tê Jésu a aɲ mô naɲ gusiri sare aɲ bô iyére kêm ɗiɲé ider. ");
INSERT INTO kqp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iskariyôt ôbi tô Jésu wo pôni wo a ayê sa Jésu hen, kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Wô mi a nana kaɲ ayê ider bi wo hen eŋgiɲ *déniyé arew subu aɲ céɲ bay nimré ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ôbi kôl hen iyôŋ na wô geyé wo ôbi gey bay nimré ré, niɲba, wôsa ôbi na ôbi gemsare men, ôbi a na ôbi gemé lari a men, aɲ lari wo bay biri gemé hen na, ôbi gômse kwari dê dê. ");
INSERT INTO kqp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Niɲba, Jésu kôl iyôŋ ba: «Ɗéŋgere ɗê iyôŋ, wôsa hende li hen iyôŋ tumô ermiɲ sa emé wo bay a sa emen a hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bay nimré a merê naɲ ken naɲ wulê wulê tô, niɲba, nôbi ba, na merê naɲ ken naɲ wulê wulê ré.» ");
INSERT INTO kqp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Menba, Jubɲê kwône toy wo Jésu ré na Bétani a na, bay era na wô geléri ôbi mera ré, niɲba, na wô gelé Lajar wo ôbi na biri ji si kamɲê hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Menba, damné kaɲ bay bê kwôbe genge wo Lajar kôba, ciré diréri men. ");
INSERT INTO kqp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Wô sé wo Lajar ji si kamɲê hen na, Jubɲê kwône kaɲji damné kaɲ bay bê kwôbe aɲ bi bôrji na sa Jésu a ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wulê pôn cêgê menba, ɓiɲé kwône ka era wô lê geserê hen toy wo Jésu ré ɗa era Jérusalêm a hen ya men, menba, ");
INSERT INTO kqp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pôrji demaɲ gare kôbriji a aɲ gerji jôriɲ kwini naɲ gura kôl iyôŋ ba: «Hosana, heramê yi wô sa Emen. Bi terê kibi yi wô sa kwo era naɲ hini Kelma Emen hen. Kwo era hen bi a na kelma wo *Israyêl hen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jésu uwôɲ kema kura ɗay mega wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Kenbay ɓiɲé ka Siɲô, harêŋge ré, geléŋge Kelma woŋge ɗaya mera sa kema kura a era hen ya.» ");
INSERT INTO kqp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kiriɲ bay ka hen na, bay tô Jésu hôn ani bô are bay ka hen a ré. Niɲba, kiriɲa Emen gel damɲare to Jésu niɲ, dema bay ré erem mega wo na ré liɲ bô magtubu to Emen a wô sari aɲa ɓiɲé ré li ariri hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɓiɲé kêm ka na ɗebe naɲ Jésu kiriɲa ôbi na uwôgiɲ Lajar aɲ na biri ji si kamɲê hen na, bay dô kwôli are bay ka ôbi na li hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na ôbi á, ɓiɲé ré jô kwini Jésu naɲ gere wôsa bay na toy kwôli giɲê bi wo ôbi na li hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Menba, *Parisiɲêɲê kôl perêrji a kôl iyôŋ ba: «Geléŋge, ka nêmê ré niɲ, wôsa ɓiɲé kêm ô tôri a.» ");
INSERT INTO kqp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grêkɲê ka pôni perê ka ô wô tibé Emen sa geserê bi wo hen a na, ");
INSERT INTO kqp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","bay kôliɲ Pilip wo Bêtsayda bô emê wo Galilé a hen iyôŋ ba: «Kamaŋ, nini gey gelé Jésu.» ");
INSERT INTO kqp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Menba, Pilip ô kôliɲ André menba, bay wôô ɓem ô kôliɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Menba, Jésu uwôlji sara iyôŋ ba: «Wulê wo Emen a geliɲ ɓiɲé damɲare tiɲê nôbi *Kema Gawra hen nêm niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na kelêŋge na tu kwôlê: hena gusiɲ kaw ka bay ci hen, ré ma ré na, bay yi na kiniji a hen mera, niɲba, hena bay ré ma dema ré sé aɲ a yé gusiɲ mê. ");
INSERT INTO kqp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ôbi a, kwôni wo ré ôm dô sa terare a nà, aɲ erem san a ré ba, kay na yiri, niɲba, kwo geyen gôliɲ emê wo sa terare a nà ba, gem na yiri wô merê tu geɲ wo naɲ kwini men. ");
INSERT INTO kqp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Men, hena kwôni wo ré gey yé mana wuɲê ba, a era tôn a aɲ kiriɲ ka na sa merê ya hen na, ôbi kôba, a sa merê ya men. Hena kwôni ré na mana wuɲê ba, Iban a ayê kibri.» ");
INSERT INTO kqp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Haw hen na, bôn erem kwôlê gaɲ. Ré ené kelê iyôŋ ba: Iban, dôren kibi aŋga ca sa san a hen, niɲba, na wô bi wo iyôŋgi hen aɲa ené eraɲ kwôy sa terare a nà, bi ené sa geliɲ gusiɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Iban, ay kibi henem.» Menba, tôô gawra ôm derômaraŋ a kôl iyôŋ ba: «En heramiri niɲ, aɲ na hô heramiri a sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Menba, kwônê ɓiɲé ka ɗebe ya aɲ toy hen na, bay kôl yaŋ ré na emen a ré enê hen men, ka pôni kôl iyôŋ ba ré na *mana wo derômaraŋ a ré iyêlê kwôlê naɲ ɗi hen men. ");
INSERT INTO kqp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Menba, Jésu kôl iyôŋ ba: «Na wô san nôbi a kené toy tôô hende to hen né, niɲba, na wô sarŋge kenbay ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Haw hen, na wulê wo Emen a jôriɲ sa kwôlê sa ɓiɲé ka sa terare a nà men, na wulê wo bay a dagiɲ Sidan kelma wo sa terare a nà a men. ");
INSERT INTO kqp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Niɲba, nôbi na, kiriɲa bay a sa ɗén sa gurô tagelê na, na wuro gawrê kêm yen a.» ");
INSERT INTO kqp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jésu kôl hen iyôŋ geliɲ geré wo ɗiré sa maɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Menba, kwônê ɓiɲé uwôli sara iyôŋ ba: «Na liɲ bô magtubu tôô tona kôl iyôŋ ba: ‹*Krist, kwo Emen dôri hen ré merê naɲ kwini yôd› menba, wô mi a jeré kôl iyôŋ ba: ‹Bay ré sa ɗé Kema Gawra sa gurô tagelê ba?› Men, i na Kema Gawra bi men ba?» ");
INSERT INTO kqp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Menba, Jésu uwôlji sara iyôŋ ba: «Mega wo kiriɲ ka peraŋgi baa perêrŋge a sem tô hen na, erêŋge kiriɲ ka peraŋgi a wô wo dilemne maa gwôsêŋge. Wôsa kwôni wo ô dilemne a na, hôn kiriɲ ka ôbi ôriɲ ya hen né. ");
INSERT INTO kqp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mega wo kiriɲ ka peraŋgi bay ka hen baa perêrŋge a tô hen na, ken bi bôrŋge sarji a aɲ bi ken biliɲ yi kami kiriɲ ka peraŋgi.» Kiriɲa Jésu kôl kwôli are bay ka hen niɲ, menba, ôbi ɗiji aɲ ô uwôbê kelaŋ naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bi wo Jésu li aŋgaɲ giɲê kwône tirji a bay gel hen a men, hen kôba, bay bi bôrji sari a ré. ");
INSERT INTO kqp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ôbi a, kwôlo *ôbi kibi Emen *Esay na kôl hen a ariri ré liɲ hen. Ôbi na kôl iyôŋ ba: «Kelma, i a bê bôri sa kwôlo nini dô hen ba? Men, na i a Emen né yêge sa néé wori biri ba?» ");
INSERT INTO kqp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bay nêm bê bôrji sara ré, wôsa Esay na hô kôl a kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Emen bi tirji gel kiriɲ né men, bi bôrji deŋgel aɲ bi tirji ré gel kiriɲ né, aɲ bi bay ré hôn ani ré. Emen kôl iyôŋ ba: En li hen iyôŋ bi bay ré bulo hera uɲen né, wô wo hena bay ré hera uɲen ba, ma ené berarêji.» ");
INSERT INTO kqp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esay kôl kwôli are bay ka hen iyôŋ wôsa ôbi gel damɲare to Jésu aɲa ôbi ré kôliɲ kwôli hen. ");
INSERT INTO kqp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bi wo hen kôba, perê damné ka Jubɲê hen na, ka pôni kwône bi bôrji sari a, niɲba, bay gel yirji nô ré wô Parisiɲêɲê, wôsa bay hare wô wo bay maa ré dagêji bô *iyéy daɲare a. ");
INSERT INTO kqp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wôsa bay gey dené wo gawrê gôliɲ kwo Emen. ");
INSERT INTO kqp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Menba, Jésu iyêl kaŋ a ta kôl iyôŋ ba: «Kwôni wo bi bôri san a ba, bi na san nôbi a mera ré niɲba, bi na sa kwo joon a hen men. ");
INSERT INTO kqp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Men, kwôni wo gelen nôbi ba, gel na kwo joon hen men. ");
INSERT INTO kqp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wôsa en era sa terare a nà ná môɲ kiriɲ ka peraŋgi iyôŋ, aɲ bi i i wo ré bi bôri san a ba, ré mô kiriɲ ka hendi a ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hena kwôni wo ré toy kwôlê wuɲê aɲa ré gem ré na, na nôbi a jerê kwôlê sari a ré, wôsa en era sa terare a nà, ná wô jerê kwôlê sa ɓiɲé a ré, niɲba, na wô gôliɲ naɲ ci ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kwôni wo kaɲen men, gey kwôlê wuɲê a ré a men na, ôbi jerê kwôlê sari a ya, wôsa na kwôlê bi wo en uwôl béréri hen a sa jerê kwôlê sari a, Wulê woɲ jerê kwôlê a. ");
INSERT INTO kqp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nôbi na, en iyêl na kwôlê wôni sa keben ré, niɲba, Iban wo joon hen ôbi kôlen naɲ kibri wori kwôlo ené sa kôl men, ené uwôliɲ béréri a men. ");
INSERT INTO kqp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aɲ en hôn, tôô tori na, na merê wo naɲ kwini. Na ôbi á, kwôlo kêm wo ené kôl hen na, en kôl na mega bi wo Iban na kelan hen iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wulê pôn tumô sa lê geserê *Pak a na, Jésu hôn wo wulê wo ɗiré henaɲ sa terare a nà herê ligi Ibari a ré baa ɗa niɲ. Ôbi na pur ɓiɲé kari ka sa terare a nà. Ôbi pirji hen kwôy wo ôbi deriɲ kibi wulê wori sa terare a nà. ");
INSERT INTO kqp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kiriɲa Jésu naɲ bay tôri môrji kibi emê a perare menba, Sidan na dôbe ermé wo habiɲ bô Judas Iskariyôt woɲ kema Simô a bi ré sa dese Jésu. ");
INSERT INTO kqp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jésu hôn wo Emen ré biri néé sa are kêm men, ôbi hôn wo ɗiré hena na ligiri a men, ɗiré hô na ligiri a a men. ");
INSERT INTO kqp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Menba, ôbi hena kibi emê bi wo hen a dô bargay ka sa megêrji a hen yiri a aɲ, menba, ay kibi ka ôbi ré hariɲ tô bôri hen. ");
INSERT INTO kqp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Menba, ôbi bi kam bô dasa a piliɲ tê bay tôri aɲ mô naɲ kibi bargay bay ka ôbi ré hariɲ tô bôri hen. ");
INSERT INTO kqp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kiriɲa Jésu sa sa Simô Piyêr a menba, Piyêr kôli iyôŋ ba: «Kelma, jôbi a hô pelen nôbi tên ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Menba, Jésu uwôli sara iyôŋ ba: «Aŋga en li hen na, ju hôn bôrji haw hen né, niɲba, era tumô hen na, já sa henê bôrji tô.» ");
INSERT INTO kqp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Menba, Piyêr hô kôli iyôŋ ba: «Já pelé tên nôbi ré kwôy.» Menba, Jésu uwôli sara iyôŋ ba: «Hena ené pelem têm né ba, já yé ôbi tôn ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Menba, Simô Piyêr hô kôli iyôŋ ba: «Kelma, hena ré na hen iyôŋ ba, pul tên mera ré, niɲba, ju pul kôben naɲ san kêm a men.» ");
INSERT INTO kqp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Menba, Jésu kôli iyôŋ ba: «Kwôni wo pul yiri ba, sél niɲ aɲ na têri a ré pelé mera. Kenbay kena ɓiɲé ka séli, niɲba, ken sél kêm né.» ");
INSERT INTO kqp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wôsa Jésu hôn kwo a ayê sari hen, aɲa ré kôl iyôŋ ba: «Ken sél, niɲba, ken sél kêm né hen.» ");
INSERT INTO kqp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kiriɲa ôbi pilji têrji kô niɲ men, tôbe bargay kari hôriɲ a men niɲ na, ôbi hô mô kibi emê aɲ kôlji iyôŋ ba: «Aŋga en li hen ba, ken hôn bôrji ba? ");
INSERT INTO kqp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ken uwôgen *Rabi men, Kelma men. Ken uwôgen na ya wôsa ena ôbi sarŋge men, Kelma woŋge a men, na tiri. ");
INSERT INTO kqp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A hena nôbi woɲ Rabi woŋge men, Kelma woŋge a men hen, a peléŋge têrŋge hen na, kenbay kôba, ken piliɲ têrŋge hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wôsa en li hen iyôŋ geléŋge na gelé aɲ bi kené liɲ perêrŋge a hen iyôŋ men, mega wo nôbi en liɲ hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na tu kwôlê a ené kelêŋge hen: mana a gôliɲ sa dami wori ré men, ôbi jé a gôliɲ sa kwo jori hen né men. ");
INSERT INTO kqp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Haw hen wo ken hôn are bay ka kêm hen niɲ na, hena kené li arirji ba, yerŋge a sa derêŋge.» ");
INSERT INTO kqp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«En kôl hen iyôŋ, na wô sarŋge kenbay kêm né, wôsa en hôn ɓiɲé ka en tôrji hen. Niɲba, kwôlo na liɲ bô magtubu to Emen a hen na, arirji a liɲ. Kwôlê bi wo hen na, kôl iyôŋ ba: ‹Kwo ôm kwô naɲ en hen na, ôbi a hô yé ôbi bareren.› ");
INSERT INTO kqp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","En kelêŋge haw hen pa dema are bay ka hen ré sa tô, aɲ kiriɲa bay sa niɲ ba, kené hôn mega wo ‹Ena kwo en kôl ené na ôbi hen.› ");
INSERT INTO kqp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na tu kwôlê a ené kelêŋge hen: kwôni wo ɓu kwo en jéri hen yiri a na, na nôbi a, ôbi ré ɓeren yiri a hen men, kwo ɓeren nôbi yiri a ba, ɓu na kwo joon hen yiri a hen men.» ");
INSERT INTO kqp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jésu kôl hen iyôŋ menba, ermé kwôlê liri damaŋ aɲ ôbi kôl iyôŋ ba: «Na tu kwôlê a ené kelêŋge hen: kwôni pôn perêrŋge a hen a sa ayê san.» ");
INSERT INTO kqp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Menba, bay tôri bôriɲ tirji aɲ bay hôn na ba, ôbi ré kôl na kwôli i ba ré. ");
INSERT INTO kqp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ôbi tôri wo pôni kwo ôbi geyri gaɲ hen, mô kwari a aɲ yi ley kabrêri a. ");
INSERT INTO kqp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simô Piyêr liri kôbri ré eŋgeriɲ Jésu na ba, ré na i a ôbi ré kôliɲ kwôli hen ba? ");
INSERT INTO kqp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ôbi tôri wo ôbi geyri gaɲ bi wo hen yi kabrêri a aɲ kôli iyôŋ ba: «Kelma, na i bi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Menba, Jésu uwôli sara iyôŋ ba: «Na kwo na ɓeré mapa jibiɲ kiliɲ biri hen.» Ôbi ɓu mapa jibiɲ kiliɲ aɲ biɲ Judas woɲ kema Simô Iskariyôt. ");
INSERT INTO kqp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kiriɲa Judas eŋge mapa bi wo hen kôbi Jésu a menba, Sidan ô bôri a menba, Jésu kôli iyôŋ ba: «Aŋga ju gey lê hen na, ju li lew ham niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niɲba, tô bay tôri ka môrji kibi emê naɲ ci hen hôn na ba, wô mi a Jésu ré kôl hen ba, ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aɲ ka pôni kôl yaŋ ba, mega wo Judas ré na ôbi gemé lari hen na, Jésu ré gey kelêri na iyôŋ ba: «Ô kelé aŋga na liɲ geserê Pak réba ré kôli ré li naɲ bay nimré men.» ");
INSERT INTO kqp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas eŋge mapa bi wo hen menba, hena si nô men. Kiriɲ hendu niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kiriɲa Judas si nô niɲ menba, Jésu kôl iyôŋ ba: «Haw hen bay a gelé damɲare tiɲê nôbi *Kema Gawra men, bay a gelé damɲare to Emen sa keben a men. ");
INSERT INTO kqp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Hena bay ré gel damɲare to Emen wô sa kibi keben na, ba ɗa wo Emen naɲ yiri kôba, a gelé damɲare to Kemari men. ");
INSERT INTO kqp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yênên kaɲê, na merê naɲ ken gaɲ ré niɲ. Ka wogen niɲba, mega wo na en kôliɲ Jubɲê hen iyôŋ na, ka nêmê erê kiriɲ ka na erê ya hen né. ");
INSERT INTO kqp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na ɗéŋge tôô to kôrbi tôŋ: Periɲge yerŋge. Mega wo en peréŋge hen iyôŋ na, kenbay kôba, ken periɲ yerŋge hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kiriɲa ken periɲ yerŋge hen iyôŋ dema ɓiɲé kêm ré henê wo kené na bay tôn tô.» ");
INSERT INTO kqp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Menba, Simô Piyêr kôli iyôŋ ba: «Kelma, já erê na yôŋ ba?» Menba, Jésu uwôli sara iyôŋ ba: «Kiriɲ ka na erê ya hen na, já nêmê erê ya haw hen né, niɲba, dê iyôŋ a dema, jeré sa erê tôn a tô.» ");
INSERT INTO kqp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Menba, Piyêr kôli iyôŋ ba: «Kelma, wô mi a ené erê tôm a haw hen né ba? Na temare hende kôba, na ma wô sam.» ");
INSERT INTO kqp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Menba, Jésu uwôli sara iyôŋ ba: «Na tiri wo já geyé ma wô san ba? Na tu kwôlê a ené kôlem hen: kura a yelé ré tô menba, já uwôserê têê subu jeré hônen né.» ");
INSERT INTO kqp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Menba, Jésu kôlji iyôŋ ba: «Erméŋge kwôlê wôni ré, niɲba, ken bi bôrŋge sa Emen a men, ken bi bôrŋge san a a men. ");
INSERT INTO kqp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wôsa kini merê yi gaɲ bô iyé Iban a. Hena henaŋ ré na hen iyôŋ réba, henaŋ ené kelêŋge waŋ a ta. En ô wô ɲanê kiriɲ ka gengiɲ sarŋge. ");
INSERT INTO kqp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aɲ kiriɲa na erê aɲ kiriɲa en ɲanaŋge kiriɲ kera niɲ na, na bulo hera sa perêŋge naɲ en, aɲ bi kiriɲ ka en sa ô merê ya ba, kenbay kôba ka merê ya men. ");
INSERT INTO kqp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kiriɲ ka na erê ya hen na, ken hôn geré wo ô kiriɲ bay ka hen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Menba, Tomas kôli iyôŋ ba: «Kelma, nini hôn kiriɲ ka já ôriɲ ya hen né, menba, niɲa lê iyeŋ a niné henê geré wo ô ya hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Menba, Jésu kôli iyôŋ ba: «Nôbi ena geré men, tu kwôlê men, merê tu geɲ a men. Kwôni a erê ligi Iban a ba, sé si legen né. ");
INSERT INTO kqp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hena kené hônen ba, ken hôn na Iban men. Aɲ haw hen ba, ken hôni men, na ken gili a men niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Menba, Pilip kôli iyôŋ ba: «Kelma, geléni Ibam aɲ yerni a derêni mera.» ");
INSERT INTO kqp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Menba, Jésu kôli iyôŋ ba: «Pilip, en mô naɲ ken nà ca yeŋ aɲa jeré kôl jeré hônen ré tô ba? Kwôni wo gelen nôbi ba, gel na Iban men, menba, li iyeŋ a jeré kôl iyôŋ ba: ‹Geléni Ibam sôŋ ba?› ");
INSERT INTO kqp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ju bi bôm sara mega wo ené na yi Iban a men, Iban ré na yen a men ré ba? Kwôlo en kelêŋge hen na, en kelêŋge na sa keben né aɲ Iban wo yi yen a hen na, ôbi a lê aŋgari. ");
INSERT INTO kqp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Iyôŋ ba, ken bi bôrŋge sa kwôlê wo en kôl iyôŋ ba: En biɲ naɲ Iban a men, Iban kôba, biɲ naɲ en men hen. Men, hena ré na iyôŋ né kôba, ken bi bôrŋge san a, wô kibi aŋga en li hen. ");
INSERT INTO kqp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na tu kwôlê ené kelêŋge hen: kwôni wo bi bôri san a na, ôbi a lê aŋga en li hen men, a hô lê ka ɗê ka en li hen aɲ sôŋ, wôsa en ô na ligi Iban a tô. ");
INSERT INTO kqp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aɲ are kêm ka ka eŋgeré naɲ henen hen na, na lê béŋge aɲ bay ré geliɲ damɲare to Iba Kema sa kibi Kemari. ");
INSERT INTO kqp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hena kené eŋgere ani naɲ henen na, na lê béŋge.» ");
INSERT INTO kqp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Hena kené geyen ba, ka bê kwôlê sa tôô tiɲê a men. ");
INSERT INTO kqp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aɲ nôbi na uwôlê Iban aɲ ôbi a béŋge hende lê naɲ ken to ɗaŋgi bi ré sa mô naɲ ken yôd naɲ kuune. ");
INSERT INTO kqp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hende a na Tunu toɲ tu kwôlê to ɓiɲé ka sa terare a nà. Bay a geyére ré, wôsa bay gele ré men, bay hône ré a men. Niɲba, kenbay ba, ken hône, wôsa hende mô naɲ ken men, mô bôrŋge a a men.» ");
INSERT INTO kqp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Na ɗéŋge kam tiɲaɲê ré, niɲba, na hera uɲéŋge hen ya. ");
INSERT INTO kqp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dê iyôŋ a menba, ɓiɲé ka sa terare a nà, a gelen ré niɲ, niɲba, kenbay ba, ka gelen. Mega wo en mô tu geɲ hen iyôŋ na, kenbay kôba ka merê tu geɲ a men. ");
INSERT INTO kqp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wulê bi wo hen na, ka henê wo nibay naɲ Iban niné yi mega gawra wo pôn iyôŋ men, kenbay naɲ en kôba, nana yi mega gawra wo pôn iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Kwôni wo hôn tôô tiɲê aɲ bi kwôlê sara dô ba, ôbi a puren men, Iban a peréri men, nôbi kôba, na peréri men, na lê aɲ ôbi a henê wo ené na i ba, a men.» ");
INSERT INTO kqp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Menba, Judas wo na kwoɲ Iskariyôt ré hen kôli iyôŋ ba: «Kelma, na iyeŋ a jeré gelé yem béni nibay ɗiba biɲ ɓiɲé ka sa terare a nà, ré hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Menba, Jésu uwôli sara iyôŋ ba: «Hena kwôni ré geyen ba, a bê kwôlê sa kwôlê wuɲê men, Iban a geyéri men, nibay naɲ Iban niɲa era uɲéri aɲ sa biɲ naɲ ɗi a men. ");
INSERT INTO kqp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Niɲba, kwôni wo geyen ré, ba, a bê kwôlê sa kwôlê wuɲê ré men. Aɲ kwôlo ken toy keben a hen na, na kwôlê wuɲê ré, niɲba, na kwo Iban wo joon hen ɗi.» ");
INSERT INTO kqp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Na en kelêŋge kwôli are bay ka hen kiriɲa na en baɲ naɲ ken hen. ");
INSERT INTO kqp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hende lê naɲ ken to na Tunu toɲ hendi bô bôrê to Iban a joɲ naɲ henen béŋge hen na, hende a geléŋge are kêm men, a jebé tô bôrŋge sa kwôlo kêm wo na en kelêŋge a hen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«En ɗéŋge naɲ bô jalê wuɲê, en béŋge bô jalê wuɲê, en béŋge na môɲ kwo ɓiɲé ka sa terare a nà, biɲ hen iyôŋ né. Iyôŋ ba, ken ɗi bôrŋge bôɲ kam ré men, ken sun ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na ken toy, na en kelêŋge iyôŋ ba: ‹Na erê aɲ na bulo hera uɲéŋge.› Hena kené geyen ba, ka sa lê yi derê wô wo en hô ligi Iban a wôsa ôbi dami ɗên. ");
INSERT INTO kqp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na en kelêŋge kwôli are bay ka hen ca tumô niɲ dema bay ré sa tô, aɲ bi kiriɲa are bay ka hen ré sa ba, kené biɲ bôrŋge sara. ");
INSERT INTO kqp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na iyêlê naɲ ken gaɲ cêgê ré niɲ, wôsa kelma wo sa terare a nà wo na Sidan hen era hen ya. ");
INSERT INTO kqp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ôbi ôriɲ naɲ néé san a ré. Niɲba, na bé ɓiɲé ka sa terare a nà, ré hôn wo ené gey Iban aɲ ené li na aŋga ôbi ré gey ené li hen. Henaŋge ta, na erêŋge aɲ kiriɲ ka nà.» ");
INSERT INTO kqp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ena yi tiɲaɗor toɲ tiri hen men, Iban a na ôbi gemére men. ");
INSERT INTO kqp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kam kôbi tiɲaɗor to yê ré ba, ôbi dere jô aɲ, niɲba, to yê ba, ôbi ɲane bi ré hô yê damaŋ a. ");
INSERT INTO kqp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Haw hen kena ɓiɲé ka sédelé sa kibi kwôlo na en ulêŋge béréri hen. ");
INSERT INTO kqp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hena kené biɲ naɲ en ba, nôbi ba, kôba na biɲ naɲ ken men. Hena kôbi tiɲaɗor ré baa yi gurôre a ré ba, a nêmê yê sa kibri biɲ né, hen iyôŋ na, kenbay kôba, hena kené biɲ naɲ en ré ba, ka nêmê lê ani kani ka dôri sa kebreŋge ré kwôy hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Nôbi ena yi tiɲaɗor aɲ kenbay kena kami kôbre. A hena kwôni ré biɲ naɲ en aɲa nôbi ené biɲ naɲ ɗi a men na, ôbi a lê aŋga dôri damaŋ biɲ Emen, wôsa hena nôbi ené naɲ ken ré ba, ka lê ani kani sa kebreŋge ré. ");
INSERT INTO kqp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hena kwôni ré biɲ naɲ en ré ba, bay a uwôli aɲ, môɲ kam kôbi tiɲaɗor to bay na soor aɲ hay menba, bay pô bi bô tare a aɲ uwoyéɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hena kené biɲ naɲ en men, hena kwôlê wuɲê yi bôrŋge a a men na, eŋgeréŋge aŋga yôŋ yôŋ ka ken gey aɲ ka uɲé. ");
INSERT INTO kqp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hena kené li aŋga damaŋ biɲ Emen na, bay a ayê kibi Iban men, ôbi a, kené yiɲ bay tôn a men tô. ");
INSERT INTO kqp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mega wo Iban geyen hen iyôŋ na, nôbi kôba, en geyéŋge hen iyôŋ men. Biɲge naɲ en, aɲ bi na peréŋge. ");
INSERT INTO kqp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Hena kené bi kwôlê sa tôô tiɲê ba, na peréŋge mega wo nôbi en biɲ kwôlê sa tôô to Iban a, aɲ ôbi puren hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«En kelêŋge kwôli are bay ka hen, aɲ bi yi derê wo yi yena hen na, ré yi yerŋge a iyôŋ men, aɲ bi yi derê woŋge bi wo hen ré dô dô cerêd. ");
INSERT INTO kqp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na tôô tiɲê nôbi a na: ‹Periɲge yerŋge mega nôbi kôba, en peréŋge hen iyôŋ men.› ");
INSERT INTO kqp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ayê yem biɲ temare wô sa milɲêm na, peré wo ɗê kwo hen ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hena kené li aŋga en ay tôô béŋge hen na, kena milɲên. ");
INSERT INTO kqp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na uwôgêŋge manê cêgê ré niɲ yôd, wôsa kwôni wo na mana na, hôn aŋga ôbi iyéyri li hen né. Nôbi en uwôgêŋge milɲên wôsa en geléŋge aŋga Iban na gelon hen kêm. ");
INSERT INTO kqp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na kenbay a dôren né, niɲba, na nôbi a terêŋge aɲ jéŋge aɲ bi jé lêreŋge ré yi kwo dôri kwôy kwôy men, ré yi naɲ kiniji a men. Aɲ bi kiriɲa kené eŋgeriɲ Iban aŋga yôŋ yôŋ naɲ henen ba, ôbi ré béŋge a men. ");
INSERT INTO kqp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tôô to en ay béŋge a na: ‹Periɲ yerŋge.› » ");
INSERT INTO kqp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Hena ɓiɲé ka sa terare a nà ré derêŋge yôd na, ken hôn wo bay na ré kaɲen yôd na hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hena henaŋ kené na ka sa terare a nà ná, sa terare henaŋ ré geyé aŋgare. Niɲba, kena ka sa terare a nà ré men, en terêŋge na perê ɓiɲé ka sa terare a nà na wô bi wo hen aɲa bay ré derêŋge yôd hen. ");
INSERT INTO kqp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Erméŋge sa kwôlo na kelêŋge hen: ‹Mana a gôliɲ sa dami wori ré.› Hena bay na ré gelen gusiɲ ba, kenbay kôba, bay a geléŋge gusiɲ hen iyôŋ men, hena bay na ré bi kwôlê sa kwôlê wuɲê a ba, bay a bê sa kwoŋge a hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Niɲba, bay a lêŋge are bay ka kêm hen wô kibi henen, wôsa bay hôn kwo joon hen né. ");
INSERT INTO kqp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hena na ené sa ré men, na en kôlji kwôlê wo Emen ré a men na, têriɲ henaŋ ré naɲê yirji a. Niɲba, haw hen, bay a derê kibriji wô sa têriɲ toji biɲ né. ");
INSERT INTO kqp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kwôni wo kaɲen ba, kaɲ na Iban hen men. ");
INSERT INTO kqp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hena na ené li perêrji a aŋga kwôni na li tumô sa pôn ré hen na, têriɲ henaŋ né naɲê yirji a, niɲba, haw hen wo bay gel are bay ka en li hen kôba, bay kaɲêni nibay naɲ Iban. ");
INSERT INTO kqp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Niɲba, yi hen iyôŋ bi kwôlo na liɲ bô magtubu tôô toji a kôl iyôŋ ba: ‹Bay kaɲen yôd na ɗéɲ iyôŋ› hen na, bi ariri ré liɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Menba, Jésu hô kôlji iyôŋ ba: «Kiriɲa hende lê naɲ ken to na Tunu toɲ hendi yêgê sa kwôlê woɲ tiri biɲ ɓiɲé hen to hena ligi Iban a a sa na, hende a sa derêŋge kwôlen. ");
INSERT INTO kqp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Men, kenbay kôba, ka sa derê kwôlen, wôsa na kena naɲ en kiriɲa na en ayiɲ tô jé wuɲê kwôy kemnêŋ kemnêŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Na en kelêŋge kwôli are bay ka hen, aɲ bi kené ɗi tô ayê bôô woŋge aɲ né. ");
INSERT INTO kqp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bay a dagêŋge bô *iyéy daɲare a men, era baa tumô hen na, kwôni a deréŋge menba, a ermé môɲ ɗiré tebe na Emen hen. ");
INSERT INTO kqp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bay a lê hen iyôŋ, wôsa bay hôn Iban ré men, bay hônen nôbi ré a men. ");
INSERT INTO kqp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","En kelêŋge kwôli are bay ka hen, aɲ kiriɲa bay ré sa ba, kené erem mega wo na ené kelêŋge kwôliji tumô niɲ. Na en kelêŋge ca tumô ré, na wô wo na en baa naɲ ken tô.» ");
INSERT INTO kqp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Haw hen, na herê ligi kwo na joon a hen. Menba, kwôni pôn nêŋ iyôŋ perêrŋge a hen eŋgeren iyôŋ ba: ‹Ju ô na yôŋ ba›, ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na wô wo en kelêŋge kwôli are bay ka hen, aɲa turŋge ré ɲa hen ba? ");
INSERT INTO kqp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Niɲ na, na kelêŋge na tu kwôlê: hena ené ô ba, a derê wô sarŋge, wôsa hena ené ô ré ba, hende lê naɲ ken a era uɲéŋge ré. Niɲba, hena ené ô na, na joɲ naɲ tu béŋge. ");
INSERT INTO kqp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aɲ kiriɲa hende a sa na, hende a geliɲ ɓiɲé ka sa terare a nà, mega wo ermé woji wo gengiɲ sa têriɲ men, sa lê aŋgaɲ derôre a men, sa jerê kwôlê a a men hen na, ré habiɲ. ");
INSERT INTO kqp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wôsa kwo gengiɲ sa têriɲ ba, na wô wo bay bi bôrji san a ré. ");
INSERT INTO kqp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Men, kwoɲ lê aŋgaɲ derôre ba, na wô wo na erê ligi Iban a, aɲ ka gelen cêgê ré niɲ yôd hen. ");
INSERT INTO kqp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Men, kwo gengiɲ sa jerê kwôlê a ba, na wô wo kelma wo sa terare a nà, bay jô kwôlê sari a niɲ a men.» ");
INSERT INTO kqp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Kwôlê baa gaɲ wo ré ené kelêŋge tô, niɲba, haw hen en hôn wo ré ɗê sarŋge. ");
INSERT INTO kqp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kiriɲa Tunu toɲ hende yêgê sa kwôlê woɲ tiri biɲ ɓiɲé hen, a sa na, hende a geléŋge tu kwôlê kêm, wôsa hende a kelê kwôlê wôni sa kebre ré, niɲba, na kwôlo hende toya men, hende a kelêŋge kwôli aŋga a era hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hende a geliɲ ɓiɲé damɲare tiɲê wôsa na kwôlo hende toyo keben a ré kelêŋge hen. ");
INSERT INTO kqp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Are kêm ka Iban ôriɲ hen na, na kaɲê nôbi men. Na ôbi á, ené kôl hende ré sa kelêŋge na kwôlo hende toyo keben a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Dê a menba, ka gelen ré niɲ men, sem cêgê menba, ka hô gelen.» ");
INSERT INTO kqp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sa kwôlê bi wo hen a na, bay tôri ka pôni eŋgeriɲ yirji kôl iyôŋ ba: « ‹Dê a menba, ka gelen ré niɲ men, sem cêgê menba, ka hô gelen wôsa en ô na ligi Iban a›, hen ba, bôri na iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Menba, bay hô kôl iyôŋ ba: «Ba kwôlo ôbi kôl iyôŋ ba: ‹Dê a› hen ba, bôri na iyeŋ ba? Wôsa nana hôn bô kwôlê wori bi wo hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jésu hôn wo bay ré gey eŋgereri kwôlê menba, ôbi kôl iyôŋ ba: «Ken eŋgeren na kwôlê na sa kwo ené kôl iyôŋ ba: ‹Dê a menba, ka gelen ré niɲ men, sem cêgê menba, ka hô gelen hen ba?› ");
INSERT INTO kqp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na tu kwôlê ené kelêŋge hen: ka sômnê men, ka ɓarê men, menba, ɓiɲé ka sa terare a nà ba, a merê naɲ yi derê. Kenbay ka geliɲ gusiɲ niɲba, gusiɲ toŋge hende to hen a sa beliɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kiriɲa iyore ta yê na, hende geliɲ gusiɲ wôsa wulê wore nêm, niɲba, kiriɲa hende yê kema uwôl tôŋ niɲ na, yi derê wo gawra ré yêɲ sa terare a nà hen lere aɲ hende gôrbiɲ sa gusiɲ to na lere hen. ");
INSERT INTO kqp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kenbay kôba, haw hen ken geliɲ gusiɲ niɲba, na hô geléŋge ka lê yi derê aɲ kwôni wo a derê yi derê woŋge bi wo hen ba, naɲ niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Wulê bi wo hen a na, ka eŋgeren kwôlê wôni ré kwôy. Na tu kwôlê ené kelêŋge hen, aŋga yôŋ yôŋ ka ken eŋgeriɲ Iban naɲ henen na, ôbi a béŋge. ");
INSERT INTO kqp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kwôy kemnêŋ kemnêŋ kôba, ken eŋgere ani naɲ henen ré tô. Eŋgeréŋge aɲ ka uɲé aɲ bi yerŋge ré derêŋge cerêd.» ");
INSERT INTO kqp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«En kelêŋge kwôli are bay ka kêm hen naɲ gwosore niɲ. Niɲba, wulêri a nêmê na, na kelêŋge na naɲ gwosore ré niɲ. Niɲba, na kelêŋge kwôli Iban waŋ ta. ");
INSERT INTO kqp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wulê bi wo hen na, ka eŋgeré are naɲ henen ɗiba, na uwôliɲ Iban are wô sarŋge ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Wôsa Iban bi naɲ yiri geyéŋge, wôsa ken geyen men, ken bi bôrŋge san a mega wo ené hena na ligiri a a men. ");
INSERT INTO kqp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","En hena na ligi Iban a a ené era sa terare a nà. Haw hen, na hena sa terare a nà, herê ligi Iban a.» ");
INSERT INTO kqp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bay tôri kôli iyôŋ ba: «Gel, haw hen ju kôl kwôli Ibam waŋ a ta men, ju kôl gwosore tôni ré men. ");
INSERT INTO kqp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Haw hen, nini hôn wo jeré hôn are kêm aɲ kwôlê wo kwôni ɗa eŋgerem tô kôba, ju hôn niɲ. Na ôbi á, niné bi bôrni sam a wo jeré hena na ligi Ibam a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Menba, Jésu uwôlji sara iyôŋ ba: «Ken hôn niɲ ba? ");
INSERT INTO kqp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wulêri nêm niɲ wo ka useriɲ aɲ i ba a wayê kwini erê erê aɲ ka ɗén penen. Niɲba, ena penen ré, wôsa Iban na naɲ en. ");
INSERT INTO kqp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na en kelêŋge kwôli are bay ka hen, bi kené uwôɲ bô jalê legen a. Ka geliɲ gusiɲ sa terare a nà, niɲba, ken ɓu bôrŋge iyêre wôsa en gôliɲ sa néé wo sa terare a nà niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kiriɲa Jésu kôl hen iyôŋ kô niɲ menba, ay tiri bôriɲ kiriɲ si derômaraŋ aɲ kôl iyôŋ ba: «Iban, wulêri nêm niɲ. Ay kibi Kemam aɲ bi Kemam kôba, ay kem men. ");
INSERT INTO kqp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wôsa ju biri tôô sa ɓiɲé ka sa terare a nà kêm bi ré biɲ ka ju biri hen merê wo naɲ kwini. ");
INSERT INTO kqp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aɲ merê wo naɲ kwini bi wo hen na, na bi bay ré hônem jôbi Emen woɲ tiri pôn nêŋ ham hen men, bay ré hôn Jésu *Krist wo ju jori hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","En gel damɲare tom sa terare a nà men, en li jé wo na ju bên kôben a hen kô niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iyôŋ ba, Iban, haw hen wo ju môriɲ hen na, ju hô ben damɲare tiɲê to na en baɲ legem a tumô pa dema tô terare na ré ɗiɲ tô hen.» ");
INSERT INTO kqp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Ɓiɲé ka sa terare a nà, ka na ju teraji ben hen na, en li kwôy aɲ bay hôn damɲare tom. Bay na kam aɲa jeré ben hen, ôbi a, bay ré bi kwôlê sa kwôlê wom a hen. ");
INSERT INTO kqp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aɲ haw hen, bay hôn mega wo are kêm ka jeré ben hen na, ré hena na legem a. ");
INSERT INTO kqp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wôsa na kwôlo na ju kelan a ené kôlji men, bay eŋge biɲ bôrji sara aɲ bay hôn dô wo ené hena na legem a tiri men, bay bi bôrji sam a mega wo jôbi a na ré joon a men.» ");
INSERT INTO kqp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Na wô sarji bay a ené uwôlem hen. En uwôlem na wô sa ɓiɲé ka sa terare a nà ré, niɲba, wô sa ka ju ben hen, wôsa bay na kam. ");
INSERT INTO kqp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wôsa aŋga na kaɲê ba, na kam men, ka na kam ba, na kaɲê men. Aɲ bay ré geliɲ damɲare tiɲê yirji a. ");
INSERT INTO kqp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nôbi ena kwo sa terare a nà ré niɲ, niɲba, bay ba, baji sa terare a nà tô, wôsa na herê legem a. Iban wo yi naɲ jeŋgêri, ɓiɲé ka na ju ben hen na, ju gemji naɲ henem, aɲ bi bay yi mega gawra wo pôn, mega wo nabay kôba, nana pôn hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kiriɲa na en baɲ naɲ ci sa terare a nà tô na, na en gemji naɲ henem. Na en gem ka na ju ben hen ɗiba, kwôni pôn nêŋ iyôŋ kôba, na kay ré. Niɲba, na kema woɲ ôbi mênê pôn hari a kayê, aɲ bi kwôlo na yi bô magtubu to Emen a hen ré ô naɲ geréri. ");
INSERT INTO kqp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aɲ haw hen wo na herê legem a hen na, en kôl kwôli are bay ka hen wo en baa sa terare a nà tô, bi bay ré uwôɲiɲ yi derê wuɲê mega wo yen nôbi kôba, dôren hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","En kôlji kwôlê wom menba, ɓiɲé ka sa terare a nà kaɲji yôd, wôsa bay li aŋga ɓiɲé ka sa terare a nà li hen né, mega wo nôbi kôba, ena kwo sa terare a nà ré hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","En uwôlen na wo jeré pôrji sa terare a nà ôriɲ legem a ré tô, niɲba, jeré gemji wô wo Sidan woge wô bêji kayê hen ɗi. ");
INSERT INTO kqp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bay na ka sa terare a nà ré, mega wo nôbi kôba, ena kwo sa terare a nà ré hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bi tu kwôlê wom liji bi bay yi ɓiɲé ka yi naɲ jeŋgêrji, wôsa kwôlê wom na, na tu kwôlê. ");
INSERT INTO kqp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mega wo na ju joon perê ɓiɲé ka sa terare a nà hen iyôŋ na, nôbi kôba, en jéji perê ɓiɲé ka sa terare a nà hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","En ay yen liɲ jé bem wô sarji aɲ bi bay kôba, ré ayiɲ yirji liɲ jé bem tiri hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Na wô sarji bay piniji a ené uwôlem hen né, niɲba, wô sa ka a bê bôrji san a wô kwôlo bay ka ju ben hen a dôrji hen a men. ");
INSERT INTO kqp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","En uwôlem na wo bay kêm ré yi mega gawra wo pôn. Iban, bi bay biɲ pôn naɲ na, mega wo nabay kôba, nana yi môɲ gawra wo pôn hen iyôŋ men, bi bay yi mega gawra wo pôn iyôŋ men. Aɲ bi ɓiɲé ka sa terare a nà ré bi bôrji san a wo jôbi a ré joon hen. ");
INSERT INTO kqp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hini emê wo na ju ben hen na, nôbi kôba, en biji men, aɲ bi bay ré biɲ pôn mega wo nabay nana biɲ pôn hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aɲ nôbi naɲ ci niɲa gawra wo pôn mega wo jôbi naɲ en nana gawra wo pôn hen iyôŋ men, aɲ bi bay ré biɲ pôn dô. Ôbi a, ɓiɲé ka sa terare a nà ré henê wo jôbi a na ré joon men, jeré geyji môɲ kwo jeré geyen hen iyôŋ men hen.» ");
INSERT INTO kqp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Iban, en gey bi kiriɲ ka ené merê ya hen na, ɓiɲé ka na ju ben hen ré mô ya men, aɲ bi bay ré gel damɲare to na ju ben hen, wôsa ju geyen ca tumô dema tô terare na ré ɗiɲ tô. ");
INSERT INTO kqp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Iban woɲ ôbi lê aŋgaɲ derôre, ɓiɲé ka sa terare a nà na hônem ré, niɲba, nôbi en hônem, aɲ ka na ju ben hen hôn wo jôbi a na ré joon. ");
INSERT INTO kqp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","En li aɲ bay hônem men, na hô lê aɲ bi bay hônem damaŋ a. Aɲ bi geyé wo ju geyen hen na, bi bay kôba, geyiɲ megêrji hen iyôŋ men, bi nôbi ené biɲ pôn naɲ ci a men.» ");
INSERT INTO kqp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kiriɲa Jésu uwôl Emen hen iyôŋ kô niɲ menba, ôbi naɲ bay tôri ɗayji si cêgi tu kam ka bay uwôgeri Sédrôn aɲ bay ô bô yagê wo pôni wo bay baniɲ gurô ya wo yi kiriɲ bay ka hen a. ");
INSERT INTO kqp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Menba, Judas wo a sa ayê sari hen hôn kiriɲ bay ka hen dô, wôsa Jésu naɲ bay tôri ôrji ya gaŋ gaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Menba, Judas dera asgarɲê naɲ bay gemé *iyéy Emen ka damné kaɲ bay bê kwôbe naɲ *Parisiɲêɲê a joji hen eraɲ kiriɲ bay ka hen naɲ tare toɲ tô deɲere men, lampa men, aŋgaɲ maɲê a men. ");
INSERT INTO kqp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jésu hôn aŋga ré sa liri hen, menba, ôbi jera kwiniji aɲ kôlji iyôŋ ba: «Ken woge na i ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Menba, bay uwôli sara iyôŋ ba: «Nini woge na Jésu wo Najarêt.» Menba, ôbi uwôlji sara iyôŋ ba: «Na nôbi bi a na.» Judas woɲ ôbi ayê sari hen kôba, naɲ ci ya men. ");
INSERT INTO kqp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kiriɲa Jésu kôlji iyôŋ ba: «Na nôbi bi a na», menba, bay hô naɲ cêgeriji aɲ heriɲji. ");
INSERT INTO kqp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jésu hô eŋgeriji iyôŋ ba: «Ken woge na i ba?» Menba, bay kôl iyôŋ ba: «Nini woge na Jésu wo Najarêt.» ");
INSERT INTO kqp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Menba, Jésu hô uwôlji sara iyôŋ ba: «Ré ené kelêŋge tumô ré na nôbi bi a ré na ré ba? A hena ré na nôbi a kené wogen ba, kamaŋ ka hen ba, ken ɗiji ô aŋgaji.» ");
INSERT INTO kqp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ôbi kôl hen iyôŋ bi kwôlo na ré liɲ bô magtubu to Emen a kôl iyôŋ ba: «Ka na ju ben hen na, kwôni pôn nêŋ iyôŋ kôba, kay ré hen na, ariri ré liɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simô Piyêr wo ôriɲ naɲ yebere toɲ kaskar to kôbri a hen, dô diɲ maa mana wo pôni wo *dami wo damné kaɲ bay bê kwôbe woɲ gusurô jô. Mana bi wo bay di mari jô hen na, hini na Malkus. ");
INSERT INTO kqp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Menba, Jésu kôliɲ Piyêr iyôŋ ba: «Dôbe yebere tom hôriɲ bô sabare a. Ju gey bi ené geliɲ gusiɲ to Iban na ɗi gengiɲ san hen né ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Menba, asgarɲê naɲ dami woji men, bay gemé iyéy Emen a men ɓeroji Jésu aɲ harêri naɲ gaŋne. ");
INSERT INTO kqp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Menba, tumô ba, bay ôriɲ naɲ ɗi iyé Aan a wo na môy Kayib woɲ dami wo damné kaɲ bay bê kwôbe bô elê bi wo hen a hen. ");
INSERT INTO kqp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Men, na Kayib bi a na kôliɲ damné ka Jubɲê iyôŋ ba: «Hena gawra pôn ré ma wô sa ɓiɲé ka sa ira ba, dô hen.» ");
INSERT INTO kqp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simô Piyêr naɲ ôbi tô Jésu wo pôni kôbiji tô Jésu. Ôbi tô Jésu wo pôni bi wo hen na, dami wo damné kaɲ bay bê kwôbe hôni dô. Na ôbi á, bay ré ɗiri ô naɲ Jésu ira derô haba wo dami wo damné kaɲ bay bê kwôbe bi wo hen a hen. ");
INSERT INTO kqp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Niɲba, Piyêr ba, ɗebo baa nô kibi geré. Menba, ôbi tô Jésu bi wo hen so sa iyêl naɲ iyore to gem kibi geré hen menba, hende ɗi Piyêr ô ira men. ");
INSERT INTO kqp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hende gemé kibi geré hende to hen eŋgeriɲ Piyêr iyôŋ ba: «Jôbi ju na ôbi tô gawra bi wo hen men, ré ba?» Menba, ôbi kôle iyôŋ ba: «Eŋ eŋ, ena ôbi tôri ré.» ");
INSERT INTO kqp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kelanê dii menba, bay jé naɲ bay gemé iyéy Emen hen lamji tare iyêbe. Menba, Piyêr kôba, era sa iyêbe naɲ ci men. ");
INSERT INTO kqp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dami wo damné kaɲ bay bê kwôbe eŋgeriɲ Jésu kwôlê gengiɲ sa bay tôri men, sa ari gelé kari a men. ");
INSERT INTO kqp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Menba, Jésu uwôli sara iyôŋ ba: «En kôl kwôlê wuɲê tu wolé men, en geliɲ ɓiɲé are bô *iyéy daɲare a men, bô iyéy Emen a men, kiriɲ ka Jubɲê kêm daɲ ya hen a men ɗiba, en li ani kani naɲ uwôbê ré. ");
INSERT INTO kqp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wô mi a jeré eŋgeren ba? Eŋgeriɲ ɓiɲé ka na toy kwôlo na en dô hen. Wôsa bay hôn kwôlê bi wo na en dôrji hen.» ");
INSERT INTO kqp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kiriɲa Jésu kôl hen iyôŋ menba, ôbi gemé iyéy Emen wo pôni kwo ré ɗebe kwa hen di Jésu tô mari a aɲ kôli iyôŋ ba: «Na hen iyôŋ a jeré uwôliɲ dami wo damné kaɲ bay bê kwôbe kwôlê sara hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Menba, Jésu uwôli sara iyôŋ ba: «Hena ené iyêl habiɲ ba, ju gelen kwôlê bi wo en iyêl habiɲ hen. A hena kwôlo ené iyêl hen na tiri ba, wô mi a jeré dên ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Menba, Aan jéɲ naɲ Jésu naɲ kôbri wo ré hariɲ biɲ dami wo damné kaɲ bay bê kwôbe Kayib. ");
INSERT INTO kqp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kiriɲ bay ka hen na, Piyêr ɗebe iyêbe tare tori hende to hen baa ya menba, kwôni wo pôni eŋgereri iyôŋ ba: «Jôbi kôba ju na perê bay tô gawra bi wo hen men ré ba?» Menba, Piyêr uwôser kôl iyôŋ ba: «Eŋ eŋ, ena ôbi tôri ré.» ");
INSERT INTO kqp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mana wo dami wo damné kaɲ bay bê kwôbe wo pôni na gôbri kwo Piyêr na di mari jô hen kôli iyôŋ ba: «Kamaŋ, na gelem bô yagê a naɲ ɗi ré ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Niɲba, Piyêr hô uwôser a menba, kiriɲ bay ka hen na, kura yel. ");
INSERT INTO kqp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tô kiriɲ cud menba, bay henaɲ naɲ Jésu iyé Kayib a ôriɲ iyé ôbi emê sa iyére woɲ Rômê wo bay uwôgeri Pilat hen. Niɲba, damné ka Jubɲê ôrji ira ré wôsa Pilat na Jub ré, wôsa erê iyé kwôni na Jub ré na, a lê aɲ bay a kagemê. Bay gey bi yirji ré *kagem né, bi ciré ômiɲ geserê *Pak. ");
INSERT INTO kqp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Na ôbi á, ôbi emê sa iyére Pilat ré so nô dema ré sa uwoɲji hen. Kiriɲa ôbi sa menba, eŋgeriji iyôŋ ba: «Na kwôli mi a kené uwôl sa gawra bi wo hen a ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Menba, bay uwôli sara iyôŋ ba: «Hena gawra bi wo hen henaŋ ré li habrê wôni ré ba, henaŋ niné eraɲ naɲ ɗi tumôm a ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Menba, Pilat uwôlji sara iyôŋ ba: «Ɓeréŋgeri ken ôriɲ aɲ kenbay ken ô jerê kwôlê sari a naɲ tôô toŋge.» Menba, bay hô uwôli sara iyôŋ ba: «Kenbay kaɲ Rômê ken kelêni niné uwôliɲ kwôni kwôlê woɲ temare sari a ré.» ");
INSERT INTO kqp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na hen iyôŋ aɲa kwôlo Jésu na kôl gengiɲ sa geré temayri to ɗiré ma hen, ariri ré liɲ hen. ");
INSERT INTO kqp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Menba, Pilat bul hô ira ô uwôgê Jésu aɲ eŋgereri iyôŋ ba: «Ju na kelma wo Jubɲê bi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Menba, Jésu uwôli sara iyôŋ ba: «Kwôlo ju eŋgeren hen, na kwo jôbi a ermé hen iyôŋ laba, na kwôni a kôlen hen iyôŋ gengiɲ san ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Menba, Pilat uwôli sara iyôŋ ba: «Nôbi ena Jub ba? Na yênêm kam naɲ damné kaɲ bay bê kwôbe a eraɲ naɲ ju ben. Niɲba, ju la na mi ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Menba, Jésu uwôli sara iyôŋ ba: «Emê iyére tiɲê na to sa terare a nà ré. Hen aɲa emê iyére tiɲê henaŋ ré na to sa terare a nà ná, henaŋ manê kaɲê henaŋ ré karê maɲê wô san aɲ bi bay ré ɓuren biɲ damné ka Jubɲê ré. Niɲba, na hen iyôŋ né, wôsa emê iyére tiɲê na to sa terare a nà ré.» ");
INSERT INTO kqp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Menba, Pilat hô eŋgereri iyôŋ ba: «Iyôŋ ba, ju na kelma ɗê?» Menba, Jésu uwôli sara iyôŋ ba: «Na ôbi, a jeré kôl hen, ena Kelma. Nôbi en yêɲ aɲ en era sa terare a nà wô derê kwôli tu kwôlê aɲ ɓiɲé kêm ka na ka tu kwôlê hen na, bay toy kwôlê wuɲê bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Menba, Pilat hô eŋgeriɲ Jésu iyôŋ ba: «Tu kwôlê ba, na mi ba?» Cêgi kwôlê bi wo hen menba, ôbi hena hô si nô ô uɲé Jubɲê aɲ kôlji iyôŋ ba: «Ken toy, nôbi en uwôɲ kwôlê wôni wo na ɓeriɲ gawra bi wo hen né. ");
INSERT INTO kqp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Niɲba, naɲ hara woŋge na, en uwôl daŋgay pôn pôn ta béŋge kwôy kwôy naɲ geserê Pak hen ba, ken gey bi ené uwôl kelma wo Jubɲê ta béŋge ba?» ");
INSERT INTO kqp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Menba, bay ka gura naɲ kwônêrji iyôŋ ba: «Nini gey ré, ulêni Barabas ta ɗi.» Men né, Barabas bi wo hen na, na bandi men. ");
INSERT INTO kqp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Menba, *Pilat ay tôô bi bay ré yêmnê Jésu naɲ tinêre. ");
INSERT INTO kqp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asgarɲê gaa jabga woɲ kenare naɲ gesem aɲ dôbri sari a men, bay dôbri bargay kaɲ kenare ka sêyi yiri a a men. ");
INSERT INTO kqp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Menba, bay uso ɗa ligiri a aɲ kôli iyôŋ ba: «Dosé tom kelma wo Jubɲê» men, bay sêri tô mari a men. ");
INSERT INTO kqp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Menba, Pilat hô so nô aɲ kôliɲ Jubɲê iyôŋ ba: «Geléŋge, en saɲ naɲ ɗi nô béŋge bi kené hôn mega wo ené uwôɲ kwôlê wôni wo habiɲ yiri a ré.» ");
INSERT INTO kqp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jésu so naɲ jabga woɲ kenare woɲ gesem naɲ bargay ka sêyi kaɲ kenare ka bay ré tôbri yiri a hen. Menba, Pilat kôl iyôŋ ba: «Geléŋge, gawra bi a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kiriɲa damné kaɲ bay bê kwôbe naɲ bay gemérji gili hen iyôŋ menba, bay bi gura kôl iyôŋ ba: «Ɓériŋgeri sa gurô tagelê, ɓériŋgeri sa gurô tagelê.» Menba, Pilat kôlji iyôŋ ba: «Kenbay ken ɓiri aɲ ken ô ɓééri sa gurô tagelê ɗiba, nôbi en uwôɲ ani kani ka ôbi li ka habiɲ né.» ");
INSERT INTO kqp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Menba, Jubɲê uwôli sara iyôŋ ba: «Nibay nini ôriɲ naɲ tôô toni ya aɲ naɲ tôô toni hende to hen na, niɲa deréri, wôsa ôbi kôl ɗiré na Kema Emen.» ");
INSERT INTO kqp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kiriɲa Pilat toy kwôlê bi wo hen iyôŋ menba, harê hô liri damaŋ a. ");
INSERT INTO kqp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ôbi hô kini merêri a aɲ eŋgeriɲ Jésu iyôŋ ba: «Jôbi ju na gawra wo yôŋ ba?» Niɲba, Jésu uwôli kwôlê wôni sara ré. ");
INSERT INTO kqp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Menba, Pilat kôli iyôŋ ba: «Na nôbi a jeré wômen tôŋ hen ba? Ju hôn mega wo ené ôriɲ naɲ néé woɲ ɓéremare sa gurô tagelê men, kwoɲ uwôlemare ta a men iyôŋ né ba?» ");
INSERT INTO kqp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Menba, Jésu uwôli sara iyôŋ ba: «Hen aɲa Emen henaŋ ré bem néé bi wo hen ré ba, henaŋ jeré ôriɲ naɲ néé wôni san a ré kwôy. Na ôbi á, kiriɲa kwo ré ɓeren bem hen na, ôbi li na têriɲ to dami ɗêm.» ");
INSERT INTO kqp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kiriɲ bay ka hen na, Pilat woge geré ɗiré ulêri ta. Niɲba, Jubɲê ka gura kôl iyôŋ ba: «Hena jeré uwôli ta ba, ju na melaɲ kelma wo dami *Sésar ré kwôy. Kwôni wo li yiri môɲ kelma iyôŋ na, ôbi na ôbi bayi Sésar.» ");
INSERT INTO kqp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kiriɲa Pilat toy kwôlê bi wo hen iyôŋ menba, ôbi soɲ naɲ Jésu nô aɲ ô merê kiriɲ jerê kwôlê ka bay uwôl daŋne ya ka bay uwôgeji naɲ hébre «Gabata» hen. ");
INSERT INTO kqp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na wulê woɲ ɓeré sa têê geserê *Pak. Tare ɗebu ɗiŋne niɲ menba, Pilat kôliɲ Jubɲê iyôŋ ba: «Geléŋge, kelma woŋge bi.» ");
INSERT INTO kqp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Niɲba, Jubɲê bi gura kôl kibriji pôn hôm iyôŋ ba: «Diri, diri, ɓééri sa gurô tagelê.» Menba, Pilat kôlji iyôŋ ba: «Kelma woŋge bi a kené gey bi nôbi ené ɓééri sa gurô tagelê hen ba?» Menba, damné kaɲ bay bê kwôbe kôl iyôŋ ba: «Kelma woni na Sésar pôn nêŋ hari.» ");
INSERT INTO kqp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Menba, ôbi nôge Jésu biji bi bay ré ô ɓééri sa gurô tagelê. Menba, bay ɓiri ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jésu ay gurô tagelê wori aɲ saɲ kiriɲ ka bay uwôgeji ibé sa gawra ka naɲ kibi hébre ba bay uwôgeji Gwôlgwota hen. ");
INSERT INTO kqp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na kiriɲ bay ka hen a aɲa bay ré ɓééri sa gurô tagelê ya naɲ ɓiɲé ka pôni wôô. Kwo pôni sa kôbri gusurô men, kwo pôni sa kôbri maa men aɲ Jésu derôrji a. ");
INSERT INTO kqp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat ɗi are yi gurô aɲ di ta sa gurô tagelê wo Jésu a aɲ kôl iyôŋ ba: «Jésu wo Najarêt, kelma wo Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jubɲê kwône dêŋse kwôlê bi wo hen wôsa kiriɲ ka bay ɓériɲ Jésu ya hen na, ɗa naɲ iyére. Aɲ are bay ka bay li di ta hen na, na naɲ kibi hébre men, kibi latên men, kibi grêk a men. ");
INSERT INTO kqp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Damné ka bay bê kwôbe ka Jubɲê kôliɲ Pilat iyôŋ ba: «Ɗi ‹Na kelma wo Jubɲê› ré niɲba, ju ɗi ‹Ôbi ré kôl iyôŋ ba: «Ena kelma wo Jubɲê.» › » ");
INSERT INTO kqp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Menba, Pilat uwôlji sara iyôŋ ba: «Aŋga en ɗi tôŋ da niɲ na, yi na yériji.» ");
INSERT INTO kqp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kiriɲa asgarɲê ɓér Jésu kô niɲ menba, bay pô bargay kari soderé kiriɲ pôrbu aɲ céɲji. Bay ay bargay kari kaɲ kabrêri ka yêŋgi ka tu seŋrêrji naɲ aɲ na kibi bargay pôn nêŋ hena ta kwôy era tôŋ. ");
INSERT INTO kqp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Menba, bay kôl iyôŋ ba: «Na yêgerêŋge ré niɲba, na jibiɲ jala terê gelé na i a ɓeré ba?» Aɲ bi kwôlo na liɲ bô magtubu to Emen a hen, ariri ré liɲ. Magtubu hende to hen kôl iyôŋ ba: «Bay céɲ bargay kaɲê men, kaɲ kabrên bay jibiɲ jala terê a men.» Na hen iyôŋ a asgarɲê ré li hen. ");
INSERT INTO kqp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ɗa kwa gurô tagelê wo Jésu a na, yori naɲ yêre ɗebiji ya, Mari toɲ tam Klopas men, Mari to Magdala a men. ");
INSERT INTO kqp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kiriɲa Jésu gel yori men, gel ôbi tôri wo ôbi geyri gaɲ hen ɗebu kware a men na, ôbi kôle iyôŋ ba: «Yon, gel, kemarê a hen niɲ.» ");
INSERT INTO kqp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Men, ôbi kôliɲ ôbi tôri bi wo hen iyôŋ ba: «Gel, na yom a hen.» Ayiɲ tôri wulê bi wo hen na, ôbi ôriɲ naɲ tu iyére tori. ");
INSERT INTO kqp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cêgeri wori menba, Jésu hôn wo are kêm ré kô niɲ menba, kôl iyôŋ ba: «Kam dêên.» Aɲ bi kwôlo liɲ bô magtubu to Emen hen na, ré biɲ. ");
INSERT INTO kqp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kiriɲ bay ka hen na, baɲa gerêŋgê wo pôni yi naɲ kam tiɲaɗor ka bay uwôgeji binêger hen bô. Asgarɲê dôbe jaa bô a aɲ dôbe kibi gurô wo bay uwôgeri *hisôp hen aɲ usoɲ sa dôbri kibri a. ");
INSERT INTO kqp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kiriɲa Jésu yi kam ka geraŋgi bay ka hen menba, ôbi kôl iyôŋ ba: «Kibi are kêm deriɲ niɲ.» Menba, ôbi di sari tôŋ menba, kibri wôm hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kiriɲ bay ka hen na, na wulê woɲ ɲanê sa tê kwô woɲ emê *sa merê ta a menba, Jubɲê hare wô wo temay Jésu naɲ gawrê ka wôô hen maa ré yé kwôy sé sa sa merê ta, wôsa sa merê ta na, na sa to dami. Menba, bay ô eŋgeré Pilat ré pôy têrji aɲ bi bay ré ma lew aɲ ré tô temayriji bi tôŋ. ");
INSERT INTO kqp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ɓiɲé ka bay ɓérji naɲ Jésu hen na, asgarɲê sa pôy têrji wôô kêm. ");
INSERT INTO kqp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kiriɲa bay sa sa Jésu a menba, bay gel wo ôbi ré ma niɲ menba, bay ɗi piyê têri ba, mera. ");
INSERT INTO kqp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Asgar wo pôni jebu kabrê Jésu naɲ yêre menba, kiriɲ bay ka hen na, kwôbe naɲ kam so. ");
INSERT INTO kqp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kwo gel are bay ka hen na, dô kwôliji aɲ kwôlê wori bi wo hen na tiri men, ôbi hôn wo ɗiré kôl na tu kwôlê men, ɗiré kôl hen iyôŋ bi kenbay kôba, kené biɲ bôrŋge sara men. ");
INSERT INTO kqp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Are bay ka hen yi hen iyôŋ bi magtubu to Emen ré ô naɲ gerére magtubu hende to hen na kôl iyôŋ ba: «Ibéri wôni pôn nêŋ iyôŋ kôba, a bôɲ né.» ");
INSERT INTO kqp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Men, magtubu hende to hen hô kôl iyôŋ ba: «Bay a sa gelé kwo bay na cibri hen a men.» ");
INSERT INTO kqp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cêgê menba, Josêp wo Arimaté woɲ ôbi ayê bôô hen era sa eŋgere Pilat ɗiré erê ayê temay Jésu, wôsa ôbi na ôbi tô Jésu niɲba, na naɲ ɲalê, wôsa ôbi hariɲ Jubɲê. Pilat dege naɲ ɗi sara dema ôbi ré ô ayê temay Jésu ôriɲ tô. ");
INSERT INTO kqp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikwodêm wo na ô naɲ yoyre ô uɲé Jésu hen eraɲ naɲ ider wo ɗiɲé dô wo bay li naɲ *miir men, alowês a men hen comlé tôre subu. ");
INSERT INTO kqp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Si Josêp naɲ Nikwodêm ayji temay Jésu lêgere naɲ kibi bargay ka bay yêgerê men wuse ider sari a men mega wo Jubɲê liiriɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kiriɲa bay na ɓériɲ Jésu ya hen na, na ɗa kwa kini banê gurô aɲ kiriɲ bay ka hen na, kamɲê ka kôrbi ka bay kerge bô keram a ka bay emiɲ kwôni ya sa pôn né hen yi ya. ");
INSERT INTO kqp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na bô kamɲê bay ka hen a bay ré emiɲ Jésu ya, wôsa na kamɲê ka yi ɗa naɲ kiriɲ ka bay na ɓééri ya hen. Wôsa Jubɲê ɓu sa têê aŋga gengiɲ sa sa merê ta. ");
INSERT INTO kqp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naɲ sa demas tô kiriɲ cud wo kiriɲ baa hendu ɗurum ɗurum tô menba, Mari to Magdala ô sa kamɲê. Menba, hende gel kulmaŋ keram wo bay na ligiɲ kibi kamɲê hen gerŋgiɲ yi wolé. ");
INSERT INTO kqp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hende ge ô uɲé Simô Piyêr naɲ ôbi tô Jésu wo pôni wo Jésu geyri gaɲ hen aɲ kôlji iyôŋ ba: «Bay dô Kelma kamɲê ôriɲ aɲê aɲ nini hôn kiriɲ ka bay uwôli ya hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyêr naɲ ôbi tô Jésu wo pôni bi wo hen siji gerji ô sa kamɲê. ");
INSERT INTO kqp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Menba, bay gerji wô ɓem niɲba, ôbi tôri wo pôni bi wo hen ge gôliɲ Piyêr aɲ biɲ sa kamɲê tumô. ");
INSERT INTO kqp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ôbi deŋge tôŋ kôbe bô kamɲê menba, gel na kibi bargay ka bay na lêgeriɲ Jésu hen, a yé tôŋ mera. Niɲba, ôbi si bô kamɲê ré. ");
INSERT INTO kqp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simô Piyêr wo guro cêgeri a tôŋ tôŋ hen sa menba, si bô kamɲê menba, gel na kibi bargay a yé tôŋ mera. ");
INSERT INTO kqp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Men, bargay ka bay na lêgeriɲ sa Jésu hen, lêgeriɲ yi wolé piniji ɗiba, yi naɲ ka bay na lêgeriɲ yiri hen né. ");
INSERT INTO kqp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Menba, ôbi tô Jésu wo ré guro sa tumô hen si bô kamɲê aɲ gel menba, ôbi bi bôri sara. ");
INSERT INTO kqp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wôsa kwôlo na liɲ bô magtubu to Emen a wo Jésu ré jê sé kamɲê hen na, kwôy saɲ wulê bi wo hen na, bay tôri na hôn ré tô tô. ");
INSERT INTO kqp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Menba, bay tô Jésu bay ka wôô hen bilji hô iɲ. ");
INSERT INTO kqp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Niɲba, Mari ɗebe nô kibi kamɲê sôm. Kiriɲa hende sôm ɗibiɲ iyôŋ menba, deŋge tôŋ ɲél bô kamɲê. ");
INSERT INTO kqp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Menba, hende gel *manê ka derômaraŋ a wôô ka tôbe bargay ka bôri môrji kiriɲ ka bay na uwôliɲ Jésu ya hen, kwo pôn si sari men, kwo pôn si cêbêri men. ");
INSERT INTO kqp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Menba, bay kôle iyôŋ ba: «Iyore, wô mi a meré sôm ba?» Menba, hende uwôlji sara iyôŋ ba: «Wôsa bay dô temay Kelma wuɲê aɲ en hôn kiriɲ ka bay uwôli ya hen né.» ");
INSERT INTO kqp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kiriɲa hende kôl hen iyôŋ menba, bare cêgere menba, gel Jésu ɗebe hen niɲba, hende hôn wo ré na Jésu ré. ");
INSERT INTO kqp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Menba, Jésu kôle iyôŋ ba: «Iyore wô mi a meré sôm ba? Mu woge na i ba?» Menba, hende kôl yaŋ ba, ré na ôbi gemé kini banê gurô bi wo hen menba, hende kôli iyôŋ ba: «Gawra, hena ré na jôbi a ré ayêri ôriɲ wolé ba, ju kôlen na erê ô ayêri.» ");
INSERT INTO kqp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Menba, Jésu uwôgere: «Mari», menba, hende bul aɲ uwôgeri: «*Raboni», naɲ kibi hébre bôri na ôbi geliɲ ɓiɲé are. ");
INSERT INTO kqp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Menba, Jésu kôle iyôŋ ba: «Heben né wôsa en ô ta ligi Iban a ré tô. Niɲba, ô mu ô uɲé yênên aɲ mu kôlji iyôŋ ba, ené erê ta ligi Iban a wo na Ibareŋge kenbay men, ligi Emen wuɲê a wo na Emen woŋge kenbay men hen.» ");
INSERT INTO kqp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Menba, Mari to Magdala ô kôliɲ bay tô Jésu wo teré gelo Kelma aɲ hende kôlji kwôlo ôbi ré kelare hen. ");
INSERT INTO kqp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Perare to demas hende to hen na, bay tôri daɲji mô bô ira aɲ legeji kermiɲ dô sarji a, wôsa bay hariɲ Jubɲê. Menba, Jésu so ɗebe derôrji a aɲ kôlji iyôŋ ba: «Bi bô jalê wo Emen baa naɲ ken.» ");
INSERT INTO kqp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kiriɲa ôbi kôl hen iyôŋ menba, ôbi gelji hôlmê iyare to kôbri men, kwa bôri a men. Kiriɲa bay tôri gili hen iyôŋ menba, yirji dôrji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Menba, Jésu hô kôlji iyôŋ ba: «Bi bô jalê baa ré ken. Mega wo Iban na joon hen na, nôbi kôba, en jéŋge men.» ");
INSERT INTO kqp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kiriɲa ôbi kôl hen iyôŋ kô niɲ menba, ôbi dô bul wo dami sarji a aɲ kôlji iyôŋ ba: «Eŋgéŋge Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓiɲé ka ka ɗé bôrŋge jalê sa têriɲ toji a hen na, Emen kôba, a ɗé bôri jalê sa têriɲ toji a men, ka ken ɗi bôrŋge jal têriɲ toji a ré hen na, Emen kôba, a ɗé bôri jalê sa têriɲ toji a ré men.» ");
INSERT INTO kqp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas ôbi tôri wo pôni perê ka môj kibi wôô wo bay uwôgeri Kerma hen ré naɲ kiriɲa Jésu ré siɲ sa megêri a hen. ");
INSERT INTO kqp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tô megêri ka baa hen kôli iyôŋ ba: «Nini gel Kelma.» Menba, ôbi kôlji iyôŋ ba: «Hena ené gel kôbri wo bay na di naɲ pôndé hen né men, hena ené dôbe kôben hôlmê iyare to kôbri a hen ré men, hena ené dôbe kôben kwa kabrêri ka bay na cubu naɲ dargaw hen né a men na, na bê bôn sara ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wulê marge cêgê menba, bay tô Jésu hô daɲji bô ira menba, Tomas naɲ ci niɲ. Kermiɲ ligiriɲ ta menba, Jésu so ɗebe derôrji a aɲ kôl iyôŋ ba: «Bi bô jalê baa ré ken.» ");
INSERT INTO kqp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Menba, ôbi kôliɲ Tomas iyôŋ ba: «Eraɲ naɲ kôbem nà aɲ ju hamiɲ hôlmê iyare to kôben a men, usoɲ naɲ kôm nà aɲ ju hamiɲ hôlmê iyare to kwa kabrên a hen a men, aɲ ju ɗi narê kwôlê wom baa aɲ ju bi bôm sara.» ");
INSERT INTO kqp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Menba, Tomas uwôli sara iyôŋ ba: «Kelma wuɲê, Emen wuɲê.» ");
INSERT INTO kqp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Menba, Jésu kôli iyôŋ ba: «Na wô gelé wo ju gelen hen aɲa jeré bi bôm sara hen. Niɲba, ɓiɲé ka gelen né aɲ bi bôrji san a hen na, yirji a dôrji.» ");
INSERT INTO kqp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jésu hô li aŋgaɲ giɲê ka gay gay kwône a tu bay tôri a niɲba, kwôliji kôliɲ bô magtubu a na ré. ");
INSERT INTO kqp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Niɲba, are bay ka hen liɲ bô magtubu a hen iyôŋ, bi kené bi bôrŋge sara mega wo Jésu ré na *Krist Kema Emen aɲ hena kené bi bôrŋge sari a ba, kené môriɲ tu geɲ sa kibri. ");
INSERT INTO kqp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cêgê menba, Jésu hô si sa bay tôri a kibi cér wo Tibériyad a. Geré sé wo ôbi siɲ sarji a bi a na. ");
INSERT INTO kqp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wulê wo pôni na, Simô Piyêr men, Tomas woɲ Kerma hen men, Nataniyêl wo Kana bô emê wo Galilé a naɲ kam Jébédé men, bay tô Jésu ka pôni wôô a men bay kêm daɲji kiriɲ pôn. ");
INSERT INTO kqp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simô Piyêr kôlji iyôŋ ba: «Na erê uré.» Menba, bay kôli iyôŋ ba: «Nibay kôba, niɲa erê naɲ ju men.» Menba, bay si ô aɲ ɗayji bô bato a ôrji uré. Yoyre hende to hen na, bay ɓu kuyê kani pôn nêŋ iyôŋ né kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tô kiriɲ pulôl menba, Jésu ɗebu kibi cér a niɲba, bay tôri hôn wo ré na ôbi ré. ");
INSERT INTO kqp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Menba, Jésu kôlji iyôŋ ba: «Kam manê, ken ɓu kuyê kani ré ba?» Menba, bay uwôli sara iyôŋ ba: «Nini ɓu ani ré kwôy.» ");
INSERT INTO kqp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Menba, ôbi kôlji iyôŋ ba: «Bêŋge bera si sa kôbi gusurô hen iyôŋ aɲ ka uɲé kuyê.» Bay uwôl bera menba, bay nêm wurére ta biɲ ré niɲ, wô kuyê ka mêy ka bay pera hen. ");
INSERT INTO kqp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Menba, ôbi tô Jésu wo Jésu geyri gaɲ hen kôliɲ Piyêr iyôŋ ba: «Na Kelma.» Menba, kiriɲa Simô Piyêr toy wo ré na Kelma hen iyôŋ menba, ôbi hô dôbe bargay ka ôbi ré hariɲ tô bôri uriɲ hen aɲ, neŋgere kuriɲ kam a. ");
INSERT INTO kqp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tô bay tô Jésu ka baa hen jubo bato wuroɲ kuyê ka wôn bera hen eraɲ guba cér a, wôsa bay ré na mêter arew naɲ guba cér. ");
INSERT INTO kqp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kiriɲa bay sa biɲ guba menba, bay gel deseri tare to kuyê jééɲ sara naɲ mapa yé kwa a menba, Jésu kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","«Eraɲge naɲ kuyê ka ken pera hen dê iyôŋ.» ");
INSERT INTO kqp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simô Piyêr ɗay bô bato a aɲ wuro bera to kuyê ka damné arew naɲ tôre bay kibi subu wôn bô ta hen tôŋ, bi wo kuyê wôn bera kêm hen kôba, hende yêgeriɲ ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Menba, Jésu kôlji iyôŋ ba: «Eraŋge ken sa ôm.» Niɲba, ôbi tôri wôni pôn iyôŋ kôba, nêm eŋgeréri iyôŋ ba: «Ju na i ba ré.» Wôsa bay hôn wo ré na Kelma niɲ. ");
INSERT INTO kqp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Menba, Jésu uso ɗa aɲ ay mapa aɲ biji men, hô pô kuyê biji a men. ");
INSERT INTO kqp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hen a ba, na têê subu tori wo Jésu siɲ sa bay tôri a kiriɲa ôbi jiɲ siɲ kamɲê hen. ");
INSERT INTO kqp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kiriɲa bay ôm are kô niɲ menba, Jésu eŋgeriɲ Simô Piyêr iyôŋ ba: «Simô kema Ja, ju geyen gôliɲ kamaŋ ka baa hen ba?» Menba, Simô Piyêr uwôli sara iyôŋ ba: «Ew Kelma, ju hôn wo ené geyem.» Menba, Jésu kôli iyôŋ ba: «Iyôŋ ba, ju abe kam gamgê kaɲê ben.» ");
INSERT INTO kqp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jésu hô eŋgereri wo têê wôô wori iyôŋ ba: «Simô kema Ja, ju geyen ba?» Menba, Piyêr uwôli sara iyôŋ ba: «Ew Kelma, ju hôn wo ené geyem.» Menba, Jésu kôli iyôŋ ba: «Iyôŋ ba, ju gem gamgê kaɲê ben.» ");
INSERT INTO kqp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jésu hô eŋgereri wo têê subi iyôŋ ba: «Simô kema Ja, ju geyen ba?» Menba, tu Piyêr li ɲa wô eŋgeré wo Jésu ré eŋgereri têê subu iyôŋ ba: «Ju geyen ba?» hen. Menba, ôbi uwôli sara iyôŋ ba: «Kelma, ju hôn are kêm men, ju hôn wo ené geyem a men.» Menba, Jésu kôli iyôŋ ba: «Iyôŋ ba, ju abe gamgê kaɲê ben. ");
INSERT INTO kqp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na tu kwôlê a ené kôlem hen: Kiriɲa na ju baɲ mana tô na, jôbi a na harê tô bôm wom naɲ kôm men, ju ô kiriɲ ka bôm jôbi a na geyé a men. Niɲba, kiriɲa já halê na, já perê kôm ta aɲ na kwôni wo ɗaŋgi a harem tô bôm aɲ a ayem ôriɲ kiriɲ ka bôm gey ré a hen.» ");
INSERT INTO kqp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ôbi kôl hen iyôŋ ɗiré geliɲ temare to Piyêr ré sa ma hen aɲ ré na temare to ré sa ulê hini emê sa Emen. Kiriɲa Jésu kôl hen iyôŋ kô niɲ menba, ôbi kôliɲ Piyêr iyôŋ ba: «Era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kiriɲa Piyêr bare cêgeri menba, ôbi gel ôbi tô Jésu wo Jésu geyri gaɲ hen era tôrji a. Na ôbi a na yé kabrê Jésu a kibi emê aɲ na eŋgereri iyôŋ ba: «Kelma, na i bi a ayê sam hen ba?» ");
INSERT INTO kqp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kiriɲa Piyêr gili menba, ôbi kôliɲ Jésu iyôŋ ba: «Kelma, a kwo na ba, na mi a sa sari a men ba?» ");
INSERT INTO kqp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Menba, Jésu kôli iyôŋ ba: «Hena ené gey bi ôbi ré mô geɲ kwôy wo ené buloɲ heraɲ ba, dôlem jôbi iyeŋ ba? Jôbi ju era tôn a.» ");
INSERT INTO kqp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sa kwôlê bi wo hen a na, bay ayê bôô kôl iyôŋ ba, ôbi tô Jésu bi wo hen ré ma ré. Niɲba, Jésu na kôliɲ Piyêr mega wo ôbi tôri bi wo hen ré ma ré ré, niɲba, Jésu na kôli na iyôŋ ba: «Hena ené gey bi ôbi ré ma ré kwôy wo na buloɲ heraɲ ba, dôlem jôbi iyeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na ôbi tô Jésu wo Jésu geyri gaɲ bi a derê kwôli are bay ka hen men, na ôbi a lê bô magtubu hende to na hen a men. Aɲ nini hôn wo kwôlê bi wo ôbi ré dô hen na, ré na tiri. ");
INSERT INTO kqp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jésu hô li aŋga ɗaŋgi kwône a. Aɲ hena bay ré gey ciré derê kwôliji pôn pôn kêm bô magtubu a ba, kiriɲ ka bay ré biɲ magtubu hende to hen ba, ré naɲê sa terare nà.");
INSERT INTO kqp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dami wuɲê Téwpil, bô magtubu tiɲê to tumô to na en li hen na, na en kôl kwôli aŋga Jésu na li men, kwôlo ôbi na geliɲ ɓiɲé a men. Kwôli are bay ka en kôlem kwôliji hen na, na kiriɲa ôbi na ayiɲ tô jé wori hen. ");
INSERT INTO kqp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Kwôy wulê wo Emen ayri hôriɲ derômaraŋ a. Pa dema Emen ré ayri hôriɲ derômaraŋ a tô na, cêgi temayri a na, na bay jé bay ka ôbi na tôrji hen a, ôbi ré si sarji a tumô têê kwône naɲ yiri na iyôŋ kwôy wulê tôre pôrbu aɲ gelji wo ré na ɗôbi a ré jê sé kamɲê hen men, kôlji kwôli *emê iyére to Emen a men. Ôbi na geliɲ bay jé ka ôbi na tôrji hen, tôô tori hende to hen naɲ néé wo Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wulê wo pôni ôbi mô ôm emê naɲ ci, menba, ôbi kôlji iyôŋ ba: «Merêŋge Jérusalêm a nà kwôy ken gem aŋga Iban na genge ɗiré béŋge aɲ na en kelêŋge kwôliji hen, ɗiba, ken ô aɲê ré tô. ");
INSERT INTO kqp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wôsa Ja ba, na liɲ ɓiɲé batêm na naɲ kam niɲba, era baa tumô a hen na, na naɲ Tunu toɲ hendi bô bôrê a Emen ré lêŋge kenbay batêm niɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kiriɲa bay tô Jésu môrji naɲ ɗi baa ya tô menba, bay eŋgereri iyôŋ ba: «Kelma, na wulê bi wo hen a jeré hô biɲ kam *Israyêl kenare toji hôriɲ hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Menba, ôbi uwôlji sara kôl iyôŋ ba: «Kwôlo gengiɲ sa wulê naɲ tayi kwôlo ken eŋgeren hen na, dôlêŋge kenbay ré, niɲba, na Iban a gengé naɲ bô geyé wori. ");
INSERT INTO kqp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Niɲba, kenbay ba, ka sa uɲé néé kiriɲa Tunu toɲ hendi bô bôrê a herbo sarŋge a dema kené yé bay derê kwôlen Jérusalêm a men, Judé a men, Samari men, gôriɲ kiriɲ kêm sa terare a nà a men tô.» ");
INSERT INTO kqp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kiriɲa ôbi kôlji hen iyôŋ kô niɲ menba, Emen biri ɗay tirji a hen bô kiriɲ ka geri a ô derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kiriɲa bay ɗebu bô derômaraŋ ɗéɲ kiriɲ ka Jésu ôriɲ ya hen baa ya tô, menba, gawrê wôô ka tôbe bargay ka bôri soji ɗibiji kwarji a. ");
INSERT INTO kqp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aɲ kôlji iyôŋ ba: «Ken gawrê ka Galilé, wô mi a kené ɗebe bô derômaraŋ hen iyôŋ ba? Jésu bi wo Emen biri ɗay ô derômaraŋ a aɲ ken ɗebu bô hen na, herari kôba, a yé môɲ ôbi wo ken gili ôriɲ derômaraŋ a hen iyôŋ têj têj.» ");
INSERT INTO kqp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bay tô Jésu hena sa Keram wo Olibiyé heraji Jérusalêm a, hena ya erê Jérusalêm a na, na kilomêter pôn. ");
INSERT INTO kqp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kiriɲa bay hena sa keram heraji uwo menba, bay ɗay bô iyére to tayi to bay dayriɲ ya gaŋ gaŋ hen. Kamaŋ ka ɗay ô bô iyére hende to hen a na: Piyêr, Ja, *Jak, André, Pilip, Tomas, Bartélémi, Matiyé, Jak kema Alpé, Simô woɲ kema iyére hen naɲ Jud woɲ kema Jak hen. ");
INSERT INTO kqp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bay kôliɲ kaɲniji aɲ daɲji ta ta wô uwôlê Emen naɲ bôô pôn aɲ yébé ka pôni men, si Mari toɲ yoo Jésu men, yênêri a men naɲ ci ya men. ");
INSERT INTO kqp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wulê sem cêgê menba, bay ayê bôô arew naɲ tôre wôô daɲji menba, Piyêr hena ɗebu ta perêrji a wô kelê kwôlê. ");
INSERT INTO kqp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ôbi kôl iyôŋ ba: «Yênên, kwôlo magtubu to Emen na kôl aɲ Tini na yêge sari ca tumô yeŋ biɲ Dabid aɲ ôbi na kôl kwôli Judas wo ré sa derê tumô bay ɓeré Jésu hen na, ariri ré liɲ niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas Iskariyôt bi wo hen na, na na kwoni aɲ na uwoɲ jé môɲ kwo nini li hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Na naɲ lari kwôbe bi wo ôbi na uwôɲ hen a ôbi na ré keliɲ yagê menba, na sa kuriɲ aɲ bôri waɲ aɲ kworɲéri ɓegiɲ kêm aɲ. ");
INSERT INTO kqp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓiɲé ka Jérusalêm kêm toy kwôli aŋga sa sa Juda a hen. Na ôbi á, bay ré uwôge yagê bi wo Hakeldama hen, bôri na «yagê woɲ kwôbe.») ");
INSERT INTO kqp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Ôbi a, bay ré li bô magtubu toɲ kurôŋ kôl iyôŋ ba: ‹Bi bô iyére tori yi seŋge men, bi kwôni mô bô ré men.› Men, hô liɲ kôl iyôŋ ba: ‹Bi kwôni wo ɗaŋgi ré gaseri kini jé wori a a men.› ");
INSERT INTO kqp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Bi kwôni wo ɗaŋgi era sa jôgiɲ naɲ na sa derê kwôli jê sé wo Kelma Jésu. Bi na kwôni wo na ô naɲ na wulê kêm wo Kelma Jésu na ô naɲ na naɲ kiriɲ kiriɲ hen, ayiɲ tôri sa batêm to Ja na liri a kwôy wulê wo Emen ayri perêrna ôriɲ derômaraŋ a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Menba, bay tô ɓiɲé wôô ɗi tumôrji a bay a na si Josêp wo ɓiɲé uwôgeri Barsabas men, Justus men hen men, Matiyas a men. ");
INSERT INTO kqp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Menba, bay ayê bôô kêm uwôl Emen kôl iyôŋ ba: «Kelma, jôbi wo ju hôn bô gawrê pôn pôn kêm hen na, geléni kwôni wo ju dôri perê kamaŋ bay ka wôô hen, ");
INSERT INTO kqp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","bi ré yi *ôbi jé hôlmê Judas wo na ay jé wori ɗéɲ aɲ ôriɲ kiriɲ kaɲ mênê ka na yi gengiɲ sari hen.» ");
INSERT INTO kqp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Menba, bay pool hiniji ta aɲ bay ay pôn perê menba, na Matiyas a bay ré ayri jôgiɲ naɲ bay jé ka môj kibi pôn hen. ");
INSERT INTO kqp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kiriɲa sa lê geserê *Pantékwôt nêm menba, bay tô Jésu daɲji kiriɲ pôn. ");
INSERT INTO kqp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kiriɲ bay ka hen na, néé ani ema si ta môɲ kal wo dami iyôŋ, aɲ so wôn bô iyére to bay môriɲ ya hen ɓerêj ta. ");
INSERT INTO kqp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Menba, ani geliɲ môɲ kôli tare iyôŋ aɲ useriɲ mô sarji a pôn pôn kêm. ");
INSERT INTO kqp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Menba, kiriɲ bay ka hen na, Tunu toɲ hendi bô bôrê wôn bôrji aɲ li aɲ i i kôba iyêl kibi kwôlê wo ɗaŋgi wo Tunu hende to hen a biri a ré iyêl. ");
INSERT INTO kqp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wulê bi wo hen na, Jubɲê kaɲ bay lê tôô Emen ka hena sa iyére to gay gay to sa terare a nà môrji Jérusalêm a ya men. ");
INSERT INTO kqp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kiriɲa bay toy tôô bay tô Jésu ka iyêl hen iyôŋ menba, ɓiɲé dayriɲ naɲ kwônêrji aɲ tiniji ge kay, wôsa i i kôba toy kwôlê wo bay ayê bôô kôl hen naɲ kibi kwôlê wori, kwôlê wori. ");
INSERT INTO kqp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kiriɲa bay toy hen iyôŋ menba, tiniji ge kay yôd aɲ bay kôl iyôŋ ba: «Ɓiɲé bay ka kêm ka iyêl hen, na ka Galilé ré ba? ");
INSERT INTO kqp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Menba, na iyeŋ a i i ba, ré toy kibi kwôlê wori kwôlê wori kibriji a hen iyôŋ ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wôsa nabay kêm ka nana ɗebe nà ná, nana ka tôrna gay gay, ka hena Partiya a men, Médiya a men, Elam men, Mésopotami a men, Judé a men, Kapadôs a men, Pônt a men, Asi a men, ");
INSERT INTO kqp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Priji a men, Pampili a men, Ejipt a men, bô emê wo Libi to ɗa naɲ Sirên hen men, ka na Rômêɲê ka mô nà a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kamaŋ ka Krêt a naɲ Arabɲê kôba, ya naɲ naa men, perêrna hen kôba, Jubɲê kaɲ ɗéɲ ɗéɲ ya men, ka ay bôrji kôba, ya men, menba, na iyeŋ a nana toy kwôlo bay kôl gengiɲ sa aŋga dôri ka Emen li hen naɲ kibi kwôlê wona, kwôlê wona ɗi ba?» ");
INSERT INTO kqp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bay kêm tiniji ge kay aɲ bay hôn kwôlê woɲ kelê ré, menba, bay ɲamniɲ perêrji a kôl iyôŋ ba: «Na mi a geliɲ hen iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Menba, ka pôni ayrêji kôl iyôŋ ba: «Na care a kwoyréji hen.» ");
INSERT INTO kqp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyêr ôbi tô Jésu perê ka môj kibi pôn ka baa hen, hena ɗebe ta aɲ uwôlji sara naɲ tôri to dami kaŋ a ta kôl iyôŋ ba: «Kenbay yênêrni Jubɲê naɲ kenbay kêm ka ken mô Jérusalêm a hen, are bay ka yi hen na, dôbêŋge marŋge dô ken toyiɲ kwôlo na kelê hen aɲ bi ken hôn tôrji dô. ");
INSERT INTO kqp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mega wo ɓiɲé ka pôni perêrŋge a kôl iyôŋ ba: ‹Ɓiɲé bay ka hen ré kwoy na kwoyé hen na›, bay kwoy na kwoyé ré, wôsa tare baa jal tô. ");
INSERT INTO kqp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Niɲba, tiri wori ba, na kwôlo *ôbi kibi Emen Jowêl na kôl hen a ariri ré yi kemnêŋ hen. Ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Nôbi Emen, en kelêŋge kiriɲa sa terare baa ɗa wo ta kerê niɲ na, geléŋge aŋga na lê a na: Na bé Tunun erê sa gawrê kêm. Aɲ kamneŋge kaɲ imɲê naɲ kaɲ yébé a yé bay keben men, kam manê kaŋge a henêji tu kwôlê wo Emen bô pelal wo a jôrji a hen men, Surɲê kaŋge kôba, a henêji tu kwôlê wo Emen bô wônê woji a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na tiri wulê bi wo hen na, na bê Tunun sa manê kaɲê kaɲ imɲê naɲ kaɲ yébé a, aɲ bay a yé bay keben. ");
INSERT INTO kqp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Men, na lê aŋgaɲ giɲê derômaraŋ a men, aŋga ɗê kiriɲ sa terare a nà, kwôbe naɲ tare naɲ gusô tare a men a so yé ya. ");
INSERT INTO kqp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tare a biliɲ hendé culum men, geserê kôba, a biliɲ kwôbe a men, cêgi are bay ka hen dema Wulê woɲ hini emê naɲ kwo dami wo Kelma wona ré sa tô. ");
INSERT INTO kqp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wulê bi wo hen na, i i wo bi bôri sa Kelma Emen a ba, a uɲé gelê.› » ");
INSERT INTO kqp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Menba, Piyêr kôl iyôŋ ba: «Kenbay ɓiɲé ka *Israyêl, dôbêŋge marŋge dô ken toyiɲ kwôlo na kelêŋge hen. Jésu wo Najarêt na gawra wo Emen geléŋge néé wori naɲ aŋgaɲ giɲê naɲ kaɲ gelé ka ɗê sa kiriɲ ka ôbi li perêrŋge a mega bi wo ken geliɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Gawra bi wo hen naɲ bô geyé men, naɲ gengé wo Emen na genge a men na, bay ɓiri béŋge aɲ ken diri naɲ geré wo bay henê Emen né, aɲ bay ɓééri sa gurô tagelê. ");
INSERT INTO kqp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Niɲba, Emen biri ji si kamɲê aɲ dôri kibi gusiɲ to temare a, wôsa néé wo temare nêm ɓeréri tôŋ né. ");
INSERT INTO kqp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ôbi a, kelma Dabid na ré kôliɲ kwôli kôl iyôŋ ba: ‹En gel Kelma tumôn a kwôy kwôy, wôsa ôbi ɗebe sa kôben woɲ gusurô bi ené kuriɲ né ");
INSERT INTO kqp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","men, yen dôren men, en kebe kurôŋ naɲ yi derê wôsa kurôŋgi yen a sa merê ta gengiɲ sa aŋga Emen a sa lê ben. ");
INSERT INTO kqp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wôsa já ɗén aɲ perê temay ɓiɲé a ré, men, já ɗé mana wom wo yi naɲ jeŋgêri hen, uyê ré men, ");
INSERT INTO kqp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","na ju gelen geré gelê men, já ben yi derê kiriɲa na ɗebiɲ tumôm a a men.› » ");
INSERT INTO kqp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Menba, Piyêr kôl iyôŋ ba: «Yênên, ɗéŋge na kelêŋge kwôlo gengiɲ sa môyrena Dabid, ôbi ma, aɲ bay emni nà aɲ sa kamɲêri yi kemnêŋ iyére tona na. ");
INSERT INTO kqp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Niɲba, ôbi nà ná ôbi kibi Emen men, ôbi na hôn aŋga Emen na genge ɗiré biri hen a men. Emen na ay tôri biri mega wo kuŋgari woɲ bôri a ré sa merê sa gagay kenare a. ");
INSERT INTO kqp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ôbi na gel tumô aŋga Emen ré sa lê hen, na ôbi a, ôbi na ré kôl kwôli jê sé wo *Krist, kwo Emen dôri hen perê ɓiɲé ka may a aɲ ôbi na kôl iyôŋ ba: ‹Emen na ɗiri aɲ perê temay ɓiɲé ré men, kurôŋgi yiri na uyê kamɲê ré a men.› ");
INSERT INTO kqp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jésu bi wo hen na, Emen biri ji si kamɲê, nibay kêm nini gel naɲ tirni men, nini dô kwôli a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Men, Emen hôriɲ naɲ ɗi derômaraŋ a aɲ mô sa kôbri woɲ gusurô a. Haw hen mega wo Emen na ayiɲ tôri hen iyôŋ na, ôbi biri Tunu toɲ hendi bô bôrê aɲ ôbi wusérére sarni a mega wo ken toy men, gel men, hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kelma Dabid wo na ɗay derômaraŋ a ré hen, kôba, na kôl iyôŋ ba: ‹Kelma Emen na kôliɲ Kelmaren iyôŋ ba: mô sa kôben woɲ gusurô a, ");
INSERT INTO kqp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kwôy wo na biɲ bay barem a yé aŋgaɲ sêlê têm.› ");
INSERT INTO kqp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aɲ bi ɓiɲé ka sa iyé Israyêl a kêm hôn dô mega wo Jésu bi wo ken ɓééri hen na, ré na ôbi a Emen ré biri yi Kelma men, Krist, kwo Emen dôri hen men hen.» ");
INSERT INTO kqp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kiriɲa ɓiɲé toy kwôlê bi wo Piyêr kôl hen iyôŋ menba, bay hôn aŋga ca lê ré niɲ, menba, bay eŋgeriɲ si Piyêr naɲ bay jé ka ɗaŋgi iyôŋ ba: «Niɲa lê iyeŋ niɲ ba, yênêrni?» ");
INSERT INTO kqp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyêr uwôlji sara iyôŋ ba: «Ɗéŋge jé lêreŋge wo cay hen baa aɲ ken li batêm naɲ hini Jésu Krist aɲ bi Emen ɗiɲ bôri jal sa têriɲ toŋge a men ôbi a béŋge Tunu toɲ hendi bô bôrê a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wôsa Tunu toɲ hendi bô bôrê to Emen na genge hen na, gengiɲ na sarŋge kenbay naɲ kamneŋge men, gengiɲ sa ka sa terare to kelaŋgi a ka kwôni ka Kelma wona Emen a uwôgaji hen a men.» ");
INSERT INTO kqp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyêr hô dôrji kwôlo ɗaŋgi gay gay wô bôyiɲji men, dôbiɲji ibiyare bôrji a aɲ kôlji iyôŋ ba: «Bêŋge bôrŋge sa gelê wo Jésu a ɗiba, ken uwôɲ aŋga bay têriɲ ka haw hen a uɲé hen né.» ");
INSERT INTO kqp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɓiɲé ka bi bôrji sa kwôlo Piyêr kôl hen na, bay liji batêm, aɲ wulê bi wo hen na, bay uwôɲ ɓiɲé dubu subu bi sarji a a. ");
INSERT INTO kqp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bay ayê bôô ay yirji biɲ bay jé ré gelji are men, bay biɲ perêrji a men, ômji emê pôn men, uwôlji Emen pôn a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɓiɲé kêm tiniji ge kay men, harê liji a men wôsa aŋgaɲ giɲê ka gay gay ka Emen biɲ bay jé li hen. ");
INSERT INTO kqp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓiɲé kêm ka bi bôrji sa Jésu a hen na, biɲji perêrji a men, aŋgaji kôba bay day kiniji pôn a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta ta bay keléɲ ari uɲérji aɲ ɗi larirji céɲji naɲ doy aŋga kwôni ôriɲ ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bay daɲ sa pôn pôn derô haba wo *iyéy Emen a naɲ bôô pôn men, ômji emê iyé kwo hen a, kwo hen a men, ômji naɲ yi derê men, bay uwôyrê yirji ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bay heram Emen men, ɓiɲé kêm kôba, geyji a men. Aɲ sa pôn pôn Kelma bi ɓiɲé ka ôbi gôliɲ naɲ ci hen sarji a sarji a. ");
INSERT INTO kqp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sa to pôni a si Piyêr naɲ Ja ôrji *iyéy Emen a naɲ tare to yébé ayiɲ sa tôɲne hen, wô uwôlê Emen. ");
INSERT INTO kqp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kibi geré wo bay uwôgeri «kibi geré wo li kalmare» hen na, gawra wo pôni wo meray bô yori a yeŋ bay ayari ca sa ɗé kibi geré bi wo hen a. Sa pôn pôn bay ayri sa ɗi kibi geré bi wo hen a wô uwôliɲ ɓiɲé ka ô men, hera men, derô haba wo iyéy Emen a hen gursu. ");
INSERT INTO kqp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kiriɲa ôbi gel si Piyêr naɲ Ja wo ca sé bô iyéy Emen a menba, ôbi masiji bi bay ré biri ani. ");
INSERT INTO kqp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Menba, si Piyêr naɲ Ja bôri ɗéɲ aɲ Piyêr kôli iyôŋ ba: «Berêni ju gel!» ");
INSERT INTO kqp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ôbi bôrji aɲ kôl yaŋ ba, bay ré ca biri na ani. ");
INSERT INTO kqp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Niɲba, Piyêr kôli iyôŋ ba: «En ôriɲ naɲ gursu ré, niɲba, aŋga en ôriɲ kôben a hen na, na ben: naɲ néé wo Jésu Krist wo Najarêt, hena ju ô ta!» ");
INSERT INTO kqp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Menba, ôbi ɓu kôbri woɲ gusurô aɲ biri hena ta. Kiriɲ bay ka hen na, têri naɲ tô gworɲéri iyêderê hôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ôbi neŋgere ɗebu ta naɲ têri aɲ ô ta. Aɲ ô naɲ ci derô haba wo iyéy Emen neŋréré men, heramiɲ Emen men. ");
INSERT INTO kqp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aɲ ɓiɲé kêm gili wo ô ta men, heram Emen men. ");
INSERT INTO kqp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bay gili hôn menba, bay kôl iyôŋ ba: «Ôbi a na miirê kibi geré wo bay uwôgeri ‹kibi geré wo li kalmare› hen uwôdelê are na ré ba?» Aɲ tiniji ge kay wôsa aŋga ré sa sari a hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mega wo gawra bi wo hen ɗi tô si Piyêr naɲ Ja bul ré hen iyôŋ na, tini ɓiɲé kêm ge kay aɲ bay era sôm sôm si ligirji a tô pal wo bay uwôgeri kwo Salomôn hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kiriɲa Piyêr gel hen iyôŋ menba, ôbi kôlji iyôŋ ba: «Kam *Israyêl, wô mi a tunuŋge ré ge kay sa aŋga li are hen ba? Wô mi a kené berêni mega ré na néé woni ley, derê woni tu Emen ley, a niné berariɲ gawra bi wo hen ba? ");
INSERT INTO kqp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Emen wo *Abraham wo Isak naɲ kwo Jakwôb, Emen wo balêrna a ulê hini emê sa mana wori Jésu wo na ken ayri bi bay na diri aɲ kiriɲa *Pilat na gey ulêri ta menba, ");
INSERT INTO kqp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","na ken kaɲ kwo yi naɲ jeŋgêri men, kwoɲ dôri men hen, aɲ na ôbi deré temare a na kené gey bi bay ré uwôli ta ɗi hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Aɲ Kelma ôbi tô gelê, a na kené bi bay diri ɗi. Niɲba, Emen biri ji si kamɲê perê ɓiɲé ka ma a aɲ nini gel naɲ tirni. ");
INSERT INTO kqp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aɲ na wô wo nini bi bôrni sa Jésu a aɲa néé wo hini bi wo hen ré biɲ gawra bi wo ken gili aɲ hôni hen néé a ré ɗebiɲ ta hen. Na tiri na sa kibi bê bôô sa Jésu a woɲ tiri hen, aɲa gawra bi wo hen ré berariɲ yôd turŋge a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Iyôŋ ba, yênên, en hôn wo ré na henêri ré, aɲa kenbay naɲ kilmérŋge na kené liɲ are bay ka hen hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Emen ba, na kôl ca tumô naɲ tô bay kibri kêm wo *Mési wo ôbi na genge ɗiré joɲ hen, ré geliɲ gusiɲ, aɲ na ôbi a yé hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Beléŋge hal woŋge aɲ ken hera uɲé Emen, aɲ bi ôbi mô têriɲ toŋge aɲ. ");
INSERT INTO kqp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Menba, Kelma a béŋge wulê woɲ derê bul kiriɲa ôbi a joɲ naɲ *Krist Jésu wo ôbi na dôri ca tumô gengiɲ sarŋge hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pa dema wulê bi wo hen ré sa tô na, Jésu Krist a merê derômaraŋ a kwôy wo derômaraŋ naɲ sa terare a hô ɲaniɲ naɲ gerérji mega wo Emen na kôl kwôli ca tumô, naɲ tôô bay kibri ka yi naɲ jeŋgêrji hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ôbi a *Moyis na ré kôl iyôŋ ba: ‹Kelma woŋge Emen a derê gawra pôn perêrŋge a hen, liɲ ôbi kibri wo a yé môɲ nôbi iyôŋ. Ka toyé kwôlo kêm wo ôbi a kelêŋge hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kwôni wo kaɲ toyé kwôlê kibri a ba, bay a dagêri perê ɓiɲé ka Emen aɲ, bay a diri.› ");
INSERT INTO kqp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bay kibi Emen kêm ayiɲ tôri sa Samiyêl a kwôy saɲ sa bay jebé tôri a na, kôlji kwôli wulê bi wo nana mô bô a haw hen. ");
INSERT INTO kqp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aŋga Emen na genge naɲ tôô bay kibri hen na, na wô sarŋge kenbay. Iyôŋ ba, biɲare to Emen na biɲ naɲ môɲêrŋge hen na, na yi wô sarŋge men, ôbi na kôliɲ Abraham iyôŋ ba: ‹Na terê keben sa tô môɲ wo ɓiɲé kêm ka sa terare a nà wô sa kibi kwôŋgêm.› ");
INSERT INTO kqp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Na wô sarŋge kenbay tumô, aɲa Emen né dô mana wori jéri wô terê kibri sarŋge a men, wô lê bi kené bul hal woŋge a men hen.» ");
INSERT INTO kqp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kiriɲa si Piyêr naɲ Ja dôriɲ ɓiɲé kwôlê baa ya tô menba, bay bê kwôbe naɲ dami wo bay gemé *iyéy Emen naɲ *Sadusiɲêɲê soji. ");
INSERT INTO kqp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bay li hen iyôŋ wôsa bôrji tarji wô gelé wo Piyêr naɲ Ja geliɲ ɓiɲé are men, kwôli jê sé wo Jésu ji si kamɲê perê ɓiɲé ka ma a hen a men. Aɲ gel wo ɓiɲé kôba, ré jê sé kamɲê hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mega, kiriɲ kô niɲ hen iyôŋ na, bay pôrji biji daŋgay a gemiɲ kiriɲ ka wôli. ");
INSERT INTO kqp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Perê ɓiɲé bay ka toy kwôlo si Piyêr naɲ Ja hen na, kwône ay bôrji aɲ bay ayê bôô kêm nêm imɲê dubu bay iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kiriɲa kiriɲ wôl menba, bay sa Jubɲê naɲ surɲê naɲ *bay derê tô tôô to Emen daɲji Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kiriɲ bay ka hen na, Aan *dami wo damné kaɲ bay bê kwôbe men, Kayib men, Ja men, Alêksander naɲ balê dami wo damné kaɲ bay bê kwôbe kêm kôba, môrji ya. ");
INSERT INTO kqp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bay bi bay eraɲ naɲ si Piyêr naɲ Ja sa ɗibiji ta tumôrji a, aɲ bay eŋgeriji kwôlê iyôŋ ba: «Aŋga ken li hen na, ken li na iyeŋ iyeŋ pôn ba? Men, na naɲ néé wo i men, hini i men, aɲa kené liɲ are bay ka hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tunu toɲ hendi bô bôrê wôn bô Piyêr aɲ ôbi kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Bay sa ɓiɲé naɲ surɲê, kemnêŋ ken eŋgeréni wô derê wo nini li naɲ ôbi merayê hen men, niné li iyeŋ a ôbi ré berare hen ba men. ");
INSERT INTO kqp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kenbay men, ɓiɲé ka *Israyêl kêm toyéŋge dô, na naɲ hini Jésu Krist wo Najarêt wo ken ɓééri aɲ Emen biri ji si kamɲê perê ɓiɲé ka ma a hen, na wô sari aɲa gawra wo ɗebu tumôrŋge a hen ré berariɲ hen. ");
INSERT INTO kqp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na ôbi, a magtubu to Emen ré kôl gengiɲ sari kôl iyôŋ ba: ‹Keram wo kenbay bay ɗé iyére ken kaɲ hen, ôbi a hô yé kwoɲ ɗé tô iyére hende to hen hen.› ");
INSERT INTO kqp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Na ligiri ôbi a pôn nêŋ a kené uɲé kini gelê ɗiba, kini gelê wo ɗaŋgi naɲ, wôsa sa terare a nà kêm na, Emen na bi hini kwôni wo ɗaŋgi wo ré gôliɲ naɲ ɓiɲé ba, naɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kiriɲa bay gel wo si Piyêr naɲ Ja iyêl naɲ ibiyare hen iyôŋ menba, tiniji ge kay wô wo bay ré na ɓiɲé ka beray mera ka ré dôyrê are gaɲ né a men menba, bay hôn wo bay ré na bay erê naɲ Jésu. ");
INSERT INTO kqp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Niɲba, kiriɲa bay gel gawra bi wo berare hen ɗebu kwarji a menba, bay hôn kwôlê woɲ kelê ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Menba, bay biji bay séɲ kini daɲare to *Sanédrên a aɲ bay iyêliɲji perêrji a. ");
INSERT INTO kqp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bay kôl iyôŋ ba: «Na liɲ ɓiɲé bay ka hen na mi ba? Wôsa bay li giɲê wo dami tu ɓiɲé ka Jérusalêm a gel kêm ɗiba, na nêmê narê biɲ né. ");
INSERT INTO kqp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Niɲba, bi kwôli giɲê bi wo hen ré ôm erê tumô tumô ré na, na karêŋgeji gwom bi bay ré dôriɲ kwôni kwôlê wôni naɲ hini Jésu ré niɲ pa pa.» ");
INSERT INTO kqp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bay hô uwôgaji heraɲ aɲ kôlji iyôŋ ba: «Nini jô bi kené iyêl men, kené geliɲ kwôni ani a men naɲ hini Jésu.» ");
INSERT INTO kqp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Menba, si Piyêr naɲ Ja uwôlji sara iyôŋ ba: «Kenbay ken erem ken gel, na ba, toyé kwôlê kebreŋge a na lê aŋgaɲ derôre laba, biɲ Emen kwôlê a na lê aŋgaɲ derôre ɗi ba? ");
INSERT INTO kqp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwoni nibay ba, aŋga nini gel naɲ tirni men, nini toy naɲ marni a men hen na, niɲa wômê kwôliji tôŋ né.» ");
INSERT INTO kqp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bay hô karêji gwom damaŋ a, aɲ biji ta wôsa bay uwôɲ kwôlê wôni wo nêm perêji ré. Wôsa ɓiɲé kêm ay kibi Emen wô aŋga li are hen. ");
INSERT INTO kqp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gawra bi wo berare naɲ giɲê hen na, elêri ɗê tôre pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kiriɲa bay biji ta menba, si Piyêr naɲ Ja hôrji uɲé megêrji bay ayê bôô aɲ dôrji kwôlo kêm wo damné kaɲ bay bê kwôbe naɲ surɲê kelaji hen. ");
INSERT INTO kqp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kiriɲa bay toy kwôlo si Piyêr naɲ Ja dôrji hen iyôŋ menba, bay bi kibriji pôn aɲ uwôl Emen kôl iyôŋ ba: «Kelma, na jôbi a ɗé derômaraŋ naɲ sa terare men, cér naɲ aŋga kêm ka yi ya hen, ");
INSERT INTO kqp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","na jôbi a bé naɲ geré wo Tunu toɲ hendi bô bôrê aɲa ré bi kwôlê bi wo hen kibi mana wom Dabid wo na môyrini hen, aɲ ôbi na kôl iyôŋ ba: ‹Wô mi a ɓiɲé ka sa terare a nà ré karê maɲê hen iyôŋ ba? Men, wô mi a ɓiɲé ré lêrê aŋgaɲ ɗéɲ iyôŋ bay ka hen ba? ");
INSERT INTO kqp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kilmé ka sa terare a na ɲan yirji men, ɓiɲé kêm ka ôriɲ naɲ néé biɲ tôrji wô liɲ kumbul naɲ Kelma Emen men, naɲ kwo ôbi dôri hen a men.› ");
INSERT INTO kqp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wôsa na hen iyôŋ a, si *Hérôd naɲ Pos *Pilat ré daɲji sa iyére hende to nà naɲ ɓiɲé ka sa terare a nà a men, ɓiɲé ka Israyêl a a men wô lê kumbul naɲ Jésu mana wom wo ju dôri ɗiri yi gay hen. ");
INSERT INTO kqp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na hen iyôŋ a, bay ré liɲ are kêm ka na ju genge ca tumô naɲ néé wom hen men, naɲ bô geyé wom a men hen.» ");
INSERT INTO kqp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","«Haw hen na, Kelma dôbe mam ju toyiɲ gwom to bay karêni hen, aɲ ju biɲ manê kam ré kôl kwôlê wom naɲ ibiyare. ");
INSERT INTO kqp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jé kôm aɲ bi berarê ɓiɲé men, giɲê naɲ aŋgaɲ gelé ka gay gay liɲ naɲ hini mana wom Jésu wo yi naɲ jeŋgêri hen.» ");
INSERT INTO kqp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kiriɲa bay uwôl Emen hen iyôŋ kô niɲ menba, terare yebagiɲ kiriɲ bay ka bay môriɲ ya hen, aɲ Tunu toɲ hendi bô bôrê wiinê bôrji aɲ bay dô kwôlo Emen naɲ ibiyare. ");
INSERT INTO kqp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɓiɲé kêm ka ay bôrji hen na, bôrji naɲ ermé woji na pôn men, kwôni wo kôl ari uɲéri a ré nà iyôŋ ba, naɲ men, bay kêm day ari uɲérji na pôn. ");
INSERT INTO kqp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bay jé dô kwôli jê sé wo Kelma Jésu kamɲê naɲ néé wo dami aɲ terê kibi wo Emen baa naɲ ci kêm. ");
INSERT INTO kqp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kwôni pôn iyôŋ perêrji a wo na ôbi nimré ba, naɲ, wôsa ka ôriɲ naɲ kiriɲ men, iyére men ley na, bay keléɲ aɲ eraɲ naɲ lari are bay ka bay keléɲ hen. ");
INSERT INTO kqp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Aɲ sa biɲ bay jé. Aɲ i i ba, bay biri gengiɲ sa doy aŋga ôbi ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Menba, Josêp wo bay jé uwôgeri Barnabas (hini Barnabas bi wo hen na, bôri na «ôbi dôbê ibiyare bô kiriɲ a») ôriɲ naɲ yagê wori ya. Ôbi na tô môɲ wo *Lébit wo yêɲ Sipre a. ");
INSERT INTO kqp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ôbi keléɲ yagê wori bi wo hen, aɲ eraɲ naɲ lariri sa biɲ bay jé. ");
INSERT INTO kqp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Niɲba, gawra wo pôni bay uwôgeri Ananiyas bay naɲ tamni Sapira. Bay keléɲ yagê woji. ");
INSERT INTO kqp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Menba, ôbi dera kwa lari na dê ɗo tôŋ aɲ tamni hôn men aɲ eraɲ naɲ tôri wo baa hen sa biɲ bay jé. ");
INSERT INTO kqp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Menba, Piyêr kôli iyôŋ ba: «Ananiyas, wô mi a Sidan ré ô bôm a aɲ ju kôliɲ Tunu toɲ hendi bô bôrê kwôlê woɲ benare hen iyôŋ ba? Wôsa ju dera kwa lari yagê bi wo hen dê ɗo tôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yagê bi na kwom ré ba? Hena na jeré gey kôba, na já ɗé keléri aɲ baa ré ba? A hena na jeré keléɲ kôba, lariri na na kwom ré ba? Wô mi a ermé kwôlo hen iyôŋ ré yi bôm a ba? Na gawrê a jeré liji benare hen né, niɲba, na Emen.» ");
INSERT INTO kqp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kiriɲa Ananiyas toy kwôlê bi wo hen iyôŋ menba, ôbi kuriɲ aɲ ma. Ɓiɲé kêm ka toy kwôlê bi wo hen na, tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kam manê sa ay temayri ô haarê aɲ ôriɲ ô emé. ");
INSERT INTO kqp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tare subu cêgê menba, tamni Sapira ô ira tô si Piyêr a. Aŋga sa sa kurôre a hen na, hende hôn né kwôy tô. ");
INSERT INTO kqp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Menba, Piyêr eŋgerere iyôŋ ba: «Na lari yagê kêm wo ken keléɲ bi ré ba?» Menba, hende uwôli sara iyôŋ ba: «Ew, na lariri bi kêm.» ");
INSERT INTO kqp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyêr hô kôle iyôŋ ba: «Ken li iyeŋ a kené biɲ kebreŋge wô sébé Tini Kelma hen iyôŋ ba? Toy tê ka uwo emo kurôrê hen ema kibi geré hen ya, bay a ôriɲ naɲ mu men.» ");
INSERT INTO kqp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kiriɲ bay ka hen menba, hende kuriɲ aɲ ma tumô Piyêr a. Kiriɲa manê bay ka hen soji ira menba, bay uwôɲ temayre aɲ ay ôriɲ emé kwa kurôre a. ");
INSERT INTO kqp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kiriɲ bay ka hen na, bay ayê bôô kêm naɲ ɓiɲé kêm ka toy kwôlê bi wo hen na, harê wo dami liji. ");
INSERT INTO kqp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bay jé li aŋgaɲ gelé naɲ kaɲ giɲê kwône tu ɓiɲé a. Bay ayê bôô kêm kôliɲ kaɲniji aɲ daɲji tô pal wo Salomôn a. ");
INSERT INTO kqp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kwôni wo ɗaŋgi wo gey daɲ naɲ ci ba, naɲ. Men né, ɓiɲé kêm dô kwôliji wo dôri ta men. ");
INSERT INTO kqp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aɲ ɓiɲé naɲ kwônêrji imɲê men, yébé men bi bôrji sa Kelma aɲ daɲji naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɓiɲé sooriɲ naɲ bay ômɲare tô geré, ka pôni sa kwoy a men, ka pôni sa jaare a men, aɲ bi kiriɲa Piyêr ré sa ba, tini ré ô si sa kwo pôni gaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kwônê ɓiɲé henaji sa kam iyére to kwa Jérusalêm a hen eraɲ bay ômɲare men, ka tunu to habiɲ dôyrêji men, aɲ bay kêm berare. ");
INSERT INTO kqp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kiriɲa *dami wo damné kaɲ bay bê kwôbe naɲ bay tôri kaɲ *Sadusiɲêɲê gel hen iyôŋ menba, terbére liji menba, bay genge wo ciré lê ani. ");
INSERT INTO kqp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bay pô bay jé ô biji daŋgay tô kwônê ɓiɲé a. ");
INSERT INTO kqp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Niɲba, derô yoyre menba, mana wo Kelma sa bôl kibi iyéy daŋgay aɲ biji si nô aɲ kôlji iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Erêŋge ken ô ɗebé *iyéy Emen a aɲ ken uwôliɲ ɓiɲé béré kwôlê kêm woɲ gelê bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bay toy kwôlê kibri a aɲ kiriɲa kiriɲ peraɲ soɲ soɲ menba, bay ô derô haba wo iyéy Emen a aɲ geliɲ ɓiɲé are. Dami wo damné kaɲ bay bê kwôbe naɲ bay tôri uwôgeji daɲare to surɲê ka kam *Israyêl kêm menba, bay jé wogé bay jé bô daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Niɲba, kiriɲa asgarɲê saji biɲ iyéy daŋgay menba, bay uwoɲji ré menba, bay buloji hera sa dôriɲ bay jériji hen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Nini uwôɲ kibi geré ligiɲ men, bay geméri hen kôba môrji ya a men, niɲba, kiriɲa nini bôl kermiɲ menba, nini uwôɲ kwôni ira ré.» ");
INSERT INTO kqp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kiriɲa dami wo bay gemé iyéy Emen naɲ damné kaɲ bay bê kwôbe hen toy hen iyôŋ menba, bay hôn kwôlê woɲ kelê sa aŋga sa sa bay jé a hen né aɲ bay eŋgere mi a ré lê are hen iyôŋ ba. ");
INSERT INTO kqp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Menba, kiriɲ bay ka hen na, kwôni era sa kôlji iyôŋ ba: «Gel, ɓiɲé ka ken biji daŋgay a hen ɗebiji derô haba wo iyéy Emen a geliɲ ɓiɲé are yaŋ.» ");
INSERT INTO kqp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Menba, dami wo bay gemé iyéy Emen ô naɲ ɓiɲé kari ôrji perê bay jé heraɲ. Bay liji ani ré wôsa bay hare wô wo ɓiɲé ma ré gôbiji naɲ jerew. ");
INSERT INTO kqp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bay eraɲ naɲ ci sa geliɲ daɲare to surɲê menba, dami wo damné kaɲ bay bê kwôbe eŋgeriji kwôlê. ");
INSERT INTO kqp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ôbi kôlji iyôŋ ba: «Nini jerêŋge yôd bi kené geliɲ ɓiɲé are naɲ hini gawra bi wo hen, menba, ken li aɲ ɓiɲé ka Jérusalêm kêm toy kwôlê woŋge bi wo hen men, ken gey lê bi kwôbri gawra bi wo hen ré hera sarni a men.» ");
INSERT INTO kqp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Menba, Piyêr naɲ bay jé uwôlji sara iyôŋ ba: «Biɲ Emen kwôlê dô ɗê biɲ gawrê kwôlê. ");
INSERT INTO kqp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jésu bi wo na ken bi bay na ɓééri a sa gurô aɲ ma hen na, Emen wo môɲêrna na biri ji si kamɲê. ");
INSERT INTO kqp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na ôbi aɲa Emen né ayri ɗiri mô sa kôbri woɲ gusurô a mega Kelma men, ôbi gôliɲ naɲ ɓiɲé men, aɲ bi kam Israyêl ré uwôɲiɲ geré biliɲ hal woji aɲ Emen né ɗiɲ bôri jal sa têriɲ toji a. ");
INSERT INTO kqp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nibay nini dô kwôli are bay ka hen, nibay naɲ Tunu toɲ hendi bô bôrê to Emen biɲ ɓiɲé ka biri kwôlê hen.» ");
INSERT INTO kqp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kiriɲa bay daɲare toy kwôlê bi wo hen iyôŋ menba, bôrji tarji aɲ bay gey ciré deré bay jé. ");
INSERT INTO kqp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Niɲba, gawra wo pôni bay uwôgeri Gamaliyêl, ôbi na *Parisiɲê men, na ôbi gelé tôô wo dami wo ɓiɲé kêm biri kwôlê. Ôbi hena perêrji aɲ kôl bay ré biɲ bay jé ré siji nô sem. ");
INSERT INTO kqp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Menba, ôbi kôliɲ surɲê ka daɲ hen iyôŋ ba: «Kenbay kam Israyêl, erméŋge dô sa aŋga ken gey lê naɲ ɓiɲé ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wulê wo na di jô hen na, nana gel Tédas wo kôl ɗiré na kwôni wo dami aɲ li ɓiɲé arew pôrbu ô tôri a. Bay diri, menba, bay tôri bay ka hen kôba, usuriɲji a men, aɲ ani ka baa ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Cêgeri wori ba, nana gel Judas wo Galilé bô wulê woɲ sajima hen, ôbi kôba, day ɓiɲé tôri a aɲ bay diri menba, bay tôri bay ka hen kêm usuriɲji. ");
INSERT INTO kqp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iyôŋ ba, en kelêŋge, ɗéŋge turŋge tô ɓiɲé ka hen a ré niɲ, ɗeŋgiji ô. Hena ermé woji naɲ jé lêreji bi wo hen ré na kwo gawrê na, ôbi a naɲê sa kibri mera. ");
INSERT INTO kqp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A hena ré na kwo Emen na, kena nêmê mênê ré kwôy. Berêŋge dô ré ba, ka lê kumbul naɲ Emen!» Menba, bay gey kwôlê wori bi wo hen, ");
INSERT INTO kqp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","menba, bay hô uwôga bay jé heraɲ aɲ bay bi bay sêji aɲ bay karji gwom bi bay ré uwôge hini Jésu cêgê ré niɲ aɲ bay biji ta. ");
INSERT INTO kqp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bay jé soji kini daɲare to surɲê a naɲ yi derê wôsa Emen ré bôrji môɲ gawrê ka nêm, aɲa ré bi ciré geliɲ gusiɲ wô hini Jésu hen. ");
INSERT INTO kqp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naɲ wulê wulê derô haba wo iyéy Emen a men, bô iyé ɓiɲé a men a na, bay geliɲ ɓiɲé are men, bay uwôl béré Kwôlo Dôri mega wo Jésu ré na *Krist, kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wulê bi wo hen na, bay tô Jésu kwône erê tumô tumô menba, kwôlê yi perê Jubɲê ka iyêl kibi grêk hen naɲ ka yêɲ sa terare toji a, wôsa ka iyêl kibi grêk hen kôl sa cé are ka naɲ wulê wulê hen na, bay ré liɲ mamê kaji dô ré. ");
INSERT INTO kqp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Bay jé ka môj kibi wôô hen uwôge daɲare to dami to bay ayê bôô kêm aɲ kôlji iyôŋ ba: «Dé wo nibay niné ɗi ulê béré kwôlo Emen baa aɲ ô wô cé emê ré. ");
INSERT INTO kqp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iyôŋ ba, yênêrni, wogéŋge gawrê jurgem perêrŋge a hen ka bay kôl kwôliji dô men, ka Tunu toɲ hendi bô bôrê bôrji a men, kaɲ bay tu melênê a men, aɲ niɲa biji jé bi wo hen kôbri a. ");
INSERT INTO kqp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aɲ nibay ba, niɲa erê wô uwôlê Emen men, geliɲ ɓiɲé are men.» ");
INSERT INTO kqp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ɓiɲé kêm gey kwôlê woji bi wo hen: bay dô Etiyên, na kwôni wo ayê bôô wori dô men, Tunu toɲ hendi bô bôrê kôba wôn bôri a men, Pilip men, Prokôr men, Nikanôr men, Timôn men, Parménas naɲ Nikwolas wo na kwôni wo Antiyôk wo na Jub ré niɲba, na bi bôri sa tôô toji a hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bay eraɲ naɲ ci sa geliɲ bay jé, aɲ bay uwôl Emen wô sarji men, bay uwôl kôbriji sarji a a men. ");
INSERT INTO kqp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kwôlo Emen ô tumô tumô men, ɓiɲé ka bi bôrji sara hen kôba kwône damaŋ a Jérusalêm a men, bay bê kwôbe kwône bi bôrji sa Jésu a men. ");
INSERT INTO kqp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Terê kibi naɲ néé wo Emen baa naɲ Etiyên aɲ ôbi li aŋgaɲ giɲê men, kaɲ gelé damné damné a men tu ɓiɲé bay gel. ");
INSERT INTO kqp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kiriɲa bay gel hen iyôŋ menba, ɓiɲé ka pôni bô *iyéy daɲare to bay uwôgere iyéy daɲare to limé ka mô sarji seŋge to na Jubɲê ka Sirên naɲ ka Alêksandri daɲ ya hen, naɲ ka Silisi a naɲ ka Asi a men aɲ bay kêm nariɲ kwôlê naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Niɲba, bay nêm ɗebé geraŋ tumôri a ré, wôsa ôbi iyêl naɲ tu melênê wo Tunu a biri hen. ");
INSERT INTO kqp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Menba, bay têbe ɓiɲé aɲ ré kôl iyôŋ ba: «Nini toy wo ôbi kôl kwôlo habiɲ gengiɲ sa *Moyis men, sa Emen a men.» ");
INSERT INTO kqp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bay sôge tô ɓiɲé men, surɲê naɲ *bay derê tô tôô to Emen. Bay era sa ɓu Etiyên ereŋ ôriɲ naɲ ɗi tumô sanédrên a. ");
INSERT INTO kqp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kiriɲ bay ka hen na, bay eraɲ naɲ gawrê ka pôni sa pôy kwôlê woɲ benare ɗiri sari a kôl iyôŋ ba: «Gawra bi wo hen, ɗi kelê kwôlo habiɲ gengiɲ sa *iyéy Emen tona to yi naɲ jeŋgêre hen baa ré men, gengiɲ sa tôô to Moyis hen baa ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Men, nini toy ôbi kôl iyôŋ ba: ‹Jésu wo Najarêt bi wo hen ré mênê iyéy Emen men, ré hô ɲanê hara wo Moyis na ay béna hen a men.› » ");
INSERT INTO kqp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɓiɲé kêm ka mô kini daɲare to surɲê hende to hen, hen na, tirji na sari a aɲ bay gel tiri yi môɲ to *mana wo derômaraŋ a iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*Dami wo damné kaɲ bay bê kwôbe eŋgereri iyôŋ ba: «Kwôlo bay kôl kêm hen na, na tiri ba?» ");
INSERT INTO kqp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Menba, Etiyên uwôli sara iyôŋ ba: «Balên naɲ yênên, toyéŋge, Emen ôbi hini emê si sa môyrena *Abraham a kiriɲa ôbi na môriɲ Mésopotami a pa dema ré ô môriɲ Haran a tô. ");
INSERT INTO kqp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aɲ Emen na kôli iyôŋ ba: ‹Ɗéɲ sa iyére tom men, balêm men, aɲ ju ô sa iyére to na gelem hen.› ");
INSERT INTO kqp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Menba, Abraham ɗéɲ sa iyé Kaldé, aɲ ôriɲ môriɲ Haran a. Kiriɲ bay ka hen cêgi temare to ibari a menba, Emen biri era sa mô sa iyére to ken môriɲ ya haw hen. ");
INSERT INTO kqp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Niɲba, sa iyére hende to hen na, kiriɲ kani dê iyôŋ kôba, ôbi jô biri ré, kaɲ ɗiɲ têri ya kôba, naɲ niɲba, Emen ay tôri ɗiré biri ôbi men, kwôŋgêri men, kiriɲ bay ka hen, bi wo Abraham kemari na naɲ hen kôba. ");
INSERT INTO kqp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aɲ Emen kôli iyôŋ ba: ‹Kwôŋgêm a merê sa iyére to ɗaŋgi a men, bay a liji lemnare men, bay a geliɲ tirji gusiɲ kwôy elê arew pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Niɲba, ɓiɲé ka sa iyére hende to gelji gusiɲ hen na, nôbi Emen na jerê kwôlê sarji a, aɲ cêgeri wori menba, na biɲ ɓiɲé kaɲê a séɲ sa iyére hende to hen a, aɲ bay a teben sa iyé Kanan hende to nà.› ");
INSERT INTO kqp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Menba, Emen kôliɲ Abraham iyôŋ ba: ‹Aŋga gel biɲare hende to hen na, ôbi a na walê keŋ.› Na ôbi á, kiriɲa Abraham ré yê Isak li sa marge menba, wali keŋ. Isak liɲ Jakwôb hen iyôŋ men, Jakwôb kôba, liɲ kamni ka môj kibi wôô kaɲ môɲêrna hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Kam Jakwôb li terbére naɲ yêniji Josêp aɲ bay ɓiri keléɲ bi bay ré ôriɲ naɲ ɗi lê lemnare Ejipt a. Niɲba, Emen ba, naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Men, Emen dôri kibi gusiɲ to kêm a aɲ biri tu melênê men, biri dé tu Parawôn kelma wo Ejipt a. Kelma wo Ejipt bi wo hen biri ôm Ejipt men, biri bô sa bô iyére tori a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kiriɲ bay ka hen na, kurôŋ wo dami kuriɲ sa iyé Ejipt a kêm men, sa iyé Kanan a men, gusiɲ to dami li ɓiɲé aɲ môɲêrna uwôɲ ani kaɲ emê ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kiriɲa bay toy wo kaw ré yi Ejipt a ya na, Jakwôb jé kamni ka na môɲêrna hen ôrji têê pôn. ");
INSERT INTO kqp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Têê wôô wori wo bay hera menba, Josêp li aɲ yênêri gili hôn aɲ na wulê bi wo hen dema Parawôn ré hôn balê Josêp tô. ");
INSERT INTO kqp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josêp jé wogé ibari Jakwôb naɲ balêri kêm aɲ bay kêm na ɓiɲé tôre jurgem kibi bay. ");
INSERT INTO kqp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakwôb era sa mô Ejipt a, ôbi ma kiriɲ bay ka hen, môɲêrna kôba, môrji na ya men, maji na ya a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bay pôrji ôriɲ Sisêm a ô emé bô kamɲê ka Abraham na kel kôbi kam Hemôr Sisêm a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Kiriɲa wulê wo aŋga Emen na ayiɲ tôri biɲ Abraham hen baa ɗa wo a liɲ menba, ɓiɲé yêɲ yirji Ejipt aɲ bay kwône tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kwôy wulê wo kelma wo ɗaŋgi wo hôn Josêp ré hen ayiɲ kenare sa Ejipt a. ");
INSERT INTO kqp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kelma bi wo hen lam balêrna men, liji habrê, aɲ ôbi biji bay ɗéɲ kamniji ka bay yê haw hen bi ré ma aɲ. ");
INSERT INTO kqp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na wulê bi wo hen aɲa *Moyis ré yêɲ ya. Ôbi na kema wo li manare men, dê tu Emen a men. Bay aberi geserê subu bô iyé ibari a. ");
INSERT INTO kqp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Menba, kiriɲa bay ɗiri aɲ menba, môni Parawôn ayri ô gemé mega kemare woɲ bôre iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bay geliɲ Moyis tu melênê wo Ejipt kêm aɲ ôbi na kwôni wo dami sa kwôli kelêri a men, sa jé lêri a a men.» ");
INSERT INTO kqp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Kiriɲa ôbi li elê tôre pôrbu menba, ôbi erem erê uɲé yênêri Israyêlɲê. ");
INSERT INTO kqp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ôbi gel yêni wo Ejiptiɲê wo pôni geli gusiɲ menba, ôbi ô jerê sari aɲ ôbi di Ejiptiɲê bi wo hen duu. ");
INSERT INTO kqp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ôbi kôl yaŋ ba, yênêri ré henê mega wo ré na Emen a ré ɗa gôliɲ naɲ ci naɲ geré wori hen, niɲba, bay hôn né. ");
INSERT INTO kqp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wulê wo ɗaŋgi ôbi hô gel yênêri wôô sêɲji menba, ôbi waji aɲ gey bi bay ré hô biɲ hôriɲ aɲ ôbi kôlji iyôŋ ba: ‹Milɲén, kena yênê a menba, wô mi a kené liɲ yerŋge habiɲ hen iyôŋ ba?› ");
INSERT INTO kqp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Menba, kwo geliɲ tu yêni gusiɲ hen nôgeri wolé aɲ kôli iyôŋ ba: ‹I a ɗém jeré na kelma woni men, ôbi jerê kwôlê sarni a a men ba? ");
INSERT INTO kqp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ju gey deren mega wo henaŋ ju diriɲ Ejiptiɲê wo pôni hen iyôŋ men ba?› ");
INSERT INTO kqp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kiriɲa Moyis toy hen iyôŋ menba, ge ô uwôbê sa iyé Madiɲa a, ôbi yê kam imɲê wôô kiriɲ bay ka hen.» ");
INSERT INTO kqp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Kiriɲa elê tôre pôrbu nêm menba, *mana wo derômaraŋ a si sari a derô gwôlê ɗa naɲ keram wo Sinay a perê germé kaɲ tare a. ");
INSERT INTO kqp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kiriɲa Moyis gel hen iyôŋ menba, tini ge kay aɲ ôbi uso ɗa ɗiré gelé, menba, ôbi toy tô Kelma ôm kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ena Emen wo môɲêm Abraham, Isak naɲ Jakwôb.› Moyis wuré aɲ gey ayê tiri geliɲ ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Menba, Kelma kôli iyôŋ ba: ‹Tô garbê têm a aɲ wôsa kiriɲ ka ju ɗibiɲ ya hen na, na terare to yi naɲ jeŋgêre. ");
INSERT INTO kqp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na tiri, en gel gusiɲ to bay geliɲ ɓiɲé kaɲê Ejipt a hen men, en toy ɲôrê woji a men, aɲ en herbo wô dôrji bô lemnare a. Era, haw hen, na jém Ejipt a.› » ");
INSERT INTO kqp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyis bi wo bay na kaɲni kôl iyôŋ ba: ‹I a ɗém kelma ôbi jerê kwôlê sarni a ba hen› na ôbi a, Emen né ɗiri mega kelma men, ôbi derêji bô lemnare a naɲ néé wo mana wo derômaraŋ a wo na siɲ sari a bô germé kaɲ tare a hen. ");
INSERT INTO kqp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na ôbi a siɲ naɲ ci Ejipt a liɲ aŋgaɲ giɲê naɲ kaɲ gelé sa iyé Ejipt a men, bô cér wo sêyi a men, derô gwôlê a men kwôy elê tôre pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na Moyis bi a na kôliɲ Israyêlɲê iyôŋ ba: ‹Emen a derê ôbi kibri pôn perê yênêrŋge a hen, liɲ ôbi kibri mega nôbi iyôŋ.› ");
INSERT INTO kqp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kiriɲa kam *Israyêl na daɲ derô gwôlê hen na, na na ôbi a na derê tô kwôlê perê môɲêrna naɲ mana wo derômaraŋ a wo iyêli sa keram wo Sinay a. Na ôbi a eŋgé kwôlê woɲ gelê bi wo hen heraɲ béna hen.» ");
INSERT INTO kqp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Niɲba, môɲêrna na gey biri kwôlê ré men, bay kaɲni aɲ ermé woji hô yi na si Ejipt a ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bay kôliɲ Arôn iyôŋ ba: ‹Lêni kamrê ka ô tumôrni a niɲa gelé ɗiba Moyis bi wo derani soɲ Ejipt a hen na, ôbi beliɲ na mi kôba nini hôn né.› ");
INSERT INTO kqp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wulê bi wo hen na, bay iyege kema kelba mega kamrê kaji iyôŋ aɲ bay li sarga biji men, bay ay kibi ari lê kaji bay ka hen naɲ yi derê a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Emen ay tiri aɲ sarji men, ɗiji bay ay kibi têbêŋne to derômaraŋ a. Bay kibi Emen kôl kwôliji kôl iyôŋ ba: ‹Kam Israyêl, kiriɲa na ken duu lari liɲ sarga bô elê wo tôre pôrbu wo na ken li derô gwôlê a hen ba, nà ná nôbi a na kené li ben hen ba? ");
INSERT INTO kqp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na nôbi a na kené li ben hen né, niɲba, ken ay iyéy gergé to emen woɲ Môlôk naɲ aŋga ken gengiɲ emen woŋge woɲ têbêŋne wo ken uwôgeri Répan hen, kamrê bay ka ken li aɲ ken ay kibriji. Na ôbi á, ené perêŋge ôriɲ kelaŋ naɲ Babilôn a sôŋ.› » ");
INSERT INTO kqp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Derô gwôlê a na, môɲêrna na ôriɲ naɲ iyéy gergé to magtubu toɲ biɲare yi bô. Iyéy gergé hende to hen, na ɗiɲ na mega to Emen na geliɲ Moyis ré ɗiɲ hen iyôŋ. Wôsa ôbi kôliɲ Moyis ré li giliɲ naɲ to kwo ré gel hen iyôŋ têj têj. ");
INSERT INTO kqp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iyéy gergé hende to hen na, bay biɲ môɲêrna kaɲ bay jibérji aɲ bay ay ôriɲ kôbriji a kiriɲa Josuwé na dôriɲ tumôrji aɲ bay na bôyiɲ kumbul sa iyére to ɓiɲé ka ɗaŋgi a ka Emen na dageji tumôrji a hen. Bay gem iyéy gergé hende to hen kwôy saɲ sa emê kenare to kelma Dabid a. ");
INSERT INTO kqp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na kelma Dabid bi a dé tu Emen aɲ ôbi eŋgereri tôô bi ɗiré ɗé iyére biɲ Emen wo Jakwôb. ");
INSERT INTO kqp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Niɲba, na kemari Salomôn a lê *iyéy Emen hende to hen biri.» ");
INSERT INTO kqp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Niɲba, Emen wo derômaraŋ a mô na bô iyére to kôbi gawra a lê ré. Mega *ôbi kibi Emen kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Kelma kôl iyôŋ ba: Derômaraŋ na gagay kenare tiɲê men, sa terare na kini bê tên ya men. Na iyére to iyeŋgi a kené lê ben ba? Men kiriɲ ka yôŋ a ené erê merê ya wô dôriɲ bul ba? ");
INSERT INTO kqp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Men, are bay ka kêm hen na nôbi a lê ré ba?› » ");
INSERT INTO kqp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ay! Kenbay gawrê kaɲ bay sa iyêrê hen, bôrŋge deŋgel môɲ bô ɓiɲé ka bi bôrji sa Emen a ré iyôŋ men, ken lugu marŋge ta sa kwôlo Emen kôl hen men, ken ɗebiɲ Tunu toɲ hendi bô bôrê iyêre kwôy kwôy men, ken geliɲ naɲ môɲêrŋge a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ôbi kibi Emen wo yôŋ a môɲêrŋge na ré gili gusiɲ ré ba? Tumô bay na duu ka na uwôl béré sa wo ôbi lê aŋgaɲ derôre wo pôn nêŋ hen, na ôbi a kené ay sari aɲ diri. ");
INSERT INTO kqp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kenbay ka Emen na béŋge tôô naɲ geré wo *manê ka derômaraŋ a niɲba, na ken bi kwôlê sa tôô hende to hen a ré.» ");
INSERT INTO kqp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kiriɲa surɲê ka mô kini daɲare hen toy kwôlê bi wo Etiyên kôl hen menba, tirji sêrê sari a men, bay gederé kaɲniji kaɲ bô tarê sari a a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Niɲba, Tunu toɲ hendi bô bôrê wôn bôri aɲ ôbi bô kiriɲ si derômaraŋ menba, gel damɲare to Emen men, ôbi gel Jésu ɗebu sa kôbi Emen woɲ gusurô a men. ");
INSERT INTO kqp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ôbi kôl iyôŋ ba: «Toyéŋge, en gel derômaraŋ bôliɲ aɲ en gel *Kema Gawra ɗebe sa kôbi Emen woɲ gusurô a.» ");
INSERT INTO kqp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Menba, bay karê gura wo dami ligiɲ marji ta aɲ bay bi kibriji pôn cariɲ sari a, ");
INSERT INTO kqp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ɓiri ôriɲ wolé kelaŋ naɲ iyére aɲ bay gôbri duu. Ɓiɲé ka ɗebu ya gel hen na, ôriɲ naɲ bargay kaji ô bê a tumô kema mana wo bay uwôgeri Sôl hen bi ré gem. ");
INSERT INTO kqp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kiriɲa bay gôbri ca deré hen iyôŋ menba, Etiyên uwôl Emen kôl iyôŋ ba: «Kelma Jésu, eŋge tunun.» ");
INSERT INTO kqp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Menba, ôbi jubu gubari tôŋ aɲ jô gura wo dami kôl iyôŋ ba: «Kelma, ɗi bôm jal sa têriɲ toji a.» Kiriɲa ôbi kôl hen iyôŋ menba, kibri wôm men. ");
INSERT INTO kqp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aɲ Sôl dege naɲ ɓiɲé ka duu Etiyên hen. Wulê bi wo hen na, bay ay tô geliɲ bay ayê bôô gusiɲ to habiɲ hen Jérusalêm a. Wulê bi wo hen na, bay ayê bôô kêm useriɲji ge si sa kam iyére men, si Judé men, Samari a men, aɲ na bay jé a baji Jérusalêm a mera. ");
INSERT INTO kqp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɓiɲé kaɲ bay tibé Emen kaɲ bay bôô pôn sôm Etiyên dô aɲ emni. ");
INSERT INTO kqp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sôl ba, mase wô mênê bay ayê bôô. Ôbi ô naɲ bô iyére iyére pô imɲê naɲ yébé biji daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bay ayê bôô ka useriɲ hen na, ôrji naɲ kiriɲ kiriɲ wô uwôlê béré Kwôlo Dôri wo Emen. ");
INSERT INTO kqp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ôbi a, Pilip ré ô sa iyére to dami a bô emê wo Samari a ô ulê béré Kwôlo Dôri wo *Krist, kwo Emen dôri hen biɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɓiɲé kêm dôbe marji toyiɲ kwôlo Pilip kôl hen. Bay toy kwôli bi wo hen men, bay gel aŋgaɲ giɲê ka ôbi li hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tunu to habiɲ kwône séɲ bô ɓiɲé aɲ karê gura wo dami men, bay merayê kwône kôba, berare a men. ");
INSERT INTO kqp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɓiɲé kêm sa ira li yi derê wo dami. ");
INSERT INTO kqp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sa iyére hende to hen na, gawra wo bay uwôgeri Simô mô ya, ôbi na beli, ôbi li aŋga tini ɓiɲé ka Samari ge kay kwôy kwôy. Ôbi li yiri môɲ kwôni wo dami iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aɲ ɓiɲé kêm kamrê ré, ka iyêrɲê ré dôbe marji toyiɲ kwôlê wori. Aɲ bay kôl iyôŋ ba: «Gawra wo hen na, na néé wo Emen wo bay kôl ré na néé wo dami hen.» ");
INSERT INTO kqp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Menba, bay biri kwôlê damaŋ wôsa ca yeŋ ôbi li tiniji ge kay naɲ aŋgaɲ beli kari bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Niɲba, kiriɲa bay bi bôrji sa Kwôlo Dôri wo Pilip uwôlji gengiɲ sa *emê iyére to Emen men, gengiɲ sa hini Jésu Krist a men na, bay li batêm imɲê ré naɲ yébé ré. ");
INSERT INTO kqp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simô bi wo hen kôba, ay bôri aɲ li batêm aɲ ɗi tô Pilip bul ré kwôy. Kiriɲa ôbi gel aŋgaɲ giɲê men, kaɲ gelé ka liɲ hen menba, tini ge kay. ");
INSERT INTO kqp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kiriɲa bay jé ka baa Jérusalêm a hen toy wo ɓiɲé ka Samari ré bi bôrji sa kwôlo Emen a hen iyôŋ menba, bay jé si Piyêr naɲ Ja ô uɲéji. ");
INSERT INTO kqp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kiriɲa bay ô biɲ Samari menba, bay uwôl Emen wô bay ayê bôô bi ôbi ré biji Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wôsa kwôni iyôŋ perêrji a hen wo Tunu toɲ hendi bô bôrê herbe sari a baa naɲ tô, bay li na batêm naɲ hini Kelma Jésu mera. ");
INSERT INTO kqp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Si Piyêr naɲ Ja uwôlji kôbriji a sa bay ayê bôô ka Samari a aɲ bay uwôɲ Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Menba, kiriɲa Simô gel wo bay jé ré uwôl kôbriji sa bay ayê bôô a dema ôbi ré uwôɲ Tunu toɲ hendi bô bôrê tô hen iyôŋ menba, ôbi kôl ɗiré biɲ si Piyêr naɲ Ja gursu. ");
INSERT INTO kqp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Aɲ ôbi kôlji iyôŋ ba: «Benge néé bi wo hen men, aɲ ɓiɲé ka en uwôl kôben sarji a ba, bi uwôɲ Tunu toɲ hendi bô bôrê men.» ");
INSERT INTO kqp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Menba, Piyêr uwôli sara iyôŋ ba: «Kenbay naɲ gursu tom hende to hen ken mêne kêm, wôsa ju erem mega jeré kelé naɲ gursu aŋga Emen bi seŋge hen. ");
INSERT INTO kqp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aŋgam kani naɲ naɲ ni bô jé woni a, wôsa bôm yi na pôn tumô Emen a ré. ");
INSERT INTO kqp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ɗi tô bô habrê wom bi wo hen baa aɲ ju eŋgeriɲ Kelma hena ré iyeŋ ba, ré ɗi bôri jal sam a wô ermé wo habiɲ bi wo sa sam a hen. ");
INSERT INTO kqp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wôsa en bôrem hen na, terbére wôn bôm aɲ ju na lema wo têriɲ tom hende to hen.» ");
INSERT INTO kqp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Menba, Simô kôliɲ si Piyêr naɲ Ja iyôŋ ba: «Kenbay ken uwôl Kelma wô san aɲ bi are bay ka ken kôliɲ kwôliji hen na, ré sa san a ré.» ");
INSERT INTO kqp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kiriɲa si Piyêr naɲ Ja dô kwôli hen iyôŋ men, bay uwôl béré kwôlo wo Kelma a men, menba, bay bilji hô Jérusalêm a. Tô geré a na, bay uwôl béré Kwôlo Dôri naɲ kiriɲ kiriɲ sa kam iyére to bô emê wo Samari a. ");
INSERT INTO kqp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mana wo Kelma kôliɲ Pilip iyôŋ ba: «Já erê si kini kuriɲare tare iyôŋ tô geré wo hena Jérusalêm ô Gaja hen. Geré bi wo hen na, na derô gwôlê a.» ");
INSERT INTO kqp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Menba, Pilip hena lew ô. Kiriɲ bay ka hen dami wo Etiyopi wo li jé gemé lari bô emê wo Kandasé tôlômne to Etiyopi. Ôbi uwo tô tibé Emen Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ôbi bul hô iɲ menba, mô bô pus a aɲ dôŋse magtubu to ôbi kibi Emen *Esay. ");
INSERT INTO kqp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tunu kôliɲ Pilip iyôŋ ba: «Uso ɗa, ju ɗebu kwa pus bi wo hen a.» ");
INSERT INTO kqp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Menba, ôbi ge ô menba, toy dami wo Etiyopi bi wo hen wo dêŋse magtubu to *ôbi kibi Emen Esay, menba, ôbi kôli iyôŋ ba: «Ju hôn bô magtubu to ju dêŋse hen ham ba?» ");
INSERT INTO kqp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Menba, ôbi uwôli sara iyôŋ ba: «Hena kwôni ré dô tôre ben ré ba, na lê iyeŋ a ené henê ba?» Menba, ôbi kôliɲ Pilip ré ɗay mô kwari a. ");
INSERT INTO kqp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kwôlo Emen wo ôbi dêŋse bi a na: «Ôbi bôl kibri ré mega demaŋne to bay ɓu ôriɲ ca erê deré iyôŋ. Mega kema gemga wo wôm kôbi ôbi karê gusuriri a hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bay uwôli tayre sari a niɲba, kwôni wo ré jô sari ba, naɲ men, na i a derê kwôli kwôŋgêri ba? Wôsa bay mêne gelê wori sa terare a nà.» ");
INSERT INTO kqp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Menba, dami wo Etiyopi bi wo hen eŋgeriɲ Pilip iyôŋ ba: «En uwôlem, kôlen na kwôli i a, ôbi kibi Emen ôbi bi wo hen ré kôl kwôli hen iyôŋ ba? Na kwôli ôbi gaŋ laba, na kwôli kwôni wo ɗaŋgi ɗiba?» ");
INSERT INTO kqp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Naɲ kwôlê bi wo magtubu to Emen kôl hen na, Pilip ɓeriɲ tô kôbri aɲ uwôliɲ béré Kwôlo Dôri wo Jésu. ");
INSERT INTO kqp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bay era era menba, bay saji kibi kam ka pôni a menba, dami wo Etiyopi bi wo hen kôliɲ Pilip iyôŋ ba: «Gel, kam a yé na, na mi a jerê bi ené li batêm ba?»  ");
INSERT INTO kqp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Menba, Pilip kôli iyôŋ ba: «Hena jeré bi bôm pôn sara ba, já lê batêm.» Menba, dami bi wo hen uwôli sara iyôŋ ba: «En bi bôn sara mega wo Jésu Krist ré na Kema Emen.» ");
INSERT INTO kqp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ôbi bi bay ɗebiɲ naɲ pus tôŋ, aɲ bay naɲ Pilip herbiji ôrji bô kam a menba, Pilip liri batêm. ");
INSERT INTO kqp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kiriɲa bay so bô kam a menba, Tini Kelma ay Pilip ôriɲ aɲ dami wo Etiyopi bi wo hen gili ré niɲ yôd, menba, ôbi ɓu geré wori naɲ yi derê ô. ");
INSERT INTO kqp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tunu ôriɲ naɲ Pilip ô uwôli Ajôt a aɲ ôbi uwôl béré Kwôlo Dôri naɲ sa iyére iyére to ôbi ôriɲ ya hen kwôy wo ôbi sa biɲ Sésaré. ");
INSERT INTO kqp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kiriɲ bay ka hen na, ermé wo Sôl ba, yi na sa mênê bay tô Kelma men, sa derérji a a men, ôbi ô uɲé *dami wo damné kaɲ bay bê kwôbe, ");
INSERT INTO kqp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aɲ eŋgereri bi ôbi ré biri magtubu to ré dô tumôri aɲ ɗiré ôriɲ wô *iyéy daɲare to Damas a. Hena ɗiré uwôɲ ɓiɲé ka ay geré wo Kelma, imɲê ley yébé ley ba, ɗiré peraji harê heraɲ Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ôbi ɓu geré ô menba, kiriɲa ôbi baa ɗa naɲ Damas menba, kiriɲ bay ka hen na, kiriɲ ka peraŋgi hena derômaraŋ a sa têli naɲ peraŋgêrji. ");
INSERT INTO kqp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kiriɲa ôbi kuriɲ tôŋ menba, ôbi toy tôô kwôni kôli iyôŋ ba: «Sôl, Sôl, wô mi a jeré gelen gusiɲ iyôŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ôbi eŋgere iyôŋ ba: «Ju na i ba, Kelma.» Menba, tô hende to hen uwôli sara iyôŋ ba: «Ena Jésu, na nôbi a jeré gelen gusiɲ hen. ");
INSERT INTO kqp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Niɲba, hena ta, ju ô derô ira aɲ bay a gelem aŋga já lê.» ");
INSERT INTO kqp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɓiɲé ka ô naɲ ɗi hen ɗebiji tôŋ, niɲba, bay bôl kibriji kôliɲ kwôlê wôni ré men, bay toy tôô gawra, niɲba, bay gel kwôni ré men. ");
INSERT INTO kqp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sôl hena terare a, bôl tiri hari, niɲba, ôbi gel kiriɲ né, aɲ bay ɓu na kôbri dema ré ôriɲ naɲ derô ira Damas a. ");
INSERT INTO kqp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aɲ sa subu ôbi nêm gelé kiriɲ né men, ôbi ôm ani ré men, yi ani ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ôbi tô Jésu wo pôni bay uwôgeri Ananiyas mô Damas a ya. Kelma si sari a bô pelal a aɲ uwôgeri «Ananiyas!» menba, ôbi yuge ôm iyôŋ ba: «En nà Kelma!» ");
INSERT INTO kqp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Menba, Kelma kôli iyôŋ ba: «Hena ta, ju ô tô geré wo bay uwôgeri kwo ɗebu ‹derôre› a hen aɲ ju eŋgere gawra wo bay uwôgeri Sôl wo Tars iyé Judas a, ôbi mô uwôl Emen kiriɲ bay ka hen ya. ");
INSERT INTO kqp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sôl gel bô pelal a gawra wo bay uwôgeri Ananiyas wo so ira aɲ uwôl kôbri a sari a bi ôbi ré hô gel kiriɲ hôriɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas uwôli sara iyôŋ ba: «Kelma, en toy ɓiɲé kwône kôl kwôli gawra bi wo hen men, habrê kêm wo ôbi liɲ ɓiɲé kam ka Jérusalêm a hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Men, damné kaɲ bay bê kwôbe biri tôô bi ré eraɲ nà, sa pôriɲ ɓiɲé kêm ka ré uwôge henem hen aɲ ré harêji a men.» ");
INSERT INTO kqp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Menba, Kelma kôli iyôŋ ba: «Ô, wôsa gawra bi wo hen en dôri mega aŋgaɲ ulê béré henen naɲ kiriɲ kiriɲ biɲ ɓiɲé ka iyére to ɗaŋgi a men, biɲ kilmé kaji men, biɲ kam *Israyêl a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nôbi naɲ yen na gili gusiɲ to ôbi a geliɲ wô henen.» ");
INSERT INTO kqp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Menba, Ananiyas hena ô. Ôbi biɲ bô iyére hende to hen aɲ uwôl kôbri a sa Sôl a, aɲ kôl iyôŋ ba: «Yênen Sôl, na Kelma Jésu bi wo so sam a tô geré bi wo jeré eraɲ hen, na ôbi a joon bi jeré hô gel kiriɲ hôriɲ men, bi Tunu toɲ hendi bô bôrê ré wôn bôm a men.» ");
INSERT INTO kqp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kiriɲ bay ka hen menba, ani kani geliɲ môɲ palmê kuyê iyôŋ heriɲ tiri a aɲ ôbi gel kiriɲ men, hena ta, aɲ bay liri batêm a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kiriɲa bay biri aŋgaɲ emê ôm menba, ôbi uwôɲ néri hôriɲ. Sôl wôl sem naɲ bay tô Jésu ka Damas a. ");
INSERT INTO kqp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Menba, kiriɲ bay ka hen ôbi ô ulê béré bô iyéy daɲare mega wo Jésu ré na Kema Emen. ");
INSERT INTO kqp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɓiɲé kêm ka toy kwôlo ôbi kôl hen na, tiniji ge kay sari a aɲ bay eŋgere iyôŋ ba: «Na gawra bi wo hen, a na liɲ ɓiɲé ka uwôge hini Jésu bi wo hen habrê Jérusalêm a na ré ba? Men, na ôbi na era ɗôd nà wô perêji harê ôriɲ biɲ damné kaɲ bay bê kwôbe hen ré ba?» ");
INSERT INTO kqp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Niɲba, ôbi uwôɲ néri tumô tumô sa derê kwôlê wori aɲ Jubɲê ka Damas uwôɲ kwôlê woɲ kelê ré, kiriɲa ôbi gelji wo Jésu ré na *Krist, kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wôl gaɲ cêgê menba, Jubɲê bay ka hen biɲji bi ciré deréri. ");
INSERT INTO kqp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Niɲba, Sôl toy kwôli deréri bi wo hen. Bay mô gem kibi iyére hende to hen yoyre naɲ tu tare bi ciré deréri. ");
INSERT INTO kqp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Niɲba, bô yoyre a menba, bay tôri ayri bô gway a herbe nô si sa gweŋ. ");
INSERT INTO kqp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kiriɲa ôbi sa biɲ Jérusalêm a menba, ôbi ô uɲé megêri bay tô Jésu niɲba, bay kêm hare wôsa bay kôl iyôŋ ba: «Ôbi ré na ôbi tô Jésu bi pa pa hari ba.» ");
INSERT INTO kqp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas ôriɲ naɲ ɗi ligi bay jé aɲ dôrji kwôli gelé wo Sôl ré gelo Kelma tô geré men, kwôlo Kelma kôli a men. Ôbi dôrji kwôli derê kwôlo ôbi dô naɲ ibiyare naɲ hini Jésu a Damas a hen men. ");
INSERT INTO kqp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wulê bi wo hen na, ôbi mô naɲ ci men, ô men hera naɲ ci a men bô Jérusalêm a men, dô kwôlê naɲ ibiyare a men naɲ hini Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ôbi iyêl naɲ Jubɲê ka iyêl kibi grêk hen men, nariɲ kwôlê naɲ ci a men, niɲba, bay woge geré wô deréri. ");
INSERT INTO kqp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kiriɲa yênêri toy hen iyôŋ menba, bay ôriɲ naɲ ɗi Sésaré a aɲ biri ô Tars a. ");
INSERT INTO kqp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bay ayê bôô ka sa iyé Judé men, ka Galilé naɲ ka Samari a kêm môrji naɲ bô jalê men, haliɲ yirji men, hariɲji Tini Kelma a men, bay kwône erê tumô tumô naɲ néé wo Tunu toɲ hendi bô bôrê. ");
INSERT INTO kqp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyêr ô gôr kiriɲ sa ira menba, ôbi sa biɲ uɲé bay ayê bôô ka Lida a. ");
INSERT INTO kqp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kiriɲ bay ka hen na, ôbi uwôɲ gawra wo bay uwôgeri Ené wo yi sa kalaŋ a. Ôbi meray li elê marge. ");
INSERT INTO kqp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyêr kôli iyôŋ ba: «Ené, Jésu Krist berarem. Hena ta, ju ɲan kalaŋ kam naɲ kôm!» Kiriɲ bay ka hen na, ôbi hena ta. ");
INSERT INTO kqp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kiriɲa ɓiɲé ka Lida naɲ ka tu wolé wo Sarôn a gili hen iyôŋ menba, bay kêm bi bôrji sa Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sa iyé Jopé a na, hende ayê bôô to pôni bay uwôgere Tabita mô ya. Hene bi wo hen naɲ kibi grêk ba na Dôrkas aɲ bôri na: Cénire. Hende na hendi lê aŋga dôri kwôy kwôy men, hendi ɓu baliyare naɲ bay nimré a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wulê bi wo hen na, hende ômiɲ aɲ ma. Bay pule aɲ ô ulêre bô iyére to ta a. ");
INSERT INTO kqp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bay tô Jésu ka Jopé toy wo Piyêr ré na Lida a ya. Lida na ɗa naɲ Jopé menba, bay jé ɓiɲé wôô ô kôli iyôŋ ba: «Era lew uɲéni ɗiba, ju mera sem né.» ");
INSERT INTO kqp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyêr hena kerêd ô naɲ ci. Kiriɲa ôbi sa biɲ menba, bay ôriɲ naɲ ɗi bô iyére to ta hende to hen, kiriɲ bay ka hen na, yébé kaɲ mamê usoji ligiri a naɲ sômê men, bay gili bargay ka hende na sôŋre kiriɲa hende na baɲ naɲ ci tô hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyêr bi bay si nô kêm aɲ jubu gubari tôŋ aɲ uwôl Emen menba, bul si ligi temare aɲ kôl iyôŋ ba: «Tabita, hena ta.» Hende bôl ture aɲ kiriɲa hende gel Piyêr menba, hena mô ta. ");
INSERT INTO kqp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ôbi ɓu kôbre buru hena ta, aɲ uwôga bay ayê bôô naɲ mamê aɲ gelji hendi temare hende to hen. ");
INSERT INTO kqp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɓiɲé ka Jopé kêm toy kwôli are bay ka hen, aɲ bay kwône ay bôrji biɲ Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyêr wôl gaɲ Jopé a iyé gawra wo bay uwôgeri Simô woɲ ôbi uwôŋsê ariɲ hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sa iyé Sésaré a na, gawra wo bay uwôgeri Kwôrney mô ya, ôbi na dami wo asgarɲê ka Rômêɲê ka bay uwôgeji ré na Itali hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gawra bi wo hen, na ôbi lê tôô Emen aɲ, bay naɲ ɓiɲé ka bô iyére tori ayji kibi Emen kwôy kwôy men, ôbi li naɲ Jubɲê kaɲ bay nimré damaŋ men, ôbi uwôl Emen ta ta a men. ");
INSERT INTO kqp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wulê wo pôni naɲ tare to yébé ayiɲ sa tôɲne hen menba, ôbi gel aɲ hôn mana wo Emen na iyôŋ naɲ yiri bô pelal a wo so iyére tori a aɲ kôli iyôŋ ba: «Kwôrney.» ");
INSERT INTO kqp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ôbi bô mana wo Emen bi wo hen ɗéɲ naɲ harê aɲ ôbi kôli iyôŋ ba: «Kelma, na mi ba?» Menba, mana wo Emen bi wo hen uwôli sara iyôŋ ba: «Uwôlê Emen wom naɲ lê wo ju li naɲ bay nimré hen na, dôriɲ Emen aɲ ôbi gôrbiɲ sam né. ");
INSERT INTO kqp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jé ɓiɲé kam haw hen, ô Jopé ô kelaɲ gawra wo bay uwôgeri Simô wo jelêri na Piyêr hen ré era. ");
INSERT INTO kqp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ôbi yi iyé megari Simô woɲ ôbi uwôŋsê ariɲ wo iyére tori ɗa naɲ kibi cér a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kiriɲa mana wo Emen bi wo ré iyêli hen ô niɲ menba, Kwôrney uwôga manê kari wôô naɲ asgar wo pôni woɲ ôbi jé wori woɲ ôbi lê tôô Emen hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ôbi dôrji kwôli aŋga ré li are hen kêm menba, jéji Jopé. ");
INSERT INTO kqp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kiriɲa kiriɲ wôl aɲ bay ay geré ô aɲ baji ɗa naɲ Jopé menba, Piyêr ɗay sa iyére toɲ dur dur a wô uwôlê Emen naɲ tay ɗiŋne. ");
INSERT INTO kqp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kurôŋ liri aɲ ôbi gey aŋgaɲ emê. Kiriɲa bay la emê ciré biri menba, pelal jôri. ");
INSERT INTO kqp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ôbi gel derômaraŋ bôliɲ aɲ ani kani ka geliɲ naɲ kibi bargay ka dami ka bay ɓu jeŋlare wo pôrbu hen iyôŋ sa herbe kwôy sa terare a. ");
INSERT INTO kqp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bô bargay ka dami bay ka hen a na, tanare to têre pôrbu kêm bô naɲ tu ka gay gay ka erge hen men, naɲ tu ciré ka gay gay kêm a men. ");
INSERT INTO kqp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Menba, tôô kwôni kôli iyôŋ ba: «Piyêr, hena ta, ju duu tanare hende to kêm aɲ ju ôm.» ");
INSERT INTO kqp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyêr uwôli sara iyôŋ ba: «En gey ré Kelma, en ôm ani kani ka jôriɲ naɲ ka *kagemi sa pôn né.» ");
INSERT INTO kqp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tôô kwôni bi wo hen hô kôli iyôŋ ba: «Aŋga Emen liɲ ka séli ba, jôbi já kelê ré na ka *kagemi ba?» ");
INSERT INTO kqp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Are bay ka hen sa hen iyôŋ têê subu aɲ, cêgê menba, bargay ka dami bay ka hen hô ayiɲ hôriɲ derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyêr erem na ba, pelal wo ré jôri na ba, bôri ré na iyeŋ pôn ba? Menba, kiriɲ bay ka hen na, bay jé ka Kwôrney ka ré wogeji iyé Simô hen, saji kibi geré men. ");
INSERT INTO kqp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bay uwôge bay iyére aɲ eŋgeriji iyôŋ ba: «Na iyére to nà a Simô woɲ Piyêr ré yi ya hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyêr erem sa pelal wo ré jôri a hen baa ya tô, menba, Tunu kôli iyôŋ ba: «Gel, imɲê subu wogem. ");
INSERT INTO kqp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hena ta, ju ô naɲ ci ɗiba, ju erem sem né, wôsa na nôbi a joji hen.» ");
INSERT INTO kqp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyêr herbo uwôɲ ɓiɲé bay ka hen aɲ kôlji iyôŋ ba: «Na nôbi wo ken woge bi a nà. Ken era gelen wô mi ba?» ");
INSERT INTO kqp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Menba, bay uwôli sara iyôŋ ba: «Na Kwôrney dami wo asgarɲê a jéni. Ôbi na kwôni woɲ derôre men, ôbi ay kibi Emen men, Jubɲê kêm kôba, geyri a men. *Mana wo derômaraŋ a kôli ôbi ré uwôgam jeré era iyére tori a bi ôbi ré toy kwôlo jeré kelêri.» ");
INSERT INTO kqp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyêr biji bay era ira aɲ wôl naɲ ɗi. Kiriɲa kiriɲ wôl menba, ôbi ô naɲ ci, yênêri bay ayê bôô ka pôni ka Jopé biri ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ɗaŋ tô hen menba, bay biɲ Sésaré. Kwôrney mô gemji naɲ balêri men, milɲéri kaɲ ɗéɲ ka ôbi jé uwôgaji hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kiriɲa Piyêr ɗa sé ira menba, Kwôrney jô kwini aɲ di kwini tôŋ tumôri a kwôy terare a naɲ bê kwôlê wo dami. ");
INSERT INTO kqp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Niɲba, Piyêr ɓiri ta, aɲ kôli iyôŋ ba: «Hena ta! Wôsa nôbi kôba, ena gawra môɲ jôbi hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ôbi iyêl naɲ ɗi aɲ ô ira, kiriɲ ka ɓiɲé ka kwôni daɲ ya hen, ");
INSERT INTO kqp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","menba, ôbi kôlji iyôŋ ba: «Ken hôn mega wo kwôni woɲ Jub naɲ hara wori na, ré erê naɲ kwôni wo sa iyére to ɗaŋgi a ré men, erê iyére tori a ré a men. Niɲba, Emen gelen mega wo ené bô kwôni môɲ aŋga kagemi ré men, wo ré nêm bi kwôni ré ô naɲ ɗi ré iyôŋ né a men. ");
INSERT INTO kqp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na iyôŋ a, kiriɲa kené jé uwôgan menba, en kuriɲ era mera ɗiba, en meremné ré hen. Iyôŋ ba, en gey henê tô uwôgê wo ken jé uwôgan hen.» ");
INSERT INTO kqp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Menba, Kwôrney uwôli sara iyôŋ ba: «Kemnêŋ li sa subu niɲ naɲ tare to yébé ayiɲ sa tôɲne mega megare na iyôŋ hen na, en uwôl Emen iyére tiɲê. Menba, kiriɲ bay ka hen na, gawra wo pôni naɲ bargay ka eŋné so ɗebu tumôn a. ");
INSERT INTO kqp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aɲ kôlen iyôŋ ba: ‹Kwôrney, Emen toy uwôlê wom men, bôri gôrbiɲ sa lê wo ju li naɲ bay nimré hen né a men. ");
INSERT INTO kqp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jé ɓiɲé ô Jopé ô uwôga Simô wo jelêri na Piyêr wo yi iyé Simô ôbi uwôŋsê ariɲ wo mô kibi cér a hen ré era.› ");
INSERT INTO kqp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kiriɲ bay ka hen menba, en jé ɓiɲé wogem aɲ naɲ bô derê wom a jeré eraɲ uɲéni hen. Haw hen nibay kêm nini mô na tumô Emen a wô toyé kwôlê kêm wo Kelma kelam jeré sa kelêni hen.» ");
INSERT INTO kqp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Menba, Piyêr ay kwôlê kôl iyôŋ ba: «Haw hen en hôn dô bêɲ bêɲ niɲ wo Emen na, ré dô tu kwôni ré, ");
INSERT INTO kqp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","aɲ gawra wo yôŋ yôŋ wo sa iyére to yôŋ yôŋ wo biri kwôlê men, li aŋgaɲ derôre a men hen na, ré dé tiri. ");
INSERT INTO kqp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ken hôn béré kwôlo ôbi na jéɲ biɲ kam *Israyêl hen. Béré bi wo hen gengiɲ sa Kwôlo Dôri woɲ bô jalê naɲ geré wo Jésu Krist wo na Kelma wo ɓiɲé kêm hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Cêgi derê kwôlê wo Ja naɲ batêm to ôbi na liɲ ɓiɲé a men hen na, ken hôn kwôli are bay ka li are ayiɲ tôrji Galilé a kwôy sa iyé Judé a hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ken hôn iyeŋ a Emen ré dô Jésu wo Najarêt bi wo hen men, bé wo ôbi biri néé naɲ geré wo Tunu toɲ hendi bô bôrê men. Men, ken hôn iyeŋ a ôbi ré ô gôr sa iyére liɲ ɓiɲé derê men, berariɲ ɓiɲé kêm ka mô bô lemnare to Sidan a a men hen, wôsa Emen baa naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aɲ nibay ka pôni nini gel ari lêri bay ka kêm hen naɲ tirni sa iyé Jubɲê men, Jérusalêm a men. Ôbi bi wo bay na ɓééri sa gurô tagelê aɲ diri hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Li sa wôô, subu tori menba, Emen biri ji si kamɲê men, biri gel yiri, ");
INSERT INTO kqp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","biɲ ɓiɲé kêm né niɲba, ka ôbi na tôrji tumô mega bay derê kwôli are bay ka hen iyôŋ. Na nibay ka na nini ôm men, yi men, naɲ ɗi cêgi jê sé wo Emen biri ji si perê ɓiɲé ka ma a hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aɲ ôbi kelêni niné uwôl béré aɲ geliɲ ɓiɲé mega wo ré na Emen a ré ɗiri mega ôbi jerê kwôlê iyôŋ sa ɓiɲé ka mô geɲ men, ka ma a a men, ");
INSERT INTO kqp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na ôbi á, bay kibi Emen kêm na ré kôl kwôli kôl iyôŋ ba: ‹Emen ɗi bôri jal naɲ néé wo hini sa têriɲ to kwôni wo yôŋ yôŋ wo bi bôri sari a.› » ");
INSERT INTO kqp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piyêr kôl kwôli are bay ka hen baa ya tô menba, Tunu toɲ hendi bô bôrê herbe sa ɓiɲé kêm ka mô toy kwôli bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jubɲê ka baa Piyêr eraɲ hen kiriɲa bay gel wo Tunu toɲ hendi bô bôrê to Emen a bé heriɲ sa ɓiɲé ka sa iyére to ɗaŋgi a men hen iyôŋ menba, tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bay toy ɓiɲé bay ka hen iyêl kibi yê wo ɗaŋgi men, heramiji damɲare to Emen men. Menba, Piyêr kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Naa jerê bi ɓiɲé bay ka hen ré li batêm naɲ kam haw hen wo bay uwôɲ Tunu toɲ hendi bô bôrê môɲ nabay iyôŋ men hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Menba, ôbi ay tôô bi bay ré liji batêm naɲ hini Jésu Krist menba, bay kôli ré wôl sem naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bay jé naɲ bay ayê bôô ka Judé toy wo ɓiɲé ka na Jubɲê ré hen ka pôni kôba, ré toy kwôlo Emen men. ");
INSERT INTO kqp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kiriɲa Piyêr hera Jérusalêm a menba, yênêri Jub kaɲ bay ayê bôô nayri kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Ju ô iyé ɓiɲé ka na Jubɲê ré hen men, ju ôm are naɲ ci a men!» ");
INSERT INTO kqp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Menba, ôbi dôrji tô kwôlê bi wo hen pôn pôn naɲ geréri geréri kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«En mô Jopé a uwôl Emen menba, en gel bô pelal a ani kani geliɲ naɲ kibi bargay ka dami iyôŋ herbo derômaraŋ a tôŋ naɲ kibriji pôrbu kwôy ɗa kwan a. ");
INSERT INTO kqp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","En kôbe bôrji menba, en gel tanare to têre pôrbu men, to noni men, ka erge men, ciré men. ");
INSERT INTO kqp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Menba, en toy tôô kwôni kôlen iyôŋ ba: ‹Piyêr, hena ta, ju duu tanare hende to kêm hen ju ôm.› ");
INSERT INTO kqp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","En uwôli sara iyôŋ ba: ‹En gey ré kwôy Kelma. Wôsa kiriɲ ka en yêɲ na, ani kani ka jôriɲ naɲ ka *kagemi si keben a ré.› ");
INSERT INTO kqp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tôô kwôni hô ôm derômaraŋ a kôl iyôŋ ba: ‹Aŋga Emen kôl ré na ka séli ba, jôbi já kelê ré na ka kagemi ré.› » ");
INSERT INTO kqp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«Are bay ka hen, sa hen iyôŋ têê subu menba, are bay ka kêm hen hô pôriɲ hôriɲ ta derômaraŋ a. ");
INSERT INTO kqp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kiriɲ bay ka hen menba, gawrê subu saji kibi iyére to en môriɲ ya hen, bay joji na Sésaré. ");
INSERT INTO kqp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tunu kôlen ené hena ô naɲ ci ɗiba, ené gaanê ré. Yênêrna bay ayê bôô ka jii ka en eraɲ naɲ ci nà a bên ôriɲ Sésaré a. Menba, nini ô ira kêm iyé Kwôrney a. ");
INSERT INTO kqp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ôbi derêni kwôli *mana wo derômaraŋ a wo ɗiré gili bô iyére tori a aɲ ré kôli iyôŋ ba: ‹Jé gawrê ô Jopé ô uwôga Simô woɲ Piyêr. ");
INSERT INTO kqp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aɲ kwôli aŋga ôbi a dôrem hen na, a bem gelê naɲ ɓiɲé kêm ka bô iyére tom a.› ");
INSERT INTO kqp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kiriɲa ena belê keben tô menba, Tunu toɲ hendi bô bôrê heriɲ sarji a mega wo na heriɲ sarna tumô hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Menba, en erem sa kwôlo Kelma na kôl kôl iyôŋ ba: ‹Ja na liɲ ɓiɲé batêm naɲ kam niɲba, kenbay ba, Emen a lêŋge batêm naɲ Tunu toɲ hendi bô bôrê.› ");
INSERT INTO kqp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hena Emen né ɓu baliyare naɲ ci mega wo ôbi na ɓu naɲ na wôsa bê bôô wona sa Kelma Jésu Krist a hen iyôŋ ba, ena i a ené jôriɲ Emen lê aŋgari ba?» ");
INSERT INTO kqp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kiriɲa bay toy hen iyôŋ menba, bay hô ɗi bôrji jal aɲ ayji kibi Emen kôl iyôŋ ba: «Emen biɲ ɓiɲé ka na Jubɲê ré hen kôba, geré bi ré bul hal woji aɲ ré uwôɲiɲ gelê woɲ tiri hen men.» ");
INSERT INTO kqp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bay tô Jésu ka na useriɲ wô sa gusiɲ to bay gelji cêgi temare to Etiyên a hen na, ôrji kwôy biɲ Pinisi, Sipre naɲ Antiyôk, bay uwôl béré biɲ na Jubɲê mera. ");
INSERT INTO kqp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Niɲba, ka perêrji a ka na ka Sipre a men, Sirên a men, hen kiriɲa sa biɲ Antiyôk menba, bay uwôl béré Kwôlo Dôri wo Kelma Jésu biɲ ɓiɲé ka na Jubɲê ré hen men. ");
INSERT INTO kqp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Néé wo Kelma baa naɲ ci aɲ ɓiɲé ka ay bôrji biɲ Kelma kwône erê tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kwôlê bi wo hen era sa kuriɲ maa bay ayê bôô ka Jérusalêm a aɲ bay jé Barnabas Antiyôk a. ");
INSERT INTO kqp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kiriɲa ôbi sa aɲ gel terê kibi wo Emen tô sa ɓiɲé hen iyôŋ na, yiri dôri damaŋ aɲ ôbi kôlji bay ré ɗi bôrji pôn lêŋniɲ tô Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas bi wo hen, na kwôni wo li aŋgaɲ derôre men, Tunu toɲ hendi bô bôrê wôn bôri men, ayê bôô wori dô a men. Aɲ ɓiɲé kwône bi bôrji sa Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Menba, Barnabas ô Tars a wô wogé Sôl. ");
INSERT INTO kqp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kiriɲa ôbi uwoɲni menba, heraɲ naɲ ɗi Antiyôk a. Bay mô ɓem elê pôn naɲ bay ayê bôô ka Antiyôk a. Bay geliɲ kwônê ɓiɲé are. Na Antiyôk a a bay ré ay tô ɗé hini woɲ Krétiɲê hen sa bay tô Jésu a. ");
INSERT INTO kqp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wulê bi wo hen na, bay kibi Emen hena Jérusalêm a era Antiyôk. ");
INSERT INTO kqp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kwo pôni perêrji a bay uwôgeri Agabus Tunu gili mega kurôŋ wo dami ré lê sa terare a nà. (Aɲ kurôŋ bi wo hen li sa terare a nà tiri a men wulê wo Kulod na ômiɲ kenare hen.) ");
INSERT INTO kqp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bay tô Jésu gengiji ciré lê naɲ yênêrji ka Judé naɲ ari uɲé ka Emen né biji. ");
INSERT INTO kqp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bay wôge are bay ka hen aɲ jéɲ si Barnabas naɲ Sôl ôriɲ biɲ surɲê ka bay ayê bôô ka Judé. ");
INSERT INTO kqp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wulê bi wo hen na, kelma *Hérôd ay tô geliɲ tu bay ayê bôô ka Jérusalêm a gusiɲ. ");
INSERT INTO kqp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ôbi bi bay duu *Jak woɲ yêni Ja hen naɲ yebere. ");
INSERT INTO kqp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aɲ kiriɲa ôbi bô wo yi Jubɲê ré dôrji hen iyôŋ menba, ôbi bi bay ɓu Piyêr. Wulê bi wo hen na, na sa lê geserê mapa wo wubere naɲ bô a hen. ");
INSERT INTO kqp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hérôd bi bay ɓu Piyêr ô uwôli daŋgay a aɲ biɲ asgarɲê pôrbu, pôrbu gwogelérji pôrbu ɗebu gemni. Aɲ cêgi *Pak a dema ciré jerê kwôlê sari a tumô ɓiɲé tô. ");
INSERT INTO kqp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piyêr yi daŋgay a menba, bay ayê bôô uwôl Emen yôôd naɲ bôô pôn wô sari. ");
INSERT INTO kqp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bô yoyre hende to kiya Hérôd ɗa jôriɲ kwôlê sari a hen na, bay harêri naɲ musure aɲ ôbi yi kum derô asgarɲê wôô men, bay gemé kibi geré ɗebu gem men. ");
INSERT INTO kqp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Niɲba, kiriɲ bay ka hen na, mana wo Kelma so menba, iyéy daŋgay peraŋge. Mana wo Kelma bi wo hen di kwa bô Piyêr aɲ eŋni aɲ kôli iyôŋ ba: «Hena ta, lew.» Kiriɲ bay ka hen na, musure beseriɲ kôbri a. ");
INSERT INTO kqp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aɲ mana bi wo hen kôli iyôŋ ba: «Ha tô bôm men, ha gaŋgi garbê kam a men.» Ôbi li hen iyôŋ hende to hen menba, mana bi wo hen hô kôli iyôŋ ba: «Dôbe bargay kam kaɲ kelanê aɲ ju era tôn a nà.» ");
INSERT INTO kqp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyêr so tôri a niɲba, ôbi bô môɲ ré na pelal a ré jôri hen ɗiba, ré na aŋgaɲ tiri ré. ");
INSERT INTO kqp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bay saa asgarɲê ka gem kibi geré hen kini wôô kara, menba, saji kibi geré woɲ musure a wo si kini derô iyére hen, menba, kibi geré bi wo hen bôliɲ sa kibri tumôrji a mera. Kiriɲa bay si nô niɲ menba, bay ô sem tô geré menba, mana wo Kelma bi wo hen ɗéɲ Piyêr. ");
INSERT INTO kqp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tini uwo yiri a aɲ ôbi kôl iyôŋ ba: «Haw hen, en hôn niɲ, na tiri, na Kelma a jo mana wori sa dôren kibi néé wo Hérôd a men, kibi habrê kêm wo Jubɲê genge ré sa san a hen a men.» ");
INSERT INTO kqp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kiriɲa ôbi hôn aŋga ré li are hen iyôŋ niɲ menba, ôbi ô iyé Mari toɲ yoo Ja wo bay uwôgeri Mark hen, ɓiɲé kwône mô uwôl Emen ya. ");
INSERT INTO kqp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kiriɲa ôbi di kibi geré menba, hende jé to pôni bay uwôgere Rodé so era wô belê kermiɲ. ");
INSERT INTO kqp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hende toy tôô Piyêr hôn aɲ wo ré bôl kibi kermiɲ biri na, yi derê lere aɲ hende ge ô kelê Piyêr ré ɗebu kibi geré yaŋ ya. ");
INSERT INTO kqp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bay kôle iyôŋ ba: «Mu gal.» Niɲba, hende kôlji wo ré na tiri. Aɲ bay kôl iyôŋ ba: «Na *mana wo derômaraŋ a woɲ ôbi geméri.» ");
INSERT INTO kqp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyêr hô di kibi kermiɲ menba, bay sa bôl menba, na ôbi menba, tiniji ge kay. ");
INSERT INTO kqp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ôbi liji kôbri bay ré wôm tôŋ menba, ôbi dôrji kwôli derê wo Kelma ré dôri bô daŋgay a aɲ ôbi kôlji iyôŋ ba: «Erêŋge ken ô kôliɲ Jak naɲ bay ayê bôô kêm.» Menba, ôbi si ɓu geré ô kiriɲ ka ɗaŋgi a. ");
INSERT INTO kqp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kiriɲa kiriɲ wôl menba, harê li asgarɲê damaŋ aɲ bay eŋgere aŋga ré sa sa Piyêr a hen. ");
INSERT INTO kqp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hérôd bi bay wogeri niɲba, bay uwoɲni ré. Menba, ôbi bi bay eŋgeriɲ asgarɲê ka na gem kibi geré hen kwôlê aɲ ôbi kôl bay ré derji. Menba, Hérôd hena Judé era Sésaré aɲ uwôl ya nêm kwôlê. ");
INSERT INTO kqp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hérôd ôriɲ naɲ kwôlê naɲ ɓiɲé ka Tir a men, ka Sidôn a a men. Bay way ciré jé ɓiɲé yiri a, wôsa bay hôn wo tô kibri wo bay uwôgeri Blastus hen ré gey bi ɗiré lê naɲ ci bi bay ré ɲan kwôlê woji bi wo hen naɲ bô jalê. Wôsa are kêm ka bay ôriɲ doyriji hen na, hena na sa iyére tori a. ");
INSERT INTO kqp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Menba, wulê wo bay genge hen na, Hérôd tôbe bargay kari kaɲ kenare aɲ mô sa gagay kenare a aɲ dôrji kwôlê tu wolé. ");
INSERT INTO kqp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Menba, ɓiɲé kôl iyôŋ ba: «Na emen a kelê kwôlê hen ɗiba, na gawra ré.» ");
INSERT INTO kqp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kiriɲ bay ka hen na, mana wo Kelma di Hérôd wôsa ôbi ay damɲare to Emen liɲ tori, menba, wôŋne ômni aɲ aɲ ôbi ma. ");
INSERT INTO kqp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Niɲba, kwôlo Emen ba, ôm ôriɲ naɲ kwini tumô tumô. ");
INSERT INTO kqp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kiriɲa si Barnabas naɲ Sôl liji jé wo bay joji Jérusalêm a hen kô niɲ na, bay bul hô Antiyôk a, bay heraɲ naɲ Ja woɲ Mark hen kôbriji a. ");
INSERT INTO kqp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Perê bay ayê bôô ka Antiyôk a na, bay kibi Emen ya men, bay gelé are kôba ya a men, hiniji a na: Barnabas, Siméɲôn wo ba uwôgeri gawra wo hendi hen men, Lusiyus wo Sirên men, Manayen wo na melaɲ *Hérôd woɲ kelma kiriɲa ôbi na baɲ kema hen men, Sôl men. ");
INSERT INTO kqp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wulê wo pôni kiriɲa bay tebe Kelma jôriɲ bôrji kurôŋ menba, Tunu toɲ hendi bô bôrê kôl iyôŋ ba: «Terêŋge si Barnabas naɲ Sôl ken ɗiji gay ben wô jé wo en uwôgeji kwôli hen.» ");
INSERT INTO kqp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kiriɲa bay jôriɲ bôrji kurôŋ men, uwôl Emen a men kô niɲ menba, bay uwôl kôbriji sarji a aɲ ɗiji ô. ");
INSERT INTO kqp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kiriɲa si Barnabas naɲ Sôl bô wo Tunu toɲ hendi bô bôrê a ré jéji ulê béré hen iyôŋ na, bay henaji Antiyôk eraji Sélesi a wô ayêji bato ôriɲ iyére to derô cér to bay uwôgere Sipre hen. ");
INSERT INTO kqp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kiriɲa bay sa biɲ Salmin Sipre a menba, bay uwôl béré kwôlo Emen bô *iyéy daɲare to Jubɲê. Bay ôriɲ naɲ Ja Mark kôbriji a bi ré li naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kiriɲa bay ô naɲ kiriɲ kiriɲ sa iyére to derô cér a hen kwôy saɲ Papôs a menba, bay uwôɲ ôbi beli wo li yiri môɲ *ôbi kibi Emen iyôŋ, ôbi na Jub, hini ôm Bar-Jésu, aɲ naɲ kibi grêk ba na Elimas. ");
INSERT INTO kqp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ôbi na melaɲ Sêrgiyus Pawlus ôbi emê sa iyére to derô cér a hen, Sêrgiyus bi wo hen na, na ôbi tu melênê, ôbi jé uwôga si Barnabas naɲ Sôl wôsa ôbi ôriɲ doy toyé béré kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Niɲba, Elimas woɲ beli hen jibji sêd aɲ woge wô jôriɲ kelma ré bi bôri sa Jésu a. ");
INSERT INTO kqp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Menba, Tunu toɲ hendi bô bôrê wôn bô Sôl wo na Pol hen aɲ ôbi bôri ");
INSERT INTO kqp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aɲ kôli iyôŋ ba: «Jôbi na, gwosore naɲ habrê wôn bôm, kema Sidan, ôbi bayi aŋga dôri, ɗi mênê geré aŋga Kelma genge hen baa. ");
INSERT INTO kqp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ju toy, haw hen Kelma a dêm aɲ tum a dôbê hendé aɲ já gelé berarê tare ré sem.» Kiriɲ bay ka hen na, tiri dôbe hendu aɲ ôbi mô bô dilemne a aɲ ôbi bul si na si na woge kwôni bi ré ɓu kôbri. ");
INSERT INTO kqp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kiriɲa kelma gel are bay ka hen iyôŋ menba, ôbi ay bôri wôsa ari gelé ka gengiɲ sa Kelma dô tini. ");
INSERT INTO kqp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol naɲ megêri ɗayji bato Papôs a wô erê Pêrgé bô emê wo Pampili a. Menba, Ja Mark ɗiji ya hen aɲ bul hô Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bay hena Pêrgé ayji geré kwôy saɲ biɲ Antiyôk bô emê wo Pisidi a. Naɲ *sa merê ta a menba, bay ô bô iyéy daɲare a aɲ môrji tôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kiriɲa bay dêŋse magtubu tôô naɲ to bay kibi Emen menba, bay sa iyéy daɲare hende to hen, jé kôlji iyôŋ ba: «Yênêrni, hena kwôlê woɲ dôbê ibiyare wôni ya a kené gey kôliɲ ɓiɲé ba, ken kôl.» ");
INSERT INTO kqp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Menba, Pol hena li kôbri bi bay ré wôm tôŋ aɲ kôl iyôŋ ba: «Kam *Israyêl naɲ kenbay ka ba hen ka ken tebe Emen hen, toyéŋge. ");
INSERT INTO kqp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Emen wo ɓiɲé ka Israyêl na tô môɲêrna. Men, ôbi biji bay yêɲ kwône sa iyé Ejipt a, aɲ naɲ néé wori na, ôbi dôrji siɲ aɲ a men. ");
INSERT INTO kqp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ôbi uwôl bôri sarji a derô gwôlê li elê tôre pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ôbi bi bay mêne tô yê ɓiɲé jurgem bô emê wo Kanan a na, ôbi biɲ ɓiɲé kari sa iyére toji bay liɲ toji. ");
INSERT INTO kqp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Are bay ka kêm hen li elê arew pôrbu naɲ tôre bay. Cêgeri wori menba, ôbi biji bay jerê kwôlê kwôy saɲ sa Samiyêl ôbi kibi Emen a. ");
INSERT INTO kqp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Menba, bay gey ôbi ré biji kelma menba, Emen biji Sawul kema Kis môɲ wo Bênjamin ôbi ôm kenare li elê tôre pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kiriɲa Emen kaɲ Sawul na, ôbi biji Dabid mega Kelma woji. Na wô sari ôbi a na ré kôl kwôli kôl iyôŋ ba: ‹Dabid kema Jésé na na kwôni wo en diini, ôbi a lê are kêm ka bôn gey hen.› ");
INSERT INTO kqp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuŋga Dabid wo pôni na Jésu wo Emen ɗiri mega ôbi gôliɲ naɲ kam Israyêl wo ôbi na ay tôri ɗiré biji hen. ");
INSERT INTO kqp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pa dema Jésu ré saɲ tô na, Ja na uwôl béré biɲ kam Israyêl kêm ré ɗi tô têriɲ toji aɲ ré liji batêm. ");
INSERT INTO kqp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kiriɲa ôbi duu kibi jé wori niɲ menba, kôl iyôŋ ba: ‹Ken kôl ené na i ba? Ena kwo ken mô gemni hen ré tô. Niɲba, gel ôbi era cêgena hen ya, en nêm beseré gaŋgi garbê kaɲ têri ré.› » ");
INSERT INTO kqp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Yênên, kenbay kaɲ kwôŋgê *Abraham naɲ ɓiɲé kêm ka sa iyére to ɗaŋgi a ka mô tebe Emen hen kôba, kwôli gelê bi wo hen na, Emen gengiɲ na sarna nabay tumô. ");
INSERT INTO kqp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ɓiɲé ka Jérusalêm naɲ kilmérji hôn Jésu ré na i ba ré, aɲa bay ré ɗi kwôli temare ɓu sari hen. Bay dêŋse magtubu to bay kibi Emen naɲ sa merê ta a kwôy kwôy niɲba, bay hôn bôre ré. Aɲ ulê wo bay uwôl kwôlê sa Jésu hen na, bay li na aŋga magtubu to bay kibi Emen na kôl hen. ");
INSERT INTO kqp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bay uwôɲ kwôlê wôni wo nêm temayri ré, niɲba, bay kôliɲ *Pilat ré bi bay ré diri. ");
INSERT INTO kqp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aɲ kiriɲa bay li are kêm ka magtubu to Emen na kôl gengiɲ sari hen niɲ na, bay tôri derari sa gurô tagelê ô emé. ");
INSERT INTO kqp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Niɲba, Emen biri ji si kamɲê. ");
INSERT INTO kqp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aɲ wulê kwône ôbi si sa ka na bari henaɲ Galilé eraɲ Jérusalêm a hen, bay a na bay kelê kwôli haw hen biɲ kam Israyêl. ");
INSERT INTO kqp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nibay kôba, nini ulêŋge béré Kwôlo Dôri bi wo hen na kaɲ tôô to Emen na ay biɲ môɲêrna hen. ");
INSERT INTO kqp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ôbi li ariri béna nabay kwôŋgêri, kiriɲa ôbi biɲ Jésu ji si mega wo na liɲ bô kurôŋ wo jôgiɲ wôô bô magtubu kurôŋ a kôl iyôŋ ba: ‹Jôbi a na Keman aɲ kemnêŋ nôbi ena Ibam.› ");
INSERT INTO kqp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Emen na kôl ɗiré biɲ Jésu ré jê sé kamɲê ɗiba, ré hô ma a ré niɲ. Na ôbi á, ôbi na ré kôl iyôŋ ba: ‹Na béŋge aŋga yi naɲ jeŋgêrji naɲ kaɲ tiri ka nôbi na en genge ené biɲ Dabid hen.› ");
INSERT INTO kqp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na ôbi á, ôbi ré kôl bô magtubu to ɗaŋgi a kôl iyôŋ ba: ‹Já ɗé mana wom wo yi naɲ jeŋgêri hen uyê kamɲê ré.› ");
INSERT INTO kqp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ken hôn, bô wulê bi wo hen na, Dabid na li bô geyé wo Emen. Aɲ kiriɲa, ôbi ma aɲ bay ayri ô emé kwa môɲêri a aɲ ôbi uyê. ");
INSERT INTO kqp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Niɲba, kwo Emen biri ji si kamɲê hen na, uyê ré. ");
INSERT INTO kqp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Yênên, henêŋge mega wo ré na sa kibi Jésu aɲa béré ɗé bôô jalê sa têriɲ a ré uwôliɲ hen. Men, na na sa kibri aɲa i i wo ré bi bôri sari a ba, têriɲ tori kêm to tôô to *Moyis na nêm derê sarŋge a ré hen réé dôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Berêŋge dô wô kwôlo bay kibi Emen na kôl hen na, bi arirji sa sarŋge a ré. Bay na kôl kwôliji kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Toyéŋge kenbay kaɲ bay uwôyrê yi kaɲ bay kelê kwôlo habiɲ gengiɲ sa kwôlo Emen kôl hen. Na lê are ka gelé, are bay ka na lê hen na, hena kwôni ré derêŋge kwôliji kôba, ka bê bôrŋge sara ré. Kiriɲa ken ba geɲ tô hen na, are bay ka hen a lê aɲ tunuŋge geré kayê aɲ ka erê aɲ.› » ");
INSERT INTO kqp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kiriɲa si Pol naɲ Barnabas soji nô bô *iyéy daɲare a menba, bay uwôlji bi bay ré hô dôrji kwôlê bi wo hen hôriɲ sa merê to cêgê. ");
INSERT INTO kqp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cêgi daɲare a menba, Jubɲê kwône naɲ ɓiɲé ka bi bôrji sa tôô to Jubɲê hen ôrji tô si Pol naɲ Barnabas aɲ si Pol naɲ Barnabas iyêl naɲ ci men, bay dôbji ibiyare bôrji a men bi bay ré lêŋnê tô bô derê wo Emen a men. ");
INSERT INTO kqp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Naɲ sa merê ta to ɗaŋgi a menba, ɓiɲé ka derô ira kêm era wô toyé Kwôlo Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kiriɲa Jubɲê gel wo ɓiɲé era kwône hen iyôŋ menba, terbére liji aɲ bay gage kwôlo si Pol aɲ bay tiréri. ");
INSERT INTO kqp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Si Pol naɲ Barnabas kôlji naɲ ibiyare kôl iyôŋ ba: «Béré kwôlo Emen bi wo hen, ré uwôliɲ béŋge na kenbay tumô. Niɲba, mega wo ken kaɲ kwôlê bi wo hen aɲ ken bô yerŋge mega wo kené nêm uɲé gelê wo naɲ kwini ré hen iyôŋ niɲ na, niɲa erê uɲé ɓiɲé ka iyére to ɗaŋgi a. ");
INSERT INTO kqp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wôsa Kelma ay tôô béni kôl iyôŋ ba: ‹En ɗém môɲ kiriɲ ka peraŋgi iyôŋ biɲ tô yê ɓiɲé ka sa terare a nà, wô ulê béré kwôlê woɲ gelê biɲ ɓiɲé kêm gôriɲ kiriɲ sa terare a nà.› » ");
INSERT INTO kqp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kiriɲa ɓiɲé ka iyére to ɗaŋgi hende to hen toy hen iyôŋ menba, bay li yi derê men, ay kibi kwôlo Kelma men, aɲ ka gelê wo naɲ kwini na yi wô sarji hen na, ayji bôrji kêm. ");
INSERT INTO kqp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Béré kwôlo Kelma ôm naɲ kiriɲ kiriɲ sa ira kêm. ");
INSERT INTO kqp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Menba, Jubɲê gwôse yébé ka tebe Emen ka balêrji na ka damné hen naɲ damné bi bay kôl bay ré liɲ si Pol naɲ Barnabas habrê men, bay ré dageji sa iyére toji a a men. ");
INSERT INTO kqp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Si Pol naɲ Barnabas yebageji beni têrji sarji a aɲ ɗiɲ yirji ô Ikôniyôm a. ");
INSERT INTO kqp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bay tô Jésu ka Antiyôk a yirji dôrji men, Tunu toɲ hendi bô bôrê wôn bôrji a men. ");
INSERT INTO kqp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikôniyôm a kôba, si Pol naɲ Barnabas ôrji *iyéy daɲare to Jubɲê aɲ dôrji kwôlê aɲ li wo, Jubɲê naɲ ɓiɲé ka na Jubɲê ré hen a kwône ay bôrji. ");
INSERT INTO kqp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Niɲba, Jubɲê ka kaɲ kwôlê woji bi wo hen na, gwôseji ɓiɲé ka na Jubɲê ré hen, ré liɲ bay ayê bôô habrê. ");
INSERT INTO kqp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Si Pol naɲ Barnabas wôl gaɲ Ikôniyôm a men, bay uwôl béré kwôlo Emen naɲ ibiyare men, wôsa bay bi bôrji sa Kelma menba, ôbi biji néé bay liɲ aŋgaɲ giɲê naɲ kaɲ gelé. Aɲ gel wo béré kwôlê woɲ bô derê bi wo bay ré uwôl hen na, ré na tiri. ");
INSERT INTO kqp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Aɲ li wo ɓiɲé ka Ikôniyôm a bay ka hen kariɲ kiriɲ wôô: ka pôni ô tô Jubɲê men, ka pôni ô tô bay jé men. ");
INSERT INTO kqp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jubɲê naɲ ka na Jub ré hen naɲ kilmérji genge ciré geliɲ si Pol naɲ Barnabas gusiɲ men, ciré gôbêji deré a men. ");
INSERT INTO kqp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kiriɲa si Pol naɲ Barnabas toy hen iyôŋ menba, bay ge si sa iyé Listre a men, Dêrb a men ka bô emê wo Likaniya naɲ sa iyére to mérji hen. ");
INSERT INTO kqp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aɲ bay uwôl béré Kwôlo Dôri wo Emen ya. ");
INSERT INTO kqp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listre a na, gawra wo pôni na ôbi merayê mô ya, wôsa têri meray wôô ɓem naɲ kamɲêri yeŋ, aɲ nêm ɗebé ta ré. ");
INSERT INTO kqp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wulê wo pôni ôbi toy Pol dô kwôlê. Menba, Pol bôri ɗéɲ tiri a, aɲ bô wo ôbi bi bôri sa Emen a mega wo ré berarêri. ");
INSERT INTO kqp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Menba, Pol kôli naɲ tôri to dami kôl iyôŋ ba: «Hena, ju ɗebu ta naɲ têm!» Ôbi hena neŋgere aɲ ô ta. ");
INSERT INTO kqp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kiriɲa kwônê ɓiɲé gel aŋga Pol li hen iyôŋ menba, bay kôl naɲ kibi kwôlê woji Likawniɲê kôl iyôŋ ba: «Kamrê bul yirji gawrê aɲ herbiji sarna.» ");
INSERT INTO kqp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Menba, bay uwôge Barnabas «Jês» men, Pol «Hêrmês» men, wôsa Pol a na ôbi kibriji. ");
INSERT INTO kqp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ôbi tibé kamrê Jês ka iyéyrerji ɗiɲ cêd kibi kalmê hen, bi bay ôriɲ naɲ kelbê ka bay elageji naɲ béé gurô bi ré li manare hen, nô wolé naɲ iyére, wôsa ôbi gey bi ɓiɲé ré li sarga biɲ si Pol naɲ Barnabas. ");
INSERT INTO kqp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kiriɲa bay jé Barnabas naɲ Pol toy hen iyôŋ menba, bay yêgerê bargay kaji aɲ gerji ô ligi ɓiɲé kariɲ gura kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Milɲérni, wô mi a kené li hen iyôŋ ba? Nibay kôba niné gawrê mega kenbay hen iyôŋ men. Béré Kwôlo Dôri wo nini uwôl béŋge hen na, na wo kené ɗi tô kamrê kaɲ ɗéɲ iyôŋ bay ka hen aɲ, aɲ kené bul uɲé Emen woɲ ôbi merê tu geɲ men, ôbi ɗé derômaraŋ naɲ sa terare men, cér naɲ aŋga kêm ka yi ya hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wulê wo na tumô hen na, Emen na ɗi ɓiɲé i i ba, na ay geré wori geré wori, ");
INSERT INTO kqp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","niɲba, ôbi na gelji yiri naɲ bô derê wori kwôy kwôy wôsa ôbi bi emen uwôŋge men, kaw naɲ geserêri geserêri a men. Na tiri ôbi a béŋge emê naɲ kwônêri men, bi yi derê wôn bôrŋge a men.» ");
INSERT INTO kqp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kwôlê bi wo Pol dôrji hen kôba, bay naɲ Barnabas li kôbriji a kôbriji a dema bay ré jôriɲ ɓiɲé bi ré li sarga biji tô. ");
INSERT INTO kqp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Cêgi are bay ka hen na, Jubɲê ka hena Antiyôk bô emê wo Pisidi a naɲ Ikôniyôm eraji sa gwôse ɓiɲé aɲ bay gôbe Pol naɲ keram kuu aɲ wuréri ô ulê wolé naɲ iyére aɲ bay kôl yaŋ ba ôbi ré ma niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Niɲba, kiriɲa bay ayê bôô daɲ sari a menba, ôbi hena ta, aɲ hô derô ira. Kiriɲ wôl menba, bay ôrji naɲ Barnabas Dêrb a. ");
INSERT INTO kqp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kiriɲa si Pol naɲ Barnabas uwôl béré Kwôlo Dôri Dêrb a aɲ ɓiɲé kwône bi bôrji sa Jésu hen iyôŋ menba, bay bulo hera si Listre, Ikôniyôm a naɲ Antiyôk bô emê Pisidi a. ");
INSERT INTO kqp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aɲ kiriɲ kêm ka bay ô ya hen na, bay dôbji ibiyare bô bay ayê bôô a bi bay ré lêŋnê tô ayê bôô woji a men, bay kôlji iyôŋ ba: «Naa geliɲ gusiɲ gaɲ dem aɲa nana sé bô *emê iyére to Emen a tô.» ");
INSERT INTO kqp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bô églis a pôn pôn na, bay tô surɲê biji men, uwôlji Emen men, jôriɲ bôrji kurôŋ a men, aɲ bay biji kôbi Kelma wo bay bi bôrji sari a hen. ");
INSERT INTO kqp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kiriɲ bay ka hen na, bay so si bô emê wo Pisidi a aɲ saji biɲ Pampili. ");
INSERT INTO kqp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bay uwôl béré kwôlo Emen Pêrgé a aɲ ôrji Ataliya a. ");
INSERT INTO kqp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kiriɲ bay ka hen na, bay ɗay bô bato wô herê Antiyôk bô emê wo Siri a kiriɲ ka bay na henaɲ ya hen men, na kiriɲ bay ka hen a a bay na ré ɗiji naɲ bô derê wo Emen wô jé wo bay la hen men hen. ");
INSERT INTO kqp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kiriɲa bay biɲ menba, bay day bay ayê bôô aɲ dôrji kwôli are kêm ka Emen ré li naɲ geré woji hen men, wô belê wo ôbi ré bôl kibi geré biɲ ɓiɲé ka na Jubɲê ré hen bi bay kôba ré bi bôrji sari a men hen. ");
INSERT INTO kqp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Menba, bay wôl gaɲ naɲ bay ayê bôô. ");
INSERT INTO kqp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɓiɲé ka pôni hena Judé era Antiyôk a. Bay geliɲ bay ayê bôô are aɲ kôlji iyôŋ ba: «Hena kené wal keŋ môɲ wo tôô to *Moyis kôl hen iyôŋ ré ba, ka uɲé gelê ré.» ");
INSERT INTO kqp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Si Pol naɲ Barnabas nariɲ naɲ ci sa kwôlê woji bi wo hen a. Bay nariɲ kwôlê damaŋ sara. Bay genge bi Pol, Barnabas naɲ bay ayê bôô ka pôni ka Antiyôk ré ôrji Jérusalêm a ô uɲé bay jé naɲ surɲê wô sa kwôlê bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bay ayê bôô ka Antiyôk a ɗiji geré. Si Pol naɲ megêri siji si Pinisi naɲ Samari aɲ dôrji kwôli bilé wo ɓiɲé ka sa iyére to ɗaŋgi a bul uwôɲ Emen hen menba, yi bay ayê bôô bay ka hen dôrji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kiriɲa bay biɲ Jérusalêm a menba, bay ayê bôô naɲ bay jé naɲ surɲê ɓerji a yirji a menba, si Pol naɲ megêri dôrji kwôli aŋga Emen né li naɲ geré woji hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Parisiɲêɲê ka pôni ka ay bôrji hen na, kôlji iyôŋ ba: «Kôliɲge ɓiɲé ka na Jubɲê ré hen ré wal keŋ men, ré bi kwôlê sa tôô to Moyis a a men.» ");
INSERT INTO kqp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bay jé naɲ surɲê daɲji wô kebê kwôlê bi wo hen gelé. ");
INSERT INTO kqp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kiriɲa bay nariɲ kwôlê uwoy gaɲ hen iyôŋ menba, Piyêr hena aɲ kôl iyôŋ ba: «Yênên, ken hôn, Emen na dôren perêrŋge a na ca yeŋ bi ené uwôl béré Kwôlo Dôri biɲ ɓiɲé ka na Jubɲê ré hen bi bay ré toy aɲ ré biɲ bôrji sara. ");
INSERT INTO kqp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Emen bi wo hôn bô gawrê hen na, ôbi gel wo ɗiré geyji aɲ biji Tunu toɲ hendi bô bôrê mega wo na béna nabay hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɗiba ôbi dô tirji dê iyôŋ gay naɲ na ré, na naɲ ayê bôô woji a ôbi ré biji yiɲ ɓiɲé ka séli hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Iyôŋ niɲ ba, wô mi a kené cubu tu Emen ayiɲ aŋga néy bay ka môɲêrna na nêm ayê ré men, nabay kôba nana nêm ayê ré men hen ɗé sa bay ayê bôô ba? ");
INSERT INTO kqp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nana bi bôrna mega wo nana uɲé gelê naɲ bô derê wo Kelma Jésu môɲ wo bay kôba, uwôɲiɲ gelê hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kiriɲa Piyêr dô kwôlê bi wo hen iyôŋ menba, bay wôm sidiŋ, menba, bay toy si Pol naɲ Barnabas dôrji kwôli giɲê naɲ aŋgaɲ gelé ka Emen né biji ciré li perê ɓiɲé ka na Jubɲê ré hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kiriɲa bay iyêl kô niɲ menba, *Jak kôl kwôlê kôl iyôŋ ba: «Yênên, toyéŋge kwôlo na kelê hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simô kelêna haw, na wô terê wo Emen na ré tô ɓiɲé kari tumô perê ɓiɲé ka na Jubɲê ré hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kwôli are bay ka hen na, biɲ naɲ kwôlo bay kibi Emen na kôl kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Cêgi are bay ka hen menba, na hô hera ɗé iyé Dabid to tiɲ hen ta. Hôlmêre wo baa hen na, na herê ɗére hôriɲ men, na hô ɲanêre ta derê a men. ");
INSERT INTO kqp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kiriɲ bay ka hen na, tô ɓiɲé ka sa terare a ka baa hen a wogéji Kelma. Na tiri, tô yê ɓiɲé kêm ka na en uwôgeji ré yi kaɲê hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Gel, na kwôlo Kelma kôl bi a na, ôbi na bi are bay ka hen hôniɲ ca yeŋ.› ");
INSERT INTO kqp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Na ôbi á, ené gey bi nana dayrê aŋga néy ɗi sa ɓiɲé ka na Jubɲê ré ka bul uɲé Emen hen né. ");
INSERT INTO kqp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Na lêŋge magtubu biji mera kôlji bi bay ré ôm tanare to bay tibiɲ kamrê hen ré men, bay ré yiɲ yiɲare toɲ têriɲ ré men, tanare to kwôbe biɲ tôŋ né hen né men, kwôbe ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ca wo balê yeŋ na, ɓiɲé dêŋsêrê tôô to Moyis *sa merê ta a kwôy kwôy bô *iyéy daɲare a, naɲ sa iyére iyére.» Jak kôl kwôlê bi wo hen iyôŋ wôsa tôô to Moyis to jô are bay ka hen na, ɓiɲé hôn ca yeŋ. ");
INSERT INTO kqp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Menba, bay jé naɲ surɲê naɲ bay ayê bôô kêm biɲji bi ciré tô gawrê perêrji a hen, jéji Antiyôk a naɲ si Pol naɲ Barnabas. Bay tô si Jud woɲ Barsabas naɲ Silas bay na ɓiɲé ka bay ayê bôô kêm biji kwôlê men, geyji men. ");
INSERT INTO kqp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bay biji magtubu hende to hen kôl iyôŋ ba: «Bay jé naɲ surɲê naɲ bay ayê bôô kêm liɲ bay ayê bôô ka na Jubɲê ré ka Antiyôk men, ka Siri a naɲ ka Silisi a dosé. ");
INSERT INTO kqp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nini toy mega wo yênêrni ka pôni ré ô dôyrêŋge men, ré mêne ermé woŋge a men, naɲ kwôli kelêrji, niɲba, na nibay a jéji ré. ");
INSERT INTO kqp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Na ôbi á, niné kôliɲ kaɲnini wô terê ɓiɲé aɲ jéji yerŋge a naɲ yênêrni si Pol naɲ Barnabas, ");
INSERT INTO kqp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ka ay yirji uwôl aɲ wô sa hini Kelma Jésu Krist hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nini jé si Jud naɲ Silas bi ré ô kelêŋge naɲ kibriji a, kwôlo nini li bô magtubu a hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wôsa Tunu toɲ hendi bô bôrê men, nibay men, nini genge bi niné ɗéŋge ani kani ka néy sa ka ré liɲ hen a ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Aŋga nini kôl kwôliji bô magtubu hende to hen a na: Emê tanare to bay tibiɲ kamrê ré men, emê kwôbe ré men, lari ka bay gwôse tôrji hen né men, yiɲ yiɲare toɲ têriɲ hen né a men. Hena kené pô yerŋge aɲ yi are bay ka hen a na, ken li dô. Dosé toɲ yêniɲare.» ");
INSERT INTO kqp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bay ɗi bay jé kaji bay ka hen geré ôrji, aɲ bay sa biɲ Antiyôk a aɲ bay day bay ayê bôô kêm aɲ biji magtubu hende to hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kiriɲa bay dêŋse na, yirji dôrji damaŋ wô ibiyare to magtubu hende to hen dôbji bôrji a hen. ");
INSERT INTO kqp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mega wo si Jud naɲ Silas kôba, na bay kibi Emen men hen iyôŋ na, bay dôrji kwôlê damaŋ dôbiɲ ibiyare bôrji a men, geriɲji a men. ");
INSERT INTO kqp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bay wôl naɲ ci sem menba, bay ɗiji geré hô uɲé ka na joji hen naɲ derêri.  ");
INSERT INTO kqp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Niɲba, Silas genge ɗiré baa tôŋ aɲ na Jud pini a herê Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Menba, si Pol naɲ Barnabas môrji Antiyôk a. Bay naɲ ka ɗaŋgi kwône geliɲ ɓiɲé are men, uwôliɲ béré Kwôlo Dôri wo Kelma a men. ");
INSERT INTO kqp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sem cêgê menba, Pol kôliɲ Barnabas iyôŋ ba: «Na hô ô gelé yênêrna ka sa iyére to pôn pôn to na nana uwôliɲ béré kwôlo Kelma ya hen. Aɲ na ô gelé na ba, bay yi iyeŋ pôn ba?» ");
INSERT INTO kqp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas gey bi Ja woɲ Mark hen ré ô naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Niɲba, Pol gey bi ôbi ré ô naɲ ci ré, wôsa ôbi na ɗoji aɲ Pampili a tumô men, na ô naɲ ci kini jé woji a cêgê ré niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kwôli Ja bi wo hen li, aɲ nariɲare to dami yi perêrji a aɲ bay kariɲ aɲ i ba ô naɲ kwa wori kwa wori. Barnabas ay Mark naɲ ɗi ôriɲ Sipre a men, ");
INSERT INTO kqp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol ay Silas naɲ ɗi, aɲ kiriɲa bay ayê bôô uwôl Emen bi ré tô kibri sari a menba, bay ô haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bay ô bô emê wo Siri a men, Silisi a a men aɲ dôbiɲ ibiyare bô bay ayê bôô a tô ayê bôô woji a. ");
INSERT INTO kqp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol sa biɲ Dêrb a men, Listre a a men. Kiriɲ bay ka hen na, ôbi ayê bôô wo pôni bay uwôgeri Timoté, yori na Jub to ay bôre men, ibari na Grêk men. ");
INSERT INTO kqp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kwôli ôm dô perê bay ayê bôô ka Listre a men, ka Ikôniyôm a a men. ");
INSERT INTO kqp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol gey ayêri bi ré ô naɲ ɗi. Ôbi wali keŋ wô Jubɲê ka mô sa iyére hende to hen a, wôsa bay hôn kêm wo ibari ré na Grêk. ");
INSERT INTO kqp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sa iyére to si Pol naɲ Silas ô ya ya hen na, bay dôriɲ ɓiɲé tôô to bay jé naɲ surɲê na ay Jérusalêm a, aɲ bay kôlji bay ré bi kwôlê sara. ");
INSERT INTO kqp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bay ayê bôô uwôɲ nérji tô bê bôô woji a men, kwônêrji erê tumô naɲ wulê wulê a men. ");
INSERT INTO kqp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tunu toɲ hendi bô bôrê jô bi si Pol naɲ Silas ré uwôl béré Kwôlo Dôri Asi a menba, bay soji si kiriɲ ka yi perê Priji a naɲ Galati a hen. ");
INSERT INTO kqp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kiriɲa bay baa ɗa naɲ Misi a menba, bay woge ciré erê Bitini a, niɲba, Tini Jésu jôrji. ");
INSERT INTO kqp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bay so si Misi a wô erê Trowas a. ");
INSERT INTO kqp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pelal jô Pol yoyre to pôni a menba, ôbi gel gawra wo Maséduwan wo pôni ɗebu ta tumôri a aɲ uwôli kôl iyôŋ ba: «Era Maséduwan, ju sa li naɲ ni men.» ");
INSERT INTO kqp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Peraŋ cêgi pelal bi wo hen menba, nini woge geré wô erê Maséduwan a, wôsa nini hôn wo ré na Emen a ré uwôgêni bi niné ulê béré Kwôlo Dôri biɲ ɓiɲé ka Maséduwan a hen. ");
INSERT INTO kqp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nini hena Trowas a ay bato ôriɲ sa iyére to derô cér a to bay uwôgere Samotras hen. Kiriɲa kiriɲ wôl cêgê menba, nini sa biɲ Néyapolis. ");
INSERT INTO kqp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Menba, nini ô Pilip a to na iyére to Rômêɲê ôm men, na kibi iyére to tumô bô emê wo Maséduwan a men, aɲ nini wôl gaɲ ya. ");
INSERT INTO kqp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Naɲ *sa merê ta a menba, nini séɲ wolé ô kibi cér a kiriɲ ka nini kôl yaŋ ba niné uɲé kiriɲ ka Jubɲê ré uwôliɲ Emen ya, nini mô tôŋ iyêl naɲ yébé ka daɲ kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iyore to pôni perêrji a hen bay uwôgere Lidi, hende na iyore to Tiyatir men, na hendi ɗé gara bargay ka gararji mê mê hen men, na hendi tibé Emen a men. Kelma bôl bôre aɲ hende dôbe mare toyiɲ kwôlo Pol dô. ");
INSERT INTO kqp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bay lere batêm naɲ ɓiɲé ka bô iyére tore a kêm menba, hende uwôgêni iyôŋ ba: «Hena kené bôren mega wo ené bi bôn tiri sa Kelma na, eraŋge iyére tiɲê a.» Hende masêni aɲ nini gey naɲ tu sara. ");
INSERT INTO kqp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wulê wo pôni nini ô kini uwôlê Emen a menba, môni temale toɲ hendi jé to pôni era yerni a, tunu to habiɲ yi bôre a aɲ lere hende kôrbe aɲ uwôɲ are damaŋ biɲ bay iyéyrere naɲ kerbê kare bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hende era tôrni a nibay naɲ Pol pê pê karê gura kôl iyôŋ ba: «Ɓiɲé ka hen, na manê ka Emen wo derômaraŋ a, bay ulêŋge na béré geré wo a ôriɲ naɲ ken kini gelê.» ");
INSERT INTO kqp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hende ôm hen iyôŋ wulê kwône. Deré kibri menba, bô Pol tari menba, ôbi bare cêgeri aɲ kôliɲ tunu hende to bôre a hen iyôŋ ba: «En kôlê naɲ hini Jésu Krist séɲ bô iyore hende to hen a.» Menba, tunu hende to hen séɲ bôre a kiriɲ bay ka hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kiriɲa bay iyérere bô wo tunu to saɲ naɲ lari biji hen ré si erêɲ hen iyôŋ na, bay pô si Pol naɲ Silas wuréji ôriɲ tu wolé tumô bay emê iyére a. ");
INSERT INTO kqp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bay ôriɲ naɲ ci biɲ bay jerê kwôlê kaɲ Rômêɲê aɲ kôl iyôŋ ba: «Ɓiɲé ka hen gusiré ɓiɲé derô iyére tona a men, bay na Jubɲê a men. ");
INSERT INTO kqp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Men, bay geliɲ ɓiɲé hal wo jôriɲ, wo nabay kaɲ Rômêɲê nana bi bôrna sara ré hen men, nana ay liɲ jé ré hen a men.» ");
INSERT INTO kqp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bô ɓiɲé ka daɲ hen tarji sarji a men, menba, bay jerê kwôlê bi bay tô bargay yi si Pol naɲ Silas a aɲ bi bay yêmnêji naɲ sera. ");
INSERT INTO kqp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aɲ cêgi sê wo bay sêji a hen menba, bay biji daŋgay a aɲ kôliɲ gumɲa woɲ ôbi gemé iyéy daŋgay hen ré bôrji dô. ");
INSERT INTO kqp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na kwôlo bay kôli wô sarji bi wo hen menba, ôbi ôriɲ naɲ ci ô bê a bô iyére to gerɲé aɲ harê têrji bô kwogelé gurô a. ");
INSERT INTO kqp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ɗa naɲ sa kiriɲ ka jali menba, si Pol naɲ Silas uwôlji Emen men, kibji kurôŋ heramiri a men, aɲ megêrji bay daŋgay toy tôrji. ");
INSERT INTO kqp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Menba, kiriɲ bay ka hen na, terare yebagiɲ naɲ nére aɲ tô iyéy daŋgay a yebagiɲ kêm. Kibi iyére kêm pôliɲ, men, musure to bay hariɲ tê daŋgayɲê hen kôba, beseriɲ kêm a men. ");
INSERT INTO kqp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Gumɲa woɲ ôbi gemé kibi iyére hen eŋgiɲ tô kum a menba, gel kibi geré kêm pôliɲ hen iyôŋ menba, ôbi dô yebere tori ɗiré deriɲ yiri. Wôsa ôbi kôl yaŋ ba, daŋgayɲê kêm ré si ge niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Niɲba, Pol jô gura kaŋ a ta kôl iyôŋ ba: «Duu yem né nini baa na ya kêm.» ");
INSERT INTO kqp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ôbi eŋgere tare ôriɲ lew bô ira, ôbi wuré naɲ harê aɲ ô kuriɲ tê si Pol naɲ Silas a. ");
INSERT INTO kqp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ôbi biji bay so nô aɲ ôbi kôlji iyôŋ ba: «Gawrê, na lê iyeŋ a ené uwôɲiɲ gelê ba?» ");
INSERT INTO kqp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Menba, bay uwôli sara iyôŋ ba: «Bi bôm sa Kelma Jésu a, aɲ já uɲé gelé jôbi naɲ ɓiɲé ka bô iyére tom a.» ");
INSERT INTO kqp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aɲ bay uwôli béré kwôlo Kelma naɲ ɓiɲé ka bô iyére tori a kêm. ");
INSERT INTO kqp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Derô yoyre hende to hen, ôbi ôriɲ naɲ ci ô pelé tu iyare to yirji a hen aɲ, menba, kiriɲ bay ka hen, bay liri batêm naɲ ɓiɲé ka bô iyére tori a kêm. ");
INSERT INTO kqp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Men, ôbi ôriɲ naɲ si Pol naɲ Silas iɲ tori ô biji emê aɲ li yi derê naɲ ɓiɲé ka iyére tori a wô bê wo ɗiré bi bôri sa Emen a hen. ");
INSERT INTO kqp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kiriɲa kiriɲ wôl menba, bay jerê kwôlê Rômêɲê jé bay tôrji ô kôliɲ gumɲa na iyôŋ ba: «Bi gawrê bay ka hen ta.» ");
INSERT INTO kqp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Menba, gumɲa na ô kôliɲ Pol kôl iyôŋ ba: «Bay jerê kwôlê jé kôlen ené bêŋge ta. Hen iyôŋ na, ken si ô naɲ bô jalê haŋge niɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Niɲba, Pol kôliɲ bay jé na iyôŋ ba: «Kwôlê wôni ɓu sarni ré tô menba, bay bi bay sêni tu wolé nibay kaɲ Rômêɲê, bay bêni daŋgay a aɲ haw hen bay gey ciré bêni ta jegêd iyôŋ mera. Na iyôŋ né. Bi bay era naɲ yirji sa bêni ta.» ");
INSERT INTO kqp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bay jé ka bay jerê kwôlê bay ka hen hô ô kôlji kwôlo Pol kelaji hen menba, harê li bay jerê kwôlê bay ka hen wôsa bay toy wo si Pol naɲ Silas ré na Rômêɲê men. ");
INSERT INTO kqp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Menba, bay era sa uwôlji bô jalê aɲ biji ta aɲ kôlji bay ré erêɲ sa ira. ");
INSERT INTO kqp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kiriɲa si Pol naɲ Silas siji daŋgay a menba, bay ô uɲé Lidi. Aɲ kiriɲa bay gel bay ayê bôô men, dôbji ibiyare bôrji a a men, menba, ôrji ta. ");
INSERT INTO kqp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Si Pol naɲ Silas soji si Ampipolis naɲ Apoloni aɲ sa biɲ Tésalonik, Jubɲê ôriɲ naɲ *iyéy daɲare kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mega wo Pol lêrê gaŋ gaŋ hen iyôŋ na, ôbi ô naɲ *sa merê ta a subu bô iyéy daɲare a ô iyêlê naɲ ɓiɲé ka mô ya hen gengiɲ sa kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ôbi gelji mega wo kwôlo Emen ré kôl hen, mega kwo Emen né dôri hen ré ma aɲ Emen ré biri hô gôl hôriɲ. Ôbi hô kôlji iyôŋ ba: «Jésu bi wo en kelêŋge kwôli hen na, na ôbi a na *Mési kwo Emen dôri hen.» ");
INSERT INTO kqp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Si Pol naɲ Silas bôy Jubɲê ka pôni naɲ kwôlê bi wo hen, aɲ bay ôrji tôrji a men, ɓiɲé ka na Jubɲê ré kaɲ bay tibé Emen hen kôba, kwône ô tôrji a men, yébé ka damné damné hen kôba, ô tôrji a a men. ");
INSERT INTO kqp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Niɲba, Jubɲê ka pôni terbére liji aɲ bay pera bay galê ka bay uwoɲji tô geré hen, aɲ li bay gusuré ɓiɲé derô ira. Bay ôrji iyé gawra wo bay uwôgeri Jasôn hen ciré erê wogé si Pol naɲ Silas ôriɲ naɲ ci tumô daɲare to kwône ɓiɲé a wô jerê kwôlê sarji a. ");
INSERT INTO kqp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kiriɲa bay uɲaji ré niɲ menba, bay pera si Jasôn naɲ bay ayê bôô ka pôni eraɲ naɲ ci tumô bay emê sa iyére a, bay kôl iyôŋ ba: «Ɓiɲé bay ka hen gusuré ɓiɲé ka sa terare aɲ, haw hen bay ná nà niɲ ");
INSERT INTO kqp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aɲ bay yi iyé Jasôn a. Ɓiɲé bay ka kêm hen li na aŋga biɲ naɲ tôô to kelma *Sésar hen né, wôsa bay kôl iyôŋ ba: ‹Ciré naɲ kelma wo ɗaŋgi ya, bay ré uwôgeri Jésu.› » ");
INSERT INTO kqp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwôlê woji bi wo hen gusuré kwônê ɓiɲé naɲ bay emê sa iyére. ");
INSERT INTO kqp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Aɲ bay li Jasôn naɲ bay ayê bôô têbiji pa dema bay ré biji ta tô. ");
INSERT INTO kqp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bô yoyre hende to hen bay ayê bôô biɲ si Pol naɲ Silas ô Béré. Kiriɲa bay sa biɲ menba, bay ô iyéy daɲare to Jubɲê. ");
INSERT INTO kqp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jubɲê ka Béré a na, li dô ɗiba, bay yi mega ka Tésalonik ré, bay gey Kwôlo Dôri wo si Pol bi wo hen naɲ bô pôn, aɲ naɲ wulê wulê bay dêŋse magtubu to Emen ciré gelé na ba, kwôlê wo Pol ré dô hen na, ré na tiri hari bi ba. ");
INSERT INTO kqp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Aɲ ka pôni kwône perêrji a ay bôrji. Men, perê ɓiɲé ka sa iyére to ɗaŋgi a bay ka hen na, yébé ka damné damné hen naɲ imɲê kwône a men ayji bôrji men. ");
INSERT INTO kqp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kiriɲa Jubɲê ka Tésalonik toy wo si Pol ré uwôl béré kwôlo Emen a Béré a men na, bay saji wô gwôsê kwônê ɓiɲé aɲ sôge tôrji. ");
INSERT INTO kqp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kiriɲ bay ka hen na, bay ayê bôô biɲ Pol ô si kibi cér iyôŋ aɲ na si Silas naɲ Timoté a baji tôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ɓiɲé ka bi Pol hen na, ôriɲ naɲ ɗi kwôy Atên a dema ré heraji Béré a tô, aɲ Pol kôlji ré heraji sa kôliɲ si Silas naɲ Timoté ré eraji uɲéri lew Atên a. ");
INSERT INTO kqp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kiriɲa Pol mô gem si Silas naɲ Timoté Atên a menba, bôri tari wô kamrê ka ôbi gel naɲ kiriɲ kiriɲ perê ira hen. ");
INSERT INTO kqp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ôbi iyêl naɲ Jubɲê men, ɓiɲé ka sa iyére to ɗaŋgi a ka mô tebe Emen hen men, bô iyéy daɲare a men, sa pôn pôn ôbi iyêl tu wolé naɲ ɓiɲé ka ôbi uwoɲji tô geré hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bay henê are ka bay uwôgeji épikuriɲê naɲ éstoysiɲê hen kôba, era sa iyêl naɲ ɗi. Ka pôni eŋgere iyôŋ ba: «Ôbi heragê bi wo hen kôl na kwôli mi hen ba?» Kiriɲa ka pôni toy wo Pol dô kwôlo Jésu men, kwôli jê sé wo ɓiɲé ka ma a men na, bay kôl iyôŋ ba: «Ôbi dô na kwôli kamrê ka sa iyére to ɗaŋgi a.» ");
INSERT INTO kqp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Menba, bay biri ô naɲ ci kini daɲare to bay emê sa iyére a to bay uwôgeji *Ayéropaj hen aɲ kôli iyôŋ ba: «Derêni tô aŋgaɲ gelé ka kôrbi ka ju kôl kwôliji hen niɲa henê. ");
INSERT INTO kqp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wôsa ju derêni na kwôlo kôrbi kôrbi aɲ nini gey henê tô kwôlê bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ɓiɲé ka Atên a kêm, kergê ré bay iyére ré naɲ wulê wulê môrji na wô toyé men, kelê men, kwôli aŋga si haw. ");
INSERT INTO kqp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Menba, Pol hena ɗebu ta tumôrji a, aɲ kôl iyôŋ ba: «Ɓiɲé ka Atên, tun a ba, ermé woŋge yi sa Emen a kêm. ");
INSERT INTO kqp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Wôsa kiriɲa en ô derô ira na, en gel iyéy kamrê kaŋge men, en gel kiriɲ uwoyé aŋgaɲ sarga biɲ Emen kwône niɲba, kwo pôni ka bay ɗi are sara kôl iyôŋ ba: ‹Kini uwoyé gindiriw wo emen wo nini hôni ré.› Iyôŋ ba, na Emen wo ken tibri aɲ ken wôni ré bi a ené era wô ulê béré kwôlê wori hen.» ");
INSERT INTO kqp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«Emen woɲ ôbi ɗé sa terare naɲ are kêm ka yi ya hen, ôbi woɲ Kelma wo derômaraŋ naɲ kwo sa terare a nà, ôbi mô na bô iyére to kôbi gawra a lê ré men, ");
INSERT INTO kqp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ôbi ôriɲ doy gawra ré li ani biri ré, wôsa na ôbi a biɲ gawrê kêm gelê naɲ bul naɲ are kêm a men. ");
INSERT INTO kqp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Na naɲ gawra pôn nêŋ a ôbi ré liɲ tô ɓiɲé kêm hen, aɲ ɗiji sa terare a nà kêm men, ôbi genge wulê wo are kêm a liɲ men, jeŋgê kini merêrji biji a men. ");
INSERT INTO kqp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ôbi li hen iyôŋ bi gawrê ré wogeri aɲ kiriɲa bay ré hamnêri wô uɲéri, aɲ iyeŋ ba, bay ré uwoɲni. Tiri wori ba, Emen ɗebu kelaŋ naɲ kwôni iyôŋ perêrna na ré. ");
INSERT INTO kqp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‹Wôsa na yiri a a nana uwôɲiɲ gelê hen men, nana nêm ôriɲ si na si na hen men, nana yiɲ gawrê hen a men.› Mega wo bay piyê kurôŋ kaŋge ka pôni na kôl hen: ‹Wôsa nana kwôŋgêri.› ");
INSERT INTO kqp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mega wo nana kwôŋgêri hen iyôŋ na, na erméŋge mega wo ôbi ré geliɲ môɲ kamrê ka bay li naɲ lôr men, naɲ lari men, réba jerew wo jeraɲnê men, wo na ermé naɲ kôbi gawra lê hen né niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Emen erem sa wulê wo gawrê kêm na na, bay tu tiɲ hen ré niɲ, niɲba, haw hen ôbi uwôge gawrê kêm naɲ kiriɲ kêm bi bay ré ɗi tô têriɲ lêreji aɲ. ");
INSERT INTO kqp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ôbi genge wulê wo ôbi a jôriɲ kwôlê sa ɓiɲé a kêm naɲ geréri naɲ kwo ôbi dôri hen. Ôbi biri ji si kamɲê perê ɓiɲé ka ma wô geliɲ ɓiɲé kêm mega wo ré na ôbi a ɗiré dôri ré yi ôbi jerê kwôlê hen.» ");
INSERT INTO kqp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kiriɲa bay toy wo Pol kôl wô jê sé kamɲê wo ɓiɲé ka ma menba, ka pôni ayrêri men, ka pôni kôl iyôŋ ba: «Cêgê já hô kelê niɲa toyé a.» ");
INSERT INTO kqp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kiriɲ bay hen menba, Pol ɗiji aɲ ô ta. ");
INSERT INTO kqp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Menba, ka pôni ɗi yirji yiri a menba, ay bôrji, perêrji a na, gawra wo bay uwôgeri Dénis wo na dami perê daɲare to bay berê sa iyére hende to hen men, iyore to bay uwôgere Damaris, naɲ ɓiɲé ka ɗaŋgi a men. ");
INSERT INTO kqp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Cêgê menba, Pol hena Atên a ô Kworênt a. ");
INSERT INTO kqp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ya hende to hen na, ôbi uwôɲ Jub wo pôni bay uwôgeri Akilas na kwôni wo bay yêri sa iyé Pônt. Ôbi hena Itali a sa haw naɲ tamni Prisil, wôsa kelma wo dami Kulod na ay tôri bi Jubɲê kêm ré ôrji aɲ sa iyé Rôm a. Menba, Pol ɓu milɲare naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Mega wo Pol kôba, na ôbi lê tanda môɲ bay iyôŋ men hen na, ôbi mô iyére toji a aɲ li jé naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Naɲ *sa merê ta a merê ta a kwôy kwôy na, ôbi dô kwôlê bô *iyéy daɲare a aɲ woge bi Jubɲê naɲ Grêkɲê ré bi bôrji sa kwôlê wori bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Niɲba, kiriɲa si Silas naɲ Timoté henaji Maséduwan a saji menba, ôbi ɗi jé lê tanda ba, aɲ li na jé derê kwôlê yôd kôliɲ Jubɲê mega wo Jésu ré na *Mési kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bay kaɲ kwôli men, bay tiréri a men menba, Pol gage bunu bargay kari aɲ kôlji iyôŋ ba: «Kwôbreŋge a baa sarŋge a, kwôlê wôni naɲ san a, aɲ haw hen, na erê iyé ɓiɲé ka na Jubɲê ré hen.» ");
INSERT INTO kqp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ôbi hena kiriɲ bay ka hen ô iyé Titus Justus a wo na ôbi tibé Emen wo iyére tori jéniɲ naɲ iyéy daɲare hen. ");
INSERT INTO kqp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus ôbi sa iyéy daɲare hende to hen bi bôri sa Kelma naɲ ɓiɲé ka bô iyére tori a kêm men, ɓiɲé kwône ka Kworênt a ka toy kwôlo Pol hen na, ay bôrji aɲ bay liji batêm. ");
INSERT INTO kqp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bô yoyre to pôni a, Kelma kôliɲ Pol bô pelal a iyôŋ ba: «Hare ré dô kwôlê yôd yôd ɗiba ju wôm tôŋ né. ");
INSERT INTO kqp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ena naɲ ju, kwôni wo a ɗé kôbri sam a wô gelem gusiɲ ba, naɲ, wôsa ɓiɲé kaɲê kwône baa derô iyére hende to hen ya tô.» ");
INSERT INTO kqp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol mô Kworênt a li elê pôn naɲ geserê jii dôriɲ ɓiɲé kwôlo Emen. ");
INSERT INTO kqp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wulê wo Galiɲô na na ôbi emê kiriɲ ka Akay a hen na, Jubɲê biɲ tôrji aɲ ɓirji Pol ôriɲ kini jerê kwôlê a. ");
INSERT INTO kqp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Aɲ bay kôl iyôŋ ba: «Gawra bi wo hen woge bi ɗiré biyê ɓiɲé bi bay ré tebe Emen naɲ geré wo biɲ naɲ tôô ré hen.» ");
INSERT INTO kqp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol ɗa kelê kwôlê tô menba, Galiɲô kôliɲ Jubɲê iyôŋ ba: «Hena henaŋ ré na ɗagê sa tôô lay, ré na aŋga habiɲ kani ka dami lay na, ré ené toyé kwôlê woŋge bi wo hen tiri a men. ");
INSERT INTO kqp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Niɲba, mega wo na naɲare toŋge to gengiɲ sa kwôlê woɲ kelê men, sa hini a men, sa tôô toŋge a men hen na, na kwôlê woŋge ɗiba, nôbi na ɲanê kwôlo hen iyôŋgi hen né.» ");
INSERT INTO kqp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Menba, ôbi dageji kini jerê kwôlê a. ");
INSERT INTO kqp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bay kêm ɓu Sôstên ôbi sa iyéy daɲare sêri kini jerê kwôlê a niɲba, dôliɲ Galiɲô ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol wôl gaɲ Kworênt a menba, ôbi ɗéɲ yênêri bay ayê bôô aɲ ɗay tera naɲ bato wô erê Siri naɲ si Prisil naɲ Akilas. Niɲba, pa dema ôbi ré ɗa erê tô na, ôbi bi bay dili sari a Sênkré a, wôsa ôbi na ay tôri tumô Emen a. ");
INSERT INTO kqp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bay sa biɲ Epês a menba, Pol ɗi si Prisil naɲ Akilas aɲ, aɲ ô iyéy daɲare a ô dôriɲ Jubɲê kwôlê. ");
INSERT INTO kqp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bay kôli ôbi ré wôl sem naɲ ci, niɲba, ôbi kaɲ. ");
INSERT INTO kqp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pa dema ôbi ré ô ta, tô ná, ôbi kôlji iyôŋ ba: «Hena Emen né gey na, na hô hera.» Menba, ôbi ay bato ô ta. ");
INSERT INTO kqp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kiriɲa ôbi sa biɲ Sésaré aɲ herbe tôŋ menba, ôbi ô Jérusalêm wô liɲ bay ayê bôô ka ya hen dosé pa dema ré ô Antiyôk a. ");
INSERT INTO kqp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ôbi wôl ya hende to hen sem menba, bul hô ô gôr bô emê wo Galati a naɲ Priji dôbiɲ ibiyare bô bay ayê bôô ka ya hen a. ");
INSERT INTO kqp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jub wo pôni bay uwôgeri Apolôs ôbi yêɲ na Alêksandri a, ôbi sa biɲ Epês a. Na kwôni wo kwôlê gwa kibri a men, hôn magtubu to Emen dô a men. ");
INSERT INTO kqp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bay na hali naɲ geré wo Kelma, menba, ôbi uwôl béré men, geliɲ ɓiɲé naɲ geréri kwôlo Jésu naɲ yi derê niɲba, na batêm to Ja a ôbi ré hôn mera. ");
INSERT INTO kqp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ôbi dô kwôlê naɲ ibiyare bô *iyéy daɲare a niɲba, kiriɲa si Prisil naɲ Akilas toy kwôlo ôbi dô hen iyôŋ menba, bay biri ô naɲ ci aɲ gili geré wo Emen damaŋ a naɲ geréri. ");
INSERT INTO kqp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Menba, ôbi genge ɗiré erê bô emê Akay a, bay ayê bôô dôbri ibiyare bôri a, aɲ bay li magtubu biɲ bay ayê bôô ka Kworênt a bi bay ré ɓiri yirji a dô. Kiriɲa ôbi ô biɲ menba, naɲ bô derê wo Emen na, ôbi li naɲ bay ayê bôô damaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wôsa ôbi kôl kwôlê naɲ ibiyare tu wolé kaɲiɲ kwôlo Jubɲê men, gelji naɲ magtubu to Emen mega wo Jésu ré na Mési kwo Emen dôri hen. ");
INSERT INTO kqp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kiriɲa Apolôs baa Kworênt a tô na, Pol waya si bô emê wo Asi sa iyére to keram yi ya hen aɲ sa biɲ Epês a. Ôbi uwôɲ bay ayê bôô ka pôni kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Aɲ ôbi eŋgeriji iyôŋ ba: «Kiriɲa na kena biɲ bôrŋge sa Jésu hen na, na ken uwôɲ Tunu toɲ hendi bô bôrê ba?» Menba, bay uwôli sara iyôŋ ba: «Kwôli Tunu toɲ hendi bô bôrê kôba, nini toy ré.» ");
INSERT INTO kqp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol eŋgeriji iyôŋ ba: «Batêm to yôŋ a bay ré lêŋge ba?» Menba, bay uwôli sara iyôŋ ba: «Na batêm to Ja na uwôl bérére hen.» ");
INSERT INTO kqp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Menba, ôbi kôl iyôŋ ba: «Ja na liɲ ɓiɲé ka *Israyêl batêm to gel wo bay ré ɗéɲ tô têriɲ toji aɲ, aɲ ôbi na kôlji bi bay ré bi bôrji sa kwo ré era cêgeri a hen, ôbi a na Jésu.» ");
INSERT INTO kqp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kiriɲa bay toy kwôlê wori bi wo hen iyôŋ menba, bay bi bay liji batêm naɲ hini Kelma Jésu. ");
INSERT INTO kqp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol uwôl kôbri sarji a menba, bay uwôɲ Tunu toɲ hendi bô bôrê aɲ bay iyêl kibi yê wo ɗaŋgi men, bay uwôl béré kwôlo Emen biji hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ɓiɲé bay ka hen kêm na môj kibi wôô. ");
INSERT INTO kqp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol ô bô *iyéy daɲare a aɲ dô kwôlê kwôy kwôy li geserê subu, ôbi dôriɲ ɓiɲé kwôli *emê iyére to Emen naɲ ibiyare bi ɗiré biyêji. ");
INSERT INTO kqp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ka pôni bôrji deŋgel aɲ kaɲ kwôli bi wo hen tu ɓiɲé aɲ kôlji kwôlo habiɲ gengiɲ sa geré wo Kelma hen, menba, Pol dô yiri yirji a aɲ dô bay ayê bôô ôriɲ wolé, aɲ naɲ wulê wulê ôbi dôrji kwôlê bô iyéy gelé are to Tiranôs a. ");
INSERT INTO kqp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ôbi gilji are bay ka hen iyôŋ kwôy li elê wôô aɲ li wo ɓiɲé ka sa iyé Asi a Jubɲê ré, Grêkɲê ré kêm toyji kwôlo Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Aɲ Emen biɲ Pol li giɲê wo ɗê kiriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Aɲ na hen iyôŋ a ɓiɲé ré pô kibi bargay ka hebe yiri hen ô hebiɲ yi bay ômɲare, menba, bay berare men, ka tunu to habiɲ si aɲ bôrji a men. ");
INSERT INTO kqp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Jubɲê ka pôni dagiɲ tunu to habiɲ bô bay ômɲare a ôriɲ si na si na. Perê Jubɲê bay ka hen na, na kam *dami wo damné kaɲ bay bê kwôbe woɲ Jub wo bay uwôgeri Sébéba ka jurgem hen. Aɲ bay kôba, gey uwôgê hini Kelma Jésu sa ɓiɲé ka ôriɲ naɲ tunu to habiɲ bôrji a hen aɲ bi hende ré séɲ, menba, bay kôliɲ tunu to habiɲ hende to hen iyôŋ ba: «En ay tôn béŋge naɲ hini Jésu wo Pol uwôl béré kwôlê wori hen bi kené si aɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Menba, tunu to habiɲ hende to hen uwôlji sara iyôŋ ba: «En hôn Jésu men, en toy kwôli Pol a men. Niɲba, kenbay ba, kena si i men ba?» ");
INSERT INTO kqp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Menba, gawra wo tunu to habiɲ yi bôri a bi wo hen kuriɲ sarji a aɲ basirêji gôliɲ, aɲ bay tôriɲ kôbri a aɲ bay séɲ iyére tori a ge tôrji seŋge men, naɲ iyare yirji a men. ");
INSERT INTO kqp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɓiɲé ka Epês a kêm Jubɲê ré, Grêkɲê ré toy kwôlê bi wo hen, aɲ bay kêm harê liji aɲ bay bi kwôlê damaŋ sa hini Kelma Jésu. ");
INSERT INTO kqp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Aɲ kwônê ɓiɲé ka ay bôrji hen era sa dô tô jé lêreji wo habiɲ bi wo hen ta tu wolé. ");
INSERT INTO kqp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ɓiɲé kwône ka na li aŋgaɲ beli hen na, eraɲ naɲ magtubu toji toɲ beli hende to hen, aɲ uwoyré aɲ tu ɓiɲé. Magtubu toji hende to hen larirji kêm na, ré erê selé sak tôre bay. ");
INSERT INTO kqp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na iyôŋ a, kwôlo Kelma ré ô tumô tumô naɲ néé wori men, gel néé wori bi wo hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cêgi are bay ka kêm hen menba, Tunu toɲ hendi bô bôrê dô tumô Pol aɲ ôbi genge ɗiré sé si Maséduwan naɲ Akay aɲ erê Jérusalêm a. Ôbi kôl iyôŋ ba: «Hena ené biɲ yeŋ na, na erê Rôm a men.» ");
INSERT INTO kqp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ôbi jé si Timoté naɲ Erast megêri bay jé Maséduwan a aɲ ôbi ba, wôl sem bô emê wo Asi a. ");
INSERT INTO kqp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wulê bi wo hen na, kwôlê wo dami yi Epês a wô sa geré wo Kelma. ");
INSERT INTO kqp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sa hende to hen na, gawra wo pôni bay uwôgeri Démétriyus, na ôbi igé lari, ôbi ay lari aɲ ige are geliɲ naɲ iyéy kamrê kaɲ Artémis hen aɲ bay kel, aɲ ôbi naɲ bay jé kari uwôɲiɲ are damaŋ kini jé woji bi wo hen a. ");
INSERT INTO kqp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ôbi day bay jé kari naɲ megêri bay igé lari aɲ kôlji iyôŋ ba: «Megên, ken hôn, na jé wona bi wo hen a béna derê hen. ");
INSERT INTO kqp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ken gel men, toy a men, aŋga gawra woɲ Pol bi wo hen li hen. Ôbi kôl mega wo emen wo kôbi gawra a ré lê hen na, ré na emen woɲ tiri ré. Aɲ ôbi bôy ɓiɲé kwône, na Epês a pôn mera ré, niɲba, bô emê wo Asi a kêm. ");
INSERT INTO kqp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Aɲ kwôlê wori bi wo hen a lê aɲ jé wona a mêniɲ men, hini emê wo iyéy emen wo dami woɲ Artémis hen kôba a mêniɲ a men. Aɲ emen bi wo ɓiɲé ka bô emê wo Asi a naɲ sa terare a na kêm tebe hen na, damɲare tori a naɲê sari a.» ");
INSERT INTO kqp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kiriɲa bay toy hen iyôŋ menba, bôrji tarji aɲ bay ka gura kôl iyôŋ ba: «Artémis emen wo Epês a na kwo dami.» ");
INSERT INTO kqp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Lê woji bi wo hen ay kiriɲ derô ira aɲ bay pô si Gayus naɲ Aristark ka Maséduwan megê Pol kaɲ bay biri ôriɲ kergare hen ôriɲ naɲ ci tu wolé. ");
INSERT INTO kqp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol gey ɗiré erê uɲé kwônê ɓiɲé tu wolé niɲba, bay ayê bôô jôri. ");
INSERT INTO kqp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Milɲéri ka damné ka Asi ka pôni kôba, kôli ôbi ré ô tu wolé ré. ");
INSERT INTO kqp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Heragê wo dami ôm tu wolé aɲ i i ba ka gura wori wori, li aɲ kini daɲare a hen na, kwôni hôn na ba, wô mi a bay ré daɲ ba, ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Perê kwônê ɓiɲé bay ka hen na, ka pôni dôriɲ Alêksander woɲ Jub wo bay ayri ɗi tumô hen sa tê kwôlê bi wo hen, ôbi li kôbri bi bay ré wôm tôŋ aɲ ɗiré dôrji kwôlê jôriɲ sa si Gayus naɲ Aristark. ");
INSERT INTO kqp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Niɲba, kiriɲa bay hôn wo ôbi ré na Jub hen iyôŋ menba, bay ka gura kibriji pôn kwôy li tare wôô kôl iyôŋ ba: «Artémis emen wo Epês a na kwo dami, Artémis emen wo Epês a na kwo dami.» ");
INSERT INTO kqp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Menba, dami wo pôni woɲ ôbi emê sa iyére biji bay wôm tôŋ aɲ kôlji iyôŋ ba: «Gawrê ka Epês, ɓiɲé kêm hôn wo sa iyé Epês ré na sa iyére to iyéy emen Artémis naɲ aŋga geliɲ naɲ ci ka kuriɲ ta hen. ");
INSERT INTO kqp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kwôni wo a narê ba, naɲ, iyôŋ na, wômêŋge tôŋ ɗiba, ken li are mega kené erem kwôlê ré iyôŋ né. ");
INSERT INTO kqp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gawrê ka ken eraɲ naɲ ci nà ná, bay li ani kani ka habiɲ iyéy kamrê a ré men, bay uwôge hini kamrê wo habiɲ wôni ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hena Démétriyus naɲ bay jé kari ré ôriɲ naɲ kwôlê wôni naɲ kwôni na, wulê woɲ jerê kwôlê ya men, kilmé nà ya men, bi bay uwôgiɲ yirji tumôrji a. ");
INSERT INTO kqp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Men, hena kwôlê wôni wo ɗaŋgi ré ya ba, naa ɲanê tumô bay jerê kwôlê ka bay tôrji ɗi naɲ geréri hen. ");
INSERT INTO kqp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nana bô dô ré ba, bay a ulêna kwôlê sarna mega wo nana na bay mêne kiriɲ wô sa daɲare tona to kemnêŋ, wôsa ani ka li aɲa nana daɲ na ba, naɲ, men, naa nêmê derê tô daɲare hende to hen ré a men.» Kiriɲa ôbi kôl hen iyôŋ menba, ôbi biɲ ɓiɲé bur haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kiriɲa tô kwôlê bi wo hen jôriɲ niɲ menba, Pol day bay ayê bôô aɲ dôbji ibiyare bôrji a. Men liji dosé aɲ ɓu geré wô erê Maséduwan a. ");
INSERT INTO kqp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kiriɲa ôbi ô naɲ kiriɲ kiriɲ sa iyé Maséduwan a dôriɲ bay ayê bôô kwôlê kwône dôbiɲ ibiyare bôrji a, menba, ôbi ô Grês a. ");
INSERT INTO kqp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Aɲ ôbi li geserê subu ya. Kiriɲa ôbi ɗa ayê bato wô erê Siri a menba, ôbi toy wo Jubɲê ré way kwôli liri habrê hen ya, menba, ôbi genge herê si Maséduwan. ");
INSERT INTO kqp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ɓiɲé ka biri tô kergare tori hende to hen a na: Sopatêr kema Pirus wo Béré a men, Aristark naɲ Sékôndus ka Tésalonik men, Gayus wo Dêrb naɲ Timoté men, Tikik naɲ Tropim ka bô emê wo Asi a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓiɲé bay ka kêm hen na, ôrji tumô ô geméni Trowas a. ");
INSERT INTO kqp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nibay ba, nini hena Pilip cêgi geserê wo mapa wo wubere ɗiɲ ya ré hen menba, nini li wulê bay geré dema niné biɲ uɲéji Trowas a tô, aɲ nini li wulê jurgem ya. ");
INSERT INTO kqp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Naɲ sa demas perare menba, nini daɲ kibi emê wo Kelma aɲ Pol kiya ɗa erê ta niɲ menba, ôbi iyêl naɲ bay ayê bôô kwôy sa kiriɲ jal. ");
INSERT INTO kqp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bô iyére to ta to nini daɲ ya hen na, lampa kwône berare kiriɲ ya. ");
INSERT INTO kqp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kema mana wo pôni bay uwôgeri Etik mô ɗa naɲ tu pinêter menba, yi kum kaɲ ɗôre wôsa Pol dô kwôlê cêgeri kelaŋ. Kum ayri aɲ ôbi kuriɲ ta bô iyére to subi to ta aɲ bay ca ayêri ta menba, ôbi ma. ");
INSERT INTO kqp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol herbo aɲ era lew sa deŋge gili aɲ sa ayri kôbri a aɲ kôl iyôŋ ba: «Sunéŋge ré! ôbi baa geɲ baa ya.» ");
INSERT INTO kqp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Menba, Pol hô ɗay hôriɲ bô ira ta, aɲ ô merê kibi gwoy emê to Kelma menba, bay hô iyêl kwôy wo tare siɲ menba, ôbi ô ta hari niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kema mana bi wo hen, gôl aɲ bay ayri ôriɲ iɲ aɲ na yi derê wo dami. ");
INSERT INTO kqp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nibay nini ɗay bato ôriɲ Asôs a tumô. Na ya hen a Pol ré sa ɗayê naɲ ni. Na hen iyôŋ a, ôbi ré genge, wôsa ôbi gey ɗiré erê naɲ têri. ");
INSERT INTO kqp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kiriɲa ôbi sa biɲ uɲéni Asôs a menba, bay daɲ naɲ ni aɲ nini ô Mitilên a. ");
INSERT INTO kqp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kiriɲ bay ka hen na, kiriɲa kiriɲ wôl menba, nini ô kwôy ɗa naɲ Kiyo, aɲ ɗaŋ to hen menba, nini sa biɲ Samôs a aɲ wulê pôn cêgê menba, nini sa biɲ Milé. ");
INSERT INTO kqp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol genge ɗiré ɗebé tôŋ a Epês a ré, wôsa ma ɗiré ɗebé sem bô emê wo Asi. Wôsa ôbi mase hena ré iyeŋ ba, ɗiré biɲ Jérusalêm a tumô *Pantékwôt. ");
INSERT INTO kqp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol jé uwôgê surɲê ka bay ayê bôô ka Epês a Milé a. ");
INSERT INTO kqp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kiriɲa bay sa biɲ uɲéri menba, ôbi kôlji iyôŋ ba: «Ken hôn hal wuɲê naɲ ken wulê kêm wo na en môriɲ perêrŋge a kiriɲa na en saɲ bô emê wo Asi a hen. ");
INSERT INTO kqp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","En li jé biɲ Kelma naɲ uwôyrê yi ré men, naɲ cémé tun a men, perê wayê wo Jubɲê way kwôlen wô gelen gusiɲ hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ani kani ka dôri ka ré lê naɲ ken ka en uwôbe sarji tôŋ ba, naɲ, en uwôl béré are kêm men, en geléŋge are tu wolé men, bô iyére toŋge a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Aŋgaɲ gelé kaɲê na, na wo Jubɲê naɲ ɓiɲé ka iyére to ɗaŋgi a ré ré bul uɲé Emen men, ré bi bôrji sa Kelma wona Jésu a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Haw hen, Tunu ɓuren ereŋ bi ené ô Jérusalêm a, aŋga a lên ya hen kôba, en hôn né tô. ");
INSERT INTO kqp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Niɲba, aŋga pôn ka en hôn na, naɲ sa iyére iyére to en ôriɲ hen na, Tunu toɲ hendi bô bôrê gelen wo ené yé daŋgay men, ené geliɲ gusiɲ damaŋ a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Niɲba, en bô yen mega ani ré iyôŋ, derêri ba, na wo ené ɓu iyêre deriɲ kibi jé wo Kelma Jésu bên kôben a hen. Ôbi a na ulê béré Kwôlo Dôri wo gengiɲ sa bô derê wo Emen hen.» ");
INSERT INTO kqp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Na en mô perêrŋge a na kêm uwôl béré kwôli *emê iyére to Emen aɲ haw hen, en hôn kwôni pôn iyôŋ perêrŋge a hen a gelé tun né niɲ yôd. ");
INSERT INTO kqp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Na ôbi á, ené kelêŋge kemnêŋ waŋ a ta hen, hena kwôni pôn perêrŋge a ré ge kay ba, na kwôlê wuɲê nôbi ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wôsa na en uwôlêŋge béré aŋga Emen na genge hen kêm ɗiba, na en uwôbêŋge sarji tôŋ né. ");
INSERT INTO kqp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Geméŋge yerŋge dô men, ken gem gamgê kêm ka Tunu toɲ hendi bô bôrê béŋge ken yi bay gemérji hen men, berêŋge sa bay ayê bôô ka Emen uwoɲji naɲ kwôbri kemari wori hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","En hôn wo cêgen wo na ôriɲ ta hen na, gawrê ka geliɲ môɲ heŋɲê iyôŋ hen, a tôbê yirji perêrŋge a aɲ gamgê kôba, bay a ɗiji ré. ");
INSERT INTO kqp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Perêrŋge a hen kôba, ɓiɲé ka pôni a kelê kwôlê woɲ benare aɲ wô terê bay ayê bôô bê a tôrji a. ");
INSERT INTO kqp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɗéŋge tu melênê sa yerŋge a. Ken hôn, elê subu wo na en li perêrŋge a hen na, yoyre naɲ tu tare en halêŋge pôn pôn, aɲ kiriɲ ka pôni a naɲ cémé tun a.» ");
INSERT INTO kqp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Aɲ haw hen na, en bêŋge kôbi Emen a men, naɲ kwôlê wori woɲ bô derê hen. Ôbi ôriɲ naɲ néé wo ka ɗebiɲ tô ayê bôô woŋge a men, kwoɲ béŋge aŋga dôri kêm ka ôbi gem wô biɲ ɓiɲé ka na kari hen men. ");
INSERT INTO kqp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","En li tu bôriyare sa gursu to kwôni a ré men, sa lôr wo kwôni a ré men, sa bargay ka kwôni a ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kenbay ken hôn ené li jé naɲ kôben wuɲê aɲa niné uwôɲiɲ aŋga ré li naɲ ni nibay naɲ megên. ");
INSERT INTO kqp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kiriɲa en li jé damaŋ hen iyôŋ na, en geléŋge na gelé, wôsa na hen iyôŋ a, kené lê naɲ bay nimré men, ermiɲ sa kwôlo Kelma Jésu naɲ yiri na kôl kôl iyôŋ ba: ‹Kwôni wo bi na, li yi derê gôliɲ kwôni wo uwôɲ.› » ");
INSERT INTO kqp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kiriɲa ôbi kôl kwôlê bi wo hen iyôŋ kô niɲ menba, ôbi cubu gubarji tôŋ naɲ ci kêm aɲ uwôl Emen. ");
INSERT INTO kqp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bay kêm heriɲ tô Pol a naɲ sômê men, ɓiri a kabrêrji a a men wô liri dosé toɲ erê ta. ");
INSERT INTO kqp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tirji li ɲa wô sa kwôlo ôbi kôl iyôŋ ba: «Bay ré gelé tiri ré niɲ hen.» Aɲ bay biri kwôy ôriɲ kibi bato a. ");
INSERT INTO kqp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kiriɲa nini ɗiji aɲ niɲ menba, nini ay bato aɲ hergiɲ sarni si Kôs a, aɲ nini wôl ya. Kiriɲa kiriɲ wôl menba, nini ô Rôd a aɲ nini wôl ya. Aɲ nini hena Rôd a ô Patara. ");
INSERT INTO kqp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kiriɲ bay ka hen na, nini uwôɲ bato to ta erê Pinisi a menba, nini ɗay ô. ");
INSERT INTO kqp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kiriɲa nini gel sa Sipre ba ɗa menba, nini ɗere aɲ sa kôbi maa aɲ nini ô si Siri, aɲ nini herbe Tir a, wôsa bay ca terê aŋga bô bato hen tôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nini li sa jurgem ya hende to hen, wôsa nini uwôɲ bay ayê bôô ya. Menba, Tunu kôlji bay ré kôliɲ Pol ré ô Jérusalêm a ré. ");
INSERT INTO kqp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kiriɲa wulê woni kô niɲ menba, nini ô wô ɗayê bato wô erê kergare toni menba, bay kêm bêni naɲ yébérji men naɲ kamniji ɗé kibi kalmê a naɲ iyére. Kiriɲ bay ka hen na, nini cubu gubarni tôŋ kibi cér a aɲ nini uwôl Emen. ");
INSERT INTO kqp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Aɲ kiriɲa nini liɲ dosé kô niɲ menba, nini ɗay bô bato a menba, bay hô iɲ haji niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kiriɲa nini hena Tir a sa biɲ Tolémé menba, nini ô ɓeré kôbi bay ayê bôô ka ya hen aɲ nini wôl naɲ ci. ");
INSERT INTO kqp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kiriɲ wôl menba, nini hena ya hen ô Sésaré aɲ nini ô wulê iyé Pilip woɲ ôbi ulê béré wo pôni perê ka jurgem ka bay na tôrji Jérusalêm a hen. ");
INSERT INTO kqp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kamni kaɲ kalmê pôrbu na bay kôliɲ ɓiɲé kwôlo Emen yêge sari biji hen men. ");
INSERT INTO kqp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kiriɲa nini li wulê kwône hen iyôŋ menba, *ôbi kibi Emen wo bay uwôgeri Agabus hen hena Judé sa. ");
INSERT INTO kqp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ôbi era sa uɲéni aɲ ay ariɲ wo Pol hariɲ tô bôri hen, hariɲ kôbri wori naɲ têri tori aɲ kôl iyôŋ ba: «Kwôlo Tunu toɲ hendi bô bôrê kôl iyôŋ ba: ‹Ôbi iyéy ariɲ woɲ harê tô bôô bi wo hen na, gel, na hen iyôŋ a, Jubɲê ré ɓiri harê Jérusalêm a aɲ biɲ ɓiɲé ka sa iyére to ɗaŋgi a.› » ");
INSERT INTO kqp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kiriɲa nini toy hen iyôŋ menba, nibay naɲ bay ayê bôô ka Sésaré nini mase Pol ré ô Jérusalêm a ré. ");
INSERT INTO kqp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Niɲba, ôbi ulêni sara iyôŋ ba: «Wô mi a kené sômnê men, wô mi a kené woge wô té deŋgôn men, hen iyôŋ ba? Na yé daŋgay a mera ré niɲba, na temare hende kôba, na ma Jérusalêm a wô sa hini Kelma Jésu.» ");
INSERT INTO kqp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mega wo nini nêm biyêri ré hen iyôŋ menba, nini uwôli dôriɲ dôriɲ ré niɲ, aɲ nini kôl iyôŋ ba: «Bi Kelma li bô geyé wori.» ");
INSERT INTO kqp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kiriɲa wulê woni nêm hen iyôŋ menba, nini ɲan yerni aɲ nini ô wô erê Jérusalêm a, ");
INSERT INTO kqp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","bay ayê bôô ka Sésaré bêni aɲ bay ôriɲ naɲ ni iyé gawra wo bay uwôgeri Nasôn wo niɲa erê yé iyére tori a hen, ôbi na kwôni wo Sipre hen, ôbi na ôbi ayê bôô ca yeŋ. ");
INSERT INTO kqp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kiriɲa nini sa biɲ Jérusalêm a na, bay ayê bôô ɓeréni yirji a naɲ yi derê. ");
INSERT INTO kqp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kiriɲ wôl menba, nini ô naɲ Pol iyé *Jak a aɲ surɲê ka églis kêm kôba ya men. ");
INSERT INTO kqp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol liji dosé menba, dôrji kwôli are kêm ka Emen né li naɲ geré wori sa iyé ɓiɲé ka na Jubɲê ré a hen. ");
INSERT INTO kqp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Si Jak naɲ surɲê toy kwôlo Pol dôrji hen iyôŋ menba, bay heram Emen aɲ kôli iyôŋ ba: «Yênini, ju gel Jubɲê kwône ay bôrji men bay kêm ɗi yirji damaŋ baa yi tôô to *Moyis a baa ya tô. ");
INSERT INTO kqp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Men, bay kôlji kwôli aŋgaɲ gelé ka jeré geliɲ Jubɲê ka mô perê ɓiɲé ka sa iyére to ɗaŋgi a hen, bi bay ré ɗéɲ tôô to Moyis men, jeré kôlji bay ré waliɲ kamniji keŋ ré men, bay ré li hara wo Jubɲê ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Na lêŋge iyeŋ niɲ ba? Wôsa bay a toyé wo jeré sa hen ya. ");
INSERT INTO kqp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Li aŋga niɲa kôlem hen. Perêrni a na ɓiɲé pôrbu ka na ay tôrji biɲ Emen nà ya. ");
INSERT INTO kqp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pôrji naɲ ju, ju ôriɲ lôɲiɲ yem naɲ ci mega wo hara wona gey hen iyôŋ men, ju têbe are kêm ka bay liɲ sarga hen aɲ bi bay dilji sarji. Aɲ kiriɲa ɓiɲé gel hen iyôŋ menba, bay a kelê kwôlo bay na ré kôlji gengiɲ sam hen na, ré na kwôlê woɲ benare ɗéɲ iyôŋ, wôsa jôbi kôba, jeré li tôô baa ya men. ");
INSERT INTO kqp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ɓiɲé ka sa iyére to ɗaŋgi a ka ay bôrji hen na, nini li magtubu ayiɲ tôô kôlji iyôŋ ba: ‹Bay ré ôm tanare to bay tibiɲ kamrê hen né men, kwôbe ré men, tanare to kwôbrere biɲ tôŋ né hen né men, bay ré yiɲ yiɲare toɲ têriɲ ré a men.› » ");
INSERT INTO kqp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kiriɲ wôl menba, Pol pô ɓiɲé bay ka hen ôriɲ aɲ lôɲiɲ yiri naɲ ci men, ôbi ô *iyéy Emen a wô jerê sa to kiriɲa lôɲê yi ré kô niɲ ba, ɗiré bê kwôbe wô sarji pôn pôn. ");
INSERT INTO kqp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kiriɲa wulê wo jurgem hen ɗa kerê niɲ menba, Jubɲê ka hena bô emê wo Asi sa hen, gelji Pol iyéy Emen a menba, gwôsiji ɓiɲé kêm aɲ bay ɓiri. ");
INSERT INTO kqp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Aɲ bay ka gura kôl iyôŋ ba: «Kam *Israyêl, néniŋge men, gel gawra woɲ ôbi erê naɲ kiriɲ kiriɲ kôliɲ ɓiɲé kêm kwôlo habiɲ gengiɲ sa kam Israyêl men, sa tôô to Moyis men, sa iyéy Emen a men hen. Aɲ haw hen ôbi hô eraɲ naɲ ɓiɲé ka na Jubɲê ré hen derô haba wo iyéy Emen a wô mêniɲ kiriɲ ka yi naɲ jeŋgêrji bay ka hen sôŋ.» ");
INSERT INTO kqp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bay kôl hen iyôŋ, wôsa bay gel Tropim wo Epês a derô ira naɲ ɗi menba, bay erem yaŋ ba ôbi ré ôriɲ naɲ ɗi derô haba wo iyéy Emen a. ");
INSERT INTO kqp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Aɲ lê woji bi wo hen ay ɓiɲé kêm derô ira aɲ bay dayriɲ naɲ kwônêrji. Bay ɓu Pol siɲ nô derô haba wo iyéy Emen a aɲ bay legeré kibi geré ta lew lew. ");
INSERT INTO kqp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kiriɲ bay ka hen na, bay gey ciré deréri menba, kwôli era sa kuriɲ ma dami wo asgarɲê mega are ré li are bô Jérusalêm a kêm. ");
INSERT INTO kqp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Menba, ôbi day asgarɲê naɲ bay sarji ôriɲ lew kwôli ɓiɲé bay ka hen, kiriɲa bay gel asgarɲê naɲ damné kaji bay ka hen iyôŋ menba, bay ɗi sê Pol ba. ");
INSERT INTO kqp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dami wo asgarɲê bay ka hen era sa bi bay ɓiri aɲ kôlji bay ré harê kôbri naɲ gaŋgi musure wôô, aɲ eŋgere ôbi ré na i ba? Men, ré na mi a ôbi ré li ba a men. ");
INSERT INTO kqp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Niɲba, ɓiɲé bay ka kêm hen na, ka pôni kaa gura kôl na iyôŋ men, ka pôni kaa gura kôl na iyôŋ men, aɲ dami wo asgarɲê nêm toyé kwôlê wôni ɗêrêrê henê ré, menba, ôbi bi bay ôriɲ naɲ Pol galay a. ");
INSERT INTO kqp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kiriɲa bay eraɲ naɲ ɗi ɗa kibi ira menba, asgarɲê ayri ta wôsa bô ɓiɲé tarji damaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ɓiɲé kêm era tôri a aɲ ka gura kôl iyôŋ ba: «Diiri, diiri.» ");
INSERT INTO kqp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kiriɲa bay ca siɲ naɲ ɗi bô galay a menba, Pol kôliɲ dami wo asgarɲê iyôŋ ba: «En gey kôlem kwôlê pôn.» Menba, dami wo asgarɲê na eŋgereri iyôŋ ba: «Ju hôn kelê kibi grêk men ba? ");
INSERT INTO kqp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Iyôŋ ba, jôbi a na Ejipt, wo na gwôse ɓiɲé aɲ na geriɲ naɲ ka pôni dubu pôrbu derô gwôlê hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Menba, Pol kôli iyôŋ ba: «Ena ôbi ré. Nôbi ena Jub wo Tars bô emê wo Silisi a, ena kema iyére to dami, en uwôlen ɗén na iyêliɲ ɓiɲé kwôlê.» ");
INSERT INTO kqp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ôbi ɗiri aɲ Pol hena ɗebu ta aɲ liɲ ɓiɲé kôbri. Né kiriɲ wôm sidiŋ menba, ôbi kôlji kwôlê naɲ kibi yê Jubɲê kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Yênên naɲ balên, toyéŋge kwôlo na derêŋge wô jôriɲ san hen.» ");
INSERT INTO kqp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Né kiriɲ hô wôm sidiŋ a kiriɲa bay toy wo Pol iyêlji naɲ kibi yê wo Jubɲê hen. ");
INSERT INTO kqp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ôbi kôlji iyôŋ ba: «Ena Jub wo bay yên Tars a bô emê wo Silisi a. Niɲba, en li manare na Jérusalêm a na men, ôbi gelenare are na Gamaliyêl men. Ôbi gelen are ka gengiɲ sa tôô to môɲêrna kwôy yôd. Na en ay yen biɲ Emen môɲ wo kenbay kêm kemnêŋ ken liɲ hen iyôŋ men, ");
INSERT INTO kqp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","en geliɲ tu ɓiɲé ka ay geré wo Kelma hen, gusiɲ men, ka pôni uwôɲ temare a men, en bi bay pô imɲê ré yébé ré bay harê kôbriji naɲ musure aɲ biji daŋgay a men. ");
INSERT INTO kqp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","*Dami wo damné kaɲ bay bê kwôbe naɲ surɲê kêm a kelêŋge mega wo ené kôl na tiri, wôsa na bay a na lê magtubu ben wô yênêrna Jubɲê ka Damas a, na wô perê bay ayê bôô ka ya hen heraɲ naɲ ci Jérusalêm a wô gelji gusiɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«En ô ô, menba, kiriɲa en baa ɗa naɲ Damas na, tare ɗebu ɗiŋne niɲ menba, kiriɲ ka peraŋgi ka dami hena derômaraŋ a sa peraŋge kiriɲ kwan a. ");
INSERT INTO kqp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","En kuriɲ tôŋ menba, en toy tôô kwôni kôlen iyôŋ ba: ‹Sôl, Sôl, wô mi a jeré gelen gusiɲ hen iyôŋ ba?› ");
INSERT INTO kqp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","En eŋgere iyôŋ ba: ‹Ju na i ba, Kelma?› Menba, kwôni bi wo hen kôlen iyôŋ ba: ‹Ena Jésu wo Najarêt, na nôbi a jeré gelen gusiɲ hen.› » ");
INSERT INTO kqp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","«Ɓiɲé ka ô naɲ en hen na, bay gel kiriɲ ka peraŋgi bay ka hen, niɲba, bay toy tôô kwôni bi wo iyêlen hen né. ");
INSERT INTO kqp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","En eŋgere iyôŋ ba: ‹Kelma, na mi a ené lê niɲ ba?› Menba, Kelma uwôlen sara iyôŋ ba: ‹Hena ta, ju ô Damas a, bay a gelem are kêm ka Emen ay tôri bem bi jeré li hen.› ");
INSERT INTO kqp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Niɲba, peraŋgê wo kiriɲ ré peraŋge hen na, jôren gelé kiriɲ aɲ na bay bêren hen, a ɓeré kôben ôriɲ naɲ en Damas a. ");
INSERT INTO kqp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kiriɲ bay ka hen na, gawra wo pôni bay uwôgeri Ananiyas na kwôni wo tebe Emen men, bi kwôlê sa tôô tona a a men, aɲ Jubɲê ka Damas a kêm dô kwôli dô. ");
INSERT INTO kqp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ôbi era sa uɲen ɗebu kwan a aɲ kôlen iyôŋ ba: ‹Yênen Sôl bi ju hô gel kiriɲ hôriɲ.› Menba, kiriɲ bay ka hen na, en hô gel kiriɲ hôriɲ aɲ en gili. ");
INSERT INTO kqp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ôbi kôlen iyôŋ ba: ‹Emen wo môɲêrna a dôrem bi jeré hôn bô geyé wori men, jeré gel kwoɲ ôbi lê aŋgaɲ derôre hen men, jeré toyiɲ kwôlo ôbi ré kôlem naɲ kibri wori hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Já yé ôbi kelê kwôli tumô gawrê kêm gengiɲ sa aŋga ju gel naɲ tum hen men, ka ju toy naɲ mam hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wô mi a jeré hô gaanê sôŋ ba? Hena ta, ô ju ô lê batêm aɲ bi têriɲ tom ré piliɲ aɲ naɲ hini.› » ");
INSERT INTO kqp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Kiriɲa en hera Jérusalêm a na, wulê wo pôni en uwôl Emen bô *iyéy Emen a menba, pelal jôren, ");
INSERT INTO kqp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","en gel Kelma aɲ ôbi kôlen iyôŋ ba: ‹Hena lew ju si ô aɲ Jérusalêm a, wôsa bay a toyé kwôlê wuɲê wo ju dôrji hen né.› ");
INSERT INTO kqp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","En uwôli sara iyôŋ ba: ‹Kelma, bay hôn dô wo na ré na nôbi a na ré erê naɲ bô *iyéy daɲare iyéy daɲare perê ɓiɲé ka bi bôrji sam a hen biji daŋgay aɲ sêji a men hen. ");
INSERT INTO kqp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Men, kiriɲa bay na duu Etiyên woɲ ôbi derê kwôlem hen na, nôbi kôba, na en ya men, na en biɲ naɲ bay deréri bay ka hen men, na en gem bargay kaji a men.› » ");
INSERT INTO kqp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«Niɲba, Kelma kôlen iyôŋ ba: ‹Ô, wôsa na jém kelaŋ uɲé ɓiɲé ka na Jubɲê ré hen.› » ");
INSERT INTO kqp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɓiɲé dôbe marji toyiɲ kwôlo Pol bi wo hen kwôy sa biɲ sa kwo ôbi kôl wô erê uɲé ɓiɲé ka sa iyére to ɗaŋgi a hen menba, bay karê gura kôl iyôŋ ba: «Gawra wo hen iyôŋgi hen na, bi mêniɲ sa terare a nà aɲ! Ôbi dé bi ré gôl ré.» ");
INSERT INTO kqp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bay karê gura men, tô bargay kaji lêrê belgey belgey men, pôrji terare wusiré ta a men. ");
INSERT INTO kqp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Menba, dami wo asgarɲê bi bay ôriɲ naɲ Pol bô galay a bi bay ré ô yêmnêri aɲ eŋriɲni kwôlê hôniɲ tô aŋga ôbi ré li aɲa ɓiɲé ré karê gura sari a hen. ");
INSERT INTO kqp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Niɲba, kiriɲa bay ca harêri aɲ bi ciré yêmnêri menba, Pol kôliɲ ôbi sa asgarɲê wo wulê bi wo hen iyôŋ ba: «Ken ôriɲ naɲ tôô toɲ sê kwôni wo na Rômê wo kwôlê ɓiri ré tô hen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kiriɲa ôbi toy hen iyôŋ menba, ôbi ô kôliɲ dami woji iyôŋ ba: «Já lê iyeŋ ba? Gawra bi wo hen na Rômê.» ");
INSERT INTO kqp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Menba, dami wo asgarɲê bi wo hen eŋgere Pol iyôŋ ba: «Kôlen, ju na Rômê tiri a men ba?» Menba, Pol uwôli sara iyôŋ ba: «Ew, ena Rômê.» ");
INSERT INTO kqp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ôbi hô kôl iyôŋ ba: «Nôbi en têbe damaŋ dema ené yiɲ Rômê tô.» Menba, Pol kôl iyôŋ ba: «Nôbi en yêɲ Rômê.» ");
INSERT INTO kqp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɓiɲé ka ré ca eŋgeriri kwôlê hen na, dô tôrji wolé ligi Pol a men, dami wo asgarɲê bi wo hen kôba, harê liri men, kiriɲa ôbi hôn wo Pol ré na Rômê aɲ ɗiré bi bay ré harêri naɲ gaŋgi musure hen. ");
INSERT INTO kqp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dami wo asgarɲê bi wo hen gey henê tô kwôlo Jubɲê ré ɗiɲ Pol sari a hen. Aɲ kiriɲa kiriɲ wôl menba, ôbi bi bay besere musure têri a, aɲ ay tôri biɲ bay sa bay bê kwôbe naɲ sanédrên kêm bi bay ré daɲ. Menba, ôbi eraɲ naɲ Pol sa ɗiji tumôrji a. ");
INSERT INTO kqp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol bô surɲê ɗéɲ a bô tirji a aɲ kôlji iyôŋ ba: «Yênên, na naɲ bôô pôn a ené ayiɲ geré wo Emen bi wo hen ca yeŋ kwôy saɲ kemnêŋ hen.» ");
INSERT INTO kqp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Menba, *dami wo damné kaɲ bay bê kwôbe Ananiyas kôliɲ bay tôri ka ɗebu ɗa kwa Pol a hen bay ré sê kibri. Menba, Pol kôli iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","«Na jôbi a Emen ré dêm tumô, gweŋ wo bôri. Ju mô na wô jerê kwôlê naɲ tôô menba, tôô hende to hen ju ɗage sare aɲa jeré kôlji bi bay ré sên hen.» ");
INSERT INTO kqp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ɓiɲé ka ɗebu ɗa kwa Pol a hen kôli iyôŋ ba: «Ju ô kwôy tiiré dami wo damné kaɲ bay bê kwôbe wo Emen!» ");
INSERT INTO kqp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Menba, Pol uwôlji sara iyôŋ ba: «Yênên en hôn wo ré na dami wo damné kaɲ bay bê kwôbe ré, wôsa liɲ bô magtubu a kôl iyôŋ ba: ‹Já tiiré ôbi sa ɓiɲé kam né.› » ");
INSERT INTO kqp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol hôn wo kwa surɲê ré na *Sadusiɲêɲê men, kwarji ré na *Parisiɲêɲê men, na ôbi a, ôbi ré hena ɗebu ta tumôrji a aɲ kôl kaŋ a ta kôl iyôŋ ba: «Yênên, ena Parisiɲê, kema Parisiɲê, na wôsa en hôn mega ɓiɲé ka ma ré jê sé kamɲê hen, a kené ka jerê kwôlê san a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kiriɲa Pol kôl hen iyôŋ menba, nariɲare kwôlê yi perê Sadusiɲêɲê naɲ Parisiɲêɲê menba, daɲare kariɲ kini wôô. ");
INSERT INTO kqp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Wôsa Sadusiɲêɲê kôl iyôŋ ba, ɓiɲé ka ma ré jê sé kamɲê ré men, *mana wo derômaraŋ a ré naɲ men, tunu to habiɲ kôba, ré naɲ a men. Niɲba, Parisiɲêɲê ba kôl are bay ka kêm hen ré ya men. ");
INSERT INTO kqp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Heragê ôm wuu menba, *bay derê tô tôô to Emen ka pôni perê Parisiɲêɲê henaji karji maɲê naɲ nérji aɲ bay kôl iyôŋ ba: «Nini uwôɲ kwôlê wôni woɲ uwôliɲ kwôlê sa gawra wo na a ré. Na tunu tôni réba, na mana wo derômaraŋ a a kôli kwôlê bi wo hen kôba nana hôn né.» ");
INSERT INTO kqp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bay nariɲ kwôlê uwoy tumô tumô menba, dami wo asgarɲê hare wô wo bay ma ré yêgerê Pol derôre a menba, kôliɲ asgarɲê ré ô perêrji a hen ré dera Pol heraɲ naɲ ɗi bô galay a. ");
INSERT INTO kqp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Derô yoyre menba, Kelma si sa Pol a aɲ kôli iyôŋ ba: «Ɓu yem ibiyare, ju dera kwôlen Jérusalêm a niɲ, aɲ baa wo Rôm a kôba, já derê kwôlen hen iyôŋ men.» ");
INSERT INTO kqp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kiriɲa kiriɲ wôl naɲ tô kiriɲ menba, Jubɲê gerji sa Pol ta ta aɲ dusu yirji kôl iyôŋ ba, ciré emê ani ré men, yê ani ré men, kwôy wo ciré deriɲ Pol. ");
INSERT INTO kqp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ɓiɲé ka way kwôli Pol hen na, bay ɗê tôre pôrbu. ");
INSERT INTO kqp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bay ô uɲé bay sa bay bê kwôbe naɲ surɲê aɲ kôlji iyôŋ ba: «Nini dusu yirni niné emê ani ré kwôy wo niné deriɲ Pol iyôŋ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kenbay naɲ surɲê kêm ken ô kôliɲ dami wo asgarɲê ré eraɲ naɲ Pol béŋge bi kené hô kebê kwôli gelé sôŋ, aɲ nibay ba, niɲa ɲanê yirni aɲ kiriɲa bay eraɲ naɲ ɗi menba, niɲa deréri geré.» ");
INSERT INTO kqp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Menba, kuna Pol woɲ kema yêri toy kwôlê bi wo hen iyôŋ menba, ô bô galay a ô kôli ta. ");
INSERT INTO kqp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Menba, Pol jé uwôgê ôbi sa asgarɲê wo pôni aɲ kôli iyôŋ ba: «Ôriɲ naɲ kema mana wo hen ligi dami woŋge a ôbi ôriɲ naɲ kwôlê pôn ya ɗa kôli.» ");
INSERT INTO kqp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ôbi sa asgarɲê bi wo hen ôriɲ naɲ ɗi biɲ dami woji aɲ kôli iyôŋ ba: «Pol woɲ daŋgay hen, a kelê ené eraɲ naɲ kema mana wo nà bem wôsa ôbi ré ôriɲ naɲ kwôlê pôn ya wô kôlem.» ");
INSERT INTO kqp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Dami wo asgarɲê bi wo hen ɓu kôbi kema bi wo hen ôriɲ naɲ ɗi wolé eŋgereri iyôŋ ba: «Na kwôli mi a jeré gey kôlen ba?» ");
INSERT INTO kqp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Menba, ôbi uwôli sara iyôŋ ba: «Jubɲê way bi ciré era sa kôlem jeré bi Pol kiya ré ô tumô sanédrên a mega ciré erê kebê tô kwôli gelé sôŋ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Niɲba, ju bi bôm sa kwôlê woji a ré wôsa ɓiɲé ɗê tôre pôrbu perêrji a uwôbê tô geré gemni, wôsa bay dusu yirji ciré emê ani ré men, yê ani ré men, kwôy wo ciré deriɲni, bay ɓu sa têrji kô niɲ aɲ bay gem na toyé kwôlê wom mera.» ");
INSERT INTO kqp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Dami wo asgarɲê bi wo hen ɗi kema mana bi wo ô aɲ kôli iyôŋ ba: «Kwôlo ré kôli hen na, kwo ré kôliɲ kwôni wo ɗaŋgi ré pa pa.» ");
INSERT INTO kqp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Menba, dami wo asgarɲê na uwôga bay sa asgarɲê wôô aɲ kôlji iyôŋ ba: «Ɓeréŋge sa têrŋge naɲ asgarɲê arew wôô men, asgarɲê kaɲ bay yêndê tôre jurgem men, bay jebé tôrŋge kaɲ bay dargaw hen arew wôô a men aɲ ka erê Sésaré yoyre hende to hen kiriɲa ɓiɲé ô yé tôŋ tôŋ hen. ");
INSERT INTO kqp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wogéŋge yêndê ken biɲ Pol aɲ ken ôriɲ naɲ ɗi naɲ derêri ô biɲ Pélis ôbi emê sa iyére.» ");
INSERT INTO kqp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ôbi li magtubu biji kôbri a kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Klodiyus Lisiyas, a lê magtubu hende to hen biɲ dami wuɲê ôbi emê sa iyére Pélis, en lêm dosé! ");
INSERT INTO kqp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jubɲê ɓu gawra wo en jéɲ bem hen aɲ bay gey diri menba, en ôriɲ naɲ asgarɲê dema ené derari kôbriji a wôsa en toy wo ôbi ré na Rômê. ");
INSERT INTO kqp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","En gey ené henê tô kwôlo bay ɗiri sari a hen menba, en bi bay ôriɲ naɲ ɗi tumô sanédrên a. ");
INSERT INTO kqp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Menba, gel mega kwôlo bay ɗiri sari a hen na, gengiɲ na, sa nariɲay kwôlo gengiɲ sa tôô toji aɲ kwôlê wôni wo nêm deréri lay, yé daŋgay lay ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kiriɲa en toy mega wo bay ré ɓu sa têrji ciré deréri, na ôbi a, ené jéɲ naɲ ɗi bem aɲ na kôliɲ bay ɗéri kwôlê sari a bay ka hen ré ô kaŋgêri tumôm a.» ");
INSERT INTO kqp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Asgarɲê bi kwôlê sa tôô to dami woji ré ay biji hen, aɲ bay ôriɲ naɲ Pol yoyre hende to hen kwôy Antipatris a. ");
INSERT INTO kqp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kiriɲa kiriɲ wôl menba, asgarɲê ka naɲ têrji hen bilji hô galay a aɲ ɗiji bay yêndê a ôriɲ naɲ Pol. ");
INSERT INTO kqp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kiriɲa bay ô biɲ Sésaré a menba, asgarɲê kaɲ bay yêndê biɲ kelma Pélis magtubu hende to hen men, bay dôbri Pol kôbri a men. ");
INSERT INTO kqp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ôbi dêŋse magtubu hende to hen aɲ eŋgeriɲ Pol iyôŋ ba: «Kwo ré na gawra wo bô emê wo yôŋ ba?» Menba, kiriɲa bay kôli ôbi ré na kwôni wo Silisi a, ");
INSERT INTO kqp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","menba, ôbi kôli iyôŋ ba: «Kiriɲa kamaŋ ka ɗém kwôlê sam a hen a saji pa dema ené eŋgerem kwôlê tô.» Aɲ ôbi ay tôô bi bay ré ôriɲ naɲ ɗi ô geméri iyére to *Hérôd na ɗi hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wulê bay cêgê menba, Ananiyas *dami wo damné kaɲ bay bê kwôbe naɲ surɲê ka pôni saji Sésaré naɲ gawra wo bay uwôgeri Têrtulus woɲ ôbi iré kwôlê woji, bay ô wô kaŋgê Pol kibi Pélis ôbi emê sa iyére. ");
INSERT INTO kqp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pélis jé uwôga Pol aɲ Têrtulus uwôli kwôlê sari a kôl iyôŋ ba: «Dami wuɲê Pélis, na wô sa kem jôbi aɲa niné môriɲ naɲ bô jalê hen men, na sa kibi tu melênê wom aɲa kiriɲ ré ɲaniɲ wô derê wo sa iyére hende to hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Na kibi kelanêrem jôbi dami wuɲê Pélis aɲa niné uwôɲiɲ are kêm kwôy kwôy naɲ kiriɲ kiriɲ hen, nini lêm dosé. ");
INSERT INTO kqp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bi ené jebam ré na, na kelê kwôlê ɗêj iyôŋ mera, na ôbi a, ené uwôlem dôbê mam ju toyiɲ kwôlo niɲa kôlem hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nini bô mega gawra bi wo hen na, ré na ôbi mênê kiriɲ wo habiɲ men, ôbi cube tu Jubɲê ka sa terare a nà kêm men, ôbi a na ôbi sa ɓiɲé ka bay uwôgeji *Najarêtɲê hen men. ");
INSERT INTO kqp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ôbi woge ɗiré mênê *iyéy Emen aɲa niné ɓiri. Nini gey niné jerê kwôlê sari a naɲ tôô toni, ");
INSERT INTO kqp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","niɲba, dami wo asgarɲê Lisiyas era sa dôri kôbrini a naɲ néé, ");
INSERT INTO kqp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","aɲ kôliɲ bay ɗéri kwôlê sari a bay ka hen ré era sa kaŋni tumôm a. Hena jeré eŋgeriri kwôlê na, kwôlo ôbi a uwôlem sara hen na, já kelê kwôlo niné kôl hen na, ré na tiri mera.» ");
INSERT INTO kqp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jubɲê kêm kôl iyôŋ ba: «Kwôlo Têrtulus ré kôl hen na, ré na tiri.» ");
INSERT INTO kqp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ôbi emê sa iyére liɲ Pol kôbri ré iyêl menba, ôbi uwôli sara kôl iyôŋ ba: «En hôn wo jeré na ôbi jerê kwôlê bô iyére tona ca yeŋ elê kwône aɲ na naɲ bôô pôn a ené iyêlê kwôlê tumôm a jôriɲ san hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Jôbi ju eŋgere ju gel, li wulê môj kibi wôô ré tô wo en ô Jérusalêm a wô tibé Emen. ");
INSERT INTO kqp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aɲ kwôni gelen en iyêl naɲ kwôni derô haba wo *iyéy Emen a ré men, en gwôse ɓiɲé iyéy daɲare a ré men, kiriɲ ka ɗaŋgi a derô ira ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓiɲé bay ka hen bay nêm derê tô kwôlo bay ɗén san a haw hen né. ");
INSERT INTO kqp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Niɲba, aŋga li are a na: En hôn wo ené na mana wo Emen wo môɲêrni naɲ geré wo kôrbi bi wo bay kôl ré na kwo habiɲ hen men, en bi bôn sa kwôlo magtubu to Emen toɲ tôô a naɲ to bay kibi Emen kôl a hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","En bi bôn sa Emen a aɲ bay kôba, bi bôrji sara mega wo ɓiɲé ka li aŋgaɲ derôre naɲ kaɲ bay lê habrê hen kôba, ré jêji sé kamɲê. ");
INSERT INTO kqp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Na ôbi á, ené mase bi ené yiɲ kwôni woɲ ôbi bôô pôn tu Emen a men, tu gawrê a men hen.» ");
INSERT INTO kqp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Li elê kwône cêgen wo en henaɲ Jérusalêm a ôriɲ a menba, en heraɲ naɲ gursu to bay ɓeriɲ baliyare naɲ balên hen wô biji men, wô lê sarga biɲ Emen a men. ");
INSERT INTO kqp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na aŋga en li bay ka bay gelen derô haba wo iyéy Emen a bay a hen. En li naɲ ɓiɲé hara woɲ lôɲê yi hen aɲ kwônê ɓiɲé na naɲ naɲ en men, kwôni li ani kani kaɲ maɲê ré a men. ");
INSERT INTO kqp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Niɲba, na Jubɲê ka pôni ka Asi ka uɲen hen, aɲ hena kwôlê wôni ré ya kôba, ré na bay a ré sa kaŋgen tumôm a ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kwo kamaŋ ka ɗube nà ná, bi bay kôl kwôli aŋga habiɲ ka en li li kiriɲa na en ɗube tumô sanédrên a hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Na wô sa kwôlê pôn nêŋ wo na en kôl kaŋ a ta ɗebiɲ perêrji a hen a, bay ré uwôliɲ kwôlê san a. Na en kôl mega wo ɓiɲé ka ma ré jê sé kamɲê, na ôbi a, ené ɗebiɲ tumôrŋge a hen, a kené ka jerê kwôlê san a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pélis hôn kwôlo gengiɲ sa ayê bôô hen dô, aɲ ôbi jô kibi sariya na ta aɲ kôl iyôŋ ba: «Kiriɲa dami wo asgarɲê Lisiyas a sa dema ené jerê kwôlê woŋge bi wo hen tô.» ");
INSERT INTO kqp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ôbi kôliɲ ôbi sa asgarɲê kaɲ bay gemé Pol hen ré hôriɲ naɲ ɗi daŋgay a niɲba, bi bay ré li iyêre naɲ ɗi ré men, bay ré ɗi bi milɲêri ka ré gey ba, ré sa gili men, ré li naɲ ɗi a men. ");
INSERT INTO kqp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wulê sem cêgê menba, Pélis naɲ tamni Drusil saji. Hende na Jub. Menba, ôbi jé uwôga Pol aɲ toy kwôlo ôbi kôl gengiɲ sa bê bôô sa Jésu Krist a. ");
INSERT INTO kqp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mega Pol kôl wô lê aŋgaɲ derôre men, ɓeré yi naɲ jerê kwôlê wo a era hen a men, hen na, deŋgô Pélis tiri aɲ ôbi kôli iyôŋ ba: «Hô ham niɲ aɲ hen na, ené uwôɲ tulmô kiriɲ dê ba na hô jé uwôgam tô.» ");
INSERT INTO kqp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ôbi kôl yaŋ ba, Pol ma ré biri gursu aɲa ré jé uwôgeri kwôy kwôy wô iyêlê naɲ ɗi hen. ");
INSERT INTO kqp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Elê wôô cêgê menba, Pôrkiyus Pêstus ay kenare hôlmê Pélis. Mega wo Pélis gey bi yi Jubɲê ré dôrji sari a hen iyôŋ menba, ôbi ɗi Pol daŋgay a. ");
INSERT INTO kqp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pêstus sa kini ayê kenare tori a, li wulê subu menba, ôbi hena Sésaré ô Jérusalêm a. ");
INSERT INTO kqp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Aɲ damné kaɲ bay bê kwôbe Emen, naɲ bay sa Jubɲê ôrji ô kaŋgê Pol yiri a aɲ bay maseri damaŋ ");
INSERT INTO kqp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bi ôbi ré heraɲ naɲ Pol Jérusalêm a. Ermé woji a na: bay way kwôli aɲ bôrji a ba, bay gey uwôbê tô geré wô deréri. ");
INSERT INTO kqp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Niɲba, Pêstus kôlji iyôŋ ba: «Pol ré yi daŋgay a Sésaré a aɲ ɗôbi kôba, ɗiré ɗa herê na herê ya haw hen.» ");
INSERT INTO kqp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ôbi hô kôlji iyôŋ ba: «Bi bay sarŋge hô naɲ en Sésaré aɲ hena gawra bi wo hen ré li ani ka habiɲ ya ba, bi bay ô kaŋgêri!» ");
INSERT INTO kqp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pêstus wôl Jérusalêm a wulê marge réba môj mera menba, bul hô Sésaré, aɲ kiriɲa kiriɲ wôl menba, ôbi ô kini jerê kwôlê a aɲ bi bay eraɲ naɲ Pol. ");
INSERT INTO kqp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kiriɲa Pol sa menba, Jubɲê ka hena Jérusalêm hen mééri ta aɲ ɗiri kwôlo dami dami sari a niɲba, bay nêm gelé ɗêrêrê aŋga habiɲ bay ka ôbi li hen né. ");
INSERT INTO kqp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Niɲba, Pol iyêl kwôlê jôriɲ sari kôl iyôŋ ba: «En li ani kani ka habiɲ gengiɲ sa tôô to Jubɲê ré men, gengiɲ sa *iyéy Emen ré men, gengiɲ sa ôbi emê sa iyére wo dami *Sésar ré a men.» ");
INSERT INTO kqp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pêstus gey bi yi Jubɲê ré dôrji sari a menba, ôbi kôliɲ Pol iyôŋ ba: «Ju gey erê Jérusalêm a bi ené ɲanê kwôlê wom yeŋ ba?» ");
INSERT INTO kqp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Niɲba, Pol uwôli sara iyôŋ ba: «En ɗebu na kini jerê kwôlê wo ôbi emê iyére wo dami Sésar a na aɲ na na hende to hen a kwôlê ré a jôriɲ san a. Mega wo ju gel hen iyôŋ na, nôbi en liɲ Jubɲê ani kani ka habiɲ ré yôd. ");
INSERT INTO kqp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Hena kwôlê wôni ré ɓu san lay, hena ené li ani kani ka habiɲ ka nêm wo bay ré deren ná, na kaɲê bi bay ré deren né ré, niɲba, hena kwôlo bay ɗén san a hen, ré na kwôlê woɲ ɗéɲ iyôŋ na, kwôni nêm wo a ayen biji ré. En gey bi ôbi emê sa iyére wo dami Sésar ré ɲan kwôlê woni bi wo hen.» ");
INSERT INTO kqp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Menba, Pêstus eŋgeriɲ bay tôri kwôlê aɲ toy kwôlê wo bay kôli hen aɲ kôliɲ Pol iyôŋ ba: «Ju gey bi ôbi emê sa iyére wo dami Sésar ré ɲan kwôlê woŋge bi wo hen niɲ na, já erê tumôri a.» ");
INSERT INTO kqp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Wulê sem iyôŋ cêgê menba, kelma Agripa naɲ yêri Bérénis saji Sésaré a wô liɲ Pêstus dosé. ");
INSERT INTO kqp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mega wo bay wôl nêm kwôlê hen iyôŋ na, Pêstus dôriɲ Agripa kwôli Pol kôl iyôŋ ba: «Gawra wo pôni wo Pélis na ɗiri daŋgay a hen nà ya. ");
INSERT INTO kqp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kiriɲa na en ô Jérusalêm a menba, damné kaɲ bay bê kwôbe naɲ surɲê ka Jubɲê eraji sa kaŋni aɲ bay gey bi kwôlê ré ɓiri. ");
INSERT INTO kqp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Niɲba, en kôlji iyôŋ ba: ‹Tôô to Rômêɲê kôl jeré ɓéré kwôni iyôŋ mera baa wo ôbi naɲ ka ɗiri kwôlê sari a hen môrji ɓem men, baa wo ôbi ré dô kwôlê jôriɲ sari ré a men.› ");
INSERT INTO kqp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bay saji na naɲ en, aɲ kiriɲ wôl, en dô bul ré tô menba, en ô kini jerê kwôlê a aɲ en bi bay eraɲ naɲ gawra bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bay ɗéri kwôlê sari a bay ka hen saji niɲba, kwôli ani kani ka habiɲ ka ôbi li ɗêrêrê iyôŋ ba: en gel ré. ");
INSERT INTO kqp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bay nariɲ naɲ ɗi na kwôli lê kwôlo Emen woji men, kwôlo gengiɲ sa gawra wo pôni wo bay uwôgeri Jésu wo ma niɲ niɲba, Pol kôl ôbi ré hô mô geɲ baa ya hen. ");
INSERT INTO kqp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aɲ kwôlo na ulê sa kwôlo hen iyôŋgi a ba, en hôn né, menba, en eŋgeriɲ Pol kwo ré gey herê Jérusalêm a bi bay ré ô jerê kwôlê sari a yaŋ ba? ");
INSERT INTO kqp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Niɲba, Pol gey bi ôbi emê sa iyére wo dami Sésar ré ɲan kwôlê woji bi wo hen aɲ en bi bay gemni daŋgay a kwôy wo na jéɲ naɲ ɗi tumô ôbi emê sa iyére wo dami Sésar a.» ");
INSERT INTO kqp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Menba, Agripa kôliɲ Pêstus iyôŋ ba: «Nôbi en gey toyé kwôlo gawra bi wo hen men.» Menba, Pêstus uwôli sara iyôŋ ba: «Kiya tôŋ hen já toyéri mera.» ");
INSERT INTO kqp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kiriɲa kiriɲ wôl menba, si Agripa naɲ yêri Bérénis saji naɲ kwônê ɓiɲé men, bay sa asgarɲê men, damné ka derô ira a men kini jerê kwôlê a aɲ Pêstus bi bay eraɲ naɲ Pol. ");
INSERT INTO kqp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Aɲ ôbi kôl iyôŋ ba: «Kelma, Agripa, men, kenbay kêm ka mô naɲ ni na, ken gel gawra wo hen wo Jubɲê kêm eraji sa uɲen Jérusalêm a men, tôŋ na men, wô kwôli aɲ karêji gura kôlji ciré gey bi ôbi ré ma. ");
INSERT INTO kqp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kuɲê nôbi ba, aŋga ôbi li ka nêm deréri ba, en gel ré, niɲba, mega wo ôbi gey ôbi emê sa iyére wo dami Sésar ré ɲan kwôlê wori hen iyôŋ niɲ na, en genge ené jéɲ naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aɲ kwôlê wôni wo ené liɲ magtubu biɲ ôbi emê sa iyére wô sari ya ba, en gel ré, na ôbi á, ené biri ôbi era tumôrŋge a na men, tumôm jôbi kelma Agripa a men, aɲ kiriɲa jeré eŋgeriri kwôlê ba, bi ené uwôɲ kwôlê wôni ba, ené liɲ magtubu biɲ ôbi emê sa iyére Sésar. ");
INSERT INTO kqp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A yé mega kwôlê woɲ galê iyôŋ, hena ené jéɲ naɲ kwôni woɲ daŋgay baa lê magtubu kôliɲ kwôli aŋga bay ɗiri sari a hen né.» ");
INSERT INTO kqp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa kôliɲ Pol iyôŋ ba: «Jôbi ju dô kwôlê wom.» Menba, Pol ay kôbri ta aɲ dô kwôlê wô jôriɲ sari aɲ kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Kelma Agripa, kwôlê kêm wo Jubɲê ɗén san a hen na, yen dôren gaɲ wô derê kwôlê wuɲê tumôm a kemnêŋ. ");
INSERT INTO kqp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Wôsa ju hôn hal wo Jubɲê men, nariɲay kwôlê woji a men. En uwôlem uwôl bôm aɲ ju toyiɲ kwôlo na kelê hen.» ");
INSERT INTO kqp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Jubɲê kêm hôn hal wuɲê naɲ kamɲên men, hal wuɲê wo ca yeŋ wo na en môriɲ perê balên a Jérusalêm a hen men, ");
INSERT INTO kqp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","bay hônen ca yeŋ men, hena bay ré gey kôba, bay a derê kwôlen a men mega wo tô lê kwôlo Emen woni a ba, ené na *Parisiɲê woɲ ɗéɲ kaɲ bay lê tôô ɗê tô ɓiɲé ka baa hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aɲ haw hen bay eraɲ naɲ en kini jerê kwôlê a nà wô sa bê wo en bi bôn sa kwôlo Emen na ayiɲ tôri biɲ môɲêrni hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Aɲ tô yê woni wo môj kibi wôô hen bi bôrji wô gelé are bay ka Emen na ayiɲ tôri hen, liɲ. Na ôbi á, bay ré tebri yoyre naɲ tu tare naɲ bôô pôn hen, kelma Agripa, na wô sa bê bôô sa are bay ka Emen na genge hen, aɲa Jubɲê ré ɗén kwôlê san a hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Wô mi a kenbay Jubɲê kené bô mega wo Emen né biɲ ɓiɲé ka ma ré jê sé kamɲê ré ba?» ");
INSERT INTO kqp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Nôbi naɲ yen na en erem mega wo ené lê are bay ka kêm hen wô mêniɲ hini Jésu wo Najarêt. ");
INSERT INTO kqp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na hen iyôŋ a, na ené li Jérusalêm a, en pô bay ayê bôô kwône bi daŋgay a naɲ tôô to bay sa bay bê kwôbe ay ben men, kiriɲa bay ca dirji kôba, en biɲ naɲ bay derérji bay ka hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","En ô naɲ *iyéy daɲare iyéy daɲare gelji gusiɲ damaŋ aɲ bi bay ré ɗéɲ tô ayê bôô woji men, bôn bi wo taren sarji a hen na, en ô wô gelji gusiɲ sa iyére to ɗaŋgi a a men.» ");
INSERT INTO kqp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Na hen iyôŋ a, ené ô ené erê Damas a naɲ néé men, tôô to bay sa damné kaɲ bay bê kwôbe ay ɗôd ben hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kelma Agripa, kiriɲa en baa geré tô menba, naɲ tay ɗiŋne menba, en gel kiriɲ ka peraŋgi hena derômaraŋ a aɲ berare ɗê tare aɲ aɲ peraŋgê woji bi wo hen era sa peraŋge kiriɲ kwan a naɲ kamaŋ ka ô naɲ en hen men. ");
INSERT INTO kqp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nini heriɲ tôŋ terare a kêm menba, en toy tôô kwôni kôlen naɲ kibi yê wo Jubɲê kôl iyôŋ ba: ‹Sôl, Sôl, wô mi a jeré gelen gusiɲ hen iyôŋ ba? Ɗebé wo ju ɗeben iyêre hen na, ju mêne na yem wom ɗéɲ iyôŋ.› ");
INSERT INTO kqp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","En eŋgere iyôŋ ba: ‹Ju na i ba, Kelma› menba, Kelma uwôlen sara kôl iyôŋ ba: ‹Ena Jésu, na nôbi a jeré gelen gusiɲ hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Niɲba, hena ju ɗebu ta. En si sam a na wô wo jeré yi mana wuɲê men, ôbi derê kwôlen wô kôliɲ ɓiɲé kwôli sé wo en si sam a hen men, wô gelé wo ju gelen kemnêŋ hen men, wô ulêji béré aŋga na gelen hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Na dôren kôbi Jubɲê men, kôbi ɓiɲé ka sa iyére to ɗaŋgi a ka na jém yirji a hen a men. ");
INSERT INTO kqp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","En jém bi jeré bi tirji ré jôriɲ men, bi jeré deraji bô kiriɲ kaɲ dilemne a heraɲ kiriɲ ka peraŋgi a men, jeré deraji bô néé wo Sidan a eraɲ kwo Emen a aɲ kiriɲa bay ré bi bôrji sari a ba, bi ôbi ré ɗiɲ bôri jal sa têriɲ toji a aɲ bay ré uwôɲiɲ kiriɲ perê ɓiɲé ka na ka Emen hen men.› » ");
INSERT INTO kqp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kelma Agripa, kiriɲ bay ka hen na, en bi kwôlê sa pelal bi wo hena derômaraŋ a bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Menba, en dôriɲ ɓiɲé ka Damas a naɲ ka Jérusalêm a kwôlê tumô dema ené dôriɲ ka bô emê wo Judé a kêm men, en dôriɲ ɓiɲé ka sa iyére to ɗaŋgi a, aɲ en kôlji bi bay ré ɗi tô jé lêreji wo cay hen baa, aɲ bay ré bul uɲé Emen aɲ bi jé lêreji ré gel wo coré bul hal woji bi wo hen tiri a men. ");
INSERT INTO kqp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na tôri bi wo hen a, Jubɲê ré gelen wo en ô derô haba wo *iyéy Emen a menba, bay ɓeren ciré deren ôbi a hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Na wô ulê wo Emen uwôl kôbri baa ya san a kwôy kemnêŋ aɲa ené ɗebiɲ dôriɲ kwôlê biɲ ɓiɲé kêm, ka beray men, ka damné men, en kôl na kwôli aŋga magtubu to bay kibi Emen naɲ tôô to *Moyis na kôl tumô niɲ ré sa hen ɗiba, en kôl kwôli aŋga ɗaŋgi kani ré. ");
INSERT INTO kqp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bay na kôl iyôŋ ba, Mési, kwo Emen dôri hen réé geliɲ gusiɲ men, ôbi ré yé kwo tumô wo ré jê sé kamɲê perê ɓiɲé ka ma a men, ôbi ré ulê béré kiriɲ ka peraŋgi kaɲ gelê biɲ Jubɲê men, biɲ ɓiɲé ka sa iyére to ɗaŋgi a a men.» ");
INSERT INTO kqp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Mega wo Pol iyêl hen iyôŋ menba, Pêstus ôn tôri kôl iyôŋ ba: «Ju gal Pol, ju dôyrê are gaɲ, aɲ lêm aɲ ju gal.» ");
INSERT INTO kqp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Niɲba, Pol uwôli sara iyôŋ ba: «En gal ré, Dami wuɲê Pêstus, na kwôlê woɲ tiri men, kwoɲ derôre a men a ené kôl hen. ");
INSERT INTO kqp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kwôli are bay ka en dô biɲ kelma Agripa hen na, ôbi hôn dô. Iyôŋ ba, na naɲ ibiyare a ené iyêlê tumôri a hen. En hôn wo ôbi ré hôn kwôli are bay ka hen kêm. Wôsa are bay ka kêm hen na, liɲ na kini uwôbê ré. ");
INSERT INTO kqp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kelma Agripa, ju bi bôm sa kwôlo bay kibi Emen a na kôl hen ba? En hôn wo jeré bi bôm sara.» ");
INSERT INTO kqp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kôliɲ Pol iyôŋ ba: «Sem a menba, já lên na yé ôbi ayê bôô.» ");
INSERT INTO kqp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol uwôli sara iyôŋ ba: «Ré na kemnêŋ, ré wôl gaɲ kôba, na kwôlê wôni ré, niɲba, en uwôl Emen bi ré na jôbi penem mera ré niɲba, kenbay kêm ka ken mô toy kwôlo en dô kemnêŋ hen kené ay bôrŋge môɲ nôbi iyôŋ, ɗiba en gey bi kené yi daŋgay a môɲ kuɲê iyôŋ né.» ");
INSERT INTO kqp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kelma men, ôbi emê sa iyére men, Bérénis naɲ ɓiɲé kêm ka mô naɲ ci hen henaji ta. ");
INSERT INTO kqp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Aɲ kiriɲa bay dô yirji wolé menba, bay kôliɲ perêrji a iyôŋ ba: «Ani ka gawra bi wo hen li ka nêm deréri réba ɓeréri ba, naɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Menba, Agripa kôliɲ Pêstus iyôŋ ba: «Hena gawra bi wo hen henaŋ ré gey bi Sésar ré ɲan kwôlê wori ré na, ré jeré uwôli ta mera.» ");
INSERT INTO kqp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kiriɲa bay genge wo niné ay bato wô erê Itali a menba, bay biɲ gawra wo bay uwôgeri Juliyus hen bi ré gem Pol naɲ megêri daŋgay ka ɗaŋgi. Juliyus bi wo hen, na ôbi sa asgarɲê ka bay uwôgeji ré na ka kelma hen. ");
INSERT INTO kqp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Menba, nini ɗay bô bato to hena sa iyére to bay uwôgere Adramit aɲ ta erê si tera wo bô emê wo Asi a aɲ nini ô. Aristark wo Maséduwan wo sa iyére tori na Tésalonik a hen ô naɲ nini men. ");
INSERT INTO kqp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kiriɲa kiriɲ wôl menba, nini sa biɲ Sidôn aɲ nini ɗebe tôŋ sem menba, Juliyus liɲ Pol dô aɲ ôbi ɗiri herbe ô ɓeré kôbi milɲéri men, bi bay ré li naɲ ɗi sa aŋga ôbi ôriɲ doyriji hen men. ");
INSERT INTO kqp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nini hô ɗay ô ta aɲ nini ɓu si kwoŋge cér wo si Sipre wôsa kal ge si sarni gaɲ. ");
INSERT INTO kqp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nini ô si kibi cér wo ô si Silisi naɲ Pampili hen aɲ nini sa biɲ Mira bô emê wo Lisi a. ");
INSERT INTO kqp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kiriɲ bay ka hen na, Juliyus dami wo asgarɲê bi wo hen uwôɲ bato to hena Alêksandri wo ta erê Itali a menba, ôbi béni nini ɗay. ");
INSERT INTO kqp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wulê kwône nini ge gaɲ né aɲ nini mase gaɲ dema niné sa biɲ sa iyé Sinid tô. Mega wo kal jerêni erê ta hen iyôŋ na, nini si si Salmoné iyére to yi sa iyére to derô a to bay uwôgere Krêt hen aɲ nini ɓu kwoŋgé wo Krêt bi wo hen wo kal ge gaɲ ya ré hen. ");
INSERT INTO kqp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Aɲ kiriɲa nini masa ɗé ɗé menba, nini sa biɲ kiriɲ ka bay uwôgeji ré na kini ɗebé bato ka dôri ka ɗa naɲ sa iyé Lasé hen. ");
INSERT INTO kqp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kiriɲa nini wôl gaɲ hen iyôŋ menba, jebé bato na iyêre wôsa wulê woɲ jerê bôô kurôŋ woɲ kibi kelanê di jô niɲ. Menba, Pol yêge marji kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Milɲén, en bô mega wo kergare tona ré na kergare to iyêre, wôsa hena nana ô hen iyôŋ na, aŋga bô bato a naɲ bato yere kôba, a mêniɲ men, nabay kôba, dô ré ba, na mêniɲ a men.» ");
INSERT INTO kqp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Niɲba, Juliyus ba, bi bôri na sa kwôlo ôbi ayê gôni bato men, sa kwo ôbi iyéy bato a men ɗi ɗiba, sa kwôlo Pol a ré. ");
INSERT INTO kqp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Mega wo kini ɗebé bato bay ka hen dé merê ya kibi kelanê a ré hen iyôŋ menba, ɓiɲé kwône ka naɲ ni hen ré, gey ciré erê kiriɲ bay ka hen men. Bay gey hena ré iyeŋ ba, ciré erê Pénis kini ɗebé bato wo Krêt wo yi si kini kuriɲay tare hen aɲ ciré erê merê ya kwôy deriɲ kibi kelanê. ");
INSERT INTO kqp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kal wo hena si sa kôbi gusurô wôre dê menba, bay kôl ré kô niɲ ciré gôl haji niɲ, aɲ bay ay musure to néy to bay ré uwôl kam a geriɲ bato tôŋ hen ta, aɲ ôrji si kwoŋgé cér wo Krêt a ɗa ɗa. ");
INSERT INTO kqp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Menba, kal wo bay uwôgeri Erakilôn wo hena si sa keram wo sa iyére to derô cér a hende to hen, aɲ ge naɲ néri. ");
INSERT INTO kqp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kal bi wo hen dô bato dulôŋ dulôŋ tumôri a aɲ bay nêm ɓurore heraɲ né, aɲ nini ɗiri derêni ôriɲ mera. ");
INSERT INTO kqp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kal bi wo hen ayani soɲ si cêgi môni iyére to derô cér a to bay uwôgere Klawda hen aɲ hende têlêni ta dê menba, nini mase gaɲ dema niné hô ɓuro bato woɲ gôliɲare yi wo hariɲ tô bato hen ɗa. ");
INSERT INTO kqp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bay jé ka bô bato a hen ayaji bato bi wo hen bô bato a aɲ harêji naɲ gaŋne tôŋ wô wo bato ma ré yêgeriɲ. Bay hare wô wo bato ma ré erê hebé haal wo kwoŋgé wo Libi a hen, menba, bay pô kwogelé wo damné damné wo bay harê kwa bô bato a hen bê kam a bi ré ɓu bato dê tôŋ aɲ ɗiji kal bi ré ôriɲ naɲ bato kiriɲ ka bôri gey a. ");
INSERT INTO kqp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mega kal lêni damaŋ hen iyôŋ na, kiriɲa kiriɲ wôl menba, bay pô aŋga bô bato hen bêɲ bô kam a. ");
INSERT INTO kqp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kiriɲ hô wôl cêgê menba, ɓiɲé ka li jé bô bato hen pô kwa aŋgaɲ jé kaji ka pôni bô bato a hen naɲ kôbriji bêɲ kam a. ");
INSERT INTO kqp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wulê kwône wo nini gel tu tare ré men, tu têbêŋne ré a men, wôsa kal ge naɲ néri baa ya aɲ ermé wo niné erem wo kwôni ré gôliɲ naɲ ni ba, naɲ niɲ. ");
INSERT INTO kqp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ɓiɲé bay ka bô bato a hen uwôɲ aŋgaɲ emê ré li wulê kwône niɲ. Pol hena ɗebu ta perêrji a aɲ kôlji iyôŋ ba: «Ken gel, milɲên, henaŋ kené toy kwôlê wuɲê ba, henaŋ nana baŋge Krêt a aɲ aŋga mêniɲ kêm hen na, henaŋ né yé iyôŋ né tô. ");
INSERT INTO kqp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Niɲba, haw hen ba, en uwôlêŋge geréŋge kaɲneŋge wôsa kwôni pôn iyôŋ kôba, ani a liri ré, niɲba, bato a mêniɲ yôd ɗi. ");
INSERT INTO kqp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Derô yoyre to henaŋgi hen na, *mana wo Emen wo ena kwori aɲ en li jé biri hen si san a. ");
INSERT INTO kqp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Aɲ kôlen iyôŋ ba: ‹Hare ré Pol, já erê tumô *Sésar a iyôŋ iyôŋ, Emen naɲ bô derê wori gôliɲ naɲ ju men, naɲ ɓiɲé kêm ka bô bato a naɲ ju hen a men.› ");
INSERT INTO kqp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Geréŋge kaɲneŋge milɲên, en bi bôn sa Emen a, wôsa a yé mega bi wo mana wori kôlen hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Niɲba, kal a derêna ô bê kwoŋgé sa iyére to pôni to derô cér a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na wulê môj kibi pôrbu niɲ wo kal layrêni sa cér wo Adriyatik a, sa kiriɲ ka jali menba, bay lê jé bô bato a hen, bô mega wo terare ré baa ɗa, ");
INSERT INTO kqp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","menba, bay uwôl gaŋne to bay ha aŋga néy a kibi a hen, kam a bi ciré geliɲ ɗogérji menba, ɗogé kam na têê tôre subu kibi jurgem, tumô dê menba, bay hô uwôl a menba, bay uwôɲ têê tôre wô kibi marge. ");
INSERT INTO kqp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bay hare wô wo bato ma ré hebiɲ naɲ keram wôni tô kam a menba, bay pô musure to damné pôrbu bi kam a si tô bato bi ré ɗebu kene pôn aɲ bay gem jeraŋ bi kiriɲ ré wôl lew. ");
INSERT INTO kqp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bay lê jé bô bato a hen gey ciré herbé geré menba, ayji gwosore kôl iyôŋ ba, ciré ɗayê bô bato woɲ gelê a hen, ô gelé musure to damné to ciré bi tumô bato a hen. ");
INSERT INTO kqp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Niɲba, Pol kôliɲ Juliyus naɲ asgarɲê iyôŋ ba: «Hena gawrê ka hen ré môrji bô bato ré na, kenbay ka gelê ré.» ");
INSERT INTO kqp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Menba, asgarɲê jô gaŋgi bato toɲ gelê hende to hen aɲ, aɲ ɗi kal nôgerêri ôriɲ. ");
INSERT INTO kqp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pa dema kiriɲ ré wôl tô na, Pol kôliɲ ɓiɲé kêm ka bô bato a hen bay ré ôm ani dê iyôŋ. Aɲ kôl iyôŋ ba: «Li wulê môj kibi pôrbu wo ken mô gem baa emê ani kwôy, aɲ haw hen, ");
INSERT INTO kqp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","en uwôlêŋge emêŋge ani dê réba ka gelê ré. Gusiri sa kwôni pôn nêŋ iyôŋ perêrŋge a hen kôba, a kayê ré.» ");
INSERT INTO kqp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kiriɲa ôbi kôl hen iyôŋ menba, ay mapa aɲ liɲ Emen dosé tirji a kêm menba, ôbi ɓôl aɲ ôm. ");
INSERT INTO kqp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bay kêm ger kaɲniji aɲ ômji mapa bi wo hen men. ");
INSERT INTO kqp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nibay nina ɓiɲé arew wôô naɲ tôre jurgem kibi jii bô bato a. ");
INSERT INTO kqp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kiriɲa bay uyirê niɲ menba, bay pô kaw ka baa hen bêɲ kam a, aɲ ɗiɲ bato gwa dê iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kiriɲa kiriɲ wôl niɲ menba, bay jé ka bô bato a hen, kay kiriɲ aɲ bay gel na kwoŋgé naɲ haal mera. Bay kôl ré na iyeŋ ba, ciré ɗebiɲ naɲ bato tôŋ kiriɲ bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Aɲ bay ka tô gaŋne to bay na hariɲ musure to damné bê a kam a hen men, bay buser gaŋne to bay na hariɲ gurô woɲ jebé bato hen aɲ men, bay ay bargay ka dê tumô bato a hen ta bi kal ré nôge bato ôriɲ aɲ herŋge sarji si sa haal. ");
INSERT INTO kqp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Niɲba, bato ô jebé kebre gôg haal a kiriɲ ka kam têl sa haal ta hen, aɲ kini derêre naɲ, kal usuré tôre ɗeŋgê ɗeŋgê aɲ bô kam a. ");
INSERT INTO kqp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asgarɲê gey ciré deré daŋgayɲê wô wo ka pôni ma ré nélé geré erê. ");
INSERT INTO kqp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Niɲba, Juliyus jôrji wôsa ôbi gey gôliɲ naɲ Pol, ôbi kôl ka ré hôn nélé ba, heriɲ kam a nél ô hayê, aɲ ");
INSERT INTO kqp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","tô ka ré baa hen na, ka réé ɗayê sa gurô bato a pa men, sa gerŋgare a pa men. Na hen iyôŋ a bay kêm ré ô biɲ kiriɲ ka hay a naɲ derêri. ");
INSERT INTO kqp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kiriɲa nini si gôl kêm hen iyôŋ niɲ, menba, cêgê dema niné sa toy wo iyére to derô cér a hende to hen bay ré uwôgere Malt. ");
INSERT INTO kqp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ɓiɲé ka sa iyére hende to hen na, bay lêni dô damaŋ. Bay lam tare to dami béni nini iyêbe, wôsa emen uwôŋge aɲ kelanê dii damaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol pô kam gurô bi tare a menba, jênêre so bô a wô tare to uwoyre hen aɲ ger kôbri lêɲ pa da da a. ");
INSERT INTO kqp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kiriɲa bay iyére gel wo jênêre lêê a kôbi Pol a hen iyôŋ menba, bay ɲamniɲ perêrji a kôl iyôŋ ba: «Gawra wo hen, na ôbi deré temare, wôsa jerê kwôlo Emen ɓu sari aɲ gey bi ôbi ré gôl ré, ôbi gelaɲ cér sôŋ, a jênêre ré gereri hen a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Niɲba, Pol wusu jênêre hende to hen uwôl tare a aɲ ani kani iyôŋ kôba, liri ré. ");
INSERT INTO kqp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ka pôn kôl yaŋ ba, ciré geléri ré uwôyrê réba kuriɲ ma niɲba, bay gem ɗé ɗé aɲ ani iyôŋ liri ré, menba, bay hô kôl iyôŋ ba: «Ôbi na emen!» ");
INSERT INTO kqp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ɗa kwa kiriɲ ka bay môriɲ ya hen na, kiriɲ ka Pibuyus ôbi emê sa iyére to derô cér a hende to hen kaɲ yiri yi ya, ôbi béni nini ô yé ya wulê subu aɲ lêni kergare dô a men. ");
INSERT INTO kqp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Kal di ibari men, bi kaɲ kwôbe damaŋ a men aɲ yi ira. Pol ô tôri a ô geléri, ôbi uwôl Emen aɲ uwôl kôbri sari menba, ôbi berare. ");
INSERT INTO kqp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Cêgeri wori menba, bay ômɲare ka sa iyére to derô cér a hende to hen kêm eraji men, aɲ ôbi berareji men. ");
INSERT INTO kqp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bay li are gay gay gel wo niné yi gay tirji a men, kiriɲa niɲa ɗayê bô bato wô erê ta kôba, bay béni saade damaŋ a men. ");
INSERT INTO kqp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nini li geserê subu Malt a dema niné ay bato to Alêksandri a to bay uwôgere kamrê kaɲ karmê hen wô ôriɲ Rôm a. Bato hende to hen na, hariɲ tôŋ Malt a wô kibi kelanê. ");
INSERT INTO kqp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nini sa biɲ Sirakus aɲ nini li wulê subu ya. ");
INSERT INTO kqp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nini hena ya hen ɓu kwoŋgé cér ôriɲ Régiyo. Kiriɲa kiriɲ wôl menba, kal wo hena si cêgerni iyôŋ nôge tôrni aɲ nini li wulê wôô menba, nini ô biɲ Pujolês. ");
INSERT INTO kqp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nini uwôɲ bay ayê bôô ya aɲ bay kelêni niné li wulê jurgem naɲ ci. Na hen hende to hen a niné ô wô ôriɲ Rôm. ");
INSERT INTO kqp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kiriɲ bay ka hen na, bay ayê bôô ka Rôm ka toy kwôlini hen na, jeraji kwinini kwôy saɲ gasugo wo Apiyus a men, ka pôni sa biɲ Obêrj to Subu a men, kiriɲa Pol gelji hen iyôŋ menba, ôbi liɲ Emen dosé aɲ uwôɲ nééri dê. ");
INSERT INTO kqp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kiriɲa nini sa biɲ Rôm a menba, bay ay tôô ciré biɲ Pol iyére tori gay naɲ asgar pôn bi ré gemni. ");
INSERT INTO kqp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Wulê subu cêgê, menba, ôbi uwôge damné ka Jubɲê ka Rôm a bi ciré daɲ. Kiriɲa bay daɲ menba, Pol kôlji iyôŋ ba: «Yênên, nôbi en liɲ balên ani ka habiɲ né men, en ɗage sa hara wo môɲêrna ré a men, niɲba, bay ɓuren Jérusalêm a aɲ biɲ Rômêɲê. ");
INSERT INTO kqp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rômêɲê pi tô kwôlê wuɲê bi wo hen menba, bay uwôɲ kwôlê wôni wo nêm derenare ré aɲ bay gey uwôlen ta. ");
INSERT INTO kqp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Niɲba, Jubɲê kaɲ aɲ lên wo en gey bi *Sésar ré ɲan kwôlê woni bi wo hen, niɲba, kwôlê wôni wo na ɗé sa sa iyére tiɲê ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Na tôri bi wo hen aɲa ené gey geléŋge men, iyêlê naɲ ken men hen. Wôsa en yi daŋgay a na wô sa kwo kam *Israyêl ɗi bôrji sari a hen.» ");
INSERT INTO kqp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Menba, bay uwôli sara iyôŋ ba: «Yênêrni ka Judé li magtubu tôni iyôŋ béni gengiɲ sam né men, kwôni wôni sa aɲ kelêni kwôlê wôni ré men, kelêni kwôlo habiɲ wôni gengiɲ sam né a men. ");
INSERT INTO kqp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Niɲba, nini gey bi jôbi jeré derêni niɲa toyé, wôsa nini hôn wo ɓiɲé ré kaɲ geré woŋge bi wo ken ay hen naɲ kiriɲ kiriɲ.» ");
INSERT INTO kqp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bay genge wulê naɲ Pol aɲ bay era naɲ kwônêrji uwoɲni ira. Kiriɲa Pol dôrji kwôlê hen iyôŋ na, ôbi kôl kwôli *emê iyére to Emen, aɲ tô kiriɲ kwôy perare na, ôbi kôl kwôli Jésu ayiɲ tôri bô magtubu tôô to *Moyis a naɲ bay kibi Emen. Ôbi li hen iyôŋ bi ɗiré biyêji. ");
INSERT INTO kqp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ôbi bôy ka pôni naɲ kwôlê wori bi wo hen men, ka pôni kaɲ bê bôrji sara men. ");
INSERT INTO kqp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kwôy wo bay ca usuriɲ hen kôba, bay biɲ perêrji a ré, menba, Pol hô kôlji iyôŋ ba: «Kwôlo Tunu toɲ hendi bô bôrê na kôliɲ *ôbi kibi Emen *Esay kôliɲ môɲêrna hen na, na tiri. Ôbi na kôl iyôŋ ba: ");
INSERT INTO kqp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Ô ju ô kôliɲ ɓiɲé bay ka hen iyôŋ ba: Ka toyé derê niɲba, ka henê ani bô ré kwôy, Ka gelé derê niɲba, ka gelé ani ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Marji suriɲ ta aɲ bay toy kwôlê wôni ré men, Bay lugu tirji ta aɲ bay gel ani ré men, Wôsa bô ɓiɲé bay ka hen deŋgel wôsa bay gey bi ermé woji ré yi sara ré, Wô wo ma ciré belé uɲén Aɲ ma ené berareji.› » ");
INSERT INTO kqp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol hô kôlji iyôŋ ba: «Bi ken hôn mega wo béré kwôli gelê wo Emen bi wo hen na, uwôliɲ biɲ ɓiɲé ka na Jubɲê ré hen, wôsa bay baa a toyé.»  ");
INSERT INTO kqp_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kiriɲa Pol kôl kwôlê bi wo hen iyôŋ menba, Jubɲê ôrji ta, aɲ nariɲ kwôlê perêrji a damaŋ. ");
INSERT INTO kqp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol li elê wôô bô iyére to ôbi têbe naɲ geserê geserê hen, aɲ ɓiɲé kêm ka era uɲéri hen na, ôbi iyêl naɲ ci na ya. ");
INSERT INTO kqp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ôbi uwôl béré *emê iyére to Emen men, geliɲ ɓiɲé kwôlo gengiɲ sa Kelma Jésu Krist naɲ ibiyare aɲ kwôni iyôŋ dôyrêri sara ré.");
INSERT INTO kqp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nôbi Pol woɲ mana wo Jésu Krist wo Emen uwôgen bi ené yi *ôbi jé wori hen a lê magtubu hende to hen. Emen a dôren ɗé gay bi ené uwôliɲ béré Kwôlo Dôri wori biɲ ɓiɲé. ");
INSERT INTO kqp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Kwôlo Dôri bi wo hen na, Emen na kôliɲ bay kibri ka tumô wo ɗiré joɲ béna aɲ bay na li kwôli bô magtubu to Emen a. ");
INSERT INTO kqp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kwôlo Dôri bi wo hen na, gengiɲ na sa Kemari Kelma wona Jésu Krist. Kwo gengiɲ sa kurôŋgi yi ba, ôbi yêɲ na tô môɲ wo kelma Dabid a. ");
INSERT INTO kqp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Niɲba, kwo gengiɲ sa Tunu toɲ hendi bô bôrê ba, Emen gel wo ôbi ré na Kemari naɲ néé, kiriɲa ôbi biri ji si kamɲê hen. ");
INSERT INTO kqp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Na sa kibri aɲa Emen né li dô naɲ en aɲ ben en yiɲ *ôbi jé wori hen, aɲ bi ené ô ulê béré Kwôlo Dôri biɲ ɓiɲé ka sa iyére to ɗaŋgi a aɲ bi bay ré biɲ bôrji sari a men, bay ré biɲni kwôlê a men. Hen iyôŋ na, bay a ayê kibi hini Jésu Krist. ");
INSERT INTO kqp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kenbay kôba, kena perê ɓiɲé bay ka hen a men. Na Emen a na uwôgêŋge bi kené yi ɓiɲé ka Jésu Krist. ");
INSERT INTO kqp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Na hen iyôŋ a, ené liɲ magtubu hende to hen béŋge kenbay ka Rôm a ka Emen peréŋge hen. Ôbi a uwôgêŋge bi kené yi kari. Bi bô derê naɲ bô jalê wo Ibarna Emen naɲ kwo Kelma Jésu Krist ba naɲ ken. ");
INSERT INTO kqp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tumô dem ba, en liɲ Emen wuɲê dosé naɲ geré wo Jésu Krist wô sarŋge kêm. Wôsa ɓiɲé naɲ kiriɲ kiriɲ sa terare a nà toy wo kené bi bôrŋge sa Jésu Krist. ");
INSERT INTO kqp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Emen wo en li jé biri naɲ bôn pôn hen béré Kwôlo Dôri wo gengiɲ sa Kemari wo en uwôl hen na, ôbi hôn wo kwôlo ené kôl hen na, ré na kwoɲ tiri. Ôbi hôn kwôy kwôy wo kiriɲa ené uwôli na, ené erem sarŋge a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","En uwôli ôbi ré ben geré aɲ bi ené ôriɲ geléŋge niɲ. ");
INSERT INTO kqp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Wôsa en ôriɲ doy erê geléŋge damaŋ men, ené béŋge aŋgaɲ baliyare ka Tunu toɲ hendi bô bôrê ben hen aɲ bi kené ɗebiɲ sa têêrŋge a. ");
INSERT INTO kqp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Kwôlo en kôl hen na, en gey bi nabay kêm nana dôbiɲ ibiyare bôrna. Bêê wo ken bi bôrŋge sa Krist a hen na, a dôben ibiyare bôn a men, bê wo en bi bôn sa *Krist hen na, a dôbêŋge ibiyare bôrŋge a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yênên, en gey bi kené hôn wo ené genge kwôy kwôy ené erê sa geléŋge, niɲba, en uwôɲ geré ré tô. En gey erê wô lê jé perêrŋge a aɲ bi ré li naɲ ɓiɲé ka iyére toŋge mega wo liɲ naɲ ɓiɲé ka sa iyére to ɗaŋgi a hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Emen a ben jé bi wo hen. Na ôbi á, ré yi bi ené uwôliɲ béré Kwôlo Dôri biɲ ɓiɲé ka tirji jôriɲ men, ka tirji jôriɲ né hen men, biɲ bay henê magtubu men, bay henê ani ré hen a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Na ôbi wo hen aɲa ené gey erê ulê béré Kwôlo Dôri béŋge kenbay ka Rôm a men hen. ");
INSERT INTO kqp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tayre dên sa Kwôlo Dôri a ré ded. Kwôlo Dôri bi wo hen na, néé wo Emen woɲ gôliɲ naɲ ɓiɲé kêm ka bi bôrji sa Krist yi bô a ya. Ôbi geliɲ na Jubɲê geré tumô, dema ré geliɲ ka tô yê wo ɗaŋgi a tô. ");
INSERT INTO kqp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Na Kwôlo Dôri bi wo hen, a gelé wo iyeŋ a Emen né bi ɓiɲé yi kaɲ derôre tiri a hen ba. Geré bi wo hen na, na kiriɲa ɓiɲé biɲ bôrji sa Jésu Krist mera ɗiba, geré wo ɗaŋgi naɲ. Na mega wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «Kwôni wo na kwoɲ derôre tun a ba, a merê tu geɲ naɲ geré ayê bôô wori, niɲba, kwo hô cêgê ba, yen a dôren sari a ré.» ");
INSERT INTO kqp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Na ta derômaraŋ a yeŋ a Emen geléna mega wo bôri ré taari sa têriɲ kêm to ɓiɲé ré li hen men, wô aŋga habiɲ bay ka bay li hen a men. Jé lêreji wo habiɲ bi wo hen, a jôriɲ ɓiɲé henê tu kwôlê hen, ");
INSERT INTO kqp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","bi wo geré wo bay ré hôniɲni yi tu wolé hen. Emen bi naɲ yiri a gelji bêɲ bêɲ. ");
INSERT INTO kqp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kiriɲa Emen na ɗiɲ tô terare yeŋ kwôy kemnêŋ na, kwôni na hôn na ba ôbi giliɲ na iyeŋ ba, ré niɲba, aŋga ôbi na ɗi a gelé wo ôbi ré na i ba men, gel wo ôbi ré na naɲ néé wo ré kerê ré kwôy men, aɲ ré na ôbi pôn nêŋ a ré na Emen. Aɲ bay a kelê ré na kwôlê woji ré, hena ciré biri kwôlê ré ré. ");
INSERT INTO kqp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bi wo bay hôn wo Emen né ya hen iyôŋ haji kôba, bay ay kibri ré men, bay liri dosé ré a men, mega wo bay ré lê hen iyôŋ. Bi wo bay ré li hen iyôŋ na, bay li ré, aɲ erméréji na kwôlo ɗéɲ iyôŋ mera men, môrji na bô dilemne a men, bay hôn ani kani ka dôri ré kwôy. ");
INSERT INTO kqp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bay kôl ciré na bay tu melênê, niɲba, na bay galê ɗééɲ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bi bay ré ay kibi damɲare to Emen woɲ ôbi merê naɲ kwini hen na, bay kaɲ, aɲ ayji na kibi kamrê ka bay albe yi mega gawrê ka bay ba, a ma hen réba mega ciré môriɲ hen iyôŋ men, ka pôni yi môɲ tanare to noni iyôŋ men, ka yi môɲ kalaw iyôŋ a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Na wô sa bi wo hen aɲa Emen né dô kôbri aɲ, aɲ bi bay ré li aŋga habiɲ bay ka bay ôriɲ doyriji hen. Bay ay yirji liɲ aŋgaɲ tayre bay ka hen. ");
INSERT INTO kqp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Tu kwôlê wo gengiɲ sa Emen hen na, bay ɗiri kwa aɲ bay ɓu na tô benare ɗi. Bay ay kibi ari ɗé ka Emen men, bay li jé biji a men, niɲba, bay ay kibi ôbi ɗé are bay ka kêm hen né. Ɗôd wori ba, nana ayê na kibri ôbi kwôy kwôy ɗi. *Amên, bi yi geliɲ hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Na hen iyôŋ aɲa Emen né dô kôbri aɲ, aɲ ɗiji li aŋgaɲ tayre bay ka bay gey lê hen. Yébé ɗi imɲê aɲ, aɲ yiɲ naɲ megêrji yébé. ");
INSERT INTO kqp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Imɲê kôba, li hen iyôŋ men. Bay ɗi yébé aɲ, aɲ na doy yiɲ naɲ imɲê ka ɗaŋgi a deréji ɗi. Bay li aŋgaɲ tayre naɲ megêrji imɲê. Bay li hen iyôŋ uwôliɲ na kwôlê sarji a gaŋ wô kibi têriɲ toji. ");
INSERT INTO kqp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ɓiɲé bay ka iyôŋgi hen na, kaɲji henê Emen. Aɲ ôbi dô kôbri aɲ, aɲ bi ermé woji ré habiɲ hen men, bi bay ré liɲ aŋga bay réé lê ré hen a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Lê aŋgaɲ derôre naɲ yirji a men, aŋgaɲ lê ka habiɲ gay gay wôn bôrji, aɲ bay li tu bôriyare sa aŋga megêrji a men, bay liɲ yirji habrê men, bay liɲ megêrji terbére men, bay duu ɓiɲé men, bay nayriɲ men, bay lamiɲ yirji men, bôrji habiɲ naɲ megêrji men, bay liɲ megêrji ɲôm a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Bay mêne hini megêrji men, na bay bayi Emen men, bay tiiré megêrji men, uwôyrê yirji men, di deŋgôrji men, yirji gwaji sa ermé sa gwosoy lê têriɲ a kwôy kwôy men, bay biɲ balêrji kwôlê ré a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bay li are baa ermé tôrji men, bay li aŋga bay kôl ciré lê hen né men, bay hôn peré megêrji ré men, bay bô tu ɲa to ka ɗaŋgi ré a men. ");
INSERT INTO kqp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ɓiɲé bay ka hen na, hôn dô wo Emen na ré kôl iyôŋ ba: «Ɓiɲé ka ré ay geré wo habiɲ bi wo hen na, nêm temare.» Bay hôn hen iyôŋ haji kôba, bay liɲ are bay ka hen tumô tumô. Bay li hen iyôŋ mera ré niɲba, kiriɲa bay gel ka ɗaŋgi li aŋga habiɲ ba, yirji dôrji damaŋ a. ");
INSERT INTO kqp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ôbi a, jôbi wo jeré kôl jeré na ôbi jerê kwôlê sa megêm a, aɲ uwôliɲ kwôlê sarji a hen na, kwôni a ɗé bôri jalê sam a ré. Wôsa ju jô kwôlê sa megêm a menba, jôbi ju liɲ aŋga habiɲ bay ka hen ta men. Ôbi a, kem ré uwôlem kwôlê sam a hen. ");
INSERT INTO kqp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ɓiɲé kaɲ bay lê aŋga habiɲ bay ka hen na, nana hôn mega wo kwôlo Emen ré uwôlji sarji a hen na, ré na jerê kwôlê woɲ tiri. ");
INSERT INTO kqp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Jôbi wo jô kwôlê sa megêm a wô lê jériji wo habiɲ hen, menba, jôbi kôba ju li are bay ka hen men. Emen a sa jerê kwôlê sam a môj môj. ");
INSERT INTO kqp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Dô ré ba, ju bô Emen mega ani ré wô wo ôbi li dô. Aɲ ôbi ɓurem jog ré tô men, uwôl bôri a men. Hôn wo ôbi ré lêm na dô hen, aɲ bi jeré beliɲ jé lêrem. ");
INSERT INTO kqp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Jôbi bi wo hen na, sam iyêre men, ju gey belé jé lêrem ré men. Na hen iyôŋ a, ré yi mega jeré dayrê na jerê kwôlo Emen sam a iyôŋ hen. Já geliɲ gusiɲ wulê wo Emen a gelé bô tarê wori sa ɓiɲé bay ka iyôŋgi hen. Wulê bi wo hen na, ôbi a jerê kwôlê sa ɓiɲé kêm, naɲ jerê kwôlê woɲ derôre. ");
INSERT INTO kqp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ôbi a sa têbiɲ ɓiɲé kêm sa kôbriji i ba, naɲ jé lêri jé lêri. ");
INSERT INTO kqp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ɓiɲé ka pôni na bay ɗé yirji sa lê aŋga dôri a kwôy kwôy. Na hen iyôŋ a bay ré gey bi Emen né ay kibriji men, ré kôl kwôliji wo dôri men, bay gey uɲé merê tu geɲ wo naɲ kwini a men. Aɲ na bay a Emen né biji merê tu geɲ wo naɲ kwini bi wo hen. ");
INSERT INTO kqp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Niɲba, ɓiɲé ka pôni biɲ Emen kwôlê ré men, bay gey kwôlê woɲ tiri ré, na aŋga habiɲ a bay ré li mera men. Ɓiɲé bay ka hen na, bay a gelé bô tarê wo Emen men, bô mênê wori a men. ");
INSERT INTO kqp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ɓiɲé kêm kaɲ bay lê habrê hen na, Emen a geliɲ tirji gusiɲ damaŋ. Jubɲê a geliɲ gusiɲ tumô dema, ɓiɲé ka na Jubɲê ré hen ré geliɲ gusiɲ tô. ");
INSERT INTO kqp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Niɲba, bay lê derê na, Emen a ayê kibriji men, ôbi a kelê kwôliji wo dôri men, a biji bô jalê a men. Ôbi a biɲ Jubɲê tumô dema ré biɲ ɓiɲé ka na Jubɲê ré hen tô. ");
INSERT INTO kqp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Wôsa Emen na ôbi derê tu kwôni ré. ");
INSERT INTO kqp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ɓiɲé ka li têriɲ baa henê tôô to Moyis hen na, bay a li têriɲ aɲ bay a mênê baa wo tôô ré li ani kani naɲ ci. Jubɲê ba, hôn tôô to *Moyis hende to hen, aɲ ka mêne tôô hende to hen na, Emen a sa jerê kwôlê sarji a na naɲ tôô hende to hen men. ");
INSERT INTO kqp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Na wô toyé tôô mera a kwôni ré yiɲ kwo dôri tu Emen a ré, niɲba, hena ôbi ré li tôô hende to hen dema, ré yiɲ derôre tu Emen a tô. ");
INSERT INTO kqp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɓiɲé ka na Jubɲê ré hen na, bay hôn tôô to Moyis ré, niɲba, ka pôni li naɲ sarji aŋga tôô genge hen. Bay li yirji môɲ ciré hôn tôô hende to hen, niɲba, bay hône ré a men. ");
INSERT INTO kqp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bay gel na wo ari lê ka tôô ré gey hen na, ré yi na bôrji a men, ermé woji gel a men. Ta ta ermé woji uwôl kwôlê sarji a men, dô kwôlê sarji a men. ");
INSERT INTO kqp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Aŋga en kôl kwôliji hen na, a yé tu wolé wulê wo Emen a biɲ Jésu Krist jerê kwôlê sa ɓiɲé. Wulê bi wo hen na, ôbi a jerê kwôlê sa ɓiɲé wô jé lêreji wo uwôbi hen mega Kwôlo Dôri wo en uwôl béréri hen kôl hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kwoŋge kenbay Jubɲê ba, ken kôl mega wo kené na Jubɲê men, ken ɗi yerŋge yi tôô a aɲ ken ɗiɲ deŋgôrŋge naɲ Emen. ");
INSERT INTO kqp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ken hôn, aŋga dôriɲ Emen na, tôô tori na geléŋge geré bi kené dôriɲ tu aŋga dôri naɲ ka habiɲ. ");
INSERT INTO kqp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kenbay ken erem mega kené geliɲ bay tu tiɲ geré men, kené yé kiriɲ ka peraŋgi ka ɓiɲé ka mô dilemne a men, ");
INSERT INTO kqp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ken kôl kené nêm geliɲ ɓiɲé ka hôn ani ré hen are men, kené nêm geliɲ kamrê are a men, wôsa ken kôl mega wo kené hôn tôô to Emen hen iyôŋ niɲ, aɲ yi mega wo kené hôn na are kêm men, kené hôn na tu kwôlê a men. ");
INSERT INTO kqp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ken geliɲ ɓiɲé are menba, wô mi a kené geliɲ yerŋge ré ba? Ken kôliɲ ɓiɲé ré gômse ré menba, wô mi a kené gômse ba? ");
INSERT INTO kqp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ken kôliɲ ɓiɲé ré yiɲ naɲ yébé ɓiɲé ré menba, kenbay ken li wô mi men ba? Ken kôl kené gey kamrê ré menba, ken gômse aŋga ɓiɲé biɲ kamrê bay ka hen wô mi sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ken di deŋgôrŋge damaŋ kôl iyôŋ ba: kené hôn tôô to Emen niɲ, niɲba, ken mêne na tôô hende to hen, aɲ ɓiɲé kôl kwôlo habiɲ gengiɲ sa Emen wô kebreŋge wô mi sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Na mega wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «Ɓiɲé ka na Jubɲê ré hen tiiré Emen wô kebreŋge kenbay Jubɲê.» ");
INSERT INTO kqp_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kenbay Jubɲê ken wal keŋ, gel wo kené na ka Emen. Hena kené li tôô to Moyis dô na, keŋ wo ken wal hen na, a lê naɲ ken, niɲba, hena kené li tôô hende to hen ré na, walê keŋ woŋge bi wo hen na, yi mega kené wal ré tô iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Hena kwôni ré wal keŋ ré niɲba, li na tôô to Moyis na, tu Emen a ba, ôbi yi mega ɗiré wal keŋ iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kenbay kaɲ Jubɲê ba, Emen na bêŋge tôô tori to na liɲ bô magtubu a hen kebreŋge a menba, ken bi bay walêŋge keŋ menba, ken mêne tôô hende to hen. Ɓiɲé ka na Jubɲê ré hen na, kwoji ba, bay wal keŋ né, niɲba, hena bay ré bi kwôlê sa tôô hende to hen a na, na bay a jerê kwôlê sarŋge a. ");
INSERT INTO kqp_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Niɲba, i a na Jub woɲ tiri ba? Jub woɲ tiri na, na kwo yi Jub nô na mera ré. Aŋga gel wo kwôni ré na kwo Emen na, na kwoɲ walê keŋ wo ɓiɲé gel naɲ tirji hen mera ré, ");
INSERT INTO kqp_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","niɲba, Jub woɲ tiri na, na kwo Emen bul ermé wori hen. Walê keŋ woɲ tiri wo na kwo Tini Emen a lê bô gawra hen na, na kwôlo gengiɲ sa tôô to liɲ bô magtubu to Emen a hen né. Emen a na ôbi ayê kibi gawra bi wo iyôŋgi hen, ɗiba, na ɓiɲé ré. ");
INSERT INTO kqp_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hena ré na iyôŋ ba, yé Jub ba, derêri yôŋ ba? Hena kwôni ré wal keŋ ba, li naɲ ɗi na iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Li naɲ ɓiɲé damaŋ naɲ geré kwône. Ɗéŋge na derêŋge tôri ken toy: Emen na biɲ na Jubɲê kwôlê wori tumô. ");
INSERT INTO kqp_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","A hena ka pôni ré bi kwôlê sara ré ba, a lê wo Emen a ɗé bê kwôlê wori baa ba? ");
INSERT INTO kqp_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Eŋ eŋ, na iyôŋ né. Hena gawrê ré na bay benare kêm haji kôba, Emen ba, na ôbi kelê kwôlê woɲ tiri. Na mega wo na liɲ bô magtubu tori a kôl iyôŋ ba: «Jôbi Emen hena jeré iyêl kwôlê ba, gawra hôn wo ré na kwôlê woɲ tiri. Hena kwôni ré uwôlem kwôlê sam a ba, kwôlê wôni wo a ɓeré sam ba, naɲ.» ");
INSERT INTO kqp_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kwôlê bi wo hen na, gawrê kôl na hen iyôŋ hende to hen. Ka pôni a kelê habrê wo niné li hen na, ré lê naɲ ɓiɲé aɲ bay ré henê mega wo Emen ba, ré na ôbi lê aŋgaɲ derôre. Hen ba, niɲa kôlji na kwôli mi ba? Niɲa kelê Emen ré li habiɲ aɲa ré perêna hen ba? (En kôl na mega wo gawrê kôliriɲ hen iyôŋ.) ");
INSERT INTO kqp_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Eŋ eŋ, na iyôŋ né kwôy. Hena Emen na ré na kwôni woɲ derôre ré ba, ôbi henaŋ ré jerê kwôlê sa ɓiɲé na iyeŋ ba? ");
INSERT INTO kqp_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Hena kwôni ré kôl iyôŋ ba, ena ôbi benare, hen iyôŋ na, benare tiɲê hende to hen a lê aɲ ɓiɲé a henê mega wo Emen ba, ré na kwôni woɲ tiri. Aɲ bay a heramiri wô sa bi wo hen. Iyôŋ ba, wô mi a kwôlê ré ɓeré san wôsa ené na ôbi têriɲ sôŋ ba? ");
INSERT INTO kqp_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ka pôni kôl iyôŋ ba: «Hena nana lêŋge habrê aɲ na geliɲ derê wo Emen ba, li mi ba?» Ka pôni kôlen kwôlo habiɲ kôl iyôŋ ba ré na nôbi a ré kelê kwôlê bi wo hen. Emen a jerê kwôlê sa ɓiɲé bay ka hen iyôŋgi a hen, aɲ jerê kwôli bi wo hen na ya. ");
INSERT INTO kqp_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Na kelê iyeŋ ba? Hen ba, nabay kaɲ Jubɲê na, naa ɗê ɓiɲé ka na Jubɲê ré hen ba? Eŋ eŋ, nana ɗêji ré kwôy. Na en kôl tumô kôl iyôŋ ba: «Nabay kaɲ Jubɲê men, ɓiɲé ka na Jubɲê ré hen a men na, na têriɲ a emê iyére sarna.» ");
INSERT INTO kqp_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Na mega bi wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «Kwôni woɲ derôre pôn nêŋ iyôŋ kôba ré naɲ tumô Emen a hen. ");
INSERT INTO kqp_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kwôni pôn nêŋ iyôŋ wo hôn aŋgaɲ derôre ba, naɲ men, kwo pôn nêŋ iyôŋ wo woge Emen kôba naɲ a men. ");
INSERT INTO kqp_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bay kêm bul cêgeriji biɲ Emen men, bay kêm ge kay men, kwôni pôn nêŋ iyôŋ wo li aŋga dôri ba, naɲ kwôy. ");
INSERT INTO kqp_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Aŋga so kibi kwôni a na, na aŋga habiɲ ka nêm deréri kwôni hen. Kibriji kôl kwôlê woɲ benare men, kwôli kelêrji ba yi mega gura kalaw wo duu ɓiɲé hen iyôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bay tideré ɓiɲé men, bay kôl na kwôlê woɲ ɗôre ɗôre kwôy kwôy men, ");
INSERT INTO kqp_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","bay sê masê wô deré ɓiɲé a men. ");
INSERT INTO kqp_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kiriɲ ka bay ô ya na, bay mêne are men, bay geliɲ ɓiɲé gusiɲ a men. ");
INSERT INTO kqp_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bay hôn merê naɲ bô jalê naɲ ɓiɲé ré men, ");
INSERT INTO kqp_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","bay hariɲ Emen né a men.» ");
INSERT INTO kqp_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kiriɲa tôô geléna hen iyôŋ na, nana hôn wo aŋga hende ré geléna kêm hen na, ré geliɲ na ka Emen na biji tôô hende to hen men. Na ôbi á, Emen ré ɓu kibi ɓiɲé ka kôl ciré hôn né a ciré li hen, aɲ Emen a jerê kwôlê sarji a kêm. ");
INSERT INTO kqp_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Na hen iyôŋ a, kwôni pôn nêŋ iyôŋ wo a kelê ɗiré na kwoɲ derôre tumô Emen a wôsa ɗiré li aŋga tôô ré kôl hen ba, naɲ. Tôô gel na têriɲ to ɓiɲé nô bi bay ré hôn mera. ");
INSERT INTO kqp_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Haw hen na, na Emen a geliɲ ɓiɲé geré wo bay ré yiɲ kaɲ derôre tumôri a. Geré bi wo hen na, na kwo ɗaŋgi ɗiba, na kwo tôô hen né. Geré bi wo hen na, tôô to *Moyis naɲ bay kibi Emen na kôl kwôli. ");
INSERT INTO kqp_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Geré bi wo ɓiɲé a yiɲ kaɲ derôre tumô Emen a hen na, na sa kibi aŋga Jésu Krist li hen. Emen bôl geré bi wo hen, biɲ ɓiɲé kêm ka bi bôrji sa Jésu a ɗiba, na Jubɲê mera ré, wôsa Emen dô tu kwôni ré. ");
INSERT INTO kqp_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Ɓiɲé kêm li têriɲ aɲ bay kelaŋ naɲ Emen men, bay a uɲé hini emê wori ré a men. ");
INSERT INTO kqp_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Niɲba, bô Emen dô naɲ ci na ɗéɲ iyôŋ, aɲa ôbi ré biji yi ɓiɲé kaɲ derôre tiri a hen. Ôbi li hen iyôŋ naɲ geré wo Krist Jésu dôrji bô têriɲ a hen. ");
INSERT INTO kqp_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Emen a ayêri ɗé bi ré ma aɲ bi kwôbriri ré dô têriɲ toji sarji a aɲ. Hena bay ré bi bôrji sa Jésu Krist a ba, ôbi a ɗé bôri jalê sarji a. Ôbi li hen iyôŋ bi ɓiɲé ré hôn wo ɗiré na kwoɲ derôre. Têriɲ to ɓiɲé na li tumô hen na, Emen na pôrji wô sare ré. ");
INSERT INTO kqp_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Wôsa ôbi na uwôl bôri. Niɲba, haw hen na, ôbi gel iyeŋ a ɗiré bi ɓiɲé ré yi kaɲ derôre ba men, ôbi gey yé kwôni woɲ derôre men, ɓiɲé ka ré bi bôrji sa Jésu a hen kôba, ɗiré biji ré yi kaɲ derôre men. ");
INSERT INTO kqp_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hena ré na hen iyôŋ ba, ani ka naa diɲ deŋgôrna hen ya ba? Eŋ eŋ, ani naɲ. Aŋga dôri ba, na bê bôô sa Jésu Krist a ɗiba, na bê kwôlê wona sa tôô a ré. Iyôŋ ba, ani ka naa diɲ deŋgôrna ba, naɲ. ");
INSERT INTO kqp_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nana hôn wo Emen né biɲ ɓiɲé ré yi kaɲ derôre na sa kibi bê bôô woji sa Jésu a ɗiba, na wô wo bay ré li tôô to Moyis hen né. ");
INSERT INTO kqp_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ken erem mega wo Emen ré na Emen wo Jubɲê mera ba? Ɓiɲé ka na Jubɲê ré hen kôba, na kari men ré ba? Ôbi na Emen woji a men. ");
INSERT INTO kqp_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Emen na pôn nêŋ hari. Hena Jubɲê ré bi bôrji sa Jésu Krist a na, ôbi a biji bay a yé kaɲ derôre tiri a. Kwo ɓiɲé ka na Jubɲê ré hen kôba, na hen iyôŋ men, hena bay ré bi bôrji sa Jésu Krist a. ");
INSERT INTO kqp_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mega wo kôliɲ Emen ré biɲ ɓiɲé ré yi kaɲ derôre wô kibi bê bôô woji sa Jésu a hen ba, kôl na wo nana kaɲiɲ tôô ba? Eŋ eŋ, na iyôŋ né. Ôbi bi wo hen dema nana geliɲ derê tôô tô. ");
INSERT INTO kqp_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Erména sa môyrena *Abraham a, kwôli mi a nana erem gengiɲ sari ba? Men, na mi a ôbi ré uwôɲ kôbi Emen a gengiɲ sa yirji woɲ gawra hen ba? ");
INSERT INTO kqp_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Hena Emen na ré biri yi kwôni woɲ derôre tiri a wô ari lêri ka dôri na, Abraham henaŋ né di deŋgôri ba, ré na tiri niɲba, ôbi nêm dê deŋgôri tumô Emen a ré. ");
INSERT INTO kqp_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Toyéŋge kwôlo magtubu to Emen kôl kôl iyôŋ ba: «Abraham bi bôri sa Emen a, na ôbi a, Emen né biri yi kwôni woɲ derôre tiri hen.» ");
INSERT INTO kqp_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Henêŋge wo hena kwôni ré li jé aɲa bay ré têbiri na, na sa kôbri wori ɗiba, bay biri na ɗéɲ iyôŋ né. ");
INSERT INTO kqp_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Niɲba, hena kwôni ré li ani kaɲ déɲ tu Emen ré, aɲa ré bi bôri sa Emen woɲ ôbi berê tu ɲa to bay têriɲ hen na, naɲ ayê bôô wori bi wo hen na, Emen a biri yé kwôni woɲ derôre tiri a. ");
INSERT INTO kqp_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kelma Dabid kôba, na kôl kwôlê bi wo hen iyôŋ tumô men. Ôbi na kôl kwôli ɓiɲé ka Emen biji yi kaɲ derôre tiri a ɗiba, ôbi bi bôri sa jé lêreji a ré. Ɓiɲé bay ka hen na, yi derê yi wô sarji. ");
INSERT INTO kqp_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ôbi kôl iyôŋ ba: «Ɓiɲé ka Emen ɗi bôri jal sa têriɲ toji a hen na, ré na ka yi derê ré yi wô sarji. Ɓiɲé bay ka Emen dô têriɲ toji aɲ hen na, na bay yi derê. ");
INSERT INTO kqp_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Yi derê yi wô sa gawra wo Kelma Emen ɓiri naɲ kwôli têriɲ tori a ré hen.» ");
INSERT INTO kqp_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kwôlo kelma Dabid na kôl hen ba, na kôl gengiɲ na sa bay walê keŋ a, yirji ré derêji mera ba? Eŋ eŋ, ka wal keŋ né hen kôba, bay a lê yi derê a men. Nana toy mega wo Emen né bô Abraham môɲ kwôni woɲ derôre tiri a, wô bôri wo ôbi bi sari a. ");
INSERT INTO kqp_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kiriɲa Abraham na yiɲ kwôni woɲ derôre tu Emen a hen ba, ôbi na wal keŋ niɲ laba, na wal ré tô ba? Wulê bi wo hen na, ôbi na wal keŋ né tô a men. ");
INSERT INTO kqp_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Keŋ wo Abraham na wal hen na, na aŋga gel wo ôbi na ré bi bôri sa Emen a niɲ men, Emen na ré biri yi kwôni woɲ derôre tiri a kiriɲa ôbi na bi bay wali keŋ ré tô hen a men. Na ôbi wo hen, aɲa Abraham ré na iba ɓiɲé ka wal keŋ né niɲba, bi bôrji sa Emen a, aɲ ôbi bôrji mega ɓiɲé kaɲ derôre hen. ");
INSERT INTO kqp_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ɓiɲé ka wal keŋ hen kôba, Abraham na ibarji men niɲba, bi bay li môɲ ôbi na liɲ hen iyôŋ men, wôsa pa dema ôbi na ré wal keŋ tô na, ôbi na bi bôri sa Emen a niɲ. ");
INSERT INTO kqp_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Emen na genge ɗiré biɲ Abraham naɲ kwôŋgêri sa terare. Aŋga Emen na genge ɗiré biɲ Abraham hen na, ôbi na genge wô wo Abraham na li tôô ba? Ôbi na kôl hen iyôŋ, na wôsa Abraham na bi bôri sari a aɲ yiɲ kwôni woɲ derôre tiri. ");
INSERT INTO kqp_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Hena ré na ɓiɲé ka li tôô a ré uɲé aŋga Emen genge hen na, iyôŋ ba, ɓiɲé ka bi bôrji sari a hen na, bay bi na ɗéɲ iyôŋ, aɲ aŋga Emen na genge hen kôba, a yé ani tirji a ré a men. ");
INSERT INTO kqp_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Na hen iyôŋ, wôsa tôô li aɲ bô Emen taari sa ɓiɲé, wôsa bay li tôô hende to hen né. Hena tôô na ré naɲ ba, kwôni henaŋ ré mênêre ba? ");
INSERT INTO kqp_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Iyôŋ ba, aŋga Emen na genge hen na, na wô sa ɓiɲé ka bi bôrji sari a hen. Ôbi li hen iyôŋ wô geliɲ bô derê wori. Ôbi gey biɲ kwôŋgê *Abraham kêm ɗiba, biɲ na ɓiɲé ka bi bôrji sa tôô to *Moyis a hen mera ré, niɲba, ôbi biɲ ɓiɲé kêm ka bi bôrji sari a, mega Abraham na biɲ bôri sari a hen iyôŋ men, wôsa Abraham na ibarna nabay kêm. ");
INSERT INTO kqp_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Na mega wo na liɲ bô magtubu to Emen a kôl iyôŋ ba: «En ɗém ju yi môy tô yê ɓiɲé kwône.» Tu Emen a na, Abraham na ibarna wô kibi bê bôô wori sari a. Na Emen bi wo hen a na ôbi biɲ ɓiɲé ka ma ji si men, kiriɲa ôbi ay tôri na, aŋga naɲ kôba, ôbi biji yi ya a men. ");
INSERT INTO kqp_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kiriɲa ɓiɲé na bô mega geré ɗé bôô sa Emen a ré naɲ hen iyôŋ haji kôba, Abraham ba, na ɗi bôri sa Emen a men, na bi bôri sari a men. Na hen iyôŋ aɲa Emen né li aŋga ôbi na genge ɗiré lê biɲ Abraham hen, aɲ ôbi yiɲ iba tô yê ɓiɲé kwône mega Emen na kôli kôl iyôŋ ba: «Kwôŋgêm a kwônê.» ");
INSERT INTO kqp_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Wulê bi wo Emen na kôli hen na, elê Abraham na a nêmê arew ley, aɲ ôbi hôn wo ɗiré na kwo hali niɲ men, Sara kôba, yê wore ré naɲ a men, niɲba, ôbi bi bôri sa Emen a ré lê aŋga ôbi na ré genge hen biri. ");
INSERT INTO kqp_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ôbi hôn wo ɗiré uɲé aŋga Emen na genge ɗiré biri hen, aɲ ôbi meremné ré, niɲba, bôri wo ôbi bi sa Emen a hen na, biri néri aɲ ôbi heramiri. ");
INSERT INTO kqp_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ôbi hôn hôn dô sari a wo Emen ré ôriɲ naɲ néé woɲ liɲ aŋga ôbi ré genge ɗiré lê biri hen. ");
INSERT INTO kqp_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Na ôbi wo hen aɲa, Emen né biri yi kwôni woɲ derôre tiri a hen. ");
INSERT INTO kqp_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Kwôlo na liɲ bô magtubu a kôl iyôŋ ba: «Emen ré bôôri mega kwôni woɲ derôre tiri a» hen na, na liɲ hen iyôŋ gengiɲ na sa Abraham pini mera ré. ");
INSERT INTO kqp_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Bay li hen iyôŋ na wô sarna, aɲ hena nana bi bôrna sa Emen wo biɲ Kelma wona Jésu ji si perê ka ma a hen na, ôbi a berêna mega ɓiɲé kaɲ derôre tiri a men. ");
INSERT INTO kqp_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jésu bi wo hen na, Emen na uwôli kôbi ɓiɲé, aɲ bi ré ma wô kibi têriɲ tona, menba, ôbi biri ji si perê ɓiɲé ka ma a, aɲ bi nana yiɲ ɓiɲé kaɲ derôre tiri a men. ");
INSERT INTO kqp_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Mega hen iyôŋ na, Emen berêna mega ɓiɲé kaɲ derôre tiri a wô kibi ayê bôô wona, aɲ haw hen nana mô ré bô jalê naɲ Emen sa kibi aŋga Kelma wona Jésu Krist li hen. ");
INSERT INTO kqp_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Na ôbi a belê geré bi Emen né béna derê wori wô kibi bôrna wo nana bi sa Jésu a hen. Na bô derê bi wo hen a nana mô bôô a haw hen men, nana liɲ yi derê a men, wôsa nana ɗi bôrna mega Emen né sa béna hini emê wori men. ");
INSERT INTO kqp_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Nana li yi derê na wô bi wo hen mera ré, niɲba, naa li yi derê kiriɲa nana mô bô gusiɲ a ba, ré geléna ulê bôô. ");
INSERT INTO kqp_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Kiriɲa nana uwôl bôrna hen iyôŋ na, a béna ɓeré bôrna iyêrê hen iyôŋ men, bôrna wo nana ɓu iyêre hen, a béna ɗé bôô sa Emen a men. ");
INSERT INTO kqp_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Hena nana ɗi bôrna hen iyôŋ na, a yé seŋge ré, wôsa Emen na geléna geyé wo ɗiré geyéna hen. Aɲ na Tini to ôbi na béna hen a gelé. ");
INSERT INTO kqp_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kwôlo en kôl hen na, en kôl na wo ca ba, néé wo na nana gôliɲ naɲ yerna ba, naɲ. Wulê bi wo hen na, *Krist sa ma wô sarna nabay kaɲ bay têriɲ. Na wulê wo Emen na genge. ");
INSERT INTO kqp_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Bi kwôni ré ma wô kibi kwôni woɲ derôre na, nana hôn wo ré na aŋga iyêre gaɲ. Hena ôbi na ré na ôbi lê derê a men ley dema kwôni ré geyé ma wô kibri. ");
INSERT INTO kqp_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Niɲba, Jésu Krist ba, ma wô sarna kiriɲa nana baɲ bô têriɲ a tô. Na hen iyôŋ a Emen né geléna geyé wo ɗiré geyéna hen. ");
INSERT INTO kqp_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Na naɲ kwôbri Jésu Krist wo ma wô sarna hen aɲa, Emen né berêna mega ɓiɲé kaɲ derôre tiri a hen. Na hen iyôŋ a, nana hôn wo Jésu Krist réé gôliɲ naɲ na, aɲ bi bô Emen né taari sarna ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ca kiriɲa na nana bay bayi Emen tô hen na, ôbi na hô bi nana biɲ pôn naɲ ɗi naɲ temay Kemari. Aɲ haw hen wo nana biɲ naɲ ɗi hen na, nana hôn dô wo ôbi réé gôliɲ naɲ na yôd wôsa Kemari mô tu geɲ. ");
INSERT INTO kqp_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Na hen iyôŋ mera ré. Nana li yi derê tumô Emen naɲ geré wo Kelma wona Jésu Krist, aɲ nana li yi derê wôsa ôbi a derê tumôrna ôriɲ ligi Emen a aɲ bi nana hô biɲ pôn naɲ ɗi. ");
INSERT INTO kqp_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Na gawra pôn nêŋ a lê têriɲ menba, hende gôr sa terare nà. Na wô kibi têriɲ hende to hen aɲa, ɓiɲé ré maɲ hen. Na hen iyôŋ a, temare ré gôr kiriɲ kêm men, duu gawrê kêm a men, wôsa bay kêm li têriɲ. ");
INSERT INTO kqp_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Têriɲ na yi sa terare a nà niɲ dema Emen na ré biɲ *Moyis tôô tô. Wulê wo tôô na naɲ tô hen na, Emen na uwôl kwôlê sa ɓiɲé kwôli têriɲ toji ré. ");
INSERT INTO kqp_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Niɲba, hen iyôŋ hari kôba, wulê wo Adam a yeŋ kwôy saɲ sa kwo Moyis a na, temare na ôm iyére sa ɓiɲé kêm. Bi wo têriɲ toji na yi mega to Adam to na biɲ kwôlê sa Emen a ré hen iyôŋ né. Adam na na tini kwo a era hen. ");
INSERT INTO kqp_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ɓiɲé bay ka wôô hen na, geliɲji ré. Wôsa têriɲ to Adam na li hen na, a némiɲ naɲ aŋga Emen béna hen né. Na tiri, ɓiɲé kwône ma wô kibi têriɲ to gawra pôn nêŋ a lê, niɲba, bô derê wo Emen ɗê aɲ sôŋ. Ôbi tô kibri damaŋ sa ɓiɲé kwône ɗéɲ iyôŋ men, liji dô wô kibi Jésu Krist a men. ");
INSERT INTO kqp_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Aŋga Emen bi na, yi geliɲ gay ɗiba, yi mega têriɲ né. Têriɲ to gawra pôn nêŋ li hen na, li aɲ Emen uwôl kwôlê sa ɓiɲé. Niɲba, kiriɲa Emen li bô derê wori naɲ ɓiɲé, bi wo bay li têriɲ damaŋ hen haji kôba, ôbi biji yi ɓiɲé kaɲ derôre aɲ kwôlê a ɓeré sarji ré niɲ. ");
INSERT INTO kqp_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Na tiri, gawra pôn nêŋ a lê têriɲ menba, temare ôm iyére sa gawrê kêm wô kibi têriɲ tori hende to hen. Hen iyôŋ ba, nana hôn wo sa kibi Jésu Krist pôn nêŋ na, nana uwôɲ are damaŋ. Ɓiɲé ka Emen biji bô derê wori damaŋ aɲ biji yi kaɲ derôre tiri a hen na, bay a merê tu geɲ naɲ kwiniji men, bay gôliɲ sa are kêm, sa kibi gawra pôn nêŋ, ôbi a na Jésu Krist. ");
INSERT INTO kqp_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Na ôbi á, nana gel wo kwôlê ɓu sa ɓiɲé kêm sa kibi Adam pôn nêŋ wo li têriɲ hen men, sa kibi Jésu Krist pôn nêŋ wo li aŋga dôri hen a lê aɲa kwôlê ré ɓu sa ɓiɲé kêm né hen men, ôbi biji mô tu geɲ naɲ kwiniji a men. ");
INSERT INTO kqp_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nana gel wo ɓiɲé kwône yi bay têriɲ wô kibi gawra pôn nêŋ wo biɲ Emen kwôlê ré hen iyôŋ na, ɓiɲé kwône yi kaɲ derôre tiri a wô kibi bê kwôlê wo Jésu Krist pôn nêŋ men. ");
INSERT INTO kqp_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Emen na biɲ ɓiɲé tôô to Moyis bi têriɲ toji ré ô tumô tumô menba, kiriɲa têriɲ to ɓiɲé ô tumô tumô hen iyôŋ na, bô derê wo Emen kôba, ô tumô tumô ɗê aɲ sôŋ. ");
INSERT INTO kqp_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Na hen iyôŋ a, bô derê wo Emen ré li aɲ ɓiɲé yi kaɲ derôre tiri a, mega wo têriɲ ôriɲ naɲ néé woɲ diriɲ gawrê hen iyôŋ men. Bô derê wori bi wo hen li aɲ nana môriɲ tu geɲ naɲ kununa aɲ na Kelma wona Jésu Krist a belê geré béna. ");
INSERT INTO kqp_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Hena ré na hen iyôŋ ba, naa kelê kwôli mi ba? Hena ré na hen iyôŋ ba, naa lê têriɲ aɲ bi Emen né béna bô derê wori damaŋ a ba? ");
INSERT INTO kqp_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Eŋ eŋ, na hen iyôŋ né kwôy. Kwo gengiɲ sa têriɲ ba, nana ma aɲ nana nêm merê bô têriɲ a ré kwôy niɲ. ");
INSERT INTO kqp_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ken hôn dô kiriɲa bay na lêna batêm hen na, ken hôn wo na nana biɲ pôn naɲ Jésu Krist hen iyôŋ haŋge ba? Wulê bi wo hen na, nana ma naɲ ɗi men. ");
INSERT INTO kqp_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kiriɲa bay na lêna batêm hen na, nana ma naɲ ɗi men, bay eména naɲ ɗi men, aɲ bi jé lêrena ré yi na aŋga kôrbi mega wo Ibarna Emen bi Jésu ji si kamɲê naɲ néé wori wo gôliɲ sa are kêm hen. ");
INSERT INTO kqp_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Na tiri, nana ma môɲ ôbi iyôŋ aɲa nana biɲ pôn naɲ ɗi hen. Mega wo hen iyôŋ na, nana biɲ pôn naɲ ɗi sa kwo gengiɲ sa jê sé kamɲê wori wo ôbi jiɲ siɲ kamɲê hen iyôŋ men. ");
INSERT INTO kqp_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nana hôn wo kiriɲa Jésu na ma sa gurô tagelê hen na, Emen na ɓér jé lêrena wo cay hen ya men, aɲ bi yi woɲ têriɲ ré ma men, bi têriɲ ré lêna lemnare ré niɲ a men. ");
INSERT INTO kqp_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Wôsa têriɲ ôriɲ naɲ néé sa kwôni wo ma hen ré niɲ yôd. ");
INSERT INTO kqp_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nabay naɲ *Krist nana maŋge, ôbi a nana hôn wo nana merê tu geɲ naɲ ɗi men hen. ");
INSERT INTO kqp_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Men, nana hôn wo Jésu Krist wo ré ji si kamɲê hen na, réé ma ré niɲ yôd 