﻿USE sofia;
DROP TABLE IF EXISTS sofia.kql_vpl;
CREATE TABLE kql_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kql_vpl WRITE;
INSERT INTO kql_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais* Gotkɨk fakɨk wulu anafu kavɨla. ");
INSERT INTO kql_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Katɨk Aisaia* galavale balañjɨkɨn Gotkɨk maŋgɨk malaŋmɨ sivɨleve. Wun moleve buk kumbaŋɨle yila wulu kavik tonma, “Gotɨn kavik galava, ‘Bɨiye, ŋɨn dakɨk wulundi ŋɨmaŋgapale yetɨk balañjɨk apɨsukuve ga ŋɨmama wandefop, dakɨk mai bambavaŋga. ");
INSERT INTO kql_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Muñuŋgumbañi yetɨk balañjɨkɨn towok sivɨtva, “Gasak Wakɨnkɨk mai bambave, wokok mase mfavɨliñjiwɨ.” ’ ” ");
INSERT INTO kql_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","De, Jonon muñuŋgumbaŋɨk yiŋɨmeve. Kaukatɨk balañju maŋamɨk ga bumŋɨlali wun. Jonon kavik yikali yikali galaveve, “Juñjuŋama anafak yive suwɨ. Suwɨndi ŋɨn be maŋamɨk ga bumbapa. Kavik pavɨndi Gotɨn bikɨk yaka wulu bikɨk safumbatɨk mandɨve ka sivɨlapayi. Valambapa.” ");
INSERT INTO kql_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","De, wunutuk yiŋɨ yiŋɨlali Juta galavale distrikɨle balañju wofopti Jerusalem galavale sititɨle balañju wofopɨn. Valan bɨkɨk yakavik paŋɨlalile wulu sivɨlevendi Jonon vala ga bumbeve Jordan galavale maŋamguanɨk. ");
INSERT INTO kql_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","De, Jonon kamel dumbindi paveve wataŋ wokok safutuk kuwɨlali. Jak mfɨsakti paveve dɨka kɨlɨkɨlali dauwutuk. Wun kusiŋandi manaŋu jiŋɨlali. ");
INSERT INTO kql_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wun kavik galaveve, “Ŋakɨk pɨtɨkti juñjuŋama matɨkakalɨwale balañjɨkɨn yiŋɨmama pɨndaŋ. Ŋɨn yakakatɨk balañjɨk, kapekandi apɨtɨtɨtve wokok gambiŋgitɨle sutɨle gɨnda tokoivalen ka balakapayi. ");
INSERT INTO kql_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋɨn be maŋamɨk ga bumba, kape wun be Gotkɨk Sulakti* ga bumbapa.” ");
INSERT INTO kql_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","De, Jisasɨlɨn Nasalet galavale watɨkɨle. Nasaletɨn Galili galavale distrikɨle avɨt. De, Jonon balañju maŋamɨk ga bumbeve valundi Jisasɨlɨn yetɨk vandi Nasalet valambe yiŋɨmeve Jontɨk. Kape, de, Jonon wunu maŋamɨk ga bumbeve, Jordan maŋamguanɨk. ");
INSERT INTO kql_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","De, Jisasɨlɨn maŋami alikɨvevekandi, de, wun wuleve fɨiŋgalɨn atavɨkɨvendi Gotkɨk Sulakɨn* wunutuk walimɨŋgo bumbeve. ");
INSERT INTO kql_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bumbevendi fɨiŋgati yetɨk maŋgɨkɨn kavik galaveve, “Du ŋakɨk ŋɨn mɨliwale fak. Ŋakɨk kumbaŋɨn du towok mɨliwa.” ");
INSERT INTO kql_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","De, Gotkɨk Sulakɨn* Jisas apɨsukuve ga ŋɨmeve yetɨk muñuŋgumbaŋɨk. ");
INSERT INTO kql_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wun kaukatɨk 40 valu toneve. Kavɨla valundi Satanɨn* wunu yikali yikali ta muwove yaka wulu ga pavaŋga. Wun muñugumbaŋɨle jakalindi tonevendi Gotkɨk luasamban sulun wunutuk anafak wulu ŋɨme paŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","De, yila balañjun Jon wuwɨ muñjɨmɨk suwove. Suwovendi Jisasɨlɨn Galilitɨk ŋɨmeve. Ŋɨmevekandi Gotkɨk wulu anafu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wun kavik galaveve, “De, mfɨmɨmaneve valɨn kamfu. Yila balañjun Got lolomɨk tonapa. Kapendi juñjuŋama anafak yive. Gotkɨk wulu anafu yive suwɨ.” ");
INSERT INTO kql_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisasɨlɨn Galili galavale maŋamguan vevekatɨk ŋɨmevekandi wuleve wuŋgiakti wufaka, bɨkɨk wuŋa Saimondi Andru. Valan giŋdi yesiŋa kolowove, maŋamguanɨk. Valan valu valu yesiŋandi bɨkɨk moni mɨñakavik yiŋɨlali. ");
INSERT INTO kql_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","De, Jisasɨlɨn valatɨk kavik galaveve, “Ŋunu vañjenme ŋɨme. Ŋɨn be apɨkakalaiyapa yesiŋa kolokvale daŋdi balañju miyakavik ga yivaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","De, valan kepat bɨkɨk giŋa valambevekandi wunu vañjenme wakan ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","De, yika ŋɨmevekandi, ŋaikɨkfak, wun wuleve yetɨk wuŋgiakti wufaka, Jemsɨndi Jon, Sepetikɨk fu. Valan bɨkɨk balɨ kumbaŋi giŋa yika waiŋgeve mfɨndɨŋeve. ");
INSERT INTO kql_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","De, wun vala galaveve, kapendi valan bɨkɨk waŋ balɨ kumbaŋɨk valambeve, bɨkɨk luasamban balañjundi. Valambevekandi valan Jisas vañjenme ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","De, Jisasɨlɨn wokok guŋgundandi Kaperneam galavale watɨkɨk ŋɨmeve. Ŋɨmevekandi, de, Yisɨ Tonɨmbale Valundi*Sa Wamɨk* ŋɨŋɨ lolo mfɨtɨti mfɨtɨti sivɨtali Jisasɨlɨn. ");
INSERT INTO kql_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","De, katɨk watɨkɨle balañjun wokok mfɨtɨtiwale wulu bɨimbɨi bɨkɨk kumbaŋgin yikali yikali kambekeve. Wun Gotkɨk Wulu Kumbaŋgikɨk Balañjuluŋgo* ava sivɨtve. Wun gasak pɨtɨkie wulukok wakɨnɨŋgo sivɨtali. ");
INSERT INTO kql_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De, yetɨk ŋaikɨk vandi yetɨk avɨtɨn toneve katɨk Sa Wamɨk. Yetɨk sulak yakakatɨkɨn wunutuk dundumɨive toneve. ");
INSERT INTO kql_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kapendi wun kavik joŋ galaveve, “Jisas, du Nasaletɨle avɨt. Dɨn gɨtɨk we pavaŋga pave yiŋɨma, ñetɨk? Dɨn ñe yakai yakai ga tonmaŋga pave yiŋɨmala? Ŋɨn du juŋava. Du Gotkɨk anafawali.” ");
INSERT INTO kql_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kape Jisasɨlɨn wunu apɨkakambeve. Wun kavik galaveve, “Maŋgɨk valambe! Wunu valambe dalaŋɨme!” ");
INSERT INTO kql_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","De, katɨk sulak yakakatɨkɨn katɨk avɨt ga nanambevekandi towok ga joŋovekandi wunu valambe ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","De, balañju wofopkɨk kumbaŋgin kambekeve. Valan busuak kavik sivɨleve, “Kasik gɨtɨk we? Kuŋgu wulu sivɨtva, wun. Wokok maŋgɨkɨn pɨtɨkie. Kapendi sulak yakakalen wokok maŋgɨk bɨiye pava.” ");
INSERT INTO kql_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","De, afɨndafɨnda katɨk wun paveve wulu Galilitɨle mɨta mɨta wofop ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Valan Sa Wami* salavevekandi Jisasɨlɨn Saimondi Andrukɨk mfotok ŋɨmeve, Jemsɨndi Jondi. ");
INSERT INTO kql_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","De, Saimonkɨk wuŋañilɨn malɨwɨ yokowɨ toneve safulun kukuleve. De, kape, de, valan sivɨleve Jisasɨtɨk, wokok mamalɨk. ");
INSERT INTO kql_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","De, Jisasɨlɨn wunutuk ŋɨmeve, wokok kɨlik mfove mfakambekevendi wokok mamalɨkɨn valambeve katɨk me. Kape, de, wun kambekevekandi jeñjek masiveve valatɨk. ");
INSERT INTO kql_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yisɨ Tonɨmbale Valɨn* balakevendi, katɨk mfunum, valɨn mfatɨnɨmbevendi, katɨk watɨkɨle balañjun Jisasɨtɨk malaŋɨve malɨwale balañju wofop, sulak yakakale dundumɨiyeve balañju wokok. ");
INSERT INTO kql_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","De, katɨk watɨkɨle balañju wofopɨn katɨk mfotok lova salava pavale mai mfakuŋguŋmɨ toneve. ");
INSERT INTO kql_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kapendi Jisasɨlɨn mamalu mamalu malɨwale balañju wusandaŋ anafak ga tonevekandi sulak yakakale wusandaŋ sañjaŋeve. Kavɨla sulak yakalen Jisas juŋaveve. Kape wun sulak yakakale kavik apɨkakambeve, “Ben wulu sivɨtvandu.” ");
INSERT INTO kql_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","De, watvit, gasak wukan vaŋ, Jisasɨlɨn kambewɨ yetɨk balañju mɨñakɨk mɨtɨk ŋɨme kukuñeve. ");
INSERT INTO kql_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","De, Saimonɨn wunundi wakan toneve balañjundi ŋɨme mamfoveve, Jisas. ");
INSERT INTO kql_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mamfovɨlevekandi kavik galaveve, “Wofopɨn du mamfova!” ");
INSERT INTO kql_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","De, Jisasɨlɨn valatɨk kavik galaveve, “De, amban yila vevekatɨk tonmale watatɨk ŋɨmama, ŋɨn Gotkɨk wulu sivɨtvaŋga. Ŋɨn katɨk juñjuŋamandi yiŋɨmeve.” ");
INSERT INTO kql_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kapekandi wun Galilitɨle mɨta mɨta wofop ŋɨmeve. Ŋɨmevekandi Sa Wumbi* kumbaŋgiti ŋɨŋɨ loveve. Lovevekandi Gotkɨk wulu sivɨlevekandi sulak yakakale sañjaŋeve. ");
INSERT INTO kql_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","De, yetɨk andɨvɨli safu jivali mamalɨkiye balañjɨkɨn Jisasɨtɨk ŋɨme gambiŋgi mfaiyimutve apɨtɨtɨlevekandi kavik galambalambaneve, “Dɨn ŋunu anafak ga tonmaŋga pave mɨliwalen, dɨn balakapa.” ");
INSERT INTO kql_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","De, Jisasɨlɨn wunu balambanevekandi kɨlik mandɨvevekandi wunutuk kavik galaveve, “Ŋɨn kavik mɨliwa. Dɨn anafak tonme.” ");
INSERT INTO kql_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","De, kepat katɨk andɨvɨli safu jivale mamalɨkɨn wunu valambeve, kape wun anafak toneve. ");
INSERT INTO kql_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","De, Jisasɨlɨn wunu apɨsukuve towok galaveve, ");
INSERT INTO kql_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dɨn waiŋgeve. Dɨn kavɨla wulu sivɨtvandu yetɨk balañjɨktɨk. Kape dalaŋɨme dakɨk safu apɨkasɨlɨmfu Gotkɨk Gasak Wamɨle Wakundutuk*. De, Mosesɨlɨn* anañ anañ bikɨk anañkɨk wuŋgasutuk galaveve yila lua masivaŋga kasik mamalɨk malɨwale balañjukok sulakɨn anafak ga tonmaŋgapale. Dɨn kavɨla lua malaŋmɨ masive kavɨla wakundutuk yila balañjutuk ga wutve juŋavaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kape katɨk avɨtɨn ŋɨme galaveve balañju wofoptɨk. Kavɨla wulu mɨta mɨtatɨk ŋɨme galaveve, wun. Kape Jisasɨlɨn yetɨk watɨk avik ŋɨme lovapa, sɨpalati. Wun muñuŋgumbaŋɨk tonevendi mɨta mɨtatɨle balañjun wunutuk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","De, muñuŋgubaŋñi tonevekandi Jisasɨlɨn Kaperneamɨk yika ŋɨmeve. Kapendi yila balañjun sivɨleve, “Jisasɨlɨn wokok mfotok tonma.” ");
INSERT INTO kql_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bɨiyevekandi balañjun wusandaŋɨn wokok mfotok yiŋɨmeve. Kapekandi balañju sakimbaŋ vaŋɨn gɨfutupeve. Mfoton apɨmomowovendi yilan mfot lova salava pavale mai makolowove. Kape, de, Jisasɨlɨn valatɨk Gotkɨk wulu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","De, valan yetɨk kɨliandi gambiŋgin sɨŋgɨneve balañjɨk Jisasɨtɨk malaŋɨve. Yila balañju aŋgataseñeñ wunu palasakɨk suwɨ malaŋɨve. ");
INSERT INTO kql_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Malaŋɨvekandi ta wuleve, mfoton apɨmomowove. Ta wulevekandi vavɨki kɨve mfot wunambinɨk vaŋɨle ñisemɨk malaŋkɨveve. Malaŋkɨvevekandi Jisasɨlɨn toneve mɨt wofop wofop yetɨk kutak mfamandaŋeve valan. Mfamandaŋevekandi mfot kumbaŋɨk palasaktɨliaka apɨkukuwo ga bumbeve. ");
INSERT INTO kql_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","De, Jisasɨlɨn kavik wuleve, bɨkɨk juñjuŋamalɨn kavik toneve, “Jisasɨkɨk pɨtɨkɨn gasak kasik balañjɨk anafak pavɨliyapa.” Wulevekandi wun kavik galaveve, “Ŋakɨk wufaka, ŋɨn dakɨk yaka wulu dakɨk safutuk mandɨve ka sivɨlapayi. Ŋɨn anañ valambale.” ");
INSERT INTO kql_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","De, yila Gotkɨk Wulu Kumbaŋgikɨk Balañjun* yisɨwɨ toneve Jisasɨndi. Valan bɨkɨk kumbaŋgiti kavik juŋaveve, ");
INSERT INTO kql_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kasik balañjɨkɨn wun kavik aipandi sivɨtva? Wun wokok wuŋ ŋaikɨk malaŋkɨva. Wun kavik juŋava, wun Gotoŋgo tonma! Gotɨn wun wusuak ŋaikɨk pava kavik, balañjukok yaka wulu valamba. ");
INSERT INTO kql_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kavɨla Gotkɨk Wulu Kumbaŋgikɨk Balañjun kavik juŋavevendi, de, kepat Jisasɨlɨn wokoki bɨkɨk juñjuŋamavi wuleve. Kapekandi wun valatɨk kavik galaveve, “Ben bikɨk kumbaŋgiti kavik aipandi juŋava? ");
INSERT INTO kql_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kasik kɨliandi gambiŋgin sɨŋgɨneve balañjɨktɨk avik sivɨlapa, ŋɨn? Kavik waiŋgeve sivɨlapati, ‘Ŋɨn dakɨk yaka wulu dakɨk safutuk mandɨve ka sivɨlapayi. Ŋɨn anañ valambale.’ Kavik waiŋgeve sivɨlapati, ‘Dɨn kambewɨ, dakɨk palasak yive dalaŋɨme.’ ");
INSERT INTO kql_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kape ŋɨn be apɨkakalayapa, Balañjɨkɨk Fakɨn yaka wulu valambaŋgapale pɨtɨkɨn kasik mañjikatɨk tonma.” Kavik sivɨlevekandi wun kavɨla Gotkɨk Wulu Kumbaŋgikɨk Balañju valambevekandi katɨk kɨliandi gambiŋgin sɨŋgɨneve balañjɨk wulevekandi kavik galaveve, ");
INSERT INTO kql_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ŋɨn dutuk sivɨtva, kambewɨ, dakɨk palasak yive, mfotok dalaŋɨme.” ");
INSERT INTO kql_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kapekandi katɨk avɨtɨn kambekevekandi wokok palasak yive salaveve, balañju wofopkɨk sɨpalati. Kapekandi bɨkɨk kumbaŋgin kambekevendi valan Got apɨkɨleve. Valan kavik galaveve, “Anañ amban kavik tonmale wulu ava wutve.” ");
INSERT INTO kql_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","De, Jisasɨlɨn yika ŋɨmeve maŋamguan vevekatɨk. Ŋɨmevendi balañju wofopɨn yiŋɨ yiŋɨ makolokɨlali wunutuk. Kapendi wun valatɨk yikali yikali mfɨtɨtiwɨ sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","De, wun ŋɨmevekandi wuleve, Livai galavale avɨt. Wun Alfius galavale avɨtkɨk fak. Livaisɨn yisɨwɨ toneve yetɨk takis yivaŋgapale mfotok. Jisasɨlɨn wunutuk kavik galaveve, “Ŋunu vañjenme ŋɨme!” Kape, de, Livaisɨn kambekevekandi Jisas vañjenme ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","De, Jisasɨlɨn Livaikɨk mfotok ŋɨmevekandi yisɨwɨ jeñjek jiveve. Takis yivaŋgapale balañju gasakamanaŋdi yaka wulu pavale balañju gasakamanaŋɨn yisɨwɨ toneve, Jisasɨndi wokok guŋgundandi wakan. Vala wusandaŋɨn Jisas vañjeneve. ");
INSERT INTO kql_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","De, yila Gotkɨk Wulu Kumbaŋgikɨk Balañju*, valan Farisitɨle* autu toneve, valan wuleve Jisasɨlɨn yisɨwɨ jeñjek jiveve yila yaka wulu pavale balañjundi yila takis yivaŋgapale balañjundi. Kapekandi valan wokok guŋgundatɨk kavik kombɨiyeve, “Takis yivaŋgapale balañjundi yaka wulu pavale balañjundi Jisasɨlɨn jeñjek aipaŋga jiva?” ");
INSERT INTO kql_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","De, Jisasɨlɨn kavik bɨiyevekandi valatɨk kavik galaveve, “Anafak tonmale balañjun doktatɨk ka ŋɨmi. Kayi. Malɨwale balañjun ŋaikɨk doktatɨk ŋɨma. Mɨñakavik ŋɨn anafak wulu pavale balañju joŋmɨ ga yiŋɨmaŋga ava yiŋɨme. Kayi. Ŋɨn yaka wulu pavale balañju joŋmaŋga yiŋɨmeve.” ");
INSERT INTO kql_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","De, yila valundi Jonkɨk guŋgundandi Farisitɨle* autun jeñjek wofop kakambeve. Ava jive. Kape, de, yila balañjun Jisasɨtɨk ŋɨme kavik kombɨiyeve, “Jonkɨk guŋgundandi Farisitɨle autukɨk guŋgundan jeñjek kakamba. Ka jivi. Kape dakɨk guŋgundan jeñjek ka kakambi. Valan jeñjek jiva. Aipaŋga jiva?” ");
INSERT INTO kql_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","De, Jisasɨlɨn valatɨk kavik galaveve, “Me yivapale vɨtɨk ŋɨmale balañjun jeñjek kakambala, katɨk me yivapale avɨtɨn valandi tonma? Kayi. Wun valandi tonmalen valan jeñjek ka kakambi. ");
INSERT INTO kql_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pɨndaŋ yila balañjun katɨk avɨt malaŋapa. Katɨk vandi valan jeñjek kakambapa.” ");
INSERT INTO kql_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","De, Jisasɨlɨn yila wulu kavik galaveve, “Yila balañjun yetɨk anɨkɨk wataŋ yindaŋ yive yetɨk pɨlɨk wataŋɨle guan mfɨndiŋmalen, wun pɨndaŋ andakambindi mfapetaŋmɨ pɨlɨk wataŋ ga pɨtɨwɨkapa. Pɨtɨkɨvakandi katɨk guanɨn gasak tonapa. Kapekandi balañjun kavik ka pavi.” ");
INSERT INTO kql_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","De, Jisasɨlɨn yila wulu kavik galaveve, “De, balañjun anɨkɨk wain maŋam yañjik jak mfɨsakɨk ka fulapayi. Kavik pavalen wun gɨfɨmbe kɨvakandi pɨtɨwɨkɨ wain maŋamɨn salave sakapa. Kape jak mfɨsakɨn yakakatɨk tonapa. Kayi. Anɨkɨk wain anɨkɨk jak mfɨsakɨk fulapa.” ");
INSERT INTO kql_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","De, yetɨk Yisɨ Tonɨmbale Vandi* Jisasɨlɨn yetɨk wit mandɨvale balam kumbaŋɨk ŋɨmeve. Wunundi wakan ŋɨmeve wokok guŋgundan wit mavi vekeve. ");
INSERT INTO kql_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","De, yila Farisitɨle* autun wunutuk kavik galaveve, “Valan kakambale wulu Yisɨ Tonɨmbale Vandi aipandi pava?” ");
INSERT INTO kql_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisasɨlɨn valatɨk kavik sivɨleve, “Devitɨn anañ paveve wulu moleve anañ anañ, yetɨk balañjɨkɨn. Ben katɨk momotva ava wuleka? Wunundi yila balañjun yataŋgɨn gunaŋan toneve. Valan jeñjekɨn mɨñakɨk. ");
INSERT INTO kql_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Katɨk vandi Apiatalɨn Gotkɨk Gasak Wamɨle Gasak Gia Wakɨn* toneve. Devitɨn*Gasak Wamɨk* ŋɨmevekandi katɨk Gotkɨk makɨtɨk mandɨvale bret jiveve. Katɨk Gasak Wamɨle Wakundun busuak ŋaikɨk jivale bret. Yila balañjun ka jivi, kakamba. Kape Devitɨn jive masiveve wunundi wakan ŋɨmeve balañjutuk.” ");
INSERT INTO kql_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisasɨlɨn kavɨla Farisitɨle aututɨk kavik sivɨleve, “Gotɨn Yisɨ Tonɨmbale Va mandɨveve balañju anafak ga tonmaŋga. Kape Gotɨn balañju ava mandɨve Yisɨ Tonɨmbale Va anafak ga tonmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Miyakavik Balañjɨkɨk Fakɨn* Yisɨ Tonɨmbale Vakɨk Gasak Wakɨn tonma.” ");
INSERT INTO kql_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","De, Jisasɨlɨn yetɨk Sa Wamɨk* yika loveve. Lovevekandi ŋaikɨk kɨlik sɨsɨŋgɨlifukɨk avɨtɨn toneve, katɨk Sa Wamɨk. ");
INSERT INTO kql_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Katɨk Sa Wam kumbaŋɨle balañjun Jisas wutve jɨleve. Wun katɨk avɨt anafak ga tonapati Yisɨ Tonɨmbale Vandi. Kavik pavalen valan wulu mandɨve sivɨtvaŋga juŋaveve wunutuk. ");
INSERT INTO kql_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","De, Jisasɨlɨn katɨk kɨlik sɨsɨŋgɨlifukɨk avɨtɨk galaveve, “Dɨn kaipatɨk ŋɨme.” ");
INSERT INTO kql_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jisasɨlɨn valatɨk kavik kombɨiyeve, “Yisɨ Tonɨmbale Vandi ala wulu kakamba, ala wulu anafak tonma? Wulu anafu pavati, yaka wulu pavati? Balañju anafak ga tonmati, balañju matve ga sɨŋgɨnmati?” Kape valan wulu ava sivɨtve. ");
INSERT INTO kql_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","De, Jisasɨlɨn vala jɨtve vaŋ jɨlevekandi wokok kumbaŋɨn akalakɨve. Bɨkɨk kumbaŋgin yakakale toneve. De, Jisasɨlɨn wokok kumbaŋɨn akalakeve. De, wun katɨk avɨtɨk sivɨleve, “Dɨn dakɨk kɨlik apɨpɨliñjiwɨ.” De, Wun wokok kɨlik apɨpɨliñjiwevekandi anafak toneve. ");
INSERT INTO kql_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sa Wami salavevekandi kavɨla Farisitɨle* autun Herotkɨk* autundi mfakuŋgumove, Jisas ga sɨŋgɨnmaŋgapale wulu gɨnambeve. ");
INSERT INTO kql_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","De, Jisasɨlɨn wokok guŋgundandi Galili maŋamguanɨk ŋɨmeve. Distrik Galilitɨle balañjun wusandaŋ wakan ŋɨmeve. Distrik Jutatɨle balañjun wakan, ");
INSERT INTO kql_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","siti Jerusalemɨle balañjun wakan, distrik Idumeatɨle balañjun wakan, maŋamguan Jordan aŋgɨndaŋɨle balañjun wakan ŋɨmeve. Siti Tair vevekatɨlendi siti Saidon vevekatɨle balañju wusandaŋɨn wakan ŋɨmeve. Valan wokok wun paveve papava bɨiyevekandi wunutuk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisasɨlɨn wokok guŋgundatɨk galaveve yetɨk balɨ vevekatɨk malaŋmɨ mandɨvaŋga, kavɨla balañju wusandaŋɨn wunu towok gɨfutupandu. ");
INSERT INTO kql_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wun balañju wusandaŋ anafak ga toneve, kapendi malɨwale balañju wofopɨn wunu gɨfutupeve, wunu mfovaŋga. ");
INSERT INTO kql_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","De, balañjutuk mamalɨk masivale sulak yakakale, valan Jisas wulevekandi, valan Jisasɨkɨk makɨtɨk kumu fɨlekevekandi kavik joŋmɨ galaveve, “Du Gotkɨk Fak.” ");
INSERT INTO kql_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisasɨlɨn apɨkakambe sivɨleve, “Ben ŋunu sivɨtve masivandu.” ");
INSERT INTO kql_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","De, Jisasɨlɨn lamɨk kɨvevekandi, wun mɨlikɨve balañju wun kañiŋɨve. Kapendi valan wunutuk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wun 12 autu akakalayeve wunundi wakan tonmakandi apɨsukuvaŋga Gotkɨk wulu sivɨtvakandi ");
INSERT INTO kql_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sulak yakakale sañjaŋmaŋgapale pɨtɨk yivaŋga. ");
INSERT INTO kql_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kavɨla 12 autukok wuŋa kavik tonma: Saimon, Jisasɨlɨn yetɨk wuŋ galaveve, Pita. ");
INSERT INTO kql_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sepetikɨk fak Jemsɨndi wokok wufaka Jon. Kavɨla alawiñ wun yetɨk wuŋ kavik galaveve, Boanerges. Ambɨkɨk balaŋdi katɨk wuŋkɨk asɨk kavik galava, bambalanduŋuŋgo fu. ");
INSERT INTO kql_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yila balañju Andrundi Filipti Bartolomyundi Matyundi Tomasɨndi yetɨk Jems, Alfiusɨkɨk fakti Tatiusɨndi yetɨk Saimon, Selotɨle balañjɨkti ");
INSERT INTO kql_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jutas Iskariot. Jutasɨlɨn mamatutuk Jisas kɨndɨŋmɨ suwapale fak. ");
INSERT INTO kql_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","De, Jisasɨlɨn wokok mfotok ŋɨmeve. Ŋɨmevendi balañju wusandaŋɨn yika wunutuk ŋɨmeve mfakuŋguŋove. Kapendi wun wokok guŋgundandi jeñjek akafayi jivapa? ");
INSERT INTO kql_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","De, kavik bɨiyevekandi wokok ñiŋandi jaŋasan wunutuk yiŋɨmeve, wunu wuwaŋga. Valan kavik galaveve, “Wun nanambakandi tonma, kaukatɨk.” ");
INSERT INTO kql_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","De, yila Jerusalemɨle Gotkɨk Wulu Kumbaŋgikɨk Balañjun* wunutuk ŋɨmeve. Valan kavik galaveve, “Katɨk Belsepul galavale sulak yakakatɨkɨn wokok kumbaŋɨk tonma. Kapekandi wun katɨk sulak yakakalekɨk gasak wakɨnkɨk pɨtɨkti yila sulak yakakale sañjaŋmɨ.” ");
INSERT INTO kql_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","De, Jisasɨlɨn vala yiŋɨmaŋga galaveve. Yiŋɨmevendi wun apɨkamule wulu kavik sivɨleve, “Satanɨn* Satan avik sañjaŋapa? ");
INSERT INTO kql_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋaikɨk lomɨn gɨŋgani matɨvavɨlevekandi yipatɨli balañjun yipatɨli balañjundi mɨn ŋɨlik tonma, kavik pavalen katɨk lomɨn anafak ka tonapayi. ");
INSERT INTO kql_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","De, ŋaikɨk mfotɨle balañjun mɨn ŋɨlik tonmalen valan anafak ka tonapayi. ");
INSERT INTO kql_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","De, Satanɨn wokok guŋgundandi gɨŋgani matɨvavɨli mɨn ŋɨlɨwalen, valan ka sambɨtve tonapayi. Wun mɨñakɨk tonapa. ");
INSERT INTO kql_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","De, yetɨk fumafumɨn katɨk gasak pɨtɨkie balañjɨkɨk mfotok yataŋgɨn ka lovapayi, lua fombaŋga. Wun wandefaka kɨlɨwɨ balawɨ, lovama, lua fombaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ŋɨn betɨk wulu vaŋu galava, balañjun Gotkɨk wulu anafu yive suwɨndi, Gotɨn kavɨla balañjukok yaka wulundi Got maiyawale wulu bɨkɨk safumbatɨk ka mandɨve sivɨlapayi. Valambapa. ");
INSERT INTO kql_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kape yetɨk balañjɨkɨn Gotkɨk Sulak maiyawalen, Gotɨn katɨk yakakatɨk wulu ka valambapayi. Wokok yaka wulu valu valu tonŋɨmama.” ");
INSERT INTO kql_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kavɨla Gotkɨk Wulu Kumbaŋgikɨk Balañjun anañ kavik sivɨleve, “Wun wokok kumbaŋɨk yetɨk sulak yakakatɨkɨn tonma.” Kapendi Jisasɨlɨn kavɨla wulu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","De, Jisasɨkɨk womendi wufakalɨn yiŋɨmevekandi tataŋgatɨk sambɨlevekandi yetɨk balañjɨk apɨsukuveve Jisas ga salavaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Balañju sakimbaŋɨn wunundi yisɨwɨ toneve. Valan wunutuk sivɨleve, “Dakɨk womendi wufakali tataŋgatɨk tonma. Valan du salavaŋga galava.” ");
INSERT INTO kql_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","De, Jisasɨlɨn kavik kombɨiyeve, “Ŋakɨk womendi wufakali nanimba?” ");
INSERT INTO kql_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wun kavɨla wunundi yisɨwɨ toneve balañju joloŋevekandi kavik galaveve, “Ŋakɨk womeandundi wufakalin kavɨla. ");
INSERT INTO kql_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gotkɨk wulu pavale balañjun ŋakɨk wufaka, ŋakɨk sami, ŋakɨk wome tonma.” ");
INSERT INTO kql_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","De, balañju gasakamanaŋ Jisasɨtɨk yika ŋɨme mfakuŋguŋove mfanɨk, kapendi Jisasɨlɨn wulu mfɨtɨtiwɨ sivɨleve Galili maŋamguan avaki. Kape, de, wun balɨnɨk valape yisɨwove maŋamguanɨk. De, wofopɨn siŋasiŋ mokalowove. ");
INSERT INTO kql_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wun yila wulu gasakamanaŋ apɨkamule sivɨleve, valatɨk. De, kavik mfɨtɨtiwɨ sivɨleve, ");
INSERT INTO kql_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“De, bɨiye. Yetɨk avɨtɨn wit mavi mandɨveven masoiŋɨmeve, wokok balamɨk. ");
INSERT INTO kql_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","De, wun miyakavik masoiŋɨmevendi yila wit mavi masi kumuwovendi waŋan ŋɨme jiveve. ");
INSERT INTO kql_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","De, yila wit mavi yetɨk mɨndɨmɨn vɨlekɨk toneve mañjikatɨk kumuwove. Gasakamanaŋ mañju mɨñakɨk mɨtɨk kumuwove. Kape, de, valan kepat pambi takeve. ");
INSERT INTO kql_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Takevekandi valɨn sikapavendi kepat aliyeve. Sɨmbɨlin waiŋgeve ava bumbe, kape aliyeve. ");
INSERT INTO kql_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","De, yila wit mavi yisakɨk wulakɨn gɨŋganɨk kumuwove, kapendi katɨk wulakɨnɨn vaiyendoŋevendi kavɨla witɨn ava loŋmɨ. ");
INSERT INTO kql_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","De, yila wit mavin mañjika anafakɨk kumuwove. Kapekandi kambewɨ gasak tonevekandi yila ŋaikɨk ŋaikɨkɨn 30 loŋeve, yila ŋaikɨk ŋaikɨkɨn 60 loŋeve, yila ŋaikɨk ŋaikɨkɨn 100 loŋeve. Wofopɨn miyakavik loŋeve.” ");
INSERT INTO kql_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kapekandi wun kavik sivɨleve, “Tuandukok balañjɨk mɨkɨnɨm bɨiyaŋgale.” ");
INSERT INTO kql_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisasɨlɨn wokok guŋgundandi ŋaikɨk yika tonevendi, yila wunundi wokok 12 guŋgundandi toneve balañjun wunutuk kavɨla apɨkamule sivɨleve wulu kombɨiyeve. ");
INSERT INTO kql_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisasɨlɨn valatɨk kavik galaveve, “Ben yivale Gotkɨk lomɨle fombale wulu, kape yila balañjun ava yive. Apɨkamule sivɨtvale wulu katɨk ŋaikɨk bɨiya, valan. ");
INSERT INTO kql_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kapekandi valan yataŋgɨn jɨñjɨt tonma, kape ka wuti. Yataŋgɨn bɨimbɨi tonma, kape ka juŋavi. Valan kavik pavalen juŋjuŋamavi anafak yivakandi Gotɨn bɨkɨk wulu yakakale bɨkɨk safumbatɨk mandɨve ka sivɨlapayi. Valambapa. Kape kavik ka pavi, valan.” ");
INSERT INTO kql_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","De, Jisasɨlɨn kavik kombɨiyeve, “Ben kasik apɨkamule sivɨtvale wulukɨk asɨk ka juŋavala? Ben apɨkamule sivɨtvale wulu wofopkɨk asɨk avik juŋavapa? ");
INSERT INTO kql_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Katɨk wit mavi mandɨvale avɨtɨn wun Gotkɨk wulu mandɨva. ");
INSERT INTO kql_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Katɨk masi kumuwole wit mavi kavik tonma, Gotkɨk wulu sivɨtvale mɨtɨk yila balañjun wokok wulu bɨiya, kape Satanɨn afɨndafɨnda ŋɨme dɨwa, katɨk valan bɨiyale wulu. ");
INSERT INTO kql_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","De, mɨñakavik, kavɨla wit mavin yetɨk mɨndɨm vɨlekɨk tonmale mañjikatɨk kumuwa. Valan kavik tonma, yila balañjun Gotkɨk wulu bɨiyakandi afɨndafɨnda yive vavalawa. ");
INSERT INTO kql_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kape valan sɨmbɨli mɨñakɨk bɨkɨk kumbaŋgitɨk. Ŋasuak ŋasuak tonmale yila balañjun Gotkɨk wulu gɨlɨpakandi valatɨk yikali yikali yaka wulu pavandi valan Gotkɨk wulu valamba, kepat. ");
INSERT INTO kql_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","De, mɨñakavik, kavɨla wit mavin yisakɨk wulakɨndakɨk mɨtɨk kumuwa. Valan kavik tonma, yila balañjun Gotkɨk wulu bɨiya. ");
INSERT INTO kql_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kape valan mañjikatɨle wulu wulu wofop towok juŋava. Moni pɨpɨwandi yila lua yivaŋga mɨliwa. Kavɨla wulun wofop Gotkɨk maŋgɨk vaiyendoŋmandi ka loŋmi. ");
INSERT INTO kql_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","De, mɨñakavik, yila wit mavin mañjika anafakɨk kumuwa. Valan kavik tonma, yila balañjun Gotkɨk wulu bɨiye yive mfovakandi loŋmɨ, yila ŋaikɨk ŋaikɨkɨn 30 loŋma, yila ŋaikɨk ŋaikɨkɨn 60 loŋma, yila ŋaikɨk ŋaikɨkɨn 100 loŋma.” ");
INSERT INTO kql_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","De, Jisasɨlɨn kavi kombɨiyeve, “Ben yisɨ tonmaŋgapale mɨn gɨnɨŋgindi tɨmbala? Kayi. Ben katɨk mɨn mambat lolomɨk mandɨvala? Kayi. Ben mambat vɨlekɨk mandɨvala? Ye! ");
INSERT INTO kql_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anañ gɨsakaivale wulu wofopɨn wulapa. Anañ fombe tonmale wulu tataŋgatɨk tonapa. ");
INSERT INTO kql_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tuandukok balañjɨk mɨkɨnɨm bɨiyaŋgale.” ");
INSERT INTO kql_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisasɨlɨn valatɨk kavik sivɨleve, “Ben bɨiyale maŋgɨk, ben mfove. Ben atɨk siŋgak masivalen Gotɨn betɨk katɨk ŋaikɨk siŋgak masivapa. Kape Gotɨn betɨk yila wusandaŋ masivapa. ");
INSERT INTO kql_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yetɨk balañjɨkɨn yila lua tonmalen, Gotɨn yika yila lua masivapa wunutuk. Yetɨk balañjɨkɨn lua mɨñakɨk tonmalen, wunutuk tonmale lua wokok, Gotɨn yivapa.” ");
INSERT INTO kql_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","De, Jisasɨlɨn kavik sivɨleve, “Gotkɨk lomɨn kavikɨŋgo tonma, ŋaikɨk balañjɨkɨn wit mavi balamɨk mandɨveve. ");
INSERT INTO kql_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","De, wun wukanda ñemŋɨlalilekandi vasisu paŋɨlali, kape kavɨla valundi pambi tawɨ apɨkɨkɨva, kape katɨk balañjɨkɨn katɨk apɨkɨkɨvale wulu ka juŋavi. ");
INSERT INTO kql_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","De, katɨk mañjikalɨn woven ga tawɨ pambi, de, pɨndaŋ duŋmati loŋmakandi, de, pɨndaŋ vaŋ wokok mavi loŋeve. ");
INSERT INTO kql_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","De, kavɨla witɨn alivakandi sɨŋgɨnma, kape balam waŋɨn ŋɨma, yivaŋga pave. Wokok jeñjekɨn balawale.” ");
INSERT INTO kql_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","De, Jisasɨlɨn kavik sivɨleve, “Gotkɨk lomɨn gɨtɨk woseŋgo tonma? Amban gɨtɨk wulu apɨkamule sivɨlapa? ");
INSERT INTO kql_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wun muŋ mastet maviŋgo tonma. Katɨk mañjikatɨk mandɨvale, wun vɨvɨtka vaŋ tonma. Yila mavi wofopɨn gasak. ");
INSERT INTO kql_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kape wunu mandɨve kambekuakɨle gasak vaŋ, wokok yila gasak gu mɨliyaŋgale, kapendi yila waŋan muaŋa kawale wokok dɨndɨŋgatɨk.” ");
INSERT INTO kql_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","De, Jisasɨlɨn yila kavik tonmale wulu wusandaŋ valatɨk apɨkamule sivɨleve, bɨkɨk juñjuŋamatɨle gɨkɨlikɨk. ");
INSERT INTO kql_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wun vala wofopti tonevekandi apɨkamule wulu ŋaikɨk sivɨleve. Kape wun wokok guŋgundandi ŋaikɨndi tonevekandi, wun wokok wulu wofop matɨsivaŋmɨ sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","De, katɨk vanɨle mfunum, valɨn mfatɨndɨmbevendi, Jisasɨlɨn wokok guŋgundatɨk sivɨleve, “Amban aŋgɨndaŋɨk govapa.” ");
INSERT INTO kql_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","De, valan katɨk mfakuŋguŋeve mfa valambe ŋɨmeve. De, Jisasɨlɨn wandefaka balɨnɨk valape yisɨ mfɨtɨtiwɨ sivɨleve. Kapekandi valan wakan valapevekandi ŋɨmeve. Yila balɨŋan wakan ŋɨmeve, wunundi. ");
INSERT INTO kql_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","De, gasak vɨvɨlimɨn ŋɨmandi pukapukalɨn gasak vaŋɨn kambekevendi balɨlɨn maŋam mfuleve. Gasak maŋam mfulevendi ŋɨlɨwaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisasɨlɨn fufu kalaŋmɨ fop mandɨve ñembeve vimbati. Kape valan wunu matɨmfemfembe sivɨleve, “Watpalaŋ, dɨn sawulu juŋavala, amban sɨŋgɨnapa!” ");
INSERT INTO kql_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kapendi Jisasɨlɨn kambekuakave vɨvɨlim apɨvawɨ galavevekandi maŋam wokok kavik, galaveve, “Balawɨ! Biam tonme!” Kape, de, vɨvɨlimɨn mɨñakɨk, biam toneve maŋamɨn. ");
INSERT INTO kql_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jisasɨlɨn wokok guŋgundatɨk kavik sivɨleve, “Ben aipandi valaiva? Ben Gotkɨk wulu ava yive suwoka?” ");
INSERT INTO kql_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","De, valan towok valaiveve. Valan bɨsak sivɨleve, “Wun nanafat? Wun galavandi vɨvɨlimndi maŋamɨn wokok maŋgɨk bɨiye pava.” ");
INSERT INTO kql_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","De, Jisasɨlɨn wokok guŋgundandi maŋamguan aŋgɨndaŋɨn goveve, katɨk Gerasa galavale mɨtɨk. ");
INSERT INTO kql_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Govevekandi balɨni alikɨvevendi, de, kepat yetɨk sulak yakakale dundumɨivale balañjɨkɨn gumbiti salave ŋɨmeve, Jisasɨtɨk. ");
INSERT INTO kql_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Katɨk balañjɨkɨn gumbitɨk tonŋɨlali. Yila balañjun wunu ta kɨlɨkeve. Senɨn ava balawɨ. ");
INSERT INTO kql_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Valan anañ yikali yikali sendi gambiŋgindi kɨlia kɨlɨkeve. Kape wun kɨliatɨle sen gɨpɨtɨkevekandi gambiŋgitɨle wokok gɨpɨtɨwɨ pata pata ga kumuwove. De, balañju wofopɨn pɨtan mɨñakɨk wunu wuwaŋgapale. ");
INSERT INTO kql_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vasisu wukanda wun gumbitɨk toneve, kape lambitɨk. Towok kolekɨlalilekandi wovene wovene wokok safu mapɨpɨlɨkeve, mundumundi. ");
INSERT INTO kql_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wun Jisas ganaiŋgatɨk wulepakavekandi Jisasɨtɨk jaŋevekandi makiye daŋdi vandamfufu amandepewɨ bakti mañjikatɨk taŋmɨ toneve. ");
INSERT INTO kql_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","De, Jisasɨlɨn wunutuk sivɨleve, “Kasik sulak yakakatɨk, dɨn wunu valambe!” De, katɨk balañjɨkɨn gasak pɨtɨkti joŋmɨ sivɨleve, “Jisas, du Gotkɨk fak. Goton wusuak ŋaikɨk tonma, Gasak Wakɨn. Dɨn ŋunutuk gɨtɨk papa? Ŋɨn dutuk Gotkɨk wuŋdi aŋgeleŋmɨ sivɨtva, dɨn ŋunu yakai yakai pavandu.” ");
INSERT INTO kql_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","De, Jisasɨlɨn wunutuk kombɨiyeve, “Dakɨk wuŋɨn nanɨ?” De, wun Jisasɨtɨk sivɨleve, “Ŋakɨk wuŋɨn Kamaŋ. Ñen gasakamanaŋ.” ");
INSERT INTO kql_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wun Jisas towok galambalambaneve vala sañjaŋmɨ yetɨk mɨtɨk ga ŋɨmandu. ");
INSERT INTO kql_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","De, vevekatɨk yetɨk lamɨk yila vilun sakimbaŋɨn jitoneve. ");
INSERT INTO kql_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kavɨla sulun galambalambanme sivɨleve, “Ñe kavɨla vilutuk apɨsukuve. Ñe valatɨk ga love.” ");
INSERT INTO kql_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kape Jisasɨlɨn apɨsukuve ga ŋɨme loveve. De, valan katɨk balañjɨk valambe salavevekandi vilutuk lovevendi kavɨla vilu wofopɨn kambɨlɨmɨk jaŋ bumbe ŋɨlɨkeve maŋamguanɨk. De, 2000-iŋgo ŋɨlɨwove. ");
INSERT INTO kql_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kape, de, kavɨla vilu mañjiñjiveve balañjun mɨlevekandi sivɨleve, gia watɨkɨle balañjundi kaukatɨle balañjutuk. Kape, de, valan wofopɨn salaveve wulaŋga, katɨk paveve wulu, gɨtɨk wulu. ");
INSERT INTO kql_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","De, valan Jisasɨtɨk ŋɨmevekandi katɨk kamaŋ sulu dundumɨivale balañjɨk wuleve. Wun wataŋ kɨlɨwɨ Jisasɨndi yisɨtoneve. Wokok juŋjuŋamalɨn tukuakeve, kapendi kavɨla balañjun valaiveve. ");
INSERT INTO kql_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kavɨla wutvale balañjun Jisasɨlɨn pavale wulu yila balañjutuk sivɨleve, katɨk sulak yakakatɨk dundumɨiveve balañjɨkɨk wulundi katɨk vilukɨk wulu sivɨleve, valan. ");
INSERT INTO kql_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","De, kavɨla balañjun galambalambaneve Jisasɨlɨn bɨkɨk mañjika valambe ŋɨmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisasɨlɨn balɨnɨk valapaŋga pavevendi katɨk sulak yakakale dundumɨivale avɨtɨn wakan ŋɨmaŋga galambalambaneve Jisasɨtɨk. ");
INSERT INTO kql_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kape Jisasɨlɨn wunu kavik aŋgeleŋmɨ sivɨleve, “Dɨn dakɨk mfotok dalaŋɨme, dakɨk balañjutuk sivɨtvaŋga kasik Gasak Wakɨnɨn du balambanme pavale wulu.” ");
INSERT INTO kql_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kape, de, katɨk avɨtɨn valambe ŋɨme sivɨleve Dekapolis galavale distrikɨle balañjutuk. Wun Jisasɨlɨn wunutuk pavale wulu sivɨleve, kapendi balañju wofopkɨk kumbaŋgin kambekeve. ");
INSERT INTO kql_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","De, Jisasɨlɨn yika aŋgɨndaŋɨk gove alikɨvevendi balañju wusandaŋɨn wunutuk mfakuŋguŋove maŋamguan vevekatɨk. ");
INSERT INTO kql_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","De, yetɨk Sa Wamɨle* Jairus galavale gasak avɨtɨn Jisasɨtɨk ŋɨmeve. Jisas wulevekandi katɨk avɨtɨn Jisasɨkɨk gambiŋgi mɨtɨk ŋɨme mfaiyimɨtve apɨtɨtɨlevekandi ");
INSERT INTO kql_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","galambalambanme kavik galaveve, “Ŋakɨk alepɨn sɨŋgɨnmaŋga pava. Dɨn ŋɨme kɨlik mandɨvaŋga. Kavik pavalen wun anafak tonapa, ka sɨŋgɨnapayi.” ");
INSERT INTO kql_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","De, Jisasɨlɨn wunundi ŋɨmeve. Gasakamanaŋ balañjun wakan ŋɨme wunu gɨfutupe ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","De, ŋaikɨk melɨn wakan ŋɨmeve. Wun 12 yia yila valu wusandaŋ ambala towok kakɨlali. ");
INSERT INTO kql_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Katɨk melɨn gasakamanaŋ doktalutuk ta ŋɨlali. Kape valan wunu towok ga akalakeve kape wun wokok gasakamanaŋ moni vala ta wusuwɨ valambeve. Kape wokok mamalɨkɨn ava valambe. Avan. Yika gasak toneve. ");
INSERT INTO kql_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Katɨk melɨn Jisasɨkɨk wulu bɨiyeve kapekandi gasakamanaŋ balañju gɨŋgani yiŋɨmeve Jisas pɨndaŋi. Yiŋɨmevekandi wun Jisasɨkɨk wataŋ matɨvɨvɨñiŋeve. ");
INSERT INTO kql_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wun wokoki sivɨleve, “Ŋɨn wokok wataŋ matɨvɨvɨñiŋmalen, ŋɨn anafak tonapa, yika.” ");
INSERT INTO kql_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","De, kepat, wokok ambala matɨtɨkaleve. Wun juŋaveve wokok mamalɨkɨn wunu valambeve. ");
INSERT INTO kql_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","De, kepat, Jisasɨlɨn kavik juŋaveve yila pɨtɨkɨn wunu valambe salaveve. Kapekandi, matɨyokolowɨ sivɨleve, “Ŋakɨk wataŋ nan matɨvɨvɨñiŋma?” ");
INSERT INTO kql_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","De, wokok guŋgundan wunutuk sivɨleve, “Balañjun gasakamanaŋ du gɨfutupa. Dɨn aipandi galava, ‘Ŋunu nan matɨvɨvɨñiŋma?’ ” ");
INSERT INTO kql_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kape Jisasɨlɨn joloŋeve wunu matɨvɨvɨñiŋeve balañjɨk wulaŋga. ");
INSERT INTO kql_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","De, katɨk melɨn valaive pɨpɨkeve. Wun juŋaveve, wokok mamalɨkɨn wunu valambeve. Kapekandi Jisasɨkɨk makɨtɨk gambiŋgi mfaiyimɨtve apɨtɨtɨlevekandi wulu vaŋu sivɨleve. Wun wokok wulu wofop sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","De, Jisasɨlɨn wunutuk sivɨleve, “Ŋakɨk sami, dɨn kavik juŋava, ŋɨn dakɨk mamalɨk ga apɨtandaŋmaŋgapale pɨtɨkɨn tonma. Katɨk juñjuŋamandi mamalɨk valambale, dɨn. Dɨn anafak dalaŋ juŋaŋɨme. Dɨn dakɨk mamalɨkɨn yika ka yivapayi.” ");
INSERT INTO kql_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Valan kamfu sivɨt tonevekatɨk, katɨk bɨkɨk Sa Wamɨle gasak avɨtkɨk mfotɨle yetɨk avɨtɨn ŋɨme sivɨleve, “Dakɨk alepɨn anañ sɨŋgɨnmale. Watpalaŋ gɨtɨk paŋga malaŋmaŋga? Ga tonme.” ");
INSERT INTO kql_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","De, Jisasɨlɨn bɨkɨk wulu bɨiyulu gɨlipeve. Wun katɨk bɨkɨk Sa Wamɨle gasak avɨtɨk kavik sivɨleve, “Valaivandu. Ŋakɨk wulu yive suwɨ.” ");
INSERT INTO kql_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","De, wun balañju wofop aŋgɨleŋevekandi wun aliluaŋguaŋ balañju ŋaikɨk malaŋeve, Pitandi Jemsɨndi Jon, Jemsɨkɨk wufaka, kavɨla aliluaŋguaŋ ŋaikɨndi wakan ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","De, valan katɨk wamɨle gasak avɨtkɨk mfotok ŋɨmevekandi, Jisasɨlɨn kavik wuleve, yila balañjun jipala salaveve, kape yila balañjun towok yekeve. De, gasak dɨndɨŋgɨt paveve, valan. ");
INSERT INTO kql_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","De, Jisasɨlɨn lovevekandi sivɨleve, “Ben aipandi gasak dɨndɨŋgɨt pandi pandi yewɨ? Wun ava sɨŋgɨnme. Wun ñemba.” ");
INSERT INTO kql_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kape valan wunu sekeve. De, wun vala wofop tataŋgatɨk sañjaŋeve. Sañjaŋevekandi katɨk alepkɨk womendi waŋdi wokok wunundi ŋɨmeve balañjundi katɨk alepɨn toneve mɨtɨk loveve. ");
INSERT INTO kql_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","De, wun katɨk alepkɨk kɨlik mfovevekandi galaveve, “Talita kum.” Wun ambɨkɨk balaŋdi kavik galava, “Kasik alepat, ŋɨn du galava, dɨn kambewɨ!” ");
INSERT INTO kql_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","De, kepat katɨk alepɨn kambekevekandi makaŋɨmeve. Wun 12 krismas toneve. De, kavɨla balañjun wutve vɨlawɨkɨ pɨkɨliyeve, towok pɨkɨliyeve. ");
INSERT INTO kql_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","De, Jisasɨlɨn valatɨk towok sivɨleve kasik wulu yila balañjutuk sivɨtve masivandu. Kavik sivɨlevekandi yila jeñjek katɨk aleptɨk masivaŋga galaveve. ");
INSERT INTO kql_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","De, Jisasɨlɨn katɨk mɨt valambe ŋɨmeve wokok watɨkɨk. Wokok guŋgundandi wakan ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","De, katɨk Yisɨ Tonɨmbale Vandi* wun Sa Wamɨk* love mfɨtɨti mfɨtɨti sivɨleve. Wulu bɨiyeve balañju wusandaŋɨn pɨkɨliye sivɨleve, “Kasik avɨtɨn kavɨla wulu akati yivale? Katɨk wunutuk tonmale gasak juŋjuŋamalɨn avik tonma? Kasik avɨtɨn kavɨla gasak pɨtɨkie wulu akati yivale? ");
INSERT INTO kql_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wun katɨk kɨlikvali. Wun Mariakɨk fak. Wun Jemsɨndi Josepɨndi Jutasɨndi Saimonkɨk wuŋgiak. Wokok samilu ambandi tonma.” Kavik sivɨlevekandi, de, bɨkɨk kumbaŋgin akakalakeve, wunundi. ");
INSERT INTO kql_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","De, Jisasɨlɨn kavik sivɨleve, “Balañjun Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨk akɨtva, kape wokok watɨk ŋaikɨk valan wunu ka akɨtvi, wokok ñiŋan wunu ka akɨtvi, wokok mfotɨle balañjun wunu ka akɨtvi.” ");
INSERT INTO kql_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kape, de, Jisasɨlɨn gasak pɨtɨkie wulu katɨk watɨkɨk avik pavapa? Kape wun ŋaikɨk ŋaikɨk malɨwale balañju kɨlik mandɨvevendi apɨtandaŋeve. ");
INSERT INTO kql_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Valan wokok wulu ava yive suwɨ, kapendi wun towok juŋaveve. De, Jisasɨlɨn wokok guŋgundandi wata watatɨk ŋɨlali mfɨtɨti mfɨtɨti sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kape, de, wun wokok 12 guŋgunda kañiŋmɨleve. Kañiŋɨmɨlevekandi asɨkuveve alawiñe alawiñe Gotkɨk wulu sivɨtvaŋga. Wun valatɨk pɨtɨk masiveve sulak yakakale sañjaŋmaŋgapale. ");
INSERT INTO kql_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Wun kavik galaveve, “Ben muŋfuti sundi safutɨle wataŋ ŋaikɨk malaŋmɨ. Kape yetɨk wataŋdi kaŋgaindi bretandi yila monindi malaŋmandu.” ");
INSERT INTO kql_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wun valatɨk galaveve, “Ben yetɨk watɨkɨk ŋɨme apɨsalavakandi yetɨk ŋaikɨk mfotok love tonmumfu. Ben katɨk mfot valambe yetɨk mfotok ŋɨmandu. Kape yetɨk watɨk ŋɨmamaŋga pavalen, de, katɨk vandi katɨk mfot valambumfu. ");
INSERT INTO kql_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","De, katɨk watɨkɨle balañjun be yivulu gɨlipakandi bikɨk wulu bɨiyulu gɨlipalen, de, ben vala valambe ŋɨmumfu. Kavik pavapalen ben bikɨk gambiŋgitɨle mañju bɨmbɨliŋmumfu. Kavik pamfu kavɨla balañjun bɨkɨk yaka wulu ga juŋavaŋgapale.” ");
INSERT INTO kql_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kape, de, kavɨla guŋgundan wata watatɨk ŋɨŋɨ salavevekandi sivɨleve, yila balañju anafak juñjuŋama ga yivaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Valan sulak yakakale wusandaŋ sañjaŋevekandi malɨwale balañju gasakamanaŋɨk wel mandɨve anafak ga toneve. ");
INSERT INTO kql_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","De, Herot* galavale juwutkasakɨn bɨiyeve Jisasɨkɨk wuŋɨn gasak toneve, mɨta mɨtatɨk. Yila balañjun kavik galaveve, “Jon, katɨk balañju maŋamɨk gaŋga bumbeve balañjɨkɨn, wun sɨŋgɨneve kape guami yika kambekevekandi yika wun Jisas tonma. Kapekandi kavɨla gasak pɨtɨkie wulu pava.” ");
INSERT INTO kql_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kape yila balañjun kavik galaveve, “Elaijalɨn* Jisas tonma.” Kape yilan galaveve, “Wun yetɨk Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨk, anañkɨk Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨkɨŋgo tonma.” ");
INSERT INTO kql_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","De, Herotɨn kavɨla wulu bɨiyevekandi sivɨleve, “Ŋɨn sivɨtve Jonkɨk fop ga matɨpɨtɨkeve, kape wun guami yika kambekeve.” ");
INSERT INTO kql_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Anañ Herotɨn wokok Filip galavale wufakakɨk Herotias galavale me vasomɨleve. Jonon Herotɨk kavik sivɨleve, “Gotkɨk wulun kakambeve dakɨk wufakakɨk me vasomɨleve wulu.” Kape, de, Herotɨn wokok matamatu ga ŋɨmeve Jon wuwɨ muñjɨmɨk suwove. ");
INSERT INTO kql_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kape, de, Herotiasɨkɨk kumbaŋ akalakɨlali Jondi. Wun Jon ga sɨŋgɨnmaŋga ta sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herotɨn Jon valaiveve. Wun juŋaveve Jonon balañjɨk anafawali, Gotkɨk wulu ŋaikɨk pavale balañjɨk. Kapekandi wun Jon anafak ga tonmaŋga paveve. Jonon Gotkɨk wulu sivɨlevendi Herotɨn Jonkɨk maŋgɨk bɨiyevekandi wokok kumbaŋɨn towok kambekeve, kape wun yikali yikali bɨiyaŋga mɨlikeve. ");
INSERT INTO kql_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","De, pɨndaŋ Herotiasɨlɨn Jon ga sɨŋgɨnmaŋgapale juñjuŋama kavik yiveve. Herotɨn yetɨk gasak vɨt paveve wokok womelɨn wunu kakeve vandi. Kape katɨk vɨtɨk wokok wakɨndundi matamatkasundi Galilitɨle yila gasak autun yiŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","De, Herotiasɨkɨk alepɨn love gɨŋ sɨlɨveve, kapendi Heroti wokok vɨtɨk yiŋɨmeve balañjun vavalakeve. Kapekandi Herotɨn katɨk aleptɨk kavik sivɨleve, “Dɨn mɨliwale lua ŋunu kombɨiyumfu, ŋɨn masapa.” ");
INSERT INTO kql_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wun galaveve, “Ŋɨn ka galavalaŋapayi. Dɨn gɨtɨk lua gɨtɨk lua kombɨiyalen, ŋɨn masapa. Dɨn ŋakɨk lomɨle yipat yivaŋga mɨliwalen, ŋɨn gɨŋgani vawa dutuk yipat masapa.” ");
INSERT INTO kql_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","De, katɨk alepɨn wokok wometɨk salave kombɨiyeve, “Ŋɨn avik galavapa?” De, wokok womelɨn galaveve, “Jon, katɨk balañju maŋamɨk gaŋga bumbeve balañjɨk, dɨn wokok fop kombɨiyumfu.” ");
INSERT INTO kql_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","De, kepat katɨk alepɨn afɨndafɨnda ŋɨme galaveve Herotɨk, “Ŋɨn kavik mɨliwa, katɨk balañju maŋamɨk gaŋga bumbeve balañjɨk, Jon, dɨn wokok fop kamfu kamfu aŋgatɨk suwɨ masive ŋunutuk.” ");
INSERT INTO kql_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","De, Herotɨn katɨk wulu bɨiyevekandi juŋambɨi juŋambɨiyeve. Kape wun wokok anañ towok sivɨleve wulu juŋaveve. Wun kavɨla vɨtɨk yiŋɨmale balañju mɨmɨlikeve, kapekandi kavɨla wun sivɨleve wulu valambulu gɨlipeve. ");
INSERT INTO kql_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","De, wun yetɨk wunundi tonmale matamat apɨsukuve ga ŋɨmeve Jonkɨk fop matɨpɨtɨwɨ yivaŋga. Katɨk matamatɨn muñjɨmɨk ŋɨmevekandi Jonkɨk fop matɨpɨtɨkeve. ");
INSERT INTO kql_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Matɨpɨtɨwevekandi aŋgɨtɨk suwɨ malaŋmɨ masiveve aleptɨk. De, katɨk alepɨn wokok wometɨk masiveve. ");
INSERT INTO kql_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","De, kavɨla wulu bɨiyevekandi Jonkɨk guŋgundan ŋɨmeve Jon sɨsɨŋgɨn yive malaŋmɨ mandɨveve guamɨk. ");
INSERT INTO kql_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","De, kavɨla Jisasɨlɨn apɨsukuveve 12 balañjun wunutuk yika yiŋɨmevekandi bɨkɨk valan paveve papavandi mfɨtɨtiwɨ sivɨleve wulu Jisasɨtɨk sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","De, balañju gasakamanaŋɨn valatɨk yikali yikali yiŋɨ yiŋɨmeve, kapendi valan jeñjek avik jivapa? De, Jisasɨlɨn wokok guŋgundatɨk kavik sivɨleve, “De, ŋunundi ŋɨme. Amban muñuŋgumbaŋɨk ŋɨmama, yisɨ wuliaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De, valan busuak ŋaikɨk balɨndi muñuŋgumbaŋɨk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Valan ŋɨmevendi yila balañju wusandaŋɨn wule juŋave ŋɨmeve. Wata watatɨle balañju wusandaŋɨn masi jaŋmɨ ŋɨmeve, bɨndefop. ");
INSERT INTO kql_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","De, Jisasɨlɨn alikɨvevekandi wuleve balañjun mfakuŋguŋove mfa. Wulevekandi balambaneve. Wun kavik wuleve valan sipsip fuingo toneve, valan mañjiñjiveve balañjɨkɨn mɨñakɨk. De, wun wulu gasakamanaŋ mfɨtɨtiwɨ sivɨleve, valatɨk. ");
INSERT INTO kql_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kape, de, mfunum, valɨn bumbevendi wokok guŋgundan Jisasɨtɨk ŋɨme sivɨleve, “Kaikalɨn muñuŋgumbaŋ, de, valɨn bumba. ");
INSERT INTO kql_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kavɨla balañju ga ŋɨme veveka mɨtandi watatɨk, bɨkɨk jeñjek ga wusuwaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kape Jisasɨlɨn wokok guŋgundatɨk kavik sivɨleve, “Ben jeñjek masive, valatɨk.” De, valan wunu kombɨiyeve, “Ñen 200 valu tonapale monitɨle breta wusuwapala, valatɨk masive ga jivaŋga?” ");
INSERT INTO kql_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wun valatɨk sivɨleve, “Ben breta akuaŋɨn tonma? Wutvaŋga dalaŋɨme.” Valan ŋɨme wutve balakevekandi yika yiŋɨme sivɨleve, “Ñen ŋaikɨk kɨlik bretandi alawiñ yesiŋa tonma.” ");
INSERT INTO kql_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","De, Jisasɨlɨn kavɨla balañju wofoptɨk kavik galaveve, “Ben gumu gumu yisɨwɨ, anafak vasembaŋɨk.” ");
INSERT INTO kql_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","De, valan gumu gumu yisɨwove, yilan 100 100 yisɨwove, yilan 50 50 yisɨwove. ");
INSERT INTO kql_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","De, Jisasɨlɨn kavɨla ŋaikɨk kɨlik bretandi alawiñ yesiŋa yivevekandi fɨiŋga mataŋmɨ wulevekandi Gotɨk akɨtve kukuñeve. Kukuñevekandi breta pɨtɨwɨ masiveve wokok guŋgundatɨk kavɨla balañjutuk masivaŋgapale. Pavevekandi wun kavɨla alawiñ yesiŋa pɨtɨwɨ masiveve, wofoptɨk. ");
INSERT INTO kql_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kape, de, vala wofopɨn jive balakeve. ");
INSERT INTO kql_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","De, valan yila yisɨŋgalindi breta yila 12 banda yive suwɨ mɨmɨlesekeve. ");
INSERT INTO kql_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","De, 5000 autun katɨk jeñjek jiveve. ");
INSERT INTO kql_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisasɨlɨn wokok guŋgunda balɨnɨk ga valapeve aŋgɨndaŋɨk govaŋga, bɨndefop. Wun Betsaita galavale watɨkɨk ga goveve, vala. Wun wusuak toneve, kavɨla yila balañju bɨkɨk mfututuk ga ŋɨmaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","De, wun kavɨla balañju ga ŋɨme balakevekandi yetɨk lamɨk ŋɨme kɨvevekandi Got kukuñmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","De, katɨk wukan vaŋ, katɨk balɨlɨn maŋamguan gɨŋganɨk toneve. Kape Jisas wusuak siŋasiŋɨk toneve. ");
INSERT INTO kql_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","De, wun kavik wuleve wokok guŋgundan towok yikɨveve, kape gasak vɨvɨlimɨn bɨkɨk mapalatɨk ŋɨmevendi ta yikɨveve. De, valɨtɨk Jisasɨlɨn ŋɨmeve maŋam vɨleki. Wun vala valambe ŋɨmaŋga paveve, ");
INSERT INTO kql_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kape valan maŋam veleki wunu wuleve. Kapekandi sɨŋgɨn mui juŋavevekandi kolekeve. ");
INSERT INTO kql_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vala wofopɨn wunu wule valaiyeve. De, kepat wun valatɨk galaveve, “Ŋunu kasik. Valaivandu! Kumbaŋgi dɨtɨpata tonme.” ");
INSERT INTO kql_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","De, wun valandi balɨni valapevendi katɨk vɨvɨlɨmɨn valambeve. De, valan wutve towok mfulawɨkeve. ");
INSERT INTO kql_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Valan katɨk breta masiveve wulukɨk asɨk mamaŋgoveve. Valan sipɨlavɨt yakakale balañju. ");
INSERT INTO kql_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","De, Jisasɨlɨn wokok guŋgundandi maŋamguan aŋgɨndaŋɨk govevekandi Genesaret galavale mɨtɨk ŋɨme balɨ dɨŋeve. ");
INSERT INTO kql_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dɨŋevekandi balɨ valambe alikɨvevendi kavɨla balañjun wunu wule juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kapekandi valan bɨkɨk mɨta mɨta wofop jaŋɨvekandi malɨwale balañju yiveve. Valan palasuandi malaŋeve malɨwale balañju katɨk Jisasɨlɨn tonmale mɨtɨk anañ bɨiyeve, valan. ");
INSERT INTO kql_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","De, Jisasɨlɨn ŋɨmeve mɨta wofop, wata wofop, gia wata wofop, mia mɨta wofop, valan bɨkɨk malɨwale balañju malaŋmɨ mfelekeve, bɨkɨk makalowale mfanɨk. Valan pavevekandi Jisasɨtɨk galambalambaneve wokok wataŋɨle mfumfut matɨvɨvɨñiŋmaŋga. Wokok wataŋɨle mfumfut matɨvɨvɨñiŋeve balañju wofopɨn bɨkɨk mamalun valambeve. ");
INSERT INTO kql_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","De, yila Farisitɨle* autundi yila Jerusalemɨle Gotkɨk Wulu Kumbaŋgikɨk Balañjun* Jisasɨtɨk mfakuŋguŋove. ");
INSERT INTO kql_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mfakuŋguŋovekandi wuleve Jisasɨkɨk yila guŋgundan jeñjek jiveve, kape bɨkɨk kɨlia yakakale, valan ava andakambe maŋamɨk. ");
INSERT INTO kql_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kavɨla Farisitɨle balañjundi yila Jutatɨle balañjun wofopɨn bɨkɨk kɨlia ka andakambalen jeñjek ka jivapayi. Anañkɨk balañjun masiveve bɨkɨk goŋguaŋmali fulakɨn kavik toneve. ");
INSERT INTO kql_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Valan maket mandɨvale mfanɨk ŋɨme yiŋɨmevekandi, yataŋgɨn ava jive. Valan wandefaka maŋam andakambeve. Bɨkɨk goŋguaŋmali wulu wusandaŋ mɨñakavik vañjeneve. Bɨkɨk wambikasundi susumundi gɨnɨŋgiñe andakambeve.) ");
INSERT INTO kql_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De, kavɨla Farisitɨle balañjundi Gotkɨk Wulu Kumbaŋgikɨk Balañjun Jisasɨtɨk kombɨiyeve, “Dakɨk guŋgundan aipandi anañkɨk balañjun masiveve goŋguaŋmali fulak ava pave? Valan yataŋgɨn jiva, kape bɨkɨk kɨlia yakakale, ava andakambe.” ");
INSERT INTO kql_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","De, Jisasɨlɨn valatɨk galaveve, “Ben velek mapalandi sivɨtvale balañju! Katɨk Aisaia* galavale Gotkɨk maŋgɨk malaŋmɨ sivɨleve balañjɨkɨn bikɨk fulak waiŋgeve galaveve. Anañ anañ wun kavik moleve, ‘Kavɨla balañjun ŋunu maŋgu ŋaikɨkti akɨtva, kape bɨkɨk kumbaŋgin ganaiŋgɨtɨk tonma. ");
INSERT INTO kql_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Valan ŋunu yataŋgɨn ta kukuñma, valan balañjukok mfɨtɨtiwali wulu ŋakɨk wululuŋgo galava.’ ” ");
INSERT INTO kql_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisasɨlɨn Aisaiakɨk wulu kavik galavevekandi wun wusuak yika kavik galaveve, “Ben Gotɨn Masiveve Goŋguaŋmali Fulak pindave kape balañjukok goŋguaŋmali wulu pava. ");
INSERT INTO kql_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ben kavik juŋava, Gotɨn Masiveve Goŋguaŋmali Fulak valambakandi kape anañkɨk balañjukok goŋguaŋmali fulak pava, katɨk anafak, a? ");
INSERT INTO kql_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesɨlɨn* anañ anañ galaveve, ‘Dakɨk waŋdi wome fofonombe.’ Wun miyakavik galaveve, ‘Yetɨk balañjɨkɨn wokok waŋdi wome moŋgopalen, ben katɨk balañjɨk matve ga sɨŋgɨnme.’ ");
INSERT INTO kql_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Kape ben pindavakandi galava yetɨk balañjɨkɨn wokok womendi waŋtɨk masivaŋgapale lua wun anañ galaveve Gotɨk masivaŋga, wun wokok womendi waŋtɨk masivandu. Kakamba. Gotkɨk lua. ");
INSERT INTO kql_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ben mɨñakavik Gotɨn Masiveve Goŋguaŋmali Fulak valambakandi kape anañkɨk balañjun betɨk masiveve goŋguaŋmali fulak ben katɨk pava. Ben mɨñakavik pava yila wulu wusandaŋ.” ");
INSERT INTO kql_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","De, Jisasɨlɨn galaveve yila balañju wunutuk yika mfakuŋgumaŋga. Yiŋɨmevendi wun galaveve, “Ben ŋakɨk wulu bɨiye juŋave. ");
INSERT INTO kql_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tataŋgatɨle yetɨk wosen balañjɨktɨk lovalen katɨk balañjɨkɨn yakatɨk balañjɨk ka tonapayi. Kayi. Balañjɨkɨk kumbaŋɨle wulun salavakandi, kavɨla wulun katɨk balañjɨk yakatɨk balañjɨk ga tonapa.” ");
INSERT INTO kql_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","De, Jisasɨlɨn kavɨla balañju valambevekandi mfotok ŋɨme lovevendi wokok guŋgundan wunutuk ŋɨme kombɨiyeve katɨk mfɨtɨtik sivɨleve wulu. ");
INSERT INTO kql_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","De, wun valatɨk kavik galaveve, “Ben wakan juñjuŋama mɨñakɨk, a? Ben ka juŋavai, a? Tataŋgatɨle yetɨk wosen balañjɨkɨk kumbaŋɨk lovalen katɨk balañjɨkɨn yakatɨk balañjɨk ka tonapayi. ");
INSERT INTO kql_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Katɨk wosen dau ŋaikɨk love salave, kape katɨk balañjɨkɨk juñjuŋamatɨk ka lovapayi.” Jisasɨlɨn kavɨla anañ galaveve wulu galavevendi, de, jeñjekɨn wofopɨn anafawali tonma, Gotkɨk makɨti. ");
INSERT INTO kql_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisasɨlɨn yika kavik galaveve, “Balañjɨkɨk kumbaŋɨle wulun salavakandi, kavɨla wulun katɨk balañjɨk yakatɨk balañjɨk ga tonapa. ");
INSERT INTO kql_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Balañjukok kumbaŋɨle yila yakatɨk juñjuŋamalɨn salava. Kavɨla kavik tonma, mendulak fulak pava, lua fomba, balañju mat mat gaŋga sɨŋgɨnma, wutvɨliwa, yaka wulu yaka wulu pamfuluwa, apɨpɨlaiva, mɨmɨlika mɨñakɨk, mfamuñjuwa, maiyawa, wovene yataŋgɨn malaŋkɨva, kakaŋgɨn. ");
INSERT INTO kql_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kavɨla yaka wulun balañjɨkɨk kumbaŋɨle. Valan katɨk balañjɨk yakatɨk ga tonma.” ");
INSERT INTO kql_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","De, Jisasɨlɨn katɨk watɨk valambe ŋɨmeve Tair galavale siti vevekatɨle mɨtɨk. Wun kaukati yetɨk mfotok loveve, kape wokok safulun pɨmbɨlɨŋmeve, kapekandi wun yila balañjun wunu wutvulu gɨlipeve. Kape wun avik gulipɨliyapa? ");
INSERT INTO kql_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","De, yetɨk melɨn, yetɨk sulak yakakatɨkɨn wokok aleptɨk dundumɨiyeve. Katɨk melɨn bɨiyeve Jisasɨlɨn yiŋɨmeve, kape, de, wun ŋɨmeve Jisasɨkɨk gambiŋgitɨk vandamfufundi amandepewɨ bakti mañjikatɨk mandɨveve. ");
INSERT INTO kql_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Katɨk melɨn yetɨk wutakɨwɨ. Wokok goŋguaŋmali fulakɨn Gris galavale lomɨle, kape wokok wunu kaweve watɨkɨn Sairofonisia galavale distrikɨle. Wun Jisasɨtɨk yiŋɨmevekandi galambalambaneve Jisasɨlɨn wokok alep dundumɨiyeve sulak yakakatɨk sañjaŋmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kape Jisasɨlɨn wunutuk galaveve, “Faklia bɨndefaka ga jive. Fakliakɨk bret yive kindutɨk malipakɨle fulakɨn yakatɨk.” ");
INSERT INTO kql_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kape katɨk melɨn wunutuk sivɨleve, “Gasak Wakɨn, mambat lolomɨle kindun fakliakɨk jeñjek vɨvɨli jiva.” ");
INSERT INTO kql_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","De, Jisasɨlɨn wunutuk kavik galaveve, “Dɨn kavik galavandi, ŋɨn anafak bɨiya, kape dɨn dalaŋɨme. Katɨk sulak yakakatɨkɨn dakɨk alep valambe ŋɨma.” ");
INSERT INTO kql_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","De, katɨk melɨn mfotok ŋɨmevekandi wuleve, wokok alepɨn ñeñembaŋɨk yokowɨ toneve. Katɨk sulak yakatɨkɨn anañ valambe ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","De, Jisasɨlɨn Tair valambe ŋɨmeve Saidon galavale distrikɨk. Kauka valambe ŋɨmeve Dekapolis galavale distrikɨk. Kauka valambe ŋɨmeve Galili galavale maŋamguanɨk. ");
INSERT INTO kql_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","De, valan yetɨk tuandusin balañjɨk Jisasɨtɨk malaŋeve. Wokok belɨn gɨkɨlikeve, wulu waiŋgeve ava sivɨtve. Kape valan Jisasɨtɨk galaveve wokok kɨlik mandɨvaŋga, katɨk balañjɨk anafak ga tonmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","De, Jisasɨlɨn katɨk balañjɨk yive kavɨla yila balañjukok mɨt valambe ŋɨmɨleve. Ŋɨmɨlevekandi wokok kɨliwavi katɨk balañjɨkɨk tuandutuk suwovekandi susupi tulevekandi wokok kɨlik katɨk balañjɨkɨk betɨk mandɨveve. ");
INSERT INTO kql_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","De, Jisasɨlɨn fɨiŋga wunambin gɨvataŋmɨ wulevekandi, sikaiŋevekandi katɨk balañjɨtɨk galaveve, “Efata!” Katɨk wulu amban kavik galava, “Tɨkuaka!” ");
INSERT INTO kql_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","De, kepat wokok tuandun tɨkuakevekandi wokok belɨn anafak tonevekandi wulu waiŋgeve sivɨleve ");
INSERT INTO kql_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","De, Jisasɨlɨn valatɨk galaveve yila balañjutuk sivɨtvandu, kape valan bala pindave sivɨleve. Wun towok apɨkakambe sivɨleve, kape valan Jisasɨkɨk maŋgɨk yika towok bala pindave sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kape, de, kavɨla yila balañjun, bɨkɨk kumbaŋgin towok vaŋ kambekeve, kapekandi galaveve, “Wun wulu wulu wofop waiŋgeve pava. Wun tuandusin balañju wulu ga bɨiya. Wun maŋgɨk miyakɨk balañju wulu ga sivɨtva.” ");
INSERT INTO kql_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","De, yetɨk vandi yila balañjun wusandaŋ mfakuŋguŋove, kape valan jeñjekɨn mɨñakɨk. Kape, de, Jisasɨlɨn wokok guŋgunda kañiŋmɨ ga yiŋɨmevekandi galaveve, ");
INSERT INTO kql_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ŋɨn kavɨla balañju balambanma. Valan valu alilam tonmale, kape jeñjekɨn mɨñakɨk. ");
INSERT INTO kql_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋɨn vala yataŋgɨn gunaŋa apɨsukuvalen bɨkɨk mfututuk, yilan gunaŋaka masi sɨŋgɨnapati. Yilan ganaiŋgati yiŋɨmale.” ");
INSERT INTO kql_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","De, wokok guŋgundan wunutuk galaveve, “Kaikalɨn muñuŋgumbaŋ, jeñjek miyakɨk mɨt. Amba breta akati yivapa kavɨla balañju ga jivaŋga?” ");
INSERT INTO kql_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wun valatɨk kombɨiyeve, “Ben breta akuaŋ?” Valan galaveve, “7 breta.” ");
INSERT INTO kql_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","De, Jisasɨlɨn galave mañjikatɨk ga yisɨwove, kavɨla balañju. Wun kavɨla 7 breta yivevekandi Gotɨk akɨtve kukuñevekandi pɨtɨwɨ masiveve wokok guŋgundatɨk, kavɨla yila balañjutuk ga masivaŋga. De, valan kavɨla balañjutuk masiveve. ");
INSERT INTO kql_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","De, valan yila sa yesiŋa toneve, ŋaikɨle. Wun Got akɨtve galavevekandi kavɨla yesiŋa ga masiveve, miyakavik. ");
INSERT INTO kql_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Valan jeñjek jive mamalasewɨ balawɨ, valambeve makandu 7 bandatɨk yive suwɨ mamalasekeve. ");
INSERT INTO kql_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kavɨla balañjun 4,000-iŋgo toneve. ");
INSERT INTO kql_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","De, Jisasɨlɨn vala apɨsukuve ga ŋɨmevekandi wun wokok guŋgundandi yetɨk balɨni valape aŋgɨndaŋɨk goveve Dalmanuta galavale distrikɨk. ");
INSERT INTO kql_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","De, yila Farisitɨle* autun Jisasɨtɨk yiŋɨmeve wunundi towok bala sivɨleve. Valan wunu apɨpɨlayeve, yetɨk ga juŋavaŋgapale gasak pɨtɨkie wulu wunutuk ga pavaŋga. Valan yila wulu wokok safutuk mandɨve sivɨtvaŋga juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","De, Jisasɨlɨn wokok kumbaŋɨn saŋmɨkɨ apɨwoselevekandi kavik galaveve, “Kamfu tonmale balañjun ga juŋavaŋgapale gasak pɨtɨkɨle wulu aipandi wulaŋga mɨliwa? Ŋɨn wulu vaŋu betɨk sivɨtva, valan ka wulapayi. Ŋɨn vala ga wutvaŋga ka pavapayi.” ");
INSERT INTO kql_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","De, wun vala valambe ŋɨmevekandi balɨnɨk yika valapevekandi aŋgɨndaŋɨk goveve. ");
INSERT INTO kql_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","De, Jisasɨndi wokok guŋgundan bret gɨnanambe valambe ŋɨmeve. Ŋaikɨk bret ŋaikɨkɨn balɨ kumbaŋɨk toneve. ");
INSERT INTO kql_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","De, Jisasɨlɨn valatɨk kavik galaveve, “Ben waiŋgeve, Farisitɨle* autukok yisndi Herotkɨk* autukok yis. Ben waiŋgeve.” ");
INSERT INTO kql_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wokok guŋgundan bɨkɨk gumi wokok sivɨleve wulu sivɨt pɨiyeve. Valan kavik sivɨleve, “Amban bretɨn mɨñakɨk.” ");
INSERT INTO kql_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisasɨlɨn valan sivɨleve wulu juŋavevekandi sivɨleve, “Ben aipandi bretɨn miyakɨk tonmale wulu sivɨtva? Ben ka juŋavi, a? Bikɨk kumbaŋgi ava tɨkuakɨka? Bikɨk juñjuŋamalɨn apɨvɨtɨpalia? ");
INSERT INTO kql_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ben sɨpalakɨk, kape ka wuti, a? Ben tuandukok, kape ka bɨsi, a? Ben gɨnanambale, a? ");
INSERT INTO kql_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ŋɨn bret ŋaikɨk kɨlik pɨtɨk pɨliŋevekandi 5,000 balañjukok, jive gɨpɨive valambeve bretandi ben akuaŋ banda suwove?” Valan wunutuk sivɨleve, “12.” ");
INSERT INTO kql_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisasɨlɨn valatɨk yika galaveve, “Ŋɨn bret 7 pɨtɨk pɨliŋevekandi 4,000 balañjukok, jive gɨpɨive valambeve bretandi ben akuaŋ banda suwove?” Valan wunutuk sivɨleve, “7.” ");
INSERT INTO kql_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wun valatɨk galaveve, “Ben ka juŋavi, a?” ");
INSERT INTO kql_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","De, Jisasɨndi wokok guŋgundan Betsaita galavale watɨkɨk apɨsalave ŋɨmeve. Apɨsalave ŋɨmevendi katɨk watɨkɨle balañjun wunutuk malaŋeve yetɨk sɨpala yakakalekɨk balañjɨk. Valan wunu galambalambaneve Jisasɨlɨn wunutuk kɨlik mandɨvaŋga. ");
INSERT INTO kql_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kape Jisasɨlɨn wokok kɨlik mfovevekandi wunu watɨk kutuk malaŋeve. Malaŋevekandi wokok sɨpalatɨk susupi tulevekandi kɨlia wunutuk mandɨvevekandi kavik kombɨiyeve “Dɨn yila lua wutvala?” ");
INSERT INTO kql_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","De, wun wutve wulevekandi kavik galaveve, “Ŋɨn balañju wutva, kape muŋaŋgo ŋɨmakatɨk wutva.” ");
INSERT INTO kql_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","De, Jisasɨlɨn wokok kɨlia katɨk balañjɨkɨk sɨpalatɨk yika mandɨveve. Mandɨvevendi katɨk avɨtɨn towok jɨlevekandi, de, tɨkuakave, wun waiŋgeve wuleve, lua wofop. ");
INSERT INTO kql_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","De, Jisasɨlɨn wokok mfotok apɨsukuve ga ŋɨmeve. Wun kavik galaveve, “Dɨn watɨkɨk apɨsalavandu.” ");
INSERT INTO kql_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","De, Jisasɨlɨn wokok guŋgundandi yila watatɨk ŋɨmeve. Sisaria Filipai galavale siti vevekatɨk tonmale kavɨla. Valan mai ŋɨmevekatɨk wun wokok guŋgundatɨk kombɨiyeve, “Yila balañjun ŋunu nani galava?” ");
INSERT INTO kql_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Valan wunutuk galaveve “Yilan galava Jon, katɨk maŋamɨk ga bumbale fak. Yilan galava Elaija*. Kape yilan galava yetɨk Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨk.” ");
INSERT INTO kql_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kape wun vala yika kombɨiyeve, “Ben ŋunu nanifak galava?” De, Pitalɨn kavik galaveve, “Dɨn Krais tonma, katɨk Gotkɨk Balañju Yika Yivaŋgapale Balañjɨk.” ");
INSERT INTO kql_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","De, wun vala apɨkakambeve, valan katɨk wun Krais tonmale wulu sivɨtvandu yila balañjutuk. ");
INSERT INTO kql_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","De, Jisasɨlɨn valatɨk yila wulu mfɨtɨtiwɨ sivɨleve. Kavɨla wulu kavik tonma, yila balañjun yaka wulu wusandaŋ Balañjɨkɨk Faktɨk* pavapa, kape, de, wokok safulun towok akalakapa. Jutatɨle avɨtkasundi Gasak Wamɨle Gasak Wakundundi*Gotkɨk Wulu Kumbaŋgikɨk Balañjun* wunu beŋgoŋapa. Kape valan wunu matve ga sɨŋgɨnapa. Kape aliluaŋgɨk vandi yika kambekapa. ");
INSERT INTO kql_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wun kavɨla wulu matɨsivaŋmɨ sivɨleve. Kape, de, Pitalɨn wun malaŋevekandi vavawɨ sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","De, Jisasɨlɨn matɨyokolowovekandi wokok yila guŋgunda wuleve. Wun Pita mɨñakavik vavawɨ sivɨleve, “Satan*, dɨn avave! Ŋɨn du wutvulu gɨlipa! Dɨn Gotkɨk juñjuŋama ka vañjenmi! Dɨn balañjukok juñjuŋama ŋaikɨk vañjenma!” ");
INSERT INTO kql_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","De, Jisasɨlɨn ga yiŋɨmevekandi wokok guŋgundandi yila balañju wusandaŋ. Wun valatɨk kavik sivɨleve, “Yetɨk balañjɨkɨn ŋunu vañjenme ŋɨmaŋga mɨliwalen, woven mɨliwale juñjuŋama ga valambe, kape wokok mamatawi muŋ ga afufulive malaŋmɨ ŋunu vañjenme. ");
INSERT INTO kql_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yetɨk balañjɨkɨn wovene wovene kamfu kamfu kasik mañjikatɨk alilekalak tonmaŋgapale wulu gasak wulu vaŋ juŋava. Kavik juŋavale balañjɨkɨn sɨŋgɨnapa. Kape yetɨk balañjɨkɨn kavik ka juŋavi. Wun wokok woven tonmaŋgapale wulu gasak we ka galavi. Wun ŋunundi Gotkɨk wulu anafu malaŋkɨve juŋava, kapekandi sɨŋgɨnma. Kavik juŋavale balañjɨkɨn alilekalak tonŋɨmama. ");
INSERT INTO kql_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yetɨk balañjɨkɨn lua wofop vaŋ wofop yiva, kapekandi sɨŋgɨnmalen, kavɨla luan wunu anafak avik ga tonapa? ");
INSERT INTO kql_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Katɨk balañjɨkɨn woveñe woveñe gɨtɨk luandi wusukapa, alilekalak yika tonmaŋga? ");
INSERT INTO kql_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kamfu tonmale yakakale balañjun, Got valambale balañjun, betɨle yetɨk balañjɨkɨn ŋunundi ŋakɨk wulu mɨmɨliwɨ ŋaŋalambalen, Balañjɨkɨk Fakɨn, wokok wun yiŋɨmale vandi, wun mɨñakavik mɨmɨliwɨ ŋaŋalambapa katɨk balañjɨk. Balañjɨkɨk Fakɨn katɨk vandi wokok Waŋkɨk gasak pɨtɨkti valɨŋgo apɨkowɨ yiŋɨmama Gotkɨk anafawali luasamban sulundi.” ");
INSERT INTO kql_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisasɨlɨn valatɨk kavik galaveve, “Ŋɨn wulu vaŋu betɨk sivɨtva, kaikatɨk sambɨtve tonmale yila balañjun kavik wulapa, Gotɨn gasak pɨtɨkɨk Juwutkasak tonapa. Wandefaka ka sɨŋgɨnapayi, yilan.” ");
INSERT INTO kql_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","De, valu 6 vandi, Jisasɨlɨn Pitandi Jemsɨndi Jon ŋaikɨk yive malaŋɨve, yetɨk lam wunambin vaŋɨk. Kaukatɨk valan bɨsak tonevekandi wuleve yetɨk fulakɨn wunutuk apɨsalavevendi kape wun yindaŋdi toneve. ");
INSERT INTO kql_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wokok wataŋu towok vavaivɨkɨve, towok vaŋ kɨliavɨkɨve. Kasik mañjikatɨle yetɨk balañjɨkɨn wokok wataŋu avik ga kɨliavɨkapa, kavik. ");
INSERT INTO kql_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","De, wokok guŋgundan kavik wulevekatɨk Elaijandi*Mosesɨlɨn* pɨlekɨvalaŋevekatɨk wuleve valan. Pɨlekɨvalaŋevekandi Jisasɨndi wulu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kape, de, Pitalɨn Jisasɨtɨk kavik sivɨleve, “Watpalaŋ, amban kaikatɨk tonma anafak. Ñe kakalak mfutu alilam ga gɨve, dakɨk yetɨk, Mosesɨkɨk yetɨk, Elaijakɨk yetɨk.” ");
INSERT INTO kql_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kavɨla guŋgundan towok valaiyevendi Pitalɨn kavik galaveve. ");
INSERT INTO kql_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","De, yetɨk yaŋgɨmɨn ŋɨme vala tɨmbevendi yaŋgɨm kumbaŋñi yetɨk maŋgɨkɨn kavik sivɨleve, “Ŋakɨk towok mɨliwale fakɨn kasik. Ben wunu bɨiye.” ");
INSERT INTO kql_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Valan kepat ta maiyokolok mfɨiyokolokevekandi Jisas ŋaikɨk wuleve valan. ");
INSERT INTO kql_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","De, lam bumbevekandi sivɨlɨmeve Jisasɨlɨn. Katɨk valan wuleve wulu apɨkakambe sivɨleve. Wun kavik sivɨleve, “Kamfu ben wutvale wulu sivɨtvandu. Balañjɨkɨk Fakɨn sɨŋgɨnme kambekuakɨle vandi pɨndaŋ matɨsivaŋmɨ sivɨtvumfu.” ");
INSERT INTO kql_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kavɨla wulun bɨkɨk kumbaŋgi ŋaikɨktɨk tonŋɨlali. Kape valan bɨvene bɨvenetɨk kombɨi kombɨi sivɨt pɨiyeve. Katɨk sɨŋgɨnme kambekuakɨle wulu sivɨt pɨiyeve, valan. ");
INSERT INTO kql_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Valan wunutuk kavik kombɨiyeve, “Gotkɨk Wulu Kumbaŋgikɨk Balañjun* aipandi galava Elaijalɨn wandefaka yiŋɨmama?” ");
INSERT INTO kql_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","De, wun valatɨk kavik sivɨleve, “Kavik tonma. Elaijalɨn wandefaka yiŋɨmama wulu wofop waiŋgeve mfavɨliñjiwaŋga pave. Kape Gotkɨk Buk kumbaŋɨle wulu aipava? Kavik moleve, Balañjɨkɨk Fakɨn yakai yakai tonapa, kape yila balañjun wunu maiyakapa. ");
INSERT INTO kql_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kape ŋɨn kavik galava, Elaijalɨn anañ yiŋɨmeve. Yila balañjun wunutuk bɨkɨk juñjuŋamandi paveve. Gotkɨk buk kumbaŋɨle anañ moleve wulu miyakavik paveve, valan.” ");
INSERT INTO kql_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","De, Jisasɨlɨn Pitandi Jemsɨndi Jonɨndi wokok yila guŋgundatɨk yiŋɨmevekandi wuleve, valatɨk mfakove toneve gum. Katɨk gum kumbaŋɨle yila Gotkɨk Wulu Kumbaŋgikɨk Balañjun* valandi wulu sivɨt pɨiyeve. ");
INSERT INTO kql_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","De, kavɨla gumɨle balañjun wofopɨn Jisas wulevekandi bɨkɨk kumbaŋgin kepat kambekeve. Valan wunu wutve jaŋevekandi wunu wutve vavalawa galaveve, “Anafak yiŋɨma!” ");
INSERT INTO kql_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wun valatɨk kombɨiyeve, “Ben gɨtɨk wulu sivɨt pɨiya?” ");
INSERT INTO kql_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","De, katɨk gum kumbaŋɨle yetɨk balañjɨkɨn galaveve, “Watpalaŋ, ŋakɨk fak yetɨk sulak yakakatɨkɨn dundumɨive maŋgɨk miyakɨk ga tonma, kapendi ŋɨn dutuk malaŋma. ");
INSERT INTO kql_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Katɨk sulak yakakatɨkɨn dundumɨivendi wun gapakandi suapɨn salava mamaliŋñi kapekandi ŋandu lɨkɨtɨwa safulun pektaŋmuwa. Ŋɨn dakɨk guŋgundatɨk ga sañjaŋmaŋga ta kombɨiya. Valan ka balawɨ.” ");
INSERT INTO kql_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","De, Jisasɨlɨn valatɨk kavik galaveve, “Ben kamfu tonmale balañju. Ben Gotkɨk wulu yive susuka mɨñakɨk balañju. Ŋɨn bendi akuaŋ valu tonapa? Ŋɨn valu valu be ta mfɨtɨti mfɨtɨti sivɨtvale. Ben ka juŋavi, a? Ŋɨn valu akuaŋ kavik pavapa, betɨk? Katɨk fak ŋunutuk malaŋmɨ!” ");
INSERT INTO kql_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","De, valan wunu Jisasɨtɨk malaŋevendi katɨk sulak yakakatɨkɨn Jisas wulevekandi katɨk fak ga gapeve. Katɨk fakɨn mañjikatɨk kukumukevekandi asokopekevendi suapɨn salaveve mamaliŋñi. ");
INSERT INTO kql_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","De, Jisasɨlɨn katɨk fakɨk waŋtɨk sivɨleve, “Valu akuaŋ kavik toneve?” Wun galaveve, “Sawekatɨk mandɨvɨleve, wun. ");
INSERT INTO kql_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yila valu katɨk sulak yakakatɨkɨn mɨndatɨk gaŋga kumukeve yila valu maŋambitɨk gaŋga kumukeve, wunu ga sɨŋgɨnmaŋga pave. Kape dɨn balawalen, ñe balambanmakandi matɨkokolewɨ.” ");
INSERT INTO kql_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisasɨlɨn wunutuk sivɨleve, “Dɨn aipandi galava ‘Dɨn balawalen’? Yetɨk balañjɨkɨn kavik juŋavalen, ‘Gotɨn balawa,’ de, katɨk balañjɨkɨn balakapa wulu wulu wofop pavaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","De, kepat katɨk fakɨk waŋɨn galaveve, “Ŋɨn kavik juŋava! Ŋɨn ta juŋavale daŋ waiŋgeve ga juŋave.” ");
INSERT INTO kql_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","De, Jisasɨlɨn wulevekandi yila balañjun wusandaŋ jaŋmɨ mfakuŋgumove, wun katɨk sulak yakakatɨkɨk apɨkakambe sivɨleve, “Dɨn, maŋgɨk ga valambalendi tuandu sin ga tonmale sulak, ŋɨn du apɨkakambe sivɨtva, wunu valambe dalaŋɨme. Wunutuk yika dundumɨivaŋga yiŋɨmandu.” ");
INSERT INTO kql_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","De, katɨk sulakɨn ga kolewɨ gapevekandi wunu valambe ŋɨmeve. Kape katɨk fakɨn sɨsɨŋgɨn vaŋɨŋgo toneve. Mɨñakavik wulevekandi balañjun wusandaŋɨn sivɨleve, “Wun anañ sɨŋgɨnmale.” ");
INSERT INTO kql_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kape Jisasɨlɨn wokok kɨlikɨk mfove mfakambekevendi wun kambewɨ sambɨleve. ");
INSERT INTO kql_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","De, Jisasɨlɨn wokok guŋgundandi vala valambe ŋɨme loveve yetɨk mfotok. Valan bɨsak tonevekandi Jisasɨtɨk kavik kombɨiyeve, “Ñen aipandi katɨk sulak yakakatɨk sañjaŋmaŋga ta pava?” ");
INSERT INTO kql_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wun valatɨk kavik galaveve, “Kavik tonmale sulun ŋaikɨk fulakɨn ŋaikɨkɨn tonma, sañjaŋmaŋgapale, ambɨkɨk Waŋ kukuñmalen, balakapa.” ");
INSERT INTO kql_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","De, Jisasɨlɨn wokok guŋgundandi katɨk mɨt valambe ŋɨmeve. Valan Distrik Galili ŋɨŋawɨ ŋaikɨndi ŋɨmeve. Jisasɨlɨn wokok guŋgundantɨk yila mfɨtɨtiwale wulu sivɨtvaŋga mɨlikeve, kapekandi yila balañjutuk wunu ga wutve juñjuŋawulu gɨlipeve. ");
INSERT INTO kql_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wun wokok guŋgunda kavik mfɨtɨtikeve yetɨk balañjɨkɨn Balañjɨkɨk Fak* kɨndɨŋmɨ suwapa yila mamatutuk. Valan wunu matve ga sɨŋgɨnapa. Matve ga sɨŋgɨnmindi wun alilaŋgɨk vandi yika kambekapa. ");
INSERT INTO kql_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wokok Guŋgundan wokok wulu mamaŋguve kape kombɨiyulu valaiyeve. ");
INSERT INTO kql_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","De, Jisasɨlɨn wokok guŋgundandi Kaperneam galavale watɨk apɨsalave ŋɨmevekandi mfotok ŋɨme loveve. Lovevendi Jisasɨlɨn wokok guŋgundatɨk kombɨiyeve, “Masi ŋɨmakandi ben gɨtɨk wulu sivɨlɨma?” ");
INSERT INTO kql_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kape valan wulu mɨñakɨk. Valan masi ŋɨmevekandi vala gɨŋgani nan gasak tonapale wulu sivɨlɨmeve bɨvene bɨvenetɨk. ");
INSERT INTO kql_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kape, de, Jisasɨlɨn yisɨkevekandi gave ga yiŋɨmeve, wokok 12 guŋgunda. Yiŋɨmevendi valatɨk kavik sivɨleve, “Yetɨk balañjɨkɨn gasak vaŋ tonmaŋga mɨliwalen, wovene wovene mañjika vaŋɨk malaŋbumbe yila balañju wofopkɨk luasamban tonme.” ");
INSERT INTO kql_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","De, Jisasɨlɨn yetɨk fakliak yive mfapiŋgapeve bɨkɨk gɨŋganɨk. Wun mamatawuwɨ tonevekandi valatɨk kavik galaveve, ");
INSERT INTO kql_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yetɨk balañjɨkɨn ŋunu juŋavalen kapekandi yetɨk kavik tonmale fak matɨkokolewalen, wun ŋunu matɨkokolewa. Mɨñakavik yetɨk balañjɨkɨn ŋunu matɨkokolewalen wun ŋunutuk ka pavi. Kayi. Wun ŋakɨk ŋunu apɨsukuve ga yiŋɨmale Waŋ matɨkokolewa.” ");
INSERT INTO kql_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","De, Jonon Jisasɨtɨk galaveve, “Watpalaŋ, ñen dakɨk wuŋdi sulak yakakale sañjaŋmale balañjɨk wutvale. Wun amba ava vañjenme kapendi ñen wunu apɨkakambale.” ");
INSERT INTO kql_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kape Jisasɨlɨn kavik galaveve, “Wunu apɨkakambandu. Yetɨk balañjɨkɨn ŋakɨk wuŋdi gasak pɨtɨkie wulu pavalen, wun kamfu kamfu ŋunu avik maiyakapa? ");
INSERT INTO kql_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ambatɨk yakavik ka pavale balañjɨkɨn ambatɨk anafak pava. ");
INSERT INTO kql_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yetɨk balañjɨkɨn juŋavalen ben Kraistɨle*, kapekandi wun ŋaikafak miña maŋam betɨk masiva, ŋɨn wunutuk anafak pavapa. Ŋɨn wulu vaŋu betɨk sivɨtva, ŋɨn wokok anafak fulak yataŋgɨn ka valambapayi.” ");
INSERT INTO kql_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisasɨlɨn kavik galaveve, “Yila faklian ŋakɨk wulu yive suwapa. Yetɨk balañjɨkɨn kavik tonmale fak ŋakɨk wulu ga valambalen, wun yakai yakai vaŋ tonapa. Yila balañjun wandefaka katɨk balañjɨk yetɨk gasak mɨndɨm wokok bɨŋbatɨk dɨŋmakandi gia maŋamguanɨk yukuakɨ ga ŋɨlɨwalen, valan anafak pava wunutuk. Ŋɨlɨwale fulakɨn yakai yakai vaŋ gaveka. Yetɨk balañɨkɨn safakliak pave ŋunu ga valambalen, ŋɨn yakakatɨk vaŋ wunutuk papa. ");
INSERT INTO kql_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kape, de, dakɨk yetɨk kɨlikɨn yakakatɨk fulak pavalen, kapendi dɨn miyakavik yakakatɨk fulak paviŋgi, de, dɨn dakɨk kɨlik matɨpɨtɨkumfu. Dɨn Wunambinɨk ŋaikɨk kɨlikti ŋɨmalen, dɨn anafak tonapa. Kape dɨn alawiñ kɨliandi Heltɨk ŋɨmalen, dɨn yakai yakai vaŋ tonapa. Heltɨle mɨnɨn kusimbeve mɨn gaveka. ");
INSERT INTO kql_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Dakɨk yetɨk gambaŋɨn yakakatɨk fulak pavalen, kapendi dɨn miyakavik yakakatɨk fulak paviŋgi, dɨn dakɨk gambaŋ matɨpɨtɨkumfu. Ŋaindaŋ gambaŋdi Wunambinɨk ŋɨmalen, dɨn anafak tonapa. Kape dɨn Heltɨk gambiŋgi alawindi ŋɨmalen, dɨn yakai yakai vaŋ tonapa. ");
INSERT INTO kql_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dakɨk yetɨk sɨkɨlɨn yakakatɨk fulak pavalen, kapendi dɨn miyakavik yakakatɨk fulak paviŋgi, dɨn dakɨk sɨkɨ dɨkumfu. Dɨn Gotkɨk watɨkɨk ŋaindaŋ sɨkɨndi ŋɨmalen, dɨn anafak tonapa. Kape dɨn Heltɨk sɨpala alawiñdi ŋɨmalen dɨn yakai yakai vaŋ tonapa. ");
INSERT INTO kql_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Heltɨle mfumfundan ka sɨŋgɨnapayi. Mɨñakavik Heltɨle mɨnɨn ka kusimbapayi. ");
INSERT INTO kql_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mɨnɨk apɨkuwapa balañju wofoptɨk sota mfafɨlewalɨŋgo. ");
INSERT INTO kql_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sotan anafak. Kape sotan sotaŋgo ka gɨŋgɨliŋmalen, dɨn avik pave yika anafak ga tonapa? Bikɨk kumbaŋgi sotaŋgo ga gɨŋgɨliŋmɨkaŋga, kapekandi bivene bivenendi ka ŋɨliwa.” ");
INSERT INTO kql_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","De, Jisasɨlɨn wokok guŋgundandi Kaperneam valambe ŋɨmeve Distrik Jutatɨk Jordan maŋamguan aŋgɨndaŋɨk. De, balañjun wusandaŋɨn yika wunutuk mfakaŋguŋove. Kape, de, wun wokok fulak kavik paveve, wun valatɨk yila wulu mfɨtɨtiwɨ sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","De, yila Farisitɨle* autun wunutuk yiŋɨme wunu muwɨ dɨpikape kombɨiyeve, “Gotɨn Masiveve Goŋguaŋmali Fulakɨn* kavik galavala, yetɨk avɨtɨn wokok me apɨtomoñmaŋga pavale fulakɨn anafak, a?” ");
INSERT INTO kql_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisasɨlɨn kavik galaveve, “Anañ anañ Mosesɨlɨn* ambɨkɨk anañ toneve wuŋgasutɨk gɨtɨk wulu sivɨleve?” ");
INSERT INTO kql_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Valan kapendi kavik galaveve, “Mosesɨlɨn galaveve yetɨk avɨtɨn wokok me apɨtomoñmaŋga pavalen katɨk avɨtɨn wokok me apɨtomoñmaŋgapale janda motve masive wokok metɨk.” ");
INSERT INTO kql_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","De, Jisasɨlɨn valatɨk kavik galaveve, “Ben wulu pindavale balañju, kapendi Mosesɨlɨn katɨk ŋaikɨk wulu betɨk motve masiveve. ");
INSERT INTO kql_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kape anañ anañ vaŋ Gotɨn yila wulu galaveve. Gotɨn lua wofop mandɨvevekandi, wun balañju mañjikatɨk gotve mandɨveve. Avɨti me mandɨveve, wun. ");
INSERT INTO kql_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gotɨn kavik paveve, kapekandi wun ambatɨk kasik fulak masiveve. De, yetɨk avɨtɨn wokok waŋdi wome valambakandi wokok me yivpa. ");
INSERT INTO kql_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yivakandi valan alawiñɨñ ŋaikɨk safu tonapa. Valan alawiñɨñ gaveka. Kayi. Ŋaikɨk balañjɨkɨŋgo tonapa. ");
INSERT INTO kql_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kape, de, Gotɨn anañ mfakuŋove balañju, yetɨk balañjɨkɨn apɨtomoñmandu.” ");
INSERT INTO kql_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","De, Jisasɨndi wokok guŋgundan mfotok ŋɨmevendi wokok guŋgundan katɨk wun anañ sivɨtvale me apɨtomoñmale wulu yika kombɨiyeve. ");
INSERT INTO kql_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kapendi wun valatɨk galaveve, “Yetɨk avɨtɨn wokok me apɨtomoñme yetɨk me yivalen, wun mendulak fulak pava. Wun wunutuk yakai yakai pava. ");
INSERT INTO kql_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Miyakavik yetɨk melɨn wokok malat apɨtomoñme yetɨk malat yivalen, wun miyakavik mendulak fulak pava.” ");
INSERT INTO kql_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","De, yila balañjun faklia Jisasɨtɨk malaŋmaŋga paveve, wun vala mfovaŋga. Kape wokok guŋgundan vala apɨkakambe galaveve. ");
INSERT INTO kql_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisasɨlɨn kavik wulevekandi gɨlipe valatɨk kavik sivɨleve, “Faklia ŋunutuk ga yiŋɨme. Apɨkakambe sivɨtvandu. Gotkɨk lomɨle balañjun kavik tonmale balañju. ");
INSERT INTO kql_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ŋɨn wulu vaŋu betɨk sivɨtva, yetɨk balañjɨkɨn Got lolom tonmaŋga sa fakliakiŋgo ka vavalawalen wun Gotkɨk watɨk avik lovapa? Kayi vaŋ.” ");
INSERT INTO kql_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kape, de, Jisasɨlɨn kavɨla faklia mamatawuwo kɨlia valatɨk mandɨve kukuñeve, Gotɨn valatɨk wulu anafu ga pavaŋga. ");
INSERT INTO kql_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","De, Jisasɨlɨn yetɨk mɨtɨk ŋɨmevekatɨk yetɨk avɨtɨn wunutuk jaŋmɨ yiŋɨmevekandi vandamfufu mañjikatɨk mandɨvevekandi kombɨiyeve, “Watpalaŋ Anafawali. Ŋɨn avik pave Gotki tonŋɨmama siŋambamavi?” ");
INSERT INTO kql_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisasɨlɨn wunutuk kavik sivɨleve, “Dɨn ŋunutuk aipandi anafawali galava. Got ŋaikɨkɨn tonma anafawali. ");
INSERT INTO kql_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dɨn aipandi kombɨiya? Dɨn Gotɨn Masiveve Goŋguaŋmali Fulak* juŋava, ‘Balañjɨk mat mat gaŋga sɨŋgɨnmandu. Mendulak Pavandu. Yetɨk balañjɨkɨk we fombandu. Balañjɨkɨk safutuk muwale wulu mandɨve sivɨtvandu. Muwɨ apɨpɨlaive yivandu, yetɨk balañjɨkɨk we. Waŋdi wome waiŋgeve fofonombe.’ ” ");
INSERT INTO kql_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","De, katɨk avɨtɨn Jisasɨtɨk sivɨleve, “Watpalaŋ, ŋɨn sawekatɨk mandɨvɨli miyakavik kavɨla wulu ŋaikɨk juŋave paŋɨlali.” ");
INSERT INTO kql_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisasɨlɨn wunu wulevekandi towok mɨlikevekandi kavik sivɨleve, “Dɨn yetɨk ŋaikɨk fulak ava pave. Dɨn dakɨk lua yila balañjutuk ga wusuwɨ. Yivale moni miña balañjutuk yataŋgɨn masive. Kavik pavakandi dɨn lua wusandaŋ Hevenɨk tonapa. Kape, ŋɨme. Ŋunu vañjenme ŋɨme.” ");
INSERT INTO kql_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Katɨk maŋgɨk bɨiyevekandi baŋgaivɨkɨ ŋɨmeve. Wokok lua gasakamanaŋ toneve. ");
INSERT INTO kql_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","De, Jisasɨlɨn wokok guŋgundatɨk wutve sivɨleve, “Lua wusandaŋ tonmale balañjun Got lolomɨk tonmaŋga ta mandɨmbɨi mandɨmbɨiapati.” ");
INSERT INTO kql_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wokok guŋgundan wokok wulu bɨiyevekandi bɨkɨk kumbaŋgin kambekeve. Kape Jisasɨlɨn yika sivɨleve, “Wufakali. Balañjun Gotkɨk lolomɨk tonmaŋga ta mandɨmbɨi mandɨmbɨiapati. ");
INSERT INTO kql_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gaŋgɨikɨk fopɨle guanɨk kameltɨn love salavakalen ka balakaŋgale. Miyakavik lua wusandaŋ tonmale yetɨk balañjɨkɨn Gotkɨk watɨk avik lovapa. Kape katɨk lua towok tonmale balañjɨkɨn Gotkɨk watɨk ta lovale wulun kameltɨn gaŋgɨikɨk fopɨle guanɨk love salavale wulu matɨkakalɨwa.” ");
INSERT INTO kql_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wokok guŋgundan kavik bɨiye towok pɨkɨliye kombɨiyeve Jisasɨtɨk, “Miyakavik tonmalen, nan Gotki tonŋɨmama siŋambamavi?” ");
INSERT INTO kql_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisasɨlɨn vala wutve sivɨleve, “Balañjun avik? Kape Gotɨn balakapa. Wun pava wulu wulu wofop.” ");
INSERT INTO kql_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","De, Pitalɨn wunutuk galaveve, “Wutve, ñen lua wofop valambevekandi vañjenma, du.” ");
INSERT INTO kql_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","De, Jisasɨlɨn sivɨleve, “Ŋɨn wulu vaŋu betɨk sivɨtva, yetɨk balañjɨkɨn ŋunu vañjenme mɨliwakandi wokok mfoti wuŋgiaki wuiñaŋdi wufakandi avɨti samindi waŋdi womendi mañjikandi faklia valambalen ŋunundi Gotkɨk wulu anafu vañjenmaŋga, ");
INSERT INTO kql_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wun kamfu watɨk tonmale vandi 100 mfutundi wufakalindi samilundi womeandundi fakliandi mañjika yivapa. Kape yila balañjun yaka wulu wunutuk papa. Kape wun pɨndaŋ siŋambamavi tonŋɨmama Gotki. ");
INSERT INTO kql_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kape yila wusandaŋ kamfu gasak tonmale balañju Gotɨn malaŋbumbapa. Kape yila wusandaŋ wuŋa miyakɨk tonmale balañju Gotɨn malaŋkɨvapa.” ");
INSERT INTO kql_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","De, Jisasɨlɨn wokok guŋgundandi yila balañjundi Jerusalemɨk masi ŋɨmeve. Jisasɨlɨn wandefop ŋɨmeve. Valan pɨndaŋɨle balañjun veven juŋavevekandi valaiyeve. Mai kamfu ŋɨmevekandi Jisasɨlɨn wokok guŋgunda yive sivɨlɨmeve wunutuk pɨndaŋ pavaŋgapale papawa. ");
INSERT INTO kql_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wun kavik sivɨleve, “Bɨiye. Amban Jerusalemɨk ŋɨma. Yetɨk balañjɨkɨn Balañjɨkɨk Fak* kɨndɨŋmɨ suwapa Gasak Wamɨle Gasak Wakundundi*Gotkɨk Wulu Kumbaŋgikɨk Balañjutuk*. Valan wunu ga sɨŋgɨnmaŋgapale wulu sivɨtve tɨmbapa. Kapekandi wunu masivapa wutatɨk. ");
INSERT INTO kql_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kavɨla wutan wunu maiyawakandi susupi tulakandi towok paiyakandi matve ga sɨŋgɨnapa. Matve ga sɨŋgɨnmindi wun alilaŋgɨk vandi yika kambekapa.” ");
INSERT INTO kql_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepatikɨk fun, Jemsɨndi Jon, valan Jisasɨtɨk ŋɨme kombɨiyeve, “Watpalaŋ, ñen kombɨiyale wulu dɨn pavaŋga mɨliwa.” ");
INSERT INTO kql_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisasɨlɨn valatɨk sivɨleve, “Ben ŋɨn gɨtɨk we pavaŋga mɨliwa?” ");
INSERT INTO kql_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Valan sivɨleve, “Dɨn gasak tonmakandi ñetɨle yetɨk mamataŋ ga yisɨwɨ, yetɨk aŋgataŋ ga yisɨwɨ.” ");
INSERT INTO kql_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","De, Jisasɨlɨn valatɨk sivɨleve. “Ben kombɨiyale wulu ben waiŋgeve ka juŋavi. Ben waiŋgeve jivapala kasik ŋɨn jivapale wombikasak? Katɨk ŋɨn maŋamɨk bumbale we ben wakan kavik bumbapala?” ");
INSERT INTO kql_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Valan galaveve, “Ñen balawa.” Kape, de, Jisasɨlɨn valatɨk sivɨleve, “Ŋɨn jivapale wombikasak ben jivapa. Miyakavik ŋɨn maŋamɨk bumbale we ben miyakavik bumbapa. ");
INSERT INTO kql_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kape mamataŋdi aŋgataŋɨk yisɨwaŋgapale wulu ŋakɨk wulu gaveka. Kavɨla tɨkɨmu Gotɨn galavale balañjukok.” ");
INSERT INTO kql_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kavɨla yila fopat guŋgundan kavɨla wulu bɨiyevekandi bɨkɨk kumbaŋgin yakakale, Jemsɨndi Jontok. ");
INSERT INTO kql_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kape Jisasɨlɨn vala ga yiŋɨmevekandi galaveve, “Ben juŋava, wutan yila balañju gasak wakɨn galava. Kavɨla wutatɨle gasak wakundun bɨkɨk lolomɨk tonmale balañju bɨkɨk wulu ga bɨiye pave. Bɨkɨk gasak autun bɨkɨk juñjuŋama sivɨtva yila balañju ga pavaŋga. ");
INSERT INTO kql_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kape ben kavik tonmandu. Gasak balañjɨk tonmaŋgapale betɨle balañjɨkɨn bikɨk luasamban tonme. ");
INSERT INTO kql_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Betɨle yetɨkɨn wakɨn tonmaŋga mɨliwalen, wun sambanma vaŋ tonme. ");
INSERT INTO kql_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Miyakavik Balañjɨkɨk Fakɨn ava yiŋɨme yila balañju wunu matɨkokolewaŋga. Kayi. Wun yila balañju matɨkokolewaŋga yiŋɨmeve. Wun sɨŋgɨnmaŋga yiŋɨmeve, yila balañju wusandaŋ wusuwaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisasɨlɨn wokok guŋgundandi Jeriko galavale watɨkɨk ŋɨmeve. Yika valambe ŋɨmevekandi yila balañju gasakamanaŋɨn wakan ŋɨmeve. De, mai laŋgɨnɨk yisɨwɨ toneve Bartimeus galavale avɨtɨn. Wun Timeus galavale avɨtkɨk fak. Bartimeusɨlɨn yetɨk sɨpala yakakalekɨk avɨt. ");
INSERT INTO kql_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wun Nasaletɨle Jisasɨlɨn yiŋɨmeve sak bɨiyeve. Bɨiyevekandi kavik joŋ galaveve, “Jisas! Devitkɨk* Afun! Dɨn ŋunu balambanme!” ");
INSERT INTO kql_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Valan wunu apɨkakambe kavik galaveve, “Dɨn maŋgɨk valambe!” Kape wun yika towok vaŋ joŋ galaveve, “Jisas! Devitkɨk Afun! Dɨn ŋunu balambanme!” ");
INSERT INTO kql_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","De, Jisasɨlɨn ŋɨmevekandi sambɨtve kavik galaveve, “Ga yiŋɨme.” Valan katɨk balañjɨktɨk sivɨleve, “Dakɨk kumbaŋ ga apɨtɨwɨ. Kambewɨ. Wun du galava.” ");
INSERT INTO kql_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","De, wun wokok safu tɨmbeve yetɨk wataŋ malipakɨ afɨndafɨnda pɨtɨkti kambekuakavekandi Jisasɨtɨk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","De, Jisasɨlɨn wunutuk sivɨleve, “Dɨn ŋɨn dutuk gɨtɨk pavaŋga mɨliwa?” Wun sivɨleve, “Watpalaŋ, ŋakɨk sɨpala anafak ga tonme.” ");
INSERT INTO kql_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisasɨlɨn wunutuk sivɨleve, “Dɨn kavik juŋava ŋɨn pɨtɨkɨn tonma dakɨk sɨpala anafak ga tonmaŋga. Kapekandi dɨn anafak dala juŋaŋɨme.” De, kepat wun waiŋgeve wulevekandi Jisas vañjenme ŋɨmeve katɨk masi. ");
INSERT INTO kql_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","De, Jisasɨlɨn wokok guŋgundandi ŋɨmeve Jerusalem vevekatɨle sa watatɨk. Betfagendi Betani galavale wata. Kavɨla wata alawiñɨñ Oliv galavale lam gambaŋɨk tonma. De, Jisasɨlɨn wokok guŋgunda alawiñ apɨsukuve ga ŋɨme ");
INSERT INTO kql_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","galaveve, “Ben aŋgɨtɨk watɨkɨk dalaŋɨme. Ŋɨme apɨsalavakandi kepat wulapa yetɨk dɨŋmale kambɨn donki. Yetɨk balañjɨkɨn ava yisɨwɨ anañ wunutuk. Tokoive yimalaŋumfu. ");
INSERT INTO kql_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","De, yetɨk balañjɨkɨn betɨk kavik kombɨiyalen ‘Ben aipandi pava?’ ben kavik galavumfu, ‘Gasak Wakɨnɨn yila wulu pavapa, wunundi.’ De, wun afɨndafɨnda ga yiŋɨmama yika.” ");
INSERT INTO kql_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","De, valan ŋɨmevekandi wuleve, yetɨk dɨŋmale kambɨn donki. Wun yetɨk mfotok lova salava pavale mai gia mai laŋgɨnɨk toneve. Valan wunu tokoiyeve. ");
INSERT INTO kql_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tokoiyevekatɨk kaukatɨk tonmale balañjun kombɨiyeve, “Ben aipaŋga tokoiva katɨk donki?” ");
INSERT INTO kql_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","De, Jisasɨkɨk guŋgundan Jisasɨlɨn galavale maŋgɨk sivɨleve valatɨk. Kapendi valan ga malaŋeve Jisasɨtɨk. ");
INSERT INTO kql_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","De, Jisasɨtɨk malaŋevekandi wokok guŋgundan bɨkɨk wataŋu donkikɨk siŋmatɨk sɨmbɨle ga yisɨkeve Jisas. ");
INSERT INTO kql_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","De, yila balañjun Jisas fofonombaŋga mɨlikevekandi bɨkɨk wataŋu masi sɨmbɨleve, kape yila balañjun balambitɨk ŋɨme muŋ batɨfu vawɨ malaŋmɨ masi sɨmbɨleve. ");
INSERT INTO kql_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","De, yila balañjun bɨndefop ŋɨmeve, yila pɨndaŋ ŋɨmeve. Valan kavik fofonombe akɨtve galaveve, “Ñen Got akɨtva! Got, dɨn waiŋgeve pave katɨk ñetɨk Gasak Wakɨnkɨk wuŋdi ŋɨmale balañjɨktɨk! ");
INSERT INTO kql_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Got, dɨn waiŋgeve pave ñikɨk wuŋgasak Devitkɨk lomtɨk! Yika wokok sumuaŋgalɨn Juwutkasak tonapa! Hevenɨle luasamban sulun Got akɨtva!” ");
INSERT INTO kql_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","De, Jisasɨlɨn Jerusalemɨk apɨsalavevekandi Gotkɨk Gasak Wam* mfawuŋove pumbumɨk lovevekandi lua wofop joloŋgokove. Kape mfunum. Kape, de, wun wokok 12 guŋgundandi Betanitɨk ŋɨme salaveve. ");
INSERT INTO kql_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","De, wulak vandi valan Betani valambe ŋɨmevekandi Jisasɨlɨn gunaŋa gɨveve. ");
INSERT INTO kql_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","De, Jisasɨlɨn yetɨk fik galavale muŋ ganaiŋgatɨk wuleve. Katɨk muŋkɨk daŋa fofokeve, kape, de, Jisasɨlɨn ŋɨme mavi ta mamfoveve, daŋa ŋaikɨk fofokeve. Wun loŋmale siŋa gaveka. ");
INSERT INTO kql_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","De, Jisasɨlɨn galaveve, “Dɨn yika ka loŋapayi. Yila balañjun dakɨk mavi ka jivapayi. Kayi vaŋ.” Wokok guŋgundan katɨk maŋgɨk bɨiyeve. ");
INSERT INTO kql_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","De, Jisasɨlɨn wokok guŋgundandi Jerusalem ŋɨme apɨsalaveve. Apɨsalavevekandi Gasak Wam* mfawuŋove pumbumɨk ŋɨme lovevekandi maket mandɨvale mfanɨle balañju sañjaŋeve. Wun moni bala mfɨlɨmɨkeve mfanɨle mambatu mfamfuŋgañevekandi walimu mandɨve ga wusuwale autukok tɨkɨmu apɨkindaŋeve. ");
INSERT INTO kql_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pavevekandi wun Gasak Wam mfawuŋove pumbumɨk bɨkɨk lua mamalaŋulu kakambeve. ");
INSERT INTO kql_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wun kavik mfɨtɨtiwɨ galaveve, “Gotkɨk buk kumbaŋɨle wulu kavik tonma, ‘Ŋakɨk mfoton ŋunu kukuñmale mfot tonapa, mɨta mɨtatɨle balañju wofopkɨk.’ Ben kavik juŋavala? Kape ben fumafumukok totoŋga ga tonma.” ");
INSERT INTO kql_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","De, kavɨla Gasak Wamɨle Gasak Wakundundi*Gotkɨk Wulu Kumbaŋgikɨk Balañjun* wunu matve ga sɨŋgɨnmaŋgapale wulu sivɨt pɨiyeve. Valan wunu valaiyeve. Balañjun wofopɨn wokok mfɨtɨtiwɨ sivɨleve wulu bɨiyevendi bɨkɨk kumbaŋgin towok kambekeve. ");
INSERT INTO kql_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","De, mfunum Jisasɨndi wokok guŋgundan Jerusalem valambe ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","De, wulak vandi watvɨt ŋɨmevekatɨk Jisasɨndi wokok guŋgundan wuleve katɨk fik galavale muŋ aliyeve, wokok sɨmbɨlin wakan. ");
INSERT INTO kql_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wulevekandi Pitalɨn katɨk Jisasɨlɨn anañ paveve wulu juŋave galaveve, “Watpalaŋ, wutve! Dɨn galavale muŋɨn aliva!” ");
INSERT INTO kql_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","De, Jisasɨlɨn valatɨk galaveve, “Ben juŋave, wulu vaŋu. Kukuñmiŋgi, Gotɨn wulu papa. ");
INSERT INTO kql_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ŋɨn wulu vaŋu betɨk sivɨtva, yetɨk balañjɨkɨn kasik lamtɨk galavalen, ‘Katɨk lam, Gotɨn du yive yukuakapa gia maŋamguanɨk,’ katɨk balañjɨkɨn katɨk ŋaikɨk juñjuŋama ŋaikɨk juŋavalen Gotɨn papa kavik wun galavale we. Wokok kumbaŋɨn matɨñjuŋavalen Gotɨn ka pavapayi. ");
INSERT INTO kql_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kapekandi ŋɨn betɨk sivɨtva, kukuñme kombɨiyale wulu wofop kavik towok juŋave Gotɨn anañ pavale. Kavik juŋavalen Gotɨn ben kombɨiyale wulu papa.” ");
INSERT INTO kql_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Jisasɨlɨn yila wulu kavik galaveve, “Ben sambɨtve kukuñmalen, ben yila balañjukok betɨk yakayi pavale wulu valambe. Bɨkɨk safumbatɨk mandɨve sivɨtvandu. Kavik pavalen Gotɨn bikɨk yaka wulu valambapa. Wun bikɨk safumbatɨk mandɨve ka sivɨlapayi.” ");
INSERT INTO kql_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","De, Jisasɨndi wokok guŋgundan Jerusalemɨk yika ŋɨme apɨsalaveve. Apɨsalavevekandi Gasak Wam* mfawuŋove pumbum kumbaŋñi ŋɨme lovevekandi yila Gasak Wamɨle Gasak Wakundundi* yila Gotkɨk Wulu Kumbaŋgikɨk Balañjundi* yila Avɨtkasun wunutuk yiŋɨme ");
INSERT INTO kql_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kavik kombɨiyeve, “Kavɨla wulu akatɨk yive pava, dɨn? Nan sivɨtve masiva, dutuk, katɨk dakɨk wulu pavaŋgapale wulu?” ");
INSERT INTO kql_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","De, Jisasɨlɨn valatɨk yika galaveve, “Ŋɨn yila wulu betɨk kombɨiyapa. Ben sivɨtviŋgi, ŋɨn katɨk ŋunutuk sivɨtve masivale wulu betɨk sivɨlapa. ");
INSERT INTO kql_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ben Jonon maŋamɨk ga bumbale wulu avik juŋava? Gotkɨk wulu a? Balañjɨkɨk wulu a? Ben ŋunutuk sivɨtve.” ");
INSERT INTO kql_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","De, valan busuak kavik sivɨt pɨiyeve, “Amban Got galavalen, wun kavik galavapa, ‘Ben aipandi ava yive suwɨ juŋave?’ ");
INSERT INTO kql_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kape amban balañju galavalen amba yakakai papa.” Valan yila balañju valaiyeve. Yila balañju wofopɨn kavik juŋaveve, katɨk Jonon Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨk toneve wulun wulu vaŋu toneve. ");
INSERT INTO kql_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","De, valan Jisasɨtɨk sivɨleve, “Ñen akoŋma.” De, Jisasɨlɨn valatɨk sivɨleve, “Ŋɨn mɨñakavik wowakandi ka sivɨtapayi, katɨk ŋunutuk sivɨtve masive ga pavale wulu.” ");
INSERT INTO kql_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","De, Jisasɨlɨn kavɨla gasak aututuk apɨkamule wulu sivɨleve kavik, “Yetɨk avɨtɨn wain galavale muŋa mandɨveve wokok yetɨk balamɨk. Balam gɨsɨkaiye pumbumbeve pumbum paveve. Mɨndɨmɨk mut anañ yowove wain mavi sambɨ sɨsɨwaŋgapale. Wun yetɨk wunambin vaŋɨle mfot gɨveve, balam jɨtvaŋgapale. Kavɨla wulu wofop pavevekandi yila balañjutuk valambeve katɨk balam. Wain mavi vewɨ balawakandi valan wovenetɨk yila masapa. Kavik pavevekandi woven ganaiŋgatɨk ŋɨme toneve. ");
INSERT INTO kql_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","De, wain mavi loŋevendi wokok luasamban balañjɨk apɨsukuve ga ŋɨmeve kavɨla balamɨk tonmale balañjutuk, yila mavi ga yivaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Valan katɨk luasamban yive mfove paiyevekandi yataŋgɨn ga ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","De, katɨk avɨt wokok yetɨk luasamban balañjɨk apɨsukuve ga ŋɨmeve, kape valan wunu yive mfove fopɨk paiyevekandi maiyakeve. ");
INSERT INTO kql_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","De, wun yetɨk mɨñakavik apɨsukuveve yika. Valan wunu matve ga sɨŋgɨneve. De, wun mɨñakavik yika yila apɨsukuve ga ŋɨmeve. Valan yila paiyeve, yila mat mat gaŋga sɨŋgɨneve. Kape, de, yila luasamban balañju miyakɨk. ");
INSERT INTO kql_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kape, de, katɨk gasak avɨtɨn yetɨk balañjɨk toneve, wokok ŋaikɨk fak, towok mɨliwale. De, pɨndaŋ wun wokok ŋaikɨk fak ga ŋɨmeve. Wun kavik galaveve, ‘Valan ŋakɨk fak fofonombapa.’ ");
INSERT INTO kql_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kape kavɨla balamɨk toneve balañjun katɨk fak wulevekandi bɨvene bɨvenetɨk kavik sivɨt pɨiyeve, ‘Katɨk fakɨn wokok waŋkɨk lɨmbaŋɨk tonma. Kape, de, ŋɨme. Amban wunu matve ga sɨŋgɨnapa. Wokok balam ambɨkɨk tonapa.’ ");
INSERT INTO kql_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kavik sivɨlevekandi valan wunu yive mfove matve ga sɨŋgɨnevekandi sɨsɨŋgɨn yukuakave balam kutuk.” ");
INSERT INTO kql_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisasɨlɨn katɨk wulu sivɨlevekandi yila wulu kavik sivɨleve, “Katɨk balam waŋɨn gɨtɨk wulu papa? Wun yika yiŋɨmama balamɨk tonmale balañju matve ga sɨŋgɨnmaŋga pave. Ga sɨŋgɨnme balawakandi balam masivapa yila balañjutuk. ");
INSERT INTO kql_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gotkɨk buk kumbaŋɨle wulu kavik moleve wulu ava wutve, a? Wun kavik tonma, ‘Katɨk mfot gɨvale balañjun yakai yakai wutvale kape valambeve mɨndɨm, pɨndaŋ katɨk mɨndɨmɨn mfotɨle yakamɨtka mulavali vaŋ mɨndɨm toneve. ");
INSERT INTO kql_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gasak Wakɨnɨn paveve. Ñen anafak vaŋ wuleve.’ ” ");
INSERT INTO kql_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","De, kavɨla gasak autun juŋaveve Jisasɨlɨn kavɨla apɨkamule wulu bɨkɨk safumbatɨk mandɨve sivɨleve. Kapekandi valan Jisas wuwɨ mfovaŋga juŋaveve, kape mfakuŋguŋove balañju valaiveve. Kapekandi valambe ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","De, kavɨla gasak wakundun Jisasɨtɨk yila Farisitɨle* autundi yila Herotkɨk* autu apɨsukuve ga ŋɨmeve Jisas apɨpɨlaivaŋga pave, kape wokok safutuk yila wulu mandɨve sivɨtvaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","De, valan wunutuk ŋɨme sivɨleve, “Watpalaŋ, ñen kavik juŋava, dɨn balañjɨk anafak. Dɨn balañju wofop mɨñakavik fofonomba. Dɨn yetɨktɨk yakatɨk ka gavi. Dɨn yetɨktɨk anafak ka gavi. Dɨn balañju wofop mɨliwa. Kape dɨn Gotkɨk wulu vaŋu mfɨtɨtiwɨ sivɨtva. Gotɨn Masiveve Goŋguaŋmali Fulakɨn* galavala amban Sisa galavale Romɨle juwutkasaktɨk takis masapala, kayi, a? Masapati, kaviati?” ");
INSERT INTO kql_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kape Jisasɨlɨn bɨkɨk matɨkambaiyikeve wulu wule gaveve, “Ben aipandi ŋunu muwɨ? Ŋaikɨk va tonmaŋgale moni malaŋmɨ, ŋɨn wulapa.” ");
INSERT INTO kql_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","De, malaŋevendi wun vala kombɨiyeve, “Katɨk makɨndi katɨk wuŋɨn nanɨkɨk?” De, valan wunutuk galaveve, “Sisakɨk.” ");
INSERT INTO kql_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kape, de, Jisasɨlɨn valatɨk kavik galaveve, “Sisakɨk lua wovenetɨk masive, Sisarɨtɨk. Mɨñakavik Gotkɨk lua wovenetɨk masive, Gotok.” Kape, de, valan wokok maŋgɨk bɨiyevekandi pɨkɨliyeve. ");
INSERT INTO kql_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satyusitɨle balañjun galaveve sɨŋgɨnmale balañjun yika ka kambekapayi. De, yila Satyusitɨle balañjun Jisasɨtɨk yiŋɨmevekandi kavik kombɨiyeve, ");
INSERT INTO kql_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Watpalaŋ, Mosesɨlɨn* buk kumbaŋɨk anañ anañ ambakɨk wuŋgasutuk kavik moleve, yetɨk balañjɨkɨn sɨŋgɨnmaŋga pave, kapekandi wokok me kavik valambe sɨŋgɨnma, kape faklia mɨñakɨk, wokok wufakalɨn katɨk me yika yivapa wokok wuŋgiakɨk faklia malaŋmaŋga katɨk mendi. ");
INSERT INTO kql_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","De, ŋaikɨk avɨtkɨk 7 fu toneve. Katɨk balɨsɨkɨk fakɨn me yiveve. Kape faklia mɨñakɨk me valambe sɨŋgɨneve. ");
INSERT INTO kql_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","De, wokok gambaŋ mfovale wufakalɨn katɨk me yiveve, kape wun katɨk me faklia mɨñakɨk yika valambe sɨŋgɨneve. Kape alilaŋgɨkɨn mɨñakavik paveve wakan, wun. ");
INSERT INTO kql_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","De, vala 7 wofopɨn mɨñakavik paveve, katɨk me faklia mɨñakɨk valambe sɨŋgɨnmisakave. Kape pɨndaŋ katɨk melɨn wakan sɨŋgɨneve. ");
INSERT INTO kql_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Balañju kambewɨsakɨle vandi, kavɨla 7 balañjun kambewakandi, katɨk me nan yivapa? Valan 7 autun wofopɨn yiveve me katɨk.” ");
INSERT INTO kql_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","De, Jisasɨlɨn valatɨk kavik sivɨleve, “Ben Gotkɨk buk kumbaŋɨle wulu mamaŋgova. Mɨñakavik ben Gotkɨk pɨtɨk mamaŋgovakandi yakai yakai sivɨtva. ");
INSERT INTO kql_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sɨŋgɨnmale balañjun kambewale vandi, valan yika meandu ka yivapayi, meandun malata ka yivapayi. Valan wunambinɨle luasamban sululungo mɨñakavik tonapa. ");
INSERT INTO kql_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kape katɨk sɨŋgɨnmale balañjun kambewale wulu, sivɨlapa, ŋɨn. Ben katɨk sa muŋ wuŋmale mɨnɨle wulu Mosesɨlɨn moleve buk kumbaŋɨk ava wuleka? Gotɨn kaukatɨk Mosesɨtɨk kavik galaveve, ‘Ŋɨn Aprahamkɨk Got, ŋɨn Aisikɨk Got, ŋɨn Jekopkɨk Got.’ ");
INSERT INTO kql_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wun sɨŋgɨnmale balañjukok Got gaveka. Wun watɨk tonmale balañjukok. Ben towok mamaŋgova.” ");
INSERT INTO kql_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yetɨk Gotkɨk Wulu Kumbaŋñe Balañjɨkɨn* ŋɨme bɨiyeve valan sivɨt pɨiyeve wulu. Wun bɨiyeve Jisasɨlɨn waiŋgeve sivɨleve, kapekandi kavik kombɨiyeve, “Gotɨn Masiveve Goŋguaŋmali Wulu* wofopɨle, ala wulun tonma gasak vaŋ?” ");
INSERT INTO kql_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","De, Jisasɨlɨn kavik galaveve, “Katɨk gasak wulu vaŋɨn kavik tonma, ‘Israeltɨle balañju, ben bɨiye! Ambɨkɨk Gasak Wakɨnɨn, Got, wun wusuak ŋaikɨk Gasak Wakɨn tonma. ");
INSERT INTO kql_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dɨn dakɨk Gasak Wakɨn, Got towok mɨliwɨ, dakɨk kumbaŋ wofopti, dakɨk sulak wofopti, dakɨk juñjuŋama wofopti, dakɨk pɨtɨk wofopti.’ ");
INSERT INTO kql_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Katɨk yetɨk gasak vaŋ Gotɨn Masiveve Goŋguaŋmali Fulakɨn kavik tonma, ‘Aŋgɨla aŋgɨla balañju wofop mɨliwɨ dɨn daven mɨliwale daŋdi.’ Kavɨla wulu alawiñɨñ busuak ŋaikɨk tonma gasak vaŋ.” ");
INSERT INTO kql_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Katɨk Gotkɨk Wulu Kumbaŋñe Balañjɨkɨn kavik galaveve, “Wulu vaŋu, Watpalaŋ. Dɨn waiŋgeve galava, Got, wun wusuak ŋaikɨk tonma. Yetɨkɨn mɨyakɨk. ");
INSERT INTO kql_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wunu towok mɨliwale fulak, dakɨk kumbaŋ wofopti, dakɨk juñjuŋama wofopti, dakɨk pɨtɨk wofopti, kape mɨñakavik aŋgɨla aŋgɨla balañju wofop mɨliwale fulak dɨn davene mɨliwale daŋdi, kavɨla wulun yila wulu wofop matɨkakalɨwa. Jakali malaŋmɨ mɨnɨk wofop apɨkuwakandi kukuñme masivandi yila wunutuk masivaŋgapale lua, kavɨla wunutuk masivale wulu wofopɨn gasak gaveka.” ");
INSERT INTO kql_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","De, Jisasɨlɨn wokok wulu waiŋgeve bɨiyevekandi galaveve wunutuk, “Dɨn vevekave ŋɨma Got lolomɨk tonmaŋga.” De, yila balañjun Jisas yila wulu kombɨiyulu veven juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisasɨlɨn Gasak Wam* mfawuŋove pumbumɨk tonme mfɨtɨtiwɨ sivɨleve. Wokok yila wulu kavik galaveve, “Gotkɨk Wulu Kumbaŋgikɨk Balañjun* aipandi galava Krais, katɨk Gotkɨk Balañju Yika Yivaŋgapale Balañjɨkɨn, wun Devitkɨk* afun tonapa? ");
INSERT INTO kql_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gotkɨk Sulakɨn Devitɨk* juñjuŋama masive ga galaveve, kavik, ‘Gasak Wakɨnɨn ŋakɨk Gasak Wakɨntɨk sivɨleve, “Ŋakɨk mamataŋ kɨlikɨk yisɨwɨ. Dutuk yakai yakai pavale balañju dakɨk gambiŋgi lolomɨk ga tonmaŋga ŋɨn.” ’ ” ");
INSERT INTO kql_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jisasɨlɨn Devitkɨk anañ anañ galaveve wulu sivɨlevekandi kavik yika sivɨleve, “Devitɨn katɨk avɨt Gasak Wakɨn galava. Kape wokok afun avik tonma, yika?” De, kavɨla makolokeve balañju wusandaŋɨn Jisasɨkɨk maŋgɨk bɨiyaŋga mɨlikeve. ");
INSERT INTO kql_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisasɨlɨn valatɨk mfɨtɨtiwɨ kavik galaveve, “Ben waiŋgeve kavɨla Gotkɨk Wulu Kumbaŋgikɨk Balañju*. Valan bɨkɨk papaikasak wataŋu kɨlɨwakandi mfaŋatɨk makaŋɨma, yila balañjun vala ga akɨtvaŋga. ");
INSERT INTO kql_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Valan wakundukok tɨkumutuk yisɨwaŋga towok mɨliwa Sa Wamɨle. Mɨñakavik balañju makolowale jeñjek jivaŋga pava, valan gasak autukok anafak mɨtɨk yisɨwaŋga mɨliwa. ");
INSERT INTO kql_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Valan dɨkiak meandukok mfututɨle lua malaŋ malaŋ jivakandi wulu wusandaŋ mumuk kukuñma. Gotɨn bɨkɨk safumbatɨk gasak wulu vaŋu mandɨve yakai yakai vaŋ papa.” ");
INSERT INTO kql_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","De, yivɨt Jisasɨlɨn moni masiveve mɨt balaŋgoŋgo jɨtve yisɨwɨ toneve. Wun wulevekatɨk yila balañjun mfakuŋgumɨ moni masiveve. Moni gasakamanaŋ tonmale balañjun gasakamanaŋ moni suwove. ");
INSERT INTO kql_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","De, yetɨk samban dɨkiak melɨn ŋɨme suwove alawiñ sa moni. Kavɨla alawiñ mfakuŋovendi ambɨkɨk ŋaikɨk sa manilɨŋgo toneve. ");
INSERT INTO kql_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","De, Jisasɨlɨn wokok guŋgunda ga yiŋɨme galaveve, “Ŋɨn wulu vaŋu betɨk sivɨtva, katɨk samban dɨkiak melɨn masivale monin aŋgala gasakamanaŋ moni masivale balañjukok moni matɨkakalɨwa. ");
INSERT INTO kql_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Valan gasakamanaŋ monitɨle yila suwa, kape wun sambanma tonma. Wun wokok jeñjek wusuwaŋgapale moni wofop masiva.” ");
INSERT INTO kql_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","De, Jisasɨlɨn Gasak Wam* mfawoŋove pumbumi salave ŋɨmevekatɨk wokok yetɨk guŋgunɨn wunutuk sivɨleve, “Watpalaŋ, wutve. Kavɨla mfot gɨvale mɨndɨmun mulavali vaŋ. Kavɨla mfutun mulavali vaŋ.” ");
INSERT INTO kql_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","De, Jisasɨlɨn wunutuk galaveve, “Dɨn kavɨla sosowe mfutu wutvala? Ŋɨn wulu vaŋu sivɨtva, yetɨk mɨndɨmɨn yetɨk mɨndɨmɨk ka tonapayi. Yila balañjun wofop apɨfuŋgaimapa.” ");
INSERT INTO kql_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","De, Jisasɨlɨn wokok guŋgundandi Oliv galavale lamɨk ŋɨmeve. Ŋɨmevekandi wun wusuak yisɨ toneve, katɨk Gasak Wam yakatɨle kambɨlɨm aŋgɨndaŋɨk. De, Pitandi Jemsɨndi Jonɨndi Andrulun, valan ŋaikɨk wunutuk yiŋɨme kavik kombɨiyeve, ");
INSERT INTO kql_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dɨn ñetɨk galave, ata vandi kavɨla wulu salave ŋɨmama? Kavɨla wulu wofopɨn yiŋɨmaŋgapale vandi, ñen gɨtɨk we wulapa ga juŋavaŋgapale wandefaka?” ");
INSERT INTO kql_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","De, Jisasɨlɨn valatɨk galaveve, “Ben waiŋgeve. Yila balañjun be muwapa, kape bɨiyandu. ");
INSERT INTO kql_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Balañju gasakamanaŋɨn ŋakɨk wuŋdi yiŋɨ yiŋɨ galavapa, ‘Ŋunu katɨk balañjɨk.’ De, yila balañju wusandaŋɨn bɨiyapa bɨkɨk muwale wulu. ");
INSERT INTO kql_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ben mɨn ŋɨliwale sawavi bɨiyapa, yila vevekatɨle, yila ganaiŋgatɨle, kape bikɨk kumbaŋgin kambewandu. Kavɨla wulun yiŋɨmama, kape katɨk pɨndaŋɨle ŋaikɨk valɨn kaiyimfutuk. ");
INSERT INTO kql_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yetɨk balaŋɨle balañjun yetɨk balaŋɨle balañjundi mɨn ŋɨliwapandi yetɨk juwutkasakɨk lomɨn yetɨk juwutkasakɨk lomdi mɨn ŋɨliwapa. Mandɨkɨn ŋɨmama mɨta mɨtatɨk. Yila mɨtan jeñjek bɨŋapa. Kavɨla wulun fofop fopɨle melɨn fak matɨlapɨtvɨleliaŋgo tonapa.” ");
INSERT INTO kql_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jisasɨlɨn kavɨla wulu galavevekandi yila wulu kavik galaveve, “Ben waiŋgeve. Valan bikɨk safumbatɨk yila wulu mandɨve sivɨlapa bɨkɨk gasak wakundutuk. Valan be paiyapa bɨkɨk Sa Wumbi* kumbaŋgitɨk. Ben bɨkɨk gasak wakundukok gasakti juwutkasakɨk makɨtɨk sambɨlapa, ŋakɨk ŋɨn pavale wulu sivɨtvaŋga valatɨk. ");
INSERT INTO kql_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kape wandefaka ŋakɨk balañjun ŋakɨk wulu anafu mɨta mɨtatɨle balañju wofoptɨk sivɨlapa. ");
INSERT INTO kql_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kape, de, kavɨla valan be wuwɨ kotɨk malaŋmale vandi, ben bikɨk sivɨtvaŋgapale wulu veven juŋavandu. Gotɨn yila wulu masapa betɨk. Ben katɨk wun masivale wulu sivɨtvumfu. Ben bisuak ka sivɨlapayi. Gotkɨk Sulakɨn* beti sivɨlapa. ");
INSERT INTO kql_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wuŋgiakɨn wokok wufaka masivapa, yila balañjutuk ga matve ga sɨŋgɨnmaŋga. Yetɨk waŋɨn wokok fak mɨñakavik. Yila fun bɨkɨk womendi waŋ masivapa yila balañjutuk ga matve ga sɨŋgɨnmaŋga. ");
INSERT INTO kql_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yila balañju wofopɨn bikɨk ŋunu mɨliwale fulak wulapa, kapekandi valan be towok gɨlɨpapa. Kape yila dɨtikpat kumbaŋgikɨk balañjun apɨnɨŋgɨlipe ŋunu vañjenmale, kapekandi ŋunu ka valambapayi, ŋɨn kavɨla balañju yivapa.” ");
INSERT INTO kql_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisasɨlɨn kavɨla wulu galavevekandi yila wulu kavik galaveve, “Ben wutvakandi yetɨk yakai yakai vaŋ kakambale wosen yetɨk kakambale anafak luakɨk mɨtɨk tonmiŋgi ben kasik wulu wutvale balañjun waiŋgeve juŋave, Jutatɨk tonmale balañjun, ben lambitɨk mɨtvumfu. ");
INSERT INTO kql_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yila mfot wunambini yisɨ tonmale balañjun, valan mfot kumbaŋ bɨndefaka bumbe lovandu, lua yivaŋga. ");
INSERT INTO kql_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yetɨk mɨtɨk tonmale balañjɨkɨn wokok mfotok yika ŋɨmandu, wokok yetɨk wataŋ yivaŋga. ");
INSERT INTO kql_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Fawandu tonmale meandundi fakliatɨk milu ga jivale meandun yakai yakai tonapa katɨk vandi. ");
INSERT INTO kql_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ben Got kukuñme, katɨk wulun malɨn dɨmbale alolowale gɨŋatundi yiŋɨmandu. ");
INSERT INTO kql_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kavɨla valundi balañjun yakai yakai vaŋ tonapa. Kavɨla ŋɨn galavale yaka valun anañ Gotɨn lua wofop pavevendi pɨndaŋɨle yaka valu wofop matɨkakalekapa. Kavɨla valu pɨndaŋ balañjun yika mɨñakavik yakai yakai vaŋ ka tonapayi. ");
INSERT INTO kql_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","De, Gotɨn kavɨla valu kakaika ga tonmalen balañjun wofopɨn sɨŋgɨnapa, kape Wun wokok wukuaŋeve balañju balambanmakandi kavɨla valu patka ga tonapa. ");
INSERT INTO kql_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yila balañjun betɨk sivɨtviŋgi, ‘Krais* kasik,’ ben bɨiyandu. Valan sivɨtviŋgi ‘Wun aŋgatɨk’ ben bɨiyandu. ");
INSERT INTO kql_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yila muwale balañjun yiŋɨme muwɨ galavapa kavik, ‘Ŋunu Krais.’ Yilan muwɨ galavapa, ‘Ŋunu yetɨk Gotkɨk maŋgɨk malaŋmɨ sivɨtvale balañjɨk.’ Valan yila gasak pɨtɨkie wulu papa, daŋgi daŋgindi. Kape valan balawalen, valan Gotɨn wukuaŋeve balañju muwapa. ");
INSERT INTO kql_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kape ben waiŋgeve! Ŋɨn fofop kavɨla pɨndaŋ pavapɨle wulu wofop galava.” ");
INSERT INTO kql_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jisasɨlɨn kavɨla wulu galavevekandi yila wulu kavik galaveve, “Kavɨla yakai yakai valu balawakandi, kavɨla pɨndaŋ valundi valɨn wukaniŋgo tonapandi gɨŋatɨn ka apakowapayi. ");
INSERT INTO kql_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Katɨk vandi juñjaŋan fɨiŋga valambe kumuwapa, kape yila fɨiŋgatɨle gasak pɨtɨkie luan pɨpɨwapa wakan. ");
INSERT INTO kql_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","De, kavik pavindi valan wulapa, Balañjɨkɨk Fakɨn* yiŋɨmama yaŋgɨmdi. Wun gasak pasalakasak pɨtɨkti gasak valɨŋgo apɨkowɨ yiŋɨmama. ");
INSERT INTO kql_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yiŋɨmakandi wun wokok Gotkɨk luasamban sulu apɨsukuvapa wokok wukuaŋeve balañju wofop yivaŋga mɨta mɨtatɨle. Yetɨk mɨt ka valambapayi.” ");
INSERT INTO kql_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisasɨlɨn kavɨla wulu galavevekandi yila wulu kavik galaveve, “Ben fik galavale muŋ wutve, wokok mfɨtɨtiwale wulu bɨiye. Wokok gun maŋambikɨk kapekandi fofowa, de, ben juŋava vanñevalɨn kɨva. ");
INSERT INTO kql_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mɨñakavik, ben ŋɨn anañ galavale wulu atavandi wutvalen juŋamfu, Balañjɨkɨk Fakɨn* vevekatɨk tonma. Wun mfotok lovaŋgapale mai vaŋgɨkɨk tonma. ");
INSERT INTO kql_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ŋɨn wulu vaŋu betɨk sivɨtva, kamfu tonmale balañjun kasik ŋɨn galavale wulu yiŋɨmaŋgapale vandi, valan yilan wandefaka ka sɨŋgɨnapayi. ");
INSERT INTO kql_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Fɨiŋgandi mañjikalin yetɨk vandi ka tonapayi, kape ŋakɨk wulun towok tonŋɨmama.” ");
INSERT INTO kql_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisasɨlɨn kavɨla wulu galavevekandi yila wulu kavik galaveve, “Kavɨla wulun yiŋɨmaŋgapale va balañjun wofopɨn akoŋma. Watvɨt yiŋɨmamati, mfunum yiŋɨmamati wukan yiŋɨmamati. Mɨñakavik akoŋma, balañjun wofopɨn. Gotkɨk luasamban sulun mɨñakavik akoŋma. Gotkɨk fakɨn wakan mɨñakavik akoŋma. Got Waŋɨn woven wusuak ŋaikɨk katɨk va juŋava. ");
INSERT INTO kql_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kape ben waiŋgeve! Jiñjit tonme! Ben akoŋma, mɨvandi yiŋɨmama. ");
INSERT INTO kql_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wun kavikɨŋgo tonma. Yetɨk avɨtɨn wokok mfot valambaŋga juŋaveve, kapekandi wokok luasamban balañju ga yiŋɨmevekandi galaveve valan ŋaikɨk ŋaikɨk yila wulu pavaŋga. Wun katɨk mfotok lovaŋgapale mai wasalomale balañjɨktɨk wasalomɨ tonmaŋga galaveve. ");
INSERT INTO kql_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Miyakavik ben wasalomɨ! Ben akoŋma, mfot waŋɨn mɨvandi yiŋɨmama, mfunumɨti, wukanɨti, moañɨn galavale paleti, watvɨtɨti. ");
INSERT INTO kql_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wun afɨndafɨnda yiŋɨme du ñembakatɨk ŋɨme wutvalen, katɨk yakatɨk. ");
INSERT INTO kql_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Betɨk sivɨtvale maŋgɨk mɨñakavik ŋɨn balañju wofoptɨk sivɨtva, wasalomɨ!” ");
INSERT INTO kql_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","De, katɨk gasak goŋguaŋmali jeñjek jivale valun luañjek tonapa. Fofop tonmale valɨn kavik toneve, Jutatɨle balañjun yila sipsip fu jiveve, Gotɨn vala anañ Makatve Ga Toneve Vandi* ga juŋavaŋgapale. Yetɨk jeñjekɨn kavik toneve, valan yis mɨñakɨk breta jiveve. De, katɨk goŋguaŋmali jeñjek jivali valɨn luañjek tonapa kamfu vandi aŋgin takeve wulu sivɨt pɨiyeve, kavɨla Gotkɨk Gasak Wamɨle Gasak Wakundundi* kavɨla Gotkɨk Wulu Kumbaŋgikɨk Balañjun*. Valan Jisas fombe wuwɨ matve ga sɨŋgɨnmaŋga juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kape valan kavik galaveve, “Jeñjek jivale mfa kumbaŋñi pavandu. Yila balañjun mɨn ŋɨliwandu.” ");
INSERT INTO kql_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","De, Jisasɨlɨn Betani watɨkɨle mfotok ŋɨme loveve. Saimon, andɨvɨli mumuiŋgali safuye avɨtkɨk mfotok love yisɨwove mambatɨk. De, yetɨk melɨn anafak mɨndɨm avimbɨlɨm malaŋmɨ ŋɨme loveve. Katɨk avimbɨlɨm kumbaŋɨk anafak kosembɨye maŋam suwove, gasak monikɨk. De, katɨk melɨn avimbɨlɨmkɨk fop matɨvakevekandi anafak kosembɨye maŋam mfafɨlekeve Jisasɨkɨk fopɨk. ");
INSERT INTO kql_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kape yila balañjun bɨkɨk kumbaŋgin akalakevekandi fom sivɨleve. Valan kavik sivɨleve, “Wun gɨtɨk paŋga pave yataŋgɨn mfɨlewɨ katɨk maŋam? ");
INSERT INTO kql_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wun katɨk maŋam monitɨk masivalen wun 300 valu tonapale moni yivapa, yataŋgɨn tonmale mia balañjutuk masivaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kape Jisasɨlɨn galaveve, “Wunu ga tonme! Ben gɨtɨk paŋga sivɨtva wunutuk? Wun ŋunutuk anafak pava. ");
INSERT INTO kql_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yataŋgɨn tonmale mia balañjun bendi valu valu tonapa. Ben atɨvandi kavɨla anafak pavaŋga pavalen, pamfu. Kape ŋɨn bendi valu valu ka tonapayi. ");
INSERT INTO kql_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Katɨk melɨn wun pavapale we, de, wun pavale. Wun kasik maŋam ŋunutuk mfafalewale ŋakɨk safu bambave guamɨk ŋɨmaŋgapale. ");
INSERT INTO kql_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ŋɨn wulu vaŋu betɨk sivɨtva. Valan ŋɨmale mañjikalitɨk valan wulu anafu sivɨlimapa, katɨk melɨn pavale wulu wokok sivɨlapa wunu ga juŋa ŋɨmaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kavɨla 12 guŋgunda kumbaŋɨk yetɨkɨn toneve. Wokok wuŋ Jutas Iskariot. Wun kavɨla Gasak Wamɨle Gasak Wakundutuk* ŋɨme galaveve Jisas valatɨk kɨndɨŋmɨ suwaŋga. ");
INSERT INTO kql_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Valan wokok wulu bɨiyevekandi vavalakeve. Kapekandi yila moni wunutuk masivaŋga galaveve. Kape, de, wun kɨndɨŋmɨ suwaŋgapale wulu juŋambɨi juŋambɨiyeve. ");
INSERT INTO kql_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","De, katɨk Yis Mɨñakɨk Bret Jivaŋgapale Goŋguaŋmali Jeñjekɨk* fopɨle valɨn kamfu. Katɨk Got kukuñmaŋgapale yetɨk sipsip fakɨk bɨŋpat matɨpɨtɨwaŋgapale vandi, Jisasɨkɨk guŋgundan wunutuk kavik galaveve, “Ñen atɨkatɨk ŋɨmama jeñjekɨk lua waiŋgeve mandɨvaŋga yivɨt katɨk Makatve Ga Tonmale Vakɨk* jeñjek jivaŋgapale.” ");
INSERT INTO kql_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","De, Jisasɨlɨn guŋgunda alawiñ apɨsukuve kavik galaveve, “Gia watɨkɨk dalaŋɨme apɨsalave. Apɨsalavandi yetɨk maŋame kuluwali afufulivɨ malaŋmale avɨtɨn ŋɨmama betɨk. Wunu vañjenme ŋɨmumfu. ");
INSERT INTO kql_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wun ŋaikɨk mfotok lovapa. De, ben katɨk mfot waŋtɨk kavik galavumfu, ‘Watpalaŋɨn kavik kombɨiya, “Ŋakɨk mɨtɨn atɨk, kasik mfotɨle, katɨk Makatve Ga Tonmale Vakɨk jeñjek jivaŋgapale mɨt. Ŋɨn ŋakɨk guŋgundandi katɨk jeñjek jivapa.” ’ ");
INSERT INTO kql_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","De, wun betɨk akakalayapa yetɨk gasak wunambinɨk tonmale mɨt. Katɨk mɨtɨk luan bambave tonma. De, ben lovumfu jeñjek pavaŋgo.” ");
INSERT INTO kql_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","De, kavɨla guŋgundan ŋɨme gia watikɨk apɨsalaveve. Valan wokok sivɨtvale wulu mɨñakavik wuleve. Kapekandi katɨk Makatve Ga Tonmale Vakɨk lua paveve. ");
INSERT INTO kql_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","De, valɨn mfatɨndɨmevendi Jisasɨlɨn wokok 12 guŋgundandi yiŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Valan jeñjek jive yisɨwɨ tonevekatɨk Jisasɨlɨn kavik galaveve, “Ŋɨn betɨk wulu vaŋu galava, katɨk bikɨk gɨŋganɨle balañjɨkɨn ŋunundi wakan jeñjek jiva. Wun ŋunu kɨndɨŋmɨ suwapa mamatutuk kɨliatɨk.” ");
INSERT INTO kql_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Valan kavik bɨiyevekandi bɨkɨk kumbaŋgi gɨkɨlikeve. Kapekandi valan ŋaikɨk ŋaikɨkɨn wunu kombɨiyeve, “Dɨn ŋunu galavala?” ");
INSERT INTO kql_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wun valatɨk kavik galaveve, “Wun bikɨk 12 guŋgundakɨk gɨŋganɨle yetɨkɨn. Wun ŋunundi wakan bret aŋgatɨk kukuwɨ jiva. ");
INSERT INTO kql_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Balañjɨkɨk Fakɨn* Gotɨn anañ ga moleve wuluŋgo miyakavik vaŋ sɨŋgɨnapa. Kape katɨk wunu mamatukok kɨliatɨk kɨndɨŋmɨ masivale balañjɨk, wun yakai yakai vaŋ tonapa. Wokok womelɨn wunu ka kawulevekalen, katɨk anafak.” ");
INSERT INTO kql_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","De, Jisasɨlɨn wokok guŋgundandi jeñjek jivevekatɨk, Jisasɨlɨn ŋaikɨk bret yiveve. Yivevekandi Gotɨk akɨtve galaveve. Galavevekandi masiveve valatɨk. Wun valatɨk kavik galaveve, “Yive jive, katɨk ŋakɨk safu.” ");
INSERT INTO kql_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","De, wun wain wombikasak yivevekandi Gotɨk yika akɨtve galavevekandi valatɨk masiveve. Masivevendi valan wofopɨn jiveve. ");
INSERT INTO kql_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wun valatɨk kavik galaveve, “Katɨk ŋakɨk ambala. Ŋakɨk ambalandi Gotɨn wokok yila wulu sivɨtve tɨmbapa. Ŋakɨk ambala salavapa balañju wusandaŋ yika yivaŋgapale. ");
INSERT INTO kql_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɨŋ wulu vaŋu betɨk galava, ŋɨn wain wombikasak yika ka jivapayi. Gotkɨk watɨkɨk tonmakandi, de, katɨk vandi ŋɨn yika anɨkɨk wain wombikasak jivapa.” ");
INSERT INTO kql_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Valan Gotkɨk gɨŋ sɨlivevekandi, salave ŋɨmeve katɨk Oliv galavale lamɨk. ");
INSERT INTO kql_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisasɨlɨn wokok guŋgundatɨk kavik galaveve, “Ben wofopɨn ŋunu mɨmɨliwakandi valambapa. Gotkɨk janda kumbaŋɨk kavɨla wulu tonma, ‘Ŋɨn sipsip fukok waŋ malapa, kapendi sipsip fun wolokuakɨk mɨlapa.’ ");
INSERT INTO kql_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kape Gotɨn ŋunu yika ga kambekuakakandi, ŋɨn ŋandefaka ŋɨmama, Galilitɨk.” ");
INSERT INTO kql_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kape Pitalɨn wunutuk kavik galaveve, “Valan wofopɨn du mɨmɨliwɨ valambalen, ŋɨn kayi vaŋ! Ka valambapayi!” ");
INSERT INTO kql_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","De, Jisasɨlɨn wunutuk kavik galaveve, “Ŋɨn wulu vaŋu dutuk galava, kamfu wukan moañɨn alawiñkɨk maŋgɨk gaŋgalaka mɨñakɨk, gaŋgalawavi alilam dɨn ŋunu ŋaŋalambapa.” ");
INSERT INTO kql_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kape Pitalɨn towok vaŋ galaveve, “Ŋɨn dundi sɨŋgɨnapalen, du ka ŋaŋalambapayi. Kayi vaŋ!” De, vala wofopɨn mɨñakavik galaveve. ");
INSERT INTO kql_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","De, Jisasɨlɨn wokok guŋgundandi ŋɨmeve Getsemani galavale mɨtɨk. Ŋɨmevekandi wun wokok guŋgundatɨk galaveve, “Ben yisɨ tonme. Ŋɨn kukuñapa.” ");
INSERT INTO kql_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wun Pitandi Jemsɨndi Jon yikafak ŋɨmɨleve. De, wokok kumbaŋɨn towok veven juŋavevekandi yakai yakai juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wun valatɨk galaveve, “Ŋakɨk kumbaŋɨn yefop yefop juŋava towok kalikvɨyi kapekandi sɨŋgɨnmaŋga pava. Ben kaikatɨk mandɨwɨ.” ");
INSERT INTO kql_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","De, wun yikafak ŋɨmevekandi amandepewɨ fopti mañjikatɨk mandɨve kukuñeve. Wun kavik kukuñeve, “Dɨn balawalen, kavɨla wulu ŋunutuk ga yiŋɨmandu.” ");
INSERT INTO kql_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wun kavik galaveve, “Apa, Wawa. Dɨn wulu wulu wofop pavaŋgale dɨn pava. Kasik ŋunutɨle wombikasak yive. Kape ŋakɨk juñjuŋamandi pavandu. Dɨn papandaŋdi pave.” ");
INSERT INTO kql_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kukuñevekandi wun kavɨla guŋgunda alilaŋguaŋtɨk yika ŋɨme wuleve. Valan ñembeve. Kapendi wun galaveve Pitatɨk, “Saimon, dɨn ñembala? Dɨn ŋasuak ŋasuak ka mandɨkvɨliapaya? ");
INSERT INTO kql_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ben mandɨki kukuñme. Ben yaka wulutuk kumuwandu. Kumbaŋɨn anafak wulu pavaŋga mɨliwa, kape safulun pɨtɨkɨn mɨyakɨk.” ");
INSERT INTO kql_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","De, wun yika ŋɨme kukuñeve. Ŋaikɨk daŋdi kukuñeve, yika. ");
INSERT INTO kql_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yika ŋɨmevekandi wokok guŋgundan kamfu ñembevekatɨk wuleve. Bɨkɨk sɨpalan towok vaŋ aluŋeve. Vala matɨkambekevendi yataŋgɨn toneve. Valan gɨtɨk wulu sivɨlapa? ");
INSERT INTO kql_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisasɨlɨn yika alilaŋgɨk ŋɨŋawa kukuñme yiŋɨmevekandi sivɨleve valatɨk, “Ben ñembe golañjaŋmala? De, balawa. Wutve. Kamfu kamfu Balañjɨkɨk Fak kɨndɨŋmɨ suwɨ masiva yaka wulu pavale balañjukok kɨliatɨk. ");
INSERT INTO kql_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ben kambewɨ. Amban ŋɨmama. Wutve. Katɨk ŋunu kɨndɨŋmɨ suwɨ masivaŋgapale balañjɨkɨn anañ yiŋɨmale.” ");
INSERT INTO kql_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","De, kepat. Wun kamfu sivɨlevekatɨk, Jutasɨlɨn yila autukok saiti yiŋɨmeve. Jutasɨlɨn Jisasɨkɨk 12 guŋgundatɨle yetɨk avɨt. Katɨk sasɨn kavik tonma, yila Gasak Wamɨle Gasak Wakundutɨle* autundi yila Gotkɨk Wulu Kumbaŋgikɨk Balañjutɨle* autundi yila avɨtkasutɨle autun. Kavɨla autun tuaŋpindandi muŋfuŋa mfoveve kɨliatɨk. ");
INSERT INTO kql_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Katɨk valatɨk Jisas kɨndɨŋmɨ suwaŋgapale avɨtɨn, wun kavɨla aututuk anañ kavik galaveve, “Ben wunu kavik wulumfu. Ŋɨn yetɨk balañjɨk tafoloŋ jusuivɨliapa. Wun katɨk avɨt. Ben wunu wuwɨ mfove waiŋgeve malaŋɨmfu.” ");
INSERT INTO kql_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","De, yiŋɨmeve, kepat wun Jisasɨtɨk ŋɨme galaveve, “Watpalaŋ.” Galavevekandi tafoloŋ jusuivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kape, de, valan Jisas wuwɨ mfoveve. ");
INSERT INTO kql_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kape, de, yetɨk Jisasɨndi toneve avɨtɨn wokok tuaŋpin yive paiyeve katɨk Gasak Wamɨle Gasak Gia Wakɨnkɨk gɨsamban. Gɨsambankɨk tuan matɨsetvɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kape, de, Jisasɨlɨn valatɨk kavik galaveve, “Ben ŋunutuk yiŋɨmala tuaŋpindandi muŋfuŋandi? Ben fumafom balañjɨk wuwaleŋgo ŋunu wuwaŋga pave ŋɨmala? ");
INSERT INTO kql_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Valu valu ŋɨn bendi Gasak Wam mfawoŋove pumbumɨk tonŋɨlali, Gotkɨk wulu mfɨtɨtiwɨ sivɨtali. Kape ben ŋunu ava wuwɨ. Kape Gotkɨk anañ moleve wulu ga pave.” ");
INSERT INTO kql_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","De, Jisasɨkɨk guŋgundan wofopɨn wunu valambe mɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","De, yetɨk mɨlɨkakɨn Jisas vañjeneve. Wun mia wataŋ ŋaikɨk kɨlɨkeve, wokok safutuk. Valan wunu wokok wuwove. ");
INSERT INTO kql_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kape wun wataŋ valambe miña muti mɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","De, kavɨla wakundukɨk autun Jisas malaŋeve Gasak Wamɨle Gasak Gia Wakɨntɨk*. Kavɨla yila Gasak Wamɨle Gasak Wakundundi* Avɨtkasundi Gotkɨk Wulu Kumbaŋgikɨk Balañjun* wofopɨn wakan mfakuŋguŋove. ");
INSERT INTO kql_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kape, de, Pitalɨn vañjene ŋɨmeve. Ganaiŋ ganaiŋ ŋɨmeve, wun. Wun katɨk Gasak Gia Wakɨnkɨk pumbum kumbaŋ gɨveve mfotkɨk pumbumɨk loveve. Wun kavɨla matamatundi wakan yisɨwɨ mɨn paŋ toneve. ");
INSERT INTO kql_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","De, kavɨla Gasak Wamɨle Gasak Wakundundi kavɨla mfakuŋguŋove balañju wofopɨn yila wulu Jisasɨkɨk safutuk mandɨve ta sivɨt pɨiyeve Jisas matve ga sɨŋgɨnmaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Autun wusandaŋɨn muwale wulu mandɨve sivɨleve wokok safutuk, kape valan wusa wulu wusa wulu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","De, yila sambɨtve muwale wulu mandɨve sivɨleve wokok safutuk. Valan kavik sivɨleve, ");
INSERT INTO kql_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ñen kavik bɨiyeve wun kavik galaveve, ‘Ŋɨn kasik kɨliandi gɨveve Gasak Wam* mfafuŋgoñakandi valu alilam yetɨk yika gɨvɨliapa. Katɨk Gasak Wamɨn kɨliandi gɨvale wam gaveka.’ ” ");
INSERT INTO kql_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kape valan wusa wulu wusa wulu sivɨleve. ");
INSERT INTO kql_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kape, de, katɨk Gasak Wamɨle Gasak Gia Wakɨn, wun vala gɨŋganɨk sambɨtve kombɨiyeve, Jisasɨtɨk, “Valan dutuk mandɨve sivɨtvale wulu sivɨtvulu aipava?” ");
INSERT INTO kql_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kape Jisasɨlɨn akolet toneve. Wun yila wulu ava galave. Kape katɨk Gasak Wamɨle Gasak Gia Wakɨn yika kombɨiyeve, “Du Krais, a? Ñen Akɨtvale Gotkɨk fakɨn du, a?” ");
INSERT INTO kql_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","De, Jisasɨlɨn kavik galaveve, “Ŋunu kasik. Yetɨk vandi ben Balañjɨkɨk Fak Gasak Pɨtɨkie Gotkɨk mamataŋ kɨlikɨk  yisɨwɨ tonmakatɨk wulapa. De, yika wulapa Wunambinɨle yaŋgɨmdi yimbumbamava.” ");
INSERT INTO kql_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","De, katɨk Gasak Wamɨle Gasak Gia Wakɨnɨn wun woven wokok wataŋ mfamɨmɨlevekandi  galaveve, “Yila wulu wokok safutuk aipandi mandɨve sivɨtva? ");
INSERT INTO kql_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ben bɨiyale wun wovenetɨk Gotoŋgo galavala wun! Ben avik juŋava? Amban avik papa?” Valan wofopɨn wunu wulukok galaveve kapekandi ga sɨŋgɨnmaŋga galaveve. ");
INSERT INTO kql_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","De, yila wunutuk susupi tuleve. Yilan wokok makɨ folevekandi paiyevekandi galaveve, “Dɨn galave, du nan paiya.” De, kavɨla matamatun wunu yive paiyeve. ");
INSERT INTO kql_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","De, Pitalɨn pumbum kumbaŋɨk gɨveve mfotɨle pumbum kumbaŋɨk mɨn paŋ toneve. Gasak Wamɨle Gasak Gia Wakɨnkɨk* luasamban melɨn wunu ŋɨme wule gaveve, “Dɨn wakan toneve, katɨk Nasaretɨle balañjɨk, Jisasɨndi.” ");
INSERT INTO kql_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kape Pitalɨn kavik galaveve, “Ŋunu kayi. Ŋɨn dɨn sivɨtvale wulu akoŋma.” De, wun salaveve pumbumɨle maikɨk maŋgɨk vevekatɨk ŋɨme sambɨtve toneve. ");
INSERT INTO kql_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","De, katɨk melɨn wunu yika wule vevekatɨk tonmale balañjutuk galaveve, “Kavɨla autukok sasɨle yetɨkɨn kasik.” ");
INSERT INTO kql_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kape Pitalɨn apɨkoŋove. De, pɨndaŋ kavɨla vevekatɨk tonmale balañjun yika wakan galaveve, “Wulu vaŋ, kavɨla autukok sasɨle yetɨk wakan, du. Dɨn Galilitɨle.” ");
INSERT INTO kql_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","De, Pitalɨn galaveve, “Muwalen Got ŋunu yakai yakai pave! Gotɨn juŋava, ŋɨn wulu vaŋu sivɨtva! Ka muwu! Ŋɨn katɨk balañjɨk akoŋma ben galavale!” ");
INSERT INTO kql_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kavik ŋaŋalambe kuŋguliŋguakavevekandi, de, kepat katɨk moañɨn alawiñkɨk maŋgɨk galaveve. De, Pitalɨn juŋavɨleve Jisasɨlɨn anañ sivɨleve wulu, “Kamfu wukan moañɨn alawiñkɨk maŋgɨk galaka mɨñakɨk gaŋgalawavi alilam dɨn ŋunu ŋaŋalambapa.” De, wun veven juŋavevekandi yekeve. ");
INSERT INTO kql_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","De, Jutatɨle balañjun yetɨk gasak wulu sivɨt pɨiaŋgapale mfa toneve. Kavɨla mfatɨle balañjun kavik toneve, Gasak Wamɨle Gasak Wakundundi* yila avɨtkasundi Gotkɨk Wulu Kumbaŋgikɨk Balañjundi* yila gasak wakundu. De, kavɨla mfatɨle balañju wofopɨn watvɨt vaŋ mfakuŋgumɨ Jisasɨkɨk safutuk mandɨvale wulu sivɨt pɨiyeve. Kapekandi Jisas kɨlɨwɨ ga ŋɨme Pailatɨk* masiveve. ");
INSERT INTO kql_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","De, Pailatɨn wunu kombɨiyeve, “Dɨn Judatɨle balañjukok juwutkasak, a?” Jisasɨlɨn wunutuk kavik galaveve, “Dɨn dasuak galava kavik.” ");
INSERT INTO kql_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","De, kavɨla Gasak Wamɨle Gasak Wakundun wulu gasakamanaŋ mandɨve sivɨleve wokok safutuk. ");
INSERT INTO kql_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kape, de, Pailatɨn wunutuk yika kavik kombɨiyeve, “Dɨn aipɨndi wulu ka sivɨtvi? Dɨn bɨiya valan wulu gasakamanaŋ mandɨve sivɨtva, dakɨk safutuk.” ");
INSERT INTO kql_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kape Jisasɨlɨn yila wulu ava bala sivɨtve. Kapendi Pailatɨn ta juŋaveve. ");
INSERT INTO kql_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","De, Pailatɨn* ŋaikɨk yia ŋaikɨk yia bɨkɨk Makatve Ga Toneve* jeñjek jiveve goŋguaŋmali valutɨle yetɨk ŋaikɨk vandi muñjɨmɨk lovale yetɨk balañjɨk valatɨk ga salaveve. Valan yetɨk balañjɨkɨk wuŋ mfapekevekandi galaveve, “Dakɨk weka. Katɨk balañjɨk ga salave.” Kapekandi Pailatɨn katɨk balañjɨk ga salaveve. ");
INSERT INTO kql_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","De, Barapas galavale avɨtɨn muñjɨm kumbaŋɨk toneve wokok sasɨle yila autundi. Valan Romɨle gavman gɨlipevekandi valambaŋga mɨn ta ŋɨlikeve. Wun mɨn ŋɨliwovekatɨk yila balañju matve ga sɨŋgɨneve. ");
INSERT INTO kql_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","De, balañjukok gumɨn Pailatɨk ŋɨme wokok anañ paveve fulak valatɨk pavaŋga yika galaveve. ");
INSERT INTO kql_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kape, de, Pailatɨn sivɨleve, “Katɨk Jutatɨle Balañjukok Juwutkasak ga salavapala, betɨk?” ");
INSERT INTO kql_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailatɨn kavik juŋaveve, kavɨla Gasak Wamɨle Gasak Wakundun mfamuñjiwɨ kapekandi Jisas wunutuk malaŋmɨ masiveve. ");
INSERT INTO kql_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kape kavɨla Gasak Wamɨle Gasak Wakundun mfakuŋgumɨ toneve mfani sivɨleve Barapas valatɨk ga salavaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","De, Pailatɨn yika galaveve valatɨk, “Ŋɨn avik pavapa, katɨk ben Jutatɨle Juwutkasak galavale avɨtɨk?” ");
INSERT INTO kql_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kape valan yika towok sivɨleve, “Wunu apɨvɨtipe matve dɨŋguakumfu mamatawi muŋɨk!” ");
INSERT INTO kql_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","De, Pailatɨn kombɨiyeve, “Aipandi? Wun gɨtɨk yaka wulu pavandi amban wunu matvaga?” Kape valan yikali yikali towok sivɨleve, “Wunu apɨvɨtipe matve dɨŋguakumfu mamatawi muŋɨk!” ");
INSERT INTO kql_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","De, Pailatɨn bɨkɨk kumbaŋgi ga mfɨliñjiwɨkaŋga pave masiveve Barapas valatɨk. Kavik pavevekandi Jisas towok yakakai ga paiyevekandi matamatutuk masiveve wunu mamatawi muŋɨk apɨvɨtipe matve dɨŋguakaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","De, kavɨla matamatun Jisas malaŋeve bɨkɨk gavman mfotɨle pumbum kumbaŋɨk. Malaŋevekandi bɨkɨk yila matamatu wofop ga yiŋɨmaŋga galaveve. ");
INSERT INTO kql_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","De, yiŋɨmevekandi valan kavik muwɨ apɨpɨlaive fofonombeve, valan tɨliŋ wataŋ ga kuwove Jisasɨtɨk. Kape valan yetɨk yisakɨk wulakɨndi woŋ woŋove Juwutkasakɨk muwakiŋ ambandave Jisasɨkɨk fopɨk apɨkuwove. ");
INSERT INTO kql_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pavevekandi wunu maiyawɨ akɨtve galaveve, “Yakamɨtka avɨt! Jutatɨle Juwutkasak! Yiŋɨnɨmbala?” ");
INSERT INTO kql_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","De, valan muŋpati fopɨk pai paiyeve. Yilan susupi tuleve wunutuk. Yilan vandamfufundi mandɨve wunu akɨleve. ");
INSERT INTO kql_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Maiyawɨ balakevekandi tokoiyeve tɨliŋ wataŋ wunutɨle. De, wovenekɨk wataŋu ga kuwove yika. Ga kuwɨ balakevekandi malaŋeve wunu mamatawi muŋɨk apɨvɨtipe matve dɨŋguakaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yetɨk Sairini galavale watɨkɨle Saimon galavale balañjɨkɨn, wokok fu alawiñ, Aleksandandi Lufus. Wun Jerusalemɨk apɨsalavaŋga ŋɨmeve. Apɨsalave ŋɨmevekatɨk yila matamatun wunu apɨsukuve ga afufɨlive malaŋeve Jisasɨkɨk mamatawi muŋ. ");
INSERT INTO kql_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Valan Jisas Golkota galavale mɨtɨk malaŋeve. Ambɨkɨk balaŋdi katɨk wuŋ, Golkota, kavik galava, “kikiak fop.” ");
INSERT INTO kql_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Valan waindi yetɨk myr galavale merasin balakandaŋmɨ suwove maŋam ta masiveve. Wun ava jive. ");
INSERT INTO kql_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","De, valan wunu apɨvɨtipe matve dɨŋguakave mamatawi muŋɨk, ga sɨŋgɨnmaŋga pave. Apɨvɨtipe matve dɨŋguakavekandi wokok valan anañ tokiyeve wataŋu yiveve. Valan busuak satu paveve kavɨla wataŋu yivaŋga. ");
INSERT INTO kql_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","De, 9 klok watvɨt wunu apɨvɨtipe matve dɨŋguakave. ");
INSERT INTO kql_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Valan wokok wunu ga sɨŋgɨnmaŋgapale wulu kavik moleve, “Jutatɨle balañjukok Juwutkasak.” ");
INSERT INTO kql_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","De, valan fumafumu alawiñ wokok apɨvɨtipe matve dɨŋguakave wunundi, mamataŋɨk yetɨk, aŋgataŋɨk yetɨk. ");
INSERT INTO kql_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","De, aŋgapat kaipatɨk ŋɨmale balañjun wutve gumon gumonme maiyakeve kavik, “Ayu, dɨn katɨk Gasak Wam* pɨlimakandi yika valu alilaŋguaŋdi gɨvɨliapale balañjɨk, ");
INSERT INTO kql_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","dɨn daven mayilave katɨk mamatawi muŋ valambe bumbe!” ");
INSERT INTO kql_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kavɨla Gotkɨk Wamɨle Gasak Wakundundi*Gotkɨk Wulu Kumbaŋgikɨk Balañjun*, valan busuak kavik galaveve, “Wun yila balañju yive sukvɨleve, kape wun wovene avik papa? Ka balawɨ. ");
INSERT INTO kql_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wun Krais*, Israeltɨle balañjukok juwutkasak tonmalen, mamatawi muŋ ga valambe bumbe, kamfu kamfu. Kavik pavalen ñen wutve yive suwapa.” De, kavɨla wakan apɨvɨtipe matve dɨŋguakave fumafumu balañju valan wakan wunu maiyakeve. ");
INSERT INTO kql_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","De, valɨn vavaŋ kalakevekandi valɨn mfatɨndɨmeve. Mɨta mɨta wofop mfatɨndɨmeve. De, valɨn 3 klok tonevendi, yika apɨkowove. ");
INSERT INTO kql_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","De, Jisasɨlɨn 3 klok vasisakti towok joŋmɨ galaveve, “Eloi, Eloi, lama sapaktani?” Ambɨkɨk balaŋgi kavɨla wulu kavik galava “Ŋakɨk Got, ŋakɨk Got, ŋunu aipandi mfalakaiva?” ");
INSERT INTO kql_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Joŋovekandi yila vevekati sambɨtvale balañjun bɨiye kavik galaveve, “Bɨiye, Elaija* joŋma, wun.” ");
INSERT INTO kql_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","De, ŋaikɨkɨn jaŋmɨ ŋɨme, yetɨk spans wain suwove, guñi Jisasɨkɨk mamaliŋɨk mandɨve ga jivaŋga paveve. Pavevekandi galaveve, “Jile, wutvaŋga. Elaijalɨn yiŋɨmamati wunu sepewaŋga.” ");
INSERT INTO kql_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kape Jisasɨlɨn yika towok joŋovekandi sɨŋgɨneve. ");
INSERT INTO kql_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","De, katɨk Gasak Wam* kumbaŋɨle papalai palaiyeve wataŋɨn wunambini jikvɨkɨ bumbeve mañjikatɨk. Kapekandi daŋgi alawiñ. ");
INSERT INTO kql_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","De, Jisas vevekati toneve matamatkasakɨn Jisasɨkɨk sɨŋgɨneve wulu wulevekandi, de, wun kavik galaveve, “Wulu vaŋu, wun Gotkɨk fak tonmale.” ");
INSERT INTO kql_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","De, yila meandun ganaiŋgafak sambɨtve wuleve Bɨkɨk gɨŋganɨle yila aliluaŋguaŋɨn kavik toneve, Malia alawiñɨn toneve, yetɨk Maktala galavale watɨkɨle, yetɨk Jemsɨndi Josepkɨk wome. Katɨk yetɨk melɨn Salome galava. ");
INSERT INTO kql_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Valan Galiliti Jisas vañjenme matɨkokolekeve. Valan yila meandu wusandaŋdi Jerusalemɨk ŋɨmeve wunundi. ");
INSERT INTO kql_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Katɨk Yisɨ Tonimbale Valɨn* wulak tonapa. Kapekandi lua wofop pavaŋgapale valɨn kamfu. De, valɨn mfatɨndɨmaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kavik toneve, de, Josepɨn, wun Arimatea galavale watɨkɨle avɨt. Yila balañjun juŋaveve wun anafa wakɨn toneve. Wun jiñjit toneve balañju wofopɨn Got lolomɨk tonmale va. Kapekandi wun wokok kumbaŋ apɨtowɨ Pailatɨk* ŋɨmevekandi Jisas sɨsɨŋgɨn kombɨiyeve, guamɨk mandɨvaŋga pave. ");
INSERT INTO kql_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","De, Pailatɨn kavik bɨiyeve Jisasɨlɨn anañ sɨŋgɨnmale. Kapekandi wokok kumbaŋɨn kambekeve. De, matamatkasak ga yiŋɨme kavik kombɨiyeve “Jisasɨlɨn anañ sɨŋgɨnmalea?” ");
INSERT INTO kql_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailatɨn matamatkasakɨk maŋgɨk bɨiyevekandi, wun Josep apɨsukuve ga ŋɨme yiveve Jisas sɨsɨŋgɨn. ");
INSERT INTO kql_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kapekandi Josepɨn kuŋgum wataŋ wusukeve. Wusukevekandi Jisas sɨsɨŋgɨn sepekvɨlevekandi wataŋdi mfolevekandi yetɨk yowove mɨndɨmfot guamɨk mandɨveve. Kavik pavevekandi yetɨk gasak mɨndɨm kɨndɨŋmɨ malaŋmɨ guamɨle maŋgɨk matɨkiŋeve. ");
INSERT INTO kql_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","De, Maria alawiñ, yetɨk Maktalatɨle, yetɨk Josepkɨk wome, valan katɨk mandɨveveka wuleve. ");
INSERT INTO kql_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","De, katɨk Yisɨ Tonimbale Valɨn* balakevekandi, Malia alawiñɨñ, yetɨkɨn Maktalatɨle, yetɨkɨn Jemsɨkɨk wome, valandi katɨk yetɨk melɨn Salome, kavɨla meandu alilaŋguaŋɨn Jisas sɨsɨŋgɨn mulumbaŋgapale anafak kosɨmbɨiye lua wusukeve. ");
INSERT INTO kql_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kapekandi valɨn tɨwɨ balakevendi katɨk wisɨle fopɨle vandi valan guamɨk ŋɨmeve. ");
INSERT INTO kql_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Valan busuak ŋɨndiŋ ŋɨndiŋ sivɨt ŋɨmeve kavik “Amba nan matɨkokolewɨ guam maŋgɨk matɨkiŋeve mɨndɨm apɨkɨndɨŋapa?” ");
INSERT INTO kql_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Katɨk mɨndɨmɨn gasak vaŋ toneve. Sivɨlevekandi de, valan wuleve katɨk gasak mɨndɨm anañ apɨkɨndɨŋeve. ");
INSERT INTO kql_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","De, valan lovevekandi guam kumbaŋɨk wuleve mɨlɨkak. Wun mamataŋ daŋɨk yisɨwɨ toneve. Wokok papaikasak wataŋɨn kɨliak. Kavik wulevekandi bɨkɨk kumbaŋgin towok kambekeve. ");
INSERT INTO kql_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Katɨk mɨlɨkakɨn valatɨk kavik galaveve, “Bikɨk kumbaŋgin towok kambewandu. Ben katɨk Nasaletɨle Jisas yiŋɨme mamfova. Wun katɨk valan anañ apɨvɨtipe matve dɨŋguakave avɨt. Kape wun mɨñakɨk. Wun anañ kambewɨ ŋɨmale. Wutve, kasik mɨtɨn kasik valan wunu mandɨveve. ");
INSERT INTO kql_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kape ben dalaŋɨme. Wokok guŋgundatɨk, Pita wokotok, valatɨk kavik galavumfu, ‘Wun wandefaka Galilitɨk ŋɨma. Ben kaukatɨk wulapa.’ Wun anañ betɨk miyakavik galaveve.” ");
INSERT INTO kql_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kape, de, kavɨla meandun salave mɨleve guami. Bɨkɨk kumbaŋgin kambekevekandi pɨpɨkeve. Kapekandi valan yila balañjutuk wulu ava sivɨtve. Towok valaiyeve. ");
INSERT INTO kql_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisasɨlɨn katɨk wusɨle fopɨle vandi kambekeve, watvɨt vaŋ. Wandefaka katɨk Maktala galavale watɨkɨle Malialɨn wunu wuleve. Jisasɨlɨn anañ katɨk metɨle 7 sulak yakakale sañjaŋeve. ");
INSERT INTO kql_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jisasɨndi ŋɨmeve balañjun baŋgaivɨkɨ yekevekatɨk Malialɨn valatɨk ŋɨme galaveve. ");
INSERT INTO kql_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Malialɨn kavik galaveve, “Jisasɨlɨn yika alilekalak tonma! Ŋɨn wutva!” Kape valan ava bɨiye juŋave. ");
INSERT INTO kql_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","De, pɨndaŋ yila autu alawiñɨñ yetɨk watɨkɨk ŋɨme masi ŋɨmevekatɨk Jisas wuleve, kape wokok momolika waiŋgeve ava wutve. ");
INSERT INTO kql_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Valan wokok guŋgundatɨk ŋɨme galaveve katɨk wulu, kape valan ava bɨiye. ");
INSERT INTO kql_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pɨndaŋ wokok 11 guŋgundan jeñjek mfakuŋgumɨ jivevekatɨk Jisasɨlɨn valatɨk yiŋɨmeve. Wun vavawa mandɨñiŋmɨ sivɨleve, valan wulu ava bɨiye, bɨkɨk kumbaŋgin apɨvɨtipe toneve, kapekandi Jisas yika wutve galaveve balañjukok maŋgu ava bɨiye. ");
INSERT INTO kql_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De, wun valatɨk kavik sivɨleve, “Ben wofopɨn kasik mañjikatɨk wolokuakɨk dalaŋɨmisaka ŋakɨk wulu anafu sivɨtva sivaŋgo. ");
INSERT INTO kql_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wulu yive suwɨ, kape maŋam bumbale balañju Gotɨn yika yivapa. Kape Gotkɨk wulu yive susuka miyakɨk balañju Gotɨn vala yakai yakai papa. Vala ka yivapayi. ");
INSERT INTO kql_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kavɨla Ga Juŋavaŋgapale Gotkɨk Pɨtɨkie Gasak Wulu ŋunu yive suwale balañjundi tonapa. Valan ŋakɨk wuŋdi yila sulak yakakale sañjaŋapa. Valan yila kuŋgum balaŋdi wulu sivɨlapa. ");
INSERT INTO kql_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Valan gaŋgaliŋ maikasu mfovapa. Valan yila gaŋgaliŋ maŋam jivalen, yakakale ka tonapayi. Valan bɨkɨk kɨlia mamalɨkiye balañjutuk mandɨvindi kavɨla mamalɨkiye balañjun anafak tonapa.” ");
INSERT INTO kql_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisasɨlɨn valatɨk wulu sivɨtve balakevendi Gotɨn wunu yive malaŋkɨveve Hevenɨk. Jisasɨlɨn kaukatɨk Gotkɨk mamataŋ kɨlikɨk yisɨkeve. ");
INSERT INTO kql_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","De, valan mɨta mɨtatɨk ŋɨme Jisasɨkɨk sak sivɨleve. Gasak Wakɨnkɨk Sulakɨn wakan ŋɨmevekandi yila Ga Juŋavaŋgapale Gasak Pɨtɨkie Wulu paveve bɨkɨk wulundi. ");
ALTER TABLE kql_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
