﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqf_vpl;
CREATE TABLE kqf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqf_vpl WRITE;
INSERT INTO kqf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Keliso ena magumagula ba niga taudidi: Tana ba Ḡalibona Deivida damnemo i tubuḡa, bi Deivida ba Eiblaḡam damnemo i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bi Eiblaḡam natuna ba Aisik, bi Aisik natuna ba Deikap. Bi Deikap natunatuna ba Diuda matasitasina. ");
INSERT INTO kqf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Bi Diuda natunatuna ba Peles bi Sela, bi tinedi ba Tama. Bi Peles natuna ba Eslon, bi Eslon natuna ba Lam, ");
INSERT INTO kqf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","bi Lam natuna ba Aminadab, bi Aminadab natuna ba Nason, bi Nason natuna ba Salmon, ");
INSERT INTO kqf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","bi Salmon natuna ba Boas, bi Boas tinana ba Leiḡeb. Bi Boas natuna ba Obedi, bi Obedi tinana ba Luti. Bi Obedi natuna ba Diyesi. ");
INSERT INTO kqf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Bi Diyesi natuna ba Ḡalibona Deivida. Deivida natuna ba Solomon bi Solomon tinana mba Uliya ena vesala. ");
INSERT INTO kqf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Bi Solomon natuna ba Leḡobom, bi Leḡobom natuna ba Abida, bi Abida natuna ba Asa. ");
INSERT INTO kqf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Bi Asa natuna ba Deḡosafet, bi Deḡosafet natuna ba Diyolam, bi Diyolam natuna ba Usaiya. ");
INSERT INTO kqf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Bi Usaiya natuna ba Diyotam, bi Diyotam natuna ba Eiḡes, bi Eiḡes natuna ba Esekaiya. ");
INSERT INTO kqf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Bi Esekaiya natuna ba Manasi, bi Manasi natuna ba Amon, bi Amon natuna ba Diyosaiya. ");
INSERT INTO kqf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Bi Diyosaiya natuna ba Dekonaiya matasitasina. Tedi edi laḡannmo Islael lavedi matabudi a pani nawedi Babilonmo te ḡome a miya. ");
INSERT INTO kqf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonmo a miyamiya bi Dekonaiya natuna Seyatel i tubuḡa. Bi Seyatel natuna ba Selubabel. ");
INSERT INTO kqf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Bi Selubabel natuna ba Abiuda, bi Abiuda natuna ba Eliyakim, bi Eliyakim natuna ba Aso. ");
INSERT INTO kqf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Bi Aso natuna ba Sadok, bi Sadok natuna ba Akim, bi Akim natuna ba Eliuda. ");
INSERT INTO kqf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Bi Eliuda natuna ba Eliyesa, bi Eliyesa natuna ba Matan, bi Matan natuna ba Deikap, ");
INSERT INTO kqf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","bi Deikap natuna ba Diyosep. Bi Diyosep ba Meli mwanena. Meli, tana Yesu Keliso i bewa. ");
INSERT INTO kqf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Niga tubulelesina ba wapana 14 nove Eiblaḡam lisinemo te i saḡa Deivida lisinemo. Bi Deivida lisinemo te a nawedina Babilon biliwelokonemo ba kota tubulelesa wapana 14. Babilonmo te i saḡa Yesu Keliso ena laḡannimo kota mainana wapana 14. ");
INSERT INTO kqf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keliso muliḡa kaka i tubuḡana, bi dolinemo kauwa niga mainana i tubuḡa: Yesu tinana Meli tana Diyosep i waitauye. Bi muliḡa kaka a miya labuna bi lava a kita te Meli i bwaga, tana Aluwa Waiyawemo i bwaga. ");
INSERT INTO kqf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Meli mwanena Diyosep ba didimana lavana. Bi mote i ḡoye te lava matedimo maso Meli i voiye te i waitunimayaḡa, taunana aubaina noponemo waigose i noḡoti. ");
INSERT INTO kqf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Diyosep mainana i wainuwanoḡonoḡota ba Bada ena aneya laubonimo lisinemo i laumaḡata bi i giuwena gado, “Diyosep, Deivida natuna, mote kuma naila, Meli kwa vai te tam mwanem, banina Meli ba Aluwa Waiyawa ena ḡailisimo i bwaga. ");
INSERT INTO kqf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tana kaka gomana olotona ya bewa bi tam kwai isana Yesu, banina tana ena lava kaka edi gebogebomo yai yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Niga kauwidi matabudi ba Bada wala taugiuwatana lisinemo i giugiuwena mainana a tubuḡa: Taugiuwatana niga mainana i giu, ");
INSERT INTO kqf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Totop a kaka ya bwaga bi gomana olotona ya bewa, bi sai isana Imanuwel.” Isa Imanuwel banina “Maimaituwa tada vaiteda.” ");
INSERT INTO kqf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Laḡannemo Diyosep i kenakena moito, ba Bada ena aneya bai i giugiuwena mainana i voiye, tana Meli i vai te mwanena. ");
INSERT INTO kqf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Diyosep Meli vaitena mote tubuḡa ai ḡemoti, eete Meli gomana olotona i bewa. Bi Diyosep mba gomenina i wai isana “Yesu.” ");
INSERT INTO kqf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ḡalibona Alodi ena laḡannimo, Diudiya noponemo Betliḡem malagainemo Yesu i tubuḡa. Mulinemo nuwauyauya lavedi suwala ena anilovotava yawaninaḡa a nato Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bi ai talana gado, “Gomana ḡaubona Diu edi ḡalibona bamo ḡome i tubuḡa? Tama suwala ena anilovotavamo, gomana ena kipola ke kita te lauduneyena aubaina ke nato.” ");
INSERT INTO kqf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Laḡannemo Ḡalibona Alodi niga giuna i vaivaiye, ba nuwana i yapuyapu. Bi lava matabudi Yelusalemmo kota mainana. ");
INSERT INTO kqf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mba ḡome tana pilisi edi babada bi waiḡake tauwailovelovena matabudi i waiḡemotidi bi i waitalayedina gado, “Keliso bamo ḡome ya tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bi tedi giu ai munena gado, “Diudiya noponemo Betliḡem malagainemo ya tubuḡa.” Banina taugiuwatana i gilugilumina ba niga mainana, ");
INSERT INTO kqf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Tam Betliḡem Diudiya dobunemo, tam mote malagai yababa, Banina temi Betliḡem lavemi nopomimo kaka ḡemota ya tubuḡa, bi tana kaka yai bada bi egu lava Islael ya labedi.” ");
INSERT INTO kqf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ḡome Alodi nuwauyauya lavedi kandavonemo i waiḡemotidi bi i waitala kaukauwedi te bai sauginemo kipola i laumaḡata te a kita. ");
INSERT INTO kqf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ḡalibona nuwauyauya lavedi i giukamaḡedi te sa nawa Betliḡemmo bi i giuwedina gado, “Ko nawa bi koi tavutavu kauwa te mba gomenina ko banavi. Laḡannemo, kona banavina ba ko tava munaḡa te ko giuwegu te tagu kota yà nawa bi yà lauduneye.” ");
INSERT INTO kqf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tedi ḡalibona ena giu a vaiye mulinemo ba nawa ai tubu. Bi kipolina a kitakitana taunana a vawata, eete bamo gomana i tubutubuḡanemo ḡome kipola i vamoito. ");
INSERT INTO kqf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Laḡannemo kipolina a kitakita, ba ai nuwavisu gulata. ");
INSERT INTO kqf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bi vanuwemo a tavatava, ba gomana matinana Meli a kitedi. Ḡome tuwapekedi ai tupagwaliḡedi bi gomana a lauduneye. Tedi edi puyo a kaikamaḡedi bi gomana a puyona ba goldimo, piupiumo bi Maelamo. ");
INSERT INTO kqf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mba kauwina mulinemo Maimaituwa laubonimo nuwauyauya lavedi i giuwedi te mote sima munaḡa Alodi lisinemo. Taunana aubaina tedi eta ḡesauna a kaiwata te a munaḡa edi dobumo. ");
INSERT INTO kqf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nuwauyauya lavedi a nawanawa mulidimo, Bada ena aneya laubonimo Diyosep lisinemo i laumaḡata bi i giuwena gado, “Kwa moito, gomana kwa bewa bi tinana vaitena ko naila ko nawa Idip. Bi ḡome ko miyamiyana eete laḡannemo yà giuwemina kaka ko munaḡa, banina ba Alodi gomana ya tavutavuḡe te yai peki.” ");
INSERT INTO kqf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kamaina bi Diyosep i miya moito, gomana i bewa bi tinana vaitena dudubalemo malagai a gose bi a nawana Idip. ");
INSERT INTO kqf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bi tedi Idipmo a miyamiyana eete Alodi i peki. Niga kauwina ba Bada wala taugiuwatana i giugiuwena mainana i tubuḡa. Taugiuwatana i giuna gado, “Natugu Idipmo i miyamiya bi e kapotiyovo.” ");
INSERT INTO kqf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bi laḡannemo Alodi i kita te nuwauyauya lavedi mote lisinemo a tava munaḡa ba edi giu i noḡoti bi nuwana i medi gulata. Taunana aubaina, tauwaiḡaviya i giukamaḡedi te Betliḡem bi diyadiyana malagaidi matabudi nopodimo, libilibi oloolotodi edi kwalabu labu bi i yovoyovona matabudi sai pekidi. Niga kauwina a voiyena ba, mba laḡannemo nuwauyauya lavedi kipola a kita bi Alodi a giugiuwena i noḡoti waitete te a kaiyovuḡe taunana aubaina ḡaviḡaviyidi i giukamaḡedi te libilibi oloolotodi matabudi sai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Te taugiuwatana Delimaiya wala bai i giugiuwena mainana i tubuḡa. Tana i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lama malagainemo, lava peki saledi a salesaleyedi ba edi nuwaboya i dididiga gulata. Leitsel natunatuna ya ḡabeḡabedi, banina natunatuna matabudi a peki kovi bi tana mote ḡemoḡemotina te sai nuwauba.” ");
INSERT INTO kqf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Alodi i peki mulinemo ba Idipmo Bada ena aneya laubonimo Diyosep lisinemo i laumaḡata ");
INSERT INTO kqf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","bi i giuwena gado, “Kwa moito, gomana matinana kwai dolidi bi ko munaḡa Islael dobunemo. Banina tedi mabai gomana waipekina a ḡoyeḡoyena, ba lavedi a peki kovi.” ");
INSERT INTO kqf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kamaina bi Diyosep gomana matinana i waidolidi te a munamunaḡa Islael dobunemo. ");
INSERT INTO kqf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bi i vaiye te Akilas tamana Alodi gabuna i vai te Diudiya plovinsna i waiwaibadaye, ba Diyosep ḡome nawa i naila. Bi aneya laubonimo Diyosep i giuwe te ya nawa Galili plovinsnemo. ");
INSERT INTO kqf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kamaina bi tedi a nawa Nasalet malagainemo a miya. Bi Taugiuwatana wala bai a giugiuwena mainana i tubuḡa, “Te tana sai isana Nasalet lavana.” ");
INSERT INTO kqf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mba laḡandimo Diyon taukabulu Diudiya plovinsnemo i tava bi kalakalalelemo i laulauguguya. ");
INSERT INTO kqf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tana i laulauguguyana gado, “Emi noḡota ko vitaledi bi emi gebogebo ko kuvesidi, banina Mala ena waibada kaikana i tava.” ");
INSERT INTO kqf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Taugiuwatana Aisaiya wala Diyon taukabulu i giugiuwatana gado, “Lava kalakalalelemo ya binabinauna gado, ‘Bada ena eta ko yawasi bi ko kadidimani.” ");
INSERT INTO kqf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Diyon ena gala ba kamelo kapalina vatuvatulina i kotekote. Bi ena tagilolo ba ḡamoḡamo kwapina bi kanaya ba kapau bi iwavi. ");
INSERT INTO kqf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lava wapewapedi Yelusalemḡa, Diudiya plovinsna bi Diyodan dobuna lavedi matabudi a tava Diyon lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ḡome edi gebogebo matabudi a kuvesidi bi tana Diyodan gaubinemo i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bi laḡannemo Diyon lava i kakabuludi bi i kita te ḡome Palisi bi Sadisi wapewapedi a natonato ba niga mainana i giuwedi, “Temi mwata salama natunatuna! Temi aiyai i giuwemi te Maimaituwa ena kovoḡa ya natonatona ko vola kamaḡe? ");
INSERT INTO kqf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kona laulaukuvasana ba miyamiyana ko miyae te ta kita bi ta sibe. ");
INSERT INTO kqf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bi mote komai noḡota bi koma giu gado, ‘Tama Eiblaḡam ena tubulelesa, taunana aubaina mote bai gebogebona kaka lisimaimo ima tubuḡa.’ Yà giugiuwemi te Maimaituwa ba ḡemoḡemotina niga ḡakimidimo Eiblaḡam ena tubulelesa yai tubudi. ");
INSERT INTO kqf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Maimaituwa kaikana kai lamlamdimo ḡadivi i sako te bamo kaidi mote sima votavota kauwa ba matabudi ya oi kamakamaḡedi, ya douḡavuḡavukidi bi kaimo yai kalaḡosedi. ");
INSERT INTO kqf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Tagu gaubemo yà kakabulumi te ko sibe te kaikana kona laukuvasa. Bi lava muliguḡa ya natonatona ba i saḡa gulatana kaka tagu. Bi tagu mote yà visu te ena kaḡesuma yà avala. Tana kaka Aluwa Waiyawemo bi kaimo ya kabulumi. ");
INSERT INTO kqf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tana kaka lava visuvisudi bi gebogebodi ya dailidina maibena lava laisi ya tututuna. Bi yavalemo ya ḡini te kwapidi ya suve waipaipailidi tabudimo sa nawa bi banidiḡa sa kena. Tana laisi banidiḡa ya legaudi te ena vanuwemo ya sivudi bi kwapidi kai kalakalati nonoḡinemo yai naḡasa nawedi.” ");
INSERT INTO kqf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kamaina bi Yesu Galiliḡa i nato Diyoudan gaubinemo, te Diyon Yesu ya kabulu. ");
INSERT INTO kqf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Diyon i ḡoyeḡoye te Yesu ena noḡota maso i vitale bi i giuwena gado, “Tam maso tagu kuna kabulugu. Bi geḡa te tam kuna natona tagu lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bi Yesu Diyon ena giu i waimunena gado, “Geḡa, mba kamaina. Niga ba Maimaituwa ena ḡowana, kamaina te didimana kauwidi matabudi ta voiyedi te Maimaituwa ena waiyawasana ta kamaḡati.” Ḡome ba Diyon i waianina. ");
INSERT INTO kqf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kamaina bi Diyon Yesu i kabulu bi i lovolovotava ba mala i nuwawasa. Mba taunana te Maimaituwa Aluwina i yovona dabanemo maibena gabubu. ");
INSERT INTO kqf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bi kalina malaḡa i yovona gado, “Niga taunana tagu natugu nuwagu tauvaina, yà wainuwavisuye.” ");
INSERT INTO kqf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kamaina bi Aluwa Waiyawa Yesu i waidoli nawe kalakalalelemo te Seitan Yesu yai laulubu. ");
INSERT INTO kqf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu ḡome, suwala 40 bi dudubala 40 i udi, mulinemo ba kani i peki. ");
INSERT INTO kqf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tauwailaulubu Yesu lisinemo i tava bi i giuwena gado, “Bamoda tam Maimaituwa Natuna, ba niga ḡakimidi kwa giuwedi te saila buledi.” ");
INSERT INTO kqf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bi Yesu ena giu i waimunena gado, “Gilugilumina wadubonemo niga mainana i giu: ‘Lava mote buledi taunaḡa yasinemo ima miya, bi Maimaituwa giunemo ya miya.” ");
INSERT INTO kqf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ḡome te Seitan Yesu i waidoli nawe Yelusalem, taun dididiga waiwaiyawinemo bi Maimaituwa ena vanuwa dabaotinemo i giuwe te i moito. ");
INSERT INTO kqf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bi i giuwena gado, “Bamoda tam Maimaituwa Natuna, ba taumḡa kwai ḡiutaluim, banina gilugilumina wadubonemo niga mainana i giu: ‘Maimaituwa ena aneya ya giukamaḡedi te tam sa labem, bi nimedimo sa kamotim te ḡakimemo mote kaḡem kumai kelo.” ");
INSERT INTO kqf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu, Seitan ena giu i waimunena gado, “Gilugilumina wadubonemo kota niga mainana i giu.” “Bada, em Maimaituwa mote kumai laulubu.” ");
INSERT INTO kqf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ḡome Seitan, Yesu i waidoli nawe oya lofalofana daba otinemo bi dobu matabuna ena waiguyau wainuwavaivaidi matabudi Yesu i wailove ");
INSERT INTO kqf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","bi i giuwena gado, “Bamoda tam kwa lauduneyeguna ba niga mwalidi matabudi yà vitem.” ");
INSERT INTO kqf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bi Yesu giu i waimunena gado, “Seitan, ku nawa tabummo banina, gilugilumina wadubonemo niga mainana i giu: ‘Bada, em Maimaituwa taunaḡa kwa lauduneye bi aubaina kwa noya.” ");
INSERT INTO kqf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ḡome Seitan Yesu i gose kamaḡe bi aneya a yovo te a sagu. ");
INSERT INTO kqf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Laḡannemo Yesu i vaiye te Diyon biliwelokomo a sako nawe ba tana i munaḡa Galili dobunemo. ");
INSERT INTO kqf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tana Nasalet i gose bi i nawa Kapeniyammo i miya. Kapeniyam ba Galili topana diyanemo, dobu Sebulun bi Naptali nopodimo. ");
INSERT INTO kqf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Niga ba taugiuwatana Aisaiya bai i giugiuwena mainana i tubuḡa. Tana i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Dobu Sebulun bi Naptali ba Galili topana etana diyanaḡa. Dobuna Galili ba eteni lavedi edi animiya. ");
INSERT INTO kqf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bi lava mabai waidudubalemo sa miyamiyana, kaka yanayana dididiga sa kita. Tedi mabai peki boimatuwinemo sa miyamiyana kaka yanayana ya laiyanedi.” ");
INSERT INTO kqf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mba sauginemo te noke i nawana ba Yesu lauguguya i waitubuna gado, “Emi gebogebo ko kuvesidi, banina Maimaituwa ena waibada kaikana nuwana tava.” ");
INSERT INTO kqf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili topana diyanaḡa i nawanawa ba olooloto labu i kitedi, Saimon a waiisana Pita bi tasina Endulu. Tedi topamo a gomogomo, banina tedi taugomogomo. ");
INSERT INTO kqf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ḡome Yesu i giuwedina gado, “Ko nato, ko kaiwatagu bi yài lovelovemi te lava ko konedi.” ");
INSERT INTO kqf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Noi taunana te edi gomo a gosedi bi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ḡome a modina a nawanawa ba kota olooloto labu i kitedi, Diyemesi bi tasina Diyon, tedi ba Diyebedi natunatuna. Tedi tamedi Diyebedi vaitena wagamo a miya bi edi gomo a kakavisuvisudi. Bi Yesu i giuwedina gado, “Ko nato, ko kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Noi taunana te tamedi bi edi waga a gose kamaḡedi bi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili dobuna noponaḡa i nawa bi bolu vanuwidiḡa i waiwailovelove bi Maimaituwa ena waibada giuna visuvisuna i laulauguguyae. Bi lava edi sida tabudi bi tabudi a legalegaudina i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bi Yesu giuna Sailiya dobuna i nawa yaḡosi, bi ḡome lava edi sida tabudi bi tabudi a tavaitedi Yesu lisinemo. Lava ḡesaudi yavi nananakidi a legalegaudina, ḡesaudi aluwa gebogebodi a sunesuneidina bi ḡesaudi kaḡenuwakududi, matabudi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bi lava kumdi Galiliḡa, Dekapolisḡa, Yelusalemḡa, Diudiyaḡa, Diyoudan bi noi nevana lavedi a tavatavana vaitedi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Laḡannemo Yesu lava kumdi i kitekitedi, ba tana i saḡa i nawa oya dabanemo bi i miyatulu. Ḡome ena tauwaikaiwatana lisinemo a tava ");
INSERT INTO kqf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","bi wailovelovedi i waitubuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Temi mabai nuwemi tabutabunemo Maimaituwa ena waibada ko ḡoyeḡoyena ba koi nuwavisu, banina temi kaka Mala ena waibada ya yovo bi yai badayemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Temi mabai nuwemi tabutabunemo yawasana aubaina ko ḡabaḡabana ba koi nuwavisu, banina temi kaka Maimaituwa yai nuwaubemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Temi mabai ḡaubo munaḡemo ko miyamiyana ba koi nuwavisu, banina temi kaka dobu matabuna koi taniwagaye. ");
INSERT INTO kqf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Temi mabai didimana ko ḡoyeḡoyena Maimaituwa kaka emi ḡowana ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Temi mabai lava taulaunuwatoiyedi ba koi nuwavisu, banina temi kaka Maimaituwa ya launuwatoiyemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Temi mabai nopomi kakasabusabudi ba koi nuwavisu, banina temi kaka Maimaituwa ko kita. ");
INSERT INTO kqf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Temi mabai nuwauba tauvoiyena ba koi nuwavisu, banina temi kaka Maimaituwa yai kawa natunemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Temi mabai didimana ko voivoiye bi lava sa laulaukivigebogeboyemina ba koi nuwavisu, banina Mala ena waibada kaka ya yovo bi temi yai badayemi. ");
INSERT INTO kqf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Temi mabai lava sa giu waiyovoyovomi, sa laukivigebogeboyemi bi giu kaikaiyovudimo sa waiwavumi, banina temi tagu taukaiwatagu ba koi nuwavisu. ");
INSERT INTO kqf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Temi koi nuwavisu bi ko yasisi, banina emi mai'ia dididiga malamo ya kenakena. Bi ko sibe te lava ḡesaudi wala mainana taugiuwatana a laulaukivigebogeboyedi. ");
INSERT INTO kqf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Temi ba maibena lava edi soliti. Bamoda soliti dinina i kovina, ba bainewa ko voiye bi yaila soliti munaḡa? Kamaina te mba solitina i gebogebo, te lava kaka sa pwalaḡe bi sa vawaidoḡadoḡa. ");
INSERT INTO kqf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Temi ba maibena yanayana dobu lavedi lisidimo. Laḡannemo oya dabanemo taun a ḡalana ba mote ḡemoḡemotina ima kandavona. ");
INSERT INTO kqf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kauwina ḡemotina lava mote lampa ima gabu bi gulewa dibunemo ima sako nawe, geḡa te tana lampa ya gabu te ena animoitomo yai moito te vanuwa noponemo lava matabudi ya laiyanedi. ");
INSERT INTO kqf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Temi kota mainana kauwa visuvisudi ko voiyedi te lava sa kitemi bi Tamemi malamo isana sa kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Komai noḡota bena tagu e natona ba Mousis ena waiḡake bi taugiuwatana edi wailovelove yàma kaikamaḡedi. Tagu e natona ba waiḡake banidi yà kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yà giugiu kauwemi te mala bi dobu sa launeḡaneḡa bi waiḡake ḡemota mote ima launeḡaneḡa eete waiḡake bai i giugiuwedina matabudi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Taunana aubaina, tam aiyai waiḡake ḡaubo otina kwa noḡoti waiubauba bi kwa waikatikotona, mba em lava kwa wailovedi te mainana sa voiye, tam kaka Mala ena waibada noponemo sa kita kamaḡem. Bi tam aiyai waiḡake kwa vovoteyateyaedina ba lava kwai lovelovedi te tedi kota sa voteyateya, bi tam kaka Mala ena waibada noponemo sa sako saḡem. ");
INSERT INTO kqf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bi yà giugiuwemi, emi yawasana ko kadidimani kauwedi, bi mote koma voiye maibena Palisi bi waiḡake tauwailovelovena. Tedi ta kitekitedi te bena didimana lavedi bi nopodi ba gebogebo i wanavu. Bamoda temi mainana ko voiyena ba mote kaka Mala ena waibada noponemo koma solasaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Mote kumai peki. Aiyai bi lava i waipekina, tana kaka etalemo ya moito.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bi geḡa te tagu niganana yà giugiuwemi te tam aiyai em tau lisinemo kuna medina, tam kaka sa etalem. Bi tam aiyai te em tau kuna giu waigebogebona ba tam yaḡolo etala dididiginemo kwa moito. Bi bamoda tam aiyai em tau kuna giu waibu'ubu'uina, ba tam kwai laba te kwa nawana iyoyoḡamo. ");
INSERT INTO kqf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bamoda em puyo kuna natome Oltemo Maimaituwa vitena aubaina, bi ḡome kuna noḡoti te em tau vaitena modomimo gebogebo ya kenakena, ");
INSERT INTO kqf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ba em puyo Olta diyanemo kwa gose. Bi kwa munaḡa te em tau vaitena mba pilipilina ko gei kadidimani, kaka kwa nato munaḡa te em puyo Maimaituwa kwa vite. ");
INSERT INTO kqf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bamoda lava aiyai tam ya nawemna etala aubaina, kamaina te etamo em gebogebo kwa kadidimani makaiye, te taulauetala nimanemo mote ima sakom. Banina taulauetala kaka tauwaipanipani nimanemo ya sakom te ya nawemna biliwelokomo. ");
INSERT INTO kqf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bi yà giugiu kauwem te tam kaka biliwelokomo kwa miyamiyana, eete kwai maii'a kovi kaka kwa potiyovo. ");
INSERT INTO kqf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Mwanem mote kuma vawaidoḡa.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Geḡa te tagu niganana yà giugiuwemi, te tam aiyai bi waivini ḡesauna kuna kita bi nopommo kuna elawena, ba tam kaikana mwanem kuna vawaidoḡa. ");
INSERT INTO kqf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bamoda matam kataiyammo i voiyem te gebogebo kwa voivoiye, ba kamaina te kwa ḡivoi kamaḡe bi kwa pwalaḡe. I visu te matam ḡemota bi malamo kwa solasaḡa, kaka tubuḡim matabuna sa pwalaḡe nawena iyoyoḡamo. ");
INSERT INTO kqf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bi bamoda nima kataiyam i voiyem te gebogebo kuna voiyena, ba kamaina te kwa bwali ḡavuki te kwa pwalaḡe. I visu te nimam ḡemota bi malamo kwa solasaḡa, kaka tubuḡim matabuna sa pwalaḡe nawena iyoyoḡamo. ");
INSERT INTO kqf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Oloto waigose ya ḡoyena, ba kamaina te waigose pepana mwanena ya vite.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bi geḡa te niganana yà giugiuwemi te oloto mwanena mote ima gose. Bamoda i voiyena ba mwanena ya vavawaidoḡa bi waivini ena waimatawapamo kaka mwanena ya voiye te ya gose. Bi aiyai olotona mba waivinina gosegosena i naḡina, ba vawaidoḡa ya voivoiye. ");
INSERT INTO kqf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Bamoda Bada isanemo kuna giuwapana ba kamaina te kwa voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bi geḡa te, tagu niganana yà giugiuwemi te mote bai isanemo koma giuwapa. Mote mala isanemo, banina mba ba Maimaituwa ena animiya, ");
INSERT INTO kqf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ee mote dobu isanemo, banina mba ba Maimaituwa kaḡetabana ani waigwaliḡena. Bi mote Yelusalem isanemo, banina mba ba Ḡalibona Dididiga ena malagai. ");
INSERT INTO kqf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bi kota kunummo mote kuma giuwapa, banina tam mote ḡemoḡemotina te dabam kuma voiye te ima duba ee ima poti. ");
INSERT INTO kqf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Taunana aubaina temi koi aninana, ba kamaina te koi anina ota. Bi kona dabokana ba, kamaina te ko daboka ota. Bi giu ḡesaudi ko vatodina, mba Seitan lisinaḡa sa natonato. ");
INSERT INTO kqf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Bamoda em tau matam i ḡivoina, kamaina te tana matana kwa ḡivoi. Bi em tau mwakam i waidoulosina, kamaina te tam tana mwakana kwai doulosi.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bi geḡa te tagu niganana yà giugiuwemi, te gebogebo lavana bai lisimmo i voiye waigebona, mote kuma laubiwa. Bamoda aiyai gadigadimmo i talaḡana, ba kota gadigadim ḡesaunemo ya talaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bamoda aiyai i etaetalem bi em kwama dibunemo anikote i vaina, ba kamaina te em kwama dabanemo anikote vaitena kwa vite! ");
INSERT INTO kqf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bamoda tauwaiḡaviya ya egelim te ena ḡonaḡona kwa avala bi ko nawa palata i sakosakonemo, ba mba mainana manekina lofana kota kwa nawae kaka kwa gose. ");
INSERT INTO kqf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aiyai bi bai lisimmo i waibaḡayena, ba kamaina te kwa vite bi mote kuma nuwevi. ");
INSERT INTO kqf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Temi kona vaiye te wala waiḡake i giuna gado, ‘Em tau diyammo taumiya khwa ḡoe bi em ḡaviya kwa daboke.’ ");
INSERT INTO kqf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bi geḡa te niganana yà giugiuwemi te emi ḡaviya ko ḡoyedi, bi mabai sa laulaukivi gebogeboyemina aubaidi ko laupali, ");
INSERT INTO kqf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","mba mainana ko voiyena kaka Tamemi malamo yai kawa natunemi. Tana suwala ya giugiukamaḡe yovoḡe visuvisu bi gebogebo lavedi lisidimo. Bi nabu ya giugiukamaḡe yovoḡe didimana bi mote didimana lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bamoda tedi mabai sa ḡoyeḡoyemna taudiḡa kwa ḡoyedina ba bai mai'ina kaka kwa vai? Geḡa ota! Takis taulaitupana ba edi lava taudiḡa sa ḡoyeḡoyedi bi edi gaviya sa dabodabokedi. ");
INSERT INTO kqf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bamoda em dam lavedi taudiḡa kwai ebonedina, mba kauwa visuvisuna kwa voivoiye, lava ḡesaudi lisidimo? Lava waisumaḡageḡedi mainana sa voivioye. ");
INSERT INTO kqf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taunana aubaina, temi kota emi ḡaviya ko ḡoyedi bi emi yawasana sa visu bi sa didimana maibena Tamemi malamo.” ");
INSERT INTO kqf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Laḡannemo waisagu kauwidi ko voiyedina ba koi kita kauwa te mote lava matedimo koma voiyedi. Bamoda mainana ko voiyena ba emi maii'a malamo Tamemi lisinemo mote koma vai. ");
INSERT INTO kqf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Taunana aubaina, laḡannemo lava malumaluwabina kona saguna ba mote koma nuwasaḡesaḡe bi bwagigi koma suvedi, maibena lava kaikaiyovudi edi kauwa. Tedi bolu vanuwidimo bi eta nananakidimo sa voiyedi te bena lava sa soveyedi. Giukauwa yà giugiuwemi te mba lavedi edi mai'ia kaikana sa vaivai. ");
INSERT INTO kqf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bi laḡannemo lava malumaluwabina kona saguna ba mote aiyai diyemimo ima sibe, ");
INSERT INTO kqf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bi emi vite ba kandavonemo ko voiye. Tamemi i kitemi te bai kandavonemo kona voiyena ba tana kaka emi maii'a ya vitemi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Laḡannemo ko laupalina ba mote mai lava kaikaiyovudi sa laulaupalina mainana, tedi sa ḡoyeḡoye te bolu vanuwidimo bi eta nananakidimo sa moito nawa bi sa laupali te lava sa kitedi. Giukauwa yà giugiuwemi te mba lavedi edi maii'a kaikana a vai. ");
INSERT INTO kqf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bi laḡannemo pali ko ḡoyena, ba ko nawa emi vanuwemo, mataetina ko gudu bi Tamemi miyamiya waidavonina lisinemo ko laupali. Tamemi i sibemi bai kandavonemo ko voivoiyena kaka emi maii'a ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bi laḡannemo ko laupalina ba mote mai koikoitau taulauduneyedi sa lelolelona mainana. Tedi sa wainoḡota te edi giu wapewapedi sa vatodina kaka Maimaituwa ya vaiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Temi mote koma voiye mai tedi, banina muliḡa kaka koi baḡana ba Tamemi kaikana emi maluwabi i sibedi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Temi ko laupalina gado, Tamamai malamo miyamiyam, dobu matabuna Isam Waiwaiyawina sa vivile. ");
INSERT INTO kqf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tam em waibada ya nato. Bi em ḡowana dobumo ya tubuḡa, maibena malamo ya tubutubuḡana mainana. ");
INSERT INTO kqf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Laḡan onena kamaya kwa vitemai, ");
INSERT INTO kqf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bi ema gebogebo kwa noḡoti kamaḡedi, mai ema lava edi gebogebo ke noḡonoḡotikamaḡedina mainana. ");
INSERT INTO kqf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kwa sagumai te laulubumo mote kama nawa bi gebogebo kwa tauliye bi kwai yawasanimai. ");
INSERT INTO kqf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bi bamoda lava a kanuwagebomina ba edi gebogebo ko noḡoti kamaḡedi. Banina mba mainana kaka Tamemi malamo kota emi gebogebo ya noḡoti kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bamoda lava edi gebogebo yaḡolo te ko noḡonoḡoti watedi ba Tamemi malamo kota mainana emi gebogebo ya noḡoti watedi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Laḡannemo ko udiudina ba mote matemi koma voiyedi te simai nuwatoitoi maibena, lava waikaikaiyovudi sa voivoiyena. Tedi sa kakamaḡati munaḡedi lava matedimo te sa udiudi. Giukauwa yà giugiuwemi te tedi kaikana edi ma'ia a vai. ");
INSERT INTO kqf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bamoda ko udina ba dabemi ko oelidi bi matemi ko sevedi, ");
INSERT INTO kqf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te lava mote sima sibemi te temi ko udiudi. Bi Tamemi miyamiya waidavonina taunaḡa ya sibemi te temi ko udiudi. Tana kaka bai kandavonemo ko voivoiyena ya kita bi ma'ia ya vitemi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Emi waiguyau mote dobumo koma susuḡudi, male sulasula sa kagebogebodi bi sa laukoekoe ee taudanedanene vanuwemo sa sola saḡa te sa danenedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Taunana aubaina emi waiguyau malamo ko susuḡudi, banina ḡome mote sulasula kaka sima kagebogebodi bi sima laukoekoe ee taudanene mote ima sola saḡa te ima danenedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bi emi waiguyau bamo ḡome sa kenakena ba temi kota nuwemi ḡome.” ");
INSERT INTO kqf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata ba tubuḡa ena kwadam. Bamoda matemi visuvisudi ba tubuḡimi matabuna ya yana. ");
INSERT INTO kqf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bamoda matami sa gebogebona, ba tubuḡimi matabuna yai dudubala. Bamoda yana nopommo i wai dudubalana, ba i gebo kauwa te nopom yai boimatuwa. ");
INSERT INTO kqf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mote aiyai kaka babada labu aubaidi ima paula. Tana ḡemota ya ḡoye bi ḡesauna ya daboke ee ḡemota ya kaiwatawata bi ḡesauna ya kita kamaḡe. Temi mote ḡemoḡemotina te Maimaituwa bi mane koma pauledi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Taunana aubaina, yà giugiuwemi te tubuḡa aubaina mote komai nuwaboya te bai maso kona kani bi kona tego. Bi mote komai nuwaboya te bai maso kona kote tunimi aubaina. Yawasana noḡotina i didiga gulatana kaka kani bi kota mainana tunimi noḡotina i didiga gulatana kaka gala. ");
INSERT INTO kqf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwanuwa sawasawamo sa lovolovona ko noḡotidi! Tedi mote sima wadiwadi, mote kani sima yabayaba ee sima laulaususuḡu, geḡa te Tamemi malamo ya waikanidi. Bi temi nuwaboyemi i didiga gulatana kaka mwanuwa. ");
INSERT INTO kqf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Temi mba mwalidi kowai nuwaboyaedina, kaka emi miya sa kalofedi, ee? Geḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Te bai aubaina gala ko wainuwaboyaedi? Belana bodumo sa dugadugana ko kitedi. Tedi mote sima noyanoya bi gala sima voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bi yà giugiuwemi, avena te Solomon ena waiguyaumo ena gala kipokipolidi bi mba galedi mote a visu gulata maibena niga belenidi. ");
INSERT INTO kqf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Maimaituwa ḡawaḡawa i voiyedi bi ya labelabe kauwedi. Bi mba ḡaweḡawedi niganana niga ḡome bi bokina ba kai ya kala ḡosedi. Bi temi noḡotimi i didiga gulatana kaka ḡawaḡawa. Taunana aubaina Maimaituwa kaka yai galemi, bi temi kamaina te koi sumaḡadidi.” ");
INSERT INTO kqf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mote komai nuwaboya bi koma giu gado, ‘Mwali bai ta kani, ee bai ta tego? Ee bai ta kote?’ ");
INSERT INTO kqf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Koikoitau taulauduneyedi mba mwalidi sa wainuwaboya gulatedi. Bi temi Tamemi malamo i sibe te mba mwalidi ko ḡoyeḡoyedi. ");
INSERT INTO kqf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bi geḡa te temi Maimaituwa ena waibada bi ena didimana etedi ko gei tavuḡedi kaka tana mba mwalidi matabudi ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Taunana aubaina, bokina ena kauwa niganana komai nuwaboyae. Bokina ko gose te taunaḡa ena nuwaboya. Laḡan onena taunaḡa ena nuwaboya ya kenakena.” ");
INSERT INTO kqf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Lava kuma kitakita waipoipoyedi bi kuma giugiuwatedi, Maimaituwa kaka kauwina ḡemotina lisimmo ya voiye. ");
INSERT INTO kqf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bainewa em tau kuna lauipoipoyena ba Maimaituwa kaka luvanemo ya lauipoyem. ");
INSERT INTO kqf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bai aubaina em tau matanemo ḡasububu kwa kitakita, bi tam matammo mote kaitupo kuma kitakita? ");
INSERT INTO kqf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bai aubaina tam matammo mote kaitupo ku kaikamaḡe, bi em tau matanemo ḡasububu kaikamaḡena kwa giugiuwe? ");
INSERT INTO kqf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tam lava kaikaiyovum! Dolinemo tam matammo kaitupo kwa kaikamaḡe te kwai kita kauwa, kaka em tau matanemo ḡasububu kwa kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Bai waiwaiyawina mote daḡadaḡasi koma vitedi. Bi kota em posalu mote buwawa matedimo kumai naḡasa, tedi male sa vagudegudedi bi sa nuwavitala te sa koilisilisim.” ");
INSERT INTO kqf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Koi baḡana kaka Maimaituwa ya vitemi, koi tavutavuna kaka ko banavi bi ko laupewapewana kaka lisimimo mataeta ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lava matabudi sa waibaḡana kaka ya vitedi, tedi mabai sa waitavutavuna kaka sa banavi bi tedi mabai sa laulaupewapewana kaka lisidimo mataeta ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tam aiyai natum maso kani i waibaḡaye bi ḡakima kuna vite? ");
INSERT INTO kqf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ee iyana i waibaḡaena ba mwata kwa vite, ee? Bena geḡa! ");
INSERT INTO kqf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Temi mwali visuvisudi natunatumi vitedi kona sibe kauwedi. Tedi mabai sa waibaḡana Tamemi Malamo lisinemo ba mwali visuvisudi ya vitedi. ");
INSERT INTO kqf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Temi bai ko ḡoyeḡoyena lava lisimimo sa voiyena ba mainana kota tedi lisidimo ko voiye, banina niga taunana Waiḡake bi Tauḡiuwatana edi wailovelove.” ");
INSERT INTO kqf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mataeta ḡulilinaḡa ko sola nawa, banina iyoyoḡa etana ba gayana i didiga, i taba bi lava wapewapedi sa kaikaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yawasana etana mataetina ba i ḡulili bi nawaena ba i pilipili bi lava visa ota sa kaikaiwata.” ");
INSERT INTO kqf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Taugiuwatana kaikaiyovudi ko kita kauwedi. Tedi sa nato bi sa voiyedi mai sipu waitunipekidi bi geḡa te nopodi ba medimedidi mai bena tabei. ");
INSERT INTO kqf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bi edi kauwemo ba ko kita ḡonedi. Lava ḡemoḡemotina guleipi gedala modonemo ya losi, ee kulou tipolo modonemo ya losi? Bena geḡa. ");
INSERT INTO kqf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kota mainana kai dugaduga kauwina ba ya vota kauwa bi kai mote dugaduga kauwina mote vota kauwa. ");
INSERT INTO kqf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kai dugaduga kauwina mote ḡemoḡemotina vota gebogebona ima votae. Bi kai mote dugaduga kauwina mote ḡemoḡemotina vota visuvisuna ima votae. ");
INSERT INTO kqf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bi bamo kaidi mote sima votavota kauwa ba Maimaituwa ya oi kamaḡedi bi kai kalakalatinemo yai naḡasedi. ");
INSERT INTO kqf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mba kauwina ḡemotinemo, taugiuwatana edi yawasana ko kita waitetedi bi ko sibedi te tedi taugiuwatana visuvisudi ee taugiuwatana kaikaiyovudi.” ");
INSERT INTO kqf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Lava wapewapedi lisigumo sa giugiuna gado, ‘Bada, Bada,’ Bi mote lavedi matabudi kaka Maimaituwa ena waibadamo sima sola saḡa. Bi tedi mabai Tamagu malamo ena ḡowana sa voivoiyena taudidi Maimaituwa ena waibadamo sa sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bi etala laḡanna ya tavana kaka lava wapewapedi sa giuna gado, ‘Bada, Bada, tama isammo aluwa gebogebodi kei potiyovodi bi mataila kauwidi wapewapedi ke voivoiyedi.’ ");
INSERT INTO kqf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bi tagu kaka yà giuotiḡedina gado, ‘Tagu mote yà sibemi. Ko nawa tabumimo, temi gebogebo lavemi.’” ");
INSERT INTO kqf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Taunana aubaina, tana aiyai ya nato giugu ya vaiye bi ya kaikaiwata kauwena ba maibena lava nuwauyauyana, ena vanuwa ḡakima dabanemo i ḡala. ");
INSERT INTO kqf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bi nabu i yovo, gauba a kabaita bi yavala i lausuve gulata vanuwa modonemo bi mote i likwa, banina yasina ḡakima dabanemo i waimoito. ");
INSERT INTO kqf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bi aiyai giugu ya vaiye bi mote ima vovoteyeteye, ba maibena oloto bu'ubu'uwina ena vanuwa bubumo i ḡala. ");
INSERT INTO kqf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bi nabu i yovo, gauba a kabaita bi yavala i lausuve gulata vanuwa modonemo te i likwa bi daguguna ba i didiga gulata.” ");
INSERT INTO kqf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Laḡannemo Yesu ena wailovelove i kovi mulinemo ba lava kumdi ena wailovelove a sove gulate, ");
INSERT INTO kqf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","banina tana ḡailisi vaitena i waiwailovelove, mote mai waiḡake tauwailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Laḡannemo Yesu oya dabanemo i yovoyovo munaḡa ba lava kumdi tana a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ḡome oloto sida kapa vaivaina i tava Yesu kaḡepakanemo, tuwapekana i waitupagwaliḡedi bi i giuna gado, “Aee, BADA, bamoda kwa ḡoyena, te kwai yawasanigu.” ");
INSERT INTO kqf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nimana i tuḡu te oloto i taukoni bi i giuwena gado, “Tagu yà ḡoyeḡoyena kwa yawasana.” Noi taunana te oloto sida kapa vaivaina i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kamaina bi Yesu oloto i waiḡakena gado, “Bai lisimmo i tubutubuḡana, mote aiyai kuma giuwe bi kwa nawa pilisi lisinemo te tana ya kitam. Bi Mousis ena sewasewa i giugiuwena mainana kwa voiye te lava sa kitam te tam kuna yawasana.” ");
INSERT INTO kqf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bi laḡannemo Yesu Kapeniyammo i tavatava, ba ḡome tauwaiḡaviya wapedi 100 edi bada i tava Yesu lisinemo bi i waibaḡana gado, ");
INSERT INTO kqf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bada, egu taupaula ba sida tunipekipeki i vai bi ya pelopelo.” ");
INSERT INTO kqf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Bi Yesu tana i giuwena gado, “Tagu kaka yà nato te yài yawasani.” ");
INSERT INTO kqf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bi tauwaiḡaviya edi bada Yesu ena giu i waimunena gado, “Bada, tagu mote yà visu te egu vanuwemo kwa tava. Bi kwa giu ota te egu taupaula ya yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tagu kota waibabada dibudimo yà miyamiya, bi ḡaviḡaviyidi egu waibada dibunemo sa miyamiya. Bi laḡannemo tauwaiḡaviya yà giuwena gado, ‘Ku nawa,’ Ba ya nawa, ee yà giuwena⅝Q1qàQ gado, ‘Ku nato,’ Ba ya nato. Bi egu taupaula yà giuwena gado, ‘Niga ku voiye,’ Ba tana ya voivoiye.” ");
INSERT INTO kqf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Laḡannemo Yesu, tauwaiḡaviya wapedi 100 edi bada ena giu i vaivaiyedi ba i sove bi i tauvitale te lava kumna a kaikaiwatana i giuwedina gado, “Yà giugiu kauwemi, te tagu mote bamo Islael noponemo lava aiyai e banavi ena waisumaḡa mai niga olotona. ");
INSERT INTO kqf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bi tagu yà giugiuwemi, te Mala ena waibada noponemo lava wapewapedi kaka suwala ena anilovotava bi ena anibulu yawanidiḡa sa tava. Ḡome Eiblaḡam, Aisik bi Deikap vaitedi sai ḡemotidi bi sa kani ḡemota. ");
INSERT INTO kqf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bi tedi mabai sa ḡoyeḡoye te Maimaituwa ena waibadamo maso sa sola saḡa bi geḡa te ya pwalaḡe yovoḡedi boimatuwemo. Bi mba ḡome tedi kaka sa ḡaba bi sa gadigadi kiko.” ");
INSERT INTO kqf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kamaina bi Yesu tauwaiḡaviya edi bada i giuwena gado, “Ku nawa, bi em waisumaḡa luvanemo mainana ya tubuḡa.” Mai i giugiu ba, tauwaiḡaviya edi bada ena taupaula i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Laḡannemo Yesu, Pita ena vanuwemo i solasola saḡa ba lawana, i kita gaugaululu i vai bi ena gabumo i kenakena. ");
INSERT INTO kqf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu waivini nimana i tautaukoni ba i yawasana bi i moito te i waikanidi. ");
INSERT INTO kqf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mba aubiganemo, lava wapewapedi aluwa gebogebodi a sunesuneidina a natomedi Yesu lisinemo. Bi tana aluwa gebogebodi i giuwedi a potiyovo bi kota lava sidesidedi matabudi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Niga kauwidi ba taugiuwatana Aisaiya wala bai i giugiuwena mainana a tubuḡa. Taugiuwatana niga mainana i giu, “Tana taunana eda nuwaboya bi eda sida vitedi i avali.” ");
INSERT INTO kqf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu lava kumna i kitedi a dubudubutawi, ba ena tauwaikaiwatana i giuwedi te sa nawa topa nevanemo. ");
INSERT INTO kqf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bi waiḡake tauwailovelovena ḡemota Yesu lisinemo i tava bi i giuwena gado, “Tauwailovelove, tam bamo maiḡa kwa nawana ba yà kaiwatam.” ");
INSERT INTO kqf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bi Yesu giu i waimunena gado, “Dako edi bwadamo sa miyamiya, mwanuwa edi noḡimo sa kenakena, bi Tana Taunana Natuna mote bamo ena gabu kauwa te yai yawasi.” ");
INSERT INTO kqf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ḡome Yesu ena tauwaikaiwatana ḡesauna i giuna gado, “BADA, dolina yà munaḡa te tamagu yà dobo.” ");
INSERT INTO kqf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bi Yesu ena giu i waimunena gado, “Ku kaiwatagu, bi lava pekipekidi kwa gosedi te edi peki sa dobo.” ");
INSERT INTO kqf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kamaina bi Yesu wagamo i gelu bi ena tauwaikaiwatana vaitedi a nawa. ");
INSERT INTO kqf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tedi topa modonemo a tavatava, noi taunana te kaibitibiti i talaḡa i waitubu. Bi labama nananakidi waga noponemo a waidubusaḡedi, bi Yesu ba i kenakena. ");
INSERT INTO kqf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ḡome ena tauwaikaiwatana tana a lainuwesi bi a giuwena gado, “Bada, kwai yawasanida, ḡotona te ta peki.” ");
INSERT INTO kqf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bi Yesu edi giu i waimunena gado, “Temi bai aubaina ko nainaila? Emi sumaḡa kana ḡaubo.” Kamaina bi tana i miya moito te yavala bi labama i giu waitautaudi. Bi daumola i kena. ");
INSERT INTO kqf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tedi a soveye bi a giuna gado, “Niga lava baibaina? Te yavala bi labama a voteyeteye.” ");
INSERT INTO kqf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sauginemo Yesu noi nevanemo Gelesin lavedi edi dobumo i tavatava, ba olooloto labu aluwa gebogebodi a sunesuneidina, tauyewaḡa a tava Yesu lisinemo. Tedi ai nuwanainaila gulata aubaina mba etana mote lava a kaikaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bi tedi kalinedi dididiginemo Yesu lisinemo a binauna gado, “Maimaituwa Natuna! Tam bai kwa ḡoyeḡoyena lisimaimo kwa voiye? Kovoḡa ena laḡan yaḡolo kaka ya tava, bi niganana kuna natona kwa kovoḡimai, ee?” ");
INSERT INTO kqf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tedi a moimoitona diyedimo ba buwawa yalaboluboludi a yabayaba. ");
INSERT INTO kqf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kamaina bi aluwa gebogebodi Yesu ai baḡana gado, “Bamoda kwa kwavi waipotiyovomaina ba kwa giukamaḡemai te buwawa yalaboludi nopodimo ka solanawa.” ");
INSERT INTO kqf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu aluwa gebogebodi i giuwedina gado, “Ko nawa!” Te lava a potiyovo kamaḡedi bi buwawa nopodimo a sola nawa. Ḡome buwawa yalaboluboludi salisali a velavelau watana ba topamo a tona te a peki. ");
INSERT INTO kqf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bi buwawa tauḡamodi a naila a nawa taunimo. Bi olooloto labu bi buwawa lisidimo bai i tubutubuḡana giuna a laidabalali. ");
INSERT INTO kqf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kamaina bi mba taunina lavedi a nawa Yesu kitana aubaina bi laḡannemo a banabanavi ba aibaḡa vavasaḡe te edi dobu ya gose. ");
INSERT INTO kqf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kamaina bi Yesu wagamo i gelu saḡa bi i munaḡa nato ena taunimo. ");
INSERT INTO kqf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bi ḡome olooloto ḡesaudi edi tau nuwakudukuduna latilatina a avali tavaite Yesu lisinemo. Laḡannemo Yesu mba oloolotodi edi waisumaḡa i kitakita, ba oloto nuwakudukuduna i giuwena gado, “Koko, kumai nuwaboya, em gebogebo e noḡoti kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ḡome waiḡake tauwailovelovena giuna mai a vaivaiye, ba taudiḡa ai giugiuna gado, “Niga lavana ba Maimaituwa ya waidiboḡi.” ");
INSERT INTO kqf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu mba lavedi edi noḡota i sibedi bi i giuna gado, “Bai aubaina mba noḡotidi gebogebodi nopomimo ko noḡonoḡotidi? ");
INSERT INTO kqf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bamo giuna i tekateka? ‘Em gebogebo e noḡoti kamaḡedi, ee Kwa moito bi kwa nawa?’ ");
INSERT INTO kqf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Niganana kaka yài lovemi bi ko sibe te dobumo Tana Taunana Natuna lisinemo ḡailisi ya kenakena te gebogebo ya noḡotikamaḡedi.” Kamaina bi Yesu mba olotona nuwakudukuduna i giuwena gado, “Kwa miya moito, em kebana kwa vai bi kwa nawa em vanuwemo.” ");
INSERT INTO kqf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ḡome oloto i miya moito bi i nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Laḡannemo lava kumna mba kauwina a kitakita, ba tedi a sove bi Maimaituwa a kasaḡesaḡe, banina tana ḡailisi lava i vitedi. ");
INSERT INTO kqf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu mba gabuna i gose bi i nawanawa ba oloto isana Met i kita. Tana takis anilaitupana gabunemo i miyamiya. Bi Yesu Met i giuwena gado, “Ku kaiwatagu!” Ḡome Metiu i miya moito bi Yesu i kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kamaina bi Met Yesu ena tauwaikaiwatana vaitedi i giuvaidi te ena vanuwemo a kani. Bi vanuwinemo ba gebogebo lavedi bi takis taulaitupana wapewapedi a tava bi vaitena a kanikani ḡemota. ");
INSERT INTO kqf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ḡome Palisi ḡesaudi a kita te Yesu ba gebogebo lavedi vaitedi a kanikani. Bi ena tauwaikaiwatana a giuwedina gado, “Bai aubaina emi tauwailovelove takis taulaitupedi bi gebogebo lavedi vaitedi sa kanikani ḡemota?” ");
INSERT INTO kqf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Laḡannemo Yesu mainana i vaivaiyedi ba i giuna gado, “Lava yawayawasanidi mote doketa sima ḡoyeḡoye, bi lava sidesidedi taudiḡa doketa sa ḡoyeḡoye. ");
INSERT INTO kqf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Temi ko nawa bi gilugilumina wadubonemo ko kita bai i giuwe, ‘Tagu lisigumo mote musala koma lausewasewayedi bi lava ko launuwatoiyedi. Banina tagu e yovona ba gebogebo lavedi waiyawasanidi aubaidi. Bi mote visuvisu lavedi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Laḡan ḡemota Diyoni taukabulu ena tauwaikaiwatana a tava Yesu lisinemo bi a giuwena gado, “Bai aubaina tama bi Palisi ka udiudi, bi tam em tauwaikaiwatana mote sima udiudi?” ");
INSERT INTO kqf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bi Yesu edi giu i waimunena gado, “Laḡannemo lawelawe ena wale naḡi soinemo vaitedi sa miyamiya, ba bai aubaina sai nuwaboya bi sa udi? Bi saugina ya tavana kaka lawelawe ya gosedi, mba laḡannemo kaka tedi sai nuwaboya bi sa udi.” ");
INSERT INTO kqf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mote aiyai gala valivaliuna ima vai bi gala wadubona vaitena ima siyau ḡemotidi. Banina gala valivaliuna male gala wadubona ya solulisi, te ya puliti waididigi. ");
INSERT INTO kqf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bi kota lava mote waen valivaliuna sima vai, bi kwagi wadubonemo sima ḡini. Bamoda mainana sa voiyena, ba kwagi wadubona ya nuwasena te waen ya nuwaḡini. Geḡa, tedi waen valivaliuna kwagi valivaliunemo sa ḡini yovoḡe. Te kwagi bi waen visuvisudi sa kena. ");
INSERT INTO kqf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu mba kauwidi i giugiuwedi ba, bolu vanuwina tauwaibadayena ḡemota i tava lisinemo. Tana tuwapekana i tupagwaliḡedi bi i giuwena gado, “Tagu natugu waivinina niganana i peki. Taunana aubaina tam kwa nato bi nimam dabanemo kwa sako bi ya yawasana munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kamaina bi Yesu bi ena tauwaikaiwatana mba olotona vaitena, a nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tedi a nawanawa etamo ba waivini kwasina i miyamiya kamakamaḡena Yesu mulinaḡa i saḡa. Te ena gala isunaḡa i taukoni bi noponemo i wainoḡotana gado, “Bamoda Yesu ena gala isunaḡa yà taukonina, ba yà yawasana.” Niga waivinina kwasina i miyamiya kamakamaḡena ba kwalabu wapana 12 a kovi. ");
INSERT INTO kqf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ḡome Yesu i tauvitale te waivini i kita bi i giuwena gado, “Keulo, mote kumai nuwaboya, em sumaḡa i waiyawasanim.” Mba taunana te i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bi laḡannemo Yesu bolu vanuwina tauwaibadayena ena vanuwemo i valavalageta, ba lava kumna i kitedi a ḡabaḡaba salesale. ");
INSERT INTO kqf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bi Yesu i giuwedina gado, “Matabumi ko potiyovo. Gomana mote i peki tana ya kenakena.” Ḡome lava kumna mainana a vaivaiye ba tedi Yesu ai gwaigwaiye. ");
INSERT INTO kqf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bi lava giuwedi te a potiyovo doḡamo, mulinemo Yesu i saḡa noke dabanemo bi gomana nimanemo i kabikabi ba i kenamoito. ");
INSERT INTO kqf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Niga kauwina i tubutubuḡana, giuna dobu matabuna i nawa yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kamaina bi Yesu mba vanuwina i gose bi i nawanawa te olooloto matapotepotedi labu, a kaiwata bi a binabinauna gado, “Deivida natuna, kwa launuwatoiyemai!” ");
INSERT INTO kqf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bi Yesu i nawa vanuwemo i valavalageta, ba olooloto matapotepotedi a tava lisinemo. Bi i waitalayedina gado, “Temi konai sumaḡa te tagu ḡemoḡemotina matemi yài yawasanidi, ee?” Tedi ena giu ai munena gado, “Emaso Bada, tama kei sumaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kamaina bi Yesu mba oloolotodi matedi i taukonidi bi i giuwedina gado, “Temi konai sumaḡa aubaina te ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ḡome te matedi i kayanedi bi ai kita. Bi Yesu i giu vavasaḡedina gado, “Bai niganana lisimimo i tubuḡana mote aiyai koma giuwe!” ");
INSERT INTO kqf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bi geḡa te tedi a nawa bi lisidimo bai i tubutubuḡana giuna mba dobuna matabuna a giu nawe. ");
INSERT INTO kqf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mba oloolotodi Yesu a gose bi a nawanawa, ba mulidimo, lava ḡesaudi oloto aluwa gebogebona i sunesuneḡina ai doli tavaite Yesu lisinemo. Bi mba olotona tana ba gumgum. ");
INSERT INTO kqf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ḡome Yesu olotona noponemo aluwa gebogebona i kwavivai bi mulinemo ba oloto i giu ota. Bi lava kumna ḡome kauwina a kitakita ba a tagugu bi a sove te a giuna gado, “Niga kauwina Islael noponemo mote bamo mainana ta kitakita.” ");
INSERT INTO kqf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bi Palisi a giuna gado, “Mba aluwa gebogebodi edi bada ḡailisi Yesu i vite. Taunana aubaina tana aluwa gebogebodi ya kwavidi bi sa potipotiyovo.” ");
INSERT INTO kqf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu i nawa taun bi malagai matabudi nopodiḡa bi bolu vanuwidiḡa i waiwailovelove, bi Maimaituwa ena waibada giuna visuvisuna i laulauguguyae. Bi kota lava edi sida tabudi bi tabudi i waiwaiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Laḡannemo Yesu lava kumdi i kitekitedi ba i launuwatoiyedi. Tedi wainuwatoitoidi tausagudi geḡa. Tedi ba maibena sipu bi taulabedi geḡa. ");
INSERT INTO kqf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ḡome Yesu ena tauwaikaiwatana i giuwedina gado, “Daibimo maula i didiga gulata bi taupaulayena mote a wapa. ");
INSERT INTO kqf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bada tana daibi taniwagina, koi baḡa bi taupaula ya giukamaḡedi te ena daibimo sa noya.” ");
INSERT INTO kqf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ena tauwaikaiwatana 12 i waiḡemotidi bi ḡailisi i vitedi te tedi aluwa gebogebodi sa kwavidi sa potiyovo bi sida tabudi bi tabudi matabudi sai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Giugiukamaḡedi 12 isedi ba niga, dolidolina ba Saimon, a waiisana Pita, bi tasina ba Endulu, Diyemesi tamana Diyebedi bi tasina ba Diyon ");
INSERT INTO kqf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi, Batolomiu, Tomasi bi Met takis taulaitupana, Diyemesi tana taunana Alupiyasi natuna bi Tadiyas, ");
INSERT INTO kqf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon tana Selot, bi Diudas Iskaliot tana taunana Yesu tauwaibenabenamena. ");
INSERT INTO kqf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesu niga oloolotodi 12 i giukamaḡedi bi i giu wailovelovedina gado, “Eteni bi Sameliya lavedi edi tauniḡa mote koma nawa. Bi ko nawa Islael lavedi lisidimo, tedi ba maibena sipu gwegwedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Temi ko nawa bi niga giuna ko lauguguyaena gado, ‘Mala ena waibada kaikana ya tavatava.’ ");
INSERT INTO kqf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bi lava sidesidedi koi yawasanidi, pekipekidi ko ka kenamoitodi, kapa vaivaidi koi yawasanidi, bi aluwa gebogebodi a sunesuneidina ko kwavidi sa potiyovo. Niga ḡailisina e vite otiemi, mainana kota temi lava koi yawasani otiedi bi mote maii'a komai baḡae. ");
INSERT INTO kqf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Emi nawamo mote goldi, ee silva ee kopa koma legaudi, ");
INSERT INTO kqf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mote tana, mote kwesi ḡesauna, mote kaḡesuma bi mote diḡona. Temi egu taupaula aubaina te lava kaka mwali matabudi aubaimi sa voiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Laḡannemo bamo taunimo ee malagaimo kona tavana, bi aiyai i giuvaimina ba ena vanuwinemo ko miyamiyana, eete mba vanuwina ko gose. ");
INSERT INTO kqf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Laḡannemo temi vanuwemo kona valagetana ba, koi ebodi bi ko giuna gado, ‘Nuwauba lisimimo ya kena.’ ");
INSERT INTO kqf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bamoda vanuwa lavedi sa giuvaimina ba kamaina te emi nuwauba nopodimo ya kena. Bi geḡa, ba nuwaubana ko vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bi bamoda lava mote sima giuvaimi bi kalinemi mote sima vaiye, ba kamaina te kaḡemi gobusidi ko laikulukuluvidi bi mba vanuwina ee malagaina ko gose. ");
INSERT INTO kqf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tagu yà giugiu kauwemi te malaetala laḡannemo ba Maimaituwa Sodom bi Gomola ya launuwatoiyedi bi mba taunina lavedi mote kaka ima launuwatoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tagu yà giugiukamaḡemina maibena sipu, tabei nopodimo. Taunana aubaina ko volana mai mwata ko volavolayena te gebogebo mote ima taukonimi bi kota ko voyaḡotana mai gabubu te yawasana gebogebodi mote koma voiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bi lava ko kita kauwedi, banina tedi kaka taulauetala nimedimo sa sivumi bi bolu vanuwidi nopodimo sa kwapumi. ");
INSERT INTO kqf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tagu dabagumo kaka temi sa panimi bi sa nawemi gabegabemani bi ḡaliḡalibona nananakidi lisidimo. Bi ḡome giugu visuvisuna tedi bi Eteni lavedi lisidimo ko kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bi laḡannemo sa panimina ba mote komai nuwaboya te bainewa ko giu. Mba sauginemo Maimaituwa kaka giu ya vitemi te bainewa ko giu. ");
INSERT INTO kqf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Banina giu ko vatodina ba mote temi koma giugiu, bi Tamemi Aluwina kaka giu ya vitemi te lisidimo ko giu. ");
INSERT INTO kqf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mba laḡannemo olooloto kaka lava sa kaisoluḡedi te valevaletidi sai pekidi, bi libilibi tametamedi kauwina ḡemotina natunatudi lisidimo sa voiye, bi libilibi kota tametamedi sai ḡaviyedi bi sai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tagu dabagumo kaka lava matabudi sa dabokemi, bi tana aiyai ya moimoitodidinana ba damonemo ya yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bamo malagainemo sa laukivigebogeboyemina, ba kamaina te mba malagaina ko gose, bi ko nawa malagai ḡesaunemo. Bi yà giugiu kauwemi te temi mote emi noya komai kovidi Islael taunidimo, bi Tana Taunana Natuna ya nato. ");
INSERT INTO kqf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Gomana gilugilumina mote ena tauwailovelove ima saḡa kamaḡe, ee taupaula ena bada mote ima saḡa kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bi libilibi gilugilumidi ba edi tauwailovelove vaitena ḡemoḡemotidi, bi taupaula ba mai ena bada. Bamoda vanuwa taniwagina sa giugiuwe te tana ba aluwa gebogebodi edi bada Belsebul, kamaina te ena vanuwa lavedi mainana giuna ḡemotinemo sa giuwedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Taunana aubaina lavedi koma nailedi. Bai mwalina sumamo kenakenana ba ya nuwatanesa. Laḡan ya natonatona kaka bai mwalidi sa kenakena waidavonana ba sa laumaḡata. ");
INSERT INTO kqf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bi dudubalemo bai e giugiuwemina, temi kaka suwalemo ko giuwedi, bi tagu bai kandavonemo beyemimo e kasakasavemina ba vanuwa dabedimo koi noyanoyae. ");
INSERT INTO kqf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Lava tubuḡa taunaḡa tauwaipekidi mote koma nailedi, tedi mote ḡemoḡemotina aluwimi simai pekidi. Maimaituwa tana taunana ko naile, banina tana tubuḡimi bi aluwimi ḡemoḡemotina iyoyoḡamo ya kagebogebodi. ");
INSERT INTO kqf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Niga ko noḡoti, mwanuwa mavumavuyam a keikeilika kauwa ḡemoḡemotina 10 toyamo labu ko gimala, ḡemota bi doḡamo i kuluvana ba Tamemi Maimaituwa mote ima noḡoti kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Temi kota mainana dabemi iyevina wapana matabuna i sibe kovi. ");
INSERT INTO kqf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Taunana aubaina mote koma naila, banina temi noḡotimi i didiga gulatana, mote mai mwanuwa mavumavuyam. ");
INSERT INTO kqf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Aiyai i vite munaḡe bi lava matedimo ya kakamaḡatiguna, ba tagu kaka Tamagu matanemo malamo yà kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bi aiyai ya valevaleleguna lava matedimo, ba tagu kaka Tamagu malamo matanemo yà valeleye. ");
INSERT INTO kqf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bi koma wainoḡota bena tagu nuwauba e vai yovoḡe dobumo. Tagu e yovona mote nuwauba bi kepata e yovoḡena daila aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tagu e yovona ba yà voiyemi te, oloto natuna olotona vaitena sai saḡasaḡa bi gomana waivinina tinana vaitena sai saḡasaḡa bi vesala lawana vaitena sai saḡasaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lava ena ḡaviya ba ena vanuwa nopona lavedi. ");
INSERT INTO kqf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tana aiyai tamana bi tinana ya ḡoyeḡoye gulatedina mote mai tagu, ba mote ḡemoḡemotina te egu tauwaikaiwatana, bi tana aiyai bi natuna olotona ee waivinina ya ḡoyeḡoye gulatena mote mai tagu, ba mote ḡemoḡemotina te egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bi aiyai mote ena kolosi ima avali bi ima kaiwatagu ba tana mote ḡemoḡemotina te egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tam aiyai em yawasana kuna nuwevina ba mote kuma banavi, bi tam aiyai bi em yawasana kuna nuwakamaḡena tagu aubaigu ba muliḡa, yawasana kwa vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tana aiyai temi ya giugiuvaimina, ba tagu vaitegu ya giugiuvaigu. Bi aiyai tagu ya giugiuvaiguna ba taugiukamaḡegu vaitena ya giugiuvai. ");
INSERT INTO kqf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tana aiyai taugiuwatana i giuvaina banina tana ba taugiuwatana, aubaina te taugiuwatana kaka ena maii'a ya vai. Bi tana aiyai didimana lavana i giuvaina, banina tana ba didimana lavana, aubaina te tana kaka didimana lavana ena maii'a ya vai. ");
INSERT INTO kqf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bi bamoda aiyai gauba leduna taukaiwatagu sivusivuyovoḡedi i vitedina ba yà giugiukauwemi te tana kaka ena maii'a ya vai.” ");
INSERT INTO kqf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ena tauwaikaiwatana 12 i giu wailovelovedi, mulinemo tana i nawa Galili taunidimo te yai lovelove bi ya lauguguya. ");
INSERT INTO kqf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Laḡannemo Diyoni biliwelokomo i miyamiya ba Keliso bai i voivoiyedina giudi i vaiyedi bi ena tauwaikaiwatana i giukamaḡedi ");
INSERT INTO kqf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te Yesu sai talayaena gado, “Tam taunana Tauwaiyawasana a giugiuwemna kuna tava ee lava ḡesauna ka labe?” ");
INSERT INTO kqf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bi Yesu edi giu i waimunena gado, “Ko munaḡa bi bai lisigumo kona vaivaiyena bi kona kitekitedina, mba taudidi Diyon ko talavite. ");
INSERT INTO kqf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Lava matapotepotedi sa waikita munaḡa, kaḡenuwanokudi ba sa nawanawa, kapa vaivaidi sa yawayawasana, beyapotepotedi sa waibeyavaiya, lava pekipekidi sa kenakena moito munaḡa, bi lava waiyamoyamonidi Maimaituwa giuna visuvisuna sa vaivaiye. ");
INSERT INTO kqf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lava aiyai ya waisumaḡeguna bi mote ima nuwakulukuluva ba tana kakavisuvisuna.” ");
INSERT INTO kqf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Laḡannemo Diyon ena tauwaikaiwatana a munamunaḡa ba Yesu lava kumna lisidimo Diyon i waigayo watana gado, “Temi wala kona nawa kalakalalelemo, Diyon lisinemo kona kitana, kitana bainewa? Maibena yavala vagala i suvesuvelemedina mainana kona kita, ee? ");
INSERT INTO kqf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bamoda mote mainana ko kita, te lavana bainewa kitana kona kita? Gala visuvisudi i kotekotedi kona kita? Geḡa, lava ḡalibona ena vanuwemo taumiya gala visuvisudi sa kotekotedi. ");
INSERT INTO kqf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Temi kona nawana bai kona kita? Taugiuwatana, ee? Emaso, yà giugiuwemi te Diyon i saḡa gulata mote mai taugiuwatana ḡesaudi.” ");
INSERT INTO kqf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Gilugilumina wadubonemo tana taunana a gilumi watana gado, ‘Tagu kaka egu tauwainoyanoya yà gei giukamaḡe te tana kaka tam em eta ya yawasi.’” ");
INSERT INTO kqf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Tagu giukauwa yà giugiuwemi te dobumo Diyon i saḡa gulatana mote mai lava matabumi. Bi lava aiyai i sakosakoyovoḡena mala ena waibada noponemo ya miyamiyana ba tana i tausaḡana mote mai Diyon. ");
INSERT INTO kqf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Diyon taukabulu ena laḡanmo te niganana, lava edi ḡailisi ai laulubudi te lava mala ena waibada noponemo miyemiyedi a waiḡaviyedi, banina tedi edi ḡowana maso mala ena waibada ai badae. ");
INSERT INTO kqf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Taugiuwatana matabudi bi Mousis ena waiḡake Maimaituwa ena waibada a giugiuwatana eete Diyoni ena laḡan i tava. ");
INSERT INTO kqf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bamoda Elaidiya ko labelabe te ya tavana ba Diyon taunana Elaidiya, tana bai ya giugiuwena taunana ko vaiye. ");
INSERT INTO kqf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Temi waibeyemi te koi beyavaiya. ");
INSERT INTO kqf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Niga kimtina bai mwalina yà laukoiluvae? Tedi maibena libilibi aniwaikunekune gabudimo sa miya bi sa waimuduveleyana gado, ");
INSERT INTO kqf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tama naḡi salena ke saleye bi mote ko biga bi peki ḡabanemo ke ḡabalauiyava bi mote ko ḡaba.’ ");
INSERT INTO kqf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mainana laḡannemo Diyon i tavana ba mote i kanikani bi wain i tegotego, tana a giuwena gado, ‘Tana aluwa gebogebona i sunei.’ ");
INSERT INTO kqf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bi Tana Taunana Natuna i tavana ba a giuwena gado, ‘Niga taunana taugudaguda, tautegotego, takis taulaitupedi bi gebogebo lavedi edi tau.’ Nuwauyauya didimanina ko vaina ba Diyon bi tagu ema wailovelove ko kaiwatedi.” ");
INSERT INTO kqf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu bamo taundimo anisove kauwidi i voivoiyedina mba lavedi edi gebogebo mote a kuvesidi taunana aubaina, i giugiumataidina gado, ");
INSERT INTO kqf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“I gebo kauwa Kolasin bi Betsaida lavemi lisimimo! Bamoda lisimimo anisove kauwidi e voivoiyedina mainana Taiya bi Sidon lisidimo e voiyedi, tedi maso maḡokana laukuvasa galedi a kotedi, ai kovutopedi bi edi gebogebomo a laukuvasa. ");
INSERT INTO kqf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tagu yà giugiu kauwemi te malaetala laḡannemo tagu kaka Taiya bi Sidon yà launuwatoitoiyedina kaka temi Kolasin bi Betsaida lavemi. ");
INSERT INTO kqf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bi Kapeniyam lavemi, temi bena Maimaituwa ya nawemi malamo? Geḡa, temi kaka Maimaituwa ya pwalaḡe nawemi pekipekidi edi gabumo. Bamoda temi lisimimo anisove kauwidi e voivoiyedina mainana Sodom malagainemo e voiyedi, tedi maso a laukuvasa bi malagaina visuvisuna i kena te niga laḡandimo. ");
INSERT INTO kqf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tagu yà giugiuwemi te malaetala laḡannemo ba Sodom kovoḡa ḡaubona ya vai bi taun waisumaḡa geḡemi temi kaka kovoḡa dididiga ko vai.” ");
INSERT INTO kqf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mba sauginemo Yesu i laupalina gado, “Tamagu, mala bi dobu Badana, yà kakasaḡesaḡem, banina tam lava mabai a noḡoti munaḡedi te tedi anapu bi sibe lavedi, ba lisidimo niga kauwidi kuna sivuwaidavonedi bi lava edi yawasana maibena libilibi lisidimo kuna kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tamagu giukauwa te niga kauwidi ba em ḡowanemo sa tubutubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tagu mwali matabudi Tamagu i vitegu. Bi aiyai mote Natuna i sibe te Tamana taunaḡa. Aiyai mote Tamana i sibe te Natuna taunaḡa i sibe. Bi kota Natuna tedi mabai i vinevinedina ba tana sa kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Temi mabai nuwaboya bi vita sa pokepokemina ba ko nato lisigumo kaka waiyawasi yà vitemi. ");
INSERT INTO kqf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Egu kewa isunemo ko laulauavalana ba niga kauwidi yài lovelovemi te ko sibedi, banina tagu voyaḡota bi ḡaubo munaḡa lavagu. Taunana aubaina, tagu lisigumo ko natona kaka aluwimi sai yawasi. ");
INSERT INTO kqf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bi kewa yà vitemna ba i tekateka, ḡemoḡemotina kwa lageti bi kwa avali.” ");
INSERT INTO kqf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mba sauginemo Waiyawasi Laḡannemo, Yesu ena tauwaikaiwatana vaitedi laisi daibinaḡa a nawanawa te ena tauwaikaiwatana kani a peki. Taunana aubaina laisi a tanodi bi a kanikanidi. ");
INSERT INTO kqf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bi Palisi mainana a kitakitana ba, Yesu a giuwena gado, “Kuna kita, kauwidi Waiyawasi Laḡannemo mote maso ko voivoiyedi bi geḡa te em tauwaikaiwatana kauwidi sa voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bi Yesu edi giu i waimunena gado, “Ḡalibona Deivida ena lava vaitedi kani a peki bi Deivida bai i voivoiyena, temi kona iyevi, ee geḡa? ");
INSERT INTO kqf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tana Maimaituwa ena vanuwemo i solanawa bi buledi kakavisuvisudi i legaudi bi ena lava i vitedi te a kanidi. Bi waiḡake ya giugiu te mba buledidi ba pilisi taudiḡa sa kanikanidi. ");
INSERT INTO kqf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bi temi Mousis ena waiḡake kona iyevi ee geḡa? Pilipilisi Waiyawasi Laḡandimo Maimaituwa ena vanuwa noponemo a noyanoyana ba Waiyawasi Laḡanna ena waiḡake a waidoukoto, bi geḡa te mba mote gebogebo a voivoiye. ");
INSERT INTO kqf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tagu yà giugiuwemi te lava ḡemota nopodemo ena wailovelove i saḡa gulata mote mai pali vanuwina. ");
INSERT INTO kqf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bi gilugilumina wadubonemo i giuna gado, ‘Tagu yà ḡoyeḡoyena launuwatoi kauwina lava lisidimo ko voiye, bi kota temi musala ko laulau sewasewaena tagu mote yàma ḡoyeḡoye.’ Bamoda temi giudi banidi ko sibedina, ba mote egu tauwaikaiwatana komai wavu yababedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Banina Tana Taunana Natuna Waiyawasi Laḡanna Badana.” ");
INSERT INTO kqf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu nawa i waitubu munaḡe bi lava edi bolu vanuwina noponemo i sola saḡa, ");
INSERT INTO kqf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","bi ḡome oloto sida nima pekipeki vaivaina i miyamiya i kita. Bi Palisi eta a tavutavu te bainewa maso Yesu ai wavu. Taunana aubaina tedi Yesu ai talayenana gado, “Waiḡake bainewa ya giugiu? Waiyawasi laḡannemo kamaina te lava tai yawasani ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bi Yesu edi giu i waimunena gado, “Bamoda aiyai em sipu ḡemota Waiyawasi Laḡannemo dommo i kuluvana ba sipuna dommo kwa solu saḡe ee geḡa? ");
INSERT INTO kqf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bi lava noḡotina i didiga gulatana, mote mai sipu. Taunana aubaina Waiyawasi Laḡannemo kamaina te visu ta voiye.” ");
INSERT INTO kqf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kamaina bi Yesu mba olotona i giuwena gado, “Nimam ku tuḡu.” Ḡome oloto nimana i tuḡutuḡu ba i visuvisu munaḡana maibena nimana ḡesauna. ");
INSERT INTO kqf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bi Palisi a potiyovo a nawa bi ai ogatala te bainewa Yesu sai peki. ");
INSERT INTO kqf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ḡome Yesu i sibe te Palisi a waiogatala te tana sa vunu, taunana aubaina mba modomodona i gose. Bi i nawanawa ba lava kumdi a kaiwata bi matabudi edi sidamo i waiyawasanidi ");
INSERT INTO kqf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","bi i giu vavasaḡedi te tedi mote aiyai sima giuwe te tana lava aiyai. ");
INSERT INTO kqf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Niga kauwidi matabudi wala taugiuwatana Aisaiya lisinemo BADA bai i giugiuwedina, mainana a tubuḡa. Gilugiluminemo i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Niga ba egu Taupaula tana taunana e vine, tana nuwagu tauvaina, bi tagu tana lisinemo yà wainuwavisu. Bi tagu kaka Aluwigu yà vite, te tana lava matabudi lisidimo didimana ya lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tana mote aiyai vaitena simai kagiu bi ima lasa guda, tana mote etaḡa ima binau nawa te lava kalinana sima vaiye. ");
INSERT INTO kqf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tana mote vagala nuwayovuna ima koto kamaḡe. Bi kaipou tututukina mote imai suwavunu. Tana mainana ya voivoiyena eete dobu matabudi nopodimo lava ya kadidimani kovidi. ");
INSERT INTO kqf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mba laḡannemo kaka dobu matabudi lavedi edi waisumaḡa tana lisinemo sa sako.” ");
INSERT INTO kqf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ḡome oloto aluwa gebogebodi a sunesuneina a natome Yesu lisinemo. Mba olotona ba gumgum bi matapotapotana. Bi Yesu i waiyawasani te i waikita munaḡa bi giu i waitubu. ");
INSERT INTO kqf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bi lava matabudi Yesu a soveye bi a giuna gado, “Augunai niga ba ḡalibona Deivida natuna, ee?” ");
INSERT INTO kqf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bi Palisi niga mainana a vaivaiye ba a giuna gado, “Mba aluwa gebogebodi edi bada isana taumudulele, tana Yesu i sunei bi ḡailisi i vite te aluwa gebogebodi ya kwavidi bi sa potipotiyovo.” ");
INSERT INTO kqf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bi Yesu edi noḡota i sibedi, taunana aubaina i giuwedina gado, “Bamoda ḡalibona ena waibada noponemo taudiḡa sa daili munaḡedina ba taudiḡa sa kakagebogebodi. Bi bamo taunina ee vanuwina noponemo taudiḡa sa dailidi bi sa waiḡasiḡasina ba sa kakagebogebo munaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mba kauwina ḡemotina mainana, bamoda Seitan ena waibada noponemo sa dailidi bi sai ḡasiḡasina ba taudiḡa sa kaka gebogebo munaḡedi bi mba waibadana mote ima kena nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bamoda tagu taumudulele ena ḡailisimo aluwa gebogebodi yà kwavikwavivaidi te temi Palisi ko giu, emi tauwaikaiwatana aiyai ena ḡailisimo aluwa gebogebodi sa kwavikwavivaidi? Emi tauwaikaiwatana sa kaka maḡatimi te temi ba kaikaiyovumi. ");
INSERT INTO kqf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tagu Maimaituwa Aluwina ena ḡailisimo aluwa gebogebodi yà kwavikwavivaidi. Niga kauwinemo temi ko sibe te Maimaituwa ena waibada kaikana lisimimo i tava. ");
INSERT INTO kqf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aiyai mote oloto ḡaiḡailisina ena vanuwa ima lolo te dolinemo ya panipani kaka ena vanuwa ya lolo te ena ḡonaḡona ya legau kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tana aiyai ya waiḡaviyeguna ba mote egu tau. Bi aiyai mote vaitena kama noyanoya ḡemota ba egu lava ya suwasuwa waidabalalidi. ");
INSERT INTO kqf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Taunana aubaina, lava aiyai Maimaituwa ya giugiu waigebogebona bi ya waidiboḡina ba ena gebogebo ya noḡoti kamaḡedi. Bi tana aiyai Aluwa Waiyawa ya waidiboḡina, ba ena gebogebo mote Maimaituwa kaka ima noḡoti kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lava aiyai Tana Taunana Natuna lisinemo ya giugiu vitavitalana ba Maimaituwa kaka ena gebogebo ya noḡoti kamaḡedi. Bi aiyai te Aluwa Waiyawa lisinemo ya giugiu vitavitalana ba mote ena gebogebo ima noḡoti kamaḡedi, niganana eete laḡan damonemo. ");
INSERT INTO kqf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kai ko komaniyena kaka ya vota kauwa, bi kai mote koma komaniye ba kaina mote ima vota. Banina kai votanemo kaka ta sibe te mba kaina visuvisuna ee gebogebona. ");
INSERT INTO kqf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Temi mwata salama natunatuna! Nopomi gebogebo i wanavu te bainewa visu ko giuwata? Banina lava noponemo bai i wanavu bi ya kenakenana, taunana mudunemo ya potipotiyovo. ");
INSERT INTO kqf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lava visuvisuna nopona visu i wanavu, taunana aubaina kauwa visuvisudi ya voivoiyedi. Bi lava gebogebona nopona gebo i wanavu, taunana aubaina kauwa gebogebodi ya voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tagu yà giugiuwemi te etala laḡannemo lava giu gebogebodi matabudi mududimo sa potipotiyovona dabedimo kaka Maimaituwa ya etaledi. ");
INSERT INTO kqf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bi Maimaituwa kaka tam em giu luvanemo ya kovoḡim, bi kota em giu luvanemo yai yawasanim.” ");
INSERT INTO kqf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kamaina bi palisi bi waiḡake tauwailovelovedi ḡesaudi Yesu a giuwena gado, “Tauwailovelove, tama ka ḡoyeḡoyena anisove matailina kwa voiyedi te ka kitedi.” ");
INSERT INTO kqf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bi tana i giuwedina gado, “Niga kimtimi temi gebogebo lavemi bi waimatawapemi! Bi ko ḡoeḡoe te mataila ko kita. Yà giugiuwemi te temi mote mataila koma kita, bi taugiuwatana Diyona lisinemo mataila i tubutubuḡana taunana ko noḡoti. ");
INSERT INTO kqf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Te Diyona iyana noponemo i miyana ba laḡan faiona bi dudubala faiona. Mba kauwina ḡemotina mainana Tana Taunana Natuna kota doḡa noponemo ya kenana laḡan faiona bi dudubala faiona. ");
INSERT INTO kqf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bi malaetala laḡannemo Ninive lavedi bi temi niga kimtina lavemi kaka pekimo ko moito munaḡa bi tedi kaka sa giuwemi te iyoyoḡamo ko nawa. Banina Diyona i laulauguguya laḡannemo ba Ninive lavedi tana ena giu a vaiye bi a nuwavitala. Bi niga ḡome niganana lava ḡemota tana Diyona i saḡa kamaḡe, bi temi tana ena giu mote ko vaiye bi ko nuwavitala. ");
INSERT INTO kqf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bi kota malaetala laḡannemo Siba edi ḡalibona waivinina bi niga kimtimi tana vaitena kaka pekimo ko kenamoito munaḡa. Bi tana kaka ya giuwemi te iyoyoḡamo ko nawa. Banina mba ḡalibonina waivinina wala tana Idip yawaninaḡa i saḡa, Solomon ena nuwauyauya vaiyena aubaina. Bi niga ḡome niganana lava ḡemota tana Solomon i saḡa kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bi laḡannemo aluwa gebogebona lava i potiyovo kamaḡena, ba ya nawa dobu tatakalidiḡa animiya ya tavutavu te yai yawasi bi mote ima banavi ");
INSERT INTO kqf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ba ya giuna gado, ‘Tagu lava e gosegosena lisinemo yà munaḡa.’ Bi sauginemo lavana lisinemo ya tavatava munaḡa ba ya kita te lavana nopona kavakavana, laulauḡiliḡilina bi ḡonaḡona sivusivu kauwedi. ");
INSERT INTO kqf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ḡome te ya munaḡa bi aluwa gebogebodi ḡesaudi, wapedi 7 yai dolidi. Bi mba aluwidi tedi a gebogebo gulatana mote mai tana. Tedi vanuwina noponemo sa sola saḡa te sa miya. Mba lavana ena yawasana ya gebogebo gulatana mote mai wala i miyamiyana. Mba kauwina ḡemotina mainana kota niga kimtina lisidimo kaka ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu yaḡolo lava kumna lisidimo i giugiu ba tinana bi tasitasina a tava. Tedi didiyaumo a moito bi a ḡoyeḡoyena maso Yesu vaitena ai giugiu. ");
INSERT INTO kqf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kamaina bi lava ḡemota Yesu i giuwena gado, “Tinam bi tasitasim doḡamo sa moimoito, bi sa ḡoyeḡoye te vaitedi koi giugiu.” ");
INSERT INTO kqf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ḡome Yesu giu i waimunena gado, “Aiyai tinaguna bi mabai tasitasigudi?” ");
INSERT INTO kqf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bi tana ena tauwaikaiwatana lisidimo nimana i waiyoyo bi i giuna gado, “Niga taudidi tinatinagu bi tasitasigu. ");
INSERT INTO kqf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Banina tana aiyai Tamagu malamo ena ḡowana ya voivoiyedina, tana taunana tasiotigu, nuvuotigu bi tinaotigu.” ");
INSERT INTO kqf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mba laḡanna ḡemotinemo Yesu vanuwa i potiyovo kamaḡe, i yovo i nawa topa diyanemo i miya wailovelove aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bi lava kumdi a tava a moito kwaivivile, taunana aubaina te tana wagamo i moito saḡa bi lava matabudi ba gelemo a moito. ");
INSERT INTO kqf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mba ḡome tana kauwa wapewapedi lautaulalamo i wailovelovedi bi i giuwedina gado, “Laḡan ḡemota taubayau i nawa ena pesi aulaunaḡasedimo. ");
INSERT INTO kqf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tana pesi i laulaunaḡasedina ba pesi ḡesaudi etamo a talaḡa bi mwanuwa a tava te a kani kovidi. ");
INSERT INTO kqf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bi pesi ḡesaudi doḡa waitelitelinemo a talaḡa te a duga makai, banina doḡa mote i didiga. ");
INSERT INTO kqf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bi laḡannemo suwala i lalanina ba pesidi a welai, banina tedi mote lamlamdi doḡamo a yovo gulata. ");
INSERT INTO kqf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bi pesi ḡesaudi gedala nopodimo a talatalaḡana ba gedelidi pesi a yavanidi te mote a bani. ");
INSERT INTO kqf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bi pesi ḡesaudi doḡa visuvisunemo a talatalaḡana ba a duga te a vota bi votedi ba 100, 60 bi ḡesaudi ba 30. ");
INSERT INTO kqf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tana aiyai waibeyana te yai beyavaiya kauwa.” ");
INSERT INTO kqf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kamaina bi Yesu ena tauwakaiwatana a tava lisinemo bi ai talayena gado, “Bai aubaina lautaulalamo lava kwa giugiuwedi?” ");
INSERT INTO kqf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bi tana edi giu i waimunena gado, “Mala ena waibada sibena ba Maimaituwa temi i vitemi bi lava ḡesaudi mote i vitedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tana aiyai niga kauwidi ya sibesibedina ba Maimaituwa kaka sibena lisinemo yai lautawi. Bi aiyai mote niga kauwidi i sibedi ba avena te sibe ḡaubona lisinemo bi Maimaituwa kaka ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Taunana aubaina, tagu lava lisidimo lautaulalamo yà giugiuwedi. Tedi sa kitakitana bi mote sima kita banavi, sa vaivaiyena bi mote sima vaiye ḡone. ");
INSERT INTO kqf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Taugiuwatana Aisaiya wala nove bai i giugiuwena, niganana tedi lisidimo ya tubutubuḡa.” “Tana i giuna gado, ‘Temi ko vaivaiyena bi mote koma sibesibe, ko kitakitana bi mote koma kitakita banavi. ");
INSERT INTO kqf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Banina niga lavedi nopodi ḡaiḡaidi. Tedi waibeyedi bi mote sima waibeyavaiya kauwa, tedi waimatedi bi mote sima waikita kauwa, banina tedi matedi a pota. Male matedimo sai kita, beyedimo sa vaiye bi nopodimo sa sibe, tedi mainana sa voivoiyena, banina mote sima ḡoyeḡoye te edi gebogebo sa kuvesidi bi yài yawasanidi.’ ");
INSERT INTO kqf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Bi temi koi nuwavisu, banina matemimo ko kitakita bi beyemimo ko vaivaiye. ");
INSERT INTO kqf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tagu giukauwemo yà giugiuwemi, te taugiuwatana wapewapedi bi didimana lavedi wala a ḡoyeḡoyena maso niga kauwidi a kitedi bi a vaiyedi. Bi geḡa te, mote a kitedi bi a vaiyedi maibena niganana temi ko kitekitedina bi ko vaivaiyedina. ");
INSERT INTO kqf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Koi beyavaiya bi taubayau lautaulalana banina yà giuwemi: ");
INSERT INTO kqf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lava mabai Maimaituwa ena waibada giuna visuvisuna sa vaivaiye bi banina mote sima sibesibe ba maibena pesi etamo talatalaḡidi. Seitan ya tava te bai sa vaivaiyena nuwapoudimo ya kaikaikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bi lava mabai manuwavisudi giu visuvisuna sa vaiye bi sa waianinena ba maibena pesi doḡa waitelitelinemo talatalaḡidi. ");
INSERT INTO kqf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bi laḡannemo pilipili ee laukivigebogebo sa natona Maimaituwa giuna aubaina, ba tedi mote sima moimoitodidina, banina lamlamdi mote a yovo gulata. ");
INSERT INTO kqf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bi pesi gedala nopodimo talatalaḡidi ba lava mabai Maimaituwa giuna sa vaivaiyena bi dobu nuwaboyedi bi waiguyau noḡotidi nopodi sa waiwanavudi te mote sima votavota. ");
INSERT INTO kqf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bi lava mabai Maimaituwa giuna sa vaivaiye bi sa sibesibena, ba maibena pesi doḡa visuvisunemo sa talatalaḡana, tedi giu sa vaiye bi sa miyamiyaena ba sa vota bi votedi ba 100, 60 bi 30.” ");
INSERT INTO kqf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu lautaulala ḡesauna i giuwedina gado, “Mala ena waibada ba maibena oloto pesi visuvisudi ena daibimo i laulaunaḡasedina. ");
INSERT INTO kqf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tedi dudubalinemo a kenakena ba kana ḡaviya i tava te daibinemo pesi visuvisudi nopodiḡa ḡawaḡawa i launaḡasedi te i nawa. ");
INSERT INTO kqf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Laḡannemo pesi visuvisudi a kalakalanapu ba ḡawaḡawa vaitedi a duga ḡemota. ");
INSERT INTO kqf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Daibi taniwagina ena taupaula a tava lisinemo bi ai talayena gado, ‘Bada, tam bena pesi visuvisudi daibimo ku launaḡasedi. Niga ḡaweḡawedi bamo maiḡa a tava bi sa dugaduga?’ ");
INSERT INTO kqf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bi tana edi giu i waimunena gado, ‘Mba ḡaviya i launaḡasedi.’ Bi ena taupaula ai talayena gado, ‘Bainewa kwa noḡonoḡoti, ka nawa ka laka kamaḡedi, ee?’ ");
INSERT INTO kqf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bi edi giu i waimunena gado, ‘Avena! Bamoda ḡawaḡawa koma lakelakedi bi witi vaitedi koma lakedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ko gose kamaḡedi te matabudi sa duga ḡemota eete vililubu laḡanna. Mba laḡannemo tagu kaka tauvililubu yà giuwedi te ḡawaḡawa sa gei lakedi, sa pani bwainidi bi kaimo sai kalaḡosedi. Bi witi sai ḡemotidi te sa saḡedi egu susuḡumo.” ");
INSERT INTO kqf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bi Yesu lautaulala ḡesauna i giuwedina gado, “Mala ena waibada ba maibena wasiva pesina, lava ya vai te ena daibimo ya wadi. ");
INSERT INTO kqf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mba pesina ba pesi ḡaubo otina, bi laḡannemo i dugana ba kai matabudi ya saḡa tawedi bi yai kaibada te mwanuwa sawasawaḡa lovolovodi sa tava bi lagalaganemo sa launoḡi.” ");
INSERT INTO kqf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bi yaḡolo te lautaulala ḡesauna i giuwedina gado, “Mala ena waibada ba maibena muu'a, waivini ya vai, falawa noponemo ya vitale, bi ya gwadai te falawina nopona matabuna muu'a ya nawae.” ");
INSERT INTO kqf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu niga kauwidi matabudi lava kumna lisidimo lautaulalamo i giugiuwedi. Bai laḡannemo mote giu baniotidi i giuwedi bi lautaulalamo tedi i giugiuwedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Niga kauwina Maimaituwa wala taugiuwatana i giugiuwena mainana i tubuḡa. Taugiuwatana i giuna gado, “Tagu kaka lautaulalamo yà giuwemi, ‘Pakanemo dobu i tubuḡa bi i saḡa te niganana giu kenakena waidavonidi yà giuwemi.” ");
INSERT INTO kqf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ḡome Yesu lava kumna i gosedi bi i valageta vanuwemo. Bi ena tauwaikaiwatana a tava lisinemo bi a giuwena gado, “Aee Bada, ḡawaḡawa daibimo dugedugedi lautaulalana maso lisimaimo kuna giu waiipoipo.” ");
INSERT INTO kqf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bi Yesu edi giu i waimunena gado, “Pesi visuvisudi tauwadidi ba Tana Taunana Natuna. ");
INSERT INTO kqf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Daibi ba niga dobuna, bi pesi visuvisudi ba tauwaisumaḡa, tedi taudidi Maimaituwa ena waibada noponemo sa miyamiyana. Bi ḡawaḡawa ba tedi Seitan natunatuna. ");
INSERT INTO kqf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bi ḡaviya ba Seitan tana ḡawaḡawa taulaunaḡasedi. Bi vililubu ba laḡan damona bi tauvililubu ba aneya. ");
INSERT INTO kqf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Bi ḡawaḡawa bainewa sa lakedi, sa pani bwainidi bi kaimo sa waikalaḡosedina ba mainana kauwina ḡemotina laḡan damonemo ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tana Taunana Natuna kaka ena aneya ya giukamaḡedi, te ena waibada noponemo gebogebo tauwaitubudi bi tauvoiyedi matabudi sai ḡemotidi ");
INSERT INTO kqf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bi kai kalakalatinemo sa pwalaḡe nawedi. Bi ḡome kaka sa lauaiyoi bi mwakedi sa sanawaikikokikodi. ");
INSERT INTO kqf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bi didimana lavedi kaka Tamedi ena waibada noponemo sa yanana maibena suwala. Tana aiyai waibeyana te yai beyavaiya bi ya sibe.” ");
INSERT INTO kqf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mala ena waibada ba maibena aniwaiguyau ḡoneḡonedi, doḡa noponemo kenakena waidavonidi. Laḡannemo lava i banabanavi ba i ḡuluvi munaḡe, ḡome tana mayasisina i nawa bi ena ḡonaḡona matabudi i kuneye kamaḡedi. Bi manena matabuna i vai bi i tava munaḡa te mba doḡana i gimeli. ");
INSERT INTO kqf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Bi kota, Mala ena waibada ba maibena tauwaikunekune ḡemota, posalu visuvisuna i tavutavu te maso i gimeli. ");
INSERT INTO kqf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Laḡannemo tana posalu maiina dididiga i banabanavi ba i munaḡa bi ena ḡonaḡona matabudi i kune kamaḡedi bi manenemo posalu i gimeli.” ");
INSERT INTO kqf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Bi kota, mala ena waibada ba maibena gomo, topamo sa pwalaḡe, bi iyana tabudi bi tabudi sa konekonedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Laḡannemo gomo i wanavuna ba sa solusaḡe balabalamo bi sa miyatulu, te iyana visuvisudi poa'a noponemo sa sivudi bi gebogebodi sai naḡasedi. ");
INSERT INTO kqf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Niga kauwina mainana kaka laḡan damonemo ya tubuḡa. Mba laḡannemo aneya kaka sa yovo te didimana lavedi nopodimo gebogebo lavedi sa daliḡidi, ");
INSERT INTO kqf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","te gebogebo lavedi kai lemlemnemo sa pwalaḡe nawedi, bi ḡome kaka sa lauaiyoi bi mwakedi sa sanawaikikokikodi.” ");
INSERT INTO kqf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bi Yesu ena tauwaikaiwatana i waitalayedina gado, “Niga kauwidi matabudi kona sibedi ee geḡa?” Bi tedi ena giu ai munena gado, “Emaso, bena ke sibedi.” ");
INSERT INTO kqf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bi Yesu i giuwedina gado, “Taunana aubaina, waiḡake tauwailovelovena ḡesaudi ba Mala ena waibada wailovelovena kaikana a vai, tedi ba maibena vanuwa taniwagina ena susuḡumo aniwaiguyau mwalidi valivaliudi bi wadubodi ya yovodi te ya kitedi bi lava ya wailovedi.” ");
INSERT INTO kqf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Laḡannemo Yesu lautaulala giudi i waiwaikovidi ba dobuna i gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tana i munaḡa ena malagai otinemo, bi ḡome bolu vanuwidiḡa lava i waiwailovelovedi. Tedi a soveye bi ai talana gado, “Niga lavana bamo ḡome nuwauyauya bi ḡailisi i vai bi anisove kauwidi ya voivoiyedi? ");
INSERT INTO kqf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tana bena taukamda natuna? Tinana bena isana Meli, bi tasitasina ba Diyemesi, Diyosep, Saimon bi Diudas? ");
INSERT INTO kqf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nuvunuvuna matabudi bena vaiteda niga? Niga olotona kauwidi matabudi bamo ḡome i legaudi?” ");
INSERT INTO kqf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bi ḡome te Yesu a daboke. Bi Yesu i giuwedina gado, “Taugiuwatana ena malagai bi ena vanuwa lavedi ba mote sima vivivile.” ");
INSERT INTO kqf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Taunana aubaina, mba malagainemo Yesu mote mataila wapewapedi i voiyedi, banina tedi mote ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mba sauginemo Alodi Galili tauwaibadayena Yesu giuna i vaiye, ");
INSERT INTO kqf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","bi ena taupaula i giuwedina gado, “Niga lavana ba Diyon taukabulu, tana pekimo i kena moito munaḡa, taunana aubaina ḡailisi lisinemo ya kenakena bi mataila ya voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Alodi niga mainana i giuna, ba tana wala Diyon i pani bi biliwelokomo i sako nawe, valetina Pilipi mwanena Elodiyas dabanemo. ");
INSERT INTO kqf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Diyon, Alodi i giugiu mataina gado, “Mote i visu te Elodiyas kwa naḡi, banina mba ba valetim mwanena.” ");
INSERT INTO kqf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mba giuna aubaina Alodi i ḡoyeḡoye te Diyoni maso i waipeki. Bi lava i nailedi, banina tedi a sibe te Diyon ba taugiuwatana. ");
INSERT INTO kqf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bi Alodi ena tubuḡa soina noponemo, Elodiyas natuna waivinina wale aubaidi i bigabiga ba Alodi nuwana i laukwasili. ");
INSERT INTO kqf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Taunana aubaina, Alodi i giuwapa te bai yai baḡayena ba ya vite. ");
INSERT INTO kqf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kamaina bi gomana tinana kalinana i lauwata te Alodi i giuwena gado, “Tagu yà ḡoyeḡoyena Diyon taukabulu kununa abomemo kwa sako, bi kwa vitegu.” ");
INSERT INTO kqf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bi ḡalibona i wainuwaboya gulata bi i waiuvala, bi kaikana i giuwapa ena wale matedimo taunana aubaina te gomana ena ḡowana ya voiye. ");
INSERT INTO kqf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ḡome Alodi tauwaiḡaviya i giukamaḡe biliwelokomo te Diyon gadona a bwaliḡavuki, ");
INSERT INTO kqf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","bi kununa abomemo a sako, bi gomana guguinina a vite, te i avali nawe tinana i vite. ");
INSERT INTO kqf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bi Diyon ena tauwaikaiwatana a tava, tubuḡina a avali nawe a dobo, bi a nawa te Yesu a giuvite. ");
INSERT INTO kqf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Laḡannemo Yesu Diyon noyana i vaivaiye, ba wagamo i gelu bi i nawana dobu ḡuyuwinemo. Bi lava kumdi a vaivaiye ba edi malagai a gosedi bi kaḡediḡa a vawata. ");
INSERT INTO kqf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Laḡannemo Yesu wagamo i potipotiyovo, ba lava kumdi i kitedi, ba i launuwatoiyedi bi sidesidedi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bi mba aubiganemo, ena tauwaikaiwatana lisinemo a nato bi a giuwena gado, “Bada, niga ba mutuyuwa bi kaikana tautaugudu. Lava kwa giukamaḡedi sa nawa malagaiḡa te kediya sa gimala.” ");
INSERT INTO kqf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bi Yesu edi giu i waimunena gado, “Tedi mote sima nawa, temi koi kanidi.” ");
INSERT INTO kqf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bi tana a giuwena gado, “Tama mote bai lisimaimo, kamaina buledi 5 bi iyana labu ota.” ");
INSERT INTO kqf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bi Yesu i giuwedina gado, “Ko natomedi lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tana lava i giuwedi te ḡawaḡawa dabedimo a miya. Bi buledi 5 bi iyana labu i legaudi, i waikita saḡa malamo, i waiebo bi buledi i kividi. Kamaina bi ena tauwaikaiwatana i vitedi te lava a vite nawedi. ");
INSERT INTO kqf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bi lava matabudi a kani te a kani nonoḡa. Kamaina bi tauwaikaiwatana lava kani a kanikani sivudina, ai ḡemoḡemotidi te po'a wapedi 12 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lava ḡome a kanina ba olooloto wapana 5 tausan, waiwaivini bi libilibi mote a iyevidi. ");
INSERT INTO kqf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mba kauwina mulinemo, Yesu ena tauwaikaiwatana wagamo i waigeludi bi a damana, a nawanawa noi nevanemo ba kota lava i giukamaḡedi te a nawa edi malagaiḡa. ");
INSERT INTO kqf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bi lava i giukamaḡedi mulinemo, tana i nawa oya dabanemo, pali aubaina. Mba dudubalina ba taunaḡa ḡome i laulaupali. ");
INSERT INTO kqf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bi waga ba kaikana topa modona i nawanawae. Bi ḡome yavala dididiga i talatalaḡa taunana aubaina labama waga i waikati vitavitale. ");
INSERT INTO kqf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Laḡan tinana bwaganemo, bi Yesu topa dabanaḡa i nawanawa ena tauwaikaiwatana lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Laḡannemo ena tauwaikaiwatana a kita topa dabanaḡa i natonato ba tedi a naila gulata bi a galalana gado, “Noi ba boita.” ");
INSERT INTO kqf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bi Yesu maḡemota i giuwedina gado, “Mote koma naila, tagu. Nuwemi ya lautou.” ");
INSERT INTO kqf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ḡome Pita i giuna gado, “Bada, bamoda giukauwa te tam ba kwa giuwegu te topa dabanaḡa yà nato lisimmo.” ");
INSERT INTO kqf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Bi Yesu Pita i giuwena gado, “Ku nato.” Bi Pita wagamo i potiyovo bi topa dabanaḡa i nawa Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bi tana yavala bi labama i kitedi bi i nainaila laḡannemo, kwaluluva i waitubu bi i binauna gado, “Bada, kwai yawasanigu!” ");
INSERT INTO kqf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Noi taunana te Yesu nimana i tuḡu bi Pita nimanemo i kabi te i solu saḡe bi i giuwena gado, “Em sumaḡa i ala ḡaubo, bai aubaina kuna nuwakulukuluva?” ");
INSERT INTO kqf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Laḡannemo tedi a moimoitosaḡa wagamo ba yavala i lautautau. ");
INSERT INTO kqf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tedi waga noponemo a miyamiyana Yesu a lauduneye bi a giuna gado, “Giukauwa te tam taunana Maimaituwa Natuna.” ");
INSERT INTO kqf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tedi a damana nawa Genesaletimo a solasaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bi laḡannemo mba dobuna lavedi Yesu a kitakita ba a kitaḡone bi Yesu giuna a giunawe te dobuna diyadiyana matabuna i nawa yaḡosi. Ḡome lava sidesidedi a tavaitedi Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bi Yesu ai baḡa te sidesidedi maso i waianinedi, te ena gala isunaḡa a taukoni. Bi lava mabai ena gala a tautaukonina, matabudi a yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ḡome Palisi bi waiḡake tauwailovelovena ḡesaudi Yelusalemḡa a tava Yesu lisinemo bi ai talayena gado, ");
INSERT INTO kqf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bai aubaina em tauwaikaiwatana wala nove magumagula edi miyamiya a sakosakona sa waidoukotodi? Tedi mote nimedi sima koḡedi bi sa kanikani!” ");
INSERT INTO kqf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bi Yesu edi giu i waimunena gado, “Bi temi bai aubaina Maimaituwa ena waiḡake ko waidoukotokotodi, bi temi emi wailovelove ko kaikaiwatedi? ");
INSERT INTO kqf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maimaituwa i giuna gado, ‘Tamam bi tinam kwa viviledi.’ Banina aiyai tamana bi tinana i pasilidina ba sai peki. ");
INSERT INTO kqf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lava aiyai bai mwalina lisinemo ya kenakenana maso tamana ee tinana i vite. Bi geḡa te, temi emi wailovelove luvanemo mote ima vitedi bi ya giuwedina gado, ‘Egu magula, tagu mote yàma sagumi banina kaikana e giuwapa te Maimaituwa yà vite.’ ");
INSERT INTO kqf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Temi emi wailovelovemo lava ko voiyedi te tametamedi bi tinetinedi mote sima sagusagudi. Temi Maimaituwa giuna ko sakosakoliye bi temi emi miyamiya ko kaikaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Temi lava kaikaiyovumi! Bai Aisaiya i giugiuwena ba giukauwa te temi i giugiuwatemi. ");
INSERT INTO kqf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Niga lavedi mududiḡa ya giugiu te Bada, Bada bi nopodi ba tabudimo mote tagu lisigumo. ");
INSERT INTO kqf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tedi sa laulaudune yababegu tedi taudiḡa edi waiḡake a voivoiyedina, taudidi lava sa wailovelovedi.” ");
INSERT INTO kqf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kamaina bi Yesu lava kumna i giuwedi a tava lisinemo bi i giuwedina gado, “Koi beyavaiya bi ko sibe kauwe. ");
INSERT INTO kqf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Lava kani ya kani te bwaganemo ya yovo bi ya potiyovo munaḡa. Bi bai gebogebona noponemo i noḡoti bi mudunemo ya potipotiyovona taunana ya waimila.” ");
INSERT INTO kqf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ḡome ena tauwaikaiwatana a tava lisinemo bi ai talayena gado, “Kuna sibe ee geḡa te bai kwa giugiuwedina ba palisi mote ai nuwavisuye?” ");
INSERT INTO kqf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu giu i waimunena gado, “Tamagu malamo miyamiyana tana dobumo kai mote i wadiwadina ba matabudi malamlamdi ya lakedi. ");
INSERT INTO kqf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ko kita kamaḡedi tedi tauwaietadoli matapotepotedi, bamoda lava matapotapotana ena tau matapotapotana ya waidolina ba labuḡidi dommo sa kuluva.” ");
INSERT INTO kqf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita i giuna gado, “Te niga lautaulalana lisimaimo ku giu waitete.” ");
INSERT INTO kqf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu i waitalayedina gado, “Temi yaḡolo te ko wainuwanaina, ee? ");
INSERT INTO kqf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kona sibe ee geḡa te lava kani ya kanikanina ba ya yovo bwaganemo te ya potiyovo munaḡa? ");
INSERT INTO kqf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lava noponemo bai gebogebona ya nogoti bi mudunemo ya potipotiyovona taunana nopona ya waimila. ");
INSERT INTO kqf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Noḡota gebogebodi maibena, waipeki, vawaidoḡa, waimatawapa, danene, waimuduna bi kaiyovumo waiwavu. ");
INSERT INTO kqf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Niga yawasanidi lava nopona sa waimila. Bi lava manima milana ya kanikanina, taunana mote ima waimila.” ");
INSERT INTO kqf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu Galili dobuna i gose bi i nawa Taiya bi Sidon palatidimo. ");
INSERT INTO kqf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ḡome Keinan waivinina i tava Yesu lisinemo bi i talaḡabalana gado, “Aee Bada, Deivida natuna, kwa launuwatoitoiyegu! Aluwa gebogebona natugu waivinina i sunei bi ya wainuwatoi gulata.” ");
INSERT INTO kqf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bi Yesu mote bai i giu lubuye, taunana aubaina ena tauwaikaiwatana a nato lisinemo bi ai baḡana gado, “Niga waivinina mulidaḡa ya nato bi ya ḡabaḡabana, kwa giukamaḡe ya nawa tabunemo. Ya waibeyawakida.” ");
INSERT INTO kqf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ḡome Yesu i giuna gado, “Tagu Maimaituwa i giukamaḡeguna Islael lavedi gwegwegwedi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bi waivini i nato Yesu kaḡepakanemo, tuwapekana i waitupagwaliḡedi bi i giuna gado, “Aee Bada, kwa kai sagugu!” ");
INSERT INTO kqf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bi Yesu giu i waimunena gado, “Mote i visu te libilibi kediya yà vai bi daḡadaḡasi yà vitedi.” ");
INSERT INTO kqf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bi waivini i giuna gado, “Bada, mba giukauwa! Bi geḡa te daḡadaḡasi tamedi ena teibolomo kani pusepuselidi ya taitaikulukuludina ba sa kanikanidi.” ");
INSERT INTO kqf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kamaina bi Yesu waivini ena giu i waimunena gado, “Waivini, em sumaḡa kota i tausaḡa, taunana aubaina bai kunai baḡaena ba yà vitem.” Mba taunana te waivini natuna i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ḡome Yesu Galili nisana diyanaḡa i saḡa i nawa oya dabanemo i miyatulu. ");
INSERT INTO kqf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ḡome lava kumdi a tava Yesu lisinemo. Bi lava kaḡedi nuwanokudi, matapotepotedi, nuwakududi, kupekupedi bi kota sida ḡesaudi vaivaidi vaitedi a tavaitedi Yesu kaḡepakanemo bi matabudi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lava kupekupedi a gagali, kaḡedi nuwanokudi a didimana, nuwakududi a nawanawa bi matapotepotedi ai kita munaḡa. Ḡome lava matabudi tedi a kitekitedina ba a sove bi Islael edi Maimaituwa a kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ena tauwaikaiwatana i giuwedi a tava lisinemo bi i giuwedina gado, “Tagu niga lavedi e launuwatoiyedi, tedi vaitedi te miya te laḡani faiona a kovi bi kani geḡa, mote yà ḡoyeḡoye te makanipekidi yà giukamaḡedi sa nawa, male etamo sa laumoyaḡau.” ");
INSERT INTO kqf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bi ena tauwaikaiwatana ena giu ai munena gado, “Niga ba mutuyuwamo ta miyamiya, bamo ḡome kani ta vai bi lava kumna tai kanidi?” ");
INSERT INTO kqf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bi tana i waitalayedina gado, “Temi buledi wapedi visa lisimimo?” Tedi ena giu ai munena gado, “Tama buledi wapedi 7 bi iyana keikeilikidi visa ota.” ");
INSERT INTO kqf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bi lava kumna i giuwedi te doḡamo a miya. ");
INSERT INTO kqf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kamaina bi tana buledi 7 bi iyana i legaudi, Maimaituwa i waiebo bi i kivikividi te ena tauwaikaiwatana i vitedi bi tedi lava a vite nawedi. ");
INSERT INTO kqf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tedi matabudi a kani te a kani nonoḡa, mulinemo ena tauwaikaiwatana kani a kanikani sivudina a laitupedi, te po'a wapedi 7 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ḡome olooloto a kanikanina ba wapedi 4 tausan bi waivini bi libilibi mote a iyevidi. ");
INSERT INTO kqf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Niga kauwina mulinemo, Yesu lava i giukamaḡedi a nawanawa ba tana wagamo i gelu saḡa bi i nawa Magadan dobunemo. ");
INSERT INTO kqf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisi bi Sadisi Yesu lisinemo a tava laulubuna aubaina bi a giuwe te mala ena mataila, yai lovedi te tana giukauwa Maimaituwa lisinaḡa i yovo. ");
INSERT INTO kqf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bi edi giu i waimunena gado, “Laḡannemo suwala ya bulubulu bi galewa ya lailaisabasaba ba ko giuna gado, ‘Bokina ba kwamla.’ ");
INSERT INTO kqf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bi olaolalemo galewa ya laisabasaba bi yai dudubalana ba ko sibe te, ‘Mateya ba nabu ya yovo.’ Temi ba yada waigayona kona sibe, bi niga laḡandimo mataila sa tubutubuḡana mote koma sibesibedi. ");
INSERT INTO kqf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Temi niga kimtimi emi kauwa gebogebodi bi tauvawaidoḡa, ko ḡoyeḡoye te mataila ko kita, bi mote kaka yàmai lovemi, te mataila Diyona lisinemo i tubutubuḡana taunana ko noḡoti.” Kamaina bi i gose kamaḡedi bi i nawa. ");
INSERT INTO kqf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Laḡannemo topa a damaniye a nawa noi nevanemo ba ena tauwaikaiwatana nuwedi i kauleya te buledi mote a vai. ");
INSERT INTO kqf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bi Yesu i giuwedina gado, “Koi kita kauwa te Palisi bi Sadisi edi muu'a ko vola kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bi tedi taudiḡa ai talapilina gado, “Tada mote buledi te vai aubaina mainana i giu.” ");
INSERT INTO kqf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tedi bai a giugiuwena ba Yesu i sibe, taunana aubaina i giuwedina gado, “Emi sumaḡa kana ḡaubo! Bai aubaina taumiḡa ko waitalapili te lisimimo buledi geḡa? ");
INSERT INTO kqf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Temi yaḡolo ko wainuwanaina, ee? Tagu buledi wapedi 5 e kividi te lava wapedi 5 tausan a kanikanina ko noḡoti, bi po'a visa konai wanavudi? ");
INSERT INTO kqf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bi kota buledi wapedi 7 bi lava 4 tausan a kanina mulinemo po'a visa konai wanavudi? Temi nuwemi i kauleya, ee? Temi mote komai noḡota kauwa. ");
INSERT INTO kqf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Temi bai e giugiuwena mote ko sibe, konai noḡota bena tagu buledi e giugiu wata? Geḡa, tagu e giuna gado, ‘Palisi bi Sadisi edi muu'a ko vola kauwedi.” ");
INSERT INTO kqf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mba ḡome kaka a sibe te tana mote muu'a buledimo vitavitalena i giugiuwe, bi tana ba Palisi bi Sadisi edi wailovelove kaikaiyovudi volayedi i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Laḡannemo Yesu, Seseliya Pilipai dobuna palatinemo i tavatava ba ena tauwaikaiwatana i waitalayedina gado, “Lava sa giugiu te Tana Taunana Natuna ba aiyai?” ");
INSERT INTO kqf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bi tedi ena giu ai munena gado, “Lava ḡesaudi sa giugiu te Diyon Taukabulu, ḡesaudi sa giugiu te Elaidiya bi kota ḡesaudi sa giugiu te Delimaiya ee wala taugiuwatana ḡemota i laumaḡata munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bi tedi i waitalayedina gado, “Bi temi ko noḡonoḡoti te tagu aiyai?” ");
INSERT INTO kqf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bi Saimon Pita giu i waimunena gado, “Tam Keliso, Maimaituwa yawayawasanina Natuna.” ");
INSERT INTO kqf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bi Yesu, Pita i giuwena gado, “Saimon, Diyona natuna, tam kakavisuvisum. Niga giukauwina mote lava ota i wailovem, bi Tamagu malamo i wailovem. ");
INSERT INTO kqf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bi yà giugiuwem te tam Pita, bi dabammo kaka Maimaituwa ena dam yà keli, te peki ena ḡailisi mote ima lauyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bi tagu kaka mala ena waibadana kiina yà vitem. Dobumo bai kwa panipanina ba mainana malamo yà pani, bi dobumo bai kwa kuvekuvesina ba mainana malamo yà kuvesi.” ");
INSERT INTO kqf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kamaina bi ena tauwaikaiwatana i waiḡakedi te mote aiyai sima giuwe, te tana taunana Keliso. ");
INSERT INTO kqf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mba sauginemo te noi i nawana, Yesu ena tauwaikaiwatana lisidimo ena peki i giu waitete te ya nawana Yelusalemmo ba kauwa wapewapedimo yai nuwatoi. Bi ḡome babada nananakidi, pilisi edi babada, bi waiḡake tauwailovelovedi, Yesu sa laukivi gebogeboye bi sai peki. Bi laḡan waifaioninemo tana ya kenamoito munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kamaina bi Pita Yesu i waidoli nawe tabunemo bi i kaipasinena gado, “Ke Bada, mba kauwina mote lisimmo ima tubuḡa!” ");
INSERT INTO kqf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ḡome Yesu i tauvitale bi Pita i giuwena gado, “Seitan, ku tauliya! Tam egu eta kwa waikoigudu, mba noḡotina mote Maimaituwa lisinaḡa i yovo, mba temi lava ota emi noḡota.” ");
INSERT INTO kqf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kamaina bi Yesu ena tauwaikaiwatana i giuwedina gado, “Bamoda tam aiyai kaiwatagu kuna ḡoyena ba em ḡowana matabudi kwa gosedi bi em kolosi kwa avali bi kwa kaiwatagu. ");
INSERT INTO kqf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aiyai bi ena yawasana i nuwamunaḡena ba ya kula yakasi, bi aiyai ena yawasana i nuwakamaḡena tagu aubaigu ba yawasana ya vai. ");
INSERT INTO kqf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bamoda aiyai dobu ena ḡowana i vai kovi bi ena yawasana i gebogebona, ba bai ya voiye te ena yawasana ya vai munaḡe? Geḡa, mote bai ima voiye. ");
INSERT INTO kqf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bi Tana Taunana Natuna kaka Tamana namalinemo ena aneya vaitedi sa yovo bi lava ḡemoḡemotaḡa bai a voivoiyedina luvanemo yai maiidi. ");
INSERT INTO kqf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yà giugiu kauwemi, temi ḡesaumi niganana kaka mote koma peki, eete Tana Taunana Natuna ena waibada ya natonatona ko kita.” ");
INSERT INTO kqf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Laḡan 6 mulidimo Pita, Diyemesi bi tasina Diyon Yesu i waidolidi te a nawa oya lofalofana dabanemo. ");
INSERT INTO kqf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bi ḡome matedimo a waikita ba Yesu kitana i launuwavitala, matana i namalana maibena suwala matana bi ena gala potina maibena suwala yanana. ");
INSERT INTO kqf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Noi taunana te Mousis bi Elaidiya a laumaḡata bi Yesu vaitena a waigiugiu. ");
INSERT INTO kqf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kamaina bi Pita Yesu i giuwena gado, “Bada, i visu te tama niga ḡome. Bamoda kwa ḡoyena ba tagu kape faiona yà voiyedi, ḡemota tam aubaim, ḡemota Mousis bi ḡemota Elaidiya.” ");
INSERT INTO kqf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yaḡolo i giugiu ba giyou potipoti otina i yovo te i sumatawedi. Bi kalina giyou noponaḡa i giu yovona gado, “Niga taunana Tagu Natugu, nuwagu tauvaina, tana ya wainuwavisugu. Kalinana ko vaiye!” ");
INSERT INTO kqf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Laḡannemo tauwaikaiwatana kalina a vaivaiye, ba manailidi a laudulu yovo doḡamo. ");
INSERT INTO kqf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ḡome Yesu i nato te i taukonidi bi i giuwedina gado, “Ko moito, mote koma naila.” ");
INSERT INTO kqf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bi a tautaulagetidi ba Yesu taunaḡa a kita bi mote aiyai ḡesauna. ");
INSERT INTO kqf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tedi oyamo bi a miyamiya kuluva ba Yesu niga mainana i giuwedi, “Temi bai kona kitakitana mote aiyai ḡesauna koma giuwe eete, Tana Taunana Natuna pekimo ya kenamoito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ḡome ena tauwaikaiwatana ai talayena gado, “Bai aubaina waiḡake tauwailovelovena sa giugiu te Elaidiya ya gei tava?” ");
INSERT INTO kqf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bi Yesu edi giu i waimunena gado, “Mba giukauwa, Elaidiya kaka ya gei tava te bai matabuna ya kanonoḡidi. ");
INSERT INTO kqf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bi yà giuwemi te Elaidiya ba kaikana i tava bi lava mote a kita ḡone, bi bai a noḡonoḡotina lisinemo a voiye. Mba mainana kota sa ḡoyeḡoyena Tana Taunana Natuna sa laukivigebogeboye bi yai nuwatoitoi.” ");
INSERT INTO kqf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mba ḡome kaka ena tauwaikaiwatana a sibe te tana Diyoni Taukabulu i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sauginemo tedi a tavatava lava kumna lisidimo ba oloto i nato Yesu matanemo, tuwapekana i tupagwaliḡedi bi i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bada, natugu kwa launuwatoiye! Tana aluwa gebogebona sulusuluvaina ba ya kakaonalele bi ya wainuwatoi gulata. Bi wali saugemo ba kaimo ya pwalapwalaḡe nawena bi wali saugemo ba gaubamo ya pwalapwalaḡe nawe. ");
INSERT INTO kqf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tana e natomena em tauwaikaiwatana lisidimo bi mote ai yawasani.” ");
INSERT INTO kqf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu i giuna gado, “Temi niga kimtimi laukasaḡaiḡaimi bi mote waisumeḡemi vaitemi te alamiya, bi kauwa e alavoiyedi? Gomana ko natome lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ḡome te Yesu aluwa gebogebona i kaipasine bi gomana i potiyovo kamaḡe. Noi taunana te gomana i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bi ena tauwaikaiwatana taudiḡa a nato Yesu lisinemo bi ai talayena gado, “Bai aubaina tama aluwa gebogebona ke kwavi kasaḡe?” ");
INSERT INTO kqf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ḡome edi giu i waimunena gado, “Banina, temi emi sumaḡa i ḡaubo. Yà giugiu kauwemi te bamoda emi sumaḡa ḡaubona maibena wasiva pouna, ba niga oyana ko giuwena gado, ‘Ku nuwaliye noi ḡome kwa nawa bi ya nuwaliya te ḡome ya nawa.’ Bai lisimimo maso mote i pilipili.” ");
INSERT INTO kqf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bi sauginemo ena tauwaikaiwatana vaitedi a waiḡemotidi Galilimo ba i giuwedina gado, “Tana Taunana Natuna kaka kana ḡaviya nimedimo sa sako. ");
INSERT INTO kqf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tedi kaka sai peki bi laḡan waifaioninemo Maimaituwa kaka ya kakenamoito munaḡe.” Ḡome ena tauwaikaiwatana mainana a vaivaiyena ba ai nuwaboya gulata. ");
INSERT INTO kqf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ena tauwaikaiwatana vaitedi a tava Kapaniyammo, ḡome takis taulaitupana i tava bi Pita i waitalayena gado, “Emi tauwailovelove pali vanuwina manena ya sakosako e geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kamaina bi Pita giu i waimunena gado, “Emaso, bena yai waimaii!” Sauginemo Pita i valageta vanuwemo, ba Yesu i gei waitalana gado, “Saimon, tam em noḡota bainewa? Mabai lisidimo ḡaliḡalibona takisi sa lailaitupa, edi dobu lavedi ee wali dobu lavedi lisidimo?” ");
INSERT INTO kqf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kamaina bi Pita giu i waimunena gado, “Wali dobu lavedi takisi sa waimaii.” Ḡome Yesu, Pita i giuwena gado, “Mba kamaina ḡalibona ena dobu lavedi mote takis simai maii. ");
INSERT INTO kqf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bi bamoda nopodi tama kagebogebo aubaina te kwa nawa topamo bi em kauli kwa pwalaḡe. Bi iyana kwa geigei soluna mba iyenina gayana kwa ḡole bi mane kwa vai te eda takis luvanemo kwai maii.” ");
INSERT INTO kqf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mba sauginemo ena tauwaikaiwatana lisinemo a tava bi ai talayena gado, “Bada, Mala ena waibada noponemo ba aiyai i saḡa gulata?” ");
INSERT INTO kqf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ḡome te Yesu gomana ḡaubona i giuwe i tava, bi mododimo i moito. ");
INSERT INTO kqf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kamaina bi i giuna gado, “Tagu yà giugiu kauwemi te aiyai em yawasana gebogebonemo kwa nuwavitalana, maibena libilibi keikelikidi edi yawasana, mba tam kaka Mala ena waibada noponemo kwa sola saḡa. Bi bamoda geḡa ba mote kuma sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taunana aubaina, aiyai kwa ḡaubo munaḡana maibena niga gomenina kaka Mala ena waibada noponemo em lava mododimo kwa saḡa gulata. ");
INSERT INTO kqf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aiyai bi isagumo niga mai gomenina ya giugiuvaina ba tagu ya giugiuvaigu. ");
INSERT INTO kqf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bamoda aiyai niga lavedi sivusivuyovoḡedi sa waisumaḡeguna i voiyedi te gebomo a kuluvana, ba i visu te ḡakima vitavitana mba lavana gadonemo sa duli bi nisa waidomdomnemo sa pwalaḡe yovoḡe. ");
INSERT INTO kqf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“I gebo kauwa te dobu lavedi edi lava sa voiyedi te edi sumaḡa sa taitaikuludi! Laulubudi ba giukauwa te sa tava bi i gebo kauwa te tana lava aiyai laulubuna ya voivoiyena. ");
INSERT INTO kqf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Bamoda nimam ee kaḡem ḡemota ya voiyem bi gebogebo kwa voivoiye ba kamaina te kwa douḡavuki bi kwa pwalaḡe. I visu te kaḡem ḡemota bi nimam ḡemota yawasana kenakena nonoḡinemo kwa sola saḡa bi mote i visu te nimam labu bi kaḡem labu bi kai kalakalatinemo sa pwalaḡe nawem. ");
INSERT INTO kqf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Bamoda matam ya voiyem bi gebogebo kwa voivoiye ba kwa ḡivoi kamaḡe bi kwa pwalaḡe. I visu te matam ḡemota bi yawasana noponemo kwa saḡa, bi mote i visu te matam labu bi iyoyoḡamo sa pwalaḡe nawem. ");
INSERT INTO kqf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Koi kita kauwa te sivusivuyovoḡedi mote koma kita waiyovoyovodi, banina tedi edi aneya ba laḡan matabuna Tamagu malamo matanemo sa moimoito. ");
INSERT INTO kqf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Banina Tana Taunana Natuna i yovona ba lava gwegwegwedi yai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Temi bainewa ko noḡonoḡoti? Bamoda oloto ḡemota ena sipu wapedi ba 100 a miyamiya, bi ḡemota i gwegwena ba tana bai ya voiye? Tana kaka sipu wapedi 99 oya nevanemo ya gosedi sa yabayaba, bi ya nawa sipu gwegwena ya tavuḡe. ");
INSERT INTO kqf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bi yà giugiu kauwemi, laḡannemo mba sipuna gwegwena i banavina ba yai nuwavisu gulatana mote mai sipu wapedi 99 mote a gwegwegwena. ");
INSERT INTO kqf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bi kota kauwina ḡemotina mainana Tamemi malamo mote ima ḡoyeḡoye te sivusivuyovoḡedi ḡemota ima gwegwe. ");
INSERT INTO kqf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bamoda valetim gebogebo lisimmo i voiyena, ba kwa nawa lisinemo bi taumiḡa mba pilipilina ko kadidimani. Bamo te em giu i vaiye bi i kuvasana ba kamaina te tana kunai yawasani munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bamoda kalinam mote i vaiye ba lava ḡemota ee labu kwai dolidi bi ko munaḡa lisinemo te lava labu ee faiona mba pilipilina ko kakadidimanina sa vaiye. ");
INSERT INTO kqf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bi mba lavana kalinedi mote ima vaiye, ba kamaina te ko nawena Maimaituwa ena dam lisidimo. Bi tana Maimaituwa ena dam edi laididimana mote ima anine, ba kamaina te tana ko voiyena maibena koikoitau taulauduneyena ee takis taulaitupana. ");
INSERT INTO kqf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yà giugiu kauwemi te temi dobumo bai ko panipanina ba Maimaituwa mainana malamo ya pani. Bi dobumo bai ko kuvekuvesina ba Maimaituwa mainana malamo ya kuvesi. ");
INSERT INTO kqf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Bi giukauwemo yà giugiuwemi, bamoda lava labu dobumo koi anina ḡemota bi bai koi baḡayena, ba Tamagu malamo emi waibaḡa ya voiye. ");
INSERT INTO kqf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bamo ḡome lava labu ee faiona isagumo sa waiḡemotana ba tagu ḡome vaitedi.” ");
INSERT INTO kqf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kamaina bi Pita Yesu lisinemo i tava bi i waitalayena gado, “Bada, bamoda egu tau gebogebo lisigumo i voiyena, ba malavisa ena gebogebo yà noḡoti kamaḡe? Mala 7, ee?” ");
INSERT INTO kqf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Bi Yesu giu i waimunena gado, “Geḡa, mote mala 7, bi 7 wapana 70, bi laḡan onena. ");
INSERT INTO kqf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Banina mala ena waibada ba niga mainana, maibena ḡalibona, ya ḡoyeḡoyena ya sibe kauwe te ena taupaula ena mane a labe kauwe ee geḡa. ");
INSERT INTO kqf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Laḡannemo tedi i waiḡemotidi, ba oloto ena ḡaga goldi baikidi 10 tausan luvana i vaivaina, a natome ḡalibona lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bi tana mote ḡemoḡemotina te maso goldi baikidi 10 tausan luvana i waimaii munaḡe. Taunana aubaina, ḡalibona i giu te olotona sa kune kamaḡe te yai taupaula yababa, mwanena, natunatuna bi ena ḡonaḡona matabudi kota sa kuneyedi te manena ḡalibona lisinemo ḡaga sai mai'i. ");
INSERT INTO kqf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mba ḡome te taupaula ḡalibona matanemo tuwapekana i waitupagwaliḡedi bi i waibaḡana gado, ‘Aee ḡalibona, kwa launuwatoiyegu bi em mane kaka yài mai'i munaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kamaina bi ḡalibona ena taupaula i launuwatoiye bi ena ḡaga matabuna i noḡoti kamaḡe, bi i giuwe te ya nawa. ");
INSERT INTO kqf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Laḡannemo olotona i potipotiyovo, ba falona taupaula wala ena mane ḡaubona 10 kina luvana i vaivaina i banavi, kamaina bi i kaididi te gadonemo i kabi bi i giuwena gado, ‘Ei, egu mane ku waimaii makaiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ḡome falona taupaula matanemo tuwapekana i waitupagwaliḡedi bi i waibaḡana gado, ‘Aee egu tau, kumai papalana, kwa labegu te em mane kaka yài mai'i munaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bi geḡa te ena tau kalinana mote i vaiye, bi biliwelokomo i sako nawe. Bi ḡome i miyamiyana eete maso ena tau ena ḡaga i waimaii kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Laḡannemo taupaula ḡesaudi mainana a kitakita ba ai nuwaboya kauwa bi a nawa ḡalibona lisinemo te bai matabuna i tubutubuḡana a tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kamaina bi ḡalibona mba taupaulina i giuwe te i valageta bi i giuwena gado, ‘Tam taupaula gebogebom! Tagu em ḡaga e noḡoti kamaḡe, banina tam lisigumo kunai baḡa gulata. ");
INSERT INTO kqf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bi tam maso mainana falom taupaula kuna launuwatoiye, mai tagu e laulaunuwatoiyemna.’ ");
INSERT INTO kqf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ḡalibona i medi kauwa bi i giukamaḡe biliwelokomo te ḡome sa kovoḡina eete ena ḡaga matabuna yai maii kovi.” ");
INSERT INTO kqf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ḡome te Yesu giu i waikenana gado, “Bamoda valetim ee nuvum ena gebo mote nopom tabutabunemo ku noḡoti kamaḡe ba Tamagu malamo kaka tam lisimmo kauwina ḡemotina mainana ya voiye.” ");
INSERT INTO kqf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bi sauginemo Yesu wailovelove i waiwaikovi ba Galili i gose bi i nawa Diudiya, Diyoudan gaubina noi nevanemo. ");
INSERT INTO kqf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bi lava kumdi tana a kaiwata bi ḡome i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ḡome Palisi ḡesaudi Yesu wailaulubuna aubaina a tava lisinemo bi ai talayena gado, “Waiḡake ya waianina ee geḡa te oloto bai i noḡonoḡotina luvanemo mwanena ya gose, ee?” ");
INSERT INTO kqf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bi Yesu giu i waimunena gado, “Temi gilugilumina wadubona kona iyevi ee geḡa? Te wala pakanemo Maimaituwa oloto bi waivini i voiyedi, ");
INSERT INTO kqf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","bi i giuna gado, ‘Taunana aubaina, oloto kaka tamana bi tinana ya gosedi te mwanena vaitena, sa miya te tedi tubuḡa ḡemota.’ ");
INSERT INTO kqf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Taunana aubaina, tedi mote lava labu bi tedi niganana lava ḡemota. Tedi Maimaituwa i waiḡemotidina ba mote aiyai kaka ima dailidi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bi palisi Yesu ai talayena gado, “Bai aubaina te Mousis oloto i giuwe te mwanena waigose pepana ya vite bi ya giukamaḡe ya nawa?” ");
INSERT INTO kqf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bi Yesu giu i waimunena gado, “Mousis i waianinemi te mwanemwanemi ko gosedina, banina temi nopomi ba a ḡaiḡai kauwa. Bi pakanemo Maimaituwa mote waigose i waianine. ");
INSERT INTO kqf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tagu yà giugiuwemi te oloto aiyai mwanena ena waimatawapa dabanemo i gosena mba olotona mote ima naḡi munaḡa, bamoda i naḡina ba mwanena ya vavawaidoḡa bi tana kota ya kaka milamila.” ");
INSERT INTO kqf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kamaina bi ena tauwaikaiwatana Yesu a giuwena gado, “Bamoda waigose mote kumai anine ba i visu te lava mote maso a naḡi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu giu i waimunena gado, “Niga wailovelovena mote lava matabudi sima vai bi tedi mabai Maimaituwa i vinevinedina taudiḡa lisidimo ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lava ḡesaudi mote sima naḡinaḡi, banina tedi mainana a tubuḡae, olooloto ḡesaudi ba poudi a lauvaidi taunana aubaina mote sima naḡi bi ḡesaudi ba mala ena waibada noponemo waitaupaula aubaina mote a ḡoye te sa naḡi. Bi lava aiyai niga wailovelovedi banidi ya sibesibedina ba tana maso i waianinedi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kamaina bi lava libilibi keikeilikidi a natomedi Yesu lisinemo te nimana dabedimo i sivudi bi aubaidi i laupali. Bi geḡa te ena tauwaikaiwatana lava a kaipasinedi. ");
INSERT INTO kqf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bi Yesu i giuna gado, “Libilibi keikeilikidi ko kita kamaḡedi te sa nato lisigumo, bi mote komai ḡakedi, banina mala ena waibada ba lava maibena niga libilibidi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kamaina bi Yesu nimana libilibi dabedimo i sako bi i kavisuvisudi te mba modomodona i gose bi i nawa. ");
INSERT INTO kqf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mba taunana te ewali waiguyauna i tava Yesu lisinemo bi i waitalayena gado, “Tauwailovelove, tagu visu bai yà voiye te yawasana kenakena nonoḡina yà vai?” ");
INSERT INTO kqf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bi Yesu giu i waimunena gado, “Banina bai bi visu aubaina kwa waitalayegu? Maimaituwa taunaḡa visuvisuna. Bamoda yawasana kwa ḡoyena ba kamaina te waiḡake kwa kaiwatedi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bi ewali i waitalana gado, “Waiḡake isedi?” Bi Yesu giu i waimunena gado, “Mote kumai peki, mote kuma vawaidoḡa, mote kuma danene, mote kaiyovumo em tau kumai wavu, ");
INSERT INTO kqf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamam bi tinam kwa viviledi bi em tau kwa ḡoyena maibena taumḡa kwa ḡoyeḡoyemna.” ");
INSERT INTO kqf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bi ewali waiguyauna i giuna gado, “Tagu mba waiḡakedi matabudi e kaiwatedi. Bi niganana bai ḡesauna yà voiye?” ");
INSERT INTO kqf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kamaina bi Yesu giu i waimunena gado, “Bamoda tam yawasana didimanina miyaena kuna ḡoyena, ba kwa nawa te em ḡonaḡona matabudi kwa kune kamaḡedi bi manena lava wainuwatoitoidi kwa vitedi bi mala ena waiguyau kwa vai. Ḡome kaka kwa nato te kwa kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sauginemo niga ewalina giudi i vaivaiyedi ba tana manuwaboyana i nawa, banina tana lava waiguyauna. ");
INSERT INTO kqf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ḡome te Yesu ena tauwaikaiwatana i giuwedina gado, “Giukauwemo yà giugiuwemi te lava waiguyauna ba i pilipili kauwa te mala ena waibadamo ya sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bi kota yà giugiuwemi te kamelo ba i pilipili te siyau bwadanemo ya sola. Bi lava waiguyauna ba i pilipili te i pilipili kauwa te Maimaituwa ena waibada noponemo ya sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bi laḡannemo Yesu ena tauwaikaiwatana niga giuna a vaivaiye ba a tagugu bi ai talayena gado, “Bamoda mainana ba aiyai kaka ya yawasana?” ");
INSERT INTO kqf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kamaina bi Yesu tedi i kitadididi bi i giuna gado, “Mba kauwidi lava lisidimo ba i pilipili kauwa, bi Maimaituwa lisinemo bai matabuna ba ḡemoḡemotina ya voiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bi Pita Yesu ena giu i waimunena gado, “Tama kaiwatam aubaina te mwali matabudi ke gosedi! Bi ema maii'a ba bai ka vai?” ");
INSERT INTO kqf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ḡome Yesu i giuwedina gado, “Giukauwemo yà giugiuwemi te Tana Taunana Natuna ena animiya namanamalinemo ya miyana kaka mwali matabudi laivaliudi mba laḡaninemo temi taukaiwatagu animiya 12 dabedimo ko miya bi Islael damna 12 koi badayedi. ");
INSERT INTO kqf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bi tedi mabai edi vanuwa, ee tametamedi, ee tinetinedi, ee valevaletidi, ee nuvunuvudi, ee natunatudi ee edi daibi bi a gosedina tagu kaiwatagu aubaina, ba mala 100 bi wailautawina sa banavina mote mai bai a gosegosedina. Bi kota yawasana kenakena nonoḡina sa vai. ");
INSERT INTO kqf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bi lava wapewapedi niganana sa dolidolina, kaka sa muli, bi mabai niganana sa mulimulina, kaka sa doli.” ");
INSERT INTO kqf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bi Yesu i giuna gado, “Mala ena waibada ba maibena waen daibina taniwagina, tana kageka i lauolala bi lava i aulitavaitedi te waen daibinemo sa noya. ");
INSERT INTO kqf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tana i waianina te laḡan ḡemota luvanemo yai maiidi bi i giu kamaḡedi te a nawa waen daibinemo. ");
INSERT INTO kqf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Bi olaolalemo suwala 9 koloki mainana, tana i munaḡa bi lava ḡesaudi aniwaikunekune gabunemo a moimoito yabayababana i kitedi. ");
INSERT INTO kqf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ḡome i giuwedina gado, ‘Temi kota ko nawa bi egu waen daibinemo bai noyana ko voivoiyena ba didimanemo yài maiimi.’ ");
INSERT INTO kqf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kamaina bi tedi a nawa. “Tana i munaḡa bi 12 koloki bi 3 koloki mainana kauwina ḡemotina i voiye. ");
INSERT INTO kqf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Bi suwala 5 koloki, tana i munaḡa bi lava ḡesaudi yaḡolo a moimoito yabayababana i banavidi. Ḡome i waitalayedina gado, ‘Temi suwala lofalofana niga ḡome bai kona miyamiya yabayababe?’ ");
INSERT INTO kqf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bi tedi a giuwena gado, ‘Tama mote aiyai i waiutaniyemai te maso aubaina ke noya.’ Bi tana i giuwedina gado, ‘Kamaina, temi kota ko nawa egu daibimo ko noya.’ ");
INSERT INTO kqf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Noya i kovi dudubala isuna, daibi taniwagina taunoya edi bada i yoge bi i giuwena gado, ‘Taunoya matabudi kwai ḡemotidi bi edi ma'ia kwa vitedi, kwai maiidina ba mabai muliḡa a tavatavana lisidimo kwai tubu te kwa nawa a geigei tavana lisidimo kwai kovi.’ ");
INSERT INTO kqf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Taunoya mabai aubiga isuna a tava bi a noyanoyana ba laḡan ḡemota maii'na a vai. ");
INSERT INTO kqf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bi tedi mabai a geigei tavana a wainoḡota te maiia dididiga sa vai bi geḡa te edi lava bainewa a vaivaina mainana a vai. ");
INSERT INTO kqf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Laḡannemo edi mane a legalegaudi ba daibi taniwagina lisinemo wawalu aitubuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Niga lavedi muliḡa a tavatavana ba awa ḡemota ota a noya bi tama ba suwala poyapoyanemo ke noya te suwala i bulu bi geḡa te kunai maiidina mainana tama kunai maiimai.” ");
INSERT INTO kqf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Bi daibi taniwagina oloto ena giu i waimunena gado, ‘Goma, kwai beyavaiye, tagu mote kaiyovumo yà soi. Temi kage konai anina te ko noyana ba laḡan ḡemota maiina ko vai. ");
INSERT INTO kqf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Em maii'a ku vai bi kwa nawa. Tagu yà ḡoyeḡoyena lava muliḡa e tanodi bi a noyanoyana kota mainana yài maiidi. ");
INSERT INTO kqf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tagu egu laukivivisuvisu ḡalanemo kona gadoḡai, ee? Niga ba tagu egu mane, taunana aubaina bai e noḡonoḡotina mainana yà voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Bi Yesu giu i waikenana gado, ‘Tedi mabai sa mulimulina kaka sa doli, bi tedi mabai sa dolidolina kaka sa muli.” ");
INSERT INTO kqf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ena tauwaikaiwatana 12 vaitedi a nawanawa Yelusalem bi etamo a vagebi bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Koi beyavaiya, tada ta nawanawana Yelusalemmo, ḡome kaka pilipilisi edi badabada bi waiḡake tauwailovelovena sai ogatala te Tana Taunana Natuna waipekina sai anine. ");
INSERT INTO kqf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bi tedi kaka sa vai bi eteni lavedi nimedimo sa sako, sai diboḡi, sa kwapu bi kolosimo sa tupalatu. Bi laḡan waifaioninemo Maimaituwa kaka ya kakenamoito.” ");
INSERT INTO kqf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ḡome Diyebedi mwanena natunatuna vaitedi a tava Yesu lisinemo bi tinedi tuwapekana i waitupagwaliḡedi bi ena ḡowana i waibaḡaye. ");
INSERT INTO kqf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Bi Yesu i giuna gado, “Tam bai kwa ḡoyeḡoye?” Ḡome waivini i giuna gado, “Natunatugu labu maso kunai aninedi te em waibada noponemo a miya, ḡemota kataiyammo bi ḡesauna ḡeniyammo.” ");
INSERT INTO kqf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bi Yesu i giuwedina gado, “Temi mote ko sibe te bai ko waibaḡaye. Temi luvemi te tagu wainuwatoi bi peki yà nawayena mainana ko nawaye?” Ḡome tedi a giuna gado, “Emaso, luvana ka nawaye.” ");
INSERT INTO kqf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bi Yesu i giuwedina gado, “Giukauwa te temi wainuwatoi bi peki ko nawaye, bi tagu mote egu waibada bai ima kenakena te yài aninemi te aiyai kataiyagumo bi aiyai ḡeniyagumo ya miya. Mba animiyedi ba Tamagu i kanonoḡidina, lava vinevinedi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Laḡannemo ena tauwaikaiwatana 10 mainana a vaivaiye ba valevaletidi labu a mediyedi. ");
INSERT INTO kqf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu mba mai kauwina i kitakita ba i waiḡemotidi bi i giuwedina gado, “Ko sibe te tedi mabai eteni sa waibadayedina ba ḡailisi lisidimo ya kenakena te lava matabudi sai badayedi. ");
INSERT INTO kqf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Niga kauwina mote temi mainana koma voiye. Bi bamoda aiyai modomimo didiga ya ḡoyena, ba kamaina te matabumi aubaimi yai taupaula. ");
INSERT INTO kqf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aiyai bi doli i ḡoyena ba kamaina te aubaimi yai taupaula yababa, ");
INSERT INTO kqf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","maibena Tana Taunana Natuna i yovona, mote lava tana aubaina sima noya, bi tana lava aubaidi ya noya bi ena yawasana ya vite munaḡe te edi gebogebo guduna ya vai.” ");
INSERT INTO kqf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sauginemo Yesu ena tauwaikaiwatana vaitedi Deliko a gosegose ba lava kumna tana a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ḡome ba olooloto labu matapotepotedi eta diyanemo a miyamiya. Bi ḡome a vaiye te Yesu mba etanaḡa i nawanawa ba tedi kalinedi dididiginemo a binauna gado, “Bada, Deivida Natuna, kwa launuwatoitoiyemai!” ");
INSERT INTO kqf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bi ḡome lava kumna a kaipasinedi bi a giuwedi te maso a miya moimoisili. Bi geḡa te tedi a binau gulagulatana gado, “Bada, Deivida Natuna, kwa launuwatoitoiyemai!” ");
INSERT INTO kqf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ḡome Yesu i vamoito te i giuwedi a nato bi i waitalayedina gado, “Bai ko ḡoyeḡoyena aubaimi yà voiye?” ");
INSERT INTO kqf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bi tedi ena giu ai munena gado, “Bada, tama matamai kwa kayanedi.” ");
INSERT INTO kqf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu i launuwatoiyedi bi matedi i tautaukonidi, ba ai kita bi a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tedi Yelusalem a vavawaiḡeleḡele, ba Betpage malagainemo a tava, oya Oliv dabanemo. Ḡome te Yesu ena tauwaikaiwatana labu i giukamaḡedi a doli, ");
INSERT INTO kqf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","bi i giuwedina gado, “Ko nawa te malagaimo ko tava bi ko kita te ḡome donki manatuna waitamidi. Ko kuvesidi bi ko yovoḡedi tagu lisigumo. ");
INSERT INTO kqf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bamoda aiyai yai talayemina ba ko giuwena gado, ‘Bada ya ḡoyeḡoyedi bi noi taunana te ya giukamaḡe saḡedi.’” ");
INSERT INTO kqf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Niga kauwina wala taugiuwatana i giugiuwena mainana i tubuḡa. Taugiuwatana niga mainana i giu: ");
INSERT INTO kqf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yelusalem lavedi ko giuwedina gado, ‘Ko kita emi ḡalibona vovoyaḡotina donki lauewalina i geluye bi lisimimo ya natonato.” ");
INSERT INTO kqf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kamaina bi ena tauwaikaiwatana a nawa te Yesu bai i giugiuwedina mainana a voiye. ");
INSERT INTO kqf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tedi donki manatuna a tavaitedi, Yesu lisinemo bi edi gala donki lauewalina dabanemo a yesidi te Yesu i miya saḡa. ");
INSERT INTO kqf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lava kumna edi kwama etamo a yesidi, ḡesaudi kai lagedi malugulugudi a bwali tavaitedi bi etamo a yesidi. ");
INSERT INTO kqf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lava kumdi a dolidolina Yesu matanemo bi ḡesaudi a mulimulina matabudi a binabinauna gado, “Ousana Deivida natuna! Kakavisuvisuna tana taunana Bada isanemo ya natonato! Ousana noke malamo!” ");
INSERT INTO kqf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Laḡannemo Yesu Yelusalemmo i solasola saḡa ba malagaina matabuna i waidagu bi lava a giuna gado, “Niga aiyai lavana?” ");
INSERT INTO kqf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bi lava kumdi a giuna gado, “Niga taunana Yesu, tana ba taugiuwatana, Nasalet lavana Galili plovins noponemo.” ");
INSERT INTO kqf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bi Yesu pali vanuwina ganakukuna noponemo i sola saḡa bi ḡome lava mabai a gimagimala bi a waikunekunena matabudi i kwavivaidi. Ḡome dobu ḡesaudi manedi bi mba dobuna manena taulabedi edi teibolo, bi mwanuwa gabubu a waikunekuneyedina lavedi edi animiya vaitedi i vitaledi. ");
INSERT INTO kqf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bi Yesu i giuwedina gado, “Gilugilumina wadubonemo Maimaituwa i giuna gado, ‘Tagu egu vanuwa ba sa waiisana pali vanuwina.’ Bi temi niganana kona voiyena mai taudanedanene edi anikandavona.” ");
INSERT INTO kqf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bi lava matapotepotedi bi kaḡedi nuwanokudi a tava pali vanuwinemo, Yesu lisinemo bi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bi ḡome pilisi edi babada bi waiḡake tauwailovelovena Yesu kauwa visuvisudi i voivoiyedina a kitedi. Bi kota libilibi pali vanuwina ganakukuna noponemo a kakasaḡesaḡena gado, “Ousana Deivida Natuna.” Taunana aubaina mba babadidi nuwedi i medi. ");
INSERT INTO kqf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bi Yesu a giuwena gado, “Tam libilibi bai sa giugiuwena kwa vaivaiye ee geḡa?” Bi Yesu tedi i giuwedina gado, “Mm, e vaiyedina. Temi gilugilumina wadubonemo kona iyevi ee geḡa?” Bi i giuna gado, “Bada, tam libilibi keikelikidi bi meyemeyedi kunai lovelovedi te isam sa kasaḡesaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ḡome tana i gosedi bi malagai dididigina i potiyovo kamaḡe bi i nawa Betenimo, te ḡome i kena. ");
INSERT INTO kqf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Olaolala kaikana Yesu i munamunaḡa Yelusalemmo, ba etamo kani i peki. ");
INSERT INTO kqf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ḡome i waikita te damaya kaina eta diyanemo moimoitona i kita. Kamaina bi i nawa damaya kaina diyanemo bi i kitakita ba mote i vota bi lugulugunaḡa. Taunana aubaina tana damaya kaina i pasili, “Tam mote kaka kuma vota munaḡa!” Noi taunana te damaya kaina i poki. ");
INSERT INTO kqf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Laḡannemo ena tauwaikaiwatana niga mainana a kitakita ba a sove bi a giuna gado, “Damaya kaina bainewa bi i poki makai?” ");
INSERT INTO kqf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bi Yesu edi giu i waimunena gado, “Giukauwemo yà giugiuwemi, te mote koma nuwalaḡalaḡa bi koi sumaḡa te bai e voivoiyena mainana temi ko voiye, bi mote damaya kaina taunaḡa bi kota niga oyana ko giuwena gado ‘Ku nuwalageta bi nisamo kwa pwalaḡe nawem.’ Bi mainana kaka ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bamoda konai sumaḡana ba temi bai palimo ko waibaḡayena kaka ko banavi.” ");
INSERT INTO kqf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu pali vanuwina ganakukuna noponemo i saḡa bi i waiwailovelove ba, pilisi edi babada bi babada ḡesaudi vaitedi tana lisinemo a tava, bi ai talayena gado, “Tam em waibada bai, bi aiyai waibada i vitem bi niga kauwidi kwa voivoiyedi?” ");
INSERT INTO kqf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bi Yesu i giuwedina gado, “Tagu kota egu waitala ḡemota temi yài talayemi, bi bamoda temi koi munena, kaka tagu yà giuwemi te aiyai niga waibadana i vitegu te niga kauwidi yà voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ko giuwegu! Diyon bamo ḡome waibada i vai bi i kakabulu, Maimaituwa lisinemo ee lava lisidimo?” Ḡome taudiḡa ai giugiuna gado, “Bainewa ta giuwe? Bamoda ta giuna gado, ‘Maimaituwa lisinaḡa.’ Ba tana kaka ya giuwedana gado, ‘Bai aubaina temi Diyoni mote koi sumaḡe?’ ");
INSERT INTO kqf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bamoda tada ta giuna gado, ‘Lava lisinaḡa.’ Ba lava sa ḡasiyeda, banina tedi matabudi a sibe te Diyoni ba taugiuwatana.” ");
INSERT INTO kqf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kamaina bi Yesu ena giu ai munena gado, “Tama mote ke sibe.” Ḡome te tedi i giuwedina gado, “Mote kaka yàma giuwemi te aiyai waibadana i vitegu bi niga kauwidi yà voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Niga lautaulalana ko noḡonoḡoti? Mai maso oloto ḡemota bi natunatuna labu. Tana i nawa natuna tautuwaḡa lisinemo bi i giuwena gado, ‘Koko, niganana kwa nawa te waen daibinemo kwa noya.’ ");
INSERT INTO kqf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bi natuna i giuna gado, ‘Tagu e daboka.’ Bi geḡa te, muliḡa nuwana i vitale bi i nawa waen daibinemo i noya. ");
INSERT INTO kqf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ḡome kota tamana i nawa natuna tautasina lisinemo bi giuna ḡemotina i giuwe. Bi ḡome te natuna tautasina i giuna gado, ‘Kamaina tamagu, tagu kaka yà nawa te noyana ya voiye.’ Bi geḡa te tana mote i nawa. ");
INSERT INTO kqf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Bamo taunana tamana i voteyeteye bi ena ḡowana i voiye?” Bi lava Yesu ena giu ai munena gado, “Gomana tautuweḡina.” Ḡome Yesu i giuwedina gado, “Tagu giukauwemo yà giugiuwemi te takis taulaitupana bi waivini kabakabaleyidi tedi kaikana a vawaimulimi bi Maimaituwa ena waibadamo sa saḡasaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Banina Diyon lisimimo i tava te didimana etana i wailovemi, bi temi mote tana koi sumaḡe. Bi takis taulaitupana bi waivini kabakabaleyidi tedi Diyon ai sumaḡe. Bi temi niga kauwina kona kita bi mote ko laukuvasa bi ena lauguguya mote koi sumaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Koi beyavaiya bi kota lautaulala ḡesauna yà giuwemi: Daibi taniwagina ḡemota waen daibina i voiye bi i ganakuku. Kamaina bi waen anivapisana domna i ḡala bi aniwaikoyaḡa vanuwina i keli. Ḡome tana daibina taubayau ḡesaudi nimedimo i sako te sa labe bi tana i modina te i nawa dobu ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Laḡannemo waen losina ena laḡani i tavatava ba tana ena taupaula i giukamaḡe nawedi waen daibina taulabena lisidimo, te tana ena soisoi maso a vai. ");
INSERT INTO kqf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Bi waen daibina taulabena taupaula a panidi bi ḡemota a kwapu yabayababe, ḡesauna ai peki bi waifaionina a lauḡakimi. ");
INSERT INTO kqf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kamaina bi waen daibina taniwagina ena taupaula wapawapa i giukamaḡedi. Bi waen daibina taulabena mba kauwina ḡemotina lisidimo a voiye. ");
INSERT INTO kqf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mba kauwina mulinemo, tana natuna i giukamaḡe lisidimo bi i giuna gado, ‘Niganana ba yà noḡonoḡoti te tedi kaka natugu sa vivile!’ ");
INSERT INTO kqf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Bi laḡannemo waen daibina taulabena tana a kitakita ba taudiḡa ai giugiuna gado, ‘Niga taunana waen daibina taniwagina natuna. Ko nato ta laipeki bi ena gagasa ta vai.’ ");
INSERT INTO kqf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kamaina bi a kaididi, a solu nawe waen daibina ganana taulinemo bi a laipeki. ");
INSERT INTO kqf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Bainewa ko noḡonoḡoti, laḡannemo waen daibina taniwagina ya tavana ba tauwailaba lisidimo bai ya voiye?” ");
INSERT INTO kqf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tedi Yesu a giuwena gado, “Tana kaka mba lavedi gebogebodi ya laipekidi, bi mulinemo ena daibi lava ḡesaudi nimedimo ya sako. Bi waen losina sauginemo tedi kaka tana ena soisoi sa vite.” ");
INSERT INTO kqf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bi Yesu i giuwedina gado, “Temi gilugilumina wadubonemo kona iyevi ee geḡa? Niga mainana i giu, ‘Vanuwa tauḡalana ḡakima a dabodabokena i waila vanuwa yasina. Bada niga kauwina i voiye te kitana i visu.’ ");
INSERT INTO kqf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Taunana aubaina yà giugiuwemi te Maimaituwa ena waibada lisimimo kaka ya kaikamaḡe bi lava ḡesaudi ya vitedi bi tedi kaka sa vota. ");
INSERT INTO kqf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lava aiyai bi ya kuluvana niga ḡakimina dabanemo ba yai doulisilisi. Bi ḡakimina aiyai dabanemo ya talaḡana ba yai doumisimisi.” ");
INSERT INTO kqf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sauginemo pilisi edi babada bi palisi Yesu ena lautaulala a vaivaiyedi ba a sibe te tana tedi i giugiu watedi. ");
INSERT INTO kqf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tedi eta a tavutavuḡe te maso a pani bi geḡa te lava kumna a nailedi, banina a sibe te tana ba taugiuwatana. ");
INSERT INTO kqf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu lautaulala ḡesaunemo kota lava i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mala ena waibada ba maibena ḡalibona natuna olotona ena naḡi soina i kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bi ena taupaula i giukamaḡedi te sa nawa lava giugiuvaidi sa giuwedi te sa nato soimo. Bi geḡa te nato a daboka. ");
INSERT INTO kqf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kamaina bi taupaula ḡesaudi kota i giukamaḡedi bi i giuna gado, ‘Ko nawa lavedi e giugiuvaidina lisidimo bi ko giuwedina gado, tagu egu kau pwatapwatana e nigonigo bi bai matabuna e kanonoḡi. Niganana ko nato naḡi soinemo.’ ");
INSERT INTO kqf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bi geḡa te taupaula kalinedi a vaiye kamaḡedi, bi ai nawa ḡemoḡemota. Ḡesauna i nawa ena daibimo, bi ḡesauna i nawa ena noyamo. ");
INSERT INTO kqf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bi ḡesaudi taupaula a panidi, a laukivigebogeboyedi bi ai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Taunana aubaina, ḡalibona nuwana i medi kauwa bi ena tauwaiḡaviya i giukamaḡedi te tauwaipeki ai pekidi bi edi taun ai kalaḡosa. ");
INSERT INTO kqf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ḡome ḡalibona ena taupaula i giuwedina gado, ‘Naḡi soina kaikana e kanonoḡi. Bi tedi mabai e giugiuvaidina mote a visu gulata te maso a tava. ");
INSERT INTO kqf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Taunana aubaina, ko nawa etaḡa bi mabai ko banabanavidina, ko giuvaidi te sa tava soimo.’ ");
INSERT INTO kqf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Kamaina bi taupaula etaḡa a nawa bi lava a banabanavidina, visuvisudi e gebogebodi matabudi a tavaitedi, te tauliso soi vanuwina ai wanavu. ");
INSERT INTO kqf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Bi ḡalibona i valageta vanuwemo ena tauliso kitedi aubaina. Bi i kita te oloto ḡemota mote naḡi galedi i kotedi. ");
INSERT INTO kqf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ḡome ḡalibona mba lavana i giuwena gado, ‘Goma, tam mote naḡi galedi ku kotedi, bainewa bi niga ḡome kuna valageta?’ Bi olotona mote bai i giuwe. ");
INSERT INTO kqf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kamaina bi ḡalibona taupaula i giuwedina gado, ‘Niga olotona nimana bi kaḡena ko panipanidi bi ko pwalaḡe nawe boimatuwemo. Bi ḡome kaka ya ḡaba bi mwakana ya sanawaikikokikodi.’ ");
INSERT INTO kqf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Banina Maimaituwa lava wapewapedi i giuvaidi, bi visa i vinedi.” ");
INSERT INTO kqf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ḡome Palisi a nawa bi ai ogatala, te Yesu ena giumo maso bai i vato waigebo bi ai wavu. ");
INSERT INTO kqf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tedi edi tauwaikaiwatana bi Alodi ena muli tauavalina matabudi a giukamaḡedi Yesu lisinemo bi a giuwena gado, “Tauwailovelove, tama ke sibe te tam giukauwemo Maimaituwa ena ḡowana kwa wailoveloveye. Tam mote lava kuma nainailedi, bi lava bainewa kitedi mote kuma iyeiyevidi. ");
INSERT INTO kqf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwa giuwemai, tam bainewa kwa noḡonoḡoti ḡiliuwe, tama Loum gabemanina Sisa lisinemo takis kai mai'i ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ḡome Yesu edi noḡota gebogebodi i sibedi taunana aubaina, i giuwedina gado, “Temi tauwaikaikaiyovu! Bai aubaina ko wailaulubugu? ");
INSERT INTO kqf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis aniwaimai'ina manena koi lovegu bi yà kita.” Kamaina bi mane a vai natome ai love, ");
INSERT INTO kqf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","bi Yesu i waitalayedina gado, “Aiyai aluwina bi isana mane modonemo ya kenakena?” ");
INSERT INTO kqf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tedi a giuna gado, “Sisa aluwina.” Ḡome te Yesu i giuwedina gado, “Kamaina te bai Sisa aubaina ba Sisa ko vite, bi bai Maimaituwa aubaina ba Maimaituwa ko vite!” ");
INSERT INTO kqf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sauginemo Yesu ena giu a vaivaiye, ba a sove bi a gose te a nawa. ");
INSERT INTO kqf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadisi sa waisumaḡa te lava i pekina ba mote ima kenamoito munaḡa, taudidi a nato Yesu lisinemo, ");
INSERT INTO kqf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","bi ai talayena gado, “Tauwailovelove, Mousis i giuwemai te bamoda oloto i naḡi bi mote i wainatuna bi i pekina, ba tasina ee tuwaḡana mba iwapena ya naḡi te libilibi yai tubudi valetina pekipekina aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mai maso tama lisimaimo olooloto wapedi 7, tautuwaḡa waivini i naḡi bi mote ai natuna, te olotona i peki bi tasina iwape i naḡi. ");
INSERT INTO kqf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bi kauwina ḡemotina oloto wailabuna bi waifaionina lisidimo i tubuḡa, mainana eete oloto wai 7 na lisinemo i tava. ");
INSERT INTO kqf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muliḡa te mba waivinina i peki. ");
INSERT INTO kqf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bi niganana niga oloolotodi 7 mba waivinina a naḡinaḡina, kenamoito munaḡemo ba aiyai mwanena?” ");
INSERT INTO kqf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu giu i waimunena gado, “Temi kona aigiugiu, banina temi gilugilumina wadubona mote ko iyevi ee Maimaituwa ena ḡailisi mote ko sibe. ");
INSERT INTO kqf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kenamoito laḡannemo, lava mote sima naḡi bi tedi kaka sa miyana mai aneya malamo. ");
INSERT INTO kqf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Temi lava pekipekidi edi kenamoito Maimaituwa i giugiuwemina mote ko iyevi. Tana niga mainana i giu, ");
INSERT INTO kqf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Tagu Eiblaḡam, Aisik bi Deikap edi Maimaituwa.’ Tana mote lava pekipekidi edi Maimaituwa bi lava yawayawasanidi edi Maimaituwa.” ");
INSERT INTO kqf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sauginemo lava kumdi Yesu ena giu a vaivaiye ba ena wailovelove a sove gulate. ");
INSERT INTO kqf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Laḡannemo Palisi a vaiye te Yesu, Sadisi i waitupedi, ba a tava ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bi waiḡake tauwailovelovena edi bada laukaina, Yesu i wailaulubuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tauwailovelove, waiḡake mododimo, bamo waiḡakena i saḡa gulata?” ");
INSERT INTO kqf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Bi Yesu giu i waimunena gado, “Bada em Maimaituwa kwa ḡoyena ba nuwam tabutabunemo, tubuḡim tabutabunemo bi em noḡota tabutabunemo. ");
INSERT INTO kqf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Niga taunana ba waiḡake dolidolina bi laukaina. ");
INSERT INTO kqf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bi wailabuna kota, em tau kwa ḡoyena mai bainewa taumḡa kwa ḡoyeḡoyemna mainana. ");
INSERT INTO kqf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mousis ena waiḡake matabudi bi Taugiuwatana edi wailovelove ba niga waiḡakedi labu nopodimo a wailovelove.” ");
INSERT INTO kqf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bi sauginemo Palisi ai ḡemotidi bi a miyamiya ba Yesu i waitalayedina gado, ");
INSERT INTO kqf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Temi ko noḡonoḡotina Keliso ba aiyai natuna?” Bi tedi giu ai munena gado, “Tana Deivida natuna.” ");
INSERT INTO kqf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bi Yesu i giuwedina gado, “Bainewa te Aluwa Waiyawa Deivida i waiwanavu bi i giugiuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bada egu Bada i giuwena gado, kataiyagumo kwa miyamiyana eete, em ḡaviya kaḡem dibunemo yài dubudi.’ ");
INSERT INTO kqf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Bamoda Deivida, Keliso i giugiuwena gado, ‘Egu Bada.’ Bi bainewa te Keliso maso Deivida natuna?” ");
INSERT INTO kqf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mba ḡome mote aiyai ḡemoḡemotina te Yesu ena giu i waimune. Mba laḡannemo te noi i nawana lava matabudi a naila bi mote ai tala munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kamaina bi Yesu ena tauwaikaiwatana bi lava kumdi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Waiḡake tauwailovelovena bi Palisi, tedi lava sa wailovelovedina maibena Mousis i wailovelovena. ");
INSERT INTO kqf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Taunana aubaina temi bai matabuna sa giugiuwemina, ba kamaina te ko voteyateyaedi. Bi edi kauwa gebogebodi mote koma kaiwatedi, tedi mba kauwidi sa laulauguguyaedina, mote sima kaikaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mousis ena waiḡake bi tedi waiḡake ḡesaudi a voiyedi, bi lava sa egelidi te waiḡakedi sa kaikaiwatedi. Bi lava mba waiḡakedi kaiwatedi sa kabikabi kasaḡedi, bi tedi nimedi a bewedi bi mote sima sagusagudi. ");
INSERT INTO kqf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tedi kauwa matabudi sa voivoiyedina ba bena lava sa kitedi bi sa soveyedi: Tedi Maimaituwa giuna pepamo sa gilumidi, soledimo sa pani waipatudi bi ḡesaudi sa waikalimaedi. Bi gala lofelofedi laupelopelodi sa kotedi bi lava matediḡa sa kaikaimoito nawa. ");
INSERT INTO kqf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Soi laḡandimo tedi sa ḡoyeḡoye te gabu poudimo sa miya, bi bolu vanuwidimo ba animiya laukaidi sa ḡoyeḡoyedi. ");
INSERT INTO kqf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tedi edi ḡoye ba aniwaiḡemota gabudimo lava lisidimo sa tava, sai ebonedi bi sa giuna gado, ‘O tauwailovelove.’ ");
INSERT INTO kqf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Bi temi maso mote ai isemina gado, tauwailovelove, banina temi emi tauwailovelove ḡemota ota Bada, bi matabumi ba valevaleta kavakava. ");
INSERT INTO kqf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bi dobumo mote aiyai komai isa gado, ‘Tamamai.’ Banina Tamemi ba ḡemota ota malamo. ");
INSERT INTO kqf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kota temi mote aiyai imai isemi gado, ‘Tauwailovelove.’ Banina emi tauwailovelove ba ḡemota ota Keliso. ");
INSERT INTO kqf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bi aiyai saḡasaḡa guletina modomimo ba tana taunana emi taupaula. ");
INSERT INTO kqf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Taunana aubaina tedi mabai taudiḡa sa sivusivu saḡedina ba Maimaituwa kaka ya sivu yovoḡedi. Bi tedi mabai taudiḡa sa sivusivu yovoḡedina ba Maimaituwa kaka ya sivu saḡedi.” ");
INSERT INTO kqf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","I gebo kauwa, temi waiḡake tauwailovelovena bi Palisi lisimimo, temi kaikaiyovumi! Lava sa wailaulubu te mala ena waibadamo sa sola saḡa bi temi ko moimoito gududi bi edi mataeta ko gudugudu ḡavutedi te mote sima solasola saḡa. Taunana aubaina, temi mote kaka Mala ena waibada noponemo koma sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Bi i gebo kauwa, temi waiḡake tauwailovelovena bi Palisi lisimimo, temi kaikaiyovumi! Temi ko nawa dobu te dobu, nisa te nisa bi emi wailovelove kaikaiyovudimo, lava nuwedi ko vitaledi bi sa kaikaiwatemi. Sauginemo, bi lava i kaiwatemina ba tana iyoyoḡa aubaina ya vokaukauwa te kovoḡa dabanemo bi dabanemo ya vai mote mai temi ko vaina. ");
INSERT INTO kqf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“I gebo kauwa, temi taulauetadoli matapotepotemi. Temi ko giugiuna gado, ‘Bamoda aiyai bi Pali vanuwina isanemo i waisaḡina bi i waidoukotona ba mote gebo i voiye. Bi aiyai Pali vanuwina noponemo goldi isanemo i waisaḡina bi i waidoukotona ba gebo i voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Temi bu'ubu'uwimi bi matapotepotemi! Bamo taunana i tausaḡa, Pali vanuwina e goldi? Pali vanuwina taunana goldi ya voiye te ya waila waiyawa. ");
INSERT INTO kqf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bi kota ko giugiuna gado, ‘Bamoda aiyai olta isanemo i waisaḡina bi i waidoukotona ba mote gebo i voiye. Bi bamoda sewasewa olta dabanemo sakosakona isanemo i waisaḡina bi i waidoukotona ba gebo i voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Temi matapotepotemi! Bamo taunana i saḡa gulata, sewasewa e olta? Olta taunana sewasewa ya voiye te ya waila waiyawa. ");
INSERT INTO kqf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taunana aubaina aiyai bi olta isanemo i waisaḡinawapana, mba olta bi mwali matabudi olta dabanemo sa kenakenana isedimo i waisaḡina. ");
INSERT INTO kqf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aiyai bi Pali vanuwina isanemo i waisaḡinawapana, ba vanuwina noponemo Maimaituwa ya miyamiyana isanemo i waisaḡina. ");
INSERT INTO kqf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aiyai bi mala isanemo i waisaḡinawapana, ba Maimaituwa bi ena animiya isedimo i waisaḡina. ");
INSERT INTO kqf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“I gebo kauwa, temi waiḡake tauwailovelovena bi Palisi lisimimo. Temi kaikaiyovumi, banina temi kani anikadinidinidi ko laidubudi te dubu wapedi 10 bi dubu ḡemota ba Maimaituwa ko vitevite. Mba kamaina bi niga kauwidi ko gei voiyedi: Didimana, launuwatoi bi moitodidina. ");
INSERT INTO kqf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Temi tauwaietadoli matapotepotemi! Temi emi waiḡake kona voivoiyedina ko kitakita kauwedi bi ko wailoveloveyedi, bi Maimaituwa ena waiḡake laukaidi ko sivusivuliyedi bi mote komai wailoveloveyedi. ");
INSERT INTO kqf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“I gebo kauwa, waiḡake tauwailovelovena bi Palisi lisimimo, temi kaikaiyovumi! Temi ledu bi aboma taulidiḡa ko koḡekoḡedi, bi nopomi ba kanitoku bi taumiḡa ko noḡonoḡoti munaḡemi. ");
INSERT INTO kqf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Temi Palisi matapotepotemi. Temi ledu bi aboma nopodi ko gei koḡedi, kaka taulidi sa visuvisu. ");
INSERT INTO kqf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“I gebo kauwa, temi waiḡake tauwailovelovena bi Palisi lisimimo, temi kaikaiyovumi! Temi ba maibena tauyewa dabedi lailaisabusabudi, bi nopodi ba milemiledi bi siliḡe a wanavu. ");
INSERT INTO kqf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Temi lava sa kitekitemina ba didimana lavemi, bi geḡa te nopomi ba kaiyovu bi gebogebo i wanavu. ");
INSERT INTO kqf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Bi i gebo kauwa, temi waiḡake tauwailovelovena bi Palisi lisimimo. Temi kaikaiyovumi. Banina emi magumagula, taugiuwatana bi didimana lavedi a waipekidina, tauyewidi ko doudoudi bi ko waiwaisiyedi, ");
INSERT INTO kqf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","bi ko giugiuna gado, ‘Bamoda wala nove eda magumagula edi laḡannimo, vaitedi te miyamiya, maso mote te sagudi bi taugiuwatana tei pekidi.’ ");
INSERT INTO kqf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Mba mainana ko giugiuna ba ko kakamaḡati munaḡemi te temi giukauwa te taugiuwatana tauwaipekidi edi tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kamaina te emi magumagula gebo a voivoiyena koi kovi. ");
INSERT INTO kqf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Temi, mwata salama natunatuna! Temi kaka ko nawana iyoyoḡamo, mote ḡemoḡemotina kaka koma naile kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Taunana aubaina taugiuwatana, nuwauyauya lavedi bi waiḡake tauwailovelovena yà giugiukamaḡedi lisimimo. Bi temi kaka ḡesaudi koi pekidi, ḡesaudi ko tupalatudi, ḡesaudi kaka bolu vanuwidi nopodimo ko kwapudi, bi ḡesaudi ko kwavi waibabalidi malagai te malagai nopodiḡa. ");
INSERT INTO kqf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Taunana aubaina dididmana lavedi kovoḡidi temi kaka ko vai. Wala Eibolo ena saugemo, te i saḡa Belekaiya natuna Sakalaiya ena saugemo i tava. Sakalaiya ba pali vanuwina bi olta mododimo kona laipeki. ");
INSERT INTO kqf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Giukauwemo yà giugiuwemi, te tauwaipeki matabudi edi kovoḡa kaka niga kimtimi ko vai.” ");
INSERT INTO kqf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Oo Yelusalem dobuna lavemi! Temi taugiuwatana konai pekidi bi Maimaituwa ena tauwainoyanoya, i giugiukamaḡedina lisimimo kona lauḡakimidi! Bi laḡan matabuna, tagu e ḡoyeḡoye te maso emi lava ei ḡemotidi, maibena kamkam waivinina mabenemo natunatuna ya ḡomoḡomo tawidina, bi temi mote koi aninegu. ");
INSERT INTO kqf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Taunana aubaina, Maimaituwa kaka pali vanuwina ya gose bi ya laukavakava. ");
INSERT INTO kqf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bi yà giugiuwemi te temi mote koma kita munaḡegu eete, ko giuna gado, ‘Tana kakavisuvisuna, Bada isanemo ya natonato.” ");
INSERT INTO kqf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu Maimaituwa ena vanuwa i gose kamaḡe bi i nawanawa ba ena tauwaikaiwatana a tava lisinemo. Bi a giuwe te Maimaituwa ena vanuwa ya kita waitete. ");
INSERT INTO kqf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bi ḡome Yesu i giuwedina gado, “Niga kauwidi niganana matabudi kona kitedi? Yà giugiu kauwemi, te ḡakima ḡemota mote kaka ena gabumo ima kena nonoḡa, geḡa, bi matabudi kaka sa laubulili.” ");
INSERT INTO kqf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mba mulinemo Yesu oya Olip dabanemo i miyamiya, ena tauwaikaiwatana taudiḡa Yesu lisinemo a tava bi ai talayena gado, “Kwa giuwemai te niga kauwidi bai laḡannemo sa tubuḡa? Bi mataila bai sa tubuḡa te ka kitedi bi ka sibe te kaikana laḡan damona, kota bainewa ka sibe ḡiliuwe te tam em nato laḡannina ya tavatava?” ");
INSERT INTO kqf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bi Yesu edi giu i waimunena gado, “Koi kita kauwa te mote aiyai ima aiwaietadoliyemi. ");
INSERT INTO kqf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Banina lava wapewapedi kaka isagumo sa tava bi sa giuna gado, ‘Tagu taunana Keliso!’ Bi tedi kaka lava wapewapedi sa aiwaietadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bi laḡannemo waiḡasiḡasi dagugudi laulisimo ee manekemo giudi ko vaiyedina ba koma naila! Niga kauwidi ba sa tubuḡa, bi mba mote laḡan damona. ");
INSERT INTO kqf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dobu bi dobu kaka sai ḡasiḡasi, bi ḡalibona falona ḡalibona vaitena kaka sai ḡasiḡasi. Bi dobu wapewapedi nopodimo gomala bi yoyo sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Niga kauwidi matabudi yavidi ba maibena waivini wainatuna ya sulusuluvaina yavina. ");
INSERT INTO kqf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mba laḡannemo temi kaka sa panimi bi babada nimedimo sa sivumi, bi tedi sa laukivigebogeboyemi bi sai pekimi. Lava matabudi dobumo kaka sa dabokemi banina temi tagu ko waisumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mba sauginemo lava wapewapedi kaka waisumaḡa sa kaisako bi tedi kaka edi lava sa dabokedi bi sa kaisoluḡedi, ");
INSERT INTO kqf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","bi taugiuwatana kaikaiyovudi wapewapedi mba laḡannemo kaka sa laumaḡata bi lava wapewapedi sa ai waietadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bi lava wapewapedi edi nuwavaina Maimaituwa lisinemo kaka sa uba banina, Maimaituwa giuna mote sima kaikaiwata. ");
INSERT INTO kqf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bi tana aiyai ya moitodidina bi ya waisumaḡana kaka damonemo ya yawasana. ");
INSERT INTO kqf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bi Maimaituwa ena waibada giuna visuvisuna dobumo lava matabudi lisidimo sa lauguguyae te sa vaiye, muliḡa kaka laḡan damona ya tava. ");
INSERT INTO kqf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“(Temi tauiyava niga giuna banina ko sibe kauwe.) Laḡannemo kauwa waimatawalawalana ko kita bi gabu waiwaiyawinemo ya tubutubuḡa, ba ko noḡoti te Taugiuwatana Daniyela bai i giugiuwena taunana ya tubutubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bi tedi mabai Diudiyamo miyemiyedi ba oya aubaina sa velau. ");
INSERT INTO kqf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bi aiyai vanuwa dabanemo ba mote ima yovo ena ḡonaḡona vanuwa noponemo ima legaudi. ");
INSERT INTO kqf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bi aiyai daibimo mote ima munaḡa vanuwemo ena gala vaina aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mba laḡandimo ba i pilipili gulata, waivini bwagebwagedi bi vaivaisudi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Temi Maimaituwa lisinemo ko laupali te niga kauwidi mote bodubodumo ee Waiyawasi Laḡandimo sima tubuḡa, bamoda sa tubuḡana ba bainewa ko naila ko nawa? ");
INSERT INTO kqf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Banina mba laḡandimo kauwa pilipilidi kaka sa tubuḡa. Mote wala mainana dobu pakanemo eete niganana, bi mote mai kitana kaka ima tubuḡa munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bi bamoda Maimaituwa mba pilipili laḡandi i kita kamaḡedi maso mote aiyai ḡemota i yawasana. Bi ena lava i vinevinedina kedi nawamo, taunana aubaina mba laḡannidi i taiwatiḡedi. ");
INSERT INTO kqf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bi mba laḡandimo bamoda aiyai ya giuwemina gado, ‘Ko kita, Keliso naniga, ee tana nanoko!’ Mba komai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Banina Keliso kaikaiyovudi bi taugiuwatana kaikaiyovudi kaka sa laumaḡata bi mataila bi anisove kauwidi sa voiyedi, te Maimaituwa ena vinevine lavedi sa aiwaietadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Taunana aubaina ko kita kauwa, mwali matabuna kaikana e giu wainonomi. ");
INSERT INTO kqf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Taunana aubaina bamoda aiyai ya giuwemina gado, ‘Keliso noko kalakalalelemo.’ Mote kuma laufi bi kuma nawa. Ee bamoda ya giuwemina gado, ‘Tana naniga vanuwemo.’ Mote komai sumaḡe! ");
INSERT INTO kqf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Banina Tana Taunana Natuna ena laḡan ya natona mai namanamali ya kem te galewa matabuna ya laiyana. ");
INSERT INTO kqf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bamo musala pekina ya kenakena, ba ḡome taudou sa waiḡemotidi.” ");
INSERT INTO kqf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mba pilipilidi mulidimo ba suwala yai boimatuwa, bi nawalai mote ima yana. Bi kipola galewemo sa kuluva bi ḡaiḡailisidi sawasawamo matabudi sa gusu bi edi eta sa paledi. ");
INSERT INTO kqf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mba sauginemo galewemo kaka mataila ya laumaḡata te Tana Taunana Natuna ya natonato, bi dobumo lava matabudi kaka sa ḡaba te sa ḡaba gulata. Bi Tana Taunana Natuna, ḡailisi vaitena manamalina, galewaḡa magiyouna ya yovoyovona kaka sa kita. ");
INSERT INTO kqf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tana ena aneya ya giukamaḡedi te bwagigi sa suvesuve gulate ba sa nawa dobu liuna 4 nopodimo bi ena lava vinevinedi sa laitupa nawedi dobu isuna te isuna.” ");
INSERT INTO kqf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Temi kai damaya waigayona ko sibe kauwe. Laḡannemo damaya lagalagana sa nimagala, sa kini bi sa gidagidava, ba ko sibe otiḡe te bodubodu laḡannina. ");
INSERT INTO kqf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mba kauwina ḡemotina mainana, laḡannemo kauwa gebogebodi sa tubutubuḡa ba ko sibe otiḡedi te Bada ena nato laḡannina kaikana ya tavatava. ");
INSERT INTO kqf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tagu giukauwemo, yà giugiuwemi te niga kimtina mote kaka sima peki kovi, eete niga kauwidi matabudi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mala bi dobu kaka sa launeḡaneḡa, bi tagu giugu, mote kaka ima launeḡaneḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tana Taunana Natuna ena nato munaḡa laḡanna ee saugina mote aiyai i sibe, mote aneya malamo ee Natuna bi Tamana taunaḡa i sibe. ");
INSERT INTO kqf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Tana Taunana Natuna kaka ya natona, maibena Nowa ena laḡannimo kauwa i tubutubuḡana mainana. ");
INSERT INTO kqf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mba laḡandimo, muliḡa kaka kabaita, ba lava a kanikani, a tegotego, a naḡinaḡi ba laḡan i tava te Nowa gulamo i valageta. ");
INSERT INTO kqf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bi lava mote a sibe te bai lisidimo ya tubuḡa, tedi a miyamiya yabayababa bi kabaita i yovo te matabudi i nawedi. Tana Taunana Natuna ya nato munaḡana ba niga kauwina ḡemotina mainana kota ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mba laḡannemo olooloto labu sa bayabayau bi Maimaituwa kaka ḡemota ya kailageti nawe bi ḡesauna ya miya gwasa. ");
INSERT INTO kqf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bi waiwaivini labu kani sa laulauḡisi, bi Maimaituwa kaka ḡemota ya kailageti nawe, bi ḡesauna ya miya gwasa. ");
INSERT INTO kqf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Taunana aubaina laḡan matabuna koi kita kauwa, banina emi Bada ena tava laḡanna mote ko sibe. ");
INSERT INTO kqf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bamoda vanuwa taniwagina taudanedanene ena tava laḡanna i sibe kauwena, ba didiyau ya yave te taudanedanene mote ena vanuwa ima lolo. ");
INSERT INTO kqf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Taunana aubaina temi vaitemi ko vononoḡa bi koma miyamiya yabayababa, banina Tana Taunana Natuna ena nato munaḡa sauginemo ba yai tagugumi.” ");
INSERT INTO kqf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Taupaula aiyai nuwanuwauyauyana ya moimoitodidina tana taunana Bada i vine te ena lava ya labelabedi bi laḡan kauwemo ya waikanidi. ");
INSERT INTO kqf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Laḡannemo ena Bada ya tava munaḡa bi ya kita te ena taupaulana noya visuvisuna i voiyena ba kamaina te mai'ia ya vai. ");
INSERT INTO kqf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Giukauwemo yà giugiuwemi te Bada ena ḡonaḡona matabudi kaka mba taupaulina ya vite te yai badayedi. ");
INSERT INTO kqf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bi bamo te taupaula nopona gebogebona ba ya giuna gado, ‘Egu bada walaka i nawa bi ya alamiya.’ ");
INSERT INTO kqf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ḡome ena lava i kwapudi bi tana i nawa tautego bu'uwa vaitedi a kanikani bi a tegotego. ");
INSERT INTO kqf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mba kauwidi i voivoiye nawedi bi ena bada i tavana mote i sibe. ");
INSERT INTO kqf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mba laḡannemo Bada kaka mba taupaulina gebogebona ya douḡavuḡavuki bi lava kaikaiyovudi edi gabumo ya pwalaḡe nawe. Bi ḡome kaka ya lauaiyoi bi mwakana ya sanawaikikokikodi.” ");
INSERT INTO kqf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mba sauginemo mala ena waibada kaka mai totopa 10, edi lampa a legaudi bi a potiyovo a nawa te lawelawe sa banavi. ");
INSERT INTO kqf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Matabudi 5 ba opeopedi bi 5 ba nuwanuwauyeuyedi. ");
INSERT INTO kqf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ḡome totopa opeopedi edi lampa a legaudi bi kalesin dubidi mote a legaudi. ");
INSERT INTO kqf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bi totopa nuwanuwauyeuyedi ba edi kalesin dubidi lampa aubaidi a legaudi. ");
INSERT INTO kqf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bi lawelawe mote i tava makai, taunana aubaina tedi matedi a yaune te a kena kwavu. ");
INSERT INTO kqf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kamaina bi dudubala modonemo, lava a binauna gado, ‘Lawelawe kaikana i tava! Ko potiyovo bi ko velaubeye.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ḡome totopa matabudi a kena moito bi edi lampa a kanonoḡidi. ");
INSERT INTO kqf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kamaina bi waivini opeopedi edi lava nuwanuwauyeuyedi a giuwedina gado, ‘Aee, kalesin maso kona vitemai, ema lampa sa pekipeki.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bi waivini nuwanuwauyeuyedi edi lava opeopedi edi giu ai munena gado, ‘Geḡa, tama mote luvana te kalesin ka vitemi. Temi ko nawa te bamo kalesin sa gimegimelina ḡome ko gimeli.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kamaina bi tedi kalesin gimelina aubaina a nawanawa ba mulidimo, lawelawe i tava. Bi totopa mabai kaikana a vovononoḡana, tedi lawelawe vaitena a nawa naḡi soina vanuwina noponemo a valageta, bi mataeta i waidougudu. ");
INSERT INTO kqf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bi totopa opeopedi muliḡa a tavatavana a giuna gado, ‘Aee Bada, aee Bada, maso mataeta kuna kaikamaḡe aubaimai!’ ");
INSERT INTO kqf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ḡome lawelawe totopa opeopedi edi giu i waimunena gado, ‘Yà giugiu kauwemi te tagu mote yà sibemi.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Taunana aubaina, ko vokaukauwa, banina temi laḡan ee awa ya natonatona mote ko sibe.” ");
INSERT INTO kqf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kota Mala ena waibada ba niga mainana: Laḡan ḡemota muliḡa kaka lava ya nawana, bi ena taupaula i giuwedi te tana ena mane sa labe. ");
INSERT INTO kqf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kamaina bi ḡemoḡemotaḡa edi vaivai luvanemo mane i vitedi, ḡemota 5 tausan kina i vite, ḡesau 2 tausan kina i vite, bi kota ḡesau 1 tausan kina i vite. Ḡome te i nawa dobu ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bi taupaula 5 tausan kina i vaivaina, tana i nawa te manena i noyae te 5 tausan kina ḡesauna i voiye. ");
INSERT INTO kqf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kauwina ḡemoḡemotina kota mainana taupaula 2 tausan kina i vaivaina, tana i nawa te manena i noyae te 2 tausan kina ḡesauna i voiye. ");
INSERT INTO kqf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bi taupaula 1 tausan i vaivaina, ba i nawa te doḡa i keli bi noponemo ena bada ena mane i sako waidavo. ");
INSERT INTO kqf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mba taupaulidi edi bada i miya gulata kaka i tava munaḡa, bi i waiḡemotidi te i ḡoyeḡoyena maso mane lisidimo i sibe. ");
INSERT INTO kqf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Taupaula 5 tausan kina i vaivaina i tava te ena bada i giuwena gado, ‘Kwa kita, tam 5 tausan kina kuna vitegu bi e noyae te 5 tausan kina ḡesauna e voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ḡome ena Bada giu i waimunena gado, ‘I visu kauwa, tam taupaula visuvisum bi waipatutum! Tagu mwali ḡaubona e vitem bi tam kuna noyae te i didiga. Taunana aubaina tagu kaka yà voiyem te mwali wapewapedi kwai badayedi. Kwa nato bi tagu em Bada vaitegu tai nuwavisu.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Bi taupaula 2 tausan kina i vaivaina i tava bi i giuna gado, ‘Bada, tam 2 tausan kina kuna vitegu, bi e noyae te 2 tausan kina ḡesau e voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ḡome ena Bada giu i waimunena gado, ‘I visu kauwa, tam taupaula visuvisum bi waipatutum! Tagu mwali ḡaubona e vitem bi tam kuna noyae te i didiga. Taunana aubaina tagu kaka yà voiyem te mwali wapewapedi kwai badayedi. Kwa nato bi tagu em Bada vaitegu tai nuwavisu.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Bi taupaula 1 tausan kina i vaivaina i tava bi i giuna gado, ‘Bada, tagu e sibem te tam lava medimedim. Tam mote kuma bayabayau bi nonoḡina kwa laulauyaba bi kota mote kuma wadiwadi bi nonoḡina kwa laulaulaka. ");
INSERT INTO kqf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Taunana aubaina tagu e naila te e nawa em mane dommo e sakowaidavo. Kwa kita niga em mane kuna viteviteguna yà vitevite munaḡem.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ḡome ena Bada giu i waimunena gado, ‘Tam taupaula gebogebom bi matamatagayawim. Kuna sibe te tagu mote yàma bayabayau bi nonoḡina yà yabayaba bi tagu kota mote yàma wadiwadi bi nonoḡina yà laulaulaka. ");
INSERT INTO kqf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mba kamaina, bi tam egu mane maso banikemo kuna sako bi i noya. Te tagu e munaḡa tavana, maso dabanemo anitaipwatana vaitena e vai.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Taunana aubaina, niganana niga taupaulina gebogebona lisinemo mane ko vai kamaḡe te taupaula 10 tausan kina tauvoiyena ko vite. ");
INSERT INTO kqf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Taunana aubaina, aiyai lavana bai mwalina a vite bi i voivoiye kauwena kaka dabanemo yai autawi. Bi aiyai lavana mwali bai a vite bi mote i voivoiye kauwe ba avena te lisinemo ḡaubona ya kenakenana bi tagu kaka yà kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mba taupaulina ba matamatagayawina, ko pwalaḡe nawe boimatuwemo bi ḡome ya lauaiyoi bi mwakana ya sanawaikikokikodi.” ");
INSERT INTO kqf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Laḡannemo Tana Taunana Natuna manamalina ya yovona, ena aneya mat0abudi vaitedi, ba ena animiya namanamalinemo ya miya. ");
INSERT INTO kqf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bi lava matabudi dobumo kaka matanemo yai ḡemotidi bi ya dailidina, maibena tauḡamo sipu bi gouti ya daidailidina. ");
INSERT INTO kqf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tana kaka kataiyanemo sipu ya sivudi, bi ḡeniyanemo gouti ya sivudi. ");
INSERT INTO kqf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Bi ḡome kaka ḡalibona lava mabai kataiyanemo taumiya ya giuwedina gado, ‘Ko nato temi mabai Tamagu i kakavisuvisumina, bi emi gagasa ko vai. Banina muliḡa kaka Maimaituwa dobu i voiyena bi temi ena waibada i kakanonoḡina noponemo ko miya. ");
INSERT INTO kqf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Banina tagu kani e peki bi temi konai kanigu, bi gadogu i magu bi gauba kona vitegu te e tego. Bi walidobu lavagu e nawanawa bi temi kona giuvaigu emi vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bi tagu gala e malumaluwabiye bi temi konai galagu, tagu e sida bi temi kona labe kauwegu. Tagu biliwelokomo e miyamiya bi temi kona vakitagu.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ḡome didimana lavedi Bada ena giu sai munena gado, ‘Bada, bamo ḡome kani kuna peki bi kei kani bagibagim. Ee gadom i magubi gauba ke vitem kuna tego? ");
INSERT INTO kqf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bamo ḡome walidobu lavam kuna nawanawa, bi ke giuvaim ema vanuwem0o, ee gala kuna malumaluwabiye, bi kei galam? ");
INSERT INTO kqf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bamo ḡome ke kitam kuna sida ee biliwelokomo kuna miyamiya bi ke vakitam?’ ");
INSERT INTO kqf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Bi Ḡalibona kaka edi giu yai munena gado, ‘Giukauwemo yà giugiuwemi, te bai kauwina kona voivoiyena valevaletigu ee nuvunuvugu yovoyovodi lisidimo ba tagu lisigumo kona voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bi kota ḡeniyana yawaninemo sa miyamiyana kaka ya giuwedina gado, ‘Temi mabai Maimaituwa i pasipasilimina, ko nawa tabumimo, ko nawa kai kalakalati nonoḡinemo, Seitan bi ena aneya aubaidi Maimaituwa i kaka nonoḡinemo. ");
INSERT INTO kqf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Banina tagu kani e peki, bi mote kani ko vitegu e kani, gadogu i magu, bi mote gauba ko vitegu e tego. ");
INSERT INTO kqf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tagu walidobu lavagu e nawanawa, bi mote ko giuvaigu, tagu gala e malumaluwabiye bi mote koi galagu, tagu e sida bi mote koi nenetegu bi kota biliwelokomo e miyamiya bi mote ko vakitakitagu.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tedi kota Bada ena giu sai munena gado, ‘Bada, bamo ḡome ke kitam kani kuna peki ee gadom i magu ee kuna nawanawa ee gala kuna malumaluwabiye ee kuna sida ee biliwelokomo bi mote ke sagum?’ ");
INSERT INTO kqf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Bi tana kaka edi giu yai munena gado, ‘Giukauwemo yà giugiuwemi te bai kauwina valevaletigu ee nuvunuvugu yovoyovodi lisidimo mote ko voiye ba tagu kota lisigumo mote ko voiye.’ ");
INSERT INTO kqf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ḡome kaka tedi kovoḡa kenakena nonoḡinemo sa nawa bi didimana lavedi ba yawasana kenakena nonoḡinemo sa miya.” ");
INSERT INTO kqf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Laḡannemo Yesu niga kauwidi matabudi i giuwedi mulinemo ba ena tauwaikaiwatana i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Temi kona sibe te laḡan labu matademo te Vawaitauli soina, bi Tana Taunana Natuna kaka lava nimedimo sa sako te sa tupalatu.” ");
INSERT INTO kqf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ḡome pilisi edi babada bi babada ḡesaudi vaitedi, pilisi saḡasaḡa guletina isana Kaiyapas ena vanuwemo ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bi tedi ai ogatala te Yesu kandavonemo sa pani bi sai peki. ");
INSERT INTO kqf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bi tedi a giuna gado, “Niga kauwina mote soi noponemo tama voiye bamoda ta voiyena ba lava waiḡasiḡasi sa kelisali.” ");
INSERT INTO kqf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mba sauginemo ba Yesu Betenimo, oloto isana Saimon sida kapa vaivaina ena vanuwemo i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ḡome Yesu teibolo diyanemo i miya giligili bi i kanikani ba waivini masi panepanena dubina maiina dididiga, i avali tavaite te Yesu dabanemo i ḡini. ");
INSERT INTO kqf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bi laḡannemo ena tauwaikaiwatana niga kauwina a kitakita ba nuwedi i medi bi a giuna gado, “Bai aubaina masi panepanena ya waiyakali? ");
INSERT INTO kqf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Niga masina panepanena maso i kuneye te mane dididiga i vai bi lava waiyamoyamonidi i vitedi.” ");
INSERT INTO kqf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ḡome Yesu edi noḡota i sibe taunana aubaina i giuwedina gado, “Bai aubaina niga waivinina ko kaka nuwalaḡalaḡa? Tana kauwa visuvisuna lisigumo i voiye. ");
INSERT INTO kqf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Temi laḡan matabuna lava waiyamoyamonidi vaitedi ko miyamiya. Bi tagu mote vaitemi laḡan matabuna tama miya nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tana masi panepanena tunigumo i ḡinina ba dobogu aubaina i kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tagu giukauwemo yà giugiuwemi te bamo ḡome giu visuvisuna sa laulauguguyae dobu matabuna noponemo ba niga waivinina bai i voivoiyena, sa noḡoti bi sa giuwata.” ");
INSERT INTO kqf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ḡome ena tauwaikaiwatana 12 nopodimo ḡemota isana Diudas Iskaliot, tana i nawa pilisi edi bada lisinemo, ");
INSERT INTO kqf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bi i waitalayena gado, “Bamoda tagu Yesu nimemimo yà sakona, ba visamo koi maiigu?” Kamaina bi tedi mane a iyevi te silva wapedi 30 a vite. ");
INSERT INTO kqf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mba laḡannemo bi noi i nawana ba Diudas eta i tavutavu te gavogavo ya vai bi Yesu nimedimo ya sako. ");
INSERT INTO kqf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kamaina bi buledi mote muu'a vaitena, soina laḡanna dolidolina, Yesu ena tauwaikaiwatana a tava lisinemo bi ai talayena gado, “Bamo ḡome kwa ḡoyeḡoyena Vawaitauli soina aubaim kakanonoḡi te kwa kani?” ");
INSERT INTO kqf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bi tana giu i waimunena gado, “Ko nawa malagai didiginemo, oloto ḡemota lisinemo bi ko giuwena gado, ‘Tauwailovelove i giuna gado, egu laḡani kauwa i tava, te egu tauwaikaiwatana vaitedi em vanuwemo Vawaitauli soina ka voiye.’” ");
INSERT INTO kqf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kamaina bi Yesu bai i giugiuwena mainana ena tauwaikaiwatana a voiye. Tedi a nawa bi Vawaitauli soina a kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bi laḡannemo i auaubiga ba Yesu ena tauwaikaiwatana 12 vaitedi teibolo diyana a miya kwaivivili bi a kani. ");
INSERT INTO kqf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tedi a kanikani ba i giuwedina gado, “Yà giugiu kauwemi te modomimo ḡemota kaka tagu ya sako yovoḡegu.” ");
INSERT INTO kqf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ḡome tedi ai nuwaboya kauwa bi ḡemoḡemotaḡa ai talayena gado, “Bada, giukauwa te mote tagu?” ");
INSERT INTO kqf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bi Yesu giu i waimunena gado, “Tana aiyai nimana abomemo i waidakwa yovoḡena vaitegu, tana taunana kaka ya sako yovoḡegu. ");
INSERT INTO kqf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bi Tana Taunana Natuna kaka ya peki, gilugilumina wadubonemo i giugiuna mainana, bi i gebo kauwa te lava aiyai Tana Taunana Natuna ya sakosakoyovoḡena. I visu te mba lavana maso mote i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bi Diudas tana taunana Yesu tausakoyovoḡena i giuna gado, “Tauwailovelove giukauwa te mote tagu?” Bi Yesu giu i waimunena gado, “Giukauwa tam taunana.” ");
INSERT INTO kqf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tedi a kanikani bi Yesu buledi i vai, i kavisuvisu, i kivi bi ena tauwaikaiwatana i vitedi bi i giuna gado, “Ko vai bi ko kani, niga ba tagu tubuḡigu.” ");
INSERT INTO kqf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kamaina bi ledu i vai, Maimaituwa i waiebone bi i vitedi bi i giuna gado, “Temi matabumi niga ledunemo ko lautego. ");
INSERT INTO kqf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Niga ba kwasinigu waianina aubaina, i nuwaḡini, lava wapewapedi edi gebogebo, noḡoti kamaḡedi aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tagu yà giugiuwemi te niganana bi noi i nawana niga waenina mote yàma tego munaḡe, eete mba laḡannemo kaka Tamagu ena waibadamo, temi vaitemi waen valivaliuna ta tego.” ");
INSERT INTO kqf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ḡome tedi a sale kovi te a nawa oya Olip dabanemo. ");
INSERT INTO kqf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ḡome Yesu ena tauwaikaiwatana i giuwedina gado, “Mateya dudubalinemo temi matabumi kaka tagu ko gosegu. Banina gilugilumina wadubonemo i giuna gado, ‘Tagu kaka sipu tauḡamodi yài peki bi sipu yalaboluboluna kaka sa dabalala.’ ");
INSERT INTO kqf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Bi tagu pekimo yà kenamoito munaḡana, kaka yà doli Galilimo te ḡome yà banavimi.” ");
INSERT INTO kqf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ḡome Pita, Yesu ena giu i waimunena gado, “Bamoda lava matabudi sa gose kamaḡem, bi tagu mote kaka yàma gosem.” ");
INSERT INTO kqf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ḡome Yesu giu i waimunena gado, “Yà giugiu kauwemi, mateya dudubalinemo, muliḡa kaka kamkam ya ḡabana, tam kaka mala faiona kwa valele te mote ku sibegu.” ");
INSERT INTO kqf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bi Pita i giuna gado, “Mote kaka yàma valeleyem, kamaina te vaitem ta peki.” Bi ena tauwaikaiwatana matabudi giuna ḡemotina a vato. ");
INSERT INTO kqf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kamaina bi Yesu ena tauwaikaiwatana vaitedi a nawa dobu isana Getsemenimo bi i giuwedina gado, “Temi niga ḡome ko miyamiya bi tagu yà nawa noi ḡome bi yà laupali.” ");
INSERT INTO kqf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tana, Pita bi Diyebedi natunatuna labu i waidolidi bi ḡome i wainuwaboya kauwa bi nuwana i toitoi. ");
INSERT INTO kqf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kamaina bi i giuwedina gado, “Tagu nopogu nuwaboya i waiwanavu te yai pekigu. Niga ḡome ko miya bi ko waikita.” ");
INSERT INTO kqf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bi Yesu i taunawa tabunemo te doḡamo i kuluva yovo bi i laupalina gado, “Tamagu, bamoda em ḡowana te niga wainuwatoina leduna lisigumo kwa kaikamaḡe. Bi geḡa te, mote tagu egu ḡowana bi tam em ḡowana.” ");
INSERT INTO kqf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ḡome i tava munaḡa, ena tauwaikaiwatana lisidimo bi i kitedi te a kenakena ba Pita i giuwena gado, “Temi maso ḡemoḡemotina awa ḡemota kona miya bi konai kita? ");
INSERT INTO kqf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Temi koi kita kauwa bi ko laupali te mote laulubumo koma kuluva. Banina aluwa pali ya ḡoyeḡoye, bi tubuḡa i gwaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tana i munaḡa nawa bi i laupalina gado, “Tamagu, bamoda niga wainuwatoina leduna lisigumo mote kuma kaikamaḡe ba kamaina te yà tego, kamaina te em ḡowana ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sauginemo i tavatava munaḡa ba i kita te ena tauwaikaiwatana a kenakena, banina matedi a yaune kauwa. ");
INSERT INTO kqf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kamaina bi tana i gosedi i munaḡa nawa, bi pali i waifaioni bi giudi ḡemotidi i vatodi. ");
INSERT INTO kqf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bi i munaḡa tava ena tauwaikaiwatana lisidimo bi i giuwedina gado, “Temi yaḡolo ko kenakena bi ko waiyawasi? Ko kita, saugina kaikana i tava, te Tana Taunana Natuna gebogebo lavedi nimedimo sa sako. ");
INSERT INTO kqf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ko moito bi ta nawa, tausakoyovoḡegu kaikana i tava.” ");
INSERT INTO kqf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu yaḡolo i giugiu, ba ena tauwaikaiwatana 12 nopodimo ḡemota, isana, Diudas i tava. Bi pilisi edi babada bi babada nananakidi tedi lava kumna dididiga a giukamaḡe te tana vaitena a tava, nimedimo kepata bi mada kai a legaudi. ");
INSERT INTO kqf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Niganana tausakoyovoḡena mataila lisidimo ya voiyena i giuwedi: “Bamo lavana yài suluvena, ba tana taunana ko pani.” ");
INSERT INTO kqf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kamaina bi Diudas i nawa ota Yesu lisinemo, bi i giuna gado, “Ebom tauwailovelove!” Bi i waisuluve. ");
INSERT INTO kqf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Bi Yesu giu i waimunena gado, “Goma, bai noḡotina aubaina kuna tavana ba kwa voiye.” Ḡome olooloto a moito nawa te Yesu a kaididi bi a pani nawe. ");
INSERT INTO kqf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mba ḡome te Yesu ena tauwaikaiwatana ḡemota, kepata i kaikailagetina ba pilisi edi bada ena taupaula beyana i tadikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bi Yesu i giuwena gado, “Em kepata ena gabumo ku sako munaḡe, tedi mabai kepatemo sa laulauḡasina, kaka kepatemo sai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gode temi mote ko sibe, tagu tamagu lisinemo yài baḡana sagu aubaina ba noi taunana aneya a wapa kauwana ya giukamaḡe yovoḡedina, kaka tauwaiḡaviya 72 tausan. ");
INSERT INTO kqf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bamoda mainana yà voiyena ba bainewa gilugilumina wadubonemo bai i giugiuwena banina ya tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mba sauginemo Yesu lava kumna i giuwedina gado, “Tagu gode taudanedanene edi bada te temi mada bi kepata vaitedi kona tava te ko panigu? Tagu laḡan matabuna pali vanuwina ganakukuna noponemo e miya bi e wailovelove, bi temi mote ko panigu. ");
INSERT INTO kqf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bi niga kauwidi matabudi a tubuḡana banina wala taugiuwatana a gilugilumina luvanemo sa tubutubuḡa.” Ḡome ena tauwaikaiwatana matabudi Yesu a gose, bi a naila a nawa. ");
INSERT INTO kqf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bi mabai Yesu a panipanina ba ai doli nawe pilisi edi bada Kaiyapas ena animiyamo, ḡome ba waiḡake tauwailovelovena bi babada ḡesaudi a waiḡemotidina lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita, laumanemanekemo Yesu mulinaḡa i natonatona eete pilisi saḡasaḡa guletina ena animiya ganakukunemo, i sola nawa. Bi ḡome tauyava vaitedi a miyatulu bi i waikita te bainewa Yesu sa etale. ");
INSERT INTO kqf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bi pilisi edi babada bi bolu babadidi, matabudi giu kaikaiyovudi a tavutavuḡedi te giudimo maso Yesu ai wavu bi ai peki. ");
INSERT INTO kqf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Avena te tedi kaiyovu wapewapedi a saḡedi, bi bamo mote giu kauwa a banavi. Kamaina bi lava labu a miya moito, ");
INSERT INTO kqf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bi a giuna gado, “Niga lavana i giuna gado, ‘Tagu ḡemoḡemotigu Maimaituwa ena vanuwa yà koisuwa bi laḡan faiona nopodimo yà ḡala munaḡe.’” ");
INSERT INTO kqf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ḡome pilisi saḡasaḡa guletina i miyamoito bi Yesu i giuwena gado, “Lava bai sa giugiuwemna kwa vaivaiye? Tam edi giu kwai munedi, ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kamaina bi Yesu i miya moimoisili. Ḡome Pilisi saḡasaḡa guletina Yesu i giuwena gado, “Maimaituwa yawayawasanina isanemo yà giugiu vavasaḡem te kwa giuwemai, te tam taunana Keliso, Maimaituwa Natuna.” ");
INSERT INTO kqf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu giu i waimunena gado, “Emaso, kuna giugiuna mainana. Bi matabumi yà giugiuwemi te laḡan ya natonatona kaka Tana Taunana Natuna Maimaituwa ḡaiḡailisina kataiyanemo ya miya, bi malaḡa magiyouna ya yovoyovona ko kita.” ");
INSERT INTO kqf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ḡome Pilisi saḡasaḡa guletina ena gala i lisidi bi i giuna gado, “Tana i waidiboḡana kona vaiye! Bai tai talatavu munaḡe? Kona kita ena waidiboḡa kaikana kona vaiye. ");
INSERT INTO kqf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Temi bainewa ko noḡonoḡoti?” Bi tedi giu ai munena gado, “Tana kamaina te ya peki.” ");
INSERT INTO kqf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ḡome tedi Yesu matana a kaniso bi nimedimo a paide. Bi ḡesaudi a launevakau, ");
INSERT INTO kqf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bi a giuwena gado, “Keliso, kwa giuwemai te aiyai i kativunum?” ");
INSERT INTO kqf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ganakuku noponemo i miyamiya bi taupaula waivinina i tava lisinemo, bi i giuwena gado, “Tam kota Galili Yesuna vaitena kona nawanawa.” ");
INSERT INTO kqf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bi tana matabudi matedimo i valeleye bi i giuna gado, “Tam bai kwa giugiuwena, tagu mote e sibe.” ");
INSERT INTO kqf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita ganakuku mataetinemo i potipotiyovo ba waivini ḡesau kota Pita i kita, bi ḡome lava i giuwedina gado, “Niga lavanana Nasalet Yesuna vaitena a nawanawa.” ");
INSERT INTO kqf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bi waisaḡinemo i valele munaḡana gado, “Tagu mba olotona mote yà sibe!” ");
INSERT INTO kqf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tedi a miya mote i lofa, ḡome mabai a moimoitona a saḡa a nawa Pita lisinemo bi a giuna gado, “Giukauwa tam taunana edi tau ḡemota, kalinam ke vaiye ḡone.” ");
INSERT INTO kqf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bi Pita i giuna gado, “Bamoda e kaiyovuna ba Maimaituwa kaka ya kovoḡigu.” Ḡome te Pita i giuwapana gado, “Tagu giukauwemo yà giugiuwemi te mba olotona mote yà sibe.” Noi taunana te kamkam i ḡaba. ");
INSERT INTO kqf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ḡome te Pita Yesu bai i giugiuwena i noḡotina gado, “Muliḡa kaka kamkam ya ḡabana, bi tam mala faiona kwa valeleyegu.” Bi ḡome Pita i potiyovo i nawa bi i ḡaba gulagulata. ");
INSERT INTO kqf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Olaolala kaikana pilisi edi babada bi waibabada ḡesaudi ai ogatala te Yesu sai peki. ");
INSERT INTO kqf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ḡome Yesu nimana a panidi bi ai doli nawe Loum gabemanina isana Paelat, nimanemo a sako. ");
INSERT INTO kqf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bi laḡannemo tausakoyovoḡe Diudas i vaiye te Yesu waipekina a giugiuwe, ba tana i waiuvala, bi i wainuwaboya kauwa. Kamaina bi Diudas silva wapedi 30 i munaḡedi, pilisi edi babada bi waibabada lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bi i giuna gado, “Tagu gebo e voiye te lava visuvisuna e sakoyovoḡe te sai peki yababe.” Bi tedi a giuna gado, “Mba tam em nuwaboya, mote tama.” ");
INSERT INTO kqf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kamaina bi Diudas i nawa Maimaituwa ena vanuwemo bi mane i waiyamonidi bi i potiyovo i nawa te taunemo gadona i duli. ");
INSERT INTO kqf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ḡome pilisi edi babada manedi a laitupedi bi a giuna gado, “Mote i visu te niga manedi pali vanuwina manena vaitena tamai ḡemotidi, banina manenemo peki i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ḡome tedi ai ogatala bi mba manenemo, gulewa taupatipatidi lisinemo doḡa a gimelivai te tautavatava edi aniwaikokowaga. ");
INSERT INTO kqf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taunana aubaina mba gabuna yaḡolo sa waiisana kwasina doḡana. ");
INSERT INTO kqf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Niga kauwina ba taugiuwatana Delimaiya bai i giugiuwena, luvanemo i tubuḡa. Tana i giuna gado, “Islael lavedi tana ena peki silva wapedi 30mo sai mai'i. Bi mba silvidimo ");
INSERT INTO kqf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","gulewa taupatipatidi ena doḡa a gimelina. Bada i giugiuna luvanemo i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu i nawa gabemani isana Paelat matanemo i moito bi Paelat i waitalayena gado, “Tam Diu edi ḡalibona, ee?” Bi Yesu i giuna gado, “Emaso, kuna giugiuna mainana.” ");
INSERT INTO kqf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ḡome pilisi edi babada bi waibabada ḡesaudi Yesu ai wavu, bi tana lisidimo mote bai i giuwe. ");
INSERT INTO kqf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kamaina bi Paelat Yesu i waitalayena gado, “Tam lava sa waiwavumna, kwa vaivaiyedi ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bi Yesu mote bamo edi giu i waimune lubu. Taunana aubaina gabemani i sove gulata. ");
INSERT INTO kqf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bi Vawaitauli soinemo, gabemani ena vaivaimo ba lava kumdi, bi aiyai lavana biliwelokomo waianinena taunana ya kaikaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bi mba laḡannemo gebogebo lavana isana Balabas, tana isanawanawana biliwelokomo i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bi laḡannemo lava kumna a waiḡemotidi ba Paelat i waitalayedina gado, “Bamo lavana ko ḡoyeḡoyena yà kaikamaḡe? Balabas ee Yesu, sa waiisana Keliso?” ");
INSERT INTO kqf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paelat mainana i giuna, banina i sibe te Diu babadidi ba Yesu a unule, taunana aubaina tana nimanemo a sako. ");
INSERT INTO kqf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ḡome Paelat etala gabunemo i miyamiya, bi mwanena giu i giukamaḡena gado, “Mba lavana lisinemo mote bai kuma voiye, tana mote bai gebona i voiye. Banina kage dudubalinemo mba lavana kana nawamo tagu lauboni wainuwanainailina e kita.” ");
INSERT INTO kqf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bi pilisi edi babada bi waibabada ḡesaudi lava kumna nuwedi a liudi te Paelat sai baḡa te Balabas ya kaikamaḡe bi Yesu ya tupalatu. ");
INSERT INTO kqf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bi Paelat lava kumna i waitalayedina gado, “Lava labu bi bamo taunana kona ḡoyeḡoyena yà kaikamaḡe?” Bi tedi ena giu ai munena gado, “Balabas kwa kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ḡome Paelat i waitalayedina gado, “Bi Yesu sa waiisana ‘Keliso, bainewa yài vose?” Bi tedi matabudi a binauna gado, “Kwa tupalatu!” ");
INSERT INTO kqf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bi Paelat i waitaleyedina gado, “Tana bai gebona i voiye?” Bi tedi matabudi ai palalana gado, “Kwa tupalatu!” ");
INSERT INTO kqf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Laḡannemo Paelat i kita te bamo mote eta i banavi bi waiḡasiḡasi i tubutubuḡa, ba tana gauba i vai bi lava kumna matedimo nimana i koḡa. Bi i giuna gado, “Tagu niga lavana ya pekina, ba wavuna mote yàma avali. Mba temi emi wavu.” ");
INSERT INTO kqf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ḡome te lava matabudi a giuna gado, “Kamaina te tana kwasinina ya nuwaḡinina ba wavuna tama bi natunatumai ka avali.” ");
INSERT INTO kqf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ḡome te Paelat Balabas i kaikamaḡe te i nawa, bi Yesu a kwapu, tauwaiḡaviya nimedimo a sako bi a nawe a tupalatu. ");
INSERT INTO kqf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mba ḡome te gabemani ena tauwaiḡaviya, Yesu ai doli saḡe gabemani vanuwinemo bi matabudi a moito kwaivivili. ");
INSERT INTO kqf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bi tedi ena gala a ḡiḡi kamaḡedi, bi gala sabasabana ai kote. ");
INSERT INTO kqf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bi gedala a pipini te Yesu kununemo ai kote, a solupatini bi diḡona kataiyanemo a sako. Ḡome tedi Yesu matanemo tuwapekedi ai tupagwaliḡedi, ai gadolose bi a giuna gado, “Ebom, Diu edi ḡalibona.” ");
INSERT INTO kqf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tedi a kanisotawatawa bi diḡonina a vai bi kununemo a talatalaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bi tedi ai valavala mulinemo, gala sabasabana a kaikamaḡe, bi tana ena gala otidi ai kote munaḡe. Kamaina bi ai doli nawe te a tupalatu. ");
INSERT INTO kqf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tedi a nawanawa ba Sailin olotona a banavi, isana Saimon. Ḡome tauwaiḡaviya a egeli te Yesu ena kolosi i avali. ");
INSERT INTO kqf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kamaina bi dobu isana Golgotamo a tava. Giu Golgota banina ba kunukoukou gabuna. ");
INSERT INTO kqf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ḡome tedi waen bi bunama waiḡolana mai dadawala vaitena a gwadai bi Yesu a vite te maso i tego. Bi i tegotego lubu ba i daboke. ");
INSERT INTO kqf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ḡome Yesu kolosimo a tupalatu bi wainasi beyakuluna a voiye te ena gala a dailidi. ");
INSERT INTO kqf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mba kauwina mulinemo tedi a miya bi Yesu a waikitawata. ");
INSERT INTO kqf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ḡome kai selipapinemo a gilumana gado, “NIGA BA YESU, DIU EDI ḠALIBONA.” Bi kununa kavalinemo a tutu. ");
INSERT INTO kqf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bi taudanedanene labu Yesu vaitena a tupalatudi, ḡemota kataiyanemo bi ḡemota ḡeniyanemo. ");
INSERT INTO kqf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bi lava mabai etaḡa a nawanawana, kunudi a kwadiyedi bi Yesu ai diboḡi, bi a giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Tam kuna giu te pali vanuwina kwa dousuwasuwa bi laḡan waifaioninemo kwa ḡala munaḡe. Bamoda tam Maimaituwa natuna te kwai yawasani munaḡem bi kolosi modonaḡa kwa yovo!” ");
INSERT INTO kqf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mba kauwina ḡemotinemo kota pilisi edi babada, waiḡake tauwailovelovena bi waibabada ḡesaudi vaitedi, Yesu ai ḡwaiḡwaiyena gado, ");
INSERT INTO kqf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tana bena Islael edi ḡalibona, tana lava ḡesaudi i waiyawasanidi, bi taunaḡa mote i waiyawasani munaḡe. Niganana kolosi modonaḡa ya yovo te ta kita bi tai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tana wala i giugiu te Maimaituwa natuna bi tauwaisumaḡena. Bamoda Maimaituwa ya ḡoyena te niganana yai yawasani bi ta kita.” ");
INSERT INTO kqf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bi taudanedanene labu, Yesu vaitena a tupatupalatudina kota ai diboḡi. ");
INSERT INTO kqf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bi suwalamodomo dobu matabuna i waidudubalana eete 3 koloki. ");
INSERT INTO kqf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bi 3 koloki mainana Yesu kalinana dididiginemo i talaḡabalana gado, “Eli, Eli, lema sabatani?” Niga giuna banina ba “Egu Maimaituwa, egu Maimaituwa, bai aubaina kuna gosegu?” ");
INSERT INTO kqf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bi laḡannemo tedi ḡesaudi ḡome a moimoitona a vaiye bi a giuna gado, “Koi beyavaiya! Tana Elaidiya ya yogeyoge!” ");
INSERT INTO kqf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bi noi taunana te oloto ḡemota i velau te tai i vai. Bi waen ḡolaḡolanemo i waidakwa yovoḡe te kai isunemo i pani bi Yesu lisinemo i waiyoyosaḡe te maso i tego. ");
INSERT INTO kqf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bi lava ḡesaudi a giuna gado, “Ku kita kamaḡe, bamoda Elaidiya ya yovo te yai yawasani.” ");
INSERT INTO kqf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bi Yesu kalinana dididiginemo i binau bi aluwina tamana i vitekamaḡe bi i peki. ");
INSERT INTO kqf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Noi taunana te pali vanuwinemo guduboyo i dawedawena i nuwalisi, noke dabanemo te dibunemo i laukamaḡe. Bi doḡa i gusugusu ba ḡakima nananakidi a nuwasena. ");
INSERT INTO kqf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bi tauyewa mataetidi a nuwakamaḡa bi Maimaituwa ena lava waiwaiyawidi wapewapedi a pekipekina a kenamoito munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi Yesu ena kenamoito mulinemo, mba lavedi pekipekidi tauyewa a potiyovo kamaḡedi bi a nawa Yelusalemmo a laumaḡata lava wapewapedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Laḡannemo tauwaiḡaviya 100 edi bada bi tauwaiḡaviya Yesu a waikitawata, ba yanigusugusu bi bai matabudi a tubutubuḡana a kitedi, tedi a naila gulata bi a giuna gado, “Tana giukauwa te Maimaituwa Natuna!” ");
INSERT INTO kqf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bi ḡome ba waiwaivini wapewapedi manemanekemo a waikita. Mba waiwaivinidi wala Galilimo Yesu a kaiwata bi a sagusagu. ");
INSERT INTO kqf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bi mba waiwaivinidi nopodimo ba Meli Magdalin, Meli, Diyemesi bi Diyosep tinedi, bi Diyebedi natunatuna tinedi. ");
INSERT INTO kqf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bi i auaubiga, ba Yesu taukaiwatana ḡesauna i tava. Tana ba Alimatiya olotona isana Diyosep. ");
INSERT INTO kqf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tana i nawa Paelat lisinemo bi i waibaḡa te Yesu taubeuna ya vai. Kamaina bi Paelat i waianina te tana Yesu taubeuna ya avali. ");
INSERT INTO kqf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kamaina bi Diyosep Yesu taubeuna i vai bi gala potipotinemo i suma, ");
INSERT INTO kqf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bi ena tauyewa valivaliuna doudou wainononemo i sako nawe. Ḡome te ḡakima dididiga i ḡima bi tauyewa mataetina i waidougudu bi i nawa. ");
INSERT INTO kqf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bi Meli Magdalin bi Meli tedi tauyewa mataetina yawaninemo a miya bi a waikita. ");
INSERT INTO kqf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bokinamainana Waiyawasi Laḡanna, pilipilisi edi babada bi Palisi a nawa Paelat lisinemo bi a giuna gado, ");
INSERT INTO kqf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Gabemani, niga tauwaikaikaiyovuna mamiyanemo i giugiuna gado, ‘Tagu kaka laḡan waifaioninemo yà kenamoito munaḡa.’ ");
INSERT INTO kqf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taunana aubaina tauyava kwa giuvavasaḡedi te tauyewa sa yave kauwe eete laḡan waifaioninemo. Maite ena tauwaikaiwatana sa tava bi taubeu sa danenevai, bi sa kaiyovuna gado, ‘Yesu kaikana pekimo i kenamoito munaḡa.’ Niga kaiyovuna ya tubuḡana ba ya tausaḡana mote mai dolinemo.” ");
INSERT INTO kqf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ḡome Paelat edi giu i waimunena gado, “Kamaina, emi tauyava vaitedi ko nawa bi bainewa kona noḡonoḡotina mainana ko voiye te mote bai ima tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ḡome te a nawa tauyewa mataetina a gudu ḡavute bi a ḡavipatini te mba taunana mataila bamoda walitau ima solanawa. ");
INSERT INTO kqf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Waiyawasi Laḡannina mulinemo, Sande olaloalemo, Meli Magdalin bi Meli ḡesau vaitena a nawa tauyewa ivuna aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mba ḡome aneya malaḡa i yovoyovo ba yoyo dididiga i tubuḡa. Te i nawa tauyewamo bi tauyewa mataetinemo ḡakimina i ḡimakamaḡe te dabanemo i miya. ");
INSERT INTO kqf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bi aneya kitana mai namanamali, bi ena gala potipoti otina. ");
INSERT INTO kqf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ḡome tauyava a naila gulata, bi naila i ka gusugusudi te a laugulibubu. ");
INSERT INTO kqf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kamaina bi aneya waivini i giuwedina gado, “Mote koma naila! Tagu e sibemi te temi Yesu tupatupalatuna ko tavutavuḡe. ");
INSERT INTO kqf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tana mote niga ḡome, tana kaikana i kenamoito munaḡa, wala i giugiuna mainana i tubuḡa. Ko nato bi i kenakenana gabuna ko kita. ");
INSERT INTO kqf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bi ko nawa makai bi ena tauwaikaiwatana niga mainana ko giuwedi, ‘Yesu pekimo i kenamoito munaḡa. Niganana yà taitainuwataumi, te tana ba ya dolidoli Galilimo, bi ḡome kaka ko kita.” ");
INSERT INTO kqf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kamaina bi waivini tauyewa a gose kamaḡe, nopodi i naila kauwa bi geḡa te mayasisidi, a velau ena tauwaikaiwatana giuwedi aubaina. ");
INSERT INTO kqf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mba taunana te Yesu lisidimo i laumaḡata bi i giuwedina gado, “Manuwaubemi.” Bi waivini lisinemo a nawa bi tuwapekedi ai tupagwaliḡedi, bi kaḡenemo a kabi bi a lauduneye. ");
INSERT INTO kqf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ḡome Yesu waivini i giuwedina gado, “Mote koma naila! Ko nawa bi valevaletigu ko giuwedi te sa nawa Galilimo. Bi ḡome kaka tagu sa kitagu.” ");
INSERT INTO kqf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kamaina bi waivini yaḡolo etaḡa a nawanawa ba tauyava a nawa malagai dididiginemo pilisi edi babada lisidimo, bi bai matabudi a tubutubuḡana a tainuwataudi. ");
INSERT INTO kqf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ḡome pilisi edi babada bi babada ḡesaudi vaitedi ai bolu bi ogatala a voiye, te tauyava mane dididiga a vitedi, ");
INSERT INTO kqf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bi a giuwedina gado, “Ko nawa bi lava niga mainana ko tainuwataudi, ‘Tama dudubalemo ke kenakwavu, bi Yesu ena tauwaikaiwatana a tava te Yesu taubeuna a danene vai.’ ");
INSERT INTO kqf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bi bamoda plovins tauwaibadayena niga giuna ima vaiye, ba tama kaka kakanuwabigabiga te mote bai gebogebona koma banavi.” ");
INSERT INTO kqf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kamaina bi tauyava mane a vai bi bai pilisi bi babada ḡesaudi a giugiuwedina mainana a voiye. Bi niga titikunina Diu lavedi nopodimo i dabalala, te giuna niganana yaḡolo ya kenakena. ");
INSERT INTO kqf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mba ḡome te ena tauwaikaiwatana wapedi 11 a nawa Galilimo, Yesu oya i giugiuwenemo a tava. ");
INSERT INTO kqf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bi laḡannemo tedi Yesu a kitakita, ba a lauduneye bi ḡesaudi ba a nuwakulukuluva. ");
INSERT INTO kqf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kamaina bi Yesu lisidimo i tava bi i giuna gado, “Tagu malamo bi dobumo Maimaituwa waibada matabuna i vitegu. ");
INSERT INTO kqf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Taunana aubaina, ko nawa bi dobu matabudi nopodiḡa lava ko voiyedi te egu tauwaikaiwatana sa tubuḡa. Bi ko kabuludina ba Tamana, Natuna bi Aluwa Waiyawa isedimo. ");
INSERT INTO kqf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bi bai matabuna e giugiu vavasaḡemina tedi koi lovelovedi te sa voteyeteyedi. Bi yà giugiu kauwemi te tagu laḡan matabuna temi vaitemi, eete laḡan damona.” ");
INSERT INTO kqf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Maimaituwa natuna Yesu Keliso, giuna visuvisuna ba niga mainana i tubuḡa, ");
INSERT INTO kqf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Taugiuwatana Aisaiya i gilugilumina luvanemo, mainana i tubuḡa. Maimaituwa i giuna gado, “Kwai beyavaiya, tagu egu tauwainoyanoya yà gei giukamaḡe bi em eta ya yawasi. ");
INSERT INTO kqf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lava ḡemota kalakalalelemo ya binabinauna gado, ‘Bada ena eta ko kavisuvisu bi ko kadidimani, tana ya natonato.’” ");
INSERT INTO kqf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Taunana aubaina Diyon taukabulu, kalakalalelemo i tava bi lava i kakabuludi. Tana i lauguguyana gado, “Emi gebogebo ko gosedi bi ko nato yà kabulumi bi Maimaituwa emi gebogebo ya noḡoti kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lava wapewapedi Diudiyamo bi Yelusalemmo miyemiyedi a nawa Diyon lisinemo. Bi edi gebogebo a kuvesidi bi Diyon Diyoudan gaubinemo i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Diyon ena kotekote ba kamelo kapalina vatuvatulina bi ena tagilolo ba ḡamoḡamo kwapina. Bi kanaya ba kapau bi iwavi. ");
INSERT INTO kqf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bi lava i giugiuwedina gado, “Lava muliguḡa ya natonatona ba laukaiotina mote mai tagu. Tagu mote ḡemoḡemotigu te ya laudulu bi ena kaḡesuma yà kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tagu gaubemo yà kakabulumi bi lava muliḡa ya natonatona tana Aluwa Waiyawemo ya kabulumi.” ");
INSERT INTO kqf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mba laḡannemo Yesu Galili noponemo malagai Nasalet i gose bi i nawana Diyon lisinemo. Bi Diyon Diyoudan gaubinemo Yesu i kabulu. ");
INSERT INTO kqf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bi Yesu gaubemo i laulaulovotava ba mala nuwawasana i kita. Bi Aluwa i yovona lisinemo kitana maibena gabubu. ");
INSERT INTO kqf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bi Maimaituwa kalinana malaḡa i yovona gado, “Tam ba natuotigu, nuwapougu lisimmo yà wainuwavisu.” ");
INSERT INTO kqf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mote lofana te Aluwa Yesu i wai doli nawena kalakalalelemo. ");
INSERT INTO kqf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ḡome i miyana laḡan 40 nopodimo bi Seitan Yesu i wailaulubu. Bi gunuwala ḡamoḡamodi vaitedi bi aneya a yovo te a sagu. ");
INSERT INTO kqf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ḡalodi Diyon biliwelokomo i sako nawe mulinemo Yesu i nawa Galilimo bi Maimaituwa giuna visuvisuna i lauguguyaye. ");
INSERT INTO kqf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tana i giuna gado, “Maimaituwa ena waibada lava lisidimo saugina i tava. Emi gebogebo ko kuvesidi bi giuna visuvisuna koi sumaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu Galili topana diyanaḡa i nawanawa bi Saimon ma tasina Endulu i kitedi. Tedi topamo a gomogomo, banina tedi ba taugomogomo. ");
INSERT INTO kqf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu i giuwedina gado, “Ko nato ko kaiwatagu. Temi bainewa iyana ko konekonedina mainana tagu yài lovelovemi te lava ko konedi.” ");
INSERT INTO kqf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tedi ma ḡemota edi gomo a gose kamaḡedi bi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu i taunawanawa mote lofana te Diyebedi natunatuna Diyemes bi tasina Diyon i kitedi. Tedi wagamo edi gomo a vovokaukauwedi. ");
INSERT INTO kqf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Laḡannemo wagamo i kitekitedi te i yogedi, “Ko nato ko kaiwatagu!” Ḡome tamedi Diyebedi bi tausagudi wagamo a gosedi bi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu bi ena tauwaikaiwatana a nato Kapeniam malagainemo bi waiyawasi laḡaninemo i nawa bolu vanuwinemo bi wailovelove i wai tubu. ");
INSERT INTO kqf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bi ḡome ena wailovelove lava a vaivaiyena ba a tagugu. Banina tana ena wailovelove tabuna mote mai waiḡake tauwailovelovedi mainana. Tana ena wailovelove vaiyena ba waibadana tana lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ḡome bolu vanuwinemo aluwa gebogebona oloto i sunesuneḡina i binauna gado, ");
INSERT INTO kqf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Tam Nasalet Yesuna kuna ḡoena bai lisimaimo kwa voiye? Tam kuna natona kwa ka gebogebomai ee? Tagu e sibem tam aiyai? Tam waiyawa ḡemota Maimaituwa lisinaḡa kuna yovo.” ");
INSERT INTO kqf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu aluwa gebogebona i giuwena gado, “Kumiya moimoisili bi oloto ku potiyovo kamaḡe!” ");
INSERT INTO kqf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aluwa gebogebona oloto i ka galagalali bi i voiye te i pekibubu bi i lau potiyovo kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lava matabudi ḡome a sove bi edi lava ai talayedina gado, “Niga bai kauwina ya tubutubuḡa? Niga wailovelove valivaliuna, tana waibada lisinemo te aluwa gebogebodi ya giuwedi bi kalinana sa kaikaiwata.” ");
INSERT INTO kqf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesu giuna ma ḡemota Galili dobuna matabuna i na yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tedi bolu vanuwina a gosegose, ba tana Diyemes bi Diyon vaitedi a nawa Saimon bi Endulu edi vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bi mba vanuwinemo Saimon lawana gaugaululu i vai bi ena gabumo i kenakena. Tana i sida aubaina te Yesu a tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kamaina bi Yesu i nawa waivini nimanemo i kabi bi i solu waimoito. Gaugaululu ma ḡemota i kovi bi waivini i moito te i wai kanidi. ");
INSERT INTO kqf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mba aubiganemo suwala bulubulumo lava matabudi edi lava sidesidedi bi aluwa gebogebodi a sunesuneḡidina a avala tava Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tedi matabudi vanuwina didiyaunemo ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bi Yesu edi sida tabudi bi tabudi i wai yawasanidi. Bi kota aluwa gebogebodi vaitedi i wai potiyovodi. Bi aluwa gebogebodi a sibe te Yesu tana Maimaituwa ena Vinevine. Taunana aubaina mote i wai aninedi te sa giu. ");
INSERT INTO kqf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Olaolalemo dobu mawai dudubalina, Yesu vanuwa i gose bi i nawa dobu ḡuyuwinemo bi i laulaupali. ");
INSERT INTO kqf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon bi ena lava vaitedi a nawa a tavuḡe. ");
INSERT INTO kqf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tedi tana a banavi bi a giuwena gado, “Lava matabudi tam sa tavutavuḡem.” ");
INSERT INTO kqf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bi Yesu i giuwedina gado, “Ta nawa malagai ḡesaunemo bi diyadiyanaḡa bi tedi vaitedi lisidimo yà lauguguya. Taunana aubaina e tava.” ");
INSERT INTO kqf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kamaina bi tana Galili dobuna i nawa yaḡosi bi bolu vanuwidiḡa i laulauguguya. Bi kota lava nopodimo aluwa gebogebodi i kwavidi a potipoti yovo. ");
INSERT INTO kqf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oloto sida kapa i vaivaina i tava Yesu kaḡe pakanemo tuwapekana i wai tupagwaliḡe bi i giuna gado, “Bamoda kwa ḡoena, te kwai yawasanigu.” ");
INSERT INTO kqf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu oloto i kita te i launuwatoiye, bi nimana i tuḡu te i taukoni bi i giuwena gado, “Kamaina yà ḡoeḡoena, kwa yawasana!” ");
INSERT INTO kqf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mote lofana te, sida kapa oloto i gose bi i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kamaina bi Yesu oloto i wai ḡakena gado, ");
INSERT INTO kqf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mote aiyai ḡesauna kuma giuwe. Kwa nawa pilisi sewasewa taugabuna lisinemo bi ya kitam. Bi Mousis sewasewa i giugiuwena mainana kwa voiye, te lava sa kitam te tam kuna yawasana.” ");
INSERT INTO kqf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Geḡa te oloto i nawa bi lava i giu nawedi bai lisinemo i tubutubuḡana giuna i ka didigi. Taunana aubaina Yesu mote masagaboḡa i nawanawa taun. Bi tana i nawa dobu ḡuyuwidiḡa i miyamiya nawa. Bi yaḡolo te lava bamo miyemiyedi tana lisinemo a tavatava. ");
INSERT INTO kqf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Laḡan visa a kovi mulidimo Yesu i munaḡa tava Kapeniammo. Lava a vaiye te Yesu i tava munaḡa vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kamaina bi lava wapewapedi a tava ḡome bi vanuwa nopona bi mataetina ai wanavu. Yesu Maimaituwa giuna i giugiuwedi. ");
INSERT INTO kqf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bi olooloto 4 edi tau tuni pekipekina latilatina a avali tavaite. ");
INSERT INTO kqf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tedi mote ḡemoḡemotina te maso a valageta Yesu lisinemo, lava mataeta ai wanavu. Taunana aubaina a saḡa vanuwa dabanemo, bi bamo Yesu i moimoitona luvaluvanemo bwada a koiyavusi. Kamaina bi edi tau latilatina ai dawe yovoḡe Yesu matanemo. ");
INSERT INTO kqf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu olooloto edi sumaḡa i kita aubaina oloto tuni pekipekina i giuwena gado, “Natugu, em gebogebo yà noḡonoḡoti kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ḡome waiḡake tauwailovelovena mainana a vaivaiye ba nuwedimo ai nuwanoḡonoḡotana gado, ");
INSERT INTO kqf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Maimaituwa taunaḡa gebogebo taunoḡoti kamaḡedi bai aubaina niga lavana mainana ya giugiu? Tana bena Maimaituwa vaitena ḡemoḡemotidi, ee?” ");
INSERT INTO kqf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tedi mai a wai nuwanoḡonoḡota ba Yesu ma ḡemota nopodi i sibe. Bi i giuwedina gado, “Bai aubaina nopomimo mainana ko wai noḡota? ");
INSERT INTO kqf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bamo giuna i tekateka oloto tuni pekipekina lisinemo, ‘Ku moito em kebana kwa avali bi kwa nawa, ee em gebogebo e noḡoti kamaḡe?’ ");
INSERT INTO kqf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Niganana kaka yài lovemi bi ko sibe te Tana Taunana Natuna waibadana i vai te dobumo gebogebo ya noḡotikamaḡedi.” Ḡome Yesu oloto tuni pekipekina i giuwena gado, ");
INSERT INTO kqf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kwa moito em kebana kwa avali bi kwa nawa em vanuwemo.” ");
INSERT INTO kqf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lava matabudi a kitakita bi ma ḡemota i kena moito, ena kebana i vai bi i nawa. Tedi ḡome a sove bi Maimaituwa a ka saḡesaḡena gado, “Tama niga kauwina mote bamo mainana ka kitakita.” ");
INSERT INTO kqf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu Kapeniam i gose bi i munaḡa topa diyanaḡa i nawanawa. Bi lava kumna a tava lisinemo bi i wai lovelovedi. ");
INSERT INTO kqf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tana i nawanawa te Alupias natuna Livai i kita, takis anilaitupana vanuwinemo i miyamiya. Kamaina bi Yesu i giuwena gado, “Ku kaiwatagu!” Livai i miya moito te Yesu i kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mba aubiganemo Livai ena vanuwemo, Yesu ena tauwaikaiwatana vaitedi bi takis taulaitupa bi gebogebo lavedi wapewapedi vaitedi a kanikani. ");
INSERT INTO kqf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Palisi mabai waiḡake tauwailovelovena a kita te takis taulaitupa bi gebogebo lavedi Yesu vaitena a kanikani. Taunana aubaina Palisi Yesu ena tauwaikaiwatana a giuwedina gado, “Bai aubaina tana niga lavedi vaitedi sa kanikani?” ");
INSERT INTO kqf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu i vaiyedi bi edi giu i waimunena gado, “Lava yawayawasanidi mote doketa sima ḡoeḡoe bi lava sidesidedi doketa taudidi sa ḡoeḡoe. Tagu e yovona mote didimana lavedi aubaidi bi gebogebo lavedi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Laḡan ḡemota Diyon taukabulu ena tauwaikaiwatana bi kota Palisi a udiudi. Lava ḡesaudi a tava Yesu lisinemo bi ai talayena gado, “Bai aubaina Diyon taukabulu ena tauwaikaiwatana bi Palisi edi tauwaikaiwatana sa udiudi bi tam em tauwaikaiwatana geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu i giuwedina gado, “Bai aubaina lawelawena ena tauliso sa udi? Tedi mote sima udi banina lawelawena yaḡolo tedi vaitedi. ");
INSERT INTO kqf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bi laḡan yaḡolo ya natonatona ena ḡaviya sa kaikamaḡe mulinemo kaka ena tauliso sa udi.” ");
INSERT INTO kqf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Lava mote ḡemoḡemotina te gala puselina valivaliuna ima vai bi gala wadubona vaitena ima popo waiḡemotidi. Bai aubaina, galana valivaliuna male gala wadubona ya lisi wai didigi. ");
INSERT INTO kqf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aiyai mote waen valivaliuna ima vai bi galele wadubonemo ima ḡini yovoḡe. Bamoda mainana ya voiyena ba waen galelena wadubona ya nuwa golu te galele bi waen sa gebogebo. Geḡa te tana maso waen valivaliuna i vai bi galele valivaliunemo i ḡini. ");
INSERT INTO kqf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waiyawasi laḡannemo Yesu bi ena tauwaikaiwatana vaitedi witi daibinaḡa a nawanawa bi witi banidi a tanodi bi a kanikanidi. ");
INSERT INTO kqf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Taunana aubaina Palisi Yesu a giuwena gado, “Ei! Mba tama ema waiḡake te em tauwaikaiwatana mote maso mai a voiye waiyawasi laḡannemo.” ");
INSERT INTO kqf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu giu i wai munena gado, “Temi Deivida bai i voivoiyena mote bamo ko iyevi? Sauginemo tana bi ena lava vaitedi kani a peki bi a ḡoe te maso bai a kani. ");
INSERT INTO kqf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kamaina bi i nawa Maimaituwa ena vanuwemo bi buledi Maimaituwa vitevitena i vai bi ena lava vaitedi a kani. Niga kauiwina pilisi saḡasaḡa guletina Abiyata ena waibada sauginemo i tubuḡa. Waiḡake ena luvamo mba buledina pilisi taudiḡa sa kanikani. Bi geḡa te Deivida i vai bi ena lava vaitedi a kani.” ");
INSERT INTO kqf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu giu i waikenana gado, “Waiyawasi laḡanina ba lava aubaidi. Bi waiyawasi laḡanna mote lava imai badaye.” ");
INSERT INTO kqf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Niganana kona kita, Tana Taunana Natuna, tana waiyawasi laḡanina badana. ");
INSERT INTO kqf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Waiyawasi laḡannemo Yesu i munaḡa nawa bolu vanuwinemo. Bi ḡome oloto nimana pekipekina i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bi lava ḡesaudi Yesu a wainene te sa kita, te waiyawasi laḡannemo oloto nimana pekipekina yai wai yawasani te sai wavu. ");
INSERT INTO kqf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu oloto nimana pekipekina i giuwena gado, “Ku moito kwa saḡa lava matedimo.” ");
INSERT INTO kqf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bi lava i wai talayedina gado, “Egu lava, eda waiyawasi laḡanna ena waiḡake bainewa ya giugiu? Lava ta sagu ee ta kita kamaḡe, tai yawasani ee ta kagebogebo?” Bi tedi a miya moimoisili. ");
INSERT INTO kqf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lava i kita nawedi te nopodi bagibagidi aubaina te tana nuwana i lai medimedi bi geḡa te i wainuwapoyaedi. Kamaina bi oloto i giuwena gado, “Nimam ku tuḡu.” Ḡome oloto nimana i tuḡutuḡu ba i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Palisi mai a kitakitana, tedi pali vanuwina a gose bi a nawa Alodi ena muli lavedi lisidimo. Bi Yesu kana pota a yesi te maso ai peki. ");
INSERT INTO kqf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu ena tauwaikaiwatana vaitedi mba malagaina a gose bi a nawa gelemo, Galili topana diyanemo. Bi Galili lavedi kumna a kaiwatedi. Bi bai matabuna i voivoiyena a vaiye bi lava wapewapedi Diudiyaḡa, Yelusalemḡa, Idumeya bi Diyoudan noi nevanemo, Taiya bi Sidon lavedi a tava Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Lava kumna sima dubutawi taunana aubaina te ena tauwaikaiwatana i giuwedi te waga sa kanonoḡi. Banina tana lava i waiwai yawasanidi, aubaina mabai sidesidedi a wai bibibina te maso a taukoni bi a yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ḡome lava aluwa gebogebodi a sunesuneḡidina Yesu a kitakita te matanemo a nuwalikwa bi a galagalalana gado, “Tam, Maimaituwa natuna.” ");
INSERT INTO kqf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bi Yesu aluwa gebogebodi i wai ḡakedi te mote aiyai sima giuwe te tana aiyai. ");
INSERT INTO kqf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu i nawa oya dabanemo bi tedi mabai i ḡoeḡoedina i yogedi bi a nato lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tedi 12 i vinedi bi i wai isedina, giugiukamaḡedi. Tana i giuwedina gado, “Tagu e vinemi te temi tagu vaitegu. Tagu yà giugiukamaḡemi te ko nawa ko lauguguya, ");
INSERT INTO kqf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","bi waibada ko vai te aluwa gebogebodi ko kwavidi.” ");
INSERT INTO kqf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Niga 12 i vinevinedina isedi ba Saimon i wai isana Pita, ");
INSERT INTO kqf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Diyebedi natunatuna Diyemes bi tasina Diyon i wai isedina Boaneges, niga isana banina ba palele natunatuna. ");
INSERT INTO kqf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endulu, Filip, Batolomiu, Met, isana ḡesau Livai, Tomas, Diyemes Alupias natuna, Tadias, Saimon tana ba Selot ");
INSERT INTO kqf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Bi Diudas Iskaliot tana taukaisolu. ");
INSERT INTO kqf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu i munaḡa vanuwemo bi lava kumdi a tava ai ḡemotidi, taunana aubaina Yesu bi ena tauwaikaiwatana mote ḡemoḡemotina te maso a kani. ");
INSERT INTO kqf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sauginemo ena vanuwa lavedi giuna a vaivaiye ba a nawa auwai dolinemo banina lava a giuna gado, “Yesu i bu'uwa.” ");
INSERT INTO kqf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Waiḡake tauwailovelovena mabai Yelusalemḡa a tavatavana a giu te penama edi bada taumudulele Yesu i suneḡi te ḡailisi i vite bi aluwa gebogebodi ya kwavikwavivaidi. ");
INSERT INTO kqf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kamaina bi Yesu i yogedi bi lautaulalamo i giuwedina gado, “Seitani bainewa taunaḡa ya kwavi munaḡe? ");
INSERT INTO kqf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bamo dobuna lavedi sa dailidi bi sai ḡasiḡasina ba taudiḡa sa ka gebogebodi? ");
INSERT INTO kqf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bi kota vanuwa ḡemota nopona lavedi sa dailidi bi sai ḡasiḡasina ba sai dabalalidi. ");
INSERT INTO kqf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bamoda Seitan ena dam sa dailidi bi taudiḡa sai ḡasiḡasina kaka bamo mote sima tava. ");
INSERT INTO kqf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aiyai mote oloto ḡaiḡailisina ena vanuwa ima lolo, te tana dolinemo ya panipani kaka ena ḡonaḡona ya legaudi. ");
INSERT INTO kqf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yà giugiu kauwemi te gebo matabudi bi lava kuvalidi ba Maimaituwa ya noḡotikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bi bamoda aiyai Aluwa Waiyawa i kuvalina ba Maimaituwa mote ima noḡotikamaḡe. Banina tana gebo ilailala i voiye.” ");
INSERT INTO kqf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu niga mainana i giuna banina tedi a giugiuwena gado, “Tana aluwa gebogebona i suneḡi.” ");
INSERT INTO kqf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu tinana bi tasitasina a tava didiyaumo bi ena giu a giukamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lava kumna a miyamiya kwaikwaivivilena a giuwena gado, “Ei, tinam bi tasitasim oloolotodi bi waiwaivinidi didiyaumo sa labelabem bi a ḡoeḡoena sa kitam.” ");
INSERT INTO kqf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kamaina bi Yesu i giuwedina gado, “Bamo tinaguna bi bamo tasitasigudi?” ");
INSERT INTO kqf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tana lava ḡome a miyamiyana i kita nawedi bi i giuna gado, “Tagu tinagu bi tasitasigu niga taudidi sa miyamiya. ");
INSERT INTO kqf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tana aiyai Maimaituwa ena ḡowana ya voivoiyena ba tasigu, nuvugu bi tinagu.” ");
INSERT INTO kqf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu Galili topana diyanemo wailovelove i waitubu munaḡe. Bi lava kumna a tava a dubutawi aubaina te tana waga i poupoulena dadanemo i miya saḡa. Bi lava matabudi gelemo a moito. ");
INSERT INTO kqf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tana lautaulalamo kauwa wapewapedi i wailovelovedi bi enai lovelovemo niga mainana i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Koi beyavaiya, taubayau i nawa pesi au launaḡasedimo. ");
INSERT INTO kqf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Laḡannemo pesi i laulaunaḡasedi, ḡesaudi etamo a talaḡa bi mwanuwa a tava te a kani vaidi. ");
INSERT INTO kqf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bi ḡesaudi doḡa waitelitelinemo a talaḡa. Ḡome doḡa sebunemo te pesi a duga makai banina doḡa ḡaubona. ");
INSERT INTO kqf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bi laḡannemo suwala i lovo tava bi i lalalani ba pesi kalakalanapudi i lalawaipokidi, banina tedi lamlamdi mote a yovo gulata. ");
INSERT INTO kqf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bi pesi ḡesaudi gedala nopodimo a talatalaḡana, ba a duga. Bi gedala pesi i yavanidi. Taunana aubaina mote a bani. ");
INSERT INTO kqf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bi kota pesi ḡesaudi doḡa visuvisunemo a talatalaḡana ba a duga a saḡa te a vota, ḡesaudi 30, 60 bi 100.” ");
INSERT INTO kqf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu i giuna gado, “Temi waibeyemi te koibeyavaiya.” ");
INSERT INTO kqf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Muliḡa Yesu taunaḡa i miyamiya bi ena tauwaikaiwatana 12 bi lava ḡesaudi lisinemo a tava bi ai talaye te lautaulala banina bai. ");
INSERT INTO kqf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kamaina bi Yesu tedi i giuwedina gado, “Maimaituwa ena waibadana kenakena waidavonina ba temi i vitemi. Lava tabudimo miyemiyedi tedi mwali matabudi lautaulalamo yà giuwedi, ");
INSERT INTO kqf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","te bai Aisaiya i giugiuwena ya tubuḡa, ‘Tedi sa kitakitana bi mote sima kita banavi. Bi kota male sa vaivaiyena, bi mote sima sibe. Taunana aubaina mote sima nuwavitala Maimaituwa lisinemo, te maso edi gebogebo ya noḡotikamaḡedi!” ");
INSERT INTO kqf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu tedi i wai talayedina gado, “Temi niga lautaulalana mote ko sibe? Lautaulala ḡesaudi yà giuwedina mba bainewa bi ko sibedi? ");
INSERT INTO kqf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Taubayau pesi i laulau naḡasedina ba lava Maimaituwa giuna ya giugiu nawena. ");
INSERT INTO kqf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bi lava ḡesaudi ba maibena pesi etamo kulukuluvidi. Niga lavedi Maimaituwa giuna sa vaivaiyena bi Seitan ya saḡa makai nopodimo te giu ya kaikaikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lava ḡesaudi maibena doḡa waitelitelinemo, tedi manuwavisudi giu sa vaivaiyena ");
INSERT INTO kqf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bi lamlamdi geḡa aubaina mote sima moimoito didina. Laḡannemo pilipili bi laukivigebogebo sa saḡa, Maimaituwa giuna aubaina ba tedi maḡemota sa kuluva. ");
INSERT INTO kqf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lava ḡesaudi maibena pesi gedala nopodimo a talatalaḡana. Tedi Bada giuna sa vaivaiyena, ");
INSERT INTO kqf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bi kota niga dobuna ena yawasana, mai mane ḡoena bi mwali ḡesaudi noḡotidi sa tava te Maimaituwa giuna sa yavayavani. Taunana aubaina tedi mote sima votavota. ");
INSERT INTO kqf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lava ḡesaudi maibena pesi doḡa visuvisunemo wadiwadidi. Niga lavedi ba giu sa vaiye, te nopodimo sa sako bi sa kaikaiwata. Tedi votedi ḡesaudi 30, 60 bi 100.” ");
INSERT INTO kqf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu lava niga mai i giuwedina gado, “Lava piupiu i gabuna, mote bai sauginemo ima vai te gulewa dibunemo ee bena dibunemo ima sako nawe. Bi tana masagabomo ḡakima dabanemo ya sako te ya yana. ");
INSERT INTO kqf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mwali bai kankandavonina muliḡa male ya laumaḡata. Bi mwali bai waiwai kwesina male ya lazaumasagabo. ");
INSERT INTO kqf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bamoda temi wai beyemi te koi beyavaiya.” ");
INSERT INTO kqf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bi kota lava i giuwedina gado, “Bai ko vaivaiyena, kamaina te ko vaiye kauwe. Bamoda niga kauwina ko komaniyena ba Maimaituwa kauwa ḡesaudi yai lovelovemi te ko sibedi. Bi kota tana kauwa wapewapedi ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aiyai niga kauwidi ya vaivaiye kauwedina ba Maimaituwa tana lisinemo nuwauyauya yai lautawi. Bi aiyai mote ima waibeyavaiya kauwa bi lisinemo ḡaubona ya kenakenana kaka sa kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Bi Yesu i giuna gado, “Maimaituwa ena waibada ena lava lisidimo titikunina ba niga mainana: Lava pesi ena daibimo i wadidi. ");
INSERT INTO kqf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dudubala bi suwala tana ya kenakena ee ya miyamiya bi pesi kamaina te sa dugaduga. Bi tana mote i sibe te bai ya tubutubuḡa ");
INSERT INTO kqf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Doḡa taunaḡa pesi ya wai dugedi bi ya wai votedi. Dolinemo sa kalanapu te lugudi sa sivudi bi sa love te sa buso bi banidi nopodimo sa sivudi. ");
INSERT INTO kqf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Laḡannemo pesi i tabutuna ba lava ya tava te biliukomo ya laukoiḡavuka. Banina vililubu ena laḡani i tava.” ");
INSERT INTO kqf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu i giu munaḡana gado, “Maimaituwa ena waibadana ena lava lisidimo ba bai ya lau koiluvae te ko sibe? Ee bai lautaulalana tagu yà giuwe te ko sibe? ");
INSERT INTO kqf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mba maibena wasiva pouna ḡaubo otina doḡamo ko wadiwadina. ");
INSERT INTO kqf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Muliḡa mba pesina ya duga te ya didiga mote mai pesi ḡesaudi. Bi lagalagana waiyamonina damodamodimo mwanuwa sawasawaḡa lovolovodi sa tava te sa laulau noḡi.” ");
INSERT INTO kqf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Niga lautaulalana bi lautaulala ḡesaudi vaitedi, Yesu Maimaituwa giuna lava edi luvamo i giuwedi te maso a sibe. ");
INSERT INTO kqf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tana giu matabudi i giugiuwedina ba lautaulalamo i giugiuwedi, bamo mote giu bai i giu otiedi. Bi kota laḡannemo ena tauwaikaiwatana taudiḡa ba tana giu bani otidi i giugiuwedi. ");
INSERT INTO kqf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mba laḡanna ḡemotina aubiganemo, Yesu ena tauwaikaiwatana i giuwedina gado, “Ta nawa noi nevanemo.” ");
INSERT INTO kqf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesu wagamo bi ena tauwaikaiwatana tana vaitena a nawa. Bi lava kumna ḡome gelemo a gosedi. Bi tedi edi waga bi waga ḡesaudi vaitedi a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tedi a nawanawa te yavala didiga i tava. Bi labama wagamo i talatalaḡa te gauba waga noponemo i waidubusaḡe bi ḡotona te maso i wanavu. ");
INSERT INTO kqf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bi Yesu waga mulinemo kunuwana dabanemo i kenakena. Kamaina bi ena tauwaikaiwatana tana a lainuwesi bi a giuwena gado, “Tauwailovelove tam kwai nuwaboyaeda ee geḡa? Niga ta peki!” ");
INSERT INTO kqf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu i moito bi kalinana bagibaginemo yavala i giuwena gado, “Ku nuwaḡavuka.” Bi labama i giuwena gado, “Ku lautautau.” Kamaina bi yavala i nuwaḡavuka bi daumola i kena ");
INSERT INTO kqf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu ena tauwaikaiwatana i giuwedina gado, “Temi bai aubaina ko nainaila? Temi ko wai sumaḡa ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tedi a naila bi taudiḡa ai giugiuna gado, “Niga tana aiyai? Te yavala bi labama i giuwedi te kalinana a kaiwata.” ");
INSERT INTO kqf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu bi ena tauwaikaiwatana Galili topana noi nevanemo, Gelasin lavedi edi dobumo. ");
INSERT INTO kqf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sauginemo Yesu waga dabanemo i potipoti yovo te, oloto aluwa gebogebodi a sunesuneḡina, tana tauyewamo bi i velau i tava Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Niga olotona tauyewaḡa miyamiya nawina, mote aiyai ḡemoḡemotina te ya katautau. Tana suwala bi dudubala tauyewaḡa bi dakiḡa i binabinau nawa bi sabilemo tunina i sesesedi. Bi tana laḡani matabuna kaḡena bi nimana seinimo a panipanidi bi geḡa te i katikati ḡavuḡavukidi. ");
INSERT INTO kqf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sauginemo tana Yesu manekemo i kitakita, te i velau Yesu kaḡe pakanemo bi tuwapekana i wai tupagwaliye. ");
INSERT INTO kqf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bi kalinana dididiginemo i binauna gado, “Yesu Maimaituwa saḡasaḡa guletina Natuna, tam bai lisigumo kwa voiye? Maimaituwa isanemo yà giugiuwem te mote kuma laukivi gebogeboegu.” ");
INSERT INTO kqf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Niga mainana i giuna, banina Yesu kaikana giuwena gado, “Tam aluwa gebogebom oloto ku potiyovo kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ḡome Yesu, oloto i waitalayena gado, “Tam isam bainewa?” Te tana niga mainana i giuvitena gado, “Tagu isagu kumna tama ke wapa kauwa.” ");
INSERT INTO kqf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bi aluwa gebogebona yaḡolo te Yesu i waibaḡa gulate te maso mote i giukamaḡedi wali dobumo. ");
INSERT INTO kqf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bi mba ḡome buwawa kumna dididiga a yabayaba oya nevakaunemo. ");
INSERT INTO kqf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Taunana aubaina penama Yesu ai baḡa gulatena gado, “Kwa giu kamaḡemai te buwawa lisidimo te nopodimo ka sola nawa.” ");
INSERT INTO kqf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kamaina bi Yesu aluwa gebogebodi i giuwedi te oloto a potipoti yovo kamaḡe bi buwawa nopodimo a sola nawa. Kamaina bi buwawa kumna wapana 2 tausan dabakai a velauwata a yovoyovona ba topamo a tona. ");
INSERT INTO kqf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bi buwawa tauḡamodi a velau a nawa malagai nopodiḡa bi malagai diyadiyanaḡa bi bai i tubutubuḡana, lava a giuwedi. Kamaina bi lava bai i tubutubuḡana au kitanemo a tava. ");
INSERT INTO kqf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Laḡanemo lavedi Yesu lisinemo a tava, ba olotona penama kumna a sunesuneḡina a kita, i wai gala kauwa bi ena noḡota didimaninemo i miyamiya ba lavedi a naila kauwa. ");
INSERT INTO kqf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tedi mabai oloto aluwa gebogebodi a sunesuneḡina bi kota buwawa lisidimo bai i tubutubuḡana a kitakitana lava ḡesaudi a giuwedi. ");
INSERT INTO kqf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Taunana aubaina tedi Yesu ai baḡa te edi dobu ya gose. ");
INSERT INTO kqf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Laḡaninemo Yesu wagamo i gelugelu tena, oloto aluwa gebogebodi a sunesuneḡina Yesu i wai baḡa te vaitena maso a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bi Yesu mote i wai anine bi i giuwena gado, “Kwa munaḡa em vanuwa lavedi lisidimo bi Bada bai lisimmo i voivoiyena bi ena lau kivivisuvisu tedi kwa giuwedi.” ");
INSERT INTO kqf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kamaina bi oloto i modina i nawa malagai 10 nopodiḡa bi bai Yesu lisinemo i kaukauwena, lava i giu nawedi. Bi lava a vaivaiyena ba a sove. ");
INSERT INTO kqf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wagaḡa i munaḡa noi nevanemo i tava. Tana topa diyanemo i miyamiya bi lava kumna a tava a dubutawi. ");
INSERT INTO kqf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bolu vanuwina taulabena isana Diyailesi i tava Yesu i kitakita ba Yesu kaḡe pakanemo tuwapekana i waitupagwaliḡe ");
INSERT INTO kqf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","bi nuwana tabutabunemo i wai baḡana gado, “Natugu waivinina ḡaubona i sida kauwa, ḡotona te ya peki. Aee, kwa nato nimam dabanemo kwa sako te ya yawasana bi ya miya.” ");
INSERT INTO kqf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kamaina bi Yesu vaitena a nawa. Bi kota lava kumna dididiga tana a kaiwata bi a bibibini. ");
INSERT INTO kqf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ḡome waivini ḡemota kwalabu wapana 12 kwasina i miyamiya kamakamaḡena. ");
INSERT INTO kqf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Niga waivinina ena mane matabuna doketa lisidimo i waiyakali. Bena maso i yawayawasana ba sida i dididiga. ");
INSERT INTO kqf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Laḡannemo waivinina Yesu giuna i vaivaiye ba tana lava kumna mododiḡa Yesu mulinaḡa i saḡa bi ena gala isu damodamonaḡa i taukoni. ");
INSERT INTO kqf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Banina tana kaikana noponemo i wai noḡotana gado, “Bamoda Yesu ena galaḡa yà taukonina ba yà yawasana.” ");
INSERT INTO kqf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Noi taunana te waivini ena sida kwasina i miyamiya kamakamaḡena i kovi. Bi tuninemo mayana i vai te ena wainuwatoimo i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu maḡemota mayana i vai te ḡailisi lisinemo i potiyovo. Bi i tauvitale lava kumna nopodimo bi i wai talayedina gado, “Aiyai i taukonigu?” ");
INSERT INTO kqf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bi ena tauwaikaiwatana a giuwena gado, “Tam kuna kita te lava kumna sa bibibinim bi kuna giu te aiyai i taukonigu?” ");
INSERT INTO kqf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bi tana yaḡolo te i wai laulau kita te aiyai ena gala i taukoni. ");
INSERT INTO kqf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Waivini i noḡoti munaḡe te tana i taukoni. Taunana aubaina tana manailina bi magusuna i tava Yesu kaḡe pakanemo te tuwapekana i wai tupagwaliye bi mwali matabuna i ka maḡati. ");
INSERT INTO kqf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bi Yesu waivinina i giuwena gado, “Keulo, em sumaḡa i wai yawasanim. Em sida i kovi bi ma nuwaubam kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu yaḡolo waivini lisinemo i giugiu ba Diyailesi ena vanuwa lavedi a tava bi a giuwena gado, “Tauwailovelove kuma kaka nuwalaḡalaḡa natum kaikana i kovi.” ");
INSERT INTO kqf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tedi mai a giugiu ba Yesu beya damodamonemo i vaiyedi bi bolu vanuwina taulabena i giuwena gado, “Nuwam ima kulukuluva kwai sumaḡa ota.” ");
INSERT INTO kqf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ḡome lava matabudi i wai ḡakedi, kamaina Pita, Diyemes bi tasina Diyon taudiḡa tana vaitena a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tedi a nawa Diyailesi ena vanuwemo a tavatava ba lava i kitedi a ḡabaḡaba bi, a leleleyakeyake bi a nusanusa. ");
INSERT INTO kqf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu vanuwa noponemo i valageta bi i giuwedina gado, “Bai aubaina ko wai nuwapoyae bi ko ḡabaḡaba? Gomana mote i peki tana ya kenakena ota.” ");
INSERT INTO kqf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lava Yesu ai gwaigwaiye aubaina, lava i giuwedi a potiyovo doḡamo. Kamaina bi Yesu ena tauwaikaiwatana faiona bi gomana tamana bi tinana a saḡa noke gomana lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kamaina bi Yesu gomana nimanemo i kabi bi i giuna gado, “Talita kum.” (Niga giuna banina ba keulo yà giugiuwem te kwa kenamoito.) ");
INSERT INTO kqf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma ḡemota gomana i kenamoito bi i moito nawa. Niga gomenina ena kwalabu ba 12. Lava niga kauwina a kita te a sove gulata. ");
INSERT INTO kqf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu lava i waiḡakedi te bai i tubutubuḡana mote aiyai sima giuwe. Bi i giuwedi te gomana kani sa vite ya kani. ");
INSERT INTO kqf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu mba dobuna i gose bi i munaḡa ena malagai otinemo bi ena tauwaikaiwatana a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Waiyawasi laḡannemo tana wailovelove i waitubu bolu vanuwinemo. Bi lava wapewapedi ḡome ena wailovelove a vaivaiyena, tedi matabudi a tatava bi ai talapilina gado, “Niga nuwauyauyana bamo i vai? Bi kota bamo ḡailisi i vai bi ani sove kauwidi ya voivoiyedi? ");
INSERT INTO kqf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tana ba taukamda, Meli natuna. Bi tasitasina niga Diyemes, Diyousep, Diudas bi Saimon. Bi kota nuvunuvuna niga vaiteda, ee?” Kamaina bi Yesu a daboke. ");
INSERT INTO kqf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu tedi i giuwedina gado, “Lava ḡesaudi ba taugiuwatana sa vivivile bi ena dam bi ena vanuwa lavedi ba mote sima vivivile.” ");
INSERT INTO kqf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Taunana aubaina lisidimo mote ani sove kauwidi i voiyedi bi lava sidesidedi visa ota lisidimo nimana dabedimo i sako bi i wai yawasanidi. Bi Yesu i sove te lavedi mote ai sumaḡe. Yesu i nawa malagaiḡa bi lava i wailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tana ena tauwaikaiwatana 12 i giuwedi te a nato lisinemo bi labulabuḡa i giukamaḡedi. Tedi waibada i vitedi te aluwa gebogebodi sa vawaiubedi ");
INSERT INTO kqf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","bi kota niga mainana i giuwedi, “Ko nawanawana mote bai ḡidoina koma vai, diḡona taunaḡa ko vai. Ko nawanawana mote kani, mote tana, mote mane koma tagini. ");
INSERT INTO kqf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bi kaḡesuma ba ko kotedi bi kwama ḡidoi mote koma vai.” ");
INSERT INTO kqf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bi kota niga mainana i giuwedina gado, “Bamo malagaidimo ko tavatava bi vanuwinemo sa giuvaimina, ba vanuwidimo ko miyamiyana eete malagaina ko gose. ");
INSERT INTO kqf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bi bamoda lava mote sima ḡoemi bi mote simai beyavaiyemi, kamaina te kaḡemi gobusidi ko lai kulukuluvidi bi ko gose kamaḡedi. Mba ba wailove te muliḡa lisidimo bai ya tubuḡana, mba tedi edi wavu.” ");
INSERT INTO kqf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kamaina bi ena tauwaikaiwatana a nawa bi lava lisidimo a lauguguya te lava maso edi gebogebo a kuvesidi. ");
INSERT INTO kqf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tedi lava nopodimo aluwa gebogebodi a kwavidi, te a lau potiyovo. Bi kota olip masinemo lava sidesidedi tunidi a kailolodi bi ai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Yesu giuna kaikana i dididiga, taunana aubaina lava a giugiuna gado, “Diyon taukabulu male pekimo i kena moito. Taunana aubaina ḡailisi bi ani sove kauwidi ya voivoiyedi.” Bi ḡesaudi a giugiuna gado, “Tana Elaidiya.” Bi kota ḡesaudi a giugiuna bena kage, “Bada taugiuwatana ḡemota mai wala dolinemo.” Bi ḡalibona Alodi i vaiye te Yesu isana kaikana ya dididiga bi i giuna gado, “Tagu wala Diyon taukabulu gadona e koi ḡavuki bi kota pekimo i kena moito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Alodi wala tauwaiḡaviya i giukamaḡedi te Diyon a kaididi bi a lau seini te biliwelokomo a sako nawe. Alodi tinanatuna Filip mwanena isana Elodias wala i kwaya. Taunana aubaina Diyon, Alodi niga mainana i giugiuwena gado, “Mote i visu te tinanatum mwanena kuna kwaya.” Taunana aubaina, Elodias nuwana i medi Diyon taukabulu lisinemo bi i ḡoeḡoe te maso i wai peki. Bi mote i ḡemoḡemotina te maso mainana i voiye banina Alodi tana Diyon i naile bi i labelabe kauwe. Bi i sibe te Diyon tana lava waiyawa bi didimanina. Laḡan wapawapa Diyon tana Alodi ena kauwa aubaina i giugiu matai bi Alodi i nuwanuwalaḡalaḡa te Diyon ena giu mote i noḡonoḡoti watawata. Bi Alodi yaḡolo te Diyon ena giu vaiyena i ḡoeḡoe. ");
INSERT INTO kqf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kamaina bi Alodi ena tubuḡa laḡanna soina i voiye. Bi gabegabemani babadidi, ḡaviya babadidi bi kota Galili babadidi i giuwedi te a tava ena soimo. Ḡome Elodias gavogavo i vai te ena nuwa kilikili ya laukamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ḡome Elodias natuna guguinina i saḡa bi i bigabiga te ḡalibona Alodi ena soi taulisoena nuwedi i laukwasili. Kamaina bi ḡalibona Alodi gomana i giuwena gado, “Bai kwai baḡaena ba ḡemoḡemotina yà vitem.” ");
INSERT INTO kqf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Alodi niga mainana gomana lisinemo i giuwapa, “Bai lisigumo kwai baḡaena ba yà vitem bamo te egu waiguyau kwa ḡoena ba nevana yà vitem.” ");
INSERT INTO kqf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gomana ḡome i potiyovo i nawa tinana i giuwena gado, “Bai yaibaḡae?” Bi tinana gomana i giuwena gado, “Tagu egu ḡowana Diyon taukabulu kununa.” ");
INSERT INTO kqf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gomana ḡome maḡemota i velau i munaḡa ḡalibona Alodi lisinemo bi niga mainana i waibaḡa, “Yà ḡoeḡoena noi taunana Diyon taukabulu kununa aboma noponemo.” ");
INSERT INTO kqf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niga giuna ḡalibona i voiye te i wai nuwaboya kauwa. Bi tana mote ḡemoḡemotina te gomana ena giu ya giuvitale. Banina tana kaikana i giuwapa ena tauliso matedimo. ");
INSERT INTO kqf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kamaina bi ḡalibona ena tauwaiḡaviya maḡemota i giukamaḡe te Diyon gadona ya koiḡavuki bi ya vai natome. Tauwaiḡaviya i nawa biliwelokomo Diyon gadona i koiḡavuki bi ");
INSERT INTO kqf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","abomemo i sako te i vai natome ḡalibona i vite. Bi ḡalibona i vai te gomana i vite bi gomana i vai nawe te tinana i vite. ");
INSERT INTO kqf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Laḡannemo Diyon taukaiwatana a vaiye te Diyon i peki, tedi a tava te taubeuna a vai nawe te tauyewamo a sako. ");
INSERT INTO kqf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu giugiukamaḡedi i giukamaḡedi bi a nawanawana a tava munaḡa te a wailovelovena bi lava a wai yawasanidina Yesu a tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lava ḡome a natonato bi a nawanawa aubaina te tedi mote ḡemoḡemotina te maso a miya bi a kani. Taunana aubaina Yesu ena tauwaikaiwatana i giuwedina gado, “Temi taumiḡa ko nato ta nawa dobu ḡuyuwinemo bi ko sula waiyawasi.” ");
INSERT INTO kqf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kamaina bi tedi taudiḡa wagamo a gelu bi a nawa dobu ḡuyuwinemo. ");
INSERT INTO kqf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lava ḡome tedi a kitekitedi ba a sibe otiyedi. Kamaina bi malagai matabudi nopodimo lava a lau potiyovo bi geleḡa a vamakamakai te a gei tava. ");
INSERT INTO kqf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Laḡannemo Yesu wagaḡa balabalamo i sunasuna saḡa ba lava kumna i kitedi bi i lau nuwatoiyedi. Banina tedi maibena sipu bi taulabedi geḡa. Kamaina bi giu visuvisuna wai lovelovedi i waitubu. ");
INSERT INTO kqf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aubigamo ena tauwaikaiwatana a tava lisinemo bi niga mainana a giuwe, “Niga ba dobu ḡuyuwina bi mateya te ya dudubala. ");
INSERT INTO kqf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lava kwa giu kamaḡedi sa nawa malagaiḡa bi malagai diyediyediḡa te kani sa kune bi sa kani.” ");
INSERT INTO kqf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bi Yesu niga mai i giuvitedi, “Temi kani ko vitedi te sa kani.” Bi tedi tana a giuwena gado, “Tam kwa ḡoeḡoena tama ka nawa te mane 200 denali luvana buledi ka gimala bi kai kanidi ee?” ");
INSERT INTO kqf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bi Yesu i wai talayedi, “Buledi visa lisimimo? Ko nawa ko kita.” Ena tauwaikaiwatana a nawa te a kita bi a giuna gado, “Buledi 5 bi iyana labu.” ");
INSERT INTO kqf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu ena tauwaikaiwatana i giuwedi te lava a laidubudubudi ḡawaḡawa gidegidevidi dabedimo te a miya. ");
INSERT INTO kqf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kamaina bi lava edi dubuḡa a miya lelesidi ḡesaudi 100 bi ḡesaudi 50. ");
INSERT INTO kqf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kamaina bi Yesu buledi 5 bi iyana labu i tanodi te i wai kita saḡa malamo, Maimaituwa i wai ebone bi buledi i kividi. Tana i kivi kovidi te ena tauwaikaiwatana i vitedi te a soiye bi lava a vitedi. Bi kota iyana vaitedi i lisidi bi a soiye edi dubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lava matabudi a kani te a kani nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bi ena tauwaikaiwatana lava buledi bi iyana a kanikani sivudina a laitupa bi po'a 12 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Olooloto taukani wapedi ba 5 tausan. ");
INSERT INTO kqf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu maḡemota taukaiwatana i giuvavasaḡedi te wagamo sa gelu bi sa dolidoli Betsaidamo, noi nevanemo bi kota lava kumna i giukamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tana lava i wai ebonedi a nawanawa mulidimo tana i nawa oyamo laupali aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tautaugudu balana bi waga topa modonemo taunaḡa i poupoule i kita nawe. Bi gelemo taunaḡa i moimoito. ");
INSERT INTO kqf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bi Yesu ena tauwaikaiwatana i kitedi te waga a ḡiuḡiu bi a kabikabiye banina yavala i suvesuvedidi bi labama i talatalaḡa. Kamaina bi laḡan sakosako balana Yesu topa dabanaḡa i nawanawa lisidimo bi ḡotona te maso i vawaitaulidi. ");
INSERT INTO kqf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bi tedi a kitakita ba ai noḡota bena alualuwa. Taunana aubaina tedi a naila gulata ");
INSERT INTO kqf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bi a kabi binabinau. Ma ḡemota Yesu tedi lisidimo i giuna gado, “Nuwemi ya lautou. Tagu, mote koma naila.” ");
INSERT INTO kqf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kamaina bi Yesu waga dabanemo i moito saḡa lisidimo bi yavala i lautautau. Ena tauwaikaiwatana mainana a kitakitana ba edi sove i kovi. Banina Yesu buledi i kivikivina banina yaḡolo mote a sibe, aubaina te edi noḡota mote a didimana. ");
INSERT INTO kqf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Laḡannemo Yesu taukaiwatana vaitedi noi nevanemo a tava Ganasaletimo bi edi waga ai moito bi a pani kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Noi taunana wagamo a potipoti yovo ba lava Yesu a kita ḡone. ");
INSERT INTO kqf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kamaina bi tedi a nawa mba dobuna bi diadiana lavedi a giuwedi. Bi lava sidesidedi latilatimo ai kenedi bi a avala tava. Bi Yesu i nawanawana matanemo a wai kenedi. ");
INSERT INTO kqf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu i nawanawana malagaidiḡa bi malagai diyadiyanaḡa lava edi lava sidesidedi a natomedi bi ani waiḡemota gabudiḡa a wai kenedi. Bi Yesu ai baḡa vavasaḡe te maso ena gala isu damodamonaḡa a taukoni bi a yawasana. Tedi mabai tana ena gala a tautaukonina ba matabudi a yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Palisi bi Diu iteitedi edi vaivai a voiyedi bi a wai laudamedina taudidi a kaikaiwata kauwedi. Mba vaivaidi ba niga mainana: Tedi mote sima kani te dolinemo nimedi sa gei koḡedi kaka sa kani. Ḡemoḡemotina kota mainana waikunekunemo bi a tava munaḡana ba mote sima kani te nimedi sa koḡa kauwedi kaka sa kani. Bi kota vaivai wapewapedi ḡesaudi iteitedi lisidiḡa a yovoyovona vaitedi a kaikaiwatedi, maibena ledu, gulewa bi aboma koḡedi. Niga mainana sa voiyedi te bena Maimaituwa matanemo tedi kamaina. Kamaina bi Palisi bi waiḡake tauwailovelovena Yelusalemḡa a tava Yesu lisinemo. Bi ḡome Yesu ena tauwaikaiwatana ḡesaudi a kitedi te mote nimedi a koḡedi bi a kanikani. ");
INSERT INTO kqf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Taunana aubaina tedi Yesu ai talayena gado, “Bai aubaina taukaiwatam mote sima lau nimakoḡa bi sa kanikani. Tama itaitamai edi vaivaimo ba lava nimedi sa gei koḡedi kaka sa kanikani.” ");
INSERT INTO kqf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bi tana edi giu i waimunena gado, “Temi lava matedimo ko voiyemi te bena giu kauwa bi geḡa te nopomi kavekavedi. Taugiuwatana Aisaiya i gilugilumina niga mainana i giu watemi, ‘Niga lavedi mududiḡa sa giugiu te sa vivivilegu bi nopodi ba mote lisigumo. ");
INSERT INTO kqf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tedi taudiḡa edi vaivai sa wai lovelovedi bi sa giugiu te bena Maimaituwa ena waiḡake. Taunana aubaina sa laulauduneyeguna bi banidi geḡa.’” ");
INSERT INTO kqf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu i giuwedina gado, “Temi Maimaituwa ena waiḡake ko sakosako liye bi temi emi wailovelove ko kaikaiwatedi.” ");
INSERT INTO kqf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bi kota i giuwedina gado, “Temi konai noḡota bena ko voivoiye kauwe, Maimaituwa ena waiḡake mulimimo kona sako liye bi iteitemi edi vaivai a wai lovelovemina ko kaikaiwata kauwedi. ");
INSERT INTO kqf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mousis i giuwedina gado, Tamam bi tinam kwa viviledi, bi aiyai tamana bi tinana i kuvalidi ba sa laipeki. ");
INSERT INTO kqf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bi temi ko giugiuna bamoda lava lisinemo bai mwalina ya kenakena tamana bi tinana maso i vitedi bi geḡa te i giuwedina gado, niga Maimaituwa aubaina e sako temi mote yàma vitemi. ");
INSERT INTO kqf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Temi emi wailovelove oloto konai love wapa te tamana bi tinana mote ima sagusagudi. ");
INSERT INTO kqf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Niga mainana wailovelovedi kowai dama lava ḡesaudi lisidimo bi Maimaituwa giuna ko kaka neḡaneḡa. Bi mote niga kauwina taunaḡa bi kota kauwa wapawapa vaitedi ko voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu lava kumna i yogedi a tava munaḡa lisinemo bi i giuwedina gado, “Matabumi koi beyavaiyegu bi giu banidi kosibedi. ");
INSERT INTO kqf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Mwali bai lava gayanemo ya wai daululuna, mote ima ka milamila bi bai noponemo ya saḡa te gayanemo ya potipotiyovona taunana ya kaka milamila.” ");
INSERT INTO kqf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sauginemo tana lava kumna i gosedi bi i nawa vanuwemo bi ena tauwaikaiwatana ai talaye te lautaulala banina bai. ");
INSERT INTO kqf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Bi i giuwedina gado, “Temi yaḡolo ko wai nuwanaina, mote ko sibe? Temi kona sibe e geḡa te kani bai lava i kanina ba ya yovona bwaganemo te ya potiyovo munaḡa bi mote kaka nopona imai mila.” Yesu niga mainana i giuna ba i ka maḡati te kani matabudi ba visuvisudi Maimaituwa matanemo. ");
INSERT INTO kqf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bi kota i giu, “Mwali bai lava noponemo ya potipotiyovona mba taunana yawai mila. ");
INSERT INTO kqf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lava nuwapounemo noḡota gebogebodi mai elawa, waimwanemwanena yabayababa, danene, waipeki bi waimatawapa. ");
INSERT INTO kqf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kanitoku, lau laukivigebogebo, waikaikaiyovu, unula, kuvali, nuwasaḡasaḡa bi kauwa yabayababa. ");
INSERT INTO kqf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Niga kauwidi matabudi lava nopodimo sa tubutubuḡana, taudidi lava sa kaka milamila.” ");
INSERT INTO kqf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu mba malagaina i gose bi i nawa Taiya malagainemo Fonisia noponemo. Bi vanuwemo i miya moimoisili, mote i ḡoe te lava sa sibe. Bi mote ḡemoḡemotina te maso i kandavona. ");
INSERT INTO kqf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Sailiya noponemo dobu Fonisia waivinina bi natuna aluwa gebogebona i sunesuneḡina, i vaiye te Yesu ḡome. Kamaina bi i tava Yesu lisinemo bi kaḡe pakanemo tuwapekana i wai tupagwaliye. Bi i waibaḡa vavasaḡe te aluwa gebogebona natuna i sunesuneḡina maso i kwavi. ");
INSERT INTO kqf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Waivinina ba eteni bi Yesu i giuwena gado, “Mote i visu te libilibi kediya yà vai bi yà pwalaḡe daḡasi matedimo, libilibi sa gei kani te sa launonoḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Waivini Yesu ena giu i wai munena gado, “Bada bai kuna giuwena ba giu kauwa, bi geḡa te daḡadaḡasi kani puselidi benamo sa lavulavusana sa kanikanidi.” ");
INSERT INTO kqf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bi Yesu waivini i giuwena gado, “Mainana kuna giu aubaina, kwa nawa bi natum kaikana penama i gose.” ");
INSERT INTO kqf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kamaina bi i munaḡa vanuwemo, penama i potiyovo bi gomana i kita i kenakena. ");
INSERT INTO kqf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Taiya i gose bi Sidon noponaḡa i nawa te Galili nisanemo bi Taun 10 nopodiḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bi ḡome lava editau papapina ai doli tavaite Yesu lisinemo bi ai baḡa vavasaḡe te nimana maso papapa dabanemo i sako. ");
INSERT INTO kqf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu oloto i wai doli bi lava a gosedi bi a nawa tabudimo, Yesu nimana i tuḡudi bi oloto beyana i sikwedi bi nimagalana i gelolo bi oloto menana i taukoni. ");
INSERT INTO kqf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kota Yesu i wai kita saḡa malamo bi yawasina i bunanai kamaḡe bi oloto i giuwena gado, “Ephphatha banina ba ku nuwakamaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Maḡemota oloto beyana bi menana a nuwakamaḡa bi i wai beyavaiya bi i gagali ota. ");
INSERT INTO kqf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu i waiḡakedi te mote aiyai sima giuwe bi geḡa te kauwina a giugiu nawe. ");
INSERT INTO kqf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sauginemo lava kauwina giuna a vaivaiye te a tagugu bi a sove. Bi a giu te bai matabuna i kauwena ba visuvisunaḡa, papapa i wai beyavaiya bi i giu. ");
INSERT INTO kqf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sauga ḡemota lava wapewapedi ai ḡemoti munaḡedi. Lava kediya geḡa aubaina te Yesu taukaiwatana i yogedi a tava lisinemo bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Niga lavedi vaitedi ke miya te laḡan faiona a kovi, bi kani geḡa aubaina te e launuwatoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bamoda ma kani pekidi yà giukamaḡedi bi sa nawa edi vanuwemo, mba etamo sa laugulibubu. Bi kota ḡesaudi manekaḡa a tava.” ");
INSERT INTO kqf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bi ena tauwaikaiwatana ai talayena gado, “Niga mutuyuwa bamo kani ta vai bi tai kanidi?” ");
INSERT INTO kqf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bi Yesu i wai talayedina gado, “Temi lisimimo buledi visa sa kenakena?” Bi tedi a giuwena gado, “Wapedi 7.” ");
INSERT INTO kqf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kamaina bi Yesu lava kumdi i giuwedi doḡamo a miya. Tana buledi 7 i tanodi bi Maimaituwa i wai ebone bi i kividi bi ena tauwaikaiwatana i vitedi, te a soiyedi. ");
INSERT INTO kqf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bi iyana visa keikeilikidi vaitedi a natomedi Yesu lisinemo bi tana Maimaituwa i wai ebone bi ena tauwaikaiwatana i giuwedi te a soiyedi. ");
INSERT INTO kqf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lava a kani te a kani nonoḡa. Bi ena tauwaikaiwatana kani pusepuselidi a laitupa bi po'a 7 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Olooloto wapedi ba 4 tausan mainana bi i giukamaḡedi te a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bi kota tana ena tauwaikaiwatana vaitedi wagamo a gelu bi a nawa Damanutamo. ");
INSERT INTO kqf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ḡome Palisi ḡesaudi Yesu laulubuna ḡaḡaluna a tava bi ai tala vitavitale te Maimaituwa ena mataila maso i wai lovedi. ");
INSERT INTO kqf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu yawasina i bunanai kamaḡe bi i giuna gado, “Temi niga kimtina bai aubaina ko ḡoeḡoe te mataila ko kita? Yà giugiu kauwemi te mote mataila yàma voiye koma kita.” ");
INSERT INTO kqf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu ena tauwaikaiwatana vaitedi Palisi a gosedi te wagamo a gelu bi a nawa noi nevanemo. ");
INSERT INTO kqf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ena tauwaikaiwatana nuwedi i kauleya te mote buledi a tano. Bi ḡemota ota wagamo ai gelu. ");
INSERT INTO kqf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu i giuvavasaḡedina gado, “Palisi bi Alodi edi mu'aa koi kita kauwe.” ");
INSERT INTO kqf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tedi taudiḡa ai talapilina gado, “Tada mote buledi ta vai aubaina te mai i giu.” ");
INSERT INTO kqf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu edi noḡota i sibe bi i giuwedina gado, “Bai aubaina ko giugiu te mote buledi ko vai? Temi mote ko kita, ee mote ko sibe? Temi yaḡolo ko wai nuwanaina? ");
INSERT INTO kqf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Temi waimatemi bi mote komai kita kauwa? Waibeyemi bi mote komai beyavaiya kauwa? Mote ko noḡoti? ");
INSERT INTO kqf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tagu buledi 5 e kividi bi lava 5 tausan a kani bi kani puselidi kona laitupa bi po'a visa konai wanavudi?” Tedi a giuna gado, “Po'a 12.” ");
INSERT INTO kqf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Bi tagu buledi 7 e kividi bi lava 4 tausan a kani bi kani puselidi kona laitupa bi po'a visa konai wanavudi?” Tedi a giuna gado, “Po'a 7.” ");
INSERT INTO kqf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bi i giuwedina gado, “Temi yaḡolo mote ko sibe?” ");
INSERT INTO kqf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tedi Betsaida malagainemo a tava bi ḡome lava edi tau matapotapotana ai doli tavaite bi Yesu ai baḡa vavasaḡe te maso matana i taukoni. ");
INSERT INTO kqf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bi tana oloto nimanemo i kaididi bi i wai doli te malagai a potiyovo kamaḡe. Ḡome Yesu oloto matana i gelolo bi nimana matanemo i sako bi i wai talayena gado, “Bai kwa kitakita ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tana matana i taulageti bi i giuna gado, “Tagu lava e kitedi sa nawanawa kitedi mai kai.” ");
INSERT INTO kqf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu nimana i sako munaḡe oloto matanemo. Maḡemota oloto matana i yana i visuvisu bi i wai kita kauwa. ");
INSERT INTO kqf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu oloto i giuwena gado, “Kwa nawa em vanuwemo, mote kuma nawa malagaimo.” ");
INSERT INTO kqf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu bi ena tauwaikaiwatana a nawa Seseliya Filipai malagaidi diyediḡa. Tedi a nawanawa etamo bi Yesu i wai talayedina gado, “Lava sa giugiu te tagu aiyai?” ");
INSERT INTO kqf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tedi a giuna gado, “Lava ḡesaudi sa giugiu te tam Diyon taukabulu, ḡesaudi Elaidiya bi ḡesaudi taugiuwatana ḡemota.” ");
INSERT INTO kqf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bi i wai tala munaḡedina gado, “Temi bainewa ko noḡonoḡoti, te tagu aiyai?” Bi Pita i giuna gado, “Tam ba Keliso Maimaituwa ena Vinevine!” ");
INSERT INTO kqf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu i giu vavasaḡedi te mote aiyai sima giuwe te tana aiyai. ");
INSERT INTO kqf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tana wai lovelovedi i waitubu bi i giuwedina gado, “Tana Taunana Natuna male kauwa wapewapedi yai nuwatoiyedi bi babada nananaka, pilisi edi babada bi waiḡake tauwailovelovena sa miya tautaulie bi tana male sai peki bi laḡan wai faioninemo ya kenamoito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu mba kauwidi i giu kaukauwedi, taunana aubaina Pita i wai doli nawe tabudimo bi i kaipasini. ");
INSERT INTO kqf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu i tauvitale bi ena tauwaikaiwatana i kitedi bi Pita lisinemo i kaipasina, “Seitani! Ku taulia muligumo. Mba noḡotidi mote Maimaituwa lisinaḡa sima yovoyovo bi lava edi noḡota mainana.” ");
INSERT INTO kqf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu lava kumna bi ena tauwaikaiwatana i yogedi a nato lisinemo bi i giuwedina gado, “Bamoda aiyai muliguḡa ya natona ba ena ḡowana matabudi sa kena bi ena kolosi ya kailageti bi ya kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lava aiyai bi ena yawasana i nuwamunaḡena ba muliḡa ya kulayakasi. Bi aiyai ena yawasana ya nuwakamaḡena tagu aubaigu bi giu visuvisuna aubaina ba muliḡa ya vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bamoda lava niga dobuna ena ḡowana matabuna i vai kovi bi ena yawasana i ka gebogebo, mba kauwidi damodimo bai visuna ya tubuḡa? ");
INSERT INTO kqf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bi kota bai mwalina ya vite bi ena yawasana ya vai munaḡe? Geḡa geḡa ota. ");
INSERT INTO kqf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lava niganana laḡannemo sa miyamiyana ba Maimaituwa giuna sa laulau kasaḡaiḡaiye bi gebo sa voivoiyena ba tedi mai lava wai matawapedi. Bi bamo te aiyai kwai tunimayaḡegu bi giugu wailovelovena kwai tunimayaḡena ba Tana Taunana Natuna Tamana namalinemo ena aneya waiyawa vaitedi ena nato munaḡemo yai tunimayaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bi Yesu i giuwedina gado, “Yà giugiu kauwemi, matabumi niganana ko miyamiyana mote koma peki kamaina eete Maimaituwa ena waibada ḡailisi vaitena ya natonatona ko kita.” ");
INSERT INTO kqf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Laḡan 6 mulidimo Yesu Pita, Diyemes bi Diyon i wai dolidi te a saḡa a nawa oya lofalofana dabanemo, ḡome tedi taudiḡa. Bi a wai kita ba Yesu kitana i nuwavitala. ");
INSERT INTO kqf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Te ena gala potipotina bi waimatakanikanina, mote aiyai dobumo gala ima koḡa bi mainana kitana ima tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kamaina bi ena tauwaikaiwatana faiona a kita te Mousis bi Elaidiya a laumaḡata bi Yesu vaitena a wai giugiu. ");
INSERT INTO kqf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita Yesu i giuwena gado, “Tauwailovelove i visu te tama niga ḡome. Tama kape faiona ka voiyedi, ḡemota tam, ḡemota Mousis bi ḡemota Elaidiya.” ");
INSERT INTO kqf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tedi a tava bi a naila gulata bi Pita mote bai i sibe taunana aubaina i giu yabayababa. ");
INSERT INTO kqf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kamaina bi giyou i laumaḡata bi i suma tawedi bi kalina dididigina giyouḡa i yovona gado, “Niga taunana tagu Natugu, nuwagu taulaukwasilina. Koi beyavaiye kauwe!” ");
INSERT INTO kqf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Noi taunana a tautauvitaledi te mote aiyai a kita bi Yesu taunaḡa i moimoito. ");
INSERT INTO kqf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sauginemo oyamo a miyamiya kuluva ba Yesu i giu vavasaḡedi te bai i tubutubuḡana mote aiyai ḡesau sima giuwe, eete Tana Taunana Natuna pekimo ya kena moito. ");
INSERT INTO kqf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tedi ena giu a kaiwata bi taudiḡa niga kauwina a wai giugiuwe te pekimo kenamoito banina bai. ");
INSERT INTO kqf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bi Yesu ai talayena gado, “Bai aubaina waiḡake tauwailovelovena sa giugiu te Elaidiya ya gei tava?” ");
INSERT INTO kqf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu i giuna gado, “Mba giu kauwa, Elaidiya kaka ya gei tava bi bai matabuna ya kadidimani. Bi kota bai aubaina gilugilumina wadubonemo i giu te Tana Taunana Natuna kaka sa daboke bi yai nuwatoi gulata. ");
INSERT INTO kqf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yà giugiuwemi te Elaidiya kaikana i tava bi lava edi ḡowana lisinemo a noḡonoḡotina a voiye, maibena gilugilumina wadubonemo i giugiu watana mainana.” ");
INSERT INTO kqf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu bi ena tauwaikaiwatana faiona oyamo bi a yovo munaḡa tauwaikaiwatana ḡesaudi lisidimo. Bi a kita te lava kumna tedi a dubutawidi bi waiḡake tauwailovelovena vaitedi a waikagiu. ");
INSERT INTO kqf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sauginemo lava Yesu a kitakita ba a tagugu bi a velau waiyebone aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tana ena tauwaikaiwatana i waitalayedina gado, “Bai kona waikagiuwe?” ");
INSERT INTO kqf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lava kumna nopodimo oloto i giuna gado, “Tauwailovelove, natugu e natomena lisimmo, tana aluwa gebogebona i suneḡi bi i voiye te mote ima giugiu. ");
INSERT INTO kqf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sauginemo aluwa gebogebona gomana i sulusuluvai ba ya pwalapwalaḡena doḡamo. Bi mwakana ya sana waikikokikodi bi kasapula gayanaḡa sa yovoyovo bi tunina sa badobado. Taunana aubaina te em tauwaikaiwatana e giuwedi te aluwa gebogebona maso a kwavi vai bi geḡa mote a voiye.” ");
INSERT INTO kqf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu i giuwedina gado, “Ei, temi mote koma wai sumaḡa! Vaitemi te alamiya! Yaḡolo te emi vita yà ava'avali? Gomenina ko natome lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tedi gomana a nawe Yesu lisinemo. Noi taunana aluwa gebogebona Yesu i kitakita ba gomana i katititi te i kuluva doḡamo i talaḡa bi i wai kuikuileva bi kasapulana gayanaḡa a yovoyovo. ");
INSERT INTO kqf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu gomana tamana i waitalayena gado, “Niga ena sidana i vaina bainewa lofana?” Bi tana i giuna gado, “Wala ma ḡaubonemo te niganana. ");
INSERT INTO kqf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bi laḡan wapawapa aluwa gebogebona gomana kaimo bi gaubemo i pwalaḡe nawe te maso i wai peki. Bamo te tam ḡemoḡemotim, te kwa launuwatoiyemai bi kwa sagumai.” ");
INSERT INTO kqf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu i giuwena gado, “Bamo te tam ḡemoḡemotim? Aiyai ya waisumaḡana ba Maimaituwa ḡemoḡemotina bai matabuna tana aubaina ya voiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Noi taunana te gomana tamana i kaiḡabalana gado, “Aee, yà waisumaḡa bi egu sumaḡa mote i didiga. Kwa sagugu te egu sumaḡa ya didiga!” ");
INSERT INTO kqf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu i kita te lava kumna a tavatava taunana aubaina Yesu aluwa gebogebona i giuwena gado, “Tam beyapotapota bi gumgum aluwina yà kwavikwavim te noi taunana gomana kwa gose kamaḡe, mote kuma saḡa munaḡa gomana noponemo!” ");
INSERT INTO kqf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aluwa gebogebona gomana i ka binabinau bi i katititi bi i potiyovo kamaḡe. Bi gomana kitana mai lava pekipekina bi lava wapewapedi ḡome a giuna gado, “Gomana i peki.” ");
INSERT INTO kqf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bi Yesu gomana nimanemo i kabi, bi i solu waimoito. ");
INSERT INTO kqf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muliḡa Yesu i nawa vanuwa noponemo bi ḡome tedi taudiḡa bi ena tauwaikaiwatana ai talayena gado, “Bai aubaina te tama mote aluwa gebogebona ke kwavi vai?” ");
INSERT INTO kqf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bi Yesu i giuwedina gado, “Niga mai aluwina ba pali taunaḡa kaka ya kwavi vai, mote bai ḡesauna.” ");
INSERT INTO kqf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu bi ena tauwaikaiwatana mba modomodona a ḡose bi Galili noponaḡa a nawa. Yesu mote i ḡoe te aiyai ḡesau ya sibe te tana ḡome, ");
INSERT INTO kqf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","banina tana ena tauwaikaiwatana i wailovelovedi bi i giuwedina gado, “Tana Taunana Natuna kaka sa kaisoluḡe, lava nimedimo sa sako bi sai peki. Bi laḡan wai faioninemo ya kenamoito.” ");
INSERT INTO kqf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tana mba mainana giuna i vatovatona ba tedi banina mote a sibe. Bi a naila aubaina te mote ai talaye. ");
INSERT INTO kqf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu bi ena tauwaikaiwatana Kapeniammo a tava. Bi a valageta vanuwemo bi i waitalayedina gado, “Temi etamo bai konai kagiuwe?” ");
INSERT INTO kqf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tedi a miya moimoisili bi mote bai a giuwe banina tedi etamo taudiḡa a waikagiu te aiyai i saḡa gulata. ");
INSERT INTO kqf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tana i miyatulu bi ena tauwaikaiwatana 12 i giuwedi a nato ai ḡemotidi bi i giuwedina gado, “Aiyai bi doli i ḡoena ba ya sakoyovoḡe munaḡe bi lava matabudi aubaidi yai taupaula.” ");
INSERT INTO kqf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu gomana i natome mododimo i wai moito bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aiyai isagumo bi gomana ḡaubona i giuvai maibena niga gomenina ba tagu ya giugiuvaigu. Bi kota aiyai tagu ya giugiuvaiguna ba tana mote tagu tauguḡa ima giugiuvaigu bi taugiukamaḡegu vaitena ya giugiuvai.” ");
INSERT INTO kqf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Diyon Yesu i giuwena gado, “Tauwailovelove, tama oloto ḡemota ke kita isammo aluwa gebogebodi i kwavikwavivaidi. Tana mote tada nopodemo, taunana aubaina kei ḡake te mote ima voiye munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu i giuwedina gado, “Mote komai ḡake, lava aiyai isagumo anisove kauwidi ya voivoiyedina ba muliḡa mote isagu ima kagebogebo. ");
INSERT INTO kqf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lava aiyai bi mote imai ḡaviyeda ba lavana eda tau. ");
INSERT INTO kqf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yà giugiu kauwemi te lava aiyai gauba i yaai bi i vitemina banina temi tagu taukaiwatagu ba ena maii'a kaka ya vai.” ");
INSERT INTO kqf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Bamo te niga libilibidi mododimo gomana ḡaubona ḡemota i waisumaḡegu bi aiyai i voiye wapa bi gebomo i kuluvana ba i visu te lavana gadonemo ḡakima dididiga sa duli bi nisamo sa pwalaḡe nawe. ");
INSERT INTO kqf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Bamo te nimam i voiyem bi gebomo kuna kuluvana ba kwa koiḡavuki. I visu te nimam ḡemota bi kwa saḡa yawasanamo. Kaka nimam labu bi kwa nawana iyoyoḡamo, ḡome kai kalakalatina bamo mote ena ani kalapeki. ");
INSERT INTO kqf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Bamo te kaḡem i voiyem bi gebomo kuna kuluvana ba kwa koi ḡavuki. I visu te kaḡem ḡemota bi kwa saḡa yawasanamo. Kaka kaḡem labu sa voiyem te kwa nawana iyoyoḡamo. ");
INSERT INTO kqf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bamo te matam i voiyem bi gebomo kuna kuluvana ba kwa ḡivoi kamaḡe. I visu te matam ḡemota bi Maimaituwa ena waibadamo kwa saḡa. Kaka matam labu sa voiyem te kwa nawana iyoyoḡamo. ");
INSERT INTO kqf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mba ḡome mwatamwata lava sa kanikanidi bamo mote edi anipeki bi kaina mote bamo ena ani kalapeki. ");
INSERT INTO kqf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Taukaiwatagu matabudi kaka pilipili sa banavidi bi pilipilidi mayavaidi mai kai poyana, mba etanemo kaka sa ḡailisi. ");
INSERT INTO kqf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Soliti ba mwali visuvisuna bi bamo te dinina i kovina ba bainewa ko voiye bi ya dini munaḡa? Temi ko wai kagiuna didiga aubaina, mba temi mai soliti dinimi i kovi. Temi emi yawasana maso maibena kani solisolitina dinina. Temi maso mainana nuwavisumo emi lava vaitedi kona miya.” ");
INSERT INTO kqf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu mba dobuna i ḡose bi i nawa Diudiya bi Dioudan gaubina i damaniye noi nevanemo. Bi ḡome lava kumna a tava munaḡa bi i wai lovelovedi, maibena sauga matabuna i voivoiyena mainana. ");
INSERT INTO kqf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Palisi ḡesaudi Yesu wai laulubuna a ḡoe aubaina te a nato lisinemo bi ai talayena gado, “Eda waiḡake i waianine ee geḡa, te oloto mwanena ya gose?” ");
INSERT INTO kqf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bi Yesu waitalamo i giuwedina gado, “Mousis waiḡake i vitevitemina bainewa i giu?” ");
INSERT INTO kqf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tedi a giuwena gado, “Mousis ena waiḡake i waianina te oloto waiḡose pepana ya gilumi mwanena ya vite kaka ya giukamaḡe te ya nawa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kamaina bi Yesu i giuwedina gado, “Banina temi nopomi a ḡaiḡai taunana aubaimi Mousis mba waiḡakena aubaina i gilumi. ");
INSERT INTO kqf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bi ko noḡoti, Maimaituwa wala pakanemo dobu i voivoiye sauginemo, tana lava i voiyedi, oloto bi waivini. ");
INSERT INTO kqf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Taunana aubaina oloto tamana bi tinana ya gosedi bi mwanena vaitena sa miya ḡemota, ");
INSERT INTO kqf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bi tedi labuidi tubuḡa ḡemota sa tubuḡa. Niganana tedi mote labu bi ḡemota. ");
INSERT INTO kqf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taunana aubaina Maimaituwa tedi i wai ḡemotidina mote lava i mai dabalalidi.” ");
INSERT INTO kqf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muliḡa a munaḡa vanuwemo bi Yesu ena tauwaikaiwatana niḡa giuna aubaina ai talaye. ");
INSERT INTO kqf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kamaina bi tana i giuwedina gado, “Bamoda oloto waivini i gose bi waivini ḡesau i naḡina ba mwanena ya vavawaidoḡa. ");
INSERT INTO kqf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kota mainana, waivini ena oloto i gose bi oloto ḡesau i naḡina ba mwanena ya vavawaidoḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lava ḡesaudi libilibi keikeilikidi a natomedi Yesu lisinemo te tana maso nimana dabedimo i sivudi bi geḡa te ena tauwaikaiwatana lava ai ḡakedi. ");
INSERT INTO kqf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu mainana i kitakita ba ena tauwaikaiwatana lisidimo nuwana i medi bi i giuwedina gado, “Libilibi koi aninedi sa nato lisigumo mote komai ḡakedi banina Maimaituwa ena waibada lava lisidimo maibena niga libilibidi. ");
INSERT INTO kqf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yà giugiu kauwemi te aiyai mote Maimaituwa ena waibada i mai anine bi ima vai, maibena libilibi keikeilikidi edi yawasana. Ba tana kaka mote Maimaituwa ena waibada noponemo ima sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kamaina bi libilibi i bewedi kalonemo i sivudi bi nimana dabedimo i sivudi bi i laupali, te Maimaituwa ya kavisuvisudi. ");
INSERT INTO kqf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bi Yesu i modina i nawanawa etamo ba oloto i velau i tava Yesu matanemo bi tuwapekana doḡamo i wai tupagwaliye. Bi i giuwena gado, “Tauwailovelove visuvisum bai yà voiye bi yawasana ilailalana yà vai?” ");
INSERT INTO kqf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bi Yesu oloto i giuwena gado, “Bai aubaina kuna giu te visuvisugu? Aiyai mote i visu, Maimaituwa taunaḡa i visu. ");
INSERT INTO kqf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tam waiḡake kuna sibedi: Mote kumai peki, mote mwanem kuma vawaidoḡa, mote kuma danene, lava mote kaiyovumo kumai wavu, mote kuma soinuwava, tamam bi tinam kwa viviledi.” ");
INSERT INTO kqf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bi oloto i giuwena gado, “Tauwailovelove, tagu ḡaubogumo te niganana mba waiḡakedi matabudi e voiye kovidi.” ");
INSERT INTO kqf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Bi Yesu oloto i kita te nuwana i vai bi i giuwena gado, “Mwali ḡemota kwa malumaluwabiye. Kwa nawa em waiguyau matabuna kwa kune kamaḡedi bi mane waiyamoyamonidi kwa vitedi bi mala ena waiguyau kwa vai. Kaka kwa nato te kwa kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Niga olotona ba i wai ḡonaḡona gulata, taunana aubaina Yesu ena giu i vaivaiye ba nuwana i kuluva bi ma nuwaboyana i nawa. ");
INSERT INTO kqf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ḡome ena tauwaikaiwatana i kita nawedi bi i giuwedina gado, “I bagibagi kauwa kaka tana waiwaiguyauna Maimaituwa ena waibada noponemo ya sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tauwaikaiwatana Yesu ena giu a vaivaiye ba a tagugu. Bi Yesu i giuwedina gado, “Libilibi, i bagibagi kauwa kaka lava waiguyauna Maimaituwa ena waibada noponemo ya sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I pilipili kauwa kaka ḡamoḡamo dididiga kamelo, siyau bwadanemo ya sola, mba mainana kota lava waiguyauna mote Maimaituwa ena waibada noponemo ima sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ḡome ena tauwaikaiwatana mba giuna a vaivaiyena ba a tatava gulata bi edi lava vaitedi ai talapilina gado, “Bamoda mainana, ba aiyai kaka bena ya yawasana?” ");
INSERT INTO kqf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu i kitedi bi i giuwedina gado, “Lava lisidimo ba i pilipili kauwa te taudiḡa sai yawasanidi bi Maimaituwa lisinemo bai matabuna ba ḡemoḡemotina ya voiye.” ");
INSERT INTO kqf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kamaina bi Pita i giuna gado, “Bi tama bainewa? Tama kaikana bai matabudi ke ḡosedi kamaḡedi bi ke kaiwatam.” ");
INSERT INTO kqf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu i giuwedina gado, “Yà giugiu kauwemi, aiyai ena vanuwa ee tinatinanatuna ee nuvunuvuna ee valevaletina ee tinana bi tamana, ee natunatuna bi ena daibi ya gosedi bi tagu ya kaiwatagu bi lava ḡesaudi lisidimo giugu visuvisuna ya giunawena, ");
INSERT INTO kqf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mba sauginemo tana mai'a dididiga otina Maimaituwa ya vite: Ena vanuwa, valevaletina, nuvunuvuna, tinatinana, natunatuna bi daibi sa wapa. Bi kota lava sa laukivigebogeboye. Bi laḡan muliḡa ya natonatona tana yawasana ilailala ya vai. ");
INSERT INTO kqf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lava wapewapedi mabai niganana sa wailaumatanana kaka sai laumuli bi mabai sa wailaumulina ba sai laumatana.” ");
INSERT INTO kqf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tedi etaḡa a nawanawa Yelusalem bi Yesu eta i dolidoliye. Bi ena tauwaikaiwatana a tagugu bi lava ḡesaudi a kaikaiwatedina a naila. Yesu ena tauwaikaiwatana vaitedi a moito gebi tabudimo bi lisinemo bai matabudi sa tubuḡana ena tauwaikaiwatana i tainuwataudina gado, ");
INSERT INTO kqf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ko vaiye, niganana ta nawanawa Yelusalem, bi ḡome taukaisolu kaka Tana Taunana Natuna pilisi edi babada bi waiḡake tauwailovelovena babadidi nimedimo ya sako. Tedi sa etale bi sai anine te Loum lavedi nimedimo sa sako te tedi sai peki. ");
INSERT INTO kqf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tedi sai gadolose, sa gelolo, sa kwapu bi sai peki bi laḡan wai faioninemo tana ya kena moito.” ");
INSERT INTO kqf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Diyebedi natunatuna Diyemes bi Diyon a tava Yesu lisinemo bi a giuwena gado, “Tauwailovelove, tama ka ḡoeḡoena bai kai baḡamna ba ema ḡowana kwa voiye.” ");
INSERT INTO kqf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu i waitalayedina gado, “Bai mwalina ko ḡoeḡoena aubaimi yà voiye?” ");
INSERT INTO kqf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tedi ena giu ai munena gado, “Kwai aninemai te aiyai kataiyammo ya miya bi aiyai ḡeniyammo ya miya em waibada laḡannemo.” ");
INSERT INTO kqf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu i giuwedina gado, “Temi mote ko sibe te bai ko waibaḡae. Temi ḡemoḡemotina wainuwatoi leduna yà tegona mainana ko tego? Ee yà buluna mainana ko bulu?” ");
INSERT INTO kqf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tedi ena giu ai munena gado, “Tama ḡemoḡemotimai.” Kamaina bi Yesu i giuwedina gado, “Temi ḡolaḡolana yà tegona mainana temi ko tego bi yà pekina mainana ko peki.” Bi Yesu i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Kamaina bi tagu mote egu waibada ima kenakena te yà lauvina, te aiyai kataiyagumo bi aiyai ḡeniyagumo. Niga gabuna tedi mabai Maimaituwa i vinevinedina aubaidi i kanonoḡi.” ");
INSERT INTO kqf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tauwaikaiwatana 10 mainana giuna a vaivaiyena, ba tedi Diyemes bi Diyon lisidimo a medi. ");
INSERT INTO kqf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu matabudi i yogedi bi i giuwedina gado, “Kona sibe tedi mabai Eteni sa wai badaedina ba lisidimo sa wai bada teyala. ");
INSERT INTO kqf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Temi mote maso mai ko voiye, aiyai didiga i ḡoena ba ya sako yovoḡe munaḡe bi aubaimi yai taupaula. ");
INSERT INTO kqf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aiyai bi doli i ḡoena ba ya sako yovoḡe munaḡe bi lava ḡesaudi aubaidi yai taupaula yababa. ");
INSERT INTO kqf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mainana Tana Taunana Natuna i yovona mote lava aubaina si paula bi tana lava aubaidi i paula bi ena yawasana i vite munaḡe te lava wapewapedi i wai yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu ena taukaiwatana vaitedi a tava Deliko malagainemo. Ḡome ena tauwaikaiwatana bi lava kumna dididiga vaitedi Deliko a gosegose ba oloto matapotapotana isana Batimiyas tana eta diyanemo i miya bi i waiwaigigimana, Batimiyas tana Timiyas natuna. ");
INSERT INTO kqf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sauginemo tana Nasalet Yesuna giuna i vaivaiye ba binau i waitubuna gado, “Yesu Deivida Natuna kwa lau nuwatoitoiyegu!” ");
INSERT INTO kqf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lava wapewapedi ḡome Batimiyas a kaipasine, “Ku miya moimoisili!” Bi tana yaḡolo te kalinana dididiginemo i binabinau gado, “Deivida Natuna kwa lau nuwatoitoiyegu!” ");
INSERT INTO kqf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kamaina bi Yesu i vamoito bi lava i giuwedina gado, “Ko giuwe ya saḡa niga ḡome.” Tedi oloto matapotapotana a giuwena gado, “Ya yogeyogem, ma nuwavisum kwa moito bi kwa nawa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kamaina bi tana ena kwama i ḡiḡi, i pwalaḡe kamaḡe, i laupotisaḡa bi i nato Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ḡome Yesu Batimiyas i waitalayena gado, “Bai kwa ḡoeḡoena aubaim yà voiye?” Kamaina bi oloto mata potapotana i giuwena gado, “Tauwailovelove, tagu ya ḡoeḡoena yai kita munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu i giuwena gado “Kwa nawa em sumaḡa i wai yawasanim.” Noi taunana te oloto matana i yana bi Yesu i kaiwata te etaḡa a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu bi ena tauwaikaiwatana oya Olip diyanemo malagai Betpage bi Betenimo a tava, Yelusalem a vavawaiḡeleḡele. Bi Yesu ena tauwaikaiwatana labu i giukamaḡedi a doli, ");
INSERT INTO kqf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","bi i giuwedina gado, “Ko nawa Yelusalem malagainemo bi sauginemo ḡome kona tavana ba donki lauewalina waitamina ko kita, mote aiyai i geluwe, temi ko kuvesi bi ko natome. ");
INSERT INTO kqf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bi aiyai yai talayemina gado, ‘Bai aubaina niga mai ko voivoiye?’ Ba temi tana ko giuwena gado, ‘Bada ya ḡoeḡoe bi mote lofana te ya munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tedi a nawa malagaimo a tava bi eta diyanemo vanuwa mataetinemo donki lauewalina waitamina a kita i moimoito, kamaina bi a kuvesi. ");
INSERT INTO kqf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ḡome lava ḡesaudi diyanemo a moimoitona ai talayedina gado, “Bai aubaina mba donkina ko kuvekuvesi?” ");
INSERT INTO kqf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kamaina bi tedi Yesu bai i giugiuwedina mainana a giuwedi. Ḡome te ai aninedi bi donki ai doli nawe. ");
INSERT INTO kqf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tedi donki ai doli nawe Yesu lisinemo bi edi kwama a ḡiḡikamaḡedi te donki dabanemo a yesidi bi dabedimo Yesu i miya. ");
INSERT INTO kqf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lava wapewapedi edi kwama etamo a yesidi bi ḡesaudi kai malugulugudi a bwalidi bi a yesi nawedi. ");
INSERT INTO kqf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lava dolidolidi bi mulimulidi a binabinauna gado, “Maimaituwa ta kasaḡesaḡe. Ka kavisuvisuna ya natonato Bada isanemo. ");
INSERT INTO kqf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ka kavisuvisuna Bada isanemo ya natonatona Deivida ena tubulelesemo Maimaituwa ta kasaḡesaḡe, noke malamo!” ");
INSERT INTO kqf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu Yelusalemmo i tava bi i nawa Maimaituwa ena vanuwemo. Ḡome bai matabuna i kita kovidi bi kaikana aubiga aubaina te ena tauwaikaiwatana 12 vaitedi a nawa Betenimo. ");
INSERT INTO kqf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Laḡani i sako Beteni a gose bi a nawanawa te Yesu kani i peki. ");
INSERT INTO kqf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kamaina bi i wai kita nawa manemanekemo te kai damaya luguna i kita. Bi i nawa diyanemo te i kita kaukauwe ba votana geḡa, banina mote vota ena bolimani. ");
INSERT INTO kqf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu kai damaya i pasilina gado, “Mote aiyai kaka votam ima kani munaḡe!” Mai i giugiu ba ena tauwaikaiwatana ena giu a vaiye. ");
INSERT INTO kqf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu ena tauwaikaiwatana vaitedi Yelusalemmo a tava bi tana i nawa Maimaituwa ena vanuwa ganakukuna noponemo. Ḡome tedi mabai a wai kunekune bi a gimagimala i kwavivaidi a potiyovo. Bi wali dobu manedi tauvitaledi bi mwanuwa gabubu a wai kunekuneyedina edi bena bi edi animiya i vitaledi. ");
INSERT INTO kqf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bi lava i waiḡakedi te waikunekune mwalidi mote sima avala bi Maimaituwa ena vanuwa ganakukuna noponaḡa sima nawa. ");
INSERT INTO kqf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bi tana lava i wailovelovedi bi i giuwedina gado, “Gilugilumina wadubonemo Maimaituwa i giuna gado, ‘Tagu egu vanuwa sai isana pali vanuwina lava dobu matabuna aubaidi.’ Bi temi kona voiye te maibena ‘taudanedanene edi gabu.’” ");
INSERT INTO kqf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pilisi edi babada bi waiḡake tauwailovelovena niga giuna a vaiye bi eta a tavutavu te bainewa maso Yesu ai peki. Bi geḡa te a naile banina lava kumna ena wailovelove a sovesoveye. ");
INSERT INTO kqf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kamaina bi suwala bulubulumo Yesu ena tauwaikaiwatana vaitedi Yelusalem a gose bi a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malaboiboi ḡesaunemo tedi a munamunaḡa, mba kaina a kita i poki pakanemo te damonemo. ");
INSERT INTO kqf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ḡome tedi kai a kitakita ba Pita Yesu ena giu i noḡoti bi i giuna gado, “Tauwailovelove kwa kita, damaya kaina kuna pasipasilina i poki.” ");
INSERT INTO kqf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu edi giu i waimunena gado, “Emi waisumaḡa Maimaituwa lisinemo ko sako. ");
INSERT INTO kqf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Giukauwemo yà giugiuwemi, aiyai niga oyana ya giuwena gado, ‘Ku pwalaḡe nawem nisamo.’ Bi tana noponemo mote ima nuwalaḡalaḡa bi yai sumaḡa te bai i giugiuwena ba aubaina ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Taunana aubaina yà giugiuwemi te bai palimo ko wai baḡaena ba koi sumaḡa te kona banavi, bi mba temi emiya. ");
INSERT INTO kqf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Bi laḡannemo ko laulaupalina ba dolina tedi mabai gebogebo lisimimo a voivoiyena, ko noḡoti kamaḡedi, mainana kaka Tamemi malamo emi gebogebo ya noḡoti kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tedi a tava munaḡa Yelusalemmo bi Yesu, Maimaituwa ena vanuwa didiyaunaḡa i nawanawa. Pilisi edi babada, waiḡake tauwailovelovena bi Diu babadidi a tava Yesu lisinemo ");
INSERT INTO kqf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bi ai talayena gado, “Tam waibada bamo kuna vai bi niga kauwidi kwa voivoiyedi? Em waibada aiyai i vitem?” ");
INSERT INTO kqf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kamaina bi Yesu edi giu i wai munena gado, “Waitala ḡemota yài talayemi bi giu koi mune kaka yà giuwemi te bamo tagu waibada e vai bi niga kauwidi yà voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko giuwegu, aiyai Diyon waibadana i vite bi i laulaukabulu? Maimaituwa i vite ee lava dobumo?” ");
INSERT INTO kqf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tedi taudiḡa ai talapilina gado, “Bamoda ta giuna gado, Malaḡa, ba tana ya giuna gado, ‘Bai aubaina mote koi sumaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bi bamoda ta giuna gado, ‘Lava lisidiḡa, ba sa ḡasiyeda.” Tedi a nailana banina lava matabudi a sibe, te Diyon tana kamaina te taugiuwatana. ");
INSERT INTO kqf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Taunana aubaina ena giu ai munena gado, “Tama mote ka sibe.” Bi Yesu i giuwedina gado, “Tagu kota mote yàma giuwemi te egu waibada bamo e vai bi niga kauwidi yà voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kamaina bi Yesu lautaulalamo giuwedi i waitubuna gado, “Oloto waen daibina i wadi bi i ganakuku. Bi kota waen aniva pisana i voiye bi ani waikoyaḡa vadavadana i keli. Kamaina bi taubayau i tanodi te waen daibinemo i waidubudi. Bi tana i nawa dobu ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vililubu laḡannemo tana taupaula i giukamaḡe waen daibina taulabena lisidimo te waen votedi ḡesaudi maso i laitupa. ");
INSERT INTO kqf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bi geḡa te taubayau taupaula a kaididi, a kwapu bi a giukamaḡe kavakavana i munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bi kota taniwaga taupaula ḡesau i giukamaḡe lisidimo bi tedi kununa a dougolu bi a voiye te i wai tunimayaḡa. ");
INSERT INTO kqf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Daibi taniwagina taupaula ḡesau i giukamaḡe bi tedi tana ai peki. Bi kota wapewapedi mainana a voiyedi, a kwapudi bi ai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Niganana ḡemota ota ya miyamiya, taniwaga natuotina nuwapouna. Muliḡa tana natuotina i giukamaḡe bi i giuna gado, ‘Tedi male natugu sa vivile.’ ");
INSERT INTO kqf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Bi geḡa te taubayau taudiḡa ai giugiuna gado, ‘Niga olotona male tamana gagasina matabudi ya tanodi. Ei, ko nato ta lai peki bi gagasa matabuna tada ta vai.’ ");
INSERT INTO kqf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kamaina bi tedi a kaididi, ai peki bi waen daibina mulitaulinemo a pwalaḡe nawe.” ");
INSERT INTO kqf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu ena giu i waikovi bi i wai talayedina gado, “Daibi taniwagina bai ya voiye? Tana kaka ya tava bi taubayau yai pekidi bi waen daibina lava ḡesaudi ya vitedi. ");
INSERT INTO kqf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Temi gilugilumina wadubonemo kona iyevi ee geḡa? Mba niga mainana i giu, ‘Vanuwa taukelina duḡu a dabodabokena, i nuwavitala te duḡu laukaina vanuwa yasina i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bada, niga kauwina i voiye te kitana lisidemo i visu gulata.’” ");
INSERT INTO kqf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ḡome Diu babadidi eta a tavutavuḡe te maso a pani, banina a sibe te tana lautaulalamo i giugiu watedi bi geḡa te tedi lava kumna a nailedi. Kamaina bi a kita kamaḡe te i nawa. ");
INSERT INTO kqf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lautaulala mulinemo Palisi ḡesaudi bi Alodi ena muli a giukamaḡedi Yesu lisinemo te ena giumo maso ai wavu. ");
INSERT INTO kqf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bi tedi a tava lisinemo bi a giuwena gado, “Tauwailovelove, ke sibe te tam ba giukauwa kwa giugiuwe, te lava bai sa giugiuwena mote kuma nainaile. Tam lava isanawenawedi edi giu mote kuma iyeiyevidi bi em wailovelove ba Maimaituwa ena ḡowana bi giukauwa lava kwa wailovelovedi. Kwa giuwemai, kamaina te takis kai maii Sisa lisinemo ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu edi kaiyovu i sibe bi i giuwedina gado, “Bai aubaina, ko ḡoeḡoe te ko taikulugu? Kaikaiyovumi? Mane ko natome bi yà kita.” ");
INSERT INTO kqf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kamaina bi mane a natome bi i giuwedina gado, “Aiyai isana bi kununa aluwina manemo?” Bi a giuwena gado, “Ḡalibona Sisa aluwina bi isana.” ");
INSERT INTO kqf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kamaina bi Yesu i giuwedina gado, “Bai Sisa enaya ba Sisa ko vite bi bai Maimaituwa enaya ba Maimaituwa ko vite.” Ḡome tana ena giu a soveye. ");
INSERT INTO kqf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadisi ai sumaḡa te lava pekipekidi mote sima kenamoito. Taunana waitalana aubaina a tava Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Bi tedi a giuna gado, “Tauwailovelove, Mousis, Maimaituwa enai ḡake aubaimai i gilumina gado, ‘Bamoda oloto tinanatuna mwanena i peki kamaḡe bi natunatuna geḡa ba kota tinanatuna iwapena ya naḡi. Bi yai natuna te tuwaḡana pekipekina aubaina.’ ");
INSERT INTO kqf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mai maso olooloto 7 bi tautuweḡina i naḡi te i peki bi natunatuna geḡa. ");
INSERT INTO kqf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wai labuna iwapena i naḡi bi kota i peki, natunatuna geḡa. Mainana wai faionina vaitena. ");
INSERT INTO kqf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mba olotodi wapedi 7 waivinina a naḡi bi kauwina ḡemotina lisidimo i tubuḡa bi a peki kovi mote natunatudi bi waivini muliḡa i peki. ");
INSERT INTO kqf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kenamoito sauginemo male aiyai mwanena mba waivinina, oloto wapedi 7 a naḡinaḡina?” ");
INSERT INTO kqf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bi Yesu i giuwedina gado, “Temi kona ai giugiu, gilugilumina wadubonemo Maimaituwa ena giu kona iyevi bi mote ko sibe, kota ena ḡailisi mote ko sibe. ");
INSERT INTO kqf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Laḡannemo pekipekidi sa kenamoitona ba mote sima naḡi. Tedi sa miyana mai aneya malamo. ");
INSERT INTO kqf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bi pekimo kenamoito ena giu Mousis i gilugilumina mote ko iyevi? Wala kai tombolunemo, kai vavavanina noponemo Maimaituwa, Mousis i giuwena gado, ‘Tagu Eiblaḡam ena Maimaituwa, Aisik ena Maimaituwa bi Deikap ena Maimaituwa.’ ");
INSERT INTO kqf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tana mote lava pekipekidi edi Maimaituwa bi lava miyemiyedi edi Maimaituwa. Temi ba ko giugiu yabayababa.” ");
INSERT INTO kqf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Waiḡake tauwailovelovena ḡome i vaiyedi a waitalapilina gado. Tana i sibe te Yesu i giukauwa, kamaina bi i waitalayena gado, “Waiḡake matabudi mododimo bamo taunana waiḡake laukaina?” ");
INSERT INTO kqf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ena giu i waimunena gado, “Waiḡake laukaina ba niḡa, ‘Ko vaiye Islael, Bada eda Maimaituwa taunaḡa Bada. ");
INSERT INTO kqf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bada em Maimaituwa kwa ḡoena, mba nuwapoum tabutabunemo, tubuḡim tabutabunemo, em noḡota tabutabunemo bi em ḡailisi tabutabunemo.’ ");
INSERT INTO kqf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Waiḡake wai labuna ba niga, ‘Lava ḡesauna kwa ḡoena mai bainewa taumḡa kwa ḡoeḡoemna. Bamo mote waiḡake ḡesau i didiga gulata kaka niga taudidi.” ");
INSERT INTO kqf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kamaina bi waiḡake tauwailovelovena Yesu i giuwena gado, “Bai kuna giuwena ba i visu. Giukauwa te Bada tana Maimaituwa bi diyanemo mote bamo Maimaituwa ḡesau. ");
INSERT INTO kqf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bi lava maso Bada edi Maimaituwa a ḡoena, nuwapoudi tabutabunemo, tubuḡidi tabutabunemo, edi noḡota tabutabunemo bi edi ḡailisi tabutabunemo. Bi lava ḡesaudi ḡoedi, i saḡa gulatana kaka sewasewa gabugabu ḡosedi Maimaituwa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu i vaiye te niga olotona ena giu i visu. Kamaina bi i giuwena gado, “Maimaituwa ena waibadana ḡotona te kwa banavi.” Niga mulinemo lava matabudi a naila bi aiyai mote Yesu i waitala munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu Maimaituwa ena vanuwemo i wailovelove bi i waitalana gado, “Bainewa te waiḡake tauwailovelovena sa giugiu te Keliso ba Deivida ena tubulelesemo? ");
INSERT INTO kqf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aluwa Waiyawa noḡota Deivida i vite te i giuna gado, ‘Bada egu Bada i giuwena gado, “Niga ḡome kataiyagumo kwa miyamiya eete em ḡaviya kaḡem dibunemo yài dubudi.” ’ ");
INSERT INTO kqf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivida otina i giuna gado, Bada. Bi bainewa te Vinevinena maso Deivida ena tubulelesemo?” Lava kumna dididiga Yesu ena giu a vaivaiye ba ai nuwavisu. ");
INSERT INTO kqf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu i wailovelovedi bi i giuna gado, “Waiḡake tauwailovelovena ko kita kauwedi. Tedi gala lofelofedi sa kotedi bi ani waiḡemota gabudiḡa sa moimoito nawa te lava maso sai ebonedi vivila vaitena. ");
INSERT INTO kqf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tedi sa ḡoeḡoena ani miya visuvisudimo sa miya aniwai bolu vanuwidimo bi mata'asimo. ");
INSERT INTO kqf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tedi iwape sa kaiyovuḡedi, edi ḡonaḡona sa legaudi bi lisidimo sawai bada teyala. Bi kota pali lofelofedi sa voivoiyedi, te maso lava sa sovedi. Niga lavedi muliḡa edi kovoḡa dididigi otina sa vai.” ");
INSERT INTO kqf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maimaituwa ena vanuwa didiyaunemo, Yesu mane abomina diyanemo i miya bi lava i kitedi abomemo mane a sivusivudi. Lava waiguyaudi wapewapedi mane nananakidi a sivusivudi. ");
INSERT INTO kqf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bi kota iwape wai nuwatoitoina i tava bi peni labu i sivu, mba penidi labu ba laḡan ḡemota ani gimala luvana. ");
INSERT INTO kqf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu ena tauwaikaiwatana i yogedi ai ḡemotidi bi i giuwedina gado, “Yà giugiu kauwemi te niga iwapena ena puyo i sakona ba i didiga gulatana kaka lava waiguyaudi. ");
INSERT INTO kqf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bai aubaina tedi wai guyaudi edi mane nananakidi a kenakena bi keikeilikidi a sivusivudi. Bi niga iwapena waiyamoyamonina kanaya ani gimelina bi geḡa te matabuna i sako kovi.” ");
INSERT INTO kqf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ḡome Yesu Maimaituwa ena vanuwa waiyawa i gosegose bi ena tauwaikaiwatana ḡemota i giuwena gado, “Tauwailovelove, kwa kita niga vanuwidi kitedi a visu gulata bi kota ḡakima nananakidi a laukeliyedi.” ");
INSERT INTO kqf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu giu i waimunena gado, “Niga vanuwidi nananakidi ko kitekitedina, mote kaka ḡakima ḡemota ena gabumo ima kena, matabudi kaka sa ḡima wai dabalalidi.” ");
INSERT INTO kqf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu oya Olip dabanemo i miya bi matana Maimaituwa ena vanuwa waiyawa yawaninaḡa i waikita nawa. Kamaina bi Pita, Diyemes, Diyon bi Endulu taudiḡa a tava Yesu lisinemo bi ai talayena gado, ");
INSERT INTO kqf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kwa giuwemai te bai laḡannemo niga kauwidi sa tubuḡa? Bi bai matailina ka kita bi ka sibe te mba kauwidi ḡotona te sa tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bi Yesu i giuwedina gado, “Koi kita kauwa te mote aiyai ima kaiyovuḡemi. ");
INSERT INTO kqf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muliḡa male lava wapewapedi sa tava bi isagumo sa giuna gado, ‘Tagu taunana Maimaituwa ena vinevine.’ Bi lava wapewapedi sa'ai wai etadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Laḡannemo waiḡasiḡasi daguguna laulisimo bi manekemo noyana ko vaiyena ba koma naila. Niga kauwidi sa gei tubuḡa bi mba taunana mote damona. ");
INSERT INTO kqf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dam bi dam sai ḡasiḡasi bi ḡalibona falona ḡalibona vaitena sai ḡasiḡasi. Bi dobu ḡesaudiḡa yoyo bi gomala sa tubuḡa. Niga kauwidi sa tubuḡana maibena waivini bwagabwagana wainatuna yavina mayavaina mainana. ");
INSERT INTO kqf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Temi ko kita kauwa, lava male sa panimi bi sa etalemi bi bolu vanuwidimo sa kwapumi. Banina temi tagu taukaiwatagu. Temi babada bi ḡalibona matedimo ko moito bi tagu giugu ko giuwedi. ");
INSERT INTO kqf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Muliḡa kaka laḡan damona ya tavana, dolina taukaiwatagu giugu visuvisuna sa lauguguyaena dobu matabudimo. ");
INSERT INTO kqf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Bi laḡannemo sa panimi bi sa nawemi ko etalena ba mote komai nuwaboya dolidoli te bainewa ko giu. Mba laḡannemo bai Maimaituwa ya vitevitemina ko giuwe. Mba mote temi koma giugiu bi Aluwa Waiyawa noḡota ya vitemi te ko giu. ");
INSERT INTO kqf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Lava ḡesaudi sa kaisolu te tasitasidi kedi ḡaviya nimedimo sa sivudi te sai pekidi. Bi tamatama natunatudi sa kaisoluḡedi. Bi libilibi sa kaisolu te tametamedi kedi ḡaviya nimedimo sa sivudi te sai pekidi. ");
INSERT INTO kqf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bi lava matabudi sa dabokemi banina temi tagu ko waisumaḡegu. Bi aiyai i moito didina te damonemo ba ya yawasana.” ");
INSERT INTO kqf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mba laḡaninemo kauwa gebogebo otina bi wai matawalawalana, ḡome mote maso i moito bi geḡa te ya moito. (Temi tauiyava niga ḡome bai ya giugiuwena banina ko sibe kauwe.) Tedi mabai Diudiyamo sa miyamiyana sa velau sa nawa oyamo. ");
INSERT INTO kqf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bi tedi mabai vanuwa dabanemo sa miyamiyana mote sima yovo vanuwa noponemo te edi ḡonaḡona bai sima vai. ");
INSERT INTO kqf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bi kota tana aiyai daibimo mote i munaḡa vanuwemo ena gala vaina aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bi mba laḡandimo vesavesala bwagebwagedi bi vaivaisu lisidimo ba i gebo gulata! ");
INSERT INTO kqf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taunana aubaina ko laupali gulata te niga kauwidi mote bodubodu laḡandimo sima tubuḡa! ");
INSERT INTO kqf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mba laḡanidimo ba wainuwatoi dididigina ya tubuḡa, mote mai wala pakanemo Maimaituwa dobu i voivoiyena laḡannemo te niganana. Bi muliḡa mote mainana wainuwatoina ima tubuḡa munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bada ena vinevine lavedi kedinawamo aubaina te mba laḡandi i bwali wai watiyedi, bamoda geḡa, mote maso aiyai i yawasana. ");
INSERT INTO kqf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","“Mba laḡannemo bamoda aiyai ya giuna gado, ‘Kwa kita Keliso niga, ee kwa kita tana nanoi.’ Mote kumai sumaḡe. Banina Keliso kaikaiyovudi bi taugiuwatana kaikaiyovudi sa laumaḡata te mataila bi anisove kauwidi sa voiyedi te bena maso Maimaituwa ena vinevine lavedi male sa'ai waietadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Taunana aubaina koi kita kauwa mwali matabuna kaikana e giu wainonomi.” ");
INSERT INTO kqf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mba pilipilidi laḡanidi mulidimo suwala yai dudubala bi nawalai mote ima yana. ");
INSERT INTO kqf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bi kota kipola galewemo sa kuluva bi mwali sawasawamo ḡaiḡailisidi matabudi sa gusu. ");
INSERT INTO kqf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Mba laḡannemo Tana Taunana Natuna yadamo, ya laumaḡata ḡailisi vaitena bi ma namalina ya nato te lava sa kita. ");
INSERT INTO kqf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bi tana ena aneya ya giukamaḡedi te dobu matabuna sa kwaivivile. Bi ena vinevine lavedi dobu isuna bi isuna sai ḡemotidi bi kota mainana malamo.” ");
INSERT INTO kqf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Niganana kaikini yai lovelovemi, laḡannemo kai lagelagedi sa nimagala, sa kini bi lugudi sa gidagidava ba ko sibe te bodubodu laḡanina ya natonato. ");
INSERT INTO kqf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bi kota mainana temi niga kauwidi sa tubutubuḡa ba ko sibe te laḡani i watiḡe te tana ya nato munaḡa. ");
INSERT INTO kqf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Giukauwemo yà giugiuwemi, te niga kimtina sa miyamiyana mote sima peki bi niga kauwidi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mala bi dobu sa launeḡaneḡa bi giugu mote kaka ima launeḡaneḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Bada ena nato munaḡa laḡanina bi saugina mote aiyai i sibe. Mote aneya malamo, mote natuna bi tamana taunaḡa i sibe. ");
INSERT INTO kqf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Koi kita kauwa bi koi mayavai banina temi mote ko sibe te bai laḡannemo mba laḡanna ya tava. ");
INSERT INTO kqf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mba maibena oloto ena vanuwa i gose bi i nawa dobu ḡesaunemo bi ena taupaula ena vanuwa sa kitakita wata. Bi ḡemoḡemotaḡa edi noya i vitedi bi mataeta taulabena i giuwe te yai kita kauwa. ");
INSERT INTO kqf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Koi kita kauwa! Bai aubaina, mote ko sibe te bai laḡannemo vanuwa taniwagina ya tava, bamoda aubigamo ee dudubala modonemo ee kamkam ya ḡabaḡaba ee olaolalemo suwala ya lovolovotava. ");
INSERT INTO kqf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mote koma kena nuwayavuḡa bamoda yai tagugumi. ");
INSERT INTO kqf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bai yà giugiuwemina ba mainana lava ḡesaudi yà giugiuwedi: Koi kita kauwa!” ");
INSERT INTO kqf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Laḡani labu muliḡa kaka vawaitauli bi buledi tabatabana mote muu'a vaitena soina sa voiyena. Ba Pilisi edi babada bi waiḡake tauwailovelovena kandavonemo eta a tavutavu te bainewa maso Yesu a pani bi ai peki. ");
INSERT INTO kqf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tedi a giuna gado, “Mote soimo tama voiye male lava ta kaḡasiḡasidi.” ");
INSERT INTO kqf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betenimo Saimon sida kapa i vaivaina ena vanuwemo Yesu i miya i kanikani bi waivini masi panepanena dubina i vai tavaite. Kamaina bi dubi gadona i kulakoto bi Yesu dabanemo i ḡini. Niga gaubina ba ḡawaḡawa isana Nad masinemo a voiye bi maiina ba i didiga gulata. ");
INSERT INTO kqf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lava ḡesaudi ḡome a miyamiyana a medi bi taudiḡa ai giugiuna gado, “Bai aubaina masi panepanena i waiyakali? ");
INSERT INTO kqf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mba maso a kuneye bi mane dididiga otina a vai te maso lava wainuwatoitoidi a vitedi.” Bi tedi waivini a kaipasine. ");
INSERT INTO kqf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bi Yesu i giuwedina gado, “Ko kita kamaḡe! Bai aubaina ko kaka nuwalaḡalaḡa? Tana kauwa visuvisuna tagu aubaigu i voiye. ");
INSERT INTO kqf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Temi lava wai nuwatoitoidi sauga matabuna vaitedi ko miyamiya, bamoda sagudi ko ḡoena ba wali saugemo ko sagudi bi tagu mote temi vaitemi tama miya nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tana i sibe te bai ya voivoiye. Masi panepanena tubuḡigumo i ḡinina ba i ka nonoḡina muliḡa laudobo aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yà giugiu kauwemi, dobu matabunemo lava giu visuvisuna sa lauguguyaena ba niga waivinina bai i voivoiyena sa noḡoti bi sa giuwata.” ");
INSERT INTO kqf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Diudas Iskaliot, tauwaikaiwatana 12 nopodimo i nawa pilisi edi babada lisidimo bi i kaisolu te bainewa Yesu sa pani. ");
INSERT INTO kqf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tedi bai i giugiuwedina, a vaiye bi ai nuwavisu gulata. Kamaina bi a giuwapa te mane sa vite. Ḡome Diudas gavogavo i tavutavu te bainewa maso Yesu nimedimo i sako. ");
INSERT INTO kqf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Buledi mote muu'a vaitena soina laḡanina i tava. Ḡome lava sipu natunatudi lau ewalidi a vunudi bi a lau sewasewaedi vawaitauli soinemo. Bi ena tauwaikaiwatana ai talayena gado, “Bamo ḡome kuna ḡoeḡoena vawaitauli kanina ka voiye?” ");
INSERT INTO kqf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kamaina bi Yesu ena tauwaikaiwatana labu i giu wailovelovedi bi i giukamaḡedina gado, “Ko nawa Yelusalemmo ko tava bi oloto ko kita gauba dubina ya avaavalina ko kaiwata. ");
INSERT INTO kqf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bi bamo vanuwinemo ya valagetana, mba vanuwina taniwagina ko giuwena gado: Tauwailovelove niga mainana i giu, ‘Bamo gabunemo tagu bi egu tauwaikaiwatana vaitedi, vawaitauli kanina ka kani?’ ");
INSERT INTO kqf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bi ḡome vanuwina noponemo gabu dididiga kaka nonoḡina yai lovemi. Te ḡome temi bai matabuna aubaida ko kanonoḡi.” ");
INSERT INTO kqf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kamaina bi taukaiwatana a nawa, malagai dididiginemo a tava bi bai matabuna Yesu bainewa i giugiuwedina mainana a banavi. Bi ḡome vawaitauli kanina a kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aubigamo Yesu taukaiwatana vaitedi a tava. ");
INSERT INTO kqf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laḡannemo a miya a kanikani ba Yesu i giuna gado, “Yà giugiu kauwemi, te ḡemota modomimo kaka ya kaisoluyegu, tana aiyai vaitena ka kanikanina.” ");
INSERT INTO kqf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Taukaiwatana nuwedi i gebo bi ḡemoḡemotaḡa ai talayena gado, “Bada ku giu, mote tagu, ee?” ");
INSERT INTO kqf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu i giuwedina gado, “Temi 12 modomimo ḡemota, tana aiyai vaitegu ema buledi abomemo ka wai dakwana. ");
INSERT INTO kqf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maibena wala a gilugilumina noponemo te Tana Taunana Natuna kaka ya peki. Bi i gebo kauwa te oloto aiyai Tana Taunana Natuna ya kaisoluye! Mba olotona avena te maso i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ḡome a kanikani bi Yesu buledi i vai, Maimaituwa i wai ebone, i vilikivi bi ena tauwaikaiwatana i vitedi. Bi i giuwedina gado, “Niga ko vai, tagu tubuḡigu.” ");
INSERT INTO kqf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kota ledu i vai, tamana i wai ebone bi tedi matabudi ledunemo a lautego. ");
INSERT INTO kqf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu i giuwedina gado, “Niga ba tagu kwasinigu i nuwaḡini lava wapewapedi aubaidi, tagu kwasinigu Maimaituwa ena waianina ya voiye te ya ḡailisi. ");
INSERT INTO kqf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yà giugiukauwemi, tagu kaka mote niga waenina yàma tego munaḡe eete Maimaituwa ena waibada laḡannemo kaka waen valivaliuna yà tego.” ");
INSERT INTO kqf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kamaina bi a sale i kovi bi a nawa Olip oyanemo. ");
INSERT INTO kqf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu tedi i giuwedina gado, “Temi matabumi kaka ko velau ko gosegu, maibena gilugilumina wadubonemo Maimaituwa niga mainana i giu, ‘Tagu kaka tauwaiḡamoḡamo yai peki bi sipu kaka sa dabalala.’ Taunana aubaina temi matabumi kaka ko velau ko nawa. ");
INSERT INTO kqf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bi laḡannemo tagu yà kenamoito, ba yà dolidoli Galilimo.” ");
INSERT INTO kqf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tana mainana i giugiu ba Pita ena giu i wai munena gado, “Egu lava ḡesaudi male sa velau sa nawa bi tagu ba mote yàma gosem!” ");
INSERT INTO kqf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu Pita i giuwena gado, “Yà giugiukauwem te mateya dudubalemo, muliḡa kaka kamkam malabu ya ḡabana, ba tam ma faiona kwa giu te mote ku sibegu.” ");
INSERT INTO kqf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita kalinana bagibaginemo i giuna gado, “Tagu male mote mainana yàma giu. Avena te bainewa bi male vaitem ta peki. Tagu male mote yàma valeleem.” Bi ḡesaudi giuna ḡemotina a vato. ");
INSERT INTO kqf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tedi dobu isana Getsemenimo a tava bi Yesu ena tauwaikaiwatana i giuwedina gado, “Niga ḡome ko miyamiya bi tagu yà nawa yà laupali.” ");
INSERT INTO kqf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tana Pita, Diyemes bi Diyon i waidolidi te a nawa. Tana yavi bi nuwaboya nopona i wai wanavu. ");
INSERT INTO kqf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bi i giuwedina gado, “Nuwaboya nopogumo i didiga gulata, ḡotona te yai pekigu. Niga ḡome ko miya bi manoḡotimi ko wai kita.” ");
INSERT INTO kqf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu ḡotona i taunawa bi i nuwalikwa doḡamo i talaḡa bi i laupalina, bamoda ḡemoḡemotina, te niga wainuwatoina mote maso i vai. ");
INSERT INTO kqf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kamaina bi i laupalina gado, “Tamagu, Tamagu! Bai matabuna tam lisimmo i tekateka. Niga wainuwatoina leduna lisigumo kwa kaikamaḡe. Bi geḡa te mote tagu egu ḡowana bi tam em ḡowana.” ");
INSERT INTO kqf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu i tava munaḡa bi ena tauwaikaiwatana faiona i kitedi a kena kwavu. Kamaina bi tana Pita i giuwena gado, “Saimon, tam kwa kenakena ee? Maso ḡemoḡemotina kona tauwai kita laḡan ḡaubona? ");
INSERT INTO kqf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ko kita kauwa bi ko laupali te mote laulubumo koma kuluva. Aluwimi ya ḡoeḡoe bi tubuḡa i gwaḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kamaina bi kota i munaḡa i laupali bi giuna ḡemotinana i vatovato. ");
INSERT INTO kqf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I nato munaḡa i kitedi a kenakena banina tedi mote ḡemoḡemotina te sai kita. Bi mote a sibe te bai sa giuwe. ");
INSERT INTO kqf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bi ena tava waifaioninemo i giuwedina gado, “Temi yaḡolo ko waiyawasi? Kena avena, ko kita, laḡanina i tava, te Tana Taunana Natuna sa kaisoluye bi gebogebo lavedi nimedimo sa sako. ");
INSERT INTO kqf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ko moito! Ta nawa, ko kita, oloto taukaisoluḡegu kaikana i tava!” ");
INSERT INTO kqf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu yaḡolo i giugiu ba ena tauwaikaiwatana 12 nopodimo ḡemota isana Diudas i tava. Lava kumna edi madamada bi kepata a tanodi bi tana vaitena a tava. Pilisi edi babada, waiḡake tauwailovelovena bi Diu babadidi niga lavedi a giukamaḡedi a tava. ");
INSERT INTO kqf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Diudas lava kumna i giu wainonodi te mataila yai lovedi, “Bamo taunana yài suluvena ba taunana ko pani bi ko kita te mote ima naila ima nawa.” ");
INSERT INTO kqf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Noi taunana a tavatava, te Diudas i nawa ota Yesu lisinemo bi i giuwena gado, “Tauwailovelove, bi i waisuluve.” ");
INSERT INTO kqf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kamaina bi Yesu a pani bi a labadidi. ");
INSERT INTO kqf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bi ḡome diyanemo taumoito ḡemota ena kepata i wai guli, te pilisi saḡasaḡa guletina ena taupaula beyana i tadi kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kamaina bi Yesu i giuwedina gado, “Temi kepata bi madamada kona avala tava, te tagu ko paniguna maibena tauwaibeyapota ee? ");
INSERT INTO kqf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Laḡan matabuna tagu Maimaituwa ena vanuwemo e wailovelove bi mote ko panigu. Gilugilumina wadubonemo i giugiuwena niga taunana ya tubutubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kamaina bi ḡome ena tauwaikaiwatana a ḡose bi a velau a nawa. ");
INSERT INTO kqf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oloto ewalina ḡemota Yesu i kaikaiwata bi ena kaleko potipotina i kotekotena bena maso a kaididi ");
INSERT INTO kqf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bi geḡa te ena galaḡa a soluḡiḡi kamaḡe bi tana ma kofakofana i velau i nawa. ");
INSERT INTO kqf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kamaina bi Yesu ai dolinawe pilisi saḡasaḡa guletina ena vanuwemo, ḡome pilisi edi babada, waiḡake tauwailovelovena bi Diu babadidi ḡesaudi a tava ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita, Yesu i vawatawata te tana didimanina i nawa pilisi saḡasaḡa guletina ena vanuwa mataetinemo. Tana ḡome etala gabuna taulabena vaitedi a miya kai diyanemo a malimalili. ");
INSERT INTO kqf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pilipilisi edi babada bi bolu babadidi ḡesaudi tedi Yesu ena gebo a tavutavuḡe te maso ai peki bi mote aiyai bamo lisinemo giukauwa a vai. ");
INSERT INTO kqf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lava wapewapedi edi waiwavu giudi a tava a giuwedi bi edi giu ba tabudi bi tabudi. ");
INSERT INTO kqf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lava ḡesaudi a moito bi waiwavu kaikaiyovudimo tana ai wavuna gado, ");
INSERT INTO kqf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tama ke vaiye i giuna gado, ‘Tagu kaka Maimaituwa ena vanuwa lava a kelikelina, yà kagebogebo bi laḡan faiona nopodimo ḡesau yà keli, mote lava nimedimo voivoiyena.” ");
INSERT INTO kqf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bi yaḡolo te edi giu tabudi bi tabudi. ");
INSERT INTO kqf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kamaina bi pilisi saḡasaḡa guletina i miya moito i nato bi Yesu i wai talayena gado, “Bai kwa giuwe ee geḡa? Niga lavedi sa wai wavum.” ");
INSERT INTO kqf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bi tana i miya moimoisili, mote bai i giuwe. Bi kota pilisi saḡasaḡa guletina i waitala munaḡe bi i giuna gado, “Tam taunana Vinevinena, Maimaituwa ta kaka saḡesaḡena natuna, ee?” ");
INSERT INTO kqf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bi Yesu i giuna gado, “Tagu taunana Vinevinena, Tana Taunana Natuna kaka ko kita tamana ḡaiḡailisina kataiyanemo ya miyamiya bi malamo ma giyouna ya nato.” ");
INSERT INTO kqf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ḡome pilisi saḡasaḡa guletina ena gala i kulalisi bi i giuna gado, “Tama niganana mote giu ḡesaudi vaiyedi kama ḡoeḡoedi.” ");
INSERT INTO kqf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bainewa ko noḡonoḡoti, kaikana beyademo te vaiye te i waidiboḡa te Maimaituwa i sako yovoḡe. Tedi matabudi a binauna gado, “Tana i waidiboḡa, kamaina te ya peki.” ");
INSERT INTO kqf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bi lava ḡesaudi Yesu a gelolo, matana a suma, a kwapu bi a giuna gado, “Tena ku giu, aiyai i kwapum?” Kamaina bi tauyava Yesu a kaididi bi a lau nevanevakau. ");
INSERT INTO kqf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita yaḡolo pilisi saḡasaḡa guletina ena vanuwa mataetinemo bi pilisi ena taupaula waivinina ḡemota i tava. ");
INSERT INTO kqf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ḡome Pita i kita i malimalili bi i kitadidi bi i giuwena gado, “Tam taunana Nasalet Yesuna vaitena kona nawanawa ḡemota.” ");
INSERT INTO kqf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bi geḡa te tana i valele bi i giuna gado, “Tagu mote yà sibe bai kwa giugiuwe.” Kamaina bi Pita i miya moito te ganakuku mataetina yawaninaḡa i nawa. Kamaina bi kamkam i ḡaba. ");
INSERT INTO kqf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ḡome taupaula waivinina Pita i kita bi giuna ḡemotina diyanemo taumoito i giuwedina gado, “Niga taunana editau ḡemota.” ");
INSERT INTO kqf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bi Pita kota i valele munaḡa. Kamaina bi a taumiya mala ḡaubona bi diyanemo taumoito Pita a giu munaḡena gado, “Mote kuma valele, kamaina te tam taunana Galili lavam.” ");
INSERT INTO kqf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bi Pita Maimaituwa isanemo i waisaḡinana gado, “Kagusai Tamagu, yà giugiu kauwemi te tagu mba lavana ko giugiuwena mote yà sibe.” ");
INSERT INTO kqf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Noi taunana te kamkam ḡaba i wai labu, mulinemo Pita Yesu ena giu i noḡoti, “Muliḡa kaka kamkam ma labu ya ḡabana, tam kaka ma faiona kwa valeleyegu.” Kamaina bi Pita i laudulu bi i ḡaba nusanusa. ");
INSERT INTO kqf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Olaolala kaikana Pilisi edi babada, waiḡake tauwailovelovena, waibabada bi bolu babadidi matabudi ai ḡemotidi bi ai ogatala. Kamaina bi Yesu nimana a pani bi ai doli nawe gabemani isana Paelat nimanemo a sako. ");
INSERT INTO kqf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paelat Yesu i waitalayena gado, “Tam Diu edi ḡalibona ee?” Bi Yesu ena giu i wai munena gado, “Emaso, kuna giugiuna mainana.” ");
INSERT INTO kqf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pilisi edi babada kauwa wapewapedimo Yesu ai wavu. ");
INSERT INTO kqf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kamaina bi Paelat Yesu i waitala munaḡena gado, “Ei, tam bai kwa giuwe ee geḡa? Kwa vaiye kauwa wapewapedi gebogebodimo sa wai wavum!” ");
INSERT INTO kqf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bi Yesu mote bamo bai i giulubuḡe. Taunana aubaina Paelat i sove. ");
INSERT INTO kqf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paelat ena vaivaimo wala vawaitauli soina laḡannemo Diu lavedi bamo lavana biliwelokomo a wai aninena taunana ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mba ḡome oloto isana Balabas ena lava tauwaiḡaviya ḡesaudi vaitedi biliwelokomo a miyamiya. Tedi wala Loum gabemanina ena waibada ai ḡaviye bi lava a waipekidi. ");
INSERT INTO kqf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lava kumna a tava Paelat lisinemo ai ḡemotidi bi ai baḡa te aubaidi, ena vaivaimo wala i voivoiyena mainana maso i voiye. ");
INSERT INTO kqf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Bi Paelat i sibe kauwe te pilipilisi edi babada unula dabanemo Yesu tana nimanemo a sako. Taunana aubaina Paelat edi giu i waimunena gado, “Ko ḡoeḡoena Diu edi ḡalibona yà kaikamaḡe aubaimi ee?” ");
INSERT INTO kqf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilipilisi edi babada edi giumo lava kumna nuwedi a liuliuwe te Paelat maso ai baḡa te Balabas biliwelokomo ya kaikamaḡe aubaidi bi mote Yesu. ");
INSERT INTO kqf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bi tana lava i waitala munaḡedina gado, “Te bai kona ḡoena yà voiye niga lavana ko wai isana Diu edi ḡalibona lisinemo?” ");
INSERT INTO kqf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bi tedi a binauna gado, “Ku tupalatu!” ");
INSERT INTO kqf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bi Paelat i waitalayedina gado, “Bi bai aubaina? Bai gebona i voiye?” Bi kota a binau gulatana gado, “Ku tupalatu!” ");
INSERT INTO kqf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kamaina bi Paelat i ḡoeḡoena lava yai nuwavisudi aubaina, Balabas i kaikamaḡe i nawa bi ḡaviḡaviyidi i giuwedi te Yesu sa kwapu bi sa nawe sa tupalatu. ");
INSERT INTO kqf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ḡaviḡaviyidi Yesu ai doli nawe Paelat ena vanuwa mataetinemo bi edi lava ḡesaudi ḡaviḡaviyidi a giuwedi a tava te ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bi ḡome tedi gala molemolena maibena ḡalibona ena gala kulina, Yesu ai kote bi donadona pipipinina a voivoiyena a vai te kununemo ai kote. ");
INSERT INTO kqf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kamaina bi ai gwaigwaiye bi lisinemo a binauna gado, “Ebom, Diu edi ḡalibona!” ");
INSERT INTO kqf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tedi diḡonemo kununa a kwapu, a kaniso tawatawa bi tuwapekedi ai tupagwaliḡedi bi wainamaḡemo a laulauduneye maibena ḡalibona. ");
INSERT INTO kqf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tedi ai namaḡe i kovi bi gala molemolena a kaikamaḡe bi tana ena gala otina ai kote munaḡe, kaka bi ai dolinawe tupalatuna aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A nawanawa etamo te oloto isana Saimon a banavi, tana daibimo bi i saḡasaḡa Yelusalem malagai dididiginemo. Saimon tana Aleksanda bi Lupas tamedi tana Sailin lavana. Ḡome ḡaviḡaviyidi Saimon a egeli te Yesu ena kolosi i avali. ");
INSERT INTO kqf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tedi Yesu ai doli nawe Golgotamo, niga isana banina ba Kunukoukou gabuna. ");
INSERT INTO kqf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ḡome tedi waen ma'a vaitena vitavitalena Yesu a vite lubu bi i daboke. ");
INSERT INTO kqf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ḡaviḡaviyidi Yesu a tupalatu bi ena gala a daliḡidi. Bi wainasi beyakuluna a voiye te aiyai bi i vato kauwena ba galedi ya tanodi. ");
INSERT INTO kqf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Olaolalemo 9 okoloki bi Yesu a tupalatu. ");
INSERT INTO kqf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bi kai selipapinemo wai gwaigwai giuna a gilumina gado, “Niga Diu edi ḡalibona.” Bi kununa kavalinemo a sako. ");
INSERT INTO kqf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bi kota taudanedanene labu a tupalatudi Yesu vaitena, ḡemota kataiyanemo bi ḡemota ḡeniyanemo. ");
INSERT INTO kqf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tedi mabai a velavelau teiyaḡina ba ai diboḡi, iwedi ai kwadekwadedi bi a giugiuna gado, “Emata! Tam walanamo kuna giu te Maimaituwa ena vanuwa kwa koisuwasuwa bi laḡan faiona nopodimo kwa keli munaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Niganana ku waiyawasani munaḡem bi kolosi modonaḡa kwa yovo!” ");
INSERT INTO kqf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kauwina ḡemoḡemotinemo pilipilisi edi babada bi waiḡake tauwailovelovena Yesu ai namaḡe bi tedi taudiḡa a wai gwaigwaiyena gado, “Lava ḡesaudi i wai yawasanidi bi tana mote ḡemoḡemotina te imai yawasani munaḡe! ");
INSERT INTO kqf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tana i giu te tana taunana Keliso, Islael edi ḡalibona. Niganana kolosimo ya potiyovo ta kita, kaka bi tai sumaḡe.” Bi kota lava labu Yesu diyanemo a tupatupalatudina vaitedi tana ai diboḡi. ");
INSERT INTO kqf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Suwala 12 okoloki balamo mba dobuna matabuna i waidudubala eete suwala i tinamuli. ");
INSERT INTO kqf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Suwala 3 okoloki bi Yesu kalinana dididiginemo i guletutuna gado, “Eloi, Eloi, lama sabatani.” Niga giuna banina ba, “Egu Maimaituwa, Egu Maimaituwa bai aubaina kuna gosegu?” ");
INSERT INTO kqf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bi diyanemo taumoito noi giuna a aivaivaiye ba a giuna gado, “Ko vaiye, tana Elaidiya ya yogeyoge.” ");
INSERT INTO kqf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lava ḡemota i velau tai i vai te kai isunemo i pani bi waen wailuluna i taivai te maso Yesu i waitego. Bi i giuna gado, “Avena ta tau wailaba bi ta wai kita bamoda Elaidiya ya nato bi kolosimo ya sako yovoḡe.” ");
INSERT INTO kqf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ḡome Yesu kalinana dididiginemo i lauaiyoi bi yawasina i tauvunu. ");
INSERT INTO kqf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bi Maimaituwa ena vanuwemo guduboyo i dawedawena i nuwalisi labu dabanemo te i yovo dibunemo i laukamaḡe. Niga guduboyona ba gabu waiwaiyawina guduna. ");
INSERT INTO kqf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ḡome ḡaviḡaviyidi edi bada kolosi pakanemo i moimoitona i kita te bainewa Yesu i peki, kamaina bi i giuna gado, “Giukauwa te niga lavana Maimaituwa natuna!” ");
INSERT INTO kqf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mba ḡome ba waivini ḡesaudi manemanekemo a waiwaikitana, nopodimo ba Meli Magdalin, Meli, Diyemes ḡaubona bi Dioses tinedi bi Salome. ");
INSERT INTO kqf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Niga waivinidi wala Galilimo Yesu a kaikaiwata bi a sagusagu. Bi kota waivini ḡesaudi wala Yesu vaitena a natonatona Yelusalemmo ba ḡome vaitedi. ");
INSERT INTO kqf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mba aubiganemo vononoḡa suwelina i kovikovi bi muliḡa kaka waiyawasi laḡanna yai tubu. Bi Diyousep Alimatiya olotona tana bolu badana ḡemota bi a vivivile, tana Maimaituwa ena waibadana ya natonatona i labelabe. Tana ma laudabatolana i nawa Paelat lisinemo bi i waibaḡa te Yesu taubeuna ya vai. ");
INSERT INTO kqf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ḡome Paelat i tatava te Yesu kaikana i peki. Taunana aubaina ḡaviḡaviyidi edi bada i yoge bi i waitalayena gado, “Yesu i peki, ee?” ");
INSERT INTO kqf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bi ḡaviḡaviyidi edi bada Paelat i giuwe te Yesu kaikana i peki. Taunana aubaina Diyousep i waianine te Yesu taubeuna kolosimo ya vai. ");
INSERT INTO kqf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Diyousep gala potipotidi i gimeli tavaitedi bi Yesu taubeuna i sako yovoḡe te galedimo i suma. Kamaina bi i avali nawe tauyewamo po'oa doudou wainononemo i sako. Ḡome ḡakima dididiga tabatabana i ḡima bi tauyewa mataetina i wai dougudu. ");
INSERT INTO kqf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meli Magdalin bi Meli Dioses tinana a kita te Yesu taubeuna bamo ḡome i sako. ");
INSERT INTO kqf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kamaina bi waiyawasi laḡanina i kovi mulinemo Meli Magdalin, Diyemes tinana Meli bi Salome bona panepanedi a gimala Yesu tunina a kailolo aubaina. ");
INSERT INTO kqf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kamaina bi Sande olaolalemo suwala i lovolovotava tedi a nawa tauyewamo. ");
INSERT INTO kqf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bi etaḡa taudiḡa a wai giugiuna gado, “Aiyai aubaida ḡakima ya ḡima kamaḡe tauyewa mataetinemo?” ");
INSERT INTO kqf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Laḡannemo matedi a tautaulagetidi ba ḡakimina dididiga ḡimaḡima kamaḡena a kita. ");
INSERT INTO kqf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tedi tauyewamo a sola nawa te oloto lauewalina a kita, ena gala potipotina kataiyedimo i miyamiya. Ḡome tedi a tatava bi a naila gulata. ");
INSERT INTO kqf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kamaina bi i giuwedina gado, “Koma nainaila! Temi ba Nasalet Yesuna tupatupalatuna ko tavutavuḡe. Tana mote niga ḡome, kaikana pekimo i kenamoito. Ko kita, niga taubeu gabukavanaḡa. ");
INSERT INTO kqf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bi ko nawa ena tauwaikaiwatana ḡesaudi lisidimo bi kota Pita bi niga mainana ko giuwedi, ‘Tana ya dolidoli Galilimo, i giugiuwemina mainana, ḡome kaka ko kita.” ");
INSERT INTO kqf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kamaina bi waivinidi ma nuwagusugusudi tauyewa a potiyovo kamaḡe bi a velau a nawa. Tedi a naila gulata aubaina te mote bamo aiyai a giuwe. ");
INSERT INTO kqf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kamaina bi Sande olaolalemo Yesu pekimo i kenamoito bi Meli Magdalin lisinemo i gei laumaḡata. Niga waivinina wala lisinemo aluwa gebogebodi wapedi 7 i kwavivaidi. ");
INSERT INTO kqf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tana i nawa te Yesu taukaiwatana bai i tubutubuḡana i giuwedi. Banina Yesu i peki aubaina tedi ma nuwaboyedi a miya bi a ḡabaḡaba. ");
INSERT INTO kqf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bi laḡannemo Meli i giuwedina gado, “Tagu lisigumo Yesu i laumaḡata te e kita.” Tedi waivinina ena giu mote ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bi mulinemo taukaiwatana labu malagai a potiyovo kamaḡe bi a nawanawa etaḡa bi Yesu lisidimo i laumaḡata bi kitana i nuwavitala te mote a kita ḡone. ");
INSERT INTO kqf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tedi a tau nawanawa kaka a kitaḡone, kamaina bi a munaḡa edi lava a giuwedi bi edi giu mote ai sumaḡedi. ");
INSERT INTO kqf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mulinemo te Yesu ena tauwaikaiwatana 11 a kanikani bi lisidimo i laumaḡata. Ena tauwaikaiwatana nopodi ba gudugududi aubaina mote ai sumaḡe. Taunana aubaina i ḡasiyedi bi i giuwedina gado, “Tagu pekimo e kenamoito te lava a kitagu bi a giuwemi bi bai aubaina mote koi sumaḡedi?” ");
INSERT INTO kqf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kamaina bi i giuwedina gado, “Ko nawa dobu matabudimo bi lava matabudi lisidimo giu visuvisuna ko lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bi lava aiyai yai sumaḡegu bi gaubemo sa kabuluna ba tana ya yawasana. Bi aiyai mote i wai sumaḡegu ba kamaina te kovoḡa ya vai. ");
INSERT INTO kqf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bi mabai sa wai sumaḡeguna ba anisove kauwidi sa voiyedi. Bi tedi kaka tagu isagumo aluwa gebogebodi lava lisidimo sa kwavivaidi. Bi kota kalina ḡesaudi mote a sibesibedinemo sa gagali. ");
INSERT INTO kqf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tedi mwata wai lauonedi sa legaudina ba mote sima peki. Bi kota gauba waionedi sa tegodina ba mote ima laukubutidi. Bi nimedi lava sidesidedi dabedimo sa sivudina ba sa yawasana.” ");
INSERT INTO kqf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Yesu giu i wai waikovi mulinemo ba Maimaituwa Yesu i lageti saḡe malamo. Tana kataiyanemo waibada gabunemo i waimiyeni. ");
INSERT INTO kqf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kamaina bi ena tauwaikaiwatana a potiyovo a nawa dobu matabudimo bi a lauguguya. Bi Bada i sagudi bi i ka maḡati kauwe te edi lauguguya ba giukauwa. Banina Bada ena ḡailisimo anisove kauwidi a voivoiyedi bi lava a kitekitedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Aisi Tiyopilas! Lava wapawapa kaikana kauwa lisidemo a tubutubuḡana matabudi a gilumi watedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pakanemo taupaula a laulauguguyana bi lava matedimo kauwa a kitekitedi bi a giugiuwemaina matabudi a gilumidi. ");
INSERT INTO kqf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Taunana aubaina tagu niga kauwidi pakanemo e kita kauwedi te edi didimanemo yà gilugilumidina tam aubaim. ");
INSERT INTO kqf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Banina tam maso kuna sibe kauwe te bai a wailovelovemna ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Diudiya edi ḡalibona Alodi ena waibada sauginemo bi ḡome ba pilisi isana Sakalaiya i miyamiya. Tana ba pilisi Abisa ena tubulelesa bi mwanena Elisabet ba pilisi Elon ena tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bi tana mamwanena ba yawasana didimaninemo a miyamiya Maimaituwa matanemo. Bada ena giuvavasaḡa bi ena waiḡake a voteyeteyaedi bi mote bai a voiye waigebo. ");
INSERT INTO kqf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tedi mote ai natunatuna banina Elisabet i aipoi bi tedi ai magula kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laḡan ḡemota Sakalaiya ena sauga i tava te Pilisi noyana pali vanuwina noponemo i voivoiye. ");
INSERT INTO kqf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tana koitilimo a vine te piupiu ya gabu pilisi edi vaivai luvanemo. Kamaina bi i sola nawa Bada ena vanuwemo te piupiu panepanena i gabu. ");
INSERT INTO kqf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bi lava kumna vanuwa didiyaunemo a laulaupali, piupiu gabuna laḡannemo. ");
INSERT INTO kqf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mba ḡome Bada ena aneya i laumaḡatana Sakalaiya lisinemo. Bi olta diyanemo i moimoito, kataiyana yawaninemo, bamo piupiu i gabugabunemo. ");
INSERT INTO kqf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ḡome Sakalaiya aneya i kitakita ba i tatava, bi naila i kagusugusu. ");
INSERT INTO kqf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Geḡa te aneya i giuwena gado, “Mote kuma naila.” Em pali ba Maimaituwa i vai. Mwanem Elisabet kaka natum olotona ya bewa bi kwai isana Diyon. ");
INSERT INTO kqf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tana ya voiyem te kwai nuwavisu bi kwa yasisi, ena tubuḡemo ba lava wapawapa sa yasisi. ");
INSERT INTO kqf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bi Bada matanemo ba tana i saḡa gulata. Tana mote wain e tegotego ḡaiḡailisidi ima tegodi, banina ena tubuḡemo ba Aluwa Waiyawa yai waiwanavu. ");
INSERT INTO kqf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tana Islael lavedi wapewapedi ya natome munaḡedi Bada edi Maimaituwa lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bi tana Bada ena eta ya yawasi bi Aluwemo maḡailisina ya noyana maibena Elaidiya. Tana magumagula nuwedi ya vitaledi te natunatudi nuwedi sa vaidi. Bi lava laulaukasaḡaiḡaidi nuwedi ya vitaledi te Maimaituwa ena nuwauyauya sa sibe bi didimanemo sa miya. Lava ya vononoḡedina Bada ya natonatona aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ḡome sakalaiya aneya i waitalayena gado, “Bainewa ya sibe te niga ba giukauwa. Tagu ei magula bi mwanegu kota i wai magula.” ");
INSERT INTO kqf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneya giu i waimunena gado, “Tagu Geibiliyelo, tagu Maimaituwa diyanemo taumoito. Tana i giukamaḡegu te lisimmo yà gagali bi giu visuvisuna yà giuwem. ");
INSERT INTO kqf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tagu bai e giugiuwemna mote kuwai sumaḡe te laḡan kauwa ya natonatona niga kauwina ya tubuḡa. Taunana aubaina tam kwai gumgum bi mainana kwa miyamiyana eete bai e giugiuwemna ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mba laḡannemo lava Sakalaiya a labelabena a wainuwanaina te bai aubaina tana pali vanuwinemo i miya gulata. ");
INSERT INTO kqf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sauginemo tana i potipotiyovo ba mote ḡemoḡemotina te tedi lisidimo ya gagali bi a kita ḡone te pali vanuwina noponemo wailove i kita. Tana i waigumgum bi giu i kabi kasaḡe te tubuḡinemo gagali i voivoiyedi. Kamaina te tana waigumgummo i miya. ");
INSERT INTO kqf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sauginemo wiki ḡemota noponemo tana ena noya i kovi ba i munaḡa ena malagaimo. ");
INSERT INTO kqf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mba mulinemo ba mwanena Elisabet i bwaga. Tana nawalai 5 nopodimo i lauguduguduye bi mote lava matediḡa i nawanawa. ");
INSERT INTO kqf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Bi Elisabet i giuna gado, “Niga kauwina ba Bada lisigumo i voiye bi ena ḡowana i kamaḡati bi ena launuwatoimo lava nopodimo egu dabauba i kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Laḡannemo Elisabet ena nawalai wai 6 nemo Maimaituwa aneya i giukamaḡe te i nawa Nasalet tauninemo, Galili plovinsina noponemo, ");
INSERT INTO kqf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ḡome totopa isana Meli lisinemo. Tana ai anine te Diyousep ya naḡi, bi Diyousep ba Deivida ena tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneya Meli i giuwena gado, “Ebom tam Maimaituwa i ḡoe gulatem, Bada ba tam vaitem.” ");
INSERT INTO kqf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aneya ena giumo ba Meli ena noḡota i kovi bi nuwana i laḡalaḡa te niga giuna banina bai. ");
INSERT INTO kqf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bi aneya i giuwena gado, “Meli, mote kuma naila, Maimaituwa lisimmo i wainuwa visu gulata.” ");
INSERT INTO kqf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bi tam kaka kwa bwaga bi kwai natuna te gomana olotona kwa bewa bi kwai isana Yesu. ");
INSERT INTO kqf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tana isanawanawana Maimaituwa Saḡasaḡa Guletina natuna. Bada Maimaituwa ya voiye te yai ḡalibonana maibena tamana Deivida ena waibada. ");
INSERT INTO kqf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bi Islael lavedi lisidimo yai bada bi ena waibadana ya kena nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meli aneya i waitalayena gado, “Mba bainewa? Tagu mote bamo oloto mayana yà vai.” ");
INSERT INTO kqf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bi aneya, Meli ena giu i waimunena gado, “Aluwa Waiyawa lisimmo ya yovo bi Maimaituwa Saḡasaḡa Guletina ena ḡailisimo kaka yai kwesitawam. Taunana aubaina gomana Waiwaiyawina kaka ya tubuḡa bi sai isana, Maimaituwa Natuna. ");
INSERT INTO kqf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tana kwa kita em dam isuna Elisabet, avena te i waimagula bi i aipoi bi geḡa te niganana ena nawalai wai 6 na. ");
INSERT INTO kqf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maimaituwa lisinemo mote bai i pilipili.” ");
INSERT INTO kqf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ḡome Meli giu i waimunena gado, “Tagu ba Bada ena taupaula bi bai kuna giugiuwena ba ya tubuḡa.” Kamaina bi aneya Meli i gose. ");
INSERT INTO kqf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mba kauwina mulinemo Meli i vononoḡa bi i nawa oyamo, taun Diudiya plovinsina noponemo. ");
INSERT INTO kqf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tana Sakalaiya ena vanuwemo i tava bi Elisabet i waiebone. ");
INSERT INTO kqf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Laḡannemo Elisabet Meli ena waiebona giuna i vaivaiye ba bwaganemo gomana i laupoti bi Aluwa Waiyawa i waiwanavu. ");
INSERT INTO kqf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bi kalinana dididiginemo manuwa visuna i giuna gado, “Waivini matabudi ka kavisuvisudi nopodimo tam Maimaituwa i kavisuvisu gulatem te gomana ka kavisuvisuna kwa bewa! ");
INSERT INTO kqf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tagu ba lava yababa bi bai aubaina egu Bada tinana kuna tava au kitagu. ");
INSERT INTO kqf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sauginemo kuna waiyebogu ba gomana bwagagumo mayasisina i laupoti. ");
INSERT INTO kqf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tam Maimaituwa i kavisuvisumna, banina ba kunai sumaḡa te Bada bai lisimmo i giugiuwena ba ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meli i giuna gado, “Nopogu Bada ya kasaḡesaḡe, ");
INSERT INTO kqf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aluigu i yasisi ");
INSERT INTO kqf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","banina Maimaituwa tauwaiyawasanigu, tagu taupaula ota bi tana i noḡotigu. Niganana bi noi i saḡa i nawana ba kimta matabudi sa giu te tagu Bada i kavisuvisugu, ");
INSERT INTO kqf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Maimaituwa Wailewapanina tana Waiyawa bi kauwa nananakidi aubaigu i voiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kimta te kimta mabai sa vivivilena ba ya launuwatoiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tana nimana ḡaiḡailisinemo kauwa nananakidi i voiyedi bi lava nuwanuwa saḡesaḡedi edi ogatalamo i waidabalalidi. ");
INSERT INTO kqf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tana lava a waiguyauna edi waibadamo i sivu yovoḡedi bi lava a ḡauḡaubo munaḡana i sivu saḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Maimaituwa lava kanikanipekidi mwali visuvisudimo i waiwanavudi bi waiwaiguyaudi makavekavedi i giu kamaḡedi a nawa. ");
INSERT INTO kqf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Maimaituwa ena launuwatoimo ena taupaula Islael lavedi i noḡotidi bi i sagudi. ");
INSERT INTO kqf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bi ena giuwapa i voivoiyena eda magumagula, Eiblaḡam bi natunatuna lisidimo ba ya kena nonoḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meli Elisabet lisinemo i miyana nawalai faiona a kovi bi i munaḡa ena animiyamo. ");
INSERT INTO kqf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ena wainatuna saugina i tava bi gomana olotona i bewa. ");
INSERT INTO kqf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Laḡannemo diyanemo taumiya bi ena dam lavedi a vaiye te Bada ena launuwatoi i didiga lisinemo ba matabudi a yasisi ḡemota. ");
INSERT INTO kqf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Laḡan wai 8 nemo ba gomana a natome te kwapi bwali sa vite bi tamana Sakalaiya maso i waivaliḡesae. ");
INSERT INTO kqf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bi geḡa te tinana Elisabet i giuna gado, “Geḡa! Koi isana Diyon.” ");
INSERT INTO kqf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bi tedi a giuwena gado, “Bamo em dammo mba mai isa?” ");
INSERT INTO kqf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kamaina bi lava tubuḡidimo mataila a voiye te Sakalaiya bainewa gomana yai isa. ");
INSERT INTO kqf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kamaina bi Sakalaiya anigiluma tabatabana i waibaḡaye te a vite bi i gilumana gado, “Koi isana Diyon.” Bi lava matabudi a soveye. ");
INSERT INTO kqf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Noi taunana gayana i sasasaḡi te i kabi giugiu bi Maimaituwa i kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Edi lava diyedimo taumiya matabudi a sove bi Diudiya oyana lavedi niga kauwidi a giugiu watedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lava matabudi niga giudi a vaivaiyedina ba ai nuwa noḡonoḡotaedi bi ai talana gado, “Niga gomenina ba lava bainewa kitana ya tubuḡa? Banina Bada nimana ba tana lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Diyon tamana Sakalaiya Aluwa Waiyawa i waiwanavu bi Maimaituwa giuna visuvisuna i giuwena gado, ");
INSERT INTO kqf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bada, Islael edi Maimaituwa ta kasaḡesaḡe banina tana i nato ena lava lisidimo bi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tana Tauwaiyawasanida wailewapanina i giukamaḡe lisidemo. Tana ba ena taupaula Deivida ena tubulelesemo. ");
INSERT INTO kqf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","“Maibena taugiuwatana waiwaiyawidi lisidimo wala i giugiuwapana mainana, ");
INSERT INTO kqf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","te niganana kada ḡaviya bi mabai sa dabodabokedana edi waibadamo yai yawasanida. ");
INSERT INTO kqf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Maimaituwa eda magumagula i launuwatoiyedi bi ena waianina waiwaiyawina i voivoiyena i noḡotiwata. ");
INSERT INTO kqf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Tana eda magula Eiblaḡam lisinemo i giuwapa te kada ḡaviya nimedimo yai yawasanida, bi yai anineda te mote manailida tana aubaina tamai taupaula, ");
INSERT INTO kqf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","te taila waiyawa bi eda yawasana didimanidimo laḡan matabuna tana matanemo ta miya. ");
INSERT INTO kqf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bi tam natugu kaka sai isamna Maimaituwa Saḡasaḡa Guletina taugiuwatana, banina tam kaka Bada ena eta kwa yawasi. ");
INSERT INTO kqf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bi ena lava kwa giuwedi te yawasana sai anine bi Maimaituwa edi gebogebo ya noḡoti kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eda Maimaituwa ena launuwatoi dabanemo te yawasana valivaliuna maibena olaolala suwelina ya viteda. ");
INSERT INTO kqf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bi mabai peki boimatuwina gwagwanemo sa miyamiyana, ya lai yanedi bi nuwauba etanaḡa yai dolidi.” ");
INSERT INTO kqf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Diyon i didiga bi aluwemo i ḡailisi bi tana kalakalalelemo i miyana eete i tava Islael lavedi lisidimo bi ena noya i waitubu. ");
INSERT INTO kqf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mba laḡandimo, Sisa Ogastas Loum dobuna bi dobu ḡesaudi ena waibadamo a miyamiyana i giuvavasaḡedi te sensas sa voiye. ");
INSERT INTO kqf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Niga sensasna ba sensas dolidolina i tubuḡa Kwaliniyas Sailiya i waigabemaniyena laḡannemo. ");
INSERT INTO kqf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lava matabudi a nawa edi tauniḡa isedi sivu saḡedi aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Bi kota Diyosep Nasalet malagaina Galili noponemo i modina, bi i nawa Diudiyamo ḡalibona Deivida ena taun Betliḡemmo, banina tana ba Deivida ena tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Meli wala ai anine te Diyosep ya naḡi bi tana mabwagana a nawa isedi ausivu saḡedimo. ");
INSERT INTO kqf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tedi ḡome a miyamiya bi gomana ena tubuḡa laḡanna i tava. ");
INSERT INTO kqf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kamaina bi Meli natuna tautuweḡina, gomana olotona i bewa. Bi tana galamo i suma bi ḡamoḡamo edi ḡedaḡemo i waikena, banina balekimo mote bamo edi gabu. ");
INSERT INTO kqf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bi mba dudubalinemo sipu taulabedi wapumo edi sipu a kitakita watedi. ");
INSERT INTO kqf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bi noi taunana te Bada ena aneya lisidimo i laumaḡata bi Bada namalina i yanayana kwaiviviledi ba tedi a gusu. ");
INSERT INTO kqf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bi aneya i giuwedina gado, “Koma naila, tagu yasisi dididigina giuna visuvisuna ya yovoyovoḡe lava matabudi aubaidi. ");
INSERT INTO kqf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Niganana Deivida ena taunnimo ba tauwaiyawasana i tubuḡa, tana ba Keliso, Bada. ");
INSERT INTO kqf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bi mataila kaka ko kita te gomana galamo sumasumana, ḡamoḡamo edi ḡedaḡamo ya kenakena.” ");
INSERT INTO kqf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mba taunana te malaḡa aneya kumdi a laumaḡata bi aneya edi bada vaitena a sale, Maimaituwa a kakasaḡesaḡe bi a giugiuna gado, ");
INSERT INTO kqf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Malamo namala Maimaituwa lisinemo bi nuwauba dobumo lava mabai lisidimo ya wainuwavisuna.” ");
INSERT INTO kqf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Laḡannemo aneya a munaḡana Lmalamo ba sipu taulabedi taudiḡa ai giugiuna gado, “Tada ta nawa Betliḡemmo te niga kauwina i tubuḡana ta kita, Bada i giugiuwedana mainana.” ");
INSERT INTO kqf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mba ḡome sipu taulabedi a velau makai te Meli bi Diyosep a banavidi bi kota gomana a kita ḡamoḡamo edi ḡedaḡamo i kenakena. ");
INSERT INTO kqf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Laḡannemo sipu taulabedi gomana Yesu a kitakita ba giuna ai dabalali nawe. ");
INSERT INTO kqf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bi lava sipu taulabedi edi giu a vaivaiyena ba a sove. ");
INSERT INTO kqf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bi niga kauwidi matabudi Meli noponemo i noḡotiwatedi. ");
INSERT INTO kqf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bi sipu taulabedi a munaḡa edi gougoumo, namala bi kasaḡesaḡe Maimaituwa a vite, banina kauwa matabudi a vaiyedi bi a kitedi aneya i giugiuwedina mainana a tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Laḡan 8 mulidimo gomana kwapi bwali i vai bi ai isana Yesu. Mba isana ba aneya wala Meli i gei vite muliḡa kaka i bwaga. ");
INSERT INTO kqf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mousis ena waiḡake luvanemo, mila koḡa kamaḡedi ena laḡan i kovi mulinemo ba Diyosep bi Meli, Yesu a nawe Yelusalemmo bi Bada a vite kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bada ena waiḡakemo i giuna gado, “Gomana olotona gei tubuḡina ba Bada kwa vite kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bi puyo ani lausewasewa Bada ena waiḡakemo i giuna gado, “Gabubu masepana bi mwanuwa lauewalidi labu.” ");
INSERT INTO kqf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ḡome Yelusalemmo ba oloto isana Simiyon, tana ba lava dididimanina bi waiwaipatutuna. Tana ba Keliso i labelabe te ya nato bi Islael yai yawasani bi aluwa waiyawa ba tana vaitena. ");
INSERT INTO kqf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aluwa waiyawa i wailove te tana mote ima peki eete Bada Keliso ya kita. ");
INSERT INTO kqf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aluwa Simiyon i lauetadoliye te i nawa pali vanuwinemo. Ḡome Diyosep bi Meli gomana Yesu a tavaite te waiḡake bai i giugiuwena mainana a voiye. ");
INSERT INTO kqf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon gomana i bewa bi Maimaituwa i kasaḡesaḡena gado, ");
INSERT INTO kqf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bada ḡaiḡailisim, kuna giuwapa te em taupaula nuwaubemo kwa giukamaḡegu yà nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Banina tauwaiyawasana kuna giugiukamaḡena aubaimai mataotigumo e kita. ");
INSERT INTO kqf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tam kuna vovononoḡena lava matabudi aubaidi. ");
INSERT INTO kqf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Em ḡowana tana taunana yanayana ya kamaḡati eteni lavedi lisidimo. Bi kota tana taunana Islael lavedi lisidimo namala ya kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyon ena gagalimo ba gomana tinana bi tamana a tatava. ");
INSERT INTO kqf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyon i kavisuvisudi bi gomana tinana i giuwena gado, “Niga gomenina ba Maimaituwa i vine te tana taunana kaka Islael lavedi wapewapedi ya voiyedi te sa kuluva bi kota Islael lavedi wapewapedi ya voiyedi te sa moito saḡa. Tana ba Maimaituwa ena mataila i giukamaḡe te lava wapewapedi kaka sai dibodiboḡi. ");
INSERT INTO kqf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tana ya voiyedi te edi noḡota nopodimo kenekenedi sai maḡatidi. Bi tam kaka yavi nuwapoum ya gwalina maibena naipi.” ");
INSERT INTO kqf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mba ḡome taugiuwatana waivinina isana Ana, Panuwela natuna Asa damna noponemo bi tana ba i magula kauwa. Tedi a naḡi bi a miyana kwalabu wapana 7 te mwanena i peki. ");
INSERT INTO kqf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bi Ana i iwape bi i miyana kwalabu wapana 84. Tana pali vanuwina mote i gosegose, suwala bi dudubala udimo bi palimo Maimaituwa i laulauduneye. ");
INSERT INTO kqf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ḡome Simiyon, Meli bi Diyosep vaitedi a waigiugiu te Ana i tava lisidimo. Bi Maimaituwa i waiebone bi gomana Yesu i giuwaimaḡati, tedi mabai Maimaituwa a labelabe te Yelusalem yai yawasani. ");
INSERT INTO kqf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Laḡannemo Diyosep bi Meli bai matabuna Bada ena waiḡake i giugiuwedina ai kovi, ba a munaḡa edi malagai Nasaleti Galili noponemo. ");
INSERT INTO kqf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gomana Yesu i didiga, ḡailisi i vai bi nuwauyauya i waiwanavu bi Maimaituwa ena kavisuvisu ba tana lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kwalabu onena Meli bi Diyosep a nawanawa Yelusalemmo, vawaitauli soina aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sauginemo Yesu ena kwalabu i wai 12 ba a nawa vawaitauli soina aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mba ḡome soi i kovi bi a munamunaḡa ba Yesu i miya gwasa Yelusalemmo. Tinana bi tamana mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tedi ai noḡota bena Yesu lava kumdi nopodimo. Sauginemo mote a kita edi lava bi edi dam lavedi noponemo ba tavuḡena ai tubu. ");
INSERT INTO kqf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tedi Yesu mote a banavi taunana aubaina a munaḡa Yelusalemmo tavuḡena aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Suwala waifaioninemo kaka Yesu a banavi, pali vanuwinemo, i miya Diu tauwailovelovedi i waibeyavaiyedi bi lisidimo i waiwaitala. ");
INSERT INTO kqf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bi ḡome Yesu lava matabudi edi giu i waimunedi bi a vaivaiyena ba ena nuwauyauya a soveye. ");
INSERT INTO kqf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Laḡannemo tinana bi tamana a kitakita ba a tagugu bi tinana i giuwena gado, “Natugu, bai aubaina niga kauwina kuna voiye? Tamam bi tagu ba kei nuwaboya kauwa bi ke tavutavuḡem.” ");
INSERT INTO kqf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu giu i waimunena gado, “Temi bai aubaina tagu kona tavutavuḡegu? Temi ko sibe te tagu Tamagu ena vanuwemo.” ");
INSERT INTO kqf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bi tana bai i giugiuwedina banina mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kamaina bi Yesu i waikalina kabi te tinana bi tamana vaitedi a munaḡa Nasalet. Bi tinana ba niga kauwidi matabudi noponemo i noḡoti watedi. ");
INSERT INTO kqf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bi Yesu nuwauyauya vaitena i dididiga ba Maimaituwa bi lava nuwedi i laukwasilidi. ");
INSERT INTO kqf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Laḡannemo ḡalibona Sisa Taibeliyas, tana waibadamo i miyana ena kwalabu ba wai 15 nemo, bi mba laḡannemo Pontis Paelat tana Diudiya plovins gabemanina bi Alodi tana Galili plovins guyauna bi tasina Pilip ba Ituliya bi Talakontis edi guyau bi Lisaniyas tana Abilena guyauna. ");
INSERT INTO kqf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bi Anas bi Kaiyapas ba tedi pilisi saḡasaḡa guletidi. Mba lavedi edi waibada laḡannemo ba Sakalaiya natuna Diyon kalakalalelemo i miyamiya bi Maimaituwa giuna lisinemo i yovo. ");
INSERT INTO kqf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kamaina bi Diyon i nawa Diyoudan gaubina diyanaḡa malagai matabudi nopodiḡa bi lava lisidimo i lauguguyana gado, “Emi gebogebo ko gosedi bi ko bulu yovo te Maimaituwa emi gebogebo ya noḡotikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Maibena taugiuwatana Aisaiya kalinana a gilugilumina niga mainana i giu: ‘Lava kalakalalelemo ya binabinauna gado, “Bada ena nato aubaina eta ko yawasi, ena ani nato ko kadidimani. ");
INSERT INTO kqf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gwagwa matabudi ko ḡuluvidi bi oya bi dabatuwa ko keli waiwapuwapudi. Eta balebaledi ko kadidimanidi bi ani nawa ko kasabusabu kauwe. ");
INSERT INTO kqf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mba ḡome kaka Maimaituwa bainewa yai yawasanidina lava matabudi sa kita.” ");
INSERT INTO kqf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ḡome lava kumdi laubuluyovo aubaina a natonatona Diyon lisinemo bi i giuwedina gado, “Temi salama natunatuna, aiyai i giuwemi te Maimaituwa ena kovoḡa ya giu kamaḡe yovoḡena ko naile kamaḡe? ");
INSERT INTO kqf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Taunana aubaina kauwa visuvisudi ko voiyedi te lava sa kita te temi kona nuwavitala. Bi komai noḡota gado, ‘Tada Eiblaḡam natunatuna aubaina te lisidemo mote kaka bai gebogebona ima tubuḡa.’ Yà giugiuwemi te Maimaituwa ḡemoḡemotina niga ḡakimidi ya voiyedi te Eiblaḡam ena tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bada kaikana ḡadivi i wainono te bamo kaidi bi mote sima votavota kauwa ba pakedimo ya oi kamaḡedi bi yai kalaḡosedi.” ");
INSERT INTO kqf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ḡome lava kumdi ai talana gado, “Niganana bai ka voiye?” ");
INSERT INTO kqf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bi Diyon giu i waimunena gado, “Aiyai bi kwama labu lisimmo ba ḡemota em tau waikwama geḡana kwa vite, bi kota kani mainana ko voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi taulaitupana a nato kabulu aubaina bi ai talayena gado, “Tauwailovelove, tama bai ka voiye?” ");
INSERT INTO kqf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bi Diyon i giuwedina gado, “Takis a giugiuwemina luvanemo mainana ko laitupa bi mote koma tausaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bi ḡaviḡaviyidi ḡesaudi vaitedi kota ai talayena gado, “Bi kota tama bai ka voiye?” Bi tana i giuwedina gado, “Lava mote koma laukivi gebogeboyedi bi mote koma giu waigusugusudi bi edi mane koma legaudi. Temi emi maiia taunaḡa koi nuwavisuye.” ");
INSERT INTO kqf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ḡome lava matabudi tauwaiyawasana a labelabena ai noḡota Diyon lisinemo te tana taunana bena Keliso tauwaiyawasana. ");
INSERT INTO kqf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bi geḡa te Diyon i giuwedina gado, “Tagu gaubemo yà waibulumi bi lava muliguḡa ya natonatona tana lava dididigina bi saḡasaḡa guletina bi tagu mote visuvisugu te ena kaḡesuma yà kaikamaḡe. Tana kaka Aluwa Waiyawemo bi kaimo yà kabulumi. ");
INSERT INTO kqf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tana visu bi gebogebo lavedi ya dailidina maibena laisi. Tana laisi ya tutu bi ya ḡini yavalemo bi yavala laisi kwapina ya suve te tabunemo bi banina tabunemo. Muliḡa tana laisi banidi ya legaudi bi ena susuḡumo ya sivudi bi kwapidi kai kalakalati nonoḡinemo yai kalaḡosedi.” ");
INSERT INTO kqf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ḡome Diyon kauwa wapewapedimo giu visuvisuna i laulauguguyae bi lava i giugiusagusagudi te edi yawasana sa vitaledi. ");
INSERT INTO kqf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Diyon lava wapawapa matedimo gabemani Alodi dabana i saḡai, banina Alodi tasina ena vesala Elodiyas i kwaya vai, bi ena gebogebo ḡesaudi vaitedi dabedimo. ");
INSERT INTO kqf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kamaina bi Alodi kauwa gebogebo otina i voiyena ba Diyon biliwelokomo i sako nawe bi ena gebogebo i kadidigi otiḡe. ");
INSERT INTO kqf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Muliḡa kaka Alodi Diyon biliwelokomo i sako nawena bi dolinemo Diyon lava matabudi i kabulu kovidi bi kota Yesu i kabulu. Ḡome Yesu i laulaupali ba mala i nuwa wasa ");
INSERT INTO kqf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bi Aluwa Waiyawa i yovona lisinemo maibena mwanuwa gabubu. Bi kalina malamo i yovona gado, “Tam tagu natugu nuwagu kwa vaivai bi tagu ya wainuwavisuna tam lisimmo.” ");
INSERT INTO kqf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sauginemo Yesu ena kwalabu 30 bi ena noya i waitubu lava lisidimo. Bi lava a wainoḡota bena kage tana ba Diyousep natuna bi Diyousep ba Eli natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","bi Eli ba tana Matata natuna bi Matata ba tana Livai natuna bi Livai ba tana Melki natuna bi Melki ba tana Danai natuna bi Danai ba tana Diyousep natuna. ");
INSERT INTO kqf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Bi Diyousep ba tana Matatiyas natuna bi Matatiyas ba tana Eimos natuna bi Eimos ba tana Naum natuna bi Naum ba tana Esli natuna bi Esli ba tana Nagai natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","bi Nagai ba tana Mat natuna bi Mat ba tana Matatiyas natuna bi Matatiyas ba tana Semin natuna bi Semin ba tana Diosek natuna bi Diosek ba tana Dioda natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","bi Dioda ba tana Dionan natuna bi Dionan ba tana Leḡesa natuna bi Leḡesa ba tana Selubabel natuna bi Selubabel ba tana Setiel natuna bi Setiel ba tana Neli natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","bi Neli ba tana Melki natuna bi Melki ba tana Adi natuna bi Adi ba tana Kosam natuna bi Kosam ba tana Elmada natuna bi Elmada ba tana Elu natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","bi Elu ba tana Diyosuwa natuna bi Diyosuwa ba tana Eliyesa natuna bi Eliyesa ba tana Diyolim natuna bi Diyolim ba tana Matata natuna bi Matata ba tana Livai natuna, bi Livai ");
INSERT INTO kqf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ba tana Simiyon natuna bi Simiyon ba tana Diuda natuna bi Diuda ba tana Diyousep natuna bi Diyousep ba tana Diyonam natuna bi Diyonam ba tana Eliakim natuna, ");
INSERT INTO kqf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","bi Eliakim ba tana Meleya natuna bi Meleya ba tana Menna natuna bi Menna ba tana Matata natuna bi Matata ba tana Neitan natuna bi Neitan ba tana Deivid natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","bi Deivid ba tana Diyesi natuna bi Diyesi ba tana Obed natuna bi Obed ba tana Bowas natuna. Bi Bowas ba tana Salmon natuna bi Salmon ba tana Nason natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","bi Nason ba tana Aminadab natuna bi Aminadab ba tana Admin natuna bi Admin ba tana Ani natuna bi Ani ba tana Eslon natuna bi Eslon ba tana Peles natuna bi Peles ba tana Diuda natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","bi Diuda ba tana Deikap natuna bi Deikap ba tana Aisik natuna bi Aisik ba tana Eiblaḡam natuna bi Ablaḡam ba tana Tela natuna bi Tela ba tana Naḡo natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","bi Naḡo ba tana Selug natuna bi Selug ba tana Leu natuna bi Leu ba tana Peleg natuna bi Peleg ba tana Eba natuna bi Eba ba tana Sela natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","bi Sela ba tana Keinan natuna bi Keinan ba tana Apesad natuna bi Apesad ba tana Sem natuna bi Sem ba tana Nowa natuna bi Nowa ba tana Lemeki natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","bi Lemeki ba tana Metusala natuna bi Metusala ba tana Inoki natuna bi Inoki ba tana Daledi natuna bi Daledi ba tana Maḡalel natuna bi Maḡalel ba tana Kenon natuna ");
INSERT INTO kqf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","bi Kenon ba tana Enos natuna bi Enos ba tana Seta natuna bi Seta ba tana Adam natuna bi Adam ba Maimaituwa natuna. ");
INSERT INTO kqf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Diyodan gaubinemo bi i munamunaḡa ba Aluwa Waiyawa i waiwanavu bi i waidoli nawe kalakalalelemo. ");
INSERT INTO kqf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ḡome laḡan 40 mulidimo Seitan i tava Yesu taikuluna aubaina. Mba laḡandimo tana mote bai i kani bi laḡanidi mulidimo ba Yesu kani i peki. ");
INSERT INTO kqf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kamaina bi Seitan Yesu i giuwena gado, “Bamoda tam Maimaituwa natuna, ba niga ḡakimina kwa giuwe te yaila buledi bi kwa kani.” ");
INSERT INTO kqf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Geḡa te Yesu giu i waimunena gado, “Geḡa! Gilugilumina ya giugiu te lava mote kaka buledimo sima miya.” ");
INSERT INTO kqf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kamaina bi Seitan Yesu i waidoli nawe oya dabaotinemo bi dobu ena waiguyau matabuna i wailove. ");
INSERT INTO kqf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bi Seitan Yesu i giuwena gado, “Tagu waibada bi waiguyau namanamalidi matabudi yà vitem, niga mwalidi ba Maimaituwa i vitegu bi tagu ḡemoḡemotina lava aiyai e ḡoyeḡoyena ba yà vite.” ");
INSERT INTO kqf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bamoda kwa lauduneyeguna ba waibada matabuna ya vitem. ");
INSERT INTO kqf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu giu i waimunena gado, “Geḡa! Gilugiluminemo ya giugiu te Bada em Maimaituwa taunaḡa kwa lauduneye bi aubaina kwai taupaula.” ");
INSERT INTO kqf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kamaina bi Seitan Yesu i waidoli nawe Yelusalemmo bi i voiye te pali vanuwina dabatolana isu otinemo i moito bi i giuna gado, “Bamoda tam Maimaituwa natuna ba niga ḡome kwa pwalaḡe yovoḡem. ");
INSERT INTO kqf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Banina gilugiluminemo ya giugiu te tana kaka ena aneya ya lauegelidi te sa moito galamem bi sa labe kauwem. ");
INSERT INTO kqf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bi kota tedi nimedimo sa kaididi saḡem te mote kaḡem ḡakimemo kumai tutu.” ");
INSERT INTO kqf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bi Yesu giu i waimunena gado, “Geḡa! Gilugiluminemo ya giugiu te Bada em Maimaituwa mote kumai laulubu.” ");
INSERT INTO kqf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sauginemo Seitan kauwa matabudimo Yesu i wailaulubu kovi, ba i gose bi laḡan kauwemo kaka yai laulubu munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kamaina bi Yesu i nawa Galilimo bi Aluwa Waiyawa ena ḡailisi yaḡolo tana vaitena. Ḡome Yesu giuna i dabalala te Galili dobuna matabuna i nawa yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bi edi bolu vanuwidiḡa i wailovelove nawa bi lava matabudi tana a kakasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu i munaḡa Nasaletimo, ena ani didigemo. Bi waiyawasi laḡanina ḡemota tana i nawa bolu vanuwinemo, maibena bainewa Waiyawasi laḡandimo i voivoiyena mainana. Tana i moitona ba gilugilumina iyevina aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kamaina bi Taugiuwatana Aisaiya ena buka a vite bi i tapale te giluma bamo i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bada Aluwina tagu nopogumo, banina tana i vinegu te giu visuvisuna lava wainuwatoitoidi lisidimo yà lauguguyae. Tana i giu kamaḡegu te lava panipanimo miyemiyedi yà giuwedi te tedi kaka panipani sa potiyovo kamaḡe bi matapotepotedi yà giuwedi te sai kita munaḡa. Bi kota lava edi lava sa laulau kivigebogeboyedina yài yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bi yài noyanoyana gado, “Niganana laḡan i tava te Bada ena lava yai yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ḡome Yesu buka i gudu bi taupaula i vite munaḡe te i miyatulu. Bi bolu vanuwinemo lava matabudi Yesu a kitadidi. ");
INSERT INTO kqf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ḡome Yesu giu i waitubuna gado, “Niganana giuna kona vaivaiyena ba banina i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bi lava matabudi ena giu visuvisudi a sovedi bi isana a kasaḡesaḡe bi a giuna gado, “Tana bena Diyosep natuna, bi bainewa te niga mainana ya giugiu?” ");
INSERT INTO kqf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bi Yesu i giuwedina gado, “Tagu e sibena ba niga giunemo male koi giugiuwegu, ‘Doketa, ku waiyawasani munaḡem.’ Tama ke vaiyem te Kapeniyamo bai kuna voivoiyedina, mainana kota niga em malagaimo kwa voiyedi.” ");
INSERT INTO kqf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu i giuna gado, “Tagu yà giugiu kauwemi te, taugiuwatana ena malagai lavedi kaka sa daboke. ");
INSERT INTO kqf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yà giugiu kauwemi, taugiuwatana Elaidiya ena saugemo, ba Islael noponemo iwaiwape a wapa kauwa. Bi suwala kalakaladada i lalanina ba kwalabu faiona bi nawalai 6 nopodimo, mba dobuna matabuna ba gomala i nawa yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bi Bada mote Elaidiya i giu kamaḡe aiyai ḡesau lisinemo Islael noponemo. Bi kamaina te tana i giukamaḡe nawena malagai Salepatimo, iwape i miyamiyana lisinemo Sidon noponemo. ");
INSERT INTO kqf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bi kota mainana taugiuwatana Elisa ena laḡanimo Islael noponemo, lava wapewapedi sida kapa i vaidi. Bi ḡome mote aiyai ḡesauna i waiyawasani te Sailiya olotona isana Naman taunaḡa i waiyawasani.” ");
INSERT INTO kqf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Laḡannemo lava bolu vanuwinemo mba giuna a vaivaiye ba nuwedi i laimedimedi. ");
INSERT INTO kqf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tedi a miya moito Yesu a solu, taun a potiyovo kamaḡe bi a nawena oya isunemo daki dabanemo. Bi a ḡoeḡoena maso Yesu dakimo ai lavakui, ");
INSERT INTO kqf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","bi geḡa te tana lava nopodimo i kwalakusu. ");
INSERT INTO kqf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mba ḡome te Yesu i nawa Kapeniyam tauninemo, Galili plovinsna noponemo bi Waiyawasi laḡandimo tana lava i waiwailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bi ena wailovelove a soveyena, banina ena gagali ba waibada vaitena. ");
INSERT INTO kqf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bolu vanuwina noponemo oloto aluwa gebogebona i sunesuneina, kalinana didiginemo i binauna gado, ");
INSERT INTO kqf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei, tam bai lisimaimo kwa voiye, Nasalet Yesuna! Tam kuna natona kwa kagebogebomai, ee? Tagu e sibem te tam aiyai: Tam ba Maimaituwa ena tauwainoyanoya waiwaiyawim.” ");
INSERT INTO kqf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kalinana bagibaginemo aluwa gebogebona i giuwena gado, “Kumiya moimoisili bi oloto kwa potiyovo kamaḡe!” Ḡome aluwa gebogebona oloto i pwalaḡe yovoḡe doḡamo lava matedimo bi i potiyovo kamaḡe bi mote i waikelo. ");
INSERT INTO kqf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lava matabudi a sove bi edi lava vaitedi ai giugiuna gado, “Tana ena wailovelove ba waibada bi ḡailisi vaitena te aluwa gebogebodi ya giuwedi bi sa potipotiyovo.” ");
INSERT INTO kqf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bi Yesu giuna mba dobuna matabuna i nawa yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu bolu vanuwina i gose bi i nawa Saimon ena vanuwemo. Ḡome Saimon lawana i kita sida gaugaululu i vai bi Yesu ai baḡa te ya sagu, banina tana i sida kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu i nawa waivini i kenakenana diyanemo i moito bi gaugaululu i kaipasine te waivini ya gose kamaḡe. Gaugaululu waivini i gose bi tana maḡemota i kena moito te i waikanidi. ");
INSERT INTO kqf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bi mba aubiganemo suwala bulubulumo, lava wapewapedi edi lava sida tabudi bi tabudi a vaivaidina a tavaitedi Yesu lisinemo. Tana ḡemoḡemotaḡa i taukonidi bi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bi kota aluwa gebogebodi lava wapewapedi a sunesuneidina i kwavidi a potiyovo. Bi a binabinauna gado, “Tam taunana Maimaituwa natuna!” Bi Yesu i giuwedi te a lautautau bi i voiyedi te mote a giu, banina tedi a sibe te tana taunana Keliso. ");
INSERT INTO kqf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Laḡan sakosakomo Yesu i nawa dobu ḡuyuwinemo, laupali aubaina. Bi lava a tavutavuḡe bi laḡannemo a banavina ba ai baḡa te maso mote i ḡosedi. ");
INSERT INTO kqf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bi geḡa te tana i giuwedina gado, “Tagu kota Maimaituwa ena waibada giuna visuvisuna yà lauguguyae taun ḡesaudimo, mba taunana aubaina Maimaituwa i giukamaḡegu te e yovo.” ");
INSERT INTO kqf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kamaina bi Diudiya noponemo, bolu vanuwidiḡa Yesu i lauguguya nawa. ");
INSERT INTO kqf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laḡan ḡemota Yesu Genasalet topana diyanemo i moimoito bi Maimaituwa giuna i laulauguguyaye. Bi lava kumdi a tava a dubutawi bi a waibeya vaiye. ");
INSERT INTO kqf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bi tana taugomo i kitedi edi waga labu a solusaḡedi gelemo bi edi gomo a koḡekoḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tana i moito saḡa Saimon ena wagamo bi i miyatulu. Bi i waibaḡa te ya taududunawe topamo bi lava kumdi wailovelovedi i waitubu. ");
INSERT INTO kqf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Laḡannemo i giugiu kovi ba Saimon i giuwena gado, “Waga kwa taududunawe topa pounemo bi em lava vaitedi emi gomo ko sivu yovoḡedi bi iyana ko konedi.” ");
INSERT INTO kqf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kamaina bi Saimon giu i waimunena gado, “Bada, tama dudubala lofalofa ke gomo gulata bi mote iyana ke konedi. Bi em giu aubaina te gomo ka sivuyovoḡedi.” ");
INSERT INTO kqf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Laḡannemo edi gomo a sivuyovoḡedi ba iyana wapewapedi a konedi bi ḡotona te maso edi gomo a nuwalisi. ");
INSERT INTO kqf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Taunana aubaina waga ḡesaunemo edi lava a laumatakamotaedi te sa nato sa sagudi. Ḡome te edi lava a nato a sagudi te wagedi a waiwanavudi bi wagedi ḡotona te maso a bulu. ");
INSERT INTO kqf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Laḡannemo Saimon niga kauwina i kitakita ba tuwapekanemo i kuluva Yesu kaḡepakanemo bi i giuna gado, “Tagu gebogebo lavagu, kwa ḡose kamaḡegu.” ");
INSERT INTO kqf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tana ena lava vaitedi a sove gulata, banina tedi iyana wapewapedi a konedi. ");
INSERT INTO kqf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bi ena lava Diyemesi bi Diyon, Diyebedi natunatuna kota a sove. Kamaina bi Yesu i giuwedina gado, “Mote kuma naila, niganana bi noi i saḡa i nawana, temi kaka lava ko konedi.” ");
INSERT INTO kqf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bi tedi maḡemota edi waga a solu saḡedi gelemo, mwali matabudi a ḡosedi bi Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bi taun ḡesaunemo Yesu oloto sida kapa vaivaina i banavi. Bi sauginemo oloto Yesu i kitakita ba i laudulu yovona doḡamo bi i giuna gado, “Bada, bamoda kuma ḡoe te kwai yawasanigu.” ");
INSERT INTO kqf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kamaina bi Yesu oloto i kita bi nimana i tuḡu te i taukoni bi i giuwena gado, “Yà ḡoeḡoena kwa yawasana.” Mote lofana te sida kapa oloto i ḡose bi i yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kamaina bi Yesu oloto i waiḡakena gado, “Bai i tubutubuḡana mote aiyai ḡesauna kuma giuwe, kwa nawa pilisi sewasewa taugabuna lisinemo bi ya kitam. Bi Mousis sewasewa i giugiuwena kwa voiye te lava sa kitam te kuna yawasana.” ");
INSERT INTO kqf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bi geḡa te oloto i nawa bi bai lisinemo i tubutubuḡana giuna i kadidigi. Taunana aubaina te lava kumdi a tava Yesu lisinemo bi giu visuvisuna a vaiye te edi sidamo i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bi laḡan onena Yesu i gosedi bi i nawanawa dobu ḡuyuwidimo pali aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Laḡan ḡemota Yesu i waiwailovelove, Palisi bi waiḡake tauwailovelovena babadidi ḡome a miyamiya. Tedi ba Galili, Diudiya bi Yelusalem nopodimo malagai onediḡa a tava. Bi Bada ena ḡailisi ba Yesu lisinemo te waiyawasana i voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bi olooloto ḡesaudi edi tau tunipekipekina latilatina a avali tavaite. Bi a ḡoeḡoena maso a saḡena vanuwa noponemo, Yesu matanemo ai kena. ");
INSERT INTO kqf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bi a kitakita te lava kumna vanuwa ai wanavu. Taunana aubaina a saḡa noke vanuwa dabanemo te Yesu i moimoitona luvaluvanemo, bwada a koiyavusi bi edi tau latilatina ai dawe yovoḡena Yesu matanemo. ");
INSERT INTO kqf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sauginemo Yesu edi waisumaḡa i kitakita ba oloto i giuwena gado, “Egu tau em gebogebo e noḡoti kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Palisi bi waiḡake tauwailovelovena mai giuna a vaivaiye ba taudiḡa ai giugiuna gado, “Tana ya noḡonoḡoti munaḡe te bena i saḡa gulata, mba ya waidiboḡa. Maimaituwa taunaḡa gebogebo taunoḡoti kamaḡedi, mote aiyai ḡesauna.” ");
INSERT INTO kqf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu edi noḡota i sibedi taunana aubaina i waitalayedina gado, “Bai aubaina nopomimo niga mainana ko waiwainoḡota?” ");
INSERT INTO kqf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bai giuna i tekateka, “Em gebogebo e noḡoti kamaḡedi ee ku moito bi kwa nawa? ");
INSERT INTO kqf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Taunana aubaina niganana kaka yài lovemi te ko sibe, te niga dobunemo Tana Taunana Natuna waibada i vai te gebogebo ya noḡoti kamaḡedi.” Kamaina bi Yesu i tauvitale oloto tunipekipekina i giuwena gado, “Ku kena moito, em latilati kwa vai bi kwa nawa em vanuwemo.” ");
INSERT INTO kqf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Noi taunana te lava matabudi a kitakita bi oloto i miya moito, ena latilati i vai bi Maimaituwa lisinemo makakasaḡesaḡena i nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tedi naila ika gusugusudi bi a sove gulata, bi Maimaituwa a kasaḡesaḡena gado, “Tama niganana anisove kauwina ke kita.” ");
INSERT INTO kqf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Niga kauwina mulinemo Yesu malagai i potiyovo kamaḡe bi i nawanawa te takis taulaitupana isana Livai i kita, ena anibagibagimo i miyamiya. Kamaina bi Yesu i giuwena gado, “Ku kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Noi taunana te Livai i miya moito, bai matabudi i gose kamaḡedi bi Yesu i kaiwata. ");
INSERT INTO kqf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mba mulinemo Livai ena vanuwemo soi dididiga Yesu aubaina i voiye, bi ḡome ba takis taulaitupedi kumna bi lava ḡesaudi vaitedi a kanikani. ");
INSERT INTO kqf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kamaina bi palisi bi waiḡake tauwailovelovena, Yesu ena tauwaikaiwatana a giu vitavitaledina gado, “Temi bai aubaina takis taulaitupana bi gebogebo lavedi vaitedi ko kanikani?” ");
INSERT INTO kqf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu edi giu i waimunena gado, “Lava yawayawasanidi mote doketa sima ḡoeḡoe bi lava sidesidedi taudidi doketa sa ḡoeḡoe. ");
INSERT INTO kqf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tagu e tavana mote didimana lavedi aubaidi bi gebogebo lavedi aubaidi te sa laukuvasa.” ");
INSERT INTO kqf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lava ḡesaudi Yesu a giuwena gado, “Diyon ena tauwaikaiwatana maḡemoḡemotaḡa sa udiudi bi sa laulaupali, bi kota palisi edi tauwaikaiwatana mainana sa voivoiye. Bi tam em tauwaikaiwatana bai aubaina sa kanikani bi sa tegotego?” ");
INSERT INTO kqf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Bi Yesu i giuwedina gado, “Bainewa te maso lawelawena ena tauliso sa udi? Laḡannemo tana vaitena sa miyamiya ba mote sima udi. ");
INSERT INTO kqf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Laḡan ya tava te tana ena tauwaikaiwatana lisidimo sa kaikamaḡena, kaka tedi sa udi.” ");
INSERT INTO kqf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu niga lautaulalana i giuwedina gado, “Lava mote gala valivaliuna selepina ima vai bi gala wadubonemo ima popo waiḡemoti. Bamoda mainana bi i voiyena ba gala valivaliuna ya nuwalisi, bi gala valivaliuna mote luvana te gala wadubona vaitena sima popo waiḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bi lava mote wain valivaliuna ima vai bi kwagi wadubonemo ima ḡini, male kwagi wadubona ya nuwatili te wain ya nuwaḡini bi kwagi ya gebogebo. ");
INSERT INTO kqf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wain valivaliuna kamaina te kwagi valivaliunemo ko ḡini. ");
INSERT INTO kqf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lava aiyai wain wadubona i tegotegona ba mote wain valivaliuna tegona ima ḡoeḡoe, taunana aubaina ya giugiuna gado, ‘Wain valivaliuna tegona mote i visu.’” ");
INSERT INTO kqf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Waiyawasi Laḡanina ḡesaunemo Yesu laisi daibina noponaḡa i nawanawa bi ḡome ena tauwaikaiwatana laisi a legaudi, a musudi bi a kanikanidi. ");
INSERT INTO kqf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kamaina bi ḡome waiḡake babadidi mba kauwina a kitakitana, ba a giuwedina gado, “Bai aubaina Waiyawasi Laḡannemo mba kauwina kona voiye?” ");
INSERT INTO kqf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu edi giu i waimunena gado, “Bamo mote gilugilumina ko iyevi te Deivida bi ena lava vaitedi kani a peki ba bai i voiye? ");
INSERT INTO kqf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deivida i nawa Maimaituwa ena vanuwemo i sola saḡa bi buledi Maimaituwa vitevite wainonona i legaudi te i kani. Bi waiḡake ena luvamo mba buledidi ba pilisi taudiḡa sa kanikanidi. Bi buledi ḡesaudi kota ena lava i vitedi te a kani.” ");
INSERT INTO kqf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ḡome Yesu i giuwedina gado, “Tana Taunana Natuna ba Waiyawasi Laḡanina Badana.” ");
INSERT INTO kqf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bi Waiyawasi Laḡanna ḡesaunemo Yesu i nawa bolu vanuwinemo, ḡome i waiwailovelove ba oloto nima kataiyana nuwanokuna ḡome i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Palisi bi waiḡake tauwailovelovena a waikitawata te Waiyawasi Laḡannemo yai yawasana ee geḡa. Banina tedi a ḡoeḡoena maso bai i voiye wapa bi ai wavu. ");
INSERT INTO kqf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bi tana edi noḡota i sibe kamaina bi oloto nimana nuwanokuna i giuwena gado, “Kwa saḡa matedimo kwa moito.” Bi oloto i miya moito i saḡa lava matedimo i moito. ");
INSERT INTO kqf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu i giuwedina gado, “Yài talayemi, eda waiḡake bainewa i giuweda? Waiyawasi Laḡannemo ba lava ta sagu ee ta lau kivigebogeboye. Lava tai peki ee tai yawasani?” ");
INSERT INTO kqf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bi ḡemoḡemotaḡa i kita nawedi bi oloto i giuwena gado, “Nimam ku tuḡu.” Bi nimana i tuḡutuḡu ba i yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bi tedi a medi gulata bi taudiḡa ai ogatalavivila te Yesu lisinemo bai sa voiye. ");
INSERT INTO kqf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mba laḡanna i nawa kamaḡe ba tana i nawa oyamo bi Maimaituwa lisinemo i laupali laḡansako. ");
INSERT INTO kqf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Laḡan i sako olaolalemo ena tauwaikaiwatana i yogedi a tava bi wapedi 12 i vinedi te tedi giugiukamaḡedi. Bi i vinevinedina isedi ba niga taudidi: ");
INSERT INTO kqf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon i wai isana Pita, bi tasina Endulu, Diyemesi, Diyoni, Pilipi bi Batolomi, ");
INSERT INTO kqf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Met, Tomasi, Saimon sa wai isana Delot, ");
INSERT INTO kqf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Diudas, Diyemesi natuna, bi Diudas Iskaliyot, tana taunana i waila Yesu kana ḡaviya. ");
INSERT INTO kqf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sauginemo tedi oyamo bi a miyamiya kuluva ba dobu laiwapuwapunemo a vamoito. Yesu ena tauwaikaiwatana vaitedi a moito, bi tauwaikaiwatana wapewapedi bi lava kumdi a moito kwaivivilidi. Mba lavedi ba Diudiya, Yelusalem bi gele malagaidi, Taiya bi Sidonḡa a tava. ");
INSERT INTO kqf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bi mba lavedi a tava Yesu au waibeyavaiyenemo te edi sidamo sa yawasana. Bi tedi mabai aluwa gebogebodi a sunesuneidina vaitedi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bi lava matabudi a wailaulubu te maso Yesu a taukoni, banina tana lisinemo poya i potiyovo bi lava matabudi i waiwaiyawasandi. ");
INSERT INTO kqf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ena tauwaikaiwatana niga mainana i giuwedi: “Waiwaiyamoyamonimi ba koi nuwavisu banina Maimaituwa ena waibada ba temi aubaimi. ");
INSERT INTO kqf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Koi nuwavisu temi mabai ko kanikani pekina, Maimaituwa kaka yai wanavumi. ");
INSERT INTO kqf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Laḡannemo lava sa yoaiyemi, sa kita kamaḡemi, sa lauyovoḡemi bi sa giuwemi te temi ba gebogebo lavemi ba koi nuwavisu, banina temi ba Tana Taunana Natuna tauwaisumaḡena. ");
INSERT INTO kqf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Laḡannemo bi lisimimo mai ya tubuḡana ba koi nuwavisu, bi ko yasisi banina emi maii'a malamo ya kenakena. Ko noḡoti te wala edi magumagula kauwina ḡemotina taugiuwatana lisidimo mainana a voivoiye.” ");
INSERT INTO kqf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Bi i gebo kauwa te tam aiyai niganana kwa waiguyauna. Mba kaikana em soisoi kuna vai. ");
INSERT INTO kqf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bi i gebo kauwa te tam niganana tubuḡemo kwa wainuwavisuna, tam kaka kani kwa peki. Bi i gebo kauwa te niganana kwa gwaigwai, laḡan muliḡa kaka kwai nuwaboya bi kwa ḡaba gulata. ");
INSERT INTO kqf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bi i gebo kauwa te tam niganana lava sa sovesovem, mba kauwina ḡemotinemo edi magumagula taugiuwatana kaikaiyovudi a sovesoveyedi.” ");
INSERT INTO kqf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Koi beyavaiya bi yà giuwemi, em ḡaviya kwa ḡoedi, bi tedi mabai sa dabodabokemna lisidimo visu kwa voiye. ");
INSERT INTO kqf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bi tedi mabai sa pasipasilimna kwa kavisuvisudi, bi taukagebogebom kwa laupali. ");
INSERT INTO kqf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tana aiyai bi gadigadimmo i talaḡana ba kota gadigadim ḡesauna kwa vite te ya talaḡa. Bi aiyai em kwesi i vaina ba kota kwai anine te em kwama ya vai.” ");
INSERT INTO kqf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bamoda aiyai bai i waibaḡayena ba ku vite bi aiyai em bai mwalina i vaina ba mote kuma giuwe te ima vite munaḡem. ");
INSERT INTO kqf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ko ḡoeḡoe te lava aubaimi bai sa voiyena ba temi kota tedi aubaidi mainana ko voiye. ");
INSERT INTO kqf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bamoda temi lava sa wainuwavainemna taudiḡa koi nuwavainedina ba Maimaituwa mote kaka kavisuvisu ima vitemi. Banina gebogebo lavedi kota mainana edi lava sa wainuwavainedi. ");
INSERT INTO kqf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bi bamoda temi lava visuvisu lisimmo sa voivoiyena taudiḡa lisidimo ko voiyena ba Maimaituwa mote kaka kavisuvisu ima vitemi. Gebogebo lavedi kota mainana sa voivoiye. ");
INSERT INTO kqf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bi bamoda lava ko ḡoeḡoedi te emi mane sai sipona, ba temi mote kaka maii'a koma vai. Gebogebo lavedi kota mainana sa wainoḡota te edi lava sai sipo munaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Emi ḡaviya ko ḡoedi bi lisidimo visuvisu ko voiye. Bai kona vitedina ba koma noḡonoḡoti te sa vite munaḡemi, bi emi maii'a ba dididiga malamo ya kenakena. Bamoda temi niga mainana ko voiyena ba Maimaituwa Saḡasaḡa Guletina yai kawa natunemi. Banina tana ba kivina i visu lava gebogebodi bi lava mabai mote sima waiebone lisidimo. ");
INSERT INTO kqf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ko launuwatoina maibena Tamemi malamo laulaunuwatoina. ");
INSERT INTO kqf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nopomimo lava ḡesaudi koma etaledi, Maimaituwa kaka temi ya etalemi. Lava mote koma kuvalidi, Maimaituwa kaka temi ya kuvalimi. Emi lava edi gebogebo ko nogoti kamaḡedina kaka Maimaituwa emi gebogebo ya nogoti kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lava ḡesaudi lisidimo ko soina ba Maimaituwa ya vite munaḡemi. Nopomi tabutabudimo ko soisoina ba mainana dabemimo kavisuvisu yai lautawidi. Bai ko voivoiyena ba mainana luvanemo Maimaituwa lisimimo ya voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu i lautaulalana gado, “Ḡemoḡemotina lava matapotapotana, ena tau matapotapotana yai etadoliye ee? Bamoda mainana sa voiyena ba labuidi dommo sa kuluva. ");
INSERT INTO kqf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Gomana gilugilumina mote tauwailovelovena ima saḡa kamaḡe, geḡa! Bi tana aiyai ai lovelove kauwena ba tauwailovelovena vaitena ḡemoḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Tam mote maso valetim matanemo ḡasububu ku kitakita bi tam matammo mote kaitupo kuma kitakita. ");
INSERT INTO kqf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bainewa te valetim kwa giugiuwena gado, ‘Valetigu, matammo ḡasububu yà kaikamage.’ Bi geḡa te tam matammo kaitupo mote ku kaikamaḡe. Tam kaikaiyovum. Dolina kaitupo matammo kwa gei kaikamaḡe kaka matam ya negavai, te valetim matanemo ḡasububu kwa kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Bi kai visuvisuna mote votana gebogebona, kota kai gebogebona mote votana visuvisuna. ");
INSERT INTO kqf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kai votanemo kaka kwa kita ḡone. Lava mote tipolo kainemo kulou ima losi, ee ḡawaḡawa waigedegedelinemo guleipi ima losi. ");
INSERT INTO kqf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lava noponemo kauwa visuvisudi sa kenakenana ba kauwa visuvisudi ya voivoiyedi, bi lava nopona gebogebo i waiwanavuna ba mainana gebogebo kauwidi ya voivoiyedi. Bai nopomo i wanawanavuna ba mainana gayamo ya potipotiyovo. ");
INSERT INTO kqf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bai aubaina te ko giugiuna gado, ‘Bada, Bada. Bi bai yà giugiuwena mote koma vaivaiye? ");
INSERT INTO kqf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bi tana aiyai ya nato lisigumo bi giugu ya vaiye bi ya voivoiyedina kaka yai lovemi te tana bainewa kitana. ");
INSERT INTO kqf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tana ba maibena oloto ena vanuwa domdi i ḡala gulatedi bi duḡutau i waimoitodi. Sauginemo kabaita i yovona ba vanuwina mote ima likwa, banina tana i lauḡala kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bi tana aiyai giugu i vaiye bi mote ima miyamiyaedi, ba tana maibena oloto doḡamo ena vanuwa domdi mote i ḡala gulatedi. Laḡannemo kabaita vanuwina i wailautaguna ba i likwa kamaḡe bi i kagebogebo otiḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Laḡannemo Yesu niga kauwidi matabudi lava i giuvitedi, mba ḡome te i nawa Kapeniyammo. ");
INSERT INTO kqf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ḡome tauwaiḡaviya 100 edi bada, ena taupaula nuwana tauvaikauwena tana i sida kauwa bi nuwana peki. ");
INSERT INTO kqf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Laḡannemo tauwaiḡaviya edi bada Yesu giuna i vaivaiye, ba Diu babadidi ḡesaudi i giukamaḡedi te tana sai baḡa te ya nato ena taupaula yai yawasani. ");
INSERT INTO kqf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tedi a tava Yesu lisinemo, bi ai baḡa vavasaḡena gado, “Tauwaiḡaviya edi bada em sagu ya ḡoeḡoe kauwe bi tana ba lava visuvisuna. ");
INSERT INTO kqf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Banina eda lava i ḡoyedi aubaina tana taunaḡa bolu vanuwina aubaida i ḡala.” ");
INSERT INTO kqf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kamaina bi Yesu vaitena a nawa. Tana vanuwa diyanemo i tavatava, bi tauwaiḡaviya edi bada ena lava i giukamaḡedi Yesu lisinemo te niga mai sa giu: “Bada, tagu mote yà visu te egu vanuwemo kwa nato. ");
INSERT INTO kqf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Taunana aubaina kwa giu ota bi egu taupaula ya yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tagu e sibe kauwe te tam giuḡa kwa giuwe bi ya tubuḡa. Banina tauwaibabada gabulidimo yà miyamiya, bi kota tauwaiḡaviya egu waibada dibunemo sa noyanoya. Niga yà giuwena gado, ‘Ku nawa.’ Te ya nawa, noko yà giuwena gado, ‘Ku nato.’ Te ya nato. Bi egu taupaula yà giuwena gado, ‘Niga ku voiye.’ Te ya voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Laḡannemo Yesu niga giuna i vaivaiye ba tauwaiḡaviya edi bada i soveye, bi i tauvitale te lava kumna a kaikaiwatana i giuwedina gado, “Yà giugiuwemi te niga sumeḡina mote bamo mai Islael noponemo yà kita.” ");
INSERT INTO kqf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kamaina bi tauwainoyanoya a munaḡa tava tauwaiḡaviya edi bada ena vanuwemo, bi a kita te taupaula i yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ḡome Yesu i taumiya, mulinemo, tana ena tauwaikaiwatana bi kota lava kumna vaitedi a nawa Nain tauninemo. ");
INSERT INTO kqf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Laḡannemo tana i tavatava taun lovolovotavinemo ba iwape natuna taubeuna a avali bi a potipotiyovo. Olotona pekipekina ba iwape natuna lauḡemotina, bi lava kumna mba tauninemo ba iwape vaitena. ");
INSERT INTO kqf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Laḡannemno Bada iwape i kitakita ba i launuwatoiye bi i giuwena gado, “Kuma ḡaba.” ");
INSERT INTO kqf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kamaina bi Yesu i moito nawa te taubeu i taukoni, bi olooloto taubeu tauavalina a vamoito bi tana i giuna gado, “Ewali yà giugiuwem te kwa kena moito.” ");
INSERT INTO kqf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ḡome ewali pekipekina i kena moito i miya bi giu i waitubu, bi Yesu gomana tinana i vite munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tedi matabudi a tatava bi Maimaituwa a kasaḡesaḡe bi a giuna gado, “Taugiuwatana saḡasaḡa guletina poudemo i laumaḡata, Maimaituwa i yovo te ena lava yai yawasanida.” ");
INSERT INTO kqf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu giuna i dabalala Diudiya Plovinsina bi diyadiyanaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Diyon ena tauwaikaiwatana kauwa matabudi a tubutubuḡana Diyon a tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bi ḡome ena tauwaikaiwatana labu i yogedi bi i giukamaḡedi Yesu lisinemo te sai talayena gado, “Tam taunana Keliso, lava a giugiuwena ee lava ḡesauna ka labe?” ");
INSERT INTO kqf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Laḡannemo Yesu lisinemo a tava ba tedi a giuwena gado, “Diyon Taukabulu i giukamaḡemai te kai talayem, tam taunana ke labelabem ee lava ḡesauna ka labe?” ");
INSERT INTO kqf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mba laḡannemo Yesu lava wapewapedi edi sida tabudi bi tabudi i waiyawasanidi, aluwa gebogebodi a sunesuneidina i kapotiyovodi bi matapotepotedi i waiyawasanidi te ai kita munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bi Yesu Diyon ena tauwaikaiwatana edi giu i waimunena gado, “Ko munaḡa bi bai kona kita bi kona vaivaiyena Diyon ko giuvite te matapotapotedi sa wai kita, kaḡe nuwanokudi sa nawanawa, kapa vaivaidi a yawasana, beya potepotedi sa waibeyavaiya, pekipekidi a kena moito munaḡa bi giu visuvisuna waiwaiyamoyamonidi lisidimo sa laulauguguyaye. ");
INSERT INTO kqf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Waiwainuwavisudi tedi mabai mote sima nuwanuwakulukuluvegu.” ");
INSERT INTO kqf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Diyon ena tauwaikaiwatana a munaḡa, mulinemo Yesu lava kumna nopodimo Diyon ena kauwa i giuwena gado, “Wala kona nawa Diyon lisinemo kalakalalelemo, bai kona noḡonoḡotina maso kona kita? Noḡota kulukuluva lavana ena noḡota mai leḡi yavala ya suvesuve lemana ee? ");
INSERT INTO kqf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Temi kona nawa te maso bai kona kita? Lava gala visuvisuna i kotekotena maso kona kita ee? Lava mabai mai sa wai galana ba tedi ḡalibona ena vanuwemo taumiya. ");
INSERT INTO kqf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ko giuwegu, kona nawa te bai kona kita? Taugiuwatana ee? Kamaina te giukauwa bi kona kitakitana i tausaḡana kaka taugiuwatana ḡesaudi. ");
INSERT INTO kqf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Diyon tana taunana gilugilumina wadubonemo i giuwatana gado, ‘Tagu kaka egu tauwainoyanoya yà gei giukamaḡe te em eta ya yawasi.’ ");
INSERT INTO kqf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Yà giugiuwemi te waivini a wainatunana nopodimo mote aiyai bamo Diyon i saḡa kamaḡe, bi geḡa te lava ani kita waiyovoyovo Maimaituwa ena waibada noponemo ya miyamiyana ba i tausaḡana kaka Diyon.” ");
INSERT INTO kqf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lava matabudi bi takis taulaitupana Yesu ena giu a vaivaiye te Maimaituwa giuna ba giukauwa, banina tedi kaikana Diyon i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bi geḡa te Palisi bi waiḡake tauwailovelovedi Maimaituwa ena ḡowana tedi lisidimo ba a daboke, taunana aubaina Diyon ena kabulu a daboke. ");
INSERT INTO kqf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bi Yesu giu i laumunaḡena gado, “Niga kimtimi bai yà laukoiluvaye? Kitedi mai bai? ");
INSERT INTO kqf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kitedi mai libilibi ani waiḡemota gabunemo sa miya bi sa waimuduveleyana: ‘Tama naḡi salena ke saleye bi mote ko biga bi kota peki salena ke saleye bi mote ko ḡaba.’ ");
INSERT INTO kqf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bi laḡannemo Diyon Taukabulu i tavana mote buledi i kanikani bi mote wain i tegotego ba kona giu te penama i sunei. ");
INSERT INTO kqf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tana Taunana Natuna i yovona ba i kanikani bi i tegotego bi kona giuna gado, ‘Ko kita tana kanikani yaviyavina bi tegotego yaviyavina, tana ba takisi taulaitupana bi gebogebo lavedi edi tau.’ ");
INSERT INTO kqf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Maimaituwa natunatuna ba lava mabai ena nuwauyauyamo sa miyamiyana.” ");
INSERT INTO kqf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi ḡemota Yesu i giuvai ena vanuwemo, te aubiga kanina sa kani. Kamaina bi Yesu i nawa Palisi ena vanuwemo bi i kenagiligili kani aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mba tauninemo gebogebo waivinina i miyamiya, bi i vaiye te Yesu Palisi ena vanuwemo i kanikani ba tana masi panepanena bi mai'ina dididigina dugina i avali tavaite. ");
INSERT INTO kqf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bi Yesu kaḡepakanemo i laudulu bi i ḡaba bi matasulunemo Yesu kaḡena i wai kwaukwaudi bi dabana doyonemo i yasayasaḡidi, i waisuluvedi bi masi panepanena kaḡenemo i ḡini. ");
INSERT INTO kqf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Laḡannemo Yesu taugiuvaina niga kauwina i kitakita ba taunaḡa i wainuwanoḡonoḡotana gado, “Bamoda tana taugiuwatana maso ba i sibe te waivini baibaina ya tautaukoni, te maso i sibe te tana waivini gebogebona.” ");
INSERT INTO kqf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu i giuwena gado, “Saimon, tagu bai yà ḡoeḡoena yà giuwem.” Bi Saimon i giuna gado, “Kamaina, Tauwailovelove ku giuwegu.” ");
INSERT INTO kqf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mane taniwagina olooloto labu loun i vitedi, ḡemota mane 500 dinali i vite bi ḡesauna 50 dinali i vite. ");
INSERT INTO kqf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tedi labuidi mote lisidimo mane te maso edi ḡaga ai maii, taunana aubaina mane taniwagina edi ḡaga i yasaḡi kamaḡedi. Kwa noḡonoḡoti te bamo olotona ena ḡoe i didiga gulata? ");
INSERT INTO kqf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon Yesu ena giu i waimunena gado, “Oloto ena mane 500 dinali i yasayasaḡi kamaḡena.” Yesu i giuna gado, “Tam kuna giukauwa.” ");
INSERT INTO kqf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ḡome Yesu i tauvitale waivini lisinemo bi Saimon i giuwena gado, “Tagu em vanuwemo e tava bi kaḡegu ani koḡana gaubina mote ku vitegu. Niga waivinina ku kita. Tana matasulunemo kaḡegu i waikwau bi dabana doyonemo i yasaḡidi. ");
INSERT INTO kqf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Laḡannemo e valagetana, tam mote ku waisuluvegu bi niga waivinina kaḡegu waisuluvena mote i kaisako. ");
INSERT INTO kqf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tam mote olip masina dabagumo ku ḡini, bi tana masi panepanena kaḡegumo i ḡini. ");
INSERT INTO kqf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Taunana aubaina yà giugiuwem te tana ena gebogebo wapewapedi Maimaituwa i noḡoti kamaḡedi, aubaina tana ena ḡoe Maimaituwa lisinemo i didiga gulata. Bi tana aiyai ena gebogebo ḡaubona Maimaituwa i noḡoti kamaḡena ba ena ḡoe Maimaituwa lisinemo i ḡaubo.” ");
INSERT INTO kqf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ḡome Yesu waivini i giuwena gado, “Em gebogebo e noḡoti kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bi lava ḡesaudi tedi taudiḡa ai giugiuna gado, “Niga aiyai lavana te lava edi gebogebo ya noḡonoḡoti kamaḡedi?” ");
INSERT INTO kqf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ḡome Yesu waivini i giuwena gado, “Em sumaḡa i waiyawasanim, bi manuwaubam kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Laḡan visa mulidimo Yesu i nawa taun bi malagai onediḡa, Maimaituwa ena waibada giuna visuvisuna i laulauguguyae. Tana ena tauwaikaiwatana 12 i waidolidi, ");
INSERT INTO kqf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","waiwaivini mabai wala aluwa gebogebodi a suneidi bi edi sidamo i waiyawasanidina vaitedi. Bi nopodimo ba Meli Magdalin vaitena, wala tana lisinemo aluwa gebogebodi 7 i kwavidi a potiyovo, ");
INSERT INTO kqf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bi Diyowena ba Usa mwanena bi Usa ba Alodi ena waiguyau tauwaibadayena, Susana bi waiwaivini ḡesaudi tedi taudidi edi waiguyau a natomedi bi Yesu ena tauwaikaiwatana vaitedi a sagusagudi. ");
INSERT INTO kqf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mba ḡome taun wapewapediḡa lava kumdi a tava Yesu waibeyavaiyena aubaina, tedi niga lautaulalana i giuwedi, ");
INSERT INTO kqf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Taubayau i nawa daibimo ena pesi launaḡasedi aubaina. Laḡannemo i laulaunaḡesedi ba ḡesaudi etamo anivavutuḡemo a talaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bi pesi ḡesaudi doḡa waitelitelinemo a talaḡa. Laḡannemo a kalakalanapu ba a welai te a poki banina doḡa tatakalinemo. ");
INSERT INTO kqf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bi pesi ḡesaudi gedala nopodimo a talaḡa te a duga saḡa bi gedala a yavanidi. ");
INSERT INTO kqf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bi pesi ḡesaudi doḡa visuvisunemo a talaḡa te a duga saḡa, bi a vota te votedi matabudi 100.” Laḡannemo niga giuna i waiwaikovi ba i giuna gado, “Aiyai waibeyam te kwai beyavaiya kauwa.” ");
INSERT INTO kqf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ena tauwaikaiwatana ai talaye te niga lautaulalana banina bai. ");
INSERT INTO kqf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Bi tana i giuwedina gado, “Temi i waianinemi te Maimaituwa ena waibada kenakena waidavonina sibena kaikana e vitemi. Lava ḡesaudi ba lautaulalamo ya giuwedi te sa kitakitana bi mote sima kita ḡone, sa vaivaiyena bi mote sima sibe.” ");
INSERT INTO kqf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Niga lautaulalana banina ba niga mainana: Pesi ba Maimaituwa giuna. ");
INSERT INTO kqf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bi pesi etamo a talatalaḡana ba tedi mabai giu a vaiye bi seitan ya tava te nopodimo ya kaikaikamaḡedi, te tedi mote simai sumaḡa bi sima yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bi doḡa waitelitelinemo a talatalaḡana ba tedi mabai giu a vaiye bi manuwavisudi sa vaivai bi geḡa te lamlamdi mote a yovo gulata. Tedi mote simai sumaḡa kauwa taunana aubaina, laḡannemo pilipili i tavana ba sa kulukuluva. ");
INSERT INTO kqf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bi pesi gedala nopodimo a talatalaḡana ba tedi mabai giu sa vaiye bi laḡannemo edi nuwalauwataḡa sa nawanawa ba niga dobuna ena waiguyau nuwaboyana ya yavayavanidi te mote sima votavota kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bi pesi doḡa visuvisunemo a talatalaḡana ba tedi mabai Maimaituwa giuna sa vaiye bi sa kaikaididina. Tedi yawasana visuvisunemo sa miyamiya bi sa votavota kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Lava piupiu i gabuna ba mote gulewemo imai kabubutawi e teibolo dibunemo ima sako. Kamaina te ḡakima dabanemo ya sako te lava mabai vanuwemo sa valavalagetana ba yanana sa kita. ");
INSERT INTO kqf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bamo te kandavonemo bai a voivoiyena kaka ya laumaḡata, bi bai sumamo ya kenakenana kaka sumana ya nuwatanesa. ");
INSERT INTO kqf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Taunana aubaina koi beyavaiya kauwa te giu banidi ko sibedi, banina tana aiyai bi lisinemo bai ya kenakenana ba dabanemo yai lautawi. Bi aiyai mote ima waibeyavaiya kauwa ba bai ḡaubona lisinemo ya kenakenana kaka sa kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu tinana bi valevaletina a tava kitana aubaina, bi mote ḡemoḡemotina te maso a sola nawa lisinemo banina lava kumna i didiga. ");
INSERT INTO kqf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ḡome lava ḡesauna Yesu i giuwena gado, “Tinam bi valevaletim didiyaumo sa moimoito bi sa ḡoeḡoena sa kitam.” ");
INSERT INTO kqf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kamaina bi Yesu giu i waimunena gado, “Tinagu bi valevaletigu ba tedi mabai Maimaituwa giuna sa vaiye bi sa kaikaiwata kauwena.” ");
INSERT INTO kqf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Laḡan ḡesaunemo Yesu ena tauwaikaiwatana i giuwedina gado, “Wagamo ko gelu bi ta nawa topa nevanemo.” ");
INSERT INTO kqf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kamaina bi tedi wagamo a gelu, a nawanawa ba Yesu i kena kwavu. Mba taunana te kaibitibiti i talaḡa, labama wagamo i waidubusaḡe bi ḡotona te maso a bulu. ");
INSERT INTO kqf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bi ena tauwaikaiwatana a nawa Yesu a lainuwesi bi a giuwena gado, “Bada, niga ta bulu!” Tana i kenamoito te yavala bi labama i giuḡavukidi, a lautautau te daumola i kena. ");
INSERT INTO kqf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kamaina bi ena tauwaikaiwatana i giuwedina gado, “Ko waisumaḡa e geḡa?” Tedi a sove bi manailidi taudiḡa ai giugiuna gado, “Niga lava baibaina te yavala bi labama i giuḡavukidi bi kalinana ai bade.” ");
INSERT INTO kqf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ena tauwaikaiwatana vaitedi wagaḡa a nawa Gelasin dobuna Galili topana noi nevanemo. ");
INSERT INTO kqf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Laḡannemo Yesu i potipotiyovo gelemo ba mba malagainemo aluwa gebogebona oloto i sunesuneina i tava Yesu lisinemo. Laḡan i lofa gulata niga olotona malagai i gose bi makofakofana tauyewaḡa i miyamiya nawa. ");
INSERT INTO kqf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bi laḡannemo oloto Yesu i kitakita ba magalalina kaḡepakanemo i kuluva bi i binauna gado, “Yesu, Maimaituwa Saḡasaḡa Guletina Natuna, bai lisigumo kwa voiye? Aee, yà waibaḡa vavasaḡem te mote kuma ka gebogebogu.” ");
INSERT INTO kqf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Niga mainana i giuna banina ba Yesu kaikana aluwa gebogebona i giuvavasaḡe te oloto ya potiyovo kamaḡe. Sauga tabutabuna aluwa gebogebona niga olotona i waibadabadaye. Avena te oloto nimana bi kaḡena laulauseinidi, tauyava a labelabe bi geḡa te aluwa gebogebona mba seinidi i waidouḡavuḡavukidi bi oloto i avali vai te i nawenawena dobu ḡuyuwidimo. ");
INSERT INTO kqf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bi Yesu oloto i waitalayena gado, “Isam bainewa?” Bi tana ena giu i waimunena gado, “Tagu isagu ba ke wapa gulata.” Tana mai i giuna banina aluwa gebogebodi wapewapedi a sunei. ");
INSERT INTO kqf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aluwa gebogebodi Yesu ai baḡavavasaḡe te mote ima giukamaḡedi sima nawa dom yovoyovo alealelenemo. ");
INSERT INTO kqf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bi mba modomodonemo buwawa yalaboluboludi, oya nevakaunemo a yabayaba. Bi aluwa gebogebodi Yesu ai baḡavavasaḡe te maso i waianinedi te buwawa nopodimo sa sola saḡa. Kamaina bi Yesu i waianinedi te a sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Laḡannemo aluwa gebogebodi oloto a potipotiyovo kamaḡe ba buwawa nopodimo a sola. Ḡome buwawa yalaboluboludi salisali a velavelauwatana ba topamo a bulu. ");
INSERT INTO kqf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Laḡannemo buwawa taulabedi niga kauwina a kitakita ba a velau a nawa taunimo bi diyadiyanaḡa te giu ai dabalali. ");
INSERT INTO kqf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kamaina bi bai i tubutubuḡana kitana aubaina lava a nawa. Sauginemo Yesu lisinemo a tavatava ba aluwa gebogebodi oloto a potipotiyovo kamaḡena a kita. Tana i waigala bi ena noḡota didimaninemo, Yesu kaḡepakanemo i miyamiya, bi tedi matabudi ba a naila gulata. ");
INSERT INTO kqf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bi tedi mabai oloto aluwa gebogebodi a sunesuneina lisinemo bai i tubuḡa bi a kitakitana lava ḡesaudi a giuwedi te bainewa Yesu oloto i waiyawasani. ");
INSERT INTO kqf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ḡome Gelesen dobuna lavedi matabudi, a naila gulata taunana aubaina Yesu ai baḡa vavasaḡe te edi dobu ya gose. Kamaina bi Yesu wagamo i gelu te i munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bi oloto aluwa gebogebodi a potipotiyovo kamaḡena Yesu i waibaḡa te maso vaitena a nawa. Bi geḡa te Yesu mba olotona i giuwena gado, ");
INSERT INTO kqf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kwa munaḡa te em vanuwa lavedi lisidimo bi kwa giuwedi te bainewa Maimaituwa i waiyawasanim.” Kamaina bi oloto taun i nawa yaḡosi bi bai Yesu lisinemo i voivoiyena taunana lava i giuwedi. ");
INSERT INTO kqf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bi lava Galili topana noi nevanemo a wailaba bi laḡannemo Yesu i munamunaḡa tava ba a giuvai. ");
INSERT INTO kqf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ḡome bolu vanuwina taulabena isana Diyailesi i tava Yesu lisinemo bi kaḡe pakanemo tuwapekana i waitupagwaliye bi i waibaḡa vavasaḡe te maso vaitena a nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Banina tana natuna waivinina lauḡemotina ena kwalabu ba 12 bi ḡotona te ya peki. Laḡannemo Yesu i nawanawa ba lava kumdi a tava a dubutawi. ");
INSERT INTO kqf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bi nopodimo ba waivini kwasina i miyamiya kamakamaḡena, kwalabu wapana 12 a kovi. Tana ena ḡonaḡona doketa lisidimo i waiyakali bi mote aiyai i waiyawasani. ");
INSERT INTO kqf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tana Yesu mulinaḡa i saḡa te ena gala isudamodamona i tautaukoni ba noi taunana te kwasina i miyamiya kamakamaḡena i kaisako. ");
INSERT INTO kqf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu i tauvitale bi lava i waitalayedina gado, “Gode aiyai i taukonigu?” Lava matabudi a valele bi Pita i giuna gado, “Bada, kuna kita te lava a dubutawim, sa bibibinim bi kuna giu te aiyai i taukonim.” ");
INSERT INTO kqf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu i lauyaviyavina gado, “Lava i taukonigu, taunana aubaina mayagu e vai te ḡailisi i gosegu.” ");
INSERT INTO kqf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Waivini i noḡoti munaḡe te tana Yesu i taukoni. Taunana aubaina tana manailina bi magusuna i saḡa Yesu kaḡe pakanemo te tuwapekana i wai tupagwaliye. Bi lava matabudi i giuwedi te bai aubaina tana Yesu i taukoni bi maḡemota mayana i vai te i yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bi Yesu waivini i giuwena gado, “Natugu em sumaḡa i waiyawasanim bi manuwaubam kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu yaḡolo waivini lisinemo i giugiu ba bolu vanuwina badana isana Diyailesi, ena vanuwemo lava i tava bi i giuwena gado, “Tauwailovelove kuma kaka nuwalaḡalaḡa natum kaikana i peki.” ");
INSERT INTO kqf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu niga giuna mainana i vaivaiye ba Diyailesi i giuwena gado, “Mote kumai nuwaboya, kwai sumaḡa ota bi tana kaka ya yawasana.” ");
INSERT INTO kqf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sauginemo Yesu Diyailesi ena vanuwemo i tavana ba lava matabudi i waiḡakedi te mote vaitedi a sola nawa, Kamaina Pita, Diyemesi, Diyoni bi gomenina tinana bi tamana taudiḡa a saḡa noke gomana lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lava matabudi ḡome gomenina ai nuwaboye te a ḡabeḡabe. Bi Yesu i giuwedina gado, “Ḡaba ko kaisako! Gomana mote i peki, tana ya kenakena ota.” ");
INSERT INTO kqf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bi tedi a sibe te gomana kaikana i peki, taunana aubaina te Yesu ai gwaigwaiye. ");
INSERT INTO kqf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ḡome Yesu gomana waivinina nimanemo i kabi bi i giuwena gado, “Natugu, ku kena moito.” ");
INSERT INTO kqf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ḡome gomana yawasina i tava munaḡa bi maḡemota i kena moito. Bi Yesu i giuwedi te bai sa vite ya kani. ");
INSERT INTO kqf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bi gomana tamana bi tinana a sove gulata, bi geḡa te Yesu i giuvavasaḡedi te bai i tubutubuḡana ba mote aiyai sima tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ena tauwaikaiwatana 12 i giuwedi a tava ai ḡemotidi, tana ḡailisi bi waibada i vitedi te aluwa gebogebodi matabudi sa kwavi vaidi bi lava edi sida tabudi bi tabudi sai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kamaina bi ena tauwaikaiwatana i giukamaḡedi a nawa te Maimaituwa ena waibada sa lauguguyae bi lava sidesidedi sai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tana niga mainana i giuwedi, “Ko nawanawana mote bai ḡesauna koma vai. Mote diḡona, mote tana, mote mane, mote kani bi mote kwama wailabuna koma vai. ");
INSERT INTO kqf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bamo vanuwinemo bi a giuvaimina ba vanuwinemo ko miyamiyana eete mba malagaina ko gose. ");
INSERT INTO kqf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bi bamo tauninemo mote lava sima giuvaimi ba sauginemo mba taunina ko gosegose ba kaḡemi gobusidi ko laikulukuludi te sauginemo bai i tubuḡana ba tedi edi wavu.” ");
INSERT INTO kqf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kamaina bi ena tauwaikaiwatana a modina a nawa malagai te malagai nopodiḡa giu visuvisuna a lauguguyae bi lava sidesidedi a waiyawasani nawedi. ");
INSERT INTO kqf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Laḡannemo Alodi Entipas bai matabuna i tubutubuḡana giuna i vaivaiye ba i tagugu bi i nuwalaḡalaḡa, banina lava a giugiu te Diyon taukabulu pekimo i kena moito. ");
INSERT INTO kqf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lava ḡesaudi a giugiu te bena Elaidiya i laumaḡata bi kota ḡesaudi a giugiu te bena kage taugiuwatana dolidolidi ḡemota i kenamoito munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Alodi i giuna gado, “Tagu wala Diyon gadona e koiḡavuki bi niga kota aiyai giuna yà vaivaiye.” Bi tana i ḡoeḡoe te maso i kita. ");
INSERT INTO kqf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sauginemo giugiukamaḡedi a munaḡa tava bi bai matabudi a voivoiyedina Yesu a giuvite. Kamaina bi tana i waidolidi te a vasoyavaidi a nawa Betsaida tauninemo. ");
INSERT INTO kqf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bi geḡa te lava kumdi a sibe te Yesu bamo maiḡa i nawa, taunana aubaina a kaiwata. Bi tana i giuvaidi te Maimaituwa ena waibada lisidimo i lauguguyae bi tedi mabai sidesidedi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mba aubiganemo ena tauwaikaiwatana 12 a tava lisinemo bi tana a giuwedina gado, “Niga ba dobu ḡuyuwina. Lava kwa giukamaḡedi te sa nawa malagaiḡa bi malagai diyediyediḡa te kani bi anikena sa banavi.” ");
INSERT INTO kqf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bi Yesu edi giu i waimunena gado, “Temi kani ko vitedi sa kani.” Bi tedi a giuwena gado, “Tama buledi wapedi 5 bi iyana labu ota. Bamoda mainana ba ka nawa te buledi ka gimala lava kumdi aubaidi.” ");
INSERT INTO kqf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mba ḡome olooloto wapana maso ba 5 tausan. Kamaina bi ena tauwaikaiwatana i giuwedina gado, “Ko dailidi te wapedi 50 edi dubuḡa sa miya nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kamaina bi ena tauwaikaiwatana bai i giugiuwedina mainana lava a giuwedi te matabudi a miyatulu. ");
INSERT INTO kqf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bi Yesu buledi wapedi 5 bi iyana labu i tanodi, i waikita saḡa malamo, Maimaituwa i waiebone bi i vili kivikividi te ena tauwaikaiwatana i vitedi te a soiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lava matabudi a kani te a kani nonoḡa. Bi lava buledi bi iyana a kanikani sivudina, a laitupedi te poa wapedi 12 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Laḡan ḡemota Yesu i laulaupali bi ena tauwaikaiwatana ba tana vaitena bi i waitalayedina gado, “Lava sa giugiu te tagu aiyai?” ");
INSERT INTO kqf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bi tedi a giuna gado, “Lava ḡesaudi sa giugiu te tam Diyon taukabulu, ḡesaudi sa giugiu te tam Elaidiya bi ḡesaudi sa giugiu te nove wala taugiuwatana mododimo ḡemota pekimo i kena moito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bi ena tauwaikaiwatana i waitalayedina gado, “Bi temi ko giugiu te tagu aiyai?” Pita Yesu ena giu i waimunena gado, “Tam ba Keliso Maimaituwa ena Vinevine.” ");
INSERT INTO kqf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ḡome Yesu ena tauwaikaiwatana i giuvavasaḡedi te niga giuna mote aiyai sima giuwe. ");
INSERT INTO kqf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tana kota i giuwedina gado, “Tana Taunana Natuna kaka kauwa wapewapedimo yai nuwatoi. Bi babada laukaidi, pilipilisi edi babada bi waiḡake tauwailovelovena babadidi, kaka sa daboke bi sai peki. Bi laḡan waifaioninemo kaka ya kenamoito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kamaina bi Yesu lava matabudi i giuwedina gado, “Aiyai bi kaiwatagu kuna ḡoena ba em ḡowana matabudi kwa gosedi, kwa vite munaḡem bi laḡan matabuna em kolosi kwa avali bi kwa kaiwatagu. ");
INSERT INTO kqf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tam aiyai bi em yawasana kuna nuwamunaḡena ba mote kaka kuma vai munaḡe, bi tam aiyai em yawasana kuna nuwakamaḡena tagu aubaigu kaka kwa vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lava bi niga dobuna ena yawasana matabuna kuna vai kovi bi em yawasana kuna aiwainawenawena ba bai visuvisuna kaka kwa banavi? Geḡa ota! ");
INSERT INTO kqf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bamoda tagu egu wailovelove mote lava lisidimo ku kamaḡati ba Tana Taunana Natuna, Tamana bi aneya waiwaiyawidi manamalidi sa yovona laḡannemo kaka tagu mote yà kamaḡatim. ");
INSERT INTO kqf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tagu yà giugiu kauwemi, te ḡesaumi niga ḡome mote kaka koma peki te Maimaituwa ena waibada ko kita.” ");
INSERT INTO kqf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tana wailovelove i waikovi bi i miyana laḡan 8 mulidimo, Yesu, Pita, Diyon bi Diyemesi i waidolidi bi vaitedi a saḡa a nawa oya dabanemo laupali aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laḡannemo i laulaupali ba matana i nuwavitala bi ena gala ba ai mata kanikanina maibena namanamali kemna. ");
INSERT INTO kqf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mba taunana te olooloto labu, Mousis bi Elaidiya, tedi manamalidi a laumaḡata bi Yesu vaitena a waigiugiu. ");
INSERT INTO kqf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tedi edi waigiugiu banina ba Maimaituwa ena ḡowana tana lisinemo ya tubuḡa te Yelusalemmo sai peki. ");
INSERT INTO kqf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ena lava vaitedi ba a waidule bi sauginemo matedi a yanayana ba Yesu namalina a kita bi olooloto labu tana vaitena a moimoito. ");
INSERT INTO kqf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Laḡannemo mba oloolotodi Yesu a gosegose ba ḡome Pita i giuna gado, “Bada, i visu kauwa te tama niga ḡome, augunai kape faiona ka voiyedi, te ḡemota tam aubaim, ḡemota Elaidiya aubaina bi ḡemota Mousis aubaina.” Pita mote i sibe te bai i giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita yaḡolo i giugiu ba giyou i laumaḡata te i sumatawidi. Tedi giyou i sumasumatawidi ba a naila kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kalina giyou noponaḡa i yovona gado, “Niga taunana Natu otigu tana taunana e vine, kalinana ko vaiye.” ");
INSERT INTO kqf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Laḡannemo kalina a vaiye mulinemo ba Yesu taunaḡa a kita ḡome i moimoito. Ena tauwaikaiwatana mba kauwina a kitakita ba nopodimo a sivudi bi mote aiyai a giuwe. ");
INSERT INTO kqf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bokina mai Yesu ena tauwaikaiwatana vaitedi oyamo bi a yovoyovo ba lava kumna a banavidi. ");
INSERT INTO kqf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bi nopodimo oloto ḡemota i binauna gado, “Tauwailovelove yà waibaḡam te natugu lauḡemotina kwa kita! ");
INSERT INTO kqf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Laḡannemo aluwa gebogebona ya sulusuluvai ba ya kaka gusugusu, ya kaka binabinau, ya waibutaleva bi ya voiye te gayanaḡa kasapulana sa yovoyovo. Bi aluwina mote bamo natugu ima gosegose. ");
INSERT INTO kqf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Em tauwaikaiwatana e giuwedi te maso a kwavivai bi mote ḡemoḡemotina te maso a voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu edi giu i waimunena gado, “Ei, niga kimtimi kona ala gebogebo bi mote koma waisumaḡa! Ee tagu yaḡolo te emi vita yà avaavali? Natumna ku natome lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Laḡannemo gomana a natonatome ba aluwa gebogebona gomenina doḡamo i waibui bi i katiti. Ḡome Yesu aluwa gebogebona i giu tunidaboke bi gomana i waiyawasani te tamana i vite munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lava matabudi Maimaituwa ena ḡailisi a soveye. Yesu bai matabuna i voivoiyena ba lava a sovesove bi tana ena tauwaikaiwatana i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Koi beyavaiya kauwa te bai yà giuwemi! Tana Taunana Natuna kaka lava nimedimo sa sakona laukivigebogeboyena aubaina.” ");
INSERT INTO kqf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tedi bai i giugiuwedina banina mote a sibe. Giuna lisidimo i kena waidavona, taunana aubaina maso ai talaye bi geḡa te a naila. ");
INSERT INTO kqf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu ena tauwaikaiwatana taudiḡa a waikagiu te nopodimo aiyai i saḡa gulata. ");
INSERT INTO kqf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bi Yesu kaikana edi noḡota i sibedi, taunana aubaina gomana i vai te diyanemo i waimoito, ");
INSERT INTO kqf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bi i giuwedina gado, “Aiyai bi niga gomenina ḡaubona isagumo ya giuvaina ba tagu ya giugiuvaigu bi kota aiyai bi tagu ya giugiuvaiguna ba yaḡolo taugiukamaḡegu ya giugiuvai. Aiyai bi nopomimo i ḡaubo munaḡana mai niga gomenina tana taunana i saḡa gulata.” ");
INSERT INTO kqf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kamaina bi Diyon i giuna gado, “Bada, tama oloto ke kita isammo aluwa gebogebodi i kwavikwavivaidi bi ke giuwe te maso i kaisako, banina tana mote tada vaiteda.” ");
INSERT INTO kqf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bi Yesu i giuwedina gado, “Komai ḡake, tana aiyai mote ima waiḡaviyemi ba emi tau.” ");
INSERT INTO kqf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kamaina bi sauga kaikana ya tavatava te Maimaituwa Yesu ya nawe malamo. Bi tana ena noḡota i sakodidi te ya nawa Yelusalem. ");
INSERT INTO kqf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tana tauwainoyanoya i gei giu kamaḡedi a nawa Sameliyamo lava sa tai nuwataudi te ena tava aubaina sa vononoḡa. ");
INSERT INTO kqf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bi geḡa te lava ḡome mote a giuvai banina tana Yelusalem aubaina i nawanawa. ");
INSERT INTO kqf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Laḡannemo ena tauwaikaiwatana Diyemesi bi Diyoni niga kauwina a kitakita ba ai talayena gado, “Bada, kwai aninemai te ka giu saḡa bi malaḡa kai ya yovo te ya kalaḡosedi.” ");
INSERT INTO kqf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bi geḡa te Yesu i tauvitale bi i kaipasinedi ");
INSERT INTO kqf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","bi ena tauwaikaiwatana vaitedi a nawa malagai ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Laḡannemo tedi etaḡa a nawanawa ba oloto Yesu i giuwena gado, “Tam bamomaiḡa kwa nawana ba yà kaiwatam.” ");
INSERT INTO kqf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bi Yesu i giuwena gado, “Dako waibwadedi, kota mwanuwa sawasawamo ba wainoḡidi bi Tana Taunana Natuna mote bamo ena gabu kauwa te yai yawasi.” ");
INSERT INTO kqf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bi Yesu oloto ḡesauna i giuwena gado, “Ku kaiwatagu.” Bi tana Yesu ena giu i waimunena gado, “Bada, kwai aninegu te yà nawa tamagu pekina yà gei dobo.” ");
INSERT INTO kqf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bi Yesu i giuwena gado, “Avena, pekipekidi taudiḡa edi peki sa dobodi. Bi tam kwa nawa te Maimaituwa ena waibada kwa lauguguyae.” ");
INSERT INTO kqf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bi kota lava ḡesauna i giuwena gado, “Bada, yà kaiwatamna bi dolinemo yà nawa te egu vanuwa lavedi yài ebonedi.” ");
INSERT INTO kqf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bi Yesu giu i waimunena gado, “Tana aiyai suwata i waitubu bi ya tinatinamulina ba mote ḡemoḡemotina te Maimaituwa ena waibadamo ima noya.” ");
INSERT INTO kqf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Niga kauwina mulinemo Yesu tauwaikaiwatana ḡesaudi 72 i vinedi te bamo taunidi bi malagaidiḡa muliḡa ya nawana maiḡa labulabuḡa i gei giukamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bi i giuwedina gado, “Maula i didiga bi taunoya a labuḡa. Taunana aubaina daibi Badana lisinemo ko laupali te taunoya ya giukamaḡedi te ena daibi sa vililubu. ");
INSERT INTO kqf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kamaina ko nawa, tagu yà giugiukamaḡemina mai sipu lauewalidi, ḡamoḡamo ḡasiḡasidi kitedi mai daḡasi nopodimo. ");
INSERT INTO kqf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Temi mote mane solusoluguduna, ee tana ee kaḡesuma koma legaudi bi mote aiyai vaitena etamo komai bolubolu.” ");
INSERT INTO kqf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Laḡannemo bamo vanuwinemo kona valagetana ba ko gei giuna gado, ‘Nuwauba niga vanuwinemo. Diu lavedi edi lausuwata ba matediḡa sa nawanawa mote sima tinatinamuli ");
INSERT INTO kqf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bamo te ḡome nuwauba lavana ya miyamiya, ba kamaina te em nuwauba giuna lisinemo ya kena. Bamoda geḡa ba emi nuwauba giuna ko vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bi vanuwinemo ko miyamiya bi bai sa vitevitemina taunana ko kani bi ko tego bi mote komai vanuwa saḡa. Banina taunoya edi maiia ba sa vai.” ");
INSERT INTO kqf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bamo tauninemo kona tava bi a giuvaimi, bi bai a vitevitemina taudidi ko kanidi. ");
INSERT INTO kqf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bi ḡome lava sidesidedi koi yawasanidi bi ko giuwedina gado, ‘Maimaituwa ena waibada kaikana i tava.’ ");
INSERT INTO kqf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bi bamo taunidi mote sima giuvaimi ba ko nawa etamo bi ko giuna gado, ");
INSERT INTO kqf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Emi tauni gobusina kaḡemaimo i laulaupatuna ka lailaikulukuluvidi te ko sibe. Banina Maimaituwa ena waibada saugina i tava bi kona daboke. ");
INSERT INTO kqf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tagu yà giugiuwemi, te etala laḡannemo mba taunina yà kovoḡi gulatena kaka Sodom.’” ");
INSERT INTO kqf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“I gebo kauwa Kolasin bi Betsaida lavemi lisimimo, bamoda Taiya bi Sidon nopodimo anisove kauwidi e voiyedi mai temi lisimimo e voivoiyedina, tedi maso kaikana udi galedi a kotedi, ai kovu topedi bi a kamaḡati munaḡedi te edi gebogebomo a kuvasa. ");
INSERT INTO kqf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Etala laḡannemo, temi Maimaituwa ya kovoḡi gulatemina kaka Taiya bi Sidon. ");
INSERT INTO kqf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bi temi Kapeniyam lavemi, ko wainoḡota te bena ko nawa Malamo, ee? Geḡa, temi ko nawa lava pekipekidi edi gabumo.” ");
INSERT INTO kqf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bi Yesu ena tauwaikaiwatana i giuwedina gado, “Aiyai emi giu ya vaivaiyena ba tagu egu giu ya vaivaiye. Bi aiyai temi ya miyamiyatautauliyemina ba tagu ya miyamiyatautauliyegu. Bi kota aiyai i miya tautauliyeguna ba taugiukamaḡegu ya miyamiya tautauliye.” ");
INSERT INTO kqf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bi laḡannemo lavedi 72 mayasisidi a munaḡa tava bi a giuwena gado, “Bada, isammo aluwa gebogebodi a voteyateyaemai.” ");
INSERT INTO kqf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bi Yesu giu i waimunena gado, “Tagu malamo Seitan e kita i kuluvana maibena namanamali. ");
INSERT INTO kqf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tagu waibada e vitemi te mwata wailauonedi bi tikutikula ko vaḡoseḡosedi bi ḡaviya edi ḡailisi matabudi ko vawaiubedi: Mote bai kaka ima ka gebogebomi. ");
INSERT INTO kqf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bi penama a vovoteyeteyemina mote komai nuwavisuyedi. Bi ko yasisi te isemi malamo a gilumidi.” ");
INSERT INTO kqf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mba sauginemo Aluwa Waiyawemo Yesu nopona yasisi i waiwanavu, bi i giuna gado, “Tamagu, yà kakasaḡesaḡem. Tam mala bi dobu Badana, taunana aubaina nuwauyauya bi sibe lavedi lisidimo niga kauwidi kuna sivu waidavonedi bi lava edi yawasana maibena libilibi lisidimo kuna kamaḡati. Tamagu, giukauwa te niga tam em ḡowana. ");
INSERT INTO kqf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamagu mwali matabudi i vitegu. Aiyai mote Natuna i sibe te tana Tamana taunaḡa. Mainana kota aiyai mote Tamana i sibe te tana Natuna taunaḡa. Bi tedi mabai Natuna i vinevinedina ba tedi taudidi Yesu sa kamaḡati.” ");
INSERT INTO kqf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu i tauvitale bi ena tauwaikaiwatana taudiḡa i giuwedina gado, “Kakavisuvisudi kaka bai ko kitakitana sa kita. ");
INSERT INTO kqf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kamaina yà giugiuwemi te bai ko kitakitana ba taugiuwatana bi ḡalibona wapewapedi a ḡoeḡoena maso kauwina a kita bi mote a kita. Bi giu ko vaivaiyena a ḡoeḡoena maso a vaiye bi mote a vaiye.” ");
INSERT INTO kqf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laḡan ḡemota waiḡake tauwailovelovena Yesu nuwana wailausoluna aubaina i tava bi i waitalayena gado, “Tauwailovelove, bai yà voiye te yawasana kenakena nonoḡina yà vai?” ");
INSERT INTO kqf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ena giu i waimunena gado, “Waiḡake bainewa a gilumidi? Tam waiḡakena kwa iyeiyevina banina kwa sibesibe, ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bi olotona giu i waimunena gado, “BADA em Maimaituwa kwa ḡoena ba: Nuwapoum tabutabunemo, aluwim tabutabunemo, em ḡailisi tabutabunemo, em noḡota tabutabunemo bi kota em tau kwa ḡoena maibena taumḡa kwa ḡoeḡoemna.” ");
INSERT INTO kqf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu oloto ena giu i waimunena gado, “Mba kuna giukauwa, laḡan matabuna kwa voiye bi yawasana kwa vai.” ");
INSERT INTO kqf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bi waiḡake tauwailovelovena i ḡoeḡoena ya sibe kauwe te Yesu i waitalayena gado, “Bamo taunana egu tau?” ");
INSERT INTO kqf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bi Yesu waititikunamo oloto ena giu i waimunena gado, “Oloto ḡemota Yelusalemmo bi i yovo i nawanawa Deliko bi etamo taudanene a lovo tava te a kaididi, ena gala a doulisi kamaḡedi bi a kwapu kauwe te nuwana peki bi a gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kamaina bi Pilisi mba etana ḡemotina i kaiwata i yovo i nawanawa te oloto nuwakalunaḡa i kita bi i kita kamaḡe te eta nevanaḡa i yovo i nawa. ");
INSERT INTO kqf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mulinemo kota Livai etana ḡemotina i kaiwata i yovo i nawanawa, te olotona i kita bi i kita kamaḡe bi eta nevanaḡa i yovo i nawa. ");
INSERT INTO kqf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bi Sameliya olotona mba etanaḡa i yovoyovo te olotona nuwakalunaḡa i vabanavi i kenakena te i launuwatoiye. ");
INSERT INTO kqf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamaina bi i nawa oloto lisinemo bi boninemo olip masina bi wain i ḡinidi bi gala selipidimo i panidi. Bi i lageti te ena donkimo i waigelu te i nawe balekimo. Ḡome tauwailaba nimanemo i sako te ya labe. ");
INSERT INTO kqf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Laḡan i sako te mane isana dinali labu i kaikamaḡedi te baleki taulabena i vite bi i giuwena gado, ‘Kwa labe kauwe bi laḡannemo yà tava munaḡana kaka bai kuna voivoiyena luvanemo yài mai'im.’” ");
INSERT INTO kqf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu waiḡake tauwailovelovena i waitalayena gado, “Kuna sibe te niga lavedi faiona nopodimo bamo taunana taudanene oloto a laulau kivigebogeboyena lisinemo waitau ena kauwa i voiye?” ");
INSERT INTO kqf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Waiḡake tauwailovelovena giu i waimunena gado, “Tana aiyai i waiwaisaguna.” Ḡome Yesu i giuwena gado, “Tam kwa nawa bi mainana kwa voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ena tauwaikaiwatana vaitedi a nawanawa Yelusalem aubaina, te malagai ḡesaunemo i tava. Bi ḡome waivini isana Mata i giuvai te vanuwemo i valageta. ");
INSERT INTO kqf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bi waivinina tasina isana Meli, tana Yesu kaḡepakanemo i miya bi ena giu i waibeyavaiye. ");
INSERT INTO kqf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bi Mata tana noya matabuna i voivoiye, taunana aubaina i nato Yesu lisinemo bi i giuwena gado, “Bada, kwa kitakitagu ee geḡa te tasigu i gosegu bi tauguḡa yà noyanoya? Bi kwa giuwe te ya sagugu.” ");
INSERT INTO kqf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bada, Mata ena giu i waimunena gado, “O egu tau Mata, tam mwali matabudi kwa ala wainuwaboyedi bi kwa kaka nuwalaḡalaḡam. ");
INSERT INTO kqf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vaivai ḡemota ota taunana i visu bi Meli vaivaina i kulamatai bi mote aiyai kaka lisinemo ima kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sauga ḡemota Yesu gabu ḡesaunemo i laulaupali. Bi laḡannemo pali i kovikovi ba ena tauwaikaiwatana ḡemota i giuwena gado, “Bada, kwai lovemai te tama maso mainana ke laupali, maibena Diyon ena tauwaikaiwatana i wailovedina mainana.” ");
INSERT INTO kqf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu i giuwedina gado, “Laḡannemo ko laupalina ba niga mainana ko giu: Tamamai, isam waiyawa sa vivile. Tam em waibada ya nato. ");
INSERT INTO kqf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Laḡan matabuna ema kani kwa vitemai. ");
INSERT INTO kqf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bada ema gebogebo kwa noḡoti kamaḡedi, banina tama kota ema lava lisimaimo gebogebo a voivoiyedina ka noḡonoḡoti kamaḡedi. Bi laulubumo mote kuma nawemai.” ");
INSERT INTO kqf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ḡome Yesu i giuwena gado, “Ḡemoḡemotina maso ḡesaum dudubala modonemo kuna nawa em tau lisinemo, bi kuna giuwena gado, ‘Goma, buledi faiona ku vitegu, ");
INSERT INTO kqf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","banina egu tau i nawanawa niganana i tava, bi tagu lisigumo mote kani te maso e vite.’ ");
INSERT INTO kqf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bi em tau vanuwa noponemo maso em giu i waimunena gado, ‘Kuma lailainuwanuwasa, tama kaikana ke laugudu, bi natunatugu vaitedi ka kenakena. Mote ḡemoḡemotina yàma kena moito bi bai yàma vitem.’” ");
INSERT INTO kqf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ḡome Yesu i giuna gado, “Yà giugiuwemi te mote maso i moito bi buledi i vite, banina i sibe te tana ena tau. Bi ena laukalayaviyavi dabanemo kaka ya moito bi buledi ya vite. ");
INSERT INTO kqf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Taunana aubaina yà giugiuwemi, koi baḡana ba ya vitemi, ko tavuḡena ba ko banavi, bi ko laupewapewana ba lisimimo gudu ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Banina mabai sa waibaḡana kaka sa vai, aiyai ya tavutavuḡena kaka ya banavi bi aiyai ya laulaupewapewana kaka lisinemo gudu ya kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mote bamo mai kauwa te gomana iyana i ḡabeḡabe bi tamana mwata i vite, ");
INSERT INTO kqf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ee pou i ḡabeḡabe bi tamana tikutikula i vite. ");
INSERT INTO kqf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Temi niga kauwina ko noḡoti, avena te gebogebo lavemi bi yaḡolo te natunatumi puyo visuvisudi vitedi kona sibe. Taunana aubaina Tamemi malamo tana ḡemoḡemotina, mabai Aluwa Waiyawa sa waibaḡena kaka ya vitedi.” ");
INSERT INTO kqf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu oloto noponemo gumgum penemina i kwavivai. Bi laḡannemo penama oloto i potipotiyovo kamaḡe ba tana giu i waitubu munaḡe. Bi ḡome lava kumna tana a soveye. ");
INSERT INTO kqf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bi kota lava ḡesaudi a giuna gado, “Mba taumudulele ḡailisi i vite, te penama ya kwavikwavivaidi.” ");
INSERT INTO kqf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bi lava ḡesaudi tana laulubumo ai talaye, te maso anisove kauwina i voiye bi maso aikawa giukauwe, te tana Maimaituwa lisinaḡa i yovo. ");
INSERT INTO kqf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bi geḡa te Yesu edi noḡota i sibedi aubaina i giuwedina gado, “Dobu ḡemota bi taudiḡa sa daili munaḡedina ba sa kagebogebodi. Mainana kota vanuwa ḡemota lavedi taudiḡa sai miyataulina ba mote edi miya ima visu.” ");
INSERT INTO kqf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mainana kota seitan falona seitan vaitena sa dailidi bi sai ḡasiḡasina ba mote kaka ena waibada ima kena gulata. Niga e giuna banina temi kage ko giugiu te tagu taumudulele ḡailisi i vitegu bi penama yà waipotiyovodi. ");
INSERT INTO kqf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bamoda taumudulele bi ena ḡailisimo penama yà waipotiyovodi ba temi palisi aiyai ena ḡailisimo emi tauwaikaiwatana penama sa waipotiyovodi? Emi tauwaikaiwatana sa kaka maḡatimi te temi kaikaiyovumi! ");
INSERT INTO kqf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bamoda tagu, Maimaituwa nima kiukiunemo penama ya waipotiyovodi. Ba ya kaka maḡatigu te Maimaituwa ena waibada kaikana lisimimo i tava. ");
INSERT INTO kqf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Laḡannemo bi oloto ḡaiḡailisina ena apiya i vononoḡedi bi ena vanuwa ya labelabena, ba ena ḡonaḡona sa kena kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bi bamoda oloto ḡesauna ḡaiḡailisi guletina mote mai tana mba olotona i lauyovoḡena ba, ena apiya i waisumaḡedina ya tano kamaḡedi. Bi ḡoneḡonedi matabudi ya soiye waipaipailidi. ");
INSERT INTO kqf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tana aiyai mote tagu vaitegu ba kagu ḡaviya. Bi kota tana aiyai mote vaitena kama noyanoya ḡemota ba tana taulaidabalala. ");
INSERT INTO kqf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Laḡannemo aluwa gebogebona lava i potiyovo kamaḡe, bi dobu tatakalidiḡa gabu ya tavutavu te maso yai yawasi, bi bamo mote gabu kauwa i banavi, ba taunaḡa i giu munaḡena gado, ‘I visu te tagu yà munaḡa egu vanuwa e gosegosenemo.’ ");
INSERT INTO kqf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bi laḡannemo i tava vanuwa i gosegosenemo, ba i kita te laulauḡiliḡilina bi kakanonoḡina. ");
INSERT INTO kqf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kamaina bi i munaḡa te aluwa gebogebo otidi 7 i waidoli tavaitedi mote mai tana. Bi sa sola nawana lavana noponemo ba mba lavana ena yawasana ya pilipili gulatana kaka dolinemo.” ");
INSERT INTO kqf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu yaḡolo niga kauwidi i giugiuwedi ba waivini lava kumna nopodimo i binauna gado, “Waivini kakavisuvisuna ba tana aiyai i bewam bi i waisusumna.” ");
INSERT INTO kqf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bi Yesu, waivini ena giu i waimunena gado, “Geḡa, kakavisuvisudi ba tedi mabai Maimaituwa giuna sa vaivaiye bi sa kaikaiwatana.” ");
INSERT INTO kqf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bi lava kumna a wapawapa gulata ba Yesu i giuna gado, “Niga kimtimi kona ala gebo te mataila ko waibaḡae. Mote mataila ḡesauna yàma voiye bi Diyona ena mataila taunaḡa ko kita bi ko noḡoti. ");
INSERT INTO kqf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Banina Ninive lavedi edi mataila ba Diyona bi kota mainana niga kimtimi, emi mataila ba Tana Taunana Natuna. ");
INSERT INTO kqf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bi etala laḡannemo, Siba edi ḡalibona waivinina kaka ya moito saḡa bi temi kimtimi yai wavumina banina tana manekaḡa i tava, Solomon ena nuwauyauya giudi vaiyedi aubaidi. Bi aiyai temi vaitena ko miyamiyana tana taunana i saḡa gulatana kaka Solomon. Bi kalinana mote koma vaivaiye. ");
INSERT INTO kqf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Etala Laḡannemo Ninive lavedi niga kimtimi sai wavumina banina tedi Diyona ena lauguguyemo a laukuvasa. Bi tana aiyai niganana vaitena ko miyamiyana tana taunana i saḡa gulatana kaka Diyona. Bi temi laukuvasa mote koma ḡoeḡoe. ");
INSERT INTO kqf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Aiyai mote kwadam imai tuni bi ima sako waidavo ee gulewa dibunemo imai kabubutawi. Geḡa, mote mainana, tana kwadam ena ani moitomo yai moito, te lava sa valavalagetana yanana sa kita. ");
INSERT INTO kqf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bi tubuḡim ena kwadam ba matam. Laḡannemo matam bi visuvisudi ba tubuḡim matabuna ya yana. Bi kota laḡannemo matam a gebogebona ba tubuḡim matabuna yai dudubala. ");
INSERT INTO kqf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Taunana aubaina yana nopommo kwa labe kauwe te mote imai dudubala. ");
INSERT INTO kqf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bamoda tubuḡim matabuna yanayana i yana galamena, ba tubuḡim mote imai dudubala bi ya yana gulata, maibena kwadam yanana.” ");
INSERT INTO kqf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Laḡannemo Yesu giu i waiwaikovi, ba Palisi ḡesauna tana i giuvai nawe ena vanuwemo te vaitena sa kani: Kamaina bi i valageta vanuwemo bi teibolo diyanemo i kenagiligili bi a kanikani. ");
INSERT INTO kqf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bi ḡome Palisi i sove te Yesu nimana mote i koḡedi bi i kanikani. ");
INSERT INTO kqf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kamaina bi Bada i giuwena gado, “Temi Palisi ledu bi aboma taulidi koḡedi kona sibe kauwedi bi nopomimo ba kanitoku bi gebogebo kauwidi a wanavu. ");
INSERT INTO kqf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“Temi opeopemi! Kona sibe ee geḡa te Maimaituwa tubuḡa bi kota nopo i voiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bi bai aboma noponemo ya kenakenana taunana waiyamoyamonidi ko vitedi kaka emi yawasana sa visu. ");
INSERT INTO kqf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“I gebo kauwa temi Palisi lisimimo, banina kani ani taidinidinidi bi dubu wai 10 na Maimaituwa vitena kona sibe kauwe. Temi mote lava koma labelabe kauwedi bi Maimaituwa mote koma ḡoeḡoe. Niga taudidi ko voiyedi bi vite Maimaituwa lisinemo koma sakoliye. ");
INSERT INTO kqf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“I gebo kauwa temi Palisi, banina temi ko ḡoeḡoe te animiya visuvisudimo ko miya, bolu vanuwidimo. Bi kota ko ḡoeḡoe lava sa vivilemi aniwaiḡemota gabudimo. ");
INSERT INTO kqf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“I gebo kauwa, banina temi ba maibena kokowaga waimataila geḡedi, dabediḡa lava sa nawanawa bi mote sima sibesibedi.” ");
INSERT INTO kqf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Waiḡake tauwailovelovena ḡemota Yesu i giuwena gado, “Tauwailovelove, laḡannemo niga kauwidi kuna giugiuwedi ba tama kota vaitemai kuna lauyovoḡemai.” ");
INSERT INTO kqf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu giu i waimunena gado, “Temi waiḡake tauwailovelovena, i gebo kauwa, te emi giumo lava ko waivitedi. Bi vitedi mote ḡemoḡemotidi te sa avala bi mote bamo koma sagusagu lubudi. ");
INSERT INTO kqf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“I gebo kauwa, banina emi magumagula wala taugiuwatana ai pekidi. Bi temi niganana edi ai kaukauwina ḡemotinemo mba tauyewidi ko kaka visuvisudi. ");
INSERT INTO kqf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","“Bi ko kaka maḡatimi te emi magumagula bai a voivoiyena ba ko waianinedi, banina tedi taugiuwatana ai pekidi bi temi edi tauyewa ko lailaivaliudi. ");
INSERT INTO kqf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Taunana aubaina Maimaituwa ena nuwauyauyamo i giuna gado, ‘Tagu kaka taugiuwatana bi giugiukamaḡedi yà giukamaḡedi te ḡesaudi sai pekidi bi kota ḡesaudi sa laukivigebogeboyedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Nove laḡan pakanemo te niganana, lava taugiuwatana ai pekidi bi kwasinidi a tositosina, aubaina te temi niga kimtimi kaka kovoḡa ko vai. ");
INSERT INTO kqf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wala Eibol ena pekimo te i saḡa Sakalaiya lisinemo. Bi Sakalaiya tana olta bi pali vanuwina mododimo ai peki. Ya giugiu kamaḡemi te niga kimtimi kaka pekidi matabudidi kovoḡidi ko vai. ");
INSERT INTO kqf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“I gebo kauwa temi waiḡake tauwailovelovena, banina temi sibe ki-ina kona vai bi ko kaikaididi. Temi otimi mote ko sola nawa bi mabai sa solasola nawana temi ko moimoito gudugududi.” ");
INSERT INTO kqf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Laḡannemo Yesu mba malagaina i gosegose ba palisi bi waiḡake tauwailovelovena lauyovoḡe giudimo tana ai tala vitavitale. ");
INSERT INTO kqf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tedi a ḡoeḡoena maso Yesu bai giuna gebogebona i vato wapa te a kaididi. ");
INSERT INTO kqf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mba laḡannemo, lava wapewapedi tausan ai ḡemotidi, taunana aubaina edi lava dabediḡa a waikavutuvutuḡa. Yesu ena tauwaikaiwatana i gei giuwedina gado, “Palisi edi waikaikaiyovumo ko kita kauwa te ko vola kamaḡedi. Tedi edi yawasana maibena muu'a, ya waitaudamadama makamakai.” ");
INSERT INTO kqf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mwali bai sumasumana kaka ya nuwa tanesa bi mwali bai kenakena waidavonina kaka Maimaituwa ya kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mwali bai dudubalemo kuna vatona kaka suwalemo sa vaiye. Mwali bai nakanaka noponemo kona waikasakasavenayena kaka debamo sai noyanoyae. ");
INSERT INTO kqf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Egu lava, yà giugiuwemi te tubuḡa taunaḡa tauwaipekina mote koma nailedi. Mba mulinemo mote kaka bai ḡesauna sima voiye. ");
INSERT INTO kqf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bi tagu kaka yài lovemi te aiyai ko naile, banina tana ḡailisi lisinemo ya kenakena te tubuḡa ya ka gebogebo bi ya pwalaḡe nawemi iyoyoḡamo. Emaso, yà giugiuwemi te Maimaituwa taunaḡa ko naile. ");
INSERT INTO kqf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mavumavuyama wapedi 5 ba luvana peni labumo kwa gimelidi, bi geḡa te Maimaituwa mote mavumavuyama ḡemota kaka nuwana ima kauleya. ");
INSERT INTO kqf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Temi mainana kunumimo, dabemi matabudi iyeiyevi waipailidi. Mote koma naila banina temi kona tausaḡana kaka mba mavumavuyamidi. ");
INSERT INTO kqf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yà giugiuwemi te aiyai bi lava wapewapedi matedimo ya giugiu waimaḡatiguna, ba Tana Taunana Natuna kaka Maimaituwa ena aneya matedimo yà kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bi tana aiyai lava wapewapedi matedimo ya valevaleleguna ba Tana Taunana Natuna kota mainana Maimaituwa ena Aneya matedimo yà valeleye. ");
INSERT INTO kqf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Lava aiyai Tana Taunana Natuna i giu waigebogebona ba Maimaituwa ena gebogebo ya noḡoti kamaḡe. Tana aiyai bi Aluwa Waiyawa i waidiboḡina ba Maimaituwa ena gebogebo mote ima noḡoti kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Laḡannemo bolu vanuwidimo a tavaitemi bi waibabada matedimo ai moitomina ba komai nuwaboya te bai ko giuwe ee bainewa ko koi galagalamemi, ");
INSERT INTO kqf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","banina Aluwa Waiyawa kaka yai lovemi te mba sauginemo bai ko giuwe.” ");
INSERT INTO kqf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lava kumna nopodimo oloto ḡemota Yesu i giuwena gado, “Tauwailovelove, valetigu kwa giuwe te tamamai gagasina ya soiye te tana bi tagu.” ");
INSERT INTO kqf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bi Yesu giu i waimunena gado, “Goma, tagu mote egu giu bai te yà laididimanimi ee tamemi ena ḡonaḡona yà dailidi temi labu poumimo.” ");
INSERT INTO kqf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kamaina bi Yesu i giuwedina gado, “Koi kita bi ko labe kauwemi te niga dobuna ena ḡonaḡona mote nopomi simai wanavudi, banina niga mwalidimo yawasana mote koma vai.” ");
INSERT INTO kqf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kamaina bi Yesu niga lautaulalana i giuwedi: “Maimaso oloto ḡemota waiguyauna, tana ena daibimo kani a lau bani kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tana taunaḡa i wainuwanoḡonoḡotana gado, ‘Tagu mote bamo gabu te egu kani matabudi yà susuḡudi.’ Niganana bai yà voiye? ");
INSERT INTO kqf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bai yà voiyena ba egu kani vanuwidi keikelikidi yà suwedi bi launanakidi yà kelidi. Ḡome kaka kani yà susuḡudi bi egu ḡonaḡona matabudi yài dubudi. ");
INSERT INTO kqf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kamaina bi yà giu munaḡeguna gado, ‘Tagu niganana mwali visuvisudi e sivudi, kwalabu wapawapa aubaidi. Niganana yà miya ota, yà kani, yà tego bi yài nuwavisu.’ ");
INSERT INTO kqf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bi geḡa te Maimaituwa oloto i giuwena gado, ‘Tam opaopam! Niga dudubalinemo kaka kwa peki. Bi bai kuna vovononoḡedina kaka aiyai ya legaudi?” ");
INSERT INTO kqf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu giu i waikenana gado, “Tedi mabai dobu ḡoneḡonedi sa laulaususuḡudina taudiḡa aubaidi ba Maimaituwa matanemo mote ai guyau.” ");
INSERT INTO kqf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kamaina bi Yesu ena tauwaikaiwatana i giuwedina gado, “Taunana aubaina yà giugiuwemi te tubuḡimi aubaina mote komai nuwaboya, te bai ko kani bi ko miya ee bai ko kote. ");
INSERT INTO kqf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Banina yawasana i tausaḡana kaka kani bi tubuḡimi i tausaḡana kaka gala. ");
INSERT INTO kqf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aoao ko kitedi: Tedi mote pesi sima wadiwadidi ee kediya sima laulau voti. Tedi mote sima laulaususuḡu bi edi susuḡu vanuwidi geḡa. Bi geḡa te Maimaituwa ya waikanidi. Temi kona tausaḡana kaka aoao! ");
INSERT INTO kqf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tam aiyai bi niga mwalidi kwa wainuwaboyaedina bena em miya ya lofa, ee? Geḡa! ");
INSERT INTO kqf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bamoda, mote ḡemoḡemotim mba mainana mwali ḡaubona kuma miyae, te bai aubaina mwali ḡesaudi kwa wainuwaboyaedi? ");
INSERT INTO kqf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Bodu belenidi sa dugadugana ko kitedi: Tedi mote sima noyanoya ee edi gala sima voivoiyedi. Bi yà giuwemi te, ḡalibona Solomon ena waiguyau galedi bi ena waigala mote a visu gulata maibena niga belenidi namalidi, tedi a tausaḡana kaka ḡalibona Solomon ena waiguyau galedi. ");
INSERT INTO kqf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Maimaituwa taunaḡa ḡawaḡawa wapumo kulidi visuvisudi ya voivoiyedi. Bi ḡaweḡawedi niganana niga ḡome bi bokina kaimo sai kalaḡosedi. Kona sibe e geḡa, te Maimaituwa kaka yai galemi? Emi sumaḡa a ala keikeilika! ");
INSERT INTO kqf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Laḡan matabuna mote komai nuwaboya te bai ko kani bi ko tego. ");
INSERT INTO kqf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Banina dobumo lava mote waiwaisumeḡidi, laḡan matabuna niga kauwidi sa wainuwaboyaedi bi sa ḡoeḡoe te sa legaudi. Bi temi, Tamemi i sibe te niga mwalidi ko malumaluwabiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Temi kamaina te ena waibada ko gei tavuḡe kaka tana mba mwalidi ya vitemi.” ");
INSERT INTO kqf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Egu yalabolu ḡaubona komai nuwaboya, banina Tamemi i wainuwavisuyemi te ena waibadamo ko miya. ");
INSERT INTO kqf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Emi ḡonaḡona ko kune kamaḡedi bi lava waiyamoyamonidi mane ko vitedi. Mba kauwidimo emi solusolugudu bagibagidi ko voivoiyedi te mote sima nuwalisi, emi waiguyau malamo ko laususuḡudi te mote sima kovi bi taudanene mote sima danenedi bi kwalikwali mote sima kagebogebodi. ");
INSERT INTO kqf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Banina emi waiguyau bamo ḡome ba temi laḡan matabuna kota nuwapoumi ḡome. ");
INSERT INTO kqf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Laḡan matabuna Maimaituwa ena noya aubaina koi gala bi ko vononoḡa. Emi kwadam ko gabudi te sa yanayana, ");
INSERT INTO kqf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","maibena taupaula edi bada sa labelabe te naḡi soinemo ya munaḡa tava. Laḡannemo i tava bi i laupewapewana ba tedi maḡemota sa moito te gudu sa kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Taupaula mabai edi bada aubaina a vononoḡa bi sa wailabana ba ena nato munaḡemo sai nuwavisu. Giukauwemo yà giugiuwemi, te tana kaka waitaupaula aubaina yai gala, ya giuwedi te teibolo sa miya kwaivivili bi yai kanidi. ");
INSERT INTO kqf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Avena te dudubala modonemo ee laḡan sakosako balanemo Bada ya nato bi mabai a vovononoḡana ya banavidina ba sai nuwavisu. ");
INSERT INTO kqf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Temi niga kauwina ko sibe: Bamoda vanuwa taniwagina taudanene ena sola saḡa saugina i sibena ba, mote gavogavo ima vite te ena vanuwa ima lolo. ");
INSERT INTO kqf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Temi kota mainana ko vononoḡa, banina Tana Taunana Natuna ya natona kaka sauga mote koma noḡonoḡotinemo ya tava.” ");
INSERT INTO kqf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita i waitalana gado, “Bada, niga lautaulalana ba tama taumaiḡa kwa giugiuwemai ee ema lava ḡesaudi vaitedi kwa giugiuwedi?” ");
INSERT INTO kqf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu Pita ena giu i waimunena gado, “Taupaula aiyai waisumeḡina bi nuwanuwauyauyana, tana taunana kaka ena bada ya vine te taupaula ya labedi te sauga kauwemo kaka kediya ya soisoiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bamoda Bada ena tava munaḡemo bi taupaula aiyai ya banavi, niga kauwina ya voivoiyena ba nuwavisu didiga mba taupaulina lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tagu giukauwemo yà giugiuwemi te mba taupaulina kaka ena bada waibada matabuna ya vite te ena ḡonaḡona matabudi yai badayedi. ");
INSERT INTO kqf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bi bamoda taupaulina maso taunaḡa i giu munaḡena gado, ‘Egu bada ya alaala nawa bi mote ima tavatava makai.’ Tana ḡome taupaula oloolotodi bi waiwaivinidi i kwapudi, i kani, i tego bi i tego buu'wa. ");
INSERT INTO kqf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mba taupaulina ena bada ena nato saugina mote ima noḡonoḡoti bi ima sibesibe te bai sauginemo ya tava. Sauginemo ya miyamiya nuwakauleya bi ena bada ya tavana kaka taupaula ya koiḡavuḡavuki bi lava laukasaḡaiḡaidi edi gabumo ya pwalaḡe nawe. ");
INSERT INTO kqf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Taupaula aiyai ena bada ena ḡowana i sibedi bi mote ima voivoiyedi ee ima vovononoḡa ba ena bada kaka tana ya kovoḡi gulate. ");
INSERT INTO kqf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bi taupaula aiyai ena bada ena ḡowana mote i sibedi bi noya i ai voivoiyena ba tana kaka ena kovoḡa ḡaubona ya vai. Tedi mabai noya dididiga i vitedi bi mote sima voivoiye kauwedi ba kovoḡa dididiga sa banavi. Maimaituwa taupaula aiyai bi vaivai wapewapedi i vitevitena ba ya noḡonoḡoti te vaivai wapewapedi lisinemo ya legau munaḡedi. Bi Maimaituwa taupaula aiyai i waisumaḡe bi vaivai wapewapedi nimanemo i sivudi te ya labelabedina ba mainana kota Maimaituwa ya vite munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tagu e yovona dobumo ba kai e yovoḡe bi e ḡoeḡoena maso kaikana i kalakalati. ");
INSERT INTO kqf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tagu kaka kabulu yà vai bi wainuwatoimo yà miyana eete kabulu yà laudamoye. ");
INSERT INTO kqf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Temi ko noḡonoḡoti te tagu bena dobumo nuwauba e yovoḡe, ee? Geḡa, mote nuwauba bi daila. ");
INSERT INTO kqf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Niganana bi noi i nawana ba vanuwa ḡemota noponemo lava wapedi 5 kaka sa daili munaḡedi te lava faiona ba lava labu vaitedi sai miyatauli bi kota lava labu ba faiona vaitedi sai miyatauli. ");
INSERT INTO kqf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tedi kaka sa daili munaḡedi, tama kaka natuna olotona vaitena sai miyatauli bi gomana olotona kaka tamana vaitena sai miyatauli, bi vesala kaka natuna waivinina vaitena sai miyatauli, gomana waivinina kaka matinana sai miyatauli. Bi vesala malawana kaka sai miyatauli bi lawana kaka vesala vaitena sai miyatauli. ");
INSERT INTO kqf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu lava kumna i giuwedina gado, “Laḡannemo yada nisa yawaninaḡa ya saḡasaḡa ba ko giugiuna gado, ‘Noi taunana nabu ya yovo.’ Bi mainana ya tubutubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bi laḡannemo suwala ena anilovotava yawaninaḡa yavala ya laulausuve ba ko giugiuna gado, ‘Niganana ba ya kwamla.’ Bi mainana ya tubutubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Temi waiwaikaikaiyovumi! Temi galewa bi dobu kita waiipoipodi kona sibe kauwedi. Bi bainewa te niga saugina giuwaiipoipona mote koma sibesibe kauwe?” ");
INSERT INTO kqf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bai aubaina mote komai talapili munaḡemi te maso didimana kauwina kona voiye? ");
INSERT INTO kqf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bamoda lava ya panim bi ya nawem etala gabunemo, ba etamo kwa giu bagibagi bi em gebogebo ko kadidimani te em tau vaitena koi nuwaḡemota. Bi mote kuma voiye ba ya nawemna taulauetala lisinemo. Bi taulauetala ya nawemna biliweloko taulabena lisidimo te biliwelokomo sa sako nawem. ");
INSERT INTO kqf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yà giugiuwem te tam mote kaka kuma potiyovo bi ḡome kwa waimaiiana eete em mane matabuna biliwelokomo kwai kovi.” ");
INSERT INTO kqf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mba laḡanemo tedi mabai ḡome a tavatavana Yesu a tainuwatau te mani Galili Maimaituwa lisinemo a laulausewasewana ba Paelat i waipekidi. ");
INSERT INTO kqf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bi Yesu edi giu i waimunena gado, “Mba lausewasewanemo mani Galilidi a waipekidina ba ko noḡonoḡotina a gebo gulatana kaka edi lava ḡesaudi, ee? ");
INSERT INTO kqf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Geḡa, yà giugiuwemi te emi gebogebomo mote ko laukuvasa ba matabumi ko pekina mai tedi a pekipekina. ");
INSERT INTO kqf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bi ko noḡoti Silowammo kota vanuwa kaikaidakina i nuwagolu yovo te lava wapedi 18 i waipekidi. Tedi a gebo gulatana kaka lava ḡesaudi Yelusalemmo sa miyamiyana, ee? ");
INSERT INTO kqf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Geḡa, yà giugiuwemi te emi gebogebomo mote ko laukuvasa ba matabumi ko pekina mai tedi a pekipekina.” ");
INSERT INTO kqf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kamaina bi Yesu niga lautaulalinemo i giuwedina gado, “Mai maso, oloto ena wain daibinemo damaya kaina i wadi. Bi tana i nawa votana au-losinemo ba mote votana i kita. ");
INSERT INTO kqf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Taunana aubaina, tana daibi taulabena i giuwena gado, ‘Tagu kwalabu faiona nopodimo ei velavelau damaya votana aubaina, bi damayina mote i vota. Maso kuna oi kamaḡe, bai aubaina doḡa ya waiyakale?’ ");
INSERT INTO kqf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Bi daibi taulabena i giuna gado, ‘Bada, kwalabu ḡemota noponemo kwa kita kamaḡe te pakana yà ḡuluvi waikwaivivili bi kaidubudubu yà sivudi. ");
INSERT INTO kqf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bi bamo te kwalabu ḡesau noponemo ya votana ba kamaina, bi geḡa, ba kamaina te kwa oi kamaḡe.’” ");
INSERT INTO kqf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Waiyawasi Laḡaninemo Yesu bolu vanuwina ḡesaunemo i waiwailovelove. ");
INSERT INTO kqf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bi ḡome ba waivini ḡemota, bi aluwa gebogebona waivini i voiye te i nuwakudu bi i pelona ba kwalabu 18 a kovi bi mote i yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Laḡannemo Yesu waivinina i kitakita ba i giu otiḡena gado, “Waivini, em sidamo kuna yawasana.” ");
INSERT INTO kqf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ḡome Yesu nimana i tuḡu bi waivini dabanemo i sakosako ba noi taunana te i moito didimana bi Maimaituwa i kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bolu vanuwina taulabena i medina banina Yesu Waiyawasi Laḡannemo waiyawasana i voiye. Bi lava i giuwedina gado, “Laḡan 6 nopodimo eda noya ta voiyedi, bi mba laḡandimo ko tava Yesu lisinemo te yai yawasanimi bi mote Waiyawasi Laḡannemo.” ");
INSERT INTO kqf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bada ena giu i waimunena gado, “Temi kaikaiyovumi! Tam aiyai em kau ee em donki Waiyawasi Laḡannemo gadona i magu bi kuna kita kamaḡe, ee? Bena ena ganamo kwa kuvesi bi kwai doli nawe te gauba ya tego. ");
INSERT INTO kqf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Niga waivinina ba Eiblaḡam ena tubulelesa bi Seitan i panina ba kwalabu 18 a kovi. Niga waivinina Waiyawasi Laḡannemo maso te kita kamaḡe, ee? Bena geḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Laḡannemo Yesu mainana i giugiuwedi ba kana ḡaviya i voiyedi te taudiḡa ai dabaubedi. Bi Yesu kauwa visuvisudi matabudi i voivoiyedina lava a yasisiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kamaina bi Yesu i waitalana gado, “Maimaituwa ena waibada ba mai bai? Bai yà laukoiluvae? ");
INSERT INTO kqf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mba maibena wasiva pesina, oloto i vai te ena daibimo i wadi. I duga te i waila kai bi mwanuwa sawasawaḡa lovolovodi lagalaganemo a launoḡi.” ");
INSERT INTO kqf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu i waitala munaḡana gado, “Bai kauwinemo Maimaituwa ena waibadana yà lau koiluvaye? ");
INSERT INTO kqf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mba niga mainana: Laḡannemo waivini muu'a ya vai bi falawa vaitena ya vitalena ba muu'a mba falawina nopona matabuna ya voiye te ya lusa.” ");
INSERT INTO kqf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu i nawanawa Yelusalemmo, bi mba nawanemo ba taun bi malagai nopodiḡa i nawa bi lava i waiwailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bi ḡome lava ḡesauna i waitalana gado, “Bada, giukauwa te lava visa ota sa yawasana, ee?” Bi Yesu i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Temi ko kaibagibagi te mataeta ḡulilinemo ko sola nawa, banina lava wapewapedi sa wailaulubu te maso sa sola nawa bi sa kabikabi kasaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ḡome vanuwa taniwagina ya moito te mataeta ya gudu. Bi temi kaka vanuwa mataetinemo ko moito, ko laupewapewa bi koi baḡana gado, ‘Bada, aubaimai mataeta ku kaikamaḡe.’ Bi tana giu yai munena gado, ‘Tagu mote yà sibemi, temi bamo maiḡa kona tava.’ ");
INSERT INTO kqf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bi temi kaka giu koi munena gado, ‘Tama tam vaitem te kani, te tego bi ema taunimo kunai lovelove.’ ");
INSERT INTO kqf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bi geḡa te tana giu yai munena gado, ‘Tagu mote yà sibemi te bamo maiḡa kona tava. Temi gebogebo tauvoiyena, ko nawa tabumimo!’ ");
INSERT INTO kqf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ḡome kaka ko ḡaba bi mwakemi ko sanadididi, sauginemo Eiblaḡam, Aisik, Deikap bi taugiuwatana matabudi Maimaituwa ena waibadamo sa miyamiyana ko kitedi. Bi ḡome kaka temi sa pwalaḡe yovoḡemi. ");
INSERT INTO kqf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bi lava kaka aibeu, lalasi, aibadabada bi yalousa yawanidiḡa sa tava bi Maimaituwa ena waibada soinemo edi gabu sa legaudi. ");
INSERT INTO kqf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bi tedi mabai niganana sa mulimulina kaka sai laumatanana, bi mabai niganana sa wailaumatanana kaka sa muli.” ");
INSERT INTO kqf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mba saugina ḡemotinemo, palisi ḡesaudi a tava Yesu lisinemo bi a giuwena gado, “Tam niga dobuna kwa gose kamaḡe bi kwa nawa tabummo, banina Alodi ya ḡoeḡoena yai pekim.” ");
INSERT INTO kqf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bi Yesu edi giu i waimunena gado, “Ko nawa te mba dakona ko giuwena gado, ‘Tagu penama yà waipotiyovodi bi lava yà wai yawasanidi, niganana bi bokina. Bi laḡan waifaioninemo ba egu noya yài kovi.’ ");
INSERT INTO kqf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Avena te bainewa bi tagu egu noya niganana, bokina bi laḡan ḡesaunemo yà voiyedi kaka yà nawa Yelusalem. Banina, Taugiuwatana mote bamo ima peki te Yelusalemmo kaka ya peki. ");
INSERT INTO kqf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalem dobuna lavemi, temi taugiuwatana konai pekidi bi Maimaituwa ena tauwainoyanoya i giukamaḡedi lisimimo bi kona lauḡakimidi. Bi laḡan matabuna e ḡoeḡoena maso temi ei ḡemotimi maibena kamkam waivinina mabenemo natunatuna ya ḡomoḡomo tawidina. Bi temi mote koi aninegu. ");
INSERT INTO kqf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Taunana aubaina koi beyavaiya, Maimaituwa kaka emi vanuwa ya gose bi i laukavakava. Yà giugiuwemi te mote kaka koma kitagu eete ko giuna gado, ‘Tana kakavisuvisuna, Bada isanemo ya natonato.’” ");
INSERT INTO kqf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Waiyawasi Laḡanna ḡesaunemo, Yesu i nawa Palisi isanawanawana ena vanuwemo kani aubaina. Bi ḡome ba lava tana a waikita wata. ");
INSERT INTO kqf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ḡome ba oloto kaḡena bi nimana luselusedi Yesu matanemo i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu Palisi bi waiḡake tauwailovelovena i waitalayedina gado, “Waiḡake bainewa ya giugiuweda, Waiyawasi Laḡannemo lava tai yawasani e avena?” ");
INSERT INTO kqf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Geḡa te tedi mote bai a giuwe, kamaina bi Yesu oloto i taukoni, i waiyawasani bi i giukamaḡe te i nawa. ");
INSERT INTO kqf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ḡome Yesu i waitalayedina gado, “Bamoda walitau natum olotona ee em bulumakau Waiyawasi Laḡannemo bi dommo i kuluvana, maso kuna kita kamaḡe e kunai papalana bi kuna solu saḡe?” ");
INSERT INTO kqf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bi tedi mote luvana te bai sa giuwe. ");
INSERT INTO kqf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Laḡannemo Yesu i kita te tauliso animiya a laulauvavina ba tana niga lautaulalana i giuwedi: ");
INSERT INTO kqf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Laḡannemo lava bi i giuvaimna naḡi soinemo, ba animiya laukaina kuma gei vai. Mote ku sibe te lava isanawanawana kota a giuvai. ");
INSERT INTO kqf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Male soi taniwagina ya giuwemna gado, ‘Niga lavana em animiya ku vite.’ Ḡome te waidabauba vaitena bi kwa miya yovo duyamo. ");
INSERT INTO kqf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Laḡannemo bi a giuvaimna, ba kwa nawa te doḡamo kwa miya. Taugiuvaim kaka ya giuwemna gado, ‘Goma, ku saḡa gabu laukainemo kwa miya.’ Mba mainana kaka soi taniwagina ya kasaḡem tauliso ḡesaudi matedimo. ");
INSERT INTO kqf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tana aiyai bi i nuwasaḡasaḡana, ba ya sakoyovoḡe munaḡe, bi aiyai i sakoyovoḡe munaḡena kaka sa kailageti.” ");
INSERT INTO kqf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kamaina bi Yesu taugiuvaina i giuwena gado, “Laḡannemo suwalamodo e aubiga kanina kwa voiyena ba mote em lava, valevaletim, em dam lavedi e diyammo taumiya waiguyaudi kuma giuvaidi, mainana bi kuna voiyena ba matabudi male sai sipo te sa giuvaim. ");
INSERT INTO kqf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Laḡannemo kwa soina ba wainuwatoitoidi, nawanawa geḡedi, kaḡe nuwanokudi bi matapotepotedi kwa giuvaidi. ");
INSERT INTO kqf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tedi mote luvana te bai kuna voivoiyena simai sipo bi Maimaituwa kaka ya kavisuvisum bi yai maiim, didimana lavedi edi kenamoito laḡannemo.” ");
INSERT INTO kqf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Laḡannemo tauliso ḡesauna niga giuna i vaivaiye ba Yesu i giuwena gado, “Lava aiyai Maimaituwa ena waibada soinemo ya miya bi ya kanikanina ba yai nuwavisu gulata.” ");
INSERT INTO kqf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bi Yesu oloto ena giu i waimunena gado, “Laḡan ḡemota oloto soi dididigina i voiye bi tauliso wapewapedi i giuvaidi te sa tava. ");
INSERT INTO kqf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bi soi laḡannemo ba ena taupaula i giukamaḡedi a nawa te tauliso a giuwedina gado, ‘Ko nato, bai matabuna kaikana i nonoḡa.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bi matabudi edi waikoigudu giudi a giuwedi te mote sima nato soimo. Oloto dolidolina taupaula i giuwena gado, ‘Maḡo ota doḡa ḡaubona e gimeli aubaina te yà nawa yà kita. Ae, egu waipapa kwai anine.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ḡesauna i giuna gado, ‘Tagu ba egu bulumakau wapedi 10 e gimala te yà nawa bi noyamo yài laulubudi. Ae, egu waipapa kwai anine.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bi kota ḡesauna i giuna gado, ‘Tagu ba niganana kaka e naḡi, taunana aubaina te mote yàma nato.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ḡome taupaula i munaḡa te ena bada bai matabuna i tainuwatau. Vanuwa taniwagina i medi gulata bi taupaula i giuwena gado, ‘Kwa nawa makai te taun etedi nananakidi bi keikelikidiḡa lava wainuwatoitoidi, kaḡe nuwanokudi, matapotepotedi bi kaḡedi nuwakududi kwa tavaitedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Taupaula i nawanawana i tava munaḡa bi i giuna gado, ‘Bada bai kuna giugiuwena ba e voiye bi yaḡolo te gabu dididiga ya kenakena.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kamaina bi Bada ena taupaula i giuwena gado, ‘Kwa nawa etaḡa bi dobu diyadiyanaḡa mabai kwa banabanavidina kwa giuwedi te sa tava bi egu vanuwa sai wanavu.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yà giugiuwemi te lava mabai e giuvaidi bi a dabodabokana, kaka egu soimo mote sima kani.” ");
INSERT INTO kqf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lava kumdi Yesu vaitena a nawanawa, i tinamuli bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Aiyai kaiwatagu ya ḡoena ba tagu ya ḡoe gulateguna kaka tamana, tinana, mwanena, natunatuna bi tasitasina. Bi bamoda aiyai taunaḡa ena yawasana ya ḡoeḡoe gulatena kaka tagu, ba tana mote ḡemoḡemotina te egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aiyai mote ḡemoḡemotina ena kolosi ima avali bi ima kaiwatagu ba tana mote egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bamoda ḡemota poumimo ya waiogatala te maso vanuwa kaikaidakina ya ḡalana, ba dolinemo ya miya bi mane ya gei kita te visa ya pwalaḡe kaka vanuwina ya ḡala kovi. ");
INSERT INTO kqf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bamoda tana vanuwa ḡalana i waitubu bi mote i waikovi ba lava sa kita bi sai gwaigwaiye, ");
INSERT INTO kqf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bi sa giuna gado, ‘Niga lavana lauḡala i waitubu bi mote i waikovi.’ ");
INSERT INTO kqf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mai maso, ḡalibona ena tauwaiḡaviya wapedi 10 tausan bi ḡalibona ḡesauna ba 20 tausan, dolinemo tana ya miya bi yai nuwanoḡonoḡota te ḡemoḡemotina 20 tausan yai ḡaviyedi ee geḡa? ");
INSERT INTO kqf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bamoda tana mote ḡemoḡemotina ba tedi yaḡolo manekemo bi tauwainoyanoya ya gei giukamaḡe kana ḡaviya lisidimo te yai baḡedi, te nuwauba poudimo ya kena.” ");
INSERT INTO kqf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu giu i waikenana gado, “Mainana tam aiyai mote bai matabuna ku gose kamaḡedi ba tam mote ḡemoḡemotina te egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Soliti ba i visu bi laḡannemo dinina bi i kovina, ba bainewa kwa voiye te ya dini munaḡa? Mote luvana. ");
INSERT INTO kqf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mba mai solitina ba mote sima pwalaḡe doḡamo ee venimo sima ḡini bi sa pwalaḡe otiḡe. Aiyai waibeyam te kwai beyavaiya kauwa.” ");
INSERT INTO kqf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Laḡan ḡemota takis taulaitupedi bi gebogebo lavedi a tava Yesu waibeyavaiyena aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kamaina bi Palisi bi waiḡake tauwailovelovena babadidi a wawaluna gado, “Bai aubaina niga olotona gebogebo lavedi ya giuvaidi bi vaitena sa kanikani?” ");
INSERT INTO kqf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Taunana aubaina Yesu niga lautaulalana i giuwedi: ");
INSERT INTO kqf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mai maso, ḡesaum em sipu wapedi 100 bi ḡemota i gwegwena, ba bai kwa voiye? Bena tam 99 kwa gose kamaḡedi edi ani miyamo bi kwa nawa sipu gwegwena kwa tavutavuḡena eete kwa banavi. ");
INSERT INTO kqf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bi laḡannemo kuna banavina, ba ma yasisim dabayalommo kwa sako saḡe bi ");
INSERT INTO kqf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kwa nawa em malagaimo. Em lava bi diyammo taumiya kwa yogedi sa tava, sai ḡemotidi bi kwa giuwedina gado, ‘Egu sipu gwegwena e banavi, taunana aubaina ko nato bi ta yasisi.’ ");
INSERT INTO kqf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yà giugiu kauwemi, te gebogebo lavana ḡemota bi i kuvasana ba noke malamo sa yasiyasisina mote mai 99 didimana lavedi mote kuvasa sima ḡoeḡoe. ");
INSERT INTO kqf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mai maso waivini ena kina wapedi 10, bi ḡemota i laipaili bi bai ya voiyena ba kwadam yai tuni bi ena vanuwa ya lauḡiliḡili bi ya waitavutavuna eete ya banavi. ");
INSERT INTO kqf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bi laḡannemo i banavina ba ena lava bi diyanemo taumiya ya yogedi sa tava sai ḡemotidi bi ya giuwedina gado, ‘Egu kina e lailaipailina e banavi, taunana aubaina ko nato bi ta yasisi.’ ");
INSERT INTO kqf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kota mainana yà giugiuwemi te gebogebo lavana ḡemota bi i kuvasana, ba malamo yasisi dididiga Maimaituwa ena aneya matedimo.” ");
INSERT INTO kqf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu yaḡolo te lautaulalamo i giugiuwedina gado, “Mai maso bada ḡemota natunatuna oloolotodi labu. ");
INSERT INTO kqf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gomana tautasina tamana i giuwena gado, ‘Tamagu, em waiguyau kwa soiyedi te egu soisoi vokai kwa vitegu.’ Kamaina bi bada vokai natunatuna i waioneonedi. ");
INSERT INTO kqf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tedi a miya mote lofana te tautasina ena vokai i kune kamḡedi bi i nawa manekemo dobu ḡesaunemo bi kauwa yabayababemo ena mane i waiyakale. ");
INSERT INTO kqf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tana bai matabuna i gwasatutu, mulinemo gomala mba dobuna matabuna i laugulate ba tana maluwabi i waitubu. ");
INSERT INTO kqf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kamaina bi i nawa mba dobuna lavana lisinemo, bi i waibaḡa te isana i sako saḡe te aubaina ya noya. Ḡome te i giukamaḡe nawe ena buwawa edi go'ugo'umo te buwawa yai kanidi. ");
INSERT INTO kqf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ḡome tana kanipeki i laukauwe, taunana aubaina i ḡoeḡoena maso buwawa kedi dayo i kani bi mote aiyai kani i vite. ");
INSERT INTO kqf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Laḡannemo noḡota kauwa i vaivai ba tana i giuna gado, ‘Tamagu ena taupaula kediya mainana kenakenana bi tagu niga ḡome kani peki yai pekigu. ");
INSERT INTO kqf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bi i visu te yà munaḡa tamagu lisinemo bi yà giuwena gado, “Tamagu, gebo e voiye Maimaituwa lisinemo bi tam lisimmo. ");
INSERT INTO kqf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tagu mote yà visu te kwai kawa natunegu. Bi kwa voiyeguna maibena em taupaula ḡemota.” ");
INSERT INTO kqf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kamaina bi i modina tamana lisinemo. Tana yaḡolo manekemo bi tamana natuna i kita nawe i tavatava ba i launutoiye bi i velau i labavai te i waisuluve. ");
INSERT INTO kqf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gomana tamana i giuwena gado, “Tamagu, tagu gebo e voiye Maimaituwa lisinemo bi tam lisimmo. Tagu mote yà visu te kwai kawa natunegu.” ");
INSERT INTO kqf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Bi geḡa te tamana ena taupaula i giuwedina gado, ‘Waiḡapa gala laukaina ko natome bi tana koi kote. Nimagalanemo lini ko sako bi kaḡesuma koi kote. ");
INSERT INTO kqf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kau natuna pwatapwatana ko natome bi koi peki, ta soi bi matabuda soina ta yasisiye. ");
INSERT INTO kqf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Banina niga natuguna i peki bi niganana i yawasana munaḡa, tana i gwegwe bi i tava munaḡa.’ Taunana aubaina tedi soina a yasisiye. ");
INSERT INTO kqf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mba soina a yasiyasisiye ba gomana tautuweḡina daibimo bi i tava. Laḡannemo vanuwa diyanemo i tavatava ba boiḡatu a bigabigayena daguguna i vaiye. ");
INSERT INTO kqf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kamaina bi taupaula ḡemota i yoge bi i waitalaye te bai ya tubutubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Taupaula gomana tautuweḡina i giuwena gado, ‘Tasim yawayawasanina i tava munaḡa taunana aubaina, tamam kau natuna pwatapwatana i vunu bi ka soisoi.’ ");
INSERT INTO kqf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Gomana tautuweḡina nuwana i medi te vanuwemo valageta i daboka. Kamaina bi tamana i potiyovo te i waibaḡa bi i giu komakomaniye te maso i valageta. ");
INSERT INTO kqf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bi gomana tamana ena giu i waimunena gado, ‘Kuna sibe te niga kwalabudi wapewapedi e ala paulem bi mote yà laulaukasaḡaiḡaiyem. Bi tam mote bamo gouti lauewalina ku vitegu te maso egu lava vaitedi ke soi yasiyasisi. ");
INSERT INTO kqf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bi niga natumna ba waivini kabakabaleyedi lisidimo em mane matabuna i waiyakale. Bi niganana i tava te tam kau natuna pwatapwatana aubaina kuna vunu.’ ");
INSERT INTO kqf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bi tamana ena giu i waimunena gado, ‘Natugu, tada miyamiyada laḡan matabuna bi bai matabuna lisigumo ba tam aubaim. ");
INSERT INTO kqf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tada ta soi yasiyasisi bi tai nuwavisu, banina niga tasimna ba i peki bi i yawasana munaḡa. Tana i gwegwe bi niganana e banavi.’” ");
INSERT INTO kqf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ena tauwaikaiwatana i giuwedina gado, “Maimaso lava waiguyauna, tana ena sitowa taulabena i sako te ena mane ya labelabe. Lava a tava te mane taniwagina a tainuwatau te sitowa taulabena mane ya waiyakale. ");
INSERT INTO kqf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kamaina bi i yoge bi i waitalayena gado, ‘Niga bai giuna lisimmo e vaiye, kabe ku giu? Mane visa kuna voiye, ku kamaḡati. Tam niganana ya kaikamaḡem, mote egu sitowa kuma labe munaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Sitowa taulabena taunaḡa i giu munaḡena gado, ‘Niganana bai yà voiye? Egu bada noyamo i kaikamaḡegu bi tagu mote ḡemoḡemotigu te doba yà ḡala, lava yài gigimanedi bi yài tunimayaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Niganana ba e sibe te bai yà voiye, laḡannemo egu noyamo bi egu bada i kaikamaḡeguna ba lava ḡesaudi edi vanuwemo sa giuvaigu.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kamaina bi lava mabai ena bada ena mane a solusoluna i yogedi a tava lisinemo. Bi dolidolina i waitalayena gado, ‘Egu bada ena mane sipona visa lisimmo?’ ");
INSERT INTO kqf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bi giu i waimunena gado, ‘Oela dulamdi wapedi 100.’ Bi sitowa taulabena mane tausoluna i giuwena gado, ‘Kwa miyatulu makai bi em pepamo dulam wapana 50 kwa gilumi.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kota ḡesauna i waitalayena gado, ‘Bi tam mane sipona visa kuna solu?’ Bi tana i giuwena gado, ‘Witi baikidi wapedi 1 tausan.’ Bi sitowa taulabena i giuna gado, ‘Kwa miyatulu bi em pepamo witi baikidi wapedi 800 kwa gilumi.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sitowa taniwagina tauwailaba kaikaiyovuna kaiyovumo kauwa i voivoiyedina i kasaḡe. Bi giukauwa te dobu lavedi, dobu ena kauwa voiyedimo a anapu kauwana kaka yanayana lavedi.” ");
INSERT INTO kqf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Yà giugiuwemi te dobu ena waiguyau ko soiye te emi lava sa wapa, bi laḡannemo mane ya kovi bi ko pekina ba temi kaka sa giuvaimi yawasana kenakena nonoḡinemo. ");
INSERT INTO kqf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tana aiyai bi noya ḡaubona i voiye kauwena ba kota mainana noya dididiga ya voiye kauwe. Tana aiyai bi noya ḡaubona i aivoivoiyena ba kota mainana noya dididiga ya aivoivoiye. ");
INSERT INTO kqf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Bamoda dobu ena waiguyaumo mote simai sumaḡem, bena aiyai kaka mala ena waiguyaumo yai sumaḡem? ");
INSERT INTO kqf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bamoda mote simai sumaḡem te lava ḡesauna ena ḡonaḡona kwa labedi, ba tam bena aiyai kaka em ḡonaḡona ya vitem? ");
INSERT INTO kqf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Taupaula mote babada labu aubaidi ima noya. Tana ḡemota ya daboke bi ḡesauna ya ḡoe, ee ḡemota ya vai bi ḡesauna ya daboke. Tam mote ḡemoḡemotina Maimaituwa bi mane kuma noyaedi.” ");
INSERT INTO kqf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Laḡannemo Palisi niga giudi matabudi a vaivaiyedi ba Yesu ai namaḡe, banina tedi ba mane noḡotina nopodi i waiwanavu. ");
INSERT INTO kqf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu i giuwedina gado, “Temi taunana lava matedimo ko voiyemi te bena kage lava didimanimi, bi geḡa te Maimaituwa nopomi i sibedi. Lava dobu kauwidi edi visu a kitedi bi sa kakasaḡesaḡedina ba Maimaituwa matanemo ai matawalawala. ");
INSERT INTO kqf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mousis ena Waiḡake bi taugiuwatana a gilugilumina wadubonemo ba a lauguguyaena eete Diyon Taukabulu ena saugemo. Mba ḡome Maimaituwa ena waibada giuna visuvisuna i lauguguyae bi lava wapewapedi sa wailaulubu te mba waibadanemo sa sola nawa. ");
INSERT INTO kqf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“I tekateka kauwa te mala bi dobu sa launeḡaneḡa bi waiḡake gilugilumina wadubonemo mote ḡemota ḡaubona sima kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oloto mwanena i gose bi waivini ḡesauna i naḡina ba mwanena ya vavawaidoḡa. Bi aiyai olotona mba waivinina gosegosena i naḡina ba vawaidoḡa ya voivoiye.” ");
INSERT INTO kqf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu i giuna gado, “Lava waiguyauna ḡemota ḡalibona edi gala molemoleledi i kotedi bi laḡan matabuna i soi bi i waiwainuwavisu. ");
INSERT INTO kqf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mba ḡome kota oloto waiyamoyamonina isana Yasales tunina boniboni i wanavu. Tana laḡan matabuna a natome oloto waiguyauna ena mataetamo a waimiyeni. ");
INSERT INTO kqf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bi i ḡoeḡoe te lava waiguyauna ena teibolomo kani pusepuselidi a kulukuluvana maso i kanidi. Bi kota ḡome daḡadaḡasi a tava bi bonibonina a lemolemodi. ");
INSERT INTO kqf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sauga i tava te Yasales i peki bi aneya ai doli nawe Eiblaḡam lisinemo bi vaitena a miya. Bi oloto waiguyauna kota i peki te a dobo. ");
INSERT INTO kqf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bi i nawa iyoyoḡamo yavi gabunemo bi i waikita saḡa te manekemo Eiblaḡam i kita Yasales vaitena a miyamiya. ");
INSERT INTO kqf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kamaina bi lisinemo i binau saḡana gado, ‘Tamagu Eiblaḡam, kwa lau nuwatoiyegu bi Yasales kwa giukamaḡe te nimagalana gaubemo yai dakwa bi menagu yai uba, banina tagu niga kainemo yavi dididiga yà vaivai.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bi Eiblaḡam ena giu i waimunena gado, ‘Natugu, kwa noḡoti te mamiyammo mwali visuvisudi kuna waiguyauyedi bi Yasales tana mwalidi i malulmaluwabiyedi. Bi niganana tana niga ḡome ya wainuwavisu bi tam yavi kwa vaivai. ");
INSERT INTO kqf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bi kota ḡesauna ba mododemo gwagwa i yovo gulata, taunana aubaina mabai sa ḡoeḡoe te lisimmo sa damana natona ba mote ḡemoḡemotina. Mainana kota temi mote ḡemoḡemotina te koma damana nato lisimaimo.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bi oloto waiguyauna i giuna gado, ‘Tamagu Eiblaḡam, Yasales kwa giukamaḡe egu vanuwa lavedi lisidimo, ");
INSERT INTO kqf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te valevaletigu wapedi 5 ya tala wainuwataudi te niga tunivusula gabunemo mote sima tava.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eiblaḡam giu i waimunena gado, ‘Tedi Mousis bi Taugiuwatana bai a gilugilumina lisidimo ya kenakena te sa iyevi bi sa sibe.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tana i giuna gado, ‘Geḡa, tamagu Eiblaḡam, bamoda lava ḡesau pekimo ya kena moito bi ya nawana lisidimo kaka sa laukuvasa.’ ");
INSERT INTO kqf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bi Eiblaḡam i giuwena gado, ‘Bamoda Mousis bi Taugiuwatana kalinedi mote sima vaiyedi, ba avena te lava pekimo ya kena moito bi ya giuwedina bi yaḡolo mote simai sumaḡe.’” ");
INSERT INTO kqf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ena tauwaikaiwatana i giuwedina gado, “Kauwa lava sa voiyedi te gebomo sa kulukuluvana ba sa tubuḡa. Bi kota i gebo kauwa te tana aiyai bi natunatugu gebomo ya voiyedi te sa kulukuluva. ");
INSERT INTO kqf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ba i visu te gadonemo anilauliti ḡakimina vitavitana sa duli bi nisamo sa pwalaḡe yovoḡe, bi mote i visu te lava ḡemota anikita waiyovoyovo ya voiye bi gebomo ya kuluva. ");
INSERT INTO kqf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taunana aubaina koi kita kauwa! Bamoda falom tauwaisumaḡa gebo i voiyena ba kwa kaipasine, bi i kuvasana ba ena gebogebo kwa noḡoti kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bamoda laḡan ḡemota noponemo, mala 7 lisimmo gebo i voiye bi kota mala 7 ya tava bi ya giuna gado, ‘Yà kuvakuvasa, ba kamaina te ena gebo kwa noḡoti kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Giugiukamaḡedi Bada a giuwena gado, “Ema sumaḡa kwa kananakidi.” ");
INSERT INTO kqf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bi Yesu edi giu i waimunena gado, “Wasiva pesina ba ḡaubona bi ya duga te kai dididiga. Bamoda emi sumaḡa ya dididigana maibena wasiva pesina, ba luvana malubani kaina ko giuwena gado, ‘Ku nuwalaka bi nisamo kwa wadim, bi ḡemoḡemotina kalinemi yai bade.” ");
INSERT INTO kqf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Maimaso em taupaula ḡemota i suwasuwata ee sipu i labelabedi. Laḡannemo wapuḡa bi i tavana bena kwa egeli te ya kani makai? Geḡa! ");
INSERT INTO kqf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tam maso ba em taupaula kuna ḡiuwena gado, ‘kwa vononoḡa bi kaguya kwa kanonoḡi te kwa labegu yà kani bi yà tego. Muliḡa kaka tam kwa kani bi kwa tego.’ ");
INSERT INTO kqf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bi taupaula ena bada aubaina i noyanoyana, ba ko noḡonoḡoti te bada ena taupaula yai ebone, ee? Geḡa! ");
INSERT INTO kqf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Temi mainana Maimaituwa noya i giugiuwemina ko voiye bi maso kona giuna gado, ‘Tama mote taupaula visuvisumai bi ema noyaḡa ke voiye.’” ");
INSERT INTO kqf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yelusalem aubaina i nawanawa ba Sameliya ena palata bi Galili ena palata poudiḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bi laḡannemo malagaimo i solasola saḡa, ba ḡome oloto wapedi 10 a banavi bi tabudimo a moito banina tedi ba sida kapa i vaidi ");
INSERT INTO kqf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bi a binauna gado, “Bada Yesu, kwa launuwatoitoiyemai.” ");
INSERT INTO kqf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Laḡannemo i kitekitedi, ba i giuwedina gado, “Ko nawa pilipilisi lisidimo bi tubuḡimi sa kitedi.” Tedi a nawanawa ba etamo a yawasana. ");
INSERT INTO kqf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Laḡannemo oloto ḡemota i kita munaḡe te i yawasana, ba i munaḡa tava Yesu lisinemo bi kalinana dididiginemo Maimaituwa i kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tana Yesu kaḡepakanemo i kuluva bi i waiebone. Tana ba Sameliya olotona. ");
INSERT INTO kqf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu lava i waitalayedina gado, “Olooloto wapedi 10 a yawasana bi wapedi 9 bamo? ");
INSERT INTO kqf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bai aubaina niga walidobu olotona taunaḡa i munaḡa tava bi Maimaituwa ya kakasaḡesaḡe.” ");
INSERT INTO kqf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kamaina bi Yesu oloto i giuwena gado, “Ku moito kwa nawa, em sumaḡa i waiyawasanim.” ");
INSERT INTO kqf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisi babadidi ḡesaudi Yesu ai talayena gado, “Bai sauginemo Maimaituwa ena waibada ya nato?” Yesu edi giu i waimunena gado, “Maimaituwa ena waibada ya natona bi mote ani kita ḡone. ");
INSERT INTO kqf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mote aiyai kaka ima giu gado, ‘Ko kita, tana naniga.’ Ee ‘Tana nanoko.’ Banina Maimaituwa ena waibadana ba temi nopomimo.” ");
INSERT INTO kqf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kamaina bi Yesu ena tauwaikaiwatana i giuwedina gado, “Saugina ya natonatona kaka ya tava. Mba ḡome kaka ko ḡoeḡoena Tana Taunana Natuna ena nato laḡanna maso kona kita, bi mote kaka koma kita. ");
INSERT INTO kqf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lava kaka sa giuwemina gado, ‘Ko kita, tana kaunoko.’ Ee ‘Ko kita, tana kauniga.’ Bi mulidiḡa koma nawanawa. ");
INSERT INTO kqf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tana Taunana Natuna ena nato munaḡa laḡanna kaka maibena namanamali, ya kem bi galewa ya lailaiyanana isuna te isuna. ");
INSERT INTO kqf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bi tana kauwa wapewapedi ya gei wainuwatoiyedi bi niga kimtina lavedi sa daboke. ");
INSERT INTO kqf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Maibena Nowa ena saugemo i tubutubuḡana kota mainana Tana Taunana Natuna ena saugemo. ");
INSERT INTO kqf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lava matabudi a kanikani, a tegotego bi olooloto bi waiwaivini a waikanaḡinaḡi, mba laḡannemo Nowa gulamo i valageta bi kabaita i yovo te matabudi i waipekidi. ");
INSERT INTO kqf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Mba kauwina kota ḡemotina maibena Loti ena laḡannimo. Lava a kanikani, a tegotego, a gimagimala, a wai kunekune, a wadiwadi bi vanuwa a kelikelidi. ");
INSERT INTO kqf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bi laḡannemo Loti Sodom i gosegose ba kai bi ḡakima laimwanamwanaudi bovebovedi malaḡa a laubulili yovo te ai peki kovidi. ");
INSERT INTO kqf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tana Taunana Natuna ena nato munaḡa laḡannemo, kaka mba mainana kauwidi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mba laḡannemo lava aiyai ena vanuwa dabanemo mote ḡemoḡemotina te ima solanawa ena ḡonaḡona ima legaudi, mainana kota lava aiyai daibimo mote luvana ima munaḡa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loti mwanena lisinemo bai i tubuḡana ko noḡoti. ");
INSERT INTO kqf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tana aiyai ena yawasana i nuwamunaḡena ba ya kulayakasi bi tana aiyai ena yawasana i nuwakamaḡena ba ya vai munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Yà giugiuwemi, mba dudubalinemo lava labu kaka sa kenakena ḡemota, Maimaituwa kaka ḡemota ya vai nawe bi ḡesau ya gose. ");
INSERT INTO kqf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Waiwaivini labu kaka witi sa litiliti ḡemota, Maimaituwa kaka ḡemota ya vai nawe bi ḡesauna ya gose.” ");
INSERT INTO kqf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ena Tauwaikaiwatana ai talayena gado, “Bada, bamo ḡome mba kauwidi sa tubuḡa?” Bi Yesu edi giu i waimunena gado, “Bamo ḡome bi peki ba ḡome aoao sa waiḡemota.” ");
INSERT INTO kqf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kamaina bi Yesu lautaulalamo ena tauwaikaiwatana i wailovedi te sa laupali valolo bi mote sima nuwakulukuluva. ");
INSERT INTO kqf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tana i giuna gado, “Taun ḡemota noponemo taulauetala i miyamiya, tana mote Maimaituwa i nainaile e lava i viviviledi. ");
INSERT INTO kqf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bi ḡome iwape taunina ḡemotina noponemo i nawanawa valolo taulauetala lisinemo bi i waibaḡa yaviyavina gado, ‘Kwa sagugu tauwaiwavugu nuwaboya ya vitevitegu.” ");
INSERT INTO kqf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Laḡani i lofa kauwa taulauetala mote i voiye, damonemo tana taunaḡa niga mai i giu munaḡena gado, ‘Avena te tagu mote Maimaituwa yàma nainaile e lava yàma viviviledi, ");
INSERT INTO kqf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yaḡolo te niga iwapena ya kaka nuwalaḡalaḡagu, taunana aubaina tagu yà voiye te nuwauba ya vai, te enai velau munaḡemo mote ima ka tuniyoaigu.’” ");
INSERT INTO kqf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kamaina bi Bada i giuna gado, “Koi beyavaiya te taulauetala ena yawasana mote didimanina bi bai i giuwena ko vaiye. ");
INSERT INTO kqf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bi Maimaituwa ena lava vinevinedi sagu aubaina sa ḡabaḡabana, suwala bi dudubala mote ima kadidimanidi, ee? E sagudi aubaina yai voivoiya? Bena geḡa! ");
INSERT INTO kqf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yà giugiuwemi, tana kaka ena lava ya laididimani makaiyedi. Bi Tana Taunana Natuna ena nato laḡannemo, dobumo tauwaisumaḡa kaka ya tavuḡedi bi visa ota ya banavidi.” ");
INSERT INTO kqf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu kota niga lautaulalana i giuwena ba lava mabai a noḡonoḡoti munaḡedi te tedi bena didimana sa voivoiye bi lava ḡesaudi a kitakita waiyovoyovodi. ");
INSERT INTO kqf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Olooloto labu a saḡa a nawa pali vanuwinemo laupali aubaina, ḡemota ba palisi bi ḡesauna takis taulaitupana. ");
INSERT INTO kqf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Palisi tabunemo i moito bi taunaḡa palimo i kasaḡesaḡe munaḡena gado, ‘Maimaituwa yà waiebonem te tagu mote mai lava ḡesaudi: Maibena taudanedanene, gebogebo tauvoiyedi, tauvawaidoḡa bi kota niga takis taulaitupana. ");
INSERT INTO kqf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tagu wiki ḡemota noponemo laḡan labu yà udiudi bi egu waiguyaumo dubu 10 yà voivoiyedi bi dubu wai 10 na ba tam yà vitevitem.’ ");
INSERT INTO kqf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Bi takis taulaitupana laumulimo i moito, tana mote i waikita saḡa malamo, iwana i taunoku, nuwakadanemo i sivudi bi i laupalina gado, ‘Maimaituwa kwa launuwatoitoiyegu, tagu ba gebogebo lavagu.’” ");
INSERT INTO kqf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu i giuwedina gado, “Yà giugiuwemi te Maimaituwa takis taulaitupana ena pali i vaiye te ena gebogebo i noḡoti kamaḡe, i kadidimani bi i nawa ena vanuwemo. Bi palisi ena pali i vaiyena bi mote i vai. Banina tedi mabai taudiḡa sa sivusivu saḡedina ba Maimaituwa kaka ya sivu yovoḡedi bi mabai sa ḡauḡaubo munaḡana ba Maimaituwa kaka ya sivu saḡedi.” ");
INSERT INTO kqf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lava ḡesaudi natunatudi a tavaitedi Yesu lisinemo te maso nimana dabedimo i sivudi bi i kavisuvisudi. Laḡannemo ena tauwaikaiwatana mba kauwina a kitakita ba lava a ḡasiyedi. ");
INSERT INTO kqf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bi geḡa te Yesu libilibi i yogedi bi i giuna gado, “Libilibi ko kita kamaḡedi te sa nato lisigumo, mote komai ḡakedi, banina lava mabai a ḡaubo munaḡa bi Maimaituwa ena waibadamo sa miyamiyana ba mai libilibi. ");
INSERT INTO kqf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Giukauwemo yà giugiuwemi, aiyai mote Maimaituwa ena waibada imai anine mai gomana ḡaubona mba tana mote Maimaituwa ena waibadamo ima saḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Diu badana ḡemota Yesu i waitalayena gado, “Tauwailovelove visuvisum, bai yà voiye te yawasana kenakena nonoḡina yà vai?” ");
INSERT INTO kqf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bi Yesu giu i waimunena gado, “Tam kwa giugiu te tagu visuvisugu bi Maimaituwa taunaḡa giukauwa te visuvisuna. ");
INSERT INTO kqf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tam bena waiḡake kuna sibedi: Mote kuma vawaidoḡa, mote kumai peki, mote kuma danene, tam mote kaiyovu lavana kumai mulinawanawae, tamam bi tinam kwa viviledi.” ");
INSERT INTO kqf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bi oloto giu i waimunena gado, “Tagu maḡaubogumo te niganana mba waiḡakedi matabudi e kaiwata kauwedi.” ");
INSERT INTO kqf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Laḡannemo Yesu oloto ena giu i vaivaiye ba i giuwena gado, “Tam yaḡolo te kauwa ḡemota kwa malumaluwabiye. Kwa nawa te em ḡonaḡona matabudi kwa kune kamaḡedi, waiyamoyamonidi mane kwa vitedi bi mala ena waiguyau kwa vai. Kaka kwa nato te kwa kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Oloto niga giuna i vaivaiye ba i wainuwaboya kauwa, banina tana i waiguyau gulata. ");
INSERT INTO kqf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu olotona i kita te i wainuwaboya bi i giuna gado, “I bagibagi kauwa te lava waiwaiguyauna Maimaituwa ena waibadamo ya sola saḡa. ");
INSERT INTO kqf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","I pilipili te kamelo siyau bwadanemo ya sola. Mainana kota lava waiguyauna ba i pilipili gulata te Maimaituwa ena waibada noponemo ya sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tedi mabai a vaivaiyena a giuna gado, “Lava waiwaiguyaudi mote sima yawasana te bena aiyai kaka ya yawasana?” ");
INSERT INTO kqf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu giu i waimunena gado, “Lava lisinemo ba mote ḡemoḡemotina bi Maimaituwa lisinemo ba ḡemoḡemotina.” ");
INSERT INTO kqf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kamaina bi Pita Yesu i giuwena gado, “Tama ba bai matabudi ke gosedi bi ke kaiwatam.” ");
INSERT INTO kqf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Bi Yesu i giuwedina gado, “Giukauwa yà giugiuwemi te aiyai bi Maimaituwa ena waibada aubaina ena malagai ee mwanena, ee valevaletina, ee nuvunuvuna, ee magula bi natunatuna i gosedina, ");
INSERT INTO kqf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ba tana kaka ena lava bi ḡonaḡona wapewapedi niga dobunemo ya banavidi bi kota yaḡolo te yawasana kenakena nonoḡinemo ya sola saḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bi Yesu ena tauwaikaiwatana 12 i nawedi tabudimo bi i giuwedina gado, “Koi beyavaiya! Tada ta nawanawana Yelusalemmo ba ḡome kaka wala taugiuwatana Tana Taunana Natuna a gilugilumi watana banidi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tana kaka Eteni nimedimo sa sako te sai dibodiboḡi, sa lauyovoḡe bi sa kanisotawatawa. ");
INSERT INTO kqf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tedi madamo sa kwapu bi sai peki. Bi laḡan waifaioninemo kaka ya kenamoito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bi ena tauwaikaiwatana niga kauwidi i giugiuwedina mote a sibedi, banina giudi banidi tedi lisidimo a kena waidavona, taunana aubaina mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Deliko i vavawaiḡeleḡele ba oloto matapotapotana eta diyanemo i miya bi i waiwaigigimana. ");
INSERT INTO kqf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bi laḡannemo lava kumna a vavawaitauli ba i waitalayedina gado, “Niga bai ya tubutubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bi tedi a giuwena gado, “Nasalet Yesuna ya nawanawa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tana i binauna gado, “Aee Yesu Deivida natuna, kwa launuwatoitoiyegu.” ");
INSERT INTO kqf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lava dolidolidi a ḡasiye bi a giuwe te ya miya moimoisili. Bi geḡa te tana i binau gulatana gado, “Deivida natuna, kwa launuwatoitoiyegu!” ");
INSERT INTO kqf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kamaina bi Yesu i vamoito bi i giuwedi te oloto matapotapotana sa natome lisinemo. Tana i moito nato diyanemo bi Yesu oloto i waitalayena gado, ");
INSERT INTO kqf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bai kwa ḡoeḡoena aubaim yà voiye?” Bi oloto Yesu ena giu i waimunena gado, “Bada, yà ḡoeḡoena yài kita munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Bi Yesu i giuwena gado, “Kamaina ku waikita! Em sumaḡa i waiyawasanim.” ");
INSERT INTO kqf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Noi taunana te oloto matana i yana bi i waikita munaḡa, Maimaituwa i waiebone, i kasaḡesaḡe bi Yesu i kaiwata. Lava matabudi mabai a kitakitana kota Maimaituwa a kasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu i sola saḡa Delikomo bi taunina i nawanawae. ");
INSERT INTO kqf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bi ḡome ba oloto isana Sakiyas tana takis taulaitupana edi bada bi tana ba oloto waiguyauna. ");
INSERT INTO kqf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakiyas i ḡoeḡoena maso Yesu i kita te tana aiyai bi geḡa te i watiḡe gulata, taunana aubaina mote ḡemoḡemotina te Yesu ya kita, banina lava kumna i didiga. ");
INSERT INTO kqf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Taunana aubaina i velau doli bi kai damaya i saḡai te Yesu ya kita banina tana mba etanaḡa i saḡasaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Laḡannemo Yesu mba modomodonemo i tavatava ba i taulageti i kita saḡe bi i giuwena gado, “Sakiyas, ku bulili makai, banina tagu niganana em vanuwemo yà miya.” ");
INSERT INTO kqf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kamaina bi Sakiyas i bulili makai bi manuwavisuna Yesu i giuvai. ");
INSERT INTO kqf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ḡome lava matabudi a kitakitana ba a wawaluna gado, “Niga lavana i waila wale, gebogebo lavana ena vanuwemo.” ");
INSERT INTO kqf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyas i miya moito bi Bada i giuwena gado, “Bada, tagu egu waiguyau nevana lava wainuwatoitoidi yà vitedi. Bi lava mabai takis laitupanemo e kaikaiyovuḡedina ba manedi mala 4 yà laipwatapwata bi yà vite munaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bi Yesu i giuwena gado, “Yawasana niganana niga vanuwinemo i tava, banina niga lavana tana kota Eiblaḡam ena tubulelesa. ");
INSERT INTO kqf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tana Taunana Natuna i yovona ba mabai a gwegwegwena ya tavuḡedi bi yai yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ḡome lava yaḡolo a waibeyavaiya bi lautaulalamo i giuwedi. Banina tana kaikana Yelusalemmo nuwana tava bi tedi a wainoḡotana bena Maimaituwa ena waibada noi taunana ya laumaḡata. ");
INSERT INTO kqf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kamaina bi i giuwedina gado, “Lava laukaina i nawa wali dobumo te waibada ya vai kaka ya tava munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kamaina bi ena taupaula 10 i giuwedi a tava bi mane i soiye bi i giuwedina gado, ‘Niga manedi ko noyanoyaedina eete yà tava munaḡa.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bi geḡa te ena dobu lavedi a daboke bi mulinaḡa tauwainoyanoya a giukamaḡedi mba dobuna babadidi lisidimo bi a giuna gado, ‘Tama niga olotona mote ka ḡoe te yai ḡalibona bi yai badayemai.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tana a vine te i waiḡalibona bi i munaḡa tava. Kamaina bi taupaula mabai mane i vitevitedina edi giu i giukamaḡe te sa tava bi mane a voivoiyedina sa kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kamaina bi taupaula dolidolina i tava bi i giuna gado, ‘Bada em mane ḡemota kuna vitegu bi tagu kota e noyae te wapedi 10 e voiyedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ḡome ḡalibona giu i waimunena gado, ‘Tam taupaula visuvisum, noya ḡaubonemo kunai patutu, taunana aubaina tam kaka taun wapedi 10 kwai badayedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bi kota taupaula wailabuna i tava te i giuwena gado, ‘Bada, em mane ḡemota kuna vitegu bi tagu kota e noyae te wapedi 5 e voiyedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bi ḡalibona giu i waimunena gado, ‘Tam kaka taun wapedi 5 kwai badayedi.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ḡome kota taupaula ḡesauna i tava te i giuna gado, ‘Bada, em mane ba gala selepinemo e suma te e sako waidavo. ");
INSERT INTO kqf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tagu e nailem, banina tam lava medimedim, tam mote mwali mabimmo bi geḡa te kwa vai. Bi kota bai mote ku wadi bi geḡa te kwa lauyaba.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kamaina bi ena bada giu i waimunena gado, ‘Tam taupaula gebogebom, tam em giu ya vitaledi te yà etalem. Kuna sibe te tagu ba medimedigu. Tagu mwali mote mabigumo bi geḡa te yà vai bi mote yà wadi bi geḡa te yà lauyaba. ");
INSERT INTO kqf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bi bai aubaina egu mane banikemo mote ku sako? Maso bi banikemo ku sako, egu tava munaḡemo maso ba laipwatana e vai.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kamaina bi lava ḡome a moimoitona i giuwedina gado, ‘Manena lisinemo ko kaikamaḡe te taupaula aiyai mane 10 i voivoiyena ko vite.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ḡome lava a giu vitena gado, ‘Bada, mba taupaulina kaikana mane 10 i legaudi.’ ");
INSERT INTO kqf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Bi bada i giuna gado, ‘Yà giugiuwemi te tana aiyai bi lisinemo wapawapa ba sai lautawi bi kota aiyai lisinemo geḡa bi ḡaubona ya kenakenana kaka sa kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Niganana tedi mabai kagu ḡaviya mote a ḡoeḡoegu te yài ḡalibona bi yài badayedi ba ko natomedi matagumo bi ko laipekidi.’” ");
INSERT INTO kqf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu niga lautaulalana i waikovi mulinemo ba i doli nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tana oya Oliv diyanemo malagai Betpega bi Beteni i vava waiḡeleḡeledi ba ena tauwaikaiwatana labu niga mai i giuwedi bi i giukamaḡedi a doli, ");
INSERT INTO kqf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ko nawa malagaimo bi ko sola saḡana ba donki lauewalina waitamina ko kita mote aiyai geluḡe. Ko kuvesi bi ko natome. ");
INSERT INTO kqf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bi bamoda lava aiyai yai talaemina gado, ‘Bai aubaina ko kuvekuvesi?’ Ba ko giuwena gado, ‘Bada ya ḡoeḡoe.’” ");
INSERT INTO kqf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tedi mabai i giu kamaḡedi bi a nawanawana ba bai i giugiuwena mainana a banavi. ");
INSERT INTO kqf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tedi donki lauewalina a kuvekuvesi bi taniwagina i waitalayedina gado, “Bai aubaina donki ko kuvekuvesi?” ");
INSERT INTO kqf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bi tedi ena giu ai munena gado, “Bada ya ḡoeḡoe.” ");
INSERT INTO kqf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kamaina bi a natome Yesu lisinemo bi edi kwama a ḡiḡidi te donki dabanemo a yesidi bi Yesu a sagu te i miya saḡa. ");
INSERT INTO kqf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Laḡannemo i gelu bi i nawanawa ba lava edi kwama etamo a yesidi. ");
INSERT INTO kqf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Laḡannemo Yelusalem i vava waiḡeleḡele, Oya Oliv etana i yovo i nawanawanemo i tavatava ba taukaiwatana kumna mayasisidi kalinedi dididiginemo Maimaituwa a kakasaḡesaḡe, banina mataila bi anisove kauwidi matabudi a kitekitedina aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ḡalibona kakavisuvisuna Bada isanemo ya natonato! Namala dididiga Maimaituwa lisinemo bi nuwauba malamo bi dobumo mododemo ya kena.” ");
INSERT INTO kqf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palisi ḡesaudi lava kumna nopodimo Yesu a giuwena gado, “Tauwailovelove, taukaiwatam kwa kaipasinedi te sa miya moimoisili!” ");
INSERT INTO kqf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu giu i waimunena gado, “Ya giugiuwemi, bamoda tedi sa miya moimoisilina ba ḡakima binau sai tubu.” ");
INSERT INTO kqf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu Yelusalem i vavawaiḡeleḡele bi taun i kitakita ba nuwana i toitoi te i ḡaba, ");
INSERT INTO kqf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","bi i giuna gado, “Bamoda niga laḡanna maso bi ko kita ḡone maso ba Maimaituwa bi temi modomimo nuwauba i kena, bi geḡa te niganana matemimo i kena waidavona. ");
INSERT INTO kqf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bi laḡan sa natonatona kaka emi ḡaviya emi malagai ganana taulina sa ḡuluvi bi sa kenavanaḡi, sa moito waikwaivivilimi bi sa vatawimi. ");
INSERT INTO kqf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bi temi natunatumi vaitedi sa kativunumi bi sa vapatinimi. Bi emi ḡaviya kaka gana ḡakimidi sa douwaidabalalidi te ḡakima ḡemota mote kaka ena gabumo ima kena. Banina Maimaituwa tauwaiyawasanimi i giukamaḡe bi mote ko kita ḡone.” ");
INSERT INTO kqf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kamaina bi Yesu i sola nawa pali vanuwina noponemo bi mabai a waikunekunena i kwavidi a potiyovo. ");
INSERT INTO kqf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Bi i giuwedina gado, “Gilugilumina wadubonemo niga mainana Maimaituwa i giu, ‘Egu vanuwa ba pali vanuwina bi temi kona voiye te i waila taudanedanene edi ani kandavona.’” ");
INSERT INTO kqf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tana laḡan matabuna pali vanuwinemo i waiwailovelove. Bi pilisi edi babada, waiḡake tauwailovelovena bi waibabada ḡesaudi a ḡoeḡoena maso ai peki. ");
INSERT INTO kqf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bi tedi mote gavogavo a banavi te maso edi ḡowana a voiye. Banina lava matabudi yaḡolo te ena giu vaiyena a ḡoeḡoe. ");
INSERT INTO kqf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Laḡan ḡemota Yesu pali vanuwinemo lava i wailovelovedi bi giu visuvisuna i laulauguguyae. Pilisi edi babada, waiḡake tauwailovelovena bi waibabada vaitedi a tava Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bi a giuwena gado, “Kwa giuwemai tam em waibada bamo kuna vai bi niga kauwidi kwa voivoiyedi, ee aiyai waibada i vitem?” ");
INSERT INTO kqf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bi Yesu edi giu i waimunena gado, “Tagu kota temi yài talayemi te ko giuwegu. ");
INSERT INTO kqf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Diyon ena laukabulu ba malaḡa i yovo ee lava lisidiḡa i nato?” ");
INSERT INTO kqf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tedi taudiḡa ai talapilina gado, “Bamoda ta giuna gado, ‘Maimaituwa lisinaḡa.’ Ba tana ya giuna gado, ‘Bi bai aubaina mote Diyon koi sumaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bi bamoda ta giuna gado, ‘Lava lisidiḡa.’ Ba lava kumdi sa lau ḡakimida. Banina tedi a sibe kauwe te Diyon ba taugiuwatana.” ");
INSERT INTO kqf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Taunana aubaina tedi a giuna gado, “Tama mote ka sibe te bamo i vai.” ");
INSERT INTO kqf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bi Yesu i giuwedina gado, “Tagu kota mainana mote yàma giuwemi te waibada bamo e vai bi niga kauwidi yà voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kamaina bi Yesu lautaulalamo lava i giuwedina gado, “Oloto ḡemota wain daibina i wadi, taubayau nimedimo i sako bi tana i nawa dobu ḡesaunemo i miyana ba i lofa kauwa. ");
INSERT INTO kqf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vililubu laḡanna i tava bi daibi taniwagina taupaula i giukamaḡe taubayau lisidimo te maso guleipi a vite. Bi geḡa te taubayau, taupaula a kwapu bi a giukamaḡe manimakavakavana i munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kamaina bi daibi taniwagina, taupaula ḡesauna i giukamaḡe. Bi tana kota a kwapu, a voiye te i waidabauba bi manimakavakavana a giukamaḡe i munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bi yaḡolo te daibi taniwagina taupaula waifaionina i giukamaḡe lisidimo, tedi daibi noponemo a kwapu kauwe te nuwakaluna bi a daibi ganataulinemo a pwalaḡe nawe. ");
INSERT INTO kqf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kamaina bi daibi taniwagina i giuna gado, ‘Niganana bai yà voiye? Natuotigu nuwapougu yà giukamaḡena male sa vivile.’ ");
INSERT INTO kqf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bi laḡannemo taubayau a kitakita ba ai giugiuna gado, ‘Niga taunana ba daibi taniwagina natuna. Ko nato ta laipeki bi gagasina tada ta vai.’ ");
INSERT INTO kqf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kamaina bi a pwalaḡe yovoḡe daibi ganataulinemo te a laipeki.” Bi Yesu i giuna gado, “Mba mainana ba daibi taniwagina bai ya voiye taubayau lisidimo? ");
INSERT INTO kqf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tana kaka ya nato te taubayau yai pekidi bi daibi lava ḡesaudi ya vitedi.” Laḡannemo lava niga giuna a vaivaiye ba a giuna gado, “Mote mainana ima tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu lava i kitedi bi i waitalayedina gado, “Gilugiluminemo niga giuna banina ko noḡoti: ‘Taulaukeli ḡakima a dabodabokena taunana i nuwavitala te ḡakima laukaina.’ ");
INSERT INTO kqf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bi tedi mabai niga ḡakimina dabanemo sa talatalaḡana ba sai doulisilisidi bi kota tana lava dabedimo ya talaḡana ba sa nuwamisimisi.” ");
INSERT INTO kqf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Waiḡake tauwailovelovena bi pilisi edi babada gavogavo a tavutavuḡe te noi taunana maso Yesu a pani. Banina a sibe te tedi lautaulalamo i giugiuwedi bi geḡa te lava a nailedi. ");
INSERT INTO kqf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tedi tauwaikita kaikaiyovudi a giukamaḡedi a nawa te Yesu a wainene nawe. Banina tedi a ḡoeḡoena maso bai i vato waigebo bi Loum gabemanina nimanemo a sako te maso i pani. ");
INSERT INTO kqf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kamaina bi tauwaikita Yesu ai talayena gado, “Tauwailovelove, tama ke sibe te tam giukauwemo kwa wai lovelove. Bi tam mote lava kuma nainailedi bi Maimaituwa ena ḡowana lava aubaidi taunana kwa wailoveloveye. ");
INSERT INTO kqf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwa giuwemai, kamaina te tama Sisa lisinemo takis kai maii ee, geḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ḡome Yesu edi kaiyovu i kita bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Te manena koi lovegu. Aiyai isana bi aluwina manenemo?” Tedi ena giu ai munena gado, “Sisa.” ");
INSERT INTO kqf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kamaina bi Yesu i giuwedina gado, “Bai Sisa aubaina ba kamaina te Sisa ko vite, bi bai Maimaituwa aubaina ba kamaina te Maimaituwa ko vite.” ");
INSERT INTO kqf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bi lava matedimo bai i giugiuwedina mote luvana te maso a lauyovoḡe. Taunana aubaina a soveye bi a miya moimoisili. ");
INSERT INTO kqf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadisi sa giugiu te mote kenamoito. Kamaina bi a tava Yesu lisinemo waitala aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tedi a giuna gado, “Tauwailovelove, Mousis ena waiḡakemo niga mai i giuwemai: Bamoda oloto waivini i naḡi bi olotona i pekina, ba tasina mba iwapena ya naḡi te yai natuna tuwaḡana aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mai maso olooloto wapedi 7, tautuwaḡa waivini i naḡi bi mote ai natuna te i peki. ");
INSERT INTO kqf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bi oloto wailabuna iwapena i naḡi te olotona kota i peki ");
INSERT INTO kqf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","mulinemo, oloto waifaionina iwapena i naḡi te olotona i peki bi kauwina ḡemotina olooloto 7 lisidimo i tubuḡa te mote aiyai iwai natuna te a peki kovi. ");
INSERT INTO kqf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bi damonemo waivini i peki. ");
INSERT INTO kqf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mba oloolotodi 7 waivinina a naḡinaḡina, ba kenamoito laḡannemo ba aiyai mwanena?” ");
INSERT INTO kqf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bi Yesu i giuwedina gado, “Dobumo naḡi ya kenakena te oloto bi waivini sa naḡi. ");
INSERT INTO kqf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bi laḡan ya natonatona tedi mabai waisumeḡidi pekimo sa kenamoitona ba mote sima naḡi. ");
INSERT INTO kqf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tedi maibena aneya bi mote sima peki. Banina tedi ba Maimaituwa natunatuna pekimo a kenamoito. ");
INSERT INTO kqf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maimaituwa Mousis lisinemo i kamaḡati kauwe te pekipekidi sa kenamoito. Gilugilumina wadubonemo kai tomboyana vavavaninemo i giu te Bada tana, Eiblaḡam, Aisiki bi Deikap edi Maimaituwa. ");
INSERT INTO kqf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tana mote pekipekidi edi Maimaituwa, bi yawayawasanidi edi Maimaituwa. Mabai sumaḡemo a pekipekina ba lisinemo yawayawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kamaina bi waiḡake tauwailovelovena a giuna gado, “Tauwailovelove, bai kuna giuwena ba giukauwa.” ");
INSERT INTO kqf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ḡome tedi a miyamoimoisili, bi mote ai tala munaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kamaina bi Yesu i waitalayedina gado, “Bainewa te tedi sa giugiu te Keliso ba Deivida natuna? ");
INSERT INTO kqf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deivida ena Sale bukana noponemo tana niga mainana i giu: Bada egu Bada i giuwena gado, ‘Kataiyagumo kwa miya ");
INSERT INTO kqf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","eete em ḡaviya yà voiyedi te kaḡetabam dibunemo kwa vapatinidi maibena anilaukaḡeyasaḡa.’ ");
INSERT INTO kqf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Deivida ya giugiu te Bada ba tana ena Bada, bi bainewa te Keliso maso Deivida natuna?” ");
INSERT INTO kqf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ḡome lava matabudi a waibeyavaiya bi Yesu ena taukaiwatana i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Temi waiḡake tauwailovelovena ko kita kauwedi. Tedi edi gala lofelofedi sa kotedi bi waiḡemota gabudiḡa sa moimoito nawa, bi sa ḡoeḡoena lava vivilemo tedi sai ebonedi, bi kota bolu vanuwidiḡa ee soimo animiya laukaidimo sa miya. ");
INSERT INTO kqf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tedi iwape edi solusolugudu sa kaka kavekavedi bi lava matedimo pali lofelofedi sa iyeiyevidi. Tedi kaka kovoḡa dididiga otina sa vai.” ");
INSERT INTO kqf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu lava waiguyaudi i kitedi pali vanuwina noponemo edi puyo mane abominemo a sivusivudi. ");
INSERT INTO kqf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bi kota iwape waiyamoyamonina i kita toya labu i sivudi. ");
INSERT INTO kqf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ḡome Yesu i giuna gado, “Giukauwa yà giugiuwemi te niga iwapena waiyamoyamonina puyo i sakona i dididiga gulatana kaka lava ḡesaudi. ");
INSERT INTO kqf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Niga lavedi waiguyaudi edi mane nananakidi a kenakena bi keikelikidi a sivusivudi. Bi iwape ena waiyamoyamonemo ena mane matabuna i laupuyoye.” ");
INSERT INTO kqf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu ena tauwaikaiwatana ḡesaudi Pali vanuwina a kita te kulina i visu kauwa taunana aubaina a giugiuwata. Banina mba vanuwina ba ḡakima kulikulidimo a ḡala bi lava puyo kulikulidi a natonatomedina vaitedi vanuwa ai siya. Bi Yesu i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bai niganana ko kitakitana, laḡanna ya tavana kaka ḡakimidi sa douwaidabalalidi, bi ḡakima ḡemota mote ena gabumo ima kena.” ");
INSERT INTO kqf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bi tedi ai talayaena gado, “Tauwailovelove, mavisa niga kauwidi sa tubuḡa? Bi mataila bai ka kita bi ka sibe te mba kauwidi ba ḡotona te sa tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu edi giu i waimunena gado, “Koi kita kauwa te mote aiyai ima aiwainawenawemi. Banina lava wapewapedi kaka sa tava bi isagumo sa lauguguyana gado, ‘Tagu taunana Keliso.’ Bi sa giuna gado, ‘Sauga kaikana i tava.’ Ba koma kaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Laḡannemo pilipili bi waiḡasiḡasi giudi ko vaiyedina ba koma naila. Niga kauwidi kaka sa gei tubuḡa bi mba laḡanna mote ima tava makai.” ");
INSERT INTO kqf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kamaina bi i giuwedina gado, “Dobu bi dobu kaka sai ḡasiḡasi bi kota ḡalibona falona ḡalibona vaitena kaka sai ḡasiḡasi. ");
INSERT INTO kqf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yoyo kaka sa tubuḡa, gomala bi kovoḡa nananakidi mba dobudimo sa tubuḡa bi kota kauwa wainuwa nainailidi bi mataila nananakidi galewemo sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Muliḡa kaka niga kauwidi sa tubuḡana ba tedi sa panimi bi sa lau kivigebogeboyemi. Tedi bolu vanuwidimo bi biliwelokomo kaka sa sivu nawemi bi kota sa nawemi ḡaliḡalibona bi gabemani lisidimo banina temi taukaiwatagu. ");
INSERT INTO kqf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mba ḡome kaka temi emi gavogavo ko vai te giu visuvisuna ko lauguguyaye. ");
INSERT INTO kqf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bi emi noḡota sa didimana bi mote komai nuwaboya te bainewa taumiḡa ko moito galamemi. ");
INSERT INTO kqf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Banina tagu kaka nuwauyauya bi giu yà vitemi te emi ḡaviya mote ḡemoḡemotina sima lauyovoḡemi. ");
INSERT INTO kqf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bi temi kaka tametamemi, tinetinemi, valevaletimi, emi dam lavedi bi emi lava sa lauyovoḡemi bi ḡesaumi kaka sai pekimi. ");
INSERT INTO kqf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tagu dabagumo kaka lava matabudi sa dabokemi. ");
INSERT INTO kqf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bi geḡa te kunumimo daba ḡemota mote kaka ima paila. ");
INSERT INTO kqf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bi moitodidimo kaka yawasana ko vai.” ");
INSERT INTO kqf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Laḡannemo kona kita te tauwaiḡaviya Yelusalem a moito kwaivivilina ba ko sibe te laudousuwasuwa laḡanna i tava. ");
INSERT INTO kqf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tedi mabai Diudiyamo ba sa naila sa nawa oyamo. Tedi mabai taunimo ba tauni sa potiyovo kamaḡe. Bi tedi mabai dobu diyanemo taumiya ba mote sima sola saḡa taunimo. ");
INSERT INTO kqf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Banina niga taunana ba ena kovoḡa saugina i tava te wadubonemo bai matabuna a gilugilumina banina ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mba laḡandimo waivini bwagebwagedi bi waivaivaisudi lisidimo ba i gebo gulata. Niga dobunemo wainuwatoi dididiga ya tubuḡa bi Maimaituwa ena medi kaka ya yovona niga lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bi tedi kaka ḡesaumi kepatemo sai pekimi bi ḡesaumi sa pani nawemi dobu ḡesaudimo. Bi eteni kaka Yelusalem sa vagudagudana eete edi laḡan ya nawakamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mataila kauwidi kaka suwalemo, nawalaimo bi kipolemo sa tubuḡa. Bi dobumo, dobu matabudi kaka sai nuwatoi bi nisa labamidi dagugudimo lava sa naila bi edi noḡota sa kovi. ");
INSERT INTO kqf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bi kauwa dididiga ya natonatona ba dobumo ya tubuḡa bi nailinemo kaka lava sa laugilibubu banina, sawasawa tauwaibadaedi ḡaiḡailisidi matabudi kaka sa gusu bi edi eta sa paledi. ");
INSERT INTO kqf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mba sauginemo tedi kaka Tana Taunana Natuna, maḡailisina bi namala dididiga vaitena yadaḡa ya yovoyovona sa kita. ");
INSERT INTO kqf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Laḡannemo niga kauwidi sa tubutubuḡa ba ko moito bi yasisimo ko lausanadada banina tauwaiyawasanimi nuwana tava.” ");
INSERT INTO kqf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu niga lautaulalanemo i giuwedina gado, “Damaya kaina bi kai matabudi ko kitedi. ");
INSERT INTO kqf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Laḡannemo sa nimanimagala ba temi ko kita bi ko sibe otiḡe te bodubodu laḡannina ya tavatava. ");
INSERT INTO kqf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mba mainana kauwidi ko kitedi sa tubutubuḡa, ba ko sibe otiḡe te Maimaituwa ena waibada ba nuwana tava. ");
INSERT INTO kqf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yà giugiu kauwemi te niga kimtimi mote kaka koma peki eete niga kauwidi matabudi sa tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mala bi dobu sa launeḡaneḡa bi tagu giugu mote kaka ima launeḡaneḡa. ");
INSERT INTO kqf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Koi kita kauwa te soi laḡanidimo tegobu'uwa bi dobu kauwidi mote nopomi simai wanavudi. Bi mba laḡanna mote imai tagugumi maibena kwalo. ");
INSERT INTO kqf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Banina niga kauwina dobumo kaka lava matabudi lisidimo ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Koi kita kauwa bi ko laupali gulata te niga kauwidi sa tubuḡana bi ko vola kamaḡedi. Bi Tana Taunana Natuna ena nato munaḡemo ba luvana temi matanemo ko moito.” ");
INSERT INTO kqf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Laḡan onena Yesu pali vanuwinemo i waiwailovelove, bi aubiga onena i nawa Oliv oyana dabanemo bi i miyamiya te laḡan i sakosako. ");
INSERT INTO kqf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bi olaolala kageka lava a kena moito bi a nawanawa pali vanuwinemo Yesu au waibeyavaiyenemo. ");
INSERT INTO kqf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buledi mote muu'a vaitena Soina sa wai isana Vawaitauli saugina i tava. ");
INSERT INTO kqf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pilisi edi babada bi waiḡake tauwailovelovedi tedi kandavonaḡa gavogavo a tavutavu, te Yesu maso ai peki. Bi geḡa te lava a nailedi. ");
INSERT INTO kqf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tedi 12 nopodimo Seitan Diudas sa wai isana Iskaliyot, i sunei. ");
INSERT INTO kqf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ḡome te Diudas i nawa, Pilisi edi babada bi pali vanuwina tauyavena vaitedi ai ogatala te eta ya voiye te Yesu sa kaididi. ");
INSERT INTO kqf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tedi nuwedi i visu bi ai anina te mane sa vite. ");
INSERT INTO kqf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kamaina bi Diudas i waianina bi eta ya voiye te Yesu babada nimedimo ya sako te lava mote sima sibe. ");
INSERT INTO kqf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kamaina bi Buledi-Mote muu'a vaitena Soina laḡanina i tava, bi ḡome Vawaitauli sewasewana sipu lau ewalidi ai pekidi. ");
INSERT INTO kqf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu, Pita bi Diyon i giuwedina gado, “Ko nawa bi Vawaitauli kanina aubaida ko kanonoḡi te ta kani.” ");
INSERT INTO kqf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tedi ai talayena gado, “Bamo ḡome kuna ḡoeḡoena kani kaka nonoḡi?” ");
INSERT INTO kqf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bi Yesu edi giu i waimunena gado, “Ko nawa bi laḡannemo malagaimo ko solasaḡa ba oloto gauba dugina ya avaavalina ya banavimi. Tana ko kaiwata te bamo vanuwinemo ya valavalagetana ḡome ko valageta. ");
INSERT INTO kqf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bi vanuwa taniwagina ko giuwena gado, ‘Tauwailovelove niga mainana i giu, tauliso edi nakanaka bamo te ḡome egu tauwaikaiwatana vaitedi Vawaitauli Soina ka kani?’ ");
INSERT INTO kqf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tana kaka vanuwina dabanemo nakanaka didiga kaka nonoḡina yai lovemi te ḡome bai matabuna ko kanonoḡi.” ");
INSERT INTO kqf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tedi a nawa bi Yesu mwali matabudi i giugiuwedina mainana a banavidi. Kamaina bi Vawaitauli kanina a kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kamaina bi sauga kauwa i tava te ḡome Yesu bi giugiukamaḡedi teibolo a miya kwaivivili. ");
INSERT INTO kqf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tana i giuwedina gado, “Tagu e ḡoye kauwemi te vaitemi Vawaitauli kanina ta kani kaka muliḡa yài nuwatoi. ");
INSERT INTO kqf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Banina yà giugiuwemi te niga kanina mote yàma kani munaḡe, eete Maimaituwa ena waibadamo niga soina banina ya laumaḡata.” ");
INSERT INTO kqf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ḡome Yesu wain leduna i vai, Maimaituwa i wai ebone bi i giuwedina gado, “Niga ko vai bi emi lava vaitedi ko tego soiye. ");
INSERT INTO kqf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Banina yà giugiuwemi te niganana tagu niga wainina mote yàma tego munaḡe eete Maimaituwa ena waibada ya tava.” ");
INSERT INTO kqf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kamaina bi buledi i vai, Maimaituwa i wai ebone, i kivi, te i vitedi bi i giuna gado, “Niga ba tubuḡigu temi aubaimi i vitemi, niga kauwina ko voiye nonoḡe ani noḡotiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kauwina ḡemotinemo, kani mulinemo tana ledu i vai bi i giuna gado, “Niga ba kwasinigu leduna Maimaituwa ena waianina valivaliuna matailina ya nuwaḡinina temi aubaimi. ");
INSERT INTO kqf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Temi ko sibe te ḡemota tausakoyovoḡegu ba tagu tana vaitena teibolomo. ");
INSERT INTO kqf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maimaituwa ena wai anina luvanemo kaka Tana Taunana Natuna ya peki, bi i gebo kauwa te lava aiyai ya sakoyovoḡegu!” ");
INSERT INTO kqf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tedi taudiḡa aitala vivila te aiyai niga kauwina ya voiye. ");
INSERT INTO kqf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bi ena tauwaikaiwatana taudiḡa nopodimo waikagiu te aiyai i saḡa gulata. ");
INSERT INTO kqf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bi Yesu i giuwedina gado, “Eteni edi ḡalibona ba edi lava lisidimo sa waibada teyala, bi kota isedi aubaidi sa waibada bi sa giugiu te bena kage lavedi sa sagusagudi. ");
INSERT INTO kqf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ḡeḡa, temi mote mai koma voiye, tana aiyai saḡa gulata i ḡoena ba ya ḡaubomunaḡa. Bi taulauetadoli maso ba mai taupaula. ");
INSERT INTO kqf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bamo taunana i tausaḡa, teibolomo ya miya ya kanikanina ee ya waitaupaulana? Tedi lisidimo ba lava teibolomo ya miya bi ya kanikanina. Bi tagu ba mote mainana, tagu ba taupaula. ");
INSERT INTO kqf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Temi egu pilipili matabudimo kona miya sagusagugu. ");
INSERT INTO kqf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tagu Tamagu waibada i viteguna, kota mainana temi waibada yà vitevitemi. ");
INSERT INTO kqf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Taunana aubaina temi kaka egu waibadamo teibolomo ko kani bi ko tego. Bi temi kaka ḡalibona ena animiyaḡa ko miya bi Islaelmo dam 12 koi badayedi.” ");
INSERT INTO kqf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu i giuna gado, “Saimon, kwai beyavaiya kauwa! Seitan kaikana ai anine te matabumi yai laulubumi, ya daili te visuvisuna bi gebogebona maibena taubayau witi ya vuneḡi te banina tabuna bi venina tabuna. ");
INSERT INTO kqf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Saimon, tagu aubaim e laupali te mote em sumaḡa ima kuluva, bi laḡannemo kwa nuwavitalana kaka valevaletim kwa laibagidi.” ");
INSERT INTO kqf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kamaina bi Pita giu i waimunena gado, “Bada, tagu ḡemoḡemotigu ta nawa biliwelokomo te vaitem ta peki.” ");
INSERT INTO kqf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu, Pita ena giu i waimunena gado, “Yà giugiuwem te mateya dudubalemo muliḡa kaka kamkam ya ḡabana ba tam mala faiona kwa valele te mote ku sibegu.” ");
INSERT INTO kqf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kamaina bi Yesu i waitalayedina gado, “Laḡannemo solusolugudu, tana bi kaḡesuma kona gosedi bi e giukamaḡemi kona nawana. Ba mwali bai kona maluwabiye?” Tedi a giuna gado, “Geḡa, mote bai.” ");
INSERT INTO kqf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bi Yesu i giuwedina gado, “Bamoda niganana wai manemi bi wai tanemi ba ko legaudi, bi aiyai lisimmo mote kwatikwati ba kwama kwa kune kamaḡe te kwatikwati kwa gimeli. ");
INSERT INTO kqf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tagu yà giugiuwemi te gilugilumina wadubonemo niga mainana i giu, ‘Tana sa voiyena maibena taudanedanene,’ Banina bai matabuna a gilugilumi watana ba kauwina lisigumo ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bi ena tauwaikaiwatana a giuwena gado, “Bada, kwatikwati labu niga.” Tana edi giu i waimunena gado, “Mba giuna avena.” ");
INSERT INTO kqf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu malagai dididiga i gose bi i nawa Oliv oyanemo laḡan matabuna i voivoiyena mainana. Bi ena tauwaikaiwatana a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Laḡannemo mba gabunemo a tavatava ba i giuwedina gado, “Ko laupali te mote laulubumo koma kuluva.” ");
INSERT INTO kqf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tana i gosedi bi i nawana ba manekina mai ḡakima sa pwalaḡe bi ya talatalaḡana mainana, ḡome tuwapekana i waitupagwaliḡedi bi i laupalina gado, ");
INSERT INTO kqf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Aee, Tamagu bamoda em ḡowana te niga wainuwatoina leduna lisigumo kwa kai kamaḡe. Bi geḡa te tagu mote egu ḡowana bi tam em ḡowana ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ḡome te Aneya malaḡa i yovo lisinemo i laumaḡata bi ḡailisi i vite. ");
INSERT INTO kqf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tana yavi bi nuwaboya nopona i waiwanavu taunana aubaina i laupali gulata, bi yokuyokuna i tositosi yovona doḡamo maibena kwasina. ");
INSERT INTO kqf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tana pali mulinemo i moito bi i munaḡa ena tauwaikaiwatana lisidimo, bi i kitedi te a kena nuwayavuḡa, banina tedi ai nuwaboya gulata. ");
INSERT INTO kqf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu i giuwedina gado, “Bai aubaina ko kenakena? Ko moito bi ko laupali te mote laulubumo koma kuluva.” ");
INSERT INTO kqf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu yaḡolo i giugiu bi ena tauwaikaiwatana 12 nopodimo ḡemota isana Diudas, tana lava kumna i lauetadoliyedi te a tava Yesu lisinemo. Kamaina bi tana i nawa ota Yesu wai suluvena aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bi Yesu Diudas i waitalayena gado, “Tam waisuluvemo Tana Taunana Natuna kwa sakosakoyovoḡe, ee?” ");
INSERT INTO kqf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Laḡannemo Yesu ena tauwaikaiwatana a kita te bai ya tubuḡa, aubaina te ai talayena gado, “Bada, tama ḡemoḡemotina ema kwatikwati kai gulidi, ee?” ");
INSERT INTO kqf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bi edi tau ḡemota kwatikwati i waiguli, te pilisi saḡasaḡa guletina ena taupaula kataiyana yawaninemo beyana i tadi kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kamaina bi Yesu i giuna gado, “Kauwina ko kaisako!” Tana oloto beyana i taukoni te i waiyawasani. ");
INSERT INTO kqf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bi pilisi edi babada, pali vanuwina tauyavena edi babada bi waibabada, ḡome a tava Yesu aubaina. Bi tana i giuwedina gado, “Tagu gode taudanedanene te makwatikwatimi bi mada vitedi kona tava?” ");
INSERT INTO kqf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tagu laḡan matabuna temi vaitemi pali vanuwinemo bi mote ko panigu. Bi niga ba boimatuwa ena sauga kauwa i tava te ena ḡailisi yai badayemi. ");
INSERT INTO kqf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tedi Yesu a pani bi a nawena pilisi saḡasaḡa guletina ena vanuwemo. Bi Pita manemanekemo bi Yesu i vavawata nawe. ");
INSERT INTO kqf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bi lava vanuwa didiyaunemo kai a muka bi a miya kwaivivili bi Pita i nato te vaitena a miya. ");
INSERT INTO kqf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ḡome taupaula waivinina kai yananemo Pita i kita ḡone. Kamaina bi i kitadidi bi i giuna gado, “Niga olotona ba Yesu vaitena.” ");
INSERT INTO kqf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bi Pita i valelena gado, “Mm, waivini, mba olotona kwa giugiuwena tagu mote yà sibe.” ");
INSERT INTO kqf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ḡome a tau miya bi lava ḡesauna Pita i kita ḡone bi i giuwena gado, “Tam kota edi tau ḡemota.” Bi Pita ena giu i waimunena gado, “Oloto, mba mote tagu!” ");
INSERT INTO kqf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mba giuna waumina i nawa kamaḡe mulinemo, kota oloto ḡesauna i giuna gado, “Mba giukauwa, mote ima valele tana Yesu vaitena a nawanawa, banina tana Galili lavana.” ");
INSERT INTO kqf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita giu i waimunena gado, “Oloto, tagu mote yà sibe te tam bai kwa giugiuwe.” Tana yaḡolo i gagagali bi kamkam i ḡaba. ");
INSERT INTO kqf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ḡome Bada i tauvitale bi Pita i kitakitanawe ba Pita Bada ena giu i noḡotidi. “Muliḡa kaka kamkam ya ḡabana ba tam mala faiona kwa valele te mote ku sibegu.” ");
INSERT INTO kqf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kamaina bi Pita i potiyovo i nawa bi i ḡaba te i ḡaba nusanusa. ");
INSERT INTO kqf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bi tauyava mabai Yesu a labelabena ai namaḡe bi a kwapu. ");
INSERT INTO kqf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tedi matana a suma bi ai talayena gado, “Te ku giuwemai, aiyai i kwapum?” ");
INSERT INTO kqf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bi tana kauwa wapewapedimo ai wavu. ");
INSERT INTO kqf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Laḡan i sako bi Pilisi edi babada bi waiḡake tauwailovelovena a tava ai ḡemotidi bi Yesu ai doli nawe bolu babadidi matedimo ai moito. ");
INSERT INTO kqf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tedi ai talayena gado, “Bamoda tam Keliso te kwa giuwemai?” Bi Yesu edi giu i waimunena gado, “Bamo te yà giuwemina ba mote kaka komai sumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bamoda yài talayemina, ba mote ḡemoḡemotimi te egu giu koi mune. ");
INSERT INTO kqf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Niganana bi noi i nawana, Tana Taunana Natuna kaka Maimaituwa ḡaiḡailisina kataiyanemo ya miya.” ");
INSERT INTO kqf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tedi matabudi ai talayena gado, “Tam taunana Maimaituwa Natuna, ee?” Bi edi giu i waimunena gado, “Giukauwa, ko giugiuna mainana.” ");
INSERT INTO kqf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kamaina bi a giuna gado, “Tama mote giu wapewapedi kama ḡoeḡoedi. Tada kaikana beyademo te vaiye.” ");
INSERT INTO kqf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamaina bi bolu babadidi matabudi Yesu ai doli nawe Paelat lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ḡome tedi ai wavuna gado, “Niga lavana ke banavi te lava ya aiaiwaieta doliyedi, bi ya giugiuwedi te takisi mote simai maii Loum Gabemanina lisinemo. Bi tana taunaḡa ya giugiu munaḡe te tana Ḡalibona Vinevine kamaḡena.” ");
INSERT INTO kqf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ḡome Paelat Yesu i waitalayena gado, “Tam Diu edi ḡalibona, ee?” Bi Yesu ena giu i waimunena gado, “Emaso, kuna giugiuna mainana.” ");
INSERT INTO kqf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kamaina bi Paelat, pilisi edi babada bi lava kumdi i giuwedina gado, “Niga lavana lisinemo mote bai gebona e banavi.” ");
INSERT INTO kqf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bi tedi a lauyaviyavina gado, “Niga lavana ena wailovelovemo waiḡasiḡasi ya wai tubudi Diudiya dobuna matabuna noponemo. Tana Galilimo i waitubu bi niganana Yelusalemmo i tavaite.” ");
INSERT INTO kqf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Laḡannemo paelat i vaivaiyedi ba i waitalayedina gado, “Mba Galili lavana ee?” ");
INSERT INTO kqf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ḡome paelat i vaiye te Yesu ba Alodi ena waibada gabulinemo i noyanoya ba tana i giukamaḡe Alodi lisinemo. Mba sauginemo kota Alodi ḡome Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Laḡannemo Alodi Yesu i kitakita ba nuwana i visu gulata, banina giunaḡa i vaivaiye bi laḡan i wapa i ḡoeḡoena maso i kita. Ḡome i ḡoeḡoena maso Yesu anisove kauwidi i voiyedi bi i kitedi. ");
INSERT INTO kqf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Alodi giu wapewapedimo Yesu i waitalavitavitale bi tana mote bai i giu lubuḡe. ");
INSERT INTO kqf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pilisi edi babada bi waiḡake tauwailovelovedi a moito bi Yesu ai wavudidi. ");
INSERT INTO kqf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Alodi ena tauwaiḡaviya vaitedi Yesu ai namaḡe bi ai gwaigwaiye. Tana gala molemolena ai kote bi a giukamaḡe i munaḡa paelat lisinemo. ");
INSERT INTO kqf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Alodi bi Paelat wala a waimiyatauli bi mba laḡannemo tedi aitau munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelat, Pilisi edi babada, bolu babadidi bi lava i giuwedi te a tava ai ḡemotidi, ");
INSERT INTO kqf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bi i giuwedina gado, “Temi niga lavana kona natome lisigumo bi kona giu te lava ya voiyedi bi sa waiḡasiḡasi. Niganana matemimo ei talavitavitale te emi waiwavu banina geḡa. ");
INSERT INTO kqf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bi kota Alodi mote bai gebogebona i banavi, taunana aubaina i giukamaḡe munaḡe lisidemo. Niga lavana mote bai i voiye waigebo te ya peki. ");
INSERT INTO kqf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Taunana aubaina yà kwapu bi yà giukamaḡe ya nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lava kumna a binauna gado, “Mba lavana kwai peki! Bi aubaimai Balabas kwa kaikamaḡe!” ");
INSERT INTO kqf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Balabas ba waiḡasiḡasi bi waipeki i voivoiyedina dabedimo biliwelokomo a sako nawe.) ");
INSERT INTO kqf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paelat lava i waitala munaḡedina, banina ba tana i ḡoeḡoena maso Yesu i kaikamaḡe i nawa. ");
INSERT INTO kqf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tedi yaḡolo a binabinauna gado, “Ko tupalatu, ko tupalatu!” ");
INSERT INTO kqf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paelat giu i waifaionina gado, “Bai gebona i voiye? Tagu lisinemo mote bai gebona e banavi te yài peki. Taunana aubaina sa kwapu bi sa kaikamaḡe te ya nawa.” ");
INSERT INTO kqf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tedi yaḡolo te kalinedi dididiginemo a binabinau te Yesu sa tupalatu. Tedi edi binaumo paelat nuwana ai lausolu. ");
INSERT INTO kqf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kamaina bi Paelat lava edi ḡowana i voiye. ");
INSERT INTO kqf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bi Balabas wai ḡasiḡasi bi wai peki i voivoiyedina aubaina biliwelokomo a sako nawe miyamiya. Bi lava edi ḡowana aubaina te paelat ai baḡa te Balabas ya kamaḡe ya nawa. Bi Yesu i vitedi te edi ḡowana sa voiye. ");
INSERT INTO kqf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sauginemo ḡaviḡaviyidi Yesu a waidoli nawe ba oloto isana Saimon tana Sailin lavana, i solasolasaḡa malagai dididiginemo bi a banavi. Kamaina bi a egeli, kolosi ai avali bi Yesu i kaiwata. ");
INSERT INTO kqf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lava kumna a kaiwata bi nopodimo ba waiwaivini vaitedi, tedi a ḡabeḡabe bi a nusanusa. ");
INSERT INTO kqf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ḡome Yesu i tauvitale bi i giuwedina gado, “Yelusalem waivinimi, koma ḡabegu, temi ko ḡaba munaḡemi bi kota natunatumi aubaidi ko ḡaba. ");
INSERT INTO kqf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Koi beyavaiya, laḡan ya natonatona kaka lava sa giuna gado, ‘Waiwaivini aiaipoidi wainatuna geḡedi bi bamo mote ai susu lubu ba sai nuwavisu.’ ");
INSERT INTO kqf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mba laḡannemo kaka lava oya sa giuwedina gado, ‘Ko dobo tawimai!’ Bi dabatuwa sa giuwedina gado, ‘Ko ḡuluvi tawimai.’ ");
INSERT INTO kqf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bamoda kai gidevinemo bi lava niga kauwidi sa voivoiyedi, bi i pokina ba bai kaka ya tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Taudanene labu Yesu vaitena a nawedi tupalatudi aubaina. ");
INSERT INTO kqf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Laḡannemo tedi dobu a wai isana kunukoukou gabunemo a tavatava, ba ḡome Yesu bi taudanene labu vaitedi a tupalatudi, ḡemota kataiyanemo bi ḡemota ḡeniyanemo. ");
INSERT INTO kqf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu i giuna gado, “Tamagu, edi gebogebo kwa noḡoti kamaḡedi! Tedi mote a sibe te bai sa voivoiye.” Bi tedi koitilimo ena gala a dailidi. ");
INSERT INTO kqf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ḡome lava kumna a moito a kitakita bi Diu babadidi a waidiboḡi, ai gwaiye bi a giuna gado, “Tana lava ḡesaudi i waiyawasanidi bi bamoda tana Keliso, Maimaituwa i Vinevinena ba taunaḡa yai yawasani munaḡe!” ");
INSERT INTO kqf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bi ḡaviḡaviyidi waidiboḡemo a saḡa bi wain wailuluna a vite, ");
INSERT INTO kqf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bi a giuwena gado, “Bamoda tam Diu edi ḡalibona ba kwai yawasani munaḡem!” ");
INSERT INTO kqf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kununa kavalinemo kai selipapinemo a gilumana gado, “Niga ba Diu edi Ḡalibona.” ");
INSERT INTO kqf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bi taudanene ḡemota i dawedawena waidiboḡemo i giuna gado, “Tam bena Keliso? Ku waiyawasanim bi kwai yawasanimai!” ");
INSERT INTO kqf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bi geḡa te taudanene ḡesauna ena tau i kaipasinena gado, “Tam mote Maimaituwa ku naile? Tam kwa pekina mai tana ya peki. ");
INSERT INTO kqf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tada giukauwa te eda kauwa gebogebodi dabedimo kovoḡa ta vaivai bi niga lavana mote bai gebona i voiye.” ");
INSERT INTO kqf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kamaina bi i giuna gado, “Yesu, laḡannemo waibada kuna vaina ba kwa noḡotigu!” ");
INSERT INTO kqf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu lavana ena giu i waimunena gado, “Giukauwemo yà giugiuwem, te niganana ba tam bi tagu Paladaisimo.” ");
INSERT INTO kqf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Suwala 12 koloki balanemo bi dobu matabuna waidudubala i waitubuna eete 3 koloki i vai. ");
INSERT INTO kqf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bi suwala lalani i kaisako bi pali vanuwinemo guduboyo i dawedawena i nuwatili labu. ");
INSERT INTO kqf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kalinana dididiginemo i ḡaba saḡana gado, “Tamagu, nimammo Aluwigu ya sakosako.” Laḡannemo giu i waiwaikovi ba yawasina i tauvunu. ");
INSERT INTO kqf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ḡome tauwaiḡaviya 100 edi bada bai i tubutubuḡana i kitakita ba Maimaituwa i kasaḡesaḡe bi i giuna gado, “Giukauwa te niga lava didimanina.” ");
INSERT INTO kqf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Laḡannemo lava matabudi a kita te Yesu bainewa a tupalatu ba tedi manuwapou yavidi bi manuwaboyedi a munaḡa edi malagaimo. ");
INSERT INTO kqf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lava matabudi Yesu tausibena bi waivini Galilimo bi a kaikaiwata nawena manemanekemo a moito bi niga kauwidi a kitekitedi. ");
INSERT INTO kqf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mba ḡome ba oloto isana Diyosep tana Alimatiya lavana bi Alimatiya taunina ba Diudiya noponemo. Tana ba lava visuvisuna bi didimanina bi Maimaituwa ena waibada ya natonatona i labelabe. Avena te tana bolu badana ḡemota bi ena lava edi ogatala bi edi kauwa mote i waianinedi. ");
INSERT INTO kqf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tana i nawa paelat lisinemo bi Yesu taubeuna i waibaḡaye. ");
INSERT INTO kqf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kamaina bi Yesu taubeuna i talui yovoḡe bi gala potipotinemo i suma. Kaka bi i avali nawe tauyewa valivaliuna, po'a doudou wainononemo i sako nawe. ");
INSERT INTO kqf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mba aubiganemo vononoḡa suwelina i kovikovi, bi Waiyawasi Laḡanna yai tubu. ");
INSERT INTO kqf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Waiwaivini Galilimo Yesu a kaikaiwatana Diyosep a kaiwata nawe tauyewamo bi bainewa Yesu taubeuna i sakosakona a kita. ");
INSERT INTO kqf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kamaina bi a munaḡa edi malagaimo te bona bi masi panepanedi a kanonoḡidi, bi Waiḡake ena luvamo aubaina te Waiyawasi Laḡannemo ai yawasi. ");
INSERT INTO kqf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande olaolalemo kaikana waiwaivini bona panepanedi a kaka nonoḡidina a legaudi bi a nawa tauyewamo. ");
INSERT INTO kqf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ḡome tedi ḡakima ḡimaḡima kamaḡena tauyewa mataetinemo a kita, ");
INSERT INTO kqf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kamaina bi tedi tauyewamo a sola nawa bi Bada Yesu tubuḡina mote a banavi. ");
INSERT INTO kqf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ḡome a moito bi kauwina a wainuwanoḡonoḡotae ba i waimaḡemoti te olooloto labu edi gala waimatakanikanidi diyedimo a moito kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mba waivinidi a naila gulata bi a laudulu yovo doḡamo. Kamaina bi oloolotodi a giuwedina gado, “Bai aubaina tana miyamiyana pekipekidi edi gabumo ko tavutavuḡe? ");
INSERT INTO kqf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tana mote niga ḡome, tana kaikana Maimaituwa i kakenamoito. Laḡannemo temi Galilimo bi tana bai i giugiuwemina ko noḡotidi: ");
INSERT INTO kqf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Maimaituwa ya ḡoeḡoe te Tana Taunana Natuna kaka gebogebo lavedi nimedimo sa sako, te sa tupalatu bi laḡan waifaioninemo ya kakenamoito munaḡe.’” ");
INSERT INTO kqf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ḡome ba waivinidi Yesu ena giu a noḡotidi, ");
INSERT INTO kqf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","laḡannemo tauyewamo a tava munaḡa ba tedi niga kauwidi matabudi ena tauwaikaiwatana 11 bi lava ḡesaudi a giuwedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mba waivinidi ba Meli Magdalin, Diyowena, Diyemesi tinana Meli bi waivini ḡesaudi vaitedi, niga kauwidi giugiukamaḡedi a giuwedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bi tedi niga waivinidi mote ai sumaḡedi, banina edi giu vaiyedi lisidimo ba banidi geḡa. ");
INSERT INTO kqf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ḡome Pita i miyamoito bi i velau ota te tauyewamo i tava bi i launevali te gala taudiḡa i kitedi a kenakena. Tana i munaḡa, bi bai i tubutubuḡana i wainuwanoḡonoḡotae. ");
INSERT INTO kqf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mba laḡanna ḡemotinemo Yesu ena tauwaikaiwatana labu a nawanawa Emasi malagainemo, bi Yelusalem te Emasi ena maneka ba 11 kilomita. ");
INSERT INTO kqf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tedi a nawanawa bi kauwa matabudi nove a tubutubuḡana a waigiugiuwedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tedi mba nawanemo bai i tubutubuḡana a giuwedi bi a waitalapiliyedi, ba Yesu i moito nato te vaitena a nawa, ");
INSERT INTO kqf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","bi i voiye munaḡe te mote a kita ḡone. ");
INSERT INTO kqf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kamaina bi Yesu i waitalayedina gado, “Temi ko nawanawa bi bai ko waitalapiliyedi?” Tedi manuwaboyedi a moito moimoisili. ");
INSERT INTO kqf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ḡesauna isana Kliyopas Yesu i waitalayena gado, “Tam tautavatava te Yelusalemmo kauwa a tubutubuḡana niga laḡandimo mote ku sibedi?” ");
INSERT INTO kqf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bi Yesu i waitalayedina gado, “Bai kauwidi?” Bi ena giu ai munena gado, “Bi Nasalet Yesuna lisinemo kauwa a tubutubuḡana. Niga lavana ba taugiuwatana, ena giu bi ena kauwa ba ai poya gulata Maimaituwa bi lava matedimo. ");
INSERT INTO kqf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pilisi edi babada bi tama ema babada tana a vai te ḡaviḡaviyidi nimedimo a sako bi a tupalatu te i peki. ");
INSERT INTO kqf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bi tama ke noḡoti te Tana Taunana i tava te Islael ya kuvesidi, bi niga kauwidi a tubuḡana ba laḡan faiona a kovi. ");
INSERT INTO kqf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Waivini ḡesaudi vaitedi miyamiyamai kaikana olaolalemo a nawa tauyewamo, bi edi giumo ke sove, ");
INSERT INTO kqf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","te Yesu taubeuna mote a banavi. Tedi a munaḡa tava bi a giu te wailovemo aneya a kitedi, bi aneyidi waivini a giuwedi te Yesu ba i yawasana munaḡa. ");
INSERT INTO kqf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ḡome ema lava ḡesaudi a velau a nawa tauyewamo bi a kita kauwe te waivinidi bai a giugiuwena ba giukauwa te Yesu mote a banavi.” ");
INSERT INTO kqf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kamaina bi Yesu i giuwedina gado, “Temi kemi opa, bi nopomi a ḡaiḡai te taugiuwatana bai matabudi a giugiuwedina mote koi sumaḡedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Temi kona sibe ee geḡa te Keliso niga kauwidi yai nuwatoiyedi kaka ena namalemo ya saḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bi Yesu giu Mousis bi taugiuwatana matabudi lisidimo i waitubu te edi bukamo tana a gilugilumiwatana giuna i tanesi kauwe tedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bi tedi Emasi malagaina diyanemo a tavatava ba Yesu i vamakamakai te bena kage ya vawaitulidi, ");
INSERT INTO kqf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","bi geḡa te tedi ai baḡa vavasaḡena gado, “Vaitemai ta kena, kaikana dobu ya waidudubala.” Kamaina bi i sola nawa vanuwemo te vaitena a miya. ");
INSERT INTO kqf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Laḡannemo Yesu olooloto labu vaitedi teibolo a miya kwaivivili, tana buledi i vai Tamana i waiebone, i kivi bi i vitedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ḡome tedi matedi i yana bi laḡannemo a kitakita ḡone ba matedimo tana i yaufa. ");
INSERT INTO kqf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tedi ai tala vivilana gado, “Sauginemo etamo lisidemo gilugilumina i giugiuwedana ba nopoda i kalakalatina maibena kai.” ");
INSERT INTO kqf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tedi noi taunana te a miyamoito bi a munaḡa Yelusalem. Ḡome ena tauwaikaiwatana 11 bi edi lava ḡesaudi vaitedi ai ḡemotidi a miyamiya bi labudi a tava, ");
INSERT INTO kqf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bi tedi giuna a vaiyena gado, “Giukauwa te Bada i kenamoito munaḡa bi Saimon lisinemo i laumaḡata.” ");
INSERT INTO kqf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tedi labuidi etamo bai i tubutubuḡana bi bainewa Yesu buledi i kivi bi a kitakita ḡonena taunana edi lava a giuvitedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tedi yaḡolo niga kauwina a giugiuwedi ba Yesu tana otina poudimo i laumaḡata bi i giuwedina gado, “Manuwaubemi.” ");
INSERT INTO kqf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tedi ḡome a naila bi ai noḡota bena alualuwa a kitakita. ");
INSERT INTO kqf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bi Yesu i giuwedina gado, “Bai aubaina ko nainaila bi ko nuwanuwalaḡalaḡa? ");
INSERT INTO kqf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimagu bi kaḡegu ko kitedi bi ko taukonigu kaka ko sibegu. Banina alualuwa mote waivisiḡonina bi waisiliḡena bi tagu ba waitubuḡigu.” ");
INSERT INTO kqf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Laḡannemo giu i waiwaikovi ba nimana bi kaḡena i wailovedi. ");
INSERT INTO kqf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tedi sove bi yasisi i waiwanavudi bi yaḡolo te mote ai sumaḡe, taunana aubaina i waitalayedina gado, “Lisimimo kani ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tedi iyana bukabukana a vite, ");
INSERT INTO kqf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","tana i vai te matedimo i kani. ");
INSERT INTO kqf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bi i giuwedina gado, “Wala vaitegu te miyamiyana ba niga mainana e giuwemi. Mousis ena waiḡake, taugiuwatana bi Deivida ena Sale bukedi matabudi tagu a gilugilumi wataguna ba niganana kaka banidi sa tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ḡome kaka Yesu i voiyedi te nopodi a nuwakamaḡa bi gilugilumina a sibe. ");
INSERT INTO kqf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yesu i giuwedina gado, “Gilugiluminemo ba niga mainana a gilumi: Keliso kaka yai nuwatoi bi laḡan waifaioninemo pekimo ya kenamoito munaḡa, ");
INSERT INTO kqf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","bi temi isanemo laukuvasa bi gebogebo noḡoti kamaḡedi ko lauguguyae. Yelusalemmo koi tubu bi ko nawa dobu matabuna isuna te isuna. ");
INSERT INTO kqf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Temi taunana bai matabuna kona kitakitana taugiuwatawatana. ");
INSERT INTO kqf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bi tagu kaka Aluwa Waiyawa yà giukamaḡe yovoḡe mai Tamagu i giugiuwapaena luvanemo. Temi niga malagaina dididiginemo ko wailabana eete malaḡa ḡailisi dabemimo ya yovo.” ");
INSERT INTO kqf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ḡome te Yesu i waidoli nawedi Betenimo. Kamaina bi nimana i lagetidi bi i kavisuvisudi. ");
INSERT INTO kqf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laḡannemo i kaka visuvisudi ba Maimaituwa i lageti nawe malamo. ");
INSERT INTO kqf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tedi a lauduneye bi mayasisidi a munaḡa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi laḡan matabuna tedi pali vanuwinemo, Maimaituwa a kakasaḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Muliḡa kaka bai matabudi a tubuḡana bi pakanemo ba Giu, bi Giuna ba Maimaituwa vaitena, bi Giu taunana Maimaituwa. ");
INSERT INTO kqf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Muliḡa kaka bai matabudi a tubuḡana bi Giu ba Maimaituwa vaitena. ");
INSERT INTO kqf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tana dabanemo mwali matabudi Maimaituwa i voiyedi, tana bi geḡa maso mote Maimaituwa bai ḡesauna i voiye. ");
INSERT INTO kqf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tana lisinemo ba yawasana, bi mba yawasanina ba lava matabudi edi yanayana. ");
INSERT INTO kqf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bi yana ba boimatuwemo ya yanayana, bi boimatuwa mote ḡemoḡemotina te ima lauyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mba ḡome ba oloto isana Diyon, Maimaituwa i giukamaḡe te i tava. ");
INSERT INTO kqf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tana i tava te lava lisidimo yanayana i giuwata bi ena giumo ba lava matabudi sai sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Diyon tana mote yanayana, bi i tavana mba yanayanana i giuwata. ");
INSERT INTO kqf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yanayana giugiukauwina kaka dobumo ya yovo bi tana taunana kaka lava matabudi yanayana ya vitedi. ");
INSERT INTO kqf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tana dabanemo Maimaituwa dobu i voiye bi geḡa te, dobumo i yovona ba dobu lavedi mote a kitaḡone. ");
INSERT INTO kqf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tana i yovo ena lava otidi lisidimo, bi geḡa te mote a giuvai. ");
INSERT INTO kqf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bi tedi mabai a giuvai bi isanemo ai sumaḡana ba i waianinedi te Maimaituwa natunatuna. ");
INSERT INTO kqf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tedi mote tina bi tama edi ḡowanemo ee lava ota edi ḡailisimo a tubuḡa bi Maimaituwa ena ḡailisimo a tubuḡa vitala. ");
INSERT INTO kqf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Giu i waila lava bi lisidemo i miya. Tama ena ḡailisi namalina ke kita, Natuna lauḡemotina namalina, Tana Tamana lisinaḡa i yovo, sagu bi giukauwa i waiwanavu. ");
INSERT INTO kqf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Diyon ba tana taunana i giugiuwata bi kalinana dididiginemo i giugiuna gado, “Niga taunana e giugiuwatana gado, ‘Tana muliguḡa ya natonatona taunana i tausaḡana mote mai tagu, banina tana i miyamiya kaka tagu e tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tana ena sagu wanawanavunemo ba tada matabuda kavisuvisu ya viteviteda. ");
INSERT INTO kqf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Maimaituwa waiḡake Mousis lisinaḡa i giukamaḡe yovoḡe, bi sagu bi giukauwa ba Yesu Keliso lisinaḡa i yovo. ");
INSERT INTO kqf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aiyai mote bamo Maimaituwa i kita, bi Natuna lauḡemotina tana kota Maimaituwa bi Tamana vaitena ḡemoḡemotidi, tana taunana Tamana lava lisidemo i kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Diu babadidi Yelusalemmo, pilipilisi ḡesaudi bi Livai damnemo lava a giukamaḡedi, Diyon lisinemo bi sai talaye te tana ba aiyai. ");
INSERT INTO kqf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Diyon edi giu waimunena mote i daboke bi i giu waimaḡati munaḡena gado, “Tagu mote Keliso.” ");
INSERT INTO kqf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kamaina bi tedi ai talana gado, “Te tam ba aiyai? Tam Elaidiya, ee?” Bi Diyon edi giu i waimunena gado, “Geḡa, tagu mote Elaidiya.” Bi tedi ai tala munaḡena gado, “Te tam taunana tauwaiyawasana a labelabena, ee?” Bi tana edi giu i waimunena gado, “Geḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tedi ena giu ai munena gado, “Tena ku giuwemai tam aiyai, bi tama ka munaḡa te taugiukamaḡemai ka giuvitedi. Tam bainewa kwa giugiu munaḡem?” ");
INSERT INTO kqf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bi Diyon Taugiuwatana Aisaiya i giugiuna luvanemo edi giu i waimunena gado, “Tagu taunana kalina kalakalalelemo yà binabinauna gado, ‘Bada ena eta ko kadidimani.” ");
INSERT INTO kqf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kamaina bi Palisi a giugiukamaḡedina Diyon ");
INSERT INTO kqf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ai talayena gado, “Bamoda tam mote Keliso ee Elaidiya ee taugiuwatana, te bai aubaina lava kwa kakabuludi?” ");
INSERT INTO kqf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Bi Diyon edi giu i waimunena gado, “Tagu gaubemo lava yà kakabuludi, bi modomimo ba lava ḡemota i moito saḡana mote ko sibe. ");
INSERT INTO kqf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tana taunana muliguḡa ya natonato. Bi tagu mote e visu gulata te ena kaḡesuma ḡulevina yà kaikamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Niga kauwidi matabudi ba Betenimo a tubuḡa, Diyoudan Gaubina noi nevanemo bamo Diyon lava i kakabuludinemo. ");
INSERT INTO kqf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Laḡan i sako te Diyon, Yesu i kita lisinemo i natonato ba i giuna gado, “Ko kita, Maimaituwa ena sipu lauewalina, dobu lavedi edi gebogebo taukaikamaḡena! ");
INSERT INTO kqf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tagu niga taunana e giugiuwatana gado, ‘Lava muliguḡa ya natonatona ba i saḡa gulatana mote mai tagu banina, tana i miyamiya kaka tagu e tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tagu mote tana e sibe, bi bai aubaina gaubemo e kakabuluna ba banina tana Islael lavemi lisimimo yà kamaḡati.” ");
INSERT INTO kqf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Bi Diyon bai i kitakitana i giuwatana gado, “Tagu Aluwa Waiyawa e kita maibena gabubu malaḡa i yovo te tana dabanemo i miya. ");
INSERT INTO kqf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tagu yaḡolo mote tana yà sibe bi Maimaituwa i giukamaḡegu te lava gaubemo e kakabuludi bi i giuweguna gado, ‘Aluwa Waiyawa kaka ya yovo te lava dabanemo ya miyana kwa kita. Tana taunana kaka Aluwa Waiyawemo lava ya kabuludi.” ");
INSERT INTO kqf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Diyon i giuna gado, “Tagu e kita bi yà giugiuwemi te tana taunana Maimaituwa Natuna.” ");
INSERT INTO kqf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Laḡan i sako munaḡa bi Diyon kota ḡome ena tauwaikaiwatana labu vaitedi a moimoito. ");
INSERT INTO kqf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sauginemo Diyon i kita te Yesu i nato i nawanawa ba i giuna gado, “Temi labuḡimi ko kita, noi taunana Maimaituwa ena sipu lauewalina!” ");
INSERT INTO kqf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ḡome Diyon ena tauwaikaiwatana labu ena giu a vaivaiye ba Yesu a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu i tauvitale bi i kitedi tana a kaikaiwata ba i waitalayedina gado, “Temi labuḡimi ba bai ko ḡoyeḡoye?” Bi tedi a giuna gado, “Labai. Niga giuna banina ba Tauwailovelove. Tam bamo ḡome kwa miyamiya?” ");
INSERT INTO kqf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu edi giu i waimunena gado, “Temi labuḡimi ko nato kaka ko kita.” Kamaina bi a nawa te a kita bi suwala ba 4 koloki bi ḡome Yesu vaitena a miya te i dudubala. ");
INSERT INTO kqf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tedi labuḡidi Diyon ena giu a vaiye bi Yesu a kaikaiwatana, ḡemota ba Saimon Pita tasina Endulu. ");
INSERT INTO kqf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Endulu maḡemota tuwaḡana Saimon i banavi bi i giuwena gado, “Tama Vinevinena ke banavi, tana taunana Keliso.” ");
INSERT INTO kqf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kamaina bi Endulu tuwaḡana Pita i waidoli tavaite Yesu lisinemo. Yesu, Pita i kita bi i giuwena gado, “Tam isam ba Saimon, Diyon natuna bi geḡa te niganana ba tam isam Kipasi.” Niga isana ba ḡemotina mai Pita bi banina ba ḡakima. ");
INSERT INTO kqf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Laḡan i sako ba Yesu i wainuwanoḡonoḡota te ya nawa Galili Plovinsnemo. Tana Filip i banavi bi i giuwena gado, “Ku kaiwatagu!” ");
INSERT INTO kqf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ba Betsaida lavana bi Endulu bi Pita kota mba malagaina lavedi. ");
INSERT INTO kqf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip, Nataniyel i banavi bi i giuwena gado, “Mousis ena waiḡake bi kota taugiuwatana lavana a gilugilumiwatana ke banavi. Yesu ba Nasalet malagaina lavana, Diyosep natuna.” ");
INSERT INTO kqf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel i waitalana gado, “Nasaletiḡa ba bai visuvisuna kaka ya nato?” Bi Filip i giuna gado, “Kwa nato kaka matammo kwa kita.” ");
INSERT INTO kqf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Laḡannemo Yesu, Nataniyel i kita diyanemo i tavatava ba i giuna gado, “Niga ba Islael otina, tana lisinemo mote bamo kaiyovu.” ");
INSERT INTO kqf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel i waitalana gado, “Tam bainewa bi tagu kuna sibegu?” Bi Yesu giu i waimunena gado, “Tam Fig kaina pakanemo e kitam muliḡa kaka Filip i yogem.” ");
INSERT INTO kqf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel giu i waimunena gado, “Labai, tam taunana Maimaituwa Natuna! Tam taunana Islael ena Ḡalibona!” ");
INSERT INTO kqf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kamaina bi Yesu i giuna gado, “Tam kunai sumaḡana ba, banina tagu e giuwem te tam Fig kaina pakanemo e kitam. Tam kaka kauwa nananakidi kwa kitedina mote mai niga taunana.” ");
INSERT INTO kqf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu kota giu i wailautawina gado, “Giukauwa yà giugiuwem, tam kaka mala nuwawasana kwa kita, bi Maimaituwa ena aneya wawanaḡa sa yovoyovo bi sa saḡasaḡa. Mba wawanina ba tagu Tana Taunana Natuna.” ");
INSERT INTO kqf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Laḡan waifaioninemo, Keina tauninemo Galili Plovins noponemo naḡi soina i tubuḡa. Bi Yesu tinana ba ḡome. ");
INSERT INTO kqf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu bi ena tauwaikaiwatana edi giu a giukamaḡe te mba soinemo sa tava. ");
INSERT INTO kqf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Laḡannemo waen i kovi ba Yesu tinana Yesu i giuwena gado, “Tedi edi waen i kovi.” ");
INSERT INTO kqf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu giu i waimunena gado, “Waivini, tam kwa giugiuwegu te maso bai yà voiye bi tagu egu sauga yaḡolo mote i tava.” ");
INSERT INTO kqf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ḡome te Yesu tinana taupaula i giuwedina gado, “Bai yai utaniyemina mba ko voiye.” ");
INSERT INTO kqf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ḡome ba dubi wapedi 6 ai moitodi, bi Diu edi vaivai luvanemo mba edi anilaukoḡa. Bi dubi ḡemoḡemotaḡa ba 100 lita luvana ai moitodi. ");
INSERT INTO kqf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu taupaula i giuwedina gado, “Gauba ko ledu bi niga dubidi koi wanavudi.” Kamaina bi ai wanavudi te gayagabulidimo. ");
INSERT INTO kqf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tana i giuwedina gado, “Ko yai'i vaidi bi ko nawa soi badana ko vite.” Yesu i giugiuna mainana a voiye ");
INSERT INTO kqf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","bi soi badana gauba i waila waenina i tego lubuye bi mote i sibe te mba waenina bamo maiḡa a tavaite, bi taupaula gauba tauyai'ina taudiḡa a sibe. Kamaina bi soi badana lawelawena i giuvai tabudimo ");
INSERT INTO kqf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bi i giuwena gado, “Lava matabudi waen laukaina sa geigei tego, bi laḡannemo tauliso sa tego te sa tego gulata, mulinemo kaka waen tomatomana ko soiye. Bi tam waen laukaina kuna alalabe eete niganana.” ");
INSERT INTO kqf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Niga malagaina Keina ba Galili Plovins noponemo, ḡome Yesu mataila dolidolina i voiye te ena ḡailisi namalina i kamaḡati bi ena tauwaikaiwatana ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Niga kauwina mulinemo ba Yesu tinana, tasitasina bi ena tauwaikaiwatana vaitedi a yovo a nawa Kapeniyam malaginemo. Bi ḡome a taumiya. ");
INSERT INTO kqf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ḡotona te maso Vawaitauli Soina laḡanna i tavana ba Yesu i saḡa i nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tana lava i kitedi pali vanuwina ganakukuna noponemo, kau, sipu bi gabubu a waikunekuneyedi bi lava ḡesaudi ba mane teibolodimo a miya bi wali dobu manedi a senisenisidi. ");
INSERT INTO kqf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Taunana aubaina, maḡinemo anilaubiti i voiye te sipu, kau bi lava matabudi i kwavivaidi te pali vanuwina didiyauna a potiyovo kamaḡe, mane tauvitaledi edi peni i laidabalalidi bi edi teibolo i vitaledi. ");
INSERT INTO kqf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tedi mabai gabubu a waikunekuneyedina i giuwedina gado, “Niga gabubudi ko kapotiyovodi, Tamagu ena vanuwa mote koma voiye te aniwaikunekune gabuna.” ");
INSERT INTO kqf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bi ena tauwaikaiwatana mba kauwina i tubutubuḡa ba gilugilumina wadubona a noḡotina gado, “Oo Bada, em vanuwa nuwaboyina ba Nopogu ya kalakalatina mai kai.” ");
INSERT INTO kqf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kamaina bi Diu babadidi a tava Yesu lisinemo bi ai talayena gado, “Bai matailina kwai lovemai bi ka kita te tam waibada kuna vai bi niga kauwidi matabudi kwa voivoiyedi?” ");
INSERT INTO kqf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu edi giu i waimunena gado, “Niga pali vanuwina, ko dousuwasuwa bi laḡan faiona nopodimo ba yà keli munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tedi ena giu ai munena gado, “Niga pali vanuwina ba kwalabu 46 nopodimo a keli, bi tam laḡan faiona nopodimo kwa keli, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bi geḡa te, Yesu pali vanuwina i giugiuwena ba tubuḡina i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sauginemo Yesu pekimo i kenamoito mulinemo ba ena tauwaikaiwatana lisidimo bai i giugiuwedina a noḡotidi. Ḡome Yesu ena giu i giugiuwedina bi gilugilumina wadubona ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tana Yelusalemmo Vawaitauli Soinemo, mataila i voivoiyedina lava wapewapedi a kitedi bi isanemo ai sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bi Yesu mote lava i waisumaḡedi, banina tana lava matabudi nopodi i sibedi. ");
INSERT INTO kqf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tana mote i ḡoye te aiyai ya nato lisinemo bi lava ḡesaudi edi kauwa ya giuwe, banina tana lava nopodi i sibedi. ");
INSERT INTO kqf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mba ḡome ba oloto isana Nikodimas, tana ba palisi ḡemota bi Diu lavedi edi bada. ");
INSERT INTO kqf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dudubala ḡemota i tava Yesu lisinemo bi i giuwena gado, “Labai, tama ke sibem te tam ba tauwailovelove, Maimaituwa lisinaḡa kuna yovo. Tam mataila kwa voivoiyedina ba sa kakamaḡatim te tam ba Maimaituwa vaitena.” ");
INSERT INTO kqf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu giu i waimunena gado, “Giukauwemo yà giugiuwemi te aiyai mote Maimaituwa ena waibadana ima kita te ya tubuḡa vitala kaka ya kita.” ");
INSERT INTO kqf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas i waitalana gado, “Lava magulina ba bainewa tinana bwaganemo ya solasaḡa bi ya tubuḡa munaḡa? Geḡa, tana mote tinana bwagamo ima sola saḡa bi ima tubuḡa munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu giu i waimunena gado, “Giukauwemo yà giugiuwem te aiyai mote Maimaituwa ena waibadamo ima sola saḡa te tana gaubemo ya buluyovo bi Aluwa Waiyawa ya laivaliu munaḡe kaka ya solasaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lava ya tubutubuḡana ba tina bi tama edi ḡowanemo ya tubutubuḡa, bi aluwemo ya tubutubuḡana ba Aluwa Waiyawemo ya tubuḡa vitala. ");
INSERT INTO kqf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tam mote egu giu kumai nuwanaine, temi ba kamaina te ko tubuḡa vitala. ");
INSERT INTO kqf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bamo maiḡa yavala ya lausuvena ba i ḡoyeḡoyena mainana ya lausuve. Daguguna ko vaiyena bi mote koma sibe te bamo maiḡa ya saḡasaḡa ee ya nawanawa. Mba mainana kota lava matabudi Aluwemo sa tubutubuḡa vitalana mote kaka koma sibedi.” ");
INSERT INTO kqf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas i waitalana gado, “Mba ba bainewa?” ");
INSERT INTO kqf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu i giuna gado, “Tam ba Islael edi tauwailovelove, bi niga kauwidi mote kuma sibesibedi? ");
INSERT INTO kqf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Giukauwemo yà giugiuwem, tama bai ke sibesibena taunana ka giugiuwe, bi bai ke kitakitana ka giugiuwata bi geḡa te ema giu yaḡolo mote komai anine. ");
INSERT INTO kqf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bi tagu dobu kauwidi kage e giugiuwatedi bi mote koi sumaḡa te mala ena kauwa yà giuwemina ba bainewa koi sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aiyai mote i saḡa i nawa malamo te Tana Taunana Natuna malaḡa i yovoyovona taunana i munaḡa malamo.” ");
INSERT INTO kqf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Maibena Mousis, wala kalakalalelemo kai modonemo mwata i kaikailagetina, mainana kota Tana Taunana Natuna sa kailageti, ");
INSERT INTO kqf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te lava sa waisumaḡena ba yawasana ilailala sa vai. ");
INSERT INTO kqf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Taunana aubaina, Maimaituwa dobu lavedi i ḡoye gulatedi te Natuna lauḡemotina i vitedi te mabai sa waisumaḡena mote sima peki bi yawasana ilailala sa vai. ");
INSERT INTO kqf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Maimaituwa Natuna i giukamaḡe yovoḡe dobumo mote laukivigebogebo aubaina bi dobu lavedi waiyawasanidi aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tedi mabai Maimaituwa Natuna lauḡemotina sa waisumaḡena ba Maimaituwa mote ima pasilidi. Bi mabai mote simai sumaḡe ba kaikana pasipasilidi, banina tedi mote Maimaituwa Natuna isanemo ai sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Niga mainana kovoḡa ya noyanoya: Maimaituwa ena yanayana ba dobumo i yovo. Bi lava waidudubala a ḡoye mote mai yana, banina edi kauwa a gebo gulata. ");
INSERT INTO kqf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tedi mabai kauwa gebogebodi sa voivoiyedina ba yana sa dabodaboke. Bi mote kaka yanayanamo sima nato, banina a naila bi mote a ḡoye te edi gebogebo sa kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bi kota tedi mabai yawasana giugiukauwinemo sa miyamiyana ba yanayanamo a nato, bi yanayana i laimaḡatidi te bai sa voivoiyedina ba giukauwa te Maimaituwa sa vovoteyeteye. ");
INSERT INTO kqf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Niga kauwina mulinemo, Yesu ena tauwaikaiwatana vaitedi a potiyovo a nawa Diudiya plovins noponaḡa, bi ḡome tana tedi vaitedi a miya bi lava a kakabuludi. ");
INSERT INTO kqf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Diyon kota Ainonmo dobu Salim diyanemo i laulaukabulu, banina ḡome ba gauba wapewapedi bi lava lisinemo a tava bi i kakabuludi. ");
INSERT INTO kqf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Niga kauwina mulinemo kaka Diyon biliwelokomo a sakonawe. ");
INSERT INTO kqf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Diyon ena tauwaikaiwatana ḡesaudi Diu lavana vaitena laukoḡa vaivaina dabanemo ai kagiu. ");
INSERT INTO kqf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tedi a nato Diyon lisinemo bi a giuna gado, “Labai, kuna noḡoti mba olotona Diyoudan gaubina noi nevanemo kuna giugiuwena, ba niganana ya laulaukabulu. Bi lava matabudi tana lisinemo sa nawanawa.” ");
INSERT INTO kqf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ḡome Diyon giu i waimunena gado, “Lava mote bai ima voiye yababe te Maimaituwa bai noyana ya vitena kaka ya voiye. ");
INSERT INTO kqf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Temi taunana ko giu waimaḡatigu te tagu mote Tauwaiyawasana bi Maimaituwa i giukamaḡegu te e gei doli bi Tauwaiyawasana ba muliḡa ya natonato. ");
INSERT INTO kqf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lawelawe ba lawelawena aubaina. Bi naḡi soinemo lawelawe ena tau ya tavana ba ya labe bi yai beyavaiye. Bi laḡannemo lawelawe kalinana ya vaivaiye ba ya yasisi gulata. Maibena tagu niganana e yasisi gulata bi nuwagu i kena. ");
INSERT INTO kqf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tana ba kamaina te ya saḡa gulata bi tagu ba yovoyovogu. ");
INSERT INTO kqf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tana aiyai malaḡa i yovoyovona ba i saḡa gulatana mote mai lava matabudi. Bi tana aiyai dobumo, bi dobu ena kauwa ya giugiuwatedina ba tana dobu lavana. Tana malaḡa i yovoyovona taunana i saḡa gulatana mote mai lava matabudi. ");
INSERT INTO kqf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tana bai i kitekitedina bi i vaivaiyedina taudidi ya giugiuwatedi. Bi geḡa te, lava mote ena giu koma waisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aiyai giudi i vaiyedi bi i waisumaḡedina ba i sibe te Maimaituwa ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tana taunana Maimaituwa i giukamaḡe te Maimaituwa giuna ya giugiuwe, banina Maimaituwa Aluwina tana i waiwanavu kauwe. ");
INSERT INTO kqf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana ba Natuna i ḡoye gulate, taunana aubaina ḡailisi i vite te bai matabudi yai badayedi. ");
INSERT INTO kqf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tana aiyai Natuna ya waisumaḡena ba yawasana ilailala ya vai, bi aiyai Natuna mote ima waisumaḡe ba mote yawasana ima vai, bi Maimaituwa ena medi ba tana lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu i sibe te Palisi ba tana giuna a vaiye te tauwaikaiwatana wapewapedi nuwedi i vitaledi bi i kakabuludina mote mai Diyon. ");
INSERT INTO kqf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu mote aiyai i kabulu, bi ena tauwaikaiwatana taudiḡa lava a kakabuludi. ");
INSERT INTO kqf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bi sauginemo Yesu niga giuna i vaivaiye ba tana Diudiya Plovinsna i gose bi i munaḡana Galili Plovinsnemo. ");
INSERT INTO kqf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mba nawanemo ba Sameliya noponaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tana Saika malagainemo i tava Sameliya Plovinsnemo. Bi mba malagaina ba Deikap natuna Diyosep wala doḡa ḡaubona i vitevitena diyanemo. ");
INSERT INTO kqf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yesu i nawanawana eete, suwala modo balana bi nawa i poka, taunana aubaina tana Deikap ena gauba domna diyanemo i miyatulu. ");
INSERT INTO kqf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kamaina bi Sameliya waivinina i tava gauba yai'ina aubaina bi ḡome Yesu waivini i giuwena gado, “Aee, gauba ku vitegu yà tego.” ");
INSERT INTO kqf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bi ena tauwaikaiwatana ba a nawa taunimo kani gimelina aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kamaina bi waivini i giuna gado, “Tam ba Diu olotona bi tagu ba Sameliya waivinina bi bainewa te lisigumo gauba tegona kwa waibaḡaye?” Niga waivinina mainana i giuna banina ba Diu lavedi bi Sameliya lavedi mote simai ḡonaḡona ḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu waivini ena giu i waimunena gado, “Bamoda Maimaituwa ena puyo vitevitena maso bi ku sibe te aiyai lisimmo tego ya waibaḡaye maso ba kunai baḡa te tana yawasana gaubina i vitem.” ");
INSERT INTO kqf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Bi waivini i giuna gado, “Bada, dom i yovo gulata bi bai mwalinemo gauba kwa yaii. Bi gauba yawayawasanina baimo kwa vai? ");
INSERT INTO kqf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tam bena kuna tausaḡa kaka ema magula Deikap, ee? Tana niga gaubina domna i vitemai, tana, natunatuna bi kota ena ḡamoḡamo niga ḡome gauba a vaivai.” ");
INSERT INTO kqf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu giu i waimunena gado, “Lava matabudi niga gaubina sa tegotegona ba gadodi ya magu munaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bi tedi mabai gauba yà vitedi bi sa tegona ba mote kaka gadodi ima magu munaḡa. Niga gaubina yà vitedina ba mai tovosa laulaupusuwalina te yawasana ilailala sa vai.” ");
INSERT INTO kqf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Bi waivini Yesu i giuwena gado, “Aee Bada, gaubina ku vitegu yà tego te mote gadogu ima magu munaḡa bi niga gaubina dommna waivelau muneḡana yà kaisako.” ");
INSERT INTO kqf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Bi Yesu waivini i giuwena gado, “Kwa nawa te mwanem kwa giuwe bi ko nato munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bi waivini i giuna gado, “Tagu mwanegu geḡa.” Yesu waivini ena giu i waimunena gado, “Mba kuna giukauwa te tam mwanem geḡa. ");
INSERT INTO kqf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bai kuna giuwena ba giukauwa te tam wala olooloto wapedi 5 kuna naḡidi, bi niganana oloto vaitena ko miyamiyana ba mote tam mwanem.” ");
INSERT INTO kqf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bi waivini i giuna gado, “Bada, niganana kaka e sibe te tam ba taugiuwatana. ");
INSERT INTO kqf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tamatamamai niga oyanemo a laulaudune bi temi Diu lavemi ko giugiu te Yelusalem ba anilaudune gabuna.” ");
INSERT INTO kqf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu waivini i giuwena gado, “Waivini, kwai sumaḡegu te sauga ya natonatona lava mote kaka Tamagu niga oyanemo e Yelusalemmo sima lauduneye. ");
INSERT INTO kqf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Temi Sameliya lavemi mote ko sibe te aiyai ko laulauduneye, bi tama Diu lavamai ba ke sibe te aiyai ka laulauduneye, banina waiyawasana ba tama lisimaiḡa ya natonato. ");
INSERT INTO kqf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bi geḡa te, sauga ba ya natonato bi kaikana i tava, mba sauginemo kaka taulaudune giugiukauwidi Tamada sa lauduneyena Aluwemo bi giukauwemo, mba laudunena taunana Tamada ya ḡoyeḡoye. ");
INSERT INTO kqf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Maimaituwa ba Aluwa. Bi taulauduneyena ba Aluwa Waiyawa ena ḡailisimo bi giukauwemo sa lauduneye.” ");
INSERT INTO kqf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bi waivini i giuna gado, “E sibe te tauwaiyawasana sa wai isana Keliso ba ya natonato, bi sauginemo i tavana kaka bai matabuna ya giuwemai.” ");
INSERT INTO kqf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kamaina bi Yesu i giuna gado, “Tana taunana tagu vaitem ta waigiugiu.” ");
INSERT INTO kqf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mba taunana te ena tauwaikaiwatana a munamunaḡa tava ba a kita bi a sove te Yesu ba waivini vaitena a waigiugiu. Bi mote aiyai i waitala gado, “Bai kwa ḡoyeḡoye e bai aubaina waivini vaitena ko waigiugiu?” ");
INSERT INTO kqf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kamaina bi ḡome waivini ena gauba dubina i gose kamaḡe bi i munaḡa taunimo bi lava i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ko nato bi oloto ḡemota ko kita. Tana bai matabudi wala e voivoiyedina i giu waimaḡatidi. Tana taunana male Keliso?” ");
INSERT INTO kqf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kamaina bi lava tauni a gose bi a nawa Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mba gavogavonemo ba ena tauwaikaiwatana a giuwena gado, “Tauwailovelove, bai maso kuna kani.” ");
INSERT INTO kqf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bi geḡa te tana i giuwedina gado, “Tagu kaguya ba temi mote ko sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kamaina bi ena tauwaikaiwatana taudiḡa ai giugiuna gado, “Lava ḡesauna male kani i vite?” ");
INSERT INTO kqf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Bi Yesu i giuwedina gado, “Tagu kaguya ba taugiukamaḡegu ena ḡowana yà voiye bi ena noya yài kovi. ");
INSERT INTO kqf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Temi wala ko giugiuna gado, ‘Nawalai 4 mulidimo ba vililubu laḡannina ya tava.’ Tagu yà giugiuwemi te koi kita bi daibi ko kitedi a laubanina vililubu aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aiyai bi daibi ya vilivililubuna ba ena mai'ia ya vaivai. Bi mba vililubuna ba lava sa natonatomedina yawasana ilailalemo te damonemo ba tauwadi bi tauvililubu sa yasisi ḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lava niga giuna sa giugiuwena ba giukauwa te, ‘Lava ḡesau tauwadi bi lava ḡesau tauvililubu.’ ");
INSERT INTO kqf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tagu e giukamaḡemi te lava ḡesaudi a wadiwadina nonoḡina ko vilivililubu.” ");
INSERT INTO kqf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mba tauninemo Sameliya lavedi wapewapedi Yesu ai sumaḡe, banina waivini i giuna gado, “Tana bai matabudi e voivoiyedina i giu waimaḡatidi.” ");
INSERT INTO kqf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sauginemo Sameliya lavedi a tava lisinemo bi ai baḡa te maso vaitena a miya, taunana aubaina, Yesu ḡome i miyana ba laḡan labu. ");
INSERT INTO kqf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bi Yesu ena giumo kota lava wapewapedi ai sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tedi waivini a giuwena gado, “Tam bai kuna giugiuwena mote taunaḡa kei sumaḡe bi tama beyaotimaimo ke vaiye bi ke sibe te tana taunana dobu lavedi tauwaiyawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Laḡan labu a kovi mulidimo, Yesu Sameliya i gose bi i nawa Galilimo. ");
INSERT INTO kqf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu tana taunaḡa i giu munaḡena gado, “Taugiuwatana ena dobu otinemo mote kaka sima vivile.” ");
INSERT INTO kqf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Laḡannemo Galili Plovinsnemo i tavatava ba Galili lavedi a giuvai, banina tana dolinemo Yelusalemmo, Vawaitauli Soinemo baibaiḡa i voivoiyedina a kitedi. ");
INSERT INTO kqf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu i munaḡa tava Galili Plovins noponemo Keina malagainemo, ḡome wala gauba i voiye te i waila waen. Bi niga tavanemo ba gabemani badana ḡemota ḡome i tava bi natuna olotona sidasidana ba Kapeniyammo. ");
INSERT INTO kqf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bi gabemani i vaiye te Yesu Diudiya Plovins i gose bi i tava Galili plovinsnemo. Tana i nawa lisinemo bi i waibaḡa te maso i yovo natuna i waiyawasani, banina natuna i sida kauwa te nuwana peki. ");
INSERT INTO kqf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu i giuwena gado, “Temi mote koma waisumaḡa bi sauginemo mataila bi anisove kauwidi ko kitedina kaka koi sumaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bi gabemani badana Yesu i giuwena gado, “Aee, Bada, kwa yovo makai muliḡa bi natugu ya peki.” ");
INSERT INTO kqf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu gabemani ena giu i waimunena gado, “Kwa nawa, bi natum ba ya yawasana.” Oloto, Yesu ena giu i waisumaḡe bi i munaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Laḡannemo i nawanawa etamo ba ena taupaula a banavi bi a giuwena gado, “Natum ba i yawasana.” ");
INSERT INTO kqf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tana i waitalayedina gado, “Bai sauginemo natugu i yawasana? Maḡo aubiga balanemo i yawasana.” ");
INSERT INTO kqf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ḡome kaka gomana tamana Yesu ena giu i noḡoti te mba aubiganemo Yesu i giuwena gado, “Natum ba ya yawasana.” Taunana aubaina, tana bi ena vanuwa lavedi matabudi Yesu ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu Diudiya Plovins i gose bi i tava munaḡa Galili Plovinsnemo te niga taunana ba mataila wailabuna i voiye. ");
INSERT INTO kqf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sauga ḡesaunemo, Yesu i saḡa i nawa Yelusalemmo, Diu lavedi edi soi aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bi ḡome Yelusalemmo sipu ganakukuna mataetinemo ba topa, Alemik kalinedimo sa waiisana Betsada. Bi yoveyove wapedi 5 a moito kwaivivile. ");
INSERT INTO kqf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Bi ḡome ba lava wapewapedi sidesidedi a kenakena. Lavedi ba matapotepotedi, kaḡenuwanokudi bi tunipekipekidi topa diyanemo a kenakena. ");
INSERT INTO kqf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bi lava ḡemota kaḡenuwanokuna i miyana ba kwalabu wapedi 38 a kovi. ");
INSERT INTO kqf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sauginemo Yesu mba olotona i kita i kenakena ba i sibe te tana walakana bamo i sida, bi i waitalayena gado, “Tam kuna ḡoyeḡoyena kwa yawasana, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Oloto sidasidana giu i waimunena gado, “Bada, laḡannemo gauba ya laulaupusuwali saḡa ba mote aiyai te ya sako yovoḡegu topamo. Tagu yovo yà kabikabiye ba lava ḡesau ya geigei yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kamaina bi Yesu i giuwena gado, “Ku miyamoito, em kebana kwa vai bi kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Noi taunana te oloto i yawasana, bi ena kebana i avali te i nawa. Niga kauwina ba Diu edi Waiyawasi Laḡannemo i tubuḡa, ");
INSERT INTO kqf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","taunana aubaina Diu babadidi oloto i yawayawasanana a giuwena gado, “Niga ba Waiyawasi Laḡannina, waiḡake mote i waianinem te em kebana kwa avali bi kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tana giu i waimunena gado, “Oloto i waiwaiyawasaniguna i giuweguna gado, ‘Em kebana ku vai bi kwa nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kamaina bi tedi ai talayena gado, “Mba aiyai lavana i giuwem te em kebana kwa vai bi kwa nawa?” ");
INSERT INTO kqf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bi oloto i yawayawasanana mote i sibe te aiyai i waiyawasani, banina Yesu lava kumdi nopodiḡa i vasoyavai. ");
INSERT INTO kqf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bi muliḡa Yesu mba olotona i waiyawasanina Maimaituwa ena vanuwa noponemo i banavi bi i giuwena gado, “Kuna kita, tam niganana kuna yawasana. Gebogebo voiye munamunaḡena kwa kaisako, male bai gebogebo otina lisimmo ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kamaina bi olotona i nawa te Diu babadidi i giuwedi te Yesu ba tana i waiyawasani. ");
INSERT INTO kqf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bi Yesu niga kauwidi Waiyawasi Laḡandimo i voivoiyedina dabedimo, Diu babadidi laukivigebogeboyena ai tubu. ");
INSERT INTO kqf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bi Yesu i giuwedina gado, “Tamagu ba sauga matabuna i noyanoya bi yaḡolo ya noyanoya te tagu kota vaitegu yà noyanoya.” ");
INSERT INTO kqf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Niga giudi dabanemo, Diu babadidi a laulauyaviyavi te maso Yesu ai peki, bi mote Waiyawasi Laḡanna waidoukotona taunaḡa bi i giugiu te tana Tama otina ba Maimaituwa bi kota tana Maimaituwa vaitena ḡemoḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bi Yesu giu i waimunena gado, “Yà giugiu kauwemi te gomana taunaḡa mote bai ima voiye te Tamana bai i voivoiyena ya kita kaka tana mainana ya voiye banina, Tama bai ya voivoiyena mainana kota natuna ya voiye. ");
INSERT INTO kqf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bi Tama ba nuwana tabutabuna Natuna te bai matabuna i voivoiyedina i wailove. Bi kota kauwa nananakidi kaka yai love, te ya voiyedina mba sa tausaḡana mote mai niga kauwidi bi temi male ko sove. ");
INSERT INTO kqf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamana bainewa lava pekipekidi ya kakakenamoitodi bi yawasana ilailala ya vitevitedina kota mainana, Natuna lava mabai ya wainuwavisuyedina yawasana ilailala ya vitedi. ");
INSERT INTO kqf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamana mote aiyai ima etale bi ḡailisi matabuna ba Natuna i vite te tana kaka lava ya etaledi, ");
INSERT INTO kqf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te lava matabudi Natuna sa vivilena maibena Tamana sa vivivilena. Tana Natuna i giugiukamaḡena bi mote sima vivivile ba kota Tamana mote sima vivivile. ");
INSERT INTO kqf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Bi giukauwemo yà giugiuwemi, te tedi mabai egu giu sa vaiye bi taugiukamaḡegu sai waisumaḡena ba yawasana ilailala sa vai bi mote etalemo sima moito. Tedi peki gabuna kaikana a gose bi a natona yawasana gabunemo. ");
INSERT INTO kqf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bi giukauwa yà giugiuwemi, te sauga ya natonatona bi kaikana i tava te lava pekipekidi kaka Maimaituwa Natuna kalinana sa vaiye bi sa vaivaiye kauwena ba yawasana ilailala sa vai. ");
INSERT INTO kqf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Banina Tamagu ba yawasana pakana, bi yawasanina kota tagu Natuna i vitegu te lava lisigumo yawasana ilailala sa vai. ");
INSERT INTO kqf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bi tana waibada i vite te yà lauetala banina, tana ba Tana Taunana Natuna. ");
INSERT INTO kqf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Niga giudimo mote koma tagugu, banina sauga ya natonatona ba lava matabudi kokowagemo kaka Natuna kalinana sa vaiye, ");
INSERT INTO kqf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bi pekimo sa kenamoito. Bi lava mabai visuvisu a voivoiyena kaka sa miya nonoḡa bi mabai gebogebo a voivoiyena kaka sa pwalaḡe nawedi kovoḡa gabunemo. ");
INSERT INTO kqf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tagu mote tauguḡa bai yàma voivoiye, bi Maimaituwa i giugiuweguna luvanemo yà etaetala, bi aiyai e etalena ba didimanemo yà etaetale. Bi bai yà voivoiyena ba mote tagu egu ḡowana bi taugiukamaḡegu ena ḡowana yà voivoiye.” ");
INSERT INTO kqf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Bi bamoda tauguḡa yà giuwataguna, ba bai yà giugiuwena mote giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bi lava ḡesauna tagu egu kauwa bi egu noya ya giuwatana ba e sibe te bai ya giugiuwena ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Temi tauwainoyanoya kona giukamaḡedi Diyon lisinemo bi giukauwa i giugiuwedina ba matabudi giukauwa te tagu i giugiuwatagu. ");
INSERT INTO kqf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tagu mote lavaota edi giu yàma waianine bi Diyon e giuwatana banina ba, temi koi sumaḡa bi ko yawasana. ");
INSERT INTO kqf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Diyon ba maibena lampa a gabu bi i yanayana. Bi temi sauga watiḡena mba yanayanana konai nuwavisuye. ");
INSERT INTO kqf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Tagu egu wailovelove bi mataila yà voivoiyedina a tausaḡa mote mai Diyon. Tamagu niga noyedi i vitegu bi yà voivoiyedina taudidi sa kakamaḡatigu te tagu tana i giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bi Tamagu taugiukamaḡegu mote bamo kalinana ko vaiye e matana ko kita bi tana taunana lava lisimimo tagu ya kakamaḡatigu, ");
INSERT INTO kqf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","bi kota giuna mote nopomimo ima kenakena, taunana aubaina tana i giugiukamaḡena mote koma waisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Temi gilugilumina wadubona ko iyeiyevi kauwedina, banina ko wainoḡota te mba ḡome kaka yawasana ilailala ko banavi. Bi mote ko sibe te mba gilugilumidi matabudi ba tagu sa giugiuwatagu. ");
INSERT INTO kqf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bi geḡa te, temi mote koma ḡoyeḡoye te ko nato lisigumo bi yawasana ilailala ko vai. ");
INSERT INTO kqf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tagu mote lavaota edi kasaḡesaḡe yàma waianine ");
INSERT INTO kqf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","bi e sibe te temi nopomimo ba mote Maimaituwa koma ḡoyeḡoye. ");
INSERT INTO kqf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tagu ba Tamagu ena ḡailisimo dobumo e yovo bi geḡa te, temi ko dabodabokegu. Bi bamoda lava ḡesauna isana vatona aubaina i tavana ba nuwavisumo ko giugiuvai. ");
INSERT INTO kqf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Temi ko ḡoyeḡoye. Te lava sa kakasaḡesaḡemi bi temi maso Maimaituwa kona kasaḡesaḡena ba mote ko ḡoye. Mba mainana te bainewa tagu koi sumaḡegu? ");
INSERT INTO kqf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bi komai noḡota te tagu kaka Tamagu matanemo yàma etalemi! Geḡa, temi Mousis kowai sumaḡena, tana taunana kaka temi ya etalemi. ");
INSERT INTO kqf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bamoda Mousis konai sumaḡena ba tagu kota maso konai sumaḡegu, banina Mousis ba tagu i gilumiwatagu. ");
INSERT INTO kqf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bi Mousis bai i gilugilumina mote koi sumaḡe, mba bainewa tagu bai yà giugiuwemina koi sumaḡe?” ");
INSERT INTO kqf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Laḡan visa a kovi mulidimo, Yesu Galili topanemo wagaḡa i nawa noi nevanemo, niga topana isana ḡesauna ba Tabeliyasi. ");
INSERT INTO kqf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bi lava kumdi tana a kaiwata, banina tedi mataila a kita te sidesidedi i waiwaiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ḡome te Yesu i saḡa i nawa oyamo bi ena tauwaikaiwatana vaitedi a miyatulu. ");
INSERT INTO kqf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bi Diu lavedi edi Vawaitauli Soina laḡanna ba kaikana i tavatava. ");
INSERT INTO kqf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Laḡannemo Yesu i kita te lava kumdi a saḡasaḡa lisinemo, ba Filip i waitalayena gado, “Bamo ḡome kani ta gimeli te niga lavedi sa kani?” ");
INSERT INTO kqf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tana kaikana i sibe te bai ya voiye, bi Filip wailaulubuna aubaina te mai i waitala. ");
INSERT INTO kqf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kamaina bi Filip Yesu ena giu i waimunena gado, “Bamoda lisidemo 200 dinali bi laipwatana vaitena kaka buledi ta gimeli te lava matabudi tai kanidi.” ");
INSERT INTO kqf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Bi ḡome ena tauwaikaiwatana ḡesauna, Saimon Pita tasina Endulu, Yesu i giuwena gado, ");
INSERT INTO kqf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Niga gomenina olotona lisinemo ba buledi wapedi 5 bi iyana keikeilikidi labu. Niga kanina i ala ḡaubo bi moḡoi te lava wapewapedi tai kanidi?” ");
INSERT INTO kqf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kamaina bi Yesu ena tauwaikaiwatana i giuwedina gado, “Lava matabudi ko giuwedi te sa miyatulu.” Mba dobuna ba waigidagidana aubaina te lava a miyatulu. Bi ḡome ba olooloto wapedi maso ba 5 tausan. ");
INSERT INTO kqf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kamaina bi Yesu buledi i legaudi te Maimaituwa i waiebo bi lava gidagida dabanemo a miyamiyana lisidimo i soiyedi, bi iyana kota mainana i soiyedi te a kani. ");
INSERT INTO kqf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Laḡannemo lava a kani nonoḡa mulinemo, Yesu ena tauwaikaiwatana i giuwedina gado, “Niganana ko nawa te kani a kanikani sivudina ko laitupedi. Mote kani komai beyakuluye.” ");
INSERT INTO kqf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kamaina bi lava kani a kanikani sivudina ai ḡemotidi te po'a wapedi 12 ai wanavudi. ");
INSERT INTO kqf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Laḡannemo lava niga matailina a kitakita ba taudiḡa ai giugiuna gado, “Giukauwa te niga taunana taugiuwatana, wala a giugiuwena niganana dobumo i tava.” ");
INSERT INTO kqf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu i sibedi te tedi a ḡoyeḡoyena maso tana egalemo a voiye te i waiḡalibona, taunana aubaina i vasoyavai munaḡa te i nawa dabatuwa ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mba aubiganemo ba ena tauwaikaiwatana a munaḡa yovo Galili topanemo, ");
INSERT INTO kqf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ḡome tedi wagamo a gelu bi a nawana Kapeniyam. Bi kaikana i dududubala bi Yesu yaḡolo mote lisidimo i tava. ");
INSERT INTO kqf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tedi a taunawanawa te yavala dididiga i lausuve bi nisa wailabalabama i waitubu. ");
INSERT INTO kqf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Laḡannemo tedi waga a ḡiu bi a nawanawa topa modonemo nuwedi tava ba Yesu, topa dabanaḡa waga yawaninaḡa i natonato a kita. Bi diyedimo i tavatava ba a naila kauwa. ");
INSERT INTO kqf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bi tana i giuwedina gado, “Wae tagu, koma nainaila.” ");
INSERT INTO kqf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bi ena tauwaikaiwatana a ḡoyeḡoyena maso a solusaḡe wagamo ba i waimaḡemoti te waga dobu ḡaḡaluna a nawanawanemo i solasaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Laḡan i sako bi lava kumdi noi nevanemo a gosegosedina ai laulaukita bi a noḡoti te maḡo ba waga ḡemota ota i moimoito. Bi waganemo mote Yesu i gelu bi ena tauwaikaiwatana taudiḡa a gelu te a nawa. ");
INSERT INTO kqf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bi bamo Bada kani i kavisuvisu bi lava a kanikanina ḡome, waga ḡesaudi Tabeliyasiḡa a natonatona diyedimo a solasaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Laḡannemo lava kumna a kita te Yesu bi ena tauwaikaiwatana mote ḡome, ba tedi Yesu tavuḡena aubaina wagamo a gelu bi a nawa Kapeniyammo. ");
INSERT INTO kqf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bi laḡannemo Kapeniyammo lava Yesu a banabanavi ba ai talayena gado, “Labai, bai laḡannemo niga ḡome kuna tava?” ");
INSERT INTO kqf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu edi giu i waimunena gado, “Giukauwa yà giugiuwemi, te temi ko tavutavuḡeguna banina ba maḡo ei kanimi te kona kani nonoḡa bi niganana kota ko ḡoyeḡoyena ko kani munaḡa. Bi geḡa te, temi mataila e voivoiyedina mote banidi koma sibesibedi. ");
INSERT INTO kqf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Temi mote kani ota aubaidi koma noya, mba kanidi kaka sa gebogebo. Temi ba yawasana ilailalala kanina taunana ko noyae. Mba kanina ba Tana Taunana Natuna kaka ya vitemi, banina Tamada Maimaituwa ba tana i waianine bi ḡailisi i vite.” ");
INSERT INTO kqf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kamaina bi tedi ai talayena gado, “Maimaituwa bai noyedi ya ḡoyeḡoyena ka voiyedi?” ");
INSERT INTO kqf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bi Yesu edi giu i waimunena gado, “Maimaituwa ena ḡowana ba tana i giugiukamaḡena taunana koi sumaḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kamaina bi tedi ai tala munaḡana gado, “Mataila bai kwa voiye te tama ka kita bi kai sumaḡem? Kota bai matailina kwa voiye? ");
INSERT INTO kqf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gilugilumina wadubonemo ya giugiu te ‘Eda magumagula wala kalakalalemo a bababala bi Mousis mala kanina i vitedi.” ");
INSERT INTO kqf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bi Yesu i giuwedina gado, “Giukauwemo yà giugiuwemi te buledi malaḡa i yovoyovona mote Mousis i vitevitemi bi Tamagu i vitevitemi. Bi tagu Tamagu taunana mala buledina giugiukauwina ya vitevitemi. ");
INSERT INTO kqf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bi buledi giugiukauwina Maimaituwa malaḡa i giugiukamaḡe yovoḡena ba tana taunana dobu lavedi yawasana ya vitevitedi.” ");
INSERT INTO kqf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tedi a giuna gado, “Bada, niga buledina laḡan matabuna kwa vitemai.” ");
INSERT INTO kqf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ḡome te Yesu i kamaḡati munaḡena gado, “Tagu taunana yawasana buledina. Tedi mabai lisigumo sa natonatona ba kani mote sima peki. Bi kota mabai sa waisumaḡeguna ba gadodi mote sima magu. ");
INSERT INTO kqf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bi yà giugiuwemi te temi ko kitakitaguna bi yaḡolo mote koma waisumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tedi mabai Tamagu i viteviteguna kaka lisigumo sa nato, bi lisigumo a natona mote kaka yàma kwavivaidi. ");
INSERT INTO kqf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Banina tagu malaḡa e yovona mote egu ḡowana aubaina bi taugiukamaḡegu ena ḡowana voiyena aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bi Maimaituwa ena ḡowana ba aiyai i viteviteguna mote ḡemota ima paila, te laḡan damonemo kaka tagu pekimo yà kakenamoitodi. ");
INSERT INTO kqf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tamagu ena ḡowana ba lava mabai Natuna sa kita bi sa waisumaḡena, taudidi yawasana ilailalala a vai bi laḡan damonemo tana kaka pekimo ya kakenamoitodi.” ");
INSERT INTO kqf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mba laḡannemo Diu lavedi waipilipiliyena ai tubu, banina Yesu i giuna gado, “Tagu taunana buledi malaḡa e yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tedi a giuna gado, “Niga Yesu, Diyosep natuna, tada tinana bi tamana te sibedi. Bi bainewa te niganana i giu gado, ‘Tagu malaḡa e yovo?” ");
INSERT INTO kqf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bi Yesu i giuwedina gado, “Taumiḡa waipilipili ko kaisako. ");
INSERT INTO kqf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lava mote aiyai ima nato lisigumo te Tamagu, taugiukamaḡegu lava aiyai i natonatomena taunana lisigumo ya tavaite. Te tagu kaka laḡan damonemo pekimo yà kakenamoito munaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Maimaituwa taugiuwatana ḡemota niga mainana i giu, ‘Tedi matabudi kaka Maimaituwa yai lovelovedi.’ Bi mabai Tamagu kalinana sa vaivaiye bi giuna sa vovoteyeteye ba lisigumo sa nato. ");
INSERT INTO kqf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mote aiyai Tamada i kita bi tana aiyai Maimaituwa lisinaḡa i yovoyovona, taunaḡa Tamada i kita. ");
INSERT INTO kqf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Giukauwemo yà giugiuwemi te tana aiyai tagu ya waisumaḡeguna ba yawasana ilailalala i vai. ");
INSERT INTO kqf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Tagu taunana yawasana buledina! ");
INSERT INTO kqf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Emi magumagula wala kalakalalelemo mana a kani bi geḡa te, matabudi a peki. ");
INSERT INTO kqf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bi niga buledina taunana malaḡa i yovo. Tana aiyai bi ya kanina ba mote ima peki. ");
INSERT INTO kqf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Tagu taunana buledi kenakena nonoḡina malaḡa e yovo. Tana aiyai niga buledina ya kanina ba ya miya nonoḡa. Bi buledina taunana tubuḡigu yà vitevite munaḡe te niga dobunemo lava yawasana kenakena nonoḡina sa vai.” ");
INSERT INTO kqf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ḡome te Diu lavedi taudiḡa ai kagiuna gado, “Niga olotona ba bainewa tubuḡina ya viteda te ta kani?” ");
INSERT INTO kqf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kamaina bi Yesu i giuwedina gado, “Yà giugiu kauwemi te Tana Taunana Natuna tubuḡina mote koma kani bi kwasinina mote koma tego ba temi yawasana mote kaka koma vai. ");
INSERT INTO kqf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tana aiyai tubuḡigu ya kanikani bi kwasinigu ya tegotegona ba yawasana ilailalala ya vai. Bi laḡan damonemo tagu kaka pekimo yà kakenamoito munaḡe, ");
INSERT INTO kqf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","banina tubuḡigu taunana kani giugiukauwina bi kwasinigu kota tegotego giugiukauwina. ");
INSERT INTO kqf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tana aiyai bi tubuḡigu ya kanikani bi kwasinigu ya tegotegona ba tana nopogumo ya miya bi tagu tana noponemo yà miya. ");
INSERT INTO kqf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamagu yawayawasanina i giukamaḡegu te tana ena ḡailisimo yà miyamiya, bi kota mainana tedi mabai tagu sa kanikaniguna ba egu ḡailisimo sa miya. ");
INSERT INTO kqf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Niga buledina taunana malaḡa i yovo. Temi emi magumagula wala mana a kani, bi geḡa te a peki. Aiyai bi niga buledina ya kanina ba tana kaka ya miya nonoḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu niga giudi matabudi ba Kapeniyammo Diu lavedi edi bolu vanuwinemo lava i wailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bi laḡannemo niga wailovelovedi a vaivaiyedi ba tauwaikaiwatana wapawapa niga mainana a giu, “Niga wailovelovena ba i pilipili kauwa. Aiyai kaka wailovelovena ya kaiwata.” ");
INSERT INTO kqf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu i sibe te tauwaikaiwatana yaḡolo te niga wailovelovena a waipilipiliye. Kamaina bi i giuwedina gado, “Niga wailovelovena ya kaka pilipilimi, ee? ");
INSERT INTO kqf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sauginemo Tana Taunana Natuna ko kita ya saḡa ya nawanawa malamo wala ena animiyamo, ba bainewa koi noḡota? ");
INSERT INTO kqf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maimaituwa Aluwina taunana yawasana ya viteviteda bi tubuḡa ba geḡa. Tagu giu e giugiuwemina ba Aluwa yawasana ya natonatome. ");
INSERT INTO kqf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bi geḡa te, ḡesaumi mote koma waisumaḡa.” Pakanemo ba Yesu i sibedi te mabai mote sima waisumaḡe bi aiyai kaka tana ya sakoyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tana giu i laumunaḡena gado, “Niga taunana aubaina e giuwemina gado, ‘Mote aiyai kaka ima nato lisigumo te Tamagu mabai ya viteviteguna taudidi lisigumo sa nato.” ");
INSERT INTO kqf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Niga giudi mulidimo ba tauwaikaiwatana wapewapedi Yesu a gose kamaḡe bi mote a kaiwata munaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu ena tauwaikaiwatana 12 a miyamiyana i waitalayedina gado, “Temi kota ko ḡoyeḡoyena ko gosegu, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bi Saimon Pita Yesu i giuwena gado, “Bada, aiyai lisinemo ka nawa? Tam lisimmo yawasana giudi yawasana ilailalala sa vitevitemai. ");
INSERT INTO kqf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tama kei sumaḡem bi ke sibe te tam taunana Waiwaiyawim Maimaituwa lisinaḡa kuna yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ḡome te Yesu edi giu i waimunena gado, “Tagu ba 12 e vinemi bi geḡa te, modomimo ḡemota ba aluwa gebogebona i suneḡi.” ");
INSERT INTO kqf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu ba Saimon Iskaliyot natuna Diudas i giugiuwe. Tana 12 modomimo bi geḡa te, Yesu ya sakoyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Niga wailovelovena mulinemo, Yesu Galili plovins noponaḡa i nawa. Tana mote i ḡoye te Diudiya plovinsnaḡa ya nawa, banina Diu waibabadidi eta a tavutavuḡe te sai peki. ");
INSERT INTO kqf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bi laḡannemo Diu lavedi edi kape soina laḡanna i tutuḡeleḡele ba, ");
INSERT INTO kqf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu tasitasina a giuwena gado, “Tam niga dobuna kwa gose bi kwa nawa Diudiya plovinsnemo bi mataila kwa voiyedi te taukaiwatam sa kita. ");
INSERT INTO kqf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lava aiyai bi kauwa kandavonemo ya voivoiyedina ba lava mote sima sibe. Tam kuna ḡoye te lava sa sibena ba mataila kwa voiye te dobumo lava sa kita.” ");
INSERT INTO kqf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tana tasitasina niga mainana a giuna, banina ba tana mote ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kamaina bi Yesu i giuwedina gado, “Tagu egu sauga kauwa mote i tava, bi sauga matabuna ba temi emi sauga bi nawa ko ḡoyena te ko nawa. ");
INSERT INTO kqf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lava dobumo mote temi sima dabokemi, bi tagu sa dabokegu banina, tagu lava edi gebogebo yà giugiuwaimaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Temi soinemo ko nawa. Tagu mote yàma nawa, banina tagu egu sauga kauwa mote i tava.” ");
INSERT INTO kqf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu niga mainana i giuwedi bi tana Galilimo i miyagwasa. ");
INSERT INTO kqf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bi ḡome te tasitasina a nawanawa soimo ba tana muliḡa kandavonaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bi mba Soinemo ba Diu babadidi Yesu a tavutavuḡe bi a waitalana gado, “Niga lavana bamo?” ");
INSERT INTO kqf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bi ḡome lava kumdi ba a waikasakasavena. Ḡesaudi a giuna gado, “Tana lava visuvisuna.” Bi ḡesaudi a giuna gado, “Geḡa, tana lava ya aiaiwainawenawedi.” ");
INSERT INTO kqf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bi geḡa te, aiyai lavana mote Yesu i giugiuwaimaḡati banina, Diu babadidi a nailedi. ");
INSERT INTO kqf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Laḡannemo soi nuwana kovi ba, Yesu i saḡa pali vanuwina ganakukuna noponemo bi wailovelove i waitubu. ");
INSERT INTO kqf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ḡome Diu babadidi a sove bi a giuna gado, “Niga lavana bainewa bi ena sibe i tausaḡa? Tana mote i giluma bi sibe bamo i vai?” ");
INSERT INTO kqf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu edi giu i waimunena gado, “Niga wailovelovena mote tagu egu wailovelove, bi taugiukamaḡegu lisinaḡa ya yovoyovo. ");
INSERT INTO kqf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tana aiyai Maimaituwa ena ḡowana ya voivoiyena, kaka ya sibe te wailovelove yà voivoiyena ba Maimaituwa lisinaḡa ya yovoyovo, ee tauguḡa yà waitubudi. ");
INSERT INTO kqf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tana aiyai bi ena waibada ya giugiuwata, ba tana taunaḡa isana kasaḡesaḡena aubaina. Bi tana aiyai taugiukamaḡena isana kasaḡesaḡena aubaina ya noyanoyana ba mote ima kaikaiyovu bi giukauwa ya giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mousis ba waiḡake i vitemi. Bi geḡa te, mote aiyai waiḡake kuma kaikaiwata. Bi bai aubaina ko ḡoyeḡoye te koi pekigu?” ");
INSERT INTO kqf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ḡome lava kumdi ena giu ai munena gado, “Tam ba aluwa gebogebona i suneḡim! Aiyai waipekim ya ḡoyeḡoye?” ");
INSERT INTO kqf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu i giuwedina gado, “Tagu mataila ḡemota e voiye bi temi matabumi kona tatava. ");
INSERT INTO kqf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mousis i giuwemi te natunatumi oloolotodi ba kwapibwali ko vitedi, bi mba waiḡakena mote Mousis i waitubu, bi nove emi magumagulaḡa i saḡa. Bi avena te Diu lavedi edi Waiyawasi Laḡanna bi temi natunatumi oloolotodi lisidimo kwapibwali ko voivoiye. ");
INSERT INTO kqf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bamoda Diu lavedi edi Waiyawasi Laḡannemo, gomana olotona lisinemo kwapibwali sa voiyena, ba Mousis ena waiḡake mote sima wai doukoto. Bai aubaina Diu lavedi edi Waiyawasi Laḡannemo oloto e waiyawasanina dabanemo lisigumo kona medi. ");
INSERT INTO kqf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Em tau ena kauwa kwa kita kauwe kaka muliḡa bi kwa giu waiipoipo.” ");
INSERT INTO kqf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mba giudi dabedimo te Yelusalem lavedi ḡesaudi ai talana gado, “Niga olotona taunana sa ḡoyeḡoyena sai peki, ee? ");
INSERT INTO kqf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tana debamo ya giugiuna bi mote bai lisinemo sima voivoiye. Bi waibabada sa giugiu te tana taunana augunai Buyobuyona? ");
INSERT INTO kqf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bi geḡa te, tada ba te sibe te tana bamo maiḡa i tava, bi laḡannemo Buyobuyona ya natona, ba mote aiyai kaka ima sibe te tana bamo maiḡa i nato.” ");
INSERT INTO kqf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bi Yesu yaḡolo Pali vanuwina ganakukunemo i waiwailovelove, bi kalinana dididiginemo i giuna gado, “Emaso, bena kona sibegu. Bi kona sibe te bamo maiḡa e tava, tagu mote egu waibadamo e yovo. Bi taugiukamaḡegu ba giugiukauwina, tana taunana i giukamaḡegu bi temi mote tana ko sibe, ");
INSERT INTO kqf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","bi geḡa te, tagu e sibe, banina tagu tana lisinaḡa te e yovo. ");
INSERT INTO kqf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","“Mba giudi dabedimo tedi a ḡoyeḡoyena maso a pani, bi geḡa te, tana ena sauga yaḡolo mote i tava. ");
INSERT INTO kqf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bi lava kumdi nopodimo lava ḡesaudi ai sumaḡa bi a giuna gado, ‘Temi mba Kelisona ko giugiuwena ya natona male mataila nananakidi ya voiyedina mai niga lavana, ee?’ Geḡa, Kelisona niga taunana i tava.” ");
INSERT INTO kqf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","“Ḡome palisi a vaiye te lava kumna tana ena kauwa a waikasakasavenae ba Palisi bi pilipilisi edi babada Pali vanuwina tauyavena a giukamaḡedi te Yesu sa pani.” ");
INSERT INTO kqf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu i giuna gado, “Tagu ba laḡani watiḡena vaitemi ta miya munaḡa kaka taugiukamaḡegu lisinemo yà munaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Temi kaka ko tavuḡegu bi mote koma banavigu, bi bamo ḡome yà nawana ba temi mote ḡemoḡemotimi te ḡome koma tava.” ");
INSERT INTO kqf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bi Diu babadidi taudiḡa a waigiugiuna gado, “Niga olotona bamo ya nawa te tada mote tama kita? Male ya nawa Guliki dobudiḡa eda lava sa miyamiyanemo te Guliki lavedi yai lovelovedi. ");
INSERT INTO kqf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Niga giuna i vatovatona gado, ‘Temi kaka ko tavuḡegu bi mote koma banavigu, bi kota tagu bamo ḡome ba temi mote ḡemoḡemotimi te koma nato.’ Mba giuna banina ba bai?” ");
INSERT INTO kqf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Soi dididiga damonemo, Yesu i moito bi kalinana dididiginemo i giuna gado, “Aiyai bi gadona i maguna ba ya nato lisigumo bi yawasana gaubina ya tego. ");
INSERT INTO kqf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bi aiyai ya waisumaḡeguna ba ya tego, banina gilugilumina i giuna gado, ‘Gauba yawayawasanina kaka tedi lisidiḡa ya nuwaḡini yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu niga mainana i giuna ba, tedi mabai tana sa waisumaḡena ba sauga muliḡa Aluwa Waiyawa sa vai. Mba sauginemo ba Aluwa mote i yovo, banina Maimaituwa yaḡolo mote Yesu i lageti nawe malamo. ");
INSERT INTO kqf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Laḡannemo tana ena giu a vaivaiyedi ba lava ḡesaudi a giuna gado, “Giukauwa te niga olotona ba Taugiuwatana. Tana taunana te labelabe.” ");
INSERT INTO kqf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ḡesaudi a giuna gado, “Tana taunana Keliso.” Bi geḡa te, ḡesaudi ai talana gado, “Bainewa te maso Keliso Galiliḡa ya nato? ");
INSERT INTO kqf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gilugilumina ya giugiu te Keliso ba Deivida ena tubulelesaḡa ya nato, Betliḡem tauninemo Deivida ena animiyamo.” ");
INSERT INTO kqf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kamaina bi Yesu dabanemo lava a dailidi. ");
INSERT INTO kqf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ḡesaudi a ḡoye te maso a kaididi bi geḡa te aiyai mote lisinemo bai i voiye. ");
INSERT INTO kqf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Laḡannemo Pali vanuwina tauyavena a munaḡa nawa pilisi edi babada bi palisi lisidimo ba waibabada ai talayedina gado, “Bai aubaina mote ko pani natome?” ");
INSERT INTO kqf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tauyava a giuna gado, “Mote bamo mainana lava ke vaiye i giugiuna mai niga lavana.” ");
INSERT INTO kqf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ḡome palisi ai talana gado, “Temi kota i aiwainawenawemi, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bamo kona kita te palisi ee waibabada mba lavana ai sumaḡe? ");
INSERT INTO kqf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Geḡa, niga lavedi kumdi Mousis ena waiḡake mote a sibe, taunana aubaina Maimaituwa ena medi kaka lisidimo ya yovo. ");
INSERT INTO kqf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ḡome palisi ḡemota isana Nikodimas tana dolinemo i nawa Yesu lisinemo, tana ena lava i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Eda waiḡake ya giugiu te lava mote tamai wavu yababe bi ta gei etale te kauwa banina ta gei sibe te tana bai i voiyewapa.” ");
INSERT INTO kqf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bi tedi ena giu ai munena gado, “Bi tam kota Galili lavam, ee? Gilugilumina kwa iyevina ba taugiuwatana mote Galiliḡa ima nato.” ");
INSERT INTO kqf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ḡome te lava matabudi a dabalala bi ai nawa ḡemoḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kamaina bi lava matabudi a nawa, bi Yesu i nawa Oliv oyanemo. ");
INSERT INTO kqf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Laḡan i sako olaolalemo Yesu i tava munaḡa Pali Vanuwina ganakukunemo i miyatulu, bi lava matabudi a tava a miya kwaivivili bi wailovelovedi i waitubu. ");
INSERT INTO kqf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bi i waiwailovelove ba waiḡake tauwailovelovedi bi palisi, waivini waimatawapana ai doli tavaite te lava kumna matedimo ai moito. ");
INSERT INTO kqf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bi Yesu a giuwena gado, “Tauwailovelove, niga waivinina ba i waimatawapa te ke pani tavaite. ");
INSERT INTO kqf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mousis ena waiḡake ya giugiu te mba mai waivinina ba ḡakimemo ka laipeki. Bi tam bainewa kwa noḡonoḡoti?” ");
INSERT INTO kqf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tedi a ḡoyeḡoyena maso bai giuna i vatowapa bi ai wavu. Bi geḡa te, Yesu i laudulu doḡamo bi nimanemo i waigilugiluma. ");
INSERT INTO kqf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bi tedi yaḡolo te a waitala vitavitale, kamaina bi i miyamoito te i giuwedina gado, “Tam aiyai mote gebogebo ku voiye ba ḡakima kwa gei pwalaḡe noi waivinina lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bi kota i laudulu munaḡa bi doḡamo i waigilugiluma. ");
INSERT INTO kqf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mba giuna a vaivaiye ba lava matabudi ai nawa ḡemoḡemota, magumagulidi a gei nawa. Yesu bi mba waivinina yaḡolo ḡome i moimoito a gose kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu i taulageti bi waivini i waitalayena gado, “Waivini, tauwaiwavum baiḡa a nawa? Aiyai bamo ya miyamiya te yai wavum bi sai pekim ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Bi waivini giu i waimunena gado, “Bada, geḡa, mote bamo aiyai.” Kamaina bi Yesu i giuna gado, “Waivini, tagu kota mote yàmai wavum te simai pekim. Kwa nawa bi gebona mote kuma voiye munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu palisi i giu munaḡedina gado, “Tagu ba dobu lavedi edi yanayana. Aiyai ya kaikaiwataguna ba yawasana yananemo ya miya bi mote kaka waidudubalaḡa ima nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bi palisi tana a giuwena gado, “Kuna kita, tam taumḡa gode kwa giugiu munaḡem, bi bai kwa giugiuwena ba mote giukauwa.” ");
INSERT INTO kqf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu giu i waimunena gado, “Geḡa, avena te tagu tauguḡa yà giugiu munaḡegu bi bai yà giugiuwedina ba giukauwa, banina tagu e sibe te bamo maiḡa e tava bi bamo maiḡa yà nawanawa bi temi mote ko sibe te bamo maiḡa e tava bi bamo maiḡa yà nawanawa. ");
INSERT INTO kqf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Temi lavaota edi waikitamo lava ko kitakita waiipoipodi bi tagu mote aiyai lavana yàma kitakitawaiipoipo. ");
INSERT INTO kqf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bi tagu lava yà kitakitawaiipoipona ba giukauwemo, banina tagu mote tauguḡa, bi Tamagu taugiukamaḡegu vaitena. ");
INSERT INTO kqf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Emi waiḡake gilugiluminemo ya giugiu te tauwaimatamata labu bi bai giuna sa waianinena ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tagu tauguḡa aubaigu yà giugiu. Bi tauwaimatamata ḡesauna ba Tamagu taugiukamaḡegu.” ");
INSERT INTO kqf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tedi ai talayena gado, “Te Tamamna bamo?” Bi Yesu edi giu i waimunena gado, “Temi mote tagu ee Tamagu ko sibe, bamoda tagu ko sibegu maso Tamagu vaitena kona sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu niga giudi i wailoveloveyedina ba Pali vanuwina ganakukunemo, sewasewa anisivudi diyanemo. Bi geḡa te, mote aiyai i pani, banina ena laḡan kauwa mote i tava. ");
INSERT INTO kqf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu i giu munaḡedina gado, “Tagu yà nawa bi temi kaka tagu ko tavuḡegu bi emi gebogebomo kaka ko peki. Bi bamomaiḡa yà nawanawana ba temi mote kaka ḡome koma tava.” ");
INSERT INTO kqf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te Diu lavedi edi waibabada ai talana gado, “Te tana taunaḡa yai peki munaḡe, ee?” Taunana aubaina, ya giugiu te tada mote tana ena aninawaḡa tama nawa. ");
INSERT INTO kqf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu edi giu i waimunena gado, “Temi ba niga dobuna lavemi bi tagu ba malaḡa e yovo. Bi temi ba niga dobuna lavemi bi tagu mote niga dobuna lavagu. ");
INSERT INTO kqf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bi yà giugiuwemi te emi gebogebomo kaka ko peki, bamoda mote koi sumaḡa te tagu ba Tana Taunana, temi kaka emi gebogebomo ko peki.” ");
INSERT INTO kqf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bi tedi tana ai talayena gado, “Bi tam aiyai?” Bi Yesu edi giu i waimunena gado, “Maibena wala pakanemo e giugiuwemina. ");
INSERT INTO kqf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Bi emi kauwa dabedimo maso e etaetalemi. Bi mba mainana ba yà kagebogeboḡemi bi geḡa te, taugiukamaḡegu ba giukauwa bi bai i giugiuweguna, taunana dobumo lava yà giugiuwemi.” ");
INSERT INTO kqf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tedi mote a sibe te Yesu ba Tamana i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Taunana aubaina, Yesu i giuwedina gado, “Laḡannemo, Tana Taunana Natuna ko kailagetina, kaka ko sibe te tagu aiyai. Tagu tauguḡa egu ḡailisimo mote kaka bai yàma voiye bi bai Tamagu i wailoveguna taunana yà giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bi taugiukamaḡegu ba mote i gose kamaḡegu, banina tagu laḡan matabuna ena ḡowana yà voivoiyedi.” ");
INSERT INTO kqf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu niga giudi i giuwedi bi mabai a vaivaiyena ba tana ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kamaina bi Diu lavedi mabai Yesu a waisumaḡena, i giuwedina gado, “Bamoda temi bi tagu bai yà wailovelovemina ko kaiwata kauwedina, ba giukauwa te temi ba tagu egu tauwaikaiwatana. ");
INSERT INTO kqf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Temi kaka giukauwa giudi ko sibedi bi giukauwina kaka gebogebomo ya kuvesimi.” ");
INSERT INTO kqf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tedi ena giu ai munena gado, “Tama Eiblaḡam ena tubulelesa bi mote aiyai ena taupaula yababa, bi bainewa te tam kwa giugiu te tama waitaupaula yababemo ka potiyovo?” ");
INSERT INTO kqf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu giu i waimunena gado, “Tagu yà giugiu kauwemi, tana aiyai bi gebogebo ya voivoiyena ba gebo tana ya waibadabadaye. ");
INSERT INTO kqf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Taupaula yababa mote vanuwa lavedi vaitedi sima miya gulata, bi vanuwa lavedi natuotidi kaka vaitena sa miya nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Taunana aubaina, Maimaituwa Natuna ya kuvesimina ba kamaina i kuvesi kauwemi. ");
INSERT INTO kqf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tagu e sibemi te temi Eiblaḡam ena tubulelesa bi geḡa te, eta ko tavutavu te tagu koi pekigu, banina giugu mote nopomimo ima kenakena. ");
INSERT INTO kqf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tagu Tamagu bai i wailoveguna yà giugiuwemi bi kota temi mainana tamemi bai i wailovemina mainana ko voivoiye.” ");
INSERT INTO kqf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tedi ena giu ai munena gado, “Eiblaḡam ba tama ema magula.” Kamaina bi Yesu i giuwedina gado, “Bamoda temi Eiblaḡam natunatuna, maso ba emi kauwa kona voivoiyedina mai tana ena kauwa. ");
INSERT INTO kqf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tagu yà giugiukauwemi te Maimaituwa bai i giuwegu bi e vaivaiyena yà giugiuwemi, bi bainewa te temi eta ko tavutavu te koi pekigu. Eiblaḡam mote mai kauwidi i voiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Temi ba tamemi ena kauwa ko voivoiyedi.” Tedi ena giu ai munena gado, “Tama mote keda, tama Tamamai ḡemota. Tana taunana Maimaituwa.” ");
INSERT INTO kqf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu i giuwedina gado, “Bamoda Maimaituwa bi Tamemi maso ba tagu kona ḡoyegu, banina tagu Maimaituwa lisinemo te e yovo. Tagu mote nuwagumo e yovo, bi Maimaituwa i giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bai aubaina giu yà giugiuwemina banidi mote koma sibesibedi? Banina ba temi bai yà giugiuwemina mote koma vaivaiye kauwedi. ");
INSERT INTO kqf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Temi ba tamemi taumudulele, taunana aubaina kona ḡoye te tana ena ḡowana ko voiyedi. Pakanemo ba tana tauwaipeki bi giukauwa mote i kaiwata, banina tana lisinemo mote giukauwa. Laḡannemo ya kaiyovuna mba tana kalina otina, banina tana tauwaikaikaiyovu bi kaiyovu tamedi. ");
INSERT INTO kqf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tagu giukauwa yà giugiuwemi, bi geḡa te, temi mote koma waisumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bai gebona e voiye bi temi ko waiwavugu? Bi bamoda giukauwa yà giugiuwe, ba kamaina te koi sumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maimaituwa natunatuna ba kalinana sa vaivaiye. Temi Maimaituwa kalinana vaiyena kona daboke, banina temi mote Maimaituwa natunatuna.” ");
INSERT INTO kqf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bi Diu lavedi Yesu ena giu ai munena gado, “Tama ke giukauwa te tam Sameliya lavam bi aluwa gebogebona i suneḡim.” ");
INSERT INTO kqf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Bi Yesu i giuna gado, “Tagu mote aluwa gebogebona i suneḡigu bi tagu Tamagu yà vivivile bi temi mote tagu koma vivivilegu. ");
INSERT INTO kqf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tagu mote isagu kasaḡesaḡena aubaina yàma noyanoya bi Tamagu ena ḡowana ba lava tana isana sa kasaḡesaḡe, banina tana taunana taulauetala. ");
INSERT INTO kqf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Giukauwemo yà giugiuwemi, te tana aiyai giugu ya vovoteyateyaena ba mote kaka ima peki.” ");
INSERT INTO kqf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ḡome Diu babadidi a giuwena gado, “Niganana kaka ke sibem te tam ba aluwa gebogebona i suneḡim. Eiblaḡam i peki bi kota taugiuwatana a peki bi tam kuna giu te aiyai bi em wailovelove ya kaikaiwatedina ba mote kaka ima peki. ");
INSERT INTO kqf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Te tam bena kuna saḡa gulatana kaka tamamai Eiblaḡam, ee? Tana i peki bi kota taugiuwatana a peki. Bi tam bena kwa saḡa kamaḡedi, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu giu i waimunena gado, “Bamoda tagu tauguḡa yà kasaḡe munaḡeguna ba banina geḡa. Bi temi ko giugiu te Tamagu ba emi Maimaituwa, tana taunana tagu ya kasaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Avena te temi mote ko sibe bi tagu ba e sibe. Bi bamoda tagu e giu te mote yà sibe ba yà waikaikaiyovuna mai temi. Bi tagu e sibe aubaina kalinana yà vovoteyeteye. ");
INSERT INTO kqf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamemi Eiblaḡam i yasisi gulata te egu nato saugina ya kita, tana i kita bi i wainuwavisu.” ");
INSERT INTO kqf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bi tedi a giuwena gado, “Tam mote yaḡolo kwalabu 50 ku vai bi kwa giugiu te Eiblaḡam kuna kita.” ");
INSERT INTO kqf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu edi giu i waimunena gado, “Tagu giukauwemo yà giugiuwemi te muliḡa kaka Eiblaḡam i tubuḡana ba Tagu e miyamiya.” ");
INSERT INTO kqf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ḡome lava ḡakima a legaudi te maso a lauḡakimina ba Yesu kandavonemo i vasoyavai bi Pali vanuwina i gose. ");
INSERT INTO kqf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu i bababala ba oloto matapotapotana mai i tubutubuḡayena i kita. ");
INSERT INTO kqf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ena tauwaikaiwatana ai talayena gado, “Labai, aiyai ena gebo i voiye te niga olotona mamatapotapotana i tubuḡa? Tana ena gebo ee tamana bi tinana edi gebo?” ");
INSERT INTO kqf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu i giuwedina gado, “Geḡa, mote tana e tamana bi tinana edi gebo. Tana matana potapotana i tubuḡana ba Maimaituwa ena ḡailisi lisinemo ya kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tada ba suwalemo taugiukamaḡegu ena noya ta voiye, dudubala ya natonatona ba mote aiyai kaka ima noya. ");
INSERT INTO kqf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tagu dobumo yaḡolo yà miyamiya ba tagu taunana dobu lavedi edi yanayana.” ");
INSERT INTO kqf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Niga giuna mulinemo ba Yesu doḡamo i gelolo, i viliwainiginigi bi i vai te oloto matanemo i musu ");
INSERT INTO kqf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","bi i giuwena gado, “Kwa nawa bi matam Silowam Topanemo kwa koḡa. Giu Silowam banina ba ‘giukamaḡe.” Kamaina bi oloto i nawa, matana i koḡakoḡa ba matana i yana, i waikita bi i nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Diyanemo taumiya bi lava mabai wala a kita i waiwaigigimanana a giuna gado, “Niga olotona taunana wala i miya bi i waiwaigigimana, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lava ḡesaudi a giuna gado, “Tana taunana.” Bi kota ḡesaudi a giuna gado, “Geḡa, niga olotona kitana mai mba olotona matapotapotana.” Kamaina bi olotona taunaḡa i giu bagibagina gado, “Tagu taunana.” ");
INSERT INTO kqf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tedi ai talayena gado, “Bainewa bi matam i yana?” ");
INSERT INTO kqf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bi tana i giuwedina gado, “Oloto isana Yesu, doḡa i gelolo, matagumo i musu bi i giuweguna gado, ‘Kwa nawa te Silowam topanemo matam kwa koḡa.’ Ḡome e nawa matagu e koḡekoḡedi ba matagu a yana.” ");
INSERT INTO kqf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bi tedi ai talayena gado, “Bi olotona bamo?” Bi Oloto i giuna gado, “Mote e sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Olotona matapotapotana a natome Palisi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu doḡa i gelolo wainiginigi bi oloto matapotapotana i waiyawasanina ba Diu lavedi edi Waiyawasi Laḡannemo. ");
INSERT INTO kqf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Taunana aubaina, Palisi oloto ai talaye te bainewa matana i yana. Bi tana i giuwedina gado, “Tana matagumo doḡa viliviliwainiginigina i musu bi topamo e koḡa te niganana yà waikita.” ");
INSERT INTO kqf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Palisi ḡesaudi a giuna gado, “Niga olotona kauwina i voiyena ba mote Maimaituwa lisinaḡa i yovo, banina tana eda Waiyawasi Laḡanna ena waiḡake i waidoukoto.” Bi kota lava ḡesaudi a giuna gado, “Gebogebo lavana mote luvana niga mai matailina ima voiye?” Ḡome te waimiyatauli i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Palisi oloto ai tala munaḡena gado, “Te ku giuwemai, niga olotona matam i kakayanana ba kuna sibe te tana aiyai?” Bi oloto edi giu i waimunena gado, “Tana ba taugiuwatana.” ");
INSERT INTO kqf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Diu babadidi yaḡolo mote ai sumaḡa te oloto matapotapotana mai i tubuḡaye bi niganana ya waikita, taunana aubaina tamana bi tinana a giuwedi te a tava. ");
INSERT INTO kqf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bi ai talayedina gado, “Niga ba temi natumi, ee? Kona giu te matapotapotana i tubuḡa, bi bainewa te niganana ya waikita?” ");
INSERT INTO kqf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tinana bi tamana giu ai munena gado, “Tama natumai te ke sibe, tana matapotapotana i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tana bainewa bi i waikita e aiyai matana i kayanana, tama mote ke sibe. Tana kaikana i didiga, koi talaye te taunaḡa aubaina ya giu.” ");
INSERT INTO kqf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana bi tinana Diu babadidi a nailedi taunana aubaina, niga giuna mainana a vato. Diu edi babada kaikana ai anina te lava aiyai Yesu ya kamaḡati te tana Buyobuyona ba bolu vanuwinemo sa kapotiyovo. ");
INSERT INTO kqf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tamana bi tinana a naila, taunana aubaina a giuna gado, “Tana kaikana i didiga, koi talaye.” ");
INSERT INTO kqf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kamaina bi oloto matapotapotana i yawayawasanana a giuwe i te tava munaḡa bi a giuwena gado, “Maimaituwa matanemo kwa giukauwa, tama ke sibe te niga olotona i waiwaiyawasanimna ba gebogebo lavana.” ");
INSERT INTO kqf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bi edi giu i waimunena gado, “Tagu mote e sibe, bamoda tana gebogebo lavana ee geḡa, bi bai e sibena ba tagu matagu potapotana bi niganana yà waikita.” ");
INSERT INTO kqf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bi tedi ai talayena gado, “Bai kauwina lisimmo i voiye? Bi bainewa matam i kayanedi?” ");
INSERT INTO kqf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bi edi giu i waimunena gado, “Tagu kaikana e giuwemi bi mote ko vaiye. Bai aubaina ko ḡoyeḡoye te ko vaiye munaḡe? Temi kota ko ḡoyeḡoyena ena tauwakaiwatana, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ḡome tana a giuvitavitalena gado, “Tam mba lavana taukaiwatana bi tama ba Mousis taukaiwatana. ");
INSERT INTO kqf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tama ke sibena ba Maimaituwa Mousis lisinemo i giugiu, bi niga lavana ba mote tama ka sibe te bamo maiḡa i tava.” ");
INSERT INTO kqf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Oloto i giuwedina gado, “Konai sovegu te mba lavana mote ko sibe te bamomaiḡa i tava bi tana matagu i kayana! ");
INSERT INTO kqf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te sibe te Maimaituwa mote gebogebo lavedi ima vaivaiyedi. Tana ba tauvivilena bi ena ḡowana tauvoiyena lavedi kalinedi ya vaivaiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wala nove pakanemo te niganana, bamo mote aiyai i vaiye te lava matapotapotana mai i tubutubuḡayena ai yawasani. ");
INSERT INTO kqf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bamoda niga lavana mote maso Maimaituwa lisinaḡa i yovo, ba maso mote bai i voiye.” ");
INSERT INTO kqf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oloto ena giu dabanemo ba tedi a giuwena gado, “Tam gebomo kuna tubuḡa bi kwai lovelovemai, ee?” Bi a kwavivai te i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu i vaiye te olotona bolumo a kwavivai bi laḡannemo i banabanavi ba i waitalayena gado, “Tana Taunana Natuna kwa waisumaḡe ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bi oloto giu i waimunena gado, “Bada, ku giuwegu te mba aiyai lavana bi yài sumaḡe?” ");
INSERT INTO kqf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu i giuwena gado, “Kaikana kuna kita, tana taunana niganana vaitena ko waigiugiu.” ");
INSERT INTO kqf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Oloto i giuna gado, “Bada, yà waisumaḡem!” Bi Yesu matanemo tuwapekana i waitupagwaliḡedi bi i lauduneye. ");
INSERT INTO kqf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu i giuna gado, “Tagu niga dobunemo ba etala aubaina e yovo. Te tedi mabai sa noḡonoḡoti te mote a sibe kauwe ba matedi kaka sa yana bi mabai sa noḡonoḡoti munaḡedi te bena a sibe kauwa ba yaḡolo matedi potepotedi.” ");
INSERT INTO kqf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ḡome Palisi a vaiye te Yesu mainana i giugiu, ba ai talana gado, “Gode tama matamai potepotedi, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu edi giu i waimunena gado, “Bamoda matemi a pota maso ba waigebo geḡemi, bi geḡa te ko waikita, mba ko kakamaḡatimi te temi ba gebogebo lavemi.” ");
INSERT INTO kqf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu i giuna gado, “Palisi, yà giugiu kauwemi te lava aiyai sipu edi ganakuku mataetinaḡa mote ima valageta bi gavogavo ḡesaunaḡa ya solasaḡana ba tana taudanedanene bi taukoinene. ");
INSERT INTO kqf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lava aiyai bi mataetaḡa ya valavalagetana ba tana taunana sipu taulabedi. ");
INSERT INTO kqf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mataeta taulabena mataeta ya kaikamaḡe te sipu taulabena ya valageta. Bi sipu taulabena ena sipu ḡemoḡemotaḡa isedi ya lauiyava bi kalinana vaiyeḡonena a sibe kauwe taunana aubaina, yai dolidi te sa potiyovo. ");
INSERT INTO kqf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tana ya doli bi ena sipusipu sa kaiwata, banina tana kalinana vaiyeḡonena a sibe kauwe. ");
INSERT INTO kqf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tedi lava ḡesauna mote kaka sima kaiwata, mba lavana kaka sa velau sa gose kamaḡe banina, kalinana mote a vaiyeḡone.” ");
INSERT INTO kqf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu niga lautaulalana palisi i giuwedi bi geḡa te, tedi giuna banina mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Taunana aubaina, Yesu giu i laumunaḡena gado, “Giukauwemo yà giugiuwemi te tagu taunana sipusipu edi mataeta. ");
INSERT INTO kqf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Temi mabai kona gei tava bi Maimaituwa ena dam lavedi kona labelabedina, ba temi taudanedanene bi taukoinene, taunana aubaina sipusipu mote emi giu a vaivaiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Tagu taunana mataeta, tedi mabai lisiguḡa sa solasaḡana ba sa yawasana. Tedi sa solasaḡa bi sa potiyovo te kani sa banavi bi ḡoyogumo sa miya. ");
INSERT INTO kqf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bi taudanene ya solasaḡana ba ya danene, yai peki bi ya laukivigebogebo. Bi tagu e yovona ba yawasana ko vai bi yawasanina ba yawasana tupana. ");
INSERT INTO kqf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Tagu taunana sipu taulabedi visuvisugu. Sipu taulabedi visuvisuna ena yawasana ya nuwakamaḡe te ena sipusipu aubaidi ya peki. ");
INSERT INTO kqf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bi mane taubagibagiyena ba tana mote sipu taulabedi taunana aubaina, laḡannemo tabei ya kita ya natonato ba ya velau sipusipu ya gosedi. Te tabei sipusipu ya suluvaidi bi yai dabalalidi. ");
INSERT INTO kqf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","“Taubagibagi ba maiia aubaina ya noyanoya, tana mote sipusipu taulabedi te yai sasalanedi. ");
INSERT INTO kqf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Tagu taunana tauwailaba visuvisugu, egu sipu e sibedi bi sipu tagu a sibegu. ");
INSERT INTO kqf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mainana kota Tamagu i sibegu bi tagu Tamagu e sibe. Bi tagu luvana egu sipusipu aubaidi yà peki. ");
INSERT INTO kqf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Egu sipu ḡesaudi mote niga ganakukunemo, tedi vaitedi yà natomedi te kalinagu sa vaiye, te dam ḡemota ya tubuḡa, bi edi tauwailaba ḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tamagu ya ḡoyeḡoyeguna banina, tagu kaka egu yawasana yà vitekamaḡe bi kota yà vaimunaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mote aiyai kaka egu yawasana ima vaikamaḡe. Tagu egu ḡowana te egu yawasana yà vitekamaḡe. Bi egu ḡailisi ya kenakena te egu yawasana yà vitekamaḡe bi kota egu ḡailisi ya kenakena te yà vaimunaḡe. Niga taunana tamagu ena giuvavasaḡa i vitegu te yà voiye.” ");
INSERT INTO kqf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Laḡannemo Diu lavedi niga giudi a vaivaiyedi ba a daili munaḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lava wapewapedi a giuna gado, “Tana aluwa gebogebona i suneḡi bi ya giugiu yabayababa. Bai aubaina kalinana ko vaivaiye?” ");
INSERT INTO kqf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bi geḡa te, ḡesaudi a giuna gado, “Niga mote mainana lava aluwa gebogebodi a sunesuneḡina kalinana. Aluwa gebogebona maso ḡemoḡemotina lava matana potapotana i kayana, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kamaina bi Pali Vanuwina Soina Yelusalemmo laḡanna i tava. Bi mba ba sinou bi taumata sauginemo, ");
INSERT INTO kqf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","bi Yesu ba pali vanuwina didiyaunaḡa bi Solomon ena Yoveyove noponaḡa i nawanawa. ");
INSERT INTO kqf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Diu lavedi a tava te Yesu a dubutawi bi a giuna gado, “Kwa alamiya moimoisili, bamoda tam Buyobuyona te kwa giu otiḡemai?” ");
INSERT INTO kqf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu edi giu i waimunena gado, “Bena kaikaina e giuwemi bi temi mote koi sumaḡegu. Tagu anisove matailidi e voivoiyedina Tamagu ena ḡailisimo, taudidi sa kakamaḡatigu. ");
INSERT INTO kqf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bi geḡa te, temi mote koma waisumaḡegu banina, temi mote tagu egu sipusipu. ");
INSERT INTO kqf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bi tagu egu sipusipu ba kalinagu sa vaivaiye, bi tagu e sibedi bi tedi tagu sa kaikaiwatagu. ");
INSERT INTO kqf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tagu yawasana ilailala yà vitedi te mote sima peki, bi mote aiyai kaka ima kwayagu. ");
INSERT INTO kqf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamagu wailewapanina, tana ḡailisi i vitegu te bai matabuna yà waibadaye. Bi mote aiyai kaka Tamagu nimanemo ima kwayavai. ");
INSERT INTO kqf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tagu bi Tamagu ba tama lava ḡemota.” ");
INSERT INTO kqf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kamaina bi Diu lavedi kota ḡakima a laitupa munaḡa te maso a ḡakimemo a laipeki ");
INSERT INTO kqf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","bi geḡa te, Yesu i giuwedina gado, “Tagu Tamagu i wailovegu te mataila wapewapedi visuvisudi e voiyedi. Bi temi bamo kauwidi dabedimo ko ḡoyeḡoyena ko laipekigu?” ");
INSERT INTO kqf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tedi ena giu ai munena gado, “Tama mote kauwa visuvisudi kuna voivoiyedina aubaidi kama lauḡakimim bi em waidiboḡa dabanemo. Tam ba lava ota bi kwa giugiu te tam bena Maimaituwa.” ");
INSERT INTO kqf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bi Yesu edi giu i waimunena gado, “Temi kona sibe ee geḡa te emi Waiḡake gilugilumina wadubonemo Maimaituwa i giuna gado, ‘Tagu e giu te temi ba dobu maimaituwidi.’ ");
INSERT INTO kqf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te sibe te Maimaituwa kalinana ba giukauwa te i yovo Islael lavedi lisidimo. Bi tedi mabai niga giuna sa kulakulavitalena ba Maimaituwa i giu te tedi taunana dobu maimaituwidi. ");
INSERT INTO kqf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tagu ba Tamagu i vinegu bi i giukamaḡegu te dobumo e yovo. Bi yà giugiu te tagu ba Maimaituwa Natuna. Bai aubaina ko giugiu te tagu yà waidiboḡa? Tagu mote yàma waidiboḡa. ");
INSERT INTO kqf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bamoda Tamagu ena ḡowana mote yàma voivoiye ba avena komai sumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bi bamoda temi mote tagu koi sumaḡegu ba anisove matailidi yà voivoiyedina taudidi koi sumaḡedi. Ḡome kaka ko sibe te Tamagu ba Tagu nopogumo bi Tagu ba Tamagu noponemo.” ");
INSERT INTO kqf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ḡome Yesu maso a kaididina ba tana i vasoyavai te i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kamaina bi Yesu i munaḡa nawa Diyoudan gaubina noi nevanemo, wala Diyon taukabulu i laulaukabuluna modomodonemo bi ḡome i miya. ");
INSERT INTO kqf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ḡome i miyamiya ba lava wapewapedi a tava lisinemo bi a giuna gado, “Diyon taukabulu mote mataila i voiyedi. Bi bai i giugiuwedina ba giukauwa te niga lavana i giugiuwata.” ");
INSERT INTO kqf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kamaina bi ḡome lava wapewapedi Yesu ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oloto isana Yasalesi i sida, tana ba Beteni lavana, Beteni ba Meli tinanatuna Mata vaitena edi malagai. ");
INSERT INTO kqf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Niga Melina taunana Yasalesi sidasidana nuvuna, tana muliḡa masi panepanena i ḡini, Bada kaḡenemo bi dabanemo i bakili. ");
INSERT INTO kqf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kamaina bi Yasalesi nuvunuvuna labu Yesu ena giu a giukamaḡena gado, “Bada, valeti kauwim ba i sida kauwa.” ");
INSERT INTO kqf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bi laḡannemo, Yesu mainana i vaivaiye ba i giuna gado, “Niga sidanemo ba mote ima peki. Bi Maimaituwa ena ḡailisi namalina ya kamaḡati. Te mba kauwinemo Maimaituwa Natuna kaka namala sa vite.” ");
INSERT INTO kqf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ena ḡoye ba Mata, Meli bi nuvudi Yasalesi. ");
INSERT INTO kqf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Taunana aubaina, laḡannemo i vaiye te Yasalesi i sida, ba tana mote i tava makai bi ḡome kota laḡan labu i miya. ");
INSERT INTO kqf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ḡome te ena tauwaikaiwatana i giuwedina gado, “Ta munaḡa Diudiya plovinsnemo.” ");
INSERT INTO kqf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bi ena tauwaikaiwatana ena giu ai munena gado, “Labai, maḡoota Diu lavedi a ḡoyeḡoyena maso ai pekim bi tam niganana munaḡa ḡome kwa ḡoyeḡoye, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu i giuwedina gado, “Tada suwalemo noya ta voiyedi. Lava mabai suwalaḡa sa nawanawana ba mote ḡemoḡemotina te kaḡedi simai tutudi, banina tedi dobu ena yanayana a kita. ");
INSERT INTO kqf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bi tedi mabai dudubalaḡa sa nawana ba kaḡedi sai tutudi, banina tedi lisidimo mote yanayana.” ");
INSERT INTO kqf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Niga giudi i tainuwataudi mulinemo bi i giuwedina gado, “Eda tau Yasalesi ba ya kenakena bi tagu yà nawa lisinemo bi yà lainuwesi.” ");
INSERT INTO kqf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bi ena tauwaikaiwatana a giuwena gado, “Bada, bamoda tana ya kenakena ota ba ya yawasana.” ");
INSERT INTO kqf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu ena giu banina ba Yasalesi i peki bi ena tauwaikaiwatana ai noḡota benakage tana i kenakena ota. ");
INSERT INTO kqf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Taunana aubaina, Yesu i giu otiḡedina gado, “Yasalesi ba i peki, ");
INSERT INTO kqf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","tagu ei nuwavisu te tagu mote ḡome, banina temi koi sumaḡeguna aubaina. Niganana kaka ta nawa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kamaina bi Tomas (a waiisana Didimas) falona tauwaikaiwatana i giuwedina gado, “Kamaina te matabuda ta nawa bi Yesu vaitena ta peki.” ");
INSERT INTO kqf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bi laḡannemo Yesu Betenimo i tavatava, ba i vaiye te Yasalesi tauyewamo i kenana ba laḡan 4 a kovi. ");
INSERT INTO kqf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beteni te Yelusalem ba manekina mote i lofa, maso ba 3 kilomita mainana. ");
INSERT INTO kqf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bi Diu lavedi wapewapedi a tava te Mata bi Meli ai nuwaubedi banina nuvudi i peki. ");
INSERT INTO kqf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Laḡannemo Mata i vaiye te Yesu i natonato, ba i potiyovo i nawa te i banavi, bi Meli ba vanuwemo i miya. ");
INSERT INTO kqf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bi Mata, Yesu i giuwena gado, “Bada, tam maso bi niga ḡome, tasigu mote maso i peki. ");
INSERT INTO kqf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bi tagu e sibe te bai niganana kwai baḡayena ba Maimaituwa kaka ya vitem.” ");
INSERT INTO kqf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu i giuwena gado, “Tasim kaka ya kenamoito munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Bi Mata giu i waimunena gado, “Tagu e sibe te kenamoito laḡannemo kaka tana ya kenamoito.” ");
INSERT INTO kqf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu giu i waimunena gado, “Tagu taunana kenamoito bi yawasana. Tedi mabai bi sa waisumaḡeguna ba avena te a pekina bi yaḡolo te sa yawasana, ");
INSERT INTO kqf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","bi lava miyemiyedi mabai sa waisumaḡeguna mote kaka bai laḡannemo sima peki. Niga giuna kwa waisumaḡe ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Bi Mata i giuna gado, “Bada, yà waisumaḡem te tam taunana Buyobuyona, Maimaituwa Natuna, dobumo kuna yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata giu i waikovi mulinemo ba i munaḡa vanuwemo, tasina Meli lisinemo bi nuwatauḡa i tainuwatauna gado, “Meli, Labai i tava bi ya ḡoyeḡoyena ya kitam.” ");
INSERT INTO kqf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bi sauginemo Meli giu i vaivaiye ba i miyamoito makai bi i nawa Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bi Yesu yaḡolo mote malagaimo i solasaḡa bi tana bamo Mata i banabanavinemo ḡome i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sauginemo Diu lavedi mabai Meli vaitena vanuwemo a wainuwaubana, a kita te maḡemota vanuwa i potiyovo kamaḡe, ba ai noḡota bena Meli i nawanawa tauyewamo ḡaba aubaina, kamaina bi a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Laḡannemo Meli i tava Yesu lisinemo bi i kitakita ba kaḡe pakanemo tuwapekana i waitupagwaliḡedi bi i giuna gado, “Bada, bamoda tam bi niga ḡome, mote maso nuvugu i peki.” ");
INSERT INTO kqf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ḡome Yesu i kita te Meli bi Diu lavedi a ḡabaḡaba ba tana nuwana i toitoi bi i wainuwaboya kauwa. ");
INSERT INTO kqf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kamaina bi i waitalayedina gado, “Tana bamo ḡome kona sako?” Tedi a giuna gado, “Bada, kwa nato bi kwa kita.” ");
INSERT INTO kqf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ḡome te Yesu i ḡaba. ");
INSERT INTO kqf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bi Diu lavedi diyanemo a moimoitona a giuna gado, “Kona kita, tana i ḡoye gulate!” ");
INSERT INTO kqf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bi lava ḡesaudi a giuna gado, “Niga olotona lava matapotapotana i waiyawasani. Tana bi niga ḡome maso ba Yasalesi i sagu te, mote maso i peki.” ");
INSERT INTO kqf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ḡome Yesu nuwana i toitoi munaḡa bi i nawa tauyewamo, bi tauyewina mataetina ba ḡakima dididiginemo ai dougudu. ");
INSERT INTO kqf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bi Yesu i giuna gado, “Ḡakima ko kaikamaḡe tabunemo!” Bi oloto pekipekina nuvuna tautuweḡina Mata i giuna gado, “Bada, niganana ba bovana i gebo kauwa, banina kaikana laḡan 4 a kovi.” ");
INSERT INTO kqf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kamaina bi Yesu i giuna gado, “Tagu e giuwem ee geḡa, bamoda tam kwai sumaḡana ba Maimaituwa ena ḡailisi namalina kwa kita?” ");
INSERT INTO kqf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kamaina bi ḡakima a kaikamaḡe tabunemo. Ḡome Yesu i waikita saḡa malamo bi i giuna gado, “Ebom, Tamagu, te kalinagu mote kuma vaivaiye kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tagu e sibe kauwem te tam sauga matabuna kalinagu kwa vaivaiye, bi bai e giuwemna ba niga lavedi sa moimoitona kedi nawamo te kalinagu sa vaiye bi sai sumaḡa te tam ba tagu kuna giukamaḡegu.” ");
INSERT INTO kqf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ḡome Yesu giu i waiwaikovi ba i binauna gado, “Yasalesi, ku potiyovo!” ");
INSERT INTO kqf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kamaina bi oloto pekipekina tauyewamo i potiyovo. Tana nimana, kaḡena, kununa bi tunina matabuna galamo sumesumedi. Ḡome Yesu i giuwedina gado, “Kokowaga galedi ko kaikamaḡedi bi ya nawa!” ");
INSERT INTO kqf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Diu lavedi wapewapedi Meli vakitana aubaina a tavatavana, tedi bai Yesu i voivoiyena a kita bi ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bi lava ḡesaudi a nawa Palisi lisidimo bi bai Yesu i voiyena taunana sa tainuwataudi. ");
INSERT INTO kqf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ḡome pilipilisi edi babada bi Palisi, ai ḡemotidi bi waibabada edi bolu a sako. Bi a giuna gado, “Tada niganana bai ta voiye? Niga olotona ba anisove kauwidi wapewapedi ya voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bamoda tada bi ta kita kamaḡena ba lava matabudi tana sai sumaḡe. Mba sauginemo kaka Loum ḡaviyidi sa tava te tada eda Pali vanuwina bi eda dobu sa kagebogebodi.” ");
INSERT INTO kqf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ḡome edi tau ḡesauna isana Kaiyapas, tana ba pilipilisi edi bada mba kwalabunemo. Tana i miyamoito bi i giuna gado, “Temi mote ko sibe te bai ko giugiuwe! ");
INSERT INTO kqf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Temi mote ko sibe, i visu te lava ḡemota maso aubaida i peki bi matabuda te yawasana, kaka dobu matabuna sa kagebogebona.” ");
INSERT INTO kqf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mba kwalabunemo, Kaiyapas ba pilipilisi edi bada. Bi niga giudi i vatovatodina ba mote nuwanemo i waitubudi. Bi Yesu Diu lavedi aubaidi ya pekina, taunana i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bi Diu lavedi mote taudiḡa, bi Maimaituwa natunatuna a dabadabalalana ya natomedi, te yai ḡemotidi bi dam ḡemota ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kamaina bi mba laḡannemo te noi i nawana ba tedi Yesu kana pota a yesi te sai peki. ");
INSERT INTO kqf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Taunana aubaina, Yesu mote Diu lavedi matediḡa i nawanawa. Bi ḡome te i nawa Iflem malagainemo kalakalalele diyanemo, bi ḡome ena tauwaikaiwatana vaitena a miya. ");
INSERT INTO kqf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Laḡannemo Diu lavedi edi Vawaitauli Soina saugina i tavatava ba lava wapawapa a tava Yelusalemmo ai ḡemotidi. Bi Diu lavedi edi vaivaimo ba a vokaukauwa munaḡedi muliḡa kaka Vawaitauli Soina. ");
INSERT INTO kqf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tedi yaḡolo te Yesu a tavutavuḡe, bi pali vanuwina didiyauna a moito kwaivivili bi edi lava ai talayedina gado, “Bainewa ko noḡonoḡoti? Kona sibe te niga soinemo ya tava ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bi geḡa te, pilisi edi babada bi Palisi giu a sako te aiyai bi bamo ḡome Yesu i banavina ba ya kamaḡati te sa pani. ");
INSERT INTO kqf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Muliḡa kaka laḡan 6 sa kovi te Vawaitauli Soina, bi Yesu i tava Betenimo Yasalesi ena animiyamo, Yasalesina taunana i peki bi Yesu i kakenamoito munaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu i tava aubaina te tedi aubiga kanina a kanonoḡi. Mata kani i yati bi Yasalesi, Yesu bi lava ḡesaudi vaitedi teibolo diyanemo a kena giligili bi kani i vite nawedi te a kani. ");
INSERT INTO kqf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kamaina bi Meli masi panepanena af lita luvana dubina mai'ina dididiga i natome bi Yesu kaḡenemo i ḡini. Bi dabanemo i bakili bi vanuwa nopona ba masi panena i waiwanavu. Niga masina ba ḡawaḡawa isana nad masinemo a voiye. ");
INSERT INTO kqf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu ena tauwaikaiwatana ḡemota Diudas Iskaliot, tana taunana muliḡa ya sakoyovoḡe, i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mba masina maiina ba kwalabu ḡemota ena maiia luvana, temi maso kona kuneye bi manena lava wainuwatoitoidi kona vitedi.” ");
INSERT INTO kqf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tana niga giuna i giuwena ba mote lava wainuwatoitoidi sagudi aubaidi, banina tana ba taudanene. Bi kota tana ba mane baikina taulabena bi manenemo i laulaukulasolu. ");
INSERT INTO kqf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kamaina bi Yesu giu i waimunena gado, “Waivini ku kita kamaḡe, tana niga kauwina i voiyena ba dobogu aubaina i kanonoḡi. ");
INSERT INTO kqf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Temi laḡan matabuna lava wainuwatoitoidi vaitedi ko miyamiya bi tagu ba mote laḡan matabuna vaitemi tama miya nonoḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Laḡannemo Diu lavedi kumdi a vaiye te Yesu ba Betenimo Yasalesi ena vanuwemo, ba tedi a tava lisinemo. Bi mote Yesu taunaḡa kitana aubaina bi kota Yasalesi vaitena. Banina Yesu, Yasalesi pekimo i kakenamoito munaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Taunana aubaina, Pilisi edi babada ai ogatala te maso Yasalesi vaitena ai peki, ");
INSERT INTO kqf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","banina Yasalesi dabanemo lava wapewapedi Diu babadidi a dabokedi bi Yesu a waiwaisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Laḡan i sako te lava kumdi vawaitauli soina aubaina a tava bi a vaiye te Yesu ba Yelusalem aubaina i saḡasaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Taunana aubaina, lava galamo malugulugudi a legaudi bi a laupotiyovo etamo bi a binabinauna gado, “Ousana! Kakavisuvisuna, BADA isanemo ya natonato! Kakavisuvisuna Islael edi Ḡalibona.” ");
INSERT INTO kqf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu donki lauewalina i banavi bi i geluye, gilugilumina wadubonemo niga mainana giu: ");
INSERT INTO kqf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalem lavemi koma naila, ko kita emi ḡalibona donki lauewalinemo i gelu bi ya natonato.” ");
INSERT INTO kqf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Niga giuna ena tauwaikaiwatana mote a sibe bi ena kenamoito mulinemo kaka niga giudi banidi a sibedi. Bi giudi ba tana a gilugilumiwata bi kota niga kauwidi banidi lisinemo a tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mba laḡannemo ba lava kumdi Yesu vaitena bi Yasalesi pekina tauyewamo i kakakenamoitona a kita. Niganana mba lavedi taudidi giuna sa giugiunawe. ");
INSERT INTO kqf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Taunana aubaina, lava kumdi mataila i voivoiyena a vaivaiye ba a nawa lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kamaina bi Palisi taudiḡa ai giugiuna gado, “Niga mote bai ta maitubu, ko kita lava matabudi tana sa kaikaiwata.” ");
INSERT INTO kqf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lava mabai a nawanawa Yelusalemmo Vawaitauli soina aubaina ba Gulik lavedi ḡesaudi vaitedi a nawa. ");
INSERT INTO kqf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tedi Filip lisinemo a tava bi tana ba Betsaida olotona, bi Betsaida ba Galili noponemo bi ai baḡana gado “Ema tau, tama ka ḡoyeḡoyena Yesu ka kita.” ");
INSERT INTO kqf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ḡome te Filip i nawa Endulu i giuwe, bi labuḡidi a nawa te Yesu a giuwe. ");
INSERT INTO kqf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu edi giu i waimunena gado, “Saugina i tava te Tana Taunana Natuna namala sa vite.” ");
INSERT INTO kqf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tagu giukauwemo yà giugiuwemi, bamoda witi pesina mote kuma wadi ba pesina mai ya kenakena. Bi laḡannemo doḡamo sa wadina ba ya peki, bi ya duga te pesi wapewapedi ya sivudi. ");
INSERT INTO kqf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tedi mabai edi yawasana a nuwamunaḡedina ba sa kulayakasidi, bi mabai edi yawasana niga dobunemo a nuwakamaḡedina ba yawasana kenakena nonoḡina sa vai. ");
INSERT INTO kqf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tana aiyai bi aubaigu waitaupaula i ḡoyena ba ya kaiwatagu, te tagu bamo ḡome ba egu taupaula ḡome. Bi Tamagu kaka tana aiyai aubaigu ya waitaupaulana ya kavisuvisu. ");
INSERT INTO kqf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Niganana nuwapougu i yavi bi bena bai yà giuwe? Luvana yà giuna gado, ‘Tamagu, niga wainuwatoina saugina lisigumo kwa kaikamaḡe.’ Bi geḡa te taunana aubaina e yovo te wainuwatoina ya nawaye. ");
INSERT INTO kqf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamagu, tam taumḡa isam aubaina namala kwa vai.” Kamaina bi kalina malaḡa i yovona gado, “Tagu kaikana isagu aubaina namala e vai bi niganana kota yà vai munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Laḡannemo lava kumna kalina a vaivaiye ba ai noḡota benakage palele, bi lava ḡesaudi a giu te aneya i giu yovo Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kamaina bi Yesu i giuwedina gado, “Niga kalinina i yovona ba temi ko ḡailisina aubaina bi mote tagu. ");
INSERT INTO kqf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Niganana ba etala saugina i tava, te Maimaituwa niga dobuna ya etale bi dobu tauwaibadayena ya lauyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bi laḡannemo dobumo sai daweguna kaka lava matabudi yà natomedina lisigumo.” ");
INSERT INTO kqf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu niga giuna i giuwena ba bainewa tana ya pekina taunana i giuwata. ");
INSERT INTO kqf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lava kumdi a giuwena gado, “Ema Waiḡake ya giugiuwemai te Buyobuyona ba ya miya nonoḡa. Bainewa bi kuna giu te Tana Taunana Natuna sai dawe? Bi Tana Taunana Natuna ba aiyai?” ");
INSERT INTO kqf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kamaina bi Yesu giu i waimunena gado, “Yanayana ba temi lisimimo, kamaina te ko vai bi mote kaka vaitena koma miya gulata. Niga yanana kona vaina ba yananaḡa ko nawa. Muliḡa kaka waidudubala yai kwesitawemi. Lava mabai dudubalaḡa sa nawanawana ba mote a sibe te baiḡa sa nawanawa. ");
INSERT INTO kqf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yana kona vaina ba koi sumaḡe, te temi ba yanayana lavemi.” Laḡannemo Yesu giu i waiwaikovi ba i nawa tabunemo bi i miya moimoisili. ");
INSERT INTO kqf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Avena te Yesu anisove kauwidi wapewapedi matedimo i voiyedi bi yaḡolo te mote ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Niga ba taugiuwatana Aisaiya bai i giugiuwena mainana ya tubutubuḡa. Tana i giuna gado, “BADA, aiyai ema giu ya waisumaḡe? Bi BADA, aiyai lisinemo em ḡailisi kwa kamaḡati?” ");
INSERT INTO kqf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taunana aubaina, lava mote Yesu ai sumaḡe, banina taugiuwatana Aisaiya laidalolo ḡesaunemo kota i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Bada lava i voiyedi te mote a kita banavi, bi i voiyedi te nopodi a gududi, taunana aubaina sa kitakitana bi mote sima kita banavi. Bi mote sima sibegu ba mote sima nuwavitala lisigumo te tagu maso ei yawasanidi.” ");
INSERT INTO kqf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya niga giugiuna i giuwena banina Yesu ena ḡailisi namalina i kita, taunana aubaina i giuwata. ");
INSERT INTO kqf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Avena te Diu babadidi wapewapedi Yesu ai sumaḡe, bi geḡa te Palisi babadidi kedinawamo aubaina te tedi mote debamo a giugiuwata banina, bolu vanuwinemo male sa kapotiyovodi. ");
INSERT INTO kqf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tedi sa ḡoyeḡoyena maso lava tedi a kasaḡesaḡedi. Bi mote sima ḡoyeḡoye te Maimaituwa tedi ya kasaḡesaḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu kalinana dididiginemo i giuna gado, “Tana aiyai bi ya waisumaḡeguna ba mote tagu tauguḡa ima waisumaḡegu bi taugiukamaḡegu vaitena ya waisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tana aiyai bi ya kitakitaguna ba taugiukamaḡegu ya kitakita. ");
INSERT INTO kqf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tagu dobumo e yovona ba yanayana, te lava matabudi sai sumaḡeguna ba mote waidudubalemo sima miya. ");
INSERT INTO kqf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Bamoda lava egu giu sa vaiye bi mote sima voteyeteye ba tagu mote kaka yàma etaledi. Tagu e yovona mote dobu lavedi etaledi aubaina bi waiyawasanidi aubaina. ");
INSERT INTO kqf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tedi mabai a dabokegu bi egu giu mote sima waianine, mba giunana kaka laḡan damonemo ya etaledi. ");
INSERT INTO kqf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Niga ba giukauwa, banina tagu tauguḡa mote egu ḡailisimo yàma giugiu, bi Tamagu taugiukamaḡegu bai i giugiuvavasaḡeguna taudidi yà giugiuwedi. ");
INSERT INTO kqf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bi tagu e sibe te ena giuvavasaḡa ba yawasana ilailala ya natome. Taunana aubaina, bai yà giugiuwena ba Tamagu i giugiuweguna mainana yà giugiu.” ");
INSERT INTO kqf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Muliḡa kaka Vawaitauli Soina bi Yesu i sibe te sauga i tava te niga dobuna ya gose bi ya munaḡa Tamana lisinemo. Tana dobumo laḡan matabuna ena tauwaikaiwatana i ḡoyeḡoye kauwedi. Bi i ḡoyeḡoyedina eete edi noya damonemo a tava. ");
INSERT INTO kqf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ena tauwaikaiwatana vaitedi aubiga kanina a kanikani bi Seitan ba kaikana Diudas Iskaliyot noponemo noḡota gebogebona i sako te Yesu ya sakoyovoḡe, Diudas ba Saimon natuna. ");
INSERT INTO kqf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu i sibe te Tamana ḡailisi matabuna i vite te mwali matabudi yai badayedi. Tana i sibe te Maimaituwa lisinaḡa i yovo bi kota ya munamunaḡa Maimaituwa lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kamaina bi kani noponemo i miyamoito te ena kwama dabanemo i kotekotena i kaikamaḡe bi tauweli i vai te bwalinemo i pani. ");
INSERT INTO kqf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bi gauba i vai te abomemo i ḡini bi ena tauwaikaiwatana kaḡedi i koḡedi, bi tauweli bwalinemo panipanina isunemo kaḡedi i bakilidi. ");
INSERT INTO kqf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bi Yesu, Saimon Pita lisinemo i tavatava ba Saimon i giuna gado, “Bada, tam bena kaḡegu kwa koḡa, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Bi Yesu ena giu i waimunena gado, “Tagu bai niganana yà voivoiyena mote ku sibe bi muliḡa kaka banina kwa sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bi Pita i giuna gado, “Geḡa, kaḡegu mote kuma koḡa.” Ḡome Yesu ena giu i waimunena gado, “Bamoda kaḡem mote yàma koḡa ba tam mote egu tauwaikaiwatana.” ");
INSERT INTO kqf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita ena giu i waimunena gado, “Bada, mote kaḡegu taunaḡa kuma koḡa, nimagu bi kunugu kota vaitedi kwa koḡedi.” ");
INSERT INTO kqf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ḡome Yesu giu i waimunena gado, “Lava mabai kaikana a asiwana ba kaḡediḡa sa koḡedi, tunidi matabudi ba sabusabudi. Bi temi matabumi ba kona asiwa bi geḡa te, ḡesaumi mote ko asiwa.” ");
INSERT INTO kqf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kaikana i sibe te aiyai kaka ya sakoyovoḡe, taunana aubaina i giuna gado, “Matabumi mote lailaisabusabumi.” ");
INSERT INTO kqf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Laḡannemo kaḡedi i koḡakoḡa kovidi ba ena kwama i kote munaḡe bi i munaḡa ena animiyamo. Bi i waitalayedina gado, “Tagu bai lisimimo e voiyena banina kona sibe ee geḡa? ");
INSERT INTO kqf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Temi ko waiisaguna gado, ‘Tauwailovelove.’ Bi ‘Bada.’ Bi mba ko giugiukauwa, lavana ba tagu taunana. ");
INSERT INTO kqf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Niganana ba tagu emi Bada bi tauwailovelove, kaḡemi e koḡedina ba temi kota mainana emi lava, kaḡedi ko koḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tagu kauwa ei lovemi te kona kita bi bai e voivoiyena mainana temi ko voiye. ");
INSERT INTO kqf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tagu giukauwemo yà giugiuwemi te taupaula mote edi bada sima saḡa kamaḡe, bi kota mainana tauwainoyanoya mote ḡemoḡemotina te taugiukamaḡena ima saḡa kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","“Temi niga giukauwidi niganana kona sibedi, bi ko miyaedina ba Maimaituwa kaka ya kavisuvisumi.” ");
INSERT INTO kqf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tagu mote matabumi yàma giugiuwemi bi mabai e vinevinedina taudidi e sibedi. Bi gilugilumina wadubonemo bai i giugiuwena ba kamaina te ya tubuḡa, ‘Tagu aiyai vaitena ke kanikani ḡemotana mba lavana ya nuwavitala te yai ḡaviyegu.’ ");
INSERT INTO kqf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Bi muliḡa kaka kauwa sa tubuḡana bi tagu niganana yà giugiuwemi te laḡannemo bi sa tubuḡana ba temi koi sumaḡa te Tagu Mai Miyamiyagu. ");
INSERT INTO kqf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tagu giukauwemo yà giugiuwemi, te lava aiyai e giukamaḡe bi aiyai lavana ya giugiuvaina ba tagu ya giugiuvaigu. Bi aiyai tagu i giuvaiguna ba taugiukamaḡegu ya giugiuvai.” ");
INSERT INTO kqf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Niga giuna mulinemo ba Yesu nopona nuwaboya i wanavu bi ena tauwaikaiwatana i giuwedina gado, “Giukauwemo yà giugiuwemi te temi modomimo ḡemota kaka ya sakoyovoḡegu.” ");
INSERT INTO kqf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tedi ai nuwanaina bi ai matakita te aiyai lavana ya giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bi Yesu ena tauwaikaiwatana mododimo ḡemota, taunana i ḡoyeḡoye kauwena diyanemo i miyamiya. ");
INSERT INTO kqf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kamaina bi Saimon Pita lava Yesu diyanemo i miyamiyana i laumatakamote bi i kasavenana gado, “Bada kwai talaye te lava aiyai ya giugiuwe?” ");
INSERT INTO kqf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ḡome te ena tauwaikaiwatana i miyanato Yesu diyanemo bi i waitalana gado, “Bada, aiyai lavana?” ");
INSERT INTO kqf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu giu i waimunena gado, “Tana aiyai buledi abomemo yài dakwa bi yà vitena mba taunana lavanana.” Kamaina bi Yesu buledi i vai te i waidakwa bi Saimon natuna Diudas Iskaliyot i vite. ");
INSERT INTO kqf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mba ḡome Diudas buledi i vaivai ba Seitan noponemo i sola saḡa. Bi Yesu, Diudas i giuwena gado, “Bai kwa noḡonoḡotina ba kwa voiye makaiye.” ");
INSERT INTO kqf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bi tedi teibolomo a kanikanina, Yesu ba Diudas i giugiuwena lisidimo banina mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bi Diudas ba mane taulabena, taunana aubaina ena lava ai noḡota bena Yesu, Diudas i giugiuwe te soi kanina ya gimala ee lava waiyamoyamonidi mane ya vitedi. ");
INSERT INTO kqf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ḡome Diudas buledi i kanikani kovi ba tana i vapotiyovo te dudubalaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Laḡannemo Diudas i nawanawa mulinemo ba Yesu i giuna gado, “Niganana kaka Tana Taunana Natuna namalina ya laumaḡata. Maimaituwa namalina kaka Natuna lisinemo ya kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bi Natuna ena ḡailisi namalina kaka Maimaituwa ya vite. Bi mote ima lofa te Maimaituwa ena ḡailisi namalina Natuna ya vite. ");
INSERT INTO kqf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Natunatugu, tagu mote kaka vaitemi tama miya gulata. Temi kaka ko tavuḡegu bi mote koma banavigu. Bamomaiḡa yà nawanawana ba temi mote luvemi te maiḡa ko nawa. Niga giudi ḡemotidi Diu babadidi e giuwedi bi niganana kota temi yà giugiuwemi. ");
INSERT INTO kqf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bi niganana waiḡake valivaliuna yà vitevitemina ba: Emi lava, emi lava ko ḡoyedi, mai tagu e ḡoyeḡoyemina. Taunana aubaina emi lava ko ḡoyedi. ");
INSERT INTO kqf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bamoda emi lava, ko ḡoyedina kaka lava matabudi sa sibemi te temi ba tagu egu tauwaikaiwatana.” ");
INSERT INTO kqf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Bi Saimon Pita i waitalana gado, “Bada, bamo maiḡa kwa nawanawa?” Ḡome Yesu ena i giu waimunena gado, “Tagu niganana bamo maiḡa ya nawanawana ba tam mote ḡemoḡemotim te kwa kaiwatagu, bi muliḡa kaka tam kwa kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita i waitalana gado, “Bada, bai aubaina niganana mote yàma kaiwatam? Tagu e vononoḡa te vaitem ta peki.” ");
INSERT INTO kqf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kamaina bi Yesu ena giu i waimunena gado, “Tam giukauwa te tagu aubaigu kwa peki, ee? Tagu giukauwemo yà giugiu te muliḡa kaka kamkam ya ḡabana bi tam kaka mala faiona kwa valele te tagu mote ku sibegu.” ");
INSERT INTO kqf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu i giuwedina gado, “Mote komai nuwaboya, Maimaituwa koi sumaḡe bi kota tagu koi sumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tamagu ena vanuwemo ba nakanaka wapewapedi, bamoda gabu geḡa tagu maso mote yà giuwemi. Niganana tagu ḡome yà nawanawana kaka emi gabu yà kanonoḡidi. ");
INSERT INTO kqf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Laḡannemo yà nawa bi emi gabu yà kanonoḡina ba yà yovo munaḡa te matabumi yài doli nawemi egu animiyamo, te vaitemi ḡome ta miya ḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tagu gabunemo yà nawanawana ba etana temi kona sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas i giuna gado, “Bada tama mote ke sibe te tam bamomaiḡa kwa nawanawa, bi tama bainewa bi mba etana ka sibe?” ");
INSERT INTO kqf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kamaina bi Yesu i giuna gado, “Tagu taunana eta, giukauwa bi yawasana ilailala. Aiyai mote Tamagu lisinemo ima tava, te tagu lisigumo ya tava kaka ya nawa Tamagu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bamoda tagu kona sibeguna ba mainana kota Tamagu ko sibe. Niganana, bi noi i nawana ba temi tana kona sibe bi kona kita.” ");
INSERT INTO kqf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ḡome Filip i giuna gado, “Bada, Tamam kwai lovemaina kaka nuwamai ya kena.” ");
INSERT INTO kqf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Bi Yesu ena giu i waimunena gado, “Filip, vaitem te alamiya bi mote ku sibegu? Tana aiyai bi i kitaguna ba Tamagu i kita. Bi tam bai aubaina kwa giugiu te Tamagu yai lovemi? ");
INSERT INTO kqf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, mote ku waisumaḡegu te tagu Tamagu noponemo bi Tamagu tagu nopogumo? Niga giudi yà giugiuwedina mote nuwagumo yàma waitubudi, tam kwa sibe te Tamagu nopogumo ya miyamiyana taunaḡa ena noya ya voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sauginemo yà giuna gado, Tagu ba Tamagu noponemo bi Tamagu ba Tagu nopogumo ba kamaina te kwai sumaḡegu. Bi geḡa ba, anisove kauwidi e voivoiyedina kwa kitedi bi kwai sumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tagu giukauwemo yà giugiuwemi, te tana aiyai bi i waisumaḡeguna kaka bai e voivoiyedina mainana ya voiyedi. Bi tana kaka kauwa nananaka otidi ya voiyedi, mote mai niga kauwidi, banina Tamagu lisinemo yà nawanawa. ");
INSERT INTO kqf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bi tagu isagumo, bai ko waibaḡayena, ba tagu kaka yà voiye te Tamana namalina ḡaiḡailisina Natuna lisinemo yà kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Temi bai mwalina isagumo koi baḡayena ba tagu kaka yà voiye.” ");
INSERT INTO kqf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Bamoda kwa ḡoyeguna, ba egu waiḡake kwa voteyateyaedi. ");
INSERT INTO kqf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bi tagu kaka Tamagu yài baḡa, te emi tausagu ḡesauna ya vitemi te vaitena ko miya nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tana ba Aluwa Waiyawa, Maimaituwa ena giukauwa taukamaḡatina. Bi dobu lavedi mote luvana te simai anine, banina tedi mote a kita ee a sibe. Bi temi kona sibe te tana ba vaitemi bi nopomimo kaka yà miya. ");
INSERT INTO kqf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tagu mote kaka yàma gose kamaḡemi maibena kedakeda bi lisimimo kaka tagu yà yovo munaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bi laḡan watiḡena ba dobu lavedi mote sima kitagu. Bi temi kaka tagu ko kitagu, tagu e yawasana aubaina temi kota ko yawasana. ");
INSERT INTO kqf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Laḡannemo yà kenamoitona kaka temi ko sibe te tagu ba Tamagu noponemo, bi temi ba tagu nopogumo bi tagu ba temi nopomimo. ");
INSERT INTO kqf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tedi mabai egu waiḡake sai aninedi bi sa kaikaiwatedina mba taudidi tagu sa ḡoyeḡoyegu. Bi mabai sa ḡoyeḡoyeguna ba Tamagu kaka ya ḡoyedi, bi tagu kota tedi yà ḡoyedi bi lisidimo yà kamaḡati munaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kamaina bi Diudas (mote Diudas Iskaliyot) i giuna gado, “Bada, bai aubaina te tama lisimaimo kwa kamaḡatim bi mote dobu lavedi lisidimo kuma kamaḡatim?” ");
INSERT INTO kqf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Bi Yesu ena giu i waimunena gado, “Tana aiyai bi ya ḡoyeḡoyeguna ba egu wailovelove ya voteyeteyedi. Bi Tamagu kaka tana ya ḡoye, bi tama kaka ka nato lisinemo te vaitena ka miya. ");
INSERT INTO kqf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tana aiyai bi mote ima ḡoyeḡoyegu ba egu wailovelove mote ima voteyeteyedi. Bi niga giudi ko vaivaiyedina ba mote nuwagumo yàma waitubudi, bi Tamagu i giugiukamaḡeguna kalinana. ");
INSERT INTO kqf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Temi yaḡolo vaitemi ta miyamiya, aubaina te niga giudi matabudi yà giugiuwemi. ");
INSERT INTO kqf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bi laḡannemo emi Tausagu Aluwa Waiyawa, isagumo Tamagu ya giukamaḡena, ba mwali matabudi kaka yai lovelovemi bi bai matabudi e giugiuwemina kaka ya talawainoḡotimi. ");
INSERT INTO kqf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Bi tagu ba yà nawana bi nuwauba yà vitevitemi. Tagu nuwauba yà vitevitemina ba mote mai dobu lavedi sa vitevitemina. Taunana aubaina, temi mote komai nuwaboya bi nuwemi ima kuluva. ");
INSERT INTO kqf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Temi kona vaiye, e giuwemina gado, ‘Tagu ba yà nawana, bi yà munaḡa yovo lisimimo.’ Bamoda ko ḡoye kauweguna, ba koi nuwavisu te Tamagu lisinemo yà nawanawa, banina Tamagu i saḡa gulatana mote mai tagu. ");
INSERT INTO kqf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Muliḡa kaka kauwa sa tubuḡana bi niganana yà giugiu wainonomi te koi sumaḡa, te bai e giugiuwemina ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mote bamo gavogavo te lisimimo yà gagali gulata, banina niga dobuna tauwaibadayena kaikana ya tavatava. Tana mote ena ḡailisi tagu lisigumo ima kenakena. ");
INSERT INTO kqf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tagu Tamagu bai i giugiuvavasaḡeguna taunana yà voiye, te dobu lavedi sa sibe te tagu ba Tamagu yà ḡoyeḡoye kauwe. “Ko potiyovo bi ta nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kamaina bi Yesu i giu munaḡana gado, “Tagu taunana waen kaina, bi Tamagu ba taubayau. ");
INSERT INTO kqf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Bi tagu modogumo, lagalaga mote sima votavota ba tana ya guledi bi lagalaga a votavotana ba ya gula yawasidi te sa vota gulata. ");
INSERT INTO kqf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Temi kaikana kona visuvisu, banina tagu giu visuvisuna ei lovelovemi. ");
INSERT INTO kqf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Te temi tagu nopogumo ko miya, kota tagu temi nopomimo yà miya. Bi waen kaina lagalagana mote kaka taudiḡa sima vota yababa, kamaina te waen kaina modonemo sa patuna kaka sa vota. ");
INSERT INTO kqf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Tagu taunana waen kaina, bi temi ba lagalagana. Tedi mabai tagu nopogumo sa miyamiya bi tagu tedi nopodimo kaka sa vota gulata. Bi temi mote tagu vaitegu ba mote kaka koma vota. ");
INSERT INTO kqf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tana aiyai bi mote nopogumo ima miyamiya, ba tana maibena kai lagana nuwagasina sa pwalaḡe, bi ya pokipokina. Mba mai lagelagedi ba sa laitupedi te kaimo sai kalaḡosedi. ");
INSERT INTO kqf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bamote temi tagu nopogumo ko miyamiyana ba giugu nopomimo sa kenakena, bi bai ko ḡoye bi koi baḡayena ba tagu kaka yà vitemi. ");
INSERT INTO kqf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Laḡannemo ko votavota gulatana, ba temi ko kakamaḡatimi te egu tauwaikaiwatana. Mba votanana taunana Tamagu namalina ya kakamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tamagu ya ḡoyeḡoyeguna, mainana kota tagu temi yà ḡoyeḡoyemi. Temi niganana ba egu ḡoyemo ko miya. ");
INSERT INTO kqf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bamoda egu giuvavasaḡa ko voteyeteyedina ba temi kaka tagu egu ḡoye noponemo ko miya, maibena tagu Tamagu ena giuvavasaḡa e voteyeteye bi ena ḡoyemo yà miyamiyana. ");
INSERT INTO kqf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Bi tagu niga giudi e giuwemi te yasisigu nopomimo ya kena bi ko yasisi nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Niga taunana egu giuvavasaḡa: Temi emi lava ko ḡoyedina mai tagu yà ḡoyeḡoyemina. ");
INSERT INTO kqf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bi ḡoye laukaina ba tana aiyai ena yawasana ya vitevite munaḡena ena lava aubaidi. ");
INSERT INTO kqf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bamoda temi tagu egu lava ba egu giuvavasaḡa ko kaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tagu mote yàmai isemi taupaula, banina taupaula edi bada bai ya voivoiyena mote a sibe. Taunana aubaina, yà waiisemina egu lava, banina Tamagu bai matabudi i wailoveloveguna ba temi ei lovelovemi. ");
INSERT INTO kqf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Temi mote tagu ko vinegu bi tagu temi e vinemi bi e giukamaḡemi te ko vota. Bi mba votedi ba sa kena nonoḡa. Taunana aubaina, isagumo bai ḡesauna koi baḡayena ba Tamagu kaka ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Niga taunana egu giuvavasaḡa: Temi emi lava ko ḡoyedi.” ");
INSERT INTO kqf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Bamoda dobu lavedi sa dabokemina ba ko noḡoti te tagu dolinemo a gei dabokegu. ");
INSERT INTO kqf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bamoda temi dobu lavedi edi miyamiyamo ko miyana ba dobu lavedi sa ḡoyemina mai tedi edi lava otidi. Bi geḡa te, temi niga dobunemo e vinekamaḡemi te mote niga dobuna aubaina. Taunana aubaina, dobu lavedi kaka temi sa dabokemi. ");
INSERT INTO kqf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tagu niga giudi e giugiuwemina ko noḡotidi, ‘Taupaula mote kaka ena bada ima saḡa kamaḡe.’ Bamoda lava sa laulaukivigebogeboyeguna ba kota temi sa laukivigebogeboyemi. Bamoda egu wailovelove sa vovoteyeteyedina ba temi kota emi wailovelove sa voteyeteyedi. ");
INSERT INTO kqf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bi lava kaka sa laukivigebogeboyemi, banina temi ba tagu aubaigu. Bi tedi mote a sibe te aiyai i giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bamoda lisidimo mote maso e nato bi e lauguguya, ba gebogebo wavuna maso mote a avali. Bi niganana mote gebogebomo simai papa, banina tagu kaikana lisidimo e lauguguya. ");
INSERT INTO kqf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tana aiyai bi ya dabodabokeguna ba kota Tamagu ya dabodaboke. ");
INSERT INTO kqf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tagu mataila nananakidi e voiyedi a kitekitedina ba mote bamo aiyai mainana i voiyedi. Bamoda tagu mote maso matailidi e voiyedi ba maso mote gebo wavuna a avali. Bi geḡa te, tagu niga matailidi e voivoiyedina a kitedi, bi yaḡolo te tagu bi Tamagu sa dabodabokemai. ");
INSERT INTO kqf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Niga ba edi waiḡake gilugilumina wadubonemo banina ya tubutubuḡa. Gilugilumina i giuna gado, ‘Tedi mote bai gebona lisigumo a banavi bi tagu a daboke yababegu.’ ");
INSERT INTO kqf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tamagu kaka tausagu Aluwa Waiyawa yà giukamaḡe yovoḡe. Aluwina taunana giukauwemo yai eta doliyemi bi tagu ya giuwaimaḡatigu. ");
INSERT INTO kqf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bi temi kaka lava ḡesaudi lisidimo tagu ko giuwatagu, banina pakanemo ba temi tagu vaitegu.” ");
INSERT INTO kqf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Bi Tagu bai matabuna e giuwemi te temi mote waisumaḡa koma kaisako. ");
INSERT INTO kqf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bi temi kaka bolu vanuwinemo sa kwavivaimi, bi saugina ya tavana ba lava aiyai i waipekimina ba ya wainoḡota te bena Maimaituwa ena noya ya voivoiye. ");
INSERT INTO kqf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tedi kaka niga mainana kauwidi sa voiyedi, banina Tamagu bi Tagu mote a sibemai. ");
INSERT INTO kqf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tagu niga kauwidi e giuwemi te sauga ya natonatona niga kauwidi sa tubuḡana, ba bai e geigei giuwemina ko noḡotidi. Tagu pakanemo mote yà giuwemi, banina tagu temi vaitemi. ");
INSERT INTO kqf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tagu niganana yà nawanawana taugiukamaḡegu lisinemo bi geḡa te, mote aiyai kuma waitalayegu gado, “Tam bamo kwa nawanawa? ");
INSERT INTO kqf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bi banina niga giudi e giuwemi, taunana aubaina te ko waiwainuwaboya. ");
INSERT INTO kqf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tagu giukauwemo yà giugiuwemi, temi emi visu aubaina te tagu yà nawa. Bamote tagu bi mote yàma nawa ba emi Tausagu mote kaka lisimimo ima yovo. Bi yà nawana kaka Tausagumi yà giukamaḡe yovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bi laḡannemo ya yovona ba dobu lavedi yai lovelovedi te edi gebogebo sa sibedi, didimana voiyedi sa sibedi bi kovoḡa ya natonatona sa sibe. ");
INSERT INTO kqf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bi gebogebo giuna ena yawanimo ba, banina lava mote tagu sima waisumaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bi didimana voiyena ena yawanimo ba niga mainana, banina tagu yà nawanawa Tamagu lisinemo bi temi mote koma kitagu. ");
INSERT INTO kqf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bi etala ena yawanimo ba, banina Maimaituwa kaikana niga dobuna tauwaibadayena i lauyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Bi giu i wapa te maso e giuwemi bi temi mote luvemi te koma sibe kovidi. ");
INSERT INTO kqf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Laḡannemo giukauwa Aluwina ya yovona, kaka giukauwemo yai eta doliyemi. Tana mote taunaḡa ena ḡailisimo ima gagali bi lisigumo bai ya vaivaiyena taunana ya gagaliye bi kauwa bai muliḡa sa tubuḡana taudidi ya giuwemi. ");
INSERT INTO kqf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tana bai lisigumo ya vaivaiyena taunana ya giuwemi te namala ḡaiḡailisina ya vitegu. ");
INSERT INTO kqf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bi bai matabuna Tamagu lisinemo ba tagu aubaigu, taunana aubaina tagu e giuna gado, ‘Aluwa Waiyawa lisigumo bai ya vaivaiyena taunana lisimimo ya kamaḡatidi.’” ");
INSERT INTO kqf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu i giuna gado, “Temi sauga watiḡena mote koma kitagu bi mote ima lofa te ko kita munaḡegu.” ");
INSERT INTO kqf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ena tauwaikaiwatana taudiḡa ai giugiuna gado, “Tana i giuwedana gado, ‘Temi sauga watiḡena mote koma kitagu bi mote ima lofa te ko kita munaḡegu.’ Niga giuna banina ba bai? Bi kota i giuna gado, ‘Banina tagu yà nawanawa Tamagumo.’ Niga giuna banina ba bai?” ");
INSERT INTO kqf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tedi yaḡolo te a waitalana gado, “Niga giuna, ‘Sauga watiḡena.’ Mba banina bai? Tada mote ta sibe te tana bai ya giugiuwe.” ");
INSERT INTO kqf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bi Yesu i sibe te tedi a ḡoyeḡoyena tana sai talaye, taunana aubaina i giuwedina gado, “Tagu e giuwemi te, laḡan watiḡena mote kaka koma kitagu bi mote lofana te ko kitagu. Temi niga giuna taunana ko waitalapiliye, ee? ");
INSERT INTO kqf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tagu giukauwa yà giugiuwemi, te temi ba ko ḡaba bi koi nuwaboya. Bi dobu lavedi ba sa yasiyasisi, temi ba koi nuwatoi bi emi wainuwatoi kaka ya nuwavitala te ko yasisi. ");
INSERT INTO kqf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Laḡannemo waivini nuwana wainatuna ba yavi ya vai, banina ena waibewa saugina i tava, bi gomana i tubuḡana mba yavina i kovi. Tana ya yasisi banina gomana dobumo i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mba kauwina ḡemotina kota mainana lisimimo ya tubuḡa. Te temi niganana ko wainuwaboya bi tagu kaka yà kita munaḡemi te ko yasisi bi emi yasisina mote aiyai kaka lisimimo ima kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mba laḡannemo temi mote kaka bai ḡesauna lisigumo komai baḡaye. Tagu giukauwemo yà giugiu te isagumo bai koi baḡayena Tamagu lisinemo ba ya vitemi. ");
INSERT INTO kqf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Temi yaḡolo mote isagumo bai koi baḡaye eete niganana. Bi niganana koi baḡana ba ko banavi bi koi nuwavisu gulata.” ");
INSERT INTO kqf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tagu niga kauwidi lautaulalamo e giugiuwedi. Bi sauga ya natonato kaka Tamagu giuna yà giu otiḡemi bi mote lautaulalamo yàma giu. ");
INSERT INTO kqf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bi mba laḡannemo temi kaka isagumo Tamagu koi baḡa bi tagu mote temi aubaimi tana yàmai baḡa. ");
INSERT INTO kqf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bi Tamagu taunana ya ḡoyeḡoyemi, banina temi tagu ko ḡoyeḡoyegu bi konai sumaḡegu te tagu Tamagu lisinaḡa e yovo. ");
INSERT INTO kqf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tagu Tamagu lisinaḡa e yovo te dobumo e tava bi niganana ba dobu yà gosegose bi yà munamunaḡana Tamagu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kamaina bi Yesu ena tauwaikaiwatana a giuwena gado, “Niganana ba giu baniotidimo kwa giugiuwemai bi kuma laulautaulala. ");
INSERT INTO kqf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niganana kaka ke sibem te tam mwali matabudi kuna sibedi, bi mote ku ḡoye te lava ḡesau yai talayem. Mba taunana aubaina, tama kei sumaḡa te tam Maimaituwa lisinaḡa kuna yovo.” ");
INSERT INTO kqf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Bi Yesu edi giu i waimunena gado, “Temi niganana kaka konai sumaḡa, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saugina ba ya natonato bi kaikana i tava, mba sauginemo temi kaka ko dabalala emi malagaiḡa. Temi kaka tagu ko gose kamaḡegu bi geḡa te, tagu mote tauguḡa, banina Tamagu ba tagu vaitegu. ");
INSERT INTO kqf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Tagu niga kauwidi e giuwemi te temi kaka lisigumo nuwauba ko vai. Bi dobumo kaka pilipili koi ḡalodi. Bi geḡa te, nuwemi ya lautou, banina tagu dobu tauwaibadayena e lauyovoḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu giu i waikovi, mulinemo ba i waikita saḡa malamo bi i laupalina gado, “Tamagu, saugina i tava te namalim ḡaiḡailisina kwa vitegu, bi tagu namala tam yà vitem. ");
INSERT INTO kqf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tam waibada kuna vitegu te tagu lava matabudi yài badayedi. Te lava mabai kuna viteviteguna ba yawasana ilailala yà vitedi. ");
INSERT INTO kqf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bi yawasana ilailala banina ba tam Maimaituwa giugiukauwim sa sibem, bi kota tagu Yesu Keliso, kuna giugiukamaḡeguna sa sibegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tagu dobumo noya kuna viteviteguna ba ei kovi te dobumo namalim ḡaiḡailisina yà kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bi Tamagu, niganana em ḡailisi namalinemo kwa saḡegu, ḡailisina namalinemo wala te miyamiya, muliḡa kaka dobu i tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Bi niga dobunemo tauwaikaiwatana kuna viteviteguna, lisidimo tam e kamaḡatim. Tedi wala tam aubaim, bi tagu kuna vitegu te gium a voteyeteye. ");
INSERT INTO kqf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tedi niganana a sibe te bai matabuna kuna viteviteguna ba tam lisimḡa sa yovoyovo. ");
INSERT INTO kqf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tam giu kuna viteviteguna e vitedi te ai aninedi. Bi a sibe te giukauwa, tam lisimḡa e yovo bi ai sumaḡa te tam kuna giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Tagu egu pali ba mote dobu lavedi aubaidi bi mabai kuna viteviteguna aubaidi yà laulaupali, banina tedi ba tam aubaim. ");
INSERT INTO kqf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bai matabuna tagu lisigumo ba tam aubaim, bi bai matabuna tam lisimmo ba tagu aubaigu. Te tedi ḡailisi sa vai bi namala tagu sa vitegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tagu mote dobumo yàma miya wailofa bi, tedi yaḡolo dobumo sa miyamiya. Bi geḡa te, tagu ba niganana lisimmo yà saḡasaḡa. Tamagu Waiwaiyawim, isam kuna viteviteguna, niganana isamna ena ḡailisimo kwa labedi te tedi ba ḡemota maibena tada. ");
INSERT INTO kqf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Laḡannemo tedi tagu vaitegu ba, em waibada ḡaiḡailisina kuna vitevitegunemo e labe kauwedi te mote ḡemota i ainawanawa. Bi geḡa te, aiyai te ya ainawanawana taunana i ainawanawa te, gilugilumina wadubonemo banina ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bi tagu niganana ba lisimmo yà saḡasaḡa. Tagu yaḡolo dobumo vaitedi bi niga kauwidi yà giugiuwedi, te tedi egu yasisi nopodi yai wanavu. ");
INSERT INTO kqf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tam gium tagu e vitedi, bi dobu lavedi tedi a dabokedi, banina tedi mote dobu lavedi, kota tagu mainana mote dobu lavagu. ");
INSERT INTO kqf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tagu mote yàma laulaupali te egu tauwaikaiwatana kwa nawedi tabudimo, bi kwa labe kauwedi te ḡaviḡaviyina mote ima kagebogebodi. ");
INSERT INTO kqf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tedi ba mote dobu lavedi, tagu kota mainana mote dobu lavagu. ");
INSERT INTO kqf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tam gium ba giukauwa. Em giukauwinemo egu tauwaikaiwatana kwa voiyedi te saila waiyawa. ");
INSERT INTO kqf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tam dobumo kuna giukamaḡe yovoḡegu, mainana kota tedi dobumo yà giugiukamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bi tedi aubaidi tagu yà vitevite munaḡegu, te tedi kota giukauwemo sa vite munaḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tagu egu pali ba mote egu tauwaikaiwatana taudiḡa aubaidi. Bi edi lauguguyemo mabai sai sumaḡeguna kota vaitedi aubaidi yà laulaupali, ");
INSERT INTO kqf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","te tedi matabudi ba ḡemota. Tamagu, tedi kwa natomedi tada nopodemo maibena tam tagu nopogumo bi tagu tam nopommo. Te dobu lavedi sa kita bi sai sumaḡa te tam, tagu kuna giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bi tam em ḡailisi namalina kuna viteviteguna taunana e vitedi te tedi nuwaḡemotemo sa miya, maibena tam bi tagu tada ḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Te tagu ba tedi nopodimo bi tam ba tagu nopogumo. Tam tedi kwai ḡemotidi te bwainemo sa miya nonoḡa. Mba mainana kaka dobu lavedi sa sibe te tam tagu kuna giukamaḡegu. Bi kota sa sibe te tam kwa ḡoyeḡoyedina mainana tagu kwa ḡoyeḡoyegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamagu, muliḡa kaka dobu i tubuḡana, tam kuna ḡoye kauwegu aubaina te namala saḡasaḡa guletina kuna vitegu. Tagu yà ḡoyeḡoyena tedi mabai kuna viteviteguna, tagu bamo ḡome ba tedi vaitedi te egu ḡailisi namalina sa kita. ");
INSERT INTO kqf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamagu, tam didimanim, dobu lavedi mote tam a sibem, bi tagu tam e sibem. Bi tedi mabai kuna viteviteguna a sibe te tam ba tagu kuna giukamaḡegu. ");
INSERT INTO kqf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tagu tedi lisidimo e kamaḡatim, bi yaḡolo te yà giu nawem. Te em ḡoye lisigumo ba tedi nopodimo ya kena, bi tagu tedi nopodimo yà miya.” ");
INSERT INTO kqf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Laḡannemo Yesu pali i waiwaikovi, ba ena tauwaikaiwatana vaitedi Kidlon gwagwanaḡa a nawa te noi nevanemo a tava. Bi ḡome ba oliv kaidi guguludi. ");
INSERT INTO kqf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Diudas tana Yesu tausakoyovoḡena bi mba dobuna i sibe, banina tedi laḡan wapawapa ḡome a waiḡemota. ");
INSERT INTO kqf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Taunana aubaina, Diudas Palisi bi pilipilisi edi babada, Loum edi tauwaiḡaviya visa bi pali vanuwina tauyavena a giugiukamaḡedina i waietadoliyedi te oliv kaidi gugulunemo a tava. Tedi nimedimo ba kwadam bi aniwaiḡaviya madedi. ");
INSERT INTO kqf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu bai matabudi lisinemo sa tubuḡana i sibedi, kamaina bi i moito nawa matedimo bi i waitalayedina gado, “Temi aiyai ko tavutavuḡe?” ");
INSERT INTO kqf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tedi ena giu ai munena gado, “Nasalet Yesuna.” Bi Yesu i giuna gado, “Tagu taunana.” Bi Diudas, Yesu tausakoyovoḡena ba ḡome mba lavedi vaitedi a moimoito. ");
INSERT INTO kqf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bi ḡome Yesu i giuwedina gado, “Tagu niga taunana, ba tedi ai mulisuwasuwa te a kuluva doḡamo.” ");
INSERT INTO kqf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kamaina bi Yesu i waitala munaḡedina gado, “Temi aiyai ko ḡoyeḡoye?” Bi tedi a giuna gado, “Nasalet Yesuna.” ");
INSERT INTO kqf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kamaina bi Yesu i giuwedina gado, “Kaikana e giuwemi te tagu taunana. Bi bamoda tagu ko tavutavuḡegu, ba niga oloolotodi ko giuwedi te sa nawa.” ");
INSERT INTO kqf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Niga giuna ba dolinemo i giugiuwedina mainana i tubuḡa. Tana i giuna gado, “Tamagu, kuna viteviteguna mote ḡemota e laipaili.” ");
INSERT INTO kqf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ḡome te Saimon Pita ena kwatikwati i soluvai bi pilisi saḡasaḡa guletina ena taupaula isana Malukasi beyana kataiyanemo i tadi kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu, Pita i giuvavasaḡena gado, “Em kwatikwati ku sako munaḡe ena gabumo. Tam kunai noḡota bena Tamagu wainuwatoi yavina i viteguna mote yàma nawae, ee? Bena yà nawae.” ");
INSERT INTO kqf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kamaina bi Loum edi tauwaiḡaviya visa, edi bada bi pali vanuwina tauyavena Yesu a kaididi bi a pani. ");
INSERT INTO kqf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tedi tana a gei nawe Kaiyapas botiyana Anas lisinemo. Kaiyapas ba pilisi saḡasaḡa guletina mba kwalabunemo. ");
INSERT INTO kqf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyapas taunana wala Diu babadidi i giuwedina gado, “I visu te lava ḡemota lava matabudi aubaidi ya peki.” ");
INSERT INTO kqf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita bi tauwaikaiwatana ḡesauna Yesu a vavawata nawe. Pilisi saḡasaḡa guletina mba tauwaikaiwatanina ḡesauna i sibe taunana aubaina, Yesu vaitena a sola nawa pilisi saḡasaḡa guletina ena vanuwa didiyaunemo. ");
INSERT INTO kqf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bi Pita ba ganakuku mataetinemo i waiwailaba. Bi mba tauwaikaiwatanina ḡesauna i potiyovo munaḡa ganakuku mataetinemo bi taupaula waivinina ḡome noyanoyana i giuwe te Pita yai doli saḡe ganakuku noponemo. ");
INSERT INTO kqf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bi taupaula waivinina Pita i waitalayena gado, “Tam kota niga olotona ena tauwaikaiwatana ḡemota, ee?” Bi Pita giu i waimunena gado, “Geḡa, mote tagu.” ");
INSERT INTO kqf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mba ḡome ba tululu i didiga taunana aubaina, taupaula bi tauyava kai a muka, a moito waikwaivivili bi a malimalili. Bi Pita kota ḡome vaitena a malimalili. ");
INSERT INTO kqf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tedi ḡome a malimalili ba Pilisi saḡasaḡa guletina noke Yesu i waitalayena gado, “Em tauwaikaiwatana ba mabai bi bai kuna wailoveloveye?” ");
INSERT INTO kqf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Bi Yesu giu i waimunena gado, “Tagu sauga matabuna debamo e gagagali. Tagu Diu lavedi edi bolu vanuwidiḡa bi pali vanuwinemo bamo Diu lavedi a waiḡemotana ba ḡome e waiwailovelove. Bi mote bamo kandavonemo yà giugiu. ");
INSERT INTO kqf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bai aubaina kwa waitalayegu? Lava a vaivaiyeguna kwai talayedi. Tedi bai e giugiuwena a sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Laḡannemo Yesu niga mai i giugiu ba tauyava ḡemota diyanemo i moimoitona Yesu i launevakau bi i giuwena gado, “Mba mainana pilisi saḡasaḡa guletina ena giu waimunena, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Bi Yesu giu i waimunena gado, “Bamoda bai giuna e vatowapana ba kwa giu, bi bamo te giukauwa e giuwena ba bai aubaina kuna launevakaugu?” ");
INSERT INTO kqf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ḡome te Anas Yesu manima panipanina i giukamaḡe pilipilisi edi bada Kaiyapas lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bi Saimon Pita i moito i malimalili bi ai talayena gado, “Tam kota ena tauwaikaiwatana ḡemota, ee?” Tana i valelena gado, “Geḡa, mote tagu.” ");
INSERT INTO kqf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ḡome ba pilisi saḡasaḡa guletina ena taupaula, bi tana ba Pita oloto beyana i taditadikamaḡena ena dam lavana. Mba taupaulina Pita i giuwena gado, “Tagu olip kaina gugulunemo tam tana vaitena e kitemi.” ");
INSERT INTO kqf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ḡome Pita i valevalele munaḡa, ba kamkam ḡaba i waitubu. ");
INSERT INTO kqf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yesu ba Kaiyapas ena vanuwemo bi olaolala kaikana Diu babadidi ai doli nawe Loum gabemanina isana Paelat lisinemo. Tedi mote a ḡoye te sai miledi, taunana aubaina Paelat ena animiyamo mote a valageta, banina a ḡoyeḡoye te Vawaitauli Soina sa kani. ");
INSERT INTO kqf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kamaina bi Paelat i potiyovo doḡamo bi i waitalayedina gado, “Niga lavana bai gebona i voiye bi ko natonatome lisigumo?” ");
INSERT INTO kqf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tedi Paelat ena giu ai munena gado, “Bamoda tana mote maso pilipili tauvoiyedi maso bai aubaina kei doli natome lisimmo.” ");
INSERT INTO kqf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paelat i giuna gado, “Temi koi doli nawe bi emi waiḡake luvanemo ko etale.” Bi Diu babadidi mamedidi a giuna gado, “Tama mote ema waibada bai ima kenakena te lava kai peki.” ");
INSERT INTO kqf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bi Yesu bainewa sai pekina ba i gei giuwata bi bai i giugiuwena luvanemo mainana ya peki. ");
INSERT INTO kqf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mba ḡome te Paelat i valageta munaḡa ena animiyamo, bi i giu te Yesu a natome lisinemo bi i waitalayena gado, “Tam ba Diu lavedi edi ḡalibona, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Bi Yesu i waitalana gado, “Niga ba tam taumḡa em noḡota kwa giugiuwegu ee lava a giugiuwemna kwa giugiuwegu?” ");
INSERT INTO kqf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bi Paelat giu i waimunena gado, “Tam kunai noḡota te tagu Diu lavagu, ee? Niga ba tam em lava otidi bi pilipilisi edi babada a pani natomem tagu lisigumo. Tam bai gebona kuna voiye?” ");
INSERT INTO kqf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ḡome Yesu giu i waimunena gado, “Tagu egu waibada mote niga dobunemo e vai. Bamoda egu waibada niga dobunemo e vai, maso ba taukaiwatagu aubaigu ai ḡaviya te Diu babadidi nimedimo a kaikamaḡegu. Bi geḡa te, egu waibada ba dobu ḡesaunemo e vai.” ");
INSERT INTO kqf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kamaina bi Paelat i giuna gado, “Tam ba ḡalibona.” Bi Yesu giu i waimunena gado, “Tam kwa giugiu te tagu ḡalibona ba kuna giukauwa. Tagu niga dobunemo e yovo bi e tubuḡana ba giukauwa yà giuwata. Tedi mabai giukauwa a sibesibena ba kalinagu sa vaivaiye.” ");
INSERT INTO kqf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bi Paelat i waitalana gado, “Giukauwa banina ba bai?” Ḡome Paelat i potiyovo munaḡa lava lisidimo bi i giuwedina gado, “Tana mote bai gebona i voiye te tagu yà etale. ");
INSERT INTO kqf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bi geḡa te, temi emi vaivaimo ba Vawaitauli Soina sauginemo, biliwelokomo taumiya ḡemota yà kaikaikamaḡe. Temi ko ḡoyeḡoyena Diu edi Ḡalibona aubaimi yà kaikamaḡe, ee?” ");
INSERT INTO kqf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ḡome tedi a binau saḡena gado, “Geḡa, mote tana. Tama ka ḡoyeḡoyena Balabas kwa kaikamaḡe.” Balabas wala ḡaviya tauwaitubuna. ");
INSERT INTO kqf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bi Paelat ena tauwaiḡaviya i giuwedi te Yesu sa biti, kamaina bi tedi tana a biti. ");
INSERT INTO kqf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tauwaiḡaviya donadona a pipini bi Yesu kununemo a sako bi gala molemolewina ai kote. ");
INSERT INTO kqf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bi lisinemo ai velaumunaḡa bi a giugiuna gado, “Ebom, Diu edi ḡalibona.” Kamaina bi a launevakau. ");
INSERT INTO kqf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paelat i potiyovo munaḡa bi Diu a waiḡemotidina i giuwedina gado, “Yà kapotiyovo lisimimo te ko kita. Tagu yà giugiuwemi te konai wavuna ba lisinemo mote bai e banavi.” ");
INSERT INTO kqf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ḡome te Yesu kunuteiya waidonadonana bi gala molemolewina a waikotena i potiyovo, bi Paelat i giuwedina gado, “Lavana niga.” ");
INSERT INTO kqf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sauginemo Pilisi edi babada bi pali vanuwina tauyavena a kitakita ba a binauna gado, “Ku tupalatu, ku tupalatu.” Bi geḡa te, Paelat i giuwedina gado, “Temi ko vai nawe te ko tupalatu, banina tagu mote ena gebo bai e banavi.” ");
INSERT INTO kqf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bi geḡa te, Diu babadidi a laugayabagibagina gado, “Ema waiḡake ya kenakena te mba waiḡakena luvanemo tana kamaina te ya peki. Banina tana i giu munaḡe te tana ba Maimaituwa Natuna.” ");
INSERT INTO kqf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Laḡannemo Paelat niga giuna i vaivaiye ba i naila gulata. ");
INSERT INTO kqf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ḡome te Paelat i munaḡa vanuwa noponemo bi Yesu i waitalayena gado, “Tam dobu isana lavam?” Bi Yesu mote bai i giuwe. ");
INSERT INTO kqf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bi Paelat i giuna gado, “Bai aubaina egu giu mote ku waimune? Tam kuna sibe ee geḡa te tagu waibada lisigumo ya kenakena te yà kaikamaḡem ee yà tupalatum?” ");
INSERT INTO kqf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Bi Yesu giu i waimunena gado, “Em waibada dibunemo yà miyamiya, banina Maimaituwa i vitem. Bi aiyai lavana i pani natomeguna lisimmo ba tana gebo dididiga i voiye.” ");
INSERT INTO kqf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ḡome Paelat eta i tavutavu te maso Yesu i kaikamaḡe bi geḡa te, Diu lavedi a binabinauna gado, “Bamoda niga olotona kwa kaikamaḡe bi ya nawana ba Sisa mote tam imai tauyem. Banina, aiyai lavana ya giugiu te tana ḡalibona ba tana Sisa ya laulauyovoḡe.” ");
INSERT INTO kqf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sauginemo Paelat niga giudi i vaivaiyedi ba Yesu i waidoli te a potiyovo. Kamaina bi taulauetala ena animiyamo i miya. Mba gabuna sa waiisana Gasagasana Alemik kalinedimo sa waiisana Gabata. ");
INSERT INTO kqf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Suwalamodo balana muliḡa kaka Vawaitauli Soina ya tubuḡa. Bi Paelat Diu lavedi i giuwedina gado, “Emi ḡalibona naniga.” ");
INSERT INTO kqf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tedi a binauna gado, “Ku nawe tabunemo kwa tupalatu! Kwa tupalatu!” Bi Paelat i waitalayedina gado, “Gode, emi ḡalibona yà tupalatu, ee?” Bi pilisi edi babada giu ai munena gado, “Tama mote bamo ema ḡalibona ḡesau, kamaina Sisa taunaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bi etala mulinemo ba Paelat Diu lavedi nimedimo Yesu i sako te sa tupalatu. Kamaina bi tauwaiḡaviya Yesu ai doli. ");
INSERT INTO kqf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tana taunaḡa ena kolosi i avali bi i potiyovo te i nawa Kunukoukou gabunemo. Mba modomodona Alemik kalinedimo ba sa waiisana Golgota. ");
INSERT INTO kqf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ḡome Yesu kolosimo a tupalatu bi diyanemo ba lava labu vaitedi kota a tupalatudi. Lava ḡemota kataiyana yawaninemo bi ḡesauna ḡeniyana yawaninemo. ");
INSERT INTO kqf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paelat giugiu watiḡena i gilumina gado, “Nasalet Yesuna, Diu lavedi edi Ḡalibona.” Te kolosi modonemo a tutu waipatu. ");
INSERT INTO kqf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lava wapewapedi niga gilumina a iyevi, banina Yesu anitupalatuna gabuna ba mote manekemo bi malagai dididiga diyanemo. Gilumina ba Alemik, Latin bi Gulik kalinedimo. ");
INSERT INTO kqf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bi pilisi edi babada nuwedi i medi bi Paelat a giuwena gado, “Bai aubaina kuna gilumana gado, ‘Diu lavedi edi Ḡalibona?’ Tam maso kuna gilumana gado, ‘Niga lavana i giuna gado, Tagu taunana Diu lavedi edi Ḡalibona.’” ");
INSERT INTO kqf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ḡome te Paelat edi giu i waimunena gado, “Bai e gilugilumina ba kamaina e gilumi.” ");
INSERT INTO kqf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yesu kolosimo a tupalatu mulinemo ba tauwaiḡaviya 4 Yesu ena gala a legaudi bi a dailidi te dubu 4, bi ai legau ḡemoḡemota. Bi kota kwama lofalofana, noponemo anikote vaitena a vai. Niga kwamana ba mote popopona bi ḡauḡaulina. ");
INSERT INTO kqf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tedi a giuna gado, “Mote tama lisi bi ta koitiliye te aiyai ya vai.” Niga kauwina i tubuḡana ba gilugilumina wadubona i giugiuna luvanemo, “Tedi egu gala a dailidi bi a koitili te aiyai ya legaudi.” Taunana aubaina, tauwaiḡaviya niga kauwidi mai a voiyedi. ");
INSERT INTO kqf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu ena kolosi diyanemo taumoito ba Yesu tinana matasina, Kiliyopas mwanena Meli bi Meli Magadalin. ");
INSERT INTO kqf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Laḡannemo Yesu i kita te tinana bi ena tauwaikaiwatana i ḡoyeḡoye kauwena vaitena a moimoito ba tinana i giuwena gado, “Waivini, mba taunana natum.” ");
INSERT INTO kqf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bi kota ena tauwaikaiwatana i giuwena gado, “Niganana niga waivinina ba tinam.” Mba ḡome te ena tauwaikaiwatana tinana i waidoli nawe ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mba kauwidi mulidimo, Yesu i sibe te ena noya i waikovi bi bai gilugilumina wadubonemo i giugiuwena ya tubuḡana aubaina i giuna gado, “Tagu gadogu i magu.” ");
INSERT INTO kqf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ḡome ba waen waiḡolana dubina i kenakena. Kamaina bi waen anitaina ai dakwa bi kai isop lagana a vai te a kaiḡavi bi ai yoyo saḡe Yesu mudunemo. ");
INSERT INTO kqf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu waen waiḡolana i tego mulinemo ba i giuna gado, “Bai matabuna i kovi.” Ḡome iwana i taunoku bi aluwina Tamana i vite te i peki. ");
INSERT INTO kqf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bi mba laḡanna ba vononoḡa laḡanna bi bokinamai ba Diu lavedi edi Waiyawasi Laḡanna laukaina. Banina, Diu lavedi mote sima ḡoyeḡoye te edi Waiyawasi Laḡannemo tubuḡa kolosi modonemo sima dawe. Taunana aubaina, Paelat ai baḡa te kaḡedi sa doukotodi bi sa sivu yovoḡedi. ");
INSERT INTO kqf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kamaina bi tauwaiḡaviya ḡome olooloto labu Yesu vaitena a tupatupalatudina kaḡedi a gei doukotodi. ");
INSERT INTO kqf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bi Yesu a kitakita ba tana kaikana i peki, taunana aubaina kaḡena mote a doukotodi. ");
INSERT INTO kqf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bi geḡa te, tauwaiḡaviya ḡemota Yesu giligilina alaiyamo i gwaligwali, ba maḡemota kwasina bi gauba i pusuwali. ");
INSERT INTO kqf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bi oloto niga kauwina taukitana ba i giu te niga ba giukauwa. Tana bai i kitakitana ba i sibe te giukauwa ya giugiuwe, taunana aubaina temi koi sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Niga kauwidi a tubuḡana ba gilugilumina wadubonemo bai a giugiuwedina mainana a tubuḡa. Gilugilumina wadubonemo i giuna gado, “Tana mote bamo siliḡena ḡemota i nuwakoto.” ");
INSERT INTO kqf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bi gilugilumina wadubona ḡesaunenemo kota i giuna gado, “Bi tana giligilina gwaligwalina kaka lava sa kita.” ");
INSERT INTO kqf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mba mulinemo ba Alimatiya olotona isana Diyousep, Paelat i waibaḡa te Yesu tubuḡina ya vai nawe. Bi Diyousep ba Yesu ena tauwaikaiwatana ḡesauna bi tana kandavonemo i miyamiya, banina Diu lavedi edi babada i nainailedi. Paelat i waianine te tubuḡa i avali nawe. ");
INSERT INTO kqf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas kota bona panepanedi, maela bi aloye vaitena vitavitalena, 30 kiloglem luvana i legaudi te Diyousep vaitena a nawa. Nikodimas tana taunana dolinemo dudubalaḡa i nawa Yesu lisinemo. ");
INSERT INTO kqf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bi oloolotodi labu Yesu tubuḡina a vai te bona panepanedimo tubuḡina a laipanepane bi gala potipotidimo a suma, Diu lavedi edi laudobo vaivaina luvanemo. ");
INSERT INTO kqf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu bamo a tupatupalatuna diyanemo ba vokai wadiwadidi. Bi ḡome ba tauyewa valivaliuna bi mba tauyewanemo mote bamo taubeu ḡesauna a sako. ");
INSERT INTO kqf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bi Diu lavedi edi Waiyawasi Laḡanna vokaukauwina aubaina te Yesu tubuḡina mba tauyewanemo a sako, banina manekina mote i lofa. ");
INSERT INTO kqf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande oleolelinemo dobu mawaidudubalina, Meli Magdalin i nawa tauyewamo. Ḡome tauyewa mataetina ḡakimina ḡimaḡima kamaḡena i kita. ");
INSERT INTO kqf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mba ḡome te waivini i velau i nawa Saimon Pita bi Yesu ena tauwaikaiwatana ḡemota i ḡoyeḡoye kauwena lisidimo bi i giuna gado, “Tauyewamo Bada taubeuna a kaikamaḡe te bamo ḡome a sakona, tama mote ke sibe.” ");
INSERT INTO kqf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kamaina bi Pita bi Yesu ena tauwaikaiwatana ḡesauna vaitena a nawa tauyewamo. ");
INSERT INTO kqf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tedi labuḡidi a velavelau bi ena tauwaikaiwatana ḡesauna i velau gulata te Pita i gose bi tauyewamo i gei tava. ");
INSERT INTO kqf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tana i laudulu bi tauyewa nopona i kita te galaḡa a kenakena bi mote i sola nawa. ");
INSERT INTO kqf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita muliḡa i tava te i sola nawa tauyewamo, bi i kita te galaḡa a kenakena. ");
INSERT INTO kqf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bi kota i kita te Yesu kununa anisumana galana ba taunemo i nuwanoku te tabunemo i kenakena. ");
INSERT INTO kqf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bi Yesu ena tauwaikaiwatana ḡesauna i geigei tavana kota i sola nawa tauyewamo, bi i kita te i waisumaḡa. ");
INSERT INTO kqf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bi gilugilumina wadubonemo ya giugiu te Yesu kaka pekimo ya kenamoito. Bi tedi mba giugiuna mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kamaina bi tedi a munaḡa bamo ḡome a miyamiyanemo. ");
INSERT INTO kqf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bi Meli ba tauyewa mataetinemo i moito bi i ḡabaḡaba. Tana maḡabaḡabana i laudulu bi i waikita nawa tauyewa noponemo. ");
INSERT INTO kqf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bi bamo Yesu taubena a waikenanemo, aneya labu edi gala potipotidi i kitedi a miyamiya. Ḡemota kununa yawaninemo bi ḡesauna kaḡena yawaninemo. ");
INSERT INTO kqf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bi aneya Meli ai talayena gado, “Waivini, tam bai kwa ḡabeḡabe?” Bi tana i giuwedina gado, “Egu Bada taubeuna a nawe bi mote yà sibe te bamo ḡome a sako.” ");
INSERT INTO kqf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mba ḡome waivini i tautauvitale ba Yesu i kita i moimoito, bi mote i kitaḡone te mba Yesu. ");
INSERT INTO kqf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu i waitalana gado, “Waivini, bai aubaina kwa ḡabaḡaba, bi aiyai kwa tavutavuḡe?” Bi tana i wainoḡota te bena taubayau, taunana aubaina i giuna gado, “Goma, bamoda Yesu tubuḡina kuna vaina ba kwa giuwegu te bamo ḡome kuna sako bi yà nawa te yà avali natome.” ");
INSERT INTO kqf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu i giuna gado, “Meli!” Bi tana i tauvitale bi i ḡabana gado, “Laboni. Niga giuna Alemik kalinedimo banina ba Tauwailovelove.” ");
INSERT INTO kqf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu i giuna gado, “Tam mote kuma taukonigu, banina tagu yaḡolo mote e saḡa e nawa Tamagu lisinemo. Bi kwa nawa valevaletigu kwa giuwedi te tagu yà munamunḡana Tamagu bi Tamemi, egu Maimaituwa bi emi Maimaituwa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meli Magdalin giu i vai nawe Yesu ena tauwaikaiwatana lisidimo bi i giuwedina gado, “Tagu Bada e kita.” Kamaina bi Bada bai giudi i giugiuwena taudidi tedi i giuvitedi. ");
INSERT INTO kqf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mba Sandena aubiganemo, Yesu ena tauwaikaiwatana vanuwa noponemo ai ḡemotidi bi mataeta a gudu ḡavute, banina Diu babadidi a nailedi. Bi ḡome a miyamiya ba i waimaḡemoti te Yesu poudimo i laumaḡata bi i giuwedina gado, “Nuwauba lisimimo.” ");
INSERT INTO kqf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mba giuna mulinemo ba nimana bi giligilina i wailovedi. Bi laḡannemo ena tauwaikaiwatana Bada a kitakita ba a yasisi gulata. ");
INSERT INTO kqf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kota Yesu i giu munaḡana gado, “Nuwauba lisimimo. Tagu Tamagu i giukamaḡegu bi tagu kota mainana temi yà giugiukamaḡemi.” ");
INSERT INTO kqf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bi ḡome te lisidimo yawasina i bunanai kamaḡe bi i giuwedina gado, “Aluwa Waiyawa ko vai! ");
INSERT INTO kqf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bamoda lava edi gebogebo ko noḡoti kamaḡedina, ba Maimaituwa edi gebogebo ya noḡoti kamaḡedi. Bi bamoda temi edi gebogebo mote koma noḡoti kamaḡedi ba Maimaituwa mote edi gebogebo ima noḡoti kamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Bi laḡannemo Yesu i tavatava ena tauwaikaiwatana 12 lisidimo, ba nopodimo ḡemota isana Tomas (sa waiisana Didimas) tana mote ḡome. ");
INSERT INTO kqf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kamaina bi ena tauwaikaiwatana ḡesaudi Tomas a giuwena gado, “Tama Bada ke kita!” Bi tana i giuna gado, “Mm, tagu mote yàmai sumaḡa bi dolina tutu leleidi nimanemo yà kitedi, nimagalagumo yà taukonidi bi giligilina gwaligwalina leleina yà taukoni kaka bi yài sumaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wiki ḡemota i kovi mulinemo ba ena tauwaikaiwatana kota a tava vanuwemo ai ḡemoti munaḡedi. Bi Tomas ba vaitena ḡome. Avena te mataeta gudugudu ḡavutina bi yaḡolo te Yesu poudimo i laumaḡata bi i giuwedina gado, “Nuwauba lisimimo.” ");
INSERT INTO kqf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ḡome Yesu Tomas i giuwena gado, “Nimagalammo nimatabagu kwa taukoni bi nimagu kwa kitedi. Bi nimam kwa tuḡu te giligiligu kwa taukoni. Tam nuwakulukuluva kwa kaisako bi kwai sumaḡa.” ");
INSERT INTO kqf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kamaina bi Tomas i giuna gado, “Tam egu Bada bi egu Maimaituwa.” ");
INSERT INTO kqf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kamaina bi Yesu i giuna gado, “Tam kunai sumaḡana banina kuna kitagu. Bi tedi mabai mote a kitagu bi sa waisumaḡana ba kakavisuvisudi.” ");
INSERT INTO kqf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu anisove matailidi wapewapedi ḡesaudi ena tauwaikaiwatana matedimo i voivoiyedina ba niga bukanemo mote a gilumidi. ");
INSERT INTO kqf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bi niga taudidi a gilumidina ba temi kamaina te Yesu koi sumaḡe te tana taunana Buyobuyona, Maimaituwa Natuna. Bi temi koi sumaḡena ba ena ḡailisimo kaka yawasana ilailala ko banavi. ");
INSERT INTO kqf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Laḡan visa a kovi mulidimo ba Yesu Galili topana diyanemo, ena tauwaikaiwatana lisidimo i laumaḡata munaḡa. Niga kauwina i tubuḡana ba niga mainana. ");
INSERT INTO kqf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yesu ena tauwaikaiwatana Galili topana diyanemo ai ḡemotidina ba: Saimon Pita, Tomas sa waiisana Didimas, Nataniyel ba Keina lavana, bi Keina malagaina ba Galili plovins noponemo, Diyebedi natunatuna bi ena tauwaikaiwatana labu vaitedi. ");
INSERT INTO kqf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Bi Saimon Pita ena lava i giuwedina gado, “Tagu gomo aubaina yà nawanawa.” Bi tedi a giuwena gado, “Tama vaitem ta nawa.” Kamaina bi edi wagamo a gelu, bi tedi mba dudubalinemo mote bamo iyana a konedi. ");
INSERT INTO kqf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bi laḡan sakosako balana ba Yesu nisa diyanemo i laumoito kamaḡe, bi ena tauwaikaiwatana mote tana a kitaḡone. ");
INSERT INTO kqf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu ena lava lisidimo i binauna gado, “Egu lava, temi iyana kona konedi ee geḡa?” Tedi giu ai munena gado, “Geḡa, mote iyana ke konedi.” ");
INSERT INTO kqf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kamaina bi i giuwedina gado, “Emi gomo kataiyemi yawaninaḡa ko pwalaḡe nawe kaka iyana ko konedi.” Bi laḡannemo mai a voivoiye ba mote ḡemoḡemotina te maso gomo a solu saḡe wagamo. Banina tedi iyana wapewapedi a konedi. ");
INSERT INTO kqf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ḡome tauwaikaiwatana ḡesauna Yesu i ḡoyeḡoye kauwena Pita i giuwena gado, “Noi ba Bada.” Laḡannemo Saimon Pita i vaiye te noi ba Bada, ba ena kwama dabanemo anikote i kote munaḡe bi i laupoti topamo bi i nawa diyadiyamo. ");
INSERT INTO kqf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bi Yesu ena tauwaikaiwatana ḡesaudi ba wagamo. Tedi waga a ḡiu bi iyana gomona wanawanavuna a solu nawena diyadiyamo, banina mba ḡome te gelemo ba mote i lofa, 90 mita luvana. ");
INSERT INTO kqf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Laḡannemo waga a potipotiyovo kamaḡe ba tedi kai mafuwalinemo iyana kalakalatidi bi buledi vaitedi a kitedi. ");
INSERT INTO kqf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu i giuwedina gado, “Temi iyana noi taunana kona konekonedina ḡesaudi ko natomedi.” ");
INSERT INTO kqf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kamaina bi Saimon Pita i kaisaḡa wagamo, gomomo i kabi te i solu saḡe gelemo. Bi iyana nananakidi ba wapedi 153, bi avena te iyana a wapa gulata bi gomo mote i nuwalisi. ");
INSERT INTO kqf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu i giuwedina gado, “Temi ko nato bi ko kani.” Bamo mote tauwaikaiwatana ḡesau Yesu i waitalaye gado, “Tam aiyai?” Tedi a sibe otiḡe te tana ba Bada. ");
INSERT INTO kqf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu buledi i vai bi ena tauwaikaiwatana i vitedi, bi kota iyana i vai te i vitedi. ");
INSERT INTO kqf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Bi Yesu pekimo i kenamoito mulinemo, niga taunana ba sauga waifaionina tana ena tauwaikaiwatana lisidimo i laumaḡata. ");
INSERT INTO kqf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Laḡannemo a kanikani kovi ba Yesu, Saimon Pita i waitalayena gado, “Saimon, Diyon natuna, tam kwa ḡoyeḡoye gulateguna kaka niga em lavedi, ee?” Pita Yesu ena giu i waimunena gado, “Emaso, bena kuna sibe te tagu yà ḡoyeḡoyem.” Kamaina bi Yesu i giuna gado, “Egu sipu kwai kani bagibagidi.” ");
INSERT INTO kqf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu i giu munaḡana gado, “Saimon, Diyon natuna, tam kwa ḡoyeḡoyegu, ee?” Ḡome Pita i giuna gado, “Emaso, Bada, tam kuna sibe.” Kamaina bi Yesu i giuna gado, “Tam egu sipu kwa labe kauwedi.” ");
INSERT INTO kqf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu waitala waifaionina, Saimon lisinemo i voiyena gado, “Saimon, Diyon natuna tam kwa ḡoyeḡoyegu, ee?” Yesu waitala i waifaioni, taunana aubaina te Pita nuwana i gebo. Kamaina bi Saimon i giuna gado, “Bada, bai matabuna kuna sibe te tagu yà ḡoyeḡoyem.” Yesu giu i waimunena gado, “Egu sipu kwai kani bagibagidi. ");
INSERT INTO kqf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tagu giukauwemo yà giugiuwem, tam mavalivaliummo ba kunai gala bi em nuwalauwataḡa ku nawanawa. Bi laḡannemo kuna magulana ba nimam kwa tuḡudi te lava ḡesauna yai galam, nimammo ya kabi bi yai dolim te mote aninawa ku ḡoyeḡoyena maiḡa ya nawem.” ");
INSERT INTO kqf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu, Pita lisinemo niga mainana i giuna ba bainewa Pita ya peki bi Maimaituwa namala ya vaina taunana i giugiuwata. Kamaina bi Yesu Pita i giuwena gado, “Ku kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ḡome Pita i tauvitale bi i kita te tauwaikaiwatana Yesu i ḡoyeḡoye kauwena ba i kaikaiwatedi. Tana taunana Vawaitauli Soinemo Yesu diyanemo i miyamiyana, iwana i taunawe Yesu lisinemo bi i waitalayena gado, “Bada, tam aiyai ya sakoyovoḡem?” ");
INSERT INTO kqf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sauginemo Pita, noi olotona i kitakita ba i waitalana gado, “Bada, bi noi olotona ba bainewa?” ");
INSERT INTO kqf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu giu i waimunena gado, “Bamoda tagu yà ḡoyena ba tana ya miyamiya bi tagu yà nato munaḡa. Bi bai aubaina kwa ḡoyeḡoyena kwa sibe? Bi tam ba kamaina te kwa kaiwatagu.” ");
INSERT INTO kqf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kamaina bi Yesu ena tauwaikaiwatana nopodimo niga giuna i dabalala te bena mba tauwaikaiwatanina mote ima peki. Bi geḡa te, Yesu mote i giu te tana mote ima peki bi i giuna gado, “Bamoda tagu yà ḡoyena ba tana ya miyamiya bi yà nato munaḡa. Bi bai aubaina kwa ḡoyeḡoyena kwa sibe?” ");
INSERT INTO kqf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Niga tauwaikaiwatanina taunana niga kauwidi i giuwatedi, bi kota i gilumidi. Bi ke sibe te bai ya giugiuwena ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bi Yesu kauwa wapewapedi ḡesaudi kota i voiyedi. Bamoda kauwidi matabudi bi a gilumidi ba yà noḡonoḡoti te bukedi maso dobu ai wanavu. ");
INSERT INTO kqf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Aisii, Tiopilas! Egu buka dolinemo e gilugilumina, ba Yesu ena noya bi ena wailovelove i wai waitubuna e gilumiwata. ");
INSERT INTO kqf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Bi noya wapewapedi i voivoiyedina eete i saḡe i nawe malamo. Muliḡa kaka i nawana malamo bi giugiukamaḡedi i vinevinedina Aluwa Waiyawemo i giu vavasaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu ena wai nuwatoitoi bi ena peki mulinemo giugiukamaḡedi lisidimo kauwa wapewapedimo i laumaḡata te tedi sa sibe te tana i kenamoito munaḡa. Laḡan 40 nopodimo laḡan wapawapa i laumaḡata bi Maimaituwa ena waibada lisidimo i giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bi laḡan ḡemota tana giugiukamaḡedi vaitedi ai ḡemotidi bi i giuvavasaḡedina gado, “Mote Yelusalem koma gose bi koi laba te Tamagu Aluwa Waiyawa ya giukamaḡe yovoḡe maibena dolinemo i giugiuwapana mainana. Tagu niga puyona dolinemo e gei giuwemi. ");
INSERT INTO kqf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Diyon lava gaubemo i ka buludi bi laḡan ḡotona temi Aluwa Waiyawamo ya ka bulumi.” ");
INSERT INTO kqf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Laḡannemo giugiukamaḡedi Yesu vaitena ai ḡemoti munaḡedi ba Yesu ai talayena gado, “Bada, tam niga laḡannemo Islael lavedi waibada kwa vite munaḡedi, ee?” ");
INSERT INTO kqf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bi i giuwedina gado, “Tamagu taunaḡa waibadana lisinemo te mba laḡandi i vinedi bi temi mote emi noya bai te ko sibe. ");
INSERT INTO kqf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bi laḡanemo Aluwa Waiyawa ya yovona lisimimo laḡannemo, kaka ḡailisi ko vai te giugu visuvisuna ko giuwata, Yelusalemmo, Diudiya, Sameliya matabuna nopodiḡa bi dobu isuna te isuna.” ");
INSERT INTO kqf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Laḡannemo Yesu ena giu i waikovi mulinemo a kitakita bi Maimaituwa i kailageti saḡe bi giyou i suma te mote a kita munaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tedi ai kitawata i saḡa i nawanawa ba olooloto labu edi gala potipotidi, ai maḡemoti te diyedimo a moito kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bi a giuna gado, “Temi mani Galili bai aubaina niga ḡome kona moito bi galewa ko kitakita? Niga Yesuna niganana lisimimo Maimaituwa i vai nawe galewemo, tana bainewa kona kita bi i saḡa i nawanawana, mainana kota ya yovo munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ḡome oya isana Olip, a gose bi a munaḡa Yelusalemmo. Niga oyana Yelusalem diyanemo, manekina mote i lofa. ");
INSERT INTO kqf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bi laḡannemo a munaḡa taun ba vanuwa a miyamiyanemo a valageta bi noke a saḡa dabanemo. Bi lava ḡome a miyamiyana ba Pita, Diyon, Diyemes, Endulu, Filip, Tomas, Batolomiu, Met, Diyemes tamana ba Alupias. Bi Saimon a wai isana Selot bi Diudas tamana ba Diyemes. ");
INSERT INTO kqf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Niga lavedi laḡan matabuna ai ḡemotidi bi a laulaupali. Nopodimo ba Yesu tasitasina, tinana Meli bi waivini ḡesaudi vaitedi. ");
INSERT INTO kqf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bi mba laḡannemo tauwaisumaḡa wapedi 120 a wai bolu poudimo Pita i miya moito bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Egu lava waisumeḡimi, wala nove Aluwa Waiyawa Deivida i waietadoliye te i giuwatana gado, lava ḡemota kaka Yesu ya kaisoluḡe. Bi niganana gilugilumina wadubonemo bai i giugiuwena banina i tubuḡa. Bi dolinemo Yesu lavana i vine te tada vaitena te noyanoya. Niga lavana Diudas, tana Yesu taupanina i wai etadoliyedi te Yesu a kaididi.” ");
INSERT INTO kqf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Diudas Yesu kaisoluna aubaina mane a vite bi manenemo doḡa i kune. Bi ḡome tana kununaḡa i kuluva bi bwagana i wai katisali bi tinaḡena i dabalala te i peki. ");
INSERT INTO kqf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bi lava matabudi Yelusalem noponemo niga giuna a vaiye. Taunana aubaina niga doḡana kalinedimo ai isana Akeldama. Mba banina ba kwasina doḡa i vitale). ");
INSERT INTO kqf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita i giuna gado, “Niga kauwina Deivida ena buka Sale noponemo, i gilugilumina mainana i tubuḡa. Ḡome i giuna gado, ‘Kaka ena vanuwa ya kavakava, bi mote aiyai noponemo ima miya.’ Bi kota, ‘Lava ḡesau ena waibada gabuna ya vai.’ ");
INSERT INTO kqf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Taunana aubaina i visu te oloto ḡesau ta vine te Bada Yesu ena kenamoito vaitena ta giu nawe. Niga olotona maso ba Yesu vaitena te nawanawa ḡemota nove Diyon ena waibulu laḡannemo eete Maimaituwa Yesu i kailageti saḡe malamo.” ");
INSERT INTO kqf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kamaina te lava labu a legaudi: Diyousep a wai isana Basabas bi isana ḡesauna Diyastas bi Mataiyas. ");
INSERT INTO kqf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bi ḡome a laupalina gado, “Bada, tam lava matabudi nopodi tausibedi. Kamaina te kwai lovemai te niga lavedi labu bi bamo taunana kuna vine, ");
INSERT INTO kqf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te giugiukamaḡedi vaitena sa noya. Banina Diudas niga noyana i gose kamaḡe bi i nawa ena gabumo.” ");
INSERT INTO kqf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kamaina te ḡakima labu mododimo mba lavedi isedi a gilumidi bi ledu noponemo a sivudi. Bi lava ḡemota i wai matapota bi ledu noponemo i kabi yovo bi Mataiyas isana i kulamatai. Kamaina te Mataiyas giugiukamaḡedi 11 nopodimo i saḡa. ");
INSERT INTO kqf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Laḡannemo Pentikost soina laḡanina i tava, tauwaisumaḡa matabudi gabu ḡemota ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bi i wai maḡemoti te vuvusa malamo bi i yovona maibena kaibitibiti daguguna bi vanuwa nopona i wai wanavu. ");
INSERT INTO kqf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ḡome mwali a kitana maibena kai menamenana ḡemoḡemotaḡa dabediḡa i wai yamone. ");
INSERT INTO kqf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bi matabudi Aluwa Waiyawa nopodi i wai wanavudi bi kalina ḡesaudi gagaliyedi ai tubu, Aluwa Waiyawa i vitevitedina mainana a gagali. ");
INSERT INTO kqf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ḡome ba Diu lavedi Maimaituwa taulauduneyena dobu matabuna noponemo a tava Yelusalemmo a miyamiya. ");
INSERT INTO kqf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bi laḡannemo kalina a vaivaiye ba a tava ai ḡemotidi bi a vaiye te tauwaikaiwatana kalinedimo a giugiu ba a nuwalaḡalaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bi tedi tauwaikaiwatana a soveyedi bi a giuna gado, “Niga lavedi ba Galili dobuna lavedi, ");
INSERT INTO kqf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","bi bainewa te ta vaivaiyedi ḡemoḡemotaḡa kalinademo sa giugiu? ");
INSERT INTO kqf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tada matabuda dobu tabudiḡa te tava: Patiya, Midiya, Elam, Mesapotomiya lavedi, Diudiya, Kapadosiya, Pontus, Eisiya, ");
INSERT INTO kqf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piligiya, Pamfilia, Idip bi dobu ḡesaudi Libiya noponemo Sailin diyanemo. Bi ḡesauda ba tautavatava Loumḡa te tava. ");
INSERT INTO kqf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Eteni lavedi bi Diu, niganana Diu lavedi edi laudune ta kaikaiwatedi). Bi tada ḡesauda ba Kulitiḡa bi Alebiyaḡa te tava. Bi ta vaivaiye te ḡemoḡemotaḡa kalinademo Maimaituwa kauwa nananakidi i voivoiyedina sa giugiuwedi.” ");
INSERT INTO kqf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tedi a sove bi nuwedi i laḡalaḡa bi ai giugiuna gado, “Niga kauwina banina bai?” ");
INSERT INTO kqf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bi lava ḡesaudi ai gadolosedi bi a giuna gado, “Niga lavedi waen a tego gulate te a bu'uwa bi sa giugiu yabayababa.” ");
INSERT INTO kqf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ḡome Pita bi giugiukamaḡedi 11 vaitedi a moito bi Pita kalinana dididiginemo lava i giuwedina gado, “Temi Diu bi ma baibaimiḡa Yelusalemmo ko miyamiyana, koi beyavaiya kauwa bi bai yà giuwemi! ");
INSERT INTO kqf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Niga lavedi mote a tego bu'uwa mai temi ko noḡonoḡotina banina niganana ba 9-na okoloki olaolala. ");
INSERT INTO kqf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Niga ba buka wadubonemo taugiuwatana Diyouwelo bai i giugiuwena niganana ya tubutubuḡa. Diyouwelo niga mainana i giu, ");
INSERT INTO kqf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ḡome Maimaituwa i giuna gado: Laḡan damodimo tagu kaka egu Aluwa yà ḡini kamaḡe lava matabudi lisidimo. Bi natunatumi oloolotodi bi waiwaivinidi tedi kaka taugiuwatana sa tubuḡa bi giugu sa lauguguyae. Bi emi olooloto valivaliudi kaka wailove sa kitedi. Bi emi magumagula lauboni sa kitedi. ");
INSERT INTO kqf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mba laḡandimo egu taupaula oloolotodi bi waiwaivinidi matabudi lisidimo egu Aluwa yà ḡini kamaḡe, te tedi taugiuwatana sa tubuḡa bi giugu sa lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bi tagu mataila galewemo yà voiyedi bi dobumo kwasina bi kaisikei baduwalina. ");
INSERT INTO kqf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Suwala yai dudubala bi nawalai ya sabana maibena kwasina bi muliḡa kaka Bada ena laḡan dididiga ya tava. ");
INSERT INTO kqf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tedi mabai Bada isanemo sai baḡana ba matabudi sa yawasana.’ ");
INSERT INTO kqf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Islael lavemi, niga giudi ko vaiyedi: Maimaituwa Nasalet Yesuna, ḡailisi i vite te kauwa nananakidi bi mataila i voivoiyedi, mba Maimaituwa i wai lovemi te temi Yesu ko sibe. ");
INSERT INTO kqf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bi wala Maimaituwa ena ogatala i voivoiyena luvanemo, temi gebogebo lavedi nimedimo kona sako te kolosimo kona tupalatu te i peki. ");
INSERT INTO kqf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bi Maimaituwa Yesu lisinemo peki tuniyavina bi nuwaboya i kaikamaḡe bi i ka kenamoito munaḡe. Banina peki mote ḡemoḡemotina te maso Yesu i kaididi. ");
INSERT INTO kqf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Banina Deivida Yesu niga mainana i gei giuwata, ‘Bada Maimaituwa e kita laḡan matabuna ya waidoligu. Tana tagu vaitegu aubaina te egu ḡaviya mote yàma nailedi. ");
INSERT INTO kqf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Taunana aubaina tagu yài nuwavisu bi mayasisigu yà sale. Bi avena te yà peki, bi yà noḡonoḡoti te tam tubuḡigu kwa labe kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bi Maimaituwa, tam mote pekipekidi edi gabumo kuma gosegu, bi kota em taupaula waiyawa tubuḡina mote kuma kita kamaḡe ima bova. ");
INSERT INTO kqf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tam yawasana kunai lovegu te yà miya nonoḡa. Tam vaitegu aubaina te nopogu yasisi i wanavu.’ ");
INSERT INTO kqf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Egu lava, eda magula ḡalibona Deivida ena giu kamaina te yà giu otiḡemi. Deivida i peki te a dobo bi kokowagina niganana niga ḡome ya kenakena. ");
INSERT INTO kqf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tana taugiuwatana aubaina te i sibe te ena dam noponemo kaka Maimaituwa ena waiguyau lava ḡemota ya vite, banina Maimaituwa i giuwapa te mainana ya voiye. ");
INSERT INTO kqf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deivida laḡan muliḡa bai ya tubuḡana i gei giuwata, te Keliso ya kenamoito munaḡa. Bi tana mote pekipekidi edi gabumo ima gose bi tubuḡina ima bova. ");
INSERT INTO kqf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Tama matabumai matamaimo ke kita te Maimaituwa niga Yesuna pekimo i ka kenamoito munaḡa, ");
INSERT INTO kqf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","bi ena ḡailisimo i kailageti saḡe te kataiyanemo i waimiyeni. Ḡome tamana Aluwa Waiyawa i vite, dolinemo i giugiuwapana mainana. Bi niganana Yesu Aluwa Waiyawa tama lisimaimo i ḡini kamaḡe, mba taunana niganana ko kitakita bi ko vaivaiye. ");
INSERT INTO kqf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bi Deivida yaḡolo mote i nawa malamo bi tana Yesu niga mainana i gei giuwata, ‘Maimaituwa egu Bada i giuwe: Kataiyagumo ku miya ");
INSERT INTO kqf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kamaina eete tagu em ḡaviya yà natomedi bi kaḡem dibunemo yài dubudi maibena panibulu kaḡem ani lauyasayasaḡina.’ ");
INSERT INTO kqf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Taunana aubaina Islael lavemi e ḡoe te maso matabumi kona sibe kauwe te niga Yesuna kona tupatupalatuna, Maimaituwa i voiye te tana taunana Keliso bi Bada.” ");
INSERT INTO kqf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Laḡannemo lava Pita ena giu a vaivaiye ba, nuwedi i kalati. Bi Pita bi giugiukamaḡedi ḡesaudi a giuwedina gado, “Ema lava bai ka voiye?” ");
INSERT INTO kqf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bi Pita i giuwedina gado, “Temi ḡemoḡemotaḡa emi gebogebo ko kuvesidi bi Maimaituwa lisinemo ko nato. Bi Yesu Vinevinena isanemo ko bulu, te mba mataila te Maimaituwa emi gebogebo i noḡotikamaḡedi. Bi puyo Aluwa Waiyawa ko vai. ");
INSERT INTO kqf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Banina Maimaituwa i giuwapemi te mai ya voiye. Niga puyona ba temi bi natunatumi vaitedi aubaimi. Bi kota lava matabudi manekaḡa mabaibaidiḡa Bada eda Maimaituwa ya yogedina.” ");
INSERT INTO kqf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bi Pita giu wapewapedi ḡesaudi i tainuwataudi bi i giu vavasaḡedina gado, “Maimaituwa koi anine te yai yawasanimi bi mote niga kimtina lavedi edi yawasana gebogebodi edi kovoḡa vaitedi koma vai.” ");
INSERT INTO kqf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tedi mabai ḡome Pita ena giu a vaivaina, taudidi a bulu. Mba laḡannemo lava wapana male 3 tausan edi lava waisumeḡidi nopodimo a saḡa. ");
INSERT INTO kqf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bi laḡan matabuna giugiukamaḡedi edi wailovelove a vaivaiyedi, a kanikani ḡemota, a tulituliya bi palimo a waiḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bi matabudi nopodi naila bi vivila i wanavu bi kota giugiukamaḡedi anisove kauwidi bi mataila wapewapedi a voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bi tauwaisumaḡa edi ḡonaḡona gabu ḡemota ai ḡemotidi te matabudi aubaidi. ");
INSERT INTO kqf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tedi doḡa bi ḡonaḡona a kuneyedi bi mane a legaudi bi edi lava bai a malumaluwabina a vitevitedi. ");
INSERT INTO kqf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bi laḡan matabuna a wai ḡemotidi pali vanuwinemo a laulaudune bi edi vanuwa nopodiḡa ma nuwavisudi nuwedi ḡemota edi lava vaitedi buledi a kivi bi a kanikani ḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bi tedi Maimaituwa a kasaḡesaḡe bi lava matabudi nuwedi a solusoludi. Bi laḡan matabuna Bada lava ḡesaudi i wai yawasanidi bi i saḡesaḡedi edi lava nopodimo. ");
INSERT INTO kqf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Laḡan ḡemota aubigamo suwala 3 okoloki, Pita bi Diyon a saḡa a nawanawana pali vanuwinemo laupali aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kamaina bi oloto ḡemota kaḡena nuwakududi mai i tubuḡaye a avali tavaite. Bi pali vanuwina mataetinemo, sawai isana, “Mataeta mulemulelena.” Ḡome aimiyeni. Tana mba ḡome laḡan matabuna aimiyeni bi i miyamiya bi mabai pali vanuwinemo a saḡa a nawanawana lisidimo mane i wai waigigimane. ");
INSERT INTO kqf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kamaina bi i kita te Pita bi Diyon ḡotona te maso a valageta pali vanuwina noponemo bi tana lisidimo mane i wai gigimane gado, “Aee, mane ko vitegu.” ");
INSERT INTO kqf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ḡome Pita bi Diyon tana a kitadidi bi Pita oloto i giuwena gado, “Kwa kitamai!” ");
INSERT INTO kqf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kamaina bi, oloto tedi i kitedi bi i wai noḡotana bena kage mane tana sa vite. ");
INSERT INTO kqf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bi Pita i giuwena gado, “Tagu lisigumo mane geḡa. Bi bai lisigumo taunana yà vitem: Nasalet Yesuna Vinevinena isanemo: Kwa moito bi kwa nawa!” ");
INSERT INTO kqf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kamaina bi Pita oloto nimana kataiyanemo i kabi bi i solu waimoito. Bi maḡemota oloto kaḡe matabiwana bi kaḡe iwakiduna nuwakududi a didimana. ");
INSERT INTO kqf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tana kaḡenemo i moito makai bi nawa i waitubu. Kamaina bi tana vaitena a nawa pali vanuwina ganakukuna noponemo bi ḡome tana ganakuku noponaḡa i nawa bi i wai laulaupoti bi Maimaituwa i kaka saḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bi lava matabudi mba olotona a kita i nawa bi Maimaituwa i kaka saḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ḡome tedi a kitaḡone te tana ba tauwaigigimana laḡan matabuna pali vanuwina mataetinemo i miyamiya, mba mataetina a wai isana “Mataeta Mulemulelena.” Bi lava matabudi a tagugu bi a sove te bai lisinemo i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Laḡannemo tauwaigigimana Pita bi Diyon i kaidididi bi a moimoito, ḡome lava matabudi a sove gulata bi a velau lisidimo gabu isana Solomon ena yoveyovemo ai ḡemotidi. ");
INSERT INTO kqf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Laḡannemo Pita mba mainana i kitekitedi ba i giuwedina gado, “Islael lavemi, bai aubaina ko sovesoveye bi ko kitakitamai te bena kage tama ema ḡailisimo ee ema kauwa visuvisuna niga olotona i voiye te kaḡena i didimana? ");
INSERT INTO kqf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Geḡa Maimaituwa, wala tamatamada Eiblaḡam, Aisik bi Deikap a wai sumaḡena, tana namalina ena taupaula Yesu i vite. Niga Yesuna temi konai anine bi ena ḡaviya nimedimo kona sako te maso ai peki, avena te Paelat i ḡoeḡoe te maso i giukamaḡe i nawa bi temi kona lauyaviyavi. ");
INSERT INTO kqf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tana lava visuvisuna bi didimanina bi temi kona giuvavasaḡa te aubaimi Paelat, lava tauwaipekidi i kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Temi yawasana tautavaitena konai peki bi geḡa te Maimaituwa pekimo i wai yawasani. Bi tama niga kauwina matamaimo ke kita. ");
INSERT INTO kqf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Bi niga olotona matabumi ko kitakita bi ko sibesibe, tama ema waisumaḡa Yesu lisinemo aubaina, Yesu isanemo i yawasana. Banina tama Yesu ena ḡailisi kei sumaḡe aubaina te niga olotona i yawasana bi niganana matemimo ko kitakita. ");
INSERT INTO kqf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bi niganana egu lava, e sibe te temi emi babada vaitedi bu'uwa kona voiye bi Vinevinena konai peki. ");
INSERT INTO kqf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bi Maimaituwa ena giu i kamaḡati banina dolinemo taugiuwatana matabudi lisidimo i gei giu te yaḡolo Vinevinena yai nuwatoitoi bi ya peki. ");
INSERT INTO kqf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Taunana aubaina nuwemi ko vitaledi bi Maimaituwa lisinemo ko nawa te tana emi gebogebo ya noḡotikamaḡedi bi nuwemi ya laivaliudi. ");
INSERT INTO kqf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bi Tauwaiyawasana i vinevinena ya giukamaḡe lisimimo. Niga Tauwaiyawasanina ba Yesu. ");
INSERT INTO kqf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tana malamo ya miyamiyana, eete laḡan ya tava te Maimaituwa bai matabuna ya laivaliu munaḡedi banina wala niga mainana i giu waiyawa taugiuwatana lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bi kota Mousis mainana i giu, ‘Bada emi Maimaituwa tana kaka modomimo taugiuwatana ḡemota ya kamaḡati maibena tagu. Bi tana bai matabuna ya giugiuwemina, ko vaiye kauwe! ");
INSERT INTO kqf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bi aiyai mote taugiuwatana ena giu ima vaivaiye ba kamaina te Maimaituwa ena dam lavedi lisidimo ya kwavi vai bi ya kovoḡi.’ ");
INSERT INTO kqf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bi taugiuwatana ḡesaudi vaitedi a giu te niga kauwidi yaḡolo sa tubuḡa, maibena niganana laḡandimo sa tubutubuḡa mainana. Mba taugiuwatedi tedi Samuwel bi ḡesaudi mulinemo a tubutubuḡana. ");
INSERT INTO kqf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bi temi mba taugiuwatedi edi libilibi, taunana aubaina Maimaituwa wala emi magula lisidimo giu wainoḡota i sako, mba temi vaitemi aubaimi mai i giu. Bi Maimaituwa Eiblaḡam lisinemo waianina i voiyena ba niga mainana, ‘Tam em tubulelesemo kaka lava matabudi dobumo kavisuvisu sa vai.’ ");
INSERT INTO kqf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Taunana aubaina Maimaituwa ena taupaula pekimo i ka kenamoito munaḡe bi i gei giukamaḡe lisimimo. Bi mba taupaulina i voiyemi te ḡemogemotaḡa emi gebogebo kona kuvesidi bi tana i kavisuvisumi.” ");
INSERT INTO kqf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita bi Diyon yaḡolo lava lisidimo a giugiu ba Diu pilipilisidi, Sadisi lavedi bi pali vanuwina tauyavena edi bada a nawa Pita bi Diyon lisidimo a tava. ");
INSERT INTO kqf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tedi nuwedi i medina banina Pita bi Diyon lava a wailovelovedi bi a giugiuwedi te Yesu pekimo i kenamoito munaḡa bi kota lava matabudi pekimo sa kena moito munaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Taunana aubaina a panidi bi kaikana aubiga aubaina te biliwelokomo a sivu nawedi te laḡan i sako. ");
INSERT INTO kqf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bi lava wapewapedi Pita ena giu a vaivaiyena ai sumaḡa. Bi tauwaisumaḡa olooloto wapedi i saḡa te 5 tausan. ");
INSERT INTO kqf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bokinamai Diu edi babada bi babada nananakidi bi waiḡake tauwailovelovena Yelusalem noponemo ai ḡemotidi bi ai bolu. ");
INSERT INTO kqf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Lava niga bolunemo ba Anas tana pilipilisi edi bada Kaiyapas, Diyon, Aleksanda, olooloto ḡesaudi vaitedi bi pilisi edi bada ena vanuwa lavedi matabudi. ");
INSERT INTO kqf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tedi Pita bi Diyon mododimo ai moitodi bi ai talayedina gado, “Bai ḡailisinemo ee aiyai isanemo temi niga kauwina kona voiye?” ");
INSERT INTO kqf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ḡome Pita nopona Aluwa Waiyawa i wai wanavuna i giuwedina gado, “Tauwaibabada lava aubaidi bi tauwaibabada nananakimi koi beyavaiya. ");
INSERT INTO kqf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tama niganana ko wai talavitavitalemaina, kauwa visuvisuna lava kaḡe nuwakuduna lisinemo i tubuḡa aubaina. Temi ko wai talavitavitalemai te bainewa bi niga lavana i yawasana. ");
INSERT INTO kqf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kamaina te ka giuwemi te temi bi Islael lavemi matabumi ko vaiye. Nasalet Yesuna Vinevine Kamaḡena temi kona tupatupalatuna, tana Maimaituwa pekimo i ka kenamoito munaḡe, tana isanemo niga olotona niganana i yawasana bi matemimo ya moimoito. ");
INSERT INTO kqf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tana taunana ‘duḡumoito bi temi vanuwa taukelina duḡumoitona kona dabodabokena, niganana i nuwavitala te vanuwa yasina i tubuḡa.’ ");
INSERT INTO kqf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mote aiyai ḡemota niga dobunemo kaka imai yawasanida banina dobu matabuna noponemo mote bamo isa ḡesauna ima kenakena te isanemo yawasana tai baḡaye, geḡa te Yesu taunaḡa isanemo.” ");
INSERT INTO kqf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Laḡannemo bolu babadidi Pita bi Diyon edi laudabatola a kitakita ba, tedi a soveyedi banina a sibe te Pita bi Diyon mote giluma kauwa lavedi, tedi ba lava yababa. Bi a sibe te niga lavedi dolinemo Yesu vaitena a nawanawa. ");
INSERT INTO kqf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bi Diu babadidi a kita te oloto a waiyawasanina diyedimo i moimoito. Taunana aubaina tedi mote ḡemoḡemotina te maso lisidimo bai a giuwe. ");
INSERT INTO kqf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kamaina bi a giuwedi te a potiyovo aniwai bolu vanuwina didiyaunemo a miyamiya bi taudima babadidi taudiḡa ai talapili vivila. ");
INSERT INTO kqf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tedi ai tala munaḡedina gado, “Niga lavedi bainewa tai voiyedi? Yelusalem lavedi matabudi a sibe te niga lavedi mataila dididiga a voiye bi tada mote ḡemoḡemotina te ta valeledi. ");
INSERT INTO kqf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bi ta giu dabokedi te niga kauwina i tubutubuḡana mote ima dabalala lava lisidimo. Niga lavedi ta giu wainainailidi te mba isanemo mote aiyai lisinemo sima gagali munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ḡome Pita bi Diyon a giuwedi te aniwai bolu vanuwina noponemo a saḡa munaḡa bi a giu wainainailidi te mote niga lavana isanemo sima lauguguya, ee simai lovelove munaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bi edi giu ai munena gado, “Taumiḡa koi talapili munaḡemi te Maimaituwa matanemo bamo taunana i visu? Maimaituwa giuna ka kaiwata, ee temi emi giu ka kaiwata? ");
INSERT INTO kqf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tama mote ḡemoḡemotina te bai ke kitakitana bi ke vaivaiyena giuwena kama gose.” ");
INSERT INTO kqf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kamaina bi bolu babadidi a giu wainainailidi bi a kaikamaḡedi te a nawa banina mote a sibe te bainewa maso a kovoḡidi. Kota lava matabudi kaikana a kita te bai i tubuḡa bi Maimaituwa isana a kaka saḡesaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Niga olotona kaḡenuwanokuna i yawasanana ba ena kwalabu 40 bi i waimuli. ");
INSERT INTO kqf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Laḡannemo waibabada Pita bi Diyon a giugiukamaḡedi ba tedi a munaḡa edi lava tauwaisumaḡa lisidimo bi bai matabuna pilisi edi babada bi babada ḡesaudi bai a giugiuwedina, mainana a kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Laḡannemo tauwaisumaḡa mainana a vaivaiye ba matabudi ai ḡemotidi bi kalinedi dididiginemo Maimaituwa lisinemo a laupali, “Bada saḡasaḡa guletim, tam galewa, dobu, nisa bi nopodimo mwali matabuna kuna voiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tama tamamai Deivida em taupaula, wala Aluwa Waiyawemo kuna voiye te niga mainana i giu: ‘Bai aubaina Eteni lavedi sa medimedi? Bai aubaina lavedi kampota sa yesiyesi? Mba potana ba waibani geḡana. ");
INSERT INTO kqf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dobu edi ḡaliḡalibona a miya moito bi waibabada ḡesaudi nananakidi vaitedi ai ḡemotidi te Bada bi ena Buyobuyona sa wai ḡaviye.’ ");
INSERT INTO kqf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Giukauwa te, Alodi, Pontis Paelat, Islael lavedi bi kota Eteni lavedi niga malagainemo ai ḡemotidi bi em taupaula waiwaiyawina Yesu kuna vinena buyobuyona ai ḡaviye. ");
INSERT INTO kqf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bi tedi ai ḡemotidi bi bai matabuna tam em ḡailisimo bi em ogatala kuna wai aninena, luvanemo mainana a voiye. ");
INSERT INTO kqf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bi Bada, niganana edi giu wainainaila lisimaimo kwa noḡoti bi kwa voiyemai te tama em taupaula gium laudabatolamo ka giuwe. ");
INSERT INTO kqf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimam kwa tuḡu te kwai yawasana, mataila bi kauwa nananakidi kwa voiyedi em taupaula waiwaiyawina Yesu isanemo.” ");
INSERT INTO kqf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Laḡannemo pali i kovikovi ba gabu a waiḡemotidina i gusu. Bi matabudi Aluwa Waiyawa i waiwanavudi bi tedi Maimaituwa giuna laudabatolamo a giu nawe. ");
INSERT INTO kqf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tauwaisumaḡa matabudi nuwedi bi edi noḡota ḡemota. Bi aiyai mote i giu te taunaḡa ena ḡonaḡona, geḡa te matabudi awai sagu vivila. ");
INSERT INTO kqf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ḡome giugiukamaḡedi ḡailisi vaitena Bada Yesu ena peki bi ena kenamoito a giu nawe. Bi Maimaituwa sagu dididigina matabudi i vitedi bi i kavisuvisudi. ");
INSERT INTO kqf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bi ḡome mote aiyai mododimo bai i maluwabiye. Banina mabai doḡa bi vanuwa lisidimo ba a kuneyedi bi mane ");
INSERT INTO kqf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","giugiukamaḡedi a vitedi. Bi aiyai bai i malumaluwabiyena, mai a vitevite. ");
INSERT INTO kqf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Maibena Diyousep tana Livai damna noponemo bi Saiplasimo i tubuḡa bi giugiukamaḡedi awai isaisana Banabas. Isa Banabas banina ba Taulaibagi. ");
INSERT INTO kqf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tana doḡa i wai badayena i kuneye bi manena i natome giugiukamaḡedi i vitedi. ");
INSERT INTO kqf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oloto isana Ananaiyas bi mwanena Safila, tedi edi doḡa ḡaubona a kuneye. ");
INSERT INTO kqf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bi tana mwanena vaitena ai anina te mane isuna a kaididi tedi aubaidi. Bi isuna giugiukamaḡedi a vitedi. ");
INSERT INTO kqf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bi Pita Ananaiyas i giuwena gado, “Bai aubaina Seitan kunai anine te nopom i waibadae bi Aluwa Waiyawa lisinemo kuna kaiyovu, tam doḡa kuna kunekuneyena manena isuna kuna kaididi tam aubaim? ");
INSERT INTO kqf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tam maso doḡa kuna labe gwase, ee doḡa kuna kuneyena mulinemo mane maso kuna kaididi. Bi bai aubaina niga kauwina nopommo kunai nuwanoḡonoḡotae bi mainana kuna voiye? Tam mote lava lisinemo ku kaiyovu bi geḡa te Maimaituwa lisinemo kuna kaiyovu.” ");
INSERT INTO kqf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Laḡannemo Ananaiyas mai giuna i vaivaiye, tana i kuluva bi i peki. Bi lava matabudi niga kauwina giuna a vaivaiyena a naila gulata. ");
INSERT INTO kqf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Laḡannemo Ananaiyas i pekipeki ba, ḡome ewaewali a tava te a suma bi a avali nawe te a dobo. ");
INSERT INTO kqf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tedi a taumiya laḡan ḡotona te mwanena Safila i tava bi mote i sibe te bai i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ḡome Pita i waitalayena gado, “Ku giuwegu, doḡa kona kunekuneyena manena, niga taunana kamaina, ee?” Bi Safila i giuna gado, “Emaso, mba taunana kamaina.” ");
INSERT INTO kqf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bi Pita i giuwena gado, “Bai aubaina temi konai anina bi Bada ena Aluwa konai laulubu? Lava mwanem a dobodobona, tedi mataetamo sawai laba te tam kota vaitem sa avali nawem.” ");
INSERT INTO kqf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kamaina te Safila i waimaḡemoti te Pita kaḡe pakanemo i kuluva bi i peki. Ḡome ewaewali a saḡa vanuwemo bi a kita te waivini i peki. Kamaina bi a avali nawe bi mwanena diyanemo a dobo. ");
INSERT INTO kqf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bi Maimaituwa ena dam lavedi matabudi bi lava matabudi niga giuna a vaivaiyena ba a naila gulata. ");
INSERT INTO kqf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Giugiukamaḡedi mataila bi anisove kauwidi wapewapedi a voiyedi lava lisidimo. Bi tauwaisumaḡa matabudi Solomon ena yoveyovemo awai ḡemotidi, ");
INSERT INTO kqf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","bi lava ḡesaudi mote waisumeḡidi tedi tauwaisumaḡa vaitedi waiḡemota a naile geḡa te lava matabudi a viviledi. ");
INSERT INTO kqf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Olooloto bi waiwaivini Bada ai sumaḡe bi a solasaḡa tauwaisumaḡa nopodimo te laḡan matabuna tauwaisumaḡa iyevina i dididiga. ");
INSERT INTO kqf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tedi lava sidesidedi a avali nawedi etamo te benamo bi duya dabedimo ai kenedi. Tedi mai a voiyena banina Pita i natonatona waguluna maso i taukonidi te a yawasana. ");
INSERT INTO kqf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lava kumna ḡesaudi Yelusalem diyana malagaidi vaitedi ai ḡemotidi bi lava sidesidedi bi kota lava ḡesaudi aluwa gebogebodi a sunesuneḡidina vaitedi a tavaitedi bi matabudi ai yawasanidi. ");
INSERT INTO kqf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ḡome pilisi saḡasaḡa guletina bi ena lava Sadisi wai babadidi vaitedi nopodi unula i wanavu. ");
INSERT INTO kqf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bi Giugiukamaḡedi a panidi bi biliwelokomo a sivudi. ");
INSERT INTO kqf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bi dudubalemo Bada ena aneya biliweloko mataetina i kaikamaḡe te i waidolidi a potiyovo bi i giuwedina gado, ");
INSERT INTO kqf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ko nawa Maimaituwa ena vanuwa ganakukunemo ko moito bi yawasana valivaliuna matabuna lava ko giuwedi!” ");
INSERT INTO kqf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Laḡan i sako bi giugiukamaḡedi a nawa pali vanuwinemo, aneya i giugiuwedina mainana bi lava wailovelovedi ai tubu. Laḡannemo pilisi saḡasaḡa guletina bi ena wai babada ḡesaudi bi Diu babadidi vaitedi bolu ai yogae bi a tava bolu vanuwinemo ai ḡemotidi. Bi tauyava a giukamaḡedi biliwelokomo, te maso giugiukamaḡedi ai dolidi. ");
INSERT INTO kqf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Laḡannemo tedi biliwelokomo a tavatava ba giugiukamaḡedi mote a kitedi, taunana aubaina a munaḡa bolu babadidi lisidimo bi bai i tubutubuḡana a kamaḡati bi a giuna gado, ");
INSERT INTO kqf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Biliweloko mataetina gudugudu kauwena bi tauyava mataetamo a moimoito bi mataeta ke kaikaikamaḡe ba mote aiyai ḡome ke kita.” ");
INSERT INTO kqf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Laḡannemo Maimaituwa ena vanuwa tauyavena edi bada bi pilisi edi babada niga giuna a vaivaiye ba, tedi ai nuwanaina bi mote a sibe te bai ya tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ḡome lava ḡemota i tava bi i giuwedina gado, “Olooloto biliwelokomo kona sivusivudina, tedi niganana Maimaituwa ena vanuwemo a moito bi lava sa wailovelovedi.” ");
INSERT INTO kqf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ḡome pali vanuwina tauyavena edi bada vaitena a nawa bi giugiukamaḡedi a natomedi. Bi mote a egelidi banina lava a nailedi, male sa lauḡakimidi. ");
INSERT INTO kqf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tedi giugiukamaḡedi a natomedi Bolu babadidi lisidimo bi pilisi edi bada i wai talavitavitaledi. ");
INSERT INTO kqf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Bi i giuwedina gado, “Tama ke giu vavasaḡemi te temi mote maso niga olotona isanemo ko wailovelove. Bi geḡa te emi wailovelove kaikana Yelusalem nopona i waiwanavu. Bi temi ko giugiuwemai te niga lavana ena peki wavuna tama ke avali.” ");
INSERT INTO kqf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bi Pita giugiukamaḡedi ḡesaudi vaitedi giu ai munena gado, “Tama Maimaituwa ka voteyateyae mote lava. ");
INSERT INTO kqf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Temi Yesu kolosi modonemo konai peki bi tamatamada edi Maimaituwa pekimo i ka kenamoito munaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Te kataiyanemo i waimiyenina Ḡalibona bi Tauwaiyawasana. Te Islael lavedi nopodi ya vitaledi te sa laukuvasa bi edi gebogebo ya noḡotikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tama niga kauwidi matamaimo ke kitekitedina ka giugiu nawe, kota mabai Maimaituwa Aluwa Waiyawa i vitevitedina tedi sa vovoteyeteye.” ");
INSERT INTO kqf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Laḡannemo Diu babadidi niga giuna a vaivaiye ba tedi nuwedi i medi gulata bi a ḡoeḡoena maso ai pekidi. ");
INSERT INTO kqf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bi Palisi ḡemota isana Gamaliel, tana waiḡake tauwailovelovena bi lava matabudi tana a vivivile, tana poudimo i miya moito bi tauyava i giu vavasaḡedina gado, “Pita bi Diyon ko giuwedi sa potiyovo doḡamo laḡan watiḡena. ");
INSERT INTO kqf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tana i giuna gado, Islael babadimi, ko kita kauwa kaka niga lavedi lisidimo bai ko voiye. ");
INSERT INTO kqf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dolinemo mainana oloto isana Tadiyas i moito saḡa bi i giu te tana bena kage lava dididiga bi lava wapana 400 a kaiwata. Bi laḡannemo tana ḡaviḡaviyidi ai peki bi taukaiwatana a dabalala bi bai matabuna i lautautau. ");
INSERT INTO kqf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bi tana mulinemo, kota Galili olotona isana Diudas ko noḡoti. Mba laḡannemo Loum gabemanina lava a iyeiyevidi bi i moitosaḡa te lava kumna iai waietadoliyedi. Bi tana vaitena ḡaviḡaviyidi ai peki bi taukaiwatana matabudi ai nawa ḡemoḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Taunana aubaina niganana yà giugiuwemi te niga lavedi lisidimo mote bai koma voiye. Bamoda edi noya lava lisinaḡa i natona ba, noyana ya lautautau. ");
INSERT INTO kqf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bi bamoda Maimaituwa lisinaḡa i natona ba mote ḡemoḡemotina niga lavedi koma giu waitautaudi bamoda temi Maimaituwa kowai ḡaviye.” Kamaina bi mba babadidi Gamaliel ena giu ai anine bi a kaiwata. ");
INSERT INTO kqf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ḡome tauyava giugiukamaḡedi a ka valageti munaḡedi bi madamo a kwapudi bi a giu vavasaḡedi te maso mote Yesu isanemo a giu munaḡa, kamaina bi a kita kamaḡedi te a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ḡome giugiukamaḡedi ma nuwavisudi bolu vanuwina a potiyovo kamaḡe bi a nawa banina Maimaituwa i vinedi te tedi kamaina te sai nuwatoi Yesu isana aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bi laḡan matabuna pali vanuwinemo bi lava edi vanuwa nopodiḡa giu visuvisuna wailovelovena mote a kaisako bi a laulauguguya te Yesu tana Vinevine Kamaḡena. ");
INSERT INTO kqf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mba laḡandimo tauwaikaiwatana iyevina i saḡasaḡa. Bi tauwaisumaḡa Gulik kalinana taugiuwena a moito te Diu Ḡibulu taugiuwena a giuvitavitaledi. Banina Gulik iwape mote a kita kauwedi kani soiyenemo. ");
INSERT INTO kqf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Taunana aubaina tauwaikaiwatana 12 tauwaisumaḡa a yogedi a tava ai ḡemotidi bi a giuwedina gado, “Mote i visu te kani soiyenemo ka soisoi kauleya bi Maimaituwa giuna lauguguyaena ka kaisako. ");
INSERT INTO kqf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Taunana aubaina, ema lava waisumeḡimi ko kita te olooloto 7 sibe lavedi bi Aluwa i waiwai wanavudina ko vinedi te tama niga noyana ka vitedi te sai badaye. ");
INSERT INTO kqf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bi tama kamaina te Maimaituwa giuna ka lauguguyae bi pali ka kaididi.” ");
INSERT INTO kqf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ḡome giugiukamaḡedi edi giu, lava matabudi ai anine. Kamaina bi Stivin, waisumeḡina bi Aluwa Waiyawa i waiwai wanavuna a vine. Bi ena lava ḡesaudi ba: Filip, Pokolas, Nikano, Timon, Pamenas bi Nikolas. Nikolas tana ba Eteni, Entiyok olotona bi wala i waila Diu. ");
INSERT INTO kqf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tauwaisumaḡa niga oloolotodi 7 ai doli natomedi giugiukamaḡedi lisidimo. Bi giugiukamaḡedi nimedi olooloto 7 dabedimo a sivudi te a laupali. ");
INSERT INTO kqf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kamaina bi ḡome Maimaituwa giuna i tuwa. Bi tauwaikaiwatana iyevina Yelusalem noponemo i wapa kasaḡe. Bi pilisi wapewapedi vaitedi a nato Yesu ena kauwa a wailovelovena ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Maimaituwa Stivin i ka visuvisu bi ḡailisi i vite te anisove kauwidi bi mataila i voivoiyedi lava lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bi geḡa te Diu lavedi ḡesaudi Stivin a giu vitavitale, tedi ba bolu vanuwina isana Waitaupaula yababa i kovi lavedi. Tedi ba Diu lavedi mabai Sailin, Aleksandiliya, Silisiya bi Eisiya plovinsina lavedi. Tedi Stivin vaitena waikagiu ai tubu. ");
INSERT INTO kqf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bi geḡa te Aluwa Waiyawa nuwauyauya Stivin i vite bi i gagagaliyena mote ḡemoḡemotina te maso a lauyovoḡe. ");
INSERT INTO kqf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Taunana aubaina tedi kandavonemo olooloto ḡesaudi a gwayedi te kaiyovumo sa giuna gado, “Tama ke vaiye te Stivin Mousis bi Maimaituwa i giu waiyovoyovodi.” ");
INSERT INTO kqf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Niga giudimo lava, waibabada bi waiḡake tauwailovelovena a ka medimedidi. Kamaina bi tedi Stivin a pani bi ai doli nawe bolu babadidi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ḡome tedi giu kaikaiyovudimo lava ḡesaudi a giuwedi te sa giuna gado, “Niga lavana ke vaiye te tana Maimaituwa ena vanuwa bi ena waiḡake Mousis i vitevitena laḡan matabuna i laulauyovoḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tama ke vaiye te i giuna gado, ‘Niga Nasalet Yesuna male pali vanuwina yaka gebogebo bi Diu edi vaivai Mousis i vitevitemaina ya vitaledi.” ");
INSERT INTO kqf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tedi mabai bolu babadidi a miyamiyana Stivin a kitakitadidi bi kitana i nuwavitala maibena aneya. ");
INSERT INTO kqf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pilisi saḡasaḡa guletina Stivin i wai talayena gado, “Niga lavedi bai sa giugiuwena ba giukauwa, ee?” ");
INSERT INTO kqf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Bi Stivin edi giu i waimunena gado, “Tamatamagu bi tuwatuwaḡagu bai yà giuwena ko vaiye. Maimaituwa namanamalina wala Mesapotomiyamo Eiblaḡam lisinemo i laumaḡata, muliḡa kaka i nawa Alanmo i miya. ");
INSERT INTO kqf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Bi Maimaituwa Eiblaḡam i giuwena gado, ‘Em dobu bi em lava kwa gosedi bi dobu tagu yài lovemnemo kwa nawa.’ ");
INSERT INTO kqf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kamaina bi ena dobu Mesapotomiya i gose bi i nawa Alanmo i miya. Ḡome tamana i peki mulinemo, Maimaituwa Eiblaḡam i giukamaḡe niga dobunemo niganana ta miyamiyanemo. ");
INSERT INTO kqf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mba laḡannemo Maimaituwa mote doḡa ḡaubona niga ḡome i vite. Bi Maimaituwa i giuwapa te laḡan muliḡa tana bi ena tubulelesa ya vitedi. Avena te Eiblaḡam mote i wainatuna bi yaḡolo te Maimaituwa lisinemo i sauga. ");
INSERT INTO kqf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Maimaituwa i giuwena gado, ‘Em tubulelesa kaka wali dobumo sai taupaula yababa. Bi kwalabu 400 nopodimo mba dobuna lavedi kaka em tubulelesa sa voiyedi te sai nuwatoitoi. ");
INSERT INTO kqf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bi mba dobuna lavedi aubaidi sa wai taupaula yababana kaka yà kovoḡidi. Bi muliḡa kaka em tubulelesa mba dobuna sa gose kamaḡe bi sa nato niga dobunemo bi sa lauduneyegu.’ ");
INSERT INTO kqf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mba ḡome Maimaituwa kwapibwali ena waianina Eiblaḡam i vite. Bi laḡannemo Aisik i tubuḡa, laḡan 8 mulidimo Eiblaḡam kwapibwali i voiye Aisik lisinemo. Bi kota Aisik natuna Deikap lisinemo i voiye. Bi Deikap natunatuna 12 lisidimo kota mainana i voiye. Niga lavedi edi tubulelesa ba tada. ");
INSERT INTO kqf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Deikap natunatuna tasidi Diyousep a unule, taunana aubaina tana a kune kamaḡe Idip lavedi lisidimo te yai taupaula yababa. Bi geḡa te Maimaituwa tana vaitena, ");
INSERT INTO kqf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","taunana aubaina ena pilipili matabudimo i sagu. Maimaituwa Diyousep nuwauyauya i vite bi ena yawasanamo Idip ḡalibonana nuwana i laukwasili. Taunana aubaina ḡalibona, Diyousep waibada i vite te Idip dobuna matabuna bi ena vanuwa nopona i waibadae. ");
INSERT INTO kqf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kamaina bi Idip bi Keinan dobudi matabudi gomala i ka gebogebodi bi wainuwatoi dididiga i tubuḡa. Bi eda magula mote bamo kani a banavi. ");
INSERT INTO kqf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Laḡannemo Deikap i vaiye te Idipmo kani, tana natunatuna eda magumagula i giukamaḡedi. Tedi mote ḡome nawenawedi bi geḡa te a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bi kota edi nawa wailabunemo Diyousep i kamaḡati munaḡe tuwatuwaḡana lisidimo. Ḡome kaka Idip ḡalibonana Diyousep ena vanuwa lavedi i sibedi. ");
INSERT INTO kqf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Diyousep tamana Deikap bi ena vanuwa lavedi wapedi 75 edi giu i giukamaḡe te sa nato Idipmo. ");
INSERT INTO kqf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kamaina bi Deikap i nawa Idipmo, ḡome tana bi natunatuna a miyamiyana eete a peki. ");
INSERT INTO kqf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bi tubuḡidi a munaḡedi te Sekemmo tauyewamo a sivudi wala Eiblaḡam manemo i gimegimelina Ḡema natunatuna lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Laḡan i watiwatiḡe te Maimaituwa Eiblaḡam lisinemo bai i giugiuwapana ya tubuḡa. Bi Idip noponemo eda lava Islael lavedi iyevina i wapa gulata. ");
INSERT INTO kqf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kamaina bi lava ḡesau i waiḡalibona Idipmo. Niga lavana mote Diyousep i sibe. ");
INSERT INTO kqf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bi niga ḡalibonana eda magumagula i laukivi gebogeboyedi bi i egelidi te natunatudi meyemeyedi doḡamo a sivu yovoḡedi te sa peki. ");
INSERT INTO kqf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mba laḡannemo Mousis i tubuḡa bi tana gomana mulemulelena Maimaituwa matanemo. Nawalai faiona tinana bi tamana edi vanuwemo a labe. ");
INSERT INTO kqf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bi laḡannemo mote ḡemoḡemotina te maso a labe, tana a sako yovoḡe. Bi ḡalibona natuna waivinina i vai, te i ḡamo bi i wai natune maibena natu otina. ");
INSERT INTO kqf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bi tana Idip edi nuwauyauyamo ai lovelove. Tana ena giumo bi ena kauwemo lava ḡaiḡailisina i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Laḡannemo Mousis ena kwalabu 40 a kovi bi i ḡoe te ena lava Islael ya vakitedi. ");
INSERT INTO kqf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bi Mousis i kita te Idip lavana i miya moito te Islael olotona i katikati vunu. Ḡome tana ena tau mulinemo i moito bi biwana i vai te Idip lavana i lai peki. ");
INSERT INTO kqf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Bi Mousis i wainoḡota te ena lava otidi maso a sibe te Maimaituwa yai etadoliye te tana kaka ena lava yai yawasanidi bi geḡa te tedi mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bokina mainana i kita te ena lava Islael labu a waiḡasiḡasi. Kamaina bi Mousis i nawa i katautaudi bi i giuwedina gado, ‘Ei, mba em tau bai aubaina ko waikaḡasiḡasi?’ ");
INSERT INTO kqf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ḡome oloto ena tau i laulaugulatena Mousis i bibini bi i giuwena gado, ‘Tam aiyai waibada i vitem bi kwa waibadaemai bi kwa etaetalemai? ");
INSERT INTO kqf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tam maḡo Idip lavana kuna lai peki, mai niganana tagu kwa lai pekigu, ee?’ ");
INSERT INTO kqf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Laḡannemo Mousis niga giuna i vaivaiye ba tana i naila i nawa Midian. Ḡome i miyana maibena tautavatava bi natunatuna oloolotodi labu. ");
INSERT INTO kqf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kwalabu 40 a kovi mulidimo kalakalalelemo oya Sainai diyanemo, kai tomboluna, vavavannemo aneya i laumaḡata Mousis lisinemo. ");
INSERT INTO kqf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Laḡannemo nigamai i kitakita ba i tava. Kamaina bi i nawa diyanemo maso i kita kaukauwena mba Bada kalinana i vaiyena gado, ");
INSERT INTO kqf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Tagu taunana em magumagula Eiblaḡam, Aisik bi Deikap edi Maimaituwa.’ Mousis naila i kagusugusu bi mote i waikita munaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kamaina bi Bada, Mousis i giuwena gado, ‘Em kaḡe suma kwa kaikamaḡe. Banina mba gabunemo kwa moimoitona ba doḡa waiyawa. ");
INSERT INTO kqf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tagu egu lava edi wainuwatoi Idipmo e kita bi kota edi lauaiyoi e vaiye. Bi tagu e yovona ba yài yawasanidi. Taunana aubaina kwa nato bi niganana yà giukamaḡem kwa munaḡa Idipmo.’ ");
INSERT INTO kqf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mousis tana taunana dolinemo Islael lavedi a daboke bi a giuwena gado, ‘Tam aiyai ḡailisi i vitem bi kwa waibadaemai?’ Tana taunana Maimaituwa i giukamaḡe te lava ya kapotiyovodi bi yai etadoliyedi, aneya kai tomboluna vavavaninemo lisinemo i laulaumaḡatana ena sagumo. ");
INSERT INTO kqf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Islael lavedi Idipmo i kapotiyovodi bi anisove kauwidi bi mataila Idipmo i voiyedi. Bi kota Nisa Sabasabanemo bi kalakalalelemo kwalabu 40 nopodimo. ");
INSERT INTO kqf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mousis Islael lavedi i giuwedina gado, ‘Maimaituwa kaka taugiuwatana ḡemota nopomimo ya vine bi ya giukamaḡena lisimimo maibena tagu.’ ");
INSERT INTO kqf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Bi tana taunana kalakalalelemo Islael lavedi, vaitedi ai ḡemotidi. Tana ḡome eda magumagula vaitedi bi kota Mousis oya Sainai dabanemo yawasana giuna aneya i giuvite te i waidama lisidemo. ");
INSERT INTO kqf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bi geḡa te eda magumagula mote kalinana a voteyateyae. Tedi a daboke bi a ḡoeḡoena maso a munaḡa Idip. ");
INSERT INTO kqf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Taunana aubaina Elon a giuwena gado, ‘Ema maimaituwa kwa voiyedi te sai etadoliyemai. Niga lavana Mousis Idipmo i ka potiyovoda bi tada mote ta sibe te bai lisinemo i tubuḡa?’ ");
INSERT INTO kqf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kamaina bi tedi koikoitau a voiyena kitana maibena kau natuna. Bi koikoitau a voivioyena lisinemo a soi, a lausewasewa bi a vivivile. ");
INSERT INTO kqf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Taunana aubaina Maimaituwa i miyatautauliyedi bi i kita kamaḡedi te kipola, suwala bi nawalai galewemo a laulauduneyedi, maibena taugiuwatana edi bukamo a gilugilumina mainana. Ḡome Maimaituwa i giuna gado, ‘Islael lavemi, wala kwalabu 40 kalakalalelemo kona miyamiyana ba mote tagu lisigumo ko laulausewasewa. ");
INSERT INTO kqf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bi temi mba maimaituwa Molek ena kape kona ava'avali waibabali. Bi kota kipola maimaituwana Lafen aluwina kona ava'avali waibabali. Temi mba mwalidi kona voiyedi bi kona laulauduneyedi. Taunana aubaina yà giukamaḡemi te emi dobuko potiyovo kamaḡe bi Babilon mulitaulinemo ko nawa.’ ");
INSERT INTO kqf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kalakalalelemo eda magumagula Maimaituwa mayavaina kapena a ava'avali nawe. Bi a voiyena ba bainewa Maimaituwa Mousis i giugiuwena mainana. Bi kota kitana bainewa i wailovena mainana luvanemo i voiye. ");
INSERT INTO kqf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Laḡan muliḡa Diyosuwa eda magumagula i wai etadoliyedi ḡaviya noponemo bi lava mba dobudimo miyemiyedi Maimaituwa i kwavi waipotiyovodi te dobuna a vai, lava niga ḡome a miyamiyana lisidimo. Bi Maimaituwa mayavaina kapena a avali tavaite niga dobunemo Maimaituwa ani laudunena bi ḡome i kenana eete Deivida ena waibada saugina. ");
INSERT INTO kqf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Maimaituwa, Deivida nuwana i vai. Bi Deivida, Maimaituwa i waibaḡa te maso i waianine bi pali vanuwina i ḡala, Deikap ena tubulelesa edi ani laudune. ");
INSERT INTO kqf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bi geḡa te Solomon pali vanuwina i ḡala Maimaituwa aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bi kota Maimaituwa saḡasaḡa guletina mote lava vanuwa a ḡaleḡaledina nopodimo ima miyamiya. Taugiuwatana niga mainana i giu: ");
INSERT INTO kqf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mala egu ani miya bi dobu kaḡegu ani waitupamoitona. Vanuwa bainewa kitana kwa ḡala aubaigu? Ee bamo egu vanuwa ani waiyawasi? ");
INSERT INTO kqf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tagu mote mwali matabudi malamo bi dobumo nimagumo e voiyedi?’” ");
INSERT INTO kqf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stivin yaḡolo ena giu ya nawenawe, “Temi nopomi ḡaiḡaidi, beyemi a pota bi kona laukasaḡaiḡai mote Maimaituwa giuna koma vaivaiye. Maibena emi magumagula. Temi sauga matabuna Aluwa Waiyawa ko laulaukasaḡaiḡaiye. ");
INSERT INTO kqf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Emi magumagula wala taugiuwatana matabudi a laukivigebogeboyedi bi ai pekidi. Tedi ba lava didimanina ena nato a giugiuwata. Bi laḡannemo i tavana ba temi kona kaisoluḡe bi konai peki. ");
INSERT INTO kqf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Maimaituwa ena waiḡake aneya i vitedi bi a natome eda magula lisidimo bi temi mote ko kaiwata.” ");
INSERT INTO kqf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Laḡannemo Diu babadidi Stivin ena giu a vaivaiyedi ba a medi gulata lisinemo bi mwakedi a sanadididi. ");
INSERT INTO kqf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stivin Aluwa Waiyawa i waiwanavu bi i wai kita saḡa malamo te Maimaituwa namalina bi Yesu, Maimaituwa kataiyanemo i moimoitona i kita. ");
INSERT INTO kqf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kamaina bi Stivin i giuna gado, “Koi kita, tagu mala nuwa wasana e kita bi Maimaituwa kataiyanemo Tana Taunana Natuna ya moimoito.” ");
INSERT INTO kqf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Niga giudi a vaivaiyedi ba beyedi a sula gududi bi matabudi ai lasa te velau Stivin a dubutawi. ");
INSERT INTO kqf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tedi a solu nawe malagai mulitaulinemo bi ḡome a lauḡakimi. Bi tauwaiwavu edi gala a lolodi bi oloto ewalina isana Sol kaḡe pakanemo a sivudi te ya labedi. ");
INSERT INTO kqf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laḡannemo Stivin a laulauḡakimi ba tana i laupalina gado, “Bada Yesu, aluwigu kwa vai!” ");
INSERT INTO kqf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kamaina bi tuwapekana i waitupagwaliḡe bi kalinana dididiginemo i binauna gado, “Bada niga lavedi edi gebogebo kwa noḡotikamaḡe.” Stivin niga giuna i vato mulinemo te i peki. ");
INSERT INTO kqf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Bi Sol ena waianina Stivin ai peki. Diu babadidi Stivin a laipeki mulinemo, olooloto tauwaisumaḡa Stivin a ḡabe gulate bi a avali nawe tauyewamo a sako. Mba laḡaninemo kota Yelusalemmo laukivigebogebo dididiga tauwaisumaḡa lisidimo i tubuḡa. Te tauwaisumaḡa matabudi a dabalala bi a nawa Diudiya bi Sameliya plovinsidi nopodiḡa. Bi giugiukamaḡedi taudiḡa Yelusalemmo a miya gwasa. ");
INSERT INTO kqf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ḡome Sol lava i lauegelidi te Maimaituwa ena dam laukivigebogeboyedi ai tubu. Tedi a nawa vanuwa bi vanuwa bi tauwaisumaḡa oloolotodi bi 8waiwaivinidi a solu yovoḡedi te biliwelokomo a sivusivu nawedi. ");
INSERT INTO kqf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tauwaisumaḡa a dabadabalalana a nawa malagai te malagai bi Yesu giuna visuvisuna a lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bi Filip i nawa malagai dididigina Sameliya dobuna noponemo bi Vinevine Kamaḡena giuna visuvisuna i lauguguyae lava lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Laḡannemo lava kumdi Filip ena lauguguya a vaivaiye bi anisove kauwidi a kitekitedi ba tedi matabudi ena giu a vaiye kaukauwe. ");
INSERT INTO kqf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Banina Filip lava nopodimo aluwa gebogebodi i kwavi vaidi bi ma galalidi a potiyovo. Bi kota lava wapewapedi tunipekipekidi bi kaḡe nuwakududi i waiyawasanidi. ");
INSERT INTO kqf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taunana aubaina lava mba malagaina dididiginemo ai nuwavisu gulata. ");
INSERT INTO kqf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sameliyamo oloto isana Saimon walaka bwalabwalauna miyamiyana, Sameliya lavedi matabudi ena bwalau kauwidi i voivoiyedina a sovesove. Bi i seḡaseḡala te lava dididiga. ");
INSERT INTO kqf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bi lava yababa te lava nananakidi mataudi kalinana a vaivaiye kauwe bi a giu te, “Maimaituwa ena ḡailisi dididiga lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tedi Saimon kaiwatana walaka ai tubu bi ena bwalaumo lava i wai soveyedi. ");
INSERT INTO kqf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bi Laḡannemo Filip Maimaituwa ena waibada bi Yesu isana i laulauguguyae ba olooloto bi waiwaivini ai sumaḡa bi i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bi Saimon vaitena i waisumaḡa bi i kabulu. Ḡome Filip ena ani nawamo i kaiwata. Bi Filip anisove kauwidi bi mataila i voivoiyedina Saimon i kitedi bi i sovesoveyedi. ");
INSERT INTO kqf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Laḡannemo giugiukamaḡedi Yelusalemmo a vaiye te Sameliya lavedi Maimaituwa giuna ai sumaḡe, tedi Pita bi Diyon a giukamaḡedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Banina tedi yaḡolo mote Aluwa Waiyawa i yovo tauwaisumaḡa valivaliudi lisidimo. Bi tedi ba Bada Yesu isanemo a kabulu otiḡedi. Laḡannemo Pita bi Diyon a tava lisidimo ba aubaidi a laupali te Aluwa Waiyawa sa vai. ");
INSERT INTO kqf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kamaina bi Pita bi Diyon nimedi tauwaisumaḡa dabedimo a sivudi bi Aluwa Waiyawa a vai. ");
INSERT INTO kqf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Bi laḡannemo Saimon i kita te giugiukamaḡedi nimedi tauwaisumaḡa dabedimo a sivudi te Aluwa Waiyawa a vai. Ḡome Saimon mane i waiyoyo Pita bi Diyon lisidimo ");
INSERT INTO kqf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bi i giuwedina gado, “Niga ḡailisina kota ko vitegu te aiyai dabanemo nimagu yà sakona ba Aluwa Waiyawa ya vai.” ");
INSERT INTO kqf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bi geḡa te bi Pita i giuwena gado, “Tam male em mane vaitena ko nawa kai kalakalatinemo. Banina tam kuna noḡoti te Maimaituwa ena puyo bena manemo kwa gimeli ee! ");
INSERT INTO kqf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tam mote Maimaituwa i waianinem te tama ema noyamo kwa saḡa banina nuwapoum mote i didimana Maimaituwa matanemo. ");
INSERT INTO kqf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","I visu te mba em noḡotidi gebogebodi kwa kuvesidi bi kwa laupali Bada lisinemo te em gebogebo male ya noḡoti kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Banina e kitam te kuna unula gulata lisimaimo bi em noḡota gebogebodi sa waibadaem.” ");
INSERT INTO kqf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kamaina bi Saimon i giuwena gado, “Aee aubaigu ko laupali Bada lisinemo te bai kuna giugiuwena lisigumo mote mainana ima tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ḡome Pita bi Diyon edi waisumaḡa a giuwedi bi Bada Yesu giuna visuvisuna a lauguguyae. Mulinemo tedi a munamunaḡa Yelusalemmo ba Sameliya malagaidiḡa giu visuvisuna a laulauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kamaina bi Yelusalemmo Bada ena aneya Filip i giuwena gado, “Kwa vononoḡa bi kwa yovo kwa nawa yalousa yawaninaḡa. Tam eta Yelusalemmo bi i yovo i nawa Gasa taunana kwa kaiwata.” (Mba etana i pupu aubaina lava mote sima kaikaiwata). ");
INSERT INTO kqf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ḡome Filip i modina i nawanawa etamo te Itiopiya olotona i banavi bi olotona ba waibadana dididiga, ḡalibona waivinina isana Kandeke ena mane taulabena. Niga olotona i nawa Yelusalemmo laudune aubaina, ");
INSERT INTO kqf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","bi ena seliotmo i munamunaḡa ba etamo taugiuwatana Aisaiya ena buka i iyeiyevi. ");
INSERT INTO kqf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kamaina bi Aluwa Waiyawa Filip i giuwena gado, “Kwa nawa noi seliyotina diyanemo kwa moito.” ");
INSERT INTO kqf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Bi ḡome Filip i velau seliot diyanemo bi i vaiye te olotona taugiuwatana Aisaiya ena buka i iyeiyevi. Kamaina bi Filip i waitalayena gado, “Bai kwa iyeiyevina banina kwa sibesibe ee geḡa?” ");
INSERT INTO kqf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bi olotona ena giu i waimunena gado, “Bainewa yà sibe? Walitau ya giuwailovelovegu kaka yà sibe.” Kamaina bi olotona Filip i giuwe te i valageta ena seliotimo bi diyanemo i miya. ");
INSERT INTO kqf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bi olotona Aisaiya ena bukamo i iyeiyevina ba niga mainana i giu: “Lava tana ai doli nawe bi sa vununa maibena sipu. Bi kota maibena sipu lauewalina laḡannemo kapalina a bwalibwali, ba tana i miya moimoisili bi mote bai i giuwe. ");
INSERT INTO kqf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Laḡannemo a ka gebogebo gulate, tana mote aubaina i giu ḡaiḡailisi. Mote aiyai kaka ena tubulelesa ima giuwata. Banina ena yawasana dobumo ba damona.” ");
INSERT INTO kqf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ḡome Itiopiya badana Filip i waitalayena gado, “Ae goma, ku giuwegu, taugiuwatana aiyai ya giugiuwe, tana taunaḡa ee, lava ḡesau?” ");
INSERT INTO kqf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kamaina bi Filip, Aisaiya ena bukamo giugiuna ḡemotinemo giu i waitubu bi Yesu giuna visuvisuna giu wailovelove i wai tubu. ");
INSERT INTO kqf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Tedi a nawanawa etaḡa te gaubemo a tava bi Itiopiya badana i giuwena gado, “Ei, gauba nove, tagu kamaina te yà bulu bai ya ka pilipiligu?” ");
INSERT INTO kqf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kamaina bi ena seliot tauvelauyena i giuwe te i moito bi tana bi Filip a nawa gaubemo. Ḡome Filip Itiopiya badana i kabulu. ");
INSERT INTO kqf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Laḡannemo gaubemo a lovolovo tava ba Bada Aluwina i waimaḡemoti te Filip i avali nawe. Bi Itiopiya olotona mote Filip i kita munaḡe. Bi tana ma yasisina i gelu i nawa banina Maimaituwa i waiyawasani. ");
INSERT INTO kqf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip bainewa te Adotasmo i laumaḡata. Tana malagai matabuna nopodiḡa i nawa bi giu visuvisuna i laulauguguya nawena eete Seseliyamo i tava. ");
INSERT INTO kqf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mba laḡandi nopodimo Sol yaḡolo te nuwana i medi gulata bi i giu te Bada ena tauwaikaiwatana yai pekidi. Taunana aubaina i nawa pilisi saḡasaḡa guletina lisinemo bi ");
INSERT INTO kqf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","i waibaḡa te pepa ya kulidi Diu edi bolu vanuwidi babadidi aubaidi Damaskas malagainemo. Tedi maso mba pepedi a iyevidi bi Sol ai anine te olooloto bi waiwaivini Yawasana Etana taukaiwatana maso i panidi bi i natomedi Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kamaina bi Sol i nawa Damaskas malagaina diyanemo i tavatava ba yanayana wai matakanikanina malamo i wai maḡemoti te Sol i yana kwaivivili, ");
INSERT INTO kqf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","bi i kuluva doḡamo i talaḡa. Bi kalina galewemo i vaiyena gado, “Sol, Sol bai aubaina kwa laulau kivigebogeboyegu?” ");
INSERT INTO kqf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol i waitalana gado, “Tam aiyai, Bada ee!” Bi Yesu i giuna gado, “Tagu Yesu, tagu taunana kwa laulaukivigebogeboyegu. ");
INSERT INTO kqf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yaḡiyaḡina kwa moito makai bi kwa nawa malagai dididiginemo bi ḡome sa giuwem te bai kwa voiye.” ");
INSERT INTO kqf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Olooloto Sol vaitena a nawanawana, ḡome a tau moimoito giu geḡa banina tedi kalina a vaiye bi mote aiyai a kita. ");
INSERT INTO kqf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ḡome Sol i miya moito bi gado yai kita ba matana i wai dudubala bi mote bai i kita. Kamaina bi nimanemo a kabi bi ai wai doli nawe Damaskas. ");
INSERT INTO kqf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Bi ma matapotapotana i miyana laḡan faiona a kovi, mote bai i kani bi i tego. ");
INSERT INTO kqf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas noponemo tauwaikaiwatana ḡemota isana Ananaiyas i miyamiya. Bi wailove i kita Bada i laumaḡata bi i giuwena gado, “Ananaiyas.” Bi ena giu i waimunena gado, “Bada, tagu niga.” ");
INSERT INTO kqf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ḡome Bada i giuwena gado, “Kwa modina kwa nawa eta sa wai isana, Eta Didimanina. Mba ḡome Diudas ena vanuwemo kwa tava bi kwai talana Tasis olotona isana Sol aubaina, tana ḡome niganana ya laulaupali lisigumo. ");
INSERT INTO kqf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Bi wailove i kita te oloto isana Ananaiyas ya natonato lisinemo te nimana dabanemo ya sivudi bi yai kita munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ḡome Ananaiyas ena giu i waimunena gado, “Bada, lava wapewapedi mba olotona ena kauwa a giuwegu, te tana taukaiwatam Yelusalemmo i kaka gebogebodi. ");
INSERT INTO kqf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bi pilipilisi edi babada ḡailisi a vite te i nato Damaskasmo te taulauduneyem matabudi ya panidi.” ");
INSERT INTO kqf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bada, Ananaiyas i giuwena gado, “Kwa nawa banina tagu niga olotona e vine te egu noya ya voiye bi isagu ya giuwaimaḡati, Eteni lavedi bi ḡaliḡalibona bi Islael lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bi tagu yài love te bainewa wainuwatoi dididiga ya banavi tagu isagu aubaina.” ");
INSERT INTO kqf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kamaina bi Ananaiyas i nawa vanuwemo i valageta. Te nimana Sol dabanemo i sako bi i giuwena gado, “Valetigu Sol, etaḡa kuna natonato bi Bada Yesu lisimmo i laulau maḡatana, taunana i giukamaḡegu te tam kwai kita munaḡa bi Aluwa Waiyawa yai wanavum.” ");
INSERT INTO kqf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Laḡannemo Ananaiyas nimana Sol dabanemo i sakosako ba maḡemota mwali kitedi maibena iyana vevedi matanemo a kuluva bi matana i layana munaḡa, moito bi Ananaiyas Sol i kabulu. ");
INSERT INTO kqf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kamaina bi Sol kani i kani te ena ḡailisi i vai munaḡe. Sol Damaskasmo tauwaikaiwatana vaitena a taumiyamiya laḡan visa. ");
INSERT INTO kqf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ḡome bolu vanuwidiḡa i nawa bi lauguguya i waitubuna gado, “Yesu tana Maimaituwa Natuna.” ");
INSERT INTO kqf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ḡome tedi mabai a vaivaiyena ba a tagugu bi ai giugiuna gado, “Niga olotona tana taunana Yelusalem noponemo Yesu tauwaisumaḡena i kaka gebogebodi. Bi niganana i tava niga ḡome bi tauwaisumaḡa ya pani nawedi Yelusalemmo pilipilisi edi babada lisidimo.” ");
INSERT INTO kqf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bi geḡa te Sol ena lauguguya i ḡailisi gulata bi i kamaḡati kauwe te Yesu tana Maimaituwa ena Vinevine. Bi Diu lavedi Damaskasmo miyemiyedi mote ḡemoḡemotina te Sol vaitena sai kagiu. ");
INSERT INTO kqf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Laḡan wapawapa a kovi mulidimo Diu lavedi ḡome miyemiyedi ai ḡemotidi bi Sol kana pota a yesi te maso ai peki. ");
INSERT INTO kqf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bi geḡa te lava ḡesaudi Sol a tainuwatau. Bi Diu lavedi suwala bi dudubala tedi malagai ganakukuna mataetina a yaveyave te Sol maso i laupotiyovo bi ai peki. ");
INSERT INTO kqf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Taunana aubaina dudubala ḡemota Sol ena lava kaikaiwatana dou noponemo a suveki bi ganakuku koiyavusinemo ai dawe yovoḡe. ");
INSERT INTO kqf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Laḡannemo Sol Yelusalemmo i tava bi i ḡoe te maso tauwaikaiwata vaitedi ai ḡemotidi bi tedi matabudi a naile bi mote ai sumaḡe te tana tauwaikaiwatana ḡesauna. ");
INSERT INTO kqf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kamaina bi Banabas, Sol i waidoli nawe giugiukamaḡedi lisidimo bi i giuwedi te bainewa Sol i nawanawa Damaskas bi etamo Bada lisinemo i laumaḡata. Bi kota i giuwedi te Sol bainewa Damaskasmo ma laudabatolana Yesu isana i lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ḡome Sol tauwaikaiwatana vaitena a miya bi Yelusalem malagaina noponaḡa ma laudabatolana Bada isana i laulauguguya nawe. ");
INSERT INTO kqf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Bi kota Diu lavedi Gulik kalinedi taugiuwena vaitedi ai kagiu bi a wai saḡasaḡa. Bi tedi a ḡoeḡoena maso Sol ai peki. ");
INSERT INTO kqf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bi laḡannemo tauwaisumaḡa a vaivaiye ba tedi Sol ai doli nawe Seseliya bi a giukamaḡe i nawa Tasis. ");
INSERT INTO kqf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mba laḡandimo Maimaituwa ena dam lavedi Diudiya, Galili bi Sameliya dobudimo miyemiyedi tedi nuwedi i kena. Bi Aluwa Waiyawa ena ḡailisimo tedi i laibagidi te a ḡailisi. Tedi Maimaituwa a vivivile bi ena dam iyevina i dididiga. ");
INSERT INTO kqf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mba laḡandimo Pita i nawa dobu bi dobu bi kota Laida malagaina noponemo tauwaisumaḡa i vakitedi. ");
INSERT INTO kqf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ḡome tana oloto isana Aniyas i banavi bi tana sida tunipekipeki i vai bi i kenana kwalabu 8 a kovi. ");
INSERT INTO kqf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bi Pita i giuwena gado, “Aniyas, Yesu Keliso i wai yawasanim, ku moito em kebana kwa noku.” Noi taunana te Aniyas i yawasana te kenamoito. ");
INSERT INTO kqf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mba ḡome Laida bi Salon malagaidi lavedi matabudi, mainana a kitakita ba a nuwavitaledi bi Bada ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bi kota Diyopa malagainemo tauwaisumaḡa waivinina i miyamiyana isana Tabita. (Gulik kalinedimo isa Tabita ba Dokas). Tana laḡan matabuna kauwa visuvisudi i voivoiyedi bi lava wainuwatoitoidi i sagusagudi. ");
INSERT INTO kqf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Laḡan ḡemota tana i sida kauwa te i peki. Kamaina bi tubuḡina a koḡa bi a avali saḡe noke bena wailabunemo a sako. ");
INSERT INTO kqf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bi Laida malagaina ba Diyopa diyanemo, taunana aubaina tauwaisumaḡa Diyopamo a vaiye te Pita Laidamo i miyamiya. Kamaina bi olooloto labu a giukamaḡedi te Pita sai baḡana gado, “Aee, ku nato makai lisimaimo.” ");
INSERT INTO kqf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kamaina bi Pita niga oloolotodi vaitedi a munaḡa Diyopamo. Laḡannemo tedi ḡome a tava ba Pita ai doli saḡe noke bena wailabunemo. Bi iwape matabudi Pita a moito kwaivivili bi a ḡabaḡaba. Tedi kwama bi gala Dokas ma miyanemo i voivoiyedina Pita ai love. ");
INSERT INTO kqf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ḡome Pita matabudi i giuwedi te a potiyovo vanuwa dibunemo. Bi tana tuwapekana i waitupagwaliḡe bi i laupali. Bi i tauvitale te waivini pekipekina i kita bi i giuwena gado, “Tabita, ku kenamoito.” Tana matana i layana bi laḡannemo Pita i kitakita ba i kenamoito. ");
INSERT INTO kqf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita nimana i tuḡu bi waivini nimanemo i kabi te i solu waimoito. Ḡome tana, iwape bi tauwaisumaḡa i yogedi a saḡa bi i wailovedi te waivini i yawasana munaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lava matabudi Diyopa noponemo bai i tubutubuḡana giuna a vaiye bi lava wapewapedi Bada Yesu ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita oloto isana Saimon vaitena Diyopamo laḡan wapewapedi a miyamiya. Bi Saimon ena noya ba musala kwapidi i kopedi bi i waikunekuneyedi. ");
INSERT INTO kqf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Seseliya malagainemo oloto isana Koniliyas i miyamiya, tana ba tauwaiḡaviya edi bada, sawai isedina Itali potumina. ");
INSERT INTO kqf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tana ba lava didimanina bi ena vanuwa lavedi matabudi Maimaituwa a laulauduneye. Tana laḡan matabuna Diu lavedi wainuwatoitoidi i sagusagudi bi kota Maimaituwa lisinemo i laulaupali nonoḡa. ");
INSERT INTO kqf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bi laḡan ḡemota suwala 3-ya okoloki mainana bi Koniliyas wailove i kita, wailovenemo ba Maimaituwa ena aneya i laumaḡata bi i giuwena gado, “Koniliyas.” ");
INSERT INTO kqf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniliyas ma nailina tana i kitadidi bi i giuna gado, “Bada bai kwa ḡoeḡoe?” Bi aneya i giuwena gado, “Em pali bi em waisagu lava wainuwatoitoidi lisidimo Maimaituwa i sibe bi nuwana kuna laukwasili. Tam em pali maibena sewasewa sa gabugabuna panena. ");
INSERT INTO kqf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Taunana aubaina niganana olooloto ḡesaudi kwa giukamaḡedi te sa nawa Diyopa bi ḡome oloto isana Saimon bi wai isaisa ba Pita sai doli natome. ");
INSERT INTO kqf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tana ena tau ḡesau Saimon musala kwapidi taukopedi ena vanuwemo ya miyamiya. Mba vanuwina ba nisa diyanemo.” ");
INSERT INTO kqf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Laḡannemo aneya giu i wai kovi bi i nawanawa ba Koniliyas ena taupaula labu bi ena tauwaiḡaviya ḡemota i giuwedi a tava. Bi tauwaiḡaviya tana ba Maimaituwa taulauduneyena. ");
INSERT INTO kqf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bi bai matabuna i tubutubuḡana i giuvitedi bi i giukamaḡedi a nawa Diyopa malagainemo. ");
INSERT INTO kqf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bokinamai suwala modomo niga oloolotodi nuwedi tava Diyopamo bi Pita vanuwa dabanemo i saḡa laupali aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tana kani i peki bi i ḡoeḡoe te maso bai i kani. Bi laḡannemo kani vanuwemo a kaka nonoḡi ba kota wailove i kita. ");
INSERT INTO kqf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ḡome Pita mala nuwawasana i kita. Bi mwali kitana maibena kadawali dididiga liuna 4 isunemo bi isunemo a kabi bi ai dawe yovoḡe dobumo. ");
INSERT INTO kqf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bi geina noponemo ba musala kitedi tabudi bi tabudi a miyamiya. Musala kaḡediḡa nawenawedi, daledaledi bi lovolovodi. ");
INSERT INTO kqf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kamaina bi kalina malaḡa i yovona gado, “Pita ku moito bi niga muselidi kwa vunudi bi kwa kanidi.” ");
INSERT INTO kqf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bi Pita i giuna gado, “Mm Bada, geḡa ota! Tagu mote bai bamo milamilana ee waiyawa e kani eete niganana.” ");
INSERT INTO kqf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bi kalina i giu munaḡana gado, “Mote bai mwalina Maimaituwa i kaka visuvisuna kuma giuwe te milamilana.” ");
INSERT INTO kqf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Niga kauwina i tubuḡana ma faiona. Kamaina bi kadawali maḡemota a munaḡe malamo. ");
INSERT INTO kqf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ḡome Pita yaḡolo wailove i kitakitana banina i noḡonoḡoti waitete ba Koniliyas olooloto i giugiukamaḡedina Saimon ena vanuwa a banavi. Tedi vanuwa ganakukuna mataetinemo a vamoito. ");
INSERT INTO kqf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bi vanuwa taniwagina ai talayena gado, “Niga ḡome lava isana Saimon Pita ya miyamiya e geḡa?” ");
INSERT INTO kqf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bi Pita yaḡolo wailove i kitakitana i noḡonoḡoti wata ba Aluwa Waiyawa i giuwena gado, “Saimon, olooloto faiona sa tavutavuḡem. ");
INSERT INTO kqf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Taunana aubaina kwa moito bi kwa potiyovo doḡamo bi mote nawa vaitedi nuwam ima laḡalaḡae. Banina niga lavedi ba tagu e giukamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ḡome Pita i potiyovo doḡamo bi olooloto i giuwedina gadoaubaina, “Egu lava, tagu taunana ko tavutavuḡegu. Bai aubaina kona tava?” ");
INSERT INTO kqf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kamaina bi olooloto a giuna gado, “Tama tauwaiḡaviya edi bada Koniliyas i giukamaḡemai. Tana ba lava didimanina bi kota Maimaituwa taulaudunena bi Diu lavedi matabudi tana sa vivivile. Bi Bada ena aneya waiyawa i giuwe te tam i ḡoemna kwa nawa ena vanuwemo bi bai kwa giuwe te ya vaiye.” ");
INSERT INTO kqf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kamaina bi Pita olooloto i giuvaidi te vaitedi sa kena. Bokinamai Pita i vononoḡa bi olooloto faiona vaitedi a modina. Bi kota tauwaisumaḡa ḡesaudi Diyopamo vaitedi a nawa Seseliya. ");
INSERT INTO kqf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tedi laḡan i sako kaka Seseliyamo a tava. Koniliyas bi ena dam lavedi bi kota ena lava kauwa i giuwedi te ai ḡemotidi bi Pita a labelabe te ya tava. ");
INSERT INTO kqf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Laḡannemo Pita i valavalageta vanuwemo ba Koniliyas i nato Pita matanemo bi tuwapekana i waitupagwaliḡe bi i lauduneye. ");
INSERT INTO kqf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bi geḡa te Pita, Koniliyas nimanemo i kabi te i solu waimoito bi i giuwena gado, “Ku moito, tagu lava ota mai tam.” ");
INSERT INTO kqf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tedi ma waigiugiudi a valageta vanuwemo. Bi ḡome lava wapewapedi i kitedi ai ḡemotidi bi a wailaba. ");
INSERT INTO kqf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kamaina bi Pita i giuwedina gado, “Temi kona sibe te tama Diu ema waiḡake te Eteni lavedi vaitedi kamai ḡemotimai, ee lisidimo kama nawa. Bi geḡa te Maimaituwa i wailovegu, te mote yàmai noḡota gado, ‘Eteni lavedi ba lava milemiledi bi ani kitakamaḡa.’ ");
INSERT INTO kqf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Taunana aubaina laḡannemo egu giu kuna giukamaḡe ba mote yà giuvitale gado. Bai aubaina egu giu kuna giukamaḡe?” ");
INSERT INTO kqf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Bi Koniliyas, Pita ena giu i waimunena gado, “Laḡan faiona a kovi, egu vanuwemo suwala 3 okoloki e laulaupali bi aneya ena gala waimatakanikanina i wai maḡemoti te matagumo i moito kamaḡe, ");
INSERT INTO kqf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","bi i giuweguna gado, ‘Koniliyas em pali i vaiye bi em waisagu lava wainuwatoitoidi lisidimo Maimaituwa i sibe. ");
INSERT INTO kqf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lava ḡesaudi niganana kwa giukamaḡedi sa nawa Diyopamo, te lava isana Saimon sawai isana Pita sa giuwe te ya nato. Tana ba taomana bi Saimon musala kwapidi taukopedi vaitena sa miyamiya bi ena vanuwa ba nisa diyanemo.’ ");
INSERT INTO kqf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Taunana aubaina tagu em giu maḡemota e giukamaḡe. Bi i visu te kuna tava. Bi niganana Maimaituwa matanemo matabumai kei ḡemotimai, te Bada bai i giugiuwemna matabudi kwa giuwemai te ka vaiye.” ");
INSERT INTO kqf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ḡome Pita giu i waitubuna gado, “Niganana kaka e sibe kauwe te Maimaituwa lava matabudi ya ḡoeḡoedi bi Diu lavedi mote taudiḡa. ");
INSERT INTO kqf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dobu matabuna noponemo mabai Maimaituwa sa laulauduneye bi kauwa didimanidi sa voivoiyedina ba ya wai aninedi. ");
INSERT INTO kqf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Temi kona sibe te Maimaituwa giuna visuvisuna i giukamaḡe Islael lavedi lisidimo, te laḡannemo mabai Yesu Vinevinena Kamaḡena sai sumaḡena ba Maimaituwa nuwauba ya vitedi. Yesu taunana mwali matabuna tauwaibadayena. ");
INSERT INTO kqf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bai matabuna Diudiya noponemo i tubutubuḡana temi kona sibe. Yesu giuna visuvisuna Galilimo i tubuḡa, Diyon kabulu i lauguguyae mulinemo. ");
INSERT INTO kqf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","“Mba laḡannemo Maimaituwa, Aluwa Waiyawa bi ḡailisi Nasalet Yesuna i wai wanavu. Bi tana mba dobuna i nawa yaḡosi bi kauwa visuvisudi i voivoiyedi bi lava mabai aluwa gebogebodi a sunesuneḡidina i waiyawasanidi banina Maimaituwa tana vaitena. ");
INSERT INTO kqf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Tana kauwa matabudi Diudiya bi Yelusalem noponedimo i voivoiyedina tama mataotimaimo ke kitedi. Tana kolosimo a tupalatu te i peki. ");
INSERT INTO kqf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bi geḡa te laḡan waifaioninemo, Maimaituwa pekimo i ka kenamoito bi i voiye te tama lisimaimo i kamaḡati. ");
INSERT INTO kqf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bi pekimo kenamoito mulinemo tana mote lava matabudi a kita bi tama Maimaituwa i gei vinemai te ke kita, vaitena ke kani bi ke tego. ");
INSERT INTO kqf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Bi i giu vavasaḡemai te tama lava lisidimo ka lauguguya bi ka giuwedi te tana taunana Maimaituwa i vine te lava miyemiyedi bi pekipekidi ya etaledi. ");
INSERT INTO kqf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Taugiuwatana matabudi tana a giuwata, te lava matabudi tana sai sumaḡena ba Yesu isanemo Maimaituwa edi gebogebo ya noḡotikamaḡedi.” ");
INSERT INTO kqf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita yaḡolo i giugiu ba Aluwa Waiyawa i yovo lava matabudi ena giu a vaivaiyena lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Diu lavedi waisumeḡidi ḡesaudi Pita vaitena a natonatona, tedi a tagugu. Banina Maimaituwa puyo Aluwa Waiyawa i giukamaḡe yovoḡe Eteni lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bi tedi a vaiyedi te kalina ḡesaudi mote a sibedi bi a gagagaliyedi bi kota Maimaituwa a kaka saḡesaḡe. Kamaina bi Pita i giuna gado, ");
INSERT INTO kqf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tagu e noḡoti te niga lavedi maso gaubemo te ka buludi bi mote aiyai i mai ḡakeda. Banina tedi kaikana Aluwa Waiyawa a vai, mai tada.” ");
INSERT INTO kqf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ḡome Pita i giuwedi te tedi Yesu Keliso Kamaḡena isanemo sa kabuludi. Kamaina bi Pita ai baḡa te vaitena ḡome sa taumiya laḡan visa. ");
INSERT INTO kqf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Giugiukamaḡedi bi tauwaisumaḡa Diudiyamo a vaiye te Eteni lavedi Maimaituwa giuna a vai. ");
INSERT INTO kqf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Taunana aubaina laḡannemo Pita Yelusalemmo i tavatava ba Diu lavedi tauwaisumaḡa Pita a giuvitavitalena gado, ");
INSERT INTO kqf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Tam bai aubaina kuna nawa Eteni lavedi edi vanuwemo bi vaitedi kona kanikani?” ");
INSERT INTO kqf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Taunana aubaina Pita lisinemo baibaiḡa a tubutubuḡana matabudi i giu waiipoipo lava lisidimo gado, ");
INSERT INTO kqf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Laḡan ḡemota tagu Diyopamo e laulaupali bi wailove e kita. Bi mwali kitana maibena kadawali dididiga liuna 4 malaḡa ai dawe yovoḡe matagumo. ");
INSERT INTO kqf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bi kadawali nopona e kitakita ba dobumo ḡamoḡamo kitedi tabudi bi tabudi suwana, malamalaḡamidi bi mwanuwa lovolovodi. ");
INSERT INTO kqf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kamaina bi kalina malamo i giuweguna gado, ‘Pita ku moito, kwa vunudi bi kwa kanidi.’ ");
INSERT INTO kqf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Bi tagu e giuwena gado, ‘Mm Bada, geḡa ota! Tagu mote bamo musala milemiledi e kanidi, eete niganana.’ ");
INSERT INTO kqf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Bi kalina malamo i giu munaḡana gado, ‘Bai mwalina Maimaituwa i kaka visuvisuna mote kuma giuwe te milamilana.’ ");
INSERT INTO kqf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Niga kauwina ma faiona i tubuḡa. Kamaina bi bai matabuna a solu saḡe munaḡe malamo. ");
INSERT INTO kqf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Noi taunana te olooloto faiona Seseliyaḡa a giugiukamaḡedina a tava, vanuwa e miyamiyanemo. ");
INSERT INTO kqf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bi Aluwa i giuwegu te mote yà nuwalalaḡa bi vaitedi ka nawa. Niga lavedi 6 waisumeḡidi vaitedi Diyopamo te ke nawa Sisaliyia bi matabumai Koniliyas ena vanuwemo ke valageta. ");
INSERT INTO kqf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ḡome Koniliyas i giuwemai te bainewa aneya ena vanuwemo i laumaḡata bi giuwena gado, ‘Olooloto ḡesaudi kwa giukamaḡedi Diyopamo, ḡome lava isana Saimon bi wai isaisa ba Pita sai doli natome. ");
INSERT INTO kqf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tana giu visuvisuna ya natome te tam bi em vanuwa lavedi matabumi ko yawasana.’ ");
INSERT INTO kqf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Laḡannemo giu e wai tubu ba Aluwa Waiyawa i yovo lisidimo, maibena dolinemo tada lisidemo i yovoyovona. ");
INSERT INTO kqf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kamaina bi ḡome Bada bai i giugiuwena e noḡoti, ‘Diyon gauba otamo i waibulu bi temi kaka Aluwa Waiyawemo ko bulu.’ ");
INSERT INTO kqf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tada wala Bada Yesu Keliso tei sumaḡe bi Maimaituwa puyo Aluwa Waiyawa i viteda, niganana ḡemotina kota Eteni lavedi i vitedi. Taunana aubaina tagu mote egu ḡailisi bai te Maimaituwa ena kauwa yài ḡake.” ");
INSERT INTO kqf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Laḡannemo niga giudi a vaivaiyedi ba Pita a giugiuvitavitalena a kaisako bi Maimaituwa a ka saḡesaḡena gado, “Giukauwa te niganana kaka ke sibe te Maimaituwa Eteni lavedi i waianinedi te sa lau kuvasa bi yawasana kenakena nonoḡina sa vai.” ");
INSERT INTO kqf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Laḡannemo laukivigebogebo i tubuḡa bi Stivin a waipeki ba tauwaisumaḡa ḡesaudi a dabalala. Tedi a nawa Fonisia wapunemo, Saiplas bwanabwananemo bi Entiyok tauninemo. Bi ḡome Diu taudiḡa lisidimo giu visuvisuna a lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bi tauwaisumaḡa ḡesaudi oloolotodi Saiplasiḡa bi Sailinḡa, tedi kota a nawa Entiyokmo bi Eteni lavedi lisidimo Bada Yesu giuna visuvisuna a lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tedi Bada ena ḡailisimo lava wapewapedi a vitaledi bi Bada ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Laḡannemo Maimaituwa ena dam Yelusalemmo niga giuna a vaivaiye ba Banabas a giukamaḡe i nawa Entiyok. ");
INSERT INTO kqf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Laḡannemo Banabas Entiyokmo i tavatava ba Maimaituwa ena laukivivisuvisu lava lisidimo i kita. Ḡome tana i wainuwavisu bi i laibagidi te nuwedi tabutabunemo Bada lisinemo sa moito didina. ");
INSERT INTO kqf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas tana lava visuvisuna bi i waisumeḡi guletina nopona Aluwa Waiyawa i waiwanavu. Taunana aubaina lava wapewapedi a nato te Bada ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kamaina bi Banabas bi i nawa Tasis Sol tavuḡena aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bi laḡannemo i banabanavi ba i waidoli natome Entiyokmo. Bi ḡome tedi tauwaikaiwatana vaitedi kwalabu ḡemota a miya bi lava wapewapedi a wailovelovedi. Mba lagannemo Entiyokmo tauwaisumaḡa wai isedi ai tubuna gado, “Maimaituwa ena dam lavedi.” ");
INSERT INTO kqf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mba laḡandimo taugiuwatana ḡesaudi Yelusalemḡa a tava Entiyokmo. ");
INSERT INTO kqf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bi ḡemota isana Agabas i miya moito te Aluwa Waiyawa ena sagumo, Loum dobuna matabuna noponemo gomala dididiga ya tubuḡana i gei giuwata. (Niga gomelina ba Kolodiyas ena waibada laḡannemo i tubuḡa). ");
INSERT INTO kqf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taunana aubaina tauwaikaiwatana Entiyokmo ai ogatala te edi banava luvanemo edi puyo a giukamaḡedi tauwaisumaḡa Diudiyamo miyemiyedi aubaidi. ");
INSERT INTO kqf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tedi edi puyo Banabas bi Sol nimedimo a sivudi te a nawedi Yelusalemmo tauwaisumaḡa edi babada lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mba laḡandimo ḡalibona Alodi Maimaituwa ena dam ḡesaudi i panidi bi i laukivigebogeboyedi. ");
INSERT INTO kqf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tana Diyon tuwaḡana Diyemes kwatikwatimo i wai peki. ");
INSERT INTO kqf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bi laḡannemo Alodi i kita te Diu lavedi nuwedi i visu kauwa, kauwina i voivoiyena aubaina ba kota i giu te Pita ya pani. Bi Buledi mote muu'a vaitena soina noponemo i pani. ");
INSERT INTO kqf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kamaina bi Alodi tauwaiḡaviya i giuwedi te Pita biliwelokomo a sako nawe. Bi tauwaiḡaviya dubudi 4 bi nopodiḡa ba wapedi 4 a sivunawedi te Pita a kita wata. Tana i ogatala te vawaitauli soina mulinemo maso Pita biliwelokomo ika potiyovo lava kumna matedimo te maso i etale. ");
INSERT INTO kqf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kamaina bi Pita biliwelokomo a labe bi Maimaituwa ena dam ba nopodi tabutabudimo tana aubaina Maimaituwa lisinemo a laulaupali. ");
INSERT INTO kqf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bokinamai Alodi Pita maso i kapotiyovona etala aubaina ba mba dudubalinemo Pita lava tauwaiḡaviya labu mododimo i kenakena. Bi tana seini labu a lau paniyedi, ḡemota kataiyanemo bi ḡemota ḡeniyanemo. Bi mba seinidi ḡemotidi isudi ba tauwaiḡaviya nimedimo ai ḡalodi. Bi biliweloko mataetinemo ba tauyava a moimoito. ");
INSERT INTO kqf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bi i wai maḡemoti te Bada ena aneya i lau moitoe bi Pita ena ani kena gabuna i lai yana. Bi tana Pita giligilinemo i laidagu bi i giuwena gado, “Ku kenamoito makai!” Kamaina bi mba seinidi nimanemo a nuwa kamaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ḡome aneya Pita i giuwena gado, “Em gala bi em kaḡesuma kwa kotedi.” Bi Pita mainana i voiye bi kota aneya i giu munaḡe, “Niganana em kwama dabanemo kwa kote bi kwa kaiwatagu te ta potiyovo.” ");
INSERT INTO kqf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kamaina bi Pita aneya i kaiwata bi biliweloko a potiyovo kamaḡe. Bi tana mote i sibe te aneya bai i voivoiye, bi mba kamaina kauwa banina i tubutubuḡa bi tana i wainoḡotana benakage wailove i kitakita. ");
INSERT INTO kqf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tedi tauyava laumatamo bi laumulimo a vawaitaulidi bi a potiyovo malagai etana mataetinemo. Mba mataetina guduna ba ilama bi ḡome a tavatava ba mataetina nuwanemo i nuwa kamaḡe bi aneya Pita vaitena a yovo a taunawanawa bi aneya i wai maḡemoti te i yaufa. ");
INSERT INTO kqf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ḡome kaka Pita bai lisinemo i tubutubuḡana i noḡoti bi i giuna gado, “Niganana e sibe kauwe te giukauwa Bada ena aneya i giukamaḡe te Alodi ena ḡailisimo bi Diu lavedi edi ogatala gebogebodimo tagu i wai yawasanigu.” ");
INSERT INTO kqf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ḡome kaka Pita ena noḡota i kena kauwa bi i nawa Meli ena vanuwemo, natuna Diyon isana ḡesauna ba Mak. Bi lava wapewapedi ena vanuwemo ai ḡemotidi bi a laulaupali. ");
INSERT INTO kqf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kamaina bi Pita gudu taulinemo i laupewapewa bi taupaula waivinina isana Loda, tana mataeta kaikamaḡena aubaina i nawa. ");
INSERT INTO kqf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bi laḡannemo Pita kalinana i vai ḡone ba nuwana i lauvisuvisu bi gudu kaikamaḡena nuwana i yavuḡa bi i velau i munaḡa bi i giuna gado, “Pita mataetamo ya moimoito.” ");
INSERT INTO kqf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bi tedi a giuwena gado, “Tam kuna bu'uwa, ee?” Bi geḡa te tana i giu laukasaḡaiḡai, aubaina tedi a giuna gado, “Augunai Pita meyauna.” ");
INSERT INTO kqf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bi Pita yaḡolo te i laulaupewapewa. Ḡome tedi mataeta a kaikamaḡe bi Pita a kitakita ba a ai sovesove. ");
INSERT INTO kqf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bi Pita nimanemo i wai katitawedi te maso a miya moimoisili. Ḡome tana i giuwedi bainewa Bada biliwelokomo bi i ka potiyovona. Bi tana i giuwedina gado, “Niga kauwina Diyemes bi tuwatuwaḡana ḡesaudi vaitedi ko giuwedi!” Kamaina bi tana i potiyovo munaḡa te i nawa dobu ḡesaunemo. ");
INSERT INTO kqf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Olaolalemo tauyava ai nuwanaina gulata bi nuwedi i lovo bi a giuna gado, “Pita lisinemo bai i tubuḡa?” ");
INSERT INTO kqf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Alodi i vaiye te Pita biliwelokomo i potiyovo ba giu i sako te sa tavuḡe bi mote a banavi aubaina biliweloko tauyavena i wai talavitavitaledi bi i giuvavasaḡa te sai pekidi. Ḡome Alodi dobu Diudiya i gose bi i nawa Seseliyamo i taumiya. ");
INSERT INTO kqf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Bi Alodi tana Taiya bi Sidon lavedi lisidimo nuwana i medi kauwa. Taunana aubaina edi babada a giukamaḡedi Alodi lisinemo. Bi tedi Alodi ena vanuwa taulabena isana Blastas a gei waitauwe. Bi a giuwe te tana maso Alodi i kanuwabigabiga. Banina tedi mba ḡalibonana ena dobumo kani a vaivai. ");
INSERT INTO kqf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ḡome Alodi laḡan i vine te maso mba laḡannemo ai ḡemotidi. Kamaina bi laḡanna i sakosakonemo ḡalibona galedi i kotedi bi ena animiya gabunemo i miya bi lava lisidimo i gagali. ");
INSERT INTO kqf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ḡome ena giu noponemo lava kalinedi dididiginemo a binauna gado, “Niga ba maimaituwa kalinana, mote mai lava!” ");
INSERT INTO kqf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Banina tana mote Maimaituwa isana i ka saḡesaḡe. Taunana aubaina Maimaituwa ena aneya Alodi i doulikwa doḡamo i talaḡa bi bwagana mwatamwata a kani te i peki. ");
INSERT INTO kqf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bi Maimaituwa giuna i didiga bi i dabalala. ");
INSERT INTO kqf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Laḡannemo Banabas bi Sol edi noya Yelusalemmo a wai kovi ba tedi Diyon isana ḡesauna Mak, vaitena a munaḡa Entiyok. ");
INSERT INTO kqf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bi Entiyokmo Maimaituwa ena dammo taugiuwatana bi tauwailovelove a miyamiya. Tedi isedi ba Banabas, Simiyon isana ḡesau Duba, Sol, Lusiyas tana Sailin lavana bi Manen tana ḡalibona Alodi vaitena a didiga ḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Laḡannemo tedi Bada a laulauduneye bi a udiudi ba Aluwa Waiyawa i giuwedina gado, “Banabas bi Sol ko vinedi banina tagu e yogedi te egu noya sa voiye.” ");
INSERT INTO kqf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ḡome tedi a udi, a laupali bi nimedi Banabas bi Sol dabedimo a sivudi kaka a giukamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sol bi Banabas Aluwa Waiyawa i giukamaḡedi a nawa dobu Selusiya bi ḡome kukakukamo a gelu a nawa Saiplas bwanabwananemo. ");
INSERT INTO kqf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Laḡannemo tedi Salamisimo a tavatava ba Diu lavedi edi bolu vanuwidiḡa Maimaituwa giuna a lauguguyae. Bi ḡome ba tausagudi Diyon Mak vaitena. ");
INSERT INTO kqf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bi tedi Saiplas bwanabwanana a nawa yaḡosi eete Papos tauninemo a tava. Bi ḡome tedi taugiuwatana kaikaiyovuna Diu olotona a banavi. Tana lava bwalabwalauna isana Bar-Yesu. ");
INSERT INTO kqf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bi tana ba gabemani Segiyas Polas ena tau. Segiyas Polas tana lava nuwanuwa uyauyana, Maimaituwa giuna vaiyena i ḡoeḡoe taunana aubaina Sol bi Banabas i giuwedi te ena vanuwemo a saḡa. ");
INSERT INTO kqf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bi taubwalau Gulik kalinedimo sa wai isana Elimas, tana kota Sol bi Banabas edi giu i laulaupali-ibedi. Banina tana i ḡoeḡoe te Plimiya Segiyas maso mote Sol bi Banabas edi giu i wai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bi Sol isana ḡesauna Pol tana Aluwa Waiyawa nopona i waiwanavu bi taubwalau matana i kitadidi ");
INSERT INTO kqf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","bi i giuwena gado, “Tam penama natuna, kaiyovu bi gebogebo nopom i waiwanavu. Tam visuvisu matabudi sa natonatona kwa laulaupali-ibedi. Bi Bada giuna didimanidi laḡan matabuna kwa lailaibaledi. ");
INSERT INTO kqf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Taunana aubaina niganana Bada ya kovoḡim bi matam ya paya te laḡan visa nopodimo suwala mote kuma kita.” Noi taunana te boimatuwa pilina i waikwesi tawa te i waikaibwasoku nawa bi i ḡoeḡoe te aiyai maso nimanemo i kabi bi i waidoli. ");
INSERT INTO kqf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Laḡannemo Plimiya Segiyas bai i tubutubuḡana i kitakita ba i tagugu gulata bi Bada giuna a wailovelovena i waisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Laḡannemo Pol bi ena tausagu vaitedi dobu Papos a gose bi kukakukaḡa a nawa Pega tauninemo Pamfilia plovinsnemo. Mba ḡome Diyon Mak ena lava i gose kamaḡedi bi i munaḡa Yelusalem. ");
INSERT INTO kqf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ḡome tedi Pegamo bi a nawa Entiyok malagainemo Pisidiya plovinsnemo. Bi waiyawasi laḡannemo tedi a nawa bolu vanuwinemo a miyatulu. ");
INSERT INTO kqf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ḡome bolu vanuwina babadidi, waiḡake giudi bi taugiuwatana kalinedi a gilugilumidina a iyevidi. Mulinemo tedi Banabas bi Pol ai baḡedina gado, “Tuwatuwaḡamai bamoda temi lisimimo laibagi giudi lava aubaidi ba kamaina te ko giu.” ");
INSERT INTO kqf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol i miya moito te nimanemo lava i waikatitawedi a miyamoimoisili bi i giuna gado, “Temi Islael lavemi bi Eteni lavemi mabai Maimaituwa taulauduneyena koi beyavaiya. ");
INSERT INTO kqf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Islael lavedi edi Maimaituwa wala eda magumagula i vinedi bi i voiyedi te Islael damna i didiga. Bi Idip dobunemo a miyana mai tautavatava. Bi Maimaituwa ena ḡailisimo eda magumagula Idipmo i kapotiyovodi bi i waidoli nawedi. ");
INSERT INTO kqf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bi kwalabu 40 nopodimo kalakalalelemo avena te a kaka manisobala bi kamaina te i labelabe kauwedi. ");
INSERT INTO kqf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tana dobu wapana 7 Keinan noponemo lava i ḡosedi bi dobudi ena lava Islael i vitedi te sai taniwagaye. ");
INSERT INTO kqf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kwalabu wapana 450 nopodimo niga kauwidi matabudi a tubuḡa. “Mulinemo Maimaituwa Islael lavedi taulaididimana i vitedi bi a miyana eete taugiuwatana Samuwel ena sauga i tava. ");
INSERT INTO kqf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mba laḡannemo Islael lavedi ḡalibona a ḡoe, taunana aubaina Maimaituwa Sol i vitedi. Sol ba Kis natuna Bendiman damnemo. Tana i wai ḡalibona bi i labedi te kwalabu 40 a kovi. ");
INSERT INTO kqf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“Kamaina bi Maimaituwa Sol i kaikamaḡe mulinemo Deivida i voiye te edi ḡalibona bai i giugiuwena luvanemo. Tana niga mainana i giu, ‘Diyesi natuna Deivida tagu e kita banavi, tana taunana nopogu ena ḡowana. Tana kaka egu ḡowana matabuna ya voiyedi.’ ");
INSERT INTO kqf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Deivida ena tubulelesemo Maimaituwa Tauwaiyawasana Yesu i giukamaḡe Islael lavedi lisidimo, mai nove wala i giugiuwapana luvanemo. ");
INSERT INTO kqf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bi muliḡa kaka Yesu i tava ena noya i waitubuna ba dolinemo Diyon i gei tava te i lauguguya Islael lavedi lisidimo te maso a nuwavitala bi i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Laḡannemo Diyon ena noya i wai waikovi ba i giuwedina gado, ‘Temi ko noḡonoḡotigu te tagu aiyai? Temi male tagu ko noḡonoḡotigu te Tauwaiyawasana. Geḡa, tagu mote Tauwaiyawasana. Lava muliguḡa ya natonatona tana taunana Tauwaiyawasana. Tagu mote ḡemoḡemotigu te ena kaḡesuma yà kaikamaḡe.’ ");
INSERT INTO kqf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Temi tuwatuwaḡagu Eiblaḡam natunatuna bi temi Eteni lavemi mabai Maimaituwa taulauduneyena, koi beyavaiya. Maimaituwa tada aubaida yawasana giuna i giukamaḡe lisidemo. ");
INSERT INTO kqf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bi Diu lavedi edi babada vaitedi Yelusalemmo miyemiyedi ba mote a sibe te Yesu tauwaiyawasana bi a giu te sai peki. Bi laḡannemo a waipeki ba taugiuwatana a gilugilumina, waiyawasi laḡandimo a iyeiyevi nonoḡena banina i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tedi Yesu lisinemo mote bai gebona a banavi bi geḡa te Paelat ai baḡa te Yesu ai peki. ");
INSERT INTO kqf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Bi laḡannemo niga kauwidi matabudi taugiuwatana a giugiuwedina, lava a voivoiye kovi Yesu lisinemo ba taubeuna kolosi modonemo a avali yovoḡe bi tauyewamo a sako. ");
INSERT INTO kqf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bi kota Maimaituwa pekimo i ka kenamoito. ");
INSERT INTO kqf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Bi tedi mabai tana vaitena a bababalana Galilimo te Yelusalemmo lisidimo laḡan wapewapedi i laumaḡata. Bi matedimo a kitakitana taunana niganana sa giu nawe lava lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Bi tama niganana niga giuna visuvisuna ka giugiuwemi: Niga giuna Maimaituwa tamatamada lisidimo wala nove i giuwapaye. ");
INSERT INTO kqf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Niganana natunatudi tada lisidemo banina i kamaḡati te Yesu tana pekimo i ka kenamoito. Sale 2 noponemo niga mainana i giu, ‘Tam natugu bi niganana tagu tamam.’ ");
INSERT INTO kqf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Maimaituwa Yesu pekimo yaka kenamoito bi mote ima bova ba ena giugiu niga mainana, ‘Tagu kavisuvisu bi yawasana waiyawa yà vitemi mai wala Deivida i giugiuwapaeyena luvanemo.’ ");
INSERT INTO kqf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Bi gilugilumina ḡesaunemo kota mainana i giu, ‘Tam em taupaula Waiyawa mote kuwai anine te tauyewamo ima bova.’ ");
INSERT INTO kqf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Niganana Deivida ta kita, tana ena laḡanimo Maimaituwa ena ḡowana i voivoiye bi i peki te tauyewamo tamatamada diyedimo taubeuna a sako bi i bova gwasa. ");
INSERT INTO kqf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bi kota niga lavana Maimaituwa ika kenamoito te mote i bova. ");
INSERT INTO kqf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Taunana aubaina, egu lava! Tama niganana lisimimo ka laulauguguya te Yesu ko sibe kauwe te tana dabanemo kaka Maimaituwa emi gebogebo ya noḡotikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bi Mousis ena waiḡake mote ḡemoḡemotina te ima ka didimanimi. Temi Yesu koi sumaḡena ba emi gebogebo ya noḡotikamaḡe bi yaka didimanimi. ");
INSERT INTO kqf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bi ko kita kauwa te bai taugiuwatana a giugiuwena lisimimo mote sima tubuḡa. Tedi niga mainana a giu, ");
INSERT INTO kqf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Koi beyavaiya, temi waidiboḡimi, ko kita kauwa. Temi koi nuwanaina te ko peki. Banina temi emi laḡanmo tagu niganana bai yà voiyena, ba mote komai sumaḡa. Bi bamo te aiyai lisimimo ya giuna, ba yaḡolo mote komai sumaḡe.’” ");
INSERT INTO kqf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Laḡannemo Pol bi Banabas bolu vanuwina a potipotiyovo kamaḡe ba lava tedi a giuwedi te waiyawasi laḡanina ḡesaunemo maso a nato munaḡa bi giudi a laukaukauwedi. ");
INSERT INTO kqf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tapalolo mulinemo Diu bi Eteni lavedi mabai nuwedi a nuwanuwavitalana Pol bi Banabas a kaiwatedi bi tedi lava a laibagidi te Maimaituwa ena laukivivisuvisu sai sumaḡedidi bi sa miyae. ");
INSERT INTO kqf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bi waiyawasi laḡanna ḡesaunemo ḡotona te maso malagai lavedi matabudi a tava kovi ai ḡemotidi, Bada giuna vaiyena aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bi ḡome Diu lavedi a kita te lava kumna giu awai beyavaiye ba tedi Banabas bi Pol a unuledi bi Pol bai i giugiuwena a giuvitavitale. ");
INSERT INTO kqf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol bi Banabas ḡome ma laudabatoledi a giuna gado, “Tama kamaina te Maimaituwa giuna lisidimo ka giu doliye. Bi anikitana ba kona daboke bi giuna kenakena nonoḡina mote koma ḡoeḡoe. Taunana aubaina tama niganana ka gosemi bi ka nawa Eteni lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Baninana Maimaituwa niga mainana i giuwemai, ‘Tagu e vinem te tam Eteni lavedi edi yanayana. Bi tam taunana yawasana giuna kwa giu nawena dobu isuna te isuna.’” ");
INSERT INTO kqf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Laḡannemo Eteni lavedi niga giuna a vaivaiye ba nuwedi i visu bi Bada a kasaḡesaḡe tana giuna aubaina. Bi mabai Maimaituwa i vinedi bi sa waisumaḡana ba yawasana kenakena nonoḡinemo sa saḡa. ");
INSERT INTO kqf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bi Bada giuna mba dobuna matabuna i nawa yaḡosi. ");
INSERT INTO kqf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bi Diu lavedi a miya moito te Eteni waivinidi isanawenawedi Maimaituwa taulauduneyena bi malagai babadidi laukaidi nuwedi a liudi bi a kanuwa medimedidi. Kamaina bi edi dobumo Pol bi Banabas a laukivi gebogeboyedi bi a kwavivaidi ");
INSERT INTO kqf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Taunana aubaina Pol bi Banabas kaḡedi gobusidi ḡome a lai kulukuludi bi a gosedi a nawa Ikoniyam malagaina. ");
INSERT INTO kqf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ḡome tauwaikaiwatana Aluwa Waiyawa i waiwanavudi te ai nuwavisu bi a yasisi. ");
INSERT INTO kqf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniyam malagainemo Pol ena vaivai luvanemo Banabas vaitena a nawa Diu lavedi edi bolu vanuwinemo. Ḡome tedi a lauguguya bi edi lauguguya ba i ḡailisi kauwa, te Diu bi Eteni lavedi wapawapa otidi Yesu ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ḡome Diu lavedi mabai waisumaḡa a daboka tedi taudidi Eteni lavedi nuwedi a liudi te a medi tauwaisumaḡa lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol bi Banabas ḡome a taumiya bi malaudabatoledi Bada Yesu a giuwata. Bi Bada ḡailisi i vitedi te mataila bi anisove kauwidi a voiyedi. Ḡome Bada ena lau kivivisuvisu lisidimo lava a kita. ");
INSERT INTO kqf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bi mba malagainemo lava a daili munaḡedi te nevedi Diu vaitedi ai kalinakabiyedi bi nevedi Pol bi Banabas vaitedi ai kalinakabiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Taunana aubaina Diu bi Eteni edi babada ai ḡemotidi te Pol bi Banabas kedi pota a yesi, te maso a laukivigebogebodi bi ḡakimemo maso a laipekidi. ");
INSERT INTO kqf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bi laḡannemo pota a yesiyesina giuna a vaivaiye ba kandavonaḡa a nawa Lista bi Debi malagaidimo, Likoniyam plovinsina noponemo. Bi mba malagaidi nananakidi bi diyediḡa, ");
INSERT INTO kqf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tedi edi noya a laumunaḡe bi Yesu giuna visuvisuna a lauguguya nawe. ");
INSERT INTO kqf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lista malagaina noponemo oloto kaḡena nuwanokuna mai i tubuḡae bi mote i nawanawa. ");
INSERT INTO kqf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tana i miya bi Pol ena giu i vaivaiye bi Pol mba olotona i kitadidi te tana ba i waisumaḡa te ya yawasana. ");
INSERT INTO kqf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ḡome Pol kalinana dididiginemo i giuwena gado, “Ku miya moito!” I waimaḡemoti te oloto i laupoti saḡa bi nawa i waitubu. ");
INSERT INTO kqf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Laḡannemo Pol mai i voiye bi lava a kitakita ba tedi Likoniyam kalinedimo a binauna gado, “Po-oi, niga maimaituwedi labu ba ailalava ota bi niganana a yovo lisidemo!” ");
INSERT INTO kqf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tedi Banabas ai isana Sus bi Pol ai isana Emes banina tana taugagali. ");
INSERT INTO kqf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Bi maimaituwa Sus ena pilisi ena ani laudunena vanuwina ba malagai eta lovolovotavinemo i moimoito, kamaina bi Sus ena pilisi bi lava a ḡoe te kau tamokanidi bi belana dulidulidi edi puyo a natomedi te ḡome a lausewasewa Pol bi Banabas lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Laḡannemo giugiukamaḡedi Pol bi Banabas mai a vaivaiyedi ba tedi edi gala a lisidi bi a velau a nawa lava kumna nopodimo bi kalinedi dididiginemo a giuna gado, ");
INSERT INTO kqf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Olooloto bai aubaina mai ko voivoiye? Tama lava ota, mai temi! Tama giu visuvisuna ke natome te ko vaiye bi nuwemi ko vitaledi. Mba maimaituwidi waibanigeḡedi ko gose kamaḡedi bi Maimaituwa miyamiya nonoḡina lisinemo ko nawa bi ko lauduneye. Banina tana taunana mala, dobu, nisa bi bai matabudi nopodimo i voiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tana wala lava matabudi i kita kamaḡedi te edi ḡowanaḡa a nawanawa. ");
INSERT INTO kqf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bi yaḡolo te ena laukivivisuvisu lisimimo yà kakamaḡati. Tana nabu i vitemi te emi pesi a dugaduga kauwa edi ilimo bi yà wai maulimi te kowai wainuwavisu.” ");
INSERT INTO kqf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Giugiukamaḡedi giu a wai waikovi ba lava matabudi a lautautau. Bi lava ḡesaudi yaḡolo a ḡoeḡoe te sa puyodi. ");
INSERT INTO kqf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ḡome Diu lavedi Entiyok bi Ikoniyamḡa a tavatavana edi giumo lava kumdi a ka manisobaledi. ");
INSERT INTO kqf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bi matabudi Pol a lauḡakimi bi a solu nawe malagai a potiyovo kamaḡe. Banina ai noḡota te tana bena i peki. Kamaina bi tauwaikaiwatana Pol a moito kwaivivili te i kena moito bi i munaḡa malagaimo. Bi bokinamai tana bi Banabas a nawa Debi malagainemo. ");
INSERT INTO kqf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mba malagainemo tedi giu visuvisuna a lauguguyae bi lava wapawapa a voiyedi te a nuwavitala bi Bada a kaiwata. Mulinemo tedi a munaḡa Lista, Ikoniyam bi Entiyok malagaidimo. ");
INSERT INTO kqf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ḡome tedi tauwaikaiwatana a laibagidi te waisumaḡemo sa moito didina bi a giuwedina gado, “Muliḡa kaka tada Maimaituwa ena waibadamo ta sola saḡana bi dolinemo waiwaiḡolana ta gei asiwi.” ");
INSERT INTO kqf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mba malagaidi nopodiḡa a nawanawa bi Maimaituwa ena dam lavedi nopodimo babada a vinedi, kaka bi a laupali, a udi bi Bada nimanemo a sivudi. Banina tana taunana a waisumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tedi Pisidiya plovinsnaḡa a nawanawana eete Pamfilia plovinsnemo a tava. ");
INSERT INTO kqf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bi Pega malagainemo Bada giuna a lauguguyae, i kovi bi a nawa Ataliya malagainemo. ");
INSERT INTO kqf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kamaina bi ḡome ai kaivitaledi te kukakukaḡa a munaḡa Entiyokmo. Dolinemo tauwaisumaḡa ḡome tedi Pol bi Banabas Bada nimanemo a sivudi. Bi ena laukivivisuvisumo noyana a nawenawena eete a tavaite munaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tedi ḡome a tava bi Maimaituwa ena dam lavedi matabudi ai ḡemotidi bi Maimaituwa bai matabuna i voivoiyedina lisidimo bi bainewa waisumaḡa etana i kaikaikamaḡena Eteni lavedi lisidimo taudidi a tai nuwataudi. ");
INSERT INTO kqf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pol bi Banabas ḡome tauwaikaiwatana vaitedi a miya gulata. ");
INSERT INTO kqf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pol bi Banabas Entiyokmo a miyamiya bi olooloto ḡesaudi Diudiyaḡa a yovo Entiyokmo bi tauwaisumaḡa a wailovelovedina gado, “Bamoda temi bi mote kwapibwali matailina ko vai, mai Mousis ena waiḡake luvanemo ba mote koma yawasana.” ");
INSERT INTO kqf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Niga giudi dabedimo Pol bi Banabas mba lavedi vaitedi ai saḡasaḡa. Taunana aubaina tauwaisumaḡa Entiyokmo Pol, Banabas bi tauwaisumaḡa ḡesaudi a vinedi bi sa ḡoeḡoe te sa giukamaḡedi Yelusalemmo. Bi ḡome tauwaikaiwatana bi waibabada nananakidi vaitedi kwapibwalina giugiuna sa laididimani. ");
INSERT INTO kqf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bi Maimaituwa ena dam, tedi a giukamaḡedi a nawanawa Fonisia bi Sameliya malagaidiḡa ba Pol bi Banabas tauwaisumaḡa a giuvitedi te Eteni lavedi ba a nuwavitala Maimaituwa lisinemo. Tauwaisumaḡa mai giuna a vaivaiye ba ai nuwavisu. ");
INSERT INTO kqf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bi laḡannemo Yelusalemmo a tavatava ba ḡome Maimaituwa ena dam lavedi, giugiukamaḡedi bi waibabada Pol ena lava vaitedi a giuvaidi. Bi ḡome Pol bi Banabas bai matabuna Maimaituwa lisidimo i voivoiyena taunana Yelusalem lavedi a giuvitedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bi kota Palisi nopodimo tauwaisumaḡa ḡesaudi a miya moito bi a giuna gado, “Mousis ena waiḡake luvanemo kamaina te Eteni lavedi kwapibwali sa vai.” ");
INSERT INTO kqf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ḡome giugiukamaḡedi bi waibabada ai ḡemotidi ai bolu bi niga pilipilina ai talapiliye. ");
INSERT INTO kqf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ai talapili gulata mulinemo Pita i miya moito bi i giuna gado, “Valevaletigu, temi kona sibe te dolinemo nopomimo tagu Maimaituwa i vinegu te egu giumo Eteni lavedi giu visuvisuna sai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Maimaituwa nopo matabuna taukitana i wai lovegu te tana Eteni lavedi i waianinedi te Aluwa Waiyawa ya vitedi mai wala tada. ");
INSERT INTO kqf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tana mote i waiseli te tedi tabudi bi tada tabuda. Tedi ai sumaḡa aubaina Maimaituwa nopodi i koḡedi bi edi gebogebo i noḡotikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Niganana bai aubaina ko kaka nuwalaḡelaḡedi? Tada ee eda magumagula wala mai niga vitana ava'avalina maso mote luvada te ta miya. Temi mai ko giugiuna ba Maimaituwa lisinemo ko waimenabala te ya medi. ");
INSERT INTO kqf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mainana koma giugiu. Bada Yesu ena laukivi visuvisu tei sumaḡe te yawasana te vai. Bi kota kauwina ḡemotina mainana Eteni lavedi lisidimo.” ");
INSERT INTO kqf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bolu lavedi matabudi a miya moimoisili bi Pol bi Banabas lisidiḡa Maimaituwa mataila bi anisove kauwidi Eteni lavedi lisidimo i voivoiyena lava a giuwedi bi a wai beyavaiya. ");
INSERT INTO kqf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Laḡannemo edi giu a wai kovi ba Diyemes i miya moito bi i giuna gado, “Valevaletigu, koi beyavaiyegu. ");
INSERT INTO kqf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Pita kaikana i gei giuweda te Maimaituwa Eteni lavedi i vinedi te tana ena lava otidi. ");
INSERT INTO kqf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Niga kauwina taugiuwatana a giugiuwena luvanemo ya tubutubuḡa. Mai taugiuwatana ḡemota ba niga mainana i gilumi, ");
INSERT INTO kqf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Laḡan muliḡa tagu yà nato munaḡa bi Deivida ena palai i laulaubulilina ba yà keli munaḡe. Bamo gavogavodi a nuwanuwa suwasuwana ba yà laivaliudi. ");
INSERT INTO kqf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tagu mai yà voiye te Islael miyamiya gwasedi sai sumaḡegu. Bi Eteni lavedi mabai e vinevinedina sai sumaḡegu bi yai badayedi. Niga Bada kalinana, tana taunana niga kauwidi ya voivoiyedi.’ ");
INSERT INTO kqf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Niga kauwidi yà giugiuwedina ba walaka lava a sibedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Taunana aubaina niga mainana egu noḡota: Eteni lavedi mabai Maimaituwa lisinemo a nawa bi sa waisumaḡena, mote tama ka nuwalaḡelaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Niganana maso tada pepa te gilumi bi te giuwedi te niga kauwidi mote sima voiyedi: Kani milemiledi koikoitau lisidimo laulau sewasewayedi mote sima kanidi, simai mwanemwanena yabayababa bi musala gadona vilivilisina ee kwasinina mote sima kani. ");
INSERT INTO kqf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Banina Mousis ena waiḡake wala te niganana waiyawasi laḡandimo malagai matabudi nopodimo bolu vanuwidiḡa sa iyeviyevi bi sa laulauguguya nonoḡedi.” ");
INSERT INTO kqf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ḡome tauwaikaiwatana, waibabada bi Maimaituwa ena dam lavedi matabudi a ḡoeḡoe te olooloto ḡesaudi maso sa vinedi te Pol bi Banabas vaitedi sa nawa Entiyok. Kamaina bi Diudas isana ḡesau Basabas bi Saelas a vinedi. Tedi ba tauwaisumaḡa taulauetadoliyedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Waibabada pepana niga oloolotodi nimedimo a sako. Bi pepana noponemo ba niga mainana a gilumi: Aisii valevaletimai ebomi, temi mabai Eteni ko waisumaḡana. Tama tuwatuwaḡemi, giugiukamaḡedi bi waibabada niga pepana ka gilugilumina tauwaisumaḡa niga dobudimo lisidimo: Entiyok, Sailiya bi Silisiya. ");
INSERT INTO kqf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tama ke vaiye te nopomaimo lava ḡesaudi a nato lisimimo bi edi giumo nuwemi a kalaḡelaḡedi bi ai nuwaboyemi. Tama mba lavedi mote kai aninedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Taunana aubaina matabumai kei anina te olooloto ḡesaudi ke vinedi, te niganana ema lava Pol bi Banabas vaitedi ka giugiukamaḡedi lisimimo. ");
INSERT INTO kqf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol bi Banabas mote peki a naile bi a vite munaḡedi eda Bada Yesu Vinevinekamaḡena aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Niga Diudas bi Saelas ka giugiukamaḡedi te pepamo bai ke gilugilumina taudidi mudu otidimo sa giuwemi. ");
INSERT INTO kqf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Aluwa Waiyawa bi tama kei anina ḡemota te mote kama kanuwalaḡelaḡemi bi kamaivitemi. ");
INSERT INTO kqf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bi niga kauwidi taudidi mote koma voiyedi: Koikoitau lisidimo kani laulau sewasewayena mote koma kani. Musala gadona vilivilisina ee ma kwasinina mote koma kani. Mote komai mwanemwanena yabayababa. Niga waiḡakedi ko kaiwatedina ba temi kamaina. Ebom ema lava matabumi. ");
INSERT INTO kqf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ḡome olooloto a giukamaḡedi bi a nawa Entiyok. Laḡannemo ḡome a tavatava ba tedi Maimaituwa ena dam lavedi matabudi ai ḡemotidi bi pepa a vitedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lavedi pepana a iyevi bi laibagi a vai te ai nuwavisu. ");
INSERT INTO kqf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Diudas bi Saelas ba taugiuwatana bi tauwaisumaḡa a laibagidi te ḡailisi sa vai. ");
INSERT INTO kqf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Diudas bi Saelas Entiyokmo a taumiya mulinemo, tauwaisumaḡa kavisuvisu giudimo a kavisuvisudi bi a giuwedi te manuwaubedi sa munaḡa taugiukamaḡedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol bi Banabas Entiyokmo a taumiya. Bi lava ḡesaudi vaitedi Bada giuna lava lisidimo a lauguguyae bi ai lovelovedi. ");
INSERT INTO kqf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tedi a miya laḡan visa a kovi mulinemo Pol ena tau Banabas i giuwena gado, “Goma, dolinemo bamo malagaidiḡa te laulauguguya nawana maiḡa kota ta munaḡa bi valevaletida ta vakitedi. Tedi bainewa edi miyamiya.” ");
INSERT INTO kqf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kamaina bi Banabas ena ḡowana ba Diyon isana ḡesauna Mak vaitena maso a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bi kota Pol i noḡoti te Diyon vaitena sa nawana ba mote i visu. Banina tana dolinemo Pamfiliamo i gose kamaḡedi. Bi tedi mote tana vaitena a noya. ");
INSERT INTO kqf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Niga kauwina dabanemo Pol bi Banabas ai kagiu gulata te a dailidi. Ḡome Banabas, Mak i waidoli bi kukakukaḡa a nawa Saiplasimo. ");
INSERT INTO kqf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bi kota Pol, Saelas i vine te tauwaisumaḡa tedi aubaidi a gei laupali te Bada ya labe kauwedi edi ani nawamo. ");
INSERT INTO kqf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tedi Sailiya bi Silisiya nopodiḡa a nawa bi Maimaituwa ena dam lavedi a lailaibagidi. ");
INSERT INTO kqf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol Debi bi Lista malagaidimo i tavatava ba ḡome tauwaikaiwatana isana Timoti i banavi. Tana tinana ba Diu lavana bi tauwaisumaḡa, tamana ba Gulik lavana. ");
INSERT INTO kqf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tauwaisumaḡa matabudi Lista bi Ikoniyam dobudimo miyemiyedi a giu te Timoti tana ba lava visuvisuna. ");
INSERT INTO kqf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Taunana aubaina Pol i ḡoeḡoe te Timoti yai doli bi sa nawa. Bi Pol kwapibwali i voiye Timoti lisinemo banina mba malagainemo ba Diu lavedi a miyamiya. Tedi kedi nawamo te Pol, Timoti lisinemo kwapibwali i voiye. Banina lava matabudi a sibe te tana tamana ba Gulik lavana. ");
INSERT INTO kqf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mulinemo tedi malagai bi malagai a nawaedi bi Yelusalemmo giugiukamaḡedi bi waibabada bamo giudi a wai aninedina taudidi lava a giuvitedi te maso a kaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Maimaituwa ena dam lavedi a voiyedi te edi waisumaḡa i ḡailisi. Bi laḡan matabuna tauwaisumaḡa iyevina i dididiga. ");
INSERT INTO kqf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Aluwa Waiyawa mote i wai aninedi te Pol ena tausagu vaitedi maso Maimaituwa giuna Eisiya plovinsnemo a lauguguyae. Taunana aubaina tedi Piligiya bi Galeisiya plovins nopodiḡa a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Laḡannemo tedi Misiya plovinsina platinemo a tavatava ba tedi a ḡoe te maso a nawa Bitiniya plovinsnemo bi geḡa te Yesu Aluwina mote i wai aninedi te ḡome sa nawa. ");
INSERT INTO kqf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Taunana aubaina tedi Misiya a vaitauli bi a yovo a nawa ota Tolas malagainemo. ");
INSERT INTO kqf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mba dudubalinemo Pol wailove i kita. Tana Mesidoniya olotona i kita matanemo i moito bi i wai baḡana gado, “Aee, kwa damana nato Mesidoniyamo bi kwa sagumai!” ");
INSERT INTO kqf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol niga wailovena i kita mulinemo tama wailove aubaina ke novononoḡa makai bi ke modina Mesidoniya. Banina ke noḡoti te tama Maimaituwa i yogemai te ḡome tana giuna visuvisuna ka lauguguyaye lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tama Tolas ke gose bi kukakukaḡa ke damanana Samotes. Bi bokinamai ke damanana Nipolis. ");
INSERT INTO kqf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ḡome te kaḡemaiḡa ke nawa Filipai, mba Mesidoniya malagaina dididiga bi Loum gabemanina i waibadaye. Bi tama ḡome laḡan visa ke miya. ");
INSERT INTO kqf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bi waiyawasi laḡannemo tama malagai ke gose bi ke nawa gauba diyanemo ani laupali gabuna maso ke tavuḡe. Kamaina bi ḡome waivini awai ḡemotidina lisidimo ke tava, ke miyatulu bi ke lauguguya. ");
INSERT INTO kqf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mba ḡome waivini ḡemota isana Lidiya tana Maimaituwa taulauduneyena. Tana Taiyatila malagainemo gala laumolemoledi i voivoiyedi. Bi laḡannemo Pol i laulauguguya ba Bada Lidiya nopona i kaikamaḡe bi Pol, Yesu giuna i giugiuwena i vaiye kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bi tana bi ena vanuwa lavedi vaitedi ḡome a kabuludi. Mulinemo tana i giuvaimai ena vanuwemo bi i giuna gado, “Egu lava, temi kona noḡoti te tagu Bada tauwaisumaḡena ba yà waibaḡemi te ko nato egu vanuwemo ta miya.” Tana i waibaḡa gulatamai te nuwamai ke vitale te ke nawa ena vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Laḡan ḡemota tama ke nawanawa pali gabunemo bi taupaulayababa guguinina etamo ke banavi. Tana aluwa gebogebona i suneḡi bi kauwa bai noke matademo sa tubuḡana i geigei giuwatedi. Mba kauwinemo mane dididiga i voivoiye ena taniwaga aubaidi. ");
INSERT INTO kqf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Niga waivinina Pol bi tama i kaiwatamai bi i binabinauna gado, “Niga oloolotodi tedi Maimaituwa saḡasaḡa guletina ena taupaula! Tedi ba yawasana etana sa giugiuwemi!” ");
INSERT INTO kqf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Waivinina laḡan wapawapa i tava bi mai i voivoiye, eete Pol i ka tunidaboki. Bi Pol aluwa gebogebona i giuwena gado, “Yesu Keliso isanemo yà giugiu vavasaḡem te waivini kwa potiyovo kamaḡe!” Noi taunana te aluwa gebogebona i potiyovo kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Laḡannemo ena tanitaniwaga a kita te edi mane etana i nuwaḡavuka ba tedi a medi gulata, Pol bi Saelas lisidimo bi a vunudi bi a solu waga nawedi aniwai kunekune gabunemo, waibabada nimedimo a sivudi. ");
INSERT INTO kqf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kamaina bi tedi a nawedi taulauetala lisidimo bi a giuwena gado, “Niga Diu oloolotodi eda malagai sa kaka gebogebo. ");
INSERT INTO kqf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tedi vaivai tabudi a tavaitedi bi sa wailoveloveda, tada mote ḡemoḡemotina te mba vaivaidi ta kaiwatedi. Banina tada ba Loum lavada eda vaivai tabudi.” ");
INSERT INTO kqf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lava kumna ḡome ai ḡemotidi bi Pol bi Saelas a mediyedi bi taulauetala lava a egelidi te Pol bi Saelas edi gala a lisi kamaḡedi bi a kwapu yabayababedi. ");
INSERT INTO kqf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bi wai kwapu mulinemo a sivu nawedi biliwelokomo. Waibabada ḡome tauyava edi bada a giuwe te Pol bi Saelas ya kita watedi. ");
INSERT INTO kqf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Niga giuna luvanemo tauyava Pol bi Saelas biliweloko nopo otinemo i sivu nawedi bi kaḡedi kai tupidimo ai ḡaviti. ");
INSERT INTO kqf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dudubala modonemo mainana Pol bi Saelas Maimaituwa lisinemo a laulaupali bi a salesale. Bi edi lava biliwelokomo taumiya a vaivaiye watedi. ");
INSERT INTO kqf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kamaina bi i wai maḡemoti te yanigusugusu dididiga i tubuḡa. Bi biliweloko matabuna i waitalitali te mataeta gududi a nuwakamakamaḡa. Bi lava seinimo a panipanidina nuwedimo a nuwakamakamaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ḡome tauyava i kena tagugu bi i kita te biliweloko mataetidi nuwakamaḡedi. Tana maḡemota ena kepata i soluvai te maso i wai peki munaḡe. Banina i wai noḡota bena kage biliwelokomo taumiya a velau a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kamaina bi Pol i binauna gado, “Ei, kumai peki munaḡem! Tama matabumai niga!” ");
INSERT INTO kqf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tauyava ḡome ena lava ḡesaudi i binauwedi te kwadam a natome bi magusuna i velau Pol bi Saelas matedimo tuwapekana i wai tupagwaliḡe ");
INSERT INTO kqf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","bi i kapotiyovodi bi i wai talayedina gado, “Egu babada bai yà voiye bi yawasana yà vai?” ");
INSERT INTO kqf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bi tauyava ena giu ai munena gado, “Bada Yesu kwai sumaḡe bi kwa yawasana, tam bi em vanuwa lavedi matabumi.” ");
INSERT INTO kqf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pol bi Saelas Bada giuna tauyava bi ena vanuwa lavedi lisidimo a lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mba dudubalina kauwina mulinemo tauyava i wai doli nawedi bi bonidi i koḡedi, kaka bi Pol bi Saelas tauyava ena vanuwa lavedi vaitedi a kabuludi. ");
INSERT INTO kqf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kamaina bi tauyava i giuvaidi ena vanuwemo bi i wai kanidi. Ḡome tauyava bi ena vanuwa lavedi vaitedi ai nuwavisu gulata banina Maimaituwa ai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bokinamai olaolalemo taulauetala, tauwaiḡaviya a giukamaḡedi tauyava lisinemo bi a giuwedina gado, “Mba oloolotodi kwa giukamaḡedi bi sa nawa.” ");
INSERT INTO kqf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kamaina bi tauyava Pol i giuwena gado, “Taulauetala a giu te tam bi Saelas yà kaikamaḡemi te ko nawa. Taunana aubaina niganana manuwaubemi ko nawa.” ");
INSERT INTO kqf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bi Pol tauwaiḡaviya i giuwedina gado, “Geḡa mote mainana, tama Loum lavamai bi tedi mote a etala kauwemai bi lava kumna matedimo a kwapu yabayababemai bi biliwelokomo a sivunawemai. Bi niganana sa giugiu te kandavonemo sa kaikamaḡemai, mote mainana, tedi otidi ko giuwedi te sa nato niga ḡome bi sa kaikamaḡemai.” ");
INSERT INTO kqf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ḡome tauwaiḡaviya a nawa taulauetala lisidimo bi Pol bai i giugiuwedina a giuvitedi. Laḡannemo a vaiye te Pol bi Saelas tedi Loum lavedi ba a naila. ");
INSERT INTO kqf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Taulauetala a nawa Pol bi Saelas lisidimo te edi kauwa waigebo aubaina ai ebonedi bi biliwelokomo a kaikamaḡedi bi ai baḡedi te mba malagaina sa gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ḡome Pol bi Saelas a potiyovo bi didimanina a nawa Lidiya ena vanuwemo. Bi ḡome tauwaisumaḡa a banavidi bi a laibagidi, kaka bi malagaina a gose. ");
INSERT INTO kqf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tedi Empipolis bi Apoloniya malagaidi nopodiḡa a nawa ota te Tesalonia tauninemo a tava bi ḡome Diu edi bolu vanuwina a kita. ");
INSERT INTO kqf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kamaina bi Pol ena miyamiya luvanemo i nawa bolu vanuwinemo. Bi tana ḡome i miya bi waiyawasi laḡanidi faiona nopodimo wadubonemo gilugilumina i iyevidi ");
INSERT INTO kqf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","bi giudi banidi i kamaḡati bi i wailovelovedi te Keliso yai nuwatoi bi pekimo ya kenamoito. Pol i giuna gado, “Niga Yesuna yà laulauguguyaena ba tana taunana Keliso.” ");
INSERT INTO kqf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Edi lauguguyamo Diu lavedi ḡesaudi nopodi a kaikamaḡedi te Pol bi Saelas a kaiwatedi. Bi kota mainana Gulik lavedi Maimaituwa taulauduneyena wapewapedi bi kota waivini isanawenawedi vaitedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bi kota Diu lavedi a unula bi ani waikunekune gabunemo tauwaibeyapota ai ḡemotidi bi waimalumalu ai tubu. Bi a velau a nawa Deisen ena vanuwemo Pol bi Saelas a tavuḡedi te maso ai doli natomedi lava lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bi laḡannemo tedi mote a banavidi ba Deisen bi tauwaisumaḡa ḡesaudi a solu yovoḡedi te a natomedi tauni babadidi matedimo bi a binabinauna gado, “Pol bi Saelas taudidi dobu isuna bi isuna sa nawaye bi gebogebo sa voivoiye bi niganana lisidemo a tava. ");
INSERT INTO kqf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ḡome Deisen i giuvaidi te i nawedi ena vanuwemo bi sa giugiu te ḡalibona ḡesauna ba isana Yesu Tedi ba Sisa ena waiḡake sawai doukoto.” ");
INSERT INTO kqf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Laḡannemo lava kumna bi tauwaiḡaviya niga giudi a vaivaiyedi ba a medi bi a laimalumalu te waiḡasiḡasi i tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Taunana aubaina taun babadidi Deisen bi tauwaisumaḡa ḡesaudi a lauegelidi te sai mai'a lisidimo kaka sa kaikamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Laḡannemo dobu i wai dudubala ba tauwaisumaḡa Pol bi Saelas a giukamaḡedi Beliya malagainemo. Tedi ḡome a tava bi a nawa Diu edi bolu vanuwinemo. ");
INSERT INTO kqf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bi Beliya taunina lavedi nuwedi kaikaikamaḡedi mote mai Tesalonia lavedi. Banina tedi laḡan matabuna Maimaituwa giuna nuwedi tabutabunemo a vaiye bi nuwedimo a sivusivudi. Bi a kita te Pol gilugilumina wadubonemo bai i giugiuwena ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ḡome Diu lavedi wapewapedi ai sumaḡa. Bi kota Gulik oloolotodi bi waiwaivinidi isa nawenawedi ai sumaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bi laḡannemo Diu lavedi Tesaloniamo a vaiye te Pol Beliyamo Maimaituwa giuna i laulauguguyae ba tedi kota ḡome a nawa. Bi lava kumna nuwedi a liuwidi te a medi gulata Pol bi Saelas lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Taunana aubaina tauwaisumaḡa waiḡapa Pol a giukamaḡe makaiye i nawa gelemo. Saelas bi Timoti ba tedi Beliya tauninemo a miya. ");
INSERT INTO kqf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bi olooloto mabai Pol a wai doli nawena gelemo vaitedi a nawa Atens tauninemo. Ḡome Pol ena giu a munaḡe Beliya tauninemo te Saelas bi Timoti sa giuwedi te mulinaḡa sa nawa makai. ");
INSERT INTO kqf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atens tauninemo Pol ena lava Saelas bi Timoti i labelabedi bi i kita te mba malagaina ba koikoitau i wanavu, taunana aubaina i wainuwaboya kauwa. ");
INSERT INTO kqf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kamaina bi i nawa bolu vanuwinemo Diu bi Eteni lavedi vaitedi ai ogatala. Bi laḡan onena Eteni Maimaituwa taulaudunena bi mabai ani waiḡemota gabunemo a tavatavana vaitedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bi ḡome Epikuliya bi Stoiki dobudi oloolotodi nuwauyeuyedi Pol vaitena ai kagiu bi a giuwena gado, “Mba lavana giugiu bu'ubu'uwina bai ya giugiuwe.” Bi ḡesaudi ai talana gado, “Anivaiyena maibena walidobu maimaituwedi ya giugiuwedi.” Tedi mai a giuna banina Pol ba Yesu ena kenamoito i giugiuwata. ");
INSERT INTO kqf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Taunana aubaina Pol ai doli nawe oya Aliopagas dabanemo bi a giuwena gado, “Tama ka ḡoeḡoe te em wailovelove valivaliuna kwa giugiuwena ka sibe. ");
INSERT INTO kqf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Banina tam em giu ka vaivaiyedina ba tabu otidi. Tama ka ḡoeḡoe mba em wailovelove valivaliuna kwa giugiuwena banina ka sibe.” ");
INSERT INTO kqf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ḡome Atens lavedi bi tautavatava edi miyamiyamo laḡan matabuna mai sa miyaboni bi giu valivaliudi sa giuwatedi bi sa vaivaiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aleopagasmo ḡome bolumo babadidi matedimo i miya moito bi i giuwedina gado, “Atens lavemi, tagu e kitemi te maimaituwa tabudi bi tabudi ko laulauduneyedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Emi tauniḡa e nawanawa ba emi ani laudune koikoitaudi e kitedi. Bi olta ḡemota modonemo giu niga mainana a gilugilumina e kita: MAIMAITUWA MOTE AIYAI I SIBE AUBAINA. Niga Maimaituwina ko laulauduneyena ba mote ko sibe, taunana niganana yà kamaḡati lisimimo. ");
INSERT INTO kqf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Maimaituwa dobu matabuna noponemo mwali matabudi tauvoiyedi tana taunana galewa bi dobu yaibadedi. Bi tana mote lava nimedimo laudune vanuwidi, a ḡaleḡaledinemo ima miyamiya. ");
INSERT INTO kqf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bi lava mote ḡemoḡemotina simai kani bi sima labe tana mote bai ḡesauna lisidemo ima ḡoeḡoe banina tana taunana lava matabudi yawasi, yawasana bi mwali matabudi ya vitevitedi. ");
INSERT INTO kqf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pakanemo tana lava ḡemota i voiye bi lisinaḡa dobu matabuna noponemo lava a wapa. Bi ena ḡowanemo edi ani miya bi edi laḡan i sivudi. ");
INSERT INTO kqf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Maimaituwa mai i voiye te lava sai tavutavu gulata kaka tana sa banavi. Bi tana ba diyademo, mote manekina i lofa ḡemoḡemotaḡa lisidemo. ");
INSERT INTO kqf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tana dabanemo tada ta yawayawasana, ta nawanawa bi ta miyamiya. Maibena ḡesaumi emi sale a gilumidina gado, ‘Tada natunatuna.’ ");
INSERT INTO kqf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Banina tada Maimaituwa natunatuna, taunana aubaina maso mote ta noḡoti te tana koikoitau, mai lava edi sibemo bi anapumo goldimo, siluvamo bi ḡakimemo a voivoiyedina mainana. ");
INSERT INTO kqf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Banina wala lava Maimaituwa mote a sibe tedi bu'uwa ena miyamo a miyamiyana i kita kamaḡedi. Bi niganana dobu lava matabudi ya giugiuvavasaḡedi te sa laukuvasa. ");
INSERT INTO kqf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Banina tana laḡan i sako te lava didimaninemo ya etaledi. Maimaituwa oloto ḡemota i vine te mba laḡannemo etala yai badaye. Niga olotona taunana Maimaituwa pekimo i ka kenamoito munaḡe te lava matabuda ta kita bi ta sibe.” ");
INSERT INTO kqf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Laḡannemo pekimo kena moito giuna a vaivaiye ba Pol ai gwaigwaiye bi ḡesaudi a giuna gado, “Niga giuna ḡemotina laḡan ḡesaunemo kwa nato munaḡa bi kwa giuwemai te ka vaiye.” ");
INSERT INTO kqf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kamaina bi Pol bolu lavedi i gose kamaḡedi bi i nawa. ");
INSERT INTO kqf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lava visa lauguguya a vaivaiyena ba Pol a kaiwata bi Yesu ai sumaḡe. Mba lavedi ba Aleopagas olotona Diyonsi, waivini isana Damalesi bi lava ḡesaudi vaitedi. ");
INSERT INTO kqf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Niga kauwidi mulidimo Pol Atens i gose kamaḡe bi i nawa Kolinti. ");
INSERT INTO kqf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mba ḡome Diu olotona isana Akwila i banavi, tana Pontus plovinsnemo i tubuḡa. Bi mwanena Pilisila vaitena maḡo ota Italiḡa a tava. Banina ḡalibona Kolodiyas Diu lavedi matabudi i giuvavasaḡedi te Loum malagaina dididiga sa gose. Bi Pol i nawa kitedi aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol, Pilisila bi Akwila ba edi noya ḡemota palai tausiyaudi taunana aubaina vaitena a miya bi a noyanoya ḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bi waiyawasi laḡandi onedi Pol, Diu bi Eteni lavedi edi pali vanuwina noponemo i wai wailovelovedi te maso nuwedi i vitaledi. ");
INSERT INTO kqf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Laḡannemo Saelas bi Timoti Mesidoniyaḡa a tavatava ba tana palai voiyedi i kaisako bi laḡan matabuna Maimaituwa giuna i giugiuwata. Bi Diu lavedi lisidimo i kamaḡati kauwe te Yesu kamaina Tauwaiyawasana. ");
INSERT INTO kqf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bi Diu lavedi Pol ena giu a unule bi giuvitavitale, taunana aubaina ena gala gobusidi i lai kulukulu bi i giuna gado, “Bamoda yawasana mote koma banavi ba temi emi wavu bi wavumi taumiḡa ko avali munaḡe bi mote tagu. Niganana bi noke i saḡa i nawana ba tagu yà nawana Eteni lisidimo.” ");
INSERT INTO kqf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kamaina bi Pol pali vanuwina i potiyovo kamaḡe bi i nawa Taitos Diyastas ena vanuwemo, pali vanuwina diyanemo. Bi Taitos ba Maimaituwa taulauduneyena. ");
INSERT INTO kqf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bi Klispas tana bolu vanuwina tauwaibadayena, tana ena vanuwa lavedi vaitedi Bada Yesu ai sumaḡe. Bi laḡannemo Kolinti lavedi wapewapedi giuna visuvisuna a vaivaiye ba kota Yesu ai sumaḡe bi Pol i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Dudubala ḡemota Pol wailove i kita, Bada i laumaḡata lisinemo bi i giuwena gado, “Mote kuma naila, tam kamaina te Bada giuna kwa giuwata bi mote kuma miya moimoisili. ");
INSERT INTO kqf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Banina tagu tam vaitem bi mote aiyai kaka ima laukivigebogeboyem. Bi mba malagainemo ba egu lava wapewapedi sa miyamiya.” ");
INSERT INTO kqf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kamaina bi kwalabu ḡemota bi nawalai 6 nopodimo Pol ḡome i miya bi Maimaituwa giuna lava i wailovelovedi. ");
INSERT INTO kqf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Laḡannemo Galiyo, Akaiya plovinsina i waibadaye ba Diu lavedi ai ḡemotidi bi Pol a pani bi a natome bolu gabunemo lauetala aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tedi Pol ai wavu bi a giuna gado, “Niga olotona taunana lava nuwedi ya liuwidi bi Maimaituwa sa laulauduneye bi Loum ena waiḡake sa waidoukoto.” ");
INSERT INTO kqf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ḡome Pol maso giu i waitubuna ba Galiyo Diu lavedi i giuwedina gado, “Bamoda niga lavana bai i voiyewapa ee bai gebona dididigina i voiye bi ko waiwavuna mba ba kamaina tagu yai beyavaiyemi. ");
INSERT INTO kqf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bi niga waitaledi bi giudi ya giugiuwedina ba temi emi giugiu, isa bi emi waiḡake. Taunana aubaina temi taumiḡa ko viliyaḡosidi. Tagu mote yamai talapiliyedi.” ");
INSERT INTO kqf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Taunana aubaina tana i kwavivaidi bi etala gabuna a potiyovo kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ḡome Diu lavedi matabudi bolu vanuwina tauwaibadayena isana Sostenes a kaididi bi taulauetala matedimo a kwapu yabayababe. Bi Galiyo mote bai i giuwe. ");
INSERT INTO kqf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol Kolintimo i miya gulata kaka bi valevaletina i waiebonedi bi kukakukaḡa i nawa Sailiya, Akwila bi Pilisila vaitedi. Bi muliḡa kaka ya geluna ba Kenkeliya malagainemo dabana a suvi. Banina tana Maimaituwa lisinemo i giugiuwapana ena palatemo i tava. ");
INSERT INTO kqf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tedi Epeses tauninemo a tava bi ḡome Pilisila bi Akwila i gosedi bi tana i nawa bolu vanuwinemo bi Diu lavedi vaitedi awai talapili. ");
INSERT INTO kqf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bi Diu lavedi tana ai baḡa te maso vaitena a taumiyamiya kaka maso i nawa bi geḡa te tana i daboka. ");
INSERT INTO kqf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bi i modimodina ba i giuwedina gado, “Bamoda Maimaituwa ena ḡowana ba yà tava munaḡa lisimimo.” Kamaina bi Epeses i gose bi kukakukaḡa i nawa Seseliya. ");
INSERT INTO kqf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Laḡannemo Seseliyamo i tava, ba tana i nawa Yelusalemmo bi Maimaituwa ena dam lavedi i waiebonedi kaka bi i nawa Entiyok tauninemo. ");
INSERT INTO kqf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol Entiyokmo i taumiya kaka bi dobuna i gose bi i babala malagai te malagai Galeisiya bi Piligiya plovinsidi nopodiḡa bi tauwaikaiwatana matabudi i lailaibagidi. ");
INSERT INTO kqf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mba laḡandimo Diu olotona isana Apolos, tana dobu Aleksandiliya dobunemo i tubuḡa. Tana ba giugiu komakomanina bi gilugilumina wadubonemo i sibe kauwedi. Bi i nato Epeses tauninemo. ");
INSERT INTO kqf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bi Bada Yesu ena Yawasana Etana ai love kauwe. Tana Diyon ena kabulu giugiuna taunana i sibe kauwe. Bi nuwauyauya vaitena, Yesu i giuwata bi giukauwa i wailovelove lava lisidimo bi Yesu yaḡolo mote i sibe kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos malaudabatolana i nawa bolu vanuwinemo bi lauguguya i waitubu. Bi laḡannemo Pilisila bi Akwila ena giu a vaivaiye ba a giuvai te edi vanuwemo bi Maimaituwa giuna lisinemo a laididimani kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kamaina bi Apolos Akaiya plovinsina nawana i wainuwa noḡonoḡotae ba valevaletina Epesesmo pepa a gilumi nawena tauwaisumaḡa lisidimo Akaiya plovinsnemo te laḡannemo Apolos ya tavana ba tedi nimedimo. Apolos laḡannemo ḡome i tavatava ba Maimaituwa ena sagumo tauwaisumaḡa i sagu gulatedi edi sumaḡa i ḡailisi. ");
INSERT INTO kqf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tana ena giu i ḡailisi gulata te Diu lavedi edi giu i lauyovoḡedi lava kumdi matedimo. Banina tana gilugilumina wadubonemo i kamaḡati kauwe te Yesu tana kamaina Tauwaiyawasana. ");
INSERT INTO kqf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Laḡannemo Apolos Kolintimo ba Pol eta oyaḡa ani waivaḡavuka maiḡa i nawa te Epeses tauninemo i tava, mba ḡome tauwaikaiwatana ḡesaudi i banavidi. ");
INSERT INTO kqf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Bi i waitalayedina gado, “Laḡannemo konai sumaḡana ba Aluwa Waiyawa kona vai e geḡa?” Bi tedi a giuna gado, “Geḡa, tama mote bamo Aluwa Waiyawa giuna ka vaiye.” ");
INSERT INTO kqf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kamaina bi Pol i waitalayedina gado, “Temi bai kabuluna kona vai?” Bi tedi ena giu ai munena gado, “Diyon ena kabulu.” ");
INSERT INTO kqf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol tedi i giuwedina gado, “Diyon ena kabulu ba laukuvasa aubaina lava i kaka buludi. Tana lava i giuwedi te lava mulinaḡa ya natonatona sai sumaḡe, mba taunana Yesu.” ");
INSERT INTO kqf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Laḡannemo niga giuna a vaivaiye ba Pol Yesu isanemo i kabuludi. ");
INSERT INTO kqf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kamaina bi Pol nimana lava dabedimo i sivudi bi Aluwa Waiyawa i yovo dabedimo bi kalina ḡesaudimo a gagali bi Bada giuna a lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ḡome olooloto wapedi ba 12. ");
INSERT INTO kqf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bi nawalai faiona nopodimo Pol i nawa bolu vanuwinemo bi lava lisidimo ma laudabatolana Maimaituwa ena waibada i ka kamaḡati bi i giugiu vavasaḡedi te sa nuwavitala. ");
INSERT INTO kqf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bi tauwaikaiwatana ḡesaudi a laukasaḡaiḡai bi mote ai sumaḡa bi lava kumna matedimo Yawasana Etana a giugiu waigebogebo. Taunana aubaina Pol tedi i gosedi bi tauwaikaiwatana ḡesaudi i legaudi bi laḡan matabuna Tailanos ena giluma vanuwinemo a waitalapili. ");
INSERT INTO kqf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Niga noyana i velauna ba kwalabu labu a kovi. Taunana aubaina Diu lavedi matabudi bi Gulik mabai Eisiya plovinsnemo miyemiyedi matabudi Bada giuna a vaiye. ");
INSERT INTO kqf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bi Epeses noponemo Maimaituwa ena ḡailisi Pol i vite te tana mataila nananakidi i voiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ḡome lava Pol ena agesi bi ena gala a legaudi bi lava sidesidedi dabedimo a sivudi te a yawasana bi aluwa gebogebodi a potiyovo kamaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bi Diu lavedi ḡesaudi ba ginauli tauvoiyedi bi a babala nawa malagai te malagai bi aluwa gebogebodi a kwavikwavivaidi. Tedi niga ḡome a wai laulubu te maso lava aluwa gebogebona i sunesuneḡina maso Yesu isanemo a kwavivai. Tedi a giuna gado, “Yà giugiu vavasaḡem te Yesu, Pol i laulauguguyaena isanemo mba lavana kwa potiyovo kamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Niga kauwina ba Diu edi pilisi saḡasaḡa guletina isana Sikiva natunatuna oloolotodi wapedi 7 niga kauwina a voivoiye. ");
INSERT INTO kqf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bi aluwa gebogebona i giuwedina gado, “Tagu Yesu e sibe bi kota Pol e sibe bi temi mabai?” ");
INSERT INTO kqf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ḡome aluwa gebogebona oloto i suneḡi i potivai i kativunu yabayababedi, i laikofekofedi bi ma kwasikwasinidi te a velau ena vanuwa a gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Diu bi Gulik lavedi matabudi Epesesmo miyemiyedi niga kauwina a vaivaiye ba a naila gulata. Bi Bada Yesu isana a vivile kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bi lava wapewapedi mabai a wai sumaḡana tedi a nato bi edi kauwa gebogebodi a voivoiyedina lava kumna matedimo a kuvesidi. ");
INSERT INTO kqf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bi kota lava wapewapedi mabai ginauli a voivoiyedina matabudi edi ginauli bukedi ai ḡemotidi bi lava kumna matedimo ai kalaḡosedi. Bi buka ai ḡemotidi bi a iyevidina maso ba silva mane didigina 50 tausan luvana. ");
INSERT INTO kqf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kauwidi mainana a tubutubuḡa ba Bada giuna i ḡailisi bi i dabalala. ");
INSERT INTO kqf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Niga kauwidi a tubutubuḡana mulidimo ba Pol Yelusalem nawana i wai nuwa noḡonoḡotae, te maso Mesidoniya plovins bi Akaiya plovins nopodiḡa i nawa. Bi i giuna gado, “Dolinemo tagu yà gei nawa Yelusalem muliḡa kaka yà nawa Loum.” ");
INSERT INTO kqf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kamaina bi tausaguna labu, Timoti bi Elastas i gei giukamaḡedi Mesidoniyamo. Bi tana Eisiya plovinsnemo i taumiya. ");
INSERT INTO kqf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mba laḡannemo lava ḡesaudi Yawasana Etana aubaina a medi gulata bi waikagiu dididiga ai tubu. ");
INSERT INTO kqf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bi oloto isana Damatilis tana ena noya ba siluvemo pulapula i voivoiyedi. Bi kota siluvemo koikoitau waivinina Atemas ena vanuwa aluwidi i voivoiyedi. Niga kauwinemo Damatilis mane dididiga i voivoiye. Bi ena taupaula noya i vite nawedi bi pulapula tabudi bi tabudi a voivoiyedi. ");
INSERT INTO kqf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kamaina bi tana ena taupaula bi ena waibabada matabudi i yogedi a tava ai ḡemotidi bi i giuwedina gado, “Egu lava, kona sibe te niga noyanemo mane dididiga ta vaivai. ");
INSERT INTO kqf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Temi kona kita bi kona vaiye te niga lavana Pol lava wapewapedi niga Epesesmo nuwedi i liuwidi bi tada a goseda bi tana sa kaikaiwata. Niga kauwina mote niga ḡome taunaḡa bi Eisiya plovinsina matabuna. Tana ya giugiu te maimaituwa lava nimedimo a voivoiyedina ba mote maimaituwa giugiukauwidi. ");
INSERT INTO kqf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Niga giunemo niganana eda mane ani vaina etana i waidougudu. Bi ḡesauna ba niga mainana: Lava kaka Atemas ani lauduneyena vanuwina sa noḡoti waiubauba. Atemas tana Eisiya nopodiḡa bi dobu matabuna isana i dididiga bi lava matabudi sa laulauduneye bi niganana Pol ya kaka ḡaubo.” ");
INSERT INTO kqf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Laḡannemo lava kumdi niga giudi a vaivaiye ba a medi gulata bi a binauna gado, “Weo! Epeses maimaituwana Atemas saḡasaḡa guletina!” ");
INSERT INTO kqf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ḡome taun dididiga matabuna lavedi ai kaḡasiḡasi yabayababa bi Pol ena lava labu Mesidoniya lavedi tana vaitena a natonatona Epesesmo, ḡome lava kumdi Gaiyas bi Alistakas a kaididi bi etaḡa a solu nawedi ani waibolu gabunemo. ");
INSERT INTO kqf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bi Pol i ḡoeḡoe te maso i nawa lava kumdi nopodimo bi tauwaikaiwatana mote ai anine. ");
INSERT INTO kqf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bi kota mba plovinsina babadidi nananakidi Pol ena lava, tana ena giu a giukamaḡe te mote ima nawa ani waibolu gabunemo. ");
INSERT INTO kqf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ḡome lava kumdi ai nuwanaina. Taunana aubaina lava ḡesaudi kauwa tabudi a binabinauwedi bi kota lava ḡesaudi wali kauwa a binabinauwedi. Bi lavedi ḡesaudi mote a sibe te bai aubaina ḡome a tava. ");
INSERT INTO kqf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bi Diu lavedi Aleksanda a biulikwa nawe lava kumdi matedimo bi nimana i kailageti te maso Diu aubaidi i giu. ");
INSERT INTO kqf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bi laḡannemo gado sa kita ḡone te tana Diu olotona ba awa labu nopodimo matabudi a binauna gado, “Epeses maimaituwana Atemas saḡasaḡa guletina!” ");
INSERT INTO kqf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tauni dididiga badana ḡemota lavedi i giu waitautaudina gado, “Ei, Epeses lavemi, dobu matabuna a sibe te Atemas aluwina ḡakimina sawamo i kulukuluva yovona ani lauduneyena vanuwina ba Epeses lavada ta labelabe. ");
INSERT INTO kqf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Niga giudi ba giukauwa, mote aiyai ima giu waikaikaiyovuda. Taunana aubaina ko miya moimoisili, mote bai ḡesau koma voiye. ");
INSERT INTO kqf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Temi niga oloolotodi labu kona saḡe yababedi. Tedi mote eda ani laudune vanuwinemo a danene ee maimaituwa waivinina Atemas a giu waigebogebo. ");
INSERT INTO kqf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bamoda Damatilis ena taupaula vaitedi edi waiwavu aiyai lisinemo ba taulaididimana babadidi sa miyamiya bi kota etala laḡandi ai dubudi te sa kenakena te ḡome kaka maiia sa sako. ");
INSERT INTO kqf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Bi bamoda temi kauwa ḡesaudi koma ḡoeḡoedi, mba ba kamaina te bolu dididiginemo lava vaitedi bi ko kadidimanidi. ");
INSERT INTO kqf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bai te niganana i tubuḡana ba ani naila. Bi tada kaka niga pilipilina aubaina sai wavuda. Bi tada mote bamo eda giu ima kenakena te ta giu.” ");
INSERT INTO kqf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Niga giudi mulidimo tana lava i giukamaḡedi te a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bi pilipili a kovi mulidimo, Pol tauwaikaiwatana i giuwedi te a tava lisinemo. Bi i laibagidi, i waiebonedi bi i modina i nawa Mesidoniya plovinsnemo. ");
INSERT INTO kqf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ḡome i tava bi mba dobuna matabuna i nawa yaḡosi bi tauwaikaiwatana i lailaibagi nawedina eete Gulik plovinsnemo i tava. ");
INSERT INTO kqf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Bi ḡome i miyana nawalai faiona a kovi, i ḡoeḡoe te maso wagaḡa i nawa Sailiya. Bi i vaiye te Diu lavedi mba nawanemo sa ḡoeḡoe te maso sai peki, taunana aubaina nuwana i vitale te i munaḡa Mesidoniya noponaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bi olooloto ḡesaudi vaitena a nawana, isedi ba Sopata Pailas natuna, ena dobu ba Beliya, Alistakas bi Sekundas tedi Tesalonia lavedi, Gaiyas ba Debi dobuna lavana, Timoti bi Eisiya oloolotodi labu Titikas bi Tolofimas. ");
INSERT INTO kqf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Niga oloolotodi wagaḡa a gei doli a nawa Tolasimo a labelabemai. ");
INSERT INTO kqf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bi buledi tabatabana mote muu'a vaitena soina i kovi, tama kukakukamo ke gelu i Filipai taunina ke gose. Laḡan 5 mulidimo ke tava ema lava lisidimo Tolas tauninemo, ḡome vaitedi ke miya te laḡan 7 a kovi. ");
INSERT INTO kqf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wiki pakanemo ke tava kei ḡemotimai kani ḡemota aubaina bi Pol lava lisidimo i laulauguguya. Tana i noḡonoḡoti te bokinamai ya modina. Taunana aubaina tana i gagagalina eete dudubala modona. ");
INSERT INTO kqf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bi tama noke vanuwa benana waifaioninemo ke miyamiya, ḡome piupiu wapawapa a yanayana. ");
INSERT INTO kqf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bi bilibili koikoiyavusinemo ba ewali isana Yutikas i miya bi i waibeyavaiye. Bi laḡannemo Pol i giugiu wailofalofa ba Yutikas i yadoyadona eete i wainuwayavuḡa, kamaina bi i kuluva te bilibili taulinaḡa i yovo doḡamo i talaḡa. Bi a kaikailageti ba tana pekipekina. ");
INSERT INTO kqf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bi Pol i potiyovo bi Yutikas i ḡomotawi. Kamaina bi lava i giuwedina gado, “Mote komai nuwaboya, tana yawayawasanina.” ");
INSERT INTO kqf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ḡome Pol i valageta munaḡa vanuwemo bi buledi i kivi bi a kani bi i gagagalina eete dobu i yana te mba dobuna i gose. ");
INSERT INTO kqf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bi tauwaisumaḡa ai nuwavisu gulata te ewali i yawasana munaḡa, kamaina bi ai doli a nawa vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ḡome ke nawa wagamo ke gelu bi Pol i giuwemai te kaḡenaḡa yai vaḡavuka Asosi tauninemo kaka ya gelu. ");
INSERT INTO kqf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bi Asosi tauninemo i banavimai kaka wagamo kei gelu bi matabumai ke nawa Mitiliyen tauninemo. ");
INSERT INTO kqf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Laḡan i sako tama ke nawa dobu ḡesaunemo ke tava Kiyos bwanabwanana diyanemo. Bi laḡani wailabuna tama Samos bwanabwanana ke vaitauli bi laḡan waifaioninemo tama Militas tauninemo ke tava. ");
INSERT INTO kqf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol mote i ḡoe te Epeses tauninemo ka solasaḡa bi ḡome ka miya laḡan wapawapa Eisiya plovinsnemo taunana aubaina i ogatala te ke nawa ota. Bi Pol i ḡoe kauwe te ya nawa makai Yelusalemmo, te Pentikost soinemo maso i tava. ");
INSERT INTO kqf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Laḡannemo Militas tauninemo ke tavatava ba Pol giu i giukamaḡe nawe Epesesmo te Maimaituwa ena dam babadidi maso a nato lisinemo. ");
INSERT INTO kqf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bi laḡannemo a tavatava ba i giuwedina gado, “Dolinemo e tavana Eisiya plovinsnemo ba kona sibe bainewa laḡan matabuna vaitemi e miyana. ");
INSERT INTO kqf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Bi kona sibe te Diu lavedi a ḡoeḡoena maso a vunugu bi e sako yovoḡe munaḡegu bi pilipili nopodiḡa ma matasulugu Bada ena noya e voivoiye. ");
INSERT INTO kqf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bi temi kona sibe te laḡannemo e laulauguguyana mote bamo giu ḡesauna e nuwevi. Bi sagumi aubaina giu matabudi lisimimo e giu kovidi, lava boludi nopodiḡa bi vanuwa te vanuwa e nawa bi e wailovelovemi. ");
INSERT INTO kqf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Bi Diu bi Gulik lavedi e giuvavasaḡedi te edi gebogebomo sa nuwavitala bi sa nato Maimaituwa lisinemo, Bi eda Bada Yesu Tauwaiyawasana sai sumaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Bi niga giuna ko vaiye, Aluwa Waiyawa i lagetigu te yà nawanawa Yelusalemmo. Bi mote yà sibe te ḡome male bai lisigumo yà tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Bi e sibe bamo taunidiḡa yà nawanawana ba Aluwa Waiyawa yà taitainuwataugu, te Yelusalemmo kaka sa laukivi gebogeboyegu bi biliwelokomo sa sakogu. ");
INSERT INTO kqf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bi bamoda sai pekiguna ba kamaina, mba mote bai. Bi kauwa laubanina yà noḡonoḡotina ba egu noya, Bada Yesu i viteviteguna taunana yài kovi. Mba noyana ba Maimaituwa ena sagu bi giuna visuvisuna lava lisidimo yà lauguguyae. ");
INSERT INTO kqf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Bi niganana e sibe te lava matabumi lisimimo Maimaituwa ena waibada e lauguguyae bi mote kaka koma kita munaḡegu. ");
INSERT INTO kqf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Taunana aubaina niganana yà giugiuota, te lava matabuna kwasinina nimagumo e yasaḡi. ");
INSERT INTO kqf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Niganana yà giugiu vavasaḡemi te niga giudi mote komai aninedi emi yawasanamo mba temi emi wavu. ");
INSERT INTO kqf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Taunana aubaina ko labe munaḡemi bi kota tauwaisumaḡa ḡesaudi matabudi. Bamo taudidi Aluwa Waiyawa nimemimo i waidubudi te ko labedi, maibena tauwailabalaba sipu ya labedi bi ya kitakita watedina mainana. Niga lavedi matabudi Maimaituwa natuna kwasininemo i kune munaḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Bi e sibe te laḡannemo yà ḡosemina ba tauwailovelove kaikaiyovudi sa tava lisimimo bi lava waisumeḡidi sa kagebogebodi, maibena daḡasi gwegwena ya saḡa sipu nopodimo bi ya kaka gebogebodina mainana. ");
INSERT INTO kqf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bi kota temi nopomimo ba lava ḡesaudi sa moito bi Maimaituwa giuna sa kulavitale bi tauwaikaiwatana sa ai wainawenawemi te ko kaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Taunana aubaina koi kita kauwa bi ko noḡoti te tagu kwalabu faiona nopodimo dubala bi suwala, ma matasulugu wailovelovemi mote e kaisako. ");
INSERT INTO kqf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Niganana yà laukaikamaḡemi Maimaituwa nimanemo, ena sagumo giunemo ya kavisuvisumi bi sakosako liyedi vaitedi yawasana ko vai. ");
INSERT INTO kqf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tagu mote aiyai lisinemo goldi, ee silva, ee gala ei kitakonedi. ");
INSERT INTO kqf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Temi kona sibe te tagu nimagumo e noya bi mane e vai te egu lava vaitedi ema ḡowana voiyedi aubaidi. ");
INSERT INTO kqf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Bi bai matabuna e voivoiyedina ba ei lovemi, te temi maso mainana kona noya gulata te lava wainuwatoitoidi kona sagudi. Bada Yesu ena giu ko noḡoti, i giuna gado, ‘Vitemo ba wainuwavisu i dididiga guletina, kaka ta vaivaina.” ");
INSERT INTO kqf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Laḡannemo Pol giu waikovi ba matabudi tuwapekedi ai tupagwaliḡedi bi a laupali. ");
INSERT INTO kqf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tedi matabudi Pol nuwedi i poyae bi a yovuvai ai suluve bi ai yebone. ");
INSERT INTO kqf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bai i voiyedi bi a ḡabana ba ena giu a noḡoti te mote matana sima kita munaḡe. Kamaina bi ai doli nawe auwai gelunemo. ");
INSERT INTO kqf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Laḡannemo kei yeboyebona mulinemo, wagamo ke gelu bi ke nawa Kos bwanabwananemo ke tava. Bokinamai ke nawa Lodes bwanabwananemo bi ḡome te ke modina te ke nawa Patala malagainemo ke tava. ");
INSERT INTO kqf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ḡome waga ke banavi i damadamana Fonisia, kamaina bi ke gelu te ke nawa. ");
INSERT INTO kqf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Te Saiplas bwanabwanana ḡeniyamaimo ke kitakita bi ke vawaitauli te ke nawa Sailiya. Ḡome te ke nawa Taiya tauninemo ke vamoito bi wagamo ḡonaḡona kei yovodi. ");
INSERT INTO kqf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ḡome tauwaikaiwatana ke banavidi bi laḡan 7 vaitedi ke miya. Tedi Aluwa ena mayavaimo Pol a giuvavasaḡe te mote ima nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bi ema nawa saugina i tavatava ba ke modina ke nawa. Bi tauwaikaiwatana matabudi mwanemwanedi bi natunatudi vaitedi, matabumai malagai ke gose bi ke nawa gelemo. Bi matabumai tuwapekamai kei tupagwaliḡedi bi ke laupali. ");
INSERT INTO kqf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Bi kei ebonedi i kovi bi wagamo ke gelu bi ke nawa bi tedi a munaḡa malagaimo. ");
INSERT INTO kqf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bi Taiya tauninemo ke modina kamaina eete Tolemais dobunemo ke tava, ḡome tauwaisumaḡa ke yebonedi bi tedi vaitedi ke miyana laḡan ḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bokina mainana olaolalemo ke modina munaḡa te Seseliyamo ke tava. Bi ḡome ba Filip giu visuvisuna taulauguguyena ena vanuwemo ke miya, Filip ba wala tauwaisagu 7 a vinevinedina nopodimo ba tana ḡemota. ");
INSERT INTO kqf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tana natunatuna guguḡinidi 4 lava a sibedi te tedi ba Bada giuna visuvisuna giuwatana puyona a vai. ");
INSERT INTO kqf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ḡome ke miya laḡan visa a kovi mulidimo taugiuwatana isana Agabas Diudiyaḡa i yovo. ");
INSERT INTO kqf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Lisimaimo i nato bi Pol ena dagilolo i vai bi taunaḡa nimana bi kaḡena i panipanidi bi i giuna gado, “Aluwa Waiyawa i kamaḡati te Diu lavedi Yelusalemmo kaka niga dagilolo taniwagina, niga mainana kota sa pani bi Eteni lavedi nimedimo sa sako.” ");
INSERT INTO kqf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Sauginemo lava matabumai niga giuna ke vaivaiye ba tama bi lava ḡesaudi Pol kei baḡa vavasaḡe te mote maso i nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bi Pol edi giu i waimunena gado, “Temi bai aubaina ko ḡabaḡaba bi koi wainuwaboyaegu? Tagu e vononoḡa te Yelusalemmo sa panigu ee sai pekigu Bada Yesu isana aubaina.” ");
INSERT INTO kqf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bi laḡannemo mote luvamai te maso kei ḡake ba kamaina te ke miya moimoisili bi ke giuna gado, “Kamaina te Bada ena ḡowana luvanemo mainana ya tubuḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Niga kauwidi mulidimo ema ḡonaḡona ke vononoḡa ba ke saḡa ke nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Tauwaikaiwatana ḡesaudi Seseliyamo vaitedi ke nawa ḡemota, eete Manason ena vanuwemo a kavalagetimai te ḡome ke miya. Manason ba Saiplas olotona tana tauwaikaiwatana dolidolina. ");
INSERT INTO kqf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Laḡannemo tama Yelusalemmo ke tavatava ba tauwaisumaḡa ma nuwavisudi ai doli nawemai edi vanuwemo. ");
INSERT INTO kqf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bokinamai Pol bi tama ke nawa Diyemes kitana aubaina. Bi tauwaisumaḡa edi babada matabudi ḡome a miyamiya. ");
INSERT INTO kqf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol i waiebonedi bi bai matabuna ena noyamo Maimaituwa i voivoiyena Eteni lavedi lisidimo taunana i tainuwataudi. ");
INSERT INTO kqf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Niga giudi a vaivaiyedi ba Maimaituwa a kasaḡesaḡe. Bi Pol a giuwena gado, “Valetimai, niganana kwa kita Diu lavedi iyevina wapana tausan ai sumaḡa. Bi tedi matabudi nuwedi tabutabunemo Mousis ena waiḡake sa kaikaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bi a vaiye te tam Diu lavedi Eteni nopodimo sa miyamiyana kunai lovelovedi te Mousis ena waiḡake mote sima kaiwatedi te natunatudi lisidimo mote kwapidibwali sima voiye ee Diu edi vaivai mote sima kaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bi niganana tedi sa vaiye te tam kuna tavana. Ba tada bai ta voiye? ");
INSERT INTO kqf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Taunana aubaina bai ka giuwemna ba kwa voiye. Niga ḡome olooloto 4 giuwapa a voiyena Maimaituwa lisinemo ");
INSERT INTO kqf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mba oloolotodi kwa legaudi bi tedi vaitedi ko kavisuvisu munaḡemi. Bi tam aubaidi kwai maii'a bi tedi dabedi sa ḡalidi. Niga mainana kwa voiyena kaka lava sa sibe, te niga giudi matabudi lava sa giugiuwedina lisimmo ba mote giukauwa. Bi tam taumḡa ba Mousis ena waiḡake luvanemo kwa miyamiya. ");
INSERT INTO kqf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Bi Eteni lavedi mabai a waisumaḡana, tama edi pepa kaikana ke gilumidi bi ke giukamaḡe tedi, kani koikoitau lisidimo a laulau sewesewedina mote sima kanidi bi kota kwasina ee musala gadodi kikikidi mote sima kanidi bamoda mainana ba kwasina ko gei waitosi kamaḡe, kaka ko kani. Bi mote komai mwanemwanena yabayababa.” ");
INSERT INTO kqf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bokinamai Pol mba oloolotodi i legaudi bi a kuvesi munaḡedi. Ḡome tedi a nawa pali vanuwina noponemo bi Pol pilisi i giuwedina gado, niganana giuwapa laḡanina i tubuḡa. Bi laḡan 7 mulidimo tada ḡemoḡemotaḡa kavisuvisu puyona ta tavaitedi. ");
INSERT INTO kqf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","Laḡan wai 7-na nuwana kovi, Diu lavedi ḡesaudi Eisiya plovinsnaḡa tavetavedi. Tedi Pol pali vanuwina noponemo a kita bi ḡome lava a kanuwa medimedidi te maso Pol a kaididi. Tedi mainana a giuna banina dolinemo Pol bi Tolofimas a kitedi Yelusalem tauninaḡa a nawanawa. Bi tedi ai noḡoti bena Pol Tolofimas i dolinawe pali vanuwinemo. Bi kalinedi dididiginemo a giuna gado, “Islael lavemi, ko sagumai! Niga olotona dobu matabuna i nawa bi lava i wailovelovedi te Diu edi waiḡake mote sima kaiwatedi. Bi tana giumo pali vanuwina i kakagebogebo. Bi ḡesaunemo ba Gulik lavedi i saḡedi pali vanuwina ganakukunemo bi gabu waiyawa i kaka milamila.” ");
INSERT INTO kqf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kamaina bi malagai lavedi matabudi a kanuwa medimedidi bi a dabalala tava. Bi ḡome Pol pali vanuwina ganakukuna noponemo a kaididi te a solu yovoḡe ganakuku taulinemo bi geḡa te tauyava maḡemota mataeta a gududi. ");
INSERT INTO kqf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bi noitaunana maso ai pekina ba giuna i velau makai te Loum edi tauwaiḡaviya, edi bada didigina i vaiye. Yelusalem lavedi pali vanuwina ganakukuna noponemo waiḡasiḡasi aubaina te a ḡaḡala gulata. ");
INSERT INTO kqf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ḡome maḡemota tauwaiḡaviya edi bada, waibabada ḡesaudi bi tauwaiḡaviya i waidolidi te a yovo a nawa lava kumdi lisidimo. Laḡannemo lava babada nananakidi a kitekitedi ba Pol kwapuna a kaisako. ");
INSERT INTO kqf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tauwaiḡaviya edi bada i saḡa Pol i kaididi bi tauwaiḡaviya i egelidi te seini labumo maso a pani. Ḡome tana lava i waitalayedina gado, “Niga lavana aiyai bi bai i voiye?” ");
INSERT INTO kqf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ḡome lava ḡesaudi edi giu tabudi bi tabudi taunana aubaina tauwaiḡaviya edi bada dididiga mote bamo giukauwa i banavi, aubaina te tauwaiḡaviya i giuwedi te ai dolinawe edi ani miyamo. ");
INSERT INTO kqf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Laḡannemo Pol kini pakanemo i tavatava ba lava edi medi i dididiga gulata, kamaina te tauwaiḡaviya Pol dabayalodimo a avali otiḡe. ");
INSERT INTO kqf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Banina lava kumna a kaiwatedi bi kalinedi dididiginemo a binabinauna gado, “Koi peki! Koi peki!” ");
INSERT INTO kqf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ḡome ḡotona te maso tauwaiḡaviya Pol a nawena vanuwemo ba Pol tauwaiḡaviya edi bada dididiga i giuwena gado, “Kamaina ee geḡa te maso lisimmo bai e giuwe.” Bi tauwaiḡaviya edi bada dididiga ena giu i waimunena gado, “Tam gode Gulik kalinedi kuna sibe? ");
INSERT INTO kqf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","E noḡoti te tam bena Idip lavam, tana dolinemo waiḡaviya i waitubu bi tauwaiḡaviya 4 tausan i waidoli nawedi kalakalalelemo.” ");
INSERT INTO kqf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bi Pol i giuna gado, “Geḡa, tagu ba Diu lavagu egu dobu ba dobu isa nawanawana Tasis, Silisiya plovins noponemo. Bi yà waibaḡam te maso kunai aninegu te lava lisidimo bai e giuwe.” ");
INSERT INTO kqf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kamaina bi tauwaiḡaviya edi bada dididiga Pol i wai anine, te kinimo i moito bi nimanemo lava i waikatitawedi te sa miyamoimoisili. Bi Pol Ḡibulu kalinedimo lava lisidimo i giu. ");
INSERT INTO kqf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Egu lava Diu bi valevaletigu, koi beyavaiya niganana yà koikoigalamegu.” ");
INSERT INTO kqf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Laḡannemo a vaiye te Pol Ḡibulu kalinedimo i giugiu ba tedi binau a kaisako bi a miya moimoisili ota. ");
INSERT INTO kqf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Kamaina bi Pol i giuna gado, “Tagu ba Diu lavagu bi Tasis malagainemo e tubuḡa, Silisiya plovins noponemo. Bi niga Yelusalemmo dobunemo e didiga, Gamaliel ena waibada laḡannemo, ba tamatamada edi waiḡake bi edi vaivai i wailovelove kauwegu. Te tagu Maimaituwa e kaiwata kauwe mai temi matabumi niganana. ");
INSERT INTO kqf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tagu Yesu ena wailovelove taukaiwatana e laukivi gebogeboyedi bi e waipekidi. Olooloto bi waiwaivini ḡesaudi e panidi bi biliwelokomo e sivusivu nawedi. ");
INSERT INTO kqf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bi Pilisi saḡasaḡa guletina bi babada ḡesaudi sa giu te niga ba giukauwa. Tedi pepa a kuli bi a vitegu, te edi lava Damaskasmo aubaidi. Tagu e nawanawa ḡome te maso a sagugu bi tauwaisumaḡa ḡome maso ke kaidididi bi ke saḡedi Yelusalemmo te maso a kovoḡidi. ");
INSERT INTO kqf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Bi suwala modo mainana Damaskas diyanemo ke tavatava ba yanayana malamo waimatakanikanina i waimaḡemoti te i laiyana yovoḡegu. ");
INSERT INTO kqf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Bi e kuluva doḡamo e talatalaḡa ba kalina malaḡa i yovo e vaiye i giuna gado, ‘Sol! Sol! Bai aubaina kwa laulaukivi gebogeboyegu?’ ");
INSERT INTO kqf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Bi ei talayena gado, ‘Tam aiyai, Bada?’ “Bi kalina niga mainana i giu, ‘Tagu taunana Nasalet Yesuna kwa laulaukivi gebogeboyegu.’ ");
INSERT INTO kqf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bi tausagugu yana a kita bi lava lisigumo i giugiuna kalinana mote a vaiye bi mote a sibe. ");
INSERT INTO kqf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Bi ei talana gado, ‘Bada bai yà voiye?’ Bi i giuna gado, ‘Kwa moito bi kwa nawa Damaskas malagainemo bi lava aiyai egu ḡowana bai ya giuwemna ba taunana kwa voiye.’ ");
INSERT INTO kqf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kamaina bi tausagugu nimagumo a kabi bi ai doli nawegu Damaskas. Banina yana waimatakanikanina matagu i kani te i waidudubala bi ei kaimatabwasoku. ");
INSERT INTO kqf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ḡome oloto isana Ananaiyas i tava lisigumo tana Mousis ena waiḡake i kaikaiwata bi Maimaituwa taulaudune kauwena bi Diu lavedi matabudi ḡome miyemiyedi a vivivile kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bi tana diyagumo i moito bi i giuna gado, ‘Valetigu Sol, niganana kwai kita munaḡa!’ Bi i waimaḡemoti te Ananaiyas e kita. ");
INSERT INTO kqf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ḡome i giuna gado, ‘Tamatamada edi Maimaituwa i vinem te ena ḡowana kwa sibe bi lava didimanina kwa kita bi giu mudunemo ya giugiuwedina kwa vaiye ḡonedi. ");
INSERT INTO kqf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Banina tam kaka tana aubaina kwa noya, lava matabudi lisidimo. Bi bai kuna kitekitedina bi kuna vaivaiyedina ba lava matabudi kwa giuwedi. ");
INSERT INTO kqf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bi niganana mote kumai goela, kwa miya moito bi kwa bulu bi Yesu isanemo kwai baḡa te em gebogebo ya koḡa kamaḡedi.’ ");
INSERT INTO kqf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Laḡannemo e munaḡa tava Yelusalemmo bi pali vanuwinemo e laulaupali noponemo ba mataotigumo lauboni e kita. ");
INSERT INTO kqf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ḡome Bada e kita bi i giuweguna gado, ‘Kwai papalana bi Yelusalem kwa gose banina ḡome giugu kwa giuwena mote kaka simai beyavaiyem.’ ");
INSERT INTO kqf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Bi e giu waimunena gado, ‘Bada, tedi a sibe te tagu wala tauwaisumaḡem bolu vanuwidi nopodiḡa e kwapudi bi biliwelokomo e sivusivu nawedi. ");
INSERT INTO kqf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Bi em tauwaimatamata Stivin laḡannemo a waipeki mba tagu ḡome e moimoito bi kauwina i tubutubuḡana ba tagu ei anine. Bi mabai Stivin ai waipekina edi gala tagu e labelabedi.’ ");
INSERT INTO kqf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Bi ḡome Bada i giuweguna gado, ‘Kwa nawa! Tagu yà giugiu kamaḡemna manekemo Eteni lavedi lisidimo.’” ");
INSERT INTO kqf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lava kumna a waibeyavaiye bi Pol mai giuna i vatovato ba tedi kalinedi didiginemo a binauna gado, “Ko nawe tabunemo bi koi peki kamaḡe mote luvana dobumo ima miya!” ");
INSERT INTO kqf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ḡome tedi ma binabinaudi edi gala dabanemo a pwalaḡedi bi ḡobusa sawasawamo a yalaidi. ");
INSERT INTO kqf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Taunana aubaina tauwaiḡaviya edi bada dididiga i giu vavasaḡedi te Pol maso a saḡe vanuwa ganakukuna noponemo. Bi i giuwedi te maso a kwapu bi ai talaye te maso a sibe te bai aubaina lava tana a lasalasawaineḡa. ");
INSERT INTO kqf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ḡome tedi Pol nimana a panipani kai modonemo bi kwapuna aubaina ba Pol tauwaiḡaviya edi bada i giuwena gado, “Temi emi waiḡake ya kenakena te Loum lavana mote ena gebo ko banavi bi ko kwapu yababe, ee?” ");
INSERT INTO kqf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Laḡannemo tauwaiḡaviya edi bada niga giuna i vaivaiye ba i nawa tauwaiḡaviya edi bada didigina lisinemo bi i giuna gado, “Tam bai kwa voiye? Niga Loum lavana.” ");
INSERT INTO kqf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ḡome ḡaviya badana i nawa bi Pol i waitalayena gado, “Tam giukauwa te Loum lavam, ee?” Ḡome Pol i giuna gado, “Emaso bena kuna giu kauwa.” ");
INSERT INTO kqf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Bi tauwaiḡaviya edi bada dididiga i giuna gado, “Tagu mane dididiga e sako te eila Loum.” Pol i giuna gado, “Bi tagu bena Loum gomenigu.” ");
INSERT INTO kqf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bi tedi mabai maso ai talayena ba mba taunana te a gose kamaḡe. Bi tauwaiḡaviya edi bada dididiga i naila gulata te Loum lavana a lausein. ");
INSERT INTO kqf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bokina mainana tauwaiḡaviya edi bada dididiga i ḡoeḡoena maso i sibe kauwe, te Diu lavedi bai aubaina Pol ai wavu. Taunana aubaina Pol a laulauseinina i kaikamaḡe bi pilisi edi babada bi Diu lavedi edi babada i egelidi te ai ḡemotidi bolu aubaina. Kamaina bi Pol a lau egeli te i nato matedimo i moito. ");
INSERT INTO kqf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol Diu babadidi i kitadididi bi i giuwedina gado, “Egu lava laḡan matabuna Maimaituwa matanemo e miyana ba egu noḡota sabusabuna didimanina te niganana.” ");
INSERT INTO kqf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mainana i giugiu ba pilisi saḡasaḡa guletina Ananaiyas, Pol diyanemo mabai a moimoitona i giuwedi te Pol muduna sa talaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ḡome Pol, pilisi saḡasaḡa guletina i giuwena gado, “Maimaituwa kaka ya kwapum, tam lava kaikaiyovum! Tam niganana kwa etaetalegu waiḡake luvanemo bi tam kota waiḡake kuna wai doukoto. Lava kuna giuwedi te a kwapukwapugu.” ");
INSERT INTO kqf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bi mabai ḡome a moimoitona Pol a giuwena gado, “Tam Maimaituwa ena pilisi saḡasaḡa guletina kwa ḡasiḡasiye ee?” ");
INSERT INTO kqf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol i giuwedina gado, “Egu valevaletigu, tagu mote e sibe te tana gode pilisi saḡasaḡa guletina. Bi tagu e sibena ba gilugilumina wadubonemo i giuna gado, ‘Mote em lava edi bada kuma giu waigebogebo.” ");
INSERT INTO kqf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bi Pol i kitedi te waibabada ḡesaudi ba Sadisi bi ḡesaudi ba Palisi lavedi, taunana aubaina bolu babadidi nopodimo bi kalinana dididiginemo i giuna gado, “Egu lava, tagu ba Palisi bi kota tamagu ba tana Palisi. Bi yà waisumaḡa te lava pekipekidi ba sa kena moito munaḡa bi niga waisumeḡina aubaina temi ko etaetalegu.” ");
INSERT INTO kqf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Niga mainana i giugiu ba Palisi bi Sadisi waikagiu ai tubuḡa. Bi edi boluna a suwa te dam labu a tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Banina Sadisi sa giugiu te lava mote pekimo ima kenamoito munaḡa bi bamo mote aneya ee alualuwa. Bi Palisi lavedi sa giugiu te niga mwalidi ba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ḡome binau i didiga gulata te waiḡake tauwailovelovena Palisi damna noponemo tedi Pol mulinemo a nawa bi a giuna gado, “Tama niga lavana lisinemo mote bai gebogebona ka banavi. Augunai alualuwa ee aneya lisinemo i giu.” ");
INSERT INTO kqf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bi waikagiu i dididiga gulata aubaina tauwaiḡaviya edi bada dididiga nuwana i lovo bamoda Pol sima lisi waiyamoni. Taunana aubaina ena tauwaiḡaviya i egelidi te a yovo bi Pol a solu nawe edi animiyamo. ");
INSERT INTO kqf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mba dudubalinemo Bada ena aneya Pol diyanemo i moito bi i giuwena gado, “Mote kuma naila! Bainewa Yelusalemmo kuna giugiuna kota mainana Loum noponemo aubaigu kwa giu.” ");
INSERT INTO kqf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Laḡan i sako olaolalemo Diu lavedi ḡesaudi Pol kana pota a yesi bi a giuwapa munaḡedi, te mote bai sima kani e sima tego, eete Pol sai peki. ");
INSERT INTO kqf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Niga giuwapana noponemo olooloto wapedi 40 ai ḡemotidi bi ai ogatala. ");
INSERT INTO kqf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bi a nawa pilisi babadidi bi waibabada nananakidi lisidimo bi a giuna gado, “Tama ke giuwapa te mote kama kani e kama tego eete Pol kaipeki.” ");
INSERT INTO kqf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Taunana aubaina niganana temi waibabada vaitemi, tauwaiḡaviya edi bada dididigina koi baḡa te Pol ya yovoḡe lisimimo. Ko kaiyovuḡe te bena a waiwavuna banina ko sibe kauwe. Bi ke vononoḡa te sauginemo ya yovoyovo ba etamo kaipeki. ");
INSERT INTO kqf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bi Pol ḡavuna i vaiye te Diu lavedi ḡesaudi Pol kana pota a yesiyesi, kamaina bi i nawa te baimo i miyamiyanemo bi bai a giugiuwena i tainuwatau. ");
INSERT INTO kqf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ḡome Pol tauwaiḡaviya edi bada ḡemota i yoge bi i giuwena gado, “Niga ewalina kwa doli nawe tauwaiḡaviya edi bada dididiga lisinemo bi tana bai ya giuwe.” ");
INSERT INTO kqf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kamaina bi mba ewalina i wai doli nawe tauwaiḡaviya edi bada dididiga lisinemo bi i giuna gado, “Pol biliwelokomo taumiya, i yogegu e nawa bi i wai baḡagu te niga ewalina e saḡe lisimmo banina tana kaka lisimmo bai ya giuwe.” ");
INSERT INTO kqf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tauwaiḡaviya edi bada dididigina ewali nimanemo i kabi bi a nawa tabudimo bi i waitalena gado, “Bai mwalina kuna ḡoena kwa giuwegu?” ");
INSERT INTO kqf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Bi ewali i giuna gado, “Diu lavedi ai anina te bokina ba sai baḡam te Pol kwa nawe Diu a babadidi edi bolumo bi sa kaiyovu te bena waibabada Pol ena pilipili banina sa sibe kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bi kalinedi mote kuma vaiye banina olooloto wapedi 40 male sa kandavona bi sa labelabe. Tedi kaikana a giuwapa te mote sima kani ee sima tego eete Pol sai peki. Tedi noitaunana a vononoḡa te mai sa voiye bi tam sa labelabe te edi ogatala kwai anine ee geḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ḡaviya edi bada dididiga i giuna gado, “Mote aiyai kuma giuwe te lisigumo kunai benabenama.” Ḡome te ewali i giu kamaḡe i nawa. ");
INSERT INTO kqf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Bi tauwaiḡaviya edi bada dididigina bi tauwaiḡaviya babada labu i yogedi bi i giuwedina gado, “Tauwaiḡaviya 200 ko tanodi bi ko nawa Seseliya. Bi kota osi tauvelauyedi wapedi 70 bi pawasimo tauwaiḡaviya wapedi 200, ko vononoḡa bi mateya 9:00 dudubalemo ko modina Seseliya. ");
INSERT INTO kqf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bi kota osi ḡesaudi ko tanodi Pol aubaina ya gelu bi ya nawa kauwa gabemani edi bada Filiks lisidimo.” ");
INSERT INTO kqf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kamaina bi ḡaviya badana dididiga pepa i kulina gado. ");
INSERT INTO kqf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Tagu Kolodiyas Lisiyas, tam bada saḡasaḡa guletim, gabemani badana Filiks: yà waiyebone kauwem! ");
INSERT INTO kqf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Niga olotona Pol ba Diu lavedi a kaididi bi ḡotona maso ai peki bi lava ḡesau i giuwegu te tana ba Loum olotona. Taunana aubaina egu tauwaiḡaviya vaitedi ke nawa te kanakuvu keyeda. ");
INSERT INTO kqf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Bi e ḡoeḡoe maso e sibe te bai aubaina ai waiwavu, taunana aubaina Pol e saḡe Diu waibabada matedimo. ");
INSERT INTO kqf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bi e banavi te edi kauwa bi edi waiḡake aubaina te ai waiwavu bi mote Loum edi waiḡake i waidoukoto te maso biliwelokomo a sako e ai peki.” ");
INSERT INTO kqf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bi giu e vaiye te Diu lavedi ḡesaudi Pol kana pota a yesiyesi te maso ai peki ba waiḡapa e giukamaḡe lisimmo bi tauwaiwavuna e giuwedi te sa giuwem te bai aubaina Pol ai wavu. ");
INSERT INTO kqf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kamaina bi ḡaviya edi bada dididigina bai tauwaiḡaviya i giugiuwedina mainana a voiye. Mba dudubalinemo Pol ai doli bi a nawa, Entipatlis tauninemo a tava. ");
INSERT INTO kqf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Laḡan i sako ba kepatemo bi pawasimo tauwaiḡaviya a munaḡa edi animiya Yelusalemmo. Bi osi tauvelauyedi taudiḡa Pol vaitena a nawa. ");
INSERT INTO kqf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bi tedi Seseliyamo a tavatava ba gabemani Filiks, pepa a vite bi Pol tana lisinemo a gose. ");
INSERT INTO kqf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ḡome gabemani Filiks leta i iyevi kovi bi Pol i waitalaye te tana dobu isana lavana. Bi Pol i giuna gado, “Tagu ba Silisiya plovinsina lavagu.” ");
INSERT INTO kqf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kamaina bi i giuna gado, “Tam tauwaiwavum sa tava bi em pilipili yà laididimani.” Kamaina bi tauwaiḡaviya i giuwedi, te Pol sai doli nawe ḡalibona Alodi ena vanuwemo sa sako bi sa labe kauwe. ");
INSERT INTO kqf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","2Laḡan 5 a kovi mulidimo pilisi saḡasaḡa guletina Ananaiyas, Diu babadidi bi waiḡake taulaididimana isana Titulas vaitena, Yelusalemḡa a yovona Seseliyamo. Ḡome edi waiwavu Pol lisinemo gabemani edi bada Filiks matanemo a kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Sauginemo Pol a giuwe te i saḡa gabemani edi bada lisinemo. Ḡome Titulas ena kita waigebo Pol lisinemo Filiks i giuwena gado, “Filiks tam dididigim, visuvisum bi em noḡota didimanina, ka wainuwavisu gulata te em waibada dibunemo ke miya te niga palatina. Bi kauwa wapawapa visuvisudi ema dobumo a tubuḡa. ");
INSERT INTO kqf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bi dobu matabuna tama laḡan matabuna niga kauwidi aubaidi tam gabemani Filiks lisimmo kawainuwavisu. ");
INSERT INTO kqf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Tagu mote yà ḡoeḡoe te yà taipilipilim, taunana aubaina yà waibaḡam te kivim maso i visu bi ema giu watiena kuna beyavaiye. ");
INSERT INTO kqf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Tama niga lavana ke banavi te tana ba gebogebo tauwaitubuna, tana dobu matabuna nopodimo Diu lavedi ya kanuwa medimedi bi waiḡasiḡasi sa waitubudi. Bi tana kota Nasalet damna edi bada. ");
INSERT INTO kqf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Bi Pali vanuwina i kaka milemiledi taunana aubaina ke pani. ");
INSERT INTO kqf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Bi kwai talaye kaka kwa banavi te bai ka waiwavuna ba giukauwa.” ");
INSERT INTO kqf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bi Diu lavedi edi tau Titulas a sagu bi a giuna gado, “Niga giudi matabudi ba giukauwa.” ");
INSERT INTO kqf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kamaina bi gabemani edi bada dididiga nimana i waiyoyo Pol lisinemo te ya giu. Bi Pol i koigalamena gado, “Tagu e sibe te tam kwalabu te kwalabu tam niga dobuna lavedi edi taulaididimana, taunana aubaina tagu nuwagu visuvisunemo matamo yà koigalamegu. ");
INSERT INTO kqf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bi lava kwai talayedi kaka sa giu kauwem te e saḡa e nawa Yelusalemmo laudune aubaina ba niganana laḡan 12 a kovi. ");
INSERT INTO kqf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bi tauwaiwavugu mote a kitagu te aiyai vaitena kei kagiu, ee aiyai lavana nopona e kamedimedi pali vanuwinemo ee malagai noponemo. ");
INSERT INTO kqf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bi mote ḡemoḡemotina te niganana edi waiwavu lisigumo sa kamaḡati te mba giukauwa. ");
INSERT INTO kqf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bi yà giuwemi te niga ba giukauwa te tamatamada edi Maimaituwa tagu yà laulauduneye bi tagu Yesu eta yà kaikaiwatana ba tedi sa wai isana laudune kaikaiyovuna. Tagu Mousis ena waiḡake bai i waianinena bi taugiuwatana a gilugilumina taudidi yà kaikaiwatedi. ");
INSERT INTO kqf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Bi tagu Maimaituwa yà waisumaḡe mainana tedi bi yà noḡotadidi te lava didimanidi bi gebogebodi pekimo sa kenamoito munaḡa. ");
INSERT INTO kqf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Taunana aubaina sauga matabuna yà wailaulubu gulata te egu noḡota bi egu kauwa Maimaituwa bi lava lisidimo maso didimanidi. ");
INSERT INTO kqf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yelusalem e gosena ba kwalabu visa a kovi. Bi maḡo ota e tava munaḡa egu lava wai nuwatoitoidi aubaidi puyo e natomedi bi sewasewa Maimaituwa yà vite. ");
INSERT INTO kqf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tagu pali vanuwina noponemo laukuvasa sewasewana e voivoiye bi tauwaiwavugu a banavigu. Tagu mote lava e kaka nuwa medimedidi ee waiḡasiḡasi e waitubudi. ");
INSERT INTO kqf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bi ḡome Diu lavedi ḡesaudi Eisiya plovinsina noponemo miyemiyedi a kitagu. Tedi taunana maso niganana a tava bi a giu te bai gebona a kita e voivoiye. ");
INSERT INTO kqf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ee mabai ḡome maso niganana a giuwem te gebo bai a banavi, sauginemo Diu waibabada edi bolumo e moito bi a etaetalegu. ");
INSERT INTO kqf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Bi augunai mwali ḡemota Diu lavedi matedimo e moito bi e laulaugayapouna gado, ‘Lava pekipekidi kaka sa kenamoito munaḡa bi niga taunana aubaina temi niganana ko etaetalegu.” ");
INSERT INTO kqf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bi Filiks yawasana etana i sibe kauwe aubaina tana etala laḡanna i tauliye bi i giuna gado, “Koi laba ḡaviya edi bada dididiga Lisiyas ya tava kaka tagu etalemi yài tubu munaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ḡome Filiks tauwaiḡaviya edi bada i giuwe te Pol biliwelokomo ya sako nawe bi i giuwena gado, “Kwa voiye te yai nuwavisu. Bamoda ena lava sa vakitakita ee saguna aubaina sa tavana ba mote kumai ḡakedi.” ");
INSERT INTO kqf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Laḡan visa a kovi Filiks bi mwanena Dulusila, tana ba Diu waivinina a tava waiḡemota vanuwinemo. Bi Pol ena giu i giu kamaḡe te i tava. Bi Pol Yesu Keliso waisumaḡena Filiks lisinemo i giu waiipoipo. Bi a wai beyavaiye. ");
INSERT INTO kqf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bi Pol i giu nawa te yawasana didimanina, eda ḡowana balebaledi gosedi bi laḡan damona waitalapilina, i giugiu waiipoipo ba Filiks i naila bi giuna gado, “Niganana aubaina ba kamaina, bi kwa nawa! Bi laḡan ḡesaunemo yà vononoḡana, kaka em giu yà giukamaḡe te kwa tava munaḡa.” ");
INSERT INTO kqf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Bi Filiks sauga matabuna ena giu i giugiukamaḡe te i tava vaitena a waigiugiu. Banina Pol biliwelokomo i miyamiya taunana aubaina Filiks i ḡoeḡoe, te Pol maso kandavonemo mane i vite bi kandavonemo i kaikamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bi lagannemo kwalabu labu a kovi ba Posias Festas i moito saḡa te gabemani edi bada bi Filiks ena gabu i vai. Bi Filiks Diu lavedi edi ḡowana i voiye te Pol biliwelokomo i gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gabemani edi bada Festas Seseliyamo i tava bi laḡan faiona mulidimo i saḡa i nawa Yelusalemmo. ");
INSERT INTO kqf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bi ḡome pilisi edi babada bi Diu babadidi a nato Festas lisinemo bi edi waiwavu Pol lisinemo a saḡedi. ");
INSERT INTO kqf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Kamaina bi Festas ai baḡa te maso edi ḡowana i voiye, te maso Pol i giukamaḡe i saḡa i nawa Yelusalemmo. Banina tedi kaikana kana pota a yesi te kandavonemo etamo sai peki. ");
INSERT INTO kqf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bi Festas i giuna gado, “Geḡa Pol Seseliyamo biliwelokomo ya miyamiya bi mavisemo ba yà yovo yà nawa. ");
INSERT INTO kqf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bi emi babada ḡesaudi maso vaitedi ke nawa nove ḡome kaka edi waiwavu maso a saḡedi mba olotona lisinemo, bamoda tana bai i voiye waigebo.” ");
INSERT INTO kqf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ḡome Festas i miyana male laḡan 8 ee 10 mainana bi mulinemo i yovo i nawa Seseliya. Bi laḡan i sako ba etala i waitubu bi ena tauwaiḡaviya i giuwedi te Pol sa natome lisinemo. ");
INSERT INTO kqf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bi sauginemo Pol i tavana ba Diu lavedi mabai Yelusalemḡa a yovoyovona tana a moito kwaivivili bi a waiwavu gulatena. Bamo mote giukauwa. ");
INSERT INTO kqf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bi Pol i koigalame gado, “Tagu mote bai gebogebona e voiye. Ḡalibona Sisa lisinemo ee Diu edi waiḡake ei doukoto ee pali vanuwina e ka milamila.” ");
INSERT INTO kqf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festas i ḡoe te Diu edi ḡowana ya voiye. Taunana aubaina Pol i waitalayena gado, “Tam Yelusalem nawana kwa ḡoeḡoe ee geḡa, te ḡome maso niga kauwidi aubaidi yà etalem?” ");
INSERT INTO kqf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bi Pol giu i waimunena gado, “Niga vanuwinemo niganana ya moimoitona taunana ḡalibona Sisa ena anietala gabuna. Niga taunana gabunemo kwa etalegu. Tam kuna sibe te tagu mote bai gebogebona e voiye Diu lavedi lisidimo. ");
INSERT INTO kqf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bamoda bai gebona e voiyena ba kamaina te yà peki, tagu mote peki e daboka. Bi bamoda niga lavedi bai sa waiwavuna mote giukauwa, ba aiyai mote ḡemoḡemotina te noi lavedi nimedimo ya sakogu te sai pekigu. Bi tagu yà ḡoeḡoena ḡalibona Sisa ya etalegu.” ");
INSERT INTO kqf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ḡome Festas ena lava nuwanuwauyeuyedi vaitedi ai giugiu te bai ya voiye, kaka bi Festas Pol i giuwena gado, “Tam kuna ḡoena ḡalibona Sisa ya etalemna, ba kamaina te kwa nawa Loummo ḡalibonana Sisa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Laḡan visa a kovi mulidimo ḡalibona Agilipa bi nuvuna Benis a tava Seseliyamo, gabemani valivaliuna Festas waiyebona aubaina. ");
INSERT INTO kqf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bi ḡome a taumiya laḡan visa a kovi bi Festas, Pol ena kauwa ḡalibona Agalipa i giuwe gado, “Laḡannemo Filiks i laulaupotiyovo ba oloto ḡemota biliwelokomo i gose kamaḡe. ");
INSERT INTO kqf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bi sauginemo e nawanawa Yelusalem ba pilisi edi babada bi Diu babadidi tedi ai wavu bi ai baḡagu te maso ei anina bi maso ai peki. ");
INSERT INTO kqf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Bi e giuwedina gado, ‘Tama Loum ema vaivaimo mote lava kama kovoḡi yababe. Te dolina tana tauwaiwavuna vaitedi Taulaetala matanemo sa moito te sa waiwavuna aubaina ya koigalagalame. ");
INSERT INTO kqf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bi sauginemo Diu babadidi vaitedi ke tava niga ḡome ba tagu mote yài laba. Bi laḡan i sako olaolalemo etala gabunemo e miya bi tauwaiḡaviya e giuwedi te Pol sa saḡe matagumo. ");
INSERT INTO kqf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ḡome tauwaiwavuna a moito bi edi waiwavu lisinemo a giuwedi, tagu e wainoḡotana bena olotona bai gebogebo otina i voiye bi sai wavu. ");
INSERT INTO kqf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bi geḡa te tedi ba a waikagiu Diu edi laudune aubaina bi lava isana Yesu i peki bi Pol ya giugiu te i kenamoito munaḡa dabanemo. ");
INSERT INTO kqf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bi tagu a kanuwa laḡalaḡagu te niga kauwidi bainewa yà kadidimanidi. Taunana aubaina Pol e giuwe te maso i nawa Yelusalemmo bi ḡome maso i etala. ");
INSERT INTO kqf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bi Pol i daboka bi i waibaḡa te Seseliyamo ya miya bi ḡalibona Sisa ya etale. Taunana aubaina e giu te niga ḡome a kaididi eete tagu yà giukamaḡe Sisa lisinemo.” ");
INSERT INTO kqf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ḡome ḡalibona Agilipa, Festas i giuwena gado, “Tagu yà ḡoeḡoena niga lavana ena giu yài beyavaiye.” Bi Festas i giuna gado, “Tam bokina kaka kwai beyavaiye.” ");
INSERT INTO kqf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Laḡan i sako ḡalibona Agilipa bi Benis edi gala waimatakanikani a kotedi bi tauwaiḡaviya edi babada nananakidi bi malagai babadidi vaitedi matabudi a poleni. Bi a saḡa anietala vanuwina noponemo. Bi Festas tauwaiḡaviya i giuwedi te Pol ai doli saḡe. ");
INSERT INTO kqf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Bi Festas i giuna gado, “Ḡalibona Agilipa bi babada matabumi niganana vaitemai, niga olotona ko kita matademo ya moimoitona! Diu lavedi matabudi Yelusalemmo bi Seseliyamo ai baḡagu te niga lavana sai peki mote ima miya. ");
INSERT INTO kqf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bi tagu e banavi te tana mote bai gebogebona i voiye te maso ya peki. Bi Pol i giu te tana ya ḡoeḡoena ḡalibona Sisa ya etale. Taunana aubaina te yà ḡoeḡoe te yà giukamaḡe Loum. ");
INSERT INTO kqf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bi tagu mote e sibe kauwe te bai giuna maso e kuli ḡalibona Sisa lisinemo. Taunana aubaina Pol e saḡe temi matabumi lisimimo bi kota tam ḡalibona Agilipa lisimmo. Bi ta gei waitalavitavitale te bai tagu yà sibe kaka muliḡa leta yà kuli. ");
INSERT INTO kqf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tagu e sibe te panipani lavana mote bai gebona i voiye bi yà giukamaḡe yababe ḡalibona Sisa lisinemo ba mote i visu.” ");
INSERT INTO kqf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kamaina bi Agilipa Pol i giuwena gado, “Niganana ba kei aninem te taumḡa aubaim kwa giu.” Kamaina bi Pol nimana i lageti te lava i waikatitawedi bi taunaḡa i koi galamena gado, ");
INSERT INTO kqf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ḡalibona Agilipa, tagu nuwagu i visu te niganana matammo yà moimoito, Diu a waiwavugu aubaina niganana yà koikoigalamegu. ");
INSERT INTO kqf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Banina tam Diu edi vaivai bi edi waiḡinana kuna sibe kauwe. Taunana aubaina yà waibaḡam te kwai beyavaiyegu. ");
INSERT INTO kqf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wala egu dobumo ma ḡaubogu egu yawasana bainewa e miyamiyana Diu lavedi matabudi a sibe bi kota muliḡa Yelusalemmo e miyana. ");
INSERT INTO kqf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Tedi a sibe mba sauginemo Yelusalemmo e miyamiyana ba tagu Palisi edi vaivai e kaikaiwata. Bi Palisi edi waiḡake ba i bagibagi kauwa. Bi bamoda Diu lavedi sima ḡoe te sa giu. ");
INSERT INTO kqf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Bi niganana egu sumaḡa bai Maimaituwa i giugiuwapana tamatamada lisidimo aubaina ko etaetalegu. ");
INSERT INTO kqf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Bi niga giuwapana eda dam 12 a noḡonoḡoti te maso i tubuḡa te a kita. Taunana aubaina ma vivilidi dudubala bi suwala Maimaituwa aubaina a waitaupaula. Ḡalibona, tagu niga giuwapana yà waisumaḡe, taunana aubaina Diu lavedi sa waiwavugu. ");
INSERT INTO kqf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bai aubaina temi ko wainoḡota, te Maimaituwa mote ḡemoḡemotina te lava pekipekidi ima kakenamoito munaḡedi? ");
INSERT INTO kqf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Tagu wala mainana e wainoḡota te bai matabuna e voiye te Nasalet Yesuna isana e waiḡaviye. ");
INSERT INTO kqf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Bi mba kauwina Yelusalemmo e voiye. Tagu pilipilisi edi babada edi ḡailisimo tauwaisumaḡa wapewapedi e panidi bi biliwelokomo e sivusivu nawedi. Bi sauginemo waipekidi aubaina ba tagu taunana e waianina. ");
INSERT INTO kqf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tagu laḡan wapawapa bolu vanuwidi nopodiḡa e nawa bi tauwaisumaḡa e kovoḡidi bi e egelidi te tedi Yesu isana a kaka gebogebo. Tagu nuwagu i medi kauwa lisidimo, taunana aubaina te e nawa dobu ḡesaudiḡa te maso e banavidi bi e kovoḡidi. ");
INSERT INTO kqf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Laḡan ḡemota pilisi edi babada, ḡailisi a vitegu, te e nawanawa Damaskas. ");
INSERT INTO kqf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ḡalibona, tagu suwalamodo mainana etamo bi yanayana malaḡa waimatakanikanina i yovo. Bi yana e kita i waimatakanikani gulata mote mai suwala. Ḡome tagu bi olooloto vaitedi ke nawanawana i laiyana kwavivilemai. ");
INSERT INTO kqf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bi matabumai ke kuluva doḡamo bi kalina e vaiye, Ḡibulu kalinedimo, i giu yovona lisigumo gado, ‘Sol, Sol! Bai aubaina kwai ḡaviyegu mba tam kwa kaka gebogebo munaḡem?’ ");
INSERT INTO kqf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Bi ei talana gado, ‘Tam aiyai, Bada?’ Bi Bada i giuna gado, ‘Tagu taunana Yesu kwa laulau kivigebogeboyegu. ");
INSERT INTO kqf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bi niganana kwa miya moito! Tagu lisimmo e laumaḡatana banina tam e vinem te egu taupaula bi matammo kuna kitakitaguna lava kwa tainuwataudi bi kota kauwa ḡesaudi muliḡa lisimmo yà kamaḡatidi. ");
INSERT INTO kqf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Tagu yà giugiukamaḡem Diu bi Eteni lavedi lisidimo bi yà labe kauwem. ");
INSERT INTO kqf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kwa nawa bi matedi kwa kayanedi te wai dudubalinemo sa nuwavitala bi sa natona yanayanamo. Bi Seitan ena ḡailisimo sa potiyovo bi sa nato Maimaituwa lisinemo, kaka edi gebogebo yà noḡoti kamaḡedi. Bi sai sumaḡegu bi yai aninedi te egu dam waiwaiyawidi sa tubuḡa.’ ");
INSERT INTO kqf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ḡalibona Agilipa, wailove malaḡa i yovoyovona kamaina te e voteyeteye. ");
INSERT INTO kqf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Bi Damaskasmo lauguguya lava lisidimo ei tubu, tena Diu lavedi lisidimo Yelusalemmo bi Diudiya plovinsina nopona matabuna bi kota Eteni lavedi lisidimo te maso a laukuvasa bi a nuwavitala Maimaituwa lisinemo bi kauwa visuvisudi a voiyedi te a kamaḡati munaḡedi te giukauwa te a laukuvasa. ");
INSERT INTO kqf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Banina niga kauwidi dabedimo, Diu lavedi pali vanuwidi nopodimo a kaididigu bi a ḡoeḡoena maso ai pekigu. ");
INSERT INTO kqf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bi Maimaituwa i sagugu eete niganana, niga ḡome e moito bi lava nanakidi bi keikeilikidi lisidimo yà laulauguguya. Bi taugiuwatana bi Mousis bai a giugiuwata te maso i tubuḡa, taunana yà giugiuwe. ");
INSERT INTO kqf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bi Keliso sa voiye te yai nuwatoitoi bi pekimo ya gei kenamoito munaḡa bi yana ya natome ena lava Diu bi Eteni lavedi lisidimo.” ");
INSERT INTO kqf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bi sauginemo Pol i koikoigalame ba Festas Pol i lasagudana gado, “Pol tam kuna bu'uwa ee! Em anapu dididigina i ka bu'uwim.” ");
INSERT INTO kqf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bi Pol i giuwena gado, “O Festas saḡasaḡa guletim! Tagu mote yà bu'uwa. Bi bai yà giugiuwena ba giukauwa bi waibanina. ");
INSERT INTO kqf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ḡalibona Agilipa niga kauwidi yà giugiuwedina ba mote kadavonemo a tubuḡa. E sibe te niga kauwidi matabudi kuna sibedi, taunana aubaina malaudabatolagu lisimmo yà giugiu.” ");
INSERT INTO kqf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ḡome te Pol i waitalana gado, “Ḡalibona Agilipa, taugiuwatana bai a gilugilumina kwai sumaḡe e geḡa, e sibe te kwai sumaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ḡome ḡalibona Agilipa, Pol i giuwena gado, “Tam kuna noḡoti te noi taunana laḡan watiḡenemo kwa voiyegu te yesu yai sumaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bi Pol i giu waimunena gado, “Bamoda noitaunana ee yaḡolo bi mba mote i pilipili. Bi Maimaituwa lisinemo yà laulaupali te mote taumḡa bi lava matabudi niganana ko waibeyavaiyana kaka koi sumaḡa mai tagu bi mote yàma ḡoeḡoe te panipanimo ko miya mai tagu.” ");
INSERT INTO kqf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ḡome ḡalibona Festas, gabemani badana Agilipa, Benis bi mabai ḡome a miyamiyana matabudi a miya moito. ");
INSERT INTO kqf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bi tedi etala gabuna a gose bi edi lava vaitedi ai giugiuna gado, “Niga lavana mote bai i voiye waigebo, te maso biliwelokomo ya miya ee ya peki.” ");
INSERT INTO kqf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Bi Agilipa, Festas i giuwena gado, “Niga olotona maso biliwelokomo a sakoyovoḡe te i nawa. Bi geḡa te kaikana i giu te ḡalibona Sisa ya etale, te bai gebona i voiye. Taunana aubaina tada mote ḡemoḡemotina te ta kaikamaḡe.” ");
INSERT INTO kqf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sauginemo a ḡoeḡoe te wagaḡa ka nawa Itali ba Pol bi biliwelokomo taumiya ḡesaudi vaitedi bi tauwaiḡaviya edi bada isana Duliyas nimanemo a sivudi. Duliyas ba ḡalibona Sisa ena tauwaiḡaviya laukaina. ");
INSERT INTO kqf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kamaina bi Adamitiyam edi waga maso i nawa Eisiya plovinsina noponaḡa, nisadiya malagaidiḡa bi ḡome ke gelu. Bi ke modina Seseliya ke gose bi ḡome ba Alistakas vaitena bi tana Tesalonia taunina lavana Mesidoniya plovinsina noponemo. ");
INSERT INTO kqf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bi laḡan i sako ba Sidon tauninemo ke tava, bi wagamo ḡonaḡona ḡesaudi ai yovodi. Bi Duliyas ba kivina i visu kauwa aubaina Pol i waianine te i nawa ena lava i kitedi bi ena ḡowana bai te maso a sagu. ");
INSERT INTO kqf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mba dobuna ke gose bi ke nawanawa ba yavala i didiga gulata, taunana aubaina Saiplas bwanabwanana ḡoyonaḡa ke kwaivivila. ");
INSERT INTO kqf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kamaina te ke nawa nisa dididiginemo Silisiya plovins bi Famfiliya plovins gele diyediḡa, te ke nawa Maila taunaḡa Lisiya plovinsina noponemo. ");
INSERT INTO kqf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ḡome Maila tauninemo tauwaiḡaviya edi bada waga i banavi Aleksandiliyaḡa i tava. Bi waganemo kegelu kenawa Itali. ");
INSERT INTO kqf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Laḡan visa nopodimo tama nuwatauḡa ke nawanawana eete Kinidus taunina diyanemo ke tava. Bi yavala i didiga gulata matamaiḡa i laulausuve. Taunana aubaina Kuliti bwanabwana ḡoyonaḡa te Salon Isukokona ke gose. ");
INSERT INTO kqf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bi nuwatauḡa diyadiyaḡa bwanabwana ḡoyonaḡa eete Wofu Visuvisuna ḡome ke tava Laseya taunina diyanemo. ");
INSERT INTO kqf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Laḡan wapawapa a kovi mulidimo bi kota udi laḡanina i kovi. Bi nawa i wainuwa nainaila taunana aubaina Pol lava i tainuwataudi, ");
INSERT INTO kqf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","bi i giuwedina gado, “Egu lava, eda babala male ya pilipili kauwa bi waga ḡonaḡona bi tada eda yawasana male sa gebogebo. Bi tada male kota ta peki.” ");
INSERT INTO kqf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bi tauwaiḡaviya edi bada waga tauvelauyena ena giu i waianine te Pol ena giu mote a vaiye. ");
INSERT INTO kqf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bi niga dobunemo mote ḡemoḡemotina te maso waga i moito. Taunana aubaina lava wapawapa a giu te ke nawa otana Finiks wofunemo. Ḡome ka miya te bodubodu laḡanina ya kovi. Bi Finiks dobuna Kuliti bwanabwananemo ba waga edi ani moito. Finiks ba suwala ena anibulu yawaninemo. ");
INSERT INTO kqf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kamaina bi yalousaḡa yavala nuwatauḡa lausuve i waitubu ba ai noḡota bena niga yavalina ya sagudi te sa nawa Finiks tauninemo sa tava. Taunana aubaina anika a solu saḡe bi waga Kuliti bwanabwanana diyanaḡa i nawa. ");
INSERT INTO kqf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bi ke nawa mote lofana, te Kuliti bwanabwananemo aibadabadaḡa kaibitibiti lausuve i waitubu. ")