﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqew_vpl;
CREATE TABLE kqew_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqew_vpl WRITE;
INSERT INTO kqew_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yani yang tarsila ni Isa Almasi. Si Isa topo ni Daud, aw si Daud topo ni Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Ibrahim yang ama ni Isahak. Si Isahak yang ama ni Yakob. Si Yakob yang ama ni Yodah. ");
INSERT INTO kqew_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yang mga anak ni Yodah si Paris aw si Sirah. Yang ina nilan si Tamar. Si Piris yang ama ni Isrom. Si Isrom yang ama ni Aram. ");
INSERT INTO kqew_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram yang ama ni Aminadab. Si Aminadab yang ama ni Nason. Si Nason yang ama ni Salmon. ");
INSERT INTO kqew_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon yang ama ni Booz. Yang ina ni Booz si Rahab. Si Booz yang ama ni Obid. Yang ina ni Obid si Rot. Si Obid yang ama ni Isai. ");
INSERT INTO kqew_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aw si Isai yang ama ni Daud. Si Daud yang ama ni Solayman. Yang ina ni Solayman yang dati na asawa ni Oriyas. ");
INSERT INTO kqew_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solayman yang ama ni Robowam. Si Robowam yang ama ni Abiyas. Si Abiyas yang ama ni Asa. ");
INSERT INTO kqew_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa yang ama ni Yosapat. Si Yosapat yang ama ni Yoram. Si Yoram yang ama ni Osiyas. ");
INSERT INTO kqew_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Osiyas yang ama ni Yotam. Si Yotam yang ama ni Akas. Si Akas yang ama ni Isikiyas. ");
INSERT INTO kqew_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Isikiyas yang ama ni Manasi. Si Manasi yang ama ni Amon. Si Amon yang ama ni Yosiyas. ");
INSERT INTO kqew_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Yosiyas yang ama ni Ikoniyas aw yang mga lomon nan. Yamabowi silan sidtong wakto na yamadaa yang mga bangsa Yahodi adto sang banwa ng Babilon. ");
INSERT INTO kqew_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sikun sidtong pagdaa kanilan adto sang Babilon yani yang mga kaompowan na yakalista: si Ikoniyas yang ama ni Salatiyal. Si Salatiyal yang ama ni Sirobabil. ");
INSERT INTO kqew_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sirobabil yang ama ni Abiyod. Si Abiyod yang ama ni Iliyakim. Si Iliyakim yang ama ni Asor. ");
INSERT INTO kqew_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor yang ama ni Sadok. Si Sadok yang ama ni Akim. Si Akim yang ama ni Iliyod. ");
INSERT INTO kqew_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Iliyod yang ama ni Iliyasar. Si Iliyasar yang ama ni Matan. Si Matan yang ama ni Yakob. ");
INSERT INTO kqew_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Yakob yang ama ni Yosop na bana ni Mariyam. Si Mariyam yang ina ni Isa na tyawag ng Almasi. ");
INSERT INTO kqew_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Idto sagaw, yang kadaig ng mga katopowan sikun kang Nabi Ibrahim sampay da kang Soltan Daud sampoo aw opat. Aw sampoo aw opat oman yang kadaig ng mga katopowan sikun kang Soltan Daud taman sang wakto ng pagdaa kanilan adto sang Babilon. Aw sampoo aw opat oman yang kadaig ng mga katopowan sikun sidtong wakto na adto da silan sang Babilon taman sang pagkaotaw ni Isa Almasi. ");
INSERT INTO kqew_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Adon, maynini yang kyatamanan ng pagkaotaw ni Isa Almasi. Si Mariyam na ina nan, tawas ni Yosop. Awgaid sang wa pa silan akawina, yamabdus da si Mariyam sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Adon, si Yosop madyaw na otaw sang pagtanaw ng Tohan. Agaw, pagkatigam nan na mabdus da si Mariyam, di nan karim na akamomowaan yan sa atobangan ng mga otaw. Agaw yagadumdum yan na buagan nan si Mariyam ng sikrito. ");
INSERT INTO kqew_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ansinyan sarta yagadumdum pa si Yosop daw ono yang inangun nan, yagatagaynup yan. Aw sa tagaynup nan aon yagapakita kanan na sambok na malaikat sikun sang Tohan aw laong nan, “Kay Yosop na topo ni Soltan Daud, ayaw pagkalluk mangasawa kang Mariyam kay yang pagkabdus nan sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amanganak yan ng usug aw pagangaanan mo yan kang Isa kay yan yang magalowas sang mga otaw na sakop nan sikun sang mga dosa nilan.” ");
INSERT INTO kqew_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, ya-inang yang kariko nini untak matoman yang pyaglaongan ng Tohan pina-agi kang Nabi Isayas na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Amabdus yang sambok na daaga aw amanganak yan ng usug. Pagangaanan yan kang Imanuel,” na yang mana nan “Idi kanatun yang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na, pagmata ni Yosop, pyangagadan nan yang pyagasogo kanan ng malaikat aw pyangasawa nan si Mariyam. ");
INSERT INTO kqew_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Awgaid wa nan saidi si Mariyam sarta wa pa yan apanganak. Sang yamanganak da si Mariyam, pyagangaanan nan yang isu kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ansinyan yaotaw si Isa sang longsod ng Baytlaham sang probinsya ng Yahodiya sang panahon ng pagkasoltan ni Hirod. Wa akadogay sinyan aon dyomatung sa Awrosalam na mga otaw sikun sang silatan. Mga mangkatigam silan na yagapangadi makapantag sang mga bitoon. ");
INSERT INTO kqew_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagdatung nilan sa Awrosalam yaga-osip silan sang mga otaw, laong nilan, “Wain ingaong isu na baya pa yamaotaw na magasoltan sang mga Yahodi? Kay adto sang silatan kinita nami yang bitoon na yan yang tanda ng pagkaotaw nan. Idto sagaw yakani kami untak magsojod kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagdungug sinyan ni Soltan Hirod, yamarido yan kipat yang kariko ng mga otaw adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agaw, yang ininang ni Soltan Hirod, pyatawag nan yang kariko ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw yosip nan silan, laong nan, “Wain kono amaotaw yang Almasi?” ");
INSERT INTO kqew_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tyomobag silan, “Adto sa Baytlaham na sakop ng Yahodiya kay yani yang syorat ng nabi singaon sang Kitab, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ikaw, kay Baytlaham na adto sa Yahodiya, amabantog kaw sang kariko ng mga longsod sa Yahodiya. Kay ansan kammo magasikun yang pangoo na maga-atiman sa bangsa Israil na silan yang mga otaw na kanak sakop.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na, pagdungug sinyan ni Soltan Hirod, pyatawag nan idtong mga mangkatigam na taga silatan aw yosip nan nang silan da gaid daw kano nilan akitaa idtong bitoon. ");
INSERT INTO kqew_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatigam da nan, pyakadto nan silan sa Baytlaham aw laong nan, “Panaw da kamo aw anapa mayo ng madyaw yang isu. Kong kitaun da mayo, patigama mayo ako untak makakadto oman ako aw makasojod ako kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Na, pagkatapos maglaong sinyan ng soltan, pyomanaw da idtong mga mangkatigam. Sarta yagapanaw silan, kinita oman nilan yang bitoon na yakita da nilan adto sang silatan. Pagkita sinyan, bali na kasowat nilan. Ansinyan yama-ona kanilan idtong bitoon sampay na yamondang yan sa babaw ng baay na kyabutangan ng isu. ");
INSERT INTO kqew_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagsuud nilan sidto na baay, kinita nilan yang isu aw yang ina nan na si Mariyam. Ansinyan syomojod silan aw byantog nilan yang isu. Pagkatapos yabrian nilan yang mga lasakanan nilan aw yatag nilan adto sang isu yang daa nilan na bowawan, toob aw paballo na tyawag ng mira. ");
INSERT INTO kqew_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, pag-ori nilan adto kanilan, yamagi silan sang tuna na daan kay pyagalaong silan ng Tohan sang tagaynup na di da silan magbarik adto kang Soltan Hirod. ");
INSERT INTO kqew_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ansinyan pagpanaw da nilan, aon malaikat ng Tohan na yagapakita kang Yosop sang tagaynup nan aw laong nan, “Bangon da aw daa yang isu aw yang ina nan aw panaw da kamo adto sa Misir. Adto da kamo pag-uya taman sang pagalaongon ta kamo na maka-ori da oman kamo. Kay anapun ni Hirod yang isu untak patayun nan.” ");
INSERT INTO kqew_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ansinyan sagaw yagabangon da si Yosop. Aw sinyan na gabi pyaga-agad nan yang isu aw yang ina nan aw pyomanaw da silan adto sa Misir. ");
INSERT INTO kqew_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Adto da silan paga-uya sampay na yamatay si Hirod. Ya-inang yani untak matoman yang pyaglaongan ng Tohan pina-agi sang sambok na nabi na laong nan, “Tyawag ko yang anak ko sikun sa Misir.” ");
INSERT INTO kqew_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pagkatigam ni Hirod na yama-ilad yan nidtong mga mangkatigam kay wa da paka-apit kanan, bali na kadaman nan. Agaw syogo nan yang kanan mga otaw na apatayun nilan yang kariko ng mga isu na usug adto sa Baytlaham aw sang makilibot na mga banwa, na yaga-idad ng dowangka toig pababa kay sobay sang pyaglaongan kanan ng mga mangkatigam idto yang wakto na ona nilan akitaa yang idto na bitoon. ");
INSERT INTO kqew_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, sang mayninyan na pama-agi yatoman yang pyaglaongan ni Nabi Irimiyas na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aon yadungug na sowara adto sang banwa ng Rama, yang sowara ng pagpangiyak aw pagminatay. Pyagatiyaowan ni Rakiya yang kanan mga anak aw di da yan malibad kay yamangkamatay da silan.” ");
INSERT INTO kqew_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ansinyan pagkamatay ni Hirod, yagapakita da oman yang malaikat ng Tohan kang Yosop sa tagaynup nan adto sang banwa ng Misir. ");
INSERT INTO kqew_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Laong nan, “Bangon da aw daa yang isu aw yang ina nan aw ori da kamo adto sa Israil kay yamatay da yang mga otaw na marim magpatay sang isu.” ");
INSERT INTO kqew_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ansinyan sagaw yagabangon da si Yosop aw pyaga-agad nan yang isu aw yang ina nan aw yamori da silan adto sa Israil. ");
INSERT INTO kqew_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Awgaid pagdungug ni Yosop na si Arkilas na anak ni Hirod yang bago na soltan sang probinsya ng Yahodiya, yamalluk yan komadto sa Yahodiya. Ansinyan aon oman pyatigam kanan ng Tohan sang tagaynup nan daw ono yang madyaw na inangun nan. Agaw kyomadto silan sang probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pagdatung nilan adto, yaga-uya silan sang longsod ng Nasarit. Na, ansinyan yatoman yang pyaglaongan ng mga nabi makapantag sang Almasi na laong nilan, “Pagatawagun yan ng taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sidto na wakto kyomadto si Yahiya na Magsosogboway sang kamingawan sa Yahodiya aw yagasogod da yan mag-osiyat sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Laong nan, “Pagtawbat kamo aw biyai mayo yang mga dosa mayo kay masaid da domatung yang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yani si Yahiya yang pyagalambit ni Nabi Isayas nang yagalaong yan, “Aon sangka otaw na manawag-tawag adto sang kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yang dagom ni Yahiya ininang sikun sang boboo ng kamil aw yang sintoron nan ininang ng paris ng ayup. Aw yang pagkan nan mga doon aw duga. ");
INSERT INTO kqew_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na, madaig yang mga otaw na kyomadto kanan sikun sa Awrosalam aw sang kadaigan pa na mga banwa sang probinsya ng Yahodiya aw sikun oman sang mga banwa na masaid sang tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yagagogod silan sang mga dosa nilan aw yagapasogbo silan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na, madaig oman yang mga Parisi aw Sadoki na mga pangoo ng agama Yahodi na kyomadto kanan untak magpasogbo. Pagkita kanilan ni Yahiya, yagalaong yan, “Kamo na mga limbongon! Sino kadi yang yagalaong kamayo na kong magapasogbo kamo makalikay kamo sang siksa ng Tohan na mallug da domatung? ");
INSERT INTO kqew_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na, kong di mayo karim na asiksaun kamo, pakitaan da gaid mayo pina-agi sang madyaw na batasan na bunna na tyarikodan da mayo yang mga dosa mayo. ");
INSERT INTO kqew_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aw ayaw kamo pagdumdum na di kamo asiksaun kay mga topo kamo ni Nabi Ibrahim. Kay ipaglaong ko kamayo na maskin yani na mga bato amabaoy ng Tohan na mga topo ni Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Timani mayo na main kamo ng kaoy na mallug da pilaun. Kay yang kariko ng kaoy na way madyaw na bonga apilaun aw damian adto sang atoon. ");
INSERT INTO kqew_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ako, tobig yang pyagasogbo ko kamayo silbi tanda na yagatawbat da kamo sang mga dosa mayo. Awgaid aon masonod kanak domatung na labaw pa kanak. Aw maskin yang pagbitbit ng sandalyas nan di dait kanak. Yang pagasogbo nan sang kadaigan kamayo yang Nyawa ng Tohan aw yang kadaigan oman asiksaun nan sang atoon adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yan da yang magahokom sang manosiya aw lainun nan yang mangkadyaw sikun sang mangkaat. Kay main yan ng otaw na magtaap ng omay. Pagkatapos magtaap, tagoon nan yang omay adto sang kamarig. Awgaid yang tipig asonogon nan sa atoon na di amatay.” ");
INSERT INTO kqew_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pagkatapos sinyan pyomanaw si Isa sikun sang probinsya ng Jalil aw kyomadto yan sang tobig ng Yordan untak magpasogbo kang Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Awgaid di gao magsogbo kanan si Yahiya, laong nan, “Nanga magapasogbo kaw kanak? Ako gao yang dait mo sogbowan.” ");
INSERT INTO kqew_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Awgaid tyomobag si Isa, laong nan, “Unda, sogbowi da ako kay dait gaid kita magpangagad sang kariko ng kahanda ng Tohan.” Ansinyan yasogot si Yahiya aw syogbowan nan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapos kasogbowan si Isa, syomaka dayon yan sikun sang tobig. Sinyan na wakto yagaboka yang langit aw kinita nan na yakunsad adto kanan yang Nyawa ng Tohan sa porma ng malapati. ");
INSERT INTO kqew_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aw aon sowara sikun sang langit na yagalaong, “Yani yang pyasaya ko na Anak. Dakowa yang kasowat ko kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ansinyan dyaa si Isa ng Nyawa ng Tohan adto sang kamingawan kay untak sasatun yan ni Iblis. ");
INSERT INTO kqew_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na, pagkatapos ni Isa magpowasa sa suud ng 40 na allaw aw 40 na gabi, yamagutum da yan. ");
INSERT INTO kqew_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ansinyan dyomood kanan yang mangsasatay aw laong nan, “Kong bunna na ikaw yang Anak ng Tohan, sogowa yani na mga bato na ma-inang ng pan.” ");
INSERT INTO kqew_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Awgaid tyomobag si Isa aw laong nan, “Yakasorat sang Kitab, ‘Yang manosiya di amabowi sabap sang pagkan gaid, kondi sabap oman sang pyaglaongan ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapos sinyan dyaa yan ni Iblis adto sa Awrosalam, yang tyawag na sotti na syodad, aw pa-induga nan adto sang labi na makagwas na bain sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ansinyan yagalaong si Iblis kang Isa, “Aw bunna na ikaw yang Anak ng Tohan, layog adto sang daum. Kay yakasorat sang Kitab na “ ‘Asogoon ng Tohan yang mga malaikat nan sang pag-atiman kammo. Asakgawon kaw nilan untak yang siki mo di komuug sang bato.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tyomobag si Isa, “Aon oman yakasorat sang Kitab na yagalaong, ‘Ayaw pagtigia yang Tohan na kammo Tagallang.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos sinyan dyaa da oman yan ni Iblis adto sang tanto mataas na butay aw pyakita nan kanan yang kariko ng mga pyagdatowan adi sa babawan ng donya aw yang kadyawan sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ansinyan yagalaong si Iblis kang Isa, “Yang kariko ninyan i-atag ko kammo kong somojod kaw kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tyomobag si Isa, “Panaw da, kay Iblis, kay yakasorat sang Kitab, ‘Yang Tohan na kammo Tagallang, yan gaid yang asambayangan aw apangagadan mo.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagkatapos sinyan pyanawan da yan ni Iblis. Ansinyan dyomatung yang mga malaikat aw yatiman nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ansinyan pagdungug ni Isa na yapiriso da si Yahiya, byomarik yan sang probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Awgaid wa da yan paga-uya adto sa Nasarit kondi adto da sa Kapirnaom, sambok na longsod sang kilid ng Linaw ng Jalil na adto yakabutang sang lopa na yatag singaon sang mga tribo ni Sibolon aw Naptali. ");
INSERT INTO kqew_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na, ansinyan yatoman yang pyaglaongan ni Nabi Isayas na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yang lopa ni Sibolon aw yang lopa ni Naptali na iyan sang daan paduug sa dagat, yang banwa na adto sang dipag ng tobig ng Yordan, yan yang banwa na tyawag oman ng Jalil na pyaga-uyaan ng mga dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yang mga otaw na yaga-uya ansan maynang iyan silan sang kadugguman, awgaid makakita da silan ng allag na labi na masilaw. Maskin iyan silan sang kadugguman aw yamalluk silan matay, aka-allagan da silan.” ");
INSERT INTO kqew_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sikun sidto na wakto yagasogod da si Isa mag-osiyat aw laong nan, “Pagtawbat kamo aw biyai mayo yang mga dosa mayo kay masaid da domatung yang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ansinyan sarta yagapanaw si Isa sang kilid ng Linaw ng Jalil, kinita nan yang dowa na maglomon na si Simon na tyawag oman ni Pitros aw yang mangod nan na si Andriyas. Yamamokot silan kay mangingisdaay silan. ");
INSERT INTO kqew_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yagalaong kanilan si Isa, “Bita da, agad kamo kanak. Sikun adon inangun ta kamo na mangingisdaay ng otaw untak magpangagad silan kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na, pagdungug sinyan biniyaan dayon nilan yang kanilan pokot aw yamagad silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ansinyan pyomanaos si Isa pagpanaw aw kinita oman nan yang dowa na maglomon na si Yakob aw si Yahiya na mga anak ni Sibidi. Yanagpona silan ng pokot adto sang bangka upud sang ama nilan. Tyawag silan ni Isa na amagad kanan. ");
INSERT INTO kqew_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ansinyan biniyaan da nilan yang bangka aw yang ama nilan aw yamagad silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ansinyan yakarimpud si Isa pomanaw sang tibok probinsya ng Jalil. Yaga-indo yan adto sang mga pagsasambayangan ng mga Yahodi aw yaga-osiyat yan ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw pyakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na, yang gogodanun makapantag kanan yakarimpud oman adto sang bangsa ng Siriya. Agaw, dyaa da ng mga otaw yang kariko ng mga masakitun adto kanan, mga otaw na bali na kasakit yang lawas nilan, mga kyasaytanan, mga pyagababoy-baboy aw mga yamasadi yang lawas nilan. Aw yang kariko nilan pyakadyaw ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ansinyan madaig yang mga otaw na yamagad kanan. Aon mga taga Jalil, aon oman sikun sang probinsya ng Dikapolis, taga Awrosalam, taga Yahodiya aw sikun oman adto sang dipag ng tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ansinyan pagkita ni Isa sinyang kaotawan na yamagad kanan, syomakat yan sang butay aw yag-ingkod ansan. Pag-ingkod nan, dyomood kanan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na, yagasogod da si Isa mag-indo, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kadyaw ng ginawa nidtong mga otaw na yamatigam na way ma-inang nilan kong di silan atabangan ng Tohan, kay yasakop da silan sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kadyaw ng ginawa nidtong mga otaw na yamarido sabap sang kaatan adi sang donya, kay libadun silan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kadyaw ng ginawa nidtong mga otaw na magpababa sang ginawa nilan, kay amakun nilan yang pyasad ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kadyaw ng ginawa nidtong mga otaw na mallini magpangagad sang karim ng Tohan, kay atabangan nan silan sang pag-inang ng karim nan. ");
INSERT INTO kqew_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kadyaw ng ginawa nidtong mga otaw na maooy sang kapag-onawa nilan, kay akaoyan oman silan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kadyaw ng ginawa nidtong mga otaw na mapoti yang pangatayan nilan, kay makakita silan sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kadyaw ng ginawa nidtong mga otaw na maga-osay sang kapag-onawa nilan, kay pagatawagun silan ng Tohan na mga anak nan. ");
INSERT INTO kqew_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kadyaw ng ginawa nidtong mga otaw na pyasikotan sabap sang pagpangagad nilan sang karim ng Tohan, kay yasakop da silan sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kadyaw ng ginawa mayo kong pag-insoltoon aw apasikotan kamo aw pagbutang-butangan kamo ng maskin ono na maat sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqew_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pagkasowat kamo kay dakowa yang baras mayo adto sa sorga. Kay maynan oman yang pagpasikot sang mga nabi singaon.” ");
INSERT INTO kqew_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yagalaong oman si Isa, “Kamo na yagapangagad kanak, main kamo ng asin adi sang donya. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. Agaw, waa day siyat nan aw idami da gaid yan adto sa logwa aw pagagina-ginaan da yan ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamo na yagapangagad kanak, main kamo ng allag adi sang donya. Na, yang allag di amatago mag-onawa ng syodad na yakabutang sa babaw ng butay. ");
INSERT INTO kqew_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Way otaw na magasuga ng ilawan aw asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan untak ka-allagan yang kariko ng mga otaw adto sa suud ng baay. ");
INSERT INTO kqew_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mag-onawa sinyan, pakitaan mayo yang allag mayo sa atobangan ng mga otaw untak makita nilan yang madyaw na batasan mayo aw pojiun nilan yang Tohan na Ama mayo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayaw kamo pagdumdum na yakani ako untak kamangan ko ng kapantagan yang Hokoman ni Nabi Mosa aw yang indowan ng mga nabi. Wa ako akani sang pagkamang sinyan, kondi yakani ako untak atagan ko yan ng bunna na katomanan. ");
INSERT INTO kqew_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa bunna-bunna na ipaglaong ko kamayo na sampay aon pay langit aw lopa di amakamang maskin yang sambok na litra atawa kodlit sikun sang Hokoman ng Tohan aw di amawaa yang kapantag sinyan sampay di amatoman yang kariko ninyan. ");
INSERT INTO kqew_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Idto sagaw, sino-sino yang somopak sang maskin labi na magaan na sogowan ng Tohan aw maga-indo sang kadaigan na somopak oman sinyan, ma-inang yan ng pinakababa adto sang pyagdatowan ng Tohan. Awgaid sino-sino yang amangagad sang mga sogowan aw maga-indo sang kadaigan na amangagad oman sinyan, ma-inang yan ng labi na dakowa adto sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Agaw ipaglaong ko kamayo kong yang pagpangagad mayo sang karim ng Tohan di makalabaw sang pagpangagad ng mga magiindoway ng Hokoman aw yang mga Parisi, di kamo makasuud sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yagalaong oman si Isa, “Yadungug mayo yang sogo adto sang mga kaompowan natun na yagalaong, ‘Ayaw pagpatay. Kay sino-sino yang magapatay sang kapag-onawa nan, dait yan hokoman.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Awgaid ako, ipaglaong ko kamayo na sino-sino yang amadaman sang kapag-onawa nan, dait yan hokoman. Aw sino-sino yang magalaong sang kapag-onawa nan na, ‘Way siyat mo,’ dait yan daun adto sang Makagwas na Hokomanan. Aw sino-sino yang magalaong sang kaupudanan nan na, ‘Bowang kaw,’ dait yan idami sang atoon adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Na, kong iyan kaw sang Baay ng Tohan untak magpakorban adto sang Tohan, aw ansinyan kyadumduman mo na aon otaw na maat yang ginawa nan kammo, ");
INSERT INTO kqew_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, bilina yang korban mo aw kadtoni mona yang idtong otaw aw pag-osay kamo. Pagkatapos, barik adto sang Baay ng Tohan aw pagpakorban. ");
INSERT INTO kqew_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kong aon otaw na magadimanda kammo, pag-osay kamo sang wa pa kamo adatung sa hokomanan. Kay kong dili, basin adaun kaw nan adto sang howes, aw ansinyan adaun kaw adto sang polis aw ilasak da kaw sang pirisowan. ");
INSERT INTO kqew_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sa bunna-bunna na ipaglaong ko kamayo na di da kaw amakalogwa sikun sinyan sampay di mo akabayadan yang kariko ng molta mo. ");
INSERT INTO kqew_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yadungug oman mayo yang sogo na yagalaong, ‘Ayaw pagjina.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Awgaid ako, ipaglaong ko kamayo na sino-sino yang matanaw sang sambok na bobay aw maganiyat ng maripa, yakajina da yan sidtong bobay sa suud ng pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Agaw sagaw, kong yang karinto na mata mo yang pyagasabapan na amakadosa kaw, lusata yan aw damian. Kay madyaw pa yang akawaan kaw ng sangkilid gaid na mata kaysang idami yang tibok lawas mo adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aw kong yang karinto na arima mo yang pyagasabapan na amakadosa kaw, otoda yan aw damian. Madyaw pa yang akawaan kaw ng sangkilid gaid na arima kaysang idami yang tibok lawas mo adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aon oman kasogowan singaon na yagalaong, ‘Sino-sino yang magabuag sang kanan asawa kinaanglan mag-atag kanan ng sorat silbi tanda na yanagbuag da silan.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Awgaid ako, ipaglaong ko kamayo na sino-sino na usug na magabuag sang asawa nan, awgaid yang asawa nan wa pagajina, makadosa da yan na usug kay ma-inang yan ng pyagasabapan na amadaa yang bobay sang pagjina kong magabana da oman yan. Aw yang usug na amangasawa sidtong bobay na byuagan, magajina oman. ");
INSERT INTO kqew_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yadungug da oman mayo yang sogo adto sang mga kaompowan natun na yagalaong, ‘Ayaw pagbarobaa yang kammo pasad, awgaid tomana yang pasad na ininang mo adto sang Tohan.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Awgaid ako, ipaglaong ko kamayo na kong magapasad kamo, ayaw da kamo pagsapa. Ayaw kamo paglaong na ipagsaksi mayo yang sorga kay yang sorga maynang ingkodanan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ayaw oman kamo paglaong na ipagsaksi mayo yang donya kay yang donya maynang tongtonganan ng siki ng Tohan. Ayaw oman kamo paglaong na ipagsaksi mayo yang Awrosalam kay yan yang syodad ng Soltan na Labi na Mabarakat. ");
INSERT INTO kqew_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aw ayaw oman kamo paglambit sang oo mayo kong magapasad kamo kay maskin yang sambok na logay mayo di mayo ma-inang na maitum atawa mapoti. ");
INSERT INTO kqew_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Awgaid yani yang madyaw na inangun mayo. Paglaong gaid kamo ng ‘Uu’ kong uu, atawa ‘Di’ kong di, aw ayaw da mayo pagdogangi. Kay maskin ono na idogang mayo sinyan untak gaid kamo pangintowan, maat yan kay magasikun yan kang Iblis. ");
INSERT INTO kqew_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yadungug da oman mayo yang sogowan na yagalaong, ‘Kong aon otaw na magalusat ng mata ng kapag-onawa nan, dait da oman lusatun yang mata nan. Yang otaw na magapangag sang kapag-onawa nan, dait oman yan pangagan.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Awgaid ako, ipaglaong ko kamayo na ayaw kamo panimaus sang otaw na yaga-inang kamayo ng maat. Kong aon magasampal sang karinto na pisngi mo, pasampalan oman kanan yang kawaa. ");
INSERT INTO kqew_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kong aon magadimanda kammo untak kamangun gao yang kammo dagom, madyaw pa kong i-atag oman kanan yang kammo dagmay. ");
INSERT INTO kqew_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kong aon sondao na magapugus kammo sang pagdaa ng kanan karga ng sangka kilomitro, madyaw pa kong adaun mo ng dowangka kilomitro. ");
INSERT INTO kqew_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na, atagi yang amangayo kammo, aw pahirama yang magahiram gao kammo. ");
INSERT INTO kqew_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yadungug da oman mayo yang sogowan na yagalaong, ‘Kaoyi yang kaupudanan mo aw dumuti yang kalaban mo.’ ");
INSERT INTO kqew_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Awgaid ako, ipaglaong ko kamayo na kaoyi yang kalaban mayo aw pangayowi ng kadyawan idtong yagapasikot kamayo. ");
INSERT INTO kqew_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kay kong maynan yang inangun mayo, ma-inang kamo ng bunna na mga anak ng Tohan na Ama mayo adto sa sorga. Kay pasilatun nan yang suga untak ka-allagan yang kariko ng mga otaw na mangkadyaw aw yang mangkaat. Aw atagan oman nan silan ng owan, yang mga otaw na matorid aw yang yaga-inang ng maat. ");
INSERT INTO kqew_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na, kong kaoyan gaid mayo yang mga otaw na maooy oman kamayo, ono yang baras mayo? Waa! Kay maskin yang mga kobrador ng bowis na kinilaa na mga limbongon, matigam silan magkaooy sang mga yamaooy kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aw kong pagsalaman gaid mayo yang mga kalomonan mayo, ono yang ininang mayo na labaw pa sang kadaigan? Kay maskin yang mga wa apangintoo sang Tohan yaga-inang ng mayninyan. ");
INSERT INTO kqew_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Agaw sagaw dait na madyaw yang batasan mayo na way ikasaway kamayo mag-onawa ng Tohan na Ama mayo adto sa sorga na yan way ikasaway. ");
INSERT INTO kqew_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Timani mayo na di kamo mag-inang ng pag-ibada mayo sa atobangan ng mga otaw untak kitaun gaid nilan. Kay kong maynan yang inangun mayo, waa day baras kamayo ng Tohan na Ama mayo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Agaw, kong maga-atag kamo ng sidoka adto sang mga miskinan, ayaw kamo pagpasigarbo sang ininang mayo na mag-onawa ng mga otaw na yagapakita-kita gaid. Kay magasidoka silan sang mga miskinan adto sang mga pagsasambayangan atawa sang mga daan untak bantogon silan ng mga otaw. Sa bunna-bunna na ipaglaong ko kamayo na yadawat da nilan yang baras nilan aw waa day baras kanilan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Awgaid kamo, kong magasidoka kamo sang mga miskinan, ayaw mayo pagpatigama sang maskin sino ");
INSERT INTO kqew_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kay untak way otaw na matigam. Aw ansinyan abarasan kamo ng Tohan na Ama mayo na yan yang yamatigam sang ininang mayo sang tago. ");
INSERT INTO kqew_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kong magadowaa kamo, ayaw kamo pagsiling sang mga otaw na yagapakita-kita gaid. Kay mallini silan magdowaa na yaga-indug adto sang mga pagsasambayangan aw adto oman sang mga kanto untak kitaun silan ng mga otaw. Sa bunna-bunna na ipaglaong ko kamayo na yadawat da nilan yang baras nilan. ");
INSERT INTO kqew_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Awgaid kamo, kong magadowaa kamo, pagsuud kamo sang kowarto aw siradowi mayo. Aw adto da kamo magdowaa sang Tohan na Ama mayo na di amakita. Aw ansinyan abarasan kamo ng Ama mayo na yakakita sang ininang mayo sang tago. ");
INSERT INTO kqew_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kong magadowaa kamo, ayaw mayo pagbarik-barika yang mga pyaglaongan mayo mag-onawa ng ininang ng mga otaw na wa apangintoo sang Tohan. Kay yagadumdum silan na atobagun yang pagdowaa nilan kong madaig yang pyaglaongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ayaw kamo pagsiling kanilan kay kyatigaman ng Tohan na Ama mayo daw ono yang kinaanglan mayo maskin wa pa kamo pagapangayo kanan. ");
INSERT INTO kqew_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Agaw kong magadowaa kamo, maynini yang ipaglaong mayo, “ ‘Ya Tohan na Ama nami adto sa sorga, addatan gao yang ngaan mo kay ikaw sotti. ");
INSERT INTO kqew_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Magadato da kaw gao sang kariko ng manosiya. Aw agadan gao yang kahanda mo adi sang donya mag-onawa ng yagadan da yan adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Atagi kami ng pagkan na kinaanglan nami ng matag allaw. ");
INSERT INTO kqew_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aw ampona kami sang mga dosa nami kay amponon oman nami yang yakadosa kanami. ");
INSERT INTO kqew_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pakawata kami sang mga sasat aw lowasa kami sikun sang kaatan.’ ");
INSERT INTO kqew_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na, kong amponon mayo yang yakadosa kamayo, amponon oman kamo ng Tohan na Ama mayo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Awgaid kong di mayo amponon yang yakadosa kamayo, di oman kamo amponon ng Tohan na Ama mayo. ");
INSERT INTO kqew_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kong magapowasa kamo, ayaw mayo pakitaan sang parangay mayo na maynang yamarido kamo mag-onawa ng mga otaw na yagapakita-kita gaid. Kay di silan magpowamos ni magsodlay untak katigaman ng mga otaw na yagapowasa silan. Sa bunna-bunna na ipaglaong ko kamayo na yadawat da nilan yang baras nilan aw waa day baras kanilan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Awgaid kamo, kong magapowasa kamo, pagpowamos aw pagsodlay kamo ");
INSERT INTO kqew_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","untak way yamatigam na yagapowasa kamo yatabiya yang Tohan na Ama mayo na di amakita. Aw ansinyan abarasan kamo ng Ama mayo na yakakita sang ininang mayo sang tago. ");
INSERT INTO kqew_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ayaw kamo pagtipon ng kakawasaan adi sang donya kay akutkutun da yan ng anay atawa makaring atawa apangkawatun pa ng kawatan. ");
INSERT INTO kqew_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Awgaid pagtipon kamo ng kakawasaan adto sa sorga kay di yan asapadan ng anay atawa karing aw di oman apangkawatun ng kawatan. ");
INSERT INTO kqew_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kay daw wain yang kakawasaan mayo, adto oman yang pangatayan mayo. ");
INSERT INTO kqew_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yang mata maynang ilawan ng lawas ng otaw. Kong madyaw yang mata mo, matinaw yang pananaw mo. Yang mana nan na ma-allag yang dumduman mo kay di kaw amasina kong aridskian yang kapag-onawa mo. ");
INSERT INTO kqew_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Awgaid kong dili ng madyaw yang mata mo, hanap yang pananaw mo. Na, yang mana nan na sabap sang pagkasingit mo maynang iyan kaw sang kadugguman. ");
INSERT INTO kqew_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Way allang na dowa yang amo nan. Kay yang sambok adumutan nan aw yang sambok addatan nan. Yang sambok apangagadan nan aw yang sambok asopakun nan. Mag-onawa sinyan, kong dakowa yang sapi sang pangatayan mayo, di kamo makapangagad sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Agaw sagaw ipaglaong ko kamayo na ayaw kamo pagkarido sang kinabowi mayo daw ono yang akanun aw inumun mayo, atawa ono yang apandagomon mayo. Kay yang kinabowi mayo labaw pa sang pagkan aw yang lawas mayo labaw pa sang dagom. ");
INSERT INTO kqew_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tanawa mayo yang mga langgam. Di silan mananum, di silan maggani aw di silan magtipon ng pagkan sang mga kamarig. Awgaid pyakan silan ng Tohan na Ama mayo adto sa sorga. Na, di ba, labaw pa yang bili mayo kaysang mga langgam? ");
INSERT INTO kqew_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sino kamayo yang makapataas sang kinabowi nan ng maskin tagbis da gaid sabap sang pagkarido? ");
INSERT INTO kqew_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Mag-onawa sinyan, nanga yamarido kamo sang apandagomon mayo? Tanawa mayo yang mga bolak daw monono yang pagtorin nilan. Di silan maggawbuk aw di silan maglaa. ");
INSERT INTO kqew_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Awgaid ipaglaong ko kamayo na maskin yang mga dagom ni Soltan Solayman na bali na kawasa nan wa paka-upung sang kadyaw sini na mga bolak. ");
INSERT INTO kqew_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na, kong maynan yang pagpandagom ng Tohan sang sagbut na bowi adon awgaid kisuum asonogon da, kamo pa na manosiya, di ba nan kamo atagan ng dagom? Katagbi ng pagpangintoo mayo! ");
INSERT INTO kqew_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Agaw sagaw, ayaw kamo pagkarido daw ono yang akanun atawa inumun mayo atawa ono yang apandagomon mayo. ");
INSERT INTO kqew_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kay yani maag yang kyaridowan ng mga otaw na wa apangintoo sang Tohan. Awgaid kamo, ayaw kamo pagkarido kay kyatigaman ng Ama mayo adto sa sorga na kinaanglan mayo yani na mga butang. ");
INSERT INTO kqew_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Awgaid onaa mayo yang pagpasakop sang pagdato ng Tohan aw yang pagtoman sang karim nan aw ansinyan atagan kamo ng kariko ng kinaanglan mayo. ");
INSERT INTO kqew_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Agaw sagaw, ayaw kamo pagkarido daw ono yang ma-inang kisuum. Osto da yang mga kasikotan ng matag allaw. Agaw, ayaw da mayo dogangi ng pagkarido sa sonod pa na mga allaw. ");
INSERT INTO kqew_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ayaw kamo paghokom sang kapag-onawa mayo untak di oman kamo hokoman ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay hokoman kamo ng Tohan mag-onawa ng paghokom mayo sang kadaigan. Yang pangsokat na agamitun mayo sang kadaigan, yan oman yang ipangsokat kamayo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nanga kono kinita mo yang bagaso sang mata ng lomon mo, awgaid yang kaoy na iyan sang mata mo pyasagdan da mo? ");
INSERT INTO kqew_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nanga makapaglaong kaw sang lomon mo, ‘Tabiya, kay lomon, akamangun ko ona yang bagaso sang mata mo,’ sarta aon kaoy sang kammo mata? ");
INSERT INTO kqew_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikaw na yagapakita-kita gaid, kamanga ona yang kaoy sang mata mo untak kaw makakita ng madyaw sang pagkamang ng bagaso sang mata ng lomon mo.” ");
INSERT INTO kqew_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yagalaong oman si Isa, “Ayaw kamo pag-atag ng labi na mahalaga adto sang mga ido kay basin akagatun kamo nilan. Aw ayaw kamo pagdami ng kamayo perlas adto sang mga binatang kay pagagina-ginaan da gaid nilan. ");
INSERT INTO kqew_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pangayo kamo kay atagan kamo. Panganap kamo kay makakita kamo. Pagtawag kamo kay apasuudun kamo. ");
INSERT INTO kqew_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kay sino-sino yang amangayo atagan, aw sino-sino yang amanganap makakita sang pyagapanganap nan, aw sino-sino yang magatawag, apasuudun. ");
INSERT INTO kqew_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kamo na mga taganak, kong amangayo ng pagkan yang kamayo anak, atagan ba mayo ng bato? ");
INSERT INTO kqew_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kong amangayo yan ng isda, atagan ba mayo ng od? ");
INSERT INTO kqew_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na, kong kamo na maat na mga manosiya matigam mag-atag ng madyaw na mga butang adto sang mga anak mayo, labi-labi da yang Tohan na Ama mayo adto sa sorga! Sa way dowa-dowa i-atag nan yang maskin ono na madyaw adto sang otaw na amangayo kanan. ");
INSERT INTO kqew_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Agaw sagaw pag-inang kamo sang kapag-onawa mayo daw ono yang karim mayo na inangun nilan kamayo. Yani yang kinatibokan ng Hokoman ni Nabi Mosa kipat yang indowan ng mga nabi. ");
INSERT INTO kqew_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pagsuud kamo sang mapiyut na powertaan. Kay maowag yang powertaan aw masayun yang daan paduug sang narka. Aw madaig yang yamagi sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Awgaid mapiyut yang powertaan aw masikot yang daan paduug sang kinabowi na way kataposan. Aw tagbi gaid yang yakakita sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pagbantay kamo sang mga otaw na yagalaong na mga nabi kono silan, awgaid dili kadi ng bunna. Yang pyaglaongan nilan maynang madyaw paningugan, awgaid main silan ng maisug na ido na amakasapad kamayo. ");
INSERT INTO kqew_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amakilaa mayo silan sabap sang ininang nilan mag-onawa na akatigaman mayo yang kaoy sabap sang bonga nan. Kay di maka-ipo ng grips sang sampinit, aw di oman maka-ipo ng igira sang bowa. ");
INSERT INTO kqew_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kong madyaw yang kaoy madyaw oman yang bonga nan, awgaid kong dili ng madyaw yang kaoy maat yang bonga nan. ");
INSERT INTO kqew_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kay yang madyaw na kaoy di makabonga ng maat, aw yang kaoy na dili ng madyaw di oman makabonga ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na, yang kariko ng kaoy na dili ng madyaw yang bonga, apilaun aw damian adto sang atoon. ");
INSERT INTO kqew_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Idto sagaw, akatigaman mayo yang mga magpapayapatay na dili ng bunna kong tanawon mayo yang ininang nilan. ");
INSERT INTO kqew_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Madaig yang mga otaw na yagalaong na ako yang Dato nilan, awgaid dili ng kariko nilan amasakop sang pyagdatowan ng Tohan kondi silan gaid na yagapangagad sang karim ng Tohan na kanak Ama adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pagdatung ng allaw ng paghokom, madaig yang mga otaw na magalaong kanak, ‘Kay Dato, sang kammo ngaan pyapayapat nami yang pyaglaongan ng Tohan. Aw sang ngaan mo pyalogwa nami yang mga saytan aw madaig oman yang mga katingaan na ininang nami sabap sang kabarakat mo.’ ");
INSERT INTO kqew_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Awgaid magalaong ako kanilan, ‘Wa ako akilaa kamayo. Panaw da kamo, kamo na yaga-inang ng maat!’ ");
INSERT INTO kqew_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Agaw, sino-sino yang amaningug aw amangagad sang pyaglaongan ko, mag-onawa yan ng matigamay na otaw na yaga-inang ng baay sa babaw ng bato. ");
INSERT INTO kqew_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kay maskin dakowa yang owan aw yagabaa aw yasogat idtong baay ng makusug na samut, wa yan akatowad kay bato yang pyagapa-indugan nan. ");
INSERT INTO kqew_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Awgaid sino-sino yang amaningug sang pyaglaongan ko awgaid di amangagad sinyan, mag-onawa yan ng sangu na yaga-inang ng baay sa babaw ng bowangin. ");
INSERT INTO kqew_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kay pagdatung ng dakowa na owan aw yagabaa aw yasogat idtong baay ng makusug na samut, na, yatowad da yan aw yadanas.” ");
INSERT INTO kqew_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos ni Isa maglaong sinyan, yangkatingaa yang mga otaw sang pag-indo nan. ");
INSERT INTO kqew_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kay yaga-indo si Isa na aon kapatot nan aw dili mag-onawa ng mga magiindoway ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagkatapos mag-osiyat lyomodsad si Isa sikun sang butay aw madaig yang mga otaw na yamagad kanan. ");
INSERT INTO kqew_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ansinyan dyomood kanan yang sangka otaw na sanglaun. Syomojod yan sa atobangan nan aw laong nan, “Kay Dato, aw karim mo, makapagkadyaw kaw sang kanak sakit.” ");
INSERT INTO kqew_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ansinyan dyapunan ni Isa yang inyan na otaw ng arima nan aw laong nan, “Uu, karim ko. Amadyaw da kaw.” Na, sinyan na wakto yawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ansinyan yagalaong kanan si Isa, “Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Aw pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqew_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ansinyan pagdatung ni Isa sang longsod ng Kapirnaom, aon syomongon kanan na sangka otaw na kapitan ng mga sondao na taga Roma. Yaga-angyo yan kanan ");
INSERT INTO kqew_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aw laong nan, “Kay Sir, yang sogowanun ko yagakowang adto sang baay na yamasakit. Di da yan makaliyuk aw bali na kasakit nan.” ");
INSERT INTO kqew_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tyomobag si Isa, “Unda, akadtonan da ko aw apakadyawon ko yan.” ");
INSERT INTO kqew_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Awgaid yagalaong yang kapitan, “Kay Sir, ayaw da pagkadto kay way kapatot ko pagtarima kammo sang kanak baay. Paglaong gaid aw amadyaw da yang sogowanun ko. ");
INSERT INTO kqew_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kyatigaman ko yani kay ako yagapasakop sang labaw pa kanak aw aon oman mga sondao ko na yagapasakop kanak. Kong sogoon ko yang isa, ‘Adto kaw,’ makadto yan. Kong sogoon ko yang isa, ‘Adi kaw,’ makani yan. Aw kong sogoon ko yang kanak sogowanun, ‘Inanga yani,’ na, inangun da nan.” ");
INSERT INTO kqew_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagdungug sinyan ni Isa, yatingaa yan aw yagalaong yan sang mga otaw na yamagad kanan, “Sa bunna-bunna na ipaglaong ko kamayo na waa pay kinita ko na otaw na bangsa Israil na maynini kadakowa ng pagpangintoo nan. ");
INSERT INTO kqew_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Timani mayo yani! Sang madatung na mga allaw madaig yang mga dili ng Yahodi sikun sang yagakatuna-tuna na mga banwa sa silatan aw sallupan na manag-upud kang Ibrahim, Isahak aw si Yakob sang kandori adto sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Awgaid madaig yang mga otaw na bangsa Israil na silan gao yang amasakop sang pyagdatowan ng Tohan, awgaid di silan amakasuud. Idami silan ng Tohan adto sa logwa sang kadugguman aw adto da silan magtiyao aw mangolitub yang onto nilan.” ");
INSERT INTO kqew_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ansinyan yagalaong si Isa sang kapitan, “Ori da, aw amatoman yang pyangayo mo sabap sang pagpangintoo mo.” Aw sinyan na wakto yamadyaw da yang sogowanun nan. ");
INSERT INTO kqew_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ansinyan kyomadto si Isa sang baay ni Pitros. Pagdatung nan ansan, kinita nan yang ogangan na bobay ni Pitros na yagakowang kay labi na mapaso yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ansinyan tyakmagan ni Isa yang arima ng bobay aw yawaa dayon yang kapaso ng lawas nan. Na, yagabangon da yan aw pakana nan sang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagkasilum da, madaig yang mga otaw na kyasaytanan na dyaa adto kang Isa. Pyalogwa ni Isa yang mga saytan sikun sidtong mga otaw sang sambok gaid na paglaong aw pyakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ininang nan yani kay untak matoman yang pyaglaongan ni Nabi Isayas na laong nan, “Yan mismo yang yakamang sang kanatun mga sakit aw yagapakadyaw kanatun.” ");
INSERT INTO kqew_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sangallaw sinyan pagkita ni Isa na madaig yang mga otaw na yanagkatipon sang palibot nan, yagalaong yan sang mga inindowan nan, “Mataripag da kita sang linaw.” ");
INSERT INTO kqew_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sinyan na wakto dyomood kanan yang sambok na magiindoway ng Hokoman aw yagalaong yan kanan, “Kay Goro, amagad ako kammo maskin wain kaw kadto.” ");
INSERT INTO kqew_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tyomobag si Isa aw laong nan, “Yang mga milo aon kanilan tagowanan aw yang mga langgam aon kanilan pogad. Awgaid ako na Anak ng Manosiya, way kanak logar na akakowangan ko.” ");
INSERT INTO kqew_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aon oman sambok na inindowan nan na yagalaong kanan, “Kay Dato, mori pa ako kay ilubung pa ko yang kanak ama.” ");
INSERT INTO kqew_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Awgaid yagalaong si Isa kanan, “Pabayai yang paglubung ng mga patay adto sang mga otaw na main oman ng patay kay wa silan apangintoo kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ansinyan syomakay si Isa sang bangka upud sang mga inindowan nan aw larga da silan. ");
INSERT INTO kqew_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na, tyomokaw moyop yang makusug na samut aw kyalasakan da ng tobig yang kanilan bangka. Awgaid si Isa yatoog. ");
INSERT INTO kqew_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Agaw dyood yan ng mga inindowan nan aw pokawa nilan. Laong nilan, “Kay Dato, tabangi kami! Amatay da kita!” ");
INSERT INTO kqew_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yagalaong si Isa kanilan, “Nanga yamalluk kamo? Katagbi ng pagpangintoo mayo!” Ansinyan yagabangon yan aw syagda nan yang samut aw yang mga baud. Na, ansinyan yamalinaw da. ");
INSERT INTO kqew_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yangkatingaa da yang mga inindowan nan aw yagalaong silan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud matoman kanan?” ");
INSERT INTO kqew_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ansinyan pagdatung nilan adto sang dipag ng linaw sang logar ng mga taga Gadara, syongon si Isa ng dowangka otaw na lyomogwa sikun sang mga langob na pakoboran. Yani na dowangka otaw kyasaytanan aw makallukay sagaw silan. Agaw, way maka-agi sinyan na daan. ");
INSERT INTO kqew_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ansinyan yagapiyagit silan aw laong nilan, “Ikaw na Anak ng Tohan, ono yang labot mo kanami? Yakani kaw sang pagsiksa kanami maskin di pa wakto ng paghokom?” ");
INSERT INTO kqew_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, dili ng mawat kanilan aon dakowa na panon ng mga binatang na yanagdowang. ");
INSERT INTO kqew_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agaw yaga-angyo yang mga saytan kang Isa aw laong nilan, “Aw bogawon mo kami, adto da kami pasuuda sidtong mga binatang.” ");
INSERT INTO kqew_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Unda, kadto da kamo!” laong ni Isa. Ansinyan lyomogwa da yang mga saytan sikun sinyang dowangka otaw aw syomuud silan sang mga binatang. Aw yang tibok panon dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangka-umus. ");
INSERT INTO kqew_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod kay igogod nilan sang mga otaw yang kariko ng yamaitabo kipat yang ya-inang sidtong mga kyasaytanan. ");
INSERT INTO kqew_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Agaw sagaw yang kariko ng mga otaw sidtong longsod kyomadto kang Isa aw yanagpangayo silan kanan na apanawan da nan yang banwa nilan. ");
INSERT INTO kqew_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ansinyan syomakay silan Isa sang bangka aw byomarik da silan adto sang dipag sang banwa na pyaga-uyaan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ansinyan aon dyomatung na mga otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. Na, pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, pabagsuga yang pangatayan mo kay yampon da kaw sang mga dosa mo.” ");
INSERT INTO kqew_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na, aon oman mga otaw ansan na mga magiindoway ng Hokoman. Pagdungug nilan sinyan, yagalaong silan sang ginawa nilan, “Astaga! Yani na otaw yaga-akun ng kapatot ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Awgaid kyatigaman ni Isa yang dumduman nilan, agaw yagalaong yan, “Nanga maat yang dumduman mayo? ");
INSERT INTO kqew_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wain yang masayun paglaong, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon aw panaw?’ ");
INSERT INTO kqew_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Adon, untak katigaman mayo na ako na Anak ng Manosiya, aon kapatot ko adi sa babawan ng donya pag-ampon sang mga dosa, apakadyawon da ko yani na otaw.” Ansinyan yagalaong yan sidtong otaw na sadi, “Pagbangon, daa yang kowangan mo aw ori da adto kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ansinyan yagabangon da yan aw yamori. ");
INSERT INTO kqew_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkita sinyan ng mga otaw, yangkalluk silan aw pyoji nilan yang Tohan sabap ng yatag nan sang manosiya yang mayninyan na kapatot. ");
INSERT INTO kqew_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ansinyan pyanawan da ni Isa yang inyan na baay. Sarta yagapanaw yan, kinita nan yang sambok na kobrador ng bowis na yaga-ingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Matiyo. Laong ni Isa kanan, “Bita da, agad kanak.” Ansinyan yamindug dayon si Matiyo aw agad kanan. ");
INSERT INTO kqew_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wa akadogay sinyan yanagpangan si Isa aw yang mga inindowan nan adto sang baay ni Matiyo. Madaig oman yang mga kobrador ng bowis aw yang kadaigan pa na mga otaw na tyawag na baradosa na yanag-upud kanilan koman. ");
INSERT INTO kqew_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagkita sinyan ng mga Parisi, yagalaong silan sang mga inindowan ni Isa, “Nanga yakan yang kamayo goro upud sang mga kobrador ng bowis aw yang mga baradosa?” ");
INSERT INTO kqew_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Awgaid yakadungug sinyan si Isa, agaw yagalaong yan, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. ");
INSERT INTO kqew_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na, dait sosiun mayo daw ono yang mana ng yakasorat sang Kitab na yagalaong, ‘Way karim ko sang mga ayup na ipakorban mayo kanak, kondi yani yang karim ko na maooy kamo sang kapag-onawa mayo.’ Mag-onawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan, kondi para sang mga baradosa kay untak magtawbat silan.” ");
INSERT INTO kqew_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ansinyan aon mga inindowan ni Yahiya na Magsosogboway na kyomadto kang Isa aw yaga-osip silan kanan, laong nilan, “Kami aw yang mga Parisi yabay magpowasa, awgaid yang mga inindowan mo di magpowasa. Nanga?” ");
INSERT INTO kqew_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tyomobag si Isa kanilan pina-agi sang pasombingay, laong nan, “Mapakay ba na di amasowat yang mga bisita sang kawin sarta iyan pa kanilan yang usug na akawinun? Dili! Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun. Ansinyan magapowasa da silan.” ");
INSERT INTO kqew_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na, yagalaong oman si Isa ng tuna pa na pasombingay makapantag sang dadaan na indowan aw yang indowan nan, laong nan, “Way otaw na magatompaa ng bago na tela sang dadaan na dagom. Kay kong makoyot idtong tyompaa, amalasi da oman yang dagom aw labi da yang lasi nan. ");
INSERT INTO kqew_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Way oman otaw na yang bago na bino ilasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, maasag da yang bino aw amasapad yang lasakanan. Agaw sa, yang bago na bino dait ilasak sang bago na lasakanan na abay pa ma-onat untak di masayang yang bino aw di oman amasapad yang lasakanan.” ");
INSERT INTO kqew_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Adon, sarta yagalaong pa si Isa dyomatung yang sambok na pangoo ng pagsasambayangan ng mga Yahodi. Syomojod yan sa atobangan ni Isa aw laong nan, “Yang anak ko na bobay baya pa yamatay. Awgaid kong kadtonan mo aw dapunan mo ng arima mo, amabowi oman yan.” ");
INSERT INTO kqew_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ansinyan yamindug si Isa aw yamagad kanan. Aw yamagad oman yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Adon, aon sambok na bobay na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. Dyomood yan kang Isa sang likod nan aw takmagi nan yang sagayadan ng dagom nan. ");
INSERT INTO kqew_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kay yagalaong yan sang ginawa nan, “Aw makatakmag gaid ako sang dagom ni Isa, amadyaw da ako.” ");
INSERT INTO kqew_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ansinyan lyomingi si Isa aw kinita nan yang bobay. Yagalaong yan kanan, “Kay Bi, pabagsuga yang pangatayan mo. Sabap sang pagpangintoo mo yamadyaw da kaw.” Aw sinyan na wakto yamadyaw da yang bobay. ");
INSERT INTO kqew_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ansinyan dyomatung silan Isa sang baay ni Yairos. Pagsuud ni Isa sang baay, kinita nan yang mga otaw na yanagsoring para sang paglubung aw yang mga otaw na yanagsitiyao. ");
INSERT INTO kqew_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ansinyan yagalaong yan kanilan, “Logwa da kamo! Dili ng patay yang isu, kondi yatoog gaid yan.” Awgaid inikuan da nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na, paglogwa da ng mga otaw, syomuud si Isa sang kowarto ng isu. Tyakmagan nan yang arima ng isu aw yagabangon da yan. ");
INSERT INTO kqew_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ansinyan yakarimpud yang gogodanun makapantag sini na ininang ni Isa sang kariko ng makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ansinyan pagpanaw ni Isa sinyan na baay, aon dowangka otaw na bota na yagasonod kanan. Yagapiyagit silan aw laong nilan, “Anak ni Daud, kallati kami!” ");
INSERT INTO kqew_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na, pagsuud ni Isa sang baay na pyaga-uyaan nan, syomuud oman idtong dowangka bota aw dyomood silan kanan. Ansinyan yosip silan ni Isa, “Yagapangintoo kamo na makapagkadyaw ako kamayo?” Tyomobag silan, “Uu, kay Dato.” ");
INSERT INTO kqew_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ansinyan dyapunan ni Isa yang mata nilan ng arima nan aw laong nan, “Sabap sang pagpangintoo mayo ma-inang yan kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na, ansinyan yakakita da silan. Pagkatapos, syagda silan ni Isa, laong nan, “Ayaw gaid kamo paggogod sinyan sang maskin sino.” ");
INSERT INTO kqew_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Awgaid pagpanaw nilan, gyogod nilan yang makapantag sini na ininang ni Isa sang kariko ng makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Adon, pagpanaw sidtong mga bota, aon dyaa adto kang Isa na sambok na otaw na yama-amang sabap ng kyasaytanan yan. ");
INSERT INTO kqew_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Awgaid pagkatapos ni Isa palogwaun yang saytan sikun sinyan na otaw, yakapaglaong da oman yan. Yangkatingaa da yang kariko ng mga otaw aw yanaglaong silan, “Sokad-sokad waa pay kinita natun na mag-onawa sini sang tibok banwa ng Israil.” ");
INSERT INTO kqew_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Awgaid yagalaong yang mga Parisi, “Yang pangoo ng mga saytan yang yaga-atag kanan ng kabarakat pagpalogwa ng mga saytan.” ");
INSERT INTO kqew_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pagkatapos sinyan yakarimpud si Isa komadto sang kariko ng mga longsod aw baryo aw yaga-indo yan adto sang mga pagsasambayangan ng mga Yahodi. Yaga-osiyat yan ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw pyakadyaw nan yang mga otaw sikun sang kariko ng mga sakit nilan. ");
INSERT INTO kqew_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na, pagtanaw ni Isa sang kadaig ng mga otaw, yamaooy yan kanilan kay madaig yang mga kasikotan nilan, awgaid way yakatabang kanilan. Main silan ng mga karniro na way magbabantayay. ");
INSERT INTO kqew_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Agaw yagalaong yan sang mga inindowan nan, “Madaig yang ganiunun, awgaid tagbi da yang maggagani. ");
INSERT INTO kqew_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Idto sagaw, pagpangayo-ngayo kamo adto sang Tohan na tagtomon ng ganiunun na magapadaa yan ng mga maggagani sang ganiunun nan.” ");
INSERT INTO kqew_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ansinyan tyawag ni Isa yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw yatagan nan silan ng kapatot pagpalogwa ng mga saytan aw pagpakadyaw ng maskin ono na sakit. ");
INSERT INTO kqew_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, yani yang mga ngaan ng sampoo aw dowa na mga sahabat nan. Ona, si Simon na pyagangaanan oman kang Pitros, aw yang kanan lomon na si Andriyas. Sonod si Yakob aw yang kanan lomon na si Yahiya na mga anak ni Sibidi. ");
INSERT INTO kqew_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Sonod si Pilip aw si Bartolomi, si Tomas, si Matiyo na kobrador ng bowis, aw si Yakob na anak ni Alpiyo. Sonod si Tadiyos ");
INSERT INTO kqew_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aw si Simon na rebelde singaon, aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yani na sampoo aw dowa na mga sahabat syogo ni Isa pagpanaw aw paglaonga nan silan, laong nan, “Ayaw kamo pagkadto sang mga banwa ng dili ng Yahodi atawa sang mga longsod ng mga taga Samariya. ");
INSERT INTO kqew_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Awgaid kadto kamo sang mga topo ni Israil kay mag-onawa silan ng mga karniro na yamangkawaa. ");
INSERT INTO kqew_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panaw kamo aw pagpayapat kamo na mallug da domatung yang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakadyawa mayo yang mga masakitun aw bowia mayo yang mga patay. Pakadyawa mayo yang mga sanglaun aw palogwaa mayo yang mga saytan sikun sang mga otaw. Dyawat mayo yani na kapatot ng way bayad, agaw pagtabang oman kamo ng way bayad. ");
INSERT INTO kqew_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ayaw kamo pagdaa ng sapi na bowawan atawa pilak sang bolsa mayo. Maskin pa sinsilyo, ayaw da mayo daa. ");
INSERT INTO kqew_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ayaw oman kamo pagdaa ng maskin ono na lasakanan, mga ilisan, sandalyas atawa songkod. Kay yang maggawbukay dait atagan ng panginaanglan nan. ");
INSERT INTO kqew_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Maskin wain na longsod atawa baryo yang adatungan mayo, panganap kamo ng otaw na magatarima kamayo aw ansan da kamo mag-uya taman sang pagpanaw mayo. ");
INSERT INTO kqew_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagdatung mayo sang sambok na baay, pagsalam ona. ");
INSERT INTO kqew_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kong tarimaun kamo ng mga otaw san na baay, kanilan da yang salam na pyagapangayo mayo. Awgaid kong di kamo nilan tarimaun, bawia da oman mayo yang salam na pyagapangayo mayo. ");
INSERT INTO kqew_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kong aon baay atawa banwa na akadtonan mayo aw yang mga otaw ansan di magatarima kamayo ni amaningug sang pyaglaongan mayo, panawi mayo silan. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sa bunna-bunna na ipaglaong ko kamayo na pagdatung ng allaw ng paghokom, labaw pa yang siksa sidtong mga otaw kaysang siksa sang mga taga Sodom aw Gomora. ");
INSERT INTO kqew_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Na adon, asogoon ta kamo na main kamo ng mga karniro adto sang mga otaw na main ng mangka-isug na mga ido. Agaw dait na alisto yang dumduman mayo na mag-onawa ng od, aw mapoti yang pangatayan mayo na mag-onawa ng malapati. ");
INSERT INTO kqew_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pagbantay kamo kay adakupun kamo ng mga otaw aw adaun kamo adto sang mga hokomanan aw abadasan kamo adto sang mga pagsasambayangan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sabap sang pagpangintoo mayo kanak adaun kamo adto sa atobangan ng mga gobirnador aw mga soltan. Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan aw adto oman sang mga dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na, kong adakupun aw adaun kamo adto sang hokomanan, ayaw kamo pagkarido daw ono yang ipaglaong atawa ikatobag mayo, kay sinyan na wakto ipatigam kamayo daw ono yang dait mayo paglaong. ");
INSERT INTO kqew_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aw idtong ipaglaong mayo di magasikun sang dumduman mayo kondi sang Nyawa ng Tohan na Ama mayo. ");
INSERT INTO kqew_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sinyan na mga allaw aon mga otaw na magapadakup sang kanilan mga lomon untak silan patayun. Aon oman mga ama na magapadakup sang kanilan mga anak untak silan patayun. Aw aon mga anak na malaban sang taganak nilan aw ipapatay nilan silan. ");
INSERT INTO kqew_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kamo oman, adumutan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. Awgaid kong magapadayon kamo sang pagpangintoo mayo kanak sampay sang kataposan sini na mga kasikotan, amalowas kamo. ");
INSERT INTO kqew_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kong apasikotan kamo sa sambok na banwa, panaw kamo adto sang tuna na banwa. Sa bunna-bunna na ipaglaong ko kamayo na sang di pa mayo akadtonan aw pag-osiyatan yang kariko ng mga banwa adi sang Israil, mabarik oman ako na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Way inindowan na labaw pa sang kanan goro, aw way sogowanun na labaw pa sang kanan amo. ");
INSERT INTO kqew_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Agaw dait manginsokor yang inindowan kong maga-onawa da yan sang kanan goro. Aw dait manginsokor yang sogowanun kong maga-onawa da yan sang kanan amo. Na, kong ako na Dato mayo tyawag ng mga otaw na Bilsibol, sa way dowa-dowa labi pa na maat yang pagatawag nilan kamayo na mga sakop ko. ");
INSERT INTO kqew_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Awgaid maskin maynan, ayaw kamo pagkalluk sang mga otaw kay yang kariko ng yamatago adon, amaklaro sang madatung na mga allaw. Aw yang kariko ng wa akatigami adon, akatigaman da. ");
INSERT INTO kqew_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yang pyagalaong ko na kamo gaid yang yakadungug, ipatigam da mayo adto sang kariko ng mga otaw. Aw yang pyagatomod-tomod ko kamayo, ipayapat da mayo adto sang kadaigan. ");
INSERT INTO kqew_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayaw kamo pagkalluk sidtong makapatay sang lawas mayo awgaid di makapatay sang nyawa mayo. Awgaid yang Tohan yang dait mayo kallukan kay yan yang amakasapad sang lawas aw nyawa mayo adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Na, dumduma mayo yang mga maya. Di ba dowambok yang amabili mayo ng 50 sintabos gaid? Awgaid abir pa maynan, way maskin sambok kanilan na amallog sang lopa aw amatay kong dili ng kahanda ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na, labi da kamo kay maskin yang logay mayo, kyatigaman ng Tohan daw pilambok da. ");
INSERT INTO kqew_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Agaw, ayaw kamo pagkalluk kay labaw pa yang bili mayo kaysang kadaig ng mga langgam. ");
INSERT INTO kqew_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sino-sino yang magalaong sa atobangan ng mga otaw na yagapangagad yan kanak, akunun ko oman yan na sakop ko sa atobangan ng kanak Ama adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Awgaid sino-sino yang magalaong sa atobangan ng mga otaw na wa yan apangagad kanak, di ko oman yan akunun na sakop ko sa atobangan ng kanak Ama adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayaw kamo pagdumdum na yakani ako untak magdaa ng kalinaw adi sang donya. Kay dili kalinaw yang dyaa ko kondi kasamok kay ako yang pyagasabapan ng panagtanam aw pagkabain-bain ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sabap kanak malaban yang anak na usug sang ama nan, yang anak na bobay sang ina nan, aw yang mamanogang na bobay sang ogangan nan na bobay. ");
INSERT INTO kqew_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Idto sagaw, yang ma-inang ng kalaban ng otaw yang sakop mismo sang baay nan. ");
INSERT INTO kqew_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sino-sino yang magpakadakowa sang ama atawa ina nan na labaw pa kanak, di dait tawagun na sakop ko. Aw sino-sino yang magpakadakowa sang anak nan na usug atawa bobay na labaw pa kanak, di oman dait tawagun na sakop ko. ");
INSERT INTO kqew_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kay sino-sino yang marim magpangagad kanak, dait andam yan mag-agi sang kasikotan aw maskin yang pagkamatay sabap kanak. Kong dili, di yan dait tawagun na sakop ko. ");
INSERT INTO kqew_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kay sino-sino na yang pyalabi nan yang kanan kinabowi, akawaan sinyan. Awgaid sino-sino na yang pyalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, aka-aonan ng bunna na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sino-sino yang magatarima kamayo, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang Tohan na yagasogo kanak adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kong aon syogo ng Tohan, sino-sino yang magatarima kanan kay syogo yan ng Tohan, atagan yan ng Tohan ng baras na mag-onawa ng i-atag nan sidtong syogo nan. Kong aon otaw na matorid, sino-sino yang magatarima kanan kay matorid yan na otaw, atagan yan ng Tohan ng baras na mag-onawa ng i-atag nan sidtong otaw na matorid. ");
INSERT INTO kqew_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aw sino-sino yang magapa-inum ng maskin tobig gaid sang pinakababa na inindowan ko kay yagapangagad yan kanak, sang bunna-bunna abarasan yan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos ni Isa mag-indo sang sampoo aw dowa na mga inindowan nan, pyomanaw yan ansan aw kyomadto yan sang makilibot na mga longsod untak mag-indo aw mag-osiyat. ");
INSERT INTO kqew_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Adon, si Yahiya na Magsosogboway na adto sa suud ng pirisowan, yadungug nan daw ono yang ininang ng Almasi. Agaw syogo nan yang mga inindowan nan adto kang Isa untak mag-osip kanan. ");
INSERT INTO kqew_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pagdatung nilan kang Isa, laong nilan, “Paglaonga kami daw ikaw agaw yang pyasad ng Tohan na madatung atawa aon pay tuna na atagadan nami?” ");
INSERT INTO kqew_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tyomobag si Isa, “Barik da kamo adto kang Yahiya aw paglaonga yan daw ono yang dyungug aw kinita mayo. ");
INSERT INTO kqew_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Paglaonga mayo yan na yang mga bota yakakita da, yang mga sadi yakapanaw da, aw yang mga sanglaun yamadyaw da. Yang mga bunguu yakadungug da, yang mga patay yabowi da oman aw yang Madyaw na Gogodanun yapayapat da adto sang mga miskinan. ");
INSERT INTO kqew_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kadyaw ng ginawa ng otaw na wa pagadowa-dowa kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagpanaw ng mga inindowan ni Yahiya, yagalaong si Isa adto sang kaotawan makapantag kang Yahiya, laong nan, “Pagkadto mayo sang kamingawan, ono yang kallini mayo kitaun? Sambok na otaw na yagaparin-parin yang dumduman na maynang tambiling na pyagaparid-parid ng samut? ");
INSERT INTO kqew_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na, ono kadi yang kyadtonan mayo? Sambok na otaw na tanto madyaw yang dagom? Dili kowaw, kay yang mga otaw na mayninyan yang dagom adto paga-uya sang palasyo ng soltan. ");
INSERT INTO kqew_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Unda, ono sagaw yang kyadtonan mayo? Sambok na nabi? Bunna sagaw na nabi si Yahiya, awgaid labaw pa yan sang kadaigan pa na mga nabi. ");
INSERT INTO kqew_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kay si Yahiya pyagalaong ng Kitab makapantag kanan nang laong ng Tohan, “ ‘Ipadaa ko yang sogowanun ko untak ma-ona yan kammo sang pagpangandam ng agianan mo.’ ");
INSERT INTO kqew_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sa bunna-bunna na ipaglaong ko kamayo na sang kariko ng mga yamangkaotaw adi sa babawan ng donya way makalabaw kang Yahiya na Magsosogboway. Awgaid adon, maskin yang pinakababa na otaw na magapasakop sang pagdato ng Tohan, labaw pa kanan. ");
INSERT INTO kqew_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sikun sang pag-osiyat ni Yahiya na Magsosogboway sampay adon makusug yang pagpayapat makapantag sang pagdato ng Tohan aw aon mga otaw na yamaningkamot pagpasakop sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kay yang kariko ng mga nabi aw yang Hokoman ni Nabi Mosa, pyagatagna yang pagdatung ng pagdato ng Tohan aw yagasogod da yang pagtoman ng pyagatagna nilan sang pagdatung ni Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kong mangintoo kamo sang pyaglaongan ng nabi na mabarik kono si Nabi Iliyas, akatigaman da mayo na si Yahiya kadi si Nabi Iliyas. ");
INSERT INTO kqew_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Adon, ono yang ikatandi ko sang mga otaw adon na panahon? Mag-onawa silan sang mga isu na yanag-ingkod adto sang plaza aw yanaglaro. Yagalaong da yang kadaigan adto sang mga kalaro nilan, ");
INSERT INTO kqew_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Pyagatogtogan kamo nami ng kolintang, awgaid wa kamo pagasayaw. Pyagakantaan kamo nami ng kanta ng paglubung, awgaid wa kamo pagatiyao.’ ");
INSERT INTO kqew_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na, yang mga otaw adon mag-onawa da kanilan. Kay pagdatung ni Yahiya, yabay yan magpowasa aw wa yan paga-inum ng bino. Agaw yagalaong silan na ‘Kyasaytanan kowaw yani na otaw!’ ");
INSERT INTO kqew_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aw pagdatung ko na Anak ng Manosiya, yakan aw yaminum ako. Agaw yagalaong silan, ‘Tanawa mayo, tokgawon aw paralasing yani na otaw! Inagad yan ng mga kobrador ng bowis aw yang kadaigan pa na mga baradosa.’ Awgaid maskin maynan,” laong ni Isa, “yang bonga ng gawbuk nami ni Yahiya, idto yang tanda na syogo kami ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ansinyan syaway ni Isa yang mga otaw sidtong mga banwa daw wain yan paga-inang ng madaig na mga katingaan kay wa silan pagatawbat sang mga dosa nilan. ");
INSERT INTO kqew_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yagalaong yan, “Labi na maat yang adatungan mayo na taga Korasin! Labi na maat oman yang adatungan mayo na taga Bitsayda! Kay kong ya-inang pa sang Tiros aw Sidon yang mga katingaan na ininang ko ansan kamayo, dogay da silan yanagsoog ng sako aw yanag-ingkod sang abo silbi tanda ng pagtawbat nilan. ");
INSERT INTO kqew_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Agaw, ipaglaong ko kamayo na sang allaw ng paghokom, labaw pa yang siksa kamayo kaysang mga taga Tiros aw Sidon. ");
INSERT INTO kqew_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na, kamo oman na taga Kapirnaom. Yagadumdum ba kamo na apataasun kamo adto sa sorga? Dili! Kay ioog kamo ng Tohan adto sang narka. Kay kong ya-inang pa sang Sodom yang mga katingaan na ininang ko ansan kamayo, sa way dowa-dowa iyan pa adon idtong longsod. ");
INSERT INTO kqew_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na, ipaglaong ko kamayo na sang allaw ng paghokom, labaw pa yang siksa kamayo kaysang mga taga Sodom.” ");
INSERT INTO kqew_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagkatapos sinyan yagadowaa si Isa aw laong nan, “O kay Ama, ikaw da yang yagadato adto sa sorga aw adi sang donya. Yanginsokor ako kammo kay yang pyagatago mo sang mga aon katigam aw mataas yang pagpangadi pyatigam mo adto sang mga way katigam. ");
INSERT INTO kqew_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ininang mo yani, kay Ama, kay idto yang karim mo.” ");
INSERT INTO kqew_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ansinyan yagalaong si Isa sang mga otaw, “Yang kariko ng mga butang yatag kanak ng kanak Ama. Way akilaa kanak yatabiya yang kanak Ama. Aw way oman akilaa sang kanak Ama yatabiya ako na Anak nan kipat sidtong mga otaw na pinili ko na makakilaa kanan. ");
INSERT INTO kqew_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Pagdood kamo kanak, yang kariko mayo na kyapoyan aw kyabugatan kay untak makapagpatana kamo. ");
INSERT INTO kqew_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tarimaa mayo yang mga sogowan ko aw pangagadi mayo yang indowan ko. Ansinyan aka-aonan kamo ng kalinaw sa suud ng pangatayan mayo kay ako maoyanun aw masabar. ");
INSERT INTO kqew_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kay yang indowan ko masayun pangagadan aw dili ng mairap yang ipa-inang ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sangallaw sinyan na Allaw ng Pagpatana, yamagi si Isa aw yang mga inindowan nan sang pawa ng trigo. Pag-agi nilan yangutu yang mga inindowan nan ng trigo aw kyubkub nilan kay yamagutum silan. ");
INSERT INTO kqew_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkita sinyan ng mga Parisi, yagalaong silan kang Isa, “Tanawa yang mga inindowan mo! Sopak sang Hokoman yang ininang nilan kay yagagawbuk silan sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tyomobag kanilan si Isa, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sang wakto na yamagutum yan kipat yang mga kaupudanan nan? ");
INSERT INTO kqew_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Syomuud yan sang Baay ng Tohan aw kyan nan yang pan na pyasampay adto sang Tohan aw atagi oman yang mga kaupudanan nan. Na, sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan. ");
INSERT INTO kqew_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wa oman mayo akabasa sang Kitab Tawrat na yang mga imam na yagagawbuk adto sa suud ng Baay ng Tohan yamakasopak sang Hokoman kay yagagawbuk silan sang Allaw ng Pagpatana? Awgaid maskin maynan, wa silan pakadosa. ");
INSERT INTO kqew_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na, ipaglaong ko kamayo na idi adon yang labaw pa sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aon oman yakasorat sang Kitab na yagalaong yang Tohan, ‘Way karim ko sang mga ayup na ipakorban mayo kanak, kondi yani yang karim ko na maooy kamo sang kapag-onawa mayo.’ Na, kong yakasabot kamo sang mana nan, wa gao kamo pagalaong na yakadosa yaning mga otaw na way dosa. ");
INSERT INTO kqew_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kay ako na Anak ng Manosiya, aon kapatot ko paglaong daw ono yang mapakay inangun sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ansinyan pyomanaw si Isa ansan aw kyomadto yan sang pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Adto sa suud aon sambok na otaw na yamasadi yang sangkilid na arima nan. Aon oman mga otaw ansan na karim nilan na aon ikasombong nilan kang Isa. Agaw yaga-osip silan kanan, “Sobay ba sang Hokoman yang pagpakadyaw ng mga masakitun sang Allaw ng Pagpatana?” ");
INSERT INTO kqew_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tyomobag si Isa, “Sawpama aon karniro mayo na yamallog sang longag sang Allaw ng Pagpatana. Ono yang inangun mayo? Di ba akadtonan mayo aw atabangan mayo? ");
INSERT INTO kqew_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na, labaw pa yang bili ng otaw kaysang karniro! Agaw di kita masopak sang Hokoman kong matabang kita sang kapag-onawa ta sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ansinyan yagalaong si Isa sidtong otaw na yamasadi yang sangkilid na arima nan, “Onata yang kammo arima.” Na, yonat da nan aw yamadyaw dayon yang arima nan na mag-onawa ng sangkilid na arima nan. ");
INSERT INTO kqew_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ansinyan lyomogwa da yang mga Parisi sikun sang pagsasambayangan aw yanagbaaw-baaw silan daw monono nilan patayun si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Adon, sabap ng kyatigaman ni Isa idtong pyagabaawan nilan, pyomanaw yan sikun sinyan na banwa. Madaig yang mga otaw na yamagad kanan aw pyakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Awgaid syagda nan yang mga otaw na di silan maggogod adto sang kadaigan ng makapantag kanan. ");
INSERT INTO kqew_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Maynini yang ininang nan kay untak matoman yang pyaglaongan ng Tohan pina-agi kang Nabi Isayas na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Idi kay yang kanak sogowanun na pinili ko. Dakowa yan sang pangatayan ko aw yamasowat ako kanan. Ipadatung ko kanan yang Nyawa ko aw magapayapat yan adto sang kariko ng mga bangsa na matorid yang paghokom ko. ");
INSERT INTO kqew_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Di yan mapaglalis, di yan magpiyagit, aw di oman amadungug yang tingug nan adto sang mga daan. ");
INSERT INTO kqew_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Apabagsugun nan yang pangatayan ng mga otaw na tagbi gaid yang pagpangintoo, aw atabangan nan yang mga otaw na kyawaan ng pagsarig. Aw padayonon nan yang gawbuk nan taman sang amatoman da yang matorid na katoyowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aw yang mga otaw sang kariko ng mga bangsa masarig kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ansinyan aon dyaa adto kang Isa na sambok na otaw na kyasaytanan na bota aw amang. Pyakadyaw yan ni Isa, aw ansinyan yakakita aw yakapaglaong da oman yan. ");
INSERT INTO kqew_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na, yang kariko ng mga otaw na yakakita sinyan yangkatingaa aw laong nilan, “Basin yan agaw yang Almasi, yang Anak ni Daud?” ");
INSERT INTO kqew_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagdungug sinyan ng mga Parisi, yagalaong silan, “Astaga! Makapalogwa gaid yan ng mga saytan kay yatagan yan ng kabarakat ni Bilsibol na pangoo ng mga saytan.” ");
INSERT INTO kqew_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Awgaid kyatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Kong yang mga otaw sang sambok na pyagdatowan manag-onay magtanam, sang di amadogay amasapad inyan na pyagdatowan. Aw kong magakabain-bain yang mga otaw sang sambok na longsod atawa baay, sang orian magabuag da silan. ");
INSERT INTO kqew_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mag-onawa sinyan, kong magabogaw si Iblis sang mga sakop nan na saytan, magakabain-bain da yang pyagdatowan nan aw sang di amadogay amasapad da yan. ");
INSERT INTO kqew_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na, kong bunna yang pyagalaong mayo na yagapalogwa ako sang mga saytan kay si Bilsibol yang yaga-atag kanak ng kabarakat, sino kadi yang yaga-atag ng kabarakat adto sang mga inindowan mayo pagpalogwa ng mga saytan? Na, silan da yang magalaong na yamasayup kamo. ");
INSERT INTO kqew_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Awgaid sang bunna-bunna yagapalogwa ako ng mga saytan sabap sang kabarakat ng Nyawa ng Tohan. Aw yani yang tanda na dyomatung da adi kamayo yang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ansinyan yaga-atag oman kanilan si Isa ng opamaan, laong nan, “Way otaw na makasuud sang baay ng makusug na otaw aw makakamang sang mga butang nan kong di nan ona gaposon idtong makusug na otaw. Awgaid kong yamagapos da nan, makakamang da yan sang mga butang sidto na baay. ");
INSERT INTO kqew_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sino-sino yang di madapig kanak, mapaglaban kanak. Aw sino-sino yang di matabang kanak pagtipon, magapakanat-kanat. ");
INSERT INTO kqew_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Agaw ipaglaong ko kamayo na yang kariko ng dosa ma-ampon aw maskin pa yang paglaong ng maat makapantag sang Tohan. Awgaid yang paglaong ng maat makapantag sang Nyawa ng Tohan, di ma-ampon. ");
INSERT INTO kqew_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sino-sino yang magalaong ng maat makapantag kanak na Anak ng Manosiya, ma-ampon. Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di ma-ampon taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kong madyaw yang kaoy, madyaw yang bonga nan. Awgaid kong dili ng madyaw yang kaoy, dili ng madyaw yang bonga nan. Agaw, akatigaman yang kaoy sabap sang bonga nan. ");
INSERT INTO kqew_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mga limbongon kamo! Monono kamo makapaglaong ng madyaw sarta maat yang pangatayan mayo? Kay yang maskin ono na adto sa suud ng pangatayan ng otaw, idto oman yang ipaglaong nan. ");
INSERT INTO kqew_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yang madyaw na otaw, madyaw yang pyaglaongan nan kay madyaw yang lasak ng pangatayan nan. Awgaid yang maat na otaw, maat yang pyaglaongan nan kay maat yang lasak ng pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na, ipaglaong ko kamayo na sang allaw ng paghokom amanobag yang mga otaw adto sang Tohan makapantag sang kariko ng mga pyaglaongan nilan na way siyat. ");
INSERT INTO kqew_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay sobay sang mga pyaglaongan mayo yang paghokom kamayo ng Tohan, daw atarimaun atawa asiksaun kamo.” ");
INSERT INTO kqew_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pagkatapos sinyan dyomood kang Isa yang mga magiindoway ng Hokoman aw yang mga Parisi aw yagalaong silan kanan, “Kay Goro, karim nami makakita ng katingaan mo silbi tanda na syogo kaw ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Awgaid tyomobag si Isa, laong nan, “Maat yang mga otaw adon na panahon aw yagapakawat silan sang Tohan. Yamangayo silan ng katingaan, awgaid way ipakita ko kanilan yatabiya sidtong katingaan na ya-inang adto kang Nabi Yonos. ");
INSERT INTO kqew_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Toong allaw aw toong gabi adto yan sa suud ng dubdub ng dakowa na isda. Mag-onawa sinyan ako na Anak ng Manosiya, magapabilin ako sa suud ng kobor sa suud ng toong allaw aw toong gabi. ");
INSERT INTO kqew_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na, sang allaw ng paghokom magabangon yang mga taga Ninibe upud kamayo na mga otaw adon na panahon aw magalaong silan na dait kamo siksaun kay wa kamo pagatawbat. Awgaid silan, yagatawbat silan sang mga dosa nilan pagdungug nilan sang pag-osiyat ni Nabi Yonos. Na, pagalaongon ta kamo na idi adon yang labaw pa kang Nabi Yonos. ");
INSERT INTO kqew_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sang allaw ng paghokom magabangon oman yang soltana sang bangsa ng Siba upud kamayo na mga otaw adon na panahon aw magalaong yan na dait kamo siksaun. Kay maskin mawat yang banwa nan kyomadto yan untak magpaningug sang pyaglaongan ni Soltan Solayman kay maum yang katigam nan. Na, pagalaongon ta kamo na idi adon yang labaw pa kang Soltan Solayman. ");
INSERT INTO kqew_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kong lomogwa yang sambok na saytan sikun sang otaw na yasuudan nan, magapanaw-panaw da yan sang mga banwa na way tobig untak manganap ng akapagpatanaan nan. Aw way kinita nan, ");
INSERT INTO kqew_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","magalaong yan sang ginawa nan, ‘Mabarik da gaid ako sang dadaan na pyaga-uyaan ko.’ Na, pagbarik nan makita nan na waa day yaga-uya aw kyalinisan da idtong pyaga-uyaan. ");
INSERT INTO kqew_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ansinyan mapanaw da oman yan kay magadaa yan ng pito pa na mga saytan na labi pa na maat kay kanan aw masuud silan sidtong otaw aw apag-uyaan nilan. Na, sang orian mas maat pa yang kabutang sidtong otaw kaysang pirmiro. Mag-onawa sinyan yang amaitabo sang mga otaw adon na panahon kay bali na kaat nilan.” ");
INSERT INTO kqew_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sarta yaga-indo pa si Isa sang mga otaw, dyomatung yang ina nan aw yang mga mangkangod nan na usug. Yagatagad silan sa logwa kay karim nilan mapagbaaw kanan. ");
INSERT INTO kqew_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ansinyan aon sambok na otaw na yagalaong kang Isa, “Yang ina mo aw yang mga lomon mo adto sa logwa. Karim nilan mapagbaaw kammo.” ");
INSERT INTO kqew_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Awgaid tyomobag si Isa sidtong otaw aw laong nan, “Sino kadi yang ina ko aw mga lomon ko?” ");
INSERT INTO kqew_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ansinyan tyolli nan yang mga inindowan nan aw laong nan, “Tanawa, silan yang ina ko aw mga lomon ko. ");
INSERT INTO kqew_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kay sino-sino yang yaga-inang ng karim ng Tohan na kanak Ama adto sa sorga, silan yang ina ko aw yang mga lomon ko na usug aw bobay.” ");
INSERT INTO kqew_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sinyan na allaw pyanawan da ni Isa yang baay aw kyomadto yan sang kilid ng linaw aw yamingkod ansan. ");
INSERT INTO kqew_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ansinyan madaig yang mga otaw na yanagkatipon adto kanan. Agaw, yang ininang ni Isa, syomakay yan sang sambok na bangka aw yamingkod ansan sarta yang mga otaw adto manag-indug sang kilid ng linaw. ");
INSERT INTO kqew_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na, madaig yang pyaga-indo ni Isa kanilan pina-agi sang mga pasombingay. Laong nan, “Aon otaw na kyomadto sang pawa untak magsabod ng bini. ");
INSERT INTO kqew_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sang pagsabod nan, aon mga bini na yamallog adto sang kilid ng daan. Ansinyan dyomatung yang mga langgam aw toboga nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aon oman mga bini na yamallog adto sang batoon na lopa. Na, tyomobo dayon yang mga bini kay mababaw yang lopa. ");
INSERT INTO kqew_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Awgaid pagsilat ng suga, yalanus dayon yang mga tanum sabap sang kapaso ng suga aw yagango da kay wa silan pakagamot ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aon oman mga bini na yamallog adto sang lopa na madaig yang sampinit. Ansinyan tyomorin yang sampinit aw kyatabonan sinyan yang mga tanum. ");
INSERT INTO kqew_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Awgaid aon oman mga bini na yamallog adto sang madyaw na lopa. Tyomorin silan aw yabonga ng madyaw. Yang kadaigan yabonga ng labi na madaig, yang kadaigan oman yabonga ng madaig, aw yang kadaigan oman yabonga ng osto gaid.” ");
INSERT INTO kqew_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na, laong oman ni Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ansinyan dyomood kang Isa yang mga inindowan nan aw yaga-osip silan, laong nilan “Nanga mga pasombingay gaid yang gyamit mo pag-indo sang mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tyomobag si Isa, “Kamo, yatagan kamo ng katigam untak makasabot kamo sang mga tinago makapantag sang pagdato ng Tohan. Awgaid yang kadaigan, wa silan atagi ninyan. ");
INSERT INTO kqew_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kay sino-sino yang amaningug ng madyaw, adogangan pa yang katigam nan untak labi da yang katigam nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyatigaman nan, akamangun pa kanan. ");
INSERT INTO kqew_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Agaw sagaw mga pasombingay yang gyamit ko sang pag-indo kanilan kay maskin yagatanaw silan, di silan makakita, aw maskin yamaningug silan, di silan makasabot. ");
INSERT INTO kqew_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idto sagaw yatoman adto kanilan yang pyaglaongan ng Tohan pina-agi kang Nabi Isayas na laong nan, “ ‘Maskin yamaningug kamo, di kamo makasabot. Aw maskin yagatanaw kamo, di kamo makakita. ");
INSERT INTO kqew_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay yani na mga otaw, mabagsug yang oo nilan. Tyabonan nilan yang taringa nilan untak di silan makadungug aw ipilung nilan yang mata nilan untak di silan makakita. Kay kong dili ng maynan yang inangun nilan, makakita aw makadungug da gao silan. Makasabot da gao silan aw mabarik da gao silan adi kanak untak pakadyawon ko silan.’ ");
INSERT INTO kqew_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Awgaid kamo,” laong ni Isa, “kadyaw ng ginawa mayo kay yakasabot kamo sang dyungug mayo. ");
INSERT INTO kqew_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa bunna-bunna na ipaglaong ko kamayo na madaig yang mga nabi singaon aw yang kadaigan pa na mga otaw na matorid sang pagtanaw ng Tohan na karim gao nilan komita sang kinita mayo, awgaid wa silan pakakita. Karim gao nilan dumungug sang dyungug mayo, awgaid wa silan pakadungug. ");
INSERT INTO kqew_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Agaw pagpaningug kamo untak kamo makasabot sang mana ng pasombingay makapantag sang otaw na yagasabod ng bini. ");
INSERT INTO kqew_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yang mga otaw na yakadungug sang pyaglaongan makapantag sang pagdato ng Tohan awgaid wa pakasabot sinyan mag-onawa sidtong kilid ng daan na kyaoogan ng bini. Ansinyan dyomatung si Iblis aw kyamang nan yang pyaglaongan na dyungug nilan sikun sang pangatayan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yang batoon na lopa, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan aw tyarima dayon nilan na aon kasowat. ");
INSERT INTO kqew_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Awgaid sabap ng wa pakagamot yang pyaglaongan sang pangatayan nilan, di silan magadogay sang pagpangintoo nilan. Kay kong adatungan silan ng mga sasat atawa apasikotan silan sabap sang pagpangagad nilan sang pyaglaongan ng Tohan, mabiya dayon silan sang pagpangintoo. ");
INSERT INTO kqew_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yang lopa oman na madaig yang sampinit, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan, awgaid sabap sang karidowan nilan adi sa babawan ng donya aw sabap oman sang kallini nilan sang kakawasaan, kyatabonan da yang pyaglaongan ng Tohan. Idto sagaw way yakita na bonga ng pagpangintoo sang kinabowi nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Awgaid yang madyaw na lopa, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan aw yakasabot sinyan. Agaw sagaw aon makita na bonga ng pagpangintoo sang kinabowi nilan. Yang kadaigan yabonga ng labi na madaig, yang kadaigan oman yabonga ng madaig, aw yang kadaigan oman yabonga ng osto gaid.” ");
INSERT INTO kqew_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Adon yagalaong oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan mag-onawa ng otaw na yagasabod ng madyaw na bini adto sang kanan pawa. ");
INSERT INTO kqew_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sanggabi sinyan sarta yatoog yang kariko ng mga otaw, dyomatung yang kalaban nan aw yagasabod ng mga liso ng sagbut adto sang pyagatanuman ng madyaw na bini. Pagkatapos, pyomanaw. ");
INSERT INTO kqew_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nang tyomorin da yang mga tanum aw yangiswak da, ansan pa akitaa na aon oman mga sagbut kadi. ");
INSERT INTO kqew_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ansinyan kyomadto sang tagtomon ng pawa yang mga sogowanun nan aw laong nilan, ‘Kay Dato, madyaw saba yang bini na pyasabod mo sang kammo pawa. Wain kadi pagasikun yang mga sagbut?’ ");
INSERT INTO kqew_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Tyomobag yang tagtomon ng pawa, ‘Yang kanak kalaban yang yaga-inang sinyan.’ “Yaga-osip silan, ‘Karim mo na agaboton nami yang mga sagbut?’ ");
INSERT INTO kqew_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Ayaw da,’ tyomobag yan, ‘kay kong agaboton mayo, amagabot oman yang mga tanum. ");
INSERT INTO kqew_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayai da gaid mayo yang mga sagbut na magadungan tomobo sang mga tanum taman sang tinggani. Kay pagdatung ng tinggani, asogoon ko yang mga maggagani na agaboton mona nilan yang mga sagbut aw bogkoson nilan untak sonogon. Aw ansinyan ipatipon ko kanilan yang mga tanum untak ibutang adto sang kanak kamarig.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ansinyan yagalaong da oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan mag-onawa ng liso ng mostasa na tyanum ng otaw adto sang kanan pawa. ");
INSERT INTO kqew_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yani na liso yang labi na tagbi sang kariko ng mga liso. Awgaid pagkatorin sinyan, makagwas pa yan sang kariko ng mga tanum aw ma-inang yan ng kaoy. Aw maskin yang mga langgam makapogad sang mga sanga sinyan.” ");
INSERT INTO kqew_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yagalaong da oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan mag-onawa ng labadora na pyagadari ng bobay sang sangka sako na arina aw ininang nan ng masa. Aw ansinyan tyomobo yang tibok masa.” ");
INSERT INTO kqew_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mga pasombingay gaid yang gyamit ni Isa sang pag-indo sang mga otaw. Way pyaga-indo nan kanilan na dili pina-agi sang pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Maynini yang ininang nan untak matoman yang pyaglaongan ng Tohan pina-agi sang sambok na nabi na laong nan, “Mga pasombingay yang agamitun ko sang pagbaaw ko kanilan. Pagalaongon ko silan sang mga butang na wa pa akatigami sikun pa sang pagbaoy ng donya.” ");
INSERT INTO kqew_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos sinyan biniyaan ni Isa yang mga otaw aw syomuud yan sang baay. Ansinyan dyomood kanan yang mga inindowan nan aw yagalaong silan, “Paglaonga kami daw ono yang mana ng pasombingay makapantag sang mga sagbut adto sang pawa.” ");
INSERT INTO kqew_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tyomobag si Isa aw laong nan, “Yang otaw na yagasabod ng madyaw na bini way lain kondi ako na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yang pawa, yan yang donya aw yang madyaw na bini, yan yang mga otaw na yagapasakop sang pagdato ng Tohan. Aw yang mga sagbut, yan yang mga otaw na yagapasakop kang Iblis. ");
INSERT INTO kqew_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yang otaw na yagasabod ng mga liso ng sagbut, yan si Iblis. Yang wakto ng paggani, yan yang kataposan ng donya aw yang mga maggagani, silan yang mga malaikat. ");
INSERT INTO kqew_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na, mag-onawa ng mga sagbut na agaboton untak silan sonogon, maynan oman yang amaitabo sang Allaw na Maori. ");
INSERT INTO kqew_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kay ako na Anak ng Manosiya, asogoon ko yang kanak mga malaikat untak lainun nilan sikun sang mga otaw na yagapasakop sang pagdato ko yang kariko ng mga otaw na yaga-inang ng maat aw pyagasabapan ng pagpakadosa ng kadaigan aw atiponon nilan silan. ");
INSERT INTO kqew_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aw ansinyan idami silan sang atoon adto sang narka. Adto da silan magtiyao aw mangolitub yang onto nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Awgaid yang mga otaw na tyarima ng Tohan na matorid, magasiga da silan na maynang sigay ng suga adto sang pyagdatowan ng Tohan na Ama nilan. Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yagalaong oman si Isa, “Yang pagdato ng Tohan mag-onawa ng bowawan na lyubung sang lopa. Pagkita sinyan ng otaw, lyubung oman nan aw panaw. Sabap sang bali na kasowat nan byarigya nan yang kariko ng mga butang nan aw binili nan yang inyan na lopa.” ");
INSERT INTO kqew_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laong oman ni Isa, “Yang pagdato ng Tohan mag-onawa oman sang negosyante na yaga-anap ng madyaw na mga perlas. ");
INSERT INTO kqew_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkita nan sang perlas na labi na madyaw, byarigya nan yang kariko ng mga butang nan aw binili nan yan na perlas.” ");
INSERT INTO kqew_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Laong oman ni Isa, “Yang pagdato ng Tohan mag-onawa oman sang pokot na tyaktak sang dagat untak makamang yang klasi-klasi na isda. ");
INSERT INTO kqew_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kong pono da yang pokot, agoyodon inyan adto sang baybay. Ansinyan maga-ingkod da yang mga mangingisdaay untak mamili ng isda. Yang madyaw na isda ilasak nilan sang aniga, awgaid yang maat idami nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na, maynan oman yang akatamanan sang Allaw na Maori. Kay makani yang mga malaikat aw alainun nilan yang maat na mga otaw sikun sang mga otaw na matorid sang pagtanaw ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aw yang maat na mga otaw idami nilan sang atoon adto sang narka. Adto da silan magtiyao aw mangolitub yang onto nilan. ");
INSERT INTO kqew_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Na, yakasabot ba kamo sang kariko nini na pyagalaong ko kamayo?” yosip ni Isa yang mga inindowan nan. Tyomobag silan, “Uu.” ");
INSERT INTO kqew_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ansinyan yagalaong yan kanilan, “Kong maynan, makasabot oman kamo na kong aon magiindoway ng Hokoman na amangagad sang indowan ko makapantag sang pagdato ng Tohan, mag-onawa yan sang tagtomon ng baay na aon kakawasaan na bago aw dadaan adto sang kanan bodega kay matigam yan mag-indo ng dadaan aw bago na indowan.” ");
INSERT INTO kqew_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapos ni Isa maggogod sidtong mga pasombingay, pyanawan da nan inyan na banwa. ");
INSERT INTO kqew_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yamori yan adto sa Nasarit, yang longsod na tyorinan nan aw yaga-indo yan adto sang pagsasambayangan ng mga Yahodi. Ansinyan yatingaa yang mga otaw na yakadungug kanan aw yagalaong silan, “Wain yani na otaw pakakamang sini na katigam? Aw wain yan sang kabarakat pag-inang sini na mga katingaan? ");
INSERT INTO kqew_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Di ba anak yan ng panday, aw si Mariyam yang kanan ina? Aw yang mga lomon nan si Yakob, si Yosop, si Simon aw si Yodas? ");
INSERT INTO kqew_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Di ba, adi oman paga-uya yang mga lomon nan na bobay? Awgaid wain yan pakakamang sini na katigam aw kabarakat?” ");
INSERT INTO kqew_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ansinyan wa nilan atarimaa si Isa. Agaw yagalaong kanilan si Isa, “Yang nabi pyaga-addatan ng mga otaw maskin wain yatabiya adto sang kanan banwa aw sang kanan baay.” ");
INSERT INTO kqew_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Idto sagaw wa yan paka-inang ng madaig na katingaan sidto na banwa kay wa silan apangintoo kanan. ");
INSERT INTO kqew_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sidto na wakto yakadungug si Hirod na soltan sa Jalil ng makapantag sang ininang ni Isa ");
INSERT INTO kqew_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aw yagalaong yan sang mga opisyales nan, “Yan kay si Yahiya na Magsosogboway na yabowi oman! Idto sagaw aon kabarakat nan pag-inang ng katingaan.” ");
INSERT INTO kqew_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maynini yang pyaglaongan ni Hirod kay singaon pyadakup nan si Yahiya, pyagapos aw pyapiriso nan. Kay si Hirod, pyangasawa nan si Hirodiya na asawa ng lomon nan na si Pilip. ");
INSERT INTO kqew_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aw yabay yan paglaongon ni Yahiya, laong nan, “Di mapakay na pangasawaun mo yang asawa ng lomon mo. Sopak yan sang Hokoman.” ");
INSERT INTO kqew_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na, sabap sinyan apatayun gao ni Hirod si Yahiya, awgaid yamalluk yan sang mga otaw kay yagapangintoo silan na si Yahiya sambok na nabi. ");
INSERT INTO kqew_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, pagdatung ng allaw ng pagkaotaw ni Hirod, yagapakandori yan. Ansinyan yagasayaw yang anak ni Hirodiya sa atobangan ng mga otaw na yagatambong sang kandori, aw bali na kasowat ni Hirod. ");
INSERT INTO kqew_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Agaw yagalaong yan sidtong daaga, “Magapasad ako na i-atag ko kammo yang maskin ono na apangayoon mo.” ");
INSERT INTO kqew_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Adon, sabap ng pyagalaong yan ng kanan ina daw ono yang apangayoon nan, yagalaong yan sang soltan, “Atagan kanak adon yang oo ni Yahiya na Magsosogboway na yakabutang sang bandiya.” ");
INSERT INTO kqew_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ansinyan yamarido da yang soltan. Awgaid sabap ng yagapasad yan sa atobangan ng mga bisita nan, yagasogo yan na i-atag kanan yang pyangayo nan. ");
INSERT INTO kqew_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Agaw pya-otodan da nan si Yahiya ng kanan oo adto sang pirisowan. ");
INSERT INTO kqew_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ansinyan byutang nilan yang oo nan sang bandiya aw atagan sang anak ni Hirodiya, aw daa nan adto sang kanan ina. ");
INSERT INTO kqew_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na, pagdungug sinyan ng mga inindowan ni Yahiya, kyadtonan nilan yang lawas nan aw lubungan nilan. Pagkatapos, kyomadto silan kang Isa aw paglaongan kanan yang kyatamanan ni Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagdungug ni Isa na patay da si Yahiya, syomakay yan sang bangka aw kadto sang mamingaw na banwa. Awgaid pagkatigam ng mga otaw na pyomanaw da si Isa, pyanawan nilan yang banwa nilan aw yagapanaw silan sang kilid ng linaw untak lopogon nilan. ");
INSERT INTO kqew_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ansinyan pagpanaog ni Isa sang bangka, kinita nan yang kadaig ng mga otaw na yalopog kanan. Yamaooy yan kanilan aw pyakadyaw nan yang mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagkasilum sinyan dyomood kanan yang mga inindowan nan aw laong nilan, “Masaid da somallup yang suga aw mamingaw yani na banwa. Madyaw pa aw pakadtonon mo yang mga otaw adto sang mga baryo untak silan makabili ng pagkan.” ");
INSERT INTO kqew_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Awgaid tyomobag si Isa, “Di kinaanglan na apapanawon ko silan. Kamo da yang magpakan kanilan.” ");
INSERT INTO kqew_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yagalaong silan, “Aon gaid adi kanami limambok na pan aw dowambok na isda.” ");
INSERT INTO kqew_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yagalaong si Isa, “Daa mayo adi.” ");
INSERT INTO kqew_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ansinyan pya-ingkod nan yang mga otaw sang kasagbutan. Kyamang nan yang limambok na pan aw dowambok na isda aw ya-angad sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga inindowan nan untak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqew_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na, yang kadaig ng mga otaw na yakakan, 5000 yang kausugan na way labot yang kaobayan aw yang mga isu. ");
INSERT INTO kqew_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkatapos sinyan pyasakay ni Isa yang mga inindowan nan sang bangka. Syogo nan silan na ama-ona kanan adto sang dipag sarta apapanawon nan yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagpanaw da ng mga otaw, syomakat si Isa sang butay ng sangka otaw da nan untak magdowaa. Aw gyabian yan adto sidtong butay. ");
INSERT INTO kqew_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Awgaid yang bangka na syakayan ng mga inindowan nan adto da sang laod na kyoso-koso ng baud kay yasongsong silan sang makusug na samut. ");
INSERT INTO kqew_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pagkadlawon kyadtonan silan ni Isa na yagapanaw sa babaw ng tobig. ");
INSERT INTO kqew_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkita ng mga inindowan na yagapanaw yan sa babaw ng tobig, bali na kalluk nilan. Yagapiyagit silan, “Aon molto!” ");
INSERT INTO kqew_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Awgaid yagalaong dayon si Isa, “Ayaw kamo pagkalluk. Ako saba yani. Pabagsuga mayo yang pangatayan mayo.” ");
INSERT INTO kqew_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ansinyan yagalaong si Pitros, “Kay Dato, kong ikaw yan, pakadtona ako adto kammo sa babaw ng tobig.” ");
INSERT INTO kqew_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yagalaong si Isa, “Unda, adi kaw.” Agaw, yanaog da si Pitros sang bangka aw yagapanaw yan sa babaw ng tobig paduug kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Awgaid pagbati nan ng makusug na samut, yamalluk yan aw yagasogod da yan malonod. Agaw yagapiyagit yan aw laong nan, “Kay Dato, lowasa ako!” ");
INSERT INTO kqew_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na, tyakmagan dayon yan ni Isa aw yagalaong yan kanan, “Katagbi ng pagsarig mo kanak! Nanga yagadowa-dowa kaw?” ");
INSERT INTO kqew_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na, pagsakay da nilan dowa sang bangka, yamondang dayon yang samut. ");
INSERT INTO kqew_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aw yang kariko ng mga inindowan sang bangka syomojod sa atobangan ni Isa aw laong nilan, “Sa bunna-bunna, ikaw yang Anak ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagtaripag da oman nilan sang linaw, yadonggo silan sang banwa ng Ginisarit. ");
INSERT INTO kqew_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yakilaa si Isa ng mga otaw ansan, agaw pyatigam dayon nilan adto sang makilibot na mga banwa na iyan da si Isa. Ansinyan dyaa da ng mga otaw yang kariko ng mga masakitun adto kanan. ");
INSERT INTO kqew_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yagapangayo-ngayo silan kang Isa na kong mapakay takmagan ng mga masakitun maskin yang sagayadan da gaid ng kanan dagom. Aw yang kariko na yakatakmag ng dagom nan yamadyaw. ");
INSERT INTO kqew_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ansinyan aon mga Parisi aw mga magiindoway ng Hokoman sikun sa Awrosalam na dyomood kang Isa aw yaga-osip silan kanan, laong nilan, ");
INSERT INTO kqew_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nanga yasopak yang mga inindowan mo sang kabatasanan ng mga kaompowan ta? Kay yakan silan maskin wa silan pakapangonaw.” ");
INSERT INTO kqew_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tyomobag kanilan si Isa, “Kamo oman, nanga syopak mayo yang sogowan ng Tohan sabap sang pagpangagad mayo sang kabatasanan mayo? ");
INSERT INTO kqew_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kay yagalaong yang Tohan, ‘Addati mayo yang ama aw ina mayo.’ Aw ‘Sino-sino yang magalaong ng maat adto sang ama atawa ina nan, dait yan patayun.’ ");
INSERT INTO kqew_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Awgaid tuna yang pyaga-indo mayo kay yagalaong kamo na kong magalaong yang otaw adto sang ama atawa ina nan na ‘Yang tabang na i-atag ko gao kammo, di da ko ma-atag kay yatag da ko sang Tohan,’ ");
INSERT INTO kqew_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na, mapakay na di da nan atabangan yang taganak nan. Agaw, sabap sang pagpangagad mayo sang kabatasanan mayo, tyaripundaan mayo yang sogowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kamo na yagapakita-kita gaid na yagapangagad sang Tohan! Bunna sagaw yang pyaglaongan ng Tohan makapantag kamayo pina-agi kang Nabi Isayas na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Yani na mga otaw yagapoji kanak sang baba gaid nilan, awgaid mawat kanak yang pangatayan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Way siyat yang pag-ibada nilan kanak kay yang pyaga-indo nilan mga sogowan na ininang gaid ng otaw, awgaid yagalaong silan na sogowan inyan ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ansinyan pyadood ni Isa yang mga otaw adto kanan aw pyagalaong nan silan, laong nan, “Paningug kamo aw sabota mayo yang ipaglaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yang makabatar sang otaw dili ng pagkan na ilasak nan sang baba nan kondi yang maat na pyaglaongan na malogwa sikun sang baba nan.” ");
INSERT INTO kqew_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ansinyan dyomood kanan yang mga inindowan nan aw yagalaong silan, “Yamatigam kaw na yadaman kammo yang mga Parisi sabap sidto na pyaglaongan mo?” ");
INSERT INTO kqew_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tyomobag si Isa, “Yang kariko ng mga tanum na wa atanuma ng kanak Ama na adto sa sorga, agaboton. ");
INSERT INTO kqew_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayai da silan kay main silan ng bota na yagagabay sang kadaigan pa na mga bota. Na, kong yang bota magagabay sang sambok oman na bota, dowa da silan na amallog sang longag.” ");
INSERT INTO kqew_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ansinyan yagalaong si Pitros kang Isa, “Tabiya, paglaongan kanami yang mana nidtong pyagalaong mo.” ");
INSERT INTO kqew_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yagalaong si Isa, “Na, maskin oman kamo, wa pa kadi kamo pakasabot? ");
INSERT INTO kqew_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wa kadi kamo akatigam na yang maskin ono na akanun ng otaw adto amalasak sang tongoo aw malogwa da oman sikun sang lawas nan? ");
INSERT INTO kqew_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Awgaid yang malogwa sikun sang baba ng otaw magasikun sang pangatayan, aw idto yang amakabatar kanan. ");
INSERT INTO kqew_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay sikun adto suud ng pangatayan ng otaw yang maat na dumduman na mag-onawa ng pagpatay, yang pagjina, yang pag-inang ng kadopangan, pagpangawat, pamakak aw yang pagpitna. ");
INSERT INTO kqew_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Idto yang amakabatar sang otaw. Awgaid yang makan na wa pakapangonaw, di yan amakabatar kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ansinyan pyanawan ni Isa yan na banwa aw kyomadto yan sang logar na masaid sang mga syodad ng Tiros aw Sidon. ");
INSERT INTO kqew_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sidto na logar aon sambok na bobay na dili ng Yahodi na dyomood kang Isa. Pagdood nan kanan yagapiyagit yan aw laong nan, “Kay Dato, Anak ni Daud, kallati ako! Kay yang anak ko na bobay kyasaytanan aw labi da yang kasikot nan.” ");
INSERT INTO kqew_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Awgaid wa atobag kanan si Isa. Ansinyan dyomood kanan yang mga inindowan nan aw yaga-angyo silan kanan, laong nilan, “Papanawa idtong bobay kay yag-agad-agad yan kanatun aw yagakasamok.” ");
INSERT INTO kqew_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ansinyan yagalaong si Isa sidtong bobay, “Syogo gaid ako sang mga topo ni Israil kay mag-onawa silan ng mga karniro na yamangkawaa.” ");
INSERT INTO kqew_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Awgaid yang ininang ng bobay, syomojod yan sa atobangan ni Isa aw laong nan, “Kay Dato, tabangi ako.” ");
INSERT INTO kqew_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Awgaid tyomobag si Isa aw laong nan, “Dili ng madyaw aw akamangun yang pagkan ng mga isu aw idami adto sang mga ido.” ");
INSERT INTO kqew_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Bunna sagaw, kay Dato,” yagalaong yang bobay, “awgaid maskin yang mga ido makakan ng momo na amallog sikun sang lamisa ng tagtomon nilan.” ");
INSERT INTO kqew_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ansinyan yagalaong kanan si Isa, “Kay Bi, dakowa yang pagpangintoo mo! Amatoman da yang pyangayo mo.” Aw sinyan na wakto yamadyaw da yang anak nan. ");
INSERT INTO kqew_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ansinyan pyomanaw si Isa sinyan na banwa aw kyomadto yan sang kilid ng Linaw ng Jalil. Pagkatapos, syomakat yan sang butay aw pag-ingkod ansan. ");
INSERT INTO kqew_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ansinyan madaig yang mga otaw na kyomadto kanan na yagadaa sang mga masakitun mag-onawa ng mga pongkol, sadi, bota, mga amang aw yang kadaigan pa na masakitun. Byutang nilan yang mga masakitun sang masaid sang siki ni Isa aw pyakadyaw nan yang kariko nilan. ");
INSERT INTO kqew_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yatingaa da yang mga otaw pagkita nilan na yang mga amang yakapaglaong da, yang mga pongkol yamadyaw da, yang mga sadi yakapanaw da, aw yang mga bota yakakita da. Aw ansinyan pyoji nilan yang Tohan ng bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Adon pyadood ni Isa yang mga inindowan nan aw paglaonga nan, “Yamaooy ako sini na mga otaw kay too pang allaw na yamagad silan kanak aw adon waa day pagkan nilan. Di ko karim na pa-oriun ko silan na yamangkagutum kay basin amalangot silan sang daan.” ");
INSERT INTO kqew_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yagalaong kanan yang mga inindowan nan, “Wain kita makakamang ng ipakan sang kadaig sini na mga otaw sini na banwa na mamingaw?” ");
INSERT INTO kqew_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Pilambok yang pan mayo ansan?” yaga-osip kanilan si Isa. “Pitombok da,” tyomobag silan, “aw tagbi da gaid yang mangkayantuk na isda.” ");
INSERT INTO kqew_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ansinyan pya-ingkod ni Isa yang mga otaw sang lopa. ");
INSERT INTO kqew_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kyamang nan yang pitombok na pan aw yang mga isda aw panginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan aw atagan sang mga inindowan nan untak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama na pagkan, pitongka bokag yang yamapono nilan. ");
INSERT INTO kqew_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yang kadaig ng mga otaw na yakakan, 4000 yang kausugan na way labot yang kaobayan aw yang mga isu. ");
INSERT INTO kqew_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos sinyan, pya-ori ni Isa yang mga otaw. Ansinyan syomakay yan sang bangka aw kadto sang banwa ng Magadan. ");
INSERT INTO kqew_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sangallaw sinyan aon mga Parisi aw Sadoki na kyomadto kang Isa untak tigiun nilan. Yamangayo silan kanan ng katingaan silbi tanda na syogo yan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Awgaid tyomobag si Isa, “Kong mapowa yang langit pagsallup ng suga, magalaong kamo, ‘Madyaw yang timpo kisuum.’ ");
INSERT INTO kqew_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kong mapowa aw maduggum yang langit ng kaamdag, magalaong kamo, ‘Omowan adon na allaw.’ Agaw sagaw, akatigaman mayo yang timpo sabap sang kinita mayo sang langit. Awgaid nanga di kamo matigam magmana ng mga tanda na kinita mayo adon na panahon? ");
INSERT INTO kqew_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Maat yang mga otaw adon na panahon aw yagapakawat silan sang Tohan. Karim nilan makakita ng katingaan, awgaid way ipakita kanilan yatabiya sidtong katingaan na ya-inang adto kang Nabi Yonos.” Pagkatapos sinyan pyanawan nan silan. ");
INSERT INTO kqew_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ansinyan pagtaripag ni Isa aw yang mga inindowan nan sang linaw, kyadumduman ng mga inindowan na wa silan pagadaa ng pan. ");
INSERT INTO kqew_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo sang labadora ng mga Parisi aw mga Sadoki.” ");
INSERT INTO kqew_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagdungug sinyan, yanagbaaw-baaw silan aw laong nilan, “Basin maynidto yang pyagalaong nan kay wa kita pagadaa ng pan.” ");
INSERT INTO kqew_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Awgaid kyatigaman ni Isa yang pyagabaawan nilan. Agaw yaga-osip yan kanilan, “Nanga yanagbaaw-baaw kamo na way daa mayo na pan? Katagbi ng pagsarig mayo kanak! ");
INSERT INTO kqew_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wa pa kadi kamo pakasabot? Kyaringawan da mayo yang limambok na pan na pyagapisang-pisang ko untak makakan yang 5000 na mga otaw? Aw pilambok yang bokag na yamapono mayo ng yamasama? ");
INSERT INTO kqew_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dumduma oman mayo yang pitombok na pan na pyakan ko sang 4000 na mga otaw. Pilambok oman yang bokag na yamapono mayo ng yamasama? ");
INSERT INTO kqew_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nanga wa pa kamo pakasabot? Dili ng pan yang karim ko ipasabot sang paglaong ko kamayo na dait kamo magbantay sang labadora ng mga Parisi aw Sadoki.” ");
INSERT INTO kqew_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ansinyan yakasabot da yang mga inindowan nan na yang labadora na pyagalaong nan kanilan dili ng labadora na gyamit sang pan kondi yang indowan ng mga Parisi aw Sadoki. ");
INSERT INTO kqew_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ansinyan kyomadto silan Isa sang logar na masaid sang longsod ng Kisariya Pilipi. Pagdatung nilan adto, yaga-osip si Isa sang mga inindowan nan, laong nan, “Sobay sang mga otaw, sino kono ako na Anak ng Manosiya?” ");
INSERT INTO kqew_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas. Yang kadaigan oman yagalaong na ikaw kono si Nabi Irimiyas atawa sambok na nabi singaon.” ");
INSERT INTO kqew_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yaga-osip kanilan si Isa, “Awgaid kamo, ono yang ikapaglaong mayo daw sino ako?” ");
INSERT INTO kqew_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tyomobag si Simon Pitros, “Ikaw yang Almasi, yang Anak ng bowi na Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yagalaong si Isa kanan, “Kay Simon na anak ni Yonos, kadyaw ng ginawa mo kay yani wa apakatigaman kammo ng mga otaw kondi yang Ama ko adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aw adon pagangaanan ta kaw kang Pitros na yang mana nan bato. Aw sang babaw sini na bato apa-indug ko yang kanak jamaa, aw maskin yang kabarakat ng kamatayun di amakadaog kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Atagan ta kaw ng kapatot sang pyagdatowan ng Tohan. Maskin ono na isagda mo adi sang donya, isagda oman adto sa sorga. Aw maskin ono na itogot mo adi sang donya, itogot oman adto sa sorga.” ");
INSERT INTO kqew_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ansinyan syagda ni Isa yang mga inindowan nan na di silan maggogod sang maskin sino na yan agaw yang Almasi. ");
INSERT INTO kqew_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sikun sidto na wakto yagasogod da si Isa magpatigam sang mga inindowan nan daw ono yang amaitabo kanan sang madatung na mga allaw. Laong nan, “Dait na makadto ako sa Awrosalam aw amagi ng mga kasikotan na inangun kanak ng mga pangoo ng mga Yahodi, mga pangoo ng mga imam kipat yang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoo na allaw amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagdungug sinyan ni Pitros, pyaga-agad nan si Isa sang mawat-awat sang kadaigan aw sagdaa nan, laong nan, “Kay Dato, di gao yan itogot ng Tohan! Di mapakay na amaitabo kammo yang mayninyan!” ");
INSERT INTO kqew_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Awgaid yaga-atobang kanan si Isa aw yagalaong yan kanan, “Panaw ansan, kay Iblis! Yagasasat kaw kanak kay yang dumduman mo dili ng kahanda ng Tohan kondi yang dumduman gaid ng manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sino-sino yang marim magpangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqew_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kay sino-sino na yang pyalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, aka-aonan ng bunna na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kay ono yang amakamang ng otaw kong amakun nan yang kariko ng kakawasaan adi sang donya, awgaid kong amatay da yan asiksaun da yan adto sang narka? Waa! Kay way ika-atag nan untak ka-aonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kay ako na Anak ng Manosiya mallug da magbarik adi sang donya sang kasiga ng kanak Ama na yagadan ako ng mga malaikat. Aw ansinyan abausan ko yang matag-isa na otaw sobay sang ininang nan. ");
INSERT INTO kqew_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bunna yang ipaglaong ko kamayo na aon mga otaw disini na di amatay taman sang akitaun nilan ako na Anak ng Manosiya na mabarik untak magdato sang kariko.” ");
INSERT INTO kqew_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkatapos ng unum na allaw pyaga-agad ni Isa si Pitros aw yang dowa na maglomon na si Yakob aw si Yahiya aw syomakat silan sang makagwas na butay na silan da gaid. ");
INSERT INTO kqew_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Adto sa taas sarta yagatanaw silan kang Isa, yaparin yan sa atobangan nilan. Yang kanan parangay yagasiga na maynang suga aw yang kanan dagom yagakapoti na mag-onawa ng allag na masilaw. ");
INSERT INTO kqew_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sakadyap yagapakita kanilan si Nabi Mosa aw si Nabi Iliyas aw yapagbaaw silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ansinyan yagalaong si Pitros kang Isa, “Kay Dato, madyaw na adi kami sini. Kong karim mo, maga-inang ako ng toombok na lagkaw, sambok kammo, sambok kang Nabi Mosa aw sambok oman kang Nabi Iliyas.” ");
INSERT INTO kqew_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nang yagalaong pa yan, kyatabonan silan ng gabon na masilaw aw aon yadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang pyasaya ko na Anak. Dakowa yang kasowat ko kanan. Paningug kamo kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagdungug sinyan ng mga inindowan, bali na kalluk nilan aw syomojod silan sang lopa. ");
INSERT INTO kqew_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Awgaid dyomood kanilan si Isa aw dyamdam nan silan aw laong nan, “Indug kamo. Ayaw kamo pagkalluk.” ");
INSERT INTO kqew_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagtanaw nilan, waa day kinita nilan na sangka otaw da ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ansinyan paglodsad nilan sikun sang butay, syagda silan ni Isa aw laong nan, “Ayaw kamo paggogod sang maskin sino ninyang kinita mayo taman sang amabowi oman ako na Anak ng Manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ansinyan yaga-osip kanan yang mga inindowan nan, “Nanga yagalaong yang mga magiindoway ng Hokoman na madatung ona si Nabi Iliyas bago pa yang Almasi?” ");
INSERT INTO kqew_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tyomobag si Isa, “Bunna sagaw na madatung ona si Nabi Iliyas kay andamun nan yang kariko. ");
INSERT INTO kqew_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Awgaid ipaglaong ko kamayo na dyomatung da si Nabi Iliyas awgaid wa yan akilaa ng mga otaw aw ininang nilan kanan yang maskin ono na kyallinian nilan. Mag-onawa sinyan, apasikotan oman ako na Anak ng Manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ansinyan yakasabot silan na si Yahiya na Magsosogboway kadi yang pyagalaong nan. ");
INSERT INTO kqew_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagbarik nilan sikun sang butay madaig oman yang mga otaw ansan. Aon sambok na otaw sinyan na dyomood kang Isa aw lyomood sa atobangan nan. ");
INSERT INTO kqew_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Laong nan, “Kay Dato, kallati yang anak ko na usug. Pagbaboyon maag yan aw labi da yang kasikot nan kay abay yan matomba sang atoon atawa mallog sang tobig. ");
INSERT INTO kqew_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Dyaa da ko yan sang mga inindowan mo, awgaid wa silan pakapagkadyaw kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yagalaong si Isa, “Astaga! Kamo na mga otaw adon na panahon, waa sabay pagpangintoo mayo aw sayup oman yang dumduman mayo. Kadogay da ako adi kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi kanak yang isu.” ");
INSERT INTO kqew_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ansinyan syagda ni Isa yang saytan na iyan sang lawas ng isu. Aw sidto na wakto lyomogwa dayon yang saytan aw yamadyaw da yang isu. ");
INSERT INTO kqew_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ansinyan nang silan da gaid, dyomood kang Isa yang mga inindowan nan aw yaga-osip silan, “Nanga wa kami pakapalogwa ng saytan?” ");
INSERT INTO kqew_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tyomobag si Isa, “Sabap ng kolang pa yang pagpangintoo mayo. Sa bunna-bunna na ipaglaong ko kamayo na kong aon pagpangintoo mayo na maskin tagbi na maynang katagbi da gaid ng liso ng mostasa, makapaglaong da kamo sini na butay na, ‘Ballin adto!’ aw magaballin sagaw yan. Kay way butang na di mayo ma-inang kong aon pagpangintoo mayo. ");
INSERT INTO kqew_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Awgaid yang mayninyan na klasi na saytan di mapalogwa yatabiya pina-agi sang pagdowaa aw pagpowasa.” ");
INSERT INTO kqew_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sangallaw sinyan nang yagakatipon yang mga inindowan ni Isa adto sa Jalil, yagalaong yan kanilan, “Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot. ");
INSERT INTO kqew_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Apatayun ako nilan, awgaid sang ikatoo na allaw amabowi oman ako.” Pagdungug sinyan ng mga inindowan nan, bali na karido nilan. ");
INSERT INTO kqew_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagdatung nilan sang longsod ng Kapirnaom, dyomood kang Pitros yang mga kobrador ng bowis para sang Baay ng Tohan aw yaga-osip silan, “Yagabayad yang kamayo goro ng bowis para sang Baay ng Tohan?” ");
INSERT INTO kqew_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Uu, yagabayad,” tyomobag si Pitros. Ansinyan pagsuud ni Pitros sang baay, yagalaong dayon si Isa kanan, “Simon, sang kammo dumduman, sino kowaw yang apabayadun ng bowis ng mga soltan adi sang donya? Yang kanilan mga anak atawa yang kadaigan na mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Yang kadaigan,” tyomobag si Pitros. “Na, kong maynan,” laong ni Isa, “di kinaanglan magbayad ng bowis yang mga anak nilan. ");
INSERT INTO kqew_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Awgaid di kita marim na magkaat yang ginawa nidtong mga otaw kanatun. Agaw kadto da sang linaw aw pamingwit. Kamanga yang ona na isda na matobog aw abrii yang baba nan. Ansan akitaun mo yang sapi na osto na pagabayad sang bowis natun dowa. Kamanga yang sapi aw atagi yang mga kobrador ng kanatun bayad.” ");
INSERT INTO kqew_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sidto na wakto dyomood kang Isa yang mga inindowan nan aw yaga-osip silan, “Sino kadi yang labaw sang pyagdatowan ng Tohan?” ");
INSERT INTO kqew_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yang ininang ni Isa, tyawag nan yang sambok na isu aw pa-induga nan sa atobangan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ansinyan yagalaong yan, “Sa bunna-bunna na ipaglaong ko kamayo, kong di mayo parinun yang dumduman mayo aw di kamo maga-onawa sang tagbi na mga isu, di kamo makasuud sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kay sino-sino yang magapababa sang ginawa nan na mag-onawa sini na tagbi na isu, yan yang labaw sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aw sino-sino yang magatarima sang isu na main sini sabap sang pagpangagad nan kanak, magatarima oman kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Sino-sino yang magasasat sang maskin sambok sini na tagbi na mga isu na yagapangintoo kanak untak yan makadosa, madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw idami yan adto sang laod. ");
INSERT INTO kqew_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kallat ng mga otaw adi sang donya kay madaig yang mga sasat na madatung kanilan. Di sagaw malikayan na aon mga sasat, awgaid kallat nidtong otaw na yagadaa sang kadaigan sang kadosaan. ");
INSERT INTO kqew_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Idto sagaw, kong yang arima atawa siki mo yang pyagasabapan na amakadosa kaw, otoda inyan aw damian. Madyaw pa na sambok gaid yang arima atawa siki mo, awgaid aka-aonan kaw ng kinabowi na way kataposan kaysang madyaw yang lawas mo awgaid idami kaw adto sang narka, sang atoon na di amatay. ");
INSERT INTO kqew_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mag-onawa sinyan, kong yang mata mo yang pyagasabapan na amakadosa kaw, lusata yan aw damian. Madyaw pa na sambok gaid yang mata mo, awgaid aka-aonan kaw ng kinabowi na way kataposan kaysang dowambok yang mata mo awgaid idami kaw sang atoon adto sang narka.” ");
INSERT INTO kqew_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yagalaong oman si Isa, “Pagbantay kamo na di mayo pagdaog-daogon yang maskin sambok sini na mga otaw na mag-onawa ng tagbi na mga isu. Kay ipaglaong ko kamayo na yang mga malaikat na yagabantay kanilan abay adto sa atobangan ng kanak Ama adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kay ako na Anak ng Manosiya yakani sang donya untak lowasun ko yang mga otaw na yagapakawat sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Na, bain kamayo,” laong oman ni Isa, “ono kowaw yang inangun ng otaw na 100 ka bok yang kanan karniro aw yawaa yang sambok? Di ba abiyaan nan yang 99 na yanagpanamsam adto sang kabutayan aw anapun nan yang sambok na yamatanak? ");
INSERT INTO kqew_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na, kong kitaun da nan, bali na kasowat nan. Sa bunna-bunna labaw pa yang kasowat nan sinyan na karniro kay sidtong 99 na wa akatanak. ");
INSERT INTO kqew_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na, mag-onawa oman sinyan yang Ama mayo adto sa sorga. Kay di nan karim na magapakawat kanan yang maskin sambok sini na mga otaw na mag-onawa ng tagbi na mga isu.” ");
INSERT INTO kqew_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yagalaong oman ni Isa, “Kong yakadosa kammo yang sambok na lomon mo, kadtoni yan aw paglaonga yan ng ininang nan kammo na kamo gaid dowa. Kong akunun nan na yakadosa yan kammo, pyabarik da mo oman yang madyaw na relasyon mayo. ");
INSERT INTO kqew_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Awgaid kong di yan amaningug kammo, pa-agada adto kanan yang isa atawa dowangka otaw untak tomanun mo yang yakasorat sang Kitab na ‘dait pangimunnaan yang kariko ng pyagabaawan mayo ng dowa atawa toongka saksi’. ");
INSERT INTO kqew_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kong di oman yan amaningug sang towada sidtong mga upud mo, patigama yang kariko ng jamaa. Na, kong di oman yan marim maningug maskin sang kariko ng jamaa, dumduma da gaid mayo yan na mag-onawa ng sambok na otaw na wa da akabilang na sakop natun na mga Yahodi atawa mag-onawa ng kobrador ng bowis. ");
INSERT INTO kqew_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Sa bunna-bunna na ipaglaong ko kamayo na maskin ono na isagda mayo adi sa babawan ng donya, isagda da oman adto sa sorga. Aw maskin ono na itogot mayo adi sang donya, itogot da oman adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Na, ipaglaong ko oman kamayo na kong aon dowangka otaw kamayo adi sa babawan ng donya na magaka-oyon sang maskin ono na apangayoon nilan adto sang Tohan, inangun yani ng Ama ko adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kong aon dowa atawa toongka otaw na magakasambok sa ngaan ko, iyan ako kanilan.” ");
INSERT INTO kqew_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wa akadogay sinyan dyomood si Pitros kang Isa aw yaga-osip kanan, laong nan, “Kay Dato, kong aon upud ko na abay makadosa kanak, makapila ko yan dait amponon? Makapito ba?” ");
INSERT INTO kqew_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tyomobag si Isa, “Dili gaid ng makapito, kondi kapitowan na kapito. ");
INSERT INTO kqew_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kay yang pyagdatowan ng Tohan mag-onawa ng soltan na marim mangobra sang mga sogowanun nan ng otang nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na, sang yagasogod da yan mangobra ng kanilan otang, aon dyaa adto kanan na sogowanun na yaka-otang kanan ng minilyon. ");
INSERT INTO kqew_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aw sabap ng way akabayad nan, yagasogo yang soltan na abarigya yan untak ma-inang ng allang upud sang kanan asawa aw yang mga anak nan, aw abarigya oman yang kariko ng mga butang nan untak kabayadan yang kariko ng otang nan. ");
INSERT INTO kqew_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Awgaid yang ininang ng sogowanun, syomojod yan sa atobangan ng soltan aw yaga-angyo kanan, laong nan, ‘Tabiya, kay Soltan, ayaw ako pag-apikia. Kay abayadan pa ko yang kariko ng otang ko kammo.’ ");
INSERT INTO kqew_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ansinyan yamallat kanan yang soltan aw pyapas nan yang kariko ng otang nan aw pyapanaw nan. ");
INSERT INTO kqew_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na, pagpanaw da sinyan na sogowanun, yakita nan yang kaupud nan na sogowanun na yaka-otang kanan ng pilangka gatos gaid. Na, gyallat da nan, tiniguu aw paglaonga, ‘Bayadi da yang otang mo kanak.’ ");
INSERT INTO kqew_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Awgaid yang ininang ng kaupud nan, syomojod yan aw yaga-angyo kanan, laong nan, ‘Ayaw da ako pag-apikia kay abayadan ta kaw.’ ");
INSERT INTO kqew_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Awgaid wa asogot idtong sogowanun. Pyapiriso nan yang upud nan taman sang amakabayad da yan ng kanan otang. ");
INSERT INTO kqew_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na, pagkita sinyan ng kadaigan na mga sogowanun, bali na karido nilan. Agaw kyomadto silan sang soltan aw paglaonga kanan yang kariko nidtong kyatamanan. ");
INSERT INTO kqew_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ansinyan pyatawag ng soltan yang idtong sogowanun aw paglaonga nan, ‘Darowaka kaw. Pyapas da ko yang kariko ng otang mo sabap ng yaga-angyo kaw kanak. ");
INSERT INTO kqew_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dait gao na amallat kaw oman sang kaupud mo na sogowanun mag-onawa ng pagkallat ko kammo.’ ");
INSERT INTO kqew_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yadaman da yang soltan aw pyapiriso nan idtong sogowanun taman sang akabayadan da nan yang kariko ng otang nan.” ");
INSERT INTO kqew_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sang orian yagalaong oman si Isa, “Na, mag-onawa sinyan yang inangun kamayo ng Tohan na kanak Ama adto sa sorga kong di mayo amponon ng iklas yang kapag-onawa mayo.” ");
INSERT INTO kqew_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos ni Isa maglaong sinyan pyanawan nan yang probinsya ng Jalil aw kyomadto yan sang probinsya ng Yahodiya na adto sang dipag ng tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Madaig yang mga otaw na yamagad kanan aw pyakadyaw nan yang mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ansinyan aon pilangka otaw na mga Parisi na dyomood kanan untak magtigi kanan. Yaga-osip silan, “Sobay sang Hokoman mapakay ba na buagan ng usug yang kanan asawa na maskin ono yang pyagasabapan?” ");
INSERT INTO kqew_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tyomobag si Isa, “Wa ba kamo pakabasa ng yakasorat sang Kitab na sang pukas pagbaoy ng Tohan sang donya, byaoy nan yang otaw na usug aw bobay? ");
INSERT INTO kqew_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aw pagkatapos san yagalaong yang Tohan, ‘Sabap sinyan abiyaan ng usug yang kanan ama aw ina aw mupud sang asawa nan aw ansinyan magakasambok da silan.’ ");
INSERT INTO kqew_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Agaw di da silan ng dowa kondi sambok da. Idto sagaw, di mapakay pagpitasun ng otaw yang pyagakasambok ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Na, kong maynan,” yanag-osip da oman yang mga Parisi, “nanga yagalaong si Nabi Mosa na maka-atag kono yang usug ng sorat sang asawa nan silbi tanda na yanagbuag da silan, aw ansinyan mapakay da nan buagan yang asawa nan?” ");
INSERT INTO kqew_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tyomobag si Isa, “Sabap ng mabagsug yang oo mayo tyogotan kamo ni Nabi Mosa ng pagbuag sang asawa mayo. Awgaid sikun sang pukas dili ng maynan yang kahanda ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Agaw ipaglaong ko kamayo na sino-sino yang magabuag ng asawa nan maskin wa yan pagajina aw amangasawa ng lain, magajina da yan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yagalaong kanan yang mga inindowan nan, “Kong maynan yang kabutang ng magasawa, madyaw pa yang di da gaid amangasawa.” ");
INSERT INTO kqew_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tyomobag si Isa, “Dili ng kariko yang makapangagad sinyan yatabiya sidtong mga otaw na yatagan ng Tohan ng kagaga. ");
INSERT INTO kqew_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yagakatuna-tuna yang mga sabap nanga aon mga usug na di amangasawa. Aon mga usug na aon problima sang lawas nilan sikun pa sang pagkaotaw nilan. Yang kadaigan kyapon ng otaw. Yang kadaigan oman di amangasawa kay pyalabi nilan yang paggawbuk para sang pyagdatowan ng Tohan. Na, sino-sino yang makadawat sinyan, madyaw pa aw pangagadan nan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ansinyan aon mga otaw na yagadaa ng mangkatagbi na mga isu nilan adto kang Isa untak dapunan nan silan ng arima nan aw pangayowan nan silan ng kadyawan adto sang Tohan. Awgaid syagda silan ng mga inindowan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Awgaid yagalaong si Isa, “Pasagdi mayo yang mga isu na domood kanak. Ayaw mayo silan pagbabagi kay yang mga otaw na main nilan yang amakasuud sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ansinyan dyapunan nan yang mga isu ng arima nan aw pyangayowan nan silan ng kadyawan. Pagkatapos sinyan pyomanaw yan. ");
INSERT INTO kqew_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sangallaw sinyan aon sambok na otaw na dyomood kang Isa aw yaga-osip kanan, “Kay Goro, ono yang madyaw na dait ko inangun untak ka-aonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqew_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tyomobag si Isa, “Nanga yaga-osip kaw kanak daw ono yang madyaw? Yang Tohan gaid yang madyaw. Awgaid kong karim mo ka-aonan ng kinabowi na way kataposan, tomana yang mga sogowan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yaga-osip oman yang otaw, “Wain na sogowan?” “Yang mga sogowan maynini,” laong ni Isa, “Ayaw pagpatay, ayaw pagjina, ayaw pagpangawat, ayaw pagsaksi ng bakak. ");
INSERT INTO kqew_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Addati yang ama aw ina mo. Pakadakowaa yang kapag-onawa mo mag-onawa ng looy mo sang ginawa mo.” ");
INSERT INTO kqew_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tyomobag yang olitawo, “Yang kariko ninyan tyoman da ko. Ono pa yang dait ko inangun?” ");
INSERT INTO kqew_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yagalaong si Isa kanan, “Aw karim mo na way gaid ikasaway kammo, ori da aw barigyaan yang kariko ng kabutangan mo aw yang alin atagan sang mga miskinan. Ansinyan aka-aonan kaw ng kakawasaan adto sa sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagdungug sinyan nidtong olitawo, pyomanaw yan na yamarido yang ginawa nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqew_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sa bunna-bunna na ipaglaong ko kamayo na mairap sang sapian na otaw pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sagaw, ipaglaong ko kamayo na masayun pa sang kamil pag-agi sang botas ng dagum kaysang sapian na otaw pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagdungug sinyan ng mga inindowan nan, bali na pagkatingaa nilan aw laong nilan, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqew_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ansinyan pyagatanawan silan ni Isa aw yagalaong yan kanilan, “Sang manosiya, di yan ma-inang. Awgaid sang Tohan, yang maskin ono ma-inang nan.” ");
INSERT INTO kqew_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ansinyan yagalaong kanan si Pitros, “Na, monono da kami adon? Ibiyaan da nami yang kariko aw yamagad kami kammo. Ono yang baras na amadawat nami?” ");
INSERT INTO kqew_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na pagdatung ng wakto na pabagoon da ng Tohan yani na donya, maga-ingkod da ako na Anak ng Manosiya sang kanak ingkodanan kay magadato da ako. Kamo oman na yagapangagad kanak, maga-ingkod oman kamo sang sampoo aw dowa na ingkodanan untak maghokom sang sampoo aw dowa na mga tribo ng bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aw sino-sino yang yagabiya sang kanan baay atawa sang mga lomon nan, sang ama aw ina nan, sang mga anak atawa lopa nan sabap sang pagpangagad nan kanak, labaw pa sinyan yang amadawat nan aw atagan yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Awgaid madaig yang yama-ona adon na amaori, aw madaig yang yamaori adon na ama-ona.” ");
INSERT INTO kqew_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yagalaong oman si Isa, “Yang pyagdatowan ng Tohan mag-onawa ng otaw na tagtomon ng tanumanan ng grips. Sangallaw sinyan pyomanaw yan ng masuum pa kay amanganap ng mga otaw na magagawbuk adto sang tanumanan nan. ");
INSERT INTO kqew_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pagkita nan sang pilangka otaw, yanagsabot silan na atagan nan silan ng osto na bayad ng sangallaw. Pagkatapos, pyakadto nan silan sang tanumanan untak maggawbuk silan. ");
INSERT INTO kqew_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na, mga alas nowebe ng kaamdag kyomadto yan sang palengke aw aon kinita nan na mga otaw na yaga-indugun ansan na way ininang. ");
INSERT INTO kqew_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pyagalaong nan silan, ‘Paggawbuk oman kamo adto sang kanak tanumanan aw atagan ta kamo ng osto na bayad.’ ");
INSERT INTO kqew_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ansinyan kyomadto da silan untak maggawbuk sang tanumanan. “Na, pagka-alas dose yang suga aw alas tres ng ambong pyomanaw da oman yan aw maynan oman yang ininang nan. ");
INSERT INTO kqew_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sang masaid da alas singko kyomadto da oman yan sang palengke aw aon oman kinita nan na kadaigan pa na mga otaw na yaga-indugun gaid ansan. Yosip nan silan, ‘Nanga yaga-indugun gaid kamo ansan ng tibok allaw na way ininang?’ ");
INSERT INTO kqew_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tyomobag silan, ‘Waa sabay magpagawbuk kanami.’ “ ‘Na, kong maynan,’ laong ng tagtomon, ‘adto da kamo maggawbuk sang kanak tanumanan.’ ");
INSERT INTO kqew_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagkasilum da yagalaong yang tagtomon ng tanumanan adto sang kapatas nan, laong nan, ‘Tawaga yang mga trabante aw atagi silan ng bayad nilan. Onaa bayadi ingaong yamaori maggawbuk bago pa idtong yama-ona.’ ");
INSERT INTO kqew_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ansinyan dyomatung yang mga otaw na yagasogod maggawbuk ng alas singko ng ambong aw yabayadan silan ng osto na bayad ng sangallaw. ");
INSERT INTO kqew_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pagdatung ng mga otaw na yama-ona maggawbuk, yagadumdum silan na labaw pa sidtong yakaori yang bayad kanilan. Awgaid yatagan oman silan ng osto na bayad ng sangallaw. ");
INSERT INTO kqew_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na, pagdawat nilan sinyan, yagabagolbol silan aw yagalaong silan sidtong tagtomon, ");
INSERT INTO kqew_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Yaning yamaori maggawbuk, sangka oras gaid yang gawbuk nilan. Awgaid kami, tibok allaw kami magagawbuk sang kapaso pa ng suga! Na, nanga mag-onawa da yang bayad kanilan aw kanami?’ ");
INSERT INTO kqew_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Awgaid tyomobag yang tagtomon sang sambok kanilan, ‘Kay lomon, paningug. Wa ako pagalimbong kammo kay yanagsabot saba kita na atagan ta kaw ng osto na bayad ng sangallaw. ");
INSERT INTO kqew_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dawata da yang bayad mo aw ori da adto kamayo. Karim ko gaid na yaning yamaori maggawbuk amakadawat ng mag-onawa kammo. ");
INSERT INTO kqew_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ako da yang magbuut daw ono yang inangun ko sang kanak sapi. Basin yamasina kaw gaid kay ako matipangatag.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na, syogpatan pa ni Isa yang pyaglaongan nan, “Idto sagaw, yang yamaori adon ama-ona, aw yang yama-ona adon amaori.” ");
INSERT INTO kqew_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ansinyan nang yagapaduug sang Isa sa Awrosalam, pyagalain nan yang sampoo aw dowa na mga inindowan nan sang kadaigan na mga otaw kay aon ipaglaong nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Laong nan, “Paningug kamo. Makadto da kita sa Awrosalam. Ansidto adaun ako na Anak ng Manosiya adto sang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw magahokom da silan na apatayun ako. ");
INSERT INTO kqew_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ansinyan adaun nilan ako adto sang mga dili ng Yahodi. Sangu-sanguun nilan ako aw abadasan aw ilansang adto sa kros. Awgaid sang ikatoo na allaw amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ansinyan kyomadto kang Isa yang asawa ni Sibidi upud sang dowa na mga anak nan na usug aw syomojod yan sa atobangan nan kay aon apangayoon nan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yaga-osip kanan si Isa, “Ono yang karim mo?” Tyomobag yang bobay, “Pagdatung ng wakto na magadato da kaw, kong mapakay pa-ingkodon mo yaning dowa na anak ko sang kilid mo, yang isa sang karinto mo, aw yang isa sang kawaa mo.” ");
INSERT INTO kqew_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Awgaid yagalaong si Isa sang dowa na mga anak nan, “Wa kamo akatigam daw ono yang pyangayo mayo. Ka-agian ba mayo yang kasikotan na mallug da ko agian?” Tyomobag silan, “Uu, kaya nami.” ");
INSERT INTO kqew_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yagalaong si Isa, “Bunna sagaw na agian mayo yang kasikotan na agian ko. Awgaid way kapatot ko paglaong daw sino yang apa-ingkodon sang karinto aw kawaa ko kay yang idto pyagakahanda ng kanak Ama sidtong mga otaw na pinili nan.” ");
INSERT INTO kqew_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagdungug sinyan ng sampoo na inindowan, yadaman silan sidtong dowa na maglomon. ");
INSERT INTO kqew_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Agaw pyadood ni Isa yang kariko ng mga inindowan nan aw paglaonga silan, laong nan, “Kyatigaman saba mayo yang batasan ansining donya na yang mga pangoo sang yagakatuna-tuna na bangsa magmando sang mga sakop nilan. Aw yang mga yagadato kanilan magpakita sang kapatot nilan. ");
INSERT INTO kqew_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Awgaid kamo, dili gao ng maynan yang batasan mayo. Kay sino kamayo yang mallini ma-inang ng makagwas, dait yan ma-inang ng sogowanun mayo. ");
INSERT INTO kqew_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aw sino yang mallini ma-inang ng labaw sang kariko, dait yan ma-inang ng allang sang kariko. ");
INSERT INTO kqew_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kay maskin ako na Anak ng Manosiya, wa ako akani ansining donya untak tabangan ako ng mga otaw, kondi untak matabang ako kanilan aw magpakamatay ako sang paglowas sang madaig na mga otaw sikun sang mga dosa nilan.” ");
INSERT INTO kqew_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ansinyan pagpanaw nilan ni Isa sikun sang longsod ng Ariha, madaig yang mga otaw na yamagad kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Adon, aon dowangka otaw na bota na yaga-ingkod sang kilid ng daan. Pagdungug nilan na yalabay si Isa, yagapiyagit silan aw laong nilan, “Kay Dato, Anak ni Daud, kallati kami!” ");
INSERT INTO kqew_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ansinyan syagda silan ng mga otaw untak magpakatingun. Awgaid lomban da silan magpiyagit aw laong nilan, “Kay Dato, Anak ni Daud, kallati kami!” ");
INSERT INTO kqew_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ansinyan yamondang si Isa, pyatawag nan idtong dowangka otaw aw osipa nan silan, “Ono yang karim mayo na inangun ko kamayo?” ");
INSERT INTO kqew_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tyomobag silan, “Kay Dato, karim nami makakita.” ");
INSERT INTO kqew_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yamallat si Isa kanilan aw dyapunan nan yang kanilan mata ng arima nan. Ansinyan yakakita dayon silan aw yamagad silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nang masaid da silan sang syodad ng Awrosalam aw iyan da silan sang baryo ng Bitpagi na adto sang Butay ng Jayton, pya-ona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqew_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Ansan aon makita mayo na asno upud sang kanan nati na inikutan. Obadi mayo silan aw daa adi kanak. ");
INSERT INTO kqew_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kong aon maga-osip kamayo daw ono yang ininang mayo, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato.’ Ansinyan ipadaa dayon nan kamayo yang mga asno.” ");
INSERT INTO kqew_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na, ya-inang yani kay untak matoman yang pyaglaongan ng nabi na laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Paglaonga mayo yang mga taga Siyon, ‘Tanawa mayo, yakani da yang soltan mayo. Yagapababa yan sang ginawa nan aw yakasakay yan sang nati ng asno.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na, pyomanaw da yang dowa na inindowan aw ininang nilan yang pyagasogo kanilan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dyaa da nilan yang asno kipat yang nati adto kang Isa, yampasan nilan yani ng dagom nilan aw syomakay da si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na, madaig yang mga otaw na yagabutang ng mga dagom nilan sang daan na agian ni Isa. Yang kadaigan oman yamotol ng mga sanga na madaig yang daon aw pyakanat nilan sang daan. ");
INSERT INTO kqew_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yang mga otaw na yaga-ona kang Isa aw yang mga yagasonod kanan yagapiyagit aw laong nilan, “Pojiun ta yang Anak ni Daud! Atagan gao ng kadyawan yani na syogo ng Tohan! Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqew_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ansinyan pagsuud ni Isa sa Awrosalam, yagakasamok yang kariko ng mga otaw ansan aw laong nilan, “Sino kadi inyan na otaw?” ");
INSERT INTO kqew_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tyomobag yang mga otaw na yamagad kang Isa, “Yani si Isa, yang nabi na taga Nasarit na sakop ng Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ansinyan syomuud si Isa sang Baay ng Tohan aw pyalogwa nan yang mga yanagbarigya aw yanagbili ansan. Pyagatowad nan yang mga lamisa ng mga yagakambiyo ng sapi aw yang mga ingkodanan ng mga yagabarigya ng mga malapati. ");
INSERT INTO kqew_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yagalaong yan kanilan, “Yakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan.” ");
INSERT INTO kqew_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ansinyan aon mga bota aw mga pilay na kyomadto kang Isa adto sang Baay ng Tohan, aw pyakadyaw nan silan. ");
INSERT INTO kqew_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na, yadaman da yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman pagkita nilan sang mga katingaan na ininang ni Isa aw pagdungug nilan sang mga isu na yagapiyagit adto sang pamanag ng Baay ng Tohan, laong nilan, “Pojiun ta yang Anak ni Daud!” ");
INSERT INTO kqew_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Agaw yagalaong silan kanan, “Yadungug ba mo yang pyaglaongan nining mga isu?” Tyomobag si Isa, “Uu, nanga? Wa kadi mayo akabasa yang yakasorat sang Kitab na yagalaong, ‘Maskin yang mangkatagbi na mga isu aw yang mga yagasoso pyaga-indowan ng Tohan pagpoji kanan?’ ” ");
INSERT INTO kqew_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ansinyan biniyaan silan ni Isa. Pyomanaw da yan sikun sang syodad ng Awrosalam aw kyomadto sa Bitani kay adto da yan mag-uya ng sanggabi. ");
INSERT INTO kqew_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkakaamdag sarta yagabarik sang Isa adto sang syodad, yamagutum si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ansinyan aon kinita nan na kaoy na igira sang kilid ng daan. Kyadtonan nan inyan, awgaid way kinita nan na bonga kondi mga daon da gaid. Agaw yagalaong yan sidtong kaoy, “Sikun adon di da kaw amamonga.” Ansinyan yagango dayon yang kaoy. ");
INSERT INTO kqew_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkita sinyan ng mga inindowan nan, yatingaa silan aw yaga-osip silan, “Nanga yagango dayon yang igira?” ");
INSERT INTO kqew_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na kong aon pagpangintoo mayo aw di kamo magdowa-dowa, maka-inang kamo ng mag-onawa ng ininang ko sini na kaoy. Aw dili gaid inyan, kondi makalaong oman kamo sini na butay ‘Ballin adto sang dagat,’ aw ma-inang yan. ");
INSERT INTO kqew_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kong aon pagpangintoo mayo, amadawat mayo yang maskin ono na apangayoon mayo adto sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ansinyan byomarik da oman si Isa adto sang Baay ng Tohan. Aw sarta yaga-indo yan sang mga otaw dyomood kanan yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yaga-osip silan kanan, “Ono yang kapatot mo pag-inang sidto na mga butang? Sino yang yaga-atag kammo sini na kapatot?” ");
INSERT INTO kqew_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tyomobag si Isa, “Aon oman osip ko kamayo. Kong matobag mayo, ipaglaong ko oman kamayo daw wain pagasikun yang kapatot ko pag-inang sidto na mga butang. ");
INSERT INTO kqew_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, wain pagasikun yang kapatot ni Yahiya pagsogbo sang mga otaw, sikun sang Tohan atawa sang manosiya?” Ansinyan yanagbaaw-baaw silan daw ono yang atobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun, ‘Na, nanga wa kamo apangintoo kanan?’ ");
INSERT INTO kqew_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, amalluk da kita daw ono yang inangun kanatun ng mga otaw kay yang kariko nilan yagapangintoo na sambok na nabi si Yahiya.” ");
INSERT INTO kqew_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Agaw tyomobag silan kang Isa, “Wa nami akatigami.” Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain pagasikun yang kapatot ko pag-inang sinyan na mga butang.” ");
INSERT INTO kqew_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yagalaong oman si Isa, “Ono yang dumduman mayo makapantag sini? Aon otaw na dowambok yang anak nan na usug. Kyadtonan nan yang magowang aw paglaonga nan, ‘Itin, kadto da kaw adon sang kanatun tanumanan aw paggawbuk adto.’ ");
INSERT INTO kqew_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Tyomobag yang anak nan, ‘Di ako adto.’ Awgaid pagkatugun-tugun, yaparin yang dumduman nan aw kadto da yan sang tanumanan untak maggawbuk. ");
INSERT INTO kqew_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ansinyan kyomadto da oman yang ama sang mangod aw mag-onawa sinyan yang pyaglaongan kanan. ‘Uu, makadto ako,’ tyomobag yang anak nan na mangod. Awgaid wa yan akadto. ");
INSERT INTO kqew_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Na, bain kamayo, sino sang dowa yang yagapangagad sang sogo ng ama nilan?” Tyomobag silan, “Yang magowang.” Yagalaong oman si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na yang mga kobrador ng bowis aw yang mga bobay na yagakadopang, yama-ona pa silan kamayo pagsuud sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay yakani kamayo si Yahiya untak indowan nan kamo sang matorid na daan, awgaid wa kamo apangintoo kanan. Awgaid yang mga kobrador ng bowis aw yang mga bobay na yagakadopang, yagapangintoo silan kanan. Awgaid kamo, maskin kinita da mayo na yagapangintoo silan, wa akaparin yang dumduman mayo aw wa oman kamo apangintoo kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yagalaong oman si Isa, “Paningug kamo kay aon pay isa na pasombingay. Aon otaw na tagtomon ng lopa na pyagatanuman nan ng grips. Pyakoral nan inyan aw yagapa-inang yan ng pagapugaan ng grips aw yagapatokod pa yan ng makagwas na baay untak mabantayan yang tanumanan. Ansinyan pya-atiman nan yang kanan tanumanan sang mga sinarigan aw pyomanaw adto sang mawat na banwa. ");
INSERT INTO kqew_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na, pagdatung ng wakto na maga-ipo da silan ng grips, syogo nan yang mga sogowanun nan adto sang mga sinarigan untak kamangun nilan yang kanan bain ng abot. ");
INSERT INTO kqew_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Awgaid pagdatung ng mga sogowanun adto sang tanumanan, pyandakup silan nidtong mga sinarigan. Yang sambok byonalan nilan, yang sambok pyatay nilan, aw yang sambok oman pyambono nilan ng bato. ");
INSERT INTO kqew_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ansinyan syogo da oman ng tagtomon yang kadaigan pa na sogowanun na mas madaig pa kaysang pirmiro. Awgaid yan da oman yang ininang kanilan nidtong mga sinarigan. ");
INSERT INTO kqew_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sang kataposan, syogo nan yang kanan anak kay yagalaong yan sang ginawa nan, ‘Sa way dowa-dowa addatan nilan yang kanak anak.’ ");
INSERT INTO kqew_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amakun sini na tanumanan. Unda, apatayun ta yan untak kanatun da yang kabilin kanan.’ ");
INSERT INTO kqew_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Idto sagaw, dyakup nilan yan aw daa nilan adto sa logwa ng tanumanan aw pataya nilan. ");
INSERT INTO kqew_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na adon,” laong ni Isa, “pagdatung ng tagtomon ng tanumanan, ono yang inangun nan sidtong mga sinarigan?” ");
INSERT INTO kqew_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tyomobag silan, “Sa way dowa-dowa apatayun nan idtong maat na mga otaw aw ipa-atiman nan yang kanan tanumanan sang kadaigan pa na mga otaw na maga-atag kanan ng kanan bain ng bonga sang panahon ng pagpangipo.” ");
INSERT INTO kqew_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ansinyan yagalaong si Isa kanilan, “Wa kadi mayo akabasa yang yakasorat sang Kitab na yagalaong, “ ‘Yang bato na dyami ng mga panday kay way kono kapantag, ya-inang kadi ng labi na barapantag. Yan yang ininang ng Tohan aw bali yan na katingaan.’ ");
INSERT INTO kqew_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Agaw sagaw ipaglaong ko kamayo,” laong oman ni Isa, “kamo na mga Yahodi, di da kamo ng sakop ng Tohan awgaid yang ma-inang adon na sakop nan yang kadaigan pa na mga bangsa na amangagad kanan ng iklas. ");
INSERT INTO kqew_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sino-sino yang amalogso sini na bato, amatomba aw waa day siyat yang kinabowi nan. Awgaid madatung yang wakto na ama-oog da yani na bato aw sino-sino yang akaoogan ninyan, di da gaid akatabangan.” ");
INSERT INTO kqew_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na, pagdungug sinyan ng mga pangoo ng mga imam aw yang mga Parisi, kyatigaman nilan na silan yang kyugdan ni Isa sinyan na pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Agaw sagaw adakupun da gao nilan si Isa, awgaid yamalluk silan sang mga otaw kay yagapangintoo silan na sambok yan na nabi. ");
INSERT INTO kqew_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ansinyan yaga-indo da oman si Isa sang mga otaw pina-agi sang mga pasombingay, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yang pagdato ng Tohan mag-onawa ng sambok na soltan na yaga-andam ng pakaradyaan para sang kawin ng kanan anak na usug. ");
INSERT INTO kqew_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nang yandam da yang kariko, syogo nan yang kanan mga sogowanun adto sang mga imbitado untak silan magtambong sang pakaradyaan. Awgaid wa silan akallini tomambong. ");
INSERT INTO kqew_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Agaw syogo da oman ng soltan yang kadaigan pa na mga sogowanun aw yagalaong yan kanilan, ‘Paglaonga mayo yang mga imbitado na yandam da yang kandori. Syobari da ko yang mga baka kipat yang mataba na mga nati ng baka aw yaloto da yang kariko. Agaw pakania da silan sang pakaradyaan.’ ");
INSERT INTO kqew_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Awgaid yang mga imbitado wa pagapaningug kanilan. Yang sambok kyomadto sang kanan pawa, aw yang sambok oman adto sang kanan tindaan. ");
INSERT INTO kqew_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yang kadaigan oman, dyakup nilan yang mga sogowanun ng soltan, pyasakitan aw pyatay nilan. ");
INSERT INTO kqew_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Idto sagaw bali na kadaman ng soltan. Syogo nan yang mga sondao nan na apatayun nilan idtong mga yagapatay sang mga sogowanun nan aw sonogon nilan yang kanilan syodad. ");
INSERT INTO kqew_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatapos sinyan pyatawag nan yang mga sogowanun nan aw paglaonga nan, ‘Yandam da yang pakaradyaan, awgaid yang mga otaw na pyaga-imbitar ko dili dait magtambong sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Agaw kadto kamo sang mga daan na madaig yang mga otaw aw pakania sang pakaradyaan yang maskin sino na akitaun mayo.’ ");
INSERT INTO kqew_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ansinyan kyomadto da yang mga sogowanun adto sang mga daan aw dyaa nilan yang kariko ng mga otaw na kinita nilan, mga madyaw aw maat. Agaw sagaw yamapono da ng mga bisita yang baay daw wain yang pakaradyaan ng kawin. ");
INSERT INTO kqew_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Adon, pagsuud ng soltan kay atanawon nan yang mga bisita, aon kinita nan na sambok na usug na wa pagapandagom para sang pakaradyaan. ");
INSERT INTO kqew_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ansinyan yagalaong yang soltan, ‘Kay Itin, monono yang pagsuud mo adi na wa kaw pagapandagom para sang pakaradyaan?’ Awgaid wa atobag yang inyan na otaw. ");
INSERT INTO kqew_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ansinyan syogo ng soltan yang mga sogowanun nan aw laong nan, ‘Gaposa mayo yang arima aw siki nan aw damian mayo adto sa logwa sang kadugguman. Adto da yan magtiyao aw mangolitub yang onto nan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ansinyan yagalaong oman si Isa, “Madaig yang mga otaw na pyaga-imbitar ng Tohan adto sang pyagdatowan nan, awgaid tagbi da yang pinili nan untak makasuud.” ");
INSERT INTO kqew_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Adon pyomanaw da yang mga Parisi aw yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa sang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ansinyan pyakadto nilan kang Isa yang pilangka otaw na mga inindowan nilan aw yang mga otaw ni Soltan Hirod. Pagdatung nilan kang Isa, yagalaong silan kanan, “Kay Goro, yamatigam kami na mapoti yang pangatayan mo aw aag bunna yang pyaga-indo mo makapantag sang karim ng Tohan. Di mo apangagadan yang dumduman ng mga otaw kay di kaw magapili sang otaw na maskin ono yang ranggo nilan. ");
INSERT INTO kqew_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Adon, paglaonga kami daw ono yang dumduman mo makapantag sini. Sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sa Roma atawa dili?” ");
INSERT INTO kqew_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Awgaid kyatigaman ni Isa na maat yang toyo nilan, agaw yagalaong yan, “Kamo na yagapakita-kita gaid! Nanga karim mayo ako dakupun sang pyaglaongan ko? ");
INSERT INTO kqew_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitaan kanak yang sapi na ibayad mayo ng bowis.” Ansinyan yatag nilan kanan yang sambok na sapi na pilak. ");
INSERT INTO kqew_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Adon yosip silan ni Isa, “Kanino parangay aw ngaan yang yakabutang sini?” ");
INSERT INTO kqew_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Kanang soltan sa Roma,” yang tobag nilan. Ansinyan yagalaong si Isa, “Na, kong maynan, i-atag mayo sang soltan yang kanang soltan, aw i-atag oman mayo sang Tohan yang kanang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagdungug nilan sinyan, bali na pagkatingaa nilan aw pyanawan da nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sinyan na allaw aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. ");
INSERT INTO kqew_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yaga-osip silan kang Isa, “Kay Goro, yagalaong si Nabi Mosa sang Hokoman na kong amatay yang usug ng way anak sang kanan asawa, dait na apangasawaun ng lomon nan yan na biyoda untak ka-aonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqew_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Adon, aon adi kanami pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. Agaw, pyangasawa da ng mangod na yagasonod kanan idtong biyoda. ");
INSERT INTO kqew_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Awgaid yamatay da oman yan na lomon na way anak. Maynan oman yang ikatoo taman sa ikapito. ");
INSERT INTO kqew_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqew_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Adon, sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay kay yang kariko ng pito na maglomon yakapangasawa kanan?” ");
INSERT INTO kqew_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tyomobag si Isa aw laong nan kanilan, “Sayup yang dumduman mayo kay wa kamo pakasabot sang yakasorat sang Kitab aw wa oman mayo akatigami yang kabarakat ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kay kong amabowi oman yang mga patay, di da silan amangasawa atawa magabana kay mag-onawa da silan sang mga malaikat adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, makapantag sang pagkabowi oman ng mga patay, wa kadi mayo akabasa yang pyaglaongan kamayo ng Tohan? Kay yagalaong yan, ");
INSERT INTO kqew_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ako yang Tohan na pyagasambayangan ni Ibrahim, ni Isahak aw ni Yakob.’ Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay.” ");
INSERT INTO kqew_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagdungug sinyan ng mga otaw, yangkatingaa silan sang pyaga-indo nan. ");
INSERT INTO kqew_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagdungug ng mga Parisi na wa da pakatobag kang Isa yang mga Sadoki, yanagkatipon silan adto kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yang sambok kanilan alim ng Hokoman ng Tohan. Yaga-osip yan kang Isa untak magtigi kanan, ");
INSERT INTO kqew_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","laong nan, “Kay Goro, wain na sogowan sang Hokoman yang labaw sang kariko?” ");
INSERT INTO kqew_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tyomobag si Isa, “ ‘Pakadakowaa yang Tohan na kammo Tagallang sang tibok mo na pangatayan aw kallowa aw sang tibok mo na dumduman.’ ");
INSERT INTO kqew_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yani yang sogowan na labaw sang kariko. ");
INSERT INTO kqew_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mag-onawa sinyan, dakowa oman yang ikadowa na sogowan, ‘Kaoyi yang kapag-onawa mo mag-onawa ng looy mo sang ginawa mo.’ ");
INSERT INTO kqew_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yang kariko ng Hokoman na yatag ng Tohan kang Nabi Mosa aw yang kariko ng pyaga-indo ng mga nabi yakalasak sining dowambok na sogowan.” ");
INSERT INTO kqew_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sarta yanagkatipon pa ansan yang mga Parisi, yaga-osip kanilan si Isa, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ono yang kamayo dumduman makapantag sang Almasi? Kanino topo yan?” Tyomobag silan, “Topo yan ni Soltan Daud.” ");
INSERT INTO kqew_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Na, kong maynan,” laong ni Isa, “nanga yagalaong si Soltan Daud na yang Almasi yang kanan Dato? Kay idto yang pyaglaongan nan sang wakto na pyagabuutan yan ng Nyawa ng Tohan, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Yagalaong yang Tohan sang kanak Dato, “Pag-ingkod adi sang karinto ko sampay na ataloon ko yang mga kalaban mo aw ma-inang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqew_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, kong tyawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” ");
INSERT INTO kqew_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na, way maskin isa kanilan na yakatobag sinyan. Aw sikun sinyan na allaw waa day yamangisug mag-osip kanan. ");
INSERT INTO kqew_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ansinyan yagalaong si Isa sang mga otaw kipat sang mga inindowan nan, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yang mga magiindoway ng Hokoman aw yang mga Parisi, aon kapatot nilan pag-obad sang Hokoman ni Nabi Mosa. ");
INSERT INTO kqew_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Agaw pangagadi mayo yang kariko ng pyaga-indo nilan kamayo. Awgaid ayaw mayo pagsonoda yang ininang nilan kay wa nilan inanga yang pyaga-indo nilan. ");
INSERT INTO kqew_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pyapusan nilan yang mga otaw ng mabugat na mag-onawa ng mga sogowan na mairap tomanun, awgaid di silan matabang kanilan ng maskin tagbis. ");
INSERT INTO kqew_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yang kariko ng ininang nilan, ininang gaid nilan untak silan kitaun ng mga otaw. Tanawa mayo yang kadakowa ng lasakanan ng mga ayatan sikun sang Kitab na byutang nilan sang guya aw sang mga buktun nilan. Tanawa oman mayo yang kataas ng mga sinolid na ibitay nilan sang sidsid ng dagom nilan. ");
INSERT INTO kqew_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sang mga kandori, kallini nilan mag-ingkod sang ingkodanan ng mga otaw na dait addatan. Aw adto sang pagsasambayangan, karim nilan mag-ingkod sang ingkodanan ng dakowa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Adto sang palengke, kallini nilan na asalamun silan ng mga otaw aw pagtawagun silan na ‘Goro.’ ");
INSERT INTO kqew_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Awgaid di kamo dait pagtawagun na ‘Goro’ kay obos kamo maglomon aw sambok da yang kamayo goro. ");
INSERT INTO kqew_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aw ayaw kamo pagtawag na ‘Ama’ sang maskin sino adi sang donya kay sambok da yang Ama mayo na adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Di oman kamo dait pagtawagun na ‘Pangoo’ kay sambok da yang kamayo pangoo aw yan yang Almasi. ");
INSERT INTO kqew_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Daw sino yang labaw kamayo, dait yan ma-inang ng sogowanun mayo. ");
INSERT INTO kqew_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kay sino-sino yang magapataas sang ginawa nan, apababaun, aw sino-sino yang magapababa sang ginawa nan, apataasun. ");
INSERT INTO kqew_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Pyagalupunan mayo yang daan untak yang mga otaw di makasuud sang pyagdatowan ng Tohan. Kamo mismo di marim magpasakop sang pagdato nan aw yagababag pa kamo sang mga otaw na marim gao magpasakop. ");
INSERT INTO kqew_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Pyasikotan mayo yang mga biyoda untak ma-agaw mayo yang kakawasaan nilan. Aw pyataas mayo yang pagdowaa mayo sa atobangan ng mga otaw untak magpakita kamo na madyaw kamo na mga otaw. Na, labi da yang siksa kamayo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Mataripag kamo sang dagat aw makadto kamo sang tuna na mga banwa untak madaa mayo yang maskin sangka otaw gaid na dili ng Yahodi sang pagpangintoo mayo. Pagkatapos, kong aon day yagapangagad kamayo, na, sabap sang pag-indo mayo kanan mallabi pa yang kaatan nan kay kamayo aw labaw pa kamayo yang siksa kanan adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Labi na maat yang adatungan mayo kay main kamo ng mga bota na yagagabay sang kadaigan! Yaga-indo kamo na kong magapasad yang otaw aw ipagsaksi nan yang Baay ng Tohan, mapakay na maskin di da nan atomanun yang pasad nan. Awgaid kong magapasad yang otaw aw ipagsaksi nan yang bowawan na adto sa suud ng Baay ng Tohan, di mapakay na abarobaun nan yang pasad nan. ");
INSERT INTO kqew_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Astaga! Mga bota aw mga sangu kamo! Wain yang labi na barapantag, yang bowawan atawa yang Baay ng Tohan na yagapasotti sang bowawan? ");
INSERT INTO kqew_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yaga-indo oman kamo na kong magapasad yang otaw aw ipagsaksi nan yang pagsosonogan ng korban, mapakay na di da nan atomanun yang pasad nan. Awgaid kong magapasad yang otaw aw ipagsaksi nan yang korban sa babaw ng pagsosonogan, di mapakay na abarobaun nan yang pasad nan. ");
INSERT INTO kqew_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga bota sagaw kamo! Wain yang labi na barapantag, yang korban atawa yang pagsosonogan na yagapasotti sang korban? ");
INSERT INTO kqew_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na idto, kong magapasad yang otaw aw ipagsaksi nan yang pagsosonogan ng korban, apil ninyan yang kariko na adto sang babaw ng pagsosonogan. ");
INSERT INTO kqew_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aw kong magapasad yang otaw aw ipagsaksi nan yang Baay ng Tohan, apil ninyan yang Tohan na yaga-uya sinyan na baay. ");
INSERT INTO kqew_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kong magapasad yang otaw aw ipagsaksi nan yang sorga, apil ninyan yang ingkodanan ng Tohan kipat oman sang Tohan na yaga-ingkod sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Yagajakat kamo ng ikasampoo na bain maskin dakoman ng anag mayo na mag-onawa ng paminta, bawang aw pandan. Awgaid yang labi na barapantag na mga sogowan ng Hokoman wa mayo atomana na mag-onawa ng pag-inang ng matorid, na dait magkaooy sang kapag-onawa aw dait na kasarigan kamo na mga otaw. Na, yani silan yang dait mayo tomanun, awgaid ayaw oman mayo pagpasagdi yang kadaigan pa na mga sogowan. ");
INSERT INTO kqew_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Astaga! Mga bota kamo na yagagabay sang kadaigan! Kay yang ininang mayo mag-onawa ng ininang ng otaw na yagasaa ng tobig na inumun nan untak makamang yang niknik. Awgaid yang dakowa na ayup na mag-onawa ng kamil, alamonon nan. ");
INSERT INTO kqew_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Pyagalinisan mayo yang logwa gaid ng kamayo tasa aw plato, awgaid yang pangatayan mayo yamapono ng pagkasingit aw pagpangilad sang kapag-onawa mayo. ");
INSERT INTO kqew_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamo na mga Parisi, mga bota kamo! Dait na linisan mayo ona yang pangatayan mayo, aw ansinyan madyaw oman yang batasan mayo. ");
INSERT INTO kqew_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Mag-onawa kamo sang kobor na pinintoraan ng mapoti. Madyaw yan tanawon, awgaid adto sa suud madaig yang mga pusa ng patay aw yang mangkaripa na mga butang. ");
INSERT INTO kqew_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mag-onawa sinyan, maynang matorid kamo sang pagtanaw ng mga otaw, awgaid sang kabunnaan maat yang lasak ng pangatayan mayo. ");
INSERT INTO kqew_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yagapangagad kamo sang Tohan! Yaga-inang kamo ng tadumanan sang kobor ng mga nabi aw pyakadyaw mayo yang mga kobor ng matorid na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aw yagalaong kamo, ‘Aw yabowi kami sang panahon ng kanami kaompowan, di kami mag-upud sang maat na ininang nilan na pyatay nilan yang mga nabi.’ ");
INSERT INTO kqew_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sabap sini na pyaglaongan mayo pyatigam mayo na topo kamo nidtong mga otaw na yagapatay sang mga nabi. ");
INSERT INTO kqew_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, taposa da gaid mayo yang dosa na pyagasogodan ng kaompowan mayo! ");
INSERT INTO kqew_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mga limbongon kamo! Yagadumdum ba kamo na makalikay kamo sang hokom ng Tohan na asiksaun kamo adto sang narka? Dili! ");
INSERT INTO kqew_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kay ipaglaong ko kamayo na apadaan ta kamo ng mga nabi, mga otaw na maum yang katigam aw mga magiindoway ng pyaglaongan ng Tohan. Na, yang kadaigan kanilan apatayun mayo aw yang kadaigan ilansang mayo sa kros. Aw yang kadaigan oman apabadasan mayo adto sang mga pagsasambayangan mayo aw alopogon aw apasikotan mayo silan maskin wain silan kadto. ");
INSERT INTO kqew_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na, sabap sinyan kamo da yang adatungan ng siksa sang pagpatay sang kariko ng matorid na mga otaw adi sa babawan ng donya sikun pa sang pagpatay kang Habil na matorid na otaw sampay sang pagpatay kang Sakariyas na anak ni Baraki na pyatay mayo na mga Yahodi adto sang tunga ng Baay ng Tohan aw yang pagsosonogan ng korban. ");
INSERT INTO kqew_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa bunna-bunna na ipaglaong ko kamayo na yang siksa sang kariko ninyan madatung sang mga otaw adon na panahon. ");
INSERT INTO kqew_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O mga taga Awrosalam! Kallat mayo kay pyatay mayo yang mga nabi aw byato mayo yang mga otaw na syogo ng Tohan adto kamayo. Makapila da ako magpakita kamayo na karim ta kamo tiponon aw atimanun mag-onawa ng osoyan na ilooban nan yang mga osoy nan. Awgaid wa kamo akallini! ");
INSERT INTO kqew_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, apabayaan da kamo ng Tohan aw sang orian waa day maga-uya sang banwa mayo. ");
INSERT INTO kqew_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ipaglaong ko kamayo na di da mayo ako akitaun taman sang wakto na mabarik oman ako aw magalaong da kamo, ‘Atagan gao ng kadyawan yani na syogo ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ansinyan lyomogwa da si Isa sikun sang Baay ng Tohan. Aw sarta yagapanaw yan dyomood kanan yang mga inindowan nan aw yagabaaw silan kanan makapantag sang kadyaw ng pag-inang sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Awgaid yagalaong kanilan si Isa, “Madyaw sagaw tanawon yang kariko ninyan. Awgaid bunna yang ipaglaong ko kamayo na madatung yang allaw na way maskin sambok na bato na amabilin sang kyabutangan nan kay obos silan ipangkanat-kanat.” ");
INSERT INTO kqew_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wa akadogay sinyan sarta yaga-ingkod si Isa adto sang Butay ng Jayton, dyomood kanan yang mga inindowan nan aw nang silan da gaid yagalaong silan, “Paglaonga kami daw kano pa matoman yani na pyaglaongan mo aw ono yang tanda na magapatigam kanami na mallug da kaw bomarik adi sang donya aw mallug da domatung yang kataposan ng donya.” ");
INSERT INTO kqew_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tyomobag si Isa, laong nan, “Pagbantay kamo untak di kamo kalimbongan ng maskin sino. ");
INSERT INTO kqew_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kay madaig yang mga otaw na madatung sa kanak ngaan aw magalaong silan na, ‘Ako yang Almasi,’ aw madaig yang akalimbongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amadungug mayo na aon mga gira sang masaid kamayo aw adto oman sang mawat na mga banwa. Awgaid ayaw kamo pagkalluk kay dait na amaitabo yang kariko ninyan awgaid dili pa yani yang kataposan ng donya. ");
INSERT INTO kqew_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagdatowan mapaglaban adto sang kadaigan. Aw ama-aon yang gutum aw mga linog sang yagakatuna-tuna na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Awgaid yang kariko ninyan pagsogod pa gaid ng kasikotan na mag-onawa ng pagbati ng sambok na bobay sang pagpanganak. ");
INSERT INTO kqew_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ansinyan apandakupun aw adaun kamo adto sang mga pangoo untak kastigoon aw patayun kamo. Aw adumutan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqew_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sinyan na wakto madaig yang mga otaw na magatarikod sang pagpangintoo nilan kanak. Adumutan aw pagatraydoran nilan yang mga kaupudanan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aw madaig yang mga otaw na magalaong na mga nabi kono silan aw madaig yang akalimbongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na, sabap ng labi da yang pagsopak ng mga otaw sang mga sogowan ng Tohan, waa day looy ng kadaigan sang kapag-onawa nilan. ");
INSERT INTO kqew_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Awgaid sino-sino yang magapadayon ng pagpangintoo nan kanak sampay sang kataposan sini na mga kasikotan, amalowas. ");
INSERT INTO kqew_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aw yang Madyaw na Gogodanun makapantag sang pagdato ng Tohan ipayapat sang tibok donya untak yang kariko ng mga bangsa matigam. Pagkatapos sinyan madatung yang kataposan ng donya. ");
INSERT INTO kqew_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, sang madatung na mga allaw makita mayo na aon yakabutang adto sang sotti na logar na haram na makabatar sang Baay ng Tohan na mag-onawa ng pyagatagna ni Nabi Daniyal singaon. Aw sino-sino yang magabasa sini, sabota mayo yang mana nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na, pagkita mayo sinyan, yang mga otaw na adto sa Yahodiya, dait silan domaagan adto sang kabutayan. ");
INSERT INTO kqew_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yang otaw na adto sa logwa ng kanan baay, di dait somuud untak makamang pa sang maskin ono na butang nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aw yang otaw na adto sang pawa, di dait mori untak makamang pa ng dagom nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pagdatung sinyan na mga allaw, kallat sidtong mga mabdus aw sidtong mga yagapasoso kay mairapan silan domaagan. ");
INSERT INTO kqew_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Agaw, pagpangayo-ngayo kamo adto sang Tohan na di gao yan ama-inang sang wakto ng tingmaniki atawa sang Allaw ng Pagpatana. ");
INSERT INTO kqew_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kay sinyan na mga allaw labi da yang kasikotan na agian ng mga otaw. Sikun pa sang pagbaoy ng donya sampay adon waa pay main da nan na kasikotan, aw pagkatapos sinyan di da oman ama-inang yang mag-onawa sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na, kong madogay yang inyan na kasikotan, amatay da yang kariko ng mga otaw. Awgaid sabap sang looy ng Tohan sang mga otaw na pinili nan, di nan apadogayun. ");
INSERT INTO kqew_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na, sinyan na mga allaw, kong aon magalaong kamayo na, ‘Tanawa idi da yang Almasi,’ atawa ‘Adto sidto yan,’ ayaw kamo pagtoo kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kay aon madatung na mga otaw na magalaong na silan kono yang Almasi. Aw aon oman mga otaw na magalaong na mga nabi kono silan, awgaid dili yan ng bunna. Maga-inang silan ng maskin ono na tanda aw katingaan kay untak kong mapakay ma-ilad maskin yang mga pinili ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, timani mayo na pyagalaong da ta kamo sinyan sang wa pa yan aka-inang. ");
INSERT INTO kqew_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Agaw, kong aon magalaong kamayo na, ‘Tanawa, adto yang Almasi sang mamingaw na banwa,’ ayaw kamo pagkadto. Aw kong magalaong silan na, ‘Yagatago yan adi sa suud,’ ayaw oman kamo pagtoo sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kay kong mabarik ako na Anak ng Manosiya adi sang donya, makita yang pagdatung ko na mag-onawa ng kilat na yagasiga adto sang langit sikun sang silatan taman sang sallupan. ");
INSERT INTO kqew_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mag-onawa yan sang pasombingay na yagalaong, ‘Daw wain yang patay, adto magatipon yang mga banog.’ ");
INSERT INTO kqew_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na, pagkatapos sinyan na mga allaw ng kasikotan, “ ‘magkaduggum yang suga aw di da magasiga yang bowan. Mangkallog yang mga bitoon sikun sang langit aw yang kariko na adto sang langit amagayung.’ ");
INSERT INTO kqew_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ansinyan ama-aon adto sang langit yang tanda na madatung da ako na Anak ng Manosiya. Aw yang kariko ng mga bangsa adi sang donya magatiyao kong kitaun nilan ako na Anak ng Manosiya sikun sang mga gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqew_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aw ansinyan sang makusug na pagpa-oni ng trompita asogoon ko yang kanak mga malaikat sang opat ka pinidyowan ng donya untak tiponon nilan yang mga otaw na pinili ko sikun sang kariko ng mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, dumduma mayo yang kaoy na igira. Aw yamanaringsing da yang mga sanga sinyan na kaoy, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqew_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mag-onawa sinyan, pagkita mayo na ma-inang da yang kariko nini na pyagalaong ko kamayo, akatigaman mayo na mallug da ako magbarik adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sa bunna-bunna na ipaglaong ko kamayo na amatoman yang kariko ninyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqew_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Awgaid way otaw na yamatigam daw ono na allaw atawa ono na wakto ako mabarik. Maskin yang mga malaikat adto sa sorga aw maskin oman ako na Anak ng Tohan, wa akatigam. Yang Tohan da gaid na kanak Ama yang yamatigam sinyan. ");
INSERT INTO kqew_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na, yang ininang ng mga otaw sidtong wakto na mabarik ako na Anak ng Manosiya adi sang donya mag-onawa ng ininang ng mga otaw singaon sang panahon ni Nabi Noh. ");
INSERT INTO kqew_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kay sang wa pa pagalunup adi sang donya, way lain na kyaridowan ng mga otaw yatabiya yang pagkan, pag-inum aw pag-inasawaay taman sidtong wakto na syomuud si Nabi Noh sang dakowa na bangka. ");
INSERT INTO kqew_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na, wa silan akatigam na mallug da silan asapadan. Agaw pagdatung ng lunup, obos silan yamangka-umus. Na, mag-onawa sinyan yang kabutang ng mga otaw sang wakto na mabarik ako na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sidto na wakto, kong aon dowangka usug na yagagawbuk adto sang pawa, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqew_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kong aon dowangka bobay na yagalubuk ng omay, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqew_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Idto sagaw, pagbantay kamo kay wa mayo akatigami daw ono na allaw yang pagbarik ng kamayo Dato. ");
INSERT INTO kqew_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Awgaid dumduma mayo yani. Kong kyatigaman ng tagtomon ng baay daw ono na wakto ng gabi yang pagdatung ng kawatan, sa way dowa-dowa di yan matoog kondi magabantay yan untak yang kawatan di makasuud sang baay nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Agaw sagaw, dait kamo mag-andam kay mabarik ako na Anak ng Manosiya sang wakto na wa kamo pagadumdum na mabarik ako.” ");
INSERT INTO kqew_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ansinyan yagalaong si Isa sini na pasombingay, laong nan, “Yang sogowanun na kasarigan aw matigam maggawbuk, yan yang apiliun ng amo nan untak magdaa ng kadaigan pa na mga sogowanun sang baay. Aw yan da yang maga-atag kanilan ng kanilan pagkan sang insakto na wakto. ");
INSERT INTO kqew_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kadyaw ng ginawa ng sogowanun aw pag-ori ng amo nan adatungan yan na yaga-inang ng kanan gawbuk. ");
INSERT INTO kqew_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sa bunna-bunna na ipaglaong ko kamayo na isarig da kanan ng amo nan yang kariko ng mga kabutangan nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Awgaid kong maat yang idtong sogowanun, magalaong yan sang ginawa nan, ‘Ah, madogay pa mori yang amo ko!’ ");
INSERT INTO kqew_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tapos akolataun da nan yang mga kaupudanan nan na sogowanun aw abay gaid yan koman aw minum upud sang mga lasing. ");
INSERT INTO kqew_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na, ansinyan mori da yang amo nan sang wakto na wa nan akaniyat kay wa nan akatigami daw ono na allaw yang pagbarik nan. ");
INSERT INTO kqew_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ansinyan kastigoon da yan ng amo nan aw adto da yan ibutang sang adatungan ng mga otaw na yagapakita-kita gaid na yagapangagad silan sang Tohan. Adto da yan magatiyao aw mangolitub yang onto nan.” ");
INSERT INTO kqew_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ansinyan yagalaong oman si Isa ng tuna pa na pasombingay, laong nan, “Sang wakto ng pagbarik ko, yang pagdato ng Tohan mag-onawa ng sampoo na mga daaga na pyomanaw untak songonon nilan yang usug na akawinun. Yang matag-isa kanilan aon daa na ilawan. ");
INSERT INTO kqew_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na, sangu yang limangka otaw kanilan aw mangkatigam yang kadaigan na limangka otaw. ");
INSERT INTO kqew_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kay yang mga sangu yagadaa ng ilawan, awgaid wa silan pagadaa ng dogang pa na lana. ");
INSERT INTO kqew_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Awgaid yang mangkatigam, yagadaa silan ng ilawan kipat yang lasakanan na yamapono ng lana. ");
INSERT INTO kqew_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Adon, sabap ng yadogay yang pagdatung ng usug na akawinun yamatodtod da yang mga daaga aw yamangkatoog. ");
INSERT INTO kqew_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ansinyan pagkatungang gabi da aon yagapiyagit aw laong, ‘Idi da yang usug na akawinun! Adi da kamo aw songona mayo!’ ");
INSERT INTO kqew_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Pagdungug sinyan yagabangon dayon yang mga daaga aw dyayaw nilan yang siga ng ilawan nilan. ");
INSERT INTO kqew_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Adon, yaning mga sangu, yagalaong silan adto sang mga mangkatigam, ‘Atagi kami ng tagbis na lana mayo kay mallug da matay yang ilawan nami.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Awgaid tyomobag yang mga mangkatigam, ‘Di mapakay! Kay kong atagan ta kamo, mag-onawa da kita na akolangan ng lana. Madyaw pa aw magabili da gaid kamo ng lana adto sang tindaan.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ansinyan pyomanaw da yang mga daaga na sangu untak magbili ng lana. Pagpanaw nilan, dyomatung da yang usug na akawinun. Aw yang limangka otaw na daaga na yandam da yamagad kanan adto sang baay na aon pakaradyaan ng kawin. Pagsuud nilan sang baay, isiraan da yang powertaan. ");
INSERT INTO kqew_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wa akadogay sinyan dyomatung da yang kadaigan na mga daaga na yagabili ng lana aw yanagtawag silan, laong nilan, ‘Kay Dato, pasuuda kami.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Awgaid tyomobag yang usug, ‘Sa bunna-bunna, wa ako akilaa kamayo.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Agaw sagaw,” yagalaong si Isa, “pagbantay kamo kay wa mayo akatigami yang allaw atawa wakto ng pagbarik ko.” ");
INSERT INTO kqew_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yagalaong oman si Isa, “Yang pagdato ng Tohan mag-onawa ng sambok na otaw na mallug da pomanaw sang mawat na banwa. Tyawag nan yang kanan mga sogowanun aw syarigan nan silan ng kakawasaan nan. ");
INSERT INTO kqew_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pyangatagan nan yang matag-isa kanilan ng sapi na dait sang kanilan kagaga. Yang sangka otaw yatagan nan ng 5000, yang sangka otaw oman ng 2000, aw yang sangka otaw ng 1000. Pagkatapos sinyan pyomanaw da yan. ");
INSERT INTO kqew_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, yang sogowanun na yatagan ng 5000 pyomanaw dayon aw pyaganegosyo nan yang sapi aw yakaganansya ng 5000. ");
INSERT INTO kqew_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mag-onawa sinyan, yang sogowanun na yatagan ng 2000, yakaganansya ng 2000. ");
INSERT INTO kqew_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Awgaid yang sogowanun na yatagan ng 1000 pyomanaw aw yagakotkot ng longag kay tagoon nan sang lopa yang sapi ng amo nan. ");
INSERT INTO kqew_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagkatapos ng mataas na panahon yamori da yang amo nilan aw yosip nan silan daw ono yang ininang nilan sang sapi na yatag nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na, yang sogowanun na yatagan ng 5000 dyomood sang amo nan na yagadaa ng 5000 na ganansya nan. Yagalaong yan, ‘Kay Dato, yang yatag mo kanak na 5000, idi da, aw tanawa, aon pay tuna na 5000 na kanak ganansya.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yagalaong yang amo nan, ‘Madyaw yang ininang mo! Madyaw aw kasarigan kaw na sogowanun. Sabap ng kasarigan kaw sang tagbis na kakawasaan, isarig ta kammo yang madaig na kakawasaan. Karim ko na masowat kaw mag-onawa kanak.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Pagkatapos sinyan dyomood kanan yang sogowanun na yatagan ng 2000 aw yagalaong yan, ‘Kay Dato, yatagan mo ako ng 2000. Tanawa, aon pay tuna na 2000 na kanak ganansya.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yagalaong yang amo nan, ‘Madyaw yang ininang mo! Madyaw aw kasarigan kaw na sogowanun. Sabap ng kasarigan kaw sang tagbis na kakawasaan, isarig ta kammo yang madaig na kakawasaan. Karim ko na masowat kaw mag-onawa kanak.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ansinyan dyomatung yang sogowanun na yatagan ng 1000 aw yagalaong yan, ‘Kay Dato, yamatigam ako na maisug kaw na otaw. Kay akamangun mo yang wa mo pagapagodi, aw aganiun mo yang wa mo atanuma. ");
INSERT INTO kqew_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Agaw, sabap ng yamalluk ako daw basin akawaan ako ng kammo sapi, pyomanaw ako aw tyago ko yang sapi mo sang lopa. Tanawa, idi kay yang kammo sapi.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na, tyomobag yang amo nan, laong nan, ‘Way siyat mo! Mataka kaw na sogowanun! Yamatigam kaw kadi na akamangun ko yang wa ko pagapagodi, aw aganiun ko yang wa ko atanuma? ");
INSERT INTO kqew_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, kong maynan, nanga wa mo ooga sang bangko yang kanak sapi kay untak pagbarik ko amakamang ko yang sapi ko na aon pay tobo?’ ");
INSERT INTO kqew_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ansinyan yagalaong yan sang kadaigan na mga sogowanun nan, ‘Kamanga mayo yang sapi na iyan kanan aw atagan sidtong sogowanun na aon 10,000. ");
INSERT INTO kqew_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kay sino-sino yang kasarigan atagan kay untak kadogangan pa yang iyan kanan. Awgaid yang otaw na dili kasarigan, maskin yang tagbis na iyan kanan, akamangun pa. ");
INSERT INTO kqew_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aw yani na sogowanun na way siyat idami da mayo adto sa logwa, sang kadugguman. Adto da yan magtiyao aw mangolitub yang onto nan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ansinyan yagalaong oman si Isa, “Kong ako na Anak ng Manosiya mabarik da adi sang donya na yagadan ng kariko ng mga malaikat, amapayag yang dakowa na kabarakat aw kabantog ko. Kay mabarik ako adi untak magdato aw maghokom sang kariko ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na, ansinyan amatipon da sa atobangan ko yang kariko ng mga bangsa adi sang donya aw bainun ko yang mga otaw sang dowangka pondok na mag-onawa ng magbabantayay ng mga ayup na lainun nan yang mga karniro aw yang mga kambing. ");
INSERT INTO kqew_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yang mga otaw na yagapangagad kanak ibutang ko apit sang karinto ko, aw yang kadaigan ibutang ko apit sang kawaa ko. ");
INSERT INTO kqew_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ansinyan magalaong da ako na soltan nilan adto sang mga otaw apit sang karinto ko, laong ko, ‘Adi da kamo kay aon kadyawan mayo sikun sang Tohan na kanak Ama. Tarimaa da mayo yang pyagdatowan na pyagakahanda kamayo sikun pa sang pagbaoy ng donya. ");
INSERT INTO kqew_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kay sang wakto na yamagutum ako, yatagan mayo ako ng pagkan aw sang wakto na yamangga ako, pya-inum mayo ako. Aw pagkadto ko sang banwa mayo, pyapanaos mayo ako adto sang baay mayo. ");
INSERT INTO kqew_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nang way dagom ko, yatagan mayo ako ng dagom. Nang yamasakit ako, yatiman mayo ako. Aw nang yapiriso ako, binisitaan mayo ako.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ansinyan maga-osip yang matorid na mga otaw, laong nilan, ‘Kay Dato, kano pa kaw nami akitaa na yamagutum aw pyakan kaw nami atawa yamangga aw pya-inum kaw nami? ");
INSERT INTO kqew_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kano oman kaw nami akitaa na yagabisita kanami aw pyapanaos kaw nami? Atawa way dagom mo aw yatagan kaw nami ng dagom? ");
INSERT INTO kqew_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aw kano kaw nami akitaa na yamasakit atawa yapiriso aw binisitaan kaw nami?’ ");
INSERT INTO kqew_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ansinyan matobag ako na soltan nilan aw magalaong ako kanilan, ‘Sa bunna-bunna na ipaglaong ko kamayo daw ono yang ininang mayo sang mga otaw na yagapangagad kanak na maskin way siyat nilan, maynang ininang da mayo yan kanak.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagkatapos, magalaong da oman ako sang mga otaw apit sang kawaa ko, ‘Panawi mayo ako kay siniksa da kamo ng Tohan. Adto da kamo ibutang sang narka mag-onawa ng atoon na di amatay taman sa taman na pyagakahanda para kang Iblis aw yang sakop nan na mga saytan. ");
INSERT INTO kqew_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay sang wakto na yamagutum ako, wa mayo ako apakana. Nang yamangga ako, wa mayo ako apa-inuma. ");
INSERT INTO kqew_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pagkadto ko sang banwa mayo, wa mayo ako apapanaosa. Nang way dagom ko, wa mayo ako apapandagomi. Nang yamasakit aw yapiriso ako, wa mayo ako abisitai.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ansinyan maga-osip silan kanak, ‘Kay Dato, kano pa kaw nami akitaa na yamagutum atawa yamangga? Kano pa na wa kaw apapanaosa sang kanami baay atawa way dagom mo? Kano pa na yamasakit atawa yapiriso kaw aw wa kaw nami atabangi?’ ");
INSERT INTO kqew_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ansinyan matobag ako kanilan, ‘Sa bunna-bunna na ipaglaong ko kamayo na sang wa mayo atabangi yang pinakababa sang mga inindowan ko, maynang wa oman mayo ako atabangi.’ ");
INSERT INTO kqew_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na, yani na mga otaw, apakadtonon silan adto sang narka aw siksaun silan taman sa taman. Awgaid idtong matorid na mga otaw, amasorga silan aw atagan silan ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos ni Isa mag-indo sang kariko ninyan, yagalaong yan sang mga inindowan nan, ");
INSERT INTO kqew_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kyatigaman mayo na dowang allaw dakoman aw madatung da yang Pakaradyaan ng Paglabay. Sinyan na wakto adakupun da ako na Anak ng Manosiya untak ilansang adto sa kros.” ");
INSERT INTO kqew_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, sarta yagalaong si Isa ninyan, yanagkatipon yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi adto sang baay ni Kayapas na yan yang Dakowa na Imam. ");
INSERT INTO kqew_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa na di akatigaman ng mga otaw aw monono yang pagpatay kanan. ");
INSERT INTO kqew_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yagalaong silan, “Di gaid natun yani inangun sang wakto ng pakaradyaan kay basin magakasamok yang mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ansinyan sarta adto sang longsod ng Bitani sang Isa, kyomadto silan sang baay ni Simon, yang otaw na sanglaun singaon. ");
INSERT INTO kqew_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nang yanagkan silan, aon dyomatung na bobay na yagadaa ng tagbi na lasakanan na ininang ng bato na alabastro na yamapono ng paballo na labi na mahalaga. Ansinyan dyomood yan kang Isa aw obowi nan ng paballo yang oo nan. ");
INSERT INTO kqew_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkita sinyan ng mga inindowan ni Isa, yadaman silan aw yagalaong silan, “Kanogon ninyan na paballo! ");
INSERT INTO kqew_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Madyaw pa aw byarigya inyan ng dakowa na kantidad aw yang alin i-atag adto sang mga miskinan.” ");
INSERT INTO kqew_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na, kyatigaman ni Isa daw ono yang pyagabaawan nilan, agaw yagalaong yan kanilan, “Nanga pyagakasamok mayo yani na bobay? Madyaw yang ininang nan kanak. ");
INSERT INTO kqew_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kay yang mga miskinan abay mayo kaupud, awgaid ako, di ako magapabilin adi kamayo. ");
INSERT INTO kqew_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yabowan nan ako ng paballo untak andamun nan yang kanak lawas sang kanak paglubung. ");
INSERT INTO kqew_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa bunna-bunna na ipaglaong ko kamayo na maskin wain adi sining donya ipayapat yang Madyaw na Gogodanun, amagogod oman yani na ininang nan silbi tadumanan kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pagkatapos sinyan, si Yodas Iskariyot na sambok sang sampoo aw dowa na sahabat ni Isa, kyomadto yan sang mga pangoo ng mga imam ");
INSERT INTO kqew_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aw yagalaong yan kanilan, “Pila yang i-atag mayo kanak kong ipagtraydor ko kamayo si Isa?” Na, yabayadan dayon nilan yan ng 30 ka bok na sapi na pilak. ");
INSERT INTO kqew_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aw sikun sinyan yagapanganap da si Yodas ng madyaw na wakto na ipadakup kanilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ansinyan pagdatung ng pukas na allaw ng Pakaradyaan ng Pan na way Labadora, dyomood kang Isa yang mga inindowan nan aw yaga-osip silan, “Wain yang karim mo na andamun nami yang kanatun pagkan para sang Pakaradyaan ng Paglabay?” ");
INSERT INTO kqew_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tyomobag si Isa, “Kadto kamo sang syodad aw paglaonga mayo yang otaw na makita mayo ansan na ‘Yagalaong yang kanami goro na masaid da yang wakto na pyagakahanda kanan ng Tohan. Magakandori da yan ansan sang kammo baay para sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ansinyan tyoman da ng mga inindowan yang sogo kanilan ni Isa aw pyaga-andam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqew_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkagabi sinyan yamingkod si Isa sang lamisa upud sang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqew_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sarta yanagpangan silan, yagalaong si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na aon sangka otaw kamayo na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na, labi da yang karido nilan aw yang matag-isa kanilan yaga-osip kanan, “Kay Dato, ako ba yang pyagalaong mo?” ");
INSERT INTO kqew_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tyomobag si Isa, “Yang sangka otaw kamayo na yagadarit ng pan sang ladya upud kanak, yan yang magatraydor kanak. ");
INSERT INTO kqew_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amatay ako na Anak ng Manosiya mag-onawa ng yakasorat sang Kitab. Awgaid kallat ng otaw na magatraydor kanak. Madyaw pa kong wa yan akaotaw.” ");
INSERT INTO kqew_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ansinyan yaga-osip kanan si Yodas na yan yang magatraydor kanan, “Kay Goro, ako ba yang pyagalaong mo?” Tyomobag si Isa, “Na, pyagalaong da mo.” ");
INSERT INTO kqew_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Adon, sarta yanagpangan pa silan, kyomamang si Isa ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga inindowan nan aw laong nan, “Dawata mayo yani aw kana mayo kay yani yang kanak lawas.” ");
INSERT INTO kqew_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ansinyan kyomamang yan ng inumanan aw pagkatapos manginsokor sang Tohan yatag nan kanilan aw laong nan, “Inuma mayo yani, obos mayo. ");
INSERT INTO kqew_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kay yani yang kanak dogo na yaga-atag ng kasigorowan sang pyagapasadan na ininang ng Tohan sang manosiya. Maboos yang kanak dogo untak ma-ampon yang madaig na mga otaw sikun sang mga dosa nilan. ");
INSERT INTO kqew_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ipaglaong ko kamayo na sikun adon di da ako minum nining tumuk ng grips taman sang wakto na minum da ako ng bago na inmanun upud kamayo adto sang pyagdatowan ng kanak Ama.” ");
INSERT INTO kqew_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagkatapos sinyan, yanagkanta silan ng pagpoji adto sang Tohan aw kyomadto da silan sang Butay ng Jayton. ");
INSERT INTO kqew_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ansinyan yagalaong si Isa sang mga inindowan nan, “Adon na gabi magadaagan yang kariko mayo sabap kanak aw mabiya kamo kanak. Kay aon yakasorat sang Kitab na yagalaong, “ ‘Ipapatay ng Tohan yang magbabantayay ng mga karniro, aw ansinyan magakanat-kanat da yang mga karniro.’ ");
INSERT INTO kqew_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Awgaid,” laong ni Isa, “pagkatapos ko mabowi oman ama-ona ako kamayo adto sa Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ansinyan yagalaong si Pitros kang Isa, “Maskin abiyaan kaw ng kariko nilan, awgaid ako, di ako mabiya kammo.” ");
INSERT INTO kqew_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yagalaong kanan si Isa, “Sa bunna-bunna na ipaglaong ko kammo na sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw akilaa kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Awgaid yagalaong oman si Pitros, “Di ako magalaong na wa ta kaw akilaa maskin pa apatayun ako upud kammo.” Na, maynan oman yang pyaglaongan ng kadaigan na mga inindowan. ");
INSERT INTO kqew_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ansinyan kyomadto si Isa aw yang mga inindowan nan sang sambok na tanumanan na tyawag ng Gitsimani. Pagdatung nilan ansan, yagalaong si Isa sang mga inindowan nan, “Pag-ingkod kamo ansini sarta magadowaa ako adto sang onaan.” ");
INSERT INTO kqew_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tapos, pyaga-agad nan si Pitros aw yang dowangka otaw na mga anak ni Sibidi. Ansinyan yamarido da yang ginawa ni Isa aw mabugat yang pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Laong nan kanilan, “Labi da yang karido ng ginawa ko na maynang amatay da ako. Ansini da gaid kamo aw ayaw kamo pagkatoog. Pagbantay kamo upud kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ansinyan kyomadto si Isa sang onaan aw syomojod yan sang lopa kay magadowaa. Laong nan, “O kay Ama, aw mapakay, ayaw pagtogoti na amagi ako sini na madatung na kasikotan. Awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqew_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ansinyan byomarik yan adto sang toongka otaw na mga inindowan nan aw yadatungan nan silan na yamangkatoog. Pyokaw nan silan aw yagalaong yan kang Pitros, “Nanga, wa kamo pakabantay upud kanak na maskin sangka oras da gaid? ");
INSERT INTO kqew_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pagbantay aw pagdowaa kamo untak di kamo madaa ng sasat. Sa suud ng pangatayan mayo karim mayo magpangagad sang Tohan, awgaid sabap ng maomay yang lawas mayo madari kamo madaa ng sasat.” ");
INSERT INTO kqew_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ansinyan pyomanaw da oman si Isa aw yagadowaa da oman yan. Laong nan, “O kay Ama, kong kinaanglan na amagi ako sini na kasikotan, yang karim mo yang amatoman.” ");
INSERT INTO kqew_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagkatapos, byomarik da oman yan sang mga inindowan nan aw kinita nan na yamangkatoog da oman silan kay labi da yang katodtod nilan. ");
INSERT INTO kqew_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ansinyan pyomanaw da oman yan aw yagadowaa yan ng ikatoo na maynan oman yang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapos magdowaa, byomarik da oman yan sang mga inindowan nan aw yagalaong yan kanilan, “Yabay pa gaid kamo matoog aw magpatana? Osto da kay dyomatung da yang wakto na adakupun ako na Anak ng Manosiya ng baradosa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Unda, bangon da kamo kay mapanaw da kita. Idi da yang otaw na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nang yagalaong pa si Isa, dyomatung si Yodas na sambok sang sampoo aw dowa na mga sahabat. Madaig yang mga otaw na yaga-upud kanan na aon daa na mga lodyo aw mga bobonal. Syogo silan ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, pyagalaong silan dadaan ni Yodas na yan yang magatraydor kang Isa daw ono yang inangun nan silbi tanda kanilan. Laong nan, “Yang otaw na aukan ko, yan yang pyaga-anap mayo. Dakupa da mayo.” ");
INSERT INTO kqew_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Agaw pagdatung ni Yodas, dyomood dayon yan kang Isa aw maglaong, “Assalamo alaykom, kay Goro.” Aw yaukan nan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yagalaong kanan si Isa, “Kay lagi, inanga da yang kyakanian mo.” Ansinyan dyomood kang Isa yang kadaigan na mga otaw aw dakupa nilan. ");
INSERT INTO kqew_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, isa sang mga kaupudanan ni Isa yagagabot ng lodyo aw tibasa nan yang sogowanun ng Dakowa na Imam aw ya-otod yang sangkilid na taringa nan. ");
INSERT INTO kqew_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yagalaong kanan si Isa, “Barikan yang lodyo mo sang tagob kay yang magagamit ng lodyo, lodyo oman yang makamatay kanan. ");
INSERT INTO kqew_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wa mo kadi akatigami na makapangayo ako ng tabang sang kanak Ama aw ansinyan apadaan nan ako ng libo-libo na mga malaikat? ");
INSERT INTO kqew_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Awgaid kong inangun ko yan, monono da yang pagtoman sang yakasorat sang Kitab na yagalaong na dait ma-inang yang kariko nini?” ");
INSERT INTO kqew_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ansinyan yagalaong si Isa sang mga otaw, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng lodyo aw bobonal sang pagdakup mayo kanak? Matag allaw adto ako maga-ingkod sang Baay ng Tohan aw yaga-indo, awgaid wa mayo ako adakupa. ");
INSERT INTO kqew_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Awgaid yamaitabo yang kariko nini untak matoman yang syorat ng mga nabi sang Kitab.” Ansinyan yagabiya kanan yang kariko ng mga inindowan nan aw yanagdaagan silan. ");
INSERT INTO kqew_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pagkatapos sinyan dyaa si Isa nidtong mga otaw na yagadakup kanan adto sang baay ni Kayapas na yan yang Dakowa na Imam. Yanagkatipon ansan yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na, si Pitros, yasonod yan kang Isa awgaid sang mawat-awat gaid taman sang pamanag ng baay ng Dakowa na Imam. Ansinyan syomuud yan sang pamanag aw yamingkod upud sang mga gowardya untak katigaman nan daw ono yang akatamanan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yang mga pangoo ng mga imam aw yang kariko ng mga opisyales sang Hokomanan ng mga Yahodi, yagapanganap silan ng ebidensya na maskin dili ng bunna untak ma-akosar aw mapatay nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Awgaid way kinita nilan na dosa maskin madaig yang kyomaon kanilan aw yagalaong ng dili ng bunna makapantag kanan. Awgaid sang orian aon dowangka otaw ");
INSERT INTO kqew_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na yagalaong, “Yani na otaw yagalaong na mapakay nan gubaun yang Baay ng Tohan aw apa-indugun oman nan sa suud ng toong allaw.” ");
INSERT INTO kqew_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ansinyan yamindug yang Dakowa na Imam aw yagalaong yan kang Isa, “Ono yang ikatobag mo sini na mga otaw na yagasombong kammo?” ");
INSERT INTO kqew_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Awgaid wa atobag si Isa. Ansinyan yagalaong kanan yang Dakowa na Imam, “Paglaonga kami sa atobangan ng bowi na Tohan daw ikaw ba yang Almasi na Anak ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tyomobag kanan si Isa, “Pyagalaong da mo. Awgaid ipaglaong ko sang kariko mayo na sang madatung na mga allaw makita mayo ako na Anak ng Manosiya na yaga-ingkod apit sang karinto ng Tohan na Labi na Mabarakat. Aw makita oman mayo na mabarik ako adi sang donya sikun sang langit na pyagalibotan ng gabon.” ");
INSERT INTO kqew_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagdungug sinyan ng Dakowa na Imam, lyasi nan yang kanan dagom sabap sang kadaman nan aw laong nan, “Astaga! Yagalaong yan na mag-onawa kono yan sang Tohan! Di da kita kinaanglan ng kadaigan pa na saksi. Dyungug da mayo adon yang kanan pyaglaongan na mag-onawa kono yan sang Tohan! ");
INSERT INTO kqew_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, ono da yang hokom mayo?” Tyomobag yang kariko ng mga pangoo aw laong nilan, “Yakadosa yan aw dait yan patayun.” ");
INSERT INTO kqew_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ansinyan tyobadan nilan yang parangay ni Isa aw sontoka nilan. Aon oman kadaigan na yagasampal kanan ");
INSERT INTO kqew_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aw yagalaong silan, “Kong ikaw yang Almasi, paglaonga kami daw sino yang yagasampal kammo!” ");
INSERT INTO kqew_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ansinyan sarta yaga-ingkod si Pitros adto sang pamanag, dyomood kanan yang sambok na sogowanun na bobay aw yagalaong yan, “Ikaw inagad oman ni Isa na taga Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Awgaid yagadili sinyan si Pitros sa atobangan ng kariko ng mga otaw aw laong nan, “Wa ako akatigam daw ono yang pyagalaong mo.” ");
INSERT INTO kqew_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagkatapos kyomadto yan sang powertaan ng pamanag aw yakakita kanan yang sambok oman na sogowanun na bobay aw yagalaong yan sang mga otaw na yaga-indug, “Yani na otaw, inagad ni Isa na taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Awgaid yagadili oman si Pitros. Yagasapa yan aw laong nan, “Wa ako akilaa sinyan na otaw!” ");
INSERT INTO kqew_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagkatugun-tugun sinyan dyomood kanan yang mga otaw na yaga-indug ansan aw laong nilan, “Bunna sagaw na kaupudanan kaw nilan kay makilaa sang tono ng kammo pyaglaongan na ikaw taga Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ansinyan yagasapa oman si Pitros aw laong nan, “Asiksaun ako ng Tohan kong di ako maglaong ng bunna. Wa ako akilaa sinyan na otaw!” Na, sinyan na wakto yagatagaok yang laboyo. ");
INSERT INTO kqew_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ansinyan kyadumduman ni Pitros yang pyagalaong kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo, makatoo kaw maglaong na wa kaw akilaa kanak.” Na, lyomogwa da si Pitros aw bali na pagtiyao nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaamdag ng masuum pa yanagkatipon yang kariko ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yanagka-oyon silan na dait patayun si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ansinyan gyapos nilan si Isa aw dyaa nilan adto kang Pilato na gobirnador na taga Roma. ");
INSERT INTO kqew_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Adon, pagkatigam ni Yodas na yan yang yagatraydor kang Isa na pyagahokom da si Isa na apatayun, yagabasul yan sang ininang nan aw ori nan yang 30 ka bok na sapi na pilak adto sang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yagalaong yan kanilan, “Yakadosa ako kay pyagatraydoran ko yang otaw na way dosa.” “Na, way labot nami san. Bahala da kaw,” yang tobag nilan. ");
INSERT INTO kqew_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ansinyan dyami ni Yodas yang sapi adto sa suud ng Baay ng Tohan aw panaw. Lyomogwa yan, yagatali ng lobid sang liyug nan aw yagatoyo. ");
INSERT INTO kqew_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ansinyan pyoti ng mga pangoo ng mga imam yang sapi aw laong nilan, “Sopak sang Hokoman na ioog yani na sapi sang butanganan ng sapi adto sang Baay ng Tohan kay bayad yani sang kinabowi ng sambok na otaw.” ");
INSERT INTO kqew_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ansinyan yanagka-oyon silan na agamitun nilan yang sapi sang pagbili ng lopa ng tig-inang ng koon kay untak inangun nilan ng pangkoboran ng mga dayo. ");
INSERT INTO kqew_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sabap sinyan tyawag yan na lopa ng “Lopa ng Dogo” taman adon. ");
INSERT INTO kqew_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na, ansinyan yatoman yang pyaglaongan ni Nabi Irimiyas na yakasorat sang Kitab, laong nan, “Kyamang nilan yang 30 ka bok na sapi na pilak na pyagasabotan ng mga otaw na bangsa Israil sang pagbayad kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aw gyamit nilan yan na sapi sang pagbili ng lopa ng tig-inang ng koon mag-onawa ng pyagalaong kanak ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Adon, iyan da si Isa sa atobangan ni Gobirnador Pilato aw yosip yan ng gobirnador, laong nan, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag si Isa, “Pyagalaong da mo.” ");
INSERT INTO kqew_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Awgaid nang yagasombong kanan yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, wa yan atobag. ");
INSERT INTO kqew_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Agaw yagalaong kanan si Pilato, “Wa kaw pakadungug sang pyagasombong nilan kammo? Nanga di kaw matobag?” ");
INSERT INTO kqew_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Awgaid nunka na wa atobag si Isa. Agaw bali na pagkatingaa ng gobirnador. ");
INSERT INTO kqew_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, matag Pakaradyaan ng Paglabay yang kya-anadan ng gobirnador na palogwaun nan yang sangka otaw na piniriso daw sino yang pyangayo ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, sidto na wakto aon bantoganun na piniriso na pyagangaanan kang Barabas. ");
INSERT INTO kqew_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ansinyan nang yanagkatipon yang mga otaw, yaga-osip kanilan si Pilato, “Sino yang karim mayo na apalogwaun ko, si Barabas atawa si Isa na tyawag ng Almasi?” ");
INSERT INTO kqew_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Idto yang osip nan kay kyatigaman nan na dyaa kanan si Isa ng mga pangoo ng mga Yahodi sabap ng yamasina silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ansinyan sarta yaga-ingkod si Pilato sang ingkodanan ng maghohokom aon pyagatogon kanan ng kanan asawa na laong nan, “Ayaw pagpangilabot sinyan na otaw na way dosa. Kay sa tagaynup ko komang gabi maat yang byati ko sabap kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Awgaid yang ininang ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, pyagalaong nilan yang mga otaw na si Barabas yang apangayoon nilan na aboyan aw ipapatay si Isa. ");
INSERT INTO kqew_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ansinyan yaga-osip oman kanilan si Gobirnador Pilato, “Sino kanilan dowa yang karim mayo na aboyan ko?” Tyomobag silan, “Si Barabas!” ");
INSERT INTO kqew_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yagalaong kanilan si Pilato, “Kong maynan, ono yang inangun ko kang Isa na tyawag ng Almasi?” Yagalaong da yang kariko nilan, “Ilansang yan sa kros!” ");
INSERT INTO kqew_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Nanga? Ono yang dosa na ininang nan?” yaga-osip da oman si Pilato. Awgaid pyakusug pa nilan yang tingug aw laong nilan, “Ilansang yan sa kros!” ");
INSERT INTO kqew_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagkita ni Pilato na waa day ma-inang nan aw masaid da magkasamok yang kaotawan, kyomamang yan ng tobig aw yamangonaw sa atobangan ng mga otaw aw laong nan, “Way labot ko sang kamatayun sini na otaw. Kamo da yang bahala.” ");
INSERT INTO kqew_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tyomobag yang kariko ng mga otaw, “Kami aw yang kanami mga topo amanobag sang pagpatay kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagkatapos sinyan byoyan ni Pilato si Barabas adto kanilan. Awgaid si Isa, pyabadasan nan aw yatag nan sang mga sondao untak ilansang da nilan sa kros. ");
INSERT INTO kqew_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ansinyan dyaa si Isa ng mga sondao adto sa suud ng palasyo ng gobirnador aw pyatawag nilan yang kariko ng kasondaowan. ");
INSERT INTO kqew_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ansinyan lyobasan nilan si Isa ng dagom aw syoogan ng joba na mapowa. ");
INSERT INTO kqew_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tapos, yaga-inang silan ng korona sikun sang mga sanga ng kaoy na soksokon aw byutang nilan sang oo nan. Pyatakmagan nilan sang karinto na arima nan ng kaoy silbi tanda ng pagkasoltan. Lyomood silan sa atobangan nan aw pyagasangu-sangu nilan na laong nilan, “Mabowi yang soltan ng mga Yahodi!” ");
INSERT INTO kqew_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ansinyan tyobadan nilan si Isa aw kyamang da oman nilan yang kaoy na tyakmagan nan aw byonalan nilan yang oo nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos nilan sangu-sanguun si Isa, lyobasan nilan ng joba na mapowa aw syoogan da oman ng kanan dagom. Ansinyan dyaa nilan yan adto sa logwa untak ilansang da nilan sa kros. ");
INSERT INTO kqew_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Paglogwa nilan sikun sang syodad, aon syongon nilan na otaw na pyagangaanan kang Simon na taga Kirini. Pyugus yan ng mga sondao pagpusan sang kaoy na pagalansangan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagdatung nilan sang logar na tyawag ng Golgota na yang mana nan Logar ng Oo ng Kalabira, ");
INSERT INTO kqew_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pya-inum nilan si Isa ng bino na dyarian ng mapait. Awgaid pagkatilaw nan sinyan, wa nan inuma. ");
INSERT INTO kqew_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ansinyan lyansang da nilan si Isa sa kros. Pagkatapos san, yanagripa silan untak bainun nilan yang mga dagom nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tapos, yamingkod silan aw yagabantay silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adto sa taas ng oo ni Isa aon byutang nilan na karatola na syoratan ng pyagasombong kang Isa na yagalaong, “Yani si Isa, yang Soltan ng mga Yahodi.” ");
INSERT INTO kqew_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aon oman dowangka otaw na tolisan na lyansang sa kros dungan kang Isa, yang sambok sang karinto nan aw yang sambok sang kawaa nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na, yang mga otaw na yalabay ansan yaga-uung-uung aw ininsolto nilan si Isa, laong nilan, ");
INSERT INTO kqew_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yagalaong kaw na agubaun mo yang Baay ng Tohan aw apa-indugun da mo oman sa suud ng toong allaw. Kong bunna na ikaw yang Anak ng Tohan, lowasa yang ginawa mo aw panaog dosang kros.” ");
INSERT INTO kqew_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mag-onawa sinyan pyagasangu-sangu yan ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman kipat yang mga pangoo ng mga Yahodi. Laong nilan, ");
INSERT INTO kqew_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tyabangan nan yang kadaigan, awgaid di yan makalowas sang ginawa nan! Di ba yan yang soltan ng bangsa Israil? Na, kong makapanaog yan adon sikun sa kros, amangintoo da kami kanan! ");
INSERT INTO kqew_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yasarig yan sang Tohan aw yagalaong yan na Anak kono yan ng Tohan. Na, tanawon ta adon kong alowasun yan ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na, maskin yang dowangka otaw na tolisan na lyansang sa kros dungan kang Isa, yamanginsolto silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nang alas dose yang suga yagkaduggum yang tibok banwa taman ng alas tres. ");
INSERT INTO kqew_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pagka-alas tres ng ambong, yagapiyagit si Isa aw laong nan, “Iloy, Iloy, lama sabaktani?” na yang mana nan “Ya Tohan ko, ya Tohan ko, nanga pyabayaan mo ako?” ");
INSERT INTO kqew_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pagdungug sinyan ng mga otaw na yanag-indug ansan, yagalaong silan, “Tyawag nan si Nabi Iliyas.” ");
INSERT INTO kqew_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ansinyan dyomaagan dayon yang sambok na otaw aw kyomamang yan ng ispongha aw tuguma nan sang magsing na bino. Tapos, byutang nan sang kaoy aw diwian adto kang Isa untak masupsup nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Awgaid yagalaong yang kadaigan, “Tagad, kay tanawon ta daw madatung si Nabi Iliyas untak maglowas kanan.” ");
INSERT INTO kqew_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pagkatapos sinyan yagapiyagit si Isa aw yamabogto da yang napas nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na, sidto na wakto yang madakmuu na kortina adto sang Baay ng Tohan yamalasi sang tunga sikun sa taas pababa. Yamagayung yang lopa aw yamapiyak yang mangkadakowa na mga bato. ");
INSERT INTO kqew_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yamaboka yang mga kobor aw madaig yang mga patay na mga otaw ng Tohan na yabowi oman. ");
INSERT INTO kqew_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lyomogwa silan sikun sang kobor aw pagkatapos mabowi oman ni Isa kyomadto silan sa Awrosalam, yang sotti na syodad. Madaig yang mga otaw na yakakita kanilan. ");
INSERT INTO kqew_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, yang kapitan aw yang mga kaupudanan nan na mga sondao na yagabantay kang Isa, pagbati nilan sang linog aw pagkita nilan sang kariko ng kyatamanan, yasaot silan ng alluk aw laong nilan, “Bunna sagaw na Anak yan ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na, madaig oman ansan yang mga kaobayan na yanagtanaw sidto na yamaitabo sikun sang mawat. Silan yang mga bobay na yamagad kang Isa sikun pa sa Jalil aw yaga-atiman kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaupud nilan si Mariyam na taga Magdala, si Mariyam na ina ni Yakob aw ni Yosis, aw yang asawa ni Sibidi. ");
INSERT INTO kqew_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagkasilum sinyan dyomatung yang sambok na sapian na taga Arimatiya. Yang ngaan nan si Yosop aw inagad oman yan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kyomadto yan kang Pilato aw pyangayo nan yang patay na lawas ni Isa. Ansinyan yagasogo si Pilato na i-atag kanan. ");
INSERT INTO kqew_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na, kyamang da ni Yosop yang lawas ni Isa aw byalot nan ng bago na sapot na mapoti. ");
INSERT INTO kqew_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pagkatapos, byutang nan sang bago na kobor na pyalongagan nan sang bato silbi pangkoboran sang sarili nan. Ansinyan pyagaligid nan yang dakowa na bato sang baba ng kobor untak matabonan aw pyomanaw. ");
INSERT INTO kqew_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na, si Mariyam na taga Magdala aw yang sambok oman na Mariyam yaga-ingkod ansan na yaga-atobang sang kobor. ");
INSERT INTO kqew_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagka-ilaw sinyan na Allaw ng Pagpatana, kyomadto kang Pilato yang mga pangoo ng mga imam aw yang mga Parisi. ");
INSERT INTO kqew_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pagdatung nilan, yagalaong silan kang Pilato, “Kay Gobirnador, kyadumduman nami na sang bowi pa idtong limbongon na otaw yagalaong yan na amabowi oman yan sang ikatoo na allaw sikun sang pagkamatay nan. ");
INSERT INTO kqew_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Idto sagaw, madyaw pa aw pabantayan mo yang kobor nan taman sa ikatoo na allaw kay basin makadto yang mga inindowan nan aw kawatun nilan yang patay na lawas nan. Pagkatapos, pagalaongon nilan yang mga otaw na yabowi oman si Isa. Na, yan na bakak, labaw pa yang kaatan ninyan kaysang ona na bakak na yan kono yang Almasi.” ");
INSERT INTO kqew_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Pagkamang da gaid kamo ng mga sondao,” yang tobag kanilan ni Pilato, “aw pabantayan mayo ng madyaw yang kobor nan.” ");
INSERT INTO kqew_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na, kyomadto da silan sang kobor aw byutangan nilan ng silyo yang dakowa na bato na yakatabon sang baba ng kobor untak katigaman kong aon mangilabot sinyan. Aw pyabantayan nilan yang kobor sang mga sondao. ");
INSERT INTO kqew_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkatapos ng Allaw ng Pagpatana nang masaid da somilat yang suga ng allaw ng Domingo, kyomadto sang kobor ni Isa si Mariyam na taga Magdala aw yang sambok oman na Mariyam untak tanawon nilan. ");
INSERT INTO kqew_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ansinyan yagalinog ng makusug kay aon malaikat ng Tohan na yagasikun sa sorga. Kyomadto yan sang kobor aw pyagaligid nan yang dakowa na bato na yakatabon sang baba sinyan aw pyaga-ingkodan nan. ");
INSERT INTO kqew_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Makasilaw yang parangay nan na mag-onawa ng kilat aw labi na mapoti yang dagom nan. ");
INSERT INTO kqew_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pagkita kanan ng mga gowardya, tyakigan silan ng alluk aw yasiling silan ng patay. ");
INSERT INTO kqew_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ansinyan yagalaong yang malaikat sang mga bobay, “Ayaw kamo pagkalluk. Yamatigam ako na yanap mayo si Isa na pyalansang sa kros. ");
INSERT INTO kqew_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa da yan adi kay yabowi oman yan mag-onawa ng pyagalaong nan. Adi kamo aw tanawa mayo yang pyagabutangan kanan. ");
INSERT INTO kqew_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, kallug da kamo panaw aw paglaonga mayo yang mga inindowan nan na yabowi oman yan. Ama-ona yan kanilan adto sa Jalil aw adto da nilan yan akitaun. Na, timani mayo yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ansinyan yomapas-apas silan manaw sikun sang kobor. Yangkalluk silan awgaid dakowa oman yang kasowat nilan. Aw dyomaagan da silan untak paglaongon nilan yang mga inindowan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na, sakadyap syongon silan ni Isa aw laong nan kanilan, “Assalamo alaykom!” Ansinyan dyomood silan kang Isa aw syomojod silan sa atobangan nan na yagatakmag sang siki nan. ");
INSERT INTO kqew_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yagalaong si Isa kanilan, “Ayaw kamo pagkalluk. Panaw da kamo aw paglaonga mayo yang mga kalomonan ko na makadto silan sa Jalil. Adto da nilan ako akitaun.” ");
INSERT INTO kqew_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, pagpanaw ng mga bobay, pyomanaw oman yang kadaigan ng mga sondao na yagabantay sang kobor aw kyomadto silan sa Awrosalam untak patigamun nilan yang mga pangoo ng mga imam ng kariko ng yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ansinyan yanagkatipon da yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yanagbaaw-baaw silan daw ono yang inangun nilan. Pagkatapos, yatagan nilan yang mga sondao ng madaig na sapi ");
INSERT INTO kqew_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aw paglaonga nilan, “Paglaonga mayo yang mga otaw na sang tungang gabi dyomatung yang mga inindowan ni Isa aw kyawat nilan yang kanan lawas sarta yatoog kamo. ");
INSERT INTO kqew_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aw madungug yani ng gobirnador, ayaw kamo pagkarido kay kami da yang matigam maglaong kanan untak di kamo ma-ono.” ");
INSERT INTO kqew_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Agaw dyawat da ng mga sondao yang sapi aw tyoman nilan yang pyagasogo kanilan. Na, yani na gogodanun pyangintowan ng mga Yahodi sampay adon. ");
INSERT INTO kqew_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Adon, yang sampoo aw isa na mga sahabat ni Isa, kyomadto da silan sa Jalil, adto sidtong butay na pyagalaong kanilan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkita nilan kanan, syomojod silan aw pyagasambayangan nilan yan. Awgaid aon oman pilangka otaw kanilan na yagadowa-dowa pa. ");
INSERT INTO kqew_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ansinyan dyomood kanilan si Isa aw yagalaong yan, “Yatag kanak yang kariko ng kapatot sang pagdato adi sang donya aw adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Agaw sagaw, kadto da kamo sang kariko ng mga bangsa adi sa babawan ng donya aw paglaonga mayo yang mga otaw ng makapantag kanak. Sogbowi silan sa ngaan ng Ama, sa ngaan ng Anak aw sa ngaan ng Nyawa ng Tohan aw indowi mayo silan na atomanun nilan yang kariko ng pyagasogo ko kamayo. Aw ansinyan ma-inang silan ng mga inindowan ko. Aw timani mayo na abay ako mag-upud kamayo taman sang kataposan ng donya.” Wassalam");
INSERT INTO kqew_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yani yang pagsogod ng Madyaw na Gogodanun makapantag kang Isa Almasi na Anak ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aon syorat ni Nabi Isayas sang Kitab na yagalaong yang Tohan, laong nan, “Apa-onaun ko kammo yang sogowanun ko untak andamun nan yang agianan mo. ");
INSERT INTO kqew_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aon sangka otaw na manawag-tawag adto sa kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ansinyan, mag-onawa ng yakasorat sang Kitab, dyomatung da si Yahiya aw yagasogbo yan sang mga otaw adto sa kamingawan. Yaga-osiyat yan adto kanilan aw laong nan, “Pagtawbat kamo aw biyai yang mga dosa mayo aw pagpasogbo kamo silbi tanda ng pagtawbat mayo untak amponon ng Tohan yang mga dosa mayo.” ");
INSERT INTO kqew_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na, madaig yang mga otaw na kyomadto kanan sikun sang kariko ng mga banwa na sakop ng Yahodiya aw sikun oman sang syodad ng Awrosalam. Yagagogod silan sang mga dosa nilan aw yagapasogbo silan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yang dagom ni Yahiya ininang sikun sang boboo ng kamil aw yang sintoron nan ininang ng paris ng ayup. Yang pagkan nan mga doon aw duga. ");
INSERT INTO kqew_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aw yani yang pyaga-osiyat nan sang mga otaw, laong nan, “Aon otaw na masonod kanak domatung na labaw pa kanak. Maskin yang pag-obad ng liston ng sandalyas nan di dait kanak. ");
INSERT INTO kqew_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ako, tobig yang pyagasogbo ko kamayo, awgaid yang pagasogbo nan kamayo yang Nyawa ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sidto na wakto dyomatung si Isa sikun sang banwa ng Nasarit na sakop ng Jalil, aw yagapasogbo yan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqew_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na, pagsaka ni Isa sikun sang tobig, kinita nan na yagaboka yang langit aw yakunsad adto kanan yang Nyawa ng Tohan sang porma ng malapati. ");
INSERT INTO kqew_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aw aon sowara sikun sang langit na yagalaong, “Ikaw yang pyasaya ko na Anak. Dakowa yang kasowat ko kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ansinyan pyakadto dayon si Isa ng Nyawa ng Tohan adto sang kamingawan. ");
INSERT INTO kqew_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adto da yan paga-uya sa suud ng 40 na allaw aw yabay yan sasatun ni Iblis. Aon oman maisug na mga ayup sang masaid kanan, awgaid yatiman yan ng mga malaikat. ");
INSERT INTO kqew_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, nang yapiriso da si Yahiya, kyomadto si Isa sang banwa ng Jalil aw yaga-osiyat yan ng Madyaw na Gogodanun na sikun sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Laong nan, “Adon dyomatung da yang wakto na pyagakahanda ng Tohan aw masaid da domatung yang pagdato nan. Pagtawbat da kamo aw biyai mayo yang mga dosa mayo aw pangintoo kamo sang Madyaw na Gogodanun.” ");
INSERT INTO kqew_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ansinyan sarta yagapanaw si Isa sang kilid ng Linaw ng Jalil, kinita nan yang dowa na maglomon na si Simon aw si Andriyas na yamamokot kay mangingisdaay silan. ");
INSERT INTO kqew_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yagalaong si Isa kanilan, “Bita da, agad kamo kanak. Sikun adon inangun ta kamo na mangingisdaay ng otaw untak magpangagad silan kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na, pagdungug sinyan biniyaan dayon nilan yang pokot nilan aw yamagad silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ansinyan pyomanaos si Isa pagpanaw aw kinita nan yang dowa na maglomon na si Yakob aw si Yahiya na mga anak ni Sibidi. Yanagpona silan ng pokot adto sang kanilan bangka. ");
INSERT INTO kqew_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tyawag silan ni Isa na amagad kanan. Ansinyan biniyaan da nilan yang kanilan ama aw yang mga maggawbukay adto sang bangka aw yamagad silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ansinyan kyomadto silan Isa sang longsod ng Kapirnaom. Pagdatung ng Allaw ng Pagpatana kyomadto si Isa sang pagsasambayangan ng mga Yahodi aw mag-indo. ");
INSERT INTO kqew_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yangkatingaa yang mga otaw sang pag-indo ni Isa kay yaga-indo yan na aon kapatot aw dili mag-onawa ng mga magiindoway ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Adon, aon sangka otaw sang pagsasambayangan nilan na kyasaytanan. ");
INSERT INTO kqew_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yagapiyagit yan aw laong nan, “Ono yang labot mo kanami, kay Isa na taga Nasarit? Yakani kaw sang pagsapad kanami? Yamatigam ako daw sino kaw. Ikaw yang sotti na syogo ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Awgaid syagda ni Isa yang saytan aw laong nan, “Katingun aw logwa da sinyan na otaw!” ");
INSERT INTO kqew_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na, pyatakigan da idtong otaw ng saytan, tapos yagapiyagit yan ng matanog aw logwa sikun sang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ansinyan yangkatingaa da yang kariko ng mga otaw aw yanag-inosipay silan, laong nilan, “Ono kadi yani? Bago yani na indowan? Kay aon kapatot nan pagsogo sang mga saytan aw matoman silan kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ansinyan yakarimpud da yang gogodanun makapantag kang Isa sang tibok probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Paglogwa nilan ni Isa sikun sidto na pagsasambayangan, kyomadto silan sang baay ni Simon aw si Andriyas. Yamagad oman kanilan si Yakob aw si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na, yang ogangan na bobay ni Simon yagakowang adto sang baay na labi na mapaso yang lawas nan. Agaw pagdatung ni Isa pyagalaong dayon nilan makapantag kanan. ");
INSERT INTO kqew_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ansinyan dyomood si Isa sang bobay, takmagi yang arima nan aw papagbangona. Aw yawaa dayon yang kapaso ng lawas nan. Pagkatapos, pyakan nan silan Isa. ");
INSERT INTO kqew_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na, pagsallup ng suga, dyaa da ng mga otaw yang kariko ng mga masakitun aw yang mga kyasaytanan adto kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aw yang kariko ng mga otaw sikun sidto na banwa yanagkatipon sa atobangan sidto na baay. ");
INSERT INTO kqew_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na, madaig yang mga otaw na pyakadyaw ni Isa sikun sang yagakatuna-tuna na mga sakit aw madaig yang mga saytan na pyalogwa nan sikun sang mga otaw. Awgaid wa nan atogoti yang mga saytan na magalaong kay kyatigaman nilan daw sino yan. ");
INSERT INTO kqew_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagka-ilaw sinyan nang wa pa pagasilat yang suga, yagabangon si Isa aw lyomogwa yan sikun sang baay. Kyomadto yan sang mamingaw na banwa untak magdowaa. ");
INSERT INTO kqew_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ansinyan kay waa sang baay si Isa, pyagapanganap yan ni Simon kipat yang mga kaupudanan nan. ");
INSERT INTO kqew_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkita nilan kang Isa, yagalaong silan kanan, “Yang kariko ng mga otaw yagapanganap kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Awgaid yagalaong si Isa kanilan, “Bita da kamo, makadto da kita sang makilibot na mga baryo untak maka-osiyat oman ako adto. Kay yan yang katoyowan nanga yakani ako sining donya.” ");
INSERT INTO kqew_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Agaw kyadtonan da ni Isa yang kariko ng mga banwa na sakop ng Jalil aw yaga-osiyat yan adto sang mga pagsasambayangan ng mga Yahodi. Aw pyalogwa nan yang mga saytan sikun sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ansinyan aon sangka otaw na sanglaun na dyomood kang Isa. Lyomood yan sa atobangan nan aw yaga-angyo yan, laong nan, “Kong karim mo, makapagkadyaw kaw sang kanak sakit.” ");
INSERT INTO kqew_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ansinyan yarikad yang pangatayan ni Isa aw dyapunan nan yang inyan na otaw ng arima nan aw laong nan, “Uu, karim ko. Amadyaw da kaw.” ");
INSERT INTO kqew_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na, sinyan na wakto yawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ansinyan pyapanaw dayon yan ni Isa pagkatapos nan paglaongon, laong nan, ");
INSERT INTO kqew_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Aw pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqew_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Awgaid pagpanaw sinyan na otaw, yagagogod yan sang kariko ng mga otaw makapantag sang ininang ni Isa. Agaw sagaw wa da makapakita si Isa adto sang mga longsod aw kyomadto da gaid yan sang mamingaw na mga banwa. Awgaid maskin maynan, yabay komadto kanan yang mga otaw sikun sang kariko ng mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paglabay ng pilang allaw, byomarik oman si Isa adto sang longsod ng Kapirnaom. Aw yadungug dayon ng mga otaw na iyan da yan sang baay. ");
INSERT INTO kqew_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Agaw, wa akadogay sinyan madaig yang mga otaw na yanagkatipon sidto na baay taman sang waa day makasuud aw way oman logar maskin apit sang powertaan. Aw yaga-indo kanilan si Isa ng pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sarta yaga-indo si Isa, aon dyomatung na opat ka otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Awgaid wa silan pakadood adto kang Isa sabap sang kadaig ng mga otaw. Agaw pyomanik silan sang atup aw bosloti nilan sang babaw ni Isa aw tontona nilan idtong otaw sang kowangan nan adto sang masaid kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, yampon da yang mga dosa mo.” ");
INSERT INTO kqew_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Adon, aon oman mga magiindoway ng Hokoman na yanag-ingkod ansan. Pagdungug nilan sang pyaglaongan ni Isa, yagalaong silan sang ginawa nilan, ");
INSERT INTO kqew_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nanga yagalaong yani na otaw ng mayninyan? Yakun nan yang kapatot ng Tohan kay yang Tohan gaid yang maka-ampon sang dosa ng manosiya!” ");
INSERT INTO kqew_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Awgaid kyatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Nanga maynan yang dumduman mayo? ");
INSERT INTO kqew_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wain yang masayun paglaong sining otaw na sadi, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon, daa yang kowangan mo aw panaw?’ ");
INSERT INTO kqew_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Adon, untak katigaman mayo na ako na Anak ng Manosiya aon kapatot ko adi sa babawan ng donya mag-ampon sang mga dosa, pakadyawon da ko yani na otaw.” Ansinyan yagalaong si Isa sidtong otaw na sadi, ");
INSERT INTO kqew_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kay Itin, pagbangon, daa yang kowangan mo aw ori da adto kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na, sarta yagatanaw yang kariko ng mga otaw, yagabangon inyan na otaw, daa yang kowangan nan aw panaw. Aw yangkatingaa da yang kariko nilan aw pyoji nilan yang Tohan, laong nilan, “Sokad-sokad way kinita ta na mag-onawa sinyan!” ");
INSERT INTO kqew_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ansinyan byomarik si Isa adto sang kilid ng Linaw ng Jalil. Madaig yang mga otaw na yanagkatipon adto kanan aw inindowan nan silan. ");
INSERT INTO kqew_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapos, sarta yagapanaw si Isa, kinita nan yang sambok na kobrador ng bowis na yaga-ingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Libi na anak ni Alpiyo. Laong ni Isa kanan, “Bita da, agad kanak.” Ansinyan yamindug dayon yan aw yamagad kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wa akadogay sinyan yanagpangan si Isa aw yang mga inindowan nan adto sang baay ni Libi. Madaig yang mga kobrador ng bowis aw yang kadaigan pa na mga otaw na tyawag na baradosa na yanag-upud kanilan koman kay madaig da silan na yamagad kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pagkita sinyan ng mga magiindoway ng Hokoman na mga Parisi, yagalaong silan sang mga inindowan ni Isa, “Nanga yakan si Isa upud sang mga kobrador ng bowis aw yang kadaigan pa na mga otaw na baradosa?” ");
INSERT INTO kqew_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Awgaid yakadungug sinyan si Isa, agaw yagalaong yan kanilan, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. Mag-onawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan, kondi para sang mga otaw na baradosa kay untak magtawbat silan.” ");
INSERT INTO kqew_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sangallaw sinyan yagapowasa yang mga inindowan ni Yahiya na Magsosogboway aw yang mga inindowan ng mga Parisi. Ansinyan aon mga otaw na kyomadto kang Isa aw yaga-osip silan kanan, laong nilan, “Yang mga inindowan ni Yahiya aw yang mga inindowan ng mga Parisi yanagpowasa. Awgaid yang mga inindowan mo wa pagapowasa. Nanga?” ");
INSERT INTO kqew_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tyomobag si Isa pina-agi sang pasombingay, laong nan, “Mapakay ba magpowasa yang mga bisita sang kawin sarta iyan pa yang usug na akawinun? Dili! ");
INSERT INTO kqew_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun, aw sidto na wakto magapowasa da silan.” ");
INSERT INTO kqew_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yagalaong oman si Isa, “Way otaw na magatompaa ng bago na tela sang dadaan na dagom. Kay kong makoyot idtong tyompaa, amalasi da oman yang dagom aw labi da yang lasi sinyan. ");
INSERT INTO kqew_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Way oman otaw na yang bago na bino ilasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, ma-asag da yang bino aw amasapad yang lasakanan. Agaw sagaw, yang bago na bino dait ilasak sang bago na lasakanan na abay pa ma-onat.” ");
INSERT INTO kqew_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sangallaw sinyan na Allaw ng Pagpatana ng mga Yahodi, yamagi si Isa aw yang mga inindowan nan sang pawa ng trigo. Pag-agi nilan, yangutu yang mga inindowan nan ng trigo. ");
INSERT INTO kqew_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pagkita sinyan ng mga Parisi, yagalaong silan kang Isa, “Tanawa yang mga inindowan mo! Sopak sang Hokoman yang ininang nilan kay yagagawbuk silan sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tyomobag si Isa aw laong nan kanilan, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sang wakto na yamagutum yan kipat yang mga kaupudanan nan aw yagakinaanglan silan ng pagkan? ");
INSERT INTO kqew_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sidtong wakto na si Abiyatar yang Dakowa na Imam, syomuud si Soltan Daud sang Baay ng Tohan aw kyan nan yang pan na pyasampay adto sang Tohan aw atagi oman yang mga kaupudanan nan maskin sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan.” ");
INSERT INTO kqew_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yagalaong oman si Isa, “Ininang ng Tohan yang Allaw ng Pagpatana para sang kadyawan ng manosiya. Awgaid yang manosiya wa nan abaoya untak kabugatan silan ng Allaw ng Pagpatana. ");
INSERT INTO kqew_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Agaw ako na Anak ng Manosiya, aon kapatot ko paglaong daw ono yang mapakay inangun maskin sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sangallaw sinyan kyomadto si Isa sang pagsasambayangan ng mga Yahodi. Ansidto aon sambok na otaw na yamasadi yang sangkilid na arima nan. ");
INSERT INTO kqew_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aon oman mga otaw ansan na yagasima kang Isa daw pakadyawon nan idtong otaw sang Allaw ng Pagpatana kay untak aon ikasombong nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ansinyan yagalaong si Isa sang otaw na yamasadi yang sangkilid na arima nan, “Adi kaw sa atobangan ng mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkatapos yosip ni Isa yang mga otaw, laong nan, “Sobay sang Hokoman, ono yang mapakay inangun sang Allaw ng Pagpatana, yang pag-inang ng madyaw atawa maat, yang paglowas sang kinabowi ng otaw atawa yang pagpatay?” Awgaid wa silan atobag kanan. ");
INSERT INTO kqew_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ansinyan pyagatanawan silan ni Isa. Yadaman yan kanilan aw masakit yang pangatayan nan sabap ng mabagsug yang oo nilan. Ansinyan yagalaong yan sidtong otaw na yamasadi yang sangkilid na arima nan, “Onata yang arima mo.” Na, yonat da nan aw yamadyaw dayon yang arima nan. ");
INSERT INTO kqew_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ansinyan lyomogwa da yang mga Parisi sikun sang pagsasambayangan aw kadtoni nilan yang mga otaw ni Soltan Hirod kay untak pagbaawan nilan daw monono yang pagpatay nilan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ansinyan pyomanaw ansan si Isa aw yang mga inindowan nan aw kyomadto silan sang kilid ng Linaw ng Jalil. Labi na madaig yang mga taga Jalil na yamagad kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aw madaig oman yang mga otaw sikun sa Awrosalam aw sang kadaigan pa na mga banwa sa Yahodiya kipat sang mga banwa na sakop ng Idomiya. Aon oman sikun sang dipag ng tobig ng Yordan aw sikun oman sang masaid sang mga syodad ng Tiros aw Sidon. Yani na kaotawan kyomadto kang Isa kay yadungug nilan yang kariko ng ininang nan. ");
INSERT INTO kqew_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adon, sabap sang kadaig ng mga otaw pyagalaong ni Isa yang mga inindowan nan na mag-andam silan ng bangka na akasakayan nan untak di yan kaligpitan ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Madaig da yang mga otaw na pyakadyaw ni Isa, agaw yanagtinooday da yang kariko ng mga masakitun untak makatakmag silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aw pagkita kanan ng mga otaw na kyasaytanan, syomojod dayon silan sa atobangan nan aw yagapiyagit silan aw laong nilan, “Ikaw yang Anak ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Awgaid syagda silan ni Isa ng ma-igpit untak di silan maglaong daw sino yan. ");
INSERT INTO kqew_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatapos sinyan syomakat si Isa sang sambok na butay aw tawaga nan yang mga otaw na karim nan pa-agadun aw dyomood silan adto kanan. ");
INSERT INTO kqew_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ansinyan sampoo aw dowangka otaw yang pinili nan untak ma-inang ng mga sahabat nan. Yagalaong yan kanilan, “Pinili ta kamo untak magad kamo kanak aw asogoon ta kamo untak mag-osiyat ng Madyaw na Gogodanun. ");
INSERT INTO kqew_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aw atagan ta kamo ng kapatot pagpalogwa ng mga saytan sikun sang mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, yang sampoo aw dowangka otaw na pinili nan si Simon na ingaanan nan kang Pitros, ");
INSERT INTO kqew_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Yakob aw yang lomon nan na si Yahiya na mga anak ni Sibidi. Ingaanan silan ni Isa sang Bowanirgis na yang mana san “maisug na maynang linti,” ");
INSERT INTO kqew_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andriyas, si Pilip, si Bartolomi, si Matiyo, si Tomas aw si Yakob na anak ni Alpiyo, si Tadiyos, si Simon na rebelde singaon, ");
INSERT INTO kqew_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatapos sinyan yamori silan Isa. Ansinyan madaig da oman yang mga otaw na yanagkatipon adto kanan. Agaw si Isa aw yang mga inindowan nan way gaid oras maskin sang pagpangan. ");
INSERT INTO kqew_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na, pagdungug sinyan ng mga kalomonan ni Isa, kyomadto silan sidtong baay untak kamangun nilan si Isa kay pagtoo nilan na yabowang da yan. ");
INSERT INTO kqew_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aon oman mga magiindoway ng Hokoman sikun sa Awrosalam na yagalaong, “Syuudan si Isa ni Bilsibol. Yang pangoo ng mga saytan yang yaga-atag kanan ng kabarakat pagpalogwa ng mga saytan.” ");
INSERT INTO kqew_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pagdungug ni Isa sang mga pyaglaongan nilan, pyadood nan silan aw yagalaong yan kanilan ng pasombingay, laong nan, “Di mapakay na magapalogwa si Iblis ng kapag-onawa nan na saytan. ");
INSERT INTO kqew_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kong manag-onay magtanam yang mga otaw sang sambok na pyagdatowan, sang di amadogay amasapad yang pyagdatowan. ");
INSERT INTO kqew_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aw kong magakabain-bain yang mga otaw sang sambok na pamilya, sang orian amabongkag yani na pamilya. ");
INSERT INTO kqew_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mag-onawa sinyan, kong mapagtanam si Iblis sang mga sakop nan na saytan aw magakabain-bain silan, sang di amadogay akawaan yan ng kapatot pagsogo kanilan aw amasapad yang pyagdatowan nan.” ");
INSERT INTO kqew_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ansinyan yaga-atag oman si Isa kanilan ng opamaan, laong nan, “Way makasuud sang baay ng makusug na otaw aw makakamang ng mga butang nan kong di nan ona gaposon idtong makusug na otaw. Awgaid kong yamagapos da nan, makakamang da yan ng mga butang sidto na baay. ");
INSERT INTO kqew_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sa bunna-bunna na ipaglaong ko kamayo na yang kariko ng dosa ma-ampon aw maskin pa yang paglaong ng maat makapantag sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di ma-ampon taman sa taman.” ");
INSERT INTO kqew_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Maynini yang pyaglaongan ni Isa adto sang mga magiindoway ng Hokoman kay yagalaong silan na syuudan yan ng saytan. ");
INSERT INTO kqew_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ansinyan dyomatung yang ina ni Isa aw yang mga mangkangod nan na usug. Yaga-indug silan adto sa logwa ng baay aw pyatawag nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Adto sa suud madaig yang mga otaw na yanag-ingkod sang makilibot ni Isa. Ansinyan aon yagalaong kang Isa, “Tabiya, yang ina mo aw yang mga lomon mo, adto silan sa logwa na yagatagad kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tyomobag si Isa aw laong nan kanilan, “Sino kadi yang ina ko aw mga lomon ko?” ");
INSERT INTO kqew_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ansinyan pyagatanawan ni Isa yang mga otaw na yanag-ingkod sang palibot nan aw laong nan, “Idi kay yang ina ko aw yang mga lomon ko. ");
INSERT INTO kqew_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kay sino-sino yang yaga-inang ng karim ng Tohan, silan yang ina ko aw yang mga lomon ko na usug aw bobay.” ");
INSERT INTO kqew_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ansinyan yaga-indo da oman si Isa adto sang kilid ng linaw. Aw madaig da oman yang mga otaw na yanagkatipon adto kanan. Agaw, yang ininang ni Isa, syomakay yan sang sambok na bangka na yagalotaw sang tobig aw yamingkod ansan sarta yang mga otaw adto manag-indug sang kilid ng linaw. ");
INSERT INTO kqew_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na, madaig yang pyaga-indo ni Isa kanilan pina-agi sang mga pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Laong nan, “Paningug kamo! Aon otaw na kyomadto sang pawa untak magsabod ng bini. ");
INSERT INTO kqew_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sang pagsabod nan, aon mga bini na yamallog adto sang kilid ng daan. Ansinyan dyomatung yang mga langgam aw toboga nilan. ");
INSERT INTO kqew_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aon oman mga bini na yamallog adto sang batoon na lopa. Na, tyomobo dayon yang mga bini kay mababaw yang lopa. ");
INSERT INTO kqew_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Awgaid pagsilat ng suga, yalanus dayon yang mga tanum sabap sang kapaso ng suga aw yagango da kay wa silan pakagamot ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aon oman mga bini na yamallog adto sang lopa na madaig yang sampinit. Ansinyan tyomorin yang sampinit aw kyatabonan sinyan yang mga tanum. Idto sagaw wa silan abonga. ");
INSERT INTO kqew_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Awgaid aon oman mga bini na yamallog adto sang madyaw na lopa. Tyomorin silan aw yabonga ng madyaw. Yang kadaigan yabonga ng osto gaid. Yang kadaigan oman yabonga ng madaig, aw yang kadaigan oman yabonga ng labi na madaig.” ");
INSERT INTO kqew_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sang orian yagalaong si Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagpanaw ng kaotawan, yang yamabilin sang masaid kang Isa yang pilangka otaw na mga inagad nan upud sang sampoo aw dowa na sahabat nan. Ansinyan yaga-osip silan kanan daw ono yang mana nidto na pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tyomobag si Isa aw laong nan, “Kamo, yatagan kamo ng katigam untak makasabot kamo sang mga tinago makapantag sang pagdato ng Tohan. Awgaid sang kadaigan na mga otaw mga pasombingay yang gyamit ko ");
INSERT INTO kqew_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kay untak matoman yang yakasorat sang Kitab na yagalaong, “ ‘Maskin yagatanaw silan, di silan makakita. Aw maskin yamaningug silan, di silan makasabot. Kay kong dili ng maynan, mabarik da gao silan adto sang Tohan untak amponon nan silan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ansinyan yagalaong si Isa kanilan, “Wa kadi kamo pakasabot sidto na pasombingay? Kong maynan, di oman kamo makasabot sang kadaigan pa na mga pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na, yani kay yang mana nan. Yang bini na syabod, idto yang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yang kilid ng daan na kyaoogan ng bini, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan. Awgaid pagdungug sinyan, dyomatung dayon si Iblis aw kamanga nan yang pyaglaongan na dyungug nilan sikun sa pangatayan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yang kadaigan oman na mag-onawa ng batoon na lopa, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan aw tyarima dayon nilan na aon kasowat. ");
INSERT INTO kqew_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Awgaid sabap ng wa pakagamot yang pyaglaongan sang pangatayan nilan, di silan magadogay sang pagpangintoo nilan. Kay kong adatungan silan ng mga sasat atawa apasikotan silan sabap sang pagpangagad nilan sang pyaglaongan ng Tohan, mabiya dayon silan sang pagpangintoo. ");
INSERT INTO kqew_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yang kadaigan oman na mag-onawa ng lopa na madaig yang sampinit, idto yang mga otaw na yakadungug sang pyaglaongan ng Tohan, ");
INSERT INTO kqew_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","awgaid sabap sang karidowan nilan adi sa babawan ng donya aw sabap oman sang kallini nilan sang sapi aw yang kadaigan pa na mga butang, kyatabonan da yang pyaglaongan ng Tohan. Idto sagaw way yakita na bonga ng pagpangintoo sang kinabowi nilan. ");
INSERT INTO kqew_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Awgaid yang kadaigan na mag-onawa ng madyaw na lopa, silan yang mga otaw na yakadungug sang pyaglaongan ng Tohan aw yagapangagad sinyan. Agaw sagaw aon makita na bonga ng pagpangintoo sang kinabowi nilan. Yang kadaigan yabonga ng osto gaid, yang kadaigan oman yabonga ng madaig, aw yang kadaigan oman yabonga ng labi na madaig.” ");
INSERT INTO kqew_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan aw asangkoban nan ng gantangan atawa butangan nan sa saad ng katri, kondi ibutang nan sang tongtonganan kay untak kapawaan yang baay. ");
INSERT INTO kqew_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kay yang maskin ono na tyago, amaklaro sang orian. Aw yang wa pa akatigami adon, akatigaman da. ");
INSERT INTO kqew_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yagalaong oman si Isa, “Dumduma mayo yang dyungug mayo. Kay daw monono yang pagpaningug mayo, daw apangagadan mayo yang dyungug mayo atawa apasagdan mayo, maynan oman yang inangun kamayo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kay sino-sino yang amaningug ng madyaw, adogangan pa yang katigam aw pagsabot nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyatigaman nan, akamangun pa kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yagalaong oman si Isa, “Yang pagdato ng Tohan mag-onawa ng otaw na yagasabod ng bini adto sang pawa nan. ");
INSERT INTO kqew_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagkatapos nan magsabod, yaga-inang yan ng kadaigan pa na gawbuk nan. Na, sarta yatoog yan ng gabi aw yagagawbuk ng allaw, gyomiti aw tyomorin da yang mga bini. Awgaid wa yan akatigam daw monono yang pagtorin nilan. ");
INSERT INTO kqew_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kay yang lopa yang yagapatorin aw yagapabonga sang mga tanum. Sawpama yang omay, magadaon ona, sonod magkadaig yang daon aw sang orian mamonga. ");
INSERT INTO kqew_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na, kong ya-ilag da, aganiun da kay dyomatung da yang wakto ng paggani.” ");
INSERT INTO kqew_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yagalaong oman si Isa, “Ono yang ikatandi natun sang pagdato ng Tohan? ");
INSERT INTO kqew_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ono yang akapasombingay natun ninyan? Na, yang pagdato ng Tohan mag-onawa ng liso ng mostasa na yani yang labi na tagbi sang kariko ng mga liso. ");
INSERT INTO kqew_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Awgaid pagtanum sinyan, matorin yan aw ma-inang yan ng makagwas pa sang kariko ng mga tanum. Dakowa oman yang mga sanga nan na akapogadan aw akapasilongan ng mga langgam.” ");
INSERT INTO kqew_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na, madaig pa yang mga pasombingay na mag-onawa ninyan na gyamit ni Isa sang pag-osiyat nan sang mga otaw. Aw inindowan nan silan taman sang magaga nilan masabot. ");
INSERT INTO kqew_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Way pyaga-indo nan sang mga otaw na dili pina-agi sang pasombingay. Awgaid kong silan da gaid ni Isa sang mga inindowan nan, pyatigam nan kanilan yang mana ng kariko ng mga pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagsallup ng suga sinyan na allaw, yagalaong si Isa adto sang mga inindowan nan, “Bita da kamo. Mataripag da kita sang linaw.” ");
INSERT INTO kqew_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ansinyan pyanawan da nilan yang kaotawan aw syomakay silan sang bangka na pyaga-ingkodan ni Isa aw larga da silan. Aon oman kadaigan pa na mga bangka na yamagad kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ansinyan tyomokaw moyop yang makusug na samut aw kyalasakan da ng tobig yang kanilan bangka na masaid da mapono. ");
INSERT INTO kqew_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Awgaid si Isa adto sang orin ng bangka na yatoog sang oonan. Agaw, pyokaw yan ng mga inindowan nan aw yagalaong silan kanan, “Kay Goro, wa kaw akarido na mallug da kita matay?” ");
INSERT INTO kqew_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ansinyan yagabangon si Isa aw syagda nan yang samut, laong nan, “Ondang da!” aw yagalaong yan sang mga baud, “Kalinaw da!” Na, ansinyan yamondang dayon yang samut aw yamalinaw da. ");
INSERT INTO kqew_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yagalaong si Isa sang mga inindowan nan, “Nanga yamalluk kamo? Waa pay kadi pagpangintoo mayo kanak?” ");
INSERT INTO kqew_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na, labi da yang alluk nilan aw yanag-inosipay silan, laong nilan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud matoman kanan?” ");
INSERT INTO kqew_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ansinyan dyomatung si Isa aw yang mga inindowan nan adto sang dipag ng linaw sang logar ng mga taga Girasa. ");
INSERT INTO kqew_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagpanaog ni Isa sang bangka, syongon dayon yan ng sambok na otaw na yagasikun sang mga langob na pakoboran. Yani na otaw kyasaytanan ");
INSERT INTO kqew_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","aw iyan yan paga-uya sang mga langob. Way otaw na makagapos kanan maskin pa bakoson yan ng kadina. ");
INSERT INTO kqew_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Makapila da nilan bakosa yang siki aw arima nan, awgaid pyamogto da gaid nan yang mga kadina. Way sagaw otaw na makapogong kanan. ");
INSERT INTO kqew_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allaw-gabi yagapanaw-panaw yan sang pakoboran aw adto oman sang kabutayan. Yabay yan magpiyagit aw pyarian nan yang lawas nan ng mga bato. ");
INSERT INTO kqew_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Adon, pagkita nan kang Isa maskin mawat pa yan, dyomaagan yan aw syomojod sa atobangan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ansinyan yagalaong si Isa sang saytan na yakalasak sinyan na otaw, “Saytan, logwa da sini na otaw!” Yagapiyagit yang saytan aw laong nan ng matanog, “Kay Isa, Anak ng Tohan na Labi na Makagwas, ono yang labot mo kanak? Pangayoon ko sang ngaan ng Tohan na di mo ako asiksaun!” ");
INSERT INTO kqew_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ansinyan yaga-osip kanan si Isa, “Sino yang ngaan mo?” Tyomobag yan, “Yang ngaan ko si Panon kay madaig kami.” ");
INSERT INTO kqew_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ansinyan yaga-angyo yan kang Isa na di nan silan papanawon sikun sinyan na banwa. ");
INSERT INTO kqew_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, madaig yang mga binatang na yanagdowang sang kilid ng butay. ");
INSERT INTO kqew_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yaga-angyo da yang mga saytan kang Isa aw laong nilan, “Pakadtona da gaid kami adto sidtong mga binatang. Pasuuda kami adto kanilan.” ");
INSERT INTO kqew_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, tyogotan da silan ni Isa. Ansinyan lyomogwa da yang mga saytan sikun sang lawas sinyan na otaw aw lasak silan sidtong mga binatang. Aw yang kariko ng mga binatang dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangka-umus. Yang kadaig nilan mga 2000. ");
INSERT INTO kqew_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod aw sang makilibt na mga baryo aw gyogod nilan sang mga otaw idtong kyatamanan. Agaw yagasingadto da yang mga otaw untak tanawon nilan daw ono yang yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagdatung nilan adto kang Isa, kinita nilan na yaga-ingkod ansan idtong otaw na pyanawan da ng saytan. Yamandagom da yan aw yamori da yang madyaw na dumduman nan. Agaw yangkalluk da silan. ");
INSERT INTO kqew_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Idtong yakakita ng kyatamanan yagagogod sang mga otaw daw ono yang yamaitabo sidtong otaw na pyanawan da ng saytan kipat yang yamaitabo sang mga binatang. ");
INSERT INTO kqew_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pagdungug sinyan yaga-angyo yang mga otaw kang Isa na apanawan da nan yang banwa nilan. ");
INSERT INTO kqew_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ansinyan pagsakay ni Isa sang bangka kay mapanaw da yan, yaga-angyo kanan yang idtong otaw na kong mapakay pa-agadun yan. ");
INSERT INTO kqew_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Awgaid wa asogot si Isa aw laong nan kanan, “Ori da adto kamayo aw paggogod kanilan daw ono yang ininang kammo ng Tohan aw monono yang pagkallat nan kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Agaw pyomanaw da idtong otaw aw pyagapayapat nan adto sang mga banwa na sakop ng Dikapolis daw ono yang ininang kanan ni Isa. Aw yangkatingaa da yang kariko ng mga otaw na yakadungug sinyan. ");
INSERT INTO kqew_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ansinyan tyomaripag da oman si Isa sang linaw. Pagdatung nan adto sang dipag, madaig yang mga otaw na yanagtipon adto kanan. ");
INSERT INTO kqew_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ansinyan dyomatung yang sangka otaw na pyagangaanan kang Yairos na isa sang mga pangoo ng pagsasambayangan ng mga Yahodi sinyan na banwa. Pagkita nan kang Isa, syomojod yan sa atobangan nan ");
INSERT INTO kqew_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aw yaga-angyo yan, laong nan, “Yang anak ko na bobay yagapinal da. Aw mapakay kammo, kadtoni yan aw dapuni ng arima mo kay untak magkadyaw yan aw mabowi pa yan.” ");
INSERT INTO kqew_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Agaw yamagad si Isa kanan. Madaig oman yang mga otaw na yamagad kanilan aw yanagdinutdutay silan adto kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Adon, aon sambok na bobay ansan na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. ");
INSERT INTO kqew_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Madaig da yang kasikotan na ya-agian nan sang pagpatambal sang madaig na mananambalay. Ya-obos da yang kariko ng kanan sapi awgaid wa pa akadyaw, kondi yallabi pa yang kanan pagkasakit. ");
INSERT INTO kqew_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Adon, yakadungug yan ng makapantag kang Isa. Agaw, sang tunga ng mga otaw dyomood yan kang Isa sikun sang likod nan aw takmagi nan yang dagom nan. ");
INSERT INTO kqew_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kay yagalaong yan sang ginawa nan, “Aw makatakmag gaid ako sang dagom ni Isa, amadyaw da ako.” ");
INSERT INTO kqew_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na, pagtakmag nan sang dagom ni Isa, yamondang dayon yang pag-agas ng dogo nan aw byati nan na yamadyaw da yan sikun sang kanan sakit. ");
INSERT INTO kqew_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na, sinyan dayon kyatigaman ni Isa na aon kabarakat na lyomogwa sikun kanan. Agaw, lyomingi yan sang mga otaw aw yaga-osip yan, “Sino kadi yang yagatakmag sang dagom ko?” ");
INSERT INTO kqew_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tyomobag yang mga inindowan nan, “Kinita mo na madaig yang mga otaw na yanagdinutdutay kammo. Nanga yaga-osip pa kaw daw sino yang yagatakmag kammo?” ");
INSERT INTO kqew_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Awgaid yagapanlingi-lingi pa si Isa untak tanawon nan daw sino yang yagatakmag kanan. ");
INSERT INTO kqew_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Adon, sabap ng kyatigaman ng bobay daw ono yang yamaitabo kanan, dyomood yan kang Isa na tyakigan sabap sang alluk nan. Syomojod yan sa atobangan nan aw yagalaong yan ng kabunnaan. ");
INSERT INTO kqew_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ansinyan yagalaong kanan si Isa, “Kay Bi, sabap sang pagpangintoo mo yamadyaw da kaw. Panaw da na aon kalinaw kay waa day sakit mo.” ");
INSERT INTO kqew_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sarta yagalaong pa si Isa, aon dyomatung na mga otaw sikun sang baay ni Yairos na pangoo ng pagsasambayangan nilan. Yagalaong silan kang Yairos, “Yamatay da yang anak mo. Ayaw da pagdistorbowa yang goro.” ");
INSERT INTO kqew_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Awgaid yakadungug sinyan si Isa aw laong nan kang Yairos, “Ayaw pagkalluk. Pagpangintoo gaid.” ");
INSERT INTO kqew_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ansinyan wa atogoti ni Isa yang maskin sino na amagad kanan yatabiya si Pitros aw yang maglomon na si Yakob aw si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagdatung nilan sang baay ni Yairos, kinita ni Isa na yagakasamok yang mga otaw aw madaig yang yanagtiyao aw yanagminatay ng matanog. ");
INSERT INTO kqew_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagsuud ni Isa, yagalaong yan kanilan, “Nanga bali na kasamok mayo? Nanga yagatiyao kamo? Dili ng patay yang isu kondi yatoog gaid yan.” ");
INSERT INTO kqew_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na, inikuan da gaid nilan si Isa. Agaw pyalogwa da ni Isa yang kariko nilan. Tapos, pyaga-agad nan yang ama aw ina ng isu kipat yang toongka otaw na mga inindowan nan aw syomuud silan sang kowarto na pyagakowangan ng isu. ");
INSERT INTO kqew_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ansinyan tyakmagan ni Isa yan arima ng isu aw yagalaong yan, “Talita komi,” na yang mana nan, “Kay Bi, bangon da.” ");
INSERT INTO kqew_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ansinyan yagabangon dayon yang isu aw magpanaw-panaw. Sampoo aw dowangka toig yang idad nan. Aw yangkatingaa da yang mga yakakita sinyan. ");
INSERT INTO kqew_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Awgaid syagda silan ni Isa na di silan maggogod sang maskin sino ng makapantag sinyan. Aw pyagalaong nan silan na pakanun da nilan yang isu. ");
INSERT INTO kqew_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ansinyan pyomanaw si Isa sinyan na banwa aw yamori yan adto sa Nasarit, yang longsod na tyorinan nan. Aw yamagad oman kanan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pagdatung ng Allaw ng Pagpatana, yaga-osiyat si Isa adto sang pagsasambayangan ng mga Yahodi. Madaig yang mga otaw ansan aw pagdungug nilan sang pag-osiyat nan, yatingaa silan aw laong nilan, “Wain yani na otaw pakakamang sini na katigam? Aw wain yan sang kabarakat pag-inang sini na mga katingaan? ");
INSERT INTO kqew_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Di ba yani yang panday, yang anak ni Mariyam aw yang mga lomon nan si Yakob, si Yosis, si Yodas aw si Simon? Di ba, adi oman paga-uya yang mga lomon nan na bobay?” Aw wa nilan atarimaa si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Agaw yagalaong kanilan si Isa, “Yang nabi pyaga-addatan ng mga otaw maskin wain, yatabiya adto sang kanan banwa, sang kanan mga kadogo aw adto sang kanan baay.” ");
INSERT INTO kqew_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Idto sagaw, wa yan paka-inang ng katingaan sidto na banwa yatabiya yang pilangka otaw na yamasakit na dyapunan nan ng arima nan aw pyakadyaw nan. ");
INSERT INTO kqew_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aw yatingaa si Isa kay wa silan apangintoo kanan. Pagkatapos sinyan yakarimpud si Isa komadto sang makilibot na mga banwa aw yaga-indo yan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ansinyan tyawag nan yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw syogo nan silan pagpanaw ng tagdowa. Yatagan nan silan ng kapatot pagpalogwa sang mga saytan ");
INSERT INTO kqew_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","aw yagalaong yan kanilan, “Sang pagpanaw mayo, ayaw kamo pagdaa ng maskin ono yatabiya sang songkod. Ayaw kamo pagdaa ng pagkan, lasakanan atawa sapi sang bolsa mayo. ");
INSERT INTO kqew_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mapakay kamo magsandalyas, awgaid ayaw kamo pagdaa ng ilisan mayo. ");
INSERT INTO kqew_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maskin wain na baay yang adatungan mayo, ansan da kamo mag-uya taman sang pagpanaw mayo sikun sinyan na banwa. ");
INSERT INTO kqew_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kong aon banwa na akadtonan mayo aw yang mga otaw ansan di magatarima kamayo ni amaningug sang pyaglaongan mayo, panawi mayo yan na banwa. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan.” ");
INSERT INTO kqew_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ansinyan pyomanaw da yang mga inindowan ni Isa aw yanag-osiyat silan sang mga otaw na dait silan magtawbat ng mga dosa nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Madaig yang mga saytan na pyalogwa nilan sikun sang mga otaw aw madaig yang mga masakitun na dyamasan nilan ng lana aw pyakadyaw nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ansinyan yakadungug si Hirod na soltan sa Jalil ng makapantag sang ininang ni Isa kay yamabantog da yang ngaan nan sang kariko ng banwa. Aon mga otaw na yagalaong na si Isa kono si Yahiya na Magsosogboway na yabowi oman, aw idto sagaw aon kono kabarakat nan pag-inang ng katingaan. ");
INSERT INTO kqew_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yang kadaigan oman yagalaong, “Si Nabi Iliyas kowaw yan.” Aw yang kadaigan oman yagalaong, “Nabi kowaw si Isa na mag-onawa ng mga nabi singaon.” ");
INSERT INTO kqew_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Awgaid pagdungug sinyan ni Hirod yagalaong yan, “Si Yahiya kowaw yani na pya-otodan ko ng oo. Yamabowi da oman yan!” ");
INSERT INTO kqew_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maynini yang pyaglaongan ni Hirod kay singaon pyadakup nan si Yahiya, pyagapos aw pyapiriso nan. Ininang nan yani kay pyangasawa nan si Hirodiya na asawa ng kanan lomon na si Pilip. ");
INSERT INTO kqew_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aw yabay yan paglaongon ni Yahiya, laong nan, “Di mapakay na pangasawaun mo yang asawa ng lomon mo. Sopak yan sang Hokoman.” ");
INSERT INTO kqew_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na, sabap sinyan maat yang ginawa ni Hirodiya adto kang Yahiya aw karim gao nan na ipapatay si Yahiya. Awgaid way ma-inang nan ");
INSERT INTO kqew_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kay wa asogot si Hirod na apatayun si Yahiya. Kay dakowa yang addat ni Hirod kang Yahiya sabap ng kyatigaman nan na si Yahiya matorid na otaw na yagapangagad sang Tohan. Agaw pyabantayan nan si Yahiya adto sang pirisowan untak di yan ma-ono. Yamallini si Hirod maningug sang pag-osiyat ni Yahiya maskin sagaw matag wakto na yagapaningug yan kanan, yamarido yang ginawa nan. ");
INSERT INTO kqew_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Awgaid sangallaw sinyan dyomatung yang wakto na yatoman da yang kallini ni Hirodiya. Pagdatung ng allaw ng pagkaotaw ni Hirod, yagapakandori yan aw pyaga-imbitar nan yang mga opisyales nan kipat yang mga kapitan ng mga sondao aw yang mga dato sang probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sarta yagakandori silan, dyomatung yang anak ni Hirodiya aw somayaw. Aw yamasowat sinyan si Hirod kipat yang kariko ng mga bisita nan. Agaw yagalaong si Hirod sidtong daaga, “Kay Bi, ono yang karim mo? Maskin ono yang apangayoon mo, i-atag ko kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ansinyan yagapasad kanan si Hirod aw laong nan, “Sagaw, yang maskin ono yang apangayoon mo, abir pa katunga sang kanak pyagdatowan, i-atag ko kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Adon lyomogwa ansan yang daaga aw yaga-osip yan sang kanan ina, “Kay ina, ono kadi yang apangayoon ko?” Tyomobag yang kanan ina, “Pangayowa yang oo ni Yahiya na Magsosogboway.” ");
INSERT INTO kqew_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ansinyan byomarik dayon yang daaga adto sang soltan aw paglaonga nan, “Kay soltan, yani yang apangayoon ko. Atagan kanak adon dayon yang oo ni Yahiya na Magsosogboway na yakabutang sang bandiya.” ");
INSERT INTO kqew_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na, pagdungug sinyan ng soltan, dakowa yang karidowan nan. Awgaid sabap ng yagapasad yan sa atobangan ng mga bisita nan, di da nan mabawi yang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Agaw syogo dayon ni Hirod yang sambok na sondao na adaun kanan yang oo ni Yahiya. Ansinyan pyomanaw da yang sondao aw otodi nan si Yahiya ng oo adto sang pirisowan. ");
INSERT INTO kqew_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagbarik nan, dyaa nan yang oo ni Yahiya na yakabutang sang bandiya aw atagan sang anak ni Hirodiya, aw yatag oman nan adto sang kanan ina. ");
INSERT INTO kqew_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na, pagdungug sinyan ng mga inindowan ni Yahiya, kyadtonan nilan yang lawas nan aw lubungan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ansinyan pagbarik ng mga sahabat ni Isa sikun sang pagpayapat, yanagkatipon silan adto kang Isa aw gogoda nilan kanan yang kariko ng ininang aw pyaga-indo nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Awgaid sabap ng madaig yang mga otaw na yadatung aw yapanaw, way gaid oras nilan maskin sang pagpangan. Agaw yagalaong si Isa sang mga inindowan nan, “Unda, makadto da kita sang mamingaw na banwa na kita da gaid untak makapatana kamo ng tagbis.” ");
INSERT INTO kqew_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Agaw syomakay da silan sang bangka aw kadto silan sang mamingaw na banwa na silan da gaid. ");
INSERT INTO kqew_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Awgaid madaig yang mga otaw na yakakita sang kanilan pagpanaw aw yakilaa silan kanilan. Agaw, sikun sang yagakatuna-tuna na mga banwa dyomaagan silan sang kilid ng linaw aw yama-ona silan domatung sang kyadtonan nilan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagpanaog ni Isa sang bangka, kinita nan yang kadaig ng mga otaw. Yamaooy yan kanilan kay main silan ng mga karniro na way magbabantayay. Ansinyan pyaga-indowan nan silan ng madaig na mga butang. ");
INSERT INTO kqew_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagkasilum sinyan dyomood kang Isa yang mga inindowan nan aw laong nilan, “Masaid da somallup yang suga aw mamingaw yani na banwa. ");
INSERT INTO kqew_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Madyaw pa aw pakadtonon mo yang mga otaw adto sang makilibot na mga baryo aw sityo untak silan makabili ng pagkan.” ");
INSERT INTO kqew_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Awgaid tyomobag si Isa kanilan, “Kamo da yang magpakan kanilan.” Yagalaong yang mga inindowan nan, “Monono da yan? Mapanaw ba kami aw magabili ng pan na yagakantidad ng soweldo ng waombowan untak ipakan kanilan?” ");
INSERT INTO kqew_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ansinyan yagalaong si Isa kanilan, “Tanawa mayo daw pilambok yang pan mayo ansan.” Pagkatigam da nilan, tyomobag silan kang Isa, “Limambok yang pan aw dowambok yang isda.” ");
INSERT INTO kqew_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ansinyan syogo ni Isa yang mga inindowan nan na pa-ingkodon nilan yang kariko ng mga otaw na magpondok-pondok sang kasagbutan. ");
INSERT INTO kqew_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Agaw yamingkod da silan sang mga pondok ng tag-100 aw tag-50. ");
INSERT INTO kqew_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ansinyan kyamang ni Isa yang limambok na pan aw dowambok na isda aw ya-angad sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga inindowan nan untak ipangatag nilan adto sang mga otaw. Mag-onawa sinyan, pyagapisang-pisang nan yang dowambok na isda kay ipangatag oman adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. ");
INSERT INTO kqew_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagtipon ng mga inindowan sang yamasama na pan aw isda, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na, yang kadaig ng mga otaw na yakakan, 5000 yang kausugan da gaid. ");
INSERT INTO kqew_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkatapos sinyan pyasakay ni Isa yang mga inindowan nan sang bangka. Syogo nan silan na ama-ona adto sang dipag sang banwa ng Bitsayda sarta apapanawon nan yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nang pya-ori da nan silan, syomakat yan sang butay untak magdowaa. ");
INSERT INTO kqew_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkagabi sinyan, adto da sang laod yang bangka na syakayan ng mga inindowan, awgaid si Isa adto pa sang butay ng sangka otaw da nan. ");
INSERT INTO kqew_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ansinyan kinita nan na kyasikotan yang mga inindowan nan pagbugsay kay yasongsong silan sang makusug na samut. Na, pagkakadlawon kyadtonan silan ni Isa na yagapanaw sa babaw ng tobig. Malabay gao yan kanilan, ");
INSERT INTO kqew_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","awgaid pagkita nilan na yagapanaw yan sa babaw ng tobig, yagapiyagit silan kay yagadumdum silan na molto yan. ");
INSERT INTO kqew_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yang kariko nilan yakakita kanan aw labi da yang alluk nilan. Awgaid yagalaong dayon si Isa, “Ayaw kamo pagkalluk. Ako sa yani. Pabagsuga mayo yang pangatayan mayo.” ");
INSERT INTO kqew_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ansinyan syomakay yan sang bangka aw yamondang dayon yang samut. Yatingaa da yang mga inindowan nan ");
INSERT INTO kqew_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kay maskin kinita nilan yang ininang ni Isa na pyakan nan yang 5000 na mga otaw, wa silan pakasabot sang mana ng kinita nilan kay mabagsug yang oo nilan. ");
INSERT INTO kqew_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ansinyan pagtaripag da nilan sang linaw, dyomatung silan sang banwa ng Ginisarit aw adto da silan pagadonggo. ");
INSERT INTO kqew_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagpanaog nilan sang bangka, yakilaa dayon si Isa ng mga otaw ansan. ");
INSERT INTO kqew_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Agaw yanagdaagan silan adto sang makilibot na mga banwa untak patigamun nilan yang mga otaw na iyan da si Isa. Ansinyan dyaa da nilan yang mga masakitun na yakabutang sang kowangan adto sidtong banwa daw wain si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Agaw, maskin wain akadto si Isa, daw sang mga baryo atawa longsod atawa sang mga sityo adto sang bokid, dyaa nilan yang mga masakitun adto sang palengke na pyagakatiponan ng mga otaw. Aw yagapangayo-ngayo silan kang Isa na kong mapakay takmagan ng mga masakitun maskin yang sagayadan da gaid ng kanan dagom. Aw yang kariko na yakatakmag ng dagom nan yamadyaw. ");
INSERT INTO kqew_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ansinyan aon mga Parisi aw mga magiindoway ng Hokoman sikun sa Awrosalam na yanagkatipon adto kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kinita nilan na yang kadaigan ng mga inindowan ni Isa yanagpangan na wa silan pakapangonaw. Aw sang dumduman nilan batar kono silan. ");
INSERT INTO kqew_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kay yang mga Parisi aw maskin oman yang kariko ng mga Yahodi, di silan makan kong wa pa silan pakapangonaw sobay sang kabatasanan ng kaompowan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pag-ori nilan sikun sang palengke, di oman silan makan kong wa pa silan pakapangonaw. Na, madaig pa yang mga sogowan ng kaompowan nilan na pyangagadan nilan na mag-onawa ng pagpangogas ng mga baso, mga koon aw yang mga ladya na bronsi. ");
INSERT INTO kqew_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Agaw adon, yang mga Parisi kipat yang mga magiindoway ng Hokoman, yaga-osip silan kang Isa, “Nanga wa apangagad yang mga inindowan mo sang kabatasanan ng kaompowan ta? Nanga yakan silan na wa silan pakapangonaw?” ");
INSERT INTO kqew_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tyomobag si Isa, “Kamo na yagapakita-kita gaid na yagapangagad sang Tohan! Bunna sagaw yang pyaglaongan ng Tohan makapantag kamayo pina-agi kang Nabi Isayas. Kay yakasorat sang Kitab na yagalaong yang Tohan, “ ‘Yani na mga otaw yagapoji kanak sang baba gaid nilan, awgaid mawat kanak yang pangatayan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Way siyat yang pag-ibada nilan kanak kay yang pyaga-indo nilan mga sogowan na ininang gaid ng otaw, awgaid laong nilan na sogowan kono inyan ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Idto sagaw,” laong ni Isa, “tyarikodan da mayo yang sogowan ng Tohan aw yang pyangagadan mayo yang kabatasanan ng otaw.” ");
INSERT INTO kqew_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yagalaong oman si Isa, “Matigam sagaw kamo mag-inang ng daan untak kataripundaan mayo yang sogowan ng Tohan aw kapangagadan mayo yang pyaga-indo ng kaompowan mayo. ");
INSERT INTO kqew_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kay maynini yang pyaglaongan ng Tohan na yakasorat sang Hokoman ni Nabi Mosa, laong nan, ‘Addati mayo yang ama aw ina mayo.’ Aw ‘sino-sino yang magalaong ng maat adto sang ama atawa ina nan, dait yan patayun.’ ");
INSERT INTO kqew_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Awgaid tuna yang pyaga-indo mayo kay yagalaong kamo na yang otaw na magalaong adto sang ama atawa ina nan na ‘Yang tabang na i-atag ko gao kammo korban da,’ mana nan na yatag da kono nan adto sang Tohan, ");
INSERT INTO kqew_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na, kong maynan, mapakay na di da nan atabangan yang taganak nan. ");
INSERT INTO kqew_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Agaw, sabap sang kabatasanan ng kaompowan mayo na pyaga-indo oman mayo sang mga otaw, tyaripundaan da mayo yang sogowan ng Tohan. Aw madaig pa yang ininang mayo na mag-onawa sinyan.” ");
INSERT INTO kqew_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ansinyan tyawag da oman ni Isa yang mga otaw na domood silan kanan aw pyagalaong nan silan, laong nan, “Paningug kamo obos, aw sabota mayo yang ipaglaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yang makabatar sang otaw dili ng pagkan na ilasak nan sang baba nan kondi yang maat na pyaglaongan na malogwa sikun sang baba nan. ");
INSERT INTO kqew_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatapos sinyan pyanawan ni Isa yang mga otaw aw syomuud yan sang sambok na baay. Ansinyan yanag-osip kanan yang mga inindowan nan daw ono yang mana ninyan na pasombingay. ");
INSERT INTO kqew_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yagalaong si Isa, “Na, maskin oman kamo, wa kadi kamo pakasabot? Wa kadi kamo akatigam na yang maskin ono na akanun ng otaw di amakabatar kanan? ");
INSERT INTO kqew_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kay yang pagkan di amalasak sang pangatayan kondi sang tongoo aw malogwa da oman sikun sang lawas.” Na, sabap sinyan na pyaglaongan ni Isa pyatigam nan kanilan na halal yang kariko ng pagkan. ");
INSERT INTO kqew_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yagalaong oman si Isa, “Na, yang magasikun sang pangatayan ng otaw, yan yang amakabatar kanan. ");
INSERT INTO kqew_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay sikun sa suud ng pangatayan ng otaw yang maat na dumduman na mag-onawa ng pag-inang ng kadopangan, pagpangawat, pagpatay sang otaw aw yang pagjina. ");
INSERT INTO kqew_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Adto oman magasikun yang napso sang mga butang ng kadaigan, pag-inang ng kaatan, pagpanlimbong, pagkasina, pagpitna, pagpasigarbo aw yang pag-inang ng maskin ono na kamasiyatan aw kasanguan. ");
INSERT INTO kqew_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yang kariko nini na kaatan magasikun sang pangatayan ng otaw, aw yani yang amakabatar kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ansinyan pyomanaw si Isa ansan aw kyomadto yan sang logar na masaid sang syodad ng Tiros. Pagdatung nan adto, pyomanik yan sang sambok na baay, awgaid di nan karim na akatigaman ng mga otaw na iyan yan. Awgaid di sagaw matago. ");
INSERT INTO kqew_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na, aon sambok na bobay ansidto na yang anak nan na bobay kyasaytanan. Pagdungug nan na iyan si Isa, kyomadto dayon yan aw syomojod sa atobangan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na, yani na bobay dili ng Yahodi awgaid taga Piniki na sakop ng Siriya. Yaga-angyo yan kang Isa na palogwaun nan yang saytan sikun sang anak nan. ");
INSERT INTO kqew_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Awgaid yagalaong kanan si Isa ng pasombingay, laong nan, “Dait na ona pakanun yang mga isu kay dili ng madyaw aw kamangun yang pagkan ng mga isu aw idami adto sang mga ido.” ");
INSERT INTO kqew_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tyomobag yang bobay, “Bunna sagaw, kay Sir. Awgaid maskin yang mga ido sa saad ng lamisa makakan ng yamasama ng mga isu.” ");
INSERT INTO kqew_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ansinyan yagalaong kanan si Isa, “Sabap sang kammo tobag yamadyaw da yang anak mo. Maka-ori da kaw kay pyanawan da ng saytan yang anak mo.” ");
INSERT INTO kqew_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agaw yamori da yang bobay. Aw pagdatung nan sang baay, kinita nan yang anak nan na yagakowang sang kowangan na pyanawan da ng saytan. ");
INSERT INTO kqew_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ansinyan pyomanaw da oman si Isa sikun sidtong logar na sakop ng Tiros. Sang pagpanaw nan yamagi yan sa Sidon, tapos pyomanaos yan adto sang Linaw ng Jalil sang logar na sakop ng probinsya ng Dikapolis. ");
INSERT INTO kqew_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Adon, aon mga otaw ansidto na yagadaa adto kanan ng sambok na otaw na bunguu aw amang aw yaga-angyo silan kanan na dapunan nan idtong otaw ng arima nan. ");
INSERT INTO kqew_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ansinyan pyagalain yan ni Isa sang kadaigan na mga otaw aw lyasak nan yang kanan tollo sang taringa nan. Pagkatapos, tyobadan nan yang tollo nan aw dyoritan nan ng laway yang dila sinyan na otaw. ");
INSERT INTO kqew_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ansinyan ya-angad si Isa sang langit, yaganapas ng maum aw yagalaong sinyan na otaw, “Ipata!” na yang mana nan, “Pagboka da!” ");
INSERT INTO kqew_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na, yakadungug dayon inyan na otaw aw yakapaglaong da yan ng madyaw kay wa da adukut yang dila nan. ");
INSERT INTO kqew_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ansinyan syagda ni Isa yang mga otaw na di silan maggogod sang maskin sino ng makapantag sinyan. Awgaid maskin monono yang pagsagda nan kanilan, labi da yang paggogod nilan adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na, yangkatingaa da yang mga otaw na yakadungug sinyan aw laong nilan, “Madyaw sagaw yang kariko ng ininang nan. Maskin yang mga bunguu pyadungug nan aw yang mga amang pyapaglaong nan.” ");
INSERT INTO kqew_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wa akadogay sinyan yanagkatipon da oman yang madaig na mga otaw adto kang Isa. Nang kya-obosan silan ng pagkan, pyadood ni Isa yang mga inindowan nan aw paglaonga silan, ");
INSERT INTO kqew_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yamaooy ako sini na mga otaw kay too pang allaw na yamagad silan kanak aw adon waa day pagkan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aw pa-oriun ko silan na yamangkagutum, basin aon amalangot kanilan sang daan kay mawat yang pyagasikunan ng kadaigan kanilan.” ");
INSERT INTO kqew_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yagalaong kanan yang mga inindowan nan, “Wain kita makakamang ng ipakan kanilan sini na banwa na mamingaw?” ");
INSERT INTO kqew_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Pilambok yang pan mayo ansan?” yaga-osip kanilan si Isa. Tyomobag silan, “Pitombok da.” ");
INSERT INTO kqew_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ansinyan pya-ingkod ni Isa yang mga otaw sang lopa. Kyamang nan yang pitombok na pan aw panginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan aw atagan sang mga inindowan nan untak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aon oman pipila na mangkayantuk na isda nilan. Pagkatapos ni Isa manginsokor, syogo nan yang mga inindowan nan na ipangatag oman adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ansinyan kyoman da yang kariko ng mga otaw aw yamangkabiyag silan. Pagkatapos nilan koman, tinipon ng mga inindowan yang yamasama na pagkan, aw pitombok yang bokag na yamapono da. ");
INSERT INTO kqew_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na, yang kadaig ng yakakan, mga 4000. Ansinyan pya-ori da ni Isa yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagkatapos syomakay yan sang bangka upud sang mga inindowan nan aw kyomadto silan sang banwa ng Dalmanota. ");
INSERT INTO kqew_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagdatung nilan ansan, aon mga Parisi na dyomood kang Isa kay mapaglalis gao silan kanan. Karim nilan magtigi kanan, agaw yagapangayo silan kanan ng katingaan silbi tanda na syogo yan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ansinyan yaganapas si Isa ng maum aw laong nan kanilan, “Nanga yabay mangayo ng tanda yang mga otaw adon na panahon? Ipaglaong ko kamayo na way gaid tanda na ipakita ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ansinyan pyanawan da silan ni Isa upud sang mga inindowan nan. Byomarik silan sang bangka aw tyomaripag da oman silan sang linaw. ");
INSERT INTO kqew_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Adon, yang mga inindowan ni Isa yakaringaw magdaa ng baon nilan. Way pagkan nilan sang bangka yatabiya yang sambok gaid na pan. ");
INSERT INTO kqew_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo sang labadora ng mga Parisi aw ni Soltan Hirod.” ");
INSERT INTO kqew_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ansinyan yanagbaaw-baaw silan aw laong nilan, “Basin maynidto yang pyagalaong nan kay wa kita pagadaa ng pan.” ");
INSERT INTO kqew_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Awgaid kyatigaman ni Isa yang pyagabaawan nilan. Agaw yagalaong yan kanilan, “Nanga yanagbaaw-baaw kamo na way yamadaa mayo na pan? Wa pa kadi kamo pakasabot? Mairap kadi kamo pag-indowan. ");
INSERT INTO kqew_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aon mata mayo, awgaid di kamo makakita. Aon taringa mayo, awgaid di kamo makadungug. Kyaringawan da mayo ");
INSERT INTO kqew_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yang pagpisang-pisang ko ng limambok na pan untak makakan yang 5000 na mga otaw? Pilambok yang bokag na yamapono ng yamasama na tinipon mayo?” Tyomobag silan, “Sampoo aw dowa.” ");
INSERT INTO kqew_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Laong oman ni Isa, “Sang pagpisang-pisang ko ng pitombok na pan untak makakan yang 4000 na mga otaw, pilambok yang bokag na yamapono mayo ng yamasama?” Tyomobag silan, “Pito.” ");
INSERT INTO kqew_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na,” laong nan, “nanga wa pa kamo pakasabot na dili ng pan yang karim ko ipasabot?” ");
INSERT INTO kqew_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ansinyan pagdatung nilan sang baryo ng Bitsayda, aon mga otaw na yagadaa ng bota adto kang Isa aw yaga-angyo silan kanan na dapunan nan yang bota ng arima nan. ");
INSERT INTO kqew_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ansinyan tyakmagan ni Isa yang arima ng bota aw pag-agadan nan adto sa logwa ng baryo. Ansidto tyobadan ni Isa yang mata ng bota aw dapuni nan ng arima nan. Ansinyan yosip ni Isa yang bota, “Aon day kinita mo?” ");
INSERT INTO kqew_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ya-angad yang otaw aw laong nan, “Makakita da ako ng mga otaw na yagapanaw-panaw, awgaid main silan ng kaoy.” ");
INSERT INTO kqew_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agaw dyapun da oman ni Isa yang arima nan sang mata ng bota. Na, pagtanaw nan, yakakita da yan aw matinaw da yang kanan pananaw. ");
INSERT INTO kqew_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ansinyan pya-ori yan ni Isa aw laong nan kanan, “Ori da, awgaid ayaw pag-apit adto sang baryo.” ");
INSERT INTO kqew_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ansinyan pyomanaos si Isa aw yang mga inindowan nan adto sang mga baryo na masaid sang longsod ng Kisariya Pilipi. Sarta yagapanaw silan yaga-osip si Isa sang mga inindowan nan, laong nan, “Sobay sang mga otaw, sino kono ako?” ");
INSERT INTO kqew_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas, aw yang kadaigan oman yagalaong na ikaw kono yang sambok na nabi singaon.” ");
INSERT INTO kqew_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Awgaid kamo,” laong ni Isa, “ono yang ikapaglaong mayo daw sino ako?” Tyomobag si Pitros, “Ikaw yang Almasi.” ");
INSERT INTO kqew_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ansinyan syagda silan ni Isa na di silan maggogod sang maskin sino daw sino yan. ");
INSERT INTO kqew_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ansinyan yagasogod si Isa mag-indo sang mga inindowan nan aw yagalaong yan kanilan, “Ako na Anak ng Manosiya, dait na amagi ako ng mga kasikotan. Ataripundaan ako ng mga pangoo ng mga Yahodi, yang mga pangoo ng mga imam kipat yang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoo na allaw amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na, mapayag kanilan yaning pyaglaongan ni Isa. Agaw pagdungug sinyan ni Pitros, pyaga-agad nan si Isa sang mawat-awat sang kadaigan aw sagdaa nan na di yan maglaong ng mayninyan. ");
INSERT INTO kqew_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Awgaid yaga-atobang si Isa sang mga inindowan nan aw kyadamanan nan si Pitros, laong nan, “Panaw da, kay Iblis! Kay yang dumduman mo dili ng kahanda ng Tohan kondi yang dumduman gaid ng manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ansinyan tyawag ni Isa yang mga otaw kipat yang mga inindowan nan untak domood silan kanan aw yagalaong yan kanilan, “Sino-sino yang marim magpangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqew_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kay sino-sino na pyalabi nan yang kanan kinabowi, akawaan ninyan. Awgaid sino-sino na pyalabi nan yang pagpangagad nan kanak aw yang pagpayapat ng Madyaw na Gogodanun maskin idto yang ikamatay nan, aka-aonan ng bunna na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kay ono yang amakamang ng otaw kong amakun nan yang kariko ng kakawasaan adi sang donya, awgaid sang pagkamatay nan asiksaun yan adto sang narka? ");
INSERT INTO kqew_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay way ika-atag nan untak ka-aonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na, bali na kaat ng mga otaw adon na panahon aw yagapakawat silan sang Tohan. Sino-sino yang yamomowa maglaong sa atobangan sini na mga otaw na yagapangagad yan kanak kipat yang indowan ko, ikamomowa ko oman yan sang wakto na mabarik ako na Anak ng Manosiya adi sang donya sang kasiga ng kanak Ama na yagadan ako ng mga malaikat.” ");
INSERT INTO kqew_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ansinyan yagalaong oman si Isa adto sang mga inindowan nan, “Bunna yang ipaglaong ko kamayo na aon mga otaw disini na di pa amatay taman sang akitaun nilan na magadato da yang Tohan sang kanan kabarakat.” ");
INSERT INTO kqew_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, paglabay ng unum na allaw sikun sinyan pyaga-agad ni Isa si Pitros, si Yakob aw si Yahiya aw syomakat silan sang makagwas na butay na silan da gaid. Adto sa taas sarta yagatanaw silan kang Isa, yaparin yang parangay nan. ");
INSERT INTO kqew_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yang kanan dagom yagakapoti aw masilaw na way main da nan na kapoti adi sa babawan ng donya. ");
INSERT INTO kqew_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sakadyap yagapakita kanilan si Nabi Mosa aw si Nabi Iliyas aw yapagbaaw silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ansinyan yagalaong si Pitros kang Isa, “Kay Goro, madyaw na adi kami sini. Maga-inang kami ng toombok na lagkaw, yang sambok kammo, yang sambok kang Nabi Mosa aw yang sambok oman kang Nabi Iliyas.” ");
INSERT INTO kqew_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Maynini yang pyaglaongan nan kay wa yan akatigam daw ono yang dait nan ipaglaong kay labi da yang alluk nan kipat oman yang mga kaupudanan nan. ");
INSERT INTO kqew_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ansinyan aon yama-aon na gabon aw kyatabonan silan ninyan. Aw aon yadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang pyasaya ko na Anak. Paningug kamo kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ansinyan pagpanlingi nilan, waa day kinita nilan na kadaigan na sangka otaw da gaid ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ansinyan paglodsad nilan sikun sang butay, syagda silan ni Isa aw laong nan, “Ayaw kamo paggogod sang maskin sino yang kinita mayo taman sang amabowi oman ako na Anak ng Manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Agaw wa silan pagagogod ninyan sang kadaigan. Awgaid silan too, yanag-inosipay silan daw ono yang mana ng pyaglaongan nan na amabowi oman yan. ");
INSERT INTO kqew_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ansinyan yaga-osip silan kang Isa, “Nanga yagalaong yang mga magiindoway ng Hokoman na madatung ona si Nabi Iliyas bago pa yang Almasi?” ");
INSERT INTO kqew_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tyomobag si Isa, “Bunna sagaw na madatung ona si Nabi Iliyas kay dadayawon nan yang kariko. Na, kong maynan, nanga yakasorat sang Kitab na ako na Anak ng Manosiya dait amagi ng kasikotan aw ataripundaan ng mga otaw? ");
INSERT INTO kqew_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Awgaid ipaglaong ko kamayo na dyomatung da si Nabi Iliyas aw ininang kanan ng mga otaw yang maskin ono na kyallinian nilan mag-onawa ng yakasorat sang Kitab makapantag kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ansinyan pagbarik nilan adto sang kadaigan na mga inindowan, kinita nilan na madaig yang mga otaw na yanaglibot kanilan. Aon oman mga magiindoway ng Hokoman na yapaglalis kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkita ng mga otaw kang Isa, yatingaa silan aw dyomaagan dayon silan adto kanan aw panagsalam. ");
INSERT INTO kqew_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ansinyan yaga-osip si Isa kanilan, “Ono yang pyagalalisan mayo?” ");
INSERT INTO kqew_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aon isa sang mga otaw na yatobag, “Kay Goro, dyaa ko adi kammo yang anak ko na usug kay kyasaytanan yan aw di da yan makapaglaong. ");
INSERT INTO kqew_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada wakto na suudan yan ng saytan, amatowad yan sang lopa, magabowa yang baba nan, mangolitub yang onto nan aw amatoskig yang lawas nan. Pyangayo da ko sang mga inindowan mo na palogwaun nilan yang saytan, awgaid di silan makagaga.” ");
INSERT INTO kqew_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yagalaong si Isa sang mga otaw, “Astaga! Kamo na mga otaw adon na panahon, waa sabay pagpangintoo mayo! Kadogay da ako adi kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi kanak yang isu.” ");
INSERT INTO kqew_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Agaw dyaa nilan adto kanan yang isu. Pagkita ng saytan kang Isa, pyakorog dayon nan yang isu. Yatowad yan aw yagaligid-ligid sang lopa na yagabowa yang kanan baba. ");
INSERT INTO kqew_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaga-osip si Isa sang ama ng isu, “Yadogay da ba yani na isu ng mayninyan?” Tyomobag yang ama, “Uu, sokad ng tagbi pa yan. ");
INSERT INTO kqew_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Idami yan maag ng saytan adto sang atoon aw adto oman sang tobig untak yan matay. Awgaid kong aon ma-inang mo, mallat kaw kanami aw tabangi kami!” ");
INSERT INTO kqew_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yagalaong kanan si Isa, “Nanga yagalaong kaw na kong aon ma-inang ko? Yang maskin ono ma-inang sidtong otaw na aon pagpangintoo.” ");
INSERT INTO kqew_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yagalaong dayon yang ama ng isu, “Yagapangintoo ako, awgaid kolang pa. Tabangi ako untak kadogangan pa yang pagpangintoo ko.” ");
INSERT INTO kqew_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Adon, pagkita ni Isa na madaig yang mga otaw na yagapaduug adto kanan, syagda nan yang saytan aw laong nan, “Ikaw na saytan na maka-amang aw makabunguu, panawi adon yani na isu aw ayaw da pagbarik kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ansinyan yagapiyagit yang saytan, pyakorog nan yang isu aw lyomogwa. Paglogwa ng saytan, maynang patay da yang isu. Agaw yagalaong yang kadaigan, “Patay da yan.” ");
INSERT INTO kqew_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Awgaid tyakmagan ni Isa yang arima ng isu aw pa-induga nan. Ansinyan yamindug da yang isu. ");
INSERT INTO kqew_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, pagsuud ni Isa sang baay, yaga-osip kanan yang mga inindowan nan nang silan da gaid, laong nilan, “Nanga wa kami pakapalogwa ng saytan?” ");
INSERT INTO kqew_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tyomobag si Isa kanilan, “Yang mayninyan na klasi na saytan di mapalogwa yatabiya pina-agi sang pagdowaa.” ");
INSERT INTO kqew_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ansinyan pyomanaw si Isa kipat yang mga inindowan nan sikun sidto na banwa aw yamagi silan sang probinsya ng Jalil. Dili karim ni Isa na akatigaman ng mga otaw daw wain yan ");
INSERT INTO kqew_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay yaga-indo yan sang mga inindowan nan. Yagalaong yan kanilan, “Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot aw apatayun ako nilan. Awgaid sang ikatoo na allaw sikun sang kanak pagkamatay amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Awgaid wa silan pakasabot sidto na pyaglaongan nan. Aw yamalluk silan mag-osip kanan. ");
INSERT INTO kqew_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ansinyan dyomatung da silan sang longsod ng Kapirnaom. Nang iyan da silan sang baay, yaga-osip si Isa sang mga inindowan nan, “Ono yang pyagalalisan mayo adto sang daan?” ");
INSERT INTO kqew_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Awgaid yagapakatingun gaid silan kay yanaglalis silan daw sino kanilan yang labaw. ");
INSERT INTO kqew_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ansinyan yamingkod si Isa, pyadood nan yang sampoo aw dowa na sahabat nan aw yagalaong yan kanilan, “Sino-sino yang mallini ma-inang ng labaw sang kadaigan, dait yan magpababa ng ginawa nan aw ma-inang ng sogowanun sang kariko.” ");
INSERT INTO kqew_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ansinyan kyamang ni Isa yang sambok na isu aw pa-induga nan sa atobangan nilan. Sinipit nan yang isu aw yagalaong yan kanilan, ");
INSERT INTO kqew_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sino-sino yang magatarima sang mga isu na main sini sabap sang pagpangagad nan kanak, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang Tohan na yagasogo kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ansinyan yagalaong si Yahiya kang Isa, “Kay Goro, aon kinita nami na otaw na yagapalogwa ng mga saytan na lyambit nan yang ngaan mo. Syagda nami yan kay di yan inagad natun.” ");
INSERT INTO kqew_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Awgaid yagalaong kanan si Isa, “Ayaw mayo yan pagsagdaa. Kay sino-sino yang maka-inang ng katingaan pina-agi sang kanak ngaan, di yan dayon makapaglaong ng maat makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kay yang maskin sino na di mapaglaban kanatun, matabang kanatun. ");
INSERT INTO kqew_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang magpa-inum kamayo ng maskin tobig gaid sabap ng yagapangagad kamo sang Almasi, sa way dowa-dowa abarasan yan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yagalaong oman si Isa, “Sino-sino yang ma-inang ng pyagasabapan na amakadosa yang maskin sambok sini na tagbi na mga isu na yagapangintoo kanak, madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw idami yan adto sang laod. ");
INSERT INTO kqew_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Idto sagaw, kong yang arima mo yang pyagasabapan na amakadosa kaw, otoda yan. Madyaw pa na ya-otod yang sangkilid na arima mo, awgaid aka-aonan kaw ng kinabowi na way kataposan kaysang dowambok yang arima mo awgaid idami kaw adto sang narka na yang atoon adto di amatay. ");
INSERT INTO kqew_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Mag-onawa sinyan, kong yang siki mo yang pyagasabapan na amakadosa kaw, otoda yan. Madyaw pa na ya-otod yang sangkilid na siki mo, awgaid aka-aonan kaw ng kinabowi na way kataposan kaysang dowambok yang siki mo awgaid idami kaw adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Aw kong yang mata mo yang pyagasabapan na amakadosa kaw, lusata yan. Madyaw pa na sambok gaid yang mata mo, awgaid amakasuud kaw sang sorga kaysang dowambok yang mata mo awgaid idami kaw adto sang narka. ");
INSERT INTO kqew_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kay adto sang narka way kataposan ng siksa kay yang mga iyas na yanagkutkut sang lawas ng mga otaw di amatay aw di oman amatay yang atoon.” ");
INSERT INTO kqew_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yagalaong oman si Isa, “Yang kariko ng mga otaw dait amagi ng kasikotan. Kay mag-onawa ng asin atawa atoon, yang kasikotan makakamang ng maskin ono na dili ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kyatigaman mayo na madyaw yang asin. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. Agaw, mag-onawa ng asin na makatabang kanatun, kinaanglan na magtinabangay kamo aw madyaw yang relasyon mayo sang matag-isa.” ");
INSERT INTO kqew_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ansinyan pyomanaw da si Isa sang probinsya ng Jalil aw kyomadto sang mga banwa sa Yahodiya aw adto oman sang dipag ng tobig ng Yordan. Madaig oman yang mga otaw na yanagkatipon adto kanan aw inindowan nan silan sobay sang kya-anadan nan. ");
INSERT INTO kqew_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ansinyan aon pilangka otaw na mga Parisi na dyomood kang Isa untak magtigi kanan. Yaga-osip silan, “Sobay sang Hokoman mapakay ba na buagan ng usug yang asawa nan?” ");
INSERT INTO kqew_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tyomobag si Isa aw laong nan “Ono yang sogo kamayo ni Nabi Mosa?” ");
INSERT INTO kqew_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tyomobag silan, “Tyogotan ni Nabi Mosa yang usug na maga-atag ng sorat sang asawa nan silbi tanda na yanagbuag da silan, aw ansinyan mapakay da nan buagan yang asawa nan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yagalaong si Isa kanilan, “Bunna sagaw yan, awgaid syorat ni Nabi Mosa yani na sogowan sabap ng mabagsug yang oo mayo. ");
INSERT INTO kqew_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Awgaid sang pukas ng pagbaoy ng Tohan sang donya, byaoy nan yang otaw na usug aw bobay. ");
INSERT INTO kqew_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sabap sinyan abiyaan ng usug yang kanan ama aw ina aw mupud sang asawa nan. ");
INSERT INTO kqew_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aw silan dowa magakasambok da. Agaw di da silan ng dowa kondi sambok da. ");
INSERT INTO kqew_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Idto sagaw, di mapakay pagpitasun ng otaw yang pyagakasambok ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ansinyan pagsuud nilan ni Isa sang baay na pyaga-uyaan nilan, yang mga inindowan da oman yang yaga-osip kang Isa makapantag sidto na pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yagalaong si Isa kanilan, “Sino-sino yang magabuag ng kanan asawa aw amangasawa ng lain, magajina. ");
INSERT INTO kqew_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mag-onawa sinyan, kong aon bobay na magabuag ng kanan bana aw magabana ng lain, magajina da oman yan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ansinyan aon mga otaw na yagadaa ng mangkatagbi na mga isu nilan adto kang Isa untak dapunan nan silan ng arima nan. Awgaid syagda silan ng mga inindowan. ");
INSERT INTO kqew_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkita sinyan ni Isa, yadaman yan aw yagalaong yan sang mga inindowan nan, “Pasagdi mayo yang mga isu na domood kanak. Kay yang mga otaw na main nilan yang amakasuud sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bunna yang ipaglaong ko kamayo. Sino-sino yang di magapasakop sang pagdato ng Tohan na mag-onawa ng isu, di yan amakasuud sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ansinyan sinipit ni Isa yang mga isu, dyapunan nan silan ng arima nan aw pyangayowan nan silan ng kadyawan adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ansinyan sang wakto na mallug da manaw si Isa sidto na banwa, aon sangka otaw na dyomaagan adto kanan. Lyomood yan sa atobangan nan aw yagalaong yan, “Kay Goro, madyaw kaw na otaw. Ono yang dait ko inangun untak ka-aonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqew_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tyomobag si Isa aw laong nan, “Nanga yagalaong kaw na ako madyaw? Yang Tohan gaid yang madyaw, aw way lain. ");
INSERT INTO kqew_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kyatigaman mo kowaw yang mga sogowan na yagalaong, ‘Ayaw pagpatay, ayaw pagjina, ayaw pagpangawat, ayaw pagsaksi ng bakak, ayaw pagpanlimbong aw addati yang ama aw ina mo.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Kay Goro,” laong ng otaw, “yang kariko ninyan tyoman da ko sikun pa sang pagka-isu ko.” ");
INSERT INTO kqew_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ansinyan pyagatanawan yan ni Isa na aon looy aw laong nan, “Isa pa yang dait mo inangun. Ori da aw barigyaan yang kariko ng kabutangan mo aw yang alin atagan sang mga miskinan. Ansinyan aka-aonan kaw ng kakawasaan adto sa sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagdungug sinyan, yamamingaw yan na otaw aw pyomanaw na yamarido yang ginawa nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqew_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ansinyan pyagatanawan ni Isa yang mga inindowan nan aw yagalaong yan kanilan, “Mairap sagaw sang mga sapian magpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na, yatingaa da yang mga inindowan sidto na pyaglaongan nan. Awgaid yagalaong oman si Isa, “Mga anak ko, mairap sagaw yang pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Masayun pa yang pag-agi ng kamel sang botas ng dagum kaysang pagpasakop ng sapian sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na, bali da na pagkatingaa ng mga inindowan aw yanag-inosipay silan, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqew_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ansinyan pyagatanawan silan ni Isa aw laong nan, “Sang manosiya, di yan ma-inang. Awgaid sang Tohan way mairap kay yang maskin ono ma-inang nan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ansinyan yagalaong kanan si Pitros, “Na, monono da kami adon? Ibiyaan da nami yang kariko aw yamagad kami kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Laong ni Isa, “Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang yagabiya ng kanan baay atawa mga lomon nan, ina aw ama, mga anak atawa lopa nan sabap sang pagpangagad nan kanak aw sabap oman sang pagpayapat ng Madyaw na Gogodanun, ");
INSERT INTO kqew_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","labaw pa sinyan yang amadawat nan adi sining donya na mag-onawa ng mga baay aw mga lomon, mga ina, mga anak, aw mga lopa maskin pa apasikotan oman yan. Aw adto sang ahirat aka-aonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Awgaid madaig yang mga otaw na yama-ona adon na amaori, aw madaig yang mga otaw na yamaori adon na ama-ona.” ");
INSERT INTO kqew_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ansinyan nang yagapaduug silan sa Awrosalam, yaga-ona kanilan si Isa. Yang mga inindowan nan yangkatingaa aw yang kadaigan pa na mga otaw na yamagad kanilan yangkalluk daw ono yang akatamanan sa Awrosalam. Ansinyan pyagalain da oman ni Isa yang sampoo aw dowa na mga sahabat nan kay pagalaongon nan silan daw ono yang amaitabo kanan adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Laong nan kanilan, “Paningug kamo. Makadto da kita sa Awrosalam. Ansidto adaun ako na Anak ng Manosiya adto sang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw magahokom da silan na apatayun ako. Ansinyan adaun nilan ako adto sang mga dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sangu-sanguun nilan ako aw atobadan, abadasan aw apatayun nilan ako. Awgaid sang ikatoo na allaw sikun sang kanak pagkamatay amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ansinyan dyomood kang Isa si Yakob aw si Yahiya na mga anak ni Sibidi aw laong nilan, “Kay Goro, aon apangayoon nami kammo na inangun mo kanami.” ");
INSERT INTO kqew_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yagalaong si Isa, “Ono yang karim mayo na inangun ko kamayo?” ");
INSERT INTO kqew_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tyomobag silan, “Sang wakto na magadato da kaw, karim nami na pa-ingkodon mo kami sang kilid mo, yang isa sang karinto mo, aw yang isa sang kawaa mo.” ");
INSERT INTO kqew_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Awgaid yagalaong si Isa kanilan, “Wa kamo akatigam daw ono yang pyangayo mayo. Ka-agian ba mayo yang kasikotan na agian ko? Aw masabar ba mayo yang kasakit na abatiun ko?” ");
INSERT INTO kqew_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tyomobag silan, “Uu, kaya nami.” Ansinyan yagalaong si Isa kanilan, “Bunna sagaw na agian mayo yang kasikotan na agian ko aw asabaran mayo yang kasakit na abatiun ko. ");
INSERT INTO kqew_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Awgaid way kapatot ko ipaglaong daw sino yang pa-ingkodon sang karinto aw kawaa ko, kay yang idto pyagakahanda ng kanak Ama sidtong mga otaw na pinili nan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, pagdungug sinyan ng sampoo na mga inindowan, yadaman silan kang Yakob aw si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Agaw pyadood ni Isa yang kariko ng mga inindowan nan aw paglaonga silan, laong nan, “Kyatigaman sagaw mayo yang batasan ansining donya na yang mga pangoo sang yagakatuna-tuna na bangsa magmando sang mga sakop nilan, aw yang mga yagadato kanilan magpakita ng kapatot nilan. ");
INSERT INTO kqew_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Awgaid kamo, dili gao ng maynan yang batasan mayo. Kay sino kamayo yang mallini ma-inang ng makagwas, dait yan ma-inang ng sogowanun mayo. ");
INSERT INTO kqew_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aw sino yang mallini ma-inang ng labaw sang kariko, dait yan ma-inang ng allang sang kariko. ");
INSERT INTO kqew_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kay maskin ako na Anak ng Manosiya, wa ako akani ansining donya untak tabangan ako ng mga otaw, kondi untak matabang ako kanilan aw magpakamatay ako untak lowasun ko yang madaig na mga otaw sikun sang mga dosa nilan.” ");
INSERT INTO kqew_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ansinyan dyomatung si Isa aw yang mga inindowan nan adto sang longsod ng Ariha. Pagpanaw da oman nilan, madaig yang mga otaw na yamagad kanilan. Na, adto sang daan na ya-agian nilan aon sangka otaw na bota na yaga-ingkod ansan aw yagapakilimos. Yang ngaan nan si Bartimiyos na anak ni Timiyos. ");
INSERT INTO kqew_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagdungug nan na si Isa na taga Nasarit yang yalabay, yagapiyagit yan aw laong nan, “O kay Isa, Anak ni Daud, kallati ako!” ");
INSERT INTO kqew_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ansinyan syagda yan ng mga otaw untak magpakatingun. Awgaid lomban da yan magpiyagit aw laong nan, “Anak ni Daud, kallati ako!” ");
INSERT INTO kqew_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ansinyan yamondang si Isa pagpanaw aw laong nan, “Pakadia yan kanak.” Agaw tyawag ng mga otaw yang bota aw laong nilan, “Kasowat da aw pag-indug kay tyawag kaw ni Isa.” ");
INSERT INTO kqew_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na, dyami dayon ng bota yang syapaw nan aw indug aw dyomood yan adto kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yaga-osip si Isa kanan, “Ono yang karim mo na inangun ko kammo?” Tyomobag yang bota, “Kay Goro, karim ko makakita.” ");
INSERT INTO kqew_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yagalaong si Isa kanan, “Panaw da. Sabap sang pagpangintoo mo yamadyaw da kaw.” Ansinyan yakakita dayon yan aw yamagad yan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Adon nang masaid da silan sa Awrosalam aw iyan da silan sang mga baryo ng Bitpagi aw Bitani na adto sang Butay na Jayton, pya-ona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqew_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Pagsuud mayo ansan, aon makita mayo na nati ng asno na inikutan na wa pa gaid akasakayi. Obadi mayo aw daa adi kanak. ");
INSERT INTO kqew_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kong aon maga-osip kamayo daw onoon mayo yan, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato. Ipa-ori da oman nan mallaw.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, pyomanaw da yang dowa na inindowan aw pagdatung nilan sidtong baryo, kinita nilan yang nati ng asno sang kilid ng daan na inikutan sang powertaan ng sambok na baay. Ansinyan yobadan da nilan. ");
INSERT INTO kqew_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nang yaga-obad pa silan ng asno, yosip silan ng mga otaw na yaga-indug ansan, laong nilan, “Oy, ono yang ininang mayo? Nanga yobadan mayo yang asno?” ");
INSERT INTO kqew_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na, tyobag da nilan yang mga otaw sobay sang pyaglaongan kanilan ni Isa. Aw pyasagdan da silan ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ansinyan dyaa da nilan yang nati ng asno adto kang Isa, yampasan nilan ng mga dagom nilan aw syomakay da si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na, madaig yang mga otaw na yagabutang ng mga dagom nilan sang daan na agian ni Isa. Yang kadaigan oman, pyakanat nilan sang daan yang mga sanga na madaig yang daon na pyangotod nilan adto sang lati. ");
INSERT INTO kqew_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yang mga otaw na yaga-ona kang Isa aw yang mga yagasonod kanan yagapiyagit aw laong nilan, “Pojiun ta yang Tohan! Atagan gao ng kadyawan yani na syogo ng Tohan! ");
INSERT INTO kqew_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Atagan gao ng kadyawan yang magasalinti kang Soltan Daud na kanatun ompo! Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqew_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ansinyan pagdatung ni Isa sa Awrosalam, syomuud yan sang Baay ng Tohan aw pyagatanawan nan yang kariko adto sa suud. Awgaid sabap ng ambong da pyomanaw da yan upud sang sampoo aw dowa na mga sahabat nan aw barik silan sang banwa ng Bitani. ");
INSERT INTO kqew_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagka-ilaw sinyan nang yagapanaw da oman silan sikun sa Bitani paduug sa Awrosalam, yamagutum si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ansinyan aon kinita nan sang onaan na kaoy na igira na madaig yang daon. Kyadtonan nan inyan kay atanawon nan daw aon bonga. Pagdatung nan ansan, way kinita nan na bonga kondi mga daon gaid kay di pa ng wakto na mabonga yang igira. ");
INSERT INTO kqew_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ansinyan pyaminta ni Isa idtong kaoy aw laong nan, “Sikun adon waa day makakan ng bonga mo.” Aw yakadungug sinyan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ansinyan pagdatung nilan sa Awrosalam, syomuud si Isa sang Baay ng Tohan aw yagasogod yan magpalogwa ng mga otaw na yanagbarigya aw yamamili ansan. Pyagatowad nan yang mga lamisa ng mga yagakambiyo ng sapi aw yang mga ingkodanan ng yagabarigya ng mga malapati. ");
INSERT INTO kqew_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aw wa nan atogoti yang maskin sino na aon dyaa na mga butang na amagi sang pamanag ng Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ansinyan yaga-indo si Isa aw laong nan sang mga otaw, “Yakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa para sang kariko ng mga bangsa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan.” ");
INSERT INTO kqew_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yadungug nilan yang makapantag sidtong ininang ni Isa. Aw sikun sinyan na wakto yagapanganap silan ng pama-agi ng pagpatay kanan. Yamalluk silan kang Isa kay yang kariko ng mga otaw yatingaa sang pag-indo nan. ");
INSERT INTO kqew_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ansinyan nang ambong da, pyomanaw da si Isa sikun sa Awrosalam upud sang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagka-ilaw sinyan sarta yagabarik silan adto sa Awrosalam, yamagi oman silan sidtong kaoy na igira aw kinita nilan na yagango da maskin pa yang mga gamot nan. ");
INSERT INTO kqew_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ansinyan kyadumduman ni Pitros yang pyaglaongan ni Isa sidto na kaoy aw yagalaong yan kang Isa, “Kay Goro, tanawa pagaw yani na igira na pyaminta mo, yagango da!” ");
INSERT INTO kqew_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tyomobag si Isa, “Pagpangintoo kamo sang Tohan! ");
INSERT INTO kqew_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang magalaong sini na butay, ‘Ballin adto sang dagat,’ aw di yan magdowa-dowa kondi mangintoo na amatoman yang pyaglaongan nan, ma-inang sagaw yan. ");
INSERT INTO kqew_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Agaw ipaglaong ko kamayo na yang maskin ono na apangayoon mayo adto sang Tohan, kong mangintoo kamo na dyawat da mayo yang pyangayo mayo, amadawat da sagaw mayo. ");
INSERT INTO kqew_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na, kong magadowaa kamo awgaid yadaman pa kamo sang yamakadosa kamayo, ampona mayo ona yan untak amponon oman yang mga dosa mayo ng Tohan na Ama mayo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Awgaid kong di mayo amponon yang yakadosa kamayo, di oman amponon yang mga dosa mayo ng Tohan na Ama mayo adto sa sorga.” ");
INSERT INTO kqew_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ansinyan dyomatung da oman silan sa Awrosalam. Nang yagapanaw-panaw si Isa adto sa suud ng Baay ng Tohan, dyomood kanan yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yaga-osip silan kanan, “Ono yang kapatot mo sang pag-inang sidto na mga butang? Sino yang yaga-atag kammo sini na kapatot?” ");
INSERT INTO kqew_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tyomobag si Isa, “Aon oman osip ko kamayo. Kong matobag mayo, ipaglaong ko oman kamayo daw wain pagasikun yang kapatot ko sang pag-inang sidto na mga butang. ");
INSERT INTO kqew_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na, paglaonga ako daw wain pagasikun yang kapatot ni Yahiya pagsogbo sang mga otaw, sikun sang Tohan atawa yang manosiya?” ");
INSERT INTO kqew_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ansinyan yanagbaaw-baaw silan daw ono yang itobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun ‘Na, nanga wa kamo apangintoo kanan?’ ");
INSERT INTO kqew_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, magaproblima da kita.” Kay yamalluk silan sang mga otaw kay yang kariko nilan yagapangintoo na bunna na nabi si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Agaw tyomobag silan, “Wa nami akatigami.” Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain pagasikun yang kapatot ko sang pag-inang sidto na mga butang.” ");
INSERT INTO kqew_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ansinyan yagalaong si Isa kanilan ng pasombingay, laong nan, “Aon otaw na aon kanan lopa na pyagatanuman nan ng grips. Pyakoral nan inyan aw yagapa-inang yan ng pagapugaan ng grips aw yagapatokod pa yan ng makagwas na baay untak bantayan yang tanumanan. Ansinyan pya-atiman nan yang kanan tanumanan sang mga sinarigan aw pyomanaw adto sang mawat na banwa. ");
INSERT INTO kqew_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sang panahon ng pagpangipo da ng grips, syogo ng tagtomon yang sangka otaw na sogowanun nan adto sang mga sinarigan untak kamangun nan yang kanan bain ng abot. ");
INSERT INTO kqew_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Awgaid pagdatung nan sang tanumanan, dyakup yan ng mga sinarigan, byonalan yan aw pya-ori ng way daa. ");
INSERT INTO kqew_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ansinyan yagasogo da oman yang tagtomon ng sambok oman na sogowanun adto sang mga sinarigan. Awgaid pyakamomowaan nilan yan aw byonalan nilan sang oo nan. ");
INSERT INTO kqew_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ansinyan yagasogo da oman yang tagtomon ng isa pa na sogowanun adto kanilan, awgaid pyatay nilan yan. Na, madaig pa yang syogo ng tagtomon adto kanilan, awgaid yang kadaigan byonalan nilan aw yang kadaigan oman pyatay nilan. ");
INSERT INTO kqew_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Adon, sangka otaw dakoman yang yamabilin na amasogo ng tagtomon na yan yang pyasaya nan na anak. Sang kataposan, syogo nan yang kanan anak kay yagalaong yan sang ginawa nan, ‘Sa way dowa-dowa addatan nilan yan.’ ");
INSERT INTO kqew_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amakun sang tanumanan. Unda, apatayun ta yan untak kanatun da yang kabilin kanan.’ ");
INSERT INTO kqew_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Idto sagaw, dyakup nilan yan aw pyatay nilan, aw dyami nilan yang lawas nan adto sa logwa ng tanumanan. ");
INSERT INTO kqew_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na adon,” laong ni Isa, “ono yang inangun ng tagtomon ng tanumanan sidtong mga sinarigan? Sa way dowa-dowa akadtonan aw apatayun nan silan aw ipa-atiman nan yang kanan tanumanan sang kadaigan pa na mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ansinyan yagalaong si Isa sang mga otaw, “Wa kadi mayo akabasa yang yakasorat sang Kitab na yagalaong, “ ‘Yang bato na dyami ng mga panday kay way kono kapantag, ya-inang kadi ng labi na barapantag. ");
INSERT INTO kqew_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yani yang ininang ng Tohan aw bali yan na katingaan.’ ” ");
INSERT INTO kqew_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ansinyan adakupun da gao si Isa ng mga pangoo ng mga Yahodi kay kyatigaman nilan na silan yang kyugdan ninyan na pasombingay. Awgaid way ma-inang nilan kay yamalluk silan sang kaotawan. Agaw pyasagdan da nilan si Isa aw pyomanaw silan. ");
INSERT INTO kqew_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ansinyan aon pilangka otaw na mga Parisi aw yang mga otaw ni Soltan Hirod na syogo nilan adto kang Isa untak magtigi kanan pina-agi sang mga osip. ");
INSERT INTO kqew_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pagdatung nilan kang Isa, yagalaong silan kanan, “Kay Goro, yamatigam kami na aag bunna yang pyagalaong mo. Di kaw magapili ng otaw na maskin ono yang ranggo nilan, awgaid aag kabunnaan yang pyaga-indo mo makapantag sang karim ng Tohan. Adon, paglaonga kami daw sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sa Roma atawa di? Dait ba kita magbayad atawa dili?” ");
INSERT INTO kqew_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Awgaid kyatigaman ni Isa yang toyo nilan, agaw yagalaong yan kanilan, “Kamo na yagapakita-kita gaid! Nanga karim mayo ako dakupun sang pyaglaongan ko? Atagan kanak yang sambok na sapi na pilak untak ko tanawon.” ");
INSERT INTO kqew_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ansinyan yatag nilan kanan yang sapi. Adon yosip silan ni Isa, “Kanino parangay aw ngaan yang yakabutang sini?” Tyomobag silan, “Kanang soltan sa Roma.” ");
INSERT INTO kqew_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ansinyan yagalaong si Isa, “Na, kong maynan, i-atag mayo sang soltan yang kanang soltan, aw i-atag oman mayo sang Tohan yang kanang Tohan.” Pagdungug nilan sinyan, bali na pagkatingaa nilan. ");
INSERT INTO kqew_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ansinyan aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. ");
INSERT INTO kqew_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yaga-osip silan kang Isa, “Kay Goro, aon syorat ni Nabi Mosa sang Hokoman na kong amatay yang usug ng way anak sang kanan asawa, dait na apangasawaun ng kanan lomon yan na biyoda untak ka-aonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqew_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Adon, aon pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. ");
INSERT INTO kqew_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Agaw, yang mangod na yagasonod kanan, pyangasawa nan inyan na biyoda awgaid yamatay da oman yan na way anak. Maynan oman yang ikatoo taman sang yamatay da yang pito na maglomon na way anak. ");
INSERT INTO kqew_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqew_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Adon,” laong nilan, “sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay kay yang kariko ng pito na maglomon yakapangasawa kanan?” ");
INSERT INTO kqew_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tyomobag si Isa aw laong nan kanilan, “Sayup yang dumduman mayo kay wa kamo pakasabot sang yakasorat sang Kitab aw wa oman mayo akatigami yang kabarakat ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sang wakto na amabowi oman yang mga patay, di da silan amangasawa atawa magabana kay mag-onawa da silan sang mga malaikat adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, makapantag sang mga patay na amabowi oman, wa mayo akabasa ng Kitab Tawrat na gogodanun makapantag sang tagbi na kaoy na yamallaga na yagalaong yang Tohan kang Nabi Mosa, laong nan, ‘Ako yang Tohan na pyagasambayangan ni Ibrahim, ni Isahak aw ni Yakob?’ ");
INSERT INTO kqew_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay. Na, sayup sagaw yang dumduman mayo.” ");
INSERT INTO kqew_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ansinyan aon sangka otaw na magiindoway ng Hokoman na yakadungug sidtong panaglalis nilan. Pagkita nan na madyaw yang tobag ni Isa adto sang mga Sadoki, dyomood yan aw yaga-osip yan kang Isa, “Wain na sogowan yang labaw sang kariko?” ");
INSERT INTO kqew_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tyomobag si Isa, “Yani yang sogowan na labaw sang kariko, ‘Kamo na bangsa Israil, paningug kamo! Yang Tohan na kanatun Tagallang, sambok da. ");
INSERT INTO kqew_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pakadakowaa yang Tohan na kammo Tagallang sang tibok mo na pangatayan, sang tibok mo na kallowa, sang tibok mo na dumduman aw sang tibok mo na kusug.’ ");
INSERT INTO kqew_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aw yani yang ikadowa na sogowan, ‘Kaoyi yang kapag-onawa mo mag-onawa ng looy mo sang ginawa mo.’ Way sogowan na labaw pa sining dowa.” ");
INSERT INTO kqew_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ansinyan yagalaong yang magiindoway ng Hokoman adto kang Isa, “Yan sagaw, kay Goro. Bunna yang kammo pyaglaongan na sambok da yang Tohan na kanatun Tagallang aw waa day lain. ");
INSERT INTO kqew_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bunna oman na dait natun pakadakowaun yang Tohan sang tibok natun na pangatayan, sang tibok natun na dumduman aw sang tibok natun na kusug. Aw dait natun kaoyan yang kapag-onawa ta mag-onawa ng looy sang ginawa ta. Labi na madyaw yang pagpangagad sining dowa na sogowan kaysang pagpasampay aw pagpakorban adto sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagkadungug ni Isa na madyaw yang kanan tobag, yagalaong yan kanan, “Masaid da kaw magpasakop ng pagdato ng Tohan.” Pagkatapos sinyan waa day yamangisug mag-osip pa kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ansinyan sarta yaga-indo si Isa adto sang Baay ng Tohan, yagalaong yan, “Nanga yagalaong yang mga magiindoway ng Hokoman na yang Almasi topo kono ni Soltan Daud? ");
INSERT INTO kqew_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kay sang wakto na pyagabuutan si Soltan Daud ng Nyawa ng Tohan yagalaong yan, “ ‘Yang Tohan yagalaong sang kanak Dato, “Pag-ingkod adi sang karinto ko sampay na ataloon ko yang mga kalaban mo aw ma-inang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqew_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, kong tyawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” Na, yamasowat sagaw yang kaotawan maningug sang pyaga-osiyat ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ansinyan sarta yaga-indo pa si Isa, yagalaong yan, “Pagbantay kamo sang mga magiindoway ng Hokoman kay kallini nilan mandagom ng mataas na dagom untak addatan silan ng mga otaw. Aw karim nilan na asalamun silan ng mga otaw adto sa palengke. ");
INSERT INTO kqew_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Adto oman sang pagsasambayangan, karim nilan mag-ingkod sang ingkodanan ng dakowa na mga otaw. Aw adto oman sang mga kandori, karim nilan mag-ingkod sang ingkodanan ng mga otaw na dait addatan. ");
INSERT INTO kqew_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pyasikotan nilan yang mga biyoda untak ma-agaw nilan yang kanilan kakawasaan. Aw pataasun nilan yang kanilan pagdowaa sa atobangan ng mga otaw untak magpakita silan na madyaw silan na mga otaw. Na, labi da yang siksa kanilan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ansinyan yamingkod si Isa sang masaid sang butanganan ng sapi adto sang Baay ng Tohan aw pyagatanawan nan yang mga otaw na yaga-oog ng sapi. Madaig yang mga sapian na yaga-oog ng dakowa na sapi. ");
INSERT INTO kqew_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Awgaid aon oman dyomatung na biyoda na miskin aw yaga-oog yan ng dowambok gaid na sinsilyo. ");
INSERT INTO kqew_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ansinyan tyawag ni Isa yang mga inindowan nan na domood kanan aw laong nan kanilan, “Sa bunna-bunna na ipaglaong ko kamayo na yani na biyoda na miskin yaga-atag ng labaw pa sidtong yatag ng kadaigan pa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay silan,” laong nan, “yaga-atag silan ng sapi sikun sang sobra nilan na kakawasaan. Awgaid yani na bobay, abir bali na kamiskin nan, yatag nan yang kariko ng kanan sapi maskin idto dakoman yang pagabili ng pagkan.” ");
INSERT INTO kqew_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ansinyan paglogwa ni Isa sikun sang Baay ng Tohan, aon sangka otaw na inindowan nan na yagalaong kanan, “Kay Goro, tanawa yani na Baay ng Tohan. Mangkadakowa yang mga bato aw madyaw tanawon.” ");
INSERT INTO kqew_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Awgaid yagalaong si Isa kanan, “Madyaw sagaw tanawon yani na Baay ng Tohan. Awgaid madatung yang allaw na amasapad yang kariko ninyan. Way maskin sambok na bato na amabilin sang kyabutangan nan kay obos ninyan ipangkanat-kanat.” ");
INSERT INTO kqew_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ansinyan sarta yaga-ingkod si Isa adto sang Butay ng Jayton na yaga-atobang sang Baay ng Tohan, dyomood kanan si Pitros, si Yakob, si Yahiya aw si Andriyas aw nang silan da gaid yaga-osip silan kanan, laong nilan, ");
INSERT INTO kqew_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Paglaonga kami daw kano pa matoman yang pyaglaongan mo aw ono yang tanda na magapatigam kanami na mallug da amaitabo yang kariko ninyan.” ");
INSERT INTO kqew_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo untak di kamo kalimbongan ng maskin sino. ");
INSERT INTO kqew_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kay madaig yang mga otaw na madatung aw magalaong silan na ‘Ako yang Almasi,’ aw madaig oman yang akalimbongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pagdungug mayo na aon mga gira sang masaid kamayo aw adto oman sang mawat na mga banwa, ayaw kamo pagkalluk. Kay dait na amaitabo yang kariko ninyan, awgaid dili pa yani yang kataposan ng donya. ");
INSERT INTO kqew_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagdatowan mapaglaban adto sang kadaigan. Ama-aon yang mga linog sang yagakatuna-tuna na mga banwa aw ama-aon oman yang gutum. Awgaid yang kariko ninyan pagsogod pa gaid ng kasikotan na mag-onawa ng pagbati ng sambok na bobay sang pagpanganak. ");
INSERT INTO kqew_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Awgaid kamo,” laong ni Isa, “pagbantay kamo kay adakupun aw adaun kamo adto sang hokomanan aw abadasan kamo adto sang pagsasambayangan ng mga Yahodi. Sabap sang pagpangintoo mayo kanak adaun kamo adto sang mga gobirnador aw mga soltan. Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kay bago domatung yang allaw ng arikiyamat dait na ipayapat yang Madyaw na Gogodanun sang kariko ng mga bangsa adi sa babawan ng donya. ");
INSERT INTO kqew_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na, kong adakupun aw adaun kamo adto sang hokomanan, ayaw kamo pagkarido daw ono yang ipaglaong mayo. Kay sinyan na wakto ipatigam kamayo daw ono yang dait mayo paglaong. Aw idtong ipaglaong mayo di magasikun sang dumduman mayo kondi sikun sang Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sinyan na mga allaw,” laong ni Isa, “aon mga otaw na magapadakup ng mga lomon nilan untak silan patayun. Aon oman mga ama na magapadakup ng mga anak nilan untak silan patayun. Aw aon oman mga anak na malaban sang taganak nilan aw ipapatay nilan silan. ");
INSERT INTO kqew_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kamo oman, adumutan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. Awgaid sino-sino yang magapadayon sang pagpangintoo nan kanak taman sang kataposan sini na mga kasikotan, amalowas.” ");
INSERT INTO kqew_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ansinyan yagalaong oman si Isa, “Sang madatung na mga allaw makita mayo na aon yakabutang na haram adto sang logar na di dait pagbutangan. Sino-sino yang magabasa sini, sabota mayo yang mana nan. Na, pagkita mayo sinyan, yang mga otaw na adto sa Yahodiya, dait silan domaagan adto sang kabutayan. ");
INSERT INTO kqew_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yang otaw na adto sa logwa ng kanan baay, di da dait somuud untak makamang pa ng maskin ono na butang nan. ");
INSERT INTO kqew_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aw yang otaw na adto sang pawa, di da dait mori untak makamang pa ng kanan dagom. ");
INSERT INTO kqew_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pagdatung ninyan na mga allaw, kallat ng mga mabdus aw yang mga yagapasoso kay mairapan silan pagdaagan. ");
INSERT INTO kqew_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Agaw, pagpangayo-ngayo kamo adto sang Tohan na di gao yan ma-inang sang wakto ng tingmaniki. ");
INSERT INTO kqew_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kay sinyan na mga allaw, labi da yang kasikotan na agian ng mga otaw. Sikun pa sang pagbaoy ng donya sampay adon waa pay main da nan na kasikotan aw pagkatapos di da oman ma-inang yang mag-onawa sinyan. ");
INSERT INTO kqew_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na, kong madogay yang inyan na kasikotan, amatay da yang kariko ng mga otaw. Awgaid sabap sang looy ng Tohan sang mga otaw na pinili nan, di nan apadogayun. ");
INSERT INTO kqew_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sinyan na mga allaw, kong aon magalaong kamayo na, ‘Tanawa, idi da yang Almasi,’ atawa, ‘Adto sidto yan,’ ayaw kamo pagtoo kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kay aon madatung na mga otaw na magalaong na silan kono yang Almasi. Aw aon oman mga otaw na magalaong na mga nabi kono silan, awgaid dili yan ng bunna. Maga-inang silan ng maskin ono na katingaan kay untak, kong mapakay, ma-ilad nilan maskin yang mga pinili ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Agaw, pagbantay kamo! Pyagalaong ta kamo ng kariko ninyan sang wa pa yan aka-inang. ");
INSERT INTO kqew_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na, pagkatapos sinyan na mga allaw ng kasikotan,” laong ni Isa, “magkaduggum yang suga aw di da magasiga yang bowan. ");
INSERT INTO kqew_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangkallog yang mga bitoon sikun sang langit aw yang kariko na adto sang langit amagayung. ");
INSERT INTO kqew_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pagkatapos sinyan makita nilan ako na Anak ng Manosiya na magasikun sang mga gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqew_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aw ansinyan asogoon ko yang kanak mga malaikat sang opat ka pinidyowan ng donya untak tiponon nilan yang mga otaw na pinili ko sikun sang kariko ng mga banwa. ");
INSERT INTO kqew_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na, dumduma mayo yang kaoy na igira. Aw yamanaringsing da yang mga sanga ninyan na kaoy, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqew_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mag-onawa sinyan, pagkita mayo na ma-inang da yani na pyagalaong ko kamayo, akatigaman mayo na mallug da ako magbarik adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sa bunna-bunna na ipaglaong ko kamayo na amatoman yang kariko ninyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqew_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Awgaid,” laong ni Isa, “way otaw na yamatigam daw ono na allaw atawa ono na wakto mabarik ako. Maskin yang mga malaikat adto sa sorga, aw maskin oman ako na Anak ng Tohan, wa akatigam. Yang Tohan da gaid na kanak Ama yang yamatigam sinyan. ");
INSERT INTO kqew_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Agaw sagaw, pagbantay aw pag-andam kamo kay wa kamo akatigam daw kano domatung yang wakto ng pagbarik ko. ");
INSERT INTO kqew_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kay mag-onawa yani sang otaw na yamanaw sang mawat na banwa. Pagpanaw nan, syarig nan yang kanan baay adto sang kanan mga sogowanun. Yatagan nan yang matag-isa kanilan ng gawbuk aw pyagalaong nan yang gowardya sang powertaan na dait yan magbantay. ");
INSERT INTO kqew_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Idto sagaw, dait kamo magbantay kay wa kamo akatigam daw kano bomarik yang tagtomon ng baay, ambong ba, daw tungang gabi, daw kadlawon atawa omaga. ");
INSERT INTO kqew_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aw matokaw yan magbarik, na, basin adatungan nan kamo na yamangkatoog. ");
INSERT INTO kqew_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, yang pyagalaong ko kamayo, pyagalaong ko oman adto sang kariko ng mga otaw na dait kamo magbantay.” ");
INSERT INTO kqew_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Adon, dowang allaw dakoman aw madatung da yang Pakaradyaan ng Paglabay na tyawag oman ng Pakaradyaan ng Pan na way Labadora. Na, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa na di akatigaman ng mga otaw aw monono yang pagpatay kanan. ");
INSERT INTO kqew_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yagalaong silan, “Di gaid natun yani inangun sang wakto ng pakaradyaan kay basin magakasamok yang mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ansinyan sarta adto silan ni Isa sang longsod ng Bitani, kyomadto silan sang baay ni Simon na sanglaun singaon. Nang yanagkan silan aon dyomatung na bobay na yagadaa ng tagbi na lasakanan na yamapono ng paballo. Yani na paballo na pyagangaanan sang nardo labi na mahalaga aw way dari san. Ansinyan byari ng bobay yang liyug ng lasakanan aw obowi nan ng paballo yang oo ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, aon mga otaw ansan na yadaman sang ininang ng bobay aw yanaglaong silan, “Kanogon ng paballo! ");
INSERT INTO kqew_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Madyaw pa aw byarigya inyan aw yang alin i-atag adto sang mga miskinan. Kay yang alin sinyan mag-onawa ng soweldo ng sangka otaw sa suud ng sangka toig.” Na, labi da yang pagsaway nilan sinyan na bobay. ");
INSERT INTO kqew_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Awgaid yagalaong si Isa, “Nanga pyagakasamok mayo yani na bobay? Pasagdi mayo yan kay madyaw yang ininang nan kanak. ");
INSERT INTO kqew_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kay yang mga miskinan abay mayo kaupud, aw maskin ono na wakto makatabang kamo kanilan. Awgaid ako, di ako magapabilin adi kamayo. ");
INSERT INTO kqew_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yani na bobay, ininang nan yang mapakay nan inangun. Yabowan nan ako ng paballo untak andamun nan dadaan yang kanak lawas sang kanak paglubung. ");
INSERT INTO kqew_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sa bunna-bunna na ipaglaong ko kamayo na maskin wain adi sining donya na ipayapat yang Madyaw na Gogodanun, amagogod oman yang ininang nan kanak silbi tadumanan kanan.” ");
INSERT INTO kqew_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ansinyan, si Yodas Iskariyot na sambok sang sampoo aw dowa na mga sahabat ni Isa, kyomadto yan sang mga pangoo ng mga imam untak ipagtraydor nan si Isa adto kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na, pagdungug nilan sang pyaglaongan ni Yodas, yamasowat silan aw yagapasad silan na atagan yan ng sapi. Ansinyan yagapanganap da si Yodas ng wakto na madyaw ipadakup kanilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ansinyan dyomatung da yang pukas na allaw ng Pakaradyaan ng Pan na way Labadora na yan yang allaw na dait sobariun yang mga karniro para sang Pakaradyaan ng Paglabay. Ansinyan yosip si Isa ng mga inindowan nan, laong nilan, “Wain yang karim mo na andamun nami yang kanatun pagkan para sang Pakaradyaan ng Paglabay?” ");
INSERT INTO kqew_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ansinyan syogo ni Isa yang dowa na mga inindowan nan aw laong nan kanilan, “Kadto kamo sang syodad. Ansidto aon masongon mayo na usug na yagapusan ng banga na yamapono ng tobig. Agad kamo kanan sang apanikan nan na baay ");
INSERT INTO kqew_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","aw paglaonga mayo yang tagtomon ng baay, ‘Yaga-osip yang goro nami daw wain na kowarto yan makakan sang kandori sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ");
INSERT INTO kqew_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ansinyan ipakita nan kamayo yang dakowa na kowarto adto sa taas ng baay na iyan da yang kariko ng kinaanglan ta. Adto da mayo andama yang kanatun pagkan para sang kandori.” ");
INSERT INTO kqew_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ansinyan pyomanaw da idtong dowa na inindowan aw pagdatung nilan sang syodad, yatoman yang kariko ng pyaglaongan kanilan ni Isa. Ansinyan pyaga-andam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqew_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkagabi sinyan dyomatung da si Isa sidto na baay upud sang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqew_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sarta yanagpangan silan, yagalaong si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na aon sangka otaw kamayo na yaga-upud kanak koman na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ansinyan yamarido da silan aw yang matag-isa kanilan yaga-osip kanan, laong nilan, “Kay Goro, ako ba yang pyagalaong mo?” ");
INSERT INTO kqew_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tyomobag si Isa aw laong nan, “Isa sang sampoo aw dowa kamayo na mga sahabat ko na yagadarit ng pan disini na ladya upud kanak, yan yang magatraydor kanak. ");
INSERT INTO kqew_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Amatay ako na Anak ng Manosiya mag-onawa ng yakasorat sang Kitab makapantag kanak. Awgaid maat yang adatungan ng otaw na magatraydor kanak. Madyaw pa aw wa yan akaotaw.” ");
INSERT INTO kqew_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sarta yanagpangan pa silan, kyomamang si Isa ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga inindowan nan aw laong nan, “Dawata mayo yani aw kana mayo kay yani yang kanak lawas.” ");
INSERT INTO kqew_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ansinyan kyomamang yan ng inumanan aw yamanginsokor sang Tohan. Pagkatapos, yatag nan sang mga inindowan nan aw yang kariko nilan yaminum. ");
INSERT INTO kqew_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yagalaong si Isa kanilan, “Yani yang kanak dogo na yaga-atag ng kasigorowan sang pyagapasadan na ininang ng Tohan sang manosiya. Maboos yang kanak dogo untak ma-ampon yang madaig na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sa bunna-bunna na ipaglaong ko kamayo na di da ako minum ng tumuk ng grips taman sang wakto na inumun da ko yang bago na inmanun adto sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagkatapos sinyan yanagkanta silan ng pagpoji adto sang Tohan aw kyomadto da silan sang Butay ng Jayton. ");
INSERT INTO kqew_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ansinyan yagalaong si Isa sang mga inindowan nan, “Adon na gabi, yang kariko mayo mabiya kanak. Kay aon yakasorat sang Kitab na yagalaong, “ ‘Ipapatay ng Tohan yang magbabantayay ng mga karniro, aw ansinyan magakanat-kanat da yang mga karniro.’ ");
INSERT INTO kqew_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Awgaid pagkatapos ko mabowi oman, ama-ona ako kamayo adto sa Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ansinyan yagalaong si Pitros kang Isa, “Maskin abiyaan kaw ng kariko nilan, awgaid ako, di ako mabiya kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yagalaong kanan si Isa, “Sa bunna-bunna na ipaglaong ko kammo na adon na gabi, sang di pa magatagaok yang laboyo ng makadowa, makatoo kaw maglaong na wa kaw akilaa kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Awgaid yagalaong da oman si Pitros, “Di ako magalaong na wa ta kaw akilaa maskin pa apatayun ako upud kammo.” Na, maynan oman yang pyaglaongan ng kadaigan na mga inindowan. ");
INSERT INTO kqew_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ansinyan kyomadto si Isa aw yang mga inindowan nan sang sambok na tanumanan na tyawag ng Gitsimani. Pagdatung nilan ansan, yagalaong si Isa sang mga inindowan nan, “Pag-ingkod kamo ansini kay magadowaa ako.” ");
INSERT INTO kqew_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tapos, pyaga-agad nan si Pitros, si Yakob aw si Yahiya. Ansinyan yamarido da yang ginawa ni Isa aw mabugat yang pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Laong nan kanilan, “Labi da yang karido ng ginawa ko na maynang amatay da ako. Ansini da gaid kamo aw ayaw kamo pagkatoog.” ");
INSERT INTO kqew_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ansinyan kyomadto si Isa sang onaan aw syomojod yan sang lopa kay magadowaa. Yagapangayo-ngayo yan adto sang Tohan na kong mapakay di gao yan adatungan ng kasikotan. ");
INSERT INTO kqew_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Laong nan, “O kay Ama, yang maskin ono ma-inang da mo. Kong mapakay, ayaw ako pa-agia sining madatung na kasikotan. Awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqew_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ansinyan byomarik yan adto sang toongka otaw na mga inindowan nan aw yadatungan nan silan na yamangkatoog. Pyokaw nan silan aw yagalaong yan kang Pitros, “Yatoog kaw kadi, kay Simon? Di kaw makabantay na maskin sangka oras da gaid? ");
INSERT INTO kqew_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pagbantay aw pagdowaa kamo untak di kamo madaa ng sasat. Sa suud ng pangatayan mayo karim mayo magpangagad sang Tohan, awgaid sabap ng maomay yang lawas mayo madari kamo madaa ng sasat.” ");
INSERT INTO kqew_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ansinyan pyomanaw da oman si Isa aw yagadowaa da oman yan na maynan oman yang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkatapos byomarik da oman yan sang too na inindowan nan aw kinita nan na yamangkatoog da oman silan kay labi da yang katodtod nilan. Pagpokaw kanilan ni Isa, wa silan akatigam daw ono yang ipaglaong nilan. ");
INSERT INTO kqew_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ansinyan pyomanaw da oman si Isa aw sang ikatoo na pagbarik nan yagalaong yan kanilan, “Yabay pa gaid kamo matoog aw magpatana? Osto da kay dyomatung da yang wakto na adakupun ako na Anak ng Manosiya ng baradosa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Unda, bangon da kamo kay mapanaw da kita. Idi da yang otaw na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nang yagalaong pa si Isa, dyomatung si Yodas na sambok sang sampoo aw dowa na mga sahabat. Madaig yang mga otaw na yaga-upud kanan na aon daa na mga lodyo aw mga bobonal. Syogo silan ng mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, pyagalaong silan dadaan ni Yodas na yan yang magatraydor kang Isa daw ono yang inangun nan silbi tanda kanilan. Laong nan, “Yang otaw na aukan ko, yan yang yanap mayo. Dakupa da mayo aw daa mayo, awgaid bantayi ng madyaw.” ");
INSERT INTO kqew_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Agaw pagdatung ni Yodas, dyomood dayon yan kang Isa aw maglaong, “Kay Goro.” Aw yaukan nan si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ansinyan dyakup si Isa ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Awgaid aon sangka otaw na yaga-indug sang masaid kang Isa, gyabot nan yang kanan lodyo aw tibasa nan yang sogowanun ng Dakowa na Imam aw ya-otod yang sangkilid na taringa nan. ");
INSERT INTO kqew_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ansinyan yagalaong si Isa sang mga yagadakup kanan, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng lodyo aw bobonal sang pagdakup mayo kanak? ");
INSERT INTO kqew_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Matag allaw adto ako sang Baay ng Tohan na yaga-indo aw adto oman kamo, awgaid wa mayo ako adakupa. Awgaid yamaitabo yang kariko nini untak matoman yang yakasorat sang Kitab.” ");
INSERT INTO kqew_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ansinyan yagabiya kanan yang kariko ng mga inindowan nan aw yanagdaagan silan. ");
INSERT INTO kqew_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Awgaid aon sambok na olitawo na yasonod kang Isa na yagatapis gaid ng dagmay. Pagkita kanan ng mga sondao, adakupun da gao nilan. ");
INSERT INTO kqew_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Awgaid binilin nan yang kanan dagmay aw dyomaagan ng way dagom. ");
INSERT INTO kqew_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ansinyan dyaa nilan si Isa adto sang baay ng Dakowa na Imam. Yanagkatipon ansan yang kariko ng mga pangoo ng mga imam, yang mga pangoo ng mga Yahodi aw yang mga magiindoway ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, si Pitros, yasonod yan kang Isa awgaid sang mawat-awat gaid taman sang baay ng Dakowa na Imam. Ansinyan syomuud yan sang pamanag aw yamingkod upud sang mga gowardya sang masaid sang atoon untak kapasowan yan. ");
INSERT INTO kqew_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Adon, yang mga pangoo ng mga imam aw yang kariko ng mga opisyales ng Hokomanan ng mga Yahodi, yagapanganap silan ng ebidensya untak ma-akosar aw mapatay nilan si Isa. Awgaid way kinita nilan na dosa nan. ");
INSERT INTO kqew_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kay maskin madaig yang yagasaksi ng dili ng bunna makapantag kanan, wa pagaka-onawa yang pyaglaongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ansinyan aon oman mga otaw na yamindug aw yagalaong silan ng dili ng bunna makapantag kang Isa, laong nilan, ");
INSERT INTO kqew_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yadungug nami na yagalaong yani na otaw na agubaun kono nan yang Baay ng Tohan na ininang ng mga otaw, aw sa suud ng toong allaw apa-indugun oman nan yang bago na wa inanga ng manosiya.” ");
INSERT INTO kqew_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Awgaid wa oman pagaka-onawa yang pyaglaongan nilan. ");
INSERT INTO kqew_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ansinyan yamindug yang Dakowa na Imam sa atobangan ng kariko ng mga otaw aw yaga-osip yan kang Isa, “Ono yang ikatobag mo sining mga otaw na yagasombong kammo?” ");
INSERT INTO kqew_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Awgaid yagapakatingun gaid si Isa aw wa yan atobag. Agaw yaga-osip oman kanan yang Dakowa na Imam, “Ikaw ba yang Almasi, yang Anak ng Tohan na Labi na Bantoganun?” ");
INSERT INTO kqew_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tyomobag si Isa, “Uu, ako sagaw. Sang madatung na mga allaw makita mayo ako na Anak ng Manosiya na yaga-ingkod apit sang karinto ng Tohan na Labi na Mabarakat. Aw makita oman mayo na mabarik ako adi sang donya sikun sang langit na pyagalibotan ng gabon.” ");
INSERT INTO kqew_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagdungug sinyan ng Dakowa na Imam, lyasi nan yang kanan dagom sabap sang kadaman nan aw yagalaong yan, “Di da kita kinaanglan ng kadaigan pa na saksi! ");
INSERT INTO kqew_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dyungug da mayo yang kanan pyaglaongan na mag-onawa kono yan sang Tohan! Na, ono da yang hokom mayo?” Aw yang kariko ng mga pangoo yagahokom na dait yan patayun. ");
INSERT INTO kqew_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ansinyan tyobadan si Isa ng pipila na mga otaw. Tyabonan nilan yang kanan mata aw sontoka nilan. “Na,” laong nilan kanan, “paglaonga kono daw sino yang yagasontok kammo!” Aw syontok oman yan ng mga gowardya pagkamang nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ansinyan nang iyan pa si Pitros sang pamanag ng baay, aon dyomatung na sambok na bobay na sogowanun ng Dakowa na Imam. ");
INSERT INTO kqew_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkita nan kang Pitros na yagapa-init ng lawas nan sang masaid sang atoon, pyakatanawan nan ng madyaw aw laong nan, “Inagad kaw oman ni Isa na taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Awgaid yagadili si Pitros aw laong nan, “Wa ako akatigam daw ono yang pyagalaong mo.” Ansinyan kyomadto yan sang powertaan ng pamanag. Aw sinyan na wakto yagatagaok yang laboyo. ");
INSERT INTO kqew_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ansinyan kinita da oman yan ng bobay na sogowanun aw yagalaong yan sang mga otaw na yaga-indug ansan, “Yani na otaw, kaupud nilan ni Isa.” ");
INSERT INTO kqew_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Awgaid yagadili oman si Pitros sidto na pyaglaongan nan. Pagkatugun-tugun sinyan yagalaong yang mga otaw na yaga-indug ansan kang Pitros, “Bunna sagaw na kaupudanan kaw nilan kay ikaw taga Jalil.” ");
INSERT INTO kqew_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Awgaid yagasapa si Pitros aw laong nan, “Asiksaun ako ng Tohan kong di ako maglaong ng bunna. Wa ako akilaa sinyan na otaw na pyagalaong mayo kanak!” ");
INSERT INTO kqew_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sinyan na wakto yagatagaok da oman yang laboyo ng ikadowa. Aw kyadumduman ni Pitros yang pyaglaongan kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo ng makadowa, makatoo kaw maglaong na wa kaw akilaa kanak.” Na, pagdumdum nan sinyan, bali na pagtiyao nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagkaamdagay sinyan yanagkatipon yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, yang mga magiindoway ng Hokoman aw yang kariko ng mga opisyales ng Makagwas na Hokomanan aw pyagabaawan nilan daw onoon nilan si Isa. Ansinyan gyapos nilan si Isa aw dyaa nilan adto kang Pilato, yang gobirnador na taga Roma. ");
INSERT INTO kqew_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ansinyan yosip si Isa ni Pilato, laong nan, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag kanan si Isa, “Pyaglaong da mo.” ");
INSERT INTO kqew_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ansinyan madaig yang pyagasombong kanan ng mga pangoo ng mga imam. ");
INSERT INTO kqew_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Agaw, yosip da oman ni Pilato si Isa, laong nan, “Nanga di kaw matobag? Tanawa, madaig yang pyagasombong nilan kammo.” ");
INSERT INTO kqew_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Awgaid wa oman tobag si Isa, agaw yatingaa si Pilato. ");
INSERT INTO kqew_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, matag Pakaradyaan ng Paglabay yang kya-anadan ni Pilato na palogwaun nan yang sangka otaw na piniriso na pyangayo ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Adon, adto sa pirisowan aon sangka otaw na pyagangaanan kang Barabas. Yamapiriso yan kipat yang mga kaupudanan nan kay yalaban silan sang gobirno aw yakapatay yan ng otaw. ");
INSERT INTO kqew_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ansinyan yanagkatipon yang madaig na mga otaw adto sa atobangan ni Pilato aw yagapangayo silan na apalogwaun nan yang sangka otaw sobay sang kyabatasanan nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yaga-osip kanilan si Pilato, “Karim mayo na aboyan ko kamayo yang soltan ng mga Yahodi?” ");
INSERT INTO kqew_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Idto yang osip nan kay kyatigaman nan na dyaa kanan si Isa ng mga pangoo ng mga imam kay yamasina silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Awgaid yang ininang ng mga pangoo ng mga imam, pyagalaong nilan yang mga otaw na si Barabas yang apangayoon nilan na aboyan aw dili ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yagalaong da oman si Pilato sang mga otaw, “Kong maynan, ono yang inangun ko sini na otaw na tyawag mayo ng soltan ng mga Yahodi?” ");
INSERT INTO kqew_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yagapiyagit silan ng matanog, “Ilansang yan sa kros!” ");
INSERT INTO kqew_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Nanga? Ono yang dosa na ininang nan?” yagalaong oman kanilan si Pilato. Awgaid pyakusug pa nilan yang tingug aw laong nilan, “Ilansang yan sa kros!” ");
INSERT INTO kqew_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, karim ni Pilato na masowat kanan yang mga otaw. Agaw si Barabas yang pyalogwa nan. Pagkatapos sinyan pyabadasan nan si Isa aw yatag nan sang mga sondao untak ilansang da nilan sa kros. ");
INSERT INTO kqew_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ansinyan dyaa si Isa ng mga sondao adto sang pamanag ng palasyo ng gobirnador aw pyatawag nilan yang kariko ng kasondaowan. ");
INSERT INTO kqew_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ansinyan pyandagoman nilan si Isa ng joba na mapowa. Tapos, yaga-inang silan ng korona na soksokon aw butangan nilan sang oo nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ansinyan byantog konohay nilan si Isa aw laong nilan, “Mabowi yang soltan ng mga Yahodi!” ");
INSERT INTO kqew_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Byonalan nilan yang oo nan ng kaoy aw tyobadan nilan. Aw syomojod silan sa atobangan nan na maynang yaga-addat silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatapos nilan sangu-sanguun si Isa, lyobasan nilan ng joba na mapowa aw syoogan da oman ng kanan dagom. Ansinyan dyaa nilan yan adto sa logwa untak ilansang da nilan sa kros. ");
INSERT INTO kqew_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Paglogwa nilan sikun sa Awrosalam, aon syongon nilan na otaw na pyagangaanan kang Simon na taga Kirini na ama ni Iskandar aw si Ropos. Sikun yan sang baryo aw yagapaduug yan sang syodad. Pyugus yan ng mga sondao pagpusan sang kaoy na pagalansangan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ansinyan dyaa nilan si Isa adto sang logar na tyawag ng Golgota na yang mana san Logar ng Oo ng Kalabira. ");
INSERT INTO kqew_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagdatung nilan ansan, pya-inum gao nilan si Isa ng bino na dyarian ng tambal na pyagangaanan sang mira. Awgaid wa nan inuma. ");
INSERT INTO kqew_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ansinyan lyansang da nilan si Isa sa kros. Pagkatapos, pyagabain-bain nilan yang mga dagom nan pina-agi sang pagripa untak katigaman daw ono yang amakamang ng matag-isa kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na, alas nowebe ng kaamdag yang paglansang nilan kang Isa sa kros. ");
INSERT INTO kqew_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aon oman byutang nilan na karatola adto sa kros na syoratan ng pyagasombong kanan na yagalaong, “Yang Soltan ng mga Yahodi.” ");
INSERT INTO kqew_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na, aon oman dowangka otaw na tolisan na lyansang sa kros dungan kang Isa, yang sambok sang karinto nan aw yang sambok sang kawaa nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ansinyan yatoman yang yakasorat sang Kitab na yagalaong, “Yamabilang yan ng mga darowaka.” ");
INSERT INTO kqew_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, yang mga otaw na yalabay ansan yaga-uung-uung aw ininsolto nilan si Isa, laong nilan, “Yagalaong kaw na agubaun mo yang Baay ng Tohan aw apa-indugun da mo oman sa suud ng toong allaw. ");
INSERT INTO kqew_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, lowasa da yang ginawa mo aw panaog sikun sa kros!” ");
INSERT INTO kqew_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mag-onawa sinyan pyagasangu-sangu yan ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, laong nilan, “Tyabangan nan yang kadaigan, awgaid di yan makalowas sang ginawa nan! ");
INSERT INTO kqew_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na, tanawon ta adon yang Almasi, yang soltan ng bangsa Israil, daw makapanaog yan sikun sa kros. Aw makapanaog yan, amangintoo da kami kanan!” Aw maskin idtong dowangka otaw na tolisan na lyansang sa kros dungan kang Isa, yamanginsolto silan kanan. ");
INSERT INTO kqew_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nang alas dose da yang suga yagkaduggum yang tibok banwa taman ng alas tres. ");
INSERT INTO kqew_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pagka-alas tres ng ambong yagapiyagit si Isa ng matanog, laong nan, “Iloy, Iloy, lama sabaktani?” na yang mana nan “Ya Tohan ko, ya Tohan ko, nanga pyabayaan mo ako?” ");
INSERT INTO kqew_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pagdungug sinyan ng mga otaw na yanag-indug ansan, yagalaong silan, “Paningug kamo, tyawag nan si Nabi Iliyas.” ");
INSERT INTO kqew_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ansinyan dyomaagan dayon yang sambok na otaw aw kyomamang yan ng ispongha aw tuguma nan sang magsing na bino. Tapos, byutang nan sang kaoy aw diwian nan sang baba ni Isa untak masupsup nan. Yagalaong yan, “Na, tanawon ta adon daw madatung si Nabi Iliyas untak tabangan nan pagpanaog sikun sa kros.” ");
INSERT INTO kqew_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ansinyan yagapiyagit si Isa aw yamabogto da yang napas nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sinyan na wakto yamalasi yang madakmuu na kortina adto sang Baay ng Tohan aw yamatunga sikun sa taas pababa. ");
INSERT INTO kqew_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Adon, yang kapitan ng mga sondao na yaga-indug sa atobangan ng kros na pyagalansangan kang Isa, pagkita nan na mayninyan yang pagbogto ng napas ni Isa, yagalaong yan, “Bunna sagaw na yani na otaw Anak ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na, aon oman mga bobay ansan na yanagtanaw sidto na yamaitabo sikun sang mawat. Kaupud nilan si Mariyam na taga Magdala aw si Salomi. Iyan oman si Mariyam na ina ni Yosis aw si Yakob na mangod nan. ");
INSERT INTO kqew_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yani na mga bobay yamagad aw yaga-atiman kang Isa nang idto pa yan sa Jalil. Madaig oman ansan yang kaobayan na yamagad kang Isa sang pagkadto nan sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na, sidto na allaw Jomaat na allaw ng pagpangandam para sang Allaw ng Pagpatana. Pagkasilum sinyan ");
INSERT INTO kqew_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","dyomatung si Yosop na taga Arimatiya. Yani si Yosop sambok na opisyal sang Makagwas na Hokomanan na pyaga-addatan ng mga otaw aw yagatagad yan sang wakto na magadato da yang Tohan. Ansinyan yagaka-isug yan komadto kang Pilato untak pangayoon nan yang patay na lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na, yatingaa da si Pilato sang pagdungug nan na patay da kono si Isa. Agaw pyatawag nan yang kapitan ng mga sondao aw yosip nan daw bunna ba na patay da si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagdungug nan sang pyaglaong ng kapitan na patay da si Isa, tyogotan nan si Yosop na kamangun nan yang lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na, pyomanaw da si Yosop aw yagabili yan ng sapot na mapoti. Pagkatapos, kyamang nan yang lawas ni Isa sikun sa kros, byalot nan ng sapot aw butangan nan sang kobor na pyagalongagan sang bato. Pagkatapos, pyagaligid nan yang dakowa na bato sang baba ng kobor untak matabonan yan. ");
INSERT INTO kqew_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na, iyan san si Mariyam na taga Magdala aw si Mariyam na ina ni Yosis aw yakakita silan daw wain akoboran si Isa. ");
INSERT INTO kqew_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagsallup ng suga sang Allaw ng Pagpatana, pyomanaw si Mariyam na taga Magdala, si Salomi aw si Mariyam na ina ni Yakob kay magabili silan ng paballo na ibutang nilan sang patay na lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ansinyan pagsilat ng suga sang allaw ng Domingo, kyomadto da silan sang kobor. ");
INSERT INTO kqew_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sarta iyan silan sang daan yanag-inosipay silan, laong nilan, “Sino kowaw yang amakatabang kanatun pagligid sang bato sikun sang baba ng kobor?” ");
INSERT INTO kqew_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maynan yang pyagabaawan nilan kay bali na kadakowa ng bato. Awgaid pagtanaw nilan, kinita nilan na yamaligid da yang bato. ");
INSERT INTO kqew_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na, pagsuud nilan sang kobor, aon kinita nilan na sambok na olitawo na yaga-ingkod apit sang karinto. Pagkita nilan kanan, bali na pagkatingaa nilan. ");
INSERT INTO kqew_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Awgaid yagalaong kanilan yang otaw, “Ayaw kamo pagkalluk. Yamatigam ako na yanap mayo si Isa na taga Nasarit na pyalansang sa kros. Waa da yan adi kay yabowi oman yan. Tanawa mayo yang pyagabutangan nan. ");
INSERT INTO kqew_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, panaw da kamo aw paglaonga mayo yang mga inindowan nan kipat si Pitros na ama-ona yan kanilan adto sa Jalil. Adto da nilan yan akitaun mag-onawa ng pyagalaong nan.” ");
INSERT INTO kqew_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ansinyan lyomogwa da yang mga bobay sikun sang kobor aw dyomaagan silan kay tyakigan silan ng alluk. Aw wa silan pagalaong sang maskin sino kay yamalluk silan. ");
INSERT INTO kqew_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, masuum pa sang allaw ng Domingo yabowi oman si Isa. Pagkatapos nan mabowi oman, ona yan pagapakita kang Mariyam na taga Magdala na kyamangan nan singaon ng pito na mga saytan. ");
INSERT INTO kqew_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na, pyomanaw da si Mariyam untak paglaongon nan yang mga inindowan ni Isa na yanagtiyao aw yanagminatay pa. ");
INSERT INTO kqew_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Awgaid pagdungug nilan sang pyaglaongan ni Mariyam na bowi si Isa aw yakakita yan kanan, wa silan apangintoo kanan. ");
INSERT INTO kqew_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatapos san yagapakita si Isa sang dowangka otaw na mga inindowan nan nang yagapaduug silan sang baryo. Awgaid yaparin yang parangay nan. ");
INSERT INTO kqew_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ansinyan byomarik da idtong dowangka otaw adto sa Awrosalam kay paglaongon nilan yang mga kaupudanan nilan. Awgaid wa silan apangintoo kanilan. ");
INSERT INTO kqew_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pagkatapos san yagapakita si Isa sang sampoo aw isa na mga sahabat nan sarta yanagpangan silan. Kyadamanan nan silan sabap sang kabagsug ng oo nilan kay wa silan apangintoo sang pyaglaongan ng mga otaw na yakakita kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqew_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ansinyan yagalaong si Isa kanilan, “Kadto da kamo sang kariko ng mga banwa adi sa babawan ng donya aw pagpayapat kamo ng Madyaw na Gogodanun sang kariko ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sino-sino yang amangintoo aw magapasogbo, amalowas. Awgaid sino-sino yang di amangintoo, hokomon na asiksaun. ");
INSERT INTO kqew_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aw yani yang mga tanda na ma-inang ng mga yagapangintoo kanak. Sabap sang kabarakat ng kanak ngaan makapalogwa silan ng mga saytan sikun sang mga otaw aw makapaglaong silan sang mga pyaglaongan na wa nilan akatigami. ");
INSERT INTO kqew_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kong makatakmag silan ng od atawa maka-inum silan ng makamatay, di silan ama-ono. Aw kong dapunun nilan yang arima nilan sang mga masakitun, amadyaw silan.” ");
INSERT INTO kqew_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatapos ni Tagallang Isa maglaong sinyan adto sang mga inindowan nan, pyataas yan adto sa sorga aw pag-ingkod apit sang karinto ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ansinyan kyomadto da yang mga inindowan nan sang yagakatuna-tuna na mga banwa aw yagapayapat silan ng Madyaw na Gogodanun. Tyabangan silan ng Tagallang sang ininang nilan aw yatagan nan silan ng kabarakat pag-inang ng mga katingaan silbi tanda na bunna yang pyagapayapat nilan. Wassalam");
INSERT INTO kqew_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Assalamo alaykom kammo, Dato Tiyopilo. Madaig da yang yamaningkamot magsorat makapantag sang mga ininang ni Isa Almasi na yatoman adi sang kanatun banwa. ");
INSERT INTO kqew_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yang syorat nilan yasobay sang gyogod kanatun nidtong mga otaw na yakakita sang kariko ng ya-inang sikun pa sang pagsogod aw yagapayapat oman ng makapantag sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na adon, Dato Tiyopilo, sabap ng pyagasosi ko ng madyaw yang kariko nini na mga butang sikun pa sang pagsogod, yagadumdum ako na madyaw oman kong isorat ko kammo yaning kariko sang matapid na pama-agi. ");
INSERT INTO kqew_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ininang ko yani untak makasigoro kaw na bunna yang kariko ng pyaga-indo kammo. ");
INSERT INTO kqew_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sidto na wakto na si Hirod yang soltan sa Yahodiya aon sambok na imam na pyagangaanan kang Sakariyas. Yakabilang yan sang panon ng mga imam na mga topo ni Abiyas. Yang ngaan ng asawa nan si Hashiba na topo oman ni Imam Haron. ");
INSERT INTO kqew_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Si Sakariyas aw si Hashiba, matorid silan sang pagtanaw ng Tohan aw yagapangagad silan sang kariko ng mga sogowan. ");
INSERT INTO kqew_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Awgaid way anak nilan kay di maka-anak si Hashiba aw silan dowa mataas da yang idad nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ansinyan dyomatung yang wakto na si Sakariyas upud sang kadaigan pa na mga imam ng kanan panon yang maga-inang ng gawbuk nilan adto sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yanagripa silan sobay sang kabatasanan nilan na mga imam daw sino yang magasonog ng toob adto sa suud ng Baay ng Tohan. Aw si Sakariyas yang yamapili. Agaw syomuud yan adto sang Sotti na Kowarto. ");
INSERT INTO kqew_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sarta yagasonog yan ng toob adto sa suud, madaig yang mga otaw adto sa logwa na yanagdowaa. ");
INSERT INTO kqew_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakadyap sinyan aon sambok na malaikat na syogo ng Tohan na yagapakita kang Sakariyas. Iyan yan paga-indug apit sang karinto ng pagsosonogan ng toob. ");
INSERT INTO kqew_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkita ni Sakariyas sang malaikat, yakuga yan aw yasaot yan ng alluk. ");
INSERT INTO kqew_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Awgaid yagalaong yang malaikat kanan, “Ayaw da pagkalluk, kay Sakariyas, kay tyarima ng Tohan yang pyangayo mo kanan. Yang kammo asawa na si Hashiba amanganak ng usug aw pagangaanan mo yan kang Yahiya. ");
INSERT INTO kqew_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amasowat kaw sabap kanan aw madaig oman yang mga otaw na amasowat kong amaotaw da yan. ");
INSERT INTO kqew_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kay ma-inang yan ng bantoganun sa atobangan ng Tohan. Di yan dait minum ng maskin ono na makalasing kay sikun pa sang paglakad ng ina nan pyagabuutan da yan ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Madaig yang mga topo ni Israil na apabarikun nan adto sang Tohan na Tagallang nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ama-ona yan sang pagdatung ng Dato na Labi na Mabarakat na iyan kanan yang kinaiya aw kabarakat na mag-onawa ng kinaiya aw kabarakat ni Nabi Iliyas. Sabap sang pag-indo nan apabarikun nan yang madyaw na relasyon ng mga ama adto sang mga anak nilan. Aw yang mga otaw na masopakun apabarikun nan sang dumduman ng mga otaw na matorid. Aw ansinyan andamun nan yang mga otaw sang pagdatung ng Dato na Labi na Mabarakat.” ");
INSERT INTO kqew_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ansinyan yaga-osip si Sakariyas sang malaikat, laong nan, “Monono ko akatigaman na amatoman yani na pyaglaongan mo? Kay ako matikadung da aw boyag da oman yang asawa ko.” ");
INSERT INTO kqew_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tyomobag yang malaikat, laong nan, “Ako si Jibrail, aw iyan ako maga-indug sa atobangan ng Tohan. Syogo nan ako untak magpatigam kammo sini na madyaw na gogodanun. ");
INSERT INTO kqew_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awgaid adon, kay wa kaw apangintoo sang pyaglaongan ko, amasiling kaw ng amang aw di da kaw makapaglaong taman sidtong wakto na amatoman da yani na pyaglaongan ko kammo. Aw amatoman yaning kariko pagdatung ng wakto na pyagakahanda ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, yang mga otaw adto sa logwa yabay magtagad kang Sakariyas. Yangkatingaa silan nanga yadogay yan adto sa suud ng Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ansinyan paglogwa da ni Sakariyas, di da yan makapaglaong aw yagasingyas da gaid yan adto sang mga otaw. Agaw kyatigaman da nilan na aon pyakita kanan ng Tohan adto sa suud. Aw sikun sinyan amang da si Sakariyas. ");
INSERT INTO kqew_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ansinyan pagkatapos ng gawbuk ni Sakariyas adto sang Baay ng Tohan yamori da yan. ");
INSERT INTO kqew_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wa akadogay sinyan yagkabdus da yang asawa nan na si Hashiba. Aw sa suud ng limambowan wa yan apanaw sikun sang baay. ");
INSERT INTO kqew_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Laong nan, “Madyaw yang ininang kanak ng Tohan kay tyabangan nan ako aw kyamang da nan yang yagapakamomowa kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ansinyan sang ika-unum na bowan ng pagkabdus ni Hashiba syogo ng Tohan yang kanan malaikat na si Jibrail adto sang longsod ng Nasarit na sakop ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Syogo yan adto sang sambok na daaga na pyagangaanan kang Mariyam. Yani si Mariyam tawas ni Yosop na topo ni Soltan Daud. ");
INSERT INTO kqew_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ansinyan dyomood yang malaikat kang Mariyam aw laong nan, “Assalamo alaykom, kay Mariyam. Kyaoyan kaw ng Tohan aw iyan yan sang masaid kammo.” ");
INSERT INTO kqew_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na, pagdungug ni Mariyam sinyan na pyaglaongan ng malaikat, bali na karido nan aw yabay nan dumdumun daw ono yang mana ng pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ansinyan yagalaong yang malaikat kanan, “Ayaw da pagkalluk, kay Mariyam, kay kyaoyan kaw ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sang di amadogay amabdus kaw aw amanganak kaw ng usug aw pagangaanan mo yan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma-inang yan ng bantoganun aw pagatawagun yan na Anak ng Labi na Makagwas. Atagan yan ng Tohan ng kapatot pagdato sang mga otaw na mag-onawa ng kapatot ni Soltan Daud na ompo nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ansinyan magadato yan sang mga topo ni Yakob taman sa taman kay way kataposan ng pagkasoltan nan.” ");
INSERT INTO kqew_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ansinyan yagalaong si Mariyam sang malaikat, “Monono yang pagpanganak ko na daaga pa sa ako?” ");
INSERT INTO kqew_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tyomobag yang malaikat aw laong nan, “Madatung kammo yang Nyawa ng Tohan aw magapabilin kammo yang kabarakat ng Labi na Makagwas. Sabap sinyan sotti yang isu na amaotaw aw pagatawagun yan na Anak ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dumduma oman yang lomon mo na si Hashiba. Yagakabdus yan aw aka-aonan yan ng anak na usug maskin boyag da. Yan na bobay na di kono maka-anak, ika-unum na bowan da adon ng pagkabdus nan ");
INSERT INTO kqew_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kay way butang na di amabaoy ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tyomobag si Mariyam, laong nan, “Idi kay ako na allang ng Tohan. Atarimaun ko yang pyagakahanda nan kanak aw amatoman pa gao yang pyaglaongan mo kanak.” Pagkatapos sinyan biniya kanan yang malaikat. ");
INSERT INTO kqew_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wa akadogay sinyan yaga-andam da si Mariyam aw yomapas-apas yan komadto sang sambok na banwa sa kabutayan ng Yahodiya. ");
INSERT INTO kqew_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagdatung nan sidto na banwa, yamanaos yan sang baay ni Sakariyas aw yagasalam yan kang Hashiba. ");
INSERT INTO kqew_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na, pagdungug ni Hashiba sang pagsalam ni Mariyam, tyomokaw magginuk yang isu sang dubdub nan. Pyagabuutan si Hashiba ng Nyawa ng Tohan ");
INSERT INTO kqew_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aw yagapiyagit yan aw laong nan, “Dakowa yang kadyawan na yatag kammo ng Tohan na labaw pa sang kariko ng kaobayan! Aw dakowa oman yang kadyawan na yatag nan adto sang anak mo. ");
INSERT INTO kqew_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na, sino kadi ako na bisitaun ako ng ina ng kanak Dato? ");
INSERT INTO kqew_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kay pagdungug pa ko gaid sang pagsalam mo, tyomokaw magginuk yang isu sang dubdub ko na maynang yamasowat yan. ");
INSERT INTO kqew_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bali na kadyaw ng ginawa mo kay yasarig kaw na amatoman yang pyaglaongan kammo ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ansinyan yagalaong si Mariyam, “Pyoji ko yang Tohan sang kanak pangatayan, ");
INSERT INTO kqew_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aw bali na kasowat ko sang Tohan na kanak Manlolowas. ");
INSERT INTO kqew_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kay kyadumduman nan ako na kanan gaid allang. Aw sikun adon magalaong yang kariko ng mga otaw na bali na kadyaw ng ginawa ko ");
INSERT INTO kqew_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sabap sang mga katingaan na ininang kanak ng Tohan na Labi na Mabarakat. Sotti yang ngaan nan! ");
INSERT INTO kqew_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yamallat yan sang mga otaw na aon alluk kanan maskin pa sang mga katopo-topowan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pyakita nan yang kanan kabarakat sabap sang mga inang nan aw pyagakanat-kanat nan yang mga otaw na yagapataas ng ginawa nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kyamangan nan ng kapatot yang mga soltan aw pyataas nan yang mga otaw na mababa yang kabutang nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yatagan nan ng mangkadyaw na mga butang yang mga yamagutum aw pyapanaw nan ng way daa yang mga sapian. ");
INSERT INTO kqew_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tyabangan nan yang bangsa Israil na kanan allang aw tyoman nan yang kanan pasad sang kanatun kaompowan. ");
INSERT INTO kqew_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kay yagapasad yan kang Nabi Ibrahim aw yang mga topo nan na amallat yan kanatun taman sa taman.” ");
INSERT INTO kqew_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, ansinyan yagapabilin pa si Mariyam adto kang Hashiba ng mga toombowan. Pagkatapos, yamori da yan. ");
INSERT INTO kqew_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Adon dyomatung da yang wakto ng pagpanganak ni Hashiba aw yamanganak yan ng usug. ");
INSERT INTO kqew_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagdungug ng mga simbaay kipat yang mga kalomonan ni Hashiba na dakowa yang looy na pyakita kanan ng Tohan, yamangkasowat silan upud kanan. ");
INSERT INTO kqew_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na, sang ikawaong allaw da ng isu kyomadto kanilan Hashiba yang mga simbaay aw yang mga kalomonan nan kay atoliun da nilan yang isu. Aw pagangaanan gao nilan yan kang Sakariyas mag-onawa ng ama nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Awgaid yagalaong yang ina ng isu, “Ayaw, kay yang pagangaan kanan si Yahiya.” ");
INSERT INTO kqew_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Nanga kadi?” laong nilan. “Waa sabay lomon mayo na Yahiya yang ngaan.” ");
INSERT INTO kqew_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Agaw siningyasan da nilan si Sakariyas daw sino yang pagangaan nan sang isu. ");
INSERT INTO kqew_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ansinyan yagapakamang si Sakariyas ng soratanan aw syorat nan, “Yang ngaan nan si Yahiya.” Aw yangkatingaa da yang kariko nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na, pagkasorat dakoman ni Sakariyas ng ngaan ng isu, yakapaglaong da oman yan aw yagapoji sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ansinyan yangkalluk yang kariko ng mga simbaay nilan. Aw yang gogodanun makapantag sini na pangitabo yakarimpud sang kariko ng mga banwa sa kabutayan ng Yahodiya. ");
INSERT INTO kqew_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aw yang kariko ng mga yakadungug sinyan yanaglaong sang ginawa nilan, “Ono pa kowaw yang ma-inang nining isu kong dakowa da?” Kay klaro da na yagadan yan ng kabarakat ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ansinyan pyagabuutan si Sakariyas na ama ng isu ng Nyawa ng Tohan aw yakapaglaong yan ng pyaglaongan ng Tohan. Laong nan, ");
INSERT INTO kqew_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pojiun ta yang Tohan na pyagasambayangan ng bangsa Israil kay yakani yan untak lowasun nan kita na mga sakop nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pyadaa nan adi kanatun yang sambok na manlolowas na mabarakat na topo ni Soltan Daud na kanan allang. ");
INSERT INTO kqew_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Idto yang pyatigam nan kanatun pina-agi sang kanan mga nabi singaong ona pa. ");
INSERT INTO kqew_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yagapasad yan na alowasun nan kita sikun sang kanatun mga kalaban aw sikun oman sang yagadumut kanatun. ");
INSERT INTO kqew_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yagalaong oman yan na amallat yan sang kanatun kaompowan aw di nan akaringawan yang kanan pasad na inangun nan silan ng mga otaw na sakop nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Idto yang kanan pasad sang kanatun ompo na si Nabi Ibrahim ");
INSERT INTO kqew_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na alowasun nan kita sikun sang kanatun mga kalaban untak kita makapangagad kanan ng way alluk ");
INSERT INTO kqew_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","aw untak kita ma-inang ng sotti aw matorid sa atobangan nan sang tibok natun na kinabowi.” ");
INSERT INTO kqew_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ansinyan yagalaong si Sakariyas sang anak nan, “Ikaw, kay Itin, pagatawagun kaw na nabi ng Tohan na Labi na Makagwas kay ama-ona kaw sang Dato na Labi na Mabarakat untak andamun mo yang agianan nan. ");
INSERT INTO kqew_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ikaw yang magapatigam sang mga otaw na sakop nan na amalowas silan kong amangayo silan ng ampon ng mga dosa nilan. ");
INSERT INTO kqew_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kay yang kanatun Tohan labi na maoyanun. Aw sabap sinyan apakaniun nan kanatun yang manlolowas sikun sa sorga na mag-onawa ng pagsilat ng suga ");
INSERT INTO kqew_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","untak ka-allagan yang kariko ng mga otaw na iyan sang kadugguman aw yamalluk matay, aw untak indowan nan kita ng daan ng kalinaw.” ");
INSERT INTO kqew_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ansinyan tyomorin da yang anak ni Sakariyas aw yagakabagsug yang dumduman nan. Yaga-uya yan adto sang mamingaw na banwa taman sang wakto na yagasogod da yan mag-indo sang mga otaw na bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sidto na panahon yagasogo si Agosto na soltan sa Roma na ipabilang yang kariko ng mga otaw na sakop sang pyagdatowan nan. ");
INSERT INTO kqew_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yani pa yang pukas na pagbilang sang wakto na si Kiriniyos yang gobirnador sang probinsya ng Siriya. ");
INSERT INTO kqew_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Agaw yanagsi-ori da yang mga otaw adto sang banwa ng kanilan kaompowan untak magpalista ng ngaan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Adon si Yosop, pyomanaw yan sikun sa Nasarit na sakop ng Jalil aw kyomadto yan sa Baytlaham sa Yahodiya, yang longsod na pyagasikunan ni Soltan Daud kay sambok na topo yan ni Soltan Daud. ");
INSERT INTO kqew_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kyomadto yan upud kang Mariyam na tawas nan untak magpalista silan. Aw sidto na wakto mabdus da si Mariyam. ");
INSERT INTO kqew_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na, sarta adto silan sa Baytlaham dyomatung da yang wakto na akaotawan si Mariyam. ");
INSERT INTO kqew_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ansinyan yamanganak yan ng panganay nan na usug aw balota nan ng tela aw pakowanga nan sang pyagapakanan ng mga ayup. Ansan da silan adatung sang kolongan ng mga ayup kay waa day logar sang baay na yadatungan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, sidto na gabi aon mga otaw na yagabantay sang mga karniro nilan adto sang pyanamsaman na masaid sinyan na longsod. ");
INSERT INTO kqew_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sakadyap sinyan aon yagapakita kanilan na malaikat na syogo ng Tohan aw kya-allagan silan ng kasiga ng Tohan. Agaw, bali na kalluk nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Awgaid yagalaong kanilan yang malaikat, “Ayaw kamo pagkalluk kay yakani ako untak magpatigam kamayo ng madyaw na gogodanun na amakasowat ng kariko ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kay adon na gabi, sang longsod ni Soltan Daud, yaotaw yang manlolowas mayo na yan yang Almasi, yang Dato na Labi na Mabarakat. ");
INSERT INTO kqew_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yani kay yang tanda kamayo na bunna yang pyagalaong ko kamayo. Kong komadto kamo aon makita mayo na isu na byalot ng tela aw yagakowang sang pyagapakanan ng mga ayup.” ");
INSERT INTO kqew_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sakadyap yamupud da sinyan na malaikat yang madaig pa na mga malaikat sikun sa sorga na yanagpoji sang Tohan, laong nilan, ");
INSERT INTO kqew_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pojiun ta yang Tohan adto sa sorga aw adi sang donya ka-aonan ng kalinaw yang mga otaw na akasowatan nan!” ");
INSERT INTO kqew_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ansinyan pagbarik ng mga malaikat adto sa sorga, yanagbaaw-baaw yang mga magbabantayay ng karniro aw laong nilan, “Unda, adto da kita sa Baytlaham aw atanawon ta yani na pyatigam kanatun ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na, yomapas-apas da silan komadto sa Baytlaham aw kinita nilan si Mariyam aw si Yosop kipat yang isu na yagakowang sang pyagapakanan ng mga ayup. ");
INSERT INTO kqew_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkita nilan sang isu, gyogod nilan yang pyaglaongan kanilan ng malaikat makapantag kanan. ");
INSERT INTO kqew_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aw yang kariko ng mga yakadungug sinyan yangkatingaa sidtong gogodanun ng mga magbabantayay ng karniro. ");
INSERT INTO kqew_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Awgaid si Mariyam, byutang nan yang kariko ng dyungug nan sang pangatayan nan aw yabay nan dumdumun. ");
INSERT INTO kqew_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ansinyan yanagbarik da yang mga magbabantayay ng karniro adto sang pyanamsaman. Pyoji aw byantog nilan yang Tohan sabap sang kariko ng dyungug aw kinita nilan na yagaka-onawa sang pyaglaongan kanilan ng malaikat. ");
INSERT INTO kqew_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagdatung ng ikawaong allaw sikun sang pagkaotaw ng isu, tyoli nilan yan aw pyagangaanan nilan kang Isa kay idto yang ngaan na yatag kanilan ng malaikat sang wa pa pagalakad kanan yang ina nan. ");
INSERT INTO kqew_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ansinyan pagdatung ng allaw na inangun ni Yosop aw si Mariyam yang pyagasogo ng Hokoman ni Nabi Mosa para sang pagpasotti sang bobay na baya pa yamanganak, kyomadto da silan sa Awrosalam. Dyaa oman nilan yang isu adto sang Baay ng Tohan kay i-atag da nilan adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ininang nilan yani kay aon yakasorat sang Hokoman ng Tohan na yagalaong, “Yang kariko ng mga panganay na usug dait na i-atag mayo adto sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ansinyan pyangagadan da nilan yang pyagalaong ng Hokoman ng Tohan na sang pagpasotti dait ipakorban yang dowambok na tokmo atawa yang dowambok na impis ng malapati. ");
INSERT INTO kqew_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, adto sa Awrosalam aon sambok na otaw na pyagangaanan kang Simiyon. Matorid yan na otaw aw bara-ibada aw yabay yan magtagad sidtong wakto na madatung da yang magapabagsug ng pangatayan ng mga otaw na bangsa Israil. Iyan kanan yang Nyawa ng Tohan ");
INSERT INTO kqew_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aw pyatigam kanan ng Nyawa ng Tohan na di yan amatay taman sang makita da nan yang Almasi na pyasad ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na, ansinyan pyakadto si Simiyon ng Nyawa ng Tohan adto sang Baay ng Tohan. Sinyan na allaw dyomatung oman si Yosop aw si Mariyam na yagadaa kang Isa kay untak inangun nilan yang pyagasogo ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pagkita ni Simiyon sang isu, sinipit nan aw yagapoji yan sang Tohan na laong nan, ");
INSERT INTO kqew_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ya Tohan, maskin bogtoon da mo adon yang napas ko, madyaw da kanak kay yatoman da yang pasad mo kanak na allang mo. ");
INSERT INTO kqew_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kay adon kinita da ko sang dowa na mata ko yang manlolowas na syogo mo. ");
INSERT INTO kqew_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pyadaa mo yan adi sining donya untak makita yan ng kariko ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yan yang allag na magapatigam sang mga otaw na dili ng Yahodi daw sino kaw. Aw yan yang kabantog ng bangsa Israil na sakop mo.” ");
INSERT INTO kqew_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na, yang mga taganak ni Isa yangkatingaa sang pyaglaongan ni Simiyon makapantag sang anak nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ansinyan pyangayowan silan ni Simiyon ng kadyawan adto sang Tohan aw yagalaong yan adto kang Mariyam na ina ng isu, laong nan, “Yani na isu, pyagakahanda yan ng Tohan na ma-inang ng pyagasabapan ng paglowas aw pagsapad ng madaig na mga otaw na bangsa Israil. Kay yan yang tanda na yatag ng Tohan kanatun, awgaid madaig yang masopak kanan. ");
INSERT INTO kqew_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sabap kanan amapayag daw ono yang adto sa suud ng pangatayan nilan. Ikaw oman, akasakitan yang pangatayan mo na maynang dyonggab kaw ng matalas na lodyo.” ");
INSERT INTO kqew_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na, adto sang Baay ng Tohan aon oman sambok na nabi na boyag da na pyagangaanan kang Ana. Anak yan ni Panuel na tribo ni Asir. Pitongka toig gaid nan mapagtibu sang bana nan aw yamabiyoda da yan. ");
INSERT INTO kqew_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aw adon 84 ka toig yang idad nan. Wa gaid yan apanaw sang Baay ng Tohan kay allaw-gabi adto yan maga-ibada sang Tohan na yagadowaa aw yagapowasa. ");
INSERT INTO kqew_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na, sidto na wakto sarta yagalaong pa si Simiyon, dyomood yan kanilan. Yamanginsokor yan sang Tohan aw yagalaong yan ng makapantag sang isu adto sang mga otaw na yagatagad sang wakto na alowasun da ng Tohan yang mga taga Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ansinyan nang yatapos da inangun ni Yosop aw si Mariyam yang kariko ng pyagasogo ng Hokoman ng Tohan, yamori da silan adto sang kanilan pyaga-uyaan sang longsod ng Nasarit na sakop ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ansinyan tyomorin da yang isu aw yagakadogang yang kusug nan. Yagakadakowa oman yang kanan katigam aw yabay yan tabangan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, kada toig yakadto yang mga taganak ni Isa sa Awrosalam para sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ansinyan nang yaga-idad si Isa ng sampoo aw dowangka toig, pyaga-agad yan ng mga taganak nan sang pagkadto nilan sang pakaradyaan sobay sang kya-anadan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatapos ng pakaradyaan yamori da silan, awgaid yagapabilin si Isa adto sa Awrosalam na wa akatigam yang mga taganak nan. ");
INSERT INTO kqew_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kay yang pagdumdum nilan na yamagad si Isa sang kadaigan pa na mga otaw na yamori upud kanilan. Agaw, sangka allaw da yang panaw nilan bago pa nilan anapa si Isa adto sang mga kalomonan aw mga inagad nilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nang wa nilan akitaa, byomarik silan adto sa Awrosalam kay untak manganap kanan. ");
INSERT INTO kqew_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatoo na allaw sinyan kinita nilan si Isa adto sang Baay ng Tohan na yaga-ingkod upud sang mga magiindoway ng Hokoman. Yamaningug yan aw yaga-osip kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aw yang kariko ng mga yakadungug kanan yangkatingaa sang kanan katigam aw sang mga tobag nan. ");
INSERT INTO kqew_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Adon, pagkita kanan ng mga taganak nan, yatingaa oman silan aw laong ng ina nan, “Nanga da kaw, kay Itin! Dakowa yang karido nami si ama mo sang pag-anap kammo daw wain da kaw!” ");
INSERT INTO kqew_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ansinyan tyomobag si Isa kanilan, laong nan, “Nanga yanap mayo ako? Wa kadi kamo akatigam na dait na idi ako sang baay ng Ama ko?” ");
INSERT INTO kqew_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Awgaid wa silan pakasabot sidtong pyaglaongan nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ansinyan yamagad da si Isa sang mga taganak nan aw yamori silan adto sa Nasarit. Aw yabay da yan magpangagad sang kariko ng pyaglaongan ng mga taganak nan. Awgaid yang ininang ni Mariyam, tyago nan yang kariko sini na yamangka-inang sa suud ng pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ansinyan yabay tomorin si Isa aw yagakadogang pa yang katigam nan. Kyaoyan yan ng Tohan kipat yang kariko ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ansinyan sang ika-15 na ka toig ng pagkasoltan ni Tibiriyo na yan yang soltan sang bangsa Roma, si Pontiyos Pilato yang gobirnador sang probinsya ng Yahodiya aw si Hirod yang pangoo sang probinsya ng Jalil. Yang lomon ni Hirod na si Pilip yang pangoo sang mga probinsya ng Itoriya aw Tarakonitis, aw si Lisaniyas yang pangoo sa Abilin. ");
INSERT INTO kqew_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yang mga Dakowa na Imam si Anas aw si Kayapas. Na, sidto na wakto pyasampay ng Tohan yang kanan pyaglaongan adto kang Yahiya na anak ni Sakariyas nang idto yan paga-uya sang kamingawan. ");
INSERT INTO kqew_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agaw pyomanaw da si Yahiya aw kadtoni nan yang kariko ng mga banwa na masaid sang tobig ng Yordan aw yaga-osiyat yan sang mga otaw. Laong nan, “Pagtawbat kamo ng mga dosa mayo aw pagpasogbo kamo silbi tanda ng pagtawbat mayo untak amponon ng Tohan yang mga dosa mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yani na ininang ni Yahiya yang pagtoman ng syorat ni Nabi Isayas sang Kitab na laong nan, “Aon sangka otaw na manawag-tawag adto sa kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan. ");
INSERT INTO kqew_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yang kariko ng mga aog abonowan, yang kabutayan pantayun. Yang mga daan na liko-liko toridun aw yang mga daan na batoon dadayawon. ");
INSERT INTO kqew_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aw ansinyan makita ng kariko ng manosiya daw ono yang inangun ng Tohan sang paglowas kanilan.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, madaig yang mga otaw na kyomadto kang Yahiya untak magpasogbo. Yagalaong si Yahiya kanilan, “Kamo na mga limbongon! Sino kadi yang yagalaong kamayo na kong magapasogbo kamo, makalikay kamo ng siksa ng Tohan na mallug da domatung? ");
INSERT INTO kqew_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na, kong di mayo karim na asiksaun kamo, pakitaan da gaid mayo pina-agi sang madyaw na batasan na bunna na tyarikodan da mayo yang mga dosa mayo. Aw ayaw kamo pagdumdum na di kamo asiksaun kay mga topo kamo ni Nabi Ibrahim. Kay ipaglaong ko kamayo na maskin yani na mga bato amabaoy ng Tohan na mga topo ni Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Timani mayo na main kamo ng kaoy na mallug da pilaun. Kay yang kariko ng kaoy na way madyaw na bonga apilaun aw damian adto sa atoon.” ");
INSERT INTO kqew_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ansinyan yaga-osip kanan yang mga otaw, laong nilan, “Na, kong maynan, ono da yang inangun nami?” ");
INSERT INTO kqew_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tyomobag si Yahiya aw laong nan, “Sino-sino yang aon dowambok na dagom, dait na i-atag nan yang sambok adto sang way dagom. Aw kong aon pagkan mayo, atagi mayo yang way pagkan.” ");
INSERT INTO kqew_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aon oman mga kobrador ng bowis na kyomadto kang Yahiya untak magpasogbo. Yaga-osip silan kanan, “Na kami, kay Goro, ono yang dait nami inangun?” ");
INSERT INTO kqew_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tyomobag si Yahiya aw laong nan kanilan, “Ayaw kamo pagpangobra ng sobra sang pyagasogo kamayo ng gobirno.” ");
INSERT INTO kqew_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na, aon oman mga sondao na yaga-osip kanan, laong nilan, “Na, monono da kami, ono yang dait nami inangun?” Tyomobag si Yahiya kanilan, “Ayaw kamo pagpamugus sang mga otaw atawa pagbutang-butang kanilan untak kamo atagan ng sapi. Aw dait na panginsokoran mayo yang soweldo mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Adon, pagdungug ng mga otaw sang pag-osiyat ni Yahiya, yagadumdum silan na basin si Yahiya yang Almasi na pyasad ng Tohan na pyagatagadan ng bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awgaid yagalaong si Yahiya kanilan, “Tobig yang pyagasogbo ko kamayo, awgaid aon masonod kanak domatung na labaw pa kanak. Maskin yang pag-obad ng liston ng sandalyas nan di dait kanak. Yang pagasogbo nan kamayo yang Nyawa ng Tohan aw yang atoon. ");
INSERT INTO kqew_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yan da yang magahokom sang manosiya aw lainun nan yang mangkadyaw sikun sang mangkaat. Kay main yan ng otaw na magtaap ng omay. Pagkatapos magtaap, tagoon nan yang omay adto sang kamarig. Awgaid yang tipig asonogon nan sang atoon na di amatay.” ");
INSERT INTO kqew_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na, madaig pa yang pyaga-indo ni Yahiya sang mga otaw sang pag-osiyat nan kanilan ng Madyaw na Gogodanun aw pyagalaong nan silan na parinun nilan yang batasan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aw maskin pa si Hirod na pangoo sa Jalil syagda ni Yahiya kay pyangasawa nan si Hirodiya na asawa ng lomon nan na si Pilip aw madaig pa yang ininang nan na maat. ");
INSERT INTO kqew_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aw sang orian dyogangan pa ni Hirod yang kaatan nan kay pyapiriso nan si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, sang wakto na wa pa apirisowa si Yahiya, madaig yang mga otaw na yagapasogbo kanan. Maskin oman si Isa yagapasogbo kanan. Pagkatapos kasogbowan si Isa, yagadowaa yan. Aw sidto na wakto yagaboka yang langit ");
INSERT INTO kqew_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aw yang Nyawa ng Tohan yakunsad adto kanan sa porma ng malapati. Aon oman sowara sikun sang langit na yagalaong, “Ikaw yang pyasaya ko na Anak. Dakowa yang kasowat ko kammo.” ");
INSERT INTO kqew_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Adon si Isa, yagasogod yan mag-indo sang mga otaw sang yaga-idad yan ng mga 30 ka toig. Sang dumduman ng mga otaw anak yan ni Yosop. Si Isa maki-ompo ni Hili. ");
INSERT INTO kqew_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Hili anak ni Matat. Si Matat anak ni Libi. Si Libi anak ni Malki. Si Malki anak ni Yanai. Si Yanai anak ni Yosop. ");
INSERT INTO kqew_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Yosop anak ni Matatiyas. Si Matatiyas anak ni Amos. Si Amos anak ni Nahom. Si Nahom anak ni Isli. Si Isli anak ni Nagay. ");
INSERT INTO kqew_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagay anak ni Maat. Si Maat anak ni Matatiyas. Si Matatiyas anak ni Simain. Si Simain anak ni Yosik. Si Yosik anak ni Yoda. ");
INSERT INTO kqew_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Yoda anak ni Yowanan. Si Yowanan anak ni Risa. Si Risa anak ni Sirobabil. Si Sirobabil anak ni Salatiyal. Si Salatiyal anak ni Niri. ");
INSERT INTO kqew_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Niri anak ni Malki. Si Malki anak ni Addi. Si Addi anak ni Kosam. Si Kosam anak ni Ilmadam. Si Ilmadam anak ni Ir. ");
INSERT INTO kqew_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Ir anak ni Yossa. Si Yossa anak ni Ilisir. Si Ilisir anak ni Yorim. Si Yorim anak ni Matat. Si Matat anak ni Libi. ");
INSERT INTO kqew_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Libi anak ni Simiyon. Si Simiyon anak ni Yodah. Si Yodah anak ni Yosop. Si Yosop anak ni Yonam. Si Yonam anak ni Iliyakim. ");
INSERT INTO kqew_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Iliyakim anak ni Miliya. Si Miliya anak ni Mainan. Si Mainan anak ni Matata. Si Matata anak ni Natan. Si Natan anak ni Daud. ");
INSERT INTO kqew_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Daud anak ni Isai. Si Isai anak ni Obid. Si Obid anak ni Booz. Si Booz anak ni Salmon. Si Salmon anak ni Nason. ");
INSERT INTO kqew_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Nason anak ni Aminadab. Si Aminadab anak ni Admin. Si Admin anak ni Arni. Si Arni anak ni Isrom. Si Isrom anak ni Paris. Si Paris anak ni Yodah. ");
INSERT INTO kqew_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Yodah anak ni Yakob. Si Yakob anak ni Isahak. Si Isahak anak ni Ibrahim. Si Ibrahim anak ni Tirah. Si Tirah anak ni Nahor. ");
INSERT INTO kqew_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor anak ni Sirog. Si Sirog anak ni Ragaw. Si Ragaw anak ni Pilig. Si Pilig anak ni Ibir. Si Ibir anak ni Silah. ");
INSERT INTO kqew_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Silah anak ni Kainan. Si Kainan anak ni Arpaksad. Si Arpaksad anak ni Sim. Si Sim anak ni Noh. Si Noh anak ni Lamik. ");
INSERT INTO kqew_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamik anak ni Mitosala. Si Mitosala anak ni Idris. Si Idris anak ni Yarid. Si Yarid anak ni Mahalalil. Si Mahalalil anak ni Kinan. ");
INSERT INTO kqew_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kinan anak ni Inos. Si Inos anak ni Sit. Si Sit anak ni Adam. Si Adam anak ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pagkatapos kasogbowan si Isa, pyagabuutan yan ng Nyawa ng Tohan. Ansinyan pyomanaw yan sikun sang tobig ng Yordan aw dyaa yan ng Nyawa ng Tohan adto sa kamingawan. ");
INSERT INTO kqew_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ansidto syasat yan ni Iblis sa suud ng 40 na mga allaw. Way kyan nan sidto na wakto aw pagkatapos ng 40 na mga allaw yamagutum da yan. ");
INSERT INTO kqew_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ansinyan yagalaong si Iblis kang Isa, “Aw bunna na ikaw yang Anak ng Tohan, sogowa yani na bato na ma-inang ng pan.” ");
INSERT INTO kqew_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Awgaid tyomobag si Isa aw laong nan, “Yakasorat sang Kitab, ‘Yang manosiya di amabowi sabap sang pagkan da gaid.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapos sinyan dyaa yan ni Iblis adto sang makagwas na logar aw sang pagpamiluk gaid ng mata pyakita nan kanan yang kariko ng mga pyagdatowan adi sa babawan ng donya. ");
INSERT INTO kqew_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ansinyan yagalaong si Iblis kang Isa, “I-atag ko kammo yang kapatot makapantag sang kariko nini na mga pyagdatowan aw yang kakawasaan, kay yatag da kanak yani aw mapakay na i-atag ko sang maskin sino na akallinian ko. ");
INSERT INTO kqew_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Agaw, yang kariko nini amakun mo kong somojod kaw kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tyomobag si Isa aw laong nan, “Yakasorat sang Kitab, ‘Yang Tohan na kammo Tagallang, yan gaid yang asambayangan aw apangagadan mo.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatapos sinyan dyaa yan ni Iblis adto sa Awrosalam aw pa-induga nan sang labi na makagwas na bain sang Baay ng Tohan. Ansinyan yagalaong si Iblis kang Isa, “Aw bunna na ikaw yang Anak ng Tohan, layog adto sa daum! ");
INSERT INTO kqew_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kay yakasorat sang Kitab na “ ‘Asogoon ng Tohan yang kanan mga malaikat sang pag-atiman kammo. ");
INSERT INTO kqew_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Asakgawon kaw nilan untak yang siki mo di komuug sang bato.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Awgaid tyomobag si Isa, “Yakasorat oman sang Kitab na, ‘Ayaw pagtigia yang Tohan na kammo Tagallang.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagkatapos sini na mga pagsasat kang Isa, yamanaw da si Iblis kay atagadan nan yang tuna pa na wakto. ");
INSERT INTO kqew_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ansinyan byomarik si Isa sang probinsya ng Jalil sarta iyan kanan yang kabarakat ng Nyawa ng Tohan. Aw yang gogodanun makapantag kanan yakarimpud sang makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yaga-indo yan adto sang mga pagsasambayangan ng mga Yahodi aw byantog yan ng kariko ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ansinyan kyomadto si Isa sa Nasarit, yang longsod na tyorinan nan. Pagdatung ng allaw ng Sabado na Allaw ng Pagpatana ng mga Yahodi, kyomadto yan sang pagsasambayangan sobay sang kya-anadan nan. Ansinyan yamindug yan kay magabatya ng Kitab. ");
INSERT INTO kqew_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aw yatag kanan yang Kitab na lyuun na syorat ni Nabi Isayas. Pagboka nan sinyan, kinita nan yang mga ayatan na yagalaong, ");
INSERT INTO kqew_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Idi kanak yang Nyawa ng Tohan kay pinili nan ako untak magpayapat ng Madyaw na Gogodanun adto sang mga miskinan. Syogo nan ako untak magpatigam sang mga yapiriso na palogwaun da silan aw yang mga bota na makakita da silan. Syogo nan ako untak tabangan ko yang mga otaw na pyagadaog-daog, ");
INSERT INTO kqew_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aw untak magpatigam na dyomatung da yang wakto na alowasun da ng Tohan yang mga otaw na sakop nan.” ");
INSERT INTO kqew_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ansinyan lyuun da oman ni Isa yang Kitab aw orian nan sang tigtabang sang pagsasambayangan aw pag-ingkod. Na, yang kariko ng mga otaw ansan yagatanaw kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ansinyan yagalaong yan kanilan, “Yani na yakasorat sang Kitab yatoman da adon sarta pyagadungug mayo yani na byatya ko.” ");
INSERT INTO kqew_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ansinyan byantog yan ng kariko nilan aw yatingaa silan sang madyaw na pyaglaongan nan. Aw laong oman nilan, “Di ba yani yang anak ni Yosop?” ");
INSERT INTO kqew_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ansinyan yagalaong si Isa kanilan, “Yamatigam ako na pagalaongon mayo ako sidtong pasombingay na yagalaong, ‘Kay mananambalay, pakadyawa ona yang ginawa mo.’ Aw magalaong oman kamo na inangun ko adi sang sarili na longsod ko yang dyungug mayo na ininang ko adto sa Kapirnaom. ");
INSERT INTO kqew_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Awgaid bunna yang ipaglaong ko kamayo na yang nabi di addatan sang kanan banwa. ");
INSERT INTO kqew_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na, paningug kamo. Sidtong panahon ni Nabi Iliyas, way owan sa suud ng toongka toig aw tunga aw dakowa yang gutum sang tibok banwa ng Israil. Bunna na madaig yang mga biyoda sang Israil sidtong panahon, ");
INSERT INTO kqew_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","awgaid wa asogowa ng Tohan si Nabi Iliyas sang maskin isa kanilan, kondi syogo yan adto sang sambok na biyoda na dili ng Yahodi na idto paga-uya sang Saripta na sakop ng Sidon. ");
INSERT INTO kqew_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aw bunna oman na madaig yang sanglaun sang banwa ng Israil sidtong panahon ni Nabi Ilisiyo. Awgaid way maskin isa kanilan na pyakadyaw yatabiya si Naaman na taga Siriya.” ");
INSERT INTO kqew_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na, pagdungug sinyan yadaman da yang kariko ng mga Yahodi sang pagsasambayangan. ");
INSERT INTO kqew_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ansinyan yamindug silan aw goyoda nilan si Isa adto sa logwa ng longsod na iyan sa babaw ng butay kay untak oogon gao nilan si Isa sang kuba. ");
INSERT INTO kqew_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Awgaid yamagi si Isa sang tunga nilan aw pyomanaw. ");
INSERT INTO kqew_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ansinyan kyomadto si Isa sa Kapirnaom na sambok na longsod na sakop ng Jalil. Pagdatung ng Allaw ng Pagpatana, yaga-osiyat yan sang mga otaw adto sang pagsasambayangan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yangkatingaa silan sang pag-indo nan kay yaga-indo yan na aon kapatot. ");
INSERT INTO kqew_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sidto na pagsasambayangan aon sangka otaw na kyasaytanan. Pagkita nan kang Isa, yagapiyagit yan aw laong nan, ");
INSERT INTO kqew_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oy! Ono yang labot mo kanami, kay Isa na taga Nasarit? Yakani kaw sang pagsapad kanami? Yamatigam ako daw sino kaw, ikaw yang sotti na syogo ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Awgaid syagda ni Isa yang saytan, laong nan, “Katingun aw logwa da sinyan na otaw!” Na, sa atobangan ng kariko nilan tyowad ng saytan idtong otaw. Pagkatapos, lyomogwa da yang saytan aw wa da nan apasikoti idtong otaw. ");
INSERT INTO kqew_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ansinyan yangkatingaa da yang kariko ng mga otaw aw yanag-inosipay silan, laong nilan, “Ono kadi yani na indowan? Kay aon kapatot aw kabarakat nan pagsogo sang mga saytan aw malogwa da silan!” ");
INSERT INTO kqew_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na, ansinyan yakarimpud yang gogodanun makapantag kang Isa adto sang makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagkatapos sinyan lyomogwa si Isa sikun sidtong pagsasambayangan aw kyomadto yan sang baay ni Simon. Adon, yang ogangan na bobay ni Simon yamasakit aw labi na mapaso yang lawas nan. Agaw yangyo nilan si Isa na atabangan nan idtong bobay. ");
INSERT INTO kqew_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ansinyan dyomood si Isa sang kowangan nan aw papanawa nan yang kapaso sikun sang lawas nan aw yamadyaw dayon yan. Na, yagabangon da yan aw pakana nan silan Isa. ");
INSERT INTO kqew_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ansinyan pagsallup ng suga, dyaa ng mga otaw yang kariko ng mga masakitun na maskin ono yang sakit nilan adto kang Isa. Aw dyapunan ni Isa yang matag-isa kanilan ng arima nan aw pakadyawa nan silan. ");
INSERT INTO kqew_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Madaig oman yang mga saytan na pyalogwa nan sikun sang mga otaw, aw paglogwa nilan yagapiyagit silan aw laong nilan, “Ikaw yang Anak ng Tohan!” Awgaid syagda silan ni Isa aw wa nan silan atogoti na magalaong kay kyatigaman nilan na si Isa yang Almasi. ");
INSERT INTO kqew_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagka-ilaw sinyan ng masuum pa pyomanaw si Isa aw kyomadto yan sang mamingaw na banwa. Ansinyan pyagapanganap yan ng mga otaw. Pagkita nilan kanan, pyagadumutan nilan yan. ");
INSERT INTO kqew_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Awgaid yagalaong si Isa kanilan, “Kinaanglan na magapayapat oman ako adto sang kadaigan pa na mga banwa ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan. Kay yan yang katoyowan nanga syogo ako adi sining donya.” ");
INSERT INTO kqew_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ansinyan yabay mag-osiyat si Isa adto sang mga pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sangallaw sinyan yaga-indug si Isa adto sang kilid ng Linaw ng Ginisarit. Madaig yang mga otaw na yanagkatipon adto kanan aw yanagdinutdutay silan untak makapaningug silan sang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ansinyan aon kinita ni Isa na dowambok na bangka na dyaik sang baybay. Ibiyaan idto ng mga mangingisdaay kay yanag-ogas silan ng kanilan pokot. ");
INSERT INTO kqew_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Adon, syomakay si Isa sang sambok na bangka na kanang Simon aw yangyo nan si Simon na idoso nan yang bangka ng tagbis adto sang tobig. Ansinyan yamingkod si Isa aw yaga-indo yan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapos nan mag-indo, yagalaong yan kang Simon, “Pagbugsay kamo palaod aw itaktak mayo yang pokot untak aon amakamang mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yagalaong si Simon, “Kay Dato, sanggabi pa kami yamanagat aw way yakamang nami. Awgaid sabap sang pyaglaongan mo itaktak ko yang pokot.” ");
INSERT INTO kqew_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tyaktak sagaw nilan yang pokot aw madaig yang isda na yakamang nilan na apit da gao malasi yang pokot. ");
INSERT INTO kqew_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Agaw siningyasan nilan yang mga kaupudanan nilan adto sang sambok oman na bangka untak tomabang silan kanilan. Pagdatung nilan, pyono nilan yang dowambok na bangka ng isda na masaid da gao malonod. ");
INSERT INTO kqew_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na, pagkita sinyan ni Simon Pitros, lyomood yan sa atobangan ni Isa aw yagalaong yan, “Pagpakawat kanak, kay Dato, kay manosiya ako na baradosa.” ");
INSERT INTO kqew_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kay yatingaa yan kipat yang kariko ng mga kaupudanan nan sang kadaig ng isda na yakamang nilan. ");
INSERT INTO kqew_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yatingaa oman si Yahiya aw si Yakob, yang mga anak ni Sibidi, na mga kaupud ni Simon sang pagpanagat. Ansinyan yagalaong si Isa kang Simon, “Ayaw pagkalluk, kay Simon, kay sikun adon indowan ta kaw pagkamang ng mga otaw untak magpangagad silan kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ansinyan dyaik nilan yang mga bangka, biniyaan nilan yang kariko aw yamagad silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sangallaw sinyan nang adto si Isa sang sambok na longsod, aon dyomatung na otaw na sanglaun. Pagkita nan kang Isa, syomojod yan sa atobangan nan aw yaga-angyo kanan, laong nan, “Kay Dato, kong karim mo, makapagkadyaw kaw ng kanak sakit.” ");
INSERT INTO kqew_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ansinyan dyapunan ni Isa yang inyan na otaw ng arima nan aw laong nan, “Uu, karim ko. Amadyaw da kaw.” Na, sinyan na wakto yawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ansinyan pyagalaong yan ni Isa, “Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqew_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Awgaid maskin maynan, yakarimpud da yang gogodanun makapantag kang Isa sang makilibot na mga banwa. Agaw, madaig yang mga otaw na kyomadto kanan untak maningug sang pag-osiyat nan aw untak magpakadyaw ng mga sakit nilan. ");
INSERT INTO kqew_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Awgaid si Isa, ugun-ugun yan komadto sang mamingaw na mga banwa aw adto da yan pagadowaa. ");
INSERT INTO kqew_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sangallaw sinyan sarta yaga-indo si Isa, aon mga Parisi kipat yang mga magiindoway ng Hokoman na yanag-ingkod sang masaid kanan. Yani silan yagasikun sang yagakatuna-tuna na mga banwa sa Jalil aw Yahodiya aw sikun oman sa Awrosalam. Na, iyan kang Isa yang kabarakat ng Tohan pagpakadyaw sang mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ansinyan aon dyomatung na mga otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. Yamaningkamot silan somuud sang baay untak madaa nilan idtong otaw sa atobangan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Awgaid sabap sang kadaig ng mga otaw wa silan pakasuud. Agaw pyomanik silan sang atup, bosloti nilan yang mga tisa aw tontona nilan idtong otaw sang kowangan nan sang tunga ng mga otaw sa atobangan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, yampon da yang mga dosa mo.” ");
INSERT INTO kqew_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagdungug sinyan ng mga Parisi kipat yang mga magiindoway ng Hokoman, yagalaong silan sang ginawa nilan, “Sino kadi yani na otaw na yaga-akun ng kapatot ng Tohan? Kay yang Tohan gaid yang maka-ampon ng dosa ng manosiya!” ");
INSERT INTO kqew_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Awgaid kyatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Nanga maynan yang dumduman mayo? ");
INSERT INTO kqew_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wain yang masayun paglaong, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon aw panaw?’ ");
INSERT INTO kqew_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Adon, untak katigaman mayo na ako na Anak ng Manosiya, aon kapatot ko adi sa babawan ng donya sang pag-ampon ng mga dosa.” Ansinyan yagalaong si Isa sidtong otaw na sadi, “Kay Itin, pagbangon, daa yang kowangan mo aw ori da adto kamayo!” ");
INSERT INTO kqew_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ansinyan yagabangon dayon yan na kinita ng kariko nilan, kamanga yang kowangan nan aw ori adto kanilan na yagapoji sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ansinyan yangkatingaa yang kariko nilan aw pyoji nilan yang Tohan. Yangkalluk oman silan aw laong nilan, “Bali na katingaan yani na kinita natun adon na allaw!” ");
INSERT INTO kqew_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos sinyan pyomanaw da si Isa. Sarta yagapanaw yan, kinita nan yang sambok na kobrador ng bowis na yaga-ingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Libi. Laong ni Isa kanan, “Bita da, agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ansinyan yamindug si Libi, biyai nan yang kariko ng gawbuk nan aw agad kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wa akadogay sinyan yagapakaradyaan si Libi sang baay nan para kang Isa. Madaig yang mga kobrador ng bowis aw yang kadaigan pa na mga otaw na yanag-upud kanilan koman. ");
INSERT INTO kqew_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pagkita sinyan ng mga Parisi aw yang mga magiindoway ng Hokoman na mga kaupudanan nilan, yagalaong silan sang mga inindowan ni Isa, “Nanga yanagpangan aw yanag-inum kamo upud sang mga kobrador ng bowis aw yang kadaigan pa na mga otaw na tyawag na baradosa?” ");
INSERT INTO kqew_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Awgaid tyomobag kanilan si Isa, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. ");
INSERT INTO kqew_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mag-onawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan kondi para sang mga otaw na baradosa kay untak magtawbat silan.” ");
INSERT INTO kqew_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ansinyan aon mga otaw na yagalaong kang Isa, “Yang mga inindowan ni Yahiya yabay magpowasa aw magdowaa mag-onawa oman sang mga inindowan ng mga Parisi. Awgaid yang mga inindowan mo abay gaid managpangan aw manag-inum. Nanga?” ");
INSERT INTO kqew_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tyomobag si Isa, “Mapakay ba paglaongon yang mga bisita sang kawin na magapowasa silan sarta iyan pa kanilan yang usug na akawinun? Dili! ");
INSERT INTO kqew_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun, aw sidto na wakto magapowasa da silan.” ");
INSERT INTO kqew_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yagalaong oman si Isa ng tuna pa na pasombingay makapantag sang dadaan na indowan aw yang indowan nan, laong nan, “Way otaw na magalasi ng bago na dagom untak itompaa nan sang dadaan. Kay kong maynan yang inangun nan, alasiun nan yang bago na dagom aw yang tyompaa dili bagay sang dadaan. ");
INSERT INTO kqew_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Way oman otaw na yang bago na bino ilasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, ma-asag da yang bino aw amasapad yang lasakanan. ");
INSERT INTO kqew_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Agaw sagaw, yang bago na bino dait ilasak sang bago na lasakanan. ");
INSERT INTO kqew_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Awgaid sino-sino yang yaka-inum ng dadaan na bino di mallini sang bago kay magalaong yan, ‘Madyaw yang nanam ng dadaan.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sangallaw sinyan na Allaw ng Pagpatana yamagi si Isa kipat yang mga inindowan nan sang pawa ng trigo. Pag-agi nilan, yangutu yang mga inindowan nan ng trigo, ligisa ng arima nilan aw kana. ");
INSERT INTO kqew_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pagkita sinyan ng mga Parisi, yagalaong silan, “Nanga ininang mayo yang syagda kanatun? Sopak sang Hokoman maggawbuk sang Allaw ng Pagpatana!” ");
INSERT INTO kqew_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tyomobag si Isa kanilan, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sang wakto na yamagutum yan kipat yang mga kaupudanan nan? ");
INSERT INTO kqew_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Syomuud yan sang Baay ng Tohan, kamanga nan yang pan na pyasampay adto sang Tohan, kana aw atagi oman yang mga kaupudanan nan. Na, sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan.” ");
INSERT INTO kqew_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Laong oman ni Isa, “Ako na Anak ng Manosiya, aon kapatot ko paglaong daw ono yang mapakay inangun sang Allaw ng Pagpatana.” ");
INSERT INTO kqew_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sang tuna oman na Allaw ng Pagpatana kyomadto si Isa sang pagsasambayangan aw yaga-indo. Ansan aon sambok na otaw na yamasadi yang sangkilid na arima nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aon oman mga magiindoway ng Hokoman kipat yang mga Parisi ansan na yagasima kang Isa daw pakadyawon nan idtong otaw sang Allaw ng Pagpatana kay karim nilan na aon ikasombong nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Awgaid kyatigaman ni Isa yang dumduman nilan. Agaw yagalaong yan sang otaw na yamasadi yang sangkilid na arima nan, “Pag-indug aw adi kaw sa atobangan.” Ansinyan yamindug yan aw kadto sang atobangan ng kariko nilan. ");
INSERT INTO kqew_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Adon yagalaong si Isa, “Aon osip ko kamayo. Sobay sang Hokoman, ono yang mapakay inangun sang Allaw ng Pagpatana? Yang pag-inang ng madyaw atawa maat? Yang paglowas sang kinabowi ng otaw atawa yang pagpatay?” ");
INSERT INTO kqew_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ansinyan pyagatanawan ni Isa yang kariko nilan. Pagkatapos, yagalaong yan sang otaw na yamasadi yang sangkilid na arima nan, “Onata yang arima mo!” Na, yonat da nan yang arima nan aw yamadyaw dayon yani. ");
INSERT INTO kqew_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Awgaid labi da yang kadaman ng mga magiindoway ng Hokoman aw yang mga Parisi aw yanagbaaw-baaw silan daw ono yang inangun nilan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wa akadogay sinyan syomakat si Isa sang sambok na butay aw adto yan pagadowaa ng sanggabi. ");
INSERT INTO kqew_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagka-ilaw sinyan tyawag nan yang kanan mga inindowan aw pinili nan yang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yani silan si Simon na ingaanan nan kang Pitros, aw yang lomon nan na si Andriyas, si Yakob aw si Yahiya, si Pilip aw si Bartolomi, ");
INSERT INTO kqew_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Matiyo aw si Tomas, si Yakob na anak ni Alpiyo, aw si Simon na rebelde singaon, ");
INSERT INTO kqew_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Yodas na anak ni Yakob, aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ansinyan lyomodsad si Isa upud sang mga sahabat nan adto sang patag. Madaig yang mga inindowan ni Isa na yanagkatipon ansan aw iyan oman yang madaig na mga otaw na yagasikun sa Awrosalam aw sikun sang kadaigan pa na mga banwa na sakop ng Yahodiya kipat oman sang mga banwa na sakop ng Tiros aw Sidon na masaid sang dagat. ");
INSERT INTO kqew_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kyomadto silan untak maningug sang pag-indo ni Isa aw untak pakadyawon silan ng mga sakit nilan. Maskin yang mga otaw na kyasaytanan pyakadyaw nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aw yang kariko ng mga otaw sinyan yamaningkamot magtakmag kang Isa kay aon kabarakat sikun kanan na yagapakadyaw sang kariko nilan. ");
INSERT INTO kqew_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ansinyan pyagatanawan ni Isa yang mga inindowan nan aw laong nan, “Kadyaw ng ginawa mayo kong yamatigam kamo na way ma-inang mayo kong di kamo atabangan ng Tohan, kay yasakop da kamo sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kadyaw ng ginawa mayo kong mallini kamo magpangagad sang karim ng Tohan, kay atabangan nan kamo sang pag-inang ng karim nan. Kadyaw ng ginawa mayo kong magatiyao kamo sabap sang kaatan adi sang donya, kay sang madatung na mga allaw amasowat da kamo. ");
INSERT INTO kqew_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kadyaw ng ginawa mayo kong adumutan kamo ng mga otaw aw ataripundaan kamo nilan, kong pag-insoltoon kamo aw paglaongon kamo ng maat sabap sang pagpangagad mayo kanak na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Kay maynan oman yang ininang ng mga kaompowan nilan adto sang mga nabi singaon. Agaw pangkasowat kamo kong ma-inang da idto kamayo aw sayaw kamo ng kasowat kay mag-onawa sidtong mga nabi dakowa yang baras mayo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Awgaid labi na maat yang adatungan mayo kong yagadumdum kamo na di kinaanglan na atabangan kamo ng Tohan, kay yadawat da mayo yang kasowat mayo. ");
INSERT INTO kqew_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Labi na maat yang adatungan mayo kong yang ginawa gaid mayo yang kyaridowan mayo, kay madatung yang allaw na apabayaan da kamo ng Tohan. Labi na maat yang adatungan mayo kong di kamo akasakitan sabap sang kaatan adi sang donya, kay madatung yang allaw na amarido da kamo aw magatiyao. ");
INSERT INTO kqew_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Labi na maat yang adatungan mayo kong abay kamo bantogon ng mga otaw, kay yani oman yang ininang ng mga kaompowan nilan adto sang mga nabi na dili ng bunna.” ");
INSERT INTO kqew_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yagalaong oman si Isa, “Awgaid kamo na yamaningug kanak, yani yang ipaglaong ko kamayo, kaoyi yang kalaban mayo aw pag-inangan mayo ng madyaw idtong yagadumut kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pagpangayowi mayo ng kadyawan yang yamaminta kamayo aw pagdowaai idtong yagapasakit kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kong aon magasampal sang sangkilid na pisngi mo, pasampalan oman kanan yang sangkilid. Kong aon makamang ng kammo dagmay, pakamangan oman kanan yang kammo dagom. ");
INSERT INTO kqew_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Atagi yang sino-sino na amangayo kammo. Aw kong aon magakamang ng kammo butang, ayaw da pagbawia. ");
INSERT INTO kqew_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na, pag-inang kamo adto sang kapag-onawa mayo daw ono yang karim mayo na inangun nilan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kong kaoyan mayo yang yamaooy oman kamayo, ono yang baras mayo? Kay maskin yang mga baradosa na wa asobay sang sogowan ng Tohan yaga-inang ng mayninyan. ");
INSERT INTO kqew_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kong pakitaan mayo ng madyaw yang idtong yaga-inang kamayo ng madyaw, ono yang baras mayo? Maskin yang mga baradosa yaga-inang ng mayninyan. ");
INSERT INTO kqew_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kong magapahiram kamo sidtong amakabayad kamayo, ono yang baras mayo? Maskin yang mga baradosa yagapahiram sang kapag-onawa nilan na baradosa kong kyatigaman nilan na makabayad silan. ");
INSERT INTO kqew_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Awgaid yang madyaw na inangun mayo na akaoyan mayo yang kalaban mayo aw pag-inangan mayo silan ng madyaw. Pagpahiram kamo aw ayaw da kamo pagtagad na abayadan pa kamo. Kong maynan yang inangun mayo, dakowa yang baras mayo aw akatigaman da na mga anak kamo ng Labi na Makagwas. Kay yang Tohan madyaw maskin sang mga otaw na maat aw di matigam manginsokor. ");
INSERT INTO kqew_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na, dait na maoyanun kamo mag-onawa ng Tohan na Ama mayo na maoyanun. ");
INSERT INTO kqew_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ayaw kamo paghokom sang kadaigan untak di oman kamo hokoman ng Tohan. Ayaw kamo paglaong na dait silan siksaun ng Tohan untak di oman kamo asiksaun ng Tohan. Ampona mayo yang yakadosa kamayo untak amponon oman kamo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pangatag kamo kay atagan oman kamo ng Tohan. Sa way dowa-dowa, dakowa yang i-atag nan kamayo na maynang dyasuk aw yamanlapya pa. Kay daw ono yang kadakowa ng atag mayo sang kadaigan, maynan oman yang i-atag kamayo ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ansinyan pyagalaong silan ni Isa nini na pasombingay, laong nan, “Maka-agak ba yang bota ng sambok oman na bota? Dili! Kay kong inangun nan, silan dowa amallog sang longag. ");
INSERT INTO kqew_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Way inindowan na labaw pa sang goro nan, awgaid kong yatapos da nan yang pagpangadi nan, na, mag-onawa da yan sang goro nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nanga kono kinita mo yang bagaso sang mata ng lomon mo, awgaid yang kaoy na iyan sa kammo mata pyasagdan da mo? ");
INSERT INTO kqew_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nanga makapaglaong kaw sang kammo lomon, ‘Tabiya, kay lomon, akamangun ko yang bagaso sang mata mo,’ sarta wa mo akitaa yang kaoy sang kammo mata? Ikaw na yagapakita-kita gaid, kamanga ona yang kaoy sang kammo mata untak kaw makakita ng madyaw sang pagkamang mo yang bagaso sang mata ng lomon mo. ");
INSERT INTO kqew_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yang madyaw na kaoy di mabonga ng maat, aw yang kaoy na dili ng madyaw di oman mabonga ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Agaw yang matag-isa na kaoy akatigaman sabap sang bonga nan. Kay di maka-ipo ng igira sikun sang sampinit, aw di oman maka-ipo ng grips sikun sang bowa. ");
INSERT INTO kqew_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mag-onawa sinyan, yang madyaw na otaw madyaw yang pyaglaongan nan kay madyaw yang lasak ng pangatayan nan. Awgaid yang maat na otaw, maat yang pyaglaongan nan kay maat yang lasak ng pangatayan nan. Kay yang maskin ono na adto sa suud ng pangatayan ng otaw, idto oman yang ipaglaong nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nanga pagtawagun mayo ako na ‘Dato,’ awgaid di mayo apangagadan yang pyaglaongan ko? ");
INSERT INTO kqew_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na, ipakita ko kamayo daw sino yang otaw na domood kanak aw amaningug sang pyaglaongan ko aw apangagadan nan. ");
INSERT INTO kqew_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mag-onawa yan ng otaw na yaga-inang ng baay. Yagakotkot yan ng maum aw pa-induga nan yang baay sang bato. Na, maskin yagabaa aw yasogat da yan na baay ng tobig, wa yan akatowad kay madyaw yang pyagapa-indugan sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Awgaid sino-sino yang amaningug sang pyaglaongan ko awgaid di nan apangagadan, mag-onawa yan ng otaw na yaga-inang ng baay na way pondasyon. Pagdatung ng baa aw yasogat da yan na baay ng tobig, yatowad yan aw yadanas.” ");
INSERT INTO kqew_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapos ni Isa mag-indo ng kariko sinyan adto sang mga otaw, kyomadto yan sang longsod ng Kapirnaom. ");
INSERT INTO kqew_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ansidto aon kapitan ng mga sondao na taga Roma na yang sogowanun nan yamasakit aw yaga-irap da. Dakowa sang pangatayan ng kapitan idtong sogowanun nan. ");
INSERT INTO kqew_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Agaw, pagdungug ng kapitan ng makapantag kang Isa, syogo nan yang pilangka otaw na mga pangoo ng mga Yahodi sang pagkamang kang Isa untak pakadyawon nan yang kanan sogowanun. ");
INSERT INTO kqew_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Adon, pagdatung ng mga pangoo adto kang Isa, yaga-angyo sagaw silan kanan aw laong nilan, “Yani na otaw dait gaid na atabangan mo. ");
INSERT INTO kqew_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kay yamaooy yan kanatun na mga Yahodi aw yagapatokod yan ng pagsasambayangan para kanatun.” ");
INSERT INTO kqew_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Agaw yamagad kanilan si Isa. Awgaid nang masaid da si Isa sang baay ng kapitan, syogo ng kapitan yang mga kaupudanan nan sang pagsongon kang Isa kay untak paglaongon nilan, laong nan, “Ampon tabiya kammo, kay Sir, ayaw da gaid pagpanaos kay way kapatot ko pagtarima kammo sang kanak baay. ");
INSERT INTO kqew_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aw di oman ako dait mapag-atobang kammo kay labaw kaw kanak. Paglaong gaid aw amadyaw da yang sogowanun ko. ");
INSERT INTO kqew_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kyatigaman ko yani kay ako yagapasakop sang labaw pa kanak aw aon oman mga sondao na yagapasakop kanak. Kong sogoon ko yang isa, ‘Adto kaw,’ makadto yan. Kong sogoon ko yang isa, ‘Adi kaw,’ makani yan. Aw kong sogoon ko yang kanak sogowanun, ‘Inanga yani,’ na, inangun da nan.” ");
INSERT INTO kqew_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagdungug sinyan ni Isa, yatingaa yan. Yaga-atobang yan sang mga otaw na yamagad kanan aw yagalaong yan, “Ipaglaong ko kamayo na waa pay kinita ko na otaw na bangsa Israil na maynini kadakowa ng pagpangintoo nan.” ");
INSERT INTO kqew_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ansinyan yamori yang mga syogo ng kapitan aw pagdatung nilan sang baay, kinita nilan na madyaw da yang sogowanun. ");
INSERT INTO kqew_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wa akadogay sinyan kyomadto si Isa sang longsod na pyagangaanan sang Nain upud sang mga inindowan nan. Madaig oman yang mga otaw na yamagad kanan. ");
INSERT INTO kqew_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sang masaid da silan sang pasuudan sidto na longsod, aon mga otaw na yalogwa sikun sinyan na yanaglanting ng patay. Yang idtong patay tongga na anak na usug ng biyoda. Madaig yang mga otaw na yamagad kanan sang paglubung. ");
INSERT INTO kqew_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkita ni Isa sidtong biyoda, yarikad yang kanan pangatayan aw laong nan kanan, “Ayaw da pagtiyao.” ");
INSERT INTO kqew_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ansinyan dyomood si Isa aw tyakmagan nan yang tanggongan. Agaw yamondang yang mga otaw na yanaglanting sinyan. Laong ni Isa sang patay, “Kay Itin, bangon da!” ");
INSERT INTO kqew_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na, yagabangon da yang patay aw yagalaong kay yamabowi da oman yan. Ansinyan yatag da yan ni Isa adto sang ina nan. ");
INSERT INTO kqew_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na, yangkalluk da yang kariko ng mga otaw. Pyoji nilan yang Tohan aw laong nilan, “Kyadumduman ng Tohan yang mga otaw na sakop nan kay pyakani nan kanatun yang sambok na nabi na mabarakat!” ");
INSERT INTO kqew_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ansinyan yakarimpud yang gogodanun makapantag sini na inang ni Isa sang tibok probinsya ng Yahodiya kipat sang makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ansinyan pyagalaong si Yahiya ng kanan mga inindowan makapantag sang kariko ng ininang ni Isa. Agaw tyawag nan yang dowangka otaw na inindowan nan ");
INSERT INTO kqew_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aw sogowa nan silan adto kang Isa untak mag-osip kanan daw yan agaw yang pyasad ng Tohan na madatung atawa aon pay tuna na atagadan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na, pagdatung nilan kang Isa, yagalaong silan, “Syogo kami ni Yahiya na Magsosogboway untak mag-osip kammo daw ikaw ba yang pyasad ng Tohan na madatung atawa aon pay tuna na atagadan nami.” ");
INSERT INTO kqew_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, sidto na wakto nang dyomatung idtong dowangka otaw, madaig yang mga masakitun na pyakadyaw ni Isa aw pyalogwa nan yang mga saytan sikun sang mga otaw na kyasaytanan, aw madaig yang mga bota na pyakadyaw nan aw yakakita da oman silan. ");
INSERT INTO kqew_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ansinyan tyomobag si Isa sang mga inindowan ni Yahiya, “Barik da kamo adto kang Yahiya aw paglaonga mayo daw ono yang kinita aw dyungug mayo. Paglaonga mayo yan na yang mga bota yakakita da, yang mga sadi yakapanaw da, yang mga sanglaun yamadyaw da. Yang mga bunguu yakadungug da, yang mga patay yabowi da oman aw yang Madyaw na Gogodanun pyapayapat da adto sang mga miskinan. ");
INSERT INTO kqew_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kadyaw ng ginawa ng otaw na wa pagadowa-dowa kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagpanaw ng mga inindowan ni Yahiya, yagalaong si Isa adto sang kaotawan makapantag kang Yahiya, laong nan, “Pagkadto mayo sang kamingawan, ono yang kallini mayo kitaun? Sambok na otaw na yagaparin-parin yang dumduman na maynang tambiling na pyagaparid-parid ng samut? ");
INSERT INTO kqew_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na, ono kadi yang kyadtonan mayo? Sambok na otaw na tanto madyaw yang dagom? Dili kowaw, kay yang mga otaw na madyaw yang dagom aw madyaw yang kabutang adto paga-uya sang palasyo ng soltan. ");
INSERT INTO kqew_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Unda, ono sagaw yang kyadtonan mayo? Sambok na nabi? Bunna sagaw na nabi si Yahiya, awgaid labaw pa yan sang kadaigan pa na mga nabi. ");
INSERT INTO kqew_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kay si Yahiya yang pyagalaong sang Kitab na yagalaong yang Tohan, “ ‘Apa-onaun ko kammo yang sogowanun ko untak andamun nan yang agianan mo.’ ");
INSERT INTO kqew_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ipaglaong ko kamayo na sang kariko ng yamangkaotaw adi sa babawan ng donya way makalabaw kang Yahiya. Awgaid adon, maskin yang pinakababa na otaw na magapasakop sang pagdato ng Tohan, labaw pa kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, yang kariko ng mga otaw na yamaningug kang Isa aw maskin yang mga kobrador ng bowis, yagapangimunna silan na matorid yang pama-agi ng Tohan. Yan silan yang yagapasogbo silan kang Yahiya. ");
INSERT INTO kqew_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Awgaid yang mga Parisi kipat yang mga alim ng Hokoman, tyaripundaan nilan yang kahanda kanilan ng Tohan. Agaw wa silan pagapasogbo kang Yahiya. ");
INSERT INTO kqew_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Laong da oman ni Isa, “Ono yang ikatandi ko ng mga otaw adon na panahon? ");
INSERT INTO kqew_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mag-onawa silan sang mga isu na yanag-ingkod adto sa plaza aw yanaglaro silan. Yagalaong da yang kadaigan adto sang mga kaupudanan nilan, “ ‘Pyagatogtogan kamo nami ng kolintang, awgaid wa kamo pagasayaw. Pyagakantaan kamo nami ng kanta ng paglubung, awgaid wa kamo pagatiyao.’ ");
INSERT INTO kqew_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Na, mag-onawa da kamo kanilan. Kay pagdatung ni Yahiya na Magsosogboway, yabay yan magpowasa aw wa yan paga-inum ng bino. Agaw yagalaong kamo na ‘Kyasaytanan kowaw yani na otaw!’ ");
INSERT INTO kqew_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aw pagdatung ko na Anak ng Manosiya, yakan aw yaminum ako. Agaw yagalaong kamo, ‘Tanawa mayo, tokgawon aw paralasing yani na otaw. Inagad yan ng mga kobrador ng bowis aw yang kadaigan pa na mga baradosa!’ ");
INSERT INTO kqew_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Awgaid maskin maynan,” laong ni Isa, “yang bonga ng gawbuk nami ni Yahiya, idto yang tanda na syogo kami ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Adon, sangallaw sinyan pyaga-imbitar si Isa ng sambok na Parisi na pyagangaanan kang Simon untak koman adto sang baay nan. Agaw yamagad si Isa kanan. ");
INSERT INTO kqew_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, sidto na longsod aon bobay na tyawag ng baradosa kay yagakadopang yan. Pagdungug nan na si Isa yakan adto sang baay ng Parisi, kyomadto yan sidto na baay na yagadaa ng tagbi na lasakanan na yamapono ng paballo. ");
INSERT INTO kqew_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pagdatung nan sang baay, yamindug yan sang loyo ni Isa apit sang siki nan na yagatiyao taman sang yamabasa da yang siki ni Isa ng lowa nan. Ansinyan itrapowan da nan yang siki ni Isa ng kanan logay aw yaukan nan. Pagkatapos, yabowan nan ng paballo. ");
INSERT INTO kqew_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkita sinyan ng Parisi, yagalaong yan sang suud ng ginawa nan, “Aw yani na otaw bunna na nabi, kyatigaman gao nan daw sino yani na bobay na yagadamdam kanan kay yan baradosa.” ");
INSERT INTO kqew_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ansinyan yagalaong si Isa kanan, “Kay Simon, aon ipaglaong ko kammo.” “Uu, kay Goro, paglaong da.” ");
INSERT INTO kqew_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na, laong ni Isa, “Aon dowangka otaw na yaka-otang ng sapi sang tigpa-otang. Yang sambok yaka-otang ng 500, aw yang sambok ng 50. ");
INSERT INTO kqew_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Adon, kay wa silan pakabayad ng otang nilan, wa da gaid silan apabayada nidtong tigpa-otang. Na, sino kanilan dowa yang dakowa yang looy sidtong yagapa-otang kanilan?” ");
INSERT INTO kqew_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tyomobag si Simon, “Aw kanak gaid, idtong dakowa yang otang nan.” Laong ni Isa, “Bunna yang tobag mo.” ");
INSERT INTO kqew_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ansinyan lyomingi si Isa sidtong bobay aw yagalaong yan kang Simon, “Kinita mo yang ininang sini na bobay? Pagdatung ko sang kammo baay, wa mo ako atagi ng tobig na paga-ogas sang kanak siki. Awgaid yani na bobay, yogasan nan yang kanak siki ng kanan lowa aw trapowi nan ng kanan logay. ");
INSERT INTO kqew_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wa mo ako auki sang pagsalam kanak, awgaid yani na bobay, yabay nan aukan yang kanak siki sokad pa sang pagdatung ko. ");
INSERT INTO kqew_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wa mo oman ako atagi ng lana para sang kanak oo, awgaid yani na bobay, yabowan nan ng paballo yang kanak siki. ");
INSERT INTO kqew_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Agaw ipaglaong ko kammo na yang dakowa na looy na pyakita nan kanak yagapatigam na yampon da yan ng kanan dakowa na dosa. Awgaid idtong otaw na tagbi gaid yang yampon kanan, tagbi oman yang pyakita nan na looy.” ");
INSERT INTO kqew_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ansinyan yagalaong si Isa sidtong bobay, “Yampon da kaw ng kammo dosa.” ");
INSERT INTO kqew_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Adon, pagdungug sinyan ng kadaigan na mga otaw na yanag-upud kanan koman, yagalaong silan sang ginawa nilan, “Sino kadi yani na otaw na maka-ampon ng dosa?” ");
INSERT INTO kqew_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na, yagalaong da oman si Isa sang bobay, “Yalowas da kaw sabap sang pagpangintoo mo. Panaw da na aon kalinaw.” ");
INSERT INTO kqew_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wa akadogay sinyan yakarimpud si Isa komadto sang kariko ng mga longsod aw baryo aw yagapayapat ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan. Yamagad kanan yang sampoo aw dowa na mga sahabat nan ");
INSERT INTO kqew_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kipat oman yang kadaigan ng mga kaobayan na pyakadyaw nan sikun sang kanilan mga sakit aw pyangamangan ng mga saytan. Yang isa kanilan si Mariyam na taga Magdala na kyamangan singaon ni Isa ng pitombok na saytan. ");
INSERT INTO kqew_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yang isa oman si Yowana na asawa ni Kosa na kyasarigan sang baay ni Hirod. Yamagad oman si Sosana aw yang madaig pa na mga kaobayan. Sikun sang kakawasaan nilan tyabangan nilan si Isa aw yang mga inindowan nan sang mga panginaanglan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ansinyan yabay domatung yang mga otaw sikun sang yagakatuna-tuna na mga banwa aw yanagkatipon silan adto kang Isa. Yaga-indo si Isa kanilan ng pasombingay. ");
INSERT INTO kqew_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Laong nan, “Aon otaw na kyomadto sang pawa untak magsabod ng bini. Sang pagsabod nan, aon mga bini na yamallog adto sang daan. Ansinyan kyaginaan inyan ng mga otaw aw tyobog ng mga langgam. ");
INSERT INTO kqew_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yang kadaigan ng bini yamallog adto sang batoon na lopa. Pagtobo pa gaid, yalanus dayon kay magdang yang lopa. ");
INSERT INTO kqew_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yang kadaigan oman yamallog adto sang lopa na madaig yang sampinit. Na, yagadungan tomorin yang sampinit aw yang mga tanum, aw wa akadogay kyatabonan yang mga tanum. ");
INSERT INTO kqew_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Awgaid yang kadaigan na bini yamallog adto sang madyaw na lopa. Ansinyan tyomorin yang mga tanum aw yabonga ng labi na madaig.” Sang orian yagalaong si Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ansinyan yosip si Isa ng mga inindowan nan daw ono yang mana ng pasombingay. ");
INSERT INTO kqew_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tyomobag si Isa, “Kamo, yatagan kamo ng katigam untak makasabot kamo ng mga tinago makapantag sang pagdato ng Tohan. Awgaid adto sang kadaigan mga pasombingay yang gyamit ko kay untak “ ‘maskin yagatanaw silan, di silan makakita. Aw maskin yamaningug silan, di silan makasabot.’ ");
INSERT INTO kqew_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na, yani kay yang mana ng pasombingay. Yang bini, yan yang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yang kilid ng daan na kyaoogan ng bini, yan yang mga otaw na yakadungug sang pyaglaongan ng Tohan. Awgaid dyomatung si Iblis aw kamanga nan yang pyaglaongan na dyungug nilan sikun sang pangatayan nilan untak di silan mangintoo aw di oman silan amalowas. ");
INSERT INTO kqew_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yang batoon na lopa, yan yang mga yakadungug sang pyaglaongan ng Tohan aw tyarima dayon nilan na aon kasowat. Awgaid sabap ng wa pakagamot yang pyaglaongan sang pangatayan nilan, mallug da gaid yang pagpangintoo nilan. Kay kong adatungan silan ng mga sasat, mabiya dayon silan sang pagpangintoo. ");
INSERT INTO kqew_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yang lopa oman na madaig yang sampinit, yan yang mga yakadungug sang pyaglaongan ng Tohan, awgaid sabap sang karidowan nilan adi sa babawan ng donya aw sabap oman sang kakawasaan aw yang kadaigan pa na kyallinian nilan, kyatabonan da inyan. Idto sagaw, wa abonga yang pagpangintoo nilan. ");
INSERT INTO kqew_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yang madyaw na lopa, yan yang mga yakadungug sang pyaglaongan ng Tohan aw tyarima nilan inyan sa suud ng pangatayan nilan aw pyangagadan nilan na aon pagsabar taman sang yabonga silan ng madyaw.” ");
INSERT INTO kqew_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan aw butangan nan sa saad ng katri atawa asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan kay untak makita yang siga sang pagsuud ng mga otaw sang baay. ");
INSERT INTO kqew_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kay yang maskin ono na yatago, amaklaro sang orian, aw yang wa pa akatigami adon, akatigaman da. ");
INSERT INTO kqew_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Agaw paningug kamo ng madyaw. Kay sino-sino yang amaningug ng madyaw, adogangan pa yang katigam nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyatigaman nan, akamangun pa kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ansinyan dyomatung yang ina ni Isa aw yang mga mangkangod nan na usug. Awgaid wa silan pakadood kang Isa sabap sang kadaig ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ansinyan aon sambok na otaw na yagalaong kang Isa, “Yang ina mo aw yang mga lomon mo adto sa logwa. Mapagkita gao silan kammo.” ");
INSERT INTO kqew_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Awgaid tyomobag si Isa aw laong nan kanilan, “Sino-sino yang amaningug aw amangagad sang pyaglaongan ng Tohan, silan yang ina ko aw yang mga lomon ko.” ");
INSERT INTO kqew_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sangallaw sinyan yagalaong si Isa sang mga inindowan nan, “Bita da kamo, mataripag da kita sang linaw.” Ansinyan syomakay silan sang bangka aw larga da silan. ");
INSERT INTO kqew_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sang yagalayag da silan, yamatoog si Isa. Tyomokaw moyop yang makusug na samut aw kyalasakan da ng tobig yang bangka nilan na masaid da silan malonod. ");
INSERT INTO kqew_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na, dyood ng mga inindowan si Isa aw pokawa nilan. Laong nilan, “Kay Dato! Kay Dato! Amatay da kita!” Ansinyan yagabangon si Isa aw syagda nan yang samut aw yang mangkadakowa na mga baud. Na, yamondang dayon yang samut aw yamalinaw da. ");
INSERT INTO kqew_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ansinyan yagalaong si Isa sang mga inindowan nan, “Wain kadi yang pagpangintoo mayo?” Awgaid yangkalluk da silan na yangkatingaa aw yanag-inosipay silan, laong nilan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud matoman kanan?” ");
INSERT INTO kqew_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ansinyan yagapadayon silan lomayag sampay na dyomatung silan sang logar ng mga taga Girasa na adto sang dipag ng Linaw ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagpanaog ni Isa sang bangka, syongon yan ng sangka otaw sikun sinyan na longsod na kyasaytanan. Yadogay da na yani na otaw wa apandagom aw wa paga-uya sang baay. Awgaid adto da yan paga-uya sang mga langob na pakoboran. ");
INSERT INTO kqew_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkita nan kang Isa yagapiyagit yan, syomojod sa atobangan ni Isa aw laong nan ng matanog, “Kay Isa, Anak ng Tohan na Labi na Makagwas, ono yang labot mo kanak? Pangayoon ko kammo na di mo ako asiksaun!” ");
INSERT INTO kqew_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yagalaong yan ng mayninyan kay syogo da ni Isa yang saytan na apanawan nan inyan na otaw. Kay yabay yani na otaw kalasakan ng saytan, aw maskin gyapos yang arima aw siki nan ng kadina aw byantayan yan ng mga otaw, pyamogto gaid nan yang kadina aw dyaa da oman yan ng saytan adto sang mamingaw na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ansinyan yaga-osip si Isa kanan, “Sino yang ngaan mo?” “Ako si Panon,” yang tobag nan kay madaig yang mga saytan na yakalasak kanan. ");
INSERT INTO kqew_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ansinyan yaga-angyo yang mga saytan kang Isa na di nan silan pakadtonon sang maum na longag na adto silan siksaun. ");
INSERT INTO kqew_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Adon, madaig yang mga binatang na yanagdowang sang kilid ng butay. Agaw yaga-angyo yang mga saytan kang Isa na adto da silan ilasak sidtong mga binatang. Aw yasogot oman si Isa. ");
INSERT INTO kqew_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na, lyomogwa da silan sikun sinyan na otaw aw lasak silan sang mga binatang. Aw yang tibok panon dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangka-umus. ");
INSERT INTO kqew_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod aw sang mga baryo kay igogod nilan sang mga otaw idtong kyatamanan. ");
INSERT INTO kqew_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Agaw yagapaduug kang Isa yang mga otaw kay atanawon nilan daw ono yang yamaitabo. Pagdatung nilan adto kanan, kinita nilan idtong otaw na pyanawan ng mga saytan. Yaga-ingkod da yan sa atobangan ni Isa na yamandagom aw yamori da yang madyaw na dumduman nan. Agaw yangkalluk da silan. ");
INSERT INTO kqew_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Adon, ingaong yakakita sang kyatamanan yagagogod sinyan na mga otaw daw monono yang pagpakadyaw ng otaw na pyanawan da ng mga saytan. ");
INSERT INTO kqew_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ansinyan yang kariko ng mga otaw na yanag-uya sang sakop ng Girasa, yangyo nilan si Isa na apanawan da nan yang banwa nilan kay bali na kalluk nilan. Agaw syomakay da si Isa sang bangka aw larga da silan. ");
INSERT INTO kqew_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Adon, yang otaw na pyanawan ng mga saytan, yaga-angyo yan kang Isa na pa-agadun nan. Awgaid pya-ori yan ni Isa na laong nan, ");
INSERT INTO kqew_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ori da adto kamayo aw paggogod kanilan daw ono yang ininang ng Tohan kammo.” Agaw pyomanaw da idtong otaw aw yagagogod yan sang tibok longsod daw ono yang ininang kanan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagbarik da oman ni Isa adto sang dipag ng linaw, yamasowat yang mga otaw pagdawat kanan kay silan kariko yabay tomagad kanan. ");
INSERT INTO kqew_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ansinyan dyomatung yang sangka otaw na pyagangaanan kang Yairos na pangoo ng pagsasambayangan ng mga Yahodi sinyan na banwa. Syomojod yan sa atobangan ni Isa aw yaga-angyo yan na amagad kanan si Isa adto sang kanan baay. ");
INSERT INTO kqew_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kay yang tongga nan na anak na bobay na sampoo aw dowangka toig yang idad, yagapinal da. Ansinyan yamagad kanan si Isa. Sang yagapaduug si Isa, dyutdut yan ng kaotawan na yamagad kanan. ");
INSERT INTO kqew_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ansan sa tunga ng kaotawan aon sambok na bobay na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. Ya-obos da yang kanan kakawasaan sang pagpatambal sang mga mananambalay, awgaid way yakapagkadyaw kanan. ");
INSERT INTO kqew_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ansinyan dyomood yan kang Isa sang likod nan aw takmagi nan yang sagayadan ng dagom nan. Na, yamondang dayon yang pag-agas ng dogo nan. ");
INSERT INTO kqew_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ansinyan yaga-osip si Isa, “Sino yang yagatakmag kanak?” Awgaid way maskin isa na yaga-akun, agaw yagalaong si Pitros, “Kay Dato, yanagtinooday yang mga otaw aw dyutdut kaw nilan!” ");
INSERT INTO kqew_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Awgaid yagalaong si Isa, “Aon yagatakmag kanak kay byati ko na aon kabarakat na lyomogwa sikun kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Adon, pagkita ng bobay na di da amatago yang ininang nan, dyomood yan kang Isa na tyakigan aw syomojod sang atobangan nan. Ansinyan sa atobangan ng kariko ng mga otaw yagalaong yan daw nanga tyakmagan nan si Isa aw monono yang pagkadyaw nan. ");
INSERT INTO kqew_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yagalaong si Isa kanan, “Kay Bi, sabap sang pagpangintoo mo yamadyaw da kaw. Panaw da na aon kalinaw.” ");
INSERT INTO kqew_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sang yagalaong pa si Isa, aon otaw na dyomatung sikun sang baay ni Yairos. Laong nan kang Yairos, “Yamatay da yang anak mo. Ayaw da pagdistorbowa yang goro.” ");
INSERT INTO kqew_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Awgaid yakadungug sinyan si Isa aw yagalaong yan kang Yairos, “Ayaw pagkalluk. Pagpangintoo gaid aw amadyaw yang anak mo.” ");
INSERT INTO kqew_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na, pagdatung nilan adto sang baay, wa atogoti ni Isa yang maskin sino na amagad kanan pagsuud yatabiya kang Pitros, si Yahiya aw si Yakob aw yang ama aw ina ng isu. ");
INSERT INTO kqew_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na, yang kariko ng mga otaw ansan yanagtiyao aw yanagminatay. Awgaid yagalaong si Isa kanilan, “Ayaw da kamo pagtiyao kay dili ng patay yang isu, yatoog gaid yan.” ");
INSERT INTO kqew_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ansinyan inikuan nilan si Isa kay kyatigaman nilan na yamatay da yang isu. ");
INSERT INTO kqew_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Awgaid si Isa, tyakmagan nan yang arima ng isu aw paglaonga nan, “Kay Bi, bangon da!” ");
INSERT INTO kqew_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na, ansinyan byomarik yang napas nan aw yagabangon dayon yan. Aw yagasogo si Isa na apakanun nilan yang isu. ");
INSERT INTO kqew_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yangkatingaa sagaw yang mga taganak ng isu. Awgaid syagda silan ni Isa na di silan maggogod sang maskin sino daw ono yang yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ansinyan tyawag ni Isa yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw yatagan silan ng kabarakat aw kapatot sang pagpalogwa ng kariko ng mga saytan aw pagpakadyaw ng mga sakit. ");
INSERT INTO kqew_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Syogo nan silan pagpayapat makapantag sang pagdato ng Tohan aw pagpakadyaw ng mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yagalaong yan kanilan, “Sang pagpanaw mayo, ayaw kamo pagdaa ng maskin ono. Ayaw kamo pagdaa ng bangka, maskin ono na lasakanan, ni pagkan atawa sapi. Ayaw oman pagdaa ng ilisan mayo. ");
INSERT INTO kqew_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maskin wain na baay yang adatungan mayo, ansan da kamo pag-uya taman sang pagpanaw mayo sinyan na banwa. ");
INSERT INTO kqew_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kong aon banwa na akadtonan mayo aw yang mga otaw ansan di magatarima kamayo, panawi mayo yan na banwa. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan.” ");
INSERT INTO kqew_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ansinyan pyomanaw da yang mga sahabat aw kyomadto silan sang kariko ng mga banwa. Yanagpayapat silan ng Madyaw na Gogodanun aw pyakadyaw nilan yang mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, pagdungug ni Hirod na soltan sa Jalil ng makapantag sang kariko ng ininang ni Isa, yatingaa yan kay aon mga otaw na yagalaong na si Isa kono si Yahiya na yabowi oman. ");
INSERT INTO kqew_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aon oman kadaigan na yagalaong na yan kono si Nabi Iliyas na yagapakita oman atawa yang sambok na nabi singaon na yabowi oman. ");
INSERT INTO kqew_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Awgaid yagalaong si Hirod, “Pya-otodan da ko si Yahiya ng kanan oo. Na, sino adon yani na otaw na madaig yang katingaan na dyungug ko makapantag kanan?” Agaw, karim da gao nan komita kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ansinyan pagbarik ng mga sahabat ni Isa sikun sang pagpayapat, yanaggogod silan kang Isa daw ono yang ininang nilan. Ansinyan pyaga-agad nan silan aw kyomadto silan sang longsod ng Bitsayda na silan da gaid. ");
INSERT INTO kqew_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Awgaid pagkatigam sinyan ng mga otaw, yalopog silan kang Isa. Pagdatung nilan, dyawat silan ni Isa aw pyaga-osiyatan nan silan makapantag sang pagdato ng Tohan aw pakadyawa nan yang mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pagkasilum sinyan dyomood kang Isa yang sampoo aw dowa na mga sahabat nan aw laong nilan kanan, “Madyaw pa aw pakadtonon da mo yang mga otaw sang makilibot na mga baryo aw sityo untak manganap ng pagkan kipat oman yang akakowangan nilan kay ansini kita sang mamingaw na banwa.” ");
INSERT INTO kqew_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Awgaid yagalaong si Isa kanilan, “Kamo da yang magpakan kanilan.” Tyomobag silan, “Aon gaid kanami limambok na pan aw dowambok na isda. Mapanaw ba kami aw magabili ng pagkan sining kadaig ng mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kay yang kausugan gaid ansan mga 5000. Awgaid yagalaong si Isa sang mga inindowan nan, “Pa-ingkoda mayo yang mga otaw sang mga pondok ng tag-50.” ");
INSERT INTO kqew_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na, ininang da nilan yang pyagasogo kanilan ni Isa aw pa-ingkoda nilan yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ansinyan kyamang ni Isa yang limambok na pan aw yang dowambok na isda, ya-angad sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga inindowan nan untak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqew_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sangallaw sinyan nang yagadowaa si Isa ng sangka otaw da nan, iyan sang masaid kanan yang mga inindowan nan. Ansinyan yaga-osip si Isa kanilan, “Sobay sang mga otaw, sino kono ako?” ");
INSERT INTO kqew_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas, aw yang kadaigan oman yagalaong na ikaw kono yang sambok na nabi singaon na yabowi oman.” ");
INSERT INTO kqew_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Awgaid kamo,” laong ni Isa, “ono yang ikapaglaong mayo daw sino ako?” Tyomobag si Pitros, “Ikaw yang Almasi na pyasad ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Agaw yagalaong si Isa, “Ako na Anak ng Manosiya, dait na amagi ako ng mga kasikotan aw ataripundaan ako ng mga pangoo ng mga Yahodi, mga pangoo ng mga imam kipat oman yang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoo na allaw amabowi oman ako.” Aw ansinyan syagda silan ni Isa na di silan maggogod sang maskin sino ng makapantag kanan. ");
INSERT INTO kqew_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pagkatapos sinyan yagalaong si Isa sang kariko ng mga otaw, “Sino-sino yang marim magpangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqew_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kay sino-sino na yang pyalabi nan yang kanan kinabowi, akawaan sinyan. Awgaid sino-sino na yang pyalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, aka-aonan ng bunna na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kay ono yang amakamang ng otaw kong amakun nan yang kariko ng kakawasaan adi sang donya, awgaid kong amatay da yan asiksaun da yan adto sang narka? ");
INSERT INTO kqew_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sino-sino yang yamomowa maglaong sa atobangan ng kadaigan na yagapangagad yan kanak kipat yang indowan ko, akamomowa ko oman yan sang wakto na mabarik ako na Anak ng Manosiya adi sang donya sang kanak kasiga, aw yang kasiga ng kanak Ama kipat yang sotti na mga malaikat. ");
INSERT INTO kqew_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Awgaid bunna yang ipaglaong ko kamayo na aon mga otaw disini na di pa amatay taman sang amakita da nilan na magadato da yang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga sangka simana pagkatapos sidto na pyaglaongan ni Isa pyaga-agad nan si Pitros, si Yahiya aw si Yakob aw syomakat silan sang butay untak magdowaa. ");
INSERT INTO kqew_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aw sarta yagadowaa si Isa, yaparin yang kanan parangay aw yagakapoti yang kanan dagom na mag-onawa ng allag na labi na masilaw. ");
INSERT INTO kqew_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sakadyap aon dowangka otaw na yapagbaaw kanan. Yani silan si Nabi Mosa aw si Nabi Iliyas. ");
INSERT INTO kqew_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yagasiga oman yang mga dagom nilan aw yapagbaaw silan kang Isa makapantag sang pagkamatay nan adto sa Awrosalam na masaid da matoman sobay sang kahanda ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Adon, si Pitros aw yang mga kaupudanan nan yamatoog. Awgaid pagmata nilan, kinita nilan si Isa sang kasiga nan kipat oman idtong dowangka otaw na yaga-indug sang masaid kanan. ");
INSERT INTO kqew_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ansinyan nang masaid da mabiya kang Isa yang dowangka otaw, yagalaong si Pitros kang Isa, “Kay Goro, madyaw na adi kami sini. Maga-inang da kami ng toombok na lagkaw, sambok kammo, sambok kang Nabi Mosa aw sambok oman kang Nabi Iliyas.” Maynan yang pyaglaongan nan kay wa yan akatigam daw ono yang dait nan ipaglaong. ");
INSERT INTO kqew_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nang yagalaong pa si Pitros, yama-aon yang gabon na yagalandong kanilan. Ansinyan yamalluk yang mga inindowan ni Isa kay kyatabonan da silan sinyan na gabon. ");
INSERT INTO kqew_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aw aon yadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang Anak ko na pinili ko. Paningug kamo kanan!” ");
INSERT INTO kqew_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkawaa da ng sowara, kinita nilan na si Isa dakoman yang yamabilin. Na, sidto na mga allaw wa silan pagagogod sang maskin sino daw ono yang kinita nilan. ");
INSERT INTO kqew_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagka-ilaw sinyan lyomodsad si Isa upud sang mga inindowan nan sikun sang butay. Na, madaig yang mga otaw na yasongon kanan. ");
INSERT INTO kqew_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aon sambok na otaw ansidto na yagapiyagit aw laong nan, “Kay Goro, kong mapakay kammo, tabangi yani na anak ko kay tongga da yan. ");
INSERT INTO kqew_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Abay yan lasakan ng saytan. Kong amaitabo yani, matokaw yan magpiyagit, magakorog-korog yang lawas nan aw magabowa pa yang baba nan. ");
INSERT INTO kqew_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yaga-angyo da ako sang mga inindowan mo na palogwaun nilan yang saytan, awgaid di nilan magaga.” ");
INSERT INTO kqew_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ansinyan yagalaong si Isa, “Astaga! Kamo na mga otaw adon na panahon, way pagpangintoo mayo aw sayup oman yang dumduman mayo. Kadogay da ako adi kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi yang anak mo.” ");
INSERT INTO kqew_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sinyang yagapadood kanan yang isu, lyasakan yan ng saytan aw katowad sang lopa na yagakorog. Ansinyan syagda ni Isa yang saytan, pakadyawa nan yang isu aw orian sang ama nan. ");
INSERT INTO kqew_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na, yangkatingaa da yang kariko ng mga otaw sang kabarakat ng Tohan. Sarta yangkatingaa pa yang mga otaw sang kariko ng ininang ni Isa, yagalaong yan sang mga inindowan nan, ");
INSERT INTO kqew_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ayaw mayo pagkaringawi yani na ipaglaong ko kamayo. Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot.” ");
INSERT INTO kqew_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Awgaid wa silan pakasabot sini na pyaglaongan ni Isa. Kay sidto na wakto yamatago pa yani kanilan untak di nilan masabot. Aw yamalluk silan mag-osip kanan. ");
INSERT INTO kqew_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ansinyan yanaglalis yang mga inindowan ni Isa daw sino kanilan yang labaw. ");
INSERT INTO kqew_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Awgaid kyatigaman ni Isa daw ono yang iyan sang dumduman nilan. Agaw kyamang nan yang tagbi na isu aw pa-induga nan sang kilid nan. ");
INSERT INTO kqew_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ansinyan yagalaong yan kanilan, “Sino-sino yang magatarima ng isu na main nini sabap sang pagpangagad nan kanak, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang yagasogo kanak. Kay sino idtong pinakababa kamayo, yan yang labaw kamayo.” ");
INSERT INTO kqew_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ansinyan yagalaong si Yahiya, “Kay Goro, aon kinita nami na otaw na yagapalogwa ng mga saytan na lyambit nan yang ngaan mo. Syagda nami yan kay di yan inagad natun.” ");
INSERT INTO kqew_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ayaw mayo yan pagsagdaa,” laong ni Isa kanan kipat yang kadaigan pa na mga inindowan, “kay yang maskin sino na dili mapaglaban kamayo, matabang kamayo.” ");
INSERT INTO kqew_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ansinyan nang masaid da yang wakto na apataasun da si Isa adto sa sorga, yagahokom yan na makadto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Agaw yagasogo yan ng pilangka otaw na ama-ona kanan adto sang sambok na baryo na sakop ng Samariya untak andamun nilan yang logar na adatungan nan. ");
INSERT INTO kqew_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Awgaid yang mga otaw sidto na banwa wa pagatarima kang Isa kay kyatigaman nilan na makadto yan sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkatigam sinyan ng mga inindowan nan na si Yahiya aw si Yakob, yagalaong silan kang Isa, “Kay Dato, karim mo na apa-owanan nami silan ng atoon untak matay silan?” ");
INSERT INTO kqew_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Awgaid lyomingi kanilan si Isa aw syagda nan silan. ");
INSERT INTO kqew_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aw pyomanaos da gaid silan sang tuna na baryo. ");
INSERT INTO kqew_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sarta yagapanaw silan, aon otaw na yagalaong kang Isa, “Amagad ako kammo maskin wain kaw kadto.” ");
INSERT INTO kqew_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yagalaong si Isa kanan, “Yang mga milo aon kanilan tagowanan aw yang mga langgam aon kanilan pogad, awgaid ako na Anak ng Manosiya, way kanak logar na akakowangan ko.” ");
INSERT INTO kqew_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ansinyan yagalaong si Isa sang sambok oman na otaw, “Bita da, agad kanak.” Awgaid laong ng otaw, “Kay Dato, mori pa ako kay ilubung pa ko yang kanak ama.” ");
INSERT INTO kqew_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tyomobag si Isa aw laong nan kanan, “Pabayai yang paglubung ng mga patay adto sang mga otaw na main oman ng patay kay wa silan apangintoo kanak. Awgaid ikaw, panaw da aw pagpayapat ng makapantag sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aon oman sangka otaw na yagalaong kanan, “Amagad ako kammo, kay Dato. Awgaid togoti ako na mori kay magasabi pa ako sang mga taganak aw mga kalomonan ko.” ");
INSERT INTO kqew_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Awgaid yagalaong kanan si Isa, “Sino-sino yang magadaro awgaid abay pa lomingi, dili ng madyaw yang gawbuk nan. Mag-onawa sinyan, sino-sino yang marim magpangagad kanak, awgaid yang kanan dumduman adto sang kadaigan pa na mga butang, di yan dait magpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos sinyan yagapili si Isa ng 72 na mga inindowan untak sogoon nan silan pagpayapat adto sang mga longsod aw baryo na akadtonan pa nan. Syogo nan silan ng tagdowa aw pya-ona nan silan kanan. ");
INSERT INTO kqew_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Laong nan kanilan, “Madaig yang mga otaw na marim gao makadungug sang Madyaw na Gogodanun. Mag-onawa silan ng omay na ya-ilag da. Madaig sagaw yang ganiunun, awgaid tagbi da yang manggagani. Agaw pagpangayo-ngayo kamo adto sang Tohan na tagtomon ng pawa na magapadaa yan ng kadaigan pa na manggagani. ");
INSERT INTO kqew_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, panaw da kamo. Awgaid pagbantay kamo kay syogo ta kamo na main kamo ng mga karniro adto sang mga otaw na main ng maisug na mga ido. ");
INSERT INTO kqew_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaw da kamo pagdaa ng pitaka atawa maskin ono na lasakanan ni sandalyas. Aw ayaw oman kamo pag-ondang sang daan sang pagbaaw-baaw sang mga otaw na makita mayo. ");
INSERT INTO kqew_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kong makadto kamo sang sambok na baay, maglaong kamo ona, ‘Salam kamayo ansini na baay.’ ");
INSERT INTO kqew_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na, kong aon otaw san na baay na dait atagan ng kalinaw, kanan da yang kalinaw na pyangayo mayo. Awgaid kong dili, mabarik yang kalinaw ansan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kong aon madawat kamayo sang baay nilan, adto da kamo mag-uya. Ayaw da kamo pagballin-ballin ng baay. Kana aw inuma mayo yang maskin ono na yaya nilan kamayo kay yang maggawbukay dait bayadan sang gawbuk nan. ");
INSERT INTO kqew_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Na, maskin wain na longsod yang akadtonan mayo, kong adawatun kamo ng mga otaw adto, kana mayo yang maskin ono na yaya nilan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakadyawa mayo yang mga masakitun san na longsod aw paglaonga mayo yang mga otaw, ‘Dyomatung da adi kamayo yang pagdato ng Tohan.’ ");
INSERT INTO kqew_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Awgaid kong makadto kamo sang sambok na longsod aw di kamo adawatun, kadto da kamo sang mga daan aw paglaonga mayo yang mga otaw, ");
INSERT INTO kqew_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Maskin yang abog sikun sang kamayo longsod na yadukut sang kanami siki atakdagun da nami silbi tanda kamayo na waa day labot nami kamayo! Awgaid timani mayo na dyomatung da gao adi kamayo yang pagdato ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na, laong ni Isa, “Ipaglaong ko kamayo na pagdatung ng allaw ng paghokom, labaw pa yang siksa sidtong mga otaw kaysang siksa sang mga taga Sodom. ");
INSERT INTO kqew_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Labi na maat yang adatungan mayo na taga Korasin! Labi na maat oman yang adatungan mayo na taga Bitsayda! Kay kong ya-inang pa sang Tiros aw Sidon yang mga katingaan na ininang ko ansan kamayo, dogay da silan yanagsoog ng sako aw yanag-ingkod sang abo silbi tanda ng pagtawbat nilan. ");
INSERT INTO kqew_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Agaw, sang allaw ng paghokom labaw pa yang siksa kamayo kaysang siksa sang mga taga Tiros aw Sidon. ");
INSERT INTO kqew_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aw kamo oman na taga Kapirnaom, yagadumdum ba kamo na apataasun kamo adto sa sorga? Dili! Kay i-oog kamo ng Tohan adto sa narka.” ");
INSERT INTO kqew_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sino-sino yang amaningug kamayo, amaningug oman kanak. Aw sino-sino yang magataripunda kamayo, magataripunda oman kanak. Aw sino-sino yang magataripunda kanak, magataripunda oman sang yagasogo kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ansinyan byomarik da idtong 72 na syogo ni Isa na yamangkasowat aw yagalaong silan kang Isa, “Kay Dato, maskin yang mga saytan yatoman kanami aw sogoon nami sang ngaan mo!” ");
INSERT INTO kqew_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tyomobag si Isa kanilan, “Kinita ko si Iblis na yamallog sikun sang langit na mag-onawa ng kilat. ");
INSERT INTO kqew_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Paningug kamo! Yatagan ta kamo ng kapatot kay untak maskin kaginaan mayo yang mga od atawa mga olaipan, di kamo ama-ono. Aw di oman kamo amatalo ng kariko ng kabarakat ni Iblis na kalaban natun. Way maskin ono na amakasapad kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Awgaid ayaw kamo pagkasowat kay yatoman yang mga saytan ng sogo mayo. Awgaid pagkasowat kamo kay yang ngaan mayo yakasorat da adto sa sorga.” ");
INSERT INTO kqew_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sidto na wakto yamasowat si Isa sabap sang Nyawa ng Tohan aw yagalaong yan, “O kay Ama, ikaw yang yagadato adto sa sorga aw adi sang donya. Yamanginsokor ako kammo kay yang pyagatago mo sang mga aon katigam aw mataas yang pagpangadi, pyatigam mo adto sang mga way katigam. Ininang mo yani, kay Ama, kay idto yang karim mo.” ");
INSERT INTO kqew_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ansinyan yagalaong si Isa sang mga otaw, “Yang kariko ng mga butang yatag kanak ng kanak Ama. Way sino-sino na yakilaa sang Anak yatabiya yang Ama, aw way sino-sino na yakilaa sang Ama yatabiya yang Anak kipat sidtong mga otaw na pinili ng Anak na apakilaa yan kanilan.” ");
INSERT INTO kqew_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ansinyan yaga-atobang si Isa sang mga inindowan nan aw yagalaong yan kanilan nang wa pakadungug kanan yang kadaigan na mga otaw, laong nan, “Kadyaw ng ginawa mayo kay yakakita da kamo sang kariko sini na ininang ko. ");
INSERT INTO kqew_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ipaglaong ko kamayo na madaig yang mga nabi aw mga soltan singaon na karim gao komita sang kinita mayo, awgaid wa nilan akitaa. Aw karim gao nilan dumungug sang dyungug mayo, awgaid wa nilan adunguga.” ");
INSERT INTO kqew_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ansinyan aon sambok na alim ng Hokoman na dyomood kang Isa untak magtigi kanan. Yagalaong yan, “Kay Goro, ono yang dait ko inangun untak ka-aonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqew_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tyomobag kanan si Isa, “Ono yang yakasorat sang Hokoman ng Tohan? Ono yang yamabatya mo ansan?” ");
INSERT INTO kqew_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tyomobag yang otaw, “Yakasorat sang Kitab, ‘Pakadakowaa yang Tohan na kammo Tagallang sang tibok mo na pangatayan, sang tibok mo na kallowa, sang tibok mo na kusug, aw sang tibok mo na dumduman, aw kaoyi oman yang kapag-onawa mo mag-onawa ng looy mo sang ginawa mo.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Bunna yang pyagalaong mo,” laong ni Isa. “Inanga yan aw ansinyan aka-aonan kaw ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Awgaid yang alim, di nan karim na akamomowaan yan. Agaw yosip oman nan si Isa, laong nan, “Sino kadi yang kapag-onawa ko?” ");
INSERT INTO kqew_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tyomobag si Isa, “Aon sambok na otaw na Yahodi na yagalodsad sikun sa Awrosalam paduug sa Ariha. Ansan sang daan yatangan yan ng mga tolisan. Na, lyobasan nilan yan, byonalan aw pyanawan na maynang patay da. ");
INSERT INTO kqew_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ansinyan aon imam ng mga Yahodi na yamagi sidto na daan. Awgaid pagkita nan sinyan na otaw, ilikay yan adto sa sangkilid na daan aw yamagi ansan. ");
INSERT INTO kqew_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ansinyan aon oman sambok na otaw na Yahodi na yamagi ansan. Yani na otaw topo ni Libi aw katabang ng mga imam adto sang Baay ng Tohan. Pagkita nan sidtong otaw, yamagi da oman yan adto sa sangkilid na daan. ");
INSERT INTO kqew_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Awgaid wa akadogay sinyan aon sambok na otaw na taga Samariya na yamagi sidto na daan. Pagkita nan sidtong otaw, yarikad yang pangatayan nan aw yamallat yan kanan. ");
INSERT INTO kqew_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kyadtonan nan idtong otaw aw yabowan nan ng lana aw bino yang mga pari nan aw bugkuta nan. Pagkatapos san pyasakay nan sang ayup nan aw daa nan sang sambok na baay na pagapatanaan. Ansan yatiman nan idtong otaw. ");
INSERT INTO kqew_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagka-ilaw kyomamang yan ng dowambok na sapi na pilak aw yatag nan sang tagtomon sidtong baay aw paglaonga nan, ‘Tabiya, atimana yani na otaw. Aw maskin pila pa yang amagasto mo kanan na sobra sang yatag ko kammo adon, i-atag ko kammo sang pagbarik da ko.’ ");
INSERT INTO kqew_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Na adon,” laong ni Isa, “sino sining toongka otaw yang yasiling ng kapag-onawa sidtong otaw na tyolis?” ");
INSERT INTO kqew_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tyomobag yang alim, “Ingaong yamallat kanan.” Ansinyan yagalaong si Isa, “Na, panaw da aw inanga yang mag-onawa ng ininang nan.” ");
INSERT INTO kqew_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ansinyan pyomanaos si Isa aw yang mga inindowan nan sampay na dyomatung silan sang sambok na baryo. Ansan na baryo aon sambok na bobay na pyagangaanan kang Marta aw dyawat nan silan sang baay nan. ");
INSERT INTO kqew_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aon sambok na lomon ni Marta na pyagangaanan kang Mariyam. Yani si Mariyam yaga-ingkod sang masaid sang siki ni Isa untak maningug sang pyaga-indo nan. ");
INSERT INTO kqew_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Awgaid si Marta, yamarido yang ginawa nan sabap sang kadaig ng gawbuk nan kay yaga-andam yan ng pagkan para kanilan. Agaw dyomood yan kang Isa aw laong nan, “Kay Dato, wa kaw akallat kanak na pyasagdan ako ng kanak mangod aw sangka otaw da ko na yagaliyuk? Tabiya, paglaonga kono yan na tabangan ako!” ");
INSERT INTO kqew_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Awgaid tyomobag si Isa kanan, “O kay Marta, yamarido kaw sang madaig na mga butang. ");
INSERT INTO kqew_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Awgaid sambok da yang kinaanglan aw yani yang pinili ni Mariyam. Yang ininang nan labi na madyaw aw di yan akamangun kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sangallaw sinyan yagadowaa si Isa sang sambok na logar. Pagkatapos nan magdowaa, dyomood kanan yang sangka otaw na inindowan nan aw laong nan, “Kay Dato, indowi kami pagdowaa mag-onawa ng ininang ni Yahiya sang mga inindowan nan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agaw yagalaong si Isa kanilan, “Kong magadowaa kamo, maynini yang ipaglaong mayo, “ ‘Ya Tohan na Ama nami, addatan gao yang ngaan mo kay ikaw sotti. Magadato da kaw gao sang kariko ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Atagi kami ng pagkan na kinaanglan nami ng matag allaw. ");
INSERT INTO kqew_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampona kami ng mga dosa nami kay amponon oman nami yang yakadosa kanami. Aw pakawata kami sang mga sasat.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ansinyan yagalaong oman si Isa, “Sawpama aon sangka otaw kamayo na makadto sang baay ng amigo nan ng tungang gabi da aw magalaong yan, ‘Kay lomon, atagi ako ng toombok na pan. ");
INSERT INTO kqew_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kay aon yamapit kanak na lomon sikun pa sang mawat, aw nunka na way pagkan nami sang baay.’ ");
INSERT INTO kqew_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Adon, sawpama matobag idtong amigo nan adto sa suud, ‘Ayaw da ako pagdistorbowa kay yamanirado da kami ng baay aw yakowang da kami ng mga anak ko. Di da ako makabangon sang pag-atag kammo.’ ");
INSERT INTO kqew_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, monono da yan adon? Awgaid ipaglaong ko kamayo na maskin di gao yan magabangon sang pag-atag kanan maskin sagaw mag-amigo silan, awgaid sabap ng wa akamomowa yang amigo nan na abay pa mangayo, magabangon da yan aw maga-atag kanan ng kinaanglan nan. ");
INSERT INTO kqew_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Agaw ipaglaong ko kamayo, pagpangayo kamo kay atagan kamo, panganap kamo kay makakita kamo, aw pagtawag kamo kay apasuudun kamo. ");
INSERT INTO kqew_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kay sino-sino yang amangayo atagan, aw sino-sino yang amanganap makakita sang pyagapanganap nan, aw sino-sino yang magatawag apasuudun. ");
INSERT INTO kqew_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kamo na mga taganak, kong amangayo ng isda yang kamayo anak, atagan ba mayo ng od? ");
INSERT INTO kqew_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kong amangayo yan ng itlog, atagan ba mayo ng olaipan? ");
INSERT INTO kqew_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na, kong kamo na maat na mga manosiya matigam mangatag ng madyaw na mga butang adto sang mga anak mayo, labi-labi da yang Tohan na Ama mayo adto sa sorga! Sa way dowa-dowa i-atag nan yang Nyawa ng Tohan sang maskin sino na amangayo kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sangallaw sinyan pyalogwa ni Isa yang saytan na pyagasabapan ng pagka-amang ng otaw na yasuudan nan. Na, paglogwa da ng saytan, yakapaglaong da yang inyan na otaw. Aw yangkatingaa yang mga otaw na yakakita sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Awgaid yang kadaigan yagalaong, “Si Bilsibol na pangoo ng mga saytan, yan yang yaga-atag kanan ng kabarakat pagpalogwa sang mga saytan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yang kadaigan oman, karim nilan magtigi kang Isa. Agaw yagapangayo silan kanan ng katingaan silbi tanda na syogo yan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Awgaid kyatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Kong manag-onay magtanam yang mga otaw sang sambok na pyagdatowan, sang di amadogay amasapad inyan na pyagdatowan. Aw kong magakabain-bain yang mga otaw sang sambok na pamilya, sang orian amabongkag inyan na pamilya. ");
INSERT INTO kqew_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mag-onawa sinyan, kong mapagtanam si Iblis sang mga sakop nan na saytan aw magakabain-bain silan, sang di amadogay akawaan yan ng kapatot ng pagsogo kanilan aw amasapad da yang pyagdatowan nan. Yagalaong kamo na yagapalogwa ako sang mga saytan kay si Bilsibol yang yaga-atag kanak ng kabarakat. ");
INSERT INTO kqew_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, kong bunna yang pyagalaong mayo, sino kadi yang yaga-atag ng kabarakat adto sang mga inindowan mayo sang pagpalogwa ng mga saytan? Na, silan da yang magalaong na yamasayup kamo. ");
INSERT INTO kqew_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Awgaid sang bunna-bunna yagapalogwa ako sang mga saytan sabap sang kabarakat ng Tohan. Aw yani yang tanda na dyomatung da adi kamayo yang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ansinyan yaga-atag oman si Isa kanilan ng opamaan, laong nan, “Kong yang makusug na otaw na aon armas yang yagabantay sang kanan baay, way amaitabo sang mga butang nan. ");
INSERT INTO kqew_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Awgaid kong aon domatung na mas makusug pa kanan, amatalo da yan. Ansinyan akamangun da yang kyasarigan nan na armas aw bain-bainun pa yang pyangamang sikun sang kanan baay.” ");
INSERT INTO kqew_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yagalaong oman si Isa, “Sino-sino yang di madapig kanak, mapaglaban kanak. Aw sino-sino yang di matabang kanak pagtipon, magapakanat-kanat.” ");
INSERT INTO kqew_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yagalaong oman si Isa, “Aw malogwa yang saytan sikun sang otaw na yasuudan nan, magapanaw-panaw da yan sang mga banwa na way tobig kay amanganap ng akapagpatanaan nan. Aw way kinita nan, magalaong yan sang ginawa nan, ‘Mabarik da gaid ako sang dadaan na pyaga-uyaan ko.’ ");
INSERT INTO kqew_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na, pagbarik nan makita nan na kyalinisan da idtong pyaga-uyaan. ");
INSERT INTO kqew_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ansinyan mapanaw da oman yan kay magadaa yan ng pito pa na saytan na labi pa na maat kay kanan aw masuud silan sidtong otaw aw apag-uyaan nilan. Na, sang orian mas maat pa yang kabutang sidtong otaw kaysang pirmiro.” ");
INSERT INTO kqew_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Paglaong sinyan ni Isa, aon sambok na bobay ansan sang kaotawan na yagapiyagit aw laong nan, “Kadyaw ng ginawa ng bobay na yamanganak aw yagapasoso kammo!” ");
INSERT INTO kqew_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Awgaid tyomobag si Isa, “Awgaid labaw pa yang kasowat nidtong yamaningug sang pyaglaongan ng Tohan aw apangagadan nan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Adon, sang wakto na yagakadaig da yang mga otaw, yagalaong si Isa, “Maat yang mga otaw adon na panahon. Karim gaid nilan makakita ng katingaan silbi tanda na syogo ako ng Tohan, awgaid way ipakita ko kanilan yatabiya idtong katingaan na ya-inang adto kang Nabi Yonos. ");
INSERT INTO kqew_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kay mag-onawa ni Nabi Yonos na ya-inang ng tanda sang mga taga Ninibe singaon, ma-inang oman ako na Anak ng Manosiya ng tanda sang mga otaw adon na panahon. ");
INSERT INTO kqew_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sang allaw ng paghokom magabangon yang soltana sang bangsa ng Siba upud sang mga otaw adon na panahon aw magalaong yan na dait kamo siksaun. Kay maskin mawat yang banwa nan kyomadto yan untak magpaningug sang pyaglaongan ni Soltan Solayman kay maum yang katigam nan. Na, pagalaongon ta kamo na idi adon yang labaw pa kang Soltan Solayman. ");
INSERT INTO kqew_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sang allaw ng paghokom magabangon oman yang mga taga Ninibe upud sang mga otaw adon na panahon aw magalaong silan na dait kamo siksaun kay wa kamo pagatawbat. Awgaid silan, yagatawbat silan ng mga dosa nilan pagdungug nilan sang pag-osiyat ni Nabi Yonos. Na, pagalaongon ta kamo na idi adon yang labaw pa kang Nabi Yonos.” ");
INSERT INTO kqew_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan untak tagoon nan atawa asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan kay untak makita yang siga sinyan pagsuud ng mga otaw sang baay. ");
INSERT INTO kqew_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Adon, yang kammo mata maynang ilawan ng lawas mo. Kong madyaw yang mata mo, matinaw yang pananaw mo. Na, yang mana nan na ma-allag yang dumduman mo kay di kaw amasina kong iridskian yang kapag-onawa mo. Awgaid kong dili ng madyaw yang mata mo, hanap yang pananaw mo. Na, yang mana nan na sabap sang pagkasingit mo iyan kaw sang kadugguman. ");
INSERT INTO kqew_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Agaw, pagbantay kay basin yagadumdum kaw na ma-allag yang dumduman mo, awgaid maduggum kadi! ");
INSERT INTO kqew_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Awgaid kong kya-allagan yang dumduman mo na waa day maduggum, ma-allag da yang kinabowi mo na maynang ya-allagan kaw ng masilaw na ilaw.” ");
INSERT INTO kqew_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapos ni Isa mag-indo, aon sambok na Parisi na yaga-imbitar kanan untak koman adto kanilan. Agaw yamagad si Isa adto sang kanan baay aw yamingkod sang pagpangan. ");
INSERT INTO kqew_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Adon, yatingaa idtong Parisi pagkita nan na yakan si Isa na wa yan pagapangonaw sobay sang batasan nilan na mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Awgaid yagalaong kanan si Isa, “Kamo na mga Parisi, pyagalinisan mayo yang logwa gaid ng kamayo tasa aw plato, awgaid yang pangatayan mayo yamapono ng kaatan aw pagkasingit. ");
INSERT INTO kqew_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga sangu kadi kamo! Wa ba mayo akatigami na yang Tohan na yaga-inang ng kinita mo adi sa logwa, yan oman yang yaga-inang ng wa mo akitaa adto sa suud? ");
INSERT INTO kqew_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Agaw, yang madyaw na inangun mayo na atagan mayo yang mga miskinan aw ansinyan amasotti da yang maskin ono na iyan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Labi na maat yang adatungan mayo na mga Parisi! Yagajakat kamo ng ikasampoo na bain maskin dakoman ng kamayo anag na mag-onawa ng paminta, bawang aw pandan. Awgaid wa mayo inanga yang matorid aw wa oman mayo apakadakowaa yang Tohan sang kamayo pangatayan. Na, yan gao yang dait mayo inangun, awgaid ayaw oman mayo pagpasagdi yang kadaigan pa na mga sogowan. ");
INSERT INTO kqew_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Labi na maat yang adatungan mayo na mga Parisi! Kay kong adto kamo sang pagsasambayangan, kallini mayo mag-ingkod sang ingkodanan ng dakowa na mga otaw. Aw adto sang palengke, kallini mayo na asalamun kamo ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Labi na maat yang adatungan mayo kay mag-onawa kamo sang kobor na way tosanan. Kong kaginaan inyan ng mga otaw, wa silan akatigam na yamabatar da silan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Adon, aon sambok na alim ng Hokoman na yagalaong kang Isa, “Kay Goro, kong maynan yang pyaglaongan mo, maskin oman kami ininsolto mo.” ");
INSERT INTO kqew_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tyomobag si Isa, “Na, kamo oman na mga alim ng Hokoman, labi na maat yang adatungan mayo! Kay pyapusan mayo yang mga otaw ng mabugat na mag-onawa ng mga sogowan na mairap tomanun, awgaid di kamo matabang kanilan ng maskin tagbis. ");
INSERT INTO kqew_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Labi na maat yang adatungan mayo! Kay yaga-inang kamo ng tadumanan sang kobor ng mga nabi na pyatay ng mga kaompowan mayo. ");
INSERT INTO kqew_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sabap sini na ininang mayo yagapakita kamo na yaka-oyon kamo sang ininang ng kaompowan mayo. Kay silan yang yagapatay ng mga nabi, aw kamo yang yagapakadyaw ng kobor nilan. ");
INSERT INTO kqew_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Idto sagaw, pyakita yang katigam ng Tohan nang yagalaong yan, ‘Apadaan ko silan ng mga nabi kipat yang mga magpapayapatay ng pyaglaongan ko. Awgaid yang kadaigan kanilan apatayun nilan aw yang kadaigan oman apasikotan nilan.’ ");
INSERT INTO kqew_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Agaw, kamo na mga otaw adon na panahon, asiksaun kamo ng Tohan sabap sang pagpatay sang kariko ng mga nabi sikun pa sang pagbaoy ng donya. ");
INSERT INTO kqew_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Asiksaun kamo sabap sang pagpatay kang Habil sampay da sang pagpatay kang Sakariyas na pyatay adto sa tunga ng pagsosonogan ng korban aw yang Baay ng Tohan. Na, ipaglaong ko kamayo na yang siksa sang kariko sinyan madatung kamayo na mga otaw adon na panahon. ");
INSERT INTO kqew_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Labi na maat yang adatungan mayo na mga alim ng Hokoman! Kay pyagalupunan mayo yang daan paduug sang Tohan untak yang mga otaw di matigam sang kabunnaan. Kamo mismo di magsonod sang daan ng kabunnaan aw yagababag pa kamo sang mga otaw na marim gao magpanaos sinyan.” ");
INSERT INTO kqew_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagpanaw ni Isa sikun sinyan na baay, yadaman kanan yang mga Parisi aw yang mga magiindoway ng Hokoman. Yabay pa silan mag-osip kanan ");
INSERT INTO kqew_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kay karim nilan dakupun si Isa sang kanan pyaglaongan untak aon ikasombong nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na, sinyan na wakto libo-libo yang mga otaw na yanagkatipon adto kang Isa aw yanagdinutdutay silan sabap sang kadaig nilan. Ansinyan yagalaong mona si Isa sang mga inindowan nan, “Pagbantay kamo sang labadora ng mga Parisi. Yang karim ko ipasabot na ayaw kamo pagsiling sang batasan nilan na yagapakita-kita gaid. ");
INSERT INTO kqew_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kay yang maskin ono na yatago adon, amaklaro sang orian, aw yang kariko ng wa akatigami adon, akatigaman da. ");
INSERT INTO kqew_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Agaw sagaw yang maskin ono na pyagalaong mayo na kamo gaid yang yakadungug, amadungug da ng kariko ng mga otaw. Aw yang pyagatomod-tomod mayo adto sang kowarto, ipayapat da adto sang kadaigan.” ");
INSERT INTO kqew_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yagalaong oman si Isa, “Ipaglaong ko kamayo, mga lomon ko, ayaw kamo pagkalluk sidtong makapatay sang lawas mayo awgaid pagkatapos san waa day lain pa na ma-inang nilan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Awgaid ipaglaong ko kamayo daw sino yang dait mayo kallukan. Yang Tohan da yang kallukan mayo kay pagkatapos nan bogtoon yang napas mayo aon kabarakat nan pagdami kamayo adto sang narka. Idto sagaw, yan yang dait mayo kallukan. ");
INSERT INTO kqew_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Na, dumduma mayo yang mga maya. Di ba limambok yang amabili mayo ng piso gaid? Awgaid abir pa maynan, way maskin sambok kanilan na pyasagdan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na, labi da kamo kay maskin yang logay mayo, kyatigaman ng Tohan daw pilambok da. Agaw, ayaw kamo pagkalluk kay labaw pa yang bili mayo kaysang kadaig ng mga langgam.” ");
INSERT INTO kqew_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yagalaong oman si Isa, “Aon oman ipaglaong ko kamayo. Sino-sino yang magalaong sa atobangan ng mga otaw na yagapangagad yan kanak na Anak ng Manosiya, akunun ko oman yan na sakop ko sa atobangan ng mga malaikat ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Awgaid sino-sino yang magalaong sa atobangan ng mga otaw na wa yan apangagad kanak na Anak ng Manosiya, di ko oman yan akunun na sakop ko sa atobangan ng mga malaikat ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Sino-sino yang magalaong ng maat makapantag kanak na Anak ng Manosiya, amponon yan ng Tohan. Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di yan amponon ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kong adaun kamo adto sang mga pagsasambayangan atawa adto sa atobangan ng mga dato aw pangoo ng banwa, ayaw kamo pagkarido daw ono yang ikatobag atawa ipaglaong mayo. ");
INSERT INTO kqew_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kay sinyan na wakto indowan kamo ng Nyawa ng Tohan daw ono yang ipaglaong mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ansinyan aon sambok na otaw sang kaotawan na yagalaong kang Isa, “Kay Goro, paglaonga kono yang kanak lomon na bainan nan ako sang kabilin ni ama kanami.” ");
INSERT INTO kqew_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tyomobag kanan si Isa, “Kay Itin, way yaga-atag kanak ng kapatot paghokom kamayo atawa pagbain ng kabilin kamayo.” ");
INSERT INTO kqew_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ansinyan yagalaong si Isa adto sang mga otaw, “Pagbantay kamo aw paglikay kamo sang maskin ono na pagkasingit. Kay yang kakawasaan na maskin ono yang kadakowa sinyan, di maka-atag kamayo ng bunna na kinabowi.” ");
INSERT INTO kqew_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ansinyan yagalaong si Isa kanilan ng pasombingay, laong nan, “Aon sapian na yang kanan lopa madyaw yang abot. ");
INSERT INTO kqew_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ansinyan yagalaong yan sang ginawa nan, ‘Ono yang inangun ko kay waa day akabutangan ko sining kadaig ng kanak abot? ");
INSERT INTO kqew_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na, yani kay yang inangun ko,’ laong nan, ‘agubaun da ko yani na mga kamarig ko aw magapatokod ako ng dakowa pa sinyan. Aw adto da ko ibutang yang kariko ng kanak abot kipat yang mga kabutangan ko. ");
INSERT INTO kqew_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ansinyan magalaong da ako sang ginawa ko na madyaw da yang kabutang ko maskin pilangka toig pa aw waa day akaridowan ko. Abay da gaid ako koman, minum aw maglingaw-lingaw.’ ");
INSERT INTO kqew_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Awgaid yagalaong yang Tohan kanan, ‘Sangu kaw! Kay adon na gabi abogtoon da yang napas mo. Na, sino da yang amakun ng kariko ng yamatipon mo?’ ” ");
INSERT INTO kqew_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sang orian laong ni Isa, “Mag-onawa sinyan yang akatamanan sidtong otaw na yagatipon ng kakawasaan para sang ginawa nan awgaid miskinan yan adto sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ansinyan yagalaong si Isa sang mga inindowan nan, “Agaw sagaw ipaglaong ko kamayo na ayaw kamo pagkarido sang kinabowi mayo daw ono yang akanun atawa ono yang apandagomon mayo. ");
INSERT INTO kqew_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kay yang kinabowi labaw pa sang pagkan aw yang lawas mayo labaw pa sang mga dagom. ");
INSERT INTO kqew_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tanawa mayo yang mga owak. Di silan mananum, di silan maggani aw way oman kamarig nilan. Awgaid pyakan silan ng Tohan. Na, di ba labaw pa yang bili mayo kaysang mga langgam? ");
INSERT INTO kqew_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sino kamayo yang makapataas ng kinabowi nan ng maskin tagbis da gaid sabap sang pagkarido? ");
INSERT INTO kqew_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na, kong di mayo ma-inang yaning tagbi gaid na butang, nanga yamarido kamo sang kadaigan pa na mga butang? ");
INSERT INTO kqew_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tanawa mayo yang mga bolak daw monono yang pagtorin nilan. Di silan maggawbuk aw di silan maglaa. Awgaid ipaglaong ko kamayo na maskin yang mga dagom ni Soltan Solayman na bali na kawasa wa paka-upung sang kadyaw sini na mga bolak. ");
INSERT INTO kqew_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na, kong maynan yang pagpandagom ng Tohan sang sagbut na bowi adon awgaid kisuum asonogon da, kamo pa na manosiya, di nan kamo atagan ng dagom? Katagbi ng pagpangintoo mayo! ");
INSERT INTO kqew_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Agaw sagaw, ayaw mayo abay pagdumduma daw ono yang akanun atawa inumun mayo aw ayaw kamo pagkarido. ");
INSERT INTO kqew_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kay yani maag yang kyaridowan ng mga otaw na wa apangintoo sang Tohan. Awgaid kamo, ayaw kamo pagkarido kay kyatigaman ng Ama mayo adto sa sorga na kinaanglan mayo yani na mga butang. ");
INSERT INTO kqew_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Awgaid onaa mayo yang pagpasakop sang pagdato ng Tohan aw ansinyan atagan kamo ng kariko ng kinaanglan mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yagalaong oman si Isa, “Ayaw kamo pagkalluk maskin tagbi da kamo na yagapangagad kanak. Kay kallini ng Tohan na Ama mayo na atagan kamo ng kapatot ng pagdato adto sang pyagdatowan nan. ");
INSERT INTO kqew_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ibarigya mayo yang mga kabutangan mayo aw ipagsidoka mayo yang alin sinyan adto sang mga miskinan. Pagtipon kamo ng kakawasaan adto sa sorga kay yani na kakawasaan di amasapad aw di oman akakamangan kay adto sa sorga way kawatan aw way oman anay na makakutkut sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kay daw wain yang kakawasaan mayo, adto oman yang pangatayan mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yagalaong oman si Isa kanilan, “Madyaw kong andam kamo sang kariko ng wakto sampay da sang pagbarik ko. Pagsiling kamo ng mga sogowanun na yagatagad sang pag-ori ng kanilan amo sikun sang kawin. Yakapandagom silan aw wa nilan apataya yang ilawan kay untak pagdatung ng kanilan amo aw magatawag adto sa logwa, aka-abrian dayon nilan yan. ");
INSERT INTO kqew_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kadyaw ng ginawa ng mga sogowanun kong adatungan silan ng kanilan amo na yagatagad sang pag-ori nan. Bunna yani na ipaglaong ko kamayo na yan na amo maga-ilis, pa-ingkodon nan silan sang lamisa aw yan da yang maga-aya kanilan ng pagkan. ");
INSERT INTO kqew_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kadyaw sagaw ng ginawa nilan kong adatungan nan silan na yakapangandam sang pag-ori nan maskin pa tungang gabi atawa kadlawon yang pagdatung nan. ");
INSERT INTO kqew_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Awgaid timani mayo yani, kong kyatigaman pa ng tagtomon ng baay daw ono na wakto yang pagdatung ng kawatan, magbantay gao yan untak yang kawatan di makasuud sang kanan baay. ");
INSERT INTO kqew_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mag-onawa oman sinyan kamo. Pag-andam kamo kay mabarik ako na Anak ng Manosiya sang wakto na wa kamo pagadumdum na mabarik ako.” ");
INSERT INTO kqew_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Adon yaga-osip si Pitros kang Isa, “Kay Dato, yani na pasombingay kanami gaid atawa sang kariko ng mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tyomobag si Isa pina-agi sang sambok oman na pasombingay, laong nan, “Yang sogowanun na kasarigan aw matigam maggawbuk, yan yang apiliun ng amo nan untak magdaa ng kadaigan pa na mga sogowanun. Aw yan da yang maga-atag kanilan ng pagkan sang insakto na wakto. ");
INSERT INTO kqew_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kadyaw ng ginawa ng sogowanun aw pag-ori ng kanan amo, adatungan yan na yaga-inang ng kanan gawbuk. ");
INSERT INTO kqew_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sa bunna-bunna na ipaglaong ko kamayo na isarig da kanan ng amo nan yang kariko ng mga kabutangan nan. ");
INSERT INTO kqew_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Awgaid kong maat yang idto na sogowanun, magalaong yan sang ginawa nan, ‘Ah, madogay pa mori yang amo ko!’ Tapos akolataun da nan yang mga kaupudanan nan na sogowanun, mga usug aw bobay, aw abay gaid yan koman, minum aw magkalasing. ");
INSERT INTO kqew_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na, ansinyan mori da yang amo nan sang wakto na wa nan akaniyat kay wa nan akatigami daw ono na allaw yang pagbarik nan. Ansinyan kastigoon da yan ng amo nan aw adto da yan ibutang sang adatungan ng mga otaw na wa apangintoo sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yang sogowanun na yamatigam sang karim ipa-inang kanan ng amo nan awgaid wa nan inanga, yan yang alabutun ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Awgaid yang sogowanun na wa akatigam daw ono yang karim ng kanan amo, tapos yakadosa yan, alabutun oman awgaid tagbis da. Kay sino-sino yang yatagan ng madaig, madaig oman yang atagadan sikun kanan. Aw kong madaig yang syarig kanan, labi na madaig yang atagadan sikun kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yagalaong oman si Isa, “Yakani ako sining donya sang pagdaa ng atoon aw karim ko na pyagadook da gao yan. ");
INSERT INTO kqew_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Awgaid madaig pa yang mga kasikotan na dait ko agian aw amarido ako sarta di pa yani amatoman. ");
INSERT INTO kqew_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yagadumdum ba kamo na yakani ako sang pagdaa ng kalinaw adi sining donya? Dili kalinaw yang dyaa ko kondi kasamok kay ako yang pyagasabapan ng pagkabain-bain ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kay sikun adon, yang limangka otaw sang sambok na pamilya magakabain-bain, yang too laban sang dowa aw yang dowa laban sang too. ");
INSERT INTO kqew_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yang ama aw yang anak nan na usug magakalaban, yang ina aw yang anak nan na bobay magakalaban, kipat yang ogangan na bobay aw yang mamanogang na bobay, magakalaban silan.” ");
INSERT INTO kqew_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ansinyan yagalaong si Isa sang mga otaw, “Kong makita mayo na aon gabon sang sallupan, magalaong kamo, ‘Omowan kagaya,’ aw amaitabo yani sagaw. ");
INSERT INTO kqew_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aw kong moyop yang habagat, magalaong kamo, ‘Mapaso da kagaya,’ aw amaitabo oman yani. ");
INSERT INTO kqew_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kamo na yagapakita-kita gaid! Akatigaman mayo yang timpo sabap sang kinita mayo sang lopa aw sang langit. Awgaid nanga di kamo matigam magmana ng kinita mayo na mga pangitabo adon na panahon? ");
INSERT INTO kqew_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nanga di kamo matigam paghokom daw ono yang madyaw na inangun mayo? ");
INSERT INTO kqew_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sawpama aon otaw na magadimanda kammo. Na, pagpaningkamot kamo mag-osay sang wa pa kamo adatung sang hokomanan. Kay kong dili, basin adaun kaw nan adto sang howes, aw ansinyan adaun kaw adto sang polis aw ilasak da kaw sang pirisowan. ");
INSERT INTO kqew_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ipaglaong ko kamayo na di da kaw amakalogwa sikun sinyan sampay na di mo akabayadan yang kariko ng molta mo.” ");
INSERT INTO kqew_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, sidto na wakto aon mga otaw na yagagogod kang Isa makapantag sang mga taga Jalil na pyatay ni Pilato sarta yagapakorban silan adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ansinyan tyomobag si Isa aw laong nan kanilan, “Na, yagadumdum ba kamo na yang idto na mga taga Jalil labaw pa yang dosa nilan kaysang kadaigan pa na mga taga Jalil sabap ng maynidto yang pagkamatay nilan? ");
INSERT INTO kqew_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dili! Awgaid ipaglaong ko kamayo, kong di kamo magtawbat aw di mayo biyaan yang maat na mga inang mayo, amangkamatay kamo mag-onawa nilan. ");
INSERT INTO kqew_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na, ingaong 18 ka otaw na yamatay adto sa Silowam kay kyatombaan silan ng tanto mataas na baay, yagadumdum ba kamo na labaw pa yang dosa nilan kaysang kadaigan pa na mga otaw na yaga-uya sa Awrosalam? ");
INSERT INTO kqew_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dili! Awgaid ipaglaong ko kamayo, kong di kamo magtawbat aw di mayo biyaan yang maat na mga inang mayo, amangkamatay kamo mag-onawa nilan.” ");
INSERT INTO kqew_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ansinyan yagalaong si Isa kanilan nini na pasombingay, laong nan, “Aon sangka otaw na aon kaoy na igira sang tanumanan nan ng grips. Ansinyan kyomadto yan kay atanawon nan daw aon bonga nini na kaoy, awgaid way kinita nan. ");
INSERT INTO kqew_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Agaw yagalaong yan sang yaga-atiman ng tanumanan, ‘Na, ikatoo na toig da yani ng pagtanaw ko daw aon bonga nini na kaoy, awgaid nunka na way kinita ko. Madyaw pa aw apilaun da mo kay yaka-atraso gaid sang lopa.’ ");
INSERT INTO kqew_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Awgaid tyomobag yang yaga-atiman, ‘Kay Sir, pasagdi pa adon na toig. Kay akotkotan ko yang makilibot aw abutangan ko ng abono. ");
INSERT INTO kqew_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na, kong magabonga da yan sonod na toig, madyaw. Awgaid kong dili, na, ipapila da mo.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sangallaw sinyan na Allaw ng Pagpatana yaga-indo si Isa adto sang pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aon bobay ansidto na yamasakit sa suud ng 18 pangka toig sabap sang saytan. Adon yamalokot da yang lawas nan aw wa da yan paka-indug ng matorid. ");
INSERT INTO kqew_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkita kanan ni Isa, tyawag nan untak domood kanan aw yagalaong yan kanan, “Kay Babo, madyaw da kaw sikun sang kammo sakit.” ");
INSERT INTO kqew_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ansinyan dyapunan ni Isa idtong bobay ng arima nan aw sinyan dayon yaka-indug yan ng matorid aw yagapoji yan sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Adon, yang pangoo ng pagsasambayangan yadaman kay si Isa yagapakadyaw sang Allaw ng Pagpatana. Agaw yagalaong yan adto sang mga otaw, “Aon unum na allaw sang sangka simana na makagawbuk kita. Agaw, sinyan na mga allaw makani kamo untak pakadyawon kamo, awgaid dili sang Allaw ng Pagpatana!” ");
INSERT INTO kqew_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ansinyan tyomobag kanan si Isa, “Kamo na yagapakita-kita gaid! Kong aon baka atawa asno mayo, di ba obadun mayo aw agoyodon mayo adto sang inumanan maskin Allaw ng Pagpatana? ");
INSERT INTO kqew_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na, idi adon yani na topo ni Nabi Ibrahim na pyasikotan ni Iblis sa suud ng 18 pangka toig na maynang gyapos yan. Dait gaid na aka-obadan yan adon maskin sang Allaw ng Pagpatana!” ");
INSERT INTO kqew_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Adon, yani na tobag ni Isa yapakamomowa sang mga yagakontra kanan. Awgaid yang kadaigan na mga otaw yamangkasowat sabap sang kariko ng mga katingaan na ininang ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ansinyan yagalaong si Isa kanilan, “Ono yang akapag-onawa ko sang pagdato ng Tohan? Ono yang ikatandi ko sinyan? ");
INSERT INTO kqew_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na, mag-onawa yan sang tagbi na liso ng mostasa na tyanum ng otaw sang kanan pawa. Ansinyan tyomorin yan aw ya-inang yan ng kaoy. Aw maskin yang mga langgam makapogad sang mga sanga ninyan.” ");
INSERT INTO kqew_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yagalaong oman si Isa, “Ono yang ikatandi ko sang pagdato ng Tohan? ");
INSERT INTO kqew_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mag-onawa yan sang labadora na pyagadari ng bobay sang sangka sako na arina aw ininang nan ng masa. Aw ansinyan tyomobo yang tibok masa.” ");
INSERT INTO kqew_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ansinyan, sarta yagapaduug si Isa sa Awrosalam, yaga-indo yan adto sang mga longsod aw baryo na ya-agian nan. ");
INSERT INTO kqew_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na, sangallaw aon yaga-osip kanan, “Kay Sir, tagbi da ba yang amalowas?” ");
INSERT INTO kqew_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tyomobag si Isa aw laong nan, “Pagpaningkamot kamo pagsuud sang mapiyut na powertaan kay ipaglaong ko kamayo na madaig yang masuud gao sang pyagdatowan ng Tohan, awgaid di silan makasuud. ");
INSERT INTO kqew_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kay mag-onawa yan sang tagtomon ng baay na yamindug kay amanirado da yan. Na, maga-indugun da gaid kamo adto sa logwa aw magatawag kamo, ‘Kay Dato, pasuuda kami!’ “Awgaid matobag yan kamayo, ‘Wa ako akatigam daw wain kamo pagasikun!’ ");
INSERT INTO kqew_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ansinyan matobag kamo, ‘Yagadungan saba kita koman aw yaga-indo kaw sang kanami longsod!’ ");
INSERT INTO kqew_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Awgaid magalaong da oman yan, ‘Ipaglaong ko kamayo na wa ako akatigam daw wain kamo pagasikun. Panaw kamo, obos kamo na yaga-inang ng maat!’ ");
INSERT INTO kqew_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na, kong makita mayo si Ibrahim, si Isahak aw si Yakob kipat yang kariko ng mga nabi adto sang pyagdatowan ng Tohan, magatiyao da kamo aw mangolitub yang onto mayo kay kamo, pyapanaw kamo aw wa kamo apasuuda. ");
INSERT INTO kqew_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Awgaid madaig yang mga otaw na dili ng Yahodi na madatung sikun sang opat ka pinidyowan ng donya aw makan silan sang kandori adto sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, timani mayo na aon yamaori adon na ama-ona, aw aon yama-ona adon na amaori.” ");
INSERT INTO kqew_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sidto na wakto aon mga Parisi na dyomood kang Isa aw yagalaong silan kanan, “Madyaw pa aw apanawan da mo yani na banwa kay karim ni Soltan Hirod na apatayun kaw.” ");
INSERT INTO kqew_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tyomobag si Isa kanilan, “Kadto kamo aw paglaonga mayo ingaong limbongon na otaw na padayonon pa ko yang gawbuk ko. Palogwaun ko yang mga saytan sikun sang mga otaw aw pakadyawon ko yang mga masakitun, awgaid di da ng madogay. Kay masaid da domatung yang wakto na amatapos da ko yang kanak gawbuk. ");
INSERT INTO kqew_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yamatigam ako na di ako ama-ono adi sini na banwa. Awgaid kinaanglan na adon, kisuum, aw sangka allaw padayonon pa ko yang panaw ko adto sa Awrosalam. Kay di mapakay na yang nabi apatayun sang kadaigan na banwa kondi adto da gaid sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O mga taga Awrosalam! Kallat mayo kay pyatay mayo yang mga nabi aw byato mayo yang mga otaw na syogo ng Tohan adto kamayo. Makapila da ako magpakita kamayo na karim ta kamo tiponon aw atimanun mag-onawa ng osoyan na ilooban nan yang mga osoy nan. Awgaid wa kamo akallini! ");
INSERT INTO kqew_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, apabayaan da kamo ng Tohan. Ipaglaong ko kamayo na di da mayo ako akitaun taman sang wakto na mabarik oman ako aw magalaong da kamo, ‘Atagan gao ng kadyawan yani na syogo ng Tohan.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sangallaw sinyan na Allaw ng Pagpatana kyomadto si Isa untak koman sang baay ng sambok na pangoo ng mga Parisi. Na, adto sang baay pyagasimaan yan ng mga otaw daw ono yang inangun nan. ");
INSERT INTO kqew_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ansinyan aon sambok na otaw na dyaa sa atobangan ni Isa na yamallobag yang kanan arima aw bitiis. ");
INSERT INTO kqew_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na, yosip ni Isa yang mga alim ng Hokoman aw yang mga Parisi, laong nan, “Sobay ba sang Hokoman yang pagpakadyaw sang mga masakitun sang Allaw ng Pagpatana atawa dili?” ");
INSERT INTO kqew_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Awgaid wa silan atobag kanan. Na, yang ininang ni Isa, tyakmagan nan idtong otaw, pakadyawa nan aw pa-oria. ");
INSERT INTO kqew_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ansinyan yagalaong si Isa kanilan, “Sawpama aon anak atawa baka mayo na yamallog sang balon sang Allaw ng Pagpatana, di ba batonon dayon mayo sikun sinyan maskin Allaw ng Pagpatana?” ");
INSERT INTO kqew_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Awgaid wa silan pakatobag sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ansinyan kinita ni Isa na yang mga bisita ng Parisi yamamili ng ingkodanan na para sang mga dungganun. Agaw yagalaong yan kanilan sini na pasombingay, ");
INSERT INTO kqew_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","laong nan, “Kong aon yaga-imbitar kammo sang kawin, ayaw pag-ingkod sang ingkodanan na para sang mga dungganun kay basin aon pay bisita na labaw pa kammo. ");
INSERT INTO kqew_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na, pagdatung sinyan na otaw, adodon kaw ng yaga-imbitar kamayo dowa aw pagalaongon da kaw, ‘Tabiya, atagan kanan yani na pyaga-ingkodan mo.’ Ansinyan akamomowaan da kaw aw adto da kaw mag-ingkod sang ingkodanan na dili ng madyaw. ");
INSERT INTO kqew_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Agaw kong imbitado kaw, pagpili ng ingkodanan na dili ng madyaw kay untak pagdood kammo ng yaga-imbitar pagalaongon kaw nan, ‘Unda, kay lomon, adto kaw pag-ingkod sang madyaw na ingkodanan.’ Ansinyan amabantog da kaw sa atobangan ng kariko ng mga bisita nan. ");
INSERT INTO kqew_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay sino-sino yang magapataas ng ginawa nan, apababaun, aw idtong magapababa ng ginawa nan, apataasun.” ");
INSERT INTO kqew_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ansinyan yagalaong si Isa sidtong yaga-imbitar kanan, “Kong magakandori atawa magapakaradyaan kaw, ayaw da pag-imbitar sang mga amigo mo, yang mga lomon atawa parinti mo atawa yang mga simbaay mo na sapian kay silan amakabaus kammo. ");
INSERT INTO kqew_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Awgaid kong magapakaradyaan kaw, pag-imbitar sang mga miskinan, yang mga pongkol, yang mga sadi, aw yang mga bota. ");
INSERT INTO kqew_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kay kong inangun mo yan, aon kadyawan mo kay silan di amakabaus kammo. Yang Tohan da yang magabaus kammo sang Allaw na Maori na amabowi oman yang mga otaw na matorid sang pagtanaw nan.” ");
INSERT INTO kqew_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pagdungug sinyan ng sangka otaw na yaga-upud kang Isa sang pagpangan, yagalaong yan kanan, “Kadyaw ng ginawa ng mga otaw na makakan sang kandori adto sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ansinyan pyagalaong yan ni Isa ng pasombingay, laong nan, “Aon sambok na otaw na yaga-andam ng dakowa na pakaradyaan aw madaig yang imbitado nan. ");
INSERT INTO kqew_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pagdatung ng wakto na magakandori da silan, syogo nan yang kanan sogowanun na akadtonan nan yang mga imbitado aw paglaongon silan na, ‘Kadto da kamo, kay yandam da yang kandori.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Awgaid yang matag-isa kanilan yagabaribad. Yang sambok yagalaong sidtong sogowanun, ‘Baya pa ako yakabili ng lopa. Dait na akadtonan aw atanawon ko ona. Ampon tabiya da gaid.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Yang sambok oman yagalaong, ‘Yakabili ako ng limangka paris na baka. Tistingan ko adon daw madyaw silan idaro. Ampon tabiya da gaid.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aw yang sambok oman yagalaong, ‘Baya pa ako akawina. Agaw di ako makakadto.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ansinyan yamori idtong sogowanun aw paglaonga yang kanan amo. Na, yadaman da yang amo aw yagalaong yan adto sang kanan sogowanun, ‘Pag-apas-apas kadto sang mga kamino aw mga daan ansining syodad aw daa adi yang mga miskinan, yang mga pongkol, yang mga bota kipat yang mga sadi.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Pagtoman sinyan ng sogowanun, yagalaong yan sang kanan amo, ‘Kay Sir, ininang da ko yang pyagasogo mo, awgaid aon pay kanatun logar.’ ");
INSERT INTO kqew_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ansinyan yagalaong yang amo sang kanan sogowanun, ‘Kadto sang mga daan adto sa logwa ng syodad aw adto oman sang mga baryo aw pakania yang kariko ng otaw untak mapono yang kanak baay. ");
INSERT INTO kqew_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kay ipaglaong ko kamayo na way maskin isa nidtong mga otaw na imbitado ng pirmiro na makakan sang kandori na pyaga-andam ko.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sangallaw sinyan labi na madaig yang mga otaw na yamagad kang Isa. Ansinyan yaga-atobang yan kanilan aw yagalaong yan, ");
INSERT INTO kqew_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sino-sino yang marim magpangagad kanak, dait na palabiun nan ako kaysang ama aw ina nan, sang asawa aw mga anak nan, sang mga kalomonan nan aw maskin oman sang ginawa nan. Kay kong dili, di mapakay na ma-inang yan ng inindowan ko. ");
INSERT INTO kqew_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aw sino-sino yang dili andam mag-agi ng kasikotan aw maskin yang pagkamatay sabap sang pagpangagad nan kanak, di yan mapakay ma-inang ng inindowan ko. ");
INSERT INTO kqew_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sawpama, aon sangka otaw kamayo na yagadumdum magpatokod ng dakowa na baay. Di ba maga-ingkod yan ona aw tanawon nan daw pila yang agastoon nan aw kong aon sapi nan sang pagtapos ninyan? ");
INSERT INTO kqew_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kay kong di nan ona dumdumun, na, basin pagkatapos nan magpa-indug sang mga arigi, akolangan da yan ng sapi aw di nan amatapos yang baay. Na, yang kariko ng makakita sinyan magasangu-sangu da kanan ");
INSERT INTO kqew_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aw magalaong silan, ‘Tanawa mayo yani na otaw, yagasogod yan magpatokod ng baay, awgaid di nan amatapos!’ ");
INSERT INTO kqew_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Atawa aon sambok na soltan na 10,000 yang kanan mga sondao na yagadumdum mapaglaban sang sambok na soltan na 20,000 yang mga sondao. Na, maga-ingkod yan ona aw dumdumun nan daw magaga nan mapaglaban sidto na soltan. ");
INSERT INTO kqew_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na, kong sang dumduman nan di nan magaga, magasogo da yan ng mga otaw sang pagsongon sidto na soltan aw amangayo ng kalinaw sarta mawat pa yan. ");
INSERT INTO kqew_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Idto sagaw kamo oman, dumduma mayo ona daw ono yang inangun mayo. Kay kong di mayo akabiyaan yang kariko ng mga butang mayo, di kamo ma-inang ng mga inindowan ko.” ");
INSERT INTO kqew_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ansinyan yagalaong oman si Isa, “Kyatigaman mayo na madyaw yang asin. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. ");
INSERT INTO kqew_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Di da yan amagamit maskin pa sang pagpataba sang lopa atawa pagdari sang pangabono. Agaw, idami da gaid yan. Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqew_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ansinyan madaig yang mga kobrador ng bowis kipat sidtong mga otaw na tyawag na baradosa na dyomood kang Isa untak maningug sang pag-indo nan. ");
INSERT INTO kqew_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na, pagkita sinyan ng mga Parisi kipat yang mga magiindoway ng Hokoman, yanagbagolbol silan aw laong nilan, “Tanawa yani na otaw! Yagatarima yan sang mga baradosa aw yaga-upud pa yan kanilan koman.” ");
INSERT INTO kqew_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Agaw yagalaong kanilan si Isa nini na pasombingay, laong nan, ");
INSERT INTO kqew_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sawpama aon isa kamayo na 100 ka bok yang karniro nan aw yawaa yang sambok. Ono kowaw yang inangun nan? Di ba abiyaan nan yang 99 adto sang pyanamsaman aw anapun nan idtong yawaa taman sang akitaun da nan? ");
INSERT INTO kqew_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na, kong kitaun da nan, apusanun nan na bali na kasowat nan. ");
INSERT INTO kqew_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aw pag-ori nan atawagun nan yang kanan mga lomon kipat yang mga simbaay aw magalaong yan, ‘Magapakaradyaan kita kay kinita da ko yang kanak karniro na yawaa!’ ");
INSERT INTO kqew_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na, ipaglaong ko kamayo na mag-onawa sinyan labaw pa yang kasowat adto sa sorga sabap sidtong sangka otaw na yakadosa aw yagatawbat sang dosa nan kaysang 99 na yagadumdum na matorid silan aw di silan kinaanglan magtawbat.” ");
INSERT INTO kqew_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Laong oman ni Isa, “Sawpama aon sambok na bobay na aon kanan sampoo na sapi na pilak aw yawaa yang sambok. Ono kowaw yang inangun nan? Di ba sugaan nan yang ilawan, walisan nan yang kanan baay aw anapun nan inyan taman sang akitaun da nan? ");
INSERT INTO kqew_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na, pagkita da nan, atawagun nan yang mga lomon nan kipat yang mga simbaay aw magalaong yan, ‘Magapakaradyaan kita kay kinita da ko yang sapi ko na yawaa!’ ");
INSERT INTO kqew_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na, ipaglaong ko kamayo na mag-onawa sinyan amangkasowat yang mga malaikat ng Tohan adto sa sorga kong yang sangka otaw na yakadosa magatawbat ng dosa nan.” ");
INSERT INTO kqew_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ansinyan yagalaong oman si Isa, “Aon sangka otaw na aon dowambok na anak na usug. ");
INSERT INTO kqew_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sangallaw sidto yagalaong yang mangod sang ama nan, ‘Ama, atagan da adon kanak yang kanak kabainan ng kanami irinsya.’ Na, byain da ng ama yang kabutangan nan adto sang dowambok nan na anak. ");
INSERT INTO kqew_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Mga pilang allaw sinyan byarigya ng mangod yang kariko ng kabainan nan aw kadto yan sang mawat na banwa na daa yang kanan sapi. Adto sidtong banwa syapad-sapadan nan yang kanan sapi sang mga inang na way siyat. ");
INSERT INTO kqew_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na, pagka-orot nan gastoon yang kanan sapi, aon dyomatung na dakowa na gutum sidto na banwa aw waa day amakan nan. ");
INSERT INTO kqew_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Agaw kyomadto yan sang sambok na otaw sidto na banwa untak maggawbuk para kanan. Aw syogo yan adto sang pawa untak magbantay sang mga binatang. ");
INSERT INTO kqew_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ansinyan yamagutum da yan tanto aw kanun gao nan yang maskin idtong pyagatobong nan sang mga binatang. Awgaid way maskin sino na yaga-atag kanan ng pagkan. ");
INSERT INTO kqew_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Na, sang kadogayan sinyan yakadumdum da yan sang kabutang nan aw laong nan sang ginawa nan, ‘Yang kariko ng mga otaw ni ama, madaig yang pagkan aw yamanobra pa. Awgaid ako, idi ako na amatay da ng gutum! ");
INSERT INTO kqew_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Madyaw pa aw mori da ako kang ama aw pagalaongon ko yan, “Ama, yakadosa ako sang Tohan kipat oman kammo. ");
INSERT INTO kqew_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Di da ako dait na pagatawagun pa mo ng anak mo. Bilangan da gaid ako ng sambok sang kammo mga otaw.” ’ ");
INSERT INTO kqew_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ansinyan yamindug yan aw yamori sang ama nan. “Na, mawat pa yan kanilan, kinita da yan ng ama. Ansinyan yarikad yang pangatayan ng ama, dyomaagan yan pagsongon sang anak, angkupa nan aw auki. ");
INSERT INTO kqew_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ansinyan yagalaong yang anak, ‘Ama, yakadosa ako sang Tohan kipat oman kammo. Di da ako dait na pagatawagun pa mo na anak mo.’ ");
INSERT INTO kqew_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Awgaid tyawag dayon ng ama yang kanan mga allang aw laong nan kanilan, ‘Kallug kamo! Kamanga yang tanto madyaw na dagom aw pasootan kanan. Pasooti ng sandalyas aw pasoogi ng singsing. ");
INSERT INTO kqew_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sobaria mayo yang pyataba na nati ng baka kay magapakaradyaan da kita. ");
INSERT INTO kqew_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay yani na kanak anak mag-onawa ng patay na yabowi oman. Mag-onawa yan ng yamatanak, awgaid adon kinita da!’ Ansinyan yagasogod da silan magpakaradyaan. ");
INSERT INTO kqew_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, sidto na wakto waa ansan yang magowang na anak kay adto yan sang pawa. Adon, pag-ori nan aw masaid da yan sang baay, yadungug nan yang pagtogtog ng kolintang aw yang pagsayaw. ");
INSERT INTO kqew_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Agaw tyawag nan yang sambok na allang aw osipa nan, ‘Nanga yagapakaradyaan kamo?’ ");
INSERT INTO kqew_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Tyomobag yang allang, ‘Yamori da yang kammo mangod aw pyasobari ni ama mo yang pyataba na baka kay yang mangod mo yaka-ori kono na way maat na yamaitabo kanan.’ ");
INSERT INTO kqew_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na, yadaman yang magowang aw di yan mallini somuud sang baay. Agaw kyadtonan yan ng ama nan aw yangyo nan na mapanik. ");
INSERT INTO kqew_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Awgaid yagalaong yang magowang na anak sang ama nan, ‘Ama, tanawa kono! Dogay da ako pagagawbuk para kammo, nunka na way sogo mo na syopak ko. Ono yang yatag mo kanak? Maskin sambok na kambing untak makapakaradyaan ako upud sang mga kaupudanan ko, way yatag mo kanak! ");
INSERT INTO kqew_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Awgaid adon, pagdatung sini na kammo anak na yagasapad-sapad ng kammo kabutangan upud sang dopang na mga bobay, pyasobari pa mo yang pyataba na baka!’ ");
INSERT INTO kqew_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Awgaid tyomobag yang ama, ‘Anak, idi kaw pirmaminte upud kanak aw yang kariko na idi kanak, kammo oman. ");
INSERT INTO kqew_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Awgaid adon dait gaid na magakasowat aw magapakaradyaan kita kay yang mangod mo na mag-onawa ng patay, yabowi oman. Mag-onawa yan ng yamatanak, awgaid adon kinita da!’ ” ");
INSERT INTO kqew_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ansinyan yagalaong si Isa adto sang mga inindowan nan, “Aon sapian na aon sambok na sogowanun na syarigan nan sang kariko ng kanan kabutangan. Sangallaw sinyan aon yagasombong sang sapian na yang kanan kabutangan syapad-sapadan gaid nidtong sogowanun na kanan sinarigan. ");
INSERT INTO kqew_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Agaw pyatawag nan idtong sogowanun aw paglaonga nan, ‘Ono yani na yadungug ko makapantag kammo? Atagi ako adon ng listaan ng kariko ng kabutangan ko aw paglaonga ako daw monono yang pag-atiman mo sinyan. Kay sikun adon di da ta kaw akasarigan ng kabutangan ko.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ansinyan yagalaong yang sogowanun sang ginawa nan, ‘Apapanawon da kadi ako ng kanak amo. Ono da yang inangun ko? Di ako makagaga maggawbuk ng mabugat na mag-onawa ng pagkotkot aw yamomowa ako magpakilimos. ");
INSERT INTO kqew_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, yamatigam da ako daw ono yang inangun ko untak kisuum kong waa day gawbuk ko, aon mga otaw na madawat kanak sang kanilan baay.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ansinyan pyatawag nan yang kariko ng mga otaw na yaka-otang sang kanan amo. Yosip nan yang yaka-ona, laong nan, ‘Pila yang otang mo sang kanak amo?’ ");
INSERT INTO kqew_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Tyomobag yang yaka-otang, ‘100 ka lata ng lana ng jayton.’ “Laong ng sogowanun, ‘Idi kay yang listaan ng kammo otang. Pag-ingkod aw pagsorat ng 50.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ansinyan yosip oman nan yang sambok, ‘Ikaw, pila pa yang otang mo?’ “Tyomobag yan, ‘100 ka sako ng bugas.’ “Laong ng sogowanun, ‘Idi kay yang listaan mo. Pagsorat ng 80.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na, pagdungug ng amo sang ininang nidtong sogowanun na yagalimbong kanan, byantog nan yan sabap ng yamatigam yan mag-inang ng makapagkadyaw kanan. Bunna sagaw na yang mga otaw na kadodonyai yang dumduman, matigam silan magdaa ng mga otaw na main nilan labaw pa sang mga otaw na yagapangagad sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Agaw ipaglaong ko kamayo na agamitun mayo yang kakawasaan mayo adi sining donya untak tabangan mayo yang kapag-onawa mayo kay untak pagdatung ng wakto na di da kinaanglan ng sapi, adawatun da kamo adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kay sino-sino yang akasarigan ng tagbi, akasarigan oman ng dakowa. Aw sino-sino yang di akasarigan ng tagbi, di oman akasarigan ng dakowa. ");
INSERT INTO kqew_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, kong di kamo akasarigan ng kakawasaan adi sining donya, monono da yang pagsarig kamayo ng bunna na kakawasaan? ");
INSERT INTO kqew_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aw kong di kamo akasarigan ng kabutangan ng kadaigan, sino yang maga-atag kamayo ng kakawasaan na yandam da para kamayo? ");
INSERT INTO kqew_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Way allang na dowambok yang amo. Kay yang sambok adumutan nan, aw yang sambok addatan nan. Yang sambok apangagadan nan, aw yang sambok asopakun nan. Mag-onawa sinyan, kong dakowa yang sapi sang kamayo pangatayan, na, di kamo makapangagad sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pagdungug sinyan ng mga Parisi, pyagasangu-sangu nilan si Isa kay silan tokgawon sang sapi. ");
INSERT INTO kqew_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ansinyan yagalaong kanilan si Isa, “Kamo, yagapakita-kita gaid kamo sang mga otaw na kamo madyaw, awgaid kyatigaman ng Tohan yang kamayo pangatayan. Kay yang labi na dakowa sang pagtanaw ng otaw, way bili sang pagtanaw ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Yang Hokoman ni Nabi Mosa aw yang syorat ng mga nabi pyaga-indo sampay sang pagdatung ni Yahiya na Magsosogboway. Awgaid sikun sidto na wakto pyaga-osiyat da yang Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw madaig yang mga otaw na yamaningkamot magpasakop sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Awgaid wa yani pagapasabot na waa day kapantag ng Hokoman. Kay amawaa pa yang langit aw yang lopa bago pa amawaa yang maskin sambok na pyaglaongan ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Agaw di oman amaparin yang sogowan na yagalaong, ‘Sino-sino na usug na magabuag ng kanan asawa aw amangasawa sang tuna na bobay, magajina. Aw yang usug na amangasawa sang bobay na byuagan, magajina oman.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ansinyan yagalaong oman si Isa, “Aon sapian na aag madyaw yang mga dagom nan aw matag allaw madaig aw masarap yang kanan pagkan. Madyaw sagaw yang kabutang nan. ");
INSERT INTO kqew_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aon oman miskinan na yang ngaan nan si Lasaro. Yang kanan lawas pono ng mga katuu. Matag allaw dyaa yan adto sang powertaan ng baay nidtong sapian na otaw ");
INSERT INTO kqew_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","kay kallini gao nan koman sang yamasama na pagkan sikun sang lamisa nan. Kallat sagaw ng kabutang nan kay maskin yang mga ido dyomood kanan aw inilasan nilan yang mga katuu nan. ");
INSERT INTO kqew_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na, ansinyan yamatay idtong miskinan aw dyaa yan ng mga malaikat adto sang kilid ni Nabi Ibrahim adto sa sorga. Ansinyan yamatay oman idtong sapian aw lyubung da yan. ");
INSERT INTO kqew_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Adto da yan adatung sang narka aw bali na kasikot nan. Pag-angad nan, kinita nan adto sa mawat si Nabi Ibrahim aw si Lasaro sang kilid nan. ");
INSERT INTO kqew_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ansinyan yagapiyagit aw laong nan, ‘O kay Ompo Ibrahim, kallati ako! Tabiya, sogowa si Lasaro na tollokan nan sang tobig yang tollo nan aw patutudan nan yang kanak dila untak kanikian ako kay bali na kasikot ko sang kapaso sini na atoon!’ ");
INSERT INTO kqew_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Awgaid tyomobag kanan si Nabi Ibrahim, ‘Dumduma, kay Itin, nang bowi pa kaw adto sang donya aag madyaw yang dyawat mo. Awgaid si Lasaro, aag maat yang dyawat nan. Awgaid adon, madyaw da yang kabutang nan adi, aw ikaw da yang kyasikotan. ");
INSERT INTO kqew_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dogang pa san, aon maum na aog na iyan sa tunga natun. Maskin sino adi kanami na marim tomaripag adto kamayo, di makakadto. Aw way oman sikun adto kamayo na makataripag adi kanami.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ansinyan yagalaong yang sapian, ‘Kong maynan, kay Ompo, pangayoon ko kammo na ipadaa mo si Lasaro adto sang baay ng kanak ama. ");
INSERT INTO kqew_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kay aon mga lomon ko na limangka otaw na poros usug. Pakadtona yan sang pagpatigam kanilan untak di silan makakani sang banwa ng kasikotan.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Awgaid yagalaong si Nabi Ibrahim, ‘Yang mga lomon mo, iyan kanilan yang mga Kitab na syorat ni Nabi Mosa aw yang kadaigan pa na mga nabi. Dait na maningug silan sang pyaglaongan nilan.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yagalaong oman yang sapian na otaw, ‘Di silan mangintoo kanilan, kay Ompo! Awgaid kong aon patay na amabowi oman aw makadto kanilan, na, magatawbat da silan ng mga dosa nilan.’ ");
INSERT INTO kqew_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Awgaid yagalaong si Nabi Ibrahim kanan, ‘Kong di silan amaningug kang Nabi Mosa aw sang kadaigan pa na mga nabi, di oman silan amangintoo maskin aon patay na amabowi oman aw makadto kanilan.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ansinyan yagalaong si Isa sang mga inindowan nan, “Bunna sagaw na aon mga sasat na madatung sang manosiya untak makadosa silan. Awgaid kallat nidtong otaw na yagadaa ng kadaigan sang kadosaan. ");
INSERT INTO kqew_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw idami yan adto sa laod kaysang ma-inang yan ng pyagasabapan na amakadosa yang maskin sambok sini na mga otaw na mag-onawa ng tagbi na mga isu. ");
INSERT INTO kqew_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Agaw timani mayo yang mga inang mayo. “Kong makadosa kammo yang lomon mo, towadai yan. Aw kong magabasul yan ng dosa nan, ampona yan. ");
INSERT INTO kqew_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maskin makapito pa yan makadosa kammo sa suud ng sangallaw aw makapito oman mangayo ng ampon, dait na amponon mo yan.” ");
INSERT INTO kqew_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ansinyan yanaglaong yang mga sahabat kang Isa, “Kay Dato, pabagsuga yang kanami pagpangintoo!” ");
INSERT INTO kqew_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Awgaid yagalaong si Isa, “Kong aon pagpangintoo mayo na maskin tagbis na maynang katagbi da gaid ng liso ng mostasa, makapaglaong kamo sini na kaoy, ‘Ballin adto sa dagat,’ aw matoman yan kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sawpama aon sogowanun mo na yagadaro atawa yagabantay ng karniro. Na, pag-ori nan sikun sang kanan gawbuk, pagalaongon mo ba yan na, ‘Pag-apas-apas, kay Itin, kan da?’ ");
INSERT INTO kqew_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dili! Kondi magalaong kaw, ‘Pag-ilis aw andami ako ng pagkan. Tapos pag-aya kanak taman sang matapos ako koman. Pagkatapos, makakan da kaw.’ ");
INSERT INTO kqew_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na, amanginsokor ba kaw sang kammo sogowanun kay ininang nan yang pyagasogo mo kanan? Dili! ");
INSERT INTO kqew_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na, mag-onawa sinyan kamo. Kong ya-inang da mayo yang kariko ng pyagasogo kamayo, magalaong da kamo, ‘Mga sogowanun gaid kami. Di kami dait bantogon kay ininang da gaid nami yang kawajib kanami inangun.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sang yagapaduug si Isa sa Awrosalam yamagi yan sang tunga ng Samariya aw Jalil. ");
INSERT INTO kqew_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagdatung nan sang sambok na baryo, syongon yan ng sampoo na kausugan na sanglaun. Yanag-indug silan sang mawat-awat ");
INSERT INTO kqew_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aw yagapiyagit aw laong nilan, “O kay Isa, kay Dato! Kallati kami!” ");
INSERT INTO kqew_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkita kanilan ni Isa, yagalaong yan kanilan, “Kadto da kamo sang mga imam untak tanawon nilan yang lawas mayo.” Na, sang pagsingadto pa gaid nilan yamadyaw da silan. ");
INSERT INTO kqew_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Adon, pagkita ng sangka otaw kanilan na yamadyaw da yan, byomarik yan na yagapoji sang Tohan ng matanog. ");
INSERT INTO kqew_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ansinyan syomojod yan sa atobangan ni Isa aw yamanginsokor kanan. Na, yang idto na otaw taga Samariya aw dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ansinyan yagalaong si Isa, “Di ba sampoo na ka otaw yang yamadyaw? Na, wain da yang siyam? ");
INSERT INTO kqew_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nanga yani na otaw da gaid na dili ng Yahodi yang yabarik sang pagpanginsokor sang Tohan?” ");
INSERT INTO kqew_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ansinyan yagalaong si Isa sidtong otaw, “Pag-indug, kay Itin, aw panaw da. Yamadyaw da kaw sabap sang pagpangintoo mo.” ");
INSERT INTO kqew_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Adon, aon mga Parisi na yaga-osip kang Isa daw kano pa magdato yang Tohan. Tyomobag si Isa, laong nan, “Yang pagdato ng Tohan di mayo amakita ng mata. ");
INSERT INTO kqew_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Way sino-sino na makapaglaong, ‘Tanawa, idi kay!’ atawa ‘Idto sidto!’ Kay yang Tohan magadato sang pangatayan mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ansinyan yagalaong yan sang mga inindowan nan, “Madatung yang wakto na karim mayo komita kanak na Anak ng Manosiya na maskin sangallaw da gaid, awgaid di mayo ako makita. ");
INSERT INTO kqew_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aon magalaong kamayo na, ‘Tanawa, idto yan sidto!’ atawa ‘Tanawa, adi yan sidi!’ Awgaid ayaw kamo paningug kanilan atawa pagpanganap kanak. ");
INSERT INTO kqew_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay mag-onawa ng kilat na yagasiga adto sang langit aw yagapa-allag sikun sa silatan taman sa sallupan, maynan yang pagdatung ko na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Awgaid dait na amagi ako ona ng mga kasikotan aw ataripundaan ako ng mga otaw adon na panahon. ");
INSERT INTO kqew_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Na, yang ininang ng mga otaw sidtong wakto na mabarik ako na Anak ng Manosiya adi sang donya mag-onawa ng ininang ng mga otaw sang panahon ni Nabi Noh. ");
INSERT INTO kqew_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Way lain na kyaridowan nilan yatabiya yang pagkan, pag-inum aw pag-inasawaay taman sidtong wakto na syomuud da si Nabi Noh sang dakowa na bangka. Na, pagdatung ng lunup, obos silan yamangkamatay. ");
INSERT INTO kqew_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Na, yang kabutang ng mga otaw sidtong wakto na mabarik ako mag-onawa oman sang kabutang ng mga otaw sang panahon ni Lot. Yanagpangan aw yanag-inum silan, yanagbarigya aw yanagbili, yanagtanum aw yanagpa-indug silan ng mga baay. ");
INSERT INTO kqew_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na, sidtong allaw pagpanaw ni Lot sikun sang syodad ng Sodom, yamowan ng atoon aw asopri sikun sang langit aw yang kariko ng mga otaw yamangkamatay. ");
INSERT INTO kqew_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Na, mag-onawa oman sinyan yang kabutang ng mga otaw sang wakto na mabarik ako na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sidto na wakto, yang otaw na adto sa logwa ng kanan baay, di da dait somuud untak makamang pa sang maskin ono na butang nan. Aw yang otaw na adto sang kanan pawa, di da dait mori pa sang baay nan. ");
INSERT INTO kqew_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dumduma mayo yang yamaitabo sang asawa ni Lot! ");
INSERT INTO kqew_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kay sino-sino na yang pyalabi nan yang kanan kinabowi, akawaan ninyan. Awgaid sino-sino na yang pyalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, aka-aonan ng bunna na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ipaglaong ko kamayo na sang allaw ng pagbarik ko, kong aon dowangka usug sang kowangan ng gabi, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqew_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kong aon dowangka bobay na yagalubuk ng omay, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqew_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aw kong aon dowangka otaw na yagagawbuk adto sang pawa, akamangun yang isa aw amabilin yang isa.” ");
INSERT INTO kqew_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ansinyan yaga-osip kanan yang mga inindowan nan, “Kay Dato, wain yan amaitabo?” Tyomobag si Isa pina-agi sang pasombingay na yagalaong, “Daw wain yang patay, adto magatipon yang mga banog.” ");
INSERT INTO kqew_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ansinyan yagalaong si Isa ng pasombingay adto sang mga inindowan nan untak abay silan magdowaa aw di silan mag-ondang. ");
INSERT INTO kqew_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Laong ni Isa, “Sang sambok na longsod aon howes na wa akalluk sang Tohan aw way pyaga-addatan nan na otaw. ");
INSERT INTO kqew_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Adon, aon oman sambok na biyoda disidtong longsod na yabay komadto sidtong howes na yaga-angyo kanan na tabangan nan sang kanan kaso. Laong nan, ‘Tabangi ako untak di ako daog-daogon ng kalaban ko.’ ");
INSERT INTO kqew_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Na, yadogay na wa apaningug kanan yang howes. Awgaid sang kadogayan yagalaong yan sang ginawa nan, ‘Maskin wa ako akalluk sang Tohan aw way pyaga-addatan ko na otaw, ");
INSERT INTO kqew_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","awgaid sabap ng yabay ako samokon nining bobay, atabangan da ko gaid yan sang kanan kaso. Kay kong di ko yan tabangan, mabarik da oman yan adi kanak taman sang amasoya da ako.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ansinyan yagalaong si Isa, “Na, timani mayo yang pyaglaongan nidtong maat na howes. ");
INSERT INTO kqew_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kong yang maat na otaw matigam tomabang sang otaw na wa nan addati, na, yang Tohan pa, di ba nan atabangan yang mga otaw na pinili nan na yaga-angyo kanan ng tabang gabi aw allaw? Apakadogayun ba nan yang pagtabang nan kanilan? ");
INSERT INTO kqew_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ipaglaong ko kamayo na atabangan nan silan ng mallug. Awgaid kong mabarik ako na Anak ng Manosiya adi sang donya, aon bay akitaun ko na mga otaw na mabagsug yang pagpangintoo nilan?” ");
INSERT INTO kqew_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Adon, adto sang mga otaw na yagadumdum na matorid silan aw dyaog-daog nilan yang kadaigan yagalaong si Isa sini na pasombingay, ");
INSERT INTO kqew_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","laong nan, “Aon dowangka otaw na kyomadto sang Baay ng Tohan untak magdowaa. Yang sangka otaw Parisi aw yang sangka otaw kobrador ng bowis. ");
INSERT INTO kqew_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Adto sang Baay ng Tohan yamindug yang Parisi aw yagadowaa yan adto sang Tohan na yagabantog sang ginawa nan, laong nan, ‘Ya Tohan, yamanginsokor ako kammo kay ako dili ng tokgawon ni limbongon, aw wa ako pagajina na mag-onawa ng kadaigan. Yamanginsokor oman ako kammo na dili ako maynidtong kobrador ng bowis. ");
INSERT INTO kqew_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yagapowasa ako ng makadowa sang sangka simana aw yagajakat ako sikun sang kariko ng kanak sapi.’ ");
INSERT INTO kqew_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Awgaid yang kobrador ng bowis yaga-indug adto sa mawat-awat aw wa yan paka-angad sang pagdowaa nan. Byogbog nan yang kanan aba aw yagalaong yan, ‘Ya Tohan, kallati ako na baradosa.’ ");
INSERT INTO kqew_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na, ipaglaong ko kamayo,” laong ni Isa, “na yani na otaw yang yamori na yampon da aw dyawat yan ng Tohan na matorid aw dili nidtong Parisi. Kay sino-sino yang magapataas sang ginawa nan, apababaun aw yang magapababa sang ginawa nan, apataasun.” ");
INSERT INTO kqew_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Adon, aon mga otaw na yagadaa ng mangkatagbi na mga isu nilan adto kang Isa untak dapunan nan silan ng arima nan. Pagkita sinyan ng mga inindowan ni Isa, syagda nilan yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Awgaid tyawag ni Isa yang mga isu na domood kanan aw yagalaong yan sang mga inindowan nan, “Pasagdi mayo yang mga isu na domood kanak. Ayaw mayo silan pagbabagi kay yang mga otaw na main nilan yang amakasuud sang pyagdatowan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bunna yang ipaglaong ko kamayo. Sino-sino yang di magapasakop sang pagdato ng Tohan na mag-onawa ng isu, di yan amakasuud sang pyagdatowan nan.” ");
INSERT INTO kqew_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ansinyan aon pangoo ng mga Yahodi na yaga-osip kang Isa, “Kay Goro, yamatigam ako na ikaw madyaw. Ono yang dait ko inangun untak ka-aonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqew_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tyomobag si Isa kanan, “Nanga yagalaong kaw na ako madyaw? Way sino na madyaw yatabiya yang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kyatigaman mo kowaw yang mga sogowan na yagalaong, ‘Ayaw pagjina, ayaw pagpatay, ayaw pagpangawat, ayaw pagsaksi ng bakak, aw addati yang kammo ama aw ina.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tyomobag yang otaw, “Yang kariko ninyan tyoman ko sikun pa sang pagka-isu ko.” ");
INSERT INTO kqew_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagdungug sinyan ni Isa, yagalaong yan kanan, “Isa pa yang dait mo inangun. Barigyaan yang kariko ng kammo kabutangan aw yang alin atagan sang mga miskinan. Ansinyan aka-aonan kaw ng kakawasaan adto sa sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Awgaid pagdungug sinyan nidtong otaw, bali na karido nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqew_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na, pagkita ni Isa na yamarido yan, yagalaong yan, “Mairap sagaw sang sapian na mga otaw pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Masayun pa sang kamil pag-agi sang botas ng dagum kaysang otaw na sapian pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Adon, yang mga yakadungug sinyan yagalaong, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqew_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Awgaid yagalaong si Isa, “Yang di ma-inang ng manosiya, ma-inang ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ansinyan yagalaong si Pitros, “Na, monono da kami adon? Ibiyaan da nami yang kanami mga pamilya aw yamagad kami kammo.” ");
INSERT INTO kqew_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Laong ni Isa kanilan, “Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang yagabiya ng kanan baay, yang asawa nan, mga lomon, taganak, atawa mga anak nan sabap sang pagpasakop sang pagdato ng Tohan, ");
INSERT INTO kqew_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","labaw pa sinyan yang amadawat nan adi sining donya, aw sang Allaw na Maori atagan yan ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ansinyan pyagalain ni Isa yang sampoo aw dowa na mga sahabat nan aw paglaonga nan silan, “Paningug kamo. Makadto da kita sa Awrosalam aw ansinyan amatoman da yang kariko ng syorat ng mga nabi makapantag kanak na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kay adaun nilan ako adto sang mga dili ng Yahodi. Sangu-sanguun nilan ako, paga-insoltoon aw atobadan. ");
INSERT INTO kqew_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Abadasan aw apatayun nilan ako. Awgaid sang ikatoo na allaw amabowi oman ako.” ");
INSERT INTO kqew_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Awgaid yang mga inindowan nan wa pakasabot sidto na pyaglaongan ni Isa. Yatago pa kanilan yang mana nan, agaw wa silan akatigam daw ono yang karim nan ipasabot kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Adon nang masaid da si Isa sang longsod ng Ariha, aon bota na yaga-ingkod sang kilid ng daan na yagapakilimos. ");
INSERT INTO kqew_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagdungug nan na madaig yang mga otaw na yalabay, yaga-osip yan daw ono yan. ");
INSERT INTO kqew_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pyagalaong yan ng mga otaw, “Yalabay si Isa na taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagdungug nan sinyan, yagapiyagit aw laong nan, “Kay Isa, Anak ni Daud, kallati ako!” ");
INSERT INTO kqew_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ansinyan syagda yan ng mga otaw sang onaan untak magpakatingun. Awgaid labi da yang pagpiyagit aw laong nan, “Oy, Anak ni Daud, kallati ako!” ");
INSERT INTO kqew_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ansinyan yamondang si Isa aw pyagasogo nan na adaun kanan yang bota. Nang pyadood da nilan, yosip yan ni Isa, ");
INSERT INTO kqew_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ono yang karim mo na inangun ko kammo?” Tyomobag yang bota, “Kay Dato, karim ko makakita!” ");
INSERT INTO kqew_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ansinyan yagalaong si Isa kanan, “Na, makakita da kaw! Yamadyaw da kaw sabap sang pagpangintoo mo.” ");
INSERT INTO kqew_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ansinyan yakakita dayon yan aw yamagad kang Isa na yagapoji sang Tohan. Aw yang kariko ng mga otaw na yakakita sinyan yanagpoji oman sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ansinyan dyomatung si Isa sang longsod ng Ariha aw yamagi yan ansan. ");
INSERT INTO kqew_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ansidto na longsod aon pangoo ng mga kobrador ng bowis na pyagangaanan kang Sakiyo. Yani si Sakiyo sapian na otaw. ");
INSERT INTO kqew_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Adon, sang yalabay da si Isa, magatanaw gao si Sakiyo daw sino yan. Awgaid sabap ng makagpa na otaw si Sakiyo wa yan pakakita sabap sang kadaig ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Agaw yang ininang nan, dyomaagan yan sang onaan ng mga otaw aw pyomanik yan sang kaoy na sikomoro untak kitaun nan si Isa kay ansan yan malabay. ");
INSERT INTO kqew_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagdatung ni Isa sidto na kaoy, ya-angad yan aw yagalaong yan kang Sakiyo, “Apas-apas dosan pagpanaog, kay Sakiyo, kay adon na allaw dait na adto ako pomanik sang kammo baay.” ");
INSERT INTO kqew_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Agaw yomapas-apas panaog si Sakiyo aw pyaga-agad nan si Isa adto sang baay nan na aon kasowat. ");
INSERT INTO kqew_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Adon, yang kariko ng mga otaw na yakakita kanilan yanagpatomod-tomod, laong nilan, “Nanga yani na otaw yakadto sang baay ng baradosa na otaw?” ");
INSERT INTO kqew_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na, adto sang baay yamindug si Sakiyo aw yagalaong yan kang Isa, “Paningug kanak, kay Dato. I-atag da ko yang katunga ng kanak kabutangan sang mga miskinan. Aw kong aon pyagalimbongan ko, ori ko kanan yang maskin maka-opat pa!” ");
INSERT INTO kqew_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ansinyan yagalaong si Isa kanan, “Adon na allaw lyowas da ng Tohan yani na pamilya kay yani na otaw topo oman ni Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kay ako na Anak ng Manosiya, yakani ako untak anapun aw lowasun ko yang mga otaw na mawat sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Adon, sarta yamaningug yang mga otaw sang pyaglaongan ni Isa, pyagalaong pa nan silan ng sambok na pasombingay. Ininang nan yani kay masaid da silan sa Awrosalam aw yagadumdum yang mga otaw na sinyan na wakto magasogod da magdato kanilan yang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Agaw, yagalaong si Isa, “Aon sambok na otaw na barabangsa na kyomadto sang mawat na banwa untak atagan yan adto ng kapatot ng pagsoltan kay untak pag-ori nan magadato da yan sang banwa nan. ");
INSERT INTO kqew_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Adon, sang wa pa yan apanaw, tyawag nan yang sampoo na ka otaw na mga sogowanun nan aw pangatagi nan yang matag-isa ng tagsambok na sapi na bowawan aw laong nan, ‘Pagnegosyowan mayo yani sampay sang pagbarik ko.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Awgaid yani na otaw dyumutan ng mga imamanwa nan. Agaw pagpanaw nan, yagapadaa silan ng mga otaw adto sidtong banwa na kyadtonan nan untak maglaong silan na di silan marim na yani na otaw yang magadato kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Awgaid ya-inang da yan ng soltan aw yamori da yan untak magdato sang banwa nan. Pag-ori nan, pyatawag dayon nan yang mga sogowanun nan untak tanawon nan daw pila yang yamaganansya nilan. ");
INSERT INTO kqew_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Yang yaka-ona domatung yagalaong kanan, ‘Kay Dato, yang sambok na sapi na yatag mo kanak yakaganansya ng sampoo.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“ ‘Madyaw!’ laong ng amo nan. ‘Madyaw kaw na sogowanun. Sabap ng kasarigan kaw sang tagbi na butang, isarig ko kammo yang pagdaa sang sampoo na mga syodad.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na, dyomatung da yang ikadowa na sogowanun aw maglaong, ‘Kay Dato, yang sapi na yatag mo kanak yakaganansya ng lima.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yagalaong yang amo sidto na sogowanun, ‘Kong maynan, magadaa da kaw sang limambok na syodad.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Na, dyomatung da oman yang sambok pa na sogowanun aw maglaong, ‘Kay Dato, idi kay yang kammo sapi. Byalot ko yan ng panyo aw tagowa ko. ");
INSERT INTO kqew_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yamalluk ako kammo kay maisug kaw na otaw. Akamangun mo yang wa mo pagapagodi, aw aganiun mo yang wa mo atanuma.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yagalaong kanan yang amo nan, ‘Way siyat mo na sogowanun! Kastigoon ta kaw mag-onawa ng pyaglaongan mo. Yamatigam kaw kadi na ako maisug, na akamangun ko yang wa ko pagapagodi aw aganiun ko yang wa ko atanuma? ");
INSERT INTO kqew_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, kong maynan, nanga wa mo ooga sang bangko yang kanak sapi kay untak pagbarik ko amakamang ko yang sapi ko na aon pay tobo?’ ");
INSERT INTO kqew_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ansinyan yagalaong yan sang mga otaw na yanag-indug sang masaid kanilan, ‘Kamanga mayo yang sapi na iyan kanan aw atagan mayo sidtong sogowanun na aon kanan sampoo na sapi.’ ");
INSERT INTO kqew_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Awgaid yagalaong silan, ‘Kay Dato, aon day sampoo nan!’ ");
INSERT INTO kqew_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Yagalaong yang amo, ‘Ipaglaong ko kamayo na sino-sino na kasarigan, atagan pa. Awgaid yang otaw na dili kasarigan, maskin yang tagbis na iyan kanan, akamangun pa kanan. ");
INSERT INTO kqew_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aw adon, idtong mga kalaban ko na wa akallini na ako yang magadato kanilan, daa mayo silan adi aw pataya mayo silan sa atobangan ko!’ ” ");
INSERT INTO kqew_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Paglaong sinyan ni Isa, pyomanaos yan adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nang masaid da silan sang mga baryo ng Bitpagi aw Bitani na adto sang Butay ng Jayton, pya-ona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqew_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Pagsuud mayo aon makita mayo na nati ng asno na inikutan ansan na wa pa gaid akasakayi. Obadi mayo aw daa adi kanak. ");
INSERT INTO kqew_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kong aon maga-osip kamayo daw onoon mayo yang asno, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ansinyan pyomanaw da idtong mga syogo ni Isa aw pagdatung nilan sang baryo, kinita nilan yang asno sobay sang pyaglaongan kanilan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nang yaga-obad da silan sang asno, yagalaong yang mga tagtomon kanilan, “Nanga yobadan mayo yang asno?” ");
INSERT INTO kqew_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tyomobag silan, “Kinaanglan yani ng kanami Dato.” ");
INSERT INTO kqew_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ansinyan dyaa da nilan yang nati ng asno adto kang Isa, yampasan nilan ng mga dagom nilan aw pasakaya nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nang yagapanaos da si Isa na yakasakay sang asno, pyanag-ampas ng mga otaw yang mga dagom nilan sang daan na agian nan silbi tanda ng pagbantog nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ansinyan nang masaid da si Isa sa Awrosalam aw paglodsad da nan sang daan sikun sang Butay ng Jayton, yamangkasowat yang kariko ng mga otaw na yamagad kanan. Yagasogod silan magpoji sang Tohan ng matanog sabap sang kariko ng mga katingaan na kinita nilan. ");
INSERT INTO kqew_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yanaglaong silan, “Atagan gao ng kadyawan yani na soltan na syogo ng Tohan! Adon aka-aonan kita ng kalinaw sikun sa sorga. Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqew_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ansinyan aon mga Parisi sang kadaig ng mga otaw na yagalaong kang Isa, “Kay Goro, sagdaa kono yang mga inindowan mo untak magpakatingun!” ");
INSERT INTO kqew_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tyomobag si Isa, “Ipaglaong ko kamayo na kong magpakatingun silan, yang mga bato da yang magapoji kanak ng matanog.” ");
INSERT INTO kqew_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nang masaid da si Isa sa Awrosalam aw kinita da nan yang syodad, yagatiyao yan sabap sang pagkallat nan sang mga otaw ansidto na syodad. ");
INSERT INTO kqew_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Laong nan, “Aw kyatigaman pa gaid mayo adon na allaw daw ono yang maka-atag kamayo ng kalinaw! Awgaid wa mayo akatigami. ");
INSERT INTO kqew_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Madatung sagaw yang wakto na asoongon aw asarikopan kamo ng mga kalaban mayo. Pagalupunan nilan yang kariko ng mga agianan mayo untak di da kamo makalogwa. ");
INSERT INTO kqew_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apatayun nilan kamo aw agubaun nilan yang kamayo syodad na way maskin isa na bato na amabilin sang kyabutangan nan. Yang kariko ninyan amaitabo kamayo kay wa mayo adawata yang Tohan pagdatung nan sang paglowas kamayo!” ");
INSERT INTO kqew_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ansinyan kyomadto si Isa sang Baay ng Tohan aw yagasogod yan magpalogwa sang mga yanagbarigya ansan. ");
INSERT INTO kqew_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Laong nan kanilan, “Yakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan!” ");
INSERT INTO kqew_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na, matag allaw yaga-indo si Isa adto sang Baay ng Tohan. Awgaid yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman kipat yang mga pangoo sang banwa, yagapanganap silan ng pama-agi sang pagpatay kanan. ");
INSERT INTO kqew_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Awgaid sidto na wakto way ma-inang nilan kay yang kariko ng mga otaw yamallini abay maningug sang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sangallaw sinyan yaga-indo si Isa sang mga otaw adto sang Baay ng Tohan aw yaga-osiyat yan ng Madyaw na Gogodanun. Ansinyan dyomood kanan yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi ");
INSERT INTO kqew_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aw yaga-osip silan kanan, “Paglaonga kami daw ono yang kapatot mo sang pag-inang sidto na mga butang. Sino yang yaga-atag kammo sini na kapatot?” ");
INSERT INTO kqew_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tyomobag si Isa, “Aon oman osip ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wain pagasikun yang kapatot ni Yahiya sang pagsogbo ng mga otaw, sang Tohan ba atawa sang manosiya?” ");
INSERT INTO kqew_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ansinyan yanagbaaw-baaw silan daw ono yang itobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun, ‘Na, nanga wa kamo apangintoo kanan?’ ");
INSERT INTO kqew_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, abatoon da kita ng mga otaw kay yang kariko nilan yagapangintoo na sambok na nabi si Yahiya!” ");
INSERT INTO kqew_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Agaw tyomobag silan, “Wa nami akatigami daw wain pagasikun yang kapatot nan.” ");
INSERT INTO kqew_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain pagasikun yang kapatot ko pag-inang sidto na mga butang.” ");
INSERT INTO kqew_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ansinyan yagalaong si Isa sini na pasombingay adto sang mga otaw, laong nan, “Aon otaw na aon kanan lopa na pyagatanuman nan ng grips. Ansinyan pya-atiman nan inyan sang mga sinarigan aw pyomanaw sang mawat na banwa. Yamadogay yan ansidto na banwa. ");
INSERT INTO kqew_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Adon, sang panahon ng pagpangipo da ng grips, syogo ng tagtomon yang sangka otaw na sogowanun nan adto sang mga sinarigan untak kamangun nan yang kanan bain ng abot. Awgaid pagdatung nan sang tanumanan, byonalan yan nidtong mga sinarigan aw pya-ori ng way daa. ");
INSERT INTO kqew_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ansinyan syogo da oman ng tagtomon yang sambok pa na sogowanun adto kanilan, awgaid byonalan da oman yan, pyakamomowaan pa aw pya-ori ng way daa. ");
INSERT INTO kqew_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ansinyan syogo da oman ng tagtomon yang ikatoo pa na sogowanun. Na, pyarian da oman nilan yan aw dyami adto sa logwa ng tanumanan. ");
INSERT INTO kqew_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ansinyan yagalaong yang tagtomon sang ginawa nan, ‘Ono da adon yang inangun ko? Na, madyaw pa aw sogoon ko yang pyasaya ko na anak kay basin addatan nilan yan.’ ");
INSERT INTO kqew_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amakun sini na tanumanan. Apatayun ta yan untak kanatun da yani na kabilin kanan.’ ");
INSERT INTO kqew_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Idto sagaw, pyalogwa nilan yan sang tanumanan aw pataya nilan. “Na,” yagalaong si Isa, “Ono da adon yang inangun ng tagtomon sidtong mga sinarigan? ");
INSERT INTO kqew_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sa way dowa-dowa na akadtonan nan aw apatayun nan silan aw ipa-atiman nan yang kanan tanumanan sang kadaigan pa na mga otaw.” Pagdungug sinyan ng mga otaw, yagalaong silan, “Di gao yan itogot ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ansinyan pyagatanawan silan ni Isa aw laong nan kanilan, “Na, ono kadi yang mana sang yakasorat sang Kitab na yagalaong, “ ‘Yang bato na dyami ng mga panday kay way kono kapantag, ya-inang kadi ng labi na barapantag.’ ");
INSERT INTO kqew_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sino-sino yang amalogso sidto na bato, amatomba aw ansinyan waa day siyat yang kinabowi nan. Awgaid madatung yang wakto na ama-oog da yang idtong bato aw sino-sino yang aka-oogan sinyan, di da gaid akatabangan.” ");
INSERT INTO kqew_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Adon, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga imam, karim gao nilan dakupun si Isa sinyan na wakto kay kyatigaman nilan na silan yang kyugdan ni Isa sini na pasombingay. Awgaid way ma-inang nilan kay yamalluk silan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na, pyagabantayan da nilan si Isa ng madyaw kay yagapanganap silan ng pama-agi na amadakup da nilan yan. Yang ininang nilan, yagabayad silan ng mga otaw na magasiling na madyaw silan aw sogowa nilan adto kang Isa. Awgaid yang toyo nilan na adakupun nilan si Isa sang pyaglaongan nan kay untak aon ikasombong nilan kanan adto sang gobirnador na taga Roma kay yan yang aon kapatot ng paghokom. ");
INSERT INTO kqew_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Adon yagalaong idtong mga otaw kang Isa, “Kay Goro, yamatigam kami na aag bunna yang pyagalaong aw pyaga-indo mo. Di kaw magapili sang otaw, awgaid aag kabunnaan yang pyaga-indo mo makapantag sang karim ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Adon, paglaonga kami daw sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sa Roma atawa dili?” ");
INSERT INTO kqew_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Awgaid kyatigaman ni Isa yang toyo nilan, agaw yagalaong yan, ");
INSERT INTO kqew_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitaan kanak yang sambok na sapi na pilak.” Pag-atag kanan ng sapi, yagalaong oman yan, “Kanino parangay aw ngaan yang yakabutang sini?” Tyomobag silan, “Kanang soltan sa Roma.” ");
INSERT INTO kqew_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ansinyan yagalaong si Isa, “Na, kong maynan, i-atag mayo sang soltan yang kanang soltan, aw i-atag oman mayo sang Tohan yang kanang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na, wa silan pakadakup kang Isa sang kanan pyaglaongan sa atobangan ng mga otaw. Aw yanagpakatingun da gaid silan kay yangkatingaa silan sang tobag nan. ");
INSERT INTO kqew_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ansinyan aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. Yaga-osip silan kang Isa, ");
INSERT INTO kqew_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kay Goro, yagasorat si Nabi Mosa sang Hokoman na kong amatay yang usug na way anak sang kanan asawa, dait na apangasawaun ng lomon nan yan na bobay untak ka-aonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqew_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Adon, aon pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. ");
INSERT INTO kqew_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Agaw pyangasawa da ng mangod na yagasonod kanan inyan na biyoda, awgaid yamatay da oman yan na usug na way anak. ");
INSERT INTO kqew_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na, pyangasawa da oman yan na bobay ng ikatoo taman sa ikapito na mangod. Awgaid obos silan yamatay na way anak. ");
INSERT INTO kqew_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqew_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Adon, sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay? Kay yang kariko ng pito na maglomon yakapangasawa kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tyomobag si Isa aw laong nan kanilan, “Adi sang donya amangasawa aw magabana yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Awgaid adto sang ahirat, yang mga otaw na tyarima ng Tohan na dait silan bowiun sikun sang kamatay aw adaun adto sa sorga, di da silan amangasawa atawa magabana. ");
INSERT INTO kqew_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kay mag-onawa da silan sang mga malaikat na di amatay. Yamabaoy da silan ng mga anak ng Tohan kay yabowi oman silan sikun sang kamatay. ");
INSERT INTO kqew_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Awgaid makapantag sang pagkabowi oman ng mga patay, na, maskin si Nabi Mosa yagapangimunna na amabowi oman yang mga patay. Kay yakasorat sang Kitab Tawrat adto sa gogodanun makapantag sang tagbi na kaoy na yamallaga na tyawag ni Nabi Mosa yang Tohan na ‘Tohan ni Ibrahim, ni Isahak aw ni Yakob.’ ");
INSERT INTO kqew_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay kay adto kanan bowi yang kariko ng mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ansinyan yagalaong yang kadaigan ng mga magiindoway ng Hokoman, “Kay Goro, madyaw yang tobag mo.” ");
INSERT INTO kqew_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na, sikun sinyan waa day yamangisug mag-osip pa kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ansinyan yaga-osip si Isa kanilan, “Nanga yagalaong yang mga otaw na yang Almasi topo ni Soltan Daud? ");
INSERT INTO kqew_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kay si Soltan Daud mismo yang yagalaong sa Kitab Jabor, “ ‘Yagalaong yang Tohan sang kanak Dato, “Pag-ingkod adi sang karinto ko ");
INSERT INTO kqew_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampay na ataloon ko yang mga kalaban mo aw ma-inang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqew_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, kong tyawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” ");
INSERT INTO kqew_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sarta yamaningug pa kanan yang madaig na mga otaw, yagalaong si Isa sang mga inindowan nan, ");
INSERT INTO kqew_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pagbantay kamo sang mga magiindoway ng Hokoman kay kallini nilan mandagom ng joba untak silan addatan ng mga otaw. Aw adto sang palengke, karim nilan na asalamun silan ng mga otaw. Adto oman sang pagsasambayangan, karim nilan mag-ingkod sang ingkodanan ng dakowa na mga otaw. Aw sang mga kandori, karim nilan mag-ingkod sang ingkodanan ng mga otaw na dait addatan. ");
INSERT INTO kqew_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pyasikotan nilan yang mga biyoda untak ma-agaw nilan yang kanilan kakawasaan. Aw pataasun nilan yang pagdowaa nilan sa atobangan ng mga otaw untak magpakita silan na madyaw silan na mga otaw. Na, labi da yang siksa kanilan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sarta yagatanaw si Isa sang mga otaw adto sang Baay ng Tohan, kinita nan yang sapian na mga otaw na yaga-oog ng sidoka nilan sang butanganan ng sapi. ");
INSERT INTO kqew_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ansinyan aon oman kinita nan na sambok na biyoda na miskin na yaga-atag ng dowambok gaid na sinsilyo. ");
INSERT INTO kqew_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ansinyan yagalaong si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na yani na biyoda na miskin yaga-atag ng labaw pa sidtong yatag ng kadaigan pa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay silan, yaga-atag silan ng sapi sikun sang sobra nilan na kakawasaan. Awgaid yani na bobay, abir bali na kamiskin nan, yatag nan yang kariko ng kanan sapi.” ");
INSERT INTO kqew_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ansinyan aon pilangka otaw na mga inindowan ni Isa na yanagbaaw makapantag sang Baay ng Tohan na mangkadyaw yang mga bato na gyamit sang pag-inang sinyan aw madyaw tanawon yang mga pyangatag ng mga otaw. Awgaid yagalaong si Isa, ");
INSERT INTO kqew_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Taman sini na kinita mayo adon, madatung yang allaw na yang kariko sinyan amasapad. Way maskin sambok na bato na amabilin sang kyabutangan nan kay obos silan ipangkanat-kanat.” ");
INSERT INTO kqew_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ansinyan yanag-osip silan kang Isa, “Kay Goro, kano pa matoman yani na pyaglaongan mo? Aw ono yang tanda na magapatigam kanami na mallug da amaitabo yang kariko ninyan?” ");
INSERT INTO kqew_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo untak di kamo kalimbongan ng maskin sino. Kay madaig yang mga otaw na madatung sa kanak ngaan aw magalaong silan na, ‘Ako yang Almasi,’ atawa ‘Dyomatung da yang kataposan ng donya.’ Awgaid ayaw kamo pag-agad kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aw pagdungug mayo na aon mga gira aw mga kasamok, ayaw kamo pagkalluk. Kay dait na amaitabo ona yang kariko ninyan, awgaid dili pa yani yang kataposan ng donya.” ");
INSERT INTO kqew_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yagalaong oman si Isa, “Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagdatowan mapaglaban adto sang kadaigan. ");
INSERT INTO kqew_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ama-aon yang makusug na mga linog, aw sang yagakatuna-tuna na mga banwa ama-aon yang gutum aw mga sakit na makatapon. Aw adto sang langit aon makita mayo na mga tanda na makallukay aw katingaan. ");
INSERT INTO kqew_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Awgaid sang wa pa yani akaitabo, apandakupun aw apasikotan kamo. Adaun kamo adto sang pagsasambayangan ng mga Yahodi aw apamirisoon kamo. Sabap sang pagpangintoo mayo kanak adaun kamo adto sang mga gobirnador aw mga soltan. ");
INSERT INTO kqew_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Agaw butangan mayo sang pangatayan mayo na di kamo amarido daw ono yang ipaglaong mayo. ");
INSERT INTO kqew_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kay ako da yang maga-atag kamayo ng katigam daw ono yang ipaglaong mayo untak yang mga kalaban mayo di makasopak atawa makadaog kamayo. ");
INSERT INTO kqew_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Awgaid pagatraydoran kamo ng maskin kamayo mga taganak, mga kalomonan, kadogo aw mga kaupudanan mayo, aw yang kadaigan kamayo ipapatay nilan. ");
INSERT INTO kqew_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aw adumutan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqew_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Awgaid way maskin sambok na logay mayo na amawaa kong dili ng kahanda ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kong magapadayon kamo sang pagpangintoo mayo kanak sampay sang kataposan sini na mga kasikotan, aka-aonan kamo ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aw kitaun mayo yang Awrosalam na kyasarikopan ng mga sondao, akatigaman mayo na mallug da yan masapad. ");
INSERT INTO kqew_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na, sinyan na wakto yang mga otaw na adto sa Yahodiya, dait silan domaagan adto sang kabutayan. Yang mga otaw na adto sa Awrosalam, dait silan lomogwa sikun sang syodad, aw yang mga otaw na adto sang pawa, di silan dait pakadtonon sang syodad. ");
INSERT INTO kqew_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kay dyomatung da yang wakto na asiksaun ng Tohan yang mga taga Awrosalam aw ansinyan amatoman da yang kariko ng yakasorat sang Kitab makapantag sinyan. ");
INSERT INTO kqew_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pagdatung sinyan na mga allaw, kallat nidtong mga mabdus aw yang mga yagapasoso. Kay labi da yang kasikotan na madatung sini na banwa aw asiksaun da ng Tohan yang mga otaw na bangsa Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yang kadaigan kanilan apatayun ng ispada, aw yang kadaigan amadaa adto sang yagakatuna-tuna na mga banwa. Aw yang Awrosalam asapadan ng mga otaw na dili ng Yahodi aw silan da yang magadato sini na banwa sampay na madatung yang wakto na pyagakahanda kanilan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sang madatung na mga allaw aon ma-inang na mga tanda adto sang suga, bowan aw yang mga bitoon. Aw adi sang donya amangkarido yang mga bangsa aw amangkalluk silan sang pagdungug nilan sang makusug na tingug ng dagat aw pagkita nilan sang mangkadakowa na mga baud. ");
INSERT INTO kqew_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Akakoyapan yang mga otaw sabap sang alluk nilan kay yamarido silan daw ono yang amaitabo sang donya. Kay yang maskin ono na adto sang langit amagayung. ");
INSERT INTO kqew_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aw ansinyan makita nilan ako na Anak ng Manosiya na mabarik adi sang donya na pyagalibotan ng gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqew_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, kong kitaun da mayo na yagasogod da yani na mga pangitabo, pabagsuga mayo yang pangatayan mayo kay mallug da domatung yang wakto na alowasun kamo ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ansinyan yagalaong kanilan si Isa sini na pasombingay, laong nan, “Tanawa mayo yang kaoy na igira aw yang kadaigan pa na mga kaoy. ");
INSERT INTO kqew_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aw kitaun mayo na yamanaringsing da silan, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqew_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mag-onawa sinyan, pagkita mayo na ma-inang da yang kariko sini na pyagalaong ko kamayo, akatigaman da mayo na masaid da yang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sa bunna-bunna na ipaglaong ko kamayo na amatoman yang kariko sinyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqew_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pagbantay kamo na di mayo apasagdan yang ginawa mayo sang mga pakaradyaan aw yang pag-inum kipat yang pagkarido sang panginabowi mayo. Kay kong maynan, basin adatungan kamo sidto na allaw na mabarik ako na Anak ng Manosiya na wa kamo pakabantay aw main da kamo ng kyalitagan. ");
INSERT INTO kqew_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kay yan na allaw madatung sang kariko ng mga otaw adi sa babawan ng donya. ");
INSERT INTO kqew_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Agaw sagaw, abay kamo pagbantay aw abay kamo pagdowaa kay untak aon kabagsug mayo aw di kamo ama-ono sang madatung na mga pangitabo aw way kamomowa mayo kong amatobang da kamo kanak na Anak ng Manosiya.” ");
INSERT INTO kqew_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na, kada allaw yaga-indo si Isa adto sang Baay ng Tohan. Awgaid kada gabi yakadto yan sang Butay ng Jayton aw adto yan katoog. ");
INSERT INTO kqew_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aw pagkaamdag ng masuum pa, yakadto yang mga otaw sang Baay ng Tohan untak maningug kanan. ");
INSERT INTO kqew_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ansinyan masaid da yang Pakaradyaan ng Pan na way Labadora na tyawag oman ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Adon, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yanagbaaw-baaw silan daw monono yang pagpatay kang Isa na di akatigaman ng mga otaw kay yamalluk silan kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ansinyan yasuudan da si Yodas ni Iblis. Yani si Yodas na tyawag na Iskariyot, isa sang sampoo aw dowa na mga sahabat ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Agaw pyomanaw da si Yodas kay mapagbaaw yan sang mga pangoo ng mga imam kipat yang mga pangoo ng mga gowardya sang Baay ng Tohan daw monono yang pagtraydor nan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na, yamangkasowat da silan aw yanagka-oyon silan na abayadan si Yodas. ");
INSERT INTO kqew_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yasogot oman si Yodas, aw sikun sinyan yagapanganap yan ng wakto na madyaw ipadakup kanilan si Isa na way abay otaw na makakita. ");
INSERT INTO kqew_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ansinyan dyomatung da yang allaw ng Pakaradyaan ng Pan na way Labadora na yani yang allaw na dait sobariun yang mga karniro para sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Agaw syogo ni Isa si Pitros aw si Yahiya aw laong nan kanilan, “Panaw da kamo aw andama mayo yang kanatun pagkan para sang Pakaradyaan ng Paglabay.” ");
INSERT INTO kqew_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ansinyan yaga-osip silan kanan, “Wain yang karim mo na andamun nami yang kandori?” ");
INSERT INTO kqew_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tyomobag si Isa, “Pagsuud mayo sang syodad, aon masongon mayo na otaw na yagapusan ng banga ng tobig. Agad kamo kanan sang apanikan nan na baay ");
INSERT INTO kqew_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aw paglaonga mayo yang tagtomon sidtong baay na, ‘Yaga-osip yang goro nami daw wain kono na kowarto yan makakan sang kandori sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ");
INSERT INTO kqew_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ansinyan ipakita nan kamayo yang dakowa na kowarto adto sa taas ng baay na yandam da dadaan. Adto da mayo andama yang kanatun pagkan sang kandori.” ");
INSERT INTO kqew_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ansinyan pyomanaw da silan aw yatoman yang kariko ng pyaglaongan kanilan ni Isa. Aw pyaga-andam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqew_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na, pagdatung ng wakto ng kandori, yamingkod da si Isa sang lamisa upud sang mga sahabat nan. ");
INSERT INTO kqew_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ansinyan yagalaong yan kanilan, “Dakowa yang karim ko mag-upud kamayo sang kandori sini na Pakaradyaan ng Paglabay sang di pa ako amagi ng kasikotan. ");
INSERT INTO kqew_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kay ipaglaong ko kamayo na di da ako makan sinyan sampay sang wakto na amatoman da yang katoyowan sini na pakaradyaan adto sang pyagdatowan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ansinyan kyomamang si Isa ng inumanan aw pagkatapos manginsokor sang Tohan yagalaong yan kanilan, “Dawata mayo yani aw inuma mayo. ");
INSERT INTO kqew_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ipaglaong ko kamayo na sikun adon di da ako minum ng tumuk ng grips sampay sang wakto na magadato da yang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ansinyan kyomamang oman yan ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan yang pan aw atagan sang mga sahabat nan aw laong nan, “Yani yang kanak lawas na yatag para kamayo. Kana mayo yani na pan aw inanga mayo yani sang pagdumdum kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mag-onawa oman sinyan pagkatapos nilan koman, yatag nan kanilan yang inumanan aw laong nan, “Yang lasak sini na inumanan yang bago na pama-agi na pyasad ng Tohan untak ma-inang kamo ng mga otaw na sakop nan. Yang kanak dogo na maboos para kamayo maga-atag ng kasigorowan sini na pyagapasadan. ");
INSERT INTO kqew_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Awgaid adon yaga-upud kanak adi sang lamisa yang magatraydor kanak. ");
INSERT INTO kqew_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Amatay ako na Anak ng Manosiya mag-onawa ng pyagakahanda kanak ng Tohan. Awgaid kallat sidtong otaw na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ansinyan yanag-inosipay yang mga sahabat daw sino kanilan yang magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ansinyan yanaglalis yang mga sahabat daw sino kanilan yang labaw. ");
INSERT INTO kqew_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Awgaid yagalaong si Isa kanilan, “Yang mga soltan sang yagakatuna-tuna na bangsa yagamando sang mga sakop nilan. Aw yang aon kapatot, karim nilan na matawag silan ng ‘Maoyanun na Pangoo’. ");
INSERT INTO kqew_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Awgaid dili ng maynan adi kamayo. Kay yang labaw kamayo dait masiling ng kimod mayo, aw yang pangoo dait masiling ng sogowanun mayo. ");
INSERT INTO kqew_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sino kadi yang labaw? Yang yaga-ingkod sang pagkan atawa yang yaga-aya kanan? Di ba idtong yaga-ingkod sang pagkan? Awgaid ako, idi ako kamayo na yasiling ng sogowanun mayo. ");
INSERT INTO kqew_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kamo yang yamagad kanak sang kariko ng kasikotan na ya-agian ko. ");
INSERT INTO kqew_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agaw atagan ta kamo ng kapatot ng pagdato na mag-onawa ng kapatot na yatag kanak ng kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Amaka-upud kamo kanak sang kandori adto sang pyagdatowan ko aw maka-ingkod kamo untak magdato sang sampoo aw dowa na mga tribo ng Israil.” ");
INSERT INTO kqew_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ansinyan yagalaong si Isa kang Pitros, “Kay Simon, paningug kanak! Tyogotan ng Tohan si Iblis pagtigi sang kariko mayo. Yang pagsasat nan kamayo mag-onawa ng pagtaap ng omay untak makamang yang tipig. ");
INSERT INTO kqew_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bunna sagaw na magatarikod kaw kanak, awgaid yagadowaa da ako para kammo na di amawaa yang pagpangintoo mo. Aw pagbarik da mo oman kanak, pabagsuga yang pagpangintoo ng mga kalomonan mo.” ");
INSERT INTO kqew_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yagalaong si Pitros, “Kay Dato, di ako magatarikod kammo. Andam ako na amapiriso atawa amatay upud kammo.” ");
INSERT INTO kqew_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Awgaid yagalaong si Isa, “Ipaglaong ko kammo, kay Pitros, sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw akilaa kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ansinyan yosip ni Isa yang mga sahabat nan, laong nan, “Singaong syogo ta kamo sang pagpayapat na way daa mayo na sapi, lasakanan atawa sandalyas, aon bay yakolang kamayo?” Laong nilan, “Waa!” ");
INSERT INTO kqew_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Awgaid adon,” laong ni Isa, “daw sino yang aon pitaka atawa lasakanan, dait na adaun nan. Aw yang way lodyo, dait na ibarigya nan yang kanan dagom untak makabili yan ng lodyo. ");
INSERT INTO kqew_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kay ipaglaong ko kamayo na dait amatoman yani na yakasorat sang Kitab makapantag kanak na yagalaong, ‘Yamabilang yan sang mga darowaka.’ Na, bunna sagaw na masaid da yang pagtoman ng yakasorat makapantag kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ansinyan yagalaong yang mga sahabat nan, “Tanawa, kay Dato, aon disini dowambok na lodyo.” Tyomobag si Isa, “Osto da yan.” ");
INSERT INTO kqew_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ansinyan pyomanaw si Isa sikun sa Awrosalam aw kyomadto yan sang Butay ng Jayton mag-onawa ng kya-anadan nan. Aw yamagad kanan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdatung nilan ansan, yagalaong yan kanilan, “Pagdowaa kamo untak di kamo madaa ng sasat.” ");
INSERT INTO kqew_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ansinyan kyomadto yan sang mawat-awat kanilan, lyomood yan aw magdowaa. ");
INSERT INTO kqew_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Laong nan, “O kay Ama, kong karim mo, ayaw ako pa-agia sini na kasikotan, awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqew_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ansinyan aon malaikat sikun sang sorga na yagapakita kanan aw yagapabagsug kanan. ");
INSERT INTO kqew_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sabap sang labi na pagkarido ng ginawa nan yagadowaa yan ng waa day main da nan sampay na yowasan yan ng maynang dogo na yamanagdo sang lopa. ");
INSERT INTO kqew_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatapos nan magdowaa, byomarik yan sang mga inindowan nan aw yadatungan nan silan na yamangkatoog sabap ng dakowa oman yang karido nilan. ");
INSERT INTO kqew_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ansinyan pyokaw nan silan aw yagalaong yan kanilan, “Nanga yamangkatoog kamo? Bangon da kamo aw pagdowaa untak di kamo madaa ng sasat.” ");
INSERT INTO kqew_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nang yagalaong pa si Isa, dyomatung yang madaig na mga otaw. Si Yodas na sambok sang sampoo aw dowa na mga sahabat yang yaga-ona kanilan. Ansinyan dyomood yan kang Isa sang pag-auk kanan. ");
INSERT INTO kqew_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Awgaid yagalaong kanan si Isa, “Kay Yodas, pagatraydoran mo ako na Anak ng Manosiya pina-agi sang auk?” ");
INSERT INTO kqew_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagkita sinyan ng mga kaupudanan ni Isa, yanaglaong silan, “Kay Dato, atibasun da nami silan?” ");
INSERT INTO kqew_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na, tinibas da ng sambok na inindowan yang sogowanun ng Dakowa na Imam aw ya-otod yang karinto na taringa nan. ");
INSERT INTO kqew_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Awgaid yagalaong si Isa, “Osto da yan!” Ansinyan tyakmagan nan yang taringa ng otaw aw pakadyawa nan. ");
INSERT INTO kqew_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ansinyan yagalaong si Isa sang mga pangoo ng mga imam, sang mga pangoo ng mga gowardya sang Baay ng Tohan kipat yang mga pangoo ng mga Yahodi na dyomatung sang pagdakup kanan, laong nan, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng mga lodyo aw bobonal? ");
INSERT INTO kqew_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kada allaw adto ako sang Baay ng Tohan aw adto oman kamo, awgaid wa mayo ako adakupa. Awgaid yani adon yang wakto na yatag kamayo aw wakto oman na yagadato si Iblis na iyan sang kadugguman.” ");
INSERT INTO kqew_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ansinyan dyakup nilan si Isa aw daa nilan adto sang baay ng Dakowa na Imam. Adon si Pitros, yasonod yan kanilan sang mawat-awat. ");
INSERT INTO kqew_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Awgaid pagduuk ng mga gowardya ng atoon sang tunga ng pamanag ng baay aw pag-ingkod nilan sang palibot sinyan untak kapasowan silan, dyomood oman si Pitros aw yamingkod upud kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ansinyan aon sambok na sogowanun na bobay na yakakita kang Pitros na yaga-ingkod sang masaid sang atoon. Pyakatanawan nan si Pitros aw yagalaong yan, “Yani na otaw, inagad ni Isa.” ");
INSERT INTO kqew_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Awgaid yagadili si Pitros, “Kay Bi, wa ako akilaa kanan.” ");
INSERT INTO kqew_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pagkatugun-tugun sinyan aon oman yakakita kanan na otaw aw laong nan, “Ikaw, kaupudanan oman nilan.” Awgaid yagalaong si Pitros, “Kay Itin, dili!” ");
INSERT INTO kqew_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mga sangka oras sinyan aon oman otaw na yagalaong, “Bunna sagaw na yani na otaw inagad ni Isa kay taga Jalil oman yan.” ");
INSERT INTO kqew_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Awgaid yagalaong si Pitros, “Kay Itin, way gindawan ko sang pyagalaong mo!” Na, sinyan na wakto nang yagalaong pa yan, yagatagaok yang laboyo. ");
INSERT INTO kqew_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ansinyan lyomingi si Isa aw pyakatanawan nan si Pitros. Ansinyan kyadumduman ni Pitros yang pyagalaong kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw akilaa kanak.” ");
INSERT INTO kqew_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na, lyomogwa da si Pitros aw bali na pagtiyao nan. ");
INSERT INTO kqew_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ansinyan pyagasangu-sangu si Isa ng mga otaw na yagabantay kanan aw byonalan nilan yan. ");
INSERT INTO kqew_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tyabonan nilan yang mata ni Isa aw paglaonga nilan, “Tagnaa kono daw sino yang yagasontok kammo!” ");
INSERT INTO kqew_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aw madaig pa yang mga insolto na pyagalaong nilan adto kanan. ");
INSERT INTO kqew_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagka-ilaw sinyan yanagkatipon yang mga pangoo ng mga Yahodi, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman. Silan yang mga opisyales ng Makagwas na Hokomanan. Na, ansinyan dyaa si Isa sa atobangan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Laong nilan kang Isa, “Paglaonga kami daw ikaw yang Almasi.” Tyomobag si Isa aw laong nan, “Aw paglaongon ta kamo, di kamo mangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aw osipun ta kamo, di oman kamo matobag. ");
INSERT INTO kqew_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Awgaid sikun adon, ako na Anak ng Manosiya, maga-ingkod da ako apit sang karinto ng Tohan na Labi na Mabarakat.” ");
INSERT INTO kqew_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yanag-osip da yang kariko nilan, “Kong maynan, ikaw agaw yang Anak ng Tohan?” Tyomobag si Isa aw laong nan kanilan, “Yan agaw yang pyagalaong da mayo.” ");
INSERT INTO kqew_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ansinyan yanaglaong silan, “Di da kita kinaanglan ng kadaigan pa na saksi! Kita da mismo yang yakadungug sang pyaglaongan nan!” ");
INSERT INTO kqew_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ansinyan yamindug yang kariko ng mga opisyales aw dyaa nilan si Isa adto kang Pilato, yang gobirnador na taga Roma. ");
INSERT INTO kqew_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na, yagasogod da silan magsombong kang Isa, laong nilan, “Kyasakpan nami yani na otaw na yagasamok sang kapag-onawa nami na mga Yahodi kay pyagalaong nan silan na di magbayad ng bowis adto sang soltan sa Roma. Aw yagalaong pa yan na yan kono yang Almasi, yang pyasad ng Tohan na magasoltan kanami.” ");
INSERT INTO kqew_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Agaw yaga-osip si Pilato kang Isa, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag si Isa, “Yan agaw yang pyagalaong da mo.” ");
INSERT INTO kqew_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ansinyan yagalaong si Pilato sang mga pangoo ng mga imam aw sang mga otaw ansan, “Way kinita ko na dosa sini na otaw na dait yan hokoman.” ");
INSERT INTO kqew_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Awgaid yagapadayon silan mag-akosar kanan, laong nilan, “Yagakasamok yang mga otaw sang tibok Yahodiya sabap sang pag-indo nan. Yagasogod yan mag-indo sang probinsya ng Jalil aw adon dyomatung da yan adi sa Awrosalam.” ");
INSERT INTO kqew_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagdungug sinyan ni Pilato, yaga-osip yan, “Taga Jalil ba yani na otaw?” ");
INSERT INTO kqew_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na, pagkatigam ni Pilato na si Isa sikun sang probinsya na sakop ni Hirod, pyadaa nan yan adto kang Hirod kay sidto na wakto iyan oman si Hirod sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na, pagkita ni Hirod kang Isa, dakowa yang kasowat nan kay dogay da karim nan komita kang Isa. Madaig yang dyungug nan makapantag kanan aw kallini nan kitaun na maga-inang yan ng katingaan. ");
INSERT INTO kqew_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Agaw madaig yang osip nan kang Isa, awgaid wa yan atobag kanan. ");
INSERT INTO kqew_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ansinyan dyomood yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw maskin ono da yang pyagasombong nilan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ansinyan pyagasangu-sangu si Isa ni Hirod kipat yang mga sondao nan aw ininsolto nilan yan. Pyandagoman nilan si Isa ng tanto madyaw na joba na maynang dagom ng soltan aw pyabarik nilan adto kang Pilato. ");
INSERT INTO kqew_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, sinyan na allaw yagakadyaw si Pilato aw si Hirod na dati magkalaban silan. ");
INSERT INTO kqew_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ansinyan pyatawag ni Pilato yang mga imam, yang mga pangoo aw yang kadaigan pa na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Laong nan kanilan, “Dyaa mayo adi kanak yani na otaw aw yagalaong kamo na yan kono yagasamok sang mga otaw. Na, pyaga-imbistigar ko yan adi sa atobangan mayo aw way kinita ko na dosa nan na mag-onawa ng pyagalaong mayo. ");
INSERT INTO kqew_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Si Hirod oman, way kinita nan na dosa sini na otaw. Idto sagaw, pyabarik nan adi kanatun. Na, way ininang sini na otaw na dait nan akamatay. ");
INSERT INTO kqew_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Agaw, apabadasan da ko gaid yan aw aboyan da ko.” ");
INSERT INTO kqew_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na, idto yang pyagalaong ni Pilato kay matag Pakaradyaan ng Paglabay yang kya-anadan ng gobirnador na aboyan nan yang sangka otaw na yapiriso. ");
INSERT INTO kqew_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Awgaid yagadungan magpiyagit yang kariko ng mga otaw aw laong nilan, “Pataya yan na otaw! Booi kanami si Barabas!” ");
INSERT INTO kqew_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yani si Barabas, yapiriso yan sabap ng yaka-apil yan sang paglaban sang gobirno na ininang singaon sa Awrosalam aw yakapatay yan ng otaw. ");
INSERT INTO kqew_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na, karim gao ni Pilato na aboyan si Isa, agaw yapagbaaw da oman yan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Awgaid yagapiyagit silan aw laong nilan, “Ilansang yan sa kros! Ilansang yan sa kros!” ");
INSERT INTO kqew_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na, ikatoo da maglaong kanilan si Pilato, laong nan, “Nanga? Ono yang dosa na ininang nan? Way kinita ko na dosa na dait nan akamatay. Apabadasan da ko gaid yan aw aboyan da ko!” ");
INSERT INTO kqew_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Awgaid yagapadayon silan magpiyagit na si Isa ipalansang sa kros. Aw sang orian yatoman da yang karim nilan. ");
INSERT INTO kqew_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Agaw, yokoman da ni Pilato si Isa mag-onawa ng pyagapangayo ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Byoyan nan yang otaw na yapiriso sabap sang paglaban sang gobirno aw pagpatay kay yan yang pyagapangayo ng mga otaw. Awgaid si Isa, yatag nan kanilan untak inangun nilan kanan yang karim nilan. ");
INSERT INTO kqew_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ansinyan dyaa si Isa ng mga sondao adto sa logwa ng syodad. Sarta yagapanaw silan, aon syongon nilan na otaw na pyagangaanan kang Simon na taga Kirini. Sikun yan sang baryo aw yagapaduug sang syodad ng Awrosalam. Ibira yan ng mga sondao aw pyapusan nilan kanan yang kaoy na pagalansangan kang Isa aw pyasonod nilan yan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adon, madaig yang mga otaw na yamagad kang Isa upud sang mga bobay na yanagtiyao aw yanagminatay sabap kanan. ");
INSERT INTO kqew_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ansinyan lyomingi si Isa kanilan aw laong nan, “Mga kaobayan ng Awrosalam, ayaw kamo pagtiyao sabap kanak. Awgaid pagtiyaowi mayo yang ginawa mayo aw yang mga anak mayo. ");
INSERT INTO kqew_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kay madatung yang wakto na magalaong yang mga otaw, ‘Kadyaw ng ginawa ng mga bobay na di maka-anak, aw yang mga bobay na way anak aw wa pagapasoso!’ ");
INSERT INTO kqew_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aw sidto na wakto magalaong yang mga otaw sang mga butay, ‘Taboni kami untak kami matay!’ ");
INSERT INTO kqew_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na, kong maynan yang ma-inang sang otaw na way dosa, labi da yang siksa sidtong mga otaw na yakadosa.” ");
INSERT INTO kqew_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Adon, aon oman dowangka otaw na mga darowaka na dyaa nilan untak silan patayun upud kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagdatung nilan sang logar na tyawag ng Oo ng Kalabira, lyansang nilan si Isa sa kros kipat sidtong dowangka otaw, yang sambok sang karinto ni Isa aw yang sambok sang kawaa nan. ");
INSERT INTO kqew_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Adon yagalaong si Isa, “O kay Ama, ampona silan kay wa silan akatigam daw ono yang ininang nilan.” Ansinyan yanagripa yang mga sondao untak bainun nilan yang mga dagom ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na, yang mga otaw yanag-indug ansan aw yanagtanaw sarta pyagasangu-sangu si Isa ng mga pangoo ng mga Yahodi. Laong nilan, “Tyabangan nan yang kadaigan. Tanawon ta adon daw makalowas yan sang ginawa nan, daw bunna na yan yang Almasi, yang pinili ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na, maskin yang mga sondao yanagsangu-sangu kanan. Dyomood silan kang Isa aw pya-inum nilan yan ng magsing na bino. ");
INSERT INTO kqew_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aw yagalaong silan, “Lowasa yang ginawa mo kong bunna na ikaw yang soltan ng mga Yahodi!” ");
INSERT INTO kqew_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Adto sa taas ng oo ni Isa aon yakasorat na yagalaong, “Yani yang Soltan ng mga Yahodi.” ");
INSERT INTO kqew_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ansinyan yang sangka otaw na darowaka na lyansang oman ansan, ininsolto nan si Isa, laong nan, “Di ba ikaw yang Almasi? Na, lowasa yang sarili mo aw lowasa oman kami!” ");
INSERT INTO kqew_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Awgaid kyadamanan yan ng kaupudanan nan, laong nan, “Wa kaw akalluk sang Tohan na yokoman da kaw na mag-onawa kanan? ");
INSERT INTO kqew_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Awgaid kita dowa, dait kita kastigoon sabap sang maat na ininang ta. Awgaid yani na otaw, way dosa nan.” ");
INSERT INTO kqew_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aw yagalaong yan kang Isa, “Dumduma ako, kay Isa, kong magadato da kaw.” ");
INSERT INTO kqew_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ansinyan yagalaong si Isa kanan, “Sa bunna-bunna na ipaglaong ko kammo na adon na allaw amaka-upud kaw kanak adto sa sorga.” ");
INSERT INTO kqew_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Adon, pagka-alas dose ng suga yagkaduggum yang tibok banwa taman ng alas tres ng ambong. ");
INSERT INTO kqew_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sidto na mga wakto wa pagasiga yang suga. Aw yang madakmuu na kortina na adto sang Baay ng Tohan yamalasi aw yamatunga sang dowa. ");
INSERT INTO kqew_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ansinyan yagapiyagit si Isa aw laong nan, “Kay Ama, i-atag da ko kammo yang kanak nyawa!” Aw paglaong nan sinyan, yamabogto da yang napas nan. ");
INSERT INTO kqew_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Adon, yang kapitan ng mga sondao na yakakita sidtong yamaitabo, pyoji nan yang Tohan aw laong nan, “Bunna sagaw na yani na otaw way dosa!” ");
INSERT INTO kqew_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aw yang kariko ng mga otaw na yakakita sidtong yamaitabo yanagpangori na byogbog nilan yang kanilan aba sabap ng kyasakitan yang ginawa nilan. ");
INSERT INTO kqew_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Awgaid yang kariko ng yakilaa kang Isa upud sidtong mga bobay na yamagad kanan sikun pa sa Jalil, yanag-indug silan adto sang mawat aw yanagtanaw silan. ");
INSERT INTO kqew_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Adon, aon sambok na otaw na pyagangaanan kang Yosop na taga Arimatiya na sambok na longsod sa Yahodiya. Yani si Yosop madyaw na otaw aw matorid yang ininang nan aw yagatagad yan sang wakto na magadato da yang Tohan. Maskin opisyal yan sang Makagwas na Hokomanan, wa yan paka-oyon sang paghokom aw pagpatay ng mga kaupudanan nan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na, yani si Yosop kyomadto kang Pilato aw pyangayo nan yang patay na lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagkatapos sinyan kyamang nan yang lawas ni Isa aw byalot nan ng mapoti aw butangan nan sang kobor na pyalongagan sang bato. Yani na kobor wa pa akobori. ");
INSERT INTO kqew_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na, sidto na allaw Jomaat na allaw ng pagpangandam para sang Allaw ng Pagpatana na masaid da magsogod. ");
INSERT INTO kqew_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Adon, yang kaobayan na yagasikun sa Jalil upud kang Isa yamagad kang Yosop aw kinita nilan yang kobor aw monono yang pagbutang ng lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ansinyan yamori da silan aw yanag-andam silan ng mga paballo para sang patay. Awgaid sang Allaw ng Pagpatana yagapatana silan sobay sang sogowan ng agama Yahodi. ");
INSERT INTO kqew_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Adon, pagkaamdag ng masuum pa sang allaw ng Domingo kyomadto yang idto na mga bobay sang kobor na yagadaa ng mga paballo na pyaga-andam nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagdatung nilan adto, kinita nilan na yamaligid da yang bato sikun sa baba ng kobor. ");
INSERT INTO kqew_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Agaw syomuud silan, awgaid waa da don yang patay na lawas ni Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sarta yanag-indug silan adto sa suud na yangkatingaa, sakadyap aon dowangka otaw na yamindug sang masaid kanilan na labi na masilaw yang mga dagom nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ansinyan yamalluk yang mga bobay aw syomojod silan sang lopa. Awgaid yagalaong kanilan idtong mga otaw, “Nanga yanap mayo yang bowi sang mga patay? ");
INSERT INTO kqew_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa da yan adi kay yabowi oman yan! Dumduma mayo yang pyaglaongan nan kamayo nang idto pa yan sa Jalil na ");
INSERT INTO kqew_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","laong nan, ‘Ako na Anak ng Manosiya, dait na adaun ako adto sang mga baradosa aw ilansang ako sa kros. Awgaid sang ikatoo na allaw amabowi oman ako.’ ” ");
INSERT INTO kqew_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ansinyan kyadumduman da ng mga bobay idtong pyaglaongan kanilan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na, pag-ori nilan sikun sang kobor, gyogod nilan yang kariko sinyan adto sang sampoo aw isa na mga sahabat ni Isa kipat yang kadaigan pa na mga kaupudanan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na, yang idto na mga bobay si Mariyam na taga Magdala, si Yowana aw si Mariyam na ina ni Yakob. Silan aw yang kadaigan pa na mga kaobayan yang yagagogod sinyan sang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Awgaid pagtoo ng mga sahabat na yagapataka gaid maglaong yang mga kaobayan, agaw wa silan apangintoo kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Awgaid si Pitros, yamindug yan aw daagan adto sang kobor. Pagdatung nan adto, sinilib yan sang kobor aw way kinita nan yatabiya sidtong sapot. Ansinyan yamori yan na yatingaa sidtong yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sinyan na allaw aon dowangka otaw na inindowan ni Isa na yagapaduug sang baryo ng Imaos na mga sampoo aw isa na kilomitro sikun sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sarta yanagpanaw silan, yanagbaaw silan makapantag sang kariko ng yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sang yanagbaaw-baaw silan, dyomood kanilan si Isa aw yaga-upud kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na, maskin kinita nilan yan, wa silan akilaa kanan kay maynang tyago kanilan daw sino yan. ");
INSERT INTO kqew_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ansinyan yagalaong si Isa kanilan, “Ono yang pyagabaawan mayo sarta yagapanaw kamo?” Na, yamondang silan pagpanaw aw sa parangay nilan yamakita na mabugat yang ginawa nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yang sangka otaw kanilan na pyagangaanan kang Kliyopas yagalaong kanan, “Na, sigoro ikaw gaid yang yadatung sa Awrosalam na wa akatigam sang yamaitabo sidtong yalabay na mga allaw.” ");
INSERT INTO kqew_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yaga-osip si Isa, “Nanga, ono kadi yang yamaitabo?” Tyomobag silan, “Yang yamaitabo kang Isa na taga Nasarit. Yan na otaw sambok na nabi sang pagtanaw ng Tohan aw yang kariko ng mga otaw, aw yagadan ng kabarakat ng Tohan yang maskin ono na pyaglaongan aw inangun nan. ");
INSERT INTO kqew_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Awgaid yang mga pangoo ng mga imam aw yang mga pangoo sang kanatun banwa yagasombong kanan adto sang gobirnador kay untak hokomon yan na patayun. Aw pyalansang yan sa kros. ");
INSERT INTO kqew_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Awgaid kami, pagtoo nami na yan yang pyagatagadan nami na magalowas sa bangsa Israil. Aw dogang pa sinyan, ikatoo da na allaw adon sikun sang pagkamatay nan. ");
INSERT INTO kqew_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aw aon mga bobay na kaupudanan nami na yagalaong kanami ng katingaan. Kay kyomadto silan sang kobor ni Isa ng masuum pa, ");
INSERT INTO kqew_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","awgaid wa da kono nilan akitaa yang patay na lawas ni Isa. Byomarik silan na yagagogod na aon kono kinita nilan na mga malaikat na yagalaong kanilan na bowi si Isa. ");
INSERT INTO kqew_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tapos, aon mga kaupudanan nami na kyomadto sang kobor aw kinita nilan yang mag-onawa ng pyagalaong ng mga bobay. Awgaid wa nilan akitaa si Isa.” ");
INSERT INTO kqew_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ansinyan yagalaong si Isa kanilan, “Mainay sagaw yang pagsabot mayo! Nanga mairapan kamo mangintoo sang kariko ng pyagalaong ng mga nabi? ");
INSERT INTO kqew_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Di ba yagalaong silan na yang Almasi dait magi ona ng kasikotan bago pa yan atagan ng dakowa na kabantog?” ");
INSERT INTO kqew_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ansinyan pyatigam nan kanilan yang kariko ng yakasorat sang Kitab makapantag kanan, sikun pa sang syorat ni Nabi Mosa sa Kitab Tawrat kipat yang kariko ng syorat ng kadaigan pa na mga nabi. ");
INSERT INTO kqew_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nang masaid da silan sang baryo na akadtonan nidtong dowangka otaw, yagasiling si Isa na magapanaos pa yan. ");
INSERT INTO kqew_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Awgaid dyumutan nilan yan aw laong nilan, “Pagpabilin saba adi kanami kay kasilum da aw masaid da somallup yang suga.” Idto sagaw, yagapabilin kanilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ansinyan sarta yanag-ingkod silan sang pagpangan, kyomamang yan ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapisang-pisang nan aw pangatagan kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na, sinyan na wakto maynang kya-abrian da yang kanilan mata aw kinilaa nilan si Isa. Awgaid sakadyap yawaa da yan sang pagtanaw nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ansinyan yanaglaong silan, “Agaw sagaw kadi magaan yang kanatun ginawa nang yapagbaaw yan kanatun sang daan aw pyatigam nan kanatun yang yakasorat sang Kitab.” ");
INSERT INTO kqew_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na, ansinyan dayon yamindug silan aw byomarik sa Awrosalam. Pagdatung nilan adto, yadatungan nilan yang sampoo aw isa na mga sahabat aw yang kadaigan pa na mga inagad nilan na yanagkatipon ");
INSERT INTO kqew_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","aw yanaglaong yang kariko nilan, “Bunna sagaw na yabowi oman si Isa kay yagapakita yan kang Simon!” ");
INSERT INTO kqew_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ansinyan gyogod oman nidtong dowangka otaw yang yamaitabo kanilan sang daan aw monono nilan yakilaa si Isa nang yagapisang-pisang yan ng pan. ");
INSERT INTO kqew_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sarta yagagogod pa sinyan idtong dowangka otaw, sakadyap iyan da paga-indug si Isa sang tunga nilan aw yagalaong yan kanilan, “Assalamo alaykom.” ");
INSERT INTO kqew_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Awgaid yakuga silan aw yangkalluk kay pagtoo nilan na arowak yang kinita nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Awgaid yagalaong si Isa kanilan, “Nanga yamarido kamo? Aw nanga yagadowa-dowa pa kamo? ");
INSERT INTO kqew_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tanawa mayo yang arima aw siki ko untak kitaun mayo na ako sagaw yani. Damdama mayo ako untak mayo katigaman na dili ako ng arowak. Kay yang arowak way pusa atawa onod, awgaid kinita sagaw mayo na ako aon lawas.” ");
INSERT INTO kqew_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paglaong nan sinyan, pyakita nan kanilan yang arima aw siki nan. ");
INSERT INTO kqew_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Awgaid di pa abay silan makapangintoo sabap sang bali na kasowat aw pagkatingaa nilan. Agaw yagalaong kanilan si Isa, “Aon pagkan mayo ansini?” ");
INSERT INTO kqew_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ansinyan yatagan nilan yan ng pyasagan na isda. ");
INSERT INTO kqew_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dyawat nan aw kana nan sa atobangan nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ansinyan yagalaong yan kanilan, “Yani kay yang pyagalaong ko kamayo nang yaga-upud pa ako kamayo na yang kariko ng yakasorat makapantag kanak dait matoman mag-onawa ng yakasorat sang Hokoman ni Nabi Mosa, yang syorat ng mga nabi aw yang yakasorat sang Kitab Jabor.” ");
INSERT INTO kqew_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ansinyan yabrian nan yang kanilan dumduman untak silan makasabot sang yakasorat sang Kitab. ");
INSERT INTO kqew_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yagalaong yan kanilan, “Yakasorat sang Kitab na dait na amagi yang Almasi ng kasikotan aw amatay. Awgaid sang ikatoo na allaw amabowi oman yan. ");
INSERT INTO kqew_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aw dait na ipayapat adto sang kariko ng mga bangsa adi sa babawan ng donya na sabap sang Almasi amponon ng Tohan yang sino-sino na magatawbat sang mga dosa nilan. Aw pagasogdan yang pagpayapat sinyan adi sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo yang magasaksi makapantag sinyan,” laong ni Isa, “kay yakakita kamo sang kariko ng yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aw ipadaa ko kamayo yang Nyawa ng Tohan na pyasad ng kanak Ama. Awgaid pagpabilin kamo adi sa Awrosalam sampay sidtong wakto na amadawat da mayo yang kabarakat sikun sa sorga.” ");
INSERT INTO kqew_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ansinyan pyaga-agad nan silan sikun sa Awrosalam sampay na dyomatung silan sang baryo ng Bitani. Ansan pyataas nan yang kanan arima aw pyangayowan nan silan ng kadyawan adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sarta yagapangayo-ngayo pa yan, pyataas yan adto sa sorga aw biniya da yan kanilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ansinyan syomojod silan aw pyagasambayangan nilan si Isa. Pagkatapos san yamori silan adto sa Awrosalam na dakowa yang kasowat nilan. ");
INSERT INTO kqew_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na, kada allaw adto da silan sang Baay ng Tohan aw pyoji nilan yang Tohan. Wassalam");
INSERT INTO kqew_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sang pukas nang wa pa akabaoy yang donya iyan da yang Pyaglaongan, aw yang Pyaglaongan iyan sang masaid sang Tohan, aw yang Pyaglaongan yang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sikun pa singaon iyan da yan sang masaid sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yang kariko ng mga butang yabaoy pina-agi kanan, aw way maskin ono na yabaoy kondi pina-agi kanan. ");
INSERT INTO kqew_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yang Pyaglaongan yang pyagasikunan ng kinabowi, aw yani na kinabowi mag-onawa ng allag na yaga-atag ng kapawa sang dumduman ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yani na allag yagasiga sang kadugguman, aw wa pakadaog sini yang kadugguman. ");
INSERT INTO kqew_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Adon, aon sambok na otaw na pyadaa ng Tohan. Yang ngaan nan si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Syogo yan ng Tohan untak magpatigam sang mga otaw daw sino yang allag kay untak yang kariko ng manosiya mangintoo sang allag sabap sang pagsaksi nan. ");
INSERT INTO kqew_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dili ni Yahiya yang allag, awgaid yakani yan untak magsaksi makapantag sang allag. ");
INSERT INTO kqew_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yang Pyaglaongan yang bunna na allag aw yakani yan sang donya untak ka-allagan yang dumduman ng kariko ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na, idi da yan sang donya. Awgaid maskin byaoy ng Tohan yang kariko ng mga butang pina-agi kanan, wa akilaa kanan yang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yakani yan sang kanan banwa, awgaid wa yan adawata ng kanan mga imamanwa. ");
INSERT INTO kqew_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Awgaid sino-sino yang yadawat aw yasarig kanan, yatagan nan silan ng kapatot na amabaoy ng mga anak ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yamabaoy silan na mga anak ng Tohan dili kay yaotaw silan sang pama-agi ng manosiya atawa sabap sang napso atawa pagbuut ng otaw. Awgaid yabaoy silan na mga anak ng Tohan kay yatagan nan silan ng bago na kinabowi. ");
INSERT INTO kqew_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yang Pyaglaongan yagapakaotaw adi sang donya aw yaga-uya adi kanatun. Labi na maoyanun yan aw aag bunna yang pyaglaongan nan. Kinita nami yang kanan pagkaTohan, yang pagkaTohan ng tongga na Anak na yagasikun sang Tohan na Ama. ");
INSERT INTO kqew_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Yahiya yagasaksi makapantag kanan aw yagapiyagit aw laong nan, “Yan agaw yang pyagalaong ko sidtong yagalaong ako kamayo na ‘Yang otaw na masonod kanak domatung labaw pa kanak kay iyan da yan nang wa pa ako akaotaw.’ ” ");
INSERT INTO kqew_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na, sabap sang dakowa na looy nan kita obos yakadawat sikun kanan ng dogang-dogang na kadyawan. ");
INSERT INTO kqew_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yang Hokoman yatag kanatun ng Tohan sabap kang Nabi Mosa. Awgaid yang tabang ng Tohan aw yang kabunnaan yadatung kanatun sabap kang Isa Almasi. ");
INSERT INTO kqew_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Way sino-sino na yakakita sang Allaho Taala. Awgaid yang Tongga nan na bunna na Tohan, yan yang yagapatigam kanatun daw sino yang Tohan na Ama kay iyan yan sang masaid kanan. ");
INSERT INTO kqew_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Adon, yang mga pangoo ng mga Yahodi adto sa Awrosalam yagasogo sang mga imam kipat yang mga katabang nilan na mga topo ni Libi na kadtonan nilan si Yahiya untak osipun nilan daw sino yan. ");
INSERT INTO kqew_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tyomobag yan kanilan ng way tago-tago aw yagalaong yan ng kabunnaan, laong nan “Dili ko yang Almasi.” ");
INSERT INTO kqew_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Na, sino kaw kadi?” yaga-osip silan. “Ikaw ba si Nabi Iliyas?” “Dili,” tyomobag si Yahiya. “Ikaw ba yang nabi na pyagatagadan natun na bangsa Israil?” yang osip nilan. “Dili,” tyomobag oman si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yagalaong oman silan, “Sino kaw kadi? Paglaongan kanami untak aon ikatobag nami sang mga otaw na yagasogo kanami. Ono yang ikapaglaong mo makapantag sang ginawa mo?” ");
INSERT INTO kqew_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tyomobag si Yahiya sobay sang syorat ni Nabi Isayas aw laong nan, “Ako yang otaw na yamanawag-tawag adto sa kamingawan na yagalaong, ‘Patorida mayo yang daan na agian ng Dato na Labi na Mabarakat.’ ” ");
INSERT INTO kqew_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, yang mga otaw na syogo ng mga Parisi ");
INSERT INTO kqew_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","yaga-osip oman kang Yahiya, laong nilan, “Nanga yagasogbo kaw ng mga otaw na dili mo kadi yang Almasi, ni Nabi Iliyas, kipat yang pyagatagadan natun na nabi?” ");
INSERT INTO kqew_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tyomobag si Yahiya, “Ako, tobig yang pyagasogbo ko kamayo. Awgaid sang tunga mayo aon sambok na otaw na wa mayo akilaa. ");
INSERT INTO kqew_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yan agaw yang masonod kanak domatung, awgaid maskin yang pag-obad ng liston ng sandalyas nan di dait kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na, yang kariko sinyan yamaitabo sang banwa ng Bitani adto sang dipag ng tobig ng Yordan na idto pagasogbo si Yahiya sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sonod na allaw kinita ni Yahiya na yagapaduug kanan si Isa. Ansinyan yagalaong si Yahiya sang mga otaw, “Tanawa mayo, yan kay yang karniro na yatag ng Tohan na ipakorban kay untak makamang yang dosa ng manosiya! ");
INSERT INTO kqew_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yan agaw yang pyagalaong ko sidtong yagalaong ako kamayo na ‘Aon otaw na masonod kanak domatung. Labaw pa yan kanak kay iyan da yan nang wa pa ako akaotaw.’ ");
INSERT INTO kqew_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Singaon maskin ako wa akatigam daw sino yang masonod kanak domatung. Awgaid yakani ako pagsogbo sang mga otaw sang tobig untak ipakilaa yan sang mga otaw na bangsa Israil.” ");
INSERT INTO kqew_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Adon, yani yang pagsaksi ni Yahiya, laong nan, “Kinita ko na yakunsad kang Isa yang Nyawa ng Tohan sikun sang langit sa porma ng malapati aw yagapabilin kanan. ");
INSERT INTO kqew_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Singaon wa pa ako akatigam daw sino yang masonod kanak domatung. Awgaid pyagalaong ako ng Tohan na yagasogo kanak pagsogbo sang mga otaw sang tobig, laong nan, ‘Aw kitaun mo yang otaw na yang Nyawa ng Tohan makunsad aw magapabilin kanan, yan agaw yang magasogbo sang mga otaw sang Nyawa ng Tohan.’ ");
INSERT INTO kqew_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na, bunna na kinita ko yan aw yagapangimunna ako na si Isa yang Anak ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sonod na allaw idto da oman si Yahiya sang dipag ng Yordan upud sang dowangka otaw na mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pagkita nan na yalabay si Isa, yagalaong yan, “Tanawa mayo, yan kay yang karniro na yatag ng Tohan untak ipakorban!” ");
INSERT INTO kqew_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagdungug sinyan ng dowangka inindowan ni Yahiya, yasonod silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ansinyan lyomingi si Isa aw kinita nan na yasonod silan kanan. Yosip nan silan, “Ono yang karim mayo?” Tyomobag silan, “Rabbi, wain kaw paga-uya?” Yang mana ng Rabbi, Goro. ");
INSERT INTO kqew_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tyomobag si Isa, “Bita da aw tanawa mayo.” Ansinyan yamagad silan kanan. Yang oras sidto alas kowatro ng ambong. Pagdatung nilan sang pyaga-uyaan nan, yagapabilin silan ansan sampay ng gabi. ");
INSERT INTO kqew_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na, yang isa sidtong dowangka otaw na yakadungug sang pyaglaongan ni Yahiya aw yamagad kang Isa si Andriyas na lomon ni Simon Pitros. ");
INSERT INTO kqew_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ansinyan yanap dayon ni Andriyas yang lomon nan aw paglaonga nan, “Kinita da nami yang Almasi.” Na, yang mana ng Almasi yang soltan na pyasad ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ansinyan dyaa nan si Simon adto kang Isa. Pyakatanawan yan ni Isa aw paglaonga nan, “Ikaw si Simon na anak ni Yahiya. Awgaid sikun adon Kipas da yang ngaan mo.” Yang ngaan na Kipas mag-onawa ng Pitros na yang mana nan bato. ");
INSERT INTO kqew_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sonod na allaw yagabuut si Isa komadto sang probinsya ng Jalil. Ansinyan kinita nan si Pilip aw paglaonga nan, “Unda, kay Pilip. Agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yani si Pilip taga Bitsayda mag-onawa ni Andriyas aw si Pitros. ");
INSERT INTO kqew_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ansinyan yanap ni Pilip si Natanyal aw pagkita nan, paglaonga nan, “Kinita da nami yang pyaga-isgotan ni Nabi Mosa sa Kitab Tawrat kipat oman yang kadaigan na mga nabi. Yan si Isa na anak ni Yosop na taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yagalaong si Natanyal, “Oy, aon bay madyaw na yagasikun sa Nasarit?” Tyomobag si Pilip, “Bita da aw tanawa.” ");
INSERT INTO kqew_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na, pagkita ni Isa na yagapaduug kanan si Natanyal, yagalaong yan, “Idi kay yang bunna na bangsa Israil na di maglimbong.” ");
INSERT INTO kqew_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yaga-osip si Natanyal, “Nanga yakilaa kaw kanak?” Tyomobag si Isa, “Sang wa pa kaw atawaga ni Pilip, kinita ta kaw sa saad ng kaoy na igira.” ");
INSERT INTO kqew_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yagalaong si Natanyal, “Kay Goro, ikaw agaw yang Anak ng Tohan! Ikaw yang soltan sa bangsa Israil!” ");
INSERT INTO kqew_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yagalaong si Isa, “Yagapangintoo da kaw kanak kay yagalaong ako na kinita ta kaw sa saad ng kaoy na igira? Na, labaw pa sinyan yang akitaun mo na mga katingaan.” ");
INSERT INTO kqew_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aw yagalaong pa si Isa kanilan, “Sa bunna-bunna na ipaglaong ko kamayo na sang madatung na mga allaw akitaun mayo na abri yang sorga aw yang mga malaikat ng Tohan panik-panaog adi kanak na Anak ng Manosiya.” ");
INSERT INTO kqew_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Paglabay ng dowang gabi, aon kawin sang banwa ng Kana sang probinsya ng Jalil. Iyan sang pakaradyaan ng kawin yang ina ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Isa aw yang mga inindowan nan imbitado oman. ");
INSERT INTO kqew_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Adon, pagka-orot da ng bino, yagalaong yang ina ni Isa kanan, “Waa day bino nilan.” ");
INSERT INTO kqew_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tyomobag si Isa aw laong nan, “Kay Ina, ayaw pagkarido. Ako da yang bahala san. Awgaid wa pa adatung yang osto na wakto.” ");
INSERT INTO kqew_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ansinyan yagalaong yang kanan ina sang mga sogowanun, “Inanga mayo maskin ono yang ipaglaong nan kamayo.” ");
INSERT INTO kqew_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, sang masaid kanilan aon unum ka banga na ininang sikun sang bato. Yang kada isa kalasakan ng 100 ka litro na tobig na gyamit ng mga Yahodi sang pagpangonaw ng arima bago koman. ");
INSERT INTO kqew_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ansinyan yagalaong si Isa sang mga sogowanun, “Ponowa mayo yang mga banga ng tobig.” Agaw pyono nilan taman sang baba. ");
INSERT INTO kqew_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkatapos sinyan yagalaong si Isa kanilan, “Pagsauk da kamo aw daa adto sang pangoo ng pakaradyaan.” Ansinyan ininang da nilan ");
INSERT INTO kqew_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aw itilawan ng pangoo ng pakaradyaan yang tobig na yabaoy ng bino. Wa yan akatigam daw wain pagasikun idtong bino, awgaid yang mga sogowanun na yagasauk ng tobig yamatigam. Agaw tyawag ng pangoo ng pakaradyaan yang usug na akawinun ");
INSERT INTO kqew_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aw paglaonga nan, “Kasagaran yang ona na ipa-inum sang mga bisita yang madyaw na bino. Aw madaig da yang ya-inum nilan, ipa-inum da kanilan yang bino na di abay madyaw. Awgaid ikaw, pyamaori mo kadi yang tanto madyaw na bino.” ");
INSERT INTO kqew_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na, yani na katingaan na ininang ni Isa adto sang banwa ng Kana na sakop ng Jalil, idto yang ona na tanda na ininang nan. Sang mayninyan na pama-agi pyakita nan yang kanan pagkaTohan, aw yagapangintoo kanan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatapos sinyan kyomadto si Isa sang longsod ng Kapirnaom upud sang kanan ina, yang mga lomon nan na usug kipat yang mga inindowan nan. Aw yanagpabilin silan adto ng pilang allaw. ");
INSERT INTO kqew_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ansinyan masaid da yang pakaradyaan ng mga Yahodi na tyawag ng Pakaradyaan ng Paglabay. Agaw kyomadto silan ni Isa sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdatung nilan ansan, kyomadto si Isa sang Baay ng Tohan. Sang pamanag sinyan aon kinita nan na mga otaw na yanagbarigya ng mga baka, karniro aw malapati. Aon oman mga otaw na yanag-ingkod sang lamisa aw yanagkambiyo ng sapi. ");
INSERT INTO kqew_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagkita nan sinyan, kyomamang yan ng mga lobid aw ininang nan ng babadas aw pyalogwa nan yang kariko ng mga karniro aw baka sikun sang Baay ng Tohan. Pyagatayak nan yang sapi ng mga yanagkambiyo aw byariskad nan yang mga lamisa nilan. ");
INSERT INTO kqew_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pyagalaong nan yang mga yanagbarigya ng malapati, “Daa da mayo yan adto sa logwa! Ayaw mayo inanga ng palengke yang Baay ng kanak Ama!” ");
INSERT INTO kqew_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ansinyan kyadumduman ng mga inindowan nan yang yakasorat sang Kitab na yagalaong, “Dakowa yang kallini ko sang Baay mo, ya Tohan, maskin idto yang amakabogto ng ginawa ko.” ");
INSERT INTO kqew_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ansinyan yosip yan ng mga pangoo ng mga Yahodi, laong nilan, “Ono yang katingaan na ipakita mo kanami silbi tanda na aon kammo kapatot sang pag-inang sini na mga butang?” ");
INSERT INTO kqew_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tyomobag si Isa, “Gubaa mayo yani na Baay ng Tohan aw apa-indugun ko oman yan sa suud ng toong allaw.” ");
INSERT INTO kqew_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Astaga!” yagalaong yang mga pangoo. “Yang pag-inang sini na Baay ng Tohan 46 ka toig! Apa-indugun da mo oman sa suud ng toong allaw?” ");
INSERT INTO kqew_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Awgaid yang Baay ng Tohan na pyagalaong ni Isa dili nidtong Baay ng Tohan sa Awrosalam, awgaid yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Agaw, pagkatapos mabowi oman ni Isa, kyadumduman ng mga inindowan nan inyan na pyaglaongan ni Isa. Aw ansinyan pyangintowan nilan yang yakasorat sa Kitab kipat yang pyaglaongan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, sarta adto sa Awrosalam si Isa sang wakto ng Pakaradyaan ng Paglabay, madaig yang mga otaw na yagapangintoo kanan sabap ng kinita nilan yang mga katingaan na ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Awgaid way pagsarig ni Isa sang pagpangintoo nilan kanan kay kyatigaman nan yang kinaiya ng kariko ng otaw. ");
INSERT INTO kqew_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Di kinaanglan na aon magalaong kanan daw ono yang iyan sa pangatayan ng manosiya kay kyatigaman da nan. ");
INSERT INTO kqew_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Adon, aon sangka otaw na pangoo ng mga Yahodi aw mimbro ng mga Parisi na pyagangaanan kang Nikodimos. ");
INSERT INTO kqew_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sanggabi sinyan kyomadto yan kang Isa aw yagalaong kanan, “Kay Goro, yamatigam kami na ikaw sambok na magiindoway na pyadaa ng Tohan. Kay way otaw na maka-inang ng mga katingaan na mag-onawa ng ininang mo yatabiya iyan kanan yang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kammo na di amasakop yang otaw sang pyagdatowan ng Tohan kong di yan amaotaw oman.” ");
INSERT INTO kqew_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yaga-osip si Nikodimos, “Mapakay ba na amaotaw oman yang otaw na aon day idad? Di da kowaw yan makabarik adto suud ng dubdub ng kanan ina untak magpakaotaw oman.” ");
INSERT INTO kqew_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kammo na aon dowa na pama-agi ng pagkaotaw. Yang otaw di amasakop sang pyagdatowan ng Tohan yatabiya amaotaw yan pina-agi sang tobig aw pina-agi oman sang Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kay kong amaotaw yang otaw sang pama-agi ng manosiya, yang amadawat nan yang kinabowi na yagasikun sang manosiya. Awgaid kong amaotaw yan pina-agi sang Nyawa ng Tohan, yang amadawat nan yang kinabowi na yagasikun sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ayaw pagkatingaa sang pyagalaong ko na yang kariko mayo dait na amaotaw oman. ");
INSERT INTO kqew_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yang opamaan sini yang samut. Yang samut yaga-oyop abir wain. Yadungug natun yang oni nan, awgaid wa natun akatigami daw wain yan pagasikun atawa wain yan magapaduug. Mag-onawa sinyan yang otaw na amaotaw oman pina-agi sang Nyawa ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Maonono kadi yan?” yaga-osip si Nikodimos. ");
INSERT INTO kqew_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tyomobag si Isa, “Astaga! Wa kaw akatigam maskin bantoganun kaw na magiindoway ng bangsa Israil? ");
INSERT INTO kqew_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sa bunna-bunna na ipaglaong ko kammo na yang kyatigaman nami, idto yang pyagalaong nami, aw yang kinita nami idto yang pyangimunnaan nami. Awgaid di kamo mangintoo sang pyagalaong nami. ");
INSERT INTO kqew_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kong di kamo mangintoo sang pyagalaong ko makapantag sang mga butang adi sang donya, na, monono da kamo mangintoo sang ipaglaong ko makapantag sang mga butang adto sa sorga? ");
INSERT INTO kqew_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Way maskin sino na yakadto sang sorga yatabiya ako na Anak ng Manosiya kay yagasikun ako sang sorga. ");
INSERT INTO kqew_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Singaong ona pyataas ni Nabi Mosa yang od na bronsi adto sa diserto. Mag-onawa sinyan dait na apataasun oman ako na Anak ng Manosiya ");
INSERT INTO kqew_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kay untak sino-sino yang amangintoo kanak aka-aonan ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sabap sang dakowa na looy ng Tohan sang manosiya yatag nan yang tongga na Anak nan kay untak sino-sino yang amangintoo kanan di amanarka, awgaid aka-aonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay pyadaa ng Tohan yang Anak nan adi sang donya dili untak hokomon yang manosiya na asiksaun awgaid untak malowas silan sabap kanan. ");
INSERT INTO kqew_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yang otaw na yagapangintoo sang Anak ng Tohan, di hokomon na asiksaun. Awgaid yang otaw na wa apangintoo kanan, yokoman da kay wa yan apangintoo sang Tongga ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yakani sang donya yang Anak ng Tohan na mag-onawa ng allag, awgaid pyalabi ng mga otaw yang kadugguman kay maat yang mga ininang nilan. Idto yang sabap nanga yokoman da silan. ");
INSERT INTO kqew_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yang otaw na yaga-inang ng maat di mallini sang kapawa. Di yan domood sang kapawa kay di nan karim na makita yang maat na ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Awgaid yang otaw na somonod sang kabunnaan domood sang kapawa untak makita na yang Tohan yang pyagasikunan ng madyaw na ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos sinyan kyomadto si Isa aw yang mga inindowan nan sang probinsya ng Yahodiya. Yagapabilin yan adto ng tagbi na panahon upud sang mga inindowan nan aw yagasogbo silan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Yahiya oman yagasogbo sang mga otaw adto sang banwa ng Inon na masaid sang banwa ng Salim kay madaig yang tobig ansan. Yabay komadto kanan yang mga otaw untak magpasogbo. ");
INSERT INTO kqew_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sidto na wakto wa pa apirisowa si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ansinyan yanaglalis yang pilangka otaw na inindowan ni Yahiya aw yang sambok na Yahodi makapantag sang kabatasanan ng pagsogbo. ");
INSERT INTO kqew_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Agaw kyomadto silan kang Yahiya aw laong nilan, “Kay Goro, kyadumduman ba mo idtong otaw na kaupudanan mo adto sang dipag ng tobig ng Yordan, ingaong pyakilaa mo sang mga otaw? Na, yagasogbo da yan adon sang mga otaw aw madaig silan na yakadto kanan!” ");
INSERT INTO kqew_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tyomobag si Yahiya, “Way ma-inang ng otaw kong dili ng pagbuut ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo yang yakasaksi sang pyagalaong ko na dili ko yang Almasi. Syogo gaid ako na ama-ona kanan untak andamun ko yang mga otaw sang pagdatung nan. ");
INSERT INTO kqew_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Atagan ta kamo ng opamaan. Sang kawin, yang bobay na apangasawaun para gaid sang usug na akawinun. Awgaid yang amigo ng usug na yatabang sang pakaradyaan ng kawin, yamasowat yan pagdungug nan sang tingug ng usug na akawinun. Mag-onawa sinyan dakowa da adon yang kasowat ko kay dyomatung da yang Almasi. ");
INSERT INTO kqew_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dait gaid na magakadakowa yang dungug nan aw magakatagbi yang kanak dungug.” ");
INSERT INTO kqew_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yang yagasikun sang sorga labaw sang kariko. Awgaid yang yagasikun sang donya, yang kyatigaman nan kadodonya gaid kay taga donya yan. Awgaid yang yagasikun sang sorga, labaw yan sang kariko. ");
INSERT INTO kqew_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pyatigam nan yang makapantag sang kinita aw dyungug nan adto sa sorga, awgaid yang mga otaw wa apangintoo sang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Awgaid idtong mga otaw na yagapangintoo sang pyaglaongan nan yagapangimunna na aag bunna yang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay yang syogo ng Tohan, way lain na pyatigam nan yatabiya yang pyaglaongan ng Tohan kay iyan kanan yang kariko ng kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pyakadakowa ng Ama yang kanan Anak aw yatag nan kanan yang kapatot makapantag sang kariko. ");
INSERT INTO kqew_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sino-sino yang amangintoo sang Anak ng Tohan aka-aonan ng kinabowi na way kataposan. Awgaid sino-sino yang di amangagad sang Anak ng Tohan, di yan atagan ng kinabowi awgaid magapabilin kanan yang kadaman ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Adon, yadungug ng mga Parisi na mas madaig yang mga inindowan ni Isa kay kang Yahiya kipat oman yang mga otaw na syogbowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Awgaid sang kabunnaan, dili ni Isa yang yagasogbo sang mga otaw awgaid yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkatigam ni Isa na idto yang dyungug ng mga Parisi, pyomanaw yan sikun sa Yahodiya upud sang mga inindowan nan aw byomarik silan sang probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sang pagkadto nilan sa Jalil kinaanglan na amagi silan sang probinsya ng Samariya. ");
INSERT INTO kqew_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pag-agi nilan sang Samariya, dyomatung silan sang sambok na longsod na pyagangaanan sang Sikar na masaid sang lopa na yatag singaon ni Yakob sang anak nan na si Yosop. ");
INSERT INTO kqew_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ansan na lopa aon sambok na balon na pyakotkot ni Yakob. Aw sabap ng kyapoy si Isa ng pagpanaw yamingkod yan sang masaid sang balon. Sidto na wakto apit da alas dose yang suga. ");
INSERT INTO kqew_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yang mga inindowan ni Isa pyomanaos sang longsod kay magabili ng pagkan. Aw sarta yaga-ingkod si Isa sang balon, dyomatung yang sambok na bobay na taga Samariya kay masagub. Yagalaong si Isa kanan, “Kay Bi, tabiya kammo, pa-inuma ako.” ");
INSERT INTO kqew_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tyomobag yang bobay, “Yahodi kaw aw ako taga Samariya. Nanga yagapangayo kaw ng ma-inum adi kanak?” Maynini yang pyagalaong ng bobay kay di mag-upud yang mga Yahodi sang mga taga Samariya. ");
INSERT INTO kqew_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tyomobag si Isa, “Aw yamatigam pa kaw daw ono yang ika-atag ng Tohan aw sino ako na yagapangayo kammo ng tobig, ikaw da kowaw yang amangayo kanak aw atagan ta kaw ng tobig na maka-atag ng kinabowi.” ");
INSERT INTO kqew_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Kay Sir,” yagalaong yang bobay, “waa sabay pagasauk mo aw maum yani na balon. Wain kaw makamang ng tobig na maka-atag ng kinabowi? ");
INSERT INTO kqew_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labaw pa kaw sang kanami ompo na si Yakob na yag-atag kanami sini na balon? Si Yakob aw yang mga anak nan kipat yang mga kaayupan nan yaminum ng tobig sikun sini na balon.” ");
INSERT INTO kqew_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tyomobag si Isa, “Sino-sino yang minum sini na tobig amangga oman. ");
INSERT INTO kqew_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Awgaid sino-sino yang minum ng tobig na i-atag ko kanan, di da yan amangga. Kay yang tobig na i-atag ko kanan amabaoy ng bogak sa suud ng pangatayan nan na maga-atag kanan ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ansinyan yagalaong yang bobay kanan, “Kay Sir, atagi ako sini na tobig na pyagalaong mo kay untak di da ako amangga aw di da ako kinaanglan magbarik-barik adi untak somagub.” ");
INSERT INTO kqew_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yagalaong si Isa, “Panaw da, kadtoni yang kammo bana aw barik adi.” ");
INSERT INTO kqew_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tyomobag yang bobay, “Waa sabay bana ko.” Yagalaong si Isa, “Bunna yang pyagalaong mo na way bana mo. ");
INSERT INTO kqew_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kay lima pangka otaw yang yamabana da mo aw yang usug na kaupud mo adon dili ng bana mo. Agaw bunna yang pyagalaong mo.” ");
INSERT INTO kqew_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yagalaong yang bobay, “Kay Sir, nabi kaw kadi! ");
INSERT INTO kqew_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aon gao ipaglaong ko. Yang kanami mga kaompowan yagasambayang adi siding butay. Awgaid kamo na mga Yahodi yagalaong na adto gaid sa Awrosalam dait magsambayang sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yagalaong si Isa, “Kay Bi, pagtoo sang ipaglaong ko. Madatung yang wakto na asambayangan mayo yang Tohan na Ama dili adi siding butay ni adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamo na taga Samariya, wa mayo akilaa yang Tohan na pyagasambayangan mayo. Awgaid kami na mga Yahodi, kinilaa nami yang pyagasambayangan nami kay yang manlolowas magasikun sang tribo ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Awgaid madatung yang wakto aw ini da adon, na magasambayang yang mga otaw sang Tohan na Ama na iklas yang pangatayan nilan. Magasambayang silan sikun sang pangatayan aw sobay sang kabunnaan. Yani yang bunna na pagsambayang na kyallinian ng Tohan na Ama. ");
INSERT INTO kqew_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yang Tohan nyawa, agaw sino-sino yang magasambayang kanan dait na sikun sa pangatayan aw sobay sang kabunnaan yang pagsambayang nan.” ");
INSERT INTO kqew_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yagalaong yang bobay, “Yamatigam ako na madatung yang Almasi. Aw pagdatung nan, ipatigam nan kanatun yang kariko ng mga butang.” ");
INSERT INTO kqew_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yagalaong si Isa, “Ako na yapagbaaw kammo, ako ingidto.” ");
INSERT INTO kqew_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sidto na wakto byomarik yang mga inindowan ni Isa aw yatingaa silan sang pagkita nilan na yapagbaaw si Isa sang sambok na bobay. Awgaid wa silan paga-osip daw ono yang toyo ng bobay atawa nanga yapagbaaw kanan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ansinyan biniyaan ng bobay yang kanan banga aw byomarik sang longsod. Pagdatung nan adto, pyagalaong nan yang mga otaw ansan, laong nan, ");
INSERT INTO kqew_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bita da aw tanawa mayo yang otaw na yamatigam sang kariko ng ininang ko. Basin yan yang Almasi.” ");
INSERT INTO kqew_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Agaw lyomogwa silan sang longsod aw yagapaduug silan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sarta wa pa adatung yang mga otaw, yabay maglaong kang Isa yang mga inindowan nan, “Kay Goro, kan da.” ");
INSERT INTO kqew_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Awgaid yagalaong yan kanilan, “Aon kanak pagkan na wa mayo akatigami.” ");
INSERT INTO kqew_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sabap sinyan yanag-inosipay yang mga inindowan nan, laong nilan, “Aon bay yagadaa kanan ng pagkan?” ");
INSERT INTO kqew_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“Yani yang kanak pagkan,” laong ni Isa, “na inangun ko yang karim ng Tohan na yagapadaa kanak aw taposon ko yang gawbuk na pya-inang nan kanak. ");
INSERT INTO kqew_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Di ba yagalaong kamo na opat ka bowan koman bago pa yang paggani? Awgaid pagalaongon ta kamo na ini da yang wakto ng paggani. Tanawa saba mayo yang mga otaw na yagapaduug adi kanak. Mag-onawa silan sang omay na ya-ilag da aw mapakay ganiun. Agaw di amadogay amangintoo da silan kanak. ");
INSERT INTO kqew_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yang mga manggagani aon adawatun na baras, aw yang mga otaw na dyaa nilan adi kanak atagan ng kinabowi na way kataposan. Agaw, idtong magpupugas aw idtong manggagani, magakasowat silan dowa. ");
INSERT INTO kqew_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bunna yani na pyaglaongan mayo na yagalaong, ‘Aon magapugas aw aon oman magagani.’ ");
INSERT INTO kqew_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Syogo ta kamo untak ganiun mayo yang wa mayo atanuma. Tuna na mga otaw yang yagagawbuk, aw adon aon kabainan mayo sang pyagapagodan nilan.” ");
INSERT INTO kqew_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, madaig yang mga taga Samariya ansidtong longsod na yagapangintoo kang Isa sabap sang pyagalaong ng bobay na kyatigaman ni Isa yang kariko ng ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Agaw, pagdatung ng mga taga Samariya adto kang Isa, dyumutan nilan yan na magapabilin pa adto kanilan. Aw yagapabilin pa si Isa ansan na longsod ng dowang allaw. ");
INSERT INTO kqew_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Adon, mas madaig pa yang yagapangintoo kang Isa sabap sang pyaga-indo nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aw yagalaong silan sidtong bobay, “Yagapangintoo da kami kang Isa dili gaid ng sabap sang pyagalaong mo kanami, awgaid sabap ng kami mismo yang yakadungug sang pyaga-indo nan aw yamatigam da kami na yan agaw yang manlolowas ng manosiya.” ");
INSERT INTO kqew_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Paglabay ng dowang allaw, pyomanaw silan Isa sikun sa Samariya aw kyomadto silan sang probinsya ng Jalil. ");
INSERT INTO kqew_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Awgaid yagalaong si Isa singaon na dili addatan yang sambok na nabi ng mga imamanwa nan. ");
INSERT INTO kqew_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na, pagdatung ni Isa sa Jalil, madyaw yang pagdawat kanan ng mga otaw ansan kay yakatambong silan sang Pakaradyaan ng Paglabay adto sa Awrosalam aw kinita nilan adto yang kariko ng ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ansinyan byomarik silan Isa sang banwa ng Kana na sakop ng Jalil, yang banwa daw wain nan inanga yang bino sikun sang tobig. Ansidto aon sambok na opisyal ng soltan na yang anak nan na usug yamasakit adto sang longsod ng Kapirnaom. ");
INSERT INTO kqew_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagdungug ng opisyal na byomarik si Isa sa Jalil sikun sa Yahodiya, kyomadto yan kang Isa aw yaga-angyo kanan na makadto sa Kapirnaom kay untak pakadyawon nan yang anak nan na yagapinal da. ");
INSERT INTO kqew_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yagalaong si Isa kanan, “Aw di kamo makakita ng mga tanda atawa mga katingaan, di kamo amangintoo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yagalaong yang opisyal, “Kay Sir, tabiya kammo, agad kanak sarta bowi pa yang anak ko.” ");
INSERT INTO kqew_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tyomobag kanan si Isa, “Ori da, kay madyaw da yang anak mo.” Yagapangintoo yang opisyal sang pyaglaongan ni Isa aw ori dayon yan. ");
INSERT INTO kqew_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na, sarta iyan pa yan sang daan, syongon yan ng mga sogowanun nan na yagalaong, “Madyaw da yang anak mo!” ");
INSERT INTO kqew_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Agaw yosip nan silan daw ono na wakto na yamadyaw yang anak nan. Laong nilan, “Kagabi pa, mga ala ona ng ambong yawaa yang kalintora nan.” ");
INSERT INTO kqew_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ansinyan kyadumduman ng ama na idto yang wakto na pyagalaong yan ni Isa na “Madyaw da yang anak mo.” Sabap sinyan yagapangintoo yan kang Isa kipat yang kariko ng mga sakop sang kanan baay. ");
INSERT INTO kqew_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, yani yang ikadowa na katingaan na ininang ni Isa adto sa Jalil sang pagbarik nan ansan sikun sa Yahodiya. ");
INSERT INTO kqew_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wa akadogay sinyan kyomadto si Isa sa Awrosalam kay aon pakaradyaan ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Adto sa Awrosalam sang masaid sang powertaan na tyawag ng Powertaan ng Karniro aon sambok na sogbowanan na tyawag sang Hibrani ng Bitisda. Linibotan yan na sogbowanan ng limangka pagasilongan ");
INSERT INTO kqew_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","aw madaig yang mga masakitun na yakowang ansan na mag-onawa ng mga bota, mga pilay kipat yang mga sadi. Yanagtagad silan ng pagginuk ng tobig ");
INSERT INTO kqew_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kay aon wakto na makunsad yang malaikat ng Tohan sang sogbowanan aw kotawon nan yang tobig. Yang ama-ona pagpanaog sang tobig pagkatapos makotaw amadyaw sikun sang maskin ono na sakit nan. ");
INSERT INTO kqew_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, aon sangka otaw ansan na yamasakit sa suud ng 38 ka toig. ");
INSERT INTO kqew_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kinita yan ni Isa na yakowang ansan aw kyatigaman nan na madogay da yang pagkasakit nan. Agaw yosip nan yang otaw, “Karim mo na amadyaw kaw?” ");
INSERT INTO kqew_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tyomobag yang masakitun, “Uu, kay Sir, karim ko. Awgaid way magadaa kanak adto sang tobig pagkotaw da. Paduug pa gaid ako, aon day yama-ona kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yagalaong kanan si Isa, “Pag-indug! Kamanga yang kammo kamun aw panaw!” ");
INSERT INTO kqew_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ansinyan yamadyaw dayon yang otaw. Kyamang nan yang kamun nan aw panaw. Ya-inang yani ng Sabado na Allaw ng Pagpatana ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Agaw yagalaong yang mga pangoo ng mga Yahodi sidtong otaw na pyakadyaw, “Allaw ng Pagpatana adon. Sopak sang Hokoman na yagadaa kaw ng kammo kamun.” ");
INSERT INTO kqew_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Awgaid tyomobag yang otaw, “Yang otaw na yagapakadyaw kanak yagalaong na kamangun ko yang kanak kamun aw panaw.” ");
INSERT INTO kqew_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yaga-osip silan kanan, “Sino kadi yang yagasogo kammo na kamangun mo yang kammo kamun aw panaw?” ");
INSERT INTO kqew_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Awgaid wa akatigam yang otaw daw sino yang yagapakadyaw kanan kay pyomanaw dayon si Isa sarta madaig yang mga otaw ansan. ");
INSERT INTO kqew_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wa akadogay sinyan kinita ni Isa ingaong otaw sa suud ng Baay ng Tohan aw paglaonga nan, “Tanawa, madyaw da kaw adon. Ayaw da pagpakadosa kay untak di kaw adatungan ng labi pa na kasikot.” ");
INSERT INTO kqew_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ansinyan pyomanaw idtong otaw aw paglaonga nan yang mga pangoo ng mga Yahodi na si Isa yang yagapakadyaw kanan. ");
INSERT INTO kqew_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sabap sinyan yagasogod da yang pagpasikot ng mga pangoo kang Isa kay pyakadyaw nan yang masakitun sang Allaw ng Pagpatana. ");
INSERT INTO kqew_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Awgaid yagalaong kanilan si Isa, “Yang kanak Ama yabay maggawbuk sampay adon. Agaw ako oman yagagawbuk.” ");
INSERT INTO kqew_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sabap sinyan na pyaglaongan ni Isa lyomabi pa yang karim ng mga pangoo na apatayun yan. Kay dili gaid ng yasopak yan sang sogowan na di mapakay maggawbuk sang Allaw ng Pagpatana, awgaid yagalaong pa yan na yang Tohan yang kanan Ama, na mana nan na mag-onawa yan sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Idto sagaw, yagalaong si Isa kanilan, “Sa bunna-bunna na ipaglaong ko kamayo na yang Anak way ma-inang ng sarili nan, awgaid yani gaid yang ininang nan daw ono yang kinita nan na ininang ng Ama. Kay maskin ono yang ininang ng Ama, idto oman yang inangun ng Anak. ");
INSERT INTO kqew_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pyakadakowa yang Anak ng Ama, agaw pyakita nan kanan yang kariko ng ininang nan. Sang madatung na mga allaw aon pay ipa-inang nan kanan na labaw pa sang ininang nan adon aw amangkatingaa da kamo. ");
INSERT INTO kqew_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yang Ama, abowiun nan yang mga patay aw atagan nan silan ng kinabowi. Mag-onawa oman sinyan yang Anak kay atagan nan ng kinabowi yang maskin sino na karim nan atagan. ");
INSERT INTO kqew_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yang Ama di oman magahokom sang maskin sino kay yatag nan sang Anak yang kapatot ng paghokom ");
INSERT INTO kqew_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","untak addatan yang Anak ng kariko ng mga otaw mag-onawa ng pag-addat nilan sang Ama. Sino-sino yang way addat sang Anak, way oman addat sang Ama na yagasogo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang yamaningug sang pyaglaongan ko aw yagapangintoo sang yagasogo kanak, kya-aonan ng kinabowi na way kataposan. Di da yan hokomon na asiksaun kay yalowas da yan sikun sang kamatay aw kya-aonan da yan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sa bunna-bunna na ipaglaong ko kamayo na madatung yang wakto aw ini da adon, na yang mga otaw na maynang patay sabap sang mga dosa nilan makadungug sang sowara ko na Anak ng Tohan. Aw sino-sino yang amangintoo sang pyagadungug nan aka-aonan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yang kanak Ama yang pyagasikunan ng kinabowi. Mag-onawa oman sinyan ako na Anak nan kay yatagan nan ako ng kapatot ng pagpangatag ng kinabowi. ");
INSERT INTO kqew_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aw yatagan oman nan ako ng kapatot paghokom sang manosiya kay ako yang Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ayaw kamo pagkatingaa sini na pyagalaong ko kay madatung yang wakto na yang kariko ng mga patay makadungug sang sowara ko, ");
INSERT INTO kqew_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aw pagdungug nilan sinyan, malogwa silan sikun sang mga kobor. Yang mga otaw na madyaw yang ininang, amabowi oman aw atagan silan ng kinabowi na way kataposan. Yang mga otaw na maat yang ininang, amabowi oman awgaid hokomon silan na asiksaun. ");
INSERT INTO kqew_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Way ma-inang ko kong ako gaid. Yang paghokom ko masobay sang pyagalaong kanak ng Tohan. Agaw matorid yang paghokom ko kay dili ng kanak karim yang apangagadan ko kondi yang karim ng yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kong ako gaid yang magasaksi makapantag sang ginawa ko, makadoda kamo sang pyaglaongan ko. ");
INSERT INTO kqew_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Awgaid aon tuna na yagasaksi makapantag kanak, aw yamatigam ako na bunna yang pyaglaongan nan makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aon syogo mayo na mga otaw adto kang Yahiya aw yagalaong yan ng kabunnaan makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Di ko kinaanglan yang pagsaksi ng otaw, awgaid pyagalaong ta kamo makapantag kang Yahiya untak malowas kamo. ");
INSERT INTO kqew_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Yahiya mag-onawa ng ilawan na yagasiga aw yaga-atag ng kapawa, aw yamangkasowat kamo ng tagbi na panahon sabap sang kapawa na yatag nan kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Awgaid aon yagasaksi makapantag kanak na labaw pa kang Yahiya. Idto yang mga inang ko na pya-inang kanak ng Ama. Idto oman yang yagapangimunna na syogo nan ako. ");
INSERT INTO kqew_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aw yang Ama na yagasogo kanak yagasaksi oman makapantag kanak. Awgaid sikun pa singaong ona wa pa kamo pakadungug ng sowara nan aw wa kamo akita kanan. ");
INSERT INTO kqew_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aw waa sang pangatayan mayo yang pyaglaongan nan kay wa kamo apangintoo kanak na syogo nan. ");
INSERT INTO kqew_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yabay kamo mangadi ng Kitab kay yagadumdum kamo na sabap sinyan amakadawat kamo ng kinabowi na way kataposan. Aw idto sagaw, yang Kitab yagasaksi makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Awgaid di kamo mangintoo kanak maskin ako da yang maka-atag kamayo ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Di ako manganap ng pagbantog ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Awgaid kinilaa ta kamo aw yamatigam ako na wa mayo apakadakowaa yang Tohan sang kamayo pangatayan. ");
INSERT INTO kqew_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yakani ako kay yatagan ako ng kapatot ng kanak Ama, awgaid di mayo ako adawatun. Awgaid kong aon makani sang sarili nan na kapatot, na, adawatun da mayo. ");
INSERT INTO kqew_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kyallinian mayo na abantogon kamo ng kapag-onawa mayo. Awgaid wa kamo apangalingkamot na abantogon kamo ng bunna na Tohan. Agaw sagaw di kamo makapangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Na, ayaw kamo pagdumdum na ako yang magasombong kamayo adto sang Ama. Yang magasombong kamayo si Nabi Mosa na syarigan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kay kong bunna na pyangintowan mayo yang syorat ni Nabi Mosa, yagapangintoo gao kamo kanak kay syorat nan sang Kitab yang makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Awgaid sabap ng wa kamo apangintoo sang syorat ni Nabi Mosa, di oman kamo amangintoo sang pyaglaongan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkatapos sinyan tyomaripag silan ni Isa sang Linaw ng Jalil na tyawag oman ng Linaw ng Tibiriyas. ");
INSERT INTO kqew_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Madaig yang mga otaw na yasonod kanilan kay kinita nilan yang mga katingaan na ininang ni Isa na mag-onawa ng pagpakadyaw ng mga masakitun. ");
INSERT INTO kqew_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ansinyan syomakat si Isa aw yang mga inindowan nan sang sambok na butay aw yamingkod silan. ");
INSERT INTO kqew_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sidto na wakto masaid da yang pakaradyaan ng mga Yahodi na tyawag ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na, pagtanaw ni Isa, kinita nan na madaig yang mga otaw na yagapaduug kanan. Agaw yosip nan si Pilip, “Wain kita makabili ng pagkan untak makakan yani na mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yani yang pyagalaong ni Isa kay untak tistingan nan si Pilip daw ono yang atobag nan. Awgaid kyatigaman da ni Isa daw ono yang inangun nan. ");
INSERT INTO kqew_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tyomobag si Pilip, “Maskin yang soweldo ng sangka otaw sa suud ng waombowan yang pagabili natun ng pagkan, kolang pa yan sang kadaig sini na mga otaw kay untak makakan ng maskin tagbibis gaid sang kada isa kanilan.” ");
INSERT INTO kqew_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ansinyan yagalaong si Andriyas na lomon ni Simon Pitros, na isa oman sang mga inindowan ni Isa, ");
INSERT INTO kqew_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aon disini sambok na isu na aon daa nan na limambok na pan aw dowambok na isda. Awgaid onoon da ta yani sang kadaig sini na mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ansinyan yagalaong si Isa sang mga inindowan nan, “Pa-ingkoda mayo yang mga otaw.” Na, madaig yang sagbut sidtong logar, agaw yamingkod yang mga otaw sang kasagbutan. Yang kadaig ng kausugan 5000 na way labot yang kaobayan aw yang kamangaisuan. ");
INSERT INTO kqew_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ansinyan kyamang ni Isa yang pan aw panginsokor sang Tohan. Pagkatapos san pyangatag nan yang pan sang mga otaw na yanag-ingkod ansan. Maynini oman yang ininang nan sang isda. Aw yang kariko ng mga otaw yakakan kotob ng gosto nilan. ");
INSERT INTO kqew_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkatapos nilan koman, yagalaong si Isa sang mga inindowan nan, “Tipona mayo yang yamasama na pagkan untak way masayang.” ");
INSERT INTO kqew_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na, tinipon da nilan aw sikun sang limambok na pan na kyan ng mga otaw sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqew_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na, pagkita ng mga otaw sinyan na katingaan na ininang ni Isa, yanaglaong silan, “Sa way dowa-dowa, yan agaw yang nabi na pyasad singaong ona na makadi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yamatigam si Isa na madari da domood kanan yang mga otaw kay untak pugusun yan na ma-inang ng soltan nilan. Agaw pyomanaw dayon yan aw syomakat sang butay ng sangka otaw da nan. ");
INSERT INTO kqew_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pagkasilum sinyan kyomadto yang mga inindowan ni Isa sang baybay ");
INSERT INTO kqew_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aw syomakay sang bangka untak bomarik silan sang longsod ng Kapirnaom. Nang gabi da aw wa pa adatung si Isa, ");
INSERT INTO kqew_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","yagataripag silan sang linaw. Ansinyan yamoyop yang makusug na samut aw yagakadakowa yang mga baud. ");
INSERT INTO kqew_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na, pagbugsay da nilan ng lima atawa unum ka kilomitro, kinita nilan si Isa na yagapanaw sa babaw ng tobig aw yagapaduug kanilan. Aw yasaot silan ng alluk. ");
INSERT INTO kqew_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Awgaid yagalaong si Isa kanilan, “Ayaw kamo pagkalluk. Ako saba yani!” ");
INSERT INTO kqew_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na, yamangkasowat da silan aw pasakaya nilan si Isa. Aw yakadonggo dayon silan sang banwa na akadtonan nilan. ");
INSERT INTO kqew_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sonod na allaw idto pa sang dipag ng linaw yang kaotawan na pyakan ni Isa. Kyadumduman nilan na sambok gaid yang bangka ansan ng gabi aw kyatigaman nilan na wa asakay si Isa sang bangka upud sang mga inindowan nan, awgaid silan da gaid yang lyomarga. ");
INSERT INTO kqew_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ansinyan aon mga bangka sikun sa Tibiriyas na yadonggo masaid sa logar daw wain yakakan yang mga otaw ng pan pagkatapos panginsokor ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na, pagkita ng mga otaw na waa da don si Isa aw waa oman yang mga inindowan nan, syomakay silan sinyan na mga bangka aw kyomadto silan sa Kapirnaom untak anapun nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na, pagkita nilan kang Isa adto sang dipag ng linaw, yosip nilan, “Kay Goro, kano pa kaw adi?” ");
INSERT INTO kqew_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na pyagapanganap mayo ako sabap ng yakakan aw yamangkabiyag kamo. Awgaid wa kamo pakasabot sidtong katingaan na ininang ko. ");
INSERT INTO kqew_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayaw kamo pagpangalingkamot sabap sang pagkan na amadonot awgaid sabap sang pagkan na maka-atag ng kinabowi na way kataposan. Yani na pagkan i-atag kamayo ng Anak ng Manosiya na ako sagaw kay ako yang yatagan ng Tohan na Ama ng kapatot ng pagpangatag.” ");
INSERT INTO kqew_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ansinyan yaga-osip silan kanan, “Ono yang dait nami inangun untak matoman nami yang karim ng Tohan?” ");
INSERT INTO kqew_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tyomobag si Isa, “Yani yang karim na ipa-inang kamayo ng Tohan na mangintoo kamo kanak na syogo nan.” ");
INSERT INTO kqew_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Yagalaong oman silan, “Ono yang katingaan na ipakita mo kanami silbi tanda ng kammo kabarakat untak mangintoo kami kammo? Yang kanatun mga kaompowan yakan ng manna adto sa diserto mag-onawa ng syorat sang Kitab na yagalaong, ‘Yatagan silan ng pagkan sikun sa sorga.’ Na ikaw, ono kowaw yang inangun mo?” ");
INSERT INTO kqew_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na dili ni Nabi Mosa yang yaga-atag kamayo ng pagkan sikun sa sorga awgaid yang kanak Ama. Aw yan oman yang yaga-atag kamayo ng bunna na pagkan sikun sa sorga. ");
INSERT INTO kqew_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kay yang pagkan na yatag ng Tohan yang yagasikun sa sorga aw yaga-atag ng kinabowi sang manosiya.” ");
INSERT INTO kqew_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ansinyan yagalaong silan kang Isa, “Kay Sir, abaya kami atagi ninyan na pagkan.” ");
INSERT INTO kqew_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yagalaong kanilan si Isa, “Ako sagaw yang pagkan na maka-atag ng kinabowi. Sino-sino yang domood kanak di da amagutum. Aw sino-sino yang amangintoo kanak di da amangga. ");
INSERT INTO kqew_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Awgaid pyagalaong da ta kamo na maskin kinita da mayo ako, di oman kamo amangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yang kariko ng mga otaw na yatag kanak ng Ama, domood kanak. Aw sino-sino yang domood kanak, di ko apapanawon. ");
INSERT INTO kqew_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay yakani ako sikun sa sorga dili untak inangun ko yang karim ko, awgaid untak inangun ko yang karim ng yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aw yani yang karim ng yagasogo kanak na di ako kawaan ng maskin isa sang kariko ng mga otaw na yatag nan kanak, awgaid na abowiun ko oman silan sang Allaw na Maori. ");
INSERT INTO kqew_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kay yani yang karim ng kanak Ama na yang kariko ng yakilaa aw yagapangintoo kanak na Anak nan atagan ng kinabowi na way kataposan. Aw sang Allaw na Maori abowiun ko oman silan.” ");
INSERT INTO kqew_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ansinyan yagabagolbol yang mga Yahodi sabap sang pyagalaong ni Isa na yan kono yang pagkan na yagasikun sang sorga. ");
INSERT INTO kqew_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yagalaong silan, “Di ba yani si Isa, yang anak ni Yosop? Kilaa saba natun yang ama aw ina nan. Nanga yagalaong da yan adon na sikun kono yan sa sorga?” ");
INSERT INTO kqew_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tyomobag si Isa, “Ayaw da kamo pagbagolbol. ");
INSERT INTO kqew_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Way sino-sino na makadood kanak kong di silan atagan ng Ama na yagasogo kanak ng kallini magdood kanak. Aw silan na domood kanak, abowiun ko oman silan sang Allaw na Maori. ");
INSERT INTO kqew_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aon syorat ng mga nabi sang Kitab na yagalaong, ‘Yang kariko ng mga otaw indowan ng Tohan.’ Sino-sino yang amaningug aw amangagad sang pyaga-indo ng Tohan na Ama, domood kanak. ");
INSERT INTO kqew_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Awgaid wa ako pagalaong na aon yakakita sang Ama. Ako gaid na yagasikun sang Tohan na Ama yang yakakita kanan. ");
INSERT INTO kqew_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang yagapangintoo kanak kya-aonan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kay ako yang pagkan na maka-atag ng kinabowi. ");
INSERT INTO kqew_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yang mga kaompowan mayo yakan ng manna adto sa diserto. Awgaid maskin idto yang kyan nilan, yamangkamatay oman silan. ");
INSERT INTO kqew_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Awgaid sino-sino yang makan ng pagkan na yagasikun sa sorga, di amatay. ");
INSERT INTO kqew_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako yang bowi na pagkan na yagasikun sa sorga. Sino-sino yang makan sini na pagkan amabowi taman sa taman. Yang pagkan na i-atag ko kanan yang kanak lawas, aw i-atag ko yan untak ka-aonan ng bunna na kinabowi yang kariko ng manosiya adi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Adon, sabap sini na pyaglaongan ni Isa yanaglalisay yang mga Yahodi aw yanag-inosipay silan, “Monono yang pag-atag kanatun sini na otaw ng kanan lawas untak kanun natun?” ");
INSERT INTO kqew_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yagalaong kanilan si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na kong di kamo makan ng kanak onod na ako yang Anak ng Manosiya, aw di oman kamo minum ng kanak dogo, di kamo aka-aonan ng kinabowi. ");
INSERT INTO kqew_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sino-sino yang makan ng kanak onod aw minum ng kanak dogo aka-aonan ng kinabowi na way kataposan aw abowiun ko oman yan sang Allaw na Maori. ");
INSERT INTO kqew_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kay yang kanak onod yang bunna na pagkan aw yang kanak dogo yang bunna na ma-inum. ");
INSERT INTO kqew_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sino-sino yang makan ng kanak onod aw minum ng kanak dogo, abay yan magpabilin adi kanak aw ako oman magapabilin adto kanan. ");
INSERT INTO kqew_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yang Tohan na Ama na yagasogo kanak yang pyagasikunan ng kinabowi aw yabowi ako sabap kanan. Mag-onawa sinyan, sino-sino yang makan kanak, amabowi sabap kanak. ");
INSERT INTO kqew_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ako sagaw yang pagkan na yagasikun sang sorga. Dili yan mag-onawa sidtong manna na kyan ng mga kaompowan mayo singaong ona. Kay maskin kyan nilan ingidto, yamangkamatay oman silan. Awgaid sino-sino yang makan sini na pagkan na pyagalaong ko kamayo, amabowi taman sa taman.” ");
INSERT INTO kqew_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Idto yang pyagalaong ni Isa sarta yaga-indo yan sang pagsasambayangan ng mga Yahodi adto sa Kapirnaom. ");
INSERT INTO kqew_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Madaig sang mga yagapangagad kang Isa yakadungug sang pyaga-indo nan aw yagalaong silan, “Mairap yani na indowan. Sino yang amakadawat san?” ");
INSERT INTO kqew_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na, maskin way yagalaong kang Isa, kyatigaman nan na yagabagolbol silan sabap sidtong pyaga-indo nan. Agaw laong nan kanilan, “Yamalain kamo sabap sidtong pyagalaong ko? ");
INSERT INTO kqew_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, ono kowaw yang ipaglaong mayo kong akitaun mayo ako na Anak ng Manosiya na mabarik adto sa sorga na pyagasikunan ko? ");
INSERT INTO kqew_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yang Nyawa ng Tohan yang yaga-atag ng kinabowi. Di yan ma-inang ng otaw. Yang pyagalaong ko kamayo yagasikun sang Nyawa ng Tohan aw maka-atag kamayo ng kinabowi. ");
INSERT INTO kqew_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Awgaid aon kadaigan kamayo na di mangintoo kanak.” Yan yang pyagalaong ni Isa kay kyatigaman nan sikun pa sang ona daw sino yang di amangintoo kanan aw sino oman yang magatraydor kanan. ");
INSERT INTO kqew_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yagalaong oman si Isa, “Idto sagaw, pyagalaong ta kamo na way maskin sino na makadood kanak aw di yan atogotan ng Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na, sikun sidto na wakto madaig yang mga yagapangagad kang Isa na yagabiya kanan aw wa da silan apangagad kanan. ");
INSERT INTO kqew_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sabap sinyan yosip ni Isa yang sampoo aw dowa na mga sahabat nan, “Na kamo, mabiya oman kamo kanak?” ");
INSERT INTO kqew_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tyomobag si Simon Pitros, “Kay Dato, sino pa yang akadtonan nami? Iyan gaid kammo yang mga pyaglaongan na maka-atag ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yagapangintoo kami aw sang way dowa-dowa yamatigam da kami na ikaw yang sotti na syogo ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ansinyan yagalaong si Isa, “Di ba pinili ta kamo na sampoo aw dowa? Awgaid saytan yang sangkaotaw kamayo.” ");
INSERT INTO kqew_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yang pyasabot ni Isa si Yodas na anak ni Simon Iskariyot. Kay si Yodas, maskin sambok sang sampoo aw dowa na mga sahabat, magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos sinyan kyomadto si Isa sang yagakatuna-tuna na mga banwa sang probinsya ng Jalil. Di nan karim komadto sa Yahodiya kay yang mga pangoo ng mga Yahodi ansidto yagadumdum magpatay kanan. ");
INSERT INTO kqew_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ansinyan masaid da yang pakaradyaan ng mga Yahodi na tyawag ng Pakaradyaan ng mga Lagkaw. ");
INSERT INTO kqew_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Agaw pyagalaong si Isa ng mga lomon nan, “Panaw da sini na banwa aw kadto sa Yahodiya untak makita ng mga yagapangagad kammo yang mga katingaan na ininang mo. ");
INSERT INTO kqew_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay di tagoon ng otaw yang mga inang nan kong karim nan mabaoy ng bantoganun. Adon kay ininang da mo yani na mga katingaan, ipakita da mo gao sang tibok donya!” ");
INSERT INTO kqew_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maynan yang pyagalaong ng mga lomon ni Isa kay maskin silan wa apangintoo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yagalaong kanilan si Isa, “Wa pa adatung yang osto na wakto na makadto ako. Awgaid kamo, maskin ono na wakto makakadto kamo. ");
INSERT INTO kqew_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Di mapakay na adumutan kamo ng mga otaw adi sang donya. Awgaid ako, dyumutan nilan ako kay yabay ako magpatigam kanilan na maat yang ininang nilan. ");
INSERT INTO kqew_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kadto da kamo sang pakaradyaan. Awgaid di pa ako makadto kay wa pa adatung yang wakto na pyagakahanda kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na, yan yang pyagalaong ni Isa aw yagapabilin pa yan adto sa Jalil. ");
INSERT INTO kqew_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Adon, pagpanaw da ng mga lomon ni Isa, kyomadto oman yan sang pakaradyaan. Awgaid sikrito yang pagkadto nan untak di katigaman ng mga otaw na iyan yan. ");
INSERT INTO kqew_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na, adto sang pakaradyaan pyagapanganap yan ng mga pangoo ng mga Yahodi aw yabay silan mag-osip daw wain yan. ");
INSERT INTO kqew_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Madaig yang mga otaw na yanagpatomod-tomod makapantag kang Isa. Yang kadaigan yagalaong, “Madyaw yan na otaw.” Yang kadaigan oman yagalaong, “Dili, kay ilimbongan gaid nan yang mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Awgaid wa silan pagapadungug sang pyaglaongan nilan kay yangkalluk silan sang mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, sang ika-opat na allaw ng pakaradyaan kyomadto si Isa sang Baay ng Tohan aw yagasogod yan mag-indo sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yangkatingaa da yang mga pangoo ng mga Yahodi aw yagalaong silan, “Wain pagasikun yang katigam sini na otaw nang wa saba yan pagapangadi sang mga magiindoway natun?” ");
INSERT INTO kqew_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pagdungug sinyan ni Isa, yagalaong yan, “Yang pyaga-indo ko wa pagasikun kanak awgaid sikun sang Tohan na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sino-sino yang marim magpangagad sang karim ng Tohan, akatigaman nan daw wain pagasikun yang pyaga-indo ko, daw sikun sang Tohan atawa sikun gaid adi kanak. ");
INSERT INTO kqew_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yang otaw na yaga-indo ng sarili nan na katigam, karim nan na abantogon yang ginawa nan. Awgaid yang otaw na karim nan na abantogon yang yagasogo kanan, aag bunna yang pyaglaongan nan aw matorid yan na otaw. ");
INSERT INTO kqew_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Si Nabi Mosa yang yaga-atag kamayo ng Hokoman, awgaid way maskin sangka otaw kamayo na yagatoman ninyan. Kay kong tyoman mayo, na, nanga karim mayo ako patayun?” ");
INSERT INTO kqew_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tyomobag yang mga otaw aw laong nilan, “Kyasaytanan kaw kowaw! Sino kadi yang marim magpatay kammo?” ");
INSERT INTO kqew_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yagalaong kanilan si Isa, “Sambok gaid yang katingaan na ininang ko sang Allaw ng Pagpatana, aw yangkatingaa da yang kariko mayo. ");
INSERT INTO kqew_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Si Nabi Mosa yang yaga-atag kamayo ng sogowan ng pagpatoli. Awgaid sang kabunnaan, yan na sogowan wa pagasikun kang Nabi Mosa kondi sang mga kaompowan mayo na yama-ona pa kang Nabi Mosa. Agaw atoliun mayo yang mga anak mayo na usug maskin sang Allaw ng Pagpatana. ");
INSERT INTO kqew_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Adon, kong atoliun mayo yang sambok na isu sang Allaw ng Pagpatana kay untak matoman yang sogowan ni Nabi Mosa, na, nanga yadaman kamo kanak kay pyakadyaw ko yang tibok lawas ng otaw sang Allaw ng Pagpatana? ");
INSERT INTO kqew_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayaw kamo paglaong na maat yang ininang ng sambok na otaw kong wa pa mayo akatigami yang kabunnaan. Sosia mayo ona untak matorid yang paghokom mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ansinyan aon mga taga Awrosalam na yagalaong, “Di ba yani yang otaw na karim patayun ng mga pangoo natun? ");
INSERT INTO kqew_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tanawa! Yaga-indo da yan sang mga otaw, awgaid wa silan pagakontra kanan. Basin kyatigaman da nilan na yan agaw yang Almasi na pyasad ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Awgaid,” laong nilan, “pagdatung ng Almasi way yamatigam daw wain yan pagasikun. Awgaid yani si Isa, kyatigaman saba natun daw wain pagasikun.” ");
INSERT INTO kqew_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ansinyan byolasan ni Isa yang tingug nan sarta yaga-indo yan adto sa suud ng Baay ng Tohan aw laong nan, “Bunna sagaw na kinilaa mayo ako aw kyatigaman mayo daw wain ako pagasikun. Wa ako akani sabap sang karim ko, awgaid yang yagasogo kanak, aag bunna yang pyaglaongan nan. Wa kamo akilaa kanan ");
INSERT INTO kqew_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","awgaid ako, kinilaa ko yan kay yagasikun ako adto kanan aw yan agaw yang yagasogo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sabap sidtong pyaglaongan nan adakupun da gao yan ng mga pangoo, awgaid wa silan pakadakup kanan kay wa pa adatung yang wakto na pyagakahanda kanan. ");
INSERT INTO kqew_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Awgaid madaig yang mga otaw na yagapangintoo kanan aw yagalaong silan, “Pagdatung ng Almasi, maka-inang ba yan ng mas madaig pa na mga katingaan kaysang ininang nini na otaw?” ");
INSERT INTO kqew_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ansinyan yadungug ng mga Parisi daw ono yang pyagatomod-tomod ng mga otaw makapantag kang Isa. Agaw, silan aw yang mga pangoo ng mga imam, syogo nilan yang mga gowardya sang Baay ng Tohan untak dakupun nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na, yagalaong si Isa, “Magapabilin pa ako adi kamayo ng tagbi gaid na panahon. Pagkatapos san magabarik ako adto sang yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Anapun mayo ako, awgaid di mayo ako akitaun kay di kamo makakadto sang akadtonan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ansinyan yanag-inosipay yang mga pangoo ng mga Yahodi, laong nilan, “Wain yan makadto na di da ta yan akitaun? Makadto ba yan sang mga syodad ng mga Grik na idto oman paga-uya yang kadaigan na mga kalomonan ta na Yahodi untak indowan nan yang mga Grik? ");
INSERT INTO kqew_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yagalaong yan na anapun natun yan, awgaid di da ta yan akitaun kay di kita makakadto sang akadtonan nan. Na, ono kowaw yang karim nan ipasabot?” ");
INSERT INTO kqew_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na, pagdatung ng kataposan na allaw ng pakaradyaan na idto yang pinakadakowa na allaw, yamindug si Isa aw yagapiyagit aw laong nan, “Sino-sino yang yamangga, dood kamo kanak aw pa-inumun ta kamo. ");
INSERT INTO kqew_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kay aon yakasorat sang Kitab na yagalaong, ‘Sino-sino yang mangintoo kanak, sikun sang suud ng pangatayan nan imibwak yang tobig na maka-atag ng kinabowi.’ ” ");
INSERT INTO kqew_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yang karim ipasabot ni Isa sang tobig na maka-atag ng kinabowi yang Nyawa ng Tohan na madari da dawatun ng mga yagapangintoo kanan. Sidto na wakto wa pa silan atagi ng Nyawa ng Tohan kay wa pa pagabarik si Isa adto sa sorga. ");
INSERT INTO kqew_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Isa, aon kadaigan kanilan na yagalaong, “Yan agaw yang nabi na pyagatagadan natun.” ");
INSERT INTO kqew_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aon oman kadaigan na yagalaong, “Yan yang Almasi.” Awgaid aon pay oman kadaigan na yagalaong, “Yang Almasi di magasikun sa Jalil! ");
INSERT INTO kqew_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kay yakasorat sang Kitab na yang Almasi topo ni Soltan Daud aw amaotaw yan sang banwa ng Baytlaham na banwa oman ni Soltan Daud.” ");
INSERT INTO kqew_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Agaw yanagkalain-lain yang dumduman ng mga otaw makapantag kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yang kadaigan nilan, karim gao nilan dakupun si Isa, awgaid way maskin sambok kanilan na yamangisug pagdakup kanan. ");
INSERT INTO kqew_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ansinyan byomarik yang mga gowardya adto sang mga pangoo ng mga imam aw yang mga Parisi na yagasogo kanilan. Pagdatung nilan, yaga-osip yang mga yagasogo kanilan, “Nanga wa mayo adakupa si Isa aw daa adi?” ");
INSERT INTO kqew_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tyomobag yang mga gowardya, “Sokad-sokad way otaw na mag-onawa kanan yang pyaga-indo!” ");
INSERT INTO kqew_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yagalaong yang mga Parisi, “Astaga! Maskin oman kamo ilimbongan da nan? ");
INSERT INTO kqew_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Aon bay mga pangoo atawa mga Parisi na yagapangintoo kanan? ");
INSERT INTO kqew_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Waa! Idtong kaotawan na wa akatigam sang Hokoman, silan yang yagapangintoo kanan. Asiksaun silan ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na, sambok sang mga Parisi si Nikodimos, yang otaw na kyomadto kang Isa singaon untak mapagbaaw kanan. Yagalaong yan kanilan, ");
INSERT INTO kqew_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Di ba sobay sang Hokoman dait ona apaningugan yang otaw untak katigaman daw ono yang ininang nan bago pa yan mahokom?” ");
INSERT INTO kqew_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tyomobag silan aw laong nilan, “Astaga! Maynang taga Jalil kaw oman. Tanawa daw ono yang yakasorat sang Kitab. Kong basaun mo, akitaun mo na way nabi na yagasikun sa Jalil.” ");
INSERT INTO kqew_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos sinyan yanagsi-ori yang kariko nilan. ");
INSERT INTO kqew_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Awgaid si Isa yakadto sang Butay ng Jayton. ");
INSERT INTO kqew_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagka-ilaw ng masuum pa byomarik si Isa adto sang Baay ng Tohan. Yang kariko ng mga otaw ansan yanagtipon adto kanan. Agaw yamingkod yan aw yaga-indo kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ansinyan dyomatung yang mga magiindoway ng Hokoman aw yang mga Parisi na aon daa nilan na bobay na dyatungan na yagajina. Pya-atobang nilan yan sang mga otaw ");
INSERT INTO kqew_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aw yagalaong silan kang Isa, “Magiindoway, yani na bobay dyatungan na yagajina. ");
INSERT INTO kqew_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sobay sang Hokoman na yatag kanatun ni Nabi Mosa, yang mayninyan na bobay dait bonoon ng bato sampay na akamatay da nan. Na ikaw, ono yang ikapaglaong mo?” ");
INSERT INTO kqew_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Maynan yang osip nilan kay karim nilan porbaan si Isa paglaongon untak aon ikasombong nilan kanan. Awgaid yang ininang ni Isa, yadoko yan aw yagasorat sang lopa pina-agi sang kanan tollo. ");
INSERT INTO kqew_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Adon kay yabay pa silan mag-osip kanan, yamindug si Isa aw yagalaong kanilan, “Sino kamayo yang way dosa, yan yang ama-ona magbono ng bato kanan.” ");
INSERT INTO kqew_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ansinyan yadoko da oman si Isa aw yagasorat sang lopa. ");
INSERT INTO kqew_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na, pagdungug nilan sinyan, isa-isa silan pomanaw na yama-ona yang mga mangkatikadung sampay na si Isa dakoman yang yamabilin aw yang bobay na yaga-indug pa ansan. ");
INSERT INTO kqew_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ansinyan yamindug si Isa aw yaga-osip kanan, “Kay Bi, wain da silan? Way yamabilin untak maghokom kammo?” ");
INSERT INTO kqew_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Waa, kay Sir,” tyomobag yang bobay. Ansinyan yagalaong si Isa kanan, “Kong maynan, di oman ako magahokom kammo na apatayun kaw. Panaw da, awgaid ayaw da pagpakadosa.” ");
INSERT INTO kqew_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ansinyan yaga-indo da oman si Isa sang mga otaw aw yagalaong yan, “Ako yang allag na yaga-atag ng kapawa sang dumduman ng manosiya. Sino-sino yang amangagad kanak di da magapanaw sang kadugguman kay iyan kanan yang allag na maka-atag ng kinabowi.” ");
INSERT INTO kqew_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pagdungug sinyan ng mga Parisi, yagalaong silan, “Di amadawat yang pyagalaong mo kay yagasaksi kaw makapantag sang ginawa mo.” ");
INSERT INTO kqew_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tyomobag si Isa aw laong nan, “Maskin yagasaksi ako makapantag sang ginawa ko, bunna yang pyagalaong ko kay yamatigam ako daw wain ako pagasikun aw wain ako makadto. Awgaid kamo, wa kamo akatigam daw wain ako pagasikun aw wain ako makadto. ");
INSERT INTO kqew_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yang kamayo paghokom dili kasarigan kay yang syonod mayo yang dumduman ng otaw. Awgaid ako, di ako magahokom sang abir sino. ");
INSERT INTO kqew_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Awgaid kong magahokom ako, bunna yang paghokom ko kay dili ako gaid yang magahokom kondi ako aw yang Ama na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yakasorat sang kamayo Hokoman na bunna yang pagsaksi ng dowangka otaw aw mag-onawa yang pyagalaong nilan. ");
INSERT INTO kqew_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na adon, dait dawatun yang pyagalaong ko kay dowa kami na yagasaksi makapantag kanak, ako aw yang Ama na yagasogo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yaga-osip yang mga Parisi, “Wain kadi yang kammo ama?” Tyomobag si Isa, “Wa kamo akilaa kanak aw wa oman kamo akilaa sang kanak Ama. Kay kong kinilaa mayo ako, kinilaa oman mayo yang kanak Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yan yang pyagalaong ni Isa sarta yaga-indo yan adto sang Baay ng Tohan masaid sang butanganan ng mga sidoka. Awgaid way yagadakup kanan kay wa pa adatung yang wakto na pyagakahanda kanan. ");
INSERT INTO kqew_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ansinyan yagalaong oman si Isa kanilan, “Di amadogay mapanaw da ako aw anapun mayo ako. Awgaid amatay da gaid kamo nang wa pa kamo ampona ng mga dosa mayo. Aw di kamo makakadto sang akadtonan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sabap sinyan yanag-inosipay yang mga pangoo ng mga Yahodi, laong nilan, “Nanga yagalaong yan na di kita makakadto sang akadtonan nan? Karim nan ipasabot na magapakamatay yan?” ");
INSERT INTO kqew_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yagalaong si Isa, “Kamo taga donya, awgaid ako, sikun ako sang sorga. Sakop kamo sining donya, awgaid ako dili. ");
INSERT INTO kqew_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sabap sinyan pyagalaong da ta kamo na amatay kamo ng way kaamponan ng mga dosa mayo. Amaitabo sagaw yan kong di kamo mangintoo sang pyagalaong ko daw sino ako.” ");
INSERT INTO kqew_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Sino kaw kadi?” yaga-osip silan. Tyomobag si Isa, “Pyagalaong da ta kamo sikun pa sang ona daw sino ako. ");
INSERT INTO kqew_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madaig yang ikapaglaong ko makapantag kamayo na ikahokom kamayo. Awgaid idto gaid yang pyagalaong ko sang mga otaw adi sang donya daw ono yang dyungug ko adto sang yagasogo kanak. Aw yang kariko ng pyagalaong nan bunna.” ");
INSERT INTO kqew_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na, wa silan pakasabot na pyagalaong nan silan makapantag sang Tohan na Ama. ");
INSERT INTO kqew_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Agaw yagalaong si Isa kanilan, “Pagdatung ng wakto na pyataas da mayo ako na Anak ng Manosiya adto sa kros, akatigaman da mayo na ako sagaw daw sino yang pyagalaong ko. Akatigaman oman mayo na way ininang ko sikun gaid sang dumduman ko. Awgaid yani gaid yang pyagalaong ko daw ono yang pyagalaong kanak ng Ama. ");
INSERT INTO kqew_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yang yagasogo kanak yabay idi kanak. Wa nan ako apabayai kay maskin ono yang akasowat nan, idto yang ininang ko.” ");
INSERT INTO kqew_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Isa, madaig yang yagapangintoo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ansinyan yagalaong si Isa sidtong mga Yahodi na yagapangintoo kanan, “Kong abay mayo pangagadan yang pyaga-indo ko, bunna kamo na mga inindowan ko. ");
INSERT INTO kqew_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Akatigaman da mayo yang kabunnaan, aw idto sagaw, yang kabunnaan maka-atag kamayo ng kagawasan.” ");
INSERT INTO kqew_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yagalaong silan, “Oy, kami mga topo ni Nabi Ibrahim. Sikun pa singaon, dili kami ng allang ng abir sino. Nanga yagalaong kaw na atagan kami ng kagawasan?” ");
INSERT INTO kqew_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang abay magpakadosa, allang yan ng kadosaan. ");
INSERT INTO kqew_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Adon, yang allang dili sakop sang baay taman sa taman, awgaid yang anak. ");
INSERT INTO kqew_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Agaw, kong yang Anak ng Tohan yang maga-atag kamayo ng kagawasan, bunna na makagawas da kamo sang pagka-allang mayo. ");
INSERT INTO kqew_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yamatigam ako na mga topo kamo ni Nabi Ibrahim. Awgaid maskin maynan, karim mayo ako patayun kay di mayo adawatun yang indowan ko. ");
INSERT INTO kqew_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pyagalaong ko kamayo daw ono yang kinita ko adto sang kanak Ama. Kamo oman, ininang mayo daw ono yang dyungug mayo adto sang kamayo ama.” ");
INSERT INTO kqew_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yagalaong silan, “Si Nabi Ibrahim yang kanami ama.” “Kong bunna na mga topo kamo ni Nabi Ibrahim,” yagalaong si Isa, “inangun gao mayo yang mag-onawa ng ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Awgaid kamo, yagadumdum sagaw kamo magpatay kanak maskin yabay ako maglaong kamayo ng kabunnaan na dyungug ko adto sang Tohan. Dili ng maynan yang ininang ni Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yang ininang mayo mag-onawa sagaw sang ininang ng kamayo ama.” Yagalaong silan, “Dili kami mga anak sa labas. Yang Tohan gaid yang kanami ama!” ");
INSERT INTO kqew_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yagalaong si Isa kanilan, “Kong bunna sagaw na yang Tohan yang kamayo ama, pyakadakowa gao mayo ako sang pangatayan mayo kay yakani ako kamayo sikun sang Tohan. Wa ako akani sabap sang karim ko, awgaid yang Tohan yang yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Di kamo makasabot sang pyagalaong ko sabap ng dili kamo makadawat sang indowan ko. ");
INSERT INTO kqew_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Iblis yang kamayo ama, aw kallini mayo inangun daw ono yang kyallinian nan. Sikun pa singaong ona mammatay da yan. Kalaban yan ng kabunnaan kay way kinita na kabunnaan adto kanan. Kong mamakak yan, batasan gaid nan idto kay bakakun yan aw yan yang pyagasikunan ng kariko ng bakak. ");
INSERT INTO kqew_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Awgaid ako, aag bunna yang pyaglaongan ko, agaw di kamo amangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sino kamayo yang makapaglaong na yakadosa ako? Waa! Na, kong kabunnaan yang pyagalaong ko kamayo, nanga di kamo mangintoo kanak? ");
INSERT INTO kqew_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sino-sino na sakop ng Tohan amaningug sang pyaglaongan nan. Awgaid kamo, di kamo amaningug sang pyaglaongan nan kay dili kamo sakop ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ansinyan yagalaong kanan yang mga pangoo ng mga Yahodi, “Bunna sagaw yang pyagalaong nami na ikaw taga Samariya aw kyasaytanan kaw.” ");
INSERT INTO kqew_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Wa ako akasaytani,” yagalaong si Isa. “Yaddatan ko yang kanak Ama, awgaid way addat mayo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Di ako maga-anap na abantogon ako. Awgaid yang kanak Ama maga-atag kanak ng kabantog, aw yan yang maghohokom. ");
INSERT INTO kqew_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang amangagad sang indowan ko, di yan amatay taman sa taman.” ");
INSERT INTO kqew_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yagalaong kanan yang mga pangoo ng mga Yahodi, “Na, sa way dowa-dowa yamatigam da kami na kyasaytanan kaw! Maskin si Nabi Ibrahim yamatay kipat yang kadaigan pa na mga nabi. Awgaid ikaw yagalaong na sino-sino yang amangagad sang indowan mo, di amatay taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nanga, labaw pa kaw sang kanatun ompo na si Nabi Ibrahim? Si Nabi Ibrahim patay da aw maynan oman yang kadaigan pa na mga nabi. Sino kaw kadi sang dumduman mo?” ");
INSERT INTO kqew_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tyomobag si Isa, “Kong abantogon ko yang ginawa ko, way siyat ng kabantog ko. Awgaid yang yagabantog kanak yang kanak Ama na pyagalaong mayo na Tohan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wa kamo akilaa kanan, awgaid ako, kinilaa ko yan. Kong magalaong ako na wa ko yan akilaa, amabaoy ako ng bakakun mag-onawa kamayo. Awgaid bunna na kinilaa ko yan aw tyoman ko yang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yamasowat si Nabi Ibrahim na ompo mayo pagkatigam nan na madatung yang allaw na makadi ako sang donya. Pagkita nan sini, yamasowat yan.” ");
INSERT INTO kqew_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ansinyan yagalaong kanan yang mga pangoo ng mga Yahodi, “Waa pay 50 yang idad mo aw kinita mo si Nabi Ibrahim?” ");
INSERT INTO kqew_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tyomobag si Isa, “Sa bunna-bunna na ipaglaong ko kamayo, sang wa pa akaotaw si Nabi Ibrahim, iyan da ako.” ");
INSERT INTO kqew_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pagdungug nilan sinyan, yanagpamoti silan ng bato kay untak bonoon nilan si Isa. Awgaid yawaa si Isa sang kadaig ng mga otaw aw lyomogwa sikun sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ansinyan sarta yagapanaw silan Isa, aon kinita nilan na otaw na bota sikun pa sang pagkaotaw nan. ");
INSERT INTO kqew_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Adon, yosip si Isa ng mga inindowan nan, “Kay Goro, sino ba yang yakadosa na yaotaw yan na bota? Yan atawa yang taganak nan?” ");
INSERT INTO kqew_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tyomobag si Isa, “Yaotaw yan na bota dili sabap ng yakadosa yan atawa yang taganak nan. Awgaid yamabota yan untak kitaun ng mga otaw yang kabarakat ng Tohan sang pagpakadyaw kanan. ");
INSERT INTO kqew_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yang mga otaw yagagawbuk sarta allaw pa, kay kong gabi da, di da silan makagawbuk. Mag-onawa sinyan dait natun inangun yang pya-inang kanatun ng Tohan na yagasogo kanak sarta bowi pa kita. Kay madatung yang wakto na amatay da kita aw di da natun ma-inang. ");
INSERT INTO kqew_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sarta ini pa ako sang donya, ako yang allag na yaga-atag ng kapawa sang dumduman ng manosiya.” ");
INSERT INTO kqew_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Paglaong sinyan, yatobad si Isa sang lopa aw inanga nan ng pasak. Pagkatapos dyamas nan yang pasak sang mata ng bota ");
INSERT INTO kqew_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aw paglaonga nan, “Kadto sang sogbowanan ng Silowam aw pagpowamos.” Yang mana ng Silowam, Pyadaa. Agaw kyomadto yang bota aw magpowamos. Pagkatapos, byomarik na yakakita da yan. ");
INSERT INTO kqew_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Adon, pagkita kanan ng mga simbaay nan kipat yang mga otaw na yakakita kanan singaon nang yagapakilimos pa yan, yaga-osip silan, “Di ba yan yang idtong otaw na yabay mag-ingkod sang kilid ng daan aw magpakilimos?” ");
INSERT INTO kqew_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tyomobag yang kadaigan, “Uu, yan ingidto.” Yang kadaigan oman yagalaong, “Dili, mag-onawa gaid yang parangay nilan.” Agaw yagalaong idtong otaw, “Ako sagaw yang idto.” ");
INSERT INTO kqew_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na, yaga-osip silan kanan, “Nanga yakakita da kaw adon?” ");
INSERT INTO kqew_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tyomobag yang otaw, “Yang otaw na pyagangaanan kang Isa yaga-inang ng pasak aw dyamas nan sang kanak mata. Pagkatapos san pyagalaong nan ako na makadto sang sogbowanan ng Silowam aw magpowamos. Agaw kyomadto ako, aw pagkatapos magpowamos yakakita da ako.” ");
INSERT INTO kqew_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Wain da ingaon?” yosip nilan. Tyomobag yang otaw, “Wa ako akatigam.” ");
INSERT INTO kqew_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ansinyan dyaa nilan idtong otaw na bota singaon adto sang mga Parisi. ");
INSERT INTO kqew_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, sang Allaw ng Pagpatana yaga-inang si Isa ng pasak aw pyakadyaw nan yang bota. ");
INSERT INTO kqew_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Agaw yosip da oman ng mga Parisi idtong otaw daw nanga yakakita da yan adon. Pyagalaong nan silan, “Dyamasan nan ng pasak yang kanak mata. Pagkatapos san yagapowamos ako, aw adon yakakita da ako.” ");
INSERT INTO kqew_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na, yagalaong da yang kadaigan ng mga Parisi, “Wa pagasikun sang Tohan yang otaw na yaga-inang ninyan kay wa nan atomana yang sogowan makapantag sang Allaw ng Pagpatana.” Awgaid aon oman kadaigan na yagalaong, “Kong baradosa yan na otaw, di yan maka-inang ng katingaan na mag-onawa sinyan.” Aw ansinyan yanagkalain-lain yang dumduman nilan makapantag kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Agaw yosip da oman nilan idtong otaw, laong nilan, “Yagalaong kaw na pyakadyaw nan yang kammo mata. Na adon, ono yang ikapaglaong mo makapantag kanan?” Tyomobag yang otaw, “Bain kanak, sambok yan na nabi.” ");
INSERT INTO kqew_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na, di amadawat ng mga pangoo ng mga Yahodi na yang otaw na yakakita adon, bota singaon. Agaw pyatawag nilan yang mga taganak nan ");
INSERT INTO kqew_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aw yosip nilan, “Anak mayo yan? Bunna agaw na bota yan sikun pa sang pagkaotaw nan? Na, kong maynan, nanga yakakita da yan adon?” ");
INSERT INTO kqew_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tyomobag yang taganak nan, “Bunna na anak nami yan, aw bunna oman na bota yan sikun pa sang pagkaotaw nan. ");
INSERT INTO kqew_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Awgaid wa kami akatigam daw nanga yakakita da yan adon atawa sino yang yagapakadyaw sang mata nan. Osipa mayo yan kay dakowa da sa yan aw makatobag yan makapantag sang ginawa nan.” ");
INSERT INTO kqew_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yan yang pyagalaong ng taganak nan kay yamalluk silan sang mga pangoo ng mga Yahodi sabap ng yanagka-oyon silan na sino-sino yang magalaong na si Isa yang Almasi, apalogwaun yan sikun sang jamaa ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Idto sagaw yagalaong yang taganak nan, “Dakowa da yan. Yan da yang osipun mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Agaw pyatawag da oman nilan idtong otaw na bota singaon aw paglaonga nilan, “Addati yang Tohan aw paglaonga yang kabunnaan. Kay yamatigam kami na yang otaw na yagapakadyaw kammo baradosa.” ");
INSERT INTO kqew_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yagalaong idtong otaw, “Wa ako akatigam kong baradosa yan atawa dili. Basta yani gaid yang kyatigaman ko na singaon bota ako, awgaid adon yakakita da ako.” ");
INSERT INTO kqew_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yaga-osip oman silan, “Ono yang ininang nan kammo? Monono yang pagpakadyaw nan sang mata mo?” ");
INSERT INTO kqew_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tyomobag idtong otaw, “Pyagalaong da ta kamo, awgaid di kamo amaningug. Nanga yaga-osip da oman kamo? Basin karim oman mayo mabaoy ng mga inindowan nan?” ");
INSERT INTO kqew_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ansinyan ininsolto nilan idtong otaw aw paglaonga nilan, “Ikaw saba yang inindowan nidto na otaw. Awgaid kami, mga inindowan kami ni Nabi Mosa! ");
INSERT INTO kqew_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yamatigam kami na yapagbaaw yang Tohan kang Nabi Mosa. Awgaid ingaong otaw, wa kami akatigam daw wain yan pagasikun.” ");
INSERT INTO kqew_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yagalaong yang otaw, “Astaga! Wa kamo akatigam daw wain yan pagasikun, awgaid pyakadyaw nan yang kanak mata! ");
INSERT INTO kqew_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yamatigam saba kita na di atarimaun ng Tohan yang pyagapangayo ng mga otaw na baradosa. Awgaid atarimaun nan yang pyagapangayo ng mga otaw na yaga-addat kanan aw yagatoman ng karim nan. ");
INSERT INTO kqew_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sikun pa sang pukas ng donya way yakadungug na aon yagapakadyaw sang otaw na bota sikun pa sang pagkaotaw nan. ");
INSERT INTO kqew_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kong ingaong otaw wa pagasikun sang Tohan, way gao ma-inang nan.” ");
INSERT INTO kqew_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na, yagalaong da silan, “Baradosa kaw sikun pa sang pagkaotaw mo! Aw adon, indowan pa mo kami?” Aw ansinyan pyalogwa nilan yan sikun sang jamaa ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na, pagdungug ni Isa na pyalogwa nilan idtong otaw sikun sang jamaa ng mga Yahodi, yanap nan. Pagkita kanan, yosip nan, “Yagapangintoo kaw sang Anak ng Manosiya?” ");
INSERT INTO kqew_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tyomobag yang otaw, “Kay Sir, paglaongan kanak daw sino yan untak makapangintoo ako kanan.” ");
INSERT INTO kqew_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yagalaong si Isa, “Kinita da mo yan, aw yan agaw yang yapagbaaw kammo adon.” ");
INSERT INTO kqew_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Kay Tagallang, yagapangintoo ako kammo,” yagalaong yang otaw aw syomojod kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yagalaong oman si Isa, “Yakani ako sining donya untak lainun ko yang mga otaw. Kay yang mga otaw na yaga-akun na main silan ng bota kay wa silan akatigam sang kabunnaan makapantag sang Tohan, akamangun ko yang pagkabota nilan untak makakita silan. Yang mga otaw oman na yagalaong na yakakita silan kay pagtoo nilan na yamatigam silan sang kabunnaan makapantag sang Tohan, pakitaun ko kanilan na silan kadi yang bota.” ");
INSERT INTO kqew_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Adon, aon mga Parisi sang masaid kanan na yakadungug sang pyagalaong nan aw yaga-osip silan kanan, “Karim mo ba ipasabot na bota oman kami?” ");
INSERT INTO kqew_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tyomobag si Isa, “Kong adawatun mayo na bota kamo, way gao dosa mayo. Awgaid sabap ng yagalaong kamo na yakakita kamo, yagapabilin yang dosa mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ansinyan yagalaong si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na yang otaw na di amagi sang powertaan sang pagsuud sang kolongan ng mga karniro awgaid mapanik sang koral, kawatan atawa tolisan. ");
INSERT INTO kqew_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Awgaid yang otaw na masuud sang powertaan, yan yang magbabantayay ng mga karniro. ");
INSERT INTO kqew_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pasuudun yan ng yagabantay sang powertaan. Aw pagsuud nan, atawagun nan yang kanan mga karniro sang ngaan nilan aw kinilaa nilan yang tingug nan. Ansinyan adaun nan silan adto sa logwa. ");
INSERT INTO kqew_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paglogwa da ng kariko nilan, ama-ona yan kanilan aw yang mga karniro masonod kanan kay kinilaa nilan yang tingug nan. ");
INSERT INTO kqew_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Di masonod yang mga karniro sang otaw na wa nilan akilaa, awgaid magapakawat silan kanan kay wa silan akilaa sang tingug nan.” ");
INSERT INTO kqew_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na, yani yang pasombingay na pyagalaong kanilan ni Isa, awgaid wa silan pakasabot sang mana ninyan. ");
INSERT INTO kqew_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Agaw yagalaong oman si Isa, “Sa bunna-bunna na ipaglaong ko kamayo na ako yang powertaan na agian ng mga karniro. ");
INSERT INTO kqew_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yang kariko ng mga otaw na yama-ona kanak domatung aw yaga-indo ng dili ng bunna, silan yang mag-onawa ng kawatan aw tolisan. Awgaid yang mga otaw na mag-onawa ng kanak mga karniro, wa silan apaningug kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako yang powertaan. Sino-sino yang somuud pina-agi kanak amalowas. Mag-onawa silan sang mga karniro na somuud aw lomogwa aw makakita sang akasamsaman nilan. ");
INSERT INTO kqew_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yang kawatan madatung untak gaid magpangawat, magpatay aw mangguba. Awgaid ako, yakani ako sang donya untak atagan ko yang mga otaw ng kinabowi na tanto madyaw aw way kolang. ");
INSERT INTO kqew_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako yang madyaw na magbabantayay ng mga karniro. Yang madyaw na magbabantayay andam ng pagpakamatay para sang mga karniro. ");
INSERT INTO kqew_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Awgaid yang otaw na byayadan untak magbantay sang mga karniro dili ng mag-onawa ng magbabantayay na tagtomon ng mga karniro. Agaw, pagkita nan na madatung yang maisug na ido, domaagan yan aw abiyaan nan yang mga karniro. Ansinyan alopogon ng maisug na ido yang mga karniro aw ipakanat-kanat nan silan. ");
INSERT INTO kqew_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Domaagan idtong otaw kay byayadan gaid ng pagbantay aw baliwaa kanan yang mga karniro. ");
INSERT INTO kqew_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ako yang madyaw na magbabantayay ng mga karniro. Yang kanak Ama yakilaa kanak, aw ako yakilaa sang kanak Ama. Mag-onawa sinyan kinilaa ko yang kanak mga karniro, aw silan oman yakilaa kanak. Aw andam ako magpakamatay para kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aon pay kadaigan na mga karniro ko na wa pa akasakop sini na kolongan. Kinaanglan na apasuudun ko oman silan. Amaningug oman silan kanak aw ansinyan amabaoy yang kariko nilan ng sambok na panon aw sambok da yang magbabantayay nilan. ");
INSERT INTO kqew_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Pyakadakowa ako ng kanak Ama kay andam ako magpakamatay untak mabowi oman ako. ");
INSERT INTO kqew_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Way sino-sino na makapatay kanak. Awgaid iklas sang pangatayan ko na i-atag ko yang kinabowi ko. Kay aon kapatot ko na i-atag ko yang kinabowi ko, aw aon oman kapatot ko na abawiun ko yan. Kay yani yang sogo kanak ng kanak Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na, sabap sinyan na pyaglaongan ni Isa yanagkalain-lain da oman yang dumduman ng mga pangoo ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yang kadaigan kanilan yagalaong, “Kyasaytanan yan aw yamabowang! Nanga yamaningug kamo kanan?” ");
INSERT INTO kqew_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Awgaid aon oman kadaigan na yagalaong, “Yang otaw na kyasaytanan dili makapaglaong ng mayninyan. Dogang pa sinyan, yang saytan di makapakadyaw sang bota!” ");
INSERT INTO kqew_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ansinyan timpo ng tingmaniki aw wakto ng pakaradyaan sa Awrosalam na tyawag ng Pagpasotti sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na, adto si Isa sang pamanag ng Baay ng Tohan na yagapanaw-panaw sang tyawag na Pagasilongan ni Solayman. ");
INSERT INTO kqew_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ansinyan yanagtipon adto kanan yang mga pangoo ng mga Yahodi aw yanaglaong silan, “Nanga di pa mo kami paglaongon daw sino kaw? Paglaongan da kanami ng diretso kong ikaw agaw yang Almasi na pyasad ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tyomobag si Isa, “Pyagalaong da ta kamo, awgaid di kamo mangintoo kanak. Yang mga katingaan na ininang ko sabap sang kapatot ng kanak Ama, yang idto yagapangimunna daw sino ako. ");
INSERT INTO kqew_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Awgaid di kamo mangintoo kay dili kamo ng mga karniro ko. ");
INSERT INTO kqew_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yang mga otaw na sakop ko na maynang mga karniro ko, yamaningug kanak. Ikilaa ko silan aw yagapangagad silan kanak. ");
INSERT INTO kqew_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Atagan ko silan ng kinabowi na way kataposan aw di na di silan amabuag sang Tohan. Aw way sino-sino na maka-agaw kanilan sikun sang kanak arima. ");
INSERT INTO kqew_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yatag silan kanak ng kanak Ama na labaw sang kariko. Aw way sino-sino na maka-agaw kanilan sikun sang arima ng kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako aw yang kanak Ama sambok da.” ");
INSERT INTO kqew_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na, pagdungug sinyan ng mga pangoo ng mga Yahodi, yanagpamoti da oman silan ng bato untak bonoon si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Awgaid yagalaong si Isa kanilan, “Madaig yang katingaan na pyakita ko kamayo na pya-inang kanak ng kanak Ama. Wain ansidto yang pyagasabapan na abonoon mayo ako ng bato?” ");
INSERT INTO kqew_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tyomobag yang mga Yahodi, “Dili sabap sang madyaw na mga inang mo abonoon kaw nami ng bato, awgaid sabap ng yakun mo yang kapatot ng Tohan! Manosiya kaw gaid, awgaid yagalaong kaw na ikaw yang Tohan!” ");
INSERT INTO kqew_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yagalaong si Isa kanilan, “Di ba yakasorat sang kamayo Kitab na yagalaong yang Tohan na ‘mga tohan kamo?’ ");
INSERT INTO kqew_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kyatigaman natun na aag bunna yang yakasorat sang Kitab. Na, kong ‘mga tohan’ yang tawag ng Tohan sang mga otaw na pyadatungan nan ng kanan pyaglaongan, ");
INSERT INTO kqew_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nanga yagalaong kamo na yakadosa ako sang Tohan sabap ng yagalaong ako na ako yang Anak ng Tohan? Kay pinili ako ng Ama aw syogo nan ako adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na, kong wa ako paga-inang ng pya-inang kanak ng kanak Ama, ayaw kamo pagpangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Awgaid kong ininang ko yang pya-inang nan kanak, na, maskin di gao kamo amangintoo sang pyaglaongan ko, pangintowi da mayo yang mga inang ko kay untak katigaman mayo na yang Ama idi kanak, aw ako iyan sang Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na, adakupun da oman gao nilan si Isa, awgaid yakalikay yan kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ansinyan byomarik si Isa adto sang dipag ng Yordan sang logar daw wain pagasogbo singaon si Yahiya sang mga otaw. Yagapabilin yan ansan ng pilang allaw ");
INSERT INTO kqew_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","aw madaig yang mga otaw na kyomadto kanan. Yagalaong silan, “Maskin sagaw wa paga-inang si Yahiya ng katingaan, awgaid yang kariko ng pyagalaong nan makapantag kang Isa bunna.” ");
INSERT INTO kqew_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aw madaig yang mga otaw sidto na logar na yagapangintoo kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Na, aon sambok na otaw na pyagangaanan kang Lasaro. Yaga-uya yan sang banwa ng Bitani upud sang mga lomon nan na si Mariyam aw si Marta. Si Mariyam ingaong bobay na yaga-obo ng paballo sang siki ni Isa aw itrapowan nan ng kanan logay. Adon, yamasakit si Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sabap sinyan yanagtogon yang mga lomon nan na bobay adto kang Isa na yamasakit yang pyasaya nan na amigo. ");
INSERT INTO kqew_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagdungug sinyan ni Isa, yagalaong yan, “Di yan amatay sabap sini na sakit. Yamaitabo yani untak makita yang kabarakat ng Tohan aw untak mabantog oman ako na Anak nan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, dakowa sang pangatayan ni Isa yang maglomon na si Marta, si Mariyam aw si Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Awgaid maskin kyatigaman da ni Isa na yamasakit si Lasaro, yagapabilin pa yan sang kyadtonan nan ng dowang allaw. ");
INSERT INTO kqew_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na, paglabay ng dowang allaw, yagalaong si Isa sang mga inindowan nan, “Unda, magabarik da kita adto sa Yahodiya.” ");
INSERT INTO kqew_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Awgaid yagalaong yang mga inindowan nan, “Kay Goro, pilang allaw pa gaid yang yalabay na byono kaw gao ng bato ng mga pangoo ng mga Yahodi ansidto! Nanga magabarik kaw adto?” ");
INSERT INTO kqew_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tyomobag si Isa pina-agi sang pasombingay, laong nan, “Di ba sampoo aw dowangka oras yang allaw? Kong magapanaw yang otaw sarta allaw pa, di yan amalogso kay mapawa aw kinita nan yang agianan nan. ");
INSERT INTO kqew_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Awgaid kong magapanaw yang otaw kong gabi da, amalogso yan kay maduggum aw di da nan makita yang agianan nan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagkatapos ni Isa maglaong sinyan, yagalaong pa yan, “Yang kanatun amigo na si Lasaro yamatoog da. Awgaid makadto ako kay apokawon ko yan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yagalaong yang mga inindowan nan, “Kay Dato, aw yamatoog yan, amadyaw da yan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yani yang pyagalaong nilan kay pagtoo nilan na yatoog gaid si Lasaro. Awgaid yang karim ipasabot ni Isa na yamatay da si Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Agaw pyagalaong nan silan ng diretso, “Patay da si Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Awgaid sabap kamayo yamasowat ako na wa ako adto sang pagkamatay nan. Kay mallaw amangintoo da kamo kanak sabap sang akitaun mayo. Unda, makadto da kita.” ");
INSERT INTO kqew_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ansinyan yagalaong si Tomas na tyawag oman ng Kambal adto sang mga kaupudanan nan na mga inindowan, “Bita da, amagad kita kanan maskin pa amatay kita upud kanan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Adon, pagdatung nilan ni Isa sa Bitani, pyagalaong silan na opat na allaw da yang yalabay sikun sang pagkobor kang Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na, yang baryo ng Bitani masaid sa Awrosalam, mga toongka kilomitro gaid yang kawat. ");
INSERT INTO kqew_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Agaw madaig yang mga Yahodi na taga Awrosalam na yakadto kang Marta aw si Mariyam untak libadun silan sang pagkamatay ng lomon nilan. ");
INSERT INTO kqew_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Adon, pagdungug ni Marta na yagapaduug da si Isa, lyomogwa yan sikun sang baay kay asongonon nan si Isa. Awgaid si Mariyam yagapabilin adto sa suud ng baay. ");
INSERT INTO kqew_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na, pagsongon ni Marta kang Isa, yagalaong yan, “Kay Dato, aw ini pa kaw singaon, wa gao akamatay yang lomon ko. ");
INSERT INTO kqew_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Awgaid yamatigam ako na abir adon i-atag kammo ng Tohan yang maskin ono na apangayoon mo.” ");
INSERT INTO kqew_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yagalaong si Isa kanan, “Amabowi oman yang lomon mo.” ");
INSERT INTO kqew_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yagalaong si Marta, “Yamatigam ako na amabowi oman yan sang Allaw na Maori sang pagkabowi oman ng mga patay.” ");
INSERT INTO kqew_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yagalaong kanan si Isa, “Ako yang makabowi oman sang mga patay aw ako yang maka-atag ng kinabowi. Sino-sino yang yagapangintoo kanak amabowi taman sa taman maskin amatay pa. ");
INSERT INTO kqew_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aw sino-sino yang yabowi aw yagapangintoo kanak, di yan amatay aw amabuag sang Tohan. Yagapangintoo kaw sini?” ");
INSERT INTO kqew_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Uu, kay Dato,” tyomobag si Marta. “Yagapangintoo ako na ikaw yang Almasi, yang Anak ng Tohan na pyagatagadan nami na madatung adi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkatapos ni Marta maglaong sinyan, byomarik yan adto sang baay aw tawaga nan si Mariyam aw paglaonga nan na silan da gaid, “Ini da yang Magiindoway aw pyatawag kaw nan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagdungug sinyan ni Mariyam, yamindug yan aw yagadari-dari lomogwa kay akadtonan nan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na, sidto na wakto wa pa adatung si Isa sang baryo, awgaid idto pa yan sidtong logar daw wain yan asongona ni Marta. ");
INSERT INTO kqew_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, yang mga Yahodi na iyan sang baay upud kang Mariyam untak maglibad kanan, pagkita nilan na yamindug yan aw yagadari-dari lomogwa, yasonod silan kanan. Kay pagtoo nilan na makadto yan sang kobor untak magtiyao. ");
INSERT INTO kqew_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Awgaid si Mariyam yakadto kang Isa. Pagdatung nan sidtong logar daw wain si Isa aw pagkita nan kanan, syomojod dayon yan sa atobangan nan aw laong nan, “Kay Dato, aw ini pa kaw singaon, wa gao akamatay yang lomon ko.” ");
INSERT INTO kqew_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na, pagkita ni Isa na yagatiyao si Mariyam kipat oman yang mga Yahodi na yamagad kanan, yarikad yang pangatayan nan aw mabugat yang ginawa nan. ");
INSERT INTO kqew_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Wain mayo akoboran si Lasaro?” yaga-osip yan. “Kay Dato, agad kanami untak kitaun mo,” tyomobag silan. ");
INSERT INTO kqew_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ansinyan yagatiyao si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Agaw sa yagalaong yang mga Yahodi, “Tanawa, dakowa si Lasaro sang pangatayan nan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Awgaid yagalaong yang kadaigan, “Di ba pyakadyaw nan yang bota? Nanga wa nan atabangi si Lasaro untak di yan matay?” ");
INSERT INTO kqew_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na, ansinyan yarikad da oman yang pangatayan ni Isa pagdatung nan sang kobor. Sambok na langob yan na kyatabonan ng bato. ");
INSERT INTO kqew_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Kamanga mayo yang bato,” laong ni Isa. Awgaid yagalaong si Marta na lomon ng patay, “Kay Dato, mabao da yan adon kay kyobor da yan sa suud ng opat na allaw.” ");
INSERT INTO kqew_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yagalaong si Isa, “Di ba pyagalaong ta kaw na makakita kaw ng kabarakat ng Tohan kong amangintoo kaw?” ");
INSERT INTO kqew_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Agaw kyamang da nilan yang bato sikun sang baba ng kobor. Ansinyan ya-angad si Isa aw yagalaong yan, “Kay Ama, yamanginsokor ako kammo kay dyungug mo yang pyagapangayo ko. ");
INSERT INTO kqew_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yamatigam ako na abay mo dungugun yang maskin ono na apangayoon ko kammo. Awgaid yagalaong ako sini sabap sang mga otaw na idi sang palibot ko kay untak mangintoo silan na ikaw agaw yang yagasogo kanak adi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Paglaong nan sinyan, yagatawag yan ng matanog, “Lasaro, logwa da!” ");
INSERT INTO kqew_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ansinyan lyomogwa si Lasaro sikun sang kobor na yabalot yang kanan lawas ng sapot sampay sang mga arima aw siki nan, aw yabalot oman yang parangay nan ng panyo. Yagalaong si Isa kanilan, “Obada mayo yang sapot untak makapanaw yan.” ");
INSERT INTO kqew_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na, madaig sang mga Yahodi na yagabisita kang Mariyam aw yakakita sang ininang ni Isa yang yagapangintoo da kanan. ");
INSERT INTO kqew_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Awgaid yang kadaigan kanilan yakadto sang mga Parisi aw yagalaong kanilan daw ono yang ininang ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agaw yang mga pangoo ng mga imam kipat yang mga Parisi, pyatawag dayon nilan yang mga mimbro ng Makagwas na Hokomanan. Aw pagkatipon da nilan, yagalaong silan, “Ono yang inangun ta? Madaig da yang mga katingaan na ininang sini na otaw! ");
INSERT INTO kqew_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aw apasagdan natun yan, na, di amadogay yang kariko ng mga otaw amangintoo da kanan! Kong maynan, makani da yang mga taga Roma aw agubaun nilan yang Baay ng Tohan kipat yang kanatun bangsa!” ");
INSERT INTO kqew_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ansinyan yagalaong yang isa kanilan na pyagangaanan kang Kayapas na yan yang Dakowa na Imam sinyan na toig, laong nan, “Ya-ono da kamo? ");
INSERT INTO kqew_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wa mayo adumduma na madyaw pa kong sambok gaid na otaw yang amatay para sang kariko ng mga otaw kaysang amasapad yang tibok bangsa?” ");
INSERT INTO kqew_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, wa yan pagalaong sinyan sikun gaid sang kanan dumduman. Awgaid sabap ng yan yang Dakowa na Imam sinyan na toig, pyagatagna nan na si Isa yang amatay para sang bangsa Yahodi. ");
INSERT INTO kqew_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aw dili gaid para sang bangsa Yahodi kondi para oman sang kariko ng mga sakop ng Tohan na yamangkakanat-kanat sang kadaigan pa na mga bangsa kay untak magkasambok silan. ");
INSERT INTO kqew_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na, sikun sidto na allaw yanagdumdum yang mga pangoo ng mga Yahodi magpatay kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sabap sinyan wa da pagapakita si Isa sang mga banwa sa Yahodiya. Awgaid kyomadto yan sang sambok na longsod na tyawag ng Ipraim na masaid sa kamingawan. Aw yagapabilin yan ansan upud sang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na adon, masaid da yang pakaradyaan ng mga Yahodi na tyawag ng Pakaradyaan ng Paglabay. Aw madaig yang mga otaw sikun sang yagakatuna-tuna na mga banwa na kyomadto sa Awrosalam bago pa magsogod yang pakaradyaan untak magpasotti silan sobay sang kasogowan nilan. ");
INSERT INTO kqew_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na, pyagapanganap da si Isa ng mga otaw. Aw sarta yanagkatipon silan adto sang Baay ng Tohan, yanag-inosipay silan, “Ono sang dumduman mayo, matambong ba si Isa sang pakaradyaan?” ");
INSERT INTO kqew_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kay sidto na wakto aon day sogo ng mga pangoo ng mga imam kipat yang mga Parisi na abir sino na yamatigam daw wain si Isa kinaanglan magsombong kanilan kay untak madakup nilan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, unum na allaw koman bago magsogod yang Pakaradyaan ng Paglabay kyomadto silan Isa sa Bitani daw wain paga-uya si Lasaro, yang otaw na byowi oman ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sarta adto silan sa Bitani aon yandam na paniapon para kang Isa. Si Marta yaga-aya ng pagkan aw si Lasaro sambok sang mga kaupud ni Isa sang lamisa. ");
INSERT INTO kqew_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Adon si Mariyam, kyomamang yan ng paballo na ininang sikun sang tanum na nardo na yang kadaig tunga sang litro. Mahal yani na paballo aw way dari sini. Ansinyan yabowan nan ng paballo yang siki ni Isa. Pagkatapos san itrapowan nan ng kanan logay. Na, yakarimpud da yang kaballo sang tibok baay. ");
INSERT INTO kqew_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ansinyan yagalaong si Yodas Iskariyot na sambok sang mga inindowan ni Isa na yan yang magatraydor kanan, laong nan, ");
INSERT INTO kqew_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Madyaw pa aw byarigya yani na paballo aw yang alin i-atag adto sang mga miskinan. Kay yang kantidad sinyan mag-onawa ng soweldo ng sangka otaw sa suud ng sangka toig.” ");
INSERT INTO kqew_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na, wa yan pagalaong sinyan sabap ng yamaooy yan sang mga miskinan awgaid sabap ng kawatan yan. Kay si Yodas yang yagadaa ng lasakanan ng kanilan sapi aw ya-anad yan magpangawat sikun sinyan. ");
INSERT INTO kqew_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","“Pabayai da gaid yan,” yagalaong si Isa. “Kay tyagana nan yani na paballo untak andamun nan dadaan yang kanak lawas sang paglubung kanak. ");
INSERT INTO kqew_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yang mga miskinan abay mayo kaupud, awgaid ako, di ako magapabilin adi kamayo.” ");
INSERT INTO kqew_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na, madaig yang mga Yahodi na yakadungug na iyan si Isa sa Bitani. Agaw kyomadto silan, awgaid dili gaid si Isa yang karim nilan kitaun kondi si Lasaro oman na byowi oman ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Agaw yanagka-oyon yang mga pangoo ng mga imam na apatayun oman si Lasaro. ");
INSERT INTO kqew_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kay sabap kanan madaig yang mga Yahodi na yagapangintoo kang Isa aw wa da silan apangagad kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sonod na allaw yakadungug yang kaotawan na yagatambong sang pakaradyaan na yagapaduug da si Isa sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Agaw kyomamang silan ng mga sanga ng palmera aw lyomogwa silan sikun sang syodad untak songonon nilan si Isa na yagapiyagit silan aw laong nilan, “Pojiun ta yang Tohan! Atagan gao ng kadyawan yani na syogo ng Tohan! Atagan gao ng kadyawan yang soltan sa bangsa Israil!” ");
INSERT INTO kqew_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ansinyan aon kinita ni Isa na sambok na nati ng asno aw syakayan nan. Ya-inang yani sobay sang yakasorat sang Kitab na yagalaong, ");
INSERT INTO kqew_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kamo na mga taga Siyon, ayaw kamo pagkalluk kay dyomatung da yang soltan mayo na yakasakay sang nati ng asno.” ");
INSERT INTO kqew_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sidto na wakto wa pa pakasabot yang mga inindowan ni Isa daw ono yang mana ninyan na kyatamanan. Awgaid pagbarik ni Isa adto sa sorga, yakasabot da silan na yang idto na ininang ng mga otaw yang pagtoman ng yakasorat sang Kitab makapantag kanan. ");
INSERT INTO kqew_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na, yang mga otaw na yakakita sang pagtawag ni Isa kang Lasaro sikun sang kobor kipat yang pagbowi oman kanan, silan yang yagagogod ng makapantag sinyan adto sang kadaigan na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sabap sinyan madaig yang mga otaw na yasongon kang Isa kay yakadungug silan sidtong katingaan na ininang nan. ");
INSERT INTO kqew_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ansinyan yagalaong yang mga Parisi sang matag-isa kanilan, “Na, waa day ma-inang ta! Tanawa mayo, yang kariko ng mga otaw yamagad da kanan!” ");
INSERT INTO kqew_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ansinyan aon oman mga Grik na yakadto sa Awrosalam untak magpoji sang Tohan sang wakto ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dyomood silan kang Pilip na sambok sang mga inindowan ni Isa na taga Bitsayda na sakop ng Jalil. Yagalaong silan kanan, “Kay Sir, karim gao nami mapagkita kang Isa.” ");
INSERT INTO kqew_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Agaw kyadtonan ni Pilip si Andriyas, aw silan dowa yang yakadto kang Isa aw paglaonga nilan. ");
INSERT INTO kqew_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yagalaong si Isa kanilan, “Dyomatung da yang wakto na abantogon ako na Anak ng Manosiya. ");
INSERT INTO kqew_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sa bunna-bunna na ipaglaong ko kamayo na yang amaitabo kanak mag-onawa ng pagpugas ng bini. Kong yang bini di mapugas sang lopa, magapabilin yan ng sambok gaid na bini. Awgaid kong mapugas aw malubung sang lopa na maynang patay da, matobo yan aw amamonga ng madaig. ");
INSERT INTO kqew_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yang otaw na yang pyalabi nan yang kanan ginawa, akawaan sinyan. Awgaid yang otaw na wa nan atagi ng bili yang kanan kinabowi adi sang donya, aka-aonan ng kinabowi na way kataposan. ");
INSERT INTO kqew_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sino-sino yang marim magtoman ng mga sogo ko, dait yan somonod kanak kay untak maskin wain ako, idto oman yang sogowanun ko. Aw idtong yatoman ng mga sogo ko abantogon ng kanak Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yagalaong oman si Isa, “Adon mabugat yang ginawa ko. Ono kowaw yang inangun ko? Apangayoon ko sang kanak Ama na alowasun nan ako sikun sini na wakto ng kasikotan? Dili! Kay yakani ako untak agian ko yani na kasikotan.” ");
INSERT INTO kqew_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aw yagalaong pa yan, “O kay Ama, pakitaan gao yang kabantogan ng ngaan mo.” Ansinyan aon sowara sikun sa sorga na yagalaong, “Pyakita da ko yang kabantogan ko, aw apakitaun ko oman.” ");
INSERT INTO kqew_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na, yang mga otaw na yaga-indug ansan yakadungug sidtong sowara aw yagalaong silan, “Yagalinti kowaw.” Awgaid aon kadaigan na yagalaong, “Aon malaikat na yapagbaaw kanan.” ");
INSERT INTO kqew_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Awgaid yagalaong si Isa, “Pyadungug ng Tohan yani na sowara sabap kamayo, dili sabap kanak. ");
INSERT INTO kqew_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Adon dyomatung da yang wakto na hokoman ng Tohan yang mga otaw na wa apangagad kanan. Yani oman yang wakto na amatalo da nan si Iblis na yan yang yagadato ansining donya kay amakamang da kanan yang kapatot ng pagdato. ");
INSERT INTO kqew_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Awgaid ako, kong lyansang aw pyataas da ako adto sa kros, apadodon ko kanak yang kariko ng mga otaw.” ");
INSERT INTO kqew_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yani yang pyagalaong ni Isa untak ipatigam nan daw ono yang pama-agi ng pagkamatay nan. ");
INSERT INTO kqew_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ansinyan yagalaong yang mga otaw, “Kyatigaman nami na yakasorat sang Kitab na yang Almasi di amatay. Nanga yagalaong kaw na yang Anak ng Manosiya dait ilansang aw pataasun sa kros? Sino kadi yani na Anak ng Manosiya?” ");
INSERT INTO kqew_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tyomobag si Isa aw laong nan kanilan, “Di amadogay amawaa kamayo yang allag. Agaw, pagpanaw kamo sang kapawa sarta adi pa kamayo yang allag untak di kamo adatungan ng kadugguman. Kay yang yagapanaw sang kadugguman di matigam daw wain yan makadto. ");
INSERT INTO kqew_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pagsarig kamo kanak na ako yang allag sarta adi pa ako kamayo untak mabaoy kamo ng mga otaw na sakop ng kapawa.” Paglaong nan sinyan, pyomanaw yan na way yamatigam ng akadtonan nan. ");
INSERT INTO kqew_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na, maskin madaig da yang mga katingaan na ininang ni Isa sa atobangan ng mga otaw, wa silan apangintoo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ya-inang yani untak matoman yang syorat ni Nabi Isayas na yagalaong, “Ya Tohan, nanga tagbi gaid yang yagapangintoo sang pyapayapat nami? Nanga tagbi gaid yang yakasabot na pyakita mo kanilan yang kammo kabarakat?” ");
INSERT INTO kqew_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yagalaong oman si Nabi Isayas daw nanga wa silan apangintoo kay laong nan, ");
INSERT INTO kqew_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Byota silan ng Tohan untak di silan makakita, aw pyabagsug nan yang kanilan oo untak di silan makasabot aw di silan mabarik adi kanak,” laong ng Tohan, “kay untak pakadyawon ko silan.” ");
INSERT INTO kqew_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Maynini yang pyagalaong ni Nabi Isayas kay kinita nan dadaan yang kabantogan ni Isa aw makapantag kang Isa yani na pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na, maskin maynan, madaig yang mga pangoo ng mga Yahodi na yagapangintoo kang Isa. Awgaid sabap ng yamalluk silan sang mga Parisi wa silan pagapatigam na yagapangintoo silan untak di silan palogwaun sikun sang jamaa nilan. ");
INSERT INTO kqew_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kay pyalabi nilan yang pagbantog ng mga otaw kaysang pagbantog ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ansinyan yagalaong si Isa ng matanog, “Sino-sino yang yagapangintoo kanak, dili ako gaid yang pyangintowan nan, awgaid yagapangintoo oman yan sang Tohan na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yang otaw na yakakita kanak, yakakita oman sang Tohan na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yakani ako sang donya untak mag-atag ng kapawa sang manosiya kay untak di magpabilin sang kadugguman yang maskin sino na amangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Yang otaw na yakadungug sang pyaglaongan ko awgaid di nan apangagadan, di ko yan hokoman. Kay yakani ako adi sang donya dili untak hokoman ko yang mga otaw awgaid untak lowasun ko silan. ");
INSERT INTO kqew_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Awgaid aon magahokom sidtong otaw na magatarikod kanak aw di amangintoo sang pyaglaongan ko. Yang pyaglaongan ko, idto sagaw yang magahokom kanan sang Allaw na Maori. ");
INSERT INTO kqew_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kay yang pyaglaongan ko dili sikun sang sarili ko na dumduman awgaid sikun sang Ama na yagapadaa kanak. Yan yang yagasogo kanak daw ono yang dait ko paglaong. ");
INSERT INTO kqew_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aw yamatigam ako na yang sogo nan maka-atag ng kinabowi na way kataposan. Agaw sagaw maskin ono yang pyagasogo kanak ng Ama, idto yang pyagalaong ko.” ");
INSERT INTO kqew_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ansinyan nang wa pa pagasogod yang Pakaradyaan ng Paglabay, kyatigaman dadaan ni Isa na dyomatung da yang wakto na mapanaw da yan sikun sining donya aw magabarik yan adto sang Ama. Sikun pa sang ona dakowa sang pangatayan ni Isa yang mga otaw na kanan sakop adi sining donya. Aw adon pyakita nan kanilan daw ono yang kadakowa ng looy nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pagkagabi sinyan yanagpangan si Isa aw yang mga inindowan nan. Adon, si Yodas na anak ni Simon Iskariyot, byutangan yan dadaan ni Iblis ng dumduman na magatraydor kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kyatigaman ni Isa na yatag kanan ng Ama yang kapatot makapantag sang kariko. Aw kyatigaman oman nan na sikun yan sang Tohan aw magabarik oman yan adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Agaw sarta yanagpangan pa silan, yamindug si Isa aw lobasa nan yang syapaw nan na dagom aw yagatapis ng towalya. ");
INSERT INTO kqew_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagkatapos san, yaga-obo yan ng tobig sang planggana aw yagasogod yan mag-ogas ng siki ng mga inindowan nan aw itrapowan nan ng towalya na kanan pyagatapis. ");
INSERT INTO kqew_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Adon, pagdood nan kang Simon Pitros, yagalaong si Pitros kanan, “Kay Dato, ikaw ba yang maga-ogas ng siki ko?” ");
INSERT INTO kqew_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tyomobag si Isa, “Adon wa pa kaw akatigam daw ono yang mana sini na ininang ko. Awgaid sang madatung na mga allaw akatigaman da mo.” ");
INSERT INTO kqew_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yagalaong si Pitros, “Di na di ako masogot na ikaw yang maga-ogas ng siki ko!” Tyomobag si Isa, “Kong di ko ogasan yang siki mo, way labot mo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yagalaong si Pitros, “Kay Dato, kong maynan, dili gaid ng siki ko yang ogasan mo awgaid maskin pa yang arima aw oo ko!” ");
INSERT INTO kqew_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yagalaong si Isa, “Yang otaw na yakasogbo, malinis da yang lawas nan. Siki dakoman yang kinaanglan oman ogasan. Kamo, sotti yang pangatayan mayo, awgaid dili ng kariko mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kyatigaman ni Isa daw sino yang magatraydor kanan aw sabap sinyan yagalaong yan na dili ng kariko nilan sotti. ");
INSERT INTO kqew_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na, pagkatapos nan ogasan yang siki ng mga inindowan nan, yamandagom da oman yan aw byomarik adto sang pyaga-ingkodan nan. Ansinyan yaga-osip yan kanilan, “Yakasabot kamo daw ono yang ininang ko kamayo? ");
INSERT INTO kqew_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tyawag mayo ako na Magiindoway aw Dato. Osto yan kay ako sagaw yang magiindoway aw Dato mayo. ");
INSERT INTO kqew_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, kong ako na Dato aw magiindoway mayo yang yaga-ogas ng siki mayo, dait na kamo oman maga-ogas ng siki ng kada isa kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yatagan ta kamo ng opamaan untak inangun mayo daw ono yang ininang ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sa bunna-bunna na ipaglaong ko kamayo na yang sogowanun dili labaw sang kanan amo, aw yang syogo dili labaw sang yagasogo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Adon kay kyatigaman da mayo yani na mga butang, kadyaw ng ginawa mayo kong apangagadan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na, yani na pyagalaong ko dili makapantag sang kariko mayo kay kyatigaman ko daw sino yang pinili ko. Awgaid dait na amatoman yang yakasorat sang Kitab na yagalaong, ‘Yang yaga-upud kanak koman ya-inang ng kalaban ko.’ ");
INSERT INTO kqew_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Pyagalaong ta kamo sini dadaan sang wa pa yan akaitabo kay untak aw amaitabo da, amangintoo da kamo daw sino ako. ");
INSERT INTO kqew_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sa bunna-bunna na ipaglaong ko kamayo na yang otaw na matarima sang abir sino na asogoon ko, ako oman yang atarimaun nan. Aw yang matarima kanak, matarima oman sang yagasogo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Paglaong sinyan ni Isa, mabugat yang ginawa nan aw yagalaong yan ng diretso sang mga inindowan nan, “Sa bunna-bunna na ipaglaong ko kamayo na aon sangka otaw kamayo na magatraydor kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ansinyan yanagtinanaway yang mga inindowan kay wa silan akatigam daw sino yang pyagalaong nan. ");
INSERT INTO kqew_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, yang inindowan na dakowa sang pangatayan ni Isa yaga-ingkod sang masaid kanan. ");
INSERT INTO kqew_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Isingyasan yan ni Simon Pitros untak osipun nan si Isa daw sino yang pyagalaong nan. ");
INSERT INTO kqew_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agaw yagasandig idtong inindowan kang Isa aw osipa nan, “Kay Dato, sino yang magatraydor kammo?” ");
INSERT INTO kqew_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tyomobag si Isa, “Yang otaw na atagan ko sini na pan pagkatapos ko daritan sang sawsawan, yan yang magatraydor kanak.” Ansinyan dyarit nan yang pan aw yatag nan kang Yodas na anak ni Simon Iskariyot. ");
INSERT INTO kqew_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagdawat ni Yodas ng pan, syuudan dayon yan ni Iblis. Yagalaong kanan si Isa, “Unda, pagdari aw inanga yang karim mo inangun.” ");
INSERT INTO kqew_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Awgaid way maskin isa sang mga inindowan nan na yakasabot daw nanga maynidto yang pyagalaong nan kang Yodas. ");
INSERT INTO kqew_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yang kadaigan kanilan yagadumdum na syogo nan si Yodas untak magbili ng pyagakinaanglan nilan para sang pakaradyaan atawa untak mag-atag ng sidoka adto sang mga miskinan kay si Yodas yang yagadaa ng lasakanan ng sapi nilan. ");
INSERT INTO kqew_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na, pagkatapos ni Yodas koman ng pan, lyomogwa dayon yan. Gabi da sidto na wakto. ");
INSERT INTO kqew_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagpanaw ni Yodas, yagalaong si Isa, “Adon ipakita da yang kabantogan ko na Anak ng Manosiya. Aw ipakita oman yang kabantogan ng Tohan sabap kanak. ");
INSERT INTO kqew_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na, kong pyakita da yang kabantogan ng Tohan sabap kanak, ipakita oman ng Tohan yang kabantogan ko na Anak ng Manosiya, aw inangun dayon nan. ");
INSERT INTO kqew_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mga lomon ko, di da ako magadogay adi kamayo. Panganapun mayo ako, awgaid mag-onawa ng pyagalaong ko sang mga pangoo ng mga Yahodi, pagalaongon ta kamo adon na di kamo makakadto sang akadtonan ko. ");
INSERT INTO kqew_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Adon aon bago na sogowan na i-atag ko kamayo na pagsikaoyay kamo. Mag-onawa sang looy ko kamayo dait na maooy oman kamo sang kada isa kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kay kong magsikaoyay kamo, akatigaman ng kariko ng mga otaw na kamo mga inindowan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yaga-osip si Simon Pitros, “Kay Dato, wain kaw makadto?” Tyomobag si Isa, “Di kaw maka-agad kanak sang akadtonan ko adon. Awgaid sang madatung na mga allaw makasonod da kaw kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yaga-osip oman si Pitros, “Kay Dato, nanga di ako maka-agad kammo adon? Andam ako magpakamatay para kammo.” ");
INSERT INTO kqew_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yagalaong si Isa, “Andam ba kaw magpakamatay para kanak? Sa bunna-bunna na ipaglaong ko kammo na sang di pa magatagaok yang laboyo, makatoo kaw maglaong na wa kaw akilaa kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ansinyan yagalaong si Isa sang mga inindowan nan, “Ayaw kamo pagkarido. Pagsarig sang Tohan aw pagsarig oman kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adto sang baay ng kanak Ama madaig yang mga kowarto. Kong di yan ng bunna, di ako magalaong kamayo na makadto da ako untak andamun ko yang paga-uyaan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na, pagkatapos aw ma-andam da ko, magabarik ako adi aw pa-agadun ta kamo kay untak daw wain ako, adto oman kamo. ");
INSERT INTO kqew_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aw kyatigaman mayo yang daan paduug sang akadtonan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ansinyan yagalaong si Tomas kanan, “Kay Dato, wa nami akatigami daw wain kaw makadto. Monono da nami katigaman yang daan?” ");
INSERT INTO kqew_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tyomobag si Isa, “Ako yang daan, yang kabunnaan aw yang kinabowi. Way makakadto sang Ama kong dili pina-agi kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kong kinilaa mayo ako, kinilaa oman mayo yang kanak Ama. Aw sikun adon kinilaa da mayo yan aw kinita da mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yagalaong si Pilip, “Kay Dato, pakitaan gao kanami yang Ama. Aw osto da idto para kanami.” ");
INSERT INTO kqew_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yagalaong si Isa, “Pilip, dogay da ako adi kamayo, awgaid wa pa kaw akilaa kanak? Sino-sino yang yakakita kanak, yakakita oman sang Ama. Nanga yagalaong kaw na ‘pakitaan gao kanami yang Ama?’ ");
INSERT INTO kqew_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nanga kaw, kay Pilip, wa kaw apangintoo na yagakasambok kami sang Ama ko? Yang pyaga-indo ko kamayo dili sikun kanak. Awgaid yang Ama na idi kanak, yan yang yaga-inang ng mga gawbuk na ininang ko. ");
INSERT INTO kqew_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pangintowi mayo yang pyagalaong ko na iyan ako sang Ama aw yang Ama idi kanak. Kong di kamo mangintoo sang pyaglaongan ko, na, pagpangintoo da kamo sabap sang mga katingaan na ininang ko. ");
INSERT INTO kqew_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sa bunna-bunna na ipaglaong ko kamayo na sino-sino yang mangintoo kanak, maka-inang yan ng ininang ko. Aw labaw pa sinyan yang ma-inang nan kay magabarik ako adto sang kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aw abir ono yang apangayoon mayo sang ngaan ko inangun ko kay untak mabantog yang Ama sabap kanak na Anak nan. ");
INSERT INTO kqew_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sagaw, kong mangayo kamo sang ngaan ko, abir ono yang apangayoon mayo, inangun ko.” ");
INSERT INTO kqew_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yagalaong oman si Isa, “Kong pyakadakowa mayo ako sang pangatayan mayo, apangagadan mayo yang mga sogowan ko. ");
INSERT INTO kqew_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aw pangayoon ko sang Ama na atagan nan kamo ng isa koman na Magtatambagay na poli kanak na magapabilin kamayo taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yani na Magtatambagay yang Nyawa ng Tohan na maga-indo kamayo ng kabunnaan. Yang mga otaw na kadodonya gaid yang dumduman di makatarima sang Nyawa ng Tohan kay wa nilan akitaa aw wa oman nilan akilaa. Awgaid kamo, yakilaa kamo kanan kay iyan yan kamayo aw maga-uya yan sa suud ng pangatayan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na, maskin mapanaw da ako, di ta kamo abiyaan kay magabarik oman ako adi kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Di amadogay di da ako akitaun ng mga otaw adi sang donya. Awgaid kamo, makakita oman kamo kanak. Sabap ng bowi ako taman sa taman, kamo oman amabowi taman sa taman. ");
INSERT INTO kqew_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pagdatung sinyan na allaw, akatigaman da mayo na yagakasambok kami sang kanak Ama aw mag-onawa sinyan, yagakasambok ako kamayo aw kamo oman yagakasambok kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sino-sino yang matarima sang mga sogowan ko aw apangagadan nan, yan yang otaw na yagapakadakowa kanak sang kanan pangatayan. Aw yang otaw na yagapakadakowa kanak sang kanan pangatayan, dakowa oman sang pangatayan ng kanak Ama. Mag-onawa sinyan, dakowa yan sang kanak pangatayan aw ipatigam ko kanan daw sino ako.” ");
INSERT INTO kqew_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ansinyan yagalaong si Yodas, awgaid dili ni Yodas Iskariyot, laong nan, “Kay Dato, nanga kami gaid yang apatigamun mo makapantag sang sarili mo aw dili yang kariko ng mga otaw?” ");
INSERT INTO kqew_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tyomobag si Isa, “Sino-sino yang yagapakadakowa kanak sang kanan pangatayan, apangagadan nan yang pyaglaongan ko. Dakowa yan sang pangatayan ng kanak Ama, aw yang kanak Ama aw ako maga-uya adto sang pangatayan nan. ");
INSERT INTO kqew_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sino-sino yang wa pagapakadakowa kanak sang kanan pangatayan, di nan apangagadan yang pyaglaongan ko. Yani na pyaglaongan na pyagadungug mayo dili sikun kanak awgaid sikun sang Ama na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yani na mga butang pyagalaong ko kamayo sarta ini pa ako kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Awgaid yang Magtatambagay, yang Nyawa ng Tohan na ipadaa kamayo ng Ama na poli kanak, yan yang maga-indo kamayo ng kariko ng mga butang aw magapadumdum kamayo ng kariko ng pyagalaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kalinaw sang pangatayan aw dumduman mayo yang ibilin ko kamayo. Yani na kalinaw yagasikun kanak aw di yan mag-onawa ng kalinaw na ika-atag ng mga otaw adi sang donya. Agaw, ayaw kamo pagkarido aw ayaw oman kamo pagkalluk. ");
INSERT INTO kqew_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Pyagalaong da ta kamo na mapanaw ako aw magabarik oman ako adi kamayo. Kong dakowa ako sang pangatayan mayo, amasowat gao kamo na makadto ako sang kanak Ama kay labaw pa yan kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pyagalaong da ta kamo sini sang wa pa yan akaitabo kay untak aw amaitabo da, amangintoo da kamo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na, di da ko pataasun yang ipaglaong ko kamayo kay madari da domatung yang pangoo na yagadato ansining donya. Awgaid way kapatot nan kanak. ");
INSERT INTO kqew_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Awgaid maskin maynan, atogotan ko yang amaitabo kanak untak katigaman ng mga otaw adi sang donya na pyakadakowa ko yang kanak Ama aw inangun ko yang kariko ng pyagasogo nan kanak. “Bita da. Mapanaw da kita.” ");
INSERT INTO kqew_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ansinyan yagalaong oman si Isa sang mga inindowan nan, “Ako yang bunna na ponowan ng tanum aw yang kanak Ama yang yaga-atiman sinyan. ");
INSERT INTO kqew_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yang kariko ng mga sanga na di amamonga, otodon ng kanak Ama. Awgaid yang kariko ng mga sanga na yamamonga, atotowan aw alinisan nan untak magkadaig yang bonga. ");
INSERT INTO kqew_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamo, ilinisan da kamo sabap sang pyaga-indo ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pagpabilin kamo adi kanak aw ako magapabilin ansan kamayo. Yang sanga na di magapabilin sang ponowan, di amamonga. Mag-onawa sinyan, di kamo amamonga kong di kamo magapabilin adi kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Pyadayon ni Isa yang pasombingay, laong nan, “Ako yang ponowan ng tanum aw kamo yang mga sanga. Sino-sino yang magapabilin adi kanak aw ako magapabilin adto kanan, amamonga ng madaig. Awgaid kong mabiya kamo kanak, way ama-inang mayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sino-sino yang di magapabilin adi kanak mag-onawa yan ng sanga na idami aw amagango. Yang mayninyan na mga sanga atiponon aw damian adto sang atoon untak sonogon. ");
INSERT INTO kqew_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Awgaid kong abay kamo magpabilin adi kanak aw yang mga pyaglaongan ko magapabilin sang pangatayan mayo, i-atag ko kamayo yang abir ono na apangayoon mayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kong amamonga kamo ng madaig, amabantog yang kanak Ama. Aw ansinyan akatigaman na kamo bunna na mga inindowan ko. ");
INSERT INTO kqew_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pyakadakowa ako ng Ama. Mag-onawa sinyan kyaoyan ta kamo. Agaw pagpabilin kamo sang looy ko. ");
INSERT INTO kqew_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kong apangagadan mayo yang mga sogowan ko, magapabilin kamo sang looy ko mag-onawa kanak na pyangagadan ko yang mga sogowan ng kanak Ama aw yagapabilin ako sang looy nan. ");
INSERT INTO kqew_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Pyagalaong ta kamo sini untak ka-aonan kamo ng kasowat na mag-onawa ng kasowat ko aw untak makomplito yang kasowat mayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yani yang sogo ko kamayo na pagsikaoyay kamo mag-onawa ng looy ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Way looy na labaw pa sang looy ng otaw na magapakamatay para sang mga amigo nan. ");
INSERT INTO kqew_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamo, mga amigo ta kamo kong apangagadan mayo yang mga sogo ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Di da ta kamo tawagun na mga sogowanun kay yang sogowanun wa akatigam daw ono yang inangun ng amo nan. Awgaid kamo, pyagatawag ta kamo na mga amigo ko kay pyatigam ta kamo ng kariko ng pyagadungug ko adto sang kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dili kamo yang yagapili kanak, awgaid ako yang yagapili kamayo aw pinili ta kamo untak mamonga kamo aw yang bonga mayo magapabilin taman sa taman. Aw ansinyan abir ono yang apangayoon mayo adto sang Ama sang ngaan ko, i-atag nan kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na, yani yang sogo ko kamayo na pagsikaoyay kamo.” ");
INSERT INTO kqew_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yagalaong oman si Isa sang mga inindowan nan, “Ayaw kamo pagkatingaa kong adumutan kamo ng mga otaw na kadodonya gaid yang dumduman. Dumduma da gaid mayo na ako yang ona na dyumutan nilan. ");
INSERT INTO kqew_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kong mag-onawa kamo ng mga otaw na kadodonya gaid yang dumduman, kyallinian gao kamo nilan. Awgaid tuna kamo kay pinili ta kamo aw pyagalain ta kamo sinyan na mga otaw. Agaw sagaw dyumutan kamo nilan. ");
INSERT INTO kqew_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na, dumduma mayo yang pyagalaong ko kamayo na yang sogowanun dili labaw sang amo nan. Kong pyasikotan nilan ako, kamo da oman yang apasikotan nilan. Kong pyangagadan nilan yang mga pyaglaongan ko, apangagadan oman nilan yang mga pyaglaongan mayo. ");
INSERT INTO kqew_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yang kariko ninyan inangun nilan kamayo sabap sang pagpangintoo mayo kanak kay wa nilan akilaa yang Tohan na yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kong wa ako akani sang donya aw maga-indo kanilan ng kabunnaan, way gao dosa nilan. Awgaid adon, di silan makapaglaong na way dosa nilan kay pyatigam ko kanilan yang kabunnaan. ");
INSERT INTO kqew_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sino-sino yang yagadumut kanak, yagadumut oman sang kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kong wa nilan akitaa yang mga katingaan na ininang ko na wa aka-inang ng abir sino, way gao dosa nilan. Awgaid kinita da nilan, aw maskin maynan, dyumutan nilan ako aw yang kanak Ama. ");
INSERT INTO kqew_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Awgaid ya-inang yani untak matoman yang yakasorat sang Kitab na yagalaong, ‘Dyumutan ako nilan na waa sabay pyagasabapan.’ ” ");
INSERT INTO kqew_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Laong oman ni Isa, “Ipadaa ko kamayo yang Magtatambagay, yang Nyawa ng Tohan na maga-indo kamayo ng kabunnaan. Makani yan sikun sang Ama aw pagdatung nan, magalaong yan ng makapantag kanak. ");
INSERT INTO kqew_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kamo oman, dait kamo magpatigam sang mga otaw ng makapantag kanak kay sikun sang pirmiro yamagad kamo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na, yang kariko sinyan yang pyagalaong ko kamayo untak di mawaa yang pagpangintoo mayo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sang madatung na mga allaw apalogwaun kamo sikun sang jamaa ng mga Yahodi. Madatung sagaw yang wakto na sino-sino yang magapatay kamayo magadumdum na pyangagadan nilan yang karim ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yani yang inangun nilan kamayo kay wa silan akilaa sang Ama aw wa oman silan akilaa kanak. ");
INSERT INTO kqew_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pyagalaong ta kamo sini kay untak pagdatung ng wakto na inangun da nilan yani kamayo, akadumduman mayo yang pyagalaong ko kamayo. Singaon wa ta kamo paglaonga nini na mga butang kay iyan pa ako kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Awgaid adon magabarik ako sang yagasogo kanak. Awgaid way maskin sambok kamayo na yaga-osip daw wain ako makadto. ");
INSERT INTO kqew_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aw adon na pyagalaong da ta kamo, mabugat yang ginawa mayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Awgaid bunna yani na ipaglaong ko kamayo na mas madyaw kamayo na mapanaw ako. Kay kong di ako mapanaw, di makani yang Magtatambagay. Awgaid kong mapanaw ako, ipadaa ko yan kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pagdatung ng Magtatambagay, ipatigam nan sang mga otaw na wa apangagad sang Tohan na sayup yang dumduman nilan makapantag sang dosa, ipatigam nan kanilan daw ono yang pama-agi ng Tohan na ma-inang ng matorid yang manosiya, aw ipatigam nan kanilan daw ono yang paghokom ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ipatigam nan sang mga otaw na yakadosa silan kay wa silan apangintoo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipatigam nan kanilan na mapakay silan ma-inang ng matorid kay makadto ako sang Ama aw di da mayo ako akitaun. ");
INSERT INTO kqew_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aw ipatigam nan kanilan makapantag sang paghokom ng Tohan na yokoman da si Iblis, yang pangoo na yagadato ansining donya. ");
INSERT INTO kqew_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na, madaig pa gao yang ipaglaong ko kamayo awgaid di pa mayo masabot adon. ");
INSERT INTO kqew_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Awgaid pagdatung ng Nyawa ng Tohan na yan yang maga-indo ng kabunnaan, atabangan nan kamo pagsabot sang kariko ng kabunnaan. Yang paga-indo nan dili sikun kanan, awgaid daw ono yang dyungug nan, idto gaid yang ipaglaong nan kamayo. Aw ipatigam nan kamayo daw ono yang amaitabo sang madatung na mga allaw. ");
INSERT INTO kqew_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Atagan nan ako ng kabantog kay sikun kanak yang ipatigam nan kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yang maskin ono na kanang Ama, kanak oman. Agaw sagaw pyagalaong ko kamayo na yang kariko ng ipatigam kamayo ng Nyawa ng Tohan yagasikun kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yagalaong oman si Isa, “Di amadogay di da mayo ako akitaun, awgaid di oman amadogay aw akitaun da oman mayo ako.” ");
INSERT INTO kqew_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na, yanag-inosipay da yang kadaigan ng mga inindowan nan, laong nilan, “Ono yang karim nan ipasabot sini na pyagalaong nan na di amadogay di da natun yan akitaun, aw di oman amadogay aw akitaun da oman natun? Aw yagalaong pa yan na amaitabo yan sabap ng makadto yan sang Ama. ");
INSERT INTO kqew_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ono kadi yang karim nan ipasabot sang di amadogay? Di gaid kita makasabot sang pyagalaong nan!” ");
INSERT INTO kqew_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, kyatigaman ni Isa na karim gao mag-osip kanan yang mga inindowan nan, agaw yagalaong yan kanilan, “Di ba yanag-inosipay kamo daw ono yang karim ko ipasabot sang pyagalaong ko na di amadogay di da mayo ako akitaun, aw di oman amadogay aw akitaun da oman mayo ako? ");
INSERT INTO kqew_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sa bunna-bunna na ipaglaong ko kamayo na yang mga otaw na wa apangagad sang Tohan amasowat, awgaid kamo magatiyao sabap sang kabugat ng ginawa mayo. Awgaid amawaa oman yang kabugat ng ginawa mayo aw amabaoy ng kasowat. ");
INSERT INTO kqew_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mag-onawa yan sang sambok na bobay na yagapamati kay dyomatung da yang wakto na amanganak da yan. Awgaid pagkaotaw da ng isu, akaringawan da nan yang kairap nan sabap ng yamasowat yan na yaotaw da yang isu. ");
INSERT INTO kqew_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mag-onawa sinyan yang kabutang mayo. Adon mabugat yang ginawa mayo, awgaid magakita oman kita. Aw ansinyan amasowat kamo aw way maskin sino na maka-agaw ng kasowat mayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na, pagdatung sinyan na allaw, di da kinaanglan na maga-osip pa kamo kanak ng maskin ono. Sa bunna-bunna na ipaglaong ko kamayo na abir ono yang apangayoon mayo sang Ama sang ngaan ko, i-atag nan kamayo. ");
INSERT INTO kqew_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sikun singaon sampay adon wa pa kamo pakapangayo ng maskin ono sang ngaan ko. Agaw, pangayo kamo kay atagan kamo aw ansinyan amakomplito yang kasowat mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yagalaong oman si Isa, “Pyagalaong ta kamo sini na mga butang pina-agi sang mga pasombingay. Awgaid madatung yang wakto na di da ako magapasombingay, awgaid diretso da yang ipaglaong ko kamayo makapantag sang Ama. ");
INSERT INTO kqew_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pagdatung sinyan na allaw, kamo da yang amangayo adto sang Ama sang ngaan ko. Di da kinaanglan na ako pa yang amangayo adto sang Ama para kamayo ");
INSERT INTO kqew_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kay kyaoyan kamo ng Ama. Dakowa kamo sang pangatayan nan kay pyakadakowa mayo ako sang pangatayan mayo aw yagapangintoo kamo na ako yagasikun sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bunna sagaw na yagasikun ako sang Ama aw yakani ako sang donya. Aw adon mapanaw da ako sining donya aw magabarik ako adto sang Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ansinyan yagalaong yang mga inindowan ni Isa, “Adon diretso da yang pyagalaong mo aw di da pina-agi sang pasombingay. ");
INSERT INTO kqew_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yamatigam da kami adon na kyatigaman mo yang kariko ng mga butang aw di da kinaanglan na maga-osip pa kami kammo. Sabap sinyan yagapangintoo kami na ikaw yagasikun sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yagalaong si Isa, “Yagapangintoo da kamo kanak adon? ");
INSERT INTO kqew_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Awgaid timani mayo na madatung yang wakto aw ini da yan adon na amangkakanat-kanat kamo obos. Managsi-ori da kamo sang matag baay mayo aw abiyaan mayo ako. Awgaid maskin maynan, di ako ng sangka otaw da ko kay yang Ama yagapabilin adi kanak. ");
INSERT INTO kqew_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Na, pyagalaong ta kamo sini na mga butang untak ka-aonan kamo ng kalinaw sabap sang pagkasambok mayo kanak. Bunna na adi sang donya apasikotan kamo. Awgaid pabagsuga mayo yang pangatayan mayo kay dyaog da ko yang kaatan adi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkatapos ni Isa maglaong sinyan, ya-angad yan adto sang langit aw yagadowaa, laong nan, “O kay Ama, dyomatung da yang wakto na pyagakahanda mo. Ipakita mo gao adon yang kabantogan ko na Anak mo untak ipakita ko oman yang kabantogan mo. ");
INSERT INTO kqew_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kay yatagan mo ako ng kapatot makapantag sang kariko ng manosiya untak atagan ko ng kinabowi na way kataposan yang kariko ng mga otaw na yatag mo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aw yani yang kinabowi na way kataposan na yamatigam silan na ikaw gaid yang bunna na Tohan aw yamatigam oman silan na ako yang Almasi na syogo mo adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pyakita ko yang kabantogan mo adi sang donya kay tyapos da ko yang gawbuk na pya-inang mo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aw adon, kay Ama, pagbarik ko ansan kammo, atagi oman ako ng kabantogan mag-onawa ng kabantogan ko sidtong wakto na ansan pa ako kammo nang wa pa akabaoy yang donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pyatigam ko daw sino kaw adto sang mga otaw na pinili mo sikun sining donya aw yatag mo kanak. Kammo da silan singaon aw yatag mo silan kanak. Aw pyangagadan nilan yang pyaglaongan mo. ");
INSERT INTO kqew_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aw adon kyatigaman nilan na yang kariko ng yatag mo kanak yagasikun kammo. ");
INSERT INTO kqew_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kay pyaga-indo ko kanilan yang pyagalaong mo kanak aw tyarima nilan yang idto. Kyatigaman da sagaw nilan na ako yagasikun kammo aw yagapangintoo silan na ikaw yang yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Adon magadowaa ako para kanilan. Yani na pagdowaa ko dili para sang kariko ng manosiya awgaid para sang mga otaw na yatag mo kanak kay kammo da silan. ");
INSERT INTO kqew_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yang kariko na kanak, kammo oman aw yang kariko na kammo, kanak oman. Aw yamabantog ako sabap kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Di da ako magadogay ansining donya kay magabarik da ako ansan kammo. Awgaid silan, magapabilin pa silan ansining donya. O kay Ama na labi na sotti, bantayi silan untak mabantog yang ngaan mo na ngaan ko oman. Bantayi silan untak abay silan magkasambok mag-onawa ng pagkasambok natun. ");
INSERT INTO kqew_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sarta yaga-upud pa ako kanilan, byantayan aw yatiman ko silan untak mabantog yang ngaan mo na ngaan ko oman. Aw way maskin isa kanilan na yawaa adi kanak yatabiya sidtong otaw na pyagakahanda mo na asiksaun sang narka kay untak matoman yang yakasorat sang Kitab. ");
INSERT INTO kqew_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Adon madari da ako magbarik ansan kammo, awgaid sarta ini pa ako sang donya pagalaongon ko silan sini na mga butang untak makomplito yang kasowat nilan mag-onawa ng kasowat ko. ");
INSERT INTO kqew_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pyatigam ko kanilan yang pyaglaongan mo aw dyumutan da silan ng mga otaw na wa apangagad kammo kay di da silan ng mag-onawa kanilan. Kay mag-onawa silan kanak na dili ako sakop ng donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Di ako amangayo na akamangun mo silan sining donya, awgaid yani yang pangayo ko na bantayan mo silan untak di silan daogon ni Iblis na pyagasikunan ng kariko ng kaatan. ");
INSERT INTO kqew_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yang mga otaw na sakop mo mag-onawa kanak kay wa silan apangagad sang dumduman ng kadaigan na mga otaw adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pagalainun mo gao silan untak magpangagad kammo pina-agi sang pyaglaongan mo na maga-indo kanilan ng kabunnaan. ");
INSERT INTO kqew_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mag-onawa ng pagsogo mo kanak adi sang donya syogo ko silan untak magpayapat sang mga otaw adi sang donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","I-atag ko yang kinabowi ko sabap kanilan untak pagalainun oman silan untak magpangagad kammo. ");
INSERT INTO kqew_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Adon, dili gaid ng mga inindowan ko yang pagadowaan ko awgaid yang mga otaw oman na amangintoo kanak sabap sang pagpayapat nilan. ");
INSERT INTO kqew_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O kay Ama, pangayoon ko na magakasambok yang dumduman aw pangatayan ng kariko nilan na mag-onawa ng pagkasambok natun na ikaw idi kanak, aw ako iyan kammo. Mag-onawa oman ninyan, magakasambok gao silan kanatun untak mangintoo yang mga otaw adi sang donya na ikaw yang yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yatag ko kanilan yang kabantogan na yatag mo kanak untak magkasambok silan mag-onawa kanatun na sambok da kita. ");
INSERT INTO kqew_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yagakasambok ako kanilan aw ikaw yagakasambok kanak. Amakomplito gao yang pagkasambok ng dumduman aw pangatayan nilan untak katigaman ng mga otaw adi sang donya na ikaw yang yagasogo kanak aw katigaman oman nilan na yang looy mo kanilan mag-onawa ng looy mo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O kay Ama, karim ko na yang mga otaw na yatag mo kanak maka-upud kanak adto sa sorga untak kitaun nilan yang kabantogan ko na idto yang kabantogan na yatag mo kanak sabap ng pyakadakowa da mo ako nang wa pa akabaoy yang donya. ");
INSERT INTO kqew_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O kay Ama, ikaw gaid yang matorid. Yang mga otaw adi sang donya wa akilaa kammo. Awgaid ako, kinilaa ta kaw aw kyatigaman ng mga yagapangintoo kanak na ikaw yang yagasogo kanak. ");
INSERT INTO kqew_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pyatigam ko kanilan daw sino kaw aw padayonon ko yang pagpatigam ko kanilan untak yang looy nilan sang matag-isa mag-onawa ng looy mo kanak aw untak abay ako magpabilin sang pangatayan nilan.” ");
INSERT INTO kqew_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ansinyan pagkatapos magdowaa ni Isa, pyomanaw yan upud sang mga inindowan nan aw tyomaripag silan sang Tobig ng Kidron. Adto sa dipag kyomadto silan sang sambok na tanumanan. ");
INSERT INTO kqew_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Adon, si Yodas na yan yang yagatraydor kang Isa, kyatigaman nan idtong tanumanan kay yabay managkatipon ansan si Isa aw yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Agaw kyomadto si Yodas sidtong tanumanan na aon pyaga-agad nan na sangka panon ng mga sondao na taga Roma aw mga gowardya sang Baay ng Tohan na syogo ng mga pangoo ng mga imam aw yang mga Parisi. Aon daa nilan na mga saasa, mga lampara aw mga armas. ");
INSERT INTO kqew_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Adon si Isa, kyatigaman nan yang kariko ng amaitabo kanan. Agaw, pagdatung ng mga sondao aw gowardya, syongon nan silan aw yosip nan, “Sino yang yanap mayo?” ");
INSERT INTO kqew_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tyomobag silan, “Si Isa na taga Nasarit.” Yagalaong si Isa, “Ako ingidto.” Na, si Yodas na yagatraydor kang Isa, yamindug ansan upud sang mga sondao aw gowardya. ");
INSERT INTO kqew_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Paglaong ni Isa na “Ako ingidto,” yamatras silan aw yamangkatomba sang lopa. ");
INSERT INTO kqew_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yosip da oman silan ni Isa, laong nan, “Sino agaw yang yanap mayo?” Tyomobag oman silan, “Si Isa na taga Nasarit.” ");
INSERT INTO kqew_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yagalaong si Isa, “Pyagalaong da ta kamo na ako ingidto. Kong ako yang yanap mayo, pabayai da gaid yani na mga kaupudanan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yani yang pyagalaong ni Isa untak matoman yang pyaglaongan nan sang pagdowaa nan, “O kay Ama, wa akawaa kanak yang maskin isa sang mga otaw na yatag mo kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ansinyan gyabot ni Simon Pitros yang lodyo na kanan tyakos aw tinibas nan yang sogowanun ng Dakowa na Imam. Aw yang karinto na taringa nan ya-otod. Yang ngaan nidtong sogowanun si Malkos. ");
INSERT INTO kqew_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yagalaong si Isa kang Pitros, “Barikan yang kammo lodyo sang tagob! Yagadumdum ba kaw na di ko pagsabaran yang kasikotan na pyagakahanda kanak ng Ama?” ");
INSERT INTO kqew_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ansinyan dyakup si Isa ng mga sondao na taga Roma kipat yang kapitan nilan upud sang mga gowardya na bangsa Yahodi aw gyapos nilan. ");
INSERT INTO kqew_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pagkatapos san dyaa nilan mona yan adto kang Anas, yang ogangan ni Kayapas na yan yang Dakowa na Imam sinyan na toig. ");
INSERT INTO kqew_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayapas yang idtong yagatambag sang mga pangoo ng mga Yahodi na mas madyaw na yang sambok na otaw gaid yang amatay kaysang kariko ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, si Simon Pitros aw yang sambok oman na inindowan yagasonod kang Isa. Yang inyan na inindowan kinilaa ng Dakowa na Imam, agaw yakasuud yan upud kang Isa sang pamanag ng baay ng Dakowa na Imam. ");
INSERT INTO kqew_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Awgaid si Pitros yamabilin adto sa logwa apit sang powertaan. Ansinyan yalogwa da oman yang inindowan na kinilaa ng Dakowa na Imam aw pagkatapos nan mapagbaaw sang bobay na yagabantay sang powertaan pyasuud nan si Pitros. ");
INSERT INTO kqew_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ansinyan yagalaong idtong bobay kang Pitros, “Di ba inindowan kaw nidtong otaw na dyakup nilan?” Tyomobag si Pitros, “Dili.” ");
INSERT INTO kqew_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Adon, yang mga sogowanun aw yang mga gowardya yadook ng oring kay maniki sidto na gabi. Yaga-indug silan sang palibot ng atoon untak kapasowan silan. Na, dyomood si Pitros kanilan untak kapasowan oman yan. ");
INSERT INTO kqew_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ansinyan yosip si Isa ni Anas, na dati na Dakowa na Imam, makapantag sang mga inindowan nan kipat yang pyaga-indo nan sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tyomobag si Isa, “Klaro yang pag-indo ko sang mga otaw kay yabay ako mag-indo adto sang mga pagsasambayangan aw sang Baay ng Tohan na ansan yagakatipon yang kariko ng mga Yahodi. Way pyaga-indo ko ng sikrito. ");
INSERT INTO kqew_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nanga ako yang yosip mo makapantag sang pyaga-indo ko? Madyaw pa aw osipun mo yang mga otaw na yakadungug kanak kay kyatigaman nilan daw ono yang pyaga-indo ko kanilan.” ");
INSERT INTO kqew_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na, paglaong sinyan ni Isa, syampal yan ng sambok na gowardya na yaga-indug sang masaid kanan aw laong nan kanan, “Way addat mo. Ayaw pagtobaga yang Dakowa na Imam ng mayninyan!” ");
INSERT INTO kqew_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tyomobag si Isa, “Kong aon pyagalaong ko na maat, ipatigam mo gao sang kariko ng mga otaw adi sang hokomanan daw ono yang sayup ko. Awgaid kong madyaw yang pyagalaong ko, na, nanga syampal mo ako?” ");
INSERT INTO kqew_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ansinyan pyadaa ni Anas si Isa na gyapos pa adto kang Kayapas na yan yang Dakowa na Imam sinyan na toig. ");
INSERT INTO kqew_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, sarta yaga-indug pa si Simon Pitros adto sang masaid sa atoon untak kapasowan yan, yosip yan ng mga otaw, laong nilan, “Di ba ikaw oman yang sambok na inindowan sidtong otaw?” Awgaid yagalaong si Pitros, “Dili oy!” ");
INSERT INTO kqew_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ansinyan yosip oman yan ng sambok na sogowanun ng Dakowa na Imam na parinti nidtong otaw na tinibasan ni Pitros ng taringa, laong nan, “Di ba kinita ta kaw adto sang tanumanan na yamagad kaw kang Isa?” ");
INSERT INTO kqew_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na, yagalaong da oman si Pitros na dili kono yan ng inindowan nan. Aw sidto na wakto yagatagaok yang laboyo. ");
INSERT INTO kqew_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Adon, nang masuum da ng kaamdag dyaa nilan si Isa sikun sang baay ni Kayapas adto sang palasyo ng gobirnador na taga Roma. Awgaid wa asuud yang mga pangoo ng mga Yahodi sang palasyo ng gobirnador kay sobay sang kabatasanan nilan amabatar kono silan kong somuud silan sang baay ng dili ng Yahodi. Aw kong amabatar silan sidto na allaw, di da silan makakan ng kandori sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sabap sinyan lyomogwa si Pilato adto kanilan aw yaga-osip yan daw ono yang kaso nilan sini na otaw. ");
INSERT INTO kqew_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tyomobag silan, “Kong wa yan pakadosa, wa gao nami adaa adi kammo.” ");
INSERT INTO kqew_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yagalaong si Pilato, “Daa mayo yan aw kamo da yang magahokom kanan sobay sang Hokoman mayo.” Awgaid yagalaong yang mga pangoo ng mga Yahodi, “Waa sabay kapatot nami paghokom na apatayun yang sambok na otaw.” ");
INSERT INTO kqew_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na, ya-inang yang kariko sinyan untak matoman yang pyagalaong ni Isa daw ono yang pama-agi ng pagkamatay nan. ");
INSERT INTO kqew_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ansinyan syomuud da oman si Pilato sang palasyo aw pyatawag nan si Isa aw yosip nan, “Ikaw ba yang soltan ng mga Yahodi?” ");
INSERT INTO kqew_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yagalaong si Isa, “Yan na osip sikun ba kammo atawa pyagalaong kaw ng kadaigan makapantag kanak?” ");
INSERT INTO kqew_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yagalaong si Pilato, “Sang pagtanaw mo, Yahodi ako? Yang mga imamanwa mo aw yang mga pangoo ng mga imam, silan yang yagadaa kammo adi kanak. Ono kadi yang dosa mo?” ");
INSERT INTO kqew_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tyomobag si Isa, “Yang kanak pyagdatowan dili ng adi sining donya. Kay kong adi sining donya yang pyagdatowan ko, malaban gao yang mga yagapangagad kanak untak di ako madakup ng mga pangoo ng mga Yahodi. Awgaid, yang kabunnaan, dili ng adi sining donya yang pyagdatowan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yagalaong si Pilato, “Kong maynan, soltan kaw!” Yagalaong si Isa, “Na, pyagalaong da mo na soltan ako. Awgaid yakani ako sining donya aw yagapakaotaw ako untak ipatigam ko yang kabunnaan. Aw sino-sino yang marim magpangagad sang kabunnaan, amaningug sang pyaglaongan ko.” ");
INSERT INTO kqew_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yagalaong si Pilato, “Ono kadi yang kabunnaan?” Paglaong ninyan ni Pilato, lyomogwa da oman yan adto sang mga Yahodi aw laong nan kanilan, “Way kinita ko na dosa na dait yan hokoman. ");
INSERT INTO kqew_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Awgaid aon kabatasanan mayo na kada Pakaradyaan ng Paglabay palogwaun ko yang sambok na piniriso. Na, karim mayo na apalogwaun ko yang soltan ng mga Yahodi?” ");
INSERT INTO kqew_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yagapiyagit da yang mga otaw aw laong nilan, “Dili yan! Si Barabas yang palogwaa!” Na, si Barabas sambok na rebelde. ");
INSERT INTO kqew_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ansinyan syogo ni Pilato na abadasan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagkatapos san kyomamang yang mga sondao ng mga sanga ng kaoy na soksokon aw ininang nilan ng korona aw byutang nilan sang oo ni Isa. Aw pyandagoman oman nilan yan ng joba na mapowa na mag-onawa ng dagom ng soltan. ");
INSERT INTO kqew_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Isa-isa silan domood kang Isa aw yagalaong silan, “Mabowi yang soltan ng mga Yahodi!” Aw syampal nilan. ");
INSERT INTO kqew_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ansinyan lyomogwa da oman si Pilato adto sang mga otaw aw laong nan kanilan, “Paningug! Apalogwaun da ko si Isa adi kamayo untak katigaman mayo na way kinita ko na dosa nan.” ");
INSERT INTO kqew_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na, lyomogwa da si Isa na aon korona na soksokon sang oo nan aw pyandagoman ng joba na mapowa. Aw yagalaong si Pilato sang mga otaw, “Tanawa, idi da yang otaw.” ");
INSERT INTO kqew_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkita kanan ng mga pangoo ng mga imam kipat yang mga gowardya sang Baay ng Tohan, yagapiyagit silan aw laong nilan, “Ilansang yan sa kros! Ilansang yan sa kros!” Awgaid yagalaong si Pilato, “Daa da mayo yan aw kamo da yang magpalansang sa kros kay bain kanak way kinita ko na dosa nan na dait ko yan hokomon na apatayun.” ");
INSERT INTO kqew_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yagalaong oman yang mga pangoo ng mga Yahodi, “Aon kanami Hokoman, aw sobay sini na Hokoman dait yan patayun kay yagalaong yan na Anak kono yan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagdungug sinyan ni Pilato, kyadogangan pa yang alluk nan. ");
INSERT INTO kqew_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dyaa da oman nan si Isa adto sa suud ng palasyo aw yosip nan, “Taga wain kaw?” Awgaid wa atobag si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yagalaong kanan si Pilato, “Nanga wa kaw atobag kanak? Wa kaw akatigam na aon kapatot ko na aboyan ta kaw aw aon oman kapatot ko na ipalansang kaw sa kros?” ");
INSERT INTO kqew_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tyomobag si Isa, “Kong wa kaw atagi ng Tohan ng kapatot, way kapatot mo paghokom kanak. Agaw sagaw mas dakowa yang dosa ng otaw na yagadaa kanak adi kammo kaysang dosa mo.” ");
INSERT INTO kqew_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagdungug sinyan ni Pilato, yaga-anap yan ng pama-agi na akaboyan nan si Isa. Awgaid yang mga Yahodi yagapadayon silan magpiyagit aw laong nilan, “Kong palogwaun mo yani na otaw, di da kaw ng amigo ng soltan sa Roma kay sino-sino yang magpakasoltan, kalaban yan ng soltan sa Roma.” ");
INSERT INTO kqew_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Adon, pagdungug ni Pilato sang pyagalaong ng mga Yahodi, dyaa nan si Isa adto sa logwa aw yamingkod yan sang ingkodanan ng maghohokom adto sa logar na tyawag ng Pamanag na Batoon na kong sang pyaglaongan na Hibrani, Gabata. ");
INSERT INTO kqew_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, allaw sidto ng pagpangandam para sang Pakaradyaan ng Paglabay aw mga alas sais ng omaga. Ansinyan yagalaong si Pilato sang mga Yahodi, “Tanawa, idi da yang soltan mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Awgaid yagapiyagit silan aw laong nilan, “Pataya yan! Pataya yan! Ilansang yan sa kros!” Yaga-osip si Pilato, “Karim mayo na ipalansang ko sa kros yang soltan mayo?” “Way tuna na soltan nami yatabiya yang soltan sa Roma!” tyomobag yang mga pangoo ng mga imam. ");
INSERT INTO kqew_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na, sang orian, yatag da nan kanilan si Isa untak ilansang sa kros. Ansinyan dyaa si Isa ng mga sondao. ");
INSERT INTO kqew_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pyapusan nilan kang Isa yang kaoy na pagalansangan kanan aw lyomogwa silan sikun sang syodad sampay na dyomatung silan sang logar na tyawag ng Logar ng Oo ng Kalabira na kong sang pyaglaongan na Hibrani, Golgota. ");
INSERT INTO kqew_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ansidto lyansang nilan si Isa sa kros. Aw aon oman dowangka otaw na lyansang nilan sa kros, yang sambok sang karinto ni Isa aw yang sambok sang kawaa nan. ");
INSERT INTO kqew_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na, aon syorat ni Pilato na pyabutang nan sang kaoy na pyagalansangan kang Isa. Aw yani yang syorat nan, “Si Isa na taga Nasarit, Soltan ng mga Yahodi.” ");
INSERT INTO kqew_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Madaig yang mga Yahodi na yakabasa sinyan kay yang logar na pyagalansangan kang Isa masaid sang syodad ng Awrosalam aw syorat yang idto sang toongka pyaglaongan na mag-onawa ng Hibrani, yang pyaglaongan ng mga taga Roma, aw yang Grik. ");
INSERT INTO kqew_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ansinyan kyomadto yang mga pangoo ng mga imam kang Pilato aw yagalaong silan, “Yang syorat mo dili ng madyaw. Dili gao ng ‘Soltan ng mga Yahodi’ yang pyagasorat mo kondi ‘Yani na otaw yagalaong na yan kono yang soltan ng mga Yahodi.’ ” ");
INSERT INTO kqew_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tyomobag si Pilato, “Yang syorat ko di da amaparin.” ");
INSERT INTO kqew_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na, pagkatapos ng mga sondao paglansang kang Isa sa kros, kyamang nilan yang mga dagom nan aw pyagabain-bain nilan ng opat kay untak yang kada isa kanilan ka-aonan ng sangka bain. Kyamang oman nilan yang mataas na dagom nan na yabuu sikun sa taas pababa na way sogpat. ");
INSERT INTO kqew_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ansinyan yagalaong yang mga sondao sang matag-isa, “Di ta yani alasiun. Magaripa da gaid kita untak katigaman daw sino yang maka-akun sini.” Na, ya-inang yani untak matoman yang yakasorat sang Kitab na yagalaong, “Pyagabain-bain nilan yang kanak mga dagom, aw pyagaripaan nilan yang dagom ko na mataas.” Sagaw idto yang ininang ng mga sondao. ");
INSERT INTO kqew_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Adon, sang masaid sa kros na pyagalansangan kang Isa yaga-indug yang kanan ina aw yang lomon na bobay ng kanan ina, aw si Mariyam na asawa ni Klopas kipat kang Mariyam na taga Magdala. ");
INSERT INTO kqew_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagkita ni Isa na yaga-indug ansan yang kanan ina aw yang inindowan na dakowa sang pangatayan nan, yagalaong yan sang kanan ina, “Kay ina, yani na inindowan ko, anak da mo adon.” ");
INSERT INTO kqew_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aw yagalaong oman yan sang inindowan nan, “Yang ina ko, ina da mo adon.” Agaw, sikun sidto na wakto pyapag-uya nidtong inindowan yang ina ni Isa sang kanan baay. ");
INSERT INTO kqew_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Adon kyatigaman da ni Isa na yang kariko ng pya-inang kanan yatapos da. Aw untak matoman yang yakasorat sang Kitab yagalaong yan, “Yamaangga ako.” ");
INSERT INTO kqew_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na, aon ansidto sambok na lasakanan na pono ng magsing na bino. Pagdungug ng mga sondao sang pyagalaong ni Isa, kyomamang silan ng ispongha aw tuguma nilan sang bino. Pagkatapos, byutang nilan sang sanga ng isopo aw diwian nilan sang baba ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagsupsup sinyan ni Isa, yagalaong yan, “Tapos da!” Ansinyan yadumuu yan aw yamabogto da yang napas nan. ");
INSERT INTO kqew_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, allaw sidto ng pagpangandam para sang Allaw ng Pagpatana. Dakowa yan na allaw sang mga Yahodi kay yakatunung sang Pakaradyaan ng Paglabay. Sabap sinyan kyomadto yang mga pangoo ng mga Yahodi kang Pilato aw yagapangayo silan na abariun yang mga bitiis ng mga otaw na lyansang sa kros untak madari silan matay kay untak makamang yang lawas nilan sang wa pa pagasogod yang Allaw ng Pagpatana. ");
INSERT INTO kqew_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Na, kyomadto da yang mga sondao aw byari nilan yang mga bitiis nidtong dowangka otaw na lyansang sa kros upud kang Isa. ");
INSERT INTO kqew_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Awgaid pagdood nilan kang Isa, kinita nilan na patay da. Agaw wa da nilan abaria yang mga bitiis nan. ");
INSERT INTO kqew_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Awgaid yang ininang ng sambok na sondao, tyosok nan ng bangkaw yang kilid ni Isa aw ansan dayon yaboos yang dogo aw tobig. ");
INSERT INTO kqew_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na, yang otaw na yakakita sinyan yakasaksi na bunna yani na yamaitabo. Yamatigam yan na bunna yang pyagalaong nan aw yagapangimunna yan sinyan untak mangintoo oman kamo. ");
INSERT INTO kqew_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ya-inang yang kariko ninyan untak matoman yang yakasorat sang Kitab na yagalaong, “Way amabari kanan, maskin sambok na pusa.” ");
INSERT INTO kqew_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aw aon oman yakasorat sang Kitab na yagalaong, “Magatanaw silan sang otaw na tyosok nilan.” ");
INSERT INTO kqew_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Adon, aon sambok na otaw na taga Arimatiya na yang ngaan nan si Yosop. Yani si Yosop yagapangintoo oman kang Isa awgaid ng sikrito kay yamalluk yan sang mga pangoo ng mga Yahodi. Ansinyan kyomadto yan kang Pilato aw yagapangayo na atogotan yan na akamangun nan yang lawas ni Isa sikun sa kros. Aw tyogotan yan ni Pilato. Agaw kyomadto yan aw kamanga nan yang lawas ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yamagad kanan si Nikodimos, yang otaw na kyomadto singaon kang Isa untak mapagbaaw kanan ng gabi. Aon dyaa nan na paballo na ininang sikun sang mga tanum na mira aw aloe na yang kabugat sobra sang 30 ka kilo. ");
INSERT INTO kqew_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ansinyan kyamang nilan yang lawas ni Isa aw syapot nilan ng mapoti aw butangi ng paballo kay idto yang kabatasanan ng mga Yahodi sang pagkobor ng mga patay. ");
INSERT INTO kqew_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, masaid sa logar na pyagalansangan kang Isa aon sambok na tanumanan. Aw sa suud ng tanumanan aon sambok na kobor na pyagalongagan sang bato na baya pa inanga aw wa pa akobori. ");
INSERT INTO kqew_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na, sabap ng madari da magsogod yang Allaw ng Pagpatana aw masaid oman yang inyan na kobor, iyan da nilan abutangan si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pagka-omaga ng Domingo nang maduggum pa, kyomadto si Mariyam na taga Magdala sang kobor ni Isa. Pagdatung nan ansan, kinita nan na kyamang da yang bato na yakatabon sang baba ng kobor. ");
INSERT INTO kqew_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Agaw dyomaagan yan adto kang Simon Pitros kipat sang inindowan na dakowa sang pangatayan ni Isa aw laong nan kanilan, “Kyamang nilan yang lawas ng kanatun Dato sikun sang kobor. Wa nami akatigami daw wain nilan abutangan!” ");
INSERT INTO kqew_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ansinyan kyomadto dayon sang kobor si Pitros aw yang sambok oman na inindowan. ");
INSERT INTO kqew_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dyomaagan silan dowa, awgaid kyabiyaan si Pitros kay mas makusug domaagan idtong sambok na inindowan aw yama-ona yan domatung sang kobor. ");
INSERT INTO kqew_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ansan sa kobor isilib yan adto sa suud aw kinita nan yang sapot na yakabutang ansan. Awgaid wa yan asuud sang kobor. ");
INSERT INTO kqew_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ansinyan dyomatung da oman si Simon Pitros aw idiretso yan pagsuud sang kobor. Pagsuud nan, kinita nan yang sapot ");
INSERT INTO kqew_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kipat yang panyo na pyagabalot sang oo ni Isa. Yalopi yang panyo aw wa yan atipona sang sapot, awgaid yakalain yan pagbutang. ");
INSERT INTO kqew_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Adon syomuud oman yang inindowan na yama-ona domatung sang kobor. Pagkita nan na iyan san yang mapoti awgaid waa da don si Isa, yagapangintoo yan na yabowi oman yan. ");
INSERT INTO kqew_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sidto na wakto wa pa silan pakasabot sidtong yakasorat sang Kitab na dait mabowi oman si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ansinyan yamori da idtong dowa na inindowan. ");
INSERT INTO kqew_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Awgaid si Mariyam, iyan pa yan paga-indug sa logwa ng kobor aw yagatiyao. Aw sarta yagatiyao yan, isilib yan adto sa suud ng kobor. ");
INSERT INTO kqew_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pagsilib nan, aon kinita nan na dowa na malaikat na yamandagom ng mapoti aw yaga-ingkod sang dati na kyabutangan ng lawas ni Isa, yang sambok sang apit ng oo, yang sambok sang apit ng siki. ");
INSERT INTO kqew_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yagalaong yang mga malaikat kanan, “Kay Bi, nanga yagatiyao kaw?” Tyomobag si Mariyam, “Kyamang nilan yang lawas ng kanak Dato aw wa ako akatigam daw wain nilan abutangan.” ");
INSERT INTO kqew_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Paglaong nan sinyan, lyomingi yan aw kinita nan si Isa na yaga-indug ansan, awgaid wa nan akilaa si Isa. ");
INSERT INTO kqew_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yaga-osip si Isa kanan, “Kay Bi, nanga yagatiyao kaw? Sino yang yanap mo?” Yagadumdum si Mariyam na yan yang yaga-atiman sang tanumanan. Agaw yagalaong yan, “Kong ikaw yang yakamang ng lawas nan, paglaonga ako daw wain mo abutangan kay untak kadtonan ko aw akamangun ko.” ");
INSERT INTO kqew_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yagalaong si Isa kanan, “Mariyam.” Ansinyan yapag-atobang si Mariyam kanan aw yagalaong yan sang pyaglaongan na Hibrani, “Rabboni!” na yang mana san Goro. ");
INSERT INTO kqew_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yagalaong si Isa, “Ayaw da ako pagtakmagi kay wa pa ako pagabarik adto sang Ama. Awgaid kadtoni yang mga kalomonan ko aw paglaonga silan na magabarik da ako adto sang kanak Ama na Ama oman mayo, sang Tohan ko na Tohan oman mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ansinyan kyadtonan ni Mariyam na taga Magdala yang mga inindowan ni Isa aw paglaonga silan na kinita nan yang kanilan Dato aw pyatigam nan kanilan daw ono yang pyagalaong kanan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkagabi sinyan na Domingo yanagkatipon yang mga inindowan ni Isa sang sambok na baay. Isiradowan nilan yang mga powertaan kay yamalluk silan sang mga pangoo ng mga Yahodi. Sakadyap dyomatung si Isa aw yamindug sang tunga nilan aw yagalaong kanilan, “Assalamo alaykom!” ");
INSERT INTO kqew_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Paglaong nan sinyan, pyakita nan kanilan yang mga pari sang arima aw kilid nan. Aw dakowa yang kasowat ng mga inindowan pagkita nilan sang kanilan Dato. ");
INSERT INTO kqew_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yagalaong oman si Isa kanilan, “Salam kamayo. Adon asogoon ta kamo mag-onawa ng pagsogo kanak ng Ama.” ");
INSERT INTO kqew_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagkatapos san yoyopan nan yang mga inindowan nan aw laong nan, “Tarimaa mayo yang Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kong amponon mayo yang mga otaw ng mga dosa nilan, yampon da silan ng Tohan. Awgaid kong di mayo silan amponon, wa silan ampona ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Adon, sang wakto na yagapakita si Isa sang mga inindowan nan, waa ansan si Tomas na tyawag ng Kambal na sambok oman sang sampoo aw dowa na mga sahabat ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sabap sinyan pyagalaong yan ng kadaigan na mga inindowan na kinita nilan yang kanilan Dato. Awgaid yagalaong si Tomas kanilan, “Kong di ko akitaun sang dowa na mata ko aw di ko madamdam ng tollo ko yang agi ng lansang sang mga arima nan aw di ko madamdam yang pari sang kilid nan, di ako amangintoo sang pyagalaong mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Adon, paglabay ng sangka simana, yanagkatipon da oman yang mga inindowan ni Isa sa suud ng baay aw kaupud nilan si Tomas. Sirado yang mga powertaan, awgaid sakadyap dyomatung si Isa aw yamindug sang tunga nilan aw laong nan, “Assalamo alaykom!” ");
INSERT INTO kqew_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pagkatapos san yagalaong yan kang Tomas, “Tanawa yang mga arima ko aw takmagi. Sadsada oman yang pari sang kilid ko. Ayaw da pagdowa-dowa, awgaid pagpangintoo da!” ");
INSERT INTO kqew_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tyomobag si Tomas, “Ikaw yang Dato aw Tohan ko!” ");
INSERT INTO kqew_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yagalaong si Isa kanan, “Adon yagapangintoo da kaw kay kinita mo ako. Awgaid kadyaw ng ginawa nidtong mga otaw na yagapangintoo kanak maskin wa silan pakakita kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, madaig pa yang mga katingaan na ininang ni Isa aw kinita ng mga inindowan nan na wa akasorat ansini na Kitab. ");
INSERT INTO kqew_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Awgaid yang yakalasak sini na Kitab yasorat untak mangintoo kamo na bunna agaw na si Isa yang Almasi, yang Anak ng Tohan, aw untak ka-aonan kamo ng kinabowi na way kataposan sabap sang pagpangintoo mayo kanan. ");
INSERT INTO kqew_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ansinyan paglabay ng pilang allaw, yagapakita oman si Isa sang mga inindowan nan adto sang kilid ng Linaw ng Tibiriyas. Maynini yang pagpakita nan kanilan. ");
INSERT INTO kqew_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yanagkatipon silan Simon Pitros, si Tomas na tyawag ng Kambal, si Natanyal na taga Kana sang probinsya ng Jalil, yang dowa na anak ni Sibidi aw dowa koman na mga inindowan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ansinyan yagalaong si Simon Pitros kanilan, “Amanagat ako.” Yagalaong silan, “Amagad kami.” Agaw pyomanaw da silan, sakay sang sambok na bangka aw yagapalaod silan. Awgaid way yakamang nilan sidto na gabi. ");
INSERT INTO kqew_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sang pagsilat ng suga yaga-indug si Isa adto sang baybay. Awgaid wa akilaa kanan yang mga inindowan nan. ");
INSERT INTO kqew_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yagatawag si Isa kanilan, laong nan, “Mga lomon, aon yakamang mayo?” Tyomobag silan, “Waa.” ");
INSERT INTO kqew_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yagalaong si Isa, “Itaktak mayo yang pokot sang karinto ng bangka aw ansinyan aon amakamang mayo.” Na, tyaktak da nilan yang pokot aw wa da nilan mabira sabap sang kadaig ng isda na yakamang nilan. ");
INSERT INTO kqew_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ansinyan yagalaong kang Pitros yang inindowan na dakowa sang pangatayan ni Isa, “Yang Dato yang idto!” Pagdungug sinyan ni Pitros, tyapis nan yang kanan dagom na linobas nan aw layog sang dagat kay malangoy adto baybay. ");
INSERT INTO kqew_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yang mga kaibanan nan sang bangka yagabugsay paduug sang baybay na igoyod yang pokot na pono ng isda. Dili ng mawat yang pyagabugsayan nilan, mga 50 ka dupa da gaid. ");
INSERT INTO kqew_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagdonggo nilan sang baybay, kinita nilan na aon ansidto dyook na oring na aon isda na pyasagan aw aon oman pan. ");
INSERT INTO kqew_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yagalaong si Isa kanilan, “Daa kamo adi ng pilambok na isda na yakamang mayo.” ");
INSERT INTO kqew_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Agaw yasakay da oman si Simon Pitros sang bangka aw binira nan adto saka yang pokot na pono ng mangkadakowa na isda na 153 ka bok yang kadaig. Awgaid maskin maynini yang kadaig ng isda, wa akalasi yang pokot nilan. ");
INSERT INTO kqew_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yagalaong si Isa kanilan, “Adi kamo aw kan da kamo.” Na, way maskin isa sang mga inindowan na yamangisug mag-osip daw sino yan kay kyatigaman nilan na yan yang Dato nilan. ");
INSERT INTO kqew_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ansinyan dyomood si Isa, kyamang nan yang pan aw yatag nan sang mga inindowan nan. Maynan oman yang ininang nan sang isda. ");
INSERT INTO kqew_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, yani yang ikatoo na pagpakita ni Isa sang mga inindowan nan sikun sidtong wakto na yabowi oman yan. ");
INSERT INTO kqew_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkatapos nilan koman, yagalaong si Isa kang Simon Pitros, “Simon, anak ni Yahiya, yang pagpakadakowa mo kanak labaw ba kay sini na mga kaibanan mo?” Tyomobag si Pitros, “Uu, kay Dato, yamatigam kaw na dakowa kaw sang pangatayan ko.” Yagalaong si Isa, “Na, kong maynan, atimana yang mga otaw na sakop ko mag-onawa ng pag-atiman sang mga karniro.” ");
INSERT INTO kqew_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yaga-osip oman si Isa, “Simon, anak ni Yahiya, bunna agaw na dakowa yang pagpakadakowa mo kanak?” Tyomobag si Pitros, “Uu, kay Dato, yamatigam kaw na dakowa kaw sang pangatayan ko.” Yagalaong si Isa, “Na, kong maynan, atimana yang mga otaw na sakop ko mag-onawa ng pag-atiman sang mga karniro.” ");
INSERT INTO kqew_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Awgaid adon yaga-osip si Isa kang Pitros ng ikatoo, “Simon, anak ni Yahiya, dakowa ba ako sang pangatayan mo?” Na, yamarido da si Pitros kay sang ikatoo na osip yaga-osip si Isa daw dakowa ba yan sang pangatayan nan. Aw tyomobag si Pitros, “Kay Dato, yamatigam kaw sang kariko aw kyatigaman mo na dakowa kaw sang pangatayan ko.” Yagalaong si Isa kanan, “Na, kong maynan, atimana yang mga otaw na sakop ko mag-onawa ng pag-atiman sang mga karniro. ");
INSERT INTO kqew_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sa bunna-bunna na ipaglaong ko kammo na singaong isu pa kaw, ikaw yang yagabakos sang sarili mo aw kyomadto kaw abir wain yang karim mo. Awgaid kong matikadung da kaw, padupaun kaw aw ikutan kaw ng lain na otaw aw adaun kaw sang logar na di mo karim kadtonan.” ");
INSERT INTO kqew_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yani yang pyagalaong ni Isa untak ipatigam nan daw ono yang pama-agi ng pagkamatay ni Pitros, aw sabap sinyan na pagkamatay amabantog nan yang Tohan. Pagkatapos san yagalaong si Isa kang Pitros, “Agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Adon, paglingi ni Pitros, kinita nan na yasonod kanilan yang inindowan na dakowa sang pangatayan ni Isa. Yani na inindowan yang yagasandig kang Isa sidtong wakto na yanagpaniapon silan aw yaga-osip kanan daw sino yang magatraydor kanan. ");
INSERT INTO kqew_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkita kanan ni Pitros, yosip nan si Isa, “Kay Dato, ono yang akatamanan nan?” ");
INSERT INTO kqew_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tyomobag si Isa, “Kong karim ko na amabowi yan sampay sang pagbarik ko adi sang donya, way labot mo. Awgaid ikaw, agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na, sabap sidto na pyaglaongan ni Isa yakarimpud adto sang mga kalomonan yang gogodanun na di kono amatay idtong inindowan. Awgaid wa pagalaong si Isa na di yan amatay kondi yagalaong yan, “Kong karim ko na amabowi yan sampay sang pagbarik ko adi sang donya, way labot mo.” ");
INSERT INTO kqew_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na, yang inindowan na pyagalaong ni Isa yan yang yagapangimunna sini na mga butang aw yan mismo yang yagasorat sini. Aw kyatigaman nami na bunna yang pyagalaong nan. ");
INSERT INTO kqew_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na, madaig pa yang mga ininang ni Isa na wa akasorat disini. Awgaid kong yasorat pa yang kariko ng mga ininang nan, na, basin di amalasak adi sining donya yang kadaig ng mga Kitab na dait soratun. Wassalam");
INSERT INTO kqew_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kay Dato Tiyopilo, sang pirmiro na sorat ko gyogod ko yang kariko ng ininang aw pyaga-indo ni Isa sokad sang pagsogod nan pag-indo ");
INSERT INTO kqew_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taman sidtong allaw na pyataas da yan adto sa sorga. Sang wa pa yan pagabarik adto sa sorga aon mga sogowan na ibilin nan sang mga sahabat na pinili nan. Yani na mga sogowan pyatigam nan kanilan sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pagkatapos ng pagkamatay aw pagkabowi oman ni Isa yagapakita yan sang mga sahabat nan sa suud ng 40 na allaw. Madaig yang mga tanda na pyakita nan kanilan untak katigaman nilan na bunna na yabowi oman yan. Aw sidto na mga wakto nang yagapakita yan kanilan, pyagalaong nan silan makapantag sang pagdato ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sangallaw sinyan sarta yanagkatipon si Isa aw yang mga sahabat nan, yagalaong yan kanilan, “Ayaw kamo pagpanaw sikun sa Awrosalam, awgaid tagadi pa mayo yang pyasad kamayo ng Tohan na kanak Ama, na pyagalaong ko kamayo singaon. ");
INSERT INTO kqew_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kay si Yahiya, tobig yang pyagasogbo nan sang mga otaw, awgaid kamo, sang di amadogay yang pagasogbo kamayo yang Nyawa ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ansinyan sarta yanagkatipon oman si Isa aw yang mga sahabat nan, yaga-osip silan kang Isa, “Kay Dato, adon ba yang wakto na apapanawon mo yang mga yagadato kanatun aw ibarik da mo yang kapatot ng pagdato adi kanatun na mga bangsa Israil?” ");
INSERT INTO kqew_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tyomobag si Isa aw laong nan kanilan, “Way kapatot mayo katigaman daw kano yan matoman kay yang Ama gaid yang yamatigam aw yan yang yagabuut daw kano yan maitabo. ");
INSERT INTO kqew_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Awgaid sang wakto na madatung kamayo yang Nyawa ng Tohan, amakadawat kamo ng kabarakat. Aw magasaksi da kamo makapantag kanak adto sa Awrosalam aw adto sang kariko ng Yahodiya aw Samariya aw sampay oman sang kariko ng mga banwa adi sa babawan ng donya.” ");
INSERT INTO kqew_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkatapos nan maglaong sinyan, pyataas yan adto sa sorga. Aw sarta yagatanaw silan, pyagalibotan yan ng gabon aw yawaa da yan sang pananaw nilan. ");
INSERT INTO kqew_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sarta ya-angad pa silan sang langit, sakadyap aon dowangka otaw na yaga-indug sang masaid kanilan na yamandagom ng mapoti. ");
INSERT INTO kqew_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yagalaong silan, “Kamo na taga Jalil, nanga yaga-indug kamo ansan aw ya-angad kamo adto sang langit? Yani si Isa na kinita mayo na pyataas adto sa sorga, magabarik oman yan adi. Daw monono yang pagpataas kanan adto sa sorga maynan oman yang pagbarik nan adi sang donya.” ");
INSERT INTO kqew_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ansinyan byomarik silan sa Awrosalam sikun sang butay na pyagangaanan sang Butay ng Jayton. Yani na butay mga sangka kilomitro yang kawat sikun sang syodad. ");
INSERT INTO kqew_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagdatung nilan sa Awrosalam, pyomanaos silan sang kowarto adto sa taas ng baay na pyaga-uyaan nilan. Yang yanagkatipon ansan silan Pitros, Yahiya, Yakob, Andriyas, Pilip, Tomas, Bartolomi, Matiyo, si Yakob na anak ni Alpiyo, si Simon na rebelde singaon kipat kang Yodas na anak ni Yakob. ");
INSERT INTO kqew_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yang kariko nilan yabay managkatipon untak magdowaa upud sang mga kaobayan aw si Mariyam na ina ni Isa kipat oman yang mga lomon nan na usug. ");
INSERT INTO kqew_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sangallaw sinyan sarta yanagkatipon yang mga yagapangintoo kang Isa na mga 120 ka otaw, yamindug si Pitros aw yagalaong yan, ");
INSERT INTO kqew_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kalomonan ko, dait na amatoman yang pyagalaong ng Kitab na pyatigam singaon ng Nyawa ng Tohan pina-agi kang Soltan Daud. Yang idto na pyatigam nan yang makapantag kang Yodas na yan yang yagadaa ng mga otaw na yagadakup kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Yodas dati na kaupudanan nami na sahabat aw yaga-upud yan sang gawbuk nami.” ");
INSERT INTO kqew_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, yang sapi na dyawat ni Yodas silbi bayad sang maat na ininang nan gyamit nan sang pagbili ng sangka parsila na lopa. Ansidto na lopa yamaoog si Yodas aw kamatay kay yaboto yang kanan dubdub aw lyomogwa yang kariko ng tinai nan. ");
INSERT INTO kqew_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na, yang kariko ng mga taga Awrosalam yakadungug ng makapantag sinyan. Agaw tyawag nilan yan na lopa ng Akildama sang kanilan pyaglaongan na yang mana nan Lopa ng Dogo. ");
INSERT INTO kqew_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yagapadayon si Pitros maglaong, “Aon yakasorat sa Kitab Jabor na yagalaong, “ ‘Apabayaan gao yang pyaga-uyaan nan kay dait na waa day maga-uya ansan.’ Aw aon oman yakasorat na yagalaong, “ ‘Madyaw pa aw aon makasalinti sang gawbuk nan.’ ");
INSERT INTO kqew_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Agaw,” laong ni Pitros, “madyaw pa aw magapili kita ng sangka otaw na makasalinti kanan. Kinaanglan na sambok yan na kaupudanan nami sang tibok panahon na adi pa kanatun si Tagallang Isa ");
INSERT INTO kqew_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","sikun pa sang pagsogbo kanan ni Yahiya taman sidtong wakto na pyataas yan adto sa sorga. Kay dait na makasaksi yan upud kanami makapantag sang pagkabowi oman ni Isa.” ");
INSERT INTO kqew_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ansinyan dowangka otaw yang pyagapilian nilan: si Yosop na pyagangaanan kang Barsabas na tyawag oman ni Yostos, aw si Matiyas. ");
INSERT INTO kqew_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ansinyan yagadowaa si Pitros kipat oman yang kadaigan aw laong nilan, “Ya Tohan, ikaw yang yamatigam sang dumduman ng kariko ng manosiya. Agaw pakitaan kanami daw sino kanilan dowa yang pinili mo ");
INSERT INTO kqew_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na ma-inang ng sahabat poli kang Yodas. Kay biniyaan ni Yodas yani na gawbuk aw kyomadto yan sang logar na dait kanan.” ");
INSERT INTO kqew_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapos nilan magdowaa, yanagripa silan aw si Matiyas yang yamapili. Ansinyan yakadogang yan sang sampoo aw isa na mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ansinyan pagdatung ng allaw ng pakaradyaan na tyawag ng Pintikostis, yanagkatipon yang kariko ng mga yagapangintoo kang Isa sang sambok na logar. ");
INSERT INTO kqew_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sakadyap aon matanog na oni sikun sang langit na maynang makusug na samut. Aw yakarimpud yan na oni sa suud ng baay na pyagakatiponan nilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ansinyan aon kinita nilan na maynang atoon sa porma ng dila na yakatongtong sang matag-isa kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aw yang kariko nilan pyagabuutan ng Nyawa ng Tohan aw yakapaglaong silan ng yagakatuna-tuna na pyaglaongan na wa nilan akatigami. Ya-inang nilan yani sabap sang kabarakat na yatag kanilan ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, sidto na wakto aon mga Yahodi sa Awrosalam sikun sang yagakatuna-tuna na mga banwa adi sa babawan ng donya na bara-ibada silan na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagdungug nilan sidtong oni, madaig kanilan kyomadto sang pyagatiponan ng mga yagapangintoo kang Isa. Pagdatung nilan adto, bali na katingaa nilan kay idtong mga otaw na pyagabuutan ng Nyawa ng Tohan yagalaong sang pyaglaongan ng matag-isa kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yatingaa sagaw silan aw laong nilan, “Di ba yani na mga otaw taga Jalil? ");
INSERT INTO kqew_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nanga yakadungug kita na yagalaong silan ng mga pyaglaongan ng matag-isa kanatun? ");
INSERT INTO kqew_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aon adi kanatun mga taga Partiya, Midiya, aw taga Ilam. Aon oman taga Misopotamiya, Yahodiya aw Kapadokiya, Pontos aw Asiya. ");
INSERT INTO kqew_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aw aon oman taga Pirigiya, Pampiliya aw taga Misir, aw mga otaw sikun sang mga logar adto sa Libiya na masaid sa Kirini. Aw aon oman yagasikun sang syodad ng Roma ");
INSERT INTO kqew_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na mga Yahodi kipat yang mga dili ng Yahodi na yagapasakop sang agama Yahodi. Aon oman taga Kiriti aw taga Arabiya. Na, maskin yagakatuna-tuna yang pyagasikunan ta, yakasabot kita ng kanilan pyaglaongan makapantag sang mga katingaan na ininang ng Tohan kay yagalaong silan ng kanatun mga pyaglaongan!” ");
INSERT INTO kqew_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na, yamangkatingaa sagaw yang kariko ng mga otaw ansan aw yamaribog silan. Agaw yanag-inosipay silan, laong nilan, “Ono kowaw yang mana nini?” ");
INSERT INTO kqew_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Awgaid aon oman kadaigan na yagasangu-sangu sang mga yagapangintoo kang Isa aw laong nilan, “Yamangkalasing gaid yani na mga otaw!” ");
INSERT INTO kqew_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ansinyan yamindug si Pitros kipat yang sampoo aw isa na mga sahabat aw yagalaong yan ng matanog adto sang kaotawan, laong nan, “Mga kalomonan ko na mga Yahodi aw yang kariko mayo na yaga-uya adi sa Awrosalam, paningugi mayo yang ipaglaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dili ng bunna yang dumduman mayo na lasing yani na mga otaw kay way magkalasing ng baya pa alas nowebe ng kaamdag. ");
INSERT INTO kqew_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Awgaid yani na yamaitabo adon yang pagtoman ng pyagalaong ni Nabi Yowil singaon na laong nan, ");
INSERT INTO kqew_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Sang kataposan na mga allaw,’ laong ng Tohan, ‘ipadatung ko yang kanak Nyawa sang kariko ng mga otaw. Yang mga anak mayo na usug aw bobay magapatigam ng ipatigam ko kanilan, yang mga olitawo mayo makakita sang ipakita ko kanilan, aw yang mga mangkatikadung mayo magatagaynup ng karim ko ipatigam kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bunna sagaw na sidto na mga allaw ipadatung ko yang kanak Nyawa sang mga sogowanun ko na usug aw bobay aw ansinyan magapatigam silan ng ipatigam ko kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Maga-inang ako ng mga katingaan adto sang langit aw magapakita ako ng mga tanda adi sang donya na aon kitaun na dogo, atoon aw madakmuu na ubuu. ");
INSERT INTO kqew_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ansinyan magkaduggum yang suga, aw magakapowa yang bowan na maynang dogo. Aw pagkatapos san madatung yang dakowa aw barapantag na allaw na magahokom da yang Tohan sang kariko ng manosiya. ");
INSERT INTO kqew_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aw ansinyan sino-sino yang magasampit ng Tagallang aw amangayo kanan ng tabang, amalowas aw di da asiksaun.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yagalaong pa si Pitros, “Mga kalomonan ko na bangsa Israil, paningugi mayo yani na ipaglaong ko kamayo. Si Isa na taga Nasarit, bunna na syogo ng Tohan adi kanatun. Pyangimunnaan yani ng Tohan sabap sang mga katingaan aw mga tanda na pya-inang nan kanan. Kyatigaman mayo yani kay yamaitabo yang kariko ninyan adi kamayo. ");
INSERT INTO kqew_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Na, yani si Isa dyakup mayo, awgaid kyatigaman dadaan ng Tohan na maynan yang amaitabo kay idto yang kahanda nan. Aw pyatay mayo si Isa kay syogo mayo yang baradosa na mga otaw untak silan maglansang kanan adto sa kros. ");
INSERT INTO kqew_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Awgaid byowi oman yan ng Tohan aw lyowas nan yan sikun sang masikot na kamatayun kay di makadaog kanan yang kamatayun. ");
INSERT INTO kqew_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kay aon pyagalaong ni Soltan Daud singaon na makapantag kang Isa, laong nan, “ ‘Yamatigam ako na yabay idi kanak yang Tohan. Iyan yan sang masaid kanak, agaw di ako amarido. ");
INSERT INTO kqew_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sabap sinyan dakowa yang kasowat ko aw di ako maga-ondang magpoji kanan. Aw maskin amatay ako, aon pay pag-asa ko. ");
INSERT INTO kqew_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kay di mo ako apabayaan adto sang banwa ng mga patay aw di mo atogotan na amadonot yang lawas ko na sotti na sogowanun mo. ");
INSERT INTO kqew_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pyatigam mo kanak yang daan paduug sang kinabowi. Aw idto yang amakasowat kanak kong iyan ako sang masaid kammo.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yagapadayon pa maglaong si Pitros, “Mga kalomonan ko, pagalaongon ta kamo ng insakto na yang bantoganun na ompo natun na si Soltan Daud yamatay aw lyubung. Aw yang kanan kobor idi kanatun sampay da adon. ");
INSERT INTO kqew_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Awgaid maynidto yang pyaglaongan ni Soltan Daud kay sambok yan na nabi. Kyatigaman nan na aon pyasad kanan ng Tohan aw yani yang pasad nan na sambok sang mga topo nan ma-inang ng soltan na mag-onawa kanan. ");
INSERT INTO kqew_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kyatigaman oman ni Soltan Daud daw ono yang inangun ng Tohan sang madatung na mga allaw. Agaw yakapaglaong yan ng makapantag sang pagkabowi oman ng Almasi, laong nan na wa yan apabayai adto sang banwa ng mga patay aw wa atogoti ng Tohan na amadonot yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na, yang idto si Isa na byowi oman ng Tohan sikun sang kamatay aw yang kariko nami yakasaksi sinyan kay yakakita kami kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqew_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aw adon yatagan si Isa ng dakowa na kabantogan kay pyataas yan adto sang karinto ng Tohan aw yatagan yan ng Ama ng kapatot magpadaa ng Sotti na Nyawa mag-onawa ng pasad nan. Aw adon pyadaa ni Isa yang Nyawa ng Tohan adi kanami. Agaw, yang kinita aw dyungug mayo adon yang ininang ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, dili ni Soltan Daud yang pyataas adto sa sorga, awgaid yagalaong yan, “ ‘Yagalaong yang Tohan sang kanak Dato, “Pag-ingkod adi sang karinto ko ");
INSERT INTO kqew_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampay na ataloon ko yang mga kalaban mo aw ma-inang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqew_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Agaw sagaw adon,” laong ni Pitros, “yang kariko mayo na bangsa Israil, dait kamo matigam na yani si Isa na lyansang mayo sa kros, ininang yan ng Tohan ng Dato na Labi na Mabarakat aw yang Almasi.” ");
INSERT INTO kqew_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Pitros, labi da yang karido aw alluk nilan. Agaw yaga-osip silan kang Pitros kipat sang kadaigan pa na mga sahabat, laong nilan, “Mga lomon, ono yang dait nami inangun?” ");
INSERT INTO kqew_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tyomobag si Pitros, “Pagtawbat kamo aw yang matag-isa kamayo magpasogbo sang ngaan ni Isa Almasi untak amponon kamo ng mga dosa mayo. Aw ansinyan amadawat mayo yang Sotti na Nyawa na i-atag kamayo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kay idto yang pasad nan kamayo kipat sang mga katopowan mayo kipat oman sang kariko ng mga otaw adto sang mawat na mga banwa na maskin sino yang apiliun ng Tohan na kanatun Tagallang na amangagad kanan.” ");
INSERT INTO kqew_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Madaig pa yang pyaga-indo kanilan ni Pitros aw yagalaong pa yan kanilan, “Ayaw kamo pagsiling ng batasan ng maat na mga otaw adon na panahon kay untak malowas kamo sikun sang siksa na madatung kanilan.” ");
INSERT INTO kqew_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na, madaig yang yagapangintoo sang pyaglaongan ni Pitros aw yagapasogbo silan. Aw sidto na allaw mga 3000 ka otaw yang yakadogang sang mga yagapangintoo kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yang kariko nilan yagapadayon maningug sang pyaga-indo ng mga sahabat, yabay silan managkatipon aw yakan silan ng pan na tadumanan sang pagkamatay ni Isa aw yabay silan magdowaa adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na, yang kariko ng mga otaw aon alluk nilan sang Tohan kay madaig yang mga katingaan na tanda ng kabarakat ng Tohan na ininang ng mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yang kariko ng mga yagapangintoo kang Isa yabay managkatipon aw magtinabangay silan sang mga panginaanglan nilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pyamarigya nilan yang kanilan lopa kipat yang kanilan mga butang aw yang alin pyagabain-bain nilan sang mga kaupudanan nilan sobay sang pyagakinaanglan nilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Allaw-allaw yanagkatipon silan adto sang Baay ng Tohan. Aw yagadungan silan koman adto sang kanilan mga baay na aon kasowat aw iklas yang pangatayan nilan sang ininang nilan. ");
INSERT INTO kqew_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yabay silan magpoji sang Tohan aw yaddatan silan ng kariko ng mga otaw. Na, allaw-allaw aon mga otaw na yalowas aw dyogang silan ng Tohan sang mga otaw na yagapangintoo kang Isa Almasi. ");
INSERT INTO kqew_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na, sangallaw sinyan kyomadto si Pitros aw si Yahiya sang Baay ng Tohan ng alas tres ng ambong na wakto ng pagdowaa. ");
INSERT INTO kqew_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Adto sang sambok na powertaan ng Baay ng Tohan na tyawag ng Madyaw na Powertaan aon sambok na sadi na wa pakapanaw sikun pa sang pagkaotaw nan. Allaw-allaw dyaa yan adto sang powertaan untak makapangayo yan ng sapi sang mga otaw na somuud sang pamanag ng Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Adon, pagkita nan kang Pitros aw si Yahiya na masuud, yagapangayo yan kanilan ng sapi. ");
INSERT INTO kqew_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ansinyan pyakatanawan yan ni Pitros aw si Yahiya aw yagalaong si Pitros kanan, “Tanaw adi kanami!” ");
INSERT INTO kqew_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na, yagatanaw da yan adto kanilan aw yagadumdum na atagan yan ng sapi. ");
INSERT INTO kqew_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Awgaid yagalaong si Pitros kanan, “Way sapi ko, nunka, awgaid yang idi kanak i-atag ko kammo. Sang ngaan ni Isa Almasi na taga Nasarit, pag-indug aw panaw!” ");
INSERT INTO kqew_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ansinyan tyakmagan ni Pitros yang karinto na arima nan aw tyabangan nan pag-indug. Aw sinyan dayon kya-aonan ng kusug yang kanan siki aw boko-boko. ");
INSERT INTO kqew_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na, yatokaw mindug yang otaw aw yagapanaw-panaw. Pagkatapos yamagad yan kang Pitros aw si Yahiya pagsuud sang pamanag ng Baay ng Tohan. Yagapanaw-panaw yan aw yagalalayogon na yagapoji sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na, yang kariko ng mga otaw yakakita kanan na yagapanaw-panaw aw yagapoji sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Aw pagkatigam nilan na yan kadi yang makililimos na yabay mag-ingkod sang powertaan ng Baay ng Tohan na pyagatawag ng Madyaw na Powertaan, labi da yang pagkatingaa nilan sang yamaitabo kanan. ");
INSERT INTO kqew_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, wa da pagabiya idtong otaw kang Pitros aw si Yahiya, awgaid yagatakmag yan kanilan sarta yagapanaw silan adto sang pamanag ng Baay ng Tohan na pyagatawag ng Pagasilongan ni Solayman. Aw yang kariko ng mga otaw yamandaagan adto kanilan kay yangkatingaa sagaw silan sabap sidto na yamaitabo. ");
INSERT INTO kqew_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkita ni Pitros sang mga otaw na dyomood kanilan, yagalaong yan, “Mga kalomonan ko na bangsa Israil, nanga yatingaa kamo sini na pangitabo? Nanga pyakatanawan mayo kami? Basin yagadumdum kamo na yakapanaw yani na otaw sabap sang kabarakat nami atawa sabap ng bara-ibada kami na mga otaw. Dili! ");
INSERT INTO kqew_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kay yang Tohan na pyagasambayangan ng mga kaompowan natun na mag-onawa ni Nabi Ibrahim, si Isahak aw si Yakob, yan yang yaga-inang sini aw yatagan nan ng dakowa na kabantogan yang kanan sogowanun na si Isa. Awgaid pyadakup mayo yan sang mga pangoo aw tyarikodan mayo yan sa atobangan ni Gobirnador Pilato maskin pa kallini nan boyan si Isa. ");
INSERT INTO kqew_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sagaw, tyarikodan mayo yang otaw na sotti aw matorid aw pyangayo mayo adto kang Pilato na aboyan nan yang sangka otaw na yakapatay sang otaw. ");
INSERT INTO kqew_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na, si Isa na pyagasikunan ng kinabowi, pyatay mayo awgaid byowi oman yan ng Tohan. Aw kami yang mga saksi sinyan kay yakakita kami kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqew_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na adon, yani na otaw na kinita aw kinilaa mayo, yatagan ng kusug sabap sang ngaan ni Isa. Sabap sang kabarakat ni Isa aw sabap sang pagpangintoo nami kanan, pyakadyaw yani na otaw sa atobangan mayo. ");
INSERT INTO kqew_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga kalomonan ko, yamatigam ako na idto yang ininang mayo kay kamo aw yang mga pangoo mayo wa akatigam daw sino si Isa. ");
INSERT INTO kqew_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Awgaid sang mayninyan na pama-agi yatoman yang pyatigam ng Tohan pina-agi sang kariko ng mga nabi kay pyagatagna nilan na dait amagi ng kasikotan yang Almasi na yan yang syogo ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Agaw pagtawbat kamo aw pagdood kamo sang Tohan untak amponon nan yang mga dosa mayo. Aw ansinyan atagan kamo ng kadyawan sikun sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aw pagkatapos san ipadaa oman nan si Isa adi sang donya na yan yang Almasi na pinili nan untak magdato kamayo. ");
INSERT INTO kqew_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Awgaid kinaanglan na magapabilin pa yan adto sa sorga taman sidtong wakto na abagoon da ng Tohan yang kariko ng mga butang. Kay yani yang pyasad nan sikun pa singaong ona pina-agi sang kanan mga nabi. ");
INSERT INTO kqew_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kay yagalaong singaon si Nabi Mosa, laong nan, ‘Yang Tohan na kanatun Tagallang magasogo adi kamayo ng sambok na nabi na mag-onawa kanak na magasikun oman kamayo na bangsa Israil. Dait na apangagadan mayo yang kariko ng ipaglaong nan kamayo. ");
INSERT INTO kqew_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yang di amangagad sang ipaglaong ninyan na nabi, di da amabilang na sakop pa ng Tohan aw labi da yang siksa kanan.’ ");
INSERT INTO kqew_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na, yang kariko ng mga nabi sikun pa kang Samuel taman sang kariko nilan na yagasonod kanan yagapatigam ng mga butang na yatoman adon na mga allaw. ");
INSERT INTO kqew_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kamo yang amakadawat ng pyasad ng Tohan na pyatigam nan pina-agi sang mga nabi. Aw kamayo oman yang pyagapasadan na ininang ng Tohan adto sang mga kaompowan mayo. Kay yagalaong yang Tohan kang Nabi Ibrahim, laong nan, ‘Atagan ng kadyawan yang kariko ng mga otaw adi sa babawan ng donya sabap sang topo mo.’ ");
INSERT INTO kqew_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Agaw, pagdatung ng wakto na ipadaa da ng Tohan yang kanan sogowanun na si Isa, pyadaa nan yan ona adi kamayo untak tarikodan mayo yang maat na mga inang mayo aw untak makadawat kamo ng kadyawan nan.” ");
INSERT INTO kqew_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Adon, sarta yaga-indo pa si Pitros aw si Yahiya sang mga otaw, dyomood kanilan yang mga imam, yang mga Sadoki aw yang kapitan ng mga gowardya sang Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bali na kadaman nilan sang dowa na sahabat kay yaga-indo silan sang mga otaw na yabowi oman si Isa aw idto yang tanda na amabowi oman yang kariko ng mga patay. ");
INSERT INTO kqew_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Agaw dyakup nilan si Pitros aw si Yahiya aw sabap ng kasilum da, pyapiriso nilan taman ng pagka-ilaw. ");
INSERT INTO kqew_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Awgaid maskin maynan, madaig yang yagapangintoo kang Isa kay yakadungug silan sang pyaga-indo nilan Pitros. Yang kadaig ng kausugan gaid yadatung ng mga 5000. ");
INSERT INTO kqew_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na, pagka-ilaw sinyan yanagkatipon adto sa Awrosalam yang mga pangoo sang agama, yang mga pangoo sang banwa aw yang mga magiindoway ng Hokoman. ");
INSERT INTO kqew_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Iyan oman si Anas na Dakowa na Imam, si Kayapas, si Yahiya, si Iskandar aw yang kadaigan pa na mga usug na sakop ng pamilya ni Anas. ");
INSERT INTO kqew_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ansinyan pya-atobang nilan yang dowa na sahabat adto kanilan aw osipa nilan, laong nilan, “Wain pagasikun yang kabarakat mayo sang pag-inang ng katingaan? Sino yang yaga-atag kamayo ng kapatot ng pagpakadyaw ng sadi?” ");
INSERT INTO kqew_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ansinyan pyagabuutan si Pitros ng Nyawa ng Tohan aw tyomobag kanilan, laong nan, “Mga pangoo sang agama aw mga pangoo sang banwa, ");
INSERT INTO kqew_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","aw osipun mayo kami adon makapantag sang kadyawan na ya-inang sang sadi aw monono yang pagpakadyaw kanan, ");
INSERT INTO kqew_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, dait mayo katigaman kipat yang kariko ng mga bangsa Israil na yani na otaw na yaga-indug adon sa atobangan mayo yamadyaw sabap sang kabarakat ni Isa Almasi na taga Nasarit. Yani si Isa lyansang mayo sa kros, awgaid byowi oman yan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Makapantag oman kanan yang yakasorat sang Kitab na yagalaong, “ ‘Yang bato na dyami ng mga panday kay way kono kapantag, ya-inang ng labi na barapantag.’ ");
INSERT INTO kqew_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Agaw, si Isa da gaid yang makalowas sang manosiya. Kay waa day lain pa adi sa babawan ng donya na yatagan ng Tohan ng kapatot sang paglowas kanatun.” ");
INSERT INTO kqew_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, yangkatingaa da yang kariko ng mga pangoo pagkita nilan sang kaisug nilan ni Pitros aw si Yahiya sang pagtobag kanilan aw pagkatigam nilan na silan way mataas na pagpangadi. Aw ansinyan kyatigaman nilan na yani na mga otaw mga inagad ni Isa singaon. ");
INSERT INTO kqew_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Awgaid way ikapaglaong nilan kay kinita nilan yang otaw na pyakadyaw na yaga-indug sang masaid kang Pitros aw si Yahiya. ");
INSERT INTO kqew_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Agaw pyalogwa da nilan si Pitros aw si Yahiya sikun sang Makagwas na Hokomanan untak pagbaawan nilan daw ono yang inangun nilan. ");
INSERT INTO kqew_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Laong nilan, “Ono yang inangun ta sini na mga otaw? Yang kariko ng mga otaw adi sa Awrosalam yamatigam sang katingaan na ininang nilan aw di kita makapaglaong na bakak gaid inyan. ");
INSERT INTO kqew_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Awgaid untak di yani akatigaman ng kadaigan pa na mga otaw, maynini yang inangun ta. Pagalaongon natun silan na di da silan mag-indo sang maskin sino ng makapantag kang Isa.” ");
INSERT INTO kqew_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ansinyan pyatawag nilan si Pitros aw si Yahiya aw pyagalaong nilan na di na di silan maglaong atawa mag-indo sang ngaan ni Isa. ");
INSERT INTO kqew_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Awgaid tyomobag kanilan si Pitros aw si Yahiya, laong nilan, “Dumduma mayo daw wain yang madyaw na inangun sang pagtanaw ng Tohan, yang pagpangagad sang sogo mayo atawa yang sogo ng Tohan? ");
INSERT INTO kqew_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kay di gaid mapakay na ondangan nami yang pagpayapat sang mga otaw ng makapantag sang kinita aw dyungug nami.” ");
INSERT INTO kqew_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na, syagda da oman silan ng mga pangoo aw byoyan silan. Aw maskin karim gao nilan kastigoon yani na dowangka otaw, di nilan ma-inang kay yamalluk silan sang mga otaw. Kay yang kariko ng mga otaw yagapoji sang Tohan sabap sidtong katingaan na ya-inang. ");
INSERT INTO kqew_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kay idtong otaw na pyakadyaw sobra da sang 40 ka toig yang idad. ");
INSERT INTO kqew_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na, pagkatapos kaboyan si Pitros aw si Yahiya, kyomadto silan sang mga kaupudanan nilan na mga yagapangintoo kang Isa aw paglaonga nilan ng pyaglaongan kanilan ng mga pangoo ng mga imam aw yang mga pangoo sang banwa. ");
INSERT INTO kqew_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na, pagdungug nilan sinyan, yagakasambok yang pagdowaa nilan adto sang Tohan aw laong nilan, “Ya Tohan na Labi na Mabarakat, ikaw yang yagabaoy ng langit aw lopa, kipat oman yang dagat aw yang kariko ng lasak sinyan. ");
INSERT INTO kqew_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sabap sang kabarakat ng Sotti na Nyawa yagalaong yang sogowanun mo na si Soltan Daud na kanami ompo sang pyatigam mo kanan, laong nan, “ ‘Nanga yadaman yang mga dili ng Yahodi? Nanga yagadumdum yang mga otaw ng pag-inang ng mga butang na way siyat? ");
INSERT INTO kqew_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yang mga soltan adi sa babawan ng donya yanag-andam aw yang mga pangoo yagakasambok untak lomaban sang Tohan kipat yang Almasi na pinili nan untak magdato.’ ");
INSERT INTO kqew_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ya Tohan,” laong nilan, “bunna sagaw yani na pyaglaongan kay yanagkatipon adi sini na syodad si Soltan Hirod aw si Pontiyos Pilato upud sang mga dili ng Yahodi aw yang mga bangsa Israil untak magkontra silan kang Isa na sotti na sogowanun mo maskin yan yang pinili mo untak magdato. ");
INSERT INTO kqew_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ininang nilan yani kay untak matoman yang pyagakahanda mo. Aw yamaitabo inyan sabap sang karim aw kabarakat mo. ");
INSERT INTO kqew_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aw adon, ya Tohan, tanawa yang pagpangalluk nilan kanami aw tabangi kami na mga sogowanun mo untak aon kaisug nami sang pagpayapat ng pyaglaongan mo. ");
INSERT INTO kqew_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipakita mo gao yang kammo kabarakat na ipakadyaw sang mga masakitun aw togotan mo gao kami pag-inang ng mga tanda aw katingaan sabap sang kabarakat ni Isa na sotti na sogowanun mo.” ");
INSERT INTO kqew_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapos nilan magdowaa, yamagayung yang baay na pyagatiponan nilan. Ansinyan pyagabuutan silan ng Nyawa ng Tohan aw wa da silan akalluk pagpayapat ng pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Adon, yang kariko ng mga yagapangintoo kang Isa yagakasambok yang dumduman aw pangatayan nilan. Way isa na yagalaong na yan gaid yang tagtomon ng kabutangan nan kondi pyagabain-bain nilan yang kariko ng mga butang nilan. ");
INSERT INTO kqew_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aw yang mga sahabat yagadan ng kabarakat ng Tohan pagsaksi makapantag sang pagkabowi oman ni Tagallang Isa, aw yang kariko ng mga yagapangintoo tyabangan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Way isa kanilan na aon pay pyagakinaanglan kay yang mga otaw na aon mga lopa atawa mga baay nilan yanagbarigya ninyan aw yang alin ");
INSERT INTO kqew_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yatag nilan adto sang mga sahabat. Aw ansinyan pyagabain-bain nilan yang sapi aw pangatagan sang mga otaw sobay sang pyagakinaanglan nilan. ");
INSERT INTO kqew_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, idto yang ininang ni Yosop na taga Kipros. Sambok na topo yan ng tribo ni Libi aw pyagangaanan yan ng mga sahabat kang Barnabas na yang mana san “yang otaw na yagapabagsug ng pangatayan.” ");
INSERT INTO kqew_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Byarigya nan yang kanan lopa aw yang alin sinyan dyaa nan adto sang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Adon, aon sambok na otaw na pyagangaanan kang Ananiyas aw yang kanan asawa si Sapira. Aon sangka parsila na lopa nilan na byarigya nilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Awgaid kyamang ni Ananiyas yang sangka bain ng alin aw tyago nan na yamatigam oman yang asawa nan. Ansinyan dyaa ni Ananiyas yang yamabilin na sapi adto sang mga sahabat aw paglaonga nan na idto yang alin ng kanilan lopa. ");
INSERT INTO kqew_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Awgaid yagalaong si Pitros kanan, “Kay Ananiyas, nanga yagapadaa kaw sang sasat kammo ni Iblis aw yamakak kaw sang Nyawa ng Tohan? Kay tyago mo yang kadaigan na sapi na alin ng kammo lopa. ");
INSERT INTO kqew_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sang wa pa mo abarigyaa yang lopa, kammo da yan. Aw pagbarigya da mo, ikaw oman yang makabuut daw onoon mo yang alin ninyan. Awgaid nanga yagadumdum kaw pag-inang ng maat? Kay yang pyagabakakan mo dili ng otaw awgaid yang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na, pagdungug ni Ananiyas sang pyaglaongan ni Pitros, yatomba yan aw kamatay. Aw yangkalluk da yang kariko ng mga otaw na yakadungug sinyan. ");
INSERT INTO kqew_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ansinyan aon dyomatung na mga olitawo aw balota nilan yang lawas ni Ananiyas aw daa adto sa logwa kay ilubung da nilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na, paglabay ng mga toongka oras, dyomatung si Sapira na wa akatigam sang yamaitabo sang kanan bana. ");
INSERT INTO kqew_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Adon yosip yan ni Pitros, laong nan, “Paglaonga ako, yani gaid yang alin sang lopa na byarigya mayo?” Tyomobag yan aw laong nan, “Uu, yan da yang kariko.” ");
INSERT INTO kqew_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ansinyan yagalaong si Pitros, “Nanga yagaka-oyon kamo na magasawa sang pagtigi sang Nyawa ng Tohan? Tanawa, yang mga otaw na yanaglubung sang kammo bana iyan da sang powertaan. Aw ikaw da adon yang adaun nilan adto sa logwa.” ");
INSERT INTO kqew_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na, sinyan dayon yatomba si Sapira apit sang siki ni Pitros aw kamatay. Pagsuud ng mga olitawo, kinita nilan na patay da yan. Ansinyan dyaa nilan yan adto sa logwa aw lubungan sang masaid sa kanan bana. ");
INSERT INTO kqew_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na, labi da yang alluk ng kariko ng mga yagapangintoo kipat yang kariko ng yakadungug sinyan na pangitabo. ");
INSERT INTO kqew_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, madaig yang mga tanda aw katingaan na ininang ng mga sahabat adto sang mga otaw. Aw yang kariko ng mga yagapangintoo yabay managkatipon adto sang pyagatawag na Pagasilongan ni Solayman. ");
INSERT INTO kqew_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pyaga-addatan silan ng mga otaw, awgaid yang kadaigan wa pagaka-isug mag-agad kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Awgaid maskin maynan, yagakadaig pa yang mga yagapangintoo kang Tagallang Isa, mga usug aw bobay. ");
INSERT INTO kqew_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na, sabap sang mga katingaan na ininang ng mga sahabat, dyaa ng mga otaw yang mga masakitun adto sang mga daan aw butangan nilan sang kowangan atawa kamun kay untak sang paglabay ni Pitros aw kalandongan pa gaid silan ng anino nan, magkadyaw silan. ");
INSERT INTO kqew_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na, madaig oman yang mga otaw sikun sang makilibot na mga banwa na kyomadto sa Awrosalam aw yagadaa silan ng mga masakitun kipat yang mga otaw na kyasaytanan. Aw yang kariko nilan yamadyaw. ");
INSERT INTO kqew_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na adon, yang Dakowa na Imam aw yang kariko ng mga kaupudanan nan na mimbro ng panon ng mga Sadoki, dakowa yang kasina nilan sang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Agaw pyandakup nilan silan aw pamirisowa nilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Awgaid pagkagabi sinyan aon malaikat na syogo ng Tohan na yaga-abri sang powertaan ng pirisowan aw pyalogwa nan yang mga sahabat. Aw laong nan kanilan, ");
INSERT INTO kqew_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kadto kamo sang Baay ng Tohan aw indowi mayo yang mga otaw makapantag sang kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Agaw pagka-ilaw ng masuum pa, kyomadto silan sang Baay ng Tohan sobay sang pyaglaongan kanilan ng malaikat aw yagasogod silan mag-indo sang mga otaw. Na adon, yang Dakowa na Imam aw yang mga kaupudanan nan, pyatawag nilan yang kariko ng mga pangoo sa bangsa Israil untak magtipon yang kariko ng mga opisyales ng Makagwas na Hokomanan. Pagkatapos san yagasogo silan na akamangun yang mga sahabat sikun sang pirisowan aw pa-atobangun kanilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Awgaid pagdatung ng mga syogo adto sang pirisowan, waa da don yang mga sahabat. Agaw yanagbarik silan adto sang Hokomanan kay paglaongon nilan yang mga pangoo, ");
INSERT INTO kqew_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","laong nilan, “Pagdatung nami adto sang pirisowan, kinita nami na kyandadowan yan ng madyaw aw yang mga gowardya yanagbantay adto sang mga powertaan. Awgaid pag-abri nami, way kinita nami adto sa suud!” ");
INSERT INTO kqew_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na, pagdungug sinyan ng mga pangoo ng mga imam kipat yang kapitan ng mga gowardya sang Baay ng Tohan, yamarido silan kay wa silan akatigam daw ono yang yamaitabo sang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ansinyan dyomatung yang sangka otaw na yagalaong kanilan, “Yang mga otaw na piniriso mayo, adto da silan sang Baay ng Tohan aw yaga-indo sang mga otaw!” ");
INSERT INTO kqew_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na, kyomadto da yang kapitan ng mga gowardya aw yang kanan mga otaw untak kamangun nilan yang mga sahabat. Awgaid wa nilan apugusa sang pag-agad kanilan kay yamalluk silan na basin abonoon silan ng mga otaw ng bato. ");
INSERT INTO kqew_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ansinyan dyaa nilan yang mga sahabat adto sang Makagwas na Hokomanan aw pa-induga nilan sa atobangan ng mga opisyales. Aw yosip silan ng Dakowa na Imam, ");
INSERT INTO kqew_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","laong nan, “Di ba syagda nami kamo na di da gaid kamo mag-indo sang ngaan nidtong otaw? Awgaid ono da yang ininang mayo? Yakarimpud da yang pyaga-indo mayo sang tibok Awrosalam aw kami pa yang tyakunan mayo sang pagpatay kanan!” ");
INSERT INTO kqew_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Awgaid tyomobag si Pitros aw yang kadaigan na mga sahabat, laong nilan, “Yang Tohan yang dait nami pangagadan, dili ng otaw. ");
INSERT INTO kqew_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yani si Isa pyatay mayo pina-agi sang paglansang sang kaoy. Awgaid byowi oman yan ng Tohan na pyagasambayangan ng kanatun kaompowan. ");
INSERT INTO kqew_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aw yatagan yan ng dakowa na kabantogan kay pyataas yan ng Tohan adto sa sorga sa apit ng karinto nan silbi soltan aw manlolowas kay untak kita na mga bangsa Israil makapagtawbat ng mga dosa ta aw atagan ng kaamponan. ");
INSERT INTO kqew_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Saksi kami sini na mga butang. Aw yagapangimunna oman sini yang Sotti na Nyawa na yatag ng Tohan adto sang mga otaw na yagapangagad kanan.” ");
INSERT INTO kqew_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na, pagdungug sinyan ng mga opisyales, labi da yang kadaman nilan aw karim nilan patayun yang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Awgaid aon sambok na opisyal na pyagangaanan kang Gamaliyal na mimbro ng panon ng mga Parisi. Magiindoway yan ng Hokoman aw yaddatan yan ng kariko ng mga otaw. Yamindug yan aw pagsogo na palogwaun yang mga sahabat ng madari gaid. ");
INSERT INTO kqew_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ansinyan yagalaong yan sang mga kaupudanan nan na mga opisyales, “Mga kalomonan ko na bangsa Israil, dumduma mayo ng madyaw daw ono yang inangun mayo sinyan na mga otaw. ");
INSERT INTO kqew_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kay singaon aon otaw na pyagangaanan kang Todas. Yagapa-ambog yan ng ginawa nan aw aon mga 400 ka otaw na yamagad kanan. Awgaid sang kataposan, pyatay yan aw yanagkakanat-kanat da yang kariko ng mga inagad nan. Aw waa da idtong gropo nilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos sinyan, sang wakto ng pagbilang ng mga otaw, si Yodas da oman na taga Jalil yang yagapasonod ng mga otaw. Aw madaig oman yang yamagad kanan. Awgaid pyatay da oman yan aw yanagkakanat-kanat da oman yang kariko ng mga inagad nan. ");
INSERT INTO kqew_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Agaw adon, makapantag sinyan na mga otaw, pagalaongon ta kamo na ayaw kamo pangilabot kanilan. Pabayai mayo silan! Kay kong sikun sang manosiya yang katoyowan aw ininang nilan, na, sang di amadogay amawaa da yan. ");
INSERT INTO kqew_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Awgaid kong sikun yani sang Tohan, na, di da gaid kamo makadaog kanilan. Aw basin malaban pa kamo sang Tohan!” Na, yagapangagad da silan sang tambag ni Gamaliyal. ");
INSERT INTO kqew_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pyatawag oman nilan yang mga sahabat aw pyabadasan nilan. Pagkatapos, syagda nilan na di da gaid silan mag-indo sang ngaan ni Isa aw booi nilan. ");
INSERT INTO kqew_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, pyomanaw da yang mga sahabat sikun sang Makagwas na Hokomanan na bali na kasowat nilan kay tyogotan silan ng Tohan sang pag-agi ng kamomowaan sabap sang pagpangagad nilan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ansinyan allaw-allaw adto silan sang Baay ng Tohan aw adto oman sang mga baay aw yagapadayon silan mag-indo aw magpayapat ng Madyaw na Gogodanun na si Isa yang Almasi. ");
INSERT INTO kqew_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na, sidto na mga allaw sarta yagakadaig yang mga yagapangintoo kang Isa, yanagbagolbol yang mga Yahodi na Grik yang pyaglaongan adto sang mga Yahodi na Hibrani yang pyaglaongan. Yagalaong silan na sang matag allaw na pagpangatag ng pagkan wa akatagi yang mga biyoda nilan. ");
INSERT INTO kqew_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Agaw pyatawag ng sampoo aw dowa na mga sahabat yang kariko ng mga yagapangintoo kang Isa aw yagalaong silan, “Dili ng madyaw aw biyaan nami yang pag-osiyat ng pyaglaongan ng Tohan untak mag-atiman sang mga pagpangatag. ");
INSERT INTO kqew_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Agaw adon, mga kalomonan, pagpili kamo sikun sang mga kaupudanan mayo ng pitongka otaw na madyaw yang dungug, aon katigam aw yabay pagbuutan ng Nyawa ng Tohan. Aw silan yang atagan ta sini na gawbuk. ");
INSERT INTO kqew_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aw kami, magapadayon kami ng pagdowaa aw pag-osiyat ng pyaglaongan ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ansinyan yanagka-oyon yang kariko nilan sang pyaglaongan ng mga sahabat. Agaw pinili nilan si Istiban, sambok na otaw na mabagsug yang pagpangintoo aw pyagabuutan ng Nyawa ng Tohan. Yang kadaigan na pinili nilan si Pilip aw si Prokoros, si Nikanor aw si Timon, si Parminas aw si Nikolas na taga Antiyok. Yani si Nikolas dili ng Yahodi, awgaid yagapasakop yan sang agama Yahodi. ");
INSERT INTO kqew_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ansinyan dyaa nilan yani na pitongka otaw adto sang mga sahabat. Yanagdowaa silan para kanilan na dyapunan nilan ng arima. ");
INSERT INTO kqew_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ansinyan yagapadayon yang pagpayapat sang pyaglaongan ng Tohan aw yagakadaig yang mga yagapangintoo kang Isa adto sa Awrosalam. Madaig oman yang mga imam na yagapangagad kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Adon si Istiban, yabay yan tabangan ng Tohan aw yagadan ng kabarakat ng Tohan yang ininang nan. Agaw, madaig yang mga tanda aw katingaan na ininang nan sa atobangan ng mga otaw. ");
INSERT INTO kqew_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Awgaid aon oman mga otaw na yagakontra kanan, mga mimbro ng pagsasambayangan na pyagatawag ng Jamaa ng mga Yamalowas sikun sang Pagka-allang. Yani silan mga Yahodi na taga Kirini aw Iskandariya. Silan aw yang kadaigan pa ng mga Yahodi na yagasikun sang probinsya ng Kilikiya aw Asiya yapaglalis kang Istiban. ");
INSERT INTO kqew_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Awgaid tyabangan si Istiban ng Nyawa ng Tohan aw yatagan yan ng katigam sang pagtobag kanilan. Agaw wa silan pakadaog kanan. ");
INSERT INTO kqew_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ansinyan yabayadan nilan yang pilangka otaw untak maglaong silan ng bakak makapantag kang Istiban. Aw maynini yang pyagalaong nilan, “Yadungug nami na yagalaong si Istiban ng maat makapantag kang Nabi Mosa aw makapantag sang Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na, sang mayninyan na pama-agi syamok nilan yang mga otaw kipat yang mga pangoo sang banwa aw yang mga magiindoway ng Hokoman. Agaw dyakup nilan si Istiban aw dyaa nilan adto sang Makagwas na Hokomanan. ");
INSERT INTO kqew_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aon oman pyasuud nilan na mga otaw na yagasaksi ng bakak aw laong nilan, “Yani na otaw yabay maglaong ng maat makapantag sang kanatun sotti na Baay ng Tohan aw makapantag sang Hokoman ni Nabi Mosa. ");
INSERT INTO kqew_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kay yadungug nami na yagalaong yan na agubaun kono ni Isa na taga Nasarit yani na Baay ng Tohan aw parinun nan yang kanatun kabatasanan na pyaga-indo ni Nabi Mosa adto sang kanatun mga kaompowan.” ");
INSERT INTO kqew_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na, yang kariko ng mga opisyales ng Hokomanan, pyakatanawan nilan si Istiban aw kinita nilan na yang kanan parangay maynang parangay ng malaikat. ");
INSERT INTO kqew_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ansinyan yaga-osip yang Dakowa na Imam kang Istiban, “Bunna ba yani na pyaglaongan nilan makapantag kammo?” ");
INSERT INTO kqew_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tyomobag si Istiban, “Mga taganak ko aw mga kalomonan ko, paningugi mayo ako. Yang Tohan na Labi na Mabarakat yagapakita singaon sang kanatun ompo na si Nabi Ibrahim nang idto pa yan sang banwa ng Misopotamiya sang wa pa yan paga-uya adto sa Haran. ");
INSERT INTO kqew_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aw yagalaong yang Tohan kanan, ‘Panawi yang kammo banwa aw yang kammo kalomonan aw kadto sang banwa na ipakita ko kammo.’ ");
INSERT INTO kqew_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ansinyan pyomanaw si Nabi Ibrahim sikun sang kanan banwa na pyagangaanan sang Kaldiya aw pag-uya adto sang syodad ng Haran. Pagkamatay ng kanan ama, pyaballin yan ng Tohan ansini na banwa na pyaga-uyaan ta adon. ");
INSERT INTO kqew_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Awgaid maskin maynan, wa pa atagi ng Tohan si Nabi Ibrahim ng lopa ansini na banwa, na maskin sangka parsila da gaid. Awgaid yagapasad yang Tohan na i-atag nan kang Nabi Ibrahim kipat sang kanan mga topo yani na banwa. Pagpasad sinyan ng Tohan, waa pay anak ni Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na, yani yang pyaglaongan ng Tohan adto kang Nabi Ibrahim, laong nan, ‘Yang kammo mga topo manag-uya sang tuna na banwa na dili ng kanilan banwa. Ma-inang silan adto ng mga allang aw daog-daogon silan sa suud ng 400 ka toig. ");
INSERT INTO kqew_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Awgaid asiksaun ko yang mga otaw na yaga-allang kanilan. Pagkatapos san,’ laong ng Tohan, ‘mapanaw da silan sikun sinyan na banwa aw magabarik silan adi aw magasambayang silan kanak ansini na banwa.’ ");
INSERT INTO kqew_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ansinyan pyagalaong ng Tohan si Nabi Ibrahim na dait toliun yang kariko ng kausugan na kanan sakop silbi tanda ng pyagapasadan na ininang ng Tohan adto kang Nabi Ibrahim. Agaw tyoli ni Nabi Ibrahim yang kanan anak na si Isahak sang ikawaong allaw sikun sang pagkaotaw nan. Si Isahak oman, tyoli nan si Yakob na anak nan. Maynan oman si Yakob, tyoli nan yang sampoo aw dowa na mga anak nan na silan yang kaompowan ta na mga Yahodi.” ");
INSERT INTO kqew_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, yang mga anak ni Yakob yamasina sang mangod nilan na si Yosop. Agaw byarigya nilan yan aw ya-inang yan ng allang adto sang bangsa ng Misir. Awgaid iyan kanan yang Tohan ");
INSERT INTO kqew_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aw lyowas nan yan sikun sang kariko ng kasikotan na ya-agian nan. Dakowa oman yang katigam na yatag ng Tohan kang Yosop. Agaw, pag-atobang nan sang soltan sa Misir, yaka-oyon yan kanan. Ansinyan ininang nan si Yosop ng gobirnador sa Misir aw yatagan yan ng kapatot ng pagsogo sang kariko ng mga otaw adto sang palasyo nan. ");
INSERT INTO kqew_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ansinyan aon dyomatung na gutum sang tibok banwa ng Misir kipat oman sang banwa ng Kanaan. Dakowa yang kasikotan na ya-agian ng mga otaw sabap sidto na gutum. Aw yang mga kaompowan ta, waa day pagkan na kinita adto sang banwa nilan. ");
INSERT INTO kqew_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Agaw, pagdungug ni Yakob na aon pay pagkan adto sa Misir, pyakadto nan yang kanan mga anak aw idto yang pukas na pagkadto nilan sang Misir. ");
INSERT INTO kqew_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sang ikadowa na pagkadto nilan, yagapakilaa si Yosop sang mga lomon nan aw pyagalaong oman nan yang soltan makapantag sang kanan pamilya. ");
INSERT INTO kqew_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ansinyan yagatogon si Yosop adto sang kanilan ama na pakadtonon da yan sang Misir kipat yang kariko ng pamilya nan. Aw yang kadaig nilan 75 ka otaw. ");
INSERT INTO kqew_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Agaw kyomadto da si Yakob aw yang mga kaompowan ta adto sa Misir. Aw adto da silan paga-uya taman sang yamangkamatay silan. ");
INSERT INTO kqew_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Awgaid yang patay na mga lawas nilan dyaa adto sa Sikim sang banwa ng Kanaan. Aw adto silan alubungan sang lopa na binili ni Nabi Ibrahim singaon sikun sang mga anak ni Hamor. ");
INSERT INTO kqew_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na, sang kadogay ng panahon yagakadaig yang kanatun mga kaompowan adto sa Misir. Aw ansinyan dyomatung yang wakto na masaid da matoman yang pasad ng Tohan adto kang Nabi Ibrahim. ");
INSERT INTO kqew_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sidto na wakto aon sambok na soltan sang Misir na wa akatigam ng makapantag kang Yosop. ");
INSERT INTO kqew_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pyagadaog-daog nan yang kanatun mga kaompowan aw pyasikotan nan silan. Pyugus nan silan na idami nilan yang mga isu na usug na yagasoso pa adto sa logwa untak mangkamatay silan. ");
INSERT INTO kqew_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na, sidto na wakto yaotaw si Mosa. Madyaw yan na isu aw kya-oyonan yan ng Tohan. Yatiman yan ng taganak nan adto sang kanilan baay sa suud ng toombowan. ");
INSERT INTO kqew_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Awgaid nang di da nilan matago, dyaa nilan yan adto sa logwa. Na, kyamang da yan ng anak na bobay ng soltan aw pyadakowa nan mag-onawa ng bunna na anak nan. ");
INSERT INTO kqew_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ansinyan pyaga-indowan si Mosa ng kariko ng katigam ng taga Misir. Aw yamabantog yan kay matigam yan maglaong-laong aw madyaw oman yang ininang nan. ");
INSERT INTO kqew_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na, sang yaga-idad si Mosa ng 40 ka toig, yagadumdum yan komadto sang mga kalomonan nan na bangsa Israil untak tanawon nan daw ono yang kabutang nilan. ");
INSERT INTO kqew_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ansinyan kinita nan yang sangka otaw na bangsa Israil na pyagadaog-daog ng taga Misir. Agaw tyabangan nan yang lomon nan na bangsa Israil aw yapaglaban yan sidtong taga Misir taman sang pyatay da nan. ");
INSERT INTO kqew_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Na, pagtoo ni Mosa na yakasabot da yang mga kalomonan nan na bangsa Israil na agamitun yan ng Tohan sang paglowas kanilan sikun sang kanilan kasikotan. Awgaid wa silan pakasabot. ");
INSERT INTO kqew_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagka-ilaw sinyan aon kinita nan na dowangka otaw na bangsa Israil na yanagtanam. Tyabangan gao nan silan untak mag-osay aw laong nan kanilan, ‘Oy, maglomon kamo. Nanga yanagtanam kamo?’ ");
INSERT INTO kqew_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Awgaid idtong yagapasakit sang lomon nan, tyood nan si Mosa aw paglaonga nan, ‘Sino yang yag-atag kammo ng kapatot ng pagdato aw paghokom kanami? ");
INSERT INTO kqew_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Basin apatayun mo oman ako mag-onawa sidtong taga Misir na pyatay mo kagabi?’ ");
INSERT INTO kqew_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na, pagdungug sinyan ni Mosa, yalayas yan sikun sa Misir aw kyomadto sang banwa ng Midiyan. Adto da yan paga-uya sampay na yaminyo aw adto oman yaotaw yang dowa na anak nan na usug.” ");
INSERT INTO kqew_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yagapadayon si Istiban maglaong, “Paglabay ng 40 ka toig nang adto si Mosa sang diserto na masaid sang Butay ng Torosina, aon yagapakita kanan na malaikat sang tagbi na kaoy na yamallaga. ");
INSERT INTO kqew_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yatingaa sagaw si Mosa sidtong kinita nan, agaw dyomood yan sang kaoy untak pakatanawan nan. Ansinyan dyungug nan yang sowara ng Tohan na yagalaong, ");
INSERT INTO kqew_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako yang Tohan na pyagasambayangan ng kammo kaompowan, yang Tohan ni Ibrahim, ni Isahak aw si Yakob.’ Na, pagdungug sinyan, tyakigan si Mosa ng alluk aw wa da yan pakatanaw sang atoon sang tagbi na kaoy. ");
INSERT INTO kqew_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ansinyan yagalaong kanan yang Tohan, ‘Lobasa yang sandalyas mo kay sotti yang pyaga-indugan mo. ");
INSERT INTO kqew_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kinita ko yang pagpasikot sang kanak mga otaw adto sa Misir. Aw dyungug ko yang kanilan pag-ungas-ungas. Agaw yakani ako untak lowasun ko silan sikun sang kasikotan nilan. Na, pag-andam kay asogoon ta kaw adto sa Misir.’ ");
INSERT INTO kqew_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Yani si Nabi Mosa tyarikodan singaon ng mga bangsa Israil kay yagalaong silan, ‘Sino yang yaga-atag kammo ng kapatot ng pagdato aw paghokom kanami?’ Awgaid yan agaw yang syogo ng Tohan untak ma-inang ng pangoo nilan na magalowas kanilan sikun sang kasikotan adto sa Misir. Aw tyabangan yan ng malaikat na yagapakita kanan adto sang tagbi na kaoy na yamallaga. ");
INSERT INTO kqew_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Nabi Mosa agaw yang yagapangoo sang mga bangsa Israil sang pagpanaw nilan sikun sa Misir. Madaig yang mga tanda aw katingaan na ininang nan adto sa Misir, adto sa Dagat na Mapowa aw adto oman sang diserto sa suud ng 40 ka toig. ");
INSERT INTO kqew_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Nabi Mosa yang yagalaong sang kanatun kaompowan na bangsa Israil, laong nan, ‘Sang madatung na mga allaw apadaan kamo ng Tohan ng sambok na nabi na mag-onawa kanak na magasikun oman kamayo na bangsa Israil.’ ");
INSERT INTO kqew_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yani si Nabi Mosa, iyan yan upud sang kanatun kaompowan na bangsa Israil nang yanagkatipon silan adto sang diserto aw iyan yan upud sang malaikat na yapagbaaw kanan adto sang Butay ng Torosina. Si Nabi Mosa yang yadawat sang pyaglaongan ng Tohan na maka-atag ng kinabowi untak ipasampay nan kanatun. ");
INSERT INTO kqew_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Awgaid yang kanatun kaompowan,” laong ni Istiban, “wa silan pagatoman kang Nabi Mosa. Tyarikodan nilan yan aw karim gao nilan magbarik adto sa Misir. ");
INSERT INTO kqew_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Agaw yagalaong silan kang Haron, ‘Pag-inangan kami ng mga tagallang na ama-ona kanami kay yani si Nabi Mosa na yagadaa kanami sikun sa Misir, wa kami akatigam daw ono yang yamaitabo kanan.’ ");
INSERT INTO kqew_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na, idto yang wakto na yaga-inang silan ng barhala na maynang nati ng baka. Yagapakorban silan sidtong barhala aw yanagpakaradyaan silan untak bantogon nilan yang kanilan ininang. ");
INSERT INTO kqew_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na, sabap sinyan tyarikodan silan ng Tohan aw pyabayaan nan silan na magasambayang ng mga bitoon adto sang langit mag-onawa ng syorat ng nabi sang Kitab, laong nan, “ ‘Mga otaw na bangsa Israil, sa suud ng 40 ka toig sarta adto kamo sang diserto, yagasobari kamo ng mga ayup aw pyakorban mayo, awgaid yang idto na mga korban dili para kanak. ");
INSERT INTO kqew_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kay yang yabay mayo daun yang baay-baay ng barhala mayo na si Molok, kipat yang barhala mayo na pyagangaanan kang Ripan na porma ng bitoon. Yang idto yang mga barhala na ininang mayo kay untak sambayangan mayo. Agaw apasagdan ko kamo na adaun kamo adto sang sambok na banwa na mas mawat pa kaysang Babilon.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yagapadayon pa si Istiban maglaong, “Na, sarta adto sang diserto yang mga kaompowan ta, aon dyaa nilan na tolda na pagsasambayangan na idto yang tanda na iyan kanilan yang Tohan. Yan na tolda ininang sobay sang sogo ng Tohan aw sobay oman sang pyakita ng Tohan kang Nabi Mosa. ");
INSERT INTO kqew_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pagkamatay ni Nabi Mosa, dyawat ng mga kaompowan ta yan na tolda sikun sang mga ama nilan. Aw dyaa nilan inyan pagsuud nilan adi sini na banwa sang wakto na yagapangoo kanilan si Yossa. Sabap sang tabang ng Tohan pyapanaw nilan yang mga otaw na yagakatuna-tuna yang bangsa untak kanilan da yani na banwa. Aw yang inyan na tolda yang pagsasambayangan nilan taman sang wakto ng pagkasoltan ni Daud. ");
INSERT INTO kqew_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na, madyaw yang ginawa ng Tohan adto kang Soltan Daud. Aw yagapangayo si Soltan Daud adto sang Tohan na atogotan yan pag-inang ng Baay na pyaga-uyaan ng Tohan na pyagasambayangan ni Yakob na kanatun ompo. ");
INSERT INTO kqew_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Awgaid dili ni Soltan Daud kondi si Soltan Solayman yang yaga-inang ng Baay ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Awgaid yang Tohan na Labi na Makagwas wa paga-uya sang baay na ininang ng manosiya. Kay aon syorat ng nabi sang Kitab na yagalaong yang Tohan, laong nan, ");
INSERT INTO kqew_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘Yang sorga yang ingkodanan ko, aw yang donya yang tongtonganan ng siki ko. Na, ono da yang baay na inangun mayo kanak? Aw wain kadi yang pagapatanaan ko? ");
INSERT INTO kqew_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Di ba ako yang yaga-inang ng kariko sini na mga butang?’ ” ");
INSERT INTO kqew_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Aw yagalaong pa si Istiban, “Matigas sagaw yang oo mayo! Di kamo amangagad sang Tohan aw di oman kamo amaningug sang pyaglaongan nan. Yabay gaid mayo sopakun yang Nyawa ng Tohan. Mag-onawa sagaw kamo sang mga kaompowan mayo! ");
INSERT INTO kqew_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kay way nabi na wa nilan apasikoti. Aw pyatay nilan maskin yang mga syogo ng Tohan na yagapatigam ng pagdatung ng Almasi na matorid na sogowanun nan. Aw pagdatung nan, kamo yang yagatraydor aw yagapatay kanan. ");
INSERT INTO kqew_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo yang yatagan ng Hokoman na pyasampay ng Tohan kang Nabi Mosa pina-agi sang malaikat. Awgaid wa mayo apangagadi!” ");
INSERT INTO kqew_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na, pagdungug sinyan ng mga opisyales ng Hokomanan, yangolitub yang onto nilan sabap sang bali na kadaman nilan. ");
INSERT INTO kqew_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Awgaid si Istiban, pyagabuutan yan ng Nyawa ng Tohan aw ya-angad adto sang langit. Aw kinita nan yang Tohan sang dakowa na kasiga nan aw si Isa na yaga-indug apit sang karinto ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Tanawa mayo,” laong ni Istiban, “kya-abrian da yang sorga aw kinita ko yang Anak ng Manosiya na yaga-indug apit sang karinto ng Tohan!” ");
INSERT INTO kqew_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Na, yagapiyagit da yang kariko ng mga opisyales aw tyabonan nilan yang taringa nilan. Yanagdungan silan domaagan adto kang Istiban ");
INSERT INTO kqew_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aw igoyod nilan yan adto sa logwa ng syodad kay untak bonoon nilan ng bato sampay na akamatay da nan. Yang idtong mga otaw na yagasaksi ng bakak makapantag kang Istiban yanaglobas ng joba nilan untak way makasagabal kanilan aw byutang nilan apit sang sambok na olitawo na pyagangaanan kang Saul. ");
INSERT INTO kqew_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na, sarta pyagabono nilan si Istiban ng bato, yagadowaa yan, “Kay Isa na Tagallang ko, dawata yang kanak nyawa.” ");
INSERT INTO kqew_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ansinyan lyomood yan aw yagapiyagit aw laong nan, “Ya Tohan, ampona silan sini na dosa na ininang nilan!” Paglaong nan sinyan, yamabogto da yang napas nan. ");
INSERT INTO kqew_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ansinyan kyobor si Istiban ng bara-ibada na mga otaw aw bali na pagtiyao nilan sabap kanan. Awgaid si Saul yaka-oyon sang pagpatay kanan. Na, sidto na allaw yagasogod da yang bali na pagpasikot sang jamaa ng mga yagapangintoo kang Isa Almasi adto sa Awrosalam. Sabap sinyan yanagkakanat-kanat yang mga yagapangintoo adto sang kariko ng Yahodiya aw Samariya. Yang mga sahabat dakoman yang yamabilin adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Awgaid si Saul, yagasogod da yan magpasikot sang jamaa kay karim nan na waa day amabilin kanilan. Agaw kyomadto yan sang kabaayan aw goyoda nan adto sa logwa yang mga yagapangintoo, usug aw bobay, aw pamirisowa silan. ");
INSERT INTO kqew_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, yang mga yagapangintoo na yanagkakanat-kanat, yagapayapat ng pyaglaongan ng Tohan maskin wain silan akadto. ");
INSERT INTO kqew_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yang isa kanilan si Pilip. Adon, kyomadto si Pilip sang sambok na syodad sang probinsya ng Samariya aw pag-osiyat sang mga otaw ng makapantag sang Almasi. ");
INSERT INTO kqew_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na, pagdungug ng mga otaw sang pyaga-indo nan aw pagkita nilan sang mga katingaan na ininang nan, yamaningug silan ng madyaw sang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Madaig yang mga kyasaytanan na pyakadyaw nan aw yagapiyagit yang mga saytan paglogwa nilan sikun sang mga otaw. Madaig oman yang mga sadi aw yang mga otaw na yamatay da yang sangka bain ng lawas nilan na yamadyaw. ");
INSERT INTO kqew_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Agaw, labi da yang kasowat ng mga otaw ansidto na syodad. ");
INSERT INTO kqew_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Awgaid aon oman sambok na otaw ansidto na pyagangaanan kang Simon. Dogay da yangkatingaa kanan yang mga taga Samariya sabap sang kanan katigam magmadyik. Yagapa-ambog si Simon na mabarakat yan na otaw. ");
INSERT INTO kqew_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aw yang kariko ng mga otaw daw mairap atawa madyaw yang kabutang nilan, yamaningug ng madyaw kang Simon aw yagalaong silan, “Yatagan yan ng kabarakat ng Tohan aw yan kowaw yang tyawag na Dakowa na Kabarakat.” ");
INSERT INTO kqew_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yamaningug kanan yang mga otaw kay dogay da silan yangkatingaa sabap sang kanan katigam sang pagmadyik. ");
INSERT INTO kqew_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Awgaid adon, pag-osiyat ni Pilip ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan kipat makapantag kang Isa Almasi, yagapangintoo silan aw yagapasogbo silan, mga usug aw bobay. ");
INSERT INTO kqew_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na, maskin oman si Simon yagapangintoo da. Aw pagkatapos nan magpasogbo, yamagad yan kang Pilip aw yatingaa sagaw yan sang pagkita nan sang mga katingaan aw tanda na ininang ni Pilip. ");
INSERT INTO kqew_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na, pagdungug ng mga sahabat adto sa Awrosalam na yang mga taga Samariya yagapangintoo da sang pyaglaongan ng Tohan, syogo nilan si Pitros aw si Yahiya adto sa Samariya. ");
INSERT INTO kqew_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagdatung nilan adto, yagadowaa silan para sang mga yagapangintoo na amadawat nilan yang Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kay wa pa adatung kanilan yang Nyawa ng Tohan, awgaid syogbowan pa gaid silan sang ngaan ni Tagallang Isa silbi tanda na yagapangintoo silan kanan. ");
INSERT INTO kqew_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ansinyan dyapunan silan ni Pitros aw si Yahiya ng kanilan arima aw yadawat da nilan yang Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na, pagkita ni Simon na dyawat ng mga yagapangintoo yang Nyawa ng Tohan sang pagdapun kanilan ng mga sahabat ng arima nilan, dyomood yan adto kang Pitros aw si Yahiya aw atagan gao nan silan ng sapi. ");
INSERT INTO kqew_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Laong nan, “Atagi mayo ako sini na kapatot kay untak yang maskin sino na adapunan ko ng kanak arima makadawat ng Nyawa ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Awgaid yagalaong kanan si Pitros, “Asiksaun kaw upud sang sapi mo kay yagadumdum kaw na amabili mo yang kabarakat na i-atag ng Tohan! ");
INSERT INTO kqew_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Way labot mo aw way oman kabain mo sini na gawbuk nami kay dili ng matorid yang pangatayan mo adto sang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Agaw pagtawbat sining maat na dumduman mo aw pangayo-ngayo adto sang Tohan kay basin amponon pa kaw nan. ");
INSERT INTO kqew_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kay yakita ko na bali na kasina mo aw main kaw ng allang ng dosa.” ");
INSERT INTO kqew_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ansinyan yagalaong si Simon kanilan, “Tabiya, pangayowa mayo adto sang Tohan na di ako adatungan ng siksa na pyagalaong mayo kanak.” ");
INSERT INTO kqew_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na, pagkatapos ni Pitros aw si Yahiya magsaksi makapantag kang Isa aw mag-osiyat ng pyaglaongan ng Tohan, yamori silan adto sa Awrosalam. Aw sang pag-ori nilan yaga-osiyat oman silan ng Madyaw na Gogodanun sang mga baryo na ya-agian nilan adto sang probinsya ng Samariya. ");
INSERT INTO kqew_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ansinyan aon sambok na malaikat na syogo ng Tohan adto kang Pilip na yagalaong kanan, “Pag-andam aw kadto sang daan na yagasikun sa Awrosalam paduug sa Gasa.” Yan na daan yamagi sang diserto. ");
INSERT INTO kqew_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Agaw pyomanaw da si Pilip. Aw adto sidtong daan aon kinita nan na otaw na taga Itiyopa. Barapantag yan na opisyal ng soltana sang Itiyopa, yang pyagatawag na Kandisa, aw sinarigan sang kariko ng kakawasaan nan. Sikun yan sa Awrosalam kay yaga-ibada yan adto sang Tohan ");
INSERT INTO kqew_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aw adon yamori da oman yan. Yakasakay yan sang kalisa aw yagabatya sang Kitab na syorat ni Nabi Isayas. ");
INSERT INTO kqew_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ansinyan yagalaong yang Nyawa ng Tohan adto kang Pilip, “Kadtoni yang kalisa aw agadi.” ");
INSERT INTO kqew_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na, dyomaagan si Pilip aw pag-apas nan sidtong kalisa, yadungug nan na yagabatya yang taga Itiyopa ng Kitab na syorat ni Nabi Isayas. Ansinyan yaga-osip si Pilip kanan, “Makasabot ba kaw sang byatya mo?” ");
INSERT INTO kqew_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tyomobag yang opisyal, “Monono yang pagkasabot ko kong way magapatigam kanak?” Ansinyan pyasakay nan si Pilip aw pyapag-ingkod sang kilid nan. ");
INSERT INTO kqew_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na, yang pyagabatya nan sa Kitab yang syorat ni Nabi Isayas na yagalaong, “Masabar yan na mag-onawa ng karniro na igoyod adto sang magasobari kanan. Aw yagapakatingun yan mag-onawa ng nati ng karniro na wa pagatingug sarta pyagagontingan. ");
INSERT INTO kqew_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pyakamomowaan yan ng mga otaw aw yang paghokom kanan dili ng matorid. Way otaw na makagogod makapantag sang mga topo nan kay yang kanan kinabowi adi sang donya kyamang da.” ");
INSERT INTO kqew_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ansinyan yaga-osip yang opisyal kang Pilip, “Tabiya, paglaonga ako daw sino yang pyasabot ng nabi, yang kanan sarili atawa tuna na otaw?” ");
INSERT INTO kqew_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na, tyomobag da si Pilip aw sikun sidtong ayatan na pyagabatya ng opisyal pyatigam nan kanan yang Madyaw na Gogodanun makapantag kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Adon, sarta yagapadayon silan sang daan dyomatung silan sang sambok na logar na aon tobig. Ansinyan yagalaong yang opisyal, “Tanawa, aon tobig disini. Aon bay pyagasabapan nanga di mapakay na sogbowan mo ako?” ");
INSERT INTO kqew_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tyomobag si Pilip kanan, “Mapakay kong iklas yang pagpangintoo mo kang Isa.” Yagalaong yang opisyal, “Uu, yagapangintoo ako na si Isa yang Anak ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ansinyan pyara ng opisyal yang kalisa aw panaog silan dowa. Yapanaw silan adto sang tobig aw syogbowan da yan ni Pilip. ");
INSERT INTO kqew_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagsaka nilan sikun sang tobig, sakadyap kyamang si Pilip ng Nyawa ng Tohan aw wa da yan akitaa ng opisyal. Ansinyan yagapadayon da yan pag-ori na bali na kasowat nan. ");
INSERT INTO kqew_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Awgaid si Pilip, yakadatung yan adto sang syodad ng Asotos. Aw sikun ansidto yaga-osiyat yan ng Madyaw na Gogodanun sang kariko ng mga banwa na ya-agian nan sampay na dyomatung yan adto sa Kisariya. ");
INSERT INTO kqew_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Adon si Saul, yagapadayon yan magpasikot sang mga yagapangintoo kang Tagallang Isa kay karim nan na apamatayun silan. Agaw kyomadto yan sang Dakowa na Imam ");
INSERT INTO kqew_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aw pangayo kanan ng mga sorat na adaun nan adto sang mga pangoo ng pagsasambayangan ng mga Yahodi sang Damaskos. Yani na mga sorat magapatigam kanilan na aon kapatot nan pagdakup sang maskin sino na akitaun nan, usug aw bobay, na yagapangagad kang Isa Almasi. Aw pagdakup kanilan, adaun nan silan adto sa Awrosalam untak pirisoon silan. ");
INSERT INTO kqew_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ansinyan pyomanaw da si Saul. Aw nang masaid da yan sang Damaskos, sakadyap kyapawaan yan ng masilaw na allag sikun sang langit. ");
INSERT INTO kqew_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na, sinyan dayon yatomba yan sang lopa aw aon dyungug nan na sowara na yagalaong kanan, “Saul, Saul, nanga pyagapasikotan mo ako?” ");
INSERT INTO kqew_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Sino kaw, kay Dato?” laong ni Saul. Tyomobag yang sowara, “Ako si Isa na pyagapasikotan mo. ");
INSERT INTO kqew_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Adon, pag-indug aw kadto sang syodad kay ansidto aon magalaong kammo daw ono yang dait mo inangun.” ");
INSERT INTO kqew_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na, yang mga kaupudanan ni Saul yaga-indugun gaid ansan na wa pakapaglaong. Dyungug nilan yang sowara, awgaid way kinita nilan na otaw. ");
INSERT INTO kqew_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ansinyan yamindug si Saul. Awgaid pagboka nan ng kanan mata, di da yan makakita. Agaw pyaga-agakan da yan ng mga kaupudanan nan paduug sa Damaskos. ");
INSERT INTO kqew_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa suud ng toong allaw wa yan pakakita aw way kyan aw way ininum nan. ");
INSERT INTO kqew_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Adon, aon sambok na otaw na yagapangintoo kang Isa adto sa Damaskos na pyagangaanan kang Ananiyas. Yagapakita kanan si Tagallang Isa sang pagpananaw aw yagalaong kanan, “Kay Ananiyas.” Tyomobag yan, “Idi ako, kay Tagallang.” ");
INSERT INTO kqew_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yagalaong kanan yang Tagallang, “Adto kaw sang daan na pyagatawag ng Matorid na Daan aw anapa adto sang baay ni Yodas yang otaw na taga Tarsos na pyagangaanan kang Saul. Kay yagadowaa yan adto. ");
INSERT INTO kqew_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aon pyakita ko kanan na madatung yang sambok na otaw na ikaw agaw. Dapunan mo yan ng arima mo untak makakita oman yan.” ");
INSERT INTO kqew_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yagalaong si Ananiyas, “Kay Tagallang, madaig yang yagagogod kanak makapantag sidto na otaw aw makapantag sang pagpasikot nan sang mga otaw na sakop mo adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aw adon yakani yan kay yatagan yan ng mga pangoo ng mga imam ng kapatot ng pagdakup sang kariko ng mga otaw na yagasampit sang ngaan mo.” ");
INSERT INTO kqew_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Awgaid yagalaong yang Tagallang kang Ananiyas, “Panaw da kay pinili ko si Saul untak magpayapat ng makapantag kanak adto sang mga dili ng Yahodi aw yang mga soltan nilan kipat oman sang mga otaw na bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aw ipatigam ko kanan yang kariko ng kasikotan na dait nan agian sabap sang pagpangagad nan kanak.” ");
INSERT INTO kqew_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ansinyan pyomanaw si Ananiyas aw kyomadto yan sidtong baay na pyanikan ni Saul. Pagsuud nan, dyapunan nan si Saul ng arima nan aw paglaonga nan, “Lomon Saul, syogo ako adi kammo ng Tagallang. Yan si Isa na yagapakita kammo adto sang daan nang yagapaduug kaw adi sa Damaskos. Pyakani nan ako kammo kay untak makakita kaw oman aw makadawat kaw ng Nyawa ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Paglaong nan sinyan, aon yamallog na maynang imbis sikun sang mata ni Saul aw yakakita da oman yan. Ansinyan yamindug si Saul aw yagapasogbo yan silbi tanda na yagapangintoo da yan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aw pagkatapos nan koman, kya-orian da oman yan ng kusug. Ansinyan yagapabilin si Saul ng pilang allaw adto sa Damaskos upud sang mga yagapangintoo kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yagasogod dayon yan mag-osiyat adto sang mga pagsasambayangan ng mga Yahodi na si Isa bunna na Anak ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na, yatingaa da yang kariko ng mga yakadungug kanan aw yagalaong silan, “Di ba yan yang ingaong otaw na yagapasikot sang mga yagasampit sang ngaan ni Isa adto sa Awrosalam? Di ba yakani yan adon untak dakupun nan yang mga yagapangintoo kang Isa aw adaun nan silan adto sang mga pangoo ng mga imam?” ");
INSERT INTO kqew_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Awgaid si Saul, yagakadogang pa yang kaisug nan pag-osiyat aw pyangimunnaan nan na si Isa yang Almasi. Aw wa da pakatobag kanan yang mga Yahodi na yaga-uya adto sa Damaskos. ");
INSERT INTO kqew_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na, pagkadogay sinyan yanagkatipon yang mga Yahodi aw yanagka-oyon silan na apatayun si Saul. ");
INSERT INTO kqew_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Allaw-gabi byantayan nilan yang mga powertaan ng syodad kay untak patayun nilan si Saul pag-agi nan ansan. Awgaid aon yagasombong kang Saul makapantag sidto na plano nilan. ");
INSERT INTO kqew_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Agaw, sanggabi sinyan pyaga-agad si Saul ng mga inindowan nan adto sa padir na yagalibot sang syodad. Byutang nilan si Saul sang bokag aw tontona nilan yan adto sa daum sa logwa ng syodad. ");
INSERT INTO kqew_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Adon, pagdatung ni Saul adto sa Awrosalam, karim gao nan mag-upud sang mga yagapangintoo kang Isa. Awgaid yamalluk silan kanan kay wa silan atoo na yagapangintoo da yan kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ansinyan tyabangan si Saul ni Barnabas aw pyaga-agad nan yan adto sang mga sahabat. Gyogod nan kanilan yang yamaitabo kang Saul na yagapakita aw yapagbaaw kanan si Tagallang Isa adto sang daan. Aw pyagalaong oman nan silan makapantag sang kaisug ni Saul sang pag-osiyat nan makapantag kang Isa adto sa Damaskos. ");
INSERT INTO kqew_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Agaw, sikun sidto na wakto yaga-upud da si Saul kanilan. Aw maskin wain yan adto sa Awrosalam, wa yan akalluk mag-osiyat makapantag kang Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yapagbaaw aw yapaglalis yan sang mga Yahodi na Grik yang pyaglaongan. Awgaid yagadumdum silan magpatay kanan. ");
INSERT INTO kqew_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na, pagkatigam sinyan ng mga kalomonan, yatud nilan si Saul adto sa Kisariya aw pyasakay nilan yan sang bangka na yagapaduug sa Tarsos. ");
INSERT INTO kqew_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pagkatapos san kya-aonan ng kalinaw yang mga yagapangintoo kang Isa sang kariko ng Yahodiya, Jalil aw Samariya. Yagakabagsug yang pagpangintoo nilan aw aon alluk nilan sang Tohan. Yabay silan tabangan ng Nyawa ng Tohan aw yagakadaig silan. ");
INSERT INTO kqew_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, si Pitros, yakarimpud yan komadto sang kariko ng mga banwa na aon mga yagapangintoo kang Isa. Sangallaw sinyan yagabisita yan sang mga otaw na sakop ng Tohan adto sa Lida. ");
INSERT INTO kqew_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ansidto aon kinita nan na otaw na pyagangaanan kang Aniyas. Wa yan pakabangon sang kowangan nan sa suud ng wao pangka toig kay yamasadi yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ansinyan yagalaong si Pitros kanan, “Kay Aniyas, pyakadyaw da kaw ni Isa Almasi. Bangon da aw luuna yang kammo kowangan.” Ansinyan yagabangon dayon si Aniyas. ");
INSERT INTO kqew_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aw yang kariko ng mga yanag-uya sang Lida aw Saron na yakakita na madyaw da yan, yagapangintoo kang Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, adto sang syodad ng Yopa aon sambok na bobay na yagapangintoo kang Isa. Yang ngaan nan si Tabita aw kong sang pyaglaongan na Grik, Dorkas yang ngaan nan. Yani na bobay yabay mag-inang ng madyaw aw yabay nan tabangan yang mga miskinan. ");
INSERT INTO kqew_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Adon, sang wakto na adto si Pitros sang Lida, yagakasakit si Tabita aw kamatay. Syogbowan da yang lawas nan aw byutang sang kowarto adto sa taas ng baay. ");
INSERT INTO kqew_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na, yang syodad ng Yopa masaid sang longsod ng Lida. Agaw, pagdungug ng mga yagapangintoo kang Isa na si Pitros adto da sa Lida, yagasogo silan ng dowangka otaw adto kang Pitros untak mag-angyo kanan na makadto dayon sang Yopa. ");
INSERT INTO kqew_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na, pag-angyo nilan kang Pitros, yamagad yan kanilan. Pagdatung nilan sang Yopa, pyaga-agad nilan si Pitros adto sa taas ng baay sang kowarto na byutangan ng patay na lawas. Ansinyan pyagalibotan si Pitros ng mga biyoda na yanagsitiyao. Aw pyakita nilan kanan yang klasi-klasi na mga dagom na pyagatai ni Tabita nang bowi pa yan. ");
INSERT INTO kqew_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ansinyan pyalogwa ni Pitros yang kariko nilan aw lyomood yan aw pagdowaa. Pagkatapos nan magdowaa, yapag-atobang yan sang patay na lawas aw paglaong, “Kay Tabita, bangon da.” Ansinyan byoka ni Tabita yang mata nan aw sang pagkita nan kang Pitros, yaga-ingkod yan. ");
INSERT INTO kqew_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ansinyan tyakmagan ni Pitros yang arima nan aw tabangi nan pag-indug. Pagkatapos san tyawag nan yang mga yagapangintoo kipat yang mga biyoda aw pyakita nan kanilan si Tabita na bowi da. ");
INSERT INTO kqew_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na, yang gogodanun makapantag sidto na ininang ni Pitros yakarimpud sang tibok Yopa aw madaig yang yagapangintoo kang Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aw si Pitros, yadogay pa yan mag-uya adto sa Yopa sang baay ni Simon na sambok na tigbuad ng paris ng ayup. ");
INSERT INTO kqew_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, adto sang syodad ng Kisariya aon sambok na otaw na pyagangaanan kang Korniliyo. Kapitan yan ng mga sondao na taga Roma sang tyawag ng Batalyon Italyano. ");
INSERT INTO kqew_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yani na otaw bara-ibada aw aon alluk sang Tohan kipat oman yang tibok pamilya nan. Dakowa yang tabang nan sang mga Yahodi na miskinan aw yabay yan magdowaa. ");
INSERT INTO kqew_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na, sangallaw sinyan ng alas tres ng ambong, aon pyakita kanan ng Tohan. Klaro yang pagkita nan sang malaikat ng Tohan na syomuud sang kowarto nan aw yagalaong kanan, “Kay Korniliyo.” ");
INSERT INTO kqew_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pyakatanawan da nan yang malaikat na aon alluk aw laong nan, “Ono yang toyo mo kanak?” Yagalaong yang malaikat, “Wa kaw akaringawi ng Tohan kay dyungug nan yang mga pagdowaa mo aw kinita nan yang pagtabang mo sang mga miskinan. ");
INSERT INTO kqew_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Adon pagsogo ng mga otaw adto sa Yopa untak pakaniun nilan kammo si Simon na pyagangaanan oman kang Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Adto yan paga-uya sang baay ni Simon na tigbuad ng paris ng ayup na yang kanan baay masaid sang dagat.” ");
INSERT INTO kqew_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na, pagpanaw da ng malaikat, pyatawag dayon ni Korniliyo yang dowangka otaw na sogowanun nan aw yang sangka otaw na sondao na kyasarigan nan na bara-ibada oman na otaw. ");
INSERT INTO kqew_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ansinyan pyagalaong nan silan ng kariko ng yamaitabo aw syogo nan silan adto sa Yopa. ");
INSERT INTO kqew_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na, pagka-ilaw sinyan ng alas dose yang suga, adto da silan sang daan na masaid sa Yopa. Sinyan na wakto pyomanik si Pitros sang pantay na atup ng baay untak magdowaa. ");
INSERT INTO kqew_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ansinyan yamagutum si Pitros aw yamallini da gao koman. Awgaid sarta yandam pa nilan yang pagkan, aon pyakita kanan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kinita nan na yamabri yang langit aw sikun sinyan aon maynang dakowa na komot na yamatonton na inikutan sang opat na kanto. ");
INSERT INTO kqew_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Adto sa suud ng komot aon klasi-klasi na mga ayup aw mga mananap na yanagkodong sang lopa kipat oman yang mga langgam. ");
INSERT INTO kqew_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ansinyan aon dyungug nan na sowara na yagalaong kanan, “Kay Pitros, indug! Pagsobari aw kan!” ");
INSERT INTO kqew_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Awgaid tyomobag si Pitros, “Kay Tagallang, di mapakay! Kay sokad-sokad wa ako pakakan ng maskin ono na batar atawa haram.” ");
INSERT INTO kqew_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ansinyan yagalaong oman yang sowara, “Ayaw paglaong ng haram yang maskin ono na pyasotti ng Tohan.” ");
INSERT INTO kqew_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na, makatoo yan akaitabo aw pyataas da oman idtong komot adto sang langit. ");
INSERT INTO kqew_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na, sarta yagadumdum pa si Pitros daw ono yang mana ng pyakita kanan ng Tohan, dyomatung da yang mga otaw na syogo ni Korniliyo. Yakatotoo silan sang baay ni Simon aw iyan da silan sa atobangan ng powertaan. ");
INSERT INTO kqew_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yagatawag silan aw yaga-osip daw yan ba yang baay na pyaga-uyaan ni Simon Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Adon si Pitros, sarta yagadumdum pa yan sidtong pyakita kanan ng Tohan, pyagalaong yan ng Nyawa ng Tohan, laong nan, “Aon toongka otaw na yaga-anap kammo. ");
INSERT INTO kqew_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Panaog da aw ayaw pagdowa-dowa pag-agad kanilan kay ako yang yagasogo kanilan.” ");
INSERT INTO kqew_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ansinyan yamanaog si Pitros aw yagalaong yan sidtong mga otaw, “Ako si Pitros na yanap mayo. Ono yang toyo mayo kanak?” ");
INSERT INTO kqew_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yagalaong yang mga otaw, “Syogo kami adi kammo ni Kapitan Korniliyo. Madyaw yang batasan nan aw aon alluk sang Tohan aw yaddatan yan ng kariko ng mga Yahodi. Aon malaikat ng Tohan na yagalaong kanan na apakadtonon kaw sang kanan baay untak makapaningug yan sang pyaglaongan mo.” ");
INSERT INTO kqew_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ansinyan pyapanaos silan ni Pitros adto sang baay aw ansan da silan komowang ng sanggabi. Pagka-ilaw sinyan yamagad si Pitros kanilan. Aw aon oman yamagad kanilan na mga yagapangintoo na taga Yopa. ");
INSERT INTO kqew_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkasonod na allaw dyomatung da silan sang syodad ng Kisariya. Ansidto yagatagad kanilan si Korniliyo kipat yang mga kalomonan nan aw mga amigo na pyaga-imbitar nan. ");
INSERT INTO kqew_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pagdatung ni Pitros sang baay, yagasongon kanan si Korniliyo aw syomojod yan sa atobangan nan. ");
INSERT INTO kqew_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Awgaid pya-indug ni Pitros si Korniliyo aw paglaonga nan, “Pag-indug. Ayaw pagsojod kanak kay mag-onawa da kita manosiya.” ");
INSERT INTO kqew_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ansinyan sarta yanagbaaw si Pitros aw si Korniliyo, syomuud silan adto sang baay. Pagsuud nilan, kinita ni Pitros na madaig yang mga otaw na yanagkatipon ansan. ");
INSERT INTO kqew_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yagalaong yan kanilan, “Kyatigaman mayo na kami na mga Yahodi di makapag-agad-agad atawa makabisita sang dili ng Yahodi kay sopak yan sang Hokoman ng kanami agama. Awgaid pyakita kanak ng Tohan na di ko dait dumdumun na batar atawa haram yang mga otaw ng kadaigan na mga bangsa. ");
INSERT INTO kqew_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Agaw nang pyakani mayo ako, wa ako pagabaribad kamayo. Adon karim ko katigaman daw nanga pyakani mayo ako.” ");
INSERT INTO kqew_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tyomobag si Korniliyo, laong nan, “Toong allaw yang yalabay na yagadowaa ako adi sang baay sang maynini na oras na mga alas tres ng ambong. Sakadyap aon yagapakita kanak na malaikat na yamandagom ng makasilaw. ");
INSERT INTO kqew_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yagalaong yan kanak, ‘Kay Korniliyo, dyungug ng Tohan yang kammo pagdowaa aw kyadumduman nan yang kammo pagtabang sang mga miskinan. ");
INSERT INTO kqew_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Adon, pagsogo ng mga otaw adto sa Yopa untak kangayun nilan si Simon na pyagangaanan oman kang Pitros. Adto yan paga-uya sang baay ni Simon na tigbuad ng paris ng ayup na yang kanan baay masaid sang dagat.’ ");
INSERT INTO kqew_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Agaw pyakani ta kaw dayon. Aw madyaw na yakani kaw. Adon, ini da kami kariko sa atobangan ng Tohan untak maningug sang maskin ono na syogo kammo ng Tohan na ipaglaong kanami.” ");
INSERT INTO kqew_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ansinyan yagalaong si Pitros, “Adon kyatigaman da ko na bunna sagaw na way pyalabi ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Awgaid adawatun nan yang sino-sino na aon alluk kanan aw matorid yang ininang nan na maskin ono yang bangsa. ");
INSERT INTO kqew_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sa way dowa-dowa na dyungug da mayo yang Madyaw na Gogodanun na pyatigam ng Tohan kanami na mga bangsa Israil na mabarik yang madyaw na relasyon ng manosiya adto sang Tohan sabap kang Isa Almasi na yan yang Dato sang kariko. ");
INSERT INTO kqew_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aw sa way dowa-dowa na kyatigaman oman mayo yang yamaitabo sang kariko ng banwa ng mga Yahodi. Yang idto yagasogod sang probinsya ng Jalil pagkatapos ni Yahiya mag-osiyat na yang mga otaw dait magpasogbo. ");
INSERT INTO kqew_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Aw kyatigaman oman mayo na si Isa na taga Nasarit yatagan ng Tohan ng Sotti na Nyawa aw kabarakat. Agaw maskin wain yan akadto, yaga-inang yan ng kadyawan aw pyakadyaw nan yang kariko ng mga kyasaytanan kay iyan kanan yang Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kami yang yakasaksi sinyan kay yakakita kami sang kariko ng ininang nan adto sang banwa ng mga Yahodi aw adto oman sa Awrosalam. Pyatay yan ng mga Yahodi pina-agi sang paglansang kanan sang kaoy. ");
INSERT INTO kqew_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Awgaid sang ikatoong allaw sikun sang pagkamatay nan byowi oman yan ng Tohan aw pyakita kanami na bowi yan. ");
INSERT INTO kqew_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wa yan apakitaa sang kariko ng mga otaw kondi kanami gaid na pinili dadaan ng Tohan untak ma-inang ng mga saksi. Bunna sagaw na yanag-upud kami kanan koman pagkatapos nan mabowi oman. ");
INSERT INTO kqew_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Syogo nan kami pag-osiyat sang mga otaw ng makapantag kanan aw sang pagpatigam kanilan na si Isa yang pinili ng Tohan untak maghokom sang mga bowi aw yang mga patay. ");
INSERT INTO kqew_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yang kariko ng mga nabi yagasaksi oman makapantag kanan aw yagalaong silan na sino-sino yang amangintoo kanan amponon ng Tohan sang mga dosa nilan sabap kang Isa.” ");
INSERT INTO kqew_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na, sarta yagalaong pa si Pitros, yakunsad yang Nyawa ng Tohan sang kariko ng yamaningug sang pyaglaongan nan. ");
INSERT INTO kqew_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ansinyan yatingaa idtong mga yagapangintoo kang Isa na mga Yahodi na yamagad kang Pitros sikun sa Yopa kay kinita nilan na maskin yang mga dili ng Yahodi yatagan ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kay dyungug nilan na yanaglaong da silan ng yagakatuna-tuna na pyaglaongan na wa nilan akatigami aw pyoji nilan yang Tohan. Ansinyan yagalaong si Pitros, ");
INSERT INTO kqew_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yani na mga otaw yatagan da adon ng Nyawa ng Tohan mag-onawa kanami na mga Yahodi. Agaw sagaw way makapaglaong na di silan mapakay sogbowan.” ");
INSERT INTO kqew_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ansinyan yagasogo si Pitros na sogbowan silan sang ngaan ni Isa Almasi. Pagkatapos san pyagadumutan nilan si Pitros na magapabilin adto kanilan ng pilang allaw. ");
INSERT INTO kqew_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ansinyan yakadungug yang mga sahabat kipat yang kadaigan na mga yagapangintoo kang Isa adto sa Yahodiya na yang mga dili ng Yahodi yagapangintoo oman sang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na, pagbarik ni Pitros adto sa Awrosalam, aon mga Yahodi ansan na yagasaway kanan kay yagadumdum silan na yang dili ng Yahodi na yagapangintoo kang Isa dait oman magpatoli sobay sang kabatasanan ng mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Laong nilan, “Nanga yakadto kaw sang baay ng dili ng Yahodi aw yaga-upud kaw kanilan koman?” ");
INSERT INTO kqew_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ansinyan gyogod ni Pitros kanilan yang kariko ng yamaitabo sikun pa sang pagsogod. ");
INSERT INTO kqew_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Laong nan, “Sarta yagadowaa ako sang Tohan adto sa Yopa, aon pyakita nan kanak. Kinita ko na aon maynang dakowa na komot na inikutan sang opat na kanto na tyonton adi kanak sikun sang langit. ");
INSERT INTO kqew_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pagtanaw ko untak kitaun ko daw ono yang lasak, aon kinita ko na mga ayup, mga mangka-isug na ayup kipat yang mga mananap na yagakodong sang lopa aw mga langgam. ");
INSERT INTO kqew_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ansinyan aon dyungug ko na sowara na yagalaong kanak, ‘Indug, kay Pitros. Pagsobari aw kan!’ ");
INSERT INTO kqew_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Awgaid yagalaong ako, ‘Kay Tagallang, di mapakay! Kay sokad-sokad wa ako pakakan ng maskin ono na batar atawa haram.’ ");
INSERT INTO kqew_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ansinyan yagalaong oman yang sowara sikun sang langit, ‘Ayaw paglaong na haram yang maskin ono na pyasotti ng Tohan.’ ");
INSERT INTO kqew_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na, makatoo yan akaitabo aw pyataas da oman idtong komot adto sang langit. ");
INSERT INTO kqew_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Na, sidto na wakto aon dyomatung sang baay na pyaga-uyaan ko na toongka otaw sikun sa Kisariya. Syogo silan untak kangayun nilan ako. ");
INSERT INTO kqew_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ansinyan pyagalaong ako ng Nyawa ng Tohan na di ako magdowa-dowa pag-agad kanilan. Agaw yamagad ako kanilan kaupud sidtong unum na ka otaw na kalomonan ta na taga Yopa aw kyomadto kami sang baay ni Korniliyo. ");
INSERT INTO kqew_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pagdatung nami adto, gyogodan kami ni Korniliyo na aon yagapakita kanan na malaikat adto sa suud ng kanan baay. Aw yagalaong kono yang malaikat kanan, ‘Pagsogo ng mga otaw adto sa Yopa untak pakaniun nilan si Simon na pyagangaanan oman kang Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kay magapatigam yan kammo ng pyaglaongan na makalowas kammo kipat yang pamilya mo.’ ");
INSERT INTO kqew_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Adon, pagsogod ko mag-osiyat kanilan makapantag kang Isa, yakunsad kanilan yang Nyawa ng Tohan mag-onawa ng yamaitabo kanatun sidtong ona. ");
INSERT INTO kqew_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ansinyan kyadumduman ko yang pyaglaongan ni Tagallang Isa singaon nang yagalaong yan, ‘Tobig yang pyagasogbo kamayo ni Yahiya, awgaid yang pagasogbo ko kamayo yang Nyawa ng Tohan.’ ");
INSERT INTO kqew_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na adon,” laong ni Pitros, “klaro da na yang yatag ng Tohan sang mga dili ng Yahodi mag-onawa ng yatag nan kanatun na mga Yahodi sidtong wakto na yagapangintoo kita kang Isa Almasi na kanatun Tagallang. Na, sino ba ako na somopak sang Tohan?” ");
INSERT INTO kqew_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na, pagdungug nilan sinyan, yagapakatingun silan aw wa da silan pagasaway kang Pitros. Ansinyan pyoji nilan yang Tohan aw laong nilan, “Na, kong maynan, maskin yang mga dili ng Yahodi tyogotan da ng Tohan na makapagtawbat untak silan ka-aonan ng kinabowi na way kataposan.” ");
INSERT INTO kqew_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na, sikun sidtong wakto ng pagpatay kang Istiban yanagkanat-kanat da yang mga yagapangintoo kang Isa sabap sang pagpasikot kanilan. Aon yakadatung sang banwa ng Pinisiya, sang poo ng Kipros aw adto oman sang syodad ng Antiyok. Ansidto na mga banwa yagapayapat silan ng makapantag kang Isa, awgaid adto gaid sang mga Yahodi. ");
INSERT INTO kqew_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Awgaid aon oman kadaigan na mga yagapangintoo na taga Kipros aw taga Kirini na yakadto sa Antiyok aw yagapayapat silan ng Madyaw na Gogodanun makapantag kang Tagallang Isa adto oman sang mga dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yagadan silan ng kabarakat ng Tohan aw madaig yang yagapangintoo aw yagapangagad kang Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na, pagdungug ng jamaa adto sa Awrosalam ng makapantag sinyan, syogo nilan si Barnabas adto sa Antiyok. ");
INSERT INTO kqew_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pagdatung nan adto, yamasowat yang ginawa nan kay kinita nan na dakowa yang tabang ng Tohan sang mga taga Antiyok. Agaw pyagalaong silan ni Barnabas na padayonon nilan yang pagpangintoo kang Tagallang Isa ng iklas. ");
INSERT INTO kqew_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Yani si Barnabas madyaw na otaw. Pyagabuutan yan ng Nyawa ng Tohan aw mabagsug yang kanan pagpangintoo. Agaw madaig yang mga taga Antiyok na yagapangintoo sang Tagallang. ");
INSERT INTO kqew_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ansinyan kyomadto si Barnabas sang syodad ng Tarsos untak manganap kang Saul. ");
INSERT INTO kqew_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pagkita nan kang Saul, pyaga-agad nan yan adto sa Antiyok. Aw yagapabilin silan adto sa suud ng sangka toig upud sang mga yagapangintoo aw madaig yang mga otaw na pyaga-indowan nilan makapantag kang Isa. Yang mga yagapangintoo kang Isa adto sa Antiyok, silan yang ona na tawagun ng mga Almasihin. ");
INSERT INTO kqew_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na, sidto na wakto nang adto pa sang Antiyok si Barnabas aw si Saul, aon mga magpapatigamay ng pyatigam kanilan ng Tohan na dyomatung ansan sikun sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yang sambok kanilan na pyagangaanan kang Agabos yamindug aw sabap sang pyatigam kanan ng Nyawa ng Tohan yagatagna yan na aon madatung na gutum sang kariko ng banwa. Na, yani na pyaglaongan nan yatoman sang wakto na si Klaudiyo yang soltan sang Roma. ");
INSERT INTO kqew_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ansinyan yanagka-oyon yang mga yagapangintoo adto sa Antiyok na kotob ng amagaga ng matag-isa kanilan ipadaa nilan yang maskin ono na ikatabang nilan adto sang mga kalomonan nilan na Almasihin na yanag-uya sa Yahodiya. ");
INSERT INTO kqew_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na, ininang da nilan yan aw pyadaa nilan yang tabang nilan kang Barnabas aw si Saul kay untak i-atag nilan sang mga pangoo ng jamaa adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na, sidto oman na wakto yagasogod si Soltan Hirod magpasikot sang pilangka otaw na yagapangintoo kang Isa ");
INSERT INTO kqew_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","aw pya-otodan nan ng oo si Yakob na lomon ni Yahiya. ");
INSERT INTO kqew_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na, pagkatigam nan na yamasowat yang mga Yahodi sabap sidto na ininang nan, pyadakup oman nan si Pitros. Yamaitabo yani sang wakto ng Pakaradyaan ng Pan na way Labadora. ");
INSERT INTO kqew_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagdakup kang Pitros, lyasak yan sang pirisowan aw pyabantayan yan ng opat ka gropo ng mga sondao na yang matag-isa na gropo tag-opat ka sondao. Kay karim ni Hirod na hokoman si Pitros sa atobangan ng kariko ng mga otaw pagkatapos ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqew_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Agaw pyabantayan da gaid si Pitros sang pirisowan. Awgaid yang jamaa yagapadayon magdowaa para kang Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na, sidto na gabi sang wa pa yang paghokom kang Pitros, yatoog yan adto sang pirisowan sa tunga ng dowangka sondao. Gyapos yan ng dowa na kadina aw aon oman mga gowardya na yagabantay adto sang powertaan. ");
INSERT INTO kqew_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sakadyap aon malaikat ng Tohan na yamindug adto sang pirisowan aw kya-allagan yang suud ng pirisowan. Dyampaw ng malaikat yang abaga ni Pitros untak pokawon nan aw laong nan, “Pagdari! Bangon da!” Aw sinyan dayon yamangkatangtang yang dowa na kadina na iyan sang arima ni Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yagalaong kanan yang malaikat, “Pagbakos aw pagsandalyas.” Na, ininang da yan ni Pitros. Aw yagalaong oman kanan yang malaikat, “Sooga yang sapaw mo na dagom aw agad kanak.” ");
INSERT INTO kqew_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ansinyan yamagad si Pitros sang malaikat sang paglogwa sikun sang pirisowan, awgaid yagadumdum yan na yagatagaynup gaid yan. Wa yan akatigam na bunna yang pagtabang kanan ng malaikat. ");
INSERT INTO kqew_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na, yalabayan da nilan yang pirmiro aw yang ikadowa na gowardya sampay na dyomatung silan sang potaw na powertaan na ya-atobang sang syodad. Ansinyan yamabri gaid yan aw lyomogwa silan. Pagpanaw da nilan sang daan, sakadyap yawaa yang malaikat. ");
INSERT INTO kqew_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ansinyan yakasabot si Pitros na bunna kadi yang yamaitabo kanan aw laong nan, “Adon kyatigaman da ko na syogo ng Tohan yang kanan malaikat untak lowasun nan ako sikun kang Soltan Hirod kipat sang mga Yahodi na apatayun gao nilan ako.” ");
INSERT INTO kqew_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nang yakasabot da si Pitros sang yamaitabo kanan, kyomadto yan sang baay ni Mariyam na ina ni Yahiya na pyagangaanan oman kang Markos. Madaig yang mga otaw na yanagkatipon ansan untak magdowaa. ");
INSERT INTO kqew_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na, pagdatung nan adto, yagatoktok yan sang powertaan sa logwa ng baay aw lyomogwa yang sogowanun na bobay na pyagangaanan kang Roda untak tanawon nan daw sino yang yagatoktok. ");
INSERT INTO kqew_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pagtobag ni Pitros, yakilaa nan yang tingug nan aw sabap sang bali na kasowat nan wa da nan abrii yang powertaan, awgaid dyomaagan yan adto sa suud ng baay untak paglaongon nan yang kadaigan na si Pitros adto sa logwa. ");
INSERT INTO kqew_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Awgaid yagalaong silan, “Yamabowang da kaw kowaw.” Awgaid pyagabarik-barik ni Roda yang pyaglaongan nan na bunna na si Pitros adto sa logwa. Ansinyan yagalaong silan, “Basin malaikat nan ingidto.” ");
INSERT INTO kqew_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Awgaid adto sa logwa, yabay pa magtoktok si Pitros. Na, sang orian yabrian da nilan yang powertaan aw pagkita nilan kang Pitros, yatingaa sagaw silan. ");
INSERT INTO kqew_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Awgaid si Pitros, siningyasan nan silan untak magpakatingun. Ansinyan gyogod nan kanilan daw monono yang pagpalogwa kanan ng Tagallang sikun sang pirisowan. Aw yagalaong pa yan kanilan, “Paglaonga mayo si Yakob aw yang kadaigan pa na mga kalomonan ta ng makapantag sini.” Pagkatapos san pyomanaw si Pitros aw kyomadto sang tuna na banwa. ");
INSERT INTO kqew_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na, pagka-ilaw sinyan yamangkasamok yang mga sondao na yagabantay adto sang pirisowan kay wa silan akatigam daw ono yang yamaitabo kang Pitros. ");
INSERT INTO kqew_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yagasogo dayon si Hirod na anapun si Pitros, awgaid wa nilan akitaa. Ansinyan pyaga-imbistigar ni Hirod yang mga gowardya aw pyatay nan silan. Pagkatapos san pyomanaw si Hirod sikun sang probinsya ng Yahodiya aw kyomadto sa Kisariya kay adto da yan paga-uya ng pilang allaw. ");
INSERT INTO kqew_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na, sidto na wakto bali na kadaman ni Hirod sang mga taga Tiros aw Sidon. Agaw sarta adto pa si Hirod sa Kisariya, yanagka-oyon yang mga taga Tiros aw Sidon na magasogo silan ng mga otaw adto kanan untak mapag-osay ng relasyon nilan. Karim nilan na magakadyaw yang ginawa ni Hirod adto kanilan kay yang pagkan nilan yagasikun sang kasakopan ni Soltan Hirod. Agaw pagdatung nilan adto, yapag-amigo ona silan kang Blastos na sinarigan ni Hirod sang palasyo nan kay untak katabangan nan silan sang kanilan toyo. ");
INSERT INTO kqew_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Adon, pagdatung ng allaw na mapagkita si Hirod kanilan, yamandagom yan ng dagom ng soltan aw yaga-ingkod sang ingkodanan ng maghohokom aw paglaong-laong sang mga otaw. ");
INSERT INTO kqew_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pagkatapos nan maglaong-laong, byantog yan ng mga otaw aw yanagpiyagit silan aw laong nilan, “Dili ng kanang otaw yani na pyaglaongan kondi kanang Tohan!” ");
INSERT INTO kqew_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na, sinyan dayon siniksa ng malaikat ng Tohan si Hirod sabap ng dyawat nan yang pagbantog kanan ng mga otaw aw wa nan atagi ng kabantog yang Tohan. Ansinyan kyan yang lawas ni Hirod ng mga od aw kamatay yan. ");
INSERT INTO kqew_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Awgaid yabay pa makarimpud yang pyaglaongan ng Tohan sang kariko ng Awrosalam aw yagakadaig yang mga yagapangintoo kang Isa Almasi. ");
INSERT INTO kqew_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na, si Barnabas aw si Saul, yatapos da nilan yang kanilan gawbuk adto sa Awrosalam aw byomarik da silan adto sa Antiyok. Pyaga-agad nilan si Yahiya na pyagangaanan oman kang Markos. ");
INSERT INTO kqew_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Adon, adto sang jamaa sang Antiyok aon mga otaw na magpapatigamay ng pyatigam kanilan ng Tohan aw mga magiindoway ng pyaglaongan ng Tohan. Yani silan si Barnabas, si Simiyon na tyawag oman ni Negro, si Lokiyos na taga Kirini, si Manain na tyomorin sang baay ni Gobirnador Hirod, aw si Saul. ");
INSERT INTO kqew_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na, sangallaw sinyan nang yagasambayang aw yagapowasa silan, yagalaong kanilan yang Nyawa ng Tohan, “Laina mayo si Barnabas aw si Saul untak inangun nilan yang gawbuk na pyagakahanda ko kanilan.” ");
INSERT INTO kqew_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Agaw, pagkatapos nilan magpowasa aw magdowaa, dyapunan nilan si Barnabas aw si Saul ng arima nilan aw pyapanaw nilan. ");
INSERT INTO kqew_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Adon, syogo da ng Nyawa ng Tohan yani na dowangka otaw na si Barnabas aw si Saul aw kyomadto silan sang syodad ng Silokiya. Ansidto syomakay silan sang dakowa na bangka paduug sang poo ng Kipros. ");
INSERT INTO kqew_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pagdatung nilan sang longsod ng Salamis, yaga-osiyat silan ng pyaglaongan ng Tohan adto sang mga pagsasambayangan ng mga Yahodi. Kaupud oman nilan si Yahiya Markos untak tomabang sang kanilan gawbuk. ");
INSERT INTO kqew_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ansinyan yamarimpud nilan panawon yang tibok poo sampay na dyomatung silan sang longsod ng Papos. Ansidto aon kinita nilan na sambok na Yahodi na pyagangaanan kang Bar-Isa. Sambok yan na madyikiro aw yagalaong yan na nabi kono yan. ");
INSERT INTO kqew_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo yan ng gobirnador sidto na poo na si Sirgiyos Paulus na matigamay na otaw. Sangallaw sinyan pyatawag ng gobirnador si Barnabas aw si Saul kay mallini yan maningug sang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Awgaid idtong madyikiro na pyagangaanan oman kang Ilimas na ngaan nan sang pyaglaongan na Grik, yapaglalis kang Barnabas kipat kang Saul. Pyaningkamotan nan magdistorbo sang gobirnador untak di mangintoo sang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na adon, si Saul na pyagangaanan oman kang Paulus, pyagabuutan da yan ng Nyawa ng Tohan. Pyakatanawan nan idtong madyikiro ");
INSERT INTO kqew_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aw laong nan, “Anak kaw ng saytan! Kay yasopak kaw sang maskin ono na madyaw. Way lain na ininang mo yatabiya yang magpangilad aw magpanlimbong. Nanga yabay kaw maglaong na bakak kono yang bunna na indowan na yagasikun sang Tohan? ");
INSERT INTO kqew_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Awgaid adon, asiksaun da kaw ng Tohan. Amabota da kaw aw sa suud ng pilang allaw maskin yang kasiga ng suga di da mo akitaun.” Na, sinyan dayon yagakaduggum yang pananaw ni Ilimas na maynang tyabonan yan ng gabon. Yamangapkap da gaid yan aw yagapanganap ng otaw na maka-agak kanan. ");
INSERT INTO kqew_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pagkita ng gobirnador sinyan na pangitabo, yagapangintoo yan kay yatingaa yan sang pyaga-indo makapantag kang Tagallang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ansinyan syomakay da oman si Paulus kipat yang mga kaupudanan nan sang dakowa na bangka aw lyomayag silan sikun sa Papos paduug sa Pirga na sakop ng Pampiliya. Pagdatung nilan adto, pyanawan silan ni Yahiya Markos kay yamori yan adto sa Awrosalam. ");
INSERT INTO kqew_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Awgaid silan ni Paulus, sikun sa Pirga pyomanaos silan adto sang longsod ng Antiyok sang probinsya ng Pisidiya. Pagdatung ng Allaw ng Pagpatana, kyomadto silan sang pagsasambayangan ng mga Yahodi aw pag-ingkod ansan. ");
INSERT INTO kqew_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pagkatapos ng pagbatya sa Kitab Tawrat aw yang syorat ng mga nabi, yagatogon yang mga pangoo ng pagsasambayangan adto kanilan Paulus, laong nilan, “Mga lomon, kong aon ipaglaong mayo sang mga otaw na makapabagsug sang pangatayan nilan, mapakay da kamo maglaong.” ");
INSERT INTO kqew_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na, yamindug si Paulus aw siningyasan nan yang mga otaw untak magpakatingun aw laong nan, “Mga kalomonan ko na bangsa Israil aw kamo na dili ng bangsa Israil awgaid aon alluk sang Tohan, paningugi mayo yani na ipaglaong ko kamayo. ");
INSERT INTO kqew_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yang Tohan na pyagasambayangan ng mga bangsa Israil, pinili nan yang kanatun mga kaompowan untak ma-inang silan ng dakowa na bangsa. Aw sarta yaga-uya silan adto sang banwa ng Misir na dili ng kanilan banwa, yagakadaig silan. Ansinyan tyabangan silan ng Tohan aw sabap sang kanan kabarakat yakapanaw da silan sikun sidto na banwa. ");
INSERT INTO kqew_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na, sa suud ng 40 ka toig sarta adto silan sang diserto pyagasabaran ng Tohan yang pagsopak nilan kanan. ");
INSERT INTO kqew_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aw pagdatung nilan sang banwa ng Kanaan, pyadaog silan ng Tohan sang pitongka bangsa aw yatag nan kanilan yang banwa ng Kanaan. ");
INSERT INTO kqew_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ya-inang yang kariko sinyan sa suud ng 450 ka toig. “Pagkatapos san, yatagan silan ng Tohan ng mga maghohokom na yagadato kanilan sampay sang wakto ni Nabi Samuel. ");
INSERT INTO kqew_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sang kadogayan sinyan yagapangayo yang mga bangsa Israil ng soltan na magadato kanilan. Agaw pinili ng Tohan si Saul na anak ni Kis na topo ni Binyamin. Aw yagasoltan yan sa bangsa Israil sa suud ng 40 ka toig. ");
INSERT INTO kqew_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ansinyan kyamang ng Tohan si Saul sikun sang pagkasoltan aw pinili nan si Daud na magasoltan kanilan. Aw yagalaong yang Tohan makapantag kanan, ‘Si Daud na anak ni Isai yang otaw na kyallinian ko kay inangun nan yang kariko ng pagasogo ko kanan.’ ");
INSERT INTO kqew_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Adon,” laong ni Paulus, “sikun sang mga katopowan ni Daud yatagan kita ng Tohan ng manlolowas na pyasad nan sa bangsa Israil, aw yan si Isa. ");
INSERT INTO kqew_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sang wa pa si Isa pagasogod mag-indo, yaga-osiyat da si Yahiya sang mga bangsa Israil na dait silan magtawbat sang mga dosa nilan aw magpasogbo. ");
INSERT INTO kqew_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aw nang masaid da matapos yang pya-inang ng Tohan kang Yahiya, yagalaong yan sang mga otaw, ‘Basin yagadumdum kamo na ako yang manlolowas na pyagatagadan mayo. Awgaid dili ko ingidto. Masonod pa yan kanak domatung, aw maskin yang pag-obad ng sandalyas nan di dait kanak.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yagapadayon maglaong si Paulus, “Mga kalomonan ko na mga topo ni Nabi Ibrahim, aw kamo na mga dili ng Yahodi na aon alluk sang Tohan, pagalaongon ta kamo na kita-kamo yang yatagan ng Tohan sini na gogodanun makapantag sang kalowasan. ");
INSERT INTO kqew_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Awgaid yang mga Yahodi adto sa Awrosalam aw yang mga pangoo nilan, wa silan akatigam na si Isa yang pyasad na manlolowas. Aw wa oman silan pakasabot sang pyagalaong ng mga nabi sang Kitab na pyagabatya nilan matag Allaw ng Pagpatana adto sang pagsasambayangan nilan. Awgaid silan da yang yatoman ng pyagatagna ng mga nabi sabap sang kanilan paghokom na dait patayun si Isa. ");
INSERT INTO kqew_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maskin way kinita nilan na dosa na dait nan ikamatay, yagapangayo silan adto kang Pilato na apatayun si Isa. ");
INSERT INTO kqew_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na, pagkatapos nilan inangun yang kariko ng yakasorat sang Kitab makapantag kang Isa, kyamang nilan yang kanan lawas sikun sang kaoy na pyagalansangan kanan aw byutang nilan sang kobor. ");
INSERT INTO kqew_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Awgaid byowi oman yan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aw sa suud ng madaig na mga allaw yagapakita yan sang mga otaw na yamagad kanan singaon sikun sa Jalil paduug sa Awrosalam. Na, silan adon yang mga saksi na yagalaong ng kabunnaan makapantag kang Isa adto sang mga bangsa Israil. ");
INSERT INTO kqew_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Na, adi da kami adon untak maglaong kamayo ng madyaw na gogodanun na yang pyasad ng Tohan adto sang kanatun kaompowan ");
INSERT INTO kqew_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","yatoman da adon kanatun na mga topo nilan sabap ng byowi oman ng Tohan si Isa. Kay yakasorat sang ikadowa na sura sa Kitab Jabor na yagalaong yang Tohan, laong nan, “ ‘Ikaw yang Anak ko. Adon na allaw ipatigam ko na ako yang kammo Ama.’ ");
INSERT INTO kqew_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aw yang pyagalaong ng Tohan na abowiun oman nan si Isa untak di madonot yang lawas nan yakasorat oman sang Kitab, kay laong nan, “ ‘Sa way dowa-dowa i-atag ko kammo yang kadyawan na pyasad ko kang Daud.’ ");
INSERT INTO kqew_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Aw aon oman yakasorat sa Kitab Jabor na yagalaong, “ ‘Di mo atogotan na amadonot yang lawas ko kay ako yang sotti na sogowanun mo.’ ");
INSERT INTO kqew_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Na, maskin si Soltan Daud yang yagalaong sinyan, dili ng ginawa nan yang karim nan ipasabot. Kay pyangagadan ni Soltan Daud yang pyagakahanda kanan ng Tohan sang panahon nang bowi pa yan. Pagkatapos san yamatay da yan aw lyubung yan sang masaid sang mga kaompowan nan. Aw yadonot da yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Awgaid si Isa na byowi oman ng Tohan sikun sang kamatay, wa akadonot yang lawas nan. ");
INSERT INTO kqew_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Idto sagaw, mga kalomonan ko,” laong ni Paulus, “dait mayo katigaman na sabap kang Isa pyapayapat da adon ansan kamayo na aon kaamponan ng mga dosa mayo. Yang pagpangagad mayo sang Hokoman ni Nabi Mosa di makakamang ng mga dosa mayo. Awgaid sino-sino yang amangintoo kang Isa, amponon yan aw atarimaun yan ng Tohan na matorid. ");
INSERT INTO kqew_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Agaw, pagbantay kamo na di amaitabo kamayo yang pyagalaong ng mga nabi sang Kitab na yagalaong, ");
INSERT INTO kqew_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Pagbantay kamo na yagasaway sang mga otaw! Amangkatingaa kamo sang paga-inangun ko, awgaid amangkamatay kamo! Kay sang kamayo panahon aon inangun ko na di mayo pangintowan maskin aon pay magapatigam kamayo.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Adon, paglogwa ni Paulus aw si Barnabas sikun sang pagsasambayangan, yangyo silan ng mga otaw na kong mapakay magabarik silan sang sonod na Allaw ng Pagpatana untak mag-indo oman ng makapantag sini na mga butang. ");
INSERT INTO kqew_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na, pag-ori da ng mga otaw, madaig yang yamagad kang Paulus aw si Barnabas, mga Yahodi kipat yang mga dili ng Yahodi na yagapasakop sang agama Yahodi. Aw pyagalaong silan ni Paulus aw si Barnabas na magapadayon silan magsarig sang tabang kanilan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Adon, pagkasonod na Allaw ng Pagpatana, alos yang kariko ng mga otaw sidto na banwa yanagkatipon sang pagsasambayangan nilan untak maningug sang pyaglaongan ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na, pagkita ng mga Yahodi sang kadaig ng mga otaw na yanagkatipon ansan, yamasina silan. Agaw syopak nilan yang pyaglaongan ni Paulus aw ininsolto pa nilan yan. ");
INSERT INTO kqew_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Awgaid kyadogangan pa yang kaisug ni Paulus aw si Barnabas aw yagalaong silan, “Dait gaid na kamo na mga Yahodi yang ona na osiyatan ng pyaglaongan ng Tohan. Awgaid sabap ng tyaripundaan mayo yang pyaglaongan nan maynang yagalaong kamo na di kamo dait atagan ng kinabowi na way kataposan. Agaw apasagdan da kamo nami aw makadto da kami pag-osiyat sang mga dili ng Yahodi. ");
INSERT INTO kqew_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kay yani yang sogo kanami ng Tohan sang Kitab, laong nan, “ ‘Ininang ta kaw ng allag para sang mga dili ng Yahodi kay untak sabap kammo amalowas yang kariko ng manosiya adi sa babawan ng donya.’ ” ");
INSERT INTO kqew_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na, pagdungug sinyan ng mga dili ng Yahodi, yamasowat silan aw byantog nilan yang pyaglaongan ng Tohan. Aw yang kariko ng mga otaw na pinili ng Tohan na atagan silan ng kinabowi na way kataposan, yagapangintoo. ");
INSERT INTO kqew_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ansinyan yapayapat yang pyaglaongan ng Tohan sang kariko sinyan na banwa. ");
INSERT INTO kqew_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Awgaid yani yang ininang ng mga Yahodi sang Antiyok na pyagalaong nilan yang mga pangoo sidto na syodad kipat yang mga bobay na bantoganun na aon alluk sang Tohan maskin dili silan ng Yahodi, na somopak silan kang Paulus. Agaw pyasikotan nilan si Paulus aw si Barnabas aw pyapanaw nilan sikun sang banwa nilan. ");
INSERT INTO kqew_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na, pagpanaw nilan Paulus, tyakdag nilan yang abog sang siki nilan silbi tanda na waa day labot nilan sang mga otaw sidto na banwa. Pagkatapos san kyomadto silan sang syodad ng Ikoniyom. ");
INSERT INTO kqew_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Awgaid yang mga yagapangintoo kang Isa adto sa Antiyok, yamasowat silan aw pyagabuutan silan ng Nyawa ng Tohan. ");
INSERT INTO kqew_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pagdatung ni Paulus aw si Barnabas sang Ikoniyom, kyomadto silan sang pagsasambayangan ng mga Yahodi mag-onawa ng kya-anadan nilan. Aw sabap sang kadyaw ng pag-osiyat nilan madaig yang mga Yahodi kipat yang mga dili ng Yahodi na yagapangintoo kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Awgaid yang kadaigan na mga Yahodi na wa apangintoo sang pyaga-indo nilan ni Paulus, pyagalaong nilan yang mga dili ng Yahodi na makontra sidtong yagapangintoo kang Isa. ");
INSERT INTO kqew_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na, yadogay si Paulus aw si Barnabas adto sa Ikoniyom. Wa silan akalluk mag-osiyat makapantag kang Tagallang Isa. Aw pyakita ng Tagallang na bunna yang pyaga-osiyat nilan makapantag sang kadyaw nan sang mga otaw kay yatagan nan silan ng kabarakat pag-inang ng mga tanda aw katingaan. ");
INSERT INTO kqew_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na, yanagkabain-bain da yang dumduman ng mga otaw sidto na syodad. Yang kadaigan yadapig sang mga Yahodi na wa apangintoo, aw yang kadaigan oman yadapig sang mga sahabat. ");
INSERT INTO kqew_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ansinyan yanagka-oyon yang mga Yahodi aw yang mga dili ng Yahodi upud sang mga pangoo nilan na apasakitan nilan silan ni Paulus aw abonoon nilan ng bato sampay na akamatay da nilan. ");
INSERT INTO kqew_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Awgaid pagkatigam sinyan ni Paulus aw si Barnabas, yalayas silan adto sang probinsya ng Likaoniya, sang mga syodad ng Listara aw Dirbi kipat oman sang makilibot na mga banwa. ");
INSERT INTO kqew_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aw sidto na mga banwa yagapadayon silan mag-osiyat ng Madyaw na Gogodanun makapantag kang Isa Almasi. ");
INSERT INTO kqew_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na, adto sa Listara aon sangka otaw na wa pakapanaw sokad ng pagkaotaw nan kay yamasadi yang siki nan. ");
INSERT INTO kqew_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Sarta yaga-ingkod yan ansan, yamaningug yan sang pyaglaongan ni Paulus. Ansinyan pyagatanawan yan ni Paulus aw kinita nan na aon pagpangintoo ninyan na otaw na si Isa makapagkadyaw kanan. ");
INSERT INTO kqew_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Agaw yagalaong kanan si Paulus ng matanog, “Pag-indug!” Na, sinyan dayon yamindug yang otaw aw yakapanaw da yan. ");
INSERT INTO kqew_vpl VALUES ("A