﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqe_vpl;
CREATE TABLE kqe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqe_vpl WRITE;
INSERT INTO kqe_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yani yang tarsila ni Isa Almasi. Si Isa topo ni Daud, aw si Daud topo ni Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Ibrahim yang ama ni Isahak. Si Isahak yang ama ni Yakob. Si Yakob yang ama ni Yodah. ");
INSERT INTO kqe_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yang mga anak ni Yodah si Paris aw si Sirah. Yang ina nilan si Tamar. Si Piris yang ama ni Isrom. Si Isrom yang ama ni Aram. ");
INSERT INTO kqe_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram yang ama ni Aminadab. Si Aminadab yang ama ni Nason. Si Nason yang ama ni Salmon. ");
INSERT INTO kqe_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon yang ama ni Booz. Yang ina ni Booz si Rahab. Si Booz yang ama ni Obid. Yang ina ni Obid si Rot. Si Obid yang ama ni Isai. ");
INSERT INTO kqe_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aw si Isai yang ama ni Daud. Si Daud yang ama ni Solayman. Yang ina ni Solayman yang dati na asawa ni Oriyas. ");
INSERT INTO kqe_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solayman yang ama ni Robowam. Si Robowam yang ama ni Abiyas. Si Abiyas yang ama ni Asa. ");
INSERT INTO kqe_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa yang ama ni Yosapat. Si Yosapat yang ama ni Yoram. Si Yoram yang ama ni Osiyas. ");
INSERT INTO kqe_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Osiyas yang ama ni Yotam. Si Yotam yang ama ni Akas. Si Akas yang ama ni Isikiyas. ");
INSERT INTO kqe_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Isikiyas yang ama ni Manasi. Si Manasi yang ama ni Amon. Si Amon yang ama ni Yosiyas. ");
INSERT INTO kqe_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Yosiyas yang ama ni Ikoniyas aw yang mga lomon nan. Yamabowi silan sidtong wakto na yamadaa yang mga bangsa Yahodi adto sang banwa ng Babilon. ");
INSERT INTO kqe_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sikun sidtong pagdaa kanilan adto sang Babilon yani yang mga kaompowan na yamakalista: si Ikoniyas yang ama ni Salatiyal. Si Salatiyal yang ama ni Sirobabil. ");
INSERT INTO kqe_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sirobabil yang ama ni Abiyod. Si Abiyod yang ama ni Iliyakim. Si Iliyakim yang ama ni Asor. ");
INSERT INTO kqe_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor yang ama ni Sadok. Si Sadok yang ama ni Akim. Si Akim yang ama ni Iliyod. ");
INSERT INTO kqe_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Iliyod yang ama ni Iliyasar. Si Iliyasar yang ama ni Matan. Si Matan yang ama ni Yakob. ");
INSERT INTO kqe_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Yakob yang ama ni Yosop na bana ni Mariyam. Si Mariyam yang ina ni Isa na tyatawag ng Almasi. ");
INSERT INTO kqe_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Idto sagaw, yang kadaig ng mga katopowan sikun kang Nabi Ibrahim sampay da kang Soltan Daud sampoo aw opat. Aw sampoo aw opat oman yang kadaig ng mga katopowan sikun kang Soltan Daud taman sang wakto ng pagdaa kanilan adto sang Babilon. Aw sampoo aw opat oman yang kadaig ng mga katopowan sikun sidtong wakto na adto da silan sang Babilon taman sang pagkaotaw ni Isa Almasi. ");
INSERT INTO kqe_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Adon, maynini yang kyakatamanan ng pagkaotaw ni Isa Almasi. Si Mariyam na ina nan, tyatawas ni Yosop. Awgaid sang wa pa silan akawina, yamabdus da si Mariyam sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Adon, si Yosop madyaw na otaw sang pagtanaw ng Tohan. Agaw, pagkatigam nan na mabdus da si Mariyam, di nan karim na akasipugan yan sang atobangan ng mga otaw. Agaw yagadumdum yan na buagan nan si Mariyam ng sikrito. ");
INSERT INTO kqe_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ansinyan sarta yagadumdum pa si Yosop daw ono yang inangun nan, yagatagaynup yan. Aw sang tagaynup nan aon yagapakita kanan na sambok na malaikat sikun sang Tohan aw laong nan, “Kay Yosop na topo ni Soltan Daud, ayaw magkalluk mangasawa kang Mariyam kay yang pagkabdus nan sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amanganak yan ng usug aw pagangaanan mo yan ni Isa kay yan yang magalowas sang mga otaw na sakop nan sikun sang mga dosa nilan.” ");
INSERT INTO kqe_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, yamainang yang kariko sini antak matoman yang pyaglaongan ng Tohan pinaagi kang Nabi Isayas na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Amabdus yang sambok na daaga aw amanganak yan ng usug. Pagangaanan yan ni Imanuel,” na yang mana san “Idi kanatun yang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na, pagmata ni Yosop, pyapangagadan nan yang pyagasogo kanan ng malaikat aw pyapangasawa nan si Mariyam. ");
INSERT INTO kqe_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Awgaid wa nan ipidi si Mariyam sarta wa pa yan apanganak. Sang yamanganak da si Mariyam, pyagangaanan nan yang isu ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ansinyan yamaotaw si Isa sang longsod ng Baytlaham sang probinsya ng Yahodiya sang panahon ng pagkasoltan ni Hirod. Wa akadogay disinyan aon dyomatung sang Awrosalam na mga otaw sikun sang silatan. Mga mangkatigam silan na yagapangadi makapantag sang mga bitoon. ");
INSERT INTO kqe_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagdatung nilan sang Awrosalam yagaosip silan sang mga otaw, laong nilan, “Wain yangaong isu na baya pa yamaotaw na magasoltan sang mga Yahodi? Kay adto sang silatan kikita nami yang bitoon na yan yang tanda ng pagkaotaw nan. Idto sagaw yakani kami antak magsojod kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagdungug sinyan ni Soltan Hirod, yamarido yan kipat sang kariko ng mga otaw adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agaw, yang ininang ni Soltan Hirod, pyapatawag nan yang kariko ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw yosip nan silan, laong nan, “Wain kono amaotaw yang Almasi?” ");
INSERT INTO kqe_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tyomobag silan, “Adto sang Baytlaham na sakop ng Yahodiya kay yani yang syosorat ng nabi sangaon sang Kitab, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ikaw, kay Baytlaham na adto sang Yahodiya, amabantog kaw sang kariko ng mga longsod sang Yahodiya. Kay ansan kanmo magasikun yang pangoo na magaatiman sang bangsa Israil na silan yang mga otaw na kanak sakop.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na, pagdungug sinyan ni Soltan Hirod, pyapatawag nan idtong mga mangkatigam na taga silatan aw yosip nan nang silan da gaid daw akano nilan ikitaa idtong bitoon. ");
INSERT INTO kqe_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkatigam da nan, pyapakadto nan silan sang Baytlaham aw laong nan, “Panaw da kamo aw anapa mayo ng madyaw yang isu. Kong kitaun da mayo, pakatigama mayo ako antak makakadto oman ako aw makasojod ako kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Na, pagkatapos maglaong sinyan ng soltan, pyomanaw da idtong mga mangkatigam. Sarta yagapanaw silan, kikita oman nilan yang bitoon na yamakita da nilan adto sang silatan. Pagkita sinyan, bali na kasowat nilan. Ansinyan yamaona kanilan idtong bitoon sampay na yomondang yan sa babaw ng baay na kyakabutangan ng isu. ");
INSERT INTO kqe_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagsuud nilan sidto na baay, kikita nilan yang isu aw yang ina nan na si Mariyam. Ansinyan syomojod silan aw byabantog nilan yang isu. Pagkatapos yabrian nilan yang mga lasakanan nilan aw yatag nilan adto sang isu yang daa nilan na bowawan, toob aw paballo na tyatawag ng mira. ");
INSERT INTO kqe_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, pagori nilan adto kanilan, yamagi silan sang tuna na daan kay pyagalaong silan ng Tohan sang tagaynup na di da silan magbarik adto kang Soltan Hirod. ");
INSERT INTO kqe_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ansinyan pagpanaw da nilan, aon malaikat ng Tohan na yagapakita kang Yosop sang tagaynup nan aw laong nan, “Bangon da aw daa yang isu aw yang ina nan aw panaw da kamo adto sang Misir. Adto da kamo maguya taman sang pagalaongon ta kamo na makaori da oman kamo. Kay anapun ni Hirod yang isu antak patayun nan.” ");
INSERT INTO kqe_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ansinyan sagaw yagabangon da si Yosop. Aw sinyan na gabi pyagaagad nan yang isu aw yang ina nan aw pyomanaw da silan adto sang Misir. ");
INSERT INTO kqe_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Adto da silan magauya sampay na yamatay si Hirod. Yamainang yan antak matoman yang pyaglaongan ng Tohan pinaagi sang sambok na nabi na laong nan, “Tyatawag ko yang anak ko sikun sang Misir.” ");
INSERT INTO kqe_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pagkatigam ni Hirod na yamailad yan nidtong mga mangkatigam kay wa da makaapit kanan, bali na kadaman nan. Agaw syosogo nan yang kanan mga otaw na apatayun nilan yang kariko ng mga isu na usug adto sang Baytlaham aw sang makilibot na mga banwa, na yagaidad ng dowangka toig pababa kay sobay sang pyaglaongan kanan ng mga mangkatigam idto yang wakto na ona nilan ikitaa ingidtong bitoon. ");
INSERT INTO kqe_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, sang mayninyan na pamaagi yamatoman yang pyaglaongan ni Nabi Irimiyas na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aon yamadungug na sowara adto sang banwa ng Rama, yang sowara ng pagpangiyak aw pagminatay. Pyagatiyaowan ni Rakiya yang kanan mga anak aw di da yan malibad kay yamangkamatay da silan.” ");
INSERT INTO kqe_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ansinyan pagkamatay ni Hirod, yagapakita da oman yang malaikat ng Tohan kang Yosop sang tagaynup nan adto sang bangsa ng Misir. ");
INSERT INTO kqe_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Laong nan, “Bangon da aw daa yang isu aw yang ina nan aw ori da kamo adto sang Israil kay yamatay da yang mga otaw na marim magpatay sang isu.” ");
INSERT INTO kqe_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ansinyan sagaw yagabangon da si Yosop aw pyagaagad nan yang isu aw yang ina nan aw yomori da silan adto sang Israil. ");
INSERT INTO kqe_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Awgaid pagdungug ni Yosop na si Arkilas na anak ni Hirod yang bago na soltan sang probinsya ng Yahodiya, yamalluk yan komadto sang Yahodiya. Ansinyan aon oman pyapakatigam kanan ng Tohan sang tagaynup nan daw ono yang madyaw na inangun nan. Agaw kyomadto silan sang probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pagdatung nilan adto, yagauya silan sang longsod ng Nasarit. Na, ansinyan yamatoman yang pyaglaongan ng mga nabi makapantag sang Almasi na laong nilan, “Pagatawagun yan ng taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sidto na wakto kyomadto si Yahiya na Magsosogboway sang kamingawan sang Yahodiya aw yagasogod da yan magosiyat sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Laong nan, “Pagtawbat kamo aw biyai mayo yang mga dosa mayo kay masaid da domatung yang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yani si Yahiya yang pyagalambit ni Nabi Isayas nang yagalaong yan, “Aon sangka otaw na manawag-tawag adto sang kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yang dagom ni Yahiya ininang sikun sang bulbul ng kamil aw yang sintoron nan ininang ng paris ng ayup. Aw yang pagkan nan mga doon aw duga. ");
INSERT INTO kqe_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na, madaig yang mga otaw na kyomadto kanan sikun sang Awrosalam aw sang kadaigan pa na mga banwa sang probinsya ng Yahodiya aw sikun oman sang mga banwa na masaid sang tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yagagogod silan sang mga dosa nilan aw yagapasogbo silan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na, madaig oman yang mga Parisi aw Sadoki na mga pangoo ng agama Yahodi na kyomadto kanan antak magpasogbo. Pagkita kanilan ni Yahiya, yagalaong yan, “Kamo na mga limbongon! Sino kadi yang yagalaong kamayo na kong magapasogbo kamo makalikay kamo sang siksa ng Tohan na mallug da domatung? ");
INSERT INTO kqe_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na, kong di mayo karim na isiksaun kamo, pakitaan da gaid mayo pinaagi sang madyaw na batasan na bunna na tyatarikodan da mayo yang mga dosa mayo. ");
INSERT INTO kqe_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aw ayaw kamo magdumdum na di kamo isiksaun kay mga topo kamo ni Nabi Ibrahim. Kay pagalaong ko kamayo na maskin yaning mga bato amabaoy ng Tohan na mga topo ni Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Timani mayo na main kamo ng kaoy na mallug da pilaun. Kay yang kariko ng kaoy na way madyaw na bonga ipilaun aw timbagan adto sang atoon. ");
INSERT INTO kqe_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ako, tobig yang pyagasogbo ko kamayo silbi tanda na yagatawbat da kamo sang mga dosa mayo. Awgaid aon mosonod kanak domatung na labaw pa kanak. Aw maskin yang pagbitbit ng sandalyas nan di dait kanak. Yang pagasogbo nan sang kadaigan kamayo yang Nyawa ng Tohan aw yang kadaigan oman isiksaun nan sang atoon adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yan da yang magahokom sang manosiya aw lainun nan yang mangkadyaw sikun sang mangkaat. Kay main yan ng otaw na magtaap ng omay. Pagkatapos magtaap, tagoon nan yang omay adto sang kamarig. Awgaid yang tipig osonogon nan sang atoon na di amatay.” ");
INSERT INTO kqe_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pagkatapos sinyan pyomanaw si Isa sikun sang probinsya ng Jalil aw kyomadto yan sang tobig ng Yordan antak magpasogbo kang Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Awgaid di gao magsogbo kanan si Yahiya, laong nan, “Nanga sa magapasogbo kaw kanak? Ako gao yang dait mo sogbowan.” ");
INSERT INTO kqe_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Awgaid tyomobag si Isa, laong nan, “Anda, sogbowi da ako kay dait gaid kita mangagad sang kariko ng kahanda ng Tohan.” Ansinyan yosogot si Yahiya aw syosogbowan nan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkatapos kasogbowan si Isa, syomaka dayon yan sikun sang tobig. Sinyan na wakto yagaboka yang langit aw kikita nan na yukunsad adto kanan yang Nyawa ng Tohan sang porma ng salampati. ");
INSERT INTO kqe_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aw aon sowara sikun sang langit na yagalaong, “Yani yang pyapasaya ko na Anak. Dakowa yang kasowat ko kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ansinyan dyadaa si Isa ng Nyawa ng Tohan adto sang kamingawan kay antak satsatun yan ni Iblis. ");
INSERT INTO kqe_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na, pagkatapos ni Isa magpowasa sa suud ng 40 na allaw aw 40 na gabi, yamagutum da yan. ");
INSERT INTO kqe_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ansinyan dyomood kanan yang manatsatay aw laong nan, “Kong bunna ikaw yang Anak ng Tohan, sogowa yaning mga bato na amainang ng pan.” ");
INSERT INTO kqe_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Awgaid tyomobag si Isa aw laong nan, “Yamakasorat sang Kitab, ‘Yang manosiya di amabowi sabap sang pagkan gaid, kondi sabap oman sang pyaglaongan ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapos sinyan dyadaa yan ni Iblis adto sang Awrosalam, yang tyatawag na sotti na syodad, aw painduga nan adto sang labi na makagwas na bain sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ansinyan yagalaong si Iblis kang Isa, “Aw bunna ikaw yang Anak ng Tohan, layog adto daum. Kay yamakasorat sang Kitab na “ ‘Osogoon ng Tohan yang mga malaikat nan sang pagatiman kanmo. Asakgawon kaw nilan antak yang siki mo di komuug sang bato.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tyomobag si Isa, “Aon oman yamakasorat sang Kitab na yagalaong, ‘Ayaw pagtigia yang Tohan na kanmo Tagallang.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos sinyan dyadaa da oman yan ni Iblis adto sang mataasay na butay aw pyapakita nan kanan yang kariko ng mga pyagadatowan adi sang babawan ng donya aw yang kadyawan sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ansinyan yagalaong si Iblis kang Isa, “Yang kariko sinyan atag ko kanmo kong mosojod kaw kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tyomobag si Isa, “Panaw da, kay Iblis, kay yamakasorat sang Kitab, ‘Yang Tohan na kanmo Tagallang, yan gaid yang asambayangan aw apangagadan mo.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagkatapos sinyan pyapanawan da yan ni Iblis. Ansinyan dyomatung yang mga malaikat aw yatiman nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ansinyan pagdungug ni Isa na yamapiriso da si Yahiya, byomarik yan sang probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Awgaid wa da yan magauya adto sang Nasarit kondi adto da sang Kapirnaom, sambok na longsod sang kilid ng Linaw ng Jalil na adto yakabutang sang lopa na yatag sangaon sang mga tribo ni Sibolon aw Naptali. ");
INSERT INTO kqe_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na, ansinyan yamatoman yang pyaglaongan ni Nabi Isayas na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yang lopa ni Sibolon aw yang lopa ni Naptali na iyan sang daan pasingadto sang dagat, yang banwa na adto sang dipag ng tobig ng Yordan, yan yang banwa na tyatawag oman ng Jalil na pyagauyaan ng mga dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yang mga otaw na yagauya ansan maynang iyan silan sang kaduguuman, awgaid makakita da silan ng allag na labi na mabislaw. Maskin iyan silan sang kaduguuman aw yamalluk silan matay, akaallagan da silan.” ");
INSERT INTO kqe_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sikun sidto na wakto yagasogod da si Isa magosiyat aw laong nan, “Pagtawbat kamo aw biyai mayo yang mga dosa mayo kay masaid da domatung yang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ansinyan sarta yagapanaw si Isa sang kilid ng Linaw ng Jalil, kikita nan yang dowa na maglomon na si Simon na tyatawag oman ni Pitros aw yang mangod nan na si Andriyas. Yamamokot silan kay mangingisdaay silan. ");
INSERT INTO kqe_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yagalaong kanilan si Isa, “Abay da, agad kamo kanak. Sikun adon inangun ta kamo na mangingisdaay ng otaw antak mangagad silan kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na, pagdungug sinyan bibiyaan dayon nilan yang kanilan pokot aw yamagad silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ansinyan pyomanaos si Isa pagpanaw aw kikita oman nan yang dowa na maglomon na si Yakob aw si Yahiya na mga anak ni Sibidi. Yanagpona silan ng pokot adto sang bangka upud sang ama nilan. Tyatawag silan ni Isa na amagad kanan. ");
INSERT INTO kqe_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ansinyan bibiyaan da nilan yang bangka aw yang ama nilan aw yamagad silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ansinyan yamakarimpud si Isa pomanaw sang tibok probinsya ng Jalil. Yagaindo yan adto sang mga pagsasambayangan ng mga Yahodi aw yagaosiyat yan ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw pyapakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na, yang gogodanun makapantag kanan yamakarimpud oman adto sang bangsa ng Siriya. Agaw, dyadaa da ng mga otaw yang kariko ng mga masakitun adto kanan, mga otaw na bali na kasakit yang lawas nilan, mga kyakasaytanan, mga byababoy-baboy aw mga yamasadi yang lawas nilan. Aw yang kariko nilan pyapakadyaw ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ansinyan madaig yang mga otaw na yamagad kanan. Aon mga taga Jalil, aon oman sikun sang probinsya ng Dikapolis, taga Awrosalam, taga Yahodiya aw sikun oman adto sang dipag ng tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ansinyan pagkita ni Isa sinyang kamangaotawan na yamagad kanan, syomaka yan sang butay aw magingkod ansan. Pagingkod nan, dyomood kanan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na, yagasogod da si Isa magindo, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kadyaw ng ginawa sidtong mga otaw na yamatigam na way amainang nilan kong di silan atabangan ng Tohan, kay yamasakop da silan sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kadyaw ng ginawa sidtong mga otaw na yamarido sabap sang kaatan adi sang donya, kay libadun silan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kadyaw ng ginawa sidtong mga otaw na magpababa sang ginawa nilan, kay amangkun nilan yang pyapasad ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kadyaw ng ginawa sidtong mga otaw na mallini mangagad sang karim ng Tohan, kay atabangan nan silan paginang sang karim nan. ");
INSERT INTO kqe_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kadyaw ng ginawa sidtong mga otaw na malooy sang kapagonawa nilan, kay akaloyan oman silan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kadyaw ng ginawa sidtong mga otaw na mapoti yang pangatayan nilan, kay makakita silan sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kadyaw ng ginawa sidtong mga otaw na magaosay sang kapagonawa nilan, kay pagatawagun silan ng Tohan na mga anak nan. ");
INSERT INTO kqe_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kadyaw ng ginawa sidtong mga otaw na pyapakasikotan sabap sang pagpangagad nilan sang karim ng Tohan, kay yamasakop da silan sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kadyaw ng ginawa mayo kong paginsoltoon aw apakasikotan kamo aw pagbutang-butangan kamo ng maskin ono na maat sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqe_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pagkasowat kamo kay dakowa yang baras mayo adto sang sorga. Kay maynan oman yang pagpakasikot sang mga nabi sangaon.” ");
INSERT INTO kqe_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yagalaong oman si Isa, “Kamo na yamangagad kanak, main kamo ng asin adi sang donya. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. Agaw, waa day poos nan aw itimbag da gaid yan adto logwa aw pagagina-ginaan da yan ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamo na yamangagad kanak, main kamo ng allag adi sang donya. Na, yang allag di amatago magonawa sang syodad na yakabutang sang babaw ng butay. ");
INSERT INTO kqe_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Way otaw na magasuga ng ilawan aw asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan antak kaallagan yang kariko ng mga otaw adto sa suud ng baay. ");
INSERT INTO kqe_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Magonawa sinyan, pakitaan mayo yang allag mayo sang atobangan ng mga otaw antak makita nilan yang madyaw na batasan mayo aw pojiun nilan yang Tohan na Ama mayo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayaw kamo magdumdum na yakani ako antak kamangan ko ng kapantagan yang Hokoman ni Nabi Mosa aw yang indowan ng mga nabi. Wa ako akani sang pagkamang sinyan, kondi yakani ako antak atagan ko yan ng bunna na katomanan. ");
INSERT INTO kqe_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sang bunna-bunna pagalaong ko kamayo na sampay aon pay langit aw lopa di amakamang maskin yang sambok na litra atawa kodlit sikun sang Hokoman ng Tohan aw di amawaa yang kapantag sinyan sampay di amatoman yang kariko sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Idto sagaw, sino-sino yang mosopak sang maskin labi na magaan na sogowan ng Tohan aw magaindo sang kadaigan na mosopak oman sinyan, amainang yan ng pinakababa adto sang pyagadatowan ng Tohan. Awgaid sino-sino yang amangagad sang mga sogowan aw magaindo sang kadaigan na amangagad oman sinyan, amainang yan ng labi na dakowa adto sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Agaw pagalaong ko kamayo kong yang pagpangagad mayo sang karim ng Tohan di makalabaw sang pagpangagad ng mga magiindoway ng Hokoman aw yang mga Parisi, di kamo makasuud sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yagalaong oman si Isa, “Yamadungug mayo yang sogo adto sang mga kaompowan natun na yagalaong, ‘Ayaw magpatay. Kay sino-sino yang magapatay sang kapagonawa nan, dait yan hokoman.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Awgaid ako, pagalaong ko kamayo na sino-sino yang amadaman sang kapagonawa nan, dait yan hokoman. Aw sino-sino yang magalaong sang kapagonawa nan na, ‘Way tiyap mo,’ dait yan daun adto sang Makagwas na Hokmanan. Aw sino-sino yang magalaong sang kaupdanan nan na, ‘Bowang kaw,’ dait yan itimbag sang atoon adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Na, kong iyan kaw sang Baay ng Tohan antak magpakorban adto sang Tohan, aw ansinyan kyakadumduman mo na aon otaw na maat yang ginawa nan kanmo, ");
INSERT INTO kqe_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, bilina nay yang korban mo aw kadtowi mona yang idtong otaw aw pagosay kamo. Pagkatapos, barik adto sang Baay ng Tohan aw pagpakorban. ");
INSERT INTO kqe_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kong aon otaw na magadimanda kanmo, pagosay kamo sang wa pa kamo adatung sang hokmanan. Kay kong dili, basin adaun kaw nan adto sang howes, aw ansinyan adaun kaw adto sang polis aw alasak da kaw sang pirisowan. ");
INSERT INTO kqe_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sang bunna-bunna pagalaong ko kamayo na di da kaw amakalogwa sikun sinyan sampay di mo akabayadan yang kariko ng molta mo. ");
INSERT INTO kqe_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yamadungug oman mayo yang sogo na yagalaong, ‘Ayaw magjina.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Awgaid ako, pagalaong ko kamayo na sino-sino yang matanaw sang sambok na bobay aw maganiyat ng maripa, yakajina da yan sidtong bobay sa suud ng pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Agaw sagaw, kong yang karinto na mata mo yang pyagasabapan na amakadosa kaw, lusata yan aw timbagan. Kay madyaw pa yang akawaan kaw ng sangkilid gaid na mata kaysang itimbag yang tibok lawas mo adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aw kong yang karinto na arima mo yang pyagasabapan na amakadosa kaw, otoda yan aw timbagan. Madyaw pa yang akawaan kaw ng sangkilid gaid na arima kaysang itimbag yang tibok lawas mo adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aon oman kasogowan sangaon na yagalaong, ‘Sino-sino yang magabuag sang kanan asawa kinaanglan magatag kanan ng sorat silbi tanda na yanagbuag da silan.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Awgaid ako, pagalaong ko kamayo na sino-sino na usug na magabuag sang asawa nan, awgaid yang asawa nan wa magajina, makadosa da yan na usug kay amainang yan ng pyagasabapan na amadaa yang bobay sang pagjina kong magabana da oman yan. Aw yang usug na amangasawa sidtong bobay na byubuagan, magajina oman. ");
INSERT INTO kqe_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yamadungug da oman mayo yang sogo adto sang mga kaompowan natun na yagalaong, ‘Ayaw pagbarobaa yang kanmo pasad, awgaid tomana yang pasad na ininang mo adto sang Tohan.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Awgaid ako, pagalaong ko kamayo na kong magapasad kamo, ayaw da kamo magsapa. Ayaw kamo maglaong na pagasaksi mayo yang sorga kay yang sorga maynang ingkodanan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ayaw oman kamo maglaong na pagasaksi mayo yang donya kay yang donya maynang tongtonganan ng siki ng Tohan. Ayaw oman kamo maglaong na pagasaksi mayo yang Awrosalam kay yan yang syodad ng Soltan na Labi na Mabarakat. ");
INSERT INTO kqe_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aw ayaw oman kamo maglambit sang oo mayo kong magapasad kamo kay maskin yang sambok na logay mayo di mayo mainang na maitum atawa mapoti. ");
INSERT INTO kqe_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Awgaid yani yang madyaw na inangun mayo. Paglaong gaid kamo ng ‘Ud’ kong ud, atawa ‘Dili’ kong dili, aw ayaw da mayo pagdogangi. Kay maskin ono na idogang mayo sinyan antak gaid kamo pangintoowan, maat yan kay magasikun yan kang Iblis. ");
INSERT INTO kqe_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yamadungug da oman mayo yang sogowan na yagalaong, ‘Kong aon otaw na magalusat sang mata ng kapagonawa nan, dait da oman lusatun yang mata nan. Yang otaw na magapangag sang kapagonawa nan, dait oman yan pangagan.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Awgaid ako, pagalaong ko kamayo na ayaw kamo manimaus sang otaw na yagainang kamayo ng maat. Kong aon magasampal sang karinto na pisngi mo, pasampalan oman kanan yang kawaa. ");
INSERT INTO kqe_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kong aon magadimanda kanmo antak kamangun gao yang kanmo dagom, madyaw pa kong atag oman kanan yang kanmo dagmay. ");
INSERT INTO kqe_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kong aon sondao na magapugus kanmo sang pagdaa ng kanan karga ng sangka kilomitro, madyaw pa kong adaun mo ng dowangka kilomitro. ");
INSERT INTO kqe_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na, atagi yang amangayo kanmo, aw pahirama yang magahiram gao kanmo. ");
INSERT INTO kqe_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yamadungug da oman mayo yang sogowan na yagalaong, ‘Kaloyi yang kaupdanan mo aw dumti yang kalaban mo.’ ");
INSERT INTO kqe_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Awgaid ako, pagalaong ko kamayo na kaloyi yang kalaban mayo aw pangayowi ng kadyawan idtong yagapakasikot kamayo. ");
INSERT INTO kqe_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kay kong maynan yang inangun mayo, amainang kamo ng bunna na mga anak ng Tohan na Ama mayo adto sang sorga. Kay pasilatun nan yang suga antak kaallagan yang kariko ng mga otaw, yang mangkadyaw aw yang mangkaat. Aw atagan oman nan silan ng owan, yang mga otaw na matorid aw yang yagainang ng maat. ");
INSERT INTO kqe_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na, kong kaloyan gaid mayo yang mga otaw na malooy oman kamayo, ono yang baras mayo? Waa! Kay maskin yang mga mangobraay ng bowis na ikilaa na mga limbongon, matigam silan magkalooy sang mga yamalooy kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aw kong pagsalaman gaid mayo yang mga kalomonan mayo, ono yang ininang mayo na labaw pa sang kadaigan? Kay maskin yang mga wa apangintoo sang Tohan yagainang ng mayninyan. ");
INSERT INTO kqe_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Agaw sagaw dait na madyaw yang batasan mayo na way akasaway magonawa sang Tohan na Ama mayo adto sang sorga na yan way akasaway. ");
INSERT INTO kqe_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Timani mayo na di kamo maginang ng pagibada mayo sang atobangan ng mga otaw antak kitaun gaid nilan. Kay kong maynan yang inangun mayo, waa day baras kamayo ng Tohan na Ama mayo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Agaw, kong magaatag kamo ng sidoka adto sang mga miskinan, ayaw kamo magpasigarbo sang ininang mayo na magonawa sang mga otaw na yagapakita-kita gaid. Kay magasidoka silan sang mga miskinan adto sang mga pagsasambayangan atawa sang mga daan antak bantogon silan ng mga otaw. Sang bunna-bunna pagalaong ko kamayo na yamadawat da nilan yang baras nilan aw waa day baras kanilan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Awgaid kamo, kong magasidoka kamo sang mga miskinan, ayaw mayo pagpakatigama sang maskin sino ");
INSERT INTO kqe_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kay antak way otaw na matigam. Aw ansinyan abarasan kamo ng Tohan na Ama mayo na yan yang yamatigam sang ininang mayo sang tago. ");
INSERT INTO kqe_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kong magadowaa kamo, ayaw kamo magsiling sang mga otaw na yagapakita-kita gaid. Kay mallini silan magdowaa na yagaindug adto sang mga pagsasambayangan aw adto oman sang mga kanto antak kitaun silan ng mga otaw. Sang bunna-bunna pagalaong ko kamayo na yamadawat da nilan yang baras nilan. ");
INSERT INTO kqe_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Awgaid kamo, kong magadowaa kamo, pagsuud kamo sang kowarto aw siradowi mayo. Aw adto da kamo magdowaa sang Tohan na Ama mayo na di amakita. Aw ansinyan abarasan kamo ng Ama mayo na yakakita sang ininang mayo sang tago. ");
INSERT INTO kqe_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kong magadowaa kamo, ayaw mayo pagbarik-barika yang mga pyaglaongan mayo magonawa sang ininang ng mga otaw na wa apangintoo sang Tohan. Kay yagadumdum silan na otobagun yang pagdowaa nilan kong madaig yang pyaglaongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ayaw kamo magsiling kanilan kay kyakatigaman ng Tohan na Ama mayo daw ono yang kinaanglan mayo maskin wa pa kamo magapangayo kanan. ");
INSERT INTO kqe_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Agaw, kong magadowaa kamo, maynini yang pagalaong mayo, “ ‘Ya Tohan na Ama nami adto sang sorga, addatan gao yang ngaan mo kay ikaw sotti. ");
INSERT INTO kqe_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Magadato da kaw gao sang kariko ng manosiya. Aw agadan gao yang kahanda mo adi sang donya magonawa ng yagadan da yan adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Atagi kami ng pagkan na kikinaanglan nami ng matag allaw. ");
INSERT INTO kqe_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aw ampona kami sang mga dosa nami kay amponon oman nami yang yamakadosa kanami. ");
INSERT INTO kqe_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pakawata kami sang mga satsat aw lowasa kami sikun sang kaatan.’ ");
INSERT INTO kqe_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na, kong amponon mayo yang yamakadosa kamayo, amponon oman kamo ng Tohan na Ama mayo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Awgaid kong di mayo amponon yang yamakadosa kamayo, di oman kamo amponon ng Tohan na Ama mayo. ");
INSERT INTO kqe_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kong magapowasa kamo, ayaw mayo pakitaan sang parangay mayo na maynang yamarido kamo magonawa sang mga otaw na yagapakita-kita gaid. Kay di silan magpowamos ni magsodlay antak katigaman ng mga otaw na yagapowasa silan. Sang bunna-bunna pagalaong ko kamayo na yamadawat da nilan yang baras nilan aw waa day baras kanilan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Awgaid kamo, kong magapowasa kamo, pagpowamos aw pagsodlay kamo ");
INSERT INTO kqe_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","antak way yamatigam na yagapowasa kamo yatabiya yang Tohan na Ama mayo na di amakita. Aw ansinyan abarasan kamo ng Ama mayo na yakakita sang ininang mayo sang tago. ");
INSERT INTO kqe_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ayaw kamo magtipon ng kakawasaan adi sang donya kay ukutkutun da yan ng anay atawa makalawang atawa apangkawatun pa ng kawatan. ");
INSERT INTO kqe_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Awgaid pagtipon kamo ng kakawasaan adto sang sorga kay ansan di yan asapadan ng anay atawa kalawang aw di oman apangkawatun ng kawatan. ");
INSERT INTO kqe_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kay daw wain yang kakawasaan mayo, adto oman yang pangatayan mayo. ");
INSERT INTO kqe_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yang mata maynang ilawan ng lawas ng otaw. Kong madyaw yang mata mo, matinaw yang pananaw mo. Na, yang mana sinyan na maallag yang dumduman mo kay di kaw amasina kong iridskian yang kapagonawa mo. ");
INSERT INTO kqe_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Awgaid kong dili ng madyaw yang mata mo, hanap yang pananaw mo. Na, yang mana sinyan na sabap sang pagkatokgawan mo maynang iyan kaw sang kaduguuman. ");
INSERT INTO kqe_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Way allang na dowa yang amo nan. Kay yang sambok odumtan nan aw yang sambok addatan nan. Yang sambok apangagadan nan aw yang sambok osopakun nan. Magonawa sinyan, kong yang sapi dakowa sang pangatayan mayo, di kamo makapangagad sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Agaw sagaw pagalaong ko kamayo na ayaw kamo magkarido sang kinabowi mayo daw ono yang akanun aw inumun mayo, atawa ono yang apandagomon mayo. Kay yang kinabowi mayo labaw pa sang pagkan aw yang lawas mayo labaw pa sang dagom. ");
INSERT INTO kqe_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tanawa mayo yang mga langgam. Di silan mananum, di silan maggani aw di silan magtipon ng pagkan sang mga kamarig. Awgaid pyapakan silan ng Tohan na Ama mayo adto sang sorga. Na, di ba, labaw pa yang bili mayo kaysang mga langgam? ");
INSERT INTO kqe_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sino kamayo yang makapataas sang kinabowi nan ng maskin tagbis da gaid sabap sang pagkarido? ");
INSERT INTO kqe_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Magonawa sinyan, nanga sa yamarido kamo sang apandagomon mayo? Tanawa mayo yang mga bolak daw monono yang pagtorin nilan. Di silan maggawbuk aw di silan maglaa. ");
INSERT INTO kqe_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Awgaid pagalaong ko kamayo na maskin yang mga dagom ni Soltan Solayman na bali na kawasa nan wa makatupung sang kadyaw sining mga bolak. ");
INSERT INTO kqe_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na, kong maynan yang pagpandagom ng Tohan sang sagbut na bowi adon awgaid kisuum osonogon da, kamo pa na manosiya, di ba nan kamo atagan ng dagom? Katagbi ng pagpangintoo mayo! ");
INSERT INTO kqe_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Agaw sagaw, ayaw kamo magkarido daw ono yang akanun atawa inumun mayo atawa ono yang apandagomon mayo. ");
INSERT INTO kqe_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kay yani maag yang kyakaridowan ng mga otaw na wa apangintoo sang Tohan. Awgaid kamo, ayaw kamo magkarido kay kyakatigaman ng Ama mayo adto sang sorga na kinaanglan mayo yani na mga butang. ");
INSERT INTO kqe_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Awgaid onaa mayo yang pagpasakop sang pagdato ng Tohan aw yang pagtoman sang karim nan aw ansinyan atagan kamo ng kariko ng kikinaanglan mayo. ");
INSERT INTO kqe_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Agaw sagaw, ayaw kamo magkarido daw ono yang amainang kisuum. Osto da yang mga kasikotan ng matag allaw. Agaw, ayaw da mayo dogangi ng pagkarido sang sonod pa na mga allaw. ");
INSERT INTO kqe_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ayaw kamo maghokom sang kapagonawa mayo antak di oman kamo hokoman ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay hokoman kamo ng Tohan magonawa sang paghokom mayo sang kadaigan. Yang pangsokat na agamitun mayo sang kadaigan, yan oman yang ipangsokat kamayo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nanga sa kono kikita mo yang bagaso sang mata ng lomon mo, awgaid yang kaoy na iyan sang mata mo pyapasagdan da mo? ");
INSERT INTO kqe_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nanga sa makapaglaong kaw sang lomon mo, ‘Tabiya, kay lomon, akamangun ko nay yang bagaso sang mata mo,’ sarta aon kaoy sang kanmo mata? ");
INSERT INTO kqe_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikaw na yagapakita-kita gaid, kamanga nay ona yang kaoy sang mata mo antak kaw makakita ng madyaw sang pagkamang ng bagaso sang mata ng lomon mo.” ");
INSERT INTO kqe_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yagalaong oman si Isa, “Ayaw kamo magatag ng labi na mahalaga adto sang mga ido kay basin akagatun kamo nilan. Aw ayaw kamo magtimbag ng kamayo perlas adto sang mga binatang kay pagagina-ginaan da gaid nilan. ");
INSERT INTO kqe_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pangayo kamo kay atagan kamo. Panganap kamo kay makakita kamo. Pagtawag kamo kay apasuudun kamo. ");
INSERT INTO kqe_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kay sino-sino yang amangayo atagan, aw sino-sino yang amanganap makakita sang pyapanganap nan, aw sino-sino yang magatawag, apasuudun. ");
INSERT INTO kqe_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kamo na mga taganak, kong amangayo ng pagkan yang kamayo anak, atagan ba mayo ng bato? ");
INSERT INTO kqe_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kong amangayo yan ng isda, atagan ba mayo ng bila? ");
INSERT INTO kqe_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na, kong kamo na maat na mga manosiya matigam magatag ng madyaw na mga butang adto sang mga anak mayo, labi-labi da yang Tohan na Ama mayo adto sang sorga! Sang way dowa-dowa atag nan yang maskin ono na madyaw adto sidtong otaw na amangayo kanan. ");
INSERT INTO kqe_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Agaw sagaw paginang kamo sang kapagonawa mayo daw ono yang karim mayo na inangun nilan kamayo. Yani yang kinatibokan ng Hokoman ni Nabi Mosa kipat sang indowan ng mga nabi. ");
INSERT INTO kqe_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pagsuud kamo sang mapiyut na powertaan. Kay maowag yang powertaan aw masayun yang daan pasingadto sang narka. Aw madaig yang yamagi sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Awgaid mapiyut yang powertaan aw masikot yang daan pasingadto sang kinabowi na way kataposan. Aw tagbi gaid yang yakakita sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pagbantay kamo sang mga otaw na yagalaong na mga nabi kono silan, awgaid dili kadi ng bunna. Yang pyaglaongan nilan maynang madyaw paningugan, awgaid main silan ng maisug na ido na amakasapad kamayo. ");
INSERT INTO kqe_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amakilaa mayo silan sabap sang ininang nilan magonawa na akatigaman mayo yang kaoy sabap sang bonga nan. Kay di makaipo ng grips sang sampinit, aw di oman makaipo ng igira sang bowa. ");
INSERT INTO kqe_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kong madyaw yang kaoy madyaw oman yang bonga nan, awgaid kong dili ng madyaw yang kaoy maat yang bonga nan. ");
INSERT INTO kqe_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kay yang madyaw na kaoy di makabonga ng maat, aw yang kaoy na dili ng madyaw di oman makabonga ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na, yang kariko ng kaoy na dili ng madyaw yang bonga, ipilaun aw timbagan adto sang atoon. ");
INSERT INTO kqe_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Idto sagaw, akatigaman mayo yang mga magpapayapatay na dili ng bunna kong tanawon mayo yang ininang nilan. ");
INSERT INTO kqe_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Madaig yang mga otaw na yagalaong na ako yang Dato nilan, awgaid dili ng kariko nilan amasakop sang pyagadatowan ng Tohan kondi silan gaid na yamangagad sang karim ng Tohan na kanak Ama adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pagdatung ng allaw ng paghokom, madaig yang mga otaw na magalaong kanak, ‘Kay Dato, sang kanmo ngaan pyapayapat nami yang pyaglaongan ng Tohan. Aw sang ngaan mo pyapalogwa nami yang mga saytan aw madaig oman yang mga katingaan na ininang nami sabap sang kabarakat mo.’ ");
INSERT INTO kqe_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Awgaid magalaong ako kanilan, ‘Wa ako ikilaa kamayo. Panaw da kamo, kamo na yagainang ng maat!’ ");
INSERT INTO kqe_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Agaw, sino-sino yang amaningug aw amangagad sang pyaglaongan ko, magonawa yan ng matigamay na otaw na yagainang ng baay sa babaw ng bato. ");
INSERT INTO kqe_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kay maskin dakowa yang owan aw yagabaa aw yasogat idtong baay ng makusug na samut, wa yan akatangkug kay bato yang pyagapaindugan sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Awgaid sino-sino yang amaningug sang pyaglaongan ko awgaid di amangagad sinyan, magonawa yan ng sangu na otaw na yagainang ng baay sa babaw ng bowangin. ");
INSERT INTO kqe_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kay pagdatung ng dakowa na owan aw yagabaa aw yasogat idtong baay ng makusug na samut, na, yamatowad da yan aw yamadanas.” ");
INSERT INTO kqe_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapos ni Isa maglaong sinyan, yamangkatingaa yang mga otaw sang pagindo nan. ");
INSERT INTO kqe_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kay yagaindo si Isa na aon kapatot aw dili magonawa sang mga magiindoway ng Hokoman. ");
INSERT INTO kqe_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagkatapos magosiyat tyomobang si Isa sikun sang butay aw madaig yang mga otaw na yamagad kanan. ");
INSERT INTO kqe_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ansinyan dyomood kanan yang sangka otaw na sanglaun. Syomojod yan sang atobangan nan aw laong nan, “Kay Dato, aw karim mo, makapagkadyaw kaw sang kanak sakit.” ");
INSERT INTO kqe_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ansinyan dyadapunan ni Isa yang inyan na otaw ng arima nan aw laong nan, “Ud, karim ko. Amadyaw da kaw.” Na, sinyan na wakto yamawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ansinyan yagalaong kanan si Isa, “Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Aw pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqe_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ansinyan pagdatung ni Isa sang longsod ng Kapirnaom, aon syomongon kanan na sangka otaw na kapitan ng mga sondao na taga Roma. Yagapakilooy yan kanan ");
INSERT INTO kqe_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aw laong nan, “Kay Sir, yang sogowanun ko yagakowang adto sang baay na yamasakit. Di da yan makaliyuk aw bali na kasakit nan.” ");
INSERT INTO kqe_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tyomobag si Isa, “Anda, akadtowan da ko aw apakadyawon ko yan.” ");
INSERT INTO kqe_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Awgaid yagalaong yang kapitan, “Kay Sir, ayaw da magkadto kay way kapatot ko pagtarima kanmo sang kanak baay. Paglaong gaid aw amadyaw da yang sogowanun ko. ");
INSERT INTO kqe_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kyakatigaman ko yani kay ako yagapasakop sang labaw pa kanak aw aon oman mga sondao ko na yagapasakop kanak. Kong sogoon ko yang isa, ‘Adto kaw,’ makadto yan. Kong sogoon ko yang isa, ‘Adi kaw,’ makani yan. Aw kong sogoon ko yang kanak sogowanun, ‘Inanga yani,’ na, inangun da nan.” ");
INSERT INTO kqe_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagdungug sinyan ni Isa, yamatingaa yan aw yagalaong yan sang mga otaw na yamagad kanan, “Sang bunna-bunna pagalaong ko kamayo na waa pay kikita ko na otaw na bangsa Israil na maynini kadakowa ng pagpangintoo nan. ");
INSERT INTO kqe_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Timani mayo yani! Sang madatung na mga allaw madaig yang mga dili ng Yahodi sikun sang yagakatuna-tuna na mga banwa sang silatan aw sallupan na managupud kang Ibrahim, Isahak aw si Yakob sang kandori adto sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Awgaid madaig yang mga otaw na bangsa Israil na silan gao yang amasakop sang pyagadatowan ng Tohan, awgaid di silan amakasuud. Itimbag silan ng Tohan adto sa logwa sang kaduguuman aw adto da silan magtiyao aw mangoyagut yang onto nilan.” ");
INSERT INTO kqe_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ansinyan yagalaong si Isa sang kapitan, “Ori da, aw amatoman yang pyapangayo mo sabap sang pagpangintoo mo.” Aw sinyan na wakto yamadyaw da yang sogowanun nan. ");
INSERT INTO kqe_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ansinyan kyomadto si Isa sang baay ni Pitros. Pagdatung nan ansan, kikita nan yang ogangan na bobay ni Pitros na yagakowang kay labi na mapaso yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ansinyan kyukuputan ni Isa yang arima ng bobay aw yamawaa dayon yang kapaso ng lawas nan. Na, yagabangon da yan aw pakana nan silan Isa. ");
INSERT INTO kqe_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagkakasilum da, madaig yang mga otaw na kyakasaytanan na dyadaa adto kang Isa. Pyapalogwa ni Isa yang mga saytan sikun sidtong mga otaw sang sambok gaid na paglaong aw pyapakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ininang nan yani kay antak matoman yang pyaglaongan ni Nabi Isayas na laong nan, “Yan mismo yang yakamang sang kanatun mga sakit aw yagapakadyaw kanatun.” ");
INSERT INTO kqe_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sangallaw disinyan pagkita ni Isa na madaig yang mga otaw na yanagkatipon sang palibot nan, yagalaong yan sang mga inindowan nan, “Mataripag da kita sang linaw.” ");
INSERT INTO kqe_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sinyan na wakto dyomood kanan yang sambok na magiindoway ng Hokoman aw yagalaong yan kanan, “Kay Goro, amagad ako kanmo maskin makain kaw kadto.” ");
INSERT INTO kqe_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tyomobag si Isa aw laong nan, “Yang mga milo aon kanilan tagowanan aw yang mga langgam aon kanilan pogad. Awgaid ako na Anak ng Manosiya, way kanak logar na akakowangan ko.” ");
INSERT INTO kqe_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aon oman sambok na inindowan nan na yagalaong kanan, “Kay Dato, omori pa nay ako kay ulubung pa ko yang kanak ama.” ");
INSERT INTO kqe_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Awgaid yagalaong si Isa kanan, “Pabayai yang paglubung sang mga patay adto sang mga otaw na main oman ng patay kay wa silan apangintoo kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ansinyan syomakay si Isa sang bangka upud sang mga inindowan nan aw larga da silan. ");
INSERT INTO kqe_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na, tyomokaw moyop yang makusug na samut aw kyakalasakan da ng tobig yang kanilan bangka. Awgaid si Isa yamatoog. ");
INSERT INTO kqe_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Agaw, yodoodan yan ng mga inindowan nan aw pokawa nilan. Laong nilan, “Kay Dato, tabangi kami! Amatay da kita!” ");
INSERT INTO kqe_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yagalaong si Isa kanilan, “Nanga sa yamalluk kamo? Katagbi ng pagpangintoo mayo!” Ansinyan yagabangon yan aw syasagda nan yang samut aw yang mga baud. Na, ansinyan yamalinaw da. ");
INSERT INTO kqe_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yamangkatingaa da yang mga inindowan nan aw yagalaong silan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud motoman kanan?” ");
INSERT INTO kqe_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ansinyan pagdatung nilan adto sang dipag ng linaw sang logar ng mga taga Gadara, syosongon si Isa ng dowangka otaw na lyomogwa sikun sang mga langob na pakoboran. Yaning dowangka otaw kyakasaytanan aw makallukay sagaw silan. Agaw, way makaagi sinyan na daan. ");
INSERT INTO kqe_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ansinyan yamangiyak silan aw laong nilan, “Ikaw na Anak ng Tohan, ono yang labot mo kanami? Yakani kaw sang pagsiksa kanami maskin di pa wakto ng paghokom?” ");
INSERT INTO kqe_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, dili ng mawat kanilan aon dakowa na panon ng mga binatang na yanagdowang. ");
INSERT INTO kqe_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agaw yagapakilooy yang mga saytan kang Isa aw laong nilan, “Aw bogawon mo kami, adto da kami pasuuda sidtong mga binatang.” ");
INSERT INTO kqe_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Anda, kadto da kamo!” laong ni Isa. Ansinyan lyomogwa da yang mga saytan sikun sinyang dowangka otaw aw syomuud silan sang mga binatang. Aw yang tibok panon dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangkalumus. ");
INSERT INTO kqe_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod kay ogogod nilan sang mga otaw yang kariko ng yamaitabo kipat sang yamainang sidtong mga kyakasaytanan. ");
INSERT INTO kqe_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Agaw sa yang kariko ng mga otaw sidtong longsod kyomadto kang Isa aw yanagpakilooy silan kanan na apanawan da nan yang banwa nilan. ");
INSERT INTO kqe_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ansinyan syomakay silan Isa sang bangka aw byomarik da silan adto dipag sang banwa na pyagauyaan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ansinyan aon dyomatung na mga otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. Na, pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, pakatigsuna yang pangatayan mo kay yampon da kaw sang mga dosa mo.” ");
INSERT INTO kqe_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na, aon oman mga otaw ansan na mga magiindoway ng Hokoman. Pagdungug nilan sinyan, yagalaong silan sang ginawa nilan, “Astaga! Yani na otaw yamangkun ng kapatot ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Awgaid kyakatigaman ni Isa yang dumduman nilan, agaw yagalaong yan, “Nanga sa maat yang dumduman mayo? ");
INSERT INTO kqe_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wain yang masayun paglaong, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon aw panaw?’ ");
INSERT INTO kqe_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Adon, antak katigaman mayo na ako na Anak ng Manosiya, aon kapatot ko adi sang babawan ng donya pagampon sang mga dosa, apakadyawon da ko yaning otaw.” Ansinyan yagalaong yan sidtong otaw na sadi, “Pagbangon, daa yang kowangan mo aw ori da adto kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ansinyan yagabangon da yan aw yomori. ");
INSERT INTO kqe_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkita sinyan ng mga otaw, yamangkalluk silan aw pyopoji nilan yang Tohan sabap ng yatag nan sang manosiya yang mayninyan na kapatot. ");
INSERT INTO kqe_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ansinyan pyapanawan da ni Isa yang inyan na baay. Sarta yagapanaw yan, kikita nan yang sambok na mangobraay ng bowis na yagaingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Matiyo. Laong ni Isa kanan, “Abay da, agad kanak.” Ansinyan imindug dayon si Matiyo aw agad kanan. ");
INSERT INTO kqe_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wa akadogay disinyan yanagpangan si Isa aw yang mga inindowan nan adto sang baay ni Matiyo. Madaig oman yang mga mangobraay ng bowis aw yang kadaigan pa na mga otaw na tyatawag na baradosa na yanagupud kanilan koman. ");
INSERT INTO kqe_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagkita sinyan ng mga Parisi, yagalaong silan sang mga inindowan ni Isa, “Nanga sa yakan yang kamayo goro upud sang mga mangobraay ng bowis aw yang mga baradosa?” ");
INSERT INTO kqe_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Awgaid yamakadungug sinyan si Isa, agaw yagalaong yan, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. ");
INSERT INTO kqe_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na, dait sosiun mayo daw ono yang mana ng yamakasorat sang Kitab na yagalaong, ‘Way karim ko sang mga ayup na ipakorban mayo kanak, kondi yani yang karim ko na malooy kamo sang kapagonawa mayo.’ Magonawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan, kondi para sang mga baradosa kay antak magtawbat silan.” ");
INSERT INTO kqe_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ansinyan aon mga inindowan ni Yahiya na Magsosogboway na kyomadto kang Isa aw yagaosip silan kanan, laong nilan, “Kami aw yang mga Parisi yabay magpowasa, awgaid yang mga inindowan mo di magpowasa. Nanga sa?” ");
INSERT INTO kqe_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tyomobag si Isa kanilan pinaagi sang pasombingay, laong nan, “Mapakay ba na di amasowat yang mga bisita sang kawin sarta iyan pa kanilan yang usug na akawinun? Dili! Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun. Ansinyan magapowasa da silan.” ");
INSERT INTO kqe_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na, yagalaong oman si Isa ng tuna pa na pasombingay makapantag sang dadaan na indowan aw yang indowan nan, laong nan, “Way otaw na magatopak ng bago na tela sang dadaan na dagom. Kay kong mokoyot idtong tyotopak, amalasi da oman yang dagom aw labi da yang lasi sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Way oman otaw na yang bago na bino alasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, maasag da yang bino aw amasapad yang lasakanan. Agaw sa, yang bago na bino dait alasak sang bago na lasakanan na abay pa maonat antak di masayang yang bino aw di oman amasapad yang lasakanan.” ");
INSERT INTO kqe_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Adon, sarta yagatiyab pa si Isa dyomatung yang sambok na pangoo ng pagsasambayangan ng mga Yahodi. Syomojod yan sang atobangan ni Isa aw laong nan, “Yang anak ko na bobay baya pa yamatay. Awgaid kong kadtowan mo aw dapunan mo ng arima mo, amabowi oman yan.” ");
INSERT INTO kqe_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ansinyan imindug si Isa aw yamagad kanan. Aw yamagad oman yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Adon, aon sambok na bobay na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. Yodood yan kang Isa ansang likod nan aw kuputi nan yang sagyadan ng dagom nan. ");
INSERT INTO kqe_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kay yagalaong yan sang ginawa nan, “Aw makakuput gaid ako sang dagom ni Isa, amadyaw da ako.” ");
INSERT INTO kqe_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ansinyan ilingi si Isa aw kikita nan idtong bobay. Yagalaong yan kanan, “Kay Bodi, pakatigsuna yang pangatayan mo. Sabap sang pagpangintoo mo yamadyaw da kaw.” Aw sinyan na wakto yamadyaw da idtong bobay. ");
INSERT INTO kqe_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ansinyan dyomatung silan Isa sang baay ni Yairos. Pagsuud ni Isa sang baay, kikita nan yang mga otaw na yanagsoring para sang paglubung aw yang mga otaw na yanagsitiyao. ");
INSERT INTO kqe_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ansinyan yagalaong yan kanilan, “Logwa da kamo! Dili ng patay yang isu, kondi yamatoog gaid yan.” Awgaid inikuan da nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na, paglogwa da ng mga otaw, syomuud si Isa sang kowarto ng isu. Kyukuputan nan yang arima ng isu aw yagabangon da yan. ");
INSERT INTO kqe_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ansinyan yamakarimpud yang gogodanun makapantag sini na ininang ni Isa sang kariko ng makilibot na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ansinyan pagpanaw ni Isa sinyan na baay, aon dowangka otaw na bota na yagasonod kanan. Yamangiyak silan aw laong nilan, “Anak ni Daud, kallati kami!” ");
INSERT INTO kqe_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na, pagsuud ni Isa sang baay na pyagauyaan nan, syomuud oman idtong dowangka bota aw dyomood silan kanan. Ansinyan yosip silan ni Isa, “Yamangintoo kamo na makapagkadyaw ako kamayo?” Tyomobag silan, “Ud, kay Dato.” ");
INSERT INTO kqe_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ansinyan dyadapunan ni Isa yang mata nilan ng arima nan aw laong nan, “Sabap sang pagpangintoo mayo amainang yan kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na, ansinyan yakakita da silan. Pagkatapos, syasagda silan ni Isa, laong nan, “Ayaw gaid kamo maggogod sinyan sang maskin sino.” ");
INSERT INTO kqe_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Awgaid pagpanaw nilan, gyogogod nilan yang makapantag sini na ininang ni Isa sang kariko ng makilibot na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Adon, pagpanaw sidtong mga bota, aon dyadaa adto kang Isa na sambok na otaw na yamaamang sabap ng kyakasaytanan yan. ");
INSERT INTO kqe_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Awgaid pagkatapos ni Isa palogwaun yang saytan sikun sinyan na otaw, yakapagtiyab da oman yan. Yamangkatingaa da yang kariko ng mga otaw aw yanaglaong silan, “Disti-disti waa pay kikita natun na magonawa sini sang tibok banwa ng Israil.” ");
INSERT INTO kqe_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Awgaid yagalaong yang mga Parisi, “Yang pangoo ng mga saytan yang yamatag kanan ng kabarakat pagpalogwa sang mga saytan.” ");
INSERT INTO kqe_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pagkatapos sinyan yamakarimpud si Isa komadto sang kariko ng mga longsod aw baryo aw yagaindo yan adto sang mga pagsasambayangan ng mga Yahodi. Yagaosiyat yan ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw pyapakadyaw nan yang mga otaw sikun sang kariko ng mga sakit nilan. ");
INSERT INTO kqe_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na, pagtanaw ni Isa sang kadaig ng mga otaw, yamalooy yan kanilan kay madaig yang mga kasikotan nilan, awgaid way yamakatabang kanilan. Main silan ng mga karniro na way magbabantayay. ");
INSERT INTO kqe_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Agaw, yagalaong yan sang mga inindowan nan, “Madaig yang ganiunun, awgaid tagbi da yang manggagani. ");
INSERT INTO kqe_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Idto sagaw, pagpangayo-ayo kamo adto sang Tohan na tagtomon ng ganiunun na magapadaa yan ng mga manggagani sang ganiunun nan.” ");
INSERT INTO kqe_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ansinyan tyatawag ni Isa yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw yatagan nan silan ng kapatot pagpalogwa sang mga saytan aw pagpakadyaw sang maskin ono na sakit. ");
INSERT INTO kqe_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, yani yang mga ngaan ng sampoo aw dowa na mga sahabat nan. Ona, si Simon na pyagangaanan oman ni Pitros, aw yang kanan lomon na si Andriyas. Sonod si Yakob aw yang kanan lomon na si Yahiya na mga anak ni Sibidi. ");
INSERT INTO kqe_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Sonod si Pilip aw si Bartolomi, si Tomas, si Matiyo na mangobraay ng bowis, aw si Yakob na anak ni Alpiyo. Sonod si Tadiyos ");
INSERT INTO kqe_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aw si Simon na rebelde sangaon, aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yaning sampoo aw dowa na mga sahabat syosogo ni Isa pagpanaw aw paglaonga nan silan, laong nan, “Ayaw kamo magkadto sang mga banwa ng dili ng Yahodi atawa sang mga longsod ng mga taga Samariya. ");
INSERT INTO kqe_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Awgaid kadto kamo sang mga topo ni Israil kay magonawa silan ng mga karniro na yamangkawaa. ");
INSERT INTO kqe_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panaw kamo aw pagpayapat kamo na mallug da domatung yang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pakadyawa mayo yang mga masakitun aw bowia mayo yang mga patay. Pakadyawa mayo yang mga sanglaun aw palogwaa mayo yang mga saytan sikun sang mga otaw. Dyadawat mayo yaning kapatot ng way bayad, agaw pagtabang oman kamo ng way bayad. ");
INSERT INTO kqe_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ayaw kamo magdaa ng sapi na bowawan atawa pilak ansang bolsa mayo. Maskin pa sinsilyo, ayaw da mayo daa. ");
INSERT INTO kqe_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ayaw oman kamo magdaa ng maskin ono na lasakanan, mga ilisan, sandalyas atawa bangka. Kay yang maggawbukay dait atagan ng panginaanglan nan. ");
INSERT INTO kqe_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Maskin wain na longsod atawa baryo yang adatungan mayo, panganap kamo ng otaw na magatarima kamayo aw ansan da kamo maguya taman sang pagpanaw mayo. ");
INSERT INTO kqe_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagdatung mayo sang sambok na baay, pagsalam nay ona. ");
INSERT INTO kqe_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kong tarimaun kamo ng mga otaw san na baay, kanilan da yang salam na pyapangayo mayo. Awgaid kong di kamo nilan tarimaun, bawia da oman mayo yang salam na pyapangayo mayo. ");
INSERT INTO kqe_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kong aon baay atawa banwa na akadtowan mayo aw yang mga otaw ansan di magatarima kamayo ni amaningug sang pyaglaongan mayo, panawi mayo silan. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sang bunna-bunna pagalaong ko kamayo na pagdatung ng allaw ng paghokom, labaw pa yang siksa sidtong mga otaw kaysang siksa sang mga taga Sodom aw Gomora. ");
INSERT INTO kqe_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Na adon, osogoon ta kamo na main kamo ng mga karniro adto sang mga otaw na main ng mangkaisug na mga ido. Agaw dait na alisto yang dumduman mayo na magonawa ng bila, aw mapoti yang pangatayan mayo na magonawa ng salampati. ");
INSERT INTO kqe_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pagbantay kamo kay adakupun kamo ng mga otaw aw adaun kamo adto sang mga hokmanan aw abadasan kamo adto sang mga pagsasambayangan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sabap sang pagpangintoo mayo kanak adaun kamo adto sang atobangan ng mga gobirnador aw mga soltan. Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan aw adto oman sang mga dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na, kong adakupun aw adaun kamo adto sang hokmanan, ayaw kamo magkarido daw ono yang pagalaong atawa akatobag mayo, kay sinyan na wakto apakatigam kamayo daw ono yang dait mayo paglaong. ");
INSERT INTO kqe_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aw idtong pagalaong mayo di magasikun sang dumduman mayo kondi sang Nyawa ng Tohan na Ama mayo. ");
INSERT INTO kqe_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sinyan na mga allaw aon mga otaw na magapadakup sang kanilan mga lomon antak silan patayun. Aon oman mga ama na magapadakup sang kanilan mga anak antak silan patayun. Aw aon mga anak na malaban sang taganak nilan aw apapatay nilan silan. ");
INSERT INTO kqe_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kamo oman, odumtan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. Awgaid kong magapadayon kamo sang pagpangintoo mayo kanak sampay sang kataposan sini na mga kasikotan, amalowas kamo. ");
INSERT INTO kqe_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kong apakasikotan kamo sang sambok na banwa, layas kamo adto sang tuna na banwa. Sang bunna-bunna pagalaong ko kamayo na sang di pa mayo akadtowan aw pagosiyatan yang kariko ng mga banwa adi sang Israil, mabarik oman ako na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Way inindowan na labaw pa sang kanan goro, aw way sogowanun na labaw pa sang kanan amo. ");
INSERT INTO kqe_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Agaw dait manginsokor yang inindowan kong magaonawa da yan sang kanan goro. Aw dait manginsokor yang sogowanun kong magaonawa da yan sang kanan amo. Na, kong ako na Dato mayo tyatawag ng mga otaw na Bilsibol, sang way dowa-dowa labi pa na maat yang pagatawag nilan kamayo na mga sakop ko. ");
INSERT INTO kqe_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Awgaid maskin maynan, ayaw kamo magkalluk sang mga otaw kay yang kariko ng yamatago adon, amaklaro sang madatung na mga allaw. Aw yang kariko ng wa akatigami adon, akatigaman da. ");
INSERT INTO kqe_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yang pyagalaong ko na kamo gaid yang yamakadungug, apakatigam da mayo adto sang kariko ng mga otaw. Aw yang pyagatomod-tomod ko kamayo, apayapat da mayo adto sang kadaigan. ");
INSERT INTO kqe_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayaw kamo magkalluk sidtong makapatay sang lawas mayo awgaid di makapatay sang nyawa mayo. Awgaid yang Tohan yang dait mayo kallukan kay yan yang amakasapad sang lawas aw nyawa mayo adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Na, dumduma mayo yang mga maya. Di ba dowambok yang amabili mayo ng 50 sintabos gaid? Awgaid abir pa maynan, way maskin sambok kanilan na amallog sang lopa aw amatay kong dili ng kahanda ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na, labi da kamo kay maskin yang logay mayo, kyakatigaman ng Tohan daw pilambok da. ");
INSERT INTO kqe_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Agaw, ayaw kamo magkalluk kay labaw pa yang bili mayo kaysang kadaig ng mga langgam. ");
INSERT INTO kqe_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sino-sino yang magalaong sang atobangan ng mga otaw na yamangagad yan kanak, angkunun ko oman yan na sakop ko sang atobangan ng kanak Ama adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Awgaid sino-sino yang magalaong sang atobangan ng mga otaw na wa yan apangagad kanak, di ko oman yan angkunun na sakop ko sang atobangan ng kanak Ama adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayaw kamo magdumdum na yakani ako sang pagdaa ng kalinaw adi sang donya. Kay dili kalinaw yang dyadaa ko kondi kasamok kay ako yang pyagasabapan ng panagtanam aw pagkabain-bain ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sabap kanak malaban yang anak na usug sang ama nan, yang anak na bobay sang ina nan, aw yang komokuug na bobay sang ogangan nan na bobay. ");
INSERT INTO kqe_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Idto sagaw, yang amainang ng kalaban ng otaw yang sakop mismo sang baay nan. ");
INSERT INTO kqe_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sino-sino yang malugun sang ama atawa ina nan na labaw pa kanak, di dait tawagun na sakop ko. Aw sino-sino yang malugun sang anak nan na usug atawa bobay na labaw pa kanak, di oman dait tawagun na sakop ko. ");
INSERT INTO kqe_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kay sino-sino yang marim mangagad kanak, dait andam yan magagi ng kasikotan aw maskin yang pagkamatay sabap kanak. Kong dili, di yan dait tawagun na sakop ko. ");
INSERT INTO kqe_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kay sino-sino na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyapalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, akaonan ng bunna na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sino-sino yang magatarima kamayo, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang Tohan na yagasogo kanak adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kong aon syosogo ng Tohan, sino-sino yang magatarima kanan kay syosogo yan ng Tohan, atagan yan ng Tohan ng baras na magonawa sang atag nan sidtong syosogo nan. Kong aon otaw na matorid, sino-sino yang magatarima kanan kay matorid yan na otaw, atagan yan ng Tohan ng baras na magonawa sang atag nan sidtong otaw na matorid. ");
INSERT INTO kqe_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aw sino-sino yang magapainum ng maskin tobig gaid sang pinakababa na inindowan ko kay yamangagad yan kanak, sang bunna-bunna abarasan yan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkatapos ni Isa magindo sang sampoo aw dowa na mga inindowan nan, pyomanaw yan ansan aw kyomadto yan sang makilibot na mga longsod antak magindo aw magosiyat. ");
INSERT INTO kqe_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Adon, si Yahiya na Magsosogboway na adto sa suud ng pirisowan, yamadungug nan daw ono yang ininang ng Almasi. Agaw, syosogo nan yang mga inindowan nan adto kang Isa antak magosip kanan. ");
INSERT INTO kqe_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pagdatung nilan kang Isa, laong nilan, “Paglaonga kami daw ikaw agaw yang pyapasad ng Tohan na madatung atawa aon pay tuna na atagadan nami?” ");
INSERT INTO kqe_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tyomobag si Isa, “Barik da kamo adto kang Yahiya aw paglaonga yan daw ono yang dyudungug aw kikita mayo. ");
INSERT INTO kqe_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Paglaonga mayo yan na yang mga bota yakakita da, yang mga sadi yakapanaw da, aw yang mga sanglaun yamadyaw da. Yang mga bungul yakadungug da, yang mga patay yamabowi da oman aw yang Madyaw na Gogodanun yamapayapat da adto sang mga miskinan. ");
INSERT INTO kqe_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kadyaw ng ginawa sidtong otaw na wa magadowa-dowa kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagpanaw ng mga inindowan ni Yahiya, yagalaong si Isa adto sang kamangaotawan makapantag kang Yahiya, laong nan, “Pagkadto mayo sang kamingawan, ono yang kallini mayo kitaun? Sambok na otaw na yagaisab-isab yang dumduman na maynang tambiling na pyagaparid-parid ng samut? ");
INSERT INTO kqe_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na, ono kadi yang kyakadtowan mayo? Sambok na otaw na madyaway yang dagom? Dili kowaw, kay yang mga otaw na mayninyan yang dagom adto magauya sang palasyo ng soltan. ");
INSERT INTO kqe_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Anda, ono sagaw yang kyakadtowan mayo? Sambok na nabi? Bunna sagaw na nabi si Yahiya, awgaid labaw pa yan sang kadaigan pa na mga nabi. ");
INSERT INTO kqe_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kay si Yahiya yang pyagalaong sang Kitab nang yagalaong yang Tohan, “ ‘Apadaa ko yang sogowanun ko antak maona yan kanmo sang pagpangandam ng agianan mo.’ ");
INSERT INTO kqe_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sang bunna-bunna pagalaong ko kamayo na sang kariko ng mga yamangkaotaw adi sang babawan ng donya way makalabaw kang Yahiya na Magsosogboway. Awgaid adon, maskin yang pinakababa na otaw na magapasakop sang pagdato ng Tohan, labaw pa kanan. ");
INSERT INTO kqe_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sikun sang pagosiyat ni Yahiya na Magsosogboway sampay adon makusug yang pagpayapat makapantag sang pagdato ng Tohan aw aon mga otaw na yamaningkamot pagpasakop sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kay yang kariko ng mga nabi aw yang Hokoman ni Nabi Mosa, pyagatagna nilan yang pagdatung ng pagdato ng Tohan aw yagasogod da yang pagtoman sang pyagatagna nilan sang pagdatung ni Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kong mangintoo kamo sang pyaglaongan ng nabi na mabarik kono si Nabi Iliyas, akatigaman da mayo na si Yahiya kadi si Nabi Iliyas. ");
INSERT INTO kqe_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Adon, ono yang akaparias ko sang mga otaw adon na panahon? Magonawa silan sang mga isu na yanagingkod adto sang plaza aw yanaglaro. Yagalaong da yang kadaigan adto sang mga kalaro nilan, ");
INSERT INTO kqe_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Pyagatogtogan kamo nami ng kolintang, awgaid wa kamo magasayaw. Pyagakantaan kamo nami ng kanta ng paglubung, awgaid wa kamo magatiyao.’ ");
INSERT INTO kqe_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na, yang mga otaw adon magonawa da kanilan. Kay pagdatung ni Yahiya, yabay yan magpowasa aw wa yan magainum ng bino. Agaw yagalaong silan na ‘Kyakasaytanan kowaw yani na otaw!’ ");
INSERT INTO kqe_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aw pagdatung ko na Anak ng Manosiya, yakan aw iminum ako. Agaw yagalaong silan, ‘Tanawa mayo, tokgawan aw paralasing yani na otaw! Inagad yan ng mga mangobraay ng bowis aw yang kadaigan pa na mga baradosa.’ Awgaid maskin maynan,” laong ni Isa, “yang bonga ng gawbuk nami ni Yahiya, idto yang tanda na syosogo kami ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ansinyan syasaway ni Isa yang mga otaw sidtong mga banwa daw wain yan magainang ng madaig na mga katingaan kay wa silan magatawbat sang mga dosa nilan. ");
INSERT INTO kqe_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yagalaong yan, “Labi na maat yang adatungan mayo na taga Korasin! Labi na maat oman yang adatungan mayo na taga Bitsayda! Kay kong yamainang pa sang Tiros aw Sidon yang mga katingaan na ininang ko ansan kamayo, dogay da silan yanagsoot ng sako aw yanagingkod sang abo silbi tanda ng pagtawbat nilan. ");
INSERT INTO kqe_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Agaw, pagalaong ko kamayo na sang allaw ng paghokom, labaw pa yang siksa kamayo kaysang mga taga Tiros aw Sidon. ");
INSERT INTO kqe_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na, kamo oman na taga Kapirnaom. Yagadumdum ba kamo na apataasun kamo adto sang sorga? Dili! Kay ioog kamo ng Tohan adto sang narka. Kay kong yamainang pa sang Sodom yang mga katingaan na ininang ko ansan kamayo, sang way dowa-dowa iyan pa adon idtong longsod. ");
INSERT INTO kqe_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na, pagalaong ko kamayo na sang allaw ng paghokom, labaw pa yang siksa kamayo kaysang mga taga Sodom.” ");
INSERT INTO kqe_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagkatapos sinyan yagadowaa si Isa aw laong nan, “O kay Ama, ikaw da yang yagadato adto sang sorga aw adi sang donya. Yamanginsokor ako kanmo kay yang pyagatago mo sang mga aon katigam aw mataas yang pagpangadi pyapakatigam mo adto sang mga way katigam. ");
INSERT INTO kqe_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ininang mo yani, kay Ama, kay idto yang karim mo.” ");
INSERT INTO kqe_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ansinyan yagalaong si Isa sang mga otaw, “Yang kariko ng mga butang yatag kanak ng kanak Ama. Way ikilaa kanak yatabiya yang kanak Ama. Aw way oman ikilaa sang kanak Ama yatabiya ako na Anak nan kipat sidtong mga otaw na pipili ko na makakilaa kanan. ");
INSERT INTO kqe_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Pagdood kamo kanak, yang kariko mayo na kyakapoyan aw kyakabugatan kay antak makapagpatana kamo. ");
INSERT INTO kqe_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tarimaa mayo yang mga sogowan ko aw pangagadi mayo yang indowan ko. Ansinyan akaonan kamo ng kalinaw sa suud ng pangatayan mayo kay ako maloyanun aw masabar. ");
INSERT INTO kqe_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kay yang indowan ko masayun pangagadan aw dili ng mairap yang apainang ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sangallaw disinyan na Allaw ng Pagpatana, yamagi si Isa aw yang mga inindowan nan sang pawa ng trigo. Pagagi nilan yamangutul yang mga inindowan nan ng trigo aw kyukubkub nilan kay yamagutum silan. ");
INSERT INTO kqe_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkita sinyan ng mga Parisi, yagalaong silan kang Isa, “Tanawa yang mga inindowan mo! Sopak sang Hokoman yang ininang nilan kay yagagawbuk silan sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tyomobag kanilan si Isa, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sidtong wakto na yamagutum yan kipat sang mga kaupdanan nan? ");
INSERT INTO kqe_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Syomuud yan sang Baay ng Tohan aw kyakan nan yang pan na pyapasampay adto sang Tohan aw atagi oman yang mga kaupdanan nan. Na, sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan. ");
INSERT INTO kqe_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wa oman mayo akabasa sang Kitab Tawrat na matag Allaw ng Pagpatana, yang mga imam na yagagawbuk adto sa suud ng Baay ng Tohan yamakasopak sang Hokoman kay yagagawbuk silan sang Allaw ng Pagpatana? Awgaid maskin maynan, wa silan makadosa. ");
INSERT INTO kqe_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na, pagalaong ko kamayo na ini adon yang labaw pa sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aon oman yamakasorat sang Kitab na yagalaong yang Tohan, ‘Way karim ko sang mga ayup na ipakorban mayo kanak, kondi yani yang karim ko na malooy kamo sang kapagonawa mayo.’ Na, kong yakasabot kamo sang mana sinyan, wa gao kamo magahokom sidtong mga otaw na way dosa. ");
INSERT INTO kqe_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kay ako na Anak ng Manosiya, aon kapatot ko maglaong daw ono yang mapakay inangun sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ansinyan pyomanaw si Isa ansan aw kyomadto yan sang pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Adto sa suud aon sambok na otaw na yamasadi yang sangkilid na arima nan. Aon oman mga otaw ansan na karim nilan na aon akapagoman nilan kang Isa. Agaw yagaosip silan kanan, “Sobay ba sang Hokoman yang pagpakadyaw sang mga masakitun sang Allaw ng Pagpatana?” ");
INSERT INTO kqe_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tyomobag si Isa, “Sawpama aon karniro mayo na yamallog sang longag sang Allaw ng Pagpatana. Ono yang inangun mayo? Di ba akadtowan mayo aw atabangan mayo? ");
INSERT INTO kqe_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na, labaw pa yang bili ng otaw kaysang karniro! Agaw di kita mosopak sang Hokoman kong matabang kita sang kapagonawa ta sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ansinyan yagalaong si Isa sidtong otaw na yamasadi yang sangkilid na arima nan, “Onata yang kanmo arima.” Na, yonat da nan aw yamadyaw dayon yang arima nan na magonawa sang sangkilid na arima nan. ");
INSERT INTO kqe_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ansinyan lyomogwa da yang mga Parisi sikun sang pagsasambayangan aw yanagbaaw-baaw silan daw monono nilan patayun si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Adon, sabap ng kyakatigaman ni Isa idtong pyagabaawan nilan, pyomanaw yan sikun sinyan na banwa. Madaig yang mga otaw na yamagad kanan aw pyapakadyaw nan yang kariko ng mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Awgaid syasagda nan yang mga otaw na di silan maggogod adto sang kadaigan ng makapantag kanan. ");
INSERT INTO kqe_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Maynini yang ininang nan kay antak matoman yang pyaglaongan ng Tohan pinaagi kang Nabi Isayas na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yadi kay yang kanak sogowanun na pipili ko. Dakowa yan sang pangatayan ko aw yamasowat ako kanan. Apadatung ko kanan yang Nyawa ko aw magapayapat yan adto sang kariko ng mga bangsa na matorid yang paghokom ko. ");
INSERT INTO kqe_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Di yan mapaglalis, di yan amangiyak, aw di oman amadungug yang tingug nan adto sang mga daan. ");
INSERT INTO kqe_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Apakatigsunun nan yang pangatayan ng mga otaw na tagbi gaid yang pagpangintoo, aw atabangan nan yang mga otaw na kyakawaan ng pagsarig. Aw padayonon nan yang gawbuk nan taman sang amatoman da yang matorid na katoyowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aw yang mga otaw sang kariko ng mga bangsa masarig kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ansinyan aon dyadaa adto kang Isa na sambok na otaw na kyakasaytanan na bota aw amang. Pyapakadyaw yan ni Isa, aw ansinyan yakakita aw yakapagtiyab da oman yan. ");
INSERT INTO kqe_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na, yang kariko ng mga otaw na yakakita sinyan yamangkatingaa aw laong nilan, “Basin yan agaw yang Almasi, yang Anak ni Daud?” ");
INSERT INTO kqe_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pagdungug sinyan ng mga Parisi, yagalaong silan, “Astaga! Makapalogwa gaid yan sang mga saytan kay yatagan yan ng kabarakat ni Bilsibol na pangoo ng mga saytan.” ");
INSERT INTO kqe_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Awgaid kyakatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Kong yang mga otaw sang sambok na pyagadatowan managonay magtanam, sang di amadogay amasapad inyan na pyagadatowan. Aw kong magakabain-bain yang mga otaw sang sambok na longsod atawa baay, sang orian magabuag da silan. ");
INSERT INTO kqe_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Magonawa sinyan, kong magabogaw si Iblis sang mga sakop nan na saytan, magakabain-bain da yang pyagadatowan nan aw sang di amadogay amasapad da yan. ");
INSERT INTO kqe_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na, kong bunna yang pyagalaong mayo na yagapalogwa ako sang mga saytan kay si Bilsibol yang yamatag kanak ng kabarakat, sino kadi yang yamatag ng kabarakat adto sang mga inindowan mayo pagpalogwa sang mga saytan? Na, silan da yang magalaong na yamasayup kamo. ");
INSERT INTO kqe_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Awgaid sang bunna-bunna yagapalogwa ako sang mga saytan sabap sang kabarakat ng Nyawa ng Tohan. Aw yani yang tanda na dyomatung da adi kamayo yang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ansinyan yagaatag oman kanilan si Isa ng opamaan, laong nan, “Way otaw na makasuud sang baay ng makusug na otaw aw makakamang sang mga bubutang nan kong di nan ona gaposon idtong makusug na otaw. Awgaid kong yamagapos da nan, makakamang da yan sang mga bubutang sidto na baay. ");
INSERT INTO kqe_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sino-sino yang di madapig kanak, mapaglaban kanak. Aw sino-sino yang di matabang kanak pagtipon, magapakaya-kaya. ");
INSERT INTO kqe_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Agaw pagalaong ko kamayo na yang kariko ng dosa maampon aw maskin pa yang paglaong ng maat makapantag sang Tohan. Awgaid yang paglaong ng maat makapantag sang Nyawa ng Tohan, di maampon. ");
INSERT INTO kqe_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sino-sino yang magalaong ng maat makapantag kanak na Anak ng Manosiya, maampon. Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di maampon taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kong madyaw yang kaoy, madyaw yang bonga nan. Awgaid kong dili ng madyaw yang kaoy, dili ng madyaw yang bonga nan. Agaw, akatigaman yang kaoy sabap sang bonga nan. ");
INSERT INTO kqe_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mga limbongon kamo! Monono kamo makapaglaong ng madyaw na maat sa yang batasan mayo? Kay yang maskin ono na adto sa suud ng pangatayan ng otaw, idto oman yang pagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yang madyaw na otaw, madyaw yang pyaglaongan nan kay madyaw yang lasak ng pangatayan nan. Awgaid yang maat na otaw, maat yang pyaglaongan nan kay maat yang lasak ng pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na, pagalaong ko kamayo na sang allaw ng paghokom amanobag yang mga otaw adto sang Tohan sang kariko ng mga pyaglaongan nilan na way poos. ");
INSERT INTO kqe_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay sobay sang mga pyaglaongan mayo yang paghokom kamayo ng Tohan, daw atarimaun atawa isiksaun kamo.” ");
INSERT INTO kqe_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pagkatapos sinyan dyomood kang Isa yang mga magiindoway ng Hokoman aw yang mga Parisi aw yagalaong silan kanan, “Kay Goro, karim nami makakita ng katingaan sikun kanmo silbi tanda na syosogo kaw ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Awgaid tyomobag si Isa, laong nan, “Maat yang mga otaw adon na panahon aw yagapakawat silan sang Tohan. Yamangayo silan ng katingaan, awgaid way apakita ko kanilan yatabiya sidtong katingaan na yamainang adto kang Nabi Yonos. ");
INSERT INTO kqe_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Toong allaw aw toong gabi adto yan sa suud ng dubdub ng dakowa na isda. Magonawa sinyan ako na Anak ng Manosiya, magapabilin ako sa suud ng kobor sa suud ng toong allaw aw toong gabi. ");
INSERT INTO kqe_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na, sang allaw ng paghokom magabangon yang mga taga Ninibe upud kamayo na mga otaw adon na panahon aw magalaong silan na dait kamo siksaun kay wa kamo magatawbat. Awgaid silan, yagatawbat silan sang mga dosa nilan pagdungug nilan sang pagosiyat ni Nabi Yonos. Na, pagalaongon ta kamo na ini adon yang labaw pa kang Nabi Yonos. ");
INSERT INTO kqe_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sang allaw ng paghokom magabangon oman yang soltana sang bangsa ng Siba upud kamayo na mga otaw adon na panahon aw magalaong yan na dait kamo siksaun. Kay maskin mawat yang banwa nan kyomadto yan antak maningug sang pyaglaongan ni Soltan Solayman kay maum yang katigam nan. Na, pagalaongon ta kamo na ini adon yang labaw pa kang Soltan Solayman. ");
INSERT INTO kqe_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Aw mologwa yang saytan sikun sang otaw na yosuudan nan, magapanaw-panaw da yan sang mga banwa na way tobig antak manganap ng akapagpatanaan nan. Aw way kikita nan, ");
INSERT INTO kqe_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","magalaong yan sang ginawa nan, ‘Mabarik da gaid ako sang dadaan na pyagauyaan ko.’ Na, pagbarik nan makita nan na waa day yagauya aw kyakalinisan da idtong pyagauyaan. ");
INSERT INTO kqe_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ansinyan mapanaw da oman yan kay magadaa yan ng pito pa na mga saytan na labi pa na maat kay kanan aw mosuud silan sidtong otaw aw apaguyaan nilan. Na, sang orian mas maat pa yang kabutang sidtong otaw kaysang pirmiro. Magonawa sinyan yang amaitabo sang mga otaw adon na panahon kay bali na kaat nilan.” ");
INSERT INTO kqe_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sarta yagaindo pa si Isa sang mga otaw, dyomatung yang ina nan aw yang mga mangkangod nan na usug. Yagatagad silan sa logwa kay karim nilan mapagbaaw kanan. ");
INSERT INTO kqe_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ansinyan aon sambok na otaw na yagalaong kang Isa, “Yang ina mo aw yang mga lomon mo adto sa logwa. Karim nilan mapagbaaw kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Awgaid tyomobag si Isa sidtong otaw aw laong nan, “Sino kadi yang ina ko aw mga lomon ko?” ");
INSERT INTO kqe_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ansinyan tyotolli nan yang mga inindowan nan aw laong nan, “Tanawa, silan yang ina ko aw mga lomon ko. ");
INSERT INTO kqe_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kay sino-sino yang yagainang ng karim ng Tohan na kanak Ama adto sang sorga, silan yang ina ko aw yang mga lomon ko na usug aw bobay.” ");
INSERT INTO kqe_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sinyan na allaw pyapanawan da ni Isa yang baay aw kyomadto yan sang kilid ng linaw aw imingkod ansan. ");
INSERT INTO kqe_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ansinyan madaig yang mga otaw na yanagkatipon adto kanan. Agaw, yang ininang ni Isa, syomakay yan sang sambok na bangka aw imingkod ansan sarta yang mga otaw adto managindug sang kilid ng linaw. ");
INSERT INTO kqe_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na, madaig yang pyagaindo ni Isa kanilan pinaagi sang mga pasombingay. Laong nan, “Aon otaw na kyomadto sang pawa antak magsabod ng bini. ");
INSERT INTO kqe_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sang pagsabod nan, aon mga bini na yamallog adto sang kilid ng daan. Ansinyan dyomatung yang mga langgam aw toboga nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aon oman mga bini na yamallog adto sang batoon na lopa. Na, tyomobo dayon yang mga bini kay mababaw yang lopa. ");
INSERT INTO kqe_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Awgaid pagsilat ng suga, yamalanus dayon yang mga tanum sabap sang kapaso ng suga aw yamagango da kay wa silan makagamot ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aon oman mga bini na yamallog adto sang lopa na madaig yang sampinit. Ansinyan tyomorin yang sampinit aw kyakatabonan sinyan yang mga tanum. ");
INSERT INTO kqe_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Awgaid aon oman mga bini na yamallog adto sang madyaw na lopa. Tyomorin silan aw yobonga ng madyaw. Yang kadaigan yobonga ng labi na madaig, yang kadaigan oman yobonga ng madaig, aw yang kadaigan oman yobonga ng osto gaid.” ");
INSERT INTO kqe_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na, laong oman ni Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ansinyan dyomood kang Isa yang mga inindowan nan aw yagaosip silan, laong nilan “Nanga sa mga pasombingay gaid yang gyagamit mo pagindo sang mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tyomobag si Isa, “Kamo, yatagan kamo ng katigam antak makasabot kamo sang mga tinago makapantag sang pagdato ng Tohan. Awgaid yang kadaigan, wa silan atagi sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kay sino-sino yang amaningug ng madyaw, odogangan pa yang katigam nan antak labi da yang katigam nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyakatigaman nan, akamangun pa kanan. ");
INSERT INTO kqe_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Agaw sa mga pasombingay yang gyagamit ko pagindo kanilan kay maskin yagatanaw silan, di silan makakita, aw maskin yamaningug silan, di silan makasabot. ");
INSERT INTO kqe_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idto sagaw yamatoman adto kanilan yang pyaglaongan ng Tohan pinaagi kang Nabi Isayas na laong nan, “ ‘Maskin yamaningug kamo, di kamo makasabot. Aw maskin yagatanaw kamo, di kamo makakita. ");
INSERT INTO kqe_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay yani na mga otaw, matigas yang oo nilan. Tyatabonan nilan yang taringa nilan antak di silan makadungug aw pipilung nilan yang mata nilan antak di silan makakita. Kay kong dili ng maynan yang inangun nilan, makakita aw makadungug da gao silan. Makasabot da gao silan aw mabarik da gao silan adi kanak antak pakadyawon ko silan.’ ");
INSERT INTO kqe_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Awgaid kamo,” laong ni Isa, “kadyaw ng ginawa mayo kay yamakasabot kamo sang dyudungug mayo. ");
INSERT INTO kqe_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sang bunna-bunna pagalaong ko kamayo na madaig yang mga nabi sangaon aw yang kadaigan pa na mga otaw na matorid sang pagtanaw ng Tohan na karim gao nilan kimita sang kikita mayo, awgaid wa silan makakita. Karim gao nilan dumungug sang dyudungug mayo, awgaid wa silan makadungug. ");
INSERT INTO kqe_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Agaw pagpaningug kamo antak kamo makasabot sang mana ng pasombingay makapantag sang otaw na yagasabod ng bini. ");
INSERT INTO kqe_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yang mga otaw na yamakadungug sang pyaglaongan makapantag sang pagdato ng Tohan awgaid wa makasabot sinyan magonawa sidtong kilid ng daan na kyakaoogan ng bini. Ansinyan dyomatung si Iblis aw kyakamang nan yang pyaglaongan na dyudungug nilan sikun sang pangatayan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yang batoon na lopa, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan aw tyatarima dayon nilan na aon kasowat. ");
INSERT INTO kqe_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Awgaid sabap ng wa makagamot yang pyaglaongan ansang pangatayan nilan, di silan magadogay sang pagpangintoo nilan. Kay kong adatungan silan ng mga satsat atawa apakasikotan silan sabap sang pagpangagad nilan sang pyaglaongan ng Tohan, mibiya dayon silan sang pagpangintoo. ");
INSERT INTO kqe_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yang lopa oman na madaig yang sampinit, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan, awgaid sabap sang karidowan nilan adi sang babawan ng donya aw sabap oman sang kallini nilan sang kakawasaan, kyakatabonan da yang pyaglaongan ng Tohan. Idto sagaw way yamakita na bonga ng pagpangintoo sang kinabowi nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Awgaid yang madyaw na lopa, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan aw yamakasabot sinyan. Agaw sagaw aon makita na bonga ng pagpangintoo sang kinabowi nilan. Yang kadaigan yobonga ng labi na madaig, yang kadaigan oman yobonga ng madaig, aw yang kadaigan oman yobonga ng osto gaid.” ");
INSERT INTO kqe_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Adon yagalaong oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan magonawa sang otaw na yagasabod ng madyaw na bini adto sang kanan pawa. ");
INSERT INTO kqe_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sanggabi disinyan sarta yamatoog yang kariko ng mga otaw, dyomatung yang kalaban nan aw yagasabod ng mga liso ng sagbut adto sang pyagatanuman ng madyaw na bini. Pagkatapos, pyomanaw. ");
INSERT INTO kqe_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nang tyomorin da yang mga tanum aw yangiswak da, ansan pa ikitaa na aon oman mga sagbut kadi. ");
INSERT INTO kqe_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ansinyan kyomadto sang tagtomon ng pawa yang mga sogowanun nan aw laong nilan, ‘Kay Dato, madyaw sa yang bini na pyapasabod mo sang kanmo pawa. Wain kadi magasikun yang mga sagbut?’ ");
INSERT INTO kqe_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Tyomobag yang tagtomon ng pawa, ‘Yang kanak kalaban yang yagainang sinyan.’ “Yagaosip silan, ‘Karim mo na agaboton nami yang mga sagbut?’ ");
INSERT INTO kqe_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Ayaw da,’ tyomobag yan, ‘kay kong agaboton mayo, amagabot oman yang mga tanum. ");
INSERT INTO kqe_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayai da gaid mayo yang mga sagbut na magadungan tomobo sang mga tanum taman sang tinggani. Kay pagdatung ng tinggani, osogoon ko yang mga manggagani na agaboton mona nilan yang mga sagbut aw bogkoson nilan antak sonogon. Aw ansinyan apatipon ko kanilan yang mga tanum antak obutang adto sang kanak kamarig.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ansinyan yagalaong da oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan magonawa sang liso ng mostasa na tyatanum ng otaw adto sang kanan pawa. ");
INSERT INTO kqe_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yani na liso yang labi na tagbi sang kariko ng mga liso. Awgaid pagkatorin sinyan, makagwas pa yan sang kariko ng mga tanum aw amainang yan ng kaoy. Aw maskin yang mga langgam makapogad sang mga sanga sinyan.” ");
INSERT INTO kqe_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yagalaong da oman si Isa ng tuna pa na pasombingay, laong nan, “Yang pagdato ng Tohan magonawa sang labadora na pyagasagul ng bobay sang sangka sako na arina aw ininang nan ng masa. Aw ansinyan tyomobo yang tibok masa.” ");
INSERT INTO kqe_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mga pasombingay gaid yang gyagamit ni Isa sang pagindo sang mga otaw. Way pyagaindo nan kanilan na dili pinaagi sang pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Maynini yang ininang nan antak matoman yang pyaglaongan ng Tohan pinaagi sang sambok na nabi na laong nan, “Mga pasombingay yang agamitun ko sang pagbaaw ko kanilan. Pagalaongon ko silan sang mga butang na wa pa akatigami sikun pa sang pagbaoy ng donya.” ");
INSERT INTO kqe_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos sinyan bibiyaan ni Isa yang mga otaw aw syomuud yan sang baay. Ansinyan dyomood kanan yang mga inindowan nan aw yagalaong silan, “Paglaonga kami daw ono yang mana ng pasombingay makapantag sang mga sagbut adto sang pawa.” ");
INSERT INTO kqe_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tyomobag si Isa aw laong nan, “Yang otaw na yagasabod ng madyaw na bini way lain kondi ako na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yang pawa, idto yang donya aw yang madyaw na bini, idto yang mga otaw na yagapasakop sang pagdato ng Tohan. Aw yang mga sagbut, idto yang mga otaw na yagapasakop kang Iblis. ");
INSERT INTO kqe_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yang otaw na yagasabod ng mga liso ng sagbut, yan si Iblis. Yang wakto ng paggani, idto yang kataposan ng donya aw yang mga manggagani, silan yang mga malaikat. ");
INSERT INTO kqe_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na, magonawa sang mga sagbut na agaboton antak silan sonogon, maynan oman yang amaitabo sang Allaw na Maori. ");
INSERT INTO kqe_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kay ako na Anak ng Manosiya, osogoon ko yang kanak mga malaikat antak lainun nilan sikun sang mga otaw na yagapasakop sang pagdato ko yang kariko ng mga otaw na yagainang ng maat aw pyagasabapan ng pagpakadosa ng kadaigan aw itiponon nilan silan. ");
INSERT INTO kqe_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aw ansinyan itimbag silan sang atoon adto sang narka. Adto da silan magtiyao aw mangoyagut yang onto nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Awgaid yang mga otaw na tyatarima ng Tohan na matorid, magasiga da silan na maynang sigay ng suga adto sang pyagadatowan ng Tohan na Ama nilan. Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yagalaong oman si Isa, “Yang pagdato ng Tohan magonawa sang bowawan na lyulubung sang lopa. Pagkita sinyan ng otaw, lyulubung oman nan aw panaw. Sabap sang bali na kasowat nan byabarigya nan yang kariko ng mga butang nan aw binili nan ingidto na lopa.” ");
INSERT INTO kqe_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laong oman ni Isa, “Yang pagdato ng Tohan magonawa oman sang negosyante na yagaanap ng madyaw na mga perlas. ");
INSERT INTO kqe_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkita nan sang perlas na labi na madyaw, byabarigya nan yang kariko ng mga butang nan aw binili nan ingidto na perlas.” ");
INSERT INTO kqe_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Laong oman ni Isa, “Yang pagdato ng Tohan magonawa oman sang pokot na tyataktak sang dagat antak makamang yang klasi-klasi na isda. ");
INSERT INTO kqe_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kong pono da yang pokot, ogoyodon inyan adto sang baybay. Ansinyan magaingkod da yang mga mangingisdaay antak mamili ng isda. Yang madyaw na isda alasak nilan sang aniga, awgaid yang maat itimbag nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na, maynan oman yang akatamanan sang Allaw na Maori. Kay makani yang mga malaikat aw alainun nilan yang maat na mga otaw sikun sang mga otaw na matorid sang pagtanaw ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aw yang maat na mga otaw itimbag nilan sang atoon adto sang narka. Adto da silan magtiyao aw mangoyagut yang onto nilan. ");
INSERT INTO kqe_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Na, yakasabot ba kamo sang kariko sining pyagalaong ko kamayo?” yosip ni Isa yang mga inindowan nan. Tyomobag silan, “Ud.” ");
INSERT INTO kqe_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ansinyan yagalaong yan kanilan, “Kong maynan, makasabot oman kamo na kong aon magiindoway ng Hokoman na amangagad sang indowan ko makapantag sang pagdato ng Tohan, magonawa yan sang tagtomon ng baay na aon kakawasaan na bago aw dadaan adto sang kanan bodega kay matigam yan magindo ng dadaan aw bago na indowan.” ");
INSERT INTO kqe_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pagkatapos ni Isa maggogod sidtong mga pasombingay, pyapanawan da nan inyan na banwa. ");
INSERT INTO kqe_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yomori yan adto sang Nasarit, yang longsod na tyotorinan nan, aw yagaindo yan adto sang pagsasambayangan ng mga Yahodi. Ansinyan yamatingaa yang mga otaw na yamakadungug kanan aw yagalaong silan, “Wain yani na otaw makakamang sining katigam? Aw wain yan sang kabarakat paginang sining mga katingaan? ");
INSERT INTO kqe_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Di ba anak yan ng panday, aw si Mariyam yang kanan ina? Aw yang mga lomon nan si Yakob, si Yosop, si Simon aw si Yodas? ");
INSERT INTO kqe_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Di ba, adi oman magauya yang mga lomon nan na bobay? Awgaid wain yan makakamang sining katigam aw kabarakat?” ");
INSERT INTO kqe_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ansinyan wa nilan atarimaa si Isa. Agaw yagalaong kanilan si Isa, “Yang nabi pyagaaddatan ng mga otaw maskin wain yatabiya adto sang kanan banwa aw sang kanan baay.” ");
INSERT INTO kqe_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Idto sagaw wa yan makainang ng madaig na katingaan sidto na banwa kay wa silan apangintoo kanan. ");
INSERT INTO kqe_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sidto na wakto yamakadungug si Hirod na soltan sang Jalil ng makapantag sang ininang ni Isa ");
INSERT INTO kqe_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aw yagalaong yan sang mga opisyales nan, “Yan kay si Yahiya na Magsosogboway na yamabowi oman! Idto sagaw aon kabarakat nan paginang ng katingaan.” ");
INSERT INTO kqe_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maynini yang pyaglaongan ni Hirod kay sangani pyapadakup nan si Yahiya, pyapagapos aw pyapapiriso nan. Kay si Hirod, pyapangasawa nan si Hirodiya na asawa ng lomon nan na si Pilip. ");
INSERT INTO kqe_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aw yabay yan paglaongon ni Yahiya, laong nan, “Di mapakay na pangasawaun mo yang asawa ng lomon mo. Sopak yan sang Hokoman.” ");
INSERT INTO kqe_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na, sabap sinyan apatayun gao ni Hirod si Yahiya, awgaid yamalluk yan sang mga otaw kay yamangintoo silan na si Yahiya sambok na nabi. ");
INSERT INTO kqe_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, pagdatung ng allaw ng pagkaotaw ni Hirod, yagapakandori yan. Ansinyan yagasayaw yang anak ni Hirodiya sang atobangan ng mga otaw na yagatambong sang kandori, aw bali na kasowat ni Hirod. ");
INSERT INTO kqe_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Agaw yagalaong yan sidtong daaga, “Magapasad ako na atag ko kanmo yang maskin ono na apangayoon mo.” ");
INSERT INTO kqe_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Adon, sabap ng pyagalaong yan ng kanan ina daw ono yang apangayoon nan, yagalaong yan sang soltan, “Atagan kanak adon yang oo ni Yahiya na Magsosogboway na yakabutang sang bandiya.” ");
INSERT INTO kqe_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ansinyan yamarido da yang soltan. Awgaid sabap ng yagapasad yan sang atobangan ng mga bisita nan, yagasogo yan na atag kanan yang pyapangayo nan. ");
INSERT INTO kqe_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Agaw, pyapaotodan da nan si Yahiya ng kanan oo adto sang pirisowan. ");
INSERT INTO kqe_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ansinyan byubutang nilan yang oo nan sang bandiya aw atagan sang anak ni Hirodiya, aw daa nan adto sang kanan ina. ");
INSERT INTO kqe_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na, pagdungug sinyan ng mga inindowan ni Yahiya, kyakadtowan nilan yang lawas nan aw lubungan nilan. Pagkatapos, kyomadto silan kang Isa aw paglaongan kanan yang kyakatamanan ni Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagdungug ni Isa na patay da si Yahiya, syomakay yan sang bangka aw kadto sang mamingaw na banwa. Awgaid pagkatigam ng mga otaw na pyomanaw da si Isa, pyapanawan nilan yang banwa nilan aw yagapanaw silan sang kilid ng linaw antak lopogon nilan. ");
INSERT INTO kqe_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ansinyan pagkawas ni Isa sang bangka, kikita nan yang kadaig ng mga otaw na yolopog kanan. Yamalooy yan kanilan aw pyapakadyaw nan yang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagkakasilum disinyan dyomood kanan yang mga inindowan nan aw laong nilan, “Masaid da somallup yang suga aw mamingaw yani na banwa. Madyaw pa aw pakadtoon mo yang mga otaw adto sang mga baryo antak silan makabili ng pagkan.” ");
INSERT INTO kqe_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Awgaid tyomobag si Isa, “Di kinaanglan na apapanawon ko silan. Kamo da yang magpakan kanilan.” ");
INSERT INTO kqe_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yagalaong silan, “Aon gaid adi kanami limambok na pan aw dowamboos na isda.” ");
INSERT INTO kqe_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yagalaong si Isa, “Daa mayo adi.” ");
INSERT INTO kqe_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ansinyan pyapaingkod nan yang mga otaw ansang kasagbutan. Kyakamang nan yang limambok na pan aw dowamboos na isda aw imingao sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga inindowan nan antak apangatag nilan adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na, yang kadaig ng mga otaw na yakakan, 5,000 yang kausgan na way labot yang kaobayan aw yang mga isu. ");
INSERT INTO kqe_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkatapos sinyan pyapasakay ni Isa yang mga inindowan nan sang bangka. Syosogo nan silan na amaona kanan adto dipag sarta apapanawon nan yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagpanaw da ng mga otaw, tyomokod si Isa sang butay ng sayda nan antak magdowaa. Aw gyagabian yan adto sidtong butay. ");
INSERT INTO kqe_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Awgaid yang bangka na syasakayan ng mga inindowan nan adto da sang laod na kyokoso-koso ng baud kay yosongsong silan sang makusug na samut. ");
INSERT INTO kqe_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pagkakadlawon kyakadtowan silan ni Isa na yagapanaw sang babaw ng tobig. ");
INSERT INTO kqe_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagkita ng mga inindowan na yagapanaw yan sang babaw ng tobig, bali na kalluk nilan. Yamangiyak silan aw laong nilan, “Aon molto!” ");
INSERT INTO kqe_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Awgaid yagalaong dayon si Isa, “Ayaw kamo magkalluk. Ako sa yani. Pakatigsuna mayo yang pangatayan mayo.” ");
INSERT INTO kqe_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ansinyan yagalaong si Pitros, “Kay Dato, kong ikaw yan, pakadtowa ako adto kanmo sang babaw ng tobig.” ");
INSERT INTO kqe_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yagalaong si Isa, “Anda, adi kaw.” Agaw, kyomawas da si Pitros sang bangka aw yagapanaw yan sang babaw ng tobig pasingadto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Awgaid pagbati nan ng makusug na samut, yamalluk yan aw yagasogod da yan malonod. Agaw yamangiyak yan, “Kay Dato, lowasa ako!” ");
INSERT INTO kqe_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na, kyukuputan dayon yan ni Isa aw yagalaong yan kanan, “Katagbi ng pagsarig mo kanak! Nanga sa yagadowa-dowa kaw?” ");
INSERT INTO kqe_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na, pagsakay da nilan dowa sang bangka, yomondang dayon yang samut. ");
INSERT INTO kqe_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aw yang kariko ng mga inindowan ansang bangka syomojod sang atobangan ni Isa aw laong nilan, “Sang bunna-bunna, ikaw yang Anak ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagtaripag da oman nilan sang linaw, yodonggo silan sang banwa ng Ginisarit. ");
INSERT INTO kqe_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ikilaa si Isa ng mga otaw ansan, agaw pyapakatigam dayon nilan adto sang makilibot na mga banwa na iyan da si Isa. Ansinyan dyadaa da ng mga otaw yang kariko ng mga masakitun adto kanan. ");
INSERT INTO kqe_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yamangayo-ayo silan kang Isa na kong mapakay kuputan ng mga masakitun maskin yang sagyadan da gaid ng kanan dagom. Aw yang kariko na yakakuput sang dagom nan yamadyaw. ");
INSERT INTO kqe_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ansinyan aon mga Parisi aw mga magiindoway ng Hokoman sikun sang Awrosalam na dyomood kang Isa aw yagaosip silan kanan, laong nilan, ");
INSERT INTO kqe_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nanga sa yosopak yang mga inindowan mo sang kabatasanan ng mga kaompowan ta? Kay yakan silan maskin wa pa silan makapangonaw.” ");
INSERT INTO kqe_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tyomobag kanilan si Isa, “Kamo oman, nanga sa syosopak mayo yang sogowan ng Tohan sabap sang pagpangagad mayo sang kabatasanan mayo? ");
INSERT INTO kqe_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kay yagalaong yang Tohan, ‘Addati mayo yang ama aw ina mayo.’ Aw ‘Sino-sino yang magalaong ng maat adto sang ama atawa ina nan, dait yan patayun.’ ");
INSERT INTO kqe_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Awgaid tuna yang pyagaindo mayo kay yagalaong kamo na kong magalaong yang otaw adto sang ama atawa ina nan na ‘Yang tabang na atag ko gao kanmo, di da ko maatag kay yatag da ko sang Tohan,’ ");
INSERT INTO kqe_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na, mapakay na di da nan atabangan yang taganak nan. Agaw, sabap sang pagpangagad mayo sang kabatasanan mayo, tyataripundaan mayo yang sogowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kamo na yagapakita-kita gaid na yamangagad sang Tohan! Bunna sagaw yang pyaglaongan ng Tohan makapantag kamayo pinaagi kang Nabi Isayas na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Yani na mga otaw yagapoji kanak sang baba gaid nilan, awgaid mawat kanak yang pangatayan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Way poos yang pagibada nilan kanak kay yang pyagaindo nilan mga sogowan na ininang gaid ng otaw, awgaid yagalaong silan na sogowan inyan ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ansinyan pyapadood ni Isa yang mga otaw adto kanan aw pyagalaong nan silan, laong nan, “Paningug kamo aw sabta mayo yang pagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yang makabatar sang otaw dili ng pagkan na alasak nan sang baba nan kondi yang maat na pyaglaongan na mologwa sikun sang baba nan.” ");
INSERT INTO kqe_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ansinyan dyomood kanan yang mga inindowan nan aw yagalaong silan, “Yamatigam kaw na yamadaman kanmo yang mga Parisi sabap sidto na pyaglaongan mo?” ");
INSERT INTO kqe_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tyomobag si Isa, “Yang kariko ng mga tanum na wa atanuma ng kanak Ama na adto sang sorga, agaboton. ");
INSERT INTO kqe_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayai da silan kay main silan ng bota na yagagabay sang kadaigan pa na mga bota. Na, kong yang bota magagabay sang sambok oman na bota, dowa da silan na amallog sang longag.” ");
INSERT INTO kqe_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ansinyan yagalaong si Pitros kang Isa, “Tabiya, paglaongan kanami yang mana sidtong pyagalaong mo.” ");
INSERT INTO kqe_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yagalaong si Isa, “Na, maskin oman kamo, wa pa kadi kamo makasabot? ");
INSERT INTO kqe_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wa kadi kamo akatigam na yang maskin ono na akanun ng otaw adto amalasak sang tongol aw mologwa da oman sikun sang lawas nan? ");
INSERT INTO kqe_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Awgaid yang mologwa sikun sang baba ng otaw magasikun sang pangatayan, aw idto yang amakabatar kanan. ");
INSERT INTO kqe_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay sikun adto suud ng pangatayan ng otaw yang maat na dumduman na magonawa sang pagpatay, yang pagjina, yang paginang ng kadopangan, pagpangawat, pamakak aw yang pagpitna. ");
INSERT INTO kqe_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Idto yang amakabatar sang otaw. Awgaid yang makan na wa makapangonaw, di yan amakabatar kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ansinyan pyapanawan ni Isa yan na banwa aw kyomadto yan sang logar na masaid sang mga syodad ng Tiros aw Sidon. ");
INSERT INTO kqe_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sidto na logar aon sambok na bobay na dili ng Yahodi na dyomood kang Isa. Pagdood nan kanan yamangiyak yan, “Kay Dato, Anak ni Daud, kallati ako! Kay yang anak ko na bobay kyakasaytanan aw labi da yang kasikot nan.” ");
INSERT INTO kqe_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Awgaid wa otobag kanan si Isa. Ansinyan dyomood kanan yang mga inindowan nan aw yagaangyo silan kanan, laong nilan, “Papanawa idtong bobay kay yagagad-agad yan kanatun aw yagakasamok.” ");
INSERT INTO kqe_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ansinyan yagalaong si Isa sidtong bobay, “Syosogo gaid ako sang mga topo ni Israil kay magonawa silan ng mga karniro na yamangkawaa.” ");
INSERT INTO kqe_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Awgaid yang ininang ng bobay, syomojod yan sang atobangan ni Isa aw laong nan, “Kay Dato, tabangi ako.” ");
INSERT INTO kqe_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Awgaid tyomobag si Isa aw laong nan, “Dili ng madyaw aw akamangun yang pagkan ng mga isu aw itimbag adto sang mga ido.” ");
INSERT INTO kqe_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Bunna sagaw, kay Dato,” yagalaong yang bobay, “awgaid maskin yang mga ido makakan ng momo na amallog sikun sang lamisa ng tagtomon nilan.” ");
INSERT INTO kqe_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ansinyan yagalaong kanan si Isa, “Kay Bodi, dakowa yang pagpangintoo mo! Amatoman da yang pyapangayo mo.” Aw sinyan na wakto yamadyaw da yang anak nan. ");
INSERT INTO kqe_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ansinyan pyomanaw si Isa sinyan na banwa aw kyomadto yan sang kilid ng Linaw ng Jalil. Pagkatapos, tyomokod yan sang butay aw pagingkod ansan. ");
INSERT INTO kqe_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ansinyan madaig yang mga otaw na kyomadto kanan na yagadaa sang mga masakitun magonawa sang mga pongkol, sadi, bota, mga amang aw yang kadaigan pa na masakitun. Byubutang nilan yang mga masakitun sang masaid sang siki ni Isa aw pyapakadyaw nan yang kariko nilan. ");
INSERT INTO kqe_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yamatingaa da yang mga otaw pagkita nilan na yang mga amang yakapagtiyab da, yang mga pongkol yamadyaw da, yang mga sadi yakapanaw da, aw yang mga bota yakakita da. Aw ansinyan pyopoji nilan yang Tohan ng bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Adon pyapadood ni Isa yang mga inindowan nan aw paglaonga nan, “Yamalooy ako sini na mga otaw kay too pang allaw na yamagad silan kanak aw adon waa day pagkan nilan. Di ko karim na paoriun ko silan na yamangkagutum kay basin amalango-lango silan sang daan.” ");
INSERT INTO kqe_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yagalaong kanan yang mga inindowan nan, “Wain kita makakamang ng apakan sang kadaig sining mga otaw disining banwa na mamingaw?” ");
INSERT INTO kqe_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Pilambok yang pan mayo ansan?” yagaosip kanilan si Isa. “Pitombok da,” tyomobag silan, “aw pipila da gaid yang mangkayantuk na isda.” ");
INSERT INTO kqe_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ansinyan pyapaingkod ni Isa yang mga otaw sang lopa. ");
INSERT INTO kqe_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kyakamang nan yang pitombok na pan aw yang mga isda aw panginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan aw atagan sang mga inindowan nan antak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama na pagkan, pitongka bokag yang yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yang kadaig ng mga otaw na yakakan, 4,000 yang kausgan na way labot yang kaobayan aw yang mga isu. ");
INSERT INTO kqe_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkatapos sinyan, pyapaori ni Isa yang mga otaw. Ansinyan syomakay yan sang bangka aw kadto sang banwa ng Magadan. ");
INSERT INTO kqe_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sangallaw disinyan aon mga Parisi aw Sadoki na kyomadto kang Isa antak tigiun nilan. Yamangayo silan kanan ng katingaan silbi tanda na syosogo yan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Awgaid tyomobag si Isa, “Kong mapowa yang langit pagsallup ng suga, magalaong kamo, ‘Madyaw yang timpo kisuum.’ ");
INSERT INTO kqe_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kong mapowa aw maduguum yang langit ng kaamdag, magalaong kamo, ‘Omowan adon na allaw.’ Agaw sa, akatigaman mayo yang timpo sabap sang kikita mayo sang langit. Awgaid nanga sa di kamo matigam magmana sang mga tanda na kikita mayo adon na panahon? ");
INSERT INTO kqe_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Maat yang mga otaw adon na panahon aw yagapakawat silan sang Tohan. Karim nilan makakita ng katingaan, awgaid way apakita kanilan yatabiya sidtong katingaan na yamainang adto kang Nabi Yonos.” Pagkatapos sinyan pyapanawan nan silan. ");
INSERT INTO kqe_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ansinyan pagtaripag ni Isa aw yang mga inindowan nan sang linaw, kyakadumduman ng mga inindowan na wa silan magadaa ng pan. ");
INSERT INTO kqe_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo sang labadora ng mga Parisi aw mga Sadoki.” ");
INSERT INTO kqe_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagdungug sinyan, yanagbaaw-baaw silan aw laong nilan, “Basin maynidto yang pyagalaong nan kay wa kita magadaa ng pan.” ");
INSERT INTO kqe_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Awgaid kyakatigaman ni Isa yang pyagabaawan nilan. Agaw yagaosip yan kanilan, “Nanga sa yanagbaaw-baaw kamo na way daa mayo na pan? Katagbi ng pagsarig mayo kanak! ");
INSERT INTO kqe_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wa pa kadi kamo makasabot? Kyakaringawan da mayo yang limambok na pan na pyagapingas-pingas ko antak makakan yang 5,000 na mga otaw? Aw pilambok yang bokag na yamapono mayo ng yamasama? ");
INSERT INTO kqe_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dumduma oman mayo yang pitombok na pan na pyapakan ko sang 4,000 na mga otaw. Pilambok oman yang bokag na yamapono mayo ng yamasama? ");
INSERT INTO kqe_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nanga sa wa pa kamo makasabot? Dili ng pan yang karim ko ipasabot sang paglaong ko kamayo na dait kamo magbantay sang labadora ng mga Parisi aw Sadoki.” ");
INSERT INTO kqe_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ansinyan yakasabot da yang mga inindowan nan na yang labadora na pyagalaong nan kanilan dili ng labadora na gyagamit sang pan kondi yang indowan ng mga Parisi aw Sadoki. ");
INSERT INTO kqe_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ansinyan kyomadto silan Isa sang logar na masaid sang longsod ng Kisariya Pilipi. Pagdatung nilan adto, yagaosip si Isa sang mga inindowan nan, laong nan, “Sobay sang mga otaw, sino kono ako na Anak ng Manosiya?” ");
INSERT INTO kqe_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas. Yang kadaigan oman yagalaong na ikaw kono si Nabi Irimiyas atawa sambok na nabi sangaon.” ");
INSERT INTO kqe_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yagaosip kanilan si Isa, “Awgaid kamo, ono yang akapaglaong mayo daw sino ako?” ");
INSERT INTO kqe_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tyomobag si Simon Pitros, “Ikaw yang Almasi, yang Anak ng bowi na Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yagalaong si Isa kanan, “Kay Simon na anak ni Yonos, kadyaw ng ginawa mo kay yani wa apakatigaman kanmo ng mga otaw kondi yang Ama ko adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aw adon pagangaanan ta kaw ni Pitros na yang mana san bato. Aw sang babaw sini na bato apaindug ko yang kanak jamaa, aw maskin yang kabarakat ng kamatayun di amakadaog kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Atagan ta kaw ng kapatot sang pyagadatowan ng Tohan. Maskin ono na asagda mo adi sang donya, asagda oman adto sang sorga. Aw maskin ono na otogot mo adi sang donya, otogot oman adto sang sorga.” ");
INSERT INTO kqe_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ansinyan syasagda ni Isa yang mga inindowan nan na di silan maggogod sang maskin sino na yan agaw yang Almasi. ");
INSERT INTO kqe_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sikun sidto na wakto yagasogod da si Isa magpakatigam sang mga inindowan nan daw ono yang amaitabo kanan sang madatung na mga allaw. Laong nan, “Dait na makadto ako sang Awrosalam aw amagi ng mga kasikotan na inangun kanak ng mga pangoo ng mga Yahodi, mga pangoo ng mga imam kipat sang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoong allaw amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagdungug sinyan ni Pitros, pyagaagad nan si Isa sang mawat-awat sang kadaigan aw sagdaa nan, laong nan, “Kay Dato, di gao yan otogot ng Tohan! Di mapakay na amaitabo kanmo yang mayninyan!” ");
INSERT INTO kqe_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Awgaid yagaatobang kanan si Isa aw yagalaong yan kanan, “Panaw ansan, kay Iblis! Yagasatsat kaw kanak kay yang dumduman mo dili ng kahanda ng Tohan kondi yang dumduman gaid ng manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sino-sino yang marim mangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqe_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kay sino-sino na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyapalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, akaonan ng bunna na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kay ono yang amakamang ng otaw kong amangkun nan yang kariko ng kakawasaan adi sang donya, awgaid kong amatay da yan isiksaun da yan adto sang narka? Waa! Kay way akaatag nan antak kaonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kay ako na Anak ng Manosiya mallug da magbarik adi sang donya sang kasiga ng kanak Ama na yagadan ako ng mga malaikat. Aw ansinyan abausan ko yang matag-isa na otaw sobay sang ininang nan. ");
INSERT INTO kqe_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bunna yang pagalaong ko kamayo na aon mga otaw disini na di amatay taman sang ikitaun nilan ako na Anak ng Manosiya na mabarik antak magdato sang kariko.” ");
INSERT INTO kqe_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkatapos ng unum na allaw pyagaagad ni Isa si Pitros aw yang dowa na maglomon na si Yakob aw si Yahiya aw tyomokod silan sang makagwas na butay na silan da gaid. ");
INSERT INTO kqe_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Adto sa taas sarta yagatanaw silan kang Isa, yamaisab yan sang atobangan nilan. Yang kanan parangay yagasiga na maynang suga aw yang kanan dagom yagakapoti na magonawa ng allag na mabislaw. ");
INSERT INTO kqe_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sakadyap yagapakita kanilan si Nabi Mosa aw si Nabi Iliyas aw yapagbaaw silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ansinyan yagalaong si Pitros kang Isa, “Kay Dato, madyaw na ani kami sini. Kong karim mo, magainang ako ng toombok na payag, sambok kanmo, sambok kang Nabi Mosa aw sambok oman kang Nabi Iliyas.” ");
INSERT INTO kqe_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nang yagatiyab pa yan, kyakatabonan silan ng gabon na mabislaway aw aon yamadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang pyapasaya ko na Anak. Dakowa yang kasowat ko kanan. Paningug kamo kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagdungug sinyan ng mga inindowan, bali na kalluk nilan aw syomojod silan sang lopa. ");
INSERT INTO kqe_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Awgaid dyomood kanilan si Isa aw dyadamdam nan silan aw laong nan, “Indug kamo. Ayaw kamo magkalluk.” ");
INSERT INTO kqe_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagtanaw nilan, waa day kikita nilan na bay dakman kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ansinyan pagtobang nilan sikun sang butay, syasagda silan ni Isa aw laong nan, “Ayaw kamo maggogod sang maskin sino sidtong kikita mayo taman sang amabowi oman ako na Anak ng Manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ansinyan yagaosip kanan yang mga inindowan nan, “Nanga sa yagalaong yang mga magiindoway ng Hokoman na madatung ona si Nabi Iliyas bago pa yang Almasi?” ");
INSERT INTO kqe_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tyomobag si Isa, “Bunna sagaw na madatung ona si Nabi Iliyas kay andamun nan yang kariko. ");
INSERT INTO kqe_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Awgaid pagalaong ko kamayo na dyomatung da si Nabi Iliyas awgaid wa yan ikilaa ng mga otaw aw ininang nilan kanan yang maskin ono na kyakallinian nilan. Magonawa sinyan, apakasikotan oman ako na Anak ng Manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ansinyan yakasabot silan na si Yahiya na Magsosogboway kadi yang pyagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagbarik nilan sikun sang butay madaig oman yang mga otaw ansan. Aon sambok na otaw disinyan na dyomood kang Isa aw lyomood sang atobangan nan. ");
INSERT INTO kqe_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Laong nan, “Kay Dato, kallati yang anak ko na usug. Pagbaboyon maag yan aw labi da yang kasikot nan kay abay yan matomba sang atoon atawa mallog sang tobig. ");
INSERT INTO kqe_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Dyadaa da ko yan sang mga inindowan mo, awgaid wa silan makapagkadyaw kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yagalaong si Isa, “Astaga! Kamo na mga otaw adon na panahon, waa say pagpangintoo mayo aw sayup oman yang dumduman mayo. Kadogay da ako ani kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi kanak yang isu.” ");
INSERT INTO kqe_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ansinyan syasagda ni Isa yang saytan na iyan sang lawas ng isu. Aw sidto na wakto lyomogwa dayon yang saytan aw yamadyaw da yang isu. ");
INSERT INTO kqe_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ansinyan nang silan da gaid, dyomood kang Isa yang mga inindowan nan aw yagaosip silan, “Nanga sa wa kami makapalogwa sidtong saytan?” ");
INSERT INTO kqe_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tyomobag si Isa, “Sabap ng kolang pa yang pagpangintoo mayo. Sang bunna-bunna pagalaong ko kamayo na kong aon pagpangintoo mayo na maskin tagbi na maynang katagbi da gaid ng liso ng mostasa, makapaglaong da kamo sining butay na, ‘Ballin adto!’ aw magaballin sagaw yan. Kay way butang na di mayo amainang kong aon pagpangintoo mayo. ");
INSERT INTO kqe_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Awgaid yang mayninyan na klasi na saytan di mapalogwa yatabiya pinaagi sang pagdowaa aw pagpowasa.” ");
INSERT INTO kqe_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sangallaw disinyan nang yagakatipon yang mga inindowan ni Isa adto sang Jalil, yagalaong yan kanilan, “Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot. ");
INSERT INTO kqe_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Apatayun ako nilan, awgaid sang ikatoong allaw amabowi oman ako.” Pagdungug sinyan ng mga inindowan nan, bali na karido nilan. ");
INSERT INTO kqe_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagdatung nilan sang longsod ng Kapirnaom, dyomood kang Pitros yang mga mangobraay ng bowis para sang Baay ng Tohan aw yagaosip silan, “Yagabayad yang kamayo goro ng bowis para sang Baay ng Tohan?” ");
INSERT INTO kqe_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ud, yagabayad,” tyomobag si Pitros. Ansinyan pagsuud ni Pitros sang baay, yagalaong dayon si Isa kanan, “Simon, sang kanmo dumduman, sino kowaw yang apabayadun ng bowis ng mga soltan adi sang donya? Yang kanilan mga anak atawa yang kadaigan na mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Yang kadaigan,” tyomobag si Pitros. “Na, kong maynan,” laong ni Isa, “di kinaanglan magbayad ng bowis yang mga anak nilan. ");
INSERT INTO kqe_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Awgaid di kita marim na magkaat yang ginawa nidtong mga otaw kanatun. Agaw, kadto da sang linaw aw pamingwit. Kamanga yang ona na isda na motobog aw abrii yang baba nan. Ansan ikitaun mo yang sapi na osto na pagabayad sang bowis natun dowa. Kamanga yang sapi aw atagi yang mga mangobraay ng kanatun bayad.” ");
INSERT INTO kqe_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sidto na wakto dyomood kang Isa yang mga inindowan nan aw yagaosip silan, “Sino kadi yang labaw sang pyagadatowan ng Tohan?” ");
INSERT INTO kqe_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yang ininang ni Isa, tyatawag nan yang sambok na isu aw painduga nan sang atobangan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ansinyan yagalaong yan, “Sang bunna-bunna pagalaong ko kamayo, kong di mayo isabun yang dumduman mayo aw di kamo magaonawa sang tagbi na mga isu, di kamo makasuud sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kay sino-sino yang magapababa sang ginawa nan na magonawa sining tagbi na isu, yan yang labaw sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aw sino-sino yang magatarima sang isu na main sini sabap sang pagpangagad nan kanak, magatarima oman kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Sino-sino yang magasatsat sang maskin sambok sining tagbi na mga isu na yamangintoo kanak antak yan makadosa, madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw itimbag yan adto sang laod. ");
INSERT INTO kqe_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kallat ng mga otaw adi sang donya kay madaig yang mga satsat na madatung kanilan. Di sagaw malikayan na aon mga satsat, awgaid kallat sidtong otaw na yagadaa sang kadaigan sang kadosaan. ");
INSERT INTO kqe_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Idto sagaw, kong yang arima atawa siki mo yang pyagasabapan na amakadosa kaw, otoda inyan aw timbagan. Madyaw pa na sambok gaid yang arima atawa siki mo, awgaid akaonan kaw ng kinabowi na way kataposan kaysang madyaw yang lawas mo awgaid itimbag kaw adto sang narka, sang atoon na di amatay. ");
INSERT INTO kqe_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Magonawa sinyan, kong yang mata mo yang pyagasabapan na amakadosa kaw, lusata yan aw timbagan. Madyaw pa na sambok gaid yang mata mo, awgaid akaonan kaw ng kinabowi na way kataposan kaysang dowambok yang mata mo awgaid itimbag kaw sang atoon adto sang narka.” ");
INSERT INTO kqe_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yagalaong oman si Isa, “Pagbantay kamo na di mayo pagdaog-daogon yang maskin sambok sining mga otaw na magonawa ng tagbi na mga isu. Kay pagalaong ko kamayo na yang mga malaikat na yagabantay kanilan abay adto sang atobangan ng kanak Ama adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kay ako na Anak ng Manosiya yakani sang donya antak lowasun ko yang mga otaw na yagapakawat sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Na, bain kamayo,” laong oman ni Isa, “ono kowaw yang inangun ng otaw na 100 ka bok yang kanan karniro aw yamawaa yang sambok? Di ba ibiyaan nan yang 99 na yanagpanamsam adto sang kabtayan aw anapun nan yang sambok na yamatanak? ");
INSERT INTO kqe_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na, kong kitaun da nan, bali na kasowat nan. Sang bunna-bunna labaw pa yang kasowat nan sinyan na karniro kay sidtong 99 na wa akatanak. ");
INSERT INTO kqe_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na, magonawa oman sinyan yang Ama mayo adto sang sorga. Kay di nan karim na magapakawat kanan yang maskin sambok sining mga otaw na magonawa ng tagbi na mga isu.” ");
INSERT INTO kqe_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yagalaong oman ni Isa, “Kong yamakadosa kanmo yang sambok na lomon mo, kadtowi yan aw paglaonga yan sang ininang nan kanmo na kamo gaid dowa. Kong angkunun nan na yamakadosa yan kanmo, pyapabarik da mo oman yang madyaw na relasyon mayo. ");
INSERT INTO kqe_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Awgaid kong di yan amaningug kanmo, paagada adto kanan yang isa atawa dowangka otaw antak tomanun mo yang yamakasorat sang Kitab na ‘dait pangimunnaan yang kariko ng pyagabaawan mayo ng dowa atawa toongka saksi’. ");
INSERT INTO kqe_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kong di oman yan amaningug sang towada sidtong mga upud mo, pakatigama yang kariko ng jamaa. Na, kong di oman yan marim maningug maskin sang kariko ng jamaa, dumduma da gaid mayo yan na magonawa ng sambok na otaw na wa da akabilang na sakop natun na mga Yahodi atawa magonawa sang mangobraay ng bowis. ");
INSERT INTO kqe_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Sang bunna-bunna pagalaong ko kamayo na maskin ono na asagda mayo adi sang babawan ng donya, asagda da oman adto sang sorga. Aw maskin ono na otogot mayo adi sang donya, otogot da oman adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Na, pagalaong ko oman kamayo na kong aon dowangka otaw kamayo adi sang babawan ng donya na magakaoyon sang maskin ono na apangayoon nilan adto sang Tohan, inangun yani ng Ama ko adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kong aon dowa atawa toongka otaw na magakasambok sang ngaan ko, iyan ako kanilan.” ");
INSERT INTO kqe_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wa akadogay disinyan dyomood si Pitros kang Isa aw yagaosip kanan, laong nan, “Kay Dato, kong aon upud ko na abay makadosa kanak, makapila ko yan dait amponon? Makapito ba?” ");
INSERT INTO kqe_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tyomobag si Isa, “Dili gaid ng makapito, kondi kapitowan na kapito. ");
INSERT INTO kqe_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kay yang pyagadatowan ng Tohan magonawa sang soltan na marim mangobra sang mga sogowanun nan ng otang nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na, sang yagasogod da yan mangobra ng kanilan otang, aon dyadaa adto kanan na sogowanun na yakaotang kanan ng minilyon. ");
INSERT INTO kqe_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aw sabap ng way akabayad nan, yagasogo yang soltan na abarigya yan antak mainang ng allang upud sang kanan asawa aw yang mga anak nan, aw abarigya oman yang kariko ng mga butang nan antak kabayadan yang kariko ng otang nan. ");
INSERT INTO kqe_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Awgaid yang ininang ng sogowanun, syomojod yan sang atobangan ng soltan aw yagapakilooy kanan, laong nan, ‘Tabiya, kay Soltan, ayaw ako pagapikia. Kay abayadan pa ko yang kariko ng otang ko kanmo.’ ");
INSERT INTO kqe_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ansinyan yamallat kanan yang soltan aw pyapapas nan yang kariko ng otang nan aw pyapapanaw nan. ");
INSERT INTO kqe_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Na, pagpanaw da sinyan na sogowanun, yamakita nan yang kaupud nan na sogowanun na yakaotang kanan ng pilangka gatos gaid. Na, gyagallat da nan, titigul aw paglaonga, ‘Bayadi da yang otang mo kanak.’ ");
INSERT INTO kqe_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Awgaid yang ininang ng kaupud nan, syomojod yan aw yagapakilooy kanan, laong nan, ‘Ayaw da ako pagapikia kay abayadan ta kaw.’ ");
INSERT INTO kqe_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Awgaid wa osogot idtong sogowanun. Pyapapiriso nan yang upud nan taman sang amakabayad da yan ng kanan otang. ");
INSERT INTO kqe_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na, pagkita sinyan ng kadaigan na mga sogowanun, bali na karido nilan. Agaw kyomadto silan sang soltan aw paglaonga kanan yang kariko nidtong kyakatamanan. ");
INSERT INTO kqe_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ansinyan pyapatawag ng soltan yang idtong sogowanun aw paglaonga nan, ‘Darowaka kaw. Pyapapas da ko yang kariko ng otang mo sabap ng yagapakilooy kaw kanak. ");
INSERT INTO kqe_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dait gao na amallat kaw oman sang kaupud mo na sogowanun magonawa sang pagkallat ko kanmo.’ ");
INSERT INTO kqe_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yamadaman da yang soltan aw pyapapiriso nan idtong sogowanun taman sang akabayadan da nan yang kariko ng otang nan.” ");
INSERT INTO kqe_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sang orian yagalaong oman si Isa, “Na, magonawa sinyan yang inangun kamayo ng Tohan na kanak Ama adto sang sorga kong di mayo amponon yang kapagonawa mayo na iklas yang pangatayan mayo.” ");
INSERT INTO kqe_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos ni Isa maglaong sinyan pyapanawan nan yang probinsya ng Jalil aw kyomadto yan sang probinsya ng Yahodiya na adto sang dipag ng tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Madaig yang mga otaw na yamagad kanan aw pyapakadyaw nan yang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ansinyan aon pilangka otaw na mga Parisi na dyomood kanan antak magtigi kanan. Yagaosip silan, “Sobay sang Hokoman mapakay ba na buagan ng usug yang kanan asawa na maskin ono yang pyagasabapan?” ");
INSERT INTO kqe_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tyomobag si Isa, “Wa ba kamo makabasa na yamakasorat sang Kitab na sang pukas pagbaoy ng Tohan sang donya, byabaoy nan yang otaw na usug aw bobay? ");
INSERT INTO kqe_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aw pagkatapos san yagalaong yang Tohan, ‘Sabap sinyan ibiyaan ng usug yang kanan ama aw ina aw umupud sang asawa nan aw ansinyan magakasambok da silan.’ ");
INSERT INTO kqe_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Agaw, di da silan ng dowa kondi sambok da. Idto sagaw, di mapakay pagpitasun ng otaw yang pyagakasambok ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Na, kong maynan,” yanagosip da oman yang mga Parisi, “nanga sa yagalaong si Nabi Mosa na makaatag kono yang usug ng sorat sang asawa nan silbi tanda na yanagbuag da silan, aw ansinyan mapakay da nan buagan yang asawa nan?” ");
INSERT INTO kqe_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tyomobag si Isa, “Sabap ng matigas yang oo mayo tyotogotan kamo ni Nabi Mosa ng pagbuag sang asawa mayo. Awgaid sikun sang pukas dili ng maynan yang kahanda ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Agaw pagalaong ko kamayo na sino-sino yang magabuag sang asawa nan maskin wa yan magajina aw amangasawa ng lain, magajina da yan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yagalaong kanan yang mga inindowan nan, “Kong maynan yang kabutang ng magasawa, madyaw pa yang di da gaid amangasawa.” ");
INSERT INTO kqe_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tyomobag si Isa, “Dili ng kariko yang makaagad sinyan yatabiya sidtong mga otaw na yatagan ng Tohan ng kagaga sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yagakatuna-tuna yang mga sabap nanga aon mga usug na di amangasawa. Aon mga usug na aon problima sang lawas nilan sikun pa sang pagkaotaw nilan. Yang kadaigan kyakapon ng otaw. Yang kadaigan oman di amangasawa kay pyapalabi nilan yang paggawbuk para sang pyagadatowan ng Tohan. Na, sino-sino yang makadawat sinyan, madyaw pa aw pangagadan nan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ansinyan aon mga otaw na yagadaa sang mangkatagbi na mga isu nilan adto kang Isa antak dapunan nan silan ng arima nan aw pangayowan nan silan ng kadyawan adto sang Tohan. Awgaid syasagda silan ng mga inindowan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Awgaid yagalaong si Isa, “Pasagdi mayo yang mga isu na modood kanak. Ayaw mayo silan pagbabagi kay yang mga otaw na main nilan yang amakasuud sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ansinyan dyadapunan nan yang mga isu ng arima nan aw pyapangayowan nan silan ng kadyawan. Pagkatapos sinyan pyomanaw yan. ");
INSERT INTO kqe_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sangallaw disinyan aon sambok na otaw na dyomood kang Isa aw yagaosip kanan, “Kay Goro, ono yang madyaw na dait ko inangun antak kaonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqe_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tyomobag si Isa, “Nanga sa yagaosip kaw kanak daw ono yang madyaw? Yang Tohan gaid yang madyaw. Awgaid kong karim mo kaonan ng kinabowi na way kataposan, tomana yang mga sogowan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yagaosip oman yang otaw, “Wain na sogowan?” “Yani na mga sogowan,” laong ni Isa, “Ayaw magpatay, ayaw magjina, ayaw magpangawat, ayaw magsaksi ng bakak. ");
INSERT INTO kqe_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Addati yang ama aw ina mo. Kaluguni yang kapagonawa mo magonawa sang lugun mo sang ginawa mo.” ");
INSERT INTO kqe_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tyomobag yang olitawo, “Yang kariko sinyan tyotoman da ko. Ono pa yang dait ko inangun?” ");
INSERT INTO kqe_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yagalaong si Isa kanan, “Aw karim mo na way gaid akasaway kanmo, ori da aw barigyaan yang kariko ng kabtangan mo aw yang alin atagan sang mga miskinan. Ansinyan akaonan kaw ng kakawasaan adto sang sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagdungug sinyan nidtong olitawo, pyomanaw yan na yamarido yang ginawa nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqe_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sang bunna-bunna pagalaong ko kamayo na mairap sang sapian na otaw pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sagaw, pagalaong ko kamayo na masayun pa sang kamil pagagi sang botas ng dagum kaysang sapian na otaw pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagdungug sinyan ng mga inindowan nan, bali na pagkatingaa nilan aw laong nilan, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqe_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ansinyan pyagatanawan silan ni Isa aw yagalaong yan kanilan, “Sang manosiya, di yan amainang. Awgaid sang Tohan, yang maskin ono amainang nan.” ");
INSERT INTO kqe_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ansinyan yagalaong kanan si Pitros, “Na, monono da kami adon? Bibiyaan da nami yang kariko aw yamagad kami kanmo. Ono yang baras na amadawat nami?” ");
INSERT INTO kqe_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo na pagdatung ng wakto na pabagoon da ng Tohan yani na donya, magaingkod da ako na Anak ng Manosiya sang kanak ingkodanan kay magadato da ako. Kamo oman na yamangagad kanak, magaingkod oman kamo sang sampoo aw dowa na ingkodanan antak maghokom sang sampoo aw dowa na mga tribo ng bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aw sino-sino yang yagabiya sang kanan baay atawa sang mga lomon nan, sang ama aw ina nan, sang mga anak atawa lopa nan sabap sang pagpangagad nan kanak, labaw pa sinyan yang amadawat nan aw atagan yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Awgaid madaig yang yamaona adon na amaori, aw madaig yang yamaori adon na amaona.” ");
INSERT INTO kqe_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yagalaong oman si Isa, “Yang pyagadatowan ng Tohan magonawa sang otaw na tagtomon ng tanumanan ng grips. Sangallaw disinyan pyomanaw yan ng kaamdagay pa kay amanganap ng mga otaw na magagawbuk adto sang tanumanan nan. ");
INSERT INTO kqe_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pagkita nan sang pilangka otaw, yanagsabot silan na atagan nan silan ng osto na bayad ng sangallaw. Pagkatapos, pyapakadto nan silan sang tanumanan antak maggawbuk silan. ");
INSERT INTO kqe_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na, mga alas nowebe ng kaamdag kyomadto yan sang palengke aw aon kikita nan na mga otaw na yagaindugun ansan na way ininang. ");
INSERT INTO kqe_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pyagalaong nan silan, ‘Paggawbuk oman kamo adto sang kanak tanumanan aw atagan ta kamo ng osto na bayad.’ ");
INSERT INTO kqe_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ansinyan kyomadto da silan antak maggawbuk sang tanumanan. “Na, pagkaalas dose yang suga aw alas tres ng gabila pyomanaw da oman yan aw maynan oman yang ininang nan. ");
INSERT INTO kqe_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sang masaid da alas singko kyomadto da oman yan sang palengke aw aon oman kikita nan na kadaigan pa na mga otaw na yagaindugun gaid ansan. Yosip nan silan, ‘Nanga sa yagaindugun gaid kamo ansan ng tibok allaw na way ininang?’ ");
INSERT INTO kqe_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tyomobag silan, ‘Waa say magpagawbuk kanami.’ “ ‘Na, kong maynan,’ laong ng tagtomon, ‘adto da kamo maggawbuk sang kanak tanumanan.’ ");
INSERT INTO kqe_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagkakasilum disinyan yagalaong yang tagtomon ng tanumanan adto sang kapatas nan, laong nan, ‘Tawaga yang mga trabante aw atagi silan ng bayad nilan. Onaa bayadi yangaong yamaori maggawbuk bago pa idtong yamaona.’ ");
INSERT INTO kqe_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ansinyan dyomatung yang mga otaw na yagasogod maggawbuk ng alas singko ng gabila aw yabayadan silan ng osto na bayad ng sangallaw. ");
INSERT INTO kqe_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pagdatung ng mga otaw na yamaona maggawbuk, yagadumdum silan na labaw pa sidtong yamakaori yang bayad kanilan. Awgaid yatagan oman silan ng osto na bayad ng sangallaw. ");
INSERT INTO kqe_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na, pagdawat nilan sinyan, yagabagolbol silan aw yagalaong silan sidtong tagtomon, ");
INSERT INTO kqe_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Yaning yamaori maggawbuk, sangka oras gaid yang gawbuk nilan. Awgaid kami, tibok allaw kami magagawbuk sang kapaso pa ng suga! Na, nanga sa magonawa da yang bayad kanilan aw kanami?’ ");
INSERT INTO kqe_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Awgaid tyomobag yang tagtomon sang sambok kanilan, ‘Kay lomon, paningug. Wa ako magalimbong kanmo kay yanagsabot sa kita na atagan ta kaw ng osto na bayad ng sangallaw. ");
INSERT INTO kqe_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dawata da yang bayad mo aw ori da adto kamayo. Karim ko gaid na yaning yamaori maggawbuk amakadawat ng magonawa kanmo. ");
INSERT INTO kqe_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ako da yang magbuut daw ono yang inangun ko sang kanak sapi. Basin yamasina kaw gaid kay ako yamangatag.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na, syosogpatan pa ni Isa yang pyaglaongan nan, “Idto sagaw, yang yamaori adon amaona, aw yang yamaona adon amaori.” ");
INSERT INTO kqe_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ansinyan nang yagapasingadto silan Isa sang Awrosalam, pyagalain nan yang sampoo aw dowa na mga inindowan nan sang kadaigan na mga otaw kay aon pagalaong nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Laong nan, “Paningug kamo. Misingadto da kita sang Awrosalam. Disidto adaun ako na Anak ng Manosiya adto sang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw magahokom da silan na apatayun ako. ");
INSERT INTO kqe_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ansinyan adaun nilan ako adto sang mga dili ng Yahodi. Digay-digayun nilan ako aw abadasan aw alansang adto sang kros. Awgaid sang ikatoong allaw amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ansinyan kyomadto kang Isa yang asawa ni Sibidi upud sang dowa na mga anak nan na usug aw syomojod yan sang atobangan nan kay aon apangayoon nan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yagaosip kanan si Isa, “Ono yang karim mo?” Tyomobag yang bobay, “Pagdatung ng wakto na magadato da kaw, kong mapakay paingkodon mo yaning dowa na anak ko sang kilid mo, yang isa sang karinto mo, aw yang isa sang kawaa mo.” ");
INSERT INTO kqe_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Awgaid yagalaong si Isa sang dowa na mga anak nan, “Wa kamo akatigam daw ono yang pyapangayo mayo. Kaagian ba mayo yang kasikotan na mallug da ko agian?” Tyomobag silan, “Ud, kaya nami.” ");
INSERT INTO kqe_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yagalaong si Isa, “Bunna sagaw na agian mayo yang kasikotan na agian ko. Awgaid way kapatot ko paglaong daw sino yang apaingkodon sang karinto aw kawaa ko kay yang idto pyagakahanda ng kanak Ama sidtong mga otaw na pipili nan.” ");
INSERT INTO kqe_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagdungug sinyan ng sampoo na inindowan, yamadaman silan sidtong dowa na maglomon. ");
INSERT INTO kqe_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Agaw, pyapadood ni Isa yang kariko ng mga inindowan nan aw paglaonga silan, laong nan, “Kyakatigaman sa mayo yang batasan ansining donya na yang mga pangoo sang yagakatuna-tuna na bangsa magmando sang mga sakop nilan. Aw yang mga yagadato kanilan magpakita sang kapatot nilan. ");
INSERT INTO kqe_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Awgaid kamo, dili gao ng maynan yang batasan mayo. Kay sino kamayo yang mallini mainang ng makagwas, dait yan mainang ng sogowanun mayo. ");
INSERT INTO kqe_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aw sino yang mallini mainang ng labaw sang kariko, dait yan mainang ng allang sang kariko. ");
INSERT INTO kqe_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kay maskin ako na Anak ng Manosiya, wa ako akani ansining donya antak tabangan ako ng mga otaw, kondi antak matabang ako kanilan aw magpakamatay ako sang paglowas sang madaig na mga otaw sikun sang mga dosa nilan.” ");
INSERT INTO kqe_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ansinyan pagpanaw nilan Isa sikun sang longsod ng Ariha, madaig yang mga otaw na yamagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Adon, aon dowangka otaw na bota na yagaingkod ansang kilid ng daan. Pagdungug nilan na yalabay si Isa, yamangiyak silan aw laong nilan, “Kay Dato, Anak ni Daud, kallati kami!” ");
INSERT INTO kqe_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ansinyan syasagda silan ng mga otaw antak magpakatingun. Awgaid lomban da silan mangiyak ng matanogay, “Kay Dato, Anak ni Daud, kallati kami!” ");
INSERT INTO kqe_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ansinyan yomondang si Isa, pyapatawag nan idtong dowangka otaw aw osipa nan silan, “Ono yang karim mayo na inangun ko kamayo?” ");
INSERT INTO kqe_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tyomobag silan, “Kay Dato, karim nami makakita.” ");
INSERT INTO kqe_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yamallat si Isa kanilan aw dyadapunan nan yang kanilan mata ng arima nan. Ansinyan yakakita dayon silan aw yamagad silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nang masaid da silan sang syodad ng Awrosalam aw iyan da silan sang baryo ng Bitpagi na adto sang Butay ng Jayton, pyapaona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqe_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Ansan aon makita mayo na asno upud sang kanan nati na yukutan. Obadi mayo silan aw daa adi kanak. ");
INSERT INTO kqe_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kong aon magaosip kamayo daw ono yang ininang mayo, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato.’ Ansinyan apadaa dayon nan kamayo yang mga asno.” ");
INSERT INTO kqe_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na, yamainang yani kay antak matoman yang pyaglaongan ng nabi na laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Paglaonga mayo yang mga taga Siyon, ‘Tanawa mayo, yakani da yang soltan mayo. Yagapababa yan sang ginawa nan aw yakasakay yan sang nati ng asno.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na, pyomanaw da yang dowa na inindowan aw ininang nilan yang pyagasogo kanilan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dyadaa da nilan yang asno kipat sang nati adto kang Isa, yampasan nilan ng mga dagom nilan aw syomakay da si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na, madaig yang mga otaw na yagabutang ng mga dagom nilan ansang daan na agian ni Isa. Yang kadaigan oman yamotol ng mga sanga na madaig yang daon aw pyapakanat nilan sang daan. ");
INSERT INTO kqe_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yang mga otaw na yagaona kang Isa aw yang mga yagasonod kanan yamangiyak, laong nilan, “Pojiun ta yang Anak ni Daud! Atagan gao ng kadyawan yaning syosogo ng Tohan! Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqe_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ansinyan pagsuud ni Isa sang Awrosalam, yagakasamok yang kariko ng mga otaw ansan aw laong nilan, “Sino kadi inyan na otaw?” ");
INSERT INTO kqe_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tyomobag yang mga otaw na yamagad kang Isa, “Yani si Isa, yang nabi na taga Nasarit na sakop ng Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ansinyan syomuud si Isa sang Baay ng Tohan aw pyapalogwa nan yang mga yanagbarigya aw yanagbili ansan. Pyagatowad nan yang mga lamisa ng mga yagakambiyo ng sapi aw yang mga ingkodanan ng mga yagabarigya ng mga salampati. ");
INSERT INTO kqe_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yagalaong yan kanilan, “Yamakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan.” ");
INSERT INTO kqe_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ansinyan aon mga bota aw mga pilay na kyomadto kang Isa adto sang Baay ng Tohan, aw pyapakadyaw nan silan. ");
INSERT INTO kqe_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na, yamadaman da yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman pagkita nilan sang mga katingaan na ininang ni Isa aw pagdungug nilan sang mga isu na yamangiyak adto sang pamanag ng Baay ng Tohan na laong nilan, “Pojiun ta yang Anak ni Daud!” ");
INSERT INTO kqe_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Agaw yagalaong silan kanan, “Yamadungug ba mo yang pyaglaongan sining mga isu?” Tyomobag si Isa, “Ud, nanga sa? Wa kadi mayo akabasa yang yamakasorat sang Kitab na yagalaong, ‘Maskin yang mangkatagbi na mga isu aw yang mga kamokan pyagaindowan ng Tohan pagpoji kanan?’ ” ");
INSERT INTO kqe_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ansinyan bibiyaan silan ni Isa. Pyomanaw da yan sikun sang syodad ng Awrosalam aw kyomadto sang Bitani kay adto da yan maguya ng sanggabi. ");
INSERT INTO kqe_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkakaamdag disinyan nang byomarik silan Isa adto sang syodad, yamagutum si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ansinyan aon kikita nan na kaoy na igira ansang kilid ng daan. Kyakadtowan nan inyan, awgaid way kikita nan na bonga kondi mga daon da gaid. Agaw yagalaong yan sidtong kaoy, “Sikun adon di da kaw amamonga.” Ansinyan yamagango dayon yang kaoy. ");
INSERT INTO kqe_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkita sinyan ng mga inindowan nan, yamatingaa silan aw yagaosip silan, “Nanga sa yamagango dayon yang igira?” ");
INSERT INTO kqe_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo na kong aon pagpangintoo mayo aw di kamo magdowa-dowa, makainang kamo ng magonawa sang ininang ko sining kaoy. Aw dili gaid inyan, kondi makalaong oman kamo sini na butay ‘Ballin adto sang dagat,’ aw amainang yan. ");
INSERT INTO kqe_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kong aon pagpangintoo mayo, amadawat mayo yang maskin ono na apangayoon mayo adto sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ansinyan byomarik da oman si Isa adto sang Baay ng Tohan. Aw sarta yagaindo yan sang mga otaw dyomood kanan yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yagaosip silan kanan, “Ono yang kapatot mo paginang sidto na mga butang? Sino yang yamatag kanmo sini na kapatot?” ");
INSERT INTO kqe_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tyomobag si Isa, “Aon oman osip ko kamayo. Kong matobag mayo, pagalaong ko oman kamayo daw wain magasikun yang kapatot ko paginang sidto na mga butang. ");
INSERT INTO kqe_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, wain magasikun yang kapatot ni Yahiya pagsogbo sang mga otaw, sang Tohan atawa sang manosiya?” Ansinyan yanagbaaw-baaw silan daw ono yang otobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun, ‘Na, nanga sa wa kamo apangintoo kanan?’ ");
INSERT INTO kqe_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, amalluk da kita daw ono yang inangun kanatun ng mga otaw kay yang kariko nilan yamangintoo na sambok na nabi si Yahiya.” ");
INSERT INTO kqe_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Agaw tyomobag silan kang Isa, “Wa nami akatigami.” Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain magasikun yang kapatot ko paginang sidto na mga butang.” ");
INSERT INTO kqe_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yagalaong oman si Isa, “Ono yang dumduman mayo makapantag sini? Aon otaw na dowambok yang anak nan na usug. Kyakadtowan nan yang magowang aw paglaonga nan, ‘Itin, kadto da kaw adon sang kanatun tanumanan aw paggawbuk adto.’ ");
INSERT INTO kqe_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Tyomobag yang anak nan, ‘Di ako adto.’ Awgaid pagkatugun-tugun, yamaisab yang dumduman nan aw kadto da yan sang tanumanan antak maggawbuk. ");
INSERT INTO kqe_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ansinyan kyomadto da oman yang ama sang mangod aw magonawa sinyan yang pyaglaongan kanan. ‘Ud, makadto ako,’ tyomobag yang anak nan na mangod. Awgaid wa yan akadto. ");
INSERT INTO kqe_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Na, bain kamayo, sino sang dowa yang yamangagad sang sogo ng ama nilan?” Tyomobag silan, “Yang magowang.” Yagalaong oman si Isa, “Sang bunna-bunna pagalaong ko kamayo na yang mga mangobraay ng bowis aw yang mga bobay na yagakadopang, yamaona pa silan kamayo pagsuud sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay yakani kamayo si Yahiya antak indowan nan kamo sang matorid na daan, awgaid wa kamo apangintoo kanan. Awgaid yang mga mangobraay ng bowis aw yang mga bobay na yagakadopang, yamangintoo silan kanan. Awgaid kamo, maskin kikita da mayo na yamangintoo silan, wa akaisab yang dumduman mayo aw wa oman kamo apangintoo kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yagalaong oman si Isa, “Paningug kamo kay aon pay isa na pasombingay. Aon otaw na tagtomon ng lopa na pyagatanuman nan ng grips. Pyapakoral nan inyan aw yagapainang yan ng pagapugaan ng grips aw yagapatokod pa yan ng makagwas na baay antak mabantayan yang tanumanan. Ansinyan pyapaatiman nan yang kanan tanumanan sang mga sinarigan aw pyomanaw adto sang mawat na banwa. ");
INSERT INTO kqe_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na, pagdatung ng wakto na magaipo da silan ng grips, syosogo nan yang mga sogowanun nan adto sang mga sinarigan antak kamangun nilan yang kanan bain ng abot. ");
INSERT INTO kqe_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Awgaid pagdatung ng mga sogowanun adto sang tanumanan, pyapandakup silan nidtong mga sinarigan. Yang sambok byobonalan nilan, yang sambok pyapatay nilan, aw yang sambok oman pyapambono nilan ng bato. ");
INSERT INTO kqe_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ansinyan syosogo da oman ng tagtomon yang kadaigan pa na sogowanun na mas madaig pa kaysang pirmiro. Awgaid yan da oman yang ininang kanilan nidtong mga sinarigan. ");
INSERT INTO kqe_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sang kataposan, syosogo nan yang kanan anak kay yagalaong yan sang ginawa nan, ‘Sang way dowa-dowa addatan nilan yang kanak anak.’ ");
INSERT INTO kqe_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amangkun sining tanumanan. Anda, apatayun ta yan antak kanatun da yang kabilin kanan.’ ");
INSERT INTO kqe_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Idto sagaw, dyadakup nilan yan aw daa nilan adto sa logwa ng tanumanan aw pataya nilan. ");
INSERT INTO kqe_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na adon,” laong ni Isa, “pagdatung ng tagtomon ng tanumanan, ono yang inangun nan sidtong mga sinarigan?” ");
INSERT INTO kqe_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tyomobag silan, “Sang way dowa-dowa apatayun nan idtong maat na mga otaw aw apaatiman nan yang kanan tanumanan sang kadaigan pa na mga otaw na magaatag kanan ng kanan bain ng bonga sang panahon ng pagpangipo.” ");
INSERT INTO kqe_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ansinyan yagalaong si Isa kanilan, “Wa kadi mayo akabasa yang yamakasorat sang Kitab na yagalaong, “ ‘Yang bato na titimbag ng mga panday kay way kono kapantag, yamainang kadi ng labi na barapantag. Yan yang ininang ng Tohan aw bali yan na katingaan.’ ");
INSERT INTO kqe_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Agaw sagaw pagalaong ko kamayo,” laong oman ni Isa, “kamo na mga Yahodi, di da kamo ng sakop ng Tohan awgaid yang amainang adon na sakop nan yang kadaigan pa na mga bangsa na amangagad kanan ng iklas. ");
INSERT INTO kqe_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sino-sino yang amalogso sidto na bato, amatomba aw ansinyan waa day poos yang kinabowi nan. Awgaid madatung yang wakto na amaoog da yang idto na bato aw sino-sino yang akaoogan sinyan, di da gaid akatabangan.” ");
INSERT INTO kqe_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na, pagdungug sinyan ng mga pangoo ng mga imam aw yang mga Parisi, kyakatigaman nilan na silan yang kyukugdan ni Isa sinyan na pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Agaw sa adakupun da gao nilan si Isa, awgaid yamalluk silan sang mga otaw kay yamangintoo silan na sambok yan na nabi. ");
INSERT INTO kqe_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ansinyan yagaindo da oman si Isa sang mga otaw pinaagi sang mga pasombingay, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yang pagdato ng Tohan magonawa sang sambok na soltan na yagaandam ng pakaradyaan para sang kawin ng kanan anak na usug. ");
INSERT INTO kqe_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nang yandam da yang kariko, syosogo nan yang kanan mga sogowanun adto sang mga imbitado antak silan magtambong sang pakaradyaan. Awgaid wa silan akallini tomambong. ");
INSERT INTO kqe_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Agaw, syosogo da oman ng soltan yang kadaigan pa na mga sogowanun aw yagalaong yan kanilan, ‘Paglaonga mayo yang mga imbitado na yandam da yang kandori. Syosobari da ko yang mga baka kipat sang mataba na mga nati ng baka aw yamaloto da yang kariko. Agaw pakania da silan sang pakaradyaan.’ ");
INSERT INTO kqe_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Awgaid yang mga imbitado wa magapaningug. Yang sambok kyomadto sang kanan pawa, aw yang sambok oman adto sang kanan tindaan. ");
INSERT INTO kqe_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yang kadaigan oman, dyadakup nilan yang mga sogowanun ng soltan, syasakitan aw pyapatay nilan. ");
INSERT INTO kqe_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Idto sagaw bali na kadaman ng soltan. Syosogo nan yang mga sondao nan na apatayun nilan idtong mga yagapatay sang mga sogowanun nan aw sonogon nilan yang kanilan syodad. ");
INSERT INTO kqe_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatapos sinyan pyapatawag nan yang mga sogowanun nan aw paglaonga nan, ‘Yandam da yang pakaradyaan, awgaid yang mga otaw na pyagaimbitar ko dili dait magtambong sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Agaw kadto kamo sang mga daan na madaig yang mga otaw aw pakania sang pakaradyaan yang maskin sino na ikitaun mayo.’ ");
INSERT INTO kqe_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ansinyan kyomadto da yang mga sogowanun adto sang mga daan aw dyadaa nilan yang kariko ng mga otaw na kikita nilan, mga madyaw aw maat. Agaw sagaw yamapono da ng mga bisita yang baay daw wain yang pakaradyaan ng kawin. ");
INSERT INTO kqe_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Adon, pagsuud ng soltan kay atanawon nan yang mga bisita, aon kikita nan na sambok na usug na wa magapandagom para sang pakaradyaan. ");
INSERT INTO kqe_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ansinyan yagalaong yang soltan, ‘Kay Itin, monono yang pagsuud mo adi na wa kaw magapandagom para sang pakaradyaan?’ Awgaid wa otobag yang inyan na otaw. ");
INSERT INTO kqe_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ansinyan syosogo ng soltan yang mga sogowanun nan aw laong nan, ‘Gaposa mayo yang arima aw siki nan aw timbagan mayo adto sa logwa sang kaduguuman. Adto da yan magtiyao aw mangoyagut yang onto nan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ansinyan yagalaong oman si Isa, “Madaig yang mga otaw na pyagaimbitar ng Tohan adto sang pyagadatowan nan, awgaid tagbi da yang pipili nan antak makasuud.” ");
INSERT INTO kqe_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Adon pyomanaw da yang mga Parisi aw yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa sang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ansinyan pyapakadto nilan kang Isa yang pilangka otaw na mga inindowan nilan aw yang mga otaw ni Soltan Hirod. Pagdatung nilan kang Isa, yagalaong silan kanan, “Kay Goro, yamatigam kami na mapoti yang pangatayan mo aw aag bunna yang pyagaindo mo makapantag sang karim ng Tohan. Di mo apangagadan yang dumduman ng mga otaw kay di kaw magapili sang otaw na maskin ono yang ranggo nilan. ");
INSERT INTO kqe_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Adon, paglaonga kami daw ono yang dumduman mo makapantag sini. Sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sang Roma atawa dili?” ");
INSERT INTO kqe_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Awgaid kyakatigaman ni Isa na maat yang toyo nilan, agaw yagalaong yan, “Kamo na yagapakita-kita gaid! Nanga sa karim mayo ako dakupun sang pyaglaongan ko? ");
INSERT INTO kqe_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakitaan kanak yang sapi na pagabayad mayo ng bowis.” Ansinyan yatag nilan kanan yang sambok na sapi na pilak. ");
INSERT INTO kqe_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Adon yosip silan ni Isa, “Kanino parangay aw ngaan yang yakabutang sini?” ");
INSERT INTO kqe_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Kanang soltan sang Roma,” yang tobag nilan. Ansinyan yagalaong si Isa, “Na, kong maynan, atag mayo sang soltan yang kanang soltan, aw atag oman mayo sang Tohan yang kanang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagdungug nilan sinyan, bali na pagkatingaa nilan aw pyapanawan da nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sinyan na allaw aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. ");
INSERT INTO kqe_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yagaosip silan kang Isa, “Kay Goro, yagalaong si Nabi Mosa sang Hokoman na kong amatay yang usug ng way anak sang kanan asawa, dait na apangasawaun ng lomon nan yan na biyoda antak kaonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqe_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Adon, aon adi kanami pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. Agaw, pyapangasawa da ng mangod na yagasonod kanan idtong biyoda. ");
INSERT INTO kqe_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Awgaid yamatay da oman yan na lomon na way anak. Maynan oman yang ikatoo taman sang ikapito. ");
INSERT INTO kqe_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqe_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Adon, sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay kay yang kariko ng pito na maglomon yakapangasawa kanan?” ");
INSERT INTO kqe_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tyomobag si Isa aw laong nan kanilan, “Sayup yang dumduman mayo kay wa kamo makasabot sang yamakasorat sang Kitab aw wa oman mayo akatigami yang kabarakat ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kay kong amabowi oman yang mga patay, di da silan amangasawa atawa magabana kay magonawa da silan sang mga malaikat adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, makapantag sang pagkabowi oman ng mga patay, wa kadi mayo akabasa yang pyaglaongan kamayo ng Tohan? Kay yagalaong yan, ");
INSERT INTO kqe_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ako yang Tohan na syasambayangan ni Ibrahim, ni Isahak aw ni Yakob.’ Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay.” ");
INSERT INTO kqe_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagdungug sinyan ng mga otaw, yamangkatingaa silan sang pyagaindo nan. ");
INSERT INTO kqe_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagdungug ng mga Parisi na wa da makatobag kang Isa yang mga Sadoki, yanagkatipon silan adto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yang sambok kanilan alim ng Hokoman ng Tohan. Yagaosip yan kang Isa antak magtigi kanan, ");
INSERT INTO kqe_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","laong nan, “Kay Goro, wain na sogowan sang Hokoman yang labaw sang kariko?” ");
INSERT INTO kqe_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tyomobag si Isa, “ ‘Kaluguni yang Tohan na kanmo Tagallang sang tibok mo na pangatayan, sang tibok mo na kallowa aw sang tibok mo na dumduman.’ ");
INSERT INTO kqe_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yani yang sogowan na labaw sang kariko. ");
INSERT INTO kqe_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Magonawa sinyan, dakowa oman yang ikadowa na sogowan, ‘Kaluguni yang kapagonawa mo magonawa sang lugun mo sang ginawa mo.’ ");
INSERT INTO kqe_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yang kariko ng Hokoman na yatag ng Tohan kang Nabi Mosa aw yang kariko ng pyagaindo ng mga nabi yamakalasak sining dowambok na sogowan.” ");
INSERT INTO kqe_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sarta yanagkatipon pa ansan yang mga Parisi, yagaosip kanilan si Isa, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ono yang kamayo dumduman makapantag sang Almasi? Kanino topo yan?” Tyomobag silan, “Topo yan ni Soltan Daud.” ");
INSERT INTO kqe_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Na, kong maynan,” laong ni Isa, “nanga sa yagalaong si Soltan Daud na yang Almasi yang kanan Dato? Kay idto yang pyaglaongan nan sang wakto na pyagabuutan yan ng Nyawa ng Tohan, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Yagalaong yang Tohan sang kanak Dato, “Pagingkod adi sang karinto ko sampay na ataloon ko yang mga kalaban mo aw amainang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqe_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, kong tyatawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” ");
INSERT INTO kqe_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na, way maskin isa kanilan na yamakatobag sinyan. Aw sikun sinyan na allaw waa day yamangisug magosip pa kanan. ");
INSERT INTO kqe_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ansinyan yagalaong si Isa sang mga otaw kipat sang mga inindowan nan, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yang mga magiindoway ng Hokoman aw yang mga Parisi, aon kapatot nilan pagobad sang Hokoman ni Nabi Mosa. ");
INSERT INTO kqe_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Agaw pangagadi mayo yang kariko ng pyagaindo nilan kamayo. Awgaid ayaw mayo pagsonoda yang ininang nilan kay wa nilan inanga yang pyagaindo nilan. ");
INSERT INTO kqe_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pyapapusan nilan yang mga otaw ng mabugat na magonawa ng mga sogowan na mairap tomanun, awgaid di silan matabang kanilan ng maskin tagbis. ");
INSERT INTO kqe_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yang kariko ng ininang nilan, ininang gaid nilan antak silan kitaun ng mga otaw. Tanawa mayo yang kadakowa ng lasakanan ng mga ayatan sikun sang Kitab na byubutang nilan sang guya aw sang mga buktun nilan. Tanawa oman mayo yang kataas ng mga sinolid na bibitay nilan sang sidsid ng dagom nilan. ");
INSERT INTO kqe_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sang mga kandori, kallini nilan magingkod sang ingkodanan ng mga otaw na dait addatan. Aw adto sang pagsasambayangan, karim nilan magingkod sang ingkodanan ng dakowa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Adto sang palengke, kallini nilan na asalamun silan ng mga otaw aw pagtawagun silan na ‘Goro.’ ");
INSERT INTO kqe_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Awgaid di kamo dait pagtawagun na ‘Goro’ kay obos kamo maglomon aw sambok da yang kamayo goro. ");
INSERT INTO kqe_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aw ayaw kamo magtawag na ‘Ama’ sang maskin sino adi sang donya kay sambok da yang Ama mayo na adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Di oman kamo dait pagtawagun na ‘Pangoo’ kay sambok da yang kamayo pangoo aw yan yang Almasi. ");
INSERT INTO kqe_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Daw sino yang labaw kamayo, dait yan mainang ng sogowanun mayo. ");
INSERT INTO kqe_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kay sino-sino yang magapataas sang ginawa nan, apababaun, aw sino-sino yang magapababa sang ginawa nan, apataasun. ");
INSERT INTO kqe_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Pyagalupunan mayo yang daan antak yang mga otaw di makasuud sang pyagadatowan ng Tohan. Kamo mismo di marim magpasakop sang pagdato nan aw yagababag pa kamo sang mga otaw na marim gao magpasakop. ");
INSERT INTO kqe_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Pyapasikotan mayo yang mga biyoda antak maagaw mayo yang kakawasaan nilan. Aw pyapataas mayo yang pagdowaa mayo sang atobangan ng mga otaw antak magpakita kamo na madyaw kamo na mga otaw. Na, labi da yang siksa kamayo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Mataripag kamo sang dagat aw makadto kamo sang tuna na mga banwa antak madaa mayo yang maskin sangka otaw gaid na dili ng Yahodi sang pagpangintoo mayo. Pagkatapos, kong aon day yamangagad kamayo, na, sabap sang pagindo mayo kanan mallabi pa yang kaatan nan kay kamayo aw labaw pa kamayo yang siksa kanan adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Labi na maat yang adatungan mayo kay main kamo ng mga bota na yagagabay sang kadaigan! Yagaindo kamo na kong magapasad yang otaw aw pagasaksi nan yang Baay ng Tohan, mapakay na maskin di da nan otomanun yang pasad nan. Awgaid kong magapasad yang otaw aw pagasaksi nan yang bowawan na adto sa suud ng Baay ng Tohan, di mapakay na abarobaun nan yang pasad nan. ");
INSERT INTO kqe_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Astaga! Mga bota aw mga sangu kamo! Wain yang labi na barapantag, yang bowawan atawa yang Baay ng Tohan na yagapasotti sang bowawan? ");
INSERT INTO kqe_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yagaindo oman kamo na kong magapasad yang otaw aw pagasaksi nan yang pagsosonogan ng korban, mapakay na di da nan otomanun yang pasad nan. Awgaid kong magapasad yang otaw aw pagasaksi nan yang korban sa babaw ng pagsosonogan, di mapakay na abarobaun nan yang pasad nan. ");
INSERT INTO kqe_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga bota sagaw kamo! Wain yang labi na barapantag, yang korban atawa yang pagsosonogan na yagapasotti sang korban? ");
INSERT INTO kqe_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na idto, kong magapasad yang otaw aw pagasaksi nan yang pagsosonogan ng korban, apil sinyan yang kariko na adto sa babaw ng pagsosonogan. ");
INSERT INTO kqe_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aw kong magapasad yang otaw aw pagasaksi nan yang Baay ng Tohan, apil sinyan yang Tohan na yagauya sinyan na baay. ");
INSERT INTO kqe_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kong magapasad yang otaw aw pagasaksi nan yang sorga, apil sinyan yang ingkodanan ng Tohan kipat oman sang Tohan na yagaingkod sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Yagajakat kamo ng ikasampoo na bain maskin dakman ng anag mayo na magonawa ng paminta, bawang aw pandan. Awgaid yang labi na barapantag na mga sogowan ng Hokoman wa mayo otomana na magonawa ng paginang ng matorid, na dait magkalooy sang kapagonawa aw dait na kasarigan kamo na mga otaw. Na, yani silan yang dait mayo tomanun, awgaid ayaw oman mayo pagpasagdi yang kadaigan pa na mga sogowan. ");
INSERT INTO kqe_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Astaga! Mga bota kamo na yagagabay sang kadaigan! Kay yang ininang mayo magonawa sang ininang ng otaw na yagasaa ng tobig na inumun nan antak makamang yang niknik. Awgaid yang dakowa na ayup na magonawa ng kamil, otoonon nan. ");
INSERT INTO kqe_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Pyagalinisan mayo yang logwa gaid ng kamayo tasa aw plato, awgaid yang pangatayan mayo yamapono ng pagkatokgawan aw pagpangilad sang kapagonawa mayo. ");
INSERT INTO kqe_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamo na mga Parisi, mga bota kamo! Dait na linisan mayo ona yang pangatayan mayo, aw ansinyan madyaw oman yang batasan mayo. ");
INSERT INTO kqe_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Magonawa kamo sang kobor na pipintoraan ng mapoti. Madyaw yan tanawon, awgaid adto sa suud madaig yang mga pusa ng patay aw yang mangkaripa na mga butang. ");
INSERT INTO kqe_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Magonawa sinyan, maynang matorid kamo sang pagtanaw ng mga otaw, awgaid sang kabunnaan maat yang lasak ng pangatayan mayo. ");
INSERT INTO kqe_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Labi na maat yang adatungan mayo na mga magiindoway ng Hokoman aw mga Parisi kay yagapakita-kita gaid kamo na yamangagad kamo sang Tohan! Yagainang kamo ng tadumanan ansang kobor ng mga nabi aw pyapakadyaw mayo yang mga kobor ng matorid na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aw yagalaong kamo, ‘Aw yamabowi kami sang panahon ng kanami kaompowan, di kami magupud sang maat na ininang nilan na pyapatay nilan yang mga nabi.’ ");
INSERT INTO kqe_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sabap sining pyaglaongan mayo pyapakatigam mayo na topo kamo sidtong mga otaw na yagapatay sang mga nabi. ");
INSERT INTO kqe_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, taposa da gaid mayo yang dosa na pyagasogdan ng kaompowan mayo! ");
INSERT INTO kqe_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mga limbongon kamo! Yagadumdum ba kamo na makalikay kamo sang hokom ng Tohan na isiksaun kamo adto sang narka? Dili! ");
INSERT INTO kqe_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kay pagalaong ko kamayo na apadaan ta kamo ng mga nabi, mga otaw na maum yang katigam aw mga magiindoway ng pyaglaongan ng Tohan. Na, yang kadaigan kanilan apatayun mayo aw yang kadaigan alansang mayo sang kros. Aw yang kadaigan oman apabadasan mayo adto sang mga pagsasambayangan mayo aw olopogon aw apasikotan mayo silan maskin makain silan kadto. ");
INSERT INTO kqe_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na, sabap sinyan kamo da yang adatungan ng siksa sang pagpatay sang kariko ng matorid na mga otaw adi sang babawan ng donya sikun pa sang pagpatay kang Habil na matorid na otaw sampay sang pagpatay kang Sakariyas na anak ni Baraki na pyapatay mayo na mga Yahodi adto sang tunga ng Baay ng Tohan aw yang pagsosonogan ng korban. ");
INSERT INTO kqe_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sang bunna-bunna pagalaong ko kamayo na yang siksa sang kariko sinyan madatung sang mga otaw adon na panahon. ");
INSERT INTO kqe_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O mga taga Awrosalam! Kallat mayo kay pyapatay mayo yang mga nabi aw byabato mayo yang mga otaw na syosogo ng Tohan adto kamayo. Makapila da ako magpakita kamayo na karim ta kamo tiponon aw atimanun magonawa sang osoyan na olooban nan yang mga osoy nan. Awgaid wa kamo akallini! ");
INSERT INTO kqe_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na, apabayaan da kamo ng Tohan aw sang orian waa day magauya sang banwa mayo. ");
INSERT INTO kqe_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pagalaong ko kamayo na di da mayo ako ikitaun taman sang wakto na mabarik oman ako aw magalaong da kamo, ‘Atagan gao ng kadyawan yaning syosogo ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ansinyan lyomogwa da si Isa sikun sang Baay ng Tohan. Aw sarta yagapanaw yan dyomood kanan yang mga inindowan nan aw yagabaaw silan kanan makapantag sang kadyaw ng paginang sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Awgaid yagalaong kanilan si Isa, “Madyaw sagaw tanawon yang kariko sinyan. Awgaid bunna yang pagalaong ko kamayo na madatung yang allaw na way maskin sambok na bato na amabilin sang kyakabutangan nan kay obos silan apakaya-kaya.” ");
INSERT INTO kqe_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wa akadogay disinyan sarta yagaingkod si Isa adto sang Butay ng Jayton, dyomood kanan yang mga inindowan nan aw nang silan da gaid yagalaong silan, “Paglaonga kami daw kinno pa matoman yaning pyaglaongan mo aw ono yang tanda na magapakatigam kanami na mallug da kaw bomarik adi sang donya aw mallug da domatung yang kataposan ng donya.” ");
INSERT INTO kqe_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tyomobag si Isa, laong nan, “Pagbantay kamo antak di kamo kalimbongan ng maskin sino. ");
INSERT INTO kqe_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kay madaig yang mga otaw na madatung sang kanak ngaan aw magalaong silan na, ‘Ako yang Almasi,’ aw madaig yang akalimbongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amadungug mayo na aon mga gira sang masaid kamayo aw adto oman sang mawat na mga banwa. Awgaid ayaw kamo magkalluk kay dait na amaitabo yang kariko sinyan awgaid dili pa yani yang kataposan ng donya. ");
INSERT INTO kqe_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagadatowan mapaglaban adto sang kadaigan. Aw amaon yang gutum aw mga linog sang yagakatuna-tuna na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Awgaid yang kariko sinyan pagsogod pa gaid ng kasikotan na magonawa sang pagbati ng sambok na bobay sang pagpanganak. ");
INSERT INTO kqe_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ansinyan apandakupun aw adaun kamo adto sang mga pangoo antak kastigoon aw patayun kamo. Aw odumtan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqe_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sinyan na wakto madaig yang mga otaw na magatarikod sang pagpangintoo nilan kanak. Odumtan aw pagatraydoran nilan yang mga kaupdanan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aw madaig yang mga otaw na magalaong na mga nabi kono silan aw madaig yang akalimbongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na, sabap ng labi da yang pagsopak ng mga otaw sang mga sogowan ng Tohan, waa day looy ng kadaigan sang kapagonawa nilan. ");
INSERT INTO kqe_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Awgaid sino-sino yang magapadayon sang pagpangintoo nan kanak sampay sang kataposan sini na mga kasikotan, amalowas. ");
INSERT INTO kqe_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aw yang Madyaw na Gogodanun makapantag sang pagdato ng Tohan apayapat sang tibok donya antak yang kariko ng mga bangsa matigam. Pagkatapos sinyan madatung yang kataposan ng donya. ");
INSERT INTO kqe_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na, sang madatung na mga allaw makita mayo na aon yakabutang adto sang sotti na logar na haram na makabatar sang Baay ng Tohan. Ingidto yang pyagatagna ni Nabi Daniyal sangaon. Aw sino-sino yang magabasa sini, sabta mayo yang mana sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na, pagkita mayo sinyan, yang mga otaw na adto sang Yahodiya, dait silan domaagan adto sang kabtayan. ");
INSERT INTO kqe_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yang otaw na adto sa logwa ng kanan baay, di dait somuud antak makamang pa sang maskin ono na butang nan. ");
INSERT INTO kqe_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aw yang otaw na adto sang pawa, di dait mori antak makamang pa ng dagom nan. ");
INSERT INTO kqe_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pagdatung sinyan na mga allaw, kallat sidtong mga mabdus aw sidtong mga yagapasoso kay mairapan silan domaagan. ");
INSERT INTO kqe_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Agaw, pagpangayo-ayo kamo adto sang Tohan na di gao yan amainang sang wakto ng tingtignaw atawa sang Allaw ng Pagpatana. ");
INSERT INTO kqe_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kay sinyan na mga allaw labi da yang kasikotan na agian ng mga otaw. Sikun pa sang pagbaoy ng donya sampay adon waa pay main da nan na kasikotan, aw pagkatapos sinyan di da oman amainang yang magonawa sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na, kong madogay yang inyan na kasikotan, amatay da yang kariko ng mga otaw. Awgaid sabap sang looy ng Tohan sang mga otaw na pipili nan, di nan apadogayun. ");
INSERT INTO kqe_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na, sinyan na mga allaw, kong aon magalaong kamayo na, ‘Tanawa idi da yang Almasi,’ atawa ‘Adto sidto yan,’ ayaw kamo magtoo kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kay aon madatung na mga otaw na magalaong na silan kono yang Almasi. Aw aon oman mga otaw na magalaong na mga nabi kono silan, awgaid dili yan ng bunna. Magainang silan ng maskin ono na tanda aw katingaan kay antak kong mapakay mailad maskin yang mga pipili ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, timani mayo na pyagalaong da ta kamo sinyan sang wa pa yan akainang. ");
INSERT INTO kqe_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Agaw, kong aon magalaong kamayo na, ‘Tanawa, adto yang Almasi sang mamingaw na banwa,’ ayaw kamo magkadto. Aw kong magalaong silan na, ‘Yagatago yan adi sa suud,’ ayaw oman kamo magtoo sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kay kong mabarik ako na Anak ng Manosiya adi sang donya, makita yang pagdatung ko na magonawa sang kilat na yagasiga adto sang langit sikun sang silatan taman sang sallupan. ");
INSERT INTO kqe_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Magonawa yan sang pasombingay na yagalaong, ‘Daw wain yang patay, adto magatipon yang mga banog.’ ");
INSERT INTO kqe_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na, pagkatapos sinyan na mga allaw ng kasikotan, “‘magakaduguum yang suga aw di da magasiga yang bowan. Mangaoog yang mga bitoon sikun sang langit aw yang kariko na adto sang langit amagayung.’ ");
INSERT INTO kqe_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ansinyan amaon adto sang langit yang tanda na madatung da ako na Anak ng Manosiya. Aw yang kariko ng mga bangsa adi sang donya magatiyao kong kitaun nilan ako na Anak ng Manosiya sikun sang mga gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqe_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aw ansinyan sang makusug na pagpaoni ng trompita osogoon ko yang kanak mga malaikat sang opat ka pinidyowan ng donya antak tiponon nilan yang mga otaw na pipili ko sikun sang kariko ng mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, dumduma mayo yang kaoy na igira. Aw yamanaringsing da yang mga sanga sinyan na kaoy, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqe_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Magonawa sinyan, pagkita mayo na amainang da yang kariko sining pyagalaong ko kamayo, akatigaman mayo na mallug da ako magbarik adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sang bunna-bunna pagalaong ko kamayo na amatoman yang kariko sinyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqe_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Awgaid way otaw na yamatigam daw ono na allaw atawa ono na wakto ako mabarik. Maskin yang mga malaikat adto sang sorga aw maskin oman ako na Anak ng Tohan, wa akatigam. Yang Tohan da gaid na kanak Ama yang yamatigam sinyan. ");
INSERT INTO kqe_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na, yang ininang ng mga otaw sidtong wakto na mabarik ako na Anak ng Manosiya adi sang donya magonawa sang ininang ng mga otaw sangaon sang panahon ni Nabi Noh. ");
INSERT INTO kqe_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kay sang wa pa magalunup adi sang donya, way lain na kyakaridowan ng mga otaw yatabiya yang pagkan, paginum aw paginasawaay taman sidtong wakto na yosuud si Nabi Noh sang dakowa na bangka. ");
INSERT INTO kqe_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na, wa silan akatigam na mallug da silan asapadan. Agaw pagdatung ng lunup, obos silan yamangkalumus. Na, magonawa sinyan yang kabutang ng mga otaw sang wakto na mabarik ako na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sidto na wakto, kong aon dowangka usug na yagagawbuk adto sang pawa, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqe_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kong aon dowangka bobay na yagalubuk ng omay, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqe_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Idto sagaw, pagbantay kamo kay wa mayo akatigami daw ono na allaw yang pagbarik ng kamayo Dato. ");
INSERT INTO kqe_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Awgaid dumduma mayo yani. Kong kyakatigaman ng tagtomon ng baay daw ono na wakto ng gabi yang pagdatung ng kawatan, sang way dowa-dowa di yan matoog kondi magabantay yan antak yang kawatan di makasuud sang baay nan. ");
INSERT INTO kqe_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Agaw sagaw, dait kamo magandam kay mabarik ako na Anak ng Manosiya sang wakto na wa kamo magadumdum na mabarik ako.” ");
INSERT INTO kqe_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ansinyan yagalaong si Isa sini na pasombingay, laong nan, “Yang sogowanun na kasarigan aw matigam maggawbuk, yan yang ipiliun ng amo nan antak magdaa sang kadaigan pa na mga sogowanun sang baay. Aw yan da yang magaatag kanilan ng kanilan pagkan sang insakto na wakto. ");
INSERT INTO kqe_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kadyaw ng ginawa sidtong sogowanun aw pagori ng amo nan adatungan yan na yagainang ng kanan gawbuk. ");
INSERT INTO kqe_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sang bunna-bunna pagalaong ko kamayo na asarig da kanan ng amo nan yang kariko ng mga kabtangan nan. ");
INSERT INTO kqe_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Awgaid kong maat yang idto na sogowanun, magalaong yan sang ginawa nan, ‘Ah, madogay pa mori yang amo ko!’ ");
INSERT INTO kqe_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tapos okolataun da nan yang mga kaupdanan nan na sogowanun aw abay gaid yan koman aw minum upud sang mga lasing. ");
INSERT INTO kqe_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na, ansinyan omori da yang amo nan sang wakto na wa nan akaniyat kay wa nan akatigami daw ono na allaw yang pagbarik nan. ");
INSERT INTO kqe_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ansinyan kastigoon da yan ng amo nan aw adto da yan obutang sang adatungan ng mga otaw na yagapakita-kita gaid na yamangagad silan sang Tohan. Adto da yan magtiyao aw mangoyagut yang onto nan.” ");
INSERT INTO kqe_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ansinyan yagalaong oman si Isa ng tuna pa na pasombingay, laong nan, “Sang wakto ng pagbarik ko, yang pagdato ng Tohan magonawa sang sampoo na mga daaga na pyomanaw antak songonon nilan yang usug na akawinun. Yang matag-isa kanilan aon daa na ilawan. ");
INSERT INTO kqe_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na, sangu yang limangka otaw kanilan aw mangkatigam yang kadaigan na limangka otaw. ");
INSERT INTO kqe_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kay yang mga sangu yagadaa ng ilawan, awgaid wa silan magadaa ng dogang pa na lana. ");
INSERT INTO kqe_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Awgaid idtong mangkatigam, yagadaa silan ng ilawan kipat sang lasakanan na yamapono ng lana. ");
INSERT INTO kqe_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Adon, sabap ng yamadogay yang pagdatung ng usug na akawinun yamatodtod da yang mga daaga aw yamangkatoog. ");
INSERT INTO kqe_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ansinyan pagkatungang gabi da aon yamangiyak, laong nan, ‘Idi da yang usug na akawinun! Adi da kamo aw songona mayo!’ ");
INSERT INTO kqe_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Pagdungug sinyan yagabangon dayon idtong mga daaga aw dyadayaw nilan yang siga ng ilawan nilan. ");
INSERT INTO kqe_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Adon, idtong mga sangu, yagalaong silan adto sang mga mangkatigam, ‘Atagi kami ng tagbis na lana mayo kay mallug da matay yang ilawan nami.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Awgaid tyomobag idtong mga mangkatigam, ‘Di mapakay! Kay kong atagan ta kamo, magonawa da kita na okolangan ng lana. Madyaw pa aw magabili da gaid kamo ng lana adto sang tindaan.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ansinyan pyomanaw da idtong mga daaga na sangu antak magbili ng lana. Pagpanaw nilan, dyomatung da yang usug na akawinun. Aw idtong limangka otaw na daaga na yamangandam yamagad kanan adto sang baay daw wain yang pakaradyaan ng kawin. Pagsuud nilan sang baay, sisiraan da yang powertaan. ");
INSERT INTO kqe_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wa akadogay disinyan dyomatung da idtong kadaigan na mga daaga na yagabili ng lana aw yanagtawag silan, laong nilan, ‘Kay Dato, pasuuda kami.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Awgaid tyomobag yang usug, ‘Sang bunna-bunna, wa ako ikilaa kamayo.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Agaw sagaw,” yagalaong si Isa, “pagbantay kamo kay wa mayo akatigami yang allaw atawa wakto ng pagbarik ko.” ");
INSERT INTO kqe_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yagalaong oman si Isa, “Yang pagdato ng Tohan magonawa sang sambok na otaw na mallug da pomanaw sang mawat na banwa. Tyatawag nan yang kanan mga sogowanun aw syasarigan nan silan sang kakawasaan nan. ");
INSERT INTO kqe_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pyapangatagan nan yang matag-isa kanilan ng sapi na dait sang kanilan kagaga. Yang sangka otaw yatagan nan ng 5,000, yang sangka otaw oman ng 2,000, aw yang sangka otaw ng 1,000. Pagkatapos sinyan pyomanaw da yan. ");
INSERT INTO kqe_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, yang sogowanun na yatagan ng 5,000 pyomanaw dayon aw pyaganegosyo nan yang sapi aw yakaganansya ng 5,000. ");
INSERT INTO kqe_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Magonawa sinyan, yang sogowanun na yatagan ng 2,000, yakaganansya ng 2,000. ");
INSERT INTO kqe_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Awgaid yang sogowanun na yatagan ng 1,000 pyomanaw aw yagakotkot ng longag kay tagoon nan sang lopa yang sapi ng amo nan. ");
INSERT INTO kqe_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagkatapos ng mataas na panahon yomori da yang amo nilan aw yosip nan silan daw ono yang ininang nilan sang sapi na yatag nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na, yang sogowanun na yatagan ng 5,000 dyomood sang amo nan na yagadaa ng 5,000 na ganansya nan. Yagalaong yan, ‘Kay Dato, yang yatag mo kanak 5,000. Tanawa, aon pay tuna na 5,000 na kanak ganansya.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yagalaong yang amo nan, ‘Madyaw yang ininang mo! Madyaw aw kasarigan kaw na sogowanun. Sabap ng kasarigan kaw sang tagbis na kakawasaan, asarig ta kanmo yang madaig na kakawasaan. Karim ko na masowat kaw magonawa kanak.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Pagkatapos sinyan dyomood kanan yang sogowanun na yatagan ng 2,000 aw yagalaong yan, ‘Kay Dato, yatagan mo ako ng 2,000. Tanawa, aon pay tuna na 2,000 na kanak ganansya.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yagalaong yang amo nan, ‘Madyaw yang ininang mo! Madyaw aw kasarigan kaw na sogowanun. Sabap ng kasarigan kaw sang tagbis na kakawasaan, asarig ta kanmo yang madaig na kakawasaan. Karim ko na masowat kaw magonawa kanak.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ansinyan dyomatung yang sogowanun na yatagan ng 1,000 aw yagalaong yan, ‘Kay Dato, yamatigam ako na maisug kaw na otaw. Kay akamangun mo yang wa mo pagapagodi, aw aganiun mo yang wa mo atanuma. ");
INSERT INTO kqe_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Agaw, sabap ng yamalluk ako daw basin akawaan ako ng kanmo sapi, pyomanaw ako aw tyatago ko yang sapi mo sang lopa. Tanawa, idi kay yang kanmo sapi.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na, tyomobag yang amo nan, laong nan, ‘Way poos mo! Mataka kaw na sogowanun! Yamatigam kaw kadi na akamangun ko yang wa ko pagapagodi, aw aganiun ko yang wa ko atanuma? ");
INSERT INTO kqe_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, kong maynan, nanga sa wa mo ooga sang bangko yang kanak sapi kay antak pagbarik ko amakamang ko yang sapi ko na aon pay tobo?’ ");
INSERT INTO kqe_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ansinyan yagalaong yan sang kadaigan na mga sogowanun nan, ‘Kamanga mayo yang sapi na iyan kanan aw atagan sidtong sogowanun na aon 10,000. ");
INSERT INTO kqe_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kay sino-sino yang kasarigan atagan kay antak kadogangan pa yang iyan kanan. Awgaid yang otaw na dili kasarigan, maskin yang tagbis na iyan kanan, akamangun pa. ");
INSERT INTO kqe_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aw yani na sogowanun na way poos itimbag da mayo adto sa logwa sang kaduguuman. Adto da yan magtiyao aw mangoyagut yang onto nan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ansinyan yagalaong oman si Isa, laong nan, “Kong ako na Anak ng Manosiya mabarik da adi sang donya na yagadan ng kariko ng mga malaikat, amapayag yang dakowa na kabarakat aw kabantog ko. Kay mabarik ako adi antak magdato aw maghokom sang kariko ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na, ansinyan amatipon da sang atobangan ko yang kariko ng mga bangsa adi sang donya aw bainun ko yang mga otaw sang dowangka pondok na magonawa sang magbabantayay ng mga ayup na lainun nan yang mga karniro aw yang mga kambing. ");
INSERT INTO kqe_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yang mga otaw na yamangagad kanak obutang ko apit sang karinto ko, aw yang kadaigan obutang ko apit sang kawaa ko. ");
INSERT INTO kqe_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ansinyan magalaong da ako na soltan nilan adto sang mga otaw apit sang karinto ko, laong ko, ‘Adi da kamo kay aon kadyawan mayo sikun sang Tohan na kanak Ama. Tarimaa da mayo yang pyagadatowan na pyagakahanda kamayo sikun pa sang pagbaoy ng donya. ");
INSERT INTO kqe_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kay sang wakto na yamagutum ako, yatagan mayo ako ng pagkan aw sang wakto na yamalangga ako, pyapainum mayo ako. Aw pagkadto ko sang banwa mayo, pyapapanaos mayo ako adto sang baay mayo. ");
INSERT INTO kqe_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nang way dagom ko, yatagan mayo ako ng dagom. Nang yamasakit ako, yatiman mayo ako. Aw nang yamapiriso ako, bibisitaan mayo ako.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ansinyan magaosip yang matorid na mga otaw, laong nilan, ‘Kay Dato, akano pa kaw nami ikitaa na yamagutum aw pyapakan kaw nami atawa yamalangga aw pyapainum kaw nami? ");
INSERT INTO kqe_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Akano oman kaw nami ikitaa na yagabisita kanami aw pyapapanaos kaw nami? Atawa way dagom mo aw yatagan kaw nami ng dagom? ");
INSERT INTO kqe_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aw akano kaw nami ikitaa na yamasakit atawa yamapiriso aw bibisitaan kaw nami?’ ");
INSERT INTO kqe_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ansinyan motobag ako na soltan nilan aw magalaong ako kanilan, ‘Sang bunna-bunna pagalaong ko kamayo daw ono yang ininang mayo sang mga otaw na yamangagad kanak na maskin way tiyap nilan, maynang ininang da mayo yan kanak.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagkatapos, magalaong da oman ako sang mga otaw apit sang kawaa ko, ‘Panawi mayo ako kay sisiksa da kamo ng Tohan. Adto da kamo obutang sang narka, sang atoon na di amatay taman sa taman na pyagakahanda kang Iblis aw yang sakop nan na mga saytan. ");
INSERT INTO kqe_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay sang wakto na yamagutum ako, wa mayo ako apakana. Nang yamalangga ako, wa mayo ako apainuma. ");
INSERT INTO kqe_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pagkadto ko sang banwa mayo, wa mayo ako apapanaosa. Nang way dagom ko, wa mayo ako apapandagomi. Nang yamasakit aw yamapiriso ako, wa mayo ako ibisitai.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ansinyan magaosip silan kanak, ‘Kay Dato, akano pa kaw nami ikitaa na yamagutum atawa yamalangga? Akano pa na wa kaw apapanaosa sang kanami baay atawa way dagom mo? Akano pa na yamasakit atawa yamapiriso kaw aw wa kaw nami atabangi?’ ");
INSERT INTO kqe_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ansinyan motobag ako kanilan, ‘Sang bunna-bunna pagalaong ko kamayo na sang wa mayo atabangi yang pinakababa sang mga inindowan ko, maynang wa oman mayo ako atabangi.’ ");
INSERT INTO kqe_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na, yani na mga otaw, apakadtoon silan adto sang narka aw adto da silan siksaun taman sa taman. Awgaid idtong matorid na mga otaw, amasorga silan aw atagan silan ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos ni Isa magindo sang kariko sinyan, yagalaong yan sang mga inindowan nan, ");
INSERT INTO kqe_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kyakatigaman mayo na dowang allaw dakman aw madatung da yang Pakaradyaan ng Paglabay. Sinyan na wakto adakupun da ako na Anak ng Manosiya antak alansang adto sang kros.” ");
INSERT INTO kqe_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, sarta yagalaong si Isa sinyan, yanagkatipon yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi adto sang baay ni Kayapas na yan yang Dakowa na Imam. ");
INSERT INTO kqe_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa na di akatigaman ng mga otaw aw monono yang pagpatay kanan. ");
INSERT INTO kqe_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yagalaong silan, “Di gaid natun yani inangun sang wakto ng pakaradyaan kay basin magakasamok yang mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ansinyan sarta adto sang longsod ng Bitani silan Isa, kyomadto silan sang baay ni Simon, yang otaw na sanglaun sangaon. ");
INSERT INTO kqe_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nang yanagkan silan, aon dyomatung na bobay na yagadaa ng tagbi na lasakanan na ininang ng bato na alabastro na yamapono ng paballo na labi na mahalaga. Ansinyan dyomood yan kang Isa aw obowi nan ng paballo yang oo nan. ");
INSERT INTO kqe_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkita sinyan ng mga inindowan ni Isa, yamadaman silan aw yagalaong silan, “Kanogon sinyan na paballo! ");
INSERT INTO kqe_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Madyaw pa aw byabarigya inyan ng dakowa na kantidad aw yang alin atag adto sang mga miskinan.” ");
INSERT INTO kqe_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na, kyakatigaman ni Isa daw ono yang pyagabaawan nilan, agaw yagalaong yan kanilan, “Nanga sa pyagakasamok mayo yani na bobay? Madyaw yang ininang nan kanak. ");
INSERT INTO kqe_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kay yang mga miskinan abay mayo kaupud, awgaid ako, di ako magapabilin adi kamayo. ");
INSERT INTO kqe_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yobowan nan ako ng paballo antak andamun nan yang kanak lawas sang kanak paglubung. ");
INSERT INTO kqe_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sang bunna-bunna pagalaong ko kamayo na maskin wain adi sining donya apayapat yang Madyaw na Gogodanun, amagogod oman yani na ininang nan silbi tadumanan kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pagkatapos sinyan, si Yodas Iskariyot na sambok sang sampoo aw dowa na sahabat ni Isa, kyomadto yan sang mga pangoo ng mga imam ");
INSERT INTO kqe_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aw yagalaong yan kanilan, “Pila yang atag mayo kanak kong ipagtraydor ko kamayo si Isa?” Na, yabayadan dayon nilan yan ng 30 ka bok na sapi na pilak. ");
INSERT INTO kqe_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aw sikun sinyan yamanganap da si Yodas ng wakto na madyaw ipadakup kanilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ansinyan pagdatung ng pukas na allaw ng Pakaradyaan ng Pan na way Labadora, dyomood kang Isa yang mga inindowan nan aw yagaosip silan, “Wain yang karim mo na andamun nami yang kanatun pagkan para sang Pakaradyaan ng Paglabay?” ");
INSERT INTO kqe_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tyomobag si Isa, “Kadto kamo sang syodad aw paglaonga mayo yang otaw na makita mayo ansan na ‘Yagalaong yang kanami goro na masaid da yang wakto na pyagakahanda kanan ng Tohan. Magakandori da yan adto sang kanmo baay para sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ansinyan tyotoman da ng mga inindowan yang sogo kanilan ni Isa aw pyagaandam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqe_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkagabi disinyan imingkod si Isa sang lamisa upud sang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqe_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sarta yanagpangan silan, yagalaong si Isa, “Sang bunna-bunna pagalaong ko kamayo na aon sangka otaw kamayo na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na, labi da yang karido nilan aw yang matag-isa kanilan yagaosip kanan, “Kay Dato, ako ba yang pyagalaong mo?” ");
INSERT INTO kqe_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tyomobag si Isa, “Yang sangka otaw kamayo na yagadarit ng pan disining ladya upud kanak, yan yang magatraydor kanak. ");
INSERT INTO kqe_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amatay ako na Anak ng Manosiya magonawa sang yamakasorat sang Kitab. Awgaid kallat sidtong otaw na magatraydor kanak. Madyaw pa kong wa yan akaotaw.” ");
INSERT INTO kqe_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ansinyan yagaosip kanan si Yodas na yan yang magatraydor kanan, “Kay Goro, ako ba yang pyagalaong mo?” Tyomobag si Isa, “Na, pyagalaong da mo.” ");
INSERT INTO kqe_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Adon, sarta yanagpangan pa silan, kyomamang si Isa ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga inindowan nan aw laong nan, “Dawata mayo yani aw kana mayo kay yani yang kanak lawas.” ");
INSERT INTO kqe_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ansinyan kyomamang yan ng inmanan aw pagkatapos manginsokor sang Tohan yatag nan kanilan aw laong nan, “Inuma mayo yani, obos mayo. ");
INSERT INTO kqe_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kay yani yang kanak dogo na yagaatag ng kasigorowan sang pyagapasadan na ininang ng Tohan sang manosiya. Moboos yang kanak dogo antak maampon yang madaig na mga otaw sikun sang mga dosa nilan. ");
INSERT INTO kqe_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pagalaong ko kamayo na sikun adon di da ako iminum sining tumuk ng grips taman sang wakto na iminum da ako ng bago na inmanun upud kamayo adto sang pyagadatowan ng kanak Ama.” ");
INSERT INTO kqe_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagkatapos sinyan, yanagkanta silan ng pagpoji adto sang Tohan aw kyomadto da silan sang Butay ng Jayton. ");
INSERT INTO kqe_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ansinyan yagalaong si Isa sang mga inindowan nan, “Adon na gabi magadaagan yang kariko mayo sabap kanak aw mibiya kamo kanak. Kay aon yamakasorat sang Kitab na yagalaong, “ ‘Apapatay ng Tohan yang magbabantayay ng mga karniro, aw ansinyan magakanat-kanat da yang mga karniro.’ ");
INSERT INTO kqe_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Awgaid,” laong ni Isa, “pagkatapos ko mabowi oman amaona ako kamayo adto sang Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ansinyan yagalaong si Pitros kang Isa, “Maskin ibiyaan kaw ng kariko nilan, awgaid ako, di ako mibiya kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yagalaong kanan si Isa, “Sang bunna-bunna pagalaong ko kanmo na sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw ikilaa kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Awgaid yagalaong oman si Pitros, “Di ako magalaong na wa ta kaw ikilaa maskin pa apatayun ako upud kanmo.” Na, maynan oman yang pyaglaongan ng kadaigan na mga inindowan. ");
INSERT INTO kqe_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ansinyan kyomadto si Isa aw yang mga inindowan nan sang sambok na tanumanan na tyatawag ng Gitsimani. Pagdatung nilan ansan, yagalaong si Isa sang mga inindowan nan, “Pagingkod kamo ansini sarta magadowaa ako adto sang onaan.” ");
INSERT INTO kqe_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tapos, pyagaagad nan si Pitros aw yang dowangka otaw na mga anak ni Sibidi. Ansinyan yamarido da yang ginawa ni Isa aw mabugat yang pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Laong nan kanilan, “Labi da yang karido ng ginawa ko na maynang amatay da ako. Ansini da gaid kamo aw ayaw kamo magkatoog. Pagbantay kamo upud kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ansinyan kyomadto si Isa sang onaan aw syomojod yan sang lopa kay magadowaa. Laong nan, “O kay Ama, aw mapakay, ayaw pagtogoti na amagi ako sining madatung na kasikotan. Awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqe_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ansinyan byomarik yan adto sang toongka otaw na mga inindowan nan aw yadatungan nan silan na yamangkatoog. Pyopokaw nan silan aw yagalaong yan kang Pitros, “Nanga, wa kamo makabantay upud kanak na maskin sangka oras da gaid? ");
INSERT INTO kqe_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pagbantay aw pagdowaa kamo antak di kamo madaa ng satsat. Sa suud ng pangatayan mayo karim mayo mangagad sang Tohan, awgaid sabap ng maloya yang lawas mayo madari kamo madaa ng satsat.” ");
INSERT INTO kqe_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ansinyan pyomanaw da oman si Isa aw yagadowaa da oman yan. Laong nan, “O kay Ama, kong kinaanglan na amagi ako sining kasikotan, yang karim mo yang amatoman.” ");
INSERT INTO kqe_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagkatapos, byomarik da oman yan sang mga inindowan nan aw kikita nan na yamangkatoog da oman silan kay labi da yang katodtod nilan. ");
INSERT INTO kqe_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ansinyan pyomanaw da oman yan aw yagadowaa yan ng ikatoo na maynan oman yang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapos magdowaa, byomarik da oman yan sang mga inindowan nan aw yagalaong yan kanilan, “Yabay pa gaid kamo matoog aw magpatana? Osto da kay dyomatung da yang wakto na adakupun ako na Anak ng Manosiya ng baradosa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Anda, bangon da kamo kay mapanaw da kita. Idi da yang otaw na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nang yagatiyab pa si Isa, dyomatung si Yodas na sambok sang sampoo aw dowa na mga sahabat. Madaig yang mga otaw na yumupud kanan na aon daa na mga lodyo aw mga bobonal. Syosogo silan ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, pyagalaong silan dadaan ni Yodas na yan yang magatraydor kang Isa daw ono yang inangun nan silbi tanda kanilan. Laong nan, “Yang otaw na aukan ko, yan yang pyagaanap mayo. Dakupa da mayo.” ");
INSERT INTO kqe_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Agaw pagdatung ni Yodas, dyomood dayon yan kang Isa aw maglaong, “Assalamo alaykom, kay Goro.” Aw yaukan nan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yagalaong kanan si Isa, “Kay lagi, inanga da yang kyakanian mo.” Ansinyan dyomood kang Isa yang kadaigan na mga otaw aw dakupa nilan. ");
INSERT INTO kqe_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, isa sang mga kaupdanan ni Isa yagagabot ng lodyo aw tibasa nan yang sogowanun ng Dakowa na Imam aw yamapotol yang sangkilid na taringa nan. ");
INSERT INTO kqe_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yagalaong kanan si Isa, “Barikan yang lodyo mo sang tagob kay yang magagamit ng lodyo, lodyo oman yang makamatay kanan. ");
INSERT INTO kqe_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wa mo kadi akatigami na makapangayo ako ng tabang sang kanak Ama aw ansinyan apadaan nan ako ng libo-libo na mga malaikat? ");
INSERT INTO kqe_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Awgaid kong inangun ko yan, monono da yang pagtoman sang yamakasorat sang Kitab na yagalaong na dait mainang yang kariko sini?” ");
INSERT INTO kqe_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ansinyan yagalaong si Isa sang mga otaw, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng lodyo aw bobonal sang pagdakup mayo kanak? Matag allaw adto ako magaingkod sang Baay ng Tohan aw yagaindo, awgaid wa mayo ako adakupa. ");
INSERT INTO kqe_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Awgaid yamaitabo yang kariko sini antak matoman yang syosorat ng mga nabi sang Kitab.” Ansinyan yagabiya kanan yang kariko ng mga inindowan nan aw yanagdaagan silan. ");
INSERT INTO kqe_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pagkatapos sinyan dyadaa si Isa nidtong mga otaw na yagadakup kanan adto sang baay ni Kayapas na yan yang Dakowa na Imam. Yanagkatipon ansan yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na, si Pitros, yosonod yan kang Isa awgaid sang mawat-awat gaid taman sang pamanag ng baay ng Dakowa na Imam. Ansinyan syomuud yan sang pamanag aw imingkod upud sang mga gowardya antak katigaman nan daw ono yang akatamanan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yang mga pangoo ng mga imam aw yang kariko ng mga opisyales sang Hokmanan ng mga Yahodi, yamanganap silan ng ebidensya na maskin dili ng bunna antak maakosar aw mapatay nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Awgaid way kikita nilan na dosa maskin madaig yang kyomaon kanilan aw yagalaong ng dili ng bunna makapantag kanan. Awgaid sang orian aon dowangka otaw ");
INSERT INTO kqe_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na yagalaong, “Yani na otaw yagalaong na mapakay nan gubaun yang Baay ng Tohan aw apaindugun oman nan sa suud ng toong allaw.” ");
INSERT INTO kqe_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ansinyan imindug yang Dakowa na Imam aw yagalaong yan kang Isa, “Ono yang akatobag mo sining mga otaw na yagaoman kanmo?” ");
INSERT INTO kqe_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Awgaid wa otobag si Isa. Ansinyan yagalaong kanan yang Dakowa na Imam, “Paglaonga kami sang atobangan ng bowi na Tohan daw ikaw ba yang Almasi, yang Anak ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tyomobag kanan si Isa, “Na, pyagalaong da mo. Awgaid pagalaong ko sang kariko mayo na sang madatung na mga allaw makita mayo ako na Anak ng Manosiya na yagaingkod apit sang karinto ng Tohan na Labi na Mabarakat. Aw makita oman mayo na mabarik ako adi sang donya sikun sang langit na pyagalibotan ng gabon.” ");
INSERT INTO kqe_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagdungug sinyan ng Dakowa na Imam, lyalasi nan yang kanan dagom sabap sang kadaman nan aw laong nan, “Astaga! Yagalaong yan na magonawa kono yan sang Tohan! Di da kita kinaanglan ng kadaigan pa na saksi. Dyudungug da mayo adon yang kanan pyaglaongan na magonawa kono yan sang Tohan! ");
INSERT INTO kqe_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, ono da yang hokom mayo?” Tyomobag yang kariko ng mga pangoo aw laong nilan, “Yamakadosa yan aw dait yan patayun.” ");
INSERT INTO kqe_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ansinyan tyotobadan nilan yang parangay ni Isa aw sontoka nilan. Aon oman kadaigan na yagasampal kanan ");
INSERT INTO kqe_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aw yagalaong silan, “Kong ikaw yang Almasi, paglaonga kami daw sino yang yagasampal kanmo!” ");
INSERT INTO kqe_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ansinyan sarta yagaingkod si Pitros adto sang pamanag, dyomood kanan yang sambok na sogowanun na bobay aw yagalaong yan, “Ikaw inagad oman ni Isa na taga Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Awgaid yagadili sinyan si Pitros sang atobangan ng kariko ng mga otaw ansan aw laong nan, “Wa ako akatigam daw ono yang pyagalaong mo.” ");
INSERT INTO kqe_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagkatapos kyomadto yan sang powertaan ng pamanag aw yakakita kanan yang sambok oman na sogowanun na bobay aw yagalaong yan sang mga otaw na yagaindug ansan, “Yani na otaw, inagad ni Isa na taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Awgaid yagadili oman si Pitros. Yagasapa yan aw laong nan, “Wa ako ikilaa sinyan na otaw!” ");
INSERT INTO kqe_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagkatugun-tugun sinyan dyomood kanan yang mga otaw na yagaindug ansan aw laong nilan, “Bunna sagaw na kaupdanan kaw nilan kay makilaa sang tono ng kanmo pyaglaongan na ikaw taga Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ansinyan yagasapa oman si Pitros aw laong nan, “Isiksaun ako ng Tohan kong di ako maglaong ng bunna. Wa ako ikilaa sinyan na otaw!” Na, sinyan na wakto yagatagaok yang laboyo. ");
INSERT INTO kqe_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ansinyan kyakadumduman ni Pitros yang pyagalaong kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo, makatoo kaw maglaong na wa kaw ikilaa kanak.” Na, lyomogwa da si Pitros aw bali na pagtiyao nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaamdagay disinyan yanagkatipon yang kariko ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yanagkaoyon silan na dait patayun si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ansinyan gyagapos nilan si Isa aw dyadaa nilan adto kang Pilato, yang gobirnador na taga Roma. ");
INSERT INTO kqe_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Adon, pagkatigam ni Yodas na yan yang yagatraydor kang Isa na pyagahokom da si Isa na apatayun, yagabasul yan sang ininang nan aw ori nan yang 30 ka bok na sapi na pilak adto sang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yagalaong yan kanilan, “Yamakadosa ako kay pyagatraydoran ko yang otaw na way dosa.” “Na, way labot nami san. Bahala da kaw,” yang tobag nilan. ");
INSERT INTO kqe_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ansinyan titimbag ni Yodas yang sapi adto sa suud ng Baay ng Tohan aw panaw. Lyomogwa yan, yagatali ng lobid sang liyug nan aw yagatoyo. ");
INSERT INTO kqe_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ansinyan pyopoti ng mga pangoo ng mga imam yang sapi aw laong nilan, “Sopak sang Hokoman na ioog yani na sapi sang butanganan ng sapi adto sang Baay ng Tohan kay bayad yani sang kinabowi ng sambok na otaw.” ");
INSERT INTO kqe_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ansinyan yanagkaoyon silan na agamitun nilan yang sapi sang pagbili ng lopa ng tiginang ng koon kay antak inangun nilan ng pangkoboran sang mga dayo. ");
INSERT INTO kqe_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sabap sinyan tyatawag yan na lopa ng “Lopa ng Dogo” taman adon. ");
INSERT INTO kqe_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na, ansinyan yamatoman yang pyaglaongan ni Nabi Irimiyas na yamakasorat sang Kitab, laong nan, “Kyakamang nilan yang 30 ka bok na sapi na pilak na pyagasabotan ng mga otaw na bangsa Israil sang pagbayad kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aw gyagamit nilan yan na sapi sang pagbili ng lopa ng tiginang ng koon magonawa sang pyagalaong kanak ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Adon, iyan da si Isa sang atobangan ni Gobirnador Pilato aw yosip yan ng gobirnador, laong nan, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag si Isa, “Pyagalaong da mo.” ");
INSERT INTO kqe_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Awgaid nang yagaoman kanan yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, wa yan otobag. ");
INSERT INTO kqe_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Agaw yagalaong kanan si Pilato, “Wa kaw makadungug sang pyagaoman nilan kanmo? Nanga sa di kaw motobag?” ");
INSERT INTO kqe_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Awgaid ni kaw, wa otobag si Isa. Agaw, bali na pagkatingaa ng gobirnador. ");
INSERT INTO kqe_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, matag Pakaradyaan ng Paglabay yang kyakaanadan ng gobirnador na palogwaun nan yang sangka otaw na piniriso daw sino yang pyapangayo ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, sidto na wakto aon bantoganun na piniriso na pyagangaanan ni Barabas. ");
INSERT INTO kqe_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ansinyan nang yanagkatipon yang mga otaw, yagaosip kanilan si Pilato, “Sino yang karim mayo na apalogwaun ko, si Barabas atawa si Isa na tyatawag ng Almasi?” ");
INSERT INTO kqe_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Idto yang osip nan kay kyakatigaman nan na dyadaa kanan si Isa ng mga pangoo ng mga Yahodi sabap ng yamasina silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ansinyan sarta yagaingkod si Pilato sang ingkodanan ng maghohokom aon pyagatogon kanan ng kanan asawa na laong nan, “Ayaw magpangilabot sinyan na otaw na way dosa. Kay sang tagaynup ko komang gabi maat yang byabati ko sabap kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Awgaid yang ininang ng mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, pyagalaong nilan yang mga otaw na si Barabas yang apangayoon nilan na obooyan aw apapatay si Isa. ");
INSERT INTO kqe_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ansinyan yagaosip oman kanilan si Gobirnador Pilato, “Sino kanilan dowa yang karim mayo na obooyan ko?” Tyomobag silan, “Si Barabas!” ");
INSERT INTO kqe_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yagalaong kanilan si Pilato, “Kong maynan, ono yang inangun ko kang Isa na tyatawag ng Almasi?” Yagalaong da yang kariko nilan, “Alansang yan sang kros!” ");
INSERT INTO kqe_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Nanga sa? Ono yang dosa na ininang nan?” yagaosip da oman si Pilato. Awgaid pyapakusug pa nilan yang pagpangiyak aw laong nilan, “Alansang yan sang kros!” ");
INSERT INTO kqe_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pagkita ni Pilato na waa day amainang nan aw masaid da magkasamok yang kamangaotawan, kyomamang yan ng tobig aw yamangonaw sang atobangan ng mga otaw aw laong nan, “Way labot ko sang kamatayun sini na otaw. Kamo da yang bahala.” ");
INSERT INTO kqe_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tyomobag yang kariko ng mga otaw, “Kami aw yang kanami mga topo amanobag sang pagpatay kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagkatapos sinyan byobooyan ni Pilato si Barabas adto kanilan. Awgaid si Isa, pyapabadasan nan aw yatag nan sang mga sondao antak alansang da nilan sang kros. ");
INSERT INTO kqe_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ansinyan dyadaa si Isa ng mga sondao adto sa suud ng palasyo ng gobirnador aw pyapatawag nilan yang kariko ng kasondaowan. ");
INSERT INTO kqe_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ansinyan lyolobasan nilan si Isa ng dagom aw syosootan ng joba na mapowa. ");
INSERT INTO kqe_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tapos, yagainang silan ng korona sikun sang mga sanga ng kaoy na soksokon aw byubutang nilan sang oo nan. Pyapakuputan nilan sang karinto na arima nan ng kaoy silbi tanda ng pagkasoltan. Yolood silan sang atobangan nan aw didigay-digay nilan na laong nilan, “Mabowi yang soltan ng mga Yahodi!” ");
INSERT INTO kqe_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ansinyan tyotobadan nilan si Isa aw kyakamang da oman nilan yang kaoy na kyukuputan nan aw byobonalan nilan yang oo nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkatapos nilan digay-digayun si Isa, lyolobasan nilan ng joba na mapowa aw syosootan da oman ng kanan dagom. Ansinyan dyadaa nilan yan adto sa logwa antak alansang da nilan sang kros. ");
INSERT INTO kqe_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Paglogwa nilan sikun sang syodad, aon syosongon nilan na otaw na pyagangaanan ni Simon na taga Kirini. Pyupugus yan ng mga sondao pagpusan sang kaoy na pagalansangan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagdatung nilan sang logar na tyatawag ng Golgota na yang mana san Logar ng Oo ng Kalabira, ");
INSERT INTO kqe_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pyapainum nilan si Isa ng bino na syasaguan ng mapait. Awgaid pagkatilaw nan sinyan, wa nan inuma. ");
INSERT INTO kqe_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ansinyan lyalansang da nilan si Isa sang kros. Pagkatapos san, yanagripa silan antak bainun nilan yang mga dagom nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tapos, imingkod silan aw yagabantay silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adto sa taas ng oo ni Isa aon byubutang nilan na karatola na syosoratan ng pyagaoman kang Isa na yagalaong, “Yani si Isa, yang Soltan ng mga Yahodi.” ");
INSERT INTO kqe_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aon oman dowangka otaw na tolisan na lyalansang sang kros dungan kang Isa, yang sambok sang karinto nan aw yang sambok sang kawaa nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na, yang mga otaw na yalabay ansan yagauung-uung aw ininsolto nilan si Isa, laong nilan, ");
INSERT INTO kqe_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yagalaong kaw na ogubaun mo yang Baay ng Tohan aw apaindugun da mo oman sa suud ng toong allaw. Kong bunna ikaw yang Anak ng Tohan, lowasa yang ginawa mo aw kawas dosang kros.” ");
INSERT INTO kqe_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Magonawa sinyan didigay-digay yan ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman kipat sang mga pangoo ng mga Yahodi. Laong nilan, ");
INSERT INTO kqe_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tyatabangan nan yang kadaigan, awgaid di yan makalowas sang ginawa nan! Di ba yan yang soltan ng bangsa Israil? Na, kong makakawas yan adon sikun sang kros, amangintoo da kami kanan! ");
INSERT INTO kqe_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yasarig yan sang Tohan aw yagalaong yan na Anak kono yan ng Tohan. Na, tanawon ta adon kong olowasun yan ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na, maskin yang dowangka otaw na tolisan na lyalansang sang kros dungan kang Isa, yamanginsolto silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nang alas dose yang suga yagakaduguum yang tibok banwa taman ng alas tres. ");
INSERT INTO kqe_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pagkaalas tres ng gabila, yamangiyak si Isa ng matanog, laong nan, “Iloy, Iloy, lama sabaktani?” na yang mana sinyan “Ya Tohan ko, ya Tohan ko, nanga sa pyapabayaan mo ako?” ");
INSERT INTO kqe_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pagdungug sinyan ng mga otaw na yanagindug ansan, yagalaong silan, “Tyatawag nan si Nabi Iliyas.” ");
INSERT INTO kqe_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ansinyan dyomaagan dayon yang sambok na otaw aw kyomamang yan ng ispongha aw tuguma nan sang aslum na bino. Tapos, byubutang nan sang kaoy aw diwian adto kang Isa antak masupsup nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Awgaid yagalaong yang kadaigan, “Tagad nay, kay tanawon ta daw madatung si Nabi Iliyas antak maglowas kanan.” ");
INSERT INTO kqe_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pagkatapos sinyan yamangiyak da oman si Isa ng matanog aw yamabogto da yang napas nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na, sidto na wakto yang madakmul na kortina adto sang Baay ng Tohan yamalasi sang tunga sikun sa taas pababa. Yamagayung yang lopa aw yamapiyak yang mangkadakowa na mga bato. ");
INSERT INTO kqe_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yamaboka yang mga kobor aw madaig yang mga patay na mga otaw ng Tohan na yamabowi oman. ");
INSERT INTO kqe_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lyomogwa silan sikun sang kobor aw pagkatapos mabowi oman ni Isa kyomadto silan sang Awrosalam, yang sotti na syodad. Madaig yang mga otaw na yakakita kanilan. ");
INSERT INTO kqe_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, yang kapitan aw yang mga kaupdanan nan na mga sondao na yagabantay kang Isa, pagbati nilan sang linog aw pagkita nilan sang kariko ng kyakatamanan, yasaot silan ng alluk aw laong nilan, “Bunna sagaw na Anak yan ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na, madaig oman ansan yang mga kaobayan na yanagtanaw sidto na yamaitabo sikun sang mawat. Silan yang mga bobay na yamagad kang Isa sikun pa sang Jalil aw yagaatiman kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaupud nilan si Mariyam na taga Magdala, si Mariyam na ina ni Yakob aw ni Yosis, aw yang asawa ni Sibidi. ");
INSERT INTO kqe_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pagkakasilum disinyan dyomatung yang sambok na sapian na taga Arimatiya. Yang ngaan nan si Yosop aw inagad oman yan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kyomadto yan kang Pilato aw pyapangayo nan yang patay na lawas ni Isa. Ansinyan yagasogo si Pilato na atag kanan. ");
INSERT INTO kqe_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na, kyakamang da ni Yosop yang lawas ni Isa aw byabalot nan ng bago na sapot na mapoti. ");
INSERT INTO kqe_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pagkatapos, byubutang nan sang bago na kobor na pyapalongagan nan sang bato silbi pangkoboran sang sarili nan. Ansinyan pyagaligid nan yang dakowa na bato sang baba ng kobor antak matabonan yan aw pyomanaw. ");
INSERT INTO kqe_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na, si Mariyam na taga Magdala aw yang sambok oman na Mariyam yagaingkod ansan na yagaatobang sang kobor. ");
INSERT INTO kqe_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkailaw disinyan na Allaw ng Pagpatana, kyomadto kang Pilato yang mga pangoo ng mga imam aw yang mga Parisi. ");
INSERT INTO kqe_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pagdatung nilan, yagalaong silan kang Pilato, “Kay Gobirnador, kyakadumduman nami na sang bowi pa idtong limbongon na otaw yagalaong yan na amabowi oman yan sang ikatoong allaw sikun sang pagkamatay nan. ");
INSERT INTO kqe_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Idto sagaw, madyaw pa aw pabantayan mo yang kobor nan taman sang ikatoong allaw kay basin makadto yang mga inindowan nan aw kawatun nilan yang patay na lawas nan. Pagkatapos, pagalaongon nilan yang mga otaw na yamabowi oman si Isa. Na, yan na bakak, labaw pa yang kaatan sinyan kaysang ona na bakak na yan kono yang Almasi.” ");
INSERT INTO kqe_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Pagkamang da gaid kamo ng mga sondao,” yang tobag kanilan ni Pilato, “aw pabantayan mayo ng madyaw yang kobor nan.” ");
INSERT INTO kqe_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na, kyomadto da silan sang kobor aw byubutangan nilan ng silyo yang dakowa na bato na yakatabon sang baba ng kobor antak katigaman kong aon mangilabot sinyan. Aw pyapabantayan nilan yang kobor sang mga sondao. ");
INSERT INTO kqe_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagkatapos ng Allaw ng Pagpatana nang masaid da somilat yang suga sang allaw ng Domingo, kyomadto sang kobor ni Isa si Mariyam na taga Magdala aw yang sambok oman na Mariyam antak tanawon nilan. ");
INSERT INTO kqe_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ansinyan yagalinog ng makusug kay aon malaikat ng Tohan na yagasikun sang sorga. Kyomadto yan sang kobor aw pyagaligid nan yang dakowa na bato na yakatabon sang baba sinyan aw pyagaingkodan nan. ");
INSERT INTO kqe_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Makasilaw yang parangay nan na magonawa sang kilat aw labi na mapoti yang dagom nan. ");
INSERT INTO kqe_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pagkita kanan ng mga gowardya, tyatakigan silan ng alluk aw yamasiling silan ng patay. ");
INSERT INTO kqe_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ansinyan yagalaong yang malaikat sang mga bobay, “Ayaw kamo magkalluk. Yamatigam ako na yanap mayo si Isa na pyapalansang sang kros. ");
INSERT INTO kqe_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa da yan adi kay yamabowi oman yan magonawa sang pyagalaong nan. Adi kamo aw tanawa mayo yang pyagabutangan kanan. ");
INSERT INTO kqe_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, kallug da kamo panaw aw paglaonga mayo yang mga inindowan nan na yamabowi oman yan. Amaona yan kanilan adto sang Jalil aw adto da nilan yan ikitaun. Na, timani mayo yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ansinyan yomapas-apas silan manaw sikun sang kobor. Yamangkalluk silan awgaid dakowa oman yang kasowat nilan. Aw dyomaagan da silan antak paglaongon nilan yang mga inindowan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na, sakadyap syosongon silan ni Isa aw laong nan kanilan, “Assalamo alaykom!” Ansinyan dyomood silan kang Isa aw syomojod silan sang atobangan nan na yagakuput sang siki nan. ");
INSERT INTO kqe_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yagalaong si Isa kanilan, “Ayaw kamo magkalluk. Panaw da kamo aw paglaonga mayo yang mga kalomonan ko na makadto silan sang Jalil. Adto da nilan ako ikitaun.” ");
INSERT INTO kqe_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, pagpanaw ng mga bobay, pyomanaw oman yang kadaigan ng mga sondao na yagabantay sang kobor aw kyomadto silan sang Awrosalam antak pakatigamun nilan yang mga pangoo ng mga imam sang kariko ng yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ansinyan yanagkatipon da yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi aw yanagbaaw-baaw silan daw ono yang inangun nilan. Pagkatapos, yatagan nilan yang mga sondao ng madaig na sapi ");
INSERT INTO kqe_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aw paglaonga nilan, “Paglaonga mayo yang mga otaw na sang tungang gabi dyomatung yang mga inindowan ni Isa aw kyakawat nilan yang kanan lawas sarta yamatoog kamo. ");
INSERT INTO kqe_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aw madungug yani ng gobirnador, ayaw kamo magkarido kay kami da yang matigam maglaong kanan antak di kamo maono.” ");
INSERT INTO kqe_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Agaw, dyadawat da ng mga sondao yang sapi aw tyotoman nilan yang pyagasogo kanilan. Na, yan da yang gogodanun na pyapangintoowan ng mga Yahodi sampay adon. ");
INSERT INTO kqe_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Adon, yang sampoo aw isa na mga sahabat ni Isa, kyomadto da silan sang Jalil, adto sidtong butay na pyagalaong kanilan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkita nilan kanan, syomojod silan aw syasambayangan nilan yan. Awgaid aon oman pilangka otaw kanilan na yagadowa-dowa pa. ");
INSERT INTO kqe_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ansinyan dyomood kanilan si Isa aw yagalaong yan, “Yatag kanak yang kariko ng kapatot sang pagdato adi sang donya aw adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Agaw sagaw, kadto da kamo sang kariko ng mga bangsa adi sang babawan ng donya aw paglaonga mayo yang mga otaw ng makapantag kanak. Sogbowi silan sang ngaan ng Ama, sang ngaan ng Anak aw sang ngaan ng Nyawa ng Tohan aw indowi mayo silan na otomanun nilan yang kariko ng pyagasogo ko kamayo. Aw ansinyan amainang silan ng mga inindowan ko. Aw timani mayo na abay ako magupud kamayo taman sang kataposan ng donya.” Wassalam ");
INSERT INTO kqe_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yani yang pagsogod ng Madyaw na Gogodanun makapantag kang Isa Almasi na Anak ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aon syosorat ni Nabi Isayas sang Kitab na yagalaong yang Tohan, laong nan, “Apaonaun ko kanmo yang sogowanun ko antak andamun nan yang agianan mo. ");
INSERT INTO kqe_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aon sangka otaw na manawag-tawag adto sang kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ansinyan, magonawa sang yamakasorat sang Kitab, dyomatung da si Yahiya aw yagasogbo yan sang mga otaw adto sang kamingawan. Yagaosiyat yan adto kanilan aw laong nan, “Pagtawbat kamo aw biyai yang mga dosa mayo aw pagpasogbo kamo silbi tanda ng pagtawbat mayo antak amponon ng Tohan yang mga dosa mayo.” ");
INSERT INTO kqe_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na, madaig yang mga otaw na kyomadto kanan sikun sang kariko ng mga banwa na sakop ng Yahodiya aw sikun oman sang syodad ng Awrosalam. Yagagogod silan sang mga dosa nilan aw yagapasogbo silan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yang dagom ni Yahiya ininang sikun sang bulbul ng kamil aw yang sintoron nan ininang ng paris ng ayup. Yang pagkan nan mga doon aw duga. ");
INSERT INTO kqe_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aw yani yang pyagaosiyat nan sang mga otaw, laong nan, “Aon otaw na mosonod kanak domatung na labaw pa kanak. Maskin yang pagobad ng liston ng sandalyas nan di dait kanak. ");
INSERT INTO kqe_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ako, tobig yang pyagasogbo ko kamayo, awgaid yang pagasogbo nan kamayo yang Nyawa ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sidto na wakto dyomatung si Isa sikun sang banwa ng Nasarit na sakop ng Jalil, aw yagapasogbo yan kang Yahiya adto sang tobig ng Yordan. ");
INSERT INTO kqe_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na, pagsaka ni Isa sikun sang tobig, kikita nan na yagaboka yang langit aw yukunsad adto kanan yang Nyawa ng Tohan sang porma ng salampati. ");
INSERT INTO kqe_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aw aon sowara sikun sang langit na yagalaong, “Ikaw yang pyapasaya ko na Anak. Dakowa yang kasowat ko kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ansinyan pyapakadto dayon si Isa ng Nyawa ng Tohan adto sang kamingawan. ");
INSERT INTO kqe_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adto da yan magauya sa suud ng 40 na allaw aw yabay yan satsatun ni Iblis. Aon oman maisug na mga ayup sang masaid kanan, awgaid yatiman yan ng mga malaikat. ");
INSERT INTO kqe_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, nang yamapiriso da si Yahiya, kyomadto si Isa sang banwa ng Jalil aw yagaosiyat yan ng Madyaw na Gogodanun na sikun sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Laong nan, “Adon dyomatung da yang wakto na pyagakahanda ng Tohan aw masaid da domatung yang pagdato nan. Pagtawbat da kamo aw biyai mayo yang mga dosa mayo aw pangintoo kamo sang Madyaw na Gogodanun.” ");
INSERT INTO kqe_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ansinyan sarta yagapanaw si Isa sang kilid ng Linaw ng Jalil, kikita nan yang dowa na maglomon na si Simon aw si Andriyas na yamamokot kay mangingisdaay silan. ");
INSERT INTO kqe_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yagalaong si Isa kanilan, “Abay da, agad kamo kanak. Sikun adon inangun ta kamo na mangingisdaay ng otaw antak mangagad silan kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na, pagdungug sinyan bibiyaan dayon nilan yang pokot nilan aw yamagad silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ansinyan pyomanaos si Isa pagpanaw aw kikita nan yang dowa na maglomon na si Yakob aw si Yahiya na mga anak ni Sibidi. Yanagpona silan ng pokot adto sang kanilan bangka. ");
INSERT INTO kqe_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tyatawag silan ni Isa na amagad kanan. Ansinyan bibiyaan da nilan yang kanilan ama aw yang mga maggawbukay adto sang bangka aw yamagad silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ansinyan kyomadto silan Isa sang longsod ng Kapirnaom. Pagdatung ng Allaw ng Pagpatana kyomadto si Isa sang pagsasambayangan ng mga Yahodi aw magindo. ");
INSERT INTO kqe_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yamangkatingaa yang mga otaw sang pagindo ni Isa kay yagaindo yan na aon kapatot aw dili magonawa sang mga magiindoway ng Hokoman. ");
INSERT INTO kqe_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Adon, aon sangka otaw ansang pagsasambayangan nilan na kyakasaytanan. ");
INSERT INTO kqe_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yamangiyak yan aw laong nan, “Ono yang labot mo kanami, kay Isa na taga Nasarit? Yakani kaw sang pagsapad kanami? Yamatigam ako daw sino kaw. Ikaw yang sotti na syosogo ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Awgaid syasagda ni Isa yang saytan aw laong nan, “Katingun aw logwa da sinyan na otaw!” ");
INSERT INTO kqe_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na, pyapatakigan da idtong otaw ng saytan, tapos yamangiyak yan ng matanog aw logwa sikun sang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ansinyan yamangkatingaa da yang kariko ng mga otaw aw yanaginosipay silan, laong nilan, “Ono kadi yani? Bago yani na indowan? Kay aon kapatot nan pagsogo sang mga saytan aw motoman silan kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ansinyan yamakarimpud da yang gogodanun makapantag kang Isa sang tibok probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Paglogwa nilan Isa sikun sidto na pagsasambayangan, kyomadto silan sang baay ni Simon aw si Andriyas. Yamagad oman kanilan si Yakob aw si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na, yang ogangan na bobay ni Simon yagakowang adto sang baay na labi na mapaso yang lawas nan. Agaw, pagdatung ni Isa pyagalaong dayon nilan makapantag kanan. ");
INSERT INTO kqe_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ansinyan dyomood si Isa sidtong bobay, kuputi yang arima nan aw papagbangona. Aw yamawaa dayon yang kapaso ng lawas nan. Pagkatapos, pyapakan nan silan Isa. ");
INSERT INTO kqe_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na, pagsallup ng suga, dyadaa da ng mga otaw yang kariko ng mga masakitun aw yang mga kyakasaytanan adto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aw yang kariko ng mga otaw sikun sidto na banwa yanagkatipon sang atobangan sidto na baay. ");
INSERT INTO kqe_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na, madaig yang mga otaw na pyapakadyaw ni Isa sikun sang yagakatuna-tuna na mga sakit aw madaig yang mga saytan na pyapalogwa nan sikun sang mga otaw. Awgaid wa nan otogoti yang mga saytan na magatiyab kay kyakatigaman nilan daw sino yan. ");
INSERT INTO kqe_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagkailaw disinyan nang wa pa magasilat yang suga, yagabangon si Isa aw lyomogwa yan sikun sang baay. Kyomadto yan sang mamingaw na banwa antak magdowaa. ");
INSERT INTO kqe_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ansinyan kay waa ansang baay si Isa, pyapanganap yan ni Simon kipat sang mga kaupdanan nan. ");
INSERT INTO kqe_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkita nilan kang Isa, yagalaong silan kanan, “Yang kariko ng mga otaw yamanganap kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Awgaid yagalaong si Isa kanilan, “Abay da kamo, makadto da kita sang makilibot na mga baryo antak makaosiyat oman ako adto. Kay yan yang katoyowan nanga sa yakani ako sining donya.” ");
INSERT INTO kqe_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Agaw, kyakadtowan da ni Isa yang kariko ng mga banwa na sakop ng Jalil aw yagaosiyat yan adto sang mga pagsasambayangan ng mga Yahodi. Aw pyapalogwa nan yang mga saytan sikun sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ansinyan aon sangka otaw na sanglaun na yodood kang Isa. Yolood yan sang atobangan nan aw yagapakilooy yan, laong nan, “Kong karim mo, makapagkadyaw kaw sang kanak sakit.” ");
INSERT INTO kqe_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ansinyan yamatangkug yang pangatayan ni Isa aw dyadapunan nan yang inyan na otaw ng arima nan aw laong nan, “Ud, karim ko. Amadyaw da kaw.” ");
INSERT INTO kqe_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na, sinyan na wakto yamawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ansinyan pyapapanaw dayon yan ni Isa pagkatapos nan paglaongon, laong nan, ");
INSERT INTO kqe_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Aw pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqe_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Awgaid pagpanaw sinyan na otaw, yagagogod yan sang kariko ng mga otaw makapantag sang ininang ni Isa. Agaw sa wa da makapakita si Isa adto sang mga longsod aw kyomadto da gaid yan sang mamingaw na mga banwa. Awgaid maskin maynan, yabay komadto kanan yang mga otaw sikun sang kariko ng mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paglabay ng pilang allaw, byomarik oman si Isa adto sang longsod ng Kapirnaom. Aw yamadungug dayon ng mga otaw na iyan da yan sang baay. ");
INSERT INTO kqe_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Agaw, wa akadogay disinyan madaig yang mga otaw na yanagkatipon sidto na baay taman sang waa day makasuud aw way oman logar maskin adto apit sang powertaan. Aw yagaindo kanilan si Isa ng pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sarta yagaindo si Isa, aon dyomatung na opat ka otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Awgaid wa silan makadood adto kang Isa sabap sang kadaig ng mga otaw. Agaw pyomanik silan sang atup aw bosloti nilan sang babaw ni Isa aw tontona nilan idtong otaw ansang kowangan nan adto sang masaid kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, yampon da yang mga dosa mo.” ");
INSERT INTO kqe_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Adon, aon oman mga magiindoway ng Hokoman na yanagingkod ansan. Pagdungug nilan sang pyaglaongan ni Isa, yagalaong silan sang ginawa nilan, ");
INSERT INTO kqe_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nanga sa yagalaong yani na otaw ng mayninyan? Yangkun nan yang kapatot ng Tohan kay yang Tohan gaid yang makaampon sang dosa ng manosiya!” ");
INSERT INTO kqe_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Awgaid kyakatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Nanga sa maynan yang dumduman mayo? ");
INSERT INTO kqe_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wain yang masayun paglaong sining otaw na sadi, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon, daa yang kowangan mo aw panaw?’ ");
INSERT INTO kqe_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Adon, antak katigaman mayo na ako na Anak ng Manosiya aon kapatot ko adi sang babawan ng donya magampon sang mga dosa, pakadyawon da ko yaning otaw.” Ansinyan yagalaong si Isa sidtong otaw na sadi, ");
INSERT INTO kqe_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kay Itin, pagbangon, daa yang kowangan mo aw ori da adto kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na, sarta yagatanaw yang kariko ng mga otaw, yagabangon inyan na otaw, daa yang kowangan nan aw panaw. Aw yamangkatingaa da yang kariko nilan aw pyopoji nilan yang Tohan, laong nilan, “Disti-disti way kikita ta na magonawa sinyan!” ");
INSERT INTO kqe_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ansinyan byomarik si Isa adto sang kilid ng Linaw ng Jalil. Madaig yang mga otaw na yanagkatipon adto kanan aw inindowan nan silan. ");
INSERT INTO kqe_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapos, sarta yagapanaw si Isa, kikita nan yang sambok na mangobraay ng bowis na yagaingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Libi na anak ni Alpiyo. Laong ni Isa kanan, “Abay da, agad kanak.” Ansinyan imindug dayon yan aw yamagad kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wa akadogay disinyan yanagpangan si Isa aw yang mga inindowan nan adto sang baay ni Libi. Madaig yang mga mangobraay ng bowis aw yang kadaigan pa na mga otaw na tyatawag na baradosa na yanagupud kanilan koman kay madaig da silan na yamagad kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pagkita sinyan ng mga magiindoway ng Hokoman na mga Parisi, yagalaong silan sang mga inindowan ni Isa, “Nanga sa yakan si Isa upud sang mga mangobraay ng bowis aw yang kadaigan pa na mga otaw na baradosa?” ");
INSERT INTO kqe_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Awgaid yamakadungug sinyan si Isa, agaw yagalaong yan kanilan, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. Magonawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan, kondi para sang mga otaw na baradosa kay antak magtawbat silan.” ");
INSERT INTO kqe_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sangallaw disinyan yagapowasa yang mga inindowan ni Yahiya na Magsosogboway aw yang mga inindowan ng mga Parisi. Ansinyan aon mga otaw na kyomadto kang Isa aw yagaosip silan kanan, laong nilan, “Yang mga inindowan ni Yahiya aw yang mga inindowan ng mga Parisi yanagpowasa. Awgaid yang mga inindowan mo wa magapowasa. Nanga sa?” ");
INSERT INTO kqe_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tyomobag si Isa pinaagi sang pasombingay, laong nan, “Mapakay ba magpowasa yang mga bisita sang kawin sarta iyan pa yang usug na akawinun? Dili! ");
INSERT INTO kqe_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun, aw sidto na wakto magapowasa da silan.” ");
INSERT INTO kqe_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yagalaong oman si Isa, “Way otaw na magatopak ng bago na tela sang dadaan na dagom. Kay kong mokoyot idtong tyotopak, amalasi da oman yang dagom aw labi da yang lasi sinyan. ");
INSERT INTO kqe_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Way oman otaw na yang bago na bino alasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, maasag da yang bino aw amasapad yang lasakanan. Agaw sa, yang bago na bino dait alasak sang bago na lasakanan na abay pa maonat.” ");
INSERT INTO kqe_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sangallaw disinyan na Allaw ng Pagpatana ng mga Yahodi, yamagi si Isa aw yang mga inindowan nan sang pawa ng trigo. Pagagi nilan, yamangutul yang mga inindowan nan ng trigo. ");
INSERT INTO kqe_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pagkita sinyan ng mga Parisi, yagalaong silan kang Isa, “Tanawa yang mga inindowan mo! Sopak sang Hokoman yang ininang nilan kay yagagawbuk silan sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tyomobag si Isa aw laong nan kanilan, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sang wakto na yamagutum yan kipat sang mga kaupdanan nan aw yagakinaanglan silan ng pagkan? ");
INSERT INTO kqe_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sidtong wakto na si Abiyatar yang Dakowa na Imam, syomuud si Soltan Daud sang Baay ng Tohan aw kyakan nan yang pan na pyapasampay adto sang Tohan aw atagi oman yang mga kaupdanan nan maskin sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan.” ");
INSERT INTO kqe_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yagalaong oman si Isa, “Ininang ng Tohan yang Allaw ng Pagpatana para sang kadyawan ng manosiya. Awgaid yang manosiya wa nan abaoya antak kabugatan silan ng Allaw ng Pagpatana. ");
INSERT INTO kqe_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Agaw ako na Anak ng Manosiya, aon kapatot ko paglaong daw ono yang mapakay inangun maskin sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sangallaw disinyan kyomadto si Isa sang pagsasambayangan ng mga Yahodi. Ansidto aon sambok na otaw na yamasadi yang sangkilid na arima nan. ");
INSERT INTO kqe_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aon oman mga otaw ansan na yagasima kang Isa daw pakadyawon nan idtong otaw sang Allaw ng Pagpatana kay antak aon akapagoman nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ansinyan yagalaong si Isa sidtong otaw na yamasadi yang sangkilid na arima nan, “Adi kaw sang atobangan ng mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkatapos yosip ni Isa yang mga otaw, laong nan, “Sobay sang Hokoman, ono yang mapakay inangun sang Allaw ng Pagpatana, yang paginang ng madyaw atawa maat, yang paglowas sang kinabowi ng otaw atawa yang pagpatay?” Awgaid wa silan otobag kanan. ");
INSERT INTO kqe_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ansinyan pyagatanawan silan ni Isa. Yamadaman yan kanilan aw masakit yang pangatayan nan sabap ng matigas yang oo nilan. Ansinyan yagalaong yan sidtong otaw na yamasadi yang sangkilid na arima nan, “Onata yang arima mo.” Na, yonat da nan aw yamadyaw dayon yang arima nan. ");
INSERT INTO kqe_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ansinyan lyomogwa da yang mga Parisi sikun sang pagsasambayangan aw kadtowi nilan yang mga otaw ni Soltan Hirod kay antak pagbaawan nilan daw monono yang pagpatay nilan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ansinyan pyomanaw ansan si Isa aw yang mga inindowan nan aw kyomadto silan sang kilid ng Linaw ng Jalil. Labi na madaig yang mga taga Jalil na yamagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aw madaig oman yang mga otaw sikun sang Awrosalam aw sang kadaigan pa na mga banwa sang Yahodiya kipat sang mga banwa na sakop ng Idomiya. Aon oman sikun sang dipag ng tobig ng Yordan aw sikun oman sang masaid sang mga syodad ng Tiros aw Sidon. Yani na kamangaotawan kyomadto kang Isa kay yamadungug nilan yang kariko ng ininang nan. ");
INSERT INTO kqe_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adon, sabap sang kadaig ng mga otaw pyagalaong ni Isa yang mga inindowan nan na magandam silan ng bangka na akasakayan nan antak di yan kaligpitan ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Madaig da yang mga otaw na pyapakadyaw ni Isa, agaw yanagtinooday da yang kariko ng mga masakitun antak makakuput silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aw pagkita kanan ng mga otaw na kyakasaytanan, syomojod dayon silan sang atobangan nan aw yamangiyak silan, “Ikaw yang Anak ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Awgaid syasagda silan ni Isa ng maigpit antak di silan maglaong daw sino yan. ");
INSERT INTO kqe_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkatapos sinyan tyomokod si Isa sang sambok na butay aw tawaga nan yang mga otaw na karim nan paagadun aw dyomood silan adto kanan. ");
INSERT INTO kqe_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ansinyan sampoo aw dowangka otaw yang pipili nan antak mainang ng mga sahabat nan. Yagalaong yan kanilan, “Pipili ta kamo antak magad kamo kanak aw osogoon ta kamo antak magosiyat ng Madyaw na Gogodanun. ");
INSERT INTO kqe_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aw atagan ta kamo ng kapatot pagpalogwa sang mga saytan sikun sang mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, yang sampoo aw dowangka otaw na pipili nan si Simon na pyagaingaanan nan ni Pitros, ");
INSERT INTO kqe_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Yakob aw yang lomon nan na si Yahiya na mga anak ni Sibidi. Pyagaingaanan silan ni Isa ng Bowanirgis na yang mana san “maisug na maynang linti,” ");
INSERT INTO kqe_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andriyas, si Pilip, si Bartolomi, si Matiyo, si Tomas aw si Yakob na anak ni Alpiyo, si Tadiyos, si Simon na rebelde sangaon, ");
INSERT INTO kqe_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagkatapos sinyan yomori silan Isa. Ansinyan madaig da oman yang mga otaw na yanagkatipon adto kanan. Agaw, si Isa aw yang mga inindowan nan way gaid oras maskin sang pagpangan. ");
INSERT INTO kqe_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na, pagdungug sinyan ng mga kalomonan ni Isa, kyomadto silan sidtong baay antak kamangun nilan si Isa kay pagtoo nilan na yamabowang da yan. ");
INSERT INTO kqe_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aon oman mga magiindoway ng Hokoman sikun sang Awrosalam na yagalaong, “Syosuudan si Isa ni Bilsibol. Yang pangoo ng mga saytan, yan yang yamatag kanan ng kabarakat pagpalogwa sang mga saytan.” ");
INSERT INTO kqe_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pagdungug ni Isa sang mga pyaglaongan nilan, pyapadood nan silan aw yagalaong yan kanilan ng pasombingay, laong nan, “Di mapakay na magapalogwa si Iblis sang kapagonawa nan na saytan. ");
INSERT INTO kqe_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kong managonay magtanam yang mga otaw sang sambok na pyagadatowan, sang di amadogay amasapad inyan na pyagadatowan. ");
INSERT INTO kqe_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aw kong magakabain-bain yang mga otaw sang sambok na pamilya, sang orian amabongkag yani na pamilya. ");
INSERT INTO kqe_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Magonawa sinyan, kong mapagtanam si Iblis sang mga sakop nan na saytan aw magakabain-bain silan, sang di amadogay akawaan yan ng kapatot pagsogo kanilan aw amasapad da yang pyagadatowan nan.” ");
INSERT INTO kqe_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ansinyan yagaatag oman si Isa kanilan ng opamaan, laong nan, “Way makasuud sang baay ng makusug na otaw aw makakamang sang mga bubutang nan kong di nan ona gaposon idtong makusug na otaw. Awgaid kong yamagapos da nan, makakamang da yan sang mga bubutang sidto na baay. ");
INSERT INTO kqe_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sang bunna-bunna pagalaong ko kamayo na yang kariko ng dosa maampon aw maskin pa yang paglaong ng maat makapantag sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di maampon taman sa taman.” ");
INSERT INTO kqe_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Maynini yang pyaglaongan ni Isa adto sang mga magiindoway ng Hokoman kay yagalaong silan na syosuudan yan ng saytan. ");
INSERT INTO kqe_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ansinyan dyomatung yang ina ni Isa aw yang mga mangkangod nan na usug. Yagaindug silan adto sa logwa ng baay aw pyapatawag nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Adto sa suud madaig yang mga otaw na yanagingkod sang makilibot ni Isa. Ansinyan aon yagalaong kang Isa, “Tabiya, yang ina mo aw yang mga lomon mo, adto silan sa logwa na yagatagad kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tyomobag si Isa aw laong nan kanilan, “Sino kadi yang ina ko aw mga lomon ko?” ");
INSERT INTO kqe_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ansinyan pyagatanawan ni Isa yang mga otaw na yanagingkod sang palibot nan aw laong nan, “Yadi kay yang ina ko aw yang mga lomon ko. ");
INSERT INTO kqe_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kay sino-sino yang yagainang ng karim ng Tohan, silan yang ina ko aw yang mga lomon ko na usug aw bobay.” ");
INSERT INTO kqe_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ansinyan yagaindo da oman si Isa adto sang kilid ng linaw. Aw madaig da oman yang mga otaw na yanagkatipon adto kanan. Agaw, yang ininang ni Isa, syomakay yan sang sambok na bangka na yagalotaw sang tobig aw imingkod ansan sarta yang mga otaw adto managindug sang kilid ng linaw. ");
INSERT INTO kqe_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na, madaig yang pyagaindo ni Isa kanilan pinaagi sang mga pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Laong nan, “Paningug kamo! Aon otaw na kyomadto sang pawa antak magsabod ng bini. ");
INSERT INTO kqe_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sang pagsabod nan, aon mga bini na yamallog adto sang kilid ng daan. Ansinyan dyomatung yang mga langgam aw toboga nilan. ");
INSERT INTO kqe_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aon oman mga bini na yamallog adto sang batoon na lopa. Na, tyomobo dayon yang mga bini kay mababaw yang lopa. ");
INSERT INTO kqe_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Awgaid pagsilat ng suga, yamalanus dayon yang mga tanum sabap sang kapaso ng suga aw yamagango da kay wa silan makagamot ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aon oman mga bini na yamallog adto sang lopa na madaig yang sampinit. Ansinyan tyomorin yang sampinit aw kyakatabonan sinyan yang mga tanum. Idto sagaw wa silan obonga. ");
INSERT INTO kqe_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Awgaid aon oman mga bini na yamallog adto sang madyaw na lopa. Tyomorin silan aw yobonga ng madyaw. Yang kadaigan yobonga ng osto gaid. Yang kadaigan oman yobonga ng madaig, aw yang kadaigan oman yobonga ng labi na madaig.” ");
INSERT INTO kqe_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sang orian yagalaong si Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagpanaw ng kamangaotawan, yang yamabilin ansang masaid kang Isa yang pilangka otaw na mga inagad nan upud sang sampoo aw dowa na sahabat nan. Ansinyan yagaosip silan kanan daw ono yang mana sidto na pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tyomobag si Isa aw laong nan, “Kamo, yatagan kamo ng katigam antak makasabot kamo sang mga tinago makapantag sang pagdato ng Tohan. Awgaid sang kadaigan na mga otaw mga pasombingay yang gyagamit ko ");
INSERT INTO kqe_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kay antak matoman yang yamakasorat sang Kitab na yagalaong, “ ‘Maskin yagatanaw silan, di silan makakita. Aw maskin yamaningug silan, di silan makasabot. Kay kong dili ng maynan, mabarik da gao silan adto sang Tohan antak amponon nan silan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ansinyan yagalaong si Isa kanilan, “Wa kadi kamo makasabot sidto na pasombingay? Kong maynan, di oman kamo makasabot sang kadaigan pa na mga pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na, yani kay yang mana sinyan. Yang bini na syasabod, idto yang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yang kilid ng daan na kyakaoogan ng bini, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan. Awgaid pagdungug sinyan, dyomatung dayon si Iblis aw kamanga nan yang pyaglaongan na dyudungug nilan sikun sang pangatayan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yang kadaigan oman na magonawa ng batoon na lopa, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan aw tyatarima dayon nilan na aon kasowat. ");
INSERT INTO kqe_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Awgaid sabap ng wa makagamot yang pyaglaongan ansang pangatayan nilan, di silan magadogay sang pagpangintoo nilan. Kay kong adatungan silan ng mga satsat atawa apakasikotan silan sabap sang pagpangagad nilan sang pyaglaongan ng Tohan, mibiya dayon silan sang pagpangintoo. ");
INSERT INTO kqe_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yang kadaigan oman na magonawa ng lopa na madaig yang sampinit, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan, ");
INSERT INTO kqe_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","awgaid sabap sang karidowan nilan adi sang babawan ng donya aw sabap oman sang kallini nilan sang sapi aw yang kadaigan pa na mga butang, kyakatabonan da yang pyaglaongan ng Tohan. Idto sagaw way yamakita na bonga ng pagpangintoo sang kinabowi nilan. ");
INSERT INTO kqe_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Awgaid yang kadaigan na magonawa ng madyaw na lopa, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan aw yamangagad sinyan. Agaw sagaw aon makita na bonga ng pagpangintoo sang kinabowi nilan. Yang kadaigan yobonga ng osto gaid, yang kadaigan oman yobonga ng madaig, aw yang kadaigan oman yobonga ng labi na madaig.” ");
INSERT INTO kqe_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan aw asangkoban nan ng gantangan atawa butangan nan sang saad ng katri, kondi ibutang nan sang tongtonganan kay antak kaamdagan yang baay. ");
INSERT INTO kqe_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kay yang maskin ono na yamatago, amaklaro sang orian. Aw yang wa pa akatigami adon, akatigaman da. ");
INSERT INTO kqe_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yagalaong oman si Isa, “Dumduma mayo yang dyudungug mayo. Kay daw monono yang pagpaningug mayo, daw apangagadan mayo yang dyudungug mayo atawa apasagdan mayo, maynan oman yang inangun kamayo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kay sino-sino yang amaningug ng madyaw, odogangan pa yang katigam aw pagsabot nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyakatigaman nan, akamangun pa kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yagalaong oman si Isa, “Yang pagdato ng Tohan magonawa sang otaw na yagasabod ng bini adto sang pawa nan. ");
INSERT INTO kqe_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagkatapos nan magsabod, yagainang yan ng kadaigan pa na gawbuk nan. Na, sarta yamatoog yan ng gabi aw yagagawbuk ng allaw, gyomiti aw tyomorin da yang mga bini. Awgaid wa yan akatigam daw monono yang pagtorin nilan. ");
INSERT INTO kqe_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kay yang lopa yang yagapatorin aw yagapabonga sang mga tanum. Sawpama yang omay, magadaon nay ona, sonod magabuus aw sang orian moboswak. ");
INSERT INTO kqe_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na, kong yailag da, aganiun da kay dyomatung da yang wakto ng paggani.” ");
INSERT INTO kqe_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yagalaong oman si Isa, “Ono yang akaparias natun sang pagdato ng Tohan? ");
INSERT INTO kqe_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ono yang akapasombingay natun sinyan? Na, yang pagdato ng Tohan magonawa ng liso ng mostasa na yani yang labi na tagbi sang kariko ng mga liso. ");
INSERT INTO kqe_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Awgaid pagtanum sinyan, motorin yan aw amainang yan na makagwasay pa sang kariko ng mga tanum. Dakowa oman yang mga sanga sinyan na akapogadan aw akapasilongan ng mga langgam.” ");
INSERT INTO kqe_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na, madaig pa yang mga pasombingay na magonawa sinyan na gyagamit ni Isa sang pagosiyat nan sang mga otaw. Aw inindowan nan silan taman sang amagaga nilan masabot. ");
INSERT INTO kqe_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Way pyagaindo nan sang mga otaw na dili pinaagi sang pasombingay. Awgaid kong silan da gaid ni Isa sang mga inindowan nan, pyapakatigam nan kanilan yang mana ng kariko ng mga pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagsallup ng suga sinyan na allaw, yagalaong si Isa adto sang mga inindowan nan, “Abay da kamo. Mataripag da kita sang linaw.” ");
INSERT INTO kqe_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ansinyan pyapanawan da nilan yang kamangaotawan aw syomakay silan sang bangka na pyagaingkodan ni Isa aw larga da silan. Aon oman kadaigan pa na mga bangka na yamagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ansinyan tyomokaw moyop yang makusug na samut aw kyakalasakan da ng tobig yang kanilan bangka na masaid da mapono. ");
INSERT INTO kqe_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Awgaid si Isa adto sang orin ng bangka na yamatoog sang oonan. Agaw, pyopokaw yan ng mga inindowan nan aw yagalaong silan kanan, “Kay Goro, wa kaw akarido na mallug da kita matay?” ");
INSERT INTO kqe_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ansinyan yagabangon si Isa aw syasagda nan yang samut, laong nan, “Ondang da!” aw yagalaong yan sang mga baud, “Kalinaw da!” Na, ansinyan yomondang dayon yang samut aw yamalinaw da. ");
INSERT INTO kqe_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yagalaong si Isa sang mga inindowan nan, “Nanga sa yamalluk kamo? Waa pay kadi pagpangintoo mayo kanak?” ");
INSERT INTO kqe_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na, labi da yang alluk nilan aw yanaginosipay silan, laong nilan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud motoman kanan?” ");
INSERT INTO kqe_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ansinyan dyomatung si Isa aw yang mga inindowan nan adto sang dipag ng linaw sang logar ng mga taga Girasa. ");
INSERT INTO kqe_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkawas ni Isa sang bangka, syosongon dayon yan ng sambok na otaw na yagasikun sang mga langob na pakoboran. Yani na otaw kyakasaytanan ");
INSERT INTO kqe_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","aw iyan yan magauya sang mga langob. Way otaw na makagapos kanan maskin pa bakoson yan ng kadina. ");
INSERT INTO kqe_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Makapila da nilan bakosa yang siki aw arima nan, awgaid pyapamogto da gaid nan yang mga kadina. Way sagaw otaw na makapogong kanan. ");
INSERT INTO kqe_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allaw-gabi yagapanaw-panaw yan ansang pakoboran aw adto oman sang kabtayan. Yabay yan magpangiyak aw pyaparian nan yang lawas nan ng mga bato. ");
INSERT INTO kqe_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Adon, pagkita sinyan na otaw kang Isa maskin mawat pa yan, dyomaagan yan aw syomojod sang atobangan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ansinyan yagalaong si Isa sang saytan na yakalasak sinyan na otaw, “Saytan, logwa da sini na otaw!” Yamangiyak yang saytan aw laong nan ng matanog, “Kay Isa, Anak ng Tohan na Labi na Makagwas, ono yang labot mo kanak? Pangayoon ko sang ngaan ng Tohan na di mo ako isiksaun!” ");
INSERT INTO kqe_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ansinyan yagaosip kanan si Isa, “Sino yang ngaan mo?” Tyomobag yan, “Yang ngaan ko si Panon kay madaig kami.” ");
INSERT INTO kqe_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ansinyan yagapakilooy yan kang Isa na di nan silan papanawon sikun sinyan na banwa. ");
INSERT INTO kqe_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, madaig yang mga binatang na yanagdowang ansang kilid ng butay. ");
INSERT INTO kqe_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yagapakilooy da yang mga saytan kang Isa aw laong nilan, “Pakadtowa da gaid kami adto sidtong mga binatang. Pasuuda kami adto kanilan.” ");
INSERT INTO kqe_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na, tyotogotan da silan ni Isa. Ansinyan lyomogwa da yang mga saytan sikun sang lawas sinyan na otaw aw lasak silan sidtong mga binatang. Aw yang kariko ng mga binatang dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangkalumus. Yang kadaig nilan mga 2,000. ");
INSERT INTO kqe_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod aw sang makilibot na mga baryo aw gyogogod nilan sang mga otaw idtong kyakatamanan. Agaw, yagasingadto da yang mga otaw antak tanawon nilan daw ono yang yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagdatung nilan adto kang Isa, kikita nilan na yagaingkod ansan idtong otaw na pyapanawan da ng saytan. Yamandagom da yan aw yomori da yang madyaw na dumduman nan. Na, yamangkalluk da silan. ");
INSERT INTO kqe_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yangaong yakakita sang kyakatamanan yagagogod sang mga otaw daw ono yang yamaitabo sidtong otaw na pyapanawan da ng saytan kipat sidtong mga binatang. ");
INSERT INTO kqe_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pagdungug sinyan yagapakilooy yang mga otaw kang Isa na apanawan da nan yang banwa nilan. ");
INSERT INTO kqe_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ansinyan pagsakay ni Isa sang bangka kay mapanaw da yan, yagapakilooy kanan yang idtong otaw na kong mapakay paagadun yan. ");
INSERT INTO kqe_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Awgaid wa osogot si Isa aw laong nan kanan, “Ori da adto kamayo aw paggogod kanilan daw ono yang ininang kanmo ng Tohan aw monono yang pagkallat nan kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Agaw pyomanaw da idtong otaw aw pyagapayapat nan adto sang mga banwa na sakop ng Dikapolis daw ono yang ininang kanan ni Isa. Aw yamangkatingaa da yang kariko ng mga otaw na yamakadungug sinyan. ");
INSERT INTO kqe_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ansinyan tyomaripag da oman si Isa sang linaw. Pagdatung nan adto dipag, madaig yang mga otaw na yanagtipon adto kanan. ");
INSERT INTO kqe_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ansinyan dyomatung yang sangka otaw na pyagangaanan ni Yairos na isa sang mga pangoo ng pagsasambayangan ng mga Yahodi disinyan na banwa. Pagkita nan kang Isa, syomojod yan sang atobangan nan ");
INSERT INTO kqe_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aw yagapakilooy yan, laong nan, “Yang anak ko na bobay yagapinal da. Aw mapakay kanmo, kadtowi yan aw dapuni ng arima mo kay antak magkadyaw yan aw mabowi pa yan.” ");
INSERT INTO kqe_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Agaw yamagad si Isa kanan. Madaig oman yang mga otaw na yamagad kanilan aw yanagdinutdutay silan adto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Adon, aon sambok na bobay ansan na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. ");
INSERT INTO kqe_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Madaig da yang kasikotan na yaagian nan sang pagpatambal sang madaig na mananambalay. Yaobos da yang kariko ng kanan sapi awgaid wa pa akadyaw, kondi yallabi pa yang kanan pagkasakit. ");
INSERT INTO kqe_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Adon, yamakadungug yan ng makapantag kang Isa. Agaw, ansang tunga ng mga otaw yodood yan kang Isa sikun sang likod nan aw kuputi nan yang dagom nan. ");
INSERT INTO kqe_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kay yagalaong yan sang ginawa nan, “Aw makakuput gaid ako sang dagom ni Isa, amadyaw da ako.” ");
INSERT INTO kqe_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na, pagkuput nan sang dagom ni Isa, yomondang dayon yang pagagas ng dogo nan aw byabati nan na yamadyaw da yan sikun sang kanan sakit. ");
INSERT INTO kqe_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na, sinyan dayon kyakatigaman ni Isa na aon kabarakat na lyomogwa sikun kanan. Agaw, ilingi yan sang mga otaw aw yagaosip yan, “Sino kadi yang yagakuput sang dagom ko?” ");
INSERT INTO kqe_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tyomobag yang mga inindowan nan, “Kikita mo na madaig yang mga otaw na yanagdinutdutay kanmo. Nanga sa yagaosip pa kaw daw sino yang yagakuput kanmo?” ");
INSERT INTO kqe_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Awgaid yagapanlingi-lingi pa si Isa antak tanawon nan daw sino yang yagakuput kanan. ");
INSERT INTO kqe_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Adon, sabap ng kyakatigaman ng bobay daw ono yang yamaitabo kanan, yodood yan kang Isa na tyatakigan sabap sang alluk nan. Syomojod yan sang atobangan nan aw yagalaong yan ng kabunnaan. ");
INSERT INTO kqe_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ansinyan yagalaong kanan si Isa, “Kay Bodi, sabap sang pagpangintoo mo yamadyaw da kaw. Panaw da na aon kalinaw kay waa day sakit mo.” ");
INSERT INTO kqe_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sarta yagatiyab pa si Isa, aon dyomatung na mga otaw sikun sang baay ni Yairos na pangoo ng pagsasambayangan nilan. Yagalaong silan kang Yairos, “Yamatay da yang anak mo. Ayaw da pagdistorbowa yang goro.” ");
INSERT INTO kqe_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Awgaid yamakadungug sinyan si Isa aw laong nan kang Yairos, “Ayaw magkalluk. Pagpangintoo gaid.” ");
INSERT INTO kqe_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ansinyan wa otogoti ni Isa yang maskin sino na amagad kanan yatabiya si Pitros aw yang maglomon na si Yakob aw si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagdatung nilan sang baay ni Yairos, kikita ni Isa na yagakasamok yang mga otaw aw madaig yang yanagtiyao aw yanagminatay ng matanog. ");
INSERT INTO kqe_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagsuud ni Isa, yagalaong yan kanilan, “Nanga sa bali na kasamok mayo? Nanga sa yagatiyao kamo? Dili ng patay yang isu kondi yamatoog gaid yan.” ");
INSERT INTO kqe_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na, inikuan da gaid nilan si Isa. Agaw pyapalogwa da ni Isa yang kariko nilan. Tapos, pyagaagad nan yang ama aw ina ng isu kipat sang toongka otaw na mga inindowan nan aw syomuud silan sang kowarto na pyagakowangan ng isu. ");
INSERT INTO kqe_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ansinyan kyukuputan ni Isa yan arima ng isu aw yagalaong yan, “Talita komi,” na yang mana sinyan, “Kay Bodi, bangon da.” ");
INSERT INTO kqe_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ansinyan yagabangon dayon yang isu aw magpanaw-panaw. Sampoo aw dowangka toig yang idad nan. Aw yamangkatingaa da yang mga yakakita sinyan. ");
INSERT INTO kqe_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Awgaid syasagda silan ni Isa na di silan maggogod sang maskin sino ng makapantag sinyan. Aw pyagalaong nan silan na apakanun da nilan yang isu. ");
INSERT INTO kqe_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ansinyan pyomanaw si Isa sinyan na banwa aw yomori yan adto sang Nasarit, yang longsod na tyotorinan nan. Aw yamagad oman kanan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pagdatung ng Allaw ng Pagpatana, yagaosiyat si Isa adto sang pagsasambayangan ng mga Yahodi. Madaig yang mga otaw ansan aw pagdungug nilan sang pagosiyat nan, yamatingaa silan aw laong nilan, “Wain yani na otaw makakamang sini na katigam? Aw wain yan sang kabarakat paginang sini na mga katingaan? ");
INSERT INTO kqe_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Di ba yani yang panday, yang anak ni Mariyam aw yang mga lomon nan si Yakob, si Yosis, si Yodas aw si Simon? Di ba, adi oman magauya yang mga lomon nan na bobay?” Aw wa nilan atarimaa si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Agaw yagalaong kanilan si Isa, “Yang nabi pyagaaddatan ng mga otaw maskin wain, yatabiya adto sang kanan banwa, sang kanan mga kadogo aw adto sang kanan baay.” ");
INSERT INTO kqe_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Idto sagaw, wa yan makainang ng katingaan sidto na banwa yatabiya sang pilangka otaw na yamasakit na dyadapunan nan ng arima nan aw pyapakadyaw nan. ");
INSERT INTO kqe_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aw yamatingaa si Isa kay wa silan apangintoo kanan. Pagkatapos sinyan yamakarimpud si Isa komadto sang makilibot na mga banwa aw yagaindo yan sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ansinyan tyatawag nan yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw syosogo nan silan pagpanaw ng tagdowa. Yatagan nan silan ng kapatot pagpalogwa sang mga saytan ");
INSERT INTO kqe_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","aw yagalaong yan kanilan, “Sang pagpanaw mayo, ayaw kamo magdaa ng maskin ono yatabiya sang bangka. Ayaw kamo magdaa ng pagkan, lasakanan atawa sapi ansang bolsa mayo. ");
INSERT INTO kqe_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mapakay kamo magsandalyas, awgaid ayaw kamo magdaa ng ilisan mayo. ");
INSERT INTO kqe_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maskin wain na baay yang adatungan mayo, ansan da kamo maguya taman sang pagpanaw mayo sikun sinyan na banwa. ");
INSERT INTO kqe_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kong aon banwa na akadtowan mayo aw yang mga otaw ansan di magatarima kamayo ni amaningug sang pyaglaongan mayo, panawi mayo yan na banwa. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan.” ");
INSERT INTO kqe_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ansinyan pyomanaw da yang mga inindowan ni Isa aw yanagosiyat silan sang mga otaw na dait silan magtawbat sang mga dosa nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Madaig yang mga saytan na pyapalogwa nilan sikun sang mga otaw aw madaig yang mga masakitun na dyadamasan nilan ng lana aw pyapakadyaw nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ansinyan yamakadungug si Hirod na soltan sang Jalil ng makapantag sang ininang ni Isa kay yamabantog da yang ngaan nan sang kariko ng banwa. Aon mga otaw na yagalaong na si Isa kono si Yahiya na Magsosogboway na yamabowi oman, aw idto sagaw aon kono kabarakat nan paginang ng katingaan. ");
INSERT INTO kqe_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yang kadaigan oman yagalaong, “Si Nabi Iliyas kowaw yan.” Aw yang kadaigan oman yagalaong, “Nabi kowaw si Isa na magonawa sang mga nabi sangaon.” ");
INSERT INTO kqe_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Awgaid pagdungug sinyan ni Hirod yagalaong yan, “Si Yahiya kowaw yani na pyapaotodan ko ng oo. Yamabowi da oman yan!” ");
INSERT INTO kqe_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maynini yang pyaglaongan ni Hirod kay sangani pyapadakup nan si Yahiya, pyapagapos aw pyapapiriso nan. Ininang nan yani kay pyapangasawa nan si Hirodiya na asawa ng kanan lomon na si Pilip. ");
INSERT INTO kqe_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aw yabay yan paglaongon ni Yahiya, laong nan, “Di mapakay na pangasawaun mo yang asawa ng lomon mo. Sopak yan sang Hokoman.” ");
INSERT INTO kqe_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na, sabap sinyan maat yang ginawa ni Hirodiya adto kang Yahiya aw karim gao nan na apapatay si Yahiya. Awgaid way amainang nan ");
INSERT INTO kqe_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kay wa osogot si Hirod na apatayun si Yahiya. Kay dakowa yang addat ni Hirod kang Yahiya sabap ng kyakatigaman nan na si Yahiya matorid na otaw na yamangagad sang Tohan. Agaw, pyapabantayan nan si Yahiya adto sang pirisowan antak di yan amaono. Yamallini si Hirod maningug sang pagosiyat ni Yahiya maskin sagaw matag wakto na yagapaningug yan kanan, yamarido yang ginawa nan. ");
INSERT INTO kqe_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Awgaid sangallaw disinyan dyomatung yang wakto na yamatoman da yang kallini ni Hirodiya. Pagdatung ng allaw ng pagkaotaw ni Hirod, yagapakandori yan aw pyagaimbitar nan yang mga opisyales nan kipat sang mga kapitan ng mga sondao aw yang mga dato sang probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sarta yagakandori silan, dyomatung yang anak ni Hirodiya aw somayaw. Aw yamasowat sinyan si Hirod kipat sang kariko ng mga bisita nan. Agaw yagalaong si Hirod sidtong daaga, “Kay Bodi, ono yang karim mo? Maskin ono yang apangayoon mo, atag ko kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ansinyan yagapasad kanan si Hirod aw laong nan, “Sagaw, maskin ono yang apangayoon mo, abir pa katunga sang kanak pyagadatowan, atag ko kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Adon lyomogwa ansan yang daaga aw yagaosip yan sang kanan ina, “Kay ina, ono kadi yang apangayoon ko?” Tyomobag yang kanan ina, “Pangayowa yang oo ni Yahiya na Magsosogboway.” ");
INSERT INTO kqe_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ansinyan byomarik dayon yang daaga adto sang soltan aw paglaonga nan, “Kay soltan, yani yang apangayoon ko. Atagan kanak adon dayon yang oo ni Yahiya na Magsosogboway na yakabutang sang bandiya.” ");
INSERT INTO kqe_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na, pagdungug sinyan ng soltan, dakowa yang karidowan nan. Awgaid sabap ng yagapasad yan sang atobangan ng mga bisita nan, di da nan mabawi yang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Agaw, syosogo dayon ni Hirod yang sambok na sondao na adaun kanan yang oo ni Yahiya. Ansinyan pyomanaw da yang sondao aw otodi nan si Yahiya ng oo adto sang pirisowan. ");
INSERT INTO kqe_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagbarik nan, dyadaa nan yang oo ni Yahiya na yakabutang sang bandiya aw atagan sang anak ni Hirodiya, aw yatag oman nan adto sang kanan ina. ");
INSERT INTO kqe_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na, pagdungug sinyan ng mga inindowan ni Yahiya, kyakadtowan nilan yang lawas nan aw lubungan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ansinyan pagbarik ng mga sahabat ni Isa sikun sang pagpayapat, yanagkatipon silan adto kang Isa aw gogoda nilan kanan yang kariko ng ininang aw pyagaindo nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Awgaid sabap ng madaig yang mga otaw na yadatung aw yapanaw way gaid oras nilan maskin sang pagpangan. Agaw yagalaong si Isa sang mga inindowan nan, “Anda, makadto da kita sang mamingaw na banwa na kita da gaid antak makapatana kamo ng tagbis.” ");
INSERT INTO kqe_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Agaw syomakay da silan sang bangka aw kadto silan sang mamingaw na banwa na silan da gaid. ");
INSERT INTO kqe_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Awgaid madaig yang mga otaw na yakakita sang kanilan pagpanaw aw ikilaa silan kanilan. Agaw, sikun sang yagakatuna-tuna na mga banwa dyomaagan silan ansang kilid ng linaw aw yamaona silan domatung sang kyakadtowan nilan Isa. ");
INSERT INTO kqe_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagkawas ni Isa sang bangka, kikita nan yang kadaig ng mga otaw. Yamalooy yan kanilan kay main silan ng mga karniro na way magbabantayay. Ansinyan pyagaindowan nan silan ng madaig na mga butang. ");
INSERT INTO kqe_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagkakasilum disinyan dyomood kang Isa yang mga inindowan nan aw laong nilan, “Masaid da somallup yang suga aw mamingaw yani na banwa. ");
INSERT INTO kqe_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Madyaw pa aw pakadtoon mo yang mga otaw adto sang makilibot na mga baryo aw sityo antak silan makabili ng pagkan.” ");
INSERT INTO kqe_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Awgaid tyomobag si Isa kanilan, “Kamo da yang magpakan kanilan.” Yagalaong yang mga inindowan nan, “Monono da yan? Mapanaw ba kami aw magabili ng pan na yagakantidad ng soweldo ng waombowan antak apakan kanilan?” ");
INSERT INTO kqe_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ansinyan yagalaong si Isa kanilan, “Tanawa mayo daw pilambok yang pan mayo ansan.” Pagkatigam da nilan, tyomobag silan kang Isa, “Limambok yang pan aw dowamboos yang isda.” ");
INSERT INTO kqe_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ansinyan syosogo ni Isa yang mga inindowan nan na paingkodon nilan yang kariko ng mga otaw na magpondok-pondok ansang kasagbutan. ");
INSERT INTO kqe_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Agaw imingkod da silan sang mga pondok ng tag-100 aw tag-50. ");
INSERT INTO kqe_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ansinyan kyakamang ni Isa yang limambok na pan aw dowamboos na isda aw imingao sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga inindowan nan antak apangatag nilan adto sang mga otaw. Magonawa sinyan, pyagapingas-pingas nan yang dowamboos na isda kay ipangatag oman adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. ");
INSERT INTO kqe_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagtipon ng mga inindowan sang yamasama na pan aw isda, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na, yang kadaig ng mga otaw na yakakan, 5,000 yang kausgan da gaid. ");
INSERT INTO kqe_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkatapos sinyan pyapasakay ni Isa yang mga inindowan nan sang bangka. Syosogo nan silan na amaona adto dipag sang banwa ng Bitsayda sarta apapanawon nan yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nang pyapaori da nan silan, tyomokod yan sang butay antak magdowaa. ");
INSERT INTO kqe_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkagabi disinyan, adto da sang laod yang bangka na syasakayan ng mga inindowan, awgaid si Isa adto pa sang butay ng sayda nan. ");
INSERT INTO kqe_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ansinyan kikita nan na kyakasikotan yang mga inindowan nan pagbugsay kay yosongsong silan sang makusug na samut. Na, pagkakadlawon kyakadtowan silan ni Isa na yagapanaw sang babaw ng tobig. Malabay gao yan kanilan, ");
INSERT INTO kqe_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","awgaid pagkita nilan na yagapanaw yan sang babaw ng tobig, yamangiyak silan kay yagadumdum silan na molto yan. ");
INSERT INTO kqe_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yang kariko nilan yakakita kanan aw labi da yang alluk nilan. Awgaid yagalaong dayon si Isa, “Ayaw kamo magkalluk. Ako sa yani. Pakatigsuna mayo yang pangatayan mayo.” ");
INSERT INTO kqe_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ansinyan syomakay yan sang bangka aw yomondang dayon yang samut. Yamatingaa da yang mga inindowan nan ");
INSERT INTO kqe_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kay maskin kikita nilan yang ininang ni Isa na pyapakan nan yang 5,000 na mga otaw, wa silan makasabot sang mana ng kikita nilan kay matigas yang oo nilan. ");
INSERT INTO kqe_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ansinyan pagtaripag da nilan sang linaw, dyomatung silan sang banwa ng Ginisarit aw adto da silan magadonggo. ");
INSERT INTO kqe_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkawas nilan sang bangka, ikilaa dayon si Isa ng mga otaw ansan. ");
INSERT INTO kqe_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Agaw yanagdaagan silan adto sang makilibot na mga banwa antak pakatigamun nilan yang mga otaw na iyan da si Isa. Ansinyan dyadaa da nilan yang mga masakitun na yakabutang sang kowangan adto sidtong banwa daw wain si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Agaw, maskin wain akadto si Isa, daw sang mga baryo atawa longsod atawa sang mga sityo adto sang bokid, dyadaa nilan yang mga masakitun adto sang palengke na pyagakatiponan ng mga otaw. Aw yamangayo-ayo silan kang Isa na kong mapakay kuputan ng mga masakitun maskin yang sagyadan da gaid ng kanan dagom. Aw yang kariko na yakakuput sang dagom nan yamadyaw. ");
INSERT INTO kqe_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ansinyan aon mga Parisi aw mga magiindoway ng Hokoman sikun sang Awrosalam na yanagkatipon adto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kikita nilan na yang kadaigan ng mga inindowan ni Isa yanagpangan na wa silan makapangonaw. Aw sang dumduman nilan batar kono silan. ");
INSERT INTO kqe_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kay yang mga Parisi aw maskin oman yang kariko ng mga Yahodi, di silan makan kong wa pa silan makapangonaw sobay sang kabatasanan ng kaompowan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pagori nilan sikun sang palengke, di oman silan makan kong wa pa silan makapangonaw. Na, madaig pa yang mga sogowan ng kaompowan nilan na pyapangagadan nilan na magonawa sang pagpangogas ng mga baso, mga koon aw yang mga ladya na bronsi. ");
INSERT INTO kqe_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Agaw adon, idtong mga Parisi kipat sang mga magiindoway ng Hokoman, yagaosip silan kang Isa, “Nanga sa wa apangagad yang mga inindowan mo sang kabatasanan ng kaompowan ta? Nanga sa yakan silan na wa silan makapangonaw?” ");
INSERT INTO kqe_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tyomobag si Isa, “Kamo na yagapakita-kita gaid na yamangagad sang Tohan! Bunna sagaw yang pyaglaongan ng Tohan makapantag kamayo pinaagi kang Nabi Isayas. Kay yamakasorat sang Kitab na yagalaong yang Tohan, “ ‘Yani na mga otaw yagapoji kanak sang baba gaid nilan, awgaid mawat kanak yang pangatayan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Way poos yang pagibada nilan kanak kay yang pyagaindo nilan mga sogowan na ininang gaid ng otaw, awgaid laong nilan na sogowan kono inyan ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Idto sagaw,” laong ni Isa, “tyatarikodan da mayo yang sogowan ng Tohan aw yang pyapangagadan mayo yang kabatasanan ng otaw.” ");
INSERT INTO kqe_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yagalaong oman si Isa, “Matigam sagaw kamo maginang ng daan na akataripundaan mayo yang sogowan ng Tohan kay antak kapangagadan mayo yang pyagaindo ng kaompowan mayo. ");
INSERT INTO kqe_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kay maynini yang pyaglaongan ng Tohan na yamakasorat sang Hokoman ni Nabi Mosa, laong nan, ‘Addati mayo yang ama aw ina mayo.’ Aw ‘sino-sino yang magalaong ng maat adto sang ama atawa ina nan, dait yan patayun.’ ");
INSERT INTO kqe_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Awgaid tuna yang pyagaindo mayo kay yagalaong kamo na yang otaw na magalaong adto sang ama atawa ina nan na ‘Yang tabang na atag ko gao kanmo korban da,’ mana nan na yatag da kono nan adto sang Tohan, ");
INSERT INTO kqe_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na, kong maynan, mapakay na di da nan atabangan yang taganak nan. ");
INSERT INTO kqe_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Agaw, sabap sang kabatasanan ng kaompowan mayo na pyagaindo oman mayo sang mga otaw, tyataripundaan da mayo yang sogowan ng Tohan. Aw madaig pa yang ininang mayo na magonawa sinyan.” ");
INSERT INTO kqe_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ansinyan tyatawag da oman ni Isa yang mga otaw na modood silan kanan aw pyagalaong nan silan, laong nan, “Paningug kamo, obos kamo, aw sabta mayo yang pagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yang makabatar sang otaw dili ng pagkan na alasak nan sang baba nan kondi yang maat na pyaglaongan na mologwa sikun sang baba nan. ");
INSERT INTO kqe_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkatapos sinyan pyapanawan ni Isa yang mga otaw aw syomuud yan sang sambok na baay. Ansinyan yanagosip kanan yang mga inindowan nan daw ono yang mana sidto na pasombingay. ");
INSERT INTO kqe_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yagalaong si Isa, “Na, maskin oman kamo, wa kadi kamo makasabot? Wa kadi kamo akatigam na yang maskin ono na akanun ng otaw di amakabatar kanan? ");
INSERT INTO kqe_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kay yang pagkan di amalasak sang pangatayan kondi sang tongol aw mologwa da oman sikun sang lawas.” Na, sabap sinyan na pyaglaongan ni Isa pyapakatigam nan kanilan na halal yang kariko ng pagkan. ");
INSERT INTO kqe_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yagalaong oman si Isa, “Na, yang magasikun sang pangatayan ng otaw, idto yang amakabatar kanan. ");
INSERT INTO kqe_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay sikun adto suud ng pangatayan ng otaw yang maat na dumduman na magonawa sang paginang ng kadopangan, yang pagpangawat, yang pagpatay sang otaw aw yang pagjina. ");
INSERT INTO kqe_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Adto oman magasikun yang napso sang mga butang ng kadaigan, yang paginang ng kaatan, yang pagpanlimbong, pagkasina, pagpitna, pagpasigarbo aw yang paginang ng maskin ono na kamasiyatan aw kasanguan. ");
INSERT INTO kqe_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yang kariko sining kaatan yagasikun sang pangatayan ng otaw, aw idto yang amakabatar kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ansinyan pyomanaw si Isa ansan aw kyomadto yan sang logar na masaid sang syodad ng Tiros. Pagdatung nan adto, pyomanik yan sang sambok na baay, awgaid di nan karim na akatigaman ng mga otaw na iyan yan san. Awgaid di sagaw matago. ");
INSERT INTO kqe_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na, aon sambok na bobay disidto na yang anak nan na bobay kyakasaytanan. Pagdungug nan na iyan si Isa, kyomadto dayon yan aw syomojod sang atobangan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na, yani na bobay dili ng Yahodi awgaid taga Piniki na sakop ng Siriya. Yagapakilooy yan kang Isa na palogwaun nan yang saytan sikun sang anak nan. ");
INSERT INTO kqe_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Awgaid yagalaong kanan si Isa ng pasombingay, laong nan, “Dait na ona pakanun yang mga isu kay dili ng madyaw aw kamangun yang pagkan ng mga isu aw itimbag adto sang mga ido.” ");
INSERT INTO kqe_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tyomobag yang bobay, “Bunna sagaw, kay Sir. Awgaid maskin yang mga ido sang saad ng lamisa makakan sang yamasama ng mga isu.” ");
INSERT INTO kqe_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ansinyan yagalaong kanan si Isa, “Sabap sini na pyaglaongan mo yamadyaw da yang anak mo. Makaori da kaw kay pyapanawan da ng saytan yang anak mo.” ");
INSERT INTO kqe_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agaw yomori da yang bobay. Aw pagdatung nan sang baay, kikita nan yang anak nan na yagakowang sang kowangan na pyapanawan da ng saytan. ");
INSERT INTO kqe_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ansinyan pyomanaw da oman si Isa sikun sidtong logar na sakop ng Tiros. Sang pagpanaw nan yamagi yan sang Sidon, tapos pyomanaos yan adto sang Linaw ng Jalil sang logar na sakop ng probinsya ng Dikapolis. ");
INSERT INTO kqe_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Adon, aon mga otaw disidto na yagadaa adto kanan ng sambok na otaw na bungul aw amang aw yagapakilooy silan kanan na dapunan nan idtong otaw ng arima nan. ");
INSERT INTO kqe_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ansinyan pyagalain yan ni Isa sang kadaigan na mga otaw aw lyalasak nan yang kanan tollo sang taringa nan. Pagkatapos, tyotobadan nan yang tollo nan aw dyodoritan nan ng laway yang dila sinyan na otaw. ");
INSERT INTO kqe_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ansinyan imingao si Isa sang langit, yaganapas ng maum aw yagalaong sinyan na otaw, “Ipata!” na yang mana san, “Pagboka da!” ");
INSERT INTO kqe_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na, yakadungug dayon inyan na otaw aw yakapagtiyab da yan ng madyaw kay wa da odukut yang dila nan. ");
INSERT INTO kqe_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ansinyan syasagda ni Isa yang mga otaw na di silan maggogod sang maskin sino ng makapantag sinyan. Awgaid maskin monono yang pagsagda nan kanilan, labi da yang paggogod nilan adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na, yamangkatingaa da yang mga otaw na yamakadungug sinyan aw laong nilan, “Madyaw sagaw yang kariko ng ininang nan. Maskin yang mga bungul pyapadungug nan aw yang mga amang pyapagtiyab nan.” ");
INSERT INTO kqe_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wa akadogay disinyan yanagkatipon da oman yang madaig na mga otaw adto kang Isa. Nang kyakaobosan silan ng pagkan, pyapadood ni Isa yang mga inindowan nan aw paglaonga silan, ");
INSERT INTO kqe_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yamalooy ako sini na mga otaw kay too pang allaw na yamagad silan kanak aw adon waa day pagkan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aw paoriun ko silan na yamangkagutum, basin aon amalango-lango kanilan sang daan kay mawat yang pyagasikunan ng kadaigan kanilan.” ");
INSERT INTO kqe_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yagalaong kanan yang mga inindowan nan, “Wain kita makakamang ng apakan kanilan disining banwa na mamingaw?” ");
INSERT INTO kqe_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Pilambok yang pan mayo ansan?” yagaosip kanilan si Isa. Tyomobag silan, “Pitombok da.” ");
INSERT INTO kqe_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ansinyan pyapaingkod ni Isa yang mga otaw sang lopa. Kyakamang nan yang pitombok na pan aw panginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan aw atagan sang mga inindowan nan antak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aon oman pipila na mangkayantuk na isda nilan. Pagkatapos ni Isa manginsokor, syosogo nan yang mga inindowan nan na ipangatag oman adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ansinyan kyoman da yang kariko ng mga otaw aw yamangkabiyag silan. Pagkatapos nilan koman, titipon ng mga inindowan yang yamasama na pagkan, aw pitombok yang bokag na yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na, yang kadaig ng yakakan, mga 4,000. Ansinyan pyapaori da ni Isa yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagkatapos syomakay yan sang bangka upud sang mga inindowan nan aw kyomadto silan sang banwa ng Dalmanota. ");
INSERT INTO kqe_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagdatung nilan ansan, aon mga Parisi na yodood kang Isa kay mapaglalis gao silan kanan. Karim nilan magtigi kanan, agaw yamangayo silan kanan ng katingaan silbi tanda na syosogo yan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ansinyan yaganapas si Isa ng maum aw laong nan kanilan, “Nanga sa yabay mangayo ng tanda yang mga otaw adon na panahon? Pagalaong ko kamayo na way gaid tanda na apakita ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ansinyan pyapanawan da silan ni Isa upud sang mga inindowan nan. Byomarik silan sang bangka aw tyomaripag da oman silan sang linaw. ");
INSERT INTO kqe_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Adon, yang mga inindowan ni Isa yakaringaw magdaa ng baon nilan. Way pagkan nilan sang bangka yatabiya sang sambok gaid na pan. ");
INSERT INTO kqe_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo sang labadora ng mga Parisi aw ni Soltan Hirod.” ");
INSERT INTO kqe_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ansinyan yanagbaaw-baaw silan aw laong nilan, “Basin maynidto yang pyagalaong nan kay wa kita magadaa ng pan.” ");
INSERT INTO kqe_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Awgaid kyakatigaman ni Isa yang pyagabaawan nilan. Agaw yagalaong yan kanilan, “Nanga sa yanagbaaw-baaw kamo na way yamadaa mayo na pan? Wa pa kadi kamo makasabot? Mairap sa kadi kamo pagindowan. ");
INSERT INTO kqe_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aon mata mayo, awgaid di kamo makakita. Aon taringa mayo, awgaid di kamo makadungug. Kyakaringawan da mayo ");
INSERT INTO kqe_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","na pyagapingas-pingas ko yang limambok na pan antak makakan yang 5,000 na mga otaw? Pilambok yang bokag na yamapono mayo ng yamasama?” Tyomobag silan, “Sampoo aw dowa.” ");
INSERT INTO kqe_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Laong oman ni Isa, “Sang pagpingas-pingas ko ng pitombok na pan antak makakan yang 4,000 na mga otaw, pilambok yang bokag na yamapono mayo ng yamasama?” Tyomobag silan, “Pito.” ");
INSERT INTO kqe_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na,” laong nan, “nanga sa wa pa kamo makasabot na dili ng pan yang karim ko ipasabot?” ");
INSERT INTO kqe_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ansinyan pagdatung nilan sang baryo ng Bitsayda, aon mga otaw na yagadaa ng bota adto kang Isa aw yagapakilooy silan kanan na dapunan nan idtong bota ng arima nan. ");
INSERT INTO kqe_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ansinyan kyukuputan ni Isa yang arima ng bota aw pagagadan nan adto sa logwa ng baryo. Ansidto tyotobadan ni Isa yang mata ng bota aw dapuni nan ng arima nan. Ansinyan yosip ni Isa yang bota, “Aon day kikita mo?” ");
INSERT INTO kqe_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Imingao yang otaw aw laong nan, “Makakita da ako ng mga otaw na yagapanaw-panaw, awgaid main silan ng kaoy.” ");
INSERT INTO kqe_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agaw, dyadapun da oman ni Isa yang arima nan sang mata ng bota. Na, pagtanaw nan, yakakita da yan aw matinaw da yang kanan pananaw. ");
INSERT INTO kqe_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ansinyan pyapaori yan ni Isa aw laong nan kanan, “Ori da, awgaid ayaw magapit adto sang baryo.” ");
INSERT INTO kqe_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ansinyan pyomanaos si Isa aw yang mga inindowan nan adto sang mga baryo na masaid sang longsod ng Kisariya Pilipi. Sarta yagapanaw silan yagaosip si Isa sang mga inindowan nan, laong nan, “Sobay sang mga otaw, sino kono ako?” ");
INSERT INTO kqe_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas, aw yang kadaigan oman yagalaong na ikaw kono yang sambok na nabi sangaon.” ");
INSERT INTO kqe_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Awgaid kamo,” laong ni Isa, “ono yang akapaglaong mayo daw sino ako?” Tyomobag si Pitros, “Ikaw yang Almasi.” ");
INSERT INTO kqe_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ansinyan syasagda silan ni Isa na di silan maggogod sang maskin sino daw sino yan. ");
INSERT INTO kqe_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ansinyan yagasogod si Isa magindo sang mga inindowan nan aw yagalaong yan kanilan, “Ako na Anak ng Manosiya, dait na amagi ako ng mga kasikotan. Ataripundaan ako ng mga pangoo ng mga Yahodi, mga pangoo ng mga imam kipat oman sang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoong allaw amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na, mapayag kanilan yaning pyaglaongan ni Isa. Agaw pagdungug sinyan ni Pitros, pyagaagad nan si Isa sang mawat-awat sang kadaigan aw sagdaa nan na di yan maglaong ng mayninyan. ");
INSERT INTO kqe_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Awgaid yagaatobang si Isa sang mga inindowan nan aw kyakadamanan nan si Pitros, laong nan, “Panaw da, kay Iblis! Kay yang dumduman mo dili ng kahanda ng Tohan kondi yang dumduman gaid ng manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ansinyan tyatawag ni Isa yang mga otaw kipat sang mga inindowan nan antak domood silan kanan aw yagalaong yan kanilan, “Sino-sino yang marim mangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqe_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kay sino-sino na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyapalabi nan yang pagpangagad nan kanak aw yang pagpayapat sang Madyaw na Gogodanun maskin idto yang akamatay nan, akaonan ng bunna na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kay ono yang amakamang ng otaw kong amangkun nan yang kariko ng kakawasaan adi sang donya, awgaid kong amatay da yan isiksaun da yan adto sang narka? Waa! ");
INSERT INTO kqe_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay way akaatag nan antak kaonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na, bali na kaat ng mga otaw adon na panahon aw yagapakawat silan sang Tohan. Sino-sino yang yamasipug maglaong sang atobangan sini na mga otaw na yamangagad yan kanak kipat sang indowan ko, akasipug ko oman yan sang wakto na mabarik ako na Anak ng Manosiya adi sang donya sang kasiga ng kanak Ama na yagadan ako ng mga malaikat.” ");
INSERT INTO kqe_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ansinyan yagalaong oman si Isa adto sang mga inindowan nan, “Bunna yang pagalaong ko kamayo na aon mga otaw disini na di pa amatay taman sang ikitaun nilan na magadato da yang Tohan sang kanan kabarakat.” ");
INSERT INTO kqe_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, paglabay ng unum na allaw sikun disinyan pyagaagad ni Isa si Pitros, si Yakob aw si Yahiya aw tyomokod silan sang makagwas na butay na silan da gaid. Adto sa taas sarta yagatanaw silan kang Isa, yamaisab yang parangay nan. ");
INSERT INTO kqe_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yang kanan dagom yagakapoti aw masindaway na way main da nan na kapoti adi sang babawan ng donya. ");
INSERT INTO kqe_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sakadyap yagapakita kanilan si Nabi Mosa aw si Nabi Iliyas aw yapagbaaw silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ansinyan yagalaong si Pitros kang Isa, “Kay Goro, madyaw na ani kami sini. Magainang da kami ng toombok na payag, yang sambok kanmo, yang sambok kang Nabi Mosa aw yang sambok oman kang Nabi Iliyas.” ");
INSERT INTO kqe_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Maynini yang pyaglaongan nan kay wa yan akatigam daw ono yang dait nan paglaongon sabap ng labi da yang alluk nan kipat oman sang mga kaupdanan nan. ");
INSERT INTO kqe_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ansinyan aon yamaon na gabon aw kyakatabonan silan sinyan. Aw aon yamadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang pyapasaya ko na Anak. Paningug kamo kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ansinyan pagpanlingi nilan, waa day kikita nilan na kadaigan na bay dakman kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ansinyan pagtobang nilan sikun sang butay, syasagda silan ni Isa aw laong nan, “Ayaw kamo maggogod sang maskin sino sidtong kikita mayo taman sang amabowi oman ako na Anak ng Manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Agaw wa silan magagogod sinyan sang kadaigan. Awgaid silan too, yanaginosipay silan daw ono yang mana ng pyaglaongan nan na amabowi oman yan. ");
INSERT INTO kqe_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ansinyan yagaosip silan kang Isa, “Nanga sa yagalaong yang mga magiindoway ng Hokoman na madatung ona si Nabi Iliyas bago pa yang Almasi?” ");
INSERT INTO kqe_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tyomobag si Isa, “Bunna sagaw na madatung ona si Nabi Iliyas kay dadayawon nan yang kariko. Na, kong maynan, nanga sa yamakasorat sang Kitab na ako na Anak ng Manosiya dait amagi ng kasikotan aw ataripundaan ng mga otaw? ");
INSERT INTO kqe_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Awgaid pagalaong ko kamayo na dyomatung da si Nabi Iliyas aw ininang kanan ng mga otaw yang maskin ono na kyakallinian nilan magonawa sang yamakasorat sang Kitab makapantag kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ansinyan pagbarik nilan adto sang kadaigan na mga inindowan, kikita nilan na madaig yang mga otaw na yanaglibot kanilan. Aon oman mga magiindoway ng Hokoman na yapaglalis kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkita ng mga otaw kang Isa, yamatingaa silan aw dyomaagan dayon silan adto kanan aw panagsalam. ");
INSERT INTO kqe_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ansinyan yagaosip si Isa kanilan, “Ono yang pyagalalisan mayo?” ");
INSERT INTO kqe_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aon isa sang mga otaw na yotobag, “Kay Goro, dyadaa ko ani kanmo yang anak ko na usug kay kyakasaytanan yan aw di da yan makapagtiyab. ");
INSERT INTO kqe_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada wakto na suudan yan ng saytan, amatowad yan sang lopa, magabowa yang baba nan, mangoyagut yang onto nan aw amatoskig yang lawas nan. Pyapangayo da ko sang mga inindowan mo na palogwaun nilan yang saytan, awgaid di silan makagaga.” ");
INSERT INTO kqe_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yagalaong si Isa sang mga otaw, “Astaga! Kamo na mga otaw adon na panahon, waa say pagpangintoo mayo! Kadogay da ako ani kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi kanak yang isu.” ");
INSERT INTO kqe_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Agaw dyadaa nilan adto kanan yang isu. Pagkita ng saytan kang Isa, pyapakorog dayon nan yang isu. Yamatowad yan aw yagaligid-ligid sang lopa na yagabowa yang kanan baba. ");
INSERT INTO kqe_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yagaosip si Isa sang ama ng isu, “Yadogay da ba yaning isu ng mayninyan?” Tyomobag yang ama, “Ud, disti ng tagbi pa yan. ");
INSERT INTO kqe_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pyagatimbag yan maag ng saytan adto sang atoon aw adto oman sang tobig antak yan matay. Awgaid kong aon amainang mo, mallat kaw kanami aw tabangi kami!” ");
INSERT INTO kqe_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yagalaong kanan si Isa, “Nanga sa yagalaong kaw na kong aon amainang ko? Yang maskin ono amainang sidtong otaw na aon pagpangintoo.” ");
INSERT INTO kqe_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yagalaong dayon yang ama ng isu, “Yamangintoo ako, awgaid kolang pa. Tabangi ako antak kadogangan pa yang pagpangintoo ko.” ");
INSERT INTO kqe_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Adon, pagkita ni Isa na madaig yang mga otaw na yagapasingadi kanan, syasagda nan yang saytan aw laong nan, “Ikaw na saytan na makaamang aw makabungul, panawi adon yani na isu aw ayaw da magbarik kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ansinyan yamangiyak yang saytan, pyapakorog nan yang isu aw logwa. Paglogwa ng saytan, maynang patay da yang isu. Agaw yagalaong yang kadaigan, “Patay da yan.” ");
INSERT INTO kqe_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Awgaid kyukuputan ni Isa yang arima ng isu aw painduga nan. Ansinyan imindug da yang isu. ");
INSERT INTO kqe_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, pagsuud ni Isa sang baay, yagaosip kanan yang mga inindowan nan nang silan da gaid, laong nilan, “Nanga sa wa kami makapalogwa sidto na saytan?” ");
INSERT INTO kqe_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tyomobag si Isa kanilan, “Yang mayninyan na klasi na saytan di mapalogwa yatabiya pinaagi sang pagdowaa.” ");
INSERT INTO kqe_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ansinyan pyomanaw si Isa kipat sang mga inindowan nan sikun sidto na banwa aw yamagi silan sang probinsya ng Jalil. Dili karim ni Isa na akatigaman ng mga otaw daw wain yan ");
INSERT INTO kqe_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay yagaindo yan sang mga inindowan nan. Yagalaong yan kanilan, “Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot aw apatayun ako nilan. Awgaid sang ikatoong allaw sikun sang kanak pagkamatay amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Awgaid wa silan makasabot sidto na pyaglaongan nan. Aw yamalluk silan magosip kanan. ");
INSERT INTO kqe_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ansinyan dyomatung da silan sang longsod ng Kapirnaom. Nang iyan da silan sang baay, yagaosip si Isa sang mga inindowan nan, “Ono yang pyagalalisan mayo adto sang daan?” ");
INSERT INTO kqe_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Awgaid yagapakatingun gaid silan kay yanaglalis silan daw sino kanilan yang labaw. ");
INSERT INTO kqe_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ansinyan imingkod si Isa, pyapadood nan yang sampoo aw dowa na sahabat nan aw yagalaong yan kanilan, “Sino-sino yang mallini mainang ng labaw sang kadaigan, dait yan magpababa sang ginawa nan aw mainang ng sogowanun sang kariko.” ");
INSERT INTO kqe_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ansinyan kyakamang ni Isa yang sambok na isu aw painduga nan sang atobangan nilan. Sisipit nan yang isu aw yagalaong yan kanilan, ");
INSERT INTO kqe_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sino-sino yang magatarima sang mga isu na main sini sabap sang pagpangagad nan kanak, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang Tohan na yagasogo kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ansinyan yagalaong si Yahiya kang Isa, “Kay Goro, aon kikita nami na otaw na yagapalogwa sang mga saytan na lyalambit nan yang ngaan mo. Syasagda nami yan kay di yan inagad natun.” ");
INSERT INTO kqe_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Awgaid yagalaong kanan si Isa, “Ayaw mayo yan pagsagdaa. Kay sino-sino yang makainang ng katingaan sang kanak ngaan, di yan dayon makapaglaong ng maat makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kay yang maskin sino na di mapaglaban kanatun, matabang kanatun. ");
INSERT INTO kqe_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sang bunna-bunna pagalaong ko kamayo na sino-sino yang magpainum kamayo ng maskin tobig gaid sabap ng yamangagad kamo sang Almasi, sang way dowa-dowa abarasan yan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yagalaong oman si Isa, “Sino-sino yang amainang ng pyagasabapan na amakadosa yang maskin sambok sining tagbi na mga isu na yamangintoo kanak, madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw itimbag yan adto sang laod. ");
INSERT INTO kqe_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Idto sagaw, kong yang arima mo yang pyagasabapan na amakadosa kaw, otoda yan. Madyaw pa na yamaotod yang sangkilid na arima mo, awgaid akaonan kaw ng kinabowi na way kataposan kaysang dowambok yang arima mo awgaid itimbag kaw adto sang narka, sang atoon na di amatay. ");
INSERT INTO kqe_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Magonawa sinyan, kong yang siki mo yang pyagasabapan na amakadosa kaw, otoda yan. Madyaw pa na yamaotod yang sangkilid na siki mo, awgaid akaonan kaw ng kinabowi na way kataposan kaysang dowambok yang siki mo awgaid itimbag kaw adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Aw kong yang mata mo yang pyagasabapan na amakadosa kaw, lusata yan. Madyaw pa na sambok gaid yang mata mo, awgaid amakasuud kaw sang sorga kaysang dowambok yang mata mo awgaid itimbag kaw adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kay adto sang narka way kataposan ng kasiksaan kay yang mga ood na yanagkutkut sang lawas ng mga otaw di amatay aw di oman amatay yang atoon.” ");
INSERT INTO kqe_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yagalaong oman si Isa, “Yang kariko ng mga otaw dait amagi ng kasikotan. Kay magonawa sang asin atawa atoon, yang kasikotan makakamang sang maskin ono na dili ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kyakatigaman mayo na madyaw yang asin. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. Agaw, magonawa sang asin na makatabang kanatun, kinaanglan na magtinabangay kamo aw madyaw yang relasyon mayo sang matag-isa.” ");
INSERT INTO kqe_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ansinyan pyomanaw da si Isa sang probinsya ng Jalil aw kyomadto sang mga banwa sang Yahodiya aw adto oman sang dipag ng tobig ng Yordan. Madaig oman yang mga otaw na yanagkatipon adto kanan aw inindowan nan silan sobay sang kyakaanadan nan. ");
INSERT INTO kqe_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ansinyan aon pilangka otaw na mga Parisi na dyomood kang Isa antak magtigi kanan. Yagaosip silan, “Sobay sang Hokoman mapakay ba na buagan ng usug yang asawa nan?” ");
INSERT INTO kqe_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tyomobag si Isa aw laong nan “Ono yang sogo kamayo ni Nabi Mosa?” ");
INSERT INTO kqe_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tyomobag silan, “Tyotogotan ni Nabi Mosa yang usug na magaatag ng sorat sang asawa nan silbi tanda na yanagbuag da silan, aw ansinyan mapakay da nan buagan yang asawa nan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yagalaong si Isa kanilan, “Bunna sa yan, awgaid syosorat ni Nabi Mosa yani na sogowan sabap ng matigas yang oo mayo. ");
INSERT INTO kqe_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Awgaid sang pukas pagbaoy ng Tohan sang donya, byabaoy nan yang otaw na usug aw bobay. ");
INSERT INTO kqe_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sabap sinyan ibiyaan ng usug yang kanan ama aw ina aw umupud sang asawa nan. ");
INSERT INTO kqe_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aw ansinyan magakasambok da silan. Agaw di da silan ng dowa kondi sambok da. ");
INSERT INTO kqe_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Idto sagaw, di mapakay pagpitasun ng otaw yang pyagakasambok ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ansinyan pagsuud nilan Isa sang baay na pyagauyaan nilan, yang mga inindowan da oman yang yagaosip kang Isa makapantag sidto na pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yagalaong si Isa kanilan, “Sino-sino yang magabuag sang kanan asawa aw amangasawa ng lain, magajina. ");
INSERT INTO kqe_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Magonawa sinyan, kong aon bobay na magabuag sang kanan bana aw magabana ng lain, magajina da oman yan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ansinyan aon mga otaw na yagadaa sang mangkatagbi na mga isu nilan adto kang Isa antak dapunan nan silan ng arima nan. Awgaid syasagda silan ng mga inindowan. ");
INSERT INTO kqe_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkita sinyan ni Isa, yamadaman yan aw yagalaong yan sang mga inindowan nan, “Pasagdi mayo yang mga isu na modood kanak. Kay yang mga otaw na main nilan yang amakasuud sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bunna yang pagalaong ko kamayo. Sino-sino yang di magapasakop sang pagdato ng Tohan na magonawa ng isu, di yan amakasuud sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ansinyan sisipit ni Isa yang mga isu, dyadapunan nan silan ng arima nan aw pyapangayowan nan silan ng kadyawan adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ansinyan sang wakto na mallug da manaw si Isa sidto na banwa, aon sangka otaw na dyomaagan adto kanan. Yolood yan sang atobangan nan aw yagalaong yan, “Kay Goro, madyaw kaw na otaw. Ono yang dait ko inangun antak kaonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqe_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tyomobag si Isa aw laong nan, “Nanga sa yagalaong kaw na ako madyaw? Yang Tohan gaid yang madyaw, aw way lain. ");
INSERT INTO kqe_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kyakatigaman mo kowaw yang mga sogowan na yagalaong, ‘Ayaw magpatay, ayaw magjina, ayaw magpangawat, ayaw magsaksi ng bakak, ayaw magpanlimbong aw addati yang ama aw ina mo.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Kay Goro,” laong ng otaw, “yang kariko sinyan tyotoman da ko sikun pa sang pagkaisu ko.” ");
INSERT INTO kqe_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ansinyan pyagatanawan yan ni Isa na aon looy aw laong nan, “Isa pa yang dait mo inangun. Ori da aw barigyaan yang kariko ng kabtangan mo aw yang alin atagan sang mga miskinan. Ansinyan akaonan kaw ng kakawasaan adto sang sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagdungug sinyan nidtong otaw, yamamingaw yan aw pyomanaw na yamarido yang ginawa nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqe_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ansinyan pyagatanawan ni Isa yang mga inindowan nan aw yagalaong yan kanilan, “Mairap sagaw sang mga sapian pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na, yamatingaa da yang mga inindowan sidto na pyaglaongan nan. Awgaid yagalaong oman si Isa, “Mga anak ko, mairap sagaw pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Masayun pa sang kamil pagagi sang botas ng dagum kaysang otaw na sapian pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na, bali da na pagkatingaa ng mga inindowan aw yanaginosipay silan, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqe_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ansinyan pyagatanawan silan ni Isa aw laong nan, “Sang manosiya, di yan amainang. Awgaid sang Tohan way mairap kay yang maskin ono amainang nan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ansinyan yagalaong kanan si Pitros, “Na, monono da kami adon? Bibiyaan da nami yang kariko aw yamagad kami kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Laong ni Isa, “Sang bunna-bunna pagalaong ko kamayo na sino-sino yang yagabiya sang kanan baay atawa sang mga lomon nan, sang ina aw ama, sang mga anak atawa lopa nan sabap sang pagpangagad nan kanak aw sabap oman sang pagpayapat ng Madyaw na Gogodanun, ");
INSERT INTO kqe_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","labaw pa sinyan yang amadawat nan adi sining donya na magonawa ng mga baay aw mga lomon, mga ina, mga anak, aw mga lopa maskin pa apakasikotan oman yan. Aw adto sang ahirat akaonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Awgaid madaig yang mga otaw na yamaona adon na amaori, aw madaig yang mga otaw na yamaori adon na amaona.” ");
INSERT INTO kqe_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ansinyan nang yagapasingadto silan sang Awrosalam, yagaona kanilan si Isa. Yang mga inindowan nan yamangkatingaa aw yang kadaigan pa na mga otaw na yamagad kanilan yamangkalluk daw ono yang akatamanan sang Awrosalam. Ansinyan pyagalain da oman ni Isa yang sampoo aw dowa na mga sahabat nan kay pagalaongon nan silan daw ono yang amaitabo kanan adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Laong nan kanilan, “Paningug kamo. Misingadto da kita sang Awrosalam. Disidto adaun ako na Anak ng Manosiya adto sang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw magahokom da silan na apatayun ako. Ansinyan adaun nilan ako adto sang mga dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Digay-digayun nilan ako aw otobadan, abadasan aw apatayun nilan ako. Awgaid sang ikatoong allaw sikun sang kanak pagkamatay amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ansinyan dyomood kang Isa si Yakob aw si Yahiya na mga anak ni Sibidi aw laong nilan, “Kay Goro, aon apangayoon nami kanmo na inangun mo kanami.” ");
INSERT INTO kqe_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yagalaong si Isa, “Ono yang karim mayo na inangun ko kamayo?” ");
INSERT INTO kqe_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tyomobag silan, “Sang wakto na magadato da kaw, karim nami na paingkodon mo kami sang kilid mo, yang isa sang karinto mo, aw yang isa sang kawaa mo.” ");
INSERT INTO kqe_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Awgaid yagalaong si Isa kanilan, “Wa kamo akatigam daw ono yang pyapangayo mayo. Kaagian ba mayo yang kasikotan na agian ko? Aw masabar ba mayo yang kasakit na abatiun ko?” ");
INSERT INTO kqe_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tyomobag silan, “Ud, kaya nami.” Ansinyan yagalaong si Isa kanilan, “Bunna sagaw na agian mayo yang kasikotan na agian ko aw asabaran mayo yang kasakit na abatiun ko. ");
INSERT INTO kqe_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Awgaid way kapatot ko maglaong daw sino yang paingkodon sang karinto aw kawaa ko, kay yang idto pyagakahanda ng kanak Ama sidtong mga otaw na pipili nan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, pagdungug sinyan ng sampoo na mga inindowan, yamadaman silan kang Yakob aw si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Agaw, pyapadood ni Isa yang kariko ng mga inindowan nan aw paglaonga silan, laong nan, “Kyakatigaman sa mayo yang batasan ansining donya na yang mga pangoo sang yagakatuna-tuna na bangsa magmando sang mga sakop nilan, aw yang mga yagadato kanilan magpakita sang kapatot nilan. ");
INSERT INTO kqe_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Awgaid kamo, dili gao ng maynan yang batasan mayo. Kay sino kamayo yang mallini mainang ng makagwas, dait yan mainang ng sogowanun mayo. ");
INSERT INTO kqe_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aw sino yang mallini mainang ng labaw sang kariko, dait yan mainang ng allang sang kariko. ");
INSERT INTO kqe_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kay maskin ako na Anak ng Manosiya, wa ako akani ansining donya antak tabangan ako ng mga otaw, kondi antak matabang ako kanilan aw magpakamatay ako sang paglowas ng madaig na mga otaw sikun sang mga dosa nilan.” ");
INSERT INTO kqe_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ansinyan dyomatung si Isa aw yang mga inindowan nan adto sang longsod ng Ariha. Pagpanaw da oman nilan, madaig yang mga otaw na yamagad kanilan. Na, adto sang daan na yaagian nilan aon sangka otaw na bota na yagaingkod ansan aw yagapakilimos. Yang ngaan nan si Bartimiyos na anak ni Timiyos. ");
INSERT INTO kqe_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagdungug nan na si Isa na taga Nasarit yang yalabay, yamangiyak yan, “O kay Isa, Anak ni Daud, kallati ako!” ");
INSERT INTO kqe_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ansinyan syasagda yan ng mga otaw antak magpakatingun. Awgaid lomban da yan mangiyak ng matanogay, “Anak ni Daud, kallati ako!” ");
INSERT INTO kqe_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ansinyan yomondang si Isa pagpanaw aw laong nan, “Pakadia yan kanak.” Agaw tyatawag ng mga otaw yang bota aw laong nilan, “Kasowat da aw pagindug kay tyatawag kaw ni Isa.” ");
INSERT INTO kqe_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na, titimbag dayon ng bota yang syasapaw nan aw indug aw dyomood yan adto kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yagaosip si Isa kanan, “Ono yang karim mo na inangun ko kanmo?” Tyomobag yang bota, “Kay Goro, karim ko makakita.” ");
INSERT INTO kqe_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yagalaong si Isa kanan, “Panaw da. Sabap sang pagpangintoo mo yamadyaw da kaw.” Ansinyan yakakita dayon yan aw yamagad yan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Adon nang masaid da silan sang Awrosalam aw iyan da silan sang mga baryo ng Bitpagi aw Bitani na adto sang Butay na Jayton, pyapaona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqe_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Pagsuud mayo ansan, aon makita mayo na nati ng asno na yukutan na wa pa gaid akasakayi. Obadi mayo aw daa adi kanak. ");
INSERT INTO kqe_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kong aon magaosip kamayo daw onoon mayo yan, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato. Apaori da oman nan mallaw.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, pyomanaw da yang dowa na inindowan aw pagdatung nilan sidtong baryo, kikita nilan yang nati ng asno ansang kilid ng daan na yukutan sang powertaan ng sambok na baay. Ansinyan yobadan da nilan. ");
INSERT INTO kqe_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nang yagaobad pa silan sang asno, yosip silan ng mga otaw na yagaindug ansan, laong nilan, “Oy, ono yang ininang mayo? Nanga sa yobadan mayo yang asno?” ");
INSERT INTO kqe_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na, tyotobag da nilan yang mga otaw sobay sang pyaglaongan kanilan ni Isa. Aw pyapasagdan da silan ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ansinyan dyadaa da nilan yang nati ng asno adto kang Isa, yampasan nilan ng mga dagom nilan aw syomakay da si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na, madaig yang mga otaw na yagabutang ng mga dagom nilan ansang daan na agian ni Isa. Yang kadaigan oman, pyapakanat nilan ansang daan yang mga sanga na madaig yang daon na pyopotol nilan adto sang lati. ");
INSERT INTO kqe_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yang mga otaw na yagaona kang Isa aw yang mga yagasonod kanan yamangiyak, laong nilan, “Pojiun ta yang Tohan! Atagan gao ng kadyawan yaning syosogo ng Tohan! ");
INSERT INTO kqe_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Atagan gao ng kadyawan yang magasalinti kang Soltan Daud na kanatun ompo! Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqe_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ansinyan pagdatung ni Isa sang Awrosalam, syomuud yan sang Baay ng Tohan aw pyagatanawan nan yang kariko adto sa suud. Awgaid sabap ng gabila da pyomanaw da yan upud sang sampoo aw dowa na mga sahabat nan aw barik silan sang banwa ng Bitani. ");
INSERT INTO kqe_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkailaw disinyan nang yagapanaw da oman silan sikun sang Bitani pasingadto sang Awrosalam, yamagutum si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ansinyan aon kikita nan sang onaan na kaoy na igira na madaig yang daon. Kyakadtowan nan inyan kay atanawon nan daw aon bonga. Pagdatung nan ansan, way kikita nan na bonga kondi mga daon gaid kay di pa wakto na mobonga yang igira. ");
INSERT INTO kqe_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ansinyan pyapaminta ni Isa idtong kaoy aw laong nan, “Sikun adon waa day makakan sang bonga mo.” Aw yamakadungug sinyan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ansinyan pagdatung nilan sang Awrosalam, syomuud si Isa sang Baay ng Tohan aw yagasogod yan magpalogwa sang mga otaw na yanagbarigya aw yamamili ansan. Pyagatowad nan yang mga lamisa ng mga yagakambiyo ng sapi aw yang mga ingkodanan ng yagabarigya ng mga salampati. ");
INSERT INTO kqe_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aw wa nan otogoti yang maskin sino na aon dyadaa na mga butang na amagi sang pamanag sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ansinyan yagaindo si Isa aw laong nan sang mga otaw, “Yamakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa para sang kariko ng mga bangsa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan.” ");
INSERT INTO kqe_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yamadungug nilan yang makapantag sidtong ininang ni Isa. Aw sikun sinyan na wakto yamanganap silan ng pamaagi sang pagpatay kanan. Yamalluk silan kang Isa kay yang kariko ng mga otaw yamatingaa sang pagindo nan. ");
INSERT INTO kqe_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ansinyan nang gabila da, pyomanaw da si Isa sikun sang Awrosalam upud sang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkailaw disinyan pagbarik nilan adto sang Awrosalam, yamagi oman silan sidtong kaoy na igira aw kikita nilan na yamagango da maskin pa yang mga gamot nan. ");
INSERT INTO kqe_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ansinyan kyakadumduman ni Pitros yang pyaglaongan ni Isa sidto na kaoy aw yagalaong yan kang Isa, “Kay Goro, tanawa pagaw yaning igira na pyapaminta mo, yamagango da!” ");
INSERT INTO kqe_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tyomobag si Isa, “Pagpangintoo kamo sang Tohan! ");
INSERT INTO kqe_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sang bunna-bunna pagalaong ko kamayo na sino-sino yang magalaong sini na butay, ‘Ballin adto sang dagat,’ aw di yan magdowa-dowa kondi mangintoo na amatoman yang pyaglaongan nan, amainang sagaw yan. ");
INSERT INTO kqe_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Agaw pagalaong ko kamayo na yang maskin ono na apangayoon mayo adto sang Tohan, kong mangintoo kamo na dyadawat da mayo yang pyapangayo mayo, amadawat da sagaw mayo. ");
INSERT INTO kqe_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na, kong magadowaa kamo awgaid yamadaman pa kamo sang yamakadosa kamayo, ampona mayo ona yan antak amponon oman yang mga dosa mayo ng Tohan na Ama mayo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Awgaid kong di mayo amponon yang yamakadosa kamayo, di oman amponon yang mga dosa mayo ng Tohan na Ama mayo adto sang sorga.” ");
INSERT INTO kqe_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ansinyan dyomatung da oman silan sang Awrosalam. Nang yagapanaw-panaw si Isa adto sa suud ng Baay ng Tohan, dyomood kanan yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yagaosip silan kanan, “Ono yang kapatot mo paginang sidto na mga butang? Sino yang yamatag kanmo sini na kapatot?” ");
INSERT INTO kqe_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tyomobag si Isa, “Aon oman osip ko kamayo. Kong matobag mayo, pagalaong ko oman kamayo daw wain magasikun yang kapatot ko paginang sidto na mga butang. ");
INSERT INTO kqe_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na, paglaonga ako daw wain magasikun yang kapatot ni Yahiya pagsogbo sang mga otaw, sang Tohan atawa sang manosiya?” ");
INSERT INTO kqe_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ansinyan yanagbaaw-baaw silan daw ono yang otobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun ‘Na, nanga sa wa kamo apangintoo kanan?’ ");
INSERT INTO kqe_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, magaproblima da kita.” Kay yamalluk silan sang mga otaw kay yang kariko nilan yamangintoo na bunna na nabi si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Agaw tyomobag silan, “Wa nami akatigami.” Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain magasikun yang kapatot ko paginang sidto na mga butang.” ");
INSERT INTO kqe_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ansinyan yagalaong si Isa kanilan ng pasombingay, laong nan, “Aon otaw na aon kanan lopa na pyagatanuman nan ng grips. Pyapakoral nan inyan aw yagapainang yan ng pagapugaan ng grips aw yagapatokod pa yan ng makagwas na baay antak mabantayan yang tanumanan. Ansinyan pyapaatiman nan yang kanan tanumanan sang mga sinarigan aw pyomanaw adto sang mawat na banwa. ");
INSERT INTO kqe_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sang panahon ng pagpangipo da ng grips, syosogo ng tagtomon yang sangka otaw na sogowanun nan adto sang mga sinarigan antak kamangun nan yang kanan bain ng abot. ");
INSERT INTO kqe_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Awgaid pagdatung nan sang tanumanan, dyadakup yan nidtong mga sinarigan, byobonalan yan aw pyapaori ng way daa. ");
INSERT INTO kqe_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ansinyan yagasogo da oman yang tagtomon ng sambok oman na sogowanun adto sang mga sinarigan. Awgaid pyapakasipugan nilan yan aw byobonalan nilan sang oo nan. ");
INSERT INTO kqe_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ansinyan yagasogo da oman yang tagtomon ng isa pa na sogowanun adto kanilan, awgaid pyapatay nilan yan. Na, madaig pa yang syosogo ng tagtomon adto kanilan, awgaid yang kadaigan byobonalan nilan aw yang kadaigan oman pyapatay nilan. ");
INSERT INTO kqe_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Adon, sangka otaw dakman yang yamabilin na amasogo ng tagtomon na yan yang pyapasaya nan na anak. Sang kataposan, syosogo nan yang kanan anak kay yagalaong yan sang ginawa nan, ‘Sang way dowa-dowa addatan nilan yan.’ ");
INSERT INTO kqe_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amangkun sang tanumanan. Anda, apatayun ta yan antak kanatun da yang kabilin kanan.’ ");
INSERT INTO kqe_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Idto sagaw, dyadakup nilan yan aw pyapatay nilan, aw titimbag nilan yang lawas nan adto sa logwa ng tanumanan. ");
INSERT INTO kqe_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na adon,” laong ni Isa, “ono yang inangun ng tagtomon ng tanumanan sidtong mga sinarigan? Sang way dowa-dowa akadtowan aw apatayun nan silan aw ipaatiman nan yang kanan tanumanan sang kadaigan pa na mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ansinyan yagalaong si Isa sang mga otaw, “Wa kadi mayo akabasa yang yamakasorat sang Kitab na yagalaong, “ ‘Yang bato na titimbag ng mga panday kay way kono kapantag, yamainang kadi ng labi na barapantag. ");
INSERT INTO kqe_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yani yang ininang ng Tohan aw bali yan na katingaan.’ ” ");
INSERT INTO kqe_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ansinyan adakupun da gao si Isa ng mga pangoo ng mga Yahodi kay kyakatigaman nilan na silan yang kyukugdan ni Isa sinyan na pasombingay. Awgaid way amainang nilan kay yamalluk silan sang kamangaotawan. Agaw pyapasagdan da nilan si Isa aw pyomanaw silan. ");
INSERT INTO kqe_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ansinyan aon pilangka otaw na mga Parisi aw mga otaw ni Soltan Hirod na syosogo nilan adto kang Isa antak magtigi kanan pinaagi sang mga osip. ");
INSERT INTO kqe_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pagdatung nilan kang Isa, yagalaong silan kanan, “Kay Goro, yamatigam kami na aag bunna yang pyagalaong mo. Di kaw magapili sang otaw na maskin ono yang ranggo nilan, awgaid aag kabunnaan yang pyagaindo mo makapantag sang karim ng Tohan. Adon, paglaonga kami daw sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sang Roma atawa di? Dait ba kita magbayad sinyan atawa dili?” ");
INSERT INTO kqe_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Awgaid kyakatigaman ni Isa yang toyo nilan, agaw yagalaong yan kanilan, “Kamo na yagapakita-kita gaid! Nanga sa karim mayo ako dakupun sang pyaglaongan ko? Atagan kanak yang sambok na sapi na pilak antak ko tanawon.” ");
INSERT INTO kqe_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ansinyan yatag nilan kanan yang sapi. Adon yosip silan ni Isa, “Kanino parangay aw ngaan yang yakabutang sini na sapi?” Tyomobag silan, “Kanang soltan sang Roma.” ");
INSERT INTO kqe_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ansinyan yagalaong si Isa, “Na, kong maynan, atag mayo sang soltan yang kanang soltan, aw atag oman mayo sang Tohan yang kanang Tohan.” Pagdungug nilan sinyan, bali na pagkatingaa nilan. ");
INSERT INTO kqe_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ansinyan aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. ");
INSERT INTO kqe_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yagaosip silan kang Isa, “Kay Goro, aon syosorat ni Nabi Mosa sang Hokoman na kong amatay yang usug ng way anak sang kanan asawa, dait na apangasawaun ng kanan lomon yan na biyoda antak kaonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqe_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Adon, aon pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. ");
INSERT INTO kqe_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Agaw, yang mangod na yagasonod kanan, pyapangasawa nan inyan na biyoda awgaid yamatay da oman yan na way anak. Maynan oman yang ikatoo taman sang yamatay da yang pito na maglomon na way anak. ");
INSERT INTO kqe_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqe_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Adon,” laong nilan, “sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay kay yang kariko ng pito na maglomon yakapangasawa kanan?” ");
INSERT INTO kqe_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tyomobag si Isa aw laong nan kanilan, “Sayup yang dumduman mayo kay wa kamo makasabot sang yamakasorat sang Kitab aw wa oman mayo akatigami yang kabarakat ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sang wakto na amabowi oman yang mga patay, di da silan amangasawa atawa magabana kay magonawa da silan sang mga malaikat adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, makapantag sang mga patay na amabowi oman, wa mayo akabasa sang Kitab Tawrat adto sang gogodanun makapantag sang tagbi na kaoy na yamallaga na yagalaong yang Tohan kang Nabi Mosa, laong nan, ‘Ako yang Tohan na syasambayangan ni Ibrahim, ni Isahak aw ni Yakob?’ ");
INSERT INTO kqe_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay. Na, sayup sagaw yang dumduman mayo.” ");
INSERT INTO kqe_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ansinyan aon sangka otaw na magiindoway ng Hokoman na yamakadungug sidtong panaglalis nilan. Pagkita nan na madyaw yang tobag ni Isa adto sang mga Sadoki, dyomood yan aw yagaosip yan kang Isa, “Wain na sogowan yang labaw sang kariko?” ");
INSERT INTO kqe_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tyomobag si Isa, “Yani yang sogowan na labaw sang kariko, ‘Kamo na bangsa Israil, paningug kamo! Yang Tohan na kanatun Tagallang, sambok da. ");
INSERT INTO kqe_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kaluguni yang Tohan na kanmo Tagallang sang tibok mo na pangatayan, sang tibok mo na kallowa, sang tibok mo na dumduman aw sang tibok mo na kusug.’ ");
INSERT INTO kqe_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aw yani yang ikadowa na sogowan, ‘Kaluguni yang kapagonawa mo magonawa sang lugun mo sang ginawa mo.’ Way sogowan na labaw pa sining dowa.” ");
INSERT INTO kqe_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ansinyan yagalaong yang magiindoway ng Hokoman adto kang Isa, “Yan sagaw, kay Goro. Bunna yang kanmo pyaglaongan na sambok da yang Tohan na kanatun Tagallang aw waa day lain. ");
INSERT INTO kqe_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bunna oman na dait natun kalugunan yang Tohan sang tibok natun na pangatayan, sang tibok natun na dumduman aw sang tibok natun na kusug. Aw dait natun kalugunan yang kapagonawa ta magonawa sang lugun sang ginawa ta. Labi na madyaw yang magpangagad sining dowa na sogowan kaysang magpasampay aw magpakorban adto sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagkita ni Isa na madyaw yang kanan tobag, yagalaong yan kanan, “Masaid da kaw magpasakop sang pagdato ng Tohan.” Pagkatapos sinyan waa day yamangisug magosip pa kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ansinyan sarta yagaindo si Isa adto sang Baay ng Tohan, yagalaong yan, “Nanga sa yagalaong yang mga magiindoway ng Hokoman na yang Almasi topo kono ni Soltan Daud? ");
INSERT INTO kqe_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kay sang wakto na pyagabuutan si Soltan Daud ng Nyawa ng Tohan yagalaong yan, “ ‘Yang Tohan yagalaong sang kanak Dato, “Pagingkod adi sang karinto ko sampay na ataloon ko yang mga kalaban mo aw amainang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqe_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, kong tyatawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” Na, yamasowat sagaw yang kamangaotawan maningug sang pyagaosiyat ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ansinyan sarta yagaindo pa si Isa, yagalaong yan, “Pagbantay kamo sang mga magiindoway ng Hokoman kay kallini nilan mandagom ng mataas na dagom antak addatan silan ng mga otaw. Aw karim nilan na asalamun silan ng mga otaw adto sang palengke. ");
INSERT INTO kqe_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Adto oman sang pagsasambayangan, karim nilan magingkod sang ingkodanan ng dakowa na mga otaw. Aw adto oman sang mga kandori, karim nilan magingkod sang ingkodanan ng mga otaw na dait addatan. ");
INSERT INTO kqe_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pyapakasikotan nilan yang mga biyoda antak maagaw nilan yang kanilan kakawasaan. Aw pataasun nilan yang kanilan pagdowaa sang atobangan ng mga otaw antak magpakita silan na madyaw silan na mga otaw. Na, labi da yang siksa kanilan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ansinyan imingkod si Isa sang masaid sang butanganan ng sapi adto sang Baay ng Tohan aw pyagatanawan nan yang mga otaw na yagaoog ng sapi. Madaig yang mga sapian na yagaoog ng dakowa na sapi. ");
INSERT INTO kqe_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Awgaid aon oman dyomatung na biyoda na miskin aw yagaoog yan ng dowambok gaid na sinsilyo. ");
INSERT INTO kqe_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ansinyan tyatawag ni Isa yang mga inindowan nan na modood kanan aw laong nan kanilan, “Sang bunna-bunna pagalaong ko kamayo na yani na biyoda na miskin yagaatag ng labaw pa sidtong yatag ng kadaigan pa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay silan,” laong nan, “yagaatag silan ng sapi sikun sang sobra nilan na kakawasaan. Awgaid yani na bobay, abir bali na kamiskin nan, yatag nan yang kariko ng kanan sapi maskin idto dakman yang pagabili nan ng pagkan.” ");
INSERT INTO kqe_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ansinyan paglogwa ni Isa sikun sang Baay ng Tohan, aon sangka otaw na inindowan nan na yagalaong kanan, “Kay Goro, tanawa yaning Baay ng Tohan. Mangkadakowa yang mga bato aw madyaw yan tanawon.” ");
INSERT INTO kqe_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Awgaid yagalaong si Isa kanan, “Madyaw sagaw tanawon yaning Baay ng Tohan. Awgaid madatung yang allaw na amasapad yang kariko sinyan. Way maskin sambok na bato na amabilin sang kyakabutangan nan kay obos silan apangkaya-kaya.” ");
INSERT INTO kqe_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ansinyan sarta yagaingkod si Isa adto sang Butay ng Jayton na yagaatobang sang Baay ng Tohan, dyomood kanan si Pitros, si Yakob, si Yahiya aw si Andriyas aw nang silan da gaid yagaosip silan kanan, laong nilan, ");
INSERT INTO kqe_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Paglaonga kami daw kinno pa matoman yaning pyaglaongan mo aw ono yang tanda na magapakatigam kanami na mallug da amaitabo yang kariko sinyan.” ");
INSERT INTO kqe_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo antak di kamo kalimbongan ng maskin sino. ");
INSERT INTO kqe_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kay madaig yang mga otaw na madatung sang kanak ngaan aw magalaong silan na ‘Ako yang Almasi,’ aw madaig oman yang akalimbongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pagdungug mayo na aon mga gira sang masaid kamayo aw adto oman sang mawat na mga banwa, ayaw kamo magkalluk. Kay dait na amaitabo yang kariko sinyan, awgaid dili pa yani yang kataposan ng donya. ");
INSERT INTO kqe_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagadatowan mapaglaban adto sang kadaigan. Amaon yang mga linog sang yagakatuna-tuna na mga banwa aw amaon oman yang gutum. Awgaid yang kariko sinyan pagsogod pa gaid ng kasikotan na magonawa sang pagbati ng sambok na bobay sang pagpanganak. ");
INSERT INTO kqe_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Awgaid kamo,” laong ni Isa, “pagbantay kamo kay adakupun aw adaun kamo adto sang hokmanan aw abadasan kamo adto sang pagsasambayangan ng mga Yahodi. Sabap sang pagpangintoo mayo kanak adaun kamo adto sang mga gobirnador aw mga soltan. Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kay bago domatung yang allaw ng arikiyamat dait na apayapat yang Madyaw na Gogodanun sang kariko ng mga bangsa adi sang babawan ng donya. ");
INSERT INTO kqe_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na, kong adakupun aw adaun kamo adto sang hokmanan, ayaw kamo magkarido daw ono yang pagalaong mayo. Kay sinyan na wakto apakatigam kamayo daw ono yang dait mayo paglaong. Aw idtong pagalaong mayo di magasikun sang dumduman mayo kondi sang Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sinyan na mga allaw,” laong ni Isa, “aon mga otaw na magapadakup sang mga lomon nilan antak silan patayun. Aon oman mga ama na magapadakup sang mga anak nilan antak silan patayun. Aw aon oman mga anak na malaban sang taganak nilan aw apapatay nilan silan. ");
INSERT INTO kqe_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kamo oman, odumtan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. Awgaid sino-sino yang magapadayon sang pagpangintoo nan kanak taman sang kataposan sini na mga kasikotan, amalowas.” ");
INSERT INTO kqe_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ansinyan yagalaong oman si Isa, “Sang madatung na mga allaw makita mayo na aon yakabutang na haram adto sang logar na di dait pagbutangan. Sino-sino yang magabasa sini, sabta mayo yang mana sinyan. Na, pagkita mayo sinyan, yang mga otaw na adto sang Yahodiya, dait silan domaagan adto sang kabtayan. ");
INSERT INTO kqe_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yang otaw na adto sa logwa ng kanan baay, di da dait somuud antak makamang pa sang maskin ono na butang nan. ");
INSERT INTO kqe_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aw yang otaw na adto sang pawa, di da dait mori antak makamang pa ng kanan dagom. ");
INSERT INTO kqe_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pagdatung sinyan na mga allaw, kallat sidtong mga mabdus aw sidtong mga yagapasoso kay mairapan silan pagdaagan. ");
INSERT INTO kqe_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Agaw, pagpangayo-ayo kamo adto sang Tohan na di gao yan amainang sang wakto ng tingtignaw. ");
INSERT INTO kqe_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kay sinyan na mga allaw, labi da yang kasikotan na agian ng mga otaw. Sikun pa sang pagbaoy ng donya sampay adon waa pay main da nan na kasikotan aw pagkatapos san di da oman amainang yang magonawa sinyan. ");
INSERT INTO kqe_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na, kong madogay yang inyan na kasikotan, amatay da yang kariko ng mga otaw. Awgaid sabap sang looy ng Tohan sang mga otaw na pipili nan, di nan apadogayun. ");
INSERT INTO kqe_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Sinyan na mga allaw, kong aon magalaong kamayo na, ‘Tanawa, idi da yang Almasi,’ atawa, ‘Adto sidto yan,’ ayaw kamo magtoo kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kay aon madatung na mga otaw na magalaong na silan kono yang Almasi. Aw aon oman mga otaw na magalaong na mga nabi kono silan, awgaid dili yan ng bunna. Magainang silan ng maskin ono na katingaan kay antak, kong mapakay, mailad nilan maskin yang mga pinili ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Agaw, pagbantay kamo! Pyagalaong ta kamo sang kariko sinyan sang wa pa yan akainang. ");
INSERT INTO kqe_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na, pagkatapos sinyan na mga allaw ng kasikotan,” laong ni Isa, “magakaduguum yang suga aw di da magasiga yang bowan. ");
INSERT INTO kqe_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangaoog yang mga bitoon sikun sang langit aw yang kariko na adto sang langit amagayung. ");
INSERT INTO kqe_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pagkatapos sinyan makita nilan ako na Anak ng Manosiya sikun sang mga gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqe_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aw ansinyan osogoon ko yang kanak mga malaikat sang opat ka pinidyowan ng donya antak tiponon nilan yang mga otaw na pipili ko sikun sang kariko ng mga banwa. ");
INSERT INTO kqe_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na, dumduma mayo yang kaoy na igira. Aw yamanaringsing da yang mga sanga sinyan na kaoy, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqe_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Magonawa sinyan, pagkita mayo na amainang da yaning pyagalaong ko kamayo, akatigaman mayo na mallug da ako magbarik adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sang bunna-bunna pagalaong ko kamayo na amatoman yang kariko sinyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqe_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Awgaid,” laong ni Isa, “way otaw na yamatigam daw ono na allaw atawa ono na wakto ako mabarik. Maskin yang mga malaikat adto sang sorga, aw maskin oman ako na Anak ng Tohan, wa akatigam. Yang Tohan da gaid na kanak Ama yang yamatigam sinyan. ");
INSERT INTO kqe_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Agaw sagaw, pagbantay aw pagandam kamo kay wa kamo akatigam daw kinno domatung yang wakto ng pagbarik ko. ");
INSERT INTO kqe_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kay magonawa yan sang otaw na pyomanaw sang mawat na banwa. Pagpanaw nan syasarig nan yang kanan baay adto sang kanan mga sogowanun. Yatagan nan yang matag-isa kanilan ng gawbuk aw pyagalaong nan yang gowardya sang powertaan na dait yan magbantay. ");
INSERT INTO kqe_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Idto sagaw, dait kamo magbantay kay wa kamo akatigam daw kinno bomarik yang tagtomon ng baay, gabila ba, daw tungang gabi, daw kadlawon atawa omaga. ");
INSERT INTO kqe_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aw motokaw yan magbarik, na, basin adatungan nan kamo na yamangkatoog. ");
INSERT INTO kqe_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, yang pyagalaong ko kamayo, pyagalaong ko oman adto sang kariko ng mga otaw na dait kamo magbantay.” ");
INSERT INTO kqe_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Adon, dowang allaw dakman aw madatung da yang Pakaradyaan ng Paglabay na tyatawag oman ng Pakaradyaan ng Pan na way Labadora. Na, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yanagbaaw-baaw silan daw monono yang pagdakup nilan kang Isa na di akatigaman ng mga otaw aw monono yang pagpatay kanan. ");
INSERT INTO kqe_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yagalaong silan, “Di gaid natun yani inangun sang wakto ng pakaradyaan kay basin magakasamok yang mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ansinyan sarta adto sang longsod ng Bitani silan Isa, kyomadto silan sang baay ni Simon, yang otaw na sanglaun sangaon. Nang yanagkan silan aon dyomatung na bobay na yagadaa ng tagbi na lasakanan na yamapono ng paballo. Yani na paballo na pyagangaanan ng nardo labi na mahalaga aw way sagul san. Ansinyan byabari ng bobay yang liyug ng lasakanan aw obowi nan ng paballo yang oo ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, aon mga otaw ansan na yamadaman sang ininang sinyan na bobay aw yanaglaong silan, “Kanogon sinyan na paballo! ");
INSERT INTO kqe_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Madyaw pa aw byabarigya inyan aw yang alin atag adto sang mga miskinan. Kay yang alin sinyan magonawa sang soweldo ng sangka otaw sa suud ng sangka toig.” Na, labi da yang pagsaway nilan sinyan na bobay. ");
INSERT INTO kqe_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Awgaid yagalaong si Isa, “Nanga sa pyagakasamok mayo yani na bobay? Pasagdi mayo yan kay madyaw yang ininang nan kanak. ");
INSERT INTO kqe_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kay yang mga miskinan abay mayo kaupud, aw maskin ono na wakto makatabang kamo kanilan. Awgaid ako, di ako magapabilin adi kamayo. ");
INSERT INTO kqe_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yani na bobay, ininang nan yang mapakay nan inangun. Yobowan nan ako ng paballo antak andamun nan dadaan yang kanak lawas sang kanak paglubung. ");
INSERT INTO kqe_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sang bunna-bunna pagalaong ko kamayo na maskin wain adi sining donya na apayapat yang Madyaw na Gogodanun, amagogod oman yang ininang nan kanak silbi tadumanan kanan.” ");
INSERT INTO kqe_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ansinyan, si Yodas Iskariyot na sambok sang sampoo aw dowa na mga sahabat ni Isa, kyomadto yan sang mga pangoo ng mga imam antak ipagtraydor nan adto kanilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na, pagdungug nilan sang pyaglaongan ni Yodas, yamasowat silan aw yagapasad silan na atagan yan ng sapi. Ansinyan yamanganap da si Yodas ng wakto na madyaw ipadakup kanilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ansinyan dyomatung da yang pukas na allaw ng Pakaradyaan ng Pan na way Labadora na yan yang allaw na dait sobariun yang mga karniro para sang Pakaradyaan ng Paglabay. Ansinyan yosip si Isa ng mga inindowan nan, laong nilan, “Wain yang karim mo na andamun nami yang kanatun pagkan para sang Pakaradyaan ng Paglabay?” ");
INSERT INTO kqe_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ansinyan syosogo ni Isa yang dowa na mga inindowan nan aw laong nan kanilan, “Kadto kamo sang syodad. Disidto aon masongon mayo na usug na yagapusan ng banga na yamapono ng tobig. Agad kamo kanan sang apanikan nan na baay ");
INSERT INTO kqe_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","aw paglaonga mayo yang tagtomon sidtong baay, ‘Yagaosip yang goro nami daw wain na kowarto yan makakan sang kandori sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ");
INSERT INTO kqe_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ansinyan apakita nan kamayo yang dakowa na kowarto adto sa taas ng baay na iyan da yang kariko ng kinaanglan ta. Adto da mayo andama yang kanatun pagkan para sang kandori.” ");
INSERT INTO kqe_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ansinyan pyomanaw da idtong dowa na inindowan aw pagdatung nilan sang syodad, yamatoman yang kariko ng pyaglaongan kanilan ni Isa. Ansinyan pyagaandam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqe_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkagabi disinyan dyomatung da si Isa sidto na baay upud sang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqe_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sarta yanagpangan silan, yagalaong si Isa, “Sang bunna-bunna pagalaong ko kamayo na aon sangka otaw kamayo na yagaupud kanak koman na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ansinyan yamarido da silan aw yang matag-isa kanilan yagaosip kanan, laong nilan, “Kay Goro, ako ba yang pyagalaong mo?” ");
INSERT INTO kqe_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tyomobag si Isa aw laong nan, “Isa sang sampoo aw dowa kamayo na mga sahabat ko na yagadarit ng pan disini na ladya upud kanak, yan yang magatraydor kanak. ");
INSERT INTO kqe_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Amatay ako na Anak ng Manosiya magonawa sang yamakasorat sang Kitab makapantag kanak. Awgaid maat yang adatungan sidtong otaw na magatraydor kanak. Madyaw pa aw wa yan akaotaw.” ");
INSERT INTO kqe_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sarta yanagpangan pa silan, kyomamang si Isa ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga inindowan nan aw laong nan, “Dawata mayo yani aw kana mayo kay yani yang kanak lawas.” ");
INSERT INTO kqe_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ansinyan kyomamang yan ng inmanan aw yamanginsokor sang Tohan. Pagkatapos, yatag nan sang mga inindowan nan aw yang kariko nilan iminum. ");
INSERT INTO kqe_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yagalaong si Isa kanilan, “Yani yang kanak dogo na yagaatag ng kasigorowan sang pyagapasadan na ininang ng Tohan sang manosiya. Moboos yang kanak dogo antak maampon yang madaig na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sang bunna-bunna pagalaong ko kamayo na di da ako iminum ng tumuk ng grips taman sang wakto na inumun da ko yang bago na inmanun adto sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagkatapos sinyan yanagkanta silan ng pagpoji adto sang Tohan aw kyomadto da silan sang Butay ng Jayton. ");
INSERT INTO kqe_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ansinyan yagalaong si Isa sang mga inindowan nan, “Adon na gabi, yang kariko mayo mibiya kanak. Kay aon yamakasorat sang Kitab na yagalaong, “ ‘Apapatay ng Tohan yang magbabantayay ng mga karniro, aw ansinyan magakanat-kanat da yang mga karniro.’ ");
INSERT INTO kqe_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Awgaid pagkatapos ko mabowi oman, amaona ako kamayo adto sang Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ansinyan yagalaong si Pitros kang Isa, “Maskin ibiyaan kaw ng kariko nilan, awgaid ako, di ako mibiya kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yagalaong kanan si Isa, “Sang bunna-bunna pagalaong ko kanmo na adon na gabi, sang di pa magatagaok yang laboyo ng makadowa, makatoo kaw maglaong na wa kaw ikilaa kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Awgaid yagalaong da oman si Pitros, “Di ako magalaong na wa ta kaw ikilaa maskin pa apatayun ako upud kanmo.” Na, maynan oman yang pyaglaongan ng kadaigan na mga inindowan. ");
INSERT INTO kqe_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ansinyan kyomadto si Isa aw yang mga inindowan nan sang sambok na tanumanan na tyatawag ng Gitsimani. Pagdatung nilan ansan, yagalaong si Isa sang mga inindowan nan, “Pagingkod kamo ansini kay magadowaa ako.” ");
INSERT INTO kqe_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tapos, pyagaagad nan si Pitros, si Yakob aw si Yahiya. Ansinyan yamarido da yang ginawa ni Isa aw mabugat yang pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Laong nan kanilan, “Labi da yang karido ng ginawa ko na maynang amatay da ako. Ansini da gaid kamo aw ayaw kamo magkatoog.” ");
INSERT INTO kqe_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ansinyan kyomadto si Isa sang onaan aw syomojod yan sang lopa kay magadowaa. Yamangayo-ayo yan adto sang Tohan na kong mapakay di gao yan adatungan ng kasikotan. ");
INSERT INTO kqe_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Laong nan, “O kay Ama, yang maskin ono amainang da mo. Kong mapakay, ayaw ako paagia sining madatung na kasikotan. Awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqe_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ansinyan byomarik yan adto sang toongka otaw na mga inindowan nan aw yadatungan nan silan na yamangkatoog. Pyopokaw nan silan aw yagalaong yan kang Pitros, “Yamatoog kaw kadi, kay Simon? Di kaw makabantay na maskin sangka oras da gaid? ");
INSERT INTO kqe_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pagbantay aw pagdowaa kamo antak di kamo madaa ng satsat. Sa suud ng pangatayan mayo karim mayo mangagad sang Tohan, awgaid sabap ng maloya yang lawas mayo madari kamo madaa ng satsat.” ");
INSERT INTO kqe_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ansinyan pyomanaw da oman si Isa aw yagadowaa da oman yan na maynan oman yang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkatapos byomarik da oman yan sang too na inindowan nan aw kikita nan na yamangkatoog da oman silan kay labi da yang katodtod nilan. Pagpokaw kanilan ni Isa, wa silan akatigam daw ono yang pagalaong nilan. ");
INSERT INTO kqe_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ansinyan pyomanaw da oman si Isa aw sang ikatoo na pagbarik nan yagalaong yan kanilan, “Yabay pa gaid kamo matoog aw magpatana? Osto da kay dyomatung da yang wakto na adakupun ako na Anak ng Manosiya ng baradosa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Anda, bangon da kamo kay mapanaw da kita. Idi da yang otaw na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nang yagatiyab pa si Isa, dyomatung si Yodas na sambok sang sampoo aw dowa na mga sahabat. Madaig yang mga otaw na yumupud kanan na aon daa na mga lodyo aw mga bobonal. Syosogo silan ng mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, pyagalaong silan dadaan ni Yodas na yan yang magatraydor kang Isa daw ono yang inangun nan silbi tanda kanilan. Laong nan, “Yang otaw na aukan ko, yan yang yanap mayo. Dakupa da mayo aw daa mayo, awgaid bantayi ng madyaw.” ");
INSERT INTO kqe_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Agaw pagdatung ni Yodas, dyomood dayon yan kang Isa aw maglaong, “Kay Goro.” Aw yaukan nan si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ansinyan dyadakup si Isa ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Awgaid aon sangka otaw na yagaindug sang masaid kang Isa, gyagabot nan yang kanan lodyo aw tibasa nan yang sogowanun ng Dakowa na Imam aw yamapotol yang sangkilid na taringa nan. ");
INSERT INTO kqe_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ansinyan yagalaong si Isa sang mga yagadakup kanan, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng lodyo aw bobonal sang pagdakup mayo kanak? ");
INSERT INTO kqe_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Matag allaw adto ako sang Baay ng Tohan na yagaindo aw adto oman kamo, awgaid wa mayo ako adakupa. Awgaid yamaitabo yang kariko sini antak matoman yang yamakasorat sang Kitab.” ");
INSERT INTO kqe_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ansinyan yagabiya kanan yang kariko ng mga inindowan nan aw yanagdaagan silan. ");
INSERT INTO kqe_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Awgaid aon sambok na olitawo disinyan na yosonod kang Isa na yagatapis gaid ng dagmay. Pagkita kanan ng mga sondao, adakupun da gao nilan. ");
INSERT INTO kqe_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Awgaid bibilin nan yang kanan dagmay aw dyomaagan ng way dagom. ");
INSERT INTO kqe_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ansinyan dyadaa nilan si Isa adto sang baay ng Dakowa na Imam. Yanagkatipon ansan yang kariko ng mga pangoo ng mga imam, yang mga pangoo ng mga Yahodi aw yang mga magiindoway ng Hokoman. ");
INSERT INTO kqe_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, si Pitros, yosonod yan kang Isa awgaid sang mawat-awat gaid taman sang baay ng Dakowa na Imam. Ansinyan syomuud yan sang pamanag aw imingkod upud sang mga gowardya sang masaid sang atoon antak kapasowan yan. ");
INSERT INTO kqe_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Adon, yang mga pangoo ng mga imam aw yang kariko ng mga opisyales sang Hokmanan ng mga Yahodi, yamanganap silan ng ebidensya antak maakosar aw mapatay nilan si Isa. Awgaid way kikita nilan na dosa nan. ");
INSERT INTO kqe_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kay maskin madaig yang yagasaksi ng dili ng bunna makapantag kanan, wa magakaonawa yang pyaglaongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ansinyan aon oman mga otaw na imindug aw yagalaong silan ng dili ng bunna makapantag kang Isa, laong nilan, ");
INSERT INTO kqe_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yamadungug nami na yagalaong yani na otaw na ogubaun kono nan yang Baay ng Tohan na ininang ng mga otaw, aw sa suud ng toong allaw apaindugun oman nan yang bago na wa inanga ng manosiya.” ");
INSERT INTO kqe_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Awgaid wa oman magakaonawa yang pyaglaongan nilan. ");
INSERT INTO kqe_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ansinyan imindug yang Dakowa na Imam sang atobangan ng kariko ng mga otaw aw yagaosip yan kang Isa, “Ono yang akatobag mo sining mga otaw na yagaoman kanmo?” ");
INSERT INTO kqe_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Awgaid yagapakatingun gaid si Isa aw wa yan otobag. Agaw yagaosip oman kanan yang Dakowa na Imam, “Ikaw ba yang Almasi, yang Anak ng Tohan na Labi na Bantoganun?” ");
INSERT INTO kqe_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tyomobag si Isa, “Ud, ako sagaw. Sang madatung na mga allaw makita mayo ako na Anak ng Manosiya na yagaingkod apit sang karinto ng Tohan na Labi na Mabarakat. Aw makita oman mayo na mabarik ako adi sang donya sikun sang langit na pyagalibotan ng gabon.” ");
INSERT INTO kqe_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagdungug sinyan ng Dakowa na Imam, lyalasi nan yang kanan dagom sabap sang kadaman nan aw yagalaong yan, “Di da kita kinaanglan ng kadaigan pa na saksi! ");
INSERT INTO kqe_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dyudungug da mayo yang kanan pyaglaongan na magonawa kono yan sang Tohan! Na, ono da yang hokom mayo?” Aw yang kariko ng mga pangoo yagahokom na dait yan patayun. ");
INSERT INTO kqe_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ansinyan tyotobadan si Isa ng pipila na mga otaw. Tyatabonan nilan yang kanan mata aw sontoka nilan. “Na,” laong nilan kanan, “paglaonga kono daw sino yang yagasontok kanmo!” Aw syosontok oman yan ng mga gowardya pagkamang nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ansinyan nang idto pa si Pitros sang pamanag ng baay, aon dyomatung na sambok na bobay na sogowanun ng Dakowa na Imam. ");
INSERT INTO kqe_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkita nan kang Pitros na yagapainit sang lawas nan sang masaid sang atoon, pyapakatanawan nan ng madyaw aw laong nan, “Inagad kaw oman ni Isa na taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Awgaid yagadili si Pitros aw laong nan, “Wa ako akatigam daw ono yang pyagalaong mo.” Ansinyan kyomadto yan sang powertaan ng pamanag. Aw sinyan na wakto yagatagaok yang laboyo. ");
INSERT INTO kqe_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ansinyan kikita da oman yan sidtong bobay na sogowanun aw yagalaong yan sang mga otaw na yagaindug ansan, “Yani na otaw, kaupud nilan ni Isa.” ");
INSERT INTO kqe_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Awgaid yagadili oman si Pitros sidto na pyaglaongan nan. Pagkatugun-tugun disinyan yagalaong yang mga otaw na yagaindug ansan kang Pitros, “Bunna sagaw na kaupdanan kaw nilan kay ikaw taga Jalil.” ");
INSERT INTO kqe_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Awgaid yagasapa si Pitros aw laong nan, “Isiksaun ako ng Tohan kong di ako maglaong ng bunna. Wa ako ikilaa sinyan na otaw na pyagalaong mayo kanak!” ");
INSERT INTO kqe_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sinyan na wakto yagatagaok da oman yang laboyo ng ikadowa. Aw kyakadumduman ni Pitros yang pyaglaongan kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo ng makadowa, makatoo kaw maglaong na wa kaw ikilaa kanak.” Na, pagdumdum nan sinyan, bali na pagtiyao nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagkaamdagay disinyan yanagkatipon yang mga pangoo ng mga imam aw yang mga pangoo ng mga Yahodi, yang mga magiindoway ng Hokoman aw yang kariko ng mga opisyales ng Makagwas na Hokmanan aw pyagabaawan nilan daw onoon nilan si Isa. Ansinyan gyagapos nilan si Isa aw dyadaa nilan adto kang Pilato, yang gobirnador na taga Roma. ");
INSERT INTO kqe_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ansinyan yosip si Isa ni Pilato, laong nan, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag kanan si Isa, “Yan agaw yang pyagalaong mo.” ");
INSERT INTO kqe_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ansinyan madaig yang pyagaoman kanan ng mga pangoo ng mga imam. ");
INSERT INTO kqe_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Agaw, yosip da oman ni Pilato si Isa, laong nan, “Nanga sa di kaw motobag? Tanawa, madaig yang pyagaoman nilan kanmo.” ");
INSERT INTO kqe_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Awgaid wa oman otobag si Isa, agaw yamatingaa si Pilato. ");
INSERT INTO kqe_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, matag Pakaradyaan ng Paglabay yang kyakaanadan ni Pilato na palogwaun nan yang sangka otaw na piniriso na pyapangayo ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Adon, adto sang pirisowan aon sangka otaw na pyagangaanan ni Barabas. Yamapiriso yan kipat sang mga kaupdanan nan kay yalaban silan sang gobirno aw yakapatay yan ng otaw. ");
INSERT INTO kqe_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ansinyan yanagkatipon yang madaig na mga otaw adto sang atobangan ni Pilato aw yamangayo silan na apalogwaun nan yang sangka otaw sobay sang kyakabatasanan nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yagaosip kanilan si Pilato, “Karim mayo na obooyan ko kamayo yang soltan ng mga Yahodi?” ");
INSERT INTO kqe_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Idto yang osip nan kay kyakatigaman nan na dyadaa kanan si Isa ng mga pangoo ng mga imam kay yamasina silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Awgaid yang ininang ng mga pangoo ng mga imam, pyagalaong nilan yang mga otaw na si Barabas yang apangayoon nilan na obooyan aw dili ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yagalaong da oman si Pilato sang mga otaw, “Kong maynan, ono yang inangun ko sini na otaw na tyatawag mayo ng soltan ng mga Yahodi?” ");
INSERT INTO kqe_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yamangiyak silan, “Alansang yan sang kros!” ");
INSERT INTO kqe_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Nanga sa? Ono yang dosa na ininang nan?” yagalaong oman kanilan si Pilato. Awgaid pyapakusug pa nilan yang pagpangiyak aw laong nilan, “Alansang yan sang kros!” ");
INSERT INTO kqe_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, karim ni Pilato na masowat kanan yang mga otaw. Agaw si Barabas yang pyapalogwa nan. Pagkatapos sinyan pyapabadasan nan si Isa aw yatag nan sang mga sondao antak alansang da nilan sang kros. ");
INSERT INTO kqe_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ansinyan dyadaa si Isa ng mga sondao adto sang pamanag ng palasyo ng gobirnador aw pyapatawag nilan yang kariko ng kasondaowan. ");
INSERT INTO kqe_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ansinyan pyapandagoman nilan si Isa ng joba na mapowa. Tapos, yagainang silan ng korona na soksokon aw butangan nilan sang oo nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ansinyan byabantog konohay nilan si Isa aw laong nilan, “Mabowi yang soltan ng mga Yahodi!” ");
INSERT INTO kqe_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Byobonalan nilan yang oo nan ng kaoy aw tyotobadan nilan. Aw syomojod silan sang atobangan nan na maynang yagaaddat silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pagkatapos nilan digay-digayun si Isa, lyolobasan nilan ng joba na mapowa aw syosootan da oman ng kanan dagom. Ansinyan dyadaa nilan yan adto sa logwa antak alansang da nilan sang kros. ");
INSERT INTO kqe_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Paglogwa nilan sikun sang Awrosalam, aon syosongon nilan na otaw na pyagangaanan ni Simon na taga Kirini na ama ni Iskandar aw si Ropos. Sikun yan sang baryo aw yagapasingadto yan sang syodad. Pyupugus yan ng mga sondao pagpusan sang kaoy na pagalansangan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ansinyan dyadaa nilan si Isa adto sang logar na tyatawag ng Golgota na yang mana san Logar ng Oo ng Kalabira. ");
INSERT INTO kqe_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagdatung nilan ansan, pyapainum gao nilan si Isa ng bino na syasaguan ng tambal na pyagangaanan ng mira. Awgaid wa nan inuma. ");
INSERT INTO kqe_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ansinyan lyalansang da nilan si Isa sang kros. Pagkatapos, pyagabain-bain nilan yang mga dagom nan pinaagi sang pagripa antak katigaman daw ono yang amakamang ng matag-isa kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na, alas nowebe ng kaamdag yang paglansang nilan kang Isa sang kros. ");
INSERT INTO kqe_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aon oman byubutang nilan na karatola adto sang kros na syosoratan ng pyagaoman kanan na yagalaong, “Yang Soltan ng mga Yahodi.” ");
INSERT INTO kqe_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na, aon oman dowangka otaw na tolisan na lyalansang sang kros dungan kang Isa, yang sambok sang karinto nan aw yang sambok sang kawaa nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ansinyan yamatoman yang yamakasorat sang Kitab na yagalaong, “Yamabilang yan sang mga darowaka.” ");
INSERT INTO kqe_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, yang mga otaw na yalabay ansan yagauung-uung aw ininsolto nilan si Isa, laong nilan, “Yagalaong kaw na ogubaun mo yang Baay ng Tohan aw apaindugun da mo oman sa suud ng toong allaw. ");
INSERT INTO kqe_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, lowasa da yang ginawa mo aw kawas dosang kros!” ");
INSERT INTO kqe_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Magonawa sinyan didigay-digay yan ng mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, laong nilan, “Tyatabangan nan yang kadaigan, awgaid di yan makalowas sang ginawa nan! ");
INSERT INTO kqe_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na, tanawon ta adon yang Almasi, yang soltan ng bangsa Israil, daw makakawas yan sikun sang kros. Aw makakawas yan, amangintoo da kami kanan!” Aw maskin idtong dowangka otaw na tolisan na lyalansang sang kros dungan kang Isa, yamanginsolto silan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nang alas dose da yang suga yagakaduguum yang tibok banwa taman ng alas tres ng gabila. ");
INSERT INTO kqe_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pagkaalas tres disinyan yamangiyak si Isa ng matanog, laong nan, “Iloy, Iloy, lama sabaktani?” na yang mana sinyan “Ya Tohan ko, ya Tohan ko, nanga sa pyapabayaan mo ako?” ");
INSERT INTO kqe_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pagdungug sinyan ng mga otaw na yanagindug ansan, yagalaong silan, “Paningug kamo, tyatawag nan si Nabi Iliyas.” ");
INSERT INTO kqe_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ansinyan dyomaagan dayon yang sambok na otaw aw kyomamang yan ng ispongha aw tuguma nan sang aslum na bino. Tapos, byubutang nan sang kaoy aw diwian nan sang baba ni Isa antak masupsup nan. Yagalaong yan, “Na, tanawon ta adon daw madatung si Nabi Iliyas antak tabangan nan pagkawas sikun sang kros.” ");
INSERT INTO kqe_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ansinyan yamangiyak oman si Isa ng matanog aw yamabogto da yang napas nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sinyan na wakto yamalasi yang madakmul na kortina adto sang Baay ng Tohan aw yamatunga yan sikun sa taas pababa. ");
INSERT INTO kqe_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Adon, yang kapitan ng mga sondao na yagaindug sang atobangan ng kros na pyagalansangan kang Isa, pagkita nan na mayninyan yang pagbogto ng napas ni Isa, yagalaong yan, “Bunna sagaw na yani na otaw Anak ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na, aon oman mga bobay ansan na yanagtanaw sidto na yamaitabo sikun sang mawat. Kaupud nilan si Mariyam na taga Magdala aw si Salomi. Iyan oman si Mariyam na ina ni Yosis aw si Yakob na mangod nan. ");
INSERT INTO kqe_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yani na mga bobay yamagad aw yagaatiman kang Isa nang idto pa yan sang Jalil. Madaig oman ansan yang kaobayan na yamagad kang Isa sang pagkadto nan sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na, sidto na allaw Jomaat na allaw ng pagpangandam para sang Allaw ng Pagpatana. Pagkakasilum disinyan ");
INSERT INTO kqe_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","dyomatung si Yosop na taga Arimatiya. Yani si Yosop sambok na opisyal sang Makagwas na Hokmanan na pyagaaddatan ng mga otaw aw yagatagad yan sang wakto na magadato da yang Tohan. Ansinyan yagakaisug yan komadto kang Pilato antak pangayoon nan yang patay na lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na, yamatingaa da si Pilato pagdungug nan na patay da kono si Isa. Agaw, pyapatawag nan yang kapitan ng mga sondao aw yosip nan daw bunna ba na patay da si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pagdungug nan sikun sang kapitan na patay da si Isa, tyotogotan nan si Yosop na kamangun nan yang lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na, pyomanaw da si Yosop aw yagabili yan ng sapot na mapoti. Pagkatapos, kyakamang nan yang lawas ni Isa sikun sang kros, byabalot nan ng sapot aw butangan nan sang kobor na pyagalongagan sang bato. Pagkatapos, pyagaligid nan yang dakowa na bato sang baba ng kobor antak matabonan yan. ");
INSERT INTO kqe_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na, iyan san si Mariyam na taga Magdala aw si Mariyam na ina ni Yosis aw yakakita silan daw wain okoboran si Isa. ");
INSERT INTO kqe_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagsallup ng suga sang Allaw ng Pagpatana, pyomanaw si Mariyam na taga Magdala, si Salomi aw si Mariyam na ina ni Yakob kay magabili silan ng paballo na obutang nilan sang patay na lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ansinyan pagsilat ng suga sang allaw ng Domingo, kyomadto da silan sang kobor. ");
INSERT INTO kqe_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sarta iyan silan sang daan yanaginosipay silan, laong nilan, “Sino kowaw yang amakatabang kanatun pagligid sang bato sikun sang baba ng kobor?” ");
INSERT INTO kqe_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maynan yang pyagabaawan nilan kay bali na kadakowa nidtong bato. Awgaid pagtanaw nilan, kikita nilan na yamaligid da idtong bato. ");
INSERT INTO kqe_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na, pagsuud nilan sang kobor, aon kikita nilan na sambok na olitawo na yagaingkod apit sang karinto. Pagkita nilan kanan, bali na pagkatingaa nilan. ");
INSERT INTO kqe_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Awgaid yagalaong kanilan idtong otaw, “Ayaw kamo magkalluk. Yamatigam ako na yanap mayo si Isa na taga Nasarit na pyapalansang sang kros. Waa da yan adi kay yamabowi oman yan. Tanawa mayo yang pyagabutangan kanan. ");
INSERT INTO kqe_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, panaw da kamo aw paglaonga mayo yang mga inindowan nan kipat kang Pitros na amaona yan kanilan adto sang Jalil. Adto da nilan yan ikitaun magonawa sang pyagalaong nan.” ");
INSERT INTO kqe_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ansinyan lyomogwa da yang mga bobay sikun sang kobor aw dyomaagan silan kay tyatakigan silan ng alluk. Aw wa silan magalaong sinyan sang maskin sino kay yamalluk silan. ");
INSERT INTO kqe_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, omaganay pa sang allaw ng Domingo yamabowi oman si Isa. Pagkatapos nan mabowi oman, ona yan magapakita kang Mariyam na taga Magdala na kyakamangan nan sangaon ng pito na mga saytan. ");
INSERT INTO kqe_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na, pyomanaw da si Mariyam antak paglaongon nan yang mga inindowan ni Isa na yanagtiyao aw yanagminatay pa. ");
INSERT INTO kqe_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Awgaid pagdungug nilan sang pyaglaongan ni Mariyam na bowi si Isa aw yakakita yan kanan, wa silan apangintoo kanan. ");
INSERT INTO kqe_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkatapos san yagapakita si Isa sang dowangka otaw na mga inindowan nan nang yagapasingadto silan sang baryo. Awgaid yamaisab yang parangay nan. ");
INSERT INTO kqe_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ansinyan byomarik da idtong dowangka otaw adto sang Awrosalam kay paglaongon nilan yang mga kaupdanan nilan. Awgaid wa silan apangintoo kanilan. ");
INSERT INTO kqe_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pagkatapos san yagapakita si Isa sang sampoo aw isa na mga sahabat nan sarta yanagpangan silan. Kyakadamanan nan silan sabap sang katigas ng oo nilan kay wa silan apangintoo sang pyaglaongan ng mga otaw na yakakita kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqe_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ansinyan yagalaong si Isa kanilan, “Kadto da kamo sang kariko ng mga banwa adi sang babawan ng donya aw pagpayapat kamo ng Madyaw na Gogodanun sang kariko ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sino-sino yang amangintoo aw magapasogbo, amalowas. Awgaid sino-sino yang di amangintoo, hokomon na isiksaun. ");
INSERT INTO kqe_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aw yani yang mga tanda na amainang ng mga yamangintoo kanak. Sabap sang kabarakat ng kanak ngaan makapalogwa silan sang mga saytan sikun sang mga otaw aw makapagtiyab silan sang mga tiniyaban na wa nilan akatigami. ");
INSERT INTO kqe_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kong makakuput silan ng bila atawa makainum silan ng makamatay, di silan amaono. Aw kong dapunun nilan yang arima nilan sang mga masakitun, amadyaw silan.” ");
INSERT INTO kqe_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkatapos ni Tagallang Isa maglaong sinyan adto sang mga inindowan nan, pyapataas yan adto sang sorga aw pagingkod apit sang karinto ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ansinyan kyomadto da yang mga inindowan nan sang yagakatuna-tuna na mga banwa aw yagapayapat silan ng Madyaw na Gogodanun. Tyatabangan silan ng Tagallang sang ininang nilan aw yatagan nan silan ng kabarakat paginang ng mga katingaan silbi tanda na bunna yang pyagapayapat nilan. Wassalam");
INSERT INTO kqe_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Assalamo alaykom kanmo, Dato Tiyopilo. Madaig da yang yamaningkamot magsorat makapantag sang mga ininang ni Isa Almasi na yamatoman adi sang kanatun banwa. ");
INSERT INTO kqe_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yang idto na syosorat nilan yosobay sang gyogogod kanatun nidtong mga otaw na yakakita sang kariko ng yamainang sikun pa sang pagsogod aw yagapayapat oman ng makapantag sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na adon, Dato Tiyopilo, sabap ng pyagasosi ko ng madyaw yang kariko sining mga butang sikun pa sang pagsogod, yagadumdum ako na madyaw oman kong isorat ko kanmo yaning kariko sang matapid na pamaagi. ");
INSERT INTO kqe_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ininang ko yani antak makasigoro kaw na bunna yang kariko ng pyagaindo kanmo. ");
INSERT INTO kqe_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sidto na wakto na si Hirod yang soltan sang Yahodiya aon sambok na imam na pyagangaanan ni Sakariyas. Yamakabilang yan sang panon ng mga imam na mga topo ni Abiyas. Yang ngaan ng asawa nan si Hashiba na topo oman ni Imam Haron. ");
INSERT INTO kqe_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Si Sakariyas aw si Hashiba, matorid silan sang pagtanaw ng Tohan aw yamangagad silan sang kariko ng mga sogowan. ");
INSERT INTO kqe_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Awgaid way anak nilan kay di makaanak si Hashiba aw silan dowa mataas da yang idad nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ansinyan dyomatung yang wakto na si Sakariyas upud sang kadaigan pa na mga imam ng kanan panon yang magainang ng gawbuk nilan adto sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yanagripa silan sobay sang kabatasanan nilan na mga imam daw sino yang magasonog ng toob adto sa suud ng Baay ng Tohan. Aw si Sakariyas yang yamapili. Agaw syomuud yan adto sang Sotti na Kowarto. ");
INSERT INTO kqe_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sarta yagasonog yan ng toob adto sa suud, madaig yang mga otaw adto sa logwa na yanagdowaa. ");
INSERT INTO kqe_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakadyap disinyan aon sambok na malaikat na syosogo ng Tohan na yagapakita kang Sakariyas. Iyan yan magaindug apit sang karinto ng pagsosonogan ng toob. ");
INSERT INTO kqe_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkita ni Sakariyas sang malaikat, yukuga yan aw yasaot yan ng alluk. ");
INSERT INTO kqe_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Awgaid yagalaong yang malaikat kanan, “Ayaw da magkalluk, kay Sakariyas, kay tyatarima ng Tohan yang pyapangayo mo kanan. Yang kanmo asawa na si Hashiba amanganak ng usug aw pagangaanan mo yan ni Yahiya. ");
INSERT INTO kqe_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amasowat kaw sabap kanan aw madaig oman yang mga otaw na amasowat kong amaotaw da yan. ");
INSERT INTO kqe_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kay amainang yan ng bantoganun sang atobangan ng Tohan. Di yan dait minum ng maskin ono na makalasing kay sikun pa sang paglakad ng ina nan pyagabuutan da yan ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Madaig yang mga topo ni Israil na apabarikun nan adto sang Tohan na Tagallang nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Amaona yan sang pagdatung ng Dato na Labi na Mabarakat na iyan kanan yang kinaiya aw kabarakat na magonawa sang kinaiya aw kabarakat ni Nabi Iliyas. Sabap sang pagindo nan apabarikun nan yang madyaw na relasyon ng mga ama adto sang mga anak nilan. Aw yang mga otaw na masopakun apabarikun nan sang dumduman ng mga otaw na matorid. Aw ansinyan andamun nan yang mga otaw sang pagdatung ng Dato na Labi na Mabarakat.” ");
INSERT INTO kqe_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ansinyan yagaosip si Sakariyas sang malaikat, laong nan, “Monono ko akatigaman na amatoman yaning pyaglaongan mo? Kay ako matikadung da aw boyag da oman yang asawa ko.” ");
INSERT INTO kqe_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tyomobag yang malaikat, laong nan, “Ako si Jibrail, aw iyan ako magaindug sang atobangan ng Tohan. Syosogo nan ako antak magpakatigam kanmo sining madyaw na gogodanun. ");
INSERT INTO kqe_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awgaid adon, kay wa kaw apangintoo sang pyaglaongan ko, amasiling da kaw ng amang aw di da kaw makapagtiyab taman sidtong wakto na amatoman da yaning pyaglaongan ko kanmo. Aw amatoman yaning kariko pagdatung ng wakto na pyagakahanda ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, yang mga otaw adto sa logwa yabay magtagad kang Sakariyas. Yamangkatingaa silan nanga sa yamadogay yan adto sa suud ng Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ansinyan paglogwa da ni Sakariyas, di da yan makapagtiyab aw yagasingyas da gaid yan adto sang mga otaw. Agaw, kyakatigaman da nilan na aon pyapakita kanan ng Tohan adto sa suud. Aw sikun sinyan amang da si Sakariyas. ");
INSERT INTO kqe_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ansinyan pagkatapos ng gawbuk ni Sakariyas adto sang Baay ng Tohan yomori da yan. ");
INSERT INTO kqe_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wa akadogay disinyan yagkabdus da yang asawa nan na si Hashiba. Aw sa suud ng limambowan wa yan apanaw sikun sang baay. ");
INSERT INTO kqe_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Laong nan, “Madyaw yang ininang kanak ng Tohan kay tyatabangan nan ako aw kyakamang da nan yang yagapakasipug kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ansinyan sang ikaunum na bowan ng pagkabdus ni Hashiba syosogo ng Tohan yang kanan malaikat na si Jibrail adto sang longsod ng Nasarit na sakop ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Syosogo yan adto sang sambok na daaga na pyagangaanan ni Mariyam. Yani si Mariyam tyatawas ni Yosop na topo ni Soltan Daud. ");
INSERT INTO kqe_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ansinyan dyomood yang malaikat kang Mariyam aw laong nan, “Assalamo alaykom, kay Mariyam. Kyakaloyan kaw ng Tohan aw iyan yan sang masaid kanmo.” ");
INSERT INTO kqe_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na, pagdungug ni Mariyam sinyan na pyaglaongan ng malaikat, bali na karido nan aw yabay nan dumdumun daw ono yang mana sidto na pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ansinyan yagalaong yang malaikat kanan, “Ayaw da magkalluk, kay Mariyam, kay kyakaloyan kaw ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sang di amadogay amabdus kaw aw amanganak kaw ng usug aw pagangaanan mo yan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Amainang yan ng bantoganun aw pagatawagun yan na Anak ng Labi na Makagwas. Atagan yan ng Tohan ng kapatot pagdato sang mga otaw na magonawa sang kapatot ni Soltan Daud na ompo nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ansinyan magadato yan sang mga topo ni Yakob taman sa taman kay way kataposan ng pagkasoltan nan.” ");
INSERT INTO kqe_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ansinyan yagalaong si Mariyam sang malaikat, “Monono yang pagpanganak ko na daaga pa sa ako?” ");
INSERT INTO kqe_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tyomobag yang malaikat aw laong nan, “Madatung kanmo yang Nyawa ng Tohan aw magapabilin kanmo yang kabarakat ng Labi na Makagwas. Sabap sinyan sotti yang isu na amaotaw aw pagatawagun yan na Anak ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dumduma oman yang lomon mo na si Hashiba. Yagakabdus yan aw akaonan yan ng anak na usug maskin boyag da. Yan na bobay na di kono makaanak, ikaunum na bowan da adon ng pagkabdus nan ");
INSERT INTO kqe_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kay way butang na di amabaoy ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tyomobag si Mariyam, laong nan, “Idi kay ako na allang ng Tohan. Atarimaun ko yang pyagakahanda nan kanak aw amatoman pa gao yang pyaglaongan mo kanak.” Pagkatapos sinyan ibiya kanan yang malaikat. ");
INSERT INTO kqe_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wa akadogay disinyan yagaimus da si Mariyam aw yomapas-apas yan komadto sang sambok na banwa sang kabtayan ng Yahodiya. ");
INSERT INTO kqe_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagdatung nan sidto na banwa, yamanaos yan sang baay ni Sakariyas aw yagasalam yan kang Hashiba. ");
INSERT INTO kqe_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na, pagdungug ni Hashiba sang pagsalam ni Mariyam, tyomokaw misnang yang isu sang dubdub nan. Pyagabuutan si Hashiba ng Nyawa ng Tohan ");
INSERT INTO kqe_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aw yagalaong yan ng matanog, laong nan, “Dakowa yang kadyawan na yatag kanmo ng Tohan na labaw pa sang kariko ng kaobayan! Aw dakowa oman yang kadyawan na yatag nan adto sang anak mo. ");
INSERT INTO kqe_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na, sino kadi ako na bisitaun ako ng ina ng kanak Dato? ");
INSERT INTO kqe_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kay pagdungug pa ko gaid sang pagsalam mo, tyomokaw misnang yang isu sang dubdub ko na maynang yamasowat yan. ");
INSERT INTO kqe_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bali na kadyaw ng ginawa mo kay yasarig kaw na amatoman yang pyaglaongan kanmo ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ansinyan yagalaong si Mariyam, “Pyopoji ko yang Tohan sang kanak pangatayan, ");
INSERT INTO kqe_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aw bali na kasowat ko sabap sang Tohan na kanak Manlolowas. ");
INSERT INTO kqe_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kay kyakadumduman nan ako na kanan gaid allang. Aw sikun adon magalaong yang kariko ng mga otaw na bali na kadyaw ng ginawa ko ");
INSERT INTO kqe_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sabap sang mga katingaan na ininang kanak ng Tohan na Labi na Mabarakat. Sotti yang ngaan nan! ");
INSERT INTO kqe_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yamallat yan sang mga otaw na aon alluk kanan maskin pa sang mga katopo-topowan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pyapakita nan yang kanan kabarakat sabap sang mga inang nan aw pyapangkaya-kaya nan yang mga otaw na yagapataas sang ginawa nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kyakamangan nan ng kapatot yang mga soltan aw pyapataas nan yang mga otaw na mababa yang kabutang nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yatagan nan ng mangkadyaw na mga butang yang mga yamagutum aw pyapapanaw nan ng way daa yang mga sapian. ");
INSERT INTO kqe_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tyatabangan nan yang bangsa Israil na kanan allang aw tyotoman nan yang kanan pasad sang kanatun kaompowan. ");
INSERT INTO kqe_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kay yagapasad yan kang Nabi Ibrahim aw yang mga topo nan na amallat yan kanatun taman sa taman.” ");
INSERT INTO kqe_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, ansinyan yagapabilin pa si Mariyam adto kang Hashiba ng mga toombowan. Pagkatapos, yomori da yan. ");
INSERT INTO kqe_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Adon dyomatung da yang wakto ng pagpanganak ni Hashiba aw yamanganak yan ng usug. ");
INSERT INTO kqe_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagdungug ng mga simbaay kipat sang mga kalomonan ni Hashiba na dakowa yang looy na pyapakita kanan ng Tohan, yamangkasowat silan upud kanan. ");
INSERT INTO kqe_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na, sang ikawaong allaw da ng isu kyomadto kanilan Hashiba yang mga simbaay aw yang mga kalomonan nan kay otoliun da nilan yang isu. Aw pagangaanan gao nilan yan ni Sakariyas magonawa sang ama nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Awgaid yagalaong yang ina ng isu, “Ayaw, kay yang pagangaan kanan si Yahiya.” ");
INSERT INTO kqe_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Nanga sa kadi?” laong nilan. “Waa say lomon mayo na Yahiya yang ngaan.” ");
INSERT INTO kqe_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Agaw sisingyasan da nilan si Sakariyas daw sino yang pagangaan nan sang isu. ");
INSERT INTO kqe_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ansinyan yagapakamang si Sakariyas ng soratanan aw syosorat nan, “Yang ngaan nan si Yahiya.” Aw yamangkatingaa da yang kariko nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na, pagkasorat dakman ni Sakariyas sang ngaan ng isu, yakapagtiyab da oman yan aw yagapoji sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ansinyan yamangkalluk yang kariko ng mga simbaay nilan. Aw yang gogodanun makapantag sini na pangitabo yamakarimpud sang kariko ng mga banwa sang kabtayan ng Yahodiya. ");
INSERT INTO kqe_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aw yang kariko ng mga yamakadungug sinyan yanaglaong sang ginawa nilan, “Ono pa kowaw yang inangun sini na isu kong dakowa da yan?” Kay yamaklaro da na yagadan yang isu ng kabarakat ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ansinyan pyagabuutan si Sakariyas na ama ng isu ng Nyawa ng Tohan aw yakapaglaong yan sang pyaglaongan ng Tohan. Laong nan, ");
INSERT INTO kqe_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pojiun ta yang Tohan na syasambayangan ng bangsa Israil kay yakani yan antak lowasun nan kita na mga sakop nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pyapadaa nan adi kanatun yang sambok na manlolowas na mabarakat na topo ni Soltan Daud na kanan allang. ");
INSERT INTO kqe_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Idto yang pyapakatigam nan kanatun pinaagi sang kanan mga nabi sangaong ona pa. ");
INSERT INTO kqe_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yagapasad yan na olowasun nan kita sikun sang kanatun mga kalaban aw sikun oman sidtong yagadumut kanatun. ");
INSERT INTO kqe_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yagalaong oman yan na amallat yan sang kanatun kaompowan aw di nan akaringawan yang kanan pasad na inangun nan silan ng mga otaw na sakop nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Idto yang kanan pasad sang kanatun ompo na si Nabi Ibrahim ");
INSERT INTO kqe_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na olowasun nan kita sikun sang kanatun mga kalaban antak kita makapangagad kanan ng way alluk ");
INSERT INTO kqe_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","aw antak kita mainang ng sotti aw matorid sang atobangan nan sang tibok natun na kinabowi.” ");
INSERT INTO kqe_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ansinyan yagalaong si Sakariyas sang anak nan, “Ikaw, kay Olo, pagatawagun kaw na nabi ng Tohan na Labi na Makagwas kay amaona kaw sang pagdatung ng Dato na Labi na Mabarakat antak andamun mo yang agianan nan. ");
INSERT INTO kqe_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ikaw yang magapakatigam sang mga otaw na sakop nan na amalowas silan kong amangayo silan ng ampon sang mga dosa nilan. ");
INSERT INTO kqe_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kay yang kanatun Tohan labi na maloyanun. Aw sabap sinyan apakaniun nan kanatun yang manlolowas sikun sang sorga na magonawa sang pagsilat ng suga ");
INSERT INTO kqe_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","antak kaamdagan nan yang kariko ng mga otaw na iyan sang kaduguuman aw yamalluk matay, aw antak pagindowan nan kita sang daan ng kalinaw.” ");
INSERT INTO kqe_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ansinyan tyomorin da yang anak ni Sakariyas aw yagakatigsun yang dumduman nan. Yagauya yan adto sang mamingaw na banwa taman sidtong wakto na yagaindo da yan sang mga otaw na bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sidto na panahon yagasogo si Agosto na soltan sang Roma na apabilang yang kariko ng mga otaw na sakop sang pyagadatowan nan. ");
INSERT INTO kqe_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yani pa yang pukas na pagbilang sang wakto na si Kiriniyos yang gobirnador sang probinsya ng Siriya. ");
INSERT INTO kqe_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Agaw yanagsiori da yang mga otaw adto sang banwa ng kanilan kaompowan antak magpalista sang ngaan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Adon si Yosop, pyomanaw yan sikun sang Nasarit na sakop ng Jalil aw kyomadto yan sang Baytlaham sa Yahodiya, yang longsod na pyagasikunan ni Soltan Daud kay sambok na topo yan ni Soltan Daud. ");
INSERT INTO kqe_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kyomadto yan upud kang Mariyam na tyatawas nan antak magpalista silan. Aw sidto na wakto mabdus da si Mariyam. ");
INSERT INTO kqe_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na, sarta adto silan sang Baytlaham dyomatung da yang wakto na akaotawan si Mariyam. ");
INSERT INTO kqe_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ansinyan yamanganak yan ng panganay nan na usug aw balota nan ng tela aw pakowanga nan ansang pyagapakanan ng mga ayup. Ansan da silan adatung sang kolongan ng mga ayup kay waa day logar sang baay na yadatungan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, sidto na gabi aon mga otaw na yagabantay sang mga karniro nilan adto sang pyapanamsaman na masaid sinyan na longsod. ");
INSERT INTO kqe_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sakadyap disinyan aon yagapakita kanilan na malaikat na syosogo ng Tohan aw kyakaamdagan silan ng kasiga ng Tohan. Agaw, bali na kalluk nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Awgaid yagalaong kanilan yang malaikat, “Ayaw kamo magkalluk kay yakani ako antak magpakatigam kamayo ng madyaw na gogodanun na amakasowat sang kariko ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kay adon na gabi, disidtong longsod ni Soltan Daud, yamaotaw yang manlolowas mayo na yan yang Almasi, yang Dato na Labi na Mabarakat. ");
INSERT INTO kqe_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yani kay yang tanda kamayo na bunna yang pyagalaong ko kamayo. Aw komadto kamo aon makita mayo na isu na byabalot ng tela aw yagakowang ansang pyagapakanan ng mga ayup.” ");
INSERT INTO kqe_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sakadyap disinyan yumupud da sinyan na malaikat yang madaig pa na mga malaikat sikun sang sorga na yanagpoji sang Tohan, laong nilan, ");
INSERT INTO kqe_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pojiun ta yang Tohan na adto sang sorga aw adi sang donya kaonan ng kalinaw yang mga otaw na akasowatan nan!” ");
INSERT INTO kqe_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ansinyan pagbarik ng mga malaikat adto sang sorga, yanagbaaw-baaw yang mga magbabantayay ng karniro aw laong nilan, “Anda, adto da kita sang Baytlaham aw atanawon ta yaning pyapakatigam kanatun ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na, yomapas-apas da silan komadto sang Baytlaham aw kikita nilan si Mariyam aw si Yosop kipat sang isu na yagakowang ansang pyagapakanan ng mga ayup. ");
INSERT INTO kqe_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkita nilan sang isu, gyogogod nilan yang pyaglaongan kanilan ng malaikat makapantag kanan. ");
INSERT INTO kqe_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aw yang kariko ng mga yamakadungug sinyan yamangkatingaa sidtong gogodanun ng mga magbabantayay ng karniro. ");
INSERT INTO kqe_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Awgaid si Mariyam, byubutang nan yang kariko ng dyudungug nan sang pangatayan nan aw yabay nan dumdumun. ");
INSERT INTO kqe_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ansinyan yanagbarik da yang mga magbabantayay ng karniro adto sang pyapanamsaman. Pyopoji aw byabantog nilan yang Tohan sabap sang kariko ng dyudungug aw kikita nilan na yagakaonawa sang pyaglaongan kanilan ng malaikat. ");
INSERT INTO kqe_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagdatung ng ikawaong allaw sikun sang pagkaotaw ng isu, tyotoli nilan yan aw pyagangaanan nilan ni Isa kay idto yang ngaan na yatag kanilan ng malaikat sang wa pa magalakad kanan yang ina nan. ");
INSERT INTO kqe_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ansinyan pagdatung ng allaw na inangun da ni Yosop aw si Mariyam yang pyagasogo sang Hokoman ni Nabi Mosa para sang pagpasotti sang bobay na baya pa yamanganak, kyomadto da silan sang Awrosalam. Dyadaa oman nilan yang isu adto sang Baay ng Tohan kay atag da nilan adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ininang nilan yani kay aon yamakasorat sang Hokoman ng Tohan na yagalaong, “Yang kariko ng mga panganay na usug dait na atag mayo adto sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ansinyan pyapangagadan da nilan idtong pyagalaong sang Hokoman ng Tohan na sang pagpasotti dait na apakorban yang dowambok na tokmo atawa yang dowambok na impis ng salampati. ");
INSERT INTO kqe_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, adto sang Awrosalam aon sambok na otaw na pyagangaanan ni Simiyon. Matorid yan na otaw aw baraibada aw yabay yan magtagad sidtong wakto na madatung da yang magapakatigsun sang pangatayan ng mga otaw na bangsa Israil. Iyan kanan yang Nyawa ng Tohan ");
INSERT INTO kqe_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aw pyapakatigam kanan ng Nyawa ng Tohan na di yan amatay taman sang makita da nan yang Almasi na pyapasad ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na, ansinyan pyapakadto si Simiyon ng Nyawa ng Tohan adto sang Baay ng Tohan. Sinyan na allaw dyomatung oman si Yosop aw si Mariyam na yagadaa kang Isa kay antak inangun nilan yang pyagasogo sang Hokoman. ");
INSERT INTO kqe_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pagkita ni Simiyon sang isu, sisipit nan aw yagapoji yan sang Tohan na laong nan, ");
INSERT INTO kqe_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ya Tohan, maskin bogtoon da mo adon yang napas ko, madyaw da kanak kay yamatoman da yang pasad mo kanak na allang mo. ");
INSERT INTO kqe_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kay adon kikita da ko sang dowa na mata ko yang manlolowas na syosogo mo. ");
INSERT INTO kqe_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pyapadaa mo yan adi sining donya antak makita yan ng kariko ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yan yang allag na magapakatigam sang mga otaw na dili ng Yahodi daw sino kaw. Aw yan yang kabantog ng bangsa Israil na sakop mo.” ");
INSERT INTO kqe_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na, yang mga taganak ni Isa yamangkatingaa sang pyaglaongan ni Simiyon makapantag sang anak nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ansinyan pyapangayowan silan ni Simiyon ng kadyawan adto sang Tohan aw yagalaong yan adto kang Mariyam na ina ng isu, laong nan, “Yani na isu, pyagakahanda yan ng Tohan na amainang ng pyagasabapan sang paglowas aw pagsapad ng madaig na mga otaw na bangsa Israil. Kay yan yang tanda na yatag ng Tohan kanatun, awgaid madaig yang mosopak kanan. ");
INSERT INTO kqe_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sabap kanan amapayag daw ono yang adto sa suud ng pangatayan nilan. Ikaw oman, akasakitan yang pangatayan mo na maynang dyodonggab kaw ng matalas na lodyo.” ");
INSERT INTO kqe_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na, adto sang Baay ng Tohan aon oman sambok na nabi na boyag da na pyagangaanan ni Ana. Anak yan ni Panuel na tribo ni Asir. Pitongka toig gaid nan mapagtibu sang bana nan aw yamabiyoda da yan. ");
INSERT INTO kqe_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aw adon 84 ka toig yang idad nan. Wa gaid yan apanaw sang Baay ng Tohan kay allaw-gabi adto yan magaibada sang Tohan na yagadowaa aw yagapowasa. ");
INSERT INTO kqe_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na, sidto na wakto sarta yagatiyab pa si Simiyon, dyomood yan kanilan. Yamanginsokor yan sang Tohan aw yagalaong yan ng makapantag sang isu adto sang mga otaw na yagatagad sang wakto na olowasun da ng Tohan yang mga taga Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ansinyan nang yamatapos da inangun ni Yosop aw si Mariyam yang kariko ng pyagasogo sang Hokoman ng Tohan, yomori da silan adto sang kanilan pyagauyaan sang longsod ng Nasarit na sakop ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ansinyan tyomorin da yang isu aw yagakadogang yang kusug nan. Yagakadakowa oman yang kanan katigam aw yabay yan tabangan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, kada toig yakadto yang mga taganak ni Isa sang Awrosalam para sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ansinyan nang yagaidad si Isa ng sampoo aw dowangka toig, pyagaagad yan ng mga taganak nan pagkadto nilan sidtong pakaradyaan sobay sang kyakaanadan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkatapos ng pakaradyaan yomori da silan, awgaid yagapabilin si Isa adto sang Awrosalam na wa akatigam yang mga taganak nan. ");
INSERT INTO kqe_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kay yang pagdumdum nilan na yamagad si Isa sang kadaigan pa na mga otaw na yomori upud kanilan. Agaw, sangka allaw da yang panaw nilan bago pa nilan anapa si Isa adto sang mga kalomonan aw mga inagad nilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nang wa nilan ikitaa, byomarik silan adto sang Awrosalam kay antak manganap kanan. ");
INSERT INTO kqe_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatoong allaw disinyan kikita nilan si Isa adto sang Baay ng Tohan na yagaingkod upud sang mga magiindoway ng Hokoman. Yamaningug yan aw yagaosip yan kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aw yang kariko ng mga yamakadungug kanan yamangkatingaa sang kanan katigam aw sang kadyaw ng mga tobag nan. ");
INSERT INTO kqe_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Adon, pagkita kanan ng mga taganak nan, yamatingaa oman silan aw laong ng ina nan, “Nanga da kaw, kay Itin! Dakowa yang karido nami si ama mo sang paganap kanmo daw wain da kaw!” ");
INSERT INTO kqe_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ansinyan tyomobag si Isa kanilan, laong nan, “Nanga sa yanap mayo ako? Wa kadi kamo akatigam na dait na idi ako sang baay ng Ama ko?” ");
INSERT INTO kqe_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Awgaid wa silan makasabot sidtong pyaglaongan nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ansinyan yamagad da si Isa sang mga taganak nan aw yomori silan adto sang Nasarit. Aw yabay da yan mangagad sang kariko ng pyaglaongan ng mga taganak nan. Awgaid yang ininang ni Mariyam, tyatago nan yang kariko sining yamangkainang sa suud ng pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ansinyan yabay tomorin si Isa aw yagakadogang oman yang katigam nan. Kyakaloyan yan ng Tohan kipat oman sang kariko ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ansinyan sang ika-15 na ka toig ng pagkasoltan ni Tibiriyo na yan yang soltan sang bangsa Roma, si Pontiyos Pilato yang gobirnador sang probinsya ng Yahodiya aw si Hirod yang pangoo sang probinsya ng Jalil. Yang lomon ni Hirod na si Pilip yang pangoo sang mga probinsya ng Itoriya aw Tarakonitis, aw si Lisaniyas yang pangoo sa Abilin. ");
INSERT INTO kqe_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yang mga Dakowa na Imam si Anas aw si Kayapas. Na, sidto na wakto pyapasampay ng Tohan yang kanan pyaglaongan adto kang Yahiya na anak ni Sakariyas nang idto yan magauya sang kamingawan. ");
INSERT INTO kqe_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agaw pyomanaw da si Yahiya aw kadtowi nan yang kariko ng mga banwa na masaid sang tobig ng Yordan aw yagaosiyat yan sang mga otaw. Laong nan, “Pagtawbat kamo sang mga dosa mayo aw pagpasogbo kamo silbi tanda ng pagtawbat mayo antak amponon ng Tohan yang mga dosa mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yani na ininang ni Yahiya yang pagtoman sang syosorat ni Nabi Isayas sang Kitab na laong nan, “Aon sangka otaw na manawag-tawag adto sang kamingawan aw laong nan, ‘Andama mayo yang daan para sang Dato na Labi na Mabarakat aw patorida mayo yang agianan nan. ");
INSERT INTO kqe_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yang kariko ng mga aog abonowan, yang kabtayan pantayun. Yang mga daan na liko-liko toridun aw yang mga daan na batoon dadayawon. ");
INSERT INTO kqe_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aw ansinyan makita ng kariko ng manosiya daw ono yang inangun ng Tohan sang paglowas kanilan.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, madaig yang mga otaw na kyomadto kang Yahiya antak magpasogbo. Yagalaong si Yahiya kanilan, “Kamo na mga limbongon! Sino kadi yang yagalaong kamayo na kong magapasogbo kamo, makalikay kamo sang siksa ng Tohan na mallug da domatung? ");
INSERT INTO kqe_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na, kong di mayo karim na isiksaun kamo, pakitaan da gaid mayo pinaagi sang madyaw na batasan na bunna na tyatarikodan da mayo yang mga dosa mayo. Aw ayaw kamo magdumdum na di kamo isiksaun kay mga topo kamo ni Nabi Ibrahim. Kay pagalaong ko kamayo na maskin yaning mga bato amabaoy ng Tohan na mga topo ni Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Timani mayo na main kamo ng kaoy na mallug da pilaun. Kay yang kariko ng kaoy na way madyaw na bonga ipilaun aw timbagan adto sang atoon.” ");
INSERT INTO kqe_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ansinyan yagaosip kanan yang mga otaw, laong nilan, “Na, kong maynan, ono da yang inangun nami?” ");
INSERT INTO kqe_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tyomobag si Yahiya aw laong nan, “Sino-sino kamayo yang aon dowambok na dagom, dait na atag nan yang sambok adto sang way dagom. Aw kong aon pagkan mayo, atagi mayo yang way pagkan.” ");
INSERT INTO kqe_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aon oman mga mangobraay ng bowis na kyomadto kang Yahiya antak magpasogbo. Yagaosip silan kanan, “Na kami, kay Goro, ono yang dait nami inangun?” ");
INSERT INTO kqe_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tyomobag si Yahiya aw laong nan kanilan, “Ayaw kamo magpangobra ng sobra sang pyagasogo kamayo ng gobirno.” ");
INSERT INTO kqe_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na, aon oman mga sondao na yagaosip kanan, laong nilan, “Na, monono da kami, ono yang dait nami inangun?” Tyomobag si Yahiya kanilan, “Ayaw kamo magpamugus sang mga otaw atawa magbutang-butang kanilan antak kamo atagan ng sapi. Aw dait na panginsokoran mayo yang soweldo mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Adon, pagdungug ng mga otaw sang pagosiyat ni Yahiya, yagadumdum silan na basin si Yahiya yang pyapasad na Almasi na tyatagadan ng bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awgaid yagalaong si Yahiya kanilan, laong nan, “Tobig yang pyagasogbo ko kamayo, awgaid aon mosonod kanak domatung na labaw pa kanak. Maskin yang pagobad ng liston ng sandalyas nan di dait kanak. Yang pagasogbo nan sang kadaigan kamayo yang Nyawa ng Tohan aw yang kadaigan oman isiksaun nan sang atoon adto sang narka. ");
INSERT INTO kqe_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yan da yang magahokom sang manosiya aw lainun nan yang mangkadyaw sikun sang mangkaat. Kay main yan ng otaw na magtaap ng omay. Pagkatapos magtaap, tagoon nan yang omay adto sang kamarig. Awgaid yang tipig osonogon nan sang atoon na di amatay.” ");
INSERT INTO kqe_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na, madaig pa yang pyagaindo ni Yahiya sang mga otaw sang pagosiyat nan kanilan ng Madyaw na Gogodanun aw pyagalaong nan silan na isabun nilan yang batasan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aw maskin pa si Hirod na pangoo sang Jalil syasagda ni Yahiya kay pyapangasawa nan si Hirodiya na asawa ng lomon nan na si Pilip aw madaig pa yang ininang nan na maat. ");
INSERT INTO kqe_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aw sang orian dyodogangan pa ni Hirod yang kaatan nan kay pyapapiriso nan si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, sang wakto na wa pa ipirisowa si Yahiya, madaig yang mga otaw na yagapasogbo kanan. Maskin oman si Isa yagapasogbo kanan. Pagkatapos kasogbowan si Isa, yagadowaa yan. Aw sidto na wakto yagaboka yang langit ");
INSERT INTO kqe_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aw yang Nyawa ng Tohan yukunsad adto kanan sang porma ng salampati. Aon oman sowara sikun sang langit na yagalaong, “Ikaw yang pyapasaya ko na Anak. Dakowa yang kasowat ko kanmo.” ");
INSERT INTO kqe_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Adon si Isa, yagasogod yan magindo sang mga otaw sang yagaidad yan ng mga 30 ka toig. Sang dumduman ng mga otaw anak yan ni Yosop. Si Isa makiompo ni Hili. ");
INSERT INTO kqe_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Hili anak ni Matat. Si Matat anak ni Libi. Si Libi anak ni Malki. Si Malki anak ni Yanai. Si Yanai anak ni Yosop. ");
INSERT INTO kqe_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Yosop anak ni Matatiyas. Si Matatiyas anak ni Amos. Si Amos anak ni Nahom. Si Nahom anak ni Isli. Si Isli anak ni Nagay. ");
INSERT INTO kqe_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagay anak ni Maat. Si Maat anak ni Matatiyas. Si Matatiyas anak ni Simain. Si Simain anak ni Yosik. Si Yosik anak ni Yoda. ");
INSERT INTO kqe_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Yoda anak ni Yowanan. Si Yowanan anak ni Risa. Si Risa anak ni Sirobabil. Si Sirobabil anak ni Salatiyal. Si Salatiyal anak ni Niri. ");
INSERT INTO kqe_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Niri anak ni Malki. Si Malki anak ni Addi. Si Addi anak ni Kosam. Si Kosam anak ni Ilmadam. Si Ilmadam anak ni Ir. ");
INSERT INTO kqe_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Ir anak ni Yossa. Si Yossa anak ni Ilisir. Si Ilisir anak ni Yorim. Si Yorim anak ni Matat. Si Matat anak ni Libi. ");
INSERT INTO kqe_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Libi anak ni Simiyon. Si Simiyon anak ni Yodah. Si Yodah anak ni Yosop. Si Yosop anak ni Yonam. Si Yonam anak ni Iliyakim. ");
INSERT INTO kqe_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Iliyakim anak ni Miliya. Si Miliya anak ni Mainan. Si Mainan anak ni Matata. Si Matata anak ni Natan. Si Natan anak ni Daud. ");
INSERT INTO kqe_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si Daud anak ni Isai. Si Isai anak ni Obid. Si Obid anak ni Booz. Si Booz anak ni Salmon. Si Salmon anak ni Nason. ");
INSERT INTO kqe_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Nason anak ni Aminadab. Si Aminadab anak ni Admin. Si Admin anak ni Arni. Si Arni anak ni Isrom. Si Isrom anak ni Paris. Si Paris anak ni Yodah. ");
INSERT INTO kqe_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Yodah anak ni Yakob. Si Yakob anak ni Isahak. Si Isahak anak ni Ibrahim. Si Ibrahim anak ni Tirah. Si Tirah anak ni Nahor. ");
INSERT INTO kqe_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor anak ni Sirog. Si Sirog anak ni Ragaw. Si Ragaw anak ni Pilig. Si Pilig anak ni Ibir. Si Ibir anak ni Silah. ");
INSERT INTO kqe_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Silah anak ni Kainan. Si Kainan anak ni Arpaksad. Si Arpaksad anak ni Sim. Si Sim anak ni Noh. Si Noh anak ni Lamik. ");
INSERT INTO kqe_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamik anak ni Mitosala. Si Mitosala anak ni Idris. Si Idris anak ni Yarid. Si Yarid anak ni Mahalalil. Si Mahalalil anak ni Kinan. ");
INSERT INTO kqe_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Kinan anak ni Inos. Si Inos anak ni Sit. Si Sit anak ni Adam. Si Adam anak ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pagkatapos kasogbowan si Isa, pyagabuutan yan ng Nyawa ng Tohan. Ansinyan pyomanaw yan sikun sang tobig ng Yordan aw dyadaa yan ng Nyawa ng Tohan adto sang kamingawan. ");
INSERT INTO kqe_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ansidto syasatsat yan ni Iblis sa suud ng 40 na mga allaw. Way kyakan nan sidto na wakto aw pagkatapos ng 40 na mga allaw yamagutum da yan. ");
INSERT INTO kqe_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ansinyan yagalaong si Iblis kang Isa, “Aw bunna ikaw yang Anak ng Tohan, sogowa yaning bato na amainang ng pan.” ");
INSERT INTO kqe_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Awgaid tyomobag si Isa aw laong nan, “Yamakasorat sang Kitab, ‘Yang manosiya di amabowi sabap sang pagkan da gaid.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapos sinyan dyadaa yan ni Iblis adto sang makagwasay na logar aw sang pagpamiluk gaid ng mata pyapakita nan kanan yang kariko ng mga pyagadatowan adi sang babawan ng donya. ");
INSERT INTO kqe_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ansinyan yagalaong si Iblis kang Isa, “Atag ko kanmo yang kapatot makapantag sang kariko sining mga pyagadatowan aw yang kakawasaan sinyan, kay taman yani yatag da kanak. Aw mapakay na atag ko yani sang maskin sino na akallinian ko. ");
INSERT INTO kqe_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Agaw, yang kariko sini amangkun mo kong mosojod kaw kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tyomobag si Isa aw laong nan, “Yamakasorat sang Kitab, ‘Yang Tohan na kanmo Tagallang, yan gaid yang asambayangan aw apangagadan mo.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatapos sinyan dyadaa yan ni Iblis adto sang Awrosalam aw painduga nan sang labi na makagwas na bain sang Baay ng Tohan. Ansinyan yagalaong si Iblis kang Isa, “Aw bunna ikaw yang Anak ng Tohan, layog adto daum! ");
INSERT INTO kqe_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kay yamakasorat sang Kitab na “ ‘Osogoon ng Tohan yang kanan mga malaikat sang pagatiman kanmo. ");
INSERT INTO kqe_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Asakgawon kaw nilan antak yang siki mo di komuug sang bato.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Awgaid tyomobag si Isa, “Yamakasorat oman sang Kitab na, ‘Ayaw pagtigia yang Tohan na kanmo Tagallang.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pagkatapos sining mga pagsatsat ni Iblis kang Isa pyapanawan da nan yan kay atagadan nan yang tuna pa na wakto. ");
INSERT INTO kqe_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ansinyan byomarik si Isa sang probinsya ng Jalil na iyan kanan yang kabarakat ng Nyawa ng Tohan. Aw yang gogodanun makapantag kanan yamakarimpud sang makilibot na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yagaindo yan adto sang mga pagsasambayangan ng mga Yahodi aw byabantog yan ng kariko ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ansinyan kyomadto si Isa sang Nasarit, yang longsod na tyotorinan nan. Pagdatung ng allaw ng Sabado na Allaw ng Pagpatana ng mga Yahodi, kyomadto yan sang pagsasambayangan sobay sang kyakaanadan nan. Ansinyan imindug yan kay magabatya ng Kitab. ");
INSERT INTO kqe_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aw yatag kanan yang Kitab na lyuluun na syosorat ni Nabi Isayas. Pagboklad nan sinyan, kikita nan yang mga ayatan na yagalaong, ");
INSERT INTO kqe_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Idi kanak yang Nyawa ng Tohan kay pipili nan ako antak magpayapat ng Madyaw na Gogodanun adto sang mga miskinan. Syosogo nan ako antak magpakatigam sang mga yamapiriso na palogwaun da silan aw yang mga bota na makakita da silan. Syosogo nan ako antak tabangan ko yang mga dyadaog-daog, ");
INSERT INTO kqe_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aw antak magpakatigam na dyomatung da yang wakto na olowasun da ng Tohan yang mga otaw na sakop nan.” ");
INSERT INTO kqe_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ansinyan lyuluun da oman ni Isa yang Kitab aw orian nan sang tigtabang sidto na pagsasambayangan aw pagingkod. Na, yang kariko ng mga otaw ansan yagatanaw kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ansinyan yagalaong si Isa kanilan, “Yani na yamakasorat sang Kitab yamatoman da adon sarta dyudungug mayo yani na byabatya ko.” ");
INSERT INTO kqe_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ansinyan byabantog yan ng kariko nilan aw yamatingaa silan sang madyaw na pyaglaongan nan. Aw laong oman nilan, “Di ba yani yang anak ni Yosop?” ");
INSERT INTO kqe_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ansinyan yagalaong si Isa kanilan, “Yamatigam ako na pagalaongon mayo ako sidtong pasombingay na yagalaong, ‘Kay mananambalay, pakadyawa nay ona yang ginawa mo.’ Aw magalaong oman kamo na inangun ko adi sang sarili na longsod ko yang dyudungug mayo na ininang ko adto sang Kapirnaom. ");
INSERT INTO kqe_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Awgaid bunna yang pagalaong ko kamayo na yang nabi di addatan sang kanan banwa. ");
INSERT INTO kqe_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na, paningug kamo. Sidtong panahon ni Nabi Iliyas, way owan sa suud ng toongka toig aw tunga aw dakowa yang gutum sang tibok banwa ng Israil. Bunna na madaig yang mga biyoda sang Israil sidtong panahon, ");
INSERT INTO kqe_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","awgaid wa osogowa ng Tohan si Nabi Iliyas sang maskin isa kanilan, kondi syosogo yan adto sang sambok na biyoda na dili ng Yahodi na idto magauya sang Saripta na sakop ng Sidon. ");
INSERT INTO kqe_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aw bunna oman na madaig yang sanglaun sang banwa ng Israil sidtong panahon ni Nabi Ilisiyo. Awgaid way maskin isa kanilan na pyapakadyaw yatabiya si Naaman na taga Siriya.” ");
INSERT INTO kqe_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na, pagdungug sinyan yamadaman da yang kariko ng mga Yahodi ansang pagsasambayangan. ");
INSERT INTO kqe_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ansinyan imindug silan aw goyoda nilan si Isa adto sa logwa ng longsod na iyan sang babaw ng butay kay antak oogon gao nilan si Isa sang kuba. ");
INSERT INTO kqe_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Awgaid yamagi si Isa sang tunga nilan aw pyomanaw. ");
INSERT INTO kqe_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ansinyan kyomadto si Isa sang Kapirnaom na sambok na longsod na sakop ng Jalil. Pagdatung ng Allaw ng Pagpatana, yagaosiyat yan sang mga otaw adto sang pagsasambayangan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yamangkatingaa silan sang pagindo nan kay yagaindo yan na aon kapatot. ");
INSERT INTO kqe_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sidto na pagsasambayangan aon sangka otaw na kyakasaytanan. Pagkita nan kang Isa, yamangiyak yan ng matanogay, laong nan, ");
INSERT INTO kqe_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oy! Ono yang labot mo kanami, kay Isa na taga Nasarit? Yakani kaw sang pagsapad kanami? Yamatigam ako daw sino kaw, ikaw yang sotti na syosogo ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Awgaid syasagda ni Isa yang saytan, laong nan, “Katingun aw logwa da sinyan na otaw!” Na, sang atobangan ng kariko nilan tyotowad ng saytan idtong otaw. Pagkatapos, lyomogwa da yang saytan aw wa da nan apakasikoti idtong otaw. ");
INSERT INTO kqe_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ansinyan yamangkatingaa da yang kariko ng mga otaw aw yanaginosipay silan, laong nilan, “Ono kadi yani na indowan? Kay aon kapatot aw kabarakat nan pagsogo sang mga saytan aw mologwa da silan!” ");
INSERT INTO kqe_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na, ansinyan yamakarimpud yang gogodanun makapantag kang Isa adto sang makilibot na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagkatapos sinyan lyomogwa si Isa sikun sidtong pagsasambayangan aw kyomadto yan sang baay ni Simon. Adon, yang ogangan na bobay ni Simon yamasakit aw labi na mapaso yang lawas nan. Agaw yangyo nilan si Isa na atabangan nan idtong bobay. ");
INSERT INTO kqe_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ansinyan dyomood si Isa sang kowangan nan aw papanawa nan yang kapaso sikun sang lawas nan aw yamadyaw dayon yan. Na, yagabangon da yan aw pakana nan silan Isa. ");
INSERT INTO kqe_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ansinyan pagsallup ng suga, dyadaa ng mga otaw yang kariko ng mga masakitun na maskin ono yang sakit nilan adto kang Isa. Aw dyadapunan ni Isa yang matag-isa kanilan ng arima nan aw pakadyawa nan silan. ");
INSERT INTO kqe_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Madaig oman yang mga saytan na pyapalogwa nan sikun sang mga otaw, aw paglogwa nilan yamangiyak silan, “Ikaw yang Anak ng Tohan!” Awgaid syasagda silan ni Isa aw wa nan silan otogoti na magatiyab kay kyakatigaman nilan na si Isa yang Almasi. ");
INSERT INTO kqe_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagkailaw disinyan ng kaamdagay pa pyomanaw si Isa aw kyomadto yan sang mamingaw na banwa. Ansinyan pyapanganap yan ng mga otaw. Pagkita nilan kanan, pyagadumutan nilan yan. ");
INSERT INTO kqe_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Awgaid yagalaong si Isa kanilan, “Kinaanglan na magapayapat oman ako adto sang kadaigan pa na mga banwa ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan. Kay yan yang katoyowan nanga sa syosogo ako adi sining donya.” ");
INSERT INTO kqe_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ansinyan yabay magosiyat si Isa adto sang mga pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sangallaw disinyan yagaindug si Isa adto sang kilid ng Linaw ng Ginisarit. Madaig yang mga otaw na yanagkatipon adto kanan aw yanagdinutdutay silan antak makapaningug silan sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ansinyan aon kikita ni Isa na dowambok na bangka na dyadaik sang baybay. Bibiyaan silan ansan ng mga mangingisdaay kay yanagogas silan sang kanilan pokot. ");
INSERT INTO kqe_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Adon, syomakay si Isa sang sambok na bangka na kang Simon aw yangyo nan si Simon na idoso nan yang bangka ng tagbis adto sang tobig. Ansinyan imingkod si Isa aw yagaindo yan sang mga otaw sikun sang bangka. ");
INSERT INTO kqe_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapos nan magindo, yagalaong yan kang Simon, “Pagbugsay kamo palaod aw taktaka mayo yang pokot antak aon amakamang mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yagalaong si Simon, “Kay Dato, sanggabi pa kami yamanagat aw way yamakamang nami. Awgaid sabap sang pyaglaongan mo ataktak ko yang pokot.” ");
INSERT INTO kqe_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Taktaka sagaw nilan yang pokot aw madaigay yang isda na yamakamang nilan na apit da gao malasi yang pokot. ");
INSERT INTO kqe_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Agaw sisingyasan nilan yang mga kaupdanan nilan adto sang sambok oman na bangka antak tomabang silan kanilan. Pagdatung nilan, pyopono nilan yang dowambok na bangka ng isda na masaid da gao silan malonod. ");
INSERT INTO kqe_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na, pagkita sinyan ni Simon Pitros, yolood yan sang atobangan ni Isa aw yagalaong yan, “Pagpakawat kanak, kay Dato, kay manosiya ako na baradosa.” ");
INSERT INTO kqe_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kay yamatingaa yan kipat sang kariko ng mga kaupdanan nan sang kadaig ng isda na yamakamang nilan. ");
INSERT INTO kqe_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yamatingaa oman si Yahiya aw si Yakob, yang mga anak ni Sibidi, na mga kaupud ni Simon sang pagpanagat. Ansinyan yagalaong si Isa kang Simon, “Ayaw magkalluk, kay Simon, kay sikun adon indowan ta kaw pagkamang sang mga otaw antak mangagad silan kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ansinyan dyadaik nilan yang mga bangka, bibiyaan nilan yang kariko ansan aw yamagad silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sangallaw disinyan nang adto si Isa sang sambok na longsod, aon dyomatung na otaw na sanglaun. Pagkita nan kang Isa, syomojod yan sang atobangan nan aw yagapakilooy kanan, laong nan, “Kay Dato, kong karim mo, makapagkadyaw kaw sang kanak sakit.” ");
INSERT INTO kqe_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ansinyan dyadapunan ni Isa yang inyan na otaw ng arima nan aw laong nan, “Ud, karim ko. Amadyaw da kaw.” Na, sinyan na wakto yamawaa yang sangla aw yamadyaw da yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ansinyan pyagalaong yan ni Isa, “Ayaw da yani paglaongan sang maskin sino, awgaid kadto sang imam aw pagpatanaw kanan. Pagpasampay adto sang Tohan ng pyagasogo ni Nabi Mosa sang pagpangimunna sang mga otaw na yamadyaw da kaw.” ");
INSERT INTO kqe_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Awgaid maskin maynan, yamakarimpud da yang gogodanun makapantag kang Isa sang makilibot na mga banwa. Agaw, madaig yang mga otaw na kyomadto kanan antak maningug sang pagosiyat nan aw antak magpakadyaw sang mga sakit nilan. ");
INSERT INTO kqe_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Awgaid si Isa, ugun-ugun yan komadto sang mamingaw na mga banwa aw adto da yan magadowaa. ");
INSERT INTO kqe_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sangallaw disinyan sarta yagaindo si Isa, aon mga Parisi kipat sang mga magiindoway ng Hokoman na yanagingkod sang masaid kanan. Yani silan yagasikun sang yagakatuna-tuna na mga banwa sang Jalil aw Yahodiya aw sikun oman sang Awrosalam. Na, iyan kang Isa yang kabarakat ng Tohan pagpakadyaw sang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ansinyan aon dyomatung na mga otaw na yanaglanting ng sangka otaw na yamasadi yang lawas nan. Yamaningkamot silan somuud sang baay antak madaa nilan idtong otaw sang atobangan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Awgaid sabap sang kadaig ng mga otaw wa silan makasuud. Agaw pyomanik silan sang atup, bosloti nilan yang mga tisa aw tontona nilan idtong otaw sang kowangan nan sang tunga ng mga otaw ansang atobangan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkita ni Isa na dakowa yang pagsarig nilan kanan, yagalaong yan sidtong otaw na sadi, “Kay Itin, yampon da yang mga dosa mo.” ");
INSERT INTO kqe_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagdungug sinyan ng mga Parisi kipat sang mga magiindoway ng Hokoman, yagalaong silan sang ginawa nilan, “Sino kadi yani na otaw na yamangkun ng kapatot ng Tohan? Kay yang Tohan gaid yang makaampon sang dosa ng manosiya!” ");
INSERT INTO kqe_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Awgaid kyakatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Nanga sa maynan yang dumduman mayo? ");
INSERT INTO kqe_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wain yang masayun paglaong, ‘Yampon da yang mga dosa mo,’ atawa ‘Pagbangon aw panaw?’ ");
INSERT INTO kqe_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Adon, antak katigaman mayo na ako na Anak ng Manosiya, aon kapatot ko adi sang babawan ng donya pagampon sang mga dosa, apakadyawon da ko yaning otaw.” Ansinyan yagalaong si Isa sidtong otaw na sadi, “Kay Itin, pagbangon, daa yang kowangan mo aw ori da adto kamayo!” ");
INSERT INTO kqe_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ansinyan yagabangon dayon yan na kikita ng kariko nilan, kamanga yang kowangan nan aw ori adto kanilan na yagapoji sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ansinyan yamangkatingaa yang kariko nilan aw pyopoji nilan yang Tohan. Yamangkalluk oman silan aw laong nilan, “Bali na katingaan yaning kikita natun adon na allaw!” ");
INSERT INTO kqe_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos sinyan pyomanaw da si Isa. Sarta yagapanaw yan, kikita nan yang sambok na mangobraay ng bowis na yagaingkod sang kanan bayadanan ng bowis. Yang ngaan nan si Libi. Laong ni Isa kanan, “Abay da, agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ansinyan imindug si Libi, biyai nan yang kariko ng gawbuk nan aw agad kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wa akadogay disinyan yagapakaradyaan si Libi sang baay nan para kang Isa. Madaig yang mga mangobraay ng bowis aw yang kadaigan pa na mga otaw na yanagupud kanilan koman. ");
INSERT INTO kqe_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pagkita sinyan ng mga Parisi aw yang mga magiindoway ng Hokoman na mga kaupdanan nilan, yagalaong silan sang mga inindowan ni Isa, “Nanga sa yanagpangan aw yanaginum kamo upud sang mga mangobraay ng bowis aw yang kadaigan pa na mga otaw na tyatawag na baradosa?” ");
INSERT INTO kqe_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Awgaid tyomobag kanilan si Isa, “Yang mga otaw na madyaw yang lawas di kinaanglan ng mananambalay, awgaid idtong mga otaw na aon sakit. ");
INSERT INTO kqe_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Magonawa sinyan, yakani ako sining donya dili para sang mga otaw na yagalaong na matorid silan kondi para sang mga otaw na baradosa kay antak magtawbat silan.” ");
INSERT INTO kqe_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ansinyan aon mga otaw na yagalaong kang Isa, “Yang mga inindowan ni Yahiya yabay magpowasa aw magdowaa magonawa oman sang mga inindowan ng mga Parisi. Awgaid yang mga inindowan mo abay gaid managpangan aw managinum. Nanga sa?” ");
INSERT INTO kqe_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tyomobag si Isa, “Mapakay ba paglaongon yang mga bisita sang kawin na magapowasa silan sarta iyan pa kanilan yang usug na akawinun? Dili! ");
INSERT INTO kqe_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Awgaid madatung yang wakto na akamangun da kanilan yang usug na akawinun, aw sidto na wakto magapowasa da silan.” ");
INSERT INTO kqe_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yagalaong oman si Isa ng tuna pa na pasombingay makapantag sang dadaan na indowan aw yang indowan nan, laong nan, “Way otaw na magalasi sang bago na dagom antak otopak nan sang dadaan. Kay kong maynan yang inangun nan, alasiun nan yang bago na dagom aw yang tyotopak dili bagay sang dadaan. ");
INSERT INTO kqe_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Way oman otaw na yang bago na bino alasak nan sang dadaan na lasakanan na ininang ng paris ng ayup. Kay kong maynan yang inangun nan, amalasi yang lasakanan. Na, maasag da yang bino aw amasapad yang lasakanan. ");
INSERT INTO kqe_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Agaw sa, yang bago na bino dait alasak sang bago na lasakanan. ");
INSERT INTO kqe_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Awgaid sino-sino yang yakainum ng dadaan na bino di mallini sang bago kay magalaong yan, ‘Madyaw yang nanam ng dadaan.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sangallaw disinyan na Allaw ng Pagpatana yamagi si Isa kipat sang mga inindowan nan sang pawa ng trigo. Pagagi nilan, yamangutul yang mga inindowan nan ng trigo, ligisa sang arima nilan aw kana. ");
INSERT INTO kqe_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pagkita sinyan ng mga Parisi, yagalaong silan, “Nanga sa ininang mayo yang syasagda kanatun inangun? Sopak sang Hokoman maggawbuk sang Allaw ng Pagpatana!” ");
INSERT INTO kqe_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tyomobag si Isa kanilan, “Wa kadi mayo akabasa yang ininang ni Soltan Daud sang wakto na yamagutum yan kipat sang mga kaupdanan nan? ");
INSERT INTO kqe_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Syomuud yan sang Baay ng Tohan, kamanga nan yang pan na pyapasampay adto sang Tohan, kana aw atagi oman yang mga kaupdanan nan. Na, sopak sang Hokoman yang ininang nilan kay yang mga imam gaid yang makakan sinyan na pan.” ");
INSERT INTO kqe_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Laong oman ni Isa, “Ako na Anak ng Manosiya, aon kapatot ko paglaong daw ono yang mapakay inangun sang Allaw ng Pagpatana.” ");
INSERT INTO kqe_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sang tuna oman na Allaw ng Pagpatana kyomadto si Isa sang pagsasambayangan aw yagaindo. Ansan aon sambok na otaw na yamasadi yang sangkilid na arima nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aon oman mga magiindoway ng Hokoman kipat sang mga Parisi ansan na yagasima kang Isa daw pakadyawon nan idtong otaw sang Allaw ng Pagpatana kay karim nilan na aon akapagoman nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Awgaid kyakatigaman ni Isa yang dumduman nilan. Agaw yagalaong yan sidtong otaw na yamasadi yang sangkilid na arima nan, “Pagindug aw singadi sang atobangan.” Ansinyan imindug idtong otaw aw kadto sang atobangan ng kariko nilan. ");
INSERT INTO kqe_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Adon yagalaong si Isa, “Aon osip ko kamayo. Sobay sang Hokoman, ono yang mapakay inangun sang Allaw ng Pagpatana? Yang paginang ng madyaw atawa maat? Yang paglowas sang kinabowi ng otaw atawa yang pagpatay?” ");
INSERT INTO kqe_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ansinyan pyagatanawan ni Isa yang kariko nilan. Pagkatapos, yagalaong yan sidtong otaw na yamasadi yang sangkilid na arima nan, “Onata yang arima mo!” Na, yonat da nan aw yamadyaw dayon yang arima nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Awgaid labi da yang kadaman ng mga magiindoway ng Hokoman aw yang mga Parisi aw yanagbaaw-baaw silan daw ono yang inangun nilan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wa akadogay disinyan tyomokod si Isa sang sambok na butay aw adto yan magadowaa ng sanggabi. ");
INSERT INTO kqe_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkailaw disinyan tyatawag nan yang kanan mga inindowan aw sikun kanilan pipili nan yang sampoo aw dowa na mga sahabat nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yani silan si Simon na pyagaingaanan nan ni Pitros, aw yang lomon nan na si Andriyas, si Yakob aw si Yahiya, si Pilip aw si Bartolomi, ");
INSERT INTO kqe_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Matiyo aw si Tomas, si Yakob na anak ni Alpiyo, aw si Simon na rebelde sangaon, ");
INSERT INTO kqe_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Yodas na anak ni Yakob, aw si Yodas Iskariyot na yan yang magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ansinyan yotobang si Isa upud sang mga sahabat nan adto sang patag. Madaig yang mga inindowan ni Isa na yanagkatipon ansan aw madaig oman yang mga otaw na yagasikun sang Awrosalam aw sang kadaigan pa na mga banwa na sakop ng Yahodiya kipat oman sang mga banwa na sakop ng Tiros aw Sidon na masaid sang dagat. ");
INSERT INTO kqe_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kyomaon silan antak maningug sang pagindo ni Isa aw antak pakadyawon silan sang mga sakit nilan. Maskin yang mga otaw na kyakasaytanan pyapakadyaw nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aw yang kariko ng mga otaw disinyan yamaningkamot magkuput kang Isa kay aon kabarakat sikun kanan na yagapakadyaw sang kariko nilan. ");
INSERT INTO kqe_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ansinyan pyagatanawan ni Isa yang mga inindowan nan aw laong nan, “Kadyaw ng ginawa mayo kong yamatigam kamo na way amainang mayo kong di kamo atabangan ng Tohan, kay yamasakop da kamo sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kadyaw ng ginawa mayo kong mallini kamo mangagad sang karim ng Tohan, kay atabangan nan kamo paginang sang karim nan. Kadyaw ng ginawa mayo kong magatiyao kamo sabap sang kaatan adi sang donya, kay sang madatung na mga allaw amasowat da kamo. ");
INSERT INTO kqe_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kadyaw ng ginawa mayo kong odumtan kamo ng mga otaw aw ataripundaan kamo nilan, kong paginsoltoon kamo aw paglaongon kamo ng maat sabap sang pagpangagad mayo kanak na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Kay maynan oman yang ininang ng mga kaompowan nilan adto sang mga nabi sangaon. Agaw, pagkasowat kamo kong amainang da yan kamayo aw pagsayaw kamo sang kasowat kay magonawa sidtong mga nabi dakowa yang baras mayo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Awgaid labi na maat yang adatungan mayo kong yagadumdum kamo na di kinaanglan na atabangan kamo ng Tohan, kay yamadawat da mayo yang pyapaningkamotan mayo. ");
INSERT INTO kqe_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Labi na maat yang adatungan mayo kong yang ginawa gaid mayo yang kyakaridowan mayo, kay madatung yang allaw na apabayaan da kamo ng Tohan. Labi na maat yang adatungan mayo kong di kamo akasakitan sabap sang kaatan adi sang donya, kay madatung yang allaw na amarido da kamo aw magatiyao. ");
INSERT INTO kqe_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Labi na maat yang adatungan mayo kong abay kamo bantogon ng mga otaw, kay maynan oman yang ininang ng mga kaompowan nilan adto sang mga nabi na dili ng bunna.” ");
INSERT INTO kqe_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yagalaong oman si Isa, “Awgaid kamo na yamaningug kanak, yani yang pagalaong ko kamayo, kaloyi yang kalaban mayo aw paginangan mayo ng madyaw idtong yagadumut kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pagpangayowi mayo ng kadyawan yang yamaminta kamayo aw pagdowaai idtong yagapasakit kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kong aon magasampal sang sangkilid na pisngi mo, pasampalan oman kanan yang sangkilid. Kong aon makamang sang kanmo dagmay, pakamangan oman kanan yang kanmo dagom. ");
INSERT INTO kqe_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pangatagi yang sino-sino na amangayo kanmo. Aw kong aon makamang sang kanmo butang, ayaw da pagbawia. ");
INSERT INTO kqe_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na, paginang kamo adto sang kapagonawa mayo daw ono yang karim mayo na inangun nilan kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kong kaloyan mayo yang yamalooy oman kamayo, ono yang baras mayo? Kay maskin yang mga baradosa na wa osobay sang sogowan ng Tohan yagainang ng mayninyan. ");
INSERT INTO kqe_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kong pakitaan mayo ng madyaw yang madyaw oman kamayo, ono yang baras mayo? Maskin yang mga baradosa yagainang ng mayninyan. ");
INSERT INTO kqe_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kong magapahiram kamo sidtong amakabayad kamayo, ono yang baras mayo? Maskin yang mga baradosa yagapahiram sang kapagonawa nilan na baradosa kong kyakatigaman nilan na makabayad silan. ");
INSERT INTO kqe_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Awgaid yang madyaw na inangun mayo na akaloyan mayo yang kalaban mayo aw paginangan mayo silan ng madyaw. Pagpahiram kamo aw ayaw da kamo magtagad na abayadan pa kamo. Kong maynan yang inangun mayo, dakowa yang baras mayo aw akatigaman da na mga anak kamo ng Labi na Makagwas. Kay yang Tohan madyaw maskin sang mga otaw na maat aw di matigam manginsokor. ");
INSERT INTO kqe_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na, dait na maloyanun kamo magonawa sang Tohan na Ama mayo na maloyanun. ");
INSERT INTO kqe_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ayaw kamo maghokom sang kadaigan antak di oman kamo hokoman ng Tohan. Ayaw kamo maglaong na dait silan siksaun ng Tohan antak di oman kamo isiksaun ng Tohan. Ampona mayo yang yamakadosa kamayo antak amponon oman kamo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pangatag kamo kay atagan oman kamo ng Tohan. Sang way dowa-dowa, dakowa yang atag nan kamayo na maynang dyadasuk aw yamanlapya pa. Kay daw ono yang kadakowa ng atag mayo sang kadaigan, maynan oman yang atag kamayo ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ansinyan pyagalaong silan ni Isa sini na pasombingay, laong nan, “Makaabay ba yang bota sang sambok oman na bota? Dili! Kay kong inangun nan, dowa da silan na amallog sang longag. ");
INSERT INTO kqe_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Way inindowan na labaw pa sang goro nan, awgaid kong yamatapos da nan yang pagpangadi nan, na, magonawa da yan sang goro nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nanga sa kono kikita mo yang bagaso sang mata ng lomon mo, awgaid yang kaoy na iyan sang kanmo mata pyapasagdan da mo? ");
INSERT INTO kqe_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nanga sa makapaglaong kaw sang kanmo lomon, ‘Tabiya, kay lomon, akamangun ko nay yang bagaso sang mata mo,’ sarta wa mo ikitaa yang kaoy sang kanmo mata? Ikaw na yagapakita-kita gaid, kamanga nay ona yang kaoy sang kanmo mata antak kaw makakita ng madyaw sang pagkamang ng bagaso sang mata ng lomon mo. ");
INSERT INTO kqe_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yang madyaw na kaoy di mobonga ng maat, aw yang kaoy na dili ng madyaw di oman mobonga ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Agaw, yang matag-isa na kaoy akatigaman sabap sang bonga nan. Kay di makaipo ng igira sikun sang sampinit, aw di oman makaipo ng grips sikun sang bowa. ");
INSERT INTO kqe_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Magonawa sinyan, yang madyaw na otaw madyaw yang pyaglaongan nan kay madyaw yang lasak ng pangatayan nan. Awgaid yang maat na otaw, maat yang pyaglaongan nan kay maat yang lasak ng pangatayan nan. Kay yang maskin ono na adto sa suud ng pangatayan ng otaw, idto oman yang pagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nanga sa pagtawagun mayo ako na ‘Dato,’ awgaid di mayo apangagadan yang pyaglaongan ko? ");
INSERT INTO kqe_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na, apakita ko kamayo daw sino yang otaw na modood kanak aw amaningug sang pyaglaongan ko aw apangagadan nan. ");
INSERT INTO kqe_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Magonawa yan ng otaw na yagainang ng baay. Yagakotkot yan ng maum aw painduga nan yang baay sang bato. Na, maskin yagabaa aw yasogat da yan na baay ng tobig, wa yan akatangkug kay madyaw yang pyagapaindugan sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Awgaid sino-sino yang amaningug sang pyaglaongan ko awgaid di nan apangagadan, magonawa yan ng otaw na yagainang ng baay na way pondasyon. Pagdatung ng baa aw yasogat da yan na baay ng tobig, yamatowad yan aw yamadanas.” ");
INSERT INTO kqe_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapos ni Isa magindo ng kariko sinyan adto sang mga otaw, kyomadto yan sang longsod ng Kapirnaom. ");
INSERT INTO kqe_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Disidto aon kapitan ng mga sondao na taga Roma na yang sogowanun nan yamasakit aw yagairap da. Dakowa sang pangatayan ng kapitan idtong sogowanun nan. ");
INSERT INTO kqe_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Agaw, pagdungug ng kapitan ng makapantag kang Isa, syosogo nan yang pilangka otaw na mga pangoo ng mga Yahodi sang pagkamang kang Isa antak pakadyawon nan yang kanan sogowanun. ");
INSERT INTO kqe_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Adon, pagdatung ng mga pangoo adto kang Isa, yagapakilooy sagaw silan kanan aw laong nilan, “Yani na otaw dait gaid na atabangan mo. ");
INSERT INTO kqe_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kay yamalugun yan kanatun na mga Yahodi aw yagapatokod yan ng pagsasambayangan para kanatun.” ");
INSERT INTO kqe_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Agaw yamagad kanilan si Isa. Awgaid nang masaid da si Isa sang baay ng kapitan, syosogo ng kapitan yang mga kaupdanan nan sang pagsongon kang Isa kay antak paglaongon nilan, laong nan, “Ampon tabiya kanmo, kay Sir, ayaw da gaid magpanaos kay way kapatot ko pagtarima kanmo sang kanak baay. ");
INSERT INTO kqe_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aw di oman ako dait mapagatobang kanmo kay labaw kaw kanak. Paglaong gaid aw amadyaw da yang sogowanun ko. ");
INSERT INTO kqe_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kyakatigaman ko yani kay ako yagapasakop sang labaw pa kanak aw aon oman mga sondao na yagapasakop kanak. Kong sogoon ko yang isa, ‘Adto kaw,’ makadto yan. Kong sogoon ko yang isa, ‘Adi kaw,’ makani yan. Aw kong sogoon ko yang kanak sogowanun, ‘Inanga yani,’ na, inangun da nan.” ");
INSERT INTO kqe_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagdungug sinyan ni Isa, yamatingaa yan. Yagaatobang yan sang mga otaw na yamagad kanan aw yagalaong yan, “Pagalaong ko kamayo na waa pay kikita ko na otaw na bangsa Israil na maynini kadakowa ng pagpangintoo nan.” ");
INSERT INTO kqe_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ansinyan yomori yang mga syosogo ng kapitan aw pagdatung nilan sang baay, kikita nilan na madyaw da yang sogowanun. ");
INSERT INTO kqe_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wa akadogay disinyan kyomadto si Isa sang longsod na pyagangaanan ng Nain upud sang mga inindowan nan. Madaig oman yang mga otaw na yamagad kanan. ");
INSERT INTO kqe_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sang masaid da silan sang pasuudan sidto na longsod, aon mga otaw na yologwa sikun sinyan na yanaglanting ng patay. Yang idto na patay sasambokay na anak na usug ng biyoda. Madaig yang mga otaw na yamagad kanan sang paglubung. ");
INSERT INTO kqe_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkita ni Isa sidtong biyoda, yamatangkug yang kanan pangatayan aw laong nan kanan, “Ayaw da magtiyao.” ");
INSERT INTO kqe_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ansinyan dyomood si Isa aw kyukuputan nan yang tanggongan. Agaw yomondang yang mga otaw na yanaglanting sinyan. Laong ni Isa sang patay, “Kay Itin, bangon da!” ");
INSERT INTO kqe_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na, yagabangon da yang patay aw yagatiyab kay yamabowi da oman yan. Ansinyan yori da yan ni Isa adto sang ina nan. ");
INSERT INTO kqe_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na, yamangkalluk da yang kariko ng mga otaw disinyan. Pyopoji nilan yang Tohan aw laong nilan, “Kyakadumduman ng Tohan yang mga otaw na sakop nan kay pyapakani nan kanatun yang sambok na nabi na mabarakat!” ");
INSERT INTO kqe_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ansinyan yamakarimpud yang gogodanun makapantag sini na inang ni Isa sang tibok probinsya ng Yahodiya kipat sang makilibot na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ansinyan pyagalaong si Yahiya ng kanan mga inindowan makapantag sang kariko ng ininang ni Isa. Agaw tyatawag nan yang dowangka otaw na inindowan nan ");
INSERT INTO kqe_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aw sogowa nan silan adto kang Isa antak magosip kanan daw yan agaw yang pyapasad ng Tohan na madatung atawa aon pay tuna na atagadan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na, pagdatung nilan kang Isa, yagalaong silan, “Syosogo kami ni Yahiya na Magsosogboway sang pagosip kanmo daw ikaw ba yang pyapasad ng Tohan na madatung atawa aon pay tuna na atagadan nami.” ");
INSERT INTO kqe_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, sidto na wakto nang dyomatung idtong dowangka otaw, madaig yang mga masakitun na pyapakadyaw ni Isa aw pyapalogwa nan yang mga saytan sikun sang mga otaw na kyakasaytanan, aw madaig yang mga bota na pyapakadyaw nan aw yakakita da oman silan. ");
INSERT INTO kqe_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ansinyan tyomobag si Isa sang mga inindowan ni Yahiya, “Barik da kamo adto kang Yahiya aw paglaonga mayo daw ono yang kikita aw dyudungug mayo. Paglaonga mayo yan na yang mga bota yakakita da, yang mga sadi yakapanaw da, yang mga sanglaun yamadyaw da. Yang mga bungul yakadungug da, yang mga patay yamabowi da oman aw yang Madyaw na Gogodanun yamapayapat da adto sang mga miskinan. ");
INSERT INTO kqe_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kadyaw ng ginawa sidtong otaw na wa magadowa-dowa kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagpanaw ng mga inindowan ni Yahiya, yagalaong si Isa adto sang kamangaotawan makapantag kang Yahiya, laong nan, “Pagkadto mayo sang kamingawan, ono yang kallini mayo kitaun? Sambok na otaw na yagaisab-isab yang dumduman na maynang tambiling na pyagaparid-parid ng samut? ");
INSERT INTO kqe_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na, ono kadi yang kyakadtowan mayo? Sambok na otaw na madyaway yang dagom? Dili kowaw, kay yang mga otaw na mayninyan yang dagom aw madyaw yang kabutang adto magauya sang palasyo ng soltan. ");
INSERT INTO kqe_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Anda, ono sagaw yang kyakadtowan mayo? Sambok na nabi? Bunna sagaw na nabi si Yahiya, awgaid labaw pa yan sang kadaigan pa na mga nabi. ");
INSERT INTO kqe_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kay si Yahiya yang pyagalaong sang Kitab nang yagalaong yang Tohan, “ ‘Apaonaun ko kanmo yang sogowanun ko antak andamun nan yang agianan mo.’ ");
INSERT INTO kqe_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pagalaong ko kamayo na sang kariko ng mga yamangkaotaw adi sang babawan ng donya way makalabaw kang Yahiya. Awgaid adon, maskin yang pinakababa na otaw na magapasakop sang pagdato ng Tohan, labaw pa kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, yang kariko ng mga otaw na yamaningug kang Isa aw maskin yang mga mangobraay ng bowis, yamangimunna silan na matorid yang pamaagi ng Tohan. Yan silan yang yagapasogbo kang Yahiya. ");
INSERT INTO kqe_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Awgaid yang mga Parisi kipat sang mga alim ng Hokoman, tyataripundaan nilan yang kahanda kanilan ng Tohan. Agaw wa silan magapasogbo kang Yahiya. ");
INSERT INTO kqe_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Laong da oman ni Isa, “Ono yang akaparias ko sang mga otaw adon na panahon? ");
INSERT INTO kqe_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Magonawa silan sang mga isu na yanagingkod adto sang plaza aw yanaglaro silan. Yagalaong da yang kadaigan adto sang mga kaupdanan nilan, “ ‘Pyagatogtogan kamo nami ng kolintang, awgaid wa kamo magasayaw. Pyagakantaan kamo nami ng kanta ng paglubung, awgaid wa kamo magatiyao.’ ");
INSERT INTO kqe_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Na, magonawa da kamo kanilan. Kay pagdatung ni Yahiya na Magsosogboway, yabay yan magpowasa aw wa yan magainum ng bino. Agaw yagalaong kamo na ‘Kyakasaytanan kowaw yani na otaw!’ ");
INSERT INTO kqe_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aw pagdatung ko na Anak ng Manosiya, yakan aw iminum ako. Agaw yagalaong kamo, ‘Tanawa mayo, tokgawan aw paralasing yani na otaw. Inagad yan ng mga mangobraay ng bowis aw yang kadaigan pa na mga baradosa!’ ");
INSERT INTO kqe_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Awgaid maskin maynan,” laong ni Isa, “yang bonga ng gawbuk nami ni Yahiya, idto yang tanda na syosogo kami ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Adon, sangallaw disinyan pyagaimbitar si Isa ng sambok na Parisi na pyagangaanan ni Simon antak koman adto sang baay nan. Agaw yamagad si Isa kanan. ");
INSERT INTO kqe_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, sidto na longsod aon bobay na tyatawag na baradosa kay yagakadopang yan. Pagdungug nan na si Isa yakan adto sang baay ng Parisi, kyomadto yan sidto na baay na yagadaa ng tagbi na lasakanan na yamapono ng paballo. ");
INSERT INTO kqe_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pagdatung nan sang baay, imindug yan sang loyo ni Isa apit sang siki nan na yagatiyao taman sang yamabasa da yang siki ni Isa ng lowa nan. Ansinyan tyatrapowan da nan yang siki ni Isa ng kanan logay aw yaukan nan. Pagkatapos, yobowan nan ng paballo. ");
INSERT INTO kqe_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkita sinyan ng Parisi, yagalaong yan sa suud ng ginawa nan, “Aw yani na otaw bunna na nabi, kyakatigaman gao nan daw sino yani na bobay na yagadamdam kanan kay yan baradosa.” ");
INSERT INTO kqe_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ansinyan yagalaong si Isa kanan, “Kay Simon, aon pagalaong ko kanmo.” “Ud, kay Goro, paglaong da sa.” ");
INSERT INTO kqe_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na, laong ni Isa, “Aon dowangka otaw na yamakaotang ng sapi sang tigpaotang. Yang sambok yamakaotang ng 500, aw yang sambok ng 50. ");
INSERT INTO kqe_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Adon, kay wa silan makabayad sang otang nilan, wa da gaid silan apabayada nidtong tigpaotang. Na, sino kanilan dowa yang dakowa yang lugun sidtong yagapaotang kanilan?” ");
INSERT INTO kqe_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tyomobag si Simon, “Aw kanak gaid, idtong dakowa yang otang nan.” Laong ni Isa, “Bunna yang tobag mo.” ");
INSERT INTO kqe_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ansinyan ilingi si Isa sidtong bobay aw yagalaong yan kang Simon, “Kikita mo yang ininang sini na bobay? Pagdatung ko sang kanmo baay, wa mo ako atagi ng tobig na pagaogas sang kanak siki. Awgaid yaning bobay, yogasan nan yang kanak siki ng kanan lowa aw trapowi nan ng kanan logay. ");
INSERT INTO kqe_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wa mo ako auki sang pagsalam kanak, awgaid yaning bobay, yabay nan aukan yang kanak siki disti pa sang pagdatung ko. ");
INSERT INTO kqe_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wa mo oman ako atagi ng lana para sang kanak oo, awgaid yaning bobay, yobowan nan ng paballo yang kanak siki. ");
INSERT INTO kqe_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Agaw pagalaong ko kanmo na yang dakowa na lugun na pyapakita nan kanak yagapakatigam na yampon da yan sang kanan dakowa na dosa. Awgaid idtong otaw na tagbi gaid yang yampon kanan, tagbi oman yang pyapakita nan na lugun.” ");
INSERT INTO kqe_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ansinyan yagalaong si Isa sidtong bobay, “Yampon da kaw sang kanmo dosa.” ");
INSERT INTO kqe_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Adon, pagdungug sinyan ng kadaigan na mga otaw na yanagupud kanan koman, yagalaong silan sang ginawa nilan, “Sino kadi yani na otaw na makaampon sang dosa?” ");
INSERT INTO kqe_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na, yagalaong da oman si Isa sang bobay, “Yamalowas da kaw sabap sang pagpangintoo mo. Panaw da na aon kalinaw.” ");
INSERT INTO kqe_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wa akadogay disinyan yamakarimpud si Isa komadto sang kariko ng mga longsod aw baryo na yagapayapat ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan. Yamagad kanan yang sampoo aw dowa na mga sahabat nan ");
INSERT INTO kqe_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kipat oman sang kadaigan ng mga kaobayan na pyapakadyaw nan sikun sang kanilan mga sakit aw pyapangamangan nan ng mga saytan. Yang isa kanilan si Mariyam na taga Magdala na kyakamangan sangaon ni Isa ng pitombok na saytan. ");
INSERT INTO kqe_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yang isa oman si Yowana na asawa ni Kosa na kyakasarigan sang baay ni Hirod. Yamagad oman si Sosana aw yang madaig pa na mga kaobayan. Sikun sang kakawasaan nilan tyatabangan nilan si Isa aw yang mga inindowan nan sang mga panginaanglan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ansinyan yabay pa domatung yang mga otaw sikun sang yagakatuna-tuna na mga banwa aw yanagkatipon silan adto kang Isa. Sinyang madaigay da silan, yagaindo si Isa kanilan pinaagi sang pasombingay. ");
INSERT INTO kqe_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Laong nan, “Aon otaw na kyomadto sang pawa antak magsabod ng bini. Sang pagsabod nan, aon mga bini na yamallog adto sang daan. Ansinyan kyakaginaan inyan ng mga otaw aw tyotobog ng mga langgam. ");
INSERT INTO kqe_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yang kadaigan ng bini yamallog adto sang batoon na lopa. Pagtobo pa gaid, yamalanus dayon kay magdang yang lopa. ");
INSERT INTO kqe_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yang kadaigan oman yamallog adto sang lopa na madaig yang sampinit. Na, yagadungan tomorin yang sampinit aw yang mga tanum, aw wa akadogay kyakatabonan sinyan yang mga tanum. ");
INSERT INTO kqe_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Awgaid yang kadaigan ng bini yamallog adto sang madyaw na lopa. Ansinyan tyomorin yang mga tanum aw yobonga ng labi na madaig.” Sang orian yagalaong si Isa, “Kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ansinyan yosip si Isa ng mga inindowan nan daw ono yang mana sidto na pasombingay. ");
INSERT INTO kqe_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tyomobag si Isa, “Kamo, yatagan kamo ng katigam antak makasabot kamo sang mga tinago makapantag sang pagdato ng Tohan. Awgaid adto sang kadaigan mga pasombingay yang gyagamit ko kay antak “ ‘maskin yagatanaw silan, di silan makakita. Aw maskin yamaningug silan, di silan makasabot.’ ");
INSERT INTO kqe_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na, yani kay yang mana sidto na pasombingay. Yang bini, idto yang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yang kilid ng daan na kyakaoogan ng bini, idto yang mga otaw na yamakadungug sang pyaglaongan ng Tohan. Awgaid dyomatung si Iblis aw kamanga nan yang pyaglaongan na dyudungug nilan sikun sang pangatayan nilan antak di silan mangintoo aw di oman silan amalowas. ");
INSERT INTO kqe_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yang batoon na lopa, idto yang mga yamakadungug sang pyaglaongan ng Tohan aw tyatarima dayon nilan na aon kasowat. Awgaid sabap ng wa makagamot yang pyaglaongan ansang pangatayan nilan, mallug da gaid yang pagpangintoo nilan. Kay kong adatungan silan ng mga satsat, mibiya dayon silan sang pagpangintoo. ");
INSERT INTO kqe_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yang lopa oman na madaig yang sampinit, idto yang mga yamakadungug sang pyaglaongan ng Tohan, awgaid sabap sang karidowan nilan adi sang babawan ng donya aw sabap oman sang kakawasaan aw yang kadaigan pa na kyakallinian nilan, kyakatabonan da inyan. Idto sagaw, wa obonga yang pagpangintoo nilan. ");
INSERT INTO kqe_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yang madyaw na lopa, idto yang mga yamakadungug sang pyaglaongan ng Tohan aw tyatarima nilan inyan sa suud ng pangatayan nilan aw pyapangagadan nilan na aon pagsabar. Yani silan yang yobonga ng madyaw.” ");
INSERT INTO kqe_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan aw butangan nan sang saad ng katri atawa asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan kay antak makita yang siga sinyan pagsuud ng mga otaw sang baay. ");
INSERT INTO kqe_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kay yang maskin ono na yamatago, amaklaro sang orian, aw yang wa pa akatigami adon, akatigaman da. ");
INSERT INTO kqe_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Agaw paningug kamo ng madyaw. Kay sino-sino yang amaningug ng madyaw, odogangan pa yang katigam nan. Awgaid sino-sino yang di amaningug ng madyaw, maskin yang tagbis na kyakatigaman nan, akamangun pa kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ansinyan dyomatung yang ina ni Isa aw yang mga mangkangod nan na usug. Awgaid wa silan makadood kang Isa sabap sang kadaig ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ansinyan aon sambok na otaw na yagalaong kang Isa, “Yang ina mo aw yang mga lomon mo adto sa logwa. Mapagkita gao silan kanmo.” ");
INSERT INTO kqe_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Awgaid tyomobag si Isa aw laong nan kanilan, “Sino-sino yang amaningug aw amangagad sang pyaglaongan ng Tohan, silan yang ina ko aw yang mga lomon ko.” ");
INSERT INTO kqe_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sangallaw disinyan yagalaong si Isa sang mga inindowan nan, “Abay da kamo, mataripag da kita sang linaw.” Ansinyan syomakay silan sang bangka aw larga da silan. ");
INSERT INTO kqe_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sang yagalayag da silan, yamakatoog si Isa. Tyomokaw moyop yang makusug na samut aw kyakalasakan da ng tobig yang bangka nilan na masaid da silan malonod. ");
INSERT INTO kqe_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na, yodoodan ng mga inindowan si Isa aw pokawa nilan. Laong nilan, “Kay Dato! Kay Dato! Amatay da kita!” Ansinyan yagabangon si Isa aw syasagda nan yang samut aw yang mangkadakowa na mga baud. Na, yomondang dayon yang samut aw yamalinaw da. ");
INSERT INTO kqe_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ansinyan yagalaong si Isa sang mga inindowan nan, “Wain kadi yang pagpangintoo mayo?” Awgaid yamangkalluk da silan na yamangkatingaa aw yanaginosipay silan, laong nilan, “Sino kadi yani na otaw na maskin yang samut aw yang mga baud motoman kanan?” ");
INSERT INTO kqe_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ansinyan yagapadayon silan lomayag sampay na dyomatung silan sang logar ng mga taga Girasa na adto sang dipag ng Linaw ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagkawas ni Isa sang bangka, syosongon yan ng sangka otaw sikun sinyan na longsod na kyakasaytanan. Yadogay da na yani na otaw wa apandagom aw wa magauya sang baay. Awgaid adto da yan magauya sang mga langob na pakoboran. ");
INSERT INTO kqe_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pagkita nan kang Isa yamangiyak yan, syomojod sang atobangan ni Isa aw laong nan ng matanog, “Kay Isa, Anak ng Tohan na Labi na Makagwas, ono yang labot mo kanak? Pangayoon ko kanmo na di mo ako isiksaun!” ");
INSERT INTO kqe_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yagalaong yan ng mayninyan kay syosogo da ni Isa yang saytan na apanawan nan inyan na otaw. Kay yabay yani na otaw kalasakan ng saytan, aw maskin gyagapos yang arima aw siki nan ng kadina aw byabantayan yan ng mga otaw, pyapamogto gaid nan yang mga kadina aw dyadaa da oman yan ng saytan adto sang mamingaw na mga banwa. ");
INSERT INTO kqe_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ansinyan yagaosip si Isa kanan, “Sino yang ngaan mo?” “Ako si Panon,” yang tobag nan kay madaig yang mga saytan na yamakalasak kanan. ");
INSERT INTO kqe_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ansinyan yagapakilooy yang mga saytan kang Isa na di nan silan pakadtoon sang maum na longag na adto silan siksaun. ");
INSERT INTO kqe_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Adon, madaig yang mga binatang na yanagdowang ansang kilid ng butay. Agaw yagapakilooy yang mga saytan kang Isa na adto da silan alasak sidtong mga binatang. Aw yosogot oman si Isa. ");
INSERT INTO kqe_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na, lyomogwa da silan sikun sinyan na otaw aw lasak silan sang mga binatang. Aw yang tibok panon dyomaagan adto sang pangpang. Yamangkallog silan sang linaw aw yamangkalumus. ");
INSERT INTO kqe_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkita sinyan ng mga magbabantayay ng mga binatang, dyomaagan silan adto sang longsod aw sang mga baryo kay ogogod nilan sang mga otaw idtong kyakatamanan. ");
INSERT INTO kqe_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Agaw yagasingadto da yang mga otaw kay atanawon nilan daw ono yang yamaitabo. Pagdatung nilan adto kang Isa, kikita nilan idtong otaw na pyapanawan ng mga saytan. Yagaingkod da yan sang atobangan ni Isa na yamandagom aw yomori da yang madyaw na dumduman nan. Na, yamangkalluk da silan. ");
INSERT INTO kqe_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Adon, yangaong yakakita sang kyakatamanan yagagogod sinyan na mga otaw daw monono yang pagpakadyaw sidtong otaw na pyapanawan da ng mga saytan. ");
INSERT INTO kqe_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ansinyan yang kariko ng mga otaw na yanaguya sang sakop ng Girasa, yangyo nilan si Isa na apanawan da nan yang banwa nilan kay bali na kalluk nilan. Agaw syomakay da si Isa sang bangka aw larga da silan. ");
INSERT INTO kqe_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Adon, idtong otaw na pyapanawan ng mga saytan, yagapakilooy yan kang Isa na paagadun nan. Awgaid pyapaori yan ni Isa na laong nan, ");
INSERT INTO kqe_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ori da adto kamayo aw paggogod kanilan daw ono yang ininang ng Tohan kanmo.” Agaw pyomanaw da idtong otaw aw yagagogod yan sang tibok longsod daw ono yang ininang kanan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagbarik da oman ni Isa adto sang dipag ng linaw, yamasowat yang mga otaw pagdawat kanan kay silan kariko yabay tomagad kanan. ");
INSERT INTO kqe_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ansinyan dyomatung yang sangka otaw na pyagangaanan ni Yairos na pangoo ng pagsasambayangan ng mga Yahodi disinyan na banwa. Syomojod yan sang atobangan ni Isa aw yagapakilooy yan na amagad kanan si Isa adto sang kanan baay. ");
INSERT INTO kqe_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kay yang sasambokay nan na anak na bobay na sampoo aw dowangka toig yang idad, yagapinal da. Ansinyan yamagad kanan si Isa. Sang yagapasingadto si Isa, dyudutdut yan ng kamangaotawan na yamagad kanan. ");
INSERT INTO kqe_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ansang tunga ng kamangaotawan aon sambok na bobay na yabay agasan ng dogo sa suud ng sampoo aw dowangka toig. Yaobos da yang kanan kakawasa sang pagpatambal sang mga mananambalay, awgaid way yakapagkadyaw kanan. ");
INSERT INTO kqe_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ansinyan dyomood yan kang Isa ansang likod nan aw kuputi nan yang sagyadan ng dagom nan. Na, yomondang dayon yang pagagas ng dogo nan. ");
INSERT INTO kqe_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ansinyan yagaosip si Isa, “Sino yang yagakuput kanak?” Awgaid way maskin isa na yamangkun, agaw yagalaong si Pitros, “Kay Dato, yanagtinooday yang mga otaw aw dyudutdut kaw nilan!” ");
INSERT INTO kqe_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Awgaid yagalaong si Isa, “Aon yagakuput kanak kay byabati ko na aon kabarakat na lyomogwa sikun kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Adon, pagkita ng bobay na di da amatago yang ininang nan, dyomood yan kang Isa na tyatakigan aw syomojod sang atobangan nan. Ansinyan sang atobangan ng kariko ng mga otaw yagalaong yan daw nanga sa kyukuputan nan si Isa aw monono na yamadyaw da yan. ");
INSERT INTO kqe_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yagalaong si Isa kanan, “Kay Bodi, sabap sang pagpangintoo mo yamadyaw da kaw. Panaw da na aon kalinaw.” ");
INSERT INTO kqe_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sang yagatiyab pa si Isa, aon otaw na dyomatung sikun sang baay ni Yairos. Laong nan kang Yairos, “Yamatay da yang anak mo. Ayaw da pagdistorbowa yang goro.” ");
INSERT INTO kqe_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Awgaid yamakadungug sinyan si Isa aw yagalaong yan kang Yairos, “Ayaw magkalluk. Pagpangintoo gaid aw amadyaw yang anak mo.” ");
INSERT INTO kqe_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na, pagdatung nilan adto sang baay, wa otogoti ni Isa yang maskin sino na amagad kanan pagsuud yatabiya kang Pitros, si Yahiya aw si Yakob aw yang ama aw ina ng isu. ");
INSERT INTO kqe_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na, yang kariko ng mga otaw ansan yanagtiyao aw yanagminatay. Awgaid yagalaong si Isa kanilan, “Ayaw da kamo magtiyao kay dili ng patay yang isu, yamatoog gaid yan.” ");
INSERT INTO kqe_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ansinyan inikuan nilan si Isa kay kyakatigaman nilan na yamatay da yang isu. ");
INSERT INTO kqe_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Awgaid si Isa, kyukuputan nan yang arima ng isu aw paglaonga nan, “Kay Bodi, bangon da!” ");
INSERT INTO kqe_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na, ansinyan byomarik yang napas nan aw yagabangon dayon yan. Aw yagasogo si Isa na apakanun nilan yang isu. ");
INSERT INTO kqe_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yamangkatingaa sagaw yang mga taganak ng isu. Awgaid syasagda silan ni Isa na di silan maggogod sang maskin sino daw ono yang yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ansinyan tyatawag ni Isa yang sampoo aw dowa na mga sahabat nan na magtipon adto kanan aw yatagan nan silan ng kabarakat aw kapatot pagpalogwa sang kariko ng mga saytan aw pagpakadyaw sang mga sakit. ");
INSERT INTO kqe_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Syosogo nan silan pagpayapat makapantag sang pagdato ng Tohan aw pagpakadyaw sang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yagalaong yan kanilan, “Sang pagpanaw mayo, ayaw kamo magdaa ng maskin ono. Ayaw kamo magdaa ng bangka, maskin ono na lasakanan, ni pagkan atawa sapi. Ayaw oman magdaa ng ilisan mayo. ");
INSERT INTO kqe_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maskin wain na baay yang adatungan mayo, ansan da kamo maguya taman sang pagpanaw mayo sinyan na banwa. ");
INSERT INTO kqe_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kong aon banwa na akadtowan mayo aw yang mga otaw ansan di magatarima kamayo, panawi mayo yan na banwa. Aw bago kamo pomanaw takdagan mayo yang abog sang siki mayo silbi tanda kanilan na waa day labot mayo kanilan.” ");
INSERT INTO kqe_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ansinyan pyomanaw da yang mga sahabat aw kyomadto silan sang kariko ng mga banwa. Yanagpayapat silan ng Madyaw na Gogodanun aw pyapakadyaw nilan yang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, pagdungug ni Hirod na soltan sang Jalil ng makapantag sang kariko ng ininang ni Isa, yamatingaa yan kay aon mga otaw na yagalaong na si Isa kono si Yahiya na yamabowi oman. ");
INSERT INTO kqe_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aon oman kadaigan na yagalaong na yan kono si Nabi Iliyas na yagapakita oman atawa yang sambok na nabi sangaon na yamabowi oman. ");
INSERT INTO kqe_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Awgaid yagalaong si Hirod, “Pyapaotodan da ko si Yahiya ng kanan oo. Na, sino adon yani na otaw na madaig yang katingaan na dyudungug ko makapantag kanan?” Agaw, karim da gao nan kimita kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ansinyan pagbarik ng mga sahabat ni Isa sikun sang pagpayapat, yanaggogod silan kang Isa daw ono yang ininang nilan. Ansinyan pyagaagad nan silan aw kyomadto silan sang longsod ng Bitsayda na silan da gaid. ");
INSERT INTO kqe_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Awgaid pagkatigam sinyan ng mga otaw, yolopog silan kang Isa. Pagdatung nilan, dyadawat silan ni Isa aw pyagaosiyatan nan silan makapantag sang pagdato ng Tohan aw pakadyawa nan yang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pagkakasilum disinyan dyomood kang Isa yang sampoo aw dowa na mga sahabat nan aw laong nilan kanan, “Madyaw pa aw pakadtoon da mo yang mga otaw sang makilibot na mga baryo aw sityo antak manganap silan ng pagkan kipat oman sang akakowangan nilan kay ansini kita sang mamingaw na banwa.” ");
INSERT INTO kqe_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Awgaid yagalaong si Isa kanilan, “Kamo da yang magpakan kanilan.” Tyomobag silan, “Aon gaid kanami limambok na pan aw dowamboos na isda. Mapanaw ba kami aw magabili ng pagkan sining kadaig ng mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kay yang kausgan gaid ansan mga 5,000. Awgaid yagalaong si Isa sang mga inindowan nan, “Paingkoda mayo yang mga otaw sang mga pondok ng tag-50.” ");
INSERT INTO kqe_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na, ininang da nilan yang pyagasogo kanilan ni Isa aw paingkoda nilan yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ansinyan kyakamang ni Isa yang limambok na pan aw yang dowamboos na isda, imingao sang langit aw panginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga inindowan nan antak ipangatag nilan adto sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ansinyan kyoman da yang kariko nilan aw yamangkabiyag silan. Pagtipon ng mga inindowan sang yamasama, sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sangallaw disinyan nang yagadowaa si Isa ng sayda nan, iyan sang masaid kanan yang mga inindowan nan. Ansinyan yagaosip si Isa kanilan, “Sobay sang mga otaw, sino kono ako?” ");
INSERT INTO kqe_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tyomobag silan, “Aon yagalaong na ikaw kono si Yahiya na Magsosogboway. Yang kadaigan yagalaong na ikaw kono si Nabi Iliyas, aw yang kadaigan oman yagalaong na ikaw kono yang sambok na nabi sangaon na yamabowi oman.” ");
INSERT INTO kqe_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Awgaid kamo,” laong ni Isa, “ono yang akapaglaong mayo daw sino ako?” Tyomobag si Pitros, “Ikaw yang Almasi na pyapasad ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Agaw yagalaong si Isa, “Ako na Anak ng Manosiya, dait na amagi ako ng mga kasikotan aw ataripundaan ako ng mga pangoo ng mga Yahodi, mga pangoo ng mga imam kipat oman sang mga magiindoway ng Hokoman. Apatayun ako nilan, awgaid sang ikatoong allaw amabowi oman ako.” Aw ansinyan syasagda silan ni Isa na di silan maggogod sang maskin sino ng makapantag kanan. ");
INSERT INTO kqe_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pagkatapos sinyan yagalaong si Isa sang kariko ng mga otaw, “Sino-sino yang marim mangagad kanak, dait na atarikodan nan yang kallini ng ginawa nan aw dait na andam yan sang mga kasikotan aw maskin sang pagkamatay sabap kanak. Kong maynan, makapangagad da yan kanak. ");
INSERT INTO kqe_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kay sino-sino na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyapalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, akaonan ng bunna na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kay ono yang amakamang ng otaw kong amangkun nan yang kariko ng kakawasaan adi sang donya, awgaid kong amatay da yan isiksaun da yan adto sang narka? Waa! ");
INSERT INTO kqe_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sino-sino yang yamasipug maglaong sang atobangan ng kadaigan na yamangagad yan kanak kipat sang indowan ko, akasipug ko oman yan sang wakto na mabarik ako na Anak ng Manosiya adi sang donya sang kanak kasiga, aw sang kasiga ng kanak Ama kipat sang sotti na mga malaikat. ");
INSERT INTO kqe_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Awgaid bunna yang pagalaong ko kamayo na aon mga otaw disini na di pa amatay taman sang amakita da nilan na magadato da yang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga sangka simana pagkatapos sidto na pyaglaongan ni Isa pyagaagad nan si Pitros, si Yahiya aw si Yakob aw tyomokod silan sang butay antak magdowaa. ");
INSERT INTO kqe_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aw sarta yagadowaa si Isa, yamaisab yang kanan parangay aw yagakapoti yang kanan dagom na magonawa ng allag na mabislaway. ");
INSERT INTO kqe_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sakadyap aon dowangka otaw na yapagbaaw kanan. Yani silan si Nabi Mosa aw si Nabi Iliyas. ");
INSERT INTO kqe_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yagasiga oman yang mga dagom nilan aw yapagbaaw silan kang Isa makapantag sang pagkamatay nan adto sang Awrosalam na masaid da matoman sobay sang kahanda ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Adon, si Pitros aw yang mga kaupdanan nan yamakatoog. Awgaid pagmata nilan, kikita nilan si Isa sang kasiga nan kipat oman sidtong dowangka otaw na yagaindug sang masaid kanan. ");
INSERT INTO kqe_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ansinyan nang masaid da mibiya kang Isa idtong dowangka otaw, yagalaong si Pitros kang Isa, “Kay Goro, madyaw na ani kami sini. Magainang da kami ng toombok na payag, sambok kanmo, sambok kang Nabi Mosa aw sambok oman kang Nabi Iliyas.” Maynan yang pyaglaongan nan kay wa yan akatigam daw ono yang dait nan paglaongon. ");
INSERT INTO kqe_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nang yagatiyab pa si Pitros, aon yamaon na gabon na yagalandong kanilan. Ansinyan yamalluk yang mga inindowan ni Isa kay kyakatabonan da silan sinyan na gabon. ");
INSERT INTO kqe_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aw aon yamadungug nilan na sowara sikun sang gabon na yagalaong, “Yani yang Anak ko na pipili ko. Paningug kamo kanan!” ");
INSERT INTO kqe_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkawaa da ng sowara, kikita nilan na si Isa dakman yang yamabilin. Na, sidto na mga allaw wa silan magagogod sang maskin sino daw ono yang kikita nilan. ");
INSERT INTO kqe_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagkailaw disinyan yotobang si Isa upud sang mga inindowan nan sikun sang butay. Na, madaig yang mga otaw na yosongon kanan. ");
INSERT INTO kqe_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aon sambok na otaw disidto na yagalaong ng matanog, “Kay Goro, kong mapakay kanmo, tabangi sa yaning anak ko kay sasambokay da yan. ");
INSERT INTO kqe_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Abay yan lasakan ng saytan. Kong amaitabo yan, motokaw yan mangiyak, magakorog-korog yang lawas nan aw magabowa pa yang baba nan. ");
INSERT INTO kqe_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yagapakilooy da ako sang mga inindowan mo na palogwaun nilan yang saytan, awgaid di nilan magaga.” ");
INSERT INTO kqe_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ansinyan yagalaong si Isa, “Astaga! Kamo na mga otaw adon na panahon, waa say pagpangintoo mayo aw sayup oman yang dumduman mayo. Kadogay da ako ani kamayo! Wain pa kotob yang pagsabar ko kamayo? Daa adi yang anak mo.” ");
INSERT INTO kqe_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sinyang yagapadood kanan yang isu, lyalasakan yan ng saytan aw katowad sang lopa na yagakorog. Ansinyan syasagda ni Isa yang saytan, pakadyawa nan yang isu aw orian sang ama nan. ");
INSERT INTO kqe_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na, yamangkatingaa da yang kariko ng mga otaw sang kabarakat ng Tohan. Sarta yamangkatingaa pa yang mga otaw sang kariko ng ininang ni Isa, yagalaong yan sang mga inindowan nan, ");
INSERT INTO kqe_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ayaw mayo pagkaringawi yaning pagalaong ko kamayo. Ako na Anak ng Manosiya, mallug da ako adaun adto sang mga otaw na aon kapatot.” ");
INSERT INTO kqe_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Awgaid wa silan makasabot sini na pyaglaongan ni Isa. Kay sidto na wakto yamatago pa yani kanilan antak di nilan masabot. Aw yamalluk silan magosip kanan. ");
INSERT INTO kqe_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ansinyan yanaglalis yang mga inindowan ni Isa daw sino kanilan yang labaw. ");
INSERT INTO kqe_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Awgaid kyakatigaman ni Isa daw ono yang iyan sang dumduman nilan. Agaw kyakamang nan yang tagbi na isu aw painduga nan ansang kilid nan. ");
INSERT INTO kqe_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ansinyan yagalaong yan kanilan, “Sino-sino yang magatarima sang isu na main sini sabap sang pagpangagad nan kanak, magatarima oman kanak. Aw sino-sino yang magatarima kanak, magatarima oman sang yagasogo kanak. Kay sino idtong pinakababa kamayo, yan yang labaw kamayo.” ");
INSERT INTO kqe_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ansinyan yagalaong si Yahiya, “Kay Goro, aon kikita nami na otaw na yagapalogwa sang mga saytan na lyalambit nan yang ngaan mo. Syasagda nami yan kay di yan inagad natun.” ");
INSERT INTO kqe_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ayaw mayo yan pagsagdaa,” laong ni Isa kanan kipat sang kadaigan pa na mga inindowan, “kay yang maskin sino na dili mapaglaban kamayo, matabang kamayo.” ");
INSERT INTO kqe_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ansinyan nang masaid da yang wakto na apataasun da si Isa adto sang sorga, yagahokom yan na makadto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Agaw yagasogo yan ng pilangka otaw na amaona kanan adto sang sambok na baryo na sakop ng Samariya antak andamun nilan yang logar na adatungan nan. ");
INSERT INTO kqe_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Awgaid yang mga otaw sidto na banwa wa magatarima kang Isa kay kyakatigaman nilan na misingadto yan sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkatigam sinyan ng mga inindowan nan na si Yahiya aw si Yakob, yagalaong silan kang Isa, “Kay Dato, karim mo na apaowanan nami silan ng atoon antak matay silan?” ");
INSERT INTO kqe_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Awgaid ilingi kanilan si Isa aw syasagda nan silan. ");
INSERT INTO kqe_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aw pyomanaos da gaid silan sang tuna na baryo. ");
INSERT INTO kqe_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sarta yagapanaw silan, aon otaw na yagalaong kang Isa, “Amagad ako kanmo maskin makain kaw kadto.” ");
INSERT INTO kqe_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yagalaong si Isa kanan, “Yang mga milo aon kanilan tagowanan aw yang mga langgam aon kanilan pogad, awgaid ako na Anak ng Manosiya, way kanak logar na akakowangan ko.” ");
INSERT INTO kqe_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ansinyan yagalaong si Isa sang sambok oman na otaw, “Abay da, agad kanak.” Awgaid laong ng otaw, “Kay Dato, omori pa nay ako kay ulubung pa ko yang kanak ama.” ");
INSERT INTO kqe_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tyomobag si Isa aw laong nan kanan, “Pabayai yang paglubung sang mga patay adto sang mga otaw na main oman ng patay kay wa silan apangintoo kanak. Awgaid ikaw, panaw da aw pagpayapat ng makapantag sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aon oman sangka otaw na yagalaong kanan, “Amagad ako kanmo, kay Dato. Awgaid togoti nay ako na omori kay magasabi pa ako sang mga taganak aw mga kalomonan ko.” ");
INSERT INTO kqe_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Awgaid yagalaong kanan si Isa, “Sino-sino yang magadaro awgaid abay pa limingi, dili ng madyaw yang gawbuk nan. Magonawa sinyan, sino-sino yang marim mangagad kanak, awgaid yang kanan dumduman adto sang kadaigan pa na mga butang, di yan dait magpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos sinyan yagapili si Isa ng 72 na mga inindowan antak sogoon nan silan pagpayapat adto sang mga longsod aw baryo na akadtowan pa nan. Syosogo nan silan ng tagdowa aw pyapaona nan silan kanan. ");
INSERT INTO kqe_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Laong nan kanilan, “Madaig yang mga otaw na marim gao makadungug sang Madyaw na Gogodanun. Magonawa silan ng omay na yailag da. Madaig sagaw yang ganiunun, awgaid tagbi da yang manggagani. Agaw pagpangayo-ayo kamo adto sang Tohan na tagtomon ng pawa na magapadaa yan ng kadaigan pa na manggagani. ");
INSERT INTO kqe_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, panaw da kamo. Awgaid pagbantay kamo kay syosogo ta kamo na main kamo ng mga karniro adto sang mga otaw na main ng maisug na mga ido. ");
INSERT INTO kqe_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaw da kamo magdaa ng pitaka atawa maskin ono na lasakanan ni sandalyas. Aw ayaw oman kamo magondang sang daan sang pagbaaw-baaw sang mga otaw na makita mayo. ");
INSERT INTO kqe_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kong makadto kamo sang sambok na baay, magalaong kamo nay ona, “Salam kamayo ansini na baay.” ");
INSERT INTO kqe_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na, kong aon otaw san na baay na dait atagan ng kalinaw, kanan da yang kalinaw na pyapangayo mayo. Awgaid kong dili, mabarik yang kalinaw adto kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kong aon madawat kamayo sang baay nilan, ansan da kamo maguya. Ayaw da kamo magballin-ballin ng baay. Kana aw inuma mayo yang maskin ono na yaya nilan kamayo kay yang maggawbukay dait bayadan sang gawbuk nan. ");
INSERT INTO kqe_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Na, maskin wain na longsod yang akadtowan mayo, kong adawatun kamo ng mga otaw ansan, kana mayo yang maskin ono na yaya nilan kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pakadyawa mayo yang mga masakitun san na longsod aw paglaonga mayo yang mga otaw, ‘Dyomatung da adi kamayo yang pagdato ng Tohan.’ ");
INSERT INTO kqe_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Awgaid kong makadto kamo sang sambok na longsod aw di kamo adawatun ansan, adto da kamo sang mga daan aw paglaonga mayo yang mga otaw, ");
INSERT INTO kqe_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Maskin yang abog sikun sang kamayo longsod na yodukut sang kanami siki atakdagun da nami silbi tanda kamayo na waa day labot nami kamayo! Awgaid timani mayo na dyomatung da gao adi kamayo yang pagdato ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na, laong ni Isa, “Pagalaong ko kamayo na pagdatung ng allaw ng paghokom, labaw pa yang siksa sidtong mga otaw kaysang siksa sang mga taga Sodom.” ");
INSERT INTO kqe_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Labi na maat yang adatungan mayo na taga Korasin! Labi na maat oman yang adatungan mayo na taga Bitsayda! Kay kong yamainang pa sang Tiros aw Sidon yang mga katingaan na ininang ko ansan kamayo, dogay da silan yanagsoot ng sako aw yanagingkod sang abo silbi tanda ng pagtawbat nilan. ");
INSERT INTO kqe_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Agaw, sang allaw ng paghokom labaw pa yang siksa kamayo kaysang siksa sang mga taga Tiros aw Sidon. ");
INSERT INTO kqe_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aw kamo oman na taga Kapirnaom, yagadumdum ba kamo na apataasun kamo adto sang sorga? Dili! Kay ioog kamo ng Tohan adto sang narka.” ");
INSERT INTO kqe_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ansinyan yagalaong si Isa sang mga inindowan nan, “Sino-sino yang amaningug kamayo, amaningug oman kanak. Aw sino-sino yang magataripunda kamayo, magataripunda oman kanak. Aw sino-sino yang magataripunda kanak, magataripunda oman sang yagasogo kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ansinyan byomarik da idtong 72 na syosogo ni Isa na yamangkasowat aw yagalaong silan kang Isa, “Kay Dato, maskin yang mga saytan yotoman kanami aw sogoon nami sang ngaan mo!” ");
INSERT INTO kqe_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tyomobag si Isa kanilan, “Kikita ko si Iblis na yamallog sikun sang langit na magonawa ng kilat. ");
INSERT INTO kqe_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Paningug kamo! Yatagan ta kamo ng kapatot kay antak maskin kaginaan mayo yang mga bila atawa mga olaipan, di kamo amaono. Aw di oman kamo amatalo ng kariko ng kabarakat ni Iblis na kalaban natun. Way maskin ono na amakasapad kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Awgaid ayaw kamo magkasowat kay yotoman yang mga saytan sang sogo mayo. Awgaid pagkasowat kamo kay yang ngaan mayo yamakasorat da adto sang sorga.” ");
INSERT INTO kqe_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sidto na wakto yamasowat si Isa sabap sang Nyawa ng Tohan aw yagalaong yan, “O kay Ama, ikaw yang yagadato adto sang sorga aw adi sang donya. Yamanginsokor ako kanmo kay yang pyagatago mo sang mga aon katigam aw mataas yang pagpangadi pyapakatigam mo adto sang mga way katigam. Ininang mo yani, kay Ama, kay idto yang karim mo.” ");
INSERT INTO kqe_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ansinyan yagalaong si Isa sang mga otaw, “Yang kariko ng mga butang yatag kanak ng kanak Ama. Way sino-sino na ikilaa sang Anak yatabiya yang Ama, aw way sino-sino na ikilaa sang Ama yatabiya yang Anak kipat sidtong mga otaw na pipili ng Anak na apakilaa yan kanilan.” ");
INSERT INTO kqe_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ansinyan yagaatobang si Isa sang mga inindowan nan aw yagalaong yan kanilan nang wa makadungug kanan yang kadaigan na mga otaw, laong nan, “Kadyaw ng ginawa mayo kay yakakita da kamo sang kariko sining ininang ko. ");
INSERT INTO kqe_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pagalaong ko kamayo na madaig yang mga nabi aw mga soltan sangaon na karim gao kimita sang kikita mayo, awgaid wa nilan ikitaa. Aw karim gao nilan dumungug sang dyudungug mayo, awgaid wa nilan odunguga.” ");
INSERT INTO kqe_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ansinyan aon sambok na alim ng Hokoman na yodood kang Isa antak magtigi kanan. Yagalaong yan, “Kay Goro, ono yang dait ko inangun antak kaonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqe_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tyomobag kanan si Isa, “Ono yang yamakasorat sang Hokoman ng Tohan? Ono yang yamabatya mo ansan?” ");
INSERT INTO kqe_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tyomobag yang otaw, “Yamakasorat sang Kitab, ‘Kaluguni yang Tohan na kanmo Tagallang sang tibok mo na pangatayan, sang tibok mo na kallowa, sang tibok mo na kusug, aw sang tibok mo na dumduman, aw kaluguni oman yang kapagonawa mo magonawa sang lugun mo sang ginawa mo.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Bunna yang pyagalaong mo,” laong ni Isa. “Inanga yan aw ansinyan akaonan kaw ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Awgaid yang alim, di nan karim na akasipugan yan. Agaw yosip oman nan si Isa, laong nan, “Sino kadi yang kapagonawa ko?” ");
INSERT INTO kqe_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tyomobag si Isa, “Aon sambok na otaw na Yahodi na yotobang sikun sang Awrosalam pasingadto sang Ariha. Ansang daan yatangan yan ng mga tolisan. Na, lyolobasan nilan yan, byobonalan aw pyapanawan na maynang patay da. ");
INSERT INTO kqe_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ansinyan aon imam ng mga Yahodi na yamagi sidto na daan. Awgaid pagkita nan sinyan na otaw, ilikay yan adto sang sangkilid na daan aw yamagi ansan. ");
INSERT INTO kqe_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ansinyan aon oman sambok na otaw na Yahodi na yamagi ansan. Yani na otaw topo ni Libi aw katabang ng mga imam adto sang Baay ng Tohan. Pagkita nan sidtong otaw, yamagi da oman yan adto sang sangkilid na daan. ");
INSERT INTO kqe_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Awgaid wa akadogay disinyan aon sambok na otaw na taga Samariya na yamagi sidto na daan. Pagkita nan sidtong otaw, yamatangkug yang pangatayan nan aw yamallat yan kanan. ");
INSERT INTO kqe_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kyakadtowan nan idtong otaw aw yobowan nan ng lana aw bino yang mga pari nan aw bugkuta nan. Pagkatapos san pyapasakay nan sang ayup nan aw daa nan sang sambok na baay na pagapatanaan. Ansan yatiman nan idtong otaw. ");
INSERT INTO kqe_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkailaw kyomamang yan ng dowambok na sapi na pilak aw yatag nan sang tagtomon sidtong baay aw paglaonga nan, ‘Tabiya, atimana yaning otaw. Aw maskin pila pa yang amagasto mo kanan na sobra sang yatag ko kanmo adon, atag ko kanmo pagbarik da ko.’ ");
INSERT INTO kqe_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Na adon,” laong ni Isa, “sino sining toongka otaw yang yamasiling ng kapagonawa sidtong otaw na tyotolis?” ");
INSERT INTO kqe_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tyomobag yang alim, “Yangaong yamallat kanan.” Ansinyan yagalaong si Isa, “Na, panaw da aw inanga yang magonawa sang ininang nan.” ");
INSERT INTO kqe_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ansinyan pyomanaos si Isa aw yang mga inindowan nan sampay na dyomatung silan sang sambok na baryo. Ansan na baryo aon sambok na bobay na pyagangaanan ni Marta aw dyadawat nan silan sang baay nan. ");
INSERT INTO kqe_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aon sambok na lomon ni Marta na pyagangaanan ni Mariyam. Yani si Mariyam yagaingkod sang masaid sang siki ni Isa antak maningug sang pyagaindo nan. ");
INSERT INTO kqe_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Awgaid si Marta, yamarido yang ginawa nan sabap sang kadaig ng gawbuk nan kay yagaandam yan ng pagkan para kanilan. Agaw dyomood yan kang Isa aw laong nan, “Kay Dato, wa kaw akallat kanak na pyapasagdan ako ng kanak mangod aw sayda ko na yagaliyuk? Tabiya, paglaonga kono yan na tabangan ako!” ");
INSERT INTO kqe_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Awgaid tyomobag si Isa kanan, “O kay Marta, yamarido kaw sang madaig na mga butang. ");
INSERT INTO kqe_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Awgaid sambok da yang kinaanglan aw yani yang pipili ni Mariyam. Yang ininang nan labi na madyaw aw di yan akamangun kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sangallaw disinyan yagadowaa si Isa sang sambok na logar. Pagkatapos nan magdowaa, dyomood kanan yang sangka otaw na inindowan nan aw laong nan, “Kay Dato, indowi kami pagdowaa magonawa sang ininang ni Yahiya sang mga inindowan nan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agaw yagalaong si Isa kanilan, “Kong magadowaa kamo, maynini yang pagalaong mayo, “ ‘Ya Tohan na Ama nami, addatan gao yang ngaan mo kay ikaw sotti. Magadato da kaw gao sang kariko ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Atagi kami ng pagkan na kikinaanglan nami ng matag allaw. ");
INSERT INTO kqe_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampona kami sang mga dosa nami kay amponon oman nami yang yamakadosa kanami. Aw pakawata kami sang mga satsat.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ansinyan yagalaong oman si Isa, “Sawpama aon sangka otaw kamayo na makadto sang baay ng amigo nan ng tungang gabi da aw magalaong yan, ‘Kay lomon, atagi ako ng toombok na pan. ");
INSERT INTO kqe_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kay aon yamapit kanak na lomon sikun pa sang mawat, aw ni kaw, way pagkan nami sang baay.’ ");
INSERT INTO kqe_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Adon, sawpama motobag idtong amigo nan adto sa suud, ‘Ayaw da ako pagdistorbowa kay yamanirado da kami ng baay aw yokowang da kami ng mga anak ko. Di da ako makabangon sang pagatag kanmo.’ ");
INSERT INTO kqe_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, monono da yan adon? Awgaid pagalaong ko kamayo na maskin di gao yan magabangon sang pagatag kanan maskin sagaw magamigo silan, awgaid sabap ng wa akasipug yang amigo nan abay pa mangayo, magabangon da yan aw magaatag kanan ng kinaanglan nan. ");
INSERT INTO kqe_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Agaw pagalaong ko kamayo, pagpangayo kamo kay atagan kamo, panganap kamo kay makakita kamo, aw pagtawag kamo kay apasuudun kamo. ");
INSERT INTO kqe_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kay sino-sino yang amangayo atagan, aw sino-sino yang amanganap makakita sang pyapanganap nan, aw sino-sino yang magatawag apasuudun. ");
INSERT INTO kqe_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kamo na mga taganak, kong amangayo ng isda yang kamayo anak, atagan ba mayo ng bila? ");
INSERT INTO kqe_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kong amangayo yan ng itlog, atagan ba mayo ng olaipan? ");
INSERT INTO kqe_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na, kong kamo na maat na mga manosiya matigam mangatag ng madyaw na mga butang adto sang mga anak mayo, labi-labi da yang Tohan na Ama mayo adto sang sorga! Sang way dowa-dowa atag nan yang Nyawa ng Tohan sang maskin sino na amangayo kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sangallaw disinyan pyapalogwa ni Isa yang saytan na pyagasabapan ng pagkaamang ng otaw na yosuudan nan. Na, paglogwa da ng saytan, yakapagtiyab da yang inyan na otaw. Aw yamangkatingaa yang mga otaw na yakakita sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Awgaid yang kadaigan yagalaong, “Si Bilsibol na pangoo ng mga saytan, yan yang yamatag kanan ng kabarakat pagpalogwa sang mga saytan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yang kadaigan oman, karim nilan magtigi kang Isa. Agaw yamangayo silan kanan ng katingaan silbi tanda na syosogo yan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Awgaid kyakatigaman ni Isa yang dumduman nilan, agaw yagalaong yan kanilan, “Kong managonay magtanam yang mga otaw sang sambok na pyagadatowan, sang di amadogay amasapad inyan na pyagadatowan. Aw kong magakabain-bain yang mga otaw sang sambok na pamilya, sang orian amabongkag inyan na pamilya. ");
INSERT INTO kqe_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Magonawa sinyan, kong mapagtanam si Iblis sang mga sakop nan na saytan aw magakabain-bain silan, sang di amadogay akawaan yan ng kapatot pagsogo kanilan aw amasapad da yang pyagadatowan nan. Yagalaong kamo na yagapalogwa ako sang mga saytan kay si Bilsibol yang yamatag kanak ng kabarakat. ");
INSERT INTO kqe_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, kong bunna yang pyagalaong mayo, sino kadi yang yamatag ng kabarakat adto sang mga inindowan mayo pagpalogwa sang mga saytan? Na, silan da yang magalaong na yamasayup kamo. ");
INSERT INTO kqe_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Awgaid sang bunna-bunna yagapalogwa ako sang mga saytan sabap sang kabarakat ng Tohan. Aw yani yang tanda na dyomatung da adi kamayo yang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ansinyan yagaatag oman si Isa kanilan ng opamaan, laong nan, “Kong yang makusug na otaw na aon armas yang yagabantay sang kanan baay, way amaitabo sang mga bubutang nan. ");
INSERT INTO kqe_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Awgaid kong aon domatung na mas makusug pa kanan, amatalo da yan. Ansinyan akamangun da yang kyakasarigan nan na armas aw bain-bainun pa yang pyapangamang sikun sang kanan baay.” ");
INSERT INTO kqe_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yagalaong oman si Isa, “Sino-sino yang di madapig kanak, mapaglaban kanak. Aw sino-sino yang di matabang kanak pagtipon, magapakaya-kaya.” ");
INSERT INTO kqe_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yagalaong oman si Isa, “Aw mologwa yang saytan sikun sang otaw na yosuudan nan, magapanaw-panaw da yan sang mga banwa na way tobig kay amanganap ng akapagpatanaan nan. Aw way kikita nan, magalaong yan sang ginawa nan, ‘Mabarik da gaid ako sang dadaan na pyagauyaan ko.’ ");
INSERT INTO kqe_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na, pagbarik nan makita nan na kyakalinisan da idtong pyagauyaan. ");
INSERT INTO kqe_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ansinyan mapanaw da oman yan kay magadaa yan ng pito pa na saytan na labi pa na maat kay kanan aw mosuud silan sidtong otaw aw apaguyaan nilan. Na, sang orian mas maat pa yang kabutang sidtong otaw kaysang pirmiro.” ");
INSERT INTO kqe_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Paglaong sinyan ni Isa, aon sambok na bobay ansang kamangaotawan na yagalaong ng matanog, “Kadyaw ng ginawa sidtong bobay na yamanganak aw yagapasoso kanmo!” ");
INSERT INTO kqe_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Awgaid tyomobag si Isa, “Awgaid labaw pa yang kasowat sidtong yamaningug sang pyaglaongan ng Tohan aw apangagadan nan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Adon, sang wakto na yagakadaig da yang mga otaw, yagalaong si Isa, “Maat yang mga otaw adon na panahon. Karim gaid nilan makakita ng katingaan silbi tanda na syosogo ako ng Tohan, awgaid way apakita ko kanilan yatabiya sidtong katingaan na yamainang adto kang Nabi Yonos. ");
INSERT INTO kqe_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kay magonawa kang Nabi Yonos na yamainang ng tanda sang mga taga Ninibe sangaon, amainang oman ako na Anak ng Manosiya ng tanda sang mga otaw adon na panahon. ");
INSERT INTO kqe_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sang allaw ng paghokom magabangon yang soltana sang bangsa ng Siba upud sang mga otaw adon na panahon aw magalaong yan na dait kamo siksaun. Kay maskin mawat yang banwa nan kyomadto yan antak maningug sang pyaglaongan ni Soltan Solayman kay maum yang katigam nan. Na, pagalaongon ta kamo na ini adon yang labaw pa kang Soltan Solayman. ");
INSERT INTO kqe_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sang allaw ng paghokom magabangon oman yang mga taga Ninibe upud sang mga otaw adon na panahon aw magalaong silan na dait kamo siksaun kay wa kamo magatawbat. Awgaid silan, yagatawbat silan sang mga dosa nilan pagdungug nilan sang pagosiyat ni Nabi Yonos. Na, pagalaongon ta kamo na ini adon yang labaw pa kang Nabi Yonos.” ");
INSERT INTO kqe_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yagalaong oman si Isa, “Way otaw na magasuga ng ilawan antak tagoon nan atawa asangkoban nan ng gantangan, kondi ibutang nan sang tongtonganan kay antak makita yang siga sinyan pagsuud ng mga otaw sang baay. ");
INSERT INTO kqe_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Adon, yang kanmo mata maynang ilawan ng lawas mo. Kong madyaw yang mata mo, matinaw yang pananaw mo. Na, yang mana sinyan na maallag yang dumduman mo kay di kaw amasina kong iridskian yang kapagonawa mo. Awgaid kong dili ng madyaw yang mata mo, hanap yang pananaw mo. Na, yang mana sinyan na sabap sang pagkatokgawan mo iyan kaw sang kaduguuman. ");
INSERT INTO kqe_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Agaw, pagbantay kay basin yagadumdum kaw na maallag yang dumduman mo, awgaid maduguum sa kadi! ");
INSERT INTO kqe_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Awgaid kong kyakaallagan yang dumduman mo na waa day maduguum, maallag da yang kinabowi mo na maynang yaallagan kaw ng mabislaw na ilaw.” ");
INSERT INTO kqe_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapos ni Isa magindo, aon sambok na Parisi na yagaimbitar kanan antak koman adto kanilan. Agaw yamagad si Isa adto sang kanan baay aw imingkod sang pagpangan. ");
INSERT INTO kqe_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Adon, yamatingaa idtong Parisi pagkita nan na yakan si Isa na wa yan magapangonaw sobay sang batasan nilan na mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Awgaid yagalaong kanan si Isa, “Kamo na mga Parisi, pyagalinisan mayo yang logwa gaid ng kamayo tasa aw plato, awgaid yang pangatayan mayo yamapono ng kaatan aw pagkatokgawan. ");
INSERT INTO kqe_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga sangu kadi kamo! Wa ba mayo akatigami na yang Tohan na yagainang ng kikita mo adi sa logwa, yan oman yang yagainang ng wa mo ikitaa adto sa suud? ");
INSERT INTO kqe_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Agaw, yang madyaw na inangun mayo na atagan mayo yang mga miskinan aw ansinyan amasotti da yang maskin ono na iyan kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Labi na maat yang adatungan mayo na mga Parisi! Yagajakat kamo ng ikasampoo na bain maskin dakman ng kamayo anag na magonawa ng paminta, bawang aw pandan. Awgaid wa mayo inanga yang matorid aw wa oman mayo apakadakowaa yang Tohan sang kamayo pangatayan. Na, yan gao yang dait mayo inangun, awgaid ayaw oman mayo pagpasagdi yang kadaigan pa na mga sogowan. ");
INSERT INTO kqe_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Labi na maat yang adatungan mayo na mga Parisi! Kay kong adto kamo sang pagsasambayangan, kallini mayo magingkod sang ingkodanan ng dakowa na mga otaw. Aw adto sang palengke, kallini mayo na asalamun kamo ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Labi na maat yang adatungan mayo kay magonawa kamo sang kobor na way tosanan. Kong kaginaan inyan ng mga otaw, wa silan akatigam na yamabatar da silan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Adon, aon sambok na alim ng Hokoman na yagalaong kang Isa, “Kay Goro, kong maynan yang pyaglaongan mo, maskin oman kami ininsolto mo.” ");
INSERT INTO kqe_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tyomobag si Isa, “Na, kamo oman na mga alim ng Hokoman, labi na maat yang adatungan mayo! Kay pyapapusan mayo yang mga otaw ng mabugat na magonawa ng mga sogowan na mairap tomanun, awgaid di kamo matabang kanilan ng maskin tagbis. ");
INSERT INTO kqe_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Labi na maat yang adatungan mayo! Kay yagainang kamo ng tadumanan ansang kobor ng mga nabi na pyapatay ng mga kaompowan mayo. ");
INSERT INTO kqe_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sabap sining ininang mayo yagapakita kamo na yakaoyon kamo sang ininang ng kaompowan mayo. Kay silan yang yagapatay sang mga nabi, aw kamo yang yagapakadyaw sang kobor nilan. ");
INSERT INTO kqe_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Idto sagaw, pyapakita yang katigam ng Tohan nang yagalaong yan, ‘Apadaan ko silan ng mga nabi kipat sang mga magpapayapatay ng pyaglaongan ko. Awgaid yang kadaigan kanilan apatayun nilan aw yang kadaigan oman apakasikotan nilan.’ ");
INSERT INTO kqe_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Agaw, kamo na mga otaw adon na panahon, isiksaun kamo ng Tohan sabap sang pagpatay sang kariko ng mga nabi sikun pa sang pagbaoy ng donya. ");
INSERT INTO kqe_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Isiksaun kamo sabap sang pagpatay kang Habil sampay da sang pagpatay kang Sakariyas na pyapatay adto sang tunga ng pagsosonogan ng korban aw yang Baay ng Tohan. Na, pagalaong ko kamayo na yang siksa sang kariko sinyan madatung kamayo na mga otaw adon na panahon. ");
INSERT INTO kqe_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Labi na maat yang adatungan mayo na mga alim ng Hokoman! Kay pyagalupunan mayo yang daan pasingadto sang Tohan antak yang mga otaw di matigam sang kabunnaan. Kamo mismo di magsonod sang daan ng kabunnaan aw yagababag pa kamo sang mga otaw na marim gao magpanaos sinyan.” ");
INSERT INTO kqe_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagpanaw ni Isa sikun sinyan na baay, yamadaman kanan yang mga Parisi aw yang mga magiindoway ng Hokoman. Yabay pa silan magosip kanan ");
INSERT INTO kqe_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kay karim nilan dakupun si Isa sang kanan pyaglaongan antak aon akapagoman nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na, sinyan na wakto libo-libo yang mga otaw na yanagkatipon adto kang Isa aw yanagdinutdutay silan sabap sang kadaig nilan. Ansinyan yagalaong mona si Isa sang mga inindowan nan, “Pagbantay kamo sang labadora ng mga Parisi. Yang karim ko ipasabot na ayaw kamo magsiling sang batasan nilan na yagapakita-kita gaid. ");
INSERT INTO kqe_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kay yang maskin ono na yamatago adon, amaklaro sang orian, aw yang kariko ng wa akatigami adon, akatigaman da. ");
INSERT INTO kqe_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Agaw sagaw yang maskin ono na pyagalaong mayo na kamo gaid yang yamakadungug, amadungug da ng kariko ng mga otaw. Aw yang pyagatomod-tomod mayo adto sang kowarto, apayapat da adto sang kadaigan.” ");
INSERT INTO kqe_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yagalaong oman si Isa, “Pagalaong ko kamayo, mga lomon ko, ayaw kamo magkalluk sidtong makapatay sang lawas mayo awgaid pagkatapos san waa day lain pa na amainang nilan kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Awgaid pagalaong ko kamayo daw sino yang dait mayo kallukan. Yang Tohan da yang kallukan mayo kay pagkatapos nan bogtoon yang napas mayo aon kabarakat nan pagtimbag kamayo adto sang narka. Idto sagaw, yan yang dait mayo kallukan. ");
INSERT INTO kqe_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Na, dumduma mayo yang mga maya. Di ba limambok yang amabili mayo ng piso gaid? Awgaid abir pa maynan, way maskin sambok kanilan na pyapasagdan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na, labi da kamo kay maskin yang logay mayo, kyakatigaman ng Tohan daw pilambok da. Agaw, ayaw kamo magkalluk kay labaw pa yang bili mayo kaysang kadaig ng mga langgam.” ");
INSERT INTO kqe_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yagalaong oman si Isa, “Aon oman pagalaong ko kamayo. Sino-sino yang magalaong sang atobangan ng mga otaw na yamangagad yan kanak na Anak ng Manosiya, angkunun ko oman yan na sakop ko sang atobangan ng mga malaikat ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Awgaid sino-sino yang magalaong sang atobangan ng mga otaw na wa yan apangagad kanak na Anak ng Manosiya, di ko oman yan angkunun na sakop ko sang atobangan ng mga malaikat ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Sino-sino yang magalaong ng maat makapantag kanak na Anak ng Manosiya, amponon yan ng Tohan. Awgaid sino-sino yang magalaong ng maat makapantag sang Nyawa ng Tohan, di yan amponon ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kong adaun kamo adto sang mga pagsasambayangan atawa adto sang atobangan ng mga dato aw pangoo ng banwa, ayaw kamo magkarido daw ono yang akatobag atawa pagalaong mayo. ");
INSERT INTO kqe_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kay sinyan na wakto indowan kamo ng Nyawa ng Tohan daw ono yang pagalaong mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ansinyan aon sambok na otaw ansang kamangaotawan na yagalaong kang Isa, “Kay Goro, paglaonga kono yang kanak lomon na bainan nan ako sang kabilin ni ama kanami.” ");
INSERT INTO kqe_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tyomobag kanan si Isa, “Kay Itin, way yamatag kanak ng kapatot paghokom kamayo atawa pagbain sang kabilin kamayo.” ");
INSERT INTO kqe_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ansinyan yagalaong si Isa adto sang mga otaw, “Pagbantay kamo aw paglikay kamo sang maskin ono na pagkatokgawan. Kay yang kakawasaan na maskin ono yang kadakowa sinyan, di makaatag kamayo ng bunna na kinabowi.” ");
INSERT INTO kqe_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ansinyan yagalaong si Isa kanilan ng pasombingay, laong nan, “Aon sapian na yang kanan lopa madyaw yang abot. ");
INSERT INTO kqe_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ansinyan yagalaong yan sang ginawa nan, ‘Ono yang inangun ko kay waa day akabutangan ko sining kadaig ng kanak abot? ");
INSERT INTO kqe_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na, yani kay yang inangun ko,’ laong nan, ‘ogubaun da ko yaning mga kamarig ko aw magapatokod ako ng dakowa pa sinyan. Aw adto da ko obutang yang kariko ng kanak abot kipat sang mga kabtangan ko. ");
INSERT INTO kqe_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ansinyan magalaong da ako sang ginawa ko na madyaw da yang kabutang ko maskin pilangka toig pa aw waa day akaridowan ko. Abay da gaid ako koman, minum aw maglingaw-lingaw.’ ");
INSERT INTO kqe_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Awgaid yagalaong yang Tohan kanan, ‘Sangu kaw! Kay adon na gabi obogtoon da yang napas mo. Na, sino da yang amangkun sang kariko ng yamatipon mo?’ ” ");
INSERT INTO kqe_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sang orian laong ni Isa, “Magonawa sinyan yang akatamanan sidtong otaw na yagatipon ng kakawasaan para sang ginawa nan awgaid miskinan yan adto sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ansinyan yagalaong si Isa sang mga inindowan nan, “Agaw sagaw pagalaong ko kamayo na ayaw kamo magkarido sang kinabowi mayo daw ono yang akanun atawa ono yang apandagomon mayo. ");
INSERT INTO kqe_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kay yang kinabowi labaw pa sang pagkan aw yang lawas mayo labaw pa sang mga dagom. ");
INSERT INTO kqe_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tanawa mayo yang mga owak. Di silan mananum, di silan maggani aw way oman kamarig nilan. Awgaid pyapakan silan ng Tohan. Na, di ba labaw pa yang bili mayo kaysang mga langgam? ");
INSERT INTO kqe_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sino kamayo yang makapataas sang kinabowi nan ng maskin tagbis da gaid sabap sang pagkarido? ");
INSERT INTO kqe_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na, kong di mayo mainang yaning tagbi gaid na butang, nanga sa yamarido kamo sang kadaigan pa na mga butang? ");
INSERT INTO kqe_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tanawa mayo yang mga bolak daw monono yang pagtorin nilan. Di silan maggawbuk aw di silan maglaa. Awgaid pagalaong ko kamayo na maskin yang mga dagom ni Soltan Solayman na bali na kawasa nan wa makatupung sang kadyaw sining mga bolak. ");
INSERT INTO kqe_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na, kong maynan yang pagpandagom ng Tohan sang sagbut na bowi adon awgaid kisuum osonogon da, kamo pa na manosiya, di nan kamo atagan ng dagom? Katagbi ng pagpangintoo mayo! ");
INSERT INTO kqe_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Agaw sagaw, ayaw mayo abay pagdumduma daw ono yang akanun atawa inumun mayo aw ayaw kamo magkarido. ");
INSERT INTO kqe_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kay yani maag yang kyakaridowan ng mga otaw na wa apangintoo sang Tohan. Awgaid kamo, ayaw kamo magkarido kay kyakatigaman ng Ama mayo adto sang sorga na kinaanglan mayo yani na mga butang. ");
INSERT INTO kqe_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Awgaid onaa mayo yang pagpasakop sang pagdato ng Tohan aw ansinyan atagan kamo ng kariko ng kikinaanglan mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yagalaong oman si Isa, “Ayaw kamo magkalluk maskin tagbi da kamo na yamangagad kanak. Kay kallini ng Tohan na Ama mayo na atagan kamo ng kapatot pagdato adto sang pyagadatowan nan. ");
INSERT INTO kqe_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ibarigya mayo yang mga kabtangan mayo aw ipagsidoka mayo yang alin sinyan adto sang mga miskinan. Pagtipon kamo ng kakawasaan adto sang sorga kay yani na kakawasaan di amasapad aw di oman akakamangan kay adto sang sorga way kawatan aw way oman anay na makakutkut sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kay daw wain yang kakawasaan mayo, adto oman yang pangatayan mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yagalaong oman si Isa kanilan, “Madyaw kong andam kamo sang kariko ng wakto sampay da sang pagbarik ko. Pagsiling kamo sang mga sogowanun na yagatagad sang pagori ng kanilan amo sikun sang kawin. Yakapandagom silan aw wa nilan apataya yang ilawan kay antak pagdatung ng kanilan amo aw magatawag adto logwa, akaabrian dayon nilan yan. ");
INSERT INTO kqe_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kadyaw ng ginawa sidtong mga sogowanun kong adatungan silan ng kanilan amo na yagatagad sang pagori nan. Bunna yaning pagalaong ko kamayo na yan na amo magailis, paingkodon nan silan sang lamisa aw yan da yang magaaya kanilan ng pagkan. ");
INSERT INTO kqe_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kadyaw sagaw ng ginawa nilan kong adatungan nan silan na yakapangandam sang pagori nan maskin pa tungang gabi atawa kadlawon yang pagdatung nan. ");
INSERT INTO kqe_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Awgaid timani mayo yani, kong kyakatigaman pa ng tagtomon ng baay daw ono na wakto yang pagdatung ng kawatan, magabantay gao yan antak yang kawatan di makasuud sang kanan baay. ");
INSERT INTO kqe_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Magonawa oman sinyan kamo. Pagandam kamo kay mabarik ako na Anak ng Manosiya sang wakto na wa kamo magadumdum na mabarik ako.” ");
INSERT INTO kqe_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Adon yagaosip si Pitros kang Isa, “Kay Dato, yani na pasombingay kanami gaid atawa sang kariko ng mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tyomobag si Isa pinaagi sang sambok oman na pasombingay, laong nan, “Yang sogowanun na kasarigan aw matigam maggawbuk, yan yang ipiliun ng amo nan antak magdaa sang kadaigan pa na mga sogowanun. Aw yan da yang magaatag kanilan ng kanilan pagkan sang insakto na wakto. ");
INSERT INTO kqe_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kadyaw ng ginawa sidtong sogowanun aw pagori ng kanan amo, adatungan yan na yagainang ng kanan gawbuk. ");
INSERT INTO kqe_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sang bunna-bunna pagalaong ko kamayo na asarig da kanan ng amo nan yang kariko ng mga kabtangan nan. ");
INSERT INTO kqe_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Awgaid kong maat yang idto na sogowanun, magalaong yan sang ginawa nan, ‘Ah, madogay pa mori yang amo ko!’ Tapos okolataun da nan yang mga kaupdanan nan na sogowanun, mga usug aw bobay, aw abay gaid yan koman, minum aw magkalasing. ");
INSERT INTO kqe_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na, ansinyan omori da yang amo nan sang wakto na wa nan akaniyat kay wa nan akatigami daw ono na allaw yang pagbarik nan. Ansinyan kastigoon da yan ng amo nan aw adto da yan obutang sang adatungan ng mga otaw na wa apangintoo sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yang sogowanun na yamatigam sang karim apainang kanan ng amo nan awgaid wa nan inanga, yan yang alabutun ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Awgaid yang sogowanun na wa akatigam daw ono yang karim ng kanan amo, tapos yamakadosa yan, alabutun oman awgaid tagbis da. Kay sino-sino yang yatagan ng madaig, madaig oman yang atagadan sikun kanan. Aw kong madaig yang syasarig kanan, labi na madaig yang atagadan sikun kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yagalaong oman si Isa, “Yakani ako sining donya sang pagdaa ng atoon aw karim ko na pyagadook da gao yan. ");
INSERT INTO kqe_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Awgaid madaig pa yang mga kasikotan na dait ko agian aw yamarido ako sampay di pa yan amatoman. ");
INSERT INTO kqe_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yagadumdum ba kamo na yakani ako sang pagdaa ng kalinaw adi sining donya? Dili kalinaw yang dyadaa ko kondi kasamok kay ako yang pyagasabapan ng pagkabain-bain ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kay sikun adon, yang limangka otaw sang sambok na pamilya magakabain-bain, yang too laban sang dowa aw yang dowa laban sang too. ");
INSERT INTO kqe_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yang ama aw yang anak nan na usug magakalaban, yang ina aw yang anak nan na bobay magakalaban, kipat sang ogangan na bobay aw yang komokuug na bobay, magakalaban silan.” ");
INSERT INTO kqe_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ansinyan yagalaong si Isa sang mga otaw, “Kong makita mayo na aon gabon sang sallupan, magalaong kamo, ‘Omowan yani mallaw,’ aw amaitabo sagaw yan. ");
INSERT INTO kqe_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aw kong moyop yang habagat, magalaong kamo, ‘Mapaso da yani mallaw,’ aw amaitabo oman yan. ");
INSERT INTO kqe_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kamo na yagapakita-kita gaid! Akatigaman mayo yang timpo sabap sang kikita mayo sang lopa aw sang langit. Awgaid nanga sa di kamo matigam magmana sang kikita mayo na mga pangitabo adon na panahon? ");
INSERT INTO kqe_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nanga sa di kamo matigam paghokom daw ono yang madyaw na inangun mayo? ");
INSERT INTO kqe_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sawpama aon otaw na magadimanda kanmo. Na, pagpaningkamot kamo pagosay sang wa pa kamo adatung sang hokmanan. Kay kong dili, basin adaun kaw nan adto sang howes, aw ansinyan adaun kaw adto sang polis aw alasak da kaw sang pirisowan. ");
INSERT INTO kqe_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pagalaong ko kamayo na di da kaw amakalogwa sikun sinyan sampay di mo akabayadan yang kariko ng molta mo.” ");
INSERT INTO kqe_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, sidto na wakto aon mga otaw na yagagogod kang Isa makapantag sang mga taga Jalil na pyapapatay ni Pilato sarta yagapakorban silan adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ansinyan tyomobag si Isa aw laong nan kanilan, “Na, yagadumdum ba kamo na yang idto na mga taga Jalil labaw pa yang dosa nilan kaysang kadaigan pa na mga taga Jalil sabap ng maynidto yang pagkamatay nilan? ");
INSERT INTO kqe_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dili! Awgaid pagalaong ko kamayo, kong di kamo magtawbat aw di mayo biyaan yang maat na mga inang mayo, amangkamatay kamo magonawa nilan. ");
INSERT INTO kqe_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na, yangaong 18 ka otaw na yamatay adto sang Silowam kay kyakatombaan silan ng mataasay na baay, yagadumdum ba kamo na labaw pa yang dosa nilan kaysang kadaigan pa na mga otaw na yagauya sang Awrosalam? ");
INSERT INTO kqe_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dili! Awgaid pagalaong ko kamayo, kong di kamo magtawbat aw di mayo biyaan yang maat na mga inang mayo, amangkamatay kamo magonawa nilan.” ");
INSERT INTO kqe_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ansinyan yagalaong si Isa kanilan sini na pasombingay, laong nan, “Aon sangka otaw na aon kaoy na igira ansang tanumanan nan ng grips. Ansinyan kyomadto yan kay atanawon nan daw aon bonga sini na kaoy, awgaid way kikita nan. ");
INSERT INTO kqe_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Agaw yagalaong yan sang yagaatiman ng tanumanan, ‘Na, ikatoo na toig da yani ng pagtanaw ko daw aon bonga sini na kaoy, awgaid ni kaw, way kikita ko. Madyaw pa aw ipilaun da mo kay yamakaatraso gaid sang lopa.’ ");
INSERT INTO kqe_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Awgaid tyomobag yang yagaatiman, ‘Kay Sir, pasagdi pa nay adon na toig. Kay okotkotan ko yang makilibot aw obutangan ko ng abono. ");
INSERT INTO kqe_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na, kong magabonga da yan sonod na toig, madyaw. Awgaid kong dili, na, apapila da mo.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sangallaw disinyan na Allaw ng Pagpatana yagaindo si Isa adto sang pagsasambayangan ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aon bobay disidto na yamasakit sa suud ng 18 pangka toig sabap sang saytan. Adon yamalokot da yang lawas nan aw wa da yan makaindug ng matorid. ");
INSERT INTO kqe_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkita kanan ni Isa, tyatawag nan antak domood kanan aw yagalaong yan kanan, “Kay Babo, madyaw da kaw sikun sang kanmo sakit.” ");
INSERT INTO kqe_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ansinyan dyadapunan ni Isa idtong bobay ng arima nan aw sinyan dayon yamakaindug yan ng matorid aw yagapoji yan sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Adon, yang pangoo ng pagsasambayangan yamadaman kay si Isa yagapakadyaw sang Allaw ng Pagpatana. Agaw yagalaong yan adto sang mga otaw, “Aon unum na allaw sang sangka simana na makagawbuk kita. Agaw, sinyan na mga allaw singani kamo antak pakadyawon kamo, awgaid dili sang Allaw ng Pagpatana!” ");
INSERT INTO kqe_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ansinyan tyomobag kanan si Isa, “Kamo na yagapakita-kita gaid! Kong aon baka atawa asno mayo, di ba obadun mayo aw ogoyodon mayo adto sang inmanan maskin Allaw ng Pagpatana? ");
INSERT INTO kqe_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na, ini adon yaning topo ni Nabi Ibrahim na pyapakasikotan ni Iblis sa suud ng 18 pangka toig na maynang gyagapos yan. Dait gaid na akaobadan yan adon maskin Allaw ng Pagpatana!” ");
INSERT INTO kqe_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Adon, yani na tobag ni Isa yapakasipug sang mga yagakontra kanan. Awgaid yang kadaigan na mga otaw yamangkasowat sabap sang kariko ng mga katingaan na ininang ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ansinyan yagalaong si Isa kanilan, “Ono yang akapagonawa ko sang pagdato ng Tohan? Ono yang akaparias ko sinyan? ");
INSERT INTO kqe_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na, magonawa yan sang tagbi na liso ng mostasa na tyatanum ng otaw sang kanan pawa. Ansinyan tyomorin yan aw yamainang yan ng kaoy. Aw maskin yang mga langgam makapogad sang mga sanga sinyan.” ");
INSERT INTO kqe_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yagalaong oman si Isa, “Ono yang akaparias ko sang pagdato ng Tohan? ");
INSERT INTO kqe_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Magonawa yan sang labadora na pyagasagul ng bobay sang sangka sako na arina aw ininang nan ng masa. Aw ansinyan tyomobo yang tibok masa.” ");
INSERT INTO kqe_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ansinyan, sarta yagapasingadto si Isa sang Awrosalam, yagaindo yan adto sang mga longsod aw baryo na yaagian nan. ");
INSERT INTO kqe_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na, sangallaw aon yagaosip kanan, “Kay Sir, tagbi da yang amalowas?” ");
INSERT INTO kqe_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tyomobag si Isa aw laong nan, “Pagpaningkamot kamo pagsuud sang mapiyut na powertaan kay pagalaong ko kamayo na madaig gao yang mosuud sang pyagadatowan ng Tohan, awgaid di silan makasuud. ");
INSERT INTO kqe_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kay magonawa yan sang tagtomon ng baay na imindug kay amanirado da yan. Na, magaindugun da gaid kamo adto logwa aw magatawag kamo, ‘Kay Dato, pasuuda kami!’ “Awgaid motobag yan kamayo, ‘Wa ako akatigam daw wain kamo magasikun!’ ");
INSERT INTO kqe_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ansinyan motobag kamo, ‘Yagadungan sa kita koman aw yagaindo kaw sang kanami longsod!’ ");
INSERT INTO kqe_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Awgaid magalaong da oman yan, ‘Pagalaong ko kamayo na wa ako akatigam daw wain kamo magasikun. Panaw kamo, obos kamo na yagainang ng maat!’ ");
INSERT INTO kqe_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na, kong makita mayo si Ibrahim, si Isahak aw si Yakob kipat sang kariko ng mga nabi adto sang pyagadatowan ng Tohan, magatiyao da kamo aw mangoyagut yang onto mayo kay kamo, pyapapanaw kamo aw wa kamo apasuuda. ");
INSERT INTO kqe_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Awgaid madaig yang mga otaw na dili ng Yahodi na madatung sikun sang opat ka pinidyowan ng donya aw makan silan sang kandori adto sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, timani mayo na aon yamaori adon na amaona, aw aon yamaona adon na amaori.” ");
INSERT INTO kqe_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sidto na wakto aon mga Parisi na yodood kang Isa aw yagalaong silan kanan, “Madyaw pa aw apanawan da mo yani na banwa kay karim ni Soltan Hirod na apatayun kaw.” ");
INSERT INTO kqe_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tyomobag si Isa kanilan, “Kadto kamo aw paglaonga mayo yangaong limbongon na otaw na padayonon pa ko yang gawbuk ko. Palogwaun ko yang mga saytan sikun sang mga otaw aw pakadyawon ko yang mga masakitun, awgaid di da ng madogay. Kay masaid da domatung yang wakto na amatapos da ko yang kanak gawbuk. ");
INSERT INTO kqe_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yamatigam ako na di ako amaono adi sining banwa. Awgaid kinaanglan na adon, kisuum, aw sangka allaw padayonon pa ko yang panaw ko adto sang Awrosalam. Kay di mapakay na yang nabi apatayun sang kadaigan na banwa kondi adto da gaid sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O mga taga Awrosalam! Kallat mayo kay pyapatay mayo yang mga nabi aw byabato mayo yang mga otaw na syosogo ng Tohan adto kamayo. Makapila da ako magpakita kamayo na karim ta kamo tiponon aw atimanun magonawa sang osoyan na olooban nan yang mga osoy nan. Awgaid wa kamo akallini! ");
INSERT INTO kqe_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na, apabayaan da kamo ng Tohan. Pagalaong ko kamayo na di da mayo ako ikitaun taman sang wakto na mabarik oman ako aw magalaong da kamo, ‘Atagan gao ng kadyawan yaning syosogo ng Tohan.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sangallaw disinyan na Allaw ng Pagpatana kyomadto si Isa antak koman sang baay ng sambok na pangoo ng mga Parisi. Na, adto sang baay pyagasimaan yan ng mga otaw daw ono yang inangun nan. ");
INSERT INTO kqe_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ansinyan aon sambok na otaw na dyadaa sang atobangan ni Isa na yamallobag yang kanan arima aw bitis. ");
INSERT INTO kqe_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na, yosip ni Isa yang mga alim ng Hokoman aw yang mga Parisi, laong nan, “Sobay ba sang Hokoman yang pagpakadyaw sang mga masakitun sang Allaw ng Pagpatana atawa dili?” ");
INSERT INTO kqe_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Awgaid wa silan otobag kanan. Na, yang ininang ni Isa, kyukuputan nan idtong otaw, pakadyawa nan aw paoria. ");
INSERT INTO kqe_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ansinyan yagalaong si Isa kanilan, “Sawpama aon anak atawa baka mayo na yamallog sang balon sang Allaw ng Pagpatana, di ba batonon dayon mayo sikun sinyan maskin Allaw ng Pagpatana?” ");
INSERT INTO kqe_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Awgaid wa silan makatobag sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ansinyan kikita ni Isa na yang mga bisita ng Parisi yamamili ng ingkodanan na para sang mga dungganun. Agaw yagalaong yan kanilan sini na pasombingay, ");
INSERT INTO kqe_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","laong nan, “Kong aon yagaimbitar kanmo sang kawin, ayaw magingkod sang ingkodanan na para sang mga dungganun kay basin aon pay bisita na labaw pa kanmo. ");
INSERT INTO kqe_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na, pagdatung sinyan na otaw, odoodan kaw ng yagaimbitar kamayo dowa aw pagalaongon da kaw, ‘Tabiya, atagan kanan yaning pyagaingkodan mo.’ Ansinyan akasipugan da kaw aw adto da kaw magingkod sang ingkodanan na dili ng madyaw. ");
INSERT INTO kqe_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Agaw kong imbitado kaw, pagpili ng ingkodanan na dili ng madyaw kay antak pagdood kanmo ng yagaimbitar pagalaongon kaw nan, ‘Anda, kay lomon, adto kaw pagingkod sang madyaw na ingkodanan.’ Ansinyan amabantog da kaw sang atobangan ng kariko ng mga bisita nan. ");
INSERT INTO kqe_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay sino-sino yang magapataas sang ginawa nan, apababaun, aw idtong magapababa sang ginawa nan, apataasun.” ");
INSERT INTO kqe_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ansinyan yagalaong si Isa sidtong yagaimbitar kanan, “Kong magakandori atawa magapakaradyaan kaw, ayaw da magimbitar sang mga amigo mo, yang mga lomon atawa parinti mo atawa yang mga simbaay mo na sapian kay silan amakabaus kanmo. ");
INSERT INTO kqe_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Awgaid kong magapakaradyaan kaw, pagimbitar sang mga miskinan, yang mga pongkol, yang mga sadi, aw yang mga bota. ");
INSERT INTO kqe_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kay kong inangun mo yan, aon kadyawan mo kay silan di amakabaus kanmo. Yang Tohan da yang magabaus kanmo sang Allaw na Maori nang amabowi oman yang mga otaw na matorid sang pagtanaw nan.” ");
INSERT INTO kqe_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pagdungug sinyan ng sangka otaw na yagaupud kang Isa sang pagpangan, yagalaong yan kanan, “Kadyaw ng ginawa sidtong mga otaw na makakan sang kandori adto sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ansinyan pyagalaong yan ni Isa ng pasombingay, laong nan, “Aon sambok na otaw na yagaandam ng dakowa na pakaradyaan aw madaig yang imbitado nan. ");
INSERT INTO kqe_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pagdatung ng wakto na magakandori da silan, syosogo nan yang kanan sogowanun na akadtowan nan yang mga imbitado aw paglaongon silan na, ‘Kadto da kamo, kay yandam da yang kandori.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Awgaid yang matag-isa kanilan yagabaribad. Yang sambok yagalaong sidtong sogowanun, ‘Baya pa ako yakabili ng lopa. Dait na akadtowan aw atanawon ko nay ona. Ampon tabiya da gaid.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Yang sambok oman yagalaong, ‘Yakabili ako ng limangka paris na baka. Tistingan ko adon daw madyaw silan idaro. Ampon tabiya da gaid.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aw yang sambok oman yagalaong, ‘Baya pa ako akawina. Agaw di ako makakadto.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ansinyan yomori idtong sogowanun aw paglaonga yang kanan amo. Na, yamadaman da yang amo aw yagalaong yan adto sang kanan sogowanun, ‘Pagapas-apas kadto sang mga kamino aw mga daan ansining syodad aw daa adi yang mga miskinan, yang mga pongkol, yang mga bota kipat sang mga sadi.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Pagtoman sinyan ng sogowanun, yagalaong yan sang kanan amo, ‘Kay Sir, ininang da ko yang pyagasogo mo, awgaid aon pay kanatun logar.’ ");
INSERT INTO kqe_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ansinyan yagalaong yang amo sang kanan sogowanun, ‘Kadto sang mga daan sa logwa ng syodad aw adto oman sang mga baryo aw pakania yang kariko ng otaw antak mapono yang kanak baay. ");
INSERT INTO kqe_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kay pagalaong ko kamayo na way maskin isa sidtong mga otaw na imbitado ng pirmiro yang makakan sang kandori na pyagaandam ko.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sangallaw disinyan labi na madaig yang mga otaw na yamagad kang Isa. Ansinyan yagaatobang yan kanilan aw yagalaong yan, ");
INSERT INTO kqe_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sino-sino yang marim mangagad kanak, dait na palabiun nan ako kaysang ama aw ina nan, sang asawa aw mga anak nan, sang mga kalomonan nan aw maskin oman sang ginawa nan. Kay kong dili, di mapakay na amainang yan ng inindowan ko. ");
INSERT INTO kqe_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aw sino-sino yang dili andam magagi ng kasikotan aw maskin yang pagkamatay sabap sang pagpangagad nan kanak, di yan mapakay mainang ng inindowan ko. ");
INSERT INTO kqe_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sawpama, aon sangka otaw kamayo na yagadumdum magpatokod ng dakowa na baay. Di ba magaingkod yan ona aw tanawon nan daw pila yang agastoon nan aw kong aon sapi nan sang pagtapos sinyan? ");
INSERT INTO kqe_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kay kong di nan ona dumdumun, na, basin pagkatapos nan magpaindug sang mga arigi, okolangan da yan ng sapi aw di nan amatapos yang baay. Na, yang kariko ng makakita sinyan magadigay-digay da kanan ");
INSERT INTO kqe_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aw magalaong silan, ‘Tanawa mayo yani na otaw, yagasogod yan magpatokod ng baay, awgaid di nan amatapos!’ ");
INSERT INTO kqe_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Atawa aon sambok na soltan na 10,000 yang kanan mga sondao na yagadumdum mapaglaban sang sambok na soltan na 20,000 yang mga sondao. Na, magaingkod yan ona aw dumdumun nan daw makaya nan mapaglaban sidto na soltan. ");
INSERT INTO kqe_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na, kong sang dumduman nan di nan makaya, magasogo da yan ng mga otaw sang pagsongon sidto na soltan aw amangayo ng kalinaw sarta mawat pa yan. ");
INSERT INTO kqe_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Idto sagaw kamo oman, dumduma mayo ona daw ono yang inangun mayo. Kay kong di mayo akabiyaan yang kariko ng mga butang mayo, di kamo amainang ng mga inindowan ko.” ");
INSERT INTO kqe_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ansinyan yagalaong oman si Isa, “Kyakatigaman mayo na madyaw yang asin. Awgaid kong mawaa yang lasa ng asin, di da mapabarik yang kaasin nan. ");
INSERT INTO kqe_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Di da yan amagamit maskin pa sang pagpataba sang lopa atawa pagsagul sang pangabono. Agaw, itimbag da gaid yan. Na, kamo na yamaningug, paningugi mayo ng madyaw yang pyagalaong ko kamayo.” ");
INSERT INTO kqe_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ansinyan madaig yang mga mangobraay ng bowis kipat sidtong mga otaw na tyatawag na baradosa na yodood kang Isa antak maningug sang pagindo nan. ");
INSERT INTO kqe_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na, pagkita sinyan ng mga Parisi kipat sang mga magiindoway ng Hokoman, yanagbagolbol silan aw laong nilan, “Tanawa sa yani na otaw! Yagatarima yan sang mga baradosa aw yagaupud pa yan kanilan koman.” ");
INSERT INTO kqe_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Agaw yagalaong kanilan si Isa sini na pasombingay, laong nan, ");
INSERT INTO kqe_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sawpama aon isa kamayo na 100 ka bok yang karniro nan aw yamawaa yang sambok. Ono kowaw yang inangun nan? Di ba ibiyaan nan yang 99 adto sang pyapanamsaman aw anapun nan idtong yamawaa taman sang ikitaun da nan? ");
INSERT INTO kqe_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na, kong kitaun da nan, opusanun nan na bali na kasowat nan. ");
INSERT INTO kqe_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aw pagori nan atawagun nan yang kanan mga lomon kipat sang mga simbaay aw magalaong yan, ‘Magapakaradyaan kita kay kinita da ko yang kanak karniro na yamawaa!’ ");
INSERT INTO kqe_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na, pagalaong ko kamayo na magonawa sinyan labaw pa yang kasowat adto sang sorga sidtong sangka otaw na yamakadosa aw yagatawbat sang dosa nan kaysang 99 na yagadumdum na matorid silan aw di silan kinaanglan magtawbat.” ");
INSERT INTO kqe_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Laong oman ni Isa, “Sawpama aon sambok na bobay na aon kanan sampoo na sapi na pilak aw yamawaa yang sambok. Ono kowaw yang inangun nan? Di ba sugaan nan yang ilawan, walisan nan yang kanan baay aw anapun nan inyan taman sang ikitaun da nan? ");
INSERT INTO kqe_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na, pagkita da nan, atawagun nan yang mga lomon nan kipat sang mga simbaay aw magalaong yan, ‘Magapakaradyaan kita kay kinita da ko yang sapi ko na yamawaa!’ ");
INSERT INTO kqe_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na, pagalaong ko kamayo na magonawa sinyan amangkasowat yang mga malaikat ng Tohan adto sang sorga kong yang sangka otaw na yamakadosa magatawbat sang dosa nan.” ");
INSERT INTO kqe_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ansinyan yagalaong oman si Isa, “Aon sangka otaw na aon dowambok na anak na usug. ");
INSERT INTO kqe_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sangallaw sidto yagalaong yang mangod sang ama nan, ‘Ama, atagan da adon kanak yang kanak kabainan ng kanami irinsya.’ Na, byabain da ng ama yang kabtangan nan adto sang dowambok nan na anak. ");
INSERT INTO kqe_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Mga pilang allaw disinyan byabarigya ng mangod yang kariko ng kabainan nan aw kadto yan sang mawat na banwa na daa yang kanan sapi. Adto sidtong banwa syasapad-sapadan nan yang kanan sapi sang mga inang na way poos. ");
INSERT INTO kqe_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na, pagkaorot nan gastoon yang kanan sapi, aon dyomatung na dakowa na gutum sidto na banwa aw waa day amakan nan. ");
INSERT INTO kqe_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Agaw kyomadto yan sang sambok na otaw sidto na banwa antak maggawbuk para kanan. Aw syosogo yan adto sang pawa antak magbantay sang mga binatang. ");
INSERT INTO kqe_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ansinyan yamagutumay da yan aw kanun gao nan maskin idtong pyagatobong nan sang mga binatang. Awgaid way maskin sino na yagaatag kanan ng pagkan. ");
INSERT INTO kqe_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Na, sang kadogayan sinyan yakadumdum da yan sang kabutang nan aw laong nan sang ginawa nan, ‘Yang kariko ng mga otaw ni ama, madaig yang pagkan aw yamanobra pa. Awgaid ako, idi ako na amatay da ng gutum! ");
INSERT INTO kqe_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Madyaw pa aw omori da ako kang ama aw pagalaongon ko yan, “Ama, yamakadosa ako sang Tohan kipat oman kanmo. ");
INSERT INTO kqe_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Di da ako dait na pagatawagun pa mo na anak mo. Bilangan da gaid ako na sambok sang kanmo mga otaw.” ’ ");
INSERT INTO kqe_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ansinyan imindug yan aw yomori sang ama nan. “Na, mawat pa yan kanilan, kikita da yan ng ama. Ansinyan yamatangkug yang pangatayan ng ama, dyomaagan yan pagsongon sang anak, angkupa nan aw auki. ");
INSERT INTO kqe_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ansinyan yagalaong yang anak, ‘Ama, yamakadosa ako sang Tohan kipat oman kanmo. Di da ako dait na pagatawagun pa mo na anak mo.’ ");
INSERT INTO kqe_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Awgaid tyatawag dayon ng ama yang kanan mga allang aw laong nan kanilan, ‘Kallug kamo! Kamanga yang madyaway na dagom aw pasootan kanan. Pasooti ng sandalyas aw pasuugi ng singsing. ");
INSERT INTO kqe_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sobaria mayo yang pyapataba na nati ng baka kay magapakaradyaan da kita. ");
INSERT INTO kqe_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay yaning kanak anak magonawa ng patay na yamabowi oman. Magonawa yan ng yamatanak, awgaid adon kinita da!’ Ansinyan yagasogod da silan magpakaradyaan. ");
INSERT INTO kqe_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, sidto na wakto waa ansan yang magowang na anak kay idto yan sang pawa. Adon, pagori nan aw masaid da yan sang baay, yamadungug nan yang pagtogtog ng kolintang aw yang pagsayaw. ");
INSERT INTO kqe_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Agaw tyatawag nan yang sambok na allang aw osipa nan, ‘Nanga sa yagapakaradyaan kamo?’ ");
INSERT INTO kqe_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Tyomobag yang allang, ‘Yomori da yang kanmo mangod aw pyapasobari ni ama mo yang pyapataba na baka kay yang mangod mo yamakaori kono na way maat na yamaitabo kanan.’ ");
INSERT INTO kqe_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na, yamadaman yang magowang aw di yan mallini somuud sang baay. Agaw kyakadtowan yan ng ama nan aw yangyo nan na mapanik. ");
INSERT INTO kqe_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Awgaid yagalaong yang magowang na anak sang ama nan, ‘Ama, tanawa kono! Dogayay da ako magagawbuk para kanmo, ni kaw, way sogo mo na syosopak ko. Ono yang yatag mo kanak? Maskin sambok na kambing antak makapakaradyaan ako upud sang mga kaupdanan ko, way yatag mo kanak! ");
INSERT INTO kqe_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Awgaid adon, pagdatung sining kanmo anak na yagasapad-sapad sang kanmo kabtangan upud sang dopang na mga bobay, pyapasobari pa mo yang pyapataba na baka!’ ");
INSERT INTO kqe_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Awgaid tyomobag yang ama, ‘Anak, ini kaw pirmaminte upud kanak aw yang kariko na idi kanak, kanmo oman. ");
INSERT INTO kqe_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Awgaid adon dait gaid na magakasowat aw magapakaradyaan kita kay yang mangod mo na magonawa ng patay, yamabowi oman. Magonawa yan ng yamatanak, awgaid adon kinita da!’ ” ");
INSERT INTO kqe_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ansinyan yagalaong si Isa adto sang mga inindowan nan, “Aon sapian na aon sambok na sogowanun na syasarigan nan sang kariko ng kanan kabtangan. Sangallaw disinyan aon yagaoman sang sapian na yang kanan kabtangan syasapad-sapadan gaid nidtong sogowanun na kanan sinarigan. ");
INSERT INTO kqe_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Agaw pyapatawag nan idtong sogowanun aw paglaonga nan, ‘Ono yaning yamadungug ko makapantag kanmo? Atagi ako adon ng listaan ng kariko ng kabtangan ko aw paglaonga ako daw monono yang pagatiman mo sinyan. Kay sikun adon di da ta kaw akasarigan sang kabtangan ko.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ansinyan yagalaong yang sogowanun sang ginawa nan, ‘Apapanawon da kadi ako ng kanak amo. Ono da yang inangun ko? Di ako makagaga maggawbuk ng mabugat na magonawa ng pagkotkot aw yamasipug ako magpakilimos. ");
INSERT INTO kqe_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, yamatigam da ako daw ono yang inangun ko antak kisuum kong waa day gawbuk ko, aon mga otaw na madawat kanak sang kanilan baay.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ansinyan pyapatawag nan yang kariko ng mga otaw na yamakaotang sang kanan amo. Yosip nan yang yamakaona, laong nan, ‘Pila yang otang mo sang kanak amo?’ ");
INSERT INTO kqe_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Tyomobag yang yamakaotang, ‘100 ka lata ng lana ng jayton.’ “Laong ng sogowanun, ‘Idi kay yang listaan ng kanmo otang. Pagingkod aw pagsorat ng 50.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ansinyan yosip oman nan yang sambok, ‘Ikaw, pila pa yang otang mo?’ “Tyomobag yan, ‘100 ka sako ng bugas.’ “Laong ng sogowanun, ‘Idi kay yang listaan mo. Pagsorat ng 80.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na, pagdungug ng amo sang ininang nidtong sogowanun na yagalimbong kanan, byabantog nan yan sabap ng yamatigam yan maginang ng makapagkadyaw kanan. Bunna sagaw na yang mga otaw na kadodonyai yang dumduman, matigam silan magdaa sang mga otaw na main nilan labaw pa sang mga otaw na yamangagad sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Agaw pagalaong ko kamayo na agamitun mayo yang kakawasaan mayo adi sining donya antak tabangan mayo yang kapagonawa mayo kay antak pagdatung ng wakto na di da kinaanglan ng sapi, adawatun da kamo adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kay sino-sino yang akasarigan sang tagbi, akasarigan oman sang dakowa. Aw sino-sino yang di akasarigan sang tagbi, di oman akasarigan sang dakowa. ");
INSERT INTO kqe_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, kong di kamo akasarigan sang kakawasaan adi sining donya, monono da yang pagsarig kamayo sang bunna na kakawasaan? ");
INSERT INTO kqe_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aw kong di kamo akasarigan sang kabtangan ng kadaigan, sino yang magaatag kamayo ng kakawasaan na yandam da para kamayo? ");
INSERT INTO kqe_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Way allang na dowambok yang amo. Kay yang sambok odumtan nan, aw yang sambok addatan nan. Yang sambok apangagadan nan, aw yang sambok osopakun nan. Magonawa sinyan, kong dakowa yang sapi sang kamayo pangatayan, na, di kamo makapangagad sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pagdungug sinyan ng mga Parisi, didigay-digay nilan si Isa kay silan tokgawan ng sapi. ");
INSERT INTO kqe_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ansinyan yagalaong kanilan si Isa, “Kamo, yagapakita-kita gaid kamo sang mga otaw na kamo madyaw, awgaid kyakatigaman ng Tohan yang kamayo pangatayan. Kay yang labi na dakowa sang pagtanaw ng otaw, way bili sang pagtanaw ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Yang Hokoman ni Nabi Mosa aw yang syosorat ng mga nabi pyagaindo sampay sang pagdatung ni Yahiya na Magsosogboway. Awgaid sikun sidto na wakto pyagaosiyat da yang Madyaw na Gogodanun makapantag sang pagdato ng Tohan aw madaig yang mga otaw na yamaningkamot magpasakop sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Awgaid wa yan magapasabot na waa day kapantag yang Hokoman. Kay amawaa pa yang langit aw yang lopa bago pa amawaa yang maskin sambok na pyaglaongan sang Hokoman. ");
INSERT INTO kqe_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Agaw di oman amaisab yang sogowan na yagalaong, ‘Sino-sino na usug na magabuag sang kanan asawa aw amangasawa ng tuna na bobay, magajina. Aw yang usug na amangasawa sidtong bobay na byubuagan, magajina oman.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ansinyan yagalaong oman si Isa, “Aon sapian na aag madyaw yang mga dagom nan aw matag allaw madaig aw masarap yang kanan pagkan. Madyaw sagaw yang kabutang nan. ");
INSERT INTO kqe_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aon oman miskinan na yang ngaan nan si Lasaro. Yang kanan lawas pono ng mga katul. Matag allaw dyadaa yan adto sang powertaan ng baay nidtong sapian na otaw ");
INSERT INTO kqe_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","kay kallini gao nan koman sang yamasama na pagkan sikun sang lamisa nan. Kallat sagaw ng kabutang nan kay maskin yang mga ido yodood kanan aw inilasan nilan yang mga katul nan. ");
INSERT INTO kqe_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na, ansinyan yamatay idtong miskinan aw dyadaa yan ng mga malaikat adto sang kilid ni Nabi Ibrahim adto sang sorga. Ansinyan yamatay oman idtong sapian aw lyulubung da yan. ");
INSERT INTO kqe_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Adto da yan adatung sang narka aw bali na kasikot nan. Pagingao nan, kikita nan adto sang mawat si Nabi Ibrahim aw si Lasaro ansang kilid nan. ");
INSERT INTO kqe_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ansinyan yamangiyak yan aw laong nan, ‘O kay Ompo Ibrahim, kallati ako! Tabiya, sogowa si Lasaro na tollokan nan sang tobig yang tollo nan aw patutudan nan yang kanak dila antak katignawan ako kay bali na kasikot ko sang kapaso sining atoon!’ ");
INSERT INTO kqe_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Awgaid tyomobag kanan si Nabi Ibrahim, ‘Dumduma, kay Itin, nang bowi pa kaw adto sang donya aag madyaw yang dyadawat mo. Awgaid si Lasaro, aag maat yang dyadawat nan. Awgaid adon, madyaw da yang kabutang nan adi, aw ikaw da yang kyakasikotan. ");
INSERT INTO kqe_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dogang pa san, aon maumay na aog na iyan ansang tunga natun. Maskin sino adi kanami na marim tomaripag adto kamayo, di makakadto. Aw way oman sikun adto kamayo na makataripag adi kanami.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ansinyan yagalaong yang sapian, ‘Kong maynan, kay Ompo, pangayoon ko kanmo na apadaa mo si Lasaro adto sang baay ng kanak ama. ");
INSERT INTO kqe_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kay aon mga lomon ko na limangka otaw na poros usug. Pakadtowa yan sang pagpakatigam kanilan antak di silan makasingani sining banwa ng kasikotan.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Awgaid yagalaong si Nabi Ibrahim, ‘Yang mga lomon mo, iyan kanilan yang mga Kitab na syosorat ni Nabi Mosa aw yang kadaigan pa na mga nabi. Dait na amaningug silan sang pyaglaongan nilan.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yagalaong oman yang sapian na otaw, ‘Di silan mangintoo kanilan, kay Ompo! Awgaid kong aon patay na amabowi oman aw makadto kanilan, na, magatawbat da silan sang mga dosa nilan.’ ");
INSERT INTO kqe_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Awgaid yagalaong si Nabi Ibrahim kanan, ‘Kong di silan amaningug kang Nabi Mosa aw sang kadaigan pa na mga nabi, di oman silan amangintoo maskin aon patay na amabowi oman aw makadto kanilan.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ansinyan yagalaong si Isa sang mga inindowan nan, “Bunna sagaw na aon mga satsat na madatung sang manosiya na amakadosa silan. Awgaid kallat sidtong otaw na yagadaa sang kadaigan sang kadosaan. ");
INSERT INTO kqe_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Madyaw pa kanan yang talian yang liyug nan ng dakowa na bato aw itimbag yan adto sang laod kaysang amainang yan ng pyagasabapan na amakadosa yang maskin sambok sining mga otaw na magonawa ng tagbi na mga isu. ");
INSERT INTO kqe_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Agaw timani mayo yang mga inang mayo. “Kong makadosa kanmo yang lomon mo, towadai yan. Aw kong magabasul yan sang dosa nan, ampona yan. ");
INSERT INTO kqe_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maskin makapito pa yan makadosa kanmo sa suud ng sangallaw aw makapito oman mangayo ng ampon, dait na amponon mo yan.” ");
INSERT INTO kqe_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ansinyan yanaglaong yang mga sahabat kang Isa, “Kay Dato, pakatigsuna yang kanami pagpangintoo!” ");
INSERT INTO kqe_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Awgaid yagalaong si Isa, “Kong aon pagpangintoo mayo na maskin tagbis na maynang katagbi da gaid ng liso ng mostasa, makapaglaong kamo sini na kaoy, ‘Ballin adto sang dagat,’ aw motoman yan kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sawpama aon sogowanun mo na yagadaro atawa yagabantay ng karniro. Na, pagori nan sikun sang kanan gawbuk, pagalaongon mo ba yan na, ‘Pagapas-apas, kay Itin, kan da sa?’ ");
INSERT INTO kqe_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Dili! Kondi magalaong kaw, ‘Pagilis aw andami ako ng pagkan. Tapos pagaya kanak taman sang matapos ako koman. Pagkatapos, makakan da kaw.’ ");
INSERT INTO kqe_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na, amanginsokor ba kaw sang kanmo sogowanun kay ininang nan yang pyagasogo mo kanan? Dili! ");
INSERT INTO kqe_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na, magonawa sinyan kamo. Kong yamainang da mayo yang kariko ng pyagasogo kamayo, magalaong da kamo, ‘Mga sogowanun gaid kami. Di kami dait bantogon kay ininang da gaid nami yang kawajib kanami inangun.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sang yagapasingadto si Isa sang Awrosalam yamagi yan sang tunga ng Samariya aw Jalil. ");
INSERT INTO kqe_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagdatung nan sang sambok na baryo, syosongon yan ng sampoo na kausgan na sanglaun. Yanagindug silan sang mawat-awat ");
INSERT INTO kqe_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aw yamangiyak silan, “O kay Isa, kay Dato! Kallati kami!” ");
INSERT INTO kqe_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkita kanilan ni Isa, yagalaong yan kanilan, “Kadto da kamo sang mga imam antak tanawon nilan yang lawas mayo.” Na, sang pagsingadto pa gaid nilan yamadyaw da silan. ");
INSERT INTO kqe_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Adon, pagkita ng sangka otaw kanilan na yamadyaw da yan, byomarik yan na yagapoji sang Tohan sang matanog na tingug. ");
INSERT INTO kqe_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ansinyan syomojod yan sang atobangan ni Isa aw yamanginsokor kanan. Na, yang idto na otaw taga Samariya aw dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ansinyan yagalaong si Isa, “Di ba sampoo na ka otaw yang yamadyaw? Na, wain da yang siyam? ");
INSERT INTO kqe_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nanga sa yaning otaw da gaid na dili ng Yahodi yang yabarik sang pagpanginsokor sang Tohan?” ");
INSERT INTO kqe_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ansinyan yagalaong si Isa sidtong otaw, “Pagindug, kay Itin, aw panaw da. Yamadyaw da kaw sabap sang pagpangintoo mo.” ");
INSERT INTO kqe_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Adon, aon mga Parisi na yagaosip kang Isa daw kinno pa magdato yang Tohan. Tyomobag si Isa, laong nan, “Yang pagdato ng Tohan di mayo amakita ng mata. ");
INSERT INTO kqe_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Way sino-sino na makapaglaong, ‘Tanawa, idi kay!’ atawa ‘Idto sidto!’ Kay yang Tohan magadato sang pangatayan mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ansinyan yagalaong yan sang mga inindowan nan, “Madatung yang wakto na karim mayo kimita kanak na Anak ng Manosiya na maskin sangallaw da gaid, awgaid di mayo ako makita. ");
INSERT INTO kqe_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aon magalaong kamayo na, ‘Tanawa, idto yan sidto!’ atawa ‘Tanawa, adi yan sidi!’ Awgaid ayaw kamo maningug kanilan atawa manganap kanak. ");
INSERT INTO kqe_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay magonawa sang kilat na yagasiga adto sang langit aw yagapaallag sinyan sikun sang silatan taman sang sallupan, maynan yang pagdatung ko na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Awgaid dait na amagi ako ona ng mga kasikotan aw ataripundaan ako ng mga otaw adon na panahon. ");
INSERT INTO kqe_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Na, yang ininang ng mga otaw sidtong wakto na mabarik ako na Anak ng Manosiya adi sang donya magonawa sang ininang ng mga otaw sang panahon ni Nabi Noh. ");
INSERT INTO kqe_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Way lain na kyakaridowan nilan yatabiya yang pagkan, paginum aw paginasawaay taman sidtong wakto na syomuud da si Nabi Noh sang dakowa na bangka. Na, pagdatung ng lunup, obos silan yamangkamatay. ");
INSERT INTO kqe_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Na, yang kabutang ng mga otaw sidtong wakto na mabarik ako magonawa oman sang kabutang ng mga otaw sang panahon ni Lot. Yanagpangan aw yanaginum silan, yanagbarigya aw yanagbili, yanagtanum aw yanagpaindug silan ng mga baay. ");
INSERT INTO kqe_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na, sidtong allaw pagpanaw ni Lot sikun sang syodad ng Sodom, yomowan ng atoon aw asopri sikun sang langit aw yang kariko ng mga otaw yamangkamatay. ");
INSERT INTO kqe_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Na, magonawa oman sinyan yang kabutang ng mga otaw sang wakto na mabarik ako na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sidto na wakto, yang otaw na adto sa logwa ng kanan baay, di da dait somuud antak makamang pa sang maskin ono na butang nan. Aw yang otaw na adto sang kanan pawa, di da dait mori pa sang baay nan. ");
INSERT INTO kqe_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dumduma mayo yang yamaitabo sang asawa ni Lot! ");
INSERT INTO kqe_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kay sino-sino na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid sino-sino na yang pyapalabi nan yang pagpangagad nan kanak maskin idto yang akamatay nan, akaonan ng bunna na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Pagalaong ko kamayo na sang allaw ng pagbarik ko, kong aon dowangka usug ansang kowangan ng gabi, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqe_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kong aon dowangka bobay na yagalubuk ng omay, akamangun yang isa aw amabilin yang isa. ");
INSERT INTO kqe_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aw kong aon dowangka otaw na yagagawbuk adto sang pawa, akamangun yang isa aw amabilin yang isa.” ");
INSERT INTO kqe_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ansinyan yagaosip kanan yang mga inindowan nan, “Kay Dato, wain yan amaitabo?” Tyomobag si Isa pinaagi sang pasombingay na yagalaong, “Daw wain yang patay, adto magatipon yang mga banog.” ");
INSERT INTO kqe_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ansinyan yagalaong si Isa ng pasombingay adto sang mga inindowan nan antak abay silan magdowaa aw di silan magondang. ");
INSERT INTO kqe_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Laong ni Isa, “Sang sambok na longsod aon howes na wa akalluk sang Tohan aw way pyagaaddatan nan na otaw. ");
INSERT INTO kqe_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Adon, aon oman sambok na biyoda disidtong longsod na yabay komadto sidtong howes na yagapakilooy kanan na tabangan nan sang kanan kaso. Laong nan, ‘Tabangi ako antak di ako daog-daogon ng kalaban ko.’ ");
INSERT INTO kqe_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Na, yamadogay na wa apaningug kanan yang howes. Awgaid sang kadogayan yagalaong yan sang ginawa nan, ‘Maskin wa ako akalluk sang Tohan aw way pyagaaddatan ko na otaw, ");
INSERT INTO kqe_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","awgaid sabap ng yabay ako samokon sining bobay, atabangan da ko gaid yan sang kanan kaso. Kay kong di ko yan tabangan, mabarik da oman yan adi kanak taman sang amasoya da ako.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ansinyan yagalaong si Isa, “Na, timani mayo yang pyaglaongan nidtong maat na howes. ");
INSERT INTO kqe_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kong yang maat na otaw matigam tomabang sang otaw na wa nan addati, na, yang Tohan pa, di ba nan atabangan yang mga otaw na pipili nan na yamangayo kanan ng tabang gabi aw allaw? Apakadogayun ba nan yang pagtabang nan kanilan? ");
INSERT INTO kqe_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pagalaong ko kamayo na atabangan nan silan ng mallug. Awgaid kong mabarik ako na Anak ng Manosiya adi sang donya, aon bay ikitaun ko na mga otaw na matigsun yang pagpangintoo nilan?” ");
INSERT INTO kqe_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Adon, adto sang mga otaw na yagadumdum na matorid silan aw dyadaog-daog nilan yang kadaigan yagalaong si Isa sini na pasombingay, ");
INSERT INTO kqe_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","laong nan, “Aon dowangka otaw na kyomadto sang Baay ng Tohan antak magdowaa. Yang sangka otaw Parisi aw yang sangka otaw mangobraay ng bowis. ");
INSERT INTO kqe_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Adto sang Baay ng Tohan imindug yang Parisi aw yagadowaa yan adto sang Tohan na yagabantog sang ginawa nan, laong nan, ‘Ya Tohan, yamanginsokor ako kanmo kay ako dili ng tokgawan ni limbongon, aw wa ako magajina na magonawa ng kadaigan. Yamanginsokor oman ako kanmo na dili ako maynidtong mangobraay ng bowis. ");
INSERT INTO kqe_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yagapowasa ako ng makadowa sang sangka simana aw yagajakat ako sikun sang kariko ng kanak sapi.’ ");
INSERT INTO kqe_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Awgaid yang mangobraay ng bowis yagaindug adto sang mawat-awat aw wa yan makaingao sang pagdowaa nan. Byobogbog nan yang kanan aba aw yagalaong yan, ‘Ya Tohan, kallati ako na baradosa.’ ");
INSERT INTO kqe_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na, pagalaong ko kamayo,” laong ni Isa, “na yani na otaw yang yomori na yampon da aw dyadawat yan ng Tohan na matorid aw dili nidtong Parisi. Kay sino-sino yang magapataas sang ginawa nan, apababaun aw yang magapababa sang ginawa nan, apataasun.” ");
INSERT INTO kqe_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Adon, aon mga otaw na yagadaa sang mangkatagbi na mga isu nilan adto kang Isa antak dapunan nan silan ng arima nan. Pagkita sinyan ng mga inindowan ni Isa, syasagda nilan yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Awgaid tyatawag ni Isa yang mga isu na modood kanan aw yagalaong yan sang mga inindowan nan, “Pasagdi mayo yang mga isu na modood kanak. Ayaw mayo silan pagbabagi kay yang mga otaw na main nilan yang amakasuud sang pyagadatowan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bunna yang pagalaong ko kamayo. Sino-sino yang di magapasakop sang pagdato ng Tohan na magonawa ng isu, di yan amakasuud sang pyagadatowan nan.” ");
INSERT INTO kqe_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ansinyan aon pangoo ng mga Yahodi na yagaosip kang Isa, “Kay Goro, yamatigam ako na ikaw madyaw. Ono yang dait ko inangun antak kaonan ako ng kinabowi na way kataposan?” ");
INSERT INTO kqe_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tyomobag si Isa kanan, “Nanga sa yagalaong kaw na ako madyaw? Way sino na madyaw yatabiya yang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kyakatigaman mo kowaw yang mga sogowan na yagalaong, ‘Ayaw magjina, ayaw magpatay, ayaw magpangawat, ayaw magsaksi ng bakak, aw addati yang kanmo ama aw ina.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tyomobag yang otaw, “Yang kariko sinyan tyotoman ko sikun pa sang pagkaisu ko.” ");
INSERT INTO kqe_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagdungug sinyan ni Isa, yagalaong yan kanan, “Isa pa yang dait mo inangun. Barigyaan yang kariko ng kanmo kabtangan aw yang alin atagan sang mga miskinan. Ansinyan akaonan kaw ng kakawasaan adto sang sorga. Pagkatapos, barik aw agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Awgaid pagdungug sinyan nidtong otaw, bali na karido nan kay madaig sagaw yang kakawasaan nan. ");
INSERT INTO kqe_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na, pagkita ni Isa na yamarido yan, yagalaong yan, “Mairap sagaw sang sapian na mga otaw pagpasakop sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Masayun pa sang kamil pagagi sang botas ng dagum kaysang otaw na sapian pagpasakop sang pagdato ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Adon, yang mga yamakadungug sinyan yagalaong, “Na, kong maynan, sino gaid yang amalowas?” ");
INSERT INTO kqe_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Awgaid yagalaong si Isa, “Yang di amainang ng manosiya, amainang ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ansinyan yagalaong si Pitros, “Na, monono da kami adon? Bibiyaan da nami yang kanami mga pamilya aw yamagad kami kanmo.” ");
INSERT INTO kqe_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Laong ni Isa kanilan, “Sang bunna-bunna pagalaong ko kamayo na sino-sino yang yagabiya sang kanan baay, sang asawa nan, sang mga lomon, taganak, atawa mga anak nan sabap sang pagpasakop sang pagdato ng Tohan, ");
INSERT INTO kqe_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","labaw pa sinyan yang amadawat nan adi sining donya, aw sang Allaw na Maori atagan yan ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ansinyan pyagalain ni Isa yang sampoo aw dowa na mga sahabat nan aw paglaonga nan silan, “Paningug kamo. Misingadto da kita sang Awrosalam aw ansinyan amatoman da yang kariko ng syosorat ng mga nabi makapantag kanak na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kay adaun nilan ako adto sang mga dili ng Yahodi. Digay-digayun nilan ako, pagainsoltoon aw otobadan. ");
INSERT INTO kqe_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Abadasan aw apatayun nilan ako. Awgaid sang ikatoong allaw amabowi oman ako.” ");
INSERT INTO kqe_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Awgaid yang mga inindowan nan wa makasabot sidto na pyaglaongan ni Isa. Yamatago pa kanilan yang mana sinyan, agaw wa silan akatigam daw ono yang karim nan ipasabot kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Adon nang masaid da si Isa sang longsod ng Ariha, aon bota na yagaingkod ansang kilid ng daan na yagapakilimos. ");
INSERT INTO kqe_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagdungug nan na madaig yang mga otaw na yalabay, yagaosip yan daw ono yan. ");
INSERT INTO kqe_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pyagalaong yan ng mga otaw, “Yalabay si Isa na taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagdungug nan sinyan, yamangiyak yan, “Kay Isa, Anak ni Daud, kallati ako!” ");
INSERT INTO kqe_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ansinyan syasagda yan ng mga otaw sang onaan antak magpakatingun. Awgaid labi da yang pagpangiyak nan, “Oy, Anak ni Daud, kallati ako!” ");
INSERT INTO kqe_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ansinyan yomondang si Isa aw pyagasogo nan na adaun kanan yang bota. Nang pyapadood da nilan, yosip yan ni Isa, ");
INSERT INTO kqe_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ono yang karim mo na inangun ko kanmo?” Tyomobag yang bota, “Kay Dato, karim ko makakita!” ");
INSERT INTO kqe_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ansinyan yagalaong si Isa kanan, “Na, makakita da kaw! Yamadyaw da kaw sabap sang pagpangintoo mo.” ");
INSERT INTO kqe_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ansinyan yakakita dayon yan aw yamagad kang Isa na yagapoji sang Tohan. Aw yang kariko ng mga otaw na yakakita sinyan yanagpoji oman sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ansinyan dyomatung si Isa sang longsod ng Ariha aw yamagi yan ansan. ");
INSERT INTO kqe_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ansidto na longsod aon pangoo ng mga mangobraay ng bowis na pyagangaanan ni Sakiyo. Yani si Sakiyo sapian na otaw. ");
INSERT INTO kqe_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Adon, sang yalabay da si Isa, magatanaw gao si Sakiyo daw sino yan. Awgaid sabap ng makagpa na otaw si Sakiyo wa yan makakita sabap sang kadaig ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Agaw yang ininang nan, dyomaagan yan sang onaan ng mga otaw aw pyomanik yan sang kaoy na sikomoro antak kitaun nan si Isa kay ansan yan malabay. ");
INSERT INTO kqe_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagdatung ni Isa sidto na kaoy, imingao yan aw yagalaong yan kang Sakiyo, “Apas-apas dosan pagkawas, kay Sakiyo, kay adon na allaw dait na adto ako pomanik sang kanmo baay.” ");
INSERT INTO kqe_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Agaw yomapas-apas komawas si Sakiyo aw pyagaagad nan si Isa adto sang baay nan na aon kasowat. ");
INSERT INTO kqe_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Adon, yang kariko ng mga otaw na yakakita kanilan yanagpatomod-tomod, laong nilan, “Nanga sa yani na otaw yakadto sang baay ng baradosa na otaw?” ");
INSERT INTO kqe_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na, adto sang baay imindug si Sakiyo aw yagalaong yan kang Isa, “Paningug kanak, kay Dato. Atag da ko yang katunga ng kanak kabtangan sang mga miskinan. Aw kong aon pyagalimbongan ko, ori ko kanan yang maskin makaopat pa!” ");
INSERT INTO kqe_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ansinyan yagalaong si Isa kanan, “Adon na allaw lyolowas da ng Tohan yani na pamilya kay yaning otaw topo oman ni Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kay ako na Anak ng Manosiya, yakani ako antak anapun aw lowasun ko yang mga otaw na mawat sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Adon, sarta yamaningug yang mga otaw sang pyaglaongan ni Isa, pyagalaong pa nan silan ng sambok na pasombingay. Ininang nan yani kay masaid da silan sang Awrosalam aw yagadumdum yang mga otaw na sinyan na wakto magasogod da magdato kanilan yang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Agaw, yagalaong si Isa, “Aon sambok na otaw na barabangsa na kyomadto sang mawat na banwa antak atagan yan adto ng kapatot pagsoltan kay antak pagori nan magadato da yan sang banwa nan. ");
INSERT INTO kqe_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Adon, sang wa pa yan apanaw, tyatawag nan yang sampoo na ka otaw na mga sogowanun nan aw pangatagi nan yang matag-isa ng tagsambok na sapi na bowawan aw laong nan, ‘Pagnegosyowan mayo yani sampay sang pagbarik ko.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Awgaid yani na otaw dyudumtan ng mga imamanwa nan. Agaw pagpanaw nan, yagapadaa silan ng mga otaw adto sidtong banwa na kyakadtowan nan antak maglaong silan na di silan marim na yani na otaw yang magadato kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Awgaid yamainang da yan na soltan aw yomori da yan antak magdato sang banwa nan. Pagori nan, pyapatawag dayon nan yang mga sogowanun nan antak tanawon nan daw pila yang yamaganansya nilan. ");
INSERT INTO kqe_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Yang yamakaona domatung yagalaong kanan, ‘Kay Dato, yang sambok na sapi na yatag mo kanak yakaganansya ng sampoo.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“ ‘Madyaw!’ laong ng amo nan. ‘Madyaw kaw na sogowanun. Sabap ng kasarigan kaw sang tagbi na butang, asarig ko kanmo yang pagdaa sang sampoo na mga syodad.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na, dyomatung da yang ikadowa na sogowanun aw maglaong, ‘Kay Dato, yang sapi na yatag mo kanak yakaganansya ng lima.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yagalaong yang amo sidto na sogowanun, ‘Kong maynan, magadaa da kaw sang limambok na syodad.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Na, dyomatung da oman yang sambok pa na sogowanun aw maglaong, ‘Kay Dato, idi kay yang kanmo sapi. Byabalot ko yan ng panyo aw tagowa ko. ");
INSERT INTO kqe_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yamalluk ako kanmo kay maisug kaw na otaw. Akamangun mo yang wa mo pagapagodi, aw aganiun mo yang wa mo atanuma.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yagalaong kanan yang amo nan, ‘Way poos mo na sogowanun! Kastigoon ta kaw magonawa sang pyaglaongan mo. Yamatigam kaw kadi na ako maisug, na akamangun ko yang wa ko pagapagodi aw aganiun ko yang wa ko atanuma? ");
INSERT INTO kqe_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, kong maynan, nanga sa wa mo ooga sang bangko yang kanak sapi kay antak pagbarik ko amakamang ko yang sapi ko na aon pay tobo?’ ");
INSERT INTO kqe_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ansinyan yagalaong yan sang mga otaw na yanagindug sang masaid kanilan, ‘Kamanga mayo yang sapi na iyan kanan aw atagan mayo sidtong sogowanun na aon kanan sampoo na sapi.’ ");
INSERT INTO kqe_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Awgaid yagalaong silan, ‘Kay Dato, aon day sampoo nan!’ ");
INSERT INTO kqe_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Yagalaong yang amo, ‘Pagalaong ko kamayo na sino-sino na kasarigan, atagan pa. Awgaid yang otaw na dili kasarigan, maskin yang tagbis na iyan kanan, akamangun pa kanan. ");
INSERT INTO kqe_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aw adon, idtong mga kalaban ko na wa akallini na ako yang magadato kanilan, daa mayo silan adi aw pataya mayo silan sang atobangan ko!’ ” ");
INSERT INTO kqe_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Paglaong sinyan ni Isa, pyomanaos yan adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nang masaid da silan sang mga baryo ng Bitpagi aw Bitani na adto sang Butay ng Jayton, pyapaona ni Isa yang dowangka otaw na mga inindowan nan ");
INSERT INTO kqe_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aw laong nan kanilan, “Kadto kamo sang baryo sang onaan. Pagsuud mayo aon makita mayo na nati ng asno na yukutan ansan na wa pa gaid akasakayi. Obadi mayo aw daa adi kanak. ");
INSERT INTO kqe_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kong aon magaosip kamayo daw onoon mayo yang asno, paglaonga mayo, ‘Kinaanglan yani ng kanami Dato.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ansinyan pyomanaw da idtong mga syosogo ni Isa aw pagdatung nilan sang baryo, kikita nilan yang asno sobay sang pyaglaongan kanilan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nang yagaobad da silan sang asno, yagalaong yang mga tagtomon kanilan, “Nanga sa yobadan mayo yang asno?” ");
INSERT INTO kqe_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tyomobag silan, “Kinaanglan yani ng kanami Dato.” ");
INSERT INTO kqe_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ansinyan dyadaa da nilan yang nati ng asno adto kang Isa, yampasan nilan ng mga dagom nilan aw pasakaya nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nang yagapanaos da si Isa na yakasakay sang asno, pyanagampas ng mga otaw yang mga dagom nilan ansang daan na agian nan silbi tanda sang pagbantog nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ansinyan nang masaid da si Isa sang Awrosalam aw pagtobang da nan sang daan sikun sang Butay ng Jayton, yamangkasowat yang kariko ng mga otaw na yamagad kanan. Yagasogod silan magpoji sang Tohan ng matanogay sabap sang kariko ng mga katingaan na kikita nilan. ");
INSERT INTO kqe_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yanaglaong silan, “Atagan gao ng kadyawan yaning soltan na syosogo ng Tohan! Adon akaonan kita ng kalinaw sikun sang sorga. Pojiun ta yang Tohan na Labi na Mabarakat!” ");
INSERT INTO kqe_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ansinyan aon mga Parisi ansang kadaig ng mga otaw na yagalaong kang Isa, “Kay Goro, sagdaa kono yang mga inindowan mo antak magpakatingun!” ");
INSERT INTO kqe_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tyomobag si Isa, “Pagalaong ko kamayo na kong magpakatingun silan, yang mga bato da yang magapoji kanak ng matanog.” ");
INSERT INTO kqe_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nang masaid da si Isa sang Awrosalam aw kikita da nan yang syodad, yagatiyao yan sabap sang pagkallat nan sang mga otaw disidto na syodad. ");
INSERT INTO kqe_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Laong nan, “Aw kyakatigaman pa gaid mayo adon na allaw daw ono yang makaatag kamayo ng kalinaw! Awgaid wa mayo akatigami. ");
INSERT INTO kqe_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Madatung sagaw yang wakto na osolongon aw asarikopan kamo ng mga kalaban mayo. Pagalupunan nilan yang kariko ng mga agianan mayo antak di da kamo makalogwa. ");
INSERT INTO kqe_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apatayun nilan kamo aw ogubaun nilan yang kamayo syodad na way maskin isa na bato na amabilin sang kyakabutangan nan. Yang kariko sinyan amaitabo kamayo kay wa mayo adawata yang Tohan pagdatung nan sang paglowas kamayo!” ");
INSERT INTO kqe_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ansinyan kyomadto si Isa sang Baay ng Tohan aw yagasogod yan magpalogwa sang mga yanagbarigya ansan. ");
INSERT INTO kqe_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Laong nan kanilan, “Yamakasorat sang Kitab na yagalaong yang Tohan, ‘Yang kanak baay atawagun ng Baay ng Pagdowaa.’ Awgaid ininang da mayo yan ng tagowanan ng mga tolisan!” ");
INSERT INTO kqe_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na, matag allaw yagaindo si Isa adto sang Baay ng Tohan. Awgaid yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman kipat sang mga pangoo sang banwa, yamanganap silan ng pamaagi sang pagpatay kanan. ");
INSERT INTO kqe_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Awgaid sidto na wakto way amainang nilan kay yang kariko ng mga otaw yamallini abay maningug sang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sangallaw disinyan yagaindo si Isa sang mga otaw adto sang Baay ng Tohan aw yagaosiyat yan ng Madyaw na Gogodanun. Ansinyan dyomood kanan yang mga pangoo ng mga imam, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga Yahodi ");
INSERT INTO kqe_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aw yagaosip silan kanan, “Paglaonga kami daw ono yang kapatot mo paginang sidto na mga butang. Sino yang yamatag kanmo sini na kapatot?” ");
INSERT INTO kqe_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tyomobag si Isa, “Aon oman osip ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wain magasikun yang kapatot ni Yahiya pagsogbo sang mga otaw, sang Tohan ba atawa sang manosiya?” ");
INSERT INTO kqe_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ansinyan yanagbaaw-baaw silan daw ono yang otobag nilan, laong nilan, “Kong magalaong kita ‘sikun sang Tohan,’ magalaong yan kanatun, ‘Na, nanga sa wa kamo apangintoo kanan?’ ");
INSERT INTO kqe_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Awgaid kong magalaong kita ‘sikun sang manosiya,’ na, abatoon da kita ng mga otaw kay yang kariko nilan yamangintoo na sambok na nabi si Yahiya!” ");
INSERT INTO kqe_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Agaw tyomobag silan, “Wa nami akatigami daw wain magasikun yang kapatot nan.” ");
INSERT INTO kqe_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ansinyan yagalaong si Isa kanilan, “Na, kong maynan, di ko oman kamo paglaongon daw wain magasikun yang kapatot ko paginang sidto na mga butang.” ");
INSERT INTO kqe_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ansinyan yagalaong si Isa sini na pasombingay adto sang mga otaw, laong nan, “Aon otaw na aon kanan lopa na pyagatanuman nan ng grips. Ansinyan pyapaatiman nan inyan sang mga sinarigan aw pyomanaw sang mawat na banwa. Yamadogay yan ansidto na banwa. ");
INSERT INTO kqe_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Adon, sang panahon ng pagpangipo da ng grips, syosogo ng tagtomon yang sangka otaw na sogowanun nan adto sang mga sinarigan antak kamangun nan yang kanan bain ng abot. Awgaid pagdatung nan sang tanumanan, byobonalan yan nidtong mga sinarigan aw pyapaori ng way daa. ");
INSERT INTO kqe_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ansinyan syosogo da oman ng tagtomon yang sambok pa na sogowanun adto kanilan, awgaid byobonalan da oman yan, pyapakasipugan pa aw pyapaori ng way daa. ");
INSERT INTO kqe_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ansinyan syosogo da oman ng tagtomon yang ikatoo pa na sogowanun. Na, pyaparian da oman nilan yan aw titimbag adto sa logwa ng tanumanan. ");
INSERT INTO kqe_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ansinyan yagalaong yang tagtomon sang ginawa nan, ‘Ono da adon yang inangun ko? Na, madyaw pa aw sogoon ko yang pyapasaya ko na anak kay basin addatan nilan yan.’ ");
INSERT INTO kqe_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Awgaid pagkita ng mga sinarigan sang anak ng tagtomon, yanagbaaw-baaw silan aw laong nilan, ‘Yan kay yang anak ng tagtomon na amangkun sining tanumanan. Apatayun ta yan antak kanatun da yaning kabilin kanan.’ ");
INSERT INTO kqe_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Idto sagaw, pyapalogwa nilan yan sang tanumanan aw pataya nilan. “Na,” yagalaong si Isa, “Ono da adon yang inangun ng tagtomon sidtong mga sinarigan? ");
INSERT INTO kqe_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sang way dowa-dowa na akadtowan nan aw apatayun nan silan aw apaatiman nan yang kanan tanumanan sang kadaigan pa na mga otaw.” Pagdungug sinyan ng mga otaw, yagalaong silan, “Di gao yan otogot ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ansinyan pyagatanawan silan ni Isa aw laong nan kanilan, “Na, ono kadi yang mana sang yamakasorat sang Kitab na yagalaong, “ ‘Yang bato na titimbag ng mga panday kay way kono kapantag, yamainang kadi ng labi na barapantag.’ ");
INSERT INTO kqe_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sino-sino yang amalogso sidto na bato, amatomba aw ansinyan waa day poos yang kinabowi nan. Awgaid madatung yang wakto na amaoog da yang idto na bato aw sino-sino yang akaoogan sinyan, di da gaid akatabangan.” ");
INSERT INTO kqe_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Adon, yang mga magiindoway ng Hokoman aw yang mga pangoo ng mga imam, karim gao nilan dakupun si Isa sinyan na wakto kay kyakatigaman nilan na silan yang kyukugdan ni Isa sini na pasombingay. Awgaid way amainang nilan kay yamalluk silan sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na, byabantayan da nilan si Isa ng madyaw kay yamanganap silan ng pamaagi na amadakup da nilan yan. Yang ininang nilan, yagabayad silan ng mga otaw na magasiling na madyaw silan aw sogowa nilan adto kang Isa. Awgaid yang toyo nilan na adakupun nilan si Isa sang pyaglaongan nan kay antak aon akapagoman nilan kanan adto sang gobirnador na taga Roma kay yan yang aon kapatot paghokom. ");
INSERT INTO kqe_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Adon yagalaong idtong mga otaw kang Isa, “Kay Goro, yamatigam kami na aag bunna yang pyagalaong aw pyagaindo mo. Di kaw magapili sang otaw, awgaid aag kabunnaan yang pyagaindo mo makapantag sang karim ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Adon, paglaonga kami daw sopak ba sang Hokoman na kita na mga Yahodi magbayad ng bowis adto sang soltan sang Roma atawa dili?” ");
INSERT INTO kqe_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Awgaid kyakatigaman ni Isa yang toyo nilan, agaw yagalaong yan, ");
INSERT INTO kqe_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitaan kanak yang sambok na sapi na pilak.” Pagatag kanan ng sapi, yagalaong oman yan, “Kanino parangay aw ngaan yang yakabutang sini?” Tyomobag silan, “Kanang soltan sang Roma.” ");
INSERT INTO kqe_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ansinyan yagalaong si Isa, “Na, kong maynan, atag mayo sang soltan yang kanang soltan, aw atag oman mayo sang Tohan yang kanang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na, wa silan makadakup kang Isa sang kanan pyaglaongan ansang atobangan ng mga otaw. Aw yanagpakatingun da gaid silan kay yamangkatingaa silan sang tobag nan. ");
INSERT INTO kqe_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ansinyan aon mga Sadoki na kyomadto kang Isa. Yani na mga otaw yagalaong na di amabowi oman yang mga patay. Yagaosip silan kang Isa, ");
INSERT INTO kqe_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kay Goro, yagasorat si Nabi Mosa sang Hokoman na kong amatay yang usug na way anak sang kanan asawa, dait na apangasawaun ng lomon nan yan na bobay antak kaonan silan ng anak para sang usug na yamatay da. ");
INSERT INTO kqe_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Adon, aon pito na maglomon na poros usug. Yamangasawa yang panganay aw yamatay na way anak. ");
INSERT INTO kqe_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Agaw pyapangasawa da ng mangod na yagasonod kanan inyan na biyoda, awgaid yamatay da oman yan na usug na way anak. ");
INSERT INTO kqe_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na, pyapangasawa da oman yan na bobay ng ikatoo taman sang ikapito na mangod. Awgaid obos silan yamatay na way anak. ");
INSERT INTO kqe_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sang kataposan, yamatay da oman yang bobay. ");
INSERT INTO kqe_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Adon, sang allaw ng pagkabowi oman ng mga patay, kanino asawa yan na bobay? Kay yang kariko ng pito na maglomon yakapangasawa kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tyomobag si Isa aw laong nan kanilan, “Adi sang donya amangasawa aw magabana yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Awgaid adto sang ahirat, yang mga otaw na tyatarima ng Tohan na dait silan bowiun sikun sang kamatay aw adaun adto sang sorga, di da silan amangasawa atawa magabana. ");
INSERT INTO kqe_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kay magonawa da silan sang mga malaikat na di amatay. Yamabaoy da silan na mga anak ng Tohan kay yamabowi oman silan sikun sang kamatay. ");
INSERT INTO kqe_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Awgaid makapantag sang pagkabowi oman ng mga patay, na, maskin si Nabi Mosa yamangimunna na amabowi oman yang mga patay. Kay yamakasorat sang Kitab Tawrat adto sang gogodanun makapantag sang tagbi na kaoy na yamallaga na tyatawag ni Nabi Mosa yang Tohan na ‘Tohan ni Ibrahim, ni Isahak aw ni Yakob.’ ");
INSERT INTO kqe_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Agaw yang Tohan, Tohan ng mga bowi aw dili ng mga patay kay adto kanan bowi yang kariko ng mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ansinyan yagalaong yang kadaigan ng mga magiindoway ng Hokoman, “Kay Goro, madyaw yang tobag mo.” ");
INSERT INTO kqe_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na, sikun sinyan waa day yamangisug magosip pa kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ansinyan yagaosip si Isa kanilan, “Nanga sa yagalaong yang mga otaw na yang Almasi topo ni Soltan Daud? ");
INSERT INTO kqe_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kay si Soltan Daud mismo yang yagalaong sang Kitab Jabor, “ ‘Yagalaong yang Tohan sang kanak Dato, “Pagingkod adi sang karinto ko ");
INSERT INTO kqe_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampay na ataloon ko yang mga kalaban mo aw amainang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqe_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, kong tyatawag ni Soltan Daud yang Almasi na kanan Dato,” laong ni Isa, “monono da na topo gaid yan ni Soltan Daud?” ");
INSERT INTO kqe_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sarta yamaningug pa kanan yang madaig na mga otaw, yagalaong si Isa sang mga inindowan nan, ");
INSERT INTO kqe_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pagbantay kamo sang mga magiindoway ng Hokoman kay kallini nilan mandagom ng joba antak silan addatan ng mga otaw. Aw adto sang palengke, karim nilan na asalamun silan ng mga otaw. Adto oman sang pagsasambayangan, karim nilan magingkod sang ingkodanan ng dakowa na mga otaw. Aw sang mga kandori, karim nilan magingkod sang ingkodanan ng mga otaw na dait addatan. ");
INSERT INTO kqe_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pyapakasikotan nilan yang mga biyoda antak maagaw nilan yang kanilan kakawasaan. Aw pataasun nilan yang pagdowaa nilan sang atobangan ng mga otaw antak magpakita silan na madyaw silan na mga otaw. Na, labi da yang siksa kanilan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sarta yagatanaw si Isa sang mga otaw adto sang Baay ng Tohan, kikita nan yang sapian na mga otaw na yagaoog ng sidoka nilan ansang butanganan ng sapi. ");
INSERT INTO kqe_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ansinyan aon oman kikita nan na sambok na biyoda na miskin na yagaatag ng dowambok gaid na sinsilyo. ");
INSERT INTO kqe_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ansinyan yagalaong si Isa, “Sang bunna-bunna pagalaong ko kamayo na yani na biyoda na miskin yagaatag ng labaw pa sidtong yatag ng kadaigan pa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay silan, yagaatag silan ng sapi sikun sang sobra nilan na kakawasaan. Awgaid yani na bobay, abir bali na kamiskin nan, yatag nan yang kariko ng kanan sapi.” ");
INSERT INTO kqe_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ansinyan aon pilangka otaw na mga inindowan ni Isa na yanagbaaw makapantag sang Baay ng Tohan na mangkadyaw yang mga bato na gyagamit sang paginang sinyan aw madyaw tanawon yang mga pyapangatag ng mga otaw. Awgaid yagalaong si Isa, ");
INSERT INTO kqe_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Taman sini na kikita mayo adon, madatung yang allaw na yang kariko sinyan amasapad. Way maskin sambok na bato na amabilin sang kyakabutangan nan kay obos silan apangkaya-kaya.” ");
INSERT INTO kqe_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ansinyan yanagosip silan kang Isa, “Kay Goro, kinno pa matoman yaning pyaglaongan mo? Aw ono yang tanda na magapakatigam kanami na mallug da amaitabo yang kariko sinyan?” ");
INSERT INTO kqe_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ansinyan yagalaong si Isa kanilan, “Pagbantay kamo antak di kamo kalimbongan ng maskin sino. Kay madaig yang mga otaw na madatung sang kanak ngaan aw magalaong silan na, ‘Ako yang Almasi,’ atawa ‘Dyomatung da yang kataposan ng donya.’ Awgaid ayaw kamo magagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aw pagdungug mayo na aon mga gira aw mga kasamok, ayaw kamo magkalluk. Kay dait na amaitabo ona yang kariko sinyan, awgaid dili pa yani yang kataposan ng donya.” ");
INSERT INTO kqe_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yagalaong oman si Isa, “Yang sambok na bangsa mapaglaban adto sang tuna na bangsa, aw yang sambok na pyagadatowan mapaglaban adto sang kadaigan. ");
INSERT INTO kqe_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Amaon yang makusug na mga linog, aw sang yagakatuna-tuna na mga banwa amaon yang gutum aw mga sakit na makatapon. Aw adto sang langit aon makita mayo na mga tanda na makallukay aw katingaan. ");
INSERT INTO kqe_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Awgaid sang wa pa yani akaitabo, apandakupun aw apakasikotan kamo. Adaun kamo adto sang pagsasambayangan ng mga Yahodi aw apamirisoon kamo. Sabap sang pagpangintoo mayo kanak adaun kamo adto sang mga gobirnador aw mga soltan. ");
INSERT INTO kqe_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aw ansinyan makapayapat kamo ng Madyaw na Gogodanun adto kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Agaw butangan mayo sang pangatayan mayo na di kamo amarido daw ono yang pagalaong mayo. ");
INSERT INTO kqe_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kay ako da yang magaatag kamayo ng katigam daw ono yang pagalaong mayo antak yang mga kalaban mayo di makasopak atawa makadaog kamayo. ");
INSERT INTO kqe_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Awgaid pagatraydoran kamo maskin ng kamayo mga taganak, mga kalomonan, kadogo aw mga kaupdanan mayo, aw yang kadaigan kamayo apapatay nilan. ");
INSERT INTO kqe_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aw odumtan kamo ng kariko ng mga otaw sabap sang pagpangagad mayo kanak. ");
INSERT INTO kqe_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Awgaid way maskin sambok na logay mayo na amawaa kong dili ng kahanda ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kong magapadayon kamo sang pagpangintoo mayo kanak sampay sang kataposan sini na mga kasikotan, akaonan kamo ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aw kitaun mayo yang Awrosalam na kyakasarikopan ng mga sondao, akatigaman mayo na mallug da yan masapad. ");
INSERT INTO kqe_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na, sinyan na wakto yang mga otaw na adto sang Yahodiya, dait silan domaagan adto sang kabtayan. Yang mga otaw na adto sang Awrosalam, dait silan lomogwa sikun sang syodad, aw yang mga otaw na adto sang pawa, di silan dait pakadtoon sang syodad. ");
INSERT INTO kqe_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kay dyomatung da yang wakto na isiksaun ng Tohan yang mga taga Awrosalam aw ansinyan amatoman da yang kariko ng yamakasorat sang Kitab makapantag sinyan. ");
INSERT INTO kqe_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pagdatung sinyan na mga allaw, kallat sidtong mga mabdus aw sidtong mga yagapasoso. Kay labi da yang kasikotan na madatung sini na banwa aw isiksaun da ng Tohan yang mga otaw na bangsa Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yang kadaigan kanilan apatayun ng ispada, aw yang kadaigan amadaa adto sang yagakatuna-tuna na mga banwa. Aw yang Awrosalam asapadan ng mga otaw na dili ng Yahodi aw silan da yang magadato sini na banwa sampay na madatung yang wakto na pyagakahanda kanilan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sang madatung na mga allaw aon amainang na mga tanda adto sang suga, sang bowan aw sang mga bitoon. Aw adi sang donya amangkarido yang mga bangsa aw amangkalluk silan pagdungug nilan sang makusug na tingug ng dagat aw pagkita nilan sang mangkadakowa na mga baud. ");
INSERT INTO kqe_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Akakoyapan yang mga otaw sabap sang alluk nilan kay yamarido silan daw ono yang amaitabo sang donya. Kay yang maskin ono na adto sang langit amagayung. ");
INSERT INTO kqe_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aw ansinyan makita nilan ako na Anak ng Manosiya na mabarik adi sang donya na pyagalibotan ng gabon na aon dakowa na kasiga aw kabarakat. ");
INSERT INTO kqe_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, kong kitaun da mayo na yagasogod da yani na mga pangitabo, pakatigsuna mayo yang pangatayan mayo kay mallug da domatung yang wakto na olowasun kamo ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ansinyan yagalaong kanilan si Isa sini na pasombingay, laong nan, “Tanawa mayo yang kaoy na igira aw yang kadaigan pa na mga kaoy. ");
INSERT INTO kqe_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aw kitaun mayo na yamanaringsing da silan, akatigaman mayo na masaid da yang panuga. ");
INSERT INTO kqe_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Magonawa sinyan, pagkita mayo na amainang da yang kariko sining pyagalaong ko kamayo, akatigaman da mayo na masaid da yang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sang bunna-bunna pagalaong ko kamayo na amatoman yang kariko sinyan sang di pa amangkamatay yang kariko ng mga otaw na yamangkabowi adon. ");
INSERT INTO kqe_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit aw lopa amawaa, awgaid yang pyaglaongan ko di amawaa taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pagbantay kamo na di mayo apasagdan yang ginawa mayo sang mga pakaradyaan aw yang paginum kipat sang pagkarido sang panginabowi mayo. Kay kong maynan, basin adatungan kamo sidto na allaw na mabarik ako na Anak ng Manosiya na wa kamo makabantay aw main da kamo ng kyakalitagan. ");
INSERT INTO kqe_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kay yan na allaw madatung sang kariko ng mga otaw adi sang babawan ng donya. ");
INSERT INTO kqe_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Agaw sagaw, abay kamo pagbantay aw abay kamo pagdowaa kay antak aon katigsun mayo aw di kamo amaono sang madatung na mga pangitabo aw way kasipug mayo kong amatobang da kamo kanak na Anak ng Manosiya.” ");
INSERT INTO kqe_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na, kada allaw yagaindo si Isa adto sang Baay ng Tohan. Awgaid kada gabi yakadto yan sang Butay ng Jayton aw adto yan katoog. ");
INSERT INTO kqe_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aw pagkaamdagay pa, yakadto yang mga otaw sang Baay ng Tohan antak maningug kanan. ");
INSERT INTO kqe_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ansinyan masaid da yang Pakaradyaan ng Pan na way Labadora na tyatawag oman ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Adon, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman, yanagbaaw-baaw silan daw monono yang pagpatay kang Isa na di akatigaman ng mga otaw kay yamalluk silan kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ansinyan yosuudan da si Yodas ni Iblis. Yani si Yodas na tyatawag na Iskariyot, isa sang sampoo aw dowa na mga sahabat ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Agaw pyomanaw da si Yodas kay mapagbaaw yan sang mga pangoo ng mga imam kipat sang mga pangoo ng mga gowardya sang Baay ng Tohan daw monono yang pagtraydor nan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na, yamangkasowat da silan aw yanagkaoyon silan na abayadan si Yodas. ");
INSERT INTO kqe_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yosogot oman si Yodas, aw sikun sinyan yamanganap yan ng wakto na madyaw ipadakup kanilan si Isa na way abay otaw na makakita. ");
INSERT INTO kqe_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ansinyan dyomatung da yang allaw ng Pakaradyaan ng Pan na way Labadora na yani yang allaw na dait sobariun yang mga karniro para sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Agaw syosogo ni Isa si Pitros aw si Yahiya aw laong nan kanilan, “Panaw da kamo aw andama mayo yang kanatun pagkan para sang Pakaradyaan ng Paglabay.” ");
INSERT INTO kqe_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ansinyan yagaosip silan kanan, “Wain yang karim mo na andamun nami yang kandori?” ");
INSERT INTO kqe_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tyomobag si Isa, “Pagsuud mayo sang syodad, aon masongon mayo na otaw na yagapusan ng banga ng tobig. Agad kamo kanan sang apanikan nan na baay ");
INSERT INTO kqe_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aw paglaonga mayo yang tagtomon sidtong baay na, ‘Yagaosip yang goro nami daw wain kono na kowarto yan makakan sang kandori sang Pakaradyaan ng Paglabay upud sang mga inindowan nan.’ ");
INSERT INTO kqe_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ansinyan apakita nan kamayo yang dakowa na kowarto adto sa taas ng baay na yandam da dadaan. Adto da mayo andama yang kanatun pagkan sang kandori.” ");
INSERT INTO kqe_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ansinyan pyomanaw da silan aw yamatoman yang kariko ng pyaglaongan kanilan ni Isa. Aw pyagaandam da nilan yang pagkan para sang kandori. ");
INSERT INTO kqe_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na, pagdatung ng wakto ng kandori, imingkod da si Isa sang lamisa upud sang mga sahabat nan. ");
INSERT INTO kqe_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ansinyan yagalaong yan kanilan, “Dakowa yang karim ko magupud kamayo sang kandori sining Pakaradyaan ng Paglabay sang di pa ako amagi ng kasikotan. ");
INSERT INTO kqe_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kay pagalaong ko kamayo na di da ako makan sinyan sampay sang wakto na amatoman da yang katoyowan sini na pakaradyaan adto sang pyagadatowan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ansinyan kyomamang si Isa ng inmanan aw pagkatapos manginsokor sang Tohan yagalaong yan kanilan, “Dawata mayo yani aw inuma mayo. ");
INSERT INTO kqe_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pagalaong ko kamayo na sikun adon di da ako iminum sang tumuk ng grips sampay sang wakto na magadato da yang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ansinyan kyomamang oman yan ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan yang pan aw atagan sang mga sahabat nan aw laong nan, “Yani yang kanak lawas na yatag para kamayo. Kana mayo yaning pan aw inanga mayo yani sang pagdumdum kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Magonawa oman sinyan pagkatapos nilan koman, yatag nan kanilan yang inmanan aw laong nan, “Yang lasak sining inmanan yang bago na pamaagi na pyapasad ng Tohan antak mainang kamo ng mga otaw na sakop nan. Yang kanak dogo na moboos para kamayo magaatag ng kasigorowan sining pyagapasadan. ");
INSERT INTO kqe_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Awgaid adon yagaupud kanak adi sang lamisa yang magatraydor kanak. ");
INSERT INTO kqe_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Amatay ako na Anak ng Manosiya magonawa sang pyagakahanda kanak ng Tohan. Awgaid kallat sidtong otaw na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ansinyan yanaginosipay yang mga sahabat daw sino kanilan yang magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ansinyan yanaglalis yang mga sahabat daw sino kanilan yang labaw. ");
INSERT INTO kqe_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Awgaid yagalaong si Isa kanilan, “Yang mga soltan sang yagakatuna-tuna na bangsa yagamando sang mga sakop nilan. Aw yang aon kapatot, karim nilan na matawag silan na ‘Maloyanun na Pangoo’. ");
INSERT INTO kqe_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Awgaid dili ng maynan adi kamayo. Kay yang labaw kamayo dait masiling ng kimod mayo, aw yang pangoo dait masiling ng sogowanun mayo. ");
INSERT INTO kqe_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sino kadi yang labaw? Yang yagaingkod sang pagkan atawa yang yagaaya kanan? Di ba idtong yagaingkod sang pagkan? Awgaid ako, idi ako kamayo na yamasiling ng sogowanun mayo. ");
INSERT INTO kqe_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kamo yang yamagad kanak sang kariko ng kasikotan na yaagian ko. ");
INSERT INTO kqe_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agaw atagan ta kamo ng kapatot pagdato na magonawa sang kapatot na yatag kanak ng kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Amakaupud kamo kanak sang kandori adto sang pyagadatowan ko aw makaingkod kamo sang pagdato sang sampoo aw dowa na mga tribo ng Israil.” ");
INSERT INTO kqe_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ansinyan yagalaong si Isa kang Pitros, “Kay Simon, paningug kanak! Tyotogotan ng Tohan si Iblis pagtigi sang kariko mayo. Yang pagsatsat nan kamayo magonawa sang pagtaap ng omay antak makamang yang tipig. ");
INSERT INTO kqe_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bunna sagaw na magatarikod kaw kanak, awgaid yagadowaa da ako para kanmo na di amawaa yang pagpangintoo mo. Aw pagbarik da mo oman kanak, pakatigsuna yang pagpangintoo ng mga kalomonan mo.” ");
INSERT INTO kqe_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yagalaong si Pitros, “Kay Dato, di ako magatarikod kanmo. Andam ako na amapiriso atawa amatay upud kanmo.” ");
INSERT INTO kqe_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Awgaid yagalaong si Isa, “Pagalaong ko kanmo, kay Pitros, sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw ikilaa kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ansinyan yosip ni Isa yang mga sahabat nan, laong nan, “Nanganing syosogo ta kamo sang pagpayapat na way daa mayo na sapi, lasakanan atawa sandalyas, aon bay yamakolang kamayo?” Laong nilan, “Waa!” ");
INSERT INTO kqe_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Awgaid adon,” laong ni Isa, “daw sino yang aon pitaka atawa lasakanan, dait na adaun nan. Aw yang way lodyo, dait na abarigya nan yang kanan dagom antak makabili yan ng lodyo. ");
INSERT INTO kqe_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kay pagalaong ko kamayo na dait amatoman yaning yamakasorat sang Kitab makapantag kanak na yagalaong, ‘Yamabilang yan sang mga darowaka.’ Na, bunna sagaw na masaid da yang pagtoman sang yamakasorat makapantag kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ansinyan yagalaong yang mga sahabat nan, “Tanawa, kay Dato, aon disini dowambok na lodyo.” Tyomobag si Isa, “Osto da yan.” ");
INSERT INTO kqe_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ansinyan pyomanaw si Isa sikun sang Awrosalam aw kyomadto yan sang Butay ng Jayton magonawa sang kyakaanadan nan. Aw yamagad kanan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdatung nilan ansan, yagalaong yan kanilan, “Pagdowaa kamo antak di kamo madaa ng satsat.” ");
INSERT INTO kqe_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ansinyan kyomadto yan sang mawat-awat kanilan, yolood yan aw magdowaa. ");
INSERT INTO kqe_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Laong nan, “O kay Ama, kong karim mo, ayaw ako paagia sini na kasikotan, awgaid dili ng karim ko yang amatoman kondi yang karim mo.” ");
INSERT INTO kqe_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ansinyan aon malaikat sikun sang sorga na yagapakita kanan aw yagapakatigsun kanan. ");
INSERT INTO kqe_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sabap sang labi na pagkarido ng ginawa nan yagadowaa yan ng waa day main da nan sampay na yowasan yan ng maynang dogo na yamanagdo sang lopa. ");
INSERT INTO kqe_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkatapos nan magdowaa, byomarik yan sang mga inindowan nan aw yadatungan nan silan na yamangkatoog sabap ng dakowa oman yang karido nilan. ");
INSERT INTO kqe_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ansinyan pyopokaw nan silan aw yagalaong yan kanilan, “Nanga sa yamangkatoog kamo? Bangon da kamo aw pagdowaa antak di kamo madaa ng satsat.” ");
INSERT INTO kqe_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nang yagatiyab pa si Isa, dyomatung yang madaig na mga otaw. Si Yodas na sambok sang sampoo aw dowa na mga sahabat yang yagaona kanilan. Ansinyan dyomood yan kang Isa sang pagauk kanan. ");
INSERT INTO kqe_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Awgaid yagalaong kanan si Isa, “Kay Yodas, pagatraydoran mo ako na Anak ng Manosiya pinaagi sang auk?” ");
INSERT INTO kqe_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagkita sinyan ng mga kaupdanan ni Isa, yanaglaong silan, “Kay Dato, itibasun da nami silan?” ");
INSERT INTO kqe_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na, titibas da ng sambok na inindowan yang sogowanun ng Dakowa na Imam aw yamapotol yang karinto na taringa nan. ");
INSERT INTO kqe_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Awgaid yagalaong si Isa, “Osto da yan!” Ansinyan kyukuputan nan yang taringa sinyan na otaw aw pakadyawa nan. ");
INSERT INTO kqe_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ansinyan yagalaong si Isa sang mga pangoo ng mga imam, sang mga pangoo ng mga gowardya sang Baay ng Tohan kipat sang mga pangoo ng mga Yahodi na dyomatung sang pagdakup kanan, laong nan, “Ono, tolisan ba ako na kinaanglan kamo magdaa ng mga lodyo aw bobonal? ");
INSERT INTO kqe_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kada allaw adto ako sang Baay ng Tohan aw adto oman kamo, awgaid wa mayo ako adakupa. Awgaid yani adon yang wakto na yatag kamayo aw wakto oman na yagadato si Iblis na iyan sang kaduguuman.” ");
INSERT INTO kqe_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ansinyan dyadakup nilan si Isa aw daa nilan adto sang baay ng Dakowa na Imam. Adon si Pitros, yosonod yan kanilan sang mawat-awat. ");
INSERT INTO kqe_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Awgaid pagdook ng mga gowardya ng atoon ansang tunga ng pamanag sidtong baay aw pagingkod nilan sang palibot sinyan antak kapasowan silan, dyomood oman si Pitros aw imingkod upud kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ansinyan aon sambok na sogowanun na bobay na yakakita kang Pitros na yagaingkod sang masaid sang atoon. Pyapakatanawan nan si Pitros aw yagalaong yan, “Yani na otaw, inagad ni Isa.” ");
INSERT INTO kqe_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Awgaid yagadili si Pitros, “Kay Bodi, wa ako ikilaa kanan.” ");
INSERT INTO kqe_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pagkatugun-tugun disinyan aon oman yakakita kanan na otaw aw laong nan, “Ikaw, kaupdanan oman nilan.” Awgaid yagalaong si Pitros, “Kay Itin, dili!” ");
INSERT INTO kqe_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mga sangka oras disinyan aon oman otaw na yagalaong, “Bunna sagaw na yani na otaw inagad ni Isa kay taga Jalil oman yan.” ");
INSERT INTO kqe_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Awgaid yagalaong si Pitros, “Kay Itin, way gindawan ko sang pyagalaong mo!” Na, sinyan na wakto nang yagatiyab pa yan, yagatagaok yang laboyo. ");
INSERT INTO kqe_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ansinyan ilingi si Isa aw pyapakatanawan nan si Pitros. Ansinyan kyakadumduman ni Pitros yang pyagalaong kanan ni Isa na laong nan, “Sang di pa magatagaok yang laboyo adon na gabi, makatoo kaw maglaong na wa kaw ikilaa kanak.” ");
INSERT INTO kqe_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na, lyomogwa da si Pitros aw bali na pagtiyao nan. ");
INSERT INTO kqe_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ansinyan didigay-digay si Isa ng mga otaw na yagabantay kanan aw byobonalan nilan yan. ");
INSERT INTO kqe_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tyatabonan nilan yang mata ni Isa aw paglaonga nilan, “Tagnaa kono daw sino yang yagasontok kanmo!” ");
INSERT INTO kqe_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aw madaig pa yang mga insolto na pyagalaong nilan adto kanan. ");
INSERT INTO kqe_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkailaw disinyan yanagkatipon yang mga pangoo ng mga Yahodi, yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman. Silan yang mga opisyales ng Makagwas na Hokmanan. Na, ansinyan dyadaa si Isa sang atobangan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Laong nilan kang Isa, “Paglaonga kami daw ikaw yang Almasi.” Tyomobag si Isa aw laong nan, “Aw paglaongon ta kamo, di kamo mangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aw osipun ta kamo, di oman kamo motobag. ");
INSERT INTO kqe_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Awgaid sikun adon, ako na Anak ng Manosiya, magaingkod da ako apit sang karinto ng Tohan na Labi na Mabarakat.” ");
INSERT INTO kqe_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yanagosip da yang kariko nilan, “Kong maynan, ikaw agaw yang Anak ng Tohan?” Tyomobag si Isa aw laong nan kanilan, “Yan agaw yang pyagalaong mayo.” ");
INSERT INTO kqe_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ansinyan yanaglaong silan, “Di da kita kinaanglan ng kadaigan pa na saksi! Kita da mismo yang yamakadungug sang pyaglaongan nan!” ");
INSERT INTO kqe_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ansinyan imindug yang kariko ng mga opisyales aw dyadaa nilan si Isa adto kang Pilato, yang gobirnador na taga Roma. ");
INSERT INTO kqe_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na, yagasogod da silan magoman kang Isa, laong nilan, “Kyakasakpan nami yani na otaw na yagasamok sang kapagonawa nami na mga Yahodi kay pyagalaong nan silan na di magbayad ng bowis adto sang soltan sang Roma. Aw yagalaong pa yan na yan kono yang Almasi, yang pyapasad ng Tohan na magasoltan kanami.” ");
INSERT INTO kqe_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Agaw yagaosip si Pilato kang Isa, “Ikaw ba yang soltan ng mga Yahodi?” Tyomobag si Isa, “Yan agaw yang pyagalaong mo.” ");
INSERT INTO kqe_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ansinyan yagalaong si Pilato sang mga pangoo ng mga imam aw sang mga otaw ansan, “Way kikita ko na dosa sini na otaw na dait yan hokoman.” ");
INSERT INTO kqe_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Awgaid yagapadayon silan magakosar kanan, laong nilan, “Yagakasamok yang mga otaw sang tibok Yahodiya sabap sang pagindo nan. Yagasogod yan magindo sang probinsya ng Jalil aw adon dyomatung da yan adi sang Awrosalam.” ");
INSERT INTO kqe_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagdungug sinyan ni Pilato, yagaosip yan, “Taga Jalil ba yani na otaw?” ");
INSERT INTO kqe_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na, pagkatigam ni Pilato na si Isa sikun sang probinsya na sakop ni Hirod, pyapadaa nan yan adto kang Hirod kay sidto na wakto iyan oman si Hirod sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na, pagkita ni Hirod kang Isa, dakowa yang kasowat nan kay dogay da karim nan kimita kang Isa. Madaig yang dyudungug nan makapantag kanan aw kallini nan kitaun na magainang yan ng katingaan. ");
INSERT INTO kqe_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Agaw madaig yang osip nan kang Isa, awgaid wa yan otobag kanan. ");
INSERT INTO kqe_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ansinyan dyomood yang mga pangoo ng mga imam aw yang mga magiindoway ng Hokoman aw maskin ono da yang pyagaoman nilan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ansinyan didigay-digay si Isa ni Hirod kipat sang mga sondao nan aw ininsolto nilan yan. Pyapandagoman nilan si Isa ng madyaway na joba na maynang dagom ng soltan aw pyapabarik nilan adto kang Pilato. ");
INSERT INTO kqe_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, sinyan na allaw yagakadyaw si Pilato aw si Hirod na dati magkalaban silan. ");
INSERT INTO kqe_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ansinyan pyapatawag ni Pilato yang mga imam, yang mga pangoo aw yang kadaigan pa na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Laong nan kanilan, “Dyadaa mayo adi kanak yani na otaw aw yagalaong kamo na yan kono yagasamok sang mga otaw. Na, pyagaimbistigar ko yan adi sang atobangan mayo aw way kikita ko na dosa nan na magonawa sang pyagalaong mayo. ");
INSERT INTO kqe_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Si Hirod oman, way kikita nan na dosa sini na otaw. Idto sagaw, pyapabarik nan adi kanatun. Na, way ininang sini na otaw na dait nan akamatay. ");
INSERT INTO kqe_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Agaw, apabadasan da ko gaid yan aw obooyan da ko.” ");
INSERT INTO kqe_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na, idto yang pyagalaong ni Pilato kay matag Pakaradyaan ng Paglabay yang kyakaanadan ng gobirnador na obooyan nan yang sangka otaw na yamapiriso. ");
INSERT INTO kqe_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Awgaid yagadungan mangiyak yang kariko ng mga otaw, laong nilan, “Pataya yan na otaw! Booi kanami si Barabas!” ");
INSERT INTO kqe_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yani si Barabas, yamapiriso yan sabap ng yamakaapil yan sang paglaban sang gobirno na ininang sangaon sang Awrosalam aw yakapatay yan ng otaw. ");
INSERT INTO kqe_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na, karim gao ni Pilato na obooyan si Isa, agaw yapagbaaw da oman yan sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Awgaid yamangiyak silan, “Alansang yan sang kros! Alansang yan sang kros!” ");
INSERT INTO kqe_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na, ikatoo da maglaong kanilan si Pilato, laong nan, “Nanga sa? Ono yang dosa na ininang nan? Way kikita ko na dosa na dait nan akamatay. Apabadasan da ko gaid yan aw obooyan da ko!” ");
INSERT INTO kqe_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Awgaid yagapadayon silan mangiyak ng matanog na si Isa apalansang sang kros. Aw sang orian yamatoman da yang karim nilan. ");
INSERT INTO kqe_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Agaw, yokoman da ni Pilato si Isa magonawa sang pyapangayo ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Byobooyan nan yang otaw na yamapiriso sabap sang paglaban sang gobirno aw pagpatay kay yan yang pyapangayo ng mga otaw. Awgaid si Isa, yatag nan kanilan antak inangun nilan kanan yang karim nilan. ");
INSERT INTO kqe_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ansinyan dyadaa si Isa ng mga sondao adto sa logwa ng syodad. Sarta yagapanaw silan, aon syosongon nilan na otaw na pyagangaanan ni Simon na taga Kirini. Sikun yan sang baryo aw yagapasingadto sang syodad ng Awrosalam. Bibira yan ng mga sondao aw pyapapusan nilan kanan yang kaoy na pagalansangan kang Isa aw pyapasonod nilan yan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adon, madaig yang mga otaw na yamagad kang Isa upud sang mga bobay na yanagtiyao aw yanagminatay sabap kanan. ");
INSERT INTO kqe_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ansinyan ilingi si Isa kanilan aw laong nan, “Mga kaobayan ng Awrosalam, ayaw kamo magtiyao sabap kanak. Awgaid pagtiyaowi mayo yang ginawa mayo aw yang mga anak mayo. ");
INSERT INTO kqe_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kay madatung yang wakto na magalaong yang mga otaw, ‘Kadyaw ng ginawa sidtong mga bobay na di makaanak, aw yang mga bobay na way anak aw wa magapasoso!’ ");
INSERT INTO kqe_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aw sidto na wakto magalaong yang mga otaw sang mga butay, ‘Taboni kami antak kami matay!’ ");
INSERT INTO kqe_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na, kong maynan yang amainang sang otaw na way dosa, labi da yang siksa sidtong mga otaw na yamakadosa.” ");
INSERT INTO kqe_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Adon, aon oman dowangka otaw na mga darowaka na dyadaa nilan antak silan patayun upud kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagdatung nilan sang logar na tyatawag ng Oo ng Kalabira, lyalansang nilan si Isa sang kros kipat sidtong dowangka otaw, yang sambok sang karinto ni Isa aw yang sambok sang kawaa nan. ");
INSERT INTO kqe_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Adon yagalaong si Isa, “O kay Ama, ampona silan kay wa silan akatigam daw ono yang ininang nilan.” Ansinyan yanagripa yang mga sondao antak bainun nilan yang mga dagom ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na, yang mga otaw yanagindug ansan aw yanagtanaw sarta didigay-digay si Isa ng mga pangoo ng mga Yahodi. Laong nilan, “Tyatabangan nan yang kadaigan. Tanawon ta adon daw makalowas yan sang ginawa nan, daw bunna na yan yang Almasi, yang pipili ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na, maskin yang mga sondao yanagdigay-digay kanan. Dyomood silan kang Isa aw pyapainum nilan yan ng aslum na bino. ");
INSERT INTO kqe_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aw yagalaong silan, “Lowasa yang ginawa mo kong bunna na ikaw yang soltan ng mga Yahodi!” ");
INSERT INTO kqe_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Adto sa taas ng oo ni Isa aon yamakasorat na yagalaong, “Yani yang Soltan ng mga Yahodi.” ");
INSERT INTO kqe_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ansinyan yang sangka otaw na darowaka na lyalansang oman ansan, ininsolto nan si Isa, laong nan, “Di ba ikaw yang Almasi? Na, lowasa yang sarili mo aw lowasa oman kami!” ");
INSERT INTO kqe_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Awgaid kyakadamanan yan ng kaupdanan nan, laong nan, “Wa kaw akalluk sang Tohan na yokoman da kaw na magonawa kanan? ");
INSERT INTO kqe_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Awgaid kita dowa, dait kita kastigoon sabap sang maat na ininang ta. Awgaid yani na otaw, way dosa nan.” ");
INSERT INTO kqe_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aw yagalaong yan kang Isa, “Dumduma ako, kay Isa, kong magadato da kaw.” ");
INSERT INTO kqe_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ansinyan yagalaong si Isa kanan, “Sang bunna-bunna pagalaong ko kanmo na adon na allaw amakaupud kaw kanak adto sang sorga.” ");
INSERT INTO kqe_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Adon, pagkaalas dose ng suga yagakaduguum yang tibok banwa taman ng alas tres ng gabila. ");
INSERT INTO kqe_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sidto na mga wakto wa magasiga yang suga. Aw yang madakmul na kortina na adto sang Baay ng Tohan yamalasi aw yamatunga sang dowa. ");
INSERT INTO kqe_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ansinyan yamangiyak si Isa ng matanog, laong nan, “Kay Ama, atag da ko kanmo yang kanak nyawa!” Aw paglaong nan sinyan, yamabogto da yang napas nan. ");
INSERT INTO kqe_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Adon, yang kapitan ng mga sondao na yakakita sidtong yamaitabo, pyopoji nan yang Tohan aw laong nan, “Bunna sagaw na yani na otaw way dosa!” ");
INSERT INTO kqe_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aw yang kariko ng mga otaw na yakakita sidtong yamaitabo yanagpangori na byobogbog nilan yang kanilan aba sabap ng kyakasakitan yang ginawa nilan. ");
INSERT INTO kqe_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Awgaid yang kariko ng ikilaa kang Isa upud sidtong mga bobay na yamagad kanan sikun pa sang Jalil, yanagindug silan adto sang mawat aw yanagtanaw silan. ");
INSERT INTO kqe_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Adon, aon sambok na otaw na pyagangaanan ni Yosop na taga Arimatiya na sambok na longsod sang Yahodiya. Yani si Yosop madyaw na otaw aw matorid yang ininang nan aw yagatagad yan sang wakto na magadato da yang Tohan. Maskin opisyal yan sang Makagwas na Hokmanan, wa yan makaoyon sang paghokom aw pagpatay ng mga kaupdanan nan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na, yani si Yosop kyomadto kang Pilato aw pyapangayo nan yang patay na lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pagkatapos sinyan kyakamang nan yang lawas ni Isa aw byabalot nan ng mapoti aw butangan nan sang kobor na pyagalongagan sang bato. Yani na kobor wa pa okobori. ");
INSERT INTO kqe_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na, sidto na allaw Jomaat na allaw ng pagpangandam para sang Allaw ng Pagpatana na masaid da magsogod. ");
INSERT INTO kqe_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Adon, yang kaobayan na yagasikun sang Jalil upud kang Isa yamagad kang Yosop aw kikita nilan yang kobor aw monono yang pagbutang ansan ng lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ansinyan yomori da silan aw yanagandam silan ng mga paballo para sang patay. Awgaid sang Allaw ng Pagpatana yagapatana silan sobay sang sogowan ng agama Yahodi. ");
INSERT INTO kqe_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Adon, pagkaamdagay pa sang allaw ng Domingo kyomadto yang idto na mga bobay sang kobor na yagadaa ng mga paballo na pyagaandam nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagdatung nilan adto, kikita nilan na yamaligid da yang bato sikun sang baba ng kobor. ");
INSERT INTO kqe_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Agaw syomuud silan, awgaid waa da don yang patay na lawas ni Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sarta yanagindug silan adto sa suud na yamangkatingaa, sakadyap aon dowangka otaw na imindug sang masaid kanilan na labi na mabislaw yang mga dagom nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ansinyan yamalluk yang mga bobay aw syomojod silan sang lopa. Awgaid yagalaong kanilan idtong mga otaw, “Nanga sa yanap mayo yang bowi sang mga patay? ");
INSERT INTO kqe_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa da yan adi kay yamabowi oman yan! Dumduma mayo yang pyaglaongan nan kamayo nang idto pa yan sang Jalil na ");
INSERT INTO kqe_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","laong nan, ‘Ako na Anak ng Manosiya, dait na adaun ako adto sang mga baradosa aw alansang ako sang kros. Awgaid sang ikatoong allaw amabowi oman ako.’ ” ");
INSERT INTO kqe_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ansinyan kyakadumduman da ng mga bobay idtong pyaglaongan kanilan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na, pagori nilan sikun sang kobor, gyogogod nilan yang kariko sinyan adto sang sampoo aw isa na mga sahabat ni Isa kipat sang kadaigan pa na mga kaupdanan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na, yang idto na mga bobay si Mariyam na taga Magdala, si Yowana aw si Mariyam na ina ni Yakob. Silan aw yang kadaigan pa na mga kaobayan yang yagagogod sinyan sang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Awgaid pagtoo ng mga sahabat na yagapataka gaid maglaong yang mga kaobayan, agaw wa silan apangintoo kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Awgaid si Pitros, imindug yan aw daagan adto sang kobor. Pagdatung nan adto, isilib yan sang kobor aw way kikita nan yatabiya sidtong sapot. Ansinyan yomori yan na yamatingaa sidtong yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sinyan na allaw aon dowangka otaw na inindowan ni Isa na yagapasingadto sang baryo ng Imaos na mga sampoo aw isa na kilomitro sikun sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sarta yanagpanaw silan, yanagbaaw silan makapantag sang kariko ng yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sang yanagbaaw-baaw silan, dyomood kanilan si Isa aw yumupud kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na, maskin kikita nilan yan, wa silan ikilaa kanan kay maynang tyatago kanilan daw sino yan. ");
INSERT INTO kqe_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ansinyan yagalaong si Isa kanilan, “Ono yang pyagabaawan mayo sarta yagapanaw kamo?” Na, yomondang silan pagpanaw aw sang parangay nilan yamakita na mabugat yang ginawa nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yang sangka otaw kanilan na pyagangaanan ni Kliyopas yagalaong kanan, “Na, sigoro ikaw gaid yang yadatung sang Awrosalam na wa akatigam sang yamaitabo sidtong yalabay na mga allaw.” ");
INSERT INTO kqe_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yagaosip si Isa, “Nanga sa, ono kadi yang yamaitabo?” Tyomobag silan, “Yang yamaitabo kang Isa na taga Nasarit. Yan na otaw sambok na nabi sang pagtanaw ng Tohan aw yang kariko ng mga otaw, aw yagadan ng kabarakat ng Tohan yang maskin ono na pyaglaongan aw inangun nan. ");
INSERT INTO kqe_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Awgaid yang mga pangoo ng mga imam aw yang mga pangoo sang kanatun banwa yagaoman kanan adto sang gobirnador kay antak hokomon yan na patayun. Aw pyapalansang yan sang kros. ");
INSERT INTO kqe_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Awgaid kami, pagtoo nami na yan yang tyatagadan nami na magalowas sang bangsa Israil. Aw dogang pa sinyan, ikatoo da na allaw adon sikun sang pagkamatay nan. ");
INSERT INTO kqe_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aw aon mga bobay na kaupdanan nami na yagalaong kanami ng katingaan. Kay kyomadto silan sang kobor ni Isa ng kaamdagay pa, ");
INSERT INTO kqe_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","awgaid wa da kono nilan ikitaa yang patay na lawas ni Isa. Byomarik silan na yagagogod na aon kono kikita nilan na mga malaikat na yagalaong kanilan na bowi si Isa. ");
INSERT INTO kqe_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tapos, aon mga kaupdanan nami na kyomadto sang kobor aw kikita nilan yang magonawa sang pyagalaong ng mga bobay. Awgaid wa nilan ikitaa si Isa.” ");
INSERT INTO kqe_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ansinyan yagalaong si Isa kanilan, “Mainay sagaw yang pagsabot mayo! Nanga sa mairapan kamo mangintoo sang kariko ng pyagalaong ng mga nabi? ");
INSERT INTO kqe_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Di ba yagalaong silan na yang Almasi dait amagi ona ng kasikotan bago pa yan atagan ng dakowa na kabantog?” ");
INSERT INTO kqe_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ansinyan pyapakatigam nan kanilan yang kariko ng yamakasorat sang Kitab makapantag kanan, sikun pa sang syosorat ni Nabi Mosa sang Kitab Tawrat kipat sang kariko ng syosorat ng kadaigan pa na mga nabi. ");
INSERT INTO kqe_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nang masaid da silan sang baryo na akadtowan nidtong dowangka otaw, yagasiling si Isa na magapanaos pa yan. ");
INSERT INTO kqe_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Awgaid dyudumutan nilan yan aw laong nilan, “Pagpabilin sa adi kanami kay kasilum da aw masaid da somallup yang suga.” Idto sagaw, yagapabilin kanilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ansinyan sarta yanagingkod silan sang pagpangan, kyomamang yan ng pan aw yamanginsokor sang Tohan. Pagkatapos, pyagapingas-pingas nan aw pangatagan kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na, sinyan na wakto maynang kyakaabrian da yang kanilan mata aw kikilaa nilan si Isa. Awgaid sakadyap yamawaa da yan sang pagtanaw nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ansinyan yanaglaong silan, “Agaw sa kadi magaan yang kanatun ginawa nang yapagbaaw yan kanatun ansang daan aw pyapakatigam nan kanatun yang yamakasorat sang Kitab.” ");
INSERT INTO kqe_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na, ansinyan dayon imindug silan aw byomarik sang Awrosalam. Pagdatung nilan adto, yadatungan nilan yang sampoo aw isa na mga sahabat aw yang kadaigan pa na mga inagad nilan na yanagkatipon ");
INSERT INTO kqe_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","aw yanaglaong yang kariko nilan, “Bunna sagaw na yamabowi oman si Isa kay yagapakita yan kang Simon!” ");
INSERT INTO kqe_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ansinyan gyogogod oman nidtong dowangka otaw yang yamaitabo kanilan sang daan aw monono nilan ikilaa si Isa nang yagapingas-pingas yan ng pan. ");
INSERT INTO kqe_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sarta yagagogod pa sinyan idtong dowangka otaw, sakadyap iyan da magaindug si Isa ansang tunga nilan aw yagalaong yan kanilan, “Assalamo alaykom.” ");
INSERT INTO kqe_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Awgaid yukuga silan aw yamangkalluk kay pagtoo nilan na arowak yang kikita nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Awgaid yagalaong si Isa kanilan, “Nanga sa yamarido kamo? Aw nanga sa yagadowa-dowa pa kamo? ");
INSERT INTO kqe_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tanawa mayo yang arima aw siki ko antak kitaun mayo na ako sagaw yani. Damdama mayo ako antak mayo katigaman na dili ako ng arowak. Kay yang arowak way pusa atawa onod, awgaid kikita sa mayo na ako aon lawas.” ");
INSERT INTO kqe_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paglaong nan sinyan, pyapakita nan kanilan yang arima aw siki nan. ");
INSERT INTO kqe_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Awgaid di pa abay silan makatoo sabap sang bali na kasowat aw pagkatingaa nilan. Agaw yagalaong kanilan si Isa, “Aon pagkan mayo ansini?” ");
INSERT INTO kqe_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ansinyan yatagan nilan yan ng pyasagan na isda. ");
INSERT INTO kqe_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dyadawat nan aw kana nan sang atobangan nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ansinyan yagalaong yan kanilan, “Yani kay yang pyagalaong ko kamayo nang yumupud pa ako kamayo na yang kariko ng yamakasorat makapantag kanak dait matoman magonawa ng yamakasorat sang Hokoman ni Nabi Mosa, yang syosorat ng mga nabi aw yang yamakasorat sang Kitab Jabor.” ");
INSERT INTO kqe_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ansinyan yabrian nan yang kanilan dumduman antak silan makasabot sang yamakasorat sang Kitab. ");
INSERT INTO kqe_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yagalaong yan kanilan, “Yamakasorat sang Kitab na dait na amagi yang Almasi ng kasikotan aw amatay. Awgaid sang ikatoong allaw amabowi oman yan. ");
INSERT INTO kqe_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aw dait na apayapat adto sang kariko ng mga bangsa adi sang babawan ng donya na sabap sang Almasi amponon ng Tohan yang sino-sino na magatawbat sang mga dosa nilan. Aw pagasogdan yang pagpayapat sinyan adi sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo yang magasaksi makapantag sinyan,” laong ni Isa, “kay yakakita kamo sang kariko ng yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aw apadaa ko kamayo yang Nyawa ng Tohan na pyapasad ng kanak Ama. Awgaid pagpabilin nay kamo adi sang Awrosalam sampay sidtong wakto na amadawat da mayo yang kabarakat sikun sang sorga.” ");
INSERT INTO kqe_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ansinyan pyagaagad nan silan sikun sang Awrosalam sampay na dyomatung silan sang baryo ng Bitani. Ansan pyapataas nan yang kanan arima aw pyapangayowan nan silan ng kadyawan adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sarta yamangayo-ayo pa yan, pyapataas yan adto sang sorga aw ibiya da yan kanilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ansinyan syomojod silan aw syasambayangan nilan si Isa. Pagkatapos san yomori silan adto sang Awrosalam na dakowa yang kasowat nilan. ");
INSERT INTO kqe_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na, kada allaw adto da silan sang Baay ng Tohan aw pyopoji nilan yang Tohan. Wassalam ");
INSERT INTO kqe_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sang pukas nang wa pa akabaoy yang donya iyan da yang Pyaglaongan, aw yang Pyaglaongan iyan sang masaid sang Tohan, aw yang Pyaglaongan yang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sikun pa sangaon iyan da yan sang masaid sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yang kariko ng mga butang yamabaoy pinaagi kanan, aw way maskin ono na yamabaoy kondi pinaagi kanan. ");
INSERT INTO kqe_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yang Pyaglaongan yang pyagasikunan ng kinabowi, aw yani na kinabowi magonawa ng allag na yagaatag ng kaamdagan sang dumduman ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yani na allag yagasiga sang kaduguuman, aw wa makadaog sini yang kaduguuman. ");
INSERT INTO kqe_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Adon, aon sambok na otaw na pyapadaa ng Tohan. Yang ngaan nan si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Syosogo yan ng Tohan antak magpakatigam sang mga otaw daw sino yang allag kay antak yang kariko ng manosiya mangintoo sang allag sabap sang pagsaksi nan. ");
INSERT INTO kqe_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dili ni Yahiya yang allag, awgaid yakani yan antak magsaksi makapantag sang allag. ");
INSERT INTO kqe_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yang Pyaglaongan yang bunna na allag aw yakani yan sang donya antak kaamdagan yang dumduman ng kariko ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na, ini da yan sang donya. Awgaid maskin byabaoy ng Tohan yang kariko ng mga butang pinaagi kanan, wa ikilaa kanan yang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yakani yan sang kanan banwa, awgaid wa yan adawata ng kanan mga imamanwa. ");
INSERT INTO kqe_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Awgaid sino-sino yang yadawat aw yasarig kanan, yatagan nan silan ng kapatot na amabaoy na mga anak ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yamabaoy silan na mga anak ng Tohan dili kay yamaotaw silan sang pamaagi ng manosiya atawa sabap sang napso atawa pagbuut ng otaw. Awgaid yamabaoy silan na mga anak ng Tohan kay yatagan nan silan ng bago na kinabowi. ");
INSERT INTO kqe_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yang Pyaglaongan yagapakaotaw adi sang donya aw yagauya adi kanatun. Labi na maloyanun yan aw aag bunna yang pyaglaongan nan. Kikita nami yang kanan pagkaTohan, yang pagkaTohan ng tamisa na Anak na yagasikun sang Tohan na Ama. ");
INSERT INTO kqe_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Yahiya yagasaksi makapantag kanan aw yagalaong ng matanog, “Yan agaw yang pyagalaong ko sidtong yagalaong ako kamayo na ‘Yang otaw na mosonod kanak domatung labaw pa kanak kay iyan da yan nang wa pa ako akaotaw.’ ” ");
INSERT INTO kqe_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na, sabap sang dakowa na looy nan kita obos yamakadawat sikun kanan ng dogang-dogang na kadyawan. ");
INSERT INTO kqe_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yang Hokoman yatag kanatun ng Tohan sabap kang Nabi Mosa. Awgaid yang tabang ng Tohan aw yang kabunnaan yadatung kanatun sabap kang Isa Almasi. ");
INSERT INTO kqe_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Way sino-sino na yakakita sang Allaho Taala. Awgaid yang Tamisa nan na bunna na Tohan, yan yang yagapakatigam kanatun daw sino yang Tohan na Ama kay iyan yan sang masaid kanan. ");
INSERT INTO kqe_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Adon, yang mga pangoo ng mga Yahodi adto sang Awrosalam yagasogo sang mga imam kipat sang mga katabang nilan na mga topo ni Libi na kadtowan nilan si Yahiya antak osipun nilan daw sino yan. ");
INSERT INTO kqe_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tyomobag yan kanilan ng way tago-tago aw yagalaong yan ng kabunnaan, laong nan “Dili ko yang Almasi.” ");
INSERT INTO kqe_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Na, sino kaw kadi?” yagaosip silan. “Ikaw ba si Nabi Iliyas?” “Dili,” tyomobag si Yahiya. “Ikaw ba yang nabi na tyatagadan natun na bangsa Israil?” yang osip nilan. “Dili,” tyomobag oman si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yagalaong oman silan, “Sino kaw kadi? Paglaongan kanami antak aon akatobag nami sang mga otaw na yagasogo kanami. Ono yang akapaglaong mo makapantag sang ginawa mo?” ");
INSERT INTO kqe_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tyomobag si Yahiya sobay sang syosorat ni Nabi Isayas aw laong nan, “Ako yang otaw na yamanawag-tawag adto sang kamingawan na yagalaong, ‘Patorida mayo yang daan na agian ng Dato na Labi na Mabarakat.’ ” ");
INSERT INTO kqe_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, yang mga otaw na syosogo ng mga Parisi ");
INSERT INTO kqe_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","yagaosip oman kang Yahiya, laong nilan, “Nanga sa yagasogbo kaw sang mga otaw na dili mo kadi yang Almasi, ni si Nabi Iliyas, ni yang tyatagadan natun na nabi?” ");
INSERT INTO kqe_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tyomobag si Yahiya, “Ako, tobig yang pyagasogbo ko kamayo. Awgaid ansang tunga mayo aon sambok na otaw na wa mayo ikilaa. ");
INSERT INTO kqe_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yan agaw yang mosonod kanak domatung, awgaid maskin yang pagobad ng liston ng sandalyas nan di dait kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na, yang kariko sinyan yamaitabo sang banwa ng Bitani adto sang dipag ng tobig ng Yordan na idto magasogbo si Yahiya sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sonod na allaw kikita ni Yahiya na yagapasingud kanan si Isa. Ansinyan yagalaong si Yahiya sang mga otaw, “Tanawa mayo, yan kay yang karniro na yatag ng Tohan na apakorban kay antak makamang yang dosa ng manosiya! ");
INSERT INTO kqe_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yan agaw yang pyagalaong ko sidtong yagalaong ako kamayo na ‘Aon otaw na mosonod kanak domatung. Labaw pa yan kanak kay iyan da yan nang wa pa ako akaotaw.’ ");
INSERT INTO kqe_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nangaon maskin ako wa akatigam daw sino yang mosonod kanak domatung. Awgaid yakani ako pagsogbo sang mga otaw sang tobig antak apakilaa yan sang mga otaw na bangsa Israil.” ");
INSERT INTO kqe_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Adon, yani yang pagsaksi ni Yahiya, laong nan, “Kikita ko na yukunsad kang Isa yang Nyawa ng Tohan sikun sang langit sang porma ng salampati aw yagapabilin kanan. ");
INSERT INTO kqe_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nangaon wa pa ako akatigam daw sino yang mosonod kanak domatung. Awgaid pyagalaong ako ng Tohan na yagasogo kanak pagsogbo sang mga otaw sang tobig, laong nan, ‘Aw kitaun mo yang otaw na yang Nyawa ng Tohan mokunsad aw magapabilin kanan, yan agaw yang magasogbo sang mga otaw sang Nyawa ng Tohan.’ ");
INSERT INTO kqe_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na, bunna na kikita ko yan aw yamangimunna ako na si Isa yang Anak ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sonod na allaw idto da oman si Yahiya sang dipag ng Yordan upud sang dowangka otaw na mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pagkita nan na yalabay si Isa, yagalaong yan, “Tanawa mayo, yan kay yang karniro na yatag ng Tohan antak apakorban!” ");
INSERT INTO kqe_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagdungug sinyan nidtong dowangka inindowan ni Yahiya, yosonod silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ansinyan ilingi si Isa aw kikita nan na yosonod silan kanan. Yosip nan silan, “Ono yang karim mayo?” Tyomobag silan, “Rabbi, wain kaw magauya?” Yang mana ng Rabbi, Goro. ");
INSERT INTO kqe_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tyomobag si Isa, “Abay da aw tanawa mayo.” Ansinyan yamagad silan kanan. Yang oras sidto alas kowatro ng gabila. Pagdatung nilan sang pyagauyaan nan, yagapabilin silan ansan sampay ng gabi. ");
INSERT INTO kqe_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na, yang isa sidtong dowangka otaw na yamakadungug sang pyaglaongan ni Yahiya aw yamagad kang Isa si Andriyas na lomon ni Simon Pitros. ");
INSERT INTO kqe_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ansinyan yanap dayon ni Andriyas yang lomon nan aw paglaonga nan, “Kinita da nami yang Almasi.” Na, yang mana ng Almasi yang soltan na pyapasad ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ansinyan dyadaa nan si Simon adto kang Isa. Pyapakatanawan yan ni Isa aw paglaonga nan, “Ikaw si Simon na anak ni Yahiya. Awgaid sikun adon Kipas da yang ngaan mo.” Yang ngaan na Kipas magonawa sang Pitros na yang mana san bato. ");
INSERT INTO kqe_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sonod na allaw yagabuut si Isa komadto sang probinsya ng Jalil. Ansinyan kikita nan si Pilip aw paglaonga nan, “Anda, kay Pilip. Agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yani si Pilip taga Bitsayda magonawa kang Andriyas aw si Pitros. ");
INSERT INTO kqe_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ansinyan yanap ni Pilip si Natanyal aw pagkita nan, paglaonga nan, “Kinita da nami yang pyagaisgotan ni Nabi Mosa sang Kitab Tawrat kipat oman sang kadaigan na mga nabi. Yan si Isa na anak ni Yosop na taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yagalaong si Natanyal, “Oy, aon bay madyaw na yagasikun sang Nasarit?” Tyomobag si Pilip, “Abay da aw tanawa.” ");
INSERT INTO kqe_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na, pagkita ni Isa na yagapasingud kanan si Natanyal, yagalaong yan, “Yadi kay yang bunna na bangsa Israil na di maglimbong.” ");
INSERT INTO kqe_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yagaosip si Natanyal, “Nanga sa ikilaa kaw kanak?” Tyomobag si Isa, “Sang wa pa kaw atawaga ni Pilip, kikita ta kaw sang saad ng kaoy na igira.” ");
INSERT INTO kqe_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yagalaong si Natanyal, “Kay Goro, ikaw agaw yang Anak ng Tohan! Ikaw yang soltan sang bangsa Israil!” ");
INSERT INTO kqe_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yagalaong si Isa, “Yamangintoo da kaw kanak kay yagalaong ako na kikita ta kaw sang saad ng kaoy na igira? Na, labaw pa sinyan yang ikitaun mo na mga katingaan.” ");
INSERT INTO kqe_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aw yagalaong pa si Isa kanilan, “Sang bunna-bunna pagalaong ko kamayo na sang madatung na mga allaw ikitaun mayo na abri yang sorga aw yang mga malaikat ng Tohan panik-kawas adi kanak na Anak ng Manosiya.” ");
INSERT INTO kqe_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Paglabay ng dowang gabi, aon kawin sang banwa ng Kana sang probinsya ng Jalil. Iyan sang pakaradyaan ng kawin yang ina ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Isa aw yang mga inindowan nan imbitado oman. ");
INSERT INTO kqe_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Adon, pagkaorot da ng bino, yagalaong yang ina ni Isa kanan, “Waa day bino nilan.” ");
INSERT INTO kqe_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tyomobag si Isa aw laong nan, “Kay Ina, ayaw magkarido. Ako da yang bahala san. Awgaid wa pa adatung yang osto na wakto.” ");
INSERT INTO kqe_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ansinyan yagalaong yang kanan ina sang mga sogowanun, “Inanga mayo maskin ono yang pagalaong nan kamayo.” ");
INSERT INTO kqe_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, ansang masaid kanilan aon unum ka banga na ininang sikun sang bato. Yang kada isa kalasakan ng 100 ka litro na tobig na gyagamit ng mga Yahodi sang pagpangonaw ng arima bago koman. ");
INSERT INTO kqe_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ansinyan yagalaong si Isa sang mga sogowanun, “Ponowa mayo yang mga banga ng tobig.” Agaw pyopono nilan taman sang baba. ");
INSERT INTO kqe_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkatapos sinyan yagalaong si Isa kanilan, “Pagsauk da kamo aw daa adto sang pangoo ng pakaradyaan.” Ansinyan ininang da nilan ");
INSERT INTO kqe_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aw titilawan ng pangoo ng pakaradyaan yang tobig na yamabaoy ng bino. Wa yan akatigam daw wain magasikun idtong bino, awgaid yang mga sogowanun na yagasauk ng tobig yamatigam. Agaw tyatawag ng pangoo ng pakaradyaan yang usug na akawinun ");
INSERT INTO kqe_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aw paglaonga nan, “Kasagaran yang ona na apainum sang mga bisita yang madyaw na bino. Aw madaig da yang yamainum nilan, apainum da kanilan yang bino na di abay madyaw. Awgaid ikaw, pyapamaori mo kadi yang madyaway na bino.” ");
INSERT INTO kqe_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na, yani na katingaan na ininang ni Isa adto sang banwa ng Kana na sakop ng Jalil, yang ona na tanda na ininang nan. Sang mayninyan na pamaagi pyapakita nan yang kanan pagkaTohan, aw yamangintoo kanan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkatapos sinyan kyomadto si Isa sang longsod ng Kapirnaom upud sang kanan ina, yang mga lomon nan na usug kipat sang mga inindowan nan. Aw yanagpabilin silan adto ng pilang allaw. ");
INSERT INTO kqe_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ansinyan masaid da yang pakaradyaan ng mga Yahodi na tyatawag ng Pakaradyaan ng Paglabay. Agaw kyomadto silan Isa sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdatung nilan ansan, kyomadto si Isa sang Baay ng Tohan. Sang pamanag sinyan aon kikita nan na mga otaw na yanagbarigya ng mga baka, karniro aw salampati. Aon oman mga otaw na yanagingkod ansang lamisa aw yanagkambiyo ng sapi. ");
INSERT INTO kqe_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pagkita nan sinyan, kyomamang yan ng mga lobid aw ininang nan ng babadas aw pyapalogwa nan yang kariko ng mga karniro aw baka sikun sang Baay ng Tohan. Kyakaya-kaya nan yang sapi ng mga yanagkambiyo aw byabariskad nan yang mga lamisa nilan. ");
INSERT INTO kqe_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pyagalaong nan yang mga yanagbarigya ng salampati, “Daa da mayo yan adto logwa! Ayaw mayo inanga ng palengke yang Baay ng kanak Ama!” ");
INSERT INTO kqe_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ansinyan kyakadumduman ng mga inindowan nan yang yamakasorat sang Kitab na yagalaong, “Dakowa yang kallini ko sang Baay mo, ya Tohan, maskin idto yang amakabogto sang ginawa ko.” ");
INSERT INTO kqe_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ansinyan yosip yan ng mga pangoo ng mga Yahodi, laong nilan, “Ono yang katingaan na apakita mo kanami silbi tanda na aon kanmo kapatot paginang sini na mga butang?” ");
INSERT INTO kqe_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tyomobag si Isa, “Gubaa mayo yaning Baay ng Tohan aw apaindugun ko oman yan sa suud ng toong allaw.” ");
INSERT INTO kqe_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Astaga!” yagalaong yang mga pangoo. “Yang paginang sining Baay ng Tohan 46 ka toig! Apaindugun da mo oman sa suud ng toong allaw?” ");
INSERT INTO kqe_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Awgaid yang Baay ng Tohan na pyagalaong ni Isa dili nidtong Baay ng Tohan sang Awrosalam, awgaid yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Agaw, pagkatapos mabowi oman ni Isa, kyakadumduman ng mga inindowan nan inyan na pyaglaongan ni Isa. Aw ansinyan pyapangintoowan nilan yang yamakasorat sang Kitab kipat sang pyaglaongan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, sarta adto sang Awrosalam si Isa sang wakto ng Pakaradyaan ng Paglabay, madaig yang mga otaw na yamangintoo kanan sabap ng kikita nilan yang mga katingaan na ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Awgaid way pagsarig ni Isa sang pagpangintoo nilan kanan kay kyakatigaman nan yang kinaiya ng kariko ng otaw. ");
INSERT INTO kqe_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Di kinaanglan na aon magalaong kanan daw ono yang iyan sang pangatayan ng manosiya kay kyakatigaman da nan. ");
INSERT INTO kqe_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Adon, aon sangka otaw na pangoo ng mga Yahodi aw mimbro ng mga Parisi na pyagangaanan ni Nikodimos. ");
INSERT INTO kqe_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sanggabi disinyan kyomadto yan kang Isa aw yagalaong kanan, “Kay Goro, yamatigam kami na ikaw sambok na magiindoway na pyapadaa ng Tohan. Kay way otaw na makainang ng mga katingaan na magonawa sang ininang mo yatabiya iyan kanan yang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kanmo na di amasakop yang otaw sang pyagadatowan ng Tohan kong di yan amaotaw oman.” ");
INSERT INTO kqe_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yagaosip si Nikodimos, “Mapakay ba na amaotaw oman yang otaw na aon day idad? Di da kowaw yan makabarik adto suud sang dubdub ng kanan ina antak magpakaotaw oman.” ");
INSERT INTO kqe_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kanmo na aon dowa na pamaagi ng pagkaotaw. Yang otaw di amasakop sang pyagadatowan ng Tohan yatabiya amaotaw yan pinaagi sang tobig aw pinaagi oman sang Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kay kong amaotaw yang otaw sang pamaagi ng manosiya, yang amadawat nan yang kinabowi na yagasikun sang manosiya. Awgaid kong amaotaw yan pinaagi sang Nyawa ng Tohan, yang amadawat nan yang kinabowi na yagasikun sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ayaw magkatingaa sang pyagalaong ko na yang kariko mayo dait na amaotaw oman. ");
INSERT INTO kqe_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yang opamaan sini yang samut. Yang samut yagaoyop abir sa wain. Yamadungug natun yang oni nan, awgaid wa natun akatigami daw wain yan magasikun atawa wain yan magapasingud. Magonawa sinyan yang otaw na amaotaw oman pinaagi sang Nyawa ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Maonono kadi yan?” yagaosip si Nikodimos. ");
INSERT INTO kqe_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tyomobag si Isa, “Astaga! Wa kaw akatigam maskin bantoganun kaw na magiindoway ng bangsa Israil? ");
INSERT INTO kqe_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sang bunna-bunna pagalaong ko kanmo na yang kyakatigaman nami idto yang pyagalaong nami, aw yang kikita nami idto yang pyapangimunnaan nami. Awgaid di kamo mangintoo sang pyagalaong nami. ");
INSERT INTO kqe_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kong di kamo mangintoo sang pyagalaong ko makapantag sang mga butang adi sang donya, na, monono da kamo mangintoo sang pagalaong ko makapantag sang mga butang adto sang sorga? ");
INSERT INTO kqe_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Way maskin sino na yakadto sang sorga yatabiya ako na Anak ng Manosiya kay yagasikun ako sang sorga. ");
INSERT INTO kqe_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Sangaong ona pyapataas ni Nabi Mosa yang bila na bronsi adto sang diserto. Magonawa sinyan dait na apataasun oman ako na Anak ng Manosiya ");
INSERT INTO kqe_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kay antak sino-sino yang amangintoo kanak akaonan ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sabap sang dakowa na looy ng Tohan sang manosiya yatag nan yang tamisa na Anak nan kay antak sino-sino yang amangintoo kanan di amanarka, awgaid akaonan yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay pyapadaa ng Tohan yang Anak nan adi sang donya dili antak hokomon yang manosiya na isiksaun awgaid antak malowas silan sabap kanan. ");
INSERT INTO kqe_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yang otaw na yamangintoo sang Anak ng Tohan, di hokomon na isiksaun. Awgaid yang otaw na wa apangintoo kanan, yokoman da kay wa yan apangintoo sang Tamisa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yakani sang donya yang Anak ng Tohan na magonawa ng allag, awgaid pyapalabi ng mga otaw yang kaduguuman kay maat yang mga ininang nilan. Idto yang sabap nanga sa yokoman da silan. ");
INSERT INTO kqe_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yang otaw na yagainang ng maat di mallini sang kaamdagan. Di yan modood sang kaamdagan kay di nan karim na makita yang maat na ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Awgaid yang otaw na mosonod sang kabunnaan modood sang kaamdagan antak makita na yang Tohan yang pyagasikunan ng madyaw na ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos sinyan kyomadto si Isa aw yang mga inindowan nan sang probinsya ng Yahodiya. Yagapabilin yan adto ng tagbi na panahon upud sang mga inindowan nan aw yagasogbo silan sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Yahiya oman yagasogbo sang mga otaw adto sang banwa ng Inon na masaid sang banwa ng Salim kay madaig yang tobig ansan. Yabay simingadto kanan yang mga otaw antak magpasogbo. ");
INSERT INTO kqe_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sidto na wakto wa pa ipirisowa si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ansinyan yanaglalis yang pilangka otaw na inindowan ni Yahiya aw yang sambok na Yahodi makapantag sang kabatasanan ng pagsogbo. ");
INSERT INTO kqe_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Agaw kyomadto silan kang Yahiya aw laong nilan, “Kay Goro, kyakadumduman ba mo idtong otaw na kaupdanan mo adto sang dipag ng tobig ng Yordan, yangaong pyapakilaa mo sang mga otaw? Na, yagasogbo da yan adon sang mga otaw aw madaig silan na yakadto kanan!” ");
INSERT INTO kqe_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tyomobag si Yahiya, “Way amainang ng otaw kong dili ng pagbuut ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo yang yamakasaksi sang pyagalaong ko na dili ko yang Almasi. Syosogo gaid ako na amaona kanan antak andamun ko yang mga otaw sang pagdatung nan. ");
INSERT INTO kqe_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Atagan ta kamo ng opamaan. Sang kawin, yang bobay na apangasawaun para gaid sang usug na akawinun. Awgaid yang amigo ng usug na yatabang sang pakaradyaan ng kawin, yamasowat yan pagdungug nan sang tingug ng usug na akawinun. Magonawa sinyan dakowa da adon yang kasowat ko kay dyomatung da yang Almasi. ");
INSERT INTO kqe_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dait gaid na magakadakowa yang dungug nan aw magakatagbi yang kanak dungug.” ");
INSERT INTO kqe_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yang yagasikun sang sorga labaw sang kariko. Awgaid yang yagasikun sang donya, yang kyakatigaman nan kadodonya gaid kay taga donya yan. Awgaid yang yagasikun sang sorga, labaw yan sang kariko. ");
INSERT INTO kqe_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pyapakatigam nan yang makapantag sang kikita aw dyudungug nan adto sang sorga, awgaid yang mga otaw wa apangintoo sang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Awgaid idtong mga otaw na yamangintoo sang pyaglaongan nan yamangimunna na aag bunna yang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay yang syosogo ng Tohan, way lain na pyapakatigam nan yatabiya yang pyaglaongan ng Tohan kay iyan kanan yang kariko ng kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kyakalugunan ng Ama yang kanan Anak aw yatag nan kanan yang kapatot makapantag sang kariko. ");
INSERT INTO kqe_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sino-sino yang amangintoo sang Anak ng Tohan akaonan ng kinabowi na way kataposan. Awgaid sino-sino yang di amangagad sang Anak ng Tohan, di yan atagan ng kinabowi awgaid magapabilin kanan yang kadaman ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Adon, yamadungug ng mga Parisi na mas madaig yang mga inindowan ni Isa kay kang Yahiya kipat oman sang mga otaw na syosogbowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Awgaid sang kabunnaan, dili ni Isa yang yagasogbo sang mga otaw awgaid yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkatigam ni Isa na idto yang dyudungug ng mga Parisi, pyomanaw yan sikun sang Yahodiya upud sang mga inindowan nan aw byomarik silan sang probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sang pagkadto nilan sang Jalil kinaanglan na amagi silan sang probinsya ng Samariya. ");
INSERT INTO kqe_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pagagi nilan sang Samariya, dyomatung silan sang sambok na longsod na pyagangaanan ng Sikar na masaid sang lopa na yatag sangaon ni Yakob sang anak nan na si Yosop. ");
INSERT INTO kqe_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ansan na lopa aon sambok na balon na pyapakotkot ni Yakob. Aw sabap ng kyakapoy si Isa ng pagpanaw imingkod yan sang masaid sang balon. Sidto na wakto apit da alas dose yang suga. ");
INSERT INTO kqe_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yang mga inindowan ni Isa pyomanaos sang longsod kay magabili ng pagkan. Aw sarta yagaingkod si Isa ansang balon, dyomatung yang sambok na bobay na taga Samariya kay masagub. Yagalaong si Isa kanan, “Kay Bodi, tabiya kanmo, painuma ako.” ");
INSERT INTO kqe_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tyomobag yang bobay, “Yahodi kaw aw ako taga Samariya. Nanga sa yamangayo kaw ng mainum adi kanak?” Maynini yang pyagalaong ng bobay kay di magupud yang mga Yahodi sang mga taga Samariya. ");
INSERT INTO kqe_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tyomobag si Isa, “Aw yamatigam pa kaw daw ono yang akaatag ng Tohan aw sino ako na yamangayo kanmo ng tobig, ikaw da kowaw yang amangayo kanak aw atagan ta kaw ng tobig na makaatag ng kinabowi.” ");
INSERT INTO kqe_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Kay Sir,” yagalaong yang bobay, “waa say sasauk mo aw maum yani na balon. Wain kaw makamang ng tobig na makaatag ng kinabowi? ");
INSERT INTO kqe_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labaw pa kaw sang kanami ompo na si Yakob na yagaatag kanami sining balon? Si Yakob aw yang mga anak nan kipat sang mga kaayupan nan iminum ng tobig sikun sining balon.” ");
INSERT INTO kqe_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tyomobag si Isa, “Sino-sino yang iminum sining tobig amalangga oman. ");
INSERT INTO kqe_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Awgaid sino-sino yang iminum ng tobig na atag ko kanan, di da yan amalangga. Kay yang tobig na atag ko kanan amabaoy ng bogak sa suud ng pangatayan nan na magaatag kanan ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ansinyan yagalaong yang bobay kanan, “Kay Sir, atagi ako sining tobig na pyagalaong mo kay antak di da ako amalangga aw di da ako kinaanglan magbarik-barik adi antak somagub.” ");
INSERT INTO kqe_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yagalaong si Isa, “Panaw da, kadtoni yang kanmo bana aw barik adi.” ");
INSERT INTO kqe_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tyomobag yang bobay, “Waa say bana ko.” Yagalaong si Isa, “Bunna yang pyagalaong mo na way bana mo. ");
INSERT INTO kqe_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kay lima pangka otaw yang yamabana da mo aw yang usug na kaupud mo adon dili ng bana mo. Agaw bunna yang pyagalaong mo.” ");
INSERT INTO kqe_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yagalaong yang bobay, “Kay Sir, nabi kaw kadi! ");
INSERT INTO kqe_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aon gao pagalaong ko. Yang kanami mga kaompowan yagasambayang adi siding butay. Awgaid kamo na mga Yahodi yagalaong na adto gaid sang Awrosalam dait magsambayang sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yagalaong si Isa, “Kay Bodi, pagtoo sang pagalaong ko. Madatung yang wakto na asambayangan mayo yang Tohan na Ama dili adi siding butay ni adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamo na taga Samariya, wa mayo ikilaa yang Tohan na syasambayangan mayo. Awgaid kami na mga Yahodi, kikilaa nami yang syasambayangan nami kay yang manlolowas magasikun sang tribo ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Awgaid madatung yang wakto aw ini da adon, na magasambayang yang mga otaw sang Tohan na Ama na iklas yang pangatayan nilan. Magasambayang silan sikun sang pangatayan aw sobay sang kabunnaan. Yani yang bunna na pagsambayang na kyakallinian ng Tohan na Ama. ");
INSERT INTO kqe_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yang Tohan nyawa, agaw sino-sino yang magasambayang kanan dait na sikun sang pangatayan aw sobay sang kabunnaan yang pagsambayang nan.” ");
INSERT INTO kqe_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yagalaong yang bobay, “Yamatigam ako na madatung yang Almasi. Aw pagdatung nan, apakatigam nan kanatun yang kariko ng mga butang.” ");
INSERT INTO kqe_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yagalaong si Isa, “Ako na yapagbaaw kanmo, ako ingidto.” ");
INSERT INTO kqe_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sidto na wakto byomarik yang mga inindowan ni Isa aw yamatingaa silan pagkita nilan na yapagbaaw si Isa sang sambok na bobay. Awgaid wa silan magaosip daw ono yang toyo ng bobay atawa nanga sa yapagbaaw kanan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ansinyan bibiyaan ng bobay yang kanan banga aw byomarik sang longsod. Pagdatung nan adto, pyagalaong nan yang mga otaw ansan, laong nan, ");
INSERT INTO kqe_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Abay da aw tanawa mayo yang otaw na yamatigam sang kariko ng ininang ko. Basin yan yang Almasi.” ");
INSERT INTO kqe_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Agaw lyomogwa silan sang longsod aw yagapasingadto silan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sarta wa pa adatung yang mga otaw, yabay maglaong kang Isa yang mga inindowan nan, “Kay Goro, kan da sa.” ");
INSERT INTO kqe_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Awgaid yagalaong yan kanilan, “Aon kanak pagkan na wa mayo akatigami.” ");
INSERT INTO kqe_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sabap sinyan yanaginosipay yang mga inindowan nan, laong nilan, “Aon bay yagadaa kanan ng pagkan?” ");
INSERT INTO kqe_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“Yani yang kanak pagkan,” laong ni Isa, “na inangun ko yang karim ng Tohan na yagapadaa kanak aw taposon ko yang gawbuk na pyapainang nan kanak. ");
INSERT INTO kqe_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Di ba yagalaong kamo na opat ka bowan koman bago pa yang paggani? Awgaid pagalaongon ta kamo na ini da yang wakto ng paggani. Tanawa sa mayo yang mga otaw na yagapasingadi kanak. Magonawa silan sang omay na yailag da aw mapakay ganiun. Agaw di amadogay amangintoo da silan kanak. ");
INSERT INTO kqe_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yang mga manggagani aon adawatun na baras, aw yang mga otaw na dyadaa nilan adi kanak atagan ng kinabowi na way kataposan. Agaw, idtong magpupugas aw idtong manggagani, magakasowat silan dowa. ");
INSERT INTO kqe_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bunna yaning pyaglaongan mayo na yagalaong, ‘Aon magapugas aw aon oman magagani.’ ");
INSERT INTO kqe_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Syosogo ta kamo antak ganiun mayo yang wa mayo atanuma. Tuna na mga otaw yang yagagawbuk, aw adon aon kabainan mayo sang pyagapagodan nilan.” ");
INSERT INTO kqe_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, madaig yang mga taga Samariya ansidtong longsod na yamangintoo kang Isa sabap sang pyagalaong ng bobay na kyakatigaman ni Isa yang kariko ng ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Agaw, pagdatung ng mga taga Samariya adto kang Isa, dyudumutan nilan yan na magapabilin pa adto kanilan. Aw yagapabilin pa si Isa ansan na longsod ng dowang allaw. ");
INSERT INTO kqe_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Adon, mas madaig pa yang yamangintoo kang Isa sabap sang pyagaindo nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aw yagalaong silan sidtong bobay, “Yamangintoo da kami kang Isa dili gaid sabap sang pyagalaong mo kanami, awgaid sabap ng kami mismo yang yamakadungug sang pyagaindo nan aw yamatigam da kami na yan agaw yang manlolowas ng manosiya.” ");
INSERT INTO kqe_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Paglabay ng dowang allaw, pyomanaw silan Isa sikun sang Samariya aw kyomadto silan sang probinsya ng Jalil. ");
INSERT INTO kqe_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Awgaid yagalaong si Isa sangaon na dili addatan yang sambok na nabi ng mga imamanwa nan. ");
INSERT INTO kqe_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na, pagdatung ni Isa sang Jalil, madyaw yang pagdawat kanan ng mga otaw ansan kay yakatambong silan sang Pakaradyaan ng Paglabay adto sang Awrosalam aw kikita nilan adto yang kariko ng ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ansinyan byomarik silan Isa sang banwa ng Kana na sakop ng Jalil, yang banwa daw wain nan inanga yang bino sikun sang tobig. Disidto aon sambok na opisyal ng soltan na yang anak nan na usug yamasakit adto sang longsod ng Kapirnaom. ");
INSERT INTO kqe_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagdungug ng opisyal na byomarik si Isa sang Jalil sikun sang Yahodiya, kyomadto yan kang Isa aw yagapakilooy kanan na makadto sang Kapirnaom kay antak pakadyawon nan yang anak nan na yagapinal da. ");
INSERT INTO kqe_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yagalaong si Isa kanan, “Aw di kamo makakita ng mga tanda atawa mga katingaan, di kamo amangintoo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yagalaong yang opisyal, “Kay Sir, tabiya kanmo, agad nay kanak sarta bowi pa yang anak ko.” ");
INSERT INTO kqe_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tyomobag kanan si Isa, “Ori da, kay madyaw da yang anak mo.” Yamangintoo yang opisyal sang pyaglaongan ni Isa aw ori dayon yan. ");
INSERT INTO kqe_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na, sarta iyan pa yan sang daan, syosongon yan ng mga sogowanun nan na yagalaong, “Madyaw da yang anak mo!” ");
INSERT INTO kqe_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Agaw yosip nan silan daw ono na wakto na yamadyaw yang anak nan. Laong nilan, “Kagabi pa, mga ala ona ng gabila yamawaa yang kalintora nan.” ");
INSERT INTO kqe_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ansinyan kyakadumduman ng ama na idto yang wakto na pyagalaong yan ni Isa na “Madyaw da yang anak mo.” Sabap sinyan yamangintoo yan kang Isa kipat sang kariko ng mga sakop sang kanan baay. ");
INSERT INTO kqe_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, yani yang ikadowa na katingaan na ininang ni Isa adto sang Jalil pagbarik nan ansan sikun sang Yahodiya. ");
INSERT INTO kqe_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wa akadogay disinyan kyomadto si Isa sang Awrosalam kay aon pakaradyaan ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Adto sang Awrosalam sang masaid sang powertaan na tyatawag ng Powertaan ng Karniro aon sambok na sogbowanan na tyatawag sang Hibrani ng Bitisda. Lilibotan yan na sogbowanan ng limangka pagasilongan ");
INSERT INTO kqe_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","aw madaig yang mga masakitun na yokowang ansan na magonawa ng mga bota, mga pilay kipat sang mga sadi. Yanagtagad silan sang pagliyuk ng tobig ");
INSERT INTO kqe_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kay aon wakto na mokunsad yang malaikat ng Tohan ansang sogbowanan aw kotawon nan yang tobig. Yang amaona pagkawas sang tobig pagkatapos makotaw amadyaw sikun sang maskin ono na sakit nan. ");
INSERT INTO kqe_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, aon sangka otaw ansan na yamasakit sa suud ng 38 ka toig. ");
INSERT INTO kqe_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kikita yan ni Isa na yokowang ansan aw kyakatigaman nan na madogay da yang pagkasakit nan. Agaw yosip nan yang otaw, “Karim mo na amadyaw kaw?” ");
INSERT INTO kqe_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tyomobag yang masakitun, “Ud, kay Sir, karim ko. Awgaid way magadaa kanak adto sang tobig pagkotaw da. Pasingadto pa gaid ako, aon day yamaona kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yagalaong kanan si Isa, “Pagindug! Kamanga yang kanmo kamun aw panaw!” ");
INSERT INTO kqe_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ansinyan yamadyaw dayon yang otaw. Kyakamang nan yang kamun nan aw panaw. Yamainang yani ng Sabado na Allaw ng Pagpatana ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Agaw yagalaong yang mga pangoo ng mga Yahodi sidtong otaw na pyapakadyaw, “Allaw ng Pagpatana adon. Sopak sang Hokoman na yagadaa kaw ng kanmo kamun.” ");
INSERT INTO kqe_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Awgaid tyomobag yang otaw, “Yang otaw na yagapakadyaw kanak yagalaong na kamangun ko yang kanak kamun aw panaw.” ");
INSERT INTO kqe_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yagaosip silan kanan, “Sino kadi yang yagasogo kanmo na kamangun mo yang kanmo kamun aw panaw?” ");
INSERT INTO kqe_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Awgaid wa akatigam yang otaw daw sino yang yagapakadyaw kanan kay pyomanaw dayon si Isa sarta madaig yang mga otaw ansan. ");
INSERT INTO kqe_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wa akadogay disinyan kikita ni Isa yangaong otaw sa suud ng Baay ng Tohan aw paglaonga nan, “Tanawa, madyaw da kaw adon. Ayaw da magpakadosa antak di kaw adatungan ng labi pa na kasikot.” ");
INSERT INTO kqe_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ansinyan pyomanaw idtong otaw aw paglaonga nan yang mga pangoo ng mga Yahodi na si Isa yang yagapakadyaw kanan. ");
INSERT INTO kqe_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sabap sinyan yagasogod da yang pagpakasikot ng mga pangoo kang Isa kay pyapakadyaw nan yang masakitun sang Allaw ng Pagpatana. ");
INSERT INTO kqe_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Awgaid yagalaong kanilan si Isa, “Yang kanak Ama yabay maggawbuk sampay adon. Agaw, ako oman yagagawbuk.” ");
INSERT INTO kqe_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sabap sinyan na pyaglaongan ni Isa lyomabi pa yang karim ng mga pangoo na apatayun yan. Kay dili gaid ng yosopak yan sang sogowan na di mapakay maggawbuk sang Allaw ng Pagpatana, awgaid yagalaong pa yan na yang Tohan yang kanan Ama, na mana nan na magonawa yan sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Idto sagaw, yagalaong si Isa kanilan, “Sang bunna-bunna pagalaong ko kamayo na yang Anak way amainang ng sarili nan, awgaid idto gaid yang ininang nan daw ono yang kikita nan na ininang ng Ama. Kay maskin ono yang ininang ng Ama, idto oman yang inangun ng Anak. ");
INSERT INTO kqe_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kyakalugunan yang Anak ng Ama, agaw pyapakita nan kanan yang kariko ng ininang nan. Sang madatung na mga allaw aon pay apainang nan kanan na labaw pa sang ininang nan adon aw amangkatingaa da kamo. ");
INSERT INTO kqe_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yang Ama, obowiun nan yang mga patay aw atagan nan silan ng kinabowi. Magonawa oman sinyan yang Anak kay atagan nan ng kinabowi yang maskin sino na karim nan atagan. ");
INSERT INTO kqe_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yang Ama di oman magahokom sang maskin sino kay yatag nan sang Anak yang kapatot ng paghokom ");
INSERT INTO kqe_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","antak addatan yang Anak ng kariko ng mga otaw magonawa sang pagaddat nilan sang Ama. Sino-sino yang way addat sang Anak, way oman addat sang Ama na yagasogo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Sang bunna-bunna pagalaong ko kamayo na sino-sino yang yamaningug sang pyaglaongan ko aw yamangintoo sang yagasogo kanak, kyakaonan ng kinabowi na way kataposan. Di da yan hokomon na isiksaun kay yalowas da yan sikun sang kamatay aw kyakaonan da yan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sang bunna-bunna pagalaong ko kamayo na madatung yang wakto aw ini da adon, na yang mga otaw na maynang patay sabap sang mga dosa nilan makadungug sang sowara ko na Anak ng Tohan. Aw sino-sino yang amangintoo sang dyudungug nan akaonan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yang kanak Ama yang pyagasikunan ng kinabowi. Magonawa oman sinyan ako na Anak nan kay yatagan nan ako ng kapatot pagpangatag sang kinabowi. ");
INSERT INTO kqe_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aw yatagan oman nan ako ng kapatot paghokom sang manosiya kay ako yang Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ayaw kamo magkatingaa sining pyagalaong ko kay madatung yang wakto na yang kariko ng mga patay makadungug sang sowara ko, ");
INSERT INTO kqe_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aw pagdungug nilan sinyan, mologwa silan sikun sang mga kobor. Yang mga otaw na madyaw yang ininang, amabowi oman aw atagan silan ng kinabowi na way kataposan. Yang mga otaw na maat yang ininang, amabowi oman awgaid hokomon silan na isiksaun. ");
INSERT INTO kqe_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Way amainang ko kong ako gaid. Yang paghokom ko mosobay sang pyagalaong kanak ng Tohan. Agaw matorid yang paghokom ko kay dili ng kanak karim yang apangagadan ko kondi yang karim sidtong yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kong ako gaid yang magasaksi makapantag sang ginawa ko, makadoda kamo sang pyaglaongan ko. ");
INSERT INTO kqe_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Awgaid aon tuna na yagasaksi makapantag kanak, aw yamatigam ako na bunna yang pyaglaongan nan makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aon syosogo mayo na mga otaw adto kang Yahiya aw yagalaong yan ng kabunnaan makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Di ko kinaanglan yang pagsaksi ng otaw, awgaid pyagalaong ta kamo makapantag kang Yahiya antak malowas kamo. ");
INSERT INTO kqe_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Yahiya magonawa sang ilawan na yagasiga aw yagaatag ng kaamdagan, aw yamangkasowat kamo ng tagbi na panahon sabap sang kaamdagan na yatag nan kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Awgaid aon yagasaksi makapantag kanak na labaw pa kang Yahiya. Idto yang mga inang ko na pyapainang kanak ng Ama. Idto oman yang yagapangimunna na syosogo nan ako. ");
INSERT INTO kqe_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aw yang Ama na yagasogo kanak yagasaksi oman makapantag kanak. Awgaid sikun pa sangaong ona wa pa kamo makadungug ng sowara nan aw wa kamo ikita kanan. ");
INSERT INTO kqe_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aw waa ansang pangatayan mayo yang pyaglaongan nan kay wa kamo apangintoo kanak na syosogo nan. ");
INSERT INTO kqe_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yabay sa kamo mangadi sang Kitab kay yagadumdum kamo na sabap sinyan amakadawat kamo ng kinabowi na way kataposan. Aw idto sagaw, yang Kitab yagasaksi makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Awgaid di kamo mangintoo kanak maskin ako da yang makaatag kamayo ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Di ako manganap ng pagbantog ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Awgaid ikilaa ta kamo aw yamatigam ako na wa mayo apakadakowaa yang Tohan sang kamayo pangatayan. ");
INSERT INTO kqe_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yakani ako na yatagan ako ng kapatot ng kanak Ama, awgaid di mayo ako adawatun. Awgaid kong aon makani sang sarili nan na kapatot, na, adawatun da mayo. ");
INSERT INTO kqe_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kyakallinian mayo na abantogon kamo ng kapagonawa mayo. Awgaid wa kamo amangalingkamot na abantogon kamo ng bunna na Tohan. Agaw sagaw di kamo makapangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Na, ayaw kamo magdumdum na ako yang magaoman kamayo adto sang Ama. Yang magaoman kamayo si Nabi Mosa na syasarigan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kay kong bunna na pyapangintoowan mayo yang syosorat ni Nabi Mosa, yamangintoo gao kamo kanak kay syosorat nan sang Kitab yang makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Awgaid sabap ng wa kamo apangintoo sang syosorat ni Nabi Mosa, di oman kamo amangintoo sang pyaglaongan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkatapos sinyan tyomaripag silan Isa sang Linaw ng Jalil na tyatawag oman ng Linaw ng Tibiriyas. ");
INSERT INTO kqe_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Madaig yang mga otaw na yosonod kanilan kay kikita nilan yang mga katingaan na ininang ni Isa na magonawa ng pagpakadyaw sang mga masakitun. ");
INSERT INTO kqe_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ansinyan tyomokod si Isa aw yang mga inindowan nan sang sambok na butay aw imingkod silan. ");
INSERT INTO kqe_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sidto na wakto masaid da yang pakaradyaan ng mga Yahodi na tyatawag ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na, pagtanaw ni Isa, kikita nan na madaig yang mga otaw na yagasingadi kanan. Agaw yosip nan si Pilip, “Wain kita makabili ng pagkan antak makakan yaning mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yani yang pyagalaong ni Isa antak tistingan nan si Pilip daw ono yang otobag nan. Awgaid kyakatigaman da ni Isa daw ono yang inangun nan. ");
INSERT INTO kqe_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tyomobag si Pilip, “Maskin yang soweldo ng sangka otaw sa suud ng waombowan yang pagabili natun ng pagkan, kolang pa yan sang kadaig sining mga otaw kay antak makakan maskin ng tagbibis gaid yang kada isa kanilan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ansinyan yagalaong si Andriyas na lomon ni Simon Pitros, na isa oman sang mga inindowan ni Isa, ");
INSERT INTO kqe_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aon disini sambok na isu na aon daa nan na limambok na pan aw dowamboos na isda. Awgaid onoon ta sa yani sang kadaig sining mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ansinyan yagalaong si Isa sang mga inindowan nan, “Paingkoda mayo yang mga otaw.” Na, madaig yang sagbut sidtong logar, agaw imingkod yang mga otaw ansang kasagbutan. Yang kadaig ng kausgan 5,000 na way labot yang kaobayan aw yang kamangaisuan. ");
INSERT INTO kqe_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ansinyan kyakamang ni Isa yang pan aw panginsokor sang Tohan. Pagkatapos san pyapangatag nan yang pan sang mga otaw na yanagingkod ansan. Maynini oman yang ininang nan sang isda. Aw yang kariko ng mga otaw yakakan kotob sang gosto nilan. ");
INSERT INTO kqe_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkatapos nilan koman, yagalaong si Isa sang mga inindowan nan, “Tipona mayo yang yamasama na pagkan antak way masayang.” ");
INSERT INTO kqe_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na, titipon da nilan aw sikun sang limambok na pan na kyakan ng mga otaw sampoo aw dowa na bokag yang yamapono nilan. ");
INSERT INTO kqe_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na, pagkita ng mga otaw sinyan na katingaan na ininang ni Isa, yanaglaong silan, “Sang way dowa-dowa, yan agaw yang nabi na pyapasad sangaong ona na makadi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yamatigam si Isa na madari da domood kanan yang mga otaw kay antak pugusun yan na amainang ng soltan nilan. Agaw pyomanaw dayon yan aw tyomokod sang butay ng sayda nan. ");
INSERT INTO kqe_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pagkakasilum disinyan kyomadto yang mga inindowan ni Isa sang baybay ");
INSERT INTO kqe_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aw syomakay sang bangka antak bomarik silan sang longsod ng Kapirnaom. Nang gabi da aw wa pa adatung si Isa, ");
INSERT INTO kqe_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tyomaripag da silan sang linaw. Ansinyan yomoyop yang makusug na samut aw yagakadakowa yang mga baud. ");
INSERT INTO kqe_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na, pagbugsay da nilan ng lima atawa unum ka kilomitro, kikita nilan si Isa na yagapanaw sang babaw ng tobig aw yagapasingud kanilan. Aw yasaot silan ng alluk. ");
INSERT INTO kqe_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Awgaid yagalaong si Isa kanilan, “Ayaw kamo magkalluk. Ako sa yani!” ");
INSERT INTO kqe_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na, yamangkasowat da silan aw pasakaya nilan si Isa. Aw yamakadonggo dayon silan sang banwa na akadtowan nilan. ");
INSERT INTO kqe_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sonod na allaw idto pa sang dipag ng linaw yang kamangaotawan na pyapakan ni Isa. Kyakadumduman nilan na sambok gaid yang bangka ansan ng gabi aw kyakatigaman nilan na wa asakay si Isa sang bangka upud sang mga inindowan nan, awgaid silan da gaid yang lyomarga. ");
INSERT INTO kqe_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ansinyan aon mga bangka sikun sang Tibiriyas na yodonggo masaid sang logar daw wain yakakan yang mga otaw ng pan pagkatapos manginsokor ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na, pagkita ng mga otaw na waa da don si Isa aw waa oman yang mga inindowan nan, syomakay silan sinyan na mga bangka aw kyomadto silan sang Kapirnaom antak anapun nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na, pagkita nilan kang Isa adto sang dipag ng linaw, yosip nilan, “Kay Goro, akano pa kaw ani?” ");
INSERT INTO kqe_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo na pyapanganap mayo ako sabap ng yakakan aw yamangkabiyag kamo. Awgaid wa kamo makasabot sidtong katingaan na ininang ko. ");
INSERT INTO kqe_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayaw kamo magpangalingkamot sabap sang pagkan na amadonot awgaid sabap sang pagkan na makaatag ng kinabowi na way kataposan. Yani na pagkan atag kamayo ng Anak ng Manosiya na ako sagaw kay ako yang yatagan ng Tohan na Ama ng kapatot pagpangatag sinyan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ansinyan yagaosip silan kanan, “Ono yang dait nami inangun antak matoman nami yang karim ng Tohan?” ");
INSERT INTO kqe_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tyomobag si Isa, “Yani yang karim na apainang kamayo ng Tohan na mangintoo kamo kanak na syosogo nan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Yagalaong oman silan, “Ono yang katingaan na apakita mo kanami silbi tanda ng kanmo kabarakat antak mangintoo kami kanmo? Yang kanatun mga kaompowan yakan ng manna adto sang diserto magonawa sang syosorat sang Kitab na yagalaong, ‘Yatagan silan ng pagkan sikun sang sorga.’ Na ikaw, ono kowaw yang inangun mo?” ");
INSERT INTO kqe_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo na dili ni Nabi Mosa yang yagaatag kamayo ng pagkan sikun sang sorga awgaid yang kanak Ama. Aw yan oman yang yagaatag kamayo ng bunna na pagkan sikun sang sorga. ");
INSERT INTO kqe_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kay yang pagkan na yatag ng Tohan yangaong yagasikun sang sorga aw yagaatag ng kinabowi sang manosiya.” ");
INSERT INTO kqe_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ansinyan yagalaong silan kang Isa, “Kay Sir, abaya kami atagi sinyan na pagkan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yagalaong kanilan si Isa, “Ako sagaw yang pagkan na makaatag ng kinabowi. Sino-sino yang modood kanak di da amagutum. Aw sino-sino yang amangintoo kanak di da amalangga. ");
INSERT INTO kqe_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Awgaid pyagalaong da ta kamo na maskin kikita da mayo ako, di oman kamo amangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yang kariko ng mga otaw na yatag kanak ng Ama, modood kanak. Aw sino-sino yang modood kanak, di ko apapanawon. ");
INSERT INTO kqe_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay yakani ako sikun sang sorga dili antak inangun ko yang karim ko, awgaid antak inangun ko yang karim ng yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aw yani yang karim ng yagasogo kanak na di ako kawaan ng maskin isa sang kariko ng mga otaw na yatag nan kanak, awgaid na obowiun ko oman silan sang Allaw na Maori. ");
INSERT INTO kqe_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kay yani yang karim ng kanak Ama na yang kariko ng ikilaa aw yamangintoo kanak na Anak nan atagan ng kinabowi na way kataposan. Aw sang Allaw na Maori obowiun ko oman silan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ansinyan yagabagolbol yang mga Yahodi sabap sang pyagalaong ni Isa na yan kono yang pagkan na yagasikun sang sorga. ");
INSERT INTO kqe_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yagalaong silan, “Di ba yani si Isa, yang anak ni Yosop? Kikilaa sa natun yang ama aw ina nan. Nanga sa yagalaong da yan adon na sikun kono yan sang sorga?” ");
INSERT INTO kqe_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tyomobag si Isa, “Ayaw da kamo magbagolbol. ");
INSERT INTO kqe_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Way sino-sino na makadood kanak kong di silan atagan ng Ama na yagasogo kanak ng kallini sang pagdood kanak. Aw silan na modood kanak, obowiun ko oman silan sang Allaw na Maori. ");
INSERT INTO kqe_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aon syosorat ng mga nabi sang Kitab na yagalaong, ‘Yang kariko ng mga otaw indowan ng Tohan.’ Sino-sino yang amaningug aw amangagad sang pyagaindo ng Tohan na Ama, modood kanak. ");
INSERT INTO kqe_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Awgaid wa ako magalaong na aon yakakita sang Ama. Ako gaid na yagasikun sang Tohan na Ama yang yakakita kanan. ");
INSERT INTO kqe_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sang bunna-bunna pagalaong ko kamayo na sino-sino yang yamangintoo kanak kyakaonan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kay ako yang pagkan na makaatag ng kinabowi. ");
INSERT INTO kqe_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yang mga kaompowan mayo yakan ng manna adto sang diserto. Awgaid maskin ingidto yang kyakan nilan, yamangkamatay oman silan. ");
INSERT INTO kqe_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Awgaid sino-sino yang makan ng pagkan na yagasikun sang sorga, di amatay. ");
INSERT INTO kqe_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako yang bowi na pagkan na yagasikun sang sorga. Sino-sino yang makan sining pagkan amabowi taman sa taman. Yang pagkan na atag ko kanan yang kanak lawas, aw atag ko yan antak kaonan ng bunna na kinabowi yang kariko ng manosiya adi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Adon, sabap sining pyaglaongan ni Isa yanaglalisay yang mga Yahodi aw yanaginosipay silan, “Monono yang pagatag kanatun sining otaw sang kanan lawas antak kanun natun?” ");
INSERT INTO kqe_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yagalaong kanilan si Isa, “Sang bunna-bunna pagalaong ko kamayo na kong di kamo makan ng kanak onod na ako yang Anak ng Manosiya, aw di oman kamo iminum ng kanak dogo, di kamo akaonan ng kinabowi. ");
INSERT INTO kqe_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sino-sino yang makan ng kanak onod aw iminum ng kanak dogo akaonan ng kinabowi na way kataposan aw obowiun ko oman yan sang Allaw na Maori. ");
INSERT INTO kqe_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kay yang kanak onod yang bunna na pagkan aw yang kanak dogo yang bunna na mainum. ");
INSERT INTO kqe_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sino-sino yang makan ng kanak onod aw iminum ng kanak dogo, abay yan magpabilin adi kanak aw ako oman magapabilin adto kanan. ");
INSERT INTO kqe_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yang Tohan na Ama na yagasogo kanak yang pyagasikunan ng kinabowi aw yamabowi ako sabap kanan. Magonawa sinyan, sino-sino yang makan kanak, amabowi sabap kanak. ");
INSERT INTO kqe_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ako sagaw yang pagkan na yagasikun sang sorga. Dili yan magonawa sidtong manna na kyakan ng mga kaompowan mayo sangaong ona. Kay maskin kyakan nilan ingidto, yamangkamatay oman silan. Awgaid sino-sino yang makan sining pagkan na pyagalaong ko kamayo, amabowi taman sa taman.” ");
INSERT INTO kqe_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Idto yang pyagalaong ni Isa sarta yagaindo yan sang pagsasambayangan ng mga Yahodi adto sang Kapirnaom. ");
INSERT INTO kqe_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Madaig sang mga yamangagad kang Isa yamakadungug sang pyagaindo nan aw yagalaong silan, “Mairap yani na indowan. Sino yang amakadawat san?” ");
INSERT INTO kqe_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na, maskin way yagalaong kang Isa, kyakatigaman nan na yagabagolbol silan sabap sidtong pyagaindo nan. Agaw laong nan kanilan, “Yamalain kamo sabap sidtong pyagalaong ko? ");
INSERT INTO kqe_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, ono kowaw yang pagalaong mayo aw ikitaun mayo ako na Anak ng Manosiya na mabarik adto sang sorga na pyagasikunan ko? ");
INSERT INTO kqe_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yang Nyawa ng Tohan yang yagaatag ng kinabowi. Di yan amainang ng otaw. Yang pyagalaong ko kamayo yagasikun sang Nyawa ng Tohan aw makaatag kamayo ng kinabowi. ");
INSERT INTO kqe_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Awgaid aon kadaigan kamayo na di mangintoo kanak.” Yan yang pyagalaong ni Isa kay kyakatigaman nan sikun pa sang ona daw sino yang di amangintoo kanan aw sino oman yang magatraydor kanan. ");
INSERT INTO kqe_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yagalaong oman si Isa, “Idto sagaw, pyagalaong ta kamo na way maskin sino na makadood kanak aw di yan otogotan ng Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na, sikun sidto na wakto madaig yang mga yamangagad kang Isa na ibiya kanan aw wa da silan apangagad kanan. ");
INSERT INTO kqe_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sabap sinyan yosip ni Isa yang sampoo aw dowa na mga sahabat nan, “Na kamo, mibiya oman kamo kanak?” ");
INSERT INTO kqe_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tyomobag si Simon Pitros, “Kay Dato, sino pa yang akadtowan nami? Iyan gaid kanmo yang mga pyaglaongan na makaatag ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yamangintoo kami aw sang way dowa-dowa yamatigam da kami na ikaw yang sotti na syosogo ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ansinyan yagalaong si Isa, “Di ba pipili ta kamo na sampoo aw dowa? Awgaid saytan yang isa kamayo.” ");
INSERT INTO kqe_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yang pyapasabot ni Isa si Yodas na anak ni Simon Iskariyot. Kay si Yodas, maskin bunna na sambok sang sampoo aw dowa na mga sahabat, yang magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos sinyan kyomadto si Isa sang yagakatuna-tuna na mga banwa sang probinsya ng Jalil. Di nan karim komadto sang Yahodiya kay yang mga pangoo ng mga Yahodi disidto yagadumdum magpatay kanan. ");
INSERT INTO kqe_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ansinyan masaid da yang pakaradyaan ng mga Yahodi na tyatawag ng Pakaradyaan ng mga Payag. ");
INSERT INTO kqe_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Agaw pyagalaong si Isa ng mga lomon nan, “Panaw da disining banwa aw kadto sang Yahodiya antak makita ng mga yamangagad kanmo yang mga katingaan na ininang mo. ");
INSERT INTO kqe_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay di tagoon ng otaw yang mga inang nan kong karim nan mabaoy ng bantoganun. Adon kay ininang da mo yani na mga katingaan, apakita da mo gao sang tibok donya!” ");
INSERT INTO kqe_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maynan yang pyagalaong ng mga lomon ni Isa kay maskin silan wa apangintoo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yagalaong kanilan si Isa, “Wa pa adatung yang osto na wakto na makadto ako. Awgaid kamo, maskin ono na wakto makakadto kamo. ");
INSERT INTO kqe_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Di mapakay na odumtan kamo ng mga otaw adi sang donya. Awgaid ako, dyudumtan nilan ako kay yabay ako magpakatigam kanilan na maat yang ininang nilan. ");
INSERT INTO kqe_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kadto da kamo sang pakaradyaan. Awgaid di pa ako makadto kay wa pa adatung yang wakto na pyagakahanda kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na, yan yang pyagalaong ni Isa aw yagapabilin pa yan adto sang Jalil. ");
INSERT INTO kqe_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Adon, pagpanaw da ng mga lomon ni Isa, kyomadto oman yan sang pakaradyaan. Awgaid sikrito yang pagkadto nan antak di katigaman ng mga otaw na iyan yan. ");
INSERT INTO kqe_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na, adto sang pakaradyaan pyapanganap yan ng mga pangoo ng mga Yahodi aw yabay silan magosip daw wain yan. ");
INSERT INTO kqe_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Madaig yang mga otaw na yanagpatomod-tomod makapantag kang Isa. Yang kadaigan yagalaong, “Madyaw yan na otaw.” Yang kadaigan oman yagalaong, “Dili, kay lilimbongan gaid nan yang mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Awgaid wa silan magapadungug sang pyaglaongan nilan kay yamangkalluk silan sang mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, sang ikaopat na allaw ng pakaradyaan kyomadto si Isa sang Baay ng Tohan aw yagasogod yan magindo sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yamangkatingaa da yang mga pangoo ng mga Yahodi aw yagalaong silan, “Wain magasikun yang katigam sining otaw nang wa sa yan magapangadi sang mga magiindoway natun?” ");
INSERT INTO kqe_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pagdungug sinyan ni Isa, yagalaong yan, “Yang pyagaindo ko wa magasikun kanak awgaid sang Tohan na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sino-sino yang marim mangagad sang karim ng Tohan, akatigaman nan daw wain magasikun yang pyagaindo ko, daw sikun sang Tohan atawa sikun gaid adi kanak. ");
INSERT INTO kqe_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yang otaw na yagaindo ng sarili nan na katigam, karim nan na abantogon yang ginawa nan. Awgaid yang otaw na karim nan na abantogon yang yagasogo kanan, aag bunna yang pyaglaongan nan aw matorid yan na otaw. ");
INSERT INTO kqe_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Si Nabi Mosa yang yagaatag kamayo ng Hokoman, awgaid way maskin sangka otaw kamayo na yagatoman sinyan. Kay kong tyotoman mayo, na, nanga sa karim mayo ako patayun?” ");
INSERT INTO kqe_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tyomobag yang mga otaw aw laong nilan, “Kyakasaytanan kaw kowaw! Sino kadi yang marim magpatay kanmo?” ");
INSERT INTO kqe_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yagalaong kanilan si Isa, “Sambok gaid yang katingaan na ininang ko sang Allaw ng Pagpatana, aw yamangkatingaa da yang kariko mayo. ");
INSERT INTO kqe_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Si Nabi Mosa yang yagaatag kamayo ng sogowan ng pagpatoli. Awgaid yang kabunnaan, yan na sogowan wa magasikun kang Nabi Mosa kondi sang mga kaompowan mayo na yamaona pa kang Nabi Mosa. Agaw otoliun mayo yang mga anak mayo na usug maskin sang Allaw ng Pagpatana. ");
INSERT INTO kqe_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Adon, kong otoliun mayo yang sambok na isu sang Allaw ng Pagpatana kay antak matoman yang sogowan ni Nabi Mosa, na, nanga sa yamadaman kamo kanak kay pyapakadyaw ko yang tibok lawas ng otaw sang Allaw ng Pagpatana? ");
INSERT INTO kqe_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayaw kamo maglaong na maat yang ininang ng sambok na otaw kong wa pa mayo akatigami yang kabunnaan. Sosia mayo ona antak matorid yang paghokom mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ansinyan aon mga taga Awrosalam na yagalaong, “Di ba yani yang otaw na karim patayun ng mga pangoo natun? ");
INSERT INTO kqe_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tanawa! Yagaindo da yan sang mga otaw, awgaid wa silan magakontra kanan. Basin kyakatigaman da nilan na yan agaw yang Almasi na pyapasad ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Awgaid,” laong nilan, “pagdatung ng Almasi way yamatigam daw wain yan magasikun. Awgaid yani si Isa, kyakatigaman sa natun daw wain magasikun.” ");
INSERT INTO kqe_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ansinyan byobolasan ni Isa yang tingug nan sarta yagaindo yan adto sa suud ng Baay ng Tohan aw laong nan, “Bunna sagaw na kikilaa mayo ako aw kyakatigaman mayo daw wain ako magasikun. Wa ako akani sabap sang karim ko, awgaid yang yagasogo kanak, aag bunna yang pyaglaongan nan. Wa kamo ikilaa kanan ");
INSERT INTO kqe_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","awgaid ako, kikilaa ko yan kay yagasikun ako adto kanan aw yan agaw yang yagasogo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sabap sidtong pyaglaongan nan adakupun da gao yan ng mga pangoo, awgaid wa silan makadakup kanan kay wa pa adatung yang wakto na pyagakahanda kanan. ");
INSERT INTO kqe_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Awgaid madaig yang mga otaw na yamangintoo kanan aw yagalaong silan, “Pagdatung ng Almasi, makainang ba yan ng mas madaig pa na mga katingaan kaysang ininang sining otaw?” ");
INSERT INTO kqe_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ansinyan yamadungug ng mga Parisi daw ono yang pyagatomod-tomod ng mga otaw makapantag kang Isa. Agaw, silan aw yang mga pangoo ng mga imam, syosogo nilan yang mga gowardya sang Baay ng Tohan antak dakupun nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na, yagalaong si Isa, “Magapabilin pa ako adi kamayo ng tagbi gaid na panahon. Pagkatapos san magabarik ako adto sang yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Anapun mayo ako, awgaid di mayo ako ikitaun kay di kamo makakadto sang akadtowan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ansinyan yanaginosipay yang mga pangoo ng mga Yahodi, laong nilan, “Makain yan kadto na di da ta yan ikitaun? Makadto ba yan sang mga syodad ng mga Grik na idto oman magauya yang kadaigan na mga kalomonan ta na Yahodi antak indowan nan yang mga Grik? ");
INSERT INTO kqe_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yagalaong yan na anapun natun yan, awgaid di da ta yan ikitaun kay di kita makakadto sang akadtowan nan. Na, ono kowaw yang karim nan ipasabot?” ");
INSERT INTO kqe_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na, pagdatung ng kataposan na allaw ng pakaradyaan na idto yang pinakadakowa na allaw, imindug si Isa aw yagalaong ng matanog, “Sino-sino yang yamalangga, dood kamo kanak aw painumun ta kamo. ");
INSERT INTO kqe_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kay aon yamakasorat sang Kitab na yagalaong, ‘Sino-sino yang mangintoo kanak, sikun adto sa suud ng pangatayan nan imibwak yang tobig na makaatag ng kinabowi.’ ” ");
INSERT INTO kqe_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yang karim ipasabot ni Isa sidtong tobig na makaatag ng kinabowi yang Nyawa ng Tohan na madari da dawatun ng mga yamangintoo kanan. Sidto na wakto wa pa silan atagi ng Nyawa ng Tohan kay wa pa magabarik si Isa adto sang sorga. ");
INSERT INTO kqe_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Isa, aon kadaigan kanilan na yagalaong, “Yan agaw yang nabi na tyatagadan natun.” ");
INSERT INTO kqe_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aon oman kadaigan na yagalaong, “Yan yang Almasi.” Awgaid aon pay oman kadaigan na yagalaong, “Yang Almasi di magasikun sang Jalil! ");
INSERT INTO kqe_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kay yamakasorat sang Kitab na yang Almasi topo ni Soltan Daud aw amaotaw yan sang banwa ng Baytlaham na banwa oman ni Soltan Daud.” ");
INSERT INTO kqe_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Agaw yanagkalain-lain yang dumduman ng mga otaw makapantag kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yang kadaigan nilan, karim gao nilan dakupun si Isa, awgaid way maskin sambok kanilan na yamangisug pagdakup kanan. ");
INSERT INTO kqe_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ansinyan byomarik yang mga gowardya adto sang mga pangoo ng mga imam aw yang mga Parisi na yagasogo kanilan. Pagdatung nilan, yagaosip yang mga yagasogo kanilan, “Nanga sa wa mayo adakupa si Isa aw daa adi?” ");
INSERT INTO kqe_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tyomobag yang mga gowardya, “Disti-disti way otaw na magonawa kanan yang pyagaindo!” ");
INSERT INTO kqe_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yagalaong yang mga Parisi, “Astaga! Maskin oman kamo lilimbongan da nan? ");
INSERT INTO kqe_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Aon bay mga pangoo atawa mga Parisi na yamangintoo kanan? ");
INSERT INTO kqe_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Waa! Idtong kamangaotawan na wa akatigam sang Hokoman, silan yang yamangintoo kanan. Isiksaun silan ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na, sambok sang mga Parisi si Nikodimos, yang otaw na kyomadto kang Isa sangaon antak mapagbaaw kanan. Yagalaong yan kanilan, ");
INSERT INTO kqe_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Di ba sobay sang Hokoman dait ona apaningugan yang otaw antak katigaman daw ono yang ininang nan bago pa yan mahokom?” ");
INSERT INTO kqe_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tyomobag silan aw laong nilan, “Astaga! Maynang taga Jalil kaw oman. Tanawa daw ono yang yamakasorat sang Kitab. Kong basaun mo, ikitaun mo na way nabi na yagasikun sang Jalil.” ");
INSERT INTO kqe_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos sinyan yanagsiori yang kariko nilan. ");
INSERT INTO kqe_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Awgaid si Isa yakadto sang Butay ng Jayton. ");
INSERT INTO kqe_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagkailaw ng omaganay pa byomarik si Isa adto sang Baay ng Tohan. Yang kariko ng mga otaw ansan yanagtipon adto kanan. Agaw imingkod yan aw yagaindo kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ansinyan dyomatung yang mga magiindoway ng Hokoman aw yang mga Parisi na aon daa nilan na bobay na dyadatungan na yagajina. Pyapaatobang nilan yan sang mga otaw ");
INSERT INTO kqe_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aw yagalaong silan kang Isa, “Magiindoway, yani na bobay dyadatungan na yagajina. ");
INSERT INTO kqe_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sobay sang Hokoman na yatag kanatun ni Nabi Mosa, yang mayninyan na bobay dait bonoon ng bato sampay na akamatay da nan. Na ikaw, ono yang akapaglaong mo?” ");
INSERT INTO kqe_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Maynan yang osip nilan kay karim nilan porbaan si Isa paglaongon antak aon akapagoman nilan kanan. Awgaid yang ininang ni Isa, yodoko yan aw yagasorat sang lopa pinaagi sang kanan tollo. ");
INSERT INTO kqe_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Adon kay yabay pa silan magosip kanan, imindug si Isa aw yagalaong kanilan, “Sino kamayo yang way dosa, yan yang amaona magbono ng bato kanan.” ");
INSERT INTO kqe_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ansinyan yodoko da oman si Isa aw yagasorat sang lopa. ");
INSERT INTO kqe_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na, pagdungug nilan sinyan, isa-isa silan pomanaw na yamaona yang mga mangkatikadung sampay na si Isa dakman yang yamabilin aw yang bobay na yagaindug pa ansan. ");
INSERT INTO kqe_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ansinyan imindug si Isa aw yagaosip kanan, “Kay Bodi, wain da silan? Way yamabilin antak maghokom kanmo?” ");
INSERT INTO kqe_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Waa, kay Sir,” tyomobag yang bobay. Ansinyan yagalaong si Isa kanan, “Kong maynan, di oman ako magahokom kanmo na apatayun kaw. Panaw da, awgaid ayaw da magpakadosa.” ");
INSERT INTO kqe_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ansinyan yagaindo da oman si Isa sang mga otaw aw yagalaong yan, “Ako yang allag na yagaatag ng kaamdagan sang dumduman ng manosiya. Sino-sino yang amangagad kanak di da magapanaw sang kaduguuman kay iyan kanan yang allag na makaatag ng kinabowi.” ");
INSERT INTO kqe_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pagdungug sinyan ng mga Parisi, yagalaong silan, “Di amadawat yang pyagalaong mo kay yagasaksi kaw makapantag sang ginawa mo.” ");
INSERT INTO kqe_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tyomobag si Isa aw laong nan, “Maskin yagasaksi ako makapantag sang ginawa ko, bunna yang pyagalaong ko kay yamatigam ako daw wain ako magasikun aw makain ako kadto. Awgaid kamo, wa kamo akatigam daw wain ako magasikun aw makain ako kadto. ");
INSERT INTO kqe_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yang kamayo paghokom dili kasarigan kay yang syosonod mayo yang dumduman ng otaw. Awgaid ako, di ako magahokom sang abir sino. ");
INSERT INTO kqe_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Awgaid kong magahokom ako, bunna yang paghokom ko kay dili ako gaid yang magahokom kondi ako aw yang Ama na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yamakasorat sang kamayo Hokoman na bunna yang pagsaksi ng dowangka otaw aw magonawa yang pyagalaong nilan. ");
INSERT INTO kqe_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na adon, dait dawatun yang pyagalaong ko kay dowa kami na yagasaksi makapantag kanak, ako aw yang Ama na yagasogo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yagaosip yang mga Parisi, “Wain kadi yang kanmo ama?” Tyomobag si Isa, “Wa kamo ikilaa kanak aw wa oman kamo ikilaa sang kanak Ama. Kay kong kikilaa mayo ako, kikilaa oman mayo yang kanak Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yan yang pyagalaong ni Isa sarta yagaindo yan adto sang Baay ng Tohan masaid sang butanganan ng mga sidoka. Awgaid way yagadakup kanan kay wa pa adatung yang wakto na pyagakahanda kanan. ");
INSERT INTO kqe_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ansinyan yagalaong oman si Isa kanilan, “Di amadogay mapanaw da ako aw anapun mayo ako. Awgaid amatay da gaid kamo nang wa pa kamo ampona sang mga dosa mayo. Aw di kamo makakadto sang akadtowan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sabap sinyan yanaginosipay yang mga pangoo ng mga Yahodi, laong nilan, “Nanga sa yagalaong yan na di kita makakadto sang akadtowan nan? Karim nan ipasabot na magapakamatay yan?” ");
INSERT INTO kqe_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yagalaong si Isa, “Kamo taga donya, awgaid ako, sikun ako sang sorga. Sakop kamo disining donya, awgaid ako dili. ");
INSERT INTO kqe_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sabap sinyan pyagalaong da ta kamo na amatay kamo ng way kaamponan sang mga dosa mayo. Amaitabo sagaw yan kong di kamo mangintoo sang pyagalaong ko daw sino ako.” ");
INSERT INTO kqe_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Sino kaw kadi?” yagaosip silan. Tyomobag si Isa, “Pyagalaong da ta kamo sikun pa sang ona daw sino ako. ");
INSERT INTO kqe_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madaig yang akapaglaong ko makapantag kamayo na akahokom ko kamayo. Awgaid idto gaid yang pyagalaong ko sang mga otaw adi sang donya daw ono yang dyudungug ko adto sang yagasogo kanak. Aw yang kariko ng pyagalaong nan bunna.” ");
INSERT INTO kqe_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na, wa silan makasabot na pyagalaong nan silan makapantag sang Tohan na Ama. ");
INSERT INTO kqe_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Agaw yagalaong si Isa kanilan, “Pagdatung ng wakto na pyapataas da mayo ako na Anak ng Manosiya adto sang kros, akatigaman da mayo na ako sagaw daw sino yang pyagalaong ko. Akatigaman oman mayo na way ininang ko sikun gaid sang dumduman ko. Awgaid idto gaid yang pyagalaong ko daw ono yang pyagalaong kanak ng Ama. ");
INSERT INTO kqe_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yang yagasogo kanak yabay idi kanak. Wa nan ako apabayai kay maskin ono yang akasowat nan, idto yang ininang ko.” ");
INSERT INTO kqe_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Isa, madaig yang yamangintoo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ansinyan yagalaong si Isa sidtong mga Yahodi na yamangintoo kanan, “Kong abay mayo pangagadan yang pyagaindo ko, bunna kamo na mga inindowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Akatigaman da mayo yang kabunnaan, aw idto sagaw, yang kabunnaan makaatag kamayo ng kagawasan.” ");
INSERT INTO kqe_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yagalaong silan, “Oy, kami mga topo ni Nabi Ibrahim. Sikun pa sangaon, dili kami ng allang ng abir sino. Nanga sa yagalaong kaw na atagan kami ng kagawasan?” ");
INSERT INTO kqe_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo na sino-sino yang abay magpakadosa, allang yan ng kadosaan. ");
INSERT INTO kqe_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Adon, yang allang dili sakop sang baay taman sa taman, awgaid yang anak. ");
INSERT INTO kqe_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Agaw, kong yang Anak ng Tohan yang magaatag kamayo ng kagawasan, bunna na makagawas da kamo sang pagkaallang mayo. ");
INSERT INTO kqe_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yamatigam ako na mga topo kamo ni Nabi Ibrahim. Awgaid maskin maynan, karim mayo ako patayun kay di mayo adawatun yang indowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pyagalaong ko kamayo daw ono yang kikita ko adto sang kanak Ama. Kamo oman, ininang mayo daw ono yang dyudungug mayo adto sang kamayo ama.” ");
INSERT INTO kqe_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yagalaong silan, “Si Nabi Ibrahim yang kanami ama.” “Kong bunna na mga topo kamo ni Nabi Ibrahim,” yagalaong si Isa, “inangun gao mayo yang magonawa sang ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Awgaid kamo, yagadumdum sagaw kamo magpatay kanak maskin yabay ako maglaong kamayo ng kabunnaan na dyudungug ko adto sang Tohan. Dili ng maynan yang ininang ni Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yang ininang mayo magonawa sagaw sang ininang ng kamayo ama.” Yagalaong silan, “Dili kami mga anak sa labas. Yang Tohan gaid yang kanami ama!” ");
INSERT INTO kqe_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yagalaong si Isa kanilan, “Aw bunna sagaw na yang Tohan yang kamayo ama, pyapakadakowa gao mayo ako sang pangatayan mayo kay yakani ako kamayo sikun sang Tohan. Wa ako akani sabap sang karim ko, awgaid yang Tohan yang yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Di kamo makasabot sang pyagalaong ko sabap ng dili kamo makadawat sang indowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Iblis yang kamayo ama, aw kallini mayo inangun daw ono yang kyakallinian nan. Sikun pa sangaong ona mammatay da yan. Kalaban yan ng kabunnaan kay way kikita na kabunnaan adto kanan. Kong mamakak yan, batasan gaid nan ingidto kay bakakun yan aw yan yang pyagasikunan ng kariko ng bakak. ");
INSERT INTO kqe_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Awgaid ako, aag bunna yang pyaglaongan ko, agaw di kamo amangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sino kamayo yang makapaglaong na yamakadosa ako? Waa! Na, kong kabunnaan yang pyagalaong ko kamayo, nanga sa di kamo mangintoo kanak? ");
INSERT INTO kqe_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sino-sino na sakop ng Tohan amaningug sang pyaglaongan nan. Awgaid kamo, di kamo amaningug sang pyaglaongan nan kay dili kamo sakop ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ansinyan yagalaong kanan yang mga pangoo ng mga Yahodi, “Bunna sagaw yang pyagalaong nami na ikaw taga Samariya aw kyakasaytanan kaw.” ");
INSERT INTO kqe_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Wa ako akasaytani,” yagalaong si Isa. “Yaddatan ko yang kanak Ama, awgaid way addat mayo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Di ako magaanap na abantogon ako. Awgaid yang kanak Ama magaatag kanak ng kabantog, aw yan yang maghohokom. ");
INSERT INTO kqe_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sang bunna-bunna pagalaong ko kamayo na sino-sino yang amangagad sang indowan ko, di yan amatay taman sa taman.” ");
INSERT INTO kqe_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yagalaong kanan yang mga pangoo ng mga Yahodi, “Na, sang way dowa-dowa yamatigam da kami na kyakasaytanan kaw! Maskin si Nabi Ibrahim yamatay kipat sang kadaigan pa na mga nabi. Awgaid ikaw yagalaong na sino-sino yang amangagad sang indowan mo, di amatay taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nanga sa, labaw pa kaw sang kanatun ompo na si Nabi Ibrahim? Si Nabi Ibrahim patay da aw maynan oman yang kadaigan pa na mga nabi. Sino kaw kadi sang dumduman mo?” ");
INSERT INTO kqe_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tyomobag si Isa, “Kong abantogon ko yang ginawa ko, way poos yang kabantog ko. Awgaid yang yagabantog kanak yang kanak Ama na pyagalaong mayo na Tohan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wa kamo ikilaa kanan, awgaid ako, kikilaa ko yan. Kong magalaong ako na wa ko yan ikilaa, amabaoy ako ng bakakun magonawa kamayo. Awgaid bunna na kikilaa ko yan aw tyotoman ko yang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yamasowat si Nabi Ibrahim na ompo mayo pagkatigam nan na madatung yang allaw na makadi ako sang donya. Pagkita nan sinyan, yamasowat yan.” ");
INSERT INTO kqe_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ansinyan yagalaong kanan yang mga pangoo ng mga Yahodi, “Waa pay 50 yang idad mo aw kikita mo si Nabi Ibrahim?” ");
INSERT INTO kqe_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tyomobag si Isa, “Sang bunna-bunna pagalaong ko kamayo, sang wa pa akaotaw si Nabi Ibrahim, iyan da ako.” ");
INSERT INTO kqe_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pagdungug nilan sinyan, yanagpamoti silan ng bato kay antak bonoon nilan si Isa. Awgaid yamawaa si Isa sang kadaig ng mga otaw aw lyomogwa sikun sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ansinyan sarta yagapanaw silan Isa, aon kikita nilan na otaw na bota sikun pa sang pagkaotaw nan. ");
INSERT INTO kqe_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Adon, yosip si Isa ng mga inindowan nan, “Kay Goro, sino ba yang yamakadosa na yamaotaw yan na bota? Yan atawa yang taganak nan?” ");
INSERT INTO kqe_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tyomobag si Isa, “Yamaotaw yan na bota dili sabap ng yamakadosa yan atawa yang taganak nan. Awgaid yamabota yan antak kitaun ng mga otaw yang kabarakat ng Tohan sang pagpakadyaw kanan. ");
INSERT INTO kqe_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yang mga otaw yagagawbuk sarta allaw pa, kay kong gabi da, di da silan makagawbuk. Magonawa sinyan dait natun inangun yang pyapainang kanatun ng Tohan na yagasogo kanak sarta bowi pa kita. Kay madatung yang wakto na amatay da kita aw di da natun mainang. ");
INSERT INTO kqe_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sarta ini pa ako sang donya, ako yang allag na yagaatag ng kaamdagan sang dumduman ng manosiya.” ");
INSERT INTO kqe_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Paglaong sinyan, yotobad si Isa sang lopa aw inanga nan ng pasak. Pagkatapos dyadamas nan yang pasak sang mata ng bota ");
INSERT INTO kqe_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aw paglaonga nan, “Kadto sang sogbowanan ng Silowam aw pagpowamos.” Yang mana ng Silowam, Pyapadaa. Agaw kyomadto yang bota aw magpowamos. Pagkatapos, byomarik na yakakita da yan. ");
INSERT INTO kqe_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Adon, pagkita kanan ng mga simbaay nan kipat sang mga otaw na yakakita kanan sangaon nang yagapakilimos pa yan, yagaosip silan, “Di ba yan yang idtong otaw na yabay magingkod ansang kilid ng daan aw magpakilimos?” ");
INSERT INTO kqe_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tyomobag yang kadaigan, “Ud, yan ingidto.” Yang kadaigan oman yagalaong, “Dili, magonawa gaid yang parangay nilan.” Agaw yagalaong idtong otaw, “Ako sagaw yang idto.” ");
INSERT INTO kqe_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na, yagaosip silan kanan, “Nanga sa yakakita da kaw adon?” ");
INSERT INTO kqe_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tyomobag yang otaw, “Yang otaw na pyagangaanan ni Isa yagainang ng pasak aw dyadamas nan sang kanak mata. Pagkatapos san pyagalaong nan ako na makadto sang sogbowanan ng Silowam aw magpowamos. Agaw kyomadto ako, aw pagkatapos magpowamos yakakita da ako.” ");
INSERT INTO kqe_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Wain da yangaon?” yosip nilan. Tyomobag yang otaw, “Wa ako akatigam.” ");
INSERT INTO kqe_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ansinyan dyadaa nilan idtong otaw na bota sangaon adto sang mga Parisi. ");
INSERT INTO kqe_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, Allaw ng Pagpatana sidtong yagainang si Isa ng pasak aw pyapakadyaw nan yang bota. ");
INSERT INTO kqe_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Agaw yosip da oman ng mga Parisi idtong otaw daw nanga sa yakakita da yan adon. Pyagalaong nan silan, “Dyadamasan nan ng pasak yang kanak mata. Pagkatapos san yagapowamos ako, aw adon yakakita da ako.” ");
INSERT INTO kqe_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na, yagalaong da yang kadaigan ng mga Parisi, “Wa magasikun sang Tohan yang otaw na yagainang sinyan kay wa nan otomana yang sogowan makapantag sang Allaw ng Pagpatana.” Awgaid aon oman kadaigan na yagalaong, “Kong baradosa yan na otaw, di yan makainang ng katingaan na magonawa sinyan.” Aw ansinyan yanagkalain-lain yang dumduman nilan makapantag kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Agaw yosip da oman nilan idtong otaw, laong nilan, “Yagalaong kaw na pyapakadyaw nan yang kanmo mata. Na adon, ono yang akapaglaong mo makapantag kanan?” Tyomobag yang otaw, “Bain kanak, sambok yan na nabi.” ");
INSERT INTO kqe_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na, di amadawat ng mga pangoo ng mga Yahodi na yang otaw na yakakita adon, bota sangaon. Agaw pyapatawag nilan yang mga taganak nan ");
INSERT INTO kqe_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aw yosip nilan, “Anak mayo yan? Bunna agaw na bota yan sikun pa sang pagkaotaw nan? Na, kong maynan, nanga sa yakakita da yan adon?” ");
INSERT INTO kqe_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tyomobag yang taganak nan, “Bunna na anak nami yan, aw bunna oman na bota yan sikun pa sang pagkaotaw nan. ");
INSERT INTO kqe_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Awgaid wa kami akatigam daw nanga sa yakakita da yan adon atawa sino yang yagapakadyaw sang mata nan. Osipa mayo yan kay dakowa da sa yan aw makatobag yan makapantag sang ginawa nan.” ");
INSERT INTO kqe_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yan yang pyagalaong ng taganak nan kay yamalluk silan sang mga pangoo ng mga Yahodi sabap ng yanagkaoyon silan na sino-sino yang magalaong na si Isa yang Almasi, apalogwaun yan sikun sang jamaa ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Idto sagaw yagalaong yang taganak nan, “Dakowa da sa yan. Yan da yang osipun mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Agaw pyapatawag da oman nilan idtong otaw na bota sangaon aw paglaonga nilan, “Addati yang Tohan aw paglaonga yang kabunnaan. Kay yamatigam kami na yang otaw na yagapakadyaw kanmo baradosa.” ");
INSERT INTO kqe_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yagalaong idtong otaw, “Wa ako akatigam kong baradosa yan atawa dili. Basta yan gaid yang kyakatigaman ko na sangaon bota ako, awgaid adon yakakita da ako.” ");
INSERT INTO kqe_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yagaosip oman silan, “Ono yang ininang nan kanmo? Monono yang pagpakadyaw nan sang mata mo?” ");
INSERT INTO kqe_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tyomobag idtong otaw, “Pyagalaong da ta kamo, awgaid di kamo amaningug. Nanga sa yagaosip da oman kamo? Basin karim oman mayo mabaoy ng mga inindowan nan?” ");
INSERT INTO kqe_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ansinyan ininsolto nilan idtong otaw aw paglaonga nilan, “Ikaw sa yang inindowan sinyan na otaw. Awgaid kami, mga inindowan kami ni Nabi Mosa! ");
INSERT INTO kqe_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yamatigam kami na yapagbaaw yang Tohan kang Nabi Mosa. Awgaid yangaong otaw, wa kami akatigam daw wain yan magasikun.” ");
INSERT INTO kqe_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yagalaong idtong otaw, “Astaga! Wa kamo akatigam daw wain yan magasikun, awgaid pyapakadyaw nan yang kanak mata! ");
INSERT INTO kqe_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yamatigam sa kita na di atarimaun ng Tohan yang pyapangayo ng mga otaw na baradosa. Awgaid atarimaun nan yang pyapangayo ng mga otaw na yagaaddat kanan aw yagatoman sang karim nan. ");
INSERT INTO kqe_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sikun pa sang pukas ng donya way yamakadungug na aon yagapakadyaw sang otaw na bota sikun pa sang pagkaotaw nan. ");
INSERT INTO kqe_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kong yangaong otaw wa magasikun sang Tohan, way gao amainang nan.” ");
INSERT INTO kqe_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na, yagalaong da silan, “Baradosa kaw sikun pa sang pagkaotaw mo! Aw adon, indowan pa mo kami?” Aw ansinyan pyapalogwa nilan yan sikun sang jamaa ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na, pagdungug ni Isa na pyapalogwa nilan idtong otaw sikun sang jamaa ng mga Yahodi, yanap nan. Pagkita kanan, yosip nan, “Yamangintoo kaw sang Anak ng Manosiya?” ");
INSERT INTO kqe_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tyomobag idtong otaw, “Kay Sir, paglaongan kanak daw sino yan antak makapangintoo ako kanan.” ");
INSERT INTO kqe_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yagalaong si Isa, “Kikita da mo yan, aw yan agaw yang yapagbaaw kanmo adon.” ");
INSERT INTO kqe_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Kay Tagallang, yamangintoo ako kanmo,” yagalaong yang otaw aw syomojod kanan. ");
INSERT INTO kqe_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yagalaong oman si Isa, “Yakani ako sining donya antak lainun ko yang mga otaw. Kay yang mga otaw na yamangkun na main silan ng bota kay wa silan akatigam sang kabunnaan makapantag sang Tohan, akamangun ko yang pagkabota nilan antak makakita silan. Yang mga otaw oman na yagalaong na yakakita silan kay pagtoo nilan na yamatigam silan sang kabunnaan makapantag sang Tohan, pakitaun ko kanilan na silan kadi yang bota.” ");
INSERT INTO kqe_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Adon, aon mga Parisi ansang masaid kanan na yamakadungug sang pyagalaong nan aw yagaosip silan kanan, “Karim mo ba ipasabot na bota oman kami?” ");
INSERT INTO kqe_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tyomobag si Isa, “Kong adawatun mayo na bota kamo, way gao dosa mayo. Awgaid sabap ng yagalaong kamo na yakakita kamo, yagapabilin yang dosa mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ansinyan yagalaong si Isa, “Sang bunna-bunna pagalaong ko kamayo na yang otaw na di amagi sang powertaan pagsuud sang kolongan ng mga karniro awgaid mapanik sang koral, kawatan atawa tolisan. ");
INSERT INTO kqe_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Awgaid yang otaw na mosuud sang powertaan, idto yang magbabantayay ng mga karniro. ");
INSERT INTO kqe_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pasuudun yan ng yagabantay sang powertaan. Aw pagsuud nan, atawagun nan yang kanan mga karniro sang ngaan nilan aw kikilaa nilan yang tingug nan. Ansinyan adaun nan silan adto logwa. ");
INSERT INTO kqe_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paglogwa da ng kariko nilan, amaona yan kanilan aw yang mga karniro mosonod kanan kay kikilaa nilan yang tingug nan. ");
INSERT INTO kqe_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Di mosonod yang mga karniro sang otaw na wa nilan ikilaa, awgaid magapakawat silan kanan kay wa silan ikilaa sang tingug nan.” ");
INSERT INTO kqe_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na, yani yang pasombingay na pyagalaong kanilan ni Isa, awgaid wa silan makasabot sang mana sinyan. ");
INSERT INTO kqe_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Agaw yagalaong oman si Isa, “Sang bunna-bunna pagalaong ko kamayo na ako yang powertaan na agian ng mga karniro. ");
INSERT INTO kqe_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yang kariko ng mga otaw na yamaona kanak domatung aw yagaindo ng dili ng bunna, silan yang magonawa ng kawatan aw tolisan. Awgaid yang mga otaw na magonawa ng kanak mga karniro, wa silan apaningug kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako yang powertaan. Sino-sino yang mosuud pinaagi kanak amalowas. Magonawa silan sang mga karniro na mosuud aw mologwa aw makakita sang akasamsaman nilan. ");
INSERT INTO kqe_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yang kawatan madatung antak gaid magpangawat, magpatay aw mangguba. Awgaid ako, yakani ako sang donya antak atagan ko yang mga otaw ng kinabowi na madyaway aw way kolang. ");
INSERT INTO kqe_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako yang madyaw na magbabantayay ng mga karniro. Yang madyaw na magbabantayay andam sang pagpakamatay para sang mga karniro. ");
INSERT INTO kqe_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Awgaid yang otaw na byabayadan antak magbantay sang mga karniro dili ng magonawa sang magbabantayay na tagtomon ng mga karniro. Agaw, pagkita nan na madatung yang maisug na ido, madaagan yan aw ibiyaan nan yang mga karniro. Ansinyan olopogon ng maisug na ido yang mga karniro aw apakanat-kanat nan silan. ");
INSERT INTO kqe_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Madaagan idtong otaw kay byabayadan gaid ng pagbantay aw baliwaa kanan yang mga karniro. ");
INSERT INTO kqe_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ako yang madyaw na magbabantayay ng mga karniro. Yang kanak Ama ikilaa kanak, aw ako ikilaa sang kanak Ama. Magonawa sinyan kikilaa ko yang kanak mga karniro, aw silan oman ikilaa kanak. Aw andam ako magpakamatay para kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aon pay kadaigan na mga karniro ko na wa pa akasakop disining kolongan. Kinaanglan na apasuudun ko oman silan. Amaningug oman silan kanak aw ansinyan amabaoy yang kariko nilan ng sambok na panon aw sambok da yang magbabantayay nilan. ");
INSERT INTO kqe_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kyakalugunan ako ng kanak Ama kay andam ako magpakamatay antak mabowi oman ako. ");
INSERT INTO kqe_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Way sino-sino na makapatay kanak. Awgaid iklas sang pangatayan ko na atag ko yang kinabowi ko. Kay aon kapatot ko na atag ko yang kinabowi ko, aw aon oman kapatot ko na abawiun ko yan. Kay yani yang sogo kanak ng kanak Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na, sabap sinyan na pyaglaongan ni Isa yanagkalain-lain da oman yang dumduman ng mga pangoo ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yang kadaigan kanilan yagalaong, “Kyakasaytanan yan aw yamabowang! Nanga sa yamaningug kamo kanan?” ");
INSERT INTO kqe_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Awgaid aon oman kadaigan na yagalaong, “Yang otaw na kyakasaytanan dili makapaglaong ng mayninyan. Dogang pa sinyan, yang saytan di makapakadyaw sang bota!” ");
INSERT INTO kqe_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ansinyan timpo ng tingtignaw aw wakto ng pakaradyaan sang Awrosalam na tyatawag ng Pagpasotti sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na, adto si Isa sang pamanag ng Baay ng Tohan na yagapanaw-panaw sang tyatawag na Pagasilongan ni Solayman. ");
INSERT INTO kqe_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ansinyan yanagtipon adto kanan yang mga pangoo ng mga Yahodi aw yanaglaong silan, “Nanga sa di pa mo kami paglaongon daw sino kaw? Paglaongan da kanami ng diretso kong ikaw agaw yang Almasi na pyapasad ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tyomobag si Isa, “Pyagalaong da ta kamo, awgaid di kamo mangintoo kanak. Yang mga katingaan na ininang ko sabap sang kapatot ng kanak Ama, yang idto yamangimunna daw sino ako. ");
INSERT INTO kqe_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Awgaid di kamo mangintoo kay dili kamo ng mga karniro ko. ");
INSERT INTO kqe_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yang mga otaw na sakop ko na maynang mga karniro ko, yamaningug kanak. Kikilaa ko silan aw yamangagad silan kanak. ");
INSERT INTO kqe_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Atagan ko silan ng kinabowi na way kataposan aw di na di silan amabuag sang Tohan. Aw way sino-sino na makaagaw kanilan sikun sang kanak arima. ");
INSERT INTO kqe_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yatag silan kanak ng kanak Ama na labaw sang kariko. Aw way sino-sino na makaagaw kanilan sikun sang arima ng kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako aw yang kanak Ama sambok da.” ");
INSERT INTO kqe_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na, pagdungug sinyan ng mga pangoo ng mga Yahodi, yanagpamoti da oman silan ng bato antak bonoon si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Awgaid yagalaong si Isa kanilan, “Madaig yang katingaan na pyapakita ko kamayo na pyapainang kanak ng kanak Ama. Wain ansidto yang pyagasabapan na obonoon mayo ako ng bato?” ");
INSERT INTO kqe_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tyomobag yang mga Yahodi, “Dili sabap sang madyaw na mga inang mo obonoon kaw nami ng bato, awgaid sabap ng yangkun mo yang kapatot ng Tohan! Manosiya kaw gaid, awgaid yagalaong kaw na ikaw yang Tohan!” ");
INSERT INTO kqe_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yagalaong si Isa kanilan, “Di ba yamakasorat sang kamayo Kitab na yagalaong yang Tohan na ‘mga tohan kamo?’ ");
INSERT INTO kqe_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kyakatigaman natun na aag bunna yang yamakasorat sang Kitab. Na, kong ‘mga tohan’ yang tawag ng Tohan sang mga otaw na pyapadatungan nan sang kanan pyaglaongan, ");
INSERT INTO kqe_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nanga sa yagalaong kamo na yamakadosa ako sang Tohan sabap ng yagalaong ako na ako yang Anak ng Tohan? Kay pipili ako ng Ama aw syosogo nan ako adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na, kong wa ako magainang ng pyapainang kanak ng kanak Ama, ayaw kamo magpangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Awgaid kong ininang ko yang pyapainang nan kanak, na, maskin di gao kamo amangintoo sang pyaglaongan ko, pangintoowi da mayo yang mga inang ko kay antak katigaman mayo na yang Ama idi kanak, aw ako iyan sang Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na, adakupun da oman gao nilan si Isa, awgaid yamakalikay yan kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ansinyan byomarik si Isa adto sang dipag ng Yordan sang logar daw wain magasogbo sangani si Yahiya sang mga otaw. Yagapabilin yan ansan ng pilang allaw ");
INSERT INTO kqe_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","aw madaig yang mga otaw na kyomadto kanan. Yagalaong silan, “Maskin sagaw wa magainang si Yahiya ng katingaan, awgaid yang kariko ng pyagalaong nan makapantag kang Isa bunna.” ");
INSERT INTO kqe_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aw madaig yang mga otaw sidto na logar na yamangintoo kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Na, aon sambok na otaw na pyagangaanan ni Lasaro. Yagauya yan sang banwa ng Bitani upud sang mga lomon nan na si Mariyam aw si Marta. Si Mariyam yangaong bobay na yagaobo ng paballo sang siki ni Isa aw tyatrapowan nan ng kanan logay. Adon, yamasakit si Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sabap sinyan yanagtogon yang mga lomon nan na bobay adto kang Isa na yamasakit yang pyapasaya nan na amigo. ");
INSERT INTO kqe_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagdungug sinyan ni Isa, yagalaong yan, “Di yan amatay sabap sining sakit. Yamaitabo yani antak makita yang kabarakat ng Tohan aw antak mabantog oman ako na Anak nan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, dakowa sang pangatayan ni Isa yang maglomon na si Marta, si Mariyam aw si Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Awgaid maskin kyakatigaman da ni Isa na yamasakit si Lasaro, yagapabilin pa yan ansang kyakadtowan nan ng dowang allaw. ");
INSERT INTO kqe_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na, paglabay ng dowang allaw, yagalaong si Isa sang mga inindowan nan, “Anda, magabarik da kita adto sang Yahodiya.” ");
INSERT INTO kqe_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Awgaid yagalaong yang mga inindowan nan, “Kay Goro, pilang allaw pa gaid yang yalabay na byobono kaw gao ng bato ng mga pangoo ng mga Yahodi disidto! Nanga sa magabarik kaw adto?” ");
INSERT INTO kqe_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tyomobag si Isa pinaagi sang pasombingay, laong nan, “Di ba sampoo aw dowangka oras yang allaw? Kong magapanaw yang otaw sarta allaw pa, di yan amalogso kay maamdag aw kikita nan yang agianan nan. ");
INSERT INTO kqe_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Awgaid kong magapanaw yang otaw kong gabi da, amalogso yan kay maduguum aw di da nan makita yang agianan nan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pagkatapos ni Isa maglaong sinyan, yagalaong pa yan, “Yang kanatun amigo na si Lasaro yamatoog da. Awgaid makadto ako kay opokawon ko yan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yagalaong yang mga inindowan nan, “Kay Dato, aw yamakatoog yan, amadyaw da yan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yani yang pyagalaong nilan kay pagtoo nilan na yamatoog gaid si Lasaro. Awgaid yang karim ipasabot ni Isa na yamatay da si Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Agaw pyagalaong nan silan ng diretso, “Patay da si Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Awgaid sabap kamayo yamasowat ako na wa ako adto sang pagkamatay nan. Kay mallaw amangintoo da kamo kanak sabap sang ikitaun mayo. Anda, makadto da kita.” ");
INSERT INTO kqe_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ansinyan yagalaong si Tomas na tyatawag oman ng Kambal adto sang mga kaupdanan nan na mga inindowan, “Abay da, amagad kita kanan maskin pa amatay kita upud kanan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Adon, pagdatung nilan Isa sang Bitani, pyagalaong silan na opat na allaw da yang yalabay sikun sang pagkobor kang Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na, yang baryo ng Bitani masaid sang Awrosalam, mga toongka kilomitro gaid yang kawat. ");
INSERT INTO kqe_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Agaw madaig yang mga Yahodi na taga Awrosalam na yakadto kang Marta aw si Mariyam antak libadun silan sang pagkamatay ng lomon nilan. ");
INSERT INTO kqe_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Adon, pagdungug ni Marta na yagapasingud da si Isa, lyomogwa yan sikun sang baay kay osongonon nan si Isa. Awgaid si Mariyam yagapabilin adto sa suud ng baay. ");
INSERT INTO kqe_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na, pagsongon ni Marta kang Isa, yagalaong yan, “Kay Dato, aw ini pa kaw sangani, wa gao akamatay yang lomon ko. ");
INSERT INTO kqe_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Awgaid yamatigam ako na abir adon atag kanmo ng Tohan yang maskin ono na apangayoon mo.” ");
INSERT INTO kqe_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yagalaong si Isa kanan, “Amabowi oman yang lomon mo.” ");
INSERT INTO kqe_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yagalaong si Marta, “Yamatigam ako na amabowi oman yan sang Allaw na Maori sang pagkabowi oman ng mga patay.” ");
INSERT INTO kqe_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yagalaong kanan si Isa, “Ako yang makabowi oman sang mga patay aw ako yang makaatag ng kinabowi. Sino-sino yang yamangintoo kanak amabowi taman sa taman maskin amatay pa. ");
INSERT INTO kqe_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aw sino-sino yang yamabowi aw yamangintoo kanak, di yan amatay aw amabuag sang Tohan. Yamangintoo kaw sini?” ");
INSERT INTO kqe_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Ud, kay Dato,” tyomobag si Marta. “Yamangintoo ako na ikaw yang Almasi, yang Anak ng Tohan na tyatagadan nami na madatung adi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkatapos ni Marta maglaong sinyan, byomarik yan adto sang baay aw tawaga nan si Mariyam aw paglaonga nan na silan da gaid, “Ini da yang Magiindoway aw pyapatawag kaw nan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagdungug sinyan ni Mariyam, imindug yan aw yagadari-dari lomogwa kay akadtowan nan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na, sidto na wakto wa pa adatung si Isa sang baryo, awgaid idto pa yan sidtong logar daw wain yan osongona ni Marta. ");
INSERT INTO kqe_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, yang mga Yahodi na iyan sang baay upud kang Mariyam antak maglibad kanan, pagkita nilan na imindug yan aw yagadari-dari lomogwa, yosonod silan kanan. Kay pagtoo nilan na makadto yan sang kobor antak magtiyao. ");
INSERT INTO kqe_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Awgaid si Mariyam yakadto kang Isa. Pagdatung nan sidtong logar daw wain si Isa aw pagkita nan kanan, syomojod dayon yan sang atobangan nan aw laong nan, “Kay Dato, aw ini pa kaw sangani, wa gao akamatay yang lomon ko.” ");
INSERT INTO kqe_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na, pagkita ni Isa na yagatiyao si Mariyam kipat oman sang mga Yahodi na yamagad kanan, yamatangkug yang pangatayan nan aw mabugat yang ginawa nan. ");
INSERT INTO kqe_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Wain mayo okoboran si Lasaro?” yagaosip yan. “Kay Dato, agad kanami antak kitaun mo,” tyomobag silan. ");
INSERT INTO kqe_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ansinyan yagatiyao si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Agaw sa yagalaong yang mga Yahodi, “Tanawa, dakowanay si Lasaro sang pangatayan nan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Awgaid yagalaong yang kadaigan, “Di ba pyapakadyaw nan yang bota? Nanga sa wa nan atabangi si Lasaro antak di yan matay?” ");
INSERT INTO kqe_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na, ansinyan yamatangkug da oman yang pangatayan ni Isa pagdatung nan sang kobor. Sambok na langob yan na kyakatabonan ng bato. ");
INSERT INTO kqe_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Kamanga mayo yang bato,” laong ni Isa. Awgaid yagalaong si Marta na lomon ng patay, “Kay Dato, mabao da yan adon kay kyokobor da yan sa suud ng opat na allaw.” ");
INSERT INTO kqe_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yagalaong si Isa, “Di ba pyagalaong ta kaw na makakita kaw ng kabarakat ng Tohan kong amangintoo kaw?” ");
INSERT INTO kqe_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Agaw kyakamang da nilan yang bato sikun sang baba ng kobor. Ansinyan imingao si Isa aw yagalaong yan, “Kay Ama, yamanginsokor ako kanmo kay dyudungug mo yang pyapangayo ko. ");
INSERT INTO kqe_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yamatigam ako na abay mo dungugun yang maskin ono na apangayoon ko kanmo. Awgaid yagalaong ako sini sabap sang mga otaw na idi sang palibot ko kay antak mangintoo silan na ikaw agaw yang yagasogo kanak adi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Paglaong nan sinyan, yagatawag yan ng matanog, “Lasaro, logwa da!” ");
INSERT INTO kqe_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ansinyan lyomogwa si Lasaro sikun sang kobor na yamabalot yang kanan lawas ng sapot sampay sang mga arima aw siki nan, aw yamabalot oman yang parangay nan ng panyo. Yagalaong si Isa kanilan, “Obada mayo yang sapot antak makapanaw yan.” ");
INSERT INTO kqe_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na, madaig sang mga Yahodi na yagabisita kang Mariyam aw yakakita sang ininang ni Isa yang yamangintoo da kanan. ");
INSERT INTO kqe_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Awgaid yang kadaigan kanilan yakadto sang mga Parisi aw yagalaong kanilan daw ono yang ininang ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agaw, yang mga pangoo ng mga imam kipat sang mga Parisi, pyapatawag dayon nilan yang mga mimbro ng Makagwas na Hokmanan. Aw pagkatipon da nilan, yagalaong silan, “Ono yang inangun ta? Madaig da yang mga katingaan na ininang sining otaw! ");
INSERT INTO kqe_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aw apasagdan natun yan, na, di amadogay yang kariko ng mga otaw amangintoo da kanan! Kong maynan, misingani da yang mga taga Roma aw ogubaun nilan yang Baay ng Tohan kipat sang kanatun bangsa!” ");
INSERT INTO kqe_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ansinyan yagalaong yang isa kanilan na pyagangaanan ni Kayapas na yan yang Dakowa na Imam sinyan na toig, laong nan, “Yaono da kamo? ");
INSERT INTO kqe_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wa mayo odumduma na madyaw pa kong sambok gaid na otaw yang amatay para sang kariko ng mga otaw kaysang amasapad yang tibok bangsa?” ");
INSERT INTO kqe_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, wa yan magalaong sinyan sikun gaid sang kanan dumduman. Awgaid sabap ng yan yang Dakowa na Imam sinyan na toig, pyagatagna nan na si Isa yang amatay para sang bangsa Yahodi. ");
INSERT INTO kqe_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aw dili gaid para sang bangsa Yahodi kondi para oman sang kariko ng mga sakop ng Tohan na yamangkakanat-kanat sang kadaigan pa na mga bangsa kay antak magkasambok silan. ");
INSERT INTO kqe_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na, sikun sidto na allaw yanagdumdum yang mga pangoo ng mga Yahodi magpatay kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sabap sinyan wa da magapakita si Isa sang mga banwa sang Yahodiya. Awgaid kyomadto yan sang sambok na longsod na tyatawag ng Ipraim na masaid sang kamingawan. Aw yagapabilin yan ansan upud sang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na adon, masaid da yang pakaradyaan ng mga Yahodi na tyatawag ng Pakaradyaan ng Paglabay. Aw madaig yang mga otaw sikun sang yagakatuna-tuna na mga banwa na kyomadto sang Awrosalam bago pa magsogod yang pakaradyaan antak magpasotti silan sobay sang kasogowan nilan. ");
INSERT INTO kqe_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na, pyapanganap da si Isa ng mga otaw. Aw sarta yanagkatipon silan adto sang Baay ng Tohan, yanaginosipay silan, “Ono sang dumduman mayo, matambong ba si Isa sang pakaradyaan?” ");
INSERT INTO kqe_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kay sidto na wakto aon day sogo ng mga pangoo ng mga imam kipat sang mga Parisi na abir sino na yamatigam daw wain si Isa kinaanglan magoman kanilan kay antak madakup nilan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, unum na allaw koman bago magsogod yang Pakaradyaan ng Paglabay kyomadto silan Isa sang Bitani daw wain magauya si Lasaro, yang otaw na byobowi oman ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sarta adto silan sang Bitani aon yandam na paniapon para kang Isa. Si Marta yagaaya ng pagkan aw si Lasaro sambok sang mga kaupud ni Isa sang lamisa. ");
INSERT INTO kqe_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Adon si Mariyam, kyomamang yan ng paballo na ininang sikun sang tanum na nardo na yang kadaig tunga sang litro. Mahal yani na paballo aw way sagul sini. Ansinyan yobowan nan ng paballo yang siki ni Isa. Pagkatapos san tyatrapowan nan ng kanan logay. Na, yamakarimpud da yang kaballo sang tibok baay. ");
INSERT INTO kqe_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ansinyan yagalaong si Yodas Iskariyot na sambok sang mga inindowan ni Isa na yan yang magatraydor kanan, laong nan, ");
INSERT INTO kqe_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Madyaw pa aw byabarigya yani na paballo aw yang alin atag adto sang mga miskinan. Kay yang kantidad sinyan magonawa sang soweldo ng sangka otaw sa suud ng sangka toig.” ");
INSERT INTO kqe_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na, wa yan magalaong sinyan sabap ng yamalooy yan sang mga miskinan awgaid sabap ng kawatan yan. Kay si Yodas yang yagadaa sang lasakanan ng kanilan sapi aw yaanad yan magpangawat sikun sinyan. ");
INSERT INTO kqe_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","“Pabayai da gaid yan,” yagalaong si Isa. “Kay tyatagana nan yaning paballo antak andamun nan dadaan yang kanak lawas sang paglubung kanak. ");
INSERT INTO kqe_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yang mga miskinan abay mayo kaupud, awgaid ako, di ako magapabilin adi kamayo.” ");
INSERT INTO kqe_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na, madaig yang mga Yahodi na yamakadungug na iyan si Isa sang Bitani. Agaw kyomadto silan, awgaid dili gaid si Isa yang karim nilan kitaun kondi si Lasaro oman na byobowi oman ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Agaw yanagkaoyon yang mga pangoo ng mga imam na apatayun oman si Lasaro. ");
INSERT INTO kqe_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kay sabap kanan madaig yang mga Yahodi na yamangintoo kang Isa aw wa da silan apangagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sonod na allaw yamakadungug yang kamangaotawan na yagatambong sang pakaradyaan na yagapasingud da si Isa sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Agaw kyomamang silan ng mga sanga ng palmera aw lyomogwa silan sikun sang syodad antak songonon nilan si Isa na yagalaong silan ng matanog, “Pojiun ta yang Tohan! Atagan gao ng kadyawan yaning syosogo ng Tohan! Atagan gao ng kadyawan yang soltan sang bangsa Israil!” ");
INSERT INTO kqe_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ansinyan aon kikita ni Isa na sambok na nati ng asno aw syasakayan nan. Yamainang yani sobay sang yamakasorat sang Kitab na yagalaong, ");
INSERT INTO kqe_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kamo na mga taga Siyon, ayaw kamo magkalluk kay dyomatung da yang soltan mayo na yakasakay sang nati ng asno.” ");
INSERT INTO kqe_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sidto na wakto wa pa makasabot yang mga inindowan ni Isa daw ono yang mana sinyan na kyakatamanan. Awgaid pagbarik ni Isa adto sang sorga, yamakasabot da silan na yang idto na ininang ng mga otaw yang pagtoman sang yamakasorat sang Kitab makapantag kanan. ");
INSERT INTO kqe_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na, yang mga otaw na yakakita sang pagtawag ni Isa kang Lasaro sikun sang kobor kipat sang pagbowi oman kanan, silan yang yagagogod ng makapantag sinyan adto sang kadaigan na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sabap sinyan madaig yang mga otaw na yosongon kang Isa kay yamakadungug silan sidtong katingaan na ininang nan. ");
INSERT INTO kqe_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ansinyan yagalaong yang mga Parisi sang matag-isa kanilan, “Na, waa day amainang ta! Tanawa mayo, yang kariko ng mga otaw yamagad da kanan!” ");
INSERT INTO kqe_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ansinyan aon oman mga Grik na yakadto sang Awrosalam antak magpoji sang Tohan sang wakto ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yodood silan kang Pilip na sambok sang mga inindowan ni Isa na taga Bitsayda na sakop ng Jalil. Yagalaong silan kanan, “Kay Sir, karim gao nami mapagkita kang Isa.” ");
INSERT INTO kqe_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Agaw kyakadtowan ni Pilip si Andriyas, aw silan dowa yang yakadto kang Isa aw paglaonga nilan. ");
INSERT INTO kqe_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yagalaong si Isa kanilan, “Dyomatung da yang wakto na abantogon ako na Anak ng Manosiya. ");
INSERT INTO kqe_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sang bunna-bunna pagalaong ko kamayo na yang amaitabo kanak magonawa sang pagpugas ng bini. Kong yang bini di mapugas sang lopa, magapabilin yan ng sambok gaid na bini. Awgaid kong mapugas aw malubung sang lopa na maynang patay da, motobo yan aw amamonga ng madaig. ");
INSERT INTO kqe_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yang otaw na yang pyapalabi nan yang kanan ginawa, akawaan sinyan. Awgaid yang otaw na wa nan atagi ng bili yang kanan kinabowi adi sang donya, akaonan ng kinabowi na way kataposan. ");
INSERT INTO kqe_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sino-sino yang marim magtoman sang mga sogo ko, dait na mosonod yan kanak antak maskin wain ako, idto oman yang sogowanun ko. Aw idtong yotoman sang mga sogo ko abantogon ng kanak Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yagalaong oman si Isa, “Adon mabugat yang ginawa ko. Ono kowaw yang inangun ko? Apangayoon ko sang kanak Ama na olowasun nan ako sikun sining wakto ng kasikotan? Dili! Kay yakani ako antak agian ko yani na kasikotan.” ");
INSERT INTO kqe_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aw yagalaong pa yan, “O kay Ama, pakitaan gao yang kabantogan ng ngaan mo.” Ansinyan aon sowara sikun sang sorga na yagalaong, “Pyapakita da ko yang kabantogan ko, aw apakitaun ko oman.” ");
INSERT INTO kqe_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na, yang mga otaw na yagaindug ansan yamakadungug sidtong sowara aw yagalaong silan, “Yagalinti kowaw.” Awgaid aon kadaigan na yagalaong, “Aon malaikat na yapagbaaw kanan.” ");
INSERT INTO kqe_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Awgaid yagalaong si Isa, “Pyapadungug ng Tohan yani na sowara sabap kamayo, dili sabap kanak. ");
INSERT INTO kqe_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Adon dyomatung da yang wakto na hokoman ng Tohan yang mga otaw na wa apangagad kanan. Yani oman yang wakto na amatalo da nan si Iblis na yan yang yagadato ansining donya kay amakamang da kanan yang kapatot ng pagdato. ");
INSERT INTO kqe_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Awgaid ako, kong lyalansang aw pyapataas da ako adto sang kros, apadoodon ko kanak yang kariko ng mga otaw.” ");
INSERT INTO kqe_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yani yang pyagalaong ni Isa antak pakatigam nan daw ono yang pamaagi ng pagkamatay nan. ");
INSERT INTO kqe_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ansinyan yagalaong yang mga otaw, “Kyakatigaman nami na yamakasorat sang Kitab na yang Almasi di amatay. Nanga sa yagalaong kaw na yang Anak ng Manosiya dait alansang aw pataasun sang kros? Sino kadi yaning Anak ng Manosiya?” ");
INSERT INTO kqe_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tyomobag si Isa aw laong nan kanilan, “Di amadogay amawaa kamayo yang allag. Agaw, pagpanaw kamo sang kaamdagan sarta adi pa kamayo yang allag antak di kamo adatungan ng kaduguuman. Kay yang yagapanaw sang kaduguuman di matigam daw makain yan kadto. ");
INSERT INTO kqe_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pagsarig kamo kanak na ako yang allag sarta adi pa ako kamayo antak mabaoy kamo ng mga otaw na sakop sang kaamdagan.” Paglaong nan sinyan, pyomanaw yan na way yamatigam sang akadtowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na, maskin madaig da yang mga katingaan na ininang ni Isa sang atobangan ng mga otaw, wa silan apangintoo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yamainang yani antak matoman yang syosorat ni Nabi Isayas na yagalaong, “Ya Tohan, nanga sa tagbi gaid yang yamangintoo sang pyapayapat nami? Nanga sa tagbi gaid yang yamakasabot na pyapakita mo kanilan yang kanmo kabarakat?” ");
INSERT INTO kqe_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yagalaong oman si Nabi Isayas daw nanga sa wa silan apangintoo kay laong nan, ");
INSERT INTO kqe_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pyapakabota silan ng Tohan antak di silan makakita, aw pyapakatigas nan yang kanilan oo antak di silan makasabot aw di silan mabarik adi kanak,” laong ng Tohan, “kay antak pakadyawon ko silan.” ");
INSERT INTO kqe_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Maynini yang pyagalaong ni Nabi Isayas kay kikita nan dadaan yang kabantogan ni Isa aw makapantag kang Isa yani na pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na, maskin maynan, madaig yang mga pangoo ng mga Yahodi na yamangintoo kang Isa. Awgaid sabap ng yamalluk silan sang mga Parisi wa silan magapakatigam na yamangintoo silan antak di silan palogwaun sikun sang jamaa nilan. ");
INSERT INTO kqe_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kay pyapalabi nilan yang pagbantog ng mga otaw kaysang pagbantog ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ansinyan yagalaong si Isa ng matanog, “Sino-sino yang yamangintoo kanak, dili ako gaid yang pyapangintoowan nan, awgaid yamangintoo oman yan sang Tohan na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yang otaw na yakakita kanak, yakakita oman sang Tohan na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yakani ako sang donya antak magatag ng kaamdagan sang manosiya kay antak di magpabilin sang kaduguuman yang maskin sino na amangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Yang otaw na yamakadungug sang pyaglaongan ko awgaid di nan apangagadan, di ko yan hokoman. Kay yakani ako adi sang donya dili antak hokoman ko yang mga otaw awgaid antak lowasun ko silan. ");
INSERT INTO kqe_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Awgaid aon magahokom sidtong otaw na magatarikod kanak aw di amangintoo sang pyaglaongan ko. Yang pyaglaongan ko, idto sagaw yang magahokom kanan sang Allaw na Maori. ");
INSERT INTO kqe_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kay yang pyaglaongan ko dili sikun sang sarili ko na dumduman awgaid sikun sang Ama na yagapadaa kanak. Yan yang yagasogo kanak daw ono yang dait ko paglaong. ");
INSERT INTO kqe_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aw yamatigam ako na yang sogo nan makaatag ng kinabowi na way kataposan. Agaw sagaw maskin ono yang pyagasogo kanak ng Ama, idto yang pyagalaong ko.” ");
INSERT INTO kqe_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ansinyan nang wa pa magasogod yang Pakaradyaan ng Paglabay, kyakatigaman dadaan ni Isa na dyomatung da yang wakto na mapanaw da yan sikun disining donya aw magabarik yan adto sang Ama. Sikun pa sang ona dakowa sang pangatayan ni Isa yang mga otaw na kanan sakop adi sining donya. Aw adon pyapakita nan kanilan daw ono yang kadakowa ng lugun nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pagkagabi disinyan yanagpangan si Isa aw yang mga inindowan nan. Adon, si Yodas na anak ni Simon Iskariyot, byubutangan yan dadaan ni Iblis ng dumduman na magatraydor kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kyakatigaman ni Isa na yatag kanan ng Ama yang kapatot makapantag sang kariko. Aw kyakatigaman oman nan na sikun yan sang Tohan aw magabarik oman yan adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Agaw, sarta yanagpangan pa silan, imindug si Isa aw lobasa nan yang syasapaw nan na dagom aw yagatapis ng towalya. ");
INSERT INTO kqe_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pagkatapos san, yagaobo yan ng tobig sang planggana aw yagasogod yan magogas sang siki ng mga inindowan nan aw tyatrapowan nan ng towalya na kanan pyagatapis. ");
INSERT INTO kqe_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Adon, pagdood nan kang Simon Pitros, yagalaong si Pitros kanan, “Kay Dato, ikaw ba yang magaogas sang siki ko?” ");
INSERT INTO kqe_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tyomobag si Isa, “Adon wa pa kaw akatigam daw ono yang mana sining ininang ko. Awgaid sang madatung na mga allaw akatigaman da mo.” ");
INSERT INTO kqe_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yagalaong si Pitros, “Di na di ako mosogot na ikaw yang magaogas sang siki ko!” Tyomobag si Isa, “Kong di ko ogasan yang siki mo, way labot mo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yagalaong si Pitros, “Kay Dato, kong maynan, dili gaid ng siki ko yang ogasan mo awgaid maskin pa yang arima aw oo ko!” ");
INSERT INTO kqe_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yagalaong si Isa, “Yang otaw na yakasogbo, malinis da yang lawas nan. Siki dakman yang kinaanglan oman ogasan. Kamo, sotti yang pangatayan mayo, awgaid dili ng kariko mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kyakatigaman ni Isa daw sino yang magatraydor kanan aw sabap sinyan yagalaong yan na dili ng kariko nilan sotti. ");
INSERT INTO kqe_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na, pagkatapos nan ogasan yang siki ng mga inindowan nan, yamandagom da oman yan aw byomarik adto sang pyagaingkodan nan. Ansinyan yagaosip yan kanilan, “Yakasabot kamo daw ono yang ininang ko kamayo? ");
INSERT INTO kqe_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tyatawag mayo ako na Magiindoway aw Dato. Osto yan kay ako sagaw yang magiindoway aw Dato mayo. ");
INSERT INTO kqe_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, kong ako na Dato aw magiindoway mayo yang yagaogas sang siki mayo, dait na kamo oman magaogas sang siki ng kada isa kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yatagan ta kamo ng opamaan antak inangun mayo daw ono yang ininang ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sang bunna-bunna pagalaong ko kamayo na yang sogowanun dili labaw sang kanan amo, aw yang syosogo dili labaw sang yagasogo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Adon kay kyakatigaman da mayo yani na mga butang, kadyaw ng ginawa mayo kong apangagadan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na, yani na pyagalaong ko dili makapantag sang kariko mayo kay kyakatigaman ko daw sino yang pipili ko. Awgaid dait na amatoman yang yamakasorat sang Kitab na yagalaong, ‘Yang yumupud kanak koman yamainang ng kalaban ko.’ ");
INSERT INTO kqe_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Pyagalaong ta kamo sini dadaan sang wa pa yan akaitabo kay antak aw amaitabo da, amangintoo da kamo daw sino ako. ");
INSERT INTO kqe_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sang bunna-bunna pagalaong ko kamayo na yang otaw na matarima sang abir sino na osogoon ko, ako oman yang atarimaun nan. Aw yang matarima kanak, matarima oman sang yagasogo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Paglaong sinyan ni Isa, mabugat yang ginawa nan aw yagalaong yan ng diretso sang mga inindowan nan, “Sang bunna-bunna pagalaong ko kamayo na aon sangka otaw kamayo na magatraydor kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ansinyan yanagtinanaway yang mga inindowan kay wa silan akatigam daw sino yang pyagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, yang inindowan na dakowa sang pangatayan ni Isa yagaingkod ansang masaid kanan. ");
INSERT INTO kqe_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sisingyasan yan ni Simon Pitros antak osipun nan si Isa daw sino yang pyagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agaw yagasandig idtong inindowan kang Isa aw osipa nan, “Kay Dato, sino yang magatraydor kanmo?” ");
INSERT INTO kqe_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tyomobag si Isa, “Yang otaw na atagan ko sining pan pagkatapos ko daritan sang sawsawan, yan yang magatraydor kanak.” Ansinyan dyadarit nan yang pan aw yatag nan kang Yodas na anak ni Simon Iskariyot. ");
INSERT INTO kqe_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagdawat ni Yodas sang pan, syosuudan dayon yan ni Iblis. Yagalaong kanan si Isa, “Anda, pagdari aw inanga yang karim mo inangun.” ");
INSERT INTO kqe_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Awgaid way maskin isa sang mga inindowan nan na yamakasabot daw nanga sa maynidto yang pyagalaong nan kang Yodas. ");
INSERT INTO kqe_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yang kadaigan kanilan yagadumdum na syosogo nan si Yodas antak magbili ng kikinaanglan nilan para sang pakaradyaan atawa antak magatag ng sidoka adto sang mga miskinan kay si Yodas yang yagadaa sang lasakanan ng sapi nilan. ");
INSERT INTO kqe_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na, pagkatapos ni Yodas koman ng pan, lyomogwa dayon yan. Gabi da sidto na wakto. ");
INSERT INTO kqe_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagpanaw ni Yodas, yagalaong si Isa, “Adon apakita da yang kabantogan ko na Anak ng Manosiya. Aw apakita oman yang kabantogan ng Tohan sabap kanak. ");
INSERT INTO kqe_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na, kong pyapakita da yang kabantogan ng Tohan sabap kanak, apakita oman ng Tohan yang kabantogan ko na Anak ng Manosiya, aw inangun dayon nan.” ");
INSERT INTO kqe_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mga lomon ko, di da ako magadogay adi kamayo. Panganapun mayo ako, awgaid magonawa sang pyagalaong ko sang mga pangoo ng mga Yahodi, pagalaongon ta kamo adon na di kamo makakadto sang akadtowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Adon aon bago na sogowan na atag ko kamayo na paglinugunay kamo. Magonawa sang lugun ko kamayo dait na malugun oman kamo sang kada isa kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kay kong maglinugunay kamo, akatigaman ng kariko ng mga otaw na kamo mga inindowan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yagaosip si Simon Pitros, “Kay Dato, makain kaw kadto?” Tyomobag si Isa, “Di kaw makaagad kanak sang akadtowan ko adon. Awgaid sang madatung na mga allaw makasonod da kaw kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yagaosip oman si Pitros, “Kay Dato, nanga sa di ako makaagad kanmo adon? Andam ako magpakamatay para kanmo.” ");
INSERT INTO kqe_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yagalaong si Isa, “Andam ba kaw magpakamatay para kanak? Sang bunna-bunna pagalaong ko kanmo na sang di pa magatagaok yang laboyo, makatoo kaw maglaong na wa kaw ikilaa kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ansinyan yagalaong si Isa sang mga inindowan nan, “Ayaw kamo magkarido. Pagsarig sang Tohan aw pagsarig oman kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adto sang baay ng kanak Ama madaig yang mga kowarto. Kong di yan ng bunna, di ako magalaong kamayo na makadto da ako antak andamun ko yang pagauyaan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na, pagkatapos aw maandam da ko, magabarik ako adi aw paagadun ta kamo kay antak daw wain ako, idto oman kamo. ");
INSERT INTO kqe_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aw kyakatigaman mayo yang daan pasingadto sang akadtowan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ansinyan yagalaong si Tomas kanan, “Kay Dato, wa nami akatigami daw makain kaw kadto. Monono da nami katigaman yang daan?” ");
INSERT INTO kqe_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tyomobag si Isa, “Ako yang daan, yang kabunnaan aw yang kinabowi. Way makakadto sang Ama kong dili pinaagi kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kong kikilaa mayo ako, kikilaa oman mayo yang kanak Ama. Aw sikun adon kikilaa da mayo yan aw kikita da mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yagalaong si Pilip, “Kay Dato, pakitaan gao kanami yang Ama. Aw osto da yan para kanami.” ");
INSERT INTO kqe_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yagalaong si Isa, “Pilip, dogay da ako adi kamayo, awgaid wa pa kaw ikilaa kanak? Sino-sino yang yakakita kanak, yakakita oman sang Ama. Nanga sa yagalaong kaw na ‘pakitaan gao kanami yang Ama?’ ");
INSERT INTO kqe_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nanga kaw, kay Pilip, wa kaw apangintoo na yagakasambok kami sang Ama ko? Yang pyagaindo ko kamayo dili sikun kanak. Awgaid yang Ama na idi kanak, yan yang yagainang sang mga gawbuk na ininang ko. ");
INSERT INTO kqe_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pangintoowi mayo yang pyagalaong ko na iyan ako sang Ama aw yang Ama idi kanak. Kong di kamo mangintoo sang pyaglaongan ko, na, pagpangintoo da kamo sabap sang mga katingaan na ininang ko. ");
INSERT INTO kqe_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sang bunna-bunna pagalaong ko kamayo na sino-sino yang mangintoo kanak, makainang yan sang ininang ko. Aw labaw pa sinyan yang amainang nan kay magabarik ako adto sang kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aw abir ono yang apangayoon mayo sang ngaan ko inangun ko kay antak mabantog yang Ama sabap kanak na Anak nan. ");
INSERT INTO kqe_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sagaw, kong mangayo kamo sang ngaan ko, abir ono yang apangayoon mayo, inangun ko.” ");
INSERT INTO kqe_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yagalaong oman si Isa, “Kong pyapakadakowa mayo ako sang pangatayan mayo, apangagadan mayo yang mga sogowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aw pangayoon ko sang Ama na atagan nan kamo ng isa koman na Magtatambagay poli kanak na magapabilin kamayo taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yani na Magtatambagay yang Nyawa ng Tohan na magaindo kamayo ng kabunnaan. Yang mga otaw na kadodonya gaid yang dumduman di makatarima sang Nyawa ng Tohan kay wa nilan ikitaa aw wa oman nilan ikilaa. Awgaid kamo, ikilaa kamo kanan kay iyan yan kamayo aw magauya yan sa suud ng pangatayan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na, maskin mapanaw da ako, di ta kamo ibiyaan kay magabarik oman ako adi kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Di amadogay di da ako ikitaun ng mga otaw adi sang donya. Awgaid kamo, makakita oman kamo kanak. Sabap ng bowi ako taman sa taman, kamo oman amabowi taman sa taman. ");
INSERT INTO kqe_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pagdatung sinyan na allaw, akatigaman da mayo na yagakasambok kami sang kanak Ama aw magonawa sinyan, yagakasambok ako kamayo aw kamo oman yagakasambok kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sino-sino yang matarima sang mga sogowan ko aw apangagadan nan, yan yang otaw na yagapakadakowa kanak sang kanan pangatayan. Aw yang otaw na yagapakadakowa kanak sang kanan pangatayan, dakowa oman sang pangatayan ng kanak Ama. Magonawa sinyan, dakowa yan sang kanak pangatayan aw apakatigam ko kanan daw sino ako.” ");
INSERT INTO kqe_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ansinyan yagalaong si Yodas, awgaid dili ni Yodas Iskariyot, laong nan, “Kay Dato, nanga sa kami gaid yang apakatigamun mo makapantag sang sarili mo aw dili yang kariko ng mga otaw?” ");
INSERT INTO kqe_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tyomobag si Isa, “Sino-sino yang yagapakadakowa kanak sang kanan pangatayan, apangagadan nan yang pyaglaongan ko. Dakowa yan sang pangatayan ng kanak Ama, aw yang kanak Ama aw ako magauya adto sang pangatayan nan. ");
INSERT INTO kqe_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sino-sino yang wa magapakadakowa kanak sang kanan pangatayan, di nan apangagadan yang pyaglaongan ko. Yani na pyaglaongan na dyudungug mayo dili sikun kanak awgaid sikun sang Ama na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yani na mga butang pyagalaong ko kamayo sarta idi pa ako kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Awgaid yang Magtatambagay, yang Nyawa ng Tohan na apadaa kamayo ng Ama poli kanak, yan yang magaindo kamayo ng kariko ng mga butang aw magapadumdum kamayo ng kariko ng pyagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kalinaw sang pangatayan aw dumduman mayo yang ibilin ko kamayo. Yani na kalinaw yagasikun kanak aw di yan magonawa sang kalinaw na akaatag ng mga otaw adi sang donya. Agaw, ayaw kamo magkarido aw ayaw oman kamo magkalluk. ");
INSERT INTO kqe_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Pyagalaong da ta kamo na mapanaw ako aw magabarik oman ako adi kamayo. Kong dakowa ako sang pangatayan mayo, amasowat gao kamo na makadto ako sang kanak Ama kay labaw pa yan kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pyagalaong da ta kamo sini sang wa pa yan akaitabo kay antak aw amaitabo da, amangintoo da kamo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na, di da ko pataasun yang pagalaong ko kamayo kay madari da domatung yang pangoo na yagadato ansining donya. Awgaid way kapatot nan kanak. ");
INSERT INTO kqe_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Awgaid maskin maynan, otogotan ko yang amaitabo kanak antak katigaman ng mga otaw adi sang donya na kyakalugunan ko yang kanak Ama aw inangun ko yang kariko ng pyagasogo nan kanak. “Abay da. Mapanaw da kita.” ");
INSERT INTO kqe_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ansinyan yagalaong oman si Isa sang mga inindowan nan, “Ako yang bunna na ponowan ng tyatanum aw yang kanak Ama yang yagaatiman sinyan. ");
INSERT INTO kqe_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yang kariko ng mga sanga na di amamonga, opotolon ng kanak Ama. Awgaid yang kariko ng mga sanga na yamamonga, ototowan aw ilinisan nan antak magkadaig yang bonga. ");
INSERT INTO kqe_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamo, lilinisan da kamo sabap sang pyagaindo ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pagpabilin kamo adi kanak aw ako magapabilin adto kamayo. Yang sanga na di magapabilin sang ponowan, di amamonga. Magonawa sinyan, di kamo amamonga kong di kamo magapabilin adi kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Pyapadayon ni Isa yang pasombingay, laong nan, “Ako yang ponowan ng tyatanum aw kamo yang mga sanga. Sino-sino yang magapabilin adi kanak aw ako magapabilin adto kanan, amamonga ng madaig. Awgaid kong mibiya kamo kanak, way amainang mayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sino-sino yang di magapabilin adi kanak magonawa yan sang sanga na itimbag aw amagango. Yang mayninyan na mga sanga itiponon aw timbagan adto sang atoon antak sonogon. ");
INSERT INTO kqe_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Awgaid kong abay kamo magpabilin adi kanak aw yang mga pyaglaongan ko magapabilin sang pangatayan mayo, atag ko kamayo yang abir ono na apangayoon mayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kong amamonga kamo ng madaig, amabantog yang kanak Ama. Aw ansinyan akatigaman na kamo bunna na mga inindowan ko. ");
INSERT INTO kqe_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kyakalugunan ako ng Ama. Magonawa sinyan kyakalugunan ta kamo. Agaw pagpabilin kamo sang lugun ko. ");
INSERT INTO kqe_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kong apangagadan mayo yang mga sogowan ko, magapabilin kamo sang lugun ko magonawa kanak na pyapangagadan ko yang mga sogowan ng kanak Ama aw yagapabilin ako sang lugun nan. ");
INSERT INTO kqe_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Pyagalaong ta kamo sini antak kaonan kamo ng kasowat na magonawa sang kasowat ko aw antak makomplito yang kasowat mayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yani yang sogo ko kamayo na paglinugunay kamo magonawa sang lugun ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Way lugun na labaw pa sang lugun ng otaw na magapakamatay para sang mga amigo nan. ");
INSERT INTO kqe_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamo, mga amigo ta kamo kong apangagadan mayo yang mga sogo ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Di da ta kamo tawagun na mga sogowanun kay yang sogowanun wa akatigam daw ono yang inangun ng amo nan. Awgaid kamo, tyatawag ta kamo na mga amigo ko kay pyapakatigam ta kamo sang kariko ng dyudungug ko adto sang kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dili kamo yang yagapili kanak, awgaid ako yang yagapili kamayo aw pipili ta kamo antak mamonga kamo aw yang bonga mayo magapabilin taman sa taman. Aw ansinyan abir ono yang apangayoon mayo adto sang Ama sang ngaan ko, atag nan kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na, yani yang sogo ko kamayo na paglinugunay kamo.” ");
INSERT INTO kqe_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yagalaong oman si Isa sang mga inindowan nan, “Ayaw kamo magkatingaa kong odumtan kamo ng mga otaw na kadodonya gaid yang dumduman. Dumduma da gaid mayo na ako yang ona na dyudumtan nilan. ");
INSERT INTO kqe_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kong magonawa kamo sang mga otaw na kadodonya gaid yang dumduman, kyakallinian gao kamo nilan. Awgaid tuna kamo kay pipili ta kamo aw pyagalain ta kamo sinyan na mga otaw. Agaw sagaw dyudumtan kamo nilan. ");
INSERT INTO kqe_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na, dumduma mayo yang pyagalaong ko kamayo na yang sogowanun dili labaw sang amo nan. Kong pyapakasikotan nilan ako, kamo da oman yang apakasikotan nilan. Kong pyapangagadan nilan yang mga pyaglaongan ko, apangagadan oman nilan yang mga pyaglaongan mayo. ");
INSERT INTO kqe_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yang kariko sinyan inangun nilan kamayo sabap sang pagpangintoo mayo kanak kay wa nilan ikilaa yang Tohan na yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kong wa ako akani sang donya aw magaindo kanilan ng kabunnaan, way gao dosa nilan. Awgaid adon, di silan makapaglaong na way dosa nilan kay pyapakatigam ko kanilan yang kabunnaan. ");
INSERT INTO kqe_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sino-sino yang yagadumut kanak, yagadumut oman sang kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kong wa nilan ikitaa yang mga katingaan na ininang ko na wa akainang ng abir sino, way gao dosa nilan. Awgaid kikita da nilan, aw maskin maynan, dyudumtan nilan ako aw yang kanak Ama. ");
INSERT INTO kqe_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Awgaid yamainang yani antak matoman yang yamakasorat sang Kitab na yagalaong, ‘Dyudumtan ako nilan na waa say pyagasabapan.’ ” ");
INSERT INTO kqe_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Laong oman ni Isa, “Apadaa ko kamayo yang Magtatambagay, yang Nyawa ng Tohan na magaindo kamayo ng kabunnaan. Makani yan sikun sang Ama aw pagdatung nan, magalaong yan ng makapantag kanak. ");
INSERT INTO kqe_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kamo oman, dait kamo magpakatigam sang mga otaw ng makapantag kanak kay sikun sang pirmiro yamagad kamo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na, yang kariko sinyan yang pyagalaong ko kamayo antak di mawaa yang pagpangintoo mayo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sang madatung na mga allaw apalogwaun kamo sikun sang jamaa ng mga Yahodi. Madatung sagaw yang wakto na sino-sino yang magapatay kamayo magadumdum na pyapangagadan nilan yang karim ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yani yang inangun nilan kamayo kay wa silan ikilaa sang Ama aw wa oman silan ikilaa kanak. ");
INSERT INTO kqe_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pyagalaong ta kamo sini kay antak pagdatung ng wakto na inangun da nilan yani kamayo, akadumduman mayo yang pyagalaong ko kamayo. Sangaon wa ta kamo paglaonga sini na mga butang kay iyan pa ako kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Awgaid adon magabarik ako sang yagasogo kanak. Awgaid way maskin sambok kamayo na yagaosip daw makain ako kadto. ");
INSERT INTO kqe_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aw adon na pyagalaong da ta kamo, mabugatay yang ginawa mayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Awgaid bunna yaning pagalaong ko kamayo na mas madyaw kamayo na mapanaw ako. Kay kong di ako mapanaw, di makani yang Magtatambagay. Awgaid kong mapanaw ako, apadaa ko yan kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pagdatung ng Magtatambagay, apakatigam nan sang mga otaw na wa apangagad sang Tohan na sayup yang dumduman nilan makapantag sang dosa, apakatigam nan kanilan daw ono yang pamaagi ng Tohan na amainang ng matorid yang manosiya, aw apakatigam nan kanilan daw ono yang paghokom ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Apakatigam nan sang mga otaw na yamakadosa silan kay wa silan apangintoo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Apakatigam nan kanilan na mapakay silan mainang ng matorid kay makadto ako sang Ama aw di da mayo ako ikitaun. ");
INSERT INTO kqe_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aw apakatigam nan kanilan makapantag sang paghokom ng Tohan na yokoman da si Iblis, yang pangoo na yagadato ansining donya. ");
INSERT INTO kqe_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na, madaig pa gao yang pagalaong ko kamayo awgaid di pa mayo masabot adon. ");
INSERT INTO kqe_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Awgaid pagdatung ng Nyawa ng Tohan na yan yang magaindo ng kabunnaan, atabangan nan kamo pagsabot sang kariko ng kabunnaan. Yang pagaindo nan dili sikun kanan, awgaid daw ono yang dyudungug nan, idto gaid yang pagalaong nan kamayo. Aw apakatigam nan kamayo daw ono yang amaitabo sang madatung na mga allaw. ");
INSERT INTO kqe_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Atagan nan ako ng kabantog kay sikun kanak yang apakatigam nan kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yang maskin ono na kanang Ama, kanak oman. Agaw sagaw pyagalaong ko kamayo na yang kariko ng apakatigam kamayo ng Nyawa ng Tohan yagasikun kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yagalaong oman si Isa, “Di amadogay di da mayo ako ikitaun, awgaid di oman amadogay aw ikitaun da oman mayo ako.” ");
INSERT INTO kqe_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na, yanaginosipay da yang kadaigan ng mga inindowan nan, laong nilan, “Ono yang karim nan ipasabot sining pyagalaong nan na di amadogay di da natun yan ikitaun, aw di oman amadogay aw ikitaun da oman natun? Aw yagalaong pa yan na amaitabo yan sabap ng makadto yan sang Ama. ");
INSERT INTO kqe_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ono kadi yang karim nan ipasabot sang di amadogay? Di gaid kita makasabot sang pyagalaong nan!” ");
INSERT INTO kqe_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, kyakatigaman ni Isa na karim gao magosip kanan yang mga inindowan nan, agaw yagalaong yan kanilan, “Di ba yanaginosipay kamo daw ono yang karim ko ipasabot sang pyagalaong ko na di amadogay di da mayo ako ikitaun, aw di oman amadogay aw ikitaun da oman mayo ako? ");
INSERT INTO kqe_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sang bunna-bunna pagalaong ko kamayo na yang mga otaw na wa apangagad sang Tohan amasowat, awgaid kamo magatiyao sabap sang kabugat ng ginawa mayo. Awgaid amawaa oman yang kabugat ng ginawa mayo aw amabaoy ng kasowat. ");
INSERT INTO kqe_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Magonawa yan sang sambok na bobay na yagapamati kay dyomatung da yang wakto na amanganak da yan. Awgaid pagkaotaw da ng isu, akaringawan da nan yang kairap nan sabap ng yamasowat yan na yamaotaw da yang isu. ");
INSERT INTO kqe_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Magonawa sinyan yang kabutang mayo. Adon mabugat yang ginawa mayo, awgaid magakita oman kita. Aw ansinyan amasowat kamo aw way maskin sino na makaagaw sang kasowat mayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na, pagdatung sinyan na allaw, di da kinaanglan na magaosip pa kamo kanak ng maskin ono. Sang bunna-bunna pagalaong ko kamayo na abir ono yang apangayoon mayo sang Ama sang ngaan ko, atag nan kamayo. ");
INSERT INTO kqe_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sikun sangaon sampay adon wa pa kamo makapangayo ng maskin ono sang ngaan ko. Agaw, pangayo kamo kay atagan kamo aw ansinyan amakomplito yang kasowat mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yagalaong oman si Isa, “Pyagalaong ta kamo sini na mga butang pinaagi sang mga pasombingay. Awgaid madatung yang wakto na di da ako magapasombingay, awgaid diretso da yang pagalaong ko kamayo makapantag sang Ama. ");
INSERT INTO kqe_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pagdatung sinyan na allaw, kamo da yang amangayo adto sang Ama sang ngaan ko. Di da kinaanglan na ako pa yang amangayo adto sang Ama para kamayo ");
INSERT INTO kqe_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kay kyakalugunan kamo ng Ama. Dakowa kamo sang pangatayan nan kay pyapakadakowa mayo ako sang pangatayan mayo aw yamangintoo kamo na ako yagasikun sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bunna sagaw na yagasikun ako sang Ama aw yakani ako sang donya. Aw adon mapanaw da ako disining donya aw magabarik ako adto sang Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ansinyan yagalaong yang mga inindowan ni Isa, “Adon diretso da yang pyagalaong mo aw di da pinaagi sang pasombingay. ");
INSERT INTO kqe_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yamatigam da kami adon na kyakatigaman mo yang kariko ng mga butang aw di da kinaanglan na magaosip pa kami kanmo. Sabap sinyan yamangintoo kami na ikaw yagasikun sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yagalaong si Isa, “Yamangintoo da kamo kanak adon? ");
INSERT INTO kqe_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Awgaid timani mayo na madatung yang wakto aw ini da yan adon na amangkakanat-kanat kamo obos. Managsiori da kamo sang matag baay mayo aw ibiyaan mayo ako. Awgaid maskin maynan, di ako ng sayda ko kay yang Ama yagapabilin adi kanak. ");
INSERT INTO kqe_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Na, pyagalaong ta kamo sini na mga butang antak kaonan kamo ng kalinaw sabap sang pagkasambok mayo kanak. Bunna na adi sang donya apakasikotan kamo. Awgaid pakatigsuna mayo yang pangatayan mayo kay dyadaog da ko yang kaatan adi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkatapos ni Isa maglaong sinyan, imingao yan adto sang langit aw yagadowaa, laong nan, “O kay Ama, dyomatung da yang wakto na pyagakahanda mo. Apakita mo gao adon yang kabantogan ko na Anak mo antak apakita ko oman yang kabantogan mo. ");
INSERT INTO kqe_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kay yatagan mo ako ng kapatot makapantag sang kariko ng manosiya antak atagan ko ng kinabowi na way kataposan yang kariko ng mga otaw na yatag mo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aw yani yang kinabowi na way kataposan na yamatigam silan na ikaw gaid yang bunna na Tohan aw yamatigam oman silan na ako yang Almasi na syosogo mo adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pyapakita ko yang kabantogan mo adi sang donya kay tyatapos da ko yang gawbuk na pyapainang mo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aw adon, kay Ama, pagbarik ko adto kanmo, atagi oman ako ng kabantogan magonawa sang kabantogan ko sidtong wakto na idto pa ako kanmo nang wa pa akabaoy yang donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pyapakatigam ko daw sino kaw adto sang mga otaw na pipili mo sikun disining donya aw yatag mo kanak. Kanmo da silan sangaon aw yatag mo silan kanak. Aw pyapangagadan nilan yang pyaglaongan mo. ");
INSERT INTO kqe_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aw adon kyakatigaman nilan na yang kariko ng yatag mo kanak yagasikun kanmo. ");
INSERT INTO kqe_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kay pyagaindo ko kanilan yang pyagalaong mo kanak aw tyatarima nilan ingidto. Kyakatigaman da sagaw nilan na ako yagasikun kanmo aw yamangintoo silan na ikaw yang yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Adon magadowaa ako para kanilan. Yani na pagdowaa ko dili para sang kariko ng manosiya awgaid para sang mga otaw na yatag mo kanak kay kanmo silan. ");
INSERT INTO kqe_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yang kariko na kanak, kanmo oman aw yang kariko na kanmo, kanak oman. Aw yamabantog ako sabap kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Di da ako magadogay ansining donya kay magabarik da ako adto kanmo. Awgaid silan, magapabilin pa silan ansining donya. O kay Ama na labi na sotti, bantayi silan antak mabantog yang ngaan mo na ngaan ko oman. Bantayi silan antak abay silan magkasambok magonawa sang pagkasambok natun. ");
INSERT INTO kqe_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sarta yumupud pa ako kanilan, byabantayan aw yatiman ko silan antak mabantog yang ngaan mo na ngaan ko oman. Aw way maskin isa kanilan na yamawaa adi kanak yatabiya sidtong otaw na pyagakahanda mo na isiksaun sang narka kay antak matoman yang yamakasorat sang Kitab. ");
INSERT INTO kqe_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Adon madari da ako magbarik adto kanmo, awgaid sarta ini pa ako sang donya pagalaongon ko silan sining mga butang antak makomplito yang kasowat nilan magonawa sang kasowat ko. ");
INSERT INTO kqe_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pyapakatigam ko kanilan yang pyaglaongan mo aw dyudumtan da silan ng mga otaw na wa apangagad kanmo kay di da silan ng magonawa kanilan. Kay magonawa silan kanak na dili ako sakop ng donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Di ako amangayo na akamangun mo silan disining donya, awgaid yani yang pangayo ko na bantayan mo silan antak di silan daogon ni Iblis na pyagasikunan ng kariko ng kaatan. ");
INSERT INTO kqe_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yang mga otaw na sakop mo magonawa kanak kay wa silan apangagad sang dumduman ng kadaigan na mga otaw adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pagalainun mo gao silan sang pagpangagad kanmo pinaagi sang pyaglaongan mo na magaindo kanilan ng kabunnaan. ");
INSERT INTO kqe_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Magonawa sang pagsogo mo kanak adi sang donya syosogo ko silan pagpayapat sang mga otaw adi sang donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Atag ko yang kinabowi ko sabap kanilan antak pagalainun oman silan sang pagpangagad kanmo. ");
INSERT INTO kqe_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Adon, dili gaid ng mga inindowan ko yang pagadowaan ko awgaid yang mga otaw oman na amangintoo kanak sabap sang pagpayapat nilan. ");
INSERT INTO kqe_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O kay Ama, pangayoon ko na magakasambok yang dumduman aw pangatayan ng kariko nilan na magonawa sang pagkasambok natun na ikaw idi kanak, aw ako iyan kanmo. Magonawa oman sinyan, magakasambok gao silan kanatun antak mangintoo yang mga otaw adi sang donya na ikaw yang yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yatag ko kanilan yang kabantogan na yatag mo kanak antak magkasambok silan magonawa kanatun na sambok da kita. ");
INSERT INTO kqe_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yagakasambok ako kanilan aw ikaw yagakasambok kanak. Amakomplito gao yang pagkasambok ng dumduman aw pangatayan nilan antak katigaman ng mga otaw adi sang donya na ikaw yang yagasogo kanak aw katigaman oman nilan na yang lugun mo kanilan magonawa sang lugun mo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O kay Ama, karim ko na yang mga otaw na yatag mo kanak makaupud kanak adto sang sorga antak kitaun nilan yang kabantogan ko na idto yang kabantogan na yatag mo kanak sabap ng kyakalugunan da mo ako nang wa pa akabaoy yang donya. ");
INSERT INTO kqe_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O kay Ama, ikaw gaid yang matorid. Yang mga otaw adi sang donya wa ikilaa kanmo. Awgaid ako, kikilaa ta kaw aw kyakatigaman ng mga yamangintoo kanak na ikaw yang yagasogo kanak. ");
INSERT INTO kqe_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pyapakatigam ko kanilan daw sino kaw aw padayonon ko yang pagpakatigam ko kanilan antak yang lugun nilan sang matag-isa magonawa sang lugun mo kanak aw antak abay ako magpabilin sang pangatayan nilan.” ");
INSERT INTO kqe_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ansinyan pagkatapos magdowaa ni Isa, pyomanaw yan upud sang mga inindowan nan aw tyomaripag silan sang Tobig ng Kidron. Adto dipag kyomadto silan sang sambok na tanumanan. ");
INSERT INTO kqe_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Adon, si Yodas na yan yang yagatraydor kang Isa, kyakatigaman nan idtong tanumanan kay yabay managkatipon ansan si Isa aw yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Agaw kyomadto si Yodas sidtong tanumanan na aon pyagaagad nan na sangka panon ng mga sondao na taga Roma aw mga gowardya sang Baay ng Tohan na syosogo ng mga pangoo ng mga imam aw yang mga Parisi. Aon daa nilan na mga saasa, mga lampara aw mga armas. ");
INSERT INTO kqe_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Adon si Isa, kyakatigaman nan yang kariko ng amaitabo kanan. Agaw, pagdatung ng mga sondao aw gowardya, syosongon nan silan aw yosip nan, “Sino yang yanap mayo?” ");
INSERT INTO kqe_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tyomobag silan, “Si Isa na taga Nasarit.” Yagalaong si Isa, “Ako ingidto.” Na, si Yodas na yagatraydor kang Isa, imindug ansan upud sang mga sondao aw gowardya. ");
INSERT INTO kqe_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Paglaong ni Isa na “Ako ingidto,” yamatras silan aw yamangkatomba sang lopa. ");
INSERT INTO kqe_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yosip da oman silan ni Isa, laong nan, “Sino agaw yang yanap mayo?” Tyomobag oman silan, “Si Isa na taga Nasarit.” ");
INSERT INTO kqe_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yagalaong si Isa, “Pyagalaong da ta kamo na ako ingidto. Kong ako yang yanap mayo, pabayai da gaid yaning mga kaupdanan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yani yang pyagalaong ni Isa antak matoman yang pyaglaongan nan sang pagdowaa nan, “O kay Ama, wa akawaa kanak yang maskin isa sang mga otaw na yatag mo kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ansinyan gyagabot ni Simon Pitros yang lodyo na kanan tyatakos aw titibas nan yang sogowanun ng Dakowa na Imam. Aw yang karinto na taringa nan yamapotol. Yang ngaan sidtong sogowanun si Malkos. ");
INSERT INTO kqe_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yagalaong si Isa kang Pitros, “Barikan yang kanmo lodyo sang tagob! Yagadumdum ba kaw na di ko pagsabaran yang kasikotan na pyagakahanda kanak ng Ama?” ");
INSERT INTO kqe_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ansinyan dyadakup si Isa ng mga sondao na taga Roma kipat sang kapitan nilan upud sang mga gowardya na bangsa Yahodi aw gyagapos nilan. ");
INSERT INTO kqe_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pagkatapos san dyadaa nilan mona yan adto kang Anas, yang ogangan ni Kayapas na yan yang Dakowa na Imam sinyan na toig. ");
INSERT INTO kqe_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kayapas idtong yagatambag sang mga pangoo ng mga Yahodi na mas madyaw na sambok na otaw gaid yang amatay kaysang kariko ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, si Simon Pitros aw yang sambok oman na inindowan yagasonod kang Isa. Yang inyan na inindowan kikilaa ng Dakowa na Imam, agaw yakasuud yan upud kang Isa sang pamanag ng baay ng Dakowa na Imam. ");
INSERT INTO kqe_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Awgaid si Pitros yamabilin adto logwa apit sang powertaan. Ansinyan yologwa da oman yang inindowan na kikilaa ng Dakowa na Imam aw pagkatapos nan mapagbaaw sang bobay na yagabantay sang powertaan pyapasuud nan si Pitros. ");
INSERT INTO kqe_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ansinyan yagalaong idtong bobay kang Pitros, “Di ba inindowan kaw sidtong otaw na dyadakup nilan?” Tyomobag si Pitros, “Dili.” ");
INSERT INTO kqe_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Adon, yang mga sogowanun aw yang mga gowardya yodook ng oring kay matignaw sidto na gabi. Yagaindug silan sang palibot ng atoon antak kapasowan silan. Na, yodood si Pitros kanilan antak kapasowan oman yan. ");
INSERT INTO kqe_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ansinyan yosip si Isa ni Anas, na dati na Dakowa na Imam, makapantag sang mga inindowan nan kipat sang pyagaindo nan sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tyomobag si Isa, “Klaro yang pagindo ko sang mga otaw kay yabay ako magindo adto sang mga pagsasambayangan aw sang Baay ng Tohan na ansan yagakatipon yang kariko ng mga Yahodi. Way pyagaindo ko ng sikrito. ");
INSERT INTO kqe_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nanga sa ako yang yosip mo makapantag sang pyagaindo ko? Madyaw pa aw osipun mo yang mga otaw na yamakadungug kanak kay kyakatigaman nilan daw ono yang pyagaindo ko kanilan.” ");
INSERT INTO kqe_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na, paglaong sinyan ni Isa, syasampal yan ng sambok na gowardya na yagaindug sang masaid kanan aw laong nan kanan, “Way addat mo. Ayaw pagtobaga yang Dakowa na Imam ng mayninyan!” ");
INSERT INTO kqe_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tyomobag si Isa, “Kong aon pyagalaong ko na maat, apakatigam mo gao sang kariko ng mga otaw adi sang hokmanan daw ono yang sayup ko. Awgaid kong madyaw yang pyagalaong ko, na, nanga sa syasampal mo ako?” ");
INSERT INTO kqe_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ansinyan pyapadaa ni Anas si Isa na gyagapos pa adto kang Kayapas na yan yang Dakowa na Imam sinyan na toig. ");
INSERT INTO kqe_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, sarta yagaindug pa si Simon Pitros adto sang masaid sang atoon antak kapasowan yan, yosip yan ng mga otaw, laong nilan, “Di ba ikaw oman yang sambok na inindowan sidtong otaw?” Awgaid yagalaong si Pitros, “Dili oy!” ");
INSERT INTO kqe_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ansinyan yosip oman yan ng sambok na sogowanun ng Dakowa na Imam na parinti nidtong otaw na titibasan ni Pitros ng taringa, laong nan, “Di ba kikita ta kaw adto sang tanumanan na yamagad kaw kang Isa?” ");
INSERT INTO kqe_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na, yagalaong da oman si Pitros na dili kono yan ng inindowan nan. Aw sidto na wakto yagatagaok yang laboyo. ");
INSERT INTO kqe_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Adon, nang omaganay da dyadaa nilan si Isa sikun sang baay ni Kayapas adto sang palasyo ng gobirnador na taga Roma. Awgaid wa osuud yang mga pangoo ng mga Yahodi sang palasyo ng gobirnador kay sobay sang kabatasanan nilan amabatar kono silan kong mosuud silan sang baay ng dili ng Yahodi. Aw kong amabatar silan sidto na allaw, di da silan makakan sang kandori sang Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sabap sinyan lyomogwa si Pilato adto kanilan aw yagaosip yan daw ono yang kaso nilan sini na otaw. ");
INSERT INTO kqe_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tyomobag silan, “Kong wa yan makadosa, wa gao nami adaa adi kanmo.” ");
INSERT INTO kqe_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yagalaong si Pilato, “Daa mayo yan aw kamo da yang magahokom kanan sobay sang Hokoman mayo.” Awgaid yagalaong yang mga pangoo ng mga Yahodi, “Waa say kapatot nami paghokom na apatayun yang sambok na otaw.” ");
INSERT INTO kqe_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na, yamainang yang kariko sinyan antak matoman yang pyagalaong ni Isa daw ono yang pamaagi ng pagkamatay nan. ");
INSERT INTO kqe_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ansinyan syomuud da oman si Pilato sang palasyo aw pyapatawag nan si Isa aw yosip nan, “Ikaw ba yang soltan ng mga Yahodi?” ");
INSERT INTO kqe_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yagalaong si Isa, “Yani na osip sikun ba kanmo atawa pyagalaong kaw ng kadaigan makapantag kanak?” ");
INSERT INTO kqe_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yagalaong si Pilato, “Sang pagtanaw mo, Yahodi ako? Yang mga imamanwa mo aw yang mga pangoo ng mga imam, silan yang yagadaa kanmo adi kanak. Ono kadi yang dosa mo?” ");
INSERT INTO kqe_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tyomobag si Isa, “Yang kanak pyagadatowan dili adi sining donya. Kay kong adi sining donya yang pyagadatowan ko, malaban gao yang mga yamangagad kanak antak di ako madakup ng mga pangoo ng mga Yahodi. Awgaid, yang kabunnaan, dili adi sining donya yang pyagadatowan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yagalaong si Pilato, “Kong maynan, soltan kaw!” Yagalaong si Isa, “Na, pyagalaong da mo na soltan ako. Awgaid yakani ako sining donya aw yagapakaotaw ako antak pakatigam ko yang kabunnaan. Aw sino-sino yang marim mangagad sang kabunnaan amaningug sang pyaglaongan ko.” ");
INSERT INTO kqe_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yagalaong si Pilato, “Ono kadi yang kabunnaan?” Paglaong sinyan ni Pilato, lyomogwa da oman yan adto sang mga Yahodi aw laong nan kanilan, “Way kikita ko na dosa na dait yan hokoman. ");
INSERT INTO kqe_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Awgaid aon kabatasanan mayo na kada Pakaradyaan ng Paglabay palogwaun ko yang sambok na piniriso. Na, karim mayo na apalogwaun ko yang soltan ng mga Yahodi?” ");
INSERT INTO kqe_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na, yamangiyak da yang mga otaw, “Dili yan! Si Barabas yang palogwaa!” Adon, si Barabas sambok na rebelde. ");
INSERT INTO kqe_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ansinyan syosogo ni Pilato na abadasan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pagkatapos san kyomamang yang mga sondao ng mga sanga ng kaoy na soksokon aw ininang nilan ng korona aw byubutang nilan sang oo ni Isa. Aw pyapandagoman oman nilan yan ng joba na mapowa na magonawa sang dagom ng soltan. ");
INSERT INTO kqe_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Isa-isa silan domood kang Isa aw yagalaong silan, “Madyaw yang soltan ng mga Yahodi!” Aw syasampal nilan. ");
INSERT INTO kqe_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ansinyan lyomogwa da oman si Pilato adto sang mga otaw aw laong nan kanilan, “Paningug! Apalogwaun da ko si Isa adi kamayo antak katigaman mayo na way kikita ko na dosa nan.” ");
INSERT INTO kqe_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na, lyomogwa da si Isa na aon korona na soksokon sang oo nan aw pyandagoman ng joba na mapowa. Aw yagalaong si Pilato sang mga otaw, “Tanawa, idi da yang otaw.” ");
INSERT INTO kqe_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkita kanan ng mga pangoo ng mga imam kipat sang mga gowardya sang Baay ng Tohan, yamangiyak silan, “Alansang yan sang kros! Alansang yan sang kros!” Awgaid yagalaong si Pilato, “Daa da mayo yan aw kamo da yang magpalansang kanan sang kros kay bain kanak way kikita ko na dosa nan na dait ko yan hokomon na apatayun.” ");
INSERT INTO kqe_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yagalaong oman yang mga pangoo ng mga Yahodi, “Aon kanami Hokoman, aw sobay sining Hokoman dait yan patayun kay yagalaong yan na Anak kono yan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagdungug sinyan ni Pilato, kyakadogangan pa yang alluk nan. ");
INSERT INTO kqe_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dyadaa da oman nan si Isa adto sa suud ng palasyo aw yosip nan, “Taga wain kaw?” Awgaid wa otobag si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yagalaong kanan si Pilato, “Nanga sa wa kaw otobag kanak? Wa kaw akatigam na aon kapatot ko na obooyan ta kaw aw aon oman kapatot ko na apalansang kaw sang kros?” ");
INSERT INTO kqe_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tyomobag si Isa, “Kong wa kaw atagi ng Tohan ng kapatot, way kapatot mo paghokom kanak. Agaw sagaw mas dakowa yang dosa ng otaw na yagadaa kanak adi kanmo kaysang dosa mo.” ");
INSERT INTO kqe_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagdungug sinyan ni Pilato, yagaanap yan ng pamaagi na akabooyan nan si Isa. Awgaid yang mga Yahodi yagapadayon mangiyak, laong nilan, “Kong palogwaun mo yani na otaw, di da kaw ng amigo ng soltan sang Roma kay sino-sino yang magpakasoltan, kalaban yan ng soltan sang Roma.” ");
INSERT INTO kqe_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Adon, pagdungug ni Pilato sang pyagalaong ng mga Yahodi, dyadaa nan si Isa adto logwa aw imingkod yan sang ingkodanan ng maghohokom adto sang logar na tyatawag ng Pamanag na Batoon na kong sang tiniyaban na Hibrani, Gabata. ");
INSERT INTO kqe_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na, allaw sidto ng pagpangandam para sang Pakaradyaan ng Paglabay aw mga alas sais ng omaga. Ansinyan yagalaong si Pilato sang mga Yahodi, “Tanawa, idi da yang soltan mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Awgaid yamangiyak silan, “Pataya yan! Pataya yan! Alansang yan sang kros!” Yagaosip si Pilato, “Karim mayo na apalansang ko sang kros yang soltan mayo?” “Way tuna na soltan nami yatabiya yang soltan sang Roma!” tyomobag yang mga pangoo ng mga imam. ");
INSERT INTO kqe_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na, sang orian, yatag da nan kanilan si Isa antak alansang sang kros. Ansinyan dyadaa si Isa ng mga sondao. ");
INSERT INTO kqe_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pyapapusan nilan kang Isa yang kaoy na pagalansangan kanan aw lyomogwa silan sikun sang syodad sampay na dyomatung silan sang logar na tyatawag ng Logar ng Oo ng Kalabira na kong sang tiniyaban na Hibrani, Golgota. ");
INSERT INTO kqe_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Disidto lyalansang nilan si Isa sang kros. Aw aon oman dowangka otaw na lyalansang nilan sang kros, yang sambok sang karinto ni Isa aw yang sambok sang kawaa nan. ");
INSERT INTO kqe_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na, aon syosorat ni Pilato na pyapabutang nan sang kaoy na pyagalansangan kang Isa. Aw yani yang syosorat nan, “Si Isa na taga Nasarit, Soltan ng mga Yahodi.” ");
INSERT INTO kqe_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Madaig yang mga Yahodi na yamakabasa sinyan kay yang logar na pyagalansangan kang Isa masaid sang syodad ng Awrosalam aw syosorat yang idto sang toongka tiniyaban na magonawa sang Hibrani, yang tiniyaban ng mga taga Roma, aw yang Grik. ");
INSERT INTO kqe_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ansinyan kyomadto yang mga pangoo ng mga imam kang Pilato aw yagalaong silan, “Yang syosorat mo dili ng madyaw. Dili gao ng ‘Soltan ng mga Yahodi’ yang syosorat mo kondi ‘Yani na otaw yagalaong na yan kono yang soltan ng mga Yahodi.’ ” ");
INSERT INTO kqe_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tyomobag si Pilato, “Yang syosorat ko di da amaisab.” ");
INSERT INTO kqe_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na, pagkatapos ng mga sondao paglansang kang Isa sang kros, kyakamang nilan yang mga dagom nan aw pyagabain-bain nilan sang opat kay antak yang kada isa kanilan kaonan ng sangka bain. Kyakamang oman nilan yang mataas na dagom nan na yabul sikun sa taas pababa na way sogpat. ");
INSERT INTO kqe_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ansinyan yagalaong yang mga sondao sang matag-isa, “Di ta yani alasiun. Magaripa da gaid kita antak katigaman daw sino yang makaangkun sini.” Na, yamainang yani antak matoman yang yamakasorat sang Kitab na yagalaong, “Pyagabain-bain nilan yang kanak mga dagom, aw pyagaripaan nilan yang dagom ko na mataas.” Na, idto sagaw yang ininang ng mga sondao. ");
INSERT INTO kqe_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Adon, sang masaid sang kros na pyagalansangan kang Isa yagaindug yang kanan ina aw yang lomon na bobay ng kanan ina, aw si Mariyam na asawa ni Klopas kipat kang Mariyam na taga Magdala. ");
INSERT INTO kqe_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagkita ni Isa na yagaindug ansan yang kanan ina aw yang inindowan na dakowa sang pangatayan nan, yagalaong yan sang kanan ina, “Kay ina, yani na inindowan ko, anak da mo adon.” ");
INSERT INTO kqe_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aw yagalaong oman yan sang inindowan nan, “Yang ina ko, ina da mo adon.” Agaw, sikun sidto na wakto pyapaguya nidtong inindowan yang ina ni Isa sang kanan baay. ");
INSERT INTO kqe_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Adon kyakatigaman da ni Isa na yang kariko ng pyapainang kanan yamatapos da. Aw antak matoman yang yamakasorat sang Kitab yagalaong yan, “Yamalangga ako.” ");
INSERT INTO kqe_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na, aon disidto sambok na lasakanan na pono ng aslum na bino. Pagdungug ng mga sondao sang pyagalaong ni Isa, kyomamang silan ng ispongha aw tuguma nilan sang bino. Pagkatapos, byubutang nilan sang sanga ng isopo aw diwian nilan sang baba ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagsupsup sinyan ni Isa, yagalaong yan, “Tapos da!” Ansinyan yudumul yan aw yamabogto da yang napas nan. ");
INSERT INTO kqe_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, allaw sidto ng pagpangandam para sang Allaw ng Pagpatana. Dakowa yan na allaw sang mga Yahodi kay yakatunung sang Pakaradyaan ng Paglabay. Sabap sinyan kyomadto yang mga pangoo ng mga Yahodi kang Pilato aw yamangayo silan na abariun yang mga bitis ng mga otaw na lyalansang sang kros antak madari silan matay kay antak makamang yang lawas nilan sang wa pa magasogod yang Allaw ng Pagpatana. ");
INSERT INTO kqe_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Na, kyomadto da yang mga sondao aw byabari nilan yang mga bitis nidtong dowangka otaw na lyalansang sang kros upud kang Isa. ");
INSERT INTO kqe_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Awgaid pagdood nilan kang Isa, kikita nilan na patay da. Agaw, wa da nilan abaria yang mga bitis nan. ");
INSERT INTO kqe_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Awgaid yang ininang ng sambok na sondao, tyotosok nan ng bangkaw yang kilid ni Isa aw ansan dayon yoboos yang dogo aw tobig. ");
INSERT INTO kqe_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na, yang otaw na yakakita sinyan yamakasaksi na bunna yani na yamaitabo. Yamatigam yan na bunna yang pyagalaong nan aw yamangimunna yan sinyan antak mangintoo oman kamo. ");
INSERT INTO kqe_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yamainang yang kariko sinyan antak matoman yang yamakasorat sang Kitab na yagalaong, “Way amabari kanan, maskin sambok na pusa.” ");
INSERT INTO kqe_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aw aon oman yamakasorat sang Kitab na yagalaong, “Magatanaw silan sang otaw na tyotosok nilan.” ");
INSERT INTO kqe_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Adon, aon sambok na otaw na taga Arimatiya na yang ngaan nan si Yosop. Yani si Yosop yamangintoo oman kang Isa awgaid ng sikrito kay yamalluk yan sang mga pangoo ng mga Yahodi. Ansinyan kyomadto yan kang Pilato aw yamangayo na otogotan yan na akamangun nan yang lawas ni Isa sikun sang kros. Aw tyotogotan yan ni Pilato. Agaw kyomadto yan aw kamanga nan yang lawas ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yamagad kanan si Nikodimos, yang otaw na kyomadto sangaon kang Isa antak mapagbaaw kanan ng gabi. Aon dyadaa nan na paballo na ininang sikun sang mga tanum na mira aw aloe na yang kabugat sobra sang 30 ka kilo. ");
INSERT INTO kqe_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ansinyan kyakamang nilan yang lawas ni Isa aw syasapot nilan ng mapoti aw butangi ng paballo kay idto yang kabatasanan ng mga Yahodi sang pagkobor sang mga patay. ");
INSERT INTO kqe_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, masaid sang logar na pyagalansangan kang Isa aon sambok na tanumanan. Aw sa suud ng tanumanan aon sambok na kobor na pyagalongagan sang bato na baya pa inanga aw wa pa okobori. ");
INSERT INTO kqe_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na, sabap ng madari da magsogod yang Allaw ng Pagpatana aw masaid oman yang inyan na kobor, iyan da nilan obutangan si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pagkaomaga ng Domingo nang maduguum pa, kyomadto si Mariyam na taga Magdala sang kobor ni Isa. Pagdatung nan ansan, kikita nan na kyakamang da yang bato na yakatabon sang baba ng kobor. ");
INSERT INTO kqe_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Agaw dyomaagan yan adto kang Simon Pitros kipat sang inindowan na dakowa sang pangatayan ni Isa aw laong nan kanilan, “Kyakamang nilan yang lawas ng kanatun Dato sikun sang kobor. Wa nami akatigami daw wain nilan obutangan!” ");
INSERT INTO kqe_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ansinyan kyomadto dayon sang kobor si Pitros aw yang sambok oman na inindowan. ");
INSERT INTO kqe_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dyomaagan silan dowa, awgaid kyakabiyaan si Pitros kay mas makusug domaagan idtong sambok na inindowan aw yamaona yan domatung sang kobor. ");
INSERT INTO kqe_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ansang kobor isilib yan adto sa suud aw kikita nan yang sapot na yamakabutang ansan. Awgaid wa yan osuud sang kobor. ");
INSERT INTO kqe_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ansinyan dyomatung da oman si Simon Pitros aw idiretso yan pagsuud sang kobor. Pagsuud nan, kikita nan yang sapot ");
INSERT INTO kqe_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kipat sang panyo na pyagabalot sang oo ni Isa. Yamalopi yang panyo aw wa yan itipona sang sapot, awgaid yamakalain yan pagbutang. ");
INSERT INTO kqe_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Adon syomuud oman yang inindowan na yamaona domatung sang kobor. Pagkita nan na iyan san yang mapoti awgaid waa da don si Isa, yamangintoo yan na yamabowi oman yan. ");
INSERT INTO kqe_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Sidto na wakto wa pa silan makasabot sidtong yamakasorat sang Kitab na dait mabowi oman si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ansinyan yomori da idtong dowa na inindowan. ");
INSERT INTO kqe_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Awgaid si Mariyam, iyan pa yan magaindug sa logwa ng kobor aw yagatiyao. Aw sarta yagatiyao yan, isilib yan adto sa suud ng kobor. ");
INSERT INTO kqe_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pagsilib nan, aon kikita nan na dowa na malaikat na yamandagom ng mapoti aw yagaingkod sang dati na kyakabutangan ng lawas ni Isa, yang sambok sang apit ng oo, yang sambok sang apit ng siki. ");
INSERT INTO kqe_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yagalaong yang mga malaikat kanan, “Kay Bodi, nanga sa yagatiyao kaw?” Tyomobag si Mariyam, “Kyakamang nilan yang lawas ng kanak Dato aw wa ako akatigam daw wain nilan obutangan.” ");
INSERT INTO kqe_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Paglaong nan sinyan, ilingi yan aw kikita nan si Isa na yagaindug ansan, awgaid wa nan ikilaa si Isa. ");
INSERT INTO kqe_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yagaosip si Isa kanan, “Kay Bodi, nanga sa yagatiyao kaw? Sino yang yanap mo?” Yagadumdum si Mariyam na yan yang yagaatiman sang tanumanan. Agaw yagalaong yan, “Kong ikaw yang yakamang sang lawas nan, paglaonga ako daw wain mo obutangan kay antak kadtowan ko aw akamangun ko.” ");
INSERT INTO kqe_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yagalaong si Isa kanan, “Mariyam.” Ansinyan yapagatobang si Mariyam kanan aw yagalaong yan sang tiniyaban na Hibrani, “Rabboni!” na yang mana san Goro. ");
INSERT INTO kqe_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yagalaong si Isa, “Ayaw da ako pagkuputi kay wa pa ako magabarik adto sang Ama. Awgaid kadtoni yang mga kalomonan ko aw paglaonga silan na magabarik da ako adto sang kanak Ama na Ama oman mayo, sang Tohan ko na Tohan oman mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ansinyan kyakadtowan ni Mariyam na taga Magdala yang mga inindowan ni Isa aw paglaonga silan na kikita nan yang kanilan Dato aw pyapakatigam nan kanilan daw ono yang pyagalaong kanan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkagabi sinyan na Domingo yanagkatipon yang mga inindowan ni Isa sang sambok na baay. Sisiradowan nilan yang mga powertaan kay yamalluk silan sang mga pangoo ng mga Yahodi. Sakadyap dyomatung si Isa aw imindug ansang tunga nilan aw yagalaong kanilan, “Assalamo alaykom!” ");
INSERT INTO kqe_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Paglaong nan sinyan, pyapakita nan kanilan yang mga pari sang arima aw kilid nan. Aw dakowa yang kasowat ng mga inindowan pagkita nilan sang kanilan Dato. ");
INSERT INTO kqe_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yagalaong oman si Isa kanilan, “Salam kamayo. Adon osogoon ta kamo magonawa sang pagsogo kanak ng Ama.” ");
INSERT INTO kqe_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagkatapos san yoyopan nan yang mga inindowan nan aw laong nan, “Tarimaa mayo yang Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kong amponon mayo yang mga otaw sang mga dosa nilan, yampon da silan ng Tohan. Awgaid kong di mayo silan amponon, wa silan ampona ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Adon, sang wakto na yagapakita si Isa sang mga inindowan nan, waa ansan si Tomas na tyatawag ng Kambal na sambok oman sang sampoo aw dowa na mga sahabat ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sabap sinyan pyagalaong yan ng kadaigan na mga inindowan na kikita nilan yang kanilan Dato. Awgaid yagalaong si Tomas kanilan, “Kong di ko ikitaun sang dowa na mata ko aw di ko masadsad ng tollo ko yang agi ng lansang sang mga arima nan aw di ko masadsad yang pari sang kilid nan, di ako amangintoo sang pyagalaong mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Adon, paglabay ng sangka simana, yanagkatipon da oman yang mga inindowan ni Isa sa suud ng baay aw kaupud nilan si Tomas. Sirado yang mga powertaan, awgaid sakadyap dyomatung si Isa aw imindug ansang tunga nilan aw laong nan, “Assalamo alaykom!” ");
INSERT INTO kqe_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pagkatapos san yagalaong yan kang Tomas, “Tanawa yang mga arima ko aw kuputi. Sadsada oman yang pari sang kilid ko. Ayaw da magdowa-dowa, awgaid pagpangintoo da!” ");
INSERT INTO kqe_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tyomobag si Tomas, “Ikaw yang Dato aw Tohan ko!” ");
INSERT INTO kqe_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yagalaong si Isa kanan, “Adon yamangintoo da kaw kay kikita mo ako. Awgaid kadyaw ng ginawa sidtong mga otaw na yamangintoo kanak maskin wa silan ikita kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, madaig pa yang mga katingaan na ininang ni Isa aw kikita ng mga inindowan nan na wa akasorat ansini na Kitab. ");
INSERT INTO kqe_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Awgaid yang yamakalasak sini na Kitab yamasorat antak mangintoo kamo na bunna agaw na si Isa yang Almasi, yang Anak ng Tohan, aw antak kaonan kamo ng kinabowi na way kataposan sabap sang pagpangintoo mayo kanan. ");
INSERT INTO kqe_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ansinyan paglabay ng pilang allaw, yagapakita oman si Isa sang mga inindowan nan adto sang kilid ng Linaw ng Tibiriyas. Maynini yang pagpakita nan kanilan. ");
INSERT INTO kqe_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yanagkatipon silan Simon Pitros, si Tomas na tyatawag ng Kambal, si Natanyal na taga Kana sang probinsya ng Jalil, yang dowa na anak ni Sibidi aw dowa koman na mga inindowan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ansinyan yagalaong si Simon Pitros kanilan, “Amanagat ako.” Yagalaong silan, “Amagad kami.” Agaw pyomanaw da silan, sakay sang sambok na bangka aw yagapalaod silan. Awgaid way yamakamang nilan sidto na gabi. ");
INSERT INTO kqe_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sang pagsilat ng suga yagaindug si Isa adto sang baybay. Awgaid wa ikilaa kanan yang mga inindowan nan. ");
INSERT INTO kqe_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yagatawag si Isa kanilan, laong nan, “Mga lomon, aon yamakamang mayo?” Tyomobag silan, “Waa.” ");
INSERT INTO kqe_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yagalaong si Isa, “Taktaka mayo yang pokot sang karinto ng bangka aw ansinyan aon amakamang mayo.” Na, tyataktak da nilan yang pokot aw wa da nilan mabira sabap sang kadaig ng isda na yamakamang nilan. ");
INSERT INTO kqe_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ansinyan yagalaong kang Pitros yang inindowan na dakowa sang pangatayan ni Isa, “Yang Dato yang idto!” Pagdungug sinyan ni Pitros, tyatapis nan yang kanan dagom na lyolobas nan aw layog sang dagat kay malangoy adto baybay. ");
INSERT INTO kqe_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yang mga kaibanan nan sang bangka yagabugsay pasingadto sang baybay na gyogoyod yang pokot na pono ng isda. Dili ng mawat yang pyagabugsayan nilan, mga 50 ka dupa da gaid. ");
INSERT INTO kqe_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagdonggo nilan sang baybay, kikita nilan na aon disidto dyodook na oring na aon isda na pyapasagan aw aon oman mga pan. ");
INSERT INTO kqe_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yagalaong si Isa kanilan, “Daa kamo adi ng pilamboos na isda na yamakamang mayo.” ");
INSERT INTO kqe_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Agaw yasakay da oman si Simon Pitros sang bangka aw bibira nan adto saka yang pokot na pono ng mangkadakowa na isda na 153 ka boos yang kadaig. Awgaid maskin maynini yang kadaig ng isda, wa akalasi yang pokot nilan. ");
INSERT INTO kqe_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yagalaong si Isa kanilan, “Adi kamo aw kan da kamo.” Na, way maskin isa sang mga inindowan na yamangisug magosip daw sino yan kay kyakatigaman nilan na yan yang Dato nilan. ");
INSERT INTO kqe_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ansinyan yodood si Isa, kyakamang nan yang pan aw yatag nan sang mga inindowan nan. Maynan oman yang ininang nan sang isda. ");
INSERT INTO kqe_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, yani yang ikatoo na pagpakita ni Isa sang mga inindowan nan sikun sidtong wakto na yamabowi oman yan. ");
INSERT INTO kqe_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkatapos nilan koman, yagalaong si Isa kang Simon Pitros, “Simon, anak ni Yahiya, yang lugun mo kanak labaw ba kay sining mga kaibanan mo?” Tyomobag si Pitros, “Ud, kay Dato, yamatigam kaw na dakowa kaw sang pangatayan ko.” Yagalaong si Isa, “Na, kong maynan, atimana yang mga otaw na sakop ko magonawa sang pagatiman sang mga karniro.” ");
INSERT INTO kqe_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yagaosip oman si Isa, “Simon, anak ni Yahiya, bunna agaw na dakowa yang lugun mo kanak?” Tyomobag si Pitros, “Ud, kay Dato, yamatigam kaw na dakowa kaw sang pangatayan ko.” Yagalaong si Isa, “Na, kong maynan, atimana yang mga otaw na sakop ko magonawa sang pagatiman sang mga karniro.” ");
INSERT INTO kqe_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Awgaid adon yagaosip si Isa kang Pitros ng ikatoo, “Simon, anak ni Yahiya, dakowa ba ako sang pangatayan mo?” Na, yamarido da si Pitros kay sang ikatoo na osip yagaosip si Isa daw dakowa ba yan sang pangatayan nan. Aw tyomobag si Pitros, “Kay Dato, yamatigam kaw sang kariko aw kyakatigaman mo na dakowa kaw sang pangatayan ko.” Yagalaong si Isa kanan, “Na, kong maynan, atimana yang mga otaw na sakop ko magonawa sang pagatiman sang mga karniro. ");
INSERT INTO kqe_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sang bunna-bunna pagalaong ko kanmo na sangaong isu pa kaw, ikaw yang yagabakos sang sarili mo aw kyomadto kaw abir wain yang karim mo. Awgaid kong matikadung da kaw, padupaun kaw aw ikutan kaw ng lain na otaw aw adaun kaw sang logar na di mo karim kadtowan.” ");
INSERT INTO kqe_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yani yang pyagalaong ni Isa antak pakatigam nan daw ono yang pamaagi ng pagkamatay ni Pitros, aw sabap sinyan na pagkamatay amabantog nan yang Tohan. Pagkatapos san yagalaong si Isa kang Pitros, “Agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Adon, paglingi ni Pitros, kikita nan na yosonod kanilan yang inindowan na dakowa sang pangatayan ni Isa. Yani na inindowan yang yagasandig kang Isa sidtong wakto na yanagpaniapon silan aw yagaosip kanan daw sino yang magatraydor kanan. ");
INSERT INTO kqe_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkita kanan ni Pitros, yosip nan si Isa, “Kay Dato, ono yang akatamanan nan?” ");
INSERT INTO kqe_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tyomobag si Isa, “Kong karim ko na amabowi yan sampay sang pagbarik ko adi sang donya, way labot mo. Awgaid ikaw, agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na, sabap sidto na pyaglaongan ni Isa yamakarimpud adto sang mga kalomonan yang gogodanun na di kono amatay ingidtong inindowan. Awgaid wa magalaong si Isa na di yan amatay kondi yagalaong yan, “Kong karim ko na amabowi yan sampay sang pagbarik ko adi sang donya, way labot mo.” ");
INSERT INTO kqe_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na, yang inindowan na pyagalaong ni Isa yan yang yamangimunna sini na mga butang aw yan mismo yang yagasorat sini. Aw kyakatigaman nami na bunna yang pyagalaong nan. ");
INSERT INTO kqe_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na, madaig pa yang mga ininang ni Isa na wa akasorat disini. Awgaid kong yamasorat pa yang kariko ng mga ininang nan, na, basin di amalasak adi sining donya yang kadaig ng mga Kitab na dait soratun. Wassalam ");
INSERT INTO kqe_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kay Dato Tiyopilo, sang pirmiro na sorat ko gyogogod ko yang kariko ng ininang aw pyagaindo ni Isa disti sang pagsogod nan pagindo ");
INSERT INTO kqe_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taman sidtong allaw na pyapataas da yan adto sang sorga. Sang wa pa yan magabarik adto sang sorga aon mga sogowan na bibilin nan sang mga sahabat na pipili nan. Yani na mga sogowan pyapakatigam nan kanilan sabap sang kabarakat ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pagkatapos ng pagkamatay aw pagkabowi oman ni Isa yagapakita yan sang mga sahabat nan sa suud ng 40 na allaw. Madaig yang mga tanda na pyapakita nan kanilan antak katigaman nilan na bunna na yamabowi oman yan. Aw sidto na mga wakto nang yagapakita yan kanilan, pyagalaong nan silan makapantag sang pagdato ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sangallaw disinyan sarta yanagkatipon si Isa aw yang mga sahabat nan, yagalaong yan kanilan, “Ayaw nay kamo magpanaw sikun sang Awrosalam, awgaid tagadi pa mayo yang pyapasad kamayo ng Tohan na kanak Ama, na pyagalaong ko kamayo sangaon. ");
INSERT INTO kqe_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kay si Yahiya, tobig yang pyagasogbo nan sang mga otaw, awgaid kamo, sang di amadogay yang pagasogbo kamayo yang Nyawa ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ansinyan sarta yanagkatipon oman si Isa aw yang mga sahabat nan, yagaosip silan kang Isa, “Kay Dato, adon ba yang wakto na apapanawon mo yang mga yagadato kanatun aw abarik da mo yang kapatot ng pagdato adi kanatun na mga bangsa Israil?” ");
INSERT INTO kqe_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tyomobag si Isa aw laong nan kanilan, “Way kapatot mayo katigaman daw kinno yan matoman kay yang Ama gaid yang yamatigam aw yan yang yagabuut daw kinno yan maitabo. ");
INSERT INTO kqe_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Awgaid sang wakto na madatung kamayo yang Nyawa ng Tohan, amakadawat kamo ng kabarakat. Aw magasaksi da kamo makapantag kanak adto sang Awrosalam aw adto sang kariko ng Yahodiya aw Samariya aw sampay oman sang kariko ng mga banwa adi sang babawan ng donya.” ");
INSERT INTO kqe_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkatapos nan maglaong sinyan, pyapataas yan adto sang sorga. Aw sarta yagatanaw silan, pyagalibotan yan ng gabon aw yamawaa da yan sang pananaw nilan. ");
INSERT INTO kqe_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sarta imingao pa silan sang langit, sakadyap aon dowangka otaw na yagaindug sang masaid kanilan na yamandagom ng mapoti. ");
INSERT INTO kqe_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yagalaong silan, “Kamo na taga Jalil, nanga sa yagaindug kamo ansan aw imingao kamo adto sang langit? Yani si Isa na kikita mayo na pyapataas adto sang sorga, magabarik oman yan adi. Daw monono yang pagpataas kanan adto sang sorga maynan oman yang pagbarik nan adi sang donya.” ");
INSERT INTO kqe_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ansinyan byomarik silan sang Awrosalam sikun sang butay na pyagangaanan ng Butay ng Jayton. Yani na butay mga sangka kilomitro yang kawat sikun sang syodad. ");
INSERT INTO kqe_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagdatung nilan sang Awrosalam, pyomanaos silan sang kowarto adto sa taas ng baay na pyagauyaan nilan. Yang yanagkatipon ansan silan Pitros, Yahiya, Yakob, Andriyas, Pilip, Tomas, Bartolomi, Matiyo, si Yakob na anak ni Alpiyo, si Simon na rebelde sangaon kipat kang Yodas na anak ni Yakob. ");
INSERT INTO kqe_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yang kariko nilan yabay managkatipon antak magdowaa upud sang mga kaobayan aw si Mariyam na ina ni Isa kipat oman sang mga lomon nan na usug. ");
INSERT INTO kqe_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sangallaw disinyan sarta yanagkatipon yang mga yamangintoo kang Isa na mga 120 ka otaw, imindug si Pitros aw yagalaong yan, ");
INSERT INTO kqe_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kalomonan ko, dait na amatoman yang pyagalaong sang Kitab na pyapakatigam sangaon ng Nyawa ng Tohan pinaagi kang Soltan Daud. Yang idto na pyapakatigam nan yang makapantag kang Yodas na yan yang yagadaa sang mga otaw na yagadakup kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Yodas dati na kaupdanan nami na sahabat aw yumupud yan sang gawbuk nami.” ");
INSERT INTO kqe_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, yang sapi na dyadawat ni Yodas silbi bayad sang maat na ininang nan gyagamit nan sang pagbili ng sangka parsila na lopa. Disidto na lopa yamaoog si Yodas aw kamatay kay yoboto yang kanan dubdub aw lyomogwa yang kariko ng tinai nan. ");
INSERT INTO kqe_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na, yang kariko ng mga taga Awrosalam yamakadungug ng makapantag sinyan. Agaw tyatawag nilan yan na lopa ng Akildama sang kanilan tiniyaban na yang mana san Lopa ng Dogo. ");
INSERT INTO kqe_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yagapadayon si Pitros maglaong, “Aon yamakasorat sang Kitab Jabor na yagalaong, “‘Apabayaan gao yang pyagauyaan nan kay dait na waa day magauya ansan.’” Aw aon oman yamakasorat na yagalaong, “ ‘Madyaw pa aw aon makasalinti sang gawbuk nan.’ ");
INSERT INTO kqe_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Agaw,” laong ni Pitros, “madyaw pa aw magapili kita ng sangka otaw na makasalinti kanan. Kinaanglan na sambok yan na kaupdanan nami sang tibok panahon na adi pa kanatun si Tagallang Isa ");
INSERT INTO kqe_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","sikun pa sang pagsogbo kanan ni Yahiya taman sidtong wakto na pyapataas yan adto sang sorga. Kay dait na makasaksi yan upud kanami makapantag sang pagkabowi oman ni Isa.” ");
INSERT INTO kqe_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ansinyan dowangka otaw yang pyagapilian nilan: si Yosop na pyagangaanan ni Barsabas na tyatawag oman ni Yostos, aw si Matiyas. ");
INSERT INTO kqe_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ansinyan yagadowaa si Pitros kipat oman sang kadaigan aw laong nilan, “Ya Tohan, ikaw yang yamatigam sang dumduman ng kariko ng manosiya. Agaw pakitaan kanami daw sino kanilan dowa yang pipili mo ");
INSERT INTO kqe_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na amainang ng sahabat poli kang Yodas. Kay bibiyaan ni Yodas yani na gawbuk aw kyomadto yan sang logar na dait kanan.” ");
INSERT INTO kqe_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pagkatapos nilan magdowaa, yanagripa silan aw si Matiyas yang yamapili. Ansinyan yamakadogang yan sang sampoo aw isa na mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ansinyan pagdatung ng allaw ng pakaradyaan na tyatawag ng Pintikostis, yanagkatipon yang kariko ng mga yamangintoo kang Isa sang sambok na logar. ");
INSERT INTO kqe_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sakadyap aon matanog na oni sikun sang langit na maynang makusug na samut. Aw yamakarimpud yan na oni sa suud ng baay na pyagakatiponan nilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ansinyan aon kikita nilan na maynang atoon sang porma ng dila na yamakatongtong sang matag-isa kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aw yang kariko nilan pyagabuutan ng Nyawa ng Tohan aw yakapagtiyab silan sang yagakatuna-tuna na tiniyaban na wa nilan akatigami. Yamainang nilan yani sabap sang kabarakat na yatag kanilan ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, sidto na wakto aon mga Yahodi sang Awrosalam sikun sang yagakatuna-tuna na mga banwa adi sang babawan ng donya na baraibada silan na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagdungug nilan sidtong oni, madaig silan na kyomadto sang pyagatiponan ng mga yamangintoo kang Isa. Pagdatung nilan adto, bali na katingaa nilan kay idtong mga otaw na pyagabuutan ng Nyawa ng Tohan yagatiyab sang tiniyaban ng matag-isa kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yamatingaa sagaw silan aw laong silan, “Di ba yani na mga otaw taga Jalil? ");
INSERT INTO kqe_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na, nanga sa yamakadungug kita na yagatiyab silan sang mga tiniyaban ng matag-isa kanatun? ");
INSERT INTO kqe_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aon adi kanatun mga taga Partiya, Midiya, aw taga Ilam. Aon oman taga Misopotamiya, Yahodiya aw Kapadokiya, Pontos aw Asiya. ");
INSERT INTO kqe_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aw aon oman taga Pirigiya, Pampiliya aw taga Misir, aw mga otaw sikun sang mga logar adto sang Libiya na masaid sang Kirini. Aw aon oman yagasikun sang syodad ng Roma ");
INSERT INTO kqe_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na mga Yahodi kipat sang mga dili ng Yahodi na yagapasakop sang agama Yahodi. Aon oman taga Kiriti aw taga Arabiya. Na, maskin yagakatuna-tuna yang pyagasikunan ta, yamakasabot kita sang kanilan pyaglaongan na makapantag sang mga katingaan na ininang ng Tohan kay yagatiyab silan sang kanatun mga tiniyaban!” ");
INSERT INTO kqe_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na, yamatingaa sagaw yang kariko ng mga otaw ansan aw yamaribog silan. Agaw yanaginosipay silan, laong nilan, “Ono kowaw yang mana sini?” ");
INSERT INTO kqe_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Awgaid aon oman kadaigan na yagadigay-digay sang mga yamangintoo kang Isa aw laong nilan, “Yamangkalasing gaid yani na mga otaw!” ");
INSERT INTO kqe_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ansinyan imindug si Pitros kipat sang sampoo aw isa na mga sahabat aw yagalaong yan ng matanog adto sang kamangaotawan, laong nan, “Mga kalomonan ko na mga Yahodi aw yang kariko mayo na yagauya adi sang Awrosalam, paningugi mayo yang pagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dili ng bunna yang iyan sang dumduman mayo na lasing yani na mga otaw kay way magkalasing ng baya pa alas nowebe ng kaamdag. ");
INSERT INTO kqe_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Awgaid yani na yamaitabo adon yang pagtoman sang pyagalaong ni Nabi Yowil sangaon na laong nan, ");
INSERT INTO kqe_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Sang kataposan na mga allaw,’ laong ng Tohan, ‘apadatung ko yang kanak Nyawa sang kariko ng mga otaw. Yang mga anak mayo na usug aw bobay magapakatigam sang apakatigam ko kanilan, yang mga olitawo mayo makakita sang apakita ko kanilan, aw yang mga mangkatikadung mayo magatagaynup sang karim ko apakatigam kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bunna sagaw na sidto na mga allaw apadatung ko yang kanak Nyawa sang mga sogowanun ko na usug aw bobay aw ansinyan magapakatigam silan sang apakatigam ko kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magainang ako ng mga katingaan adto sang langit aw magapakita ako ng mga tanda adi sang donya na aon kitaun na dogo, atoon aw madakmul na ubul. ");
INSERT INTO kqe_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ansinyan magakaduguum yang suga, aw magakapowa yang bowan na maynang dogo. Aw pagkatapos san madatung yang dakowa aw barapantag na allaw na magahokom da yang Tohan sang kariko ng manosiya. ");
INSERT INTO kqe_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aw ansinyan sino-sino yang magasampit sang Tagallang aw amangayo kanan ng tabang, amalowas aw di da isiksaun.’ ” ");
INSERT INTO kqe_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yagalaong pa si Pitros, “Mga kalomonan ko na bangsa Israil, paningugi mayo yaning pagalaong ko kamayo. Si Isa na taga Nasarit, bunna na syosogo ng Tohan adi kanatun. Pyapangimunnaan yani ng Tohan sabap sang mga katingaan aw mga tanda na pyapainang nan kanan. Kyakatigaman mayo yani kay yamaitabo yang kariko sinyan adi kamayo. ");
INSERT INTO kqe_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Na, yani si Isa dyadakup mayo, awgaid kyakatigaman dadaan ng Tohan na maynan yang amaitabo kay idto yang kahanda nan. Aw pyapapatay mayo si Isa kay syosogo mayo yang baradosa na mga otaw antak silan maglansang kanan adto sang kros. ");
INSERT INTO kqe_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Awgaid byobowi oman yan ng Tohan aw lyolowas nan yan sikun sang masikot na kamatayun kay di makadaog kanan yang kamatayun. ");
INSERT INTO kqe_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kay aon pyagalaong ni Soltan Daud sangaon na makapantag kang Isa, laong nan, “ ‘Yamatigam ako na yabay idi kanak yang Tohan. Iyan yan sang masaid kanak, agaw di ako amarido. ");
INSERT INTO kqe_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sabap sinyan dakowa yang kasowat ko aw di ako magaondang magpoji kanan. Aw maskin amatay ako, aon pay pagasa ko. ");
INSERT INTO kqe_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kay di mo ako apabayaan adto sang banwa ng mga patay aw di mo otogotan na amadonot yang lawas ko na ako yang sotti na sogowanun mo. ");
INSERT INTO kqe_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pyapakatigam mo kanak yang daan pasingadto sang kinabowi. Aw idto yang amakasowat kanak kong iyan ako sang masaid kanmo.’ ” ");
INSERT INTO kqe_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yagapadayon pa maglaong si Pitros, “Mga kalomonan ko, pagalaongon ta kamo sang insakto na yang bantoganun na ompo natun na si Soltan Daud yamatay aw lyulubung. Aw yang kanan kobor idi kanatun sampay da adon. ");
INSERT INTO kqe_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Awgaid maynidto yang pyaglaongan ni Soltan Daud kay sambok yan na nabi. Kyakatigaman nan na aon pyapasad kanan ng Tohan aw idto yang pasad nan na sambok sang mga topo nan amainang ng soltan na magonawa kanan. ");
INSERT INTO kqe_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kyakatigaman oman ni Soltan Daud daw ono yang inangun ng Tohan sang madatung na mga allaw. Agaw yakapaglaong yan ng makapantag sang pagkabowi oman ng Almasi, laong nan na wa yan apabayai adto sang banwa ng mga patay aw wa otogoti ng Tohan na amadonot yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na, yang idto si Isa na byobowi oman ng Tohan sikun sang kamatay aw yang kariko nami yamakasaksi sinyan kay yakakita kami kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqe_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aw adon yatagan si Isa ng dakowa na kabantogan kay pyapataas yan adto sang karinto ng Tohan aw yatagan yan ng Ama ng kapatot magpadaa sang Sotti na Nyawa magonawa sang pasad nan. Aw adon pyapadaa ni Isa yang Nyawa ng Tohan adi kanami. Agaw, yang kikita aw dyudungug mayo adon yang ininang ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, dili ni Soltan Daud yang pyapataas adto sang sorga, awgaid yagalaong yan, “ ‘Yagalaong yang Tohan sang kanak Dato, “Pagingkod adi sang karinto ko ");
INSERT INTO kqe_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampay na ataloon ko yang mga kalaban mo aw amainang da silan na maynang tongtonganan ng siki mo.” ’ ");
INSERT INTO kqe_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Agaw sagaw adon,” laong ni Pitros, “yang kariko mayo na bangsa Israil, dait kamo matigam na yani si Isa na lyalansang mayo sang kros, ininang yan ng Tohan ng Dato na Labi na Mabarakat aw yang Almasi.” ");
INSERT INTO kqe_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na, pagdungug ng mga otaw sinyan na pyaglaongan ni Pitros, labi da yang karido aw alluk nilan. Agaw yagaosip silan kang Pitros kipat sang kadaigan pa na mga sahabat, laong nilan, “Mga lomon, ono yang dait nami inangun?” ");
INSERT INTO kqe_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tyomobag si Pitros, “Pagtawbat kamo aw yang matag-isa kamayo magpasogbo sang ngaan ni Isa Almasi antak amponon kamo sang mga dosa mayo. Aw ansinyan amadawat mayo yang Sotti na Nyawa na atag kamayo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kay idto yang pasad nan kamayo kipat sang mga katopowan mayo kipat oman sang kariko ng mga otaw adto sang mawat na mga banwa na maskin sino yang ipiliun ng Tohan na kanatun Tagallang na amangagad kanan.” ");
INSERT INTO kqe_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Madaig pa yang pyagaindo kanilan ni Pitros aw yagalaong pa yan kanilan, “Ayaw kamo magsiling sang batasan ng maat na mga otaw adon na panahon kay antak malowas kamo sikun sang siksa na madatung kanilan.” ");
INSERT INTO kqe_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na, madaig yang yamangintoo sang pyaglaongan ni Pitros aw yagapasogbo silan. Aw sidto na allaw mga 3,000 ka otaw yang yamakadogang sang mga yamangintoo kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yang kariko nilan yagapadayon maningug sang pyagaindo ng mga sahabat, yabay silan managkatipon aw yakan silan ng pan na tadumanan sang pagkamatay ni Isa aw yabay silan magdowaa adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na, yang kariko ng mga otaw aon alluk sang Tohan kay madaig yang mga katingaan na tanda sang kabarakat ng Tohan na ininang ng mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yang kariko ng mga yamangintoo kang Isa yabay managkatipon aw yanagtinabangay silan sang mga panginaanglan nilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pyapamarigya nilan yang kanilan lopa kipat sang kanilan mga butang aw yang alin pyagabain-bain nilan sang mga kaupdanan nilan sobay sang kikinaanglan nilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Allaw-allaw yanagkatipon silan adto sang Baay ng Tohan. Aw yagadungan silan koman adto sang kanilan mga baay na aon kasowat aw iklas sang pangatayan nilan idtong ininang nilan. ");
INSERT INTO kqe_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yabay silan magpoji sang Tohan aw yaddatan silan ng kariko ng mga otaw. Na, allaw-allaw aon mga otaw na yamalowas aw dyodogang silan ng Tohan sidtong kadaigan na yamangintoo kang Isa Almasi. ");
INSERT INTO kqe_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na, sangallaw disinyan kyomadto si Pitros aw si Yahiya sang Baay ng Tohan ng alas tres ng gabila na wakto ng pagdowaa. ");
INSERT INTO kqe_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Adto sang sambok na powertaan sang Baay ng Tohan na tyatawag ng Madyaw na Powertaan aon sambok na sadi na wa makapanaw sikun pa sang pagkaotaw nan. Allaw-allaw dyadaa yan adto sidtong powertaan antak makapangayo yan ng sapi sang mga otaw na yosuud sang pamanag ng Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Adon, pagkita nan kang Pitros aw si Yahiya na mosuud da silan, yamangayo yan kanilan ng sapi. ");
INSERT INTO kqe_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ansinyan pyapakatanawan yan ni Pitros aw si Yahiya aw yagalaong si Pitros kanan, “Tanaw adi kanami!” ");
INSERT INTO kqe_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na, yagatanaw da yan adto kanilan aw yagadumdum na atagan yan ng sapi. ");
INSERT INTO kqe_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Awgaid yagalaong si Pitros kanan, “Way sapi ko, ni kaw, awgaid yang idi kanak atag ko kanmo. Sang ngaan ni Isa Almasi na taga Nasarit, pagindug aw panaw!” ");
INSERT INTO kqe_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ansinyan kyukuputan ni Pitros yang karinto na arima nan aw tyatabangan nan pagindug. Aw sinyan dayon kyakaonan ng kusug yang kanan siki aw boko-boko. ");
INSERT INTO kqe_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na, yotokaw mindug yang otaw aw yagapanaw-panaw. Pagkatapos yamagad yan kang Pitros aw si Yahiya pagsuud sang pamanag ng Baay ng Tohan. Yagapanaw-panaw yan aw yagalalayogon na yagapoji sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na, yang kariko ng mga otaw yakakita kanan na yagapanaw-panaw aw yagapoji sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Aw pagkatigam nilan na yan kadi idtong makililimos na yabay magingkod ansang powertaan ng Baay ng Tohan na tyatawag ng Madyaw na Powertaan, labi da yang pagkatingaa nilan sang yamaitabo kanan. ");
INSERT INTO kqe_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, wa da magabiya idtong otaw kang Pitros aw si Yahiya, awgaid yagakuput yan kanilan sarta yagapanaw silan adto sang pamanag ng Baay ng Tohan sang tyatawag na Pagasilongan ni Solayman. Aw yang kariko ng mga otaw yamandaagan adto kanilan kay yamangkatingaa sagaw silan sabap sidto na yamaitabo. ");
INSERT INTO kqe_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkita ni Pitros sang mga otaw na yodood kanilan, yagalaong yan, “Mga kalomonan ko na bangsa Israil, nanga sa yamatingaa kamo sini na pangitabo? Nanga sa pyapakatanawan mayo kami? Basin yagadumdum kamo na yakapanaw yaning otaw sabap sang kabarakat nami atawa sabap ng baraibada kami na mga otaw. Dili! ");
INSERT INTO kqe_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kay yang Tohan na syasambayangan ng mga kaompowan natun na magonawa ni Nabi Ibrahim, si Isahak aw si Yakob, yan yang yagainang sini aw yatagan nan ng dakowa na kabantogan yang kanan sogowanun na si Isa. Awgaid pyapadakup mayo yan sang mga pangoo aw tyatarikodan mayo yan sang atobangan ni Gobirnador Pilato maskin pa kallini nan booyan si Isa. ");
INSERT INTO kqe_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yan sagaw, tyatarikodan mayo yang otaw na sotti aw matorid aw pyapangayo mayo adto kang Pilato na obooyan nan yang sangka otaw na yakapatay sang otaw. ");
INSERT INTO kqe_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na, si Isa na pyagasikunan ng kinabowi, pyapatay mayo awgaid byobowi oman yan ng Tohan. Aw kami yang mga saksi sinyan kay yakakita kami kanan pagkatapos nan mabowi oman. ");
INSERT INTO kqe_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na adon, yani na otaw na kikita aw kikilaa mayo, yatagan yan ng kusug sabap sang ngaan ni Isa. Agaw, sabap sang kabarakat ni Isa aw sabap sang pagpangintoo nami kanan, pyapakadyaw yani na otaw sang atobangan mayo. ");
INSERT INTO kqe_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga kalomonan ko, yamatigam ako na ininang mayo yani kay kamo aw yang mga pangoo mayo wa akatigam daw sino si Isa. ");
INSERT INTO kqe_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Awgaid sang mayninyan na pamaagi yamatoman yang pyapakatigam ng Tohan pinaagi sang kariko ng mga nabi kay pyagatagna nilan na dait amagi ng kasikotan yang Almasi na yan yang syosogo ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Agaw pagtawbat kamo aw pagdood kamo sang Tohan antak amponon nan yang mga dosa mayo. Aw ansinyan atagan kamo ng kadyawan sikun sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aw pagkatapos san apadaa oman nan si Isa adi sang donya na yan yang Almasi na pipili nan antak magdato kamayo. ");
INSERT INTO kqe_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Awgaid kinaanglan na magapabilin pa yan adto sang sorga taman sidtong wakto na abagoon da ng Tohan yang kariko ng mga butang. Kay idto yang pyapasad nan sikun pa sangaong ona pinaagi sang kanan mga nabi. ");
INSERT INTO kqe_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kay yagalaong sangaon si Nabi Mosa, laong nan, ‘Yang Tohan na kanatun Tagallang magasogo adi kamayo ng sambok na nabi na magonawa kanak na magasikun oman kamayo na bangsa Israil. Dait na apangagadan mayo yang kariko ng pagalaong nan kamayo. ");
INSERT INTO kqe_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yang di amangagad sang pagalaong sinyan na nabi, di da amabilang na sakop pa ng Tohan aw labi da yang siksa kanan.’ ");
INSERT INTO kqe_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na, yang kariko ng mga nabi sikun pa kang Samuel taman sang kariko nilan na yagasonod kanan yagapakatigam sang mga butang na yamatoman adon na mga allaw. ");
INSERT INTO kqe_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kamo yang amakadawat sang pyapasad ng Tohan na pyapakatigam nan pinaagi sang mga nabi. Aw kamayo oman yang pyagapasadan na ininang ng Tohan adto sang mga kaompowan mayo. Kay yagalaong yang Tohan kang Nabi Ibrahim, laong nan, ‘Atagan ng kadyawan yang kariko ng mga otaw adi sang babawan ng donya sabap sang topo mo.’ ");
INSERT INTO kqe_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Agaw, pagdatung ng wakto na apadaa da ng Tohan yang kanan sogowanun na si Isa, pyapadaa nan yan ona adi kamayo antak tarikodan mayo yang maat na mga inang mayo aw antak makadawat kamo sang kadyawan nan.” ");
INSERT INTO kqe_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Adon, sarta yagaindo pa si Pitros aw si Yahiya sang mga otaw, yodood kanilan yang mga imam, yang mga Sadoki aw yang kapitan ng mga gowardya sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bali na kadaman nilan sidtong dowa na sahabat kay yagaindo silan sang mga otaw na yamabowi oman si Isa aw idto yang tanda na amabowi oman yang kariko ng mga patay. ");
INSERT INTO kqe_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Agaw dyadakup nilan si Pitros aw si Yahiya aw sabap ng kasilum da pyapapiriso nilan taman ng pagkailaw. ");
INSERT INTO kqe_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Awgaid maskin maynan, madaig yang yamangintoo kang Isa na yamakadungug sang pyagaindo nilan Pitros. Yang kadaig ng kausgan gaid yadatung ng mga 5,000. ");
INSERT INTO kqe_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na, pagkailaw disinyan yanagkatipon adto sang Awrosalam yang mga pangoo sang agama, yang mga pangoo sang banwa aw yang mga magiindoway ng Hokoman. ");
INSERT INTO kqe_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Iyan oman si Anas na Dakowa na Imam, si Kayapas, si Yahiya, si Iskandar aw yang kadaigan pa na mga usug na sakop ng pamilya ni Anas. ");
INSERT INTO kqe_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ansinyan pyapaatobang nilan yang dowa na sahabat adto kanilan aw osipa nilan, laong nilan, “Wain magasikun yang kabarakat mayo paginang sinyan na katingaan? Sino yang yamatag kamayo ng kapatot pagpakadyaw sinyan na sadi?” ");
INSERT INTO kqe_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ansinyan pyagabuutan si Pitros ng Nyawa ng Tohan aw tyomobag kanilan, laong nan, “Mga pangoo sang agama aw mga pangoo sang banwa, ");
INSERT INTO kqe_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","aw osipun mayo kami adon makapantag sang kadyawan na yamainang sining sadi aw monono yang pagpakadyaw kanan, ");
INSERT INTO kqe_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na, dait mayo katigaman kipat sang kariko ng mga bangsa Israil na yaning otaw na yagaindug adon sang atobangan mayo yamadyaw sabap sang kabarakat ni Isa Almasi na taga Nasarit. Yani si Isa lyalansang mayo sang kros, awgaid byobowi oman yan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Makapantag oman kanan yang yamakasorat sang Kitab na yagalaong, “ ‘Yang bato na titimbag ng mga panday kay way kono kapantag, yamainang kadi ng labi na barapantag.’ ");
INSERT INTO kqe_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Agaw, si Isa da gaid yang makalowas sang manosiya. Kay waa day lain pa na adi sang babawan ng donya na yatagan ng Tohan ng kapatot paglowas kanatun.” ");
INSERT INTO kqe_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, yamangkatingaa da yang kariko ng mga pangoo pagkita nilan sang kaisug nilan Pitros aw si Yahiya pagtobag kanilan aw pagkatigam nilan na silan way mataas na pagpangadi. Aw ansinyan kyakatigaman nilan na yani na mga otaw mga inagad ni Isa sangaon. ");
INSERT INTO kqe_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Awgaid way akapaglaong nilan kay kikita nilan yang otaw na pyapakadyaw na yagaindug sang masaid kang Pitros aw si Yahiya. ");
INSERT INTO kqe_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Agaw pyapalogwa da nilan si Pitros aw si Yahiya sikun sang Makagwas na Hokmanan antak pagbaawan nilan daw ono yang inangun nilan. ");
INSERT INTO kqe_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Laong nilan, “Ono yang inangun ta sini na mga otaw? Yang kariko ng mga otaw adi sang Awrosalam yamatigam sang katingaan na ininang nilan aw di kita makapaglaong na bakak gaid inyan. ");
INSERT INTO kqe_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Awgaid antak di yani akatigaman ng kadaigan pa na mga otaw, maynini yang inangun ta. Pagalaongon natun silan na di da silan magindo sang maskin sino ng makapantag kang Isa.” ");
INSERT INTO kqe_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ansinyan pyapatawag nilan si Pitros aw si Yahiya aw pyagalaong nilan na di na di silan maglaong atawa magindo sang ngaan ni Isa. ");
INSERT INTO kqe_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Awgaid tyomobag kanilan si Pitros aw si Yahiya, laong nilan, “Dumduma mayo daw wain yang madyaw na inangun sang pagtanaw ng Tohan, yang pagpangagad sang sogo mayo atawa yang sogo ng Tohan? ");
INSERT INTO kqe_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kay di gaid mapakay na ondangan nami yang pagpayapat sang mga otaw ng makapantag sang kikita aw dyudungug nami.” ");
INSERT INTO kqe_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na, syasagda da oman silan ng mga pangoo aw byobooyan silan. Aw maskin karim gao nilan kastigoon yaning dowangka otaw, di nilan mainang kay yamalluk silan sang mga otaw. Kay yang kariko ng mga otaw yagapoji sang Tohan sabap sidtong katingaan na yamainang. ");
INSERT INTO kqe_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kay idtong otaw na pyapakadyaw sobra da sang 40 ka toig yang idad. ");
INSERT INTO kqe_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na, pagkatapos kabooyan si Pitros aw si Yahiya, kyomadto silan sang mga kaupdanan nilan na mga yamangintoo kang Isa aw paglaonga nilan sang pyaglaongan kanilan ng mga pangoo ng mga imam aw yang mga pangoo sang banwa. ");
INSERT INTO kqe_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na, pagdungug nilan sinyan, yagakasambok silan sang pagdowaa adto sang Tohan aw laong nilan, “Ya Tohan na Labi na Mabarakat, ikaw yang yagabaoy sang langit aw lopa, kipat oman sang dagat aw yang kariko ng lasak sinyan. ");
INSERT INTO kqe_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sabap sang kabarakat ng Sotti na Nyawa yagalaong yang sogowanun mo na si Soltan Daud na kanami ompo sang pyapakatigam mo kanan, laong nan, “ ‘Nanga sa yamadaman yang mga dili ng Yahodi? Nanga sa yagadumdum yang mga otaw paginang ng mga butang na way poos? ");
INSERT INTO kqe_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yang mga soltan adi sang babawan ng donya yanagandam aw yang mga pangoo yagakasambok antak lomaban sang Tohan kipat sang Almasi na pipili nan antak magdato.’ ");
INSERT INTO kqe_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ya Tohan,” laong nilan, “bunna sagaw yani na pyaglaongan kay yanagkatipon adi sining syodad si Soltan Hirod aw si Pontiyos Pilato upud sang mga dili ng Yahodi aw yang mga bangsa Israil antak magkontra silan kang Isa na sotti na sogowanun mo maskin yan yang pipili mo antak magdato. ");
INSERT INTO kqe_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ininang nilan yani kay antak matoman yang pyagakahanda mo. Aw yamaitabo inyan sabap sang karim aw kabarakat mo. ");
INSERT INTO kqe_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aw adon, ya Tohan, tanawa yang pyagpangalluk nilan kanami aw tabangi kami na mga sogowanun mo antak aon kaisug nami sang pagpayapat ng pyaglaongan mo. ");
INSERT INTO kqe_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Apakita mo gao yang kanmo kabarakat antak makapakadyaw kami sang mga masakitun aw togotan mo gao kami paginang ng mga tanda aw katingaan sabap sang kabarakat ni Isa na sotti na sogowanun mo.” ");
INSERT INTO kqe_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapos nilan magdowaa, yamagayung yang baay na pyagatiponan nilan. Ansinyan pyagabuutan silan ng Nyawa ng Tohan aw wa da silan akalluk pagpayapat sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Adon, yang kariko ng mga yamangintoo kang Isa yagakasambok yang dumduman aw pangatayan nilan. Way isa na yagalaong na yan gaid yang tagtomon ng kabtangan nan kondi pyagabain-bain nilan yang kariko ng mga butang nilan. ");
INSERT INTO kqe_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aw yang mga sahabat yagadan ng kabarakat ng Tohan pagsaksi makapantag sang pagkabowi oman ni Tagallang Isa, aw yang kariko ng mga yamangintoo tyatabangan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Way isa kanilan na aon pay kikinaanglan kay yang mga otaw na aon mga lopa atawa mga baay nilan yanagbarigya sinyan aw yang alin ");
INSERT INTO kqe_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yatag nilan adto sang mga sahabat. Aw ansinyan pyagabain-bain nilan yang sapi aw pangatagan sang mga otaw sobay sang kikinaanglan nilan. ");
INSERT INTO kqe_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, idto yang ininang ni Yosop na taga Kipros. Sambok na topo yan ng tribo ni Libi aw pyagangaanan yan ng mga sahabat ni Barnabas na yang mana san “yang otaw na yagapakatigsun sang pangatayan.” ");
INSERT INTO kqe_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Byabarigya nan yang kanan lopa aw yang alin sinyan dyadaa nan adto sang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Adon, aon sambok na otaw na pyagangaanan ni Ananiyas aw yang kanan asawa si Sapira. Aon sangka parsila na lopa nilan na byabarigya nilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Awgaid kyakamang ni Ananiyas yang sangka bain ng alin aw tyatago nan na yamatigam oman yang asawa nan. Ansinyan dyadaa ni Ananiyas yang yamabilin na sapi adto sang mga sahabat aw paglaonga nan na idto yang alin sang kanilan lopa. ");
INSERT INTO kqe_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Awgaid yagalaong si Pitros kanan, “Kay Ananiyas, nanga sa yagapadaa kaw sang satsat kanmo ni Iblis aw yamakak kaw sang Nyawa ng Tohan? Kay tyatago mo yang kadaigan na sapi na alin sang kanmo lopa. ");
INSERT INTO kqe_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sang wa pa mo abarigyaa yang lopa, kanmo sa yan. Aw pagbarigya da mo, ikaw oman yang makabuut daw onoon mo yang alin sinyan. Awgaid nanga sa yagadumdum kaw paginang ng maat? Kay yang pyagabakakan mo dili ng otaw awgaid yang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na, pagdungug ni Ananiyas sang pyaglaongan ni Pitros, yatomba yan aw kamatay. Aw yamangkalluk da yang kariko ng mga otaw na yamakadungug sinyan. ");
INSERT INTO kqe_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ansinyan aon dyomatung na mga olitawo aw balota nilan yang lawas ni Ananiyas aw daa adto sa logwa kay ulubung da nilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na, paglabay ng mga toongka oras, dyomatung si Sapira na wa akatigam sang yamaitabo sang kanan bana. ");
INSERT INTO kqe_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Adon yosip yan ni Pitros, laong nan, “Paglaonga ako, yani gaid yang alin sang lopa na byabarigya mayo?” Tyomobag yan aw laong nan, “Ud, yan da yang kariko.” ");
INSERT INTO kqe_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ansinyan yagalaong si Pitros, “Nanga sa yagakaoyon kamo na magasawa na magatigi sang Nyawa ng Tohan? Tanawa, yang mga otaw na yanaglubung sang kanmo bana iyan da sang powertaan. Aw ikaw da adon yang adaun nilan adto logwa.” ");
INSERT INTO kqe_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na, sinyan dayon yatomba si Sapira apit sang siki ni Pitros aw kamatay. Pagsuud ng mga olitawo, kikita nilan na patay da yan. Ansinyan dyadaa nilan yan adto logwa aw lubungan sang masaid sang kanan bana. ");
INSERT INTO kqe_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na, labi da yang alluk ng kariko ng mga yamangintoo kipat sang kariko ng yamakadungug sinyan na pangitabo. ");
INSERT INTO kqe_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, madaig yang mga tanda aw katingaan na ininang ng mga sahabat adto sang mga otaw. Aw yang kariko ng mga yamangintoo yabay managkatipon adto sang tyatawag na Pagasilongan ni Solayman. ");
INSERT INTO kqe_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pyagaaddatan silan ng mga otaw, awgaid yang kadaigan wa amangisug magagad kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Awgaid maskin maynan, yagakadaig pa yang mga yamangintoo kang Tagallang Isa, mga usug aw bobay. ");
INSERT INTO kqe_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na, sabap sang mga katingaan na ininang ng mga sahabat, dyadaa ng mga otaw yang mga masakitun adto sang mga daan aw butangan nilan sang kowangan atawa kamun kay antak paglabay ni Pitros aw kalandongan pa gaid silan ng anino nan, amadyaw silan. ");
INSERT INTO kqe_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na, madaig oman yang mga otaw sikun sang makilibot na mga banwa na kyomadto sang Awrosalam aw yagadaa silan ng mga masakitun kipat sang mga otaw na kyakasaytanan. Aw yang kariko nilan yamadyaw. ");
INSERT INTO kqe_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na adon, yang Dakowa na Imam aw yang kariko ng mga kaupdanan nan na mimbro ng panon ng mga Sadoki, dakowa yang kasina nilan sang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Agaw pyapandakup nilan silan aw pamirisowa nilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Awgaid pagkagabi disinyan aon malaikat na syosogo ng Tohan na yagaabri sang powertaan ng pirisowan aw pyapalogwa nan yang mga sahabat. Aw laong nan kanilan, ");
INSERT INTO kqe_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kadto kamo sang Baay ng Tohan aw indowi mayo yang mga otaw makapantag sang kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Agaw pagkailaw ng omaganay pa, kyomadto silan sang Baay ng Tohan sobay sang pyaglaongan kanilan ng malaikat aw yagasogod silan magindo sang mga otaw. Na adon, yang Dakowa na Imam aw yang mga kaupdanan nan, pyapatawag nilan yang kariko ng mga pangoo sang bangsa Israil antak magtipon yang kariko ng mga opisyales ng Makagwas na Hokmanan. Pagkatapos san yagasogo silan na akamangun yang mga sahabat sikun sang pirisowan aw paatobangun kanilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Awgaid pagdatung ng mga syosogo adto sang pirisowan, waa da don yang mga sahabat. Agaw yanagbarik silan adto sang Hokmanan kay paglaongon nilan yang mga pangoo, ");
INSERT INTO kqe_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","laong nilan, “Pagdatung nami adto sang pirisowan, kikita nami na kyakandadowan yan ng madyaw aw yang mga gowardya yanagbantay adto sang mga powertaan. Awgaid pagabri nami, way kikita nami adto sa suud!” ");
INSERT INTO kqe_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na, pagdungug sinyan ng mga pangoo ng mga imam kipat sang kapitan ng mga gowardya sang Baay ng Tohan, yamarido silan kay wa silan akatigam daw ono yang yamaitabo sang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ansinyan dyomatung yang sangka otaw na yagalaong kanilan, “Yang mga otaw na pipiriso mayo, adto da silan sang Baay ng Tohan aw yagaindo sang mga otaw!” ");
INSERT INTO kqe_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na, kyomadto da yang kapitan ng mga gowardya aw yang kanan mga otaw antak kamangun nilan yang mga sahabat. Awgaid wa nilan opugusa pagagad kanilan kay yamalluk silan na basin obonoon silan ng mga otaw ng bato. ");
INSERT INTO kqe_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ansinyan dyadaa nilan yang mga sahabat adto sang Makagwas na Hokmanan aw painduga nilan sang atobangan ng mga opisyales. Aw yosip silan ng Dakowa na Imam, ");
INSERT INTO kqe_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","laong nan, “Di ba syasagda nami kamo na di da gaid kamo magindo sang ngaan sidtong otaw? Awgaid ono da yang ininang mayo? Yamakarimpud da yang pyagaindo mayo sang tibok Awrosalam aw kami pa yang tyatakunan mayo sang pagpatay kanan!” ");
INSERT INTO kqe_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Awgaid tyomobag si Pitros aw yang kadaigan na mga sahabat, laong nilan, “Yang Tohan yang dait nami pangagadan, dili ng otaw. ");
INSERT INTO kqe_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yani si Isa pyapatay mayo pinaagi sang paglansang sang kaoy. Awgaid byobowi oman yan ng Tohan na syasambayangan ng kanatun kaompowan. ");
INSERT INTO kqe_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aw yatagan yan ng dakowa na kabantogan kay pyapataas yan ng Tohan adto sang sorga apit sang karinto nan silbi soltan aw manlolowas kay antak kita na mga bangsa Israil makapagtawbat sang mga dosa ta aw atagan ng kaamponan. ");
INSERT INTO kqe_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Saksi kami sini na mga butang. Aw yamangimunna oman sini yang Sotti na Nyawa na yatag ng Tohan adto sang mga otaw na yamangagad kanan.” ");
INSERT INTO kqe_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na, pagdungug sinyan ng mga opisyales, labi da yang kadaman nilan aw karim nilan patayun yang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Awgaid aon sambok na opisyal na pyagangaanan ni Gamaliyal na mimbro ng panon ng mga Parisi. Magiindoway yan ng Hokoman aw yaddatan yan ng kariko ng mga otaw. Imindug yan aw pagsogo na palogwaun yang mga sahabat ng madari gaid. ");
INSERT INTO kqe_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ansinyan yagalaong yan sang mga kaupdanan nan na mga opisyales, “Mga kalomonan ko na bangsa Israil, dumduma mayo ng madyaw daw ono yang inangun mayo sinyan na mga otaw. ");
INSERT INTO kqe_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kay sangaon aon otaw na pyagangaanan ni Todas. Yagapaambog yan sang ginawa nan aw aon mga 400 ka otaw na yamagad kanan. Awgaid sang kataposan, pyapatay yan aw yanagkakanat-kanat da yang kariko ng mga inagad nan. Aw waa da idtong gropo nilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos sinyan, sang wakto ng pagbilang ng mga otaw, si Yodas da oman na taga Jalil yang yagapasonod sang mga otaw. Aw madaig oman yang yamagad kanan. Awgaid pyapatay da oman yan aw yanagkakanat-kanat da oman yang kariko ng mga inagad nan. ");
INSERT INTO kqe_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Agaw adon, makapantag sini na mga otaw, pagalaongon ta kamo na ayaw kamo mangilabot kanilan. Pabayai mayo silan! Kay kong sikun sang manosiya yang katoyowan aw ininang nilan, na, sang di amadogay amawaa da oman yan. ");
INSERT INTO kqe_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Awgaid kong sikun yani sang Tohan, na, di da gaid kamo makadaog kanilan. Aw basin malaban pa kamo sang Tohan!” Na, yamangagad da silan sang tambag ni Gamaliyal. ");
INSERT INTO kqe_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pyapatawag oman nilan yang mga sahabat aw pyapabadasan nilan. Pagkatapos, syasagda nilan na di da gaid silan magindo sang ngaan ni Isa aw booi nilan. ");
INSERT INTO kqe_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, pyomanaw da yang mga sahabat sikun sang Makagwas na Hokmanan na bali na kasowat nilan kay tyotogotan silan ng Tohan pagagi ng kasipugan sabap sang pagpangagad nilan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ansinyan allaw-allaw adto silan sang Baay ng Tohan aw adto oman sang mga baay aw yagapadayon silan magindo aw magpayapat ng Madyaw na Gogodanun na si Isa yang Almasi. ");
INSERT INTO kqe_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na, sidto na mga allaw sarta yagakadaig yang mga yamangintoo kang Isa, yanagbagolbol yang mga Yahodi na Grik yang tiniyaban adto sang mga Yahodi na Hibrani yang tiniyaban. Yagalaong silan na sang matag allaw na pagpangatag ng pagkan wa akatagi yang mga biyoda nilan. ");
INSERT INTO kqe_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Agaw pyapatawag ng sampoo aw dowa na mga sahabat yang kariko ng mga yamangintoo kang Isa aw yagalaong silan, “Dili ng madyaw aw biyaan nami yang pagosiyat sang pyaglaongan ng Tohan antak magatiman sang mga pagpangatag. ");
INSERT INTO kqe_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Agaw adon, mga kalomonan, pagpili kamo sikun sang mga kaupdanan mayo ng pitongka otaw na madyaw yang dungug, aon katigam aw yabay pagbuutan ng Nyawa ng Tohan. Aw silan yang atagan ta sini na gawbuk. ");
INSERT INTO kqe_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aw kami, magapadayon kami sang pagdowaa aw pagosiyat sang pyaglaongan ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ansinyan yanagkaoyon yang kariko nilan sang pyaglaongan ng mga sahabat. Agaw pipili nilan si Istiban, sambok na otaw na matigsun yang pagpangintoo aw pyagabuutan ng Nyawa ng Tohan. Yang kadaigan na pipili nilan si Pilip aw si Prokoros, si Nikanor aw si Timon, si Parminas aw si Nikolas na taga Antiyok. Yani si Nikolas dili ng Yahodi, awgaid yagapasakop yan sang agama Yahodi. ");
INSERT INTO kqe_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ansinyan dyadaa nilan yaning pitongka otaw adto sang mga sahabat. Yanagdowaa silan para kanilan na dyadapunan nilan ng arima. ");
INSERT INTO kqe_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ansinyan yagapadayon yang pagpayapat sang pyaglaongan ng Tohan aw yagakadaig yang mga yamangintoo kang Isa adto sang Awrosalam. Madaig oman yang mga imam na yamangagad kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Adon si Istiban, yabay yan tabangan ng Tohan aw yagadan ng kabarakat ng Tohan yang ininang nan. Agaw, madaig yang mga tanda aw katingaan na ininang nan sang atobangan ng mga otaw. ");
INSERT INTO kqe_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Awgaid aon oman mga otaw na yagakontra kanan, mga mimbro ng pagsasambayangan na tyatawag ng Jamaa ng mga Yamalowas sikun sang Pagkaallang. Yani silan mga Yahodi na taga Kirini aw Iskandariya. Silan aw yang kadaigan pa ng mga Yahodi na yagasikun sang probinsya ng Kilikiya aw Asiya yapaglalis kang Istiban. ");
INSERT INTO kqe_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Awgaid tyatabangan si Istiban ng Nyawa ng Tohan aw yatagan yan ng katigam sang pagtobag kanilan. Agaw wa silan makadaog kanan. ");
INSERT INTO kqe_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ansinyan yabayadan nilan yang pilangka otaw antak maglaong silan ng bakak makapantag kang Istiban. Aw maynini yang pyagalaong nilan, “Yamadungug nami na yagalaong si Istiban ng maat makapantag kang Nabi Mosa aw makapantag sang Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na, sang mayninyan na pamaagi syasamok nilan yang mga otaw kipat sang mga pangoo sang banwa aw yang mga magiindoway ng Hokoman. Agaw dyadakup nilan si Istiban aw dyadaa nilan adto sang Makagwas na Hokmanan. ");
INSERT INTO kqe_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aon oman pyapasuud nilan na mga otaw na yagasaksi ng bakak aw laong nilan, “Yani na otaw yabay maglaong ng maat makapantag sang kanatun sotti na Baay ng Tohan aw makapantag sang Hokoman ni Nabi Mosa. ");
INSERT INTO kqe_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kay yamadungug nami na yagalaong yan na ogubaun kono ni Isa na taga Nasarit yaning Baay ng Tohan aw isabun nan yang kanatun kabatasanan na pyagaindo ni Nabi Mosa adto sang kanatun mga kaompowan.” ");
INSERT INTO kqe_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na, yang kariko ng mga opisyales ng Hokmanan, pyapakatanawan nilan si Istiban aw kikita nilan na yang kanan parangay maynang parangay ng malaikat. ");
INSERT INTO kqe_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ansinyan yagaosip yang Dakowa na Imam kang Istiban, “Bunna ba yaning pyaglaongan nilan makapantag kanmo?” ");
INSERT INTO kqe_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tyomobag si Istiban, “Mga taganak ko aw mga kalomonan ko, paningugi mayo ako. Yang Tohan na Labi na Mabarakat yagapakita sangaon sang kanatun ompo na si Nabi Ibrahim nang idto pa yan sang banwa ng Misopotamiya sang wa pa yan magauya adto sang Haran. ");
INSERT INTO kqe_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aw yagalaong yang Tohan kanan, ‘Panawi yang kanmo banwa aw yang kanmo kalomonan aw kadto sang banwa na apakita ko kanmo.’ ");
INSERT INTO kqe_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ansinyan pyomanaw si Nabi Ibrahim sikun sang kanan banwa na pyagangaanan ng Kaldiya aw paguya adto sang syodad ng Haran. Pagkamatay ng kanan ama, pyapaballin yan ng Tohan ansini na banwa na pyagauyaan ta adon. ");
INSERT INTO kqe_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Awgaid maskin maynan, wa pa atagi ng Tohan si Nabi Ibrahim ng lopa ansini na banwa, na maskin sangka parsila da gaid. Awgaid yagapasad yang Tohan na atag nan kang Nabi Ibrahim kipat sang kanan mga topo yani na banwa. Pagpasad sinyan ng Tohan, waa pay anak ni Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na, yani yang pyaglaongan ng Tohan adto kang Nabi Ibrahim, laong nan, ‘Yang kanmo mga topo managuya sang tuna na banwa na dili ng kanilan banwa. Amainang silan adto ng mga allang aw daog-daogon silan sa suud ng 400 ka toig. ");
INSERT INTO kqe_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Awgaid isiksaun ko yang mga otaw na yagaallang kanilan. Pagkatapos san,’ laong ng Tohan, ‘mapanaw da silan sikun sinyan na banwa aw magabarik silan ani aw magasambayang silan kanak ansini na banwa.’ ");
INSERT INTO kqe_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ansinyan pyagalaong ng Tohan si Nabi Ibrahim na dait toliun yang kariko ng kausgan na kanan sakop silbi tanda sang pyagapasadan na ininang ng Tohan adto kang Nabi Ibrahim. Agaw tyotoli ni Nabi Ibrahim yang kanan anak na si Isahak sang ikawaong allaw sikun sang pagkaotaw nan. Si Isahak oman, tyotoli nan si Yakob na anak nan. Maynan oman si Yakob, tyotoli nan yang sampoo aw dowa na mga anak nan na silan yang kaompowan ta na mga Yahodi.” ");
INSERT INTO kqe_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, yang mga anak ni Yakob yamasina sang mangod nilan na si Yosop. Agaw byabarigya nilan yan aw yamainang yan ng allang adto sang bangsa ng Misir. Awgaid iyan kanan yang Tohan ");
INSERT INTO kqe_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aw lyolowas nan yan sikun sang kariko ng kasikotan na yaagian nan. Dakowa oman yang katigam na yatag ng Tohan kang Yosop. Agaw, pagatobang nan sang soltan sang Misir, yakaoyon yan kanan. Ansinyan ininang nan si Yosop ng gobirnador sang Misir aw yatagan yan ng kapatot pagsogo sang kariko ng mga otaw adto sang palasyo nan. ");
INSERT INTO kqe_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ansinyan aon dyomatung na gutum sang tibok banwa ng Misir kipat oman sang banwa ng Kanaan. Dakowa yang kasikotan na yaagian ng mga otaw sabap sidto na gutum. Aw yang mga kaompowan ta, waa day kikita na pagkan adto sang banwa nilan. ");
INSERT INTO kqe_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Agaw, pagdungug ni Yakob na aon pay pagkan adto sang Misir, pyapakadto nan yang kanan mga anak aw idto yang pukas na pagkadto nilan sang Misir. ");
INSERT INTO kqe_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sang ikadowa na pagkadto nilan, yagapakilaa si Yosop sang mga lomon nan aw pyagalaong oman nan yang soltan makapantag sang kanan pamilya. ");
INSERT INTO kqe_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ansinyan yagatogon si Yosop adto sang kanilan ama na pakadtoon da yan sang Misir kipat sang kariko ng pamilya nan. Aw yang kadaig nilan 75 ka otaw. ");
INSERT INTO kqe_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Agaw kyomadto da si Yakob aw yang mga kaompowan ta adto sang Misir. Aw adto da silan magauya taman sang yamangkamatay silan. ");
INSERT INTO kqe_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Awgaid yang patay na mga lawas nilan dyadaa adto sang Sikim sang banwa ng Kanaan. Aw adto silan ulubungan sang lopa na binili ni Nabi Ibrahim sangaon sikun sang mga anak ni Hamor. ");
INSERT INTO kqe_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na, sang kadogay ng panahon yagakadaig yang kanatun mga kaompowan adto sang Misir. Aw ansinyan dyomatung yang wakto na masaid da matoman yang pasad ng Tohan adto kang Nabi Ibrahim. ");
INSERT INTO kqe_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sidto na wakto aon sambok na soltan sang Misir na wa akatigam ng makapantag kang Yosop. ");
INSERT INTO kqe_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Dyadaog-daog nan yang kanatun mga kaompowan aw pyapakasikotan nan silan. Pyupugus nan silan na alabak nilan yang mga kamokan nilan na usug adto logwa antak mangkamatay silan. ");
INSERT INTO kqe_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na, sidto na wakto yamaotaw si Mosa. Madyaw yan na isu aw kyakaoyonan yan ng Tohan. Yatiman yan ng taganak nan adto sang kanilan baay sa suud ng toombowan. ");
INSERT INTO kqe_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Awgaid nang di da nilan matago, dyadaa nilan yan adto sa logwa. Na, kyakamang da yan ng anak na bobay ng soltan aw pyapadakowa nan magonawa sang bunna na anak nan. ");
INSERT INTO kqe_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ansinyan pyagaindowan si Mosa sang kariko ng katigam ng taga Misir. Aw yamabantog yan kay matigam yan maglaong-laong aw madyaw oman yang ininang nan. ");
INSERT INTO kqe_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na, sang yagaidad si Mosa ng 40 ka toig, yagadumdum yan komadto sang mga kalomonan nan na bangsa Israil antak tanawon nan daw ono yang kabutang nilan. ");
INSERT INTO kqe_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ansinyan kikita nan yang sangka otaw na bangsa Israil na dyadaog-daog ng taga Misir. Agaw tyatabangan nan yang lomon nan na bangsa Israil aw yapaglaban yan sidtong taga Misir taman sang pyapatay da nan. ");
INSERT INTO kqe_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Na, pagtoo ni Mosa na yakasabot da yang mga kalomonan nan na bangsa Israil na agamitun yan ng Tohan sang paglowas kanilan sikun sang kanilan kasikotan. Awgaid wa silan makasabot. ");
INSERT INTO kqe_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagkailaw disinyan aon kikita nan na dowangka otaw na bangsa Israil na yanagtanam. Tyatabangan gao nan silan antak magosay aw laong nan kanilan, ‘Oy, maglomon kamo. Nanga sa yanagtanam kamo?’ ");
INSERT INTO kqe_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Awgaid idtong yagapasakit sang lomon nan, tyotood nan si Mosa aw paglaonga nan, ‘Sino yang yamatag kanmo ng kapatot pagdato aw paghokom kanami? ");
INSERT INTO kqe_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Basin apatayun mo oman ako magonawa sidtong taga Misir na pyapatay mo kagabi?’ ");
INSERT INTO kqe_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na, pagdungug sinyan ni Mosa, yalayas yan sikun sang Misir aw kyomadto sang banwa ng Midiyan. Adto da yan magauya sampay na yamaminyo aw adto oman yamaotaw yang dowa na anak nan na usug.” ");
INSERT INTO kqe_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yagapadayon si Istiban maglaong, “Paglabay ng 40 ka toig nang adto si Mosa sang diserto na masaid sang Butay ng Torosina, aon yagapakita kanan na malaikat sang tagbi na kaoy na yamallaga. ");
INSERT INTO kqe_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yamatingaa sagaw si Mosa sidtong kikita nan, agaw yodood yan sang kaoy antak pakatanawan nan. Ansinyan dyudungug nan yang sowara ng Tohan na yagalaong, ");
INSERT INTO kqe_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ako yang Tohan na syasambayangan ng kanmo kaompowan, yang Tohan ni Ibrahim, ni Isahak aw si Yakob.’ Na, pagdungug sinyan, tyatakigan si Mosa ng alluk aw wa da yan makatanaw sang atoon ansang tagbi na kaoy. ");
INSERT INTO kqe_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ansinyan yagalaong kanan yang Tohan, ‘Lobasa yang sandalyas mo kay sotti yang pyagaindugan mo. ");
INSERT INTO kqe_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kikita ko yang pagpakasikot sang kanak mga otaw adto sang Misir. Aw dyudungug ko yang kanilan pangungas-ungas. Agaw yakani ako antak lowasun ko silan sikun sang kasikotan nilan. Na, pagandam kay osogoon ta kaw adto sang Misir.’ ");
INSERT INTO kqe_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Yani si Nabi Mosa tyatarikodan sangaon ng mga bangsa Israil kay yagalaong silan, ‘Sino yang yamatag kanmo ng kapatot pagdato aw paghokom kanami?’ Awgaid yan agaw yang syosogo ng Tohan antak mainang ng pangoo nilan na magalowas kanilan sikun sang kasikotan adto sang Misir. Aw tyatabangan yan ng malaikat na yagapakita kanan adto sang tagbi na kaoy na yamallaga. ");
INSERT INTO kqe_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Nabi Mosa agaw yang yagapangoo sang mga bangsa Israil pagpanaw nilan sikun sang Misir. Madaig yang mga tanda aw katingaan na ininang nan adto sang Misir, adto sang Dagat na Mapowa aw adto oman sang diserto sa suud ng 40 ka toig. ");
INSERT INTO kqe_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Nabi Mosa yang yagalaong sang kanatun kaompowan na bangsa Israil, laong nan, ‘Sang madatung na mga allaw apadaan kamo ng Tohan ng sambok na nabi na magonawa kanak na magasikun oman kamayo na bangsa Israil.’ ");
INSERT INTO kqe_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yani si Nabi Mosa, iyan yan upud sang kanatun kaompowan na bangsa Israil nang yanagkatipon silan adto sang diserto aw iyan yan upud sang malaikat na yapagbaaw kanan adto sang Butay ng Torosina. Si Nabi Mosa yang yadawat sang pyaglaongan ng Tohan na makaatag ng kinabowi antak apasampay nan kanatun. ");
INSERT INTO kqe_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Awgaid yang kanatun kaompowan,” laong ni Istiban, “wa silan magatoman kang Mosa. Tyatarikodan nilan yan aw karim gao nilan magbarik adto sang Misir. ");
INSERT INTO kqe_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Agaw yagalaong silan kang Haron, ‘Paginangan kami ng mga tagallang na amaona kanami kay yani si Nabi Mosa na yagadaa kanami sikun sang Misir, wa kami akatigam daw ono yang yamaitabo kanan.’ ");
INSERT INTO kqe_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na, idto yang wakto na yagainang silan ng barhala na maynang nati ng baka. Yagapakorban silan adto sidtong barhala aw yanagpakaradyaan silan antak bantogon nilan yang kanilan ininang. ");
INSERT INTO kqe_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na, sabap sinyan tyatarikodan silan ng Tohan aw pyapabayaan nan silan na magasambayang sang mga bitoon adto sang langit magonawa sang syosorat ng nabi sang Kitab, laong nan, “ ‘Mga otaw na bangsa Israil, sa suud ng 40 ka toig sarta adto kamo sang diserto, yagasobari kamo ng mga ayup aw pyapakorban mayo, awgaid yang idto na mga korban dili para kanak. ");
INSERT INTO kqe_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kay yang yabay mayo daun yang baay-baay ng barhala mayo na si Molok, kipat sang barhala mayo na pyagangaanan ni Ripan na porma ng bitoon. Yang idto yang mga barhala na ininang mayo kay antak sambayangan mayo. Agaw apasagdan ko kamo na adaun kamo adto sang sambok na banwa na mas mawat pa kaysang Babilon.’ ” ");
INSERT INTO kqe_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yagapadayon pa si Istiban maglaong, “Na, sarta adto sang diserto yang mga kaompowan ta, aon dyadaa nilan na tolda na pagsasambayangan na idto yang tanda na iyan kanilan yang Tohan. Yan na tolda ininang sobay sang sogo ng Tohan aw sobay oman sang pyapakita ng Tohan kang Nabi Mosa. ");
INSERT INTO kqe_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pagkamatay ni Nabi Mosa, dyadawat ng mga kaompowan ta yan na tolda sikun sang mga ama nilan. Aw dyadaa nilan inyan pagsuud nilan adi sining banwa sang wakto na yagapangoo kanilan si Yossa. Sabap sang tabang ng Tohan pyapapanaw nilan yang mga otaw na yagakatuna-tuna yang bangsa antak kanilan da yani na banwa. Aw yang inyan na tolda yang pagsasambayangan nilan taman sang wakto ng pagkasoltan ni Daud. ");
INSERT INTO kqe_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na, madyaw yang ginawa ng Tohan adto kang Soltan Daud. Aw yamangayo si Soltan Daud adto sang Tohan na otogotan yan paginang ng Baay na pyagauyaan ng Tohan na syasambayangan ni Yakob na kanatun ompo. ");
INSERT INTO kqe_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Awgaid dili ni Soltan Daud kondi si Soltan Solayman yang yagainang sang Baay ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Awgaid yang Tohan na Labi na Makagwas wa magauya sang baay na ininang ng manosiya. Kay aon syosorat ng nabi sang Kitab na yagalaong yang Tohan, laong nan, ");
INSERT INTO kqe_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘Yang sorga yang ingkodanan ko, aw yang donya yang tongtonganan ng siki ko. Na, ono da yang baay na inangun mayo kanak? Aw wain kadi yang pagapatanaan ko? ");
INSERT INTO kqe_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Di ba ako yang yagainang sang kariko sini na mga butang?’ ” ");
INSERT INTO kqe_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Aw yagalaong pa si Istiban, “Matigas sagaw yang oo mayo! Di kamo amangagad sang Tohan aw di oman kamo amaningug sang pyaglaongan nan. Yabay gaid mayo sopakun yang Nyawa ng Tohan. Magonawa sagaw kamo sang mga kaompowan mayo! ");
INSERT INTO kqe_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kay way nabi na wa nilan apakasikoti. Aw pyapatay nilan maskin yang mga syosogo ng Tohan na yagapakatigam sang pagdatung ng Almasi na matorid na sogowanun nan. Aw pagdatung nan, kamo yang yagatraydor aw yagapatay kanan. ");
INSERT INTO kqe_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo yang yatagan ng Hokoman na pyapasampay ng Tohan kang Nabi Mosa pinaagi sang malaikat. Awgaid wa mayo apangagadi!” ");
INSERT INTO kqe_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na, pagdungug sinyan ng mga opisyales ng Hokmanan, yangoyagut yang onto nilan sabap sang bali na kadaman nilan. ");
INSERT INTO kqe_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Awgaid si Istiban, pyagabuutan yan ng Nyawa ng Tohan aw imingao adto sang langit. Aw kikita nan yang Tohan sang dakowa na kasiga nan aw si Isa na yagaindug apit sang karinto ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Tanawa mayo,” laong ni Istiban, “kyakaabrian da yang sorga aw kikita ko yang Anak ng Manosiya na yagaindug apit sang karinto ng Tohan!” ");
INSERT INTO kqe_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Na, yamangiyak da yang kariko ng mga opisyales aw tyatabonan nilan yang taringa nilan. Yanagdungan silan domaagan adto kang Istiban ");
INSERT INTO kqe_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aw gyogoyod nilan yan adto sa logwa ng syodad kay antak bonoon nilan ng bato sampay na akamatay da nan. Yang idtong mga otaw na yagasaksi ng bakak makapantag kang Istiban yanaglobas sang joba nilan antak way makasagabal kanilan aw byubutang nilan apit sang sambok na olitawo na pyagangaanan ni Saul. ");
INSERT INTO kqe_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na, sarta byobono nilan si Istiban ng bato, yagadowaa yan, “Kay Isa na Tagallang ko, dawata yang kanak nyawa.” ");
INSERT INTO kqe_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ansinyan yolood yan aw yagalaong ng matanog, “Ya Tohan, ampona silan sining dosa na ininang nilan!” Paglaong nan sinyan, yamabogto da yang napas nan. ");
INSERT INTO kqe_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ansinyan kyokobor si Istiban ng baraibada na mga otaw aw bali na pagtiyao nilan sabap kanan. Awgaid si Saul yakaoyon sang pagpatay kanan. Na, sidto na allaw yagasogod da yang bali na pagpakasikot sang jamaa ng mga yamangintoo kang Isa Almasi adto sang Awrosalam. Sabap sinyan yanagkakanat-kanat yang mga yamangintoo adto sang kariko ng Yahodiya aw Samariya. Yang mga sahabat dakman yang yamabilin adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Awgaid si Saul, yagasogod da yan magpakasikot sang jamaa kay karim nan na waa day amabilin kanilan. Agaw kyomadto yan sang kabaayan aw goyoda nan adto sa logwa yang mga yamangintoo, usug aw bobay, aw pamirisowa silan. ");
INSERT INTO kqe_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, yang mga yamangintoo na yanagkakanat-kanat, yagapayapat ng pyaglaongan ng Tohan maskin wain silan akadto. ");
INSERT INTO kqe_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yang isa kanilan si Pilip. Adon, kyomadto si Pilip sang sambok na syodad sang probinsya ng Samariya aw pagosiyat sang mga otaw ng makapantag sang Almasi. ");
INSERT INTO kqe_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na, pagdungug ng mga otaw sang pyagaindo nan aw pagkita nilan sang mga katingaan na ininang nan, yamaningug silan ng madyaw sang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Madaig yang mga kyakasaytanan na pyapakadyaw nan aw yamangiyak yang mga saytan paglogwa nilan sikun sang mga otaw. Madaig oman yang mga sadi aw yang mga otaw na yamatay da yang sangka bain ng lawas nilan na yamadyaw. ");
INSERT INTO kqe_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Agaw, labi da yang kasowat ng mga otaw disidto na syodad. ");
INSERT INTO kqe_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Awgaid aon oman sambok na otaw disidto na pyagangaanan ni Simon. Dogay da yamangkatingaa kanan yang mga taga Samariya sabap sang kanan katigam magmadyik. Yagapaambog si Simon na mabarakat yan na otaw. ");
INSERT INTO kqe_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aw yang kariko ng mga otaw daw mairap atawa madyaw yang kabutang nilan, yamaningug ng madyaw kang Simon aw yagalaong silan, “Yatagan yan ng kabarakat ng Tohan aw yan kowaw yang tyatawag na Dakowa na Kabarakat.” ");
INSERT INTO kqe_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yamaningug kanan yang mga otaw kay dogay da silan yamangkatingaa sabap sang kanan katigam magmadyik. ");
INSERT INTO kqe_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Awgaid adon, pagosiyat ni Pilip ng Madyaw na Gogodanun makapantag sang pagdato ng Tohan kipat makapantag kang Isa Almasi, yamangintoo silan aw yagapasogbo silan, mga usug aw bobay. ");
INSERT INTO kqe_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na, maskin oman si Simon yamangintoo da. Aw pagkatapos nan magpasogbo, yamagad yan kang Pilip aw yamatingaa sagaw yan pagkita nan sang mga katingaan aw tanda na ininang ni Pilip. ");
INSERT INTO kqe_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na, pagdungug ng mga sahabat adto sang Awrosalam na yang mga taga Samariya yamangintoo da sang pyaglaongan ng Tohan, syosogo nilan si Pitros aw si Yahiya adto sang Samariya. ");
INSERT INTO kqe_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagdatung nilan adto, yagadowaa silan para sang mga yamangintoo na amadawat nilan yang Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kay wa pa adatung kanilan yang Nyawa ng Tohan, awgaid syosogbowan pa gaid silan sang ngaan ni Tagallang Isa silbi tanda na yamangintoo silan kanan. ");
INSERT INTO kqe_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ansinyan dyadapunan silan ni Pitros aw si Yahiya ng kanilan arima aw yamadawat da nilan yang Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na, pagkita ni Simon na dyadawat ng mga yamangintoo yang Nyawa ng Tohan pagdapun kanilan ng mga sahabat ng arima nilan, yodood yan adto kang Pitros aw si Yahiya aw atagan gao nan silan ng sapi. ");
INSERT INTO kqe_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Laong nan, “Atagi mayo ako sini na kapatot kay antak yang maskin sino na adapunan ko ng kanak arima makadawat sang Nyawa ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Awgaid yagalaong kanan si Pitros, “Isiksaun kaw upud sang sapi mo kay yagadumdum kaw na amabili mo yang kabarakat na atag ng Tohan! ");
INSERT INTO kqe_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Way labot mo aw way oman kabain mo sining gawbuk nami kay dili ng matorid yang pangatayan mo adto sang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Agaw pagtawbat sining maat na dumduman mo aw pangayo-ayo adto sang Tohan kay basin amponon pa kaw nan. ");
INSERT INTO kqe_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kay yamakita ko na bali na kasina mo aw main kaw ng allang ng dosa.” ");
INSERT INTO kqe_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ansinyan yagalaong si Simon kanilan, “Tabiya, pangayowa mayo adto sang Tohan na di ako adatungan ng siksa na pyagalaong mayo kanak.” ");
INSERT INTO kqe_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na, pagkatapos ni Pitros aw si Yahiya magsaksi makapantag kang Isa aw magosiyat sang pyaglaongan ng Tohan, yomori silan adto sang Awrosalam. Aw sang pagori nilan yagaosiyat oman silan ng Madyaw na Gogodanun sang mga baryo na yaagian nilan adto sang probinsya ng Samariya. ");
INSERT INTO kqe_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ansinyan aon sambok na malaikat na syosogo ng Tohan adto kang Pilip na yagalaong kanan, “Pagandam aw kadto sang daan na yagasikun sang Awrosalam pasingadto sang Gasa.” Yan na daan yamagi sang diserto. ");
INSERT INTO kqe_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Agaw pyomanaw da si Pilip. Aw adto sidtong daan aon kikita nan na otaw na taga Itiyopa. Barapantag yan na opisyal ng soltana sang Itiyopa, yang tyatawag na Kandisa, aw sinarigan sang kariko ng kakawasaan nan. Sikun yan sang Awrosalam kay yagaibada yan adto sang Tohan ");
INSERT INTO kqe_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","aw adon yomori da oman yan. Yakasakay yan sang kalisa aw yagabatya sang Kitab na syosorat ni Nabi Isayas. ");
INSERT INTO kqe_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ansinyan yagalaong yang Nyawa ng Tohan adto kang Pilip, “Kadtowi yang kalisa aw agadi.” ");
INSERT INTO kqe_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na, dyomaagan si Pilip aw pagapas nan sidtong kalisa, yamadungug nan na yagabatya yang taga Itiyopa sang Kitab na syosorat ni Nabi Isayas. Ansinyan yagaosip si Pilip kanan, “Makasabot ba kaw sang byabatya mo?” ");
INSERT INTO kqe_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tyomobag yang opisyal, “Monono yang pagkasabot ko kong way magapakatigam kanak?” Ansinyan pyapasakay nan si Pilip aw pyapagingkod sang kilid nan. ");
INSERT INTO kqe_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na, yang byabatya nan sang Kitab yang syosorat ni Nabi Isayas na yagalaong, “Masabar yan na magonawa ng karniro na gyogoyod adto sang magasobari kanan. Aw yagapakatingun yan magonawa ng nati ng karniro na wa magatingug sarta gyogontingan. ");
INSERT INTO kqe_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pyapakasipugan yan ng mga otaw aw yang paghokom kanan dili ng matorid. Way otaw na makagogod makapantag sang mga topo nan kay yang kanan kinabowi adi sang donya kyakamang da.” ");
INSERT INTO kqe_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ansinyan yagaosip yang opisyal kang Pilip, “Tabiya, paglaonga ako daw sino yang pyapasabot ng nabi, yang kanan sarili atawa tuna na otaw?” ");
INSERT INTO kqe_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na, tyomobag da si Pilip aw sikun sidtong ayatan na byabatya ng opisyal pyapakatigam nan kanan yang Madyaw na Gogodanun makapantag kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Adon, sarta yagapadayon silan sang daan dyomatung silan sang sambok na logar na aon tobig. Ansinyan yagalaong yang opisyal, “Tanawa, aon tobig disini. Aon bay pyagasabapan nanga sa di mapakay na sogbowan mo ako?” ");
INSERT INTO kqe_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tyomobag si Pilip kanan, “Mapakay kong iklas yang pagpangintoo mo kang Isa.” Yagalaong yang opisyal, “Ud, yamangintoo ako na si Isa yang Anak ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ansinyan pyapapara ng opisyal yang kalisa aw kawas silan dowa. Yalakad silan adto sang tobig aw syosogbowan da yan ni Pilip. ");
INSERT INTO kqe_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pagsaka nilan sikun sang tobig, sakadyap kyakamang si Pilip ng Nyawa ng Tohan aw wa da yan ikitaa ng opisyal. Ansinyan yagapadayon da yan pagori na bali na kasowat nan. ");
INSERT INTO kqe_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Awgaid si Pilip, yakadatung yan adto sang syodad ng Asotos. Aw sikun disidto yagaosiyat yan ng Madyaw na Gogodanun sang kariko ng mga banwa na yaagian nan sampay na dyomatung yan adto sang Kisariya. ");
INSERT INTO kqe_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Adon si Saul, yagapadayon yan magpakasikot sang mga yamangintoo kang Tagallang Isa kay karim nan na apamatayun silan. Agaw kyomadto yan sang Dakowa na Imam ");
INSERT INTO kqe_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aw pangayo kanan ng mga sorat na adaun nan adto sang mga pangoo ng pagsasambayangan ng mga Yahodi sang Damaskos. Yani na mga sorat magapakatigam kanilan na aon kapatot nan pagdakup sang maskin sino na ikitaun nan, usug aw bobay, na yamangagad kang Isa Almasi. Aw pagdakup kanilan, adaun nan silan adto sang Awrosalam antak pirisoon silan. ");
INSERT INTO kqe_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ansinyan pyomanaw da si Saul. Aw nang masaid da yan sang Damaskos, sakadyap kyakaamdagan yan ng mabislaw na allag sikun sang langit. ");
INSERT INTO kqe_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na, sinyan dayon yatomba yan sang lopa aw aon dyudungug nan na sowara na yagalaong kanan, “Saul, Saul, nanga sa pyapakasikotan mo ako?” ");
INSERT INTO kqe_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Sino kaw, kay Dato?” laong ni Saul. Tyomobag yang sowara, “Ako si Isa na pyapakasikotan mo. ");
INSERT INTO kqe_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Adon, pagindug aw kadto sang syodad kay disidto aon magalaong kanmo daw ono yang dait mo inangun.” ");
INSERT INTO kqe_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na, yang mga kaupdanan ni Saul yagaindugun gaid ansan na wa makapagtiyab. Dyudungug nilan yang sowara, awgaid way kikita nilan na otaw. ");
INSERT INTO kqe_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ansinyan imindug si Saul. Awgaid pagboka nan ng kanan mata, di da yan makakita. Agaw tyotonggayan da yan ng mga kaupdanan nan pasingadto sang Damaskos. ");
INSERT INTO kqe_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sa suud ng toong allaw wa yan makakita aw way kyan aw way ininum nan. ");
INSERT INTO kqe_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Adon, aon sambok na otaw na yamangintoo kang Isa adto sang Damaskos na pyagangaanan ni Ananiyas. Yagapakita kanan si Tagallang Isa sang pagpananaw aw yagalaong kanan, “Kay Ananiyas.” Tyomobag yan, “Idi ako, kay Tagallang.” ");
INSERT INTO kqe_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yagalaong kanan yang Tagallang, “Adto kaw sang daan na tyatawag ng Matorid na Daan aw anapa adto sang baay ni Yodas yang otaw na taga Tarsos na pyagangaanan ni Saul. Kay yagadowaa yan adto. ");
INSERT INTO kqe_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aon pyapakita ko kanan na madatung yang sambok na otaw na ikaw agaw. Dapunan mo yan ng arima mo antak makakita oman yan.” ");
INSERT INTO kqe_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yagalaong si Ananiyas, “Kay Tagallang, madaig yang yagagogod kanak makapantag sidto na otaw aw makapantag sang pagpakasikot nan sang mga otaw na sakop mo adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aw adon yakani yan kay yatagan yan ng mga pangoo ng mga imam ng kapatot pagdakup sang kariko ng mga otaw na yagasampit sang ngaan mo.” ");
INSERT INTO kqe_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Awgaid yagalaong yang Tagallang kang Ananiyas, “Panaw da kay pipili ko si Saul antak magpayapat ng makapantag kanak adto sang mga dili ng Yahodi aw yang mga soltan nilan kipat oman sang mga otaw na bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aw apakatigam ko kanan yang kariko ng kasikotan na dait nan agian sabap sang pagpangagad nan kanak.” ");
INSERT INTO kqe_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ansinyan pyomanaw si Ananiyas aw kyomadto yan sidtong baay na pyapanikan ni Saul. Pagsuud nan, dyadapunan nan si Saul ng arima nan aw paglaonga nan, “Lomon Saul, syosogo ako adi kanmo ng Tagallang. Yan si Isa na yagapakita kanmo adto sang daan nang yagapasingani kaw sang Damaskos. Pyapakani nan ako kanmo kay antak makakita kaw oman aw makadawat kaw ng Nyawa ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Paglaong nan sinyan, aon yamallog na maynang imbis sikun sang mata ni Saul aw yakakita da oman yan. Ansinyan imindug si Saul aw yagapasogbo yan silbi tanda na yamangintoo da yan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aw pagkatapos nan koman, kyakaorian da oman yan ng kusug. Ansinyan yagapabilin si Saul ng pilang allaw adto sang Damaskos upud sang mga yamangintoo kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yagasogod dayon yan magosiyat adto sang mga pagsasambayangan ng mga Yahodi na si Isa bunna na Anak ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na, yamatingaa da yang kariko ng mga yamakadungug kanan aw yagalaong silan, “Di ba yan yangaong otaw na yagapakasikot sang mga yagasampit sang ngaan ni Isa adto sang Awrosalam? Di ba yakani yan adon antak dakupun nan yang mga yamangintoo kang Isa aw adaun nan silan adto sang mga pangoo ng mga imam?” ");
INSERT INTO kqe_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Awgaid si Saul, yagakadogang pa yang kaisug nan pagosiyat aw pyapangimunnaan nan na si Isa yang Almasi. Aw wa da makatobag kanan yang mga Yahodi na yagauya adto sang Damaskos. ");
INSERT INTO kqe_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na, pagkadogay disinyan yanagkatipon yang mga Yahodi aw yanagkaoyon silan na apatayun si Saul. ");
INSERT INTO kqe_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Allaw-gabi byabantayan nilan yang mga powertaan ng syodad kay antak patayun nilan si Saul pagagi nan ansan. Awgaid aon yagaoman kang Saul makapantag sidto na plano nilan. ");
INSERT INTO kqe_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Agaw, sanggabi disinyan pyagaagad si Saul ng mga inindowan nan adto sang padir na yagalibot sang syodad. Byubutang nilan si Saul sang bokag aw tontona nilan yan adto sa daum sa logwa ng syodad. ");
INSERT INTO kqe_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Adon, pagdatung ni Saul adto sang Awrosalam, karim gao nan magupud sang mga yamangintoo kang Isa. Awgaid yamalluk silan kanan kay wa silan otoo na yamangintoo da yan kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ansinyan tyatabangan si Saul ni Barnabas aw pyagaagad nan yan adto sang mga sahabat. Gyogogod nan kanilan yang yamaitabo kang Saul na yagapakita aw yapagbaaw kanan si Tagallang Isa adto sang daan. Aw pyagalaong oman nan silan makapantag sang kaisug ni Saul sang pagosiyat nan makapantag kang Isa adto sang Damaskos. ");
INSERT INTO kqe_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Agaw, sikun sidto na wakto yumupud da si Saul kanilan. Aw maskin wain yan adto sang Awrosalam, wa yan akalluk magosiyat makapantag kang Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yapagbaaw aw yapaglalis yan sang mga Yahodi na Grik yang tiniyaban. Awgaid yagadumdum silan magpatay kanan. ");
INSERT INTO kqe_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na, pagkatigam sinyan ng mga kalomonan, yatud nilan si Saul adto sang Kisariya aw pyapasakay nilan yan sang bangka pasingadto sang Tarsos. ");
INSERT INTO kqe_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pagkatapos san kyakaonan ng kalinaw yang mga yamangintoo kang Isa sang kariko ng Yahodiya, Jalil aw Samariya. Yagakatigsun yang pagpangintoo nilan aw aon alluk nilan sang Tohan. Yabay silan tabangan ng Nyawa ng Tohan aw yagakadaig silan. ");
INSERT INTO kqe_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, si Pitros, yamakarimpud yan komadto sang kariko ng mga banwa na aon mga yamangintoo kang Isa. Sangallaw disinyan yagabisita yan sang mga otaw na sakop ng Tohan adto sang Lida. ");
INSERT INTO kqe_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Disidto aon kikita nan na otaw na pyagangaanan ni Aniyas. Wa yan makabangon sang kowangan nan sa suud ng wao pangka toig kay yamasadi yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ansinyan yagalaong si Pitros kanan, “Kay Aniyas, pyapakadyaw da kaw ni Isa Almasi. Bangon da aw luuna yang kanmo kowangan.” Ansinyan yagabangon dayon si Aniyas. ");
INSERT INTO kqe_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aw yang kariko ng mga yanaguya sang Lida aw Saron na yakakita na madyaw da yan, yamangintoo kang Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, adto sang syodad ng Yopa aon sambok na bobay na yamangintoo kang Isa. Yang ngaan nan si Tabita aw kong sang tiniyaban na Grik, Dorkas yang ngaan nan. Yani na bobay yabay maginang ng madyaw aw yabay nan tabangan yang mga miskinan. ");
INSERT INTO kqe_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Adon, sang wakto na adto si Pitros sang Lida, yagakasakit si Tabita aw kamatay. Syosogbowan da yang lawas nan aw byubutang sang kowarto adto sa taas ng baay. ");
INSERT INTO kqe_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na, yang syodad ng Yopa masaid sang longsod ng Lida. Agaw, pagdungug ng mga yamangintoo kang Isa na si Pitros adto sang Lida, yagasogo silan ng dowangka otaw adto kang Pitros antak magangyo kanan na makadto dayon sang Yopa. ");
INSERT INTO kqe_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na, pagangyo nilan kang Pitros, yamagad yan kanilan. Pagdatung nilan sang Yopa, pyagaagad nilan si Pitros adto sa taas ng baay sang kowarto na byubutangan ng patay na lawas. Disinyan pyagalibotan si Pitros ng mga biyoda na yanagsitiyao. Aw pyapakita nilan kanan yang klasi-klasi na mga dagom na tyatai ni Tabita nang bowi pa yan. ");
INSERT INTO kqe_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ansinyan pyapalogwa ni Pitros yang kariko nilan aw lyomood yan aw pagdowaa. Pagkatapos nan magdowaa, yapagatobang yan sang patay na lawas aw paglaong, “Kay Tabita, bangon da.” Ansinyan byoboka ni Tabita yang mata nan aw pagkita nan kang Pitros, yagaingkod yan. ");
INSERT INTO kqe_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ansinyan kyukuputan ni Pitros yang arima nan aw tabangi nan pagindug. Pagkatapos san tyatawag nan yang mga yamangintoo kipat sang mga biyoda aw pyapakita nan kanilan si Tabita na bowi da. ");
INSERT INTO kqe_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na, yang gogodanun makapantag sidto na ininang ni Pitros yamakarimpud sang tibok Yopa aw madaig yang yamangintoo kang Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aw si Pitros, yamadogay pa yan maguya adto sang Yopa sang baay ni Simon na sambok na tigbuad ng paris ng ayup. ");
INSERT INTO kqe_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, adto sang syodad ng Kisariya aon sambok na otaw na pyagangaanan ni Korniliyo. Kapitan yan ng mga sondao na taga Roma sang tyatawag na Batalyon Italyano. ");
INSERT INTO kqe_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yani na otaw baraibada aw aon alluk sang Tohan kipat oman sang tibok pamilya nan. Dakowa yang tabang nan sang mga Yahodi na miskinan aw yabay yan magdowaa. ");
INSERT INTO kqe_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na, sangallaw disinyan ng alas tres ng gabila, aon pyapakita kanan ng Tohan. Klaro yang pagkita nan sang malaikat ng Tohan na yosuud sang kowarto nan aw yagalaong kanan, “Kay Korniliyo.” ");
INSERT INTO kqe_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pyapakatanawan da nan yang malaikat na aon alluk aw laong nan, “Ono yang toyo mo kanak?” Yagalaong yang malaikat, “Wa kaw akaringawi ng Tohan kay dyudungug nan yang mga pagdowaa mo aw kikita nan yang pagtabang mo sang mga miskinan. ");
INSERT INTO kqe_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Adon pagsogo ng mga otaw adto sang Yopa antak pakaniun nilan kanmo si Simon na pyagangaanan oman ni Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Adto yan magauya sang baay ni Simon na tigbuad ng paris ng ayup na yang kanan baay masaid sang dagat.” ");
INSERT INTO kqe_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na, pagpanaw da ng malaikat, pyapatawag dayon ni Korniliyo yang dowangka otaw na sogowanun nan aw yang sangka otaw na sondao na kyakasarigan nan na baraibada oman na otaw. ");
INSERT INTO kqe_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ansinyan pyagalaong nan silan sang kariko ng yamaitabo aw syosogo nan silan adto sang Yopa. ");
INSERT INTO kqe_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na, pagkailaw disinyan ng alas dose yang suga, adto da silan sang daan na masaid sang Yopa. Sinyan na wakto pyomanik si Pitros sang pantay na atup ng baay antak magdowaa. ");
INSERT INTO kqe_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ansinyan yamagutum si Pitros aw yamallini da gao koman. Awgaid sarta yandam pa nilan yang pagkan, aon pyapakita kanan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kikita nan na yamabri yang langit aw aon maynang dakowa na komot na yamatonton sikun disinyan na yukutan sang opat na kanto. ");
INSERT INTO kqe_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Adto sa suud ng komot aon klasi-klasi na mga ayup aw mga mananap na yanagkodong sang lopa kipat oman sang mga langgam. ");
INSERT INTO kqe_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ansinyan aon dyudungug nan na sowara na yagalaong kanan, “Kay Pitros, indug! Pagsobari aw kan!” ");
INSERT INTO kqe_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Awgaid tyomobag si Pitros, “Kay Tagallang, di mapakay! Kay disti-disti wa ako makakan ng maskin ono na batar atawa haram.” ");
INSERT INTO kqe_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ansinyan yagalaong oman yang sowara, “Ayaw maglaong na haram yang maskin ono na pyapasotti ng Tohan.” ");
INSERT INTO kqe_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na, makatoo yan akaitabo aw pyapataas da isab idtong komot adto sang langit. ");
INSERT INTO kqe_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na, sarta yagadumdum pa si Pitros daw ono yang mana ng pyapakita kanan ng Tohan, dyomatung da yang mga otaw na syosogo ni Korniliyo. Yakatoltol silan sang baay ni Simon aw iyan da silan sang atobangan ng powertaan. ");
INSERT INTO kqe_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yagatawag silan aw yagaosip daw yan ba yang baay na pyagauyaan ni Simon Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Adon si Pitros, sarta yagadumdum pa yan sidtong pyapakita kanan ng Tohan, pyagalaong yan ng Nyawa ng Tohan, laong nan, “Aon toongka otaw na yagaanap kanmo. ");
INSERT INTO kqe_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kawas da aw ayaw magdowa-dowa pagagad kanilan kay ako yang yagasogo kanilan.” ");
INSERT INTO kqe_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ansinyan kyomawas si Pitros aw yagalaong yan sidtong mga otaw, “Ako si Pitros na yanap mayo. Ono yang toyo mayo kanak?” ");
INSERT INTO kqe_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yagalaong yang mga otaw, “Syosogo kami ani kanmo ni Kapitan Korniliyo. Madyaw yang batasan nan aw aon alluk sang Tohan aw yaddatan yan ng kariko ng mga Yahodi. Aon malaikat ng Tohan na yagalaong kanan na apakadtoon kaw sang kanan baay antak makapaningug yan sang pyaglaongan mo.” ");
INSERT INTO kqe_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ansinyan pyapapanaos silan ni Pitros adto sang baay aw ansan da silan komowang ng sanggabi. Pagkailaw disinyan yamagad si Pitros kanilan. Aw aon oman yamagad kanilan na mga yamangintoo na taga Yopa. ");
INSERT INTO kqe_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkasonod na allaw dyomatung da silan sang syodad ng Kisariya. Disidto yagatagad kanilan si Korniliyo kipat sang mga kalomonan nan aw mga amigo na pyagaimbitar nan. ");
INSERT INTO kqe_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pagdatung ni Pitros sang baay, yagasongon kanan si Korniliyo aw syomojod yan sang atobangan nan. ");
INSERT INTO kqe_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Awgaid pyapaindug ni Pitros si Korniliyo aw paglaonga nan, “Pagindug. Ayaw magsojod kanak kay magonawa da kita manosiya.” ");
INSERT INTO kqe_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ansinyan sarta yanagbaaw si Pitros aw si Korniliyo, yosuud silan adto sang baay. Pagsuud nilan, kikita ni Pitros na madaig yang mga otaw na yanagkatipon ansan. ");
INSERT INTO kqe_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yagalaong yan kanilan, “Kyakatigaman mayo na kami na mga Yahodi di makapagagad-agad atawa makabisita sang dili ng Yahodi kay sopak yan sang Hokoman ng kanami agama. Awgaid pyapakita kanak ng Tohan na di ko dait dumdumun na batar atawa haram yang mga otaw ng kadaigan na mga bangsa. ");
INSERT INTO kqe_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Agaw nang pyapakani mayo ako, wa ako magabaribad kamayo. Adon karim ko katigaman daw nanga sa pyapakani mayo ako.” ");
INSERT INTO kqe_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tyomobag si Korniliyo, laong nan, “Toong allaw yang yalabay na yagadowaa ako adi sang baay sang maynini na oras na mga alas tres ng gabila. Sakadyap aon yagapakita kanak na malaikat na yamandagom ng makasilaw. ");
INSERT INTO kqe_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yagalaong yan kanak, ‘Kay Korniliyo, dyudungug ng Tohan yang kanmo pagdowaa aw kyakadumduman nan yang kanmo pagtabang sang mga miskinan. ");
INSERT INTO kqe_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Adon, pagsogo ng mga otaw adto sang Yopa antak kangayun nilan si Simon na pyagangaanan oman ni Pitros. Adto yan magauya sang baay ni Simon na tigbuad ng paris ng ayup na yang kanan baay masaid sang dagat.’ ");
INSERT INTO kqe_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Agaw pyapakani ta kaw dayon. Aw madyaw na yakani kaw. Adon, ini da kami kariko sang atobangan ng Tohan antak maningug sang maskin ono na syosogo kanmo ng Tohan na pagalaong kanami.” ");
INSERT INTO kqe_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ansinyan yagalaong si Pitros, “Adon kyakatigaman da ko na bunna sagaw na way pyapalabi ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Awgaid adawatun nan yang sino-sino na aon alluk kanan aw matorid yang ininang nan na maskin ono yang bangsa. ");
INSERT INTO kqe_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sang way dowa-dowa dyudungug da mayo yang Madyaw na Gogodanun na pyapakatigam ng Tohan kanami na mga bangsa Israil na mapabarik yang madyaw na relasyon ng manosiya adto sang Tohan sabap kang Isa Almasi na yan yang Dato sang kariko. ");
INSERT INTO kqe_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aw sang way dowa-dowa kyakatigaman oman mayo yang yamaitabo sang kariko ng banwa ng mga Yahodi. Yang idto yagasogod sang probinsya ng Jalil pagkatapos ni Yahiya magosiyat na yang mga otaw dait magpasogbo. ");
INSERT INTO kqe_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Aw kyakatigaman oman mayo na si Isa na taga Nasarit yatagan ng Tohan ng Sotti na Nyawa aw kabarakat. Agaw maskin wain yan akadto, yagainang yan ng madyaw aw pyapakadyaw nan yang kariko ng mga kyakasaytanan kay iyan kanan yang Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kami yang yamakasaksi sinyan kay yakakita kami sang kariko ng ininang nan adto sang banwa ng mga Yahodi aw adto oman sang Awrosalam. Pyapatay yan ng mga Yahodi pinaagi sang paglansang kanan sang kaoy. ");
INSERT INTO kqe_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Awgaid sang ikatoong allaw sikun sang pagkamatay nan byobowi oman yan ng Tohan aw pyapakita kanami na bowi yan. ");
INSERT INTO kqe_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wa yan apakitaa sang kariko ng mga otaw kondi kanami gaid na pipili dadaan ng Tohan antak mainang ng mga saksi. Bunna sagaw na yanagupud kami kanan koman pagkatapos nan mabowi oman. ");
INSERT INTO kqe_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Syosogo nan kami pagosiyat sang mga otaw ng makapantag kanan aw sang pagpakatigam kanilan na si Isa yang pipili ng Tohan antak maghokom sang mga bowi aw yang mga patay. ");
INSERT INTO kqe_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yang kariko ng mga nabi yagasaksi oman makapantag kanan aw yagalaong silan na sino-sino yang amangintoo kanan amponon ng Tohan sang mga dosa nilan sabap kang Isa.” ");
INSERT INTO kqe_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na, sarta yagatiyab pa si Pitros, yukunsad yang Nyawa ng Tohan sang kariko ng yamaningug sang pyaglaongan nan. ");
INSERT INTO kqe_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ansinyan yamatingaa idtong mga yamangintoo kang Isa na mga Yahodi na yamagad kang Pitros sikun sang Yopa kay kikita nilan na maskin yang mga dili ng Yahodi yatagan ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kay dyudungug nilan na yanagtiyab da silan sang yagakatuna-tuna na tiniyaban na wa nilan akatigami aw pyopoji nilan yang Tohan. Ansinyan yagalaong si Pitros, ");
INSERT INTO kqe_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yani na mga otaw yatagan da adon ng Nyawa ng Tohan magonawa kanami na mga Yahodi. Agaw sagaw way makapaglaong na di silan mapakay sogbowan.” ");
INSERT INTO kqe_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ansinyan yagasogo si Pitros na sogbowan silan sang ngaan ni Isa Almasi. Pagkatapos san pyagadumutan nilan si Pitros na magapabilin adto kanilan ng pilang allaw. ");
INSERT INTO kqe_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ansinyan yamakadungug yang mga sahabat kipat sang kadaigan na mga yamangintoo kang Isa adto sang Yahodiya na yang mga dili ng Yahodi yamangintoo oman sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na, pagbarik ni Pitros adto sang Awrosalam, aon mga Yahodi ansan na yagasaway kanan kay yagalaong silan na yang dili ng Yahodi na yamangintoo kang Isa dait oman magpatoli sobay sang kabatasanan ng mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Laong nilan, “Nanga sa yakadto kaw sang baay ng dili ng Yahodi aw yumupud kaw kanilan koman?” ");
INSERT INTO kqe_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ansinyan gyogogod ni Pitros kanilan yang kariko ng yamaitabo sikun pa sang pagsogod. ");
INSERT INTO kqe_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Laong nan, “Sarta yagadowaa ako sang Tohan adto sang Yopa, aon pyapakita nan kanak. Kikita ko na aon maynang dakowa na komot na yukutan sang opat na kanto na tyotonton adi kanak sikun sang langit. ");
INSERT INTO kqe_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pagtanaw ko antak kitaun ko daw ono yang lasak, aon kikita ko na mga ayup, mga mangkaisug na ayup kipat sang mga mananap na yagakodong sang lopa aw mga langgam. ");
INSERT INTO kqe_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ansinyan aon dyudungug ko na sowara na yagalaong kanak, ‘Indug, kay Pitros. Pagsobari aw kan!’ ");
INSERT INTO kqe_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Awgaid yagalaong ako, ‘Kay Tagallang, di mapakay! Kay disti-disti wa ako makakan ng maskin ono na batar atawa haram.’ ");
INSERT INTO kqe_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ansinyan yagalaong oman yang sowara sikun sang langit, ‘Ayaw maglaong na haram yang maskin ono na pyapasotti ng Tohan.’ ");
INSERT INTO kqe_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na, makatoo yan akaitabo aw pyapataas da isab idtong komot adto sang langit. ");
INSERT INTO kqe_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Na, sidto na wakto aon dyomatung sang baay na pyagauyaan ko na toongka otaw sikun sang Kisariya. Syosogo silan antak kangayun nilan ako. ");
INSERT INTO kqe_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ansinyan pyagalaong ako ng Nyawa ng Tohan na di ako magdowa-dowa pagagad kanilan. Agaw yamagad ako kanilan kaupud sidtong unum na ka otaw na kalomonan ta na taga Yopa aw kyomadto kami sang baay ni Korniliyo. ");
INSERT INTO kqe_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pagdatung nami adto, gyogogodan kami ni Korniliyo na aon yagapakita kanan na malaikat adto suud ng kanan baay. Aw yagalaong kono yang malaikat kanan, ‘Pagsogo ng mga otaw adto sang Yopa antak pakaniun nilan si Simon na pyagangaanan oman ni Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kay magapakatigam yan kanmo ng pyaglaongan na makalowas kanmo kipat sang pamilya mo.’ ");
INSERT INTO kqe_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Adon, pagsogod ko magosiyat kanilan makapantag kang Isa, yukunsad kanilan yang Nyawa ng Tohan magonawa sang yamaitabo kanatun sidtong ona. ");
INSERT INTO kqe_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ansinyan kyakadumduman ko yang pyaglaongan ni Tagallang Isa sangani nang yagalaong yan, ‘Tobig yang pyagasogbo kamayo ni Yahiya, awgaid yang pagasogbo ko kamayo yang Nyawa ng Tohan.’ ");
INSERT INTO kqe_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na adon,” laong ni Pitros, “klaro da na yang yatag ng Tohan sang mga dili ng Yahodi magonawa sang yatag nan kanatun na mga Yahodi sidtong wakto na yamangintoo kita kang Isa Almasi na kanatun Tagallang. Na, sino ba ako na mosopak sang Tohan?” ");
INSERT INTO kqe_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na, pagdungug nilan sinyan, yagapakatingun silan aw wa da silan magasaway kang Pitros. Ansinyan pyopoji nilan yang Tohan aw laong nilan, “Na, kong maynan, maskin yang mga dili ng Yahodi tyotogotan da ng Tohan na makapagtawbat antak silan kaonan ng kinabowi na way kataposan.” ");
INSERT INTO kqe_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na, sikun sidtong wakto ng pagpatay kang Istiban yanagkakanat-kanat da yang mga yamangintoo kang Isa sabap sang pagpakasikot kanilan. Aon yakadatung sang banwa ng Pinisiya, sang poo ng Kipros aw adto oman sang syodad ng Antiyok. Ansidto na mga banwa yagapayapat silan ng makapantag kang Isa, awgaid adto gaid sang mga Yahodi. ");
INSERT INTO kqe_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Awgaid aon oman kadaigan na mga yamangintoo na taga Kipros aw taga Kirini na yakadto sang Antiyok aw yagapayapat silan ng Madyaw na Gogodanun makapantag kang Tagallang Isa adto oman sang mga dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yagadan silan ng kabarakat ng Tohan aw madaig yang yamangintoo aw yamangagad kang Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na, pagdungug ng jamaa adto sang Awrosalam ng makapantag sinyan, syosogo nilan si Barnabas adto sang Antiyok. ");
INSERT INTO kqe_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pagdatung nan adto, yamasowat yang ginawa nan kay kikita nan na dakowa yang tabang ng Tohan sang mga taga Antiyok. Agaw pyagalaong silan ni Barnabas na padayonon nilan yang pagpangintoo nilan kang Tagallang Isa na iklas yang pangatayan nilan. ");
INSERT INTO kqe_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Yani si Barnabas madyaw na otaw. Pyagabuutan yan ng Nyawa ng Tohan aw matigsun yang kanan pagpangintoo. Agaw madaig yang mga taga Antiyok na yamangintoo sang Tagallang. ");
INSERT INTO kqe_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ansinyan kyomadto si Barnabas sang syodad ng Tarsos antak manganap kang Saul. ");
INSERT INTO kqe_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pagkita nan kang Saul, pyagaagad nan yan adto sang Antiyok. Aw yagapabilin silan adto sa suud ng sangka toig upud sang mga yamangintoo aw madaig yang mga otaw na pyagaindowan nilan makapantag kang Isa. Yang mga yamangintoo kang Isa adto sang Antiyok, silan yang ona na tawagun na mga Almasihin. ");
INSERT INTO kqe_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na, sidto na wakto nang adto pa sang Antiyok si Barnabas aw si Saul, aon mga magpapakatigamay sang pyapakatigam kanilan ng Tohan na dyomatung ansan sikun sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yang sambok kanilan na pyagangaanan ni Agabos imindug aw sabap sang pyapakatigam kanan ng Nyawa ng Tohan yagatagna yan na aon madatung na gutum sang kariko ng banwa. Na, yani na pyaglaongan nan yamatoman sang wakto na si Klaudiyo yang soltan sang Roma. ");
INSERT INTO kqe_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ansinyan yanagkaoyon yang mga yamangintoo adto sang Antiyok na kotob ng amagaga ng matag-isa kanilan apadaa nilan yang maskin ono na akatabang nilan adto sang mga kalomonan nilan na Almasihin na yanaguya sang Yahodiya. ");
INSERT INTO kqe_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na, ininang da nilan yan aw pyapadaa nilan yang tabang nilan kang Barnabas aw si Saul kay antak atag nilan sang mga pangoo ng jamaa adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na, sidto oman na wakto yagasogod si Soltan Hirod magpakasikot sang pilangka otaw na yamangintoo kang Isa ");
INSERT INTO kqe_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","aw pyapaotodan nan ng oo si Yakob na lomon ni Yahiya. ");
INSERT INTO kqe_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na, pagkatigam nan na yamasowat yang mga Yahodi sabap sidto na ininang nan, pyapadakup oman nan si Pitros. Yamaitabo yan sang wakto ng Pakaradyaan ng Pan na way Labadora. ");
INSERT INTO kqe_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagdakup kang Pitros, lyalasak yan sang pirisowan aw pyapabantayan yan sang opat ka gropo ng mga sondao na yang matag-isa na gropo tag-opat ka sondao. Kay karim ni Hirod na hokoman si Pitros sang atobangan ng kariko ng mga otaw pagkatapos ng Pakaradyaan ng Paglabay. ");
INSERT INTO kqe_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Agaw pyapabantayan da gaid si Pitros adto sang pirisowan. Awgaid yang jamaa yagapadayon magdowaa para kang Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na, sidto na gabi sang wa pa yang paghokom kang Pitros, yamatoog yan adto sang pirisowan sang tunga ng dowangka sondao. Gyagapos yan ng dowa na kadina aw aon oman mga gowardya na yagabantay adto sang powertaan. ");
INSERT INTO kqe_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sakadyap aon malaikat ng Tohan na imindug adto sang pirisowan aw kyakaallagan yang suud ng pirisowan. Dyadampaw ng malaikat yang abaga ni Pitros antak pokawon nan aw laong nan, “Pagdari! Bangon da!” Aw sinyan dayon yamangkatangtang yang dowa na kadina sang arima ni Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yagalaong kanan yang malaikat, “Pagbakos aw pagsandalyas.” Na, ininang da yan ni Pitros. Aw yagalaong oman kanan yang malaikat, “Soota yang sapaw mo na dagom aw agad kanak.” ");
INSERT INTO kqe_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ansinyan yamagad si Pitros sang malaikat paglogwa sikun sang pirisowan, awgaid yagadumdum yan na yagatagaynup gaid yan. Wa yan akatigam na bunna yang pagtabang kanan ng malaikat. ");
INSERT INTO kqe_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na, yalabayan da nilan yang pirmiro aw yang ikadowa na gowardya sampay na dyomatung silan sang potaw na powertaan na yamatobang sang syodad. Ansinyan yamabri gaid yan aw lyomogwa silan. Pagpanaw da nilan sang daan, sakadyap yamawaa yang malaikat. ");
INSERT INTO kqe_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ansinyan yamakasabot si Pitros na bunna kadi yang yamaitabo kanan aw laong nan, “Adon kyakatigaman da ko na syosogo ng Tohan yang kanan malaikat antak lowasun nan ako sikun kang Soltan Hirod kipat sang mga Yahodi na apatayun gao nilan ako.” ");
INSERT INTO kqe_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nang yamakasabot da si Pitros sang yamaitabo kanan, kyomadto yan sang baay ni Mariyam na ina ni Yahiya na pyagangaanan oman ni Markos. Madaig yang mga otaw na yanagkatipon ansan antak magdowaa. ");
INSERT INTO kqe_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na, pagdatung nan adto, yagatoktok yan sang powertaan sa logwa ng baay aw lyomogwa yang sogowanun na bobay na pyagangaanan ni Roda antak tanawon nan daw sino yang yagatoktok. ");
INSERT INTO kqe_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pagtobag ni Pitros, ikilaa nan yang tingug nan aw sabap sang bali na kasowat nan wa da nan abrii yang powertaan, awgaid dyomaagan yan adto suud ng baay antak paglaongon nan yang kadaigan na si Pitros adto sa logwa. ");
INSERT INTO kqe_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Awgaid yagalaong silan, “Yamabowang da kaw kowaw.” Awgaid pyagabarik-barik ni Roda yang pyaglaongan nan na bunna na si Pitros adto sa logwa. Ansinyan yagalaong silan, “Basin malaikat nan ingidto.” ");
INSERT INTO kqe_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Awgaid adto sa logwa, yabay pa magtoktok si Pitros. Na, sang orian yabrian da nilan yang powertaan aw pagkita nilan kang Pitros, yamatingaa sagaw silan. ");
INSERT INTO kqe_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Awgaid si Pitros, sisingyasan nan silan antak magpakatingun. Ansinyan gyogogod nan kanilan daw monono yang pagpalogwa kanan ng Tagallang sikun sang pirisowan. Aw yagalaong pa yan kanilan, “Paglaonga mayo si Yakob aw yang kadaigan pa na mga kalomonan ta ng makapantag sinyan.” Pagkatapos san pyomanaw si Pitros aw kyomadto sang tuna na banwa. ");
INSERT INTO kqe_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na, pagkailaw disinyan yamangkasamok yang mga sondao na yagabantay adto sang pirisowan kay wa silan akatigam daw ono yang yamaitabo kang Pitros. ");
INSERT INTO kqe_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yagasogo dayon si Hirod na anapun si Pitros, awgaid wa nilan ikitaa. Ansinyan pyagaimbistigar ni Hirod yang mga gowardya aw pyapapatay nan silan. Pagkatapos san pyomanaw si Hirod sikun sang probinsya ng Yahodiya aw kyomadto sang Kisariya kay adto da yan maguya ng pilang allaw. ");
INSERT INTO kqe_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na, sidto na wakto bali na kadaman ni Hirod sang mga taga Tiros aw Sidon. Agaw sarta adto pa si Hirod sang Kisariya, yanagkaoyon yang mga taga Tiros aw Sidon na magasogo silan ng mga otaw adto kanan antak mapagosay sang relasyon nilan. Karim nilan na magakadyaw yang ginawa ni Hirod adto kanilan kay yang pagkan nilan yagasikun sang kasakopan ni Soltan Hirod. Agaw pagdatung nilan adto, yapagamigo ona silan kang Blastos na sinarigan ni Hirod sang palasyo nan kay antak katabangan nan silan sang kanilan toyo. ");
INSERT INTO kqe_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Adon, pagdatung ng allaw na mapagkita si Hirod kanilan, yamandagom yan ng dagom ng soltan aw yagaingkod sang ingkodanan ng maghohokom aw paglaong-laong sang mga otaw. ");
INSERT INTO kqe_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pagkatapos nan maglaong-laong, byabantog yan ng mga otaw aw yanaglaong silan ng matanog, “Dili kanang otaw yani na pyaglaongan kondi kanang Tohan!” ");
INSERT INTO kqe_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na, sinyan dayon sisiksa ng malaikat ng Tohan si Hirod sabap ng dyadawat nan yang pagbantog kanan ng mga otaw aw wa nan atagi ng kabantog yang Tohan. Ansinyan kyakan yang lawas ni Hirod ng mga ood aw kamatay yan. ");
INSERT INTO kqe_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Awgaid yabay pa makarimpud yang pyaglaongan ng Tohan sang kariko ng Awrosalam aw yagakadaig yang mga yamangintoo kang Isa Almasi. ");
INSERT INTO kqe_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na, si Barnabas aw si Saul, yamatapos da nilan yang kanilan gawbuk adto sang Awrosalam aw byomarik da silan adto sang Antiyok. Pyagaagad nilan si Yahiya na pyagangaanan oman ni Markos. ");
INSERT INTO kqe_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Adon, adto sang jamaa sang Antiyok aon mga otaw na magpapakatigamay sang pyapakatigam kanilan ng Tohan aw mga magiindoway sang pyaglaongan ng Tohan. Yani silan si Barnabas, si Simiyon na tyatawag oman ni Negro, si Lokiyos na taga Kirini, si Manain na tyomorin sang baay ni Gobirnador Hirod, aw si Saul. ");
INSERT INTO kqe_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na, sangallaw disinyan nang yagasambayang aw yagapowasa silan, yagalaong kanilan yang Nyawa ng Tohan, “Laina mayo si Barnabas aw si Saul antak inangun nilan yang gawbuk na pyagakahanda ko kanilan.” ");
INSERT INTO kqe_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Agaw, pagkatapos nilan magpowasa aw magdowaa, dyadapunan nilan si Barnabas aw si Saul ng arima nilan aw pyapapanaw nilan. ");
INSERT INTO kqe_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Adon, syosogo da ng Nyawa ng Tohan yaning dowangka otaw na si Barnabas aw si Saul aw kyomadto silan sang syodad ng Silokiya. Disidto syomakay silan sang dakowa na bangka pasingadto sang poo ng Kipros. ");
INSERT INTO kqe_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pagdatung nilan sang longsod ng Salamis, yagaosiyat silan ng pyaglaongan ng Tohan adto sang mga pagsasambayangan ng mga Yahodi. Kaupud oman nilan si Yahiya Markos antak tomabang sang kanilan gawbuk. ");
INSERT INTO kqe_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ansinyan yamarimpud nilan panawon yang tibok poo sampay na dyomatung silan sang longsod ng Papos. Disidto aon kikita nilan na sambok na Yahodi na pyagangaanan ni Bar-Isa. Sambok yan na madyikiro aw yagalaong yan na nabi kono yan. ");
INSERT INTO kqe_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amigo yan ng gobirnador sidto na poo na si Sirgiyos Paulus na matigamay na otaw. Sangallaw disinyan pyapatawag ng gobirnador si Barnabas aw si Saul kay mallini yan maningug sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Awgaid idtong madyikiro na pyagangaanan oman ni Ilimas kay idto yang ngaan nan sang tiniyaban na Grik, yapaglalis kang Barnabas kipat kang Saul. Pyapaningkamotan nan magdistorbo sang gobirnador antak di mangintoo sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na adon, si Saul na pyagangaanan oman ni Paulus, pyagabuutan da yan ng Nyawa ng Tohan. Pyapakatanawan nan idtong madyikiro ");
INSERT INTO kqe_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aw laong nan, “Anak kaw ng saytan! Kay yosopak kaw sang maskin ono na madyaw. Way lain na ininang mo yatabiya yang magpangilad aw magpanlimbong. Nanga sa yabay kaw maglaong na bakak kono yang bunna na indowan na yagasikun sang Tohan? ");
INSERT INTO kqe_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Awgaid adon, isiksaun da kaw ng Tohan. Amabota da kaw aw sa suud ng pilang allaw maskin yang kasiga ng suga di da mo ikitaun.” Na, sinyan dayon yagakaduguum yang pananaw ni Ilimas na maynang tyatabonan yan ng gabon. Yamanadsad da gaid yan aw yamanganap ng otaw na makatonggay kanan. ");
INSERT INTO kqe_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pagkita ng gobirnador sinyan na pangitabo, yamangintoo yan kay yamatingaa yan sang pyagaindo makapantag kang Tagallang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ansinyan syomakay da oman si Paulus kipat sang mga kaupdanan nan sang dakowa na bangka aw lyomayag silan sikun sang Papos pasingadto sang Pirga na sakop ng Pampiliya. Pagdatung nilan adto, pyapanawan silan ni Yahiya Markos kay yomori yan adto sang Awrosalam. ");
INSERT INTO kqe_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Awgaid silan Paulus, sikun sang Pirga pyomanaos silan adto sang longsod ng Antiyok sang probinsya ng Pisidiya. Pagdatung ng Allaw ng Pagpatana, kyomadto silan sang pagsasambayangan ng mga Yahodi aw pagingkod ansan. ");
INSERT INTO kqe_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pagkatapos ng pagbatya sang Kitab Tawrat aw yang syosorat ng mga nabi, yagatogon yang mga pangoo ng pagsasambayangan adto kanilan Paulus, laong nilan, “Mga lomon, kong aon pagalaong mayo sang mga otaw na makatigsun sang pangatayan nilan, mapakay da kamo maglaong.” ");
INSERT INTO kqe_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na, imindug si Paulus aw sisingyasan nan yang mga otaw antak magpakatingun aw laong nan, “Mga kalomonan ko na bangsa Israil aw kamo na dili ng bangsa Israil awgaid aon alluk sang Tohan, paningugi mayo yaning pagalaong ko kamayo. ");
INSERT INTO kqe_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yang Tohan na syasambayangan ng mga bangsa Israil, pipili nan yang kanatun mga kaompowan antak mainang silan ng dakowa na bangsa. Aw sarta yagauya silan adto sang banwa ng Misir na dili ng kanilan banwa, yagakadaig silan. Ansinyan tyatabangan silan ng Tohan aw sabap sang kanan kabarakat yakapanaw da silan sikun sidto na banwa. ");
INSERT INTO kqe_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na, sa suud ng 40 ka toig sarta adto silan sang diserto pyagasabaran ng Tohan yang pagsopak nilan kanan. ");
INSERT INTO kqe_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aw pagdatung nilan sang banwa ng Kanaan, pyapadaog silan ng Tohan sang pitongka bangsa aw yatag nan kanilan yang banwa ng Kanaan. ");
INSERT INTO kqe_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yamainang yang kariko sinyan sa suud ng 450 ka toig. “Pagkatapos san, yatagan silan ng Tohan ng mga maghohokom na yagadato kanilan sampay sang wakto ni Nabi Samuel. ");
INSERT INTO kqe_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sang kadogayan disinyan yamangayo yang mga bangsa Israil ng soltan na magadato kanilan. Agaw pipili ng Tohan si Saul na anak ni Kis na topo ni Binyamin. Aw yagasoltan yan sang bangsa Israil sa suud ng 40 ka toig. ");
INSERT INTO kqe_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ansinyan kyakamang ng Tohan si Saul sang pagkasoltan nan aw pipili nan si Daud na magasoltan kanilan. Aw yagalaong yang Tohan makapantag kanan, ‘Si Daud na anak ni Isai yang otaw na kyakallinian ko kay inangun nan yang kariko ng pagasogo ko kanan.’ ");
INSERT INTO kqe_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Adon,” laong ni Paulus, “sikun sang mga katopowan ni Daud yatagan kita ng Tohan ng manlolowas na pyapasad nan sang bangsa Israil, aw yan si Isa. ");
INSERT INTO kqe_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sang wa pa si Isa magasogod pagindo, yagaosiyat da si Yahiya sang mga bangsa Israil na dait silan magtawbat sang mga dosa nilan aw magpasogbo. ");
INSERT INTO kqe_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aw nang masaid da matapos yang pyapainang ng Tohan kang Yahiya, yagalaong yan sang mga otaw, ‘Basin yagadumdum kamo na ako yang manlolowas na tyatagadan mayo. Awgaid dili ko ingidto. Mosonod pa yan kanak domatung, aw maskin yang pagobad ng sandalyas nan di dait kanak.’ ” ");
INSERT INTO kqe_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yagapadayon maglaong si Paulus, “Mga kalomonan ko na mga topo ni Nabi Ibrahim, aw kamo na mga dili ng Yahodi na aon alluk sang Tohan, pagalaongon ta kamo na kita-kamo yang yatagan ng Tohan sining gogodanun makapantag sang kalowasan. ");
INSERT INTO kqe_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Awgaid yang mga Yahodi adto sang Awrosalam aw yang mga pangoo nilan, wa silan akatigam na si Isa yang pyapasad na manlolowas. Aw wa oman silan makasabot sang pyagalaong ng mga nabi sang Kitab na byabatya nilan matag Allaw ng Pagpatana adto sang pagsasambayangan nilan. Awgaid silan da yang yotoman sang pyagatagna ng mga nabi sabap sang kanilan paghokom na dait patayun si Isa. ");
INSERT INTO kqe_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maskin way kikita nilan na dosa na dait nan akamatay, yamangayo silan adto kang Pilato na apatayun si Isa. ");
INSERT INTO kqe_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na, pagkatapos nilan inangun yang kariko ng yamakasorat sang Kitab makapantag kang Isa, kyakamang nilan yang kanan lawas sikun sang kaoy na pyagalansangan kanan aw byubutang nilan sang kobor. ");
INSERT INTO kqe_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Awgaid byobowi oman yan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aw sa suud ng madaig na mga allaw yagapakita yan sang mga otaw na yamagad kanan sangaon sikun sa Jalil pasingadto sang Awrosalam. Na, silan adon yang mga saksi na yagalaong ng kabunnaan makapantag kang Isa adto sang mga bangsa Israil. ");
INSERT INTO kqe_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Na, ani da kami adon antak maglaong kamayo ng madyaw na gogodanun na yang pyapasad ng Tohan adto sang kanatun kaompowan ");
INSERT INTO kqe_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","yamatoman da adon kanatun na mga topo nilan sabap ng byobowi oman ng Tohan si Isa. Kay yamakasorat sang ikadowa na sura sang Kitab Jabor na yagalaong yang Tohan, laong nan, “ ‘Ikaw yang Anak ko. Adon na allaw apakatigam ko na ako yang kanmo Ama.’” ");
INSERT INTO kqe_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aw yang pyagalaong ng Tohan na obowiun oman nan si Isa antak di madonot yang lawas nan yamakasorat oman sang Kitab, kay laong nan, “ ‘Sang way dowa-dowa atag ko kanmo yang kadyawan na pyapasad ko kang Daud.’ ");
INSERT INTO kqe_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Aw aon oman yamakasorat sang Kitab Jabor na yagalaong, “ ‘Di mo otogotan na amadonot yang lawas ko na ako yang sotti na sogowanun mo.’ ");
INSERT INTO kqe_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Na, maskin si Soltan Daud yang yagalaong sinyan, dili ng ginawa nan yang karim nan ipasabot. Kay pyapangagadan ni Soltan Daud yang pyagakahanda kanan ng Tohan sang panahon nang bowi pa yan. Pagkatapos san yamatay da yan aw lyulubung yan sang masaid sang mga kaompowan nan. Aw yamadonot da yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Awgaid si Isa na byobowi oman ng Tohan sikun sang kamatay, wa akadonot yang lawas nan. ");
INSERT INTO kqe_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Idto sagaw, mga kalomonan ko,” laong ni Paulus, “dait mayo katigaman na sabap kang Isa pyapayapat da adon adto kamayo na aon kaamponan sang mga dosa mayo. Yang pagpangagad mayo sang Hokoman ni Nabi Mosa di makakamang sang mga dosa mayo. Awgaid sino-sino yang amangintoo kang Isa, amponon yan aw atarimaun yan ng Tohan na matorid. ");
INSERT INTO kqe_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Agaw, pagbantay kamo na di amaitabo kamayo yang pyagalaong ng mga nabi sang Kitab na yagalaong, ");
INSERT INTO kqe_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Pagbantay kamo na yagasaway sang mga otaw! Amangkatingaa kamo sang pagainangun ko, awgaid amangkamatay kamo! “‘Kay sang kamayo panahon aon inangun ko na di mayo pangintoowan maskin aon pay magapakatigam kamayo.’” ");
INSERT INTO kqe_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Adon, paglogwa ni Paulus aw si Barnabas sikun sang pagsasambayangan, yangyo silan ng mga otaw na kong mapakay magabarik silan sang sonod na Allaw ng Pagpatana antak magindo oman ng makapantag sini na mga butang. ");
INSERT INTO kqe_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na, pagori da ng mga otaw, madaig yang yamagad kang Paulus aw si Barnabas, mga Yahodi kipat sang mga dili ng Yahodi na yagapasakop sang agama Yahodi. Aw pyagalaong silan ni Paulus aw si Barnabas na magapadayon silan magsarig sang tabang kanilan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Adon, pagkasonod na Allaw ng Pagpatana, alos yang kariko ng mga otaw sidto na banwa yanagkatipon ansang pagsasambayangan nilan antak maningug sang pyaglaongan ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na, pagkita ng mga Yahodi sang kadaig ng mga otaw na yanagkatipon ansan, yamasina silan. Agaw syosopak nilan yang pyaglaongan ni Paulus aw ininsolto pa nilan yan. ");
INSERT INTO kqe_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Awgaid kyakadogangan pa yang kaisug ni Paulus aw si Barnabas aw yagalaong silan, “Dait gaid na kamo na mga Yahodi yang ona na osiyatan sang pyaglaongan ng Tohan. Awgaid sabap ng tyataripundaan mayo yang pyaglaongan nan maynang yagalaong kamo na di kamo dait atagan ng kinabowi na way kataposan. Agaw apasagdan da kamo nami aw makadto da kami pagosiyat sang mga dili ng Yahodi. ");
INSERT INTO kqe_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kay yani yang sogo kanami ng Tohan sang Kitab, laong nan, “ ‘Ininang ta kaw ng allag para sang mga dili ng Yahodi kay antak sabap kanmo amalowas yang kariko ng manosiya adi sang babawan ng donya.’ ” ");
INSERT INTO kqe_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na, pagdungug sinyan ng mga dili ng Yahodi, yamasowat silan aw byabantog nilan yang pyaglaongan ng Tohan. Aw yang kariko ng mga otaw na pipili ng Tohan na atagan silan ng kinabowi na way kataposan, yamangintoo. ");
INSERT INTO kqe_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ansinyan yamapayapat yang pyaglaongan ng Tohan sang kariko sinyan na banwa. ");
INSERT INTO kqe_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Awgaid yang ininang ng mga Yahodi sang Antiyok, pyagalaong nilan yang mga pangoo sidto na syodad kipat sang mga bobay na bantoganun na aon alluk sang Tohan maskin dili silan ng Yahodi, na mosopak silan kang Paulus. Agaw pyapakasikotan nilan si Paulus aw si Barnabas aw pyapapanaw nilan sikun sang banwa nilan. ");
INSERT INTO kqe_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na, pagpanaw nilan Paulus, tyatakdag nilan yang abog sang siki nilan silbi tanda na waa day labot nilan sang mga otaw sidto na banwa. Pagkatapos san kyomadto silan sang syodad ng Ikoniyom. ");
INSERT INTO kqe_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Awgaid yang mga yamangintoo kang Isa adto sang Antiyok, yamasowat silan aw pyagabuutan silan ng Nyawa ng Tohan. ");
INSERT INTO kqe_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pagdatung ni Paulus aw si Barnabas sang Ikoniyom, kyomadto silan sang pagsasambayangan ng mga Yahodi magonawa sang kyakaanadan nilan. Aw sabap sang kadyaw ng pagosiyat nilan madaig yang mga Yahodi kipat sang mga dili ng Yahodi na yamangintoo kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Awgaid yang kadaigan na mga Yahodi na wa apangintoo sang pyagaindo nilan Paulus, pyagalaong nilan yang mga dili ng Yahodi na mokontra sidtong yamangintoo kang Isa. ");
INSERT INTO kqe_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na, yamadogay si Paulus aw si Barnabas adto sang Ikoniyom. Wa silan akalluk magosiyat makapantag kang Tagallang Isa. Aw pyapakita ng Tagallang na bunna yang pyagaosiyat nilan makapantag sang kadyaw nan sang mga otaw kay yatagan nan silan ng kabarakat paginang ng mga tanda aw katingaan. ");
INSERT INTO kqe_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na, yanagkabain-bain da yang dumduman ng mga otaw sidto na syodad. Yang kadaigan yadapig sang mga Yahodi na wa apangintoo, aw yang kadaigan oman yadapig sang mga sahabat. ");
INSERT INTO kqe_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ansinyan yanagkaoyon yang mga Yahodi aw yang mga dili ng Yahodi upud sang mga pangoo nilan na apasakitan nilan silan Paulus aw obonoon nilan ng bato sampay na akamatay da nilan. ");
INSERT INTO kqe_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Awgaid pagkatigam sinyan ni Paulus aw si Barnabas, yalayas silan adto sang probinsya ng Likaoniya, sang mga syodad ng Listara aw Dirbi kipat oman sang makil