﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqc_vpl;
CREATE TABLE kqc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqc_vpl WRITE;
INSERT INTO kqc_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Senagi senagi, mirona ituari ourefeidena vene tora amegamadiri, adabo minari negau niyo. Bethlehem amiye yokoi Judah ri, ini rema ma rumana mida remanusa, Moab gaganiri roku reyadi. ");
INSERT INTO kqc_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Mina amiye di roka bi Elimelech ma ini rema di roka bi Naomi, ma ini mida remanu di roka bi Mahlon ma Chilion. Ina bi Ephrathah vene, Bethlehem taoni, Judah gagani vene. Ma disi Moab gaganiri amegamadi. ");
INSERT INTO kqc_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Amegamadiri, Naomi di maruka Elimelech muyeyo, ma ini rumana mida remanusa amegamadi. ");
INSERT INTO kqc_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Moab rema meyadi, ini roka bi Orpah ma Ruth. Lagani vana ufo amegamadiri, ");
INSERT INTO kqc_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mahlon ma Chilion ka muyeyadi ma Naomi bi maruka ma mida de inike amegamo. ");
INSERT INTO kqc_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Gabi Moab ri neideyo bi Varika amiye yaku amiye di rauna moyari aedesi iruku rau regamo. Naomi ini radini remanusa mina gagani ferei digi dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ini radini remanusa, ini amegamadi sana feresi Judah gagani di ida moiyadi. ");
INSERT INTO kqc_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kamini Naomi yaku ini radini remanu rofu niyo, “Ya remanu yi nono di yavari dairigedi. Varika amiye buni tora gade ya rofu moi ogau rebigo, na rofu ma yi muyenari regamadi kana. ");
INSERT INTO kqc_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Varika amiye ya remanu rofu yi gado variyaganedi rumana bouna ya mago.” Kamini ina remanu fuka reyo ma rema remanu isaka nigasa ");
INSERT INTO kqc_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","niyadi, “Una bi yi vene rofu yasa gogo dairigifa.” ");
INSERT INTO kqc_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Idu Naomi yaku niyo, “Dairifa nai vefa vene. Beika maina nasa baegedi? Ye nai rumana mida be moigida, ma yi maruka nigedi ba? ");
INSERT INTO kqc_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Rautu dairifa, nai vefa vene. Na bi rumana moina rofu, kamini ugava niyaka. Gokai beika nai mokenari uka mokedo gua urusari maruka nufa mida evata rigida ");
INSERT INTO kqc_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ma ina tora nigedi vonisi, ya bi ina tua de regedi. Ya bi na tua de resi de megedi ba? Ide, nai radiyaka, na rofu bi vegu gira tora, yi vegu kana de, ini adina Varika amiye na rofu gedu maro.” ");
INSERT INTO kqc_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Mina neideyadiri dudusa isaka niyadi. Kamini Orpah yaku ini radini fuka resi yuata niyo, idu Ruth yaku ini radini moi gira reyo. ");
INSERT INTO kqc_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi yaku niyo, “Na ve kumo, yi nabore bi dairido ini vene ma ini sei rofu. Ini vegu kana re.” ");
INSERT INTO kqc_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Idu Ruth nikabai reyo, “Ya feresi dairigida na ni guba ga re. Goidu digiya na ka digida, ma goidu amegiya na bi yasa amegida. Yi vene bi nai vene ma yi Sei bi nai Sei. ");
INSERT INTO kqc_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Goinari muyegiya na ka muyegida, ma mironari na guri aegedi. Varika amiye yaku kaunava gira gira na maraine, muyena yaku maka una gaima rigo vonisi.” ");
INSERT INTO kqc_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi yaku Ruth veyori, bi inasa dina vata rego, mina resi dairiyainedi ni guba de reyo. ");
INSERT INTO kqc_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ye ina remanu disi Bethlehem ri okiyadi. Bethlehem okiyadiri, rautu vene vesi tururu reyadi ma rema vene yaku ago ni tona dudu niyadi, “Aee, mirona bi Naomi ba?” ");
INSERT INTO kqc_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ina vene rofu niyo, “Naomi vo nisi nai roka ga nifo, idu nai roka Marah nifo, adina Varika amiye Vava yaku nai vegu di ida moi gira reyo. ");
INSERT INTO kqc_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Na bi gugura fore nufa diyaka, idu Varika amiye yaku notoka na moi dairiyo. Beika resi Naomi roka nidedi? Adina Varika amiye yaku esika na maro, Varika amiye Vava yaku no na fafau aeyo.” ");
INSERT INTO kqc_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ye Naomi, ini Moab radini Ruth ya ota risi Moab gagani feresi Bethlehem ri dairiyadi, barley ini butu butu rena di medari. ");
INSERT INTO kqc_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ma Naomi bi ini usika ourena nufa ini maruka di eta rofu, Elimelech rubu rofu, roka nufa ma gugura nufa amiye, ini roka bi Boaz. ");
INSERT INTO kqc_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ma Ruth Moab rema Naomi yaku niyo, “Na ni kumo murori nesi barley ada bubudo fereyadi butu rigida. Nai mokei vava reida amiye yokoi yaku na moigo ma inasa moimai regida.” Ma Naomi yaku ina rofu niyo, “Mo bovo, nai vefa.” ");
INSERT INTO kqc_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ye Ruth yaku murori nesi moimai vene usi digamo, moiga ferena barley ada bubudo butu rigamo. Iniye veyo ina bi Boaz di muro, kaere bi Elimelech di ruburi, moimai reyo. ");
INSERT INTO kqc_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Mina ituari Boaz Bethlehem gutuna okisi baeyo ma moimai vene rofu niyo, “Varika amiye bi yasa!” Ina yaku nikabai reyadi, “Varika amiye yaku buni tora gade ya mabobigo!” ");
INSERT INTO kqc_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ma Boaz yaku moimai ourefeidena amiye nikaiteyo, “Mirona bi kaere rema ofi?” ");
INSERT INTO kqc_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ourefeidena amiye yaku nikabai reyo, “Ina bi Moab gagani rema yokoi, kaere bi Naomi sa Moab gagani gutuna dairi baeyadi. ");
INSERT INTO kqc_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Mina rema yaku niyo, ‘Na ni kumo moimai vene usi barley butu rigida.’ Murori nesi moimai kora reyo uriyaku gutuna uriyenau niyo, minari bi neitua maka duduburi asa moiyo.” ");
INSERT INTO kqc_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Resi Boaz yaku Ruth niyo, “Nai vefa, nai mokena sina buni ya nigida. Bouna sanari ga butu ri, idu mina murori maka nai moimai rema venesa maka moimai re. ");
INSERT INTO kqc_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Murori rumana vene yaku nugasi butu rededi mina rema vene usi digasa tuta butu ri. Na bi rumana vene nioteimaraka, ga ya avaka moiyaganedi, ma koru vaigiyari moimai rumana vene yaku koru biyori usi aeyadi mina moisi iri.” ");
INSERT INTO kqc_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ye Ruth neideyori bi kuri agu risi ini ne kono masi Boaz rofu niyo, “Beika buni baku reyaka, na bi yava ika rema ma beika resi na rofu yi uka na maisa?” ");
INSERT INTO kqc_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boaz yaku nikabai reyo, “Yi maruka muyeyo gutuna baeyo ya yaku yi radini rofu beika regamo bi na niyadi, gokai yi nono baba ma yi ode yava feresi ma amiye toto venesa ameisa. ");
INSERT INTO kqc_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Varika amiye yi beika buni reyo ini obini dairi ya mago. Varika amiye, Israel di Sei, kaere ini ada gabireri ya rau redo, yaku ini obini tau ya mabobigo.” ");
INSERT INTO kqc_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ruth yaku nikabai reyo, “Nai varika amiye, ya yaku yi nemokori buni toga na mavo. Yi naivo rema rofu amuta dudu ago na ni maisa, idu na bi yi naivo rema yokoi kana de.” ");
INSERT INTO kqc_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Iruku iridedi ri Boaz yaku Ruth niyo, “Minari bae desi beredi be moigiya rofu waini ideri birisi iri.” Muro rena venesa ameinu reyori, Boaz yaku barley oriyadi mina be maro. Iruku iriyo rofu uka bere nisi bafu be fereyo. ");
INSERT INTO kqc_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Mina usi dadisi neyo barley butu rigi ri, Boaz yaku ini moimai vene ni mama reyo, “Tau rigedi sanari moigo ka ga vegasa nifa. ");
INSERT INTO kqc_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Idu tau riyadi sanari ini rata be moisi ae magedi ma butu riyaine. Ina rofu ga nivaifa.” ");
INSERT INTO kqc_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ye Ruth barley butu riyo ma uriyenau niyo, kamini tau risi mina utei reyo. Ini toe bi 10 kilogramme kana. ");
INSERT INTO kqc_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Mina adodisi taoni dairiyo ma gokaisanu tau moiyo mina ini radini yaku veyo. Beika irisi bafu fereyo mina ka moi yakusi ini radini maro. ");
INSERT INTO kqc_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi yaku ini radini nikaiteyo, “Ya bi gua goinari butu butu reyo? Kaere di sanari moimai reyo? Mina amiye kaere yaku ya vei mama riyo ina rofu bi buni tora gade mago!” Mina usi Ruth yaku ini radini nioteimaro kaere amiye di sanari moimai regamo. Niyo, “Mina amiye gua inasa moimai reyaka di roka bi Boaz.” ");
INSERT INTO kqc_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi yaku ini radini rofu niyo, “Varika amiye yaku uka buni ina rofu mabobigo! Ini buni tora gade bi toga rei baedo muyena ma vegu vene fafau.” Dudusa niyo, “Mina amiye bi uni davatu yokoi, uni usika ourena toe erufudo amiye yokoi.” ");
INSERT INTO kqc_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kamini Moab rema Ruth yaku niyo, “Boaz yaku ka na rofu niyo, ‘Nai moimai venesa amegiya bogo nai barley moimai rededi mina moi koina regedi.’” ");
INSERT INTO kqc_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi yaku ini radini Ruth rofu niyo, “Nai vefa, buni bi ini ofi venesa dibigiya, ini adina amiye be di murori digiyari yaugedi baebu.” ");
INSERT INTO kqc_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ye Ruth bi Boaz di moimai ofi ofi adinau amei digasa butu butu regamo boyo barley ma witi dogo reyadi koina niyo. Ma ini radinisa amegamo. ");
INSERT INTO kqc_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Meda nokoiri Naomi ini radini rofu niyo, “Nai vefa, na yaku rumana yokoi maina regida, ye yaike yava gaima amegiya. ");
INSERT INTO kqc_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ya bi Boaz di moimai rema venesa moimai regamadi. Resi Boaz, kaere bi uni davatu, gua urusa bi barley rama utei resi fotaka koka rena yavari barley fotaka makugo. ");
INSERT INTO kqc_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ya bi rafesi sisika buni vevero risi varuka burefe iniye akugiya. Resi mina yavari negiya, idu yi ne uruma bi ari kode ga veyaine iri-iri koina nigo mamo. ");
INSERT INTO kqc_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ini varedo sana vei diba re. Bosi ini yuka bou sase resi vare. Beika regiya bi ina yaku ya nigo.” ");
INSERT INTO kqc_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ruth yaku nikabai reyo, “Ya yaku beika nisa bi regida.” ");
INSERT INTO kqc_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ye Ruth ini radini yaku niyo kana fotaka utei resi koka rena yavari neyo. ");
INSERT INTO kqc_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boaz ini vima buni dudu, iri-iri koina niyo ri barley tau riyadi sanari varegi neyo. Ruth kiya kiya atafu bosi ini yuka bou sase resi vareyo. ");
INSERT INTO kqc_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Uru tobori Boaz tururu resi kero reyo ma rema yuka adinari varedo veitao reyo. ");
INSERT INTO kqc_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ni kaiteyo, “Ya bi kaere?” Ina yaku niyo, “Na bi Ruth yi moimai rei tavoi reida rema, yi varuka bou riyo tu yaku na bou ri, adina ya bi usika ourena toe erufusa amiye.” ");
INSERT INTO kqc_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz yaku nikabai reyo, “Nai vefa, Varika amiye yaku buni tora gade ya mabobigo. Beika gua reyo di uka buni, ma sena mokei tora reyo kana de. Ya bi rumana ruaka gugura tau nufa o tau de maina de reyo. ");
INSERT INTO kqc_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Nai vefa, ori ga re. Yi beika usa nigiya na bi regida. Nai asiyaka rumana tau taoniri bi ina diba ya bi vegu buni rema. ");
INSERT INTO kqc_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Rama na ka yi maruka di usika ourena amiye, idu usika ourena toe erufudo amiye ka atafuri amedo. ");
INSERT INTO kqc_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Gua urusa minari varegiya ma uriyaku mirona rumana ya uka mokego ri ya mego, bi buni. Idu ya uka de mokego vonisi, bi rama iniye Varika amiye amedo dada, na yaku regida. Gua bi varei ari uveyo.” ");
INSERT INTO kqc_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ye Ruth bi Boaz di yuka adinari vareyo idu amiye ga diba niyagane uriyaku gorogoro dadiyo. Ma Boaz niyo, “Amiye ga neidegedi rema fotaka utei resi koka rena yavari dui reyo.” ");
INSERT INTO kqc_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boaz ka niyo, “Yi varuka moi baesi rafori ibu re.” Makai reyori, Boaz yaku 20 kilogramme kana barley rausi resi Ruth adodi maro. Ma taoniri dairiyo. ");
INSERT INTO kqc_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kamini Ruth okiyo ma ini radini yaku nikaiteyo, “Nai vefa, gokai dibo reyo?” Resi Boaz yaku beika tau reyo mina nioteimasi ");
INSERT INTO kqc_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ka niyo, “Ina yaku mina feta 6 barley na masi niyo, ‘Vana notoka yi radini rofu de dairigiya.’” ");
INSERT INTO kqc_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kamini Naomi ya niyo, “Nai vefa, tua re, ve kumo gabi beika vata nigo. Boaz bi asa moina de koderi mina ago gua moi rorobo rego.” ");
INSERT INTO kqc_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Mina ituari Boaz dadi bosi taoni di ida venari ameinu reyo. Usika ourena toe erufudo amiye, kaere bi Boaz yaku sena nidodi reyo, mina baeyori Boaz yaku raka niyo, “Nai asini, bae minari ameinu re kumo.” Ye boinesi ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boaz yaku taoni di tora vene vana ufo moisi niyo, “Minari ameinu regedi.” Ye makai reyadi. ");
INSERT INTO kqc_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Resi usika ourena toe erufudo amiye rofu niyo, “Naomi bi Moab gutuna dairi baesi uni dubuini Elimelech di kono tu bi sero redo. ");
INSERT INTO kqc_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Nai mokena bi mina ago niokuda ameinu reyadi ma nai amiye di tora tora di nemokori ya yaku voi reyaine. Voi regiya vonisi bi buni. Idu, ya de voi regiya vonisi ka na nioteima resi na diba. Adina amiye yokoi ini vava de idu ya maka, ma usi bi na.” Ma niyo, “Na yaku voi regida.” ");
INSERT INTO kqc_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kamini Boaz yaku niyo, “Mina kono Naomi rofu voi regiya medari bi, Ruth kaere bi Moab rema ma obu niyo ka voi moigiya mini. Makai regiyari bi mina kono di muyeyo amiye di rokasa amebigo.” ");
INSERT INTO kqc_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Mina usi usika ourena toe erufudo amiye yaku nikabai resi niyo, “Makai bi nai vava mina rofu moi taga rigida adina makai regidari, bi nai mida mida yaku mina kono de moigedi. Ye, ya yaku voi re. Na bi anua regida.” ");
INSERT INTO kqc_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Sena ituari Israel gaganiri bi kono o gugura sero regika bi, sero redo amiye yaku ini yuka ro moisi voi resi amiye maro. Israel gaganiri kono o gugura sero regika makai resi koina niyadi. ");
INSERT INTO kqc_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ye mina usika ourena toe erufudo amiye yaku Boaz rofu niyo, “Ya kaya voi re.” Ma ina bi ini yuka ro kutusi maro. ");
INSERT INTO kqc_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kamini Boaz yaku tora vene ma amiye tau rofu niyo, “Gua vesi neideyadi na yaku Elimelech, Chilion ma Mahlon di gugura tau Naomi rofu voi reyaka. ");
INSERT INTO kqc_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ye Ruth, kaere bi Moab rema ma Mahlon di obu ka nai rema niyo. Makai regidari bi muyei diyadi vene di roka amebigo ini gugurasa, ye ini roka ini usika ourena di rofu, ma taoniri roka bura rededi bukari de roro nigo. Gua vesi neideyadi.” ");
INSERT INTO kqc_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Resi tora vene ma amiye tau bi mina taoni di ida venari yaku niyadi, “Rama, una bi vesi neideyafa vene mini. Varika amiye yaku mina rema kaere yi yavari bogo rofu buni reyaine, Rachel ma Leah kaere bi Israel di mida tau evata reyadi kana. Ya bi Ephrathah ri amiye tora nigiya ma Bethlehem ri ka yi roka ogau nibogo. ");
INSERT INTO kqc_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Varika amiye yaku mina rema ofi rofu tutubena ya maraine, kaere bi Perez, Tamar ma Judah di mida, di usika ourena kana nigedi.” ");
INSERT INTO kqc_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ye Boaz yaku Ruth mesi inasa vareyo. Varika amiye yaku buni tora gade maro ma rivo nisi rumana mida odiyo. ");
INSERT INTO kqc_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kamini rema vene yaku Naomi nioteimaradi, “Varika amiye buni tora gade masifa, kaere bi mina medari usika ourena toe erufudo amiyesa ya ferei tavoi de reyo. Ina bi Israel gaganiri ini roka tora niyaine! ");
INSERT INTO kqc_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ina yaku mida odiyo kaere yaku yi vegu moi ruaka rego ma ugava nigiyari ya nari rei mona reyaine. Adina yi radini kaere bi ini uka ya mado bi rumana mida 7 ya yaku moiyagaduri ka vo nisi ya rofu bi buni niyagadu.” ");
INSERT INTO kqc_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Resi Naomi yaku mina mida moisi ini budari aesi nari reyo. ");
INSERT INTO kqc_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Rema vene mironari amededi yaku niyadi, “Naomi bi rumana mida nufa niyo.” Ma ina roka niyadi Obed. Ye ina bi Jesse di baba, ma Jesse bi David di baba. ");
INSERT INTO kqc_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Mina bi Perez di vata ni raroda reyadi vene: Perez bi Hezron di baba, ");
INSERT INTO kqc_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron bi Ram di baba. Ram bi Amminadab di baba, ");
INSERT INTO kqc_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadab bi Nahshon di baba, Nahshon bi Salmon di baba, ");
INSERT INTO kqc_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon bi Boaz di baba ma Boaz bi Obed di baba, ");
INSERT INTO kqc_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed bi Jesse di baba, ma Jesse bi David di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mina bi Iesu Keriso di tutubena imito rina sina; ina bi David di tutubena, kaere bi Abraham di tutubena. ");
INSERT INTO kqc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham bi Isaac di baba, ma Isaac bi Jacob di baba, ma Jacob bi Judah ma ini dubuiyaka di baba niyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah bi Perez ma Zerah di baba (ini nono bi Tamar); Perez bi Hezron di baba niyo; Hezron bi Ram di baba; ");
INSERT INTO kqc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram bi Amminadab di baba. Amminadab bi Nahshon di baba; Nahshon bi Salmon di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon bi Boaz di baba ma ini nono bi Rahab. Boaz bi Obed di baba niyo, ma ini nono bi Ruth. Obed bi Jesse di baba niyo; ");
INSERT INTO kqc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse bi kini David di baba. David bi Solomon di baba niyo, ma ini nono sena bi Uriah di rema. ");
INSERT INTO kqc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon bi Rehoboam di baba niyo; Rehoboam bi Abijah di baba; Abijah bi Asa di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa bi Jehoshaphat di baba niyo; Jehoshaphat bi Jehoram di baba; Jehoram bi Uzziah di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah bi Jotham di baba niyo; Jotham bi Ahaz di baba; Ahaz bi Hezekiah di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah bi Manasseh di baba niyo; Manasseh bi Amon di baba; Amon bi Josiah di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mina ituari ini gagani gutuna nifeideyadi ma Babylon ri amegamadiri, Josiah bi Jehoiachin ma ini dubuiyakasa di baba niyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nifeideyadi ma Babylon amegamadi usi dinari Jehoiachin bi Shealtiel di baba niyo; Shealtiel bi Zerubbabel di baba; ");
INSERT INTO kqc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel bi Abiud di baba. Abiud bi Eliakim di baba niyo; Eliakim bi Azor di baba; ");
INSERT INTO kqc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor bi Zadok di baba niyo. Zadok bi Achim di baba niyo; Achim bi Eliud di baba; ");
INSERT INTO kqc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud bi Eleazar di baba. Eleazar bi Matthan di baba niyo; Matthan bi Jacob di baba. ");
INSERT INTO kqc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob bi Joseph di baba, Mary di maruka ina rofu Iesu vata niyo kaere roka niyadi bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ye Abraham gutuna deyo David di tutubena bi 14; David gutuna amiye nifeideyadi ma Babylon ri amegamadi di tutubena ka bi 14, ma amiye nifeideyadi ma Babylon ri amegamadi gutuna Keriso vata niyo di tutubena ka 14. ");
INSERT INTO kqc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ye, Iesu Keriso ini gokai vata niyo bi yomakai. Ini nono Mary bi Joseph nikau reyadi, idu gogo amena koderi bi, ma iniye Vima kikifa di vava dudu rivo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma ini nikau rumana Joseph bi mokena rorobo nufa amiye ye ina ura de Mary bi amiye di nemokori ini roka moi no rigo, ye inaike maka suiri nikau reyadi mina ukero vau rego di vonisi mokeyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Joseph mina mokegamori, Varika amiye di naivo naivo vima yaduka venari ogau nisi niyo, “Joseph, David di tutubena, Mary yi rema niyainedi bi megi bi ori ga re. Adina mina bi Vima kikifa di vava dudu rivo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mina rumana mida moigori, ini roka nigiya bi Iesu—ini adina bi ina yaku ini vene di vegu no rededi gutuna erufusi moi vegu rigo.” ");
INSERT INTO kqc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mina tau vakoi vata niyadi bi beika Varika amiye yaku ini ago niyo amiye rofu niyo bi rama aego: ");
INSERT INTO kqc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Rumanasa varena kode rema yokoi yaku rivo nisi rumana mida odigo, ye ini roka nigedi bi Immanuel” (ini adina bi, “Sei bi unasa”). ");
INSERT INTO kqc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph dadiyori, Varika amiye di naivo naivo vima yaku niyo kana Mary mesi ini yavari moi dui reyo. ");
INSERT INTO kqc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Idu inasa gogo varena de boyo rumana mida odiyo, ma Joseph yaku ini roka maro bi Iesu. ");
INSERT INTO kqc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ma Iesu bi Bethlehem taoni Judea gaganiri vata niyo; ma mina ituari Herod bi kini nisi amegamori, mokena vabara vene be meda dadido eta gutuna Jerusalem ri baesi ");
INSERT INTO kqc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nikaitegasa diyadi, “Mina mida ruika vata niyo kaere bi Jew vene di kini bi goini? Ini magai meda dadido eta rofu vesi ina nivakegika baeyafa.” ");
INSERT INTO kqc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kini Herod mina sina neideyori, uka kenoka yaku no niyo, ma Jerusalem ri amiye tau vakoi ka makai reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Dada Sei ma amiye utari naivo vene di varika vene ma Sei di ago gira oteimana vene tau vakoi nirutu resi nikaiteyo, “Keriso bi goinari vata nigo?” ");
INSERT INTO kqc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ina vene yaku nikabai reyadi, “Bethlehem ri Judea gagani ideri, ini adina Sei di ago niyo amiye yaku bi makai bura reyo: ");
INSERT INTO kqc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ye ya Bethlehem vene, Judah gaganiri, ga mokefa ya bi Judah di ourefeidena vene keika; ini adina ourefeidena amiye yokoi ya utari baego. Ina bi nai Israel vene fafau ourefeidego.’” ");
INSERT INTO kqc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma Herod yaku diba vene sui dudu nikaiteyo beika meda nemoko ramari mina magai ogau niyo ma Herod diba niyo. ");
INSERT INTO kqc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bethlehem ri neyaganedi nifeidegasa niyo, “Nesi mina mida maina rei mona regedi rofu baku regediri, na nioteimafa, ye na ka nesi ina nivakegida.” ");
INSERT INTO kqc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mina niyo neideyadiri, bi dadisi neyadi. Idau nedediri dudusa mina magai meda dadido eta rofu veyadi. Mina magai yaku ourefeidesi mina mida varegamo sanari bere niyo. ");
INSERT INTO kqc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mina magai vegasa ada yaku no iniye niyadi! ");
INSERT INTO kqc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ye yava ideri dui resi mina mida ini nono Mary sa vegasa efuka meimisi nivakeyadi. Resi ini magedi gugura, goro, sisika buni yabo ena roka frankincense, ma sisika buni yabo ena di muramura roka myrrh ini maua gutuna moi yakusi maradi. ");
INSERT INTO kqc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ini gagani dairigika bi ida yokoi moiyadi, ini adina bi Sei yaku yaduka dudu nioteimaro bi Herod rofu dairi ga boyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kamini mokena vabara vene ferei diyadiri, Varika amiye di naivo naivo vima yaduka dudu ogau nisi Joseph rofu niyo, “Herod bi mina mida umuyegika maina rego, ye dadisi mina mida ma ini nono moigiya ma Egypt urana ori negedi; ye mironari amegedi bogo ya nigida mamo Egypt ferei digedi.” ");
INSERT INTO kqc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mina urusari maka Joseph dadisi Iesu ma ini nono afeyo ma Egypt ri neyadi. ");
INSERT INTO kqc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Resi mironari amegamadi boyo Herod muyeyo mamo. Mina vata niyo bi beika Varika amiye yaku ini ago niyo amiye rofu niyo kana moi rama aeyo, “Nai mida Egypt gutuna raka niyaka ma yakuyo.” ");
INSERT INTO kqc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ye Herod mina diba vene yaku eru reyadi veitao regasa bi gubuyo yaku no niyo. Dadisi ini iya vene ago maro bi rumana mida mida ini lagani remanu ma egona rofu Bethlehem ri ma ini adinari gagani bi umuyei vau reyaganedi. Mina bi diba vene yaku niyadi ma neidesi diba ni mona reyo kana beika meda nemokori mina magai ogau niyo. ");
INSERT INTO kqc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Makai dudu beika Sei di ago niyo amiye Jeremiah yaku niyo bi rama aeyo: ");
INSERT INTO kqc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gagani roka Ramah ri kukuroka neideyadi, mina kukuroka bi isaka no iniye nigamadi. Rachel bi ini mida mida dada isaka niyo; muyei vau reyadi dada ina ura de ini uka moi amuta reyagane.” ");
INSERT INTO kqc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kamini Herod muyeyori, Varika amiye di naivo naivo vima Joseph rofu Egypt ri yaduka dudu ogau nisi ");
INSERT INTO kqc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","makai niyo, “Dadisi mina mida ma ini nono Israel konori afesi dairi bogiya, mina mida umuyegika reyadi vene muyeyadi dada.” ");
INSERT INTO kqc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ye dadisi Iesu ma ini nono Israel konori afesi boyo. ");
INSERT INTO kqc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Idu Joseph yaku neideyo Archelaus bi ini baba Herod gaubo resi Judea fafau ourefeidegamo, ye mironari dina ori reyo. Yaduka dudu besa beika reyainedi maro ye Galilee gagani rofu bosi ");
INSERT INTO kqc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","taoni yokoi roka Nazareth ri amegamo. Ye Sei di ago nidedi vene di ago bi rama aeyo: “Ina bi Nazareth amiye vo nigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mirona ituari John Baptist yaku Judea di gagani autu sanari okisi ago nirausi resi niyo, ");
INSERT INTO kqc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Yi vegu no feresi moi etagae rifa, adina Sei ini vava nufa omari ourefeidena amena sana bi negau niyo!” ");
INSERT INTO kqc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mina bi amiye kaere Sei di ago niyo amiye Isaiah yaku ina rofu makai niyo: “Amiye yokoi di goroka bi gagani autu sanari raka nido, ‘Varika amiye di ida dogo resi ini dibo ida moi rorobo rifa!’” ");
INSERT INTO kqc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ye John di varuka bi kamelo di ueta ma ini gagaba ukita maena bi boromakau di ro. Ini iruku bi kaufa ma kaoro di ona. ");
INSERT INTO kqc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kamini Jerusalem vene ma Judea gagani tora noibanu vene ma Jordan koru adinari gagani tau amiye vakoi ina rofu baegamadi. ");
INSERT INTO kqc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ye ini vegu no niogau regamadi ma Jordan koruri babatiso regamo. ");
INSERT INTO kqc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Idu John yaku Pharisee vene ma Sadducee vene tau ina rofu babatiso reyainedi baegamadi mina vegasa ina vene rofu niyo, “Ya bi aruma di mida mida kana—kaere yaku ya niyo, ‘Sei di gubuyo baego mina rofu ori diyaganedi’? ");
INSERT INTO kqc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mina dada vegu no feresi moi etagae rina vegu iniye yabo meko rama rena kana moi ogau rifa. ");
INSERT INTO kqc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma ya kaya nigi ga mokefa, ‘Abraham bi uni tutubena.’ Adina ya vene rofu nida, Sei ina diba mina fore dudu Abraham di tutubena rigo! ");
INSERT INTO kqc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sei bi yabo meko buni de varededi bi nu makusi ita fafau you bogo. Viro bi yabo daruri sena aeyadi ma yabo neinei meko buni de varededi bi nu makusi ita fafau you bogedi. ");
INSERT INTO kqc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na yaku yi vegu no feresi moi etagae rigi koru dudu ya babatiso reida, idu na usi baego amiye ini vava yaku nai vava ebu reyo, ye na bi rorobo de ini yuka ro nurugida. Ina bi Vima kikifa ma ita dudu ya babatiso rego. ");
INSERT INTO kqc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ini witi fotaka utei resi koka rena di fodiya bi ini vanari moi gira resi ini rama bi dobeka gutuna makusi yareyo mina ini yavari aego, idu ini sanika bi kafena de itari ori kamu rego.” ");
INSERT INTO kqc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mirona ituari Iesu Galilee gutuna Jordan koruri baeyo John yaku babatiso marainedi. ");
INSERT INTO kqc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","John yaku nivaigika niyo, “Ya yaku na babatiso regiya bi buni, idu ya bi na rofu baeyo!” ");
INSERT INTO kqc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Idu Iesu yaku nikabai reyo, “Ya eyouneida ye gua bi ya nida kana re. Mina ida dudu Sei di mokena rorobo tau gade bi moi rama aegifa.” Ye John yaku yo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu babatiso maro ma evade koru ideri gutuna bae iruruka resi ne reyori, bi oma ekeyo ma Sei di Vima bi pune erena kana desi ina fafau rou riyo mina veyo. ");
INSERT INTO kqc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma goroka yokoi oma gutuna degasa niyo, “Mina bi nai uka maida mida, kaere bi ina rofu ada tora gade reida.” ");
INSERT INTO kqc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mirona ituari Vima kikifa yaku gagani autu sanari Iesu afei boyo ma Bodaka yaku no reyainedi vonisi ini uka maina rena nivegika reyo. ");
INSERT INTO kqc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Meda 40 ri ma urusa 40 ri oyo resi gabi rauna reyo. ");
INSERT INTO kqc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma uka maina regika nivena amiye yaku baesi ina rofu niyo, “Ya bi Sei di Mida vonisi, bi yomina fore ni kumo iruku niyaine.” ");
INSERT INTO kqc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Idu Iesu yaku nikabai resi niyo, “Sei di agori bura reyo bi, ‘Amiye bi iruku maka dudu de amebigedi, idu ago neinei Sei di vena ma yakudedi dudu maka amebigedi.’” ");
INSERT INTO kqc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kamini Bodaka yaku Jerusalem taoni kikifari afei bosi Sei nivakena yava tebori moi are resi ");
INSERT INTO kqc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","niyo, “Ya Sei di mida vonisi, ya kaya maku ne, adina Sei di agori bura reyo bi: ‘Sei yaku ini naivo naivo vima ago gira mago ya dada; ma ini vana dudu ya moi odoro rigedi, yi yuka foreri de tagi magiya.’” ");
INSERT INTO kqc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu yaku niyo, “Dudusa bura reyo, ‘Varika amiye yi Sei bi ini uka maina regika ga nive.’” ");
INSERT INTO kqc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bodaka dudusa omuna ika torari afei bosi ourefeidena amena sana tau mina kono tora noibanuri ini buni vayavayasa oteimasi ");
INSERT INTO kqc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","niyo, “Ya na nivakegi efuka meimigiya vonisi, bi mina tau vakoi ya magida.” ");
INSERT INTO kqc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kamini nikabai resi niyo, “Satani, na rofu etagae ri, adina yomakai bura reyo, ‘Varika amiye yi Sei nivakesi ina rofu maka naivo re!’” ");
INSERT INTO kqc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kamini Bodaka feresi diyo ma Sei di naivo naivo vima yaku okisi nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu John Baptist moi gira reyadi mina neidegasa dadi bosi Galilee ri neyo. ");
INSERT INTO kqc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazareth feresi Capernaum taoni moka daidai tora Galilee adinari ameyo, Zebulun ma Naphtali gaganiri. ");
INSERT INTO kqc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mina reyo bi beika Sei yaku ini ago niyo amiye Isaiah rofu niyo bi moi rama aegi ma niyo: ");
INSERT INTO kqc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun ma Naphtali gagani bi moka daidai tora idari Jordan koru berou eta rofu, Galilee gaganiri. Ina vene bi tutubena idana vene. ");
INSERT INTO kqc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Amiye yaku mukunari amededi bi vabara tora veyadi. Ma mukuna kono ma muyena sanari amededi vene ina fafau bi vabara maro.” ");
INSERT INTO kqc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ye mirona ituari mamo Iesu ago nirausi regi kora resi niyo, “Yi vegu no feresi moi etagae rifa, Sei di ourefeidena amena sana omari bi atafu okiyo dada.” ");
INSERT INTO kqc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Galilee moka daidai tora seriri nana digasa uba dubuisa veyo, Simon (Peter vo niyadi) ma ini usika Andrew, kaere bi koruri fate makugamadi, adina bi oyena rutu vene. ");
INSERT INTO kqc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu yaku ina vene rofu niyo, “Na usi baefa ma oyena koda rena kana amiye nirutu rena ya rigida.” ");
INSERT INTO kqc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Minari maka ini fate feresi usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Minari bogasa bi uba dubuisa James ma John, Zebedee di mida veyo. Ina yaku ini babasa bouti fafau fate veika regamadi. Iesu yaku raka niyori, ");
INSERT INTO kqc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","bi evade ini baba ma ini bouti feresi usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ye Iesu Galilee gagani tau vakoiri ini usa usa yavari disi oteimasi Sei di ourefeidena amena sana di ago buni nirausi resi gauka tau amiye utari moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ye ini beika regamo sina bi Syria gagani torari okuyo, ye mina vene ka ini gauka reyadi vene, esika reyadi vene, yuka vana kevo vene, ini roaitari vima no nufa vene, ma ada gauka vene afei baeyadi—ma Iesu yaku moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amiye tau gade Galilee, Decapolis (taoni 10), Jerusalem, Judea gagani, ma Jordan koru di berou eta rofu gutuna dadisi Iesu usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kamini, Iesu yaku usi diyadi vene tau gade vesi omunari bosi ameyo ma ini usi dina vene ka bi ina rofu boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma oteimagasa, makai niyo: ");
INSERT INTO kqc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kaere amiye ina diba ini vimari Sei di gugura buni yokoi de bi ada regedi; adina bi Sei di ourefeidena amena sana omari bi ini! ");
INSERT INTO kqc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Isaka isaka nidedi vene bi ada regedi; ini adina ini iriyedukari moi ada rego! ");
INSERT INTO kqc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kaere bi ave nidedi ada regedi; ini adina bi mina kono noibanu moigedi! ");
INSERT INTO kqc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kaere ini ura bi mokena rorobo rofu rauna rededi kana bi ada regedi; adina ina bi moi vata baegedi! ");
INSERT INTO kqc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kaere iriyeduka rena vegu rededi vene bi ada regedi; Sei yaku ini iriyeduka ina fafau rego! ");
INSERT INTO kqc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kaere uka kino yokoi de nufa bi ada regedi; ini adina Sei vegedi! ");
INSERT INTO kqc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kaere uka amuta rededi vene bi ada regedi; ini adina Sei yaku ini mida mida vo nigo! ");
INSERT INTO kqc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kaere vegu rorobo dada esika esika moidedi vene bi ada regedi; ini adina Sei di ourefeidena amena sana omari bi ini! ");
INSERT INTO kqc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Amiye yaku na dada nifafana resi esika esika masi ya fafau ago no tau ofa ofa ago dudu nibigediri, bi ada regedi. ");
INSERT INTO kqc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ada regasa yauta nifa, adina yi obini omari moigedi bi tora, adina makai senagi Sei di ago niyadi vene esika esika maradi. ");
INSERT INTO kqc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ya bi kono di ramena kana. Idu ramena di safi koina nigo vonisi, bi gokai ida dudu moi dairigedi ma dudusa ramena nigo? Mina bi kamini no niyo, ye moi makugedi ma amiye yaku etei rigedi. ");
INSERT INTO kqc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ya vene bi mina kono di vabara. Taoni yokoi omuna ikari bi de sui nigo. ");
INSERT INTO kqc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma amiye yaku ka ramefa orisi foroka gabireri de aegedi, idu bi ini ikina sanari ikigedi; ye amiye tau yavari ameinu rededi rofu ini vabara kikigo. ");
INSERT INTO kqc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mina ida dudu maka, yi vabara bi amiye budari vabara niyaine, ye yi beika vegu buni bi amiye yaku vegedi rofu yi Baba omari mina ini roka moi odoro riyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ga mokefa na bi ago gira ma Sei di ago niyadi vene di ago mina moi uroro regika deyaka; na bi moi rama aegi deyaka, uroro regi de deyaka. ");
INSERT INTO kqc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rama ya nida, oma ma kono bi roro nigedi, idu ago girari bura keika kuni kuni yokoi kava ma tuta yokoi de roro nigedi bogo mina vegu tau vakoi rama aegedi mamo. ");
INSERT INTO kqc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaere amiye yaku mina ago gira di ago keika keika yokoi obe resi amiye be ka, ina yaku reyo kana, reyaganedi oteimago bi, Sei yaku ini ourefeidena amena sana omari bi moi keika rigo, idu kaere amiye yaku mina ago gira neidesi amiye be ka oteimabigo, bi Sei yaku ka ini ourefeidena amena sana omari ka ina moi odoro rigo. ");
INSERT INTO kqc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ye ya nida, yi vegu rorobo rededi bi ago gira oteimana vene ma Pharisee vene di vegu ebu rena de reyo vonisi, ya bi Sei di ourefeidena amena sana omari toga toga de dui regedi. ");
INSERT INTO kqc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ya sena tutubena vene rofu beika nigamadi bi neideyadi, ‘Amiye umuyena ga reyaganedi; ye kaere yaku amiye umuyego bi kota rego.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Idu ya nigida bi kaere ini usika ourena rofu gubuyo rego bi kota rego. Dudusa, kaere yaku ini usika ourena rofu nigo, ‘Ya bi ada de,’ ina bi kanisoro vene di nemokori are rego, ma kaere yaku nigo, ‘Ya bi mokena de rei tavoi tavoi reisa,’ bi ita moka rofu nena idari amego. ");
INSERT INTO kqc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mina dada, ya yi ori sisika rena Sei rofu moisi ini fore fata odoro magasa mokegiya yi usika ourena bi yasa gubuyo amedo vonisi, bi ");
INSERT INTO kqc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yi beika gugura magiya bi fore fata adinari ferena siko resi yi usika ourenasa uka yokoi maka nisi mamo dairisi yi beika gugura magiya mina ma. ");
INSERT INTO kqc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Yasa uka yokoi maka de nido amiye kaere yaku ya kota aegi rena koderi, evade ya kaya yi uka moi nomu risi uka yokoi maka ni. De bi kota neidedo amiye di vanari ya aego baebu, ma ina yaku dibura yava nari redo amiye di vanari ya aego ma dibura yavari ya aego. ");
INSERT INTO kqc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rama ya nida, mina sanari de yakugiya bogo kota ya ae niyo kana metona fore keika mai vau regiya mamo. ");
INSERT INTO kqc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sena nigamadi ma neideyadi, ‘Koa ga re.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Idu ya nida bi kaere amiye yaku rema vesi inasa varegi di moke moke moigo, bi sena ini ukari mina remasa koa reyo. ");
INSERT INTO kqc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ye yi vana rama nemoko yaku ya moi vegu no rofu ourefeidego vonisi, kini biyoka resi maku. Buni bi yi mina roaita keika maka makugiya, de bi yi roaita tora noibanu ita mokari makugo. ");
INSERT INTO kqc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma yi vana rama yaku ya moi vegu no rofu ourefeidego vonisi, bi nugai maku. Adina buni bi yi mina roaita keika maka makugiya, de bi yi roaita tora noibanu ita mokari nego. ");
INSERT INTO kqc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mina bi sena ka niyadi, ‘Kaere amiye ini rema ferego vonisi, bi rema ferena fefa masi nifeideyainedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Idu ya nida kaere amiye yaku ini rema feresi nifeidego, idu mina rema bi sena koa de reyo, mina rema bi amiye idana megori bi koa rena vegu nori moi dui rego. Ma mina amiye kaere bi rema mego ka bi koa rego. ");
INSERT INTO kqc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Dudusa, senagi tutubena vene rofu nigamadi ma neideyadi, ‘Yi nitore rena ago bi ga odefa, idu Varika amiye rofu yi beika nitore reyadi mina refa.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Idu ya nida bi oma fafau nivarika ga refa, adina mina bi Sei di ourefeidena amena fata; ");
INSERT INTO kqc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o kono roka fafau ga nitore refa, adina mina bi ini yuka aena sana; o Jerusalem fafau nitore ga refa, adina mina bi Kini tora di taoni. ");
INSERT INTO kqc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yi ada fafau ka nitore ga refa, adina yi ada iye fini yokoi maka mina de moi gabu o feyo rigedi. ");
INSERT INTO kqc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Idu ya ‘Yo’ nigedi vonisi, bi yo maka mokeyagane ma ya ‘Ide’ nigedi vonisi bi ide maka mokeyagane—beika mina fufuta rofu baedo bi amiye no di. ");
INSERT INTO kqc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sena nigamadi ma neideyadi, ‘Amiye yokoi yaku amiye idana ini nemoko yokoi ugori bi makai kana mina amiye reyo rofu refa ma amiye yokoi yaku amiye idana ini gade yokoi ubaki regori, bi makai kana mina reyo amiye rofu refa.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Idu gua na yaku nida bi amiye yaku ya rofu vegu no regori, bi ga gana ri. Ye kaere yaku yi rama rofu ragena famagori, bi berou ka moi kero resi ma. ");
INSERT INTO kqc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma amiye yokoi yaku ya kota aegika resi yi serti moigori, bi yi fafau varuka ka ma. ");
INSERT INTO kqc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma amiye yokoi yaku ya ni duri duri resi kilometre yokoi bovo ya nigo vonisi, bi kilometre yokoi inasa dudusa bo. ");
INSERT INTO kqc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma kaere ya rofu ya usa nigori, bi mina ma; ma kaere ya rofu moisi gabi dairisi ya mago usa nigori, bi ga gedu ma. ");
INSERT INTO kqc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sena nigamadi ma neideyadi, ‘Yi atafu amedo amiye uka masi yi tuma amiye rofu bi gubuyo re.’ ");
INSERT INTO kqc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Idu ya vene rofu nida, yi tuma vene rofu uka masi kaere yaku ya esika esika magedi bi ina dada usa usa nifa, ");
INSERT INTO kqc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ye ya bi yi Baba omari di mida mida nigedi. Adina ina yaku ini meda bi vegu no rededi vene ma buni vene fafau mado. Resi mokena rorobo nufa vene ma mokena rorobo nufa de vene fafau ini miya moi dedo. ");
INSERT INTO kqc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ye ya rofu uka madedi vene maka ina rofu uka magedi vonisi, bi ini buni gabi bi beika moigedi? Ye fore moidedi vene ka mina vegu rededi ba? ");
INSERT INTO kqc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma yi usika ourena maka yuata nigedi vonisi, ya bi amiye bedakai kana beika de rededi? Ye tutubena idana vene ka makai rededi. ");
INSERT INTO kqc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mina dada yi Baba omari bi rorobo iniye maka kana ya vene ka rorobo iniye maka dudu amebiyaganedi! ");
INSERT INTO kqc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Yi beika mokena rorobo di vegu rededi bi amiye di nemokori bi vei mona resi ga refa, ye amiye yaku veyaganedi. Adina makai regasa yi obini yi Baba omari rofu bi de moigedi. ");
INSERT INTO kqc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mina dada gugura beika de vene rofu mabigediri, bi yi budari kibi kukuroka ga nifa, ofarosi vene usa usa yavari ma idari rededi kana, ye amiye yaku ini roka moi odoro riyaganedi. Rama iniye ya nida, ina bi ini obini ka moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Idu gugura beika de vene rofu mabigediri, bi yi vana enana ka ga diba niyainedi vana rama yaku beika redo bi, ");
INSERT INTO kqc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ye yi beika reisa bi sui dudu re. Yi Baba yaku sui dudu beika reisa vegori, bi yi obini ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sei rofu usa usa nibigediri, bi ofarosi vene kana ga refa, adina ini mokena bi usa usa yavari ma ida teukana neineiri are resi usa usa nibigediri amiye yaku veyaganedi. Rama iniye ya nida, ini obini bi kamini moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Idu Sei rofu usa usa nibigediri, bi yi daiyutu ideri dui resi ida biri risi mamo yi Baba rofu usa usa nifa, kaere ya de vegedi. Kamini yi Baba sui dudu beika rededi ya vegasa yi obini ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ma Sei rofu usa usa nibobigediri, bi deda ago tavoi tavoi tau tutubena idana vene kana ga refa, ini mokena bi mina ago tau nidediri maka ini ofa sei yaku ina vene neidego dada. ");
INSERT INTO kqc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ye ina vene kana bi ga nifa, ini adina yi Baba bi usa nigediri yi beika nufa de bi sena diba niyo. ");
INSERT INTO kqc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mina dada yomakai usa usa nifa: ‘Uni Baba omari ameisa amiye: Yi roka bi kikifa iniye; ");
INSERT INTO kqc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","yi ourefeidena amena sana bi deyaine; yi ura bi konori vata niyaine, omari kana. ");
INSERT INTO kqc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gua meda di iruku una mai baesa, mina una ma. ");
INSERT INTO kqc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma uni vegu no koite maku, ma una ka amiye di vegu no una rofu rededi moi erufusifa kana. ");
INSERT INTO kqc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma uka maina regika nivena rofu ga una moi ourefeide, idu amiye no rofu una moi vegu ri.’ ");
INSERT INTO kqc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ye ya rofu vegu no rededi vene di vegu no moi erufugedi vonisi, yi Baba omari yaku ya rofu yi vegu no ka koite makugo. ");
INSERT INTO kqc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Idu amiye ini vegu no rededi de koite makugedi vonisi, yi Baba yaku ka yi vegu no rededi de koite makugo. ");
INSERT INTO kqc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Oyo rebigediri, ofarosi vene kana ga refa, ini ne uruma moi no rededi, ye amiye yaku vegedi ina bi oyo reyadi. Rama iniye ya nida, ina bi ini obini sena moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Idu oyo rebigediri, bi yi ne uruma koitesi yi ada iye sikoma imibifa, ");
INSERT INTO kqc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ye amiye yaku ka de ya vei mama regedi ya bi oyo rededi—idu yi Baba kaere bi sui ni beika sui dudu reyadi vesi yi obini ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mina konori gugura buni tau ya kaya ga ae torekai refa, nurina ma rasta yaku moi no regedi ma duma duma vene yaku dui resi duma regedi. ");
INSERT INTO kqc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Idu ya kaya gugura buni tau bi omari ae torekai rebifa, ye nurina ma rasta yaku de moi no rigedi ma duma duma vene yaku ka dui resi de duma regedi. ");
INSERT INTO kqc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Adina yi gugura buni tau amededi sanari yi uka di ura ka amebigo. ");
INSERT INTO kqc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yi nemoko bi ramefa di vabara kana yi roaitari. Mina dada yi nemoko buni vonisi, bi yi roaita tau noibanu bi vabara yaku vata baego. ");
INSERT INTO kqc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Idu yi nemoko no vonisi, bi yi roaita tau noibanu bi mukuna yaku vata baego. Yi vabara yi ideri bi mukuna vonisi, mina bi mukuna girigiri iniye! ");
INSERT INTO kqc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Amiye yokoi yaku amiye tora remanu di moimai rei tavoi rena di moimai anua rego. Adina bi yokoi rofu bi gubuyo resi yokoi rofu bi uka mago, o ina bi yokoi di ago neidesi yokoi rofu bi mokei itu rego. Ya bi Sei ma fore di moimai rei tavoi rededi vene di moimai kana rena bi anua regedi. ");
INSERT INTO kqc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mina dada ya nida, vegu nigasa amesi beika iruku ma koru irigedi o beika varuka akudedi rofu mokena toe ga moifa. Vegu amena bi iruku ebu redo, ma roaita yaku varuka ka ebu redo. ");
INSERT INTO kqc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Erena oma odoro vefa. Ina bi iruku yo varina o iruku goena o dokemari ae torekai de rededi; idu yi Baba omari yaku vana redo. Ya bi mina erena ebu rena iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ye ya kaere yaku ini ukari mokena toe moigori, mina mokena yaku ini vegu moi doba rego ba? ");
INSERT INTO kqc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma beika resi varuka dada mokena toe moidedi? Sufari farofaro bi gokai bodedi mina vefa; moimai de resi varuka de ridedi. ");
INSERT INTO kqc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Idu ya nida, kini Solomon di varuka burefe tau ka bi mina sufari farofaro kana de. ");
INSERT INTO kqc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sei yaku sufari farofaro imu mado—mina farofaro bi gua vegu amedo mini, idu agiya bi kufusi makugedi, ma roko nigediri, bi ita mokari origedi. Ye yi varuka dudu ya nari rei mona iniye rego, ya kaere bi mokena vari gira keika aededi vene! ");
INSERT INTO kqc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mina dada ya kaya nigika mokena toe ga refa: ‘Una bi beika iruku ma koru irigifa?’ o ‘Una bi beika varuka akugifa?’ ");
INSERT INTO kqc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Adina mina beika baika tau bi tutubena idana vene yaku maina rededi. Adina yi Baba omari ina diba ya mina tau bi de. ");
INSERT INTO kqc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Idu Sei di ourefeidena amena sana ma ini mokena rorobo siko maina refa kumo mina beika baika tau ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mina dada agiya di mokena toe ga moifa; ini adina agiya bi iniye ini mokena toe moigo. Ari neinei bi iniye ini mokena toe amedo. ");
INSERT INTO kqc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Amiye di no rofu mokei no ga refa, ye Sei yaku ka yi no rofu kota de rego. ");
INSERT INTO kqc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Adina ya yaku amiye di no rofu mokei no regedi kana, makai Sei ya kota rego, ma ya amiye gokai toe madedi kana, Sei yaku mina toe dairisi ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Beika resi bubudo yi usika ourena di nemokori bi veisa, idu yabo rata yi nemokori bi de nidodi reisa? ");
INSERT INTO kqc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","O gokai ida dudu yi usika ourena rofu nigiya, ‘Na fere kumo yi nemokori bubudo amedo mina moigida,’ ma yi nemokori yabo rata amedo bi? ");
INSERT INTO kqc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ya ofarosi amiye! Yi nemokori yabo rata amedo mina siko moi etagae rigiya, mamo vei mona resi yi usika ourena di nemokori bubudo amedo mina moi etagae ri. ");
INSERT INTO kqc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Beika bi akeke bi auna rofu ga masi yi fore roka pearl bi dona di budari ga makufa. Makai regediri, bi ini yuka yaku etei ri fufuta resi kero resi ya aki rei usika regedi. ");
INSERT INTO kqc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Usa nifa kumo ya mago; maina refa kumo baku regedi; raka nifa kumo ya rofu ida vena moi ekego. ");
INSERT INTO kqc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Adina kaere yaku usa usa nigo bi moigo, ma kaere maina rego bi baku rego, ma kaere raka nigo bi ina rofu ida vena moi ekego. ");
INSERT INTO kqc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","O yi fogori kaere amiye ini mida yaku beredi usa nigori, rama dadisi fore moi mago ba? ");
INSERT INTO kqc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O oyena usa nigori, rama dadisi aruma mago ba? ");
INSERT INTO kqc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ma ya vene no bi yi mida mida rofu gugura buni magi diba nidedi vonisi, bi yi Baba omari amedo amiye yaku gugura buni usa nigedi vene bi besa besa mago! ");
INSERT INTO kqc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mina dada ya ura rededi amiye yaku beika tau ya rofu rebigedi, ya ka ina rofu makai refa. Adina mina bi Moses di ago gira ma Sei di ago niyadi vene di ago di adina. ");
INSERT INTO kqc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ida vena kakaitari dui refa, adina no moina sana rofu bona ida vena bi rafo ma ini ida bi tora, ma amiye tau tora bi minari dui rededi. ");
INSERT INTO kqc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Idu ida vena bi kakaita ma ida bi keika vegu sana rofu bodedi, ma amiye tau de mina sana baku rededi. ");
INSERT INTO kqc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sei di ago nidedi ofa vene vei mona regasa amebifa. Ya rofu bi mamoe di varuka akusi baegedi, idu ini uka ideri bi sufa di gadeva auna no iniye iniye. ");
INSERT INTO kqc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ini beika moi ogau ridediri maka vei mama regedi. Rama amiye yaku waini meko bi imiye tafari butu de regedi o fuka meko bi onana imiyeri butu de regedi. ");
INSERT INTO kqc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ye yabo buniri bi meko buni varededi, idu yabo nori bi meko no varededi. ");
INSERT INTO kqc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yabo buniri bi meko no de varegedi, ma yabo nori bi meko buni de varegedi. ");
INSERT INTO kqc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yabo tauri meko buni de varededi mina yabo bi nugasi ita mokari ori kamu rededi. ");
INSERT INTO kqc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mina dada ini beika redediri maka vei mama regedi. ");
INSERT INTO kqc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Amiye tau kaere na rofu ‘Varika amiye’ vo nidedi, bi Sei di ourefeidena amena sana omari de dui regedi, idu nai Baba kaere bi omari amedo di mokedo vegu rededi vene maka dui regedi. ");
INSERT INTO kqc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mina medari Sei yaku amiye tau kota aegori amiye tau gade yaku na rofu nigedi, ‘Varika amiye, una bi yi rokari Sei di ago nirausi resi vima no meki resi mokena vegu regamafa ba ide?’ ");
INSERT INTO kqc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Minari mamo na yaku ina vene fafau nigida, ‘Vegu no rededi vene, na bi toga ya toto; na rofu etagae ri difa!’ ");
INSERT INTO kqc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mina dada amiye kaere yaku nai ago neidesi regedi, bi mokena tora amiye kaere yaku ini yava abita fore fafau akuyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Miya deyo, abata deyo, ma itu aura mina yava fafau baeyo, bi de yareyo, ini adina bi ini gado bi abita fore fafau akuyo dada. ");
INSERT INTO kqc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ye amiye kaere nai ago neidesi de rego, bi ada de amiye yaku ini yava vasa fafau akuyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Miya deyo, abata deyo ma itu aura mina yava fafau baeyori, ma ini yareyo bi no iniye iniye!” ");
INSERT INTO kqc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu mina ago ni vau reyori, mina amiye tau gade bi ini oteimana ago rofu tururu reyadi, ");
INSERT INTO kqc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","adina ini oteimana bi kaere vava nufa amiye kana, ma ago gira oteimana vene kana de. ");
INSERT INTO kqc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu omuna aveta gutuna deyori, amiye tau gade ina usi deyadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Idau refera amiye yokoi Iesu rofu bosi efuka meimigasa usa niyo, “Varika amiye, ya ura reisa vonisi, na moi ruaka rigiya.” ");
INSERT INTO kqc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kamini Iesu yaku ini vana moi roto risi mina amiye avaka moisi niyo, “Na ura reida; ruaka ni!” Minari maka ini roaitari refera gauka bi ruaka niyo. ");
INSERT INTO kqc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ye Iesu ina rofu niyo, “Amiye yokoi ga nioteima, idu nesi ya kaya Sei ma amiye utari naivo amiye oteimasi Moses yaku ago girari niyo kana Sei rofu moi ori sisika regiya. Ye amiye vegedi ya bi buni niyo.” ");
INSERT INTO kqc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Capernaum ri okiyori, Rome di iya rededi vene di ourefeidena amiye yokoi Iesu rofu niguyaguya regasa niyo: ");
INSERT INTO kqc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Varika amiye, nai naivo amiye bi yavari esika esika tora nufa kita kita de, varena maka redo.” ");
INSERT INTO kqc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ye niyo, “Bosi moi buni rigida.” ");
INSERT INTO kqc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Idu nikabai resi niyo, “Varika amiye, na bi rorobo de ya yaku nai yavari bogiya. Idu sina maka nigiya ma nai naivo amiye bi buni nigo. ");
INSERT INTO kqc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ka bi amiye be di vava gabireri ameida dada; iya rededi vene be bi nai vava gabireri amededi. Na yaku yokoi rofu nida, ‘Bo!’ vo nidari bodo; ma yokoi rofu nida, ‘Bae!’ vo nidari baedo; ma nai moimai rei tavoi redo amiye rofu nida, ‘Mina re!’ vo nidari redo.” ");
INSERT INTO kqc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu mina ago neidesi bi tururu resi kaere usi diyadi inasa rofu niyo, “Rama ya nida, Israel ri amiye yokoi di mokena vari gira aena makai de baku reyaka. ");
INSERT INTO kqc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ye ya nida amiye tau gade meda dadido eta rofu ma meda nedo eta rofu baegedi Abraham, Isaac ma Jacob sa Sei di ourefeidena amena sana omari ameinu resi irakuna irigedi. ");
INSERT INTO kqc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Idu Sei di ourefeidena amena sana mida mida kana auba reyo vene bi etofaro mukunari maku nego ma isaka nigasa gade aki gigi rebigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Resi iya rededi vene di ourefeidena amiye rofu niyo, “Bo, yi mokena vari gira aeyo kana bi vata nigo.” Mina meda nemokori maka ini naivo amiye buni niyo. ");
INSERT INTO kqc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu yaku Peter di yavari dui reyori, Peter di imokai rema bi roaita vaki vaki resi ekamari varegamo ma veyo. ");
INSERT INTO kqc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ini vana avaka moiyori, roaita vaki vaki bi fereyo ma iruku dabara resi nari regamo. ");
INSERT INTO kqc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uriyenauri vima no nufa amiye tau gade ina rofu afei baeyadi, ma ina yaku mina vima no ini ago dudu meki resi gauka vene tau ka moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Beika Sei di ago niyo amiye Isaiah yaku niyo bi makai moi rama aeyo, “Ina kaya uni roaita afi rena ma uni gauka moi etagae riyo.” ");
INSERT INTO kqc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu amiye tau gade yaku ina buru risi deyadi mina vegasa ini usi dina vene rofu ago maro moka daidai tora berou eta rofu boi neyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma ago gira oteimana amiye yokoi ina rofu baesi niyo, “Oteimana amiye, ya goinari digiya na bi ya usi digida.” ");
INSERT INTO kqc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma nikabai resi niyo, “Sufa auna bi ini fore ruba nufa ma erena odoro didedi bi ini buri nufa, idu Amiye di mida bi ini ada aesi raudai rena sana bi koina.” ");
INSERT INTO kqc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma ini usi dina amiye yokoi yaku ina rofu niyo, “Varika amiye, na fere kumo bosi nai baba kaere muyeyo siko moi guri aegida.” ");
INSERT INTO kqc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Idu nikabai resi niyo, “Muyena vene fere kumo ini muyena iniye moi guri aeyagane ma ya bi na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu bouti keu riyo ma ini usi dina vene ka inasa diyadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma itu aura tora iniye iniye mina moka daidai tora fafau reyo; ye koru tafo regamo ma ureure bouti fafa regi ka regamo. Idu Iesu varegamo, ");
INSERT INTO kqc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","dada ini usi dina vene ina rofu bosi edadisi niyadi, “Varika amiye, una bi kamini muyegifa. Una moi vegu ri!” ");
INSERT INTO kqc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ina yaku niyo, “Mokena vari gira keika aededi vene, beika resi ori reyadi?” Resi dadisi aura ma koru tafo besenai ago maro ma moka daidai tora bere gade ni ameyo. ");
INSERT INTO kqc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ye mina vene tururu resi niyadi, “Mina amiye bi gokai kana amiye? Aura ma koru tafo ka ini ago neidededi!” ");
INSERT INTO kqc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Moka daidai tora berou eta rofu Gadara gagani okiyadiri, amiye remanu vima no nufa bi Iesu baku regika amiye guri sana fore ruba gutuna yakuyadi. Ina bi isivaga iniye vene, ye amiye yaku mina idari dibo anua regamadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma evade raka nisi niyadi, “Sei di mida, beika resi una rofu baesa? Gua meda okina koderi esika esika una magi minari baeyo ba?” ");
INSERT INTO kqc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ye dona tau bi gaima ini vana irigamadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ye mina vima no yaku Iesu niguba regasa usa niyadi, “Una meki regiya vonisi, bi yomirona dona tau ideri una nifeide.” ");
INSERT INTO kqc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ina rofu niyo, “Difa!” Ye mina amiye remanu rofu yakusi dona tau ideri dui reyadi ma mina dona tau raravari raga nesi moka daidai torari yoyo resi koruri muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dona vana regamadi vene bi ori disi taoni vene beika vata niyo ma amiye remanu vima no nufa ina rofu beika vata niyo ka mina sina ni digamadi. ");
INSERT INTO kqc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ye taoni vene tau yaku Iesu baku regika boyadi; vegasa niguba reyadi ini gagani feresi diyainedi. ");
INSERT INTO kqc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mina usi Iesu bouti keu risi moka daidai tora rofu ugasi ini taoni iniye rofu boyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ye okiyori, amiye be yaku dibo anua amiye madunari ina rofu afei baeyadi. Iesu mina vene di mokena vari gira aena veifategasa mina dibo anua amiye rofu niyo, “Nai mida, mokei itu ga re! Yi vegu no bi koite makuyo.” ");
INSERT INTO kqc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma ago gira oteimana vene bedakai yaku iniye iniye rofu niyadi, “Mina amiye bi Sei di roka moi no rido!” ");
INSERT INTO kqc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ye Iesu yaku mina vene di mokena veifatesi ina rofu niyo, “Beika resi mokena no yi ukari mokededi? ");
INSERT INTO kqc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Adina goina ago nigida bi rena gira de, ‘Yi vegu no bi koite makuyo,’ o ‘Dadisi nana re’? ");
INSERT INTO kqc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Idu ya vei mama regedi Amiye di mida bi vava nufa konori vegu no koite makugo”—kamini dibo anua amiye rofu niyo, “Dadisi yi maduna vanau moisi yi yavari di!” ");
INSERT INTO kqc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ye mina amiye dadisi ini yavari diyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma amiye tau mina vesi bi ori resi Sei di roka moi odoro riyadi, makai Sei yaku vava kono amiye maro dada. ");
INSERT INTO kqc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma Iesu mironari gutuna bogamori, amiye yokoi ini roka Matthew, fore butu rena ofesiri vesi niyo, “Na usi bae.” Ma dadisi usi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gabi bi yavari ameinu resi iruku irigamori, fore butu rededi vene ma vegu no rena vene tau gade okisi Iesu ini usi dina venesa ameinu resi iruku irigamadi. ");
INSERT INTO kqc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma Pharisee vene mina vegasa ini usi dina vene nikaiteyadi, “Beika resi yi oteimana amiye bi fore butu rededi vene ma vegu no rededi venesa iruku iridedi?” ");
INSERT INTO kqc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Idu Iesu mina ago neidesi niyo, “Amiye buni bi gauka dogo amiye de mokegedi, idu gauka vene maka. ");
INSERT INTO kqc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Va disi mina ago di ini adina vei mona refa: ‘Na bi iriyeduka ura reida ma ori sisika rena bi de.’ Adina na bi mokena rorobo vene rofu disi raka nigi de okiyaka, idu vegu no rededi vene rofu okiyaka.” ");
INSERT INTO kqc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mina usi John di usi dina vene yaku ina rofu baesi nikaiteyadi, “Beika resi Pharisee vene ma una bi oyo resifa, idu yi usi dina vene bi de?” ");
INSERT INTO kqc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ye Iesu yaku nikabai reyo, “Rema mego amiye yaku ini asiyaka venesa amebigori, isaka nigedi ba ide? Ide mada! Idu rema mego amiye afei digedi di meda baegori, bi oyo regedi. ");
INSERT INTO kqc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kamini amiye yokoi bi ruaka ma koitena de varuka tu di varuka kori fafau faniya de rego; adina bi varuka moi rutu rego ma varuka kori uesi rego ma ruba tora nigo. ");
INSERT INTO kqc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Amiye waini ruaka moisi ini ro kori ideri ka de aego. Makai rego vonisi, bi ini ro ufatego ma waini rausi rego ma ro bi no nigedi. Idu waini ruaka bi ini ro ruaka ideri aego, ye ina remanu bi buni amebigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mina ago ina rofu nigamori, ourefeidena amiye yokoi baesi efuka meimigasa niyo, “Nai vefa bi gua muyeyo. Ye baesi yi vana ina fafau aegiya ma vegu niyaine.” ");
INSERT INTO kqc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ye Iesu ma ini usi dina vene dadisi ina usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mina usi rema yokoi, kaere bi lagani 12 rema di gauka guraugamo, yaku ini fufutari baesi ini varuka tu avaka moiyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Adina ina kaya rofu nigamo, “Na ini varuka maka avaka moigida vonisi, bi buni nigida.” ");
INSERT INTO kqc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ma Iesu kero resi mina rema vesi niyo, “Nai vefa, mokei itu ga re; yi mokena vari gira aena yaku ya moi buni riyo.” Minari maka buni niyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ye Iesu mina ourefeidena amiye di yavari okisi bi bibo una vene ma uka vorivori rena amiye kukuroka tora regamadi neidesi ");
INSERT INTO kqc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","niyo, “Yaku difa, mina rema mida bi muyena de reyo—idu bi neota maka varedo!” Idu mina vene bi ina rofu ninika nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mina vene tau nifeideyori, bi ideri disi ini vana moisi edadiyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma mina vegu di sina bi mina gagani tauri ogau niyo. ");
INSERT INTO kqc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kamini Iesu yaku mina sana feresi bogamori, ne taufa amiye remanu usi bogasa raka niyadi, “David di tutubena, una iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma yava ideri dui reyori, mina ne taufa amiye remanu ina rofu baeyadi, ma ina vene nikaiteyo, “Mokena vari gira aededi mina regida ba?” Ina yaku nikabai reyadi, “Varika amiye yo!” ");
INSERT INTO kqc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mina resi ini nemoko avaka moisi niyo, “Yi mokena vari gira aena dada bi ya rofu vata niyainedi!”— ");
INSERT INTO kqc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","kamini ini ne areyadi. Ma ago gira nimaro, “Mina bi amiye yokoi ga diba niyaganedi!” ");
INSERT INTO kqc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Idu disi mina gagani tora noibanuri ini beika reyo mina niokuyadi. ");
INSERT INTO kqc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kamini digamadiri, amiye babo kaere bi vima no nufa afei baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma Iesu mina vima no meki reyori, mina amiye ago niyo, ma amiye tau gade tururu resi niyadi, “Israel gaganiri mina kana vegu yokoi bi sena vena de!” ");
INSERT INTO kqc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Idu Pharisee vene yaku niyadi, “Bi vima no di ourefeidena amiye di vava dudu vima no meki redo.” ");
INSERT INTO kqc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma Iesu yaku taoni ma rautu tau gaderi disi ini usa usa yavari oteimasi Sei di ourefeidena amena sana di ago buni nirausi resi gauka ma esika tau gade moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mina amiye tau gade vegasa ina rofu iriyeduka reyo, adina mina vene bi mokena toe moigamadi ma vana tu ini mamoe dogo amiye bi de kana. ");
INSERT INTO kqc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mina usi ini usi dina vene rofu niyo, “Iruku rama butu rena bi tora gade, idu moimai rededi vene bi tau de. ");
INSERT INTO kqc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mina dada butu butu rena Varika amiye rofu usa usa nifa kumo moimai rededi vene nifeidego ma ini butu butu resi moi aeyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kamini Iesu ini usi dina vene 12 raka nisi niegogo resi vima no meki resi deda gauka tau vakoi moi buni rigi vava maro. ");
INSERT INTO kqc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ye mina nifeidena vene 12 di roka roka bi: ouresi bi Simon (ini roka yokoi bi Peter) ma ini usika Andrew; Zebedee di mida mida James ma ini dubuini John; ");
INSERT INTO kqc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip ma Bartholomew; Thomas ma Matthew, fore butu rena amiye; Alphaeus di mida James, ma Thaddaeus; ");
INSERT INTO kqc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon kaere bi zealot amiye yokoi ma Judas Iscariot kaere bi Iesu siri reyo. ");
INSERT INTO kqc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu yaku mina amiye 12 bi ago gira masi vava dudu nifeideyo: “Tutubena idana vene di gagani o Samaria vene di taoniri bi dibo ga refa. ");
INSERT INTO kqc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Idu Israel vene, mamoe boiyo reyadi kana, ina rofu maka difa. ");
INSERT INTO kqc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Disi nirausi regedi, ‘Sei di ourefeidena amena sana omari bi negau niyo!’ ");
INSERT INTO kqc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gauka moi buni risi muyena edadisi refera nufa moi ruaka risi vima no meki rebigedi. Mina bi voi de resi moiyadi, ye mana rofu ka obini bi ga moifa. ");
INSERT INTO kqc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yi foketari bi goro, siriva o fore kopa mina ga moifa; ");
INSERT INTO kqc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ida digasa dura ga moifa, varuka remanu, yuka ro o yukana ka ga moifa, adina moimai redo amiye bi ini iruku moi mana bi buni. ");
INSERT INTO kqc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ye goina taoni o rautu dui regasa amiye yokoi kaere bi buni baku regedi vonisi, bi ini yavari amegedi bogo ferei digedi mamo. ");
INSERT INTO kqc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ye mina yava dui regasa mina ago nifa, ‘Uka amuta bi yasa.’ ");
INSERT INTO kqc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mina yava vene bi buni vonisi, yi uka amuta bi mina yavari amego; idu buni de vonisi, bi yi uka amuta maro bi dairi moigedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma goina amiye ya moi dui de regedi o yi ago de neidegedi, mina taoni o yavari ferei digasa yi yuka di budoka usi eyarefa. ");
INSERT INTO kqc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rama ya nida, Sei di kota rego medari Sodom ma Gomorrah taoni vene di esika esika moigedi bi keika, idu mina taoni vene di esika esika moigedi bi tora gade! ");
INSERT INTO kqc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mokefa; na yaku mamoe kana sufa di gadeva auna di fogori ya nifeideida. Ye aruma kana mokei mona resi pune erena kana ave nifa. ");
INSERT INTO kqc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma amiye rofu nari refa, ini adina bi kanisoro vene di vanari ya siri resi ini usa usa yavari ya buburu vai regedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na dada gavana ma kini ka kota reyaganedi ya moi erokoko rei bogedi, ina rofu ma tutubena idana vene rofu nai ago ninegau regedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ye kota regi ya afei bogediri, beika nigedi o gokai ago rofu mokena toe ga moiyagane, adina beika nigedi bi minari maka ya mago. ");
INSERT INTO kqc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Adina mina kaere yaku ago nigo bi ya yaku de, idu bi yi Baba di Vima yaku ya dudu ago nibigo. ");
INSERT INTO kqc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma usika ourena yaku usika ourena muyena rofu siri rego, ma baba yaku ini mida rofu makai rego; ma mida mida yaku ini nono baba rofu tourage regedi ma umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amiye tau gade yaku nai roka dada ya rofu gubuyo regedi, idu kaere are rei gira rego bogo ari metonari mamo bi moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Taoni yokoiri ya esika esika magediri, bi taoni yokoiri ori di. Rama iniye ya vene rofu ya nida, Israel di taoni tau vakoi ebu resi dina koderi Amiye di mida dego. ");
INSERT INTO kqc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Usi dina amiye ini oteimana amiye ebu rena de rego; moimai rei tavoi redo amiye ka ini varika amiye ebu rena de rego. ");
INSERT INTO kqc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Buni bi usi dina amiye bi ini oteimana amiye kana nigo ma moimai rei tavoi redo amiye ka ini varika amiye kana nigo. Yava biyaguna amiye di roka bi Beelzebul vo niyadi, dada besa bi ini yava vene makai nifafana rebigedi! ");
INSERT INTO kqc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mina dada amiye rofu bi ori ga refa, adina beika bou riyadi bi moi ogau rigedi, ma beika sui niyadi bi erau nigedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Beika mukunari ya nida, bi vabarari dudusa nifa, ma beika kiya mumugu ago dudu neideyadi, bi yava tebori are resi nirausi refa. ");
INSERT INTO kqc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma roaita maka umuyesi vima umuyegi anua regedi vene rofu bi ori ga refa, idu Sei rofu maka ori refa, kaere bi ita mokari roaita ma vima vakoi moi no rego vava nufa. ");
INSERT INTO kqc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Erena keika remanu di davana bi fore keika yokoi dudu ba? Mina resi erena keika yokoi mina konori de yarei tavoi rego, idu yi Baba siko diba nigo mamo. ");
INSERT INTO kqc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma yi ada iye tau vakoi ka gokaisanu amedo bi duaiya reyo. ");
INSERT INTO kqc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mina dada ori ga refa; ya amiye bi isivaga iniye, erena keika tau gade kana de! ");
INSERT INTO kqc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ye kaere yaku amiye di nemokori niogau rego ina bi nai, na yaku ka nai Baba omari di nemokori makai niogau regida. ");
INSERT INTO kqc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Idu kaere yaku amiye di nemokori na fufuta mago, na ka nai Baba omari ini nemokori fufuta magida. ");
INSERT INTO kqc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ga mokefa na mina konori deyaka bi uka amuta moi soka reyaka. Na bi uka amuta de moi deyaka, idu amiye tau gade okuna bainasi magi deyaka. ");
INSERT INTO kqc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Adina na deyaka bi rumana mida yaku ini babasa, vefa yaku ini nonosa, ma radiyaka tora yaku ini radiyakasa iniye iniye utama okuyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Amiye di tuma vene bi kaere ini yava yokoi makari amededi vene. ");
INSERT INTO kqc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kaere amiye ini nono o baba rofu uka tora masi na rofu uka keika mago vene bi nai usi dina bi kode; ma kaere amiye ini rumana o rema mida rofu uka tora masi na rofu uka keika mago, bi nai usi dina bi kode tora. ");
INSERT INTO kqc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma kaere amiye ini satauro de uakaisi na usi baego, bi na usi dina egere de. ");
INSERT INTO kqc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kaere ini vegu maina rego, bi de moigo, ma kaere na dada ini vegu youfeidego, bi moigo. ");
INSERT INTO kqc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kaere ya moi dui rego, bi na moi dui rego, ma kaere na moi dui rego, bi kaere yaku na nifeideyo moi dui rego. ");
INSERT INTO kqc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaere amiye yaku Sei di ago nido amiye moi dui rego, adina ina bi Sei di ago nido amiye, bi Sei di ago nido amiye di obini moigo. Ma kaere amiye yaku mokena rorobo amiye moi dui rego, adina ina bi mokena rorobo amiye, bi mokena rorobo amiye di obini moigo. ");
INSERT INTO kqc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma kaere amiye nai usi dina amiye kana, bi amiye yokoi, kaere bi roka de nufa, ina rofu koru itu biyori maka mago, rama ya nida, ina bi rama iniye ini obini de youfeidego.” ");
INSERT INTO kqc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ma Iesu ini usi dina vene 12 ago gira moi vau regasa mina sana feresi ina vene di taoniri oteimagasa ago nirausi regika boyo. ");
INSERT INTO kqc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ye John Baptist dibura yavari amesi Keriso yaku beika reyo mina neidegasa ini usi dina vene nifeideyo ma ");
INSERT INTO kqc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nikaiteyadi, “Ya bi dego amiye o amiye yokoi tua regifa ba?” ");
INSERT INTO kqc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kamini nikabai resi niyo, “Bosi John rofu beika neidegasa veyadi mina nifa: ");
INSERT INTO kqc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ne taufa vene dudusa gagani vededi, yuka no vene nana rededi, refera nufa vene bi moi ruaka riyo, anema kora vene bi neidededi, muyena vene bi veguri edadiyo ma ago buni bi irava vene rofu nirausi reyo. ");
INSERT INTO kqc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma kaere na rofu mokei itu de rego, Sei yaku buni tora gade ina rofu mago!” ");
INSERT INTO kqc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ye mina vene diyadiri, Iesu yaku amiye tau gade John fafau ago nigi kora reyo: “Ya bi beika vegi gagani autu sanari boyadi? Doi iye aura yaku moi raudai redo mina vegika ba? ");
INSERT INTO kqc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Idu mironari beika vegika boyadi? Varuka burefe rido amiye ba? Mina kana varuka burefe ridedi vene bi kini di yavari amededi! ");
INSERT INTO kqc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Idu beika vegika boyadi? Sei di ago nido amiye yokoi ba? Yo, ya vene rofu nida, ina bi Sei di ago nido amiye, idu bi isivaga iniye. ");
INSERT INTO kqc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mina amiye bi kaere bi bura reyo: ‘Sei yaku makai niyo, nai ago moi raga redo amiye yi budari nifeidegida. Yi ida moi dogo rego.’ ");
INSERT INTO kqc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rama ya vene rofu nida, kaere sena ameyadi vene ma gua amededi tau vakoiri bi yokoi yaku John Baptist de ebu redo. Idu Sei di ourefeidena amena sana omari bi kaere amiye roka de mina yaku bi John ebu redo. ");
INSERT INTO kqc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ye John Baptist di meda duakau baeyo gua Sei di ourefeidena amena sana omari bi toe tora moiyo ma iya rededi vene yaku duro resi moidedi. ");
INSERT INTO kqc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Adina Sei di ago niyadi vene tau ma Moses ini ago gira dudu bi Sei ini ourefeidena amena sana di ago mina nirausi regamadi baeyo gua John di ari; ");
INSERT INTO kqc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ma ya ura rededi ina vene di ago rofu mokena vari gira aegiya vonisi, bi John bi Elijah, kaere ini baego bi sena nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaere neidego, bi neideyaine! ");
INSERT INTO kqc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Idu gua amededi vene bi gokai dudu nirorotari regida? Ina bi mida keika keika kana, maketi sanari amegasa ini asiyaka vene rofu raka nisi nidedi, ");
INSERT INTO kqc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Una bi ya rofu bibo uyafa, idu ya bi adena de uyadi; muyena yauta niyafa, idu ya bi isaka de niyadi!’ ");
INSERT INTO kqc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Adina John baesi iruku oyo regasa waini de irigamori, kamini niyadi, ‘Ina bi vima no nufa!’ ");
INSERT INTO kqc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amiye di mida baesi iruku irisi waini irigamori, ina vene yaku niyadi, ‘Mina amiye vefa! Ina bi iruku ma waini irina kurakura amiye. Ina bi fore butu rededi vene ma vegu no rededi vene di asini!’ Idu Sei di mokena tora yaku beika vata nidedi una oteimado bi rama mini.” ");
INSERT INTO kqc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Taoni bedakairi Iesu yaku mokena vegu tau reyo mina amiye bi ini vegu no de feresi moi etagae riyadi, ye bi emaro. ");
INSERT INTO kqc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Chorazin vene ya rofu bi iriyeduka iniye ma Bethsaida vene ya rofu ka bi iriyeduka iniye! Adina bi, senagi mokena vegu ya vene rofu reyaka kana mina Tyre taoni ma Sidon taoniri reyagadu vonisi, bi mirona vene bi senagi guruo amena kana varuka akusi udo ini roaita ifi rei boga degasa reyaidu, mina yaku oteimaragadu ina bi ini vegu no feresi moi etagae riyadi! ");
INSERT INTO kqc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Idu ya vene rofu nida, Sei di kota rego medari Tyre ma Sidon taoni vene di esika esika moigedi bi keika, idu ya vene di esika esika moigedi bi tora gade! ");
INSERT INTO kqc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma ya Capernaum vene! Ya bi omari moi odoro de rego! Idu, muyena vene di amena sanari negedi! Mina mokena vegu ya ideri bi Sodom ri reyagadu vonisi, bi gua ka toga amebiyaidu! ");
INSERT INTO kqc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Idu ya vene rofu nida, Sei di kota rego medari, Sodom taoni di vene di esika esika moigedi bi keika, idu ya vene di esika esika moigedi bi tora gade!” ");
INSERT INTO kqc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mina ituari, Iesu yaku niyo, “Baba, oma ma kono di Varika amiye, yi roka moi odoro rida, adina ya bi mina vegu mokena tora vene rofu moi sui risi mokena keika keika vene kaere bi mida mida kana rofu moi ogau riyo. ");
INSERT INTO kqc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Baba, yi ukari mokeyo kana, makai vata niyo. ");
INSERT INTO kqc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nai Baba yaku beika baika tau na nimaro. Ma amiye yokoi ina toto ini Mida, idu nai Baba maka ina diba. Ma amiye yokoi ka ini Baba toto, ini Mida maka ina diba ma ini Mida yaku ka Sei bi kaere moi ogau rigi ura redo amiye rofu bi rama iniye vegedi. ");
INSERT INTO kqc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na rofu baegedi, ya kaere toe moisi kosika reyadi, ma na yaku sifere ya magida. ");
INSERT INTO kqc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nai maduna moisi ya fafau aesi na rofu diba nifa, adina nai ukari na bi ave nida; ma yi vima di sifere rena bi makai baku regedi. ");
INSERT INTO kqc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Adina nai maduna moina rofu bi enana de, ma nai toe bi aita.” ");
INSERT INTO kqc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mina ituari Iesu ma ini usi dina venesa Sabati medari witi muro idari nana diyadi. Ina yaku rauna resi witi di ada koma resi irigi kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Idu Pharisee vene mina vegasa ina rofu niyadi, “Neide, yi usi dina vene bi beika Sabati medari una rofu bi tabu mina rededi!” ");
INSERT INTO kqc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Idu ina rofu niyo, “Ya bi bura de veyadi beika David ini amiyesa yaku reyadi mirona medari rauna reyadiri? ");
INSERT INTO kqc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye Sei di yava ideri dui resi Sei rofu nimana beredi irisi ini vene ka maro. Ago gira yaku nido bi tabu mina beredi irigedi—Sei ma amiye utari naivo vene yaku maka iridedi. ");
INSERT INTO kqc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O ya bi bura de veyadi ba, ago gira di bukari Sabati medari Sei nivakena yavari Sei ma amiye utari naivo vene yaku mina meda di ago gira bi ukero vau rededi, idu vegu no yokoi de nufa? ");
INSERT INTO kqc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Idu ya nida, Sei nivakena yava kana de, ina bi isivaga iniye bi mini. ");
INSERT INTO kqc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Idu mina ago di ini adina ya diba niyagadu vonisi, bi ‘Na bi iriyeduka ura reida, ma ori sisika rena bi de,’ ye ya bi vegu no nufa de amiye nifafana de rei tavoi reyaidu; ");
INSERT INTO kqc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","adina Amiye di mida bi Sabati meda di Varika amiye.” ");
INSERT INTO kqc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ye mina sanari feresi ini usa usa yavari dui reyo, ");
INSERT INTO kqc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ma minari vana kevo amiye yokoi amegamo. Ini no dada nisi tourage regika nikaiteyadi, “Gauka moi buni rina Sabati medari bi ago gira rofu bi tabu ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kamini niyo, “Ya kaere yi mamoe yokoi maka nufa Sabati medari kono rubari keto rei nego vonisi, bi moi yakugiya ba ide? ");
INSERT INTO kqc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ye amiye di isivaga bi tora, idu mamoe di isivaga bi keika. Mina resi Sabati medari vegu buni rena ago gira dada bi buni.” ");
INSERT INTO kqc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Resi mina amiye rofu niyo, “Yi vana ae roto ri.” Ma ini vana ae roto risi dudusa dairi buni niyo, ini berou vana kana. ");
INSERT INTO kqc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Idu Pharisee vene feresi sina ago Iesu umuyegi nirorotari reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Idu Iesu ini nirorotari rena amutegasa mina sana feresi diyo ma amiye tau gade ina usi boyadi ma ini gauka tau gade moi buni rigamo; ");
INSERT INTO kqc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","resi ago gira maro bi amiye ga niyagane ina bi kaere. ");
INSERT INTO kqc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mina bi moi rama aeyaine beika Sei di ago niyo amiye Isaiah yaku niyo: ");
INSERT INTO kqc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mina bi nai naivo amiye, kaere bi auba reyaka; ina uka maida, kaere bi ina rofu ada reida. Nai Vima bi ina fafau aegida, ma ina yaku vegu rorobo tutubena idana vene tau rofu nirausi rego. ");
INSERT INTO kqc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ina bi kayamo de rego, o raka de nigo, ma yokoi yaku ini goroka taoni idari de neidego. ");
INSERT INTO kqc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ina yaku doi yau niyo bi ubaki de rego. Ma ita iko keika ka de ukafego, bogo vegu rorobo mina moi rama rigo; ");
INSERT INTO kqc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ma tutubena idana vene yaku ini roka rofu uka mokena aegedi.” ");
INSERT INTO kqc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mina usi vima no nufa amiye yokoi kaere bi babo ma ne taufa afei baeyadi ma Iesu yaku moi buni riyo, ye gagani vesi ago niyo. ");
INSERT INTO kqc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amiye tau gade tururu resi niyadi, “Aiyo, mina bi David di tutubena Keriso, kaere tua resifa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Idu Pharisee vene mina neidegasa niyadi, “Mina amiye bi vima no di ourefeidena amiye Beelzebul di vava dudu maka vima no meki redo.” ");
INSERT INTO kqc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Idu mina vene di mokena vesi ina rofu niyo, “Gagani uta okusi iniye iniye berou berou are resi ruda rego vonisi, bi berou berou keto rego. Ma taoni o rubu iniye iniye uta okusi iniye iniye berou berou are resi ruda rego vonisi, bi berou berou keto rego. ");
INSERT INTO kqc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ye Satani ini vima nosa iniye iniye meki regedi vonisi, bi iniye okusi ruda regedi. Ye gokai resi ini ourefeidena amena sana bi are rego? ");
INSERT INTO kqc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma na yaku vima no Beelzebul di vava dudu meki reida vonisi, bi yi vene bi kaere di vava dudu meki rededi? Mina dada ini beika rededi yaku yi ago bi rama de vo nidedi! ");
INSERT INTO kqc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Idu Sei di Vima di vava dudu vima no meki reida vonisi, bi Sei di ourefeidena amena sana bi ya vene rofu deyo mini. ");
INSERT INTO kqc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“O gokai dudu amiye yokoi yaku amiye yeiva di yava dui resi ini gugura fore duma rego? Makai siko resi bi mina amiye yeiva ukita rigo kumo ini gugura fore duma rego. ");
INSERT INTO kqc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Amiye kaere nasa de, bi na rofu de; ma kaere nasa butu de rido, bi rerevaida nido. ");
INSERT INTO kqc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mina dada ya vene rofu nida, amiye di vegu no tau ma Sei di roka moi no rina ago tau koite makugo, idu Vima kikifa ini roka moi no rigo, bi de koite makugo. ");
INSERT INTO kqc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma kaere amiye yaku Amiye di mida rofu ago no nigo, ini vegu no koite makugo, idu kaere yaku Vima kikifa rofu ago no nigo, gua o meda baegediri, ka de koite makugo. ");
INSERT INTO kqc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yabo buni, bi ini meko buni nigedi, o yabo no, bi ini meko no nigedi; yabo ini meko dudu vei mama regedi. ");
INSERT INTO kqc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya aruma di mida mida—gokai ida dudu ya bi uka no vene, ma ya yaku ago buni be nigedi? Adina beika uka ideri vata baedo, bi vena yaku nido mini. ");
INSERT INTO kqc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amiye buni yaku ini ukari beika mokedo bi buni dada, vegu buni moi baedo, ma amiye no yaku ini ukari beika mokedo bi no dada, vegu no moi baedo. ");
INSERT INTO kqc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ya nida Sei di kota rena medari amiye bi ini ago tavoi tavoi tau niyadi mina nirorotari reyainedi. ");
INSERT INTO kqc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Adina yi ago dudu yi vegu bi rorobo nigo o nifafana rego.” ");
INSERT INTO kqc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mina usi ago gira oteimana vene ma Pharisee vene be yaku Iesu nikabai resi niyadi, “Oteimana amiye, una ura resifa ya bi una rofu rebe yokoi regiya.” ");
INSERT INTO kqc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Idu nikabai resi niyo, “Vegu no resi mokena vari gira de aesi gua amededi vene yaku rebe nikaitededi; rebe yokoi de mago, idu Sei di ago niyo amiye Jonah rofu vata niyo rebe mina maka maro. ");
INSERT INTO kqc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Adina Jonah bi meda regode ma urusa regode oyena tora di uka ideri ameyo kana, ye Amiye di mida ka bi meda regode ma urusa regode kono di uka ideri amego. ");
INSERT INTO kqc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh vene Sei di kota rena medari, gua amededi venesa, are resi ini beika reyadi vegu nifafana regedi, adina bi Jonah yaku Sei di ago nirausi reyori, vegu no feresi moi etagae riyadi. Ma vefa, amiye yokoi Jonah ebu reyo bi mini! ");
INSERT INTO kqc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Meda baedo rama eta rofu di kuini bi Sei di kota rena medari gua amededi venesa edadisi beika reyadi vegu mina nifafana rego, adina bi gagani maikeri gutuna kini Solomon di mokena tora neidegi baeyo. Ye vefa, amiye yokoi kaere Solomon ebu reyo bi mini! ");
INSERT INTO kqc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ye vima no yaku amiye yokoi ferei yakusi bi koru de gaganiri ameinu rena sana maina rego. Yokoi baku rena de resi ");
INSERT INTO kqc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","iniye kamini nigo, ‘Nai yava ferei yakuyaka minari dairigida.’ Dairisi mina yava baku rego, bi sena gudare resi ae dogo reyadi ma notoka amedo. ");
INSERT INTO kqc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Resi bi disi vima no 7 inasa iniye ini no ebu reyadi afei baesi minari amegedi. Ye mina amiye di amena gua bi no iniye iniye sena kana de. Mina ye gua ari vegu no rededi vene bi makai.” ");
INSERT INTO kqc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ye amiye tau gade rofu ago niyori, ini nono ma ini dubuiyaka baesi etofaro are resi bi inasa ago nigedi ura reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ye amiye yokoi ina rofu niyo, “Ve kumo, yi nono ma yi dubuiyaka bi etofaro are resi ini ura bi yasa ago nigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kamini nikabai resi niyo, “Kaere bi nai nono ma kaere bi nai dubuiyaka?” ");
INSERT INTO kqc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Resi ini usi dina vene rofu vana imiyou resi niyo, “Ve kumo, mina vene bi nai nono ma nai dubuiyaka! ");
INSERT INTO kqc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Adina kaere nai Baba omari amedo amiye di mokena rego, bi nai dubuini, nai tobaini ma nai nono.” ");
INSERT INTO kqc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mina medari maka Iesu yavari gutuna yakusi moka daidai tora adinari nesi ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Amiye tau gade gade ina atafuri egogo reyadi, mina dada bi boutiri ameinu regi keu riyo ma amiye tau gade bi seriri are reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kamini mokena ago dudu ago tau gade nioteimasi makai niyo: “Amiye yokoi ini yo varigi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye yo moi faraka reyori, bedakai bi ida sanari yareyadi ma erena yaku okisi iri vau reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Be bi abita fore odoro yareyadi, minari kono bi keika maka. Evade meto boyadi, adina kono bi tora de. ");
INSERT INTO kqc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kamini meda are reyori, bi vai taresi abiye niyadi, adina ini daru kono ideri nei mona de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma be bi imiye tafa fogori yaresi boi tora niyadi ma imiye yaku fafa risi fono reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Idu be bi kono buniri yaresi rama niyadi; be bi 100, be bi 60, ma be bi 30 niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Kaere neidego, bi neideyaine!” ");
INSERT INTO kqc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kamini ini usi dina vene ina rofu baesi nikaiteyadi, “Beika resi mokena ago dudu ina vene rofu ago nisa?” ");
INSERT INTO kqc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma nikabai reyo, “Sei di ourefeidena amena sana omari di sui ago diba nigika bi ya maro, idu ina vene bi de. ");
INSERT INTO kqc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Adina kaere ini beika baika nufa, bi besa tau gade moi tanu mago; idu kaere ina rofu bi de iniye iniye nufa, ka ina rofu amedo bi moi dairigo. ");
INSERT INTO kqc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mina resi ina vene rofu bi mokena ago dudu ago nida: adina vededi, idu vei mama de rededi. Neidededi, idu neidei mama de rededi, ma diba de nidedi. ");
INSERT INTO kqc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiah, Sei di ago niyo amiye, yaku beika vata nigo ago niyo bi makai rama aeyo: ‘Ya bi neidebigedi, idu diba de nigedi; ya bi vebigedi, idu vei mama de regedi, ");
INSERT INTO kqc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ini adina mina vene di uka bi gira iniye, ma ini anema kebi risi neidena de resi ini nemoko muguna reyadi. Bi ini nemoko dudu vesi ini anema dudu neidesi ini uka dudu diba nigedi baebu, ye na rofu kero regedi ma na yaku moi buni rigida.’ ");
INSERT INTO kqc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Idu yi nemoko bi buni tora gade maro, ina bi vededi dada, ma yi anema, neidededi dada. ");
INSERT INTO kqc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Adina rama ya nida, Sei di ago niyadi vene ma mokena rorobo nufa vene tau ini ura bi ya beika vededi mina vegedi, idu bi de veyadi, ma ya beika neidededi mina neidegedi, idu de neideyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ye mina yo varina amiye di mokena ago di adina neidefa. ");
INSERT INTO kqc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kaere amiye yaku Sei di ourefeidena amena sana di ago neidego, idu diba de nigori, bi amiye no yaku baesi beika ini ukari aeyo mina moi digo. Mina bi ida sanari yo variyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma yo abita foreri yareyo, bi amiye kaere ago neidesi ada dudu bi evade maka moigo kana, ");
INSERT INTO kqc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","idu ini daru bi de, ma amei doba de rego. Ye mina ago dada toe ma esika esika baegediri, bi evade youfeidego. ");
INSERT INTO kqc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma yo imiye tafa fogori yareyo, bi ago neidedo amiye kana, idu mina kono di mokena toe ma ini gugura tau gade di ofa ofa ago yaku ago buni moi forovai reyadi, ye ina bi meko varena de reyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma kono buniri yo yareyadi kana, bi kaere mina ago neidesi diba nigo bi; rama nido, be bi 100 nido, be bi 60 nido, ma be bi 30 nido.” ");
INSERT INTO kqc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu yaku mokena ago yokoi dudusa nioteimaro: “Sei di ourefeidena amena sana omari bi amiye yokoi yoyava buni ini murori variyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Idu ini amiye varegamadiri, amiye no yaku baesi mina witi fogori oruma no varisi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mina witi meto bosi rama niyadiri, oruma no ka mina fogori dadiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ye yava di varika amiye di moimai rei tavoi rededi vene ina rofu baesi niyo, ‘Varika amiye, ya bi witi yoyava buni maka murori variyo, idu mina oruma no bi goinari gutuna baeyadi?’ ");
INSERT INTO kqc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ina yaku nikabai reyo, ‘Amiye no yaku mina reyo.’ Ye nikabai reyadi, ‘Ya ura reisa bi bosi oruma kurugifa ba?’ ");
INSERT INTO kqc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma niyo, ‘Ide, oruma kurubigediri ka orumasa witi rama kurugedi baebu dada. ");
INSERT INTO kqc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ferefo kumo vakoi bogedi butu rena medari mamo. Mirona medari mamo butu rededi vene nigida: Oruma siko butu resi origi rugurugu dudu mitai regedi, idu witi rama butu resi nai totoa yavari moi baegedi.’” ");
INSERT INTO kqc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Dudusa mokena ago yokoi ina vene rofu nioteimaro: “Sei di ourefeidena amena sana omari bi mastadi di yoyava kana; amiye yokoi yaku moisi ini murori variyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bi keika keika iniye, idu tora nigori, bi yabo tau vakoi ebu resi yabo tora nigo, ye odorori didedi erena yaku okisi ini tetekari buri rigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ma mokena ago yokoi nioteimaro: “Sei di ourefeidena amena sana omari bi yeast kana; ye rema yokoi yaku moisi farava siua tora regode sa moi foyomai reyo bogo mina yeast yaku farava tau vakoi moi uruyo.” ");
INSERT INTO kqc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu yaku mina sina tau noibanu mokena ago dudu amiye tau gade rofu nioteimagamo; ina bi mokena ago dudu maka sina nigamo. ");
INSERT INTO kqc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ye beika Sei di ago niyo amiye yaku niyo bi rama aeyo: “Na bi mokena ago dudu ago nigida; Na yaku kono riyori gutuna sui niyadi beika baika bi niokugida.” ");
INSERT INTO kqc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mina usi amiye tau feresi bosi yavari dui reyo. Ma ini usi dina vene bi ina rofu baesi niyadi, “Mina muro di oruma di mokena ago di adina una nirorotari re.” ");
INSERT INTO kqc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ye nikabai reyo, “Amiye kaere yaku meko buni variyo bi Amiye di mida. ");
INSERT INTO kqc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Muro bi mina kono tora noibanu, ma meko buni bi Sei di ourefeidena amena sana di mida mida. Ma oruma bi Amiye no di mida mida. ");
INSERT INTO kqc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma oruma no variyo tuma amiye bi Bodaka. Butu rena ari bi meda di bae koina nina, ma butu rededi vene bi Sei di naivo naivo vima. ");
INSERT INTO kqc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mina oruma no butu resi itari ori kamu regedi kana, meda bae koina nigori bi makai: ");
INSERT INTO kqc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amiye di mida yaku ini naivo naivo vima nifeidego ma Sei di ourefeidena amena sanari beika tau yaku vegu no rofu eyarededi ma kaere tau ago gira de neidededi bi butu resi ");
INSERT INTO kqc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ita tora fairo redo sokuri makugedi; ye mironari ini gade aki gigi regasa isaka nibigedi. ");
INSERT INTO kqc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mina usi mokena rorobo vene bi ini Baba di ourefeidena amena sanari meda vabara nido kana vabara nibigedi. Kaere neidego, bi neideyaine! ");
INSERT INTO kqc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sei di ourefeidena amena sana omari bi kono kefukari gugura buni moi sui riyadi ma amedo kana; ye amiye yokoi yaku baku resi dudusa mina moi sui risi ada dudu nesi ini gugura tau mina sero resi mina kono kefuka voi reyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Yokoi bi, Sei di ourefeidena amena sana omari bi gugura voi reyo amiye yaku fore buni vayavaya roka pearl maina reyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yokoi ini davana tora iniye veitao regasa disi ini gugura tau mina sero resi mina fore buni vayavaya voi reyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dudusa, Sei di ourefeidena amena sana omari bi fate moka daidai torari eyareyadi ma oyena deda moiyadi kana. ");
INSERT INTO kqc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Oyena yaku mina fate vata baeyadiri, amiye yaku seriri moi rutu rei baeyadi. Ameinu resi moi etagae riyadi, buni buni bi moigasa foroka ideri aesi no bi moi makuyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mina bi gokai vata nigo meda bae koina nigori: Sei di naivo naivo vima yaku desi vegu no vene mokena rorobo vene di ideri moi etagae risi ");
INSERT INTO kqc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ita tora fairo redo sokuri maku negedi; mironari bi gade aki gigi regasa isaka nigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu yaku nikaiteyo, “Mina ago tau vakoi niyaka bi diba niyadi ba?” Ma nikabai resi yo niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ye ina vene rofu niyo, “Mina dada ago gira oteimana vene neinei kaere Sei di ourefeidena amena sana omari usi dina vene niyadi, bi yava di varika amiye kaere bi ini gugura buni fogori gugura ruaka ma gugura kori moi yakudo kana.” ");
INSERT INTO kqc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kamini Iesu mina mokena ago ni vau regasa bi mina sana feresi boyo. ");
INSERT INTO kqc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma ini tora niyo taoniri dairi nesi bi ini usa usa yavari oteimagamo, ye tururu resi niyadi, “Mina mokena tora ma mokena vegu bi goidu baeyadi? ");
INSERT INTO kqc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mina bi yava rina amiye di mida ba? Ini nono di roka bi Mary, ma ini dubuiyaka bi James, Joseph, Simon ma Judas ba? ");
INSERT INTO kqc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma ini tobaiyaka tau bi unasa mini ba? Makai mina amiye bi mina beika tau bi goidu moiyo?” ");
INSERT INTO kqc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mina dada ina rofu uka no reyadi. Idu Iesu yaku ina vene rofu niyo, “Gagani tau vene yaku Sei di ago nido amiye bi vei odoro regamadi, idu ini rauturi ini usika ourena yaku bi de.” ");
INSERT INTO kqc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ye minari bi mokena vegu tau de regamo, ini adina ini mokena vari gira aena bi de dada. ");
INSERT INTO kqc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mirona ituari Herod, Galilee di ourefeidena amiye, yaku Iesu beika regamo di sina neidesi ");
INSERT INTO kqc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ini naivo vene rofu niyo, “Mina bi John Baptist. Ina bi muyena gutuna dadi rae reyo! Mina resi bi mokena vegu di vava ina rofu vata nidedi.” ");
INSERT INTO kqc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod yaku mina ago niyo, adina bi sena ago maro ma John moisi ini yuka ukita risi dibura yavari aeyadi, Herodias, kaere bi ini dubuini Philip di rema, dada. ");
INSERT INTO kqc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ini adina John yaku nigamo, “Ina meyo bi tabu!” ");
INSERT INTO kqc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod ini ura bi umuyego, idu amiye tau gade rofu ori regamo, adina amiye yaku mokegamadi John bi Sei di ago niyo amiye yokoi. ");
INSERT INTO kqc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod di vata niyo medari, Herodias di vefa yaku amiye di nemokori adena uyo, ye Herod bi ada reyo, ");
INSERT INTO kqc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mina resi iniye nivarika resi nitore reyo bi beika usa nigo bi mago. ");
INSERT INTO kqc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mina rema ofi di nono yaku niyo kana, usa niyo, “Minari mereki odorori John Baptist di ada na ma!” ");
INSERT INTO kqc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ye kini iriyeduka yaku no niyo, idu ini nitore reyo ago ma okiyadi vene dada, bi ago gira niyo bi maraganedi. ");
INSERT INTO kqc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ye ini iya redo amiye rofu ago gira maro ma dibura yavari John di ada nu burusi ");
INSERT INTO kqc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ini ada mereki odorori ae moi baesi mina rema ofi maro ma dadisi ini nono maro. ");
INSERT INTO kqc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ye John di usi dina vene baesi ini roaita maka moisi guri aesi Iesu rofu disi nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu mina ago neidegasa bi mina gagani feresi bouti keu risi inaike mafumafu sana yokoiri boyo. Idu amiye tau gade mina neidegasa taoni gutuna yuka dudu usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ye bouti feresi soka regasa bi amiye tau gade gade vesi ina rofu iriyeduka resi ini gauka moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uriyenau niyori, ini usi dina vene ina rofu baesi niyadi, “Mina sana bi autu sana, ma ari bi koina niyo mini. Amiye nifeide kumo rauturi ini iruku voi reyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Idu nikabai reyo, “Ina vene bi de digedi; ya yaku iruku mafo kumo iriyaganedi!” ");
INSERT INTO kqc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Idu nikabai reyadi, “Unasa bi beredi 5 ma oyena remanu maka.” ");
INSERT INTO kqc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kamini niyo, “Mina na rofu moi baefa.” ");
INSERT INTO kqc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma amiye tau gade rofu ago maro oruma fafau ameinu reyaganedi. Mina beredi 5 ma oyena remanu moisi oma vegasa buni tora gade Sei rofu masi bi beredi okusi ini usi dina vene maro ma amiye tau gade maradi. ");
INSERT INTO kqc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ye ina tau noibanu iriyadi ma ini uka bere niyadi. Ma ini fereyadi iruku tuta butu resi foroka 12 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma mina iriyadi vene bi rumana vene 5,000 kana, rema ma mida bi duaiya de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ye amiye tau gade nifeidegasa evade ini usi dina vene rofu ago maro bi bouti keu risi ina siko moka daidai tora berou eta rofu boyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ye amiye tau gade nifeidesi bi inaike omuna ikari usa usa nigika boyo. Uriyenau tumu niyori, ina bi inaike amegamo. ");
INSERT INTO kqc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ye mina medari bouti kono feresi maike tora niyo, ma ureure yaku bouti moi diga bogasa regamo, aura bi bogamadi sana baegamo dada. ");
INSERT INTO kqc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ari uvego atafuri, ina vene rofu moka daidai tora fafau nana regasa boyo. ");
INSERT INTO kqc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Idu ini usi dina vene moka toboma nana regamo vegasa ori resi niyadi, “Mina bi godiyo!” Resi ori dudu ababa niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Idu minari maka ina vene rofu niyo, “Uka gira nifa; na mini. Ori ga refa!” ");
INSERT INTO kqc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Peter yaku nikabai reyo, “Varika amiye ya vonisi bi, na ni kumo koru fafau ya rofu bae negida.” ");
INSERT INTO kqc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ina yaku niyo, “Baevo!” Kamini Peter boutiri gutuna soka resi Iesu urana koru fafau nana rei boyo. ");
INSERT INTO kqc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Idu ne resi aura tora vegasa ori resi tomu nigasa raka niyo, “Varika amiye, na moi vegu ri!” ");
INSERT INTO kqc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Minari maka Iesu yaku ini vana roto risi moi gira resi niyo, “Ya bi mokena vari gira keika aesa amiye, beika resi mokei itu reyo?” ");
INSERT INTO kqc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kamini boutiri keu reyadiri, aura amuta niyo. ");
INSERT INTO kqc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ye kaere kaere boutiri ameyadi yaku ina nivakesi niyadi, “Rama ya bi Sei di mida!” ");
INSERT INTO kqc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kamini moka daidai tora ugasi bi Gennesaret gaganiri utae riyadi, ");
INSERT INTO kqc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ma mina gagani vene yaku Iesu vei mama regasa amededi negau gagani vene tau rofu ago nifeideyadi ma amiye yaku ini gauka vene tau ina rofu afei baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Resi guyaguya nigamadi ini varuka metona maka avaka moiyaganedi. Ye kaere tau yaku avaka moiyadi bi buni niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mina usi Pharisee vene ma ago gira oteimana vene bi Jerusalem gutuna Iesu rofu baesi nikaiteyadi, ");
INSERT INTO kqc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Beika resi yi usi dina vene bi uni aufakai di toutou ukero vau rededi? Adina bi vana de koitesi iruku iridedi!” ");
INSERT INTO kqc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma nikabai reyo, “Ye ya bi beika resi yi aufakai di toutou dada Sei di ago gira ukero vau rededi? ");
INSERT INTO kqc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Adina Sei yaku niyo, ‘Yi nono baba emagui re,’ ma ‘Kaere yaku nono o baba nikiraini rego, bi umuyeyaine.’ ");
INSERT INTO kqc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Idu ya yaku nidedi bi, ‘Amiye kaere ini beika baika amededi vonisi, bi mina yaku ini baba o nono aedegedi. Idu nido, Mina bi Sei di ini, resi ");
INSERT INTO kqc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ini baba rofu bi kikifa ga reyaine.’ Ye yi aufakai di toutou rededi dada Sei di ago moi no ridedi. ");
INSERT INTO kqc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ya ofarosi vene! Isaiah bi rama nisi ya vene dada Sei di ago niyo bi: ");
INSERT INTO kqc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mina vene bi ini afiye dudu na kikifa rededi, idu ini uka bi na rofu bi maike tora. ");
INSERT INTO kqc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na nivakei kava rededi; adina ina yaku mokededi bi, amiye di oteimana ago bi Sei di ago gira kana!’” ");
INSERT INTO kqc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kamini amiye tau gade raka niegogo resi niyo, “Neidesi diba nifa! ");
INSERT INTO kqc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Beika amiye di vena ideri nedo bi moi kino de rido; idu beika ini vena ideri gutuna yakudo mina yaku amiye moi kino rido.” ");
INSERT INTO kqc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kamini ini usi dina vene baesi nikaiteyadi, “Pharisee vene mina ago neidegasa uka kenoka reyadi, bi diba niyo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Idu nikabai reyo, “Yabo tau nai Baba omari yaku de variyo bi ini darusa kurugo. ");
INSERT INTO kqc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mina vene bi ferei tavoi refa; ina bi ne taufa ourefeidena vene. Ye ne taufa amiye yaku ne taufa amiye ourefeidego vonisi, bi ina remanu sokuri gogo abougedi.” ");
INSERT INTO kqc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Idu Peter yaku niyo, “Mina mokena ago ini rama una rofu nirorotari re.” ");
INSERT INTO kqc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ye nikaiteyo, “Ya ka bi toga ada yora de ba? ");
INSERT INTO kqc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Diba de nidedi ba, beika vena ideri dui resi rivori gutuna nesi bi roaita ma yakudo? ");
INSERT INTO kqc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Idu beika bi vena gutuna yakudo bi uka mekori gutuna baedo, ye mina yaku amiye moi kino rido. ");
INSERT INTO kqc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Adina mokena no, amiye umuyena, mena vene koa rena, mena de vene koa rena, duma duma rena, ofa sina nina ma amiye di roka moi no rina bi ukari gutuna yakudedi. ");
INSERT INTO kqc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mina vegu yaku amiye moi kino ridedi; idu vana de koitesi iruku irina yaku bi de moi kino ridedi.” ");
INSERT INTO kqc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mina usi Iesu mina sana feresi Tyre ma Sidon adina gaganiri diyo. ");
INSERT INTO kqc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ye mina gaganiri amedo Canaan rema yokoi ina rofu baesi raka nisi niyo, “Varika amiye, David di tutubena mida, na iriyeduka re! Vima no yaku nai vefa di roaitari dui reyo ma esika esika tora gade mado.” ");
INSERT INTO kqc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Idu nikabai de reyo, dada ini usi dina vene yaku baesi ina rofu usa niyadi, “Toga una usi digasa imuna nido, ye nifeide kumo diyaine!” ");
INSERT INTO kqc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kamini nikabai reyo, “Na bi Israel vene, kaere bi mamoe boiyo reyadi kana, ina rofu maka nifeideyo.” ");
INSERT INTO kqc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Idu mina rema baesi ini budari nivakesi niyo, “Varika amiye, na aede!” ");
INSERT INTO kqc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Idu nikabai reyo, “Bi buni de mida mida di iruku moisi auna rofu makugiya.” ");
INSERT INTO kqc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kamini niyo, “Varika amiye, rama nisa, idu auna ka ini varika amiye di teiborori iruku bubudo yarededi ka iridedi.” ");
INSERT INTO kqc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ye nikabai reyo, “Rema, yi mokena vari gira aena bi tora gade! Yi beika mokegasa nisa bi ya rofu vata nigo.” Ye mina meda nemokori ini vefa bi moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu mina sana feresi Galilee moka daidai tora seriri ma nana resi omuna odorori bosi ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kamini amiye tau gade gade ina rofu baesi yuka no, ne taufa, yuka kevo, babo vene ma amiye tau gade be afei baesi ini yuka adinari aeyadi ma moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ye mina amiye tau gade bi babo ago nigamadi, yuka kevo buni nigamadi, yuka no nana regamadi ma ne taufa dudusa vegamadi, mina vegasa tururu resi Israel di Sei di roka moi odoro riyadi. ");
INSERT INTO kqc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kamini Iesu ini usi dina vene raka niegogo resi niyo, “Na bi mina vene tau gade rofu iriyeduka reida, adina bi nasa sena meda regodenu ameyadi ma irigedi iruku bi koina. Na ura de reida rauna nifeidegida ma digedi, bi idau muyei tamatama regedi baebu.” ");
INSERT INTO kqc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ye nikaiteyadi, “Una bi goidu mina gagani autu sanari beredi tau gade moisi mina amiye tau gade gade vana regifa?” ");
INSERT INTO kqc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma nikaiteyo, “Ya bi beredi bado gokaisanu be nufa?” Ma nikabai reyadi, “7 ma oyena keika keika maka.” ");
INSERT INTO kqc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ye ina yaku amiye tau gade konori ameinu reyagane vo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Resi bi beredi bado 7 ma oyena moisi buni tora gade Sei rofu masi beredi okusi ini usi dina vene maro ma amiye rofu rau reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ina vene tau vakoi iruku iriyadi ma uka bere niyadi. Ye tuta fereyadi bi foroka 7 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mina iruku iriyadi vene bi rumana vene 4,000; rema ma mida mida bi duaiya de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kamini amiye tau gade nifeidesi boutiri keu risi Magadan gaganiri neyo. ");
INSERT INTO kqc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ye Pharisee vene ma Sadducee vene ina rofu baesi omari rebe yokoi reyainedi nikaiteyadi, ebene regika bi rama ba ide Sei bi ini vava maro. ");
INSERT INTO kqc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ye nikabai reyo, “Uriyenau nidori ya yaku nidedi, ‘Ari buni nigo, oma bi bora nido dada.’ ");
INSERT INTO kqc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma uriyakuri bi nidedi, ‘Gua bi miya aura regedi, adina oma bi bora nisi seuya tau nido dada.’ Ya oma ma kono vesi bi beika ari gua una mago bi diba nigedi, idu Sei di rebe gua ariri vei mama regi bi anua rededi! ");
INSERT INTO kqc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Vegu no resi mokena vari gira de aesi gua amededi vene yaku rebe nikaitededi; rebe yokoi de mago, idu Jonah rofu vata niyo rebe mina maka maro.” Kamini mina vene feresi boyo. ");
INSERT INTO kqc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kamini ini usi dina vene moka daidai tora ugasi berou eta rofu boi negasa beredi bado moina bi toto niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ye Iesu yaku niyo, “Nari resi Pharisee vene ma Sadducee vene di yeast rofu vei mona refa.” ");
INSERT INTO kqc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ye iniye iniye nidodi resi niyadi, “Mina niyo, ini adina bi beredi be de moiyafa.” ");
INSERT INTO kqc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Idu ini mokena veifategasa nikaiteyo, “Ya mokena vari gira keika aededi vene, beika resi ya kaya nidodi rededi beredi koina dada? ");
INSERT INTO kqc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ya bi toga veifatededi ba ide? Ya bi mokededi ba ide, mina beredi bado 5 mina vene 5,000 rofu, ma foroka gokaisanu moi vata baeyadi? ");
INSERT INTO kqc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma beredi bado 7 vene 4,000 rofu foroka gokaisanu moi vata baeyadi? ");
INSERT INTO kqc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Gokai resi yi adari ufatena de redo na bi beredi dada de nida? Idu Pharisee vene ma Sadducee vene di yeast rofu bi ya kaya ya kaya nari rei mona refa!” ");
INSERT INTO kqc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Minari mamo diba niyadi ina bi beredi yeast dada de ni diba regamo, idu Pharisee vene ma Sadducee vene di oteimana ago rofu. ");
INSERT INTO kqc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kamini Iesu Caesarea Philippi gagani baesi ini usi dina vene nikaiteyo, “Amiye yaku nidedi Amiye di mida bi kaere, vo nidedi?” ");
INSERT INTO kqc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ye nikabai reyadi, “Be yaku nidedi bi John Baptist, be yaku nidedi bi Elijah, ma be yaku nidedi bi Jeremiah o Sei di ago niyo amiye yokoi.” ");
INSERT INTO kqc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma nikaiteyo, “Idu ya yaku nidedi na bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ye Simon Peter nikabai resi niyo, “Ya bi Keriso, toga amedo Sei di mida.” ");
INSERT INTO kqc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Iesu yaku nikabai reyo, “Ya Simon, Jonah di mida, ya bi buni tora gade moiyo, adina mina bi amiye yaku ya rofu de niokuyadi, idu nai Baba omari amedo yaku ya maro. ");
INSERT INTO kqc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma ya nida yi roka bi Peter, ma mina fore fafau nai dubu akugida, ma muyena vene di amena sana di vava yaku ka ebu rena de rego. ");
INSERT INTO kqc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Sei di ourefeidena amena sana omari di ki bi ya magida; ma beika konori goro rigiya bi omari ka goro rigo, ma beika konori eyounegiya bi omari ka eyounego.” ");
INSERT INTO kqc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mina usi ini usi dina vene ago maro bi amiye yokoi ga nioteimaragane ina bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mirona itua baeyori, ini usi dina vene rofu nirorotari regi kora reyo, ina bi Jerusalem ri bosi tora vene, Sei ma amiye utari naivo vene di varika vene, ma ago gira oteimana vene di esika esika tau moiyaine, ma umuyegedi ma gabi meda regodenuri dudusa dadi rae rego. ");
INSERT INTO kqc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kamini Peter yaku moi etagae risi besenai ago magi kora resi niyo, “Varika amiye, Sei mina biri riyaine; makai bi toga ya rofu vata ga niyaine!” ");
INSERT INTO kqc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Idu kero resi ina rofu niyo, “Satani, nai fufuta rofu di! Ya bi yabo daru kana nai ida gana rido, adina ya bi Sei di mokena kana de moisa, idu amiye di mokena moisa.” ");
INSERT INTO kqc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Resi ini usi dina vene rofu niyo, “Kaere amiye ini ura bi na usi digo vonisi, bi ina kaya toto nisi ini satauro moisi na usi baeyaine. ");
INSERT INTO kqc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Adina kaere ini vegu moi gira rigi ura rego, bi de moigo, idu kaere na dada ini vegu youfeidego, bi moigo. ");
INSERT INTO kqc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Adina beika buni bi amiye yokoi mina kono tora noibanuri baku resi ini vegu eyarego? O ini vegu dada bi beika dairi mago? ");
INSERT INTO kqc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ini adina Amiye di mida bi ini naivo naivo vima tausa ini Baba di vabarari desi amiye neinei ini beika reyadi kana ini obini mago. ");
INSERT INTO kqc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rama ya nida, ya bedakai minari bi de muyegedi bogo Amiye di mida Sei di ourefeidena amena sana nufa dego mina vegedi mamo.” ");
INSERT INTO kqc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kamini meda 6 koina niyori Iesu yaku Peter, James ma ini dubuini John afesi omuna tora yokoiri inaike maka boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mironari ina vene di nemokori ini roaita idana niyo. Ini seira bi meda kana kikiyo, ma ini varuka bi vabara kana feyo kamanika iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma Moses ma Elijah ina rofu ogau nisi Iesu sa sina nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ye Peter yaku niyo, “Varika amiye, bi buni una bi minari! Ye ya ura regiya vonisi, bi minari karaga regode akugida—yokoi bi yi, yokoi bi Moses di, ma yokoi bi Elijah di.” ");
INSERT INTO kqc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mina nigamori, seuya vabara kama resi ina vene bou riyo ma ago goroka mina seuya gutuna desi niyo, “Mina bi nai uka maida Mida, kaere ina rofu ada tora reida—ina bi neidefa!” ");
INSERT INTO kqc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ini usi dina vene mina neideyadiri, ori resi ini seira kono rofu aesi raudai reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma desi avaka moisi niyo, “Ori ga resi dadifo!” ");
INSERT INTO kqc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma dadisi ne odoro reyadiri, amiye yokoi de veyadi idu Iesu maka. ");
INSERT INTO kqc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ye omuna degamadiri, Iesu yaku ago gira magamo, “Mina yaduka kana veyadi bi amiye ga nifa, bogo Amiye di mida bi muyenari gutuna dadi rae rego mamo.” ");
INSERT INTO kqc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kamini ini usi dina vene yaku nikaiteyadi, “Ye beika resi ago gira oteimana vene yaku nidedi Elijah siko deyaine?” ");
INSERT INTO kqc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ye nikabai reyo, “Rama Elijah siko desi beika tau dudusa moi dogo rei mona rego. ");
INSERT INTO kqc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Idu ya nida, Elijah bi sena deyo, idu vei mama de resi ini beika mokeyadi kana ina rofu reyadi. Ye Amiye di mida ka ini vanari esika moigo.” ");
INSERT INTO kqc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mina resi usi dina vene vei mama reyadi ina bi John Baptist nigika niyo. ");
INSERT INTO kqc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kamini amiye tau gade rofu baeyadiri, amiye yokoi baesi Iesu di budari ini efuka imisi ");
INSERT INTO kqc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","niyo, “Varika amiye, nai mida rofu iriyeduka re, adina bi ada gauka amiye ma esika esika tora gade moido. Adina uru tau gade ita mokari ma koruri keto redo. ");
INSERT INTO kqc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ye yi usi dina vene rofu afei baeyaka, idu moi buni rina anua reyadi.” ");
INSERT INTO kqc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma nikabai reyo, “Ya gua mokena vari gira de aena ma mokena no vene, gokaisanu ari doba yasa amegida? Meda gokaisanu yasa moimai regida? Na rofu afei baefo!” ");
INSERT INTO kqc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ye vima no besenai ago maro ma yakuyo ma mina meda nemokori maka mina mida moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mina usi ini usi dina vene sui dudu Iesu rofu baesi nikaiteyadi, “Beika resi bi meki rena anua reyafa?” ");
INSERT INTO kqc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ye nikabai reyo, “Yi mokena vari gira aena bi keika dada. Adina rama ya nida, yi mokena vari gira aena bi mastadi di yoya kana vonisi, bi yomina omuna rofu nigedi, ‘Ya kaya mironari etagae ri,’ vo nigediri, mina omuna minari gutuna rekirei bogo. Ye beika yokoi ya rofu bi anua regedi!” ");
INSERT INTO kqc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilee ri egogo reyadiri, Iesu yaku ina vene rofu niyo, “Amiye di mida bi amiye di vanari siri regika kaira niyo ma ");
INSERT INTO kqc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","umuyegedi ma meda regodenuri dadi rae rego.” Ye ini usi dina vene iriyeduka yaku no niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu ini usi dina venesa Capernaum ri okiyadiri, bi Sei nivakena yava di takesi butu rena vene Peter rofu baesi nikaiteyadi, “Yi oteimana amiye bi Sei nivakena yava di takesi mado ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ina yaku niyo, “Yo.” Peter yava ideri baeyori, Iesu ina siko ago niyo, “Simon beika mokeisa? Kono di kini bi ini davana ma takesi bi kaere rofu butu rededi—iniye di ini amiye rofu ba amiye bedakai rofu?” ");
INSERT INTO kqc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma nikabai reyo, “Amiye bedakai rofu.” Ye ina rofu niyo, “Makai bi ini amiye rofu bi de moigedi. ");
INSERT INTO kqc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Makai bi buni de mina vene di uka bi moi kenoka renadi, ye moka daidai torari nesi yi kimai makugiya. Ouresi oyena moigiya mina moisi ini vena moi rafo resi siriva fore baku regiya. Mina moisi nai ma yi kana bi mina fore ina vene magiya.” ");
INSERT INTO kqc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mina meda nemokori, Iesu ini usi dina vene baesi nikaiteyadi, “Sei di ourefeidena amena sana omari kaere bi tora iniye?” ");
INSERT INTO kqc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ye mida keika yokoi raka nisi ini fogori moi are resi ");
INSERT INTO kqc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","niyo, “Rama ya nida, ya bi diya vegu no gedu masi mida keika kana nigedi vonisi, bi toga Sei di ourefeidena amena sana omari dui de regedi. ");
INSERT INTO kqc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mina dada kaere mina mida kana iniye moi ave nigo, bi Sei di ourefeidena amena sana omari tora iniye. ");
INSERT INTO kqc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma kaere yaku nai roka dudu mida yokoi makai kana moi dui rego, bi na moi dui rego. ");
INSERT INTO kqc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Idu kaere amiye mina mida keika keika yokoi kaere bi mokena vari gira na rofu aedo, bi mina mida ourefeidego vonisi, ma vegu no rego, bi kaunava tora moigo. Bi buni bi witi utei rena di fore tora ini kuriri ukita resi davara di moka tobori makugo ma koru irigo. ");
INSERT INTO kqc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gokai no iniye iniye mina kono vene rofu bi vegu no fafau uka maina regika nivedo! Mina vegu no fafau uka maina regika bi baebigo, idu gokai no iniye iniye mina amiye rofu kaere ina rofu moi baedo bi! ");
INSERT INTO kqc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ye yi vana o yi yuka yaku ya moi vegu nori ourefeidego vonisi, nugai maku! Makai bi buni, vana yokoi maka nufa o yuka kevo nufa, vegu buni dui regiya ma buni de, vana o yuka remanu nufa toga toga vaido ita mokari ya makugo. ");
INSERT INTO kqc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma yi nemoko yaku ya moi vegu no rofu ourefeidego vonisi, kini biyoka resi maku! Makai bi buni ya rofu vegu buniri nemoko yokoi maka nufa dui regiya, ma buni de nemoko remanu nufa ita mokari makugo. ");
INSERT INTO kqc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Vei mona refa ya bi mina mida keika keika yokoi rofu gedu ga mafo. Adina bi ini nari rededi naivo naivo vima omari toga nai Baba omari amedo amiye di seira vegasa amededi. ");
INSERT INTO kqc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ya beika mokededi bi buni? Amiye yokoi ini mamoe 100 nufa vonisi, ma yokoi bi feresi digo, ina bi mina 99 omuna ikau feresi mina yokoi maka boiyo reyo maina de digo ba? ");
INSERT INTO kqc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Rama ya nida, mina baku rego vonisi, bi mina 99 de diyadi rofu ada de rego, idu mina yokoi maka rofu ini ada rego bi tora iniye. ");
INSERT INTO kqc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ye yi Baba omari amedo amiye ina ura de mina mida keika keika yokoi bi boiyo reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Yi usika ourena ya rofu vegu no rego vonisi, bi bosi ya remanu di utari maka oteima ini beika no reyo bi. Ya neidego vonisi, bi yi usika ourena di uka moi dairiyo. ");
INSERT INTO kqc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Idu de ya neidego vonisi, amiye yokoi o remanu yasa afei bo, ye ya yaku beika ago noibanu nigiya bi mina ninegau rena amiye remanu o regode ago nisi noibanu dabi risi nigedi. ");
INSERT INTO kqc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Idu ina vene di ago de neidego vonisi, bi ekalesia vene nifo. Ye ekalesia vene di ago ka de neidego vonisi, bi yi mokenari ofa sei nivakedo amiye kana o fore butu redo amiye kana ya dada nigo. ");
INSERT INTO kqc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Rama ya nida, beika konori goro rigedi, bi omari ka goro rigo, ma beika konori eyounegedi, bi omari ka eyounego. ");
INSERT INTO kqc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Dudusa ya nigida, beika tau ya remanu konori uka yokoi maka nisi usa nigedi bi, nai Baba omari yaku ya rofu rego. ");
INSERT INTO kqc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Adina goinari amiye remanu o regode nai rokari egogo regedi, na bi inasa mironari.” ");
INSERT INTO kqc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mina usi Peter bi Iesu rofu baesi nikaiteyo, “Varika amiye, nai usika ourena vegu no na rofu rego, bi uru gokaisanu ini vegu no moi erufugida? Uru 7 ba?” ");
INSERT INTO kqc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nikabai resi niyo, “Ya nida, uru 7 de, idu uru 70 x 7 moi erufugiya, ");
INSERT INTO kqc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","adina Sei di ourefeidena amena sana omari bi kini yokoi yaku ini moimai rei tavoi rededi vene rofu ini fore moiyadi mina moi rorobo rigi reyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mina moi rorobo rigi kora reyori, amiye yokoi kaere bi talent fore 10,000 moiyo mina ina rofu moi dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ina bi beika fore moiyo, bi mai dairina vana tumu niyo dada, varika amiye yaku niyo, iniye, ini rema, ini mida ma ini gugura tau inasa mina sero resi ini beika fore moiyo kana mina moi dairiyainedi riyo. ");
INSERT INTO kqc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ye mina moimai rei tavoi redo amiye yaku ini budari efuka meimisi usa niyo, ‘Na toro re, yi fore moiyaka bi tau vakoi ya mai dairigida!’ ");
INSERT INTO kqc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ini varika amiye yaku iriyeduka resi ini beika fore moiyo kana ga moi dairiyainedi nisi feresi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Idu mina amiye yakugasa ini vakoi moimai rei tavoi redo amiye yokoi baku reyo kaere bi ina rofu 100 denarius fore moiyo. Mina amiye di bauye moi gira reyo ma asa imitoto reyo. Ma niyo, ‘Beika fore na rofu moiyo bi na ma!’ ");
INSERT INTO kqc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ye ini vakoi moimai rei tavoi redo amiye bi ini efuka konori meimisi usa niyo, ‘Na toro re, yi fore moiyaka bi ya rofu moi dairigida!’ ");
INSERT INTO kqc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Idu ina bi ura de resi bosi mina amiye bi moi diburari aeyo bogo ini fore moiyo mina mago mamo. ");
INSERT INTO kqc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ini vakoi moimai rei tavoi rededi vene yaku beika vata niyo mina veyadiri, ini uka kenoka reyadi ma boyadi ini varika amiye beika tau vata niyo mina nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kamini ini varika amiye yaku mina moimai rei tavoi redo amiye raka nisi niyo, ‘Ya bi moimai rei tavoi redo amiye no! Yi beika fore tau vakoi moiyo bi na rofu usa niyo dada ferei tavoi reyaka. ");
INSERT INTO kqc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma na yaku ya rofu iriyeduka reyaka kana yi vakoi moimai rei tavoi redo amiye rofu bi regiya vo niyo ba ide?’ ");
INSERT INTO kqc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma ini varika amiye gubuyo resi dibura nari rededi vene di vanari aeyo bogo ini fore moiyo moi dairi mai vau rego mamo.” ");
INSERT INTO kqc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ye yi usika ourena neinei ini vegu no yi uka dudu de moi erufugedi vonisi, makai nai Baba omari ka ya vene rofu rego.” ");
INSERT INTO kqc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kamini Iesu mina sina nigamo koina niyori, Galilee feresi Jordan koru di berou eta rofu Judea gaganiri boi neyo. ");
INSERT INTO kqc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ye amiye tau gade ina usi boyadi ma mironari moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ye Pharisee vene ini uka maina regika nivegi ina rofu baesi nikaiteyadi, “Rumana yaku ini rema mesi ferego bi ago gira ukero vau rido ba ide, deda vegu o mokena dada?” ");
INSERT INTO kqc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma Iesu nikabai reyo, “Bura be veyadi ba, ini adinari gutuna Riyo amiye yaku bi rema ma rumana riyo? ");
INSERT INTO kqc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ka niyo, ‘Mina dada rumana ini nono baba feresi etagae rigo ini remasa roaita gogo nigedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ye ina bi dudusa remanu de, idu yokoi maka nigedi. Mina dada beika Sei yaku moi gogo resi moi yokoi maka riyo, bi amiye yaku ga moi etagae riyagane.” ");
INSERT INTO kqc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ye nikaiteyadi, “Ye beika resi Moses bi rumana yaku ini rema ferena fefa masi nifeideyainedi mina ago gira maro?” ");
INSERT INTO kqc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma nikabai reyo, “Moses yaku bi yi rema nifeidefo vo niyo, ini adina yi uka gira kiki dada. Idu ini adinari gutuna bi makai de. ");
INSERT INTO kqc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Idu ya nida kaere amiye ini rema koa de reyo ma ina yaku nifeidesi rema bouna mego, bi koa rego.” ");
INSERT INTO kqc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ini usi dina vene yaku niyadi, “Rema rumana di ida bi makai vonisi, bi mena de rebigedi bi buni.” ");
INSERT INTO kqc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ye nikabai reyo, “Mina ago bi amiye tau yaku bi de moigedi, idu kaere maro vene yaku maka. ");
INSERT INTO kqc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Adina rumana be bi mena anua rededi, adina be bi makai vata niyadi dada; be bi makai amiye riyadi dada; ma be bi makai iniye riyadi, Sei di ourefeidena amena sana oma rofu dada. Kaere mina ago neidegasa moigo vonisi, buni bi moiyaine.” ");
INSERT INTO kqc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mina ituari be vene yaku mida keika keika ina rofu afei baeyadi, ini vana ina fafau aesi usa usa niyainedi dada, idu ini usi dina vene yaku nivaiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Idu niyo, “Mida keika keika bi ferefo kumo na rofu baeyagane; ga meki refo, adina Sei di ourefeidena amena sana omari bi mina kana vene di.” ");
INSERT INTO kqc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ye ini vana ina fafau aesi mina sana feresi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma amiye yokoi ina rofu baesi nikaiteyo, “Oteimana amiye, beika vegu buni regida bi toga toga ameibobina vegu moigida?” ");
INSERT INTO kqc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Iesu yaku niyo, “Beika resi buni vo nigasa na nikaiteisa? Amiye yokoi maka bi buni. Ya ura reisa mina vegu buni dui regiya vonisi, bi ago gira neidegasa rebi.” ");
INSERT INTO kqc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma nikaiteyo, “Goina?” Ye nikabai reyo, “Amiye umuyena ga re; koa ga re; duma duma ga re; amiye di vegu fafau ofa ofa ago ga ni; ");
INSERT INTO kqc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yi nono baba emagui re; ma ya kaya uka maisa kana, yi atafu amedo amiye uka ma.” ");
INSERT INTO kqc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mina godua yaku niyo, “Mina kana vegu ago tau vakoi neidegamaka, ye goina be bi regida?” ");
INSERT INTO kqc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma nikabai reyo, “Ya ura rorobo iniye nigiya vonisi, bosi yi gugura sero resi ini fore irava vene masi yi gugura buni bi omari baku regiya, ye na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Idu mina godua mina ago neidesi ini uka yarena iniye reyo ma dadisi diyo, adina ina bi gugura tau gade nufa. ");
INSERT INTO kqc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ye ini usi dina vene rofu niyo, “Rama ya nida: gugura tau gade amiye yaku Sei di ourefeidena amena sana omari dui rena bi gira iniye. ");
INSERT INTO kqc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dudusa nida: kamelo yaku niduru nemokori dui rego bi aita, idu gugura tau gade amiye yaku Sei di ourefeidena amena sanari dui rena bi gira iniye.” ");
INSERT INTO kqc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ye ini usi dina vene mina ago neidegasa tururu iniye resi nikaiteyadi, “Makai bi kaere moi vegu rigo?” ");
INSERT INTO kqc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma vesi niyo, “Amiye yaku mina bi anua regedi, idu Sei rofu tau noibanu rena bi aita iniye.” ");
INSERT INTO kqc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kamini Peter nikabai reyo, “Ve kumo, uni beika baika tau vakoi feresi ya usi diyafa! Ye bi beika moigifa?” ");
INSERT INTO kqc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Iesu yaku ina vene rofu niyo, “Rama ya nida, kono beika tau moi ruaka rigedi medari, Amiye di mida ini vabara di ourefeidena amena fata fafau ameinu regori, ya kaere na usi diyadi ka makai ourefeidena amena fata 12 fafau ameinu resi Israel vene di rubu 12 ourefeidegedi. ");
INSERT INTO kqc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma kaere ini yava o usika ourena, o nono baba, o mida, o kono nai roka dada fereyadi, bi tau 100 kana besa ma toga toga ameibobina vegu moigo. ");
INSERT INTO kqc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Idu amiye tau gade kaere bi ourededi vene bi gabi nigedi, ma gabi nidedi vene yaku ouregedi. ");
INSERT INTO kqc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Adina Sei di ourefeidena amena sana omari bi kono amiye yokoi kana, kaere uriyaku niyori ini waini meko muro rofu amiye moimai reyaganedi omagi boyo. ");
INSERT INTO kqc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ina venesa uka yokoi maka niyadi denarius yokoi moigedi mina mago. Mina usi bi ini waini murori nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Meda nemoko 9:00 ri bosi maketi sanari amiye be bi are rei tavoi tavoi regamadi ma vesi ");
INSERT INTO kqc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ina vene rofu niyo, ‘Ya vene ka bosi nai waini murori moimai regedi, ma na yaku fore beika bi rama ya magida.’ ");
INSERT INTO kqc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ye ina vene boyadi. Dudusa meda nemoko 12:00 ma meda nemoko 3:00 uriyenauri bosi ouresi reyo kana reyo. ");
INSERT INTO kqc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Meda nemoko 5:00 kanari nesi veyo be are regasa amegamadi. Resi nikaiteyo, ‘Beika resi beika yokoi rena de mina meda doba are regasa amededi?’ ");
INSERT INTO kqc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ma nikabai reyadi, ‘Yokoi yaku moimai renadi vo de una niyadi dada.’ Ina yaku niyo, ‘Ya ka bosi nai waini meko murori moimai regedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Uriyenau niyori, waini muro biyaguna amiye yaku ini moimai ourefeidena amiye rofu niyo, ‘Moimai rededi vene raka nisi ini fore ma. Ouresi bi gabi moimai reyadi vene siko, ma bogo ouresi moimai reyadi rofu koina niyainedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Moimai vene kaere bi meda nemoko 5:00 kana moimai regi kora reyadi neinei baesi ini denarius yokoi maka moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ye, ouresi moimai reyadi vene baeyadiri, ini moke moke ina bi moi tora regedi vo niyadi. Idu ina tau vakoi ka denarius yokoi maka moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mina moigasa waini meko muro amiye rofu mumugu nisi ");
INSERT INTO kqc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","niyadi, ‘Mina vene kaere bi gabi baeyadi bi meda nemoko yokoi maka moimai reyadi, idu uni fore kana maro—una kaere bi meda doba ma meda seiri moimai reyafa!’ ");
INSERT INTO kqc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Idu ina vene rofu nikabai reyo, ‘Asini, na bi ya rofu no yokoi de reyaka; ya meda yokoi maka di moimai fore dada moimai regiya di uka yokoi maka be reyafa ba? ");
INSERT INTO kqc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yi fore moisi di. Nai ura bi gabi moimai reyo amiye di fore magi reida ya maraka kana. ");
INSERT INTO kqc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mina bi nai fore; na bi nai ura beika regida bi, o ya bi na rofu maunu nisi nai buni reida dada ba?’” ");
INSERT INTO kqc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ye gabi vene bi ouregedi, ma ourededi vene bi gabi nigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kamini Jerusalem bogasa idau ini usi dina vene 12 moi etagae risi nana uyai regasa sina nimaro, ");
INSERT INTO kqc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Neidefa, una bi Jerusalem bogifa, ma Amiye di mida siri resi Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene rofu magedi. Ina vene yaku kota regedi bi muyeyaine, ");
INSERT INTO kqc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","resi tutubena idana vene di vanari aegedi ma nikurusi buburu vai resi satauro ikoko reyaganedi; idu gabi meda regodenuri dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kamini Zebedee di mida mida ini nonosa Iesu rofu baeyadi ma ini budari efuka meimisi ini beika ura rededi usa niyo. ");
INSERT INTO kqc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma nikaiteyo, “Ya ura reisa bi beika?” Nikabai reyo, “Nai mida remanu bi yi ourefeidena amena sanari yokoi bi yi vana rama rofu ameinu reyaine ma yokoi bi enana rofu ameinu reyaine.” ");
INSERT INTO kqc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Idu Iesu yaku nikabai reyo, “Ya beika usa nidedi bi ya ya toto. Na biyori irigida mina kana regedi ba?” Ye nikabai reyadi, “Mina bi buni regifa.” ");
INSERT INTO kqc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma niyo, “Na biyori irigida kana irigedi, idu nai vana rama rofu ma enana rofu ameinu rena di vava bi na yaku de ya magida. Mina bi kaere kaere nai Baba yaku ina rofu dogo reyo maka.” ");
INSERT INTO kqc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ye amiye 10 mina neidesi uba dubuisa rofu gubuyo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Idu Iesu yaku raka nisi niegogo resi niyo, “Ya ya diba tutubena idana vene di ourefeidena vene yaku ini vene fafau ini vava moi raga rededi, ma ini tora vene ini vava dudu beika vegu regedi amiye ini gabireri ago gira nidedi. ");
INSERT INTO kqc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ye yi fogori bi makai de; idu kaere yi fogori ini ura tora nigo vonisi, ina bi yi naivo rena amiye nigo; ");
INSERT INTO kqc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ma kaere yi fogori ouregi ura redo, bi yi moimai rei tavoi redo amiye nigo— ");
INSERT INTO kqc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amiye di mida deyo kana, diya amiye yaku naivo regedi, idu amiye di naivo regi ma ini vegu magi, amiye tau di vegu no reyadi voi regika.” ");
INSERT INTO kqc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kamini Jericho feresi yakuyadiri, amiye tau gade usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne taufa amiye remanu bi ida seriri amegasa Iesu bae bodo neidesi raka niyadi, “Varika amiye, David di tutubena, una iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Idu amiye tau gade yaku emaradi babo niyagane vo niyadi, idu besa raka niyadi, “Varika amiye, David di tutubena, una iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ye Iesu are resi raka nisi niyo, “Ya ura rededi bi na yaku beika ya rofu regida?” ");
INSERT INTO kqc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nikabai reyadi, “Varika amiye, una ura resifa bi dudusa gagani vegifa!” ");
INSERT INTO kqc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mina resi ina vene rofu iriyeduka resi ini nemoko avaka moiyo ma evade dudusa gagani veyadi ma ina usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kamini Jerusalem ri bae ekaira resi Bethphage, Olive yabo di omuna adinari boyadiri, Iesu bi ini usi dina amiye remanu nifeidesi ");
INSERT INTO kqc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","niyo, “Rautu yokoi yi buda rofu boi nefa. Mina sanari evade boi okigasa donkey ini midasa ukita riyadi baku regedi. Younesi na rofu moi bae defa. ");
INSERT INTO kqc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ye amiye yokoi yaku ago ya nigo vonisi, bi nifa, ‘Varika amiye yaku ura redo’; ma minari evade nifeidego.” ");
INSERT INTO kqc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mina vata niyo, bi beika Sei di ago niyo amiye yaku niyo bi bae rama aeyo: ");
INSERT INTO kqc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion di vefa nifa, Vefa, yi kini ya rofu baedo! Ave nisi donkey fafau ma ini rumana mida fafau amesi baedo mini.” ");
INSERT INTO kqc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ye ini usi dina vene feresi niyo kana reyadi: ");
INSERT INTO kqc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","donkey ini midasa moi bosi ini fafau rina varuka fafau youyadi ma Iesu keu riyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma amiye tau gade gade yaku ini fafau rina varuka idau ibu reyadi ma be bi yabo teteka nugasi idau ibu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kamini amiye tau gade fogori be bi ouregamadi ma be bi usi digamadi ma raka nigamadi, “David di tutubena di roka moi odoro ri! Sei buni tora gade mado, kaere bi Varika amiye di rokari baedo! Sei oma odoro iniyeri di roka moi odoro ri!” ");
INSERT INTO kqc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mina usi Jerusalem ri okiyo ma taoni vene noibanu bi kenoka resi nikaiteyadi, “Mina bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ye mina amiye tau gade yaku niyadi, “Mina bi Iesu, Sei di ago niyo amiye Nazareth taoni Galilee gagani rofu.” ");
INSERT INTO kqc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kamini bi Sei nivakena yava dui resi bi sero rena vene ma voi rena vene tau gade umeki rei feideyo. Fore senesi rena vene di teiboro ma pune erena sero rena vene di amena fata moi evairo reyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Resi niyo, “Sena bura reyo, ‘Nai yava bi usa usa nina yava vo nigedi,’ idu ya vene yaku duma duma vene di sui nina yava kana reyadi!” ");
INSERT INTO kqc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ye Sei nivakena yavari ne taufa ma yuka no vene ina rofu baeyadi ma moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Idu Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene yaku mina beika buni buni regamo ma mida mida yaku Sei nivakena yava ideri raka nigamadi, “David di tutubena di roka moi odoro ri!” mina veyadiri, bi gubuyo resi ");
INSERT INTO kqc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","nikaiteyadi, “Beika nidedi bi neideisa ba?” Nikabai reyo, “Yo neideida; ye ya bi bura veyadi ba, ‘Ya yaku mida mida ma kakua yi roka moi odoro rigi oteimaradi’?” ");
INSERT INTO kqc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kamini ina vene feresi taoni yakusi Bethany urana diyo. Mina urusa mironari vareyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Uriyaku gorogoro taoni bogasa rauna reyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ye idau fuka yabo vesi atafu baeyo, idu iye roena baku resi niyo, “Ya bi toga toga meko ga vare!” Minari maka mina yabo abiye niyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ye ini usi dina vene mina vesi tururu regasa nikaiteyadi, “Gokai resi mina fuka yabo bi evade abiye niyo?” ");
INSERT INTO kqc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ye nikabai reyo, “Rama ya nida, yi mokena vari gira aesi mokei itu de regedi vonisi, na yaku mina fuka yabo rofu reyaka kana maka de regedi, idu mina omuna rofu ka nigedi vonisi, ‘Ya kaya dadisi moka daidai tora ideri you,’ ma makai vata nigo. ");
INSERT INTO kqc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ye mokena vari gira aegedi vonisi, beika baika tau rofu usa usa nigedi bi moigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kamini Sei nivakena yavari dui resi oteimagamori, Sei ma amiye utari naivo vene di varika vene ma tora vene ina rofu baesi nikaiteyadi, “Beika vava dudu mina vegu reisa? Ma kaere yaku mina vava ya maro?” ");
INSERT INTO kqc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma nikabai resi niyo, “Nai nikaitena ka bi yokoi maka. Na nikabai regedi vonisi, ya ka nigida beika vava dudu mina vegu reida. ");
INSERT INTO kqc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John di babatiso rena di vava bi goinari gutuna baeyo? Oma gutuna ba amiye gutuna?” Ye iniye iniye nidodi resi niyadi, “Ye ‘Oma gutuna,’ nigifa vonisi, una nikaitego, ‘Ye beika resi ina rofu mokena vari gira de aeyadi?’ ");
INSERT INTO kqc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Idu ‘Amiye gutuna,’ nigifa vonisi, una bi amiye tau rofu ori resifa, adina ina tau vakoi mokededi John bi Sei di ago niyo amiye yokoi.” ");
INSERT INTO kqc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ye nikabai reyadi, “Una una toto.” Ma niyo, “Na yaku ka makai de ya nigida na bi beika vava dudu mina vegu reida bi. ");
INSERT INTO kqc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ya beika mokededi? Amiye yokoi bi ini mida remanusa amegamadi. Ini ourena mida nesi niyo, ‘Gua nesi waini meko murori moimai re.’ ");
INSERT INTO kqc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Idu nikabai reyo, ‘Na ura de reida,’ idu gabi ini mokena kero resi neyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mina usi ini mida yokoi rofu nesi ouresi niyo kana niyo. Ma nikabai reyo, ‘Baba, negida,’ idu nena de reyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Goina bi ini baba di ura reyo?” Ina vene yaku nikabai reyadi, “Ourena yaku.” Dada Iesu yaku ina vene rofu niyo, “Rama ya nida, fore butu rededi vene ma koa rededi vene yaku siko Sei di ourefeidena amena sanari dui regedi ma ya bi gabi mamo. ");
INSERT INTO kqc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Adina John bi mokena rorobo di ida ya oteimagika diyo ma ya bi ina rofu mokena vari gira de aeyadi; idu fore butu rededi vene ma koa rededi vene bi mokena vari gira aeyadi. Ma mina ka veyadi usi mokena kero de resi mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mokena ago yokoi neidefo: Yava biyaguna amiye yokoi bi waini meko muro varisi kota mina buru risi waini meko itei rina di kono ruba goesi ota rina vene di fata risi muro nari rena vene be ini nanaka moigika nimasi yava ika oto diyo. ");
INSERT INTO kqc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mina usi butu rena di meda okiyori, ini moimai rei tavoi rededi vene bi muro nari rena vene rofu nifeidesi ini waini meko butu reyadi moiyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Idu mina moimai rei tavoi rededi vene moi gira reyadi; yokoi bi ubobo reyadi, yokoi bi umuyeyadi ma yokoi bi fore dudu uyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kamini dudusa ini moimai rei tavoi rededi vene be nifeideyo, ouresi kana de, idu gua bi besa, ma muro nari rededi vene yaku ouresi reyadi kana reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ye gabi koukou bi ini mida nifeidesi niyo, ‘Nai mida bi matagini regedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Idu muro nari rededi vene yaku mida vesi iniye iniye niyadi, ‘Mina bi muro biyaguna amiye nigo. Nesi umuyesi beika baika ini baba yaku ferego bi moinadi!’ ");
INSERT INTO kqc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ye moi gira resi waini meko di muro etofarori makusi umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Mina dada waini meko muro di biyaguna amiye baegasa mina muro nari rededi vene rofu bi gokai beika be rego?” ");
INSERT INTO kqc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ina vene yaku nikabai reyadi, “Mina no vene bi umuyei mona resi ini waini meko muro bi nari rededi vene be ini nanaka moigika nimago, ina kaere yaku butu rena meda okigori ini waini meko magedi.” ");
INSERT INTO kqc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu niyo, “Ya bi toga Sei di agori bura veyadi ba? ‘Yava akuna vene moi kekevata uyadi fore bi yava moi gira redo fore iniye niyo. Mina bi Varika amiye yaku reyo; ma uni nemokori bi buni vayavaya!’ ");
INSERT INTO kqc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mina dada ya nida, Sei di ourefeidena amena sana bi ya rofu moi etagae risi gagani vene yokoi mago kaere yaku ini vegu buni rebigedi. ");
INSERT INTO kqc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma kaere mina fore fafau keto rego bi uratoku vau rego, ma mina fore kaere fafau yarego bi mina amiye foyoma rego ma budoka nigo.” ");
INSERT INTO kqc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sei ma amiye utari naivo vene di varika vene ma Pharisee vene yaku ini mokena ago neidegasa diba niyadi ina vene fafau nigamo, ");
INSERT INTO kqc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ye moi gira regika ida maina reyadi, idu amiye tau gade rofu ori reyadi, mokegamadi ina bi Sei di ago niyo amiye dada. ");
INSERT INTO kqc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ye Iesu dudusa ina vene rofu mokena ago dudu niyo, ");
INSERT INTO kqc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sei di ourefeidena amena sana omari bi kini yokoi kaere yaku ini mida di rema mena irakuna rei maro mina kana. ");
INSERT INTO kqc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Resi ini moimai rei tavoi rededi vene nifeideyo rema mena irakunari raka niyo vene nigedi baeyaganedi, idu ura de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mina usi ini moimai rei tavoi rededi vene be dudusa nifeidesi niyo, ‘Daga reyadi vene nigedi, Na bi nai irakuna reyaka; nai boromakau rumana ma nai boromakau mida burefe usi irakuna di beika baika dogo reyadi. Ye rema mena irakunari baefa!’ ");
INSERT INTO kqc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Idu neidena de resi diyadi: yokoi bi ini murori diyo ma yokoi bi voi resi sero regi diyo, ");
INSERT INTO kqc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma be yaku dadisi kini di moimai rei tavoi rededi vene moi gira resi vegu no resi umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kamini kini bi gubuyo resi ini iya rededi vene nifeideyo ma mina umuyededi vene u vau resi ini taoni ori kamu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mina usi ini moimai rei tavoi rededi vene rofu niyo, ‘Rema mena irakuna di iruku dogo resi amedo, idu raka niyaka vene bi ini rorobo de nufa okigedi. ");
INSERT INTO kqc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mina dada desi ida teukana neineiri kaere tau baku regedi mina nifo kumo irakunari baeyagane.’ ");
INSERT INTO kqc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ye mina moimai rei tavoi rededi vene idari disi kaere tau vakoi baku reyadi mina ni butu reyadi, buni ma no vene. Ye ini daga reyo vene yaku rema mena irakuna sana vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Idu kini irakuna rededi vene vegika bae dui reyori, rema mena irakuna di varuka rina de amiye yokoi veyo. ");
INSERT INTO kqc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ye nikaiteyo, ‘Asini, ya bi gokai ida dudu irakuna varuka nufa de dui reyo?’ Idu mina amiye bi de nikabai reyo. ");
INSERT INTO kqc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kamini kini yaku ini naivo rededi vene rofu niyo, ‘Yuka vana misi mukunari maku nefa. Mironari amiye ini gade giko nigedi ma isaka nigo.’” ");
INSERT INTO kqc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Adina tau gade bi raka niyo, idu bedakai maka auba redo.” ");
INSERT INTO kqc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mina usi Pharisee vene yaku disi ini ago dudu gokai Iesu eyaregedi mina nirorotari reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Resi ini usi dina vene Herod di usi dina venesa ina rofu nifeidesi ma niyadi, “Oteimana amiye, una una diba ya bi sina rama maka nisa amiye ma sina rama dudu maka Sei di ida oteimaisa. Ya bi amiye rofu de ori reisa, ini adina bi amiye gokai kana bi de mokeisa. ");
INSERT INTO kqc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mina dada una ni, yi mokena bi beika? Caesar rofu takesi fore fei rena bi uni ago gira rofu rorobo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Idu sena ini mokena no veifatesi niyo, “Ya ofarosi vene, beika resi nai uka maina regika nivededi? ");
INSERT INTO kqc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takesi fore na oteimafa.” Ye siriva fore yokoi ina rofu moi baeyadi ");
INSERT INTO kqc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ma nikaiteyo, “Mina bi kaere di vima ma roka?” ");
INSERT INTO kqc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ye nikabai reyadi, “Caesar di.” Kamini niyo, “Mina dada beika Caesar di, bi Caesar mafa, ma beika Sei di, bi Sei mafa.” ");
INSERT INTO kqc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mina neidegasa tururu resi ina feresi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mina medari, Sadducee vene, kaere niyadi dadi rae rena bi koina, yaku Iesu rofu baesi nikaitegasa ");
INSERT INTO kqc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","niyadi, “Oteimana amiye, Moses yaku niyo bi, amiye yokoi muyego ma ini rema bi mida moina de vonisi, ini dubuini bi mina obu mesi ini dubuini di mida moiyainedi, vo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yokaru uni fogori bi dubuiyaka 7 amegamadi. Ourena ere bi rema mesi muyeyo; mida yokoi de, ye ini rema bi ini dubuini meyo. ");
INSERT INTO kqc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ini usi vata niyo amiye ka makai, ma mina usi amiye ka makai, ye neyo ini viaigana dubuini ka makai, ");
INSERT INTO kqc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ye gabi bi mina rema ka muyeyo. ");
INSERT INTO kqc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mina dada dadi rae renari, ina bi kaere di rema nigo, adina bi amiye 7 tau noibanu yaku meyadi?” ");
INSERT INTO kqc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma nikabai resi niyo, “Ya forovai rededi, Sei di ago ma ini vava ya toto dada. ");
INSERT INTO kqc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Adina dadi rae renari, bi iniye iniye de megedi, idu omari Sei di naivo naivo vima kana nigedi. ");
INSERT INTO kqc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Idu muyena gutuna dadi rae rena dada, ya bi Sei yaku beika ya niyo bi burari veyadi ba ide? Niyo, ");
INSERT INTO kqc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na bi Abraham di Sei, Isaac di Sei, ma Jacob di Sei.’ Ina bi vegu ameibobina vene di Sei, diya muyena vene di Sei.” ");
INSERT INTO kqc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mina amiye tau mina neidegasa ini beika oteimado rofu bi tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Idu neideyadi Iesu yaku Sadducee vene bi ago moi babo riyori, Pharisee vene gobuno reyadi ");
INSERT INTO kqc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ma ina yokoi kaere bi ago gira oteimana amiye yaku ini uka maina regika nivegasa nikaiteyo: ");
INSERT INTO kqc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Oteimana amiye, ago girari goina bi tora iniye?” ");
INSERT INTO kqc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ye nikabai reyo, “‘Yi uka meko noibanu, yi vima noibanu, ma yi mokena tora noibanu dudu Varika amiye yi Sei uka magiya.’ ");
INSERT INTO kqc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mina bi ourena ma isivaga iniye ago gira. ");
INSERT INTO kqc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma usi bi ouresi kana: ‘Ya kaya uka maisa kana, yi atafu amedo amiye uka magiya.’ ");
INSERT INTO kqc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ago gira tau ma Sei di ago niyadi vene di oteimana ago tau bi mina ago gira remanuri kimatau rededi mini.” ");
INSERT INTO kqc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ma Pharisee vene gobuno reyadiri, Iesu yaku nikaitegasa ");
INSERT INTO kqc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","niyo, “Keriso rofu bi beika mokededi bi rama? Ina bi kaere di tutubena?” Ye nikabai reyadi, “Ina bi David di tutubena.” ");
INSERT INTO kqc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ina vene rofu niyo, “Gokai resi David yaku Vima kikifa di vava dudu ‘Varika amiye’ vo niyo? Ye makai niyo, ");
INSERT INTO kqc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Varika amiye yaku nai Varika amiye rofu niyo: Nai vana rama eta rofu ameinu re bogo na yaku yi tuma vene yi yuka aena sana kana rigida mamo.’ ");
INSERT INTO kqc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Mina dada David yaku ‘Varika amiye’ vo niyo, ye gokai ida dudu ina bi ini tutubena?” ");
INSERT INTO kqc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ye amiye yokoi yaku ago nikabai regi anua reyo, ma mina meda gutuna boyo yokoi yaku dudusa nikaitegika de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kamini Iesu yaku amiye tau ma ini usi dina vene rofu nisi ");
INSERT INTO kqc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","niyo, “Ago gira oteimana vene ma Pharisee vene bi ini vava nufa Moses di ago gira niodoro rededi. ");
INSERT INTO kqc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mina dada beika tau ya nibigedi bi rebifa, idu beika vegu ina yaku rebigedi bi ga rebifa; ini adina beika nidedi bi de rededi. ");
INSERT INTO kqc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Toe moina anua rededi rofu misi amiye di megea fafau aededi, idu ini vana ebuna yaku amiye moi aedena ka de rededi. ");
INSERT INTO kqc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ini beika vegu tau rededi bi amiye be yaku veyaganedi. Adina ini Sei di ago maua tora risi ini etofaro varuka di maena doba ridedi! ");
INSERT INTO kqc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ye irakuna sanari ma usa usa yavari amena sana ka buni torari ");
INSERT INTO kqc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ma maketiri amiye yaku ago buni dudu matagini resi roka nisi ‘Nai oteimana amiye’ vo nibiyaganedi ura rededi. ");
INSERT INTO kqc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Idu amiye yaku bi ‘Nai oteimana amiye’ ga ya nibiyagane, ini adina ya bi yi Oteimana amiye yokoi maka nufa ma ya tau vakoi bi usika ourena. ");
INSERT INTO kqc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma mina konori amiye yokoi ‘baba’ vo ga nifa, ini adina yi Baba bi yokoi maka, bi omari amedo. ");
INSERT INTO kqc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amiye ka ‘ourefeidena amiye’ vo ga ya niyagane, ini adina yi Ourefeidena amiye yokoi maka, bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ye kaere yi fogori bi tora iniye bi yi naivo naivo redo amiye nigo. ");
INSERT INTO kqc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Idu kaere iniye moi odoro rigo bi Sei yaku moi ave rigo ma kaere iniye ave nigo bi Sei yaku moi odoro rigo. ");
INSERT INTO kqc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Idu ago gira oteimana vene ma Pharisee vene, ya kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina ya bi Sei di ourefeidena amena sana omari bi amiye di budari ida biri ridedi. Ye ya bi de dui rei bodedi. Regasa bedakai yaku dui rena mokededi bi, ya yaku ini ida biri ridedi! ");
INSERT INTO kqc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ago gira oteimana vene ma Pharisee vene, kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina davarari ma konori dibo resi amiye yokoi maka Jew vene di Sei nivakena vegu usi dina rofu moi kero regika. Ye kero regori, ya bi mina amiye ita mokari digo amiye ya kana moi remanu ridedi! ");
INSERT INTO kqc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ne taufa ourefeidena vene vegu no ya rofu vata nigo! Ya yaku nidedi bi, ‘Amiye yaku Sei nivakena yava di roka dudu nitore rego vonisi, mina bi beika yokoi de; idu Sei nivakena yava di goro dudu nitore rego vonisi bi mina ago kana reyaine.’ ");
INSERT INTO kqc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ya ne taufa ada de vene! Goina bi tora iniye: goro ba Sei nivakena yava yaku mina goro moi akeke rido ba? ");
INSERT INTO kqc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yomakai ka nidedi, ‘Amiye yaku ori sisika rena fore fata fafau nitore rego vonisi, bi beika yokoi de; idu beika gugura mana fafau amedo mina rofu nitore rego vonisi, bi mina ago kana reyaine.’ ");
INSERT INTO kqc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ya ne taufa amiye! Goina bi tora iniye: Gugura ba ori sisika rena fore fata yaku mina gugura mana moi akeke rido ba? ");
INSERT INTO kqc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mina dada, kaere yaku ori sisika rena fore fata fafau Sei rofu nitore redo bi mina gugura mana ma beika tau mina fata fafau nitore redo; ");
INSERT INTO kqc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ma kaere yaku Sei nivakena yava fafau nitore redo bi mina yava fafau ma kaere mina yava ideri amedo amiye rofu ka nitore redo; ");
INSERT INTO kqc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ma kaere yaku oma fafau nitore redo, bi Sei di ourefeidena amena fata ma kaere mina fata fafau amedo rofu ka nitore redo. ");
INSERT INTO kqc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ago gira oteimana vene ma Pharisee vene, ya kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina iruku moi sisika rena roka mint ma dill yuveita ma cumin di yo neinei moisi berou berou 10 ri yokoi maka bi Sei rofu madedi, idu ago gira di ago tora tora bi vei ebu reyadi; mina bi vegu rorobo rena, iriyeduka rena ma mokena vari gira aena vegu. Idu mina vegu reyagane ma vegu buni bedakai rededi bi ga ferefa. ");
INSERT INTO kqc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne taufa ourefeidena vene! Kimisona biyori bi moi kayo rei makudedi idu kamelo bi iri moudededi! ");
INSERT INTO kqc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ago gira oteimana vene ma Pharisee vene, kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina ya bi biyo ma siua bi etofaro maka koitededi, idu ini ideri bi dadaga ma ina kaya maka uka mokena moi vata baena vegu vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ya ne taufa Pharisee vene, ouresi biyo ma siua ideri siko koitefa kumo etofaro ka ruaka nigo! ");
INSERT INTO kqc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ago gira oteimana vene ma Pharisee vene, kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina ya bi amiye guri aeyadi sana feyo tayataya kana. Dada ini etofarori vena bi buni vayavaya, idu ini ideri bi muyena vene di nena ma beika tau bi kino yaku vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye ya ka yi etofaro amiye di nemokori ya vededi ya bi mokena rorobo vene, idu yi ideri bi ofarosi vegu ma vegu no ago gira fafau yaku vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ago gira oteimana vene ma Pharisee vene, ya kaere bi ofarosi vene, iriyeduka no iniye iniye ya rofu bi! Adina ya yaku Sei di ago niyadi vene di guri moi buni resi mokena rorobo rededi vene di guri yava ikefata dudu moi buni buni resi ");
INSERT INTO kqc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nidedi, ‘Una yaku uni tutubena vene amegamadi medari amebiyagadu vonisi, bi inasa Sei di ago niyadi vene di dava moi rausi de reyaidu.’ ");
INSERT INTO kqc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mina resi ya kaya ya kaya niogau rededi ya bi Sei di ago niyadi vene umuyeyadi vene di tutubena! ");
INSERT INTO kqc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mina ye, beika yi tutubena yaku kora reyadi, mina moi koina refa! ");
INSERT INTO kqc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ya aruma ma aruma di mida mida! Ya gokai ida dudu ori digedi ita mokari ya nifeidegori? ");
INSERT INTO kqc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mina dada nai ago nidedi vene ma mokena tora vene ma ago gira oteimana vene ya rofu nifeidegida; be bi umuyesi be bi satauro ikoko resi be bi yi usa usa yavari buburu vai resi be bi taoni yokoi gutuna taoni be rofu umeki rebigedi. ");
INSERT INTO kqc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dada konori mokena rorobo vene umuyeyadi vene di kaunava tau gade bi ya vene fafau yarego, mokena rorobo amiye Abel umuyeyadi gutuna boyo Berechaiah di mida Zechariah, kaere Sei nivakena yava ma ori sisika rena fore fata utari umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rama ya nida: mina tau vakoi bi gua amededi vene fafau yarego! ");
INSERT INTO kqc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem taoni vene o! Ya vene yaku Sei di ago niyadi vene umuyesi Sei ya rofu nifeideyo vene fore dudu uyadi! Uru gokaisanu yi mida mida egogo regi ura regamaka, kokoro kosini yaku ini mida ini eta gabireri bou rido kana, idu ya vene bi na gedu magamadi! ");
INSERT INTO kqc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ye yi sana bi autu nisi feresi digo. ");
INSERT INTO kqc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kamini ya nida, de na vegedi bogo meda yokoi okigori mamo nigedi, ‘Varika amiye di rokari dedo amiye buni tora gade maraine.’” ");
INSERT INTO kqc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kamini Iesu yaku Sei nivakena yava feresi yakuyori, ini usi dina vene baesi Sei nivakena yava di yava neinei veyainedi oteimaradi. ");
INSERT INTO kqc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Idu nikabai reyo, “Mina beika tau gade vededi ba? Rama ya nida, minari fore fafau fafau amededi gabi yokoi de amegedi; mina tau gade varadaugedi.” ");
INSERT INTO kqc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kamini Iesu bi Olive yabo omuna ikari amegamori, ini usi dina vene sui dudu ina rofu bosi nikaiteyadi, “Una ni, mina bi goivaka vata nigedi? Ma yi dairina ma meda bae koina nigo di rebe bi beika?” ");
INSERT INTO kqc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma nikabai reyo, “Nari rei mona refa; yokoi yaku ga ya eru reyaine. ");
INSERT INTO kqc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ini adina amiye tau gade nai roka dudu baesi iniye nikake regedi, ‘Na bi Keriso,’ resi amiye tau gade eru regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Idu iya rena negau ma iya rena maike di sina neidegedi. Mina yaku yi uka ga dadiyaine. Adina mina bi vata niyaine, idu ari metona bi baena kode. ");
INSERT INTO kqc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Adina gagani tora iniye iniye ma ourefeidena vene iniye iniye ruda regedi. Ma gagani bedakairi, adabo ogau nigedi ma kono yagayaga regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Idu mina tau bi mida odina di gera rena esika bae kora regedi kana. ");
INSERT INTO kqc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mina usi ya siri resi afei bosi esika esika ya masi ya umuyegedi, ma gagani gagani vene tau yaku nai roka dada ya rofu gubuyo regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Resi amiye tau gade mokei itu resi iniye iniye siri resi iniye iniye gubuyo regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kamini Sei di ago nidedi ofa vene tau gade ogau nisi amiye tau tora ofarosi regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ye vegu no rena tora nigedi dada, amiye tau di uka mana yau nigo. ");
INSERT INTO kqc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Idu kaere bi are rei gira rego bogo ari metona baego mamo, bi moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma mina Sei di ourefeidena amena sana di ago buni bi gagani gagani tau vakoiri niokuna ago kana kono tora noibanuri nirausi regedi; mamo ari metona baego. ");
INSERT INTO kqc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bura veisa amiye bi ada yora niyaine: Sei di ago niyo amiye Daniel yaku sena vegu no iniye redo amiye rofu niyo. Mina dada mina amiye akeke sanari are rego vegediri, ");
INSERT INTO kqc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bi ya kaere Judea gaganiri bi omuna rofu ori difa. ");
INSERT INTO kqc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yava tebo odorori amiye bi nesi ini yavari gugura fore ga moi yakuyaine. ");
INSERT INTO kqc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma murori amedo amiye bi ini fafau varuka moigi ga dairiyaine. ");
INSERT INTO kqc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Idu mirona ituari mina vegu no vata nigori, nono kaere bi rivo nufa ma nono ini mida susu irido ina fafau bi no iniye iniye! ");
INSERT INTO kqc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Idu usa usa nifo kumo mina ori dina meda bi avari o Sabati medari ogau ga niyaine! ");
INSERT INTO kqc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Adina mirona medari bi no tora gade iniye, kono riyo di ini adinari gutuna baeyo ma gua mina kana bi koina, gabi rofu di mina kana bi dudusa ogau de nigo. ");
INSERT INTO kqc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ye Sei yaku mina vegu no di ari de moi tumu reyagadu, amiye yokoi moi vegu de riyagadu, idu ini auba reyo vene dada mina ari moi tumu rego. ");
INSERT INTO kqc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mina resi, amiye yokoi yaku ya nigo vonisi, ‘Ve kumo, Keriso bi yomini!’ o ‘Ina bi mini!’—ini ago rofu mokena vari gira ga aefa. ");
INSERT INTO kqc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ini adina bi, keriso ofa vene ma Sei di ago nidedi ofa vene ogau nisi rebe tora tora ma mokena vegu dudu, Sei di auba reyo vene ka ofa dudu eru regedi, vata nigo vonisi bi. ");
INSERT INTO kqc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Neidefo! Na bi ari dobau sena ya niyaka. ");
INSERT INTO kqc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ye, amiye yaku ya nigedi, ‘Vefa, ina bi gagani autu sanari amedo!’—mironari ga nefa; o nigedi, ‘Vefa, ina bi sui nina sana daiyuturi amedo!’—ini ago rofu mokena vari gira ga aefa. ");
INSERT INTO kqc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Idu Amiye di mida bi sui dudu de dego. Adina ini dena bi ayena yaku kamanika redori meda dadido eta rofu vabara ni bodo meda nedo eta rofu kana. ");
INSERT INTO kqc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Muyena roaita amedo sanari bi gayo bora ka mina sanari egogo regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ye mirona ari ini toe nigo mamo, gabi evade meda bi mukuna nigo, ma eyo bi ini vabara de kikigo, iya bi omari gutuna yarei degedi, ma omari ini vava amededi mina ka moi tururu regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mina usi Amiye di mida di rebe omari ogau nigo; ma Amiye di mida oma di seuya odoro vava ma vabara tora nufa debigori, gagani gagani di vene tau yaku ina vegasa isaka nigedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma kibi kukuroka tora dudu ini naivo naivo vima nifeidego, ma ini auba reyo vene kono tora noibanu gutuna oma berou berou noibanuri moi egogo regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gua fuka yabo rofu mokefa. Ini bobo ruika fiu nisi iye imu regori, ya bi diba nigedi amona bi bae negau nido. ");
INSERT INTO kqc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mina dada, mina vegu tau gade ogau nibigedi ma vegediri, bi ya ya diba ari bi negau nigi redo. ");
INSERT INTO kqc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rama ya nida, gua ari amededi vene bi muyei vau rena koderi bogo mina beika baika tau gade vata nigedi mamo. ");
INSERT INTO kqc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Oma ma kono bi roro nigedi, idu nai ago bi roro de nigo. ");
INSERT INTO kqc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Idu amiye yokoi mirona meda ma meda nemoko bi ina toto—oma di naivo naivo vima ka ina toto, Mida ka ina toto, idu Baba iniye maka ina diba. ");
INSERT INTO kqc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Adina Noah di medari reyadi kana, Amiye di mida dena medari ka makai regedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Adina mina medari abata dena koderi bi amiye iruku ma koru irigasa rumana ma rema megasa rei bogamadi, boyo Noah sisima ideri dui reyo mina medari mamo; ");
INSERT INTO kqc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ye vei mama de reyadi beika vata niyo bi, boyo abata yaku desi ina tau vakoi moi diyo mamo. Mina bi Amiye di mida degori ini gokai vata nigo. ");
INSERT INTO kqc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mirona ituari amiye remanu murori moimai rebigedi; yokoi bi moi etagae risi yokoi bi ferego. ");
INSERT INTO kqc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rema remanu witi utei rena yavari fore dudu witi utei rebigedi; yokoi bi moi etagae risi yokoi bi ferego. ");
INSERT INTO kqc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mina dada toro dudu amefo, ini adina ya ya toto beika medari yi Varika amiye dego. ");
INSERT INTO kqc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Idu ya ya diba nifa, yava biyaguna amiye siko diba nigo vonisi duma amiye baego meda nemoko bi, ina bi varena de rego ini yava ideri ga baeyainedi. ");
INSERT INTO kqc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mina ye, ya ka toro dudu amefa, adina Amiye di mida bi mokena de rededi meda nemokori dego. ");
INSERT INTO kqc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ye kaere bi vegu rama resi mokena tora nufa moimai rei tavoi redo amiye ini varika amiye yaku vava maro, ini yava nari regi moimai rei tavoi rededi vene di iruku ini meda ramari rau rego. ");
INSERT INTO kqc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ini varika amiye yaku dairisi baku rego mina vegu regasa amebigori, bi mina moimai rei tavoi redo amiye bi ada iniye rego! ");
INSERT INTO kqc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rama ya nida, bi vava mago, dada ini beika baika tau nari rego. ");
INSERT INTO kqc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Idu mina moimai rei tavoi redo amiye no bi iniye rofu mokesi nigo, ‘Nai varika amiye bi ari dobari dairigo.’ ");
INSERT INTO kqc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kamini ini moimai rei tavoi rededi vene ugi kora resi iruku irigasa koru gira tau gade irina venesa moiga amebigori ");
INSERT INTO kqc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ini mokena de redo ariri ma meda nemoko ina toto, ini varika amiye dairisi ");
INSERT INTO kqc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","mina moimai rei tavoi redo amiye di roaita nugai tumu tumu resi ofarosi vene di sanari aego. Mina sanari isaka nisi gade giko nibigo. ");
INSERT INTO kqc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kamini Sei di ourefeidena amena sana omari bi rema ofi 10 kaere bi ini keroko moisi rema mego amiye baku regika neyadi mina kana. ");
INSERT INTO kqc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ye 5 bi mokena keika rema vene, ma 5 bi mokena tora rema vene. ");
INSERT INTO kqc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Adina mokena keika rema vene ini keroko moiyadiri, bi diga yokoi inasa de moiyadi, ");
INSERT INTO kqc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","idu mokena tora rema vene bi ini keroko ma siua diga nufa ka moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ye rema mego amiye bi evade de baeyo dada, ina tau vakoi ne ota resi vareyadi. ");
INSERT INTO kqc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Urusa tobou niyori, amiye yokoi raka niyo, ‘Rema mego amiye bi mini! Ina baku regika defa!’ ");
INSERT INTO kqc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kamini rema vene dadisi ini keroko dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Idu ada de rema vene yaku mokena tora rema vene rofu niyadi, ‘Yi diga be una mafa, uni keroko bi vai tutumui didedi dada.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Idu mokena tora rema vene nikabai resi niyadi, ‘Ide, yasa rau rena bi toaini maka, ye ya bi sero rededi vene rofu disi voi refa.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kamini diga voi regi diyadi usi, rema mego amiye okiyo. Ye mina dogo reyadi rema vene yaku inasa mena irakuna yavari dui reyadi ma ida biri riyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mina usi mokena keika rema vene ka baesi niyadi, ‘Varika amiye, ida vena una rofu moi eke!’ ");
INSERT INTO kqc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Idu nikabai resi niyo, ‘Rama ya nida, na na toto ya.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Mina dada nari refa, adina ya ya toto mina meda o mina meda nemoko bi. ");
INSERT INTO kqc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Adina Sei di ourefeidena amena sana omari bi amiye yokoi yava ika oto dina kana, kaere bi ini moimai rei tavoi rededi vene raka nisi ini gugura nari regika maro. ");
INSERT INTO kqc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yokoi bi talent 5 masi yokoi bi talent remanu masi yokoi bi talent yokoi maka maro, ini gokai moimai rededi ida dudu. Mina usi feresi diyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amiye kaere 5 yaku moiyo bi besa tau niyaine sanari aeyo, ye 5 dudusa moiyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma amiye kaere remanu moiyo ka ouresi amiye yaku reyo kana resi remanu fafau moiyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Idu amiye kaere yokoi maka moiyo bi moi desi kono goesi ini varika amiye di fore sui rigika guri aeyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ari doba tora niyori, mina moimai rei tavoi rededi vene di varika amiye okisi ini fore moiyadi mina moi rorobo rigi reyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ye talent 5 moiyo amiye yaku bi okisi besa 5 moi baesi niyo, ‘Varika amiye, ya bi talent 5 na maro; ve na bi 5 fafau dudusa riyaka.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma niyo, ‘Rei mona reyo; ya bi nai vana rama moimai rei tavoi reisa amiye buni! Beika keika ya maraka bi nari rei mona reyo dada, beika tau nari reyainedi ya magida. Baesi yi varika amiyesa ada regasa amebi!’ ");
INSERT INTO kqc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma remanu moiyo amiye ka baesi niyo, ‘Varika amiye, ya yaku remanu na maro; bi dudusa remanu riyaka mini.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma niyo, ‘Rei mona reyo; ya bi nai vana rama moimai rei tavoi reisa amiye buni! Beika keika ya maraka bi nari rei mona reyo mini; na yaku beika tau ourefeideyainedi ya magida. Baesi yi varika amiyesa ada regasa amebi!’ ");
INSERT INTO kqc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mina usi yokoi maka moiyo amiye ka baesi niyo, ‘Varika amiye, na na diba ya bi amiye gira; varina de reyo sanari goe goe reisa ma yo makuna de reyo mina iruku butu reisa. ");
INSERT INTO kqc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mina ori resi moi desi kono goesi sui rigika guri aeyaka. Ye yi bi yomini.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Idu nikabai resi niyo, ‘Ya bi amei tavoi resi moimai rei tavoi reisa amiye no! Ye ya ya diba niyo na bi varina de reyaka sanari goe goe reida ma yo makuna de reyaka mina iruku butu reida. ");
INSERT INTO kqc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Makai bi, nai fore bi banika vene di vanari moi aeyagadu ma na dairi baeyagaduri, bi dudusa bae moiyagadu, banika yaku fore keika fafau aeyagadu minasa. ");
INSERT INTO kqc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mina dada ini talent yokoi maka moisi 10 nufa amiye rofu mafa. ");
INSERT INTO kqc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Adina kaere ini beika baika nufa bi besa tau gade moi tanu mago. Idu kaere ina bi de iniye iniye nufa, ka ina rofu keika iniye amedo bi moi dairigo. ");
INSERT INTO kqc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ye mina amei tavoi rena moimai rei tavoi redo amiye bi etofaro mukunari maku nefa; mironari bi isaka nina ma gade giko nina sana.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ma Amiye di mida ini naivo naivo vima tausa ini vabara nufa degori, ina bi ini vabara di ourefeidena amena fata fafau ameinu rego. ");
INSERT INTO kqc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gagani gagani vene tau bi ini budari moi egogo regedi, ma ina yaku mina amiye moi berou berou aego, mamoe dogo amiye yaku mamoe ma gouti redo kana. ");
INSERT INTO kqc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ye mamoe ini vana rama rofu aego ma gouti ini vana enana rofu aego. ");
INSERT INTO kqc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mina usi Kini yaku ini vana rama vene rofu nigo, ‘Baefa, nai Baba yaku buni tora gade ya vene ya maro; Sei di ourefeidena amena sana di gugura moifa, goina bi oma ma kono rigamori ya dogo reyo. ");
INSERT INTO kqc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ini adina rauna reyakari, iruku na maro ma iriyaka, koru vaiyakari, koru na maro ma iriyaka; yava ika amiye kana okiyakari, na moi dui reyo, ");
INSERT INTO kqc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","faisara niyakari, varuka na maro; gauka reyakari, na egoru reyo, diburari ameyakari, baesi na veyo.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kamini mokena rorobo vene yaku nikabai resi nigedi, ‘Varika amiye, goivaka rauna reyo ma ya vesi iruku ya marafa, o koru vaiyo ma koru ya marafa? ");
INSERT INTO kqc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Goivaka yava ika amiye kana okiyo ma ya vesi moi dui reyafa, o faisara niyo ma varuka ya marafa? ");
INSERT INTO kqc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma goivaka gauka reyo ma ya veyafa o dibura ameyo ma ya vegi dui reyafa?’ ");
INSERT INTO kqc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ye Kini yaku nikabai rego, ‘Rama iniye ya nida, nai usika ourena yokoi roka de amiye rofu reyadi kana, ya bi na rofu reyadi mini!’ ");
INSERT INTO kqc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mina usi ini vana enana vene rofu nigo, ‘Na rofu etagae rifa, ya kaere Sei bi nikiraini reyo; Bodaka ma ini naivo naivo vima rofu dogo reyo di toga toga vaido ita mokari nefa! ");
INSERT INTO kqc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ini adina rauna reyakari, iruku be de na maradi, koru vaiyakari, koru be de na maradi; ");
INSERT INTO kqc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","yava ika amiye kana okiyakari, de na moi dui reyadi, faisara niyakari, varuka be de na maradi; gaukari ma diburari ameyakari, de na egoru reyadi.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kamini ina vene ka nikabai resi nigedi, ‘Varika amiye, goivaka rauna reyo, o koru vaiyo, o yava ika amiye kana, o faisara niyo, o gauka, o diburari ameyo ma vesi de ya moi aedeyafa?’ ");
INSERT INTO kqc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma nikabai rego, ‘Rama iniye ya nida, nai usika ourena yokoi roka de amiye rofu de reyadi kana, ya bi na rofu de reyadi.’ ");
INSERT INTO kqc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ye mina vene toga toga esika moina sanari digedi, idu mokena rorobo vene bi toga toga ameibobina vegu di sanari digedi.” ");
INSERT INTO kqc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu mina sina tau ni vau reyori, ini usi dina vene rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ya ya diba meda remanu usi bi Ferei ebu rena irakuna vata nigo, ma Amiye di mida bi satauro ikoko regedi vene di vanari aegedi.” ");
INSERT INTO kqc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kamini Sei ma amiye utari naivo vene di varika vene ma tora vene bi Sei ma amiye utari naivo vene di tora di ourefeidena yava torari egogo reyadi. Ini roka bi Caiaphas. ");
INSERT INTO kqc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma Iesu sui dudu moi gira resi umuyegika di sina iniye iniye nidodi resi ");
INSERT INTO kqc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","niyadi, “Idu mina irakuna fuofuori bi de regifa, adina bi amiye siboroka regedi baebu.” ");
INSERT INTO kqc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma Iesu bi Bethany ri sena refera nufa amiye roka Simon di yavari amegamori, ");
INSERT INTO kqc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","rema yokoi fore roka alabaster dudu riyadi siua yokoi, ideri bi sisika buni diga moi vata baeyo, mina moi boyo. Diga bi fore tora gade dudu voi rededi. Iesu amegasa iruku irigamo ma mina rema yaku ini adari erausi reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Idu ini usi dina vene mina vegasa gubuyo resi niyadi, “Beika resi mina maku tavoi reyo? ");
INSERT INTO kqc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ini adina bi fore tora dudu voi resi fore bi irava vene maragadu!” ");
INSERT INTO kqc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Idu Iesu bi beika nidedi veifateyo, dada niyo, “Beika resi mina rema rofu toe madedi? Adina na rofu vegu buni vayavaya reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Adina irava vene bi yasa toga ameibobigedi, idu na bi toga yasa de ameibobigida. ");
INSERT INTO kqc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ina yaku diga di sisika buni nai roaitari erausi reyo, bi na guri aegedi dada na dogo reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rama ya nida, kono tora noibanuri, bi mina ago buni nirausi regediri, ka mina rema yaku ini beika reyo mina oteimagedi, ina ka mokeyagane.” ");
INSERT INTO kqc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mina usi ini usi dina vene 12 yokoi—ini roka bi Judas Iscariot—Sei ma amiye utari naivo vene di varika vene rofu bosi ");
INSERT INTO kqc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nikaiteyo, “Iesu yi vanari aegida vonisi, bi beika na magedi?” Fore siriva 30 duaiya resi maradi. ");
INSERT INTO kqc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ye minari maka Judas gokai siri rego di ida maina regi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ye ouresi medari Beredi yeast de* di irakunari, Iesu di usi dina vene yaku okisi nikaiteyadi, “Yi ura bi goina sanari Ferei ebu rena irakuna di iruku ya rofu dogo regifa?” ");
INSERT INTO kqc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma nikabai reyo, “Taoni ideri bosi mironari amiye yokoi oteimafo, ‘Oteimana amiye yaku niyo, Nai meda nemoko bi okiyo; nai usi dina venesa yi yavari Ferei ebu rena irakuna di iruku irigifa’ vo nifa.” ");
INSERT INTO kqc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ma gokai ago gira maro kana resi Ferei ebu rena irakuna di iruku dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kamini uriyenau niyori, Iesu bi ini usi dina vene 12 sa iruku irina sanari ameinu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Iruku irigamadiri, Iesu yaku niyo, “Rama ya nida, ya yokoi yaku na siri rego.” ");
INSERT INTO kqc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma iriyeduka tora resi yokoi yokoi nigi kora reyadi, “Varika amiye, rama na bi de ba?” ");
INSERT INTO kqc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma nikabai reyo, “Mina amiye kaere bi nasa ini beredi siua ideri birisifa bi na siri rego. ");
INSERT INTO kqc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Adina Amiye di mida bi muyego, bura reyadi kana, idu mina amiye rofu bi iriyeduka no iniye, kaere bi Amiye di mida siri rego! Buni bi mina amiye vata de niyagadu.” ");
INSERT INTO kqc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mina usi Judas, kaere siri rego, yaku niyo, “Oteimana amiye, rama na bi de ba?” Nikabai reyo, “Ya kaya nisa mini.” ");
INSERT INTO kqc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kamini iruku irigamadiri, Iesu bi beredi be moisi Sei rofu buni tora gade masi uroki resi ini usi dina vene magasa niyo, “Moisi irifa; mina bi nai roaita.” ");
INSERT INTO kqc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Resi biyo moisi Sei rofu buni tora gade masi ina vene magasa niyo, “Ya tau vakoi minari irifo; ");
INSERT INTO kqc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","adina mina bi nai dava Sei di uka ago regi amiye tau gade rofu vegu no koite makugika rausi reyaka. ");
INSERT INTO kqc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ye ya nida, na bi dudusa mina waini de irigida bogo mirona medari nai Baba di ourefeidena amena sanari yasa waini ruaka irigida mamo.” ");
INSERT INTO kqc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kamini yauta nisi yakusi Olive yabo omuna ikari boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mina usi Iesu yaku ina vene rofu niyo, “Gua mina urusari, na dada ya tau vakoi na feresi ori digedi, adina bi bura reyo, ‘Mamoe dogo redo amiye umuyegida ma mamoe tau bi rerevaida nigedi.’ ");
INSERT INTO kqc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Idu dadi rae resi na siko Galilee ri ourei bogida.” ");
INSERT INTO kqc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Idu Peter nikabai resi niyo, “Mina tau ya feresi ori digedi, idu na bi toga de ya feresi ori digida!” ");
INSERT INTO kqc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma nikabai reyo, “Rama ya nida, kokoro gua mina urusari raka nina koderi, bi uru regode na nisui regiya.” ");
INSERT INTO kqc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Idu Peter yaku niyo, “Yasa ka muyegida vonisi, bi ida yokoi dudu ya nisui de regida!” Ma ini usi dina vene tau gade bi makai ka niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mina usi Iesu ini usi dina venesa gagani roka Gethsemane ri bosi niyo, “Na yomironari bosi usa usa nigida, ye ya minari amefa.” ");
INSERT INTO kqc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Resi bi Peter ma Zebedee di mida remanu inasa afesi uka vorivori resi uka moigi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mina usi niyo, “Iriyeduka tora yaku nai vima vata baeyo, ye makai muyegida kana amuteida. Minari nasa amesi varena ga refa.” ");
INSERT INTO kqc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kamini inaike etagae risi ini seira konori raudai regasa usa usa niyo, “Nai Baba, ya rofu buni vonisi, mina esika esika di biyo bi na rofu moi etagae ri. Idu yi ura mina resi nai ura bi ga regiya.” ");
INSERT INTO kqc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kamini ini usi dina vene rofu dairisi veitao reyo ina bi varegamadi. Ma Peter rofu niyo, “Ye ya vene bi meda nemoko yokoi maka nasa ne arega amegedi ba ide? ");
INSERT INTO kqc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ne aregasa usa usa nifa kumo yi uka maina regika nivego baebu. Vima bi regi ura redo, idu roaita bi afi niyo.” ");
INSERT INTO kqc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Resi dudusa uru remanu etagae risi usa usa niyo, “Nai Baba, mina esika esika di biyo na rofu moi etagae rina bi de vonisi, bi mina biyori irigida, ye yi ura bi vata niyaine.” ");
INSERT INTO kqc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kamini dairi okisi bi dudusa varegamadi veitao reyo, adina varei muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ye dudusa ferei bosi ouresi usa usa nigamo kana dudusa usa usa niyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mina usi ini usi dina vene rofu dairisi niyo, “Ya bi besa sifere regasa varededi ba? Vefo, meda nemoko bi okiyo, ma Amiye di mida bi siri resi vegu no rena vene di vanari aegedi. ");
INSERT INTO kqc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dadifo! Una bi dinadi! Ve nai siri rena amiye bi baedo mini!” ");
INSERT INTO kqc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu ago nigamori, Judas, kaere bi amiye 12 ri yokoi, amiye tau gade gadesa bainasi ma gai nufa okiyadi; Sei ma amiye utari naivo vene di varika vene ma amiye di tora vene yaku nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kamini siri rego amiye yaku gokai rego di ida bi sena masi niyo: “Kaere amiye fuka regida bi mini; moi gira refa!” ");
INSERT INTO kqc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ye evade Iesu urana bosi niyo, “Oteimana amiye, ya mini ba?” Resi fuka reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma nikabai reyo, “Dubu, beika regika baeyo bi re!” Mina usi amiye baesi Iesu vanau moisi moi gira reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma yokoi kaere bi inasa yaku ini bainasi moi yakusi kuita resi Sei ma amiye utari naivo amiye tora di moimai rei tavoi redo amiye di anema nugai feideyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mina usi Iesu yaku niyo, “Yi bainasi moiyo sanari moi dairisi ae, adina kaere vene tau gade bainasi dudu ruda rededi, bi bainasi dudu muyegedi. ");
INSERT INTO kqc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ya yaku mokeisa bi nai Baba raka nigi anua reida ma naivo naivo vima tau gade gade ruda omana vene 12 kana besa nifeideyaine ma na aedegedi ba? ");
INSERT INTO kqc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Idu makai regidari, Sei di ago bi gokai rama aego, ini niyo kana mina tau bi makai dudu vata niyaine?” ");
INSERT INTO kqc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mina ituari Iesu yaku amiye tau gade rofu niyo, “Ya bi duma duma amiye yokoi kana bi bainasi ma gai moisi na moi gira regika baeyadi ba? Ari neinei Sei nivakena yavari ameinu resi oteimagamaka, idu de na moi gira reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Idu mina beika tau bi vata niyadi, ye beika Sei di ago niyadi vene yaku bura reyadi bi bae rama aeyainedi.” Mina usi ini usi dina vene tau vakoi bi feresi ori diyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kamini Iesu moi gira reyadi vene bi Caiaphas rofu afei boyadi, kaere bi Sei ma amiye utari naivo amiye tora. Mironari ago gira oteimana vene ma tora vene egogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Peter bi beika vata nigo mina vegika egaima risi usi disi Sei ma amiye utari naivo amiye tora di yava ida nefau dui resi nari rededi venesa ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kamini Sei ma amiye utari naivo vene di varika vene ma kanisoro vene noibanu bi ofa ago di adina maina regamadi gokai dudu Iesu umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amiye tau gade bi ofa ofa dudu nikake rigamadi, idu ago de baku reyadi. Gabi amiye remanu baesi ");
INSERT INTO kqc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","niyadi, “Mina amiye niyo bi, ‘Na yaku Sei nivakena yava ukero vau resi meda regodenuri dudusa akugida,’ vo niyo.” ");
INSERT INTO kqc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kamini Sei ma amiye utari naivo amiye tora yaku dadisi niyo, “Ya bi nikabai de regiya ba? Mina ago ya rofu nikake rededi, bi beika be nigiya?” ");
INSERT INTO kqc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Idu Iesu bi bere niyo ma Sei ma amiye utari naivo amiye tora yaku niyo, “Toga amedo Sei di roka dudu ya nida ya gua ofa ofa de nigiya: una ni ya bi Keriso, Sei di mida ba?” ");
INSERT INTO kqc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma nikabai reyo, “Ya yaku niyo kana. Idu ya nida: Gua gutuna bi Amiye di mida Vava iniye amiye di vana rama rofu ameinu resi oma di seuya odoro debigo ma vegedi!” ");
INSERT INTO kqc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mina usi Sei ma amiye utari naivo amiye tora yaku ini fafau varuka uesi resi niyo, “Ina bi Sei di roka moi no riyo! Beika resi nisi una bi mina ago di adina besa ni maina resifa? Vefa, ya gua mina Sei di roka moi no riyo ago neideyadi! ");
INSERT INTO kqc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ye ya mokededi bi gokai?” Ma nikabai reyadi, “Ina muyego bi buni.” ");
INSERT INTO kqc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mina usi ini seirari ayaka su resi vana kumu risi uyadi. Bedakai bi famasi ");
INSERT INTO kqc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","niyadi, “Keriso, ya bi Sei di ago nido amiye vonisi, kaere amiye yaku ya ugo ini roka una rofu ni!” ");
INSERT INTO kqc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Peter bi etofaro yava ida nefauri amegamo ma naivo rema ofi yokoi baesi niyo, “Ya ka Iesu Galilee amiyesa digamo.” ");
INSERT INTO kqc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Idu amiye tau gade di nemokori nisui resi niyo, “Na na toto ya beika nisa.” ");
INSERT INTO kqc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Resi ida vena urana neyo ma naivo rema ofi yokoi yaku vesi atafuri are regamadi vene rofu niyo, “Mina amiye bi Iesu Nazareth amiyesa digamo.” ");
INSERT INTO kqc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dudusa nisui resi nivarika resi niyo, “Na na toto mina amiye!” ");
INSERT INTO kqc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma doba deri, atafuri are regamadi vene bi niyadi, “Rama ya ka ini asini, adina yi gokai sina ago reisa yaku ya moi ogau rido!” ");
INSERT INTO kqc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mina usi iniye fafau nikiraini resi iniye nivarika regi kora resi niyo, “Na na toto mina amiye!” Ma evade kokoro raka niyo, ");
INSERT INTO kqc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ma Peter yaku Iesu beika vata nigo di ago niyo mina mokeyo: “Kokoro raka nina koderi, uru regode na nisui regiya.” Ye etofaro yakusi isaka no iniye iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Uriyaku gorogoro Sei ma amiye utari naivo vene di varika vene ma tora vene tau vakoi egogo resi nirorotari reyadi Iesu bi umuyeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ye ini vana ukita resi afei bosi Gavana Pilate di vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kamini Judas, kaere bi siri reyo amiye, yaku veyo bi Iesu kota resi umuyegedi, ye beika reyo fafau iriyeduka resi mina siriva fore 30 moi dairisi Sei ma amiye utari naivo vene di varika vene ma amiye di tora vene masi ");
INSERT INTO kqc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","niyo, “Na bi vegu no reyaka, adina vegu buni no yokoi de amiye siri reyaka ma umuyegedi!” Nikabai reyadi, “Una yaku beika regifa? Mina bi yi vanari!” ");
INSERT INTO kqc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ye Judas yaku mina fore Sei nivakena yava ideri maku feresi diyo. Mina usi disi iniye ini bauye misi uai reyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Idu Sei ma amiye utari naivo vene di varika vene yaku mina fore moisi niyadi, “Mina bi siri rena fore, mina resi Sei nivakena yava di foresa bi de aegifa, uni ago gira yaku niyo kana.” ");
INSERT INTO kqc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ye egogo resi nirorotari resi okina vene guri aebigika urena rido amiye di kono tu mina fore dudu voi reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mina resi gua mina kono kefuka bi “Dava di nomu” toga vo nidedi. ");
INSERT INTO kqc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mina usi beika Sei di ago niyo amiye Jeremiah yaku niyo bi bae rama aeyo: “Ye siriva fore 30 moiyadi; mina bi Israel vene be yaku ini davana reyadi kana. ");
INSERT INTO kqc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma urena rido amiye di kono kefuka mina fore dudu voi reyadi, Varika amiye di ago gira na rofu niyo kana.” ");
INSERT INTO kqc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kamini Iesu bi gavana di nemokori are reyo ma nikaitegasa niyo, “Ya bi Jew vene di kini ba?” Ma nikabai reyo, “Ya bi mina niyo.” ");
INSERT INTO kqc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Idu Sei ma amiye utari naivo vene di varika vene ma tora vene nitourage reyadiri, bi ago yokoi be nikabai de reyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mina usi Pilate yaku nikaiteyo, “Ya bi gokaisanu ago no tau ya rofu nitourage rededi bi neideisa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Idu ago yokoi kava nikabai de reyo, ye gavana bi tururu iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ye Ferei ebu rena irakuna neineiri ini toutou dudu, gavana bi amiye tau rofu ini ura kana dibura amiye yokoi erufuyaine nigamo. ");
INSERT INTO kqc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mirona ituari, dibura amiye no yokoi kaere bi amiye tau ina diba ini roka bi Iesu Barabbas. ");
INSERT INTO kqc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ye amiye tau egogo reyadiri, Pilate yaku nikaiteyo, “Goina bi ya rofu erufugida ma digo? Iesu Barabbas ba Iesu kaere bi Keriso vo nidedi?” ");
INSERT INTO kqc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Adina Pilate bi sena diba niyo bi gonema dudu ini vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kamini bi ini kota rena fata ameinu reyori, ini rema yaku ago nifeideyo: “Mina mokena rorobo amiye rofu bi beika yokoi ina rofu ga re. Adina na bi gua yaduka veyakari, nai mokena yaku esika esika na maro ina dada.” ");
INSERT INTO kqc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Idu Sei ma amiye utari naivo vene di varika vene ma tora vene bi amiye tau gade niguba reyadi Barabbas bi erufuyainedi, idu Iesu bi umuyeyainedi usa niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ye gavana nikaiteyo, “Mina amiye remanuri, yi ura bi goina ya rofu erufugida ma digo?” Ma nikabai reyadi, “Barabbas!” ");
INSERT INTO kqc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma nikaiteyo, “Mina dada bi beika Iesu, Keriso vo nidedi, ina rofu regida?” Ina tau vakoi yaku niyadi, “Ina bi satauro ikoko reyaine!” ");
INSERT INTO kqc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Idu nikaiteyo, “Beika resi, ina bi beika vegu no be reyo?” Idu besa imuna niyadi, “Ina bi satauro ikoko reyaine!” ");
INSERT INTO kqc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kamini veyo beika yokoi de rego ma siboroka regi kora reyadiri, koru moisi amiye tau di nemokori ini vana koitesi niyo, “Mina amiye di muyena bi nai vanari de; mina bi yi vanari amedo!” ");
INSERT INTO kqc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ye amiye tau yaku nikabai reyadi, “Ini dava rausi rego bi una ma uni mida mida ni-ikigedi!” ");
INSERT INTO kqc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mina usi ina vene rofu Barabbas erufuyo; idu ago gira maro ma Iesu buburu vai reyadi ma satauro ikoko reyaganedi iya rededi vene di vanari aeyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mina usi gavana di iya rededi vene gavana di ourefeidena yava tora ideri afei bosi iya rededi vene tau vakoi raka niegogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Resi ini varuka kutusi bou varuka kaka doba aku masi ");
INSERT INTO kqc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","yabo imiye maena moi mekuna resi kini kana ada bou ini adari aesi kodu moisi ini vana rama rofu aeyadi; resi ini budari efuka meimisi nikurugasa niyadi, “Jew vene di kini o!” ");
INSERT INTO kqc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Resi ina fafau ayaka su resi kodu moisi ini adari ugamadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kamini nikuruyadi koina niyori, bi varuka kaka doba kutusi iniye di varuka aku masi satauro ikoko regi afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ye yakugasa bi Cyrene gagani amiye yokoi roka Simon baku resi bi ini satauro uakaiyaine niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gagani roka Golgotha (ini adina bi “Ada girika di sana”) okisi ");
INSERT INTO kqc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","waini ma koru rusa iriyainedi maradi ma iri veyo, idu irina ura de reyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ma kamini satauro ikoko resi laki dudu isira reyadi ini varuka ini yokoi yokoi moisi ");
INSERT INTO kqc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ameinu resi nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ini ada odoro bi ini no nikake regi bi yomakai bura reyadi: “Mina bi Iesu, Jew vene di kini.” ");
INSERT INTO kqc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mina usi duma duma amiye remanu inasa satauro ikoko reyadi, yokoi bi ini vana rama rofu ma yokoi bi ini vana enana rofu. ");
INSERT INTO kqc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ye amiye kaere ini budari digamadi, bi nifafana regasa ini ada buro regasa ");
INSERT INTO kqc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nigamadi, “Ya yaku Sei nivakena yava ukero vau resi meda regodenuri dudusa akugiya vo niyo, ya kaya moi vegu ri! Ya Sei di mida vonisi, bi satauro gutuna soka rei de!” ");
INSERT INTO kqc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mina ida yokoi makari Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana venesa ma tora vene ka nikurugasa nigamadi: ");
INSERT INTO kqc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Amiye be bi moi vegu riyo, idu iniye bi makai regi anua rego! Ina bi Israel di kini; satauro gutuna soka rei dego mamo ina rofu mokena vari gira aegifa! ");
INSERT INTO kqc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sei rofu mokena vari gira aedo; ferefo kumo Sei ina ura redo vonisi, bi gua moi vegu rigo. Adina ina yaku niyo, ‘Na bi Sei di mida!’” ");
INSERT INTO kqc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma duma duma amiye kaere bi inasa satauro ikoko reyadi ka nifafana reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Meda nemoko tobo niyori, gagani tora noibanu bi mukuna yaku fono reyo boyo meda nemoko regodenu koina niyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma meda nemoko regode kanari Iesu bi ababa nigasa raka ni tora reyo, “Eli, Eli, lema sabachthani?” Mina di adina bi, “Nai Sei o, beika resi na ferei tavoi reyo?” ");
INSERT INTO kqc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kamini amiye be kaere bi ina atafu are regamadi mina neidesi niyadi, “Ina bi Elijah raka nido!” ");
INSERT INTO kqc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kamini amiye yokoi evade raga resi sipanisi moisi waini ru dudu moi vata baesi koduri aesi ina rofu iriyainedi maro. ");
INSERT INTO kqc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Idu be vene yaku niyadi, “Kode, venadi kumo Elijah desi moi vegu rigo ba ide!” ");
INSERT INTO kqc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma goroka tora dudu raka nisi ini vima maro. ");
INSERT INTO kqc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kamini Sei nivakena yava ideri biri rina varuka doba bi odoro gutuna doka rofu uesi rei nesi sireta remanu niyo ma kono yagayaga resi rabema okuyadi, ");
INSERT INTO kqc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","guri sana okuyadi ma Sei di vene tau sena muyeyadi mina dudusa dadi rae reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma Iesu di dadi rae rena usi, mina dadi rae reyadi vene mina guri feresi taoni kikifari boyadi ma amiye tau yaku veyadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma iya rededi vene di ourefeidena amiye tora ma kaere amiye inasa Iesu nari regamadi, bi kono yagayaga reyo ma beika tau vata niyadi mina vesi ori tora resi niyadi, “Rama mina bi Sei di mida!” ");
INSERT INTO kqc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma rema tau mironari ka gaima gutuna are resi vegamadi, kaere bi Galilee gutuna Iesu usi baegasa moi aedegamadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ini fogori bi Mary Magdalene, Mary, James ma Joseph di nono, ma Zebedee di mida mida di nono. ");
INSERT INTO kqc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uriyenau niyori, Arimathea gugura tau amiye yokoi ini roka bi Joseph okiyo; ina ka bi Iesu di usi dina amiye yokoi. ");
INSERT INTO kqc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilate rofu bosi Iesu di roaita moigika usa niyo, ye maraganedi ago maro. ");
INSERT INTO kqc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kamini Joseph ini roaita moisi varuka buni ruaka dudu kumu risi ");
INSERT INTO kqc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","iniye di guri ruaka fore ideri goeyadi bi ini roaita mina ideri aeyo. Kamini fore tora moi kurevai resi guri di ida vena biri risi ferei diyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Mary Magdalene ma Mary yokoi bi guri berou eta rofu amegamadi. ");
INSERT INTO kqc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dogo dogo rena meda usi ariri Sei ma amiye utari naivo vene di varika vene ma Pharisee vene egogo resi Pilate rofu bosi ");
INSERT INTO kqc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","niyadi, “Varika amiye, mokesifa mina ofa ofa amiye ini veguri amegasa niyo, ‘Meda regode koina nigori, na bi dudusa dadi rae regida,’ vo niyo. ");
INSERT INTO kqc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mina resi ago gira ma kumo mina guri bi nari rei mona regedi bogo meda regodenu moigo, ini usi dina vene yaku bosi ini roaita duma rei moi disi ‘Iesu bi muyena gutuna dadi rae reyo,’ mina amiye rofu nigedi baebu. Mina metonari ofa ofa sina bi ouresi kana de, idu no iniye iniye.” ");
INSERT INTO kqc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ye Pilate yaku ina vene rofu niyo, “Yi nari rena vene moi bogedi guriri yi diba dudu nari rei mona refa.” ");
INSERT INTO kqc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ye bosi guri di biri riyo fore dudu mina biri ri mona reyadi nari reyainedi amiye aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kamini Sabati meda usi ari uveyori, fura di ouresi medari, Mary Magdalene ma Mary yokoi bi guri vegika boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kamini kono yagayaga tora reyo, adina Varika amiye di naivo naivo vima yokoi oma gutuna desi guri di ida venari fore moi kurevai rei etagae risi mina fafau ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ini seira bi kamanika kana ma ini varuka bi aisi feyo kana. ");
INSERT INTO kqc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nari rena vene bi tururu resi ori yaku no nisi muyena vene kana kita de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Idu Sei di naivo naivo vima yaku rema rofu niyo, “Ori ga refa, adina na na diba ya bi Iesu maina rededi, kaere bi satauro ikoko reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ina bi minari de; adina bi dadi rae reyo, ini niyo kana. Baesi ini vareyo sana vefa. ");
INSERT INTO kqc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ye evade bosi ini usi dina vene nioteimafa, ‘Ina bi muyena gutuna dadi rae resi ina siko Galilee urana bodo; bi mironari baku regedi!’ Gua ya nida.” ");
INSERT INTO kqc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ye rema vene evade ori ma ada tora gade dudu guri sana ferei disi raga dudu ini usi dina vene nigika boyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma Iesu mina vene baku resi niyo, “Ya mini ba?” Ina rofu baesi ini yuka moi gira resi nivakeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mina usi niyo, “Ori ga refa; bosi nai usika ourena nigedi Galilee urana boyaganedi. Mironari mamo na vegedi.” ");
INSERT INTO kqc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rema vene bogamadiri, nari rena vene be bi taoniri Sei ma amiye utari naivo vene di varika vene rofu bosi beika tau vata niyadi ina rofu niyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sei ma amiye utari naivo vene di varika vene ma amiye di tora vene egogo reyadiri, nirorotari rei vau resi nari rena vene fore tora masi ");
INSERT INTO kqc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","niyadi, “Ya bi yomakai nigedi, ‘Ini usi dina vene yaku urusa vareyafari, baesi ini roaita duma resi moi diyadi,’ vo nigedi. ");
INSERT INTO kqc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma gavana yaku mina sina neidego vonisi, bi una yaku ni moi amuta regifa, ye ya bi esika de moigedi.” ");
INSERT INTO kqc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ye nari rena vene mina fore tora moisi oteimaradi kana reyadi. Ye mina sina bi boyo mina meda ramari Jew vene fogori ni baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kamini ini usi dina vene 11 bi dadisi Galilee neyadi, Iesu yaku diyaganedi vo niyo omuna ikari. ");
INSERT INTO kqc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ina veyadiri, bi nivakeyadi, idu be bi mokei itua reyadi. ");
INSERT INTO kqc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma baesi niyo, “Oma ma konori vava tau vakoi bi na maro. ");
INSERT INTO kqc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mina dada, gagani gagani vene tauri disi nai usi dina vene risi Baba di roka, ini Mida di roka ma Vima kikifa di roka dudu babatiso refa. ");
INSERT INTO kqc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma beika ago gira tau ya maraka, mina oteimagedi ma rebiyaganedi. Ma na bi yasa ari neinei bogo meda bae koina nigo di meda okigo mamo.” ");
INSERT INTO kqc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mina bi Sei di mida Iesu Keriso di ago buni yomakai kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sei di ago niyo amiye Isaiah yaku bura reyo kana: “Sei yaku makai niyo, ‘Nai ago moi raga redo amiye yi budari nifeidegida. Yi ida moi dogo rego.’ ");
INSERT INTO kqc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Amiye yokoi di goroka bi gagani autu sanari raka nido, ‘Varika amiye di ida dogo resi ini dibo ida moi rorobo rifa.’” ");
INSERT INTO kqc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma John Baptist gagani autu sanari vegu no feresi moi etagae rina ma Sei yaku ini vegu no koite makuna di babatiso di ago nirausi resi ina vene babatiso magamo. ");
INSERT INTO kqc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ye Judea gagani tora noibanu vene tau ma Jerusalem vene ina rofu baegamadi. Ye ini vegu no niogau regamadi ma Jordan koruri babatiso regamo. ");
INSERT INTO kqc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John di varuka bi kamelo di ueta ma ini gagaba ukita maena bi boromakau di ro. Ini iruku bi kaufa ma kaoro di ona. ");
INSERT INTO kqc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma nirausi resi niyo, “Na usi baego amiye ini vava yaku nai vava etei riyo, ye na bi rorobo de efuka odesi ini yuka ro di maena younegida. ");
INSERT INTO kqc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na yaku koru dudu ya babatiso reyaka, idu mina amiye bi Vima kikifa dudu ya babatiso rego.” ");
INSERT INTO kqc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mirona ituari Iesu bi Nazareth taoni Galilee gutuna baeyo ma John yaku Jordan koruri babatiso reyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu bi evade koru ideri gutuna bae iruruka resi ne reyori bi oma ekeyo ma Vima kikifa bi pune erena kana ina fafau rou reyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma goroka yokoi oma gutuna degasa niyo, “Ya bi nai uka maida mida; ada tora gade ya rofu reida.” ");
INSERT INTO kqc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ne ituari maka Vima kikifa yaku gagani autu sanari Iesu nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma gagani autu sanari meda 40 amegamori, Satani yaku vegu no reyainedi vonisi, ini uka maina regika niveyo. Ina bi tuma dona nadinasa amegamo ma Sei di naivo naivo vima yaku nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John Baptist moi gira reyadi fufuta rofu, Iesu Galilee ri nesi Sei di ago buni nirausi regamo. ");
INSERT INTO kqc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Resi niyo, “Gua bi Sei di meda, ma Sei di ourefeidena amena sana bi atafu okiyo. Yi vegu no feresi moi etagae risi ago buni rofu mokena vari gira aefa!” ");
INSERT INTO kqc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu bi Galilee moka daidai tora seriri bogasa bi Simon ini usika Andrew sa koruri fate makugamadi ma veyo, adina ina bi oyena rutu vene. ");
INSERT INTO kqc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu yaku ina vene rofu niyo, “Na usi baefa ma oyena koda rena kana amiye nirutu rena ya rigida.” ");
INSERT INTO kqc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Minari maka ini fate feresi usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Doba deri bogasa bi uba dubuisa James ma John, Zebedee di mida, veyo. Ina yaku bouti fafau fate veika regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu yaku evade uba dubuisa raka niyo ma ini baba Zebedee ma ini moimai rededi vene boutiri feresi usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu bi ini usi dina venesa Capernaum taoniri boyadi ma evade Sabati medari usa usa yava ideri dui resi amiye nioteimagi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ye ini oteimana ago rofu tururu reyadi, adina ini oteimana bi kaere vava nufa amiye kana, ma ago gira oteimana vene kana de. ");
INSERT INTO kqc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mina ituari maka, amiye yokoi vima no nufa usa usa yavari raka niyo, ");
INSERT INTO kqc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu Nazareth amiye, una rofu bi beika ura reisa? Ya bi una moi no regika okiyo ba? Na na diba ya bi kaere—ya bi Sei di Kikifa amiye!” ");
INSERT INTO kqc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma emasi niyo, “Babo nisi mina amiye rofu yakusi di!” ");
INSERT INTO kqc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma moi seko sako resi ababa nisi ini roaitari yaku diyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Amiye tau bi tururu resi iniye iniye nikaiteyadi, “Mina bi beika? Mina bi oteimana di ida ruaka yokoi mini ini vava nufa! Vima no rofu ago gira madori, neidesi anema yora nidedi!” ");
INSERT INTO kqc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kamini evade Galilee gagani tora noibanuri ini sina urafo rei diyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Usa usa yava fereyadiri, evade James ma John sa Simon ma Andrew di yavari dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ye Simon di imokai rema bi gauka resi roaita vaki vaki regasa ekamari varegamo, ma Iesu okiyori evade nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ye mina rema rofu bosi ini vana moisi moi dadiyo. Roaita vaki vaki bi fereyo ma iruku dabara resi nari regamo. ");
INSERT INTO kqc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uriyenauri meda nei tomu niyori, bi amiye yaku gauka vene tau ma vima no nufa vene tau Iesu rofu afei baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Amiye tau mina taoniri amededi vene ka mina yava ida nefau okiyadi. ");
INSERT INTO kqc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Iesu yaku gauka vene tau gade moi buni risi vima no tau gade meki reyo. Resi vima no rofu ago ga niyaganedi niyo, adina mina vima diba ina bi kaere. ");
INSERT INTO kqc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kamini uriyaku gorogoro meda youna koderi, Iesu bi dadisi feresi gagani autu sanari disi usa usa niyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ye Simon ini asiyaka venesa maina resi ");
INSERT INTO kqc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","baku resi niyadi, “Amiye tau vakoi bi ya maina rededi.” ");
INSERT INTO kqc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma nikabai reyo, “Berou rautu eta rofu boi nenadi, ma mironari na ka ago nirausi regida, adina na bi mina dada deyaka.” ");
INSERT INTO kqc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ye Galilee gagani tau vakoiri disi ini usa usa yavari ago nirausi resi vima no meki regamo. ");
INSERT INTO kqc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Refera amiye yokoi Iesu rofu okisi efuka odesi guyaguya nisi niyo, “Ya ura reisa vonisi, ya yaku na moi ruaka rigiya.” ");
INSERT INTO kqc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kamini Iesu bi iriyeduka resi ini vana moi roto risi mina amiye avaka moisi niyo, “Na yaku ura reida; ruaka ni!” ");
INSERT INTO kqc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Minari maka ini roaitari refera gauka ferei diyo ma ruaka niyo. ");
INSERT INTO kqc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ye Iesu yaku ago gira nisi evade maka nifeidesi ");
INSERT INTO kqc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","niyo, “Amiye yokoi ga nioteima, idu nesi ya kaya Sei ma amiye utari naivo amiye oteimasi yi roaita buni niyo kana ori sisika re. Ye amiye vegedi ya bi buni niyo, Moses yaku ago girari niyo kana, Sei rofu moi ori sisika regiya.” ");
INSERT INTO kqc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Idu mina amiye yaku disi mina ago nirausi regasa gagani noibanuri digamo. Iesu rofu ago tora niyadi mina resi taoni ariara ma dina bi de reyo. Ye ina bi gagani autu sanari amei digamo, idu amiye gagani gagani tau ina vegika toga okigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Meda be koina niyori, Iesu bi dudusa Capernaum taoniri dairiyo ma rautu vene bi Iesu okiyo ago mina neideyadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ye amiye tau gade egogo reyadiri, yava ida dui dui sana ka vata baeyo, ma Iesu yaku sina buni nioteimagamo. ");
INSERT INTO kqc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mina fuofuori, amiye 4 okiyadi, dibo anua amiye uakaisi Iesu urana afei baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Idu amiye tau gade dada, ina rofu moi dui regi anua reyadi. Dada Iesu amegamo sana ramari, yava tebo maka nuruyadi. Ye dibo anua amiye bi ekama fafau aesi moi feide neyadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ye Iesu mina vene di mokena vari gira aena veifategasa mina dibo anua amiye rofu niyo, “Nai mida, yi vegu no bi koite makuyaka.” ");
INSERT INTO kqc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kamini ago gira oteimana vene bedakai minari amesi ina kaya mokeyadi, ");
INSERT INTO kqc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gokai resi mina kana sina nido? Mina bi Sei di roka moi no rido! Sei maka vegu no koite makugo!” ");
INSERT INTO kqc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Evade maka Iesu yaku mina vene ina kaya di mokena bi ini ukari veifatesi ina rofu niyo, “Beika resi makai yi ukari mokededi? ");
INSERT INTO kqc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Goina ago dibo anua amiye rofu nigida bi rena gira de, ‘Yi vegu no bi koite makuyo,’ o ‘Dadisi yi maduna moisi nana re?’ ");
INSERT INTO kqc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Idu, ya vei mama regedi Amiye di mida bi vava nufa konori vegu no koite makugo.” Kamini Iesu yaku dibo anua amiye rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ya nida dadisi yi ekama vanau moisi yi yavari di!” ");
INSERT INTO kqc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ye dadisi minari maka ini ekama moisi amiye tau di nemokori yaku diyo. Ye ina tau noibanu tururu resi Sei di roka moi odoro risi niyadi, “Sena mina vegu kana bi de veyafa!” ");
INSERT INTO kqc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu bi kamini Galilee di moka daidai tora seriri dudusa dairiyori, amiye tora gade bi ina rofu okiyadi, ma oteimagi kora regamo. ");
INSERT INTO kqc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ye nana rei bogamori, Levi,* Alphaeus di mida, bi fore butu rena ofesiri amegamo ma veyo. Ina rofu niyo, “Na usi bae.” Ma dadisi usi diyo. ");
INSERT INTO kqc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gabi bi Levi di yavari iruku irigamori, fore butu rededi vene ma vegu no rededi vene tau gade okisi Iesu ini usi dina venesa ameinu resi iruku irigamadi, ini adina bi amiye tau gade usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma Iesu yaku vegu no rededi ma fore butu rededi venesa iruku irigamo ma Pharisee di ago gira oteimana vene mina vesi ini usi dina vene nikaiteyadi, “Beika resi fore butu rededi vene ma vegu no rededi venesa iruku iridedi?” ");
INSERT INTO kqc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma Iesu mina ago neidesi nikabai reyo, “Amiye buni bi gauka dogo amiye de mokegedi, idu gauka vene maka. Na bi mokena rorobo vene rofu disi raka nigi de okiyaka, idu vegu no rededi vene rofu okiyaka.” ");
INSERT INTO kqc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kamini John Baptist ma Pharisee di usi dina vene yaku iruku oyo regamadi. Amiye be okisi ina rofu nikaiteyadi, “Beika resi John Baptist ma Pharisee vene di usi dina vene bi oyo rededi, idu yi usi dina vene bi de?” ");
INSERT INTO kqc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ye Iesu yaku nikabai reyo, “Rema mego amiye yaku ini asiyaka venesa amebigori, iruku oyo regedi ba ide? Ide mada! Rema mego amiye yaku ini asiyaka venesa inasa amebigori, bi oyo de regedi. ");
INSERT INTO kqc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Idu rema mego amiye afei digedi di meda baegori, bi mirona medari oyo regedi.” ");
INSERT INTO kqc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Amiye yokoi ruaka ma koitena de varuka tu bi varuka kori fafau faniya de rego; makai regori, bi varuka ruaka moi rutu rego ma varuka kori usika regori, ruba tora nigo. ");
INSERT INTO kqc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma amiye yokoi waini ruaka moisi ini ro kori ideri de aego; makai rego vonisi, bi ini ro ufatego, ma waini ma ini ro bi no nigedi; mina dada waini ruaka bi ini ro ruaka ideri aeyaine.” ");
INSERT INTO kqc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma Sabati medari, Iesu ini usi dina venesa witi muro idari nana diyadi. Ina yaku witi di ada koma regi kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Pharisee vene ina rofu niyadi, “Neide, beika resi Sabati medari una rofu bi tabu mina rededi?” ");
INSERT INTO kqc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma ina rofu niyo, “Ya ka bura de veyadi beika David ini amiyesa yaku reyadi, mirona medari rauna reyadiri? ");
INSERT INTO kqc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ye Sei di yava ideri dui resi Sei rofu mana beredi irisi ini vene ka maro. Mina vata niyori, Abiathar bi Sei ma amiye utari naivo amiye tora. Ago gira yaku nido bi tabu Sei ma amiye utari naivo vene maka bi mina beredi irigedi.” ");
INSERT INTO kqc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kamini Iesu yaku niyo, “Sabati meda bi amiye rofu riyo; amiye bi Sabati rofu de riyo. ");
INSERT INTO kqc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mina dada Amiye di mida ka bi Sabati meda di Varika amiye.” ");
INSERT INTO kqc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kamini Iesu bi dudusa usa usa yavari dui reyo ma minari bi vana kevo amiye yokoi amegamo. ");
INSERT INTO kqc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ye vei mona regamadi Sabati medari mina amiye moi buni rigo vonisi, bi ini no dada nisi tourage regika. ");
INSERT INTO kqc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Iesu yaku mina vana kevo amiye rofu niyo, “Mina amiye tau di nemokori dadisi are re.” ");
INSERT INTO kqc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Resi nikaiteyo, “Ago gira dada beika vegu bi buni Sabati medari regedi? Vegu buni regedi, ba vegu no regedi? Amiye moi vegu rigedi, ba umuyegedi?” Idu bi bere niyadi. ");
INSERT INTO kqc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu bi gubuyo resi ina vene nene resi iriyeduka reyo, adina bi uka gira resi de neideyadi. Mina amiye rofu niyo, “Yi vana ae roto ri.” Ini vana ae roto riyori, dairi buni niyo. ");
INSERT INTO kqc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kamini Pharisee vene feresi evade Herod di eta rofu venesa sina ago Iesu umuyegi nirorotari reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ma ini usi dina venesa feresi Galilee moka daidai torari diyadi, ma amiye tau gade ina usi boyadi. Mina vene bi Galilee eta rofu baeyadi; ka Judea rofu, ");
INSERT INTO kqc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem rofu, Idumea rofu, ma Jordan koru meda dadido eta rofu, ma gagani Tyre ma Sidon mina taoni eta berou berou okiyadi. Mina amiye tau gade Iesu rofu okiyadi, ini adina bi neideyadi ini beika regamo dada. ");
INSERT INTO kqc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Amiye bi tau gade dada, Iesu ini usi dina vene niyo bouti yokoi moi dogo rei feregedi ye amiye yaku etei ri foyoma regedi baebu. ");
INSERT INTO kqc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ina bi amiye tau gade moi buni rigamo, mina dada gauka vene iniye iniye ina avaka moigi ida maina regika ebeku regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma kaere amiye vima no ini roaitari bi ina vegamadiri, bi ini budari keto resi raka nigamadi, “Ya bi Sei di mida!” ");
INSERT INTO kqc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma ago gira gira maro bi amiye ga niyagane ina bi kaere. ");
INSERT INTO kqc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kamini Iesu bi omuna odorori bosi ura redo vene raka niyo ma baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma ini vene 12 inasa ameyaganedi auba resi roka maro bi nifeidena vene. Mina bi disi ini ago nirausi reyagane dada. ");
INSERT INTO kqc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma vava maro; mina vava dudu bi vima no meki regedi. ");
INSERT INTO kqc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ye ini amiye 12 auba reyo bi mini: Simon (Iesu ini roka maro bi Peter); ");
INSERT INTO kqc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma James ini dubuini John sa, Zebedee di mida mida (Iesu ini roka maro bi Boanerges, mina ini adina bi, “Oma yaku ofu tu nido kana di mida”); ");
INSERT INTO kqc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ma Andrew, Philip, Bartholomew, Matthew, Thomas, ma Alphaeus di mida James, ma Thaddaeus, ma Simon, kaere bi zealot di amiye yokoi. ");
INSERT INTO kqc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma Judas Iscariot kaere bi Iesu siri reyo. ");
INSERT INTO kqc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kamini Iesu bi yavari dairiyo, ma rema rumana dudusa egogo reyadi; ye Iesu ini usi dina venesa ini iri-iri ari bi ebu reyo. ");
INSERT INTO kqc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesu di davatu vene yaku ini moimai regamo sina nido neideyadiri, bi dadisi neyadi beika ago nido bi ga niyainedi, adina amiye bi nigamadi, “Ina bi forovai reyo!” ");
INSERT INTO kqc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ye ago gira oteimana vene kaere bi Jerusalem gutuna deyadi, yaku nigamadi, “Beelzebul bi ini roaitari dui reyo, ye makai vima no di ourefeidena amiye di vava dudu vima no meki redo.” ");
INSERT INTO kqc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ye Iesu bi amiye raka niegogo resi mokena ago nioteimagamo. Resi yomakai ago niyo, “Gokai dudu Satani yaku iniye meki rego? ");
INSERT INTO kqc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gagani yokoi uta okusi iniye iniye berou berou are resi ruda rego vonisi, bi berou berou keto rego. ");
INSERT INTO kqc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma rubu iniye iniye uta okusi ruda rego vonisi, bi berou berou keto rego. ");
INSERT INTO kqc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ye Satani ini venesa iniye iniye berou berou are resi okusi ruda regedi vonisi, bi are rei gira de regedi. Tutumui digedi. ");
INSERT INTO kqc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Idu amiye yokoi yaku amiye yeiva di yava dui resi ini gugura fore duma regi anua rego. Makai siko bi mina amiye yeiva ukita rego kumo ini gugura fore duma rego. ");
INSERT INTO kqc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Rama iniye ya vene rofu nida, ‘Sei yaku amiye di vegu no tau ma roka moi no rina ago tau koite makugo.’ ");
INSERT INTO kqc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Idu kaere yaku Vima kikifa ini roka moi no rigo, bi toga toga de koite makugo. Ini vegu no di toe bi toga toga ameibobigo.” ");
INSERT INTO kqc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Makai niyo ini adina bi niyadi, “Ina bi vima no inasa amedo.” ");
INSERT INTO kqc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kamini Iesu ini nono ma ini dubuiyaka baesi etofaro are resi ago nifeideyadi bi ina vene rofu baeyaine. ");
INSERT INTO kqc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ye amiye tau gade bi ameinu resi buru risi ina rofu nigamadi, “Ve kumo, yi nono ma yi dubuiyaka bi etofaro amesi ini ura bi ya vegi rededi.” ");
INSERT INTO kqc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kamini nikabai resi niyo, “Kaere bi nai nono ma kaere bi nai dubuiyaka?” ");
INSERT INTO kqc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Resi ameinu resi buru riyadi vene rofu vesi niyo, “Ve kumo, mina vene bi nai nono ma nai dubuiyaka! ");
INSERT INTO kqc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Adina kaere Sei di mokenari kana rego, bi nai dubuini, nai tobaini, ma nai nono.” ");
INSERT INTO kqc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu bi dudusa Galilee moka daidai tora adinari amiye oteimagi kora reyo. Amiye tau gade gade ina atafuri egogo reyadi, mina dada bi boutiri ameinu regi keu risi koru tobo rofu boyo ma amiye tau gade bi koru vasari are reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kamini mokena ago dudu ago tau gade nioteimasi niyo: ");
INSERT INTO kqc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Neidefo! Amiye yokoi ini yo varigi diyo. ");
INSERT INTO kqc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ye yo moi faraka reyori, bedakai bi ida sanari yareyadi ma erena yaku okisi iri vau reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Be bi abita fore odoro yareyadi; minari kono bi keika maka. Evade meto boyadi, adina kono bi doba de. ");
INSERT INTO kqc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kamini meda are reyori, bi vai taresi abiye niyadi, adina ini daru kono ideri nei mona de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma be bi imiye tafa fogori yaresi boi tora niyadi ma imiye yaku fafa risi fono reyadi. Mina dada rama de niyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma be bi kono buniri yaresi meto fatesi imu resi rama niyadi. Be bi 30, be bi 60, ma be bi 100 niyadi.” ");
INSERT INTO kqc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kamini niyo, “Kaere neidego, bi neideyaine!” ");
INSERT INTO kqc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kamini inike ameyori, bi ini ago neideyadi vene, ini usi dina vene 12 sa, disi nikaiteyadi mina mokena ago nirorotari reyaine. ");
INSERT INTO kqc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ina rofu niyo, “Ya bi Sei di ourefeidena amena sana di sui ago moiyadi, idu etofaro vene bi mokena ago dudu maka tau vakoi moigedi, ");
INSERT INTO kqc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ye yomakai, ‘Vededi, idu vei mama de rededi; ma neidededi, idu diba de nidedi. Regedi vonisi, bi Sei rofu kero regedi, ma ini vegu no koite makugo.’” ");
INSERT INTO kqc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kamini nikaiteyo, “Ya vene bi mina mokena ago di adina diba ba ide? Gokai mina mokena ago tau gade diba nigedi? ");
INSERT INTO kqc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yo varina amiye bi Sei di ago varigamo. ");
INSERT INTO kqc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Amiye bedakai bi ida sanari yo yareyadi kana. Ye ago neidena doba deri, evade Satani okisi bi moi diyo. ");
INSERT INTO kqc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kamini bedakai bi abita foreri yareyadi kana; kaere ago neidesi evade maka ada dudu moiyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Idu ini daru inike bi de, ma amei doba de regedi. Ye mina ago dada toe ma esika baegediri, bi evade youfeidegedi. ");
INSERT INTO kqc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma amiye be bi imiye tafa fogori yareyadi kana. Mina vene bi ago neideyadi, ");
INSERT INTO kqc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","idu mina kono di mokena toe, ma ini gugura tau gade di ofa ofa ago, ma gugura be di ura bi ago buni moi forovai reyadi, ye ina bi meko varena de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Idu amiye be bi kono buniri yo yareyadi kana; ago neidesi moi gira risi rama nido; be bi 30 nido, be bi 60 nido ma be bi 100 nido.” ");
INSERT INTO kqc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu yaku niyo, “Ramefa moisi foroka gabireri o ekama gabireri de aesa. Idu, ya yaku ini ikina sanari ikisa. ");
INSERT INTO kqc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Adina beika sui niyadi, bi moi ogau nigedi, ma beika sui riyadi, bi bou uyounegedi. ");
INSERT INTO kqc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amiye neidego vonisi, bi neideyaine!” ");
INSERT INTO kqc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma ina vene rofu niyo, “Ya beika neidededi, mokei mona refa! Ya amiye gokai toe madedi kana, Sei yaku mina toe dairisi ka ini odoro besa aesi ya mago. ");
INSERT INTO kqc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Adina kaere ini beika baika nufa, bi moi tanu mago. Idu kaere ina bi de iniye iniye nufa, ina rofu keika ka amedo mina ka moi dairigo.” ");
INSERT INTO kqc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu yaku dudusa niyo, “Sei di ourefeidena amena sana bi yomakai: Amiye yaku konori yo makudo kana. ");
INSERT INTO kqc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Urusa ma ariu, varedo o dadisi amedo, gokai dudu mina yo ini meto fiu ni bodo bi ina kaya ka toto. ");
INSERT INTO kqc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kono iniye dudu maka yo bosi rama nidedi; ouresi bi ini rata ogau nido, resi bi ini imu mamo meko varedo. ");
INSERT INTO kqc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Rama gira nisi kaka nigori, mina amiye evade yaku biyeta moisi nugago, adina bi butu butu di meda okiyo.” ");
INSERT INTO kqc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kamini nikaitesi niyo, “Beika yaku nigifa Sei di ourefeidena amena sana bi gokai kana? Beika mokena ago dudu yaku nirorotari regifa? ");
INSERT INTO kqc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mina bi yomakai: Mastadi di yoya konori bi keika keika iniye. Amiye yokoi konori variyo kana. ");
INSERT INTO kqc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Variyo fufutari, tora nisi yabo tau vakoi ebu rego. Ini teteka tora tora nigo ma odoro didedi erena yaku okisi ini adari nui rigedi.” ");
INSERT INTO kqc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mokena ago tau gade dudu makai ini adari ufateyainedi ina rofu nioteimagamo. ");
INSERT INTO kqc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ina bi mokena ago dudu maka sina nigamo, idu inaike ini usi dina vene rofu mina sina tau noibanu sui nisi nirorotari regamo. ");
INSERT INTO kqc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mirona uriyenau, mina meda yokoi makari, Iesu yaku ini usi dina vene rofu niyo, “Una moka daidai tora berou eta rofu boi nenadi.” ");
INSERT INTO kqc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ye ini usi dina vene bi mina amiye tau gade fereyadi. Iesu yaku bouti odoro keu riyo ma inasa afei boyadi. Ma bouti be ka bi usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Fuofuori aura yeiva tora fu reyo ma ureure tafo resi bouti ideri dui reyo, ye koru yaku vata baegamo. ");
INSERT INTO kqc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu bi bouti fufuta rofu ini ada adikuna aesi varegamo. Ini usi dina vene edadisi niyadi, “Oteimana amiye, ya bi una mokei tora reisa ba ide? Una bi kamini muyegifa.” ");
INSERT INTO kqc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu dadisi aura besenai ago masi moka daidai tora rofu niyo, “Amuta ni!” Aura minari bere niyo, ma moka daidai tora amuta niyo. ");
INSERT INTO kqc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ini usi dina vene rofu niyo, “Beika resi ori reyadi? Gokai resi yi mokena vari gira Sei rofu de aeyadi?” ");
INSERT INTO kqc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma ina kaya ori tora resi iniye iniye rofu niyadi, “Ye mina amiye bi gokai kana amiye? Aura ma koru tafo ka ini ago neidededi!” ");
INSERT INTO kqc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kamini Iesu ini usi dina venesa Galilee moka daidai tora berou eta rofu Gerasa gaganiri okiyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Soka reyo doba deri, bi amiye yokoi vima no nufa amiye guri sana fore ruba gutuna baeyo ma baku reyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mina guri sanari amegamo. Amiye yaku dudusa seini dudu ukita risi ferena bi rena de regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Uru tau gade ini yuka ma ini vana ukita reyadi, idu toga toga seini ubaki resi auri ini yukari moi fufuta regamo. Ini yeiva bi tora gade iniye, ye amiye yaku moi gira kiki rena de. ");
INSERT INTO kqc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ari ma urusa bi toga toga guri sanari ma omunari raka nisi fore dudu ina kaya nugagamo. ");
INSERT INTO kqc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maikeri gutuna nesi Iesu veyo. Resi raga resi ini budari efuka meimisi ");
INSERT INTO kqc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","raka ni tora reyo, “Iesu oma odoro Sei di mida, beika resi na rofu baesa? Sei di roka dudu, ya usa nida, esika na mana ga re!” ");
INSERT INTO kqc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mina nigamo, ini adina bi Iesu yaku niyo, “Vima no, mina amiye rofu yaku!” ");
INSERT INTO kqc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kamini Iesu yaku nikaiteyo, “Yi roka bi beika?” Ma nikabai reyo, “Nai roka bi ‘Tau gade gade,’ adina una bi tau gade!” ");
INSERT INTO kqc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma niguba rei tora regamo vima no mina gaganiri meki rena ga reyaine. ");
INSERT INTO kqc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye mironari bi dona tau gade atafu, omuna ikari ini vana irigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Vima no yaku Iesu guyaguya nisi niyadi, “Una dona rofu nifeidegiya, ini roaita ideri dui regifa dada.” ");
INSERT INTO kqc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nifeideyo ma vima no mina dona 2,000 kana tau noibanu ini roaitari dui reyadi ma raravari raga nesi moka daidai torari yoyo resi koruri tomu nisi muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dona vana regamadi vene bi ori disi beika vata niyo taoniri ma gagani gagani vene rofu sina ni digamadi. Amiye bi beika vata niyo mina vegi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesu rofu okiyadiri, bi mina amiye veyadi, kaere bi vima no tau gade gade ini roaita ideri amegamo. Ina bi mironari amegamo roaita dogo resi mokena rorobo dudu, ma ina tau noibanu ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma mina vegu veyadi vene yaku amiye nioteimaradi beika vima no nufa amiye ma dona rofu vata niyo bi. ");
INSERT INTO kqc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ye Iesu rofu niguba reyadi ini gagani feresi diyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma bouti odoro keu riyori, sena vima no nufa amiye bi inasa digi niguba reyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Idu Iesu yaku nivaisi niyo, “Rauturi dairisi yi yava vene ni gokai Varika amiye ya rofu iriyeduka resi vegu buni reyo.” ");
INSERT INTO kqc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ye feresi taoni 10 (Decapolis) rofu disi amiye rofu ago nirausi regamo, Iesu yaku gokai ina rofu reyo ma amiye tau mina neidesi tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kamini Iesu boutiri dudusa dairisi moka daidai tora berou ugasi boi neyori, amiye tora gade okisi seriri ina atafu egogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mina usi usa usa yava di ourefeidena amiye yokoi roka Jairus bi okiyo. Kamini Iesu veyori, bi ini yuka adinari iniye you makusi ");
INSERT INTO kqc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","guyaguya nisi niyo, “Nai vefa keika bi tumusa muyego. Ye baesi yi vana ina fafau aegiya, ma buni nisi vegu amebigo.” ");
INSERT INTO kqc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ye inasa boyo. Ma amiye tau gade yaku usi bosi ina fafa riyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Rema yokoi bi lagani 12 rema di gauka guraugamo. ");
INSERT INTO kqc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gauka dogo amiye tau yaku vei dogo reyadi. Idu ini fore tau gade koina niyo ma buni nina de; ini gauka bi ari neinei tora nigamo. ");
INSERT INTO kqc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ina yaku Iesu di sina neidesi amiye tau gade di fufutari baesi ini varuka avaka moiyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Adina ina kaya rofu nigamo, “Na ini varuka maka avaka moigida vonisi, bi buni nigida.” ");
INSERT INTO kqc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ini varuka avaka moiyori, bi minari maka ini dava degamo koina niyo, ye amuteyo ini roaita ideri ini gurauna bi koina niyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Evade Iesu mokeyo ini vava bi ina rofu yakuyo, ye kero resi mina amiye tau gade rofu nikaiteyo, “Kaere yaku nai varuka avaka moiyo?” ");
INSERT INTO kqc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma ini usi dina vene yaku niyadi, “Ya mina amiye tau gade ya fafa ridedi veisa ba ide, idu una nikaiteisa, ‘Kaere yaku na avaka moiyo’? vo nisa.” ");
INSERT INTO kqc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma ne resi maina regamo kaere yaku mina vegu reyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma mina rema diba niyo beika ina rofu vata niyo, ye baesi ini yuka rafo adinari iniye you makusi ori dudu tururu resi sina rama tau noibanu nioteimaro. ");
INSERT INTO kqc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma niyo, “Nai vefa, yi mokena vari gira aena yaku ya moi buni riyo. Uka amuta dudu di ma yi gurauna rofu bi buni niyo.” ");
INSERT INTO kqc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Resi mina ago nigamori, usa usa yava di ourefeidena amiye di yava vene okisi niyadi, “Yi vefa bi muyeyo. Beika resi mina oteimana amiye rofu toga mokena moigasa ameisa?” ");
INSERT INTO kqc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Idu beika niyadi bi mokei vava de reyo. Resi usa usa yava di ourefeidena amiye rofu niyo, “Ori ga re; mokena vari gira maka ae.” ");
INSERT INTO kqc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ye amiye yokoi inasa afena de reyo, idu Peter, James ma ini dubuini John maka. ");
INSERT INTO kqc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kamini usa usa yava di ourefeidena amiye di yavari okiyadiri, Iesu bi uka vorivori dudu isaka nisi goroka tora dudu guruo regamadi ma veyo. ");
INSERT INTO kqc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Resi dui resi niyo, “Beika resi uka vorivori resi isaka nidedi? Mina rema mida keika bi muyena de reyo, idu bi neota varedo.” ");
INSERT INTO kqc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma ina rofu ninika nigamadi, idu amiye tau noibanu etofaro nifeidesi mina rema mida di nono baba ma ini usi dina vene regodesa mina rema mida keika muyesi varedo sanari dui rei boyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ini vana moisi niyo, “Talita, koum!” Mina ago ini adina bi, “Rema mida keika, na ya rofu nida dadi!” ");
INSERT INTO kqc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Minari maka dadisi nana digi kora reyo. Ini vata niyo lagani bi 12. Mina vata niyori, ina vene tau noibanu tururu iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Iesu yaku ago gira masi niyo amiye yokoi ga nioteimaraganedi, ma ina rofu niyo iruku yokoi be mafo kumo iriyaine. ");
INSERT INTO kqc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu ini usi dina venesa mina sana feresi ini tora niyo taoniri dairiyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati meda niyori, usa usa yavari amiye rofu oteimagi kora reyo. Amiye tau ini beika niyo neidegasa tururu resi iniye iniye niyadi, “Goidu mina baku reyo? Mina mokena tora moiyo bi beika? Gokai dudu mokena vegu makai redo? ");
INSERT INTO kqc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mina bi yava rina amiye, ma Mary di mida ma ini dubuiyaka bi James, Joseph, Judas ma Simon ba? Ma ini tobaiyaka ka minari unasa amededi ba?” Ye makai ina rofu uka no reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu yaku mina vene rofu niyo, “Gagani tau vene yaku Sei di ago nido amiye vei odoro regamadi, idu ini rauturi bi ini davatu vene ma usika ourena yaku bi de.” ");
INSERT INTO kqc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ma tururu reyo, adina bi mokena vari gira de aeyadi. Ye minari bi mokena vegu yokoi de reyo, idu gauka vene be maka ini vana moi fafau aesi moi buni riyo. Kamini bi rautu rautu amiye ago oteimagamo. ");
INSERT INTO kqc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ye ini amiye 12 raka nisi niegogo resi remanu remanu dudu nifeidegi kora reyo. Ina yaku vima no meki rena di vava magamo. ");
INSERT INTO kqc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Resi ago gira ina rofu niyo, “Gugura yokoi ida di ga moifa, idu yukana maka—iruku bi de, dura bi de, ma fore kopa yi foketari aena ka bi de. ");
INSERT INTO kqc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Idu yi yuka ro maka bi risi varuka remanu ga aku mafa. ");
INSERT INTO kqc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Goina yava dui regedi, bi minari amegedi bogo ferei digedi mamo. ");
INSERT INTO kqc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma goina gagani yokoiri ya moi dui de regedi, o yi ago de neidegedi, bi minari feresi yi yuka di budoka usi eyarefa. Ye mina bi ini vegu makai regedi yaku bi vei mama regedi.” ");
INSERT INTO kqc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kamini disi ago buni nirausi reyadi, dada amiye yaku neidesi vegu no feresi moi etagae riyagane. ");
INSERT INTO kqc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Minari bi vima no tau gade amiye di roaitari meki resi, gauka bi diga adari rausi regasa moi buni rigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ye kini Herod yaku beika vata nigamo bi neideyo, adina ini roka bi gagani tauri ogau nigamo. Amiye yaku nigamadi, “John Baptist bi muyena gutuna dadi rae reyo. Mina resi bi mokena vegu redo.” ");
INSERT INTO kqc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Idu amiye be yaku niyadi, “Ina bi Elijah.” Ma be yaku niyadi, “Ina bi Sei di ago nido amiye, kaere bi senagi senagi Sei di ago niyo amiye yokoi kana.” ");
INSERT INTO kqc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Idu Herod mina ago neidegasa niyo, “Ina bi John Baptist, kaere bi ini ada nugai feideyaka, ma dudusa dairisi vegu niyo!” ");
INSERT INTO kqc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod ina kaya mina ago niyo, adina bi sena ago maro ma John moisi ini yuka ukita risi dibura yavari aeyadi, Herodias, kaere bi Herod di ini dubuini Philip di rema, dada. ");
INSERT INTO kqc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ini adina, John yaku Herod rofu nigamo, “Yi dubuini di rema meyo bi tabu.” ");
INSERT INTO kqc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mina dada, Herodias ini uka esika John rofu bi tora gade ma ini ura bi umuyego vo nigamo, idu ina rofu ida bi de. ");
INSERT INTO kqc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod bi John rofu ori regamo, adina bi ina diba John bi mokena rorobo amiye ma amiye kikifa, mina dada buniri maka aegamo. Ini sina neideyori, bi ini mokena forovai reyo. Idu, ini ura bi ini sina neidegi, vo niyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias ini mokegamo meda bae okiyori, bi Herod di vata niyo medari, ina yaku ini ourefeidena vene, iya vene di tora tora, ma Galilee di ourefeidena vene raka nisi irakuna maro. ");
INSERT INTO kqc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias di vefa dui resi adena usi Herod di okiyadi venesa di uka moi ada reyo. Ye kini yaku mina rema ofi niyo, “Ya ura beika ya magida? Yi beika ura regiya bi ya magida.” ");
INSERT INTO kqc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nitore resi mina rema niyo, “Gua ya nida, mini beika na usa nigiya bi ya magida, ye nai ourefeidena amena sana mina berou afona tu ya magida.” ");
INSERT INTO kqc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mina rema mida minari maka nesi ini nono nikaiteyo, “Beika nigida?” Ma niyo, “John Baptist di ada.” ");
INSERT INTO kqc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma evade maka dairi nesi kini rofu niguba reyo, “Nai ura bi ya yaku ruika maka mereki odorori John Baptist di ada na ma!” ");
INSERT INTO kqc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ye kini bi iriyeduka no niyo, idu ini nitore reyo ago ma okiyadi vene dada, ini ura bi ina rofu rego. ");
INSERT INTO kqc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ye evade ini iya redo amiye nifeidesi ago gira maro ini ada moi baeyaganedi. Ma dibura yavari nesi ini ada nugai feideyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Resi mereki odorori aesi moi baeyo, mina rema ofi maro, ma ina yaku dadisi bi ini nono maro. ");
INSERT INTO kqc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ye John di usi dina vene mina neidesi baesi ini roaita moisi guri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kamini ini nifeidena vene bi inasa amei desi bi ini beika reyadi ma beika oteimaradi mina nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Minari bi amiye tau gade gade ma nega baegasa reyadi, dada iri-iri di meda bi de. Ye niyo, “Ya yaku maka nasa baegedi ma disi mafumafu sanari sifere regifa.” ");
INSERT INTO kqc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ye boutiri keu risi mafumafu sana yokoiri boyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Idu boyadiri, bi amiye tau, kaere ini goidu digo sana bi vesi diba niyadi, bi taoni tau gutuna yuka dudu raga resi sena bogamadi ini boi okigedi sana. ");
INSERT INTO kqc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ye bouti feresi soka regasa bi amiye tau gade gade vesi ina rofu iriyeduka reyo, adina bi mamoe ini dogo amiye bi de kana, dada ago tau gade nioteimagi kora regamo. ");
INSERT INTO kqc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma meda bi uriyenau eta rofu niyori, bi ini usi dina vene ina rofu baesi niyadi, “Mina bi autu sana ma ari bi koina niyo mini. ");
INSERT INTO kqc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amiye nifeide kumo mina atafu gagani sanari ma rauturi disi ini iruku voi resi iriyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Idu nikabai resi niyo, “Ya yaku iruku mafo kumo iriyaganedi.” Ma niyadi, “Una yaku siriva fore 200 dudu beredi voi resi mina vene magifa ma irigedi ba?” ");
INSERT INTO kqc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma ina yaku niyo, “Beredi gokaisanu? Disi vefa.” Ye baku resi niyadi, “Beredi 5 ma oyena remanu mini.” ");
INSERT INTO kqc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ye ago maro bi amiye tau neinei dudu mutaka odoro ameinu reyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dada amiye bi tau neinei be bi 100 dudu ma be bi 50 dudu ameyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma beredi 5 ma oyena remanu moisi oma rofu vegasa buni tora gade Sei rofu masi bi beredi moi okusi ini usi dina vene maro bi amiye tau rofu rau reyaganedi. Ina ka oyena remanu moi odesi amiye tau rofu rau reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ye ina tau noibanu iriyadi ma ini uka bere niyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma beredi ma oyena tuta butu resi foroka 12 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ye mina iriyadi vene bi rumana vene maka 5,000. ");
INSERT INTO kqc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ye amiye tau gade nifeidegasa evade ini usi dina vene rofu ago maro bi bouti keu risi ina siko Bethsaida ri moka daidai tora berou eta rofu boyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ye amiye feresi bi omuna ikari usa usa nigika boyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Uriyenau tumu niyori, bouti bi moka daidai tora tobo ramari, ye inaike konori ameyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne resi veyori, bi ini usi dina vene bi fayo rena bi gira iniye nigamo, adina aura bi bogamadi sana baegamo dada. Ye ari uvego atafuri ina vene urana koru toboma nana regasa boyo. Ina vene ebu rego vo niyo. ");
INSERT INTO kqc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Idu Iesu moka daidai tora fafau nana regamo vegasa mokeyadi mina bi godiyo. Kamini imuna niyadi, ");
INSERT INTO kqc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ina tau vakoi vesi ori reyadi dada. Idu minari maka Iesu ina vene rofu niyo, “Mina bi na; uka gira nisi ori ga refa!” ");
INSERT INTO kqc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kamini boutiri ina venesa keu riyo ma aura amuta niyo. Ina vene bi tururu iniye reyadi, ");
INSERT INTO kqc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","adina ini ada de fateyo amiye 5,000 vana reyo bi, ini uka forovai reyadi dada. ");
INSERT INTO kqc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kamini moka daidai tora ugasi bi Gennesaret gaganiri okisi minari bouti utae reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ye bouti fereyadiri, amiye evade vei mama reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Resi mina gagani di berou berouri raga resi ini gauka vene ekamari uakaisi afei okigi kora regamadi. Mina bi Iesu ini goidu amegamo sana bi neidegamadi dada. ");
INSERT INTO kqc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ye goidu soka regamori, rautu rautu neinei, o taoni, o gagani, bi maketi sanari gauka vene afei baegamadi. Ina rofu guyaguya nigamadi ini varuka metona maka avaka moisi buni niyaganedi. Ye amiye tau yaku avaka moigamadi bi buni nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kamini Pharisee vene ma ago gira oteimana vene be, kaere bi Jerusalem gutuna baeyadi, bi Iesu rofu boyadi. ");
INSERT INTO kqc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Minari veyadi, bi Iesu ini usi dina vene be bi vana dudu kino ma koitena de, bi iruku moigasa irigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee vene ma Jew vene noibanu bi ini tora vene di ago gira vaitani ini vana bi dogo resi koitegedi mamo iruku irigedi. ");
INSERT INTO kqc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maketi sana gutuna baegediri, bi rafesi mamo iruku irigedi. Ma ini sena tora vene di ago gira mina ka vededi bi biyo ma fani ma ketoro ka koitegedi. ");
INSERT INTO kqc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma Pharisee vene ma ago gira oteimana vene yaku Iesu nikaiteyadi, “Beika resi yi usi dina vene bi uni aufakai di toutou de resi ini vana kino nufa iruku iridedi?” ");
INSERT INTO kqc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ye nikabai resi niyo, “Isaiah bi rama nisi ya ofarosi vene dada, Sei di ago nisi bura reyo bi mini: ‘Mina vene bi ini afiye dudu na kikifa rededi, idu ini uka na rofu bi maike tora. ");
INSERT INTO kqc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na nivakei kava rededi; adina mokededi amiye di oteimana ago bi Sei di ago gira kana!’ ");
INSERT INTO kqc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ma ya bi Sei di ago gira bi youfeidesi sena amiye di ago moi gira ridedi.” ");
INSERT INTO kqc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Resi ka niyo, “Ye ya bi Sei di ago gira gedu masi bi yi aufakai di toutou moi gira rededi! ");
INSERT INTO kqc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Adina Moses yaku makai niyo, ‘Yi nono baba emagui re,’ ma ‘Kaere yaku nono o baba nikiraini rego, bi umuyeyaine.’ ");
INSERT INTO kqc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Idu ya yaku nidedi, amiye yokoi ini sogona amededi ye mina nufa ini baba o nono aedegedi, idu nigo, ‘Mina bi Corban (Sei di sogona)’ vonisi, ");
INSERT INTO kqc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","resi bi ka nigo, ‘Ye makai nai baba o nono bi aedena ga regida.’ ");
INSERT INTO kqc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ya yaku aufakai di toutou amiye rofu oteimadedi, ye Sei di ago moi no ridedi dada. Ya yaku ka vegu no tau gade makai rededi.” ");
INSERT INTO kqc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kamini dudusa amiye tau gade raka niegogo resi niyo, “Ya amiye tau na neidesi diba nifa. ");
INSERT INTO kqc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Beika baika etofarori ma amiye di roaita ideri dui rego bi moi kino de rigo. Idu beika amiye di roaita gutuna yakugo mina yaku amiye moi kino rigo.” ");
INSERT INTO kqc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Amiye tau feresi yavari dui reyori, ini usi dina vene yaku nikaiteyadi beika mina mokena ago di rama bi. ");
INSERT INTO kqc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma ina rofu niyo, “Ye ya ka bi ada yora de ba? Diba de nidedi ba, beika amiye etofarori ini roaitari dui rego yaku moi kino de rigo? ");
INSERT INTO kqc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Adina bi ini uka mekori de dui redo, idu ini rivori maka ma ini roaitari yakudo.” Makai niyo, iruku tora noibanu bi ruaka maka moi rama aeyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ka niyo, “Beika amiye gutuna yakudo yaku amiye moi kino rido. ");
INSERT INTO kqc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Adina amiye di uka ideri gutuna yakudedi bi mini: mokena no, mena de vene koa rena, duma duma rena, amiye umuyena, mena vene koa rena, ");
INSERT INTO kqc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","udu, amiye uka esika mana, amiye ofa nimana, uka ideri mokena no, uka mukuna, uka gubuyo, amiye di roka moi no rina, ya kaya roka niodoro, ma dona auna di moke moke. ");
INSERT INTO kqc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mina vegu tau yaku amiye di roaita ideri gutuna yakusi amiye moi kino ridedi.” ");
INSERT INTO kqc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mina usi dadisi mina sana feresi Tyre ma Sidon taoni di gagani rofu diyo. Resi bi yava ideri dui resi baeyo, ini ura bi amiye ga diba niyagane ina bi minari. Idu bi sui nina anua reyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma rema yokoi, kaere ini rema mida bi vima no nufa, bi Iesu di sina neidegasa evade maka ina rofu baesi ini yuka adinari iniye you makuyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ina bi Greek rema, Phoenicia gagani Syria ri vata niyo. Iesu niguba regamo mina vima no ini mida rofu meki reyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ye ina rofu niyo, “Mida mida yaku ini beika ura rededi siko iriyagane, adina bi buni de mida mida di iruku moisi auna rofu makugiya.” ");
INSERT INTO kqc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma nikabai resi niyo, “Varika amiye, auna yaku ka mida mida di iruku bubudo teiboro gabireri iridedi.” ");
INSERT INTO kqc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kamini Iesu yaku niyo, “Makai dudu na niyo, ma ya bi dairigiya, vima no bi yi midari yakuyo.” ");
INSERT INTO kqc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ina bi rautu disi veitao reyori, ini mida bi varegamo ma vima no bi diyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kamini Iesu bi Tyre taoni di gagani feresi Sidon dui resi Galilee moka daidai torari Decapolis taoni di gagani ideri okiyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mironari amiye yokoi ina rofu afei okiyadi. Ina bi babo ma vena ufoka resi ago nina bi gira. Ina vene yaku guyaguya niyadi ini vana mina amiye fafau aeyaine. ");
INSERT INTO kqc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ye Iesu yaku mina amiye tau rofu afei etagae ri disi ini vana ebuna moisi mina amiye di anema ideri aesi ayaka su resi ini afiye avaka moiyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne odoro risi oma vesi ababa nisi niyo, “Ephphatha!” Mina bi “Ne are!” ");
INSERT INTO kqc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mina dudu, mina amiye di anema fo'o niyo, ma ini afiye roge reyo ma ago ni mama reyo. ");
INSERT INTO kqc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu yaku ago gira dudu mina vene rofu niyo, “Amiye yokoi ga nioteimaragane.” Idu ago gira Iesu yaku niyo bi tora iniye niyori, ina vene toga ini vegu di ago nirausi regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amiye di vima bi tururu tora gade resi niyadi, “Ina yaku deda tau moi burefe rido; ina yaku ka redo ma anema kora neidesi ma babo ago nidedi.” ");
INSERT INTO kqc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mirona medari, amiye tau gade egogo reyadi. Ini irigedi iruku bi koina, ye Iesu yaku ini usi dina vene raka niegogo resi niyo, ");
INSERT INTO kqc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na bi mina vene rofu iriyeduka reida, adina bi nasa sena meda regodenu ameyadi ma iruku bi koina. ");
INSERT INTO kqc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ye raunari ini rauturi nifeidegida vonisi, bi idau muyei tamatama regedi, adina bedakai bi gagani maike gutuna soka reyadi.” ");
INSERT INTO kqc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ye nikaiteyadi, “Amiye yokoi bi goidu mina gagani autu sanari beredi moisi amiye tau gade vana rego?” ");
INSERT INTO kqc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma nikaiteyo, “Ya bi beredi bado gokaisanu nufa?” Ma niyadi, “7.” ");
INSERT INTO kqc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ye amiye tau gade konori ameinu reyagane vo niyo. Resi bi beredi bado 7 moisi buni tora gade Sei rofu masi beredi okusi ini usi dina vene maro amiye tau gade rau regedi dada, resi makai reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ina venesa ka oyena keika be nufa, mina ka buni tora gade Sei rofu masi ini usi dina vene maro rau reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma ina vene iruku iriyadi ma uka bere niyadi. Ye tuta fereyadi bi foroka 7 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Amiye bi 4,000 kana; nifeideyo ma diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kamini evade ini usi dina venesa bouti keu risi Dalmanutha gagani rofu boyadi. ");
INSERT INTO kqc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ye Pharisee vene okisi Iesu rofu kayamo regi kora regamadi. Omari rebe yokoi reyainedi nikaiteyadi, ebene regika bi rama ba ide Sei bi ini vava maro. ");
INSERT INTO kqc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma ini vima dudu ababa nisi niyo, “Beika resi gua amededi vene yaku rebe maina rededi? Rama iniye ya nida, rebe yokoi mina vene rofu de mago.” ");
INSERT INTO kqc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kamini mina vene feresi dudusa bouti keu risi berou eta rofu ugasi boyo. ");
INSERT INTO kqc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma ini usi dina vene bi beredi bado moigi toto niyadi, ye beredi yokoi maka boutiri inasa moi digamadi. ");
INSERT INTO kqc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ye Iesu ago gira masi niyo, “Nari resi Pharisee vene ma Herod di yeast rofu vei mona refa.” ");
INSERT INTO kqc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ye iniye iniye nidodi resi niyadi, “Mina niyo, ini adina bi beredi koina.” ");
INSERT INTO kqc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kamini Iesu yaku ini mokena veifategasa nikaiteyo, “Beika resi beredi bado koina dada nidodi rededi? Ya vene bi toga veifatesi adari ufatena de rededi? Yi uka bi gira niyadi ba? ");
INSERT INTO kqc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yi nemoko bi amededi, idu de vededi, ma anema nufa, idu de neidededi ba? O ya diba de mokededi? ");
INSERT INTO kqc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Amiye 5,000 dada beredi 5 odeyakari, tuta moisi bi foroka gokaisanu moi vata baeyadi?” Ma niyadi, “12.” ");
INSERT INTO kqc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma amiye 4,000 dada, beredi 7 odeyakari, tuta moisi bi gokaisanu foroka vata baeyadi?” Ma niyadi, “7.” ");
INSERT INTO kqc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ye ina rofu niyo, “Ya bi toga yi adari ufatena de rededi ba?” ");
INSERT INTO kqc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida taoniri okiyadiri, amiye yaku ne taufa amiye yokoi afei okisi Iesu guyaguya niyadi, ina yaku avaka moiyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu yaku ne taufa amiye vanau risi rautu etofaro yakusi ini nemokori ayaka su resi ini vana mina amiye fafau aesi niyo, “Beika be veisa?” ");
INSERT INTO kqc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ne taufa amiye yaku ne odoro risi niyo, “Amiye veida bi yabo kana dibo rededi.” ");
INSERT INTO kqc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma dudusa ini vana ini nemokori aeyo. Kamini ini nemoko areyadi, ma ini nene rena mina dairiyaime riyo, ma beika tau gade mina vei mama riyo. ");
INSERT INTO kqc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu yaku mina amiye ini yavari nifeidesi niyo, “Rauturi bi ga ne.” ");
INSERT INTO kqc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kamini Iesu bi ini usi dina venesa Caesarea Philippi di rauturi bogasa idauri nikaitesi niyo, “Amiye yaku nidedi na bi kaere, vo nidedi?” ");
INSERT INTO kqc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ye nikabai reyadi, “Be yaku nidedi ya bi John Baptist, be yaku nidedi bi Elijah, ma be yaku nidedi bi Sei di ago niyo amiye yokoi.” ");
INSERT INTO kqc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma nikaiteyo, “Idu ya yaku nidedi na bi kaere?” Peter nikabai resi niyo, “Ya bi Keriso.” ");
INSERT INTO kqc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ye nidiba reyo bi amiye yokoi ina dada ga nioteimaragane. ");
INSERT INTO kqc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kamini nioteimagi kora reyo, “Amiye di mida bi esika esika tau moiyaine ma tora vene, Sei ma amiye utari naivo vene di varika vene, ma ago gira oteimana vene yaku fufuta masi umuyegedi, ma gabi meda regodenuri dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Resi mina ago ina rofu niogau regamo. Ye Peter yaku moi etagae risi besenai ago magi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Idu Iesu kero resi ini usi dina vene vesi Peter besenai ago maro, “Satani, nai fufuta rofu ne, adina ya bi Sei di mokena kana de moisa, idu amiye di mokena moisa.” ");
INSERT INTO kqc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Resi amiye tau gade ini usi dina venesa raka niegogo resi niyo, “Kaere amiye ini ura bi na usi digo vonisi, bi ina kaya toto nisi ini satauro moisi na usi baeyaine. ");
INSERT INTO kqc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Adina kaere ini vegu moi gira rigi ura rego, bi de moigo, idu kaere na dada ma ago buni dada, ini vegu youfeidego, bi moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Adina beika buni bi amiye yokoi mina kono tora noibanuri baku resi ini vegu eyarego? ");
INSERT INTO kqc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O ini vegu dada, bi beika dairi mago? ");
INSERT INTO kqc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Adina gua mina mokena vari gira de aena ma vegu no rena vene fogori, amiye kaere na dada ma nai ago dada maena rego vonisi, Amiye di mida ini Baba di vabarari ini akeke naivo naivo vimasa okigasa ina rofu ka maena rego.” ");
INSERT INTO kqc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kamini ina rofu niyo, “Rama ya nida, ya bedakai minari bi de muyegedi, idu Sei di ourefeidena amena sana ini vava nufa dego bi vegedi.” ");
INSERT INTO kqc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kamini meda 6 koina niyori, Iesu yaku Peter, James ma John afesi omuna tora yokoiri inaike maka boyadi. Mironari ina vene di nemokori, ini roaita idana niyo. ");
INSERT INTO kqc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ini varuka bi feyo kamanika iniye niyo, feyo tayataya amiye yokoi mina kono tora noibanuri ka mina kana varuka koitena di feyo kana de. ");
INSERT INTO kqc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma Elijah ma Moses bi ina vene rofu ogau nisi Iesu sa sina nigamadi. ");
INSERT INTO kqc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ye Peter yaku Iesu rofu niyo, “Oteimana amiye, bi buni una bi minari. Una bi karaga regode akugifa—yokoi bi yi, yokoi bi Moses di, ma yokoi bi Elijah di.” ");
INSERT INTO kqc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ina bi ina diba de beika ago nigamo bi, adina ori iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma seuya desi ina vene bou riyo, ma ago goroka mina seuya gutuna baesi niyo, “Mina bi nai uka maida Mida; ini ago neidefa!” ");
INSERT INTO kqc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Evade maka ne kero reyadi, idu amiye yokoi de veyadi, idu Iesu maka ina venesa amegamo. ");
INSERT INTO kqc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ye omuna degamadiri, Iesu yaku ago gira magamo, “Amiye yokoi ga nioteimafa beika veyadi bi, bogo Amiye di mida bi muyenari gutuna dadi rae rego mamo.” ");
INSERT INTO kqc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mina ago bi neidei mokesi iniye maka nidodi reyadi, “Muyenari dadi rae rena bi beika?” ");
INSERT INTO kqc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Resi nikaiteyadi, “Beika resi ago gira oteimana vene yaku nidedi Elijah siko deyaine?” ");
INSERT INTO kqc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ye nikabai reyo, “Rama Elijah siko desi beika tau dudusa moi dogo rei mona rego. Ma beika resi bi bura reyadi Amiye di mida bi esika esika tora iniye baku rego ma etofa regedi? ");
INSERT INTO kqc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Idu ya nida, Elijah bi sena baeyo, ma beika mokeyadi ma bura reyadi kana, ina rofu reyadi.” ");
INSERT INTO kqc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kamini ini usi dina vene rofu baeyadiri, bi amiye tau gade gade buru riyadi ma veyadi, ma ago gira oteimana vene be yaku ina venesa kayamo regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Minari maka, amiye tau gade Iesu vegasa vima disi raga bosi buni maradi. ");
INSERT INTO kqc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma nikaiteyo, “Ya bi beika nisi ina venesa kayamo rededi?” ");
INSERT INTO kqc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ye mina amiye tau gade fogori, amiye yokoi nikabai reyo, “Oteimana amiye, nai mida ya rofu afei baeyaka, kaere bi vima no dui resi moi babo riyo. ");
INSERT INTO kqc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Goidu moidori, bi konori makudo ma vena kabudo redo ma ini gade aki gigi resi ini roaita ka gira nido. Ye yi usi dina vene rofu mina vima no meki reyaganedi usa niyaka, idu ini yeiva dudu mina regi anua reyadi.” ");
INSERT INTO kqc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma nikabai reyo, “Ya gua mokena vari gira de aena vene, gokaisanu ari doba yasa amegida? Meda gokaisanu yasa moimai regida? Na rofu afei baefa!” ");
INSERT INTO kqc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mina mida afei boyadi. Vima no yaku Iesu vegasa minari maka moi tururu reyo. Mina mida konori maku nesi etagae riyo ma buyo buyo resi vena kabudo regamo. ");
INSERT INTO kqc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu yaku mina mida di baba nikaiteyo, “Gokaisanu meda mina gauka baku reyo?” Ma nikabai reyo, “Ina mida kakuari gutuna. ");
INSERT INTO kqc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ari tau gade vima no yaku ka moisi ita mokari ma koruri makuyo muyeyaine. Idu ya mokeisa bi regiya vonisi, buni bi una iriyeduka resi una aede!” ");
INSERT INTO kqc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma niyo, “Ya mokeisa bi regiya vonisi, vegu tau ya rofu bi aita ya kaere Sei rofu mokena vari gira aegiya.” ");
INSERT INTO kqc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma evade maka, mida di baba yaku raka nisi usa niyo, “Nai mokena vari gira keika aeda bi na aede ye tora nigo!” ");
INSERT INTO kqc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu yaku amiye tora gade urana baeyadi vegasa bi ago gira vima no rofu masi niyo, “Ya anema kora ma vena babo vima no, ya rofu ago gira maida, mina mida di roaitari yakusi dudusa dui rena ga re!” ");
INSERT INTO kqc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kamini vima no raka tora nisi mina mida bi moi tururu resi ini roaitari yakuyo. Ye mida bi muyena kana varegamo, ye amiye tau yaku niyadi, “Rama iniye muyeyo!” ");
INSERT INTO kqc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Idu Iesu bi vanau moisi moi odoro reyo, ma mida bi are reyo. ");
INSERT INTO kqc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma Iesu yava ideri dui reyori, bi ini usi dina vene sui dudu nikaiteyadi, “Beika resi bi meki regi anua reyafa?” ");
INSERT INTO kqc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma nikabai resi niyo, “Mina kana meki rena ida bi koina, idu usa nina maka bi yeiva.” ");
INSERT INTO kqc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu ini usi dina venesa bi mirona sana feresi Galilee di kono ebu resi boi neyadi, ini ura de amiye yaku diba nigedi ini dibo sana, ");
INSERT INTO kqc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","adina ini usi dina vene oteimagasa niyo, “Amiye di mida bi amiye di vanari siri rego ma umuyegedi, ma meda regodenu koina nigori, dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Idu beika ago niyo bi ini adari de ufatesi nikaitegi ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum taoniri okiyadi. Kamini Iesu yaku yava ideri ina vene nikaiteyo, “Ya vene bi idau beika nigasa kayamo regamadi?” ");
INSERT INTO kqc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Idu bi bere niyadi, adina bi idau digasa kayamo reyadi kaere bi tora iniye. ");
INSERT INTO kqc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma ameinu resi bi ini usi dina vene 12 nirutu resi niyo, “Kaere amiye ouregi ura rego vonisi, mokego ina bi amiye tau gade di gabireri keika iniye nisi ka amiye tau di naivo rena amiye nigo.” ");
INSERT INTO kqc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Resi mida keika yokoi moisi ini fogori moi are resi binu masi niyo, ");
INSERT INTO kqc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kaere yaku nai roka dudu mida yokoi makai kana moi dui rego, bi na ka moi dui rego. Ma kaere yaku na moi dui rego, bi diya na maka moi dui rego, idu kaere na nifeideyo amiye, ka moi dui rego.” ");
INSERT INTO kqc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John yaku niyo, “Oteimana amiye, Amiye yokoi yi roka dudu vima no meki regamo ma veyafa, ye nivaigika reyafa, ini adina bi una usi de dido.” ");
INSERT INTO kqc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma niyo, “Ga nivaifa, adina amiye yokoi ide yaku nai roka dudu bi mokena vegu rena moimai rego, ari yokoiri bi na dada ago deda no mina nigo. ");
INSERT INTO kqc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Adina kaere una rofu no de redo, ina bi uni. ");
INSERT INTO kqc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adina rama iniye ya nida, kaere amiye biyori koru ya mago, bi Keriso di roka nufa dada, ini obini de youfeidego. ");
INSERT INTO kqc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Idu kaere amiye mina mida keika keika yokoi, kaere bi mokena vari gira na rofu aedo, bi ourefeidego vonisi, ma vegu no rego, bi kaunava tora moigo. Bi buni bi witi utei rena di fore tora ini kuriri ukita resi davarari makugo. ");
INSERT INTO kqc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ye yi vana yaku ya moi vegu no rofu ourefeidego vonisi, bi nugai feide! Makai bi buni, vana yokoi maka nufa vegu buni dui regiya, idu buni de vana remanu nufa ita moka dui rei bogiya, minari ita bi de kafedo. ");
INSERT INTO kqc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ye yi yuka yaku ya moi vegu no rofu ourefeidego vonisi, nugai feide! Makai bi buni, yuka kevo nufa vegu buni dui regiya, ma buni de yuka remanu nufa ita moka ya makugo. ");
INSERT INTO kqc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma yi nemoko yaku ya moi vegu no rofu ourefeidego vonisi, kini biyoka resi maku! Makai bi buni ya rofu Sei di ourefeidena amena sanari nemoko yokoi maka nufa dui regiya, ma buni de nemoko remanu nufa ita mokari makugo. ");
INSERT INTO kqc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mironari bi ‘adi muyena de ma ita vaido mina de kafego.’ ");
INSERT INTO kqc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ramena yaku ori sisika moi buni rido kana, amiye tau ka ita dudu moi buni rigo. ");
INSERT INTO kqc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ramena bi buni; idu ramena di safi koina nigo vonisi, bi gokai ida dudu ini safi dudusa moi safi rigiya?” “Ya kaya ya kaya maka ramena risi ya neinei ideri bi uka amuta dudu maka amefa.” ");
INSERT INTO kqc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kamini minari feresi Jordan koru di berou eta rofu Judea gaganiri boi neyo, ma amiye tau gade dudusa egogo reyadi, ye ini vegu kana dudusa nioteimagamo. ");
INSERT INTO kqc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ye Pharisee vene ini uka maina regika nivegi ina rofu baesi nikaiteyadi, “Rumana yaku ini rema mesi ferego bi ago gira ukero vau rido ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma nikabai reyo, “Moses bi beika ago gira ya maro?” ");
INSERT INTO kqc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma ina yaku niyadi, “Moses bi ago ni diyo bi rema ferena fefa bura resi nifeideyainedi.” ");
INSERT INTO kqc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma niyo, “Yi uka gira kiki dada, bi ya rofu mina ago gira bura reyo. ");
INSERT INTO kqc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Idu ini adinari gutuna beika baika riyori, ‘Sei yaku bi rema ma rumana riyo.’ ");
INSERT INTO kqc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mina dada rumana ini nono baba feresi etagae riyo, ini remasa roaita gogo nigedi.’ ");
INSERT INTO kqc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ye ina bi dudusa remanu de, idu ‘yokoi maka nigedi.’ ");
INSERT INTO kqc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mina dada beika Sei yaku moi gogo resi moi yokoi maka riyo, bi amiye yaku ga moi etagae riyagane.” ");
INSERT INTO kqc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ye, mina yavari amegamadiri, Iesu di usi dina vene yaku dudusa nikaiteyadi, mina ago di adina dada. ");
INSERT INTO kqc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Niyo, “Kaere amiye ini rema nifeidesi rema bouna mego, bi koa rego, mina rema bouna dada. ");
INSERT INTO kqc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma rema yaku ini rumana ka nifeidesi rumana bouna mego vonisi, ina bi koa rego.” ");
INSERT INTO kqc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kamini be vene yaku ina rofu mida keika keika afei baeyadi bi avaka moiyainedi, idu ini usi dina vene yaku nivaiyadi. ");
INSERT INTO kqc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ye Iesu mina veyori, gubuyo resi niyo, “Mida keika keika bi ferefo kumo na rofu baeyagane; ga meki refo, adina Sei di ourefeidena amena sana bi mina kana vene di. ");
INSERT INTO kqc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rama ya nida, kaere amiye yaku Sei di ourefeidena amena sana mida keika kana de moigo vonisi, bi de iniye iniye dui rego.” ");
INSERT INTO kqc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ye mida keika keika binu masi ini vana ina vene fafau aegasa buni tora gade maro. ");
INSERT INTO kqc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kamini bi ida nana regamori, amiye yokoi raga bosi ini budari efuka meimisi usa niyo, “Oteimana amiye buni, beika regida bi toga toga ameibobina vegu moigida?” ");
INSERT INTO kqc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Iesu yaku niyo, “Beika resi na rofu bi buni vo nisa? Amiye yokoi bi buni de; Sei iniye maka bi buni. ");
INSERT INTO kqc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ya ya diba ago gira di ago bi: ‘Amiye umuyena ga re; koa ga re; duma duma ga re; amiye di vegu fafau ofa ofa ago ga ni; amiye rofu moi ofa nina ga re; yi nono baba emagui re.’” ");
INSERT INTO kqc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ye mina amiye yaku niyo, “Oteimana amiye, na keikari gutuna mina kana vegu ago tau vakoi moi gira rei baeda.” ");
INSERT INTO kqc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma vegasa uka masi niyo, “Yokoi maka bi de reyo; bosi yi gugura tau mina sero resi fore bi irava vene ma, yi gugura buni bi omari baku regiya; na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Idu mina ago rofu mokei toe reyori, bi ini uka yarena iniye reyo, adina ina bi gugura tau gade nufa. ");
INSERT INTO kqc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu bi ne kero resi ini usi dina vene rofu niyo, “Gugura tau gade nufa vene yaku Sei di ourefeidena amena sanari dui rena bi gira iniye!” ");
INSERT INTO kqc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ini usi dina vene bi ini agori tururu reyadi. Idu bi dudusa niyo, “Mida mida, Sei di ourefeidena amena sanari dui rena bi gira iniye! ");
INSERT INTO kqc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelo yaku niduru nemokori dui rego bi aita, idu gugura tau gade nufa amiye yaku Sei di ourefeidena amena sanari dui rena bi gira iniye.” ");
INSERT INTO kqc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ye mina ago rofu besa tururu iniye resi iniye iniye niyadi, “Kamini kaere moi vegu rigo?” ");
INSERT INTO kqc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma vesi niyo, “Amiye yaku anua regedi, idu Sei rofu bi de; ina rofu tau rena bi aita iniye.” ");
INSERT INTO kqc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kamini Peter ina rofu nigi kora reyo, “Ve kumo, uni beika baika tau vakoi feresi ya usi diyafa.” ");
INSERT INTO kqc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu yaku niyo, “Rama ya nida, amiye yokoi yaku ini yava, o usika ourena, o nono baba, o mida o kono na dada ma ago buni dada fereyo vonisi, ");
INSERT INTO kqc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bi gua 100 kana tau besa ini yava, ma usika ourena, ma nono, ma mida, ma kono, ka esika esika moigo. Ma gabi mina meda baegori, toga toga ameibobina vegu moigo. ");
INSERT INTO kqc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Idu amiye tau gade kaere bi ourededi, bi gabi nigedi, ma gabi nidedi vene yaku ouregedi.” ");
INSERT INTO kqc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kamini ini usi dina venesa Jerusalem bogamadiri, Iesu bi oureyo, ma ini usi dina vene bi tururu reyadi ma kaere usi diyadi vene ka ori reyadi. Dudusa ini amiye 12 moi gaima risi beika ina rofu vata nigo mina niyo. ");
INSERT INTO kqc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Resi niyo, “Una bi Jerusalem bogifa, ma Amiye di mida siri resi Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene rofu magedi. Ina vene yaku kota regedi bi muyeyaine, ma tutubena idana vene rofu magedi umuyegedi dada. ");
INSERT INTO kqc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ina rofu nikurusi ayaka su resi umuyegedi. Idu gabi meda regoderi, dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kamini James ma John, Zebedee di mida mida, ina rofu baesi niyadi, “Oteimana amiye, uni ura bi beika ya rofu usa nigifa bi una rofu re.” ");
INSERT INTO kqc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma nikaiteyo, “Ya ura rededi bi beika ya rofu regida?” ");
INSERT INTO kqc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma nikabai reyadi, “Yi vabarari una yokoi bi yi vana rama rofu aesi yokoi bi yi enana rofu aegiya.” ");
INSERT INTO kqc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Idu Iesu yaku niyo, “Ya beika usa nidedi bi ya ya toto. Na biyori irigida o babatiso rego, mina kana regedi ba?” ");
INSERT INTO kqc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ye nikabai reyadi, “Mina bi buni regifa.” Ma niyo, “Na biyori irisi babatiso regida, mina kana ya irisi babatiso regedi. ");
INSERT INTO kqc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Idu nai vana rama rofu o enana rofu ameinu rena di vava bi na yaku de ya magida, idu mina bi kaere kaere dogo reyo vene di.” ");
INSERT INTO kqc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ye amiye 10 mina neidesi bi James ma John rofu gubuyo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Iesu yaku raka nisi niegogo resi niyo, “Ya ya diba tutubena idana vene di ourefeidena vene, kaere vei mama rededi, yaku amiye fafau ini vava moi raga rededi; ma ini tora vene yaku ini vava dudu beika vegu rigedi, amiye ini gabireri ago gira nidedi. ");
INSERT INTO kqc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ye yi fogori bi makai de, idu kaere yi fogori ini ura tora nigo vonisi, bi yi naivo rena amiye nigo. ");
INSERT INTO kqc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma kaere yi fogori ya ouregi ura redo, bi amiye tau vakoi di moimai rei tavoi redo amiye nigo. ");
INSERT INTO kqc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Adina Amiye di mida ka deyo, diya amiye naivo reyaganedi, idu bi amiye naivo regi ma ini vegu magi, amiye tau di vegu no reyadi voi regika.” ");
INSERT INTO kqc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kamini Jericho taoniri okiyadi. Ye Iesu ma ini usi dina vene ma amiye tau gade minari gutuna feregamadiri, ne taufa amiye roka Bartimaeus bi ida atafu amegamo. Ina bi Tameus di mida, kaere bi usa nigamo amiye. ");
INSERT INTO kqc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ye neideyo bi Iesu Nazareth amiye bi mini, kamini raka nigi kora resi niyo, “Iesu, David di tutubena, na iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Emaradi babo niyaine vo niyadi, idu besa raka niyo, “David di tutubena, na iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ye Iesu are resi niyo, “Raka nifa.” Ma ne taufa amiye raka nisi niyadi, “Uka gira nisi are rei gira re! Ina bi ya raka nido.” ");
INSERT INTO kqc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ye ini bou varuka makusi dadisi are resi Iesu urana reyo. ");
INSERT INTO kqc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu yaku nikaiteyo, “Ya ura reisa bi beika ya rofu regida?” “Oteimana amiye, na ura reida bi dudusa gagani vegida.” ");
INSERT INTO kqc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma ina rofu niyo, “Di, yi mokena vari gira aena yaku ya moi buni riyo.” Ma evade maka, dudusa gagani vesi Iesu usi idama boyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kamini Jerusalem ri bae ekaira resi Bethphage ma Bethany taoni keika Olive yabo di omuna adina boyadiri, Iesu bi ini usi dina amiye remanu nifeidesi ");
INSERT INTO kqc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","niyo, “Rautu yokoi yi buda rofu bofa. Mina sanari evade boi okigediri, bi donkey di mida ukita riyadi baku regedi; amiye yokoi yaku keu rina kode. Younesi moi baefa. ");
INSERT INTO kqc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ye amiye yokoi yaku ya nikaitego beika resi makai rededi nigo vonisi, bi nifa, ‘Varika amiye yaku ura redo dada,’ ma minari evade nifeidego.” ");
INSERT INTO kqc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ye ferei nesi donkey di mida ida venari ukita riyadi, mina baku resi ini maena youneyadi ");
INSERT INTO kqc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ma amiye be mironari are regamadi yaku nikaiteyadi, “Ya bi beika resi mina donkey di mida di maena younededi?” ");
INSERT INTO kqc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma nikabai reyadi Iesu niyo kana, ma mina vene yaku fereyadi ma moi diyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma donkey di mida Iesu rofu moi baesi ini bou varuka, fafau youyadi ma Iesu keu riyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma amiye tau yaku ini fafau varuka moisi idau ibu reyadi, ma be bi yabo teteka kono gutuna nugasi idau ibu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kamini amiye be kaere ouregamadi ma be bi usi digamadi ma raka nigamadi, “Sei di roka moi odoro ri! Sei buni tora gade ma, kaere bi Varika amiye di rokari baedo! ");
INSERT INTO kqc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sei uni baba buni tora gade mado, kini David di ourefeidena amena sana baedo! Sei oma odoro iniye di roka moi odoro ri!” ");
INSERT INTO kqc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mina usi Jerusalem ri okisi Sei nivakena yavari dui resi mina gagani veitao reyo. Idu ari bi koina niyo dada, ini usi dina vene 12 sa Bethany urana diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ari uveyori, Bethany fereyadiri, Iesu bi rauna reyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ye gaima gutunari, bi fuka yabo kana yuveita iye nufa vesi, vegika fuka be baku rego ba ide atafu baeyo. Idu atafu baeyori, bi yuveita iye maka baku reyo, adina mina bi diya meko varena meda. ");
INSERT INTO kqc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kamini mina fuka yabo rofu niyo, “Amiye yokoi toga toga ya rofu meko ga iriyaine!” Ma ini usi dina vene mina ago neideyadi. ");
INSERT INTO kqc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kamini Jerusalem okiyadi ma Iesu bi Sei nivakena yavari dui resi bi sero rena vene ma voi rena vene umeki rei feidegi kora reyo. Fore senesi rena vene di teiboro ma pune erena sero rena vene di amena fata moi evairo riyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sei nivakena yavari diga bogasa gugura tau uakaigamadi ka biri riyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Resi nioteimagasa niyo, “Sena bura reyo, ‘Nai yava bi gagani gagani vene tau gade di usa usa nina yava vo nigedi.’ Idu ya vene yaku duma duma vene di sui nina yava kana reyadi!” ");
INSERT INTO kqc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kamini Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene mina ago neidegasa gokai dudu Iesu umuyegedi di ida maina regamadi, adina ina rofu ori reyadi, amiye tau ini oteimagamo ago neidesi tururu regamadi dada. ");
INSERT INTO kqc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Uru nigika regamori, bi Iesu ini usi dina venesa bi taoni feresi yakuyadi. ");
INSERT INTO kqc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Uriyaku, idama nana rei baegamadiri, mina fuka yabo ne rei veyadi. Ye ini daruri gutuna abiye niyo. ");
INSERT INTO kqc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter beika vata niyo mokesi niyo, “Oteimana amiye, ve kumo! Ya yaku nikiraini reyo fuka yabo bi abiye niyo!” ");
INSERT INTO kqc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ye nikabai reyo, “Sei rofu mokena vari gira aefa. ");
INSERT INTO kqc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rama ya nida, amiye yokoi yaku mina omuna rofu nigo, ‘Ya kaya dadisi moka daidai tora ideri you,’ ma ini ukari mokei itu de rego, ye beika nido bi vata nigo, mina rofu mokena vari gira aego vonisi, bi ina rofu vata nigo. ");
INSERT INTO kqc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mina dada ya nida, moigedi kana mokena vari gira aesi beika baika tau rofu usa usa nigedi bi moigedi. ");
INSERT INTO kqc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Are resi usa usa nigediri, ye amiye yokoi ya rofu vegu no reyo vonisi, ini vegu no moi erufufa. Makai regediri, yi Baba omari ka yi vegu no koite makugo.” ");
INSERT INTO kqc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kamini dudusa Jerusalem ri dairi baeyadi. Ye Iesu bi Sei nivakena yavari nana rei bogamori, Sei ma amiye utari naivo vene di varika vene, ago gira oteimana vene, ma tora vene ina rofu baesi ");
INSERT INTO kqc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nikaiteyadi, “Beika vava dudu mina vegu reisa? Ma kaere yaku mina vava ya maro ma reisa?” ");
INSERT INTO kqc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma nikabai reyo, “Nai nikaitena bi yokoi maka. Na nikabai regedi vonisi, ya nigida beika vava dudu mina vegu reida. ");
INSERT INTO kqc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na nifa, John di babatiso rena bi oma gutuna ba amiye gutuna deyo?” ");
INSERT INTO kqc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ye iniye iniye nidodi resi niyadi, “‘Oma gutuna,’ nigifa vonisi, ina yaku nikaitego, ‘Ma beika resi ina rofu mokena vari gira de aeyadi?’ ");
INSERT INTO kqc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Idu ‘Amiye gutuna… ’ nigifa ba?” (Bi amiye tau gade ori reyadi, adina rama iniye bi amiye tau vakoi mokeyadi John bi Sei di ago niyo amiye yokoi.) ");
INSERT INTO kqc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ye nikabai reyadi, “Una una toto.” Ma niyo, “Na yaku ka makai de ya nigida na bi beika vava dudu mina vegu reida bi.” ");
INSERT INTO kqc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kamini mokena ago nigi kora reyo: “Amiye yokoi bi waini meko di muro varisi kota mina buru risi waini meko etei rina di kono ruba goesi ota rina vene di fata risi muro nari rena vene be ini nanaka nimasi yava ika oto diyo. ");
INSERT INTO kqc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mina usi butu rena di meda okiyori, bi ini moimai rei tavoi redo amiye yokoi muro nari rena vene rofu nifeideyo, ma waini meko vareyo, mina bi butu reyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Idu bi mina moimai rei tavoi redo amiye moi gira resi ubobo resi vana notoka nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kamini dudusa ini moimai rei tavoi redo amiye yokoi ina vene rofu nifeideyo, idu ini ada usi ni moi maena reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dudusa yokoi nifeideyo, idu bi umuyeyadi. Ina bi besa ma nifeideyo, idu bedakai bi uyadi ma bedakai bi umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ye inasa bi yokoi maka amegamo, ini uka mado mida. Ina bi gabi koukou nifeidesi niyo, ‘Nai mida bi matagini regedi.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Idu muro nari rededi vene yaku iniye iniye niyadi, ‘Mina bi muro adina amiye nigo. Nesi umuyenadi, ma beika baika ini baba ferego bi uni nigo!’ ");
INSERT INTO kqc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ye moi gira resi umuyesi waini meko di muro etofarori makuyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ye waini meko di muro adina amiye bi gokai beika be rego? Ina bi baesi muro nari rededi vene umuyesi muro bi bouna vene mago. ");
INSERT INTO kqc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ya bi Sei di agori mina bura veyadi ba? ‘Yava akuna vene moi kekevata uyadi fore bi yava moi gira redo fore iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mina bi Varika amiye yaku reyo; ma uni nemokori bi buni vayavaya!’” ");
INSERT INTO kqc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma ina moi gira regika ida maina reyadi, adina diba niyadi mina mokena ago ina vene fafau niyo. Idu amiye tau gade rofu ori reyadi, dada feresi diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gabi Pharisee ma Herod di vene bedakai nifeideyadi, ini ago nigori, eru regedi. ");
INSERT INTO kqc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ye baesi niyadi, “Oteimana amiye, una una diba ya bi sina rama maka nisa amiye. Ya bi amiye rofu de ori reisa, ini adina bi amiye gokai kana bi de mokeisa, idu sina rama dudu maka, Sei di ida oteimaisa. Caesar rofu takesi fore fei rena bi uni ago gira rofu rorobo ba ide? Fei bi regifa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Idu bi sena ini ofarosi sina vei diba resi nikaiteyo, “Beika resi nai uka maina regika nivededi? Siriva fore yokoi na rofu moi baefo kumo vegida.” ");
INSERT INTO kqc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma fore moi baeyadi, ma nikaiteyo, “Mina bi kaere di roka?” Ye nikabai reyadi, “Caesar di.” ");
INSERT INTO kqc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kamini niyo, “Beika Caesar di, bi Caesar mafa, ma beika Sei di, bi Sei mafa.” Ma ini ago rofu tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kamini Sadducee vene be, kaere bi niyadi dadi rae rena bi koina, bi Iesu rofu baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Resi nikaitegasa niyadi, “Oteimana amiye, Moses yaku una rofu bura reyo bi: ‘Amiye kaere ini dubuini muyesi ini rema ferego, idu mida bi koina, mina amiye bi ini obu mesi ini dubuini di mida moiyainedi.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yokaru bi dubuiyaka 7 amegamadi. Ourena bi rema meyo, idu muyeyo, mida yokoi de. ");
INSERT INTO kqc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ini usi vata niyo amiye ka makai mesi muyeyo, mida yokoi de. Ye mina usi amiye ka makai reyo. ");
INSERT INTO kqc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mina vegu yokoi maka mina dubuiyaka 7 tau noibanu rofu vata niyo—ina tau noibanu mida de muyeyadi. Gabi koukou mina rema ka muyeyo. ");
INSERT INTO kqc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ye dadi rae renari, ina bi kaere di rema nigo, adina bi amiye 7 tau noibanu yaku meyadi?” ");
INSERT INTO kqc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma nikabai reyo, “Ya forovai rededi ba, Sei di ago ma ini vava ya ya toto dada ba? ");
INSERT INTO kqc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Adina muyena gutuna dadi rae regasa bi iniye iniye de megedi, idu omari naivo naivo vima kana nigedi. ");
INSERT INTO kqc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Idu muyena vene dadi rae regedi dada, ya Moses di bura renari bura veyadi ba ide? Vaigamo yabo di agori gokai Sei yaku niyo, ‘Na bi Abraham di Sei, Isaac di Sei ma Jacob di Sei.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ina bi vegu ameibobina vene di Sei, diya muyena vene di Sei. Ya bi forovai tora reyadi!” ");
INSERT INTO kqc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma ago gira oteimana amiye yokoi baesi bi ini nidodi regamadi ago neideyo. Ye Iesu yaku rama rorobo dudu ago nigamo mina neideyori, bi nikaiteyo, “Ago girari goina bi tora iniye?” ");
INSERT INTO kqc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma niyo, “Tora iniye bi yomini, ‘Neidefo Israel vene, Varika amiye uni Sei ina bi Varika amiye yokoi maka. ");
INSERT INTO kqc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma yi uka meko noibanu, yi vima noibanu, yi mokena noibanu, ma yi yeiva tora noibanu dudu Varika amiye yi Sei uka magiya.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma mina usi bi yomini: ‘Ya kaya uka maisa kana, yi atafu amedo amiye uka magiya.’ Ago gira tora yokoi de, mina remanu maka.” ");
INSERT INTO kqc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ago gira oteimana amiye Iesu rofu niyo, “Oteimana amiye ya bi rama niyo; ya bi rorobo iniye niyo, ‘Sei bi yokoi maka; sei bouna de, idu ina maka.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma yi uka meko noibanu, yi mokena noibanu, ma yi yeiva tora noibanu dudu Sei uka mana ma yi atafu amedo amiye uka mana, yaku aira ori kamu rena ma vibani ori sisika rena tau mina ebu rededi.” ");
INSERT INTO kqc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kamini Iesu veyo ina bi ni mona iniye reyo ye niyo, “Ya bi Sei di ourefeidena amena sanari bi maike de ameisa.” Ye amiye yokoi yaku dudusa nikaitegika bi de regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kamini Iesu bi Sei nivakena yavari amiye oteimagasa nikaiteyo, “Gokai bi ago gira oteimana vene yaku nidedi Keriso bi David di tutubena? ");
INSERT INTO kqc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David iniye Vima kikifa di vava dudu niyo: ‘Varika amiye yaku nai Varika amiye rofu niyo: Nai vana rama eta rofu ameinu re bogo na yaku yi tuma vene yi yuka aena sana kana rigida mamo.’ ");
INSERT INTO kqc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David iniye yaku ‘Varika amiye,’ vo niyo, ye gokai ida dudu ina bi ini tutubena?” Amiye tau gade gade ada dudu ini ago neidegamadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ye ini oteimana ago bi yomini: “Vei mona refo ago gira oteimana vene rofu, kaere varuka doba dudu nana regika ma maketiri amiye yaku ago buni dudu matagini reyagane, ");
INSERT INTO kqc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ma usa usa yavari ma irakuna sanari amena sana ka buni torari ura rededi. ");
INSERT INTO kqc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ina vene yaku obu vene di gugura ka duma resi ofa dudu usa usa doba nioteimadedi. Mina kana vene, ini kaunava bi tora iniye.” ");
INSERT INTO kqc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Resi bi Sei nivakena yava di fore aena mauari berou eta rofu ameinu resi amiye ini fore aegamadi mina vegamo. Amiye gugura tau nufa bi fore tora aegamadi. ");
INSERT INTO kqc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Idu obu irava baesi bi fore keika keika remanu aeyo, di yeiva bi keika iniye. ");
INSERT INTO kqc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma ini usi dina vene nirutu resi niyo, “Rama ya nida, mina gugura de nufa obu irava bi tora iniye aeyo, ma mina amiye tau yaku aeyadi bi ebu reyo. ");
INSERT INTO kqc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Adina ina tau bi fore tora tora ini gugura tau fafau aeyadi, idu mina rema ini gugura nufa de, bi ini tora noibanu aeyo; mina bi ini fafau ameibogo gugura.” ");
INSERT INTO kqc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kamini Iesu Sei nivakena yava ferei diyori, ini usi dina amiye yokoi yaku niyo, “Oteimana amiye, ve kumo, mina fore bi buni iniye! Ma mina yava bi buni vayavaya!” ");
INSERT INTO kqc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kamini nikabai reyo, “Mina yava tora tora veisa ba? Minari fore fafau fafau amededi gabi yokoi de amegedi; mina tau gade varadaugedi.” ");
INSERT INTO kqc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kamini Iesu bi Olive yabo omunari Sei nivakena yava berou rofu amegamori, Peter, James, John ma Andrew yaku sui dudu ina rofu baeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Resi nikaiteyadi, “Una ni, mina bi goivaka vata nigedi? Mina tau vata nigedi di rebe bi beika?” ");
INSERT INTO kqc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma nigi kora reyo, “Nari rei mona refa; yokoi yaku ya eruna ga reyaine. ");
INSERT INTO kqc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Amiye tau gade nai roka dudu baesi iniye nikake regedi, ‘Na bi Keriso,’ resi amiye tau gade eru regedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Idu iya rena negau ma iya rena maike di sina neidegediri, mina yaku yi uka ga dadiyaine. Mina kana bi vata niyaine, idu ari metona bi baena kode. ");
INSERT INTO kqc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Adina gagani tora iniye iniye ma ourefeidena vene iniye iniye ruda regedi. Gagani bedakairi, bi kono yagayaga regedi ma adabo ogau nigedi. Mina bi mida odina gera rena esika bae kora regedi kana. ");
INSERT INTO kqc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ye ya kaya nari rei mona refa. Kanisoro vene di vanari ya siri resi ini usa usa yavari ubobo regedi. Na dada ya moi gavana ma kini di nemokori are resi ina rofu nai ago ninegau regedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma gagani gagani tauri ago buni siko nirausi reyaine. ");
INSERT INTO kqc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kamini kota regi ya afei bogediri, gokai ago nigedi bi mokena toe ga moifa. Idu, mina medari, beika ya mago, ya yaku nigedi, adina bi diya ya yaku sina nidedi, idu bi Vima kikifa yaku. ");
INSERT INTO kqc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma usika ourena yaku usika ourena muyena rofu siri rego, ma baba yaku ini mida rofu makai rego. Mida mida yaku ini nono baba rofu tourage regedi ma umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma amiye tau gade yaku nai roka dada ya rofu gubuyo regedi, idu kaere are rei gira rego bogo ari metona baego mamo bi moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bura veisa amiye bi ada yora niyaine: Ye vegu no iniye redo amiye are ga reyaine sanari are rego vegediri, bi ya kaere Judea gaganiri, bi omuna rofu ori difa. ");
INSERT INTO kqc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma yava tebo odorori amiye bi nesi ini yava dui rei ga bosi ini gugura fore moi yakuyaine. ");
INSERT INTO kqc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma murori amedo amiye bi ini fafau varuka moigi ga dairiyaine. ");
INSERT INTO kqc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Idu mirona ituari, mina vegu no vata nigori, nono kaere bi rivo nufa ma nono ini mida susu irido ina fafau bi no iniye iniye! ");
INSERT INTO kqc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Idu usa usa nifo kumo mina bi avari ogau ga niyaine, ");
INSERT INTO kqc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ini adina mirona medari, bi no tora gade iniye, senagi senagi Sei yaku oma ma kono riyo, baeyo ma gua mina kana bi koina, gabi rofu di, mina kana bi dudusa ogau de nigo. ");
INSERT INTO kqc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ye Varika amiye yaku mina vegu no di ari de moi tumu reyagadu, amiye yokoi moi vegu de riyagadu, idu ini auba reyo vene dada, mina ari moi tumu rego. ");
INSERT INTO kqc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kamini amiye yokoi yaku ya nigo vonisi, ‘Ve kumo, Keriso bi yomini!’ ma ‘Ve kumo, ina bi yomironi!’ ini ago rofu mokena vari gira ga aefa. ");
INSERT INTO kqc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ini adina bi, Keriso ofa vene ma Sei di ago nidedi ofa vene ogau nisi rebe ma mokena vegu dudu, Sei di auba reyo vene ofa dudu eru regedi, vata nigo vonisi bi. ");
INSERT INTO kqc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ye nari refa; na bi beika tau ogau nigedi bi ari dobau sena ya niyaka. ");
INSERT INTO kqc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Idu mirona ari ini toe nigo mamo gabi meda bi mukuna nigo ma eyo bi ini vabara de kikigo, ");
INSERT INTO kqc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","iya bi omari gutuna yarei degedi, ma omari ini vava amededi, mina ka moi tururu regedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mina usi amiye yaku Amiye di mida seuyari vava ma vabara tora nufa debigo bi vegedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma ini naivo naivo vima nifeidego, ma ini auba reyo vene kono tora noibanu gutuna ma kono di berou berou noibanu gutuna oma berou berou noibanuri moi egogo regedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gua fuka yabo rofu mokefa. Ini bobo ruika fiu nisi iye imu regori, ya bi diba nigedi amona bi bae negau nido. ");
INSERT INTO kqc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mina dada, mina ogau nibigedi ma vegediri, bi ya ya diba ari bi negau nigi rego. ");
INSERT INTO kqc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rama ya nida, gua ari amededi vene bi muyei vau rena koderi, bogo mina beika baika tau gade vata nigedi mamo. ");
INSERT INTO kqc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Oma ma kono bi roro nigedi, idu nai ago bi roro de nigedi. ");
INSERT INTO kqc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Idu amiye yokoi mirona meda, o meda nemoko bi toto, oma di naivo naivo vima ka ina toto, Mida ka ina toto, idu Baba iniye maka ina diba. ");
INSERT INTO kqc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ya vene bi nari rei mona refa! Adina ya ya toto ari metona baego bi. ");
INSERT INTO kqc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mina bi amiye yokoi yava ika oto dina kana: Ini yava feresi ini moimai rei tavoi rededi vene vanari aesi ina yokoi yokoi bi ini moimai neinei mago. Ye yava ida vena nari rego amiye maka bi nioteimago, nemoko kikigasa amego. ");
INSERT INTO kqc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mina dada nari rei gira refo, ini adina bi ya ya toto yava biyaguna amiye goivaka baego, bi uriyenauri, urusa tobori, kokoro koo- nigori, ba uriyaku gorogoro okigo. ");
INSERT INTO kqc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Evade maka okigori, varebigedi ma ga ya veitao reyaine. ");
INSERT INTO kqc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Beika ya vene rofu ya nida, amiye tau rofu nigida: nemoko kikifo!” ");
INSERT INTO kqc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ferei ebu rena irakuna ma Beredi yeast de nufa di irakuna bi gabi meda remanu maka di fufutari vata nigedi. Ma Sei ma amiye utari naivo vene di varika vene, ma ago gira oteimana vene bi Iesu buoru rigi moi gira resi umuyegika di ida maina regamadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Adina niyadi, “Idu mina irakuna fuofuori bi de regifa, adina bi amiye siboroka regedi baebu.” ");
INSERT INTO kqc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma Iesu bi Bethany ri sena refera nufa amiye roka Simon di yavari amegasa iruku irigamori, rema yokoi yaku fore roka alabaster dudu riyadi siua yokoi, ideri bi diga roka nard sisika buni vayavaya, mina moi boyo. Diga bi fore tora gade dudu voi rededi. Mina rema yaku siua ini diga nufa uratokusi ini adari erausi reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Minari amededi vene bedakai bi gubuyo resi iniye iniye niyadi, “Beika resi mina diga ini sisika buni bi maku tavoi reyo? ");
INSERT INTO kqc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mina diga di sisika buni bi besa siriva fore 300 dudu voi resi fore bi irava vene maragadu!” Ye emaradi. ");
INSERT INTO kqc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Idu Iesu yaku niyo, “Mina rema ferefa! Beika resi toe madedi? Ina bi na rofu vegu buni vayavaya reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Adina irava vene bi yasa toga amebigedi, ma goina medari yi mokegedi, bi mina vene aedegedi. Idu na bi toga yasa de amebigida. ");
INSERT INTO kqc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ina beika rego, bi reyo mini; ina yaku diga nai roaitari erausi reyo, bi dobau na guri aegedi dada na dogo reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rama ya nida, kono tora noibanuri, bi mina ago buni nirausi regediri, ka mina rema yaku ini beika reyo mina oteimagedi, ina ka mokeyagane.” ");
INSERT INTO kqc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kamini Judas Iscariot, kaere bi Iesu di usi dina amiye 12 yokoi, bi Iesu siri regi Sei ma amiye utari naivo vene di varika vene rofu boyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mina neidegasa ada tora gade resi Judas rofu nitore reyadi fore magedi, vo niyadi. Ma gokai siri rego di ida maina reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ouresi medari, Beredi yeast de di irakunari, Ferei ebu rena irakuna di Mamoe mida ori sisika reyadiri, Iesu di usi dina vene yaku nikaiteyadi, “Yi ura bi goina sana dogo regifa ma yi Ferei ebu rena irakuna di iruku irigiya?” ");
INSERT INTO kqc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ye ini usi dina vene remanu nifeidesi niyo, “Taoni ideri bosi mironari amiye yokoi koru urena megeari aesi ya baku regori, ina usi difa. ");
INSERT INTO kqc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Goina yavari dui rego, bi yava biyaguna amiye nioteimafo, ‘Oteimana amiye yaku niyo, Goina daiyutu bi nai usi dina venesa Ferei ebu rena irakuna di iruku irigifa?’ ");
INSERT INTO kqc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma mina yava amiye yaku odorori daiyutu tora ya oteimago. Mina bi sena veika reyadi. Mironari uni iruku dogo refo.” ");
INSERT INTO kqc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma feresi taoniri dui resi bi gokai ago niyo kana, mina veitao resi Ferei ebu rena irakuna di iruku dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kamini uriyenau niyori, Iesu bi ini usi dina vene 12 sa okiyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Amegasa iruku irigamadiri, Iesu yaku niyo, “Rama ya nida, kaere nasa iri-iri redo ya yokoi yaku na siri rego.” ");
INSERT INTO kqc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iriyeduka regi kora resi yokoi yokoi niyadi, “Rama na bi ide ba?” ");
INSERT INTO kqc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma nikabai reyo, “Mina bi yi fogori 12 yokoi, kaere bi nasa ini beredi siua ideri birisifa. ");
INSERT INTO kqc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Adina Amiye di mida bi muyego, bura reyadi kana, idu mina amiye rofu bi iriyeduka no iniye, kaere bi Amiye di mida siri rego! Buni bi mina amiye bi vata de niyagadu!” ");
INSERT INTO kqc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kamini iruku irigamadiri, Iesu bi beredi be moisi Sei rofu buni tora gade masi uroki resi ina vene magasa niyo, “Moifa, mina bi nai roaita.” ");
INSERT INTO kqc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Resi biyo moisi Sei rofu buni tora gade masi ina vene maro ma ina tau vakoi gaga reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma niyo, “Mina bi nai dava, Sei di uka ago regi amiye tau gade rofu rausi reyaka. ");
INSERT INTO kqc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rama ya nida, na bi dudusa mina waini meko di ona de gaga regida, mirona medari bogo Sei di ourefeidena amena sanari waini ruaka gaga regida mamo.” ");
INSERT INTO kqc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kamini yauta niga yakusi Olive yabo amededi omuna ikari boyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma Iesu ina vene rofu niyo, “Tau vakoi bi feresi ori digedi, adina bi bura reyo, ‘Mamoe dogo redo amiye umuyegida, ma mamoe bi rerevaida nigedi.’ ");
INSERT INTO kqc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Idu gabi dadi rae regidari, na siko Galilee ri ourei bogida.” ");
INSERT INTO kqc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Idu Peter niyo, “Mina tau bi ya feresi ori digedi, idu na bi de!” ");
INSERT INTO kqc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma nikabai reyo, “Rama ya nida, kokoro gua mina urusari uru remanu raka nina koderi, bi uru regode na nisui regiya.” ");
INSERT INTO kqc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Idu Peter ago nigira resi niyo, “Yasa muyegida vonisi, ida yokoi dudu ya nisui de regida.” Ma ina tau vakoi makai ka niyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kamini gagani roka Gethsemane ri boyadi, ma Iesu yaku ini usi dina vene rofu niyo, “Na usa usa nigidari, bi minari amefa.” ");
INSERT INTO kqc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Resi bi Peter, James ma John inasa afesi uka kenoka moigi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Resi niyo, “Iriyeduka tora yaku nai vima vata baeyo, ye makai muyegida kana amuteida. Minari amesi varena ga refa.” ");
INSERT INTO kqc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kamini inaike etagae risi konori raudai regasa usa usa niyo, ye buni mirona meda nemoko bi ina rofu moi etagae riyaine. ");
INSERT INTO kqc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Resi niyo, “Baba, nai baba, vegu tora gade ya rofu bi aita maka. Mina esika esika di biyo na rofu moi etagae rigiya. Idu, yi ura mina resi nai mokena dudu bi ga regiya.” ");
INSERT INTO kqc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kamini ina vene rofu dairisi veitao reyo ina bi varegamadi. Ma Peter rofu niyo, “Simon, ya bi vareisa ba? Ya bi meda nemoko yokoi maka nemoko kikigi yeiva nufa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Nemoko kikigasa usa usa nifa kumo yi uka maina regika nivenari regedi baebu. Vima bi regi ura redo, idu roaita bi afi nido.” ");
INSERT INTO kqc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Resi dudusa etagae risi mina ago dudusa usa usa niyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kamini dairi okisi bi dudusa varegamadi veitao reyo, adina varei muyeyadi. Ina vene bi diba de ina rofu bi beika nigedi. ");
INSERT INTO kqc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma uru regodenu dudusa dairisi niyo, “Ya bi besa sifere regasa varededi ba? Kaini! Meda nemoko bi okiyo. Vefo, Amiye di mida bi siri resi vegu no rededi vene di vanari aegedi. ");
INSERT INTO kqc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dadifo! Una bi dinadi! Vefa, nai siri rena amiye bi baedo mini!” ");
INSERT INTO kqc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Minari maka, Iesu bi ago nigamori, Judas, kaere bi amiye 12 ri yokoi, bi amiye tau gadesa bainasi ma gai nufa okiyadi; Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene ma tora venesa. ");
INSERT INTO kqc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kamini siri rego amiye yaku gokai rego di ida bi sena masi niyo, “Kaere amiye fuka regida bi mini, moi gira resi yi gabireri nari rei gira resi afei difa.” ");
INSERT INTO kqc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ye evade okisi Iesu urana bosi niyo, “Oteimana amiye,” resi fuka reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ye vanau moisi moi gira reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Idu yokoi, kaere ina atafuri are regasa amedo, yaku bainasi moi yakusi kuita resi Sei ma amiye utari naivo amiye tora di moimai rei tavoi redo amiye di anema nugai feideyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kamini Iesu yaku niyo, “Ya vene bi duma duma amiye yokoi kana bainasi ma gai moisi na moi gira regika baeyadi ba? ");
INSERT INTO kqc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ari neinei yasa Sei nivakena yavari amegamafa, idu bi de na moi gira reyadi. Idu Sei di ago di bura reyadi, mina bi bae rama aeyainedi.” ");
INSERT INTO kqc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ye amiye tau vakoi bi feresi ori diyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mida godua yokoi bi varuka keika iru maka risi Iesu usi bogamo. Kamini mina amiye moigika reyadi, ");
INSERT INTO kqc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","idu ini varuka keika fereyo rofu faisara raga reyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kamini Iesu bi Sei ma amiye utari naivo amiye tora rofu afei boyadi, ma tora vene ma ago gira oteimana vene tau gade bi egogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Peter bi egaima risi usi disi mina Sei ma amiye utari naivo amiye tora di yava ida nefau dui resi nari rededi venesa ameinu resi ita imigamo. ");
INSERT INTO kqc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kamini Sei ma amiye utari naivo vene di varika vene ma kanisoro vene noibanu bi ago di adina maina regamadi, gokai dudu Iesu umuyegedi, idu bi ago de baku reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Adina amiye tau gade bi ofa ofa dudu Iesu nikake rigamadi, idu ini sina bi yokoi de. ");
INSERT INTO kqc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ye amiye bedakai bi are resi ofa ofa sina ina rofu nigasa niyadi, ");
INSERT INTO kqc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Una neideyafa ini beika niyo bi, ‘Amiye vana yaku akuyadi Sei nivakena yava bi ukero vau resi meda regodenuri bi dudusa akugida, amiye yaku akuna de mina akugida.’” ");
INSERT INTO kqc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mina sina niyadi, mina ka bi rama aena de reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kamini Sei ma amiye utari naivo amiye tora yaku dadisi ina vene di nemokori nikaiteyo, “Ya bi nikabai regiya ba ide? Mina ago ya rofu nikake rededi bi beika be nigiya?” ");
INSERT INTO kqc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Idu bi bere nisi ago yokoi de nikabai reyo. Dudusa Sei ma amiye utari naivo amiye tora yaku nikaiteyo, “Ya bi Keriso kaere bi Sei buni tora gade mado di Mida ba?” ");
INSERT INTO kqc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma niyo, “Mina bi na; ye Amiye di mida Vava iniye amiye di vana rama rofu ameinu resi seuya omari dudu baebigo ma vegedi.” ");
INSERT INTO kqc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kamini Sei ma amiye utari naivo amiye tora yaku ini varuka uesi resi nikaiteyo, “Beika resi una bi mina ago di adina besa ni maina resifa? ");
INSERT INTO kqc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya bi Sei di roka moi no riyo ago mina neideyadi. Ye ya mokededi bi gokai?” Ina tau vakoi yaku nifafana reyadi bi muyeyaine bi buni. ");
INSERT INTO kqc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma bedakai bi ina rofu ayaka su regi kora resi ini nemoko fafa risi vana kumu risi ugasa niyadi, “Ya bi Sei di ago nido amiye vonisi, beika vata nigo una ni!” Resi nari rededi vene yaku moisi bi ini ragena famaradi. ");
INSERT INTO kqc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ma Peter bi yava ida nefauri amegamori, Sei ma amiye utari naivo amiye tora di naivo rema ofi yokoi baesi ");
INSERT INTO kqc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter veyo bi ita imigasa amegamo, resi niyo, “Ya ka Iesu Nazareth amiyesa.” ");
INSERT INTO kqc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Idu nisui resi niyo, “Na na toto ya beika nisa, bi nai adari ufatena de redo.” Resi ida vena etofarori yakuyo ma kokoro raka niyo. ");
INSERT INTO kqc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kamini mina naivo rema ofi vesi atafuri are regamadi vene rofu dudusa nigi kora reyo, “Mina amiye bi ini asini yokoi.” ");
INSERT INTO kqc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Idu dudusa nisui reyo. Ma doba deri, atafuri are regamadi vene dudusa niyadi, “Rama ya bi ini asini yokoi, adina ya bi Galilee amiye.” ");
INSERT INTO kqc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kamini iniye dudu nikiraini resi iniye nivarika regi kora resi niyo, “Mina amiye ya vene yaku nidodi rededi bi na na toto!” ");
INSERT INTO kqc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma evade kokoro dudusa raka niyo. Kamini Peter bi beika vata nigo di ago Iesu yaku niyo mina mokeyo, “Kokoro uru remanu raka nina koderi, uru regode na nisui regiya.” Mina mokena yaku uyo ma isaka niyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ari uveyori, Sei ma amiye utari naivo vene di varika vene, tora vene ma ago gira oteimana vene bi kanisoro vene tau vakoisa egogo resi nirorotari resi bi Iesu di vana ukita resi afei bosi Pilate di vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ye Pilate yaku nikaiteyo, “Ya bi Jew vene di kini ba?” Ma nikabai reyo, “Yo, ya bi mina niyo.” ");
INSERT INTO kqc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ye Sei ma amiye utari naivo vene di varika vene bi ago tau dudu nitourage reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ye Pilate yaku dudusa nikaiteyo, “Ya bi nikabai de regiya ba? Ya veisa ba de, gokaisanu ago no tau ya rofu nitourage rededi?” ");
INSERT INTO kqc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Idu ago yokoi nikabai de reyo, ye Pilate bi tururu iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ye Ferei ebu rena irakuna neineiri, amiye yaku usa nina kana, Pilate yaku diburari amiye yokoi erufugamo. ");
INSERT INTO kqc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma amiye roka Barabbas bi gavamani rofu ruda rena venesa dibura yavari amegamo. Ina bi mina gavamani rofu ruda rena vegu dudu amiye umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma amiye tau bi Pilate rofu baesi ini mina ari okidori rei baededi kana mina nikaiteyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma nikaiteyo, “Yi ura rededi bi Jew vene di kini moi yakugida ba?” ");
INSERT INTO kqc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Adina Pilate bi sena diba niyo Sei ma amiye utari naivo vene di varika vene bi gonema dudu ini vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Idu Sei ma amiye utari naivo vene di varika vene bi amiye tau gade di uka moiyadi, ye Barabbas moi erufuyainedi. ");
INSERT INTO kqc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ye Pilate dudusa nikaiteyo, “Ye na bi beika mina amiye, Jew vene di kini, vo nidedi, ina rofu regida?” ");
INSERT INTO kqc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma dudusa imuna niyadi, “Satauro ikoko re!” ");
INSERT INTO kqc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Idu nikaiteyo, “Beika resi, ina bi beika vegu no be reyo?” Idu besa imuna niyadi, “Satauro ikoko re!” ");
INSERT INTO kqc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ye amiye tau di uka moi ada regi, Pilate yaku Barabbas ina vene rofu erufusi ago masi Iesu iya rededi vene di vanari aeyo, buburu vai resi satauro ikoko reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kamini iya rededi vene gavana di ourefeidena yava tora ideri afei boyadi. (Mina yava di roka bi Praetorium.) Mina usi iya rededi vene tau vakoi raka niegogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Resi varuka purple aku masi yabo imiye maena nufa moi tetevai rei dae resi kini di ada bou kana ini adari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Resi ofa kikifa regi kora reyadi, “Jew vene di kini o!” ");
INSERT INTO kqc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Resi ini adari kodu dudu usi ina fafau ayaka su resi efuka meimisi ini budari nikurugamadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kamini nikuruna koina niyori, bi varuka purple doba kutusi iniye di varuka aku masi satauro ikoko regi afesi yakuyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kamini Cyrene gagani amiye yokoi roka Simon baku reyadi. Ina bi taoni etofaro gutuna digamori, bi ini satauro uakaiyaine niyadi. Ina bi Alexander ma Rufus di baba. ");
INSERT INTO kqc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kamini bi gagani roka Golgotha ri afei boyadi. Ini adina bi “Ada girika di sana”. ");
INSERT INTO kqc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kamini waini muramura roka myrrh sa maradi, idu moina de reyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma kamini satauro ikoko resi laki dudu isira reyadi kaere yaku ini varuka bi ina yokoi yokoiri bi beika moigedi. ");
INSERT INTO kqc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iesu bi satauro ikoko reyadiri, bi meda nemoko 9:00 uriyaku. ");
INSERT INTO kqc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ini no nikake regi bi yomakai bura reyadi: “Jew vene di kini.” ");
INSERT INTO kqc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kamini duma duma amiye remanu inasa satauro ikoko reyadi, yokoi bi ini vana rama rofu ma yokoi bi ini vana enana rofu. ");
INSERT INTO kqc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma amiye kaere ini budari digamadi, bi nifafana regasa ini ada buro regasa nigamadi, “Ye, ya yaku Sei nivakena yava ukero vau resi meda regodenuri dudusa akugiya, vo niyo! ");
INSERT INTO kqc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Satauro gutuna sokau rei desi ya kaya moi vegu ri!” ");
INSERT INTO kqc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mina ida yokoi makari, Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene ka iniye iniye nikurugasa nigamadi, “Amiye be moi vegu riyo, idu iniye moi vegu rina anua redo! ");
INSERT INTO kqc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mina Keriso, Israel di kini, satauro gutuna soka rei deyaine ma vesi kumo ma ina rofu mokena vari gira aegifa!” Ma kaere bi inasa satauro ikoko reyadi, ka nifafana reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Meda nemoko tobo niyori, gagani tora noibanu bi mukuna yaku fono reyo boyo meda nemoko regodenu koina niyo mamo. ");
INSERT INTO kqc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma meda nemoko regodenuri, Iesu bi ababa nigasa raka ni tora reyo, “Eloi, Eloi, lema sabachthani?” ago di adina bi, “Nai Sei, nai Sei, beika resi na ferei tavoi reyo?” ");
INSERT INTO kqc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kamini amiye be, kaere bi ina atafu are regamadi, mina neidesi niyadi, “Vefo kumo, ina bi Elijah raka nido!” ");
INSERT INTO kqc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Amiye yokoi raga resi sipanisi waini ru dudu vata baesi koduri aesi ina rofu iriyainedi, magasa niyo, “Kode, venadi kumo Elijah desi moi soka rego ba de!” ");
INSERT INTO kqc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma raka tora nisi asa youfeideyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kamini Sei nivakena yava ideri biri rina varuka doba bi odoro gutuna doka rofu uesi rei nesi sireta remanu niyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma iya rededi vene di ourefeidena amiye tora bi Iesu di nemokori are regasa bi gokai muyeyo, mina vesi niyo, “Rama mina amiye bi Sei di mida!” ");
INSERT INTO kqc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma rema bedakai bi gaima gutuna are resi vegamadi. Ini fogori bi Mary Magdalene, Mary, kaere bi usika ere James ma Joseph di nono, ma Salome. ");
INSERT INTO kqc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mina rema vene bi Galilee ri Iesu usi disi moi aedegamadi. Ma rema tau gade kaere bi Jerusalem ri inasa baeyadi ka minari. ");
INSERT INTO kqc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kamini mina bi dogo dogo meda, Sabati meda bi agiya. Ye uriyenau nigi regamori, ");
INSERT INTO kqc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph, Arimathea amiye, kaere bi kikifa reyadi kanisoro amiye yokoi, ma bi Sei di ourefeidena amena sana baego mina tua regamo, bi roaita gira dudu Pilate rofu bosi Iesu di roaita usa niyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma sena muyeyo ago mina neidesi tururu resi iya rededi vene di tora amiye yokoi, mina nikaiteyo bi sena muyeyo ba ide. ");
INSERT INTO kqc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iya rededi vene di ourefeidena amiye tora yaku niyo bi muyeyo ma Pilate mina neidegasa Joseph rofu niyo bi ini roaita moi digo. ");
INSERT INTO kqc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ye Joseph bi varuka buni voi resi ini roaita moi soka resi mina varuka dudu kumu risi kono guri, bi fore ideri goeyadi, bi ini roaita mina ideri aeyo. Kamini fore moi kurevai resi guri di ida vena biri riyo. ");
INSERT INTO kqc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Mary Magdalene, ma Mary, kaere bi Joseph di nono, bi ina aeyadi sana veyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kamini Sabati meda koina niyori, Mary Magdalene, Mary, kaere bi James di nono, ma Salome bi Iesu di roaitari aegika sisika buni muramura voi reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma ari uveyori, uriyaku gorogoro iniye, fura di ourena medari, mina rema vene bi guri vegi bogasa ");
INSERT INTO kqc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","iniye iniye nikaiteyadi, “Kaere yaku guri di ida venari fore biri riyadi, mina uni moi kurevai rei etagae rigo?” ");
INSERT INTO kqc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ye ne resi veyadi, bi mina fore bi sena moi kurevai rei etagae riyadi; mina fore bi tora iniye. ");
INSERT INTO kqc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kamini guri sana ideri dui resi bi amiye ruaka varuka doba feyo akusi vana rama rofu amegamo, mina vesi tururu iniye iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Idu niyo, “Tururu ga refa, Iesu Nazareth amiye, kaere bi satauro ikoko reyadi, mina maina rededi. Ina bi dadi rae reyo! Bi minari de amedo. Ini aeyadi sana vefo. ");
INSERT INTO kqc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Idu bosi ini usi dina vene ma Peter nioteimafa, ‘Ina siko Galilee urana bodo. Bi mironari baku regedi, ini niyo kana.’” ");
INSERT INTO kqc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ye mina rema vene bi roaita tururu resi ori dudu guri sanari gutuna raga disi bi amiye yokoi de niyadi, ori reyadi dada. Ago buni di ago metona yokoi Mk 16.9–20  ");
INSERT INTO kqc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu gabi muyenari gutuna dadi rae reyori, fura di ourena meda uriyaku gorogoro, ina bi Mary Magdalene siko rofu ogau niyo, kaere bi vima no 7 nufa mina meki reyo. ");
INSERT INTO kqc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ina yaku bosi Iesu sa vakoi dina vene, kaere bi isaka nigasa guruo amegamadi, mina oteimaro. ");
INSERT INTO kqc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Idu bi vegu niyo ma ina bi veyo, mina sina neidegasa mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gabi rofu Iesu bi roaita idana dudu ini amiye remanu rofu ogau niyo, idau muro gaganiri negamadiri. ");
INSERT INTO kqc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mina ago bosi nioteimaradi, idu mina ka mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gabi rofu Iesu di amiye 11 iruku irigamadiri, bi ina rofu ogau niyo; ago gira maro mokena vari gira aeyaganedi. Ada gira regasa Iesu dadi rae reyo ma veyadi vene rofu mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma niyo, “Disi kono tora noibanuri, ago buni Sei yaku riyo vene tau gade rofu nirausi refa. ");
INSERT INTO kqc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kaere amiye mokena vari gira aego ma babatiso rego, bi moi vegu rigo, idu kaere mokena vari gira de aego, ina bi nifafana rego. ");
INSERT INTO kqc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaere mokena vari gira aegedi, bi mina rebe dudu auta regedi: nai roka dudu vima no meki resi ago ruaka dudu ago nigedi; ");
INSERT INTO kqc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ini vana dudu aruma moisi yaumana no koru irigedi vonisi, ka esika esika de moigedi; ini vana gauka vene fafau aegedi, bi ina buni nigedi.” ");
INSERT INTO kqc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kamini Iesu Varika amiye ina vene rofu ago nioteimaro, gabi rofu bi Sei yaku omari afei boyo ma Sei di vana ramari ameyo. ");
INSERT INTO kqc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iesu di usi dina vene yaku disi gagani tauri ago buni nirausi reyadi, ma Varika amiye moimai regamo ina venesa ma ini ago rama aeyo ini rebe auta regamadiri. ");
INSERT INTO kqc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Theophilus amiye tora, amiye tau tora yaku beika vegu una rofu Sei yaku moi ogau riyo, bi sena bura reyadi. Mina vegu vata ni baeyo rofu, mina nifeidena vene ini ouresi ini ne yaku mina vegu veyadi, ma ina vene ka bi mina ago di naivo vene. Kamini ini sina niodoro reyadi, resi nidedi mini, una rofu. Mina dada, Theophilus, nai mokena bi mina sina dudusa bura rei mona regida, resi moi feidegida ya rofu, adina mina vata niyo vegu bi, sena baku rei mona reyaka, ini vata ni baeyo gutuna. ");
INSERT INTO kqc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Makai reyaka dada, yi adari ae mona regiya, ya rofu beika vegu ya oteimaradi bi, rama vata niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod yaku Judea gaganiri kini niyori, Sei ma amiye utari naivo amiye yokoi roka Zechariah amegamo; ina bi Abijah di vene amiye yokoi. Ini rema di roka bi Elizabeth. Iniye ka, Sei ma amiye utari naivo amiye roka Aaron di tutubena rema. ");
INSERT INTO kqc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ina remanu bi Sei di nemokori mokena rorobo nufa, Sei di ago vava tau vakoi, ma Varika amiye di ago gira, ma mokena sina tau vakoi ka moi gira rigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ina remanu bi mida de, adina Elizabeth bi natu, ma ini marukasa ka ugava iniye niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yokaru, Zechariah bi Sei nivakena yavari, Sei di nemokori, Sei ma amiye utari naivo amiye di moimai regasa amedo, adina mina meda bi ini vene bedakai di moimai ari. ");
INSERT INTO kqc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kamini Sei ma amiye utari naivo vene di rededi kana, ina vene yaku laki isirari gutuna Zechariah moiyadi, ma bi Varika amiye nivakena yava ideri orina vata fafau sisika buni muramura origi. ");
INSERT INTO kqc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma amiye tau tora iniye bi etofaro are regamadi, usa usa nigamadiri, bi sisika buni muramura oriyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mina medari, Zechariah yaku Varika amiye di naivo naivo vima yokoi veyo, sisika buni muramura ori sisika rena fore fata vana rama rofu are reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah veyori, bi tururu resi ini uka ideri ori no iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Idu naivo naivo vima yaku niyo, “Zechariah ori ga re, Sei yaku yi usa nina neideyo. Yi rema Elizabeth yaku yi mida yokoi evata rego, ini roka nigiya bi John. ");
INSERT INTO kqc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ada no iniye nigedi, ma amiye tau gade ka ada regedi, John vata nigo dada! ");
INSERT INTO kqc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Adina bi Varika amiye di nemokori bi amiye tora yokoi. Ina bi koru gira o waini de irigo; ina bi ini nono di ukari Vima kikifa ya sena vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ina yaku Israel vene tau gade ini Varika amiye Sei rofu moi dairigo. ");
INSERT INTO kqc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ina bi Varika amiye di naivo naivo amiye, kaere bi ourei bobigo, Sei di ago nido amiye Elijah di vima ma vava nufa. Ina yaku baba vene di uka moi kero regori, bi ini midasa uka yokoi maka dudu amebigedi. Ina yaku vegu no vene moi kero regori, bi mokena rorobo vene di mokena amebigedi. Adina Varika amiye di vene moi egogo resi Varika amiye di dego meda nari rebigedi.” ");
INSERT INTO kqc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah yaku mina naivo naivo vima rofu nikabai resi niyo, “Sina nisa bi gokai moi rama rego diba nigida? Na bi amiye ugava, ma nai rema ka ugava.” ");
INSERT INTO kqc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma nikabai resi niyo, “Na bi Gabriel, na bi Sei di nemokori are reida. Ya rofu na nifeideyo, mina sina buni ya nigida. ");
INSERT INTO kqc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Idu ya bi nai sina buni rofu mokena vari gira de aeyo. Mina dada ya bi babo nisi ago de nigiya; nai niyaka kana ogau nigo mamo ago nigiya. Nai sina tau niyaka, bi ini meda iniyeri vata nigo.” ");
INSERT INTO kqc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zechariah bi Sei nivakena yava ideri amei doba regamo dada, amiye tau ina nari regasa mokena tau moigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Etofaro yakuyori, bi amiye nikabai de reyo, dada mokeyadi ina bi Sei nivakena yava ideri rebe yokoi veyo. Ini vena babo niyo dudu maka, amiye oteimaro ina bi rama iniye rebe yokoi veyo. Ina babo nisi bi toga toga ina vene rofu rebe reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zechariah ini moimai ari koina niyori, bi ini rautu rofu dairiyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mina ari koina niyori, bi ini rema Elizabeth rivo niyo. Mina rivo niyori, bi eyo 5 ini yavari maka amegamo. Elizabeth yaku makai niyo, ");
INSERT INTO kqc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Gua Varika amiye yaku na rofu ada reyo. Ina yaku nai maena bi amiye di nemokori erufuyo!” ");
INSERT INTO kqc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth ini rivo niyo eyo 6 ri, bi Sei yaku naivo naivo vima roka Gabriel Galilee di taoni yokoi roka Nazareth rofu nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Rema ofi yokoi bi amiye yokoisa varena kode mironari amegamo, iniye bi amiye roka Joseph nikake reyadi, bi megedi. Joseph bi kini David di tutubena amiye yokoi. Mina rema di roka bi Mary. ");
INSERT INTO kqc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mina naivo naivo vima bi Mary rofu bosi niyo, “Rema mida, Sei ya rofu sena ada reyo, ma Varika amiye bi yasa amedo.” ");
INSERT INTO kqc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma mina sina neideyori, bi ori tora gade resi mokegamo mina ago di rama adina iniye bi beika. ");
INSERT INTO kqc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Naivo naivo vima yaku niyo, “Mary, ori ga re, adina Sei bi sena ya rofu uka ada reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ya bi rivo nisi rumana mida yokoi moi evata resi ini roka bi Iesu, vo nigiya. ");
INSERT INTO kqc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ina bi amiye tora iniye nigo, ma ini roka Sei Odoro iniye di Mida vo nigedi. Varika amiye Sei yaku ini tutubena David di vava moi mago. ");
INSERT INTO kqc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma ina bi Jacob di tutubena fafau toga toga ourefeidebobigo. Ini ourefeidena amena sana bi koina de nigo!” ");
INSERT INTO kqc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary yaku nikaitesi niyo, “Na bi rumanasa varena kode. Mina bi gokai vata nigo?” ");
INSERT INTO kqc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma nikabai resi niyo, “Vima kikifa bi ya rofu dego, ma Sei Odoro iniye di vava ya fafau ameinu rego, mina dada mina mida kikifa bi Sei di Mida, vo nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma va moke, yi davatu Elizabeth, ina bi ugava nufari, sena rivo niyo; amiye yaku nigamadi bi mida de moigo, vo niyadi, idu ini eyo 6 bi mini, ");
INSERT INTO kqc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","adina bi vegu yokoi de Sei yaku moi rama de rigo.” ");
INSERT INTO kqc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary yaku niyo, “Na bi Varika amiye di naivo rema. Yi sina niyo kana, na rofu vata nigo bi buni.” Kamini mina naivo naivo vima ina feresi diyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mina medari, Mary dadisi evade omuna ikari taoni yokoi Judea gaganiri boi neyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zechariah di yava ideri dui resi Elizabeth rofu yuata niyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth yaku Mary di yuata nina ago neideyori, bi ini mida ini rivo ideri kita reyo, ma Vima kikifa yaku Elizabeth di roaitari vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kamini dadisi goroka tora dudu niyo, “Rema tau di fogori bi ya maka bi buni tora gade! Ya yaku evata regiya mida ka buni tora iniye nigo! ");
INSERT INTO kqc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nai buni bi beika dada, ma nai Varika amiye di nono bi na rofu odi baeyo mini? ");
INSERT INTO kqc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Adina bi yi yuata nina neideyakari, nai mida bi nai rivo ideri ada resi kita reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Varika amiye di ago ya rofu niyo, ma ya bi mina rofu mokena vari gira aeyo. Ina bi buni tora gade ya mago dada!” ");
INSERT INTO kqc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kamini, Mary yaku niyo, “Nai vima yaku Varika amiye di roka moi odoro risi nido; ");
INSERT INTO kqc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nai vima yaku ka Sei na moi vegu rido amiye rofu ada redo, ");
INSERT INTO kqc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Adina bi na, ini naivo rema, na mokeyo mini! Ma mina dada gua ameibobinari, amiye tau yaku nigedi, Sei bi buni tora gade na maro. ");
INSERT INTO kqc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Adina bi Vava iniye amiye yokoi maka yaku vegu tora iniye na fafau moi vata riyo, ini roka bi kikifa. ");
INSERT INTO kqc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ini iriyeduka bi kaere ina rofu kikifa iniye rededi vene fafau amebigo. Mina vene kaere bi ini tutubena vene fafau ka amebigo. ");
INSERT INTO kqc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ini vana yaku ini yeiva bi sena moi ogau riyo, ma matuka vene ini mokenasa ina yaku meki reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ina yaku ourefeidena vene di amena vava sanari eyarei vau reyo, resi matuka de vene, bi ina yaku moi odorori vau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rauna amededi vene, bi ina yaku buni ini ukari moi vata baeyo. Resi gugura tau amiye, bi ina yaku vana koina moi feidei diyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ini naivo vene Israel aedeyo, ini iriyeduka mokeyo dada. ");
INSERT INTO kqc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ma uni tutubena vene toga toga ago niyo, Abraham ma ini tutubena rofu!” ");
INSERT INTO kqc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kamini Mary bi Elizabeth sa eyo regodenu amesi ini rautu rofu dairiyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth di mida moina ari okiyori, rumana mida evata riyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kamini ina atafu amededi vene ma ini usika ourena yaku Varika amiye di iriyeduka tora ina rofu vata niyo sina neidegasa bi inasa ada no iniye iniye niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Meda 8 ri, bi rumana mida di ini roaita nugagedi vonisi, egogo resi ini baba di roka Zechariah vo nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Idu ini nono niyo, “Ide, ini roka bi John.” ");
INSERT INTO kqc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ina vene yaku niyadi, “Idu yi usika ourena bi mina roka bi koina!” ");
INSERT INTO kqc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kamini ina vene yaku vana dudu ini baba nikaiteyadi, ini roka bi beika nisi mago. ");
INSERT INTO kqc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah yaku bura rena buka yokoi nikaitesi yomakai bura reyo, “Ini roka bi John.” Ina tau noibanu vakoi tururu reyadi! ");
INSERT INTO kqc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mina medari, Zechariah dudusa ago niyo. Resi Sei rofu moi odoro rina ago buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mina dada, ori yaku ini atafu ameyadi vene tau di uka vata baeyo, ma mina vegu di sina bi Judea omuna gagani tau rofu ni nega bogasa reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mina sina neideyadi vene tau yaku mokesi niyadi, “Mina mida yaku beika vegu moi ogau rigo?” Adina Varika amiye di vava bi mina mida fafau amedo mini. ");
INSERT INTO kqc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Vima kikifa yaku John di baba di uka vata baeyo dada, Sei di ago niyo: ");
INSERT INTO kqc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Varika amiye ni moi odoro rinadi, kaere bi Israel di Sei! Adina bi una aedegi desi ini vene moi vegu riyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Moi vegu rina amiye una maro. Ina bi ini naivo amiye David di tutubena gutuna deyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sei di ago niyadi vene kikifa yaku mina amiye fafau senagi senagi niyadi, ");
INSERT INTO kqc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","uni tuma vene rofu una moi vegu risi una gubuyo rededi vene tau di vava gutuna una moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sei yaku ina rofu niyo bi uni tutubena vene rofu ini iriyeduka moi ogau risi ini uka ago kikifa toto de nigo. ");
INSERT INTO kqc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Uni tutubena Abraham rofu nitore reyo, ");
INSERT INTO kqc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","bi uni tuma vene rofu una moi vegu rigo. Ina rofu naivo renadi ma ori ga renadi ida riyo. ");
INSERT INTO kqc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kikifa dudu, mokena rorobo dudu, ini nemokori dinadi, uni vegu ameibobina meda tauri. ");
INSERT INTO kqc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma ya, nai mida, bi Sei Odoro iniye di ago nido amiye, vo nibigedi, adina ya bi Varika amiye ouresi dibigiya, resi ini ida dogo regiya. ");
INSERT INTO kqc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ini vene oteimagiya ma Varika amiye yaku moi vegu rigo bi diba nigedi, ini vegu no koite makugo di. ");
INSERT INTO kqc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Adina Sei di iriyeduka una rofu bi ini ukari vata baeyo, ina yaku uriyaku meda vabara kana omari gutuna una rofu nifeidego. ");
INSERT INTO kqc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mukuna ideri ma muyena tumusa vene rofu mina vabara mago, resi ina yaku uka amuta di ida dudu una ourefeidebogo.” ");
INSERT INTO kqc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma mina mida kamini tora nigamo, ma ini vima ka yeiva nigamo. Ina bi gagani autu sanari amegamo, bogo Israel vene rofu ini ogau nigo medari mamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mirona ariri, Caesar Augustus yaku ago nifeideyo kono tora noibanu rofu, amiye tau roka moigedi di. ");
INSERT INTO kqc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ouresi roka moiyadi ini medari, bi Quirinius yaku Syria ri gavana niyo ariri. ");
INSERT INTO kqc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mina ago dada, amiye tau vakoi ini roka magedi vonisi, yokoi yokoi iniye di taoni rofu dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph, Nazareth, Galilee di taoni yokoi, rofu boyo, kini David di vata nina di taoni Bethlehem, Judea gagani rofu boi okiyo, adina ina bi David di tutubena. ");
INSERT INTO kqc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bethlehem taoniri, Joseph di roka mago di, Mary, kaere bi nimaradi mego vonisi, ka afesi gogo boyadi. Mary bi rivo nufa. ");
INSERT INTO kqc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mironari amegamadiri, bi Mary ini mida moina meda okiyo. ");
INSERT INTO kqc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mary yaku ini ourena rumana mida odisi varuka dudu kumu risi, kamini boromakau di iruku iridedi mauari moi aeyo, adina bi oto vene di amena varena yava bi vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mamoe dogo rededi vene be bi nomu tora gaganiri amegamadi. Urusa niyo ma ini mamoe tau dogo regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kamini, Varika amiye di naivo naivo vima yokoi desi mina vene adinari ogau niyo, ma Varika amiye di vabara yaku ina vene buru riyo ma ori iniye iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Resi mina vene rofu niyo, “Ori ga refa, sina buni moi deyaka dada. Mina sina yaku amiye tau ada regedi. ");
INSERT INTO kqc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Adina gua mina mida, David di taoniri, ya vene di Moi vegu rina amiye sena vata niyo. Mina bi Keriso Varika amiye! ");
INSERT INTO kqc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gokai vei mama rigedi di ida bi yomakai: Rumana mida keika baku regedi, boromakau di iruku irina maua ideri varedo, varuka dudu fafa riyadi.” ");
INSERT INTO kqc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kamini, minari maka, omari naivo naivo vima tau gade gade ogau nisi mina naivo naivo vimasa, Sei rofu nivakena resi yauta nigamadi: ");
INSERT INTO kqc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Oma odoro iniye Sei di roka moi odoro rinadi, kaere mina konori Sei yaku ada redo, bi uka amuta ya mago!” ");
INSERT INTO kqc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mina koina niyori, mina naivo naivo vima tau gade omari dairiyadi, ma mamoe dogo rededi vene iniye iniye rofu niyadi, “Bethlehem ri bonadi, beika bi vata niyo, Varika amiye yaku una oteimaro kana venadi.” ");
INSERT INTO kqc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Evade kamini boyadiri, Mary, Joseph sa baku reyadi. Ma rumana mida keika bi boromakau di iruku iridedi mauari varegamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mina veyadiri, mamoe dogo rededi vene yaku dadisi naivo naivo vima yaku beika nioteimaro, mina mida rofu ninegau reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kamini mina ago neideyadi vene tau mamoe dogo rededi vene di sina neidesi tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Mary yaku mina ago ma vegu tau ini ukari mokei tora iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kamini mamoe dogo rededi vene dairiyadi, Sei rofu yauta nigasa ini roka moi odoro riyadi, adina neidegasa veyadi vegu bi rama iniye, naivo naivo vima yaku nioteimaro kana. ");
INSERT INTO kqc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Meda 8 moiyori, rumana mida di roaita nugana medari, Iesu ini roka aeyadi, ini nono di rivo ideri varena koderi; naivo naivo vima yaku niyo kana, mina roka niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nono ini kino nufa meda koina niyadiri, ruaka nigi Moses di ago gira kana, Joseph ini remasa ini mida Varika amiye rofu magi Jerusalem rofu afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Varika amiye di ago girari bura rei niyo kana, “Vata ni oureyadi rumana mida tau bi Varika amiye rofu nigedi.” ");
INSERT INTO kqc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ina boyadi, Varika amiye di ago gira kana, pune erena remanu, ba kefuta di mida remanu, ori sisika rena ma Sei rofu kana magedi. ");
INSERT INTO kqc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mina ariri, amiye yokoi, roka Simeon, Jerusalem ri amegamo. Ina bi mokena rorobo amiye, ma Sei ori regamo amiye. Ina bi Israel di Moi vegu rina amiye tua rei amegamo, ma ina bi Vima kikifa yaku vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Vima kikifa yaku ka ina rofu niyo, ina bi de muyego bogo Varika amiye ini Keriso vego mamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Vima kikifa yaku Sei nivakena yava ideri Simeon afei dui reyo. Mina mida keika Iesu di nono baba, Moses di ago gira di vegu regi dada, moi dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kamini Simeon yaku mina mida keika moisi buda aesi Sei rofu buni tora gade masi niyo: ");
INSERT INTO kqc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Varika amiye, yi moimai rei tavoi reida amiye gua muyena sanari uka amuta dudu digida, yi ago niyo kana. ");
INSERT INTO kqc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Adina bi nai nemoko dudu yi Moi vegu rina ida veyaka mini. ");
INSERT INTO kqc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ya sena amiye tau vakoi di neri mina vegu dogo reyo: ");
INSERT INTO kqc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Vabara ruaka yokoi tutubena idana vene bedakai rofu moi evata riyo, ma vabara yi vene Israel mago.” ");
INSERT INTO kqc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Rumana mida di nono baba yaku Simeon di ago ina rofu neidegasa bi tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kamini Simeon yaku ina remanu rofu buni tora gade masi ini nono rofu niyo, “Mina mida yaku Israel vene tau gade moi keto rego, ma tau gade ka moi vegu rigo. Ina bi Sei di rebe kana bogo, ma amiye tau gade yaku mokena no dudu nivabi regedi. ");
INSERT INTO kqc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mina rofu dudu, ina yaku ini mokena no moi sui ridedi, mina moi negau rigo. Ma mina mokena iriyeduka yaku yi vima ora kana vaga imigo.” ");
INSERT INTO kqc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sei di ago niyo rema yokoi ka minari amegamo, ini roka bi Anna, kaere bi Panuel di vefa, Asher di rubu rema. Ina ka bi rema ugava; meyo, idu lagani 7 maka ini marukasa vakoi ameyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ini maruka muyeyo ma lagani 84 obu ni amegamo. Ina bi Sei nivakena yava de ferei tavoi regamo, uru ari Sei nivakesi iruku oyo rena di ago gira ma usa usa nina vegu moi gira rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mina ariri okigasa Sei buni tora gade masi Jerusalem moi vegu rigo nari rededi vene tau vakoi nioteimaro mina rumana mida di sina bi. ");
INSERT INTO kqc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iesu di nono baba yaku Varika amiye di ago gira di vegu tau vakoi rei vau reyadiri, bi kamini Galilee ri dairiyadi, ini taoni iniye Nazareth ri boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma mina mida kamini tora nisi yeiva nigamo ma bi mokena tora dudu vata baegamo. Ye Sei di buni tora gade ina rofu magamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lagani neinei Iesu ini nono babasa Ferei ebu rena irakuna regi Jerusalem bogamadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kamini Iesu ini lagani 12 ri, ina regode, ini tutubena rededi kana vegu, vakoi bi mina irakuna regi Jerusalem boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Irakuna meda koina niyori, dairiyadi, idu Iesu maka bi Jerusalem ri ameyo. Ini nono baba ina toto. ");
INSERT INTO kqc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ini mokenari, ina bi ini amiye fogori dido mironi. Meda yokoi maka koina niyo fufutari mamo, ini usika ourena vene rofu ma asiyaka vene rofu, Iesu kamini maina reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Baku rena de reyadi dada, Jerusalem ri maina regi dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Meda regodenu koina niyori, Sei nivakena yava ideri baku reyadi, oteimana vene di utari amegasa ini sina neidegasa ina rofu nikaitegamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ini ago neideyadi vene tau bi ini mokena ma ini ago nina mina rofu tururu iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ini nono baba mina vegasa ka tururu reyadi, kamini ini nono yaku ina rofu niyo, “Nai mida, beika resi una rofu makai reyo? Na yi babasa bi uka esika dudu ya maina reyafa.” ");
INSERT INTO kqc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma nikabai resi niyo, “Beika resi na maina rededi? Nai Baba di yavari ameida, bi ya ya diba ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ini ago bi neideyadi, idu sina di rama bi diba de niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kamini ini nono babasa Nazareth ri dairiyadi, ma ina vene di ago neidegamo. Ini nono yaku mina vegu tau ini uka ideri moi gira rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kamini Iesu bi mokena vabara ma roaita dudu tora nigamo ma Sei ma amiye di uka ka ada regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius Caesar bi lagani 15 varika amiye ini amegamori, Pontius Pilate bi Judea di gavana, ma Herod bi Galilee di gavana. Herod di ourena, Philip, bi Iturea ma Tranchonitis di gavana, ma Lysanias bi Abilene di gavana. ");
INSERT INTO kqc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas ma Caiaphas bi Sei ma amiye utari naivo vene tora. Mina ariri, Sei yaku John, Zechariah di mida, gagani autu sanari ini ago maro. ");
INSERT INTO kqc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kamini, John yaku Jordan koru seriri gagani tau digasa vegu no feresi moi etagae rina ma Sei yaku ini vegu no koite makuna di babatiso di ago nirausi regamo. ");
INSERT INTO kqc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sei di ago niyo amiye Isaiah di bukari bura resi niyo kana: “Amiye yokoi di goroka bi gagani autu sanari raka nido, ‘Varika amiye di ida dogo resi ini dibo ida moi rorobo rifa. ");
INSERT INTO kqc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Soku tau moi vata baegedi, omuna tora tora ma omuna keika keika tau bi nomu nigo. Ida kevo sana moi rorobo risi giyo ida bi amuta nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amiye tau yaku vegedi, Sei di vava gokai amiye moi vegu rigo mina!’” ");
INSERT INTO kqc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Amiye tau gade John rofu babatiso reyainedi baegamadiri, ina vene rofu niyo, “Ya bi aruma di mida mida kana, kaere yaku ya niyo, ‘Sei di gubuyo baego, mina rofu ori digedi’? ");
INSERT INTO kqc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mina dada, vegu no feresi moi etagae rina vegu di vegu iniye yabo meko rama rena kana moi ogau rifa. Ma ya kaya nigi ga kora refa, ‘Abraham bi uni tutubena.’ Adina ya vene rofu nida, Sei ina diba mina fore dudu Abraham di tutubena rigo! ");
INSERT INTO kqc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Viro bi yabo daruri sena ka aeyadi, ma yabo neinei meko buni de varededi bi nu makusi ita fafau you bogedi.” ");
INSERT INTO kqc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amiye tau gade yaku nikaitesi niyadi, “Ma una bi beika regifa?” ");
INSERT INTO kqc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John yaku nikabai resi niyo, “Kaere ini varuka remanu bi kaere varuka de rofu bi yokoi mago. Ma kaere iruku nufa bi, rau re.” ");
INSERT INTO kqc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Fore butu rededi vene be ka babatiso moigedi bi bosi nikaiteyadi, “Oteimana amiye, ma una bi gokai regifa?” ");
INSERT INTO kqc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma nikabai resi niyo, “Ago gira nido kana maka moifa, moi tora bi ga refa.” ");
INSERT INTO kqc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iya rededi vene be ka ina rofu nikaitesi niyadi, “Una bi gokai regifa?” Ma niyo, “Amiye rofu fore moi tavoi ga refa, ma ofa sina dudu ina rofu ago ga nifa. Ma yi moimai dudu, gokaisanu moisa bi, kaini ada refa.” ");
INSERT INTO kqc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gua amiye tau di uka mokena moi vau reyadi, dada mokena deda moisi niyadi, “John bi Keriso mini ba?” ");
INSERT INTO kqc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kamini ina yaku mina amiye tau rofu nikabai resi niyo, “Na yaku koru dudu ya babatiso reida, idu baedo amiye ini vava yaku nai vava ebu reyo, ye na bi rorobo de ini yuka ro di maena younegida. Mina amiye bi Vima kikifa ma ita dudu ya babatiso rego. ");
INSERT INTO kqc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ini witi fotaka utei resi koka rena di fodiya bi ini vanari moi gira resi ini rama bi dobeka gutuna makusi yareyo mina ini yavari aego, idu ini sanika bi kafena de itari ori kamu rego.” ");
INSERT INTO kqc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ina yaku ago tauri amiye rofu Ago buni nioteimaro. ");
INSERT INTO kqc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Idu John yaku, Herod, kaere bi Galilee di ourefeidena amiye, di no moi negau rigamo. Ini adina bi ini dubuini di rema Herodias meyo. Berou bi ini vegu no tau tora reyo, mina ninegau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mina vegu regasa ini no dudusa moi tora risi John dibura yavari aeyo. ");
INSERT INTO kqc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amiye tau babatiso marori, bi Iesu ka babatiso reyo. Usa usa nigamori, oma ekeyo ");
INSERT INTO kqc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Vima kikifa bi pune erena kana roaita dudu desi ina fafau rou riyo. Ma goroka yokoi oma gutuna degasa niyo, “Ya bi nai uka maida mida; ada tora gade ya rofu reida.” ");
INSERT INTO kqc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ini vata niyo lagani bi 30 kanari mamo ini moimai reyo. Amiye yaku mokegamadi bi Iesu bi Joseph di rumana mida. Joseph bi Heli di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli bi Matthat di rumana mida. Matthat bi Levi di rumana mida. Levi bi Melchi di rumana mida. Melchi bi Jannai di rumana mida. Jannai bi Joseph di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph bi Mattathias di rumana mida. Mattathias bi Amos di rumana mida. Amos bi Nahum di rumana mida. Nahum bi Esli di rumana mida. Esli bi Naggai di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai bi Maath di rumana mida. Maath bi Mattathias di rumana mida. Mattathias bi Semein di rumana mida. Semein bi Josech di rumana mida. Josech bi Joda di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda bi Joanan di rumana mida. Joanan bi Rhesa di rumana mida. Rhesa bi Zerubbabel di rumana mida. Zerubbabel bi Shealtiel di rumana mida. Shealtiel bi Neri di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri bi Melchi di rumana mida. Melchi bi Addi di rumana mida. Addi bi Cosam di rumana mida. Cosam bi Elmadam di rumana mida. Elmadam bi Er di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er bi Joshua di rumana mida. Joshua bi Eliezer di rumana mida. Eliezer bi Jorim di rumana mida. Jorim bi Matthat di rumana mida. Matthat bi Levi di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi bi Simeon di rumana mida. Simeon bi Judah di rumana mida. Judah bi Joseph di rumana mida. Joseph bi Jonam di rumana mida. Jonam bi Eliakim di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim bi Melea di rumana mida. Melea bi Menna di rumana mida. Menna bi Mattatha di rumana mida. Mattatha bi Nathan di rumana mida. Nathan bi David di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David bi Jesse di rumana mida. Jesse be Obed di rumana mida. Obed bi Boaz di rumana mida. Boaz bi Salmon di rumana mida. Salmon bi Nahshon di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon bi Amminadab di rumana mida. Amminadab bi Admin di rumana mida. Admin bi Arni di rumana mida. Arni bi Hezron di rumana mida. Hezron bi Perez di rumana mida. Perez bi Judah di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah bi Jacob di rumana mida. Jacob bi Isaac di rumana mida. Isaac bi Abraham di rumana mida. Abraham bi Terah di rumana mida. Terah bi Nahor di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor bi Serug di rumana mida. Serug bi Reu di rumana mida. Reu bi Peleg di rumana mida. Peleg bi Eber di rumana mida. Eber bi Shelah di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah bi Cainan di rumana mida. Cainan bi Arphaxad di rumana mida. Arphaxad bi Shem di rumana mida. Shem bi Noah di rumana mida. Noah bi Lamech di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech bi Methuselah di rumana mida. Methuselah bi Enoch di rumana mida. Enoch bi Jared di rumana mida. Jared bi Mahalaleel di rumana mida. Mahalaleel bi Kenan di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan bi Enosh di rumana mida. Enosh bi Seth di rumana mida. Seth bi Adam di rumana mida ma Adam bi Sei di rumana mida. ");
INSERT INTO kqc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Jordan koruri gutuna dairiyori, Vima kikifa bi ina moi vata baesi gagani autu sanari afei boyo ");
INSERT INTO kqc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ma mironari meda 40 Bodaka yaku no reyainedi ini uka maina regika niveyo. Mina meda tau, Iesu iruku irina de, ye meda koina niyori, rauna reyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kamini Bodaka yaku ina rofu niyo, “Ya bi Sei di mida vonisi, bi yomina fore ago gira ni kumo iruku niyaine.” ");
INSERT INTO kqc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma nikabai resi niyo, “Sei di agori bura reyo bi, ‘Amiye bi iruku dudu maka de amebigedi.’” ");
INSERT INTO kqc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kamini Bodaka yaku afei bosi minari maka, ourefeidena amena sana tau mina kono tora noibanuri mina nioteimasi ");
INSERT INTO kqc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","niyo, “Mina tau di vava ma buni vayavaya ya magida, adina mina tau bi na maro, ma kaere ura magida bi magida. ");
INSERT INTO kqc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mina dada, nai budari na nivakegi efuka meimigiya vonisi, bi mina tau vakoi ya magida.” ");
INSERT INTO kqc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma nikabai resi niyo, “Yomakai bura reyo, ‘Varika amiye, yi Sei nivakesi ina rofu maka naivo re!’” ");
INSERT INTO kqc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kamini Satani yaku Jerusalem ri afei bosi Sei nivakena yava tebori moi are resi niyo, “Ya bi Sei di mida vonisi, minari ya kaya maku ne. ");
INSERT INTO kqc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Adina Sei di agori bura reyo bi, ‘Sei yaku ya dada ini naivo naivo vima ago gira mago, ya nari regedi.’ ");
INSERT INTO kqc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma, ‘Ini vana dudu ya moi odoro regedi, yi yuka foreri de tagi magiya.’” ");
INSERT INTO kqc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma dudusa nikabai resi niyo, “Yomakai niyo, ‘Varika amiye, yi Sei ini uka maina regika bi ga nive.’” ");
INSERT INTO kqc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bodaka yaku Iesu vegu no reyainedi, ini uka maina regika nivena koina niyori, bi ferei diyo kumo meda buni yokoiri. ");
INSERT INTO kqc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu bi Vima kikifa di vava dudu Galilee ri dairiyo, ma iniye di sina bi mina gagani tau vakoiri ni nega bogasa reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ini usa usa yavari amiye oteimago, ma ina tau vakoi yaku ini roka moi odoro rigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kamini ini tora niyo taoni Nazareth ri dairiyo. Ini rei baedo kana, Sabati medari usa usa yavari Sei di ago bura vegi dadisi boyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ina vene yaku Isaiah, Sei di ago niyo amiye, di buka maradi. Kamini buka uforo resi bura reyadi sana baku resi vesi niyo: ");
INSERT INTO kqc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Varika amiye di Vima bi nasa, na vo niyo dada, sina buni irava vene rofu nirausi regida. Ina na nifeideyo, bi dibura vene nigida bi moi younesi ne taufa vene bi dudusa nene reyagane; moke itu vene erufugida. ");
INSERT INTO kqc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Resi nirausi regida, ‘Varika amiye di mokei vava redo ari bi okiyo mini, ma Varika amiye yaku ini vene moi vegu rigo.’” ");
INSERT INTO kqc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kamini Iesu yaku buka firo risi nari redo amiye dairi masi ameinu reyo. Amiye tau usa usa yavari Iesu maka vei mama reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma ina vene rofu nigi kora reyo, “Sei di ago bi gua neideyadi mini, mina meda bi rama aeyo.” ");
INSERT INTO kqc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kamini amiye tau ina rofu uka ada reyadi, sina buni buni niyo dada. Tururu resi niyadi, “Mina bi Joseph di mida, ba?” ");
INSERT INTO kqc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kamini Iesu yaku ina vene rofu niyo, “Rama bi mina mokena ago na rofu yomakai nigedi, ‘Gauka dogo amiye, ya kaya moi buni ri kumo.’ Ka nigedi, ‘Beika Capernaum ri reyo, bi neideyafa, dada minari yi rautu iniyeri ka re.’” ");
INSERT INTO kqc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma Iesu yaku niyo, “Rama ya nida, Sei di ago nido amiye, bi ini rautu vene yaku de nimadedi. ");
INSERT INTO kqc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Idu rama iniye ya nida, Elijah amegamo duakauri, obu tau gade Israel ri amegamadiri, bi lagani regodenu ma lagani berou afona miya de deyo ma adabo tora gade Israel gagani fono reyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sei yaku ini vene yokoi rofu Elijah de nifeideyo, idu bi taoni yokoi roka Zarephath, Sidon gagani atafu, obu yokoi rofu maka nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma Elisha Sei di ago niyo amiye amegamo duakauri, bi refera nufa vene tau tora Israel ri amegamadi, idu yokoi kava moi ruaka de riyo, mina bi Syria amiye, Naaman maka.” ");
INSERT INTO kqc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Usa usa yavari egogo reyadi vene tau yaku mina sina neidegasa bi gubuyo tora reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mina vene dadisi Iesu vanau risi taoniri moi yaku boyadi, ini taoni are redo omuna ika yokoiri raravari maku negika. ");
INSERT INTO kqc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Idu mina vene di toboma bae boyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu Capernaum, Galilee taoni yokoiri, bosi Sabati medari amiye oteimagamo. ");
INSERT INTO kqc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ye ini oteimana ago rofu tururu reyadi, adina ini ago bi vava nufa. ");
INSERT INTO kqc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma usa usa yavari, amiye yokoi vima no nufa bi goroka torari imuna nigasa niyo, ");
INSERT INTO kqc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aee, Iesu Nazareth amiye, una rofu bi beika ura reisa? Ya bi una moi no regika okiyo ba? Na na diba ya bi kaere: ya bi Sei di Kikifa amiye!” ");
INSERT INTO kqc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma emasi niyo, “Babo nisi mina amiye rofu yakusi di!” Ma amiye ini fogori moisi konori maku nesi ini roaitari yakusi ferei diyo. Idu esika yokoi de maro. ");
INSERT INTO kqc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amiye tau bi tururu resi iniye iniye nikaiteyadi, “Mina sina bi beika? Ina bi vava ma yeiva nufa vima no rofu ago gira nidori, feregasa yakudedi!” ");
INSERT INTO kqc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kamini beika regamo di sina bi gagani tora noibanuri urafo rei diyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Usa usa yava feresi Simon di yavari dui reyo. Simon di imokai rema bi gauka resi roaita vaki vaki reyo, ye ina fafau guyaguya niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ye mina rema atafu are resi mina gauka besenai ago marori, roaita vaki vaki bi fereyo. Minari maka dadisi iruku dabara resi nari regamo. ");
INSERT INTO kqc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Meda nei tomu niyo ma uru baeyori, ini gauka nufa vene tau Iesu rofu afei baeyadi; ini vana ina yokoi yokoi fafau aegasa moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma vima no ka amiye tau gade rofu yakusi ababa niyadi, “Ya bi Sei di mida!” Idu Iesu besenai ago masi ago ga niyaganedi niyo, adina ina diba ina bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aru veyori, Iesu dadisi feresi gagani autu sanari diyo ma amiye tau gade maina resi baku regasa bi moi gira reyadi, ga diyainedi. ");
INSERT INTO kqc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma nikabai resi niyo, “Na bi Sei di ourefeidena amena sana di ago buni taoni yokoi yokoiri ka nirausi regida, adina Sei yaku mina ida kana na moi feideyo dada.” ");
INSERT INTO kqc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ye Judea gagani di usa usa yavari ago nirausi regamo. ");
INSERT INTO kqc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Meda yokoiri, Gennesaret moka daidai tora seriri, Iesu are regamori, amiye tau tora ina adinari, are rei desi Sei di ago neidegi reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bouti remanu koru seri adinari ameyadi ma veyo ma oyena moidedi vene bi bouti feresi koru seriri ini oyena fate koitegamadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kamini Iesu yaku bouti yokoi, Simon di boutiri, keu risi niyo keika maka beku rego ma koruri neyaine. Resi bouti odorori ameinu resi amiye tau gade oteimagi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ago ni vau regasa Simon rofu niyo, “Yi bouti koru mokari besa fayo rei bosi yi fate maku ne oyena moiyainedi.” ");
INSERT INTO kqc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Idu nikabai resi niyo, “Varika amiye, urusa doba moimai tora rei baeyafa, idu be de uyafa. Idu ya yaku nisa dada, dudusa fate younegida.” ");
INSERT INTO kqc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Makai reyadiri, bi oyena tau tora iniye moiyadi. Ini fate ka uesi regi reyo, ");
INSERT INTO kqc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","dada ini asiyaka be bouti yokoiri rofu vana maragane raka ni boyadi. Baeyadiri bouti remanu moi vata baeyadi ma kamini tomu nigi regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ye Simon Peter mina veyori, Iesu di efukari yuka odesi niyo, “Varika amiye, na rofu etagae ri! Na bi vegu no reida amiye!” ");
INSERT INTO kqc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ye ini asiyaka tausa tururu reyadi, mina oyena tau moiyadi dada. ");
INSERT INTO kqc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedee di mida remanu, James ma John, kaere bi Simon di asiyaka, ka tururu reyadi. Ma Iesu yaku Simon rofu niyo, “Ori ga re, gua ari gutuna bi oyena koda rena kana amiye nirutu regiya.” ");
INSERT INTO kqc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ini bouti vasari rutu rei baeyadi fufutari, bi ini beika baika feresi Iesu usi diyadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Taoni yokoiri amegamori, bi refera amiye yokoi baeyo. Iesu veyori, bi ini efuka ini ne uruma konori odesi Iesu guyaguya niyo, “Varika amiye, ya ura reisa vonisi, ya yaku na moi ruaka rigiya!” ");
INSERT INTO kqc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu yaku ini vana moi roto risi mina amiye avaka moisi niyo, “Na yaku ura reida; ruaka ni!” Minari maka, ini roaitari refera gauka ferei diyo. ");
INSERT INTO kqc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma ago gira ina rofu niyo, “Amiye yokoi ga nioteima, idu nesi Sei ma amiye utari naivo amiye oteimasi yi roaita buni niyo kana ori sisika re. Ye amiye vegedi ya bi buni niyo, Moses yaku ago girari niyo kana, Sei rofu moi ori sisika regiya.” ");
INSERT INTO kqc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Idu Iesu yaku ini mina regamo sina bi urafo rei tora iniye reyo. Mina dada, amiye tau gade egogo regamadi, sina neidegi ma gauka moi buni riyainedi. ");
INSERT INTO kqc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Idu Iesu bi gagani autu sanari usa usa nigi etagae rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Meda yokoiri, amiye nioteimagamori, Pharisee vene ma ago gira oteimana vene be Iesu atafu amegamadi. Ina vene bi Galilee ma Judea taoni tauri ma Jerusalem gutuna baeyadi. Iesu bi Varika amiye di moi buni rigika vava nufa. ");
INSERT INTO kqc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye amiye be yaku dibo anua amiye yokoi, Iesu di neri aegi madunari uakaisi afei baeyadi. Yava ideri gokai moi dui regedi mina maina regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amiye tau gade dada, moi dui regi anua reyadi. Dada yava tebori moi bosi ruba risi maena dudu ini ekamasa Iesu di neri, amiye tau fogori moi feide neyadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ye Iesu mina vene di mokena vari gira aena veifategasa niyo, “Ya amiye, yi vegu no bi koite makuyaka.” ");
INSERT INTO kqc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ye ago gira oteimana vene ma Pharisee vene ina kaya mokegasa niyadi, “Mina Sei di roka moi no rido amiye bi kaere? Sei maka vegu no koite makugo!” ");
INSERT INTO kqc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Idu Iesu ini mokena veifatesi niyo, “Beika resi makai yi ukari mokededi? ");
INSERT INTO kqc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Goina ago nigida bi rena gira de, ‘Yi vegu no bi koite makuyo,’ o ‘Dadisi nana re’? ");
INSERT INTO kqc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Idu, ya vei mama regedi Amiye di mida bi vava nufa konori vegu no koite makugo.” Kamini Iesu yaku dibo anua amiye rofu niyo, “Ya nida, dadisi yi ekama vanau moisi yi yava rofu di!” ");
INSERT INTO kqc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ye minari maka amiye tau di nemokori dadisi ini varegamo ekama moisi Sei di roka moi odoro rigasa ini yavari diyo. ");
INSERT INTO kqc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amiye tau noibanu tururu reyadi. Ori yaku vata baesi Sei di roka moi odoro risi nigamadi, “Gua una yaku vegu buni vayavaya veyafa mini!” ");
INSERT INTO kqc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ye mina reyo fufutari, bi yaku nesi fore butu rena amiye roka Levi ini fore butu rena ofesiri amegamo ma veyo. Ina rofu niyo, “Na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ma dadisi ini gugura tau feresi usi diyo. ");
INSERT INTO kqc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kamini Levi bi ini yavari Iesu di iruku tora reyo ma fore butu rededi vene tau gade ma bouna vene ka mina iruku sanari ameinu regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma Pharisee vene ma ini ago gira oteimana vene bi ago tau nisi Iesu ini usi dina vene nikaiteyadi, “Beika resi fore butu rededi vene ma vegu no rededi venesa iruku irisa?” ");
INSERT INTO kqc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ye Iesu nikabai resi niyo, “Gauka de vene bi gauka dogo amiye de mokegedi, idu gauka vene maka. ");
INSERT INTO kqc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na bi mokena rorobo vene rofu disi raka nigi de okiyaka, idu vegu no rededi vene rofu okiyaka, ina yaku ini vegu no feresi moi etagae riyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kamini amiye be yaku Iesu rofu niyadi, “John di usi dina vene bi ariu oyo resi Sei rofu usa usa nidedi, ma Pharisee di usi dina vene makai ka rededi, idu yi usi dina vene bi iruku ma koru iridedi.” ");
INSERT INTO kqc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Idu nikabai reyo, “Rema mego amiye yaku ini asiyaka venesa amebigori, iruku oyo regedi ba ide? Ide mada! ");
INSERT INTO kqc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Idu rema mego amiye afei digedi meda baegori, bi mirona medari oyo regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu yaku ina vene rofu mina mokena ago ka niyo, “Amiye yokoi, varuka ruaka tu yokoi de uesi resi varuka kori di ruba fafa rigi de rego. Makai regori, bi varuka ruaka uesi rego, ma ini tu korisa de rorobo nigo. ");
INSERT INTO kqc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma amiye yokoi, waini ruaka moisi ini ro kori ideri de aego. Makai rego vonisi, bi waini ruaka di ro ufatego ma waini rausi rego ma ro bi no nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mina dada waini ruaka bi ini ro ruaka ideri aeyaine! ");
INSERT INTO kqc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Waini iriyo amiye bi ruaka de irigo, adina bi nigo, ‘Waini kori bi buni iniye.’” ");
INSERT INTO kqc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kamini Sabati medari Iesu ma ini usi dina venesa witi muro idari nana diyadi. Ina yaku witi di ada koma resi ini vanari fufuta resi rama maka irigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Idu Pharisee vene ina rofu niyadi, “Beika resi Sabati medari una rofu bi tabu mina rededi?” ");
INSERT INTO kqc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma nikabai resi niyo, “Ya bi bura de veyadi, beika David ini amiyesa yaku reyadi mirona medari rauna reyadiri? ");
INSERT INTO kqc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sei di yava ideri dui resi Sei rofu nimana beredi moisi irisi ini vene ka maro. Ago gira yaku nido bi tabu, Sei ma amiye utari naivo vene maka bi mina beredi irigedi.” ");
INSERT INTO kqc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Resi ina vene rofu niyo, “Amiye di mida bi Sabati meda di Varika amiye.” ");
INSERT INTO kqc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kamini Sabati meda yokoiri, usa usa yavari dui resi amiye oteimaro ma minari bi vana rama kevo amiye amegamo. ");
INSERT INTO kqc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ago gira oteimana vene ma Pharisee vene Sabati medari mina amiye moi buni rigi vei mona regamadi, bi ini no dada nisi tourage regika. ");
INSERT INTO kqc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Idu bi sena mina vene di mokena diba nisi vana kevo amiye rofu niyo, “Dadisi mina vene di nemokori are re.” Dadisi are reyori, bi ");
INSERT INTO kqc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","nikaiteyo, “Ya usa nida, ago gira dada beika vegu bi buni Sabati medari regedi? Vegu buni regedi, ba vegu no regedi? Amiye di vegu moi vegu rigedi, ba umuyegedi?” ");
INSERT INTO kqc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Resi ina vene tau rofu ne resi mina amiye rofu niyo, “Yi vana ae roto ri.” Ma reyori, bi ini vana dudusa dairi buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Idu mina vene di mokena bi gubuyo yaku vata baeyo ma Iesu rofu beika regedi iniye iniye nidodi regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mina ariri, Iesu yaku omuna yokoiri usa usa nigi boyo, resi urusa doba Sei rofu usa usa nigamo. ");
INSERT INTO kqc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ari uveyori, ini usi dina vene raka nisi 12 auba resi ini roka bi nifeidena vene vo nisi maro: ");
INSERT INTO kqc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Iesu ini roka maro bi Peter) ma ini usika Andrew; James ma John, Philip ma Bartholomew, ");
INSERT INTO kqc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew ma Thomas, Alphaeus di mida James, ma Simon zealot amiye, ");
INSERT INTO kqc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","James di mida Judas ma Judas Iscariot, kaere bi Iesu siri rena amiye niyo. ");
INSERT INTO kqc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kamini ina venesa desi nomuri ini usi dina vene tau gadesa are reyadi. Ma Judea gagani vene ma Jerusalem vene tau gade, ma Tyre ma Sidon kone vene tau gade ka minari; ");
INSERT INTO kqc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ini okiyadi bi Iesu di sina neidegi ma ini gauka moi buni riyainedi. Ma kaere vima no nufa guraugamadi ka moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ye amiye tau gade bi ina avaka moigika regamadi, adina vava ina rofu yakugamori, bi amiye tau gade moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu yaku ini usi dina vene rofu vesi niyo, “Ya kaere ina diba ini vimari Sei di gugura buni yokoi de, bi ada regedi, adina Sei di ourefeidena amena sana bi yi! ");
INSERT INTO kqc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gua, ya rauna rededi vene bi ada regedi; adina Sei yaku yi iruku ya mago mironi ma bi moi vata baegedi! Gua, ya isaka nidedi vene bi ada regedi; adina yoga nigedi mironi! ");
INSERT INTO kqc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Amiye yaku ya rofu gubuyo resi fufuta masi ya rofu nifafana resi yi roka moi no rigediri, Amiye di mida usi dina dada, bi ada regedi! ");
INSERT INTO kqc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mirona medari, ada regasa adena ufa, adina yi obini omari moigedi bi tora, adina mina vegu makai dudu ini tutubena yaku Sei di ago niyadi vene rofu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Idu no baego mironi, ya kaere gua bi gugura tau vene, yi vegu moi buni rena bi gua moidedi mini! ");
INSERT INTO kqc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","No baego mironi, ya kaere gua iruku tau iridedi; rauna regedi mironi! No baego mironi, ya kaere gua yoga nidedi bi; isaka nigasa guruo amegedi mironi! ");
INSERT INTO kqc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Amiye tau yaku ya ni buni regediri, bi no ya rofu baego; yi tutubena vene yaku mina ago yokoi maka Sei di ago nidedi ofa vene rofu nigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Idu na neidededi vene ya rofu nida: yi tuma vene uka masi ya rofu gubuyo rededi vene fafau buni refa. ");
INSERT INTO kqc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ya nikiraini rededi vene rofu bi buni tora gade masi ya rofu no rededi vene fafau bi Sei rofu usa usa nifa. ");
INSERT INTO kqc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amiye yokoi yaku yi ragena famagori, bi berou ka ma kumo famaraine. Ma amiye yokoi yaku yi serti moigori, bi kaini feresi yi fafau varuka ka ma. ");
INSERT INTO kqc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Amiye neinei ya rofu ya usa nigori, bi mina ma; ma kaere ya rofu yi beika be moigori, dairi ya marainedi bi ga ni. ");
INSERT INTO kqc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ya ura rededi amiye yaku ya rofu rebigedi kana, ina rofu makai refa. ");
INSERT INTO kqc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ye ya uka madedi vene maka uka mabigedi vonisi, bi gokai dudu Sei buni tora gade ya mago? Vegu no rededi vene ka uka madedi vene maka uka madedi! ");
INSERT INTO kqc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma ya rofu buni rededi vene maka buni regedi vonisi, bi gokai resi Sei buni tora gade ya mago? Vegu no rededi vene ka makai rededi! ");
INSERT INTO kqc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ya uka mokena aesa amiye be dairisi ya magedi ma magiya vonisi, bi gokai resi Sei buni tora gade ya mago? Vegu no rededi vene ka vegu no rededi vene rofu madedi, maradi kana dairi moigi maka! ");
INSERT INTO kqc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Idu yi tuma vene rofu uka mafa. Vegu buni ina rofu rei masi ya dairi moigedi mokena bi ga mokefa. Makai dudu bi yi buni tora gade moigedi, ma ya bi Sei odoro iniye di mida vene nigedi. Adina kaere amiye ni buni de rededi vene ma vegu no rededi vene rofu ka mokei tora redo. ");
INSERT INTO kqc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Amiye rofu iriyeduka refa, yi Baba ka bi iriyeduka ya rofu redo kana. ");
INSERT INTO kqc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Amiye di no rofu mokei no ga refa, ma Sei yaku ka yi no kota de rego. Amiye be nifafana ga refa, ma Sei ka ya nifafana de rego. Amiye di vegu no erufugediri, Sei yaku yi vegu no koite makugo. ");
INSERT INTO kqc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Amiye be mafa, ma Sei yaku ya mago. Yi dura moi vata baegori, moi varaka varaka resi besa ma vata baegasa rausi rebigo, kamini ya bi ya rofu beika rau reyadi, bi uka bere nigedi. Adina ya amiye gokai toe madedi kana, Sei yaku mina toe dairisi ya mago.” ");
INSERT INTO kqc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma mokena ago ina vene rofu ka niyo, “Ne taufa amiye yaku ne taufa ourefeidego ba? Makai kana ina remanu sokuri gogo keto regedi. ");
INSERT INTO kqc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Usi dina amiye ini oteimana amiye ebu de rego, idu mokena oteimai vau regori, bi ini oteimana amiye kana nigo. ");
INSERT INTO kqc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Beika resi bubudo yi usika ourena di nemokori bi veisa, idu yabo rata yi nemokori bi de nidodi reisa? ");
INSERT INTO kqc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gokai ida dudu yi usika ourena rofu nigiya, ‘Dubu, na ferei kumo yi nemokori bubudo amedo mina moigida,’ ma ya kaya yi nemokori yabo rata amedo bi de veisa? Ofarosi amiye, yi nemokori yabo rata amedo mina siko moi etagae rigiya, mamo vei mona resi yi usika ourena di nemokori bubudo amedo mina moi etagae ri. ");
INSERT INTO kqc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Adina yabo buni yaku meko no de varededi, ma yabo no yaku ka meko buni de varededi. ");
INSERT INTO kqc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ye yabo yokoi yokoi bi ini meko dudu vei mama regiya. Imiye tafari fuka meko butu de regiya. Waini meko ka imiye yabo rofu butu de regiya. ");
INSERT INTO kqc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amiye buni yaku ini ukari beika mokedo bi buni dada, vegu buni moi baedo, ma amiye no yaku ini ukari beika mokedo bi no dada, vegu no moi baedo, adina beika uka ideri makudo, bi ini vena yaku nido mini. ");
INSERT INTO kqc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ya vene bi na rofu nidedi, ‘Varika amiye,’ idu beika resi na nida kana, bi de rededi? ");
INSERT INTO kqc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amiye tau na rofu baesi nai ago neidesi regedi, bi gokai kana amiye ya oteimagida. ");
INSERT INTO kqc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ina bi amiye yokoi yava akugamo kana, kono goesi guri iniye resi fore fafau ini yava moi are reyo. Kamini abata deyori, koru yaku nesi ini yava uyori, de moi kita reyo, adina mina yava bi aku mona reyo dada. ");
INSERT INTO kqc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amiye kaere yaku nai ago neidesi de rego, bi amiye yokoi kana, kaere bi ini yava vasa fafau akuyo; abata yaku ini yava uyori, bi minari maka yareyo—ma ini uvaradauna bi no iniye!” ");
INSERT INTO kqc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Amiye rofu ini sina tau ni vau regasa bi Capernaum ri okiyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rome di iya rededi vene di ourefeidena amiye yokoi di moimai rei tavoi redo amiye yokoi bi gauka reyo; ina bi muyena gauka moiyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Resi Iesu bi beika redo mina neidegasa bi ago nifeideyo Jew tora vene be rofu, buni baesi ini moimai rei tavoi redo amiye moi buni rigo ba ide. ");
INSERT INTO kqc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Iesu rofu baesi niguba regasa niyadi, “Mina amiye vana magiya bi buni. ");
INSERT INTO kqc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Adina uni vene rofu uka mado dada, una rofu uni usa usa yava bi ina yaku riyo.” ");
INSERT INTO kqc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kamini Iesu ina venesa boyadi. Yava adina okiyadiri, bi mina iya rededi vene di ourefeidena amiye yaku ini asiyaka vene rofu ini ago nifeideyo ma Iesu rofu niyadi, “Varika amiye, gokai mokegiyari, bi ga devo, adina na bi rorobo de ya yaku nai yavari baegiya. ");
INSERT INTO kqc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mina dada, na ka ya rofu baegida bi buni de, idu sina maka nigiya, ma nai naivo amiye buni nigo. ");
INSERT INTO kqc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ka bi amiye be di vava gabireri aeyo ma ameida dada; iya rededi vene be bi nai vava gabireri amededi. Na yaku yokoi rofu nida, ‘Bo!’ vo nidari, bodo; ma yokoi rofu nida, ‘Bae!’ vo nidari, baedo; ma nai moimai rei tavoi redo amiye rofu nida, ‘Mina re!’ vo nidari, redo.” ");
INSERT INTO kqc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu mina ago neidesi bi tururu resi kero resi usi diyadi vene tau gade rofu niyo, “Ya nida, Israel ri ka mokena vari gira aena makai de baku reyaka!” ");
INSERT INTO kqc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mina nifeideyo vene yavari dairiyadiri, bi ini moimai rei tavoi reyo amiye bi buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Meda doba de, Iesu yaku taoni yokoi roka Nain ri ini usi dina vene ma amiye tau gadesa boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taoni ida venau okiyori, bi muyena amiye yokoi, guri aegi uakai yakuyadi. Mina muyena amiye bi obu yokoi di mida yokoi maka, ma taoni di amiye tau gade gade ka bi mina obusa. ");
INSERT INTO kqc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Varika amiye yaku veyori, bi iriyeduka resi niyo, “Isaka ga ni.” ");
INSERT INTO kqc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kamini, baesi muyena maua avaka moiyori, bi uakaidedi vene are reyadi. Iesu yaku niyo, “Mida godua, na yaku ya nida, dadi!” ");
INSERT INTO kqc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kamini, dadisi ameinu resi ago niyo ma Iesu yaku ini nono maro. ");
INSERT INTO kqc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma amiye tau noibanu vima fata nisi Sei di roka moi odoro rigasa niyadi, “Sei di ago nido amiye tora yokoi uni fogori ogau niyo mini!” Resi ka niyadi, “Sei yaku ini vene rofu vana magi okiyo mini!” ");
INSERT INTO kqc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kamini mina vegu di sina bi Judea gagani tau ma ina adina gagani negau tauri urafo reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ye John Baptist di usi dina vene yaku mina sina tau nioteimaradi. Kamini ini usi dina amiye remanu roka nisi ");
INSERT INTO kqc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Varika amiye rofu nifeideyo ma bosi nikaiteyadi, “Ya bi dego amiye ba amiye yokoi tua regifa?” ");
INSERT INTO kqc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ina remanu bogasa niyadi, “John Baptist una nifeidesi usa nigi niyo, ‘Ya bi dego amiye ba amiye yokoi tua regifa?’” ");
INSERT INTO kqc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mina medari, Iesu yaku amiye tau gade moi buni riyo; gauka vene, esika vene, vima no moiyadi vene, ma ne taufa vene ka moi buni riyo ma dudusa gagani veyadi. ");
INSERT INTO kqc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kamini nikabai resi niyo, “Bosi John rofu beika vegasa neideyadi mina nifa: ne taufa vene dudusa gagani vededi, yuka no vene nana rededi, refera nufa vene bi moi ruaka riyo, anema kora vene bi neidededi, muyena vene bi veguri edadiyo, ma ago buni bi irava vene rofu nirausi reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma kaere na rofu mokei itu de rego, bi buni tora gade ina rofu mago!” ");
INSERT INTO kqc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ye John di nifeidena vene diyadiri, bi amiye tau gade John fafau ago nigi kora reyadi, “Ya bi beika vegi gagani autu sanari boyadi? Doi iye aura yaku moi raudai redo mina vegika ba? ");
INSERT INTO kqc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Idu mironari beika vegika boyadi? Varuka burefe rido amiye ba? Mina kana varuka burefe ridedi ma beika baika burefe moiga irigasa amededi vene bi kini di yavari amededi! ");
INSERT INTO kqc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Idu beika vegika boyadi? Sei di ago nido amiye yokoi ba? Yo, ya vene rofu nida, ina bi Sei di ago nido amiye, idu bi isivaga iniye. ");
INSERT INTO kqc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mina amiye bi kaere bi bura reyo: ‘Sei yaku makai niyo; nai ago moi raga redo amiye bi yi budari nifeidegida. Yi ida moi dogo rego.’ ");
INSERT INTO kqc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya vene rofu nida, kaere sena ameyadi vene ma gua amededi tau vakoiri bi yokoi yaku John de ebu redo. Idu Sei di ourefeidena amena sanari bi kaere amiye roka de mina yaku bi John ebu redo.” ");
INSERT INTO kqc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Amiye tau vakoi ma fore butu rededi vene ka mina sina neideyadiri, bi Sei di vegu bi rama vo niyadi, adina bi John yaku babatiso reyo dada. ");
INSERT INTO kqc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Idu Pharisee vene ma ago gira oteimana vene bi John di babatiso de moiyadi dada, Sei di mokena ina vene rofu bi makuyadi. ");
INSERT INTO kqc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu yaku niyo, “Ye gua amededi vene bi gokai dudu nirorotari regida? Ina bi gokai kana? ");
INSERT INTO kqc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ina bi mida keika keika kana, maketi sanari amegasa iniye iniye rofu raka nisi nidedi, ‘Una bi ya rofu bibo uyafa, idu ya bi adena de uyadi; muyena yauta niyafa, idu ya bi isaka de niyadi!’ ");
INSERT INTO kqc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Adina John Baptist baesi beredi oyo regasa waini de irigamori, kamini niyadi, ‘Ina bi vima no nufa!’ ");
INSERT INTO kqc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amiye di mida baesi iruku irisi waini irigamori, ya vene yaku niyadi, ‘Mina amiye vefa! Ina bi iruku ma waini irina kurakura amiye. Ina bi fore butu rededi vene ma vegu no rededi vene di asini!’ ");
INSERT INTO kqc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Idu Sei di mokena tora yaku vegu beika tau ini vene rededi dudu una oteimado bi rama mini.” ");
INSERT INTO kqc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee yokoi yaku Iesu niyo ini yavari vakoi iruku irigedi, dada Iesu ini yavari bosi iruku irina sanari ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mina taoniri vegu no redo rema yokoi yaku neideyo, bi Iesu bi Pharisee amiye di yavari amegasa iruku irigamo, dada fore roka alabaster dudu riyadi siua yokoi, ideri bi diga di sisika buni vayavaya, mina moi boyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bosi Iesu di yuka atafu ini fufuta rofu are resi isaka niyo. Ini ne koru dudu Iesu di yuka moi dou regi kora resi ini ada iye dudu ugagamo, moi roko rigika. Ini yuka rafo fuka resi diga rausi reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kamini, Iesu raka niyo Pharisee amiye yaku mina veyori, bi ini uka ideri maka iniye niyo, “Mina amiye bi Sei di ago nido amiye vonisi, bi veyagadu mina bi gokai kana rema yaku avaka moido. Adina mina rema bi vegu no redo rema!” ");
INSERT INTO kqc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kamini Iesu nikabai resi niyo, “Simon na bi sina yokoi ya nigida.” Ma nikabai resi niyo, “Oteimana amiye, na rofu ni.” ");
INSERT INTO kqc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma niyo, “Amiye remanu yaku yokoi rofu fore abitore reyadi; yokoi bi meda 500 di moimai di fore moi tavoi reyo, ma yokoi bi meda 50 di moimai fore moi tavoi reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ina remanu bi mina fore dairi mana anua reyadi. Dada mina amiye ina remanu rofu fore dairi mana mokena ga moiyagane, vo niyo. Goina bi uka tora gade mago?” ");
INSERT INTO kqc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon yaku niyo, “Nai mokena bi kaere ina rofu fore mai dairina bi tora.” Ma Iesu yaku niyo, “Ya bi rama nisa.” ");
INSERT INTO kqc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mina rema rofu kero resi Simon rofu niyo, “Mina rema veisa? Yi yava dui reyakari, nai yuka koitegi koru de na maro, idu ina nai yuka rafo bi ini ne koru dudu moi dou resi ini ada iye dudu moi roko riyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ya bi de na fuka reyo, idu dui reyakari, bi nai yuka rafo fuka redo, mina bi ferena de mini. ");
INSERT INTO kqc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nai adari diga rausi de reyo, idu ina bi nai yuka rafori diga di sisika buni erausi reyo. ");
INSERT INTO kqc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mina dada, ya nida, mina rema ini uka mana tora gade iniye dada, ini vegu no tau gade ka koite makuyo. Idu kaere vegu no keika nufa bi keika koite makuyo, ini uka mana ka keika maka dada.” ");
INSERT INTO kqc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kamini Iesu yaku mina rema rofu niyo, “Yi vegu no bi koite makuyaka.” ");
INSERT INTO kqc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Inasa vakoi iruku iridedi vene yaku iniye nikaitesi niyadi, “Mina bi kaere, vegu no ka koite makudo?” ");
INSERT INTO kqc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kamini Iesu yaku mina rema rofu niyo, “Yi mokena vari gira aena yaku ya moi vegu riyo; uka amuta dudu di.” ");
INSERT INTO kqc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mina fufutari, Iesu yaku taoni ma rautu digasa ago buni nirausi resi Sei di ourefeidena amena sana di ago buni nigamo. Ma ini usi dina vene 12 inasa boyadi ");
INSERT INTO kqc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma rema bedakai, kaere bi Iesu yaku vima no meki reyo, ma be bi ini gauka moi buni riyo: Mary, kaere ini roka bi Magdalene, ina rofu bi, Iesu yaku vima no 7 ini roaitari meki rei yakuyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma yokoi bi Joanna, ini maruka Chuza bi Herod di yava nari redo amiye, ma rema yokoi Susanna, ma rema tau ka ina vene yaku ini gugura dudu Iesu ini usi dina venesa nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Taoni neinei vene tau gade gade ina rofu baesi egogo reyadiri, bi mokena ago yokoi niyo: ");
INSERT INTO kqc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amiye yokoi ini yo varigi diyo. Ye yo moi faraka reyori, bedakai bi ida sanari yareyadi ma amiye yaku etei ri fufuta reyadi, ma oma di erena yaku iri vau reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Be bi abita fore odoro yareyadi. Dadisi bi abiye niyadi, adina kono bi roko dada. ");
INSERT INTO kqc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma be bi imiye tafa fogori yaresi vakoi boi tora niyadi ma imiye yaku fafa risi fono reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma be bi kono buniri yaresi imu resi rama 100 niyadi.” Mina ago niyori, raka nisi niyo, “Kaere neidego, bi neideyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kamini ini usi dina vene yaku nikaiteyadi mina mokena ago nirorotari reyaine. ");
INSERT INTO kqc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kamini niyo, “Ya bi Sei di ourefeidena amena sana di sui ago diba nigika bi ya maro, idu idana vene rofu mokena ago maka nida; ye vededi, idu vei mama de rededi; ma neidededi, idu diba de nidedi. ");
INSERT INTO kqc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mina mokena ago di adina bi yomini: yo bi Sei di ago. ");
INSERT INTO kqc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amiye bedakai bi ida sanari yo yareyadi kana. Ago neideyadi ma Bodaka yaku baegasa ini uka mekori mina ago moi diyo, mokena vari gira aegedi ye moi vegu rigo baebu. ");
INSERT INTO kqc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma yo abita foreri yareyadi, bi amiye kaere ago neidesi ada dudu moiyadi kana. Idu ini daru bi de, ma mokena vari gira aena doba de regedi. Ye uka maina regika nivena baegori, bi youfeidegedi. ");
INSERT INTO kqc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma bedakai bi imiye tafa fogori yareyadi kana. Mina vene bi ago neideyadi, idu mina vegu di mokena toe, gugura tau gade ma vegu di ura bi moi forovai reyadi, ye ina bi meko varena de reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Idu amiye be bi kono buniri yo yareyadi kana; ago neidesi ini uka buniri moi gira ri yavoi resi toro dudu rama nidedi. ");
INSERT INTO kqc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Amiye yokoi yaku ramefa orisi moi disi takura ideri o ekama gabireri de aego. Idu, ina bi ini ikina sanari ikigo, ye kaere yava dui rededi ka vabara vegedi. ");
INSERT INTO kqc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Adina beika sui niyadi, bi moi ogau rigedi, ma beika sui niyadi, bi bou uyounegedi. ");
INSERT INTO kqc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ya beika neidededi, bi mokei mona refa! Amiye kaere ini beika baika nufa, bi moi tanu mago. Idu kaere ina bi de iniye iniye nufa, ka ina rofu ini mokena keika amedo, bi moi dairigo.” ");
INSERT INTO kqc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kamini Iesu ini nono ma ini dubuiyaka ina vegi baeyadi, idu bi anua reyadi, adina bi amiye tau gade dada. ");
INSERT INTO kqc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kamini nioteimaradi, “Yi nono ma yi dubuiyaka bi etofaro are resi ya vegi ura rededi.” ");
INSERT INTO kqc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Idu nikabai resi niyo, “Nai nono ma nai dubuiyaka bi Sei di ago neidegasa rededi vene.” ");
INSERT INTO kqc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Meda yokoiri, Iesu ini usi dina venesa bouti yokoiri keu risi niyo, “Una moka daidai tora berou eta rofu boi nenadi.” Ye boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bogamadiri, Iesu vareyo, kamini aura yeiva tora moka daidai tora fafau fu reyo, ye koru yaku boutiri vata baegamo, bi no baku reyadi dada. ");
INSERT INTO kqc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ini usi dina vene ina rofu bosi edadisi niyadi, “Ourefeidena amiye, una bi kamini muyegifa!” Iesu dadisi aura ma ureure nibesenai ago maro ma aura bere niyo ma moka daidai tora amuta niyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kamini ina vene rofu niyo, “Yi mokena vari gira aena Sei rofu bi goini?” Idu ina vene bi ori resi tururu resi iniye iniye rofu niyadi, “Ye mina amiye bi gokai kana amiye? Aura ma koru tafo rofu nibesenai ago madori, ka neidededi!” ");
INSERT INTO kqc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kamini Iesu bi usi dina venesa Galilee moka daidai tora berou eta rofu Gerasa gaganiri okiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Soka reyori, mina taoni amiye yokoi vima no nufa baeyo ma baku reyo. Ina bi senagi iniye varuka rina de digamo. Ina bi yavari amena de, idu bi amiye guri sana fore rubari amegamo. ");
INSERT INTO kqc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iesu vegasa ababa nisi ini yuka atafu keto resi raka ni tora reyo, “Iesu, oma odoro Sei di mida, beika resi na rofu baesa? Ya niguba reida, esika na mana ga re!” ");
INSERT INTO kqc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mina kana niyo, ini adina bi Iesu yaku sena mina vima no niyo yakuyainedi. Seini dudu yuka vana ukita risi nari regamadi, ye meda tau vima no yaku moiyo ma mina seini moi ubaki reyo ma gagani autu sanari moi afei bogamo. ");
INSERT INTO kqc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kamini Iesu yaku nikaiteyo, “Yi roka bi beika?” “Nai roka bi ‘Tau gade gade’,” vo niyo—adina vima no tau gade bi ina ideri amegamadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma vima no niguba reyadi ri ga moi feideyaine. ");
INSERT INTO kqc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ye mironari, bi dona tau gade atafu, omuna ikari vana irigamadi. Ye vima no yaku Iesu guyaguya niyadi, mina dona di roaita ideri dui reyagane. Nifeideyo ma ");
INSERT INTO kqc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","vima no mina amiye di roaitari yakusi dona ideri dui reyadi. Mina dona tau raravari raga nesi moka daidai torari yoyo resi koruri tomu nisi muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dona vana regamadi vene bi ori disi beika vata niyo ma veyadi, mina taoniri ma gagani gaganiri sina ni digamadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Amiye bi beika vata niyo mina vegi diyadi. Iesu rofu okigasa bi mina amiye veyadi, kaere bi vima no tau gade gade ini roaita ideri yakuyo, bi mironari Iesu di yuka atafuri amegamo, roaita dogo resi mokena rorobo dudu, ma ina tau noibanu ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma mina vegu veyadi vene yaku amiye nigamadi gokai mina vima no nufa amiye bi buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kamini mina Gerasa gagani tau vene yaku Iesu niguyaguya reyadi, ina vene ferei diyainedi, adina bi ori yaku no iniye niyadi. Ye ina yaku boutiri keu risi diyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma mina vima no fereyadi amiye bi inasa digi niguba reyo. Idu nifeidegasa niyo, ");
INSERT INTO kqc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Rautu dairisi Sei yaku beika buni ya rofu reyo ni digiya.” Dada dairi nesi taoni noibanuri, Iesu yaku ina rofu beika reyo, mina nirausi regasa diyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu dairiyori, amiye tau yaku faiva niyadi, adina ina tau noibanu bi nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mina usi amiye yokoi roka Jairus bi okiyo, kaere bi usa usa yava di ourefeidena amiye yokoi. Iesu di yuka adinari you makusi niguyaguya reyo bi ini yavari boyaine, ");
INSERT INTO kqc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","adina ini vefa yokoi maka, ini lagani bi 12 kana, bi muyegi reyo. Mironari boyori, bi amiye tau gade ina fafa riyadi. ");
INSERT INTO kqc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rema yokoi bi lagani 12 rema di gauka guraugamo. Ini fore tau gade gauka dogo vene rofu makuyo, idu yokoi yaku moi buni de riyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Resi Iesu di fufutari baesi ini varuka tu avaka moiyori, evade bi ini dava degamo koina niyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma Iesu yaku niyo, “Kaere yaku na avaka moiyo?” Amiye tau moi sui riyadiri, Peter yaku niyo, “Ourefeidena amiye, amiye tau gade ya buru risi ya fafa ridedi.” ");
INSERT INTO kqc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Idu niyo, “Amiye yokoi yaku na avaka moiyo, adina veifateyaka bi vava nai roaitari yakuyo.” ");
INSERT INTO kqc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma mina rema veyo bi baku reyo dada, tururu resi ini yuka rafo adinari iniye you makuyo. Minari amiye di nemokori niyo beika resi avaka moiyo, ma gokai minari maka buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma niyo, “Nai vefa, yi mokena vari gira aena yaku ya moi buni riyo. Uka amuta dudu di.” ");
INSERT INTO kqc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Resi mina ago nigamori, usa usa yava di ourefeidena amiye di naivo naivo amiye yokoi ini yava gutuna okisi niyo, “Yi vefa bi muyeyo. Beika resi mina oteimana amiye rofu toga mokena moigasa ameisa?” ");
INSERT INTO kqc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Idu Iesu yaku neidesi Jairus rofu niyo, “Ori ga re; mokena vari gira maka ae, ma buni nigo.” ");
INSERT INTO kqc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ye yavari okigasa bi amiye yokoi afena de reyo, idu Peter, John ma James, ma mina rema mida keika di nono baba maka. ");
INSERT INTO kqc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Amiye tau minari mina rema mida dada isaka nigasa guruo amegamadi. Idu Iesu yaku niyo, “Isaka ga nifo; adina bi muyena de—bi neota varedo!” ");
INSERT INTO kqc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma ina rofu ninika nigamadi, adina ina ina diba bi muyeyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Idu ini vana moisi raka nisi niyo, “Rema mida keika, dadi!” ");
INSERT INTO kqc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma ini vegu dairiyori, bi minari maka dadiyo, ma Iesu yaku iruku be magedi ma iriyaine, vo niyo. ");
INSERT INTO kqc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma ini nono baba bi tururu reyadi, idu Iesu yaku amiye yokoi mina vegu vata niyo ga niyaganedi, vo niyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kamini Iesu di usi dina vene 12 raka niegogo resi vima no tau meki regi ma gauka vene moi buni riyaganedi vava maro. ");
INSERT INTO kqc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Resi ago gira nisi nifeideyo, Sei di ourefeidena amena sana di sina nirausi regasa digedi, gauka vene moi buni riyaganedi. ");
INSERT INTO kqc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ye ka niyo, “Gugura yokoi ida di ga moifa: yukana bi de, dura bi de, iruku bi de, fore bi de, ma varuka remanu bi de. ");
INSERT INTO kqc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ye goina yavari dui regedi, bi minari amegedi bogo ferei digedi mamo. ");
INSERT INTO kqc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma amiye tau kaere ya moi dui de regedi, bi mina taoni feresi yi yuka di budoka usi eyarefa. Ye mina bi ini vegu makai regedi yaku bi vei mama regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Rautu rautu kamini digasa ago buni ni digasa gauka vene moi buni rigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, Galilee di ourefeidena amiye, yaku beika tau vata nigamadi, bi neideyori, bi ini mokena forovai iniye reyo, adina bi amiye be yaku nigamadi bi John Baptist bi muyena gutuna dadi rae reyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Amiye be yaku nigamadi bi Elijah ogau niyo, ma be yaku nigamadi bi senagi senagi Sei di ago niyo amiye yokoi dadi rae reyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Idu Herod yaku niyo, “John di ada nugai feideyaka; idu bi goina amiye di mina sina neideida?” Ye ini mokena tora bi Iesu vego. ");
INSERT INTO kqc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kamini ini nifeidena vene dairisi ini beika tau reyadi kana, mina nigamadi. Ma inasa taoni roka Bethsaida ri sui dudu boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Idu amiye tau gade mina vei mama regasa bi usi boyadi. Ina vene rofu faiva nisi Sei di ourefeidena amena sana di ago nioteimasi kaere gauka nufa vene yaku buni maina regamadi, bi moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Uriyenau niyori, bi ini usi dina vene 12 ina rofu baesi niyadi, “Amiye nifeide kumo rautu negau negau ma gagani sanari disi ini varena sana ma ini iruku maina reyaganedi, adina una bi autu sanari amesifa.” ");
INSERT INTO kqc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Idu ina rofu niyo, “Ya yaku iruku mafo kumo iriyaganedi.” Idu nikabai resi niyadi, “Una bi beredi 5 ma oyena remanu maka. Yi mokenari bi mina amiye tau di iruku voi regifa ba?” ");
INSERT INTO kqc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Adina rumana vene bi 5,000 kana.) Ye ini usi dina vene rofu niyo, “Amiye nifa kumo tau neinei 50 dudu kana ameyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mina kana rei vau reyadiri, ");
INSERT INTO kqc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","bi beredi 5 ma oyena remanu moisi omari vegasa buni tora gade Sei rofu masi bi beredi ma oyena moi okusi ini usi dina vene maro bi amiye tau rofu rau reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ye iriyadi ma ini uka bere niyadi. Ma ini fereyadi iruku tuta butu resi foroka 12 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kamini Iesu inaike usa usa nigamori, bi ini usi dina vene bi inasa ameyadi. Ye nikaitesi niyo, “Amiye yaku nidedi na bi kaere, vo nidedi?” ");
INSERT INTO kqc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ye nikabai reyadi, “Be yaku nidedi ya bi John Baptist, be yaku nidedi bi Elijah, ma be yaku nidedi bi senagi senagi Sei di ago niyo amiye yokoi, vegu nisi dairiyo.” ");
INSERT INTO kqc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma nikaiteyo, “Idu ya nidedi na bi kaere?” Ye Peter nikabai resi niyo, “Ya bi Sei di Keriso.” ");
INSERT INTO kqc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ye nidiba resi ago gira maro, “Mina bi amiye yokoi rofu ga nioteimaragane.” ");
INSERT INTO kqc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka niyo, “Amiye di mida bi esika esika tau moiyaine, ma tora vene, Sei ma amiye utari naivo vene di varika vene, ma ago gira oteimana vene yaku fufuta masi umuyegedi, ma gabi meda regoderi, dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Resi ina tau noibanu rofu niyo, “Kaere amiye ini ura bi na usi digi ura rego, bi ina kaya ni de resi meda neinei ini satauro moisi na usi baeyaine. ");
INSERT INTO kqc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Adina kaere ini vegu moi vegu rigi ura rego, bi de moigo, idu kaere na dada, ini vegu youfeidego, bi moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Adina beika buni bi amiye yokoi mina kono tora noibanuri baku resi ini vegu eyarego? ");
INSERT INTO kqc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Adina amiye kaere na dada, ma nai ago dada maena rego vonisi, Amiye di mida ini Baba di vabarari ini akeke naivo naivo vimasa okigediri ina rofu ka maena rego. ");
INSERT INTO kqc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Idu rama ya nida, ya bedakai minari bi de muyegedi, idu Sei di ourefeidena amena sana dego vegedi mamo.” ");
INSERT INTO kqc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kamini mina niyo meda 8 koina niyori, Iesu yaku Peter, James ma John afesi omuna ikari Sei rofu usa usa nigi boyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Usa usa nigasa ini roaita idana niyo; ini varuka bi feyo ma kamanika iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma amiye remanu bi inasa sina nigamadi. Bi Moses ma Elijah, ");
INSERT INTO kqc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kaere bi vabara iniye dudu ogau niyadi. Ini sina bi Jerusalem ri gokai muyesi Sei di sina moi rama aego. ");
INSERT INTO kqc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter ini asiyakasa bi varei muyeyadi. Varena dudu dadisi ne regasa Iesu di vabara ma inasa are regamadi amiye remanu veyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ye etagae reyadiri, Peter yaku Iesu rofu niyo, “Ourefeidena amiye, bi buni una bi minari! Una bi karaga regode akugifa, yokoi bi yi, yokoi bi Moses di, ma yokoi bi Elijah di.” (Ina bi ina diba de beika ago nigamo bi.) ");
INSERT INTO kqc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mina nigamori, bi seuya desi bou riyo ma ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma ago goroka yokoi mina seuya ideri niyo, “Mina bi nai Mida, nai auba reyaka amiye—ina bi neidefa!” ");
INSERT INTO kqc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mina goroka ago nina koina niyori, Iesu inaike are regamo. Ma babo nisi beika mina medari vata niyadi vesi bi amiye yokoi nioteimana de reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ari uveyori, bi mina omunari gutuna dairi neyadiri, bi amiye tau gade gade ina baku reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma mina amiye tau gade fogori, amiye yokoi raka niyo, “Oteimana amiye, ya rofu niguyaguya reida, baesi nai mida—nai mida yokoi maka ve! ");
INSERT INTO kqc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vima no yaku moisi raka ni tavoi resi moi tururu redo ma vena kabudo redo. Mina yaku toga toga esika masi ini roaitari de feredo! ");
INSERT INTO kqc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ye yi usi dina vene mina vima no meki reyaganedi niguyaguya reyaka, idu anua reyadi.” ");
INSERT INTO kqc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu yaku nikabai reyo, “Ya gua mokena vari gira de aena mokena no vene, gokaisanu ari doba yasa amegida? Meda gokaisanu yasa moimai regida? Yi mida minari afei bae.” ");
INSERT INTO kqc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mina mida afei boyori, vima no yaku konori maku nesi moi tururu reyo. Idu Iesu yaku mina vima no rofu nikaka resi mida moi buni risi ini baba dairi maro. ");
INSERT INTO kqc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Amiye tau Sei di vava vegasa tururu reyadi. Ina tau Iesu beika reyo mina tururu reyadiri, bi Iesu yaku ini usi dina vene rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Toto ga nifo na beika ya nigi reida bi! Adina Amiye di mida bi amiye di vana rofu siri regi redo.” ");
INSERT INTO kqc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Idu beika ago niyo bi ini adari de ufateyadi. Ma mina sina bi ina rofu sui niyo, ye ga veifateyagane. Ye mina ago rofu nikaitegi ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kamini iniye iniye kayamo regi reyadi, kaere bi tora iniye, ");
INSERT INTO kqc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ma Iesu ina diba beika ini ukari mokegamadi, ye mida keika yokoi moisi ina atafu moi are resi ");
INSERT INTO kqc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","niyo, “Kaere yaku mina mida nai roka dudu moi dui rego, bi na moi dui redo. Ma kaere yaku na moi dui rego, bi na nifeideyo amiye moi dui redo. Adina kaere yi fogori, ini mokenari roka tora de bi, ina bi tora iniye.” ");
INSERT INTO kqc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John yaku niyo, “Ourefeidena amiye, amiye yokoi yi roka dudu vima no meki regamo ma veyafa, idu nivaigika reyafa, ini adina bi unasa de amiye.” ");
INSERT INTO kqc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma niyo, “Nivaina ga refa, adina kaere ya rofu no de redo, ina bi yi.” ");
INSERT INTO kqc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu omari moi bogedi meda negau nigamo dada, uka gira dudu Jerusalem ri digi neyo. ");
INSERT INTO kqc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ina yaku ini ago moi raga rededi vene siko Samaria vene di rautu yokoiri nifeideyo, ma ini amena sana nitore regi dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Minari amededi vene yaku gedu maradi, adina bi Jerusalem ri digi neyo dada. ");
INSERT INTO kqc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ini usi dina amiye remanu, James ma John, mina vegu vegasa niyadi, “Varika amiye, gokai mokeisa, ita omari nigifa ma desi vai vau rego ba?” ");
INSERT INTO kqc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Idu kero resi emaro. ");
INSERT INTO kqc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kamini rautu yokoiri boi neyadi. ");
INSERT INTO kqc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ida boyadiri, amiye yokoi yaku ina rofu niyo, “Ya goina digiya, na bi ya usi digida.” ");
INSERT INTO kqc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu yaku niyo, “Sufa auna bi ini fore ruba nufa, ma erena odoro didedi bi ini buri nufa, idu Amiye di mida bi ini ada aesi raudai rena sana bi koina.” ");
INSERT INTO kqc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma amiye yokoi rofu ka niyo, “Na usi bae.” Idu niyo, “Varika amiye, na ferei kumo bosi nai baba, kaere muyeyo, siko moi guri aegida.” ");
INSERT INTO kqc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Idu niyo, “Muyena vene ferei kumo ini muyena iniye moi guri aeyagane. Idu ya bi bosi Sei di ourefeidena amena sana di ago niodoro re.” ");
INSERT INTO kqc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yokoi yaku ka niyo, “Varika amiye, ya usi baegida, idu nai yava vene kokora nigida kumo.” ");
INSERT INTO kqc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Idu Iesu niyo, “Amiye yokoi, ini vanari gadi moi gira resi muro di moimai kora resi ne kero rei fufuta rofu ne regasa Sei di ourefeidena amena sanari moimai rena bi buni de nigo.” ");
INSERT INTO kqc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mina fufutari, Varika amiye yaku amiye 72 moisi remanu remanu dudu taoni ma gagani neineiri ourei digedi, siko nifeideyo ma diyadi. ");
INSERT INTO kqc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kamini niyo, “Iruku rama butu rena bi tora gade, idu moimai rededi vene bi tau de. Mina dada, butu rena Varika amiye rofu usa usa nifa kumo moimai rededi vene nifeidego, ma ini butu butu resi moi aeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Diga mokefa; na yaku mamoe mida kana sufa gadeva auna di fogori ya nifeideida. ");
INSERT INTO kqc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Fore di pausi, dura, o yuka ro moina ga refa. Idauri amiye yuata sina ga nifa. ");
INSERT INTO kqc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ye goina yavari dui regedi, bi siko yomakai nifa, ‘Sei di uka amuta bi mina yavari ameyaine.’ ");
INSERT INTO kqc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ye mina yavari uka amuta nufa amiye yokoi amedo vonisi, bi yi uka amuta niyo bi inasa ameyaine; idu de vonisi, bi yi uka amuta maro bi dairi moigedi. ");
INSERT INTO kqc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yava idana idana rofu di ga refa; mina yavari maka amesi beika ya mabigedi, inasa irigedi, adina moimai redo amiye bi ini moimai reyo obini kana moigo bi buni. ");
INSERT INTO kqc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Goina taoni okigedi ma ya moi dui resi beika iruku ya magedi bi irifa. ");
INSERT INTO kqc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ini gauka vene moi buni risi ina vene rofu nifa, ‘Sei di ourefeidena amena sana bi ya atafu okiyo.’ ");
INSERT INTO kqc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Idu taoni yokoi dui regedi ma amiye yaku ya moi dui de regedi, bi taoni ida nefau are resi nifa, ");
INSERT INTO kqc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ye yi taoni di budoka, uni yuka rafori usi eyaresifa mini, ka bi ya rofu gubuyo rena kana. Yomakai ya ya diba niyagane Sei di ourefeidena amena sana bi atafu okiyo!’ ");
INSERT INTO kqc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya rofu nida, kota rego medari Sodom taoni vene di esika esika moigedi bi keika, idu mina taoni vene di esika esika moigedi bi tora gade! ");
INSERT INTO kqc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Chorazin vene ya rofu bi iriyeduka iniye, ma Bethsaida vene ya rofu ka bi iriyeduka iniye! Adina bi, mokena vegu ya vene rofu reyaka kana, mina Tyre taoni ma Sidon taoniri reyagadu vonisi, bi mirona vene bi senagi guruo amena kana varuka akusi udo ini roaita ifi rei boga degasa reyaidu, mina yaku oteimaragadu, ina bi ini vegu no feresi moi etagae riyadi! ");
INSERT INTO kqc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Idu Sei di kota rego medari, Tyre ma Sidon taoni vene di esika esika moigedi bi keika, idu ya vene di esika esika moigedi bi tora gade. ");
INSERT INTO kqc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma ya Capernaum vene, ya bi omari moi odoro de rego! Idu, muyena vene di amena sanari negedi!” ");
INSERT INTO kqc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ini usi dina vene rofu niyo, “Kaere ya neidego, bi na neidego; ma kaere ya rofu gedu mago, bi na rofu gedu mago; ma kaere na rofu gedu mago, bi na nifeideyo amiye rofu gedu mago.” ");
INSERT INTO kqc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mina amiye 72 dairisi ada dudu Iesu rofu niyadi, “Varika amiye, vima no ka uni ago neideyadi, yi roka dudu nigamafa dada!” ");
INSERT INTO kqc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma niyo, “Omari gutuna Satani ayena kana yareyo ma veyaka. ");
INSERT INTO kqc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neidefa, na vava ya maraka, aruma ma kaikai fafau disi ya rofu ruda rena amiye di vava tau etei rigedi; ma beika no yaku esika de ya mago. ");
INSERT INTO kqc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Idu vima no yaku yi ago neidededi vonisi, ada ga refa; yi ada regedi di adina bi yi roka bi omari bura reyo dada.” ");
INSERT INTO kqc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mina meda nemokori, Vima kikifa yaku Iesu di uka ada dudu vata baeyo ma niyo, “Baba, oma ma kono di Varika amiye, yi roka moi odoro rida, adina ya bi mina vegu mokena tora vene rofu moi sui risi mokena keika keika vene kaere bi mida mida kana moi ogau riyo. Baba, yi ukari mokeyo kana, makai vata niyo. ");
INSERT INTO kqc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nai Baba yaku beika baika tau na nimaro. Ma amiye yokoi ina toto ini Mida, idu ini Baba maka ina diba. Ma amiye yokoi ka ini Baba toto, ini Mida maka ina diba, ma ini Mida yaku ka Sei bi kaere moi ogau rigi ura redo amiye rofu bi rama iniye vegedi.” ");
INSERT INTO kqc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kamini ini usi dina vene rofu kero resi sui dudu niyo, “Yi nemoko bi buni tora gade maro, ya beika vededi dada! ");
INSERT INTO kqc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Adina ya nida, Sei di ago niyadi vene ma kini tau ini ura bi ya beika vededi mina vegedi, idu bi de veyadi. Ma ya beika neidededi, mina neidegedi, idu bi de neideyadi.” ");
INSERT INTO kqc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma ago gira oteimana amiye yokoi Iesu di uka maina rena nivegika are resi niyo, “Oteimana amiye, beika regida, ma toga toga ameibobina vegu moigida?” ");
INSERT INTO kqc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ina rofu niyo, “Ago gira ideri bi gokai bura reyadi? Ya yaku bi gokai veisa?” ");
INSERT INTO kqc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ye nikabai reyo, “‘Yi uka meko noibanu, yi vima noibanu, yi yeiva tora noibanu, ma yi mokena noibanu dudu Varika amiye yi Sei uka ma’; ma ‘Ya kaya uka maisa kana, yi atafuri amedo amiye uka ma.’” ");
INSERT INTO kqc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kamini niyo, “Ya rama niyo mini makai regasa bi ameibobigiya.” ");
INSERT INTO kqc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Idu mina amiye iniye moi rama regi Iesu dudusa nikaitesi niyo, “Na atafuri amedo amiye bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma nikabai resi niyo, “Amiye yokoi Jerusalem gutuna Jericho negasa bi duma duma vene di vanari dui reyo. Ubobo resi muyei tamatama regasa bi ini varuka ita kutusi moisi ferei diyadi. ");
INSERT INTO kqc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Minari bi Sei ma amiye utari naivo amiye yokoi bi mina idari negamo. Mina ubobo reyadi amiye vegasa bi ida berou eta rofu boi nesi kamini ebu rei neyo. ");
INSERT INTO kqc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levi amiye yokoi ka makai mina sanari baesi vegasa bi ida berou eta rofu boi nesi bi kamini ebu rei diyo. ");
INSERT INTO kqc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria amiye yokoi ka mina ida baeyo. Idu mina amiye atafu okisi vegasa bi ina rofu iriyeduka resi ");
INSERT INTO kqc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","bosi diga ma waini dudu uyadi sana mina koitesi fafa riyo. Ini donkey fafau aesi afei bosi oto vene di amena varena yavari nari reyo. ");
INSERT INTO kqc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Uriyaku dadisi bi meda remanu di moimai di fore moisi yava di madini masi niyo, ‘Ina nari re. Beika baika ina fafau regiya bi dairi baegasa ya magida.’” ");
INSERT INTO kqc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu yaku ini ago ni vau resi niyo, “Ya yaku mokeisa bi mina amiye regodenuri, kaere bi mina amiye rofu duma duma vene di vanari dui reyo, bi ini atafu amedo amiye kana?” ");
INSERT INTO kqc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma ago gira oteimana amiye yaku niyo, “Amiye kaere ina rofu iriyeduka reyo.” Ma niyo, “Disi ya ka mina kana vegu re.” ");
INSERT INTO kqc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kamini Iesu ini usi dina venesa bosi rautu yokoiri okiyadiri, bi rema yokoi roka Martha yaku ini yavari moi dui reyo. ");
INSERT INTO kqc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ina bi ini rasini nufa, ini roka bi Mary. Mary bi Varika amiye di yuka atafu amesi ini sina nigamo mina neidegamo. ");
INSERT INTO kqc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha bi ini yavari amiye afei dui reyo dada, mina kero karo regamo. Dada bosi Iesu rofu niyo, “Varika amiye, nai rasini bi beika baika bi fereyo dada, na yaku maka reida, idu gokai mokeisa? Ni kumo na moi vana reyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Idu nikabai resi niyo, “Martha, ya bi beika baika tau resi yi ada moi esika resi mokena tau tora moisa, ");
INSERT INTO kqc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","idu yokoi maka bi tora iniye. Mary beika mokei redo bi buni mini. Ina rofu mina vegu redo bi una yaku de moi etagae rigifa.” ");
INSERT INTO kqc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Meda yokoiri, Iesu yaku gagani yokoiri usa usa nigamo. Ini usa usa ni vau reyori, ini usi dina amiye yokoi yaku niyo, “Varika amiye, gokai usa usa nigifa mina una oteima, John Baptist yaku ini usi dina vene oteimagamo kana.” ");
INSERT INTO kqc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu yaku ina vene rofu niyo, “Usa usa nigediri, bi yomakai nifa: ‘Baba: Yi roka bi kikifa iniye; yi ourefeidena amena sana bi deyaine. ");
INSERT INTO kqc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ari neinei di iruku una mai baesa, mina una ma. ");
INSERT INTO kqc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma uni vegu no koite maku, adina una ka amiye tau di vegu no una rofu rededi, moi erufusifa. Ma uka maina regika nivena rofu ga una moi ourefeide.’” ");
INSERT INTO kqc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Resi niyo, “Ya yokoi mina urusa tobo iniyeri bosi yi asini rofu usa nigiya vonisi, ‘Nai asini, beredi regode na ma. ");
INSERT INTO kqc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Adina bi nai asini yokoi yaku yava ika oto disi nai yavari okiyo ma nasa bi iruku koina!’ ");
INSERT INTO kqc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Idu yi asini bi yava ideri ya nikabai resi nigo, ‘Ada esika na mana ga re! Ida vena bi sena biri risi ufe reyaka, ma nai midasa bi sena vareyafa. Dadisi beika baika ya mana ka bi gira iniye.’ ");
INSERT INTO kqc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya vene rofu nida mina bi de dadigo, ini asini vana magi bi, idu besa besa usa nigiyari, bi dadigo, yi beika usa niyo, mina ya mago. ");
INSERT INTO kqc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ye ya vene rofu nida: Usa nifa kumo ya mago; maina refa kumo baku regedi; raka nifa kumo ya rofu ida vena moi ekego. ");
INSERT INTO kqc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Adina kaere yaku usa usa nigo bi moigo, ma kaere maina rego, bi baku rego, ma kaere raka nigo, bi ina rofu ida vena moi ekego. ");
INSERT INTO kqc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Goina baba yi fogori bi ini mida yaku oyena usa nigori, bi aruma mago? ");
INSERT INTO kqc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ye erena unema vo nigori, bi kaikai mago ba? ");
INSERT INTO kqc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ye ya vegu no rededi vene yi mida mida gugura buni magi diba nidedi vonisi, bi Baba omari amedo amiye yaku Vima kikifa usa nigedi vene bi besa besa ya mago!” ");
INSERT INTO kqc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kamini Iesu yaku babo vima no yokoi meki regamo. Mina vima no yakuyori, bi mina amiye ago niyo, ma amiye tau gade tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Idu amiye be yaku niyadi, “Vima no di ourefeidena amiye Beelzebul di vava dudu vima no meki redo.” ");
INSERT INTO kqc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma be yaku omari rebe yokoi reyainedi nikaiteyadi, ebene regika bi rama ba ide Sei bi ini vava maro. ");
INSERT INTO kqc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Idu mina vene di mokena vesi ina rofu niyo, “Gagani yokoi uta okusi iniye iniye berou berou are resi ruda rego vonisi, bi berou berou keto rego. Ma rubu iniye iniye berou berou ruda rego vonisi, bi berou berou keto rego. ");
INSERT INTO kqc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ye Satani ini venesa ka iniye iniye okusi ruda regedi vonisi, gokai resi ini ourefeidena amena sana bi are rego? Adina ya yaku nidedi, na bi Beelzebul di vava dudu vima no meki reida. ");
INSERT INTO kqc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ye na yaku vima no Beelzebul di vava dudu meki reida vonisi, bi yi vene bi kaere di vava dudu meki rededi? Mina dada, ini beika rededi yaku yi ago bi rama de vo nidedi! ");
INSERT INTO kqc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Idu Sei di vava dudu vima no meki reida vonisi, bi Sei di ourefeidena amena sana bi ya vene rofu deyo mini. ");
INSERT INTO kqc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Yeiva amiye ini mari moi gira resi ini yava nari regori, bi ini beika baika bi buni amebigedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Idu yeiva iniye amiye yokoi inasa ruda resi ugasa ini moi gira regamo mari moigo. Makai mina amiye yeiva mokeyo, bi ina kaya nari rei mona rego dada. Kamini mina yeiva iniye amiye beika tau yokoi yokoi rau rego. ");
INSERT INTO kqc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Amiye kaere nasa de, bi na rofu de; ma kaere nasa butu de rido, bi rerevaida nido. ");
INSERT INTO kqc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Vima no yaku amiye yokoi ferei yakusi bi koru de gaganiri ameinu rena sana maina rego. Yokoi baku rena de resi iniye kamini nigo, ‘Nai yava ferei yakuyaka, minari dairigida.’ ");
INSERT INTO kqc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dairisi mina yava baku regori, bi gudare resi ae dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Resi bi disi vima no 7 iniye ini no ebu reyadi, afei minari baesi amegedi. Ye mina amiye di amena gua bi no iniye, sena kana ebu reyo.” ");
INSERT INTO kqc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu yaku mina sina niyori, amiye tau gade di fogori, rema yokoi yaku ina rofu raka nisi niyo, “Ya moi vata resi susu ya maro rema bi buni tora gade moido!” ");
INSERT INTO kqc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Idu nikabai resi niyo, “Rama, idu kaere Sei di ago neidededi, bi buni tora gade moidedi!” ");
INSERT INTO kqc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amiye tau gade Iesu atafu egogo reyadiri, ina vene rofu nigi kora resi niyo, “Vegu no resi gua amededi vene yaku rebe maina rededi; rebe yokoi de mago, idu Jonah rofu vata niyo rebe mina maka maro. ");
INSERT INTO kqc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Adina Sei yaku Jonah moisi Nineveh di rebe riyo kana, ye ina yaku ka Amiye di mida moisi gua amededi vene di rebe kana rigo. ");
INSERT INTO kqc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Meda baedo rama eta rofu di kuini bi Sei di kota rego medari gua amededi venesa edadisi beika reyadi vegu mina nifafana rego, adina bi gagani maikeri gutuna kini Solomon di mokena tora neidegi baeyo. Ye vefa, amiye yokoi kaere Solomon ebu reyo bi mini. ");
INSERT INTO kqc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineveh vene Sei di kota rena medari gua amededi venesa are resi ini beika reyadi vegu nifafana regedi, adina bi Jonah yaku Sei di ago nirausi reyori, vegu no feresi moi etagae riyadi. Ma vefa, amiye yokoi Jonah ebu reyo bi mini! ");
INSERT INTO kqc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Amiye yokoi yaku ramefa orisi sui sanari de moi sui rigo, o foroka gabireri de aego; idu bi ini ikina sanari ikigo, ye kaere yava dui rededi, ka ini vabara vegedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yi nemoko bi ramefa di vabara kana yi roaitari. Ye yi nemoko buni vonisi, bi yi roaita tau noibanu bi vabara yaku vata baego. Idu yi nemoko no vonisi, bi yi roaita tau noibanu bi mukuna yaku vata baego. ");
INSERT INTO kqc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mina dada, yi ukari vabara nari rei mona re, ye mukuna ga niyainedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yi uka tau noibanu vabara yaku vata baego ma mukuna keika yi ukari ka de amego vonisi, bi yi uka tau noibanu vabara iniye nigo, ramefa di vabara yaku ya moi vabara rego kana.” ");
INSERT INTO kqc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu sina ni koina reyori, bi Pharisee amiye yokoi yaku raka niyo inasa iruku irigedi. Ye ini yava dui resi iruku irigi ameyo. ");
INSERT INTO kqc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ye Iesu siko ini vana de koitesi iruku iriyo ma Pharisee amiye mina vegasa tururu reyo. ");
INSERT INTO kqc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ye Varika amiye ina rofu niyo, “Ya Pharisee vene bi biyo ma siua bi etofaro maka koitededi, idu yi uka ideri bi duma udu ma vegu no vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ada de vene! Sei yaku etofaro riyo vonisi, bi ideri ka riyo ba ide? ");
INSERT INTO kqc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yi uka noibanu dudu irava vene mafa; mina regediri, bi beika baika tau bi ya rofu ruaka nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ye ya Pharisee vene, iriyeduka no iniye iniye ya rofu bi! Adina bi iruku moi sisika rena roka mint ma rue ma bedakai tau vakoi di yuveita neinei moisi berou berou 10 ri yokoi maka bi Sei rofu madedi, idu ya bi Sei rofu vegu rorobo rena ma uka mana de rededi. Idu mina reyagane kumo ma mina vegu rededi bi ga ferefa. ");
INSERT INTO kqc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ya Pharisee vene, bi iriyeduka no iniye iniye ya rofu bi! Adina usa usa yavari amena sana ka buni torari, ma maketiri amiye yaku ago buni dudu matagini reyagane, ura rededi. ");
INSERT INTO kqc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iriyeduka no iniye iniye ya rofu bi! Adina ya bi amiye guri aeyadi sana sena tovo niyadi kana. Ye amiye guri de vesi fafau etei ri didedi, adina ina toto mina bi amiye guri aeyadi sana bi ini kino amedo.” ");
INSERT INTO kqc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ago gira oteimana amiye yokoi ina rofu niyo, “Oteimana amiye, ya makai sina nigasa bi una rofu ka ni no reisa mini!” ");
INSERT INTO kqc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Idu nikabai reyo, “Ya ago gira oteimana vene, ka iriyeduka no iniye iniye ya rofu bi! Adina toe uakaina anua rededi mina amiye fafau aededi, idu yi vana ebuna yokoi dudu bi mina toe de erufugedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iriyeduka no iniye iniye ya rofu bi! Adina yi tutubena vene yaku Sei di ago niyadi vene umuyeyadi ma ya vene bi ini guri yava ikefata dudu moi buni buni rededi. ");
INSERT INTO kqc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mina dada, ya kaya ninegau rededi yi tutubena yaku beika reyadi bi buni, ini adina Sei di ago niyadi vene umuyeyadi, ma ya bi ini guri yava akudedi. ");
INSERT INTO kqc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mina dada, Sei yaku ini mokena tora dudu ka niyo, ‘Nai ago nidedi vene ma nai nifeidena vene ina rofu nifeidegida; be bi umuyesi be bi esika esika magedi.’ ");
INSERT INTO kqc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dada Sei yaku kono riyo medari gutuna kaere Sei di ago niyadi vene tau gade umuyeyadi, gua amededi vene bi ini kaunava baku regedi: ");
INSERT INTO kqc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel umuyeyo gutuna boyo Zechariah, kaere bi ori sisika rena fore fata ma Sei di yava utari umuyeyadi. Mina bi rama, ya nida gua amededi vene bi mina kaunava baku regedi! ");
INSERT INTO kqc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ago gira oteimana vene, iriyeduka no iniye iniye ya rofu bi! Adina bi diba nina di sana di ida vena ekena etagae reyadi mini. Ya bi de dui rei bosi be yaku dui rena mokededi bi, ya yaku ini ida biri ridedi!” ");
INSERT INTO kqc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu yaku mina sana fereyori, bi Pharisee vene ma ago gira oteimana vene yaku nifafana resi ago tau rofu nikaitegi kora regamadi, ");
INSERT INTO kqc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","eru regedi ma ago rama de yokoi nigori, bi moi gira regedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mina ituari, amiye tau gade gade okisi egogo resi iniye iniye etei ri foyoma regamadi, ye Iesu siko ini usi dina vene rofu nigi kora reyo, “Ya kaya Pharisee vene di yeast nari rei mona refa—mina bi ini ofarosi vegu. ");
INSERT INTO kqc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ye beika bi bou riyadi, bi moi ogau rigedi, ma beika bi sui niyadi, bi moi diba nigedi, ");
INSERT INTO kqc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","mina dada beika sina mukunari niyadi, bi vabarari neidegedi. Ma beika sina bi yava ideri kiya mumugu niyadi, bi yava tebori are resi nirausi regedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ye nai asiyaka vene, ya nida, roaita maka umuyegedi vene ori ga refa, idu gabi vegu no yokoi rofu anua regedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Idu ya oteimagida kaere rofu ori regedi: Sei rofu ori refa, kaere bi ya umuyesi gabi ita mokari makugo di vava nufa, rama ina rofu maka ori refa! ");
INSERT INTO kqc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Erena keika 5 di davana bi fore keika remanu dudu ba? Ma Sei yaku ina tau noibanu bi yokoi maka toto de nigo. ");
INSERT INTO kqc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ye yi ada iye tau vakoi ka gokaisanu amedo bi duaiya reyo. Ye ori ga refa. Ya amiye bi isivaga iniye, erena keika tau gade kana de! ");
INSERT INTO kqc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ye na yaku ya nida, kaere yaku amiye di nemokori niogau rego ina bi nai, bi Amiye di mida yaku ka Sei di naivo naivo vima di nemokori makai niogau rego. ");
INSERT INTO kqc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Idu kaere yaku amiye di nemokori na fufuta mago, bi Sei di naivo naivo vima di nemokori ka fufuta mago. ");
INSERT INTO kqc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ma kaere amiye yaku Amiye di mida rofu ago no nigo, Sei yaku ini vegu no koite makugo; idu kaere yaku Vima kikifa rofu ini roka moi no rigo, ini vegu no bi de koite makugo. ");
INSERT INTO kqc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ye usa usa yavari, gavana, o ourefeidena vene di nemokori, kota regi ya moi erokoko regediri, yi mokena toe ga moiyagane, gokai sina nigedi o gokai nikabai regedi rofu. ");
INSERT INTO kqc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Adina mina medari, Vima kikifa yaku ya beika ago nigedi mina ya oteimago.” ");
INSERT INTO kqc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Amiye tau gade di fogori, amiye yokoi yaku ina rofu niyo, “Oteimana amiye, nai dubuini nigiya kumo beika baika uni baba fereyo nasa rau reyaine.” ");
INSERT INTO kqc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nikabai resi niyo, “Ya remanu di sina sina neidegi yi beika baika rau regi di vava na mana kode.” ");
INSERT INTO kqc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kamini ina vene tau rofu niyo, “Ya kaya nari rei mona regasa beika baika tau rofu udu ga refa. Adina amiye di vegu iniye bi mina beika baika tau yaku de mago.” ");
INSERT INTO kqc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kamini Iesu yaku mokena ago yokoi ina rofu niyo: “Gugura tau amiye, ini kono fafauri, muro iruku tora gade iniye rama niyo. ");
INSERT INTO kqc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dada iniye mokesi niyo, ‘Gokai kamini regida? Iruku aena sana bi koina.’ ");
INSERT INTO kqc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Resi niyo, ‘Yomakai regida: nai iruku aena sana ukero vau resi tora risi nai iruku ma sogona tau gade minari aegida. ");
INSERT INTO kqc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Resi bi na kaya rofu nigida, lagani tauri mina beika tau bi yi. Nai veguri mina beika baika tau kiya kiya iriga vaiga ada regasa amebigida!’ ");
INSERT INTO kqc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Idu Sei yaku ina rofu niyo, ‘Ya bi ada de amiye! Gua mina urusari umuyegiyari, bi kaere yaku mina beika tau ya kaya moi tauri fereyo mina moigo?’” ");
INSERT INTO kqc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Resi Iesu ini sina ni vau regi reyo, “Amiye rofu bi makai: kaere bi beika baika tau inaike moiyo, idu Sei di mokenari, bi beika baika tau de moiyo.” ");
INSERT INTO kqc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kamini Iesu yaku ini usi dina vene rofu niyo, “Mina dada ya nida, vegu amegasa beika irigedi, o beika varuka yi roaita yaku akugedi, mokena toe ga moifa. ");
INSERT INTO kqc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Adina vegu amena bi iruku ebu redo, ma roaita bi varuka ka ebu redo. ");
INSERT INTO kqc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yomina gayo bora erena vefa; ina bi yoya varina, o iruku goena de rededi; dokema, o iruku aena sana ka koina; idu Sei yaku vana redo. Ya bi mina erena ebu rena iniye reyadi! ");
INSERT INTO kqc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ye ya kaere yaku ini ukari mokena toe moigori, mina mokena yaku ini vegu moi doba rego ba? ");
INSERT INTO kqc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mina mokena dudu, mina beika keika anua reisa, ye beika resi mokena toe tau moisa? ");
INSERT INTO kqc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sufari farofaro bi gokai bodedi, mina vefa: moimai de resi varuka de ridedi. Idu ya nida, kini Solomon di varuka burefe tau ka bi mina sufari farofaro kana de. ");
INSERT INTO kqc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sei yaku sufari farofaro imu mado. Mina farofaro bi gua vegu amedo mini, idu agiya bi kufusi makugedi, ma roko nigori, bi ita mokari origedi. Ye yi varuka dudu ya nari rei mona iniye rego, ya kaere bi mokena vari gira keika aededi vene! ");
INSERT INTO kqc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ye beika iruku ma koru irigedi di, yi ukari mokena toe ga moifa. ");
INSERT INTO kqc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Adina mina beika baika tau bi mina konori gagani gagani vene yaku maina rededi.) Idu yi Baba ina diba yasa beika baika koina bi. ");
INSERT INTO kqc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Idu Sei di ourefeidena amena sana maina refa kumo mina beika baika tau ya mago. ");
INSERT INTO kqc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ya amiye tau ori ga refa, adina yi Baba bi ini ourefeidena amena sana ya rofu magi ada redo. ");
INSERT INTO kqc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yi beika baika nufa, bi sero resi fore bi irava vene mafa. Yi beika baika tau omari aefa: mironari fore pausi de no nigedi, ma duma amiye moigi anua rego, ma nurina ka de moi no rigo. Ye toga koina de nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Adina yi gugura buni tau amededi sanari, yi uka ka amebigo. ");
INSERT INTO kqc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Yi varuka mitai ri gira resi yi ramefa orisi toro dudu amefa. ");
INSERT INTO kqc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ini varika amiye, rema mena irakuna gutuna dairigori, naivo naivo vene toro rededi kana, amebifa. Ini varika amiye bi rema mena irakuna gutuna dairisi raka nigori, evade maka dadisi ida vena moi eboka regedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mina kana vene rofu bi buni tora gade iniye, adina bi ini varika amiye dairigori, bi varena de, ina rofu toro regasa nari amededi dada! Ya vene rofu nida, dadisi ini varika amiye raka nisi moimai regika ini varuka mitai rigo, ma iruku irina sanari amegediri, bi naivo rego. ");
INSERT INTO kqc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Uru tobori baego, o uriyaku vabarasa baego, ina toro regasa nari rededi vene baku regori, bi buni iniye moigedi! ");
INSERT INTO kqc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Idu ya diba nifa, yava biyaguna amiye siko diba nigo vonisi, duma amiye baego meda nemoko bi, ini yava nari rego, duma amiye ideri ga baeyainedi. ");
INSERT INTO kqc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye toro dudu amefa, adina Amiye di mida bi mokena de rededi meda nemokori baego.” ");
INSERT INTO kqc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter yaku Iesu rofu nikaitesi niyo, “Varika amiye, mina mokena ago bi una rofu maka nisa, ba amiye tau noibanu di nisa?” ");
INSERT INTO kqc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ye nikabai resi niyo, “Kaere bi vegu rama redo mokena tora nufa naivo amiye, ini varika amiye yaku vava mago, ini yava nari regi naivo vene be di iruku ini meda ramari rau rego. ");
INSERT INTO kqc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ini varika amiye yaku dairisi baku rego, mina vegu regasa amebigori, bi mina moimai rei tavoi redo amiye bi ada iniye rego! ");
INSERT INTO kqc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rama ya nida, bi vava mago, dada ini beika baika tau nari rego. ");
INSERT INTO kqc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Idu mina moimai rei tavoi redo amiye bi iniye rofu mokesi nigo, ‘Nai varika amiye bi ari dobari dairigo.’ Kamini ini moimai rei tavoi rena rumana rema tau ugi kora resi iruku irigasa koru gira moiga amebigori, ");
INSERT INTO kqc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ini mokena de redo ariri ma meda nemokori ina toto, ini varika amiye dairisi mina moimai rei tavoi redo amiye di roaita nugai tumu tumu resi mokena vari gira de aena vene di sanari aego. ");
INSERT INTO kqc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma mina moimai rei tavoi redo amiye, kaere bi ini varika amiye di mokena diba, idu yomakai kana dogo resi de rego, bi ubobo tora gade rego. ");
INSERT INTO kqc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Idu kaere naivo amiye, ini varika amiye di mokena bi ina toto, idu vegu no reyo dada, bi ubobo keika rego. Ma kaere moimai tora gade ina rofu maro, ina ka bi moimai tau gade reyaine; ma kaere besa moimai tora gade maro, ka bi moimai besa reyaine. ");
INSERT INTO kqc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nai deyaka bi mina konori ita origi. Nai mokenari bi ori katugo kumo! ");
INSERT INTO kqc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nai babatiso mago; ma nai mokena toe evade moigida kumo! ");
INSERT INTO kqc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ga mokefa na mina konori deyaka, bi uka amuta moi soka reyaka. Ide, idu ya nida na bi amiye iniye iniye utama okugi deyaka. ");
INSERT INTO kqc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gua mina medari gutuna kaere ini rema midasa bi 5 amededi, mina okugida; regode berou ma remanu berou utama ma remanu berou ma regode berou utama, makai okugida. ");
INSERT INTO kqc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iniye iniye utama okuyaganedi: baba ini rumana midasa, rumana mida ini babasa; nono ini vefasa, vefa ini nonosa; radiyaka tora ini radiyakasa, radiyaka ini radiyaka torasa.” ");
INSERT INTO kqc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kamini Iesu yaku ka amiye tau gade rofu niyo, “Meda nedo eta rofu gutuna seuya yokoi dadi baegori, bi vesi evade nigedi, ‘Mina bi miya regi redo,’ resi bi miya redo. ");
INSERT INTO kqc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma meda baedo rama eta gutuna aura ufu rebigori, bi nigedi, ‘Meda sei regi redo,’ resi bi sei redo. ");
INSERT INTO kqc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ofarosi vene! Ya bi oma ma kono vesi bi beika ari gua una mago bi diba nigedi. Beika resi gua yomina meda di ari bi de vei mama regi bi ya toto? ");
INSERT INTO kqc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Beika resi ya kaya vegu bi rama ba ide mina de moidedi? ");
INSERT INTO kqc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yasa uka yokoi maka de nido amiye, kaere yaku ya kota aegi rena koderi, idama gogo kota sanari bobigediri, mina amiyesa vakoi yi mokena moi yokoi maka ri, adina bi makai de regiya vonisi, bi kota rego amiye di vanari ya aego. Ina yaku bi dibura yava nari redo amiye di vanari ya aego, resi dibura yavari ya aego. ");
INSERT INTO kqc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na ya rofu nida, mina sanari de yakugiya bogo kota ya niyo kana fore mai vau regiya mamo.” ");
INSERT INTO kqc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mina ariri maka, amiye be yaku sina Iesu rofu nioteimaradi, Galilee vene be yaku Sei rofu ori sisika regamadiri, bi Pilate di ruda vene yaku umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kamini Iesu yaku ina vene rofu nikabai resi niyo, “Mina Galilee vene makai muyeyadi dada, ya yaku mokededi bi ini no bi tora iniye Galilee vene tau rofu ba? ");
INSERT INTO kqc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ide iniye! Idu ya nida, ya vene yi vegu no de feresi moi etagae rigedi, bi ya tau noibanu makai muyegedi. ");
INSERT INTO kqc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma mirona amiye 18 Siloam ri yava doba ina fafau yaresi emuyeyo bi gokai? Ya yaku mokededi mina yaku nido, bi ini vegu no bi Jerusalem ri amededi vene tau ebu reyo ba? ");
INSERT INTO kqc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ide iniye! Idu ya nida ya vene yi vegu no de feresi moi etagae rigedi, bi ya tau noibanu makai muyegedi.” ");
INSERT INTO kqc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Resi Iesu yaku mina mokena ago ina vene rofu nigi kora reyo: “Amiye yokoi ini waini murori fuka yabo yokoi variyo ma bodo mina rama be ba de vegika boyo. Idu be de baku reyo. ");
INSERT INTO kqc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dada ini muro redo amiye rofu niyo, ‘Ve kumo, lagani regoderi rama mina fuka yabo odoro maina rei baegamaka, idu de baku reyaka. Nu! Beika resi mina kono moi no regasa amedo?’ ");
INSERT INTO kqc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Idu muro nari redo amiye yaku nikabai resi niyo, ‘Amiye tora, lagani yokoi maka ferei kumo adinari kono tanu masi fonuka aegida. ");
INSERT INTO kqc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Agiya laganiri mina fuka yabo rama aegori, bi buni tora gade, idu ide vonisi, bi nu makugiya.’” ");
INSERT INTO kqc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabati meda yokoiri, Iesu usa usa yavari amiye oteimagamo. ");
INSERT INTO kqc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Minari rema yokoi bi vima no ini roaita ideri amegamo. Mina vima no yaku lagani 18 moi gauka reyo, ye ini uboma bi foki dada, rorobo de nigamo. ");
INSERT INTO kqc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu yaku vesi raka nisi niyo, “Rema, mina gauka ya rofu koina niyo mini!” ");
INSERT INTO kqc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ini vana ina fafau aeyori, bi minari maka uboma rorobo niyo ma bi Sei di roka moi odoro riyo. ");
INSERT INTO kqc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Usa usa yava di ourefeidena amiye bi gubuyo iniye reyo, adina Iesu bi Sabati medari amiye moi buni riyo. Dada dadisi amiye rofu niyo, “Meda 6 ri moimai regifa; dada buni nigika bi mina medari baefa, Sabati medari bi de!” ");
INSERT INTO kqc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Idu Varika amiye yaku nikabai resi niyo, “Ya bi ofarosi vene! Ya yokoi yokoi yaku yi boromakau o donkey mina Sabati medari ini yavari moi etae risi koru usi maragadu. ");
INSERT INTO kqc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mina rema bi Abraham di tutubena, kaere bi Satani yaku lagani 18 moi gira regamo; Sabati medari de erufugiya, ba?” ");
INSERT INTO kqc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Makai niyori, bi ina rofu gubuyo rededi vene bi maena reyadi. Amiye tau tora iniye bi Iesu yaku beika vegu buni vayavaya reyo, mina rofu ada iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ye nikaitesi niyo, “Sei di ourefeidena amena sana bi gokai kana? Gokai kana nirorotari regida? ");
INSERT INTO kqc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ina bi mastadi di yoya kana. Amiye yokoi yaku moisi ini murori variyo ma tora nisi yabo niyori, odoro didedi erena yaku ini tetekari buri riyadi.” ");
INSERT INTO kqc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Dudusa nikaitesi niyo, “Sei di ourefeidena amena sana bi gokai kana nirorotari regida? ");
INSERT INTO kqc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ina bi yeast kana: ye rema yokoi yaku moisi farava siua tora regodesa moi foyoma reyo boyo mina yeast yaku farava moi uruyo mamo.” ");
INSERT INTO kqc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu bi rautu ma taoni neinei amiye oteimasi Jerusalem rofu bogamo. ");
INSERT INTO kqc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Amiye yokoi yaku nikaitesi niyo, “Varika amiye, moi vegu rigo vene bi tau de maka ba?” Ma nikabai resi niyo, ");
INSERT INTO kqc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nana rei yeiva resi ida vena kakaitari dui refa, adina ya nida amiye tau tora ini mokenari bi dui regika idu anua regedi. ");
INSERT INTO kqc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yava amiye yaku dadisi yava ida vena kebi rigo, ma ya bi etofarori are resi raka nisi nigedi, ‘Varika amiye, ida vena una rofu moi eke!’ Idu nikabai resi nigo, ‘Na na toto ya goinari gutuna okiyadi!’ ");
INSERT INTO kqc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kamini nikabai resi nigedi, ‘Vakoi iruku irigamafa, ma ya bi uni taoni di idari oteimagasa digamo!’ ");
INSERT INTO kqc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Idu dudusa nigo, ‘Na na toto ya goinari gutuna okiyadi. Ya mokena rorobo de rededi vene tau na rofu etagae ri difa!’ ");
INSERT INTO kqc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Etofaro ya maku negediri, bi esika dudu isaka nigasa gade aki gigi rebigedi; Abraham, Isaac, Jacob ma Sei di ago niyadi vene tau vegediri, bi Sei di ourefeidena amena sanari amebigedi! ");
INSERT INTO kqc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ye amiye meda dadido eta rofu ma meda nedo eta rofu, ma meda baedo enana eta rofu ma meda baedo rama eta rofu okisi Sei di ourefeidena amena sana ameinu resi irakuna irigedi. ");
INSERT INTO kqc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mironari mamo kaere gabi vene bi ouregedi, ma gua kaere ourededi vene, bi gabi nigedi.” ");
INSERT INTO kqc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mina medari, Pharisee vene be Iesu rofu baesi niyadi, “Ya mina sanari feresi sana be yokoiri di, adina bi Herod yaku ya umuyegi mokena moido.” ");
INSERT INTO kqc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma nikabai resi niyo, “Bosi mina sufa auna mina nifa: ‘Na bi gua ma agiya vima no meki rei feidesi gauka vene moi buni rigida, ma aineka mamo nai moimai koina nigo.’ ");
INSERT INTO kqc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Idu gua, agiya ma aineka nai boida sana bogida, adina bi rorobo de iniye Sei di ago nido amiye kono yokoiri umuyegedi, bi Jerusalem ri maka bi rorobo iniye! ");
INSERT INTO kqc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem taoni vene o! Ya vene yaku Sei di ago niyadi vene umuyesi Sei ya rofu nifeideyo vene fore dudu uyadi. Uru gokaisanu yi mida mida egogo regi ura regamaka, kokoro kosini yaku ini mida ini eta gabireri bou rido kana, idu ya vene bi na gedu magamadi! ");
INSERT INTO kqc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ye yi nivakena sana bi autu nisi digo. Kamini ya nida, de na vegedi bogo meda yokoi okigori mamo nigedi, ‘Varika amiye di roka dudu baedo amiye buni tora gade maraine.’” ");
INSERT INTO kqc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabati meda yokoiri, Iesu yaku Pharisee di ourefeidena amiye yokoi di yavari iruku irigi boyo. Kamini minari, amededi vene tau yaku Iesu yaku beika rego, mina vei mona regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yuka vana ururu reyo amiye yokoi Iesu di nemokori baesi are reyo. ");
INSERT INTO kqc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kamini ago gira oteimana vene ma Pharisee vene rofu nikaitesi niyo, “Ago gira rofu gauka vene Sabati medari moi buni rigifa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Idu de nikabai reyadi. Kamini Iesu yaku mina gauka amiye moisi moi buni risi nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ye ina vene rofu niyo, “Ya kaere yi mida, o yi boromakau nufa kono rubari keto rei nego vonisi, bi evade Sabati medari moi yakugo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Idu bi nikabai rena anua reyadi ini mina agori. ");
INSERT INTO kqc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu yaku raka niyadi vene be veyo, amena sana burefe maina regamadi, dada mina mokena ago ina vene rofu niyo: ");
INSERT INTO kqc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Rema mena irakuna regi vonisi, amiye yokoi yaku ya raka nigori, bi amena sana burefe minari ga ame, mina amena sana bi raka niyadi amiye tora iniye yokoi di amena sana baebu. ");
INSERT INTO kqc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Resi bi ya roada raka niyo amiye yaku ya rofu baesi nigo, ‘Dadi kumo ini amena sanari ka ameyainedi.’ Ye ya bi kamini maena resi nesi egonari amegiya. ");
INSERT INTO kqc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Idu ya raka nigediri, bi bosi egona sanari ame. Kamini ya raka niyo amiye baesi ya nigo, ‘Dubu, dadi baesi yomina amena sana burefe minari ame.’ Mina vegu yaku ya raka niyadi vene tau di nemokori bi mokegedi amiye tora yokoi vo nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Adina kaere iniye moi odoro rigo, bi Sei yaku moi ave nigi rigo. Ma kaere iniye ave nigo, bi Sei yaku moi odoro rigo.” ");
INSERT INTO kqc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kamini Iesu yaku amiye bedakai rofu niyo, “Yi uriyenau o urusa irukuri, yi asiyaka, o usika ourena, o gugura tau vene ga raka ni—makai regiyari, bi ina ka dairi ya raka nigedi, ye yi beika reyo kana, bi dairi ya magedi mini. ");
INSERT INTO kqc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Irakuna regiyari, bi irava vene, roaita bero niyadi vene, yuka no vene, ma ne taufa vene mina raka ni. ");
INSERT INTO kqc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Minari bi buni tora gade baku regiya, adina ina vene bi anua dairi ya magedi. Sei yaku mokena rorobo amiye dadi rae rego medari, dairi ya mago.” ");
INSERT INTO kqc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amededi sanari, amiye yokoi yaku mina sina neideyori, bi Iesu rofu niyo, “Sei di ourefeidena amena sanari amesi irakuna irigedi vene tau bi buni tora gade moigedi!” ");
INSERT INTO kqc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma ina rofu niyo, “Amiye yokoi yaku irakuna tora resi amiye tau raka niyo. ");
INSERT INTO kqc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Resi mina irakuna meda okiyori, bi ini moimai rei tavoi redo amiye nifeideyo raka niyo vene nigo, ‘Ya baefa, iruku tau dogo resi amededi!’ ");
INSERT INTO kqc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Idu ina tau noibanu bi dadisi deda sina kamini niyadi. Yokoi yaku niyo, ‘Muro regi kono tu yokoi voi reyaka, ye vegi digida, dada yi amiye tora ka bosi ni gubuyo ga reyaine.’ ");
INSERT INTO kqc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma yokoi yaku niyo, ‘Na bi boromakau 10 voi reyaka, ye vei mona regi digida, dada yi amiye tora ka bosi ni gubuyo ga reyaine.’ ");
INSERT INTO kqc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma yokoi yaku niyo, ‘Na bi ruika rema meyaka, dada baena anua reida.’ ");
INSERT INTO kqc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kamini mina moimai rei tavoi redo amiye dairi bosi mina sina tau niyadi ini amiye tora rofu nioteimaro. Mina amiye tora gubuyo resi niyo, ‘Evade digasa taoni di ida tora ma ida keika tauri irava vene, roaita bero niyadi vene, ne taufa vene, ma yuka no vene minari afei bae.’ ");
INSERT INTO kqc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Doba de, bi mina moimai rei tavoi redo amiye yaku niyo, ‘Amiye tora, yi niyo kana bi reyaka, idu yi yava bi vata baena kode.’ ");
INSERT INTO kqc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dada niyo, ‘Bogiya gagani ma muro di idari ni yeiva re kumo amiye afei dui regiya, ma nai yava vata baeyaine. ");
INSERT INTO kqc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya nida, mirona vene tau raka niyaka mina, nai irakuna reyaka mina bi de irigedi!’” ");
INSERT INTO kqc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Amiye tau tora Iesu sa bogamadiri, ne kero resi ina vene rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amiye yokoi na rofu baesi na uka tora de masi ini baba, ini nono, ini rema, ini mida, ini usika ourena ma iniye rofu ka uka keika de mago vonisi, nai usi dina amiye anua rego. ");
INSERT INTO kqc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kaere amiye ini satauro de uakaisi na usi baego, bi nai usi dina amiye anua rego. ");
INSERT INTO kqc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ya amiye yokoi ini mokenari bi yava doba akugo vonisi, bi ameinu siko resi fore gokaisanu moimai koina nigi bi ina nufa vego. ");
INSERT INTO kqc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mina siko de rego vonisi, bi ini yava dadigo sana bi rigo, idu de moi koina rigori, bi amiye tau yaku mina vesi bi ina rofu ninika nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Resi nigedi, ‘Mina amiye bi yava rigi kora reyo idu de ri vau reyo!’ ");
INSERT INTO kqc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Gagani yokoi di kini ini iya rededi vene bi 10,000 moisi ruda bogo gagani kini yokoisa kaere bi ini iya rededi vene bi 20,000 vonisi, bi ameinu siko resi vego mirona gagani di kini di iya rena vene u vau rego ba de. ");
INSERT INTO kqc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ini mokena mina bosi toe nigori, bi ago mirona gagani kini rofu nifeidego ruda okina koderi, uka yokoi maka niyaganedi. ");
INSERT INTO kqc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mina makai kana, ya kaere na usi dina amiye mokeisa vonisi, bi yi beika tau bi fere. ");
INSERT INTO kqc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ramena bi buni; idu ramena di safi ka koina nigo vonisi, bi gokai dudu moi safi rigiya? ");
INSERT INTO kqc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mina bi moi makuna maka; ini buni yokoi de. Amiye neidego vonisi, bi neideyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Meda yokoiri, fore butu rededi vene tau gade ma vegu no rededi vene be, bi Iesu di sina neidegi ina rofu baeyadiri, ");
INSERT INTO kqc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisee vene ma ago gira oteimana vene bi ago tau nisi niyadi, “Mina amiye bi vegu no rededi vene faiva nisi ina venesa iruku irido!” ");
INSERT INTO kqc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ye Iesu yaku mina mokena ago ina vene rofu niyo: ");
INSERT INTO kqc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ya tau vakoiri, amiye yokoi bi ini mamoe 100 nufa ma yokoi maka bi kamini boiyo regori, bi mina mamoe 99 nomu ini tavara rededi sanari feresi disi mina yokoi maka boiyo reyo maina resi baku rego mamo. ");
INSERT INTO kqc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Baku regasa bi ada iniye resi ini megea fafau aesi ");
INSERT INTO kqc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","uakaisi rauturi okigo. Mina resi bi ini asiyaka vene ma ina atafu amededi vene raka niegogo resi nigo, ‘Na bi nai boiyo reyo mamoe baku reyaka dada, nasa ada renadi!’ ");
INSERT INTO kqc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Makai ya nida, omari amededi vene ada regedi, amiye yokoi maka ini vegu no feresi moi etagae riyo dada. Idu mokena rorobo vene 99 bi ini vegu no de feresi moi etagae de riyadi dada, omari amededi vene ada de regedi. ");
INSERT INTO kqc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O goina rema ini siriva fore bi 10, idu yokoi maka bi moi boiyo rego vonisi, ina bi ramefa kikisi yava gudare resi maina rei bogo ma baku rego ba? ");
INSERT INTO kqc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Baku regasa bi ini asiyaka ma ina atafu amededi vene raka niegogo resi nigo, ‘Na bi nai siriva fore boiyo reyo, mina baku reyaka dada, nasa ada renadi!’ ");
INSERT INTO kqc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mina ida kana dudu ya nida, Sei di naivo naivo vima bi ada regedi amiye yokoi maka ini vegu no feresi moi etagae rido dada.” ");
INSERT INTO kqc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Resi Iesu yaku niyo, “Amiye yokoi bi ini rumana mida remanu. ");
INSERT INTO kqc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Usika mida yaku dadisi ini baba niyo, ‘Baba, muyegiyari, beika gugura tau bi nai, gua na ma.’ Dada mina amiye yaku ini mida remanu di beika gugura muyesi ferego kana bi kamini rau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Meda be koina niyori, mina usika mida yaku ini gugura tau moisi ini rautu ferei dadi diyo. Gagani maike tora yokoiri disi ini fore tau ini mokena dada maku vau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Inasa beika amedo kana, maku vau reyo, ma mina gaganiri adabo tora yokoi are reyori, iniyesa bi beika buni irina yokoi de. ");
INSERT INTO kqc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dada disi mina gagani amiye yokoisa moimai reyo. Ini murori ini dona nari rei magi nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma ini mokenari bi dona iruku vana magamo, iniye ini uka rauna mina moi amuta rego, idu yokoi yaku ka beika yokoi mana ma de irigamo. ");
INSERT INTO kqc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Gabi mamo ini mokena buni dairi baeyo ma dadisi niyo, ‘Nai baba di moimai rededi vene tau bi ini iruku bi tora gade iridedi, ma na bi yomini rauna dudu muyegi reida! ");
INSERT INTO kqc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dadisi bosi nai baba nigida, Baba, na bi Sei rofu ma ya rofu vegu no reyaka. ");
INSERT INTO kqc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na bi yi mida vo ga na ni; yi moimai amiye yokoi kana na nari re.’ ");
INSERT INTO kqc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Resi bi dadisi ini baba rofu dairiyo. “Ina bi yava okina koderi, ini baba yaku maikeri gutuna vesi ina rofu iriyeduka resi raga rei bosi ini mida binu masi fuka reyo. ");
INSERT INTO kqc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ini mida yaku niyo, ‘Baba, na bi Sei rofu ma ya rofu vegu no reyaka, na bi yi mida vo ga ni.’ ");
INSERT INTO kqc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Idu ini baba yaku raka nisi ini moimai rei tavoi rededi vene rofu niyo, ‘Evade varuka burefe iniye moi desi ae mafa. Ini vanari rini yokoi ae masi ini yukari tamaka ae mafa. ");
INSERT INTO kqc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mina resi bosi boromakau mida vana resifa, mina ufa ma irakuna tora resi ada renadi! ");
INSERT INTO kqc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Adina nai mida bi muyeyo, idu gua bi vegu niyo; eva niyo, idu disi dairiyo ma baku reyafa.’ Kamini irakuna kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mina medari ini ourena mida bi murori ameyo. Dairi baegasa yava adinari bi gita kukuroka ma adena udedi mina neideyo. ");
INSERT INTO kqc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dada naivo amiye yokoi raka nisi nikaitesi niyo, ‘Mina bi beika rededi?’ ");
INSERT INTO kqc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma nikabai resi niyo, ‘Yi dubuini dairi okiyo, dada yi baba yaku boromakau mida vana resifa, mina usi irakuna rededi, adina yi baba yaku buni dudu dairi moiyo dada.’ ");
INSERT INTO kqc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mina ourena mida bi gubuyo resi yava ideri de dui rei boyo; dada ini baba yaku desi niguba reyo bi dui reyaine. ");
INSERT INTO kqc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Idu nikabai resi niyo, ‘Ve kumo yomina lagani tau yi naivo amiye kana, na yi moimai resi yi ago gira mina de neidei kora regamaka. Idu ya bi gouti mida nai asiyaka venesa irakuna regi ka de na maro! ");
INSERT INTO kqc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Idu yi mina mida bi yi gugura tau koa rededi rema vene rofu maka rau rei vau resi yavari dairiyori, ya bi boromakau mida vana resifa mina u maro!’ ");
INSERT INTO kqc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ini baba yaku nikabai resi niyo, ‘Nai mida, ya bi ari neinei nasa dada, beika tau nai bi yi. ");
INSERT INTO kqc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Idu buni bi ada resi irakuna renadi, adina yi dubuini bi muyeyo, idu gua bi vegu niyo; disi forovai reyo, idu, gua baku reyafa.’” ");
INSERT INTO kqc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ka ini usi dina vene rofu niyo, “Gugura fore tau amiye yokoi bi ini gugura nari redo amiye yokoi nufa. Mina gugura fore tau amiye nioteimaradi bi ini gugura nari redo amiye yaku ini fore iri vau regamo. ");
INSERT INTO kqc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dada raka nisi niyo, ‘Na bi mina sina ya dada nidedi, mina neideyaka. Nai fore gokai makusa, mina bi buni na oteimagiya, adina nai gugura tau moi ourefeideisa, bi moi dairigida.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mina naivo amiye yaku iniye kamini niyo, ‘Nai amiye tora bi nai moimairi kamini na moi etagae rigo, ma na bi kono goenari yeiva de, ma amiye rofu niguba renari ka maena reida; dada na bi beika regida? ");
INSERT INTO kqc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Idu ida yokoi amedo bi na na diba; nai moimairi nai moi etagae rigori, nai asiyaka vene yaku ini yavari na moi afei dui regedi.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kamini kaere ini amiye tora rofu ini beika moiyadi rofu gabi mago vene raka ni vau resi amiye yokoi siko rofu nikaiteyo, ‘Ya bi nai amiye tora rofu bi gokaisanu magiya?’ ");
INSERT INTO kqc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Olive yabo di meko di diga botoro 100 dairisi magida,’ vo niyo. Ma niyo, ‘Yi moiyo kana fefa bi mini, moisi ameinu resi evade 50 bura re.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Resi yokoi nikaiteyo, ‘Ma ya bi gokaisanu dairisi magiya?’ Ina yaku niyo, ‘Witi fuse 100.’ Kamini ina rofu niyo, ‘Yi moiyo kana fefa bi mini, moisi 80 bura re.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Gabi ini amiye tora yaku makai reyo mina neideyo dada, ini roka niodoro reyo, adina bi mokena buni dudu ini moimai reyo; mina kono vene di diba bi tora dada, mokena buni dudu ini moimai rededi, idu vabara vene ini diba bi keika bi mokena buni dudu ini moimai rededi.” ");
INSERT INTO kqc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma Iesu ka niyo, “Mina dada, ya vene rofu nida: yi kono di mokena rorobo de di gugura dudu vegu rau regasa auta refa, ye mina gugura koina nigori, Sei yaku ini toga toga amedo sanari ya afei dui rego dada. ");
INSERT INTO kqc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kaere amiye yaku beika keika keika rofu nari rei mona rego, ina bi beika tora ka nari rei mona rego. Idu beika keika keika ofa ofa dudu nari rego amiye, bi beika tora rofu ka ofa ofa dudu de nari rego. ");
INSERT INTO kqc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ya kono di gugura nari rei mona de reyadi vonisi, ya yaku gugura rama dudu ka de nari rei mona regedi. ");
INSERT INTO kqc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Resi ya bi amiye be di gugura nari rei mona de reyo vonisi, bi kaere yaku yi gugura rama ya mago? ");
INSERT INTO kqc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Moimai rei tavoi redo amiye yokoi yaku amiye tora remanu di moimai rena anua rego. Adina bi yokoi rofu bi gubuyo resi yokoi rofu bi uka mago; o ina bi yokoi di ago neidesi yokoi rofu bi mokei itu rego. Ya bi Sei ma fore di moimai rei tavoi rededi vene di moimai rena anua regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee vene yaku mina sina neidegasa bi Iesu ninika niyadi, adina ina vene bi fore mokei tora rededi. ");
INSERT INTO kqc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Idu ina vene rofu niyo, “Ya vene yaku amiye di nemokori ya kaya yi vegu bi rorobo vo nigasa rededi, idu Sei bi ina diba yi uka mokena; adina beika gugura bi buni iniye amiye di mokenari, mina bi Sei di nemokori no iniye iniye kino nufa. ");
INSERT INTO kqc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses di ago gira ma Sei di ago niyadi vene di ago bura reyadi bi niodoro regamadi, ma John Baptist di okina ariri baeyo. Mina ariri gutuna, Sei di ourefeidena amena sana di sina buni bi niogau rededi mini, ma amiye tau bi ini yeiva tau dudu dui regika rededi. ");
INSERT INTO kqc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Idu oma ma kono bi ini ida dudu roro nigedi, idu ago girari bura reyadi, mina di tuta yokoi kava de roro nigo. ");
INSERT INTO kqc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kaere amiye ini rema nifeidesi rema bouna mego, bi koa rego; ma mina amiye kaere bi rema mego, ka bi koa rego. ");
INSERT INTO kqc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Gugura tau amiye yokoi amegamo; ina bi varuka burefe iniye risi ada regasa iruku buni ari neinei irigamo. ");
INSERT INTO kqc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ini yava ida nefauri bi irava amiye ini roka Lazarus mina bae amegamo. Ini roaita bi ara yaku nivai rena iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ini ukari mokegamo bi mina gugura tau amiye di iruku bubudo ini teiborori yareyadi mina irigo. Auna yaku ka bosi ini ara uaka regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Mina irava amiye muyeyori, bi Sei di naivo naivo vima yaku Abraham atafu afei boyadi. Kamini gugura tau amiye ka muyeyo ma guri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Muyena vene di amena sanari esika moiga amesi ini nemoko maku bogasa maikeri gutuna Abraham veyo ma Lazarus bi ina atafu ameyo. ");
INSERT INTO kqc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dada raka niyo, ‘Abraham, nai baba, na iriyeduka re! Lazarus nifeidegiya, ma ini vana metona dudu koru bi risi nai afiye moi amuta reyaine, adina na bi esika tora iniye mina ita ideri moida!’ ");
INSERT INTO kqc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Idu Abraham yaku niyo, ‘Nai mida, moke, yi vegu amegasa gugura buni moigamo, ma Lazarus bi no moiyo. Idu ya esika moisari, ina bi minari gua ada redo. ");
INSERT INTO kqc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma yomakai, una remanu uni utari bi kono ruba tora gade amedo, dada kaere minari gutuna ugai bae nena ura rego, bi rena anua rego, ma mirona eta rofu ugai baena ka anua rego.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kamini mina gugura tau amiye yaku niyo, ‘Makai vonisi, bi ya niguba reida, baba Abraham, Lazarus nai baba di yavari nifeide. ");
INSERT INTO kqc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mironari bi nai dubuiyaka 5. Nifeidegiya kumo nesi ni yeiva resi nigo bi mina esika sanari ina ka ga baeyagane.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Idu niyo, ‘Moses ma Sei di ago nidedi vene di ago bi ina venesa; ina rofu maka ago neideyagane.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Idu niyo, ‘Baba Abraham, mina bi buni de! Amiye yokoi muyenari gutuna ina vene rofu dadi rae resi boi nego vonisi, bi ini vegu no feresi moi etagae rigedi.’ ");
INSERT INTO kqc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Idu nikabai resi niyo, ‘Moses ma Sei di ago nidedi vene di ago de neidegedi vonisi, bi muyena amiye dadi rae rego rofu ka ini uka de moi kero regedi.’” ");
INSERT INTO kqc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu yaku ini usi dina vene rofu niyo, “Vegu no fafau uka maina regika nivena vegu bi rama iniye vata nigo, idu mina vegu no fafau uka maina regika nivedo amiye bi ina rofu bi gokai no iniye iniye! ");
INSERT INTO kqc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amiye yokoi yaku mina mida keika yokoi ourefeidego vonisi, ma vegu no rego, bi kaunava tora moigo. Buni bi witi utei rena fore tora kuriri ukita resi davarari makugo. ");
INSERT INTO kqc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mokena dudu ya kaya nari refa! “Yi usika ourena vegu no rego vonisi, bi ni kumo ga reyaine; ini vegu no feresi moi etagae rigo vonisi, ini vegu no erufu. ");
INSERT INTO kqc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya rofu vegu no meda yokoi makari uru 7 resi baegasa ya uru 7 nibigo, ‘Na bi vegu no feresi moi etagae riyaka,’ nibigo vonisi, bi ini vegu no reyo mina erufu.” ");
INSERT INTO kqc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Varika amiye di nifeidena vene yaku ina rofu niyadi, “Uni mokena vari gira aena ya rofu moi tora ri.” ");
INSERT INTO kqc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nikabai resi niyo, “Yi mokena vari gira aena bi mastadi di yoya keika iniye kana vonisi, bi yabo tora rofu nigedi, ‘Ya kaya daru noibanu rae resi moka daidai torari vari!’ Vo nigediri, yi ago neidego. ");
INSERT INTO kqc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ya yokoi yaku yi moimai rei tavoi redo amiye bi murori moimai rebigo, o mamoe vana rei vau resi yavari okigori, bi ina rofu nigiya, ‘Baesi amesi iruku iri,’ makai de nigiya. ");
INSERT INTO kqc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ide mada! Ya bi nigiya, ‘Nai iruku feidesi varuka burefe risi nai koru vava naivo regiya bogo nai koru ma iruku iri vau regida mamo; gabi yi koru ma iruku irigiya.’ ");
INSERT INTO kqc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mina moimai rei tavoi redo amiye yi ago neidego, idu buni tora gade de nimagiya. ");
INSERT INTO kqc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mina dada, ya vene ka, niyadi kana rei vau regasa bi nigedi, ‘Una ka bi moimai rei tavoi resifa vene maka; ye uni moimai maka reyafa.’” ");
INSERT INTO kqc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu Jerusalem seira risi bogamori, bi Samaria ma Galilee taoni di kono utari boyo. ");
INSERT INTO kqc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Rautu yokoi dui reyori, refera vene 10 baku reyo, kaere bi maikeri are resi ");
INSERT INTO kqc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","raka niyadi, “Iesu, Varika amiye, una iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma vesi niyo, “Bofa kumo Sei ma amiye utari naivo vene ya veyagane.” Idama bogamadiri, bi ini roaita moi ruaka riyo. ");
INSERT INTO kqc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kamini amiye yokoi maka yaku ini roaita moi buni riyo mina vegasa bi dairi baesi goroka tora dudu Sei di roka moi odoro risi ");
INSERT INTO kqc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iesu di yuka adinari keto resi buni tora gade maro. Mina amiye bi Samaria amiye. ");
INSERT INTO kqc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kamini Iesu yaku niyo, “Amiye 10 moi ruaka riyaka. Ma mina amiye 9 bi goini? ");
INSERT INTO kqc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Beika resi mina Israel de amiye maka Sei di roka moi odoro rigi dairiyo?” ");
INSERT INTO kqc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Resi ina rofu niyo, “Dadisi bo. Yi mokena vari gira aena yaku ya moi buni riyo.” ");
INSERT INTO kqc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee vene be yaku Iesu nikaitesi niyadi, “Sei di ourefeidena amena sana goivaka ogau nigo?” Nikabai resi niyo, “Sei di ourefeidena amena sana gokai dego bi ini rebe de vegedi. ");
INSERT INTO kqc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yokoi yaku ka de nigo, ‘Vefa, ina bi yomini!’ o, ‘Ina bi yoroni!’; adina bi Sei yaku yi ideri ourefeidesi amedo.” ");
INSERT INTO kqc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kamini Iesu yaku ini usi dina vene rofu niyo, “Amiye di mida di meda baegedi, ma ya yaku mina meda vegi ura regedi vo nigedi, idu de vegedi. ");
INSERT INTO kqc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Be vene yaku ya rofu nigedi, ‘Mironari ne rei vefa!’ o ‘Minari ne rei vefa!’ Idu bosi maina ga refa. ");
INSERT INTO kqc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Amiye di mida bi sui dudu de dego. Adina ini dena bi ayena yaku kamanika redori oma berou eta rofu vabara ni baedo berou rofu moido kana. ");
INSERT INTO kqc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mina vata nina koderi, bi esika tau tora siko moigo, ma mina ari vene yaku ina rofu gedu magedi kumo. ");
INSERT INTO kqc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamini Noah di medari reyadi kana, Amiye di mida dena medari ka makai regedi. ");
INSERT INTO kqc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ina vene bi iruku ma koru irigasa rumana ma rema megasa rei bogamadi boyo, mina medari Noah sisima ideri dui reyo mamo, bi abata yaku desi ina vene ukero vau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot di medari ka makai kana, ina vene tau bi iruku ma koru irigasa voi voi regasa muro regasa yava rigasa rei bogamadi. ");
INSERT INTO kqc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot yaku Sodom ferei yakuyo medari, Sei yaku fore ita omari gutuna miya kana moi feidesi ina vene ukero vau reyo. ");
INSERT INTO kqc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Amiye di mida ogau nigo medari ka mina kana vegu vata nigo. ");
INSERT INTO kqc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mina medari, yava tebo odorori amiye bi ini yavari nesi gugura fore ga moi yakuyaine; ma murori amedo amiye ga dairiyaine. ");
INSERT INTO kqc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot di rema beika vegu ina rofu vata niyo mina mokefa! ");
INSERT INTO kqc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kaere ini vegu moigika maina rego, bi de moigo, ma kaere ini vegu youfeidego, bi moigo. ");
INSERT INTO kqc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya rofu nida, mina urusari, amiye remanu bi ekama yokoi makari varebigedi. Yokoi bi moi etagae risi yokoi bi ferego. ");
INSERT INTO kqc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rema remanu vakoi fore dudu witi utei rebigedi; yokoi bi moi etagae risi yokoi bi ferego.” ");
INSERT INTO kqc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kamini ini usi dina vene yaku nikaiteyadi, “Varika amiye, mina vegu bi goinari vata nigo?” Ye nikabai reyo, “Muyena roaita amedo sanari bi gayo bora ka mina sanari egogo regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kamini Iesu yaku mokena ago yokoi ina rofu nisi oteimasi ari neinei usa usa niyaganedi, ma kosika bi ga reyagane. ");
INSERT INTO kqc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Taoni yokoiri, kota neidena amiye yokoi amegamo, kaere bi Sei rofu ori de resi amiye rofu moi kikifa de regamo. ");
INSERT INTO kqc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Minari ka obu yokoi amegamo. Ina bi ari neinei baegasa nigamo, ‘Ya bi nai tuma vene rofu na moi rama rigiya bi buni!’ ");
INSERT INTO kqc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mina kota neidena amiye bi meda be ini ago bi ni gedu magamo, idu gabi iniye rofu kamini niyo, ‘Na ka bi Sei rofu ori de resi amiye rofu ka moi kikifa de reida, ");
INSERT INTO kqc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","idu mina obu yaku ago tau nido dada, ini kota rena usa nido kana bi regida, bi dairisi ada esika na mago baebu!’” ");
INSERT INTO kqc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Resi Varika amiye yaku niyo, “Mina mokena rorobo de, kota neidena amiye yaku niyo, mina neidefa. ");
INSERT INTO kqc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sei yaku gua ini auba resi moiyo vene, kaere uru ari ina rofu isaka nidedi, bi ini ago neidesi ini vegu moi rama rigo, ba ide? Kiya kiya aedego ba? ");
INSERT INTO kqc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya vene rofu nida, evade ini ago neidesi ini vegu moi rama rigo. Idu Amiye di mida ini degasa bi mina kono tora noibanuri mokena vari gira aena baku rego ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu yaku ka amiye be rofu mina mokena ago niyo. Mina vene yaku ini mokeyadi bi, ina bi mokena rorobo nufa vene, ma be vene rofu mokeyadi bi vegu no rededi vene. ");
INSERT INTO kqc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ari yokoiri, amiye remanu yaku Sei nivakena yavari usa usa nigi boyadi; amiye yokoi bi Pharisee amiye ma yokoi bi fore butu redo amiye. ");
INSERT INTO kqc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Pharisee amiye yaku gaima etae risi are resi usa usa niyo, ‘Sei, ya buni tora gade maida, na bi be kana de: ofa ofa dudu duma duma rededi vene, vegu no rededi vene, o koa rededi vene. Na ka mina fore butu redo amiye kana de; ");
INSERT INTO kqc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","fura yokoi makari uru remanu, bi iruku oyo resi nai gugurari beika berou berou 10 ri yokoi maka bi ya maida.’ ");
INSERT INTO kqc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Idu mina fore butu redo amiye bi gaima are resi ini kuri agu risi ini vana ini kokobari aesi niyo, ‘Sei, na iriyeduka re; na bi vegu no reida amiye!’” ");
INSERT INTO kqc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Resi Iesu yaku niyo, “Ya nida, mina amiye remanu ini yavari dairiyadiri, bi Sei yaku fore butu redo amiye rofu niyo ini vegu bi rorobo, idu mina Pharisee amiye bi de. Adina kaere iniye moi odoro rigo, bi Sei yaku moi di nego, idu kaere iniye ave nigo, bi Sei yaku moi odoro rigo.” ");
INSERT INTO kqc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kamini be vene yaku ka ina rofu mida kakua afei baegamadi, bi avaka moiyainedi, idu ini usi dina vene yaku mina vesi nivaiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Idu Iesu yaku mida keika keika rofu raka nisi niyo, “Mida keika keika bi ferefo kumo na rofu baeyagane; ga meki refo, adina Sei di ourefeidena amena sana bi mina kana vene di. ");
INSERT INTO kqc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rama ya nida, kaere amiye yaku Sei di ourefeidena amena sana mida keika kana de moigo vonisi, bi de iniye iniye dui rego.” ");
INSERT INTO kqc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kamini ourefeidena amiye yokoi yaku nikaiteyo, “Oteimana amiye buni, beika regida bi toga toga ameibobina vegu moigida?” ");
INSERT INTO kqc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Iesu yaku niyo, “Beika resi na rofu bi buni vo nisa? Amiye yokoi bi buni de, Sei iniye maka bi buni. ");
INSERT INTO kqc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ya ya diba ago gira di ago bi: ‘Koa ga re; amiye umuyena ga re; duma duma ga re; amiye di vegu fafau ofa ofa ago ga ni; yi nono baba emagui re.’” ");
INSERT INTO kqc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ye mina amiye yaku niyo, “Na keikari gutuna mina kana vegu ago tau vakoi moi gira ri baeda.” ");
INSERT INTO kqc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma mina neidegasa niyo, “Vegu yokoi maka bi de reyo. Yi gugura tau mina sero resi ini fore irava vene masi yi gugura buni bi omari baku regiya; na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Idu mina neidesi ini uka yarena iniye reyo, adina ina bi gugura tau gade amiye. ");
INSERT INTO kqc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu ina vesi iriyeduka dudu niyo, “Gugura tau gade nufa vene yaku Sei di ourefeidena amena sanari dui rena bi gira iniye! ");
INSERT INTO kqc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelo yaku niduru nemokori dui rena bi aita, idu gugura tau gade nufa amiye yaku Sei di ourefeidena amena sanari dui rena bi gira iniye.” ");
INSERT INTO kqc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ye mina ago neideyadi vene yaku niyadi, “Kamini kaere moi vegu rigo?” ");
INSERT INTO kqc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma niyo, “Amiye beika gokai anua regedi, Sei yaku mina rego bi aita iniye.” ");
INSERT INTO kqc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kamini Peter yaku niyo, “Ve kumo, uni beika baika feresi ya usi diyafa.” ");
INSERT INTO kqc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma ina vene rofu niyo, “Rama ya nida, amiye yokoi yaku ini yava, o rema, o usika ourena, o nono baba, o mida, Sei di ourefeidena amena sana rofu fereyo bi, ");
INSERT INTO kqc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mina veguri, bi tora gade iniye moigo. Ma gabi mina meda baegori, toga toga ameibobina vegu moigo.” ");
INSERT INTO kqc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kamini ini amiye 12 moi gaima risi niyo, “Neidefa, una bi Jerusalem bogifa, Sei di ago niyadi vene yaku Amiye di mida rofu vata nigo vegu bura reyadi, mina rama aego. ");
INSERT INTO kqc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tutubena idana vene di vanari aegedi; ina rofu nikurusi ni no resi ayaka su resi ");
INSERT INTO kqc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","buburu vai resi umuyegedi. Idu gabi meda regodenuri, dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Idu ini usi dina vene bi mina sina niyori, bi ini adari ufatena de reyadi. Mina sina di rama bi ina vene di mokenari sui niyo, ma ini beika nigamo bi ina vene ka ina toto. ");
INSERT INTO kqc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kamini Iesu Jericho negau okiyori, bi ne taufa amiye yokoi ida atafu amegasa usa nigamo. ");
INSERT INTO kqc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Amiye tau gade bae bogamadi mina neidegasa bi nikaitesi niyo, “Mina bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kamini niyadi, “Iesu Nazareth amiye bi bae bodo.” ");
INSERT INTO kqc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ye raka nisi niyo, “Iesu, David di tutubena, na iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ourei boyadi vene yaku emaradi babo niyaine, vo niyadi, idu besa raka niyo, “David di tutubena, na iriyeduka re!” ");
INSERT INTO kqc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ye Iesu are resi ago gira dudu ina rofu moi baeyaganedi, vo niyo. Atafu baegasa bi nikaiteyo, ");
INSERT INTO kqc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ya ura reisa bi beika ya rofu regida?” Nikabai resi niyo, “Varika amiye, na ura reida bi dudusa gagani vegida.” ");
INSERT INTO kqc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma niyo, “Ve kumo! Yi mokena vari gira aena yaku ya moi buni riyo.” ");
INSERT INTO kqc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma evade maka dudusa gagani vesi Iesu usi bosi Sei di roka moi odoro rigamo. Amiye tau yaku mina vegasa ka bi Sei di roka niodoro reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Jericho dui resi ebu rei bogamo. ");
INSERT INTO kqc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Minari bi amiye roka Zacchaeus, kaere bi fore butu rededi vene di amiye tora. Iniye bi gugura tau amiye. ");
INSERT INTO kqc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ini ura bi Iesu vego, idu ina bi amiye tumu dada, vena anua regamo, amiye ka berou bi tau tora iniye dada. ");
INSERT INTO kqc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mina dada ouresi raga bosi Iesu vegi bi yabo tora yokoi roka sycamore firu boyo. Ina bi mina dakai baego dada. ");
INSERT INTO kqc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu yaku mina sana okigasa bi ne odoro resi ina rofu niyo, “Zacchaeus, evade soka rei degiya, adina na bi gua yi yavari amegida.” ");
INSERT INTO kqc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dada evade soka resi ini yavari ada dudu moi dui reyo. ");
INSERT INTO kqc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amiye tau yaku mina vegasa bi nimumugu regi kora regasa nigamadi, “Ina bi vegu no redo amiye yokoi di yavari iruku irigi dui reyo.” ");
INSERT INTO kqc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus are resi Varika amiye rofu niyo, “Varika amiye, nai gugura berou afona moisi bi irava vene magida. Resi amiye ofa dudu ini gugura fore moiyaka vonisi, bi dudusa uru 4 besa dairi magida.” ");
INSERT INTO kqc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma ina rofu niyo, “Gua medari moi vegu rina bi mina yavari dui reyo, adina bi mina amiye ka Abraham di mida. ");
INSERT INTO kqc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Adina Amiye di mida bi boiyo reyadi vene maina rei baku resi moi vegu rigi deyo.” ");
INSERT INTO kqc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mina sina neidegamadiri, bi yavoi resi mokena ago niyo, adina ina bi Jerusalem atafuri okiyo, ma amiye yaku mokegamadi bi Sei di ourefeidena amena sana bi minari evade maka ogau nigo. ");
INSERT INTO kqc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mina resi niyo, “Amiye yokoi, kaere bi varika amiye kana, dadisi gagani maike yokoiri iniye kini rigi disi dairiyo. ");
INSERT INTO kqc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dada ouresi ini moimai rei tavoi rededi vene tau vakoi 10 raka nisi goro fore yokoi yokoi masi niyo, ‘Mina fore fafau moimai refa kumo bogo dairi okigida.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Idu ini gagani vene bi ura de iniye regamadi, dada naivo vene ago nifeideyadi ma usi disi niyadi, ‘Una ura de resifa mina amiye yaku uni kini niyaine.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kini nisi ini gaganiri dairiyo. Mina usi bi ini moimai rei tavoi rededi vene rofu ago nifeideyo fore maro fafau moimai resi beika be reyadi, mina ini nemokori vego. ");
INSERT INTO kqc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ourena amiye yaku baesi niyo, ‘Varika amiye, yi goro fore fafau dudusa 10 riyaka.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma niyo, ‘Rei mona reyo; ya bi nai moimai rei tavoi reisa amiye buni! Beika keika ya maraka bi nari rei mona reyo dada, taoni 10 bi nari regiya.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ini usi naivo amiye yaku baesi niyo, ‘Varika amiye, yi goro fore fafau bi dudusa 5 riyaka.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma ka niyo, ‘Taoni 5 bi nari regiya.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kamini naivo amiye yokoi yaku baesi niyo, ‘Varika amiye, yi goro fore bi yomini. Muko yokoiri aesi moi sui riyaka. ");
INSERT INTO kqc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ya rofu ori reyaka, adina ya bi amiye gira. Ya banikari de aeyo, mina moisa, ma varina de reyo, mina goe goe reisa.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ma nikabai reyo, ‘Ya kaya yi sina niyo dudu ya kota regida. Ya bi amei tavoi resi moimai rei tavoi reisa amiye no! Ya diba niyo na bi amiye gira, beika banikari de aeyaka, bi moida, ma beika de variyaka, bi goesi moida. ");
INSERT INTO kqc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Beika resi nai fore bi banikari de moi aeyo? Kamini na dairi baeyagaduri, bi dudusa bae moiyagadu, banika yaku fore keika fafau aeyagadu minasa.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Resi atafu are rededi vene rofu niyo, ‘Ini goro fore yokoi maka moisi 10 nufa amiye rofu mafa.’ ");
INSERT INTO kqc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Idu niyadi, ‘Varika amiye, ina ka bi ini goro fore 10 nufa!’ ");
INSERT INTO kqc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nikabai resi niyo, ‘Ya rofu nida, amiye kaere ini beika baika nufa, bi moi tanu mago. Idu kaere ina bi de iniye iniye nufa, ka ina rofu keika iniye amedo, bi moi dairigo. ");
INSERT INTO kqc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Idu nai tuma vene, kaere yaku ura de reyadi na kini nigida, vo niyadi, bi afei baesi minari nai nemokori u vau refa!’” ");
INSERT INTO kqc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu yaku mina sina ni vau regasa dadisi Jerusalem ri ourei boyo. ");
INSERT INTO kqc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kamini Bethphage ma Bethany taoni keika, omuna di roka Olive yabo adinari bae ekaira regasa ini usi dina amiye remanu nifeidesi ");
INSERT INTO kqc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","niyo, “Rautu yokoi yi buda rofu bogedi. Mina sanari boi okigediri, bi donkey di mida ukita riyadi mina baku regedi; amiye yokoi keu rina kode. Younesi moi baefa. ");
INSERT INTO kqc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ye amiye yokoi yaku ya nikaitego beika resi ini maena younededi nigo vonisi, bi nifa, ‘Varika amiye yaku ura redo dada.’” ");
INSERT INTO kqc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ye nifeideyo vene feresi baku reyadi, ini niyo kana. ");
INSERT INTO kqc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Donkey di mida di maena youneyadiri, bi ini nari rededi vene yaku nikaiteyadi, “Beika resi ini maena younededi?” ");
INSERT INTO kqc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nikabai resi niyadi, “Varika amiye yaku ura redo dada.” ");
INSERT INTO kqc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Resi Iesu rofu moi baesi ini bou varuka fafau yousi Iesu odorori aeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Keu risi bogamori, bi amiye yaku ina fafau varuka moisi idau ibu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalem atafu, Olive yabo di omuna ika di ida dena sanari deyori, bi ini usi dina vene tau gade yaku goroka tora dudu Sei di roka moi odoro rigi kora regamadi, mokena vegu tau veyadi dada. ");
INSERT INTO kqc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yomakai nigamadi, “Sei buni tora gade mado kini kaere Varika amiye di rokari baedo! Uka amuta ma Sei di vabara oma odoro iniyeri ameyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kamini Pharisee vene be bi mina amiye tau fogori yaku ina rofu niyadi, “Oteimana amiye, yi usi dina vene emasi nivo makai ga niyagane!” ");
INSERT INTO kqc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nikabai resi niyo, “Ya nida, bere nigedi vonisi, fore iniye raka nigedi.” ");
INSERT INTO kqc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalem kaira nigasa ne rei veyori, bi iriyeduka resi isaka niyo. ");
INSERT INTO kqc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Resi niyo, “Gokai uka amuta nina di vegu gua medari ya diba niyagadu! Idu gua bi de veifategedi! ");
INSERT INTO kqc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ari yokoi mironiri baego, bi yi tuma vene yaku kota misi ya buru risi kafu tau mina biri rigedi. ");
INSERT INTO kqc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Resi yi amiye tausa, yi kota ideri ya ukero vau regedi. Minari fore fafau fafau amededi bi gabi yokoi de amegedi. Ini adina bi, Sei ya rofu deyo ari bi de vei mama reyadi!” ");
INSERT INTO kqc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kamini Sei nivakena yavari dui resi sero rena vene umeki rei feidegi kora resi ");
INSERT INTO kqc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","niyo, “Sena bura reyo, ‘Nai yava bi usa usa nina yava,’ idu ya vene yaku duma duma vene di sui nina yava kana reyadi!” ");
INSERT INTO kqc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kamini meda neinei Sei nivakena yavari amiye oteimagamo, idu Sei ma amiye utari naivo vene di varika vene, ago gira oteimana vene, ma amiye di tora vene be yaku bi umuyegedi di ida maina regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ida de baku reyadi gokai regedi bi, ini adina amiye tau tora bi ini ago moi gira riyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Meda yokoiri, Sei nivakena yava ideri, amiye oteimasi ago buni nirausi regamori, bi Sei ma amiye utari naivo vene di varika vene, ago gira oteimana vene, ma tora vene ina rofu bosi are regasa ");
INSERT INTO kqc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nikaiteyadi, “Una ni, beika vava dudu mina vegu reisa? Ma kaere yaku mina vava ya maro?” ");
INSERT INTO kqc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma nikabai resi niyo, “Nai nikaitena ka bi yokoi maka. Na nifa, ");
INSERT INTO kqc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John di babatiso rena di vava bi oma gutuna ba amiye gutuna deyo?” ");
INSERT INTO kqc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ye iniye iniye nidodi resi niyadi, “‘Oma gutuna,’ nigifa vonisi, ina yaku nikaitego, ‘Ma beika resi ina rofu mokena vari gira de aeyadi?’ ");
INSERT INTO kqc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Idu ‘Amiye gutuna,’ nigifa vonisi, amiye tau fore dudu una umuyegedi, adina mokededi bi John bi Sei di ago nido amiye yokoi.” ");
INSERT INTO kqc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ye nikabai reyadi, “Una una toto bi goinari gutuna deyo.” ");
INSERT INTO kqc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma niyo, “Na yaku ka makai de ya nigida na bi beika vava dudu mina vegu reida bi.” ");
INSERT INTO kqc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kamini amiye rofu mina mokena ago nigi kora reyo: “Amiye yokoi waini meko di muro varisi muro nari rena vene be ini nanaka moigika nimasi yava ika oto diyo. ");
INSERT INTO kqc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mina usi butu rena di meda okiyori, bi ini moimai rei tavoi redo amiye yokoi muro nari rena vene rofu nifeideyo ma waini meko vareyo mina bi butu reyainedi. Idu bi mina moimai rei tavoi redo amiye ubobo resi vana notoka nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kamini dudusa ini moimai rei tavoi redo amiye yokoi ina vene rofu nifeideyo, idu ka bi ubobo resi ni moi maena resi vana notoka nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dudusa yokoi nifeideyo, mina bi uru regode niyo mini. Mina ka ubobo resi etofaro makuyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ye waini meko di muro biyaguna amiye yaku niyo, ‘Beika bi regida? Nai uka maida mida nifeidegida; bi matagini regedi baeko!’ ");
INSERT INTO kqc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Idu muro nari rededi vene yaku vesi iniye iniye nidodi resi niyadi, ‘Mina bi muro biyaguna amiye nigo. Nesi umuyenadi, ma beika baika ini baba yaku ferego bi uni nigo!’ ");
INSERT INTO kqc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ye waini meko muro etofarori makusi umuyeyadi. “Ye waini meko muro biyaguna amiye bi ina vene rofu gokai beika be rego? ");
INSERT INTO kqc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ina bi baesi muro nari rededi vene umuyesi muro bouna vene mago.” Amiye yaku mina sina neideyadiri, bi niyadi, “Makai bi ga ogau niyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Idu ina vene vesi niyo, “Ye mina bura reyo bi beika? ‘Yava akuna vene moi kekevata uyadi fore bi yava moi gira redo fore iniye niyo.’ ");
INSERT INTO kqc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mina fore fafau kaere amiye yaregedi bi ode tumu tumu regedi, ma mina fore kaere fafau yarego bi mina amiye ufoyoma rego ma budoka nigo.” ");
INSERT INTO kqc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma mina meda nemoko makari ago gira oteimana vene ma Sei ma amiye utari naivo vene di varika vene yaku ina moi gira regika ida maina reyadi, adina diba niyadi mina mokena ago ina vene fafau niyo. Idu amiye rofu ori resi ");
INSERT INTO kqc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iesu vei mona resi ini ura bi Rome vene di gavana di ourefeidena ma vava gabireri aegedi. Dada amiye be fore masi nifeideyadi, kaere bi sina buni buni kana dudu niyagane. Idu rama iniye bi, Iesu ini ago nigori ni eru regedi. ");
INSERT INTO kqc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ye baesi ina rofu niyadi, “Oteimana amiye, una una diba ya bi sina rama maka nisa amiye. Ya bi amiye gokai kana bi de mokeisa, idu sina rama dudu maka Sei di ida oteimaisa. ");
INSERT INTO kqc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Una ni, Caesar rofu takesi fore fei rena bi uni ago gira rofu rorobo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Idu bi sena ini eru rena vegu vei mama resi niyo, ");
INSERT INTO kqc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Siriva fore yokoi na oteimafa. Bi kaere di vima ma roka nufa?” Ye nikabai reyadi, “Caesar di.” ");
INSERT INTO kqc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kamini niyo, “Beika Caesar di, bi Caesar mafa, ma beika Sei di, bi Sei mafa.” ");
INSERT INTO kqc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Beika ago niyo rofu amiye di nemokori eru regika anua reyadi; ini ago dairi maro rofu tururu reyadi, dada bere niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kamini Sadducee vene be, kaere bi dadi rae rena fufuta maradi, bi Iesu rofu baeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Resi nikaitegasa niyadi, “Oteimana amiye, Moses yaku una rofu bura reyo bi: ‘Amiye kaere ini dubuini muyesi ini rema ferego, idu mida bi koina, mina amiye bi ini obu mesi ini dubuini di mida moiyainedi.’ ");
INSERT INTO kqc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yokaru bi dubuiyaka 7 amegamadi. Ourena bi rema meyo, idu muyeyo, mida yokoi de. ");
INSERT INTO kqc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ini usi vata niyo amiye ka makai ");
INSERT INTO kqc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ma mina usi amiye ka makai meyo. Mina vegu yokoi maka mina dubuiyaka 7 tau noibanu rofu vata niyo—ina tau noibanu mida de muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gabi koukou mina rema ka muyeyo. ");
INSERT INTO kqc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mina dada dadi rae renari, ina bi kaere di rema nigo, adina bi amiye 7 tau noibanu yaku meyadi?” ");
INSERT INTO kqc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Iesu yaku nikabai reyo, “Gua medari amededi rema ma rumana bi mededi, ");
INSERT INTO kqc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","idu kaere vene Sei yaku niyo bi buni bi muyena gutuna dadi rae resi mina meda baegori ameyaine, bi iniye iniye de megedi. ");
INSERT INTO kqc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Adina dudusa muyegi anua regedi; ina bi dadi rae rena di mida mida, ye Sei di naivo naivo vima kana nisi ini mida mida nigedi dada. ");
INSERT INTO kqc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Idu mirona imiye yabo tafa di sinari bi Moses yaku ka una oteimaro, muyena vene bi dadi rae regedi, adina bi Varika amiye rofu niyo bi ‘Abraham di Sei, Isaac di Sei ma Jacob di Sei,’ vo niyo. ");
INSERT INTO kqc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ye ina bi vegu ameibobina di Sei, diya muyena vene di Sei. Ini mokenari tau noibanu bi vegu amededi.” ");
INSERT INTO kqc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ago gira oteimana vene be yaku nikabai resi niyadi, “Oteimana amiye, nikabai rei mona reyo!” ");
INSERT INTO kqc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Adina dudusa nikaitegika de regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Idu nikaitesi niyo, “Gokai bi nidedi Keriso bi David di tutubena? ");
INSERT INTO kqc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Adina David iniye yaku Psalms bukari bura reyo, ‘Varika amiye yaku nai Varika amiye rofu niyo: Nai vana rama eta rofu ameinu re ");
INSERT INTO kqc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bogo na yaku yi tuma vene yi yuka aena sana kana rigida mamo.’ ");
INSERT INTO kqc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mina dada David yaku ‘Varika amiye,’ vo niyo, ye gokai ida dudu ina bi ini tutubena?” ");
INSERT INTO kqc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amiye tau yaku neidegamadiri, ini usi dina vene rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Vei mona refo ago gira oteimana vene rofu, kaere varuka doba dudu nana regika ma maketiri amiye yaku ago buni dudu matagini reyagane, ma usa usa yavari ma irakuna sanari amena sana ka buni torari ura rededi. ");
INSERT INTO kqc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ina vene yaku obu vene di gugura ka duma resi ofa dudu usa usa doba nioteimadedi. Mina kana vene, ini kaunava bi tora iniye!” ");
INSERT INTO kqc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kamini Iesu yaku ne odoro resi bi gugura tau vene yaku Sei nivakena yava di fore aena mauari ini fore aegamadi mina vegamo. ");
INSERT INTO kqc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma obu irava bi fore keika keika remanu aeyo ma vesi ");
INSERT INTO kqc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","niyo, “Rama ya nida, mina gugura de nufa obu irava bi tora iniye aeyo, ma mina amiye tau yaku aeyadi bi ebu reyo. ");
INSERT INTO kqc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Adina mina vene yaku fore tora tora ini gugura tau fafau aeyadi, idu mina rema ini gugura nufa de bi, ini tora noibanu aeyo; mina bi ini fafau ameibobigo gugura.” ");
INSERT INTO kqc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kamini ini usi dina vene be yaku Sei nivakena yava fore buni buni dudu risi Sei rofu moi aegedi gugura buni tau reyadi nidodi regamadiri, Iesu yaku bi kamini niyo, ");
INSERT INTO kqc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gua beika tau vededi—bi ini ari yokoi baego mironi, mina fore fafau fafau yokoi de amegedi; mina tau gade varadaugedi.” ");
INSERT INTO kqc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kamini nikaiteyadi, “Oteimana amiye, mina bi goivaka vata nigedi? Ma ini rebe bi gokai mina vata nigedi?” ");
INSERT INTO kqc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma niyo, “Nari rei mona refa; yokoi yaku ga ya eru reyaine. Ini adina amiye tau gade nai roka dudu baesi iniye nikake regedi, ‘Na bi Keriso!’ ma ‘Ari rama bi bae okiyo mini!’ Ina vene usi ga difa. ");
INSERT INTO kqc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Idu iya rena ma gavamani fafau ruda rena ago neidegediri, mina yaku yi uka ga dadiyaine. Adina mina kana bi ouresi vata niyaine, idu ari metona bi evade baena kode.” ");
INSERT INTO kqc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Resi ka niyo, “Gagani tora iniye iniye ma ourefeidena vene iniye iniye ruda regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gagani bedakairi, bi kono yagayaga regedi ma adabo ma orefadedi gauka ogau nigedi; ma ori rena beika baika ma rebe tora tora omari ka ogau nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Idu mina beika tau vata nina koderi, bi ya moisi esika esika masi usa usa yavari ma diburari ya kota reyainedi, kini ma gavana di nemokori nai roka dada ya afei bogedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mina bi yi ari buni mini amiye di nemokori nai ago ninegau regedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mina dada gokai ina vene di ago dairi magedi bi mokena moina ga refa, ");
INSERT INTO kqc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","adina na yaku ago ma mokena tora ya magida. Ye yi tuma vene tau bi yi ago kebi rina anua regedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ye yi nono baba, yi dubuiyaka, yi usika ourena, ma yi asiyaka yaku ka ya siri resi tourage resi ya umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ma amiye tau gade yaku nai roka dada ya gubuyo regedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Idu yi ada iye yokoi maka kava mina ka de rerevaida ni digo. ");
INSERT INTO kqc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yi are rei gira rena dudu ya kaya moi vegu rigedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Iya rededi vene yaku Jerusalem baesi buru ri deyo regedi vegediri, bi mokefa mina taoni bi evade ukero vau regedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mina ariri, ya kaere Judea gaganiri, bi omuna rofu ori difa, ma kaere taoni ideri bi feresi ori difa, ma ya kaere taoni etofaro bi ga dui refa. ");
INSERT INTO kqc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Adina mina meda bi ‘Kaunava vata nigo meda’, ye vegu tau rofu bura reyadi baesi rama aegedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mirona ituari, mina vegu no vata nigori, nono kaere bi rivo nufa ma nono ini mida susu irido ina fafau bi no iniye iniye! Adina bi esika esika tora gade iniye mina kono fafau vata nigo, ma Sei di kaunava mina vene fafau yarei dego. ");
INSERT INTO kqc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ma be vene bi bainasi dudu umuyegedi, ma be bi vegu moisi gagani gagani vene tauri moi digedi. Tutubena idana vene be yaku Jerusalem ri okisi ina vene rofu etei rigedi bogo ini ari bae koina nigo mamo. ");
INSERT INTO kqc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ye meda, eyo ma iya rofu bi de vena rebe mina ogau nigedi. Ma davara ini koru yeiva odoro dadisi kukuroka rebigo mina neidegori, bi gagani gagani vene tau mina kono tora fafau amededi, bi mokena forovai resi ori no iniye nigedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Beika vegu mina kono tora noibanu fafau vata nigedi rofu nari regediri, bi amiye yaku ori dudu muyei tamatama regedi. Adina bi omari ini vava amededi mina ka moi tururu regedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mina usi, amiye yaku Amiye di mida seuyari vava ma vabara tora nufari debigo mina vegedi. ");
INSERT INTO kqc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mina reremama vata nigi kora regori, bi dadi are resi ne odoro rifa, adina Sei ya moi vegu rigo di meda bi baesi negau niyo mini.” ");
INSERT INTO kqc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Resi mokena ago yokoi niyo: “Fuka yabo ma yabo tau vesi mokefa. ");
INSERT INTO kqc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ini iye imu regori, bi ya diba nigedi amona bi bae negau nido. ");
INSERT INTO kqc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mina dada, mina ogau nibigedi ma vegediri, bi ya ya diba Sei di ourefeidena amena sana di ari bi negau nigi rego. ");
INSERT INTO kqc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Rama ya nida, gua ari amededi vene bi muyei vau rena koderi, bogo mina beika baika tau gade vata nigedi mamo. ");
INSERT INTO kqc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Oma ma kono bi roro nigedi, idu nai ago bi roro de nigo. ");
INSERT INTO kqc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ya kaya nari rei mona refa! Iruku ma koru gira rofu dadaga ga refa. Yi vegu di toe di mokena tau yaku ya moi forovai ga reyaine. De bi, mina meda bae evade iruruka regori, tururu regedi baebu ya bi ivota ideri ya moi gira regedi kana. ");
INSERT INTO kqc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Adina mina meda bi kono tora noibanu vene tau rofu baesi ogau nigo. ");
INSERT INTO kqc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mina dada ari neinei nari regasa usa usa nifa, ya bi yeiva moisi beika tau vata nigo mina rofu ebu regi Amiye di mida di nemokori are regedi.” ");
INSERT INTO kqc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ari neinei Iesu bi Sei nivakena yavari amiye oteimagamo. Idu urusa nigamori, bi dadisi Olive yabo di omuna ikari bosi amegamo. ");
INSERT INTO kqc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ari uvegamori, bi amiye tau bosi Sei nivakena yavari ini ago nigo mina neidegi egogo regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Beredi yeast de di irakuna ari bae kaira niyo. Mina ari di roka bi Ferei ebu rena irakuna. ");
INSERT INTO kqc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene bi sui dudu Iesu moisi umuyegedi di ida maina regamadi, adina bi amiye rofu ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Minari bi Satani yaku Judas, kaere ini roka Iscariot vo nigamadi, di ukari dui reyo. Ina ka bi Iesu di usi dina amiye 12 yokoi. ");
INSERT INTO kqc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kamini ina bi dadisi Sei ma amiye utari naivo vene di varika vene ma Sei nivakena yava di iya rena ourefeidena vene rofu bosi sina sina niyo gokai ida dudu Iesu siri rego mina. ");
INSERT INTO kqc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bi ada tora gade resi Judas rofu nitore reyadi fore magedi vo niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ma mina venesa ini uka moi yokoi maka risi gokai siri rego di ida maina regi kora reyo ma amiye tau di fufuta rofu. ");
INSERT INTO kqc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Beredi yeast de di irakunari, Ferei ebu rena irakuna di mamoe mida ori sisika regi di meda baeyori, ");
INSERT INTO kqc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu yaku Peter ma John nifeidesi yomakai niyo: “Bosi Ferei ebu rena irakuna di iruku irigifa mina dogo refa.” ");
INSERT INTO kqc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kamini nikaitesi niyadi, “Yi ura bi goinari dogo regifa?” ");
INSERT INTO kqc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma nikabai reyo, “Taoni ideri bogediri, bi mironari amiye yokoi koru urena uakaisi ya baku rego. Goina yavari dui rego, bi usi ka dui resi ");
INSERT INTO kqc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yava biyaguna amiye nioteimafo, ‘Oteimana amiye yaku ya rofu niyo, Goina daiyutu bi nai usi dina venesa Ferei ebu rena irakuna di iruku irigifa?’ ");
INSERT INTO kqc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mina yava amiye yaku odorori daiyutu tora ya oteimago. Mina bi sena veika reyadi. Mironari uni iruku dogo refo.” ");
INSERT INTO kqc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ma feresi bi beika ago niyo kana mina veitao resi Ferei ebu rena irakuna di iruku dogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kamini ini iruku irina meda nemoko moiyori, Iesu bi ini nifeidena venesa iruku irina sanari ameinu reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Resi bi ina vene rofu niyo, “Nai mokena tora bi vakoi gogo amesi mina Ferei ebu rena irakuna iruku irigifa, esika esika moina di budari! ");
INSERT INTO kqc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Adina ya vene ya nida, na bi mina iruku dudusa de irigida bogo ini rama iniye Sei di ourefeidena amena sanari ogau nigo.” ");
INSERT INTO kqc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Resi biyo moisi Sei rofu buni tora gade masi niyo, “Mina biyo moisi ya kaya ka rau refa. ");
INSERT INTO kqc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Adina ya nida, na bi gua rofu mina waini meko de irigida bogo Sei di ourefeidena amena sana okigo mamo.” ");
INSERT INTO kqc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kamini bi beredi be moisi Sei rofu buni tora gade masi uroki resi ina vene magasa niyo, “Mina bi nai roaita, ya dada ya maida. Mina na mokegi rebifa.” ");
INSERT INTO kqc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mina usi iri vau reyadiri, Iesu bi mina ida dudu biyo moisi niyo, “Mina biyo bi nai dava Sei di uka ago ruaka regi ya vene rofu rausi reyaka. ");
INSERT INTO kqc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Idu na siri rego amiye di vana bi nasa mina teiborori! ");
INSERT INTO kqc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Adina Sei yaku niyo kana Amiye di mida muyego, idu mina amiye rofu bi iriyeduka no iniye, kaere bi Amiye di mida siri rego.” ");
INSERT INTO kqc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kamini iniye iniye nikaitegasa nigi kora reyadi, “Mina bi kaere uni fogori yaku mina vegu rego?” ");
INSERT INTO kqc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Resi ini usi dina vene iniye kayamo reyadi kaere bi ini mokenari tora iniye. ");
INSERT INTO kqc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Iesu yaku niyo, “Gagani gagani vene di kini yaku ini vene fafau ini vava moi raga resi ini vava dudu beika vegu rigedi amiye ini gabireri ago gira nisi iniye nigi ‘una bi uni vene di mokei vava amiye’ vo nidedi. ");
INSERT INTO kqc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ye yi fogori bi makai de, idu kaere yi fogori bi amiye tora iniye bi keika iniye niyaine, ma yi ourefeidena amiye bi naivo naivo amiye kana niyaine. ");
INSERT INTO kqc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Adina kaere bi tora iniye, amesi iruku irido amiye ba naivo redo amiye? Amesi iruku irido amiye bi tora ba? Idu, na bi yi fogori naivo amiye kana. ");
INSERT INTO kqc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nai uka maina regika nivegamori, ya vene bi nasa amegamadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mina dada, nai Baba yaku na moi varika riyo kana, na ka ya vene moi varika rida. ");
INSERT INTO kqc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Makai reyaka dada, ya bi nai teiborori ourefeidena amena sanari amesi nasa iruku ma koru irisi ya ka ourefeidena amena fata ameinu resi Israel vene di rubu 12 ourefeidegedi.” ");
INSERT INTO kqc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kamini Iesu yaku Peter rofu niyo, “Simon, na neide! Satani yaku Sei rofu usa niyo, yi uka maina regika nivego, ini mokena yaku yi uka mokena gira moi yaregedi, vo niyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Idu ya dada usa usa niyaka, yi mokena vari gira aena mina ga yareyaine, ye na rofu dairigiyari, bi yi asiyaka vene egira re.” ");
INSERT INTO kqc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Idu Peter niyo, “Varika amiye, na bi yasa ka dibura sanari bosi vakoi muyegifa!” ");
INSERT INTO kqc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma nikabai reyo, “Peter, ya rofu nida, kokoro gua raka nina koderi, bi uru regode na nisui regiya.” ");
INSERT INTO kqc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Resi Iesu yaku ina vene rofu niyo, “Pausi de, dura de, ma tamaka de ya nifeideyakari, bi beika besa be moigedi bi mokeyadi?” Nikabai regasa niyadi, “Beika yokoi de mokeyafa.” ");
INSERT INTO kqc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma ina vene rofu niyo, “Gua kaere fore di pausi o dura nufa bi moi; ma kaere bainasi de, bi ini bou varuka mina sero resi yokoi voi re. ");
INSERT INTO kqc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Makai ya nida bi Sei di ago ideri beika bura reyadi mina baesi vata niyainedi. Bi yomakai bura reyo, ‘Ina bi vegu no rededi venesa nikake reyadi,’ adina beika na dada bura reyadi bi baesi rama aego.” ");
INSERT INTO kqc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ina vene yaku kamini niyadi, “Varika amiye, ve kumo, bainasi remanu mini!” Ma niyo, “Kaini!” ");
INSERT INTO kqc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kamini Iesu yaku ini redo kana dadisi taoniri feresi Olive yabo di omuna ikari boyo. Ini usi dina vene ka inasa boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mina gaganiri okigasa ina vene rofu niyo, “Usa usa nifa yi uka maina regika nivegi keto regedi baebu.” ");
INSERT INTO kqc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kamini inaike etagae risi boyo, fore moisi makugedi di maike kana, resi efuka odesi usa usa nigasa ");
INSERT INTO kqc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","niyo, “Baba, ya ura reisa vonisi, bi mina esika esika di biyo na rofu moi etagae rigiya. Idu, ya yaku yi beika mokeisa mina resi nai mokena dudu bi ga re.” ");
INSERT INTO kqc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kamini naivo naivo vima yokoi omari gutuna desi ina rofu ogau nisi egira reyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma Iesu ini uka bi esika yaku vata baeyo dada, usa usa ni yeiva regamori, bi ini mofa bi dava kana kono fafauri yaregamadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Usa usa nigamo mina feresi dadisi ini usi dina vene rofu dairiyo. Varegamadiri, nesi baku reyo ma iriyeduka yaku no niyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Resi niyo, “Beika resi varededi? Dadisi usa usa nifa yi uka maina regika nivego baebu.” ");
INSERT INTO kqc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu ago nigamori, bi amiye tau gade okiyadi ma Judas, kaere bi amiye 12 ri yokoi, bi amiye tau gade ourefeidei baesi Iesu fuka resi ina atafu are reyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ye Iesu yaku nikaiteyo, “Judas, ya bi Amiye di mida fuka resi siri reisa ba?” ");
INSERT INTO kqc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kamini amiye kaere bi ina atafu beika vata nigo mina veyadiri, bi ina rofu niyadi, “Varika amiye, uni bainasi dudu ruda regifa ba?” ");
INSERT INTO kqc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma yokoi yaku Sei ma amiye utari naivo amiye tora di moimai rei tavoi redo amiye di anema rama kuita resi nugai feideyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Idu Iesu yaku niyo, “Mina kana vegu bi kaini!” Resi mina naivo amiye di anema avaka moiyori, bi buni niyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kamini Sei ma amiye utari naivo vene di varika vene ma Sei nivakena yava di iya rena ourefeidena vene ma tora vene, kaere bi moigika okiyadi, ina vene rofu niyo, “Ya vene bi duma duma amiye yokoi kana bainasi ma gai moisi baeyadi ba? ");
INSERT INTO kqc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ari neinei yasa Sei nivakena yavari amegamafari, bi de na moi gira reyadi. Idu gua bi yi ari—mukuna di vava ari.” ");
INSERT INTO kqc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kamini moi gira resi Sei ma amiye utari naivo amiye tora di yavari afei boyadi. Ma Peter bi egaima risi usi digamo. ");
INSERT INTO kqc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Be vene yaku yava ida nefau di tobori ita orisi amei buru riyadi. Peter ka ina vene di fogori baesi ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kamini naivo rema ofi yokoi bi Peter ita atafuri ameinu regamo mina vei mama resi niyo, “Mina amiye ka inasa digamo amiye yokoi mini!” ");
INSERT INTO kqc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Idu nisui resi niyo, “Rema, na na toto ina!” ");
INSERT INTO kqc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma doba deri bi amiye yokoi yaku vesi niyo, “Ya ka bi ini asini yokoi!” Idu Peter yaku niyo, “Na bi de.” ");
INSERT INTO kqc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ye meda nemoko yokoi kana ebu reyori, amiye yokoi yaku nigira resi niyo, “Rama iniye mina amiye ka bi inasa, adina ina ka bi Galilee amiye!” ");
INSERT INTO kqc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Idu niyo, “Na na toto ya beika nisa bi!” Mina niyori, bi evade kokoro raka niyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Varika amiye ne kero resi Peter vei mona reyo. Ye Peter minari bi kamini Iesu beika vata nigo di ago niyo mina mokeyo, “Kokoro gua raka nina koderi, uru regode na nisui regiya.” ");
INSERT INTO kqc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ye etofaro yakusi isaka no iniye iniye niyo. ");
INSERT INTO kqc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma Iesu moi gira reyadi vene yaku nikurusi ubobo resi ");
INSERT INTO kqc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ini nemoko fafa risi nikaitesi nigamadi, “Ya bi Sei di ago nido amiye vonisi, beika vata nigo una ni; kaere ya uyo ini roka ni.” ");
INSERT INTO kqc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ago no tora gade ina fafau nisi nifafana regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ari uveyori, bi amiye di kanisoro tora vene, ma Sei ma amiye utari naivo vene di varika vene, ma ago gira oteimana vene egogo resi Iesu afei bosi kota resi ");
INSERT INTO kqc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","niyadi, “Ya bi Keriso vonisi, bi una ni.” Idu niyo, “Ya nigida vonisi, bi mokena vari gira de aegedi; ");
INSERT INTO kqc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma ya nikaitegida vonisi, bi ida yokoi dudu de na nikabai regedi. ");
INSERT INTO kqc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Idu gua ari gutuna Amiye di mida bi Sei Vava iniye di vana ramari amego.” ");
INSERT INTO kqc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma ina tau vakoi yaku niyadi, “Ye ya bi Sei di mida ba?” Ma niyo, “Ya yaku nidedi mina bi na.” ");
INSERT INTO kqc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma niyadi, “Beika resi una bi mina ago di adina besa ni maina resifa? Uniye bi ini vena ago neideyafa mini.” ");
INSERT INTO kqc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamini egogo reyadi vene tau gade dadisi Pilate rofu Iesu afei bosi ");
INSERT INTO kqc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ina rofu nitourage resi kora resi niyadi: “Mina amiye vei tau reyafa bi uni vene di uka moisi Caesar rofu takesi mana ga rena vo nigamo. Resi iniye nigika ina bi Keriso, kini yokoi.” ");
INSERT INTO kqc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ye Pilate yaku nikaitegasa niyo, “Ya bi Jew vene di kini ba?” Ma nikabai reyo, “Yo, ya bi mina niyo.” ");
INSERT INTO kqc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma Pilate yaku Sei ma amiye utari naivo vene di varika vene ma amiye tau rofu niyo, “Mina amiye rofu no yokoi baku rena de reida.” ");
INSERT INTO kqc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Idu ina vene bi ago nigira resi niyadi, “Ina bi amiye tau Judea gaganiri oteimasi di uka moi odoro rido. Galilee ri siko ago nioteimai disi bi gua minari baeyo.” ");
INSERT INTO kqc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate yaku mina ago neidegasa nikaitesi niyo, “Mina amiye bi Galilee amiye ba?” ");
INSERT INTO kqc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Resi bi diba niyo ina bi Herod di vava gabireri, bi Herod rofu nifeideyo, kaere mina ariri iniye ka bi Jerusalem ri. ");
INSERT INTO kqc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod yaku Iesu veyori, bi ada iniye reyo, adina ini sina neidesi meda torari ini ura bi vego. Ini uka mokenari bi rebe be rego ma vego. ");
INSERT INTO kqc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod yaku ago tau gade dudu nikaitegasa nigamo, idu bi ago yokoi be nikabai de reyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma Sei ma amiye utari naivo vene di varika vene ma ago gira oteimana vene yaku ina rofu gubuyo resi nitourage regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma Herod ini iya rededi venesa ninika nisi nikurugamadi. Resi bi kamini varuka burefe aku masi Pilate rofu dairi moi feideyadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mina medari maka Herod ma Pilate dudusa uka yokoi maka niyadi. Sena bi ina remanu bi de auta regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kamini Pilate yaku Sei ma amiye utari naivo vene di varika vene ma ourefeidena vene ma amiye tau niegogo resi ");
INSERT INTO kqc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ina vene rofu niyo, “Ya vene yaku mina amiye na rofu moi baesi nitourage renari niyadi bi amiye di uka moigamo. Yi nemokori nikaitega vaigasa reyaka. No yokoi de baku reyaka, gua ya vene yaku na nidedi kana. ");
INSERT INTO kqc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod yaku ka no yokoi de baku reyo, dada dairi una rofu nifeideyo. Mina amiye bi no yokoi reyo dada muyeyaine. ");
INSERT INTO kqc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ye nigida ma buburu vai resi nifeidegedi.” ");
INSERT INTO kqc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Idu ina tau vakoi imuna niyadi, “Mina amiye afei bo, idu Barabbas uni erufu!” ");
INSERT INTO kqc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ina bi amiye fogori, amiye yokoi kaere bi taoni ruda rena yokoi moi vata risi amiye be umuyeyo ma dibura yavari aeyadi.) ");
INSERT INTO kqc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ye Pilate dudusa ago niyo. Ini ukari mokena moigamo bi Iesu erufugo, ");
INSERT INTO kqc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","idu imuna nigamadi, “Satauro ikoko re, satauro ikoko re!” ");
INSERT INTO kqc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma uru regode kamini niyo, “Beika resi, ina bi beika vegu no be reyo? Vegu no dada muyeyaine di adina bi baku de reyaka! Mina dada buburu vai rena maka resi moi feidegida.” ");
INSERT INTO kqc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Idu goroka tora dudu nitona tona reyadi, “Satauro ikoko re!” Ini ago yaku vava niyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dada Pilate ini mokena bi mina vene di usa niyadi kana Iesu rofu rego. ");
INSERT INTO kqc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mina ruda resi amiye umuyeyo amiye, kaere bi dibura yavari aeyadi, bi kamini erufuyo, kaere bi usa nigamadi. Idu Iesu ina vene di vanari aeyo, ini mokeyadi kana reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iya rededi vene Iesu afei bogasa Cyrene gagani amiye yokoi roka Simon, kaere bi taoni etofaro gutuna digamori, bi moi gira resi satauro ina fafau aeyadi ma uakaigasa Iesu usi boyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Amiye tora gade ina usi boyadi. Mina amiye tau fogori bi rema vene be iriyeduka resi ina dada isaka nigamadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Idu Iesu ina vene rofu kero resi niyo, “Jerusalem rema vene, na dada isaka ga nifa, idu ya kaya ma yi mida dada isaka nifa. ");
INSERT INTO kqc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Adina bi, ini ari baegedi bi amiye yaku nigedi, ‘Mida de rema vene, ma natu rema vene, kaere bi susu de maro, bi buni tora gade regedi!’ ");
INSERT INTO kqc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mina ariri bi amiye yaku omuna rofu nigedi, ‘Una fafau yare!’ resi ika keika keika rofu bi, ‘Una moi sui rifa!’ ");
INSERT INTO kqc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Adina bi yabo veguri bi makai regedi vonisi, ye yabo abiye nigori, bi gokai?” ");
INSERT INTO kqc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amiye remanu, kaere bi vegu no reyadi vene, ka Iesu sa vakoi umuyegi afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gagani roka “Ada girika” ri bae okisi satauro ikoko reyadi, vegu no reyadi amiye remanusa. Yokoi bi ini vana rama rofu ma yokoi bi ini vana enana rofu. ");
INSERT INTO kqc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Iesu yaku niyo, “Baba, ini vegu no koite maku; adina bi ina toto dada makai rededi.” Ma iya rededi vene laki isira dudu ini varuka ina yokoi yokoi moiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Amiye tau yaku are resi vegamadiri, bi Jew vene di ourefeidena vene bi Iesu ninika nigasa nigamadi: “Amiye be bi moi vegu riyo; ina bi Keriso, kaere Sei yaku abidi reyo amiye vonisi, bi iniye moi vegu riyaine!” ");
INSERT INTO kqc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma iya rededi vene ka nifafana resi baesi waini ru mina magasa ");
INSERT INTO kqc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nigamadi, “Ya bi Jew vene di kini vonisi, bi ya kaya moi vegu ri!” ");
INSERT INTO kqc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ini satauro yabo odorori ka bi yomakai bura reyadi: “Mina bi Jew vene di kini.” ");
INSERT INTO kqc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma vegu no reyo amiye yokoi satauro ikoko reyadi mina yaku Iesu nifafana regasa niyo, “Ya bi Keriso ba? Ya kaya moi vegu risi una ka una moi vegu ri!” ");
INSERT INTO kqc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Idu yokoi ere yaku emagasa niyo, “Ya bi Sei rofu ori reisa ba ide? Ini adina yi kaunava bi ini kaunava kana. ");
INSERT INTO kqc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Una beika moisifa bi uni vegu reyafa kana; rama moisifa mini. Idu yomina amiye bi vegu no yokoi rena de.” ");
INSERT INTO kqc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Resi niyo, “Iesu o, yi ourefeidena amena sana moigiyari, bi na na moke!” ");
INSERT INTO kqc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Iesu yaku ina rofu niyo, “Gua ya nitore reida mini, mina medari ya bi nasa ada rena sanari amegiya.” ");
INSERT INTO kqc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Meda nemoko tobo niyori, bi gagani tora noibanu bi mukuna yaku fono reyo boyo meda nemoko regodenu koina niyo mamo, ");
INSERT INTO kqc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ye mukuna yaku meda bou riyo ma Sei nivakena yava ideri biri rina varuka doba bi odoro gutuna utama uesi rei neyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma goroka tora dudu raka nigasa niyo, “Baba, yi vanari nai vima fereida!” Mina nisi asa youfeideyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma iya rededi vene di ourefeidena amiye tora yaku beika vata niyo mina vegasa Sei di roka moi odoro rigasa niyo, “Rama iniye ina bi vegu no nufa de amiye!” ");
INSERT INTO kqc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amiye tau gade iniye mina vata nigamo vegi egogo reyadi. Beika vata niyo mina vegasa iriyeduka tora gade resi ini rautu rofu dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma Iesu di asiyaka tau gade ma rema bedakai, kaere Galilee gutuna usi baegamadi, bi gaima gutuna are resi mina vegu vegamadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kamini kanisoro amiye yokoi ini roka bi Joseph, bi buni ma mokena rorobo amiye. ");
INSERT INTO kqc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ina bi Arimathea, Judea gagani di taoni yokoi amiye, idu kanisoro vene yaku egogo resi ini sina ago ma reremama regamadiri, bi de dui reyo. Kamini ina ka Sei di ourefeidena amena sana baego mina tua regamo. ");
INSERT INTO kqc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilate rofu bosi Iesu di roaita moigi usa niyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Resi bi ini roaita moi soka resi varuka buni dudu kumu risi kono guri fore ideri goeyadi bi ini roaita mina ideri aeyo. Mina kono guri bi ruaka; muyena roaita yokoi mina ideri aena kode. ");
INSERT INTO kqc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mina bi Sabati dogo rena di meda, adina Sabati meda bi kaira niyo. ");
INSERT INTO kqc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ma Iesu sa vakoi Galilee gutuna baeyadi rema vene bi Joseph usi bosi ini roaita gokai kono guri ideri aeyo mina veyadi. ");
INSERT INTO kqc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Resi bi sisika buni be dogo regika rauturi dairiyadi. Sabati medari, bi taru taru reyadi, adina bi ago gira yaku bi makai niyo dada. ");
INSERT INTO kqc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Idu ari uveyori uriyaku gorogoro iniye, fura di ourena medari, rema vene dadisi guri sanari sisika buni muramura sena dogo reyadi mina moi boyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Resi veyadi bi mina guri di ida venari fore bi sena moi kurevai rei etagae riyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Idu dui regasa Iesu Varika amiye di roaita baku de reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mina ini mokena moi forovai reyori, bi amiye remanu ina atafu are reyadi, kaere ini varuka bi kama kama iniye. ");
INSERT INTO kqc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ma ori resi ini seira kono rofu agu riyadiri, bi mina amiye remanu yaku nikabai reyadi, “Beika resi vegu amedo amiye bi muyena vene di fogori maina rededi? ");
INSERT INTO kqc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ina bi minari de amedo; bi dadi rae reyo. Galilee ri amegasa beika sina ya nigamo bi mokededi ba ide? ");
INSERT INTO kqc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yomakai niyo, ‘Amiye di mida bi vegu no rededi vene di vanari aesi satauro ikoko regedi, idu meda regodenu koina nigori bi dadi rae rego.’” ");
INSERT INTO kqc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ini ago kamini mokesi ");
INSERT INTO kqc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","guri sanari gutuna dairisi bi beika tau vata niyadi mina amiye 11 ma ini usi dina vene be rofu nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mina rema bi Mary Magdalene, Joanna ma Mary, kaere bi James di nono; ma rema be ina venesa yaku mina vegu nifeidena vene rofu niyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Idu mokeyadi mina rema di sina bi ago tavoi niyadi, ye mokena vari gira de aeyadi dada. ");
INSERT INTO kqc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Idu Peter bi dadisi raga bosi guri sana ideri agu risi dui regasa varuka buni maka veyo. Kamini beika vata niyo mina tururu regasa ini yavari dairiyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mina medari, Iesu di usi dina amiye remanu bi rautu roka Emmaus ri bogamadi, Jerusalem gutuna ini maike bi 11 kilometre kana. ");
INSERT INTO kqc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ina remanu bi mina beika tau vata niyo mina nidodi regamadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mina sina nigasa nidodi regamadiri, bi Iesu iniye bi ina vene atafu nisi kamini vakoi bogamadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vegamadi mini, idu de vei mama regamadi ina bi Iesu. ");
INSERT INTO kqc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kamini niyo, “Ya vene bi beika sina nigasa didedi?” Kamini ini ne uruma bi iriyeduka dudu are reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ina remanuri, bi yokoi di roka bi Cleopas, ina yaku kamini nikabai resi niyo, “Ya bi Jerusalem ri odi okiyo amiye baeko, dada ya toto mina meda be koina niyori beika vata niyadi bi?” ");
INSERT INTO kqc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kamini bi ina vene rofu niyo, “Beika vata niyo?” Ma ina rofu niyadi, “Iesu Nazareth amiye rofu nisifa, kaere bi Sei di ago nido amiye. Ina bi ini ago ma ini reremama bi yeiva iniye Sei ma amiye di nemokori. ");
INSERT INTO kqc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma uni Sei ma amiye utari naivo vene di varika vene ma uni ourefeidena vene yaku gokai iniye ini vanari moisi muyena ida risi satauro ikoko reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Idu uni uka mokena regamafa bi ina bi Israel vene erufugo amiye! Mina beika vata niyo bi meda regodenu koina niyo mini. ");
INSERT INTO kqc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Idu gua uni rema vene be yaku una moi tururu reyadi. Uriyaku gorogoro guri sanari bosi ");
INSERT INTO kqc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bi ini roaita de baku resi dairi desi niyadi bi yaduka kana naivo naivo vima ka veyadi. Mina naivo naivo vima yaku nioteimaradi bi vegu niyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Be vene unasa bi kamini dadi guri sanari bogasa bi rema vene yaku niyadi kana makai baku reyadi, idu Iesu bi de veyadi.” ");
INSERT INTO kqc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kamini Iesu yaku ina vene rofu niyo, “Ya vene bi ada de iniye; yi mokena bi mukuna tora. Sei di ago nidedi vene di ago tau bi mokena vari gira de aededi! ");
INSERT INTO kqc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ba rorobo ide, Keriso bi mina kana esika moisi ini vabara moigo?” ");
INSERT INTO kqc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kamini Moses gutuna Sei di ago niyadi vene tau rofu ago buni tau gaderi ina dada bura reyadi sina di rama mina ni-itara reyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kamini bogasa rautu ekaira reyadi, idu Iesu bi ebu rei digo kana dudu nana reyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Idu guyaguya nisi niyadi, “Unasa amevo; uriyenau kamini niyo, ma doba de urusa nigo.” Dada ina venesa amegi dui rei boyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ina regodenu iruku irigi ameinu reyadiri, bi Iesu yaku beredi moisi buni tora gade masi bi okusi ina remanu maro. ");
INSERT INTO kqc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Minari mamo ini nemoko areyadi, bi vei mama reyadi ina bi kaere, ma ini neri roro nisi diyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iniye iniye rofu niyadi, “Uni uka ita kana vaido, idau baegamafa, ago nigasa Sei di ago di adina mina ni-itara regamori.” ");
INSERT INTO kqc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Minari maka dadisi Jerusalem ri dairiyadi. Iesu ini usi dina amiye 11 ma amiye be inasa bi minari egogo resi amededi baku reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ka niyadi, “Rama Varika amiye bi dadi rae resi Simon rofu ogau niyo!” ");
INSERT INTO kqc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ina remanu yaku idau beika vata nigi kora reyo ma gokai vei mama reyadi beredi okuyori ni-itara reyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mina vegu fafau nigamadiri, bi Iesu iniye ini utari are resi niyo, “Uka amuta bi yasa ameyaine.” ");
INSERT INTO kqc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Idu ina vene bi ori yaku no iniye iniye nisi ini mokenari bi muyena vima yokoi vegamadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Idu Iesu yaku niyo, “Beika resi yi mokena forovai redo ma yi uka deda nikaitena mina baededi? ");
INSERT INTO kqc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nai yuka vana vefa, mina bi na mini; na avaka moisi vefa. Adina vima bi musa ma nena koina ma na vededi na bi nai musa ma nena nufa.” ");
INSERT INTO kqc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mina ni vau resi bi ini vana ma yuka oteimaro. ");
INSERT INTO kqc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Idu tururu reyadi ma ada yaku no iniye niyadi, ye bi ofa ba rama mokena moi forovai reyadi, dada Iesu yaku niyo, “Iruku keika be amedo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oyena kiro reyadi di tu yokoi maradi ");
INSERT INTO kqc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma ini nemokori moisi iriyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Resi niyo, “Mina bi nai ago yasa amegasa nigamaka: na dada beika tau bura reyadi Moses di ago girari, Sei di ago niyadi vene di burari ma Psalms bukari. Mina tau bi baesi rama aeyaine.” ");
INSERT INTO kqc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dada Sei di agori beika bura reyadi vei mama reyaganedi ini mokena moi vabara risi ");
INSERT INTO kqc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","niyo, “Yomakai bura reyo: Keriso bi mina kana esika moigo ma meda regodenu koina nigori, bi muyena sanari dadi rae rego. ");
INSERT INTO kqc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dada Keriso di roka dudu vegu no feresi moi etagae rina ma vegu no koite makuna di ago ouresi Jerusalem gutuna gagani gagani vene tauri disi nirausi rei diga boga reyagane. ");
INSERT INTO kqc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ya vene yaku mina vegu tau bi yi nemokori veyadi mina oteimagedi. Mina dada ya vene yaku nirausi regedi. ");
INSERT INTO kqc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dada, nai Baba ya magi nitore reyo, bi na mina ya vene fafau nifeidei degida. Kamini ya bi taoni ideri tua regedi bogo mina vava yaku ya fafau nivai rego mamo.” ");
INSERT INTO kqc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kamini Iesu yaku ina vene taoni gutuna afei boyo Bethany atafu, ini vana moi odoro resi ni buni tora gade maro. ");
INSERT INTO kqc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mina buni tora gade magamori, bi ina vene rofu etagae riyo ma oma odoro afei boyo. ");
INSERT INTO kqc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ina vene yaku nivakesi ada tora iniye dudu Jerusalem rofu dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kamini Sei nivakena yavari ari neinei Sei rofu buni tora gade magamadi. ");
INSERT INTO kqc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Senagi beika baika rina koderi, Ago bi sena amegamo; mina Ago bi Sei sa, ma mina Ago bi Sei. ");
INSERT INTO kqc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ini adinari gutuna ina bi Sei sa amegamo. ");
INSERT INTO kqc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Beika baika tau bi ina dudu vata niyadi; beika yokoi ini fufuta rofu bi de vata niyadi idu ina rofu maka. ");
INSERT INTO kqc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mina ago ideri bi vegu; ye mina vegu bi amiye di vabara. ");
INSERT INTO kqc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mina vabara yaku mukunari gagani kikido, ma mukuna yaku de ukafeyo. ");
INSERT INTO kqc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sei yaku amiye yokoi nifeideyo, ini roka bi John Baptist. ");
INSERT INTO kqc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ina deyo bi mina vabara di beika veyo kana mina niokugika, ye tau gade mina ago neidesi mokena vari gira aeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iniye bi mina vabara de, idu bi mina vabara sina nigika deyo. ");
INSERT INTO kqc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mina bi rama vabara—mina yaku kono tora noibanuri desi amiye tau vakoi moi vabara redo. ");
INSERT INTO kqc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sei yaku mina Ago dudu kono riyo, ye mina Ago bi konori, idu amiye yaku bi de vei mama reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iniye di gaganiri deyo, idu iniye di vene yaku faiva de niyadi. ");
INSERT INTO kqc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Idu amiye tau gade kaere faiva nisi ini roka fafau mokena vari gira aeyadi, bi Sei di mida mida nigi di vava maro. ");
INSERT INTO kqc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sei di mida mida niyadi, una vata nisifa kana de, ma baba ura redo vata nigedi kana de, idu Sei iniye rofu vata niyadi. ");
INSERT INTO kqc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma mina Ago bi amiye iniye nisi uni fogori amegamo. Ini vabara bi veyafa; mina vabara bi Baba rofu ini Mida yokoi maka fafau deyo kana, ma ini Baba bi buni tora gade ma rama iniye yaku vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John Baptist yaku niokugasa raka niyo, “Na yaku nigamaka amiye bi mini, resi niyaka, ‘Kaere na usi baedo, bi na kana de; bi isivaga iniye, na vata nina koderi ina bi amegamo dada.’” ");
INSERT INTO kqc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kamini una tau vakoi Ini vabara tora gutuna uni buni tora gade moi tanu resi moiyafa. ");
INSERT INTO kqc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sei yaku ini ago gira bi Moses dudu maro; idu buni tora gade ma rama bi Iesu Keriso dudu deyo. ");
INSERT INTO kqc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yokoi yaku Sei vena de, de iniye, idu ini Baba di eta rofu amedo amiye yaku una fafau Sei yokoi maka moi ogau riyo. ");
INSERT INTO kqc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ye Jew vene di ourefeidena vene yaku Sei ma amiye utari naivo vene ma Levi di rubu vene be Jerusalem gutuna nifeideyadi, ma John Baptist nikaiteyadi, “Ya bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma John bi nisui de resi niogau regasa niyo: “Na bi Keriso de.” ");
INSERT INTO kqc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ye nikaiteyadi, “Makai ye ya bi kaere? Ya bi Elijah ba?” Ma nikabai reyo, “Ide.” Ma nikaiteyadi, “Ya bi mina Sei di ago nido amiye ba?” Kamini nikabai reyo, “Ide.” ");
INSERT INTO kqc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ye dudusa niyadi, “Makai ye ya bi kaere? Ya yaku beika una nigiya, mina moi dairi bogifa una nifeideyadi vene rofu: Ye ya kaya rofu bi beika nigiya?” ");
INSERT INTO kqc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kamini niyo: “Sei di ago niyo amiye roka Isaiah niyo kana, na bi ‘amiye yokoi di goroka gagani autu sanari raka nida: Varika amiye di ida moi rorobo rifa!’” ");
INSERT INTO kqc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisee di nifeidena vene yaku ");
INSERT INTO kqc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nikaiteyadi, “Ya bi Keriso, ba Elijah, ba mina Sei di ago nido amiye de vonisi, ye beika resi babatiso reisa?” ");
INSERT INTO kqc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma nikabai reyo, “Na yaku koru dudu babatiso reida, idu yi fogori are redo amiye yokoi bi ya ya toto. ");
INSERT INTO kqc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ina bi na usi baego, idu na bi rorobo de ini yuka ro di maena younegida.” ");
INSERT INTO kqc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mina vegu tau gade bi Jordan koru di meda dadido eta rofu Bethany ri vata niyadi; mina sanari John yaku babatiso regamo. ");
INSERT INTO kqc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ari uveyori John yaku Iesu ina rofu baedo ma vesi niyo, “Sei di Mamoe mida mini, kaere yaku kono tora noibanu vene di vegu no erufudo! ");
INSERT INTO kqc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na yaku nigamaka amiye bi mini, resi niyaka, ‘Amiye yokoi na usi baedo, bi na kana de; bi isivaga iniye, na vata nina koderi ina bi amegamo dada.’ ");
INSERT INTO kqc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ye na kaya na toto ina, idu na baeyaka bi koru dudu babatiso regamaka bi Israel vene rofu ina niokugika.” ");
INSERT INTO kqc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma John bi ini beika veyo mina niokuyo: “Vima bi pune erena kana oma gutuna desi ina fafau rou riyo mina veyaka. ");
INSERT INTO kqc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na kaya na toto ina, idu Sei, kaere yaku koru dudu babatiso regi na nifeideyo, bi na rofu niyo, ‘Vima vegiya ma desi amiye yokoi fafau amego; mina bi kaere Vima kikifa dudu babatiso rego.’ ");
INSERT INTO kqc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma na bi vesi niokuyaka ina bi Sei di mida.” ");
INSERT INTO kqc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ari uveyori John bi mironari ini usi dina amiye remanusa dudusa are regamadiri, ");
INSERT INTO kqc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iesu nana rei bae boyo ma vesi niyo, “Sei di Mamoe mida bi mini!” ");
INSERT INTO kqc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kamini ini usi dina vene remanu mina neidesi Iesu usi boyadi. ");
INSERT INTO kqc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu kero resi ina usi baededi mina vesi nikaiteyo, “Ya bi beika maina rededi?” Ma nikabai reyadi, “Rabbi (ini adina bi ‘Oteimana amiye’), ya bi goinari ameisa?” ");
INSERT INTO kqc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nikabai reyo, “Baesi ma ya kaya vegedi.” Ye inasa bosi ini amedo sana vesi mina medari ameyadi, meda nemoko bi 4 kana uriyenau niyo dada. ");
INSERT INTO kqc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ina vene kaere John ago niyo mina neidesi Iesu usi boyadi yokoi bi Andrew, Simon Peter di dubuini. ");
INSERT INTO kqc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kamini ini dubuini Simon siko baku resi niyo, “Una bi Keriso (ini adina bi ‘Auba reyo amiye’) baku reyafa.” ");
INSERT INTO kqc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Resi Iesu rofu afei boyo. Ma vesi niyo, “Ye ya bi Simon, John di mida, idu bi yi roka Cephas (ini adina bi Peter o ‘fore’) nigedi.” ");
INSERT INTO kqc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ari uveyori Iesu Galilee bogika mokeyo. Philip baku resi niyo, “Na usi bae!” ");
INSERT INTO kqc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Philip bi Bethsaida taoni amiye, Peter ma Andrew yaku amededi taoni.) ");
INSERT INTO kqc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip yaku Nathanael baku resi niyo, “Una bi Moses yaku ago girari ma Sei di ago niyadi vene ka bura reyadi di amiye baku reyafa. Ina bi Iesu Nazareth amiye, Joseph di mida.” ");
INSERT INTO kqc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ye Nathanael yaku niyo, “Beika buni Nazareth gutuna baego?” Ma nikabai reyo, “Baesi ve.” ");
INSERT INTO kqc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nathanael baeyori, Iesu yaku vesi niyo, “Mina bi rama iniye Israel amiye; ini ideri bi ofa sina yokoi de!” ");
INSERT INTO kqc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma nikaiteyo, “Gokai ida dudu na vei mama reyo?” Ma nikabai reyo, “Philip ya raka nina koderi, ya bi fuka yabo gabireri na bi sena ya veyaka.” ");
INSERT INTO kqc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma nikabai reyo, “Oteimana amiye, ya bi Sei di mida; ya bi Israel di Kini!” ");
INSERT INTO kqc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma niyo, “Ya bi fuka yabo gabireri ya vesi nida, dada mokena vari gira aesa ba? Beika baika tora besa vegiya!” ");
INSERT INTO kqc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Resi niyo, “Rama iniye ya nida: oma bi ekego ma Sei di naivo naivo vima bi Amiye di mida fafau dega bogasa rebigedi kana vegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Meda regodenu koina niyori, bi mena irakuna yokoi Cana, Galilee gaganiri. Ma Iesu ini nono ka mironari ");
INSERT INTO kqc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ma Iesu ini usi dina venesa ka boyadi mena irakunari daga reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Waini koina niyori, Iesu ini nono yaku ina rofu niyo, “Ina vene di waini bi koina niyo.” ");
INSERT INTO kqc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma nikabai reyo, “Na rofu bi beika? Nai meda nemoko bi okina kode.” ");
INSERT INTO kqc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Idu ini nono yaku naivo rededi vene rofu niyo, “Ya rofu beika nigo bi refa.” ");
INSERT INTO kqc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mironari bi koru di urena daidai tora kono kaka dudu riyadi tora tora 6 moi vataru reyadi; Jew vene yaku mina dudu moi ruaka rina vegu reyadi. Mina yokoi yokoi bi 75-115 litre kana. ");
INSERT INTO kqc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu yaku naivo naivo vene rofu niyo, “Urena bi koru moi vata baefa.” Ma evade moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kamini ina vene rofu niyo, “Gua mamo be erausi resi irakuna ourefeidena amiye rofu moi bofa.” Makai resi moi boyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mina irakuna ourefeidena amiye yaku koru kero resi waini niyo mina irigasa goinari baeyo bi toto, idu koru erausi rena naivo rededi vene maka ina diba. Ye irakuna ourefeidena amiye yaku rema mego amiye raka nisi ");
INSERT INTO kqc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","niyo, “Amiye tau gade yaku waini burefe ouresi moi yakudedi ma okina vene yaku iri vau regedi mamo waini buni de magedi. Idu ya bi waini burefe moi gira rei baeyo gua mamo!” ");
INSERT INTO kqc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mina bi ini ouresi mokena vegu, Cana Galilee gaganiri reyo; mironari ini vabara moi ogau riyo ma ini usi dina vene ina rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mina usi ini nono ma ini dubuiyaka ma ini usi dina venesa Capernaum taoni bosi mironari meda be ameyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jew vene di Ferei ebu rena irakuna meda bi negau niyori, Iesu bi Jerusalem ri boyo. ");
INSERT INTO kqc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kamini Sei nivakena yava ideri bi boromakau, mamoe ma pune erena sero rena vene ma fore senesi rena vene ameinu rededi ma baku reyo. ");
INSERT INTO kqc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Buburu vai rena maena risi mamoe ma boromakausa Sei nivakena yavari umeki rei feidesi fore senesi rena vene di fore moi urafo rei makusi ini teiboro moi evairo riyo. ");
INSERT INTO kqc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Resi pune erena sero rena vene rofu yomakai niyo, “Minari moi etagae rifa; nai Baba di yava bi yi maketi sana ga rifa!” ");
INSERT INTO kqc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ini usi dina vene yaku burari riyo kana mokei tora reyadi, “Yi yava rofu mokei tora reida, bi nai uka meko ita kana vaido.” ");
INSERT INTO kqc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ye Jew vene nikaiteyadi, “Beika rebe una rofu oteimagiya ma diba nigifa ya vava nufa mina kana vegu reisa bi?” ");
INSERT INTO kqc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kamini nikabai reyo, “Mina Sei nivakena yava ukero vau regedi ma meda regodenuri na dudusa akugida.” ");
INSERT INTO kqc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ye niyadi, “Mina Sei nivakena yava bi lagani 46 moiyo mamo aku vau reyadi, idu ya yaku meda regoderi akugiya ba?” ");
INSERT INTO kqc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Idu bi ini roaita nikake dudu ago niyo. ");
INSERT INTO kqc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mina dada muyesi dadi rae reyori, ini usi dina vene yaku mina ago niyo mokei kero resi Sei di ago ma Iesu di ago rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesu bi Jerusalem ri Ferei ebu rena irakunari amegasa rebe bedakai reyori, amiye tau yaku mina mokena vegu vesi ina rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Idu Iesu ina kaya ini uka tau di mokena ina vene rofu de maro, adina bi mina amiye tau gade ini uka diba nisi ");
INSERT INTO kqc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","amiye yokoi yaku amiye rofu nioteimagi bi baku rena de, adina amiye di uka mokena bi sena veifateyo. ");
INSERT INTO kqc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pharisee amiye yokoi ini roka Nicodemus, ina bi Jew vene di ourefeidena amiye yokoi. ");
INSERT INTO kqc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Urusa yokoiri Iesu rofu baesi niyo, “Oteimana amiye, una una diba ya bi oteimana amiye, kaere bi Sei gutuna deyo, adina Sei inasa de bi, amiye yokoi mina kana rebe ya reisa kana de rego.” ");
INSERT INTO kqc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma nikabai reyo, “Rama iniye ya nida: amiye yokoi yaku Sei di ourefeidena amena sana bi de vego, idu ina bi dudusa vata nigo mamo.” ");
INSERT INTO kqc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma nikaiteyo, “Amiye bi ugava niyo, idu gokai ida dudu vata nigo? Rama iniye ini nono di rivo ideri dudusa uru remanu de dui resi vata nigo!” ");
INSERT INTO kqc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ma nikabai reyo, “Rama iniye ya nida, amiye yokoi yaku Sei di ourefeidena amena sana bi de dui rego bogo ma ina bi koru ma Vima dudu vata nigo mamo. ");
INSERT INTO kqc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Roaita yaku bi roaita evata rido, ma Vima yaku bi vima evata rido. ");
INSERT INTO kqc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tururu ga refa mina ago ya nidari, ‘Ya dudusa dairisi vata niyagane.’ ");
INSERT INTO kqc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aura yaku yomina eta ma yomirona eta rofu fu resi kukuroka nido ma neideisa, idu ya ya toto goina esona gutuna baedo ma goina dakai dido bi. Ye mina bi amiye tau noibanu Vima dudu vata nina bi makai.” ");
INSERT INTO kqc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma dudusa nikaiteyo, “Mina bi gokai makai?” ");
INSERT INTO kqc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma niyo, “Ya bi Israel vene di oteimana amiye, idu ya bi mina beika baika ya ya toto? ");
INSERT INTO kqc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rama iniye ya nida, beika una diba bi nisifa, ma beika veyafa bi niokusifa mini, idu ya vene bi uni beika nisifa bi de neidededi. ");
INSERT INTO kqc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na ya rofu bi kono di beika baika niyakari, idu ya mokena vari gira de aeyadi; ye na bi oma di beika baika rofu nigidari, gokai dudu ya mokena vari gira aegedi? ");
INSERT INTO kqc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma amiye yokoi yaku omari de boyo, idu yokoi maka bi oma gutuna deyo; mina bi Amiye di mida maka.” ");
INSERT INTO kqc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ye Moses yaku gagani autu sanari aruma moi odoro reyo kana, ye Amiye di mida makai ka moi odoro riyainedi, ");
INSERT INTO kqc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","amiye kaere ina rofu mokena vari gira aego bi toga toga ameibobina vegu baku rego dada. ");
INSERT INTO kqc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Adina Sei yaku konori amededi vene besa uka maro, ye ini Mida yokoi maka maro, ye kaere ina rofu mokena vari gira aego, bi de muyego idu toga toga ameibobina vegu baku rego dada. ");
INSERT INTO kqc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Adina Sei yaku ini Mida konori bi kono amededi vene kota regika de nifeideyo, idu ina dudu moi vegu rigo dada. ");
INSERT INTO kqc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kaere ina rofu mokena vari gira aedo bi kota de rego, idu kaere yaku mokena vari gira de aedo bi sena kota reyo, adina bi Sei di mida yokoi maka di roka rofu mokena vari gira de aeyo. ");
INSERT INTO kqc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ye mina bi kota rena di vegu: vabara bi kono tora noibanuri deyo, idu amiye bi vabara feresi mukuna rofu uka maradi, adina ini moi raga rededi vegu bi no. ");
INSERT INTO kqc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Adina amiye tau gade kaere vegu no moi raga rededi bi vabara fufuta masi negari de baegedi, ini vegu erau nigedi baebu. ");
INSERT INTO kqc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Idu amiye kaere yaku vegu rama redo bi vabarari baego, ye ina kaya vei mama rego ini vegu bi Sei dudu reyo dada. ");
INSERT INTO kqc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mina usi Iesu ma ini usi dina vene Judea gagani eta rofu boi neyadi, ye mironari ina venesa amesi babatiso regamo. ");
INSERT INTO kqc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John ka Aenon ri Salim atafu babatiso regamo, adina mironari bi koru tora gade, ma amiye ka degamadi babatiso regika. ");
INSERT INTO kqc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(John bi diburari aena koderi.) ");
INSERT INTO kqc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John di usi dina vene bedakai ma Jew amiye yokoi moi ruaka rina vegu dada kayamo resi ");
INSERT INTO kqc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","John rofu baesi niyadi, “Oteimana amiye, mina amiye kaere bi yasa Jordan koru di berou eta rofu ma ya yaku ini ago niokuyo, gua ina bi amiye babatiso redo, ma amiye tau gade bi ina rofu bodedi!” ");
INSERT INTO kqc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kamini nikabai reyo, “Amiye yokoi yaku beika baika yokoi de moigo, Sei omari yaku mago mamo. ");
INSERT INTO kqc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ya vene ka na yaku niyaka kana niokudedi, ‘Na bi diya Keriso, idu na siko ouregi nifeideyo.’ ");
INSERT INTO kqc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Rema megi redo rumana bi ini rema nufa. Rema mego amiye di asini bi are resi ini goroka neidegasa ada tora redo. Mina dada na ada tora iniye reida. ");
INSERT INTO kqc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ini roka bi boi tora niyaine, idu nai bi keika niyaine.” ");
INSERT INTO kqc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Odoro gutuna deyo amiye bi beika baika tau gade di vava nufa; kaere amiye mina kono di, ina bi mina kono amiye ma mina kono di beika baika tau gade di ago nido. Kaere omari gutuna deyo amiye bi mina beika baika tau gade rofu ina bi odoro iniye. ");
INSERT INTO kqc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ina yaku beika vesi neideyo rofu ago niokudo, idu amiye yokoi yaku ini niokuna ago bi de neideyo. ");
INSERT INTO kqc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Idu kaere ini niokuna ago neidedo, makai nido Sei bi rama iniye. ");
INSERT INTO kqc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Adina Sei yaku nifeideyo amiye bi ini ago nido, Sei yaku Vima di beika baika tau gade mado dada. ");
INSERT INTO kqc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba yaku ini Mida uka maro, dada beika baika tau gade di vava ini vanari aeyo. ");
INSERT INTO kqc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Amiye kaere ini Mida rofu mokena vari gira aedo bi toga toga ameibobigo, idu kaere ini mida di ago de neidedo bi toga toga ameibobina vegu bi de vego, ye Sei di gubuyo tora ina fafau amebigo. ");
INSERT INTO kqc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisee vene neideyadi Iesu bi usi dina vene tau gade moi babatiso reyo, idu John bi tau de. ");
INSERT INTO kqc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Rama iniye Iesu bi ina kaya babatiso de regamo, idu ini usi dina vene maka yaku reyadi.) ");
INSERT INTO kqc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kamini Iesu Judea feresi dudusa Galilee ri deyo; ");
INSERT INTO kqc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","idau bi Samaria gagani tobo toboma boyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ye ina bi Samaria di taoni yokoi okiyo, ini roka bi Sychar; mina atafuri Jacob yaku ini mida Joseph kono kefuka maro. ");
INSERT INTO kqc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob di guri koru bi mironari, ma Iesu yava ika oto dina rofu kosika no iniye reyo, ye mina guri koru atafuri ameinu reyo meda tobo niyo kana. ");
INSERT INTO kqc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kamini Samaria rema yokoi koru ugika baeyo ma Iesu yaku ina rofu niyo, “Koru be na ma.” ");
INSERT INTO kqc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Adina ini usi dina vene bi iruku voi regika taoni rofu neyadi.) ");
INSERT INTO kqc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma nikabai reyo, “Ya bi Jew amiye ma na bi Samaria rema—ye gokai resi na rofu koru usa nisa?” (Adina Jew vene bi Samaria venesa auta de rededi.) ");
INSERT INTO kqc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu yaku nikabai reyo, “Sei yaku beika mado ma kaere yaku koru ya usa nido bi diba niyo vonisi, ya bi ina usa niyagadu ma ina yaku vegu koru ya maraidu.” ");
INSERT INTO kqc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma niyo, “Varika amiye, ya bi koru una di beika baika yokoi de nufa ma guri koru ka bi soku tora. Goinari mina vegu koru moigiya? ");
INSERT INTO kqc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Uni tutubena Jacob yaku mina guri koru una masi iniye mina koru iriyo ma ini mida mida ma ini boromakau ka iriyadi. Ye ya bi ini isivaga ebu reisa ba?” ");
INSERT INTO kqc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma nikabai reyo, “Amiye tau gade kaere yaku mina koru irigediri, bi dudusa koru vaigedi, ");
INSERT INTO kqc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","idu kaere amiye na yaku magida ma irigo koru bi toga toga koru de vaigo. Na yaku ina rofu magida koru bi ini ideri koru buruka nisi furu furu regasa makai toga toga ameibobina vegu mago.” ");
INSERT INTO kqc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma rema yaku niyo, “Varika amiye, mina koru na ma kumo koru de vaigida ma dudusa minari baesi koru de ubigida.” ");
INSERT INTO kqc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma ina rofu niyo, “Nesi yi maruka raka nisi dairisi bae.” ");
INSERT INTO kqc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kamini nikabai reyo, “Na bi rumana koina.” Ma niyo, “Ya bi rumana koina vo niyo bi rama niyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Adina ya rumana 5 meyo, ma gua mina ameisa amiye bi diya yi maruka. Ya yaku beika ruika niyo bi rama.” ");
INSERT INTO kqc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma niyo, “Varika amiye, na yaku ya veida ya bi Sei di ago nido amiye. ");
INSERT INTO kqc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Uni tutubena vene yaku mina omunari Sei nivakegamadi, idu ya Jew vene nidedi bi Jerusalem ri maka amiye yaku Sei nivakeyagadu.” ");
INSERT INTO kqc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kamini Iesu yaku niyo, “Rema, na rofu mokena vari gira ae, ari baego ya vene yaku mina omunari bi de ma Jerusalem ri ka Baba de nivakegedi. ");
INSERT INTO kqc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ya vene bi beika nivakededi bi ya toto; idu una bi kaere nivakesifa bi una una diba, adina moi vegu rina bi Jew vene rofu baedo. ");
INSERT INTO kqc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Idu ari baedo ma gua okiyo mini, ye nivakei mona rededi vene bi ini Vima di vava ma ago rama dudu Baba nivakebigedi; adina Baba yaku mina kana vene ina rofu nivakegi maina redo. ");
INSERT INTO kqc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sei bi vima, ma ini nivakededi vene bi Vima di vava ma ago rama dudu maka nivakebiyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mina rema yaku niyo, “Na na diba mina Auba reyo amiye (Keriso vo nidedi) baego. Baegasa bi beika tau vanu una ni mona rego.” ");
INSERT INTO kqc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma niyo, “Na kaere yasa ago nida bi mina amiye.” ");
INSERT INTO kqc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mina nigamori ini usi dina vene dairi okisi ma remasa ago nigasa amedo mina vesi tururu reyadi. Idu yokoi yaku de nikaiteyadi, “Ya beika ura reisa?” o, “Beika resi ya mina remasa ago nisa?” ");
INSERT INTO kqc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ye rema ini koru urena feresi taoniri dairi nesi amiye rofu nioteimaro, ");
INSERT INTO kqc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Baefa amiye yokoi kaere na beika tau vanu reyaka mina na nioteimaro veyagane. Rama mina bi Keriso ba?” ");
INSERT INTO kqc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amiye taoni fere yakusi Iesu urana baeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mina fuofuori ini usi dina vene yaku ina niegira regasa niyadi, “Oteimana amiye, beika be iri!” ");
INSERT INTO kqc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Idu ina vene rofu niyo, “Nai irina iruku bi ya vene ya toto.” ");
INSERT INTO kqc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ye iniye iniye kamini niyadi, “Amiye yokoi yaku iruku moi bae maro baeko?” ");
INSERT INTO kqc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma niyo, “Nai iruku bi nai Baba, kaere na nifeideyo amiye, di ura resi ini moimai rei vau regida. ");
INSERT INTO kqc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ya yaku yomakai nidedi, ‘Eyo 4 maka nigo kumo usi bi nonobo rina meda okigo.’ Idu na yaku nida, yi nemoko aresi ma muro ne resi vefa. Iruku bi kaka niyo, ye nonobo rina negau niyo! ");
INSERT INTO kqc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Amiye kaere butu butu redo bi sena ini moimai rena di davana moisi toga toga ameibobina vegu di iruku ka butu butu redo; ye varido amiye ma butu butu rena amiye vakoi ada regedi dada. ");
INSERT INTO kqc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ye mina ago bi rama, ‘Amiye yokoi bi vari vari redo ma yokoi bi butu butu redo.’ ");
INSERT INTO kqc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na yaku ya nifeideyaka bi moimai de reyadi sanari butu butu reyaganedi. Amiye bedakai mironari moimai reyadi ma gabi ya vene bi ina venesa vakoi moimai reyadi.” ");
INSERT INTO kqc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria vene tau mina taoniri Iesu rofu mokena vari gira aeyadi, adina mina rema yaku ago niokuyo, “Na beika tau vanu reyaka mina na nioteimaro.” ");
INSERT INTO kqc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ye Samaria vene yaku ina rofu desi usa niyadi ina venesa ameyainedi, ma meda remanu ameyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kamini besa amiye tau gade mokena vari gira aeyadi ini ago dada. ");
INSERT INTO kqc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mina rema rofu yomakai niyadi, “Una bi mokena vari gira aeyafa, idu diya ya beika niyo dada; idu gua uniye neide mama resi diba niyafa rama iniye mina bi kono tora noibanu di moi vegu rina amiye.” ");
INSERT INTO kqc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Meda remanu koina niyori, bi Galilee urana boyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Adina Iesu iniye niokuyo, “Ini rautu vene yaku Sei di ago nido amiye kikifa de rededi.” ");
INSERT INTO kqc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ye Galilee okiyori, Galilee vene yaku faiva niyadi, adina bi Jerusalem irakunari bosi ini beika tau vanu reyo mina veyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ye dudusa Cana taoni Galilee gaganiri dairiyo; minari bi sena koru moi kero resi waini riyo. Ma mironari Capernaum ri bi ourefeidena amiye yokoi kaere ini mida gauka varegamo. ");
INSERT INTO kqc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mina amiye neideyo Iesu bi Judea gutuna Galilee ri okiyo. Mina neidegasa bosi usa niyo ini mida, kaere bi muyena tumusa, desi moi buni riyainedi. ");
INSERT INTO kqc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ma niyo, “Ya vene bi rebe ma mokena vegu vegedi vonisi mamo, bi mokena vari gira aegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ye ourefeidena amiye yaku niyo, “Varika amiye, ya bi evade de baegiyari, bi nai mida muyego.” ");
INSERT INTO kqc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Iesu yaku nikabai reyo, “Di, yi mida bi vegu nigo!” Mina amiye yaku ini ago nisi mokena vari gira aesi diyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ye idama bogamori, ini moimai rei tavoi rededi vene baku resi ina nioteimaradi ini mida bi vegu niyo. ");
INSERT INTO kqc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ye ina yaku nikaiteyo beika meda nemoko ramari ini mida buni niyo, ma ina vene yaku niyadi, “Ini roaita vaki vaki rena bi agiya meda nemoko yokoi uriyenauri fereyo.” ");
INSERT INTO kqc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ye baba yaku diba niyo bi Iesu yaku mina meda nemoko ramari ina rofu niyo, “Yi mida bi vegu nigo.” Ye ini yava vene tau noibanu ma iniyesa mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mina bi rebe uru remanu niyo mini Judea feresi Galilee ri baeyori. ");
INSERT INTO kqc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mina usi Jew vene yaku irakuna yokoi reyadi ma Iesu bi Jerusalem ri boyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ri mamoe di ida vena atafuri bi koru moka yokoi ini maravata 5 nufa; Hebrew agori ini roka bi Bethesda. ");
INSERT INTO kqc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Minari bi gauka vene tau gade—ne taufa vene, yuka no vene ma dibo anua vene. ");
INSERT INTO kqc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mironari bi amiye yokoi kaere bi lagani 38 gauka reyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu yaku mina amiye varegamo vegasa diba niyo ina bi ari doba tora makai varegamo. Ye nikaiteyo, “Ya ura reisa buni nigiya ba?” ");
INSERT INTO kqc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma nikabai reyo, “Varika amiye, koru kita redori, koruri na moi nena amiye bi koina, ma dadi negi reidari, amiye yokoi bi sena ina ya siko na ebu resi nedo.” ");
INSERT INTO kqc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kamini ina rofu niyo, “Dadisi yi ekama vanau moisi nana re.” ");
INSERT INTO kqc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ye minari maka buni nisi ini ekama moisi nana reyo. Mina bi Sabati medari ogau niyo, ");
INSERT INTO kqc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ye Jew vene yaku mina moi buni riyo amiye rofu niyadi, “Gua bi Sabati meda, ma ago gira dudu yi ekama uakaigi bi tabu.” ");
INSERT INTO kqc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Idu nikabai reyo, “Amiye kaere na moi buni riyo yaku yi ekama moisi nana re na niyo.” ");
INSERT INTO kqc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ye nikaiteyadi, “Kaere amiye yaku makai reyainedi ya niyo?” ");
INSERT INTO kqc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Idu mina buni niyo amiye bi ina toto mina amiye bi kaere, ini adina Iesu bi minari amededi amiye tau gade fogori forovai reyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mina usi Sei nivakena yavari baku resi niyo, “Neide, ya bi buni niyo; besa vegu no ga re, de bi beika yokoi no iniye ya rofu vata nigo baebu.” ");
INSERT INTO kqc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kamini mina amiye disi Jew vene nioteimaro ina bi Iesu kaere yaku moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mina resi Jew vene yaku Iesu esika esika maradi, bi Sabati medari mina vegu reyo dada. ");
INSERT INTO kqc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Idu ina vene rofu niyo, “Nai Baba bi gua toga mina medari moimai redo, ma na ka moimai reida.” ");
INSERT INTO kqc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jew vene bi besa umuyegika maina regamadi mina ago dada, adina Sabati meda di ago gira ukero vau reyo maka de, idu ka nigamo Sei bi ini Baba ma mina ago yaku ina bi Sei sa moi yokoi maka riyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mina resi Iesu yaku niyo, “Rama iniye ya nida: Mida yaku inike beika yokoi de rego; ini Baba yaku beika redo, mina vesi maka redo. Adina beika Baba yaku redo bi Mida ka makai redo. ");
INSERT INTO kqc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Adina Baba yaku ini Mida uka masi ini beika tau gade inike redo mina oteimado. Ina yaku ka beika tora tora reyainedi oteimago, ye ya vene tururu regedi dada. ");
INSERT INTO kqc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Baba yaku muyena edadisi ini vegu mado kana, Mida ka ini ura dudu kaere vegu mago vo nido bi mado. ");
INSERT INTO kqc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ye Baba ka amiye yokoi de kota redo, idu mina kota rena vava bi ini Mida maro, ");
INSERT INTO kqc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ye amiye tau gade ini Mida kikifa regedi, Baba rofu rededi kana. Amiye kaere ini Mida kikifa de redo, bi Baba kaere nifeideyo ina ka kikifa de redo. ");
INSERT INTO kqc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Rama iniye ya nida: kaere nai ago neidesi na nifeideyo amiye rofu mokena vari gira aego, bi toga toga ameibobina vegu baku rego. Bi kota de rego, idu bi muyena feresi vegu rofu orefaro. ");
INSERT INTO kqc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rama iniye ya nida: meda nemoko baego; rama bi sena okiyo—muyena vene yaku Sei di mida di goroka neidegedi, ye kaere neidededi bi vegu nigedi. ");
INSERT INTO kqc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ye Baba iniye bi vegu di adina kana, makai ini Mida ka bi vegu di adina risi ");
INSERT INTO kqc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kota regi di vava maro, bi Amiye di mida dada. ");
INSERT INTO kqc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mina rofu tururu ga refa, adina ini meda nemoko baego, guri aeyadi muyena vene tau gade yaku ini goroka neidesi ");
INSERT INTO kqc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ini guri gutuna dadi rae regediri: kaere vegu buni reyadi vene bi dadisi veguri amegedi, ma kaere vegu no reyadi vene bi dadigedi ma kota regedi. ");
INSERT INTO kqc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na kaya di vava dudu bi beika yokoi de regida; Sei yaku beika na nido kana makai kota reida, ye nai kota rena bi rama, ini adina na yaku beika regi reida bi na kaya di ura regika de, idu kaere yaku na nifeideyo di ura dudu maka. ");
INSERT INTO kqc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na beika reida mina na kaya maka niokugida vonisi, mina beika nida bi ini rama de nufa. ");
INSERT INTO kqc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Idu amiye yokoi yaku na beika reida rofu niokudo, ma na diba ina yaku na dada beika nido bi rama. ");
INSERT INTO kqc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ya vene yaku John rofu ago moi feideyadi ma ago rama niokuyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Idu na beika reida di niogau rena ago bi diya amiye rofu, idu ya vene moi vegu riyainedi rofu mina ago nida. ");
INSERT INTO kqc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John bi ramefa kana, vaigasa vabara nigamo, ma ari tumu maka ini vabarari ada regi ura reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nai niogau rena ago yaku John di ago ebu reyo. Adina mina vegu regida di Baba yaku na maro, mina reida ma mina niogau rededi, Baba bi na nifeideyo dada. ");
INSERT INTO kqc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Baba, kaere na nifeideyo, yaku ka na fafau niokuyo. Ini goroka toga de neidesi ini seira ka toga de veyadi. ");
INSERT INTO kqc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma ini ago ka yi uka ideri amena de redo, ini adina nifeideyo amiye rofu mokena vari gira de aededi. ");
INSERT INTO kqc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sei di ago vei mama rededi, ya mokededi bi minari toga toga ameibobina vegu baku regedi dada. Ma mina ago maka yaku na fafau niokudedi! ");
INSERT INTO kqc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Idu vegu moigika na rofu baena bi ura de rededi. ");
INSERT INTO kqc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na bi amiye gutuna nai roka moi odoro rina bi maina de reida. ");
INSERT INTO kqc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Idu na na diba yi ukari Sei rofu uka mana de rededi. ");
INSERT INTO kqc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na bi nai Baba di roka di vava dudu deyaka, idu ya bi de na moiyadi; idu amiye bi iniye di roka di vava dudu soka regori, bi moigedi. ");
INSERT INTO kqc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ya bi ya kaya roka moi odoro rina ura rededi, idu ya bi Sei yokoi maka yaku yi roka moi odoro rina bi de maina rededi; makai ye gokai ida dudu na rofu mokena vari gira aegedi? ");
INSERT INTO kqc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ga mokefo na yaku nai Baba di nemokori ya tourage regida. Moses, kaere ina rofu uka mokena aeyadi, ina yaku ya tourage rego. ");
INSERT INTO kqc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ya Moses rofu mokena vari gira aeyagadu vonisi, bi na rofu mokena vari gira aeyaidu, ini adina bi na dada bura reyo. ");
INSERT INTO kqc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Idu beika bura reyo rofu mokena vari gira de aeyadiri, ye gokai ida dudu nai ago rofu mokena vari gira aegedi?” ");
INSERT INTO kqc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mina usi Iesu bi Galilee gagani Tiberias moka daidai tora berou eta rofu boyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma amiye tau gade usi bogamadi, adina mokena vegu gauka rofu moi buni rigamo mina veyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iesu omunari bosi ini usi dina venesa ameinu reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ye Jew vene di Ferei ebu rena irakuna di meda bi negau niyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu yaku ini ne moi odoro resi amiye tau gade gade ina rofu baegamadi vegasa Philip rofu nikaiteyo, “Una bi goidu beredi voi regifa ma mina amiye yaku iriyaganedi?” ");
INSERT INTO kqc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Makai niyo bi ebene regika, adina ina bi diba beika rego bi.) ");
INSERT INTO kqc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip yaku nikabai reyo, “Siriva fore 200 dudu beredi voi regifa vonisi, bi keika maka moigedi ka egere de nigo.” ");
INSERT INTO kqc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ini usi dina amiye yokoi roka Andrew, kaere bi Simon Peter di dubuini, yaku niyo, ");
INSERT INTO kqc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mida keika yokoi minari bi barley beredi 5 ma oyena remanu nufa, idu mina bi una egere de nigo, amiye bi tau gade gade dada.” ");
INSERT INTO kqc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu yaku niyo, “Amiye nifo kumo ameinu reyaganedi.” Mirona sanari bi oruma tora gade. Mina dada ameinu reyadi vene bi rumana 5,000 kana. ");
INSERT INTO kqc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mina dada beredi moisi Sei rofu buni tora gade masi konori ameinu rena vene yokoi yokoi rofu rau reyo. Oyena ka makai reyo, ina ura reyadi kana. ");
INSERT INTO kqc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ye ini uka bere niyadiri, ini usi dina vene rofu niyo, “Fereyadi iruku tuta moi egogo refo kumo keika yokoi moi no ga renadi.” ");
INSERT INTO kqc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mina dada barley beredi 5 ri irisi fereyadi tuta butu resi foroka 12 moi vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amiye ini rebe reyo mina vesi niyadi, “Rama mina bi Sei di ago nido amiye kaere kono tora noibanuri okigo bi mini!” ");
INSERT INTO kqc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ye Iesu ina diba niyo bi yeiva dudu ina rofu baesi moi kini rigedi, ye dudusa inaike omunari boyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma uriyenau niyori, ini usi dina vene moka daidai torari nesi ");
INSERT INTO kqc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bouti yokoi keu risi berou eta rofu Capernaum urana ugai boi neyadi. Mukuna niyo, idu Iesu bi ina vene rofu okina de reyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma aura tora keriya fui resi moka daidai tora moi tafo tafo reyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ye kilometre 5 o 6 kana doba fayo reyadi ma Iesu moka daidai tora fafau nana regamo ma veyadi. Bouti adinari baegamori, bi ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Idu ina vene rofu niyo, “Na mini; ori ga refa!” ");
INSERT INTO kqc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mina dada boutiri ada dudu moi keu reyadi, ye bouti berou konori dina rofu bi evade maka mina sanari okiyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ari uveyori amiye tau gade moka daidai tora di berou eta rofu amesi diba niyadi bi bouti yokoi maka ma Iesu bi ini usi dina venesa keu de reyo, idu ini usi dina vene iniye maka diyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tiberias gutuna bouti be bi Varika amiye buni tora gade Sei rofu maro ma ini beredi iriyadi sana atafuri utae riyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mina dada amiye tau gade veyadi bi Iesu ma ini usi dina vene minari bi de amegamadi, ye bouti keu resi maina regi Capernaum rofu diyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Koru moka tora di berou eta rofu baku resi nikaiteyadi, “Oteimana amiye, ya bi minari goivaka baeyo?” ");
INSERT INTO kqc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu yaku ina vene rofu nikabai reyo, “Rama iniye ya nida: ya na maina rededi, diya nai rebe veyadi dada, idu beredi irisi uka bere niyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","No nigo iruku rofu moimai ga rebifa, idu toga toga vegu ameibobigo iruku rofu moimai rebifa. Amiye di mida yaku mina ya vene rofu mago, adina Baba Sei yaku sena auba reyo.” ");
INSERT INTO kqc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kamini nikaiteyadi, “Una yaku Sei di moimai regi bi beika regifa?” ");
INSERT INTO kqc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma nikabai reyo, “Mina bi Sei di moimai: ini nifeideyo amiye rofu mokena vari gira aebigedi dada.” ");
INSERT INTO kqc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ye nikaiteyadi, “Ye ya bi beika rebe regiya ma vesi ya rofu mokena vari gira aegifa? Ya bi beika moimai regiya? ");
INSERT INTO kqc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Uni tutubena yaku gagani autu sanari manna irigamadi, bura reyo kana, ‘Ina yaku oma gutuna irigedi beredi maro.’” ");
INSERT INTO kqc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kamini Iesu ina vene rofu niyo, “Rama iniye ya nida, bi diya Moses kaere bi omari beredi ya maro, idu nai Baba yaku omari gutuna beredi rama ya mado. ");
INSERT INTO kqc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Adina Sei di beredi bi kaere oma gutuna desi kono tora noibanu vene vegu mado.” ");
INSERT INTO kqc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma niyadi, “Amiye tora, mina beredi bi toga una mabi.” ");
INSERT INTO kqc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ye niyo, “Na bi vegu di beredi; amiye kaere na rofu baego bi rauna de rego, ma kaere na rofu mokena vari gira aego bi toga koru de vaigo. ");
INSERT INTO kqc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Idu ya rofu niyaka ya bi sena na veyadi, idu mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nai Baba yaku na maro vene tau vakoi bi na rofu baegedi, ma na rofu baegedi vene bi de meki regida de iniye. ");
INSERT INTO kqc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Adina omari gutuna soka rei deyaka bi diya na kaya nai ura regika, idu kaere na nifeideyo amiye ini ura regika. ");
INSERT INTO kqc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma kaere na nifeideyo amiye di ura bi yomini: na maro vene tau vakoi bi yokoi moi boiyo de regida, idu ari metonari mina vene tau vakoi bi moi edadigida dada. ");
INSERT INTO kqc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Adina nai Baba di ura bi yomini: ini Mida vegasa mokena vari gira aegedi vene tau vakoi bi toga toga ameibobina vegu moigedi, ma na yaku ka ari metonari moi edadigida.” ");
INSERT INTO kqc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ye Jew vene yaku ina rofu mumugu nigamadi, di ini adina niyo, “Na bi omari gutuna deyo beredi.” ");
INSERT INTO kqc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ka niyadi, “Mina bi Iesu, Joseph di mida de ba? Ini nono ma baba una una diba. Ma gokai resi gua nido, ‘Na bi omari gutuna deyaka’?” ");
INSERT INTO kqc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu ina vene rofu niyo, “Ya kaya dudu makai mumugu ga nifa. ");
INSERT INTO kqc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nai Baba na nifeideyo amiye bi amiye yokoi moi rutu resi na rofu mago vonisi, bi na rofu baego, ye ari metonari moi edadigida. ");
INSERT INTO kqc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sei di ago niyadi vene bura reyadi, ‘Sei yaku ina tau vakoi oteimago.’ Nai Baba di ago neidesi diba niyadi vene tau gade bi na rofu baegedi. ");
INSERT INTO kqc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Amiye yokoi yaku Baba vena kode, idu Sei gutuna deyo amiye yaku maka sena veyo. ");
INSERT INTO kqc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rama iniye ya nida: amiye kaere mokena vari gira na rofu aego bi toga toga ameibobina vegu moigo. ");
INSERT INTO kqc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na bi vegu di beredi. ");
INSERT INTO kqc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yi tutubena vene yaku gagani autu sanari manna irisi muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Idu omari gutuna deyo beredi bi makai: ye amiye yokoi irigo bi de muyego. ");
INSERT INTO kqc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na bi mina omari gutuna deyaka vegu amedo beredi. Amiye yokoi yaku mina beredi irigo vonisi, bi toga toga ameibobigo. Ma kono tora noibanu di vene di vegu rofu magida beredi bi nai roaita.” ");
INSERT INTO kqc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kamini Jew vene bi iniye iniye rofu kayamo regasa niyadi, “Mina amiye di roaita bi gokai una rofu mago ma irigifa?” ");
INSERT INTO kqc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ye Iesu yaku niyo, “Rama iniye ya nida: Amiye di mida di roaita ma ini dava de irigedi vonisi, vegu bi ya vene ideri de amebigo. ");
INSERT INTO kqc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Amiye kaere nai roaita ma nai dava irigo bi toga toga ameibobina vegu moigo, ma ari metonari moi edadigida. ");
INSERT INTO kqc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Adina nai roaita bi iruku rama ma nai dava ka bi irina koru rama. ");
INSERT INTO kqc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kaere nai roaita ma nai dava irigo amiye bi nasa amebigo, ma na ka inasa amebigida. ");
INSERT INTO kqc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Vegu amedo Baba yaku na nifeideyo kana, ma ina dada vegu ameida, ye kaere na irigo amiye ka na dada vegu amego. ");
INSERT INTO kqc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Omari gutuna deyo beredi bi mini; yi tutubena vene yaku irigamadi kana de. Irisi muyeyadi. Idu kaere mina beredi irigo bi toga toga ameibobigo.” ");
INSERT INTO kqc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu Capernaum ri usa usa yavari oteimagasa mina ago nigamo. ");
INSERT INTO kqc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ini usi dina vene tau mina ago neidesi niyadi, “Mina ago bi gira iniye; kaere yaku neidego?” ");
INSERT INTO kqc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Idu Iesu ini ukari diba niyo ini ago rofu mumugu nigamadi, dada niyo, “Mina yaku yi mokena moi toe rido ba? ");
INSERT INTO kqc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Idu Amiye di mida sena ameyo sanari dairi bogo mina vesi bi beika mokegedi? ");
INSERT INTO kqc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sei di Vima bi vegu mado; roaita di vava bi de iniye iniye. Ago ya rofu niyaka bi Vima ma vegu di. ");
INSERT INTO kqc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Idu ya vene be bi mokena vari gira de aededi.” (Adina bi senagi diba niyo kaere bi mokena vari gira aena de, ma kaere yaku siri rego.) ");
INSERT INTO kqc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Resi niyo, “Mina resi ya rofu niyaka nai Baba yaku maka vava mago vonisi, amiye bi na rofu baegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mina usi ini usi dina vene tau ina gedu masi inasa gogo de digamadi. ");
INSERT INTO kqc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mina dada amiye 12 rofu nikaiteyo, “Ya vene feresi digi ka ura rededi ba?” ");
INSERT INTO kqc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter yaku nikabai reyo, “Varika amiye, una bi kaere rofu digifa? Toga toga ameibobina vegu di ago bi yasa amedo. ");
INSERT INTO kqc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Una bi mokena vari gira aesi una diba ya bi Sei di amiye kikifa.” ");
INSERT INTO kqc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma nikabai reyo, “Na bi ya 12 auba reyaka, idu ya yokoi bi bodaka niyo!” ");
INSERT INTO kqc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mina bi Simon Iscariot di mida, Judas kaere yaku siri rego fafau ago niyo. Ina ka bi ini amiye 12 yokoi. ");
INSERT INTO kqc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mina usi Iesu Galilee ri diga boga regamo. Judea gagani rofu nena bi ura de reyo, adina Jew vene yaku umuyegika maina regamadi. ");
INSERT INTO kqc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jew vene Karaga di irakuna di meda bi atafu niyori, ");
INSERT INTO kqc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesu ini dubuiyaka yaku niyadi, “Mina sana feresi Judea rofu bo, ye yi usi dina vene yaku ka yi beika reisa mina veyagane. ");
INSERT INTO kqc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Adina amiye yokoi kaere ina ura redo iniye moi ogau rigo vonisi, bi suiri moimai de redo. Ya bi makai regiya, ye kono vene tora noibanu rofu ya kaya moi ogau ri!” ");
INSERT INTO kqc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Adina ini dubuiyaka ka ina rofu mokena vari gira de aegamadi.) ");
INSERT INTO kqc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kamini Iesu yaku niyo, “Nai meda rama bi okina kode, idu yi meda bi toga mini. ");
INSERT INTO kqc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kono tora noibanu vene bi ya gubuyo de regedi, idu na rofu bi gubuyo rededi, adina na yaku ini beika rededi vegu niokuda bi no dada. ");
INSERT INTO kqc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Irakuna sanari bofa. Na bi mina irakuna sanari de bogida, adina nai meda rama bi okina kode dada.” ");
INSERT INTO kqc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Makai nisi Galilee ri ameyo. ");
INSERT INTO kqc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Idu gabi ini dubuiyakasa irakuna sanari bogamadiri, erau de niyo, idu kiki dudu maka boyo. ");
INSERT INTO kqc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Irakuna sanari Jew vene yaku maina regasa nikaiteyadi, “Ina bi goini?” ");
INSERT INTO kqc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma amiye di fogori ina dada mumugu nigamadi. Bedakai yaku nigamadi, “Ina bi amiye buni,” idu bedakai yaku nikabai regamadi, “Ide, ina bi amiye ourefeidei no redo.” ");
INSERT INTO kqc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jew vene rofu ori reyadi, ye amiye yokoi yaku ina dada ago de niokugamo. ");
INSERT INTO kqc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iesu yaku irakuna utari Sei nivakena yava ideri bosi amiye oteimagi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mina resi Jew vene tururu resi niyadi, “Mina amiye bi sikuru de reyo, idu gokai resi makai diba moiyo?” ");
INSERT INTO kqc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ye nikabai reyo, “Beika oteimaida bi diya naike nai oteimana, idu na nifeideyo amiye di. ");
INSERT INTO kqc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kaere amiye Sei di ura rena kana rego vonisi, bi diba nigo mina ago oteimaida bi Sei rofu dedo, o na kaya nai vava dudu sina nida. ");
INSERT INTO kqc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amiye kaere ini vava dudu ago nigo iniye ini roka moi odoro rigi redo, idu kaere yaku ina nifeideyo amiye di moi odoro rigi redo bi rama amiye, ma ini uka ideri bi ofa yokoi de amedo. ");
INSERT INTO kqc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses yaku ago gira ya maro ba? Idu ya yokoi yaku mina ago gira de neidedo. Beika resi ya na umuyegika na maina rededi?” ");
INSERT INTO kqc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Amiye tau gade yaku nikabai reyadi, “Ya bi vima nosa! Kaere yaku ya umuyegika ya maina redo?” ");
INSERT INTO kqc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma nikabai reyo, “Na bi reremama yokoi reyakari, ya tau vakoi bi tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mina resi Moses yaku ago maro yi mida di roaita nugaraine. (Rama mina bi diya Moses rofu, idu yi tutubena vene rofu soka reyadi.) Kamini Sabati medari mida yokoi ini roaita nugadedi. ");
INSERT INTO kqc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sabati medari mida di roaita nugagori, bi Moses di ago gira de odego; ye beika resi ya na rofu gubuyo rededi, adina na yaku Sabati medari amiye yokoi moi buni riyaka? ");
INSERT INTO kqc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Etofarori bi ga mokei no refa, idu rama dudu nirorotari refa.” ");
INSERT INTO kqc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mina dada Jerusalem vene be yaku niyadi, “Mina amiye umuyegika maina rededi bi mini? ");
INSERT INTO kqc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Vefo! Ariarari ago nido ma ina rofu ago yokoi de nidedi! Ourefeidena vene bi diba niyadi ina bi Keriso bi rama ba ide? ");
INSERT INTO kqc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Idu Keriso degori, amiye yokoi diba de nigo ina bi goina rofu. Ma mina amiye goina gutuna soka reyo bi una una diba.” ");
INSERT INTO kqc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mina dada Iesu Sei nivakena yavari oteimagasa niogau regamo, “Ya ya diba na ma na goina rofu ka ya diba. Idu na bi nai vava dudu de deyaka. Amiye kaere na nifeideyo bi rama, ma ya bi ina ya toto. ");
INSERT INTO kqc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na bi ina diba, adina ina gutuna deyaka ma na nifeideyo.” ");
INSERT INTO kqc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ye moi gira regika maina reyadi, idu amiye yokoi ini vana dudu avaka de moiyo, adina ini meda bi okina kode dada. ");
INSERT INTO kqc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Idu amiye tau gade mina egogo reyadiri, ina rofu mokena vari gira aesi niyadi, “Keriso soka regasa besa rebe rego, mina amiye yaku redo kana ba ide?” ");
INSERT INTO kqc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amiye tau gade yaku Iesu rofu mumugu nigamadi ma Pharisee vene mina ago neideyadi, ye Sei ma amiye utari naivo vene di varika venesa iya rededi vene nifeideyadi moi gira reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ye Iesu niyo, “Na yasa bi de amei doba regida; gabi kaere na nifeideyo amiye rofu dairi digida. ");
INSERT INTO kqc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na maina regedi, idu baku de regedi, ma nai ameida sanari bi digi anua regedi.” ");
INSERT INTO kqc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ye Jew vene iniye iniye nikaiteyadi, “Mina amiye bi goidu digika redo ma de baku regifa? Ini mokena bi Greek vene di gagani uni amiye amededi sanari disi Greek vene oteimago ba? ");
INSERT INTO kqc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mina ago nidori, ini adina bi beika, ‘Na maina regedi, idu baku de regedi,’ ma ‘Nai ameida sanari bi digi anua regedi’?” ");
INSERT INTO kqc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Irakuna metona meda isivagari, Iesu dadi are resi raka niyo, “Kaere bi koru vaido bi na rofu baesi koru gaga re. ");
INSERT INTO kqc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kaere na rofu mokena vari gira aego, Sei di agori nido kana, ‘Vegu amedo koru ini uka meko gutuna koru kana rausi rei baego.’” ");
INSERT INTO kqc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Idu kaere ina rofu mokena vari gira aeyadi, bi Vima moigedi. Resi mina rofu ago niyo, adina mina ituari Vima bi mana kode, Iesu bi ini roka moi odoro rina kode dada. ");
INSERT INTO kqc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amiye tau gade fogori bedakai yaku mina ago niyo neidesi niyadi, “Rama iniye mina amiye bi Sei di ago nido amiye!” ");
INSERT INTO kqc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bedakai yaku nigamadi, “Mina bi Keriso!” Idu bedakai yaku nigamadi, “Rama iniye Keriso bi Galilee rofu de baego! ");
INSERT INTO kqc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sei di ago yaku nido Keriso bi David di tutubena ma Bethlehem ri vata nigo, David di amegamo rauturi.” ");
INSERT INTO kqc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mina dada amiye okuyadi ina dada. ");
INSERT INTO kqc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Be yaku ina moi gira regi ura reyadi, idu yokoi yaku ini vana dudu de avaka moiyadi. ");
INSERT INTO kqc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kamini iya rena vene yaku Sei ma amiye utari naivo vene di varika vene ma Pharisee vene rofu baeyadiri, nikaiteyadi, “Beika resi afei baena de reyadi?” ");
INSERT INTO kqc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma nikabai reyadi, “Amiye yokoi yaku ina kana de ago nido!” ");
INSERT INTO kqc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma Pharisee vene yaku nikaiteyadi, “Ye ya vene rofu ka ofa niyo ba? ");
INSERT INTO kqc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ourefeidena vene be o Pharisee vene be yaku ina rofu mokena vari gira aeyadi ba de? ");
INSERT INTO kqc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Idu mina amiye tau gade bi Moses di ago gira ina toto, ye Sei yaku kiraini nigo!” ");
INSERT INTO kqc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ini amiye yokoi, roka Nicodemus, kaere sena Iesu rofu boyo, ina vene rofu ago niyo, ");
INSERT INTO kqc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Uni ago gira dada amiye yokoi kota rena koderi, bi ini ago di rama neidesi beika reyo baku rena kumo.” ");
INSERT INTO kqc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma nikabai reyadi, “Ya ka Galilee rofu baeyo ba? Ya kaya Sei di agori vei mona refa Sei di ago nido amiye yokoi Galilee ri de baego.”  ");
INSERT INTO kqc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ma ina yokoi yokoi ini rautu neineiri diyadi. ");
INSERT INTO kqc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Idu Iesu maka Olive yabo omuna ikari boyo. ");
INSERT INTO kqc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uriyaku ari uveyori, dairisi Sei nivakena yavari boi neyo. Amiye tau gade ina rofu boyadi ma ameinu resi oteimagamo. ");
INSERT INTO kqc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ago gira oteimana vene ma Pharisee vene yaku rema yokoi afei dui reyadi, kaere bi koa reyo ma veitao reyadi. Amiye fogori moi are resi ");
INSERT INTO kqc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ina rofu niyadi, “Oteimana amiye, mina rema bi koa rena vegu reyo ma veitao reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ye Moses di ago gira yaku una nido bi mina kana rema fore dudu umuyegifa; ye ya bi beika be nigiya?” ");
INSERT INTO kqc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Idu mina niyadi bi ini uka maina rena nivegika, ye vegu no be rego vonisi bi nitourage regedi. Ma Iesu kuri agu risi ini vana ebuna dudu konori bura regamo. ");
INSERT INTO kqc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma toga nikaite regamadiri, dadisi are resi ina vene rofu niyo, “Ya kaere amiye yokoi vegu no de nufa vonisi, bi ya yaku siko mina rema rofu fore moisi youfa.” ");
INSERT INTO kqc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dudusa kuri agu risi konori bura regamo. ");
INSERT INTO kqc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Idu mina ago neidegasa tora vene siko, yokoi yokoi ferei di vau reyadi. Iesu maka inike fereyadi ma mina rema ini nemokori are regamo. ");
INSERT INTO kqc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma dadi are resi mina rema rofu niyo, “Rema e, mina amiye tau bi goini? Amiye yokoi ya nifafana de reyadi ba?” ");
INSERT INTO kqc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma nikabai reyo, “Varika amiye, amiye yokoi de.” Ma niyo, “Na ka ya nifafana de regida; disi besa vegu no ga re.” ");
INSERT INTO kqc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu dudusa ina vene rofu ago niyo, “Na bi kono tora noibanu di vabara. Amiye kaere na usi baego bi mukunari de digo, idu vegu di vabara moigo.” ");
INSERT INTO kqc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ye Pharisee vene yaku ina rofu niyadi, “Ya kaya niokusa; yi niokuna ago bi rama de.” ");
INSERT INTO kqc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Idu nikabai reyo, “Na na kaya niokugida vonisi, nai niokuna ago bi rama, adina na na diba goidu deyaka ma goidu digida. Idu ya ya toto na goidu deyaka o goidu digida. ");
INSERT INTO kqc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ya bi amiye di mokena kana kota rededi; na bi amiye yokoi kota de reida. ");
INSERT INTO kqc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Idu na yaku kota regida vonisi, nai kota rena bi rama, adina bi na naike maka de, idu nai Baba kaere na nifeideyo bi nasa kota regifa. ");
INSERT INTO kqc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yi ago girari yomakai bura reyadi amiye remanu yaku ago yokoi maka dudu niokugedi, ini beika nigedi bi rama. ");
INSERT INTO kqc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na kaya niokuda, ma nai Baba kaere na nifeideyo ka na fafau niokudo.” ");
INSERT INTO kqc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ye nikaiteyadi, “Yi baba bi goini?” Ma nikabai reyo, “Nai Baba ma na bi ya ya toto; idu ya bi na diba niyagadu vonisi, nai Baba ka diba niyaidu.” ");
INSERT INTO kqc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sei nivakena yava ideri amiye oteimagasa fore aena daiyuturi mina ago nigamo. Idu amiye yokoi yaku moi gira de reyo, adina ini meda bi okina kode dada. ");
INSERT INTO kqc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mina dada dudusa niyo, “Na bi ya ferei digida; na maina resi yi vegu no dudu ya kaya muyegedi. Nai digida sanari bi digi anua regedi.” ");
INSERT INTO kqc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ye Jew vene yaku niyadi, “Ina yaku nido, ‘Nai dina sana bi ya dina anua regedi.’ Mina resi bi iniye umuyego ba?” ");
INSERT INTO kqc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma ina rofu niyo, “Ya bi kono egona rofu baeyadi, idu na bi odoro deyaka. Ya bi mina kono tora noibanu rofu di vene, idu na bi diya mina kono tora noibanu rofu. ");
INSERT INTO kqc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mina dada ya niyaka bi yi vegu no dudu muyegedi. Adina Na bi Na, ye mina rofu mokena vari gira de aegedi vonisi, bi yi vegu no dudu muyegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ye nikaiteyadi, “Ya bi kaere?” Ma niyo, “Mina bi senagi ya nioteimaraka. ");
INSERT INTO kqc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na bi ya vene dada ago tau nisi yi vegu tau dada nifafana regida; idu na nifeideyo amiye bi rama, ma ini ago neideyaka mina kono tora noibanu vene rofu nioteimaida.” ");
INSERT INTO kqc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ini Baba fafau nigamo, idu diba de niyadi. ");
INSERT INTO kqc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ye ina vene rofu niyo, “Amiye di mida moi odoro rigasa diba nigedi mina bi na ma naike nai vava dudu yokoi de reida, idu nai Baba na oteimaro kana dudu sina nida. ");
INSERT INTO kqc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma kaere na nifeideyo amiye bi nasa mini; na ferei tavoi de reyo, adina beika ini uka moi ada redo, mina bi toga reida.” ");
INSERT INTO kqc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Makai sina niyori, amiye tau ina rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ye Iesu yaku Jew vene kaere ina rofu mokena vari gira aeyadi bi niyo, “Nai ago moi gira rigedi vonisi, ya bi rama nai usi dina vene; ");
INSERT INTO kqc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ago rama diba nigedi ma ago rama yaku ya erufugo.” ");
INSERT INTO kqc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma nikabai reyadi, “Una bi Abraham di tutubena vene, ma toga amiye yokoi rofu moimai rei tavoi de reyafa. Ye gokai nisa, ‘Ya erufugo’?” ");
INSERT INTO kqc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma nikabai reyo, “Rama iniye ya nida: amiye tau gade, kaere vegu no rededi, bi vegu no di moimai rei tavoi rededi vene. ");
INSERT INTO kqc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Moimai rei tavoi redo amiye bi toga toga yavari de amego, idu mida bi toga toga minari amebigo. ");
INSERT INTO kqc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mina dada, Mida yaku ya erufugo vonisi, bi ya erufuna iniye rego. ");
INSERT INTO kqc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na diba ya bi Abraham di tutubena vene, idu ya na umuyegi maina rededi, adina nai ago yi uka ideri bi de. ");
INSERT INTO kqc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Beika nai Babasa veyafa bi mina ago nida, idu ya bi beika yi baba rofu neideyadi mina rededi.” ");
INSERT INTO kqc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kamini nikabai reyadi, “Uni baba bi Abraham.” Ma niyo, “Ya bi Abraham di mida vonisi, bi ini reremama regamo kana mina rebiyagadu. ");
INSERT INTO kqc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Idu gua na umuyegika maina rededi—ago rama Sei rofu neideyaka, mina maka bi ya rofu oteimagamaka mini. Abraham yaku makai de reyo! ");
INSERT INTO kqc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yi baba yaku regamo mina rededi.” Kamini niyadi, “Una bi diya mena de rema di mida mida; uni Baba yokoi maka bi Sei.” ");
INSERT INTO kqc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma niyo, “Sei bi yi Baba vonisi, bi na rofu uka maragadu, adina na Sei rofu deyaka ma gua na mini. Naike nai vava dudu soka de reyaka, idu na nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Beika resi na beika ago nida bi diba de nidedi? Mina di adina bi nai ago neidena rofu anua rededi. ");
INSERT INTO kqc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ya bi yi baba Bodaka di mida mida, ma yi ura rededi bi yi baba di ura rena usi dibigedi. Ini adinari gutuna bi amiye umuyegamo amiye. Ina bi ago rama moi gira de rido, adina ini ideri ago rama bi koina. Ofa nigasa ini beika rei baedo tu dudu redo, iniye ini mokena nido, adina bi ofa ofa nina amiye ma ofa nina di madini. ");
INSERT INTO kqc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Idu ago rama nida dada ya na rofu mokena vari gira de aededi. ");
INSERT INTO kqc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ya kaere na rofu vegu no yokoi baku reyo? Na bi ago rama nida vonisi, beika resi ya vene na rofu mokena vari gira de aededi? ");
INSERT INTO kqc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kaere bi Sei di amiye bi Sei di ago neidedo; ya bi de neidededi, adina ya bi Sei di vene de dada.” ");
INSERT INTO kqc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ye Jew vene yaku nikaiteyadi, “Una rama nisifa ya bi Samaria amiye ma vima no bi yasa!” ");
INSERT INTO kqc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma Iesu yaku nikabai reyo, “Vima no yokoi bi nasa de; nai Baba rofu moi odoro rida, idu ya bi na rofu moi odoro de ridedi. ");
INSERT INTO kqc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Idu na kaya nai roka moi odoro rina de maina reida, idu yokoi kaere yaku na moi odoro regi maina redo ma na rofu kota rego. ");
INSERT INTO kqc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rama iniye ya nida: amiye yokoi nai ago neidesi anema yora nigo vonisi, bi toga de muyego.” ");
INSERT INTO kqc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma nikabai reyadi, “Gua una diba vima no bi yasa! Abraham muyeyo, ma Sei di ago niyadi vene ka muyeyadi, idu ya nisa, ‘Amiye yokoi nai ago neidesi anema yora nigo vonisi, bi toga de muyego.’ ");
INSERT INTO kqc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham uni baba kaere muyeyo bi tora; ye ya bi tora iniye ba? Ma Sei di ago niyadi vene kaere ka muyeyadi ya bi ebu reisa ba? Ya mokeisa ya bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kamini nikabai reyo, “Na kaya nai roka moi odoro rigida vonisi, bi de iniye iniye. Nai roka moi odoro rido amiye bi nai Baba, kaere bi yi Sei vo nidedi mini. ");
INSERT INTO kqc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ya toto ina, idu na na diba ina. Na toto ina vo nigida vonisi, bi ya vene kana ofa ofa nina amiye nibiyagadu. Idu na diba ina, ma ini ago neidesi anema yora reida. ");
INSERT INTO kqc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yi baba Abraham nai degida meda mina ne rei bogasa ada reyo. Vesi ada regamo.” ");
INSERT INTO kqc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ye niyadi, “Ya bi lagani 50 moina kode—ma Abraham veyo ba?” ");
INSERT INTO kqc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma nikabai reyo, “Rama iniye ya nida, Abraham vata nina koderi, ‘Na bi’.” ");
INSERT INTO kqc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ye fore moisi Iesu rofu yougika reyadi, idu iniye moi sui risi Sei nivakena yava ferei yaku diyo. ");
INSERT INTO kqc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu bogasa ne taufa vata niyo amiye veyo ");
INSERT INTO kqc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ma ini usi dina vene yaku nikaiteyadi, “Oteimana amiye, kaere yaku vegu no reyo, adina ne taufa vata niyo, mina amiye ba ini nono baba?” ");
INSERT INTO kqc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma nikabai reyo, “Diya mina amiye o ini nono baba vegu no reyadi dada, idu Sei di reremama rena ina fafau vei mama riyaganedi dada. ");
INSERT INTO kqc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ariu bi na nifeideyo amiye di moimai rebigifa; uru baebigo ma amiye yokoi kamini moimai de rego. ");
INSERT INTO kqc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na bi konori amegasa bi kono tora noibanu di vabara.” ");
INSERT INTO kqc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mina nisi konori ayaka su resi ayaka koru dudu dikina risi ne taufa amiye di nemokori dikina ifi resi ");
INSERT INTO kqc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ina rofu niyo, “Siloam koru sofukori bosi yi nemoko koite.” (Ini roka di adina bi “Nifeideyo”.) Kamini nesi ini nemoko koiteyori, bi nemoko areyadi ma vegasa dairi baeyo. ");
INSERT INTO kqc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ina atafu amededi vene ma kaere sena vegamadi bi usa usa nigamo nikaiteyadi, “Mina amiye yaku amegasa usa usa nigamo bi mini ba?” ");
INSERT INTO kqc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bedakai yaku niyadi, “Mina bi ina maka,” idu be yaku niyadi, “Diya ina mada; ini ne uruma bi ina kana maka.” Ye mina amiye iniye niyo, “Na bi mina amiye mini.” ");
INSERT INTO kqc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma nikaiteyadi, “Gokai ida dudu yi nemoko areyadi?” ");
INSERT INTO kqc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kamini nikabai reyo, “Amiye roka Iesu yaku dikina risi nai nemoko ifi resi na rofu niyo, ‘Siloam koruri nesi koite,’ vo niyo. Ye nesi koiteyakari, nai nemoko areyadi.” ");
INSERT INTO kqc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma nikaiteyadi, “Mina amiye bi goini?” Ma nikabai reyo, “Na toto.” ");
INSERT INTO kqc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kamini mina sena ne taufa amiye Pharisee vene rofu afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ye Iesu yaku dikina risi ini nemoko moi buni riyo bi Sabati meda. ");
INSERT INTO kqc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kamini Pharisee vene dudusa nikaiteyadi gokai ida dudu nene reyo. Ma niyo, “Ina yaku nai nemoko dikina dudu ifi reyo ma koiteyakari, gua nene reida mini.” ");
INSERT INTO kqc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mina dada Pharisee bedakai yaku niyadi, “Mina amiye bi Sei rofu deyo amiye de, Sabati meda di ago gira de moi gira rido dada.” Idu bedakai yaku niyadi, “Gokai resi bi vegu no rena amiye yaku makai mokena vegu redo?” Mina dada iniye iniye gubuyo resi okuyadi. ");
INSERT INTO kqc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ye dudusa ne taufa amiye nikaiteyadi, “Mina amiye yi nemoko moi buni riyo rofu bi beika vo nisa?” Ma niyo, “Ina bi Sei di ago nido amiye.” ");
INSERT INTO kqc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ye Jew vene bi sena ne taufa amiye nisi gua nene reyo di ago rofu mokena vari gira de aeyadi, ini nono baba raka nisi ");
INSERT INTO kqc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","nikaiteyadi, “Mina bi yi mida ba? Ya nidedi bi ne taufa vata niyo, idu gokai ida dudu gua nene redo?” ");
INSERT INTO kqc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma nikabai reyadi, “Una diba mina bi uni mida ma ne taufa vata niyo. ");
INSERT INTO kqc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Idu gua ini nemoko gokai dudu nene redo o kaere yaku ini nemoko moi buni riyo bi una una toto. Nikaitefa; ina bi amiye tora niyo. Ina kaya ya nioteimaraine!” ");
INSERT INTO kqc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Ini nono baba yaku makai niyadi, adina bi Jew vene rofu ori reyadi. Adina bi sena yo niyadi amiye yokoi yaku nigo Iesu bi Keriso vonisi, bi usa usa yava gutuna umeki rei makugedi.) ");
INSERT INTO kqc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mina dada ini nono baba yaku niyadi, “Ina bi amiye tora niyo; ina nikaitefa.” ");
INSERT INTO kqc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ye uru remanu dudusa ne taufa vata niyo amiye rofu raka nisi niyadi, “Sei di roka moi odoro ri. Una una diba mina amiye bi vegu no redo amiye.” ");
INSERT INTO kqc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma nikabai reyo, “Na na toto ina bi vegu no redo amiye o de, idu mina maka na diba: bi ne taufa vata niyaka ma gua nene reida.” ");
INSERT INTO kqc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma nikaiteyadi, “Ya rofu beika reyo? Gokai dudu yi nemoko moi buni riyo?” ");
INSERT INTO kqc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma nikabai reyo, “Na bi sena ya oteimaraka, idu de neideyadi. Beika resi dudusa neidegedi vo nidedi? Ye ya ka ini usi dina vene nigi ura rededi ba?” ");
INSERT INTO kqc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kamini ina rofu ago no nigasa niyadi, “Ya bi ini usi dina amiye, idu una bi Moses di usi dina vene. ");
INSERT INTO kqc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Una una diba Sei bi Moses rofu ago niyo, idu mina amiye bi una una toto goina gutuna baeyo!” ");
INSERT INTO kqc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma nikabai reyo, “Na bi tururu reyaka! Ya ya toto goina rofu baeyo, idu nai nemoko moi areyo. ");
INSERT INTO kqc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Una una diba Sei bi vegu no rededi vene di ago neidena de redo, idu amiye yokoi Sei nivakesi ini ura regi rego vonisi, Sei bi ini ago neidego. ");
INSERT INTO kqc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ini adinari gutuna baeyo gua mamo kono tora noibanuri, amiye yokoi yaku ne taufa vata nina amiye moi buni riyo mina toga neidena de resifa. ");
INSERT INTO kqc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mina amiye bi Sei rofu de deyo vonisi, bi vegu yokoi maka regi anua rego.” ");
INSERT INTO kqc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kamini nikabai reyadi, “Ya vegu no tausa vata niyo, idu una oteimagika reisa ba?” Ye ina usa usa yava rofu umeki rei makuyadi. ");
INSERT INTO kqc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu yaku neideyo bi umeki rei yakuyadi ma baku resi nikaiteyo, “Amiye di mida rofu mokena vari gira aesa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma nikabai reyo, “Varika amiye, ina bi kaere? Ye ina rofu mokena vari gira aegida.” ");
INSERT INTO kqc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma niyo, “Ya bi sena veyo, ma ina bi amiye kaere gua yasa ago nido mini.” ");
INSERT INTO kqc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma niyo, “Varika amiye, mokena vari gira aeda!” Ye nivakeyo. ");
INSERT INTO kqc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma niyo, “Na kota regika mina kono tora noibanuri soka reyaka, ye kaere de vededi bi veyaganedi, ma kaere vededi vene bi ne taufa nigedi.” ");
INSERT INTO kqc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisee vene bedakai ina atafuri bi mina ago neidesi nikaiteyadi, “Una ka bi ne taufa nisifa vene ba?” ");
INSERT INTO kqc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma niyo, “Ya bi ne taufa vonisi, ya bi vegu no de vene niyagadu, idu ya gua nidedi, ‘Vesifa,’ ye yi vegu no bi toga amededi.” ");
INSERT INTO kqc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Rama iniye ya nida: kaere amiye yaku mamoe di buru rina ida vena ideri dui de rego, idu ida yokoi rofu firu rigo, bi duma duma ma moi tavoi amiye. ");
INSERT INTO kqc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Idu ida vena dui rego amiye bi mamoe dogo redo amiye. ");
INSERT INTO kqc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ida vena nari rena amiye yaku ina rofu ida vena ekego. Mamoe ini goroka neidegedi ma ini roka raka nisi etofaro moi yakusi ourefeidego. ");
INSERT INTO kqc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ini mamoe tau vakoi etofaro moi yakugasa ourei bogo ma usi digedi, ini goroka ina diba dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Idu amiye idana bi usi de digedi, idu ori digedi, adina mina amiye di goroka neide mama de rededi dada.” ");
INSERT INTO kqc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu yaku mina mokena ago ina vene rofu niyo, idu beika nigamo bi de moiyadi. ");
INSERT INTO kqc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mina dada Iesu dudusa niyo, “Rama iniye ya nida: na bi mamoe di ida vena. ");
INSERT INTO kqc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tau gade kaere ouresi okiyadi bi duma duma ma moi tavoi vene, mamoe yaku ini ago neidena de reyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na bi ida vena. Amiye na rofu baego vonisi, bi moi vegu rigida ma bae dui resi yakusi oruma iri-iri sana baku rego. ");
INSERT INTO kqc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Duma duma redo amiye ini baedo bi duma duma resi amiye umuyesi beika baika moi no regika maka. Idu na yaku okiyaka bi vegu buni moiyaganedi—ma mina vegu buni bi tora noibanu moiyaganedi. ");
INSERT INTO kqc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na bi mamoe dogo reida amiye buni, kaere bi ini mamoe dada muyegi nai vegu magida. ");
INSERT INTO kqc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Fore rofu moimai redo amiye bi mamoe dogo de redo amiye, mamoe di adina de. Mina dada sufa gadeva auna baegori, bi vesi mamoe feresi ori digo. Makai regori, mina sufa di gadeva auna yaku mamoe aki resi moi urafo rego. ");
INSERT INTO kqc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mina moimai redo amiye ori digo bi fore rofu moimai redo amiye ma mamoe mokei tora de rego dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Na bi mamoe dogo reida amiye buni; nai mamoe bi na diba ma nai mamoe ka ina diba na. ");
INSERT INTO kqc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mina kana, nai Baba ina diba na ma na diba nai Baba, ma nai mamoe dada muyegi nai vegu magida. ");
INSERT INTO kqc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma nai mamoe bedakai bi mina buru rina sanari amena de rededi. Ina ka moi dui rei bogida ma nai goroka neidegedi. Ye yokoi maka nigedi ini mamoe dogo redo amiye yokoi makasa. ");
INSERT INTO kqc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mina dada, nai Baba yaku na uka mado, adina muyegi nai vegu magida gabi dudusa moi dairigida dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amiye yokoi yaku nai vegu na rofu moina de rego, idu na kaya nai ura dudu magida. Na bi nai vava nufa muyesi dudusa moi dairigida. Mina ago gira bi nai Baba na rofu niyo ma moiyaka.” ");
INSERT INTO kqc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jew vene dudusa iniye iniye gubuyo resi utama okuyadi mina ago dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ina vene tau yaku niyadi, “Ina bi vima no nufa ma ada forovai reyo! Beika resi ini ago neidededi?” ");
INSERT INTO kqc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Idu bedakai yaku niyadi, “Amiye yokoi vima no nufa bi mina kana ago nina de rego! Gokai dudu vima no yaku ne taufa amiye moi buni rigo?” ");
INSERT INTO kqc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mina medari Sei nivakena yava nimana irakuna bi Jerusalem ri ogau niyo. Bi ava di medari, ");
INSERT INTO kqc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ma Iesu bi Sei nivakena yavari Solomon di maravata ideri nana digamo. ");
INSERT INTO kqc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ye Jew vene egogo resi dai buru risi nikaiteyadi, “Una bi ya dada mokena moigasa amei baesifa, ye goivaka medari ya yaku una nigiya? Ya bi rama Keriso ba de? Una ni mona re.” ");
INSERT INTO kqc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma nikabai reyo, “Na bi sena ya nioteimaraka, idu ya bi na rofu mokena vari gira de aeyadi. Nai Baba di roka dudu reremama reida bi na fafau niogau rededi. ");
INSERT INTO kqc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Idu ya yaku na rofu mokena vari gira de aededi, adina ya bi diya nai mamoe dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nai mamoe bi nai goroka neidededi; na ina vene diba ma na usi didedi. ");
INSERT INTO kqc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Toga toga ameibobina vegu maida ma toga de muyegedi, ye yokoi yaku nai vana gutuna de moi yakugo. ");
INSERT INTO kqc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nai Baba, kaere ina vene na maro, di yeiva bi isivaga tora iniye ma tau gade di yeiva ebu redo. ");
INSERT INTO kqc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nai Baba nasa bi yokoi maka.” ");
INSERT INTO kqc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kamini Jew vene dudusa ugika fore moiyadi. ");
INSERT INTO kqc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Iesu niyo, “Reremama buni buni nai Baba gutuna ya oteimaraka, idu goina dada fore dudu na ugi regedi?” ");
INSERT INTO kqc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma nikabai reyadi, “Una bi mina reremama buni reyo dada fore dudu de ya ugi resifa, idu Sei di roka moi no riyo dada! Adina ya bi amiye maka, idu ya kaya moi Sei vo nisa dada!” ");
INSERT INTO kqc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ma nikabai reyo, “Yi ago girari bura reyadi bi yomakai, ‘Ya bi sei vene, vo niyaka.’ ");
INSERT INTO kqc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ye Sei yaku ina vene, kaere ini ago maro, bi ina rofu bi sei vene vo niyo. Ma Sei di ago odegi anua rego. ");
INSERT INTO kqc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nai Baba na abidi resi konori na nifeideyo. Idu niyadi, ‘Ya yaku Sei di roka moi no riyo,’ adina ‘Na bi Sei di mida,’ vo niyaka dada. ");
INSERT INTO kqc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nai Baba di reremama de reida vonisi, bi na rofu mokena vari gira ga aefa. ");
INSERT INTO kqc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Idu mina regida ma mokena vari gira na rofu de aegedi vonisi, bi nai reremama rena maka rofu mokena vari gira aefo. Mina resi diba nigedi nai Baba bi na ideri ma na ka bi ina ideri.” ");
INSERT INTO kqc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mina dada dudusa moi gira regika reyadi, idu ini vanari ori diyo. ");
INSERT INTO kqc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ye dudusa Jordan koru ugasi berou eta rofu John sena amiye babatiso regamo sanari bosi ameyo. ");
INSERT INTO kqc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma amiye tau ina rofu baesi niyadi, “John bi mokena vegu yokoi de reyo, idu ini ago tau gade mina amiye rofu nigamo bi rama.” ");
INSERT INTO kqc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ye mirona sanari amiye tau bi ina rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mina medari amiye yokoi roka Lazarus bi gauka reyo. Ina bi Bethany rofu amiye, Mary ma ini rasini Martha di rautu. ");
INSERT INTO kqc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mina Mary, kaere ini tobaini Lazarus bi gauka vareyo, bi Varika amiye fafau sisika buni diga rausi resi ini ada iye dudu ini yuka moi ugaro.) ");
INSERT INTO kqc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ye uba rasini yaku ago nifeideyadi: “Varika amiye, yi ura reisa amiye bi gauka reyo.” ");
INSERT INTO kqc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma mina neidesi niyo, “Mina gauka dudu de muyego; bi Sei di vabara moi ogau rigi, ye makai dudu ka Sei di mida ini roka moi odoro rigo.” ");
INSERT INTO kqc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ye Iesu yaku Martha ma ini rasini ma Lazarus uka magamo. ");
INSERT INTO kqc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mina resi Lazarus bi gauka varegamo mina neidesi amegamo sanari meda remanu besa ameyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Resi ini usi dina vene rofu niyo, “Judea rofu dairi nenadi.” ");
INSERT INTO kqc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma niyadi, “Oteimana amiye, Jew vene yaku ruika fore dudu ya ugika reyadi; ma ya mironari dairisi negika reisa ba?” ");
INSERT INTO kqc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma nikabai reyo, “Meda nemoko 12 bi meda yokoi di ari vabara ba ide? Kaere ariu dibo redo amiye bi abouna de rego, adina mina kono tora noibanu di vabara vedo dada. ");
INSERT INTO kqc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Idu amiye yokoi bi urusari dibo rego vonisi, bi abougo, adina inasa vabara koina.” ");
INSERT INTO kqc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mina niyo usi ka niyo, “Uni dubuini Lazarus bi raudai resi varedo, idu na yaku mironari bosi moi edadigida.” ");
INSERT INTO kqc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mina dada nikabai reyadi, “Varika amiye, varedo vonisi, buni nigo.” ");
INSERT INTO kqc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Idu bi Lazarus muyeyo dada nigamo, adina ina vene yaku mokeyadi bi neota varedo mina niyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mina dada ni mona resi niyo, “Lazarus bi muyeyo, ");
INSERT INTO kqc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ma ya vene dada na bi ada reida na bi mironari de, mina ye mokena vari gira aeyaganedi. Ye ina rofu nenadi.” ");
INSERT INTO kqc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ye Thomas (Kakafasina vo nidedi) ini usi dina raraga vene rofu niyo, “Una ka inasa bosi muyenadi!” ");
INSERT INTO kqc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu okisi neideyo Lazarus bi sena guri aeyadi meda 4 niyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany bi Jerusalem atafu; ini maike bi kilometre regode kana. ");
INSERT INTO kqc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jew vene tau bi Martha ma Mary ini tobaini muyena uka moi amuta regika okiyadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ye Martha yaku Iesu baeyo neidesi yakusi baku regika neyo, idu Mary bi yavari ameyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ye Martha niyo, “Varika amiye, ya minari ameyagadu vonisi, nai tobaini bi muyena de reyagadu! ");
INSERT INTO kqc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Idu gua na na diba beika Sei rofu usa nigiya bi ya mago.” ");
INSERT INTO kqc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma niyo, “Yi tobaini bi dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ye nikabai reyo, “Na na diba mina ari bae koina nigo dadi rae rena medari bi dudusa dadi rae rego.” ");
INSERT INTO kqc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma niyo, “Na bi dadi rae rena ma vegu ameibobina. Kaere amiye na rofu mokena vari gira aego, bi muyego, idu vegu amebigo; ");
INSERT INTO kqc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma amiye tau gade amegasa na rofu mokena vari gira aegedi, bi toga de muyegedi. Mina rofu mokena vari gira aesa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma niyo, “Yo, Varika amiye; ya bi Keriso, Sei di mida, kaere bi konori dego, mina rofu mokena vari gira aeda.” ");
INSERT INTO kqc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha makai niyo, usi dairi nesi ini rasini Mary raka nisi sui dudu niyo, “Oteimana amiye bi mini; ma ya nikaitegasa nido.” ");
INSERT INTO kqc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma mina neideyori, evade maka dadisi ina rofu neyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Iesu bi rautu dui rena kode, idu Martha ya baku reyo sanari toga amegamo.) ");
INSERT INTO kqc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jew vene kaere yava ideri Mary di uka moi amuta regamadi, bi gokai evade maka dadisi yaku neyo, mina vegasa bi usi neyadi, adina mokeyadi bi guri sanari isaka nigi nedo. ");
INSERT INTO kqc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ye Mary yaku Iesu ameyo sanari nesi vegasa ini yuka adinari raudai resi niyo, “Varika amiye, ya minari ameyagadu vonisi, nai tobaini bi de muyeyagadu!” ");
INSERT INTO kqc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ye isaka isaka niyo ma Jew vene kaere inasa deyadi ka isaka nigamadi, mina vegasa bi ini uka ideri vima yaku maruo resi esika resi ");
INSERT INTO kqc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","nikaiteyo, “Goinari aeyadi?” Ma nikabai reyadi, “Varika amiye, baesi ve.” ");
INSERT INTO kqc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ye isaka niyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma Jew vene yaku niyadi, “Va vefa gokai ina uka maro!” ");
INSERT INTO kqc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Idu bedakai yaku niyadi, “Ina yaku ne taufa amiye di ne moi areyo, idu mina amiye di muyena ka kebi rigi anua reyaidu ba?” ");
INSERT INTO kqc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ye Iesu dudusa ini uka ideri vima maruo resi guri sanari bae okiyo. Mina bi avana; ini ida vena bi fore dudu biri riyadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kamini niyo, “Mina fore moi etagae rifa.” Ma Martha, muyena amiye di tobaini, yaku niyo, “Idu Varika amiye, mina kana medari bi sau no iniye, ini muyena bi meda 4 koina niyo dada!” ");
INSERT INTO kqc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma niyo, “Na sena ya niyaka mokena vari gira aeyagadu vonisi, bi Sei di vabara veyaidu.” ");
INSERT INTO kqc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ye fore moi etagae riyadi ma Iesu ne odoro risi niyo, “Baba, na buni tora gade ya maida adina ya na neideyo. ");
INSERT INTO kqc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na na diba ya toga na neideisa, idu minari are rededi vene di buni dada nida, ye ya yaku na nifeideyo mina rofu mokena vari gira aegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Makai nisi goroka tora dudu raka niyo, “Lazarus, yaku bae!” ");
INSERT INTO kqc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Muyeyo amiye yaku baeyo; ini vana ma ini yuka bi varuka yaku tete risi ini ne uruma bi muyena sogona yaku fafa riyadi. Ma Iesu yaku ina vene rofu niyo, “Ini roaitari sogona bi youne mafo kumo diyaine.” ");
INSERT INTO kqc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mina dada Jew vene tau, kaere Mary sa deyadi, bi Iesu yaku beika reyo vesi ina rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Idu bedakai yaku Pharisee vene rofu nesi Iesu yaku beika reyo mina nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ye Sei ma amiye utari naivo vene di varika vene ma Pharisee vene yaku kanisoro vene raka niegogo resi nikaiteyadi, “Beika regifa? Adina mina amiye bi rebe tau moi evata rido! ");
INSERT INTO kqc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Makai feregifa vonisi, bi amiye tau noibanu ina rofu mokena vari gira aegedi ma Rome vene yaku baesi uni Sei nivakena yava ma uni gagani moi no regedi!” ");
INSERT INTO kqc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Idu yokoi, ini roka Caiaphas, kaere mina laganiri bi Sei ma amiye utari naivo amiye tora, yaku niyo, “Ya bi beika yokoi ya toto mada! ");
INSERT INTO kqc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ya mokei mona refa buni iniye bi yokoi maka yaku amiye rofu muyego, de bi amiye tau noibanu no baku regifa baebu.” ");
INSERT INTO kqc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mina bi ini diba dudu de niyo, idu mina laganiri Sei ma amiye utari naivo amiye tora kana Sei di ago niyo bi Iesu bi Jew vene noibanu dada muyego; ");
INSERT INTO kqc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","mirona vene dada maka de, idu Sei di mida mida gagani gaganiri rerevaida niyadi ka egogo resi moi yokoi maka rigo. ");
INSERT INTO kqc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ye mina ituari mamo Iesu umuyegika nidodi reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mina dada Iesu toga ariarari Jew vene di utari nana de digamo, idu minari feresi gagani autu sana atafuri, taoni roka Ephraim rofu diyo ma mironari ini usi dina venesa amegamadi. ");
INSERT INTO kqc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mina ituari Jew vene di Ferei ebu rena irakuna bi bae atafu niyo, dada amiye tau ini rautu feresi Jerusalem boyadi Ferei ebu rena irakuna koderi, iniye moi ruaka rigika. ");
INSERT INTO kqc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Resi Iesu maina resi Sei nivakena yavari are regasa iniye iniye nikaitegamadi, “Ya gokai mokeisa? Bi irakunari okigo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Adina Sei ma amiye utari naivo vene di varika vene ma Pharisee vene yaku ago gira maradi amiye yokoi Iesu goinari veitao rego vonisi, bi ina vene nioteimaraine, moi gira reyagane dada. ");
INSERT INTO kqc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Meda 6 koderi bi Ferei ebu rena irakuna, ye Iesu bi Bethany ri okiyo, Lazarus ini amedo rautu, kaere bi muyena gutuna edadiyo. ");
INSERT INTO kqc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma mironari bi uriyenau iruku feide maradi; Martha bi iruku dabara regamo ma Lazarus ma ina vene ka Iesu sa ameinu resi iruku irigamadi. ");
INSERT INTO kqc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kamini Mary yaku diga roka nard di sisika buni litre yokoi maka di afona kana moi boyo. Diga bi fore tora gade dudu voi rededi. Ye Iesu di yuka odoro erausi resi ini ada iye dudu moi ifi regamo. Ma ini sisika buni yaku yava fono reyo. ");
INSERT INTO kqc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ye ini usi dina amiye yokoi roka Judas Iscariot—kaere gabi siri rego—yaku niyo, ");
INSERT INTO kqc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Beika resi mina diga di sisika buni bi siriva fore 300 dudu sero resi fore bi irava vene rofu de maro?” ");
INSERT INTO kqc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas makai niyo bi irava vene dogo redo dada bi de niyo, idu ina bi duma amiye dada. Bi fore dura dogo rena amiye, ye mina beika ideri aegamadi moigasa irigamo. ");
INSERT INTO kqc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mina dada Iesu niyo, “Mina rema ferefa, adina mina diga bi inasa amego bogo na guri aegedi medari mamo. ");
INSERT INTO kqc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Adina irava vene bi toga yasa amebigedi, idu na bi toga yasa de amebigida.” ");
INSERT INTO kqc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye Jew vene tau gade Iesu bi Bethany ri okiyori mina neidegasa Iesu rofu maka bi de, idu Lazarus ka vegika okiyadi, kaere bi muyena gutuna moi edadiyo. ");
INSERT INTO kqc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma Sei ma amiye utari naivo vene di varika vene yaku Lazarus ka umuyegika nidodi reyadi, ");
INSERT INTO kqc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ina dada Jew vene tau boi nesi Iesu rofu mokena vari gira aeyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Meda yokoi uveyori, amiye tau tora irakunari okisi neideyadi Iesu bi Jerusalem urana baedo. ");
INSERT INTO kqc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Resi vatoru iye moisi baku regika nesi raka niyadi, “Sei di roka moi odoro ri! Sei yaku buni tora gade maro, kaere bi Varika amiye di rokari baedo; mina bi Israel di kini!” ");
INSERT INTO kqc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ma Iesu donkey mida baku resi keu reyo, bura reyo kana, ");
INSERT INTO kqc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion di vefa, ori ga re! Ve kumo yi kini baegasa donkey mida fafau keu rido.” ");
INSERT INTO kqc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ouresi ini usi dina vene mina tau diba de niyadi. Idu Iesu dadi rae resi vabara moiyori, bi mokeyadi beika tau ina rofu bura reyadi ma beika tau ina rofu reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu sa amegamadi Lazarus guri ideri raka nisi muyena gutuna edadiyo ma veyadi vene tau gade yaku toga niokugamadi. ");
INSERT INTO kqc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mina dada amiye tau gade Iesu baku regika neyadi—mina rebe reyo neideyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ye Pharisee vene yaku iniye iniye niyadi, “Vefa, una bi ruru rei kava resifa. Ye vefa gokai mina kono tora noibanu vene tau gade usi didedi!” ");
INSERT INTO kqc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Irakuna di medari Sei nivakegi Jerusalem ri boyadi vene di utari bi Greek vene bedakai. ");
INSERT INTO kqc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ye Philip, kaere bi Bethsaida rofu Galilee amiye, ina rofu baesi niyadi, “Amiye tora, una ura Iesu vegi resifa.” ");
INSERT INTO kqc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip nesi Andrew nioteimaro, ma vakoi Iesu rofu nesi nioteimaradi. ");
INSERT INTO kqc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ye nikabai reyo, “Amiye di mida di roka moi odoro rigo di meda bi okiyo mini. ");
INSERT INTO kqc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rama iniye ya nida: witi meko konori yaresi de muyego vonisi, bi meko yokoi makari kana amego. Idu muyego vonisi, bi ini meko tau gade rama nigedi. ");
INSERT INTO kqc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kaere ini vegu ura rego, bi de moigo, ma kaere mina konori ini vegu ura de rego, bi toga toga ameibobina vegu rofu moi gira rigo. ");
INSERT INTO kqc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Amiye yokoi na rofu naivo rego vonisi, bi na usi baeyaine; ma goina sanari amegida, ina ka amego. Amiye yokoi na rofu naivo rego vonisi, nai Baba yaku moi kikifa rego. ");
INSERT INTO kqc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Gua nai vima bi esika esika redo—ye beika nigida? ‘Baba, mina meda nemoko rofu na moi vegu rigiya’, vo nigida ba? Idu mina dada na bi mina meda nemoko rofu deyaka. ");
INSERT INTO kqc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba, yi roka moi odoro ri!” Ma goroka yokoi omari gutuna deyo, “Sena nai roka moi odoro riyaka, ma dudusa regida.” ");
INSERT INTO kqc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Minari amegamadi vene tau yaku mina neidesi niyadi bi ofu niyo, ma bedakai yaku niyadi, bi “Sei di naivo naivo vima ina rofu ago niyo!” ");
INSERT INTO kqc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kamini Iesu yaku niyo, “Mina goroka bi diya nai buni dada, idu ya vene yi buni dada. ");
INSERT INTO kqc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mina kono di kota rena meda bi gua mini; ye gua mina kono di ourefeidena amiye bi umeki rei feidego. ");
INSERT INTO kqc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma mina konori na moi odoro rigori, amiye tau noibanu na rofu afei baegida.” ");
INSERT INTO kqc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Makai niyo bi gokai ida dudu muyego ina rofu nioteimaro.) ");
INSERT INTO kqc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ye amiye tau gade yaku nikabai reyadi, “Ago girari neideyafa Keriso bi toga toga amebigo, ye ya gokai nisa Amiye di mida bi moi odoro riyagane? Mina Amiye di mida bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ye ina vene rofu niyo, “Mina vabara bi yasa de amei doba rego. Vabara yasa amedori, diga bogasa rebifa, de bi mukuna yaku ya ebu rego baebu. Kaere mukunari diga bogasa redo amiye goinari dido bi ina toto. ");
INSERT INTO kqc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vabara yasa amedori, ina rofu mokena vari gira aefa, ye ya bi vabara di mida mida nigedi dada.” Sina ni vau resi ferei disi ina vene rofu iniye moi sui riyo. ");
INSERT INTO kqc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gokai sena ini neri rebe tau regamo, idu ina vene bi toga mokena vari gira de aegamadi, ");
INSERT INTO kqc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ye Sei di ago niyo amiye Isaiah di ago bi moi rama aego dada: “Varika amiye, kaere yaku uni ago neidesi mokena vari gira aeyo? Ma kaere rofu Varika amiye di vava moi ogau riyo?” ");
INSERT INTO kqc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mina dada mokena vari gira de aeyadi, adina Isaiah dudusa niyo: ");
INSERT INTO kqc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Sei yaku ini nemoko moi taufa risi ini uka kebi riyo, ini nemoko dudu vesi ini uka dudu diba nisi na rofu kero regedi baebu, ma ina moi buni rigida.” ");
INSERT INTO kqc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah mina niyo, adina Iesu di vabara vesi ina fafau ago niyo. ");
INSERT INTO kqc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ye minari maka ourefeidena vene tau ka ina rofu mokena vari gira aeyadi, idu Pharisee vene ori reyadi dada, de niogau regamadi, bi usa usa yavari umeki regedi baebu. ");
INSERT INTO kqc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Adina amiye yaku ini roka moi odoro rina bi ura resi Sei yaku ini roka moi odoro rina bi ura de rededi. ");
INSERT INTO kqc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kamini Iesu yaku raka nigasa niyo, “Kaere na rofu mokena vari gira aego, bi diya na rofu maka de, idu rama na nifeideyo amiye rofu ka mokena vari gira aego. ");
INSERT INTO kqc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma kaere na vego, bi na nifeideyo amiye vego. ");
INSERT INTO kqc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na bi vabara kana mina konori deyaka, ye kaere na rofu mokena vari gira aego amiye bi mukunari ga amebiyaine. ");
INSERT INTO kqc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Amiye yokoi nai ago neidego, idu moi gira de rigo vonisi, na yaku ina rofu kota de regida; adina na bi kono tora noibanu di vene rofu kota regika de deyaka, idu moi vegu rigi deyaka. ");
INSERT INTO kqc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kaere na rofu gedu masi nai ago de neidego, bi kota rego; ari bae koina nigori, mina ago niyaka ina fafau kota rego! ");
INSERT INTO kqc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Adina na bi nai vava dudu de ago niyaka, idu nai Baba, kaere na nifeideyo, iniye yaku gokai nisi beika nigida di ago gira na maro. ");
INSERT INTO kqc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma na na diba ini ago gira bi toga toga ameibobina vegu. Mina dada beika ago nida, bi nai Baba yaku na niyo kana mina nigida.” ");
INSERT INTO kqc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ferei ebu rena irakuna okina koderi, Iesu diba niyo ini meda bi okiyo mina kono feresi ini Baba rofu bogi, ye metonari bi ini konori amededi vene uka maro. ");
INSERT INTO kqc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Uriyenau iruku irina koderi, Bodaka yaku Judas Iscariot, Simon di mida, di mokenari Iesu siri regi sena aeyo. ");
INSERT INTO kqc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ye Iesu bi diba niyo ini Baba yaku beika tau vakoi ini vava gabireri aeyo, ma bi Sei rofu deyo ma Sei rofu dairi bogo. ");
INSERT INTO kqc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Resi iruku iriyadi utari dadisi ini fafau varuka erufusi tauwera ini gagabari iru riyo. ");
INSERT INTO kqc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mina usi siuari koru rausi resi ini usi dina vene di yuka rafo koitegi, tauwera ini gagabari miyo mina dudu moi roko rigi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Peter rofu baeyori, ina rofu nikaiteyo, “Varika amiye, nai yuka rafo koitegiya ba?” ");
INSERT INTO kqc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma nikabai reyo, “Ya gua na yaku beika reida bi ya ya toto, idu gabi mamo diba nigiya.” ");
INSERT INTO kqc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kamini niyo, “Ide yo! Toga iniye nai yuka rafo bi koitena de regiya!” Ma nikabai reyo, “Yi yuka rafo de koitegida vonisi, ya bi diya nai.” ");
INSERT INTO kqc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ye niyo, “Varika amiye, nai yuka rafo maka de, idu nai vana ma nai ada ka koite!” ");
INSERT INTO kqc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma nikabai reyo, “Amiye kaere rafeyo bi ini yuka maka koitego; ini roaita tora noibanu bi ruaka. Ye ya vene bi ruaka, idu ya tau vakoi de.” ");
INSERT INTO kqc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Adina bi sena diba niyo kaere yaku siri rego; mina dada niyo, “Ya tau vakoi bi ruaka de.”) ");
INSERT INTO kqc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ini yuka rafo koitei vau resi ini fafau varuka risi ini amena sanari dairigasa nikaiteyo, “Ya rofu beika reyaka bi diba niyadi ba ide? ");
INSERT INTO kqc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ya yaku na rofu roka nidedi Oteimana amiye ma Varika amiye; mina bi rama rededi, adina na bi mini. ");
INSERT INTO kqc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Gua na, yi Varika amiye ma yi Oteimana amiye, yaku yi yuka rafo koiteyaka, ye ya kaya yi yuka rafo koiteyagadu. ");
INSERT INTO kqc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Adina na yaku ya gokai reyaganedi bi oteimaraka mini, ye ya ka regedi, ya rofu reyaka kana. ");
INSERT INTO kqc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rama iniye ya nida: moimai rei tavoi redo amiye ini varika amiye ebu rena de rego, ma nifeidena amiye ka nifeidedo amiye ebu rena de rego. ");
INSERT INTO kqc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mina beika tau diba nigedi vonisi, ye rebigediri buni tora gade ya mago! ");
INSERT INTO kqc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na bi diya ya vene tau vakoi rofu nida; kaere na yaku auba reyaka bi na na diba. Idu mina bi Sei di agori bura reyo ma moi rama aego: ‘Kaere nasa beredi iriyafa amiye yaku kero resi na gutuna etagae riyo.’ ");
INSERT INTO kqc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mina vata nina koderi gua ya nida, ye vata nigori ya vene yaku mokena vari gira aegedi ‘Na bi.’ ");
INSERT INTO kqc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rama iniye ya nida: kaere na nifeidego amiye moi dui rego, bi na moi dui rego; ma kaere na moi dui rego, bi na nifeideyo amiye moi dui rego.” ");
INSERT INTO kqc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mina niyo usi, ini uka bi esika resi niokuyo, “Rama iniye ya nida: ya yokoi yaku na siri rego.” ");
INSERT INTO kqc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ini usi dina vene iniye iniye veyadi, adina kaere rofu niyo bi de diba ni mona reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ini usi dina amiye yokoi, kaere Iesu yaku uka magamo, bi ina atafu ameinu regamo. ");
INSERT INTO kqc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ye Simon Peter ina rofu vana feko regasa niyo, “Nikaite kaere rofu niyo.” ");
INSERT INTO kqc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kamini mina usi dina amiye Iesu kokobari etebe risi nikaiteyo, “Varika amiye, ina bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma nikabai reyo, “Na yaku kaere rofu beredi bado siua ideri birisi magida amiye bi mini.” Mina dada beredi bado moisi siua ideri birisi Simon di mida Judas Iscariot maro. ");
INSERT INTO kqc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas beredi moiyo ma mina usi Satani ini ukari dui reyo. Ma Iesu yaku niyo, “Beika regiya, bi evade re!” ");
INSERT INTO kqc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Idu iruku irisi ameinu reyo amiye yokoi yaku beika resi makai ina rofu niyo bi diba de niyadi. ");
INSERT INTO kqc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas bi fore dogo regamo amiye dada, bedakai yaku mokegamadi Iesu bi niyo, “Irakuna di iruku uni voi re,” o beika yokoi be irava vene rofu marainedi. ");
INSERT INTO kqc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ye Judas mina beredi bado moigasa evade etofaro yakusi neyo ma bi sena mukuna niyo mini. ");
INSERT INTO kqc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Resi diyori, Iesu yaku niyo, “Gua Amiye di mida di roka moi odoro riyo ma ina dudu ka Sei di roka moi odoro riyo. ");
INSERT INTO kqc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sei di roka ina dudu moi odoro riyo vonisi, Sei yaku ka evade maka ina kaya dudu ini Mida di roka moi odoro rigo. ");
INSERT INTO kqc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nai mida mida, na yasa amei doba de regida. Na maina regedi, ma Jew vene nioteimaraka kana, ye gua ka ya nioteimaida mini: ‘Nai digida sanari bi digi anua regedi.’ ");
INSERT INTO kqc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ago gira ruaka ya vene rofu maida mini: ya kaya uka mabifa. Na yaku ya rofu uka maraka kana, makai ya kaya ka uka mabifa. ");
INSERT INTO kqc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ya kaya uka mabigediri, minari mamo amiye tau gade yaku diba nigedi ya bi nai usi dina vene.” ");
INSERT INTO kqc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter yaku niyo, “Varika amiye, ya bi goinari disa?” Ma nikabai reyo, “Nai goinari dida, gua na usi baegi anua regiya, idu gabi na usi baegiya mironi.” ");
INSERT INTO kqc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ma niyo, “Varika amiye, beika resi gua ya usi baegi anua regida? Ya dada nai vegu eyaregida!” ");
INSERT INTO kqc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma nikabai reyo, “Na dada yi vegu eyaregiya ba? Rama iniye ya nida: kokoro raka nina koderi, bi uru regode na nisui regiya. ");
INSERT INTO kqc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Yi uka moi esika ga refa. Sei rofu mokena vari gira aesi na rofu ka mokena vari gira aebifa. ");
INSERT INTO kqc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nai Baba di yavari daiyutu tau; na mironari amena sana yi dogo regika boida. Mina de vonisi, ya de niyagadu. ");
INSERT INTO kqc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ye bosi yi amena sana dogo regidari, usi bi dudusa dairi desi nasa ya afei bogida, ye na yaku goinari amegida sanari ya vene ka mironari amegedi. ");
INSERT INTO kqc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma na goinari boida sana di ida bi ya vene ya diba.” ");
INSERT INTO kqc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas yaku niyo, “Varika amiye, ya goinari digiya bi una una toto; ye gokai ida dudu ida diba nigifa?” ");
INSERT INTO kqc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma nikabai reyo, “Na bi ida, ma ago rama, ma vegu. Amiye yokoi nai Baba rofu de bogo, idu na dudu maka. ");
INSERT INTO kqc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Na diba nidediri, nai Baba ka diba nidedi. Gua mamo ina diba nisi ma veyadi.” ");
INSERT INTO kqc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip yaku niyo, “Varika amiye, Baba una oteima kumo uni uka bere nigifa.” ");
INSERT INTO kqc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma nikabai reyo: “Philip, yasa ari doba amei baegamaka idu toga ya toto ba? Kaere na veyo amiye bi nai Baba ka veyo. Gokai resi nisa, ‘Baba una oteima’? ");
INSERT INTO kqc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ya mokena vari gira aesa ba ide na bi nai Baba ideri ma nai Baba bi na ideri? Mina ago ya rofu nida bi diya nai vava dudu nida, idu nai Baba kaere na ideri amedo, ina yaku iniye ini moimai redo. ");
INSERT INTO kqc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nai Baba bi na ideri ma na bi nai Baba ideri mokena vari gira aebifa; o de bi, reremama reida rofu mokena vari gira aebifa. ");
INSERT INTO kqc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Rama iniye ya nida: kaere na rofu mokena vari gira aego amiye bi reremama na yaku reida kana ka rego—ye mina kana maka de, idu isivaga iniye, adina na bi nai Baba rofu bogida dada. ");
INSERT INTO kqc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Beika nai roka dudu usa usa nigedi bi regida, makai dudu na, ini Mida, yaku nai Baba di roka moi odoro rigida. ");
INSERT INTO kqc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nai roka dudu beika baika yokoi na rofu usa nigedi vonisi, bi regida. ");
INSERT INTO kqc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ya na uka madedi vonisi, nai ago gira bi neidegedi. ");
INSERT INTO kqc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma na yaku nai Baba usa nigida ma aedena amiye yokoi ya mago, kaere bi toga toga ya venesa amebigo. ");
INSERT INTO kqc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ina bi ago rama di Vima, ye kono tora noibanu di vene de moidedi, adina de vesi diba de nidedi. Idu ya ina diba nidedi, yasa amedo ma yasa ideri amebigo dada. ");
INSERT INTO kqc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na bi ya rofu degida; neuka kana de ya ferei tavoi regida. ");
INSERT INTO kqc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Doba de kono tora noibanu di vene yaku dudusa na vena de regedi, idu ya yaku bi na vegedi. Adina na vegu ameida kana, ya ka vegu ameibobigedi. ");
INSERT INTO kqc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mirona medari ya yaku diba nigedi na bi nai Baba ideri, ma ya bi na ideri ma na bi ya ideri. ");
INSERT INTO kqc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Kaere nai ago gira moisi neidedo, mina amiye bi na rofu uka mado. Ma kaere na rofu uka mado amiye, bi nai Baba yaku uka mago, ma na ka uka masi ina rofu na kaya niokugida.” ");
INSERT INTO kqc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ma Judas (Judas Iscariot de) yaku niyo, “Varika amiye, gokai resi ya ya kaya una rofu niokugiya, idu kono tora noibanu di vene rofu bi de?” ");
INSERT INTO kqc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma nikabai reyo, “Amiye yokoi na uka mado vonisi, bi nai ago neidego ma nai Baba yaku uka mago, ma ina rofu desi uni amena sana inasa rigifa. ");
INSERT INTO kqc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kaere na uka mana de redo amiye, bi nai ago de neidedo. Ye mina ago neidededi bi diya nai, idu nai Baba kaere na nifeideyo amiye di. ");
INSERT INTO kqc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ya venesa amegasa mina ago nigamaka. ");
INSERT INTO kqc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Idu yi aedena amiye Vima kikifa, kaere nai Baba yaku nai roka dudu nifeidego, yaku beika baika tau gade ya oteimasi beika tau gade ya niyaka, mina mokena ya moi mona rego. ");
INSERT INTO kqc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na yaku uka amuta yasa fereida; bi nai uka amuta ya maida. Mina ya maida bi mina kono vene yaku madedi kana de. Yi uka moi kenoka ga resi ori ga refa. ");
INSERT INTO kqc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya rofu niyaka, ‘Na bi disi gabi dairisi ya rofu degida’ ma neideyadi. Ya na rofu uka maragadu vonisi, ya bi ada reyagadu, adina nai Baba rofu bogida, bi isivaga iniye na kana de dada. ");
INSERT INTO kqc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ye vata nina koderi, gua ya nida mini, ye vata nigori, ya mokena vari gira aegedi. ");
INSERT INTO kqc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na bi yasa ago ni doba de regida, mina kono di ourefeidena amiye baedo dada. Ini vava na fafau bi koina iniye, ");
INSERT INTO kqc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","idu nai Baba ago gira na maro kana reida, ye kono tora noibanu di vene bi diba niyaganedi nai Baba uka maida. “Dadisi mina sana feresi dinadi. ");
INSERT INTO kqc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Na bi waini meko di yabo rama ma nai Baba bi muro amiye. ");
INSERT INTO kqc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ina yaku nai teteka neinei meko de moina bi moi tae rido; ma teteka neinei meko moina bi koroto redo, besa meko varego dada. ");
INSERT INTO kqc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ya bi sena moi ruaka riyo, ago ya rofu niyaka dada. ");
INSERT INTO kqc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nai ideri amefa, yi ideri ameida kana. Ye kai rena teteka waini meko di yabo ideri de amedo vonisi, bi inaike meko varegi anua rego, ma ya makai nai ideri de amegedi vonisi, ya bi vegu buni de regedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na bi waini meko di yabo ma ya bi ini teteka. Kaere nai ideri amego ma ini ideri amegida, bi meko tau varego, na gaima rofu bi beika yokoi regi anua regedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yokoi yaku nai ideri de amego vonisi, bi teteka you makugo ma abiye nigo kana; ye teteka moi egogo resi itari you negedi ma vaigedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Na ideri amegedi ma nai ago yi ideri amego vonisi, ya ura rededi kana usa usa nifa, ye ya rofu rego. ");
INSERT INTO kqc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ya vene meko tau moiyadi, ye nai usi dina vene niyadi vo niyo; mina makai nai Baba di roka moi odoro rigo. ");
INSERT INTO kqc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nai Baba uka na maro kana, ye uka ya maraka. Nai uka manari amefa. ");
INSERT INTO kqc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nai ago gira neidegedi vonisi, nai uka manari amegedi, nai Baba di ago gira neideyaka ma ini uka manari ameida kana. ");
INSERT INTO kqc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Na mina ya rofu niyaka ye nai ada yasa feregida ma ya ada ya muyegedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nai ago gira bi mini: ya kaya ya kaya uka mafa, ya uka maraka kana. ");
INSERT INTO kqc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Amiye yokoi di uka mana tora iniye bi mini: ini asiyaka rofu ini vegu eyaredo. ");
INSERT INTO kqc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ya beika ago gira nida mina neidegedi vonisi, bi nai asiyaka. ");
INSERT INTO kqc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na dudusa moimai rei tavoi rededi vene ya roka de nigida, adina moimai rei tavoi redo amiye bi beika ini varika amiye redo bi toto. Idu nai asiyaka bi ya roka niyaka, adina beika tau gade nai Baba rofu neideyaka, mina ya rofu nioteimaraka. ");
INSERT INTO kqc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ya na auba de reyadi, idu na yaku ya auba resi omaraka, ye disi meko varegedi, ma yi meko bi toga amebigo. Makai beika tau nai roka dudu nai Baba rofu usa nigedi, bi ya mago. ");
INSERT INTO kqc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mina ago gira ya maida bi mini: ye ya kaya ya kaya uka magedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kono tora noibanu di vene ya gubuyo rededi vonisi, ye vei mama refa, bi na rofu siko gubuyo reyadi dada, ya ka ya gubuyo regedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ya bi kono tora noibanu di vene vonisi, ini vene ya uka magedi iniye di kana; idu ya bi mina kono tora noibanu di vene de dada, ya kono tora noibanu gutuna ya raka niyaka. Mina dada kono tora noibanu di vene ya rofu gubuyo rededi. ");
INSERT INTO kqc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mina sina ya rofu niyaka mokefa: ‘Moimai rei tavoi redo amiye ini varika amiye ebu rena de redo.’ Na esika esika maradi kana, ya ka ya esika esika magedi. Nai ago neideyadi vonisi, bi yi ago ka neidegedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Idu nai roka dada mina tau vakoi ya fafau regedi, ye kaere na nifeideyo amiye ya toto dada. ");
INSERT INTO kqc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na baesi ina vene rofu de niyagadu vonisi, bi vegu no nufa de, idu gua ini vegu no rofu ago yokoi nigi anua regedi. ");
INSERT INTO kqc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kaere na rofu gubuyo redo, ka nai Baba rofu gubuyo redo. ");
INSERT INTO kqc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mina reremama amiye yokoi yaku de regamo, bi ini fogori de reyaka vonisi, bi vegu no nufa de; idu gua mina vesi na ma nai Baba una remanu rofu gubuyo reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Idu ago gira di sina bura reyo bi kamini moi rama aeyaine: ‘Ina vene na rofu gubuyo reyadi, vegu no yokoi de dada.’ ");
INSERT INTO kqc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Idu aedena amiye, ago rama di Vima, degori, kaere nai Baba gutuna nifeidegida, bi na niogau rego. ");
INSERT INTO kqc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma ya ka na niogau regedi, adina ini adinari gutuna nasa amegamadi. ");
INSERT INTO kqc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mina tau vakoi ya rofu niyaka, ye yi mokena vari gira aena rofu de futu regedi. ");
INSERT INTO kqc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Usa usa yava etofarori ya umeki regedi. Ye meda baego, ye kaere ya umuyego bi mokego ina bi Sei rofu naivo redo. ");
INSERT INTO kqc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ma mina regedi nai Baba ma na ina toto dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Idu mina ya rofu niyaka, ye ini meda baegori, ya mina rofu niyaka bi mina mokegedi. “Senagi mina de ya niyaka, na yasa dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Idu gua na bi kaere na nifeideyo amiye rofu digida, idu ya yokoi de nikaitedo, ‘Bi goidu disa?’ ");
INSERT INTO kqc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Idu iriyeduka yaku yi uka vata baeyo, mina ya rofu niyaka dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Idu rama ya nida: na ya rofu ferei digida bi buni, adina de digida vonisi, Aedena amiye ya rofu de dego. Idu digida vonisi, ya rofu nifeidegida. ");
INSERT INTO kqc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma baesi kono tora noibanu vene di ini mokena no, vegu no ma mokena rorobo dada, ma kota renari, bi no mina ina rofu oteimago. ");
INSERT INTO kqc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Adina mina bi vegu no dada, na rofu mokena vari gira de aededi; ");
INSERT INTO kqc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","mokena rorobo dada, nai Baba rofu digida, ma dudusa de na vegedi; ");
INSERT INTO kqc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ma kota renari, adina mina kono di ourefeidena amiye rofu kota reyo. ");
INSERT INTO kqc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Idu ago tau ya rofu nigi toga ura reida, idu bi gua moigi anua rededi. ");
INSERT INTO kqc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Idu ago rama di Vima desi ago rama tau vanu ya ourefeidego. Ina kaya ini vava dudu de ago nigo, idu beika neidedo, mina rofu ago nisi beika baika vata nigedi mina ka ya rofu niogau rego. ");
INSERT INTO kqc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nai roka moi odoro rigo, adina beika nai bi moisi ya rofu niogau rego dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Beika tau vanu nai Baba di bi nai; mina dada niyaka kana, beika bi nai bi moisi ya rofu niogau rego. ");
INSERT INTO kqc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Doba deri de na vegedi; ma gabi doba deri dudusa na vegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma ini usi dina vene be iniye iniye niyadi, “Mina bi beika una rofu nido, ‘Doba deri de na vegedi, ma gabi doba deri dudusa na vegedi’; ma, ‘adina nai Baba rofu digida’? ");
INSERT INTO kqc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mina ‘doba deri’ ini adina bi beika? Ini ago nido diba de nisifa!” ");
INSERT INTO kqc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu diba niyo ina nikaitegi regamadi, ye niyo, “Nai ago niyaka, ‘Doba deri de na vegedi, ma gabi doba deri dudusa na vegedi’; mina bi beika ya kaya ya kaya nikaitededi ba? ");
INSERT INTO kqc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma rama iniye ya nida: ya isaka nisi guruo regedi, idu kono tora noibanu di vene ada regedi; ya iriyeduka regedi, idu yi iriyeduka rena kero resi ada rena nigo. ");
INSERT INTO kqc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Rema mida odigasa iriyeduka redo, ini mida gera rena ari bi okiyo dada; idu mida moigori, esika dudusa de mokedo, adina amiye yokoi konori vata nina rofu ada redo dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mina resi ya ka gua iriyeduka rededi, idu dudusa ya vegida ma yi ukari ada regedi; amiye yokoi yi ada rena ya rofu moi etagae de rigo. ");
INSERT INTO kqc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mirona medari, beika yokoi na rofu usa de nigedi. Rama iniye ya nida: beika tau nai roka dudu nai Baba rofu usa nigedi, bi ya mago. ");
INSERT INTO kqc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Boyo gua, ya yaku beika yokoi nai roka dudu usa de niyadi. Yi beika tau usa nigedi bi moigedi, yi ada rena moi vau regedi dada. ");
INSERT INTO kqc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mokena ago dudu mina ya rofu nigamaka. Idu ari baegori, dudusa mokena ago dudu ya rofu de nigida, idu ago rorobo dudu Baba fafau nigida. ");
INSERT INTO kqc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mirona medari ya yaku nai roka dudu usa nigedi; ye ya rofu de nida, bi ya dada, nai Baba usa nigida; ");
INSERT INTO kqc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Baba ina kaya ya rofu uka mado dada, adina na rofu uka masi mokena vari gira aeyadi na bi Sei gutuna deyaka. ");
INSERT INTO kqc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na Baba gutuna desi konori dui reyaka, ye gua kono feresi nai Baba rofu digida.” ");
INSERT INTO kqc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma ini usi dina vene niyadi, “Gua ya ago rorobo dudu, mokena de kana dudu ago nisa. ");
INSERT INTO kqc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gua una diba ya bi beika tau gade diba nisi amiye yokoi yaku ya nikaitegika bi baku de reisa; mina resi ya bi Sei gutuna deyo, mina rofu mokena vari gira aesifa.” ");
INSERT INTO kqc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma nikabai reyo, “Ya gua mokena vari gira aededi ba? ");
INSERT INTO kqc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ari bi baedo ma sena baeyo, ya yokoi yokoi bi yi rautu neinei rerevaida nisi na feregedi. Idu na bi naike maka de, adina Baba bi nasa mini. ");
INSERT INTO kqc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mina ago ya rofu niyaka, ye na dudu uka amuta baku regedi dada. Konori esika esika iniye moigedi. Idu yi uka moi gira rifa; na yaku kono di vegu ebu reyaka dada!” ");
INSERT INTO kqc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mina ago koina nigasa oma ne odoro rei vesi niyo, “Baba, meda nemoko bi okiyo mini; yi Mida di roka moi odoro ri kumo yi Mida yi roka moi odoro riyaine dada. ");
INSERT INTO kqc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Adina ya yaku bi amiye tau gade fafau vava maro, toga toga ameibobina vegu magi, kaere ya yaku maro bi. ");
INSERT INTO kqc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma toga toga ameibobina vegu bi mini: ye amiye yaku ya Sei rama maka ma Iesu Keriso kaere nifeideyo, ya remanu diba nidedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na yaku konori yi roka moi odoro riyaka, adina moimai regi na maro bi mina rei vau reyaka. ");
INSERT INTO kqc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ma Baba o, gua yi nemokori nai roka moi odoro ri, sena mina kono rina koderi yasa amegasa vabara nufa kana. ");
INSERT INTO kqc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Na yaku kaere vene mina konori ya na maro, ina rofu yi roka moi ogau riyaka. Ina vene bi yi, ma na rofu maro, ma yi ago neideyadi. ");
INSERT INTO kqc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ye gua diba niyadi, beika tau gade na maro bi ya rofu dedo. ");
INSERT INTO kqc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Adina ya yaku ago na maro ma na yaku ina vene maraka, bi moisi ago rama diba niyadi na bi ya rofu deyaka. Ina ka mokena vari gira aeyadi ya na nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ina vene di usa usa nida. Kono vene di usa usa de nida, idu kaere ya yaku na maro vene rofu, ini adina ina bi yi. ");
INSERT INTO kqc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nai vene tau gade bi yi, ma yi vene bi nai; ma ina vene dudu nai roka moi odoro ridedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma na gua konori de amegida, idu ina vene bi konori amededi ma na ya rofu bae neida. Baba kikifa, yi roka di vava dudu nari re—mina roka na maro—ye yokoi maka niyaganedi, una yokoi maka kana. ");
INSERT INTO kqc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Inasa amegasa yi roka di vava dudu nari reyaka. Ya bi mina vava na maro. Na yaku nari regamaka, ma yokoi kava de moi boyo reyaka, no niyo amiye maka—ye Sei di ago mina bae rama aeyainedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na ya rofu baegida, ye konori mina ago nida, ye nai ada rena tau gade bi ini uka ideri moi vata baeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yi ago ina vene maraka, idu kono vene yaku ina vene gubuyo reyadi, adina bi diya kono di, na ka diya kono di kana. ");
INSERT INTO kqc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na bi konori moi etagae rigi ya usa de nida, idu amiye no rofu nari regi mina usa nida. ");
INSERT INTO kqc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na bi diya kono di kana, ina ka diya kono di. ");
INSERT INTO kqc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ago rama dudu ina vene moi akeke ri; yi ago bi rama. ");
INSERT INTO kqc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ya yaku konori na nifeideyo kana, ye ina vene ka konori nifeideyaka. ");
INSERT INTO kqc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Resi ina dada na kaya moi akeke rida, ye ina ka ago rama dudu moi akeke rigedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na diya ina vene rofu maka usa usa nigida, idu kaere nai usi dina di ago dudu na rofu mokena vari gira aegedi vene rofu ka, ");
INSERT INTO kqc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ye ina tau vakoi bae yokoi maka niyaganedi, ya Baba kana; ya bi na ideri ma na bi ya ideri. Una ideri ka ameyagane, ye kono vene ya yaku na rofu nifeideyo, mina rofu mokena vari gira aegedi. ");
INSERT INTO kqc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Vabara na maro, mina ina rofu maraka, mina dada bae yokoi maka niyaganedi, una bi yokoi maka kana: ");
INSERT INTO kqc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na bi ina venesa ma ya nasa, mina dada ina bae yokoi maka rei vau nigedi, ye mina kono vene yaku diba nigika ya yaku na nifeidesi ina vene uka maro, na uka maro kana. ");
INSERT INTO kqc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Baba, na ura reida kaere na maro vene, bi goidu ameida sanari nasa ka amegedi, ye vabara na maro veibiyaganedi, senagi kono rina koderi na uka maro dada. ");
INSERT INTO kqc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba e, ya mokena rorobo amiye, mina kono vene ina ka toto ya, idu na na diba ya, ma mina vene diba ya yaku na nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na yaku ina vene rofu yi roka oteimaraka ma toga regida, ye yi uka mana na rofu bi ina venesa amebiyainedi ma na ka inasa amebigida.” ");
INSERT INTO kqc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu ini usa nina koina niyori, bi ini usi dina venesa feresi Kidron soku ugasi muro yokoi minari dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Judas, kaere bi siri reyo amiye, bi mina sana ka diba, adina Iesu ini usi dina venesa uru tau gade mironari egogo regamadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kamini iya vene tau, Sei ma amiye utari naivo vene di varika vene, ma Pharisee vene di naivo vene bedakai afei baeyadi; bi ramefa, keroko, ma ora mari moisi mironari boyadi. ");
INSERT INTO kqc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ye Iesu sena diba niyo beika tau ina rofu vata nigo, dada ini budari bosi nikaiteyo, “Ya bi kaere maina rededi?” ");
INSERT INTO kqc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma nikabai reyadi, “Iesu Nazareth amiye.” Ma niyo, “Na bi ina mini.” Judas, siri reyo amiye, bi ina venesa mironari are regamo. ");
INSERT INTO kqc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu yaku, “Na bi ina mini,” vo niyori, fufuta rofu dairisi konori keto reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ye dudusa nikaiteyo, “Ya bi kaere maina rededi?” Ma dudusa niyadi, “Iesu Nazareth amiye.” ");
INSERT INTO kqc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ma nikabai reyo, “Na bi sena ya niyaka na bi ina mini, ye ya vene na maina rededi vonisi, bi mina vene ferefo kumo diyagane.” ");
INSERT INTO kqc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Mina ago niyo bi moi rama aego: “Ya yaku na maro vene bi yokoi kava de moi boyo reyaka.”) ");
INSERT INTO kqc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mina usi Simon Peter, kaere bainasi nufa, yaku moi yakusi kuita resi Sei ma amiye utari naivo amiye tora di moimai rei tavoi redo amiye di anema rama nugai feideyo. Mina amiye di roka bi Malchus. ");
INSERT INTO kqc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mina dada Iesu yaku Peter rofu niyo, “Yi bainasi ini moiyo sanari moi dairisi ae! Ya yaku mokeisa bi nai Baba na maro esika esika biyo bi de irigida ba?” ");
INSERT INTO kqc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mina usi iya rededi vene tau ma ini ourefeidena amiye, ma Jew vene di naivo vene yaku Iesu moi gira resi ini vana misi ");
INSERT INTO kqc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Annas rofu siko afei boyadi, kaere bi Caiaphas di imokai. Mirona laganiri bi Sei ma amiye utari naivo amiye tora. ");
INSERT INTO kqc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Bi Caiaphas kaere yaku Jew vene niyo buni iniye bi amiye yokoi maka yaku amiye fafau muyego. ");
INSERT INTO kqc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter ma usi dina amiye yokoi bi Iesu usi boyadi. Sei ma amiye utari naivo amiye tora bi mina usi dina amiye yokoi diba, ye Iesu sa Sei ma amiye utari naivo vene di tora amiye di yava ida nefau dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Idu Peter bi ida venau tua regamo. Ye mina usi dina amiye yokoi, kaere Sei ma amiye utari naivo amiye tora diba ina, yakusi rema ofi, kaere ida vena nari reyo, ina rofu ago niyo ma Peter afei dui reyo. ");
INSERT INTO kqc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ye ida vena naivo rema ofi yaku niyo, “Ya ka bi mina amiye di usi dina amiye yokoi ba ide?” Ma nikabai reyo, “Na bi ide.” ");
INSERT INTO kqc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Itu reyo dada, moimai rei tavoi rededi vene ma naivo naivo vene ita orisi are rei buru risi ita imigamadi. Ma Peter ka vava regika ina venesa are regamo. ");
INSERT INTO kqc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mina usi Sei ma amiye utari naivo amiye tora yaku ini usi dina vene ma ini oteimana ago fafau Iesu nikaiteyo. ");
INSERT INTO kqc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma nikabai reyo, “Na bi ariara kono vene rofu ago niyaka. Toga usa usa yava ma Sei nivakena yavari Jew vene tau gade egogo rededi sanari oteimagamaka; beika yokoi suiri de nigamaka. ");
INSERT INTO kqc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Beika resi na nikaiteisa? Na beika niyaka ma neideyadi vene nikaite—ina diba beika niyaka bi.” ");
INSERT INTO kqc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mina niyori, nari redo amiye yokoi kaere minari are regamo bi ini seira vana dudu famasi niyo, “Ya yaku makai kana dudu Sei ma amiye utari naivo amiye tora nikabai reisa ba?” ");
INSERT INTO kqc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ye nikabai reyo, “Na beika niyaka bi no vonisi, mina rofu niogau re; idu na bi rama niyaka vonisi, bi beika resi na uyo?” ");
INSERT INTO kqc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kamini ini vana sena miyadi dudu Annas yaku Caiaphas Sei ma amiye utari naivo amiye tora rofu nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ye Simon Peter toga ita imigasa are regamo. Mina dada nikaiteyadi, “Ya ka ini usi dina amiye yokoi ba?” Nisui resi niyo, “Na bi de.” ");
INSERT INTO kqc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sei ma amiye utari naivo amiye tora di moimai rei tavoi redo amiye yokoi, amiye kaere Peter yaku ini anema nugai feideyo, ini davatu yokoi yaku niyo, “Ya inasa murori ya veyaka ba?” ");
INSERT INTO kqc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mina dada Peter dudusa nisui reyo ma evade kokoro raka niyo. ");
INSERT INTO kqc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mina dada uriyaku gorogoro Iesu Caiaphas di yavari gutuna Rome di gavana di ourefeidena yava torari afei boyadi. Idu yava ideri bi dui de reyadi, ini adina iniye moi kino rigedi baebu, ye makai bi Ferei ebu rena irakuna di iruku de irigedi. ");
INSERT INTO kqc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ye Pilate etofaro nesi nikaiteyo, “Mina amiye bi beika vegu no reyo ma ina fafau tourage rededi?” ");
INSERT INTO kqc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma nikabai reyadi, “Mina amiye vegu no de regamo vonisi, bi yi vanari de aeyagadu.” ");
INSERT INTO kqc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kamini niyo, “Ya kaya moisi yi ago gira dudu ini vegu no kota refa.” Ye niyadi, “Uni ago gira dudu bi amiye yokoi ga umuyeyagane.” ");
INSERT INTO kqc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Mina bi Iesu di ago moi rama aeyo; ini ago niyo bi amiye oteimaro ina bi gokai muyego bi.) ");
INSERT INTO kqc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ye Pilate dudusa ini ourefeidena yavari dairisi Iesu raka nisi niyo, “Ya bi Jew vene di kini ba?” ");
INSERT INTO kqc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma nikabai reyo, “Mina nikaitena bi ya rofu baeyo, ba be vene yaku na dada ya oteimaradi?” ");
INSERT INTO kqc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma nikabai reyo, “Na bi Jew amiye ba? Yi vene ma Sei ma amiye utari naivo vene di varika vene yaku nai vanari ya aeyadi. Ye beika be reyo?” ");
INSERT INTO kqc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ye niyo, “Nai ourefeidena amena sana bi diya mina kono di. Mina kono di vonisi, bi nai naivo naivo vene yaku ruda reyagadu, ye Jew vene de na moiyagadu. Idu nai ourefeidena amena sana bi diya mina kono di!” ");
INSERT INTO kqc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mina dada Pilate yaku nikaiteyo, “Makai bi, ya bi kini ba?” Ma nikabai reyo, “Ya nisa na bi kini. Na vata nisi mina konori okiyaka bi mina rofu, ago rama rofu niogau regika dada. Kaere bi ago rama di, bi nai ago neidego.” ");
INSERT INTO kqc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma Pilate nikaiteyo, “Ago rama bi beika?” Mina niyo usi dairi etofaro nesi Jew vene rofu niyo, “Na bi mina amiye ideri vegu no yokoi de baku reyaka. ");
INSERT INTO kqc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Idu yi toutou bi Ferei ebu rena irakunari ya rofu amiye yokoi erufuyaine. Mina dada, ya ura rededi bi Jew vene di kini ya rofu erufugida ba?” ");
INSERT INTO kqc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ye dudusa imuna niyadi, “Mina amiye bi de, idu Barabbas maka!” (Ina bi gavamani rofu ruda rena amiye yokoi.) ");
INSERT INTO kqc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kamini Pilate Iesu afei boyo ma buburu vai reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ye iya rededi vene yabo imiye maena moi tetevai resi kini kana ada bou ini adari aesi varuka purple aku masi ");
INSERT INTO kqc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ina rofu bosi niyadi, “Jew vene di kini o!” Resi seira famaradi. ");
INSERT INTO kqc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Pilate dudusa desi niyo, “Vefa kumo, na yaku ya rofu afei yaku deida, ye vegu no ini ideri yokoi de baku reyaka diba niyagane dada.” ");
INSERT INTO kqc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ma Iesu bi imiye maena kini kana ada bou ma varuka purple akuyo nufa deyo ma Pilate ina vene rofu niyo, “Amiye bi mini!” ");
INSERT INTO kqc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mina dada Sei ma amiye utari naivo vene di varika vene ma naivo naivo vene vegasa imuna niyadi, “Satauro ikoko re, satauro ikoko re!” Idu Pilate yaku niyo, “Ya kaya moisi satauro ikoko refa; na bi vegu no yokoi ini ideri baku de reyaka dada.” ");
INSERT INTO kqc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jew vene nikabai reyadi, “Una bi ago gira nufa ma mirona ago gira dada bi muyeyaine, ina kaya moi Sei di mida vo niyo dada.” ");
INSERT INTO kqc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kamini Pilate mina ago neidegasa besa ori resi ");
INSERT INTO kqc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ma ini ourefeidena yava torari dairi bosi Iesu nikaiteyo, “Ya bi goidu gutuna baeyo?” Idu ago yokoi de niyo. ");
INSERT INTO kqc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dudusa niyo, “Na nikabai regiya ba? Ya diba de na bi ya erufugi o satauro ikoko regi di vava nufa bi?” ");
INSERT INTO kqc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ye nikabai reyo, “Sei ya rofu vava de maro vonisi, ya bi vava na fafau bi de. Mina dada kaere yaku yi vanari na aeyo ini vegu no bi tora iniye.” ");
INSERT INTO kqc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mina usi Pilate erufugi di ida maina reyo, idu Jew vene imuna niyadi, “Ya mina amiye erufugiya vonisi, ya bi Caesar di asini de! Kaere yaku nibigo bi kini, Caesar rofu ruda rego.” ");
INSERT INTO kqc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ye Pilate mina neidegasa Iesu afei desi kota rena di amena sana fafau ameinu reyo. Mirona sana roka nidedi “Fore ida”. (Hebrew agori mina bi “Gabbatha”.) ");
INSERT INTO kqc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kamini bi Ferei ebu rena irakuna di dogo dogo rena meda, meda tobo niyori kana. Ma Jew vene rofu niyo, “Yi kini bi mini!” ");
INSERT INTO kqc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Idu imuna niyadi, “Afei bosi satauro ikoko re!” Ye nikaiteyo, “Na bi yi kini satauro ikoko regida ba?” Ye Sei ma amiye utari naivo vene di varika vene nikabai reyadi, “Uni kini bi Caesar maka!” ");
INSERT INTO kqc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mina usi iya rededi vene di vanari aeyo satauro ikoko reyaganedi. Mina resi moiyadi ");
INSERT INTO kqc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ma yakusi iniye ini satauro uakaisi gagani roka “Ada girika di sana” okiyo. (Hebrew agori bi roka nidedi “Golgotha”.) ");
INSERT INTO kqc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Minari satauro ikoko reyadi; amiye remanu ka makai reyadi, berou berou ma Iesu utari. ");
INSERT INTO kqc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma Pilate yaku ka bura reyo ma satauro yabo odorori aeyadi, bi yomakai bura reyo: “Iesu Nazareth amiye, Jew vene di kini.” ");
INSERT INTO kqc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jew vene tau yaku mina bura veyadi, adina mina sanari satauro ikoko reyadi bi taoni atafuri; Hebrew, Latin ma Greek agori bura reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kamini Jew vene di Sei ma amiye utari naivo vene di varika vene Pilate rofu niyadi, “Bura ga re ‘Jew vene di kini’, idu, ‘Mina amiye yaku niyo, Na bi Jew vene di kini.’” ");
INSERT INTO kqc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma nikabai reyo, “Beika bura reyaka bi bura reyaka mini.” ");
INSERT INTO kqc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Iya rededi vene yaku satauro ikoko regasa ini varuka iniye yokoi yokoi moisi ina 4 ri aeyadi; ini ideri varuka ka moiyadi. Mina ideri varuka bi odorori egona rofu dabua yokoi maka dudu turiya reyadi, ");
INSERT INTO kqc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ye iniye iniye rofu niyadi, “Uvesi ga renadi, idu laki isira renadi kaere yaku moigo.” Mina yaku Sei di ago moi rama aeyainedi; mina niyo: “Ini fogori nai varuka moi rau resi nai varuka rofu laki isira reyadi.” Ye iya rededi vene yaku makai reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma Iesu di nono ma ini rasini Mary, kaere bi Clopas di rema, ma Mary Magdalene bi satauro atafuri are regamadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ini nono ma ini usi dina amiye kaere uka maro ka atafuri are regamadi, ne rei vegasa niyo, “Nono, yi mida mini!” ");
INSERT INTO kqc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Resi ini usi dina amiye rofu niyo, “Yi nono mini!” Ma mina meda nemokori maka mina usi dina amiye yaku ini yavari afei boyo. ");
INSERT INTO kqc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gabi mamo tau vakoi rei vau reyadi diba niyo, ye Sei di ago moi rama aeyaine dada, “Na bi koru vaiyaka,” vo niyo. ");
INSERT INTO kqc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Waini ru siua vata baeyo bi minari amegamo; ye mina waini viniga dudu sipanisi vata baesi yabo roka hyssop tetekari tete risi ini venari moi odoro reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waini viniga moigasa niyo, “Kamini koina niyo!” Mina nisi kuri agu risi ini vima maro. ");
INSERT INTO kqc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jew vene Pilate usa niyadi, bi satauro ikoko reyadi vene ini yuka uroki resi ini roaita moi soka regedi, bi dogo rena di medari dada, ye roaita bi Sabati medari satauro odoro ga fereyainedi; mina bi Sabati meda tora dada. ");
INSERT INTO kqc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mina dada iya rededi vene baesi Iesu sa satauro ikoko reyadi ouresi amiye ma amiye berou eta rofu di yuka uroki reyadi, ");
INSERT INTO kqc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","idu Iesu rofu baesi veyadiri, bi sena muyeyo, bi ini yuka de uroki reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ye iya redo amiye yokoi yaku ini aveta ora dudu imiyo ma minari maka dava ma koru rausi reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Amiye kaere mina veyo, bi niogau reyo ma ini niogau rena ago bi rama; adina diba nido bi ago rama nido, ye ya ka mokena vari gira aeyaine dada.) ");
INSERT INTO kqc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Adina mina vata niyadi, Sei di ago moi rama aeyaine dada: “Ini nena yokoi de uroki regedi.” ");
INSERT INTO kqc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma dudusa Sei di agori niyo: “Imiyadi amiye bi vegedi.” ");
INSERT INTO kqc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kamini mina usi, Arimathea amiye yokoi roka Joseph yaku Pilate rofu Iesu di roaita moigi usa niyo. (Ina bi Iesu di usi dina amiye yokoi, idu sui dudu, Jew vene ori reyo dada). Ma fereyo, mina dada baesi ini roaita moi diyo. ");
INSERT INTO kqc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma Nicodemus, kaere sena urusari Iesu baku reyo, ka bi myrrh ma aloe moi mikisi resi moi baeyo; ini toe bi 33 kilogramme kana. ");
INSERT INTO kqc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mina dada ini roaita moisi muramura safisa varuka buni dudu kumu riyadi, Jew vene roaita guri aena toutou kana. ");
INSERT INTO kqc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ye mina satauro ikoko reyadi sana ideri bi muro yokoi; muro ideri bi kono guri ruaka, muyena roaita yokoi mina ideri aena kode. ");
INSERT INTO kqc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Guri aeyadi sana atafuri, ma Jew vene di dogo rena di meda dada, ini roaita minari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kamini uriyaku gorogoro mukuna nufasa, fura di ourena medari, Mary Magdalene bi guri aeyadi sana bosi guri di ida venari fore biri riyadi bi moi etagae riyadi mina veyo. ");
INSERT INTO kqc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mina resi raga resi Simon Peter ma Iesu uka mado usi dina amiye yokoi rofu bosi niyo, “Bi Varika amiye guri sanari moi yakuyadi, ma una una toto ini aeyadi sana bi!” ");
INSERT INTO kqc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ye Peter mina usi dina amiye yokoisa guri aeyadi sana urana boyadi. ");
INSERT INTO kqc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ina vakoi raga regamadi, idu usi dina amiye yokoi Peter ebu resi guri sanari ina iko okisi ");
INSERT INTO kqc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","agu risi varuka buni maka veyo, idu guri ideri bi de boyo. ");
INSERT INTO kqc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ye Simon Peter usi okisi guri aeyadi sana dui resi varuka buni veyo. ");
INSERT INTO kqc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iesu di ne uruma varuka ini ada efono reyadi ka veyo; bi varuka bunisa ide, idu ini sanari maka firo risi aeyadi. ");
INSERT INTO kqc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kamini usi dina vene yokoi, kaere guri aeyadi sana rofu siko okiyadi, ka bi ini ideri bosi vesi mokena vari gira aeyo. ");
INSERT INTO kqc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Adina mina medari, Sei di ago ina toto, ye muyena dadi rae reyaine dada.) ");
INSERT INTO kqc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ye ini usi dina vene bi ini rautu neinei dairisi diyadi. ");
INSERT INTO kqc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Idu Mary bi guri aeyadi sana etofaro are resi isaka nigasa agu risi ideri ne reyo ma ");
INSERT INTO kqc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sei di naivo naivo vima remanu varuka feyo risi Iesu di roaita aeyadi sanari amegamadi ma veyo, yokoi bi ini ada rofu ma yokoi bi ini yuka rofu. ");
INSERT INTO kqc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kamini nikaiteyadi, “Rema, ya bi beika resi isaka nisa?” Ma niyo, “Nai Varika amiye bi moiyadi ma goidu aeyadi bi na toto!” ");
INSERT INTO kqc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mina nigasa kero resi Iesu are redo ma veyo, idu bi ina toto. ");
INSERT INTO kqc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ye ina rofu niyo, “Rema, beika resi isaka nisa? Ya bi kaere maina reisa?” Ma mokeyo bi muro nari redo amiye yokoi, dada niyo, “Amiye tora, moi diyo vonisi, bi goidu aeyo na oteima ma bosi moigida.” ");
INSERT INTO kqc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kamini niyo, “Mary!” Ma kero resi Hebrew agori niyo, “Rabboni!” (Mina ini adina bi “Oteimana amiye”.) ");
INSERT INTO kqc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma niyo, “Ga na avaka moi, adina nai Baba rofu bi dairina kode; idu nai dubuiyaka vene rofu disi nioteima, ‘Nai Baba ma yi Baba rofu dadigida, kaere bi nai Sei ma yi Sei.’” ");
INSERT INTO kqc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ye bosi usi dina vene rofu niogau reyo, “Na yaku Varika amiye veyaka.” Resi Iesu yaku niyo ago nioteimaro. ");
INSERT INTO kqc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Fura di ourena meda uriyenauri, ini usi dina vene bi egogo sanari ida biri risi ae gira resi ideri amegamadi, Jew vene rofu ori reyadi dada. Ye Iesu baesi ini utari are resi niyo, “Uka amuta bi yasa ameyaine.” ");
INSERT INTO kqc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mina ago ni vau resi bi ini vana ma aveta oteimaro, ye ada reyadi Varika amiye veyadi dada. ");
INSERT INTO kqc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma dudusa niyo, “Uka amuta bi yasa. Baba yaku na nifeideyo kana, na ka ya nifeideida.” ");
INSERT INTO kqc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mina nisi ina fafau asa masi niyo, “Vima kikifa moifa. ");
INSERT INTO kqc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amiye yokoi ini vegu no moi erufugedi vonisi, bi koite makugo; ya ini vegu no de moi erufugedi vonisi, de moi koite makugo.” ");
INSERT INTO kqc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mina ituari Iesu boyori, amiye 12 yokoi roka Thomas, kaere ka roka niyadi Kakafasina, bi ina venesa de. ");
INSERT INTO kqc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ye ini usi dina vene yaku niyadi, “Una yaku Varika amiye veyafa!” Idu niyo, “Ini vanari ikoko imiyadi sana vesi nai vana ebuna aesi nai vana ini aveta ideri de aegida vonisi, bi toga mokena vari gira de aegida.” ");
INSERT INTO kqc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gabi fura yokoi koina niyori, ini usi dina vene bi dudusa yava ideri amegamadi ma Thomas bi inasa. Bi yava ida biri risi ae gira reyadi, idu Iesu ini utari baesi are resi niyo, “Uka amuta bi yasa.” ");
INSERT INTO kqc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Resi Thomas rofu niyo, “Yi ebuna minari aesi nai vana ve; yi vana roto risi nai aveta ideri ae. Mokena vari gira de aena ga re, idu mokena vari gira ae!” ");
INSERT INTO kqc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ye niyo, “Nai Varika amiye ma nai Sei!” ");
INSERT INTO kqc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kamini niyo, “Yi mokena vari gira aeyo, na veyo dada, idu kaere vene na de veyadi, ma mokena vari gira aeyadi bi buni mago!” ");
INSERT INTO kqc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ye Iesu yaku ini usi dina vene di nemokori mokena vegu tau regamo, mina buka ideri bi de bura reyo. ");
INSERT INTO kqc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Idu mina bura reyo, Iesu bi Keriso, Sei di mida mina rofu mokena vari gira aeyaine dada, ye yi mokena vari gira aena dudu ini rokari vegu moigedi. ");
INSERT INTO kqc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mina usi Iesu dudusa ini usi dina vene rofu Tiberias moka daidai tora adinari ogau niyo. Mina bi yomakai vata niyo: ");
INSERT INTO kqc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Minari bi Simon Peter, Thomas (ini roka yokoi ka Kakafasina), Nathanael (Cana Galilee amiye), Zebedee di mida ma ini usi dina vene remanu. ");
INSERT INTO kqc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter yaku niyo, “Na bi kimai regida.” Niyadi, “Una ka yasa baegifa.” Ye bosi bouti keu riyadi, idu mina urusari bi yokoi moina de reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Uriyaku gorogoro Iesu moka daidai tora seriri are reyo, idu ini usi dina vene bi de vei mama reyadi. ");
INSERT INTO kqc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mina dada nikaiteyo, “Nai mida mida, oyena be moiyadi ba ide?” Nikabai resi niyadi, “Ide.” ");
INSERT INTO kqc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma niyo, “Reke moisi bouti di vana rama rofu younesi be moigedi.” Ye reke youneyadi bi rutu rei baena anua reyadi, adina bi oyena tau gade moiyadi. ");
INSERT INTO kqc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mina dada usi dina amiye kaere Iesu uka maro bi Peter rofu niyo, “Mina bi Varika amiye!” Ye Simon Peter bi faisara dada, Varika amiye mini neidesi ini bou varuka ini gagabari misi bi moka daidai torari sokau reyo. ");
INSERT INTO kqc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Idu usi dina vene bedakai reke oyena tau gade vata baeyo, mina moi rutu resi bouti keu riyadi, adina kono bi maike de, 90 metre kana. ");
INSERT INTO kqc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ye utae rigasa bi minari ita guruma oyena fafau ma beredi be veyadi. ");
INSERT INTO kqc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Iesu yaku niyo, “Oyena be na mafa ruika moiyadi mina.” ");
INSERT INTO kqc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mina dada Simon Peter bouti keu risi reke oyena tora tora vata baeyo mina konori moi rutu reyo; ini naba bi 153. Bi tau gade, idu reke uvesi de reyo. ");
INSERT INTO kqc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu yaku niyo, “Baesi iri-iri refo.” Ini usi dina vene ka ini nikaitena “Ya bi kaere?” bi mokena de reyadi, adina diba niyadi be Varika amiye mini. ");
INSERT INTO kqc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ye boi nesi beredi moisi maro ma oyena ka makai reyo. ");
INSERT INTO kqc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mina bi uru regode Iesu ini usi dina vene rofu ogau niyo ini muyena gutuna dadi rae reyo fufutari. ");
INSERT INTO kqc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iruku iriyadi koina niyori, Iesu yaku Simon Peter nikaiteyo, “Simon, John di ubama, ya besa na rofu uka maisa mina vene kana ba ide?” Ma nikabai reyo, “Yo, Varika amiye, ya ya diba ya ura reida.” Ma Iesu niyo, “Nai mamoe mida mida vana re.” ");
INSERT INTO kqc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dudusa uru remanu ina rofu niyo, “Simon, John di ubama, na rofu uka maisa ba de?” Ma niyo, “Yo, Varika amiye, ya ya diba ya ura reida.” Ma niyo, “Nai mamoe dogo re.” ");
INSERT INTO kqc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma uru regodenu niyo, “Simon, John di ubama, na ura reisa ba ide?” Kamini Peter bi iriyeduka reyo, adina bi uru regode nikaiteyo, “Na ura reisa ba de?” Ye nikabai reyo, “Varika amiye, ya bi beika baika tau gade ya diba; ya ya diba ya ura reida!” Ma niyo, “Nai mamoe mida mida vana re. ");
INSERT INTO kqc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rama iniye ya nida, ya goduari bi ya kaya farasi resi goidu digi ura regamo bi digamo. Idu ugava nigasa vana roto rigiya, ma amiye be yaku ya farasi resi bi goidu digi ura de regiyari, bi ya afei digedi.” ");
INSERT INTO kqc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Mina nigamo bi Peter ini gokai muyesi Sei di roka moi odoro rigo oteimagi.) Mina nisi ka niyo, “Na usi bae!” ");
INSERT INTO kqc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter kero resi usi dina amiye kaere Iesu yaku uka magamo, bi usi diyo mina veyo—mina amiye bi kaere Iesu kokobari etebe rigasa iruku irisi nikaiteyo, “Varika amiye, kaere yaku ya siri rego?” ");
INSERT INTO kqc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ye Peter yaku mina vegasa bi Iesu nikaiteyo, “Varika amiye, yomina amiye bi gokai?” ");
INSERT INTO kqc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kamini nikabai reyo, “Vegu amebigo mamo na baegida mina ura regida vonisi, bi ya rofu bi gokai? Na usi bae!” ");
INSERT INTO kqc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ye usika ourena vene fogori sina yokoi vai resi niyadi mina usi dina amiye bi de muyego; idu Iesu bi diya muyego ina rofu de niyo, idu, “Vegu ameibobigo bogo na baegida mamo mina ura regida vonisi, bi ya rofu bi gokai?” ");
INSERT INTO kqc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mina bi usi dina amiye kaere mina beika baika rofu niokusi mina bura reyaka. Ma una una diba ini niokuna ago bi rama. ");
INSERT INTO kqc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ye Iesu yaku ka beika baika tau reyo. Ma yokoi yokoi bura reyagaduri, bi nai mokenari kono tora noibanu bi mina bura rena buka moi gira de reyagadu. ");
INSERT INTO kqc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ya Theophilus e: Nai ouresi bura reyaka bukari bi Iesu yaku beika resi oteimagi kora regamo mironari bura reyaka. ");
INSERT INTO kqc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mina bi ini ouresi moimai reyo medari gutuna bosi mamo Sei yaku omari afei boyo medari. Oma odorori dadina koderi bi Vima kikifa di vava dudu ini ago gira ini vo niyo mina nifeidena vene rofu nimaro. ");
INSERT INTO kqc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ini esika esika moiyo fufutari, bi vegu nisi ari yokoi yokoiri meda 40 ideri ini vene rofu baesi ogau nigamo. Rama iniye baesi ogau nigamo dada mina vegamadiri, bi mokei anua de reyadi; rama ina bi dudusa vegu nisi ina vene rofu Sei di ourefeidena amena sana di vegu mina nioteimagamo. ");
INSERT INTO kqc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma inasa vakoi gogo amegamadiri, bi ini ago gira masi niyo: “Jerusalem ri ga ferefa kumo, ye na yaku ya nigamaka kana, nai Baba yaku beika nitore reyo bi ya mago vo nigamo mina tua refa. ");
INSERT INTO kqc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Adina bi, John bi koru dudu ya babatiso reyo, idu meda tau koina koderi bi Vima kikifa dudu babatiso rego.” ");
INSERT INTO kqc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma nifeidena vene yaku Iesu sa egogo regasa nikaitegamadi, “Varika amiye, gua yomina medari Israel vene vava magiya ma ini gagani dudusa ourefeidegedi ba de?” ");
INSERT INTO kqc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma niyo, “Baba ini vava iniye dudu ari ma meda aedo, idu ya bi mina ari ma meda ya toto. ");
INSERT INTO kqc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Idu Vima kikifa yaku ya vene fafau desi vava ya mago. Ma Jerusalem ri, Judea ma Samaria gagani tauri ma mina kono tora noibanu di gagani maike torari ka nai roka ninegau regedi.” ");
INSERT INTO kqc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mina ago ni vau reyo ma neyadiri, Sei yaku omari afei boyo ma seuya yaku fono reyo dada de veyadi. ");
INSERT INTO kqc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Omari boyo sana mina toga vegasa amegamadiri, bi evade amiye remanu varuka feyo akuyadi ina vene atafu are reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Resi mina amiye remanu yaku niyadi, “Galilee vene, beika resi minari are resi oma odoro ne rededi? Mina Iesu, kaere Sei yaku ya vene rofu omari afei boyo bi mina ida ya veyadi mina maka dudu omari dairi dego.” ");
INSERT INTO kqc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kamini nifeidena vene bi omuna ini roka bi Olive yabo di ikari gutuna Jerusalem ri dairi boyadi. Mina omuna gutuna Jerusalem bona bi Sabati meda yokoi makari nana rena di maike kana. ");
INSERT INTO kqc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem ri dui reyadiri, bi ini amededi daiyuturi boyadi. Mina bi Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, Alphaeus di mida James, zealot amiye Simon, ma James di mida Judas. ");
INSERT INTO kqc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ina vene tau vakoi uka yokoi maka dudu egogo regasa toga toga usa usa nigamadi. Rema be ka ina venesa egogo regamadi; minari bi Mary, kaere bi Iesu di nono, ma ini dubuiyaka. ");
INSERT INTO kqc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mina ariri, Peter yaku dadisi mina usika ourena vene di utari are reyo. (Ina vene tau egogo reyadi bi 120 kana.) Niyo, ");
INSERT INTO kqc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Usika ourena vene, Sei di agori beika bura reyadi mina rama niyo bi Vima kikifa yaku David di venari Judas rofu niyo kana: Ina yaku Iesu moi gira reyadi vene moi ourefeideyo. ");
INSERT INTO kqc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ka uni amiye yokoi, adina Iesu ina rofu uni moimairi mokeyo dada.” ");
INSERT INTO kqc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ini mokena rorobo de fore dudu bi kono kefuka yokoi voi reyo; ye minari keto resi muyeyori, bi ini uka uesi reyo ma ini diyekuki rausi reyo. ");
INSERT INTO kqc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem amiye tau mina vegu neideyadi, ye ini ago iniye dudu mina kono roka niyadi bi Akeldama, ini adina bi “Dava Kono”. ");
INSERT INTO kqc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Adina Psalms bukari bi sena bura reyadi: ‘Ini yava bi koina iniye amebigo bi buni; ma amiye yokoi mina yavari ga ameyaine.’ Ka bura reyadi: ‘Amiye yokoi yaku ini ourefeidena moimai rena sana moiyaine.’ ");
INSERT INTO kqc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mina dada amiye yokoi kaere ari tauri una tau vakoi egogo reyafa ma Varika amiye Iesu unasa diga bogamafa bi Varika amiye Iesu di dadi rae rena di sina niogau rena amiye kana unasa niyaine: John di babatiso rena di ago ogau niyo di ari gutuna Sei yaku Iesu omari afei boyo di meda rofu.” ");
INSERT INTO kqc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mina dada amiye remanu nivabi reyadi: Joseph, kaere bi ini roka nigamadi bi Barsabbas (ma ini roka yokoi ka bi Justus), ma amiye yokoi bi Matthias. ");
INSERT INTO kqc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ye usa usa niyadi, “Varika amiye, ya ya diba amiye tau di uka di mokena. Mina dada, una oteima, mina amiye remanuri bi kaere moiyo, ");
INSERT INTO kqc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","adina oteimana moimai rego dada. Adina bi Judas ini moimai feresi ini amena sanari diyo.” ");
INSERT INTO kqc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Resi bi mina amiye remanu di roka bura resi laki dudu isira rena kana resi ini roka maina reyadi. Roka moiyadi bi Matthias. Ye ina bi mina nifeidena vene 11 di rafuri boi dui reyo. ");
INSERT INTO kqc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost di irakuna di meda okiyori, ina vene tau bi egogo resi sana yokoi makari ameyadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kamini minari maka oma odorori kukuroka yokoi aura tora baedo kana bi baesi ini amegamadi yava noibanu vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma minari bi ita afiye kana fairo resi urafo resi amiye yokoi yokoi odorori ameyadi mina veyadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vima kikifa yaku mina vene tau di roaita vata baeyo dada gokai magamo kana ina vene bi gagani be vene di ago nigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mina ariri Jew vene bi Jerusalem ri amegamadi, gagani gagani tau noibanu kono tora noibanu vene kaere bi Sei rofu nivakegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mina kukuroka neideyadiri, bi amiye tau gade iniye egogo resi ini vima diyadi, adina bi ina vene iniye ini ago neinei dudu ago nigamadi mina neideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ina vene ini mokena forovai rei vau resi niyadi, “Gua mina vene bi Galilee vene, ba? ");
INSERT INTO kqc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Gokai resi bi una tau vakoi neidesifa uniye uni gagani ago neinei nidedi bi? ");
INSERT INTO kqc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Una bi Parthia vene, Media vene, Elam vene; ma Mesopotamia, Judea ma Cappadocia, Pontus ma Asia rofu vene; ");
INSERT INTO kqc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma Phrygia ma Pamphylia, Egypt ma Libya gagani rautu rautu, Cyrene taoni atafu rofu vene. Ma una be bi Rome rofu vene, ");
INSERT INTO kqc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ma be bi Jew vene ma be bi Jew vene de kaere bi Jew vene di Sei nivakena vegu usi didedi; ma una be bi Crete vene ma Arab vene—idu mina vene bi Sei yaku beika vegu buni reyo bi uniye uni ago neinei dudu nidedi ma neidesifa!” ");
INSERT INTO kqc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tururu resi mokena forovai dudu iniye iniye nikaitegasa niyadi, “Mina ini adina bi beika?” ");
INSERT INTO kqc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Be yaku ina vene rofu ni moi ninika nigasa nigamadi, “Mina vene bi waini ruaka tau gade iriyadi!” ");
INSERT INTO kqc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kamini Peter dadisi ini nifeidena vene 11 sa are resi ago ni tora resi mina amiye tau rofu niyo, “Judea vene ma ya kaere Jerusalem ri amededi vene, nai ago nigida neidefo gua yomina vegu vededi di adina rama iniye bi beika. ");
INSERT INTO kqc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yomina vene bi waini de irisi ada forovai de reyadi, yi mokededi kana. Ari uveyori meda nemoko bi 9:00 maka dada. ");
INSERT INTO kqc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Idu mina vegu vededi bi Sei di ago niyo amiye Joel yaku ini sena niyo kana: ");
INSERT INTO kqc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Sei yaku nido ari boi koina nibigediri, bi yomakai regida: Amiye tau fafau nai Vima moi rausi regida. Yi rumana mida mida ma rema mida mida yaku Sei di ago niokugedi; yi godua vene yaku yaduka kana vegedi, ma yi ugava vene yaku bi yaduka vegedi. ");
INSERT INTO kqc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ka nai moimai rei tavoi rededi rema ma rumana fafau mirona medari nai Vima rausi regida, ma ina vene yaku Sei di ago niokugedi. ");
INSERT INTO kqc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oma odorori mokena vegu resi kono fafau ka rebe regida. Bi dava, ita ma iroka tora ogau nigo; ");
INSERT INTO kqc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","meda bi baesi mukuna nigo, ma eyo bi dava kana kaka nigo, mina bi Varika amiye di meda tora ma buni tora gade baesi okina kode. ");
INSERT INTO kqc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ye kaere yaku Varika amiye di roka raka nigo bi moi vegu rigo.’ ");
INSERT INTO kqc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel vene, mina ago neidefo: Sei yaku ya vene rofu Iesu Nazareth amiye nifeidesi mokena vegu ma rebe vegu ya vene di tobori ini vana dudu regamo, ye ya ka ya diba. ");
INSERT INTO kqc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sei yaku ini mokena dudu bi sena yo niyo, Iesu ya vene di vanari aego bi; ye ya vene yaku vegu no vene di vanari aegedi ma sataurori ikoko regedi di. ");
INSERT INTO kqc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Idu Sei yaku muyenari gutuna moi dadisi muyena di esika esika rofu youneyo, adina muyena yaku moi gira regi anua rego. ");
INSERT INTO kqc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Adina David ina rofu yomakai niyo: ‘Ari neinei Varika amiye bi nai neri maka vegamaka; ina bi na vana rama atafu amedo, dada toe yaku na moi forovai de rego. ");
INSERT INTO kqc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mina dada nai uka bi ada redo, ma ada dudu nivakena sina nigamaka. Na bi amiye maka, amiye tau kana, ye Sei ini beika rego na rofu mina ini uka mokena tua regasa amego, ");
INSERT INTO kqc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","adina bi muyena vene di amena sanari nai vima de feregiya; ma yi moimai rei tavoi redo amiye kikifa de feregiya ma guri ideri iko de nigo. ");
INSERT INTO kqc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Vegu rofu boyo ida bi na oteimaro, na ada iniye reida ya nasa ameisa dada.’ ");
INSERT INTO kqc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nai usika ourena, uni tutubena David di sina rama bi ya vene rofu nigida. David muyeyo ma guri aeyadi, ma ini guri aeyadi sana bi gua mini unasa amedo. ");
INSERT INTO kqc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Adina bi Sei di ago niyo amiye, ina diba Sei yaku ina rofu ini ago nitore reyo bi David di tutubena yokoi ourefeidego, David yaku ourefeideyo kana. ");
INSERT INTO kqc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David bi sena veyo Keriso dadi rae rego sina yomakai niyo: ‘Sei yaku muyena vene di amena sanari de fereyo; ma ini roaita ka iko de niyo.’ ");
INSERT INTO kqc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sei yaku sena mina Iesu moi dadiyo, ma una tau noibanu yaku mina beika vata niyo vegu veyafa. ");
INSERT INTO kqc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mina dada Sei, ini Baba, yaku ini vana rama rofu moi dadisi ina rofu Vima kikifa maro, ini nitore rena ago kana. Dada gua beika vegasa neidededi bi una mago vo niyo kana mini una fafau moi rausi reyo. ");
INSERT INTO kqc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Adina bi David iniye omari de boyo, idu iniye yomakai niyo: ‘Varika amiye yaku nai Varika amiye rofu niyo: Nai vana rama eta rofu ameinu re ");
INSERT INTO kqc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bogo na yaku yi tuma vene yi yuka aena sana kana rigida mamo.’ ");
INSERT INTO kqc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mina dada Israel vene tau rama iniye vei mama reyainedi mina Iesu, kaere bi satauro ikoko reyadi, bi Sei yaku moi Varika amiye ma Keriso riyo!” ");
INSERT INTO kqc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Amiye yaku mina sina neideyadiri, bi ini uka okuna iniye reyo, dada Peter ma nifeidena vene be nikaitesi niyadi, “Usika ourena vene, beika regifa?” ");
INSERT INTO kqc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Peter yaku ina vene rofu niyo, “Ya tau noibanu yi vegu no feresi moi etagae risi Iesu Keriso di roka dudu babatiso moiyagane ye Sei yaku yi vegu no koite makugo; ma Vima kikifa moigedi, kaere bi Sei yaku una mago vo niyo. ");
INSERT INTO kqc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Adina Sei yaku nitore reyo sina bi ya yi midasa rofu niyo, ma kaere gagani maike amededi vene rofu ka—amiye tau kaere Varika amiye uni Sei yaku ina rofu raka nigo mina.” ");
INSERT INTO kqc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sina tau dudu Peter yaku ina vene rofu nisi toga toga ni yeiva regasa nigamo, “Gua yomina vegu no rededi vene di kaunava iniye moi vegu rifa!” ");
INSERT INTO kqc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ye amiye kaere ini ago moi rama aeyadi bi babatiso reyadi; mina ariri amiye 3,000 kana ini rafuri dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ari neinei egogo resi nifeidena vene di sina neidegasa usa usa nigasa ma iruku irigasa auta regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nifeidena vene dudu mokena vegu ma rebe tau gade regamadiri, bi amiye tau vakoi Sei rofu toga toga ori regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma Iesu rofu mokena vari gira aeyadi vene tau vakoi egogo resi ini gugura fore iniye iniye rau regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ini gugura fore ma kono sero resi ini mokegamadi kana mina fore amiye tau rofu rau regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ari neinei, rafu yokoi maka dudu Sei nivakena yavari egogo resi ini yava neineiri ada rena dudu ma mokena yokoi maka dudu iruku irigamadi, ");
INSERT INTO kqc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sei rofu nivakegamadi ma amiye tau vakoi ina vene rofu uka ada regamadi. Ari neinei Varika amiye yaku moi vegu rigamo vene bi yokoi yokoi ini rafuri moi dui regamo. ");
INSERT INTO kqc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Meda yokoiri, Peter ma John bi usa usa nina ari di uriyenau meda nemoko regodenuri Sei nivakena yavari boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Amiye yokoi yuka no vata niyo bi uakaiyadi. Ari neinei Sei nivakena yava di ida vena roka “buni iniye” atafuri moi bosi dui rei bogamadi vene rofu fore usa usa nigi aegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter ma John Sei nivakena yavari dui reyadi ma veyori, bi fore usa nigi kora reyo ina maraganedi. ");
INSERT INTO kqc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Idu Peter ma John vei mama reyadi ma Peter yaku niyo, “Una una ve kumo!” ");
INSERT INTO kqc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dada ne resi ina vene veyo. Ini mokenari bi beika bodo yokoi magedi. ");
INSERT INTO kqc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Idu Peter yaku ina rofu niyo, “Nasa bi fore de iniye iniye, idu nasa beika amedo mina ya magida: Iesu Keriso, Nazareth amiye di roka dudu ya nida dadisi nana re!” ");
INSERT INTO kqc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Resi bi ini vana ramari moi aedesi moi are reyo. Minari maka ini yuka ma kane kefuka yeiva niyadi; ");
INSERT INTO kqc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","dadi sokau usi are rei diga bogasa reyo. Kamini ina venesa Sei nivakena yavari dui rei nana rei bogasa sokaugasa Sei di roka moi odoro risi nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Amiye tau noibanu yaku veyadi nana regasa Sei di roka moi odoro risi nigamo, ");
INSERT INTO kqc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","resi vei mama reyadi ina bi Sei nivakena yava di ida vena roka “buni iniye” ri amegasa amiye rofu usa usa nigamo amiye, ye ina vene bi tururu iniye reyadi ina rofu beika vata niyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mina yuka buni niyo amiye yaku Peter ma John moi gira regamori, bi amiye tau vakoi tururu resi ina vene rofu raga boyadi. Mina sana di roka bi Solomon di yoro. ");
INSERT INTO kqc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kamini Peter yaku amiye tau tora veyori, ina vene rofu niyo, “Israel vene, beika resi mina rofu tururu resi una vei kara rededi? Ya yaku mokededi bi uniye uni vava dudu o Sei di mokena kana dudu mina amiye moi buni riyafa ma nana redo, ba? ");
INSERT INTO kqc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham di Sei, Isaac di Sei, ma Jacob di Sei, kaere bi uni tutubena vene di Sei, yaku ini naivo amiye Iesu rofu ini roka moi odoro riyo, idu ya vene yaku amiye di vanari aesi Pilate di nemokori moi etofa reyadi. Pilate yaku kaini diyaine vo niyo, idu ya bi ura de reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ina bi kikifa ma mokena rorobo amiye, idu moi etofa resi Pilate rofu bi amiye umuyeyo amiye usa niyadi ma ya maro. ");
INSERT INTO kqc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mina dada ya vene yaku Vegu ourefeidena amiye umuyeyadi. Idu Sei yaku muyena sanari gutuna moi dadiyo—una mina bi veyafa ma una diba. ");
INSERT INTO kqc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mina bi ini roka di vava yaku mina yuka no amiye rofu yeiva maro. Beika vesi diba niyadi bi mokena vari gira aena di roka dudu reyafa. Mokena vari gira Iesu rofu aena yaku ya vene tau vakoi di neri moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Usika ourena vene, na na diba bi ya toto dada reyadi, ma yi ourefeidena vene ka toto dada reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sei yaku senagi ini ago nidedi vene di vena dudu niyo bi, Keriso esika esika moigo, ye mina ago bi baesi rama aeyo mini. ");
INSERT INTO kqc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mina dada vegu no feresi moi etagae risi yi uka Sei rofu kero refa, ina yaku yi vegu no koite makugo dada. ");
INSERT INTO kqc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Minari gabi, Varika amiye Sei yaku yi vima di egira rena ari moi feidesi Iesu nifeidego, kaere bi Keriso ya rofu vo niyo amiye. ");
INSERT INTO kqc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Oma ideri amei bogo, ini meda beika baika moi ruaka rigi baego kumo, Sei yaku ini senagi senagi ago nidedi vene kikifa di vena dudu niyo kana. ");
INSERT INTO kqc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ye Moses yaku niyo, ‘Varika amiye yi Sei yaku ini ago nido amiye yokoi na kana yi usika ourena vene fogori moi ogau rigo. Ye ini ago tau ya vene rofu nigo mina neideyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kaere yaku mina Sei di ago nido amiye de neidegori, bi amiye di fogori gutuna moi etagae risi tunu rei vau rego.’ ");
INSERT INTO kqc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel ma Sei di ago niyadi vene tau vakoi gutuna baeyo gua, bi mina meda ka nigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sei yaku sina tau ini ago niyadi vene nigamo, ina yaku nitore resi yi tutubena venesa uka ago yokoi maka ni moi rama aeyadi bi ya vene di. Resi Abraham rofu niyo, ‘Yi tutubena vene gutuna konori gagani gagani amiye tau moi buni tora gade magida.’ ");
INSERT INTO kqc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Makai dada Sei yaku ini Naivo amiye vonisi ya vene rofu siko nifeideyo buni tora gade masi yi vegu no gutuna moi etagae rigi.” ");
INSERT INTO kqc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter ma John yaku amiye rofu sina nigamadiri, bi Sei ma amiye utari naivo vene, Sei nivakena yava di iya rena ourefeidena vene di tora, ma Sadducee vene okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gubuyo tora gade reyadi adina ina vene yaku amiye oteimagasa nigamadi bi muyena vene bi Sei yaku Iesu reyo kana dudusa muyena gutuna dadi rae regedi. ");
INSERT INTO kqc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mina dada moisi dibura yavari aeyadi ma ari uveyo, adina bi ari koina niyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Idu amiye tau yaku mina nifeidena vene beika sina niyadi mina neideyadiri, bi mokena vari gira Iesu rofu aeyadi; mina mokena vari gira aena vene bi 5,000 kana niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ari uveyori, bi Jew vene di ourefeidena vene, tora vene ma ago gira oteimana vene Jerusalem ri egogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, kaere bi Sei ma amiye utari naivo amiye tora, Caiaphas, John, ma Alexander inasa egogo reyadi. Sei ma amiye utari naivo vene tora tau noibanu ka mironari. ");
INSERT INTO kqc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ina vene yaku nifeidena vene ini neri aesi nikaiteyadi, “Ya bi beika vava dudu o beika roka dudu mina vegu reyadi?” ");
INSERT INTO kqc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kamini Peter, kaere bi Vima kikifa yaku ini uka vata baeyo, yaku ina vene nikabai resi niyo, “Amiye di ourefeidena vene ma tora vene: ");
INSERT INTO kqc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mina yuka no amiye rofu buni reyafa ma buni niyo dada gua una nikaitededi vonisi, ");
INSERT INTO kqc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ye ya tau noibanu ya diba, ma Israel vene tau ka ina diba, mina amiye gua yi neri are redo bi Iesu Keriso Nazareth amiye ini roka di vava dudu gauka yokoi de. Ya vene yaku mina amiye Iesu Keriso satauro ikoko reyadi ma Sei yaku muyenari gutuna moi dadiyo. ");
INSERT INTO kqc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sei di agori Iesu rofu yomakai bura reyo: ‘Yava akuna vene moi kekevata uyadi fore bi yava moi gira redo fore iniye niyo.’ ");
INSERT INTO kqc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Moi vegu rina bi Iesu rofu maka baku regifa; adina bi Sei yaku kono tora noibanuri roka yokoi una moi vegu rigika de maro.” ");
INSERT INTO kqc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kanisoro vene tau tururu reyadi Peter ma John bi ori de dudu sina niyadi dada. Ka vei mama reyadi ina vene bi sikuru buni yokoi de moiyadi vene resi bi Iesu sa ka ameyadi vene. ");
INSERT INTO kqc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma beika ago bi nigedi, moi buni riyo amiye bi Peter ma John sa are regamo ma veyadi dada. ");
INSERT INTO kqc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mina dada kanisoro vene di sana fereyaganedi niyadi ma yakuyadiri, bi iniye iniye nidodi regi kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Resi iniye nikaitegasa nigamadi, “Mina amiye remanu rofu beika regifa? Amiye tau gade Jerusalem ri bi ina diba mina rebe tora bi ina vene dudu reyo, ye mina bi de moi sui rigifa. ");
INSERT INTO kqc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Idu mina vegu amiye rofu urafo ga reyaine bi mina vene nigifa Iesu di roka dudu amiye yokoi rofu dudusa ga sina niyagane.” ");
INSERT INTO kqc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mina dada raka niyadi ma dudusa dui rei boyadi ma niyadi dudusa Iesu di roka ga nigedi ma amiye oteimana ga reyaganedi, de iniye iniye. ");
INSERT INTO kqc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Idu Peter ma John yaku ina vene nikabai resi niyadi, “Ya kaya va mokefa goina bi rama Sei di neri—yi ago neidegifa ba Sei di ago neidegifa? ");
INSERT INTO kqc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Adina bi beika vesi neideyafa mina rofu nisifa bi de feregifa.” ");
INSERT INTO kqc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kanisoro vene yaku ina vene ni moi ori iniye resi kamini nifeidesi yakuyadi. Ini kaunava maina reyadi idu de baku reyadi, adina amiye tau bi Sei di roka moi odoro rigamadi mina vegu reyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mina amiye, kaere bi mina moi buni riyo rebe ina fafau reyo, di lagani bi 40 ebu reyo. ");
INSERT INTO kqc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Minari maka nifeidesi yakuyadiri, bi Peter ma John ina vene di rafuri dairisi niyadi Sei ma amiye utari naivo vene di varika vene ma tora vene yaku beika ina rofu niyadi bi. ");
INSERT INTO kqc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mokena vari gira aena vene mina neideyadiri, bi ina tau noibanu egogo resi Sei rofu usa usa niyadi: “Varika amiye ya yaku oma, kono ma davara ma beika baika tau mina ideri riyo! ");
INSERT INTO kqc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Vima kikifa dudu uni tutubena David, yi naivo amiye rofu yomakai niyo: ‘Tutubena idana vene bi beika resi gubuyo tau reyadi? Beika resi amiye Sei rofu moi no rina mokena moi tavoi tavoi reyadi? ");
INSERT INTO kqc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kono di kini iniye iya regi dogo reyadi, ma ourefeidena vene bi egogo resi Varika amiye ma ini Keriso rofu moi no rina mokena moiyadi.’ ");
INSERT INTO kqc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ye, rama iniye mina taoni ideri Herod ma Pontius Pilate ma tutubena idana vene ma Israel venesa egogo resi Iesu rofu obe reyadi, kaere bi yi kikifa naivo amiye, ya yaku Keriso vo niyo. ");
INSERT INTO kqc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Egogo reyadi bi ya yaku yi vava ma yi ukari mina vegu sena vata niyainedi mokeyo mina regi reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ye, Varika amiye Sei, gua ini moi ori rena sina mina neidesi una yi moimai rei tavoi resifa vene una nima kumo ori de dudu yi sina nigifa. ");
INSERT INTO kqc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yi vava oteima kumo amiye buni niyagane ma yi naivo amiye kikifa Iesu di roka dudu rebe ma mokena vegu re.” ");
INSERT INTO kqc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Usa usa koina niyadiri, bi egogo reyadi sana mina yaga reyo. Vima kikifa yaku ina tau vakoi di uka vata baeyo ma Sei di sina bi ori de dudu kamini nigi kora regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mokena vari gira aena vene tau vakoi bi uka ma vima yokoi maka moisi amegamadi. Amiye yokoi yaku ini gugura dada nina de regamo, idu iniye iniye rau regamadi beika tau inasa amegamo bi. ");
INSERT INTO kqc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nifeidena vene yaku vava tora dudu Varika amiye Iesu Keriso muyena sanari gutuna dadi rae reyo sina mina ni digamadi. Ma Sei yaku ina vene tau noibanu fafau buni tora gade iniye magamo. ");
INSERT INTO kqc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ina vene di rafu fogori bi yokoi yaku vana tu nina de regamo. Adina bi kaere kono kefuka nufa ma yava nufa bi mina sero resi voi regamadi fore bi moi bosi ");
INSERT INTO kqc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nifeidena vene rau regika di neri aegamadi; ma kaere yaku ini beika toe mokegamo kana mina fore moisi rau regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amiye yokoi roka Joseph, kaere bi nifeidena vene yaku roka niyadi bi Barnabas (ini adina bi “yeiva mado amiye di mida”). Ina bi Levi di tutubena amiye yokoi ma Cyprus ri vata niyo. ");
INSERT INTO kqc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ina yaku ini kono kefuka yokoi sero resi fore moi baesi bi nifeidena vene di neri aeyo. ");
INSERT INTO kqc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kamini amiye yokoi roka Ananias ini rema Sapphira sa, kaere bi mokena vari gira aena venesa digamadi, ini kono kefuka yokoi sero reyadi, ");
INSERT INTO kqc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","idu fore be bi iniye di moi gira resi be maka nifeidena vene maro. Ini rema bi ina diba ini maruka yaku beika reyo bi. ");
INSERT INTO kqc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kamini Peter yaku ina rofu niyo, “Ananias, yi kono sero regasa fore be moi gira reyo. Beika resi Satani fereyo ma baesi yi uka vata baeyo ma Vima kikifa rofu ofa niyo? ");
INSERT INTO kqc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mina kono kefuka sero rena koderi, mina bi yi, ma sero reyori di fore ka bi yi. Beika resi yi ukari makai regiya mokena moiyo? Ya bi diya amiye rofu ofa niyo, idu ya bi Sei rofu ofa niyo!” ");
INSERT INTO kqc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kamini minari maka Ananias yaku mina neidegasa keto resi muyeyo; amiye tau mina neideyadiri, bi ori rei vau reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Godua vene yaku dui rei baesi ini roaita kumu risi moi yakusi guri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ye meda nemoko regodenu kana koina niyori, bi ini rema dui rei baeyo, idu ina bi ina toto beika vata niyo bi. ");
INSERT INTO kqc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter ini vanari Ananias yaku maro fore moi gira regasa Sapphira nikaiteyo, “Na ni kumo yi marukasa yi kono sero reyadi fore tau vakoi bi mini ba?” Nikabai resi niyo, “Yo, fore tau vakoi bi mini.” ");
INSERT INTO kqc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kamini niyo, “Beika resi ya yi marukasa Varika amiye di Vima rofu ebene reyadi? Ve kumo, yi maruka moi disi guri aeyadi vene bi ida venari mironi, ye ya ka uakai moi digedi!” ");
INSERT INTO kqc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Minari maka Peter di yuka atafu keto resi muyeyo. Godua vene dui rei baesi rema muyeyo vesi uakai yakusi ini maruka atafuri guri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kamini mina medari ekalesia vene tau ma be vene ka mina sina neidegasa bi ori tora gade reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nifeidena vene yaku mokena vegu tau ma rebe tau amiye di fogori regamadi. Mokena vari gira aeyadi vene tau vakoi uka yokoi maka dudu Solomon di yorori egogo regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amiye idana yaku mina rafuri boi dui rena bi ori regamadi, idu mina vene bi ina vene di roka moi odoro rigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amiye besa besa mina rafuri bae dui regamadi—rema rumana tau tora kaere bi mokena vari gira Varika amiye rofu aegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Oteimana vene yaku mina vegu regamadi dada, gauka vene taoni idari ekama fafau uakaisi ae feregamadi, Peter baesi ebu rei bogori ini vima ina vene be fafau yarego di. ");
INSERT INTO kqc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Amiye tau gade iniye Jerusalem adinari taoni keika keika gutuna baesi ini gauka vene ma kaere ini roaita ideri vima no nufa vene afei baegamadi; ina tau vakoi moi buni rigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kamini Sei ma amiye utari naivo amiye tora ma ini moi vana rededi vene, kaere bi Sadducee vene be, nifeidena vene rofu maunu tora gade iniye niyadi; dada vegu yokoi regedi di mokena moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nifeidena vene moi gira resi vegu no rededi vene di dibura yavari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Idu mina urusari bi Varika amiye di naivo naivo vima yokoi yaku mina dibura di ida vena ekesi bi nifeidena vene ourefeideyo ma yakuyadi ma ina vene rofu niyo, ");
INSERT INTO kqc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bosi Sei nivakena yavari are resi Iesu usi dina vegu di sina tau amiye tau rofu nifa.” ");
INSERT INTO kqc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nifeidena vene mina ago neideyadiri, ari uveyori bi dadi bosi Sei nivakena yavari dui resi kamini amiye oteimagi kora reyadi. Sei ma amiye utari naivo amiye tora ini moi vana rededi venesa boyadiri, bi kanisoro vene, Israel vene di tora vene tau vakoi, raka niyadi egogo reyaganedi; makai resi bi ago nifeideyadi nifeidena vene dibura yavari gutuna ina vene di neri afei baeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Idu ini nari rededi vene bosi dibura yavari okigasa nifeidena vene de baku reyadi, ye dairisi kanisoro vene nioteimaradi beika veyadi ");
INSERT INTO kqc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","mina niyadi, “Dibura yavari bosi okiyafari, bi ini ida vena bi biri ri gira reyadi ma iya rededi vene ka nari rei amegamadi mina veyafa; idu dui reyafari, bi amiye yokoi ideri de baku reyafa!” ");
INSERT INTO kqc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sei nivakena yava di iya rededi vene di amiye tora ma Sei ma amiye utari naivo vene di varika vene mina sina neideyadiri, ini mokena bi forovai iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kamini amiye yokoi dui rei baesi ina vene rofu niyo, “Neidefa! Dibura yavari aeyadi vene bi Sei nivakena yava ideri are resi amiye oteimadedi!” ");
INSERT INTO kqc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ye iya rededi vene di amiye tora ini nari rededi venesa dadi bosi nifeidena vene iya rena rofu de afei dairi deyadi, adina bi ori reyadi amiye yaku fore dudu umuyegedi baebu. ");
INSERT INTO kqc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nifeidena vene afei dui regasa niyadi kanisoro vene di nemokori moi are reyadi ma Sei ma amiye utari naivo amiye tora yaku nikaitegasa ");
INSERT INTO kqc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","niyo, “Una yaku sena ago gira ya niyafa, mina amiye di roka dudu amiye oteimana ga refo vo niyafa; idu vefa beika reyadi bi! Yi oteimadedi sina bi Jerusalem gagani tau vakoiri moi urafo reyadi ma yi muyena bi uni vanari aegedi vonisi rededi!” ");
INSERT INTO kqc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ye Peter ma nifeidena vene besa nikabai resi niyadi, “Una bi Sei di ago neidegifa, idu amiye di ago bi de. ");
INSERT INTO kqc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ya vene yaku satauro odorori ikoko resi umuyeyadi fufutari bi uni tutubena di Sei yaku Iesu muyenari gutuna moi dadiyo. ");
INSERT INTO kqc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Sei yaku moi dadisi uni Varika amiye ma una Moi vegu rina amiye kana ini vana rama rofu aesi bi Israel vene vegu no feresi etagae rigedi, ini vegu no koitego mina ida maro. ");
INSERT INTO kqc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Una bi mina beika vata niyo bi vesi neideyafa vene—una ma Vima kikifa, kaere bi Sei yaku ini ago neidededi vene rofu maro.” ");
INSERT INTO kqc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kanisoro vene yaku mina sina neidegasa ada fairo resi nifeidena vene umuyegedi mokena moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Idu, ina vene di amiye yokoi, roka Gamaliel, ina bi Pharisee amiye, kaere bi ago gira oteimana amiye ma amiye tau vakoi yaku ina nivasena reyadi, dadisi kanisoro vene di neri are reyo. Ina yaku niyo dada nifeidena vene bi ne tumu maka etofaro moi yakuyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Resi kanisoro vene rofu niyo, “Israel vene, beika mina vene rofu regedi bi mokei mona refa. ");
INSERT INTO kqc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Senagi amiye yokoi roka Theudas baeyo iniye nigika bi ina bi amiye tora yokoi ma amiye 400 kana inasa auta regasa digamadi. Idu, ina umuyeyadiri, bi ini usi dina vene firifari ni diyadi resi ini moimai evata risi regamadi mina ka minari maka koina niyo. ");
INSERT INTO kqc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mina usi bi, Galilee amiye yokoi roka Judas bi amiye di roka moina ariri ogau niyo; amiye be ina ka usi digamadi, idu ina ka umuyeyadi ma ini usi dina vene ka firifari ni diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mina dada gua yomina vene rofu beika yokoi ga refa. Ferefa adina yomina mokena regi bi amiye yaku reyadi moimai vonisi bi tovo nigo, ");
INSERT INTO kqc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","idu Sei rofu baeyo vonisi, bi de uketo regedi Sei sa ruda rebigedi baebu!” Kanisoro vene Gamaliel di ago moi gira riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nifeidena vene raka niyadi ma dui reyadiri, bi buburu vai resi usi niyadi Iesu di roka dudu dudusa ago ga niyagane resi moi feideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nifeidena vene kanisoro vene ferei yakugasa bi ada reyadi, adina bi Sei yaku ina vene rofu mokei buni resi moi odoro riyo Iesu di roka fafau maena moiyadi dada. ");
INSERT INTO kqc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Resi ari neinei Sei nivakena yava ideri ma amiye di yava yokoi yokoiri Iesu bi Keriso ini ago buni amiye rofu oteimagamadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mina ariri, usi dina vene bi tora ni baegamori, Greek ago nidedi Jew vene bi Hebrew ago nidedi Jew venesa kayamo reyadi. Greek ago nidedi vene yaku nigamadi bi iruku rau regasa bi ini obu vene bi de mokededi. ");
INSERT INTO kqc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mina dada, nifeidena vene 12 yaku usi dina vene raka niegogo resi niyadi, “Iruku rau regifa vonisi, Sei di ago nirausi resifa mina gedu magifa bi buni de. ");
INSERT INTO kqc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ye mina dada, usika ourena, yi fogori amiye 7 auba refa kaere bi Vima kikifa yaku ini ukari vata baeyo ma mokena tora nufa. Makai dudu una yaku mina moimai regedi di moi aegifa. ");
INSERT INTO kqc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kamini uniye uni moimai ari dobari bi Sei rofu usa usa nigasa ini ago ni digifa.” ");
INSERT INTO kqc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ina tau vakoi bi nifeidena vene yaku ini beika niyadi mina rofu ada reyadi, dada Stephen moiyadi, kaere Iesu rofu bi mokena vari gira iniye aegamo ma Vima kikifa yaku ini ukari vata baeyo. Ina ka bi Philip, Prochorus, Nicanor, Timon, Parmenas, ma Nicolaus kaere bi Antioch amiye ma Jew vene di Sei nivakena vegu usi digamo mina moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mina vene bi nifeidena vene rofu maradi; dada usa usa nisi mina vene fafau vana aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ye, Sei di ago kamini urafo regamo. Usi dina vene Jerusalem ri bi tora gade ni baegamo. Ma Sei ma amiye utari naivo vene tau tora ka mina mokena vari gira aena mina reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen, kaere bi Sei yaku buni tora gade iniye ma vava tora maro, mina yaku mokena vegu tora ma rebe amiye di fogori regamo. ");
INSERT INTO kqc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Idu amiye be bi uka yokoi maka de dudu ini beika regamo mina rofu; ina vene bi usa usa yava yokoi roka Erufuna vene, kaere bi gagani gagani roka Cyrenia, Alexandria, Cilicia ma Asia ri amededi Jew vene. Ina vene vakoi gogo resi kamini Stephen sa kayamo reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Idu Vima yaku mokena tora Stephen maro, dada ini sina nigamori, bi ina vene yaku ini ago dairi nikabai rena bi anua reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ye ina vene yaku amiye be ofa nigi nisui dudu niyadi, “Neideyafa ina bi Moses ma Sei di ago rofu ago no niyo!” ");
INSERT INTO kqc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mina ida dudu bi taoni vene, tora vene ma ago gira oteimana vene di uka moi dadiyadi. Kamini Stephen rofu baesi moi gira resi kanisoro vene rofu afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ye, amiye be moi dui reyadi ina rofu ofa sina nigedi vonisi. Yomakai niyadi, “Yomina amiye bi ari neinei mina Sei nivakena yava kikifa ma Moses di ago gira rofu ni no redo. ");
INSERT INTO kqc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Iesu Nazareth amiye yaku mina Sei nivakena yava ufeya resi Moses yaku beika vegu uni tora vene maro ma gua una rofu bi moi idana rigo, vo niyo ma neideyafa!” ");
INSERT INTO kqc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kanisoro ideri amegamadi vene tau gade yaku Stephen di ne uruma vegamadiri, bi ini ne uruma bi Sei di naivo naivo vima yokoi kana niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kamini Sei ma amiye utari naivo amiye tora yaku Stephen nikaiteyo, “Mina bi rama ba?” ");
INSERT INTO kqc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma nikabai resi niyo, “Usika ourena ma baba vene, na neidefa! Abraham, Haran gaganiri amena koderi bi Mesopotamia gaganiri amegamo. Minari amegamori, bi Sei vabara iniye ina rofu ogau nisi ");
INSERT INTO kqc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","makai niyo, ‘Yi gagani ma yi davatu feresi ya oteimagida gagani mirona bogiya.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mina dada Chaldea vene di gagani ferei bosi Haran gaganiri amegamo. Abraham di baba muyeyori, bi Sei yaku yomina gaganiri moi baeyo, gua minari amededi mini. ");
INSERT INTO kqc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Idu mina ariri Sei yaku kono yokoi ini vonisi de maro, kono kefuka yokoi mina ka de iniye iniye. Idu Sei yaku sina nitore resi niyo bi ina rofu ma ini tutubena vene mago vo niyo. Sei yaku mina sina nitore reyo ariri, bi Abraham bi mida koina. ");
INSERT INTO kqc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yomakai niyo: ‘Yi tutubena vene bi okina vene kana yava ika vene di gaganiri amegedi ma lagani 400 ri moimai rei tavoi rena vene kana vegu no ina rofu rebigedi. ");
INSERT INTO kqc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Idu na yaku mina gagani yi tutubena vene bi moimai rei tavoi rededi vene rofu kota regida ma mina fufutari bi mina gagani ferei yakusi yomina sanari na nivakegedi.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma Sei roaita nugana di vegu uka ago yokoi maka niyo di rebe kana Abraham maro. Mina dada Abraham bi ini mida Isaac di baba niyori, ma fura yokoi koina niyori, bi ini roaita nugaro; Isaac yaku ini mida Jacob di baba niyo, ma Jacob yaku ini mida 12, kaere bi uni vene di tutubena tora, di baba niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mina tutubena 12 ri Joseph rofu maunu nisi Egypt ri sero reyadi. Idu Sei bi inasa, ");
INSERT INTO kqc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","resi ini toe moigamo sanari moi vegu rigamo. Joseph bosi Pharaoh, Egypt di kini di nemokori are reyori, bi Sei yaku reremama buni ma mokena tora maro. Pharaoh yaku Joseph Egypt gaganiri moi gavana risi ini yava, ini gugura fore tau vakoi Joseph di vanari fereyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ye mirona ariri Egypt ma Canaan gaganiri bi adabo yokoi are reyo ma amiye esika esika moiyadi. Uni tutubena vene ka iruku de baku reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mina dada Egypt ri iruku nufa Jacob mina neideyori, bi ina siko uni tutubena vene mironari nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ye dudusa dairi neyadiri, bi Joseph iniye ina bi kaere ini dubuiyaka vene rofu niogau reyo ma mina ariri Pharaoh ka Joseph di usika ourena diba niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mina dada Joseph yaku ini baba Jacob rofu degi ago yokoi nifeideyo, ye ini usika ourena tau vakoisa dadisi Egypt ri deyadi, ina tau vakoi bi 75. ");
INSERT INTO kqc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kamini Jacob Egypt ri nesi bi mina sanari uni tutubena venesa amei bosi muyeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ini roaita bi moi baesi Shechem gaganiri guri aeyadi. Mina sana bi Abraham yaku Hamor di tutubena vene rofu fore dudu sena voi reyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Sei yaku Abraham rofu beika sina nitore reyo mina regi okiyori, bi uni vene Egypt gaganiri bi tora iniye niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kamini kini yokoi kaere bi Joseph bi ina toto, yaku bi Egypt nari regamo. ");
INSERT INTO kqc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Uni vene eru resi nari rei no regamo; dada ago gira niyo ini mida keika keika yavari gutuna etofaro moi yakuyaine ma muyegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mina ariri, Moses vata niyo. Ina bi Sei di nemokori mida safi iniye. Ini nono baba yaku eyo regodenu nari reyadi, ");
INSERT INTO kqc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ye ini yavari gutuna etofaro moi yakuyadiri, bi Pharaoh di vefa yaku afei bosi iniye di mida kana nari reyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt vene di mokena tora tau vakoi oteimaradi, ma ini agori ma ini reremamari amiye tora yokoi niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses ini lagani bosi 40 niyori, bi ini dubuiyaka, Israel di tutubena vene vegi mokena moiyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Egypt amiye yokoi yaku ini amiye yokoi rofu rei no regamo ma veyo, dada aedegi nesi bi ini vegu no di obini rofu Egypt amiye umuyeyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Ina yaku mokeyo bi ini usika ourena vene yaku diba nigedi Sei yaku ina dudu ina vene moi vegu rigo, idu diba de niyadi.) ");
INSERT INTO kqc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ari uveyori, bi Israel amiye remanu ruda rededi ma veyo, resi uka yokoi maka niyaganedi, bi bosi ina vene rofu niyo, ‘Ya rumana vene, neidefa kumo, ya vene bi dubuiyaka, beika resi ya kaya rofu esika madedi?’ ");
INSERT INTO kqc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Idu amiye yokoi, kaere bi ini asini rofu esika magamo, yaku dadisi bi Moses beku resi nikaiteyo, ‘Kaere yaku vava ya maro ma una fafau ourefeidesi kota regiya dada? ");
INSERT INTO kqc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Agiya mirona Egypt amiye umuyeyo kana na umuyegiya ba?’ ");
INSERT INTO kqc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses mina neidegasa bi Egypt gaganiri gutuna ori disi yava ika amiye kana Midian gaganiri amegamo. Mironari bi ini rumana mida remanu vata niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ye lagani 40 koina niyori, gagani autu sanari, omuna roka Sinai ri, Varika amiye di naivo naivo vima yokoi imiye yabo tafa vaigamo di fairo ideri Moses rofu ogau niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses mina vegasa bi tururu resi mina atafu vei mona mona regi boyo. Kamini minari Varika amiye di goroka neideyo: ");
INSERT INTO kqc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na bi yi tutubena vene di Sei; mina bi Abraham di Sei, Isaac di Sei, ma Jacob di Sei.’ Moses tururu resi bosi vena de reyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Varika amiye yaku ina rofu niyo, ‘Yi yuka ro younegiya, mina are reisa sana bi kikifa kono. ");
INSERT INTO kqc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne resi vegasa bi nai vene di esika esika Egypt ri veyaka. Ini anana nina neidesi mina erufugika deyaka. Bae kumo na yaku ya nifeidegida ma Egypt ri negiya.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Israel vene yaku mina Moses gedu masi makai nikaiteyadi, ‘Kaere yaku vava ya maro ma una fafau ourefeidesi kota regiya dada?’ Idu Sei yaku mina amiye una ourefeidesi Egypt gutuna ni feresi yakugika kana nifeideyo. Sei di naivo naivo vima yokoi, kaere bi imiye yabo tafa vaigamo sanari ogau niyo, yaku ka aedeyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Israel vene Egypt ri ourefeidesi moi yakuyo. Ina ka mokena vegu ma rebe Egypt gaganiri ma Davara kakari resi mina gagani autu sanari lagani 40 ri regamo. ");
INSERT INTO kqc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mina Moses yaku Israel vene rofu niyo, ‘Sei yaku ini ago nido amiye yokoi na kana yi usika ourena vene di fogori moi ogau rigo.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mina bi Israel venesa gagani autu sanari egogo reyadi. Ina bi uni tutubena venesa mironari ma Sinai omuna ikari Sei di naivo naivo vima yaku sina nimarori, bi ina ka mironari Sei di vegu ago moisi una rofu gua mago dada. ");
INSERT INTO kqc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Idu uni tutubena vene yaku Moses di ago neidena bi ura de resi eta rofu ebeku resi ini ura bi Egypt ri dairigedi. ");
INSERT INTO kqc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mina dada Aaron rofu niyadi, ‘Uni sei be ri kumo ina yaku una ourefeidegedi. Adina una una toto mina Moses rofu bi beika vata niyo, kaere yaku bi Egypt gaganiri gutuna una afei baeyo.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mirona ariri, boromakau di mida yokoi kana riyadi, aira ofa sei rofu ori sisika resi ini mina riyadi rofu ada reyadi dada. ");
INSERT INTO kqc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mina dada Sei yaku ini vene gutuna seira kero resi oma di iya tau rofu nivakegi maro, Sei di ago niyadi vene di bura reyadi kana: ‘Israel vene! Lagani 40 ri gagani autu sanari boromakau usi ori sisika regamadi bi diya na dada regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ofa sei roka Molech di karaga yava ka uakaisi ofa sei roka Rephan di iya kana uakaigamadi; mina bi ya yaku ofa sei di vima nivakegi riyadi. Mina dada ya ka Babylon fufuta rofu ya moi etagae rigi regida.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Uni tutubena vene yaku gagani autu sanari amegamadiri, bi Sei di kikifa karaga nufa. Mina kikifa karaga yava yaku Israel vene oteimagamo bi Sei bi ina venesa. Sei yaku Moses rofu oteimaro kana riyadi; resi Moses nioteimaro gokai akugedi mina vesi riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Gabi uni tutubena vene yaku ini baba vene rofu mina kikifa karaga yava moisi mina konori Joshua sa moi uakai boyadi. Mina ariri Sei yaku uni tutubena vene rofu mirona gagani vene moi etagae riyo ma ini kono moiyadi. Ma minari mina kikifa karaga yava amei boyo mamo David di amegamo ari ogau niyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David yaku Sei di uka ada rena moisi Sei rofu usa niyo bi ina yaku nigo, Jacob di Sei di amena sana yokoi akugo ba ide mina. ");
INSERT INTO kqc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Idu Solomon yaku ina rofu ini yava akuyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Idu Sei di ago niyo amiye yaku niyo kana, Sei odoro iniye bi amiye yaku akudedi yavari bi de amedo: ");
INSERT INTO kqc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Varika amiye niyo, Oma bi nai ourefeidena amena fata, ma kono tora noibanu bi nai yuka aena sana. Yava yokoi de na rofu akugedi. Ma nai asa moina sana bi goinari? ");
INSERT INTO kqc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mina beika tau bi na yaku maka riyaka dada.’ ");
INSERT INTO kqc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ya bi ada gira ma uka gira vene! Gokai resi Sei di ago rofu bi anema kora rededi! Ya vene bi yi tutubena vene kana: ya vene ka Vima kikifa rofu neidena de rededi! ");
INSERT INTO kqc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yi tutubena vene yaku goina Sei di ago niyo amiye rofu esika esika de maradi ba? Sei di ago moi raga regamadi vene umuyegamadi, kaere bi ina vene yaku sena ni digamadi bi ini Mokena rorobo amiye dego, mina resi gua bi ya vene yaku ini siri resi umuyena vene niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sei yaku ini naivo naivo vima dudu ini ago gira ya vene maro—idu ya vene bi mina ago gira de neideyadi!” ");
INSERT INTO kqc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kanisoro vene yaku Stephen di sina neideyadiri, bi gubuyo yaku no iniye nisi ini ada fairo reyadi ina rofu. ");
INSERT INTO kqc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Idu Stephen, kaere bi Vima kikifa yaku ini ukari vata baeyo, oma ne odorori bi Sei di vabara ma Iesu bi Sei di vana rama rofu are regamo mina veyo. ");
INSERT INTO kqc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Resi niyo, “Vefa, oma ekeyo ma Amiye di mida bi Sei di vana rama rofu are redo mina veida!” ");
INSERT INTO kqc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ye kanisoro vene goroka tora dudu ababa nisi ini vana dudu ini anema fafa riyadi. Resi bi ina tau vakoi minari Stephen rofu gobunori urana raga boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Taoni etofaro rofu umeki resi fore dudu umuyeyadi. Ninegau reyadi vene yaku ini varuka be bi mida godua yokoi roka Saul di atafuri fereyadi. ");
INSERT INTO kqc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Fore dudu ugamadiri, bi raka nisi niyo, “Varika amiye Iesu, nai vima moi!” ");
INSERT INTO kqc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ini efuka meimisi goroka tora dudu ababa nigasa niyo, “Varika amiye, mina vegu no rededi bi ini kaunava mana mokena bi ga moi!” Mina nisi muyeyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Saul yaku Stephen umuyeyadi mina moi rama aeyo. Stephen umuyeyadi ariri gutuna bi Jerusalem ri amegamadi bi ekalesia vene rofu esika esika iniye magamadi. Ekalesia vene ori resi Judea ma Samaria gagani tauri rerevaida nisi diyadi. Nifeidena vene maka ori dina de reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ye Sei rofu nivakededi mokena vene be yaku Stephen rofu isaka nisi goroka tora dudu guruo resi guri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Idu Saul yaku bi ekalesia vene moi no regi regamo; yava neinei dui regasa rema rumana moi erokoko regasa dibura yava ideri aegamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mina dada mokena vari gira aeyadi vene, kaere bi gagani gaganiri rerevaida nisi diyadi, yaku sina buni niodoro regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip yaku Samaria taoni tora rofu boi nesi mironari amededi vene rofu Keriso di ago nirausi regamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Amiye tau vakoi yaku egogo resi ini nigamo sina rofu neide mona resi rebe regamo mina ka vegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vima no amiye tau gade di roaita ideri gutuna ababa nigasa yakugamadi; dibo anua vene ma yuka no vene ka moi buni rigamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ye mina taoniri bi ada tora gade reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mina taoniri bi amiye yokoi roka Simon amegamo. Be ari bi ina yaku amiye di mokena moi forovai regamo, ini yaumana regamo dudu. Ina kaya nigika bi amiye tora yokoi vo nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ye amiye tau gade mina taoniri, keika gutuna boyo amiye tora, yaku Simon di ago neide mona regamadi. Ye yomakai nigamadi, “Mina amiye di roka bi ‘Sei di vava tora iniye.’” ");
INSERT INTO kqc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ina yaku ini yaumana dudu mina vene di mokena bi senagi moi forovai reyo, dada ini beika nigamo tau rofu neide mona regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Idu mina amiye tau yaku Philip di ago Sei di ourefeidena amena sana ma Iesu Keriso di rokari ago buni nigamo mina neidesi mokena vari gira aeyadiri, bi rema rumana babatiso reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon iniye ka Iesu Keriso rofu mokena vari gira aeyo; babatiso reyo fufutari, bi Philip atafu amegamo. Philip yaku rebe ma mokena vegu tora regamo mina vegamori, bi tururu iniye regamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nifeidena vene Jerusalem ri amegasa bi Samaria vene bi Sei di ago moiyadi mina neideyadiri, Peter ma John ina vene rofu nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bosi okiyadiri, bi ina rofu usa usa niyadi Vima kikifa moiyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Adina Vima kikifa bi ina vene fafau yokoi dena kode; ina vene bi Varika amiye Iesu di roka dudu maka babatiso reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kamini Peter ma John ina vene di ada fafau vana aeyadi mamo bi Vima kikifa moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon yaku veyo bi nifeidena vene yaku ina vene di ada fafau vana aeyadiri, bi Vima moiyadi. Resi mina dada fore be Peter ma John magika ");
INSERT INTO kqc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","resi niyo, “Mina vava ka na mafa kumo amiye tau kaere nai vana ina fafau aegidari, bi Vima kikifa moiyainedi.” ");
INSERT INTO kqc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Idu Peter yaku nikabai resi niyo, “Ya yi foresa ita mokari digedi bi buni, ya yaku mokeisa bi Sei yaku nitore reyo beika bi fore dudu voi regiya! ");
INSERT INTO kqc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uni moimairi ya bi vana aena ga re, ma beika baku regifari, ya bi de baku regiya, adina Sei di nemokori yi uka meko bi rorobo de. ");
INSERT INTO kqc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mina dada yi vegu no ferei moi etagae risi Varika amiye rofu usa usa nigiya kumo yi mina mokena moiyo mina koite makugo. ");
INSERT INTO kqc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Adina ya ya veida bi yi uka bi gonema tau yaku vata baeyo ma mokena rorobo de yaku ya moi dibura aeyo.” ");
INSERT INTO kqc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ye Simon yaku niyo, “Ya usa nida Varika amiye rofu na dada usa usa nifo kumo yomina beika niyadi sina na rofu mina ga vata niyainedi.” ");
INSERT INTO kqc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma Iesu Keriso di ago rofu niokusi Varika amiye di ago ni vau reyadi koina niyori, bi Jerusalem dairiyadi. Idau bogasa bi Samaria vene di rautu rauturi sina buni nirausi regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Varika amiye di naivo naivo vima yokoi yaku Philip rofu ago nisi niyo, “Dadisi meda dadido vana enana eta rofu ida goina bi Jerusalem gutuna Gaza rofu boyo minari ne.” (Mina bi gagani autu sana di ida.) ");
INSERT INTO kqc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ye Philip dadisi neyo. Mironari Ethiopia ourefeidena amiye tora, kaere bi Ethiopia vene di kuini Candace di gugura fore nari redo amiye, bi Jerusalem ri Sei nivakegi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ini kariota fafau keu risi ini rauturi dairi bogamori, bi Sei di ago niyo amiye Isaiah di bura reyo kana mina vegamo. ");
INSERT INTO kqc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Vima kikifa yaku Philip rofu niyo, “Yomirona kariota atafu bogiya.” ");
INSERT INTO kqc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ye Philip raga boi neyori, bi ina bi Sei di ago niyo amiye Isaiah di bura vegasa ini ago nigamo mina neidesi nikaiteyo, “Ya beika bura reyo mina vegasa bi diba nisa ba de?” ");
INSERT INTO kqc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Amiye tora yaku nikabai resi niyo, “Amiye yokoi yaku na oteimago vonisi bi diba nigida.” Resi raka niyo ma kariota ri keu risi inasa ameinu reyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sei di ago bura rena vegamo bi mini: “Mamoe umuyegika afei boyadi kana, ma mamoe mida di ueta nugadedi vene di budari babo nido kana, bi ago yokoi de niyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Moi maena resi kota rena di ida dudu kota de reyadi. Ini tutubena vene bi kaere yaku nigo? Ini adina bi ini vegu mina konori bi koina niyo mini.” ");
INSERT INTO kqc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ourefeidena amiye yaku nikaiteyo, “Na ni, mina Sei di ago nido amiye bi kaere nigika nido? Iniye rofu nido ba amiye yokoi rofu nido?” ");
INSERT INTO kqc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kamini Philip ago nigi kora reyo; Sei di ago mina one ideri gutuna boyo Iesu di ago buni nioteimaro. ");
INSERT INTO kqc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ida boyadiri, bi koru yokoiri baesi okiyadi ma ourefeidena amiye yaku niyo, “Koru bi mini. Beika resi na bi babatiso de regida?” ");
INSERT INTO kqc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ourefeidena amiye yaku niyo dada kariota raga redo mina baesi are reyo. Philip mina amiyesa vakoi gogo koru ideri neyadiri, bi ina babatiso reyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Koruri gutuna dadi baeyadiri, bi Varika amiye di Vima yaku Philip moi etagae ri diyo. Ourefeidena amiye yaku ina dudusa de veyo, idu ada tora iniye regasa ini idama neyo. ");
INSERT INTO kqc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Idu Philip bi Azotus ri okiyo; resi taoni neinei ago buni ni digasa bosi Caesarea ri okiyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Neituari Saul bi toga toga Varika amiye di usi dina vene rofu ni moi ori rena sina ma umuyena sina nigamo. Resi Sei ma amiye utari naivo amiye tora rofu bosi ");
INSERT INTO kqc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","usa niyo, usa usa yava rofu reyadi fefa marainedi ma bi Damascus taoniri di Varika amiye di Vegu dudu dibo rededi rema rumana vene be maina rego di. Veitao regasa moisi Jerusalem ri afei dairisi dibura yavari aegika. ");
INSERT INTO kqc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kamini Saul Damascus taoni atafu bae okigi redori, minari maka vabara yokoi omari gutuna ina atafu kamanika rei deyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Konori keto resi bi goroka yokoi neideyo ina rofu yomakai nigamo, “Saul! Beika resi na esika esika maisa?” ");
INSERT INTO kqc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma nikaiteyo, “Varika amiye, ya bi kaere?” Ma niyo, “Na bi Iesu kaere ya yaku esika esika maisa. ");
INSERT INTO kqc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Idu dadisi taoniri bo. Mironari bi ya nigo beika regiya bi.” ");
INSERT INTO kqc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saul sa vakoi baegamadi vene bi are resi bere nisi sina yokoi nina de reyadi; goroka bi neideyadi idu amiye yokoi de veyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul konori gutuna dadiyo, idu ne aregasa bi gagani de veyo. Mina dada vanau risi Damascus ri afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ma meda regodenuri beika yokoi de veyo. Mina ariri ka koru ma iruku yokoi irina de reyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kamini bi Varika amiye di usi dina amiye yokoi ini roka bi Ananias, kaere bi Damascus ri amegamo. Yaduka kana veyo ma Varika amiye raka niyo, “Ananias!” Ma nikabai resi niyo, “Varika amiye na mini.” ");
INSERT INTO kqc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma niyo, “Dadisi bi ida roka Rorobo rofu bo. Resi Judas di yavari, Tarsus amiye yokoi ini roka bi Saul nikaite. Ina bi usa usa nigasa amedo. ");
INSERT INTO kqc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Resi ini yaduka kana dudu amiye yokoi veyo, kaere ini roka bi Ananias, ina yaku bae dui resi ini vana ina fafau aeyo ma dudusa ne areyadi.” ");
INSERT INTO kqc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Idu Ananias nikabai resi niyo, “Varika amiye, amiye tau tora yaku mina amiye di sina na niyadi, beika vegu no reyo Jerusalem ri yi vene rofu. ");
INSERT INTO kqc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ina bi Sei ma amiye utari naivo vene di varika vene rofu vava moisi mina dudu ya rofu nivakededi vene moigika minari baeyo.” ");
INSERT INTO kqc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Idu Varika amiye yaku ina rofu niyo, “Bo, ini adina bi na yaku nai moimai regika omaraka, nai roka tutubena idana vene ma varika amiye ma Israel vene rofu nigika. ");
INSERT INTO kqc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Resi na dada esika tau moigo mina oteimagida.” ");
INSERT INTO kqc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kamini Ananias boi nesi Saul yaku amedo yava mina dui resi ini vana ina fafau aeyo. Resi niyo, “Nai dubuini Saul, Varika amiye yaku na nifeideyo—iniye bi Iesu, kaere bi minari baegasa idauri ya rofu ogau niyo. Na nifeideyo bi dudusa ne aregiya ma Vima kikifa yaku yi roaita ideri vata baego.” ");
INSERT INTO kqc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Evade oyena ireka kana ini nemokori gutuna yareyadi ma dudusa ini ne areyadi. Dadisi are reyo ma babatiso reyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kamini iruku iriyori, bi ini yeiva roaitari dairi baeyo. Saul Damascus ri usi dina venesa meda be kana ameyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Evade usa usa yavari dui resi Iesu bi Sei di mida nirausi regi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ini sina neidegamadi vene tau tururu resi nikaiteyadi, “Mina amiye yaku Jerusalem ri mina amiye Iesu nivakegamadi vene moi no rigamo, ba? Ina minari ka mina vene moigika Sei ma amiye utari naivo vene di varika vene rofu dairisi baeyo.” ");
INSERT INTO kqc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Idu Saul yaku Iesu dada ini sina nirausi regamo; bi vava iniye nisi Iesu bi Keriso moi vegu rido amiye nirorotari resi ka amiye di uka moina iniye regamo, dada Jew vene Damascus ri amegamadi bi nikabai rena bi anua iniye regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Meda tau koina niyori, Jew vene egogo resi Saul gokai umuyegedi mina di sina nidodi reyadi, ");
INSERT INTO kqc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","idu ina ugedi sina bi sena nioteimaradi. Uru ari bi taoni ida vena vegamadi ina umuyegedi vonisi. ");
INSERT INTO kqc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Idu urusa yokoiri Saul di usi dina vene yaku ina moisi foroka tora yokoi ideri merisi taoni di biri etofaro moi feideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul Jerusalem ri baegasa usi dina venesa vakoi gogo niyagane vonisi mokeyo, idu mokena vari gira aena de aeyadi ina ka usi dina amiye yokoi bi. Resi ina tau noibanu ina rofu bi ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kamini Barnabas yaku aedesi nifeidena vene rofu afei boyo. Ina yaku ina vene rofu nirorotari reyo gokai Saul yaku Varika amiye idau veyo ma beika sina Varika amiye yaku nimaro. Ina vene rofu ka niyo gokai Saul yaku ori de Iesu di roka dudu Damascus ri sina nirausi reyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dada Saul ina venesa amesi Jerusalem gagani tau noibanuri digasa ori de dudu Varika amiye di roka dudu sina nirausi regamo. ");
INSERT INTO kqc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Resi Greek ago nidedi Jew venesa ka sina nigasa kayamo regamo, ma umuyegika toga toga nirorotari regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Usika ourena yaku mina nirorotari regamadi ago neidesi Saul Caesarea ri afei bosi Tarsus rofu nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mina ariri bi ekalesia vene tau Judea, Galilee ma Samaria gagani tau noibanuri uka amuta dudu amegamadi. Vima kikifa yaku aedegamo, dada yeiva moigamadi ma ini rafu ka amiye tau gade dui regamadi, Varika amiye rofu ori regamadi dada. ");
INSERT INTO kqc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter bi gagani tau tora diga boga reyo. Meda yokoiri bi Sei di vene kaere bi Lydda ri amegamadi mina egoru regi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mironari bi amiye yokoi ini roka bi Aeneas baku reyo. Mina amiye bi dibo anua amiye lagani 8 ekamari maka varegamo. ");
INSERT INTO kqc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter yaku ina rofu niyo, “Aeneas, Iesu Keriso yaku gua ya moi buni rido. Dadisi ya kaya yi ekama ri.” Minari maka dadiyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lydda ma Sharon ri amededi vene tau yaku mina amiye vesi Varika amiye rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa ri bi usi dina rema yokoi amegamo, ini roka bi Tabitha. (Greek ago dudu ini roka bi Dorcas.) Ari neinei bi vegu buni resi gugura irava vene aedegamo. ");
INSERT INTO kqc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mina ariri bi gauka yokoi baku resi muyeyo. Ini roaita bi rafe masi yava odoro daiyutu yokoiri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa bi maike de Lydda rofu, dada usi dina vene Joppa ri yaku neideyadi Peter bi Lydda ri, ye amiye remanu nifeideyadi ma ina rofu usa niyadi, “Buni bi unasa evade baegiya.” ");
INSERT INTO kqc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mina dada Peter dadisi ina venesa boyo. Okiyori, bi odoro daiyuturi afei boyadi. Obu vene tau yaku ina buru ri desi isaka nigasa Dorcas yaku vegu amegamori, vadigamo varuka idana tau mina oteimagamadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter yaku ina vene tau niyo dada etofarori yakuyadi ma efuka ode meimisi usa usa nisi kero resi muyena roaita rofu niyo, “Tabitha, dadi!” Ini nemoko aresi Peter vesi dadisi ameyo. ");
INSERT INTO kqc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter yaku Tabitha di vana moisi aedeyo ma dadisi are reyo. Ma Sei di vene tau raka niyo, mina obu vene ka, ma ina vene rofu moi vegu riyo rema maro. ");
INSERT INTO kqc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mina sina Joppa taoni tauri urafo reyo ma amiye tau ini mokena vari gira Varika amiye rofu aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kamini Peter bi meda tau gade Joppa ri ameyo, amiye roka Simon sa, kaere bi boromakau di ro moimai redo amiye. ");
INSERT INTO kqc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Amiye yokoi di roka bi Cornelius kaere bi Caesarea ri amegamo. Ina bi iya rededi vene 100 di ourefeidena amiye yokoi Rome vene di rafu tora yokoi roka, “Italy vene di iya rafu.” ");
INSERT INTO kqc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ina bi Sei di mokena kana regamo amiye; ina ini yava vene tausa bi Sei nivakegamadi. Vegu buni tora gade iniye Jew vene di irava vene rofu resi ari neinei Sei rofu ka usa usa nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uriyenau yokoi meda nemoko regodenuri kana, yaduka kana yokoi veyo. Mina yaduka kana vegasa vei mama reyo bi Sei di naivo naivo vima yokoi bae dui resi ina rofu niyo, “Cornelius!” ");
INSERT INTO kqc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ori iniye nufa mina naivo naivo vima vei kara resi niyo, “Varika amiye, bi beika?” Ma naivo naivo vima nikabai resi niyo, “Sei bi yi usa usa nisa neidesi yi vegu buni irava vene rofu reisa vei mama reyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ye gua amiye be Joppa ri nifeidegiya ma amiye yokoi ini roka Simon Peter afei baeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ina bi amiye yokoi ini roka Simon, kaere bi boromakau di ro moimai redo amiye, di yavari oto resi amedo; yava bi davara atafuri.” ");
INSERT INTO kqc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mina naivo naivo vima diyori, bi ini yava di moimai rei tavoi rededi amiye remanu ma iya redo amiye yokoi, kaere bi Sei di mokena kana redo amiye ma ari neinei bi ini moimai redo amiye mina raka niyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Beika vata niyo mina nioteimasi Joppa ri nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ari uveyo ma idama boyadi Joppa atafuri niyadiri, bi meda tobo kana niyo. Ma Peter bi usa usa nigika yava odorori boyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kamini rauna reyo dada, iruku irina mokena moiyo; ma iruku dogo regamadiri, bi yaduka kana yokoi veyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Oma ekeyo ma beika yokoi bou varuka buni tora kana kono fafau degamo ma veyo. Mina bi teukana 4 rofu moi gira regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mina ideri bi deda vibani yuka 4 nufa tau, iyana rededi vibani aruma kana ma oma di erena. ");
INSERT INTO kqc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kamini goroka yokoi yaku niyo, “Peter, dadisi umuyegasa iri!” ");
INSERT INTO kqc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Idu nikabai resi niyo, “Varika amiye, makai bi de regida! Na bi toga toga ago gira dada kino nufa irina de vibani yokoi irina de mini.” ");
INSERT INTO kqc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mina goroka yaku dudusa nikabai resi niyo, “Beika Sei yaku bi ruaka ma kino de vo niyo, bi ya yaku bi ni moi kino ga ri.” ");
INSERT INTO kqc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mina kana bi uru regodenu vata niyo ma evade mina bi oma ideri moi dairisi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter mina yaduka kana veyo di sina di rama bi beika mina mokegamori, bi Cornelius yaku nifeideyo amiye, bi Simon di yava bi goidu amiye rofu usa nisi baku resi ini ida venari baesi are regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Raka nisi nikaiteyadi, “Minari odi okisi amedo amiye yokoi Simon, ini roka ka bi Peter, ina bi amedo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter bi toga mina yaduka kana di sina rama mokegamori, bi Vima kikifa yaku niyo, “Neide kumo, amiye regodenu bi ya maina okiyadi mini. ");
INSERT INTO kqc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dada, dadisi egona rofu nesi ina venesa di. Mokei anua ga re, adina bi na yaku moi nifeideyaka.” ");
INSERT INTO kqc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dada Peter nesi ina vene rofu niyo, “Maina rededi amiye bi na mini. Beika resi baeyadi?” ");
INSERT INTO kqc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Iya rededi vene 100 di ourefeidena amiye Cornelius yaku una nifeideyo,” vo niyadi. “Ina bi amiye buni, kaere bi mokena rorobo nufa ma Sei nivakena amiye ma Jew vene tau yaku ka ina vei odoro rededi. Sei di naivo naivo vima kikifa yokoi yaku niyo bi, ya bi ini yavari ya raka nigo ma bogiya. Makai regiya ma neidego ya yaku ina rofu beika sina nigiya mina.” ");
INSERT INTO kqc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter yaku afei dui resi niguba reyo, dada mina urusa yokoi maka bi mironari vareyadi. Ari uveyori, bi dadi ina venesa boyo; Joppa usika ourena bedakai ka inasa vakoi boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mina meda usi bi Caesarea ri okiyadi. Mironari Cornelius yaku tua regamo ini usika ourenasa, ma ini asiyaka vene bedakai, kaere bi ina yaku niyo dada oki egogo resi Peter tua regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter ini yava dui regi reyori, bi Cornelius yaku baku resi nivakegi ini yuka atafuri efuka meimiyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Idu Peter yaku moi odoro resi niyo, “Are re; na ka bi amiye tavoi.” ");
INSERT INTO kqc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Resi Cornelius sa sina nigasa dui rei boyadi yava ideri, bi egogo resi amededi vene tora gade baku reyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ina vene rofu niyo, “Ya kaya ya diba iniye bi Jew vene di ago gira yaku nido bi tutubena idana vene bi ga odi digedi ma, ina vene ka ga nikabai regedi. Idu Sei yaku na oteimaro bi amiye yokoi bi na yaku de ni moi kino regida. ");
INSERT INTO kqc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mina dada, na rofu ago nifeideyori, bi baena maka reyaka, mokena yokoi de. Mina resi ya nikaiteida, beika resi na rofu ago nifeideyo?” ");
INSERT INTO kqc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ma Cornelius yaku niyo, “Meda regode koina niyo mini, mina kana meda nemoko regodenu uriyenauri nai yavari usa usa nigasa amegamaka. Minari maka amiye yokoi varuka feyo tayataya risi nai buda rofu are resi ");
INSERT INTO kqc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","niyo, ‘Cornelius! Sei bi yi usa usa nisa neidesi yi vegu buni irava vene rofu reisa vei mama reyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mina dada amiye be Joppa ri nifeidegiya bi amiye yokoi ini roka Simon Peter raka niyaganedi. Ina bi amiye yokoi ini roka Simon, kaere bi boromakau di ro moimai redo amiye, di yavari oto resi amedo; bi davara atafuri.’ ");
INSERT INTO kqc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mina dada evade ago ya rofu nifeideyaka ma ya bi baeyo mini, adina ya bi amiye buni. Gua una tau noibanu bi mini Sei di nemokori Varika amiye yaku beika sina ya niyo nigiya ma neidegifa di ya toro resifa.” ");
INSERT INTO kqc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kamini Peter ago niyo: “Gua vei mama reida rama iniye Sei yaku una tau vakoi bi mokena yokoi maka dudu una dogo redo. ");
INSERT INTO kqc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kaere yaku ina nivakesi vegu rorobo redo amiye bi Sei yaku moi odoro rido, ina goina gagani rofu di bi de mokedo. ");
INSERT INTO kqc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ya ya diba beika ago Israel vene rofu nifeidesi uka amuta di ago buni Iesu Keriso rofu nirausi reyo, kaere bi una tau vakoi di Varika amiye. ");
INSERT INTO kqc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Beika vegu tora Judea konori vata niyo bi ya diba. Mina vegu siko Galilee ri vata niyo, John yaku ini babatiso sina nirausi reyo fufutari. ");
INSERT INTO kqc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ya ya diba Iesu Nazareth amiye ma gokai Sei yaku Vima kikifa di vavasa ina fafau ni moi feideyo. Gagani gagani tora rofu disi buni regasa amiye tau moi buni rigamo, kaere bi Bodaka di vava gabireri amegamadi, adina Sei bi inasa amedo. ");
INSERT INTO kqc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Una bi uniye uni nemoko dudu veyafa, beika vegu tau Jerusalem taoniri ma Jew vene di gagani noibanuri reyo bi. Mina resi bi umuyeyadi; yabo odorori ikoko reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Idu, meda regodenu koina niyori, bi Sei yaku moi vegu risi reyo ma ogau niyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amiye tau nemokori bi ogau de niyo, idu una rofu ina vei mama reyafa, ma Sei yaku una mokeyo vene rofu di maka, mina bi kaere bi inasa iruku koru iriyafa, muyena rofu dadiyo fufutari. ");
INSERT INTO kqc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Resi una ni yeiva resi niyo amiye rofu ago buni nirausi resi niokugifa, ina bi Sei yaku ni moi odoro riyo ma muyena vene ma vegu amena vene di kota neidena amiye di moimai rego dada. ");
INSERT INTO kqc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sei di ago niyadi vene tau bi ina nigika nigamadi bi, tau noibanu ina rofu mokena vari gira aegediri, bi ini vegu no koite makugo, ini roka di vava dudu.” ");
INSERT INTO kqc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter ago nigamori, bi Vima kikifa Peter di ago neidegamadi vene tau fafau deyo. ");
INSERT INTO kqc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jew vene kaere bi mokena vari gira aededi vene Peter sa Joppa ri gutuna baeyadi bi tururu reyadi Sei yaku ini uka buni Vima kikifa tutubena idana vene rofu ka maro dada. ");
INSERT INTO kqc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gagani gagani di ago bouna bouna dudu sina nigasa Sei nivakegamadi mina neideyadi. Kamini Peter yaku niyo: ");
INSERT INTO kqc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mina vene bi Vima kikifa moiyadi, una yaku reyafa kana. Mina dada amiye yokoi yaku ina vene koru dudu babatiso moigika moi vaigo ba ide?” ");
INSERT INTO kqc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Resi ago maro dada Iesu Keriso di roka dudu babatiso moiyadi. Mina usi bi, usa niyadi dada ma ina venesa meda be ameyo. ");
INSERT INTO kqc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nifeidena vene ma usika ourena Judea gaganiri neideyadi bi tutubena idana vene ka Sei di ago moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peter Jerusalem ri boyori, bi roaita nugana di ago gira moi gira ridedi vene bi inasa kayamo regasa niyadi, ");
INSERT INTO kqc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ya bi odi diyori roaita nugana de vene di yavari amesi ka inasa iruku irigamo!” ");
INSERT INTO kqc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ye kamini Peter yaku ina vene rofu beika vegu vata niyo mina tau vakoi niyo ini adinari gutuna baeyo gua mina: ");
INSERT INTO kqc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Joppa taoniri usa usa nigasa amegamakari, bi yaduka kana yokoi bou varuka buni tora kana omari degamo ma veyaka. Mina bi teukana 4 rofu moi gira regamadi ma na atafu baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ideri vei mona regasa vibani yuka 4 nufa ma tuma dona nadina, iyana rededi vibani aruma kana ma oma di erena veyaka. ");
INSERT INTO kqc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Resi goroka yokoi neideyaka na rofu yomakai niyo, ‘Peter, dadisi umuyesi iri!’ ");
INSERT INTO kqc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Idu na yaku niyaka, ‘Varika amiye, makai bi de regida! Na bi toga toga ago gira dada kino nufa irina de vibani yokoi irina de mini.’ ");
INSERT INTO kqc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mina goroka yaku dudusa oma odorori gutuna niyo, ‘Beika Sei yaku bi ruaka ma kino de vo niyo, bi ya yaku bi ni moi kino ga ri.’ ");
INSERT INTO kqc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mina kana bi uru regodenu vata niyo ma beika tau oma ideri moi dairisi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kamini minari maka bi amiye regode Caesarea gutuna na rofu nifeideyadi bi bae okiyadi amegamaka yavari. ");
INSERT INTO kqc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Vima kikifa yaku na niyo bi ina venesa bogida mokena yokoi de dudu. Yomina dubuiyaka 6 Joppa ri gutuna bi na ota reyadi ma Caesarea ri baesi una tau Cornelius di yavari dui reyafa. ");
INSERT INTO kqc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ye una niyo gokai veyo bi naivo naivo vima yokoi baesi ini yava ideri are resi ina rofu niyo, ‘Amiye be Joppa ri nifeide, amiye yokoi ini roka Simon Peter rofu raka niyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ina yaku ya rofu ago nigasa ya yi yava amededi vene tausa moi vegu rigo.’ ");
INSERT INTO kqc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ago nigi kora regamakari, bi Vima kikifa ina vene fafau deyo, ouresi una vene rofu ini reyo kana. ");
INSERT INTO kqc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Minari bi kamini mokeyaka Varika amiye yaku ini niyo sina bi: ‘John bi koru dudu babatiso reyo idu bi Vima kikifa dudu babatiso rego.’ ");
INSERT INTO kqc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mina dada mina bi vabara mini, Sei yaku mina tutubena idana vene rofu mina buni maro bi ina ka una maro, Iesu Keriso rofu mokena vari gira aeyafari; na bi na kaere dada Sei moi vaigida!” ");
INSERT INTO kqc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mina neideyadiri, bi fufuta ago nidedi mina feresi Sei di roka moi odoro rigasa nigamadi, “Sei yaku ka tutubena idana vene rofu bi vegu no feresi moi etagae risi amebiyaganedi vegu maro!” ");
INSERT INTO kqc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen umuyeyadiri, bi esika esika vata niyo dada ekalesia vene be ori Phoenicia, Cyprus ma Antioch gagani maikeri boi neyadi. Mironari bi Jew vene rofu maka ago buni nigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Idu mokena vari gira aena vene bedakai, kaere bi Cyprus ma Cyrene vene, bi Antioch ri bosi Greek ago nidedi vene rofu ka sina niodoro regamadi, Varika amiye Iesu di ago buni mina. ");
INSERT INTO kqc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Varika amiye di vava bi ina venesa amegamo, dada amiye tau gade iniye Varika amiye rofu ini mokena vari gira aesi ini uka kero reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mina sina Jerusalem ri amededi ekalesia vene rofu boyo, mina dada Barnabas bi Antioch ri nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sei yaku amiye rofu buni tora gade maro, mina desi veyori, bi ada resi ina vene nigira reyo, ini uka noibanu dudu Varika amiye usi baeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas bi amiye buni, Vima kikifa yaku ini ukari vata baeyo ma ini mokena vari gira aena bi tora dada. Amiye tau gade iniye Varika amiye rofu moi baeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kamini Barnabas bi Tarsus ri Saul maina regi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Baku regasa Antioch ri afei baeyo. Lagani buaru yokoi ina remanu bi ekalesia venesa egogo regasa amiye tau tora iniye oteimagamadi. Antioch taoniri, siko mokena vari gira Iesu Keriso rofu aena vene di roka niyadi bi Keriso di usi dina vene. ");
INSERT INTO kqc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mina medari maka, Sei di ago nidedi vene be Jerusalem ri gutuna Antioch ri boi neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ina vene di amiye yokoi roka Agabus bi Vima kikifa di vava dudu dadisi niyo bi adabo tora yokoi gagani kono tora noibanuri gabi vata nigo. (Claudius, kaere bi Rome di gagani gagani tau ourefeidei amegamo ariri vata niyo.) ");
INSERT INTO kqc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Usi dina vene tau yaku ini mokei tora reyadi bi gugura fore ini vanari nido kana bi Judea amededi ekalesia usika ourena vene rofu aedegi moi feidegedi. ");
INSERT INTO kqc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kamini makai resi bi fore Barnabas ma Saul rofu moi feideyadi, ekalesia vene di tora vene maraganedi. ");
INSERT INTO kqc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mina meda makari bi kini Herod yaku ekalesia vene be rofu esika esika magi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Resi Herod yaku James, kaere bi John di dubuini, bi ago niyo ma bainasi dudu umuyeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ye beika reyo mina bi Jew vene ada reyadi, mina vesi ka bi Peter moi gira reyo. (Mina bi Beredi yeast de di irakuna ariri.) ");
INSERT INTO kqc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter moiyori, bi dibura yava ideri aeyo ma iya rena rafu 4 yaku vegasa amegamadi. Rafu yokoi makari bi iya rena amiye 4 amegamadi. Herod yaku mokeyo bi Ferei ebu rena irakuna fufutari mamo amiye di nemokori kota rego. ");
INSERT INTO kqc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dada Peter bi dibura yavari aesi moi nari regamadi, idu ekalesia vene bi Peter dada usa usa ni yeiva regamadi Sei rofu di. ");
INSERT INTO kqc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod yaku amiye di nemokori moi yakugo vo niyo meda moina koderi, bi urusari Peter bi iya rena amiye remanu di utari varegamo. Seini remanu dudu mitai riyadi ma dibura yava di ida vena ka iya rededi vene yaku nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Minari maka Varika amiye di naivo naivo vima yokoi baesi are reyori, bi dibura yava bi vabara yaku vata baeyo. Naivo naivo vima yaku Peter megeari moi turu rei edadigasa niyo, “Evade dadi!” Minari maka seini ini vanari bi yareyadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kamini naivo naivo vima yaku niyo, “Yi gagaba ukita maena mitai risi yi yuka fafa ka ri.” Peter makai reyo ma naivo naivo vima yaku niyo, “Yi bou varuka risi na usi bae.” ");
INSERT INTO kqc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter ina usi dibura yavari gutuna yakuyadi; ina toto mina naivo naivo vima yaku beika regamo bi rama iniye ba ide mina. Ini mokegamo bi yaduka kana vegamo. ");
INSERT INTO kqc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iya rena vene ouresi nari regasa amegamadi sana ebu resi boi nesi yokoi ka ebu resi auri dudu riyadi biri taoni di ida vena baesi okiyadi. Ina kaya ina vene rofu ekeyo ma yakuyadi. Taoni ideri di ida yokoiri negamadiri, minari maka naivo naivo vima yaku Peter ferei diyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kamini minari Peter di mokena bae dairiyo ma niyo, “Gua mamo mokeida mini, mina bi rama iniye! Varika amiye yaku Herod di vanari gutuna na moi vegu rigika ini naivo naivo vima nifeideyo. Jew vene yaku ini mokena moigamadi rofu ka na moi vegu riyo.” ");
INSERT INTO kqc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mina mokenasa Mary, kaere bi John Mark di nono, di yavari boi neyo. Minari amiye tau egogo resi usa usa nigasa amegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter biri etofarori raka niyo ma naivo rema yokoi roka Rhoda yaku neidesi baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ini goroka neide mama resi ada no iniye iniye nisi yava ida biri bi ekena de idu feresi raga dairi bosi niyo Peter bi etofaro are regasa amedo. ");
INSERT INTO kqc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ina vene yaku niyadi, “Ya bi ada forovai reyo!” Idu ni duri duri resi niyo bi mina bi rama. Dada nikabai resi niyadi, “Mina bi ini naivo naivo vima!” ");
INSERT INTO kqc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mina fuofuori, Peter bi toga ida biriri raka nigasa amegamo. Gabi ida biri ekesi vegasa tururu reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma ini vana moi odoro reyo ago babo niyaganedi vonisi, resi nirorotari reyo gokai Varika amiye yaku dibura yavari gutuna moi yakuyo. Kamini niyo, “Mina sina bi James ma usika ourena idana rofu nioteimafa.” Kamini feresi yokoi sanari diyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ari uveyori, bi iya rededi vene bi forovai tora iniye resi niyadi, “Peter rofu di beika vata niyo mina?” ");
INSERT INTO kqc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod yaku ago maro ina maina reyaganedi vonisi, idu baku rena de reyadi. Dada iya rededi vene nikaitesi nitugi reyo umuyeyaganedi vo niyo. Mina fufutari, bi Herod Judea ferei bosi ari be bi Caesarea ri ameyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod bi Tyre vene ma Sidon vene rofu gubuyo tora iniye reyo dada, ina tau vakoi egogo resi ina vegika boyadi. Blastus ini uka siko moi amuta reyadi, kaere bi kini di yava nari redo amiye tora, ina vene aedeyainedi. Kamini Herod rofu boi nesi uka amuta usa niyadi, adina ini gagani di iruku bi kini di gaganiri gutuna moigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ini niyo medari, Herod ini sogona burefe risi ini ourefeidena amena fata odoro ameinu resi ini vene rofu ago niyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Amiye raka nisi niyadi, “Mina bi diya amiye kana yaku ago nido, idu sei yokoi yaku nido!” ");
INSERT INTO kqc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Minari maka Varika amiye di naivo naivo vima yaku u moi keto reyo, adina Sei di roka moi odoro de riyo. Adi yaku iriyadi ma muyeyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ye Sei di ago toga tora nisi urafo reyo. ");
INSERT INTO kqc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ma Saul ini moimai koina nisi John Mark ka afei baesi Jerusalem gutuna vakoi dairisi Antioch ri boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch duburi bi Sei di ago niyadi vene ma oteimana vene be amegamadi. Ina vene di roka bi mini: Barnabas, Simeon (ini roka nigika bi amiye gabu), Lucius (kaere bi Cyrene gagani amiye), Manaen (kaere bi gavana Herod sa moi tora reyadi) ma Saul. ");
INSERT INTO kqc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Varika amiye nivakesi iruku oyo regamadiri, bi Vima kikifa yaku ina vene rofu niyo, “Barnabas ma Saul bi nai moi etagae rifa raka niyaka di moimai rena reyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Oyo resi usa usa nisi ini vana ina vene fafau aesi nifeideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Vima kikifa yaku nifeideyo dada, Barnabas ma Saul bi Seleucia ri boyadi, ye mironari gutuna bi bouti dudu Cyprus motumoturi boi neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamis taoni okiyadiri, bi Jew vene di usa usa yavari Sei di ago niodoro reyadi. John Mark bi ina venesa amegasa naivo regamo. ");
INSERT INTO kqc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Motumotu di doba mina nana rei boyadi, resi ugasi Paphos ri boi neyadi; minari bi yaumana amiye yokoi baku reyadi, ini roka bi Bar-Iesu. Ina bi Jew amiye yokoi ma ofa dudu Sei di ago niyo ofa amiye vo nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ina bi mina motumotu di gavana Sergius Paulus di asini, kaere bi mokena moka amiye yokoi. Mina gavana yaku Barnabas ma Saul rofu ago nifeideyo, adina bi Sei di ago neidego di mokena moiyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Idu mina yaumana amiye (Greek agori ini roka bi Elymas) yaku moi vaiyo adina bi gavana di mokena vari gira aena biri rigika regamo. ");
INSERT INTO kqc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kamini Saul—kaere bi ini roka yokoi bi Paul—bi Vima kikifa yaku ini roaita nivai reyo; mina yaumana amiye vei kara resi ");
INSERT INTO kqc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","niyo, “Ya bi Bodaka di mida! Ya bi vegu rorobo tau biri risa amiye. Ofa ofa tau ma vegu no rena yaku ya vata baeyo, ma ya bi ari neinei Varika amiye di sina rama bi ofa ofa rofu moi kero reisa! ");
INSERT INTO kqc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Varika amiye di vana bi ya fafau gua dego ma yi ne taufa nigo, ma ari be bi meda di vabara de vegiya.” Minari maka Elymas amuteyo bi seuya mukuna kana ini nemoko fafa riyo, ma diga boga regasa bi amiye maina regamo vanau riyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gavana yaku beika vegu vata niyo mina vegasa Sei rofu mokena vari gira aeyo, Varika amiye di sina oteimaradi rofu di tururu iniye reyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul bi ini ota riyadi venesa bouti dudu Paphos gutuna Perga ri boi neyadi. Perga bi taoni yokoi Pamphylia gaganiri amedo. Idu minari John Mark bi Paul ma Barnabas feresi Jerusalem ri dairiyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga gutuna bosi Antioch ri okisi, Pisidia gaganiri, Sabati medari bi bosi usa usa yavari ameinu reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses di ago gira ma Sei di ago nidedi vene di bukari bura reyadi ago niokuyadi fufutari bi usa usa yava di ourefeidena vene yaku ina vene rofu di ago nifeidesi niyadi: “Dubuiyaka vene, uni mokenari bi yasa egira sina be amedo vonisi bi ina vene rofu nifa.” ");
INSERT INTO kqc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ye Paul dadi are resi ini vana dudu amiye ago ga niyaganedi vonisi ma niyo: “Nai Israel vene ma tutubena idana vene tau kaere bi Sei nivakededi: na neidefo! ");
INSERT INTO kqc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel vene di Sei yaku uni tutubena vene nisi moiyo. Egypt ri yava ika vene kana amegamadiri, bi ina vene rofu gagani tora yokoi moi risi ini vava tora dudu Egypt gutuna moi yakuyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ye lagani 40 ri gagani autu sanari Sei yaku ini vegu no regamadi moi tai rigamo. ");
INSERT INTO kqc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaan kono torari, gagani 7 etei riyo fufutari mina kono ina vene di maro. ");
INSERT INTO kqc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mina vegu tau bi lagani 450 kana moiyo. “Mina fufutari bi kota nari rena vene maro ma boyo Sei di ago niyo amiye Samuel di ari moiyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kamini kini rofu usa niyadiri, bi Sei yaku Saul maro, kaere bi Kish di mida. Ini rubu bi Benjamin. Ina yaku lagani 40 ri ini kini niyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ina moi etagae riyo fufutari bi Sei yaku David moi ini kini riyo. Yomina bi Sei yaku ina nigika niyo kana: ‘Gua David veitao reyaka, kaere bi Jesse di mida, bi nai mokeida amiye kana. Mina kaere bi nai beika mokeida bi rego.’ ");
INSERT INTO kqc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Sei ini nitore reyo kana bi Iesu, kaere bi David di tutubena, bi Israel vene moi vegu rina amiye moi vata riyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesu ini dena koderi, bi John yaku Israel vene tau rofu di ago niodoro reyo, bi ini vegu no feresi moi etagae risi babatiso moiyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","John ini moimai moi koina rigi ne tumusa ri, bi amiye rofu niyo, ‘Ya yaku mokededi na bi kaere? Ma ya vene bi na toro regasa amena de rededi. Idu neidefa! Ina bi na usi baedo, ye na bi rorobo de ini yuka ro younegida.’ ");
INSERT INTO kqc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nai usika ourena Israel vene, Abraham di tutubena vene, ma ya tutubena idana vene tau minari kaere bi Sei nivakededi: mina moi vegu rina sina bi una rofu nifeideyo! ");
INSERT INTO kqc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Adina Jerusalem ri amededi vene ini ourefeidena venesa ina toto mina bi moi vegu rina amiye mini, Sei di ago niyadi vene di ago Sabati meda neineiri bura vededi ka ini adari fatena de redo. Idu Iesu umuyegika dada Sei di ago niyadi vene di ago moi rama aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ye umuyegika di ida maina reyadi ka vegu no baku rena de reyadi, dada Pilate usa niyadi ina umuyeyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Beika baika ina rofu Sei di ago bura reyadi kana minari rei vau reyadi fufutari, bi satauro gutuna moi soka resi muyena guriri aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Idu Sei yaku muyenari gutuna moi dadiyo, ");
INSERT INTO kqc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ye meda tau gaderi iniye moi ogau riyo, ini vakoi Galilee gutuna Jerusalem ri digamadi vene rofu. Ina vene bi ini ne yaku veyadi vene, mina Israel vene rofu. ");
INSERT INTO kqc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ye una bi mina ago buni ya vene rofu moi baeyafa: Sei yaku uni tutubena vene rofu beika nitore resi rego ");
INSERT INTO kqc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","bi una rofu moi rama reyo, kaere bi ina vene di tutubena vene. Iesu moi dadiyo resi moi vegu riyo. Psalms remanuri bura reyo kana: ‘Ya bi nai Mida; na bi gua yi Baba niyaka.’ ");
INSERT INTO kqc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Resi mina bi Sei yaku muyenari gutuna moi dadigo sina niyo, guri ideri toga iko de niyo: ‘David rofu nitore reyaka kana buni tora gade kikifa ma rama ya magida.’ ");
INSERT INTO kqc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Psalms yokoi ka bura reyo kana: ‘Yi naivo naivo amiye kikifa de feregiya ma guri ideri iko de nigo.’ ");
INSERT INTO kqc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Adina ini ariri David bi Sei yaku ini mokeyo kana moimai tau vakoi resi muyeyo ma ini tutubena venesa guri aeyadi ma ini roaita guri ideri iko niyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Idu Sei yaku muyenari gutuna moi dadiyo amiye di roaita bi guri ideri iko de niyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Usika ourena vene, vei mama reyaganedi Iesu rofu di vegu no koite makuna di sina bi ya nisifa mini. Ma kaere amiye tau mokena vari gira ina rofu aegedi, bi vegu no tau rofu erufugo, ");
INSERT INTO kqc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","idu Moses di ago gira yaku bi vegu no rofu de erufugo. ");
INSERT INTO kqc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Dada ya kaya nari refa kumo Sei di ago nidedi vene yaku bura reyadi bi ya rofu vata nigo baebu: ");
INSERT INTO kqc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sei yaku ini sina niyo rofu ni no rededi vene, vefa kumo! Tururu resi muyefa! Adina na yaku gua beika reida rofu di bi mokena vari gira de aegedi, amiye yokoi yaku ya nirorotari rego ka mokena vari gira de aegedi!’” ");
INSERT INTO kqc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ye Paul ma Barnabas usa usa yavari yakuyadiri, bi amiye yaku usa niyadi mirona Sabati medari dairisi mina vegu di sina besa niyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Amiye tau usa usa yavari egogo reyadi ma ufeya resi diyadiri, bi Jew vene tau ma tutubena idana vene kaere bi Jew vene di Sei nivakena vegu usi dina vene tau yaku Paul ma Barnabas sa digamadi. Ina vene rofu ago nisi nigira reyadi ari neinei Sei di buni tora gaderi amebiyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mirona Sabati medari bi taoniri amededi kana amiye tau Varika amiye di ago neidegika okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Idu Jew vene yaku amiye tau gade veyadiri, bi ini uka gonema yaku vata baeyo. Paul yaku ini beika sina niyo rofu nikayamo resi nifafana reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ye Paul ma Barnabas ori de dudu ago ni yeiva iniye reyadi: “Rama iniye, ya vene rofu siko Sei di ago nigifa bi buni. Idu gedu madedi mini ma ya mokededi bi ya kaya bi toga toga ameibobina vegu rofu bi buni de, dada ya vene ya feresi tutubena idana vene rofu bogifa. ");
INSERT INTO kqc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Adina Varika amiye yaku ago gira una niyo bi yomini: ‘Tutubena idana vene di vabara bi ya riyaka, ye mina dada gagani kono tora noibanu di vene tau vegu niyaganedi.’” ");
INSERT INTO kqc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tutubena idana vene yaku mina sina neidegasa ada resi Varika amiye di roka moi odoro riyadi; resi kaere bi Sei yaku toga toga ameibobina vegu rofu niyo bi mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Varika amiye di ago mina gagani tauri urafo reyo. ");
INSERT INTO kqc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Idu Jew vene bi taoni di ourefeidena vene ma Sei nivakena gugura nufa rema vene di uka moiyadi. Paul ma Barnabas rofu esika esika moi vata resi ini gagani rofu umeki reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ye rebe kana mina taoni rofu ini yuka di budoka uyaresi Iconium taoniri boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Usi dina vene Antioch ri bi ada iniye reyadi ma Vima kikifa yaku ka ini ukari vata baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconium ri ka mina kana vegu vata niyo: Paul ma Barnabas usa usa yava ideri bosi sina nigamadi, dada Jew vene ma tutubena idana vene tau tora Iesu rofu mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Idu mokena vari gira aena de reyadi Jew vene yaku bi tutubena idana vene di uka moiyadi ma usika ourena vene rofu di gedu maradi. ");
INSERT INTO kqc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paul ma Barnabas bi mironari amei doba resi Varika amiye di ago ori de dudu nigamadi. Ina niyo ini buni tora gade di sina nigamadi bi rama ye vava maro ma mokena vegu ma rebe regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mina taoni vene tau di uka bi remanu niyo: be bi Jew vene di ma be bi nifeidena vene di. ");
INSERT INTO kqc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kamini tutubena idana vene be ma Jew vene be ini ourefeidena venesa egogo resi bi mokena moisi bi nifeidena vene rofu rei mona de resi fore dudu umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Oteimana vene yaku mina vegu neideyadiri, bi Lycaonia gagani ma ini atafu gaganiri, Lystra ma Derbe taoniri ori diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mironari ago buni niodoro regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra taoniri bi yuka no amiye yokoi amegamo, kaere bi vata nisi yuka no niyo. Ina ka bi nana de regamo. ");
INSERT INTO kqc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mironari amesi Paul di ago neidegamo. Paul veyo bi mokena vari gira aesi mokeyo bi buni nigo, dada ina vei kara resi ");
INSERT INTO kqc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ni tora resi niyo, “Are rei rorobo re yi yuka dudu!” Mina amiye sokau resi diga bogasa reyo. ");
INSERT INTO kqc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Egogo reyadi amiye tau yaku Paul beika reyo mina veyadiri, bi ini Lycaonia ago dudu raka nisi niyadi, “Sei bi amiye kana nisi una rofu deyo mini!” ");
INSERT INTO kqc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas di roka masi niyadi bi Zeus ma Paul di roka bi Hermes niyadi, adina ina bi ago ni odoro rena amiye. ");
INSERT INTO kqc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeus ma amiye utari naivo amiye, kaere bi ini nivakena yava bi taoni etofaro are redo, bi boromakau rumana be farofarosa ida venauri moi deyadi. Adina bi mina amiye tausa ini mokena bi ina vene rofu ori sisika regedi vonisi reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ye nifeidena amiye Barnabas ma Paul beika vegu regedi mina neideyadiri, bi ini varuka uesi resi amiye tau utari raga bosi raka nigasa niyadi, ");
INSERT INTO kqc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Beika resi makai rededi? Uniye ka bi amiye maka ya kana! Una minari bi ago buni nirausi regi baeyafa, ye yi mokena mina beika baika no rofu kero reyaganedi, ma yi mokena bi vegu amedo Sei mokeyaganedi, kaere bi oma, kono, ma davara beika baika tau mina ideri riyo. ");
INSERT INTO kqc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Senagi bi gagani tau di amiye fereyo, dada vegu niyadi bi iniye ini mokena kana mina regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Idu toga vegu amedo di vana anuka bi vesifa ini buni redo rofu di: miya omari gutuna ya masi ini ari ramari iruku rama niyainedi ya mado; iruku ya masi yi uka meko ada dudu moi nivai redo.” ");
INSERT INTO kqc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Oteimana vene yaku ka ina vene rofu ori sisika ga reyaganedi mina ago niyadi, idu amiye tau ori sisika rena bi gira. ");
INSERT INTO kqc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jew vene be Antioch taoni Pisidia gagani gutuna ma Iconium taoni gutuna okiyadi; mina vene yaku amiye tau di mokena ini mokena kana moiyadi, dada mina vene yaku Paul bi fore dudu usi erokoko resi taoni etofarori moi yakuyadi, ini mokenari bi muyeyo bao niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Idu usi dina vene baesi buru riyadiri, bi dadisi taoni ideri dairiyo. Ari uveyori, bi Barnabas sa Derbe taoniri boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul ma Barnabas Derbe taoniri ago buni niodoro resi usi dina amiye tora gade di uka moiyadi. Kamini Lystra taoni rofu dairisi Iconium taoniri bosi Antioch taoni, Pisidia gaganiri boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Usi dina vene egira resi niyadi bi rama iniye dudu ini mokena vari gira aenari amebiyaganedi. Yomakai oteimaradi, “Sei di ourefeidena amena sana dui regika bi toe tau tora moigifa.” ");
INSERT INTO kqc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dubu yokoi yokoiri bi tora vene omasi usa usa nisi oyo resi Varika amiye rofu nimaradi, kaere bi ina rofu di mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia gaganiri ebu rei boyadiri, bi Pamphylia gaganiri okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mironari Perga taoniri ago niodoro resi Attalia taoniri boi neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Resi minari gutuna bi bouti dudu Antioch taoniri dairiyadi. Mina sanari ekalesia vene yaku Sei di buni tora gade nimaradi, ye gua mina moimai moi koina reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioch taoniri okiyadiri, bi ekalesia vene niegogo reyadi. Resi Sei sa vakoi reyadi moimai tau vakoi di sina niyadi ma gokai Sei yaku tutubena idana vene rofu di ida ekeyo ma mokena vari gira aeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Resi bi usi dina venesa mironari amei doba reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amiye be Judea gutuna Antioch ri desi usika ourena nioteimagi kora resi niyadi, “Moses di ago gira yaku nido kana, roaita nugana mina de regedi vonisi, bi moi vegu rina anua regedi.” ");
INSERT INTO kqc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul ma Barnabas mina venesa mina sina dada kayamo tora reyadi; mina dada bi mokena moiyadi buni bi Paul, Barnabas ma amiye be Antioch ri, bi Jerusalem taoniri bosi nifeidena vene ma tora vene mina kana vegu dada veyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ekalesia vene yaku nifeideyadi ma boyadi. Ye Samaria ma Phoenicia gagani ebu regasa boyadiri, bi tutubena idana vene di uka kero resi Sei rofu aeyadi di sina mina nigamadi. Mina sina yaku Iesu di usika ourena tau rofu ada tora gade moi baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem okiyadiri, bi ekalesia vene, nifeidena vene ma tora vene yaku faiva niyadi, Sei yaku beika ina vene dudu reyo nioteimaradiri. ");
INSERT INTO kqc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Idu Pharisee vene di rafu gutuna kaere bi Iesu rofu mokena vari gira aeyadi vene be yaku dadisi niyadi, “Tutubena idana vene bi roaita nugasi mamo Moses di ini ago gira moi gira riyagane di regedi.” ");
INSERT INTO kqc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nifeidena vene ma tora vene mina sina nidodi regika egogo reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nidodi rei doba reyadiri, bi Peter dadisi niyo, “Nai usika ourena vene, ya ya diba senagi bi Sei yaku ya vene yi fogori na moiyo, ye tutubena idana vene rofu ago buni niodoro regida, neidesi mokena vari gira aeyagane dada. ");
INSERT INTO kqc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ye Sei, kaere bi una yokoi yokoi di mokena bi ina diba, yaku bi tutubena idana vene rofu nimaro, Vima kikifa ina vene rofu maro dudu, una rofu ka maro kana. ");
INSERT INTO kqc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ina vene rofu ma una rofu bi yokoi moi idana de riyo; Iesu rofu mokena vari gira aeyadi, dada ina vene di uka moi ruaka riyo. ");
INSERT INTO kqc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mina dada, beika resi gua ya vene di mokenari ya bi Sei ebene regika mina toe bi usi dina vene di megea fafau aegi rededi? Mina toe bi uni tutubena ma uniye yaku ka moina anua reyafa. ");
INSERT INTO kqc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Idu una bi Iesu rofu mokena vari gira aeyafa ma Varika amiye Iesu di buni tora gade dudu una moi vegu riyo, ina vene ka makai.” ");
INSERT INTO kqc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Amiye tau noibanu bere nisi Paul ma Barnabas yaku gokai Sei yaku ina vene dudu tutubena idana vene di fogori mokena vegu ma rebe reyo mina nirorotari regamadiri, mina neideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sina ni vau reyadiri, bi James dadisi ago niyo: “Nai usika ourena vene na neidefa! ");
INSERT INTO kqc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon una nido mini, Sei yaku sena gokai tutubena idana vene mokesi ina vene rofu di amiye be moiyo ini vonisi. ");
INSERT INTO kqc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sei di ago niyadi vene di ago bi minasa baesi yokoi maka nido. Yomakai bura reyadi: ");
INSERT INTO kqc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Gabi dairigasa David di ourefeidena amena sana yareyo bi dudusa moi odoro regida. Kekevata uyadi sana dudusa risi dudusa moi are regida. ");
INSERT INTO kqc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ye amiye idana tau na rofu baegedi, tutubena idana vene tau kaere na yaku raka niyaka nai vonisi. ");
INSERT INTO kqc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Varika amiye bi makai niyo, kaere bi senagi senagi mina ninegau reyo.’” ");
INSERT INTO kqc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","James yaku nisi niyo, “Nai mokena bi yomakai, tutubena idana vene Sei rofu di uka madedi di ida bi toe ga manadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ye minari bi, fefa yokoi bura resi ina vene nigifa bi ofa sei kino nufa di nemokori aeyadi iruku, vibani bauye moisi umuyeyo ma dava bi irina ga reyagane; koa rena ka ga reyagane. ");
INSERT INTO kqc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Adina bi sena meda dobari Moses di ago gira bi taoni neinei nirausi reyadi ma ini ago bi Sabati meda neineiri usa usa yavari bura vededi.” ");
INSERT INTO kqc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kamini nifeidena vene ma tora vene, ekalesia vene tausa mokeyadi bi amiye be ini rafuri moisi Paul ma Barnabas sa Antioch ri nifeidegedi. Amiye remanu moiyadi kaere bi usika ourena di ourefeidena vene di. Ina vene ini roka bi Judas (ini roka yokoi bi Barsabbas) ma Silas. ");
INSERT INTO kqc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ina venesa bi yomina fefa bura resi ni moi feideyadi: “Una, nifeidena vene ma tora vene, yi usika ourena vene, yaku uni yuata nifeidesifa tutubena idana usika ourena vene rofu, kaere bi Antioch, Syria ma Cilicia ri amededi. ");
INSERT INTO kqc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Neideyafa bi be vene uni rafuri gutuna bae nesi esika ya masi yi mokena moi forovai reyadi, beika ago niyadi dudu; idu, ina vene bi una rofu ago yokoi moina de. ");
INSERT INTO kqc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ye mina dada una tau noibanu egogo resi uka yokoi maka nisi bi amiye be moiyafa, ya vene rofu moi feidei bae negifa. Ina vene bi yi uka mana asiyaka Barnabas ma Paul sa bae negedi, ");
INSERT INTO kqc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","kaere bi Iesu uni Varika amiye Keriso di moimai rofu ini vegu maradi. ");
INSERT INTO kqc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judas ma Silas nifeidesifa mini, kaere mina sina ya nigika gua bura reyafa kana nigedi. ");
INSERT INTO kqc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Vima kikifasa vakoi mokena yokoi maka niyafa, ye ya fafau toe de ya magifa. Idu yomina ago bi moi gira ribifa: ");
INSERT INTO kqc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ofa sei di nemokori aeyadi iruku, dava ma vibani bauye moisi umuyeyo bi irina ga reyagane. Mina vegu de regedi vonisi, bi ya rofu bi buni. Varefo.” ");
INSERT INTO kqc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ye nifeideyadiri, bi Antioch ri boyadi. Minari bi ekalesia vene niegogo resi mina fefa maradi. ");
INSERT INTO kqc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Amiye yaku mina fefa bura veyadiri, bi ada yaku no iniye iniye niyadi, niegira rena sina dada. ");
INSERT INTO kqc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Silas, kaere bi inaike Sei di ago nidedi vene, bi ina venesa sina ni doba reyadi. Niegira resi ago gira maradi uka gira niyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ari be minari koina niyori, bi usika ourena uka amuta dudu ni moi feideyadi ma nifeideyadi vene rofu dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul ma Barnabas meda be Antioch ri amesi amiye tausa vakoi Varika amiye di ago buni ka nioteimagasa niodoro reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Meda be koina niyori, Paul yaku Barnabas rofu niyo, “Dudusa taoni neineiri Varika amiye di ago niodoro reyafa mina uni usika ourena vene rofu odi dairisi venadi gokai amededi mina.” ");
INSERT INTO kqc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas di mokenari bi John Mark bi ina venesa degedi, ");
INSERT INTO kqc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","idu Paul di mokenari mina bi rama de, adina ina venesa amena de rei boyo moimai di metonari. Ina bi Pamphylia ri ina vene feresi dairiyo. ");
INSERT INTO kqc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ina remanu kayamo resi gaima niyadi: Barnabas yaku Cyprus motumoturi bouti dudu Mark afesi boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Usika ourena yaku Varika amiye di buni tora gaderi Paul ma Silas nimaradiri, bi Paul yaku Silas afesi diyo. ");
INSERT INTO kqc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Resi Syria ma Cilicia gaganiri diga bogasa resi ekalesia vene di uka ni moi gira riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul bi Derbe ma Lystra gaganiri dibo reyo. Mironari bi usi dina amiye yokoi roka Timothy amegamo. Ini nono bi mokena vari gira aena Jew rema, idu ini baba bi Greek amiye. ");
INSERT INTO kqc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Usika ourena tau Lystra ma Iconium ri Timothy rofu nivava regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul yaku uka mokegamo bi Timothy bi afesi digedi, ye ini roaita bi nugaro, adina bi Jew vene mironari amegamadi bi diba ini baba bi Greek amiye. ");
INSERT INTO kqc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Taoni neinei ebu reyadiri, nifeidena amiye ma tora vene Jerusalem ri ago gira ekalesia vene masi niyadi mina ago moi gira riyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kamini ekalesia vene ini mokena vari gira aena bi yeiva nigamo ma ari neinei amiye bi tau nigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paul ini asiyaka venesa Phrygia ma Galatia gaganiri dibo reyadi, adina bi Vima kikifa yaku ini ida biri riyo, Asia gaganiri ago buni ga nirausi reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kamini Mysia di kono imi ugaro sana okiyadiri, Bithynia gaganiri dui regi reyadi, idu Iesu di Vima yaku yo nimana de reyo. ");
INSERT INTO kqc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mina resi Mysia ri bi ebu rei yavoi resi Troas ri neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Paul yaku mina urusari yaduka kana veyo bi Macedonia amiye yokoi are resi niguba resi niyo, “Macedonia ri bosi una aedegiya!” ");
INSERT INTO kqc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul yaku yaduka kana vei vau reyori, una bi evade Macedonia digi dogo dogo reyafa, adina ini mokena bi Sei una raka niyo bi ina vene rofu ago buni nirausi regi. ");
INSERT INTO kqc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas gutuna bi bouti dudu ida rorobori Samothrace ri boi neyafa, ma ari uveyori, bi Neapolis ri neyafa. ");
INSERT INTO kqc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mironari gutuna bi Philippi boyafa. Mina taoni Rome vene yaku akuyadi bi Macedonia gagani di ouresi konori ameyo. Ma meda ne tau mironari ameyafa. ");
INSERT INTO kqc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabati medari bi mina taoni di ida vena feresi bi koru seriri disi usa usa nina sana baku regi mokeyafa. Mironari bi rema bedakai egogo resi amegamadi ma ameinu resi inasa ago niyafa. ");
INSERT INTO kqc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Minari rema yokoi kaere uni ago neideyo, ini roka bi Lydia, kaere bi Thyatira taoni varuka purple sero regamo rema yokoi. Ina bi Sei nivakena rema. Varika amiye yaku ini uka dui resi moi areyo, ye Paul di sina neidesi nikabai reyo. ");
INSERT INTO kqc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kamini ina ma ini yavari amededi vene bi babatiso moiyadi, gabi mamo bi ina yaku ini yavari una omasi niyo, “Ye ya yaku mokeyadi na bi vegu ramari Varika amiye rofu mokena vari gira aeyaka vonisi, bi nai yavari bae dui resi amefa.” Una niguba reyo ma inasa boyafa. ");
INSERT INTO kqc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Meda yokoiri bi usa usa nina sanari boyafari, bi moimai rei tavoi reyo naivo rema ofi yokoi yaku una baku reyo. Ina bi vima no nufa ma agiya aineka dobau beika vata nigo mina niogau regamo. Mina ruru sina ago dudu ini biyaguna vene di fore tora gaderi magamo. ");
INSERT INTO kqc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mina rema mida bi Paul ma una usi baegasa raka nisi nigamo. “Mina rumana vene bi Sei odoro iniye di moimai rei tavoi rededi vene! Ina bi ya gokai moi vegu rigo mina ya rofu niokudedi!” ");
INSERT INTO kqc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mina bi ari tau gade reyo, mina dada Paul bi uka esika reyo, ye ne kero resi mina vima no rofu niyo, “Iesu Keriso di roka dudu ya ago gira maida ina rofu yaku di!” Mina niyo metonari maka vima no bi ina rofu yaku diyo. ");
INSERT INTO kqc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kamini ini biyaguna vene yaku mina vesi mokeyadi bi ini fore baku rededi kana bi kamini koina niyo, ye bosi Paul ma Silas bi vanau moi gira resi maketi sanari ourefeidena vene di nemokori moi erokoko reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Resi kota rededi vene rofu afei bosi niyadi, “Mina bi Jew vene ma uni taoni moi no rededi. ");
INSERT INTO kqc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ina bi vegu oteimadedi mina bi uni vene di ago gira moi etagae ridedi; una Rome vene mina kana oteimana vegu moina bi anua resifa.” ");
INSERT INTO kqc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Amiye tau bi mina fogori dui resi Paul ma Silas tourage reyadi. Ma kota rededi vene yaku ini varuka kutusi ago maradi kodu dudu uyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ubobo reyadi koina niyori, bi dibura yavari maku dui resi mina nari redo amiye ago masi niyadi nari rei gigitani reyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dibura yava nari redo amiye mina ago gira neideyori, bi mina amiye remanu moisi ide ramatari aesi ini yuka yabo toe di utari miyo. ");
INSERT INTO kqc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Urusa tobo niyori, bi Paul ma Silas bi Sei rofu usa usa nigasa yauta nigamadi ma dibura vene bedakai mina neidegamadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mina fogori maka kono yagayaga tora gade reyo ma dibura yava gado kuokuo reyo. Doba de dibura yava di biri tau mina iniye maka eboka reyo ma dibura vene tau seini reyadi mina ka roge reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Dibura nari amiye dadi are resi bi biri eboka reyadi mina veyori, bi iniye imi muyegi ini bainasi moiyo, ini adina bi mokeyo dibura vene bi ori yaku diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Idu Paul yaku imuna nisi niyo, “Ya kaya esika mana ga re! Una tau vakoi bi mini!” ");
INSERT INTO kqc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mina nari redo amiye bi keroko vabara moi baeyagane di raka nisi dibura ideri raga resi tururu dudu Paul ma Silas di budari keto reyo. ");
INSERT INTO kqc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kamini ina remanu afei moi yakusi nikaiteyo, “Ya varika vene, beika be regida ma na moi vegu rigo?” ");
INSERT INTO kqc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ina vene yaku nikabai resi niyadi, “Varika amiye Iesu rofu mokena vari gira aegiyari, ya ma yi yava vene bi ya moi vegu rigo.” ");
INSERT INTO kqc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kamini Varika amiye di ago mina amiye ma ini yavari amededi vene rofu nirausi reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mina urusari mina meda nemokori maka mina dibura nari redo amiye yaku Paul ma Silas afei moisi ini uyadi ara koiteyo. Kamini evade mina amiye ini yava vene tausa bi babatiso reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Resi Paul ma Silas afei dui resi ini yavari iruku dabara rei maro. Ina ini yava vene tausa bi ada iniye reyadi, Sei rofu mokena vari gira aeyadi dada. ");
INSERT INTO kqc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Uriyaku bi kota rededi vene yaku furisi tora vene ago maro ma niyadi, “Mirona amiye remanu moi yakugedi.” ");
INSERT INTO kqc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ye dibura nari redo amiye yaku Paul niyo, “Kota rededi vene yaku niyadi ya ma Silas bi yakugedi. Gua ya bi yakusi uka amuta dudu difo.” ");
INSERT INTO kqc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Idu Paul yaku furisi tora vene rofu niyo, “Ina vene yaku una ideri no yokoi de baku reyadi, idu amiye di nemokori una uyadi—una bi Rome vene! Kamini dibura yavari una maku dui reyadi. Ma gua bi sui dudu una afei yakugi nidedi ba? Ide iniye! Ina kaya baesi una afei yakugedi.” ");
INSERT INTO kqc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Furisi tora vene yaku mina ago bi kota rededi vene nioteimaradi, kamini Paul ma Silas bi Rome vene mina neideyadiri, bi ori reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ye uka moi amuta ma vana tuka regi bosi afesi dibura yavari gutuna yakusi usa niyadi mina gagani bi feresi diyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul ma Silas mina dibura yavari gutuna yakusi Lydia di yavari boyadi. Mironari bi usika ourena vene baku resi egira rena sina ago ina rofu nimasi diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ina remanu bi Amphipolis ma Apollonia ebu regasa Thessalonica ri okiyadi. Mironari bi Jew vene di usa usa yava amegamo. ");
INSERT INTO kqc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paul ini toutou reyo kana baesi usa usa yavari dui resi Sabati meda regodenuri ina venesa nidodi resi ");
INSERT INTO kqc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Sei di ago ni-itara resi oteimaro Keriso di esika esika ma muyenari gutuna dadi rae reyo di ida adina. Ina yaku niyo, “Mina Iesu ya vene rofu niokuda ina bi Keriso.” ");
INSERT INTO kqc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bedakai vene bi mokena vari gira aesi Paul ma Silas sa kefe riyadi; ma Greek vene kaere Sei nivakeyadi ma rema tora tora tau gade ka vakoi kefe riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Idu Jew vene bi ina vene rofu maunu nisi maketiri di tavoi ma vegu no rededi vene ni moi egogo resi ruda tora mina taoniri moi kora reyadi. Paul ma Silas baku resi amiye di nemokori afei bogika bi amiye yokoi roka Jason di yava rofu raga bosi dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Idu ina remanu bi baku de reyadiri, Jason ma mokena vari gira aeyadi vene besa taoni ourefeidena vene di nemokori afei erokoko rei desi raka nisi niyadi, “Mina vene bi gagani kono tora noibanu makai dudu moi no riyadi! Kamini gua minari uni taoniri okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason yaku ina vene afei ini yavari dui resi nari reyo. Ina vene bi Caesar di ago gira de moi gira risi ini nidedi bi ini kini idana yokoi amedo, ini roka bi Iesu.” ");
INSERT INTO kqc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Taoni ourefeidena vene ma amiye tau tora mina neidegasa ini mokena forovai reyo. ");
INSERT INTO kqc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kamini taoni di ourefeidena vene yaku Jason ma bedakai venesa bi fore dudu dibura faini resi yaku diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kamini uru niyori ekalesia vene yaku evade Paul ma Silas Berea taoniri nifeideyadi. Ina remanu okigasa Jew vene di usa usa yavari dui reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mironari bi ago neidena vene, diya Thessalonica vene kana. Mina vene sina neidegasa ada tora gade dudu moigamadi. Paul yaku ari neinei Sei di ago niokugamo bi ofa ba rama niyo ago mina maina regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mina dada amiye tau gade di fogori mokena vari gira aeyadi; ma Greek rema tau gade roka nufa ma Greek rumana vene tau gade ka mokena vari gira aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ye Thessalonica ri ameyadi Jew vene yaku Paul ka Berea ri Sei di ago oteimagamadi mina neidegasa ina nesi amiye tau di uka moi kenoka regi kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ma evade maka ekalesia vene yaku Paul koneri nifeideyadi; idu Silas ma Timothy bi Berea ri ameyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul ota risi afei neyadi vene bi inasa Athens ri boyadi mamo Paul yaku ago gira nitugi reyo bosi Silas ma Timothy nigedi ma evade nesi ina baku reyaganedi. Kamini Berea ri dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul yaku Athens ri ina remanu tua regasa amegamori, bi ini uka bi esika iniye reyo, adina bi amiye yaku ofa sei riyadi mina yaku taoni vata baeyadi ma veyo. ");
INSERT INTO kqc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Makai dada Paul bi usa usa yavari Jew vene ma Sei nivakeyadi venesa sina ago resi meda yokoi yokoi maketi sanari kaere baku regamo venesa ka sina ago regamo. ");
INSERT INTO kqc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ma Epicuria ma Stoic di mokena vabara vene bedakai ka bi Paul sa ago niyadi. Ma bedakai niyadi, “Mina ago ni tavoi tavoi amiye bi beika nido?” Ma bedakai yaku niyadi, “Ina bi sei bouna bedakai baeko nido.” Mina niyadi adina bi Paul bi Iesu di sina buni ma ini dadi rae reyo di ago mina niokugamo. ");
INSERT INTO kqc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mina dada bi Paul afesi taoni di kanisoro ini roka Areopagus rofu bosi niyadi, “Una ura gua diba nigifa beika ago bouna amiye rofu niokusa mina. ");
INSERT INTO kqc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ye yi ago bedakai nisa ma neidesifa bi una rofu sina idana, ma una ura resi diba nigifa bi mina ago di adina bi beika.” ");
INSERT INTO kqc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Athens vene tau gade ma okina vene kaere minari amededi bi beika yokoi rena ide, idu beika gua ogau nido ago neidegasa bi nivabi regasa amededi.) ");
INSERT INTO kqc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kamini Paul bi Areopagus kanisoro vene di nemokori dadi are resi niyo, “Ya Athens vene, veida ya bi ida tau yi uka noibanu dudu yi sei tau gade rofu mokena vari gira aededi. ");
INSERT INTO kqc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Adina bi yi taoni nana resi veyaka yi beika nivakededi rofu, ma yi bura yokoi ori sisika rena fore fata fafau veyaka, yomakai bura reyadi, ‘Sei kaere una toto rofu di.’ Mina ya nivakesi kamini toto nidedi na gua mina ya rofu niodoro regida. ");
INSERT INTO kqc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sei, kaere kono tora noibanu ma ini beika tau ideri riyo, bi oma ma kono di Varika amiye. Ina bi amiye vana yaku akuyadi nivakena yava ideri amena de redo. ");
INSERT INTO kqc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ye amiye di vana yaku ini naivo bi de rededi, adina ina bi beika yokoi de ura redo. Adina bi iniye maka yaku amiye tau vegu ma asa ma beika baika tau mado. ");
INSERT INTO kqc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Amiye yokoi maka riyo ma gagani tau di amiye ina rofu vata niyo ma ina vene yaku kono tora noibanuri amededi. Ma senagi ina yaku ini vegu di meda nemoko ma goina kono tu amegedi nitugi reyo. ");
INSERT INTO kqc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Sei yaku makai reyo, ye amiye yaku ina maina resi ina urana amutegi bi baku regedi. Ye rama, ina bi una neinei rofu maike ide; ");
INSERT INTO kqc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","adina, ‘Ina dudu vegu nisi diga bogasa resi amesifa.’ Mina bi yi yauta nina vene yaku ini niyadi kana, ‘Una ka bi ini mida mida.’ ");
INSERT INTO kqc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mina ye una bi Sei di mida, dada buni de mokena moigifa Sei bi goro, siriva o fore ma amiye vana dudu rina amiye ne uruma. ");
INSERT INTO kqc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sei yaku mirona ituari amiye bi ina toto ye mokei vava de regamo, idu gua bi gagani amiye tau rofu nido, ‘Yi vegu no feresi moi etagae rifo.’ ");
INSERT INTO kqc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ye ina yaku ini meda yokoi sena moi auba reyo, kono tora noibanu di vene rofu mokena rorobo dudu kota regori; amiye yokoi maka moi auba reyori bi ina yaku rego. Ina yaku amiye rofu mina bi moi rama riyo, muyena gutuna ina yaku moi dadi rae reyo dada!” ");
INSERT INTO kqc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kamini muyena gutuna dadi rae rena di sina neideyadiri, bedakai vene bi ina rofu nikuruyadi, idu bedakai bi niyadi, “Una ura resifa bi mina sina dudusa nigiya.” ");
INSERT INTO kqc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kamini Paul bi mina amiye fereyo. ");
INSERT INTO kqc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amiye bedakai bi mokena vari gira aesi Paul sa kefe riyadi. Ini mina fogori bi Dionysius, kaere bi Areopagus kanisoro rumana yokoi, ma rema yokoi ini roka Damaris, ma amiye bedakai. ");
INSERT INTO kqc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mina sina ago ni vau reyori, bi Paul Athens feresi Corinth taoniri boyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mironari bi Jew amiye ini roka bi Aquila baku reyo, kaere bi Pontus ri vata niyo. Ina bi ini rema Priscilla sa ruika Italy gutuna okiyadi, ini adina bi Claudius, kaere bi Rome di kini, yaku ago gira maro Jew vene Rome feresi diyaganedi. Paul bi ina vene vegi bosi ");
INSERT INTO kqc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","inasa amesi moimai regamadi, ini adina ina bi dudubu yava di farai vadina amiye ina vene kana. ");
INSERT INTO kqc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabati meda neinei bi usa usa yavari dui resi bi Jew vene ma Greek vene di uka mokena mina moi vabara rigi sina ago regamo. ");
INSERT INTO kqc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ma Timothy Macedonia ri gutuna dairi baeyadiri, Paul bi ini moimai bi ago buni maka niokusi Jew vene rofu nigamo Iesu bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Idu Jew vene bi biri risi nifafana resi ina rofu nigamadiri, Paul bi ini varukari di budoka mina varaka resi nikaka resi niyo, “Yi dava di kino bi ya kaya yi vanari! Nai moimai gabireri na bi no yokoi de. Gua ari gutuna bogo, na bi tutubena idana vene rofu digida.” ");
INSERT INTO kqc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kamini minari feresi bi amiye roka Titius Justus di yavari dui reyo, kaere bi Sei nivakedo amiye yokoi, ma ini yava bi usa usa yava atafuri maka. ");
INSERT INTO kqc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, kaere bi mina usa usa yava di ourefeidena amiye, ma ini yava vene tausa bi Varika amiye rofu mokena vari gira aeyadi. Ma Corinth vene bedakai tau ka ago neidesi mokena vari gira aeyadi ma babatiso reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Urusa yokoiri Varika amiye yaku Paul yaduka kana dudu ago nimasi niyo, “Ori ga re; besa ago nisi bere ga ni, ");
INSERT INTO kqc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","adina na bi yasa, ma amiye yokoi yaku de yaugedi, ini adina amiye tau gade mina taoniri bi nai.” ");
INSERT INTO kqc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ye Paul bi mina taoniri lagani yokoi maka ma lagani berou afonari amesi Sei di ago amiye oteimagamo. ");
INSERT INTO kqc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ma Gallio bi mirona ituari Achaia gagani di gavana niyori, bi Jew vene bi mokena moi yokoi maka resi Paul tourage resi kotari aesi ");
INSERT INTO kqc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Gallio rofu niyadi, “Mina amiye bi amiye tourage regika Sei rofu nivakena ida uni ago gira di ida dudu moi raga de redo!” ");
INSERT INTO kqc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul bi ago nigi reyori, Gallio yaku Jew vene rofu niyo, “Ye ya Jew vene, ye mina amiye no yokoi reyo ma mokena rorobo de vegu no isivaga iniye reyo vonisi, bi mina bi ida rama dudu na yaku yi sina neidegida. ");
INSERT INTO kqc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Idu mina bi nikaitena ma roka roka ma yi ago gira rofu dada, ya vene yaku maka moi nomu rifa. Na bi mina ago makai kana rofu kota de regida!” ");
INSERT INTO kqc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ye mina kota rena sanari meki reyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kamini ina tau bi Sosthenes, kaere bi usa usa yava di ourefeidena amiye, moi gira resi kota rena sana ida nefauri ubobo reyadi. Idu Gallio bi mina vata niyo bi vei feidena de reyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Mina fuofuori Paul bi Corinth ri meda tau gade amesi ini usika ourena yuata nisi Priscilla ma Aquila sa bouti dudu Syria ri boi neyadi. Cenchreae ri ini ada iye nugaro, ini adina bi Sei rofu nitore rena ago niyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ina regodenu Ephesus taoniri okiyadiri, bi Paul yaku Priscilla ma Aquila feresi inaike usa usa yavari dui resi Jew venesa sina sina niyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nikaiteyadi besa ina venesa meda ne doba ameyainedi, idu niyo bi de rego. ");
INSERT INTO kqc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Idu ina vene fereyori, bi niyo, “Sei yaku ura rego vonisi na bi ya rofu dairi baegida.” Kamini Ephesus ri gutuna bouti dudu fereyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Caesarea okigasa Jerusalem ri bosi ekalesia vene rofu yuata nisi kamini Antioch ri neyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mironari ari ne doba ameyo, feresi Galatia ma Phrygia di gagani tora neinei diga bogasa resi usi dina vene tau rofu egira ago magamo. ");
INSERT INTO kqc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mirona ituari bi Jew amiye ini roka Apollos, kaere bi Alexandria ri vata niyo, bi Ephesus ri okiyo. Ina bi ago ni mona rena amiye ma Sei di ago diba nufa amiye. ");
INSERT INTO kqc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Amiye bedakai yaku Varika amiye di ida oteimaradi ma ini ago ka vava nufa Iesu di vegu bi amiye ida rorobo dudu maka oteimagamo. Idu ina bi John di babatiso rena maka ina diba. ");
INSERT INTO kqc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ina bi usa usa yavari ago gira gira dudu nigi kora reyo, ye kamini Priscilla ma Aquila bi mina neidesi ini yavari afei dui resi Sei di ida mina besa ma nioteimai mona reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollos bi Achaia ri bogika mokeyori, bi ekalesia vene Ephesus ri yaku egira ago masi fefa yokoi Achaia ri usi dina vene rofu bura resi Apollos usa nisi faiva niyaganedi. Ina okiyori, bi Sei di buni tora gade dudu mokena vari gira aeyadi vene rofu aede tora reyo. ");
INSERT INTO kqc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Adina bi Apollos yaku amiye di nemokori ini ago gira dudu Jew vene bi etei riyo. Ina bi Sei di ago moi rorobo riyo Iesu bi Keriso. ");
INSERT INTO kqc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos Corinth amegamori, Paul bi mina gagani ideri diga bogasa resi Ephesus ri okiyo. Mironari usi dina vene be baku resi ");
INSERT INTO kqc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","nikaiteyo, “Iesu rofu mokena vari gira aeyadiri, bi Vima kikifa bi moiyadi ba ide?” Nikabai resi niyadi, “Ide, Vima kikifa amedo ba ide bi de neideyafa.” ");
INSERT INTO kqc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ye Paul yaku nikaiteyo, “Makai bi ya beika kana babatiso moiyadi?” Ye nikabai resi niyadi, “John di babatiso.” ");
INSERT INTO kqc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul yaku niyo, “John di babatiso bi amiye di vegu no feresi moi etagae rina rofu; ina yaku Israel vene mina niyo, kaere usi baedo rofu mokena vari gira aeyaganedi—mina amiye bi Iesu.” ");
INSERT INTO kqc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mina neideyadiri, ina vene bi Varika amiye Iesu di rokari babatiso reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kamini Paul yaku ini vana ina vene fafau aeyori, bi Vima kikifa ina fafau deyo ma ago bouna bouna nisi ka Sei di sina niogau regi kora reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mina amiye tau bi 12. ");
INSERT INTO kqc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul bi eyo regodenuri usa usa yavari dui resi amiye rofu ago gira gira dudu Sei di ourefeidena amena sana rofu uka gira aeyaganedi nidodi regamo. ");
INSERT INTO kqc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Idu bedakai bi uka gira ma mokena vari gira de aesi amiye egogo rena tau di nemokori Varika amiye di ida ni no reyadi. Mina resi Paul bi ina vene feresi usi dina vene inasa afesi ari neinei Tyrannus di oteimana yavari ina venesa nivabi regamo. ");
INSERT INTO kqc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mina bi lagani remanu moi raga reyo, ye Asia gaganiri Jew ma Greek vene amededi tau yaku Varika amiye di ago neideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Sei yaku Paul di vana dudu mokena vegu isivaga iniye reyo. ");
INSERT INTO kqc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ye Paul di roaitari muko ma fafau moimai regamo varuka mina avaka maka moisi gauka vene rofu moi bogamadiri mina yaku gauka buni nisi vima no ka feresi yakugamadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jew vene bedakai bi diga bogasa resi vima no meki regamadi. Ina vene ka bi Iesu Varika amiye di roka dudu meki regika resi vima no rofu nigamadi, “Iesu di rokari, kaere bi Paul yaku nirausi redo kana, na yaku ago gira ya maida ina rofu yaku.” ");
INSERT INTO kqc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sceva, kaere bi Jew vene di Sei ma amiye utari naivo amiye tora yokoi, di mida 7 yaku bi makai regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Idu vima no yaku nikabai resi ina vene rofu niyo, “Iesu bi na diba ma Paul ka na diba, idu ya vene bi kaere?” ");
INSERT INTO kqc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kamini mina amiye kaere bi vima no nufa bi ina vene fafau you makusi ubobo rei vau reyo. Makai reyo dada mina mida 7 yavari gutuna ara nufa ma faisara raga yakuyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ephesus ri Jew ma Greek ameyadi vene tau mina sina neidegasa ori yaku no iniye niyadi. Ma Iesu Varika amiye di roka bi moi odoro iniyeri reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Amiye tau gade kaere bi Iesu rofu mokena vari gira aeyadi bi iniye okisi ini vegu no rededi kana mina nirausi reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kaere yaumana regamadi vene tau bi ini mina sesere bura reyadi moi okisi amiye tau di nemokori ori kamu reyadi. Mina bura di davana duaiya reyadi di siriva fore bi 50,000. ");
INSERT INTO kqc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Makai ida dudu Varika amiye di ago bi vava dudu tora nisi yeiva nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mina beika vata nisi koina niyori, Paul bi ini ukari mokeyo bi Macedonia ma Achaia ri diga bogasa resi Jerusalem ri bogo. Ina yaku niyo, “Mina sanari okigidari, bosi Rome ka vegida.” ");
INSERT INTO kqc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ini aedena amiye remanu Timothy ma Erastus bi Macedonia ri nifeidesi Asia gagani torari besa amei doba reyo. ");
INSERT INTO kqc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mirona ituari Ephesus ri Varika amiye di ida dada bi moi siboroka tora iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Siriva dudu moimai redo amiye roka Demetrius yaku bi rema sei Artemis di nivakena yava mina siriva dudu rigamo. Ye ini moimai vene makai dudu fore tau gade baku regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ini moimai vene ma moimai rededi kana vene tau moi egogo resi niyo, “Rumana vene, mina moimai dudu uni fore tora gade iniye moisifa ya ya diba. ");
INSERT INTO kqc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gua yaike vesi neidededi mina amiye Paul yaku amiye tau gade di uka moisi moi gaima rido, mina Ephesus gaganiri maka de, idu mina Asia gagani tora noibanu ka. Ina ya nido, amiye vana yaku sei ridedi bi sei rama iniye ide. ");
INSERT INTO kqc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ye toe baku reyafa uni fore baku rena di roka bi moi no rigo. Mina maka de, idu Artemis di rema tora sei nivakena yava bi kamini roka de nisi mina rema tora sei kaere bi ina rofu nivakededi mina Asia gagani tora noibanuri ma kono tora noibanuri ini vava de iniye nigo!” ");
INSERT INTO kqc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mina neideyadiri, bi gubuyo iniye resi imuna niyadi, “Ephesus di rema sei Artemis bi tora iniye!” ");
INSERT INTO kqc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kamini mina taoni noibanu bi moi siboroka reyadi. Kamini mokena yokoi maka dudu ina vene yaku Gaius ma Aristarchus, kaere bi Paul sa vakoi diyadi Macedonia vene, mina moi gira resi egogo reyadi yava rofu raga erokoko resi afei neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul yaku egogo reyadi fogori ogau nigo vonisi uka mokeyo, idu usi dina vene yaku nivaiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma mina gagani tora di ourefeidena vene bedakai, kaere bi Paul di asiyaka vene, yaku ka ago nifeideyadi egogo yavari ga ogau niyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mina ituari egogo rena sanari bi forovai tora gade, ini adina bi bedakai bi ago yokoi nisi raka nigamadi ma bedakai bi ago idana nisi raka nigamadi. Amiye tora gade bi ina toto beika resi bi mina egogo sanari soka reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jew vene yaku Alexander bi amiye di nemokori afei bosi niyadi mina vegu amiye rofu nirorotari reyaine. Ye Alexander yaku vana dudu rebe reyo amiye bere nigedi dada; ini ura bi amiye nikabai rego. ");
INSERT INTO kqc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Idu amiye yaku veyadi ina bi Jew amiye yokoi, ye vena gobuno risi meda nemoko remanu kana raka nigamadi, “Ephesus di rema sei Artemis bi tora iniye!” ");
INSERT INTO kqc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kamini gabi bi taoni di bura redo amiye yaku raka nidedi mina nivaisi moi bere risi niyo, “Ephesus vene, amiye tau diba niyadi Ephesus taoni yaku Artemis tora iniye ma ini fore kikifa oma gutuna deyo di nivakena yava nari redo. ");
INSERT INTO kqc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mina dada mina ago bi yokoi yaku ga ukekevata uyaine. Ye ya bi mina dada bere nigedi ma vegu tavoi tavoi yokoi ga refa. ");
INSERT INTO kqc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mina vene ya yaku afei baeyadi mini, idu nivakena yavari duma de resi uni rema sei di roka moi no de riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ye Demetrius ma ini vakoi moimai rededi vene bi ini tourage rena ago amiye yokoi rofu amedo vonisi, bi kota ourefeidena vene ma ini moimai rededi meda bi mini. Buni bi tourage rena ago yokoi yokoi rofu minari niyaine. ");
INSERT INTO kqc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ye ago bouna vonisi, bi egogo rena sana ramari nivabi resi moi nomu rigedi. ");
INSERT INTO kqc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ini adina gua beika vata niyo, moi siboroka reyadi mina una tourage regedi. Mina moi siboroka reyadi ago di adina koina ma ago ini rama niogau anua regifa.” ");
INSERT INTO kqc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Makai niyo fufutari kamini egogo vene bi nifeideyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Siboroka reyadi koina niyori, Paul yaku usi dina vene nifeidesi egira ago masi kokora nisi Macedonia ri feresi boyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mirona gaganiri diga bogasa resi amiye tau gade rofu sina nisi egira ago masi gabi bi Achaia ri okiyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Mironari bi eyo regodenu ameyo. Bouti dudu Syria ri bogi reyo, idu neideyo bi Jew vene bi sina nidodi reyadi, ina umuyegedi dada; mina resi mokena moi dairisi Macedonia rofu diga boga reyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Berea amiye roka Pyrrhus di mida Sopater, ma Thessalonica amiye Aristarchus ma Secundus, ma Derbe amiye Gaius, ma Asia gagani tora amiye Tychius ma Trophimus, ma Timothy, ina tau vakoi bi inasa ota riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mina vene siko Troas ri bosi una nari regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Idu Beredi yeast de di irakuna koina niyori, bi bouti dudu Philippi fereyafa. Ma meda 5 koina niyori, bi ina vene Troas ri dairi baku resi mironari bi fura yokoi maka ameyafa. ");
INSERT INTO kqc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Fura di ourena medari egogo resi iruku irisi auta reyafa. Paul bi amiye rofu sina ni boyo uru tobou iniye niyo, ini adina bi ari uvego bi mina sana ferego. ");
INSERT INTO kqc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ma yava odoro daiyutu egogo reyafa sanari bi ramefa tau oriyadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Godua yokoi ini roka bi Eutychus ina bi yava di winidori ameyo. Paul yaku sina bi nidoba iniye reyo, mina dada mina mida bi neota resi varei muyeyo. Mina yava akuyadi bi kaukau ri regode reyo ini doba, ma mina mida bi odoro gutuna konori keto rei deyo. Ma moisi edadiyadi, idu ina bi muyeyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ye Paul bi nesi bi mina mida fafau rovauyo resi binu masi niyo, “Forovai ga refo, ina bi vegu niyo!” ");
INSERT INTO kqc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Resi dudusa daiyutu odorori keu ri bosi beredi odesi iriyo. Ye ina vene rofu ago ni doba rei boyo ma ari uveyo ma ina vene feresi diyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mina egogo reyadi vene bi uka ada ma roaita gira dudu mina mida godua bi afei diyadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Una bi boi nesi bouti keu risi Assos ri boyafa. Mironari Paul afegi bogifa una nitugi reyo kana, adina ina bi yuka dudu bogo. ");
INSERT INTO kqc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos ri una baku reyori, bi unasa boutiri keu riyo ma Mitylene ri boyafa. ");
INSERT INTO kqc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mironari gutuna bouti dudu boi neyafa ma ari uveyori bi Chios ri okiyafa. Ma aineka medari bi Samos ri boi neyafa ma neureka medari bi Miletus ri okiyafa. ");
INSERT INTO kqc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul mokeyo bi Ephesus ebu rego, ini adina bi Asia gagani torari ari koina ni tavoi ga reyainedi, mina resi evade disi Jerusalem ri Pentecost di irakuna di meda boi okigo vonisi bi buni. ");
INSERT INTO kqc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus gutuna Paul yaku Ephesus dubu di tora vene rofu ago nifeideyo baesi baku reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kamini okiyadiri, Paul yaku ago niyo, “Ya vene ya diba na gokai nai vegu tau ya venesa amei dibo reyaka, ouresi di meda kora reyo ma Asia gagani torari dui reyaka gutuna ma gua baeyo mini. ");
INSERT INTO kqc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ave nina tau ma isaka tau gade dudu Varika amiye naivo regamaka ma Jew vene yaku esika esika dudu nai ida biri rigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ya ya diba yi yava neinei ma amiye di nemokori ago niokusi oteimaraka bi buni tau ya aedeyainedi ya maraka. ");
INSERT INTO kqc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jew ma Greece vene rofu sisiba ago ni yeiva resi niyaka, vegu no feresi moi etagae risi Sei rofu kero resi Iesu uni Varika amiye rofu mokena vari gira aeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ye gua bi Vima kikifa yaku na moiyo ma Jerusalem ri digida. Mironari na rofu beika vata nigo bi, na na toto. ");
INSERT INTO kqc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Na na diba bi, taoni neineiri Vima kikifa yaku na ni yeiva resi niyo bi dibura yavari na aesi esika esika magedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ye na kaya nai vegu bi beika rama mokei tora ide regida. Nai ura bi nai raga reida di moimai, Iesu Varika amiye yaku na maro, mina maka moi koina regida. Mina bi Sei ini buni tora gade di ago buni niokuna. ");
INSERT INTO kqc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ye yi fogori diga bogasa resi Sei di ourefeidena amena sana di ago nirausi reyaka, idu gua na na diba ya kaere nai seira bi dudusa de vegedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mina dada rama iniye na yaku gua ya rofu niokuda: ya yokoi boiyo rego vonisi, na mina di toe bi no yokoi de reyaka. ");
INSERT INTO kqc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ini adina bi Sei ini mokedo ago noibanu ya vene rofu niokusi bi yokoi moi sui de riyaka. ");
INSERT INTO kqc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ye ya kaya nari rei mona refo, ma mamoe tau vakoi kaere Vima kikifa yaku sena yi vanari aeyo, mina ka nari rei mona refo. Sei di ekalesia vene rofu nari rena vene nifo, adina Sei yaku ini Mida di dava dudu ina vene moisi iniye di ini riyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na na diba gabi ya feregidari, bi sufa gadeva auna yaku yi fogori okisi mamoe amededi bi moi no rigedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ari yokoi baego yi vakoi gogo didedi vene bedakai yaku ka dadisi ofa sina dudu usi dina vene afei kokofu regedi ma ina vene usi digedi. ");
INSERT INTO kqc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mina dada ya kaya nari refo! Mokefo isaka tau dudu ya tau vakoi rofu ago lagani regodenuri meda ma urusari ya nioteimagi bi de moi vaigamaka. ");
INSERT INTO kqc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ye gua Sei di vanari ma ini buni tora gade di ago ya nimaida mini. Ina bi vava nufa ya moi are rei gira rego ma gugura buni buni ya ini vene moi akeke ri vau rego. ");
INSERT INTO kqc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Amiye yokoi di siriva, goro ma varuka dada moke moke de moigamaka. ");
INSERT INTO kqc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ya kaya ya diba nai vana dudu moimai resi nai asiyaka venesa ateyaka. ");
INSERT INTO kqc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Beika baika tauri resifa ya oteimaraka, makai moimai gira dudu kaere yau nidedi vene aedefo. Ma mokefo Iesu Varika amiye iniye di ago niyo kana, ‘Mana rofu bi yi ada tora nigo, ma moina rofu bi keika nigo.’” ");
INSERT INTO kqc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kamini Paul yaku mina ago koina nigasa efuka meimisi ina vene tau vakoisa usa usa niyo. ");
INSERT INTO kqc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ina vene bi isaka nigasa binu masi fuka resi yuata niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ini uka isaka yaku vata baeyo adina ini ago niyo bi, “Nai seira bi dudusa de vegedi.” Kamini ota risi boutiri afei neyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ina vene yuata nisi bouti dudu Cos urana boi neyafa. Ari uveyori bi Rhodes ri okisi mironari Patara ri boi neyafa. ");
INSERT INTO kqc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mironari bouti yokoi baku reyafa ina bi Phoenicia urana regamo ma una bi minari keu riyafa. ");
INSERT INTO kqc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cyprus vegasa vana enana rofu ebu resi Syria ri boyafa. Tyre seriri boyafa, mironari bouti di gugura fore moiyo mina moi soka regi. ");
INSERT INTO kqc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mironari usi dina vene be baku resi ina venesa meda 7 ameyafa. Toga Vima kikifa di vava dudu Paul rofu nigamadi bi Jerusalem ri ga boyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Idu uni meda ina venesa koina niyori, feresi diyafa. Ina vene ini rema midasa tau vakoi bi una ota risi taoni feresi bi etofaro yakusi davara vasari efuka meimisi usa usa niyafa. ");
INSERT INTO kqc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kamini uniye uniye rofu kokora nisi ma una bi boutiri keu riyafa ma ina vene bi rautu dairiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyre feregasa Ptolemais ri boi okiyafa; mironari bi usika ourenasa egoru resi meda yokoi maka ina venesa ameyafa. ");
INSERT INTO kqc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ari uveyo medari, ina vene feresi bi Caesarea ri boi okiyafa. Mironari Philip, kaere bi ago buni nioku dido amiye yokoi, di yava dui resi inasa ameyafa. Ina bi sena Jerusalem ri ekalesia moi aeyadi amiye 7 yokoi. ");
INSERT INTO kqc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ina bi ini vefa 4 nufa kaere bi mena de. Ina vene bi Sei di ago nigamadi vene. ");
INSERT INTO kqc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mironari meda bedakai ameyafari, Sei di ago nido amiye ini roka Agabus bi Judea ri gutuna okiyo. ");
INSERT INTO kqc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ina bi una rofu urana desi bi Paul di gagaba ukita redo maena moisi bi iniye di yuka vana misi niyo, “Vima kikifa yaku nido: Mina kana dudu mina gagaba maena auna redo amiye bi Jew vene yaku Jerusalem ri ukita risi tutubena idana vene di vanari aegedi.” ");
INSERT INTO kqc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mina neideyafari, bi una ma minari amededi vene bi Paul niguba regamafa Jerusalem ri ga boyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kamini nikabai reyo, “Beika dada isaka nisi nai uka moi yau ridedi? Na bi na kaya dogo reyaka, maena dudu maka de na ukita regedi, idu Jerusalem ri Iesu Varika amiye di roka dudu ka muyegida.” ");
INSERT INTO kqc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ini mokena moi idana rigi bi anua reyafa, ye bere nisi niyafa, “Varika amiye bi ini mokena kana reyainedi.” ");
INSERT INTO kqc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mina meda koina niyadiri, bi dogo resi Jerusalem ri boyafa. ");
INSERT INTO kqc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kamini Caesarea rofu usi dina vene bedakai yaku senagi senagi Cyprus ri usi dina amiye yokoi ini roka bi Mnason di yavari una ota risi afei boyadi, mironari amegifa di. ");
INSERT INTO kqc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kamini Jerusalem okiyafari, ekalesia vene yaku uka ada dudu una gaba reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ari uveyori, Paul bi unasa James vegika boyafa, ma tora vene ka okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul yaku faiva nisi Sei yaku tutubena idana vene di tobori reyo kana Paul di moimai rofu, mina ago tau niokuyo. ");
INSERT INTO kqc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mina ago neidegasa Sei di roka moi odoro risi Paul rofu niyadi, “Dubuini veisa ba Jew vene tau tora gade iniye, bi mokena vari gira aesi bi ago gira moi gira ri mona rededi. ");
INSERT INTO kqc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ina vene bi sena neideyadi, ya yaku Jew vene tau, kaere bi tutubena idana venesa amededi, oteimaro bi Moses di ago gira rofu etagae riyagane, ini mida mida di roaita ka ga nugaragane ma Jew vene di toutou ka ga usi reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Rama iniye, ina vene bi neidegedi ya bi okiyo. Beika be regifa? ");
INSERT INTO kqc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ye ya nigifa ago bi regiya. Unasa bi rumana 4 kaere bi iniye nitugi reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mina rumana venesa bosi ina venesa ini kino moi ruaka rina vegu regediri, ya ini davana regiya, ye makai resi ini ada iye nugagedi. Kamini amiye tau yaku diba nigedi ya mina ago moi diga bogasa reyo bi rama. Ma diba nigedi yi veguri ya bi rorobo maka resi Moses di ago gira bi moi gira risa. ");
INSERT INTO kqc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ye tutubena idana vene, kaere bi mokena vari gira aeyadi, bi uni ukari beika moi vava riyafa, bi burari marafa. Ago bi yomini: ofa sei di nemokori aededi iruku ma dava ma bauye moisi umuyeyadi vibani bi irina ga reyaganedi, ma koa ga reyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kamini Paul bi mina rumana vene afeyo ma ari uveyo medari ina venesa ini kino moi ruaka rina vegu reyadi. Gabi Sei nivakena yavari dui resi ago maradi, goina medari mina kino moi ruaka rina di ari boi koina nisi ina neinei rofu ori sisika rego. ");
INSERT INTO kqc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mina meda 7 bae koina nigi reyori, Jew vene bedakai Asia gagani vene yaku Sei nivakena yava ideri Paul veyadi. Ina vene yaku amiye tau di uka moi kenoka resi Paul moi gira reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Imuna nigasa niyadi, “Israel vene una aedefo! Mina bi amiye kaere gagani tau di amiye tau oteimado, uni davatu vene ma Moses di ago gira ma mina Sei nivakena yava rofu tourage redo. Ye gua Greek vene Sei nivakena yavari afei dui resi mina kikifa sana moi kino riyo!” ");
INSERT INTO kqc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Makai niyadi, ini adina bi sena Trophimus kaere bi Ephesus amiye, taoniri Paul sa vesi mokeyadi Paul yaku bi Sei nivakena yavari afei dui reyo.) ");
INSERT INTO kqc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mina taoni amiye tau bi forovai resi vakoi raga resi Paul moi gira resi Sei nivakena yavari gutuna moi erokoko rei yakuyadi ma evade ida vena bi moi biri riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Amiye tau bi Paul umuyegi reyadiri, Rome di iya rededi vene di ourefeidena amiye yaku beika amiye tau Jerusalem taoniri siboroka reyadi mina neideyo. ");
INSERT INTO kqc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Resi doba deri maka iya vene di ourefeidena vene ma iya rededi vene bedakai afeyo ma raga resi amiye tau amededi fogori okiyadi. Kamini amiye yaku iya rededi vene vegasa Paul udedi mina fereyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Iya rededi vene di ourefeidena amiye yaku Paul rofu bosi moi gira resi ago maro seini remanu dudu miyaganedi. Resi amiye nikaiteyo, “Ina bi kaere ma beika be reyo?” ");
INSERT INTO kqc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kamini mina amiye tau fogori amiye bedakai yaku bi ago yokoi ababa nigamadi ma bedakai yaku bi bouna ababa nigamadi, adina makai forovai resi iya rededi vene di ourefeidena amiye bi ago rama baku rena de reyo, ye ago gira niyo bi iya rededi vene di yavari afei boyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ida vena di idu adina okiyori iya rededi vene yaku uakaiyadi, adina amiye tau bi gubuyo iniye reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Amiye tau usi bogasa raka nisi niyadi, “Umuyefo!” ");
INSERT INTO kqc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Iya rena vene yaku yavari afei dui regi reyadiri, Paul yaku iya rededi vene di ourefeidena amiye rofu usa niyo: “Ya rofu ago nigida ba ide?” Iya rededi vene di ourefeidena amiye yaku nikabai resi niyo, “Ye ya Greek ago nisa ba? ");
INSERT INTO kqc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ye ya bi mirona Egypt amiye kaere senagi gavamani rofu ruda rena kora resi amiye 4,000 kaiya dudu amiye umuyena vene ourefeidesi gagani autu sanari diyo amiye ba ide?” ");
INSERT INTO kqc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nikabai resi niyo, “Na bi Jew amiye, Tarsus taoni Cilicia gaganiri vata niyaka; mina taoni bi roka nufa. Ya usa nida buni bi amiye tau rofu ago nigida.” ");
INSERT INTO kqc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iya rededi vene di ourefeidena amiye yaku Paul vava maro ago niyainedi. Kamini Paul bi idu odorori are resi ini vana amiye rofu rebe reyo bere niyaganedi. Mina amiye tau bere niyadiri, Paul bi Hebrew ago dudu ago niyo: ");
INSERT INTO kqc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Nai usika ourena ma nai madiyaka vene, na ura reida ya vene rofu na kaya nigira regida; yi anema na mafo!” ");
INSERT INTO kqc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kamini Hebrew ago dudu ina vene rofu niyo ma neidegasa bere gidu gidu niyadi. Ma niyo: ");
INSERT INTO kqc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Na bi Jew amiye, Tarsus taoni Cilicia gaganiri vata niyaka, ma mina taoniri tora niyaka. Gamaliel yaku na oteimaro; ina yaku uni tutubena di ago gira dudu maka na oteimaro. Gua ya tau vakoi Sei rofu moi gira ri mona rededi kana na bi mina reyaka. ");
INSERT INTO kqc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mina Ida usi digamadi vene bi na yaku esika esika masi umuyegi, rema rumana moi gira resi bi dibura yavari maku dui regamaka. ");
INSERT INTO kqc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sei ma amiye utari naivo amiye tora ma kanisoro tora vene tau vakoi ka nai ago moi rama aegedi. Ina vene rofu ka vana bura baku regamaka, ini usika ourena Damascus rofu di. Resi mironari bosi mina vene bi moi gira resi Jerusalem ri afei dairisi ini kaunava magika regamaka. ");
INSERT INTO kqc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Meda tobo moigi reyori, bi Damascus atafuri okiyakari, bi vabara tora iniye minari maka omari gutuna na atafuri kamanika rei deyo. ");
INSERT INTO kqc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Konori keto resi bi goroka yokoi neideyaka na rofu yomakai niyo, ‘Saul! Beika resi na esika esika maisa?’ ");
INSERT INTO kqc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ma nikaiteyaka, ‘Varika amiye, ya bi kaere?’ Ma niyo, ‘Na bi Iesu Nazareth amiye, kaere bi ya yaku esika esika maisa.’ ");
INSERT INTO kqc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Rama iniye nasa vakoi digamadi vene bi vabara veyadi, idu mina goroka na rofu ago nimaro bi neide mama de reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ma nikaiteyaka, ‘Varika amiye, beika bi regida?’ Ma niyo, ‘Dadi are resi Damascus ri bo. Mironari bi ya nigo beika tau Sei di ura ya yaku regiya bi.’ ");
INSERT INTO kqc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nai asiyaka yaku na vanau risi na ourefeideyadi ma Damascus ri neyafa, adina bi vabara di yeiva yaku na ne moi taufa riyo. ");
INSERT INTO kqc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Amiye yokoi roka Ananias, kaere bi uni ago gira neideyo ma Jew vene mironari amegamadi tau yaku ina vei odoro regamadi, bi minari amegamo. ");
INSERT INTO kqc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bi baesi na adinari are resi niyo, ‘Nai dubuini Saul, dudusa ne areyainedi!’ Ma minari maka ne areyadi ma ina veyaka. ");
INSERT INTO kqc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kamini ina yaku niyo, ‘Uni tutubena vene di Sei yaku ya auba reyo ina ura redo mina diba nigiya, ini mokena rorobo naivo amiye vesi ini venari gutuna ago neidegiya. ");
INSERT INTO kqc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Adina ya bi ina rofu amiye tau nigedi beika ya neidesi veyo bi rama. ");
INSERT INTO kqc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma ya bi beika tua reisa? Dadisi babatiso moisi yi vegu no koite makugi ini roka ni.’ ");
INSERT INTO kqc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Kamini Jerusalem ri dairisi Sei nivakena yavari usa usa nigamakari, yaduka kana vesi ");
INSERT INTO kqc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Varika amiye veyaka ma na rofu niyo, ‘Evade ruika maka Jerusalem fere, ini adina bi minari amededi vene bi beika ya na rofu nisa bi moi vava de regedi.’ ");
INSERT INTO kqc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ma niyaka, ‘Varika amiye, mina vene ina kaya ina diba na bi usa usa yava neineiri okisi amiye dibura yavari aesi kaere ya rofu mokena vari gira aegamadi mina ka ugamaka. ");
INSERT INTO kqc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma yi vegu moi rama aeyo amiye Stephen umuyeyadiri, na ka bi mironari are resi ini muyena di ida ago moi vava risi umuyeyadi vene di varuka nari regamaka.’ ");
INSERT INTO kqc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kamini Varika amiye yaku na niyo, ‘Dadisi di, adina maikeri tutubena idana vene rofu ya nifeidegida.’” ");
INSERT INTO kqc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Amiye tau bi Paul di sina neideyadi boyo bi mina metona ago niokuyo mamo. Kamini ini goroka moi dadisi raka niyadi, “Umuyefa! Ina bi buni de vegu amego!” ");
INSERT INTO kqc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ina vene bi imuna nigasa ini varuka odoro yougasa kono budoka moi odoro makugamadi. ");
INSERT INTO kqc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Iya rededi vene di ourefeidena amiye yaku ini amiye rofu ago maro, Paul bi iya rededi vene di amededi sanari afei dui reyaganedi. Ye ago gira maro ina bi buburu vai resi nikaite mona regedi, beika dada Jew vene bi ina rofu makai imuna nigamadi. ");
INSERT INTO kqc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kamini ukita risi buburu vai regi reyadiri, Paul yaku iya rededi vene di ourefeidena amiye minari are reyo rofu niyo, “Rome amiye buburu vai regiya ma no yokoi be de baku reyo, mina kana bi ago gira nufa ba ide?” ");
INSERT INTO kqc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kamini mina ago neideyori, nesi iya rededi vene di ourefeidena amiye tora rofu nikaiteyo, “Ya bi beika regiya? Mina amiye bi Rome amiye!” ");
INSERT INTO kqc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ye Paul rofu bosi nikaiteyo, “Na ni ya bi Rome amiye ba?” Ye nikabai reyo, “Yo.” ");
INSERT INTO kqc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kamini niyo, “Na bi na kaya davana tora dudu voi resi Rome amiye niyaka.” Idu nikabai reyo, “Na bi mina gagani amiye vata niyaka.” ");
INSERT INTO kqc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mina dada kaere nikaitegi reyadi vene bi evade maka younu reyadi. Kamini mina iya rededi vene di ourefeidena amiye tora yaku Paul veitao reyo ina bi Rome amiye dada ori reyo, adina bi moi seiniri aeyo. ");
INSERT INTO kqc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Iya rena vene di ourefeidena amiye tora bi beika no rofu Jew vene yaku ina nitourage reyadi di ida rama iniye diba nigi ura reyo. Ye ari uveyori, bi Paul yakusi Sei ma amiye utari naivo vene di varika vene ma kanisoro vene tau vakoi rofu ago maro egogo reyaganedi. Resi Paul afei baesi ina vene di nemokori moi are reyo. ");
INSERT INTO kqc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul bi kanisoro vene di ne ramari vesi niyo, “Nai usika ourena, na bi Sei di nemokori uka di mokena buni dudu ameyaka baeyo gua mina medari mini.” ");
INSERT INTO kqc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sei ma amiye utari naivo amiye tora Ananias bi Paul atafu are reyadi vene ago maro ini vena famaraganedi. ");
INSERT INTO kqc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paul yaku ina rofu niyo, “Sei yaku ya famago—ya ofarosi amiye! Ya bi mironari amesi ago gira dudu na kota reisa, idu ya bi mina ago gira ubaki resi ago maisa na famaraganedi!” ");
INSERT INTO kqc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kaere Paul atafu are regamadi yaku niyadi, “Ya bi gokai resi Sei ma amiye utari naivo amiye tora rofu makai ago gira gira nisa?” ");
INSERT INTO kqc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ma nikabai reyo, “Nai usika ourena na na toto ina bi Sei ma amiye utari naivo amiye tora. Adina ago buniri bura reyo, ‘Yi amiye di ourefeidena amiye yokoi fafau ago no bi ga niyainedi.’” ");
INSERT INTO kqc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kamini Paul yaku bedakai bi Pharisee vene ma bedakai bi Sadducee vene vei mama regasa mina kanisoro vene di fogori raka nisi niyo, “Nai usika ourena, na bi Pharisee amiye ma Pharisee vene di mida! Minari kota di nemokori are reida ini adina nai uka mokena bi muyena vene bi dudusa dadi rae regedi!” ");
INSERT INTO kqc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Makai niyori, bi kamini Pharisee vene ma Sadducee vene bi iniye ini utari kayamo resi egogo vene ka berou berou rofu etebe riyadi. ");
INSERT INTO kqc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Ini adina bi Sadducee vene yaku nidedi muyenari gutuna dudusa dadi rae rena bi ide, naivo naivo vima bi ide ma vima ka ide. Idu Pharisee vene bi mina regode bi mokena vari gira aededi.) ");
INSERT INTO kqc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kamini siboroka reyo ma ago gira oteimana vene bedakai kaere bi Pharisee vene, yaku are resi ago gira dudu tourage resi niyadi, “Una bi no yokoi mina amiye rofu de baku resifa; bi vima o naivo naivo vima yaku ago nimaro baeko!” ");
INSERT INTO kqc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ruda kayamo bi isivaga niyo, mina resi iya rededi vene di ourefeidena amiye tora bi ori reyo Paul bi odei tumu tumu resi umuyegedi baebu. Mina resi iya rededi vene ago maro, yeiva dudu Paul amiye di fogori afesi iya rededi vene di yavari afei dui regedi. ");
INSERT INTO kqc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ari uveyo ma berou urusari, Varika amiye bi Paul adinari are resi niyo, “Uka gira moi! Na dada Jerusalem ri nai sina niokuyo, ye mina reyo kana bi Rome ri ka regiya.” ");
INSERT INTO kqc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Berou meda uriyakuri Jew vene bedakai bi egogo resi iniye uka yokoi maka aesi nitore reyadi, iruku o koru irina de regedi Paul umuyegedi mamo. ");
INSERT INTO kqc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mina umuyena di ida nidodi reyadi vene di tau bi 40 ma besa mina yaku niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Sei ma amiye utari naivo vene di varika vene ma tora vene rofu bosi niyadi, “Una bi uka yokoi maka aesi uniye nitore reyafa, beika yokoi de irigifa, Paul umuyegifa mamo. ");
INSERT INTO kqc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mina dada ya vene ma kanisoro vene bi iya rededi vene di ourefeidena tora rofu ago nifeidegedi, ina yaku Paul yi nemokori afei deyaine yomakai dudu ni eru regedi, ini reremama bi besa nikake rei mona regedi. Idu una bi nari resi mina sanari okina koderi umuyegifa.” ");
INSERT INTO kqc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Idu Paul ini tobaini di mida yaku mina umuyena di ida nidodi reyadi mina neidegasa ina bi iya rededi vene di yavari bosi Paul nioteimaro. ");
INSERT INTO kqc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kamini Paul yaku iya redo amiye yokoi rofu raka nisi, niyo, “Mina godua bi iya rededi vene di ourefeidena amiye tora rofu afei bogiya, adina bi sina yokoi nioteimago.” ");
INSERT INTO kqc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ye mina iya rededi vene di ourefeidena amiye tora rofu afei bosi niyo, “Paul kaere bi dibura amiye yaku na raka nisi usa niyo, mina godua ya rofu afei baegida, ini adina bi sina yokoi ya nioteimago.” ");
INSERT INTO kqc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ma mina iya rededi vene di ourefeidena amiye tora yaku mina godua vanau risi afei moi gaima risi nikaiteyo, “Beika sina na nioteimagiya?” ");
INSERT INTO kqc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ma niyo, “Jew vene bi uka yokoi maka aeyadi bi ya rofu usa nigedi agiya Paul bi kanisoro vene rofu afei negiya, ni eru resi ini reremama bi besa nikake rei mona regedi dada. ");
INSERT INTO kqc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ye ini usa usa bi neidena ga re, adina bi amiye di tau 40 ma besa bi mironi tua resi sui ni amebigedi. Resi iniye nitore reyadi, iruku ma koru de irigedi bogo Paul umuyegedi mamo. Ye gua dogo resi yi ago tua rededi.” ");
INSERT INTO kqc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mina resi nifeidesi niyo, “Beika na rofu niyo sina bi amiye yokoi ga nioteima.” ");
INSERT INTO kqc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kamini iya rededi vene di ourefeidena amiye remanu raka nisi niyo, “Iya rededi vene 200, hosiri keu rina amiye 70 ma sosogi moidedi amiye 200 sa, moi dogo regedi. Gua urusa meda nemoko 9:00 ri bi Caesarea ri bogedi. ");
INSERT INTO kqc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ina vene hosi bedakai magedi ma Paul bi mina hosi fafau keu risi bogo, vegu buni dudu gavana Felix rofu bosi okiyaine.” ");
INSERT INTO kqc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iya rena vene di ourefeidena amiye tora rofu yomakai bura reyo: ");
INSERT INTO kqc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Na Claudius Lysias ya gavana Felix amiye buni vayavaya rofu nai ada reida ago mina ya maida. ");
INSERT INTO kqc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mina amiye bi Jew vene yaku moi gira reyadi umuyegedi vonisi. Neideyaka ina bi Rome amiye, mina resi nai iya rededi venesa nesi afei bosi moi vegu riyafa. ");
INSERT INTO kqc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nai ura reyaka bi maina regida beika reyo dada no rofu nitourage reyadi, mina dada ini kanisoro vene rofu afei neyaka. ");
INSERT INTO kqc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Veitao reyaka bi ini ago gira nikaitena fafau bi nitourage reyadi, idu ina rofu bi vegu no yokoi ide beika dada moi dibura aegedi o moi umuyegedi. ");
INSERT INTO kqc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na nioteimaradi bi Jew vene yaku ida maina reyadi gokai umuyegedi di, mina resi evade maka ya rofu nifeideyaka. Ma kaere ina rofu ini no nikake reyadi ka ago niyaka yi nemokori moi boyaganedi.” ");
INSERT INTO kqc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ye mina iya rededi vene bi ini ago maro kana dudu moi raga resi mina urusari Paul bi Antipatris ri afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ari uveyori, mina iya rededi vene bi ini yavari dairiyadi ma hosiri keu rina vene bi Paul sa boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Mina vene afei bosi Caesarea okigasa bura bi moi bosi gavana di vanari aesi Paul ka ini vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gavana yaku mina vana bura vesi nikaiteyo ina bi goina gagani rofu. Ina bi Cilicia rofu neidegasa ");
INSERT INTO kqc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","niyo, “Ya nitourage rededi vene ka okigediri, yi sina ago tau mina neidegida.” Kamini ago maro Paul bi Herod di kota rena yavari aesi nari reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Meda 5 koina niyori, Sei ma amiye utari naivo amiye tora Ananias, tora vene bedakai ma ago gira dudu nitourage rena amiye ini roka Tertullus bi Caesarea ri nesi Paul nitourage rena ago Felix di nemokori nimaradi. ");
INSERT INTO kqc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kamini Paul raka ni dui reyori, Tertullus yaku ini beika no reyo kana Felix di nemokori yomakai dudu nitourage resi niogau reyo: “Felix, ya bi amiye buni vayavaya; ya bi una ourefeide mona reisa, ari doba tora uka amuta dudu amei baeyafa. Ma ya vegu moi idana riyo dada uni gaganiri deda burefe mina vata niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Una bi ya rofu ida tau gaderi ma gagani gaganiri yi roka buni dudu ya niodoro resifa, ma buni tora gade ya masifa. ");
INSERT INTO kqc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Na ura de reida yi meda moi koina ri tavoi regiya, mina resi ya usa nida, uka buni dudu yi anema na magiya ma nai sina keika nigida. ");
INSERT INTO kqc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Una bi mina amiye veitao reyafa, amiye di varena amenari no moi evata risi kono tora noibanuri Jew vene tau rofu ruda evata rido. Ina bi Nazareth vene makai kana rededi di ourefeidena amiye. ");
INSERT INTO kqc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ma ina ka Sei nivakena yava moi kino rigika reyo, makai dada moi gira reyafa. ");
INSERT INTO kqc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ya kaya mina no fafau nikaitegiya vonisi, bi ini no nitourage resifa mina sina rama diba nigiya.” ");
INSERT INTO kqc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mina sina niyo fafau, Jew vene yaku dabi risi niyadi, “Mina sina tau bi rama.” ");
INSERT INTO kqc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kamini gavana yaku Paul rofu vana imiyou reyo ago niyanedi. Paul nikabai reyo, “Na na diba ya yaku lagani tau gade mina vene fafau kota reyo, ye na bi ada dudu beika na rofu niyadi fafau bi na kaya nigira regida. ");
INSERT INTO kqc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ye ya kaya veitao regiya: na bi meda 12 maka Sei nivakegi Jerusalem ri boyaka. ");
INSERT INTO kqc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na bi Sei nivakena yavari amiye yokoi rofu kayamo de resi usa usa yavari o taoniri amiye moi kenoka de reyaka; Jew vene bi mina vegu de veyadi. ");
INSERT INTO kqc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma ina vene ka beika no na rofu nitourage reyadi bi moi rama aegi anua regedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mina resi, ya niokuda: na bi mina mokena vari gira aena Ida usi uni tutubena di Sei nivakeida, idu ina vene yaku nidedi mina Ida bi rama de vo nidedi. Ma Moses di ago girari ma Sei di ago niyadi vene di bura reyadi mina tau vakoi ka mokena vari gira aeda. ");
INSERT INTO kqc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mina vene kana, na ka uka mokena Sei rofu moida bi yomini: amiye tau, mokena rorobo vene ma mokena vari gira de aededi venesa vakoi dadi rae regedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mina resi toga toga Sei ma amiye di nemokori uka di mokena rorobo dudu ka yeiva reida. ");
INSERT INTO kqc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Lagani tau gade fufutari, mina resi Jerusalem ri nai vene di irava vene rofu fore gugura magi ma ori sisika regi dairiyaka. ");
INSERT INTO kqc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Makai regamakari, kino moi ruaka rina vegu reyaka fufutari, ina vene yaku Sei nivakena yava ideri na veitao reyadi. Nasa bi amiye tau de, ma amiye di varena amena moi siboroka bi de reyaka. ");
INSERT INTO kqc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Idu Jew vene bedakai Asia gagani gutuna bi mironari amegamadi; ini ago be na fafau vonisi, bi buni bi yi nemokori are resi nitourage rena ago nigedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O kaere gua minari, kanisoro vene di nemokori are reyakari, beika mokena rorobo de vegu reyaka ma veitao reyadi, mina niogau regedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Idu na bi ago yokoi maka ini nemokori are resi nigira reyaka bi mini: ‘Muyena vene bi veguri dudusa dadi rae regedi, ya vene yaku na moi kota aeyadi, mina ago niyaka dada.’” ");
INSERT INTO kqc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kamini Felix bi mina mokena vari gira aena Ida di sina neide mama reyo, mina resi mina ago moi etei risi niyo, “Lysias iya rededi vene di ourefeidena amiye tora okigo mamo, mina kota rena ago nigida bi rama o ide vonisi.” ");
INSERT INTO kqc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kamini iya rededi vene di ourefeidena amiye rofu ago maro, Paul bi dibura amedo amiye de kana naivo resi ini asiyaka okisi egoru rena o beika mana dada bi ga erikiyagane. ");
INSERT INTO kqc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Meda bedakai koina niyori, Felix ini rema Drusilla, kaere bi Jew remasa baeyadi. Paul rofu ago fereyo; Iesu Keriso rofu mokena vari gira aena di ago mina niyori, bi neideyo. ");
INSERT INTO kqc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paul yaku mokena rorobo ma yuka vana nari rena ma Sei di kota rego meda mina sina sina nioteimaro, ma Felix mina neidegasa ori resi niyo, “Gua bi digiya. Ma ari buni yokoiri dudusa ya nirutu regida.” ");
INSERT INTO kqc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mina ituari Felix ini uka mokenari bi Paul yaku fore dudu voi rego, mina dada toga toga sina nifeidegamo sina besa niyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Felix ini mokena bi Jew vene yaku ina rofu uka ada reyagane, mina resi bi Paul dibura yavari fereyo. Lagani remanu koina niyori, Porcius Festus yaku gavana nina sana moiyo. ");
INSERT INTO kqc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus mina gaganiri okisi meda regode fufutari Caesarea feresi bi Jerusalem ri boyo. ");
INSERT INTO kqc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mironari Sei ma amiye utari naivo vene di varika vene ma Jew ourefeidena vene yaku Paul fafau nitourage rena ago masi Festus rofu usa niyadi, ");
INSERT INTO kqc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","buni bi ini usa nina bi neidesi ini uka moi ada reyainedi. Ini ura bi Paul bi Caesarea gutuna afei Jerusalem ri baeyagane, ini adina bi sena idau Paul umuyegedi sina di mokena moiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus nikabai reyo, “Paul bi Caesarea nari reyadi, ma na kaya bi doba de mironari dairigida. ");
INSERT INTO kqc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Buni bi yi ourefeidena vene bedakai nifeidegedi nasa Caesarea ri negifa, ma mironari ini beika no reyo vonisi bi nitourage regedi.” ");
INSERT INTO kqc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus bi ina venesa meda 8 o 10 kana amesi Caesarea ri dairiyo. Ari uveyo medari, kota amena sanari ameinu resi ago maro Paul bi afei baeyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kamini Paul okiyori, Jew vene, kaere bi Jerusalem gutuna deyadi, bi are rei buru risi sina toe tau dudu ini no rofu nitourage reyadi, idu ini sina moi rama aego di adina bi koina. ");
INSERT INTO kqc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ma Paul iniye nigira reyo, “Na bi Jew vene di ago gira, o Sei nivakena yava, o Caesar rofu no yokoi de reyaka.” ");
INSERT INTO kqc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ye Festus bi Jew vene di uka moi ada regi Paul rofu niyo, “Ya ura reisa ba ide, Jerusalem ri bogiya ma nai nemokori mina no fafau kota regida?” ");
INSERT INTO kqc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ma nikabai reyo, “Na bi Caesar di kotari are reida mini, mina bi rama iniye na kota regiya. Na bi Jew vene rofu beika no yokoi de reyaka, ya kaya mina bi ya diba iniye. ");
INSERT INTO kqc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ago gira yokoi be odeyaka ma ini kaunava bi muyegida vonisi, bi moigida. Idu beika no na rofu nitourage rededi bi rama de vonisi, bi amiye yokoi di ini vanari na de aego! Na usa nida bi Caesar di nemokori kota regida.” ");
INSERT INTO kqc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kamini Festus yaku ini kanisoro venesa nirorotari reyadi ma nikabai reyo, “Ya bi Caesar rofu usa niyo, dada Caesar rofu bogiya.” ");
INSERT INTO kqc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Meda bedakai koina niyori, kini Agrippa ma Bernice bi Caesarea ri Festus rofu egoru regi faiva nigi okiyadi. ");
INSERT INTO kqc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Meda bedakai ameyadi fufutari, Festus bi kini rofu Paul di ago nirorotari resi niyo, “Amiye yokoi amedo mini, ina bi Felix yaku dibura yavari fereyo; ");
INSERT INTO kqc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalem boyakari, Sei ma amiye utari naivo vene di varika vene, ma Jew vene di tora vene bi ini beika no reyo, niogau resi kota reyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Idu ina vene rofu niyaka una Rome vene di ida bi, amiye ini no nitourage rofu bi kota de rego, bogo ini nemokori ini no nitourage rededi vene egogo resi iniye nigira rego mamo. ");
INSERT INTO kqc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kamini minari bosi egogo reyadiri, na bi ari moi doba de reyaka, idu ari uveyori bi kota neidegi ago maraka mina amiye afei dui reyagane. ");
INSERT INTO kqc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kamini nitourage rededi vene dadisi nai mokena kanari ini no de nitourage reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Idu ina vene bi ini Sei rofu mokena vari gira aena di ma muyena amiye ini roka bi Iesu rofu maka kayamo reyadi, idu Paul yaku nigira redo mina amiye bi vegu amedo. ");
INSERT INTO kqc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mina ago moi nomu rena bi mokena forovai reyo, mina resi Paul nikaiteyaka Jerusalem ri bogo ma ini no nitourage rena ago kotari rego ba ide. ");
INSERT INTO kqc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Idu Paul na usa niyo bi nari resi Caesar di nemokori kota rego. Mina dada ago maraka nari reyagane bogo Caesar rofu nifeidegida mamo.” ");
INSERT INTO kqc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kamini Agrippa yaku Festus rofu niyo, “Na ura reida bi mina amiye di sina na kaya neidegida.” Nikabai reyo, “Agiya neidegiya.” ");
INSERT INTO kqc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ari uveyo ma Agrippa bi Bernice sa kini di sogona akusi yava torari dui reyadi, ma amiye yaku kikifa reyadi. Iya rededi vene di ourefeidena vene ma taoni di tora venesa egogo resi mina sanari ka dui reyadi. Festus ago maro ma Paul afei boyadi. ");
INSERT INTO kqc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus yaku niyo, “Kini Agrippa ma kaere tau unasa gua egogo rededi: Mina amiye vededi, kaere Jew vene tau Jerusalem ri ma minari ina dada nisi raka dudu usa niyadi vegu amena ga reyaine bi buni. ");
INSERT INTO kqc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ye muyena baku rego di ida ini no reyo dada bi maina rei kava reyaka. Idu bi na rofu usa niyo bi Caesar di nemokori kota rego, mina resi mokeyaka nifeidegida. ");
INSERT INTO kqc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Idu ina fafau ago rama bura resi Caesar rofu moi feidegida bi koina. Mina resi ya vene di nemokori afei baeyaka—ma rama iniye bi ya, kini Agrippa rofu!—ye ini no bi vei maina rei mona regedi, ma makai dudu bura be regida. ");
INSERT INTO kqc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nai mokenari bi rorobo de dibura amiye nifeide tavoi regida, no rena di ago adina baku rena koderi.” ");
INSERT INTO kqc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kamini Agrippa yaku Paul niyo, “Vava ya maida ya kaya ago ni.” Kamini Paul kimo ini vana moi odoro risi iniye ini egira ago niyo: ");
INSERT INTO kqc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kini Agrippa, na bi ada regasa gua yi nemokori are resi Jew vene yaku nai no reyaka nitourage reyadi mina tau iniye rofu niegira ago nida, ");
INSERT INTO kqc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","adina bi rama iniye ya diba Jew vene di toutou ma kayamo ago. Mina dada ya usa nida, amuta dudu nai ago neide. ");
INSERT INTO kqc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Jew vene tau noibanu nai kakuari gutuna amei baesi godua ni tora niyaka na kaya di gagani ma Jerusalem ri, bi ina diba. ");
INSERT INTO kqc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ina vene bi senagi ina diba, niokugedi vonisi, na bi uni Sei rofu mokena vari gira aena di Pharisee vene di amiye yokoi amegamaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mina dada nai uka mokena Sei rofu, uni tutubena rofu nitore rena agori dada gua kotari are reida mini— ");
INSERT INTO kqc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","mina bi uni vene di rubu 12 rofu nitore reyo ma, uka mokena regasa uru ari rama iniye Sei nivakededi bi moigedi. O, kini, mina uka mokena dada Jew vene yaku na nitourage rededi! ");
INSERT INTO kqc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Beika resi ya minari amededi bi Sei yaku muyena vene edadi rae redo rofu mokena vari gira aegi anua rededi? ");
INSERT INTO kqc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ye na kaya sena bi, Iesu Nazareth amiye di roka moi no iniye rina mina mokeyaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma mina mokena bi Jerusalem ri rama reyaka. Sei ma amiye utari naivo vene di varika vene yaku ago vava na maradi ma Sei di vene tau moi dibura aegamaka. Ma mina vene umuyegi di sina nidodi renari, bi mina ka nai vana magamaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Meda tau gade usa usa yava neineiri digasa amiye vai resi amiye yaku Sei di roka moi no riyaganedi regamaka. Gubuyo iniye ina vene rofu regamaka, ye yava ikari ka gagani bouna di taoniri digasa esika esika magamaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Yokaru mina di moimai regi, Sei ma amiye utari naivo vene di varika vene yaku vava na maradi ma Damascus ri neyaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kini o, meda tobori idau negamakari, omari gutuna vabara veyaka; mina bi meda kana de, idu ina bi vabara iniye kamanika rei desi na ma nai asiyaka na ota rina venesa una buru riyo. ");
INSERT INTO kqc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Una tau noibanu bi konori keto reyafa, ma goroka yokoi Hebrew agori neideyaka na rofu yomakai nigamo, ‘Saul! Beika resi na esika esika maisa? Ya bi ya kaya esika maisa, boromakau ini biyaguna amiye di kodu dagu mado kana.’ ");
INSERT INTO kqc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ma nikaiteyaka, ‘Varika amiye ya bi kaere?’ Ma niyo, ‘Na bi Iesu, kaere bi ya yaku esika esika maisa. ");
INSERT INTO kqc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Dadisi are re. Ya rofu ogau niyaka ini adina bi nai naivo amiye kana ya omagida. Ya bi beika gua na rofu veyo ma beika gabi ya rofu oteimagida mina amiye bouna rofu nigiya. ");
INSERT INTO kqc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Na yaku Jew vene ma tutubena idana vene, kaere na ya rofu nifeidegida, di vavari ya moi vegu rigida. ");
INSERT INTO kqc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Na bi ina vene rofu ya nifeideida, nemoko aresi mukunari gutuna vabarari kero resi Satani di vavari gutuna Sei rofu etagae riyagane, ye ini mokena vari gira aena na rofu mina yaku ini vegu no koite makugo, ma Sei di moi akeke riyo vene di fogori ini sanari amegedi.’ ");
INSERT INTO kqc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“O kini Agrippa, ye mina dada yaduka kana omari gutuna veyaka na bi de ni obe reyaka. ");
INSERT INTO kqc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ye Damascus ma Jerusalem ri siko ago buni niokusi Judea tora noibanuri ma tutubena idana vene ini fogori ago buni niokuyaka, bi ini vegu no feresi moi etagae risi Sei rofu kero resi vegu no ferena di reremama reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Makai dada Jew vene yaku Sei nivakena yava ideri na moi gira resi na umuyegika reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ye Sei yaku na aedeyo, dada ma gua are resi tora ma keika vene rofu niokuda. Na bi ago bouna nina de; na bi Sei di ago nidedi vene ma Moses di ago vata nigo mina maka nida: ");
INSERT INTO kqc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Keriso esika esika moigo ma ina siko muyenari gutuna dadi rae resi moi vegu rina di vabara sina mina Jew vene ma tutubena idana vene rofu niokuda.” ");
INSERT INTO kqc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paul yaku makai iniye nigira reyori, Festus yaku imuna nisi niyo, “Paul ya bi yi mokena eta niyo! Yi mokena vabara tora yaku ya moi forovai reyo!” ");
INSERT INTO kqc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Idu nikabai resi niyo, “Festus amiye buni vayavaya, na bi ada forovai de; beika nida bi rama iniye ma rorobo iniye. ");
INSERT INTO kqc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kini bi mina kana vegu ina diba, mina dada mina ago makai nida. Na bi nai uka moiyo, adina nai mokenari ya bi mina tau veyo, bi teukanari mina sui sina ni dina de reyo dada. ");
INSERT INTO kqc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kini Agrippa o, Sei di ago niyadi vene di ago mokena vari gira aesa ba ide? Na na diba ya reisa!” ");
INSERT INTO kqc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kamini Agrippa yaku Paul niyo, “Mina medari maka, yi mokenari bi ekalesia amiye rofu na nikake reisa ba?” ");
INSERT INTO kqc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ma nikabai reyo, “Meda doba o tumu, Sei rofu usa nida, ya maka de, idu ya kaere tau gua na neidededi mini, bi na kana nigedi—idu na seini reyadi kana bi de!” ");
INSERT INTO kqc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kamini kini, gavana, Bernice ma kaere inasa amegamadi vene dadi are resi ");
INSERT INTO kqc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","yava feresi iniye iniye ago niyadi, “Mina amiye beika redo bi muyena o dibura bi seru de rego.” ");
INSERT INTO kqc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ye Agrippa yaku Festus niyo, “Mina amiye bi Caesar di nemokori kota reyaine mina usa de niyagadu vonisi, bi ina nifeidesi erufuyagadu.” ");
INSERT INTO kqc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mokeyadi una bi bouti keu risi Italy bogifari, bi Paul ma dibura vene bedakaisa iya rededi vene di ourefeidena amiye tora di vanari aeyadi; ini roka bi Julius, kaere bi Augustus di iya rededi vene di amiye yokoi. ");
INSERT INTO kqc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Una bi Adramyttium gagani di boutiri keu riyafa. Ye una bi boyafa ma mina bouti bi Asia gagani kone di taoniri digo. Macedonia amiye yokoi Thessalonica rofu ini roka bi Aristarchus ina ka unasa. ");
INSERT INTO kqc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ari uveyori, bi Sidon ri utae riyafa ma Julius bi uka buni Paul rofu resi ago maro, ini asiyaka rofu ne vesi ini mokena gugura fore be ateyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mironari gutuna bi dudusa davarari bosi Cyprus eta rofu ebu reyafa, ini adina bi uni nao rofu bi aura tora baegamo. ");
INSERT INTO kqc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Davara tobori boyafari, bi Cilicia ma Pamphylia di kone atafuri ebu resi Myra taoni Lycia gaganiri utae riyafa. ");
INSERT INTO kqc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mironari iya rededi vene di ourefeidena amiye tora yaku Alexandria gutuna di bouti veyo ma una bi keu riyafa, adina bouti bi Italy bogamo. ");
INSERT INTO kqc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Una bi meda tau gade kimo raga regasa toe baku reyafa, mina resi Cnidus atafuri utae riyafa. Kamini mironari aura yaku ida biri riyo, mina resi Crete di fokena eta rofu kefe resi Salmone ebu reyafa. ");
INSERT INTO kqc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Makai toe baku reyafa, dada davara seriri raga resi gagani roka Sisima Buni Utae rina sana Lasea taoni atafuri okiyafa. ");
INSERT INTO kqc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Meda tora gade koina ni tavoi reyo ma iruku oyo rena di meda bi sena koina niyori, davara odoro dibo bi ravegeragera. Ye Paul yaku ina vene rofu nineu reyo: ");
INSERT INTO kqc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Amiye o, nai mokenari bi uni davara fafau dibo bi ravegeragera, uni bouti, gugura fore ma uniye di vegu ka bi rerevaida ugo.” ");
INSERT INTO kqc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Idu iya rededi vene di ourefeidena amiye tora bi Paul di sina neidena de reyo, idu bouti tari redo amiye ma bouti biyaguna amiye di sina neideyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ye minari ava di medari utae rena bi buni de niyo, ma tora noibanu mokena yokoi maka moisi niyadi, Phoenix ri yavoi regedi vonisi bi yaga di medari taru taru regedi. Mina bi bouti utae ridedi sana Crete ri, ma meda nedo rama di eta rofu ma meda nedo enana di eta rofu amei sifere regedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kamini meda baedo rama eta rofu aura amuta ufu regi kora reyo, ma ini mokena beika regedi bi baku reyadi, ye anika moi meidesi Crete seri seri ma raga reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Doba deri, aura tora yeiva nufa—ini roka bi “Meda baedo enana di eta rofu”—bi motumotu gutuna ufu resi baeyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mina aura yaku bouti rofu ufu reyo, ye aura seira rena bi anua reyadi, mina resi ferena maka reyafa ma ini diba raga reyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ye motumotu keika roka Cauda di eta rofu ebu reyafari, una bi bouti di dinige ukita rina bi gira reyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kamini bouti odoro moi keu riyadi ma gabi bouti di aveta rofu maena bedakai mi gogo riyadi gira niyainedi. Ori reyadi bi Libya seriri di vasari kake nigedi baebu, ye farai moi eyouneyadi ma bouti bi makai iyana reyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ari uveyori, bi aura tora toga ufu regamo, mina dada bi kora resi gugura moigasa davarari makuyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Meda regodenuri bi bouti di tuta bi vana dudu moisi makuyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ari tauri meda nemoko ma oma iya de veyafa ma aura tora yaku besa ufu regamo, mina resi uni vegu amegifa uka mokena bi koina niyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Meda tau amiye bi iruku irina de amegamadiri, Paul ina vene di fogori dadi are resi niyo, “Rumana vene, ya bi nai ago neidesi Crete gutuna bi de diyagadu, kamini uniye bi mina kana ekokona bi baku de reyagadu. ");
INSERT INTO kqc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Idu gua ya rofu usa nida, yi mokena gira aefo! Yi fogori amiye yokoi ini vegu boiyo de rego; bouti maka boiyo rego. ");
INSERT INTO kqc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Agiya urusari, Sei di naivo naivo vima, kaere bi ina naivo reida ma bi ini amiye, bi na adinari are resi ");
INSERT INTO kqc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","niyo, ‘Paul, ga ori re! Ya bi kotari Caesar di nemokori are reyaine, ma Sei di buni tora gade ya maro vegu moiyaganedi kaere tau yasa didedi vene ka.’ ");
INSERT INTO kqc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ye rumana vene, yi mokena gira aefo! Adina na bi Sei rofu mokena vari gira aeda, beika na niyo kana bi vata nigo. ");
INSERT INTO kqc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Idu aura yaku una motumotu yokoiri ufu rego ma utae regifa.” ");
INSERT INTO kqc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Urusa 14 bae koina niyori, una bi Mediterranean davarari aura yaku una ufu rei bogamo. Ma urusa tobori, bouti moimai vene amuteyadi bi kono rofu ekaira regamadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kamini davara di moka to moina davarari eyareyadi ma ini doba bi 37 metre; gabi makai kana dudusa reyadi ma ini doba bi 27 metre. ");
INSERT INTO kqc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ori reyadi bouti bi foreri tagi mago, mina resi anika 4 bi bouti di fufuta rofu maku nesi usa usa niyadi ari uveyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bouti di moimai vene ini mokena bi bouti feresi ori yakugedi, mina resi sui dudu bouti di dinige bi davarari moi yareyadi, ma amiye ini mokena bi anika maka bouti di seira rofu moi yareyadi, idu bi de. ");
INSERT INTO kqc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Idu Paul yaku iya rededi vene di ourefeidena amiye tora ma ini iya rededi venesa nioteimasi niyo, “Mina vene boutiri amena de regediri, ya bi de vegu nigedi.” ");
INSERT INTO kqc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kamini iya rededi vene yaku dinige ini maena nufa ukita amedo, mina nugasi moi feideyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kamini meda dadigi reyori, Paul yaku amiye nioteimaro iruku iriyaganedi. Resi niyo: “Meda 14 iruku iri mona de dudu amei baeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Gua ya usa nida iruku be irigedi; resi vegu moiyagane. Ya yokoi esika de moigedi.” ");
INSERT INTO kqc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mina niyo koina niyori, bi beredi be moisi ina vene tau di nemokori Sei rofu buni tora gade masi ode ode resi irigi kora reyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ina vene tau bi uka ada resi iniye ka iruku moiga iriyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Una tora noibanu mina bouti odoro bi amiye 276. ");
INSERT INTO kqc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kamini ina vene tau uka bere bere ma niyadiri, witi moisi davarari makuyadi bouti aita niyainedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kamini ari uveyori, kono bi vei mama de reyadi, idu koru moka yokoi vasa nufa vesi ini mokena moiyadi bi regedi vonisi, bi ida maina resi bouti bi mirona sanari moi bogedi. ");
INSERT INTO kqc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Davarari anika amegamadi di maena bi nugai feidegasa bouti di utari yabo doba are amededi di dibo moi rorobo rido di maena bi ukita youneyadi. Ma farai bouti di adari moi odoro reyadi aura yaku uyainedi. Kamini vasa rofu urana reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Idu bouti bi vasa tagi masi minari odoro varei kake niyo. Ini seira rofu kake nisi iyana de reyori, tafo tafo di yeiva yaku bouti doka bi uroki rei tumu tumu reyo. ");
INSERT INTO kqc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Iya rededi vene bi mokena moiyadi dibura vene umuyegedi, be bi ova resi ori digedi baebu. ");
INSERT INTO kqc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Idu iya rededi vene di ourefeidena amiye tora ini ura bi Paul moi vegu rigo, mina dada ini mokena mina regi moiyadi, bi ina yaku ni de resi ago maro, bi kaere ova regedi vene ya siko sokau usi kono urana ova reyaganedi, ");
INSERT INTO kqc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ma tora noibanu bi gabi bouti di yabo tuta o gugura be moisi ova reyainedi. Makai ida dudu una tau vakoi bi vegu buni dudu vasari utae riyafa. ");
INSERT INTO kqc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Vegu buni dudu vasau okiyafari, bi veitao reyafa motumotu di roka bi Malta. ");
INSERT INTO kqc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Minari amena vene yaku una rofu mokei tora reyadi. Ita tora orisi una tau rofu gaba reyadi, ini adina bi miya ma itu regamo. ");
INSERT INTO kqc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul yaku ita ruena butu risi ita fafau aeyori, gadeva aruma bi ita vava yaku moiyo ma yakusi Paul di vana aki reyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kamini motumotu vene mina aruma bi ini vanari ikiyo mina vegasa iniye iniye rofu niyadi, “Rama iniye mina rumana bi amiye umuyeyo amiye, davarari ka muyena de, idu Vegu rorobo sei iniye yaku ka nido ga vegu niyaine.” ");
INSERT INTO kqc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Idu Paul yaku aruma bi ita mokari varaka resi no yokoi de baku reyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Amiye ini mokena bi roaita urugo o keto resi muyego. Amei doba resi vegasa amegamadi idu gokai beika no de vata niyo ina rofu. Kamini ini mokena kero resi niyadi, “Ina bi sei yokoi!” ");
INSERT INTO kqc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kamini mina kono atafuri, muro bedakai ini biyaguna ini roka Publis, kaere bi motumotu di varika amiye, bi amegamo. Ina yaku una faiva nisi meda regode rofu una gaba reyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ini baba bi gauka varegamo; ina bi roaita vaki vaki ma diye fa resi guraugamo. Paul bi ini daiyutu dui resi usa usa nisi ini vana ina fafau aeyo ma ini gauka buni niyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Makai vata niyori, kaere kaere mina motumoturi gauka vene tau bi okiyadi ma ina moi buni riyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Gugura buni buni dudu una vakeyadi. Kamini bouti keu riyafari, bouti odoro dina gugura ka ateyafa. ");
INSERT INTO kqc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Eyo regodenu koina niyori, Alexandria gutuna bouti yokoi odoro keu riyafa. Mina bouti bi ava di medari motumoturi amegamo, ma ini roka bi “Kakafasina rumana sei.” ");
INSERT INTO kqc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Syracuse ri utae risi meda regode mironari ameyafa. ");
INSERT INTO kqc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mironari gutuna boyafa bi Rhegium ri utae riyafa. Ari uveyori, aura bi meda baedo rama eta rofu ufu reyo. Kamini ainekari, bi Puteoli ri okiyafa. ");
INSERT INTO kqc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mironari bi usika ourena bedakai baku reyafa ma ina venesa meda 7 amegi una daga reyadi. Ye makai dudu Rome ri okiyafa. ");
INSERT INTO kqc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Usika ourena Rome ri amededi bi uni sina neidegasa maketi ini roka Appius ma Oto vene di amena varena yava regodenuri maikeri gutuna baesi una baku reyadi. Paul mina vene vegasa Sei rofu buni tora gade maro ma ini uka gira moiyo. ");
INSERT INTO kqc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Rome okiyafari, Paul bi iya rena amiye yokoi yaku nari rego sa ameyainedi niyadi. ");
INSERT INTO kqc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Meda regode koina niyori, Paul yaku Jew vene di ourefeidena vene raka niegogo reyo. Kamini egogo reyadiri, niyo, “Usika ourena, gokai beika no uni amiye o uni tutubena di vegu rofu de reyaka, Jerusalem ri dibura amiye kana na moisi Rome vene di vanari aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Na nikaite mona resi ini ura bi na nifeidegedi, adina bi no yokoi reyaka ma muyegida di ida bi baku de reyadi. ");
INSERT INTO kqc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Idu Jew vene bi ura de reyadi, mina resi bi buni usa niyaka na bi Caesar di nemokori kota reyaine, idu nai vene rofu nitourage rena ago bi de. ");
INSERT INTO kqc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mina dada ya niegogo reyaka, ya vesi sina nimagida. Ini adina bi Israel vene yaku uka mokena aegedi amiye dada mina seini aeyadi mini.” ");
INSERT INTO kqc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ina vene nikabai reyadi, “Yi vegu reyo di sina ini bura Judea rofu baku de reyafa, ma usika ourena mirona gutuna baena vene yaku gokai yi sina no ka yokoi nina de. ");
INSERT INTO kqc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Uni ura bi yi mokena sina neidegifa, ini adina una diba gagani tau yaku ya vene fafau ago no nidedi.” ");
INSERT INTO kqc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Mina dada ina vene yaku meda yokoi nidodi resi aeyadi ma amiye tau gade iniye Paul ini amegamo yavari okiyadi. Uriyaku gutuna boyo urusa ina yaku Sei di ourefeidena amena sana di ago oteimasi niokuyo. Moses di ago gira ma Sei di ago niyadi vene di ago bura reyadi Iesu dada, mina niogau reyo uka kero reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bedakai bi ini agori uka vava aeyadi, idu bedakai bi mokena vari gira de aeyadi. ");
INSERT INTO kqc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Paul yaku ago yokoi maka niyori, amiye bi iniye iniye rofu uka yokoi maka nisi de fereyadi. Paul di ago bi yomini: “Vima kikifa yaku rama iniye Sei di ago niyo amiye Isaiah dudu yi tutubena rofu ago niyo! ");
INSERT INTO kqc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Resi yomakai niyo, ‘Disi mina vene rofu ni: Neidebigedi, idu diba de nigedi; vebigedi, idu vei mama de regedi, ");
INSERT INTO kqc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ini adina mina vene di uka bi gira iniye; ma ini anema kebi risi neidena de resi ini nemoko muguna reyadi. Bi ini nemoko dudu vesi ini anema dudu neidesi ini uka dudu diba nigedi baebu, ye na rofu kero regedi ma na yaku moi buni rigida.’” ");
INSERT INTO kqc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Mina dada ya diba niyagane, Sei ini moi vegu rina di ago bi tutubena idana vene rofu nifeideyo ma ina vene yaku neidegedi!” ");
INSERT INTO kqc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Lagani buaru remanuri Paul bi iniye voi regamo yavari amesi kaere egoru okigamadi vene tau bi faiva nigamo. ");
INSERT INTO kqc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Sei di ourefeidena amena sana di ago nirausi resi yeiva dudu Varika amiye Iesu Keriso di ago oteimaro ma yokoi yaku ini sina biri de riyo. ");
INSERT INTO kqc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Na Paul, kaere bi Iesu Keriso di moimai rei tavoi reida amiye, ya rofu bura reida. Sei yaku na nifeidena amiye kana raka nisi Sei di ago buni nirausi regi auba reyo. ");
INSERT INTO kqc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Sei senagi ini ago kikifari ini ago niyadi vene dudu mina ago buni nitore reyo. ");
INSERT INTO kqc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Bi ini Mida dada bura reyadi, kaere bi amiye roaitari David di tutubena gutuna vata niyo; ");
INSERT INTO kqc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ma Vima kikifa dudu Sei di mida vava nufa niogau reyo, ini muyenari gutuna moi dadi rae reyo dada, ina kaere bi Iesu Keriso uni Varika amiye. ");
INSERT INTO kqc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Una bi ina dudu buni tora gade ma nifeidena vene di reremama moiyafa, ye amiye mokena vari gira aesi ini ago neidegedi, ini roka gagani gagani vene tau vakoi ini fogori dada. ");
INSERT INTO kqc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ma ya kaere mina fogori ka Iesu Keriso yaku ya raka nido, inasa auta reyainedi. ");
INSERT INTO kqc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mina sina bi Rome ri amededi vene tau rofu, kaere bi Sei ini uka masi iniye ini vene roka nido: Uni Baba Sei ma Varika amiye Iesu Keriso di buni tora gade ma uka amuta ya maragane. ");
INSERT INTO kqc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Yomakai dudu ago kora regida, Iesu Keriso dudu ya tau vanu dada, nai Sei rofu buni tora gade maida, adina bi, kono tora noibanuri yi mokena vari gira aena di sina niogau redo. ");
INSERT INTO kqc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Adina Sei bi nai ninegau redo amiye, kaere nai vima dudu ini Mida di ago buniri naivo reida. Ina diba na bi toga toga ya fafau ago mokegasa ");
INSERT INTO kqc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","toga toga usa usa nida, ye ari yokoiri Sei di ura dada, na bi ida baku resi ya rofu baegida. ");
INSERT INTO kqc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Adina nai uka dadido ya vene vegika, ye Vima ini moimai yokoi mina yasa anarauda regida ma yeiva moiyagane. ");
INSERT INTO kqc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ye makai uniye uni mokena vari gira aena dudu ya na niegira regedi, ma na ka ya niegira regida. ");
INSERT INTO kqc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nai usika ourena, nai ura bi ya diba niyaganedi na bi uru tau ya rofu baegida (idu gua mamo bi kebi reyo). Mina ye tutubena idana vene yasa yi fogori moimai resi butu regida. ");
INSERT INTO kqc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Na bi nai ago yokoiri vene ma yava ika idana vene rofu ago nirausi regida, mokena tora nufa vene rofu, ma ada de nufa vene rofu. ");
INSERT INTO kqc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Mina resi ka ya kaere Rome ri amededi, bi nai uka dadido ya rofu ago buni nirausi regida. ");
INSERT INTO kqc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Na bi ago buni fafau maena de, adina bi Sei di vava, kaere amiye tau mokena vari gira aego, ouresi mina bi Jew vene ma tutubena idana vene ka moi vegu rigo. ");
INSERT INTO kqc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Adina mina ago buniri Sei di mokena rorobo moi ogau rido: bi mokena vari gira aena dudu ouresi kora resi koina nigo. Bura reyo kana, “Mokena rorobo amiye bi mokena vari gira aena dudu vegu amego.” ");
INSERT INTO kqc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Adina Sei di gubuyo resi kota rena amiye di vegu no dada omari gutuna moi ogau rido Sei di mokena kana de ma mokena rorobo de vene tau vakoi fafau, kaere ini Sei di mokena kana de vegu dudu ago rama biri ridedi. ");
INSERT INTO kqc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Adina beika Sei dada diba nigedi, bi sui de, idu negauri oteimaro mini, Sei iniye yaku mina vene rofu oteimaro dada. ");
INSERT INTO kqc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Adina Sei yaku senagi oma ma kono riyori gutuna, bi vena de, idu ini toga toga amedo vava ma ina bi beika kana, bi ramari vei mama reyadi; bi beika baika Sei yaku riyo dudu vei mama reyadi dada. Mina dada amiye bi ida yokoi dudu ina rofu nisui de regifa! ");
INSERT INTO kqc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Adina Sei diba niyadi, idu bi Sei kana ini roka moi odoro de risi buni tora gade de maradi. Idu ini mokena bi tavoi tavoi reyo ma ini uka ada de kana. ");
INSERT INTO kqc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ye iniye niyadi bi mokena vabara nufa, idu ada de kana niyadi; ");
INSERT INTO kqc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","resi Sei kaere toga toga amedo di vabara fufuta masi vana dudu riyo vima amiye muyego kana ma erena, vibani yuka 4 nufa ma variva kana nivakegamadi. ");
INSERT INTO kqc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Mina resi Sei yaku ini uka di ura rena vegu kino reyadi rofu ekure reyo. Makai iniye ini fogori ini roaita moi no regedi. ");
INSERT INTO kqc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ina vene yaku Sei di ago rama gedu masi ofa ago moisi beika Sei yaku riyo, mina nivakesi naivo regamadi, idu beika baika tau riyo amiye bi de, kaere bi toga toga buni tora gade madedi! Rama. ");
INSERT INTO kqc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Mina resi, Sei yaku moi no rena di ura rofu ekure reyo. Adina ini rema yaku rumanasa varena vegu feresi rema bounasa varegamadi, amiye di mokena buni kana de. ");
INSERT INTO kqc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Rumana vene ka makai, remasa varena vegu fufuta masi iniye iniye rofu ura regamadi, ye rumana vene yaku maena rena vegu no iniye iniye rofu resi ini ideri ini no di kaunava moigamadi. ");
INSERT INTO kqc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ma beika bi rama, mina dudu Sei rofu mokegi moi kekevata uyadi, ini mokenari Sei di mokena mokei itu reyadi, ye Sei yaku beika rena de vegu mina regi ina vene rofu mokena no ekure reyo. ");
INSERT INTO kqc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ina vene bi mokena rorobo de vegu, uka esika mana, udu ma vegu no rena mina tau vakoi nufa vata baeyo; bi maunu nina, amiye umuyena, ruda rena, ofa nimana ma gubuyo vata baeyo. Ina bi fufuta sina nidedi vene, ");
INSERT INTO kqc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","nifafana rededi vene, Sei rofu gubuyo rededi vene, negiyagiya nufa, iniye roka ni moi tora resi nivasena resi vegu no besa besa asanu rena mokesi nono baba di ago de neidededi; ");
INSERT INTO kqc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","bi dona auna di moke moke nufa, nitore rena ago de resi bi uka buni de ma iriyeduka nufa de vene. ");
INSERT INTO kqc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ina diba Sei di ago gira dada, kaere mina kana vegu rededi bi buni bi muyegedi. Ina yaku maka rena de, idu kaere amiye rededi, ka ni mama regedi gira moisi reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Mina dada ya bi ago idana idana yokoi de nigedi, ya tau noibanu, kaere amiye bouna rofu kota rededi. Adina amiye bouna rofu kota regiyari, ya kaya ka kota reisa, ya kota redo amiye, ya ka mina vegu reisa dada. ");
INSERT INTO kqc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Gua una diba Sei ini kota renari bi rama, kaere mina vegu kana rededi ina fafau keto rego. ");
INSERT INTO kqc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kaere mina kana vegu rededi bi ya yaku kota reisa, idu ya ka mina reisa! Ye mokeisa Sei di kota rena bi ori digiya ba? ");
INSERT INTO kqc_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Sei yaku ini uka buni dudu vegu no feresi moi etagae rigi ya ourefeideyaine; ye ya diba nisa ba ide? O ya bi ini uka buni vayavaya, tua rena ma toro rena rofu mokei itu reisa ba? ");
INSERT INTO kqc_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Idu yi uka gira ma vegu no feresi moi etagae de rina dada, Sei di kota rorobo rena moi ogau rigori, ya bi ya rofu Sei di gubuyo tora ae torekai reisa, mina gubuyo tora di medari moigiya. ");
INSERT INTO kqc_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ma Sei yaku amiye neinei ini beika reyo kana, ina rofu mago. ");
INSERT INTO kqc_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Amiye kaere vegu buni renari, are rei gira rena dudu vabara, kikifa rena ma moi no de rena, mina maina rededi, Sei bi ina vene rofu toga toga ameibobina vegu mago. ");
INSERT INTO kqc_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Idu kaere iniye di buni maka maina resi ago rama de neidesi mokena rorobo de ka neidededi, Sei di gubuyo tora iniye moigedi ma buburu vai rei mona rego. ");
INSERT INTO kqc_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Amiye neinei kaere vegu no redo bi toe ma uka vorivori rena moigo; bi Jew amiye rofu siko vata nigo ma gabi tutubena idana amiye rofu ka. ");
INSERT INTO kqc_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Idu amiye neinei kaere vegu buni redo bi vabara, kikifa rena ma uka amuta moigo; bi Jew amiye rofu siko vata nigo ma gabi tutubena idana amiye rofu ka. ");
INSERT INTO kqc_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Adina Sei yaku amiye neinei rofu ida yokoi makari kota redo. ");
INSERT INTO kqc_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Adina ago gira nufa de vene tau bi vegu no regamadi, ina ka bi ago gira nufa de makai muyegedi, ma ago gira gabireri amededi vene tau bi ago gira dudu kota rego. ");
INSERT INTO kqc_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Adina kaere ago gira neidededi bi Sei di nemokori mokena rorobo nufa de, idu ago gira usi rededi vene, ina bi vegu rorobo nigedi. ");
INSERT INTO kqc_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Adina tutubena idana vene, kaere bi Moses di ago gira nufa de, ini vegu dudu ago gira di ago usi regediri, bi iniye iniye di ago gira, bi Moses di ago gira ka inasa de. ");
INSERT INTO kqc_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Moi rama aededi ago gira di reremama bi ini ukari bura reyo, ma ini uka di mokena ka makai ninegau redo ma, ini mokena berou berou dudu iniye iniye nitourage rededi o nigira rededi. ");
INSERT INTO kqc_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ye mina medari, ago buni nirausi regamaka dada, Sei yaku Iesu Keriso dudu amiye di sui nina mokena kota rego. ");
INSERT INTO kqc_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Idu, ya kaere ya kaya rofu nisa bi Jew amiye ma ago gira damani resi Sei ni-ika reisa bi gokai? ");
INSERT INTO kqc_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Sei yaku beika ya regi ura redo ya diba, ma beika bi buni vayavaya ya ka yo nisa, bi ago gira ya rofu oteimagamadi dada. ");
INSERT INTO kqc_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ye yi mokena buni dudu, ya kaya ne taufa vene ourefeidesi mukunari amededi vene rofu vabara nigiya. ");
INSERT INTO kqc_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ya bi ada de vene ma mida mida di oteimana amiye, ya bi ago gira di diba nina ma ago rama beika baika tau nufa dada. ");
INSERT INTO kqc_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ya yaku bedakai vene oteimaisa, idu ya kaya oteimaisa ba? Ya duma rededi vene rofu ago nirausi resi duma ga reyagane, idu ya ka duma reisa ba? ");
INSERT INTO kqc_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ya amiye rofu nisa koa ga reyagane, idu ya koa reisa ba? Ya ofa ofa sei gubuyo reisa, idu ya kaya bi ini nivakena yavari beika amedo, mina duma reisa ba? ");
INSERT INTO kqc_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ya kaere ago gira rofu nivasena reisa, bi ago gira odena dudu Sei kikifa de reisa. ");
INSERT INTO kqc_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Adina bura reyo kana, “Tutubena idana vene yaku Sei di roka moi no ridedi, ya Jew vene dada.” ");
INSERT INTO kqc_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Adina ago gira neideisa vonisi, roaita nugana bi buni; idu ya ago gira odeisa vonisi, roaita nugana bi roaita nugana de kana nigo. ");
INSERT INTO kqc_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ye, amiye yokoi kaere roaita de nugaro, bi ago gira di ago neidego vonisi, bi roaita nugaro kana nigo ba? ");
INSERT INTO kqc_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ye roaita de nugaro amiye, kaere ago gira neidedo, bi ya kaere bura reyo ago gira ma roaita nugana nufa, idu ago gira odeisa, bi ya nifafana rego. ");
INSERT INTO kqc_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Adina amiye yokoi bi Jew de amiye, kaere bi roaita maka nugaro, ini adina bi roaita nugana bi diya roaita etofaro. ");
INSERT INTO kqc_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Idu Jew amiye rama bi makai ini ideri, ma ini roaita nugana bi uka meko di, Vima dudu, vana yaku bura rena ago gira dudu de. Ma amiye ini roka moi odoro rina bi de, idu Sei rofu. ");
INSERT INTO kqc_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ye Jew amiye di buni bi beika? O roaita nugana di buni bi beika? ");
INSERT INTO kqc_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ida tau vanu dudu ini buni bi rama iniye. Ouresi bi Sei di ago Jew vene rofu nimagamo. ");
INSERT INTO kqc_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ye bedakai yaku mokena vari gira de aeyadi vonisi, bi beika? Ini mokena vari gira de aena bi Sei di vegu rama rena moi koina rigo ba? ");
INSERT INTO kqc_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ide iniye! Sei bi rama iniye, idu amiye tau gade ka bi ofa ofa ago nidedi vene. Bura reyo kana, “Ye yi agori rama nigiya; ma ya kota rego medari ya bi ebu rego.” ");
INSERT INTO kqc_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Idu amiye yokoi yaku nigo, uni mokena rorobo de vegu bi buni, adina makai dudu amiye yaku Sei di mokena rorobo bi gokai vegedi. Mina kana, Sei yaku ini gubuyo tora una rofu maro, mina bi mokena rorobo de vegu nigifa ba? (Nai ago bi amiye di ago kana.) ");
INSERT INTO kqc_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ide iniye! Adina gokai dudu Sei yaku kono tora noibanu di amiye kota rego? ");
INSERT INTO kqc_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Idu nai ofa ago dudu, Sei di ago rama bi ini vabara moi ogau iniye rigo vonisi, na bi beika resi vegu no redo amiye kana nifafana redo? ");
INSERT INTO kqc_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Bedakai nifafana resi nidedi uni ago bi, “Ye vegu no renadi kumo buni baku regifa.” Ye Sei di kota rena bi rama. ");
INSERT INTO kqc_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ye makai una Jew vene bi buni iniye ba? Ide iniye iniye! Adina senagi nioteimarafa, Jew vene ma tutubena idana vene, ina vene tau vakoi bi vegu no di vava gabireri amededi. ");
INSERT INTO kqc_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Bura reyo kana: “Amiye yokoi mokena rorobo nufa de, yokoi de iniye iniye; ");
INSERT INTO kqc_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","yokoi de yaku vegu buni diba nido, ma yokoi de Sei maina redo. ");
INSERT INTO kqc_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ina tau vanu gedu maradi; tau vakoi rei tavoi reyadi; yokoi maka yaku buni de redo, yokoi de iniye iniye. ");
INSERT INTO kqc_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ago ninari ini vena sau bi amiye guri ruba fafa rina de kana; ini afiye dudu eru rededi, gadeva aruma di gemiso no bi ini venari. ");
INSERT INTO kqc_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Kiraini ma ago ru yaku ini vena vata baeyadi. ");
INSERT INTO kqc_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ini yuka dudu bi evade raga resi dava rausi regika; ");
INSERT INTO kqc_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","moi kekevata una ma moi no rena bi ini dina idari amededi. ");
INSERT INTO kqc_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ma uka amuta di ida bi diba de niyadi. ");
INSERT INTO kqc_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ini nemokori ka bi Sei ori de rededi.” ");
INSERT INTO kqc_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Gua una diba beika ago gira yaku nido, bi kaere ago gira di vava gabireri amedo ina rofu nido, ye vena biri risi ago nina de, ma kono tora noibanu di vene tau bi Sei di nemokori ini vegu dada kota regi are reyaganedi. ");
INSERT INTO kqc_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Adina ini nemokori ago gira usi dina dudu, amiye yokoi bi vegu rorobo de nigo, ago gira dudu vegu no neide mama rego dada. ");
INSERT INTO kqc_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Idu gua Sei di mokena rorobo bi ago gira etofarori moi ogau riyo, adina ago gira ma Sei di ago niyadi vene di ago ina rofu ninegau rededi. ");
INSERT INTO kqc_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Sei yaku amiye di mokena vari gira Iesu Keriso rofu aena dudu amiye moi rorobo rido; mina bi amiye tau gade rofu, kaere mokena vari gira aededi. Adina bi idana de: ");
INSERT INTO kqc_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","mina bi amiye tau gade yaku vegu no resi Sei di vabara moina, bi ne tumuri keto reyadi. ");
INSERT INTO kqc_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ye davana de nufa, beika buni tora gade maro dudu vegu rorobo niyadi; mina bi Iesu Keriso yaku voi resi erufuyo. ");
INSERT INTO kqc_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ina bi kaere Sei yaku ini dava dudu, vegu no di obini voi regi ori sisika kana aeyo. Ye mokena vari gira aenari moigedi; ma makai reyo, Sei di mokena rorobo oteimagi, ini toro renari sena reyadi vegu no moi tai reyo dada. ");
INSERT INTO kqc_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Makai Sei yaku gua ini mokena rorobo oteimaro, ye makai bi rama ma kaere Iesu rofu mokena vari gira aego, ina rofu nigo ini vegu bi rorobo. ");
INSERT INTO kqc_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mina dada uni nivasena rena bi beika? Bi de iniye. Ago gira neidesi nivasena reyafa, makai mokena rorobo moiyafa ba? Ide, bi mokena vari gira aena dudu maka mokena rorobo moisifa. ");
INSERT INTO kqc_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Adina amiye yokoi mokena vari gira aena dudu maka, bi vegu rorobo nigo mina mokesifa, ma ago gira di reremama dudu bi de. ");
INSERT INTO kqc_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ye Sei bi Jew vene di Sei maka ba? Ye ina ka bi tutubena idana vene di Sei ide ba? Yo, ina ka bi tutubena idana vene di Sei, ");
INSERT INTO kqc_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","adina Sei bi yokoi maka dada. Ye roaita nugana vene ini mokena vari gira aena dudu vegu rorobo nisi roaita nugana de vene mokena vari gira aena dudu ka vegu rorobo nigo. ");
INSERT INTO kqc_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mina dada mokena vari gira aena dudu ago gira moi eyaresifa ba? Ide iniye! Idu, ago gira moi gigi risifa. ");
INSERT INTO kqc_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ye Abraham uni dava di tutubena yaku beika baku reyo mina fafau bi beika nigifa? ");
INSERT INTO kqc_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Adina Abraham bi reremama buni dudu moi rorobo riyo vonisi, bi beika yokoiri nivasena rego nufa—idu Sei di nemokori bi de. ");
INSERT INTO kqc_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Adina Sei di agori bi niyo, “Abraham yaku Sei rofu mokena vari gira aeyo, ye makai bi mokena rorobo kana nimaro.” ");
INSERT INTO kqc_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Gua reremama buni redo amiye di obini bi beika baika rei maro dada ina rofu de nimaro, idu ini moimai di obini rama kana maro. ");
INSERT INTO kqc_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ma reremama buni de redo, idu Sei rofu mokena vari gira aedo amiye, Sei di mokenari ini mokena vari gira aena bi mokena rorobo kana, adina Sei yaku vegu no rededi vene rofu nido ini vegu bi rorobo. ");
INSERT INTO kqc_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Sei yaku mina reremama buni de redo amiye mokena rorobo rena kana nimaro, kaere bi buni tora gade maro. Ma David ka bi mina amiye rofu makai ago niyo: ");
INSERT INTO kqc_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Ago gira nufa de vegu koite makuyo ma vegu no moi etagae ri maro vene bi ada regedi! ");
INSERT INTO kqc_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Varika amiye yaku kaere ini vegu no mokei toto nigo amiye bi ada reyaine!” ");
INSERT INTO kqc_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mina dada mina buni tora gade bi roaita nugana vene rofu maka ba roaita nugana de vene rofu ka? Adina niyafa kana, “Abraham di mokena vari gira aena bi mokena rorobo kana nimaro.” ");
INSERT INTO kqc_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Gokai ina rofu nimaro? Bi senagi roaita nugaro ba roaita nugana koderi? Bi roaita nugana koderi. ");
INSERT INTO kqc_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ma ina bi roaita nugana koderi, ini mokena vari gira aesi roaita nugana di rebe ogau niyo, ini mokena vari gira aeyo di mokena rorobo di rebe kana. Mina bi roaita nugana de mokena vari gira aeyadi vene tau gade ini baba nigi dada, mina resi ina vene rofu ka mokena rorobo vonisi, ina fafau niyagadu. ");
INSERT INTO kqc_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ma roaita nugana vene di baba ka nigi; ina vene kaere bi roaita nugana de maka, idu ka uni tutubena Abraham senagi roaita nugana koderi, mokena vari gira aeyo di anukari nana rededi. ");
INSERT INTO kqc_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Adina Abraham ma ini tutubena rofu, Abraham bi kono tora noibanu vene di biyaguna nigo di nitore rena ago, bi ago gira dudu de maro, idu mokena vari gira aena di mokena rorobo dudu maro. ");
INSERT INTO kqc_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Adina ago gira usi dina vene bi biyaguna nigedi 