﻿USE sofia;
DROP TABLE IF EXISTS sofia.kqa_vpl;
CREATE TABLE kqa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kqa_vpl WRITE;
INSERT INTO kqa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nɨŋandɨhin Jisas Krais nɨŋuñɨŋgitakɨñandu kuyu. Jisas nu Devit nɨŋuñɨŋgi. Devit nu Abraham nɨŋuñɨŋgi. ");
INSERT INTO kqa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Aisak nɨŋuva. Aisak Jekop nɨŋuva. Juda nɨŋusinava naŋga nɨŋuranava nɨŋuva Jekop. ");
INSERT INTO kqa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Peres naŋga Sera nɨŋuva Juda, nurɨŋandɨ nɨŋum Tamar. Peres Hesron nɨŋuva, Hesron Ram nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram Aminadap nɨŋuva, Aminadap Nason nɨŋuva, Nason Salmon nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Boas nɨŋuva, Boas nɨŋum Rahap. Boas Obet nɨŋuva, Obet nɨŋum Rut. Obet Jesi nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi, aru miku Devit nɨŋuva. Devit Solomon nɨŋuva. Solomon nɨŋum Batseba, Batseba Uria kindahu. ");
INSERT INTO kqa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rehoboam nɨŋuva, Rehoboam Abiya nɨŋuva, Abiya Asap nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asap Jehosafat nɨŋuva, Jehosafat Jehoram nɨŋuva, Jehoram Usia nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia Jotam nɨŋuva, Jotam Ahas nɨŋuva, Ahas Hesekia nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia Manase nɨŋuva, Manase Emon nɨŋuva, Emon Josaia nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia Jehoiakim naŋga nɨŋuranava nɨŋuva. Kandɨhɨrɨvɨ hañɨ Babilon hati pata Israel saŋga kurɨhata, Israel hatiŋ mɨŋata uta Babilon tamahu sɨmbɨra tɨkatɨka mɨŋamu. ");
INSERT INTO kqa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon kɨta sɨmbɨra tɨkatɨka mɨŋamu hɨrɨvɨyɨ Jehoiakim Sealtielɨŋ kavumi. Sealtiel Serubabel nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel Abiut nɨŋuva, Abiut Eliakim nɨŋuva, Eliakim Asor nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sadok nɨŋuva, Sadok Akim nɨŋuva, Akim Eliut nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut Eleasar nɨŋuva, Eleasar Matan nɨŋuva, Matan Jekop nɨŋuva. ");
INSERT INTO kqa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop, Josep nɨŋuva, Maria nɨmuŋa. Maria Jisasɨŋ kavuhi, Jisasɨrɨm Krais vandu. ");
INSERT INTO kqa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jisasɨndu krunzapayɨndu kimaŋgima hama Abraham. Abrahamɨyɨ kɨta 14 krunzapa sɨwɨtɨmbɨyɨtɨmbɨyɨ ñɨŋi kavumu patavata Devitɨyɨ. Devitɨyɨ kɨta 14 krunzapa sɨwɨtɨmbɨyɨtɨmbɨyɨ ñɨŋi kavumu patavata Jehoiakim kuhɨrata tɨhi, mɨŋata Babilon umu. Babilon uta sɨmbɨra tɨkatɨka mɨŋamu takuk hañɨ kɨta 14 krunzapa sɨwɨtɨmbɨyɨtɨmbɨyɨ ñɨŋi kavumu patavata Krais kuhɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais yahami vana haŋandɨhin nɨmata. Nɨŋum Mariaŋ, Josepɨrɨm mɨŋavɨhumu. Hara kɨhɨrɨ upɨ maŋgarɨhɨmat kɨta tɨhu, Gotɨndu Mavɨñɨŋi mavɨndaŋguramahi mavɨnaŋgandɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nɨmuŋa Josep, nu tɨtɨtaya kɨyɨhɨyɨ mɨŋga. Maria naŋga kɨhɨrɨ upɨ maŋgarɨhandu. Harɨm Maria kɨpɨ naŋgandɨhi ŋgata, krunavundindu tamɨŋgaŋgɨmbañɨ pɨŋguvarɨtɨnda Maria sɨwɨmanzɨwɨmandɨtima vata, aviñam hañɨ kɨta nuŋ mitɨrɨm indarɨmitami. ");
INSERT INTO kqa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kamatɨrɨman vata indarɨmitata kɨyɨmiyɨ, kɨvɨyɨ karɨhata akwɨsɨhuyɨ Aru nɨmandu kutɨkara hamaŋ ŋgahi nuŋ nɨmavami, Josep, Devit nɨŋuñɨŋgi ŋgana, ñɨŋi mavɨ humbambu kɨyɨ haŋandɨhin Gotɨndu Mavɨñɨŋi mavɨndaŋguramahi kɨpɨ naŋgandɨsɨmi. Harɨm Mariaŋ uraurarɨm pɨŋimandu. ");
INSERT INTO kqa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu kru ñɨŋi kavɨrɨmandɨ. Nu tɨhi nuŋandɨ krunavundi ñamba vanavana andɨndu haŋɨnɨŋ sɨhiŋgata nurɨŋ ŋguramata aŋga mɨŋɨmandɨ. Harɨm nuŋ ñɨmbi ŋguta Jisas vamba amba, vami. ");
INSERT INTO kqa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Kru Gotɨndu kuyu mɨŋata ambavaravara hama ambami, Ŋgamara, navundi muŋambɨ kru naŋga kɨhɨrɨ upɨ maŋgarɨhatara kɨpɨ naŋgandɨta, kru ñɨŋi kavɨrɨmandɨ. Kamati nuŋandɨ ñɨmbi Emanuel vɨrɨmandɨyu, vami. Kanɨmavami kuyu nɨŋandɨhin kandɨsɨkwɨsɨkwɨ yɨvurahi. Emanuel ñɨmbi kanɨŋandɨhindu kuyu sapa ha nɨmata, Got ara naŋga kɨyɨ. ");
INSERT INTO kqa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kamavahi Josep karɨhata yahamɨrata Aru nɨmandu kutɨkara ambami maña Mariaŋ urami. ");
INSERT INTO kqa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hara Maria naŋga kɨhɨrɨ upɨ maŋgarɨhɨmat kɨyɨhi ututa Maria kru ñɨŋi ha kavuhi Josep ñɨmbi ŋguta Jisas, vami. ");
INSERT INTO kqa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Herot aru miku mɨŋga kɨyɨmi hɨrɨvɨyɨ, Maria Jisasɨŋ pɨrɨvɨsa Judia pɨhu Betlehem kavumi. Kamatɨhi indarɨmit avi naŋga muvɨra ina yahayahavundu haŋɨnɨŋ pata Jerusalem yɨvurahata nɨmavamba kitɨhumu, Ñɨŋi kɨhi Judandu aru miku yahami kandɨha pambu kɨyɨ. Nuŋandɨ kinɨkɨ ina yahayaha nɨmbu kɨta ŋgata nuŋandɨ ñɨmbi tɨhuyahɨrɨm parɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kamavahu aru miku Herot kuyu kandɨha indarɨhira nuŋandɨ mavɨ hambu avi mandɨmi. Jerusalemɨndu krunavundi ndahara sɨhanaŋga nurɨŋandɨ mavɨ hambu avi mandɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kamata Herot yahata Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga Israelɨndu tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ ambahi pata tɨhɨruhu nurɨŋ nɨmavamba kitɨhumi, Got krunavundiŋ aŋga mɨŋɨmandɨ vata yɨhɨramami kru kandɨhama pɨhu pañɨ nzɨkwɨ yɨvurahɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kamavahi nɨmavamu, Pɨhu Betlehem, pɨrɨvɨsa Judia nduyɨ yɨvurahɨmandɨ. Kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga kuyu nɨmata yɨhimbɨvɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pɨhu Betlehem, krunzapa Judandu pɨrɨvɨsayɨ kɨndana. Krunzapa Judandu pɨrɨvɨsayɨ pɨhu aruru muvɨra haŋɨnɨŋ ñɨmbi naŋga. Nandahara ñɨmbi naŋga. Nandɨ kru mumɨŋga aru miku mɨŋga yɨvurahata Gotɨndu krunavundi Israel hatiŋ karatamɨrɨmandɨ vamba yɨhimbɨvɨrami, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kamavahu Herot kuyu kandɨha indarɨta kru mumɨŋgaŋ aviñam ambahi, uta kru indarɨmit avi ina yahayahavundu haŋɨnɨŋ ambahi payɨmu. Payɨhu nurɨŋ nɨmavamba kitɨhumi, Pamata hɨrɨvɨyɨ kinɨkɨ kandɨha yɨvurahahi ŋgamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kamavata nurɨŋ ambami. Uta ñɨŋi kandɨha avindamata puhɨramaŋgarata ŋgata, pata yaŋ ambɨtɨra yindahara uta nuŋandɨ ñɨmbi tɨhuyahɨtɨn, vami. Kamavata sɨmbɨhi Betlehem umu. ");
INSERT INTO kqa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Aru miku Herot ambavarahi indarɨta mɨtuta umu. Uta kinɨkɨ ina yahayahavu kɨta ŋgamu sɨwɨ haŋandɨhin ŋgata kɨnzɨhɨnzɨtɨmu. Kinɨkɨ kandɨha kasiramata uhihi nurɨ sɨhɨndɨ umu. Uta tavɨ ñɨŋi kɨyɨmi hañɨ kɨmba hambu kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kamata indɨhuta ñɨŋi ha naŋga nɨŋum Mariaŋ ŋgata tanda mɨkwɨmɨkwɨnɨta kɨpumɨka nurɨŋandɨ ha pɨrɨyɨ tamahu mɨŋguhi ñɨŋi hamandu ñɨmbi tɨhuyahamu. Kamata paŋaŋgara ha mɨŋavɨhɨrɨta muhɨmɨmuhɨm mɨŋata payɨmu haŋɨnɨŋ, gol, naŋga sambaŋgihɨvɨ maña hɨm kɨrahu kɨnza avi yahandi hɨm, naŋga paura uvɨŋgɨnza avi yahandi haŋandɨhin asɨhuramata Jisasɨŋ ŋgumu. ");
INSERT INTO kqa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kamatɨhu Got akwɨsɨhuyɨ nurɨŋ nɨmavami, Uta sɨhinda Herot kɨyɨ hañɨ mayɨvurahamara, vami. Kamavahi mu hɨndɨñɨ nurɨŋandɨ pɨhuyɨ aŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kru indarɨmit avi naŋga haŋɨnɨŋ uhuhu, Aru nɨmandu kutɨkara pata akwɨsɨhuyɨ Josepɨŋ nɨmavami, Herot ñɨŋi nɨmaŋ puhɨravuhɨraramata ŋgata yɨvutatamɨrɨman vata andɨtɨhi yahamɨrata ñɨŋi naŋga nɨŋumɨŋ tɨmbuta tɨvata Isip umara. Uta kɨta yandɨ kuyurɨm tavɨra, vami. ");
INSERT INTO kqa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kutɨkara hama kamavahi Josep yahata nɨŋumɨŋ naŋga ñɨŋi hamaŋ tɨmbuta Isip kɨvɨyɨ umu. ");
INSERT INTO kqa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kamata Isip kɨyɨhuhu Herot kɨmumi. Kandɨ vana nɨŋandɨhinɨrɨm Aru nɨma, kru nuŋandɨ kuyu mɨŋata ambavaravara mɨŋgaŋ ambahi, nɨmavami, Yandɨ kru ñɨŋi Isip kɨyɨhi ambahin Isip mitata payɨ, vami. Kamataharɨm Aru nɨma ambami vana nɨŋandɨhin kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kru indarɨmit avi ina yahayahavundu haŋɨnɨŋ uhuhu, Herot yaŋ kuyusɨhɨrata mu hɨndɨyɨ umu vata kɨtɨrɨ kɨyɨmi. Kuha Herot kru indarɨmit avi ina yahayahavundu haŋɨnɨŋ kitɨhuhi ambamu, Kinɨkɨ ŋgamarɨŋ ha arɨkinzimbi umiha, vamu. Kamataharɨm kru muvɨraŋ sɨmbɨhi pɨhu Betlehem naŋga pɨhu makamaka arɨñɨarɨñɨ kɨyɨmuyɨ umu. Uta kru ñɨŋi taya arɨkinzimbi naŋga mɨŋgata haŋɨnɨŋ yɨvuhɨmumbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Muhɨmɨmuhɨm vana kanɨŋɨnɨŋɨrɨm Got ambahi, kru Gotɨndu kuyu mɨŋata ambavaravara Jeremaia ambami, Pɨhu Rama, Resel nɨŋuñɨŋgiñandu ñɨŋisɨm kɨmumbɨramu. Kamatɨhu ñɨŋi nɨŋumɨnava haŋɨnɨŋ irɨhɨnzɨhi tamamu. Kamatɨhu krunavundi muŋɨnɨŋ pata nurɨŋ mɨŋañɨŋarɨtɨrɨŋ mavɨñam hañɨ kɨyɨmu vata andɨhura kambu maŋindarɨmu, vamba ambami haŋandɨhin, kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep Isipɨndu pɨrɨvɨsayɨ kɨyɨhihi, Herot kɨmutatɨhi Aru nɨmandu kutɨkara hama Josepɨŋ akwɨsɨhuyɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kamata Josepɨŋ nɨmavami, Ñɨŋi nɨmaŋ yɨvutatamɨndaŋ vata andɨsɨmu haŋɨnɨŋ kɨmusɨmu. Harɨm yahamɨrata ñɨŋi ha naŋga nɨŋumɨŋ tɨmbuta pɨrɨvɨsa Israel aŋga umara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kamavahi Josep yahata ñɨŋi ha naŋga nɨŋumɨŋ urata pɨrɨvɨsa Israelɨrɨm aŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hara, Arkelaus nɨŋuva Herotɨndu upɨ mɨŋata pɨrɨvɨsa Judiandu aru miku mɨŋga kɨyɨ vahu Josep indarɨta kandɨhambu uhuhurɨm pɨŋitumi. Hara Aru nɨma akwɨsɨhuyɨ Josepɨŋ nandɨ indarɨmit ha kandɨ vamba ambami. Kamavahi yahata pɨrɨvɨsa Galili umu. ");
INSERT INTO kqa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Uta pɨhu Nasaret mɨnzɨmu. Harɨm kuha kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ ambamu, Kru nɨma pɨhu Nasaretɨndu mɨŋga vamba ambɨrɨmandɨyu, vamu haŋandɨhin, kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kandɨhɨvɨ hañɨ Jon kukuyɨ mɨŋaŋgɨruhɨru hama pɨrɨvɨsa Judia, kru manɨman upɨvu umi. Uta krunavundiŋ nɨmavamba kuyu ŋgumi, ");
INSERT INTO kqa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha arɨñɨndɨ. Harɨm ñamba vanavana ha mitata mavɨŋgimɨrumara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Got ambahi kru Gotɨndu kuyu mɨŋata ambavaravara Aisaia Jonɨrɨm nɨmavami, Kru manɨman upɨvu kru mumɨŋga kuyu kɨmbañɨ nɨmavɨrɨmandɨ, Aru nɨmarɨm kwɨmbɨ sɨwɨtamata, kwɨmbɨsiki sukɨsɨrambɨ haŋɨnɨŋ mɨŋasɨrɨvamara, vamba ambɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonɨndu mɨkwɨrɨ ha, kamel mɨrɨkwɨyɨ sɨvirɨmu. Kandɨhaŋandɨhin tamata aŋgɨ simbɨyɨ yɨvumɨŋgundi. Aŋgɨ kandɨhaŋandɨhin memendu pɨsayɨ musa mɨŋamu. Jon kandɨhama ñaña sɨkwɨ mañandi. Kapɨrɨmbatɨvat naŋga mɨmɨ mɨkwɨ taya ñandi. ");
INSERT INTO kqa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kandɨhɨrɨvɨ haŋu Jerusalem hati, Judia hati naŋga pɨrɨvɨsa kuku Jordan arɨñɨ kɨrasɨmu haŋɨnɨŋ Jon kɨrasɨmiyɨ parasɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kamatɨndɨ ñamba vanavana andɨndu haŋɨnɨŋ ambavarahuhu nurɨŋ Jon, Jordan kukuyɨ mɨŋaŋgɨrundi. ");
INSERT INTO kqa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kamatɨhihi Farisi naŋga Sadyusi muvɨra, utɨrɨŋ arɨŋ kukuyɨ mɨŋaŋgɨrum vata payɨmu. Kamatɨhu nurɨŋ ŋgata nɨmavami, Tau ñambandu ñɨŋi narɨ. Narɨŋ nin ambahi Got narɨŋɨrɨm kɨtɨrɨ kɨta ñamba hɨvɨ ŋgurɨmandɨ nɨŋandɨhinɨrɨm tarahɨrɨmɨndaŋ vata andɨra. ");
INSERT INTO kqa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Narɨ mavɨŋgimɨrurɨŋ nzɨkwɨ vataŋgata, muhɨmɨmuhɨm vana andɨtɨra kru muŋɨnɨŋ ŋgamu. Kamata ambɨrɨmandɨyu, Nurɨ mavɨŋgimɨruyu, vamba ambɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Narɨŋandɨ indarɨmitɨyɨ, Abraham arɨŋandɨ añɨŋgitak vamba maŋindarɨramamara. Narɨŋ yinda ambin, Got ambɨti tɨmba muŋgɨmuŋgɨ nɨŋɨnɨŋ narɨŋandɨ upɨ mɨŋata Abraham nɨŋuñɨŋgiña yɨvurahahu. ");
INSERT INTO kqa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kahɨri ha ahu tahɨratahɨrarɨm kɨmɨta kɨyɨ. Harɨm ahu sɨhanaŋga kandɨ mandamandu haŋɨnɨŋ tahɨrandahɨra ahumirayɨ kavarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yi narɨŋ mavɨŋgimɨrumaraŋa vata kukuyɨ mɨŋaŋgɨrundin. Hara kru sɨhɨndɨvu payɨmandɨ hama narɨŋ Gotɨndu Mavɨñɨŋiyɨ naŋga ahumirayɨ mɨŋaŋgɨrumandɨ. Nuŋandɨ tɨkatɨka ha aru sɨkwɨ, yandɨ tɨkatɨka taratɨvɨrandi. Yi avi mɨŋganzɨkwɨ ma, harɨm nuŋandɨ tandambɨsa ha maŋgavuhin. ");
INSERT INTO kqa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nu wit taratara tɨmba ha mɨŋata payɨmandɨ. Kamata wit ha tarandara tɨhuyahɨtiti pipɨrɨmbipɨrɨ ha muvu mɨŋgaramɨti avi haŋɨnɨŋ muvu mɨŋgaramɨti mɨŋata nuŋandɨ huyɨmandavɨyɨ tamɨmandɨyu. Kamata ñambañamba haŋɨnɨŋ ahutuvarandiyɨ kɨrɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kandɨtɨwɨmi hañɨ Jisas pɨrɨvɨsa Galili mitata, Jon yaŋ kukuyɨ mɨŋaŋgɨrumandɨ vata kuku Jordan umi. ");
INSERT INTO kqa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hara Jon nuŋ karirahɨrɨman vata nɨmavami, Na yaŋ kukuyɨ mɨŋaŋgɨrunanda avindɨhi. Mumɨndɨhi kɨmbɨnzɨnzɨ yi kɨnɨ nɨñɨ pana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kamavahira Jisas kɨmbɨ nuŋ ambami, Kɨndam, tɨhu yi ambin mañandaya andɨ. Nanaŋga kanɨmata vana andɨtanda, Got avi vana sɨhanaŋga andɨmara vata pirɨ kɨndi haŋɨnɨŋ andɨmɨndaŋ, vami. Kamavahi Jon, Jisas ambami maña andɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kamavahi Jon, Jisasɨŋ kukuyɨ mɨŋaŋgɨruta mɨtuhi yahami. Kamatɨhi ihunzɨhɨ haŋɨnɨŋ taruvɨhɨrɨhi, Jisas tɨhɨrata yahuta Gotɨndu Mavɨñɨŋi haŋandɨhin ŋgahi kava umari maña nu kɨyɨmiyɨ mɨŋgami. ");
INSERT INTO kqa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kamatɨhi Gotɨndu pɨhu nɨmbu kuyu samur muŋandi nɨmavami, Ñɨŋi nɨŋandɨhin yandɨ mavɨndamandin mɨŋga. Yandɨ mavɨnɨmbu nuŋɨrɨm kɨnzɨhɨnzɨtɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kandɨtɨwɨmi hañɨ Gotɨndu Mavɨñɨŋi Jisasɨŋ, pɨrɨvɨsa kru manɨman upɨvu nuŋ Satan mɨŋamɨŋgɨrɨmandɨ vata tɨmbuta umi. ");
INSERT INTO kqa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kamatɨhi Jisas 40 hɨvɨ itɨhañata inayɨ kɨvɨyɨ mañɨmat avɨharɨm kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kamatɨhi Satan pata Jisasɨrɨm nɨmavami, Kandɨ na Gotɨndu Ñɨŋitiŋgata tɨmba muŋgɨmuŋgɨ nɨŋɨnɨŋ ambɨna mavatɨmba yɨvurahamu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kamavahira Jisas nuŋ nɨmavami, Gotɨndu aŋgwɨmɨkɨyɨ kuyu nɨmata kɨyɨ, krunavundi ñañayɨ taya maŋgɨndu. Hara Gotɨndu kuyu mɨŋata mavɨñɨ tamata mɨŋa tɨkatɨkatɨhana handa sɨha kɨyɨhana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kamavahi Satan Jisasɨŋ tɨmbuta Gotɨndu pɨhu aru Jerusalem uta, Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨndu tapa kɨmbandɨkatɨkayɨ tamami. ");
INSERT INTO kqa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kamata Satan yahata Jisasɨŋ nɨmavami, Gotɨndu aŋgwɨmɨkɨyɨ ambami, Got nuŋandɨ kutɨkara haŋɨnɨŋ sɨmbɨti pata kumandamata naŋ mɨŋahandata kavuta urɨmandɨyu. Kamatu tɨmba muyɨputak ndahara nandɨ tanda ha mandarahandɨrɨmandɨ, vamba ambami. Harɨm na Gotɨndu Ñɨŋitiŋgata, kumbɨtɨhuta mɨŋgu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kamavahi Jisas nɨmavami, Hara Gotɨndu aŋgwɨmɨkɨyɨ kuyu nɨmata ndahara kɨyɨ. Got nandɨ Aru nɨmandu tɨkatɨkarɨm mamɨŋa mɨŋga, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jisas kamavahi, sɨhinda Satan nuŋ tɨmbuta apu kɨmbandɨkatɨkayɨ yahumi. Kamata nuŋ pɨrɨ nɨñɨndu pɨrɨvɨsa sɨhanaŋga tɨkatɨka haŋɨnɨŋ, naŋga nurɨŋandɨ muhɨmɨmuhɨm avivi kɨyɨmi haŋɨnɨŋ isɨhuramami. ");
INSERT INTO kqa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kamata Jisasɨŋ nɨmavami, Tanda mɨkwɨmɨkwɨnɨta yandɨ ñɨmbi tɨhuyaha. Kamatɨna naŋ muhɨmɨmuhɨm kanɨŋɨnɨŋ ŋgurɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Satan kamavahi Jisas nuŋ nɨmavami, Satan, mikitamata uhu. Gotɨndu aŋgwɨmɨkɨyɨ nɨmavami, Got nandɨ Aru nɨmandu tɨwɨyɨ taya kɨñɨ. Kamata nuŋandɨ ñɨmbi tɨhuyahata, nuŋandɨ sɨmbɨra taya mɨŋa, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas kamavahi Satan mitata uhihi Gotɨndu kutɨkara haŋɨnɨŋ pata nuŋ ŋguramamu. ");
INSERT INTO kqa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas, Jonɨŋ mɨŋata kru ñamba vana andɨhu tamandu upɨyɨ tamasɨyu vahu, kuyuhɨnzɨ indarɨta pɨrɨvɨsa Galili umi. ");
INSERT INTO kqa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kamata pɨhu Nasaret mitata pɨhu Kaperneam umi. Pɨhu Kaperneam kandɨha indu Galilindu tɨvɨyɨ kɨyɨmi. Krunzapa Sebulun naŋga krunzapa Naptalindu pɨrɨvɨsayɨ kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Kuha Got ambahi kru Gotɨndu kuyu mɨŋata ambavaravara Aisaia ambami, Krunzapa Sebulunɨndu pɨrɨvɨsa naŋga krunzapa Naptalindu pɨrɨvɨsa kandɨha kwɨmbɨvat aru añakɨŋgukuyɨrɨm uhuhu tɨvɨyɨ kɨndi. Pɨrɨvɨsa kandɨha kuku Jordan timukari pɨrɨvɨsa Galili kɨndi. Pɨrɨvɨsa Galili kandɨhañɨ krunavundi sambɨ muvundumuvundu ŋɨnɨŋ kɨndu. Krunavundi kɨvɨmɨŋgwɨyɨ kuyu haŋɨnɨŋ sɨña ŋgayu. Naŋga krunavundi kɨmuhɨmurɨm pɨŋituta kɨvɨmɨŋgwɨyɨ kuyu haŋɨnɨŋ, nurɨŋɨrɨm sɨña yɨvurahi, vamba Aisaia ambami. Jisas uta kandɨhambu kɨndaŋgɨnda kuyu ŋguhi, Aisaia ambami kuyu ha kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kandɨhɨrɨvɨ haŋu nda kɨta Jisas kimaŋgima sɨmbɨra mɨŋata krunavundiŋ nɨmavamba ambavarami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha arɨñɨ payɨ. Harɨm ñamba vanavana andɨndara haŋɨnɨŋ mitata mavɨŋgimɨrumara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas indu Galili tɨvɨñɨndɨvɨñɨ ndaya umi. Uta kru nɨŋusi nɨŋuraŋ ŋgahi nurɨŋandɨ kamahayɨ ha indu hañɨ kavarata kɨyɨmu. Nɨŋusi Saimon, mu ñɨmbi hambu Pita, nɨŋura Andru. Arɨkimbat asa sɨmbɨra tɨmbahɨrɨsɨrɨm mɨŋandu ŋɨnɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kamata arɨkimbatɨrɨm Jisas uraramata nɨmavami, Avayɨmara, pata yi naŋga kɨndɨtɨra asa mɨŋandara maña narɨŋ krunavundiŋ mɨŋamɨŋarɨm ambaramɨtɨn ŋgamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kamavahi arɨkimbat sarɨwayɨŋandi nurɨŋandɨ kamahayɨ haŋɨnɨŋ mitata Jisas naŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kamata Jisas uhandata, nɨŋusi nɨŋura, Sebedindu ñɨŋisɨm, Jems naŋga Jonɨŋ ŋgami. Nurɨŋandɨ kamahayɨ haŋɨnɨŋ kundɨrahu sɨvirɨta kupik hɨmba hañɨ, nɨŋuva Sebedi nin kɨyɨmu. Kamatɨhuhu Jisas pata arɨkimbatɨŋ uraramami. ");
INSERT INTO kqa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kamatɨhi sɨkwɨ nda nurɨŋandɨ kupik ha naŋga nɨŋuvaŋ mitata arɨkimbat Jisas naŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas pɨrɨvɨsa Galilindu muvumuvu kɨndami. Kamatɨndɨ nurɨŋandɨ Got naŋga kuyundavaravara tavɨyɨ indɨhundɨhu krunavundiŋ ambaramandi. Gotɨndu tɨwɨyɨ kɨyɨhɨyɨndu kuyu avivi ambavarambara, muhɨmɨmuhɨm kandi naŋga muhɨmɨmuhɨm andɨhi krunavundindu kwɨrandɨ ñambatɨmi haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kamatɨhi nuŋambirɨm pɨrɨvɨsa Siriandu sɨhanaŋga ambavarata mɨtumu. Kamataharɨm krunavundi kru sɨhanaŋga muhɨmɨmuhɨm kandi nurɨŋ pɨsiŋgarahi kañɨnda aru kavumu haŋɨnɨŋ, sundɨ ñamba naŋga haŋɨnɨŋ, kru kandi andɨhi mɨŋgata yɨvuta nanaŋgarahu kuma tanda tɨkatɨkatɨndi haŋɨnɨŋ, naŋga punzɨ kɨmuhɨmu haŋɨnɨŋ Jisas kɨyɨmiyɨ tɨmbuta payɨmu. Kamatɨhu sundɨ ñamba haŋɨnɨŋ pɨŋguvarambara, kandi naŋga haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kamatɨhi krunavundi sambɨ pɨrɨvɨsa Galili hati, pɨrɨvɨsa Dekapolis hati, pɨhu Jerusalem hati, pɨrɨvɨsa Judia hati, naŋga pɨrɨvɨsa kuku Jordan timukari hati ndahara nu naŋga kɨndandu. ");
INSERT INTO kqa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas ŋgahi krunavundi sambɨ payɨhu, apuvu yahumi. Kamata mɨnzɨhi, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nu kɨyɨmiyɨ payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas nuŋandɨ sɨmbɨrasaraŋ ambaramata ambami, ");
INSERT INTO kqa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Krunavundindu mavɨñɨŋi tɨkatɨka mandɨhi Gotɨŋ ndaya tɨhɨraramandu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨ Gotɨndu tɨwɨyɨ kɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Krunavundi irɨhɨŋgukuyɨ kuyu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨŋ Got mɨŋañɨŋarɨti mavɨñamɨñɨ kɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Krunavundi nurɨŋandɨ ñɨmbi taŋguhu mɨŋgundi haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨŋ Got pɨrɨvɨsa nɨŋandɨhin sɨhanaŋga ŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Krunavundi avɨhatɨhi naŋga kukumɨtandɨhi andɨndu maña avi vana andɨtɨrɨm pirɨtamandu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨŋ Got ŋguramɨti avi vana taya andɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Krunavundi muŋɨnɨŋ ŋgata sɨhisɨhitɨta ŋguramandu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨŋ ndahara Got sɨhisɨhitɨta ŋguramɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Krunavundi Gotɨndu avi vanarɨmɨndaya indarɨmitandu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Nurɨ Gotɨŋ ŋgɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Krunavundi kuyumɨŋguta kurɨhahu, timu mɨŋa tamu mɨŋata mɨŋasɨrɨvandu haŋɨnɨŋ kɨnzɨhɨnzɨtɨmu. Kandɨhaŋɨnɨŋɨrɨm Got yandɨ ñɨŋisɨm, vɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Krunavundi avi vana andɨtu, muŋɨnɨŋ nurɨŋ kañɨnda ŋgutu kɨnzɨhɨnzɨtɨmu. Nurɨ Gotɨndu tɨwɨyɨ kɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kamata narɨŋ ŋgɨtu yandɨ ñiŋgiñɨ kɨtɨra, narɨŋ kuyu ñamba ŋguta, narɨŋ ñamba taŋguta kuyusɨhɨrɨŋguyu ihɨvarɨtu ndahara kɨnzɨhɨnzɨtɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kandɨhamata musa andɨtu ndahara aru kɨnzɨhɨnzɨtɨmara. Muhɨmɨmuhɨm avihɨmɨŋgɨm narɨŋambirɨm Gotɨndu pɨhuyɨ kɨyɨ. Kru Gotɨndu kuyu mɨŋata ambavaravara Gotɨndu haŋɨnɨŋ kasiramata umu haŋɨnɨŋɨrɨm ndahara sɨhwɨmaña musa nda andɨmu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas sɨhinda ambami, Narɨ pɨrɨ nɨñɨndu añak maña, hara añak kandɨha sɨnza yɨwarɨti pamatɨrɨŋ sɨhinda sɨnzandɨrɨmandɨ. Kandɨhamata añak haŋandɨhinɨndu sɨmbɨra maŋgɨndi. Harɨm kru taŋgusiŋgɨti taŋguyɨwɨyɨwɨtɨhu. ");
INSERT INTO kqa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Sɨwɨmañanzihɨ narɨ pɨrɨ nɨñɨndu sɨña maña. Harɨm nɨmata nɨmbu indarɨmara, pɨhu aru muŋandɨhin apuhɨtɨyɨ kɨndi haŋandɨhin manzipɨruhi. ");
INSERT INTO kqa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naŋga umbimbuŋgɨ sɨmuvɨramata sɨŋgɨyɨ mandarɨŋguñahu. Sɨkwɨtaya pina hɨmbañɨ tamahu sɨñandɨhi sɨhanaŋga kru tavɨ humbañɨ kɨndu haŋɨnɨŋ sɨñayɨ kɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kamataharɨm sɨña maña kɨta, krunavundindu tamɨŋgañɨ avi vana andɨmara. Kamatɨra avi vanavana andɨrɨmandɨra haŋɨnɨŋ ŋgɨmandɨyu. Kamata narɨŋandɨ nava nuŋandɨ pɨhuyɨ kɨyɨ hamandu ñɨmbi tɨhuyahɨrɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas sɨhinda ambami, Narɨ yambirɨm tɨkatɨka kuyu naŋga kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋɨndu kuyu mɨŋasiŋgunziŋgundɨrɨm payɨmi vamba maŋindarɨmitamara. Yi nurɨŋandɨ kuyu ha andɨtɨn kandɨsɨkwɨsɨkwɨ yɨvuraham vata payɨmin. ");
INSERT INTO kqa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yi narɨŋ kandɨ ambin, ihumbɨsa naŋga pɨrɨvɨsa nɨ siŋgundɨrɨmandɨ. Hara kuyu musɨmbɨrɨ Gotɨndu tɨkatɨka kuyuyɨ kɨndi ndahara manziŋgundɨrɨmandɨ. Yɨhi suksɨrambɨ naŋga munzɨ suksɨmbɨrɨ, Gotɨndu tɨkatɨka kuyuyɨ yɨhimbɨvɨramu haŋɨnɨŋ ndahara sɨhanaŋga kɨyɨmandɨyu. Kɨtuhɨtu taya ihumbɨsa naŋga pɨrɨvɨsa siŋgundɨrɨmandɨ hɨvɨ ha yɨvurahɨmandɨ. Gotɨndu tɨkatɨka kuyu kanɨmata taya kɨtihɨti muhɨmɨmuhɨm yɨvurahata mɨtɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kru mumɨŋga Gotɨndu tɨkatɨka kuyu mu sɨmbɨrɨrɨm nda tamahubɨrata, muŋɨnɨŋɨrɨm yi andɨn maña andɨmara vɨti andɨrɨmandɨyu. Kandɨhamata hama Gotɨndu tɨwɨyɨ kɨyɨmandɨ. Hara ñɨmbi manɨman mɨŋga kɨyɨmandɨ. Kru mumɨŋga Gotɨndu tɨkatɨka kuyu mu sɨmbɨrɨrɨm nda indarɨmitata andɨrɨmandɨ. Kamata yi andɨn maña andɨmara vata ambaramɨti muŋɨnɨŋ andɨrɨmandɨyu. Kru kandɨhamata hama Gotɨndu tɨwɨyɨ ñɨmbi aru naŋga mɨŋga kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yi narɨŋ ambin, Gotɨndu tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga, Farisi Got pirɨtamandi vana andɨndu. Narɨndahara Got pirɨtamandi vana andɨmara. Kamatɨra narɨŋandɨ vana ha, Gotɨndu tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga, Farisindu vana haŋɨnɨŋ taratɨvɨram. Kandɨhamata vana maŋandɨrɨmandɨra ha, Gotɨndu tɨwɨyɨ maŋgɨyɨmandɨra, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas sɨhinda ambami, Narɨ ŋgandara. Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami. Krunavundiŋ mayɨvutatamamara. Krunavundiŋ yɨvutatamɨrɨmandɨ hama ŋgatɨŋgɨrutɨŋgɨru hamandu tamɨŋgañɨ taŋguramɨrɨmandɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hara yi narɨŋ nɨmavin, kru mumɨŋga nɨŋusi vaha mana nɨŋura naŋga kuyu mɨŋgurɨmandɨ hama, ŋgatɨŋgɨrutɨŋgɨru hamandu tamɨŋgañɨ taŋguramɨrɨmandɨ. Ara kru mumɨŋga nɨŋusi vaha mana nɨŋuraŋ mɨkatihɨrɨmandɨ hama, kru Juda hatindu kuyu mɨŋasɨrɨvandu haŋɨnɨŋɨndu tamɨŋgañɨ taŋguramɨrɨmandɨ. Sɨwɨmaña ndaya kru mumɨŋga yahata kru mumɨŋgarɨm na kwɨnɨkwɨnɨ mɨŋga vɨrɨmandɨ hama ahutuvarandi helɨyɨ urɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Na Gotɨŋ kɨrañɨŋgurɨm, kɨrañɨŋguhu pinayɨrɨm uta, indarɨmitɨna nasi vaha mana nara naŋga vaha nandɨ pɨmɨ vana kɨtiŋgata, kɨrañɨŋguhu hɨm ha kɨrañɨŋguhu pina arɨhañɨ tama. Kamata aŋga pata pɨmɨ ha mɨŋasɨrɨvɨna avindɨti, uta Gotɨŋ kɨrañɨŋgu. ");
INSERT INTO kqa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sɨhwɨmaña nda, kru mumɨŋga naŋ ŋgatɨŋgɨrutɨŋgɨru hamandu kuma hɨmbañɨ tamɨrɨm tɨmbuta urɨmandɨ. Kamati kwɨmbɨyɨ uhuhu nu naŋga kuyu mɨŋasɨrɨva. Kamata mandɨmana ha, naŋ kru kandɨhama kru ŋgatɨŋgɨrutɨŋgɨru hamandu kuma hɨmbañɨ tamɨrɨmandɨ. Kamati naŋ kandɨhama ahutambundu kuma hɨmbañɨ tamɨrɨmandɨ. Kamati naŋ ahutambu kru ñamba vana andɨhu tamandu upɨyɨ tamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yi naŋ kandɨ ambin, kru ñamba vana andɨhu tamandu upɨ hañɨ kɨñɨŋgɨñɨ tɨmbahɨrɨs ambɨrɨmandɨyu mañamaña mut mamɨŋata, tapɨrañɨ mambindɨhɨrɨmana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas sɨhinda ambami, Narɨ ŋgandara. Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami, Kru navundi naŋga narɨ navundi mɨŋavɨŋgɨrɨvɨŋgɨrɨmara. Navundi kru naŋga narɨ kru mɨŋavɨŋgɨrɨvɨŋgɨrɨmara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hara yi narɨŋ nɨmavɨrɨman, kru mumɨŋga navundi muŋambɨŋ ŋgata nɨŋambirɨm ñamba hɨnzɨhi indarɨta mavɨndamandi hama, navundi mɨŋavɨŋgɨrɨvɨŋgɨrɨ vana andɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nandɨ tamɨŋga kuma kandɨ samba hambundu pɨŋgɨrɨvɨŋgɨrɨramɨti ñamba vana andɨtaŋgata, ivɨta kavara. Kamata tamɨŋgaŋgɨrɨsɨ tamu naŋgandaya kɨñɨ. Kamata ñamba vana maŋandɨrɨmana. Kamatɨna nandɨ kwɨrandɨmbat ha sɨhanaŋga Got ahutuvarandi helɨyɨ maŋgavarɨmandɨ. Ara tamɨŋgaŋgɨrɨsɨ timu maŋivɨta kavarata ñamba vana andɨrɨmana ha nandɨ kwɨrandɨmbat ha, sɨhanaŋga Got ahutuvarandi helɨyɨ kavarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sɨwɨmañanda, nandɨ kuma kandɨha pɨŋgɨrɨvɨŋgɨrɨramɨti ñamba vana andɨtaŋgata pɨtɨta kavara. Kamata kuma tamu naŋgandaya kɨñɨ. Kamata ñamba vana maŋandɨrɨmana. Kamatɨna nandɨ kwɨrandɨmbat ha sɨhanaŋga Got ahutuvarandi helɨyɨ maŋgavarɨmandɨ. Ara kuma timu mambɨtɨta kavarata ñamba vana andɨrɨmana ha, nandɨ kwɨrandɨmbat ha sɨhanaŋga Got ahutuvarandi helɨyɨ kavarɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas sɨhinda nɨmavami, Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami, Kru mumɨŋga nɨmburiŋ pɨŋguvarɨm aŋgwɨmɨkɨ yɨhimbɨvɨrata nɨmburiŋ ŋguta nuŋ pɨŋguvarɨmandɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hara yi narɨŋ ambin, kru mumɨŋga, nɨmburiŋ saŋɨnaŋga pɨŋguvarɨmandɨ. Kru mamɨŋavɨŋgɨrɨndi. Kamati uta kru mumɨŋgaŋ yawɨrɨmandɨ. Kandɨhamata vana andɨta, Gotɨndu tamɨŋgañɨ navundi kru mɨŋavɨŋgɨrɨvɨŋgɨrɨ ŋambɨ andɨndi maña andɨrɨmandɨ. Kamati kru uta yawɨrɨmandɨ hama ndahara Gotɨndu tamɨŋgañɨ, kru navundiŋ mɨŋavɨŋgɨrɨvɨŋgɨrɨ mɨŋga andɨndi maña andɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas sɨhinda ambami, Narɨ ŋgandara. Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami, Muhɨm vana andɨrɨm kuyusɨhɨrata narɨŋandɨ kuyu ha tɨkatɨkatɨramata kandɨsɨkwɨsɨkwɨ kuma yawi vata maŋambamara. Kandɨsɨkwɨsɨkwɨ kuma yawi vataŋgata, Aru nɨmandu tamɨŋgañɨ ambɨrɨmandɨra maña andɨmara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hara yi narɨŋ nɨmavɨrɨman, kuyu munda tɨkatɨkatɨramata kandɨsɨkwɨsɨkwɨ kuma yawi vata maŋambamara. Narɨŋandɨ kuyu tɨkatɨkatɨramata ihumbɨsa vata ndahara maŋambamara. Ihumbɨsa ha Gotɨndu mɨnzɨmɨnzɨ maka tɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Narɨŋandɨ kuyu tɨkatɨkatɨramata pɨrɨ vata ndahara maŋambamara. Pɨrɨ nɨŋandɨhin Gotɨndu tanda tamatama upɨ tɨhi. Narɨŋandɨ kuyu tɨkatɨkatɨramata Jerusalem vata maŋambamara. Jerusalem pɨhu aru Got aru miku tɨkatɨka naŋga nɨmandu tɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Narɨŋandɨ miku mɨnɨ ha narɨŋambi andɨtɨra kitɨrɨ yɨvurahata suñɨ yɨvurahata mandɨhi. Harɨm narɨŋandɨ kuyu tɨkatɨkatɨramata miku vata maŋambamara. ");
INSERT INTO kqa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Narɨ kandɨ naŋga manɨŋga ndaya vamara. Kuyu muvɨra narɨŋandɨ kuyu tɨkatɨkatɨramata ambɨrɨmandɨra haŋɨnɨŋ, kaŋɨnɨŋ Satanɨndu kuyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas sɨhinda ambami, Narɨ ŋgandara. Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami, Kru mumɨŋga, mumɨŋgandu tamɨŋga mɨŋasɨpɨrɨti ŋgata kɨmbɨ ndahara nuŋandɨ tamɨŋga handahara mɨŋasɨpɨram. Sɨwɨmañanzihɨ kru mumɨŋga, mumɨŋgandu mɨkahɨrɨs ha yɨvukuvɨti ŋgata, kɨmbɨ ndahara nuŋandɨ mɨkahɨrɨs ha yɨvukuvɨm, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hara yi narɨŋ nɨmavɨrɨman, kru naŋ ñamba vana andɨti ndahara, kɨmbɨ maŋandɨ. Kru mumɨŋga ñuŋgi nandɨ ha timu yɨvuvandɨti ŋgata kimɨruramɨna tamu ndahara yɨvum. ");
INSERT INTO kqa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sɨhwɨmaña nda kru mumɨŋga naŋ kru ŋgatɨŋgɨrutɨŋgɨru haŋɨnɨŋɨndu kumaŋgɨmbañɨ tamata nandɨ mɨkwɨrɨ ha mɨŋɨti ŋgata, nandɨ mɨkwɨrɨ kuta ha naŋga ŋgu. ");
INSERT INTO kqa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sɨhinda kru mumɨŋga yandɨ maku nɨ kavuta uta muhɨrɨvɨ ndaŋura tama vata tɨkatɨkati ŋgata, kavuta uta ambɨrɨmandɨ mɨkwɨ haŋu itɨvata sɨwɨmañaŋgɨrɨvɨ utara tama. ");
INSERT INTO kqa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kru mumɨŋga nambirɨm muhɨmɨrɨm kitɨhuta yaŋ ŋgu vɨtiŋgata sɨkwɨtaya ŋgu. Naŋga kru mumɨŋga nandɨ muhɨm nda mɨŋata muhɨvɨra kɨmbɨ ŋgutɨn vɨti ndahara mɨrɨmɨrɨ mandɨ. Kɨmbɨ muyɨvɨra ŋgu vata maŋamba. Sɨkwɨtaya ŋgu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas sɨhinda ambami, Narɨ ŋgandara. Got Mosesɨŋ ambahi, narɨŋandɨ nañɨŋgitakɨñaŋ ambami. Narɨ krunavundi narɨŋandɨ pɨhuyɨndu mɨŋata mavɨñɨ tamamara. Kamata narɨŋandɨ miku haŋɨnɨŋ tɨkitɨkitɨmara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hara yi narɨŋ nɨmavin, Kru miku tamandara haŋɨnɨŋ mɨŋata mavɨñɨ tamamara. Kamata Got naŋga kuyundavarɨtɨra, kru narɨŋ ñamba vana andɨndu haŋɨnɨŋ Got avindamam. ");
INSERT INTO kqa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kamatɨrɨmandɨra handa narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hamandu ñɨŋi kɨyɨmandɨra. Nu ina nuŋandɨ andɨhi kru ñamba ŋɨnɨŋ naŋga aviŋɨnɨŋɨrɨm naŋga yahandi. Naŋga andɨhi kuku kru tɨtɨtaya kɨyɨhɨyɨ, naŋga tɨtɨ maŋgɨyɨhɨyɨ ŋɨnɨŋɨrɨm naŋga mɨŋgandi. ");
INSERT INTO kqa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa haŋɨnɨŋ, kru nurɨŋ mɨŋata mavɨñɨ tamandu haŋɨnɨŋ ndaya mavɨñɨ tamandu. Harɨm narɨ, nurɨ andɨndu maña kru narɨŋ mɨŋata mavɨñɨ tamandu haŋɨnɨŋ ndaya mɨŋata mavɨñɨ tamɨrɨmandɨra ha, narɨŋ Got muhɨm maŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kru Gotɨŋ maŋgandu haŋɨnɨŋ nurɨŋandɨ nɨŋusi nɨŋuraŋ ndaya aviŋgɨvɨ ŋgundu. Harɨm narɨ, nurɨ andɨndu maña maŋandɨmara. Kru muŋɨnɨŋ ndahara aviŋgɨvɨ ŋgumara. Kamata nurɨŋ taratɨvɨrata avi vana sɨkwɨ andɨrɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Narɨŋandɨ Nava nuŋandɨ pɨhuyɨ avinzɨkwɨ kɨndi. Harɨm narɨndahara nu maña avinzɨkwɨ kɨyɨmara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas sɨhinda nɨmavami, Tamɨŋga naŋga kɨndamara. Narɨŋandɨ avi vana ha krunavundindu tamɨŋgaŋgɨmbañɨ andɨtɨra maŋgamu. Kandɨhamatɨrɨmandɨra ha narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hamandu muhɨmɨmuhɨm mamɨŋɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kru muvɨra krunavundiŋ kuyusɨhɨrɨtɨrɨŋ arɨŋandɨ ñɨmbi tɨhuyahɨrɨmandɨyu vata andɨndu. Kamata kru mumɨŋgaŋ sɨmbɨhu Got naŋga kuyundavaravara tavɨyɨ naŋga kɨndɨmbatɨyɨ kaur tɨmɨhɨruta kasiramata undi. Kamatɨhihi kru kuyusɨhɨrandu haŋɨnɨŋ sɨhɨndɨ undu. Kamata kru kandɨhaŋɨnɨŋ krunavundi muhɨmɨmuhɨm manɨman haŋɨnɨŋ tɨmbahɨrɨs ŋgundu. Harɨm nurɨ andɨndu maña narɨ maŋandɨmara. Narɨŋ yi kandɨ ambin, kru kandɨhaŋɨnɨŋɨndu ñɨmbi krunavundi tɨhuyahɨrɨmandɨyu. Hara Got mandɨhuyahɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Krunavundi muhɨmɨmuhɨm manɨman haŋɨnɨŋ tɨmbahɨrɨs ŋguta, kru muŋɨnɨŋ maŋamba. ");
INSERT INTO kqa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kamataharɨm sɨhisɨhi sɨmbɨra andɨrɨmandɨra haŋandɨhin sipɨruta kɨyɨmandɨ. Kamatɨra, Nava muhɨmɨmuhɨm sipɨrusipɨru hɨm ŋgandi hama, nu taya narɨŋ muhɨmɨmuhɨm ŋgurɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas sɨhinda ambami, Kru muvɨra krunavundiŋ kuyusɨhɨrɨtɨrɨŋ arɨŋandɨ ñɨmbi tɨhuyahɨrɨmandɨyu vata andɨndu. Kamata Got naŋga kuyundavaravara tavɨyɨ naŋga kɨndɨ hiŋgɨrɨñɨ taŋguramandu. Kamata krunavundi ŋgɨmandɨyu vata Got naŋga kuyundavarambara kuyu pɨŋgɨrɨvɨŋgɨrɨrɨm pirɨtamandu. Harɨm nurɨ andɨndu maña narɨ maŋandɨmara. Narɨŋ yi kandɨ ambin, kru kandɨhaŋɨnɨŋɨndu ñɨmbi krunavundi tɨhuyahɨrɨmandɨyu. Hara Got mandɨhuyahɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nandɨ Nava nu sipɨrusipɨru upɨyɨ kɨndi. Harɨm nu naŋga kuyundavarɨm nandɨ karɨhaharɨha upɨyɨ indɨhuta kɨndɨŋariha yɨhɨta nu naŋga kuyundavara. Kamatɨna ndahara nandɨ kuyu ha indarɨta naŋ muhɨmɨmuhɨm ŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Krunavundi muvundumuvundu ŋɨnɨŋ, Got arɨŋandɨ kuyu indarɨmandɨ vata Got naŋga kuyundavarata kuyu pɨŋgɨrɨndu. Harɨm narɨŋandɨ Nava Got naŋga kuyundavarɨm, krunavundi muvundumuvundu kuyundavarata kuyu pɨŋgɨrɨndu maña kuyu mambɨŋgɨrɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Narɨŋandɨ Nava Gotɨŋ muhɨmɨrɨm nda ambɨrɨm kwɨsɨ mɨkatɨkumbɨrahara ndahara ŋgandi. Kamataharɨm nurɨ andɨndu maña maŋandɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Indarɨmara, nɨmavamba kuyundavaramara, Arɨŋandɨ yavandak nandɨ pɨhuyɨ kɨna, nandɨ ñɨmbi avinzɨkwɨsɨkwɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Krunavundi tɨhu naŋga muyɨvɨndahara nandɨ tɨwɨyɨ kɨyɨmu. Nandɨ pɨhuyɨ kɨndu haŋɨnɨŋ na pirɨtamandana vana taya mɨŋahandandu. Krunavundi pɨrɨ nɨñɨ ndahara na pirɨtamandana vana taya mɨŋahandamu. ");
INSERT INTO kqa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kamata musi hɨvɨrɨm arɨŋ ñaña ŋgu. ");
INSERT INTO kqa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Arɨŋ kru muŋɨnɨŋ ñamba vana andɨhu nurɨŋ kuŋgɨ kuyɨvandarɨŋ maña, ara naŋ ñamba vana andɨndarɨŋ haŋandɨhinɨndu kuŋgɨ kuyɨva. ");
INSERT INTO kqa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na mitɨna arɨŋ Satan ñamba vana andɨtɨrɨm mɨŋamɨŋgɨtima. Ara ñamba vana andɨrɨmɨtɨrɨŋ arɨŋ ŋguramɨna ñamba vana maŋandɨm, vamba ambamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","15","Kamavata nurɨŋ ambami, Krunavundi muŋɨnɨŋ ñamba vana andɨtu nurɨŋ kuŋgɨ maŋguyɨvɨrɨmandɨra ha, narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hama ndahara narɨŋ kuŋgɨ maŋguyɨvɨrɨmandɨ. Hara krunavundiŋ kuŋgɨ kuyɨvɨrɨmandɨra ha, narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hama ndahara narɨŋ kuŋgɨ kuyɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas sɨhinda ambami, Kru muvɨra krunavundiŋ kuyusɨhɨrɨtɨrɨŋ arɨŋandɨ ñɨmbi tɨhuyahɨrɨmandɨyu vata andɨndu. Kamata krunavundirɨm nɨŋɨnɨŋ ñaña itɨhañata kɨndayu vɨrɨmandɨyu vata kru kandɨhaŋɨnɨŋ kɨpumɨka ñambayɨ tɨhɨrandu. Hara narɨ ñaña itɨhañata ŋgata kru nɨŋɨnɨŋ andɨndu maña kɨpumɨka ñambayɨ mandɨhɨramara. Narɨŋ yi kandɨ ambin, kru kandɨhaŋɨnɨŋɨndu ñɨmbi krunavundi tɨhuyahɨrɨmandɨyu. Hara Got mandɨhuyahɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hara narɨ ñaña itɨhañata ŋgata, narɨŋandɨ kɨpumɨka ha ñɨmburɨmara. Kamata kwɨrandɨyɨ taŋgusɨharahu kɨnza avi yɨvurahandi hɨm mikuvu taŋgusɨharata ñaña maŋitɨhañata kɨndɨmañandɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kandɨhamatɨra krunavundi narɨŋambirɨm nɨŋɨnɨŋ ñaña maŋitɨhañayu, vamba ambɨrɨmandɨyu. Hara ñaña itɨhañandara ha, narɨŋandɨ Nava ŋgandi. Nu mɨŋgɨyamɨŋgɨya muhɨmɨmuhɨm sipɨruta kɨyɨhɨyɨ hɨm ŋgandi. Kamatɨra Nava narɨŋ muhɨmɨmuhɨm kɨmbɨ ŋgurɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisas sɨhinda ambami, Narɨŋandɨ muhɨmɨmuhɨm avihɨmɨŋgɨm mɨŋamɨŋa pɨrɨ nɨñɨ mayɨvumɨŋgumara. Pɨrɨ nɨñɨ akavatɨvatɨ tavɨhandu. Kamatɨhi ñaŋgwɨ yɨvuta muhɨmɨmuhɨm ñambatɨndu. Kru kipa naŋga haŋɨnɨŋ ndahara tapa yɨvuvirɨhuta kipa mɨŋandu. ");
INSERT INTO kqa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hara narɨŋandɨ muhɨmɨmuhɨm avivi haŋɨnɨŋ Gotɨndu pɨhuyɨ yɨvumɨŋgumara. Gotɨndu pɨhuyɨ akavatɨvatɨ mandavɨhandi. Kamatɨhi ñaŋgwɨ mayɨvundi. Kru kipa naŋga haŋɨnɨŋ ndahara tapa yɨvuvirɨhuta kipa mamɨŋandu. ");
INSERT INTO kqa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Narɨŋandɨ muhɨmɨmuhɨm avivi kɨyɨmandɨ upɨ hañɨ, narɨŋandɨ indarɨmit handahara upɨ kandɨhañɨ ndaya kɨyɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jisas sɨhinda ambami, Tamɨŋga nɨŋandɨhin kwɨrandɨmbat nɨŋandɨhinɨndu sɨña, tamɨŋga nandɨ avindaya kɨyɨmandɨ ha nandɨ kwɨrandɨ hambu ndahara sɨhanaŋga sɨñanzaŋɨnzaŋ ndɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hara tamɨŋga nandɨ ha ñambatɨrɨmandɨ ha, nandɨ kwɨrandɨ ha sɨhanaŋga kɨvɨmɨŋgwɨtɨrɨmandɨ. Kamataharɨm sɨña nandɨ kwɨrandɨ humba hambu kɨyɨmandɨ ha kɨvɨmɨŋgwɨti, kɨvɨmɨŋgwɨ kandɨha arutɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas sɨhinda ambami, Sɨmbɨrakara mɨŋgɨya mɨŋgandaya, aru miku arɨkimbatɨndu tɨwɨyɨ maŋgɨyɨhi. Muhamaŋ mɨŋata mavɨñɨ tamata, muhamaŋ kutɨvu mandamahi. Naŋga arɨkimbatɨndu kuyu maŋindarɨhi. Kamataharɨm narɨ Gotɨndu tɨwɨyɨ, naŋga tɨmbahɨrɨsɨndu tɨwɨyɨ maŋgɨyɨhara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas sɨhinda nɨmavami, Kamataharɨm yi narɨŋ ambin, narɨŋandɨ kwɨrandɨ ha ñaña naŋga mɨkwɨrɨŋ taratɨvɨrandi. Harɨm indarɨhɨtɨhɨta mum ñata, mum kuvɨrɨmɨndaŋ. Kamata mɨkwɨrɨ paŋundu kwɨrandɨ yɨvupɨhavɨmɨndaŋ vamba maŋindarɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Narɨ kava nɨŋɨnɨŋ ŋgamara. Nurɨ ñaña maŋgurɨndu. Naŋga nurɨ ñaña kayɨvata tavɨyɨ mandamandu. Hara narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨndi hama ŋguhihi ñandu. Harɨm narɨ kavaŋɨ taratɨvɨrandara. ");
INSERT INTO kqa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kru kɨra hañɨndu muvat mɨŋga pɨrɨ nɨñɨ sɨhinda muhɨrɨvɨ sɨmbɨrɨ avinzɨrɨsɨrɨvɨ kɨyɨhɨyɨ vanarɨm indarɨmitandi. Hara nuŋandɨ indarɨmit kandɨha andɨti arumarɨ hɨrɨvɨ kɨyɨhi vaha. Manɨŋga nzɨkwɨsɨkwɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kamataharɨm mumɨrɨm mɨkwɨrɨrɨm indarɨhɨtɨhɨtɨndara. Sumɨ nɨŋɨnɨŋ ŋgamara, nurɨ sɨmbɨra tɨkatɨka mamɨŋandu. Naŋga nurɨ mɨkwɨrɨ manzɨvirɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hara yi narɨŋ ambin, kuha aru miku Solomon mɨkwɨrɨ avivi tamandi. Hara sumɨ nɨŋɨnɨŋ Solomonɨndu mɨkwɨrɨ avivi kandɨhaŋɨnɨŋ taratɨvɨrandu. ");
INSERT INTO kqa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Musi tɨpanzɨmasɨma nɨŋɨnɨŋ kuyu. Hara amu kru tavɨhavarata ahumira aruyɨ kavarɨmandɨyu. Tɨpa kanɨmata nɨŋɨnɨŋ Got nurɨŋ kanzɨ mɨŋayahuramandi. Kamataharɨm nɨmata nɨmbu ŋgamara. Got narɨŋ ndahara kanzɨ mɨŋayahuramɨrɨmandɨ. Narɨ kru indarɨmaŋgaramaŋgara vana sukɨsɨmbɨrɨ naŋga ŋɨnɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kamataharɨm indarɨhɨtɨhɨta nɨmavata maŋambamara. Mum ñata mum kuvɨrɨmɨndaŋ. Naŋga muhɨmɨyɨ kwɨrandɨ yɨvupɨhavɨmɨndaŋ vata maŋambamara. ");
INSERT INTO kqa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gotɨŋ maŋgandu haŋɨnɨŋ muhɨmɨmuhɨm kanɨŋɨnɨŋ sɨhanaŋga ŋgɨmɨndaŋ vata puhɨrandu. Hara narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hama, muhɨmɨmuhɨmɨrɨm kɨrɨvɨtɨndara haŋɨnɨŋ ŋgandi. ");
INSERT INTO kqa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hara kimaŋgima hɨm andɨrɨmandɨra ha nɨmata. Narɨ Gotɨndu tɨwɨyɨ taya kɨyɨhɨyɨrɨm indarɨmara. Kamata avi vana taya mɨŋahandamara. Kamatɨra narɨŋ muhɨmɨmuhɨm kandɨhaŋɨnɨŋ ndahara ŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kamataharɨm muhɨmɨmuhɨm vana amu yɨvurahɨrɨmandɨrɨm maŋindarɨmitamara. Pɨmɨ amundu haŋandɨhin amu hɨvɨndu. Pɨmɨ musindu haŋandɨhin musi hɨvɨndu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisas sɨhinda ambami, Narɨ kru muŋɨnɨŋɨndu vana ŋgata ŋgatɨŋgɨruta ndaŋɨnɨŋ ñamba ŋɨnɨŋ vata maŋambamara. Kamavɨtɨra narɨŋ Got sɨhwɨmaña musa andɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Narɨ kru muŋɨnɨŋ ŋgatɨŋgɨrundara maña, Got ndahara narɨŋ ŋgatɨŋgurɨmandɨ. Kamata nurɨŋ muhɨmɨmuhɨm musa andara maña, narɨŋ ndahara kɨmbɨ andɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mumɨndɨhi nasindu tamɨŋga hañɨ ayɨwɨrsɨ sukɨyɨpu ha ŋgata ambandana. Hara nandɨ tamɨŋga hañɨ ahusɨŋga aru haŋandɨhinɨrɨm maŋindarɨndana. ");
INSERT INTO kqa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nandɨ tamɨŋga hañɨ ahusɨŋga ha kɨtihɨti, mumɨrɨm yasi nandɨ tamɨŋga hañɨ ayɨwɨrsɨ ha tɨhuyɨkɨrɨtɨnɨ vamba ambɨrɨmana. ");
INSERT INTO kqa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na kuyusɨhɨrɨmbɨhapɨha mɨŋga. Atɨ ahusɨŋga nandɨ tamɨŋgañɨ ha wɨsa mɨŋata kavara. Kamata tɨhɨramaŋgarata sɨhinda nasindu tamɨŋga hañɨ ayɨwɨrɨsɨyɨpu kɨyɨmandɨ haŋandɨhin ŋgamaŋgarata tɨhuyɨkɨra. ");
INSERT INTO kqa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Muhɨmɨmuhɨm Gotɨrɨm yɨhɨramandu haŋɨnɨŋ mɨŋgata upɨriŋ maŋgumara. Narɨŋ aŋga kimɨruramata sɨtumandɨhi. Naŋga narɨŋandɨ mɨnza avivi haŋɨnɨŋ sambarɨm maŋgavaramara. Kamatɨranda tandayɨ taya taŋgumɨŋgutumandɨhi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisas sɨhinda ambami, Got naŋga kuyundavarata nuŋ kitɨwɨtɨra narɨŋ muhɨmɨmuhɨm ŋgurɨmandɨ. Kamata muhɨmɨmuhɨm puhɨravuhɨraramata ŋgɨmandɨra. Kamata tavɨ kɨndɨŋari yɨvuyɨvuramɨtɨra narɨŋambirɨm Got kɨndɨŋari pɨhɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Harɨm kru Gotɨŋ kitɨhundu haŋɨnɨŋ muhɨmɨmuhɨm mɨŋandu. Kamata muhɨmɨmuhɨmɨrɨm puhɨravuhɨraramandu haŋɨnɨŋ ŋgandu. Naŋga tavɨ kɨndɨŋari yɨvuyɨvuramandu haŋɨnɨŋɨrɨm Got kɨndɨŋariha pɨhɨrɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kɨra nɨñɨndu muvat mɨŋgandu ñɨŋi, nɨŋuvaŋ mavatɨmbarɨm kitɨwɨti nɨŋuva nuŋ tɨmba ŋguhi vaha. Manɨŋganzɨkwɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naŋga nuŋandɨ ñɨŋi nɨŋuvaŋ asarɨm kitɨwɨti tau ŋguhi vaha. Manɨŋganzɨkwɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɨŋuvanin narɨ ñamba vana sambɨ andara. Hara narɨŋandɨ ñɨŋisɨmɨŋ avihɨmɨŋgɨm ŋgurɨm mavɨndamandara. Kamataharɨm ŋgamara. Narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hama naŋga kuyundavarɨtɨra, muhɨmɨmuhɨm avihɨmɨŋgɨm ŋgurɨm kɨnzɨhɨnzɨtɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Muhɨmɨmuhɨm vana narɨŋ kru muŋɨnɨŋ andɨmu vata pɨrɨ tamɨrɨmandɨra ha, sɨhwɨmaña musa kru muŋɨnɨŋ ndahara andɨmara. Kanɨmata vana nɨŋandɨhin Gotɨndu tɨkatɨka kuyundu kuyu sapa. Naŋga kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋɨndu kuyuyɨndu kuyu sapa, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jisas sɨhinda ambami, Narɨ kwɨmbɨsiki suksɨmbɨrɨ hañɨ umara. Pɨhu yɨwarayɨwara hañɨ uhuhundu kwɨmbɨ ha aru. Naŋga pɨhu kandɨhañɨ uhuhu kwɨmbɨ ha patɨ. Harɨm krunavundi sambɨ kwɨmbɨ kandɨhañɨ undu. ");
INSERT INTO kqa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hara pɨhu sɨhaŋgɨyɨhɨyɨndu kwɨmbɨsiki haŋandɨhin sukɨsɨmbɨrɨ sɨkwɨ. Naŋga kwɨmbɨsiki kandɨhañɨ uhuhurɨm avɨrɨ tamahana. Kamataharɨm krunavundi mɨŋgɨyavatɨvat taya kwɨmbɨsiki kandɨha ŋgata kandɨhañɨ undu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas sɨhinda nɨmavami, Kru muvɨra kuyusɨhɨrata ara kru Gotɨndu kuyu mɨŋata ambavaravara ŋɨnɨŋ vamba ambɨrɨmandɨyu. Harɨm tamɨŋga naŋga kɨndamara. Nurɨ kuyusɨhɨranzɨra narɨŋ kuyu avivi ambavarɨmandɨyu. Hara narɨŋandɨ indarɨmit hambu mɨŋawɨnɨkwɨnɨtɨrɨm andɨrɨmandɨyu. Kandɨhamata haŋɨnɨŋ upɨri saŋara maña sipsip vɨsa tarɨŋguramata arɨñɨ uta sipsip mu mɨŋahandɨmɨndaŋ vata andɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nurɨ andɨrɨmandɨyu musa ha ŋgata ambɨrɨmandɨra. Nurɨ kuyusɨhɨrata ara kru Gotɨndu kuyu mɨŋata ambavaravara ŋɨnɨŋ vamba ambandu, vamba ambɨrɨmandɨra. Kru wain kɨrɨs mɨŋɨrɨm siki punzɨ naŋgañɨ uta mamɨŋandu, naŋga kru ahu fik kɨrɨs mɨŋɨrɨm tɨpa sɨhɨvɨ naŋgañɨ uta mamɨŋandu. ");
INSERT INTO kqa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kamata maña sɨhanaŋga ahu avivi haŋɨnɨŋ kandɨ avivi tamandu. Ahu ñamba haŋɨnɨŋ kandɨ ñamba tamandu. ");
INSERT INTO kqa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ahu avi haŋɨnɨŋ kandɨ ñamba mandamandu. Ahu ñamba haŋɨnɨŋ kandɨ avi mandamandu. ");
INSERT INTO kqa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sɨhanaŋga ahu kandɨ avi mandamandu haŋɨnɨŋ tahɨravarandu. Kamata ahumirayɨ kavarahu tumbɨrundu. ");
INSERT INTO kqa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kamataharɨm nurɨ andɨrɨmandɨyu vana hambu taya ŋgata ambɨrɨmandɨra. Nurɨ kuyusɨhɨrata ara kru Gotɨndu kuyu mɨŋata ambavaravara ŋɨnɨŋ vamba ambandu, vamba ambɨrɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Krunavundi sambɨ saŋɨnaŋga yaŋ ambandu, Aru mɨŋga, Aru mɨŋga, vamba ambandu. Hara krunavundi kandɨhaŋɨnɨŋ Gotɨndu tɨwɨyɨ maŋgɨyɨmandɨyu. Kru Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hamandu kuyu taya mɨŋahandɨrɨmandɨ hama, Yavandakɨndu tɨwɨyɨ kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Got kuyu mɨŋasɨrɨvɨrɨmandɨ hɨvɨ hañɨ, krunavundi sambɨ yambirɨm nɨmavamba ambɨrɨmandɨyu. Aru mɨŋga nandɨ ñɨmbiyɨ ara Gotɨndu kuyu mɨŋata ambavarandarɨŋ. Naŋga nandɨ ñɨmbiyɨ taya ara sundɨ ñamba pɨŋguvarata muhɨmɨmuhɨm nzihɨ sihɨrandarɨŋ, vamba ambɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kamavɨtu kandɨhɨvɨ hañɨ nurɨŋ yi kuyu kɨmbañɨ ambɨrɨman. Yi narɨŋ maŋgahandandin. Narɨ ñamba vana andɨndara. Harɨm yi kɨn nɨñɨ mikitamamara, vamba ambɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas sɨhinda ambami, Kru yandɨ kuyu indarɨta mɨŋahandandi hama, kru indarɨmit avi naŋga mɨŋga nuŋandɨ tavɨ tɨmba hɨmbañɨ tɨhundi maña mɨŋga. ");
INSERT INTO kqa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kumba kayɨvata mɨŋguta tɨmba parapara aru ha ŋgandi. Kamata tɨmba hɨmba hañɨ tavɨ tɨpɨ haŋɨnɨŋ tararamandi. Kamataharɨm, kuku mɨŋgata kukuwɨrɨ taŋgundi, naŋga wɨnɨ tɨkatɨka pandi. Kamata mɨŋañaŋgɨrahi ndahara tavɨ kandɨha mamɨŋgata yɨvundi. ");
INSERT INTO kqa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hara kru yandɨ kuyu indarɨta mamɨŋahandandi hama, kru indarɨmit avi manɨman mɨŋga nuŋandɨ tavɨ kasɨyɨ tɨhundi maña mɨŋga. ");
INSERT INTO kqa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kamatɨhi wɨnɨ pandi. Naŋga kuku mɨŋgandi. Kamata kukuwɨrɨ taŋguta tavɨ ha mɨŋañaŋgɨrahi sɨkwɨtaya mɨŋgata yɨvundi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas kandɨ kuyu nɨŋɨnɨŋ, tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ kuyu ŋgundu maña maŋgumi. Manɨŋga. Nurɨŋ kru ñɨmbi naŋga hama kuyu ŋgumañandɨmi. Kamatɨhi krunavundiŋ mavɨyahavarami. ");
INSERT INTO kqa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas apu ha mitata mɨŋguhi krunavundi sambɨ nu naŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kamatɨhi kru kandi lepra naŋga mɨŋga Jisas kɨyɨmiyɨ payɨmi. Kamata tanda mɨkwɨmɨkwɨnɨta ambami, Aru mɨŋga. Naŋ pirɨti nda yaŋ mɨŋavindamɨna Gotɨndu tamɨŋgaŋgɨmbañɨ ñaŋɨrandɨhin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kamavahi Jisas kumandamata kru kandɨhamaŋ ambami, Yi pirɨkɨnɨ. Harɨm na Gotɨndu tamɨŋgañɨ hɨmbañɨ ñaŋɨrandɨ, vami. Kamavahi sarɨrwayɨ ŋandi kandi lepra ha yɨwarahi kru hama ñaŋɨrandɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kamata Jisas nuŋ karikarita ambami, Uta kru mumɨŋgaŋ naŋ yɨvurahi vana nɨrɨm maŋambavarahanda. Uta kwɨrandɨmbɨsa nandɨ ha Gotɨŋ kɨrañɨŋguhu hamaŋ isɨhurama. Kamata Mosesɨndu tɨkatɨka kuyu mɨŋahandata, Gotɨŋ kɨrañɨŋguhu hɨm ŋgu. Kamatɨna Gotɨŋ kɨrañɨŋguhu hama kɨrañɨŋgum. Kamatɨna kru muŋɨnɨŋ ŋgata ambɨrɨmandɨyu, Kandi lepra ha yɨwari, vamba ambɨrɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas pɨhu aru Kaperneam indɨhuhi Romɨndu 100 saŋganzarandu arumiku muhama pata Jisasɨŋ ambasɨhisɨhita nɨmavami, ");
INSERT INTO kqa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aru mɨŋga, yandɨ sɨmbɨrakara hama kandikɨmuhi kuma tanda kɨmuramata uhi kañɨnda aru kavuta tavɨyɨ karɨhata kɨyɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kamavahi Jisas nuŋ ambami, Uta mɨŋavindamɨtɨn avindɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jisas kamavahi, saŋganzarandu arumiku hama ambami, Aru mɨŋga, yi avi mɨŋganzɨkwɨ ma, harɨm yandɨ tavɨyɨ maŋu. Hara, kuyu taya ambɨna sɨmbɨrakara yandɨ hama avindɨmɨ. ");
INSERT INTO kqa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yi kanɨmavin ha nɨmata, yindahara kru ñɨmbi naŋga haŋɨnɨŋ karatamahu nurɨŋandɨ tɨwɨyɨ kɨndin. Yandɨ saŋganzara haŋɨnɨŋ yandɨ tɨwɨyɨ kɨndu. Kamataharɨm muhamarɨm uhu vamba ambahin, undi. Pañɨ vamba ambahin, pandi. Ara yandɨ sɨmbɨrakaraŋ uta kaŋgɨm sɨmbɨra mɨŋa vamba ambahin, uta mɨŋandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kamavahi Jisas kuyu kandɨha indarɨhi mavɨmbɨndɨrami. Kamata kru nu naŋga kɨndamu haŋɨnɨŋɨrɨm ambami, Narɨŋ yi kandɨ ambin, Israel hatindu kru muvatɨŋ ŋgahin kru nɨmandu indarɨmaŋgaramaŋgara vana maña maŋgɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Narɨŋ yinda ambin, krunavundi sambɨ pɨrɨvɨsa ina yahayaha naŋga ina mɨŋgumɨŋguvu mitata pata, Gotɨndu tɨwɨyɨ kɨyɨmandɨyu. Kamata Abraham, Aisak, Jekop naŋga mɨnzɨta ñɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hara krunavundi kuha nuŋandɨ tɨwɨyɨ kɨyɨhɨyɨ hañɨrɨm kɨyɨmandɨyu vata yɨhɨramami haŋɨnɨŋ, Got kavarɨti tapɨra kɨvɨmɨŋgwɨ humba ndambu indɨhuta kɨyɨmandɨyu. Pɨhu kɨvɨmɨŋgwɨ kandɨhañɨ irɨharɨha mɨka satɨpɨrɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kamata Jisas saŋganzarandu arumiku hamaŋ ambami, Tɨhunda uhu. Unana indarɨmitana vana ha yɨvuraham, vami. Kamatɨhi kandɨhɨrɨvɨ hañɨndaya saŋganzarandu aru miku hamandu sɨmbɨrasara hama avindɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas Pitandu tavɨyɨ indɨhuta ŋgahi Pita nɨmburi nɨŋumɨndakɨ kandikɨmuhi nuŋandɨ kwɨrandɨ ha ahupɨmbɨ maña kɨyɨhi, karɨhata kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kamatɨhi, Jisas kandɨhaŋambɨndu kumañɨ mɨŋasarahi sɨkwɨtaya avindɨmi. Kamata yahata Jisasɨrɨm ñaña sɨwɨtamami. ");
INSERT INTO kqa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kamata ina mɨŋgurɨm andɨhitɨhi, krunavundi sambɨ sundɨ ñamba arɨŋgumu haŋɨnɨŋ tɨmbuhavuta Jisas kɨyɨmiyɨ payɨmu. Kamatɨhu, sundɨ ñamba haŋɨnɨŋ ambahi krunavundi kandɨhaŋɨnɨŋ tɨhɨmitata umu. Kamata krunavundi sambɨ kandi naŋga haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kanɨmata musa nɨŋandɨhinɨrɨm, kuha Got ambahi kru Gotɨndu kuyu mɨŋata ambavaravara Aisaia ambami, Muhɨmɨmuhɨm kandi arɨŋandɨnɨ, nuŋambi mɨŋata pɨŋguvarɨmandɨ, vami. Kamataharɨm Got ambami kuyu haŋandɨhin Jisas andɨhi kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas ŋgahi krunavundi sambɨ kɨyɨmi hañɨ tɨhɨruhu nuŋandɨ sɨmbɨrasaraŋ ambami, Narɨ naŋga indu timukari ndambu indɨwɨmɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kamavahi tɨkatɨka kuyundu mirɨmba naŋga muhama pata Jisasɨŋ nɨmavamba ambami, Ahusɨki, na mupɨhu mupɨhuyɨ unandahara, yi nanaŋga urɨmanɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kamavahi Jisas nuŋ ambami, Upɨri saŋarandu upɨ ha pɨrɨhumbañɨ kɨndi. Naŋga kava ndahara ñiŋgi naŋga ŋɨnɨŋ. Hara Krundu Ñɨŋi hamandu karɨhaharɨha upɨ maŋgɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kamavahi sɨmbɨrasara muhama Jisasɨŋ ambami, Aru mɨŋga. Mitɨna uta yavandakɨŋ tuŋgɨñɨ tamɨtɨn wɨsa, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kamavahi nuŋ Jisas ambami, Kru kɨmuhɨmu haŋɨnɨŋ nurɨŋambira tuŋgɨñɨ tamamu. Pata yi naŋga kɨnda, vami. ");
INSERT INTO kqa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kamata Jisas kupik hañɨ mɨnzɨhi, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ndahara mɨnzɨta, umu. ");
INSERT INTO kqa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Uta indu pɨrɨŋɨmbɨrɨŋ kɨyɨhuhu, wɨnɨ aru pata ihɨmbɨrahi kuku kupik hañɨ indɨhuramata mɨŋa siŋgɨrɨm andɨmi. Kamatɨhira Jisas akwarɨhata kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kamatɨhi Jisasɨŋ mɨŋahimɨruta ambamu, Aru mɨŋga, kwɨmɨtɨrɨŋɨmandɨhi arɨŋ ŋgurama, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kamavahu Jisas ambami, Narɨ kru indarɨmaŋgaramaŋgara vana sukɨsɨmbɨrɨ naŋga ŋɨnɨŋ. Mumɨrɨm pɨŋitura, vami. Kamavata yahata wɨnɨ ha ambahɨmuhi wɨnɨ ha siŋgundɨhi, kuku sakɨrɨ handara mitami. ");
INSERT INTO kqa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kamatɨhi indarɨhɨtɨhɨtɨta ambamu, Kru kanɨma pamata mɨŋga. Harɨm wɨnɨ nuŋandɨ kuyu indarɨhi, kuku aviñam kɨyɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas uta indu Galili timukari, pɨrɨvɨsa pɨhu Gadara hati nduvu yɨvurahami. Kamatɨhi kru arɨkimbat sundɨ ñamba sambɨ arɨŋgumu haŋɨnɨŋ, kru kɨmuhuhu tamandu upɨ vɨrañɨ kɨta pata nuŋ ŋgamu. Arɨkimbat kandɨhaŋɨnɨŋ krunavundiŋ yɨvuvarandu. Harɨm kwɨmbɨ kandɨhañɨ maŋgɨndandu. ");
INSERT INTO kqa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Arɨkimbat nɨmavamba avaŋgaramu, Na Gotɨndu Ñɨŋi, arɨŋ mumɨndɨrɨmana. Got arɨŋ pɨsiŋgarɨmandɨ hɨvɨ ha kwɨsɨ. Hara arɨŋ pɨsiŋgarɨm pana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sambanzivi sambɨ kutañɨmarɨ kɨñɨŋgɨñɨ, ñata kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Harɨm sundɨ ñamba haŋɨnɨŋ Jisasɨŋ añaŋgarata nɨmavamu, Arɨŋ pɨŋguvarata ŋgata, mitɨna uta sambanzivi ndaŋɨnɨŋɨndu kwɨrandɨ humbañɨ mɨŋguramɨm, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kamavahu Jisas ambami, Umara, vami. Kamavahi sundɨ ñamba haŋɨnɨŋ kru arɨkimbatɨŋ mitata uta sambanzivi haŋɨnɨŋɨndu kwɨrandɨñɨ indɨhuramamu. Kamatɨhu sambanzivi kandɨhaŋɨnɨŋ sɨhanaŋga tɨvaramata ñamba humba muyɨ mɨŋgumu. Mɨŋguta kuku ñata kɨmumbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kamatɨhu kru samba karatamandu haŋɨnɨŋ ŋgata tɨvaramamu. Kamata pɨhu aru hañɨ yɨvurahata, krunavundiŋ muhɨmɨmuhɨm yɨvurahamirɨm ambavaramu. Naŋga, kru arɨkimbat sundɨ ñamba arɨŋgumu haŋɨnɨŋ, Jisas sundɨ ñamba haŋɨnɨŋ pɨŋguvarahi ŋgamurɨm ndahara ambavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kamatɨhu sɨhanaŋga krunavundi pɨhu kandɨhañɨ ŋgati Jisas kɨyɨmiyɨ payɨmu. Pata Jisasɨŋ, añaŋgaraŋgara arɨŋandɨ pɨrɨvɨsa nɨŋandɨhin mitata uhu vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kamata Jisas kupik muhañɨ mɨnzɨta indu timukari aŋga indɨhuta, nuŋandɨ pɨhuyɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kamatɨhi kru mumɨŋga kuma tanda atɨnda kɨmumi mɨŋgaŋ, pinayɨ kavuta pata Jisas kɨyɨmi arɨhañɨ tamahu karɨhata kɨyɨmi. Kamatɨhu Jisas ŋgahi kru haŋɨnɨŋ nuŋɨrɨm indarɨmaŋgarahu ŋgata kandi naŋga hamaŋ ambami, Yandɨ ñɨŋi tɨkatɨkata kɨñɨ. Ñamba vanavana andɨndana haŋɨnɨŋ kuŋgɨ kuyɨvin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kamavahi kru tɨkatɨka kuyundu mirɨmba naŋga muvɨra yahata nurɨŋambi masamasa kuyundavarambara Jisasɨrɨm nɨmavamu, Kru nɨma Gotɨndu upɨ mɨŋata kuyu kanɨmata nɨ ambi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kamavahu Jisas nurɨŋandɨ indarɨmit hambu ŋgata nɨmavami, Mumɨndɨhi indarɨmit ñamba haŋɨnɨŋ narɨŋandɨ mavɨñɨ kɨyɨ. ");
INSERT INTO kqa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yi kru nɨmarɨm nandɨ ñamba vanavana haŋɨnɨŋ kuŋgɨ kuyɨvin vɨrɨm avɨrɨmandamahin. Naŋga yahamɨrata kɨndavara vɨrɨm ndahara avɨrɨmandamahin. ");
INSERT INTO kqa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nɨmata nɨmbu indarɨmara. Krundu Ñɨŋi hama pɨrɨ nɨñɨ nu ñɨmbi naŋga mɨŋga. Kamataharɨm ñamba vanavanandu kuŋgɨ kuyɨvahi, vami. Kamavata Jisas kru kuma tanda kɨmuhɨmu hamaŋ tɨhɨratuta ŋgata ambami, Yahamɨrata nandɨ pina ha mɨŋata nandɨ tavɨyɨ uhu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kamavahi kru hama yahamɨrata nuŋandɨ tavɨyɨ umi. ");
INSERT INTO kqa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kamatɨhi, kruŋ Got tɨkatɨka naŋga ñɨmbi ŋgumiha ŋgata pɨŋitumu. Kamata krunavundi Gotɨndu ñɨmbi tɨhuyahamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas uta kru mumɨŋgaŋ ŋgami. Nuŋandɨ ñɨmbi Matyu. Gavaman ndamarɨm tɨmbahɨrɨs mɨŋandu tavɨyɨ mɨnzɨta kɨyɨmi. Kamatɨhi Jisas nuŋ ambami, Na yi naŋga pañɨ, vami. Kamavahi Matyu yahamɨrata nu naŋga umi. ");
INSERT INTO kqa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kamata muhɨvɨyɨ, Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ, Matyundu tavɨyɨ kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa haŋɨnɨŋ naŋga, kru muvɨra ñamba vanavana andɨndu haŋɨnɨŋ naŋga kɨhɨrɨ mɨnzɨta ñamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kamatɨhu Farisi haŋɨnɨŋ ŋgata, Jisasɨndu sɨmbɨrasaraŋ kitɨhuta nɨmavamu, Mumɨndɨhi kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa ndaŋɨnɨŋ, naŋga kru muvɨra ñamba vanavana andɨndu ndaŋɨnɨŋ, sɨwɨmañamasa ndamata narɨŋandɨ ahusɨki ndama naŋga kɨhɨrɨ ñandu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kamavahu Jisas indarɨta ambami, Kru kandi manɨman haŋɨnɨŋ ukɨ kahahaha mɨŋga kɨndiyɨ maŋundu. Kru kandi naŋga haŋɨnɨŋ ndaya ukɨ kahahaha mɨŋga kɨndiyɨ undu. ");
INSERT INTO kqa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Got ambami, Narɨ yaŋ saŋɨnaŋga kɨrañɨŋgundararɨm pirɨmandamandin. Hara muŋɨnɨŋ sɨhiŋgamara vata pirɨtamamaŋgarandin, vamba ambami, vami. Kamavata Jisas sɨhinda ambami, Harɨm narɨ uta kuyu kanɨŋandɨhinɨrɨm indarɨmitata ŋgamara. Yi tɨtɨtaya kɨyɨhɨyɨ haŋɨnɨŋ uraramɨrɨm mambayɨmin. Yi ñamba vanavana andɨndu haŋɨnɨŋ uraramɨrɨm payɨmin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kandɨtɨwɨmi hañɨ Jonɨndu sɨmbɨrasara haŋɨnɨŋ pata Jisasɨŋ kitɨhuta nɨmavamu, Mumɨndɨhi ara naŋga Farisi ñaña itɨhañaharɨŋ nandɨ sɨmbɨrasara haŋɨnɨŋ ñaña maŋitɨhañandu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kamavahu Jisas ambami, Kru mumɨŋga navundi urɨrɨm andɨndi. Kamata nuŋandɨ kru mɨndu haŋɨnɨŋ naŋga kɨyɨhihi nuŋambirɨm indarɨhu mavɨndɨhi maŋirɨhandu. Kɨyɨhandata kru muŋɨnɨŋ kru kandɨhamaŋ tɨmbuta muvu undu. Kamatɨhu nuŋandɨ kru mɨndu haŋɨnɨŋ nɨŋambirɨm indarɨhu mavɨndɨhi ñaña itɨhañandu. ");
INSERT INTO kqa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sɨwɨmañanda, kru mumɨŋga mɨkwɨrɨ kɨhi sɨŋga mɨŋata, kwɨrandɨ yɨvupɨhavɨhavɨ atɨndu sɨhɨrasɨhɨra humbañɨ yɨvuvihɨta manzɨvirɨndi. Kandɨhamata musa andɨta, kwɨrandɨ yɨvupɨhavɨhavɨ atɨndu ha ñɨmburɨndi. Kamatɨhi mɨkwɨrɨ kɨhi sɨŋga kumba yɨvuvihɨta sɨvirɨndi haŋandɨhin uta sukɨyɨputɨndi. Kamata mɨkwɨrɨ kɨhi sɨŋga ha andɨhi kwɨrandɨ yɨvupɨhavɨhavɨ atɨndu ha sɨhɨrata kumba ha sɨhinda arutɨmaŋgarandi. ");
INSERT INTO kqa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kru mumɨŋga wain kɨhi ŋandi meme vɨsa atɨnduyɨ maŋgapirandi. Kamatɨhi meme vɨsa ha pirɨhuhi wain ha pɨrɨyɨ mɨŋgaramandi. Kamatɨhi meme vɨsa handahara ñambatɨndi. Kamataharɨm wain kɨhi, meme vɨsa kɨhiyɨ kapirandi. Kamatɨhi arɨkiŋgɨm avindaya kɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas Jonɨndu sɨmbɨrasara haŋɨnɨŋ ambavarahihi, aru miku mumɨŋga pata Jisasɨndu tandanzapayɨ tanda mɨkwɨmɨkwɨnɨta ambami, Yandɨ navundi ha tɨhura kwɨmi. Hara pata uta mɨŋasarɨna aŋga yahamɨram, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kamavahi Jisas yahamɨrata kru kandɨhama naŋga uhi, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ndahara nu naŋga kɨhɨrɨ umu. ");
INSERT INTO kqa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kamatɨhi navundi 12 simbi sɨkwɨ ñaŋgwɨ yɨvukuvɨta kɨndi ŋambɨ nuŋambi ambami, Nuŋandɨ mɨkwɨrɨ kuta nɨñɨ ñapɨruvu kumandamata tɨmbusarata ndahara avindɨrɨman, vami. Kamavata Jisasɨndu kutɨvu arɨhañɨ pata kumandamata nuŋandɨ mɨkwɨrɨ kuta hañɨ tɨmbusarami. ");
INSERT INTO kqa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kamatɨhi Jisas kimɨruramata ŋgata nɨmavami, Yandɨ ñɨŋi tɨkatɨkata kɨñɨ. Na yaŋɨrɨm indarɨmaŋgarana harɨm avindɨ, vami. Kamavahi navundi haŋambɨ kandɨhɨrɨvɨ hañɨ sɨkwɨtaya avindɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kamatɨhi Jisas uta aru miku hamandu tavɨyɨ yɨvurahata ŋgahi krunavundi kambirɨhata kɨyɨmu. Kru haŋɨnɨŋ pɨkɨ tɨmɨhuruhuhu, krunavundi pɨrɨndɨm aru tamata kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kamatɨhu Jisas nurɨŋ ambami, Mikitamata umara. Navundiyɨpu nɨ maŋgwɨmi. Saŋ karɨhata kɨyɨ, vami. Kamavahi nuŋ irɨmɨndihɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kamatɨhura nurɨŋ pɨŋguvarahi tapɨrañɨ pindɨhamu. Kamata Jisas indɨhuta navundi ñaŋɨra haŋambɨndu kuma hañɨ mɨŋahandahi yahamɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kandɨhamatɨmi hañɨndu vana ha pɨrɨvɨsa kandɨhañɨndu pɨhu muvumuvu panzaŋgarami. ");
INSERT INTO kqa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kamata Jisas kandɨ pɨhu ha mitata umi. Kamatɨhi tamɨŋga ñumi arɨkimbat Jisas uhihi sɨhɨndɨ uta nɨmavamu, Devit nɨŋuñɨŋgi, avinda vaha arɨŋ sɨhiŋgahana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kamavahu Jisas tavɨyɨ indɨhuhi, kru arɨkimbat tamɨŋga ñumi haŋɨnɨŋ Jisas kɨyɨmiyɨ payɨmu. Kamatɨhu nurɨŋ kitɨhuta nɨmavami, Yi andɨrɨman vana nɨŋandɨhinɨrɨm narɨ indarɨmaŋgarara vaha, vami. Kamavahi arɨkimbat ambamu, Kandɨ Aru mɨŋga, ara indarɨmaŋgararɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kamavahu Jisas nurɨŋandɨ tamɨŋga hañɨ mɨŋasarata ambami, Narɨ yambirɨm indarɨmaŋgarara, harɨm ambara maña narɨŋ yɨvuraham, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kamatɨhi arɨkimbatɨndu tamɨŋga ha taruvɨhɨrɨmi. Kamatɨhi Jisas arɨkimbatɨŋ tɨkatɨka kuyu ŋguta nɨmavami, Nɨmata musa andɨhin ŋgara nɨrɨm uta muŋɨnɨŋ maŋambavaramara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hara arɨkimbat uta krunavundi pɨrɨvɨsa kandɨhañɨ hatiŋ Jisas avi vana andɨmi haŋandɨhinɨrɨm ambavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kamata kru arɨkimbat uhuhu, krunavundi kru sundɨ ñamba arɨŋguhi mɨka pɨmɨtɨhi maŋguyundavarandi hamaŋ, Jisas kɨyɨmiyɨ tɨmbuta payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kamatɨhu Jisas sundɨ ñamba ha pɨŋguvarahi kuyundavarami. Kamatɨhi ŋgata krunavundi sɨhanaŋga indarɨhɨtɨhɨtɨta ambamu, Kuha Israel pɨrɨvɨsayɨ mayɨvurahandi vana yɨvurahi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kamavahura Farisi ambamu, Nuŋ sundɨ ñambandu aru miku hama tɨkatɨka ŋguhi sundɨ ñamba haŋɨnɨŋ pɨŋguvarandi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas pɨhu aruru naŋga pɨhu suksɨrambɨ sɨhanaŋgayɨ kɨndami. Kamata krunavundiŋ Got naŋga kuyundavaravara tavɨhumba nurɨŋandɨyɨ nurɨŋ ambaramami. Kamatɨndɨ kuyu avivi Gotɨndu tɨwɨyɨ kɨyɨhɨyɨrɨm ambavarami. Kamatɨndɨ kru muhɨmɨmuhɨm kandi naŋga haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kamata krunavundi sambɨ ŋgahi indarɨhu tɨmɨndɨmɨndɨhi ñamba sɨkwɨ kɨta sipsip kara manɨmanɨ haŋɨnɨŋ kɨndu maña kɨyɨmu. Kamatɨhu nuŋ mavɨnzaŋɨnzaŋɨnɨdɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kamatɨhi Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambami, Kɨvayɨ ñaña sambɨ mɨndɨtɨ. Hara krunavundi ñaña yɨvutɨhɨruramarama haŋɨnɨŋ maŋgɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kamataharɨm kɨva nɨŋuva hama naŋga kuyundavarata kitɨhumara. Kamatɨra sɨmbɨrasaraŋ sɨmbɨti uta nuŋandɨ ñaña haŋɨnɨŋ yɨvutɨhɨrumu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nuŋandɨ 12 sɨmbɨrasara haŋɨnɨŋ ambahi payɨhu ambami, Yi narɨŋ yɨhɨramamin. Harɨm uta sundɨ ñamba haŋɨnɨŋ pɨŋguvarata, krunavundi muhɨmɨmuhɨm kandi naŋga haŋɨnɨŋ mɨŋavindamamara. ");
INSERT INTO kqa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sɨmbɨrasara kandɨhaŋɨnɨŋɨndu ñɨmbi haŋɨnɨŋ nɨmata, kimaŋgima hama Saimon, mu ñɨmbi nuŋandɨ Pita, muhama nɨŋura Andru. Naŋga Jems Sebedi ñanɨŋ naŋga nɨŋura Jon. ");
INSERT INTO kqa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Muhama Filip, muhama Bartolomyu, muhama Tomas, muhama Matyu. Kandɨhama nu gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa mɨŋga. Muhama Jems, Alfius ñanɨŋ. Muhama Tadius. ");
INSERT INTO kqa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Muhama Saimon, Selot vat mɨŋga, imbɨ hama Judas Iskariot. Kandɨhama Jisasɨŋ kru ñamba ŋɨnɨŋɨndu kumañɨ tamɨrɨmandɨ. Kamati nuŋ ñamba taŋgurɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas kru 12 vat kandɨhaŋɨnɨŋ sɨmbɨta nɨmavami, Krunavundi muvundumuvundu kɨnduyɨ maŋumara. Samariandu pɨhu aruruyɨ ndahara maŋindɨhumara. ");
INSERT INTO kqa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Narɨ sipsip Israel hatindu atɨnda yɨwaramu haŋɨnɨŋ ndaya kɨnduyɨ umara. ");
INSERT INTO kqa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uta nɨmavamba ambavaramara, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha arɨñɨndɨ ha, vamba ambamara. ");
INSERT INTO kqa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uta kandi naŋga haŋɨnɨŋ mɨŋavindamata, kru kɨmumu haŋɨnɨŋ andɨtɨra aŋga yahamɨramu. Kamata kru kandi lepra naŋga haŋɨnɨŋ andɨtɨra ñaŋɨraŋgɨyɨmu. Kamata sundɨ ñamba haŋɨnɨŋ pɨŋguvaramara. Narɨŋ sɨmbɨra mɨŋamɨŋarɨm yɨhɨramin vana nɨŋandɨhin mut mɨŋata mamɨŋara. Narɨ saŋ mɨŋara. Harɨm narɨ uta krunavundiŋ ŋguramata, mut mɨŋamɨŋarɨm maŋambamara. ");
INSERT INTO kqa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Narɨŋandɨ paŋaŋgarayɨ gol, tɨmbahɨrɨs silva, naŋga kopa kɨmbarɨta maŋumara. ");
INSERT INTO kqa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Urɨm, narɨŋandɨ paŋa, kwɨrandɨ yɨvupɨhavɨhavɨ arɨkita, tandambɨsa, naŋga makɨrutɨm mamɨŋamara. Kru sɨmbɨra mɨŋandi hamaŋ nuŋandɨ ñaña ha ŋgundu. ");
INSERT INTO kqa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pɨhu aru muyɨ vaha, mana suksɨmbɨrɨ muyɨ vaha indɨhuta, pɨhu kandɨhañɨ kru avinzɨkwɨsɨkwɨ naŋga tɨtɨtaya kɨyɨhɨyɨ mɨŋgaŋ ŋgamara. Kamata kru kandɨhama naŋgandaya kɨta uta pɨhu kandɨha mitamara. ");
INSERT INTO kqa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tavɨ muyɨ indɨhutaŋgata, krunavundi tavɨ kandɨhañɨndu ŋɨnɨŋɨrɨm kuyu avivi ŋguta ambamara. Gotɨndu mavɨñam narɨ naŋga kɨyɨm, vamba ambamara. ");
INSERT INTO kqa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kamatɨra tavɨ kandɨhañɨndu krunavundi narɨŋɨrɨm kɨnzɨkɨtuŋgata, narɨŋandɨ kuyu avi ha andɨti mavɨñamɨñɨ kɨyɨmandɨyu. Ara narɨŋɨrɨm kɨnzɨhɨnzɨ mandɨtuŋgata, Gotɨŋ kitɨwɨtɨra mavɨñamɨñɨ kɨyɨhɨyɨ vana ha nurɨ naŋga maŋgɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kamata kru mumɨŋga narɨŋ tavɨ nuŋandɨyɨ tɨmbuta maŋutiŋgata, naŋga narɨŋandɨ kuyu maŋindarɨtiŋgata, tavɨ vaha, mana pɨhu aru kandɨha mitata urɨm narɨŋandɨ tanda hañɨ ayɨwɨrsɨ kɨyɨmandɨ ha yɨvuvaramara. Kamatɨra kru pɨhu aru kandɨhañɨ ŋgati ŋgata ambɨrɨmandɨyu, Ñamba vana andɨharɨŋ nɨmata vana nɨ andɨyu vamba ambɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yi narɨŋ kandɨ ambin, Got krunavundiŋ ŋgatɨŋgurɨman vata yɨhɨramami hɨvɨyɨ hañɨ, krunavundi pɨhu kandɨhañɨ hati pɨmɨ kavɨrɨmandɨyu. Kamatu Sodom naŋga Gomora hati pɨmɨ kavɨrɨmandɨyu ha taratɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas sɨhinda ambami, Ŋgara. Yi narɨŋ sipsip maña sɨmbɨhin upɨri saŋara ñiŋgiñɨ ura. Harɨm tau andɨndi maña andɨmara. Indarɨmaŋgaratara muhɨmɨmuhɨm vana ha andɨmara. Naŋga kava umari andɨndu maña andɨmara. Ñamba vanavana andɨtɨrɨm maŋindarɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kruŋ ŋgamaŋgaramara. Narɨŋ kru Juda hatindu kuyu mɨŋasɨrɨvandu haŋɨnɨŋɨndu kumañɨ tamɨmandɨyu. Kamata Got naŋga kuyundavaravara tavɨ nurɨŋandɨyɨ narɨŋ pɨŋgɨrawɨsɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Narɨ yandɨ sɨmbɨrasara ŋɨnɨŋ. Harɨm narɨŋ gavaman ndama naŋga aru miku haŋɨnɨŋ kɨyuyɨ tɨmbuta urɨmandɨyu. Kamatu yandɨ kuyu avivi kru aruru haŋɨnɨŋ naŋga krunavundi muvundumuvundu haŋɨnɨŋ ndahara ambavarɨtɨra indarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Narɨŋ kru ŋgatɨŋgɨrutɨŋgɨru hama kɨyɨyɨ tɨmbuta urɨmandɨyu. Kamatu arɨŋ ambɨtuŋgata mumvamba ambavarɨmɨndaŋ, vata maŋindarɨhɨtɨhɨtɨmara. Kandɨtɨwɨmi hañɨ narɨŋandɨ indarɨmit hambu, Got nuŋambi ambavarɨtiti ambavarɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kuyu ambavarɨmandɨra ha narɨŋambi maŋambavarɨmandɨra. Narɨŋandɨ Navandu Mavɨñɨŋi narɨŋ indarɨmit ŋguti ambavarɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kru nɨŋuraŋ vaha mana nɨŋusiŋ vaha ŋgatɨŋgɨruta ambɨti yɨvutatamɨrɨmandɨyu. Sɨwɨmañanzihɨ nda nɨŋuvanin yahata nurɨŋandɨ ñɨŋiŋ andɨrɨmandɨyu. Nurɨŋandɨ ñɨŋi haŋɨnɨŋ ndahara nɨŋum nɨŋuvaŋ miku tamata, kru muŋɨnɨŋ sɨmbɨtu nɨŋum nɨŋuvaŋ yɨvutatamɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Narɨ yandɨ ŋɨnɨŋ. Harɨm narɨŋambirɨm sɨhanaŋga krunavundi kɨtɨrɨ ñɨmandɨyu. Hara krunavundi tɨkatɨkata kɨtuhɨtu imbɨhɨvɨ ha yɨvurahɨti, Got nurɨŋ aŋga mɨŋɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Krunavundi pɨhu muyɨndu haŋɨnɨŋ narɨŋ ñamba vana andɨtuŋgata, tɨvaramata pɨhu muyɨ umara. Yi narɨŋ kandɨ ambin, sɨmbɨra narɨŋandɨ Israelɨndu pɨhu makamaka mamɨturamɨtɨratɨra, Krundu Ñɨŋi hama payɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ñɨŋi nuŋandɨ ahusɨkiŋ mandaratɨvɨrandi, naŋga sɨmbɨrakara hama nuŋandɨ aru miku hamaŋ taratɨvɨrata kɨmbañɨ maŋgɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ñɨŋi nuŋandɨ ahusɨki maña yɨvurahɨmandɨ hama, kamatanda kɨyɨm. Naŋga sɨmbɨrasara, nuŋandɨ aru miku hama maña kɨyɨmandɨ hama, kamatanda kɨyɨm. Tavɨ nɨŋuvarɨm Belsebul vamba ambandu. Harɨm ñɨŋisɨm tavɨ kandɨhañɨ kɨndu haŋɨnɨŋ ñɨmbi ñamba sɨkwɨ ŋgumandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas sɨhinda ambami, Narɨŋ kru kandɨhaŋɨnɨŋ ñamba vana andɨrɨmɨtu ndahara mambɨŋitumara. Muhɨmɨmuhɨm tarɨŋguramata kɨndi haŋɨnɨŋ mamañɨ yɨvurahɨmandɨ. Kamati kuyu tarɨŋguramata kɨndi haŋɨnɨŋ ndahara sɨhanaŋga kru indarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Narɨŋ kuyu kɨvɨyɨ ambavaradin haŋɨnɨŋ, inahɨmur ambavaramara. Ara kuyu sɨwɨña indarɨmandɨra haŋɨnɨŋ, uta tɨhɨrutɨhɨru upɨyɨ kuyu kɨmbañɨ ambavarɨtɨra krunavundi indarɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kru pɨrɨ nɨñɨndurɨm mambɨŋitumara. Narɨŋandɨ kwɨrandɨmbatɨ ha yɨvutatamɨrɨmandɨyu, hara narɨŋandɨ mavɨñɨŋi ha mayɨvutatamɨrɨmandɨyu. Gotɨrɨmɨndaya pɨŋitumara. Nu taya narɨŋandɨ kwɨrandɨ naŋga mavɨñɨŋi ha pɨsiŋgarata, ahutuvarandi helɨyɨ kavarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Narɨ ŋgandara, kava arɨkita sukɨsɨrambɨ kru tuki tamɨŋgañɨ mut mɨŋandu. Hara narɨŋandɨ Nava kava suksɨrambɨ kandɨhaŋɨnɨŋ karatamaŋgarandi. Harɨm, kava kandɨhañɨndu muvat pɨrɨyɨ mamɨŋgatayɨvum vɨtiŋgata, mamɨŋgata yɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Naŋga, Got narɨŋandɨ miku mɨnɨ nɨŋɨnɨŋ mɨnza mɨnɨmɨnɨ ŋgatɨŋgɨruta mɨtundi. ");
INSERT INTO kqa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Narɨ Gotɨndu tamɨŋgañɨ aruŋɨnɨŋ nzɨkwɨ kɨndara, kava sukɨsɨrambɨŋ taratɨvɨramaŋgarandara. Kamataharɨm mambɨŋitumara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas sɨhinda ambami, Kru mumɨŋga krunavundiŋ nɨmavamba ambɨrɨmandɨ. Yi Jisasɨndu ñiŋgiñɨndu mɨŋga vamba ambɨrɨmandɨ. Kru kandɨhamarɨm, yindahara Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hamarɨm, kru nɨma yandɨ vamba ambɨrɨman. ");
INSERT INTO kqa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ara kru mumɨŋga krunavundiŋ, nɨmavamba ambɨrɨmandɨ. Yi Jisasɨndu ñiŋgiñɨndu mɨŋga ma vamba ambɨrɨmandɨ. Kru kandɨhamarɨm, yindahara Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hamarɨm, kru nɨma yandɨma vamba ambɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas sɨhinda ambami, Narɨ yambirɨm nɨmata maŋindarɨmitamara. Nu pɨrɨ nɨñɨ saŋga kirahɨrɨm payɨmi vamba maŋindarɨmitamara. Yi saŋga kirahɨrɨm mambayɨmin. Yi tuki kuta mɨŋata payɨmin. ");
INSERT INTO kqa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yi saŋga pɨruramɨrɨm payɨmin. Kru ñɨŋi hama nɨŋuvarɨm miku tamɨrɨmandɨ, navundi ñɨŋi haŋambɨ nɨŋumɨrɨm miku tamɨrɨmandɨ, nɨmbas nɨpahiŋ miku tamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nuŋandɨ kru ñɨŋi, navundi ñɨŋi, nɨmburi, nɨmbas, nurɨŋambi masamasa miku tamɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kru nɨŋum navaŋ mavɨndamata, yaŋ mavɨmandamɨrɨmandɨ hamarɨm, yandɨyɨndu vata maŋambɨrɨman. Kru nuŋandɨ kru ñɨŋi naŋga navundi ñɨŋiŋ mavɨndamata, yaŋ mavɨmandamɨrɨmandɨ hamarɨm, yandɨyɨndu vata maŋambɨrɨman. ");
INSERT INTO kqa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Naŋga kru, nuŋandɨ ahuandɨ maña pɨmɨ kavuta yi naŋga maŋgɨndɨrɨmandɨ hamarɨm, yandɨyɨndu vata maŋambɨrɨman. ");
INSERT INTO kqa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kru yambira muhɨmɨmuhɨm vana andɨtɨn avindɨrɨmandɨ vamba ambɨrɨmandɨ hama, siŋgundɨrɨmandɨ. Ara yambirɨm indarɨta kwɨmɨrɨmandɨ hama, kɨmuta ndahara sɨhaŋgɨyɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas sɨhinda ambami, Kru narɨŋɨrɨm kɨnzɨhɨnzɨtɨrɨmandɨ hama, yaŋɨrɨm kɨnzɨhɨnzɨtɨrɨmandɨ. Ara kru yaŋɨrɨm kɨnzɨhɨnzɨtɨrɨmandɨ hama, Gotɨrɨm kɨnzɨhɨnzɨtɨrɨmandɨ. Got yaŋ sɨmbɨhi payɨmin. ");
INSERT INTO kqa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hara, kru mumɨŋga ambɨrɨmandɨ. Yi kru Gotɨndu kuyu mɨŋata ambavarandi mɨŋgaŋ ŋguramɨrɨman vamba ambɨrɨmandɨ. Kamavata kru kandɨhamaŋ nuŋandɨ tavɨyɨ tɨmbuta uta karatamɨrɨmandɨ. Kru kandɨhamatɨrɨmandɨ hama, kru Gotɨndu kuyu mɨŋata ambavarandu haŋɨnɨŋ mɨŋandu maña muhɨmɨmuhɨm avivi mɨŋɨmandɨ. Naŋga, kru mumɨŋga ambɨrɨmandɨ. Yi kru tɨtɨtaya kɨyɨhɨyɨ mɨŋgaŋ ŋguramɨrɨman vamba ambɨrɨmandɨ. Kamavata kru kandɨhamaŋ nuŋandɨ tavɨyɨ tɨmbuta uta karatamɨrɨmandɨ. Kru kandɨhamatɨrɨmandɨ hama, kru tɨtɨtaya kɨyɨhɨyɨ mɨŋga muhɨmɨmuhɨm avivi mɨŋandi maña, mɨŋɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kru mumɨŋga ambɨrɨmandɨ. Yi kukumɨni Jisasɨndu sɨmbɨrasara ñiŋgiñɨndu ñɨmbi manɨman muvatɨŋ ŋguramɨrɨman vamba ambɨrɨmandɨ. Kamavata nuŋ ŋguramɨrɨmandɨ. Harɨm yi narɨŋ kandɨ ambin, kru kandɨhamandu avihɨmɨŋgɨm ha manziŋgundɨrɨmandɨ, mɨŋɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas nuŋandɨ sɨmbɨrasara 12 vatɨŋ ambaramata mɨtuta, kandɨ pɨhu ha mitata pɨhu makamaka kandɨhaŋu kɨndaŋgɨnda krunavundiŋ ambaramarama, nurɨŋ Gotɨndu kuyu ambavarami. ");
INSERT INTO kqa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kamatɨhi Jon kru ñamba vana andɨhi tamandu upɨyɨ kɨta, Krais muhɨmɨmuhɨm sɨmbɨra mɨŋamindu kuyuhɨnzɨ indarɨmi. Kamata nuŋandɨ sɨmbɨrasaraŋ ambami, Uta Jisasɨŋ nɨmavamba kitɨhumara, ");
INSERT INTO kqa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jon ambi, Naŋɨnda vaha Got sɨmbɨhi pɨrɨ nɨñɨ payɨmana, mana mumɨŋgaŋ vaha tavɨrɨmɨndaŋ, vamba ambi, vamba ambamara, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kamavahu Jisas nurɨŋ kɨmbɨ nɨmavami, Uta Jonɨŋ muhɨmɨmuhɨm vana indarɨra, naŋga ŋgara nɨŋɨnɨŋ ambavaramara. ");
INSERT INTO kqa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Krunavundi tamɨŋga ñumi haŋɨnɨŋ tɨhɨrañayu. Tanda ñamba haŋɨnɨŋ kɨndavarayu. Kandi lepra naŋga haŋɨnɨŋ ñaŋɨra yɨvurahayu. Kɨnzɨhi ñamba haŋɨnɨŋ kuyu indarɨyu. Naŋga kru kɨmuhɨmu haŋɨnɨŋ aŋga yahamɨrayu. Kamatɨhuhu krunavundi muhɨmɨmuhɨm manɨman haŋɨnɨŋ ndahara kuyu avi indarɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Naŋga kru yaŋ ŋgɨtu nurɨŋandɨ indarɨmaŋgaramaŋgara vana ha mamɨŋgata yɨvɨrɨmandɨ haŋɨnɨŋ, kɨnzɨhɨnzɨtɨmu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kamavahi Jonɨndu sɨmbɨrasara haŋɨnɨŋ indarɨta umu. Uhuhu Jisas krunavundiŋ Jonɨrɨm ambami, Narɨ kru manɨman upɨvu undara ha, wɨnɨ pata kukimaka mɨŋa ñɨŋuñɨŋu ndɨhi ŋgɨrɨm maŋundara. ");
INSERT INTO kqa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Naŋga, nu kwɨrandɨ yɨvupɨhavɨhavɨ kuta avivi haŋɨnɨŋ tamata kɨyɨhi ŋgɨrɨm maŋundara. Kru kwɨrandɨ yɨvupɨhavɨhavɨ kuta avivi ŋɨnɨŋ tamata kɨndu haŋɨnɨŋ aru miku ndu tavɨyɨ kɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hara narɨ undara ha, muhɨmɨmuhɨm kandɨhaŋɨnɨŋ ŋgɨrɨm maŋundara. Kru Gotɨndu kuyu mɨŋata ambavaravara mumɨŋgaŋ ŋgɨrɨm undara. Narɨŋ yi kandɨ ambin, kru Gotɨndu kuyu mɨŋata ambavaravara kandɨhama, kru Gotɨndu kuyu mɨŋata ambavaravara sɨhanaŋgaŋ taratɨvɨramaŋgarahi. ");
INSERT INTO kqa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gotɨndu aŋgwɨmɨkɨyɨ Jonɨrɨm ambami, Got ñɨŋi nuŋandɨŋ ambi, Ŋgana. Yi kru mumɨŋgaŋ sɨmbɨtɨn kasiramata yandɨ kuyu nɨ mɨŋata ambavarata, nambirɨm kwɨmbɨ mɨŋasɨrɨvɨrɨmandɨ. Kamati na sɨhɨndɨ payɨmana, vamba ambi, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Narɨŋ yi kandɨ ambin, Jon kukuyɨ mɨŋaŋgɨruhɨru hama kru pɨrɨvɨsayɨ yɨvurahamu haŋɨnɨŋ taratɨvɨrandi. Hara kru ñɨmbi manɨmanɨ nzɨkwɨ Gotɨndu tɨwɨyɨ kɨyɨmandɨ hama, Jonɨŋ taratɨvɨrɨmaŋgarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon kukuyɨ mɨŋaŋgɨruhɨru hama Gotɨndu kuyu ambavarami hɨrɨvɨyɨ nda kɨta, patavata tɨhu ndahara, kru saŋgandu tɨkatɨka naŋga haŋɨnɨŋ, Gotɨndu tɨwɨyɨ kɨyɨmɨndaŋ vata tɨkatɨkatɨndu. Kamatɨndɨ muvitamuvita saŋga kurɨhandu. Kamata krunavundi Gotɨndu tɨwɨyɨ kɨndu haŋɨnɨŋ pɨmɨ aru ŋgundu. ");
INSERT INTO kqa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ, naŋga tɨkatɨka kuyundu aŋgwɨmɨkɨ nɨŋandɨhin, Gotɨndu kuyu ambavarahuhu Jon kuhɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Harɨm narɨ kuyu kanɨŋandɨhin indarɨmɨndaŋ vataŋgata indarɨmara. Gotɨndu aŋgwɨmɨkɨyɨ ambami, Elaija payɨmandɨ, vamba ambami. Kaŋandɨhin Jonɨrɨm ambami. ");
INSERT INTO kqa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kru kɨnzɨhi naŋga hama, kuyu nɨŋandɨhin mɨŋatamamaŋgarata indarɨm. ");
INSERT INTO kqa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Krunavundi tɨhundu nɨŋɨnɨŋɨndu vana haŋɨnɨŋɨrɨm ambavarɨrɨm, tɨhi kuyu pamatavu ambɨrɨman. Nurɨ ñɨŋi maña tɨhɨrutɨhɨru upɨyɨ mɨnzɨta kɨndu. Kamata ñɨŋi muvɨrarɨm nɨmavamba ambandu, ");
INSERT INTO kqa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ara pɨkɨ tɨmɨhɨruharɨŋ narɨ manduturamara. Mavɨmavɨ sɨhɨpuri yɨvurɨŋ, hara narɨŋ mavɨndɨhi maŋirɨhara, vamba ambandu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kamavata Jisas sɨhinda ambami, Jon pata kandɨŋgandɨ mañata wain maŋguvɨrandi, naŋga ambandu, Sundɨ ñamba nu naŋga kɨyɨ, vamba ambandu. ");
INSERT INTO kqa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hara Krundu Ñɨŋi hama pata, ñata kuvɨrandi. Kamatɨhi ambandu, Nɨŋgamara, kru nɨma ñaña sambɨ ñata wain sambɨ kuvɨrandi. Nu kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋandu, naŋga kru ñamba vanavana andɨndu muvɨrandu nɨmbɨha, vamba ambandu. Hara krunavundi Gotɨndu indarɨmit avi kanɨŋɨnɨŋ mɨŋahandata sɨmbɨra mɨŋandu. Kamatɨhu krunavundi muvɨra nurɨŋandɨ sɨmbɨravu taya ŋgandu. Kamatɨhu Gotɨndu indarɨmit avi ha mamañɨndɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pɨhu aruru muvɨrañɨ, Jisas muhɨmɨmuhɨm nzihɨ sambɨ sihɨrahira mavɨ maŋgimɨrumu. Kamatɨhu kandɨtɨwɨmi hañɨ krunavundi pɨhu aruru kandɨhaŋu hatiŋ Jisas ambahɨmumbɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kamata ambami, Pɨhu aruru Korasin naŋga Betsaida hati narɨ pɨmɨ aru kavɨrɨmandɨra. Kru mumɨŋga uta pɨhu Tair naŋga Saidon muhɨmɨmuhɨm nzihɨ yi sihɨrahin ŋgandara maña nu ndahara sihɨrahi. Kamati ŋgata, nurɨ atɨnda ñamba vanavana andɨndu haŋɨnɨŋɨrɨm indarɨramata mavɨŋgimɨruhu. Kamata mɨkwɨrɨ kavɨta ahuyɨpuyɨ mɨnzɨta kɨyɨhu. ");
INSERT INTO kqa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kamataharɨm yi narɨŋ ambin, Got krunavundiŋ ŋgatɨŋgurɨman vata yɨhɨramami hɨvɨyɨ hañɨ, narɨ pɨmɨ kavɨrɨmandɨra ha, Tair naŋga Saidon hati pɨmɨ kavɨrɨmandɨyu ha taratɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaperneam hati narɨ ambandara, Arɨŋ Got tɨhuyahɨti nuŋandɨ pɨhuyɨ yawɨmɨndaŋ, vamba ambandara, manɨŋganzɨkwɨ. Hara narɨ kɨmuhɨmu ŋɨnɨŋɨndu upɨyɨ mɨŋgurɨmandɨra. Yi narɨ naŋga kɨta muhɨmɨmuhɨm nzihɨ sihɨrahin ŋgandara maña kru mumɨŋga uta Sodom ndahara sihɨrɨti, Sodom kɨyɨhi wɨsa. ");
INSERT INTO kqa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kamataharɨm yi narɨŋ ambin, Got krunavundiŋ ŋgatɨŋgurɨman vata yɨhɨramami hɨvɨ hañɨ, narɨ pɨmɨ kavɨrɨmandɨra ha, Sodom hati pɨmɨ kavɨrɨmandɨyu ha taratɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kandɨhɨrɨvɨ haŋu Jisas nɨmavami, Yava. Na ihumbɨsa naŋga pɨrɨ nɨñɨndu Aru mɨŋga. Yi naŋ kuyu avi ŋgwin, na muhɨmɨmuhɨm kandɨhaŋɨnɨŋ indarɨmit avi naŋga mirɨmba naŋga haŋɨnɨŋɨrɨm sipɨruramamana. Kamata kru nurɨŋambi taŋguhu mɨŋguhi ñɨŋi maña kɨndu haŋɨnɨŋ isɨhuramamana. ");
INSERT INTO kqa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kandɨ yava, nambi pirɨtamata kandɨhamatɨmana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kamavata Jisas sɨhinda ambami, Muhɨmɨmuhɨm Yavandak yandɨ kumañɨ tamami. Kru mumɨŋga ndahara Ñɨŋi hamaŋ maŋgandi. Nɨŋuva nuŋambi ŋgandi. Naŋga, kru mumɨŋga Nɨŋuvaŋ maŋgandi. Ñɨŋi hama nuŋambi ŋgandi. Naŋga kru Nɨŋuvaŋ isɨhuramahi ŋgandu haŋɨnɨŋ ndaya Nɨŋuvaŋ ŋgandu. ");
INSERT INTO kqa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kru sɨmbɨra tɨkatɨka mɨŋata pɨmɨ aru kavundara narɨ, sɨhanaŋga yi kɨyɨman nɨñɨ pata avɨrɨkɨmumara. ");
INSERT INTO kqa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Narɨ yaŋ ŋgandara. Yi yambi taŋguhin mɨŋguhi, mavɨñamɨñɨ kɨndin. Kamataharɨm pata avɨrɨkɨmumara. Narɨ yandɨ vana ŋgata, yandɨ kuyundu tɨwɨyɨ kɨyɨmara. Ahuhɨrɨvɨ bulmakau arɨkitandu pɨŋgwɨyɨ pɨŋgɨrɨmandɨyu vata tamandu maña yandɨ tɨwɨyɨ kɨyɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ahuhɨrɨvɨ narɨŋandɨ pɨŋgwɨyɨ tamin haŋandɨhin, kavuhavurɨm avɨrɨ mandamɨrɨmandɨra. Naŋga narɨŋ kavuhavu hɨm ŋgundin ha pɨmɨ ma, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kamata Avɨrɨkɨmuhɨmu Hɨvɨ muyɨ, Jisas wit kɨva itɨñɨitɨñɨ umi. Kamata nuŋandɨ sɨmbɨrasara haŋɨnɨŋ avɨhatɨhi, wit kɨrɨs haŋɨnɨŋ mɨŋamɨŋa ñamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kamatɨhu Farisi haŋɨnɨŋ ŋgata Jisasɨŋ nɨmavamu, Nɨŋga, nɨmata vana nandɨ sɨmbɨrasara nɨŋɨnɨŋ andɨyu nɨŋandɨhin, Avɨrɨkɨmuhɨmu Hɨvɨyɨ andɨhu avimandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kamavahu Jisas nurɨŋ kɨmbɨ nɨmavami, Kuha Devit nuŋandɨ hati naŋga avɨharɨm ŋgɨta andɨmi vana ha narɨ ŋgatɨŋgɨruta mambaha ŋgandara. ");
INSERT INTO kqa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit Gotɨndu tavɨyɨ indɨhuta, mavatɨmba amutɨ ndu tak Gotɨndu tamɨŋgaŋgɨmbañɨ kɨyɨhi, Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋ tamahu mambɨrañɨ kɨndi. Kandɨhaŋandɨhin mɨŋata nuŋandɨ hati naŋga ñamu. Mavatɨmba kandɨha kru saŋɨŋɨnɨŋ mañarasɨmu, Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋ ndaya ñarasɨmu. Hara Devit naŋga nuŋandɨ hati ñamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naŋga, tɨkatɨka kuyundu aŋgwɨmɨkɨyɨ kɨndi haŋandɨhin ŋgatɨŋgɨruta mambaha ŋgandara. Avɨrɨkɨmuhɨmu Hɨvɨyɨ ndahara Gotɨŋ kɨrañɨŋguhu tavɨyɨ Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋ sɨmbɨra mɨŋandu. Hara nurɨŋ kuŋgɨ maŋgahandi. ");
INSERT INTO kqa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Harɨm narɨŋ yi ambin, kru nɨñɨ kɨyɨ mɨŋga Gotɨŋ kɨrañɨŋguhu tavɨ ha taratɨvɨri. ");
INSERT INTO kqa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Got ambami, narɨ yaŋ saŋɨnaŋga kɨrañɨŋgundararɨm pirɨmandamandin. Hara muŋɨnɨŋ sɨhiŋgamara vata pirɨtamamaŋgarandin, vamba ambami. Harɨm kuyu kanɨŋandɨhindu kuyu sapa ha ŋgamaŋgarandarandɨti, kru pɨmɨ manɨmanɨ nɨŋɨnɨŋɨrɨm pɨmɨ maŋguhara. ");
INSERT INTO kqa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Harɨm Krundu Ñɨŋi hama nuŋambi Avɨrɨkɨmuhɨmu Hɨvɨ karatamandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas kandɨ upɨ haŋu mitata uta pɨhu muyɨ yɨvurahami. Kamata Got naŋga kuyundavaravara tavɨ nurɨŋandɨyɨ indɨhumi. ");
INSERT INTO kqa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kandɨhañɨ kru mumɨŋga kɨyɨmi, kru kandɨhama kumamaka timu kɨmuhɨmu mɨŋga. Kru muvɨra kuyusɨhɨrata Jisasɨŋ nuŋandɨ miku ŋɨnɨŋ ndu kumaŋgɨmbañɨ tamɨmɨndaŋ vata kitɨhuta ambamu, Kru kandi naŋga haŋɨnɨŋ Avɨrɨkɨmuhɨmu Hɨvɨyɨ mɨŋavindamaharɨŋ vaha, mana mambaha mɨŋavindamaharɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kamavahu Jisas nurɨŋ ambami, Narɨŋandɨ kru mumɨŋga nuŋandɨ sipsip mɨnzamɨnza ŋandi Avɨrɨkɨmuhɨmu Hɨvɨyɨ kumbañɨ mɨŋguti pɨŋgɨrɨti, yahahi. ");
INSERT INTO kqa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hara kru sipsip maña hɨm ma, sipsipɨŋ kru taratɨvɨramaŋgarandi. Harɨm Avɨrɨkɨmuhɨmu Hɨvɨyɨ kru kandi naŋga haŋɨnɨŋ mɨŋavindamaharɨŋ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kamavata kru kuma kɨmuhɨmu hamaŋ ambami, Kuma nandɨ ha tɨtɨ tama, vahi, kuma nuŋandɨha tɨtɨ tamahi avindɨta kuma tamu maña kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kandɨhamatɨhi ŋgata, Farisi haŋɨnɨŋ Got naŋga kuyundavaravara tavɨ ha mitata uta tɨhɨrumu. Kamata kuyundavarata Jisasɨŋ yɨvutatamɨtɨrɨŋ kwɨmɨrɨmandɨ vata kɨndɨmbuhɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Farisi haŋɨnɨŋ Jisasɨrɨm mɨndahɨrahu ŋgami. Harɨm kandɨ pɨhu ha mitata umi. Uhihi krunavundi sambɨ kandi naŋga haŋɨnɨŋ sɨhɨndɨ umu. Kamatɨhu krunavundi kandi naŋga haŋɨnɨŋ sɨhanaŋga mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kamata Jisas krunavundiŋ karikarita ambami, Uta yambirɨm kru muŋɨnɨŋ maŋambavaramara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas kandɨhamata vana andɨhi, Got ambahi kru Gotɨndu kuyu mɨŋata ambavaravara Aisaia ambami kuyu haŋandɨhin kandɨsɨkwɨsɨkwɨ yɨvurahami. Aisaia ambami, Got ambi, ");
INSERT INTO kqa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nɨŋandɨhin yandɨ sɨmbɨrakara mɨŋga. Yi nuŋ yambi yɨhɨramamin. Yi nuŋ mavɨndamamaŋgarandin, naŋga yandɨ mavɨnɨmbu nuŋambirɨm kɨnzɨhɨnzɨtɨmaŋgari. Yandɨ Mavɨñɨŋi nu naŋga tamɨman. Kamatɨn tɨtɨ vanarɨmɨndaya krunavundi pɨrɨvɨsa muvundumuvundu haŋɨnɨŋ ambavarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nu krunavundiŋ ukari saŋganzaŋgandɨndɨ mambɨhuravɨrɨmandɨ. Naŋga kɨndɨmakamakayɨ taŋguramata ambavarɨtiti krunavundi maŋindarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kuki tɨkatɨkama haŋandɨhin nu mamɨŋarɨvɨrɨmandɨ. Naŋga umbi mandumaŋgarɨmandɨ ha mamɨŋawɨmɨrɨmandɨ. Nu sɨmbɨra mɨŋata andɨti tɨtɨtaya kɨyɨhɨyɨ vana ha ñamba vanavana haŋɨnɨŋ taratɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kamati krunavundi pɨrɨvɨsa muvundumuvundu haŋɨnɨŋ, nuŋɨrɨm indarɨmaŋgarata arɨŋ ŋguramɨrɨmandɨ vata tavɨrɨmandɨyu, vamba ambi, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kandɨhɨrɨvɨ hañɨ kru sundɨ ñamba arɨŋgumi mɨŋgaŋ Jisas kɨyɨmiyɨ mɨŋata payɨmu. Kru kandɨhama tamɨŋga ñumi naŋga kuyu maŋguyundavarandi mɨŋga. Kamatɨhu Jisas nuŋ mɨŋavindamahi, kandɨhama kuyundavarata tɨhɨrañami. ");
INSERT INTO kqa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kamatɨhi krunavundi sɨhanaŋga pɨndɨrata yahata ambamu, Kru nɨma Devit nɨŋuñɨŋgi vaha, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hara, Farisi haŋɨnɨŋ kuyu kandɨha indarɨta yahata ambamu, Kru nɨma, sundɨ ñambandu aru miku Belsebulɨndu tɨkatɨkayɨ sundɨ ñamba pɨŋguvarandi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hara Jisas nurɨŋandɨ indarɨmit hambu ŋgami. Harɨm nurɨŋ nɨmavami, Pɨrɨvɨsa mɨnzayɨndu ŋɨnɨŋ sɨhɨrata arɨkinzapa kɨta kurɨhata, krunavundi kandɨhaŋɨnɨŋ ñambatɨhu. Pɨhu aru muyɨ hati vaha mana tavɨ mɨnzayɨndu ŋɨnɨŋ tamarahata arɨkinzapa kɨta kurɨhata, krunavundi kandɨhaŋɨnɨŋ tɨkatɨka mandɨhu. ");
INSERT INTO kqa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kamata maña, Satan yahata Satanɨŋ pɨŋguvarɨti tamarahata arɨkinzapa kɨta kurɨhɨtu, Satanɨndu tɨkatɨkata nurɨŋ karatamatamandu maŋgɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Harɨm yaŋ Belsebul ŋguramahi sundɨ ñamba haŋɨnɨŋ pɨŋguvarandintiŋgata, narɨŋandɨ hatiŋ ninɨndaya ŋguramahi sundɨ ñamba haŋɨnɨŋ pɨŋguvarandu. Harɨm narɨ ambara kuyu haŋɨnɨrɨm narɨŋandɨ hati narɨŋ ŋgatɨŋgurɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hara, yaŋ Gotɨndu Mavɨñɨŋi ŋguramahi sundɨ ñamba haŋɨnɨŋ pɨŋguvarandintiŋgata, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha pata ara naŋga kɨyɨha, vamba indarɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kru mumɨŋga kru tɨkatɨka mɨŋgandu tavɨyɨ pamata indɨhuta nuŋandɨ muhɨmɨmuhɨm mɨŋahi. Kamatɨrɨm kru tɨkatɨka hamaŋ siki naŋga sɨmahahi wɨsa. Kamatanda kru kandɨhamandu tavɨyɨ muhɨmɨmuhɨm mɨŋahi. ");
INSERT INTO kqa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kru yaŋ mɨndu mandamandi hama, yaŋ miku tamandi. Ara kru yaŋ ŋguramata krunavundiŋ mayɨvutɨhɨruramandi hama, pɨŋguvarahi siŋunziŋgu undu. ");
INSERT INTO kqa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kamataharɨm narɨŋ yi ambin, krunavundi muhɨmɨmuhɨm ñamba vanavana andɨrɨmandɨyu, naŋga Gotɨŋ ambasuvɨrɨmandɨyu haŋɨnɨŋ, Got kuŋgɨ kuyɨvɨrɨmandɨ. Hara kru Gotɨndu Mavɨñɨŋiŋ ambasuvɨrɨmandɨ hamandu kuŋgɨ, Got maŋguyɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kru mumɨŋga Krundu Ñɨŋiŋ kuyu ñamba ambɨrɨmandɨ. Hara ñamba vana kandɨhaŋɨnɨŋ Got kuŋgɨ kuyɨvɨrɨmandɨ. Hara kru Gotɨndu Mavɨñɨŋiŋ kuyu ñamba ambɨrɨmandɨ hamandu ñamba vana haŋandɨhin, tɨhu naŋga mutɨhu ndahara Got kuŋgɨ maŋguyɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kamata Jisas ambami, Ahu avi haŋandɨhin nuŋandɨ kandɨ handahara avindɨrɨmandɨ. Ara ahu ñamba ha kandɨ nuŋandɨ handahara avi mandɨrɨmandɨ. Kamataharɨm kru ndahara ñaña kandɨhambu ŋgaŋgaramata ambandu, Ahu nda avi, nda ñamba, vamba ambandu. ");
INSERT INTO kqa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Narɨ kru ñamba, tau ñamba ŋɨnɨŋ maña. Pamata kuyu avi ambavarɨmandɨra. Kru nuŋandɨ mavɨŋgukuyɨ muhɨmɨmuhɨm indarɨmit kɨndi haŋɨnɨŋ ambavarandi. ");
INSERT INTO kqa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kru avi hamandu indarɨmit avivi sambɨ nuŋandɨ mavɨ humbavu kɨndi. Harɨm avi vana taya andɨndi. Ara kru ñamba hamandu indarɨmit ñamba sambɨ nuŋandɨ mavɨ humbavu kɨndi. Harɨm ñamba vana taya andɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hara yi narɨŋ ambin, Got krunavundiŋ ŋgatɨŋgurɨmandɨ hɨvɨ hañɨ, krunavundi muhɨmɨmuhɨm kuyuhuyu kuyundavarandu haŋɨnɨŋɨrɨm indarɨramarama ŋgatɨŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Harɨm nandɨ kuyuvu taya ŋgaŋgaramata Got ambɨrɨmandɨ, Kru na ñamba mɨŋga, na avi mɨŋga vamba ambɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kru tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga Farisi muvɨra Jisasɨŋ nɨmavamu, Ahusɨki, muhɨm nzihɨ sihɨrɨnana ŋgɨm vata pirɨ kɨrɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kamavahu Jisas nurɨŋ kɨmbɨ ambami, Nɨmati hɨrɨvɨyɨndu krunavundi ñamba ŋɨnɨŋ. Harɨm Gotɨŋ ndaya mavɨñɨ mandamandu. Imutamut muhɨmɨmuhɨm nzihɨ ŋgɨmɨndaŋ vata añaŋgarandu hara maŋgɨmandɨyu, manɨŋga. Muhɨm nzihɨ sihɨrahi ŋgɨmaña ha, kru Gotɨndu kuyu mɨŋata ambavaravara Jona sihɨrami handaya ŋgɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona asa arundu mavɨŋgumbañɨ arɨkikwɨrɨ hɨvɨ kɨyɨmi. Sɨwɨmañanda Krundu Ñɨŋi hama ndahara arɨkikwɨrɨ hɨvɨ sava humbañɨ kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Krunavundiŋ Got ŋgatɨŋgurɨman vata yɨhɨramami hɨvɨyɨ, Ninive hati krunavundi sɨhanaŋga Gotɨndu tamɨŋgañɨ ñamba vana andɨndurɨm taŋguramɨrɨmandɨyu. Kamata narɨŋandɨ tɨwɨmiyɨ krunavundi ñamba vanavana andɨndurɨm kuyu kɨmbañɨ ambavarɨmandɨyu. Ninive hati Jona ambavarahi ŋgaŋga mavɨŋgimɨrumu. Hara kru mumɨŋga narɨ ñiŋgiñɨ kɨyɨ mɨŋga, Jonaŋ taratɨvɨri. ");
INSERT INTO kqa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Krunavundiŋ Got ŋgatɨŋgurɨmandɨ tɨwɨmiyɨ, Navundi aru miku Sebandu haŋambɨ ndahara Gotɨndu tamɨŋgañɨ taŋguramɨrɨmandɨ. Kamata krunavundi tɨhundu nɨŋɨnɨŋɨndu ñamba vanavanarɨm kuyu kɨmbañɨ ambavarɨmandɨ. Navundi aru miku kandɨhaŋambɨ, pɨrɨvɨsa nɨñɨndu mandambuyɨ kɨndi. Hara Solomon indarɨmit avivi nuŋandɨ ambavarɨti indarɨtɨn vata payɨmi. Hara kru mumɨŋga nɨñɨ kɨyɨ mɨŋga Solomonɨŋ taratɨvɨramaŋgari, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas sɨhinda ambami, Sundɨ ñamba kru mumɨŋgaŋ mitata urɨmandɨ. Kamata kuku manɨman upɨvu avɨrɨkɨmuhɨmu upɨ puhɨrata kɨndɨrɨmandɨ. Hara avɨrɨkɨmuhɨmu upɨ maŋgɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kamata ambɨrɨmandɨ, Yi tavɨ kɨyɨmin hañɨ aŋga uta kɨyɨman, vamba ambɨrɨmandɨ. Kamavata uta kɨyɨmi tavɨ ha ŋgɨti ikɨrañata kanzɨ mɨŋayahuramɨntu saŋgɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kamati uta sundɨ ñamba kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata vat ñamba vanandu supɨrisupɨri haŋɨnɨŋ tɨmbuta pata indɨhuta tavɨ kandɨhañɨ kɨyɨmandɨyu. Kru kandɨhama kuha ñamba kɨyɨmi, hara tɨhu ñambatɨmaŋgarɨmandɨ. Krunavundi tɨhundu nɨŋɨnɨŋ sɨwɨmañanzihɨ yɨvurahɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas krunavundiŋ kuyu ŋguhihi nɨŋum naŋga nɨŋuratakɨña pata Jisas naŋga kuyundavarɨmɨndaŋ vata tapɨrañɨ kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kuyundavarahihi, kru mumɨŋga pata ambami, Namaka naŋga naratakɨña nanaŋga kuyundavarɨmɨndaŋ vata pata tapɨravu nda kuyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kamavahi Jisas nuŋ ambami, Yamaka naŋga yaratakɨña kandɨhaŋɨnɨŋ ninɨnin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kamavata nuŋandɨ sɨmbɨrasaraŋ isɨhuramata ambami, Ŋgamara, nɨŋɨnɨŋ ndɨhi yandɨ yamaka naŋga yaratakɨña. ");
INSERT INTO kqa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Krunavundi Yavandak nuŋandɨ pɨhuyɨ kɨndi hamandu vana taya mɨŋahandahandarɨm pirɨkɨndu haŋɨnɨŋ ndaya, yandɨ yamaka, yarɨmandakɨña naŋga yaratakɨña, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kandɨhɨvɨ hañɨndaya Jisas tavɨhumba hambu mitata tapɨrañɨ pindɨhata uta indu aru hañɨndu tɨvɨyɨ mɨnzɨta kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kamatɨhi krunavundi sambɨ nu kɨyɨmi hañɨ payɨhu, kupik hañɨ yahuta mɨnzɨmi. Kamatɨhi krunavundi sɨhanaŋga indu tɨvɨ hambu taŋguvatamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kamatɨhu Jisas nurɨŋ tɨhi kuyu sambɨ ambavarata, nɨmavami, Indarɨmara. Kru mumɨŋga wit kɨrɨs kɨvayɨ sisɨvɨrɨman vata umi. ");
INSERT INTO kqa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kamata kɨva hañɨ sisɨvata uhihi muvɨra kɨndɨmbatɨyɨ mɨŋgaramahu kava pata ñamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Muvɨra pɨrɨ tɨmba naŋga vɨrañɨ mɨŋgaramamu. Pɨrɨ kandɨhaŋu simbɨyɨ simbɨyɨ kɨrɨ hambu tɨmba naŋga. Kamataharɨm wit kɨrɨs kandɨhaŋɨnɨŋ pɨrɨ kandɨhaŋu mɨŋgaramata sarɨwayɨ tɨmɨravaramu. ");
INSERT INTO kqa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hara kundur ha kavarahi pɨrɨhumbañɨ mamɨŋgumi. Harɨm ina kɨrahɨmuhi sahata kɨmumbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ara wit kɨrɨs muvɨra siki punzɨmbunzɨ ñiŋgiñɨ mɨŋgaramamu. Kamatɨhu siki punzɨ naŋga haŋɨnɨŋ tɨmɨrata wit haŋɨnɨŋ tarɨŋgumu. ");
INSERT INTO kqa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hara wit kɨrɨs muvɨra pɨrɨ aviyɨ mɨŋgaramata tɨmɨrata kandɨ tamamu. Muvɨra 100, muvɨra 60, muvɨra 30 tɨndɨ tamamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kru kɨnzɨhi naŋga hama, kuyu nɨŋandɨhin mɨŋatamamaŋgarata indarɨm, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kɨyɨhandata Jisasɨndu sɨmbɨrasara pata nuŋ nɨmavamba kitɨhumu, Mumɨndɨhi krunavundiŋ tɨhi kuyuyɨ taya ambavarandana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kamavahu Jisas ambami, Narɨŋ Got andɨti muhɨmɨmuhɨm nuŋandɨ tɨwɨyɨ kɨyɨhɨyɨ hañɨndu kuyu sapa sipɨruta kɨndi ha ŋgɨmandɨra. Hara krunavundi maŋgɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kru mumɨŋgandu kandɨhamata hɨm muhɨmɨmuhɨm kɨyɨmandɨ hañɨ nuŋ Got sɨhinda muvɨra ŋgurɨmandɨ. Kamati nuŋandɨ muhɨmɨmuhɨm sambɨ kɨyɨmandɨ. Hara kru mumɨŋgandu muhɨmɨmuhɨm maŋgɨyɨmandɨ ha, muhɨmɨmuhɨm mɨŋahandata kɨyɨmandɨyɨpu ha Got pɨŋguvarata mɨtɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kanɨmata sapayɨrɨm nurɨŋ tɨhi kuyu ŋgundin. Nurɨŋandɨ tamɨŋgaŋgɨrɨs ha tɨhɨrañandi, hara muhɨm maŋgɨmandɨyu. Mɨŋatamandu hara, kuyu mu maŋindarɨmandɨyu, kamatu nurɨŋandɨ mirɨmba vu mandaruvɨhɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Krunavundi kanɨmata nɨŋɨnɨŋɨrɨm ndɨhi Gotɨndu kuyu mɨŋata ambavaravara Aisaia ambami, Got ambi, Kuyu sambɨ ñɨmbɨrɨ indarɨmandɨra. Hara kuyu sapavu maŋgɨmandɨra. Muhɨmɨnda ŋgɨmɨndaŋ vata sambɨ ñɨmbɨrɨ tɨhɨraramɨrɨmandɨra, hara maŋgɨyɨmandɨra. Krunavundi kandaŋɨnɨŋɨndu mavɨ humba hambu tɨkatɨkatɨmi. Kamatɨhi nurɨŋandɨ kɨnɨzɨhi haŋɨnɨŋ kuyu avi indarɨtarɨrɨm yakwɨrɨvarandu. Nurɨŋandɨ tamɨŋgaŋgɨrɨsɨ ha mɨŋayɨhɨndu. Kamataharɨm nurɨŋandɨ tamɨŋga ha muhɨm maŋgɨmandɨ. Kamati nurɨŋandɨ kɨnzɨhi ha muhɨm kuyu maŋindarɨti, nurɨŋandɨ mavɨ humbavu kuyu sapa ha maŋgɨmandɨ. Kandɨhamata vana maŋandɨta, mavɨŋgimɨruta yi kɨnɨyɨ patu nurɨŋ mɨŋavindamahin, vamba ambi, vamba ambami. Aisaia ambami kuyu ha kandɨsɨkwɨsɨkwɨ yɨvurahi. ");
INSERT INTO kqa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Narɨ kuyu indarɨndara, naŋga muhɨmɨmuhɨm ŋgandara. Harɨm narɨ kɨnzɨhɨnzɨtɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yi narɨŋ kandɨ ambin, kuha kru Gotɨndu kuyu mɨŋata ambavaravara naŋga kru tɨtɨtaya kɨyɨhɨyɨ haŋɨnɨŋ sambɨ muhɨmɨmuhɨm tɨhu ŋgara nɨŋɨnɨŋ ŋgɨmɨndaŋ vata pirɨtamamaŋgaramu, hara maŋgamu. Naŋga kuyu indarɨndara nɨŋɨnɨŋ indarɨmɨndaŋ vata pirɨtamamaŋgaramu, hara maŋindarɨmu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisas sɨhinda ambami, Kru mumɨŋga kɨvayɨ wit kɨrɨs kavaramindu tɨhi kuyu hañɨndu kuyu sapa ambɨtɨn indarɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit kɨrɨs kwɨmbɨyɨ mɨŋgaramamu maña handa, kru Gotɨndu tɨwɨyɨ kɨyɨhɨyɨndu kuyu avivi indarɨndi. Hara nuŋandɨ sapavu maŋgandi. Kamatɨhi Satan nu kɨndɨyɨ pata sarɨwayɨŋandi kuyu Got nuŋandɨ mavɨŋgukuyɨ kurɨndi haŋɨnɨŋ pɨŋguvarandi. ");
INSERT INTO kqa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ara wit kɨrɨs pɨrɨ simbɨyɨ simbɨyɨ kɨrɨvu tɨmba naŋga vɨrañɨ mɨŋgaramata sarɨwayɨŋandi tɨmɨravarami maña handa, kru Gotɨndu kuyu avivi sarɨwayɨŋandi indarɨta kɨnzɨhɨnzɨtɨndi. Hara nuŋandɨ indarɨmaŋgaramaŋgara vana ha wit kɨrɨs kundur manɨman maña, harɨm nuŋandɨ indarɨmaŋgamaŋgara vana ha pakanda kɨndi. Gotɨndu kuyu avivi indarɨta kɨnzɨhɨnzɨtɨndi. Hara kru nuŋandɨ indarɨmaŋgaramaŋgara vana haŋandɨhinɨrɨm pɨmɨ ŋguhu, nuŋandɨ indarɨmaŋgaramaŋgara vana ha mɨŋgata yɨvundi. ");
INSERT INTO kqa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ara wit kɨrɨs muvɨra siki punzɨmbunzɨ ñiŋgiñɨ mɨŋgaramamu maña handa, kru Gotɨndu kuyu avivi indarɨndu. Hara pɨrɨ nɨñɨndu hɨmɨrɨm tɨmutɨmutɨndi, naŋga tɨmbahɨrɨs sambɨ mɨŋatɨhɨruramaramarɨm indarɨndi. Kamatɨhu kandɨ vana haŋɨnɨŋ Gotɨndu kuyu haŋɨnɨŋ yɨvutarɨŋguhi kandɨmandamandi. ");
INSERT INTO kqa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hara wit kɨrɨs pɨrɨ aviyɨ mɨŋgaramamu maña handa, kru Gotɨndu kuyu avivi indarɨta sapavu ŋgamaŋgarandi. Kamata 30 kɨrɨs, 60 kɨrɨs, 100 kɨrɨs tɨndɨ kandɨ tamandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas nurɨŋ tɨhi kuyu muŋandɨhin nɨmavamba ambami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha kru mumɨŋga nuŋandɨ kɨvayɨ wit kɨrɨs avi haŋɨnɨŋ kavarami maña. ");
INSERT INTO kqa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hara krunavundi karɨhahuhu kru hamandu miku mɨŋga pata tɨpa ñambandu kɨrɨs wit avi ñiŋgi hañɨ kavarata umi. ");
INSERT INTO kqa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kamatɨhi kɨyɨhandata wit haŋɨnɨŋ aruta kandɨ tamɨrɨm andɨhi ŋgahura tɨpa ñamba haŋɨnɨŋ ndahara kandɨ tamɨrɨm kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kamatɨhu sɨmbɨrasara haŋɨnɨŋ uta kɨva nɨŋuva hamaŋ nɨmavamba ambamu, Aru mɨŋga, ara wit kɨrɨs taya vaha nandɨ kɨva nɨñɨ kavaramana vamba indarɨndarɨŋ. Hara mumɨndɨhi tɨpa ñamba nda naŋga tɨmɨri, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kamavahu nurɨŋ ambami, Miku hɨru mumɨŋga kandɨ musa ha andɨsɨmi, vamba ambami. Kamavahi ambamu, Ŋgɨnaŋgata uta tɨpa ñamba ha kumbɨravarɨm, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kamavahura nurɨŋ ambami, Kɨtɨraŋgɨtɨraŋgwɨsa. Tɨpa ñamba haŋɨnɨŋ kumbɨravarambara wit avi haŋɨnɨŋ naŋga kumbɨravarɨtɨramandɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kamata mandɨta mitɨra arɨkita kɨhɨrɨhɨrɨ arutɨmu. Kamatu tahɨratahɨra tɨwɨmi kru sɨmbɨra mɨŋɨmandɨyu haŋɨnɨŋɨrɨm ambɨrɨman, Tɨpa ñamba haŋɨnɨŋ wɨsa tahɨrandahɨra kɨtɨ kahaŋgaha ahuyɨ kɨrahɨrarɨm tamamara. Kamata wit avi haŋɨnɨŋ yɨvutɨhɨruramata huyɨmandavɨ yandɨyɨ tamamamara, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas nurɨŋ tɨhi kuyu muŋandɨhin nɨmavamba ambami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha sahi mastetɨndu kɨrɨs maña. Kru mumɨŋga mastet kɨrɨs ha mɨŋata nuŋandɨ kɨvayɨ sisɨvami. ");
INSERT INTO kqa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastetɨndu kɨrɨs ha sahi muvɨrandu maña ma. Sukɨhɨrɨs sɨrambɨ, hara tɨmɨrata arutɨndi ha sahi muvɨraŋ taratɨvɨrata ahu maña arutɨndi. Kamatɨhi kava pata nuŋandɨ maka hañɨ ñiŋgi tɨhundu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas nurɨŋ sɨhinda tɨhi kuyu muŋandi nɨmavamba ambami. Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha yis maña. Navundi muŋambɨ wit sambɨ mɨŋata yis naŋga tarayɨwarata tamahi kɨhata sɨŋgɨ ha naŋga kɨhɨrɨhɨrɨtɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas sɨhanaŋga kuyu krunavundiŋ ambavarami nɨŋɨnɨŋ, tɨhi kuyuyɨ taya ambavarami. Mɨŋamamañɨ ndamata maŋambavarami. ");
INSERT INTO kqa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kuha kru Gotɨndu kuyu mɨŋata ambavaravara mumɨŋgandu mɨkatɨmbayɨ Got nɨmavamba ambami, Muhɨmɨmuhɨm pɨrɨ nɨñɨ yɨvurahami hɨrɨvɨ hañɨnda kɨta patavata tɨhundu takuk nɨñɨ, muhɨmɨmuhɨm sipɨruta kɨndi ha yi tɨhi kuyuyɨ taya ambavarɨman, vamba ambami. Kamavami kuyu ha Jisas andɨhi kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas krunavundiŋ mitata tavɨ humbañɨ indɨhuhi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nu kɨyɨmiyɨ pata nɨmavamba kitɨhumu, Tɨpa ñamba kɨvayɨ yaharamami hañɨndu kuyu sapa ha ambɨna ŋgaharɨŋ vaha, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kamavahu Jisas nurɨŋ ambami, Kru wit kɨrɨs avi kavarami hama Krundu Ñɨŋi. ");
INSERT INTO kqa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ara kɨva ha pɨrɨ nɨŋandɨhin. Ara wit kɨrɨs avi haŋɨnɨŋ krunavundi Gotɨndu tɨwɨyɨ kɨyɨhɨyɨ haŋɨnɨŋ. Ara tɨpa ñamba haŋɨnɨŋ, kaŋɨnɨŋ krunavundi Satanɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kru miku mɨŋga tɨpa ñamba kavarami hama Satan. Ara wit tahɨratahɨra tɨwɨmi haŋandɨhin pɨrɨ nɨŋandihindu imbɨhɨvɨ. Ara sɨmbɨrasara wit tahɨratahɨra haŋɨnɨŋ Gotɨndu kutɨkara. ");
INSERT INTO kqa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kru tɨpa ñamba kumbɨrata kɨramu maña ha, pɨrɨ nɨñɨndu imbɨhɨvɨyɨ andɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Krundu Ñɨŋi hama nuŋandɨ kutɨkara haŋɨnɨŋ sɨmbɨti payɨmandɨyu. Kamati muhɨmɨmuhɨm andɨhi krunavundindu indarɨmaŋgaramaŋgara vana ñambatɨndi haŋɨnɨŋ naŋga, kru sɨhanaŋga ñamba vana andɨndu haŋɨnɨŋ, pɨŋguvarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kamata kavarɨtu ahumira aruyɨ urɨmandɨyu. Ahutuŋgɨ kandɨhañɨ irɨharɨha mɨka satɨpɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kandɨtɨwɨmi hañɨ krunavundi tɨtɨtaya kɨyɨhɨyɨ haŋɨnɨŋ, nurɨŋandɨ Nɨŋuvandu tɨwɨyɨ kɨyɨhɨyɨ hañɨ ina tɨmɨrata sɨñandɨndi maña sɨñandɨrɨmandɨyu. Kru kɨnzɨhi naŋga hama, kuyu nɨŋandɨhin mɨŋatamamaŋgarata indarɨm, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas sɨhinda ambami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha tɨmbahɨrɨs tupi kɨva itɨñɨ pɨrɨ kayɨvata sipɨrumu maña ŋandi. Kamatɨhu kru mumɨŋga ŋgata sɨhinda sipɨrumi. Kamata kɨnzɨhɨnzɨta uta nuŋandɨ muhɨmɨmuhɨm ambahi mut mɨŋahu tɨmbahɨrɨs ha mɨŋata uta kɨva kandɨha mut mɨŋami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas sɨhinda tɨhi kuyu muŋandi ambata nɨmavami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha, kru tɨmbahɨrɨsɨndu arɨku mɨŋga wɨrɨri avirɨm puhɨrata kɨndɨmañandɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kamata wɨrɨri muŋandi ŋgahi avinzɨkwɨsɨkwɨ tɨhi, uta ambahi muhɨmɨmuhɨm nuŋandɨha mut mɨŋahu tɨmbahɨrɨs ha mɨŋata uta wɨrɨri avinzɨkwɨ kandɨha mut mɨŋami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas sɨhinda tɨhi kuyu muŋandi ambata nɨmavami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha kamahayɨ indu muyɨ kavarahu mɨŋguhi muhɨmɨmuhɨm asa mɨŋandu maña. ");
INSERT INTO kqa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kamahayɨ ha yavurɨhi pɨŋgɨrɨta pata tɨŋgɨvu tamamu. Kamata mɨnɨzɨta itɨhata asa avivi haŋɨnɨŋ maki isɨ muyɨ tamata, asa ñamba haŋɨnɨŋ kahuvaramu. ");
INSERT INTO kqa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pɨrɨ nɨñɨndu imbɨhɨvɨyɨ ndahara sɨwɨmañanda andɨrɨmandɨyu. Gotɨndu kutɨkara pata, kru ñamba ŋɨnɨŋ kru tɨtɨtaya kɨyɨhɨyɨ ñiŋgi hañɨ kɨyɨmandɨyu haŋɨnɨŋ mɨŋɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kamata kavarɨtu ahumira aruyɨ urɨmandɨyu. Kamata ahutuŋgɨ aruyɨ kavarɨtu irɨharɨha mɨka satɨpɨrɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kamavata Jisas sɨmbɨrasara haŋɨnɨŋ kitɨhuta nɨmavami, Kuyu sɨhanaŋga kanɨŋɨnɨŋɨndu kuyu sapa ŋgandara vaha, vami. Kamavahi ambamu, Ŋgandarɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kamavahu nurɨŋ ambami, Tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ tɨkatɨka kuyu ŋgandu. Kamataharɨm Gotɨndu tɨwɨyɨ kɨyɨhɨyɨndu kuyu sapa handahara ŋgandu. Nurɨ tavɨ aru muŋandɨhinɨndu nɨŋuva maña. Tavɨhumba hañɨndu muhambu indɨhuta muhɨmɨmuhɨm nuŋandɨ avivi kuhandu naŋga kɨhi yavurɨta kɨndi haŋɨnɨŋ, sɨhanaŋga mɨŋaramahi tapɨrañɨ pindɨhami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jisas tɨhi kuyu kanɨŋɨnɨŋ ambavarata mɨtuta pɨhu kandɨha mitata nuŋandɨ pɨhuyɨ umi. Uta Got naŋga kuyundavaravara tavɨ nurɨŋandɨyɨ indɨhuta, krunavundiŋ Gotɨndu kuyu ambavarami. Kamatɨhi krunavundi sɨhanaŋga nuŋandɨ kuyu ha indarɨhu mavɨ yahavarahi nɨmavamu, Kru kanɨma indarɨmit avi naŋga muhɨm nzihɨ sɨhɨrandi vana nɨŋandɨhin paŋundu mɨŋami. ");
INSERT INTO kqa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ara ŋgandarɨŋ, kru nɨma nɨŋuva tavɨ tɨhutɨhu mɨŋga. Nɨŋum Maria, nɨŋuranava, Jems, Josep, Saimon naŋga Judas. ");
INSERT INTO kqa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naŋga nɨŋurɨmaŋgati sɨhanaŋga kɨhɨrɨ kɨrɨŋ. Kru kanɨma tɨkatɨka naŋga indarɨmit avi nɨŋandɨhin paŋundu mɨŋata kandɨ vana nɨŋɨnɨŋ andɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kamavata nuŋɨrɨm kɨpuhɨputɨmu. Kamatɨhura Jisas nurɨŋ nɨmavami, Kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga mupɨhu mupɨhu nu ñɨmbi naŋga mɨŋga kɨndi. Hara nuŋandɨ pɨhu tɨmbanzɨkwɨyɨ naŋga nuŋandɨ tavɨyɨ nu ñɨmbi manɨman mɨŋga kɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kamataharɨm nɨŋambirɨm maŋindarɨmaŋgarahu, pɨhu kandɨhañɨ muhɨmɨmuhɨm nzihɨ kandɨŋgandɨ nzɨkwɨ manzihɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kandɨhɨrɨvɨ hañɨ Herot pɨrɨvɨsa Galilindu gavamandu aru miku kɨyɨmi. Kamata Jisas muhɨmɨmuhɨm nzihɨsihɨ andɨmi vana ha indarɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jisasɨndu kuyuhɨnzɨ Herot indarɨta nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nɨmavami, Kru kandɨhama Jon kukuyɨ mɨŋaŋgɨruhɨru hama ndɨmbanzɨkwɨ. Nu savayɨ kɨta aŋga yahamɨrami. Harɨm muhɨmɨmuhɨm nzihɨ sihɨrasihɨrandu tɨkatɨka nuŋandɨ kɨyɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kuha Herodiasɨŋ Herot urami, nu nɨŋura Filip nɨmburi. Kamatɨhi Jon Herotɨŋ nɨmavami, Navundi kaŋambɨŋ urahana avimandɨ, vami. Kamavahi Jonɨŋ Herot mɨŋahandata siki takɨrɨ maña tɨkatɨka hɨmɨñɨ kahañata ñamba vana andɨhu tamandu upɨyɨ tamami. ");
INSERT INTO kqa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kamata Herot Jonɨŋ yɨvutatamɨrɨman vata andɨmi. Hara krunavundi Jonɨrɨm kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga vamba indarɨmitandu. Harɨm krunavundirɨm pɨŋitumi. ");
INSERT INTO kqa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kamata muhɨvɨyɨ kru muvɨra pata Herot naŋga nɨŋum nuŋ kavumi hɨvɨ haŋandɨhinɨrɨm indaramata ñamu. Kamatɨhu kandɨhɨvɨ hañɨ Herodiasɨndu navundi ñɨŋi haŋambɨ pata nurɨ kɨyɨmu itɨhañɨ tuturamami. Kamatɨhi Herot tuturamami haŋandɨhinɨrɨm mavɨndamaŋgarami. ");
INSERT INTO kqa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kamata Herot tɨkatɨka kuyu kahañata nɨmavami, Kandɨsɨkwɨsɨkwɨ, yaŋ muhɨmɨrɨm nda kitɨwɨna ŋgurɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kamavahi Herodias, navundi ñɨŋi haŋambɨ nɨŋum, nuŋandɨ navundiŋ ambami. Kamatɨhi nuŋandɨ navundi haŋambɨ Herotɨŋ ambami, Jon kukuyɨ mɨŋaŋgɨruhɨru hamandu mikumuŋgɨ ha maki muyɨ tamata kavuta pata yaŋ ŋgu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kamavahi aru miku hama kuyu kandɨha indarɨhi nuŋandɨ mavɨmbu pɨmɨtɨmi. Hara tɨkatɨka kuyu kahañami haŋandɨhinɨrɨm indarɨmi. Harɨm kɨhɨrɨ mɨnzɨta ñamu haŋɨnɨŋɨndu tamɨŋgaŋgɨmbañɨ sɨhumɨ ŋgavɨtɨnɨma vata, saŋganzaraŋ ambahi navundi ñɨŋi haŋambɨ ambami maña andɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kru mumɨŋgaŋ sɨmbɨhi kru ñamba vana andɨhu tamandu upɨyɨ umi. Uta saŋganzara muhamaŋ ambahi Jonɨŋ pɨŋgwɨ pɨtɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kamata maki muyɨ miku ha tamata mɨŋata uta navundi ñɨŋi haŋambɨŋ ŋgumi. Kamatɨhi nɨŋum kɨyɨmiyɨ mɨŋata umi. ");
INSERT INTO kqa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kamatɨhu Jonɨndu sɨmbɨrasara haŋɨnɨŋ pata Jonɨndu patɨ ha kavuta uta, sava humbañɨ tamamamu. Kamata uta Jisasɨŋ ambavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas Jonɨŋ yɨvutatamatama kuyu indarɨmi, harɨm kandɨ pɨhu ha mitata nuŋandɨ sɨmbɨrasara haŋɨnɨŋ naŋga kupik mɨŋata kru manɨman upɨvu umu. Kamatɨhura krunavundi sambɨ Jisas uyɨ vava kuyu indarɨta, pɨhu aru haŋɨnɨŋ mitata, nuŋ puhɨrata pɨrɨyɨ umu. ");
INSERT INTO kqa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Uta yɨvurahata ŋgahi krunavundi sambɨ kɨyɨmu. Kamatɨhu ŋgahi mavɨndɨhi, nurɨŋandɨ krunavundi kandi naŋga haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kamata kɨvɨtititɨhi sɨmbɨrasara haŋɨnɨŋ pata Jisasɨŋ nɨmavamu, Nɨŋu kru manɨman upɨvu, naŋga ina mɨŋguta kɨvɨtɨrɨm andɨ. Harɨm avinda krunavundiŋ sɨmbɨna pɨhu makamaka uhuhu nurɨŋambirɨm ñaña mut mɨŋamu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kamavahu Jisas nuŋandɨ sɨmbɨrasaraŋ ambami, Mumɨrɨm urɨmandɨyu. Narɨŋambinda ñaña ŋgutɨra ñamu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kamavahi nuŋ ambamu, Arɨŋandɨ ñaña nɨñɨ sambɨ maŋgɨyɨ. Mavatɨmba arɨkita arɨkita kwɨrɨ naŋga asa arɨkita taya kɨyɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kamavahu ambami, Ara mavatɨmba naŋga asa kandɨha yi kɨnɨ nɨñɨ mɨŋata payɨmara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kamatɨhu Jisas krunavundiŋ ambahi tɨpa hañɨ mɨnzɨmu. Kamatɨhu mavatɨmba arɨkita arɨkita kwɨrɨ naŋga asa arɨkita haŋɨnɨŋ mɨŋata, kɨmba nɨmbu kuta yahuta Gotɨŋ kuyu avivi ŋgumi. Kamata mɨŋasɨhɨraramata nuŋandɨ sɨmbɨrasaraŋ ŋguhi krunavundiŋ tɨŋgɨrumu. ");
INSERT INTO kqa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kamatɨhu sɨhanaŋga ñahu kɨpɨtɨmi. Kamata mitamu haŋɨnɨŋ kɨyɨhi, yɨvutɨhɨruramata tɨwatɨwa kuma timutamu, tanda arɨkinzɨpi tɨŋgɨruramatayɨ kundamu. ");
INSERT INTO kqa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kru ñamu haŋɨnɨŋ 5,000 vat krundaya. Hara navundi naŋga ñɨŋisɨmɨŋ mayɨhɨtɨŋgɨrumu. ");
INSERT INTO kqa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas nuŋambi kɨta krunavundiŋ sɨmbɨtɨn urɨmandɨyu vata andɨmi. Harɨm nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kupik hañɨ yahuta kasiramata indu timukari hambu indɨhumu vata ambami. ");
INSERT INTO kqa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kamata krunavundiŋ sɨmbɨhi uhuhu nu nuŋambi apuvu Aru nɨma naŋga kuyundavarɨrɨm yahumi. Kamata ina mɨŋgumi hɨrɨvɨyɨ nu nuŋambi apu hambu kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kupik ha tɨvɨ hambu mitata uhi kutandɨmi. Kamatɨhi wɨnɨ kupik ñapɨru hambu pata kuku ha naŋga kupik ha tarayɨkɨrahi mɨnza haŋu ndaya kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kamata kwɨsɨ pɨhɨrɨta sɨñandɨhi Jisas kuku hɨmba hañɨ taŋguramata uta nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kɨyɨmuyɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kamatɨhi nuŋ ŋgahu indu hɨmba hañɨ payɨhi pɨŋituta nanaŋgarata ambamu, Nɨ sundɨ ñamba muŋandi, vamu. Kamavata pɨŋituta patɨ avaŋgaramu. ");
INSERT INTO kqa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kamatɨhura sarɨwayɨŋandi Jisas nurɨŋ nɨmavami, Tɨkatɨkatɨta kɨyɨmara. Nɨmbu yitɨhi pɨŋimandumara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kamavahi Pita yahata nuŋ kɨmbɨ nɨmavami, Aru mɨŋga, na tiŋgata, ambɨna yindahara kuku hɨmbanɨñɨ na kɨna hañɨ taŋguramata utɨnɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kamavahi Jisas ambami, Ara pañɨ, vami. Kamavahi Pita kupik ha mitata kuku hɨmba hañɨ taŋgutaŋguramata Jisas kɨyɨmiyɨ umi. ");
INSERT INTO kqa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hara ŋgahi wɨnɨ ha tɨkatɨka sɨkwɨtɨhi pɨŋitumi. Kamata kuku hañɨ tɨhɨta mɨŋguhandami. Harɨm yahata kuyu kɨmbañɨ nɨmavami, Aru mɨŋga, yaŋ ŋgurama, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kamavahi sarɨwayɨŋandi Jisas kumandamata Pitaŋ mɨŋahandata nɨmavami, Yaŋɨrɨm indarɨmaŋgaramaŋgara vana nandɨ ha sukɨsɨmbɨrɨ. Mumɨndɨhi nandɨ indarɨmit arɨkita kɨyɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kamavata arɨkimbat kupik hañɨ yahuhu wɨnɨ ha tɨhɨmitami. ");
INSERT INTO kqa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kamatɨhi kru kupik hɨmba hañɨ kɨyɨmu haŋɨnɨŋ Jisasɨndu ñɨmbi tɨhuyahata nɨmavamu, Kandɨsɨkwɨsɨkwɨ na Gotɨndu Ñɨŋi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas naŋga nuŋandɨ sɨmbɨrasara indu timukari hambu indɨhuta, pɨhu Genesaret arɨñɨ yɨvurahamu. ");
INSERT INTO kqa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kamatɨhu kru kandɨhaŋu hati Jisasɨŋ ŋgata, nuŋ ŋgandu, harɨm sɨhanaŋga pɨhu kandɨhaŋu arɨñɨ kɨndu haŋɨnɨŋɨrɨm kuyu tamahu umi. Kamatɨhu krunavundi sɨhanaŋga kandi naŋga haŋɨnɨŋ tɨmbuta nu kɨyɨmiyɨ payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kamata Jisasɨrɨm, mitɨna krunavundi kandi naŋga nɨŋɨnɨŋ nandɨ mɨkwɨrɨ ñapɨru hañɨ mɨŋasarata avindɨmu vata añaŋgaramu. Kamata krunavundi sɨhanaŋga kandɨhamatɨmu haŋɨnɨŋ, avindɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kandɨhɨrɨvɨ haŋu Farisi naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ Jerusalem mitata Jisas kɨyɨmiyɨ umu. Kamata nuŋ nɨmavamba kitɨhumu, ");
INSERT INTO kqa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mumɨndɨhi nandɨ sɨmbɨrasara nɨŋɨnɨŋ arɨŋandɨ añɨŋgitakɨñandu tɨkatɨka kuyu arɨŋ ŋgumu nɨŋɨnɨŋ mɨŋata kavarandu. Ñɨrɨm, kuma ñɨmburɨtara mañandu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kamavahu Jisas nurɨŋ kɨmbɨ nɨmavami, Mumɨndɨhi narɨŋandɨ vana taya mɨŋahandata, Gotɨndu tɨkatɨka kuyu mɨŋata kavarandara. ");
INSERT INTO kqa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Got ambami, Namɨnavandu tɨwɨyɨ taya kɨta nurɨŋandɨ kuyu taya mɨŋahanda. Naŋga, kru nɨŋum nɨŋuvaŋ mɨkatihɨrɨmandɨ hama kwɨmɨrɨmandɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hara narɨ nɨmavamba ambandara, Kru mumɨŋga nɨŋum nɨŋuvaŋ ŋguramaramandu tɨmbahɨrɨs haŋandɨhin ndaya kɨti, yahata nɨŋum nɨŋuvaŋ ambɨrɨmandɨ. Yi tɨmbahɨrɨs nɨ Gotɨŋ ŋgurɨm yɨhɨramin ndaya kɨyɨ, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kru kandɨhama nɨŋum nɨŋuvandu tɨwɨyɨ maŋgɨyɨmandɨ. Hara narɨ ambandara, Kru nɨŋum nɨŋuvaŋ tɨmbahɨrɨs maŋguta avi vana andɨrɨmandɨ, vamba ambandara. Kandɨhamata vanayɨ narɨ Gotɨndu kuyu haŋandɨhin taŋguhara mɨŋgundi. Kamata narɨŋandɨ nañɨŋgitakɨñandu vana taya tɨhuyahandara. ");
INSERT INTO kqa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Gotɨndu kuyu mɨŋata ambavaravara Aisaia narɨŋandɨ vanarɨm ambami, Got ambi, ");
INSERT INTO kqa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Krunavundi yandɨ ñɨmbi nurɨŋandɨ mɨkatɨmbayɨ tɨhuyahandu. Hara nurɨŋandɨ mavɨŋguku naŋga indarɨmit haŋɨnɨŋ yambirɨm kutañɨ nzɨkwɨ kɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Krundu tɨkatɨka kuyu ambavarata, Nɨŋandɨhin Gotɨndu kuyu, vamba ambandu. Harɨm yandɨ ñɨmbi saŋ naŋga tɨhuyahandu, vamba ambi, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas krunavundiŋ uraramahi payɨhu nɨmavamba ambami, Kuyu nɨ ambɨtɨn indarɨmaŋgarata mirɨmbañɨ tamamara. ");
INSERT INTO kqa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Muhɨmɨmuhɨm mɨka humbañɨ indɨhundi haŋɨnɨŋ andɨhi Gotɨndu tamɨŋgañɨ kru ñɨŋɨ mandɨndi. Muhɨmɨmuhɨm kuyu mɨkatɨmba nɨ ambavarandi haŋandɨhin andɨhi, Gotɨndu tamɨŋgañɨ kru ñɨŋɨndɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kamavahi kɨyɨhandata Jisasɨndu sɨmbɨrasara haŋɨnɨŋ pata nuŋ nɨmavamu, Farisi ndaŋɨnɨŋ kuyu kandɨnɨ indarɨhu nurɨŋandɨ mavɨ ndambu avimandɨha ŋganada, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kamavahu Jisas nurɨŋ nɨmavami, Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hama kɨva naŋga mɨŋga. Harɨm muhɨmɨmuhɨm nu maŋgurɨmi haŋɨnɨŋ kundur haŋɨnɨŋ naŋga kumbɨravarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kaŋɨnɨŋɨrɨm kandɨ vata maŋambamara. Nurɨ tamɨŋga ñumi ŋɨnɨŋ maña. Tamɨŋga ñumi mɨŋga yahata tamɨŋga ñumi muhamaŋ kwɨmbɨ isɨhuramɨrɨman vata arɨkimbat kumbañɨ mɨŋguhu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kamavahi Pita Jisasɨŋ kitɨhuta nɨmavami, Krunavundiŋ muhɨmɨmuhɨm andɨhi Gotɨndu tamɨŋgañɨ ñɨŋɨndɨndu vamba tɨhi kuyu ambavarana hañɨndu kuyu sapa arɨŋ ambavarɨna indarɨharɨŋ vaha, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kamavahi Jisas ambami, Narɨndahara kwɨnɨkwɨnɨtɨra wɨsa vaha tɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Narɨ ŋgandara. Muhɨmɨmuhɨm mɨka humbañɨ indɨhundi ha mavɨ humbañɨ mɨŋgundi. Kamatɨhi mavɨ nɨŋandɨhin sɨhusɨhu tavɨyɨ pɨŋguvarahi undi. ");
INSERT INTO kqa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hara kuyu mɨka nɨŋandɨhin ambavarandi haŋandɨhin mavɨŋguku nɨmbundu yɨvurahandi. Kandɨ vana haŋandɨhin andɨhi Gotɨndu tamɨŋgañɨ kru ñɨŋɨndɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yi krundu mavɨŋgukuyɨndu muhɨmɨmuhɨm ñamba vana nɨmata nɨŋɨnɨŋ yɨvurahandirɨm ambin. Indarɨmit ñamba. Kruŋ yɨvutatamahi kɨmuhɨmu vana. Navundi kru manɨman naŋga kru navundi manɨman mɨŋavɨŋgɨrɨvɨŋgɨrɨ vana. Navundi kru naŋga haŋɨnɨŋ, naŋga kru navundi naŋga haŋɨnɨŋ pɨsiŋgarahara vana. Kipa mɨŋamɨŋa vana. Ŋgatɨŋgɨrutɨŋgɨru tɨwɨmiyɨ kuyusɨhɨrɨŋguyu ambavaravara vana, naŋga muŋɨnɨŋ ñamba taŋgutaŋgu vana. ");
INSERT INTO kqa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kandɨ vana nɨŋɨnɨŋ andɨhi, Gotɨndu tamɨŋgañɨ kru ñɨŋɨndɨndi. Hara kru kuma ñɨmburɨmatɨ ñandi haŋandɨhin andɨhi Gotɨndu tamɨŋgañɨ kru ñɨŋɨ mandɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas pɨhu Genesaret mitata, pɨhu aru Tair naŋga Saidonɨndu vu umi. ");
INSERT INTO kqa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kamatɨhi Kenanɨndu krunzapayɨndu navundi uta kandambu kɨndi ŋambɨ pata kuyu kɨmbañɨ Jisasɨŋ nɨmavami, Aru mɨŋga, na Devit Nɨŋuñɨŋgi yaŋ sɨhiŋga. Yandɨ navundi ñɨŋi nɨŋambɨŋ sundɨ ñamba arɨŋguta pɨsiŋgarandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kamavahira Jisas nuŋ kuyu kɨmbɨ mu ndahara maŋambami. Kamatɨhira navundi haŋambɨ tuvɨrata sɨhɨndɨ payɨhi Jisasɨndu sɨmbɨrasara haŋɨnɨŋ pata Jisasɨŋ nɨmavamu, Navundi nɨŋambɨ sɨhɨndɨ nɨmbu avaŋgarata sirindamata payɨtɨhi sɨmbɨna aŋga umɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kamavahu Jisas ambami, Got yaŋ sɨmbɨhi Israel hatiŋ ndaya, sipsip siŋgundɨndu maña haŋɨnɨŋ ŋguramɨrɨm payɨmin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kamavahira navundi haŋambɨ pata Jisas kɨyɨmi hañɨ tandamɨkwɨmɨkwɨta, naŋgwɨndarata pɨrɨnɨmbu tɨhɨrata nɨmavami, Aru mɨŋga, yaŋ ŋgurama, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kamavahi Jisas nuŋ ambami, Ñɨŋindu ñaña nɨ mɨŋata upɨrirɨm kavarɨtɨrɨŋ utima, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kamavahira navundi haŋambɨ nɨmavami, Aru mɨŋga, kandɨ ambana. Hara ñɨŋi haŋɨnɨŋ ñahu, ñaña mɨñɨ nɨŋuvandu pina tɨwɨvu mɨŋgaramandi haŋɨnɨŋ upɨri ñandu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas kuyu kandɨha indarɨta navundi haŋambɨrɨm nɨmavami, Navundi na, nandɨ indarɨmaŋgaramaŋgara vana ha aru sɨkwɨ. Harɨm indarɨmitana hɨm ha yɨvuraham, vami. Kamavahi navundi haŋambɨndu ñɨŋi haŋambɨ kandɨhɨrɨvɨ hañɨ sɨkwɨtaya avindɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas pɨhu kandɨha mitata indu Galili kuku tɨviyɨndɨvɨñɨ ndaya umi. Kamata apuvu yahuta mɨnzɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kamatɨhi krunavundi sambɨ nu kɨyɨmiyɨ payɨmu. Kamata tanda ñamba, tamɨŋga ñumi, punzɨ kɨmɨkɨmɨ, maŋguyundavaravara haŋɨnɨŋ, naŋga muhɨmɨmuhɨm kandi naŋga haŋɨnɨŋ sambɨ tɨmbuta pata nuŋandɨ tandanzapa hañɨ tamamu. Kamatɨhu nurɨŋ mɨŋavindamahi, avindɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kamatɨhi krunavundi ŋgahu maŋguyundavarandu haŋɨnɨŋ kuyundavarahu, punzɨ kɨmɨkɨmɨ haŋɨnɨŋ avindɨhu, tanda ñamba haŋɨnɨŋ kɨndavarahu, tamɨŋga ñumi haŋɨnɨŋ tɨhɨrañamu. Kamatɨhi indarɨhɨtɨta Israelɨndu Gotɨndu ñɨmbi tɨhuyahamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas nuŋandɨ sɨmbɨrasaraŋ uraramahi payɨhu nɨmavami, Krunavundi nɨŋɨnɨŋɨrɨm yaŋ mavɨndɨ. Ara naŋga arɨki hɨvɨ sɨkwɨ kɨyɨhu kwɨrɨ hɨvɨ nɨñɨ ñaña nurɨŋandɨ maŋgɨyɨ. Harɨm avɨharɨm kɨtu sɨmbɨtɨn utu avi mandɨrɨmandɨ. Tamɨŋganzihɨsihɨtinda kwɨmbɨyɨ mɨŋgata yɨvɨtuma, vami. ");
INSERT INTO kqa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Jisasɨŋ nɨmavamu, Nɨmbɨrañɨ kru maŋgɨyɨ. Harɨm ara mavatɨmba sambɨ paŋundu mɨŋata krunzivi kanɨŋɨnɨŋ ŋgutɨrɨŋ ñɨrɨmandɨyu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kamavahu Jisas nurɨŋ kitɨhuta nɨmavami, Narɨŋandɨ mavatɨmba pamata kɨyɨ, vami. Kamavahi ambamu, Arɨŋandɨ mavatɨmba kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata kɨyɨ, naŋga asa sambɨ sɨkwɨ maŋgɨyɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kamavahu Jisas krunavundiŋ ambahi pɨrɨyɨ kambamɨnzɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kamatɨhu mavatɨmba kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata haŋɨnɨŋ naŋga asa haŋɨnɨŋ mɨŋami. Kamata Gotɨŋ kuyu avivi ŋguta mɨŋasɨhɨraramata nuŋandɨ sɨmbɨrasaraŋ ŋgumi. Kamatɨhi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ krunavundiŋ ŋgumu. ");
INSERT INTO kqa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kamatɨhu sɨhanaŋga ñahu kɨpɨtɨmi. Kamata ñata mitamu haŋɨnɨŋ yɨvutɨhɨruramata, tɨwatɨwa aruru kuma timu, tamu arɨkinzɨpi tɨŋgɨruramatayɨ kundamu. ");
INSERT INTO kqa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kru mɨnzɨta ñamu haŋɨnɨŋ kruŋ ndaya yɨhɨtɨŋgɨruhu 4,000 ndɨmi. Hara navundi naŋga ñɨŋi sɨrambɨŋ mayɨhɨtɨŋgɨrumu. ");
INSERT INTO kqa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kamata Jisas krunavundiŋ sɨmbɨhi uhu, kupik mɨŋata Magadanɨndu vu umi. ");
INSERT INTO kqa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi naŋga Sadyusi Jisasɨrɨm andɨti ŋgɨm vata pata nuŋ ambamu, Na Gotɨndu sɨmbɨra mɨŋandanatiŋgata muhɨm nzihɨ sihɨrɨna nandɨ kuma munzɨ ŋgɨm, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kamavahura nurɨŋ kɨmbɨ nɨmavami, Kɨvɨtiti ambandara, Ihumbɨsa nɨmbu ñaŋgwɨndɨ. Harɨm aviŋgɨvɨ kɨyɨmandɨ, vamba ambandara. ");
INSERT INTO kqa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɨvɨsɨhu ambandara, Kukumuwava ndaŋguta ihumbɨsa nɨmbu kitɨrɨtɨ. Harɨm musi kuku naŋga wɨnɨ payɨmandɨ, vamba ambandara. Kambu kandɨ, ihumbɨsa nɨmbu muhɨmɨmuhɨm nzihɨ yɨvurahandi haŋɨnɨŋ ŋgamaŋgarandara. Hara muhɨmɨmuhɨm nzihɨ tɨhuŋgɨrɨvɨ yɨvurahandi nɨŋɨnɨŋ maŋgamaŋgarandara. ");
INSERT INTO kqa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Krunavundi tɨhundu nɨŋɨnɨŋ ñamba ŋɨnɨŋ nzɨkwɨ, harɨm Gotɨŋ ndaya mavɨñɨ mandamandu. Kamatɨndɨ imutamut muhɨm nzihɨ ŋgɨmɨndaŋ vata tuvɨrandu, hara muhɨm nzihɨ muyɨpu ndahara maŋgɨmandɨyu. Muhɨm nzihɨ mɨŋgɨyamɨŋgɨya, Gotɨndu kru kuyu mɨŋata ambavaravara Jonandu handaya ŋgɨmandɨyu, vami. Kamavata Jisas nurɨŋ mitata umi. ");
INSERT INTO kqa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ uta indu timukari yɨvurahamu. Hara nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kwɨnɨkwɨnɨta mavatɨmba mɨŋata maŋumu. ");
INSERT INTO kqa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kamatɨhu Jisas nurɨŋ ambami, Narɨ Farisi naŋga Sadyusindu yisɨrɨm tamɨŋga naŋga kɨndamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nurɨŋambi masamasa kuyudavarata ambamu, Mavatɨmba mambaha mamɨŋata payɨharɨŋ yisɨrɨm ambi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kamavahu indarɨta Jisas nurɨŋ ambami, Kru indarɨmaŋgaramaŋgara vana suksɨmbɨrɨ naŋga narɨ. Mumɨndɨhi narɨ arɨŋandɨ mavatɨmba maŋgɨyɨ, vamba ambara. ");
INSERT INTO kqa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Narɨ indarɨmitata mambaha ŋgara. Mavatɨmba kumanzɨpi timu tɨŋgɨruramata 5,000 kru ñahu, pamata tɨwatɨwayɨ kundamara. ");
INSERT INTO kqa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naŋga narɨ mavatɨmba kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata 4,000 kru ñamu. Kamatɨhu tɨwatɨwa aruru pamatayɨ kundamara. ");
INSERT INTO kqa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Narɨ mumɨndɨhi indarɨmitata maŋgara. Narɨŋ yi mavatɨmbarɨm indarɨmitata kuyu maŋgwin. Yi ambin, narɨ Farisi naŋga Sadyusindu yisɨrɨm tamɨŋga naŋga kɨndamara vata ambin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kuyu kandɨha indarɨta ambamu, Yis mavatɨmba naŋga kɨrandu haŋandɨhinɨrɨm maŋambavari. Farisi naŋga Sadyusindu kuyurɨm tamɨŋga naŋga kɨndamara vata ambi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas pɨhu aru Sisariafilipai vurɨm umi. Uta kandɨtɨwɨmi hañɨ nuŋandɨ sɨmbɨrasaraŋ kitɨhuta ambami, Krunavundi ninɨrɨm Krundu Ñɨŋi, vamba ambandu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kamavahi ambamu, Muvɨra nambirɨm Jon kukuyɨ mɨŋaŋgɨruhɨru hama vandu. Muvɨra nambirɨm Elaija vandu, muvɨra nambirɨm Jeremaia vandu, mana kuhandu kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋɨndu muvat mɨŋga vaha, vamba ambandu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kamavahu Jisas nurɨŋ kitɨhuta ambami, Hara narɨŋambi, yambirɨm nin ndaya vamba ambandara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kamavahi Saimon Pita kɨmbɨ nɨmavamba ambami, Na Got krunavundiŋ aŋga mɨŋɨmandɨ vata yɨhɨramami hama. Na Got sɨhaŋgɨyɨhɨyɨ hamandu Ñɨŋi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kamavahi Jisas kɨmbɨ ambami, Saimon, Jon ñanɨŋ, na kɨnzɨhɨnzɨtɨ. Kandɨ kuyu nɨŋandɨhin naŋ pɨrɨ nɨñɨndu kru mumɨŋga maŋambaramami. Yandɨ Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hama naŋ kuyu kandɨnɨ ambarami. ");
INSERT INTO kqa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kamataharɨm naŋ ambɨrɨman, Na Pita. Yi krunavundi sɨhanaŋga yaŋɨrɨm indarɨmaŋgarandu haŋɨnɨŋ tɨmba hɨmba kandɨhañɨ tamɨman. Kamatɨn kɨmuhɨmundu tɨkatɨka, krunavundi yaŋɨrɨm indarɨmaŋgarandu haŋɨnɨŋ taŋguti mamɨŋgumandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yi naŋ Gotɨndu tɨwɨyɨ kɨyɨhɨyɨndu kɨndɨŋari pɨhɨrɨvɨhɨrɨ sɨki haŋɨnɨŋ ŋgurɨman. Kamatɨn muhɨmɨmuhɨm vana pɨrɨ nɨñɨ kahañɨrɨmanaŋa Got ndahara nuŋandɨ pɨhuyɨ kahañɨrɨmandɨ. Ara muhɨmɨmuhɨm vana pɨrɨ nɨñɨ kuyɨvɨrɨmanaŋa Got ndahara nuŋandɨ pɨhuyɨ kuyɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kamavata Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ karikarita ambami, Narɨ krunavundiŋ nɨmavamba maŋambamara, Jisas krunavundiŋ aŋga mɨŋɨmandɨ vata Got yɨhɨramami, vamba maŋambamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kandɨhɨvɨ hañɨnda kɨta Jisas nuŋandɨ sɨmbɨrasaraŋ ambami, Yi Jerusalem utɨnɨ, yaŋ Israelɨndu aru miku haŋɨnɨŋ, naŋga Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ, naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋɨndu kumañɨ tamɨmandɨyu. Kamatu kañɨnda sambɨ kavɨtɨn, yaŋ yɨvutatamɨtu kwɨmɨrɨman. Hara arɨkiŋgɨvɨ kɨta kwɨrɨ hañɨ aŋga yahamɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kamavahi Pita kandɨhamata kuyu indarɨta Jisasɨŋ tɨmbuta tɨvɨ hambu uta nuŋ ambahɨmuta ambami, Aru mɨŋga, manɨŋganzɨkwɨ. Naŋ kandɨ vana ha mayɨvurahɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kamavahi Jisas kimɨruramata Pitaŋ ambami, Satan yandɨ kutɨnɨmbu uhu. Na yandɨ kwɨmbɨ kivihɨrɨm andɨna. Na Gotɨndu indarɨmit mɨŋata maŋandɨna. Na krundu indarɨmit mɨŋata andɨnandɨhi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kamavata Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambami, Kru mumɨŋga yi naŋga payɨman vataŋgata, nuŋambi taŋguti mɨŋgum. Kamata yi pɨmɨ kavɨrɨman maña nu ndahara kavum. ");
INSERT INTO kqa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kru mumɨŋga kandɨhamata vana maŋandɨta nuŋandɨ kwɨrandɨ haŋandɨhinɨrɨmɨndaya tɨmutɨmutɨrɨmandɨ hama siŋgundɨrɨmandɨ. Hara kru mumɨŋga yambirɨm indarɨramata kwɨmɨrɨmandɨ hama sɨhaŋgɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kru mumɨŋga pɨrɨ nɨñɨndu muhɨmɨmuhɨm mɨŋɨmandɨ. Hara nuŋambi siŋgundɨti muhɨmɨmuhɨm kandɨhaŋɨnɨŋ sɨhanaŋga nuŋ maŋguramɨrɨmandɨyu. Naŋga nuŋandɨ kwɨrandɨ haŋandɨhin muhɨmɨmuhɨm kandɨhañɨ mut mamɨŋɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Krundu Ñɨŋi mɨŋga nuŋandɨ kutɨkara haŋɨnɨŋ naŋga nɨŋuvandu sɨña aruyɨ payɨmandɨ. Kamata kandɨhɨvɨ hañɨ krunavundi sɨhanaŋga muhɨmɨmuhɨm vana andɨndu haŋɨnɨŋ ŋgaharamarama nurɨŋ muhɨmɨmuhɨm ŋgurɨmandɨ. Avi vana andɨndu haŋɨnɨŋ avi hɨm ŋgurɨmandɨ. Ñamba vana andɨndu haŋɨnɨŋ ñamba hɨm ŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yi narɨŋ kandɨ ambin, kru taŋguramata kuyu nɨñɨndu muvɨra maŋgwɨmɨtutu, Krundu Ñɨŋi mɨŋgaŋ ŋgɨtu aru miku mɨŋga maña payɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Arɨkikwɨrɨ arɨkikwɨrɨ hɨvɨ uhi, Pita, Jems, naŋga nɨŋura Jonɨŋ Jisas tɨmbuta apu kɨmbandɨkatɨkayɨ yahuta nurɨŋambi kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kamata tɨhɨraramata kɨyɨhuhu Jisasɨndu kwɨrandɨ ha tɨvɨrata muvita yɨvurahi, nuŋandɨ kɨpumɨka ha ina tɨmɨrɨmañandɨmi. Kamatɨhi nuŋandɨ mɨkwɨrɨ haŋɨnɨŋ suñɨndɨta sɨña maña yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kamatɨhi Jisasɨndu sɨmbɨrasara haŋɨnɨŋ ŋgahu Moses naŋga Elaija yɨvurahata Jisas naŋga kuyundavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kamatɨhu Pita kandɨhamata ŋgata Jisasɨŋ ambami, Aru mɨŋga, nɨñɨ kɨtɨrɨŋ avindɨhi. Aria vɨna nda savanzava arɨkikwɨrɨ tararamahin. Mu nambirɨm, mu Mosesɨrɨm, naŋga mu Elaijarɨm, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita kuyundavarahihi kanzirɨsirɨ ihumukɨrɨ mu, sɨñanzɨkwɨsɨkwɨ ŋandi nurɨŋ kavɨramami. Kamatɨhi ihumukɨrɨ humba kandɨhañɨ kuyu samur muŋandɨhin ambami, Ñɨŋi nɨŋandɨhin yandɨ, nɨŋambirɨm mavɨndamamaŋgarata, nɨŋambirɨm kɨnzɨhɨnzɨtɨnɨ. Kamataharɨm nuŋandɨ kuyu indarɨmara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kamavahi sɨmbɨrasara arɨkikwɨrɨvat kuyu kandɨha indarɨhu nurɨŋ pɨŋitɨhi, tandamɨkwɨmɨkwɨta kɨpumɨka pɨrɨ vu tamahu mɨŋgumi. ");
INSERT INTO kqa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kamatɨhu Jisas arɨhañɨ pata nurɨŋ mɨŋahandatanda ambami, Pɨŋimanduta yahamɨramara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kamavahi tɨhɨrata yahuta kru arɨkimbatɨŋ maŋgamu. Jisasɨŋ ndaya ŋgamu. ");
INSERT INTO kqa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kamata apu ha mitata mɨŋgumɨŋgu Jisas nurɨŋ tɨkatɨka kuyu ŋguta ambami, Ŋgara vana nɨŋandɨhin kru mumɨŋgaŋ maŋambavarahandamara, ututa Krundu Ñɨŋi hama sava humbañɨ kɨta aŋga yahamɨram, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Jisasɨŋ kitɨhuta ambamu, Mumɨndɨhi tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ ambandu, Elaija wɨsa payɨmandɨ, vamba ambandu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kamavahu Jisas kɨmbɨ ambami, Ambandu kuyu haŋandɨhin kandɨ. Elaija wɨsa pata muhɨmɨmuhɨm mɨŋasɨrɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hara yi narɨŋ ambin, Elaija payɨhira kru nuŋ magŋamaŋgarandu. Kamataharɨm nurɨŋandɨ indarɨmitɨyɨ Elaijaŋ ñamba vana andɨndu. Harɨm sɨwɨmaña vanayɨ Krundu Ñɨŋi hamaŋ ñamba taŋgurɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambamu, Jon kukuyɨ mɨŋaŋgɨruhɨru hamarɨm ambi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas naŋga nuŋandɨ sɨmbɨrasara arɨkikwɨrɨvat uta krunavundi sambɨ kɨyɨmu hañɨ yɨvurahamu. Kamatɨhu kru mumɨŋga pata Jisas kɨyɨmi arɨhañɨ tandamɨkwɨmɨkwɨta ambami, ");
INSERT INTO kqa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aru mɨŋga, ñɨŋi yandɨ nɨŋandɨhin kwɨnɨkwɨnɨtɨhi nuŋandɨ kwɨrandɨ nɨ ñambatɨndi. Kamata sambɨ ñɨmbɨrɨ ahutuŋgɨyɨ mɨŋgundi, naŋga kukuyɨ ndahara mɨŋgundi. Harɨm ñɨŋi yandɨ nɨ sɨhiŋga. ");
INSERT INTO kqa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nandɨ sɨmbɨrasara nɨŋɨnɨŋ kɨyuyɨ mɨŋata payɨhin andɨhura avimandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kamavahi Jisas kɨmbɨ ambami, Krunavundi tɨhundu narɨ, narɨŋandɨ indarɨmaŋgaramaŋgara ha tɨkatɨkama. Naŋga narɨŋandɨ indarɨmit naŋga andɨndara vana haŋɨnɨŋ avima. Pamata ñɨmbɨrɨ narɨ naŋga kɨñɨŋgɨñɨ narɨŋandɨ pɨmɨ kavɨrɨman. Ñɨŋi kandɨha nɨñɨ mɨŋata pañɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kamatɨhi Jisas sundɨ ñamba haŋandɨhin ambahɨmuhi sarɨwayɨŋandi sundɨ ñamba ha ñɨŋi haŋandɨhin tɨhɨmitahi sɨkwɨ avindɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kamata muñɨmbɨrɨ nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Jisasɨŋ nuŋambi kɨyɨhihi pata nɨmavamba kitɨhumu, Pamatɨhi ara sundɨ ñamba kandɨhaŋandɨhin pɨŋguvarɨmɨndaŋ vata andɨharɨŋ manɨŋgandɨmi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Kamavahu nurɨŋ ambami, Narɨŋandɨ indarɨmaŋgaramaŋgara vana ha suksɨmbɨrɨ sɨkwɨ, harɨm mambɨŋguvarahara. Narɨŋ yi kandɨ ambin, narɨŋandɨ indarɨmaŋgaramaŋgara vana ha sahi mastet kɨrɨs maña kɨtindahara sundɨ ñamba ha pɨŋguvarahara. Hara narɨŋandɨ indarɨmaŋgaramaŋgara vana ha sahi mastetɨndu kɨrɨs ndahara mandaratɨvɨrandi. Harɨm sundɨ ñamba mambɨŋguvarahara. Narɨ apu nɨŋandɨhinɨrɨm yahamɨrata ndambu uhu vɨtɨra, uhi. Narɨŋandɨ indarɨmaŋgaramaŋgara vana kɨti muhɨmɨmuhɨm vana andɨhara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ pɨrɨvɨsa Galili tɨhɨruta nurɨŋ nɨmavamba ambami, Krundu Ñɨŋi mɨŋgaŋ krundu kumaŋgɨmbañɨ tamata, nuŋ yɨvutatamɨrɨmandɨyu. Kamatu arɨkiŋgɨvɨ kɨta kwɨrɨ hañɨ aŋga yahamɨrɨmandɨ, vami. Kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kuyu kandɨha indarɨhu nurɨŋandɨ mavɨha pɨmɨtɨmaŋgarami. ");
INSERT INTO kqa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kamata Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ uta pɨhu aru Kaperneam yɨvurahata kɨyɨmu. Kamatɨhu Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndurɨm vata kru tɨmbahɨrɨs mɨŋandu haŋɨnɨŋ payɨmu. Pata Pitaŋ nɨmavamba kitɨhumu, Narɨŋandɨ ahusɨki ndama Gotɨŋ kɨrañɨŋguhu tavɨ nɨŋandɨhin mɨŋasɨrɨvasɨrɨvarɨm tɨmbahɨrɨs ŋguhi vaha, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kamavahu Pita ambami, Ara, ŋguhi, vamba ambami. Kamavata Pita tavɨyɨ indɨhuta maŋguyundavarahihi Jisas nuŋ nɨmavamba kitɨhumi, Saimon na pamata indarɨna. Pɨrɨ nɨñɨndu aru miku haŋɨnɨŋ muhɨmɨmuhɨm sɨmbɨrayɨndu tɨmbahɨrɨs mɨŋandu. Kandɨhaŋɨnɨŋ tɨmbahɨrɨs ninɨndu taya mɨŋandu. Nurɨŋandɨ krunzapandu mɨŋandu, mana muŋɨnɨŋɨndu taya mɨŋandu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kamavahi Pita yahata ambami, Kru muŋɨnɨŋɨndu taya mɨŋandu, vami. Kamavahi Jisas ambami, Kamataharɨm nurɨŋandɨ krunzapandu tɨmbahɨrɨs mamɨŋandu. ");
INSERT INTO kqa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hara kamatɨrɨŋ arɨŋ ambɨtuma. Kamataharɨm uta indu ndañɨ atɨŋgi kavara. Kamata asa kimaŋgima pɨŋgɨrɨmana haŋandɨhin nuŋandɨ mɨka ha mɨŋativata tɨmbahɨrɨs muŋandɨhin ŋgɨna kɨyɨmandɨ. Tɨmbahɨrɨs kandɨha mɨŋata nanaŋga arɨŋambirɨm tama, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kandɨhɨrɨvɨ hañɨ Jisasɨndu sɨmbɨrasara haŋɨnɨŋ pata Jisasɨŋ nɨmavamba kitɨhumu, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨ hañɨ, kru ninɨndaya ñɨmbi aru naŋga mɨŋga kɨyɨmandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kamavahu Jisas ñɨŋi muŋandi uraramahi payɨhi nurɨ kɨyɨmu pɨrɨŋ hañɨ taŋguramaramamata ");
INSERT INTO kqa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ambami, Yi narɨŋ kandɨ ambin, narɨ mavɨ maŋgimɨruta ñɨŋisɨrambɨ kɨndu maña maŋgɨyɨmandɨraŋa, Gotɨndu tɨwɨyɨ maŋgɨyɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kru mumɨŋga nuŋambi taŋguti mɨŋguti ñɨŋi nɨma maña yɨvurahɨmandɨ hamanda, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨ hañɨ ñɨmbi aru sɨkwɨ naŋga mɨŋga kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ara kru mumɨŋga yaŋɨrɨm indarɨramata ñɨŋi sukɨyɨpu nɨmatarɨm kɨnzɨhɨnzɨtɨrɨmandɨ hama, yaŋɨrɨm kɨnzɨhɨnzɨtɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kamata Jisas sɨhinda ambami, Kru mumɨŋga andɨti ñɨŋi mu yambirɨm indarɨmaŋgarandi ŋandi ñamba vanayɨ mɨŋgata yɨvɨti, kandɨhamaŋ avinda tɨmba muŋgɨ aru mɨŋata nuŋandɨ pɨŋgwɨ hañɨ sɨmahata kavarɨtu añakɨŋguku tuŋgñɨ mɨŋguta kɨmum. ");
INSERT INTO kqa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kandɨ, kru pɨrɨ nɨñɨndu, krunavundi muvɨraŋ pɨŋgɨrɨvɨŋgɨrɨramahuhu ñamba vana andɨndu. Krunavundi ñamba vana andɨndu haŋɨnɨŋ pɨmɨ kavɨrɨmandɨyu. Hara kru pɨŋgɨrɨvɨŋgɨrɨramandu haŋɨnɨŋ pɨmɨ aru kavɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nandɨ kuma vaha mana tanda vaha pɨŋgɨrɨvɨŋgɨrɨramɨti ñamba vana andɨtaŋgata pɨtɨta kavarɨna umɨ. Kamata avinda kuma timu naŋga tanda tamu naŋgandaya kɨta sɨhaŋgɨyɨmana. Nandɨ kuma arɨkita naŋga tanda arɨkita kɨtunda naŋ Got ahu maŋgɨmuhɨmu tuta sɨhaŋgɨndi hañɨ kavarɨti unamandɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nandɨ tamɨŋga timu pɨŋgɨrɨvɨŋgɨrɨramɨti ñamba vana andɨtaŋgata, tamɨŋga kandɨha kumbɨrata kavarɨna umɨ. Kamata tamɨŋga timu naŋgandaya kɨtanda sɨhaŋgɨyɨmana. Nandɨ tamɨŋga arɨkita kɨtinda naŋ Got ahutuvarandi helɨyɨ kavarɨti unamandɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Narɨ indarɨmara. Ñɨŋi sukɨsɨrambɨ nɨñɨndu munɨrɨm nda, ñɨmbi manɨman saŋ vɨtɨrama. Narɨŋ yinda ambin, Gotɨndu pɨhuyɨ, ñɨŋi kanɨŋɨnɨŋɨndu kutɨkara haŋɨnɨŋ, Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hama naŋga sɨhaŋgɨndu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jisas sɨhinda ambami, Narɨ pamata indarɨra. Kru mumɨŋgandu sipsip 100 kɨti, mɨŋgɨyataya yɨwarɨti puhɨrahi vaha mana mambaha puhɨrahi. Manɨŋga, 99 sipsip haŋɨnɨŋ mitɨti apuvu kɨtuhɨtu, uta sipsip mɨŋgɨyataya yɨwarahi haŋandɨhin puhɨrahi. ");
INSERT INTO kqa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yi narɨŋ kandɨ ambin, sipsip haŋandɨhin aŋga mɨŋata kɨnzɨhɨnzɨtɨhi. 99 sipsip manziŋgundɨhu haŋɨnɨŋɨrɨm kɨnzɨhɨnzɨtɨmaŋgarahi. Hara sipsip mɨŋgɨyataya siŋgundɨmi haŋandɨhin aŋga mɨŋata, kɨnzɨhɨnzɨtɨmaŋgarahi. ");
INSERT INTO kqa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kamata maña narɨŋandɨ Nava nuŋandɨ pɨhuyɨ kɨyɨ hama, ñɨŋi suksɨrambɨ kanɨñɨndu muŋandɨhin yɨwarɨtima vata yakwɨrɨvarandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas sɨhinda ambami, Krunavundi yandɨ ñiŋgiñɨndu muvat naŋ ñamba vana andɨti, uta nuŋ ŋga. Kamata arɨkimbat taya kɨyɨmandɨra hɨrɨvɨyɨ ñamba vana nuŋandɨ haŋɨnɨŋɨrɨm mɨŋasɨrɨvanzɨrɨva ambavara. Kamatɨna nandɨ kuyu indarɨtiŋgata nuŋ aŋga mɨŋɨmana. ");
INSERT INTO kqa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ara nandɨ kuyu maŋindarɨtiŋgata, sɨhinda uta mɨŋgɨyavatɨŋ vaha mana arɨkimbatɨŋ vaha tɨmbuta uhu. Kamatɨna nandɨ kuyu ha arɨkimbat vaha mana arɨkikwɨrɨvat vaha tɨkatɨkatɨramandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kamatɨna nurɨŋandɨ kuyu maŋindarɨtiŋgata, uta krunavundi Jisasɨrɨm indarɨmaŋgarandu ŋɨnɨŋ amba. Kamatɨna krunavundi Jisasɨrɨm indarɨmaŋgarandu haŋɨnɨŋ ndu kuyu ndahara maŋindarɨtiŋgata, nuŋ Gotɨŋ maŋgaha mɨŋga, naŋga kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa mɨŋgaŋ ŋgɨmañandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yi narɨŋ kandɨ ambin, muhɨmɨmuhɨm vana pɨrɨ nɨñɨ kahañɨrɨmandɨraŋa, Got ndahara nuŋandɨ pɨhuyɨ kahañɨrɨmandɨ. Ara muhɨmɨmuhɨm vana pɨrɨ nɨñɨ kuyɨvɨrɨmandɨraŋa, Got ndahara nuŋandɨ pɨhuyɨ kuyɨvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Narɨŋ yi sɨhinda ambin, pɨrɨ nɨñɨ narɨ arɨkimbat muhɨmɨrɨm nda mavɨ mɨnzayɨ tamata, yandɨ Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hama naŋga kuyundavarɨtɨra narɨŋɨrɨm ŋgurɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Arɨkimbat vaha mana arɨkikwɨrɨvat vaha pata yandɨ ñɨmbiyɨ tɨwɨrɨmandɨyu ha, yi yambi nurɨŋandɨ ñiŋgiñɨ kɨyɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kandɨhɨvɨ hañɨ Pita Jisas kɨyɨmiyɨ pata nɨmavamba kitɨhumi, Aru mɨŋga, krunavundi nandɨ ñiŋgiñɨndu muvat yaŋ ñamba vana andɨti kuŋgɨ kuyɨvahin, sɨhinda muñɨmbɨrɨ andɨti kuŋgɨ kuyɨvahin, kamatataya ututa kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata ñɨmbɨrɨ sɨkwɨ kuŋgɨ kuyɨvata, ambɨhañɨ vaha vahin. Mana pamata ñɨmbɨrɨ sɨkwɨ nuŋandɨ ñamba vana ha kuŋgɨ kuyɨvahin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kamavahi Jisas nuŋ ambami, Yi naŋ ambin, naŋ kru ñamba vana kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata ñɨmbɨrɨ andɨti nuŋandɨ kuŋgɨ kuyɨva. Naŋ ñamba vana andɨtiti ndahara imutamut nuŋandɨ ñamba vanandu kuŋgɨ kuyɨva. ");
INSERT INTO kqa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Indarɨmara, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha aru miku maña, sɨmbɨrasara nuŋandɨ tɨmbahɨrɨs mɨŋamu haŋandɨhin nu naŋga kuyu mɨŋasɨrɨvasɨrɨvarɨm pirɨ kɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kamata tɨmbahɨrɨs mɨŋasɨrɨvasɨrɨva sɨmbɨra mɨŋahi sɨmbɨrasara muhamaŋ nu kɨyɨmiyɨ tɨmbuta payɨmu. Kandɨhama tɨmbahɨrɨs 10 milion mɨŋami. ");
INSERT INTO kqa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hara tɨmbahɨrɨs mɨŋami hañɨndu kɨmbɨ ŋguhu ŋandi maŋgɨyɨmi. Kamataharɨm aru miku hama ambami, Kru kanɨmaŋ, nɨmburiŋ, naŋga ñɨŋisɨmɨŋ naŋga nuŋandɨ muhɨmɨmuhɨm sɨhanaŋga ŋgutɨra kru muŋɨnɨŋ mut mɨŋamu. Kamatu sɨmbɨrasara saŋɨŋɨnɨŋ yɨvurahɨtu, tɨmbahɨrɨs ha mɨŋata yaŋ ŋgumara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kamavahi sɨmbɨrasara saŋ hama aru miku hamandu tandanzapa hañɨ tanda mɨkwɨmɨkwɨnɨta nɨmavami, Yaŋ sɨhiŋgata tavɨrahanda. Tɨmbahɨrɨs nandɨ mɨŋamin haŋandɨhin sɨhanaŋga kɨmbɨ ŋgurɨman huŋɨndɨhi, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kamavahi sɨmbɨrasara saŋ hamandu aru miku hamaŋ mavɨndɨhi nuŋ kuŋgɨ kuyɨvami. Kamata tɨmbahɨrɨs mɨŋami haŋandɨhinɨrɨm ndahara kɨndam, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kamatɨhi sɨmbɨrasara saŋ hama tapɨrañɨ indɨhuta sɨmbɨra kɨhɨrɨ mɨŋandu mɨŋga nuŋandɨ 10 tɨmbahɨrɨs taya mɨŋami mɨŋgaŋ ŋgami. Kamata sɨkwɨtaya nuŋ pɨŋgwɨ nɨkinɨki mɨŋavandata ambami, Yandɨ tɨmbahɨrɨs mɨŋamana ha tɨhunzaŋɨnzaŋ ŋgu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kamatɨhi sɨmbɨra kɨhɨrɨ mɨŋandu hama nuŋandɨ tandanzapa hañɨ tanda mɨkwɨmɨkwɨnɨta ambami, Nandɨ tɨmbahɨrɨs mɨŋamin ha ŋgurɨman huŋɨndɨhi yaŋ sɨhiŋgata tavɨrahanda, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hara sɨmbɨrasara saŋ hama yakwɨrɨvarami. Uta sɨmbɨra kɨhɨrɨ mɨŋandu hamaŋ kru ñamba vana andɨhu tamandu upɨyɨ tamami. Kamatɨhi kandɨhañɨ kɨñɨŋgɨñɨ tɨmbahɨrɨs mɨŋami ha mɨŋasɨrɨvami. ");
INSERT INTO kqa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kandɨhamata musa andɨhi kru sɨmbɨra kɨhɨrɨ mɨŋandu haŋɨnɨŋ ŋgahu nurɨŋandɨ mavɨmbu avi mandɨmi. Kamatɨhi uta nurɨŋandɨ aru miku hamaŋ muhɨmɨmuhɨm vana sɨmbɨrasara saŋ hama andɨmi haŋɨnɨŋɨrɨm ambavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kamatɨhu aru hama sɨmbɨrasara saŋ hamaŋ uraramahi payɨhi ambami, Na sɨmbɨrasara saŋ ñamba mɨŋga. Na yambirɨm mavɨmavɨ kuyu ambahana tɨmbahɨrɨs yandɨ mɨŋamana haŋandɨhinɨrɨm kɨndam vata, naŋ kuŋgɨ kuyɨvasɨn. ");
INSERT INTO kqa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yi naŋ sɨhisɨhitɨsɨn. Hara mumɨndɨhi sɨmbɨra kɨhɨrɨ mɨŋandara ndamaŋ sɨhisɨhi mandɨsɨna, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kamavata nuŋandɨ aru miku hama sɨmbɨrasara saŋ hamarɨm kɨtɨrɨ kɨta ambami, Kru kañɨnda ŋguhu haŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨman. Kamatɨn kandɨhañɨ kɨñɨŋgɨñɨ tɨmbahɨrɨs mɨŋami haŋɨnɨŋ sɨhanaŋga aŋga ŋgurɨmandɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sɨwɨmaña ŋandi, muŋɨnɨŋɨndu ñamba vana kuŋgɨ maŋguyɨvɨrɨmandɨra ha, Yavandak nuŋandɨ pɨhuyɨ kɨyɨ hama narɨŋandɨ kuŋgɨ ndahara maŋguyɨvɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas kuyu kanɨnɨŋɨnɨŋ ambavarata mɨtuta, pɨrɨvɨsa Galili mitata pɨrɨvɨsa Judiarɨm kuku Jordan ndambukari indɨhumi. ");
INSERT INTO kqa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kamatɨhi krunavundi sambɨ nu naŋga umu. Kamatɨhu kandɨhambu kandi naŋga haŋɨnɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kamatɨhi Farisi, Jisas andɨti ŋgɨm vata payɨmu. Harɨm Jisasɨŋ nɨmavamba kitɨhumu, Na pamata indarɨna. Kru mumɨŋga nɨmburiŋ saŋɨnaŋga pɨŋguvarahi. Kru kandɨhama arɨŋandɨ tɨkatɨka kuyu mɨŋahandandi vaha, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kamavahu Jisas kɨmbɨ nɨmavami, Narɨ Gotɨndu aŋgwɨmɨkɨyɨ kuyu kɨndi haŋandɨhin ŋgatɨŋgɨruta mambaha ŋgandara. Kuyu kandɨha nɨmavamba ambami, Kuha Got muhɨmɨmuhɨm tamata krunavundiŋ musa mɨŋami. Kamata andɨhi kru naŋga navundi yɨvurahamu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kamavata sɨhinda Got ambami, Harɨm kru hama yahata nɨŋum nɨŋuvaŋ mitata nɨmburi naŋga kɨhɨrɨ kɨndu. Kamata arɨkimbat kwɨrandɨmbat mɨŋgɨyataya yɨvurahandu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Got ambami, harɨm arɨkimbat kɨtɨŋgɨtɨ maŋgɨndu. Kwɨrandɨmbat mɨŋgɨyataya maña kɨndu. Harɨm Got kahañami hɨm haŋandɨhin kru mandavɨham, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kamavahi Farisi haŋɨnɨŋ Jisasɨŋ ambamu, Kamatahara mumɨndɨhi Moses arɨŋ tɨkatɨka kuyu ŋguta ambami, Kru aŋgwɨmɨkɨyɨ yɨhimbɨvɨrata navundiŋ ŋguta pɨŋguvarɨti umɨ, vamba ambami, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kamavahu Jisas nurɨŋ ambami, Narɨ tamahumbɨrɨ ŋɨnɨŋ, harɨm Moses ŋgatara andɨhi navundi pɨŋguvarandara. Hara kimaŋgimañɨ kamata vana maŋgɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Narɨŋ yi ambin, kru mumɨŋga, nɨmburi kru mamɨŋavɨŋgɨrɨtira saŋɨnaŋga pɨŋguvarahi. Kamata navundi mu urahi. Kru kandɨhama nuŋambi navundi mɨŋavɨŋgɨrɨvɨŋgɨrɨ vana andɨhi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kamavahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kuyu kandɨha indarɨta Jisasɨŋ nɨmavamba ambamu, Kru kandɨhamata vana mɨŋahandɨrɨman vataŋgata, kɨndamɨndɨhi navundi maŋuram, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kamavahu Jisas ambami, Kru sɨhanaŋga kuyu kanɨŋandɨhin mamɨŋandu. Got kru mɨnzavatɨvatɨŋ ndaya tɨkatɨka ŋguhi navundi maŋurandu. ");
INSERT INTO kqa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Narɨ indarɨmara. Kru muvitamuvita ŋɨnɨŋ kɨta navundi maŋurandu. Muvɨraŋ nɨŋumɨŋgati kavuhu nurɨŋandɨ kwɨrandɨ ha ñambatɨmi. Muvɨraŋ kru kwɨrandɨmbɨsa tavɨhamu harɨm ñɨŋi maŋgavuhu. Muvɨra Gotɨndu tɨwɨyɨ kɨyɨhɨyɨndu sɨmbɨrarɨm indarɨramata nurɨŋambi tɨkatɨka kuyu sɨmahata navundi maŋurandu. Harɨm kru kuyu kanɨŋandɨhin mɨŋɨman vɨrɨmandɨ hama mɨŋam, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kandɨhɨvɨ hañɨ krunavundi ñɨŋi sukɨsɨrambɨ haŋɨnɨŋ tɨmbuta Jisas kɨyɨmiyɨ payɨmu. Nuŋandɨ kuma ha nurɨŋandɨ kwɨrandɨ hañɨ tamata, Got naŋga kuyundavarɨti, nurɨŋ ŋguramam vata andɨmu. Kamatɨhura nuŋandɨ sɨmbɨrasara haŋɨnɨŋ krunavundi kandɨhaŋɨnɨŋ ambahɨmumu. ");
INSERT INTO kqa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kamatɨhu Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambami, Mitɨra ñɨŋi haŋɨnɨŋ yi kɨnɨ nɨñɨ payɨmu, nurɨŋ karikari mandɨmara. Krunavundi Gotɨndu tɨwɨyɨ kɨyɨmɨndaŋ vataŋgata, ñɨŋi nɨŋɨnɨŋ maña kɨyɨmu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kamavata kuma nuŋandɨha ñɨŋi haŋɨnɨŋɨndu miku hañɨ tamami. Kamata kɨyɨhandata kandɨ upɨ haŋu mitata umi. ");
INSERT INTO kqa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kamatɨhi kru mumɨŋga Jisas kɨyɨmiyɨ pata ambami, Ahusɨki, yi avi vana pamata ŋandi andɨta sɨhaŋgɨyɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kamavahi Jisas nuŋ ambami, Mumɨndɨhi na yaŋ avi vanarɨm kitɨhuna. Mɨnzamɨnza Got taya avi. Hara sɨhaŋgɨyɨman vataŋgata, Gotɨndu tɨkatɨka kuyu taya mɨŋahandamaŋgara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kamavahi kru kandɨhama Jisasɨŋ nɨmavamba kitɨhumi, Tɨkatɨka kuyu pamatarɨm ambana, vami. Kamavahi Jisas ambami, Tɨkatɨka kuyu kandɨhaŋɨnɨŋɨndu kuyu nɨmata kɨndi. Krunavundiŋ mayɨvutatama. Kru na, navundi mamɨŋavɨŋgɨrɨ, naŋga navundi na, kru mamɨŋavɨŋgɨrɨ. Kipa mamɨŋa, kru muŋɨnɨŋ kuyusɨhɨrata saŋɨnaŋga maŋgatɨŋguru. ");
INSERT INTO kqa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Namɨnavandu tɨwɨyɨ kɨñɨŋgɨñɨ nurɨŋandɨ kuyu mɨŋahanda. Kamata nambi nandɨ kwɨrandɨrɨm mavɨndamandana maña, sɨhanaŋga kruŋ ndahara mɨŋata mavɨñɨ tama, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kamavahi kru ñaŋɨra hama ambami, Yi sɨhanaŋga tɨkatɨka kuyu kanɨŋɨnɨŋ mɨŋahandandin. Hara yi pamata hɨmɨrɨmɨnzɨkwɨ kɨrɨvɨtɨn, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kamavahi Jisas ambami, Avinzɨkwɨ mɨŋga kɨyɨman vataŋgata, uta nandɨ muhɨmɨmuhɨm sɨhanaŋga ŋguna mut mɨŋamu. Kamatu tɨmbahɨrɨs ha mɨŋatuta muhɨmɨmuhɨm manɨman saŋ haŋɨnɨŋ ŋgu. Kamatɨrɨmana handa Gotɨndu pɨhuyɨndu avihɨmɨŋgɨm mɨŋɨmana. Kamata yi naŋga pañɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kru ñaŋɨra hama muhɨmɨmuhɨm sambɨ sɨkwɨ naŋga mɨŋga. Harɨm kuyu kandɨha indarɨhi nuŋandɨ mavɨmbu pɨmɨtɨhi umi. ");
INSERT INTO kqa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kamatɨhi Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambami, Yi narɨŋ kandɨ ambin, kru tɨmbahɨrɨsɨndu arɨku mɨŋga Gotɨndu tɨwɨyɨ kɨyɨman vata avɨrɨ tamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yi narɨŋ sɨhinda ambin, kamel mɨkwɨrɨ sɨvirɨsɨvirɨ sɨki humbañɨ indɨwɨrɨm, kru tɨmbahɨrɨsɨndu arɨku haŋɨnɨŋ Gotɨndu tɨwɨyɨ kɨyɨhɨyɨrɨm avɨrɨtamandu maña avɨrɨ mandamahi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kuyu kanɨŋandɨhin indarɨhu mavɨyahavarami. Kamata ambamu, Ara nindaya sɨhaŋgɨyɨmandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kamavahu Jisas nurɨŋ tɨhɨrata ambami, Kru maŋandɨhu. Hara Got muhɨmɨmuhɨm vana andɨhi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kamavahi Pita kɨmbɨ ambami, Ŋgana, ara arɨŋandɨ muhɨmɨmuhɨm mitata nanaŋga kɨndandarɨŋ. Harɨm ara mum mɨŋɨmɨndaŋ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kamavahi Jisas ambami, Yi narɨŋ kandɨ ambin, muhɨmɨmuhɨm kɨhi yɨvurahɨmandɨ hɨvɨyɨ, Krundu Ñɨŋi mɨŋga aru ñɨmbi naŋgandɨta aru miku ndu mɨnzɨmɨnzɨ maka nuŋandɨ hañɨ mɨnzɨrɨmandɨ. Kamati yi naŋga kɨhɨrɨ kɨndandara narɨndahara, aru miku ndu mɨnzɨmɨnzɨ maka kumanzɨpi timutamu, tanda timundu arɨkinzɨpi tɨŋgɨruramatayɨ mɨnzɨrɨmandɨra. Kamata Israel hatindu krunzapa kumanzɨpi timutamu, tanda timundu arɨkinzɨpi taya tɨŋgɨruramata haŋɨnɨŋ karatamɨrɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Naŋga krunavundi sɨhanaŋga yambirɨm indarɨta, nurɨŋandɨ tavɨ, nɨŋusinavaŋ, nɨŋuranavaŋ, nɨŋurɨmaŋgatiŋ, ñɨŋisɨmɨŋ, nɨŋumɨnɨŋuvaŋ, naŋga nurɨŋandɨ kɨva mitamu haŋɨnɨŋ sɨhinda muhɨmɨmuhɨm 100 mɨŋɨmandɨyu. Kamata sɨhaŋgɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hara kru kasirambu uyu haŋɨnɨŋ sɨhɨndɨvu sɨkwɨ payɨmandɨyu. Kamatu kru sɨhɨndɨvu payu haŋɨnɨŋ kasirambu urɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas sɨhinda ambami, Yi kuyu nɨ kru kasiram vu kɨyɨmandɨyu ŋɨnɨŋɨrɨm ambin. Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha kru pɨrɨvɨsa nɨŋuva mɨŋga maña. Kɨvɨsɨhu nda kruŋ tɨmbuhavuta patɨn yandɨ wain kɨva nɨñɨ sɨmbɨra mɨŋamu vata umi. ");
INSERT INTO kqa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kamata nurɨ naŋga kuyu sɨmahata ambami, Sɨmbɨra mɨŋɨtɨra musi hɨvɨndu tɨmbahɨrɨs kumba naŋganaŋga kɨrɨs narɨŋ ŋgurɨman, vamba ambami. Kamata sɨmbɨhi uta wain kɨva nuŋandɨ hañɨ sɨmbɨra mɨŋamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kamata kɨyɨhandata 9 kilok vɨrañɨ aru hama sɨhinda umi. Kamata tɨhɨrutɨhɨru upɨ hañɨ ŋgahi kru muvɨra saŋ taŋguvatata kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kamatɨhu ambami, Narɨndahara uta wain kɨvayɨ sɨmbɨra mɨŋamara. Kamatɨra sɨmbɨra mɨŋɨmandɨravu ŋgaharamata narɨŋ tɨmbahɨrɨs tɨtɨyɨ ŋgurɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kamavahi umu. Kamata ina mɨrɨyɨ kɨyɨhihi, naŋga ina mɨŋgurɨm saŋgindaŋgumi hɨrɨvɨyɨ aru hama sɨhinda aŋga uta sɨwɨmaña musa nda andɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kamata kɨvɨtiti 5 kilok tɨrɨmɨndɨhi sɨhinda uta kru muvɨraŋ ŋgahi tɨhɨrutɨhɨru upɨ hañɨ taŋguvatata kɨyɨhu ambami, Narɨ mumɨndɨhi musi hɨvɨ narɨ nɨñɨndaya saŋ taŋguvatata kɨyɨhara kɨvɨtiti, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kamavahi ambamu, Arɨŋ kru mumɨŋga sɨmbɨra maŋguyɨ, vamba ambamu. Kamavahu ambami, Narɨndahara uta yandɨ wain kɨvayɨ sɨmbɨra mɨŋamara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kamata kɨvɨtititɨhi, nuŋandɨ sɨmbɨra mɨŋahuhu karatamandi hamaŋ ambami, Sɨmbɨrasara haŋɨnɨŋ uraramɨna patu tɨmbahɨrɨs ŋgu. Sɨhɨndɨvu pata sɨmbɨra mɨŋayu haŋɨnɨŋ wɨsa ŋguta, kasiramɨyɨ pata mɨŋayu haŋɨnɨŋ ŋgu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kamavahi kru kɨvɨtiti 5 kilok pata sɨmbɨra mɨŋamu haŋɨnɨŋ kumba naŋganaŋga kɨrɨs mɨŋamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kamatɨhu kru sɨmbɨra nurɨŋgwɨsa mɨŋamu haŋɨnɨŋ pata tɨmbahɨrɨs sambɨ vaha mɨŋɨmɨndaŋ vamba indarɨmu. Hara nurɨndahara kumba naŋganaŋga kɨrɨs mɨŋamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Kamata tɨmbahɨrɨs mɨŋamu hambu ŋgata kɨva nɨŋuva hama naŋga kuyu mɨŋgumu. Kamata ambamu, Kru ndaŋɨnɨŋ sɨhɨndɨvu pata mɨŋgɨya hɨrɨvɨ taya sɨmbɨra mɨŋayu ndaŋɨnɨŋ tɨmbahɨrɨs arɨŋ ŋguna maña nurɨŋ ŋguna. Ara kɨvɨsuŋ nda kɨta sɨmbɨra tɨkatɨka mɨŋaharɨŋ arɨŋ ina kɨrahɨmuhi pata kɨvɨtititɨ, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kamavahu kɨva nɨŋuva hama kuyu kandɨha indarɨta sɨmbɨrasara muhamaŋ ambami, Yambɨha, yi naŋ ñamba vana maŋandɨn. Nanaŋga, tɨmbahɨrɨs kumba naŋga kɨrɨsɨrɨm kuyu sɨmaharɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nandɨ tɨmbahɨrɨs nɨ mɨŋata uhu. Yi yambi pirɨtamata naŋ tɨmbahɨrɨs ŋgwin maña, sɨhɨndɨvu sɨkwɨ payɨ ndamaŋ ndahara tɨmbahɨrɨs sɨwɨmañanda ŋgwin. ");
INSERT INTO kqa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nɨŋandɨhin yandɨ sɨmbɨra. Harɨm yandɨ indarɨmitɨyɨ tɨmbahɨrɨs yandɨ nɨ mambaha tɨŋgɨruhin. Yi nurɨŋ avi musa andɨhin yambirɨm mumɨrɨm kɨtɨrɨ kɨna, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kamata Jisas ambami. Kamata maña, kru sɨhɨndɨvu sɨkwɨ kɨndu haŋɨnɨŋ kasirambu patu, kasirambu kɨndu haŋɨnɨŋ sɨhɨndɨvu sɨkwɨ kɨyɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalemɨrɨm umi. Kamata nuŋandɨ 12 sɨmbɨrasara haŋɨnɨŋ tɨmbuta muvu umi. Kamata uhuhu kwɨbɨ hinɨŋgin nurɨŋ ambami, ");
INSERT INTO kqa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Narɨ indarɨmara. Musi ara Jerusalem yawɨmɨndaŋ. Kamatɨrɨŋ Krundu Ñɨŋiŋ Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨmandɨyu. Kamata nuŋ ŋgatɨŋgɨruta yɨvutatamatamarɨm kuyu kahañɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kamata krunzapa muŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨmandɨyu. Kamatu nuŋ kandɨhaŋɨnɨŋ ambasuvata pɨŋgɨrawɨsɨta, ahuandɨñɨ yɨvuwɨrɨmbɨmandɨyu. Kamatu arɨkiŋgɨvɨ kɨta kwɨrɨ hañɨ aŋga yahamɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kɨyɨhandata, Sebedindu ñɨŋisɨm arɨkimbat, naŋga nɨŋum Jisas kɨyɨmi payɨmu. Kamata nɨŋum tanda mɨkwɨmɨkwɨnɨta Jisasɨŋ ambami, Naŋ muhɨmɨrɨm kitɨwɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kamatɨhi Jisas nuŋ nɨmavamba kitɨhumi, Na muhɨmɨrɨm pirɨkɨna, vami. Kamavahi navundi haŋambɨ Jisasɨŋ ambami, Na aru miku yɨvurahata, yandɨ ñɨŋi arɨkimbatɨŋ ambɨna, mu nɨma nandɨ kuma kandɨ sambavu mɨnzɨti, mu nɨma nandɨ kuma kakayɨ sambavu mɨnzɨm, vata pirɨkɨnɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kamavahi Jisas kuyu kandɨha indarɨta ambami, Kitɨhura vana nɨŋandihindu sapa ha maŋgamaŋgarandara. Narɨ arɨkimbat, kuku kuvɨrahuvɨra vuŋgɨ yi kuvɨrɨman hañɨ narɨ kuvɨrɨmandɨra vaha, vami. Kamavahi arɨkimbat nuŋ ambamu, Ara andɨharɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kamavahu Jisas arɨkimbatɨŋ ambami, Narɨ yandɨ kuku kuvɨrahuvɨra vuŋgɨ hañɨ kuvɨrɨmandɨra. Hara yɨhɨramahi ninɨmbaha taya kandɨ sambavu mɨnzɨti, ninɨmbaha taya kakayɨ sambavu mɨnzɨmɨnzɨ sɨmbɨra nɨŋandɨhin yandɨma. Mɨnzɨmɨnzɨ maka kandɨhaŋɨnɨŋ krundu, yandɨ Yavandak sɨwɨtamami ŋɨnɨŋ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kamatɨhu Jisasɨndu 10 sɨmbɨrasara haŋɨnɨŋ nɨŋusi nɨŋura kandɨhamatɨmu kuyu ha indarɨta, arɨkimbatɨrɨm kɨpuhɨputɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kamata Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ uraramahi payɨhu ambami, Narɨ ŋgandara. Aru miku muyɨndu haŋɨnɨŋ nurɨŋandɨ krunzaparɨm arɨŋandɨ kuyu taya indarɨmu vata tɨkatɨkatmaŋgarandu. Naŋga nurɨŋandɨ kru aru haŋɨnɨŋ, krunavundi nurɨŋandɨ kuyu sɨhanaŋga mɨŋahandamu vata, tuvɨrandu. ");
INSERT INTO kqa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hara kandɨhamata vana ha narɨ naŋga maŋgɨyɨm. Narɨŋandɨ ñiŋgiñɨndu kru muvat aru mɨŋga kɨyɨman vɨrɨmandɨ hama, narɨŋandɨ sɨmbɨrakara mɨŋga kɨyɨm. ");
INSERT INTO kqa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kru mikuyɨ kɨyɨman vɨrɨmandɨ hama, narɨŋandɨ sɨmbɨrakara saŋ mɨŋga kɨyɨm. ");
INSERT INTO kqa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kamata maña Krundu Ñɨŋi hama krunavundi nɨŋambirɨm sɨmbɨra mɨŋamu vata mambayɨmi. Sɨmbɨra mɨŋata nuŋandɨ kwɨrandɨ ha nuŋambi ŋguta kɨmuta krunavundi sambɨ mut mɨŋɨtɨnɨ vata payɨmi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ pɨhu aru Jeriko mitata umu. Kamatɨhu krunavundi sambɨ sɨkwɨ nurɨ naŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kamatɨhu kru arɨkimbat kwɨmbɨ tɨvɨ hañɨ mɨnzɨta kɨyɨmu. Arɨkimbat kandɨhaŋɨnɨŋ tamɨŋga ñumi ŋɨnɨŋ. Harɨm Jisas payɨ vahu indarɨta kuyu kɨmbañɨ patɨvat ambamu, Aru mɨŋga na Devit Nɨŋuñɨŋgi. Na arɨŋ sɨhiŋga, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kamavahu krunavundi indarɨta arɨkimbatɨŋ ambahɨmuta ambamu, Mɨka narɨŋandɨha satimɨmara, vamu. Kamavahura arɨkimbat sɨhinda sɨhinda kuyu kɨmbañɨ ambamu, Aru mɨŋga na Devit Nɨŋuñɨŋgi, na arɨŋ sɨhiŋga, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kamavahu Jisas taŋguramata arɨkimbatɨŋ ambami, Yi narɨŋ pamatɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kamavahi arɨkimbat kɨmbɨ ambamu, Aru mɨŋga, arɨŋandɨ tamɨŋga nɨŋɨnɨŋ mɨŋavɨhɨrɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kamavahu Jisasɨŋ arɨkimbatɨrɨm mavɨndɨmi. Kamata kumandamata arɨkimbatɨndu tamɨŋga hañɨ tɨmbusarahi, sarɨwayɨ ŋandiŋ tamɨŋga nurɨŋandɨ haŋɨnɨŋ avindɨhi tɨhɨrañamu. Kamatɨhi arɨkimbat Jisas naŋga umu. ");
INSERT INTO kqa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas naŋga nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Jerusalem yɨvurahɨrɨmɨndɨhu arɨñɨndɨmi. Kamata Apu Oliv tamayɨ yahuta pɨhu Betfage yɨvurahamu. Kamata Jisas sɨmbɨrasara arɨkimbatɨŋ sɨmbɨta nɨmavami, Pɨhu kututa ŋgarɨŋ ndañɨ umara. Uta sɨkwɨtaya ŋgɨtɨra donki mu siki tɨmburamɨtu kɨyɨmandɨ, ñɨŋi nuŋandɨ handahara nu naŋga kɨhɨrɨ kɨyɨmandɨ. Siki ha kuyɨvata arɨkita yi kɨyɨman nɨñɨ tɨmbuta payɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kamatɨra kru mumɨŋga narɨŋɨrɨm kuyu mu ambɨtiŋgata ambamara, Donki arɨkita nɨŋɨnɨŋ, Aru hama sɨmbɨra naŋga, vamba ambamara. Kamavɨtɨra sɨkwɨtaya sɨmbɨti arɨkita payɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kanɨmata vana yɨvurahami nɨŋandɨhinɨrɨm kuha kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga kuyu nɨmata ambami ha kandɨsɨkwɨsɨkwɨ yɨvurahami. Nɨmavamba ambami, ");
INSERT INTO kqa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saion hati krunavundirɨm kuyu nɨŋandɨhin ambavaramara, Nɨŋgamara. Narɨŋandɨ aru miku nɨma payɨ. Nu kru ñɨmbi manɨman hama payɨmañandɨ. Kamata donki hɨmba munɨñɨ mɨnzɨ. Nu donki mɨwɨrɨ nɨñɨ mɨnzɨta payɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kamata sɨmbɨrasara arɨkimbat uta Jisas ambami maña andɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kamata donki nɨŋum naŋga ñɨŋi ha tɨmbuta payɨmu. Kamata arɨkimbat nurɨŋandɨ mɨkwɨrɨ kuta haŋɨnɨŋ donkindu kutɨ hañɨ yɨvutɨhumu. Kamatɨhu Jisas kɨmba hañɨ mɨnzɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kamatɨhi krunavundi sambɨ nurɨŋandɨ mɨkwɨrɨ kuta haŋɨnɨŋ sɨharanzɨhara kɨndɨmbat hañɨ yɨvutɨhumu. Kamatɨhu muvɨra ahumakamaka mɨkɨ naŋga haŋɨnɨŋ tahɨrandahɨra kɨndɨmbatɨyɨ tamamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kamatɨndɨ krunavundi Jisasɨndu kasiram ndambu umu ndaŋɨnɨŋ naŋga sɨhɨndɨ payɨmu nɨŋɨnɨŋ, sɨhanaŋga nɨmavamba taŋguvɨhumu, Devit Nɨŋuñɨŋgirɨm kɨnzɨhɨnzɨtɨm. Kru Aru nɨmandu ñɨmbiyɨ payɨmi nɨmaŋ, Got nuŋ avindamam. Got kɨmbayɨndu sɨkwɨ nɨmarɨm kɨnzɨhɨnzɨtɨm, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jerusalem indɨhuhi, pɨhu aru hañɨndu krunavundi sɨhanaŋga ŋgata pɨndɨrata nɨmavamba kitɨhumu, Kru kanɨma ninɨndɨmbanzɨkwɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kamavahu krunavundi nu naŋga umu haŋɨnɨŋ ambamu, Nu Jisas, kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga. Pɨhu Nasaret, pɨrɨvɨsa Galilindu mɨŋga payɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨ indɨhumi. Kamata kru kandɨhaŋu tɨmbahɨrɨs sɨmbɨra mɨŋamu haŋɨnɨŋ sɨhanaŋga pɨŋguvarami. Kamata kru tɨmbahɨrɨs tɨvɨrandu haŋɨnɨŋɨndu pina haŋɨnɨŋ, naŋga kava tamahuhu mut mɨŋandu haŋɨnɨŋɨndu mɨnzɨmɨnzɨ maka haŋɨnɨŋ mɨŋasiŋgɨvarami. ");
INSERT INTO kqa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kamata nurɨŋ ambami, Gotɨndu aŋgwɨmɨkɨyɨ nɨmavamba ambami, Yandɨ tavɨ nɨŋaŋdɨhin yi naŋgandaya kuyundavaravara tavɨ kɨyɨmandɨ, vamba ambami. Hara narɨ andɨhara kru kurɨhahurɨha naŋga kipa naŋga haŋɨnɨŋɨndu sipɨrusipɨru upɨ maña kɨyɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kamata Jisas Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨ kɨyɨmi. Kamatɨhi tamɨŋga ñumi naŋga tanda ñamba haŋɨnɨŋ nu kɨyɨmiyɨ payɨhu nurɨŋ mɨŋavindamami. ");
INSERT INTO kqa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Hara Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ, Jisas muhɨmɨmuhɨm avinzɨkwɨ sihɨrami haŋɨnɨŋ ŋgamu. Naŋga ñɨŋisɨrambɨ Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨ kɨta nɨmavamba taŋguvɨhumu, Narɨ Devit Nɨŋuñɨŋgirɨm kɨnzɨhɨnzɨtɨmara, vahu indarɨmu. Harɨm nurɨŋ kɨtɨrɨtɨhi, Jisasɨŋ nɨmavamba kitɨhumu, Na ñɨŋisɨrambɨ nɨŋɨnɨŋ kuyu ambayu nɨ indarɨna, vamu. Kamavahu Jisas kɨmbɨ ambami, Ara yi indarɨn. Hara narɨ kuyu nɨ Gotɨndu aŋgwɨmɨkɨyɨ ŋgatɨŋgɨruta mambaha ŋgandara. Devit Gotɨŋ ambami, Ñɨŋi sukɨsɨrambɨ nandɨ ñɨmbi tɨhuyahandu, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kamata Jisas nurɨŋ mitata pɨhu aru hañɨndu tapɨrañɨ pindɨhami. Kamata aŋga pata kandɨhɨvɨ hañɨ Betani kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kamata kɨvɨsuŋ nda Jisas sɨhinda pɨhu aru hañɨ aŋga uhi, nuŋ avɨhatɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kamata kɨndɨ tɨvɨ hañɨ ŋgahi ahu fik muŋandɨhin kɨyɨhi arɨhañɨ umi. Hara ŋgahira kandɨhañɨ kandɨ maŋgɨyɨmi. Mɨkɨ haŋɨnɨŋ ndaya kɨyɨhu ahu fik haŋandɨhinɨrɨm ambami, Na sɨhinda kandɨ mandamɨrɨmana, manɨŋganzɨkwɨ, vami. Kamavahi sarɨwayɨŋandi ahu fik haŋandɨhin kwɨrɨñandɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kamatɨhi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kandɨha ŋgata pɨndɨramu. Kamata nɨmavamba kitɨhumu, Pamatɨhi ahu fik nɨŋandɨhin sarɨwayɨŋandi kwɨrɨñandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kamavahu Jisas kɨmbɨ ambami, Narɨŋ yi kandɨ ambin, narɨ indarɨmaŋgarata, narɨŋandɨ indarɨmit arɨkita maŋgɨti, yi ahu fik nɨŋandɨhin andɨn maña narɨndahara sɨwɨmaña musa andɨhara. Naŋga kandɨ vana nindaya maŋandɨhara. Apu ndaŋandɨhin nɨmavamba ambɨtɨra, Na yahamɨrata kumbɨtɨhuta añakɨŋguku ndañɨ mɨŋgu vamba ambɨtɨra, ambahara maña andɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ara indarɨmaŋgarata Got naŋga kuyundavarɨmandɨra ha, muhɨmɨmuhɨm mɨŋɨrɨm ambɨrɨmandɨra ha, narɨ mɨŋɨmandɨra, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨ indɨhuta krunavundiŋ ambaramami. Kamatɨhi Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ payɨmu. Kamata Jisasɨŋ nɨmavamba kitɨhumu, Na ñɨmbi kanɨŋandɨhin paŋundu mɨŋata kanɨmata vana nɨ andɨna. Naŋga nindɨmbanzɨkwɨ ñɨmbi ŋguta ambahi kanɨmata sɨmbɨra mɨŋana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kamavahu Jisas kɨmbɨ ambami, Yindahara narɨŋ muhɨmɨrɨm kitɨwɨrɨman. Kamatɨn kɨmbɨ yaŋ kandɨ ambɨtɨra ŋgatanda, yi narɨŋ yaŋ ninɨmbaha taya ñɨmbi ŋguhi sɨmbɨra mɨŋandinɨrɨm ambɨtɨn indarɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon krunavundiŋ kukuyɨ mɨŋaŋgɨrundi vana ha pañɨndu mɨŋami. Kandɨha Gotɨndu pɨhuyɨndu vana vaha, mana krundu vana taya vaha, vami. Kamavahi nurɨŋambi masamasa ambamu, Ara Gotɨndu pɨhuyɨndu vana vɨtɨrɨŋ arɨŋ nɨmavamba kitɨwɨrɨmandɨ, Ara mumɨndɨhi nuŋambirɨm maŋindarɨmaŋgarandara, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hara kaŋandɨhin krundu vana vataŋgata krunavundirɨm pɨŋitɨvɨmɨ. Krunavundi Jonɨrɨm kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga vamba ambandundɨhi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kamavata Jisasɨŋ ambamu, Ara maŋgandarɨŋ, vamu. Kamavahu Jisas nurɨŋ ambami, Yindahara ninɨmbaha taya yaŋ ñɨmbi ŋguhi sɨmbɨra kanɨŋandɨhin mɨŋandinɨrɨm narɨŋ maŋambɨmɨnda, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kamata Jisas sɨhinda Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ ambami, Narɨ pamata indarɨmitara. Kru mumɨŋga kru ñɨŋi nuŋandɨ arɨkita. Nuŋandɨ ñɨŋi nɨwɨsa hamarɨm uta ambami, Yandɨ ñɨŋi, musi uta wain kɨva ndañɨ sɨmbɨra mɨŋa, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kamavahi ñanɨŋ ambami, Yaŋ yakwɨrɨtɨ, vamba ambami. Hara kɨyɨhi nuŋandɨ indarɨmit hambu tɨvɨrahi umi. ");
INSERT INTO kqa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kamata nɨŋuva uta ñɨŋi muhamarɨm sɨwɨmaña kuyu nda ambahi ñɨŋi hama ambami, Yava urɨmanɨ, vamba ambami. Hara maŋumi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jisas kamavata ambami, Ñɨŋi arɨkimbat hañɨndu ninɨndaya nɨŋuva ambami maña andɨmi, vami. Kamavahi ambamu, Kima hama, vamu. Kamavahu Jisas nurɨŋ ambami, Narɨŋ yi kandɨ ambin, kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa haŋɨnɨŋ, naŋga navundi kru mɨŋavɨŋgɨrɨvɨŋgɨrɨ haŋɨnɨŋ wɨsa Gotɨndu tɨwɨyɨ kɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon narɨ kɨyɨmarañɨ yɨvurahata narɨŋ tɨtɨtɨ vana taya isɨhuramami, hara nuŋɨrɨm maŋindarɨmaŋgaramara. Kru gavaman ndamarɨm tɨmbahɨrɨs mɨŋamɨŋa haŋɨnɨŋ, naŋga navundi kru mɨŋavɨŋgɨrɨvɨŋgɨrɨ haŋɨnɨŋ nɨŋambirɨm indarɨmaŋgaramu. Kandɨhamata vana andɨhu ŋgamara, hara narɨŋandɨ indarɨmit hambu tɨvɨrahi nɨŋambirɨm maŋindarɨmaŋgaramara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas aru miku haŋɨnɨŋ sɨhinda ambami, Sɨhinda tɨhi kuyu muŋandɨhin indarɨmara. Kru mumɨŋga wain kɨva mɨŋami. Kamata tapa haŋandɨhin tɨmbayɨ tama taŋgɨrata arɨndɨhuyɨvɨmi. Kamata kɨva tuŋgɨ hambu wain kɨrɨs taŋguvusɨvusɨrɨm kumba kayɨvata musa mɨŋata, kru kɨta kɨva ha karatamatamarɨm tavɨ kuta ŋandi tɨhumi. Kamata kru muvɨra sɨmbɨra mɨŋɨmandɨyu vata kɨva ha nurɨŋandɨ kumañɨ tamami. Kamata pɨhu mu kutañɨ umi. ");
INSERT INTO kqa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kamata wain haŋɨnɨŋ kandɨ tamɨrɨm andɨmi. Kamatɨhi nuŋandɨ sɨmbɨrasara saŋ muvɨraŋ uta kɨva sɨmbɨra mɨŋamɨŋa haŋɨnɨŋ kɨyuyɨ nuŋandɨ wain mɨndɨ mɨŋamu vata sɨmbɨhi umu. ");
INSERT INTO kqa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kamatɨhu kru kɨva hañɨ sɨmbɨra mɨŋandu haŋɨnɨŋ sɨmbɨrasara saŋ haŋɨnɨŋ mɨŋata, muhamaŋ yɨvuta, muhamaŋ yɨvutatamahu kɨmuhi, muhamaŋ tɨmba kavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kamatɨhu kɨyɨhandata kɨva nɨŋuva hama sɨhinda nuŋandɨ sɨmbɨrasara saŋ muvɨraŋ sɨmbɨhi nurɨ kɨyɨmuyɨ umu. Kimaŋgimañɨ sɨmbɨmi haŋɨnɨŋ taratɨvɨrata sambɨmarɨ sɨmbɨmi. Kamatɨhi kɨvayɨ sɨmbɨra mɨŋamu haŋɨnɨŋ sɨmbɨrasara saŋ kandɨhaŋɨnɨŋ ndahara sɨwɨmaña musa nda andɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kamatɨhu kɨta kɨva nɨŋuva hama nuŋandɨ ñɨŋi tɨmbanzɨkwɨŋ sɨmbɨhi nurɨ kɨyɨmuyɨ umi. Nɨŋuva ambami, Yandɨ ñɨŋi nɨmandu kuyu indarɨmandɨyu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hara kru kɨva hañɨ sɨmbɨra mɨŋandu haŋɨnɨŋ ŋgahu ñanɨŋ payɨhi nurɨŋambi masamasa kuyundavarata ambamu, Kru nɨma nɨŋuvandu muhɨmɨmuhɨm nu mɨŋɨmandɨ. Harɨm nuŋ yɨvutatamata, nɨŋuvandu kɨva nɨ ara mɨŋɨm, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kamavata kru hamaŋ mɨŋahandata pɨŋgɨrɨta uta kɨva tapa kut hambu kavarahu indɨhuhi yɨvutatamahu kɨmumi. ");
INSERT INTO kqa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Harɨm muyɨvɨ kɨva nɨŋuva hama pata kru nuŋandɨ kɨva hañɨ sɨmbɨra mɨŋandu haŋɨnɨŋ pamata musa andɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kamavahi nuŋ ambamu, Kru ñamba kandɨhaŋɨnɨŋ pɨsiŋgarɨmandɨ. Kamata wain kɨva ha mɨŋata kru muŋɨnɨŋ ŋguti karatamɨrɨmandɨyu. Kamata ñaña mɨŋamɨŋa tɨwɨmiyɨ yɨvutɨhɨruramata nuŋ ŋgumandɨyu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kamavahu Jisas nurɨŋ nɨmavamba kitɨhumi, Narɨ Gotɨndu aŋgwɨmɨkɨyɨ kuyu mandambu nɨŋu ŋgatɨŋgɨruta mambaha ŋgamara. Kuyu kandɨha ambami, Tɨmba tavɨ tɨhutɨhu haŋɨnɨŋ ñamba vata tɨvɨmbu tamamu. Tɨmba kandɨha tɨhu tavɨ tapa mɨŋahandahandandu tɨmba avi ŋandi kɨyɨ. Aru hama nuŋambi kandɨhɨm ha andɨhi yɨvurahahi ara ŋgaharɨŋ avindɨmbanzɨkwɨ kɨyɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kamataharɨm narɨŋ yi ambin, kuha narɨ Gotɨndu tɨwɨyɨ kɨyɨmara. Hara narɨŋ Got tɨhɨmitata krunavundi muŋɨnɨŋ mɨŋɨmandɨ. Kamati nuŋandɨ tɨwɨyɨ kɨta, nuŋandɨ kuyu taya mɨŋahandɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kamata kru tɨmba hɨmba kandɨhañɨ mɨŋgata yɨvɨrɨmandɨ hama punzɨ haŋɨnɨŋ yɨvurɨvumbɨrɨmandɨ. Hara tɨmba kandɨha kru ŋgɨmba muyɨ mɨŋgata yɨvɨrɨmandɨ ha, tɨmba ha kru kandɨhamaŋ yɨvɨti mɨñɨndɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kamavahi Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga Farisi tɨhi kuyu kandɨha indarɨta ambamu, Nɨ arɨŋambirɨmɨnzɨkwɨ ambi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Harɨm Jisasɨŋ mɨŋahandɨmɨndaŋ nzɨkwɨ vata andɨmu. Hara krunavundi Jisasɨrɨm kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga vamba indarɨmitandu. Harɨm krunavundirɨm pɨŋitumu. ");
INSERT INTO kqa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas sɨhinda aru miku haŋɨnɨŋ tɨhi kuyu mu ŋguta nɨmavami, ");
INSERT INTO kqa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha aru miku mumɨŋgandu maña. Kru ñɨŋi nuŋandɨ hama navundi urɨrɨmɨndɨhi, aru miku hama ñahuravɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kamata tɨmu kandɨhañɨ payɨmandɨyu vata kruŋ ambami. Kamata ñaña hɨvɨ hañɨ nuŋandɨ sɨmbɨrasara saŋ haŋɨnɨŋ uta kru kandɨhaŋɨnɨŋ tɨmbuta payɨmara vata sɨmbɨhi umu. Kamatɨhi uta ambahu payɨvayɨrɨm yakwɨrɨvarata mambayɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kamatɨhu sɨhinda nuŋandɨ sɨmbɨrasara saŋ muvɨraŋɨnzɨkwɨ sɨmbɨta ambami, Uta kru ambasɨmin haŋɨnɨŋ nɨmavamba ambamara. Ŋgamara, nu nuŋandɨ bulmakau kru muvɨra naŋga sɨhɨm muvɨra kwɨrandɨ naŋga haŋɨnɨŋ ndahara yɨvutatamata ñaña nuŋandɨha sɨwɨtami. Kamataharɨm pata ñamara, vamba ambamara, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kamavahi aru miku hamandu sɨmbɨrasara saŋ haŋɨnɨŋ uta kru haŋɨnɨŋ ambami maña ambavaramu. Kamatɨhura nurɨŋandɨ kuyu maŋindarɨta siŋgunziŋgu umu. Muhama nuŋandɨ kɨvayɨ umi. Muhama nuŋandɨ tɨmbahɨrɨs sɨmbɨra mɨŋɨrɨm umi. ");
INSERT INTO kqa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hara muvɨra, aru miku hamandu sɨmbɨrasara saŋ haŋɨnɨŋ mɨŋahandata sɨhumɨŋguyu ŋguta yɨvutatamahu kɨmumbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kamatɨhu aru miku hamaŋ kɨtɨrɨtɨhi nuŋandɨ saŋganzara haŋɨnɨŋ sɨmbɨhi umu. Uta kru nuŋandɨ sɨmbɨrasara saŋ yɨvutatamamu haŋɨnɨŋ sɨhanaŋga yɨvuvarahu kɨmuta mɨtumu. Kamata nurɨŋandɨ pɨhu aru ha kɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kamata aru miku hama nuŋandɨ sɨmbɨrasara saŋ haŋɨnɨŋɨrɨm ambami, Kru naŋga navundiŋ mɨŋavɨsɨhuramata ñahuravɨravɨndu ñaña sɨwɨ kɨyɨ. Hara kru uraramasɨmin haŋɨnɨŋ aviŋɨnɨŋ ma, harɨm pata mañɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kamataharɨm kwɨmbɨhiŋgɨrɨñɨ uhuhu kru sɨhanaŋga ŋgɨmandɨra haŋɨnɨŋ, uraramɨtɨra tɨmu nɨñɨ payɨmu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kamavahi nuŋandɨ sɨmbɨrasara saŋ kandɨhaŋɨnɨŋ kwɨmbɨ sɨhanaŋgayɨ siŋgunziŋgu uhuhu krunavundi ŋgamu haŋɨnɨŋ yɨvutɨhɨruramamu, krunavundi ñamba ŋɨnɨŋ naŋga aviŋɨnɨŋ. Kamatɨhu pata ñɨrɨm mɨnzɨhu tavɨ ha yavurɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kamata krunavundi mɨnzɨta kɨyɨhuhu, aru miku hama nurɨŋ ŋgɨrɨm indɨhumi. Kamata ŋgahira kru mundama mɨkwɨrɨ avi kru naŋga navundiŋ mɨŋavɨsɨhuramata ñahuravɨndu hɨvɨyɨ tamandu ŋandi mandamami. ");
INSERT INTO kqa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamatɨhi aru miku hama kitɨhumi, Yambɨha, na mumɨndɨhi mɨkwɨrɨ aviŋandɨhin mandamɨmat pindɨhana, vamba ambami. Kamavahira kru hamandu kuyu maŋgɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kamata aru miku hama sɨmbɨrasara saŋ haŋɨnɨŋɨrɨm nɨmavamba ambami, Nuŋandɨ kuma tanda nɨ sɨmahata kavarɨtɨra tapɨra kɨvɨmɨŋgwɨ humba ndambu indɨhuta kɨyɨm. Pɨhu kɨvɨmɨŋgwɨ kandɨhañɨ irɨharɨha mɨka satɨpɨrɨmandɨyu, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kamavata Jisas ambami, Indarɨmara, Got krunavundi sambɨ uraramandi. Hara mɨnzavatɨvatɨŋ ndaya pindɨhavindɨharɨm yɨhɨramandi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kamata Farisi uta Jisasɨŋ kɨndɨmbuhɨrata ŋgatɨŋgurɨmɨndaŋ vata kuyu ñamu. Jisasɨŋ kuyusɨhɨrɨtɨrɨŋ kuyu aka vu ambɨti, nuŋandɨ kuyu kandɨhañɨ nuŋ ŋgatɨŋgurɨmɨndaŋ vata indarɨramamu. ");
INSERT INTO kqa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kamata nurɨŋandɨ sɨmbɨrasara haŋɨnɨŋ naŋga Herotɨnduyɨndu kru muvɨraŋ sɨmbɨhu, Jisas kɨyɨmiyɨ uta nuŋ ambamu, Ahusɨki, ara naŋ ŋgandarɨŋ, na kandɨtaya ambavava mɨŋga. Kamata krunavundiŋ kuyu kandɨtaya Gotɨndu vana ambavarandana. Na kru mumɨŋgarɨm ndahara mambɨŋitundana. Na kruŋ kuyu sɨwɨmaña ndaya ambaramandana, ñɨmbi naŋga ŋɨnɨŋ naŋga ñɨmbi manɨman ŋɨnɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kamataharɨm arɨŋ ambɨna ŋgɨm. Na pamata indarɨna, Sisarɨŋ tɨmbahɨrɨs ŋguharɨŋ vaha, mana mambaha ŋguharɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kamavahura Jisas nurɨŋandɨ indarɨmit ñamba ha atɨnda ŋgami, harɨm ambami, Kru kuyusɨhɨrɨmbɨhapɨha narɨ, yaŋ mumɨndɨhi kuyusɨhɨrɨrɨm andɨra. ");
INSERT INTO kqa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yaŋ tɨmbahɨrɨs tamandara muha isɨhuramɨtɨra ŋgɨtɨn, vami. Kamavahi tɨmbahɨrɨs mɨŋgɨya kɨrɨs taya nu kɨyɨmiyɨ mɨŋata payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kamatɨhu Jisas nurɨŋ nɨmavamba kitɨhumi, Ñɨmbi naŋga kɨpumɨka nɨ ninɨndu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kamavahi ambamu, Sisarɨndu, vamu. Kamavahu ambami, Sisarɨndu hɨm Sisarɨŋ ŋgumara, Gotɨndu hɨm Gotɨŋ ŋgumara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kamavahi kuyu kandɨha indarɨta pɨndɨrata, nuŋ mitata umu. ");
INSERT INTO kqa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kandɨhɨvɨ hañɨndaya Sadyusi Jisas kɨyɨmiyɨ payɨmu. Kandɨhaŋɨnɨŋ ambarasɨmu, Kru kɨmundu haŋɨnɨŋ aŋga mayahamɨrɨmandɨyu, varasɨmu. Harɨm Jisasɨŋ nɨmavamba kitɨhumu, ");
INSERT INTO kqa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ahusɨki, Moses ambami, Kru mumɨŋga ñɨŋi maŋgavɨmat kwɨmɨtiŋgata, nɨmburiŋ nɨŋura urata ñɨŋi kavɨti, nɨŋusindu krunzapa ha manziŋgundɨmɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kuha arɨŋandɨ ñiŋgiñɨ kru mɨnza susukiyɨndu taya kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata vat kɨrasɨmu. Kamata Kima hama navundi urata kɨta kɨmumi, hara ñɨŋi maŋgavumi. Harɨm nɨŋura Yaŋgɨv hama navundi kandɨhaŋambɨŋ urami. ");
INSERT INTO kqa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kamatɨhi nɨŋura Yaŋgɨv hama ndahara ñɨŋi maŋgavɨmat kɨmumi. Kamatɨhi Kari hama ndahara sɨwɨmañanda ñɨŋi maŋgavɨmat kɨmumi. Kamatataya uta imbɨ, Imbima hama ndahara kɨmumi. ");
INSERT INTO kqa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sɨhanaŋga kɨmuta mɨtuhu, kɨta imbɨ navundi haŋambɨ kɨmumi. ");
INSERT INTO kqa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Harɨm na amba. Kru kɨmuhɨmu haŋɨnɨŋ aŋga yahamɨrɨmandɨyu tɨwɨmiyɨ navundi haŋambɨ nin nɨmburi sɨkwɨ nɨŋusi nɨŋura kuma timu, tamu arɨkinzɨpi tɨŋgɨruramata hañɨndu nɨmburi kɨyɨmandɨ. Ŋgandana, nurɨ sɨhanaŋga nuŋ uramu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kamavahu Jisas nurɨŋ kɨmbɨ ambami, Narɨ Gotɨndu aŋgwɨmɨkɨyɨ kuyu kɨndi haŋandɨhin mambaha ŋgandara. Naŋga narɨ Gotɨndu tɨkatɨka ndahara maŋgandara. Kamataharɨm narɨ kuyu kirivu ambara. ");
INSERT INTO kqa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gotɨndu kutɨkara nuŋandɨ pɨhuyɨ kɨndu haŋɨnɨŋ navundi maŋurandu. Sɨwɨmaña ŋandi, krunavundi kɨmuhɨmu haŋɨnɨŋ aŋga yahamɨrɨmandɨyu hɨvɨyɨ, kru haŋɨnɨŋ navundi maŋurɨmandɨyu. Kamatu navundi kru mayawɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hara kru kɨmuta aŋga yahamɨrɨmandɨyu vava vana nɨŋandɨhinɨrɨm narɨŋ kitɨwɨrɨman. Narɨ Gotɨndu aŋgwɨmɨkɨyɨ kuyu kɨndi haŋandɨhin ŋgatɨŋgɨruta mambaha ŋgandara. ");
INSERT INTO kqa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Got ambami, Yi Got. Yandɨ ñɨmbi Abraham, Aisak, naŋga Jekop tɨhuyahandu, vamba ambami, vami. Kamavata sɨhinda ambami, Krunavundi kɨmuta sava humbañɨ kɨndu haŋɨnɨŋ Gotɨndu ñɨmbi mandɨhuyahandu. Hara krunavundi sɨhaŋgɨndu haŋɨnɨŋ Gotɨndu ñɨmbi tɨhuyahandu. Abraham, Aisak, Jekop ndahara sɨhaŋgɨndu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kamavahi krunavundi nuŋandɨ kuyu kandɨha indarɨhu mavɨyahavarami. ");
INSERT INTO kqa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kamata Farisi Jisas Sadyusiŋ kuyu hɨndɨ mɨŋayɨhɨ vava kuyu indarɨmu. Kamataharɨm nu kɨyɨmiyɨ payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kandɨ ñiŋgi hañɨ tɨkatɨka kuyu mɨŋasɨrɨvasɨrɨva mumɨŋga ndahara kɨyɨmi. Harɨm kandɨhama Jisasɨrɨm ambɨti ŋgɨtɨn vata nɨmavamba kitɨhumi, ");
INSERT INTO kqa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ahusɨki, tɨkatɨka kuyu pamata kuyu sɨkwɨ kimaŋgima, tɨkatɨka kuyu muvɨraŋ sɨhanaŋga taratɨvɨrahi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kamavahi Jisas nuŋ ambami, Narɨ Gotɨŋ mɨŋata mavɨñɨ tamamara, arɨŋandɨ Aru nɨmaŋ. Narɨ nuŋ narɨŋandɨ mavɨŋguku naŋga, narɨŋandɨ mavɨñɨŋi naŋga, narɨŋandɨ indarɨmit naŋga mɨŋata mavɨñɨ tamamamara. ");
INSERT INTO kqa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tɨkatɨka kuyu kanɨŋandɨhin aru, naŋga kimaŋgimanzɨkwɨ. ");
INSERT INTO kqa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Naŋga tɨkatɨka kuyu sɨwɨmaña muha nɨŋandɨhin. Nambi nandɨ kwɨrandɨrɨm mavɨndamandana maña, sɨhanaŋga kruŋ ndahara mɨŋata mavɨñɨ tama. ");
INSERT INTO kqa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kuyu arɨkita kanɨŋɨnɨŋ kuyu muvɨrandu kuyu sapa. Gotɨndu tɨkatɨka kuyu sɨhanaŋgandu kuyu sapa. Naŋga kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ kuyu yɨhimbɨvɨramundu kuyu sapa, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi tɨhɨruta kɨyɨhuhu Jisas nurɨŋ nɨmavamba kitɨhumi, ");
INSERT INTO kqa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Narɨ kru Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata yɨhɨramami hamarɨm narɨ pamata indarɨra. Nu ninɨndu ñɨŋi, vami. Kamavahi nuŋ nɨmavamba ambamu, Nu Devit nɨŋuñɨŋgi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kamavahu Jisas nurɨŋ nɨmavamba kitɨhumi, Hara mumɨndɨhi Gotɨndu Mavɨñɨŋi nuŋ indarɨmit ŋguhi, Devit kru kandɨhamarɨm ambami, Yandɨ Aru mɨŋga vami. Kamavata Devit nɨmavamba ambami, ");
INSERT INTO kqa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Aru hama yandɨ Aru hamaŋ ambami, Na yandɨ kuma kandɨ samba nɨmbu mɨnzɨrɨmana. Kamatɨna nandɨ miku haŋɨnɨŋ tamɨtɨn nandɨ tɨwɨyɨ kɨyɨmandɨyu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Narɨ ŋgamara. Devit nuŋambi kru kandɨhamarɨm ambami, Na yandɨ Aru mɨŋga vamba ambami. Hara pamatarɨm kru kandɨhama Devit nɨŋuñɨŋgi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kamavahi muvat ndahara Jisasɨŋ kuyu kɨmbɨ maŋambami. Kamata kandɨhɨvɨ hañɨ kɨta, Jisasɨŋ muhɨm vanarɨm kitɨhuhitɨhurɨm pɨŋitumu. ");
INSERT INTO kqa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mutɨwɨmiyɨ Jisas krunavundiŋ naŋga nuŋandɨ sɨmbɨrasaraŋ kuyu ŋgumi. ");
INSERT INTO kqa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kamata ambami, Moses tɨkatɨka kuyu ambavarami maña, narɨŋ tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga Farisi haŋɨnɨŋ tɨkatɨka kuyu ambavarandu. ");
INSERT INTO kqa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kamataharɨm muhɨmɨmuhɨm kuyu narɨŋ ŋgumandɨyu haŋɨnɨŋ indarɨta mɨŋahandamara. Hara muhɨmɨmuhɨm vana andɨndu haŋɨnɨŋ mamɨŋahandamara. Muhɨmɨmuhɨm kuyu sambɨ ambavarandu, hara ambandu kuyu ha mamɨŋahandandu. ");
INSERT INTO kqa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Krundu tɨvɨŋgɨñɨ pɨmɨ tupi ŋandi sɨmahata kavuramɨmañandɨhu kru kavuŋgavu avɨrɨtamandu. Hara nurɨŋambi pɨmɨ musɨmbɨrɨ ndahara kruŋ ŋguramata kavuhavurɨm kuma maŋgundu. ");
INSERT INTO kqa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Muhɨmɨmuhɨm vana andɨndu haŋɨnɨŋɨrɨm, kru ŋgɨmandɨyu vata andɨndu. Got naŋga kuyundavaravararɨm tavɨ aru mirɨmbañɨ sɨmahandu. Kamata mɨkwɨrɨ nurɨŋandɨ kuta hañɨ ñapɨru hambu sɨri siki kutaŋguta tɨmbuvarandu. ");
INSERT INTO kqa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kamatɨndɨ tɨmu vanayɨ mɨnzɨmɨnzɨ maka kasiramɨyɨndu haŋɨnɨŋ nurɨ taya mɨŋandu. Naŋga Got naŋga kuyundavaravara tavɨyɨ nurɨ taya mɨnzɨmɨnzɨ upɨyɨ kasiramɨvu mɨnzɨmɨndaŋ vata andɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kamata tɨhɨrutɨhɨru upɨyɨ krunavundi arɨŋ kuyu avi ŋguta, ahusɨki vɨrɨmandɨyu vata pirɨkɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Hara narɨŋɨrɨm, kru ahusɨki vata maŋambamu. Ahusɨki narɨŋandɨ mɨnzavat mɨŋgandaya kɨyɨ. Narɨ sɨhanaŋga nɨŋusi nɨŋura. ");
INSERT INTO kqa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Narɨ pɨrɨ nɨñɨndu kru mumɨŋgarɨm yava vata maŋambamara. Narɨŋandɨ Nava mɨnzamɨnza nuŋandɨ pɨhuyɨ kɨyɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naŋga narɨŋɨrɨm kru miku ŋɨnɨŋ vata maŋambamu. Narɨŋandɨ miku mɨnzamɨŋgandaya, Kru Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata yɨhɨramami hama. ");
INSERT INTO kqa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Narɨŋandɨ aru hama narɨŋandɨ sɨmbɨrakara mɨŋga kɨyɨm. ");
INSERT INTO kqa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kru nuŋandɨ ñɨmbi tɨhuyahɨrɨmandɨ hama, Got andɨti ñɨmbi manɨman mɨŋga kɨyɨmandɨ. Ara kru nuŋandɨ ñɨmbi taŋguti mɨŋgurɨmandɨ hama, Got andɨti ñɨmbi aru naŋga mɨŋga kɨyɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Kamata Jisas sɨhinda ambami, Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ Gotɨndu tɨwɨyɨ kɨyɨhɨyɨ hañɨndu kɨndɨŋariha krunavundindu kɨpumɨkayɨ kivihɨta narɨŋambi maŋindɨhundara. Krunavundi indɨwɨrɨmɨnɨdɨhu nurɨŋandɨ kɨndɨha kivihɨndara. ");
INSERT INTO kqa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ pɨrɨvɨsa naŋga añakɨŋguku muvumuvu kɨndaŋgɨnda andɨhara, mɨnzavat mɨŋgandaya narɨŋandɨ sɨmbɨrasara mɨŋga yɨvurahandi. Kamata narɨŋ nu ñamba vanarɨm taratɨvɨramaŋgarandi. Kamataharɨm narɨ ahutuvarandi helɨyɨ urɨmandɨra maña, nu ndahara urɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Narɨ tamɨŋga ñumi ŋɨnɨŋ kru muŋɨnɨŋ kɨndɨ isɨhuramɨndaŋ vata andɨndara, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ ambandara, Kru mumɨŋga Gotɨŋ kɨrañɨŋguhu tavɨ haŋandɨhinɨndu ñɨmbi yɨhɨta kandɨsɨkwɨsɨkwɨ kuma yawi vata nuŋandɨ kuyu tɨkatɨkatɨramandɨ. Kandɨhaŋandɨhinɨrɨm kuyu saŋɨnzaŋ, vamba ambandara. Hara kru mumɨŋga gol Gotɨŋ kɨrañɨŋguhu tavɨyɨ kɨndi haŋandɨhinɨndu ñɨmbi yɨhɨta nuŋandɨ kuyu ha tɨkatɨkatɨramandɨ. Kamata ambɨrɨmandɨ maña andɨmɨ, vamba ambandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Narɨ kwɨnɨkwɨnɨ naŋga tamɨŋga ñumi ŋɨnɨŋ, Gotɨndu tamɨŋgañɨ mumɨndɨmbanzɨkwɨ aru hɨm. Gol vaha aru hɨm, mana Gotɨŋ kɨrañɨŋguhu tavɨ vaha aru hɨm. Narɨ ŋgandara. Gol Gotɨŋ kɨrañɨŋguhu tavɨyɨ kɨta, Gotɨŋ kɨrañɨŋguhu tavɨ ha andɨhi gol kandɨha Gotɨndu hɨm yɨvurahandi. ");
INSERT INTO kqa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naŋga narɨ ambandara, Kru mumɨŋga Gotɨŋ kɨrañɨŋguhu pina ha yɨhɨta kandɨsɨkwɨsɨkwɨ kuma yawi vata nuŋandɨ kuyu tɨkatɨkatɨramandi. Kandɨhaŋandɨhinɨrɨm kuyu saŋɨnzaŋ, vamba ambandara. Hara kru mumɨŋga muhɨmɨmuhɨm Gotɨŋ kɨrañɨŋguhu pina kɨmba hañɨ kɨndi haŋɨnɨŋ yɨhɨta nuŋandɨ kuyu ha tɨkatɨkatɨramandɨ. Kamata ambɨrɨmandɨ maña andɨmɨ, vamba ambandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Narɨ tamɨŋga ñumi ŋɨnɨŋ, Gotɨndu tamɨŋgañɨ mum ndɨmbanzɨkwɨ aru hɨm. Gotɨŋ kɨrañɨŋguhu hɨm vaha aru, mana Gotɨŋ kɨrañɨŋguhu pina vaha aru. Narɨ ŋgandara, ñaña kɨrañɨŋguhundu ha kɨrañɨŋguhu pina hañɨ kɨndi. Kamataharɨm Gotɨŋ kɨrañɨŋguhu pina ha andɨhi ñaña ha Gotɨndu hɨm yɨvurahandi. ");
INSERT INTO kqa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kamataharɨm kru mumɨŋga Gotɨŋ kɨrañɨŋguhu pina haŋandɨhinɨndu ñɨmbi yɨhɨta kandɨsɨkwɨsɨkwɨ kuma yawi vata nuŋandɨ kuyu tɨkatɨkatɨramandi. Kandɨhama, nuŋandɨ kuyu ha kɨrañɨŋguhu pina handaya ñɨmbi yɨhɨta mandɨkatɨkatɨramandi. Nuŋandɨ kuyu ha pina ha naŋga muhɨmɨmuhɨm pina hɨmba hañɨ kɨndi haŋɨnɨŋ naŋga tɨkatɨkatɨramandi. ");
INSERT INTO kqa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naŋga kru mumɨŋga Gotɨŋ kɨrañɨŋguhu tavɨ ha yɨhɨta kandɨsɨkwɨsɨkwɨ kuma yawi vata nuŋandɨ kuyu tɨkatɨramandi. Kandɨhama, nuŋandɨ kuyu ha Gotɨŋ kɨrañɨŋguhu tavɨ handaya ñɨmbi yɨhɨta mandɨkatɨkatɨramandi. Nuŋandɨ kuyu ha Gotɨŋ naŋga Got nuŋambi kɨrañɨŋguhu tavɨ kandɨhañɨ kɨndi hamaŋ naŋga tɨkatɨkatɨramandi. ");
INSERT INTO kqa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naŋga kru mumɨŋga Gotɨndu pɨhundu ñɨmbi yɨhɨta kandɨsɨkwɨsɨkwɨ kuma yawi vata nuŋandɨ kuyu tɨkatɨkatɨramandɨ. Kandɨhama nuŋandɨ kuyu ha Gotɨndu mɨnzɨmɨnzɨ maka, naŋga Got nuŋambi mɨnzɨmɨnzɨ maka kandɨhañɨ mɨnzɨndi hamaŋ naŋga tɨkatɨkatɨramandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ sahi kɨvayɨndu sukɨsɨrambɨ haŋɨnɨŋ kumanzɨpi timutamu tɨŋgɨruramata tamarahata mɨŋgɨyataya Gotɨŋ ŋgundara. Hara narɨ tɨkatɨka kuyundu vana aruru nɨmata haŋɨnɨŋ mitamaraŋa. Krunavundiŋ tɨtɨ vanayɨ taya ŋgatɨŋgɨrutɨŋgɨru vana, sɨhiŋgaha vana, naŋga indarɨmaŋgaramaŋgara vana. Kamataharɨm tɨkatɨkata kuyu aruru haŋɨnɨŋ mɨŋahandata, tɨkatɨka kuyu mu haŋɨnɨŋ ndahara mamitamara. ");
INSERT INTO kqa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tamɨŋga ñumi narɨ, kru muŋɨnɨŋ kwɨmbɨ isɨhuramɨrɨm andɨndara. Narɨ kru mumɨŋga akavat suksɨmbɨrɨ nuŋandɨ mɨsɨ hañɨ kɨyɨhi ŋgata mɨŋata kavarandi. Kamata kamel mɨsɨ hañɨ kamel ha maŋgɨmat kuvɨrata kamel ha naŋga mɨrɨhi mɨŋgundi maña ŋɨnɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ maki naŋga kuku kuvɨrahuvɨra vuŋgɨ haŋɨnɨŋ kutɨhambu taya ñaŋɨrandamandara. Hara ñaña hɨm kandɨhañɨ kundandara haŋɨnɨŋ kipa mɨŋamɨŋa vana, naŋga narɨŋambirɨmɨndaya indarɨtarɨ vanayɨ mɨŋandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi na tamɨŋga ñumi, kuku kuvɨrahuvɨra vuŋgɨ ha mavɨ hambu vɨsa ñaŋɨrandama. Kamatɨna kutɨhambu ndahara ñaŋɨrandɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ krunzava mu maŋa suñɨ naŋga taŋgusɨharahu kɨndi maña ŋɨnɨŋ. Krunzava kandɨha tapɨravu ŋgɨna avindɨhi, hara kumba hambu kru kɨmuhɨmu punzɨ naŋga ñamba hɨmɨŋgɨm yavurɨta kɨndi. ");
INSERT INTO kqa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Narɨndahara sɨwɨmañanda kɨra. Kru narɨŋandɨ kwɨrandɨ hambu ŋgata nɨŋɨnɨŋ kru tɨtɨtaya kɨyɨhɨyɨ ŋɨnɨŋ vamba indarɨmitandu. Hara narɨŋandɨ mavɨ humba hambu kuyusɨhɨrɨ vana naŋga tɨkatɨka kuyu mɨŋata kavarahavara vana yavurɨta kɨyɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tɨkatɨka kuyundu mirɨmba naŋga Farisi narɨ, narɨ pɨmɨ aru kavɨrɨmandɨra. Narɨ kuyusɨhɨrɨmbɨhapɨha ŋɨnɨŋ. Narɨ kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋɨndu sava humba avinzɨkwɨ musa mɨŋandara. Kamata kru tɨtɨtaya kɨyɨhɨyɨ haŋɨnɨŋɨndu sava ha kanzɨ mɨŋayahuramandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kamata nɨmavamba ambandara, Ara añɨŋgitakɨña kɨyɨmu takuk hañɨ kɨta, nurɨŋ ŋguramata kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ mayɨvutatamaharɨŋ, vamba ambandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kamataharɨm narɨŋandɨ kuyu kandɨhañɨ narɨŋambi isɨhuramandara. Kamata narɨ kuha kru Gotɨndu kuyu mɨŋata ambavarandu haŋɨnɨŋ yɨvutatamandu haŋɨnɨŋɨndu ñɨŋisɨm maña kɨra. ");
INSERT INTO kqa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kamataharɨm uta narɨŋandɨ nañɨŋgitakɨñandu ñamba vana haŋɨnɨŋ andɨtɨra arutɨmɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Narɨ tau ñamba ŋɨnɨŋ maña. Narɨ ahutuvarandi helɨyɨrɨm mandarahɨrɨndara. Narɨŋ Got ŋgatɨŋgɨruti, ahutuvarandi helɨyɨ urɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kamataharɨm narɨ indarɨmara. Yi kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ, naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ, naŋga kru indarɨmit avi naŋga haŋɨnɨŋ sɨmbɨtɨn narɨ kɨyɨmandɨrayɨ payɨmandɨyu. Hara muvɨraŋ yɨvutatamɨrɨmandɨra, muvɨraŋ ahuandɨñɨ yɨvuwɨrɨmbɨmandɨra. Muvɨraŋ Got naŋga kuyundavaravara tavɨ narɨŋandɨ hañɨ tamata pɨŋgɨrawɨsmandɨra. Kamata narɨŋandɨ pɨhu aru hañɨ kaharɨvɨtɨra tɨvaramata pɨhu aruru muyɨ urɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kamataharɨm kru sɨhanaŋga pɨrɨ nɨñɨndu tɨtɨtaya kɨndu haŋɨnɨŋ yɨvutatamandu haŋɨnɨŋɨndu pɨmɨ ha, narɨ naŋgandaya kɨyɨmandɨ. Kru tɨtɨtaya kɨndu haŋɨnɨŋ yɨvutatamamara. Abelɨyɨ kɨta patavata Berikia ñanɨŋ Sekaraiaŋ tɨmu Gotɨŋ kɨrañɨŋguhu pina, tamu Gotɨŋ kɨrañɨŋguhu tavɨ pɨrɨŋɨmbɨrɨŋ tamata yɨvutatamamara. Kamataharɨm ñamba vana kandɨhañɨndu pɨmɨ ha narɨŋambi kavɨrɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Narɨŋ yi kandɨ ambin, ñamba vana sɨhanaŋga kandɨhaŋɨnɨŋɨndu kañɨnda ha, krunavundi tɨhu kuyu nɨŋɨnɨŋ yɨvurahɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas sɨhinda ambami, Jerusalem, Jerusalem, na kru Gotɨndu kuyu mɨŋata ambavara haŋɨnɨŋ yɨvutatamandana. Kamata kru Got na kɨndanayɨ sɨmbɨhi pandu haŋɨnɨŋ mɨŋamɨŋa yɨvutatamɨrɨm tɨmba kavarandana. Sambɨ ñɨmbɨrɨ nandɨ ñɨŋisɨm haŋɨnɨŋ akakara nɨŋum nuŋandɨ ñɨŋisɨmɨŋ ambɨndɨwɨvu yɨvuñɨmbɨrɨndi maña yɨvuñɨmbɨrɨman vata andɨndin. Hara narɨ yakɨwɨrɨvarandara. ");
INSERT INTO kqa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Narɨ indarɨmara. Tɨhu narɨŋandɨ pɨhu nɨ ñambatɨta saŋgɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kamataharɨm yi narɨŋ ambin, narɨ yaŋ sɨhinda maŋgɨmandɨra. Utauta nɨmavamba ambɨrɨmandɨra, Kru Aru nɨmandu ñɨmbiyɨ payɨmi nɨmaŋ Got aviŋgaratamam, vamba ambɨrɨmandɨra, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨ ha mitata umi. Kamatɨhi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nu kɨyɨmiyɨ payɨmu. Kamata nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Gotɨŋ kɨrañɨŋguhu tavɨ ha naŋga muhɨmɨmuhɨm upɨ kandɨhañɨndu haŋɨnɨŋ isɨhuramɨndaŋ vata andɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kamatɨhura nurɨŋ kuyu nɨmata ambami, Narɨ tavɨ paŋgarɨvaŋgarɨ nɨŋɨnɨŋ ŋgara. Narɨŋ yi kandɨ ambin, tɨmba musɨmbɨrɨ ndahara mitɨtu tɨmba muhɨmbañɨ maŋgɨyɨmandɨ. Sɨhanaŋga yɨvukuvɨmbɨrata kavarɨtu mɨŋgurɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas Apu Oliv tamayɨ mɨnzɨta kɨyɨhihi, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ndaya pata nuŋ kitɨhuta ambamu, Arɨŋ ambɨna ŋgɨm. Pandɨwɨmira kandɨhamata vana haŋɨnɨŋ yɨvurahɨrɨmandɨyu. Naŋga pamata sihɨ wɨsa yɨvurahɨmandɨ. Kamati ŋgata ambɨmɨndaŋ, Jisas aŋga pati pɨrɨ nɨŋandɨhin siŋgundɨrɨmandɨ, vamba ambɨmɨndaŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kamavahu Jisas nurɨŋ kɨmbɨ ambami, Narɨ tamɨŋga naŋga kɨyɨmara. Narɨŋ kru mumɨŋga kuyusɨhɨrɨtimandɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kru sambɨ pañɨmbañɨ yandɨ ñɨmbi yɨhɨyɨhɨ ambɨrɨmandɨyu, Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata kru Got yɨhɨramami hamanda nɨ yi, vamba ambɨrɨmandɨyu. Kamata kru sambɨ kuyusɨhɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Narɨ saŋga arurundu pɨrɨndɨm indarɨmandɨra, naŋga saŋga arurundu kuyuhɨnzɨ indarɨmandɨra. Hara narɨ tamɨŋga naŋga kɨyɨmara. Narɨ mambɨndɨramara. Muhɨmɨmuhɨm kandɨhaŋɨnɨŋ yɨvurahɨmandɨ, hara imbɨhɨvɨ ha kwɨsɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kru muyɨ hati yahata kru muyɨndumuyɨndu haŋɨnɨŋ naŋga kurɨhɨrɨmandɨyu. Naŋga aru miku muŋɨnɨŋɨndu kru yahata, aru miku muyɨndumuyɨndu haŋɨnɨŋɨndu kru naŋga kurɨhɨrɨmandɨyu. Naŋga muvumuvu avɨha aru kwɨmɨrɨmandɨyu. Naŋga muvumuvu pɨrɨmama payɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Muhɨmɨmuhɨm vana kandɨhaŋɨnɨŋ, navundi ñɨŋi kavɨrɨmɨndɨhu kañɨnda atɨkimañɨ yɨvurahandi maña. ");
INSERT INTO kqa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kandɨtɨwɨmi hañɨ narɨŋ miku ŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨmandɨyu. Kamata narɨŋ pɨmɨ ŋguta yɨvutatamɨtu kwɨmɨrɨmandɨra. Yandɨ ñɨmbi narɨ naŋga kɨyɨ. Harɨm krunavundi sɨhanaŋga narɨŋambirɨm kɨtɨrɨ kɨyɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kandɨtɨwɨmi hañɨ krunavundi sambɨ yambirɨm indarɨmaŋgarandu vana ha tɨhɨmitɨrɨmandɨyu. Kamata krunavundi kandɨhaŋɨnɨŋ nurɨŋambi masamasa kɨtɨrɨ kɨta, nurɨŋambi nurɨŋandɨ miku ŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naŋga, kru Gotɨndu kuyu mɨŋata ambavaravara kuyusɨhɨrɨŋɨnɨŋ sambɨ yahata, krunavundi sambɨŋ kuyusɨhɨrɨmandɨyu. Kamatu krunavundi nurɨŋandɨ kuyusɨhɨrɨŋguyu haŋɨnɨŋ mɨŋahandɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kamatu ñamba vana haŋɨnɨŋ arutɨrɨmandɨ. Harɨm kru sambɨ muŋɨnɨŋ mɨŋata mavɨñɨ tamatama vana ha tɨhɨmitɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hara krunavundi tɨkatɨkata kɨtuhɨtu imbɨhɨvɨ ha yɨvurahɨmandɨ haŋɨnɨŋ, Got nurɨŋ aŋga mɨŋɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kamati Gotɨndu tɨwɨyɨndu kuyu avi haŋandɨhin, pɨrɨvɨsa muvumuvu sɨhanaŋga ambavarɨmandɨyu. Kamatu imbɨvu, imbɨhɨvɨ ha yɨvurahɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kamata Jisas sɨhinda ambami, Kuha kru Gotɨndu kuyu mɨŋata ambavaravara Daniel ambami, Pɨsiŋgarahara ñamba hɨmɨnɨzɨkwɨ yɨvurahɨti ŋgɨmandɨra. Ñamba hɨmɨnɨzɨkwɨ kandɨha ŋgɨtɨra Gotɨŋ kɨrañɨŋguhu tavɨ hañɨ taŋguramata kɨyɨmandɨ vamba ambami, vami. Kuyu aŋgwɨmɨkɨ nɨñɨ kɨyɨ nɨŋandɨhin kru ŋgatɨŋgɨruta ŋgɨmandɨ hama indarɨmitata ŋgam. ");
INSERT INTO kqa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kamata Jisas ambami, Kandɨtɨwɨmi hañɨ krunavundi pɨrɨvɨsa Judia kɨyɨmandɨyu haŋɨnɨŋ, tɨvaramata upɨ apu sambɨ naŋganaŋgavu yawɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kru tavɨ kɨmba hambu kɨyɨmandɨ hama, tavɨ tɨwɨ hambu mɨŋguta maku nuŋandɨ haŋɨnɨŋ mɨŋamɨŋarɨm maŋindarɨm. ");
INSERT INTO kqa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naŋga kru kɨvayɨ kɨyɨmandɨ hama, mɨkwɨrɨ kuta nuŋandɨha mɨŋɨrɨm tavɨyɨ aŋga maŋum. ");
INSERT INTO kqa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naŋga navundi mavɨnaŋga haŋɨnɨŋ naŋga navundi ñɨŋi amaŋgɨmbañɨndu naŋga haŋɨnɨŋ, kandɨtɨwɨmi hañɨ pɨmɨ aru kavɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naŋga narɨ Got naŋga kuyundavaramara. Kamata kɨmɨri tɨwɨmi naŋga Avɨrɨkɨmuhɨmu Hɨvɨ hañɨ ndahara mandɨvaramɨrɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kamataharɨm kandɨtɨwɨmi hañɨ pɨmɨ aru sɨkwɨ yɨvurahɨmandɨ. Pɨrɨ nɨ kɨhi kɨyɨmi hɨrɨvɨyɨ nda kɨta patavata tɨhu ndahara, pɨmɨ aru kandɨhamata mayɨvurahami. Naŋga muyɨvɨndahara pɨmɨ aru kandɨhamata sɨhinda mayɨvurahɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Got pɨmɨ kanɨŋɨnɨŋɨndu hɨvɨ ha kɨrɨvɨ tamamiti, krunavundi sɨhanaŋga siŋgundɨhu. Hara krunavundi nuŋandɨ vata yɨhɨramami haŋɨnɨŋɨrɨm indarɨta, kandɨhɨvɨ ha kɨrɨvɨ tamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kandɨhandɨwɨmi narɨŋ muhama nɨmavamba ambɨrɨmandɨ, Nɨŋgamara, kru Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata yɨhɨramami hama nɨŋan kɨyɨ, vamba ambɨrɨmandɨ. Naŋga muhama nɨmavamba ambɨrɨmandɨ, Ndambunda kɨyɨ, vamba ambɨrɨmandɨ. Hara narɨ kuyu kandɨhaŋɨnɨŋɨrɨm maŋindarɨmaŋgaramara. ");
INSERT INTO kqa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Naŋga kru sambɨ pata kuyusɨhɨrata ambɨrɨmandɨyu, Yi kru Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata yɨhɨramami, vamba ambɨrɨmandɨyu. Naŋga kru sambɨ pata kuyusɨhɨrata ambɨrɨmandɨyu, Yi kru Gotɨndu kuyu mɨŋata ambavaravara mɨŋga, vamba ambɨrɨmandɨyu. Kamata aru hɨmɨhɨm sihɨranzihɨra muhɨmɨmuhɨm nzihɨ andɨtutu yɨvurahɨmandɨ. Kamata krunavundi sɨhanaŋgaŋ mɨŋawɨnɨkwɨnɨtɨrɨmandɨyu. Kamata nurɨ mɨŋatandɨtaŋgata kru Got nuŋandɨ vata yɨhɨramami haŋɨnɨŋ ndahara mɨŋawɨnɨkwɨnɨtɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Narɨ indarɨmara. Yi narɨŋ muhɨmɨmuhɨm vana yɨvurahɨmandɨ nɨŋɨnɨŋɨrɨm ambavarin. ");
INSERT INTO kqa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kamataharɨm narɨŋ nɨmavamba ambɨrɨmandɨyu, Ŋgamara. Kru manɨman upɨ vunda kɨyɨ, vamba ambɨrɨmandɨyu. Hara kambu maŋumara. Naŋga nɨmavamba ambɨrɨmandɨyu, Ŋgamara. Tavɨhumba nɨñɨnɨ kɨyɨ, vamba ambɨrɨmandɨyu. Hara nurɨŋandɨ kuyu haŋandɨhirɨm maŋindarɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Narɨ ŋgandara. Ihumbɨsa nɨmbu ñɨma mɨŋaparahi, ina yahayahavu kɨta sɨñandɨta uta ina mɨŋgumɨŋguvu yɨvurahandi. Kamataharɨm Krundu Ñɨŋi hama ndahara payɨmandɨ hɨvɨyɨ sɨwɨmaña musa andɨrɨmandɨ. Kamati krunavundi sɨhanaŋga nuŋ ŋgɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Krumbat kɨmuta karɨhata kɨndi upɨyɨ taya, puŋgɨ pata tɨhɨrundu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas sɨhinda ambami, Pɨmɨ aru kandɨhaŋɨnɨŋ siŋgundɨrɨmɨnɨti, sarɨwayɨŋandi ina nɨ kɨnzɨmɨŋgwɨtɨti, takwɨ nɨ mandɨmɨrɨmandɨ. Kamati kinɨkɨ nɨŋɨnɨŋ ihumbɨsa nɨmbu mitata mɨŋaramɨrɨmandɨyu. Kamata tɨkatɨka hɨmɨŋgɨm ihumbɨsa nɨmbu kuyu haŋɨnɨŋ nandahara nanaŋgarɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kandɨtɨwɨmi hañɨ Krundu Ñɨŋi hamandu muhɨm nzihɨ ihumbɨsa nɨmbu yɨvurahɨmandɨ. Kamati krunavundi sɨhanaŋga pɨrɨ nɨñɨndu nɨŋɨnɨŋ kambirɨhɨrɨmandɨyu. Kamata ŋgɨtu Krundu Ñɨŋi hama, ihumbɨsa nɨmbu kɨta nuŋandɨ tɨkatɨka naŋga sɨña aru naŋga ihumukɨrɨ humbañɨ payɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pati kaur mɨnzataya yavɨrɨmandɨ. Kamati kutɨkara nuŋandɨ haŋɨnɨŋ sɨmbɨti pɨrɨ nɨñɨ muvumuvu uta krunavundi yandɨ vata yɨhɨramami haŋɨnɨŋ yɨvuñɨbɨrɨmandɨyu. Kamata tɨmbuhavuta payɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas sɨhinda ambami, Narɨ ahu fikɨŋ ŋgamara. Maka nuŋandɨ haŋɨnɨŋ kuku naŋgandɨta mɨkɨ haŋɨnɨŋ muvirahi ambandara, Ina tɨwɨmi kɨrɨmɨndɨhi andɨ, vamba ambandara. ");
INSERT INTO kqa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sɨwɨmaña ŋandi, muhɨmɨmuhɨm vana kanɨŋɨnɨŋ yɨvurahɨti ŋgata indarɨramata nɨmavamba ambamara, Krundu Ñɨŋi hama pata kɨndɨŋari mɨkayɨ ha kɨyɨ, vamba ambamara. ");
INSERT INTO kqa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yi narɨŋ kandɨ ambin, krunavundi tɨhu kuyu nɨŋɨnɨŋ maŋgwɨmɨtutu muhɨmɨmuhɨm vana kanɨŋɨnɨŋ yɨvurahɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pɨrɨvɨsa naŋga ihumbɨsa nɨ siŋgundɨrɨmandɨ, hara yandɨ kuyu nɨ manziŋgundɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas sɨhinda ambami, Hara kandɨ vana nɨŋɨnɨŋ yɨvurahɨmandɨ hɨvɨ ha naŋga pamata hɨrɨvɨyɨ vaha yɨvurahɨmandɨ ha kru mumɨŋga ndahara maŋgandi. Gotɨndu pɨhuyɨndu kutɨkara ndahara maŋgandu. Naŋga Krundu Ñɨŋi hama ndahara maŋgandi. Nɨŋuvandaya nu ŋgandi. ");
INSERT INTO kqa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Krundu Ñɨŋi hama parɨmɨti, muhɨmɨmuhɨm vana Noandu tɨwɨmiyɨ yɨvurahami maña yɨvurahɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kukuwɨrɨ aru ha mandaŋguhihi, ñaña kuvɨrarasɨmu. Naŋga kru, navundi urahihi, navundi kru yahurasɨmu. Kamatɨhuhu taya ututa Noa kupik aru hañɨ indɨhumi. ");
INSERT INTO kqa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nurɨ muhɨmɨmuhɨm vana kandɨhaŋɨnɨŋ nurɨŋ yɨvuraharaha vana ha maŋgamu. Kamatataya kɨyɨhuhu ututa kukuwɨrɨ aru ha taŋguta krunavundi kandɨhaŋɨnɨŋ sɨhanaŋga mɨturamami. Kamataharɨm sɨwɨmaña vana Krundu Ñɨŋi hama pati yɨvurahɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kru arɨkimbat kɨvayɨ sɨmbɨra mɨŋata kɨtuhɨtu, Got muhamaŋ mɨŋata, muhamaŋ tɨhɨmitɨti kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Navundi arɨkimbat mavatɨmbarɨm wit tarambɨruta kɨtuhɨtu, Got muhaŋambɨŋ mɨŋata muhaŋambɨŋ tɨhɨmitɨti kɨyɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kamataharɨm narɨ tamɨŋga naŋga kɨyɨmara. Narɨŋandɨ Aru hama payɨvayɨ hɨvɨ ha maŋgandarandɨhi. ");
INSERT INTO kqa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nɨmata vana nɨrɨm indarɨmitamara. Tavɨ nɨŋuva mɨŋga, kamata hɨrɨvɨyɨra kru kipa naŋga mɨŋga kɨvɨyɨ yandɨ tavɨ nɨñɨ kipa mɨŋɨrɨm payɨ vata nuŋandɨ tavɨ ha karatamahi. Kamati kipa naŋga hama nuŋandɨ tavɨ ha mɨŋavirɨhuta maŋindɨhuhi. ");
INSERT INTO kqa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kamataharɨm narɨndahara yɨvutɨmbumaŋgaramara. Krundu Ñɨŋi hama mambarɨmandɨ vɨrɨmandɨra hɨrɨvɨyɨ payɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas sɨhinda nɨmavami, Aru miku mumɨŋga, nuŋandɨ sɨmbɨrasara saŋ hañɨndu mumɨŋgaŋ ŋgahi indarɨmit avi, naŋga sɨmbɨra avindaya mɨŋandi hamaŋ yɨhɨramandi. Kamata nuŋ sɨmbɨra ŋgundi. Kamatɨhi nuŋandɨ sɨmbɨrasara saŋ mu haŋɨnɨŋ karatamandi. Kamata aru hama nurɨŋ ñaña ŋguhurɨm yɨhɨramandi hɨrɨvɨyɨ ñaña tɨŋgɨrundi. ");
INSERT INTO kqa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kru sɨmbɨra mɨŋahuhu karatamandi kandɨhamata hama sɨmbɨra kandɨha mɨŋɨtiti, nuŋandɨ aru miku hama aŋga pata ŋgɨti, kandɨhama kɨnzɨhɨnzɨtɨm. ");
INSERT INTO kqa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Narɨŋ yi kandɨ ambin, aru miku kandɨhama kru nuŋandɨ sɨmbɨra mɨŋahuhu karatamandi kandɨhamaŋ tamɨti nuŋandɨ muhɨmɨmuhɨm sɨhanaŋga karatamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hara kru sɨmbɨra mɨŋahuhu karatamandi kandɨhama kru ñamba mɨŋga. Harɨm indarɨmitata ambɨrɨmandɨ, Yandɨ aru hama mambayɨhavɨrɨmandɨ, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kamavata aru hamandu sɨmbɨrasara saŋ haŋɨnɨŋ yɨvuvarɨmandɨ. Kamata nurɨ naŋga ñaña, kru kuku hapa kuvɨrata kwɨnɨkwɨnɨtɨndu haŋɨnɨŋ naŋga kuku hapa kuvɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kamata kru sɨmbɨra mɨŋahuhu karatamandi hama nuŋandɨ aru hama payɨvayɨ hɨvɨ, naŋga pamata hɨrɨvɨyɨ vaha payɨmandɨ ha maŋgɨmandɨ. Kamata yɨvutɨmbɨmat kɨtihɨti aru hama payɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kamata aru hama kru sɨmbɨra mɨŋahuhu karatamandi kandɨhamaŋ pɨsiŋgarɨmandɨ. Kamata kru kuyusɨhɨrɨmbɨhapɨha haŋɨnɨŋ naŋga tamɨrɨmandɨ. Kamati kandɨhañɨ irɨharɨha mɨka satɨpɨrɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kamavata Jisas sɨhinda ambami, Kandɨtɨwɨmi hañɨ Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha, navundi ñaŋɨra kumanzɨpi timutamu tɨŋgɨruramɨvatɨndu vana maña kɨyɨmandɨ. Kru mumɨŋga navundi urɨrɨm andɨmi mɨŋga parɨm andɨmi. Kamatɨhi navundi ñaŋɨra kandɨhaŋɨnɨŋ umbimbuŋgɨ nurɨŋandɨ haŋɨnɨŋ mɨŋata, kru kandɨhamaŋ kɨndɨñɨ ŋgata tɨmbuta payɨm vata umu. ");
INSERT INTO kqa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Navundi kandɨhañɨndu arɨkita arɨkita kwɨrɨ indarɨmit avi naŋga ŋɨnɨŋ, arɨkita arɨkita kwɨrɨ indarɨmit avi manɨmanɨ ŋɨnɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Navundi indarɨmit avi manɨman naŋga haŋɨnɨŋ suñɨndamandu umbi nurɨŋandɨ haŋɨnɨŋ mɨŋamu. Hara kuku hapa muvɨra kuku vuŋgɨyɨ kavuŋgɨta mɨŋata mambayɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hara navundi indarɨmit avi naŋga haŋɨnɨŋ nurɨŋandɨ suñɨndamandu umbi haŋɨnɨŋ mɨŋamu. Kamata kuku hapa muvɨra kuku vuŋgɨyɨ kavuŋgɨta mɨŋata umu. ");
INSERT INTO kqa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hara kru, navundi urara hama mambayɨhavumi. Kamataharɨm navundi ñaŋɨra kandɨhaŋɨnɨŋ sɨhanaŋga akwɨmɨtandɨhi karɨhamu. ");
INSERT INTO kqa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kamata kɨvɨ itɨñɨ indarɨhu kru mumɨŋga kuyu kɨmbañɨ ambami, Indarɨmara. Kru, navundi urara hama payɨ. Harɨm patɨra uta nuŋ ŋgɨm, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kamavahi navundi ñaŋɨra kandɨhaŋɨnɨŋ sɨhanaŋga yahamɨrata nurɨŋandɨ umbi haŋɨnɨŋ sɨwɨtamamu. ");
INSERT INTO kqa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kamatɨhu navundi indarɨmit avi manɨman haŋɨnɨŋ navundi indarɨmit avi naŋga haŋɨnɨŋ ambamu, Arɨŋ narɨŋandɨ kuku hapa hañɨndu muvɨra ŋgumara. Arɨŋandɨ umbi nɨŋɨnɨŋ kwɨmɨrɨm andɨtɨhi, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kamavahura navundi indarɨmit avi naŋga haŋɨnɨŋ kɨmbɨ nɨmavamba ambamu. Kuku hapa nɨ narɨ naŋga arɨŋ kandɨ mandɨrɨmandɨ. Harɨm avinda uta kuku hapa mɨŋamɨŋa hañɨ narɨŋambirɨm mut mɨŋɨmandɨra, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kamavahu navundi indarɨmit avi manɨman haŋɨnɨŋ kuku hapa mutɨmɨŋɨrɨm uhuhu, kru, navundi urɨrɨm andɨmi hama yɨvurahami. Kamatɨhi navundi indarɨmit avi naŋga kuku hapa sɨwɨtamamu haŋɨnɨŋ, nu naŋga tavɨ hañɨ navundi urarandu tɨmu hañɨ indɨhumu. Kamatɨhu sɨkwɨtaya kru kɨndɨŋariha yɨhɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kamata kɨyɨhandata, navundi ñaŋɨra kuku hapa mut mɨŋɨrɨm umu haŋɨnɨŋ aŋga pata ambamu, Aru mɨŋga, aru mɨŋga, pata arɨŋambirɨm kɨndɨŋari nɨ pɨhɨrɨ, vamba ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kamavahura aru hama kɨmbɨ ambami, Yi narɨŋ kandɨ ambin, yi narɨŋ maŋgandin, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kamavata Jisas nurɨŋ ambami, Narɨ maŋgandara, pamata hɨvɨyɨ, naŋga pamata hɨrɨvɨyɨra vaha Krundu Ñɨŋi hama payɨmandɨ. Harɨm narɨ tamɨŋga naŋga kɨyɨmara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas sɨhinda ambami, Gotɨndu tɨwɨyɨ kɨyɨhɨyɨha kru mumɨŋga pɨhu kutañɨ urɨm andɨndi maña. Nuŋandɨ sɨmbɨrasara saŋ haŋɨnɨŋ uraramahi payɨmu. Kamata nuŋandɨ muhɨmɨmuhɨm karatamɨrɨmandɨyu vata nurɨŋandɨ kumaŋgɨmbañɨ tamami. ");
INSERT INTO kqa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kamata sɨmbɨrasara saŋ haŋɨnɨŋ mɨnza vatɨvatɨndu vana naŋga tɨkatɨkarɨm indarɨramarama tɨmbahɨrɨs haŋɨnɨŋ tɨŋgɨrumi. Kru muhamaŋ 5,000 tɨmbahɨrɨs ŋgumi. Muhamaŋ 2,000 tɨmbahɨrɨs ŋgumi. Muhamaŋ 1,000 tɨmbahɨrɨs ŋgumi. Kamata kru hama umi. ");
INSERT INTO kqa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kamatɨhi kru 5,000 tɨmbahɨrɨs mɨŋami hama 5,000 tɨmbahɨrɨs kandɨhañɨ tɨmbahɨrɨs sɨmbɨra mɨŋata sɨhinda 5,000 tɨmbahɨrɨs mu mɨŋami. ");
INSERT INTO kqa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kru 2,000 tɨmbahɨrɨs mɨŋami hama ndahara, 2,000 tɨmbahɨrɨs hañɨ tɨmbahɨrɨs sɨmbɨra mɨŋata sɨhinda 2,000 tɨmbahɨrɨs mu mɨŋami. ");
INSERT INTO kqa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hara sɨmbɨrasara saŋ 1,000 tɨmbahɨrɨs mɨŋami hama uta pɨrɨyɨ kumba kayɨvata nuŋandɨ aru hamandu tɨmbahɨrɨs ha sipɨrumi. ");
INSERT INTO kqa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kamata kutaŋgɨvɨ uhi, nurɨŋandɨ aru hama aŋga payɨmi. Kamata nurɨŋ tɨmbahɨrɨs ŋgumi haŋɨnɨŋɨrɨm kuyu mɨŋasɨrɨvɨrɨm andɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kamatɨhi kru 5,000 tɨmbahɨrɨs mɨŋami hama sɨhinda 5,000 tɨmbahɨrɨs mu naŋga mɨŋata pata nɨmavamba ambami, Aru mɨŋga nɨŋga, yaŋ 5,000 tɨmbahɨrɨs ŋgumana. Hara tɨmbahɨrɨs kandɨnɨñɨ tɨmbahɨrɨs sɨmbɨra mɨŋata sɨhinda 5,000 tɨmbahɨrɨs mɨŋamin, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kamavahi nuŋandɨ aru hama ambami, Na sɨmbɨrasara saŋ avi mɨŋga, na sɨmbɨra avi mɨŋamana. Na nandɨ sɨmbɨra ha avindamata karatamata, suksɨmbɨrɨ hɨm karatamamaŋgaramana. Harɨm na muhɨmɨmuhɨm sambɨ karatamɨrɨmana vata pirɨkɨnɨ. Kamataharɨm pata yi naŋga kɨnzɨhɨnzɨtɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kamata kru 2,000 tɨmbahɨrɨs mɨŋami hama ndahara payɨmi. Pata nɨmavamba ambami, Aru mɨŋga nɨŋga, yaŋ 2,000 tɨmbahɨrɨs ŋgumana. Hara tɨmbahɨrɨs kandɨnɨñɨ tɨmbahɨrɨs sɨmbɨra mɨŋata sɨhinda 2,000 tɨmbahɨrɨs mɨŋamin, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kamavahi nuŋandɨ aru hama ambami, Na sɨmbɨrasara saŋ avi mɨŋga, na sɨmbɨra avi mɨŋamana. Na nandɨ sɨmbɨra ha avindamata karatamata, suksɨmbɨrɨ hɨm karatamamaŋgaramana. Harɨm na muhɨmɨmuhɨm sambɨ karatamɨrɨmana vata pirɨkɨnɨ. Kamataharɨm pata yi naŋga kɨnzɨhɨnzɨtɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kamavahi kru 1,000 tɨmbahɨrɨs mɨŋami hama ndahara payɨmi. Kamata nɨmavamba ambami, Aru mɨŋga yi naŋ ŋgandin, na paña mɨŋga. Na kɨva muŋɨnɨŋ kurɨnduyɨ ndahara kayɨvandana. Naŋga pɨrɨvɨsa muyɨ kru mumɨŋga ñaña kɨrɨs sisɨvahi kandɨ tamahi ndahara nurɨŋandɨ ñaña haŋɨnɨŋ mɨŋandana. ");
INSERT INTO kqa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kamataharɨm yaŋ pɨŋitɨhi, uta nandɨ tɨmbahɨrɨs nɨ pɨrɨhumbañɨ sipɨrumin. Nandɨ tɨmbahɨrɨs hanɨ, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kamavahira nuŋandɨ aru hama kɨmbɨ nɨmavamba ambami, Na sɨmbɨrasara saŋ ñamba, na yakwɨrɨ mɨŋga. Na yaŋ ŋgamaŋgarandana. Yi kɨva muŋɨnɨŋ kurɨnduyɨ ndahara kayɨvandin. Naŋga pɨrɨvɨsa muyɨ kru mumɨŋga ñaña kɨrɨs sisɨvahi kandɨ tamandi ndahara nurɨŋandɨ ñaña haŋɨnɨŋ mɨŋandin. ");
INSERT INTO kqa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hara mumɨndɨhi tɨmbahɨrɨs yandɨha uta tɨmbahɨrɨs tamatama tavɨyɨ mandamana. Kamatamandɨti aŋga pata yandɨ tɨmbahɨrɨs ha kañɨmbɨrɨti tɨmbahɨrɨs muvɨra naŋga mɨŋahin. ");
INSERT INTO kqa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kamataharɨm 1,000 tɨmbahɨrɨs nu naŋga kɨyɨnɨ mɨŋata kru 10,000 tɨmbahɨrɨs naŋga nɨmaŋ ŋgumara. ");
INSERT INTO kqa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kru muhɨmɨmuhɨm naŋga haŋɨnɨŋ, nurɨŋ sɨhinda muvɨra ŋgurɨman. Kamatɨn nurɨŋandɨ muhɨmɨmuhɨm sambɨ kɨyɨmandɨ. Hara kru mumɨŋgandu muhɨmɨmuhɨm maŋgɨti, nuŋandɨ muhɨmɨmuhɨm kɨyɨmandɨ sɨmbɨrɨ ha, aŋga mɨŋɨman. ");
INSERT INTO kqa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Harɨm sɨmbɨrasara saŋ ñamba nɨmaŋ kavarɨtɨra tapɨra kɨvɨmɨŋgwɨ humba ndambu indɨhuta kɨyɨm. Pɨhu kɨvɨmɨŋgwɨ kandɨhañɨ irɨharɨha mɨka satɨpɨrɨmandɨyu, vamba ambami, vami. ");
INSERT INTO kqa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas sɨhinda ambami, Krundu Ñɨŋi hama aru miku maña kutɨkara sɨhanaŋga naŋga payɨmandɨ. Kandɨhɨvɨ hañɨ nuŋandɨ mɨnzɨmɨnzɨ maka aru miku ndu hañɨ mɨnzɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kamati krunavundi sɨhanaŋga pɨrɨvɨsa muvundumuvundu haŋɨnɨŋ pata nuŋandɨ kɨpumɨkayɨ tɨwɨrɨmandɨyu. Kamatu nurɨŋ tamarahata arɨkinziviyɨ tamɨrɨmandɨ. Kru sipsip karatamatama hama tamarahahi sipsip timu uhu meme tamu undu maña. ");
INSERT INTO kqa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kamata sipsip haŋɨnɨŋ nuŋandɨ kuma kandɨ sambavu tamata, meme haŋɨnɨŋ kuma kakayɨ sambavu tamɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kamata aru miku hama krunavundi nuŋandɨ kuma kandɨ sambavu kɨyɨmandɨyu haŋɨnɨŋ nɨmavamba ambɨrɨmandɨ, Yavandak narɨŋ avindamandi. Yandɨ Yava pɨrɨ nɨŋandɨhin tamami hɨrɨvɨyɨ ambami, Yandɨ tɨwɨyɨ kɨyɨmandɨyu vamba ambami. Kamataharɨm pata Yavandu tɨwɨyɨ narɨ kɨyɨmara. ");
INSERT INTO kqa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nɨmata, kuha yi avɨharɨm kɨyɨhin yaŋ ñaña ŋgumara. Yaŋ kukumɨtandɨhi kuku ŋgumara. Yi pɨhu muyɨndu mɨŋga, hara yaŋ tɨmbuta narɨŋandɨ tavɨyɨ umara. ");
INSERT INTO kqa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yandɨ mɨkwɨrɨ maŋgɨyɨhi, yaŋ mɨkwɨrɨ ŋgumara. Kandi kɨmuhin yaŋ karatamamara. Naŋga kru ñamba vana andɨhu tamandu upɨyɨ kɨyɨhin pata yaŋ ŋgamara, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kamavɨti krunavundi tɨtɨtaya kɨndu haŋɨnɨŋ kɨmbɨ nɨmavamba ambɨrɨmandɨyu, Aru mɨŋga, na pamata hɨrɨvɨyɨ avɨharɨm kɨyɨhana naŋ ñaña ŋgumarɨŋ. Naŋga pamata hɨrɨvɨyɨ naŋ kukumɨtandɨhi kuku ŋgumarɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naŋga naŋ pamata hɨrɨvɨyɨ ŋgaharɨŋ na kru pɨhu muyɨndu mɨŋga kɨyɨhana naŋ tɨmbuta arɨŋandɨ tavɨyɨ umarɨŋ. Naŋga pamata hɨrɨvɨyɨ mɨkwɨrɨ manɨman kɨyɨhana, naŋ mɨkwɨrɨ ŋgumarɨŋ. ");
INSERT INTO kqa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naŋga pamata hɨrɨvɨyɨ kandikɨmuta kɨyɨhana, naŋga kru ñamba vana andɨhu tamandu upɨyɨ kɨyɨhana uta naŋ ŋgamarɨŋ, vamba ambɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kamavɨtu aru miku hama kɨmbɨ krunavundiŋ nɨmavamba ambɨrɨmandɨ, Yi narɨŋ kandɨ ambin, muhɨmɨmuhɨm vana yaranava ñɨmbi manɨman haŋɨnɨŋɨndu muvatɨŋ andɨndara haŋɨnɨŋ, yaŋ andɨndara, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kamavata aru miku hama krunavundi nuŋandɨ kuma kakayɨ sambavu kɨyɨmandɨyu haŋɨnɨŋ nɨmavamba ambɨrɨmandɨ, Narɨ krunavundi siŋgundɨtɨŋɨnɨŋ, narɨ yaŋ mikiramata ahu tuvarata sɨhaŋgɨyɨhɨyɨ helɨyɨ umara. Ahu kandɨha Satan naŋga nuŋandɨ kutɨkara haŋɨnɨŋɨrɨm Got sɨwɨtamami. ");
INSERT INTO kqa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nɨmata, yi avɨharɨm kɨyɨhin yaŋ ñaña maŋgumara. Naŋga yaŋ kukumɨtandɨhi kuku maŋgumara. ");
INSERT INTO kqa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yi pɨhu muyɨndu mɨŋga, hara yaŋ tɨmbuta narɨŋandɨ tavɨyɨ maŋumara. Naŋga yandɨ mɨkwɨrɨ maŋgɨyɨhi, yaŋ mɨkwɨrɨ maŋgumara. Yi kandi kɨmuhin, naŋga kru ñamba vana andɨhu tamandu upɨyɨ kɨyɨhin uta yaŋ maŋgamara, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kamavɨti nurɨndahara nuŋ kɨmbɨ nɨmavamba ambɨrɨmandɨyu, Aru mɨŋga, na pamata hɨrɨvɨyɨ avɨharɨm kɨyɨhana, naŋ ñaña maŋgumarɨŋ. Naŋga pamata hɨrɨvɨyɨ naŋ kukumɨtandɨhi kuku maŋgumarɨŋ. Naŋga naŋ pamata hɨrɨvɨyɨ ŋgaharɨŋ na kru pɨhu muyɨndu mɨŋga kɨyɨhana naŋ tɨmbuta arɨŋandɨ tavɨyɨ maŋumarɨŋ. Naŋga pamata hɨrɨvɨyɨ mɨkwɨrɨ manɨman kɨyɨhana, naŋ mɨkwɨrɨ maŋgumarɨŋ. Naŋga pamata hɨrɨvɨyɨ kandikɨmuta kɨyɨhana, naŋga kru ñamba vana andɨhu tamandu upɨyɨ kɨyɨhana uta naŋ maŋguramamarɨŋ, vamba ambɨrɨmandɨyu. ");
INSERT INTO kqa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kamavɨtu nurɨŋ kɨmbɨ nɨmavamba ambɨrɨmandɨ, Yi narɨŋ kandɨ ambin, yaranava ñɨmbi manɨman nɨŋɨnɨŋɨndu muvatɨŋ kanɨmata vana nɨŋɨnɨŋ maŋandɨmara ha, kandɨ vana haŋɨnɨŋ yaŋ maŋandɨmara, vamba ambɨrɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kamata kandɨhaŋɨnɨŋ ñamba hɨm mɨŋɨrɨm urɨmandɨyu. Ñamba hɨm kandɨha kañɨnda sɨhaŋgɨyɨhɨyɨ ŋandi. Hara krunavundi tɨtɨtaya kɨyɨhɨyɨ haŋɨnɨŋ avindaya sɨhaŋgɨyɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas kuyu kanɨŋɨnɨŋ ambavarata mɨtuta, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nɨmavami, ");
INSERT INTO kqa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Narɨ ŋgandara, arɨkiŋgɨvɨ taya kɨyɨ. Kamati Got Israel Hatiŋ Mitahi Aviŋgɨyɨmu Hɨvɨ haŋandɨhinɨrɨm indarɨramarama ha yɨvurahɨmandɨ. Kamati Krundu Ñɨŋi hamaŋ miku ŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨtu ahuandɨñɨ yɨvuwɨrɨmbɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kandɨtɨwɨmi hañɨ, Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ, naŋga Israel hatindu aru miku haŋɨnɨŋ umu. Kamata Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋɨndu aru miku hamandu tavɨyɨ tɨhɨrumu. Nuŋandɨ ñɨmbi Kaiafas. ");
INSERT INTO kqa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kamata Jisasɨŋ kuyusɨhɨrata mɨŋahandata yɨvutatamɨrɨm kuyundavarata kɨndɨmbuhɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hara nɨmavamu, Got naŋga kuyundavaravarandu aru hɨvɨyɨ maŋandɨm. Kamatɨrɨŋ krunavundi ŋgatanda saŋga yahamɨrɨtumandɨhi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas pɨhu Betani Saimonɨndu tavɨyɨ kɨyɨmi. Kru kandɨhama kuha kandi lepra naŋga mɨŋga. ");
INSERT INTO kqa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kamatɨhi navundi muŋambɨ ambuŋguku vuŋgɨ, tɨmba aviyɨ musa mɨŋamu ha mɨŋata tavɨ kandɨhañɨ payɨmi. Ambuŋguku kandɨha tɨmbahɨrɨs aruyɨ mut mɨŋandu ŋandi. Kamata Jisas pina hañɨ mɨnzɨta kɨyɨhihi, navundi haŋambɨ Jisasɨndu miku hañɨ taŋgusiŋgɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kamatɨhi Jisasɨndu sɨmbɨrasara haŋɨnɨŋ kandɨha ŋgahu, nurɨŋ mavɨwɨyatɨmi. Kamata ambamu, Mumɨndɨhi ambuŋguku nɨ saŋɨnaŋga mɨtuta kɨyɨ. ");
INSERT INTO kqa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kanɨŋandɨhin mitɨrɨŋ kru muŋɨnɨŋ mut mɨŋɨtu, tɨmbahɨrɨs aru mɨŋata krunavundi muhɨmɨmuhɨm manɨman haŋɨnɨŋ ŋguharɨŋ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas nurɨŋandɨ kuyu ha indarɨta nurɨŋ nɨmavamba ambami, Narɨ mumɨndɨhi navundi nɨmɨndiŋ pɨmɨ ŋgura. Nu yaŋ avi vana andɨ. ");
INSERT INTO kqa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kru muhɨmɨmuhɨm manɨman haŋɨnɨŋ narɨ naŋga sɨhaŋgɨndu. Hara yi, narɨ naŋga sɨha maŋgɨyɨman. ");
INSERT INTO kqa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Navundi nɨmɨndi yandɨ kwɨrandɨ nɨñɨ ambuŋguku taŋgusiŋgɨ nɨ, yandɨ kwɨrandɨ nɨ tuŋgɨ humbañɨrɨm ikɨvata andɨ. ");
INSERT INTO kqa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yi narɨŋ kandɨ ambin, pɨrɨ nɨñɨ muvumuvu uta kuyu avi nɨŋandɨhin ambavarɨmandɨyu. Kamata navundi nɨŋambɨ yaŋ andɨ vana nɨrɨm indarɨmitata, ambavarɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kandɨtɨwɨmi hañɨ Jisasɨndu 12 sɨmbɨrasara hañɨndu muhama, nuŋandɨ ñɨmbi Judas Iskariot, Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ kɨyɨmuyɨ umi. ");
INSERT INTO kqa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kamata nurɨŋ nɨmavamba kitɨhumi, Jisasɨŋ narɨŋandɨ kumaŋgɨmbañɨ tamɨtɨn yaŋ muhɨmɨyɨ mut mɨŋɨmandɨra, vami. Kamavahi nuŋ 30 tɨmbahɨrɨs silva ŋgumu. ");
INSERT INTO kqa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kamatɨhu Judas Jisasɨŋ nurɨŋandɨ kumañɨ tamɨman vata kɨndɨmbuhɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mavatɨmba Yis Manɨmanɨndu Aru Hɨvɨ Haŋɨnɨŋɨndu kimaŋgima hɨvɨ hañɨ, Jisasɨndu sɨmbɨrasara haŋɨnɨŋ pata nuŋ ambamu, Upɨ paŋu umindaŋ. Kamata ñaña sɨwɨtamɨtɨrɨŋ Got Israel Hatiŋ Mitahi Aviŋgɨyɨmu Hɨvɨ haŋandɨhinɨrɨm indarɨramata ñɨrɨmana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kamavahu Jisas nurɨŋ kru mumɨŋgarɨm ambata ambami, Pɨhu aru nɨñɨ indɨhuta kru kandɨhamaŋ ŋgata ambamara, Ahusɨki hama ambi, Yandɨ hɨvɨ ha arɨñɨ payɨ. Harɨm, yi naŋga yandɨ sɨmbɨrasara haŋɨnɨŋ naŋga pata nandɨ tavɨyɨ Got Israel Hatiŋ Mitahi Aviŋgɨyɨmu Hɨvɨ haŋandɨhinɨrɨm indarɨramata ñɨmɨndaŋ, vamba ambi, vamba ambamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kamavahi sɨmbɨrasara haŋɨnɨŋ Jisas ambami maña andɨta, ñaña kandɨha sɨwɨtamamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kamata kɨvɨtiti Jisas naŋga nuŋandɨ 12 sɨmbɨrasara haŋɨnɨŋ ñaña tamatama pina hañɨ arɨndɨhuyɨvɨta mɨnzɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kamata ñata kɨñɨŋgɨñɨ ambami, Yi narɨŋ kandɨ ambin, narɨŋandɨ muvatɨ mɨŋga, yaŋ yandɨ miku ŋɨnɨŋɨndu kumañɨ tamɨrɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kamavahi, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ kuyu kandɨha indarɨhu nurɨŋandɨ mavɨ hambu pɨmɨtɨmaŋgarami. Kamatɨhi mɨnzavatɨvat nuŋ nɨmavamba kitɨhumu, Aru mɨŋga, yaŋɨrɨm vaha ambana, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kamavahu Jisas ambami, Kru yaŋ yandɨ miku ŋɨnɨŋɨndu kumañɨ tamɨrɨmandɨ hama, narɨŋandɨ muvatɨ mɨŋga. Yi naŋga maki isɨ nɨñɨ kɨhɨrɨ kumandamarɨŋ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Krundu Ñɨŋi hama, Gotɨndu aŋgwɨmɨkɨyɨ ambami maña kwɨmɨrɨmandɨ. Hara Krundu Ñɨŋi hamaŋ nuŋandɨ miku ŋɨnɨŋɨndu kumaŋgɨmbañɨ tamɨrɨmandɨ hama, pɨmɨ aru kavɨrɨmandɨ. Kru kandɨhamaŋ nɨŋum maŋgavumiti avindɨhi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kamavahi Judas, kru nuŋandɨ miku ŋɨnɨŋɨndu kumaŋgɨmbañɨ tamatama hama, nuŋ kitɨhuta nɨmavami, Ahusɨki yambirɨm vaha ambana, vami. Kamavahi Jisas ambami, Nambi ambana maña, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kamata ñata kɨyɨhuhu, Jisas mavatɨmba munda mɨŋata Gotɨŋ kuyu avivi ŋguta mɨŋasɨhɨraramata, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ŋgumi. Kamata ambami, Mɨŋata ñamara. Nɨŋandɨhin yandɨ kwɨrandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kamata kuku kuvɨrahuvɨra vuŋgɨ wain naŋga munda mɨŋata Gotɨŋ kuyu avivi ŋgumi. Kamata nurɨŋ ŋguta ambami, Narɨ sɨhanaŋga nɨñɨ kuvɨramara. ");
INSERT INTO kqa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɨŋandɨhin yandɨ ñaŋgwɨ. Got naŋga krunavundi nuŋandɨŋ sɨhanaŋga vata mɨŋavɨsɨhuramata sirɨtɨmbin. Yi ñaŋgwɨ kanɨŋandɨhin, krunavundi sɨhanaŋga ñamba vana andɨndu haŋɨnɨŋ kuŋgɨ kuyɨvɨrɨm taŋgusiŋgɨn. ");
INSERT INTO kqa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yi narɨŋ ambin, yi narɨ naŋga wain sɨhinda maŋguvɨrɨman. Kamata ututa muyɨvɨ wain kɨhi Yavandakɨndu tɨwɨyɨ narɨ naŋga kuvɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kamata, sɨhɨpuri muvana tundu pɨhu aru ha mitata, Apu Oliv tamayɨ umu. ");
INSERT INTO kqa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kamata Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ ambami, Musi kɨvɨyɨ yaŋ muhɨmɨmuhɨm vana yɨvurahɨmandɨ. Kamati ŋgɨtɨra sɨhanaŋga narɨŋandɨ indarɨmaŋgaramaŋgara vana ha mɨŋgata yɨvɨrɨmandɨ. Gotɨndu aŋgwɨmɨkɨyɨ, Got nɨmavamba ambami, Yi sipsip karatamatama hamaŋ yɨvutatamɨtɨn sipsip haŋɨnɨŋ siŋgunziŋgu tɨvaramɨrɨmandɨyu, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hara yi aŋga yahamɨrɨman. Kamata yi wɨsa kasiramata pɨrɨvɨsa Galili urɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kamavahi Pita kɨmbɨ ambami, Muhɨmɨmuhɨm vana naŋ yɨvurahɨmandɨ ha muvɨra ŋgɨtu nurɨŋandɨ indarɨmaŋgaramaŋgara vana ha mɨŋgata yɨvɨti naŋ mitɨrɨmandɨyu, hara yi naŋ mamitahandɨrɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kamavahi Jisas nuŋ ambami, Yi naŋ kandɨ ambin, musi kɨvɨyɨ, akakara kwɨsɨ pɨwɨtiti, na arɨkikwɨrɨ ñɨmbɨrɨ nɨmavamba ambɨrɨmana, Yi nuŋ maŋgandin, vamba ambɨrɨmana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kamavahi Pita ambami, Yi nanaŋga kwɨmɨrɨm ndahara kwɨmɨrɨman. Yi nuŋ maŋgandin vamba maŋambɨrɨman, vami. Kamavahi Jisasɨndu sɨmbɨrasara sɨhanaŋga kuyu sɨwɨmaña ambamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas nuŋandɨ sɨmbɨrasara haŋɨnɨŋ naŋga kɨva Getsemani umu. Kamata nurɨŋ ambami, Narɨ nɨñɨ mɨnzɨta kɨyɨmara. Yi ndambu uta Got naŋga kuyundavarɨman, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kamata, Pitaŋ naŋga Sebedindu ñɨŋi arɨkimbatɨŋ ndaya tɨmbuta kɨhɨrɨ umu. Kamatɨhi nuŋandɨ mavɨ hambu pɨmɨtɨhi, kañɨnda aru mɨŋami. ");
INSERT INTO kqa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kamatɨhi nurɨŋ ambami, Yandɨ mavɨnɨmbu pɨmɨtɨmaŋgarahi kwɨmɨrɨm andɨn. Harɨm narɨ nɨñɨ yaŋ karatamata narɨndahara tamɨŋga naŋga kɨyɨmara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kamavata sukɨsɨmbɨrɨ uhandata, mɨŋgata taraŋgɨruta nuŋandɨ kɨpumɨka ha pɨrɨyɨ tamami. Kamata Got naŋga nɨmavamba kuyundavarami, Yava, kuku kuvɨrahuvɨra vuŋgɨ nɨ yandɨ kumayɨnɨ mɨŋavɨkɨra vata pirɨkɨn, harɨm nambira. Hara yi pirɨkɨnɨ maña maŋandɨ, nambi pirɨkɨna maña andɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kamata, Jisas sɨmbɨrasara arɨkikwɨrɨvat kɨyɨmu hañɨ pata ŋgahi akwarɨhata kɨyɨmu. Kamatɨhu Pitaŋ nɨmavamba kitɨhumi, Narɨ yi naŋga mɨŋgɨya awa nda kɨta tamɨŋga naŋga maŋgɨyɨmandɨra. ");
INSERT INTO kqa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Narɨŋ mɨŋagaha vananda yɨvurahɨti mɨŋgata yɨvɨtɨrama. Kamataharɨm tamɨŋga naŋga kɨñɨŋgɨñɨ Got naŋga kuyundavaramara. Kandɨ, muhɨm vana andɨtɨrɨm pirɨkɨra. Hara narɨŋandɨ kwɨrandɨ haŋandɨhinɨndu tɨkatɨka maŋgɨyɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kamavata, Jisas sɨhinda aŋga uta Got naŋga nɨmavamba kuyundavarami, Yava, kuku kuvɨrahuvɨra vuŋgɨ nɨñɨ yaŋɨrɨm kuvɨrɨmandɨ sɨkwɨ vataŋgata, nambi pirɨkɨna maña, andɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kamata sɨhinda pata ŋgahi sɨmbɨrasara haŋɨnɨŋɨndu tamɨŋga ha pɨmɨtɨhi, karɨhamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kamata sɨhinda nurɨŋ mitatuta kwɨrɨñɨmbɨrɨ, Got naŋga kuyundavarami. Atɨyɨ kuyundavarami kuyu sɨwɨ handaya kuyundavarami. ");
INSERT INTO kqa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kamata pata ŋgahi nuŋandɨ sɨmbɨrasara haŋɨnɨŋ karɨhahu ambami, Narɨ karɨhata avɨrɨkɨmuraŋgwɨsa. Indarɨmara. Krundu Ñɨŋi hamaŋ kru ñamba vana andɨndu haŋɨnɨŋɨndu kumaŋgɨmbañɨ tamatama hɨrɨvɨ ha yɨvurahi. ");
INSERT INTO kqa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kamataharɨm yahamɨrɨtɨra narɨ naŋga umɨ. Nɨŋgamara, kru yaŋ nurɨŋandɨ kumaŋgɨmbañɨ ŋguhu hama arɨñɨ nɨ yɨvurahi ha, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas kuyundavarata kɨyɨhihi, Judas, nuŋandɨ sɨmbɨrasara hañɨndu muvat hama payɨmi. Kamatɨhi kru sambɨ tuki naŋga ahutɨmɨ mɨŋata nu naŋga payɨmu. Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ, naŋga Israel hatindu aru miku haŋɨnɨŋ sɨmbɨhu payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kru Jisasɨŋ nurɨŋandɨ kumaŋgɨmbañɨ tamatama hama nurɨŋ ambami, Kru mɨŋahandɨmɨndaŋ vata andɨra hamaŋ mɨkwɨmɨkwɨ sɨrɨman, kru kandɨhama Jisas. Nuŋ mɨŋahanadamara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kamavata, Judas sarɨwayɨŋandi Jisas kɨyɨmiyɨ pata ambami, Avi kɨvɨ Ahusɨki, vami. Kamavata Jisasɨŋ mɨkwɨmɨkwɨ sami. ");
INSERT INTO kqa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kandɨhamatɨhi Jisas ambami, Yambɨha, pana vana haŋandɨhin andɨrɨmɨŋgata andɨhavu, vami. Kamavahi kru haŋɨnɨŋ pata Jisasɨŋ mɨŋahandamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kamatɨhu kru Jisas naŋga kɨyɨmi mɨŋga nuŋandɨ tuki kuta ha mɨŋasɨharami. Kamata Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋɨndu aru miku hamandu sɨmbɨrasara hamandu kɨnzɨhimɨkɨ haŋandɨhin, yɨvutɨvɨhi pɨrɨyɨ mɨŋgata yɨvumi. ");
INSERT INTO kqa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kandɨhamatɨhira Jisas nuŋ nɨmavami, Nandɨ tuki kuta ha nuŋandɨ upɨyɨ kɨŋgɨraramɨna mɨŋgum. Kru sɨhanaŋga tuki kuta naŋga kurɨhɨrɨmandɨyu haŋɨnɨŋ, tuki kuta ha nurɨŋ pɨsiŋgarɨmandɨ. ");
INSERT INTO kqa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na mambaha ŋgandana. Yi yandɨ yavandakɨŋ kitɨwɨtɨn, nuŋandɨ kutɨkara sambɨ sɨkwɨ sɨmbɨti pata yaŋ ŋguramahu. ");
INSERT INTO kqa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hara yi kanɨmatɨnɨŋgata, kuyu Gotɨndu aŋgwɨmɨkɨyɨ kɨndi haŋɨnɨŋ kandɨsɨkwɨsɨkwɨ mayɨvurahɨrɨmandɨ. Gotɨndu aŋgwɨmɨkɨ ambami, harɨm kandɨ vana nɨŋɨnɨŋ yɨvurahɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kandɨhɨrɨvɨ hañɨndaya Jisas krunzivi kandɨhaŋɨnɨŋ nɨmavami, Narɨ tuki kuta naŋga ahutɨmɨ mɨŋata yaŋ saŋga kurɨhahurɨha naŋga kipa naŋga mɨŋgaŋ mɨŋahandɨrɨm payɨmañandɨra. Yi imutamut Gotɨŋ kɨrañɨŋguhu tavɨ hañɨndu upɨyɨ mɨnzɨta krunavundiŋ kuyu ŋgundin. Hara yaŋ kandɨtɨwɨmi haŋu mamɨŋahandandara. ");
INSERT INTO kqa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Muhɨmɨmuhɨm vana yɨvurahami kanɨŋɨnɨŋɨrɨm, kru Gotɨndu kuyu mɨŋata ambavaravara haŋɨnɨŋ yɨhimbɨvɨramu maña yɨvurahami, vami. Kandɨhamata vana andɨhu nuŋandɨ sɨmbɨrasara haŋɨnɨŋ Jisasɨŋ mitamita tɨvaramamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kru Jisasɨŋ mɨŋahandamu haŋɨnɨŋ, nuŋ tɨmbuta kru Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋɨndu aru miku Kaiafasɨndu tavɨyɨ umu. Kamatɨhu tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ tɨhɨruta kɨyɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kamatɨhu Pita Jisasɨŋ ŋgavɨramata sɨhɨndɨ umi, hara kutañɨmarɨ kɨyɨmi. Kamata Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋɨndu aru miku hamandu tavɨ tapa tapɨra hañɨ indɨhuta, kru tavɨ karatamatama haŋɨnɨŋ naŋga mɨnzɨmi. Jisasɨŋ mumɨbaham vana ha yɨvurahɨti ŋgɨtɨn vata, kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ, naŋga kru Juda hatindu kuyu mɨŋasɨrɨvandu haŋɨnɨŋ, kru muvɨra pata Jisas andɨndi vana kuyusɨhɨranzɨhɨra ambavaramu vata uraramahu payɨmu. Nuŋandɨ ñamba vana mu ŋgata, nuŋ yɨvutatamɨmɨndaŋ vata andɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kamatɨhu kru sambɨ pata nuŋ kuyusɨhɨrɨŋguyu yɨhɨvaramu. Hara kuyu sapa Jisasɨŋ yɨvutatamatama ŋandi maŋgamu. Hara kɨyɨhandata, kru arɨkimbat payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Pata ambamu, Kru nɨma nɨmavamba ambavarandi, Yi Gotɨŋ kɨrañɨŋguhu tavɨ ha yɨvukuvɨmbɨrata arɨkikwɨrɨ hɨvɨyɨ taya tararamɨrɨman, vamba ambavarandi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kamavahu Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋɨndu aru miku hama taŋguramata, Jisasɨŋ nɨmavamba kitɨhumi, Na kuyu kɨmbɨ maŋambɨrɨmana. Naŋ kuyu yɨhɨvarayu nɨŋandɨhinɨrɨm mumɨbana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kamavahira, Jisas kuyu mu maŋambami. Kamatɨhi Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋɨndu aru miku hama ambami, Naŋ Got sɨhaŋgɨyɨhɨyɨ hamandu ñɨmbiyɨ kitɨwin. Harɨm tɨhu kandɨsɨkwɨsɨkwɨ amba. Got krunavundi nuŋandɨŋ aŋga mɨŋɨmandɨ vata yɨhɨramami hamanda na. Na Gotɨndu Ñɨŋi, mana, manɨŋga, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kamavahi Jisas nuŋ nɨmavami, Nambi ambanaŋa. Hara yi narɨŋ ambin, muyɨvɨ Krundu Ñɨŋi mɨŋgaŋ ŋgɨtɨra, Got tɨkatɨka naŋga hamandu kuma kandɨ sambavu mɨnzɨrɨmandɨ. Kamata ihumbɨsa nɨmbu kɨta ihumukɨrɨ hɨmbañɨ payɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas kamavahi, Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋɨndu aru miku hama kandɨhuyu ha indarɨta, aka yahamɨrata nuŋandɨ mɨkwɨrɨ haŋɨnɨŋ mɨŋasɨhɨrata ambami, Gotɨŋ ambasuvi. Harɨm narɨ naŋga sɨhinda kru kanɨmandu vanarɨm ambavaravararɨm kru muvɨraŋ ambɨtɨrɨŋ mambayɨmu. Tɨhura Gotɨŋ ambasuvahi indarɨra. ");
INSERT INTO kqa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kamataharɨm kru kanɨmaŋ pamatɨmɨndaŋ, vami. Kamavahi kɨmbɨ ambamu, Nu ñamba mɨŋga. Harɨm kɨmum, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kamata Jisasɨndu kɨpumɨka hañɨ sɨmɨruhavɨta nuŋ yɨvumu. Kamata nuŋ muvɨra ñuŋgimbarapara tamandama ambamu, ");
INSERT INTO kqa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na Kru Got krunavundi nuŋandɨŋ aŋga mɨŋɨmana vata yɨhɨramami mɨŋga. Harɨm kru Gotɨndu kuyu mɨŋata ambavarandu haŋɨnɨŋ ambavarandu maña amba. Naŋ kru yɨvi nɨma nin, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita tapa humba hambu, tavɨ tapɨra hañɨ mɨnzɨta kɨyɨhihi, sɨmbɨrasara muhaŋambɨ nu kɨyɨmi arɨhañɨ pata, ambami. Nandahara Jisas Galilindu hama naŋga kɨndana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kamavahi, kru sɨhanaŋgandu tamɨŋganzimbɨyɨ Pita ambami. Yi ambana kuyu ha maŋgandin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kamavata kɨyɨhandata, tapa kɨndɨŋari naŋga hañɨ uhi, sɨhinda sɨmbɨrasara muŋambɨ ŋgata krunavundi arɨñɨ kɨyɨmu haŋɨnɨŋ ambami, Kru nɨma Jisas Nasaretɨndu hama naŋga kɨndi, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kamavahi Pita sɨhinda ambami, Yi kandɨsɨkwɨsɨkwɨ ambin, yi kru kandɨhamaŋ maŋgandin, vami. ");
INSERT INTO kqa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kamata sɨhinda kɨyɨhandata, kru muvɨra arɨñɨ taŋguramata kɨyɨmu haŋɨnɨŋ pata Pitaŋ ambamu, Kandɨsɨkwɨsɨkwɨ, na nurɨŋandɨ ñiŋgiñɨndu mɨŋga. Nandɨ pɨŋgwɨsamur hambu naŋ mɨŋamamañɨ ndami, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kamavahura Pita yahata patɨ ambami, Yi kandɨsɨkwɨsɨkwɨ ambin, yi kru kamaŋ maŋgandin. Yi kuyu kandɨ maŋambɨtɨn ŋgatara yaŋ Got pɨsiŋgaram, vami. Kamavahi sɨkwɨtaya akakara pɨhumi. ");
INSERT INTO kqa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kamatɨhi Pita, Jisas akakara kwɨsɨ pɨwɨtiti arɨkikwɨrɨ ñɨmbɨrɨ yambirɨm ambata, Nuŋ maŋgandin vɨrɨmana vamba ambami kuyu haŋandɨhinɨrɨm indarɨmitami. Kamata tapɨrañɨ indɨhuta patɨŋandi irɨhami. ");
INSERT INTO kqa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kamata pɨhɨrɨhi, Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ sɨhanaŋga, Jisasɨŋ yɨvutatamɨndaŋ vata kuyu kahañamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kamata mɨtuta, Jisasɨŋ wɨrɨmbɨnzikiyɨ sɨmahata tɨmbuta uta, Pailat Rom gavamandu aru miku hamandu kumaŋgɨmbañɨ tamamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kru Jisasɨŋ nuŋandɨ miku ŋɨnɨŋɨndu kumañɨ tamami hama Judas, ŋgahi Jisasɨŋ ŋgatɨŋgɨruta pɨmɨ ŋgumu. Kamatɨhu nuŋandɨ indarɨmit hambu tɨvɨrami. Kamatɨhi 30 tɨmbahɨrɨs silva nuŋ Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga Israel hatindu miku haŋɨnɨŋ ŋgumu haŋandɨhin, nurɨ kɨyɨmuyɨ aŋga mɨŋata umi. ");
INSERT INTO kqa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kamata ambami, Yi ñamba vana andɨn. Kru narɨŋandɨ kumaŋgɨmbañɨ tamin hama ñamba vana maŋandɨndi, hara nuŋ yɨvutatamɨrɨmandɨra, vami. Kamavahira nuŋ ambamu, Kaŋandɨhin arɨŋandɨ vana ma. Pɨmɨ ha nandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kamavahu Judas tɨmbahɨrɨs haŋɨnɨŋ Gotɨŋ kɨrañɨŋguhu tavɨhumba hambu kahuvarahi indɨhumi. Kamata uta nuŋambi sikiyɨ taŋgɨraramata kɨmumi. ");
INSERT INTO kqa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kamatɨhi Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ tɨmbahɨrɨs kandɨha mɨŋata nɨmavamu, Tɨmbahɨrɨs nɨŋandɨhin kru yɨvutatamatamandu tɨkwɨ ŋandi. Harɨm tɨmbahɨrɨs kanɨŋandɨhin Gotɨŋ kɨrañɨŋguhu tavɨ nɨñɨndu tɨmbahɨrɨs naŋga mɨnzayɨ mandamɨmɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kamata tɨmbahɨrɨs kandɨharɨm mɨŋgɨya kuyu taya kahañamu. Kamata tɨmbahɨrɨs kandɨhañɨ kru pɨrɨ sɨŋgɨ musa mɨŋandu haŋɨnɨŋɨndu pɨrɨvɨsa mu mut mɨŋamu. Pɨrɨvɨsa kandɨha kru kutañɨ ŋgati kwɨmɨtutu tamɨmandɨyu vata, mut mɨŋamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kamataharɨm pɨrɨvɨsa kandɨhaŋu, Pɨrɨvɨsa Kru Ñaŋgwɨ Mɨŋgumɨŋgu vava ñɨmbi ŋgumu. Kuha ñɨmbi kandɨhañɨ ndaya yɨhɨrasɨmu, patavata tɨhu ndahara ñɨmbi kanɨñɨ ndaya yɨhɨndu. ");
INSERT INTO kqa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Kamataharɨm kuyu mu, kuha Got ambahi kru Gotɨndu kuyu mɨŋata ambavaravara, Jeremaia ambami, 30 tɨmbahɨrɨs silva haŋandɨhin mɨŋamu. Tɨmbahɨrɨs kandɨha Israel hati kru kandɨhamaŋ mut mɨŋamɨŋarɨm yɨhɨramamu. Aru nɨma yaŋ ambami maña tɨmbahɨrɨs kandɨhañɨ, kru pɨrɨ sɨŋgɨ musa mɨŋandi hamarɨm pɨrɨvɨsa mut mɨŋamu, vami. Kamataharɨm kandɨ vana ha Jeremaia ambami maña kandɨsɨkwɨsɨkwɨ yɨvurahami. ");
INSERT INTO kqa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas Rom gavamandu aru miku Pailatɨndu tamɨŋgañɨ taŋguramata kɨyɨmi. Kamatɨhi Pailat nuŋ nɨmavamba kitɨhumi, Na Juda hatindu aru miku vaha, vami. Kamavahi Jisas ambami, Nambi ambana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kamavahi, Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ, Jisasɨŋ ihɨvarɨŋguyu sambɨ ŋgumu. Kamatɨhura Jisas kuyu kɨmbɨ maŋambami. ");
INSERT INTO kqa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kamatɨhi nuŋ sɨhinda Pailat kitɨhuta nɨmavami. Naŋ sɨhanaŋga kuyu yɨhɨvarayu nɨmbu mambaha indarɨna, vami. ");
INSERT INTO kqa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kamavahira, Jisas Pailatɨndu kuyu haŋandɨhinɨrɨm kɨmbɨ kuyu maŋambami. Kamatɨhi Pailat indarɨhɨtɨhɨtɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mɨŋgɨya simbi mɨŋgɨya simbindu mɨnza hɨvɨyɨ taya, Got Israel Hatiŋ Mitahi Aviŋgɨyɨmu Aru Hɨvɨ haŋandɨhinɨrɨm indarɨramarasɨmu. Kandɨhamatɨrasɨmu hɨvɨyɨ gavamandu aru miku hama kru ñamba vana andɨhu tamandu upɨyɨndu mɨnzavat mɨŋgaŋ ndaya tɨhɨmitarasɨmi. Krunavundi nurɨŋambi, kru ñamba vana andɨhu tamandu upɨ hañɨndu mɨnzavat hamandu ñɨmbi yɨhɨrasɨmu. Kamatɨhu kru kandɨhamaŋ tɨhɨmitahi nurɨ kɨnduyɨ urasɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kandɨtɨwɨmi hañɨ, kru mumɨŋga kru ñamba vana andɨhu tamandu upɨyɨ kɨyɨmi. Nuŋandɨ ñɨmbi, Jisas Barabas, krunavundi nuŋ ŋgamaŋgarandu. Nu kru ñamba sɨkwɨ mɨŋga. ");
INSERT INTO kqa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kamata krunavundi pata tɨhɨruhu, nurɨŋ Pailat nɨmavamba kitɨhumi, Narɨŋɨrɨm kru ninɨŋ ndɨmbanzɨkwɨ tɨhɨmitɨnɨ urɨmandɨ. Jisas Barabasɨŋ tɨhɨmitɨnɨ urɨmandɨ, mana, Jisas krunavundiŋ aŋga mɨŋɨmandɨ vata Got yɨhɨramami vamba ambandu nɨmaŋ tɨhɨmitɨnɨ urɨmandɨ, vami. ");
INSERT INTO kqa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat nurɨŋ ŋgami. Nurɨ sɨŋgɨrata Jisasɨŋ saŋɨnaŋga tɨmbuta ŋgatɨŋgurɨm payɨmu. Harɨm kandɨhamavami. ");
INSERT INTO kqa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat ŋgatɨŋgɨrutɨŋgɨru hamandu mɨnzɨmɨnzɨ maka hañɨ mɨnzɨta kɨyɨhihi nɨmburi nɨmavamba, kuyu tamahi payɨmi. Kru tɨtɨtaya kɨyɨhɨyɨ hamaŋ muhɨm vana maŋandɨ. Kɨvɨyɨ nuŋ akwɨsɨhuyɨ ŋgin. Kamata indarɨhin pɨmɨsaŋɨnzaŋɨndɨ. Kanɨmavamba, kuyu tamahi payɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gotɨŋ kɨrañɨŋguhundu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ, sɨhanaŋga krunavundiŋ mɨŋawɨnɨkwɨnɨtɨndɨ, ambamu, Ambɨtɨra Pailat Barabasɨŋ mitɨti payɨm. Kamata Jisasɨŋ yɨvutatamam, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kamata, sɨhinda gavamandu aru miku hama nurɨŋ kitɨhuta ambami, Narɨ kru arɨkimbat nɨñɨndu ninɨŋ ndaya yambirɨm tɨhɨmitam vata pirɨkɨra, vami. Kamavahi krunavundi sɨhanaŋga ambamu, Barabas, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kamavahu Pailat nurɨŋ nɨmavamba kitɨhumi, Ara Jisas, Got krunavundiŋ aŋga mɨŋɨmandɨ vata yɨhɨramami vamba ambandu nɨmaŋ yaŋɨrɨm pamatɨtɨrɨm pirɨkɨra, vami. Kamavahi sɨhanaŋga ambamu, Ahuandɨñɨ yɨvuwɨrɨmbu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kamavahu Pailat nurɨŋ kitɨhumi, Mumɨrɨm, nu ñamba vana pamatavu andɨndi, vami. Hara krunavundi patɨvat pɨhuravɨmbɨhurav ambamu, Nuŋ ahuandɨñɨ yɨvuwɨrɨmbu, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kamatɨhu Pailat ŋgata, yandɨ kuyu maŋindarɨmandɨyu, naŋga saŋga aru yɨvurahɨmandɨ, vamba indarɨmi. Harɨm kuku nɨkɨrɨ mɨŋata krunavundindu tamɨŋgañɨ nuŋandɨ kuma ha ñɨmburɨmi. Kamata ambami, Kru nɨma kwɨmɨti ndahara yi pɨmɨ maŋgavɨrɨman. Kaŋandɨhin narɨŋandɨ vana, vami. ");
INSERT INTO kqa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kamavahi krunavundi sɨhanaŋga kɨmbɨ nɨmavamu, Pɨmɨ kandɨnɨ arɨŋ naŋga arɨŋandɨ ñɨŋisɨmɨŋɨra kɨyɨm, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kamavahu Pailat Barabasɨŋ tɨhɨmitahi nurɨŋɨrɨm umi. Kamata saŋganzara haŋɨnɨŋ ambahi Jisasɨŋ pɨŋgɨrawɨsɨmu. Kamata kɨta Jisasɨŋ ahuandɨñɨ yɨvuwɨrɨmbɨmandɨyu vata, saŋganzarandu kumañɨ tamami. ");
INSERT INTO kqa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kamata gavamandu aru miku hama nuŋandɨ saŋganzara haŋɨnɨŋ ambahi, Jisasɨŋ tɨmbuta Rom gavamandu tavɨyɨ indɨhumu. Kamatɨhu saŋganzara sɨhanaŋga pata nuŋandɨ kɨpumɨkayɨ tɨhɨrumu. ");
INSERT INTO kqa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kamata nuŋandɨ mɨkwɨrɨ haŋandɨhin sɨharamu. Sɨharata nuŋ mɨkwɨrɨ ñaŋgwɨ aru miku ndu maña ŋandi tamaramamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kamata siki punzɨmbunzɨ naŋga haŋandɨhin mɨŋata, aru miku ndu mɨraŋgupihupi maña musa mɨŋata nuŋandɨ miku hañɨ tamamu. Kamata nuŋandɨ kuma kandɨ samba hambu kuki tɨmɨ mu mɨŋandɨhuramamu. Kamata nuŋɨrɨm tanda mɨkwɨmɨkwɨtɨndɨ nɨmavamba ambasuvamu, Aviŋgɨvɨ Juda hatindu aru miku, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kamatɨndɨ nuŋ sɨmɨruhavɨmu. Kamata kuki tɨmɨ mɨŋandɨhuramamu ha mɨŋata, nuŋandɨ miku hañɨ yɨvumu. ");
INSERT INTO kqa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nuŋ ambasuvasuva vana andɨta mɨtuta, mɨkwɨrɨ tamaramamu haŋandɨhin sɨharata nuŋandɨ mɨkwɨrɨ haŋandɨhin tamaramamu. Kamata nuŋ ahuandɨñɨ yɨvuwɨrɨmbɨrɨm tɨmbuta umu. ");
INSERT INTO kqa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kamata uta, saŋganzara haŋɨnɨŋ pɨhu aru Sairinindu, kru Saimonɨŋ ŋgamu. Kamata andɨhu Jisasɨndu ahuandɨ ha kavumi. ");
INSERT INTO kqa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kamata uta upɨ Golgota yɨvurahamu. Ñɨmbi Golgotandu kuyu sapa ha, miku muŋgɨyɨndu punzɨndu upɨ varasɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kamata upɨ kandɨhañɨ, Jisasɨŋ kañɨnda mɨŋguramam vata, wain kuku haŋandɨhin akɨŋgɨm naŋga tarayɨwarata kuvɨrɨmandɨ vata, ŋgumu. Kamatɨhu kuvɨrɨrɨmɨndɨhi akɨndɨhi maŋguvɨrami. ");
INSERT INTO kqa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jisasɨŋ ahuandɨñɨ yɨvuwɨrɨmbuta mɨtuta, saŋganzara haŋɨnɨŋ nuŋandɨ mɨkwɨrɨ haŋɨnɨŋ nurɨŋambi tamarahata mɨŋɨmɨŋɨndaŋ vata, atava imbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kamata kandɨ upɨ haŋu mɨnzɨta nuŋ karatamamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kamata ahu parapara sɨŋga kɨrɨvɨ ŋandi pɨtɨta, nuŋ kuyu ŋgatɨŋgɨrumu ha yɨhimbɨvɨrata nuŋandɨ miku tarayawɨ hambu tamamu. Nɨmata kuyu yɨhimbɨvɨramu. Kru nɨma Jisas, Juda hatindu aru miku. ");
INSERT INTO kqa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisas kɨyɨmi tɨvɨ hañɨ, kru arɨkimbat saŋga kurɨhahurɨha naŋga kipa naŋga haŋɨnɨŋ ndahara ahuandɨñɨ yɨvuwɨrɨmbuta tararamamu. Muhamaŋ, kandɨ sambavu tararamata, muhamaŋ kakayɨ sambavu tararamamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Kamatɨhu, krunavundi uhuvañɨndɨndɨ ambasuvanzuva, miku tɨwahandɨwaha nɨmavamu. Na Gotɨŋ kɨrañɨŋguhu tavɨ haŋandɨhin yɨvukuvɨmbɨrata, arɨkikwɨrɨ hɨvɨyɨ taya tararamarama mɨŋga. Harɨm nambi ŋgurama. Kandɨsɨkwɨsɨkwɨ na Gotɨndu Ñɨŋitiŋgata ahuandɨ ha mitata mɨŋga, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga tɨkatɨka kuyundu mirɨmba naŋga haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ ndahara sɨwɨmañanzihɨ andɨndɨ ambasuvamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nɨmavamba ambamu, Nu kru muŋɨnɨŋ ŋguramandi. Hara nuŋambi maŋgurami. Nu Israel hatindu aru miku. Harɨm ahuandɨ nɨ mitata mɨŋgɨti ŋgatanda nɨŋambirɨm indarɨmaŋgarɨmɨndaŋ. ");
INSERT INTO kqa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nu Gotɨrɨm indarɨmaŋgarata ambandi, Yi Gotɨndu Ñɨŋi, vamba ambandi. Harɨm Got nuŋɨrɨm mavɨndamata ŋgata, nuŋ tɨhu ŋguramɨrɨmandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kru arɨkimbat saŋga kurɨhahurɨha naŋga kipa naŋga haŋɨnɨŋ, Jisasɨndu tɨvɨ hañɨ ahuandɨñɨ yɨvuwɨrɨmbumu haŋɨnɨŋ ndahara, Jisasɨŋ ambasuvamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ina mɨrɨyɨ kɨyɨhi, pɨrɨvɨsa sɨhanaŋga kɨvɨmɨŋgwɨ tarɨŋgumi. Kamatɨhi taya uta ina mɨŋguta saŋgindaŋgumi. ");
INSERT INTO kqa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kamata ina mɨŋguta saŋgindaŋgumi hɨrɨvɨyɨ, Jisas patɨ avaŋgarata ambami, Eli Eli lema sabaktani, vami. Kandɨ kuyu nɨñɨndu kuyu sapa ha nɨmata. Yandɨ Got, yandɨ Got, mumɨrɨm yaŋ mitana. ");
INSERT INTO kqa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kamavahi kru muvɨra arɨñɨ taŋguramata kɨyɨmu haŋɨnɨŋ indarɨta ambamu. Kru nɨma Elaijaŋ urarami, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kamavahi sarɨwayɨŋandi nurɨŋandɨ muvatɨ hama tɨvɨta uta spans vɨsa mɨŋata wain kuku ahɨvɨ hañɨ tamami. Kamatɨhi wain yavurɨhi kuki tɨmɨ muyɨ sɨmahata, Jisasɨrɨm kuvɨrɨmandɨ vata, ŋgumi. ");
INSERT INTO kqa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kamatɨhi muvɨra ambamu, Mitɨna ŋgɨmɨŋgusa. Elaija pata nuŋ ŋguramɨrɨmandɨ vaha, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kamata Jisas sɨhinda patɨ avaŋgarata kɨmumi. ");
INSERT INTO kqa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kamatɨhi kandɨhɨrɨvɨ hañɨndaya mɨkwɨrɨ aru, Gotɨŋ kɨrañɨŋguhu tavɨyɨ inanandɨta kɨrasɨmi haŋandɨhin, kɨmba hambu kɨta sɨhɨrata mɨŋguta aŋgamɨŋga hambu yɨvurahami. Kamata arɨkinzɨŋga yɨvurahami. Kamatɨhi pɨrɨ nɨ namanama tɨhi, tɨmba aruru haŋɨnɨŋ pɨhumbɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kamatɨhi krunzava haŋɨnɨŋ pirɨhumi. Kamatɨhi Gotɨndu krunavundi muvɨra kuha kɨmumu haŋɨnɨŋ kandɨhandɨwɨmi yahamɨramu. ");
INSERT INTO kqa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yahamɨrata kɨyɨhuhu, Jisas aŋga yahamɨrata mɨtuhi, Gotɨndu pɨhu aru Jerusalem indɨhumu. Kamatɨhu krunavundi sambɨ nurɨŋ ŋgamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Saŋganzarandu arumiku hama naŋga, saŋganzara Jisasɨŋ karatamata kɨyɨmu haŋɨnɨŋ, ŋgahu pɨrɨmama payɨhi muhɨmɨmuhɨm vana yɨvurahahi ŋgata pɨŋisaŋarandumu. Kamata nɨmavamu, Kandɨsɨkwɨsɨkwɨ, kru nɨma Gotɨndu Ñɨŋi, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Navundi Galilindu sambɨ Jisas naŋga kɨndaŋgɨnda nuŋ ŋguramandu haŋɨnɨŋ ndahara kɨyɨmu. Navundi kandɨhaŋɨnɨŋ kutañɨmarɨ taŋguramata tɨhɨraramamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Navundi kandɨ ñiŋgi hañɨndu muhambɨ, Maria pɨhu aru Makdalandu ŋambɨ. Muhaŋambɨ, Maria Jems naŋga Josep nɨŋum. Ara muhaŋambɨ, Sebedindu ñɨŋi arɨkimbat nɨŋum. ");
INSERT INTO kqa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kamata kɨvɨtiti kɨvɨtɨrɨm andɨhitɨhi, kru tɨmbahɨrɨsɨndu arɨku mɨŋga pɨhu aru Arimateandu mɨŋga, nuŋandɨ ñɨmbi Josep, kandɨhama payɨmi. Josep kandɨhama ndahara Jisasɨndu sɨmbɨrasara muvatɨ mɨŋga. ");
INSERT INTO kqa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nu Pailat kɨyɨmiyɨ, kitɨwɨtɨn aria vɨtiŋgata Jisasɨndu patɨ ha mɨŋɨman vata, payɨmi. Kamatɨhi Pailat ambahi, saŋganzara haŋɨnɨŋ patɨ ha mɨŋata Josepɨŋ ŋgumu. ");
INSERT INTO kqa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kamatɨhu Josep mɨŋata patɨ ha mɨkwɨrɨ ñaŋɨra suñɨyɨ taparami. ");
INSERT INTO kqa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","61","Kamata Josep, Jisasɨndu patɨ ha mɨŋata uta sava humba nuŋandɨ kɨhiyɨ tamami. Sava humba kandɨha ambahi kru tɨmbayɨ kuhanda musa mɨŋahu saŋ kɨndi. Kamatɨhihi Maria pɨhu aru Makdalandu haŋambɨ naŋga, Maria muhaŋambɨ ndahara arɨñɨ mɨnzɨta tɨhɨraramamu. Kamatɨhuhu Josep tɨmba muŋgɨ aru muŋandi tɨhuyaparahi payɨhi, kumba mɨka ha yɨvuvihɨta umi. ");
INSERT INTO kqa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Avɨrɨkɨmuhɨmu Hɨvɨyɨrɨm muhɨmɨmuhɨm sɨwɨtamatama hɨvɨ ha sɨrɨvami. Kamatɨhi amut Avɨrɨkɨmuhɨmu Hɨvɨ hañɨ Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ, naŋga Farisi haŋɨnɨŋ uta Pailatɨŋ ŋgamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kamata nuŋ ambamu, Aru mɨŋga, ara kru kuyusɨhɨrɨ naŋga hama kɨñɨŋgɨñɨ kuyu mu ambamirɨm indarɨmitarɨŋ. Ambami, Yi arɨkiŋgɨvɨ kɨta, kwɨrɨ hañɨ aŋga yahamɨrɨman, vamba ambami. ");
INSERT INTO kqa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kamataharɨm ambɨna kumba mɨka haŋandɨhin yɨhɨñamaŋgarɨtu arɨkikwɨrɨ hɨvɨ kɨyɨm. Nuŋandɨ sɨmbɨrasara haŋɨnɨŋ pata nuŋandɨ patɨ haŋandɨhin kipa mɨŋata uta krunavundiŋ ambɨrɨmandɨyu. Sava humba ha mitata aŋga yahamɨri vamba ambɨrɨmandɨyu. Kamatu nurɨŋandɨ kuyusɨhɨrɨŋguyu kɨhi haŋandɨhin, nuŋandɨ kuyusɨhɨrɨŋguyu kuha ambami haŋandɨhin taratɨvɨrɨmandɨ, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kamavahu Pailat nurɨŋ ambami, Saŋganzaraŋ tɨmbututa ambɨtɨra sava hañɨ karatamata kɨyɨmu. Narɨ uta narɨŋandɨ indarɨmitɨyɨ muhɨmɨmuhɨm vana andɨta sava hañɨndu kumba mɨka ha yɨhɨvihɨmaŋgaramara, vami. ");
INSERT INTO kqa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kamavahi uta sava hañɨndu kumba mɨka ha yɨhɨvihɨmaŋgaramu. Kamata tɨmba hɨmba hañɨ kuŋgɨ yɨvuta tamata, saŋganzaraŋ tamahu sava ha karatamamu. ");
INSERT INTO kqa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Avɨrɨkɨmuhɨmu Hɨvɨ ha umi. Kamatɨhi kimaŋgima hɨvɨ hañɨ paka pɨhɨrɨhihi, Maria pɨhu aru Makdalandu haŋambɨ naŋga Maria muhaŋambɨ, Jisasɨndu sava ha ŋgɨmɨndaŋ vata, payɨmu. ");
INSERT INTO kqa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kamatɨhuhu Aru nɨmandu kutɨkara Gotɨndu pɨhuyɨ kɨta mɨŋgami. Kamatɨhi pɨrɨmama aru sɨkwɨ payɨmi. Kamata kutɨkara hama tɨmba muŋgɨ kumba mɨka yɨvuvihɨmi haŋandɨhin tɨhuyaparahi tɨvɨmbu umi. Kamata kandɨ hɨmba hañɨ mɨnzɨta kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kutɨkara hamandu kɨpumɨka ha ñɨma mɨŋaparahi sɨñandɨ maña sɨñandɨmañandɨmi. Kamatɨhi nuŋandɨ mɨkwɨrɨ haŋandɨhin ndahara ihumukɨrɨ maña kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kamatɨhi saŋganzara haŋɨnɨŋ nɨŋambirɨm pɨŋitɨhi, nanaŋgarata, kɨmuhɨmu ŋɨnɨŋ maña yɨvurahamu. ");
INSERT INTO kqa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kamatɨhu Aru nɨmandu kutɨkara hama yahata navundi arɨkimbatɨrɨm nɨmavami, Pɨŋimandumara. Yi narɨŋ ŋgin, narɨ Jisas kru ahuandɨñɨ yɨvuwɨrɨmbusɨmu hamaŋ ŋgɨrɨm para. ");
INSERT INTO kqa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nu nɨñɨ maŋgɨyɨ. Nuŋambi kuha ambami maña yahamɨri. Narɨ arɨkimbat pata upɨ karɨhasɨmi nɨŋandɨhin ŋgamara. ");
INSERT INTO kqa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamataharɨm narɨ arɨkimbat aŋga uhavuta nuŋandɨ sɨmbɨrasara haŋɨnɨŋ nɨmavamba ambamara, Nu sava humba ha mitata aŋga yahamɨri. Indarɨmara, nuwɨsa kasiramata Galilivu uyɨ, harɨm nuŋ kandɨhambu ŋgɨmandɨra, vamba ambamara. Yi kuyu kandɨnɨ narɨŋ ambavarɨrɨm pan, vami. ");
INSERT INTO kqa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Navundi arɨkimbat pɨŋisaŋarandɨmu, hara kɨnzɨhɨnzɨtɨmaŋgaramu. Kamata sarɨwayɨŋandi sava ha mitata tɨvaramata Jisasɨndu sɨmbɨrasara haŋɨnɨŋ ambavarɨrɨm umu. ");
INSERT INTO kqa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kamatɨhu Jisas arɨkimbatɨŋ kɨndɨñɨ ŋgata nɨmavami, Kɨvɨsɨhu vami. Kamatɨhi arɨkimbat nu kɨyɨmi arɨhañɨ uta, nuŋandɨ tandanzambɨrɨ hañɨ mɨŋahandata nuŋandɨ ñɨmbi tɨhuyahamu. ");
INSERT INTO kqa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kamatɨhu Jisas arɨkimbatɨŋ nɨmavami, Pɨŋimandumara. Narɨ arɨkimbat uta ambɨtɨra yaranava Galilivura umu. Yaŋ kandambu ŋgɨmandɨyu, vami. ");
INSERT INTO kqa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Navundi arɨkimbat uhuhu, saŋganzara Jisasɨndu sava karatamata kɨyɨmu hañɨndu muvɨra pɨhu aru hañɨ indɨhumu. Kamata Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ muhɨmɨmuhɨm vana yɨvurahamirɨm ambavaramu. ");
INSERT INTO kqa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Kamatɨhu Gotɨŋ kɨrañɨŋguhu haŋɨnɨŋɨndu aru miku haŋɨnɨŋ naŋga Israel hatindu aru miku haŋɨnɨŋ tɨhɨruta, kuyu mu sɨmahamu. Kamata saŋganzara haŋɨnɨŋ tɨmbahɨrɨs sambɨ ŋguta, ambamu, Uta nɨmavamba ambamara, Kɨvɨyɨ karɨhaharɨŋgarɨŋ, nuŋandɨ sɨmbɨrasara haŋɨnɨŋ pata nuŋandɨ patɨ ha kipa mɨŋayu, vamba ambamara. ");
INSERT INTO kqa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kamatɨra gavamandu aru hama kuyu kanɨŋandɨhin indarɨta narɨŋ yɨvutatamɨrɨmɨtiŋgata, arara nu naŋga kuyu mɨŋasɨrɨvɨm. Kamatɨrɨŋ narɨ kuyu maŋgavɨrɨmandɨra, vamu. ");
INSERT INTO kqa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kamavahu saŋganzara haŋɨnɨŋ tɨmbahɨrɨs haŋandɨhin mɨŋata, aru miku haŋɨnɨŋ ambaramamu mañamaña andɨmu. Kamatɨhu kuyu kanɨŋandɨhin Juda hati indarɨta mɨtumu. Juda hati kuyu kanɨŋandɨhinɨrɨm ambavararasɨmu. Patavata tɨhu ndahara kuyu sɨwɨmaña ndaya ambavarandu. ");
INSERT INTO kqa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kamata 11 sɨmbɨrasara haŋɨnɨŋ Galilirɨm umu. Uta Jisas apu ambami hañɨ yɨvurahamu. ");
INSERT INTO kqa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kamata Jisasɨŋ ŋgata, nuŋandɨ ñɨmbi tɨhuyahamu. Hara sɨmbɨrasara muvɨrandu indarɨmit arɨkita kɨyɨmi. ");
INSERT INTO kqa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kamatɨhu Jisas arɨhañɨ pata nurɨŋ nɨmavami, Got nuŋandɨ pɨhuyɨndu naŋga pɨrɨ nɨñɨndu muhɨmɨmuhɨm karatamatarɨm yaŋ ñɨmbi ŋgumi. ");
INSERT INTO kqa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kamataharɨm uta krunavundi sɨhanaŋga pɨrɨvɨsa muvundumuvundu andɨtɨra yandɨ sɨmbɨrasara yɨvurahamu. Kamatɨndɨ, Yavandu ñɨmbiyɨ, naŋga nuŋandɨ Ñɨŋindu ñɨmbiyɨ, naŋga nuŋandɨ Mavɨñɨŋindu ñɨmbiyɨ kukuyɨ mɨŋaŋgɨrumara. ");
INSERT INTO kqa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kamata yi narɨŋ kuyu ŋgumin haŋɨnɨŋ sɨhanaŋga nurɨŋ ambaramamara. Kamatɨra kuyu kandɨhaŋɨnɨŋɨndaya mɨŋahandamu. Indarɨmara. Yi imutamut narɨ naŋga kɨndin. Ututa pɨrɨ nɨŋandɨhin naŋga muhɨmɨmuhɨm siŋgundɨrɨmandɨ.");
ALTER TABLE kqa_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
