﻿USE sofia;
DROP TABLE IF EXISTS sofia.kpx_vpl;
CREATE TABLE kpx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kpx_vpl WRITE;
INSERT INTO kpx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kou Iesu Keliso buluve deiadaike ko. Iesuu Ebalahamuta Deividita valadamo lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Subuta mole Ebalahamuu Aisiki mamonu. Ige Aisikiu Diekobo mamonu. Ige Diekobou Diuda isi hohuvuiabe houevenu. ");
INSERT INTO kpx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ige Diudau Tamati Belesita Silata houevelu. Ige Belesiu Heseloni mamonu. Ige Heseloniu Alamu mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ige Alamuu Aminadabu mamonu. Ige Aminadabuu Nasoni mamonu. Ige Nasoniu Samoni mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ige Samoniu Leiabuti Boasi mavolu. Ige Boasiu Lutati Obedi mavolu. Ige Obediu Diesi mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ige Diesiu kosive Deividi mamonu. Ige Deividiu Ulaia mahina melamei Solomoni mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ige Solomoniu Liabomu mamonu. Ige Liabomuu Abaisa mamonu. Ige Abaisau Esa mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ige Esau Diosabati mamonu. Ige Diosabatiu Diolamu mamonu. Ige Diolamuu Usaia mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ige Usaiau Diotamu mamonu. Ige Diotamuu Ahasi mamonu. Ige Ahasiu Hesekaia mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ige Hesekaiau Manasa mamonu. Ige Manasau Amoni mamonu. Ige Amoniu Diosaia mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ige Diosaia keu Diekonaia mamoi hohuvuiabeta houevenu. Vani kela Babulonia ataeau lohoale Iselala ata moaga umudievei malevei abu vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kebia malevei tisege iaeabe Diekonaia keu Siatieli mamonu. Ige Siatieliu Selubabeli mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ige Selubabeliu Abudi mamonu. Ige Abudiu Eliakimi mamonu. Ige Eliakimiu Eso mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ige Esou Sadoki mamonu. Ige Sadokiu Akimi mamonu. Ige Akimiu Eludi mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ige Eludiu Eliesa mamonu. Ige Eliesau Matani mamonu. Ige Mataniu Diekobo mamonu. ");
INSERT INTO kpx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ige Diekobou Dioseba mamonu. Ige Diosebau Meli melamenu. Ige Meliu Iesu mamonu. Ige Iesu ke abu ivihai avoe, “Keliso.” Ivi ke ihu koseanu. Keu ata tedaevemale kosive. ");
INSERT INTO kpx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ebalahamu isi Deividi kebia vigomo valada bahata votiniu (14) ua. Ige Deividi vanimo lamisi lohoale Iselala ataeau Babuloniae timale ke vigomo valada votini (14) moleta ua. Ige Iselala ataeau Babuloniae timale isi Kelisou uale ke vigotamo valada mole votini (14) keta ua. ");
INSERT INTO kpx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Kelisou uale keu koseanu. Diosebau Meli kokovaito avuti ladeveholisege Munanae Tumuu Meli vuvunetige au ese manu. ");
INSERT INTO kpx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ige koliave Dioseba keu inutolotolote ata. Katealemo isiviholinu atae nimo Meli mai matitiliho. Kateaime isiviale tobekai au keate ke halei. ");
INSERT INTO kpx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Isi kateai huhuisege Kosive anelu moleu tababumo avue lohoale namihai avoe, “Dioseba, au Deividi valadamo lohonu. Ainaho Meli melameveve ke vabuhavolive. Keu Munana Tumue vuvunemoike au ese ke manu. Iale momoleai melamenela. ");
INSERT INTO kpx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ige au mo mamoge ke ivihai kosea, ‘Iesu.’ Ivi ke ihuu koseanu. Auna au ata tedaevei vaveveabe toelamo malevei.” ");
INSERT INTO kpx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kateai louale keu beloveta hoto mole mai selevetinu. Dilavau subuta beloveta ke namihage keu hoto koseale hisalianu. ");
INSERT INTO kpx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Avoe, “Ma molena au koliati lahaholisito ese mai. Ige ese keu uge abuna ivihai kosea, ‘Imanuelo.’” Ihuve keu koseanu. Dilavau nahehi ua. ");
INSERT INTO kpx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ige Diosebau hovelahai Dilava aneluu namihale ke nahate vai Meli melamenu. ");
INSERT INTO kpx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Isito avuti lahaholisege eseveu uge au ke ivihai avoe, “Iesu.” ");
INSERT INTO kpx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu keu Diudia vatae o mole ivi Betelihamu keve ua. Ke vanimo kosive mole Elodi keu vatae kina baluga. Isege lulele ata degomole didimo deiada kaovamale keau vaniu velemamale keveatae lohoaleau Dielusalemae velehovolu. ");
INSERT INTO kpx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Keve velehovoi lohoale ata belagevei avoe, “Lana kove ese moleu gabie Diue kosive holiveve uale ke hilokalu. Vaniu velemamale keveatae no elehasege ese ke didiu velemanu. Ige no didi ke elehai ehovai lohoale isiviale ese ke hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kateige kosive Elodiu isi Dielusalema ata bahata keau hoto ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ige Elodiu dubu nalimale kosive kebia isi Diue menaka loui haivemale kebia bahata hohavege abu lohoge au namigevei avoe, “Bukae Hotou louale Keliso kena o oleve ui.” ");
INSERT INTO kpx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ige abu namihai avoe, “Diudia vatae o mole ivi Betelihamu keve auna ui. Hoto kateale beloveta moleu subuta hisalianu. ");
INSERT INTO kpx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Avoe, ‘Betelihamu, au Diudia vata kemo o esehame. Isito o kemo umale la iviau eseve holioholisito Diudia ata bahata kebiamo laeau baluga. Kosealemo la o kemo kosi molena lohoniege di ata Iselala kebia nalievei.’” ");
INSERT INTO kpx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kateige Elodiu hoto ke evisi lulele ata nehe hohavege abu loholu. Ige au kebia holoevei tiale lilikateve neniai didi keu velemale vaniho belagevege abu namihalu. ");
INSERT INTO kpx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ige Elodiu hanavei abuho loui avoe, “Talive Betelihamue ese ke neniai kaovalive la elehaliege daho hoto hanavoge data talive ese ke hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kateai louge abu halevai tilu. Halevai tisege didi nehe abu elehale keu abuho uli holisi tiale ese keu uale hovadavemo atagai ua. ");
INSERT INTO kpx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ige abu ke elehai vahaeholahai ehovai tialeau o kemo velehovolu. ");
INSERT INTO kpx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","O kemo velehovoi oe uvue tialeau ese keta neinaveta elehalu. Isime abu kome bokoai vata bisi ese ke hoesehavoi abu busi vavegevei kunai malei omilu. Kunai ibinate koseale golo, idi mole vabele ke nahate hagote, isi idi mole kemo senisi hagote vaevemale ke malei omilu. ");
INSERT INTO kpx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iniale vavi kemo Dilavau tababumo kebia haivei avoe, “Lainaho hoidevei talive Elodi namihalive.” Kateige keau humaha molela hoidevei abu vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Abu hoidevei tisege iaeabe Kosive anelu moleu tababumo Dioseba namihai avoe, “Hovelahai ese keta neinaveta holoevei detitisi Egubitoe tenela. Talive keve usege di aho louge bae lohonela. Kosealemo Elodiu ese ke hamaliho kaovama.” ");
INSERT INTO kpx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kateai louge Diosebau hovelahai ese keta neinaveta holoevei vavimo detuluvisi Egubitoe tilu. ");
INSERT INTO kpx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Abu tiale keve isiviai usege Elodiu hatisege abu bae hoidevei. Abu hoideveveve keu belovetau Dilava hoto louale ke mai selevetinu. Hoto keu koseanu. Avoe, “Di di mo hohavoge au Egubito halei lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lulelete ata keau Elodi lobohavoge au itumu baluganu. Isi kateai au esemu hanavei avoe, “Talive Betelihamu moe eseau uale vagana abuita isi valaeabemo ui tiale kebia bahata havehatuve. Isi o ke vavae umale kebia moe eseta haveve.” Elodiu didi kemoike ese kebia vagana hilokai kateale lounu. Au subuta lulele ataemo didi keu velemale vani ke kaovage abu namihalu. Iale kemoike au au esemu hanavege abu tiale ese kebia bahata havehatulu. ");
INSERT INTO kpx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abu ese kebia haveale keu beloveta Dielimaiau hoto louale ke mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Avoe, “Lama vatae abu ese havehatuge keate mole ivi Leisolo keu kekoai nina balugama. Ige ataeau sovavihavoi tatolevage au hotoeabe evioholinu. Kosealemo eseve bahataeau haluvilu.” ");
INSERT INTO kpx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Elodiu hatige Dilava aneluu tiale tababumo Egubitoe Dioseba namihanu. ");
INSERT INTO kpx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Avoe, “Hovelahai ese keta neinaveta holoevei tota hoilahai Iselala vatae tenela. Kosealemo ese ke hamaho vamale keau haluvilu.” ");
INSERT INTO kpx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kateige Diosebau hovelahai ese keta neinaveta holoevei abuhi Iselala vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Keve tiale evige Elodi mo Akaleasi keu lovove mai Diudia vata ke kosive holinu. Ige Diosebau keve uliho vabuige Dilavau tababumo namihage abu halevai Galili vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Keve tiale o mole ivi Nasaleta keve ua. Keve uale keu belovetaeau louale ke mai selevetinu. Belovetaeau loui avoe, “Abuna avuho loui kosea, ‘Nasaleta ata.’” ");
INSERT INTO kpx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vani kateimalela ata babatisogevemale Dioni keu Diudia botoe tiale Dilava hoto loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Abuho loui avoe, “La vaveve toela kebia halevei lohove. Kosealemo ataeau Dilava adae vuvunemo uveve vaniu aike vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iale Dioni vaveve keike beloveta Aisaiau subuta loui hisaliai avoe, “Ata molena bae botoe hoai kosea, ‘Kosive humaha ke inuta loive. La uvu hoesegevei vaveve toela halevai vaveve dua vave.’” ");
INSERT INTO kpx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dioni keu ata nimole. Ogove keu ovo mole ivi kamela ke vomo. Isege beletave keta ovo ke igae vate. Isege lovive abuike kainaku isi vidiae e. ");
INSERT INTO kpx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kateisege ata moagamoagaeau hotove eviliho loholu. Degomoleau Dielusalema o baluga kemo loholu. Ige degomoleau Diudia vatamo loholu. Ige degomoleau Diodani e vavamo umale kebiata loholu. ");
INSERT INTO kpx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Loholiale abu vaveve toela louge Dioniu Diodani emo babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Au kebia babatisogevege Balisia ata isi Sadukea ata moaga keau avue lohoale isivilahale au babatisogevei. Ige Dioniu elegevei abuho itumuai loui avoe, “La keau ute nahatea. Laeau isiviholilu Dilava itumuu lae loholiho. Isito laeau hoidevei Dilava ehovaholilu. Katealemoike Dilava itumuu laemo lohoma. ");
INSERT INTO kpx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iale vasohuta la vaveve toela halevai vaveve dua vave. Isi kemo bae babatisolahave. ");
INSERT INTO kpx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Isito lainaho huhulahai kosea, ‘Noeau Ebalahamu valada noeabuliko. Dilava itumu keu bae noemo loholivebene.’ Di la namigevege evive. Dilavana isivianiege mune kobia malevei abuemo Ebalahamu valada degomole vaevege abuna la lovomo ui. ");
INSERT INTO kpx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Soeu idie umukamo heiliho hemei ua. Iale idi oletena neniai baioholige auna idi ke heisi mai venemo mihatuge auna lahai. ");
INSERT INTO kpx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ataeau abu vaveve toelamo hoideveike vage di emo babatisogevenu. Isito di iae lohoveve Iesu kena Munana Tumuteta veneta la babatisogevei. Di iae lohoale keu ivite. Keu kosive baluga. Isito dau eseve. Iale di baluga holioholialemo tamakave iamoveve keu daemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iale ata kena lohoniege au keilota laisue i bisi kitoai hatuge momoluve abuna moleve keiolahasege ive abuna moleve keiolahai. Ige auna laisue i malei au valahumo otoveito momoluve ke malei veneu hodovavesite kemo mahoevei.” Dioniu hoto kateale loui namigevenu. ");
INSERT INTO kpx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vani kateimalela Iesuu au vata Galili halei Diodanie tinu. Keve tiale isivialeike Dioniu babatisohavoi. ");
INSERT INTO kpx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Isito Dioniu vaveve katealeho isiviholinu. Isi namihai avoe, “A kove lohoale isiviale di a babatisohavoi. Isito au di babatisohavoge duave.” ");
INSERT INTO kpx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kateai louge Iesuu avuho loui avoe, “Halege aike kateale vanela. Ige kemo naitiabuna Dilava isivi ke vasa.” Kateale louge Dioniu hotove evisi babatisohavonu. ");
INSERT INTO kpx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ige Iesuu emo hovelahai elehage otogou dikolahage Dilava Munanae Tumuu ugu mole imutava ke nahate holisi dobai lohoaleu avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ige otogomo hoto moleu loui avoe, “Keu di uvue mo seleve. Iale di vahaehove va baluganu.” ");
INSERT INTO kpx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Vani kela Munanae Tumuu Iesu melamei ataeau uvesiteve tinu. Keve tiale Seteneu isiviale lobohavoge au kemo dobai. ");
INSERT INTO kpx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ige Iesuu vanie ni voti (40) isi vavi voti (40) ke uvumo lovi ioholialelua vae balugatahoanu. ");
INSERT INTO kpx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ige Seteneu ke elehai avue lohoale namihai avoe, “A Dilava mo holiniege mune kobia namigevege abu beledi holige inela.” ");
INSERT INTO kpx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ige Iesuu namihai avoe, “Bukae Hotou loui avoe, ‘Atabeu bae lovi unaha isi kemo negoalivebene. Isito Dilavau hoto bahata louale ketamo ataeabuna negolahai ugei.’” ");
INSERT INTO kpx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kateai louge Seteneu melamei oe tumu Dielusalema keve tiale Diue dubu baluga ke kobola laminu. ");
INSERT INTO kpx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Isi namihai avoe, “A Dilava mo holiniege komo lamisi heila biloanela. Kosealemo Bukae Hotou loui avoe, ‘Dilavana au anelu hanavege abuna a evudege a bae munemo dobai a velo bokoalivebene.’” ");
INSERT INTO kpx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ige Iesuu namihai avoe, “Hoto keu seleve. Isito Bukae Hotou tota loui avoe, ‘Ainaho heiata a kosive Dilava ke nego kaovalive.” ");
INSERT INTO kpx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kateige Seteneu tota Iesu melamei tana baluga koboe tinu. Tiale keve lamisi vata bahata o bahata isi onobenobeabe ke malei haivunu. ");
INSERT INTO kpx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Isi avuho loui avoe, “Ana a kome bokoai di hoesehavoge dana uokebia bahata malei aoi.” ");
INSERT INTO kpx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ige Iesuu avuho loui avoe, “Setene, di halei tenela. Bukae Hotou loui avoe, ‘Kosive Dilava ke igae hoesehavoi isivive unaha vanela.’” ");
INSERT INTO kpx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kateige Seteneu halei tisege aneluiau lohoale Iesu nalisi tedaholu. ");
INSERT INTO kpx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Vani mole abu Dioni mai dibulae mavoge Iesuu ke evisi halei Galilie tinu. ");
INSERT INTO kpx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Keve tiale au o seleve Nasaleta kemo uoholisito tiale tabu baluga Galili ke vavamo o mole ivi Kabenumu kemo ua. Vata ke ivi abui. Mole ivilike Sebulani. Isege mole ivilike Natali. ");
INSERT INTO kpx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesuu keve tai o keve uale keu beloveta mole Aisaiau louale ke mai selevetinu. Iale hoto keu koseanu. ");
INSERT INTO kpx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Avoe, “Sebulani vata isi Natali vata keau tabu baluga ke vavae ua. Isege vaki mole Diodani e keu ua. Vata kebia ivi balugalike Galili. Iale Diue ata holioholiale moagaeau keve ua. ");
INSERT INTO kpx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ata keau vavie vaveve vamale abuna bae ataga baluga elehai. Ige ataga kena subuta vavimo ui uveve doga maholiale kebiamo atagai.” ");
INSERT INTO kpx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vani kemo Iesuu vasohuta au lovi vai ata haivei avoe, “La vaveve toelamo hoidevei lohove. Kosealemo ataeau Dilava adae vuvunemo uveve vaniu aike vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesuu halei Galili tabue vavala ohanoi tinu. Tialeu abui hohote elegevesege abu abu ugabi hatui avuemo huena malema. Nanave ivilike Saimoni. Ige ivive moleike Bita. Isege hohove Andulu. ");
INSERT INTO kpx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iale abu huena malesege Iesuu namigevei avoe, “Lohoi di ehovage di la haivege lana huena malemale ke nahate ata maleveve.” ");
INSERT INTO kpx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kateai louge abu solekavesite abu ugabi halevai ehovai tilu. ");
INSERT INTO kpx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ehovai tige Iesuu tialeu Sebedi mo abui Diemisi isi Dioni kebia elegevesege keau abu boutimo ui abu mamaluvuta uguiavoi abu ugabi adahima. ");
INSERT INTO kpx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ugabi adahisege Iesuu hohavege abu boutita abu mamata halevei Iesuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesuu tiale Galili vata bahata keve Diue dubue ataeau Dilava adae vuvunemo uveve hotoe dua ke loui ata haivema. Isi vavahanite kebia hoesegevege abu momolelahama. ");
INSERT INTO kpx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kateisege vaveveve hoto keu Silia vata ke bahata sonumai gabianu. Ige ataeau ke evisi abu vavahanitebia ata malevei avue loholu. Vavahani baluga koseimalebia. Munana toela malemale, tilogoamale isi velo golote kebia malevei lohoge Iesuu kebia bahata hoesegevege abu momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ige ata moagatahoeau ehovalu. Degomoleau Galili vatamo loholu. Isege degomoleau Dekaboli vatamo loholu. Isege degomoleau Dielusalema o baluga kemo loholu. Isege degomoleau Diodani e vaki mole keve loholu. Ata keau bahata Iesu vaveve ke elehai ehovalu. ");
INSERT INTO kpx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesuu ata moaga kebia elegevei halevei tanae tinu. Tiale keve ugulamosege esemuiabeau lohoale vavavemo uguiavolu. ");
INSERT INTO kpx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ige Iesuu kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Avoe, “Oleuoleu hilokage uvuiabeu toelale keabuna vahaeholahai. Kosealemo Dilavana ata katealebia malevege abuna otogoe Dilava adae vuvunemo ugei. ");
INSERT INTO kpx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ige oleuoleu uvulahale keabuna vahaeholahai. Kosealemo Dilavana kebia uvu hoesegevege abuna ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ige uvevete keabuna vahaeholahai. Kosealemo keabuna Dilava vatae doga keve ui. ");
INSERT INTO kpx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ige oleuoleu Dilava vaveve dua keho isivi balugalahamale keabuna vahaeholahai. Kosealemo Dilavana isiviabe ke ovei hoesegevege abuna ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ige oleuoleu ataho uvulahai tedaevemale keabuna vahaeholahai. Kosealemo Dilavana kebiaho uvuai tedaevei. ");
INSERT INTO kpx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ige oleuoleu uvuiabeau dua vale keabuna vahaeholahai. Kosealemo abuna Dilava elehai. ");
INSERT INTO kpx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ige oleuoleu ata tedaevege abu uveve dua vale keabuna vahaeholahai. Kosealemo Dilavana kebiaho loui kosea, ‘Di esea.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ige oleuoleu Dilava vaveve keho isivilahai vatehani maleale keabuna vahaeholahai. Kosealemo Dilavana ata katealebia malevege abuna otogoe Dilava adae vuvunemo ugei. ");
INSERT INTO kpx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ige lata di esemu holiale kemo ataeabuna bae la vavamo lobolahai hotoe toela loui la aiogevei vatehani laovei. Ige lainaho ke huhulahalive. ");
INSERT INTO kpx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Isito vahaeholahave. Kosealemo lana bae otogoe ibina baluga maleve. Isi hoto ko huhulahave. Ataeau subuta katelahai beloveta aiogevege abu abuta vatehani malelu.” ");
INSERT INTO kpx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“La keau vatae ata bahatamo madea nahate. Isito madea kena toelage hevena uoholige auna oleve kateai bae tota heai. Keu anekianu. Ige abuna madea ke mai mihatuge ataeabuna avuela dai tai lohogei. ");
INSERT INTO kpx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Isi la keau vatae ata bahata kebia ataga. Iale o mole abu tanamo houge onobeu bamuholiale ke nahate vave. ");
INSERT INTO kpx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atabeu bae lameba hanei mai maua uvue mamolivebene. Isito auna ke mai ehanumage auna oe uvu bahatamo atagage ataeabuna atagavemo ui. ");
INSERT INTO kpx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iale ke nahate di isiviale la ataga kena ataemo atagai. Ige abuna la vaveve dua vale ke elehai la Mamau otogoe umale ke ivi ebagevai hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Lainaho huhulahai loui kosea, ‘Kou lohoalemo Mosese menaka isime beloveta hoto keabuna uoholisi.’ Di katealeho lohoholinu. Isito dana hoto kebia malevei selevetievei. ");
INSERT INTO kpx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Seleveta di la namigevege evive. Vatana otogoti uoholisege Dilava hoto bahataeabuna ui. Iniege au hoto ke bahata malei selevetievege hisalibehame keau bae uoholilivebene. ");
INSERT INTO kpx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iale olena menakae hoto esehame egumai ata mole haivuge auna avuta ke nahate vage kena otogoe matama dogae tige ivivena esevehame holisi. Isito olena menakae hoto ehomai ata haivege abu ke nahate vage kena otogoe matama dogae tige ivivena balugai. ");
INSERT INTO kpx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Diue menaka loui haivemale isi Balisia ata keau nenilahai menaka ehovaholima. Iale lana ata kebia evigevei vaveve dua vaholiliege la bae otogoe matama dogae talivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“La evige subuta menakau loui avoe, ‘Lainaho mole havegelive. Oleu menaka ke egumai ata hamage ke mai kotalahave.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Isito aikele di loui la namigevei. Olena au haokati itumuige ke mai kotalahave. Ige oleu au haokaho loui kosea, ‘A kina keu heholinu.’ Au kateige ke mai kanisoloe tige abu avuemo ke kaovai. Ige oleu au nanaho o au hohoho loui kosea, ‘A keu tilogoanu.’ Ata kateimale keabuna veneu hodovavesite keve tai. ");
INSERT INTO kpx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Kataelemo lana isiviai ono mole mai tai dubue uvue Dilava hoesehavoho valiege mesoho la haokati la moleho loui itumuale ke huhulahaliege vasohuta talive la haoka hoesehavove. Ige itumu keu gabiage bae loholive Dilava hoesehavove. ");
INSERT INTO kpx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ige mesoho ata moleu laheho itumuai isiviai la malevei kotaho tiho vage solekai ke kaovai avuluvuta haokave. Lana solekai ke vaholige auna la malevei kotai. Ige kotae kosive kena la malevei bukate ovege abuna la malevei dibulai. ");
INSERT INTO kpx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iale di la namigevege evive. Lana dibulae uliege ke ibina bahata vahatugeto abuna bae la iovei.” ");
INSERT INTO kpx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“La evige subuta menakau loui avoe, ‘Lainaho mole keatehi hotohotoai ladevegelive.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Isito di aikele loui la namigevei. La oleu keate mole elehai au uvumo huhuai kosea, ‘Di keate uketi hotohotoai lahage duave.’ Iale uvue huhuihuhui kemo au vaveve toela vanu. ");
INSERT INTO kpx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mesoho la nie baiu vaveve toela elehage la ke vage tohoai mai mihatuve. Ige elike la vava bahatau duaveai. Onoilage la ni keau la vava bahata malei venemo hatuma. ");
INSERT INTO kpx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ige mesoho la ada inute keu vaveve toela vage ke heisi etulei mai mihatuve. Lana kateholige la ada keabuna la vava bahata aiogevei malevei venemo hatuevei.” ");
INSERT INTO kpx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Subuta menakau loui avoe, ‘Oleu isiviai au mahina haleho vaniege vasohuta haleveve beiba mai omisi.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Isito aikele di loui la namigevei. Keate oleu au kolia vavae vaveve toela vaholisege koliaveu halege au tota kolia moleige malaha keu vaveve toelaike au ke au mahinaemo vanu. Ige mesoho malaha moleu keate ke melameale keta vaveve toela vanu.” ");
INSERT INTO kpx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“La evige subuta menakau loui avoe, ‘La onole Dilava ivimo valiho louliege lainaho ke halevalive. Isito la louale ke vave.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Subuta menakau kateanu. Isito di la namigevege evive. Lainaho onole valiho Dilava ivi lougelive. Isi lainaho loui kosea, ‘Otogoe biageu hilokanu.’ Kosealemo otogo keu Dilavau umale matamae tumu. ");
INSERT INTO kpx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Isi lainaho vatatamo katelahalive. Kosealemo vata keu Dilavau velo mamomale matama. Isi lainaho Dielusalema ketamo katelahalive. Kosealemo Dielusalema keu oe tumu. Kosive baluga umale matama. ");
INSERT INTO kpx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Isi lainaho loui kosea, ‘Di kinamo di huhuige dana ke vai.’ Kosealemo hoto katealeu bae onoige la kinau bukai mesoho sisoalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lainaho katelahalive. Isito hoto seleve loui kosea, ‘Ito.’ O mesoho, ‘Ba.’ La hoto kateale louholisito hotoe toela kateimale louge keu Setenemo lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Laeau evige subuta menakau loui avoe, ‘Mesoho ata moleu la nimo hamage keduige lata talive nivemo hamage niveu keduai. O mesoho au la aie luhu hamai bokoige talive aive luhu hamai bokoave.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Isito aikele di loui la namigevei. Ata moleu vaveve toela vai la aiogevege lainaho ibinave valive. Mesoho au la mono vaki molemo hamage louge au tota vaki moleveatae hamai. ");
INSERT INTO kpx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ige mesoho ata moleu la malevei kotai isiviai la sieti maho vage la dabae ogo keta mai omive. ");
INSERT INTO kpx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ige mesoho gamaniu a hanavoi isiviale a kunaiabe kakavei o moleve otovei. Ige ainaho kemo otovei hoilahagei. Isito tota mai talive o molemo otovenela. ");
INSERT INTO kpx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ige ata oleu onoleho isiviai la namigevege isivive ke mai omive. Isi mesoho isiviai aemo ono mole malive tota mai bae aoge ke mai ominela.” ");
INSERT INTO kpx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“La evige subuta menakau loui avoe, ‘La haokuvu kebiaho isiviai tedaevei hoesegeveve. Isito la aiogevemale kebia aiogeveve.’ ");
INSERT INTO kpx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Isito aikele di loui la namigevei. La aiogevemale kebiaho isiviai tedaevei hoesegeveve. Isi la aiogevei vatehani laovemale kebiaho guligulilahageve. ");
INSERT INTO kpx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kosealemo Dilavau ata bahata tedaevema. Au louge vaniu atae dua isi atae toela kebiamo haluma. Isi louge veniu vaveve dua vamale isi vaveve toela vamale kebiaho lohoma. Iale lana la Mamau otogoe umale ke nahate valiege eseve holive. ");
INSERT INTO kpx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Isito oleuoleu laheho isivilahai la hoesegeveale kebia unahaho lana isivilahaliege oleve kateai la ibina malei. Takesi malemale atae toela keau katelahai mole hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Isi mesoho lainaho evieviholimale kebia nahate vai la haokuvu unaha hoesegevelive. Isito ata bahata kebia hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","La Mamau otogoe vaveve dua unaha vamale ke nahate lata vaveve dua unaha vageve.” ");
INSERT INTO kpx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesuu tota au esemu namigevei avoe, “La vaveve hoesegeveve. Lana atae nimo vaveve dua vai isiviale abu la vaveve ke elehai la tabagevei loui kosea, ‘Keau atae duaea.’ La kateige la Mamau bae otogoe ibinabe laovelivebene. ");
INSERT INTO kpx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Katealemo la isiviai kunaiholimale kebia tedaeveho valiege lainaho kibi uvuge ataeau evisi lohoi la elegevelive. Loboe ata unahae abuna dubue mesoho oe vaveve kateale vagei. Kosealemo keau isiviale katelahage ataeau kebia elegeveime hoesegevei. Iale di louge evive. Ata keau ataemo abu ibina malelu. Isito abu bae Dilavamo ibina malelivebene. ");
INSERT INTO kpx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Katealemo la kunaivesite kebia tedaeveho valiege lainaho ata namigevege abu hilokalive. Isito tobekai tedaeveve. ");
INSERT INTO kpx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ige atabeu bae la vale ke hilokalivebene. Ige la Mamau la kebia tedaeveale kemo auna la elegevei ibina laovei.” ");
INSERT INTO kpx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Di tota hoto mole louge evive. La guligulilahaliege lainaho loboe ata kebia nahate valive. Keau isiviale dubue mesoho ologoe lavisi guligulilahage ata bahataeau elegevei. Isito ko huhulahave. Keau vata kove abu ibina bahata malelu. ");
INSERT INTO kpx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iale la guligulilahaliege talive oe uvue lilikate udaha bamui la Mama imihave. Ige la Mamana la lilikate guliguliale ke elehai ibina laovei. ");
INSERT INTO kpx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“La guligulilahaliege lainaho la noinoi ke loui dekubegelive. Evieviholimale keau katelahama. Abu huhulahai avoe, ‘No guliguli katelahage Dilavana no hoto evisi.’ ");
INSERT INTO kpx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Iale lainaho vaveveabe ke nahate vagelive. La onole loui la Mama namihaveve ke au subuta hilokanu. ");
INSERT INTO kpx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iale la guliguliho valiege noinoi koseale vave. “No Mama, otogoe umale no isiviale ataeau a ivie tumu hoesehavogei. ");
INSERT INTO kpx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","No isiviale a matamae dogau lohoale kela abu otogoe a isivi vale ke nahate ata bahata vata komo a isivi vai. ");
INSERT INTO kpx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Isi nova no isivie lovi ke noevenela. ");
INSERT INTO kpx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Isi ata degomoleau noemo vaveve toela vage no ke huhuoholisito momahavoale ke nahate no vaveve toela abuemo vale ke ulihanela. ");
INSERT INTO kpx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ainaho no halevesege no Setene lobomo dobuluvilive. Isito vaveve toela vamale kemo no malevei halio. Kosealemo ataeabuna a adae vuvunemo vani bahata a atagamo ui tigei.” ");
INSERT INTO kpx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Noinoi kateale vave. Isi lana ata degomoleau vaveve toela laemo vale ke huhuoholisito momagevege la Mamau otogoe umale kena la vaveve toela ulihaime momahavoi. ");
INSERT INTO kpx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Isito mesoho ata degomoleau vaveve toela vai la aiogevege la ke huhulahai momageveholige la Mamau otogoe umale keu bae la vaveve toela vale ke ulihai momahavolivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“La Dilava hoesehavoho lovi ioholiliege lainaho vae ni valive. Loboe ata keabuna katelahai vae vaveve vage niabeu toelage ataeabuna kebia elegevei abuho uvulahai. Isito di la namigevei. Keau vata kove ibina malealemo abu bae otogoe ibina malelivebene. ");
INSERT INTO kpx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Isito lainaho katelahalive. La Dilava hoesehavoho lovi ioholiliege la ni totolahai la kina bive. ");
INSERT INTO kpx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Katealemo ataeau bae la vaelahale ke hilokalivebene. Isito la Mama igaena la lilikate vale ke elehai ibina laovei.” ");
INSERT INTO kpx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Lainaho vata komo kunai moaga bevuai otovegelive. Lana katelahasege segele abuna bohisi. O mesoho abuna vogolahai toelai. O mesoho vavolo ataeabuna la o vusahai kunai malei. ");
INSERT INTO kpx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lainaho katelahalive. Isito la uvu malei otogoe vavevemo mavoge segeleau bae bohilivebene. Isi vogolahai toelalivebene. Ige ataeau vavoloalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vaveve keu koseanu. Vani bahata la kunaiu umale keve la uvuna ugei.” ");
INSERT INTO kpx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“La ni keau la vavamo lameba nahate. La ni abuna duavage la uvutana atagai. ");
INSERT INTO kpx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Isito la ni abuna toelage la uvuna loai. Iale ke nahate Dilava atagau la uvumo uale kena atagage la vaveve keabuna dua vai. Isito kena atagaholige la vaveve bahatae abuna toelai.” ");
INSERT INTO kpx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Esemubeu bae kosi abuiho lovialivebene. Auna kateaniege mole isivi omisi mole kabebihavoi. Isi mesoho moleho neniai loviaito moleho neniai lovialivebene. Iale ke nahate la bae Dilavata monita igaetoai ehovalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Katealemo di la namigevege evive. Lainaho la uvevemo lovita eta huhu moagagelive. Isi lainaho la ogo vaveve keta huhu moagagelive. Kosealemo nahie vava isi nahie uveve keau baluga. Isito lovi, ogo keau baluga holioholilu. ");
INSERT INTO kpx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ugu kebia elegeveve. Keau lovilahai lovi malei valahu bioholisito la Mamau otogoe umale keu kebia nibievei lovi ovema. Iale laeau kebia evigeveale kemo Dilavana la tedaeve dua vai. ");
INSERT INTO kpx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","La oleu au uveve ke huhu moaganiege auna oleve kateai au uveve vagana ke mai egetisi. Katealiveu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Iale osiohoike la ogo huhu moagama. Botoe valavalau ulimale vaveveabe kebia elegeveve. Keau lovilahai ogo vaeveholima. ");
INSERT INTO kpx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Isito di la namigevege evive. Solomoni keu kunai moagate. Iale keu ogoe dua vama. Isito ogove dua kebiau valavalae dua kebia evigeveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Valavala keabuna nova uito nivu tutukai gililahage ataeabuna bevuevei mahoevege keabuna uoholisi. Isito Dilavau kebia gadegevei nalieveale ke nahate auna la nalievei ogo laovei. Seleveta auna laheho kateale vai. Isito la evievi keu esevehameanu. ");
INSERT INTO kpx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iale lainaho huhulahai kosea, ‘Dana oleve kateai lovita ogota malei.’ ");
INSERT INTO kpx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Evieviholimale keabulike vatae onobenobe huhu moagama. Isito la Mamau otogoe umale keu laemo onoleu uoholiale ke hilokanu. Iale auna ke laovei. ");
INSERT INTO kpx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Isito vasohuta Dilava matamae doga ke humaha kaovai vaveveve dua keta kaovai isivive vage auna onobenobe kebia bahata laovei. ");
INSERT INTO kpx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iale lainaho nivu lohoveve vaveve ke huhulahalive. Kosealemo nivue vani ke toelate la hilokaholilu. Isito vani igaegaela vaveve toelau ui lohoma.” ");
INSERT INTO kpx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesuu kateai louito tota au esemu namigevei avoe, “Lainaho mole vaveve toela kaovai abuemo loui kosea, ‘Keau vaveve toelate.’ Lana mole vaveve kaovaholige Dilavau bae avuta la vaveve toela kaovalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Isito la kateale vage Dilavana la vale ke nahate vai la aiogevei. Isi la onole ataho louale ke nahate Dilavana laheho loui. ");
INSERT INTO kpx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Di louale keu koseanu. La isiviale la haokae nimo louka mai. Isito la kateisege la nimo louka balugau ua. ");
INSERT INTO kpx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Louka balugau la nimo uale kemo lana oleve kateai la haokaho loui kosea, ‘Lohoge di a nimo loukae esehameu uale ke mai.’ ");
INSERT INTO kpx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Loboe ataea, lainaho katelahalive. Isito vasohuta louka balugau la nimo uale ke maito bae la haokae nimo loukae esehameu uale ke mave. ");
INSERT INTO kpx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Isi lainaho ono mole tumute malei to ovelive. Isi lainaho la kunaie dua malei ovoe vudimo hatulive. Lana kateige abuna kemo daliege hoidevei la uagevei. Iale ke nahate ata degomole abuna Dilava hoto evisi aiohavoge halevei teve.” ");
INSERT INTO kpx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Lana Dilava imihage auna la isivi ke laovei. Isi lana ono mole kaovaliege bae mave. Isi lana udaha hamage auna bae laheho alavoi. ");
INSERT INTO kpx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kosealemo oleuoleu onoleho Dilava imihage auna isiviabe ke ovei. Isi oleuoleu ono mole kaovale ke abuna mai. Isi oleuoleu udaha hamage auna abuho alavoi. ");
INSERT INTO kpx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","La olena eseveu beleidiho imihage auna vali mune mai omisi. ");
INSERT INTO kpx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O mesoho au huenaho isiviage auna vali ute mai omisi. Ba, keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","La hilokage laeau vaveve toela vamale ataea. Isito laeau la ese kebia hoesegevei isiviabe ke oveveve ke hilokalu. Iale ke nahate lana la Mamau otogoe uale ke imihage auna la vaveve ke evihai onobenobe dua laovei. ");
INSERT INTO kpx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Isito la isiviage ataeau la hoesegeveho vage lata ata kebia hoesegeveve. Mosese menaka isi belovetaeau louale kebia ihuiabeike ke.” ");
INSERT INTO kpx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Udaha esehame kela velehovoi teve. Isito lana udaha baluga kela velehovoi humaha vototela tiliege veneu hodovavesite keve teve. Ata moaga keau humaha votote kela tima. ");
INSERT INTO kpx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Isito udaha esehamela velehovoi ukolikoli maleveve keu toloanu. Iale ata moagavesiteau humaha kela tima.” ");
INSERT INTO kpx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Loboe beloveta kebiamo nenilahave. Keabuna la lobogevege vaveveabe elehilehi keabuna duaveai mamoe nahate vai. Isito uvuiabe toela keu botoe tobalu ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Iale ata kebiau onole vamale kemo lana kebia hilokaeveve. La bae laokamo vulutu ehalivebene. Isi la bae sesenamo madilini ehalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Idie dua kena hahuhumie dua vai. Isege idie toela kena hahuhumie toela vai. ");
INSERT INTO kpx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Idie dua keu bae hahuhumie toela valivebene. Ige idie toela keu bae hahuhumie dua valivebene. ");
INSERT INTO kpx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iale idi molena neniai hahuhumie dua vaholige abuna ke heisi mai mahoi. ");
INSERT INTO kpx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iale ke nahate loboe beloveta keabuna onole vage lana kemo vaveveabe hilokave.” ");
INSERT INTO kpx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ata moagaeabuna daho loui kosea, ‘No Kosive.’ Isito kebiamo degomoleau bae otogoe matama dogae talivebene. Isito oleuoleu di Mamau otogoe umale ke isivi vamale kebia unahaeabuna ehue tai. ");
INSERT INTO kpx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ige vani keu lohoge ata moagaeabuna di namihai kosea, ‘Kosive, no a ivimo Dilava hoto loui munanae toela nunuvei vikoe vaveve moaga valu.’ ");
INSERT INTO kpx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kateai louge dana abuho loui kosea, ‘Di la hilokaeveholinu. Laeau vaveve toela vamalea. Iale tai evihave.’” ");
INSERT INTO kpx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ata oleuoleu di hoto ko evisi vale keau lulelete ata nahate. Luleleteau mune golomo abu o houevelu. ");
INSERT INTO kpx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ige veni balugau lohoge eu lalamoge heluka balugau utuai isiviai o ke egumai. Isito o keu bokolahaholinu. Kosealemo abu mune golomo houlu. ");
INSERT INTO kpx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Isito ata oleuoleu di hoto ko evisito vaholiale keau luleleholiale kebia nahate. Luleleholiale keau esagamo o houlu. ");
INSERT INTO kpx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ige veni balugau lohoge eu lalamoge heluka balugau lohoi o ke ehobehage eu mai tinu.” ");
INSERT INTO kpx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesuu hoto kateale louge uoholige ata keau au hoto louale ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kosealemo Iesu keu Diue menaka loui haivemale kebia nahate vaholinu. Isito keu vuvunemo ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesuu tanae goloe ui ata haiveniale uoholige au tana halei hevalohoge ata moagataho avuluvuta loholu. ");
INSERT INTO kpx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Avuluvuta lohosege lebolasite ata moleu Iesue lohoale au kome bokoai vudivemo vata bisi namihai avoe, “Kosive, a isivianiege di hoesehavonela.” ");
INSERT INTO kpx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kateai louge Iesuu avuela holisi namihai avoe, “Ito, dana a hoesehavoi.” Hoto ke lousege solekavesite malaha kemo lebolasiu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ige Iesuu avuho loui avoe, “Evinela. Ainaho di a hoesehavoale ko atabeho loulive. Isito inuta talive a ebika mai dubu nalimale ke haivuge au a vava elehai a namihage Moseseu louale ke nahate ono mole mai mahoi Dilava hoesehavoge ataeabuna ke elehai hilokage a vavau dua vanu.” ");
INSERT INTO kpx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesuu kateaito lohoaleu Kabenumu oe velemanu. Keve velemasege Loma tuvalie kosive moleu avue lohoale isiviale Iesuu esemuve tedahoi. ");
INSERT INTO kpx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Isi namihai avoe, “Kosive, di esemu moleu vavahani toela vage tumuu hamage kibikibiholisito oe uvue laha unahama.” ");
INSERT INTO kpx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ige Iesuu loui avoe, “Dana tiniege hoesehavoge auna momoleai.” ");
INSERT INTO kpx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ige tuvalie kosive keu namihai avoe, “Kosive, dau bae atae duabene a bae di oe uvue lohoi. Isito ana hoto unaha louge di esemu kena momoleai. ");
INSERT INTO kpx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Di hilokage tuvalie kosive baluga keau vuvune mai daovale kemo dana di tuvalie esemu namigevege abuna di isivi ke vai. Dana mole namihai kosea, ‘Tenela.’ Ige auna tai. O mesoho moleho loui kosea, ‘Loho.’ Ige auna lohoi. O mesoho dana di omo loviamale esemu namihai kosea, ‘Ke vanela.’ Ige auna vai. Iale ana hoto unaha louge di esemu kena momoleai.” ");
INSERT INTO kpx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kateai louge lesuu ke evisi vikoanu. Isi avuluvuta lohoale kebiaho loui avoe, “Di la namigevege evive. Di Iselala ataemo evievi koseale negote elehaholinu. ");
INSERT INTO kpx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Seleveta di la namigevei. Iselala ata holioholiale moagaeabuna vaniu velemai dobamale keve loholiege Dilava matamae doga keve Ebalahamume, Aisikime, Diekobome kebiahi uguiavoi igaetolahai lovi isi. ");
INSERT INTO kpx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Isito Iselala ata moagaeau bae otogoe talivebene. Dilavau isiviale keau otogoe tai. Isito keau isiviholige auna malevei heie matamae loe hatuge abuna keve ui uvulahai ninalahaime bae monomo hediavogei.” ");
INSERT INTO kpx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kateai ata namigeveito tuvalie kosive ke namihai avoe, “A oe tenela. A evievi kemo a onoleho isiviale kena velemai.” Kateale lousege tuvalie kosive ke esemu keu momoleanu. ");
INSERT INTO kpx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesuu halei Bita oe tinu. Keve tiale Bita mea elehage keu hobeai avae golomo lahai ua. ");
INSERT INTO kpx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ige au adavela holige hobeveu uoholinu. Ige keate keu hovelahai avuho lovi vanu. ");
INSERT INTO kpx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iniale gutuige munanae toelaeau ataemo biloluvimale kebia ataeau malevei Iesue loholu. Ige Iesuu munanae toela kebiaho louge keau halevei tilu. Isi vavahanite kebiata hoesegevege abu momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Au kateale vale keu beloveta mole Aisaia ke hoto mai selevetinu. Keu subuta hisaliale keu koseanu. Avoe, “Avu igaena nahie vavahani isi nahie vatehani kebia malei hatui.” ");
INSERT INTO kpx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ata moaga keau Iesu evilikahavoge Iesuu au esemu namigevei avoe, “Nahi tabu ko houi vaki moleve tai.” ");
INSERT INTO kpx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kateai namigevesege Diue menaka loui haivemale ata moleu avue lohoale namihai avoe, “No haivemale ata, ana oleve keve tige dana aiti tai.” ");
INSERT INTO kpx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ige Iesuu namihai avoe, “Seleveta ana isiviale daiti tai. Ovoeabuna abu aeamamo ladevegei. Ige uguiabuna abu hanidamo ladevegei. Isito Atae Eseu lahaveve ou uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kateige Iesu esemu moleu lesuho loui avoe, “Kosive, usege di vasohuta talive di mamau hatiale mai guliaito bae lohoi a ehomai.” ");
INSERT INTO kpx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ige Iesuu avuho loui avoe, “Halege haluviveve keau bae mole malevei gulievei. Isito au di ehomanela.” ");
INSERT INTO kpx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesuu kateai louito halei au esemu holoevei abuhi boutimo biloluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Biloluvisi tisege solekavesite hanunu balugau lohoi boutimo lohoge eu balugai vuloai bouti uvue hahosihovosege Iesuu lahanu. ");
INSERT INTO kpx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ige esemuiabeau avue tiale etuvai loui avoe, “Kosive, no aike emo tima. Iale no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ige Iesuu abuho loui avoe, “La osiohoike vabulahama. Le evievi keu esevehame.” Kateai louito hovelahai hanunuta eta hotogevege hanunuu uoholige eu tolemanu. ");
INSERT INTO kpx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kateige keau ke elehai vikolahalu. Isi loui avoe, “Malaha oletealeike ko. Kou hanunuta eta hotogevege abu hotove evisi isivive valu.” ");
INSERT INTO kpx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kateaito boutimo tiale tabu ke vaki mole vata mole ivi Gelasene keve velehovolu. Keve velehovoi dobuluvisege alue vutae umale malaha abuiau lohoale Iesuemo loholu. Munanae toelaeau kebiamo holoeavoge keau ovo aihanite ke nahate. Katealemo atabeu bae humaha kela talivebene. ");
INSERT INTO kpx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iale ata keau lohoale kekolahai Iesu namihai avoe, “Dilava mo, a isiviale noemo osioi. No aiogeveve vaniu sohu lohoholinu. Iale osiohoike a isiviale nova no aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kateai lousege vavaeabemo ovo degomoleau lovi isi olahama. ");
INSERT INTO kpx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ige munanae toela keau negolahai Iesu namihai avoe, “Ana no nunuvei no hanavege no ovo kebia uvue deluhovoi.” ");
INSERT INTO kpx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ige Iesuu abuho loui avoe, “Teve.” Kateige abu ata abui kebia halevei ovoe uvue deluhovolu. Ige ovo bahata keau detuluvisi tialeau seika vuvegevei tabu balugamo biloluvisi e isi haluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ige ovo kebia nalievemale keau detuluvisi tialeau oe velehovoi munanae toelaeau ata kebia haleveale deiada ke bahata loui ata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ige o kemo umale keau bahata isiviale Iesu elehai. Isi tilialeau elehai baita namihai avoe, “No isiviale no vata ko halei tenela.” ");
INSERT INTO kpx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Abu kateai louge Iesuu boutimo biloai hoilahai au o seleve keve tinu. ");
INSERT INTO kpx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Keve tige ata degomoleau ata mole vavahanite ebavoi loholu. Vavahanite keu kibikibiholisito avae golomo lahai u unahama. Ige Iesuu kebia evievi hilokai vavahanite ke namihai avoe, “Di mo, vahaehoanela. Di a toela bahata ulihage uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kateige Diue menaka loui haivemale degomoleau ke evisi huhulahai avoe, “Ata kou hoto kemo Dilava ivi aiohavonu. Kosealemo Dilava igaena atae vaveve toela ulihagei.” ");
INSERT INTO kpx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ige Iesuu huhuihuhuiabe ke hilokai abuho loui avoe, “La osiohoike huhuihuhuie toela kateale huhulahama. ");
INSERT INTO kpx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dana hoto onoleale loui. Dana valive malaha ke namihai kosea, ‘Di a toela ulihage uoholinu.’ Emena dana loui kosea, ‘Hovelahai tenela.’ La huhuige hoto oleteu toloholinu. ");
INSERT INTO kpx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Isito halege dana vavahanite ke hoesehavoge lana kemo hilokage vaveve toela ulihaveve vuvune keta daemo ua.” Kateai louito vavahanite ke namihai avoe, “Hovelahai a ava egumai mai a oe tenela.” ");
INSERT INTO kpx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ige malaha keu hovelahai au oe tinu. ");
INSERT INTO kpx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oe tisege ataeau ke elehai vabulahai Dilava hoesehavolu. Kosealemo au vuvune kateale mai Iesu ominu. ");
INSERT INTO kpx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesuu o ke halei tiale malaha mole takesi malemale elehanu. Iviveike Matiu. Iale keu takesilahamale oe uvue ugulamosege Iesuu avuho loui avoe, “Di ehoma.” Ige au hovelahai Iesu ehomanu. ");
INSERT INTO kpx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iniale gabie Iesuu avuti ovemo lovi isege haokuvuiabe takesi malemale isi atae toela degomole keau lohoale Iesuluvuta igaetoai esemuiabe kebiahi igaetoai lovi ima. ");
INSERT INTO kpx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lovi isege Balisia ata degomoleau ke elehai Iesu esemuho loui avoe, “Osiohoike la haivemale keu takesi malemale isi atae toela kebiahi lovi ima.” ");
INSERT INTO kpx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Katelahai louge Iesuu ke evisi abuho loui avoe, “Medikolou bae negote kebiaho loholivebene. Isito auna vavahanite kebia unaha hoesegeveliho lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ke nahate dau lohoale kou atae dua kebia hohaveho lohoholisito vaveve toela vamale kebiahoike di lohonu. Iale talive Dilavau subuta Bukae Hotomo louale ke ihu kaovave. Au loui avoe, ‘Di isiviholiale la ovo hamai mahoi di hoesehavoliho. Isito di isiviale la la haokuvuho uvulahai tedaevei.’” ");
INSERT INTO kpx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Vani mole Dioniu ata babatisogevemale ke esemuiau lohoale Iesu belahai avoe, “Osialemoike no Balisia atahi vani degomole Dilava hoesehavoho lovi ioholima. Isito a esemuiau no vale ke nahate abu vaholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ige Iesuu namigevei avoe, “La huhuige mo molena au mahina melamege haokuvuiabe abuna uvulahai. Emena vahaeholahai. Ba, abuna vahaeholahai. Isito vani mole atae toelae abuna loholiege mo ke hamage haokuvuiabe abuna bae uvulahai lovi i halevai. ");
INSERT INTO kpx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Isito di hoto louge evive. Atabeu bae ogoe doga etulei mai ogo mole mamiu dikolahalemo badivulivebene. Kosealemo auna kateige ogoe mami kena bae dikolahai vahai. ");
INSERT INTO kpx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ke nahate atabeu bae uainie doga mai ovoe vate badivuale mamivemo ehosivalivebene. Auna kateige kena savai dikolahai. Ige uainie e kena hosilahai lotihatui. Isito atabena uainie doga mai ovoe vate dogamo ehosivage keu bae dikolahalivebene. Iale ke nahate di vaveveu bae vatae vavevehi igaetoalivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesuu abuho kateale lousege Diue kosive moleu avue lohoale vudivemo kome bokoai vata bisi imihai avoe, “Di mau aike hatinu. Iale loholive a ada mai golovemo mamoge au hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ige Iesuu ke evisi hovelahai avuti tige esemuveau ehovai avuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Avuluvuta tisege keate moleu vavahanie toela male keu lohoale Iesu ogola holinu. Vavahanive keu koseanu. Vagana tuelo (12) ke uvumo tahoe toelau uvuvemo lohoma. ");
INSERT INTO kpx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Iale au huhuai avoe, “Dana Iesu ogola holiniege momoleai.” Kemoike au Iesu ogola holinu. ");
INSERT INTO kpx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ige Iesuu hoilahai elehai avuho loui avoe, “Di ma, vahaehoanela. A uvu bahata mai daemo mamoike vage vavahani keu aemo uoholinu.” Kateai lousege vavahanive keu uoholige au momoleanu. ");
INSERT INTO kpx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesuu kateaito halei tiale kosive nehe ke oe velemanu. Keve velemai elehage ataeau ninalahai kekolahage ninanau kutikutiai ua. ");
INSERT INTO kpx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ige Iesuu namigevei avoe, “La bahata halevai teve. Ma keu hatioholinu. Isito lahaike au ke vanu.” Kateai louge abu bituhavoi hehavolu. ");
INSERT INTO kpx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Isito ata bahata heie tihatusege Iesuu oe uvue tiale ma ke adala holisi ebagemage ma keu hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ige vaveveve hoto keu vata ke bahata sonumai tai gabianu. ");
INSERT INTO kpx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesuu o ke halei tisege malaha abuita ni kedute keau Iesu ehovai baita hohavoi avuho loui avoe, “Deividi mo, noheho uvuai no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kateige au tiale o mole uvue tisege abu avuemo tilu. Ige Ieus belagevei avoe, “Lana huhuige dana vali la hoesegevei.” Ige abu loui avoe, “Ito, Kosive.” ");
INSERT INTO kpx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kateige Iesuu niabela holisi loui avoe, “La evievimo la ni koeabuna dua vai.” ");
INSERT INTO kpx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kateai lousege niabeu dua vanu. Ige abu nilahai elehalu. Ige Iesuu neniai abuho loui avoe, “Lainaho ko loui atabe namihalive.” ");
INSERT INTO kpx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Isito abu halevai tiale Iesuu vale hoto ke louge hoto keu vata ke bahata sonumai gabianu. ");
INSERT INTO kpx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Keau halevai tisege ata degomoleau ata mole uvute mai Iesue loholu. Munanae toelau avuemo biloige keu uvute holiale. ");
INSERT INTO kpx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ige Iesuu munanae toela ke nunuvage solekavesite malaha keu hotoai hoto lounu. Ige ataeau ke elehai vikolahai loui avoe, “Iselala vata komo nahi subuta vaveve kosealebe elehaholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ige Balisia ataeau loui avoe, “Ba, munana toelae kosiveike vuvune mai omige vuvune kemoike au munanae toela nunuvema.” ");
INSERT INTO kpx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesuu halei tiale o baluga isi o ese ke bahatala oanu. Isi keve dubuiabela ataeau Dilava adae vuvunemo uveve hotoe dua ke loui haivema. Isi vavahanitebia moaga hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Isi ata moaga elegevei abuho uvu tumutumuanu. Kosealemo ata kebiau mamoe nahate. Ige nalievemale atau uoholige abu tebulahale ke nahate vai u kavama. ");
INSERT INTO kpx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Isi au esemuho loui avoe, “Lovi moagaeau baelahalu. Isito lovi ke malei omo otoveveve ataeau moagaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iale bulu ke biageho guliguliage au lovi ke malei otoveveve ata hanavege abu lovive bahata malei omo otovei.” ");
INSERT INTO kpx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesuu au esemu tuelo (12) hohavege abu igaetoasege au munanae toela nunuveveve vuvune ovei vavahanitebia hoesegeveveve vuvune keta ovenu. ");
INSERT INTO kpx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Abostolo kebia iviabuike koea. Mole ivilike Saimoni Bita. Ige hohove Andulu. Ige Sebedi mo abui Diemisi isi hohove Dioni. ");
INSERT INTO kpx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ige Bilibi. Ige Batolomi. Ige Tomasi. Ige takesi malemale ata Matiu. Ige Aloveasi mo Diemisi. Ige Tadeasi. ");
INSERT INTO kpx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ige Keinanie ata mole Saimoni. Ige Iesuho haiaveve malaha mole Diudasi Kaliota. ");
INSERT INTO kpx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iale Iesuu esemu tuelo (12) kebia hanavei abuho loui avoe, “Lainaho Diue ata holioholiale kebiae talive. Isi lainaho Samalia o kebiatae talive. ");
INSERT INTO kpx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isito Iselala ata kebiae teve. Keau mamoeau halae iae tai tebulahale ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Iale kebiae talive haivei kose, ‘Ataeau Dilava adae vuvunemo uveve vaniu vuguvuguanu.’ ");
INSERT INTO kpx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Isi vavahanite hoesegevei haluvimalebia tatuveve. Isi lebolasiamale kebia hoesegevege vavaeabeau duavai. Isi ataemo munanae toela nunuveve. Isito lainaho abuemo ibina malelive. Kosealemo la vuvune ke ibina valebene bae abuemo ibina malei. ");
INSERT INTO kpx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Iale la tiliege lainaho la busimo golo, siliva isi benibehame kina malei agilive. ");
INSERT INTO kpx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Isi lainaho suveika malelive. Isi ogo hatuveve, tamaka, bedoea kebiata lainaho malelive. Lana ata kebiaho lovilahage abuna bae la tedaevei kunai laovei. ");
INSERT INTO kpx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“La o molemo velehovoliege talive elehage mesoho ata moleu laheho isiviai la malevei o hatuevege avuluvuta ulive bae halevai teve. ");
INSERT INTO kpx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","La o ke uvue deluhovoi uliege ata kebia hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ige mesoho o ke biaeau la hoesegevei la tedaevege la hoesegeveale vaveve kena bae abuemo vuvune seleveai. Isito mesoho keau la hoesegevei la tedaeveholige la hoesegeveale keu bae abuemo vuvunealivebene. ");
INSERT INTO kpx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Isito o molemo abu la hoto evioholisi la malevei o hatueveholige o ke halevai anakaeabemo la veloe gogea sesilahave. ");
INSERT INTO kpx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Seleveta di la namigevege evive. Dilava kotae vaniu lohoge keabuna vatehani baluga malei. Isito Sodomata Gomolata keabuna vatehani eseve malei.” ");
INSERT INTO kpx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Di louge evive. Laeau mamoe nahate. Di tobalue vigomoike la hanavema. Iale ute lulele ke nahate vai ugu mole imutava ke vaveve nahate via ata aiogeve halevave. ");
INSERT INTO kpx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Isito nenilahave. Diue ataeabuna loholiege la malevei kotaho tai. Isi la malevei abu dubue tiliege visuta la visugevei. ");
INSERT INTO kpx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Isege Diue ata holioholiale keabuna la malevei vatae kosive kebia vudimo otovei laemo kotalahai. Ige lana keve uliege hotoe dua loui namigeveve. ");
INSERT INTO kpx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Abu la malevei kotalahage lainaho gasigasiai la onole louveve ke huhulahagelive. Kosealemo vani kena lohoge Dilavana la onole louveve ke laovei. ");
INSERT INTO kpx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ige la vani kemo bae la hoto loulivebene. Isito la Mamae Munanae Tumuu la uvumo uale ke hoto unaha lana louve. ");
INSERT INTO kpx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Vani kela ese igae abuna moleho hailahage ataeabuna kebia havei. Ige mamuvuiabe keabuna abu eseho hailahage eseabe kebiata abu mamuvuta neinuvutaho katelahage ataeabuna havei. ");
INSERT INTO kpx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ige la di esemu holialemo ataeabuna laheho itumulahai huhuihuhuie toela vai. Isito oleuoleu abu evievimo negolahamale keabuna vanie gabila ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Isi o molemo abu la aiogevei vatehani laovege o ke halevai tota o moleve teve. Di la namigevege evive. Iselala o bahata kebiamo lana la lovi ko vai gabioholisege Atae Esena lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Vatehani malemale keu koseanu. Esemue hoto keu bae haivemale ata ke hoto ke evihalivebene. Ige esemubeu bae au kosive evihalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iale esebulu keabuna haivemale ata ke nahate vage duave. Ige esemuiau abu kosive vaveve ke nahate vage keta duave. Dau kosive. Ige ataeau daho loui avoe, ‘Setene.’ Ige laeau di esemuia. Iale abuna laheho hotoe toela baluga kateale lougei.” ");
INSERT INTO kpx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Lainaho ata vabugevelive. Kosealemo vaveve toela abu vai mahogovamale keabuna bae umidamo ui. Ige hotoe toela abu loui mahogovamale kebiatae abuna bae umidamo ui. ");
INSERT INTO kpx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ige di vavimo onole loui la haiveale ke vanimo louve. Isi di onole loui mulumuluage la eviale ke ologomo baita loui ata namigeveve. ");
INSERT INTO kpx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lainaho ataeau lahaveveve ke vabuhavolive. Keau bae la munana havelivebene. Isito la vava unaha. Isito Dilava igae vabuhavove. Kosealemo auna isivianiege la munana isi la vava malei veneu lahai hodovavesite keve hatuge abuna uoholisi. ");
INSERT INTO kpx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Lana maketie tiliege ugue ese abui voievege ibinaeabena benie kina igae. Ugu keu baluga holioholinu. Isito molena dobai hatige la Mamana ke hilokai. ");
INSERT INTO kpx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ige laeau baluga. Dilavau la kinae vomo ke bahata dodavei hilokaevei gabianu. ");
INSERT INTO kpx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iale lainaho vabulahagelive. Kosealemo ugueau Dilava nimo eseve. Isito laeau nivemo baluga. ");
INSERT INTO kpx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Oleuoleu atae vudimo loui kosea, ‘Dau Iesu ata dailike ko.’ Ige dana data ehue di Mamae vudimo loui kosea, ‘Di ataike.’ ");
INSERT INTO kpx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Isito oleuoleu atae vudimo loui kosea, ‘Dau Iesu ke hilokaholinu.’ Ige dana data ehue di Mamae vudimo loui kosea, ‘Di ata ke hilokaholinu.’” ");
INSERT INTO kpx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Lainaho huhulahai kosea, ‘Di vata kove lohoaleu vatae ata bahataeau uveve duae valihoike di lohonu.’ Ba, di lohoale keu tuvalie vaveve nahate valihoike di lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Di lohoale kemo ataeabuna mole tasaligevei uvu igaealivebene. Movena au mama aiohavosege mavena au neina aiohavoi. Isege maivu abuna abu mea aiohavoi. ");
INSERT INTO kpx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Katealemo ese igaeau o igaemo umale keabuna molehi ugologoloai. ");
INSERT INTO kpx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Olena au uvu mai daoholisito au uvu bahata mai au mama au neina kebiamo otoveniege auna oleve kateai di ata holisi. Isi olena au uvu mai daoholisito au uvu bahata mai au esemo otoveniege auna oleve kateai di ata holisi. ");
INSERT INTO kpx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Isi olena di ehomai vatehani maleho isiviholiniege auna oleve kateai di ata holisi. ");
INSERT INTO kpx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iale olena au ebika unaha huhuaniege au bae ukolikoli malivebene. Isito olena au ebika huhuoholisito di ivimo vatehani malei hatiniege auna ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Olena la tedaevei la hoesegeveniege dailike au ke tedahoi hoesehavonu. Isi olena di tedahoi di hoesehavoniege di hanavoale keike au ke hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Isi olena beloveta tedahoi huhuai kosea, ‘Kou Dilavae ata. Iale dana ko tedahoi.’ Auna kateaniege avuta beloveta ibina ke nahate auna mai. Isi olena atae dua tedahoi huhuai kosea, ‘Kou Dilava atae dua. Iale dana ko tedahoi.’ Auna kateaniege avuta atae duae ibina ke nahate auna mai. ");
INSERT INTO kpx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iale ko huhulahave. La di esemu holiale kemo oleuoleu la tedaevei e seli hai laoveale kena bae au ibina mai.” ");
INSERT INTO kpx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesuu hoto kateale loui au esemu tuelo (12) namigeveniale gabiage au o ke halei tiale o ke vavae o degomole biaemo hotoe dua loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Vani kemo au kateisege ata babatisogevemale Dioni keu dibulae uniale Iesuu vamale hoto ke evinu. Isi au esemu degomole hanavege abu avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Lohoale Iesu belahai avoe, “Dioniu subuta loui avoe, ‘No tedaeveve ata kena bae lohoi.’ Iale ata ke anike ko. Emena noeabuna mole hemei ui.” ");
INSERT INTO kpx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ige Iesuu namigevei avoe, “Hoidevei talive la onole elehai eviale ke loui Dioni namihave. ");
INSERT INTO kpx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Namihai kosea, ‘Ni keduteau nilahama. Ige velo goloteau olahama. Ige lebolasite kebia vavahaniu uoholima. Ige golemateau hoto evima. Ige haluvialeau hovedevema. Isime di hotoe dua loui kunaiholimale kebiata haivema.’ ");
INSERT INTO kpx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Oleuoleu dolodoloholisito au evievi daemo mamoale kena vahaeho balugai.” ");
INSERT INTO kpx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kateai louge abu hoidevei tisege au Dioni deiada loui ata moaga kebia namigevei avoe, “La botoe tiale Dioni elehage keu ata oleteale. La huhuige auna au uvu mai Dilavaemo mamoi negobedai laminu. Emena helukau kulumo mamoge kuluu kibikibiale ke nahate vanu. ");
INSERT INTO kpx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","La keve tiale ata oleteale elehalu. Lana elehage kena ogoe dua vamale atanike. Ba, ogoe dua vamale keau bae botoe ulivebene. Isito abuna oe duamo ugei. ");
INSERT INTO kpx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Di tota la namigevei. La keve tiale onole elehalu. Lana beloveta elehalu. Seleveta belovetaike la ke elehalu. Isito keu beloveta kebia vaveve evigeve baluganu. ");
INSERT INTO kpx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dioni vaveve keike Bukae Hotou loui avoe, ‘Dana di esemu mole hanavoge auna aho uli holisi tiniege ata namigevei kosea, Kosiveu lohoma.’” ");
INSERT INTO kpx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kateaito tota loui avoe, “Seleveta di la namigevema. Ata babatisogevemale Dioni keu ata bahata vata komo uale kebia evigevenu. Isito ivi vesiteu di ata holisi Dilava adae vuvunemo uale keu Dioni evihanu. ");
INSERT INTO kpx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Vasohuta Dioniu ata haivei lohoale vani kela isi novae vani komo ataeau isiviholilu Dilava adae vuvunemo uliho. Isito abu isiviai abu negotemo ui. Kateike abu vai Dilava hoto ke bamui esemuiabe aiogevema. ");
INSERT INTO kpx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moseseu menaka hisaliage belovetata hisaliale hoto ke ataeau subuta evisi ehovalu. Isito Dioniu lohoale ataeau Dilava adae vuvunemo uveve hoto ke loui ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Subuta beloveta moleu hisaliai avoe, ‘Ata mole Ilaidia ke nahatena lohoi.’ Iale lana di hoto ko evisi mage ata keike Dioni. ");
INSERT INTO kpx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iale la olemeau hoto evimaleau hoto ko evive. ");
INSERT INTO kpx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Dana onole tovetove novae atate kobiaho loui. Keau esebuluiau ologomo uguiavoi gilulahamale ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Esebulu abuna moleho loui kosea, ‘Noeau laheho sale hamageto laeau havulahaholilu. Isi noeau ninalahageto laeau nohehi ninalahaholilu.’ Iale novae vani komo la vaveve keau esebulu kebia vaveve nahate. ");
INSERT INTO kpx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kosealemo Dioniu subuta lohoale lovi ioholisi uaini halege ataeau ke elehai avoe, ‘Keu tilogoe ataike.’ ");
INSERT INTO kpx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iniale Atae Eseu lohoniale lovita uainita ige ataeau ke elehai loui avoe, ‘Ata ke elehave. Keu lovi ivolovoloimale ataike. Keu uaini isi momaime takesi malemale atae toela kebiahi haokuvuanu.’ La hoto keu esebulue hoto nahate. La louale kemo ataeau hilokage la luleleholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesuu kateai louito hoto mole negote lounu. Au subuta o degomole keve tiniale vikoe vaveve moaga vage keau kemo abu vaveve toela halevaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iale kemo Iesuu kebiaho loui avoe, “Kolasini ata, la nohovu. Isi Betesaida ata, la nohovu. Vatehani balugana bae laemo lohoi. Kosealemo di laemo vikoe balugana bae laemo lohoi. Kosealemo di laemo vikoe vaveve moaga vaevege la ke elehaito la vaveve toelamo hoideveholilu. Subuta mole Taea isi Saidoni keve di vaveve kateale vatebene abu ogo bukate hatui uti hohumai uvulahai abu vaveve toela halevalu. Isito laeau kateholilu. ");
INSERT INTO kpx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iale di la namigevege evive. Gabie Dilava kotae vaniu lohoge auna vatehani eseve Taeata Saidonita ovei. Isito la kebia auna vatehani baluga laovei. ");
INSERT INTO kpx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Isi Kabenumu ataea, di laheho louge evive. La isiviale la ebika tabagevei malei otogoe otovei. Isito di la namigevei. La keabuna veneu lahai hodovavesite keve tihatuve. Laeau vikoe vaveve moaga elegeveito la vaveve toela haleveholilu. Isito subuta Sodoma ataeau vaveve kateale elehavatebe o keu aike ua. ");
INSERT INTO kpx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iale di la namigevege evive. Gabie Dilava kotae vaniu lohoge auna vatehani eseve Sodoma ata kebia ovei. Isito auna vatehani baluga la kebia ovei.” ");
INSERT INTO kpx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Iesuu hoto kateale loumale kela Dilava imihai avoe, “Di Mama, au otogota vatata Kosive. Au a lulele malei luleleholiale kebia ovenu. Isito vatae ataeau abu ebika tabagevei kemo luleleage a a lulele malei kebia oveholinu. Di Mama, a kateale vale keu a isivilike. Katealemo di a hoesehavoma.” ");
INSERT INTO kpx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iesuu guliguli kateale vage uoholige au ata namigevei avoe, “Di Mamau onobenobe bahata daonu. Ige ataeau moveta Mamaveta hilokaholilu. Isito Mamave igaeike au mo hiloka seleveanu. Ige move igaeike au Mama hiloka seleveai au isivie ata tabagevei lulele ovege abu Mamave hilokalu. ");
INSERT INTO kpx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“La oleuoleu onoleu uvuvemo isuige dae lohoge dana ke mai evihage vokovokoai. ");
INSERT INTO kpx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kosealemo dau uvevete. Iale lana di esemu holiliege daemo lulele maleime lu maleve. ");
INSERT INTO kpx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iale di kovu mai laoveve keu isuholinu. Isi lovita mai laoveve keu toloholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vani mole bulamo Iesuu au esemuhi konee bulue ohanoi tisege esemuiabeau vaelahai kone dakoai ilu. ");
INSERT INTO kpx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ige Balisia ataeau ke elehai Iesu namihai avoe, “Elehanela. A esemuiau bulamo kateale vai menaka eguvalu.” ");
INSERT INTO kpx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ige Iesuu abuho loui avoe, “Lana Bukae Hotomo Deividiu au esemuhi vaelahaime vale ke dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deividiu Dilava dubue uvue tiale beleidi tumute ke mai inu. Dubu nalimale unahae abuna beleidi ke igei. Isito vani kela Deividiu menaka ke egumai beleidi ke isi au esemu ovege kebiata ilu. ");
INSERT INTO kpx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Isime lana Mosese menaka dodavelu. Mosese buka kemo bula bahata dubu nalimale keau dubue lovi vamale kemo keau menaka eguvalu. Isito keu toela holioholinu. ");
INSERT INTO kpx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Isito di la namigevege evive. Ata mole aike komo uale keu dubu ke evihanu. ");
INSERT INTO kpx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Subuta Bukae Hotomo Dilavau loui avoe, ‘Di isiviholinu la ovo havei mahoi di hoesehavoliho. Isito di isiviale la moleho uvulahai mole tedaevei.’ Iale la ke ihu hilokavatebe la ataeau menaka eguvaholiale kebia aiogeveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Atae Ese keu bulae Kosive. Iale auna onole louge abuna ke vai.” ");
INSERT INTO kpx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesuu kateaito bulu ke halei dubuiabe moleve tinu. ");
INSERT INTO kpx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Keve ata mole ada goloteu ua. Ige ata degomoleau keve uale isiviale Iesuu vaveve mole vage abuna vaveveve kemo kotalahai. Iale abu belahai avoe, “A huhuige ata molena bulamo vavahanite hoesehavoge keu momoleige vaveve kena nahie menaka egumai.” ");
INSERT INTO kpx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ige Iesuu namigevei avoe, “Mesoho la moleu mamoe oveniege mamoe moleu bulamo abatamo dobage auna ke laluvai. Emena auna osioi. Auna ke laluvai. ");
INSERT INTO kpx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Isito ovo keau baluga holioholisito ataeau Dilava nimo baluga. Iale kemoike nahie menakau nahiho humaha alavoale kemo nahiabuna bulamo ata tedaevege duave.” ");
INSERT INTO kpx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kateai louito ada golote ke namihai avoe, “A ada hatunela.” Ige malaha keu au ada hatuge adaveu adave mole ke nahate vai inutolotoloanu. ");
INSERT INTO kpx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ige Balisia ataeau ke elehai halevai Iesu hamaliho humaha kaovalu. ");
INSERT INTO kpx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesuu ke evisi o ke halei tige ata moagaeau ehovai tilu. Ige au vavahanitebia hoesegevege abu bahata momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ige au kebia namigevei avoe, “Lainaho di vale ko loui ata namigevelive.” ");
INSERT INTO kpx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Au kateai louale keu Dilavau beloveta Aisaia namihale hoto ke mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Au loui avoe, “Di esemuike ko. Di ke ebagemai di isivi avuemo mamoi vahaehove vanu. Iale dana di Munanae Tumu omige auna di kotae vaniu lohoveve ke loui vatae ata bahata namigevei. ");
INSERT INTO kpx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Isito keu bae itumuai baita loulivebene. Isi au bae ologomo baita hoto loui aivolovoloalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ata degomole evieviabeu negoholimale kebia auna bae hoesegevei. Isi olemeau vaveve toelamo dobuluvimale kebia auna bae tabagevei. Auna ata kebia negotievenata gabie vaveve toela aiogevesege vaveve dua unahana ui tigei. ");
INSERT INTO kpx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ige vani kemo vatae ataeabuna abu uvu mai avuemo mavoi.” Aisaiau Dilava hoto kateale loui hisalianu. ");
INSERT INTO kpx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ata degomoleau malaha mole ni kedute isi uvute ke melavei Iesue loholu. Kosealemo munanae toelau avuemo biloige keu kateanu. Iale Iesuu ata ke hoesehavoge keu niai hotoanu. ");
INSERT INTO kpx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ige ataeau ke elehai tetelahalu. Isi mole belagevei avoe, “La huhuige Deividi mo nehenike Dilavau nahi tedaeveho hanavoale. Emena.” ");
INSERT INTO kpx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ige Balisia ataeau ke evisi loui avoe, “Munanae toelae kosive Biesabolo keike au vuvune omige au vuvunevemo munanae toela kebia nunuvema.” ");
INSERT INTO kpx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Isito Iesuu huhuihuhuiabe ke hilokai isiviai deiada mole loui haivege abuna kemo hilokage keu Setene vuvunemo munanae toela nunuveholinu. Au abuho loui avoe, “Vata mole ataeau mole tasalievei mole haveliege ata keau bae ui egealivebene. Ige o igaemo valada igaeau mole tasalievei abu moletehi mole haveliege abuna solekai uoholisi. ");
INSERT INTO kpx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iale ke nahate Setene ataeabuna mole tasalievei abu moletehi mole havege Setene vuvune kena solekai uoholisi. ");
INSERT INTO kpx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","La loui kosea, ‘Munanae toelae kosive Biesabolo keu vuvune daoge di munanae toela nunuvema.’ Isito di ke vuvunemo kebia nunuveholima. Dana kateai Setene vuvunemo kebia nunuvege la esemu abuna ole vuvunemo munanae toela kebia nunuvei. Iale lana la esemu belagevege abuna loui kosea, ‘Dilava vuvunemoike no kebia nunuvema.’ Ige di data kateale vama. ");
INSERT INTO kpx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Iale di Dilava Munana Tumue vuvunemo munanae toela nunuvege la hilokage Dilava matamae doga ke vuvuneu laemo lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Atabeu bae malaha negote ke oe uvue tai kunaive vavoloalivebene. Isito auna vasohuta malaha ke umuvaito bae ove kemo kunaive malei. ");
INSERT INTO kpx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ata oleuoleu di tedahoholimale keau di aiohavomale ataeabulike. Isi ata oleuoleu di ata maleveveve kemo di tedahoholimale keau ata kebia nunuvema. ");
INSERT INTO kpx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Katealemo di laheho louge evive. Ata olena vaveve toela vai hotoe toela onole louge Dilavana ke ulihai. Isito ata olena Munanae Tumuho hotoe toela loui aiohavoge Dilavau bae ke ulihalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iale ata oleuoleu hotoe toela loui di aiohavoge Dilavana toelave ke ulihai. Isito oleuoleu hotoe toela loui Munana Tumute ke aiohavoge Dilavau bae vata kove toelave ke ulihalivebene. Isi gabie otogo ketave au bae ulihalivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nahi idi bahata hahumamale ke hilokalu. Nahi hilokage idie dua kena hahuhumie dua vai. Isege idie toela kena hahuhumie toela vai. ");
INSERT INTO kpx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ige laeau ute nahate toelalu. Iale la bae oleve kateai hotoe dua loui. Kosealemo ataeau abu aimo loumale keu abu uvumo huhulahamaleike abu ke louma. ");
INSERT INTO kpx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atae dua keu huhuihuhuie dua vamale kemo auna hotoe dua lougei. Isege atae toela keu huhuihuhuie toela vamale kemo auna hotoe toela lougei. ");
INSERT INTO kpx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Iale di la namigevege evive. Dilava kotae vaniu lohoge ataeau hoto ihuve uoholisito abu heiata loumale ke ibina abuna bahata malei. ");
INSERT INTO kpx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vani kemo Dilavana la hoto loumale ke kaovai. Ige oleu hotoe dua loumale keho auna loui kosea, ‘A vaveveu inutolotoloanu.’ Isito oleu hotoe toela loumale keho auna loui kosea, ‘A vaveveu toelale kemo ibinae toela manela.’” ");
INSERT INTO kpx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iesuu kateai louge Diue menaka loui haivemale degomole isi Balisia ata degomole keau loui avoe, “Kosive, no isiviale au vikoe vaveve mole vage no elehai.” ");
INSERT INTO kpx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ige Iesuu loui avoe, “Novae ata la koeau atae toelaea. La Dilava halevai vaveve toela baluga vama. Katealemoike la di belahai isiviale di vikoe vaveve vage la elehai. Isito di bae la louale ke valivebene. Isito beloveta mole Dionau vale ke nahate dana data vai. ");
INSERT INTO kpx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Subuta Dionau vanie ni abuita igaeta uvumo huena baluga gogoe uvue ua. Iale ke nahate Atae Esena vanie ni abuita igaeta uvumo vatae uvue ui. ");
INSERT INTO kpx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Gabie Dilava kotae vaniu lohoge Niniva ata keabuna hovedevei la vaveve toela ke laemo loui. Kosealemo subuta Dionau hotoe dua loui haivege abu ke evisi abu vaveve toela halevalu. Isito di la namigevege evive. Ata moleu Diona ke evihale keike kou la vigomo ua. Isito laeau hotove evioholilu. ");
INSERT INTO kpx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ige Dilava kotae vani kela vata mole kuini Siba kena hovelahai la vaveve toela ke laemo loui. Kosealemo keate keu haeavamoleve Solomoniu luleleai ata haivemale ke evisi elehaho lohonu. Isito di la namigevege evive. Ata moleu Solomoni ke evihale keike ko la vigomo ua. Isito laeau hotove evioholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Di hoto mole louge evive. Munanae toelana ata mole halei tiniege eu uvesiteve uveve matama kaovai. ");
INSERT INTO kpx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Isito uveve matamabeu uoholige auna huhuai kosea, ‘Dana hoilahai talive di subuta uale kemo ui.’ Kateaime hoilahai lohoniege elehage oe neheu au uvu hoesehavoge onobenobe toelau avuemo uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ige munanae toela kena halei tiniege munanae toela seveniau (7) vuvune balugale kebia holoevei abuhi loholiege ata nehe kemo deluhovoi. Ige ata kena toela seleveai. Kosealemo subuta munanae toela igaeu avuemo ua. Isito gabie munanae toela eiti (8) keau avuemo ua. Iale novae vani komo vaveve katealena atae toelamo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesuu hoto kateale loui ata namigevesege neinaveu hohuvuiabe holoevei lohoaleau velehovoi heie uime isiviale avuluvuta hotohotoai. ");
INSERT INTO kpx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ige ata moleu Iesu namihai avoe, “Eleha. A neinau a hohuvu ehai abuhi heie ua. Iale abu isiviai aluvuta hotohotoai.” ");
INSERT INTO kpx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ige Iesuu loui avoe, “Di neinaike ole. Ige di hohuvuiabuike olemea.” ");
INSERT INTO kpx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kateai louito au esemumo ada bisi loui avoe, “Elehave. Koeau di neinuvu isi di hohuvuiabuike koea. ");
INSERT INTO kpx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iale oleuoleu di Mamau otogoe uale ke isivi vamale keau di hohuvuia, di amakinivuia, di neinuvuia.” ");
INSERT INTO kpx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Vani kemo Iesuu kateai louito o ke halei tiale esagae ugulamoi keve ata haivema. ");
INSERT INTO kpx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Isege ata moagamoagaeau igaetoai lohoale evilikahavoge au hovelahai vanagi adamo ugulamonu. Isege ataeau esagae lavisi usege Iesuu haivema. ");
INSERT INTO kpx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dovudovue hotomo haivei isiviale abu kemo lulelelahai. Isi loui avoe, “Malaha moleu i degomole malei au bulue sesiaho tinu. ");
INSERT INTO kpx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tiale sesiasege degomoleau humahamo keiolahage uguiau lohoale ke ihatulu. ");
INSERT INTO kpx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Isege degomoleau munemunemo vatau uoholiale kemo keiolahai neniai uliholige alumuiabeau heie dobai tioholilu. ");
INSERT INTO kpx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Alumuiabeau vatamo tioholialemo vaniu velemai tumuai kebia havege tutukalu. ");
INSERT INTO kpx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Isege degomoleau adu bekate ke uvumo keiolahalu. Ige adu keau botolahai kebia bamuevege keau nenilahai uliholilu. ");
INSERT INTO kpx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Isege degomoleau vatae duamo keiolahai bailahalu. Ige degomoleau bailahale moagataho. Isege degomoleau bailahale moaga. Isege degomoleau bailahale moaga vesitehame. ");
INSERT INTO kpx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iale la olemeau hoto evimaleau hoto ke evive. ");
INSERT INTO kpx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iesuu hoto kateai louge esemuveau loholiale belahai avoe, “Osialemoike a vani bahata ataho dovudovue hoto louma.” ");
INSERT INTO kpx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ige Iesuu au esemu namigevei avoe, “Di isiviale Dilavau au matamae dogae vamale ke hilokave. Isito di dovudovue hotomo ata haivege abu kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Katealemo ata olena di hoto ke huhuai luleleage Dilavana lulele baluga omisi. Isito ata olena au lulele unahamo hoto ke evisito keho isiviholige Dilavana avuemo luleleve ke mai evihai. ");
INSERT INTO kpx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Di dovudovue hotomo abuho louale keu koseanu. Keau elehaito neniai elehaholilu. Isi hoto evisito kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Katealemoike ata kebia vaveveu beloveta Aisaiau Dilava hoto hisaliale ke mai selevetinu. Avoe, ‘Lana evisito bae lulelelahalivebene. Isi lana nilahaito bae neniai elehalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kosealemo la uvuiau tololahalu. Isi la golemate holilu. Ige la ni keau kedulahalu. Onoilage la nilahai hoto evisi lulelelahai tota dae hoidevei lohoge di la vaveve toela ulihai hoesehavoma.’” ");
INSERT INTO kpx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iesuu beloveta hoto kateale louito au esemuho loui avoe, “Ata keau katelahalu. Isito laeau ni mole. Laeau di vaveve ke elehai di hoto evisi kemo lulelelahalu. ");
INSERT INTO kpx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iale ko huhulahave. Subuta beloveta moaga isi Dilava ata moaga keau isivilahale la elehale vaveve ko nahate elehai. Isito abu ke elehaholilu. Isi isivilahale la eviale ko nahate abuta evisi. Isito abu ke evioholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Di i sesiale ke hoto louale ke ihuike ko. Iale di louge evive. ");
INSERT INTO kpx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oleuoleu Dilava adae vuvunemo uveve hoto ke evisito luleleholiale keau i degomoleau humahadamo keiolahale ke nahate. Ige Setenena lohoniege uvuiabemo hotoe dua ke aiohavogei. ");
INSERT INTO kpx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Isege i degomoleau munemunemo keiolahale keau ata degomoleau hoto evisi vahaeholahai solekai male ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Abu hoto ke evisi maito hoto keu uvuiabemo holomaholige abu negoholilu. Iniege gabie abu hotoe dua eviale kemo ataeabuna abuemo vaveve toela vai aiogevege abuna vatehani malei solekavesite hoidevei. ");
INSERT INTO kpx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Isege i degomoleau adu bekate uvumo keiolahale keau ata degomole nahate. Ata keau hoto ke evisito vani mole abu vatae vaveve huhulahai kunaita huhu balugage vaveve katealeu hotoe dua ke bamuge evieviabeu negoholinu. ");
INSERT INTO kpx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Isege i degomoleau vatae duamo keiolahale keau ata degomoleau hotoe dua evisi ehovai vamale ke nahate. Degomoleau hoto kemo evieviabeu balugataho. Isege degomoleau baluga. Isege degomoleau balugavesitehame.” ");
INSERT INTO kpx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesuu ke louito tota dovudovue hoto mole loui namigevei avoe, “Ataeau Dilava adae vuvunemo uveve kemo di deiada mole louge evive. Malaha moleu bulue tiale konee i hatuito halei lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iniale vavi molemo ataeau ladevesege malaha ke bahoeu tiale latie toela malei bulu kemo sesiaito halei lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ige kone keau bailahaito nigiholisege latie toela keau lalavolu. ");
INSERT INTO kpx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ige lovi ke biage esemuiau ke elehai lohoale abu baluga namihai avoe, ‘Kosive, a tiale bulue konee i hatunu. Isito lati keau oleve kateai lalavolu.’ ");
INSERT INTO kpx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ige au namigevei avoe, ‘Nahie bahoeike ke sesianu.’ Ige abu loui avoe, ‘A isiviage no talive lati ke lavai.’ ");
INSERT INTO kpx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ige au loui avoe, ‘Ba, lainaho lati ke lavalive. Kosealemo lana lati ke lavaliege kone keta toholahave. ");
INSERT INTO kpx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Halege kone keu latiti igaetoai ulive koneu baeage dana bae kone ke hamaveve ata namigevei kosea, Talive lati ke lavai umudisi maholiho otoveve. Isito kone hamai malei lohoi di valahumo otoveve.’” ");
INSERT INTO kpx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesuu kateai louito tota dovudovue deiada loui namigevei avoe, “Ataeau Dilava adae vuvunemo uveve keu masitae i nahate. Lana masita ke i malei bulue sesiage kena ulisi balugai. ");
INSERT INTO kpx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ke iu esevehame seleve. Isito auna uliniege idi baluga holisi. Ige uguiabuna loholiege kebia adamo hasolahai. Iale ataeau Dilava adae vuvunemo ui moagatahoai ue dua vaveve keu kateanu.” ");
INSERT INTO kpx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesuu ke loui gabiaito tota dovudovue hoto mole loui namigevei avoe, “Ataeau Dilava adae vuvunemo uveve keu beikini bauda ke nahate. Keate abuna ke mai valavamo keohai ebuehage kena valava ke bahata mai balugatisi. Iale ataeau Dilava adae uvumo ui moagaveve keu ke nahate.” ");
INSERT INTO kpx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesuu dovudovue hoto kateale loui namigevenu. Keu inuta ihuve loui ata haiveholima. Isito dovudovue hoto ke unaha loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Au kateale vale keu beloveta mole hoto mai selevetinu. Hoto keu koseanu. Avoe, “Dana abuho louniege dovudovue hotomo loui. Subuta Dilavau vata vai ono mole mahogovale ke dana ekovehai abuho loui.” ");
INSERT INTO kpx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesuu kateaito ata moaga kebia halevei oe uvue tinu. Ige esemuveau avue lohoale namihai avoe, “Latie toela ke ihuike onole.” ");
INSERT INTO kpx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ige au namigevei avoe, “Malaha nehe konee i hatuale keike Atae Ese. ");
INSERT INTO kpx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ige bulu keu vata bahata. Ige konee i keau Dilava atae duaea. Ige latie toela keau Setene atae toelaea. ");
INSERT INTO kpx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ige ata neheu latie toela sesiale keike Setene. Ige kone hamamale vani keike vatae gabi. Ige kone ke hamale ataeabulike aneluia. ");
INSERT INTO kpx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ige abu lati lavai umudisi venemo mahoale ke nahate Dilavana vatae gabi kela vata ko kateai. ");
INSERT INTO kpx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ige vani kela Atae Esena au anelu hanavege abuna vatae loholiege evievi ata lobogevemale kebia isi vaveve toela vamale kebia bahata malevei. ");
INSERT INTO kpx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Malevei loholiege veneu hodovavesite kemo hatuevei. Ige abuna keve ui vatehani malei ninalahai kekolahai monogigilahagei. ");
INSERT INTO kpx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ige Dilava ataeabuna abu Mamae matama keve tiliege vani nahate atagai. Iale la olemeau hoto evimaleau hoto ke evive.” ");
INSERT INTO kpx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ataeau Dilava adae uvumo uale keu moni balugataho ke nahate. Ata molena tiniege abu moni baluga malei bulue abavuale ke elehaniege vahaehoai avuta ke vavahaito halei lohoniege oe velemai au kunai bahata malei ataemo voiai. Isi moni ke malei bulu ke voiai uvuvemo moni baluga ke malei. ");
INSERT INTO kpx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Isime tota ataeau Dilava adae uvumo uale keu ko nahate. Ata molena tiniege mune dua ibina balugate kaovai. ");
INSERT INTO kpx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ke kaovaniege mune dua seleve elehai hoilahai tiniege au kunai bahata malei ataemo voiai. Isi moni ke malei tiniege mune dua ke ibina vai. Iale ke nahate ataeabuna Dilava adae uvumo uliho humaha kaovalata bae elehai.” ");
INSERT INTO kpx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iesuu tota loui avoe, “Ataeau Dilava adae vuvunemo uveve keu abu ugabi mihatuale ke nahate. Ugabi kemo abuna huena nimolete moagamoaga malei. ");
INSERT INTO kpx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ige ugabi keu tobalohoge abuna ke butuhai mai loholiege esagae mavoi. Isi keve uguiavoi bae huena kebia sesievei duave malei abu sinimo emeito toelave malei hatui. ");
INSERT INTO kpx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iale vatau gabiveve kena kateai. Anelu abuna loholiege atae duamo atae toela kebia malevei. ");
INSERT INTO kpx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abuna kebia malevei veneu hodovavesitemo hatui. Ige abuna keve ui vatehani malei ninalahai kekolahai monogigilahagei.” ");
INSERT INTO kpx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesuu kateai louito belagevei avoe, “Lana di louale ke evisi lulelelahalu.” Ige abu namihai avoe, “Ito.” ");
INSERT INTO kpx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ige Iesuu tota namigevei avoe, “Diue menaka loui haivemale degomole keau di esemu holige Dilavau kebia malevege abu adave vuvunemo ua. Keau subuta hotote isi di hotoe doga ketamo lulelelahalu. Iale ata keau oe biageu au valahumo au kunai mamita kunai dogata malei igaetoai otoveale ke nahate.” ");
INSERT INTO kpx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesuu dovudovue hoto ke loui gabiaito halei tinu. ");
INSERT INTO kpx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Halei tiale au o seleve velemanu. Keve velemai Diue dubue tiale ata haivenu. Ige abu hotove evisi vikolahai mole belagevei avoe, “Oleveike au lulele kateale manu.” Isi, “Oleve kateai vikoe vaveve vaevenu. ");
INSERT INTO kpx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nahi hilokage keu o houmale ke moike. Isege neinaveike Meli. Ige Diemisi, Dioseba, Saimoni, Diudasi keau hohuvuiabea. Keau bahata kove ua. ");
INSERT INTO kpx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ige amakinivuiabe kebiata kove ua. Iale keu oleveike vuvune kateale manu.” ");
INSERT INTO kpx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kateale louime hotove evioholilu. Ige au namigevei avoe, “Beloveta ata kena vata moleve tige ataeabuna hotove evisi hoesehavoi. Isito au au o seleve keve tige atave keau bae hotove evisi hoesehavolivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iesuu kateale loui namigevenu. Isi keau hotove evioholiale kemo au vikoe vaveve moaga vaeveholinu. ");
INSERT INTO kpx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vani kela Galili kosive baluga Elodi keu Iesu vaveve hoto ke evinu. ");
INSERT INTO kpx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Isi au esemu namigevei avoe, “Ata babatisogevemale Dioni keu hatialeu tota hovelahaike vai vaveve nimolete kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Elodiu hoto kateale louale keu koseanu. Keu subuta louge abu Dioni umuvai mai dibulae mavolu. Kosealemoike Elodiu au hoho Bilibi ke keate Elodiasi etulei melamenu. ");
INSERT INTO kpx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ige Dioniu vani baita Elodi namihai avoe, “A keate ke koliave vavamo etulei melameale keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kateai loulage Elodiu isiviale ke hamai. Isito Diue ataeau huhulahai avoe, “Dioni keu beloveta ata.” Katealemo Elodiu vabugeve Dioni hamaholinu. ");
INSERT INTO kpx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iniale vani mole Elodiu uale vani keu lohoge Elodiasi mau tiale kosivebia bahata vudimo havuage Elodiu ke elehai ma ke vahaeho vanu. ");
INSERT INTO kpx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Isime namihai avoe, “Seleveta ana onoleho isiviage dana a isivi ke mai aoi.” ");
INSERT INTO kpx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ige ma keu tiale au neina belahage neinaveu namihai avoe, “Talive namihai kosea, ‘Di isiviale ata babatisogevemale Dioni ke kina heisi etulei kinave mai melegimo mamoi mai daonela.’” ");
INSERT INTO kpx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ige kosive Elodiu ke evisi uvuai isiviholinu hamaliho. Isito au lovi iho lohoale kebia nimo au ono vade ma keho valiho Dilava ivimo menakale kemo ke haleveve keu avuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Isi louge abu dibulae tiale Dioni eno heisi etulelu. ");
INSERT INTO kpx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Isi kinave mai melegimo mavoi lohoale ma ke omilu. Ige ma keu ke mai tiale au neina ominu. ");
INSERT INTO kpx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ige Dioni esemuiau ke evisi lohoaleau Dioni vava mai abavulu. Isi tiale deiadave ke loui Iesu namihalu. ");
INSERT INTO kpx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesuu hoto ke evisi bouti mai ahuvela ataeau uvesiteve tinu. Ige ataeau ke evisi abu o halevei ehovai vatala tilu. ");
INSERT INTO kpx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tiliale keve velehovoi usege Iesuu boutimo tiale keve dobai ata moagataho kebia elegevenu. Isime abuho uvu balugatahoai vavahanitebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iniale gutuige esemuiabeau avue lohoale namihai avoe, “Matama kou boto. Iale vau dobalelua kebia hanavege abu hoidevei abu oe talive lovi malei isi.” ");
INSERT INTO kpx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ige Iesuu namigevei avoe, “Lainaho kebia iovege abu talive. Isito la biaeau lovi ovege abu isi.” ");
INSERT INTO kpx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ige abu Iesu namihai avoe, “Valava ada mole isi huena abuita unahahameike ko.” ");
INSERT INTO kpx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ige Iesuu abuho loui avoe, “Ke malei lohove.” ");
INSERT INTO kpx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kateige abu ke malei omige au ata bahata namigevei avoe, “Kulue golomo ugulelevave.” Isito valava ada mole isi huena abuita ke malei ehue niai lovi ke hoesehavonu. Isi ke vakoanata malei au esemu ovege esemuiabeau ke malei igaegaeai ata kebia ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kebia ovege ata bahata keau lovi ke ige uniabeau hanilahalu. Ige esemuiabeau lovi ke sigu bahata iuhai basiketi tuelomo (12) otovege keau tobaloholu. ");
INSERT INTO kpx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lovi ke iale malaha bahata vai taoseni (5,000). Isito keate isi eseese kebia abu dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Keu uoholige Iesuu au esemu namigevei avoe, “Boutimo biloluvisi e houi vaki mole keve tisege di ata kobia iovege abu tisegeto di bae lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kateai kebia bahata ioveito ahuvela guliguliho tanae tinu. Tiniale vavimo ahuvela ua. ");
INSERT INTO kpx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ahuvela usege vavi kemo esemuiabeau bouti mai tisege helukau lohoge eu toelai boutiabe mai e nie tinu. ");
INSERT INTO kpx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iniale vae alamo Iesuu e golola lamisi abue lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E golola lamisi abue lohoge abu ke elehai vabulahai loui avoe, “Aluike uoke lohonu.” Isi katelahai vabulahai kekolahalu. ");
INSERT INTO kpx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ige Iesuu solekavesite namigevei avoe, “vabu halevave. Iesu dalike. Lainaho vabulahalive.” ");
INSERT INTO kpx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ige Bitau hohavoi namihai avoe, “A seleveta di kosive holiniege daho louge di e nila lamisi ae tai.” ");
INSERT INTO kpx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ige Iesuu avuho loui avoe, “Loho.” Ige Bitau bouti halei dobai e nila lamisi tinu. ");
INSERT INTO kpx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ige heluka balugau utuige Bitau ke elehai vabuaime solekavesite e uvumo dobai tinu. Isi kekoai loui avoe, “Kosive, di tedahoi di ebagema.” ");
INSERT INTO kpx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ige Iesuu solekavesite ada hatui adavela holisi ebagemai avuho loui avoe, “A evievi keu esehameale kemoike a dolodoloai emo dobanu. A kateai dolodoloale keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kateai louito avuti boutimo biloluvisege hebuluu tolemanu. ");
INSERT INTO kpx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ige esemuiabeau bouti uvumo hovedevei Iesu hoesehavoi loui avoe, “Seleveta au Dilava mo.” ");
INSERT INTO kpx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Katelahaito lohoaleau e ke vaki mole Genesaleti keve dobuluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Keve dobuluvisege ataeau Iesu elehai hilokage keu Iesu. Isime o bahatae hoto hanavoge abu vavahanitebia malevei avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ige vavahanite keau Iesu namihai isiviale ogove ivi unahala holisi momoleai. Kateige olemeau ogove ivila holiale keau bahata momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Balisia ata degomole isi Diue menaka loui haivemale keau Dielusalema halevai Iesue loholiale belahalu. ");
INSERT INTO kpx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Belahai avoe, “Nahie buluveau menaka mole mai nahiovelu. Menaka keu koseanu. Vasohuta ada totolahaito bae gabie lovi isi. Isito osialemoike a esemuiau menaka ke etulei ada totoholisito lovi ima.” ");
INSERT INTO kpx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ige Iesuu namigevei avoe, “Isito osialemoike laeau Dilava menaka halevai la buluve menaka vai ehovama. ");
INSERT INTO kpx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dilava menakau loui avoe, ‘La mamuvu la neinuvu hoto evisi hoesegeveve.’ Isi tota loui avoe, ‘Oleuoleu abu mamuvu neinuvu kebia aiogevei hotoe toela abuho louale kebia abuna havege haluvisi.’ ");
INSERT INTO kpx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Isito laeau loboe vaveve koseale loui ata haivei loui kosea, ‘La mamuvu la neinuvu kebia la onobenobe oveho isiviholiliege kebiaho loui kosea, Di ke mai Dilava omialemo di bae ke mai laovelivebene.’ ");
INSERT INTO kpx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Iale kemo au bae au mama au neina tedaevelivebene. Vaveve katealemoike la Dilava menaka halevai la menakate unaha vai ehovama. ");
INSERT INTO kpx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Iale la keau loboe ataea. Beloveta mole Aisaia keu la vaveve louale keu seleve. ");
INSERT INTO kpx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Au loui avoe, ‘Dilava hotou koseanu. Avoe, Ata kobiau abu ai unahamo di hoesehavoma. Isito uvuiabe keu vatae vaveve unaha huhuevema. ");
INSERT INTO kpx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Keau di hoesehavomale ke ihuu uoholinu. Kosealemo abu atae menaka loui ata haivei loui kosea, Menaka kou Dilava menakaike. Isito abu haiveale keu Dilava menaka holioholinu.’” ");
INSERT INTO kpx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesuu kateai louito hoage ataeau avue lohoge au namigevei avoe, “Di hoto ko louge evisi lulelelahave. ");
INSERT INTO kpx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ataeau lovi onole imale keu abuemo toela holioholinu. Isito abu vaveve toela onole huhulahai vamale keu abuemo toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ke loui gabiage esemuiabeau avue lohoale namihai avoe, “Balisia ataeau a aike louale ke evige keu abuemo isuanu. Iale ana ke hilokanu.” ");
INSERT INTO kpx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ige Iesuu namigevei avoe, “Halege lainaho kebia huhuevelive. Di Mamau otogoe uale keu lovie dua hanu. Isito lovie toela uliale ke auna tohoai hatui. ");
INSERT INTO kpx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iale ata keau ni kedute ke nahate. Ni kedutena ni kedute mole adala holisi uli holisi tiniege abuna avuti abata ke igae vuvegevei.” ");
INSERT INTO kpx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ige Bitau ke evisi namihai avoe, “Hoto ke ihu louge no evisi.” ");
INSERT INTO kpx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ige Iesuu namigevei avoe, “Lana lata hoto ke ihu hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","La hilokage ataeau lovi ige lovi kena gogoeabe taito uoholisi. ");
INSERT INTO kpx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Isito vaveve toela onole kebia uvumo uale ke abuna huhulahai vamale keike Dilava nimo toelanu. ");
INSERT INTO kpx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vaveve toela kosealeike atae uvumo lohoge abu vama. Abuna vaveve toela huhulahaliege ata havei, mole keatehi ladevei, teibalahai, vavoloai, lobolahai, isi hotoe toela loui mole aiogevegei. ");
INSERT INTO kpx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Vaveve keabuike ata aiogevege abu Dilava nimo toelalu. Isito ada totoholisito lovi imale keu Dilava nimo toela holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesuu kateai louito matama ke halei tiale vata moleve velemanu. Vata kemo o baluga abuita Taea isi Saidoni keau ua. Iale Iesuu tiale o kebia vavae ua. ");
INSERT INTO kpx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ige Keinani keate mole vata kemo uale keu Iesue lohonu. Diue ata holioholiale keate keu lohoale Iesu namihai avoe, “Iei, di Kosive. Di hilokage au Deividi mo. Iale daho uvuai di tedahonela. Kosealemo munanae toelau di maemo biloige keu kemo vatehani toela malenu.” ");
INSERT INTO kpx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kateai louge Iesuu avuho hotobe louholinu. Ige esemuveau lohoale baita namihai avoe, “Keate keu nahi ehovei ninai kekoige keu toelanu. Iomage au tai.” ");
INSERT INTO kpx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ige Iesuu namigevei avoe, “Dilavau di hanavoge di Diue ataike tedaeveliho lohonu. Di ata keau mamoeau humaha halevai botoe tebulahale ke nahate.” ");
INSERT INTO kpx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ige keate keu hoto ke evisi lohoale Iesu veloe heimo dobai loui avoe, “Kosive, di tedahonela.” ");
INSERT INTO kpx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ige Iesuu namihai avoe, “A Diue ata holialebene di bae a tedahoi. Isito di a tedahoge di Diue ata tedaeveho lohoale kebiabuna osioi.” ");
INSERT INTO kpx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ige keate keu loui avoe, “Kosive, a hoto keu seleve. Isito ana vali di isivihame igae komo di tedahoito bae a ata seleve kebia vani baita tedaevegei.” ");
INSERT INTO kpx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ige Iesuu namihai avoe, “A evievi keu balugataho. Iale a onoleho isiviale dana aho ke vai.” Kateai lousege maveu uokeve momoleanu. ");
INSERT INTO kpx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesuu matama ke halei Galili tabu baluga ke vavae ohanoi tinu. Keve tiale tanae ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ugulamoi usege ata moagaeau avue lohoime ata degomole velo toelate, ni kedute, velo golote, uvute isi vavahanite ata degomole kebia bahata holoevei lohoale Iesu hoesegeveliho vudivemo otovelu. Ige au kebia bahata hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ige ataeau elehage uvuteau hotolahalu. Ige velo golote kebia veloeau inutolotoloalu. Ige velo toelate keau olahalu. Ige ni kedute keau nilahalu. Kateige ataeau kebia elegevei tetelahai Iselalae Dilava hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ige Iesuu au esemu hohavege abu avue lohoge au abuho loui avoe, “Ata kobiau daluvuta vanie ni abuita igaetamo ui lovibe ioholige di abuho uvuanu. Iale dana lovi oveholisito hanavege abuna tiliege humaha tavae vaeho nibedai.” ");
INSERT INTO kpx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ige esemuveau belahai avoe, “Noeabuna boto kove oleve kateai lovi malei ata kobia moaga ovei.” ");
INSERT INTO kpx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kateale louge Iesuu belagevei avoe, “La valava vaesute malei loholu.” Ige abu namihai avoe, “Valava seveni (7) isi huena ada molehame.” ");
INSERT INTO kpx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kateale louge Iesuu ata moaga kebia namigevege abu vatamo ugulelevalu. ");
INSERT INTO kpx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Vatamo ugulelevasege Iesuu valava seveni (7) isi huena ke malei hoesehavoi vakoai au esemu ovege abu malei ata kebia ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ata kebia ovege keau ke ige uniabeau hanilahalu. Ige esemuiabeau lovi ke sigu bahata iuhai basiketi sevenimo (7) otovege tobaloholu. ");
INSERT INTO kpx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lovi ke iale malaha bahata voa taoseni (4,000). Isito abu keate isi eseese kebia dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ige Iesuu ata kebia iovege abu tisege au halei vanagi mai vata mole ivi Magada keve tinu. ");
INSERT INTO kpx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Balisia ata isi Sadukea ata degomoleau Iesue lohoale isiviai lobohavoge au kemo dobai. Isi kateai namihai isiviale au vikoe vaveve baluga otogomo vage abu elehai. ");
INSERT INTO kpx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Isito Iesuu namigevei avoe, “Vaniu dobai vovoige lana ke elehai loui kosea, ‘Auna vaeahai.’ ");
INSERT INTO kpx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ige vavita lana otogo elehage au bukage lana loui kosea, ‘Nova venina lohoi.’ La katelahai otogo elehai kemo lulelelahalu. Isito aike laemo lohoveve vaveve kemo la luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Novae ata la koeau atae toelaea. La Dilava halevai vaveve toela baluga vama. Katealemoike la di belahai isiviale di vikoe vaveve vai. Isito di bae la louale ke valivebene. Isito beloveta mole Dionau vale ke nahate dana data vai.” ");
INSERT INTO kpx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesuu kateai louito halevei au esemuhi bouti mai tilu. Isito esemuiabe keau valava maleholilu. Isi tiale e ke vaki mole velehovoito ke huhulahai mole namigevelu. ");
INSERT INTO kpx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ige Iesuu ke evisi namigevei avoe, “La ebia nenigeveve. Lainaho Balisia ata isi Sadukea ata kebia valava ilive.” ");
INSERT INTO kpx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kateige esemuiabeau mole namigevei avoe, “Mesoho nahi valava malei lohoholilike vage au nahiho hoto kateale lounu.” ");
INSERT INTO kpx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ige Iesuu abu loumale ke hilokai belagevei avoe, “La evieviu eseveale kemoike la moleho valava hoto ke louma. Iale la hoto ke halevave. ");
INSERT INTO kpx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lana sohu luleleholilu. Lana di valava vakoai ata moaga ovege abu iale ke lana huhulahalu. Vani kemo di valava vai (5) vakoai malaha bahata vai taoseni (5,000) ovege abu ilu. Ige uniabeu hanilahage la lovie sigu malei basiketi vaesutemo otovege tobaloholu. ");
INSERT INTO kpx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Isi vani mole di valava seveni (7) vakoai malaha bahata voa taoseni (4,000) ovege abu ige uniabeu hanilahage la basiketi vaesutemo lovie sigu malei otovege tabaloholu. Lana ke huhulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iale osialemoike la di hoto louale kemo luleleholilu. Di valava ke hoto louholinu. Valava keu daemo baluga holioholinu. Isito di loui kosea, ‘Balisia isi Sadukea ata kebia vavevemo la ebia nenigeveve.’” ");
INSERT INTO kpx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kateai louge esemuiabeau lulelelahai hilokage Iesuu valava seleve ke hoto louholinu. Isito Balisia isi Sadukea ata keau ata haivemale kemoike au hoto kateale lounu. ");
INSERT INTO kpx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesuu halei o mole Sesalia Bilibai keve tinu. Keve tiale au esemu belagevei avoe, “Ataeau huhuige dau ole.” ");
INSERT INTO kpx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ige abu namihai avoe, “Ata degomoleau a mai loui avoe, ‘Ata babatisogevemale Dioni keike ke.’ Isege degomoleau a mai loui avoe, ‘Ilaidiaike ke.’ Isege degomoleau a mai loui avoe, ‘Dielimaia o mesoho beloveta moleike ke.’” ");
INSERT INTO kpx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ige Iesuu belagevei avoe, “Isege laeau huhuige dau ole.” ");
INSERT INTO kpx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ige Saimoni Bitau namihai avoe, “Au ukolikolie Dilava ke mo. Dilavau a hanavoale Keliso ailike ke.” ");
INSERT INTO kpx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ige Iesuu namihai avoe, “Diona mo Saimoni, atae lulelemo a ke louholinu. Isito di Mamau ehue umale keu lulele mai aoike vage a ke lounu. Iale auna a hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iale di hoto mole loui a namihage evi. A ivilike Bita. A keu mune nahate. Iale dana mune ke golomo di dubu houge Seteneu bae au vuvunemo koialivebene. ");
INSERT INTO kpx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Di ataeau Dilava adae uvumo uale ke vuvune dana aoi. Ige ana vuvune keta vata kove onole bamuge Dilavana avuta ehue ke bamui. Isi mesoho ana vata kove ono mole alavoge Dilavana avuta ehue ke alavoi.” ");
INSERT INTO kpx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kateai louito isuta au esemu namigevei avoe, “Lainaho ata namigevei loui kosea, ‘Iesu keu ata tedaevemale kosive Keliso.’” ");
INSERT INTO kpx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vani kemo Iesuu lamisi au hativeve ke hoto loui neniai au esemu haive dua vanu. Abuho loui avoe, “Dana Dielusalemae tiniege oe kosivea, dubu nalimale kosivea isi Diue menaka loui haivemale kebiamo vatehani baluga malei. Abuna dahavoge dana hatiniege vanie ni abuita igaetaeau uoholisege dana tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kateai louge Bitau melamei tiale lilikateve isuta avuho loui avoe, “Kosive, hoto kateale louhale. Di isiviholinu vaveve katealeu aemo loholiho.” ");
INSERT INTO kpx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ige Iesuu Bita namihai avoe, “Setene, di haliohatunela. A keu di hativeve humaha bamuge toelanu. A huhuihuhui keu atae huhuihuhui. Keu Dilava huhuihuhui holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kateai Bitaho louito tota au esemu namigevei avoe, “Oleu daiti tiho vaniege au lako au isivi va halei au vatehani maleveve ke huhu haleito di ehomai. ");
INSERT INTO kpx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iale olena au ebika unaha huhuaniege au bae ukolikoli malivebene. Isito olena au ebika huhuoholisito di ivimo vatehani malei hatiniege auna ukolikoli mai. ");
INSERT INTO kpx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Isi olena vatae onobenobemo kunaite holisito Dilavamo au uvu mamoholisito hatiniege auna oleve kateai ukolikoli mai. Au bae kunai keta au otogoe tiveve ke ibina valivebene. ");
INSERT INTO kpx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iale Atae Esena au anelu holoevei au Mamae atagamo dobai lohoniege vatae ata igaegae vaveveabe ibina ovei. ");
INSERT INTO kpx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iale seleveta di la namigevege evive. La degomoleau kove uale keau bae haluvilivebene. Isito abuna uliege Atae Eseu ata malevege abu adave vuvunemo uveve ke elehaito bae haluvisi.” ");
INSERT INTO kpx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vanie ni sigisiu (6) uoholisege Iesuu ata halevei Bita, Diemisi isi hohove Dioni kebia holoevei abuhi tana mole balugae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tiale keve velehovosege Iesu vavae elehilehi keu nimoleanu. Ige niveu vaniu haluale ke nahate. Ige ogoveu taeai levolevoanu. ");
INSERT INTO kpx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Isi kateisege esemu abuita igaeta keau elehasege Moseseu Ilaidiati avuluvuta hotohotoima. ");
INSERT INTO kpx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ige Bitau hovelahai Iesuho loui avoe “Kosive, hoeseike no vai kove loholu. A isiviage dana oe ese abuita igaeta houevei. Moleu aho. Moleu Moseseho. Isege moleu Ilaidiaho.” ");
INSERT INTO kpx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kateai lousege goe taeteu abuemo dobai lohoale bamuevege goe kemo hoto moleu lohoale loui avoe, “Di uvue moike ke. Di vahaehove vanu. Iale au onole louge hotove evive.” ");
INSERT INTO kpx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ige Iesu esemuiau hoto ke evisi vabulahai vatamo dobuluvisi abu ni malei abavulu. ");
INSERT INTO kpx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kateige Iesuu lohoale levevei namigevei avoe, “Vabulaha halevaito hovedeveve.” ");
INSERT INTO kpx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ige abu hovedevei nilahaito atabe elehaholilu. Isito Iesu igae elehalu. ");
INSERT INTO kpx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Isime hevaluvisi lohosege Iesuu namigevei loui avoe, “Lainaho la onole elehale ke loui atabe namihalive. Ilage Atae Eseu hatisi tota hovelahageto bae ke loui ata namigeveve.” ");
INSERT INTO kpx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ige abu Iesu namihai avoe, “Osialemoike Diue menaka loui haivemaleau loui avoe, ‘Ilaidiana vasohuta lohosegeto Atae Esena bae gabie lohoi.’” ");
INSERT INTO kpx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ige Iesuu namigevei avoe, “Hoto keu seleve. Ilaidiana vasohuta lohoi humahave loisi ata bahata namigevege abu vaveve bahata hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Isito di la namigevege evive. Ilaidia keu lohonu. Isito ataeau ke hilokaholisito abu isivi avuemo vai aiohavolu. Iale ke nahate abuna vai Atae Ese aiohavoge auna vatehani malei.” ");
INSERT INTO kpx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kateai louge esemuiabeau hoto ke ihu hilokai mole namigevei avoe, “Ata babatisogevemale Dioni ke vaveveike au nahiho lounu.” ");
INSERT INTO kpx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kateaito lohoaleau ata moaga kebiamo loholu. Ige ata moleu lohoale Iesu vudimo kome bokoai vata binu. ");
INSERT INTO kpx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Isi loui avoe, “Kosive, di moho uvuai tedahonela. Munanae toelau avuemo biloige tilogoanu. Iale kena tilogoaniege auna venemo biloai mesoho emo biloigei. ");
INSERT INTO kpx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ige di mai a esemuiau hoesehavoliho abue tige abu hoesehavoholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kateai louge Iesuu abuho loui avoe, “La uvu keu tolobe nimolealemoike la evieviholilu. La huhuige dana vali vani moaga lahehi ui laheho loviai. La katealemo mo ke mai dae lohove.” ");
INSERT INTO kpx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ige abu mo ke mai lohoge Iesuu munanae toela nunuvage au mo ke halei tinu. Isege mo keu emo momoleanu. ");
INSERT INTO kpx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kateige Iesu esemuiau lilikate lohoale namihai avoe, “Osialemoike no mo kemo munanae toela ke nunuvaveve keu noemo anekianu.” ");
INSERT INTO kpx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ige Iesuu namigevei avoe, “La evievi keu baluga holioholiale kemoike keu laemo anekianu. Di seleveta la namigevege evive. Masitae i keu esevehame. Isito mesoho la evievi keu masitae i ke nahate vage lana tana koho loui kosea, ‘Toholahai tai uokeve lami.’ Ige auna toholahai tiniege keve lamisi. Lana evievi kateale mage onobeu bae laemo anekialivebene. ");
INSERT INTO kpx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Isito munanae toela kateale nunuvaveve keu toloanu. Iale lana vasohuta lovi i halevai guligulilahaliege kemo lana munanae toela kateale nunuveveve hilokave.” ");
INSERT INTO kpx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vani mole Iesu esemuiau bahata Galili vatae mole bevuevei igaetolahalu. Isege Iesuu namigevei avoe, “Ata molena Atae Eseho haiai mai atae toela ovei. ");
INSERT INTO kpx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ige abuna mai hamage auna hatiniege tota vanie ni abuita igaeta uoholige auna hovelahai.” Kateai louge esemuiabeau ke evisi uvulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesuu au esemu holoevei lohoale Kabenumu oe velehovolu. Ige dubue takesi malemale ata degomoleau Bitae lohoale belahai avoe, “A kosive kena vali dubue takesi vai. Emena auna osioi.” ");
INSERT INTO kpx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ige Bitau loui avoe, “Ito, auna vai.” Kateaito halei oe uvue tinu. Ige Iesuu hovelahai avuho loui avoe, “Saimoni, a huhuige vatae kosive keabuna olememo takesi moni malei. Abuna abu ata selevemo malei. Emena ata degomolemo.” ");
INSERT INTO kpx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ige Bitau namihai avoe, “Keau ata degomolemo takesi malema.” Ige Iesuu namihai avoe, “Seleveike. Ataeabe seleve keau bae takesilahalivebene. Katealemo di bae oleve kateai takesiai. Dau dubu ke kosive. Ige au di esemu. Iale oleve kateai nahiabuna takesilahai. ");
INSERT INTO kpx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Isito duave. Nahiabuna ke vai. Kosealemo nahiabuna ke vaholige dubue takesi malemale abuna nahiho itumulahai. Iale e bavae talive kimeianela. A vasohuta huena olete laluvaniege aive alavoi aivemo mune bai mai ke igaela a ibinata di ibinata vanela.” ");
INSERT INTO kpx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iesuu kateai Bitati hotohotoisege esemuiabeau lohoale belahai avoe, “Dilava adae uvumo uale kebiamo olemeabuna a matamae doga keve ivi balugate holisi.” ");
INSERT INTO kpx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kateige Iesuu ese mole hohavoge au lohoale vudiabemo laminu. ");
INSERT INTO kpx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ige au namigevei avoe, “Seleveta di la namigevege evive. Lana ese ko uvu nahate vaholiliege la bae Dilava matamae doga keve talivebene. ");
INSERT INTO kpx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isito ata olena eseese ko nahate vai au ebika ebagemaholisito au ebika etolemaniege kena Dilava matamae doga keve tai ata baluga holisi. ");
INSERT INTO kpx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Isi olena di ivimo eseese koseale mai o hatui hoesehavoniege daike au ke hoesehavonu.” ");
INSERT INTO kpx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ata olena isiviai evievi ese molehame aiohavoge au vaveve toela vage abege ataeau mune baluga mai enoveta etunavui mai davalamo mihatuge duave. ");
INSERT INTO kpx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Vatae ata nohovu. Vaveve toela moagau vata komo ua. Katealemo ataeabuna mole aiogevegei. Isito olena ata aiogevege abu vaveve toela vage ata ke nohoma. ");
INSERT INTO kpx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mesoho la adau o la velou la malevei vaveve toela vage ke heisi bohisi malei hatuve. La velo igaeta mesoho ada igaeta ehue tige keu duave. Isito ada abui isi velo abui ke toelana la malevei veneu hodovavesite keve hatuale keu toelanu. ");
INSERT INTO kpx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Isi mesoho la niu la malevei vaveve toela kemo tige ke ekosihai mihatuve. Lana ni igaeta ehue tiale keta duave. Isito ni abuita ke toelau la malevei veneu hodovavesite keve hatuale keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Iale la ebika nenigeveve. Lainaho eseese koseale aiogevelive. Kosealemo eseese kebia aneluiau vani bahata otogoe di Mamae vudimo ui kebia elegevema. ");
INSERT INTO kpx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Di la namigevege evive. Atae Eseu vaveve toelamo tebulahamale kebia malevelihoike au lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Iale la huhuale ata molena mamoe bahata uani handele (100) nalieveniege igaeu detitisi tebuige auna osioi. Auna degomole kebia halevei botoe tiniege mamoe igae ke kaovai. ");
INSERT INTO kpx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ke kaovanata elehaniege vahaeho balugai. Kosealemo mamoe degomole keau ua. Isito igaehame tebuale keike au elehaime kemo vahaeho baluganu. ");
INSERT INTO kpx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ke nahateike la Mamau otogoe uale keu isiviholialeike esevebehameu toelamo tebualiho.” ");
INSERT INTO kpx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mesoho a haoka moleu vaveve toela vai a aiohavoge avue talive lilikate vaveveve toela ke haivunela. Ige mesoho au a hoto evige tota avuti haokanela. ");
INSERT INTO kpx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Isito au a hoto evioholige talive ata igae mesoho abui kebia holoevege abu aluvuta talive ata ke namihai. Kosealemo a haokuvu keabuna a hoto ke ebagevai loui kosea, ‘Hotove keu hoto seleve.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ige mesoho au negoai a haokuvu kebia hotota evioholige talive hoto ke loui ekalesia bahata haive. Ige mesoho au negobedai ekalesia kebia hoto evioholige ke iovai huhulahai kosea, ‘Keu evievi ata holioholinu. Isito takesi malemale atae toela kebia nahate.’” ");
INSERT INTO kpx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Seleveta di la namigevei. Lana vata kove onole bamuge Dilavana avuta ehue ke bamui. Isi mesoho lana vata kove ono mole alavoge Dilavana avuta ehue ke alavoi. ");
INSERT INTO kpx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iale di tota hoto mole louge evive. La ole abuitau ono mole huhuai uvu igaeai la Mamau otogoe uale ke imihage auna laheho la isivi ke vai. ");
INSERT INTO kpx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kosealemo di ata abui mesoho abuita igaeta keabuna di ivimo igaetolahai lohoi di hoesehavoge dana abuhi ui.” ");
INSERT INTO kpx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kateige Bitau Iesue lohoale belahai avoe, “Kosive, di haokana vaveve toela vaesute daemo vage dana avue ti vaesuteai toelave ke hoesehavoi momahavoi. Dana vali ti seveniai (7).” ");
INSERT INTO kpx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ige Iesuu namihai avoe, “Di a namihage evinela. Ainaho ti sevenialive (7). Isito elehalive au aemo vaveve toela vage avue tigenela. ");
INSERT INTO kpx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kosealemo ataeau Dilava adae vuvunemo uveve vaveve keu kateanu. Iale di deiada mole louge evi. Vatae kosive moleu vani mole isiviale esemuiabeau avuemo bukale ke abuemo kaovai hilokai. ");
INSERT INTO kpx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kateisege abu esemuve mole melavei loholu. Esemu keu kosi kemo moni balugataho koseale subuta malenu. Teni milioni kina (K10,000,000). ");
INSERT INTO kpx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Isito esemu keu moni malei kosive ke omiveve keu avuemo anekianu. Kosealemo keu monioholinu. Ige kosiveu au esemu degomole namigevei avoe, “Malaha kota mahinaveta eseabeta malevei kunaiabe bahata keta malei talive ataemo voieveve. Isi di monie ibina malei lohove.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kateai louge esemu keu vudivemo kome bokoai vata bisi avuho loui avoe, ‘Ba, momoleai u. Dana bae moni ke bahata malei aoi.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kateai louge kosiveu avuho uvuai au avuemo moni baluga maleale ke huhuoholisito halenu. Isi iomage au tinu. ");
INSERT INTO kpx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Au heie tiale au haoka mole au avuti kosive kemo loviamale ke elehanu. Malaha keu subuta avuemo uani handele kina (K100) bukanu. Iale au enovela holisi namihai avoe, ‘Au subuta daemo moni maleale ke aike daonela.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ige haokaveu kome bokoai vata bisi avuho loui avoe, ‘Ba, momoleai u. Dana bae moni ke aoi.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ige keu hotove evioholisito mai dibulae hanavoi namihai avoe, ‘Keve ulive di moni daoi gabiaito bae heie lohonela.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kateige esemu degomole keau au vale ke elehai avuho itumulahai tiale keau vaveveve bahata loui abu kosive ke namihalu. ");
INSERT INTO kpx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ige kosiveu esemu ke hohavoge au avue tinu. Ige au avuho loui avoe, ‘A keu esemue toela. A daemo moni baluga bukale ke bahata di huhuoholisito halenu. Kosealemo a hoto isute loui di namihanu. ");
INSERT INTO kpx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Di aho uvuai a tedahoale ke nahate abege au a haokaho uvuai tedahoge duave. Isito au avuho uvuholinu.’ ");
INSERT INTO kpx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kateai loui avuho itumu baluganu. Isi esemu ke mai dibulae hanavoi namihai avoe, ‘Keve ulive di moni bahata daoi gabiaito bae heie lohonela.’” ");
INSERT INTO kpx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iesuu deiada kateale loui au esemu haiveito loui avoe, “Lana la haokuvuiau laemo vaveve toela vale ke huhuai momahavoholige di Mamau otogoe uale kena vaveve kateale vai la igaegae aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesuu hoto ke loui gabiaito Galili vata halei Diodani e houi vata mole ivi Diudia keve tinu. ");
INSERT INTO kpx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Keve tige ata moagatahoeau ehovai tilu. Ige au kebiamo vavahanitebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Isege Balisia ata degomoleau lohoale isiviai lobohavoge au kemo dobai. Isi kateai belahai avoe, “A huhuige keate molena vaveve molehame toela vage koliavena ke halege kena menaka egumai. Emena.” ");
INSERT INTO kpx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ige Iesuu namigevei avoe, “Lana Bukae Hoto dodaveholilu. Hoto keu loui avoe, ‘Dilavau subuta vata vai malaha vaito avuemo keate vanu.’ ");
INSERT INTO kpx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kebia vaeveito loui avoe, ‘Mo molena mahinaniege au mamata au neinata halevei au mahinati igaetoai ui.’ ");
INSERT INTO kpx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dilavau subuta kateai lounu. Iale abu bae avui molemo igaegaealivebene. Isito abuna molehi igaetolahai. Kosealemo Dilavaike kebia malevei igaetoige abu mole holoevei igaetoalu. Katealemo atabe lako kebia tasalievelive.” ");
INSERT INTO kpx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kateai louge Balisia ataeau belahai avoe, “Isito osialemoike Moseseu menaka mole hisaliai ataho loui avoe, ‘Ata oleu au mahina haleho vaniege talive mahina haleveve beba mai lohoi au mahina omisito bae halei.’” ");
INSERT INTO kpx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ige Iesuu namigevei avoe, “Subuta Dilavau vata vai menaka kateale mamoholinu. Isito Dilava menaka ehovaveve kemo la uvuu toloike vage Moseseu mahina haleveve humaha ke alavonu. ");
INSERT INTO kpx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iale di louge evive. Mesoho keate moleu au kolia vavae vaveve toela vaholisege koliaveu halei keate mole melameniege au keate ke vavamoike au ke vavoloanu.” ");
INSERT INTO kpx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kateige esemuiabeau namihai avoe, “Mahina melameveve menaka keu kateai toloige no mahinuvuholige duave.” ");
INSERT INTO kpx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ige Iesuu namigevei avoe, “Ata bahataeau bae di louale hoto ke evilivebene. Isito Dilavau lulele oveale ke unahaeabuna hoto ke mai. ");
INSERT INTO kpx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Isito mahinuvuholimale ke vaveveu koseanu. Ata degomoleau neinuvuiabeau houevege vavaeabeu toelanu. Ige degomoleau ataeau mahinuvuveve humaha ke aiohavolu. Isege ata degomoleau isiviholilu mahinuvulahaliho. Ebiau isivilahai Dilava adae vuvunemo uveve ke hotomo negolahai. Iale oleu isiviai hoto ko evisi maho vage halege au mai.” ");
INSERT INTO kpx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iesuu hoto ke louge uoholisege ataeau eseese malevei Iesue lohoi isivialeike Iesuu au ada mai tataeabemo mamoi abuho guliguliai. Kateige Iesu esemuiau kebia iovei avoe, “Halevai teve.” ");
INSERT INTO kpx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ige Iesuu namigevei avoe, “Lainaho eseese kebia keluevelive. Isege abu dae lohoi. Kosealemo eseese kebia uvu nahate vamale keabuna Dilava adae vuvunemo ui.” ");
INSERT INTO kpx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kateai loui au ada mai tataeabemo mamoi abuho guliguliai gabiaito halei tinu. ");
INSERT INTO kpx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Vani mole malaha moleu lohoale Iesu belahai avoe, “No haivemale ata, dana ono vade igae dua vai bae ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ige Iesuu namihai avoe, “Osialemoike a vaveve duaho di belahama. Dilava igae keu vaveve dua vamale ata. Iale a isiviai ukolikoli maliho vaniege menakave ehomanela.” ");
INSERT INTO kpx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ige au belahai avoe, “Menaka olete dana ehomai.” Ige Iesuu namihai avoe, “Ainaho ata havegelive. Ainaho mole keatehi ladevegelive. Ainaho mole vavogevelive. Ainaho mole lobogevelive. ");
INSERT INTO kpx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","A mamata a neinata hoto evisi hoesegevenela. Isi a ebika isivi omisi hoesehavoale ke nahate a vavamo umale kebiata isivi ovei hoesegevenela.” ");
INSERT INTO kpx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ige ata keu namihai avoe, “Di subuta menaka ke bahata ehomanu. Iale dana ono vade igaeta vai ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ige Iesuu avuho loui avoe, “A isiviai duave seleve valiho vaniege talive a kunai ke bahata malei voiai moni ke malei kunaiholimale kebia oveito lohoi di ehomanela. Ilive elike otogoe ibinae dua manela.” ");
INSERT INTO kpx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ige ata keu ke evisime uvuai tinu. Kosealemo keu kunai balugate. ");
INSERT INTO kpx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ige Iesuu au esemu namigevei avoe, “Di la namigevege evive. Kunaite keau otogoe tiveve keu tolo seleveanu. ");
INSERT INTO kpx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iale di tota hoto mole louge evive. Ovo mole ivi kamela keu nilae vahamo tiveve keu anekianu. Iale ke nahate kunaiteau otogoe tiveve keta anekianu.” ");
INSERT INTO kpx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ige esemuiabeau hoto ke evisi vikolahai belahai avoe, “Kunaite keau otogoe tioholige oleme igae abuna otogoe tai.” ");
INSERT INTO kpx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ige Iesuu kebia nibievei tumutumuai abuho loui avoe, “Kunaite keau otogoe tiveve keu ataemo anekianu. Isito Dilavaemo vaveve ke bahataeau anekiholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kateige Bitau namihai avoe, “Di louge evi. Noeau no onobenobe bahata halevai a ehovalu. Iale noeabuna onole malei.” ");
INSERT INTO kpx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ige Iesuu abuho loui avoe, “Di la namigevei. Dilavau onobenobe bahata hoesegevege dogamale vani kela Atae Esena au telona atagatemo ugulamoge di ehovamale la kebiata lana telona tuelomo (12) uguiavoi bae Iselala valada tuelo (12) kebia nibievei vaveveabe kaoveve. ");
INSERT INTO kpx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ige olemeau di ivimo abu o abu vata, abu mohoho, abu mahoho kebia halevei abu mamuvu, abu neinuvu, abu ese kebiata halevei di lovi vage Dilavana vani kela abu haleveale ke ibinaho onobenobe baluga ovei ukolikolita ovei. ");
INSERT INTO kpx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Isito ata moagaeau aike uli holiale keabuna bae gabi holisi. Isege ata moagaeau aike gabi holiale keabuna bae uli holisi.” ");
INSERT INTO kpx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesuu au louale kemo dovudovue hoto lounu. Avoe, “Dilavau ata malevege abu adave vuvunemo ui lovive vale keu ko nahate. Vavita vavita vaniu haluholisege bulue biage moleu taunie tiale ata degomole namigevei isiviale abu buluvemo lovilahai. ");
INSERT INTO kpx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Isi namigevei avoe, ‘Lana novae vani ko igaemo lovilahage dana vai kina (K5) laovei.’ Kateai namigevege degomoleau isivilahage au kebia iovege abu bulue tilu. ");
INSERT INTO kpx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iniale vaniu halusege au tota hoilahai tiale ata degomole elegevesege abu lavisi uma. ");
INSERT INTO kpx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ige au namigevei avoe, ‘Lana isiviai tai di bulumo lovilahage dana ibinae dua laovei.’ ");
INSERT INTO kpx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kateai namigevege abu tilu. Iniale vanie lilimo au tiale ke nahate vanu. Isi uniale vaniu vovolo vasege au tiale ke nahate tota vanu. ");
INSERT INTO kpx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Isi uniale gutumo vaniu dobaho vasege au tiale tota ata degomoleau lavisi usege au namigevei avoe, ‘Osiohoike la vani bisi lavisi u unahama.’ ");
INSERT INTO kpx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ige abu namihai avoe, ‘Kosealemoike noeau atabeu no maleveholinu.’ Ige au abuho loui avoe, ‘Lata talive di bulumo lovilahave.’ ");
INSERT INTO kpx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Iniale vau gutu seleveige bulue biageu au esemu mole ibina ovemale ke namihai avoe, ‘Lovilahamale kebia hohavei ibinaeabe ovenela. Isito vasohuta vaniu dobaho vasege lovilahale kebiamo lamisi ibinaeabe ovei veatinela. Ilive gabila bae vavita lovilahale kebia ibina ovenela.’ ");
INSERT INTO kpx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ige esemuve keu vaniu dobaho vasege lovilahale kebia igaegae vai kina (K5) ovenu. ");
INSERT INTO kpx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ige vavita lovilahale keau ke elehai huhulahai avoe, ‘Noeabuna moni baluga malei.’ Isito au kebiata igaegae vai kina (K5) ovenu. ");
INSERT INTO kpx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ige abu ke malei bulue biageho itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Isi namihai avoe, ‘Gutumo lovilahale keau lovi baluga vaholisito vai kina (K5) malelu. Isito noeau vani ko bahata vanie tumumo lovilahaito keau maleale ke nahate nota malelu. Kateale keu toelanu.’ ");
INSERT INTO kpx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ige bulue biage keu namigevei avoe, ‘Evive. Di la lobogeve holioholinu. Isito di la namigevei kosea, Novae vani ko igaemo lana lovilahage dana vai kina (K5) igaegae laovei. Ige la ke evisi loui kosea, Ito. ");
INSERT INTO kpx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Iale la ibina ke malei teve. Di isiviale gutumo lovilahale kebiata la maleale ke nahate kebia ovei. ");
INSERT INTO kpx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Iale la huhuige di kateale vage kena toelanu. Ba, moni keu di monilike. Iale di kebia tedaevei moni kateale ovege keu di isivi unaha. Iale la osiohoike itumulahalu.’” ");
INSERT INTO kpx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesuu deiada kateale loui ihuve loui namigevei avoe, “Oleuoleu gabi holiale keabuna bae uli holisi. Isege oleuoleu uli holiale keabuna bae gabi holisi.” ");
INSERT INTO kpx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Vani mole Iesuu au esemu tuelo (12) holoevei abuhi Dielusalemae vealuvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","Abu unaha tisege Iesuu namigevei avoe, “Nahi Dielusalemae timale kove ata molena bae Atae Eseho haiai mai dubu nalimale kosive isi Diue menaka loui haivemale kebia ovege abuna hamaveve hoto loui mai Diue ata holioholiale kebia ovege abuna visuhavoi hehavoi mai idie domo hamage auna hatai. Iniege vanie ni abuita igaetaeau uoholisege auna tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi mahinau au mo abui holoevei Iesue lohoniale vudivemo kome bokoai vata bisi belahai avoe, “Dana vali di isivi hoto aho loui.” ");
INSERT INTO kpx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ige Iesuu namihai avoe, “Hoto oletealeike a louliho.” Ige au namihai avoe, “Di mo abui koeau a esemu. Iale a kosive baluga holige ataeau a adae vuvunemo umale kela a isiviage di mo moleu a ada inuteve ugulamosege moleu a ada agiteve ugulamoi vuvune mai.” ");
INSERT INTO kpx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ige Iesuu namigevei avoe, “La di belahale ke la hilokaholilu. La huhuige lana valive di vatehani maleveve ke lata malei.” Ige abu avuho loui avoe, “Ito, noeabuna nota ke malei.” ");
INSERT INTO kpx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ige Iesuu namigevei avoe, “Seleveta lana bae di vatehani maleveve ke maleve. Isito di la tabagevege la di ada inuteve isi agiteve uguiavoveve ke vuvuneu daemo uoholinu. Isito di Mamau oleme tabageveale keabuna bae keve uguiavoi.” ");
INSERT INTO kpx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kateige esemuiabe teni (10) keau ke evisi abui hohote kebiaho itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kebiaho itumulahasege Iesuu kebia bahata hohavege abu avue lohoge au namigevei avoe, “La hilokage gamanie kosiveau abu ebika tabagevei isiviale ataeau valaeabemo ui isiviabe vagei. ");
INSERT INTO kpx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Isito di isiviholinu la vaveve kateale valiho. La oleu isiviai kosive baluga holiho vaniege au ebika etolemai la mole esemu holisi isivive vai. ");
INSERT INTO kpx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Isi la oleu isiviai ivite holiho vaniege la valamo ui la isivi vai. ");
INSERT INTO kpx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kosealemo Atae Eseu vatae lohoaleu isiviholinu vatae kosive holige ataeau ivive ebagevaliho. Isito lohoale keu isiviale ata bahatae toelae ibinaho hatai malevege abu ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesuu au esemuhi o mole Dieliko ke halevasege ata moagatahoeau Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Isege malaha mole abuita ni kedute keau humaha vavamo uguiavoi uliale evige Iesuu tai vavaeabela tinu. Ige abu baita hohavoi namihai avoe, “Kosive, au Deividi mo. Iale noheho uvuai no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Katelahai louge ataeau abuho loui avoe, “Lainaho katelahalive. Isito tobekai uve.” Isito abu negolahai hohavoi avoe, “Deividi mo, noheho uvuai no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kateai louge Iesuu lamisi ata abui kebia hohavei belagevei avoe, “La isiviale di laheho ono vade vai.” ");
INSERT INTO kpx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ige abu namihai avoe, “Kosive, no isiviale a no tedaevege no nilahai.” Ige Iesuu abuho uvuai niabela levege solekavesite niabeu keduale keau dua vage abu nilahai Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","(-) ");
INSERT INTO kpx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesuu au esemuhi loholiale tana mole Oliveta keve velehovosege Dielusalemau vuguvuguanu. Isi tiale o mole ese Betabedi ke vavae tisege Iesuu au esemu abui hanavenu. ");
INSERT INTO kpx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Isi namigevei avoe, “Talive o keve velehovoi ovo mole doniki ke abu umuvage eseveu vavavemo uale ke elehaliege vavehai holoevei lohove. ");
INSERT INTO kpx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","7","La ke vavehasege mesoho ata moleu la elegevei laheho louge namihai kosea, ‘Kosiveu isiviale no kobia holoevei avue tai.’ Lana kateai louge auna solekai loui kosea, ‘Duave. Malevei teve.’” Iesuu kateai au esemu namigevege abu tiale au louale ke valu. Isi doniki keta eseveta holoevei lohoale abu dabae ogo toholahai malei donikie ese golomo otovege Iesuu biloai ke golomo ugulamonu. Iale vaveve keu belovetau subuta louale hoto ke mai selevetinu. Hoto keu loui avoe, “Dielusalemae ata namigevei kosea, ‘La kosiveu aike lae lohoma. Keu ata uvevete. Iale keu donikie esemo biloai ugulamoi lohoma.’” ");
INSERT INTO kpx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kateai donikimo ugulamoi lohosege ata moagatahoeau abu dabae ogo malei humahala tedisi tilu. Isege degomoleau idie vana hamai malei humahala tedisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ige Iesuu tisege ata degomoleau avuho uli holisi tilu. Isege degomoleau avuho gabi holisi tilu. Isime baita holahai loui avoe, “Seloo, Deividi mo ko hoesehavove. Kou Dilava ivimo lohoge Dilavana hoesehavoi. Iale nahi bahata ke hoesehavoi Dilava ivi ebagevai.” ");
INSERT INTO kpx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kateai loui lohoge Iesuu Dielusalemae velemanu. Ige ata bahataeau ke evisi moleho loui avoe, “Hoto vadeuike ko. Ata oleike lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ige Iesuluvuta lohoale keau namigevei avoe, “Iesulike ko. Kou Galili vata keve o mole ivi Nasaleta ke beloveta.” ");
INSERT INTO kpx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesuu Diue dubu baluga ke uvue tiale dubumo maketilahai voivoilahamalebia nunuvenu. Isi moni senisilahamale kebia teibolo ekovehage moniabeu keiolahanu. Isi ugu voilahamale kebia batabata ekovehai kebia bahata nunuvenu. ");
INSERT INTO kpx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Isi abuho loui avoe, “Bukae Hotomo Dilavau loui avoe, ‘Di isiviale ataeau di o komo guliguliai di hoesehavogei.’ Isito laeau kateholisito vavoloe vaveve avuemo vama.” ");
INSERT INTO kpx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iesuu kateai abuho loui gabiasege ni kedute isi velo golote keau dubu ke uvue avue lohoge au kebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kateai dubue vaveve dua vage esebuluiau ke elehai vahaeholahai tovulahai loui avoe, “Lohoge nahi Deividi mo ko hoesehavoi.” Katelahai loulage dubu nalimale kosivea isi Diue menaka loui haivemale keau ke elehai Iesuho itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Isi avuho loui avoe, “Ana abu louale ke evinu.” Ige Iesuu namigevei avoe, “Ito, di ke evinu. Isito laea, lana Bukae Hoto mole dodaveholilu. Hoto keu loui avoe, ‘Amu imale isi esebulu keabuna ke hoesehavo dua vai.’” ");
INSERT INTO kpx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iesuu kateai louito kebia halevei Dielusalema halei tiale o mole Beteni keve lahanu. ");
INSERT INTO kpx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Vavita vavita Iesuu hovelahai vaeta tota Dielusalemae hoilahai lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lohoale humaha tavae idi mole ivi vigi ke elehanu. Isi tiale isiviai ke bai ehai isi. Isito keu baioholisito numu unahanu. Ige au ke elehai avuho loui avoe, “A keu bae tota hahumalivebene.” Kateai lousege idi keu solekavesite gilianu. ");
INSERT INTO kpx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ige esemuiabeau ke elehai vikolahalu. Isi Iesu belahai avoe, “Idi kou oleve kateai solekavesite gilianu.” ");
INSERT INTO kpx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ige Iesuu namigevei avoe, “Di hoto ko louge evisi huhulahave. Lana dolodoloholisito la evievimo negolahaliege di idi komo vale ke nahate lana vave. Ke unaha holioholinu. Isito lana tana koho loui kosea, ‘Toholahai davalamo tenela.’ Ige auna vai. ");
INSERT INTO kpx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iale lana evievimo negolahaliege onoleho guligulilahai Dilava imihaliege la isivi ke maleve.” ");
INSERT INTO kpx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Au kateai namigeveito tota Diue dubu balugae lohonu. Keve lohoale ata haivesege dubu nalimale kosivea isi oe kosive keau avue lohoale lobohavoi belahai avoe, “Oleike vuvune aoge a vaveve kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ige Iesuu namigevei avoe, “Usege di isiviale hoto mole loui la belagevege ke ihu loui di namihageto di bae oleu vuvune daoge di avuemo vaveve kateimale vamale ke loui la namigevei. ");
INSERT INTO kpx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","La huhuige oleike vuvune Dioni omige au ata babatisogevenu. Dilava emena ataeabulike vuvune omilu.” Kateai louge abu mole belagevei loui avoe, “Nahiabuna onole loui. Nahiabuna namihai kosea, ‘Dilavaike vuvune ominu.’ Ige auna loui kosea, ‘Isito osialemoike laeau hotove evioholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Isi nahiabuna loui kosea, ‘Ataeabulike vuvune omilu.’ Ige keta anekianu. Kosealemo ataeau huhuige Dilavaike vuvune omige au beloveta holinu.” ");
INSERT INTO kpx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hotoeabe keu uoholige abu Iesu namihai avoe, “Dioniu olemo vuvune male ke no hilokaholilu.” Ige Iesuu abuho loui avoe, “La katealemo di bae data di ole vuvunemo vaveve kateale vale loui la namigevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesuu kateai namigeveito hoto mole deiada abuho loui avoe, “Di hoto ko louge ko ihu huhulahaito di namihave. Malaha mole igaeu mo abui houevenu. Iale keu vani mole tialeu au mo ovokina namihai avoe, ‘Ana bulue lovianela.’ ");
INSERT INTO kpx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ige moveu namihai avoe, ‘Di ke valiho isiviholinu.’ Isito gabie huhuinata tialeu bulue lovianu. ");
INSERT INTO kpx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ige mamaveu halei tiale au mo ovokina namihale hoto ke igae loui hohove namihanu. Ige mo keu loui avoe, ‘Ito, dana ke vai.’ Isito keu ke vaholinu. ");
INSERT INTO kpx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Iale la huhuige ese abui kemo oleteu au mamae isivi vanu.” Ige abu loui avoe, “Ovokinave.” Ige au namigevei avoe, “Di hoto seleve louge evive. Takesi malemale isi teibalahamale keabuna la halevei Dilava matamae doga keve tai. Isito laeau Dilava hoto evisi vaholialemo bae keve talivebene. ");
INSERT INTO kpx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kosealemo ata emogevemale Dioni keu lae lohoale uveve duae hoto loui la haivege la hotove maholilu. Isito takesi malemale isi teibalahamale keau hotove malu. Ige la elehaito la vaveve toela halevaholisi la uvu avuemo mavoholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesuu hoto ke loui gabiaito tota dovudovue hoto mole loui ata kebia namigevei avoe, “Di deiada mole louge evive. Vatae biage moleu bulue doga vai avuemo hote mole uaini haevei vavavemo hala houi bulu ke naliveve o mole egetana hounu. Isi uaini ke bai vunahaveveho abata mole lovonu. Kateaito haeavamoleve taliho au bulu ke mai ata degomole ovei isiviale abu buluve ke nalisi. Isito halei haeavamoleve deiai tinu. ");
INSERT INTO kpx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Iniale hote ke bai ehaveve vaniu lohoge bulu ke biageu au esemu hanavei isiviale abu talive ata nehe kebiamo uaini ke bai degomole malei lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ige bulu ke nalimale keau esemu kebia vudievei esemu mole aiohavoi visuhavolu. Isi mole hamage hatinu. Isi mole munetilu. ");
INSERT INTO kpx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Katelahai esemu kebia havege bulue biageu esemu moaga hanavenu. Ige bulu nalimale keau abu degomole haveale ke nahate kebiata havelu. ");
INSERT INTO kpx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kebiata havege au gabivela au mo hanavonu. Isi huhuai avoe, ‘Abu bae di mo hamalivebene. Isito abuna hoesehavoi.’ ");
INSERT INTO kpx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Isito bulu nalimale keau move elehai mole namigevei avoe, ‘Mo keu bulu ko biage moike. Lohoge nahi hamage au hatige elike bulu kou nahiele holisi. ");
INSERT INTO kpx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Isime tialeau mo ke evudei mai bulu ke iae hamage au hatinu.” ");
INSERT INTO kpx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iesuu deiada ke louge uoholige au namigevei avoe, “La huhuige bulue biagena lohoniege bulu nalimale kebiamo ono vade vai.” ");
INSERT INTO kpx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ige abu namihai avoe, “Auna lohoniege atae toela kebia havei. Isi tota bulu ke mai ata degomole ovege abuna naliliege hote keu hahumai baege abuna ke bai ehai tasaliai vaki mole malei biage omisi.” ");
INSERT INTO kpx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ige Iesuu kebia namigevei avoe, “Keu seleve. Isito lana Bukae Hoto mole dodaveholilu. Hoto keu loui avoe, ‘O houmaleau mune moleta o houveve ke kabebihavoale keike nova Dilava o hadebiveve mune holinu. Dilavaike ke ebagemage nahi ke elehage keu nahie nimo duave seleveanu.’ ");
INSERT INTO kpx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bukae Hoto keu di vaveve lounu. Iale di tota hoto mole louge evive. Dilavau isiviale la malevege la adave uvumo ui. Isito laeau daho isiviholiale kemo auna la halevei ata degomoleau hotove evisi vamale kebia malevege abuna adave uvumo ui. ");
INSERT INTO kpx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ige oleuoleu mune ke vuvehaliege abuna abu ebika havei haluvisi uoholisi. Ige mune kena dobai ata mole hamage lave unahana ui.” ");
INSERT INTO kpx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iesuu dovudovue hoto ke loui dubu nalimale kosive isi Balisia ata kebia namigevege abu hilokage vaveveabeike au abuho lounu. Kosealemo mune keu Iesulike. Iale kebiau hotoveho isiviholisi kabebihavoalemo auna au dobai lohomale ke vanila kebia aiogevei. ");
INSERT INTO kpx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Katealemo abu isiviale Iesu mai hamai. Isito keau ata vabugevelu. Kosealemo ataeau hilokage Iesu keu beloveta ata. ");
INSERT INTO kpx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesuu tota dovudovue hoto mole loui kebia bahata haivenu. ");
INSERT INTO kpx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Avoe, “Dilavau ata malevege abu adave vuvunemo uveve keu vatae kosive mole mou au mahina melameho ata hohaveale ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kosive keu au esemu iovei loui avoe, ‘Talive ata igaegae namigevege abu di lovi vale komo lohoi.’ Ige esemuiabeau ata kebia namigevege keau loholiho isiviholilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ige au tota esemu degomole hanavei loui avoe, ‘Talive ata kebia namigevei kosea, Di ovo havei ovoe ese batate kebiata havei bohisi auvale keu aike lahanu. Iale lohoge nahi amu ke alavoi isege di mou au mahina melamei.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kateai au esemu namigevege abu tiale ata kebia namigevelu. Ige ata keau kebia hoto evioholisi abu isivi unaha vai tilu. Moleu au bulue loviho tinu. Isege moleu au valahu niavaho tinu. ");
INSERT INTO kpx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tisege degomoleau esemu kebia vudievei havege abu haluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ige vatae kosive keu itumu balugai au tuvalie ata iovege abu tiale atae toela kebia havehatui oeabeta mahoevelu. ");
INSERT INTO kpx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ige au tota au esemu degomole hohavei avoe, ‘Di mou au mahina melameveve loviu lahanu. Isito di ata namigeveale keau vaveve toela vale abu bae loholivebene. ");
INSERT INTO kpx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iale talive ata moagaeau humaha balugamo tai lohomale kebia elegevei namigevege abu di iveve komo lohoi lovi isi.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ige esemuiabeau humaha baluga kela tiale atae dua atae toela moaga elegevei kebia holoevei lohoge kosive ke ou gigianu. ");
INSERT INTO kpx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ige kosive keu lohoale isiviai ata kebia elegevei. Kebia elegevege malaha mole igaeu vigoeabemo mahina melameveve ogo vaholinu. ");
INSERT INTO kpx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ige au namihai avoe, ‘Di haoka, a keu mahina melameveve ogo vaholinu. Iale a osiohoike kove lohonu.’ Kateai namihage malaha keu hotoholinu. ");
INSERT INTO kpx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ige kosive keu au esemu namigevei avoe, ‘Malaha ke mai veloveta adaveta umuvai mai heie matamae lo keve mihatuve. Ige au keve ui uvuai ninaime bae monomo hedimagei.’” ");
INSERT INTO kpx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesuu deiada ke loui gabiaito abuho loui avoe, “Di louale keu koseanu. Dilavau ata moaga hohavei isiviale abu ove uvue tai. Isito au tabageveale ke unahaeabuna ove uvue tai.” ");
INSERT INTO kpx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iesuu hoto kateale loulage Balisia ataeau ke evisi tialeau hotohotolahai isiviale hoto degomole loui Iesu belahai elike hotove kemo mai dibulae mavoi. ");
INSERT INTO kpx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Katelahaito abu esemu degomole isi Elodi esemu degomoleta iovege abu Iesue tilu. Iliale namihai avoe, “No haivemale ata, no hilokage a keu hoto seleve unaha loumale ata. A ata ivite kebia vabugeveholisito ata bahatae vaveve loui kebiaho Dilava vaveve louma. ");
INSERT INTO kpx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iale no namigevenela. A huhuige no Loma gamanie kosive Sisa kemo takesiamale kena duave. Emena toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kateai namihage Iesuu uvuiabe toela ke hilokai abuho loui avoe, “La keau loboe ataea. La di hoto hilokaito tota di vavae tobekai lohomale hoto loui isiviale di lobohavoge di dobai. ");
INSERT INTO kpx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","La moni oleteale mai takesiamale ke mage di elehai.” Ige abu monie luhu mai omilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ige Iesuu belagevei avoe, “Ole munanata ivivetaike moni ko luhumo ua.” ");
INSERT INTO kpx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ige abu namihai avoe, “Loma gamani kosive baluga, Sisa.” Ige Iesuu namigevei avoe, “Ito. Iale gamaniele gamani omive. Isi Dilavaele Dilava omive.” ");
INSERT INTO kpx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kateai louge abu ke evisi vikolahalu. Isi halevai tilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Vani ke igaemo Sadukea ataeau Iesue loholu. Ata ke abulike huhulahai avoe, “Haluviale keau bae tota hovedevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Iale abu Iesuu namihai avoe, “No haivemale ata, Moseseu subuta ata haivei loui avoe, ‘Malaha moleu mahinaito eseholisi hatige hohovena hovelahai gobuve melamei au nanaho ese houi.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iale no deiada mole louge evinela. Malaha mole igaeu nohehi komo uale keu mohoho bahata seveni (7) houevenu. Iniale vani mole ovokinaveu mahinai ese houholisito hatinu. Ige valavemo keu hovelahai au nanae gobu melamenu. ");
INSERT INTO kpx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ige vaveve ke nahateu avuemo velemanu. Ige ke valamo moleu hovelahai gobu ke melameito hatinu. Ige ke valamo keau bahata igaegaeai gobu ke melaveito bahata haluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ige gabila keate keta hatinu. ");
INSERT INTO kpx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","No deiada ke loualemo a huhuige ata seveni (7) keabuna hovedevege keate kena ole mahina holisi.” ");
INSERT INTO kpx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ige Iesuu namigevei avoe, “Di hilokage la Bukae Hotota Dilava vuvuneta hilokaholialemoike hoto ke loui Dilava humaha hosidilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iale di la namigevege evive. Haluviale keabuna hovedeveliege abu bae mole holoevelivebene. Isito abuna otogoe anelu nahate vai. ");
INSERT INTO kpx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dilavau Bukae Hotomo haluvialeau hovedeveveve hoto louale ke lana dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Au kemo loui avoe, ‘Dau Ebalahamu Dilava, Aisiki Dilava, isi Diekobo Dilava.’ Iale kemoike nahi hilokage keu nova nita uale kebia Dilava isi subuta haluviale munanaeabeu uale kebiata Dilava.” ");
INSERT INTO kpx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iesuu hoto kateale louge ataeau ke evisi vikobe nimole valu. ");
INSERT INTO kpx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ige Balisia ataeau evige Iesuu Sadukea atae hoto hamage hotoeabeu dobanu. Ige Balisia ataeau ke evisi mole bevuevei igaetoai Iesue loholu. ");
INSERT INTO kpx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kebia vigomo moleu menaka haivemale ata. Iale keu hovelahai isiviale hoto mole loui Iesu belahage au hotove kemo dobai. ");
INSERT INTO kpx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Au belahai avoe, “Au no haivemale ata. Iale a huhuige Mosese menaka kebiamo hoto olete igaeu balugataho.” ");
INSERT INTO kpx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ige Iesuu namihai avoe, “‘A uvu bahata a isivi bahata a lulele bahata malei a Kosive baluga Dilava ke omisi hoesehavonela.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hoto ke igaeike menaka bahata evigevei baluganu. ");
INSERT INTO kpx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ige ke valamo mole balugaike ko. ‘A ebika hoesehavomale ke nahate a vavamo umale kebia isivi ovei hoesegevenela.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moseseu menaka hisalieveale isi belovetaeau hisalieveale hoto kebia bahatamo hoto abui keau balugataho seleve.” ");
INSERT INTO kpx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Balisia ata keau lohoale igaetoasege Iesuu belagevenu. ");
INSERT INTO kpx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Isi loui avoe, “La huhuige Bukae Hotou louale Diue ata tedaeveve Keliso kena ole valadamo lohoi.” Ige abu namihai avoe, “Bukae Hotou louale auna Deividi valadamo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ige Iesuu belagevei avoe, “Keu seleveike. Isito osialemoike Munanae Tumuu Deividi haivuge au subuta Kelisoho loui avoe, ‘Kosive.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Deividiu subuta louale keu koseanu. Avoe, ‘Dilavau di Kosive keho loui avoe, Di ada inute kove ugulamonela. Isege di a aiohavomale kebia malevei a veloe heimo otovege ana kosiveabe holinela.’ ");
INSERT INTO kpx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lana evilu. Deividiu hoto kemo Kelisoho loui avoe, ‘Di Kosive.’ Iale kemo Kelisona oleve kateai tota Deividi valada holisi.” ");
INSERT INTO kpx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kateai belagevege keau hotove ke ibina louveve keu anekianu. Vani kemo abu tota Iesu belahaliho vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesuu tota ata moaga isi au esemu kebiaho lounu. ");
INSERT INTO kpx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Isi avoe, “Diue menaka loui haivemale isi Balisia ata keau Mosese menaka ke loui la haivema. ");
INSERT INTO kpx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iale kemo hotoeabe evive. Isito lainaho ehovei vaveveabe vagelive. Kosealemo keau hoto ke loui ata haiveito ke ehovaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Katealemoike vaveveabe keu ataemo isuanu. Abu hoto baluga mai ataemo mavoge keu abuemo isuanu. Isito keau kebia tedaeve behame vaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Keau vaveve koseale vai isiviale ataeau kebia elegevei kebia tabagevei. Keabuna idie ese lovoi avuemo Bukae Hoto hisalilahai ogoe misi malei abu adamo umudigevei. Isi ke nahate valiho mole vai malei abu valimo umudigevei. Isi ogoe dua ataeau hatuvesite ke kaeahavoi ke malei hatugei. ");
INSERT INTO kpx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Isi keabuna lovi vamale vani kemo tiliege matamae duae uguiavoi isiviale ivite kebiahi igaetoagei. Isi abuna dubue tiliege vomue duamo uguiavogei. ");
INSERT INTO kpx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Isi isiviale maketie tige ataeabuna kebia elegevei hoesegevei abuho loui kosea, ‘No kosivea.’ Isi isiviale ataeau abuho loui kosea, ‘No haivemale ataea.’ ");
INSERT INTO kpx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ata keau vaveve kateale vama. Isito lainaho la ebika tabagevei isiviale ataeau laheho loui kosea, ‘No haivemale ataea.’ Kosealemo laeau ese igaea. Ige la haivemale Kosive keu igae. ");
INSERT INTO kpx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Isi lainaho vatae ataho loui kosea, ‘No mama.’ Kosealemo la Mama baluga igaeu otogoe ua. ");
INSERT INTO kpx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Isi lainaho la ebika tabagevege ataeau laheho loui kosea, ‘No kosivea.’ Kosealemo ata tedaeveve Keliso ke igaeu la Kosive. ");
INSERT INTO kpx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iale la oleu la vigomo isiviai kosive holiho vaniege au la esemu holisi. ");
INSERT INTO kpx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iale oleu au ebika ebagemale ke Dilavana etolemai. Isito oleu au ebika etolemale ke Dilavana ebagemai.” ");
INSERT INTO kpx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iesuu kateai au esemu haiveito Balisia ata isi Diue menaka loui haivemale kebiaho loui avoe, “La nohovu. La isiviholilu Dilava adae uvumo uliho. Kateike la vai la loboe vaveve kemo ataeau di hoto eviho isiviale kebia humaha bamui la humahata bamuma. ");
INSERT INTO kpx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Iei! Diue menaka loui haivemale isi Balisia ata la nohovu. Laeau loboe ataea. La keau gobuvu lobogevei oeabemo kunaiabe malema. La katelahaito lobolahai atae nimo noinoi egete vama. Katealemo Dilavana vatehani baluga laovei. ");
INSERT INTO kpx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Iale menaka haivemale isi Balisia ata, la katelahamale la nohovu. Laeau loboe ataea. Lana e houevei haeavamole tiliege ata holoevege abuna la ehovei la vaveve ke nahate vage lana kebia aiogeveve. La kateale vamalemo kebiahi humahae toelala tima. Isito keabuna la vaveve toela ke evihai vaveve toela baluga vai. ");
INSERT INTO kpx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Iale la nohovu. Laeau ata nalievemale ataea. Isito laeau ni kedute kebia nahate holisi ata haive toela vama. La ata haivei loui kosea, ‘Mesoho lana la hoto vuvunete louliege dubue ivi unaha louge keu bae vuvunealivebene. Isito lana dubue uvumo golo ke ivi louliege la hoto kena vuvuneage lana ke vave.’ ");
INSERT INTO kpx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","La hoto ke loumalemo la luleleholisito ni kedute nahate vama. La huhuige oleteu baluga. Golo emena dubu. Dubu keu baluga. Kosealemo dubu keu uoholige golo keu bae balugalivebene. Isito dubu ualemoike golo keu baluga. ");
INSERT INTO kpx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Isi la tota ata haivei loui kosea, ‘La oleu dubue vavamo mune vitale abu avuemo Dilava hoesehavomale ke ivi loui hoto tumute louale keu bae vuvunealivebene. Isito la oleu mune vitale kemo abu mesia mahosege au hoto tumute loui ivive louale ke hotona vuvuneai.’ ");
INSERT INTO kpx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","La hoto ke louito laeau ni kedute nahate vama. La huhuige oleteu baluga. Ono mole mai mahoi Dilava hoesehavomale ke emena mune vitale. Mune vitale keu baluga. Kosealemo kena abu ono mole mai ke golomo mahoale ke mai tumutisi. ");
INSERT INTO kpx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iale ata molena mune vitale kemo hotoe tumu louniege golovemo mahoale ketamoike au hotoe tumu lounu. ");
INSERT INTO kpx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ige ata olena dubumo hotoe tumu louniege Dilavau dubu ke uvumo umale ketahoike au hotoe tumu ke lounu. ");
INSERT INTO kpx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ige ata olena otogomo hotoe tumu louniege Dilava telona isi avuemo ugulamoale ketahoike au hotoe tumu lounu. ");
INSERT INTO kpx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Menaka haivemale isi Balisia ata la nohovu. Laeau loboe ataea. Laeau la bulue lovi ke bahatamo taidi malei Dilava omima. La katelahaito Dilava menaka baluga ehovaholilu. Dilavau isivialeike laeau mole vaveve toela ibina va halevaito moleho uvulahai mole tedaevei kemo inutolotololahai. La vaveve baluga kebia vaeveito bae vaveve esehame kebiata vaevege duave. Isito laeau katelahaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Laeau ata nalievemale ataea. Isito laeau ni kedute kebia nahate. La Dilava menaka baluga ke elehai ehovaholisito menaka esehame unaha elehai ehovama. ");
INSERT INTO kpx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Menaka haivemale isi Balisia ata la nohovu. Laeau loboe ataea. La vaveve keau abu melegita kabutae vava totoaito uvuve totoholiale ke nahate. Ataeau la vaveve elehage keu duave. Isito la uvu kemo huhuihuhuie toela moagaeau uge la mole kunaiho isivilahama. ");
INSERT INTO kpx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Balisia ataea, la keau ni kedute nahate. Vasohuta la uvu ke hoesehavoge la vaveve keabuna bae duaveai. ");
INSERT INTO kpx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Menaka haivemale isi Balisia ata la nohovu. Laeau loboe ataea. La keau abu alue vutamo mune otovei benievege taeale ke nahate. Abu katelahage ehue hovadave keu duave. Isito heie uvuve keve vavaeabe keau hisilahalu. Ige keve itava unahaeau ua. ");
INSERT INTO kpx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iale laeau ke nahate. Ataeau la vava elehage duave seleve. Isito la uvu kemo loboe vaveve toela moagaeau ua. ");
INSERT INTO kpx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Menaka haivemale isi Balisia ata la nohovu. Laeau loboe ataea. Laeau belovetaeau haluviale kebia vuta kaeagevei atae duaeau haluviale kebia vutata kaeagevema. ");
INSERT INTO kpx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","La vaveve kateale vai loui kosea, ‘Noeau subuta no buluve vani kemo uvatege no buluveau beloveta haveale ke nahate vaholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","La loui kosea, ‘No buluveau beloveta kebia havelu. Iale hoto kemoike di hilokage lana kebia vaveve ke nahate vave. ");
INSERT INTO kpx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iale talive momolelahai la buluve vaveve ke nahate vageve. ");
INSERT INTO kpx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","La keau utee esea. La vaveve keau uteu goligoliale ke nahate. Iale lana oleve kateai bae veneu hodovavesiteve tiveve ke aehai. Keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iale di la namigevege evive. Dana bae beloveta ata, lulelete ata, isi menaka loui haivemale ata kebia laheho hanavei. Ige lana kebia degomole havei degomole malei idimo haveve. Isi dubue uvue degomole visugevei kebia nunuvege abuna detuluvisi o igaegae tai. ");
INSERT INTO kpx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lana kateale vage Dilavana ibinave vai vatehani baluga laovei. Subuta mole abu atae dua havege keau haluvilu. Vasohuta la buluveau Eibolo hamage au hatinu. Ige abu kemo lavisi atae dua havei loholata gabivela abu Balakia mo Sekalaia mai dubuta mune vitaleta vigomo hamage au hatinu. ");
INSERT INTO kpx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iale seleveta di la namigevei. Vaveveabe ke ibinana novae ata la kebiamo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Iei! Dielusalema ataea, la nohovu. Dilavau au hoto louveve beloveta laheho hanavege la muneta kebia havege abu haluvilu. Vani moagamoaga di isiviale la malevei di adae uvumo otovei. Kokoluguu au ese bevuevei goloeabemo amuleale ke nahate. Isito laeau daho isiviholilu. ");
INSERT INTO kpx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","La katealemo gabie la o kena samiai uoholisi. ");
INSERT INTO kpx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iale di la namigevege evive. La bae tota di vaveve dua elehalivebene. Isito lana la vaveve toelamo hoidevei loui kosea, ‘No Kosiveu Dilava ivimo lohoi no hoesegevenu.’ Lana kateai louliege bae tota di vaveve dua ke elehave.” ");
INSERT INTO kpx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesuu kateai loui kebia namigeveito dubu baluga ke halei tisege esemuiabeau avue lohoale namihai avoe, “Dubu baluga ke eleha. Dubu uokeu dubue dua baua.” ");
INSERT INTO kpx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ige Iesuu namigevei avoe, “Seleveta di la namigevege evive. La dubu ke elehale ke ataeabuna gabie loholiege dubu ke koilahage mune moleu bae mune mole golomo ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesuu kateale louito lohoale tana mole Oliveta ke kobola ugulamoi ahuvela ua. Isege esemuiabeau avue lohoale namihai avoe, “No namigevenela. Osiomalela vaveve katealena lohoi. Isi noeabuna oleve kateai a lohoveve vani ke hilokage a kemo lohoge vatana gabiai.” ");
INSERT INTO kpx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ige Iesuu namigevei avoe, “La ebia nenigeveve. Onoilage loboe ataeau la lobogevege dobuluvima. ");
INSERT INTO kpx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kosealemo ata moagaeabuna loholiege di ivimo la lobogevei loui kosea, ‘Dau Keliso.’ Isi kemo ata moaga lobogevei malevei. ");
INSERT INTO kpx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ataeau haeavamoleve mesoho vuguta tuvalilahage lainaho ke evisi vabulahagelive. Kosealemo vaveve katealena vasohuta lohosege ke iae vanie gabina bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vani keu lohoho vasege vata mole ata keabuna hovedevei vata mole atahi tuvalilahai. Isege vata bahatamo vae balugaeabuna lohoi. Ige vata bahatae hamu balugana hatui tai. ");
INSERT INTO kpx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vaveve katealena vasohuta lohogeto bae gabie vaveve toela degomole abuna bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Isito vani kena lohoholisege ataeabuna la malevei lahavege lana vatehani malei haluvive. La di ata holialemo atae abuna laheho itumulahai huhuihuhuie toela vai. ");
INSERT INTO kpx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Isi vani kemo abuna katelahasege ata moagaeabuna abu evievimo dobuluvisi. Abuna moleho hailahai molehi ugologololahai. ");
INSERT INTO kpx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Isege loboe beloveta moagaeabuna lohoi ata moaga lobogevei. ");
INSERT INTO kpx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ige kemo vaveve toela balugana matama bahata sonumai tige ataeau moleho isivilahai mole tedaevemale ke abu bae valivebene. ");
INSERT INTO kpx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Isito oleuoleu abu evievimo negolahamale keabuna vanie gabila ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iale di esemuiabuna tiliege ataeau Dilava adae vuvunemo uveve hotoe dua ko loui ata bahata namigevege abu bahata hotove ke evige vatana bae gabiai.” ");
INSERT INTO kpx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Vanie gabila lana bae vaveve nimoleteu Diue dubu baluga ke uvumo lamige bae elehave. Subuta beloveta Danielau vaveve keike au loui hisalianu. (Iale oleuoleu hoto ko dodaveliege ihuve kaovai.) ");
INSERT INTO kpx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Vaveve katealeu lohoge Diudia vata komo umale la keau detuluvisi tanae teve. ");
INSERT INTO kpx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ige la oleu au oe dokoe uniege aulako oe uvue tai au hau malelive. ");
INSERT INTO kpx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Isi la oleu au bulue uniege aulako au oe hoilahai au dabae ogo malive. ");
INSERT INTO kpx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Vani kela keate ese tobute kebia nohovu. Isege keate degomole ese gite maleale kebiata nohovu. Abuna vani kela vaveve toela malei. ");
INSERT INTO kpx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Iale guliguliage elike vaveve katealeu vanie toelamo mesoho bulamo loho haleito vanie duamo lohoi. Ige elike vanie duamo detuluvive. ");
INSERT INTO kpx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vani kemo vaveve toela kena balugataho seleveai. Subuta toela baluga katealebeu vatae lohoholinu. Isi katealeu bae tota gabie loholivebene. ");
INSERT INTO kpx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vani keu lohoge Dilavana au ata tabageveale kebia huhuevei vani ke mai vuguvugutisi. Isito auna vani ke mai vuguvugutioholige ata bahatae abuna haluvisi. ");
INSERT INTO kpx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Iale vani kemo mesoho loboe ataeau laheho loui kosea, ‘Kelisoike ko lohonu.’ O mesoho loui kosea, ‘Avuike uoke lohonu.’ Ige lainaho hotoeabe evilive. ");
INSERT INTO kpx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kosealemo loboe keliso isi loboe beloveta keabuna bae loholiege vaveve degomoleta vikoe vaveve kebiata vaevei isiviale Dilava ata lobogevei malevei. ");
INSERT INTO kpx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Isito vani keu lohoholisege di vasohuta vani ke vaveve loui la namigevege evive. ");
INSERT INTO kpx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mesoho ataeabuna la namigevei kosea, ‘Elehave. Kosive keu tomagie ua.’ Ige lainaho keve talive. O mesoho abu loui kosea, ‘Elehave. Kosive keu kove hogolahai ua.’ Ige lainaho hotoeabe evilive. ");
INSERT INTO kpx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kosealemo vaniu velemamaleve hatau nivolekai lohoi vaniu dobamaleve kibalai tige ataeau elehale ke nahate Atae Esena otogomo dobai lohoge ataeabuna bahata elehai. ");
INSERT INTO kpx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mesia moleu hatisi hisiage uguiau ke iliho mole bevueveale ke nahate vaveve nimolete keabuna velehovoge lana ke elehai huhuige di lohoveve vaniu vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesuu kateai louito tota loui avoe, “Vani kemo vaveve toela katealeu lohoi gabiasege iave keve vanina loai. Ige batau bae halulivebene. Ige didi abuna otogomo keiolahai. Isege onobenobe bahata otogomo umale keabuna kibikibiai solahai. ");
INSERT INTO kpx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kateimale vanimo Atae Eseu lohoveve vaveve kena otogomo velemage vatae ata bahata keabuna ke elehai ninalahai. Isi elehasege Atae Esena au vuvuneta au atagata goe golomo dobai lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ige kibiu hotoige auna au anelu iovege abuna vata bahatae tiliege vatae dei abuita abuita keve au ata tabageveale kebia bahata malevei igaetoai bevuevei.” ");
INSERT INTO kpx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Idi mole ivi vigi kemo di hoto mole louge lulelelahave. Idi kena humuai velahage lana ke elehai hilokage vaganau vuguvuguanu. ");
INSERT INTO kpx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iale ke nahate di loui la namigeveale vaveve keau lohoge kebia elegevei loui kosea, ‘Atae Eseu lohoveveu vuguvuguai udahae vavamo ua.’ ");
INSERT INTO kpx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Seleveta di la namigevema. Novae ata koeabuna haluviholisege di louale vaveve kebia bahatae abuna lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ige otogona vatati uoholisi. Isito di hotou bae uoholilivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Atabeu di lohoveve vani ke hilokaholinu. Ige otogoe umale anelu kebiata hilokaholilu. Ige data ke hilokaholinu. Isito di Mama igaeu ke hilokanu. ");
INSERT INTO kpx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ataeau subuta Noa vanimo vamale ke nahate ataeabuna Atae Eseu lohoveve vani ketamo katelahai. ");
INSERT INTO kpx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa vani kemo e balugau lohoholisege ataeau lovi isi e isi mole holoevema. Abu katelahalage Noau bouti baluga uvue tinu. ");
INSERT INTO kpx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abu katelahai hilokaholisege solekavesite e balugau lavui kebia bahata havehatunu. Iale Atae Eseu lohoveve vani kemo abuna katelahasege auna lohoi. ");
INSERT INTO kpx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Vani kemo malaha abui abuna igaetoai bulue lovilahasege Dilavana mole maito mole halei. ");
INSERT INTO kpx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ige keate abui abuna igaetoai lovi vasege Dilavana mole maito mole halei. ");
INSERT INTO kpx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iale Atae Eseu lohoveve vani ke la hilokaholiale kemo la ebia nenigeveve. ");
INSERT INTO kpx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Isi ko huhulahave. Oe biagena vavoloe atau lohoveve vani ke hilokai nita uniege vavoloe ata keu bae lohoi ovemo vavoloalivebene. ");
INSERT INTO kpx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iale ke nahate lata nita uve. Kosealemo Atae Eseu lohoveve vani ke la hilokaholisege auna bae lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Iale esemu olena au evievimo negoai luleleige Kosivevena ke ebagemage auna esemuiabe degomole kebia nalievei vavita gututa lovi ovegei. ");
INSERT INTO kpx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Isege Kosivevena tiniege tota hoilahai lohoniege esemuveu lovie dua vale ke elehai vahaehove vai. ");
INSERT INTO kpx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iale seleveta di la namigevege evive. Kosivevena au esemu ke ebagemage auna kunaive bahata nalievei. ");
INSERT INTO kpx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Isito kena esemu toela holiniege auna huhuai kosea, ‘Di Kosive keu tiale au bae solekai loholivebene.’ ");
INSERT INTO kpx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Isi kemo auna Kosive ke esemu aiogevei havei tiniege lovi baluga isi atae toelahi e toela igei. ");
INSERT INTO kpx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Iniege vani mole Kosiveveu lohoveve vani ke hilokaholisege auna lohoniege esemu ke elehai hamai lovi kemo iomage auna tiniege loboe ataeau umale matamae toela keve ui. Matama keve ataeabuna uvulahai ninalahaime monomo hediavogei.” ");
INSERT INTO kpx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesuu tota loui avoe, “Vani kela ataeau Dilava adae vuvunemo uveve mesoho uoholiveve keu mahoho ada mole isi ada mole kebia vaveve nahate. Keau abu lameba hanevei mo moleu au mahina melameho vage abu elehaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mahoho ada mole keau luleleholioholilu. Isege ada mole keau luleletea. ");
INSERT INTO kpx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Luleleholiale keau lameba maleito kelesinibe malei tioholilu. ");
INSERT INTO kpx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Isege lulelete keau botolomo kelesini binihei malei tilu. ");
INSERT INTO kpx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Keau bahata tiale mahina melameveve mo ke hemei ulage keu solekai lohoholinu. Ige mahoho kebia niu haniage abu ladevelu. ");
INSERT INTO kpx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ladevesege vavie minamo ata moleu hoai avoe, ‘Mahina melameveve ata keu lohoma. Iale lohoge nahi talive hoesehavoi.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kateai louge mahoho nehe keau hovedevei abu lameba hoesegevelu. ");
INSERT INTO kpx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ige luleleholiale keau lulelete kebia namigevei avoe, ‘No kelesiniu uoholima. Iale kelesinibehame noeveve.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ige lulelete keau namigevei avoe, ‘Ba, no bae laovelivebene. Kosealemo kelesini kou nahie neniholioholinu. Iale talive valahue voilahave.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Katelahai louge luleleholiale keau hovedevei kelesini voieveho tilu. Keve tisege mahina melameveve keu velemanu. Ige lulelete neheau hemei uale keau avuluvuta oe uvue lovive iliho tilu. Oe uvue tisege oe biageu udaha bamunu. ");
INSERT INTO kpx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Isege gabie mahoho nehe luleleholiale keau velehovoi udaha hamai loui avoe, ‘Kosive, noheho udaha alavonela.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ige au abuho loui avoe, ‘Seleveta di la hilokaeveholinu. Oleme laea.’” ");
INSERT INTO kpx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iesuu deiada ke louito tota namigevei avoe, “Nibie tumu vave. Kosealemo laeau di lohoveve vani ke hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Di lohoveve keu koseanu. Kosive moleu o haeavamoleve taliho au esemu abuita igaeta hohavege abu avue loholu. Ige au kebia namigevei isiviale keau kunaive nalievei. ");
INSERT INTO kpx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Isime kateai luleleabe kemo moni ovenu. Au vasohuta vai taoseni kina (K5,000) mai mole ominu. Isi tu taoseni kina (K2,000) mai mole ominu. Isi uani taoseni kina (K1,000) mai mole ominu. Kateai kebia oveito halevei haeavamoleve tinu. ");
INSERT INTO kpx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Isege vai taoseni kina (K5,000) maleale keu solekai ke mai tiale monite ata mole ominu. Iniale tota kemo vai taoseni (K5,000) mole manu. ");
INSERT INTO kpx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ige emo iavemo tu taoseni kina (K2,000) maleale keu avuta ke nahate vai tu taoseni (K2,000) mole manu. ");
INSERT INTO kpx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Isito uani taoseni kina (K1,000) male keu kateholisito tiale vata lovoi au kosive moni ke mai abavunu. ");
INSERT INTO kpx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Iniale vani moagau uoholige esemu kebia kosiveu tota hoilahai lohoale esemu kebia hohavei isiviale abu moni maleale ke vaveve abuemo kaovai hilokai. ");
INSERT INTO kpx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ige oe neheu vai taoseni kina (K5,000) maleale keu lohoale ke mai omisi tota vai taoseni kina (K5,000) mole keta malei ominu. Isi namihai avoe, ‘Kosive, a vai taoseni kina (K5,000) mai daoale keike di mai tiale ata mole omisi tota kemo vai taoseni kina (K5,000) mole ko manu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ige kosive keu au esemu ke namihai avoe, ‘A keu esemue dua. A keu di moni ke nalieve dua vanu. A monie ese kemo lovie dua vale kemo dana a ebagemai lovi baluga mai aoge ana ke nalinela. Iale lohoge nahi vahaeholahai.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ige tu taoseni kina (K2,000) maleale keu lohoale au kosive namihai avoe, ‘A tu taoseni kina (K2,000) mai daoale ke di mai tiale ata mole omisi tota kemo tu taoseni kina (K2,000) ko manu. Iale ko bahata malenela.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ige kosive keu namihai avoe, ‘A keu esemue dua. A keu di moni ke nalieve dua vanu. A monie ese kemo lovie dua vale kemo dana a ebagemai lovi baluga mai aoge ana ke nalinela. Iale lohoge nahi vahaeholahai.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ige uani taoseni kina (K1,000) male keu lohoale namihai avoe, ‘Kosive di hilokage au ata negote. A bulu holioholiale kemo ana lovi malenela. Isi a vata haholiale kemo ana tiniege lovi lovonela. ");
INSERT INTO kpx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iale kemoike di a vabuhavoi tiale vata lovoi a moni mai daoale ke malei abavunu. Iale a moni keike di mai lohoale ko elehanela.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ige kosiveu avuho loui avoe, ‘A keu esemue toela. A keu neniai di lovi vaholinu. A hilokage dau di bulu holioholiale kemo dana lovi malegei. Isi di vata haholiale kemo dana lovi lovogei. ");
INSERT INTO kpx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iale abege di moni mai aoale ke a mai banikamo mamoge duave. Ilive elike moni ke goloe moleta mage duave. Isito a kateholinu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kateai namihaito au esemu mole namihai avoe, ‘Avuemo moni ke mai uokeve teni taoseni kina (K10,000) maleale ke ominela. ");
INSERT INTO kpx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kosealemo oleu moaga maleale kena moaga malei. Isito oleu maleholiale keu bae onobe malelivebene. ");
INSERT INTO kpx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iale esemue toela ke mai heie matamae loe ataeau uvulahai ninalahaime monomo hediavomale keve mihatunela.’” ");
INSERT INTO kpx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesuu deiada ke loui namigeveito tota hoto mole loui namigevei avoe, “Gabie Atae Esena au atagamo dobai lohoge anelu bahata keabuna avuluvuta lohoi. Ige auna au telona atagatemo ugulamoi atae vaveve kaovai. ");
INSERT INTO kpx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Isege vatae ata bahatae abuna igaetoai vudivemo ui. Ige auna kebia tasaligevei degomole malei vaki mole otovei degomole malei vaki mole otovei. Ovo nalimaleu mamoeta nanigosita tasalieveale ke nahate auna mamoe malei au ada inuteve otovei. Isi nanigosi malei au ada agiteve otovei. ");
INSERT INTO kpx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Auna kateaito au ada inuteve uale kebiaho loui kosea, ‘Di Mamau la vahaeho vai la hoesegevenu. Iale loholive di Mamau subuta vasohuta vata vaholisito la adave vuvunemo uveve matamae doga vale keve uve. ");
INSERT INTO kpx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kosealemo di vaeisege la lovi mai daovalu. Isi di enuisege la e hai daovage di inu. Isi di la oe ohanoi tisege la di mai o hatulu. ");
INSERT INTO kpx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Isi di ogoholisege la ogo mai daovalu. Isi di vavahaniasege la di elehai di tedaholu. Isi di dibulae usege la tiale di elehalu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Auna kateai louge atae duaeau adave inuteve uale keabuna hotove ibina vai avuho loui kosea, ‘Kosive, osiomalela a vaeisege no lovi mai aovalu. Isi a enuisege no e hai aovage a inu. ");
INSERT INTO kpx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Isi oleveike a noe lohosege no a mai o hatulu. Isi a ogoholisege no ogo mai aovalu. ");
INSERT INTO kpx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Isi osiomalelaike a vavahaniasege no a elehai a tedaholu. Isi a dibulae usege no tiale a elehalu. Osiomalelaike no vaveve kateale aemo valu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ige auna namigevei loui kosea, ‘Seleveta di la namigevei. Mesoho la oleu di ata molehame ivi holioholialehame ke hoesehavoi vaveve kateale avuemo vale keu daemoike au ke vanu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Auna kateai kebiaho louito au ada agiteve uale kebiaho loui kosea, ‘Lotai evihave. La keau Dilava nimo toela balugalu. Talive Dilavau Seteneta esemuiabetaho vene hodovavesite vai mamoale keve uve. ");
INSERT INTO kpx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kosealemo di vaeisege la lovi daovaholilu. Isi di enuisege la e hai daovaholilu. ");
INSERT INTO kpx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Isi di la oe ohanoi tigeto la di mai o hatuholilu. Isi di ogoholisege la ogo daovaholilu. Isi di vavahaniasege la di tedahoholilu. Isi di dibulae uge la dae tai di elehaholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Auna kateai louge abuna hotove ibina loui namihai kosea, ‘Kosive, osiomalelaike a no oe ohanoi lohoge no a mai o hatuholilu. Isi a vaeai enuai ogoholisi vavahaniai dibulae usege no a elehai a tedahoholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ige auna namigevei loui kosea, ‘Seleveta di la namigevege evive. Laeau di ata molehame keho isiviholisi tedahoholiale keu daike la ke tedahoholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ige Dilavana vaveve kateale vamale ata kebia hanavege abuna veneu hodovavesite keve ibinae toela malei. Isito vaveve dua vamale atae dua keabuna ehue tiliege ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesuu hoto ke bahata loui au esemu haivei gabiaito tota abuho loui avoe, ");
INSERT INTO kpx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“La hilokage vani abuita uoholisege Diue vahaeho vani Basova kena lohoi. Ige vani kemo ata molena Atae Eseho haiai mai atae toela ovege abuna mai idie domo hamai.” ");
INSERT INTO kpx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iesuu kateai lousege dubu nalimale kosiveau, Diue menaka loui haivemaleau isi oe kosive keau igaetoai dubue kosive baluga Kaiabasi oe loholu. ");
INSERT INTO kpx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Keve lohoale Iesu maveve humaha kaovai isiviale lobohavoi mai hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Isi mole namigevei avoe, “Nahi vahaeho vani kemo va halevai. Kosealemo nahiabuna kemo mage ataeabuna ke elehai itumulahai nahie havei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kateisege Iesuu Betenie subuta lebolasi male Saimoni ke oe lovi ima. ");
INSERT INTO kpx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Avuti lovi isege keate moleu deholo mole hagote mai lohoale kinavemo ehosivanu. Deholo ke ibinau balugataho. ");
INSERT INTO kpx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kateige Iesu esemuiau ke elehai itumulahai mole namigevei avoe, “Senisi ke ibinau balugataho. Iale osiohoike keate keu ke bahata ehosivahatunu. ");
INSERT INTO kpx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Abege au ke mai voiai kemo moni baluga malei kunaiholimale kebia ovege duave.” ");
INSERT INTO kpx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kateai louge Iesuu ke evisi abuho loui avoe, “La osiohoike hoto kateale loui keate ke aiohavoma. Keu daemo vaveve duaike au ke vanu. ");
INSERT INTO kpx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vani bahata kunaiholimale keabuna lahehi usege lana bae kebia tedaevegeve. Isito dau bae lahehi vani bahata ui egealivebene. ");
INSERT INTO kpx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Keate kou senisi mai daemo ehosivale keu koseanu. Di hativeveu aike vuguvuguike vage au ke vai di vava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Seleveta di la namigevege evive. Di esemuiabuna oleve keve tiliege hotoe dua loui ata haivei keate kou vale keta loui ata namigevege abuna au onole vale ke huhulahagei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iesu esemu tuelo (12) kebiamo ata mole ivi Diudasi Kaliota keu dubu nalimale kosive kebiae tinu. ");
INSERT INTO kpx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Isi namigevei avoe, “Dana Iesu mai laovege lana moni vaesute malei daovave.” Ige abu moni dodavelata vahate bahata teti (30) malei omilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ige kemo Diudasiu lamisi Iesu maveve humaha ke kaovama. ");
INSERT INTO kpx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Diue vahaeho vani Basova keu lohonu. Vani kemo abu bae beikini baudata valava mahoale ke ilivebene. Iale vani kemo esemuiau namihai avoe, “A isiviale noeabuna oleve keve Basova lovi vage nahi isi.” ");
INSERT INTO kpx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ige Iesuu namigevei avoe, “Talive Dielusalemae ata mole namihai kosea, ‘Nahie haivemale kosive ke vaniu vuguvuguanu. Iale keu isiviale au esemuhi a omo Basova lovi isi.’” ");
INSERT INTO kpx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kateai namigevege esemuiabeau tiliale au louale ke nahate o kemo Basova lovi valu. ");
INSERT INTO kpx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iniale gutumo Iesuu au esemu tuelo (12) kebiahi ugulamoi lovi ilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lovi isege Iesuu loui avoe, “Seleveta di la namigevege evive. La mole igaena di mai atae toela ovei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ige abu ke evisi uvulahai igaegaeai Iesu belahai avoe, “Kosive, danike a ke huhuai hoto ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ige Iesuu namigevei avoe, “La moleu daiti melegi igaemo igaetoai lovi iale kena bae di mai ata ovei. ");
INSERT INTO kpx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ige Bukae Hotou louale ke nahate dana hatai. Isito oleu daho haiale ata ke nohoma. Abege neinaveu mamoholige duave. Isito neinaveu mamoge au di mai ata oveale kemo auna vatehani baluga malei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kateai louge haiale ata Diudasi keu hovelahai namihai avoe, “No haivemale ata ana danike huhuai ke lounu.” Ige Iesuu namihai avoe “Avuike a ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iesuu kateai louito ke iae abu lovi isege valava mai hoesehavoi ke vakoai au esemu ovenu. Isi namigevei avoe, “Kou di misilike ko. Iale ko malei ive.” ");
INSERT INTO kpx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Isi tota kabu mai hoesehavoi mai ovei namigevei avoe, “Di tahoike ko. Di tahou lotige Dilavana ke elehai menakae doga mamoi ata bahatae toela ulihai. Iale la bahata ko mai ive. ");
INSERT INTO kpx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Isito di la namigevege evive. Di bae vata kove tota lahehi e ko i molealivebene. Isito gabie di Mamae matamae doga keve nahi bae igaetolahai uainie doga isi.” ");
INSERT INTO kpx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kateale louge uoholige abu nogoli louito halevai Oliveta tanae tilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abu tisege Iesuu namigevei avoe, “Novae vavi komo la bahatae abuna di halevai detuluvisi tihatuve. Kosealemo Bukae Hotou loui avoe, ‘Dilavana mamoe nalimale ata ke hamage mamoeve abuna detuluvisi igaegaeai.’ ");
INSERT INTO kpx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Isito auna tota di etuvage dana hovelahai Galili vatae tisege lana bae keve tiliege di elehave.” ");
INSERT INTO kpx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kateai louge Bitau hovelahai namihai avoe, “Mesoho a esemu degomole koeabuna a halevai. Isito dau bae a halelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ige Iesuu Bita namihai avoe, “Seleveta di a namihage evi. Novae vavimo kokoluguna hotoholisege ana bae di vovoho abuita igaetanela.” ");
INSERT INTO kpx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ige Bitau negoai avuho loui avoe, “Di bae a vovohoveve hoto ke loulivebene. Halege a hatige dana data hatai.” Kateai louge esemu keau bahata hoto ke igae loulu. ");
INSERT INTO kpx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Abu katelahai louge Iesuu kebia holoevei abuhi tiale matama mole ivi Gesemani keve velehovolu. Ige au keve abuho loui avoe, “Kove usege di talive uokeve guliguliai.” ");
INSERT INTO kpx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kateai au esemu kebia haleveito Bita isi Sebedi mo abuita kebia unaha holoevei abuhi tilu. Tisege uvuve keu ono vadeu avuemo lohoveve ke huhuige avuemo isuanu. ");
INSERT INTO kpx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ige au esemu kebia namigevei avoe, “Di uvu balugage di uvuu di mai hatihatie humahamo tima. Iale komo ulive lainaho ladevelive. Isito daluvuta nita uve.” ");
INSERT INTO kpx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Isi kateai louito tiale iekela kome bokoai vata bisi holumai Dilava imihai loui avoe, “Mamai, a isivianiege vatetumu ko daemo mai evihanela. Isito a isivi unaha. A isiviage dana vatetumu ke malei. Isito a isiviholige di bae ke malivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Au kateaito hoilahai au esemu abuita igaeta kebiae lohoge keau ladevema. Ige au Bita namihai avoe, “Osialemoike la vanie ni igae komo daluvuta nita uoholima. ");
INSERT INTO kpx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Negobedai nita ui di Mama imihave. Ilive elike vaveve mole toelau laemo lohoge la bae kemo dobuluvilivebene. La uvu keu isiviai nita ui. Isito la vava keu negoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kateaito tota halevei tiale iekela au Mama imihanu. Isi loui avoe, “Mamai, di isiviale vatehani ko aehai. Isito a hilokage di kateige keu anekianu. Iale dana a isivi unaha vai.” ");
INSERT INTO kpx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kateai louito hoilahai lohoale au esemu elegevege niabeu hani selevealelua ladevelu. ");
INSERT INTO kpx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ige Iesuu halevei tiale tota au Mama imihai au subuta louale ke nahate lounu. ");
INSERT INTO kpx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Isi tota halei hoilahai au esemue lohoniale abuho loui avoe, “Lana sohu ladevei uma. Isito abu di mai atae toela oveveve vaniu lohonu. ");
INSERT INTO kpx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iale hovedevege nahi tai. Elehave. Daho haiale malaha keike uoke lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesuu kateai lousege esemuve mole Diudasi keu lohonu. Ige ata moagaeau avuluvuta lohoale keau siga matagevei visuta matagevei loholu. Diue dubu nalimale kosive isi oe kosive keau louike vage abu Iesu maliho loholu. ");
INSERT INTO kpx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ige Iesuho haiale malaha keu subutaike ata moaga kebia namigevei avoe, “Elehalive di talive malaha ke evudei ulikukuhavoge ke mave.” ");
INSERT INTO kpx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iniale Diudasiu lohoale velemai inuta tiale Iesu namihai avoe, “Di Kosive, ana duave.” Isi kateai evudei ulikukuhavonu. ");
INSERT INTO kpx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ige Iesuu namihai avoe, “Di haoka, momoleai a osioho kove lohoale ke vanela.” Ige ata nehe keau hovedevei Iesu evudei malu. ");
INSERT INTO kpx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ige Iesu esemu moleu au siga mai dubu nalimale kosive ke esemu mole golema heisi etulenu. ");
INSERT INTO kpx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ige Iesuu au esemu ke namihai avoe, “Kate haleito a siga mai mamonela. Kosealemo oleuoleu sigata ata havege abuna abuta ibinaveho sigata kebia havei. ");
INSERT INTO kpx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ana hilokaholinu. Dana isivianiege di Mama imihage auna solekavesite anelu moagamoaga hanavege abuna di tedahoi. ");
INSERT INTO kpx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Isito dana kateige Bukae Hotou louale keu bae selevealivebene. Di isiviale abu di mage elike Bukae Hoto mai selevetisi.” ");
INSERT INTO kpx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Au kateai au esemu namihaito ata moaga kebia namigevei avoe, “La huhuige dau vavoloe ata seleve. Ilike vage la di maliho sigata visuta malei loholu. Di vani bahata la dubu baluga keve timale ata haivema. Isito osialemoike la keve di maholilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Isito vaveve bahata koeau beloveta ataeau subuta Bukae Hotomo hisaliale ke mai selevetilu.” Kateai lousege esemuiabeau bahata halevai detuluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ata keau Iesu evudei mai dubu nalimale kosive Kaiabasi keve tilu. Keve Diue menaka loui haivemale isi oe kosive keau mole bevuevei igaetoai ua. ");
INSERT INTO kpx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Abu Iesu mai tisege Bitau kebia ialialigevei tiale keu dubu nalimale kosive ke oe ulidae tinu. Tiale keu bukateau uguiavomale keve abuhi ugulamoi isivialeike abu Iesuemo vaveve oleteale vale ke bahata elehai. ");
INSERT INTO kpx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Isege dubue kosive isi oe kanisolo keau isiviale Iesu vavamo loboe hoto loui hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ige ata moagaeau lohoale vavavemo lobolahage kosive keau ke kaovaito hamaveve humaha elehaholilu. Ilage gabila malaha abuitaeau hovedevei hoto mole loulu. ");
INSERT INTO kpx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Abu loui avoe, “Malaha keu loui avoe, ‘Dana Dilava dubu baluga ke koiai. Iniege vanie ni abuita igaetana uoholige dana tota ke houi gabiai.’” ");
INSERT INTO kpx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ige dubu nalimale kosive balugau hovelahai Iesuho loui avoe, “Ana valive hotoeabe abu loumale ke ibina loui namigevei.” ");
INSERT INTO kpx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ige Iesuu hoto ke ibina louholinu. Ige dubu nalimale kosive baluga keu tota belaha moleai avoe, “Di ukolikoli Dilava ke ivimo di a mai a vaveve kaovama. Iale ke ivimo hoto seleve loui no namigevenela. Au ana seleveta Dilava mo Keliso.” ");
INSERT INTO kpx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ige Iesuu namihai avoe, “Avuike a ke lounu. Iale di la bahata namigevege evive. Lana ui tiliege gabie Atae Esena ehue vuvunete Kosive ke ada inuteve ugulamoito otogo halei goemo dobai lohoge lana elehave.” ");
INSERT INTO kpx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kateai louge dubu nalimale kosive baluga keu itumuai au ogo edikohai ata namigevei avoe, “Hoto kemoike keu Dilava ivi aiohavonu. Iale kemo nahi bae ata degomolemo vaveveve kaovalivebene. La aike hotove toelaike ke evilu. ");
INSERT INTO kpx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Iale la isiviage nahi avuemo osioi.” Ige abu namihai avoe, “Keu vaveve toela vanu. Iale hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Isime nivemo violahai visuhavoma. Isege degomoleau adata nivemo hamai avuho loui avoe, “Seleveta Dilavau a hanavoge a Keliso holialemo no namigevenela. Oleike aike ahamonu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Abu katelahasege Bitau heie ologoe ua. Ige dubue kosive baluga ke omo loviamale ma moleu lohoale Bita elehai avuho loui avoe, “A keu Galili ata Iesuti loviamale ata.” ");
INSERT INTO kpx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ige Bitau ata kebia bahata vudimo Iesu vovohonu. Isi ma ke namihai avoe, “A onole louale ke di hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Isito tiale udahamo lamisi usege o kemo lovimale ma moleu lohoale Bita elehanu. Isi ata namigevei avoe, “Iesu keu Nasaleta ata. Iale ke esemu moleike ko.” ");
INSERT INTO kpx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ige Bitau hotove hamai namihai avoe, “Seleveta di a namihai. Di malaha ke hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kateai louito usege lavisi umale keau Bitae lohoale namihai avoe, “Seleveta a keu esemuve mole. No a hoto kemo valitige a keu Galili ata.” ");
INSERT INTO kpx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ige Bitau ke evisi Dilava ivi loui mai aiohavoi abuho loui avoe, “Di malaha ke hilokaholinu.” Kateai lousege kokoluguu hotoanu. ");
INSERT INTO kpx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ige Bitau ke evisi Iesu hoto huhuanu. Iesuu subuta namihai avoe, “Kokoluguu hotoholisege ana bae di vovoho abuita igaetanela.” Kateai ke huhuai halei tiale iekela nina tumutumuanu. ");
INSERT INTO kpx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vavita vavita dubu nalimale kosive bahata isi Diue kosive keau igaetoai Iesu hamaveve humaha kemo abu isivie hoto loulu. ");
INSERT INTO kpx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hoto louge uoholige abu Iesu umuvai mai tialeau Loma kosive Bailoti omilu. ");
INSERT INTO kpx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ige Iesuho haiale Diudasi keu ke elehai hilokage Iesuna hatai. Isi au vaveve toela ke huhuai halei monie luhu teti (30) ke malei tiale dubu nalimale kosive isi oe kosive kebia ovenu. ");
INSERT INTO kpx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Isi namigevei avoe, “Di atae dua keho haiale kemo auna hatai. Iale keu vaveve toelaike di ke vanu.” Ige abu namihai avoe, “Halege keu a isivilike. Iale no bae a hoto ke evilivebene.” ");
INSERT INTO kpx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kateige Diudasiu moni ke malei dubue uvue hatui halei tiale au ebia mavitinu. ");
INSERT INTO kpx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ige dubu nalimale kosive keau moni ke iuhai loui avoe, “Moni kou tahoe moni. Iale moni koseale malei dubue uvue otovege kena nahie menaka egumai.” ");
INSERT INTO kpx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Isi moni ke hotohoto vaito moni ke malei vata mole ibina valu. Subuta ataeau vata kemo deba malei avuemo sosibani vaevema. Iale vata keike abu ibinave vai isiviale avuemo vata ke ata holioholiale keau haluvige abu malevei avuemo abavuevegei. ");
INSERT INTO kpx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Abu vaveve kateale vale kemoike novae ataeau vata ke ivihai avoe, “Tahoe Matama.” ");
INSERT INTO kpx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Vaveve kateale keu beloveta mole Dielimaiau louale hoto ke mai selevetinu. Dielimaiau subuta loui avoe, “Iselala ataeau ata ke ibina louale monie luhu teti (30) ke malei vata mole abu kemo deba malei sosibani vaevemale ke ibina valu. Kosiveu kateale loui di namihanu.” ");
INSERT INTO kpx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesuu Loma kosive ke vudimo laminu. Ige au belahai avoe, “Diue kosive anike ko.” Ige Iesuu namihai avoe, “Avuike a ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kateai lougeto dubu nalimale kosive isi oe kosive keau kosive ke vudimo kotalahai Iesu vaveve ke louge au hotoeabe ibina louholinu. ");
INSERT INTO kpx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ige Bailotiu namihai avoe, “Ana abu a aiohavoi ahoe hoto loumale ke evinu.” ");
INSERT INTO kpx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Isito Iesuu isiviholinu hotoeabe ibina louliho. Kateige Loma gamani kosiveu ke elehai vikoanu. ");
INSERT INTO kpx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vagana bahata Basova vani kemo ataeabuna Loma gamani kosive namihage kena dibulae ata mole iomage au tigei. ");
INSERT INTO kpx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iale vani kemo malaha mole ivite keu dibulae ua. Iviveike Balabasi. ");
INSERT INTO kpx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iale ata moagaeau igaetoai lohoge gamani kosiveu au subuta vale ke nahate vai kebia namigevei avoe, “La isiviale di ata olete iomage au tai. Dana Balabasi iomai. Emena dana la tedaevemale ata Iesu Keliso ke iomai.” ");
INSERT INTO kpx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kateai louale keu koseanu. Au hilokage keau mainave mai ilike vaime mai omilu. ");
INSERT INTO kpx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bailotiu kotamale keve ugulamoi usege mahinaveu avuho hoto mole hanavoi avoe, “Di nivu vavimo tababu mole vai Iesu elehai vabuanu. Di hilokage keu vavevebe toela vaholinu. Iale ainaho inutolotolote ata kemo vavevebe toela valive.” ");
INSERT INTO kpx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kateisege dubu nalimale kosive isi oe kosive keau negolahai ata moaga kebia hanavei avoe, “Bailoti namihage au Iesu hamaito Balabasi halei.” ");
INSERT INTO kpx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kateige Bailotiu tota belagevei avoe, “La isiviale di ata abui kobiamo olete iomage au tai.” Ige abu namihai avoe, “Balabasi iomanela.” ");
INSERT INTO kpx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ige Bailotiu namigevei avoe, “Isito dana la tedaevemale ata Iesu Keliso kemo onole vai.” Ige abu bahata Bailoti namihai avoe, “Mai idie domo hamanela.” ");
INSERT INTO kpx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kateai louge Bailotiu belagevei avoe, “Osialemo. Au onole toela vanu.” Ige abu baita tota loui avoe, “Mai idie domo hamanela.” ");
INSERT INTO kpx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Isi katelahasege Bailotiu ke elehai hilokage kotalive keu anekianu. Ige au huhuai avoe, “Koeabuna koselahalata mole havei.” Kateaime e hai atae vudimo au ada totoanu. Isiviale keau hilokage Iesuho huhuihuhuibe toelau avuemo uoholinu. Kateaito namigevei avoe, “Inutolotolote ata kou hatige tahoveu bae daemo ulivebene. Isito auna laemo ui.” ");
INSERT INTO kpx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ige ata bahata keau hotove ibina vai avoe, “Halege au hatige tahove kena noemo ui no esetamo ui.” ");
INSERT INTO kpx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Katelahai louge Bailotiu hotoeabe evisi Balabasi iomage au tinu. Isito Iesu mai tuvalie ata ovege abu visuhavoi mai hamaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kateai melavei gamanie o baluga ke uvue tiale tuvalie ata degomole hohavege abu loholu. ");
INSERT INTO kpx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lohoale keau ogove bahata tohoai ogo tahote vatae kosiveau hatumale ke mai avuemo hatulu. ");
INSERT INTO kpx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Isi kinaveho hote mole bekabekate mai viliai kinave hanubelu. Isi kosive bedoia ke nahate mai adave inuteve mavolu. Isi lobohavoi abu kosiveho vamale ke nahate vai vudivemo kome bokoai vata bisi loui avoe, “Diue kosive baluga, ana duave.” ");
INSERT INTO kpx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Katelahaito avuemo violahai bedoia ke mai kinavemo hamalu. ");
INSERT INTO kpx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Katelahai hehavolata tota avuemo ogo tahote ke elokohai ogove seleve mai avuemo holovalu. Isi melavei idie domo hamaliho tilu. ");
INSERT INTO kpx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tialeau humaha tavae Sailini malaha mole ivi Saimoni keluvuta belehovoi namihai avoe, “Ata ko tedahoi avuemo idive ebamonela.” ");
INSERT INTO kpx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Katelahaito tilialeau matama mole ivi Gologota keve velehovolu. Matama ke ihuu koseanu. Lolokue matama. ");
INSERT INTO kpx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iale abu keve velehovoi e mole toela mai uainita ebuehale ke mai omisi isiviale au ke ige vateve tumuu uoholisi. Isito Iesuu ke ige keu tumuige au ke ovonu. ");
INSERT INTO kpx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ke ovoge abu mai idie domo hamai ogove malei kasilahai ogove igaegae malelu. ");
INSERT INTO kpx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kasilahage uoholige abu uguiavoi ui Iesu nibima. ");
INSERT INTO kpx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kemo ulata sebele mole vaki mai avuemo abu ono vademoike hamale ke hisaliai avoe, “Malaha kou Diue atae kosive baluga, Iesu.” Kateaito mai kinave tatamo hamalu. ");
INSERT INTO kpx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Isi kateai vavoloe ata abui malevei idie domo havelu. Moleu Iesu ada inuteatave. Isege moleu adave agiteatave. ");
INSERT INTO kpx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Isege ataeau matama kela tai lohoi ke elehai hehavoi tuvikivikilahama. ");
INSERT INTO kpx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Isi Iesuho loui avoe, “A konike loui kosea, ‘Dana dubu baluga koiai tota vani abuita igaeta kemo houi gabiai.’ Iale a Dilava mo holiniege idie do kemo dobai loho.” ");
INSERT INTO kpx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ige dubu nalimale kosive, Diue menaka loui haivemale isi oe kosive keau bahata hoto kateale loui hehavoma. ");
INSERT INTO kpx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Isi moleho loui avoe, “Keu ata degomole tedaevei hoesegeveito au ebika tedahoholinu. Keu loui avoe, ‘Dau Diue atae kosive baluga.’ Iale auna dobai lohoge no bae no uvu mai avuemo mavoi. ");
INSERT INTO kpx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Keu au uvu mai Dilavamo mamoi loui avoe, ‘Dau Dilava mo.’ Keta duave. Iale nahi elehage Dilavau isiviai tedahoge auna dobai lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ige abu atae toela abuita malei Iesuluvuta hamale kebiata hotoe toela kateale loui namihalu. ");
INSERT INTO kpx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vanie lilimo vata bahatamo vau loai gidualeu tili okoloki masege vaniu tota halunu. ");
INSERT INTO kpx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Vanie ni ke masege Iesuu au hotomo baita kekoai loui avoe, “Ilai, Ilai lama sabakatani.” Ke ihuu koseanu. “Di Dilava, di Dilava osialemoike a di tedahoholisi di halenu.” ");
INSERT INTO kpx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ige ata degomoleau lavisi uale keau hoto ke evisi loui avoe, “Keu mesoho beloveta mole Ilaidia keike au hohavonu.” ");
INSERT INTO kpx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Katelahasege solekavesite ata moleu bibuai tiale e mole toela mai ono mole ogomu ke nahatemo ehosivai idi mai ke bisi isiviale ebagemage Iesuu e ke isi. ");
INSERT INTO kpx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ige ata degomoleau avuho loui avoe, “Usege nahi elehai. Mesoho Ilaidiana dobai lohoniege ke tedahoi.” ");
INSERT INTO kpx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Katelahasege Iesuu tota baita kekoaito hatinu. ");
INSERT INTO kpx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hatige Diue dubu balugamo abu ogo mole mai oe uvu tumute ke bamuale keu ehula dikolahai tiale heila velemai abuita holinu. Ige vatau kibikibiage muneau vigota vilahai vakolahalu. ");
INSERT INTO kpx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ige alue vuta keau daihovoge Dilava ata moaga subuta haluviale keau hovedevelu. ");
INSERT INTO kpx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hovedevei abu vuta ke halevelu. Iniale Iesuu hovelahage keau bae Dielusalemae tilu. Ige ata moagaeau kebia elegevelu. ");
INSERT INTO kpx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Isito tuvali kosive isi tuvali esemu keau Iesu nibisi ulage hamuhatuge vaveve degomole keau velehovoge abu ke elegevei tetelahai vabulahalu. Isi loui avoe, “Seleveta keu Dilava mo.” ");
INSERT INTO kpx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Isege keate moaga subuta Galili halevai Iesuluvuta olahai tedahomale keau haeavala lavisi vaveve ke bahata elehama. ");
INSERT INTO kpx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Keate kebia vigomo Meli Magidaleni isi Diemisime Diosebame neina Meli isime Sebedi mo abui kebia neina keau keve lavisi ui vaveve ke elehama. ");
INSERT INTO kpx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Alimatia malaha mole kunaite keu vaveve ke elehalage gutuanu. Malaha ke ivilike Dioseba. Keu Iesu esemu mole. ");
INSERT INTO kpx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iale keu tiale Iesu ava mai abavuliho Bailoti belahanu. Ige keu au esemu namigevege abu idie domo Iesu ava iavoi mai Dioseba omilu. ");
INSERT INTO kpx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ige Diosebau avave ke mai tiale ogoe doga mai vilianu. ");
INSERT INTO kpx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Isi mai tiale au ebikaho munemo guli lovoale kemo mamonu. Isi mune baluga evovoai mai lohoi ilive bamuito halei tinu. ");
INSERT INTO kpx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Isege Meli Magidaleni isi Meli mole keau vutave ke ulidamo uguiavoi ui ke elehama. ");
INSERT INTO kpx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Abu kateisege Basova lovi vale vaniu uoholinu. Iniale bulae vavita dubu nalimale kosivea isi Balisia ata keau igaetoai Bailoti oe loholu. ");
INSERT INTO kpx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Keve lohoale namihai avoe, “Kosive, no hilokage loboe ata keu subuta hatioholisito nita ui loui avoe, ‘Dana hatiniege vanie ni abuita igaeta uoholige dana tota hovelahai.’ ");
INSERT INTO kpx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iale a esemu namigevege abu talive novata isi nivuta vutave ke nibie dua vai. Katealemo Iesu esemu keau bae talive avave ke vavololahalivebene. Mesoho keabuna vavololahaliege abuna ata lobogevei loui kosea, ‘Iesuu hovelahanu.’ Abuna katelahai lobolahage loboeabe kena subuta Iesuu loboale ke evihai.” ");
INSERT INTO kpx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Katelahai namihage Bailotiu au tuvalie ata degomole malei ovei namigevei avoe, “Kobia malevei talive abuhi nenilahai Iesu vuta ke nibie dua vave.” ");
INSERT INTO kpx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ige abu tialeau Iesu vuta ke bamui gamanie silu mai mavoi louge tuvalie ata keau kemo nilahai uma. ");
INSERT INTO kpx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bulau uoholige Sande vavita vae hodohodota Meli Magidaleni isi Meli mole keau Iesu vuta elehaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Isi tialeau keve velehovosege solekavesite hamu balugatahou hatunu. Ige Kosive anelu moleu otogomo dobai lohoale mune ke evovoai mai mamoi ke golomo ugulamoi ua. ");
INSERT INTO kpx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ige vavave keu vau nivolekale ke nahate vai levolevoai ua. Ige ogove keu tae seleveai ua. ");
INSERT INTO kpx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ige keve nilahai umale tuvalie ata keau ke elehai tetelahai haluviale ke nahate vatamo dobuluvilu. ");
INSERT INTO kpx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vatamo dobuluvige anelu keu keate nehe abui kebia namigevei avoe, “Lainaho vabulahalive. Di hilokage abu Iesu mai idie domo hamale keike la kaovama. ");
INSERT INTO kpx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iale keu komo uoholinu. Au subuta louale ke nahate hovelahanu. Loholive au lahale lovo elehave.” ");
INSERT INTO kpx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ige abu tiale lovove elehage au namigevei avoe, “Solekai talive di laheho louale ko loui esemuve kebia namigevei kosea, ‘Iesuu hovelahai Galili vatae tinu. Iale talive bae keve elehave.’” ");
INSERT INTO kpx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kateige abu vabulahaito vahaehota solekai vutave ke halevai esemuiabe namigeveho tilu. ");
INSERT INTO kpx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Namigeveho tisege Iesuu solekavesite abuemo velemanu. Isi abuho loui avoe, “Lana duave.” Ige abu vudivemo kome bokoai vata bisi velovela holisi hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ige Iesuu namigevei avoe, “Vabu halevaito talive di haokuvu namigevege abu Galilie talive keve bae di elehai.” ");
INSERT INTO kpx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iesuu kateai louge keate keau tisege tuvalie ataeau Iesu vuta nibiale ke degomoleau Dielusalemae hoidevei tiale vaveve bahata abu elehale ke loui dubu nalimale kosive namigevelu. ");
INSERT INTO kpx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ige dubue kosive keau oe kosive kebia bevuevei abu onole vaveve ke hotohoto valu. Isi katelahai moni baluga malei tuvalie ata kebia ovelu. ");
INSERT INTO kpx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Isi namigevei avoe, “Lainaho vaveve ke loulive. Isito lobolahai loui kosea, ‘No vavimo ladevesege Iesu esemuiau lohoale Iesu vava mai tilu.’ ");
INSERT INTO kpx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Isi mesoho Loma gamani kosiveu ke evisi kemo hoto louge noeabuna la vale ke vovohoi. Iale lainaho onobe huhulahalive.” ");
INSERT INTO kpx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Katelahai namigevege tuvali esemu nehe keau moni ke malei abu abuho onole louale ke valu. Kateige hoto keu Diue vata bahata sonumai tinu. Iale novae vani komo Diue ataeau hoto ke louma. ");
INSERT INTO kpx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iesu esemu ada abui isi igae (11) keau Dielusalema halevai Iesuu Galili tana mole louale keve tilu. ");
INSERT INTO kpx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Keve tiliale elehai hoesehavoi guligulihavolu. Katelahaito degomoleau dolodololahalu. ");
INSERT INTO kpx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dolodololahage Iesuu abue lohoi namigevei avoe, “Dilavau otogota vatata vuvune ke bahata daonu. ");
INSERT INTO kpx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iale vata bahatae talive ata bahata haivege abu di ehovage di Mamae ivi, di ivi, isi Munanae Tumue ivi ketamo babatisogeveve. ");
INSERT INTO kpx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Isi di la namigeveale ke bahata loui kebia haivege abu evisi vai. Isi ko huhulahave. Dana vani bahata lahehi ulage vatana gabiai.” ");
INSERT INTO kpx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kou deiada duaike ko. Dilava mo Iesu Keliso ke deiada. Deiada ke umukau koseanu. ");
INSERT INTO kpx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Subuta beloveta mole Aisaia keu deiadae umuka ke hisaiai avoe, “Dilavau au mo namihai loui avoe, ‘Dana di esemu mole hanavoge auna aho uli holisi tiniege ata namigevei kosea, Kosiveu lohoma.’ ");
INSERT INTO kpx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Malaha kena botoe lamisi ata hohavei loui kosea, ‘Kosive humaha ke inuta loive. La uvu hoesegevei vaveve toela halevai vaveve dua vave.’” ");
INSERT INTO kpx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iniale gabie Dioni keu botoe tiale deiada ke loui ata haivei loui avoe, “La vaveve toela ke halevai hoidevei babatisolahave. Ige Dilavana bae la vaveve toela ke ulihage auna uoholisi.” ");
INSERT INTO kpx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kateai louge ata bahata Diudia vatae isi Dielusalema o keve umale keau Dioni hotoe deiada eviliho tilu. Kebiau hoto ke evisi abu vaveve toela louge Dioniu Diodani emo babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dioni keu ata nimole. Ogove keu ovo mole kamela ke vomo. Isege beletave keta ovo ke igae vate. Isege loviveike kainaku isi vidiae e. ");
INSERT INTO kpx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iale keu loui avoe, “Malaha molena di iae lohoniege di evihai ivi balugate holisi. Iale di baluga holioholialemo tamakave iamoveve keu daemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Di e unahamo la babatisogevema. Isito auna au Munanae Tumu hanavoi ke vuvunemo la hoesegevei.” ");
INSERT INTO kpx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Vani mole Iesuu Galili vatamo au o Nasaleta ke halei lohoi Dioniu uale keve tinu. Ige Dioniu Diodani emo Iesu babatisohavonu. ");
INSERT INTO kpx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ige Iesuu emo hovelahai elehage otogou dikolahage Dilava Munana Tumuteu ugu imutava ke nahate holisi dobai lohoale avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Isege hoto moleu otogomo loui avoe, “Au di uvue mo seleve. Di a vahaeho va baluganu.” ");
INSERT INTO kpx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hoto keu gabiasege Dilava Munanae Tumuu Iesu iomage au ataeau uvesiteve tinu. ");
INSERT INTO kpx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tiale vanie ni voti ke uvumo keve usege Vatae Kosiveu lohoale lobohavonu. Keve botoe ovo aihanite keau ua. Isito Dilava aneluiau loholiale tedaholu. ");
INSERT INTO kpx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vani mole abu Dioni mai dibulae mavosege Iesuu Galili vatae tiale Dilava deiadae dua loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Isi loui avoe, “Ataeau Dilava adae vuvunemo uveve vaniu vuguvuguanu. Ialelua la vaveve toela ke halevai hoidevei lohoi deiadae dua ko evive.” ");
INSERT INTO kpx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kateai louito Galili esagala oai tinu. Tiale keu abui hohote Saimoni isi Andulu elegevesege keau huenaho ugabi hatuma. ");
INSERT INTO kpx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ige Iesuu namigevei loui avoe, “Daluvuta lohoge di la haivege la huena maleale ke nahate ata moaga daho maleveve.” ");
INSERT INTO kpx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kateige abu solekavesite abu ugabi ke halevai avuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tiale tota abui hohotebia Diemisita Dionita elegevesege abu bouti uvumo abu ugabi adahima. Ata abuita keau Sebedi esea. ");
INSERT INTO kpx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ige au solekavesite kebia hohavege abu abu mamata esemuiabeta halevei Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Keau bahata lohoale o mole Kabenumu keve velehovolu. Iniale bulamo Iesuu lohoi Diue dubue tiale ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ige abu hotove ke evisime vikolahalu. Kosealemo Diue menaka loui haivemale kebia hotou vuvuneholinu. Isito Iesuu hoto ke louale keu vuvune baluganu. ");
INSERT INTO kpx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Iale Iesuu hoto ke loui ata haivesege dubu kemo tilogoe malaha moleu uale keu kekoai loui avoe, “Iesu, Nasaleta malaha, no halevei tenela. Ana no aiogevehonike kove lohonu. Di hilokage au Dilava Mo. A keu ata tumute.” ");
INSERT INTO kpx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kateige Iesuu namihai avoe, “Hoto halei malaha ke halei tenela.” ");
INSERT INTO kpx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kateai louge munanae toelau malaha ke aiohavoge keu teteteteai keko baluganu. Kateigeto munanae toelau ke halei tinu. ");
INSERT INTO kpx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ige ata bahataeau ke elehai viko balugai mole namigevei loui avoe, “Vadeulike ke. Moka vaveve dogaike. Malaha kou au vuvunemo munanae toela kebiaho louge keau hotove evisi vama.” ");
INSERT INTO kpx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kateige Iesu deiada keu solekavesite Galili vata bahata sonumanu. ");
INSERT INTO kpx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesuu kateaito dubu halei Diemisita Dionita holoevei abuhi tilu. Tialeau Saimonime Andulume oe velehovolu. ");
INSERT INTO kpx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Velehovosege abu Iesu namihai avoe, “Saimoni meau hobeage vavaveu vuvune balugage au avae golomo lahai uma.” ");
INSERT INTO kpx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ige Iesuu lohoale keate ke adala holisi ebagemage keate ke hobeu uoholige au hovelahai loviabe vanu. ");
INSERT INTO kpx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iniale gutumo vau dobai tisege abu vavahanitebia isi munanae toelaeau abuemo biloluvimale kebia bahata holoevei Iesue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","O ke ata bahataeau lohoale keau Iesu uale o ke udahamo mole bevuevei ua. ");
INSERT INTO kpx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ige Iesuu ata moagaeau vavahani nimolete vamale kebia hoesegevei munanae toelaeau ataemo biloluvimale kebia hoesegevege munanae toela keau halevai tilu. Munanae toela keau hilokage Iesu keu Dilava mo. Katealemo Iesu abuho loui isiviholialeike abu hotobe louliho. ");
INSERT INTO kpx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Vae alamo kokoluguu hotoisege Iesuu hovelahai o halei ataeau uvesite keve au Mama imihaho tinu. ");
INSERT INTO kpx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Iniale vau alamosege Saimoniu Iesu esemu degomolehi Iesu kaovaliho tilu. ");
INSERT INTO kpx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tiliale Iesu elehai namihai avoe, “Ata bahataeau a kaovama.” ");
INSERT INTO kpx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ige Iesuu namigevei avoe, “Nahi o ko halevai o degomoleve tai. Ige di tota keve ata degomole haivei. Kosealemo vaveve katealehoike di lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kateai louito halei Galili vatamo o igaegaela tiale Diue dubula ata haivei munanae toela nunuvema. ");
INSERT INTO kpx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kateimalela lebolasite malaha moleu avue lohoale kome bokoai vata bisi namihai avoe, “A isivianiege di hoesehavonela.” ");
INSERT INTO kpx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ige Iesuu avuho uvu balugai avuela holisi namihai avoe, “Ito, dana a hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kateai louge solekavesite malaha kemo lebolasiu uoholige vavaveu duaveanu. ");
INSERT INTO kpx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ige solekavesite Iesuu malaha ke iomai namihai avoe, “Evinela. Ainaho di a hoesehavoale ko atabeho loulive. Isito inuta talive a ebika mai dubu nalimale ke haivunela. Ige au a vava elehai a namihage Moseseu louale ke nahate ono mole mai mahoi Dilava hoesehavoge ataeabuna elehai hilokage a vavau duaveanu.” ");
INSERT INTO kpx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Isito malaha keu kateholisito tiale Iesu vaveve ke loui ata bahata namigevenu. Katealemoike Iesuu hoilahai oe lohoveve keu avuemo anekiage boto unahae uma. Isito ataeau o bahatamo umale keau sohu avue lohoma. ");
INSERT INTO kpx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Vani moagaeau uoholisege Iesuu tota Kabenumu oe lohonu. Ige au oe lohoale ke hoto ata bahataeau evisi avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Avue lohoge oveu gigiage ata benahateau heie lavisi ua. Ige Iesuu hotoe dua loui ata kebia bahata haivema. ");
INSERT INTO kpx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kebia haivesege ata abuita abuita keau malaha mole vavaveu kibioholiale ke mai isiviale Iesue lohoi. ");
INSERT INTO kpx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lohoale keau isiviale oe uvue tai. Isito ataeau moagage ke mai tiveve keu anekianu. Ige abu mai oe lagadae tiale Iesuu lamiale ke nenita o kobuhai vahavemo oe nehe au avae golomo uale ke mai manevege dobai lohoale Iesu veloe heimo ua. ");
INSERT INTO kpx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Katelahage Iesuu evieviabe ke elehai malaha nehe ke namihai avoe, “Di mo, di a toela bahata ulihage uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Kateai louge Diue menaka loui haivemale kebiata hoto ke evisi huhulahai avoe, “Osiohoike kou Dilava ivi mai aiohavotima. Atabeu bae toelabe ulihalivebene. Isito Dilava igaena vaveve toela ulihagei.” ");
INSERT INTO kpx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Huhuihuhui kateale huhulahasege Iesuu solekavesite huhuihuhuiabe ke hilokai namigevei avoe, “Osiohoike la huhuihuhuie toela kateale huhulahama. ");
INSERT INTO kpx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dana vavahanite namihai loui kosea, ‘Di a vaveve toela ulihanu.’ Emena dana namihai loui kosea, ‘Hovelahai a ava mai lamisi tenela.’ Dana hoto olete loui. La huhuige hoto olete louveveu toloanu. ");
INSERT INTO kpx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Isito halege dana vavahanite ke hoesehavoge lana ke elehai hilokage vaveve toela ulihaveve vuvune keta daemo ua.” ");
INSERT INTO kpx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kateai louito vavahanite ke namihai avoe, “Hovelahai a ava egumai mai a oe tenela.” ");
INSERT INTO kpx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ige ata keau elehasege malaha keu solekavesite hovelahai au ava egumai mai au oe tinu. Ige ata keau ke elehai viko balugai Dilava hoesehavoi loui avoe, “No subuta vaveve koseale elehaholilu.” ");
INSERT INTO kpx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesuu kateaito tota hoilahai Galili esagae tinu. Ige ata bahataeau laluvai avue tige au kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kebia haivege uoholige au lohoniale Aloveasi mo Livai elehanu. Malaha keu ataemo takesi malemale ata. Iale takesilahamale oe uvue ugulamoi usege Iesuu namihai loui avoe, “Di ehomai loho.” Ige au hovelahai ehomanu. ");
INSERT INTO kpx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iniale vani mole Iesuu Livai oe lovi iliho tinu. Ige takesi moni malemale ata kebiau atae toela degomolehi abu vaveve halevai Iesu ehovale keau tiliale Iesuta esemuiabeluvutahi igaetolahai lovi ima. ");
INSERT INTO kpx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Isege Diue menaka loui haivemale keau Iesu elehai tiale esemuiabe namigevei loui avoe, “Osiohoike keu atae toela kebiahi igaetoai lovi ima.” ");
INSERT INTO kpx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kateai louge Iesuu ke evisi abuho loui avoe, “Medikolou bae negote kebiaho loholivebene. Isito auna vavahanite kebia unaha hoesegeveliho lohoi. Ke nahate dau lohoale kou atae duaho di lohoholinu. Isito dau lohoale kou vaveve toela vamale kebia hohavehoike di lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vani mole ata babatisogevemale Dioni ke esemuiau Balisia esemuhi Dilava hoesehavoho lovi ioholilu. Isege ata degomoleau ke elehai lohoi Iesu namihai avoe, “Osialemoike keau lovi ioholisi uma. Isito a esemuiau kateholisito lovi ima.” ");
INSERT INTO kpx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ige Iesuu namigevei avoe, “Mo molena au keate melamege haokuvuiabe abuna lovi isi emena abuna halevai. Ba, abuna lovi isi vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Isito vani mole atae toelae abuna loholiege mo ke hamage haokuvuiabe abuna bae vani kela uvulahai lovi i halevai. ");
INSERT INTO kpx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Atabeu bae ogoe doga bohisi mai ogoe mami mai mamoi badivulivebene. Auna kateige ogoe doga kena ogoe mami ke butuhage auna dikolahai vahai. ");
INSERT INTO kpx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ige ke nahate atabeu bae uainie doga mai ovoe vate badivuale mamivemo ehosivalivebene. Auna kateige kena savai dikolahai. Ige uainie doga kena hosilahai lotihatui. Isito atabena uainie doga mai ovoe vatee dogamo ehosivage keu bae dikolahalivebene. Iale ke nahate di vaveveu bae vatae vaveve kebiahi igaetoalivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vani mole bulamo Iesuu au esemuhi konee bulula olahai tisege esemuiabeau kone dakoai ilu. ");
INSERT INTO kpx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dakoai ige Balisia malahaeau Iesu namihai avoe, “Eleha. Osiohoike keau menaka eguvai bulamo katelahalu.” ");
INSERT INTO kpx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ige Iesuu namigevei avoe, “Lana Bukae Hotomo Deividiu au esemuhi vaelahaime vale ke dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Subuta Abaiatau dubu nalimale kosive baluga holimale ke vanila Deividiu dubue uvue tiale beleidi tumute ke mai inu. Dubu nalimale unahaeabuna beleidi ke igei. Isito vani kela Deividiu menaka ke egumai beleidi ke isi au esemu ovege kebiata ilu.” ");
INSERT INTO kpx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesuu kateai louito tota namigevei avoe, “Dilavau bula vai isivialeike ataeau kemo lu malei ui. Dilavau bulaho ata vaholinu. Isito keu bula ataho vanu. ");
INSERT INTO kpx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Atae Ese keu bulae Kosive. Iale auna onole louge abuna ke vai.” ");
INSERT INTO kpx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesuu kateai louniale vani mole tota Diue dubue tiale malaha mole ada golote elehanu. ");
INSERT INTO kpx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ige Diue kosiveau Iesu nibitumutumuama. Ilive mesoho elehage au bulamo malaha ke hoesehavoge abu mai vaveveve kemo kotalahai. ");
INSERT INTO kpx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ige Iesuu malaha nehe ada toelate ke namihai avoe, “Hovelahai lohonela.” ");
INSERT INTO kpx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kateaito ata namigevei avoe, “Nahie menaka keu nahie haivege nahiabuna bulamo osioi. Nahiabuna bulamo vaveve dua vai. Emena vaveve toela vai. Nahiabuna vali ata hoesegevei. Emena aiogevei. Kateai louge abu hotove ibina louholilu.” ");
INSERT INTO kpx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kateige Iesuu kebia elegevei abuho itumuanu. Kosealemo keau menaka unaha ehovaito ata hoesegeveveve ke huhuoholilu. Isime malaha ke namihai avoe, “A ada hatunela.” Ige au hotove evisi au ada hatuge duaveanu. ");
INSERT INTO kpx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ige Balisia malahaeau ke elehaime dubu halevai solekai tiliale gamani kosive Elodi ke ata benahate namigevei isiviale abuhi Iesu hamaveve humaha kaovai. ");
INSERT INTO kpx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesuu au esemu benahatehi halevai Galili esagae tiliale keve velehovosege Galili ata moagaeau ehovai loholu. ");
INSERT INTO kpx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Isege ata degomoleau Iesu vaveve bahata evisi loholu. Keau Diudia vata isi Idumea vata halevai loholu. Isege degomoleau Diodani e vaki mole keve loholu. Isege degomoleau Dielusalema, Taea, isi Saidoni o baluga kebiamo loholu. ");
INSERT INTO kpx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ata moagamoaga keau keve lohoge Iesuu vavahanite moaga hoesegevenu. Katealemoike vavahanite bahataeau Iesu leveliho mole kabitigevema. Kateige Iesuu au esemu namigevei avoe, “Ataeau gigialelua daho vanagi mai emo mavoge di ke golomo lamisi ata haivei.” ");
INSERT INTO kpx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ata haivesege munanae toelaeau atae uvumo holoeavomale keau Iesu elehai dobuluvisi kekolahai loui avoe, “Au Dilava mo aike ke.” ");
INSERT INTO kpx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ige Iesuu namigevei avoe, “Hoto ke halevave. Di isiviholinu ataeau hoto ke eviliho.” ");
INSERT INTO kpx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu kateaniale uoholige lohoi tana molela veatisi tiale keu lamisi au ata hohavege abu avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lohoge au bae ata kebiamo au isivie esemu tuelo (12) tabagevege abu abostolove holilu. Ige au namigevei avoe, “Di la tabagevei isiviale daluvuta uge dana la hanavege di hoto loui ata haiveve. ");
INSERT INTO kpx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ige dana di vuvune malei laovege kemo munanae toela nunuvegeve.” ");
INSERT INTO kpx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ata nehebia au malevege esemuve holialeike kobia: Saimoni, ivive moleike Bita. Ige Sebedi mo abui Diemisi isi Dioni. Iesuu iviabe doga otovealeike ko, Boanele. Hoto ke ihulike hata. Kosealemo hotoeabe keu hata vutoale ke nahate. Ige Andulu. Ige Bilibi. Ige Batolomi. Ige Matiu. Ige Tomasi. Ige Diemisi mole, Aloveasi mo. Ige Tadeasi. Ige Keinanie ata mole Saimoni. Ige Iesuho haiaveve malaha mole Diudasi Kaliota. Ata katealebia Iesuu tabagevenu. ");
INSERT INTO kpx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iale keau halevai lovi iliho oe tilu. Isito ata moagaeau lohoge abu lovi iveve keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kateige ataeau loui avoe, “Iesu keu tilogoanu.” Ige deholuvuiabeau ke evisi loui avoe, “Mesoho seleve.” Isi kateaime isivilahale biaeau Iesu mai nalisi. ");
INSERT INTO kpx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kateisege Diue menaka loui haivemale degomoleau Dielusalemamo lohoale keau loui avoe, “Setene vuvuneu avuemo ua. Munanae toelae kosive Biesabolo keike au vuvune omige au vuvunevemo munanae toela kebia nunuvema.” ");
INSERT INTO kpx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kateai louge Iesuu hohavege abu avue lohoge au dovudovue hotomo namigevei avoe, “La loui kosea, ‘Keu Setene vuvunemoike au vaveve kateale vama.’ La louale keu seleve holige Setenena oleve kateai au ata nunuvei. Keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mesoho vata molemo ataeau mole tasalievei molehi mole haveliege abu bae ui egealivebene. ");
INSERT INTO kpx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ige mesoho valada igaeau mole tasalievei molehi mole haveliege keau bae ui egealivebene. ");
INSERT INTO kpx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iale ke nahate Setene ataeabuna hovedevei mole havei tiliege abu bae ui egealivebene. ");
INSERT INTO kpx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Atabeu bae ata mole negote ke oe uvue tai kunaive kebia vavoloalivebene. Isito auna vasohuta malaha ke umuvaito bae ove kemo kunaive malei. ");
INSERT INTO kpx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Seleveta di la namigevege evive. Dilavau atae vaveve toela bahata ulihaveve hiloka. Isi ataeau ivive loui mai aiohavoge auna vaveveabe toela ke ulihai. ");
INSERT INTO kpx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Isito olena loui kosea, ‘Setene vuvunemoike au loviama.’ Isi kateai Munanave Tumu ke ivi mai aiohavoge Dilavau bae vaveveve toela ke ulihalivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ata degomoleau loui avoe, “Iesu keu munanae toelae vuvunemoike au vaveve kateale vama.” Kateike vage Iesuu abuho hoto ke lounu. ");
INSERT INTO kpx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kateisege Iesu neinau hohuvuiabehi lohoale keau heie lavisi uito avuho hoto hanavoi isiviale elehai. ");
INSERT INTO kpx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ige ata moagaeau Iesu evilikahavoale keau namihai avoe, “A neinau a hohuvuhi lohoale heie ui a elehaho hoto hanavolu.” ");
INSERT INTO kpx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ige Iesuu namigevei avoe, “Di neinaike ole. Ige di hohuvuiabulike olemea.” ");
INSERT INTO kpx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kateaito uguiavoi lotiale kebia namigevei avoe, “Di neina isi di hohuvuiabulike la kebia. ");
INSERT INTO kpx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iale oleuoleu Dilava isivi vamale keau di hohuvuia, di amakinuvuia, di neinuvuia.” ");
INSERT INTO kpx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Vani mole Iesuu tota halei Galili esagae ata haiveho tinu. Keve tige ata moagaeau avuluvuta tiale mai evilikahavoge au vanagi mai e golomo meamoi avuemo ugulamosege ata keau milie usege au haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Isi dovudovue hoto moagamo kebia haivei avoe, ");
INSERT INTO kpx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Evive. Malaha moleu obie i malei au bulue sesiaho tinu. ");
INSERT INTO kpx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tiale ke sesiasege degomoleau humahamo keiolahage uguiau lohoale ke isi gabilahalu. ");
INSERT INTO kpx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Isege benahateau munemunemo vatau uoholiale kemo keiolahai neniai ulioholige alumuiabeau heie dobai tioholilu. ");
INSERT INTO kpx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Alumuiabeau vatamo tioholialemo vaniu velemai tumuai kebia havege tutukalu. ");
INSERT INTO kpx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Isege benahateau adu bekate ke uvue keiohovoge adu bekateau ulisi bamuevege hahuavoholilu. ");
INSERT INTO kpx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Isege degomoleau vatae duamo keiohovoale keau ulisi bailahalu. Ige benahateau bailahale moagataho. Isege benahateau bailahale moaga. Isege benahateau bailahale moaga vesitehame.” ");
INSERT INTO kpx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesuu deiada kateale louito namigevei avoe, “Oleuoleu hoto evimaleau hoto ko evive.” ");
INSERT INTO kpx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iniale gabie Iesuu au ehuvela usege esemuve tuelo (12) keau esemuve degomolehi avue lohoale belahai avoe, “Osialemoike a vani bahata dovudovue hotomo no haivema.” ");
INSERT INTO kpx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ige Iesuu namigevei avoe, “Di loumale kemo di isiviale Dilavau au matamae dogae vamale ke hilokave. Isito ata benahateau evieviholimale kebiaho di dovudovue hoto louge abu bae evisi lulelelahalivebene. ");
INSERT INTO kpx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kosealemo keau di vaveve niavoito neniai kemo luleleholilu. Isi vani bahata di hoto evisito ke hilokaholilu. Isito mesoho keau neniai luleleai hilokavatege Dilavau vaveveabe toela ulihanu.” ");
INSERT INTO kpx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesuu tota au esemu namigevei avoe, “Lana dovudovue hoto ke humaha hilokaholiliege bae oleve kateai dovudovue hoto degomole hilokai. ");
INSERT INTO kpx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iale di dovudovue hoto ke ekovehage evive. Sesiamale ata keu Dilava hotoike au ke loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I benahateau humahamo keiolahale keau ata degomole nahate. Ata keabuna hotoe dua ke evisege Setenena lohoniege uvuiabemo hotoe dua ke aiohavogei. ");
INSERT INTO kpx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Isege i benahateau munemunemo keiolahale keau ata degomoleau Dilava hoto evisi solekai vahaehomo male ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Abu hoto ke evisi maito hoto keu uvuiabemo holomaholige abu negoholilu. Iniege gabie abu hotoe dua eviale kemo ataeabuna abuemo vaveve toela vai aiogevege abuna vatehani malei solekavesite hoidevei. ");
INSERT INTO kpx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Isege i benahateau adu bekate uvue keiolahale keau ata degomole nahate. Ata keau hotoe dua ke evisito vani mole abu vatae vaveve huhulahai kunaita huhulahage vaveve katealeu hotoe dua bamuge evieviabeu negoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Isege i benahateau vatae duamo keiohovoale keau ata degomoleau hotoe dua evisi ehovai vamale ke nahate. Ige hotoe dua kemo degomolebia evieviu balugataho. Isege degomoleau baluga. Isege degomoleau baluga vesitehame.” ");
INSERT INTO kpx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesuu tota abuho loui avoe, “Nahiabuna vali lameba mahoi mai maua uvumo mavoi mesoho mai ladevemale betie valae mavoi. Ba, nahiabuna lameba hanei mai ehanumage ataeabuna atagavemo ui. ");
INSERT INTO kpx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Di hoto louale ke ihuu koseanu. Ataeabuna abu vaveve vai mahogovage Dilavana bae vaveveabe ke mai umidamo mamoge ataeabuna ke elehai hilokai. Isi vani kela atae vaveve bahatana Dilava atagamo bae velehovoi umidamo ui. ");
INSERT INTO kpx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Iale la oleuoleu hoto evimaleau hoto ko evive.” ");
INSERT INTO kpx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kateaito tota namigevei avoe, “Di laheho louale ke evisi vave. Lana ke evisi ehovaliege di hotomo lulele balugave. ");
INSERT INTO kpx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Olena di hotomo luleleage Dilavana lulele baluga omisi. Isito ata olena au lulele unahamo hoto ke evisito keho isiviholige Dilavana avuemo luleleve ke mai evihai.” ");
INSERT INTO kpx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesuu tota loui avoe, “Ataeau Dilava adae vuvunemo uveve kena koseai. Ata moleu bulue tiale konee i hatuale ke nahate. ");
INSERT INTO kpx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Keu hatuito tisege vavimo kone keau vakiai ulilu. Malaha keu koneu oleve kateai vakiale ke vaveve hilokaholinu. ");
INSERT INTO kpx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","29","Isito vatae onobenobe duamoike kone keau vakiai ulilu. Keau ulisi humulahai bailahage nigiabe keau gililahage malaha kena au siga mai tai kone kebia dakoevei.” ");
INSERT INTO kpx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesuu tota belagevei avoe, “Ataeau Dilava adae vuvunemo uveve kemo dana dovudovue hoto vade louge lana kemo lulelelahave. ");
INSERT INTO kpx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Di louge evive. Ataeau Dilava adae vuvunemo uveve keu masitae i ke nahate. Masita keu ie esehame seleve. ");
INSERT INTO kpx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Isito ataeabuna ke sesiage auna ulisi balugage uguiabuna loholiege idi ke adamo hasolahai. Iale ataeau Dilava adae vuvunemo ui moagatahoai ue dua vaveve keu kateanu.” ");
INSERT INTO kpx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu dovudovue hoto kateale loui haivege abu kemo lulelelahage au tota degomole loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Auna dovudovue hoto unahamo ata kebia haivegei. Isito auna au esemuhi abuhuvela uniege dovudovue hotoe ihu bahata loui haivegei. ");
INSERT INTO kpx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kateimale gutumo Iesuu au esemuho loui avoe, “Lohoge nahi tabu ko houi vaki moleve tai.” ");
INSERT INTO kpx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kateige esemuiabeau ata ioveito bouti nehe Iesuu avuemo lamisi ata haivemale ke mai bouti degomole halevei tilu. ");
INSERT INTO kpx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tilialeau vaki mole velehovoholisege humaha tavae hanunu balugau utuige eu boutiabe uvumo lavuge boutiabeu uhutege mutuanu. ");
INSERT INTO kpx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kateige esemuiabeau ke elehai tiliale Iesuu subuta bilamo lahale ke etuvai loui avoe, “No haivemale ata, hovelahanela. Ana no e vahamo timale konike elehaholisime lahama.” ");
INSERT INTO kpx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ige Iesuu hovelahai hanunuta eta hotogevei loui avoe, “Halevai tobekave.” Kateige keau hotove evige hanunu keu uoholige eu tota tolemanu. ");
INSERT INTO kpx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ige Iesuu au esemu namigevei avoe, “Osiohoike la vabulahalu. Lana la uvu mai daemo mavoholilu.” ");
INSERT INTO kpx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Isito esemuiabe keau vabulahalelua hotove ibina vaholisito moleho loui avoe, “Malaha oletealeike ko. Kou hanunuta eta hotogevege abu hotove evisi isivive valu.” ");
INSERT INTO kpx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kateaito loholiale keau Galili tabu houi vaki mole Gelasene vata keve loholu. ");
INSERT INTO kpx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ige Iesuu boutimo dobai tisege tilogoe malaha moleu alue vutae umale keu avue lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Munanae toelau avuemo uale kemo ataeau evudei seimita umuvai isiviale mai omo kouai. Isito kena vani moaga seimi ke bukiai hatui lohoi alue vutae tigei. Kateige ataeau evudei umuvaveve keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vani bahata auna alue vutae tai tanae oai kekoigei. Isime mune malei au vate ke heisi tahotigei. ");
INSERT INTO kpx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Iale keu haeavamole Iesu elehai bibuai lohoale keu vudivemo kome bokoai vata binu. ");
INSERT INTO kpx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Vata bige Iesuu tilogote kemo munanae toela ke namihai avoe, “Malaha ke halei tenela.” Kateai louge tilogote malaha keu loui avoe, “Iesu, otogoe umale Kosive ke mo, osiohoike a dae lohonu. Dilava ivimo di a imihama. Ainaho di aiohavolive.” ");
INSERT INTO kpx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ige Iesuu belahai avoe, “A ivilike ole.” Ige au loui avoe, “Di ivilike Moaga. Kosealemo noeau moaga.” ");
INSERT INTO kpx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Isi kateai negoai Iesu namihai avoe, “Ainaho no nunuvege no haeavamole talive.” ");
INSERT INTO kpx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Kateaito elehasege ovo degomoleau tanae lovi isi olahama. Ige munanae toela keau malaha kemo ualeau Iesu namihai avoe, “No hanavege no tai ovo kebia uvue deluhovoi.” ");
INSERT INTO kpx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kateige Iesuu munanae toela kebia nunuvege kebiau tiale ovo kebiamo deluhovolu. Ige ovo bahata tu taoseni (2,000) keau detuluvisi tialeau seika vuvegevei tabu balugamo biloluvisi e isi haluvilu. ");
INSERT INTO kpx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ige ovo nibievemale keau detuluvisi tialeau humaha tavae ata namigevei tialeau oe ata bahata namigevelu. Ige ata bahata kebiau lohoi tiale isiviai vaveve ke elehai. ");
INSERT INTO kpx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Keau lohoaleau munanae toelaeau malaha nehemo holoeavoale ke elehage keu ogoe dua vai tilogoholisito momoleai tobekai ugulamoi ua. Ige ata kebiau malaha ke elehai vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ige ovoe biaeau malaha nehe ke deiadata ovo kebia deiadata loui ata bahata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ige ata keau Iesu namihai isiviale au vataeabe ke halei tai. ");
INSERT INTO kpx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kateige Iesuu halei boutimo biloho vasege malaha nehe keu Iesu namihai isiviale avuti tai. ");
INSERT INTO kpx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kateige Iesuu keluai avuho loui avoe, “Talive Dilavau aho uvuai a hoesehavoale ke loui a oe ata bahata namigevenela.” ");
INSERT INTO kpx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ige malaha keu halei tiale Dekabolisi matama keve Iesuu avuemo vale ke loui ata bahata namigevenu. Ige keau ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesuu boutimo tiale keu tabu ke vaki mole dobasege ata moagaeau avue lohoale evilikahavolu. ");
INSERT INTO kpx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ige Diue dubu nalimale kosive mole Diailosi keu lohoale Iesu elehai vudivemo kome bokoai vata binu. ");
INSERT INTO kpx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Isi namihai avoe, “Di mau vavahaniale hatima. Iale loholive a ada mai golovemo mamoge au hovelahai mauliai.” ");
INSERT INTO kpx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ige Iesuu malaha nehe keti mave elehaliho tige ata moagaeau ehovei abuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tisege keate moleu vavahanie toela male keu lohoale Iesu ogola holinu. Vavahanive keu koseanu. Vagana tuelo (12) ke uvumo tahoe toelau uvuvemo lohoma. ");
INSERT INTO kpx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Medikolo moagaeau ke elehai mulamula omisito keau keate ke hoesehavoholilu. Keu kebiamo moni baluga hatugeto vavahanive keu sohu avuemo ui balugai tima. ");
INSERT INTO kpx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iale keate keu Iesu vaveve ke evisi ata moaga kebia uvumo lohoale Iesu iae ogovela holinu. ");
INSERT INTO kpx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ogovela holisi huhuai avoe, “Dana Iesu ogo unahala holiniege momoleai.” ");
INSERT INTO kpx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kateai Iesu ogola holige solekavesite tahoe toelau avuemo uoholinu. Ige keate ke biageu au uvumo huhuige vavahaniveu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ige solekavesite Iesu biageu hilokage ata hoesegevemale vuvune keu ata molemo tinu. Ige au hoilahai niai loui avoe, “Oleike di ogola holinu.” ");
INSERT INTO kpx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ige esemuiabeau namihai avoe, “Ana ata moagaeau aluvuta lohoale konike a elehaholisi loui kosea, ‘Oleu di ogola holinu.’” ");
INSERT INTO kpx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Isito Iesuu negoai elegevei lotinu. Isiviale hilokai oleike ogovela holinu. ");
INSERT INTO kpx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ige keate keu avuemo ono vadeu vale ke huhuai vabuai teteai avue lohoale vudivemo au kome bokoai vata bisi au deiada bahata loui Iesu namihanu. ");
INSERT INTO kpx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ige Iesuu avuho loui avoe, “Di ma, a a uvu bahata mai daemo mamoike vage vavahani keu aemo uoholinu. Iale vahaehomo tenela.” ");
INSERT INTO kpx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesuu keate keti kateisege ata degomoleau Diailosi oe uale keau lohoale Diailosi namihai avoe, “A mau aike hatiale ainaho kosive keho louge au loholive.” ");
INSERT INTO kpx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kateai louge Iesuu hotoeabe ke evisito Diailosi namihai avoe, “Ainaho vabualive. Isito a uvu mai daemo mamonela.” ");
INSERT INTO kpx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kateaito ata namigevei avoe, “La bahataeau usegeto Bita Diemisi isime hohove Dioni kebia unahaeau daluvuta lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kateai kebia unahahi tiale keau malaha nehe ke oe velehovoi evisege ata moagaeau o kemo ninalahai kekolahama. ");
INSERT INTO kpx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ige Iesuu o ke vahae deluai tai namigevei avoe, “Osiohoike la ninalahai kekolahama. Ma keu hatioholinu. Isito lahaike au ke vanu.” ");
INSERT INTO kpx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ige abu ke evisi bituhavoi hehavolu. Ige Iesuu kebia bahata nunuvege abu heie tisege ma ke mamata neinaveta holoevei au esemuta holoevei ma keu lahai umale keve tilu. ");
INSERT INTO kpx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Keve tiale ma ke adala holisi hotovemo namihai loui avoe, “Talita kumi.” Ke ihuu koseanu. Mabia, hovelahanela. ");
INSERT INTO kpx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ige ma keu solekavesite hovelahai lamisi oanu. Ige au hatisi hovelahale ke abu elehai vikobe nimole valu. Ma ke vaganau tuelo (12). ");
INSERT INTO kpx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ige Iesuu isuta namigevei avoe, “Lainaho deiada ko loui ata namigevelive.” Kateaito tota namigevei avoe, “Lovi mai omige au isi.” ");
INSERT INTO kpx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesuu kateaito o ke halei au o seleve keve tinu. Ige esemuiabe keau avuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iniale bulamo au Diue dubumo ata moaga haivema. Ige ata keau hotove kemo viko balugai moleho loui avoe, “Oleveike ata kou hoto ko louale lulele ko mai vikoe vaveve vuvune keta manu.” ");
INSERT INTO kpx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kateai moleho loui avoe, “Ata keu Meli moike. Keu o houmale ata unaha. Diemisi, Diosasi, Diudasi isime Saimoni hohuvuiabe abulike kebia. Iale amakinuvuiabe degomole abulike nahie vigomo ua.” Kateai loui Iesu kabebihavolu. ");
INSERT INTO kpx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ige Iesuu namigevei avoe, “Beloveta ata kena vata moleve tige ataeabuna hotove evisi hoesehavoi. Isito au au o seleve keve tige atave keau bae hotove evisi hoesehavolivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kateai loui vikoe vaveve moaga o kemo vaholisito vavahanite degomole kebiamo au ada malei tataeabemo otovege keau momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Isito oeabe ata keau abu uvu mai avuemo mavoholige au kebia elegevei vaveveabe kemo vikoanu. Kateai au o ke halei tiale o degomole kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Vani mole au au esemu tuelo (12) hohavege abu avue lohoge au munanae toela nunuveveve vuvune ovei abuibuiai hanavenu. ");
INSERT INTO kpx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hanavei abuho loui avoe, “Lainaho busebuse, lovi, moni kateale malelive. Isito la tiliege la tedaevemale bedoia ke unaha matageveve. ");
INSERT INTO kpx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Isi la veloe voto isi ogo hatuale ke unahata teve. Isito lainaho beta malei tigelive. ");
INSERT INTO kpx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","La tiliege o oletemo ata oleu la malevei o hatuevege ke omo ulata o ke halevai teve. ");
INSERT INTO kpx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Isi la tiliege o molemo velehovoge ata keau la hoto evioholisi la malevei o hatueveholige anakaeabemo la veloe gogea ke sesieveve. Ige abuna ke elehai hilokage Dilavana bae kebia aiogevei. Dilavau subuta Sodomata Gomolata aiogeveale ke nahate Dilavana bae gabie vatehani baluga kebia ovei.” ");
INSERT INTO kpx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kateai loui kebia hanavege abu ata haiveho tilu. Haiveho tiale ata haivei loui avoe, “La vaveve toela halevai hoideveve.” ");
INSERT INTO kpx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kateaito munanae toela moaga ataemo nunuvei olive oele malei vavahanite kebia kinamo ehosivage keau momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gamanie kosive baluga Elodiu Iesu vaveve ke evinu. Kosealemo ataeau Iesu vaveve loui ata haivege Elodi keta ke evinu. Ata degomoleau loui avoe, “Mesoho ata babatisogevemale Dioni keu hatialeu tota hovelahaike vaime vaveve nimolete kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ige degomoleau loui avoe, “Ilaidialike.” Ige degomoleau loui avoe, “Subuta umale beloveta moleike.” ");
INSERT INTO kpx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kateige Elodiu loui avoe, “Ba, mesoho di Dioni nehe eno heisi etulege hatisi hovelahaleike ke.” ");
INSERT INTO kpx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Elodiu hoto kateale louale keu koseanu. Dioniu Elodi namihai loui avoe, “A a hoho Bilibi ke mahina Elodiasi vavolota melameale keu toelanu.” Isi kateai loulage vani mole Elodiu louge abu mai dibulae mavolu. ");
INSERT INTO kpx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dioniu kateai louge Elodiasi keu avuho itumuai isiviale hamage au hatisi. Isito Elodiu hamaliho isiviholiale kemo hamaveve humahau uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Elodiu Dioni vabuhavoi hilokage keu malahae dua. Isime vavevebe toela vaholinu. Keu Dioni hoto keho isiviaito keate ke haleveve hoto ke evisi isiviholinu. ");
INSERT INTO kpx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iale vani mole Elodi uale vani keu lohoge au louge gamani kosive degomole, tuvalie kosive degomole, isi Galili vatae umale kosive degomole keau bahata Elodi oe lovi iliho loholu. Kemoike keate nehe keu bae Dioni hamaveve humaha ke davalianu. ");
INSERT INTO kpx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iniale lovi imale keve Elodiasi mau havuai Elodita kosive nehe kebiata malevei vahaehotievege Elodiu ke elehai ma ke namihai avoe, “A isivi louge dana a isivi ke vai.” ");
INSERT INTO kpx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kateai Dilava ivimo menakai loui avoe, “Di vata di kunai keau baluga. Iale a onoleho isiviai di namihage dana a isivi ke vai.” ");
INSERT INTO kpx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kateige ma keu lohoi tiale au neina namihai avoe, “Amia, dana ono vade igaeho kosive ke imihage au daoi.” Ige neinaveu loui avoe, “Namihage au ata babatisogevemale Dioni ke kina heisi etulei mai aoi.” ");
INSERT INTO kpx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kateige ma keu solekai tota lohoi kosive ke namihai avoe, “Di isiviale aike ata babatisogevemale Dioni ke eno heisi etulei kinave mai melegimo mamoi mai daonela.” ");
INSERT INTO kpx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ige kosive keu uvu balugai isiviholinu katealiho. Isito au lovi iho lohoale kebia nimo au ono vade ma keho valiho Dilava ivimo menakale kemo ke haleveve keu avuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Katealemo kosive keu au tuvalie malaha mole hanavoi loui avoe, “Talive ata babatisogevemale Dioni ke eno heisi etulei kinave mai lohonela.” Kateige au halei dibulae tiale enove heisi etulei kinave mai melegimo mamoi mai lohoale ma ke omige au mai au neina ominu. ");
INSERT INTO kpx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ige Dioni esemuiau hoto ke evisi lohoaleau vavave mai tiale abavulu. ");
INSERT INTO kpx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vani mole Iesuu au abostolo nehe abuibuiai hanaveale keau tota hoidevei lohoale Iesuluvuta beleavoi abu ono vade vamale ke loui Iesu namihama. ");
INSERT INTO kpx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kateisege ata moagaeau Iesue tai lohoma. Kateige Iesuu au esemuhi lovi iveve keu anekianu. Ige au au esemu namigevei avoe, “Lohoge nahi nahi unaha tai ataeau uvesiteve sibeleai.” ");
INSERT INTO kpx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Isi kateai abu boutimo biloluvisi ataeau uvesite matama keve sibeleaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sibeleaho tige ata moaga keau ke elehai matama ke halevai solekai bibuluvisi heila tialeau Iesuu au esemuhi tiale matama keve velehovolu. ");
INSERT INTO kpx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ige Iesuu boutimo dobai ata kebia elegevei abuho uvu baluganu. Kosealemo ata kebiau mamoe nahate. Ige nalievemale atau uoholinu. Kateige au hoto nimolete moaga loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Haivelage vau gutuige esemuiabeau lohoale avuho loui avoe, “Loviu uvesiteike ko. Vau loalelua ata kobia hanavege abu abu oe tai abu iveve kaovai.” ");
INSERT INTO kpx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ige Iesu namigevei avoe, “La biaeau lovi ovege abu isi.” Ige abu namihai avoe, “Noeabuna oleve kateai moni baluga malei ata moaga kobiaho lovi voievei.” ");
INSERT INTO kpx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ige Iesuu belagevei avoe, “Bato tai elehave. Lana lovibe malei lohoholilu.” Ige abu tiale lovi kaovai tota lohoale Iesu namihai avoe, “Valava ada mole isi huena abuita unahahame.” ");
INSERT INTO kpx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Kateige Iesuu namigevei avoe, “Ata kebia namigevege abu mole tasalievei igaegaeai boboe golomo ugulelevai.” Kateai louge abu tiale ata kebiaho louge abu igaegaeai ugulelevai lotilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ige Iesuu valavata huenata malei otogoe niai au Mama imihaito valavata huenata vakoanata malei au esemu ovege abu igaegaeai ata kebia ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ige ata bahata keau lovi ke ige uniabeau hanilahalu. ");
INSERT INTO kpx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ige esemuiabeau valavata huenata sigu malei basiketi tuelomo (12) udage ililoholu. ");
INSERT INTO kpx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ata keau lovi ke iale keau bahata vai taoseni (5,000). ");
INSERT INTO kpx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesuu lovi ovege uoholige au esemu namigevei avoe, “Boutimo biloluvisi e houi vaki mole Betesaida keve tisege di ata kobia hanavege abu tisegeto di bae lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kateai louito lohoi ata kebia hanavege abu tisege au tanae au Mama imihaho tinu. ");
INSERT INTO kpx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iniale vavimo Iesu esemuiau boutimo tiale keau e vigola tisege Iesu eu kove tanae ua. ");
INSERT INTO kpx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tana keve lamisi au esemu elegevesege hebulu balugau utuige keau solekai tioholilu. Iniale vae alamo Iesuu lohoi e golola lamisi abue tiale isiviai boutiabe ke evihai tai. ");
INSERT INTO kpx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ige esemuiabeau Iesuu e golola lamisi lohoale ke elehai kekolahai loui avoe, “Aluu lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Isi kateai vabulahage Iesuu namigevei avoe, “Vabu halevave. Iesu dailike. Lainaho vabulahagelive.” ");
INSERT INTO kpx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kateai louito boutimo biloisege hebulu keu tolemanu. Ige esemuiabe keau ke elehai vikolahalu. Kosealemo Iesuu valava ada mole kemo vuvune vaveve vale ke elehaito kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Katelahaito e ke houi vaki moleve lohoale Genesaletie velehovoi abu bouti mai esagae mavolu. ");
INSERT INTO kpx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Isi boutimo dobuluvisege solekavesite ata keau Iesu elehai valitilu. ");
INSERT INTO kpx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Isi kateai bibuluvisi tiale o bahatae velehovoi Iesuu lohoale ke deiada loui ata bahata namigevege abu vavahanite malei avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ige Iesuu oleve keve tige abu vavahanitebia malevei avue lohoi isiviale abu ogove ivi unahala holisi momoleai. Kateige olemeau ogove ivila holiale keau momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Vani mole Balisia ata isi Diue menaka loui haivemale keau Dielusalemamo lohoale Iesu mai evilikahavolu. ");
INSERT INTO kpx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Isi Iesu esemu elegevege keau Diue menaka ehovaholisi abu ada totoholisito lovi ilu. ");
INSERT INTO kpx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Diue vaveve keu koseanu. Abuna vasohuta abu buluve vaveve ke vai abu ada totoaito bae gabie lovi igei. Isi abuna maketie tiliege lovi voilahai loholiege abu ada totoaito bae lovi ke igei. Isi abu buluve vaveve degomole koseale vagei. Abuna melegi, kabusi, sosibani kebia vavivuiabeau subuta totoimale ke nahate totolahaito bae abuemo lovi igei. Vaveve katealeu Balisia ataemo negoai tima. ");
INSERT INTO kpx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Katealemo Balisia ata isi Diue menaka loui haivemale keau Iesu belahai avoe, “Osialemoike a esemu kebiau nahie buluve kebia menaka ehovaholisi abu ada totoholisito lovi ilu.” ");
INSERT INTO kpx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ige Iesuu namigevei avoe, “Beloveta mole Aisaiau subuta Dilavau la loboe vaveve louale koike au namihage hisalianu. Au loui avoe, ‘Ata kobiau abu ai unahamo di hoesehavoma. Isito uvuiabe keu vatae vaveve unaha huhuevema. ");
INSERT INTO kpx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Keau di hoesehavomale ke ihuu uoholinu. Kosealemo keau atae menaka loui ata haivei loui kosea, Menaka kou Dilava menakaike. Isito abu haivemale keu Dilava menaka holioholinu.’” ");
INSERT INTO kpx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Isi Iesuu tota namigevei avoe, “La katealemo Dilava menaka ke halevaito atae menaka ehovema. ");
INSERT INTO kpx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Selevetanike la Dilava menakae tumu kabebihavoi la buluve menaka kebiamo negolahama. ");
INSERT INTO kpx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseseu Dilava menaka loui ata haivei avoe, ‘La mamuvu la neinuvu kebia hoto evisi hoesegeveve.’ Isi tota haivei avoe, ‘Oleuoleu abu mamuvu neinuvu kebia aiogevei hotoe toela abuho louale kebia abuna havege haluvisi.’ ");
INSERT INTO kpx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Isito la loboe vaveve koseale loui ata haivei kosea, ‘La mamuvu la neinuvu kebia la onobenobe oveho isiviholiliege kebiaho loui kosea, Di ke mai Dilava omialemo di bae ke mai laovelivebene.’ ");
INSERT INTO kpx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","La vaveve kateale vamalemo Dilava menaka kabebihavoi la menakate ehovei ata haivema. Isi vaveve degomole kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesuu kateaito ata bahata hohavei abuho loui avoe, “La bahata di hoto ko evisi avuemo lulelelahave. ");
INSERT INTO kpx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ataeau lovi onole imale keu abuemo toela holioholinu. Isito abu vaveve toela onole huhulahai vamale keu abuemo toelanu. ");
INSERT INTO kpx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Katealemo la oleuoleu hoto evimaleau hoto ke evive.” ");
INSERT INTO kpx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu kateaito ata kebia halevei oe tige esemuiabeau belahai avoe, “A louale ke ihuike ono vade.” ");
INSERT INTO kpx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ige au namigevei avoe, “Lana lata di louale kemo luleleholilu. Nahi onole imale keu Dilava nimo toela holioholinu. ");
INSERT INTO kpx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kosealemo nahi lovi imale keu bae nahie uvue talivebene. Isito auna nahie gogoe taito uoholisi.” Hoto kateale loualemo nahi hilokage lovi bahata keau duave. ");
INSERT INTO kpx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesuu tota loui avoe, “Atae uvumo abu vaveve toela onole huhulahai vamale keike Dilava nimo toelanu. ");
INSERT INTO kpx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Vaveve toela kosealeike atae uvumo lohoge abu vama. Abuna vaveve toela huhulahaliege teibae vaveve vai mole vavogevei mole havei mole keatehi ladevei mole kunaiho isivi balugai mole lobogevei mole maina mai isi kokoluguai Dilava ivi aiohavoi vaveve toela degomole vagei. ");
INSERT INTO kpx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vaveve toela katealebiaike atae uvumo lohoge abu vage Dilava nimo toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesuu kateai louito vata ke halei o mole baluga Taeae tinu. Tiale o molemo deluai isiviholiale ataeau au lohoale ke hilokaliho. Isito ataeau au lohoale ke hilokai avue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Isi kateisege ma molemo munanae toelau holomale ke neinau Iesuu lohoale ke hoto evisi lohoaleu vudivemo kome bokoai vata binu. ");
INSERT INTO kpx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Keate keu Diue ata holioholinu. Keu Sulovenisia vatamo lohonu. Iale keu lohoaleu Iesu namihai avoe, “Ana valive di maemo munanae toela nunuvai.” ");
INSERT INTO kpx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ige Iesuu namihai avoe, “A Diue ata holialebene di bae a tedahoi. Isito di a tedahoge di Diue ata tedaeveho lohoale kebiabuna osioi. Iale dana vasohuta kebia tedaevei.” ");
INSERT INTO kpx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ige keate keu namihai avoe, “Kosive, a hoto keu seleve. Isito ana vali di isivihame igae komo di tedahoito bae a ata seleve kebia vani bahata tedaevegei.” ");
INSERT INTO kpx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ige Iesuu keate ke namihai avoe, “A hoto kateale loualemo oe talive a ma elehanela. Munanae toelau a ma halenu.” ");
INSERT INTO kpx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kateige keate keu tiale au ma elehage munanae toelau halege momoleai tobekai lahai ua. ");
INSERT INTO kpx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesuu kateaito o ke halei o mole Saidoni kela velemai tialeu Galili vata kela velemai tialeu Dekabolisie velemanu. ");
INSERT INTO kpx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Keve velemasege o ke biaeau malaha moleu uvute holisi golemate holiale ke melavei lohoale Iesue velehovoi isiviale Iesuu au ada mai avuemo mamoge au momoleai. ");
INSERT INTO kpx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ige Iesuu malaha ke melamei ata kebia halevei tiale abu lilikateve au adae viso malei malaha ke golemamo otoveito au adamo vioai vio ke mai malaha ke neme levenu. ");
INSERT INTO kpx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kateaito otogoe niai au uvumo anuai loui avoe, “Alavonela.” ");
INSERT INTO kpx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ige solekavesite malaha ke golemau dua vage nemeveta isuoholige au hotoai hoto evinu. ");
INSERT INTO kpx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ige Iesuu tota malaha keti hoidevei lohoale ata kebia bahata namigevei loui avoe, “Lainaho vaveve ko loui ata namigevegei.” Isito ataeau hotove ke evioholisi ata namigevege abu evilu. ");
INSERT INTO kpx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kateige Iesu deiada ke evialeau vaveveve kemo vikolahai loui avoe, “Malaha keu vaveve bahata vamale keu duave unaha. Keu golemate isi uvute kebia hoesegevege abu hoto evisi hotolahama.” ");
INSERT INTO kpx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Vani mole Iesuu ata moaga haivelage abu lovi iveve keu uoholinu. Ige Iesuu au esemu namigevei avoe, “Ata kobiau daluvuta vanie ni abuita igaetamo ui lovibe ioholige di abuho uvuanu. ");
INSERT INTO kpx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dana lovi oveholisito hanavege abu tiliege degomole abuna vaeho humaha tavae nibedai. Kosealemo degomoleau o haeavamolemo loholu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kateige esemuiabeau namihai avoe, “Loviu uvesiteveike nahi uale ko. Iale noeabuna oleve lovi malei ata moaga kobia ovei.” ");
INSERT INTO kpx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ige Iesuu namigevei avoe, “Lana lovibe malei lohoholilu.” Ige abu namihai avoe, “Ba, no valava seveni (7) malei loholu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kateige au ata kebia namigevege abu vatamo ugulelevai lotilu. Isito valava seveni (7) malei hoesehavoito vakoai au esemu ovege abu malei ata kebia ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Isi huena degomolehame kebiata malei hoesehavoi vakoai au esemu ovege abu tota malei ata kebia ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ige ata bahata voa taoseni (4,000) keau lovi ke ige uniabeu hanianu. ");
INSERT INTO kpx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ige esemuiabeau lovie sigu ke malei basiketi sevenimo (7) udage tobaloholu. Kateigeto Iesuu ata kebia hanaveito au esemuhi bouti mai Dalamanuta vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Abu tiale keve velehovoge Balisia ataeau Iesue lohoale lobohavoi avoe, “Ana valive vikoe vaveve vage no ke elehai hilokage a keu Dilavaemo lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ige Iesuu kabebiabe vai abuho loui avoe, “Novae ata la koeau osiohoike vikoe vaveveho di belahama. Seleveta di la namigevege evive. Di bae vikoe vavevebe laheho valivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kateai louito halevei bouti mai e ke vaki moleve tinu. ");
INSERT INTO kpx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","16","Tiale au esemuho loui avoe, “Lainaho Balisia isi Elodi ata kebia valava ilive. Isito kebiamo la ebika nenigeveve.” Kateige esemuiabeau moleho loui avoe, “Mesoho nahi valava malei lohoholilike vage au nahiho hoto ke lounu.” Kosealemoike abu hoto ke loulu. Abu abu iveve valava moaga malei lohoholisito valava igaehame mai loholu. ");
INSERT INTO kpx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iale abu abu moleteho loumale ke Iesuu hilokai abuho loui avoe, “La osiohoike valava malei lohoholiale kemo hoto louma. La uvuu tololahalemo lana di louale kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Lana di valava ada mole vakoai ata vai taoseni (5,000) ovege uniabeu haniale ke huhuoholilu. ");
INSERT INTO kpx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","La huhuige di ke valemo lovie sigu vaesuteau basiketimo ililoholu.” Ige abu avuho loui avoe, “Basiketi bahata tuelo (12).” ");
INSERT INTO kpx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ige au tota emo loui avoe, “Di valava seveni (7) vakoai ata voa taoseni (4,000) ovege uniabeu haniale ke la huhuige lovie sigu vaesuteau basiketimo ililoholu.” Ige abu avuho loui avoe, “Basiketi bahata seveni (7).” ");
INSERT INTO kpx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ige au namigevei avoe, “Lana lovi iveve kenike huhuai moleho louma. Dau lovi ke huhuai louholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Abu lohoale Betesaidae velehovoge ata degomoleau malaha mole ni kedute melavei Iesue loholu. Lohoaleau Iesu belahai isiviale au malaha ke ni levege au duaveai. ");
INSERT INTO kpx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kateige Iesuu malaha ke adala holisi melamei o iae tiale au adamo vioaito malaha ke ni levei belahai avoe, “Ana elehanu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ige malaha keu niai loui avoe, “Ito, di niai ata elegevenu. Isito ata keau oai tioholige di kebia elegevei huhuai kosea, Mesoho idiabulike.” ");
INSERT INTO kpx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Malaha keu neniai nioholige Iesuu tota nive levege niveu duave seleveage au neniai ata elegevei lotinu. ");
INSERT INTO kpx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesuu kateaito hanavoi loui avoe, “Ainaho oe tiniege vaveve ko loui ata namigevelive.” ");
INSERT INTO kpx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesuu kateaito au esemuhi halevai Sesalia Bilibai o ke vavae o degomoleve tilu. Tialeau humaha tavae Iesuu au esemu belagevei avoe, “Ataeau huhuige dau ole.” ");
INSERT INTO kpx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ige abu namihai avoe, “Ata degomoleau a mai loui avoe, ‘Ata babatisogevemale Dioni keike ke.’ Isege degomoleau a mai loui avoe, ‘Ilaidiaike ke.’ Isege degomoleau a mai loui avoe, ‘Beloveta moleike ke.’” ");
INSERT INTO kpx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ige Iesuu tota au esemu belagevei avoe, “Isege laeau huhuige dau ole.” Ige Bitau loui avoe, “A keu Keliso. Dilavau a hanavoale ke alike.” ");
INSERT INTO kpx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ige Iesuu namigevei avoe, “Lainaho ke loui ata namigevelive.” ");
INSERT INTO kpx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Isi humaha tava ke igaeve au esemu haivei loui avoe, “Atae Esena bae vatetumu baluga malei. Oe kosivea, dubu nalimale kosivea, isime Diue menaka loui haivemale keabuna bae kabebihavoi hamage auna hatisito vanie ni abuita igaetaeau uoholisege auna tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Au abuho au hativeve deiada ke loui daiage Bitau melamei abu lilikateve tai avuho loui avoe, “Hoto kateale lou hale.” ");
INSERT INTO kpx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ige Iesuu au esemu degomole niavei Bitaho loui avoe, “Setene, di haliohatunela. A huhuale keu Dilavaemo lohoholisito ataemo lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kateai louito au esemuta ata moaga kebiata hohavege abu abue lohoge au namigevei avoe, “Oleu daiti tiho vaniege au lako au isivi va halei au vatehani maleveve ke huhu haleito di ehomai. ");
INSERT INTO kpx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iale olena au ebika unaha huhuaniege au bae ukolikoli malivebene. Isito olena au ebika huhuoholisito di ivita di hototamo vatehani malei hatiniege auna ukolikoli mai. ");
INSERT INTO kpx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Olena vatae onobenobemo kunaite holisito Dilavamo au uvu mamoholisito hatiniege auna oleve kateai ukolikoli mai. ");
INSERT INTO kpx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Au bae kunai keta au ukolikoli maleveve ke ibina valivebene. ");
INSERT INTO kpx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ataeau novae vani komo Dilava halevai vatae isivi vamale kemo oleuoleu di mati vai di hoto louliho isiviholige dana bae di lohomale kela di Mamae ataga anelu tumute atagamo lohoniege data kebia matigevei.” ");
INSERT INTO kpx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesuu tota namigevei avoe, “Seleveta, di la namigevema. La degomoleau kove uale keau bae haluvilivebene. Isito ataeau Dilava adae vuvunemo uveve ke vuvune elehaito bae haluvisi.” ");
INSERT INTO kpx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kateai louniale vanie ni sigisiu (6) uoholisege au Bita, Diemisi, isi Dioni holoevei abuhi tana mole balugae tilu. Tiale keve velehovoi elehasege Iesu vavae elehilehiu nimoleanu. ");
INSERT INTO kpx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nimoleage ogove keau taebe ni mole vai ua. Atabeu ogo totoige taeve keu ke nahate va holioholinu. ");
INSERT INTO kpx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Isi kateisege esemuiabe keau elehasege Ilaidiau Moseseti Iesuluvuta hotohotoima. ");
INSERT INTO kpx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ige Bitau Iesuho loui avoe, “Kosive, hoeseike no vai kove loholu. Iale noeabuna la nenita oe ese abuita igaeta houevei. Ilive elike moleu aho. Moleu Moseseho. Isege moleu Ilaidiaho.” ");
INSERT INTO kpx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Keau vabulahalemoike Bitau hoto ke huhuoholisito lounu. ");
INSERT INTO kpx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kateisege goeu lohoi kebia bamuevesege hoto moleu goe ke uvumo loui avoe, “Di uvue moike ke. Iale hotove evive.” ");
INSERT INTO kpx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hoto keu uoholisege abu nilahai elehage ata abuita keau uoholisege Iesu igaeu lamisi ua. ");
INSERT INTO kpx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kateaito hevaluvisi lohosege Iesuu au esemu namigevei avoe, “Lainaho la ono vade elehale ke loui ata haivegelive. Ilage Atae Eseu hatisi tota hovelahageto bae loui ata haiveve.” ");
INSERT INTO kpx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kateige esemuiabeau hotove evisito abu moletehi Iesuu hatisi hovelahaveve ke ihu hilokaholisi molemo kaovama. ");
INSERT INTO kpx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Isi tota Iesu belahai avoe, “Osiohoike Diue menaka loui haivemale keau loui avoe, ‘Ilaidiana vasohuta lohosegeto Atae Esena bae gabie lohoi.’” ");
INSERT INTO kpx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ige Iesuu abuho loui avoe, “Seleveta Ilaidiana vasohuta lohoi humahave loisi ata bahata namigevege abuna abu vaveve bahata hoesegevei. Isito di la namigevege evive. Ilaidiau subuta lohoge ataeau Bukae Hotou louale ke nahate vai abu isivi avuemo vai aiohavolu.” ");
INSERT INTO kpx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kateai hevaluvisi lohoaleau abu esemu degomolebiamo velehovoi elehasege ata moagaeau igaetolahaime uma. Ata keau umale keve Diue menaka loui haivemale keau Iesu esemu degomolehi moleho louma. ");
INSERT INTO kpx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Isege ata degomoleau keve ualeau Iesuu lohoale ke elehai vahaehove vai avue bibuluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ige Iesuu lohoale au esemu belagevei avoe, “La hoto onoleike abuhi molemo louma.” ");
INSERT INTO kpx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kateisege malaha moleu ata kebiahi uale keu Iesu namihai avoe, “No haivemale ata, munanae toelau di moemo holomage uvute holialeike di mai ae lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Munanae toela kena vani degomole aiohavoge auna vatamo dobage aivemo sabana lohoge auna au aie luhumo hedimai kibioholisi ugei. Di vasohuta mai a esemue lohonu. Isito keau munanae toela ke nunuvaholilu.” ");
INSERT INTO kpx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kateige Iesuu au esemu namigevei avoe, “Evieviholimale ataea, la huhuige dana vali vani moaga lahehi ui laheho loviai. La katealemo mo ke mai dae lohove.” ");
INSERT INTO kpx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kateige keau mo ke mai lohoge munanae toelau Iesu elehai mo ke aiohavo seleveai mai vatamo mamoge tobilakage aivemo sabau lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ige Iesuu mamave belahai avoe, “A mo kou vaesuvelaike au vaveve koseale vanu.” Ige mamaveu loui avoe, “Eseesemoike au ke vai lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vani moaga munanae toela keu isiviale au hatisi. Kateaime mai venemo mihatui emo mihatuma. Ialelua a huhuige ana vali noheho uvuai no tedaevei.” ");
INSERT INTO kpx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kateige Iesuu avuho loui avoe, “Osiohoike a daho loui kosea, ‘A huhuige ana vali no tedaevei.’ Ana a uvu mai daemo mamoi onoleho di imihage dana ke vai.” ");
INSERT INTO kpx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kateige mamaveu loui avoe, “Evievi daemo uale keu baluga holioholinu. Iale di evievi ke mai balugatinela.” ");
INSERT INTO kpx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kateisege ata moaga keau Iesu mai evilikahavoi isiviale elehai. Ige Iesuu munanae toela keho loui avoe, “A mo ke mai aiohavoge au hotoholisi evioholimalemo di a namihalelua mo kemo soai ti seleveanela.” ");
INSERT INTO kpx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kateai louge munanae toela keu mo ke haleho kekoai mai vatamo mamoge ataeau elehai loui avoe, “Mo keu hatinu.” Kateaito halei soai tinu. ");
INSERT INTO kpx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ige Iesuu mo ke adala holisi ebagemage hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iniale Iesu igaeu oe uvue usege esemuiabeau belahai avoe, “Osiohoike no mo kemo munanae toela ke nunuvaveve keu noemo anekianu.” ");
INSERT INTO kpx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ige Iesuu namigevei avoe, “Onobeu bae munanae toela kateale nunuvelivebene. Isito lovi ioholisito guliguli unahamo lana munanae toela kateale nunuvei.” ");
INSERT INTO kpx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Abu tota matama ke halevai Galili vatae lohoge Iesuu isiviholiale ataeau au lohoale ke hilokaho. ");
INSERT INTO kpx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kosealemo au isiviale au hativeve ke deiada loui au esemu haivei. Kateai namigevei avoe, “Ataeabuna Atae Ese mai ata degomole ovege abuna hamage auna hatiniege vanie ni abuita igaetaeau uoholisege auna tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kateige abu Iesu hoto ke evisi avuemo luleleholisi isiviale belahai. Isito vabulahalemo belahaholilu. ");
INSERT INTO kpx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Katelahai loholiale Kabenumue velehovolu. Keve velehovoi oe uvue tige Iesuu au esemu belagevei avoe, “Hoto vadeike la nova humaha tavae loui lohoma.” ");
INSERT INTO kpx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kateige keau humaha tavae oleu abuemo kosive baluga holiveve ke loui lohoalemo vabuhavoi hotove ibina louholilu. ");
INSERT INTO kpx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ige Iesuu ugulamoi au esemu bahata namigevei avoe, “Oleu isiviai kosive baluga holiho vaniege au ebika etolemai au haokuvu huhueveito bae gabie au ebika huhuai.” ");
INSERT INTO kpx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Kateai louito eseese mole mai vudiabemo mamoito mai evudei abuho loui avoe, “Olena di ivimo eseese ko nahate mai o hatui hoesehavoniege daike au ke hoesehavonu. Isi olena di mai o hatui hoesehavoniege di hanavoale ketaike au ke mai hoesehavonu.” ");
INSERT INTO kpx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ige esemuve mole Dioniu namihai avoe, “No haivemale ata, no malaha mole elehasege keu a ivimo ataemo munanae toela munuvema. Nunuvege no isiviale keluige au halei. Kosealemo keu nohehi a ehomaholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ige Iesuu au esemu bahata namigevei avoe, “Ata oleu di ivimo vikoe vaveve vage lainaho keluagei. Kosealemo ata keu di ivimoike au ke valemo au bae di ivi aiohavolivebene. ");
INSERT INTO kpx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ata oleu kateale vale keu nahie aiogeveholisito nahie tedaeveike au ke vama. ");
INSERT INTO kpx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Seleveta di la namigevema. La di esemu holiale kemo oleuoleu la tedaevei e hai laoveale kena bae au ibina mai.” ");
INSERT INTO kpx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ata olena isiviai evievi ese molehame aiohavoge au vaveve toela vage abege ataeau mune baluga mai enoveta etunavui mai davalamo mihatuge duave. ");
INSERT INTO kpx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Iale ke nahate la adau vaveve toela vage ke heisi etuleve. La ada igae keta otogoe tiale keta duave. Isito la ada keu vaveve toela vai la malevei veneu hodovavesite keve otoveale keu toelanu. Veneu hodovavesite keu hatihatie matama. ");
INSERT INTO kpx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Isi la velou vaveve toela vage ke heisi etuleve. La velo igae keta otogoe tiale keta duave. Isito la velo keu vaveve toela vai la malevei veneu hodovavesite keve otoveale keu toelanu. Veneu hodovavesite keu hatihatie matama. ");
INSERT INTO kpx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Isi la niu vaveve toela elehai vage ke ekosihai mihatuve. La ni igae keta Dilava matamae dogae tiale keta duave. Isito la ni keu vaveve toela vai la malevei veneu hodovavesite keve otoveale keu toelanu. Veneu hodovavesite keu hatihatie matama. ");
INSERT INTO kpx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","“Madea keu duave. Isito auna toelai heholiniege auna oleve kateai bae tota heai. Iale madea keu vene nahate. Dilavana bae veneta atae vaveve kaovai hilokage oleme vaveveau duaveasege oleme vaveveau toelalu. Katealemo madea vaveve ke nahate vai mole hoesegeveve.” ");
INSERT INTO kpx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesuu kateaito ata kebia halevei Diudia vatae velemai Diodani e ke houi vaki moleve tinu. Keve tige tota ata moagaeau avue lohoge au au vamale ke nahate vai haivenu. ");
INSERT INTO kpx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ige Balisia ataeau lohoale Iesu lobohavoho belahai avoe, “A huhuige malaha moleu au mahina halege kena menaka egumanu. Emena.” ");
INSERT INTO kpx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ige Iesuu belagevei avoe, “Mosese menakau vaveve katealemo ono vade lounu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ige abu namihai avoe, “Mosese menakau loui avoe, ‘Malaha oleu au mahina haleho vaniege vasohuta au mahina haleveve beiba hisaliaito bae keate ke halei.’” ");
INSERT INTO kpx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ige Iesuu tota namigevei avoe, “Dilava menaka ehovaveve kemo la uvuu toloike vage Moseseu mahina haleveve humaha ke alavonu. ");
INSERT INTO kpx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Isito vasohuta Dilavau vata vai otogo vale vani kela Dilavau malaha vai keateta vanu. Katealemo mo molena mahinaniege au mamata au neinata halevei au mahinati igaetoai ui. ");
INSERT INTO kpx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Katealemo abu bae avui molemo igaegaealivebene. Isito abuna molehi igaetolahai. ");
INSERT INTO kpx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dilavaike mahinuvuale kebia malevei igaetoige abu mole holoevei igaetoalu. Katealemo atabe lako kebia tasalievelive.” ");
INSERT INTO kpx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kateai louniale halei oe uvue tige esemuiabeau avue tiale au hoto louale kemo luleleholisi belahalu. ");
INSERT INTO kpx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ige Iesuu namigevei avoe, “Malaha oleu au mahina halei keate mole melameniege au keate ke vavamo vavoloike au ke vanu. ");
INSERT INTO kpx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ige ke nahate mesoho keate moleu au kolia halei malaha mole melameniege au kolia ke vavamo vavoloike au ke vanu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vani mole ata degomoleau abu ese malei Iesue lohoi isiviale au levevei hoesegevei. Isito Iesu esemuiau kebia iovei avoe, “Halevai teve.” ");
INSERT INTO kpx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ige Iesuu ke elehai itumuai au esemuho loui avoe, “Lainaho eseese keluevelive. Isege abu dae lohoi. Kosealemo eseese kebia uvunahate vamale keabuna Dilava adae vuvunemo ui. ");
INSERT INTO kpx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Seleveta di la namigevema. Oleuoleu eseese kobia uvunahate vaholiliege abu bae Dilava adae vuvunemo ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kateai louito eseese kebia malevei au vudimo otovei au ada malei tataeabemo otovei hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesuu kateaito halevei tiho vasege malaha moleu bibuai lohoaleu vudivemo kome bokoai vata bisi belahai avoe, “No haivemale atae dua, dana ono vade igae vai ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ige Iesuu namihai avoe, “Osiohoike a dahoe loui kosea, ‘Atae dua.’ Atabeu duave holioholinu. Isito Dilava igaeu duave. ");
INSERT INTO kpx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A menaka koseale hilokaevenu. ‘Ainaho ata havegelive. Ainaho mole keatehi ladevegelive. Ainaho mole vavogevelive. Ainaho mole lobogevelive. Ainaho molemo loboe vaveve vagelive. Isi a mamata a neinatae hoto evisi hoesegevenela.’” ");
INSERT INTO kpx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ige malaha keu loui avoe, “No haivemale ata, di esebuluta menaka kebia bahata ehovei lohoma.” ");
INSERT INTO kpx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kateai louge Iesuu avuho isiviai niavai loui avoe, “A a louale ke bahata vanu. Isito a vaveve ko igae vaholiale talive vai a kunai ke bahata malei voiai ibinave malei kunaiholimale kebia oveito lohoi di ehomanela. Ilive elike otogoe ibinae dua manela.” ");
INSERT INTO kpx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ige malaha keu au kunai moaga ke malei ata oveveve ke evisi uvu baluganu. ");
INSERT INTO kpx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kateige Iesuu au esemu niavei lotai abuho loui avoe, “Kunaite keau otogoe tiveve keu tolo seleveanu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ige esemuiabeau vikolahage au tota namigevei avoe, “Di esemuia, olemeau kunai huhu balugamale keau otogoe tiveve keu tolo seleveanu. ");
INSERT INTO kpx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ovo kamela keu nilae vahamo tiveve keu anekianu. Iale ke nahate kunaite keu otogoe tiveve keu anekianu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ige esemuiabeau hotove ke evisi viko balugai moleho loui avoe, “Kunaite keabuna otogoe tioholige oleme igae abuna otogoe tai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kateai louge Iesuu niavei abuho loui avoe, “Kunaite keau otogoe tiveve keu ataemo anekianu. Isito keu Dilavaemo anekiholinu. Nahi hilokage vaveve bahata keau Dilavaemo toloholilu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kateige Bitau avuho loui avoe, “Di louge evi. Noeau no onobenobe bahata halevai a ehovalu.” ");
INSERT INTO kpx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ige Iesuu abuho loui avoe, “Seleveta di la namigevema. Oleuoleu di ivimo di hoto louliho abu o, abu mohoho mahoho, abu mamuvu neinuvu, abu ese, abu vata halevaliege abuna novae vani komo abu di ivimo halevale kebia bahata malevei tota tatavemo degomoleta malevei. Isi vatehani keta malei. Iliege vanie gabila abuna ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Isito di louge evive. Novae vani komo ata olemeau atae nimo ivite holiale keabuna bae vanie gabila Dilava nimo ivioholisi. Isege novae vani komo ata olemeau atae nimo ivite holioholiale keabuna bae vanie gabila Dilava nimo ivite holisi.” ");
INSERT INTO kpx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesuu kateai louito au esemuho uli holisi Dielusalema humahala tisege esemuiabeau ke elehage uvuiabeu kibikibianu. Ige ata degomoleau kebia ehovei lohoale kebiata vabulahalu. Ige Iesuu ke hilokai au esemu tuelo (12) holoevei lilikateve tialeu ono vadeu gabie avuemo lohoveve ke loui haivema. ");
INSERT INTO kpx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Isi kateai haivei avoe, “Nahi Dielusalemae timale kove ataeabuna bae Atae Ese mai dubu nalimale kosivea isi Diue menaka loui haivemale kebia ovege abuna hamaveve hoto loui mai Diue ata holioholiale kebia ovege abuna hehavoi avuemo violahai visuhavoi hamage auna hatisi. Iniege vanie ni abuita igaetaeau uoholisege auna hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iesuu ke louge uoholige Sebedi mo abuita Diemisi isi Dioni keau Iesu namihai avoe, “No haivemale ata, no isiviale no isivie hoto loui a namihai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ige Iesuu namigevei avoe, “Dana laheho la isivi vade vai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ige abu namihai avoe, “No isiviale atagae matama keve no moleu a ada inuteve ugulamosege moleu a ada agiteve ugulamoi.” ");
INSERT INTO kpx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ige Iesu abuho loui avoe, “La belahale ke la hilokaholilu. Lana valive di vatehani maleveve ke lata malei. Isi di hativeve ke nahate lata vai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ige abu namihai avoe, “Ito, noeabuna nota ke malei.” Ige au namigevei avoe, “Seleveta lana bae di vatehani malei hatiale ke nahate lata maleve. ");
INSERT INTO kpx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Isito di la tabagevege la di ada inuteve isi agiteve uguiavoveve ke vuvuneu daemo uoholinu. Isito Dilavau oleme tabageveale keabuna bae keve uguiavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kateai louge esemuiabe teni (10) keau abui hohoteau louale ke evisi abuho itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Abuho itumulahage Iesuu au esemu bahata hohavei abuho loui avoe, “La hilokage gamanie kosiveau abu ebika tabagevei isiviale ataeau valaeabemo ui isiviabe vagei. ");
INSERT INTO kpx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Isito di isiviholinu la vaveve kateale valiho. La moleu isiviai kosive baluga holiho vaniege au ebika etolemai la mole esemu holisi isivive vai. ");
INSERT INTO kpx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Isi la moleu isiviai ivite holiho vaniege la bahatae valamo ui la isivi vai. ");
INSERT INTO kpx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kosealemo Atae Eseu vatae lohoaleu isiviholinu vatae kosive holige ataeau ivive ebagevaliho. Isito lohoale keu isiviale ata bahatae toelae ibinaho hatai malevege abu ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Katelahai lohoale keau Dielikoe velehovosege ata moagaeau elegevei abuhi tilu. Tisege Timeasi mo Batimeasi niveu keduale keu humaha vavae ugulamoi moniho ata imigevema. ");
INSERT INTO kpx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Keve ugulamoaleu evige Iesuu humaha kela lohoma. Ige au hoai loui avoe, “Deividi mo Iesu, dahoe uvuai di tedahonela.” ");
INSERT INTO kpx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ige ataeau aiohavoi avuho loui avoe, “Tobekai unela.” Ige au tota baita hoai loui avoe, “Deividi mo, dahoe uvuai di tedahonela.” ");
INSERT INTO kpx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ige Iesuu ata namigevei avoe, “Hohavoge au dae lohoi.” Ige abu ni kedute ke hohavoi avuho loui avoe, “Auna nova a hoesehavovevelua momoleai lohonela.” ");
INSERT INTO kpx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kateai louge malaha keu au dabae ogo iamoi mamoi solekavesite Iesue lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ige Iesuu namihai avoe, “A isiviale di ono vade ahoe vai.” Ige au loui avoe, “Kosive, di isiviale di ni hoesehavoge di tota niai.” ");
INSERT INTO kpx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ige Iesuu namihai avoe, “A uvu mai daemo mamoalemo a nina duaveage niai tenela.” Kateige solekavesite malaha ke niu duaveage au niai Iesu ehomai tinu. ");
INSERT INTO kpx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Iesuu au esemuhi lohoale tana mole Oliveta keve velehovosege Dielusalemau vuguvuguanu. Tana ke vavae o abuita Betabedi isi Beteni keau ua. Iale o keve Iesuu au esemu abuita hanavei loui avoe, “La tiliege o keve velehovoliege o ke ivie doniki mole doga ataeau avuemo uguiavoholiale ke lulehai mai lohove. ");
INSERT INTO kpx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ige mesoho ata moleu la belagevei kosea, ‘La osiohoike ke lulehama.’ Ige namihai kosea, ‘Kosiveu avuho isivianu. Iale auna tota hanavoge auna bae lohoi.’” ");
INSERT INTO kpx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Kateai louge abu tiale o ke ologomo abu avuemo hote beisi mai hadee tavata umuvale ke elehalu. Elehai ke vavehasege oe ata degomoleau lavisi uale keau ke elehai belagevei avoe, “La osiohoike doniki ke vavehama.” ");
INSERT INTO kpx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kateige abu Iesuu louale hoto ke loui namigevelu. Ige oe ata keau hotobe loui kelueveholilu. ");
INSERT INTO kpx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ige keau doniki ke mai lohoaleau Iesue velehovoi abu dabae ogo malei doniki ke golomo tedige Iesuu biloai golovemo ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ige ata degomoleau abu dabae ogo malei humahala tedisege degomoleau idie ada numute bokoai malei humahala tedisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kateisege ata degomoleau Iesuho uli holisi gabi holiale keau baita holahai loui avoe, “Seloo, kou Dilava ivimo lohoale ko nahi hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Subuta nahie mama baluga Deividiu kosive holisi nahie ata nibieveale ke nahate ata kona kosive holisi nahie nibievei. Iale nahi ivive ebagevai Dilava hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Katelahai lousege Iesuu Dielusalema oe velemaito tiale keu Diue dubu baluga ke uvue onobenobe niaveito gutualelua au esemuhi Betenie tilu. ");
INSERT INTO kpx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ladeveliale vavita Iesuu au esemuhi o ke halevai tota Dielusalemae lohoge Iesuu vaeanu. ");
INSERT INTO kpx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Vaeai haeavamolela idi mole vigiu humuale ke elehai tiale isiviai elehage au baiage au ke bai bukiai isi. Ke huhuai lohoale elehage keu baioholisito numu unahanu. Kosealemo ke baie vaniu lohoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ige Iesuu idi keho loui avoe, “Atabeu bae tota a bai ilivebene.” Kateige esemuiabeau hotove ke evilu. ");
INSERT INTO kpx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","16","Katelahaito Dielusalemae velehovosege Iesuu halei dubu balugae tiale dubumo maketilahai voivoilahamalebia nunuvenu. Isi moni senisilahamale kebia teibolo ekovehage moniabeu keiolahanu. Isi ugu voiamale kebia batabata ekovehai kebia bahata nunuvenu. Isi ataeau onobenobe malei dubue tai lohomale ke bamunu. ");
INSERT INTO kpx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Isi ata haivei avoe, “Dilavau Bukae Hotomo loui avoe, ‘Di isiviale ata bahataeau di o komo guliguliai di hoesehavogei.’ Isito laeau kateholisito vavoloe vaveve avuemo vama.” ");
INSERT INTO kpx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ige dubu nalimale kosivea isi Diue menaka loui haivemale keau ke evisi Iesu hamaveve humaha kaovama. Kosealemo ataeau vuvuneve hoto ke evisi vikolahale kemoike abu vabulahai isiviai hamai. ");
INSERT INTO kpx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kateaniale gutuige Iesuu au esemuhi o baluga ke halevai tilu. ");
INSERT INTO kpx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ladeveliale vavita hovedevei Dielusalemae loholiale humaha tavae idi nehe vigi ke elehage keu bahata giliai gabianu. ");
INSERT INTO kpx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ige Bitau Iesuu louale ke huhuai namihai avoe, “Kosive, eleha. A idi neheho louale keu giliai gabianu.” ");
INSERT INTO kpx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ige Iesuu abuho loui avoe, “Di louale ko evive. La evievina Dilavaemo uge lana tana moleho loui kosea, ‘Toholahai davalamo tenela.’ Isi la louale kemo dolodoloholisito la uvu bahata mai avuemo mavoge la louale kena seleve holisi. ");
INSERT INTO kpx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Katealemo di la namigevema. La ono vade loui Dilava imihaliege la uvu bahata mai avuemo mavoge auna la louale ke laovei. ");
INSERT INTO kpx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","La imihaho valiege vasohuta ata moleu laemo vaveve toela vale ke momahavoito Dilava imihaliege otogoe umale la Mama kena la vaveve toela ke ulihai. ");
INSERT INTO kpx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Isito mesoho ata moleu laemo vaveve toela vale ke la momahavoholige Dilavau bae a toela ke ulihalivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Kateaito loholialeau Dielusalemae velehovoge Iesuu halei Diue dubu baluga keve oai tinu. Oai tisege dubu nalimale kosivea, Diue menaka loui haivemalea isi oe kosive keau lohoale Iesu belahai avoe, “Oleike vuvune kateale aoge a vaveve kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ige Iesuu namigevei avoe, “Di isiviale hoto mole loui la belagevege la ke ihu loui di namihageto di bae oleu vuvune daoge di avuemo vaveve kateimale vamale ke loui la haivei. ");
INSERT INTO kpx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Di isiviale di namihave. Oleike vuvune Dioni omige au ata babatisogevenu. Dilava emena ataeabulike vuvune omilu.” ");
INSERT INTO kpx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kateai louge abu ke evisi moleho loui avoe “Nahiabuna onole loui namihai. Nahiabuna loui kosea, ‘Dilavaike vuvune ominu.’ Ige auna loui kosea, ‘Isito osiohoike la hotove evioholilu.’ ");
INSERT INTO kpx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Isi mesoho nahiabuna loui kosea, ‘Ataeabulike vuvune omilu.’ Ige keta anekianu. Kosealemo ata bahataeau huhuige Dilavaike vuvune Dioni omige au beloveta holinu.” ");
INSERT INTO kpx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hotoeabe keu uoholige abu Iesu namihai avoe, “No Dioniu olemo vuvune male ke no hilokaholilu.” Ige Iesuu namigevei avoe, “La katealemo di bae data di ole vuvunemo vaveve kateale vale loui la namigevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesuu tota dovudovue hoto loui namigevei avoe, “Malaha moleu au bulumo hote mole uaini haevei vavavemo hala houi bulu ke naliveve o mole egetana hounu. Isi uaini ke bai vunahaveveho abata lovonu. Kateaito haeavamoleve taliho au bulu ke mai ata degomole ovei isiviale abu buluve ke nalisi. Kateaito halei tinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iniale idi ke bai ehaveve vaniu lohoge malaha keu au esemu mole hanavoi isiviale au talive ata nehe kebiamo uaini ke bai degomole malei lohoi. ");
INSERT INTO kpx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ige esemuve keu tige abu mai hamai iovage au ada unahala hoilahai tinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ige au tota au esemu mole hanavoge abu kinavemo hamai aiohavoge vavave bahata keu toelanu. ");
INSERT INTO kpx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ige au tota au esemu mole hanavoge abu ke hamage hatinu. Ige au tota degomole hanavege abu degomole havei aiogeveito degomole havege haluvilu. ");
INSERT INTO kpx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Abu esemu kebia havehatulage malaha ke uvue mo igaeu ua. Ige malaha keu au mo hanavoi huhuai avoe, ‘Abu bae di mo hamalivebene. Isito abuna hoesehavoi.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kateige bulu nalimale kebiau mo ke elehai moleho loui avoe, ‘Bulu ko biage moike ko. Iale nahi ke hamage au hatige elike bulu kou nahiele holisi.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kateai louito mo ke hamai mai bulue iae mihatulu.” ");
INSERT INTO kpx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesuu kateai louito au esemu belagevei avoe, “La huhuige bulue biagena ata kebiamo osioi. Auna lohoniege ata kebia havei bulu ke mai ata degomole ovege abuna nalisi. ");
INSERT INTO kpx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Di louale kemo lana Bukae Hoto mole dodaveholilu. Hoto keu loui avoe, ‘O houmale keau mune moleta o houveve ke kabebihavoale keike nova Dilava o hadebiveve mune holinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dilavaike mune ke ebagemage nahi ke elehage keu nahie nimo duave seleveanu.’” ");
INSERT INTO kpx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kateai loui Diue kosive kebia namigevege abu hilokage vaveveabe kemoike au dovudovue hoto ke lounu. Kateai isiviai Iesu mai dibulae mavoi. Isito ata moaga kebia vabugevealelua Iesu halevai tilu. ");
INSERT INTO kpx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Iniale vani mole Diue kosive keau Balisia ata degomole isi Elodi ata degomole hanavei isiviale abu hoto degomole loui Iesu belahai elike hotove kemo mai dibulae mavoi. ");
INSERT INTO kpx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ige ata keau lohoale Iesue velehovoi namihai avoe, “No haivemale ata, no hilokage a hoto loumale keu seleve unaha. A ata ivite kebia vabugeveholisito ata bahatae vaveve loui kebiaho Dilava vaveve louma. Katealemo no namigevenela. No Loma gamanie kosive baluga Sisaemo takesiamale kena duave. Emena toelanu.” ");
INSERT INTO kpx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ige Iesuu loboe hoto ke hilokai namigevei avoe, “Osiohoike la loboe hoto loui isiviale di mai dibulai. Mune bai mole mai lohoge di elehai.” ");
INSERT INTO kpx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ige abu mai lohoge au belagevei avoe, “Ole munanata ivivetaike moni ko luhumo ua.” Ige abu namihai avoe, “Loma gamani kosive baluga Sisa.” ");
INSERT INTO kpx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ige au namigevei avoe, “Iale gamaniele gamani omive. Isi Dilavaele Dilava omive.” Kateai louge abu ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukea ata degomoleau Iesue loholu. Ata keabulike loui avoe, “Haluviale keau bae hovedevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iale abu loui avoe, “No haivemale ata, Moseseu menaka koseale noheho hisaliai avoe, ‘Malaha moleu mahinaito eseholisi hatige hohovena au nanae keate ke melamei au nanaho ese houevei.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iale no deiada mole louge evinela. Vani mole malaha moleu mohoho seveni (7) houevenu. Ige malaha ke moe ovokinau mahinai esebe mamoholisito hatinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ige ke valamo mo moleu au nanae gobu melamei esebe mamoholisito hatinu. Ige ke valamo mo moleu kateaito hatinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ige ke valamo mohoho degomoleau uale keau keate ke igae melaveito esebe mavoholisi bahata haluvilu. Ige gabila keate keta hatinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","No deiada ke loualemo a huhuige ata seveni (7) keabuna hovedevege keate kena ole mahina holisi.” ");
INSERT INTO kpx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ige Iesuu namigevei avoe, “Di hilokage la Bukae Hotota Dilava vuvuneta hilokaholialemoike hoto ke loui Dilava humaha hosidilu. ");
INSERT INTO kpx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kosealemo haluviale keau hovedeveliege abu bae mole holoevelivebene. Isito abuna otogoe anelu kebia nahate vai. ");
INSERT INTO kpx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","La loui kosea, ‘Haluvimale kebiau bae hovedevelivebene.’ Isito lana Bukae Hotomo Mosese deiada mole dodaveholilu. Deiada kemo Moseseu veneu idimo lahale ke vavamo lamige Dilavau avuho loui avoe, ‘Dau Ebalahamume, Aisikime, Diekobome Dilava.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Katealemo nahi hilokage keu nova nita uale kebia Dilava isi subuta haluviale munanaeabeu uale kebiata Dilava. Iale kemo la hoto louale keu seleve holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesuu Sadukea ata kebiahi hotohotoasege Diue menaka loui haivemale ata moleu keve ualeu hoto ke evisi hilokage Iesuu hotoeabe ibina louale keu seleve. Ige au avuta Iesu belahai avoe, “Menaka bahata kebiamo menaka oleteu balugataho.” ");
INSERT INTO kpx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ige Iesuu avuho loui avoe, “Menaka ko igaeu baluga. ‘Iselala ataea, evive. Nahie Kosive Dilava keu igae. Isi avu igaeike baluga. ");
INSERT INTO kpx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ialemo a uvu bahata a isivi bahata a lulele bahata isi a nego bahata malei a Kosive baluga Dilava omisi hoesehavonela.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ige menaka ke valamo mole balugaike ko. ‘A a ebika hoesehavomale ke nahate a haokuvu kebiata isivi ovei hoesegevenela.’” ");
INSERT INTO kpx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ige Diue menaka loui haivemale keu Iesuho loui avoe, “No haivemale ata, a louale keu seleve. Nahie Kosive Dilava keu igae. Isi avu nahatebeu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ige olena au uvu bahata au isivi bahata au nego bahata Dilava omisi au ebia hoesehavomale ke nahate au haokuvu kebia isivi ovei hoesegevege keu baluga. Iale menaka abuita ehovemale keu baluga. Isito ovo havei mahomale keu baluga holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ige Iesuu hotove ke evige keu au louale kemo luleleanu. Isi kateai avuho loui avoe, “A Dilava adae vuvunemo uveve keu haeava holioholinu.” Kateai louge ataeau tota Iesu belahaliho vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesuu Diue dubu balugamo ata kebia haiveniale tota belagevei avoe, “Diue menaka loui haivemale keau loui avoe, ‘Kelisona Deividi valadamo lohoi.’ Isito auna oleve kateai Deividi valada holisi. ");
INSERT INTO kpx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kosealemo Munanae Tumuu Deividi mai luleletige au loui avoe, ‘Dilavau di Kosiveho loui avoe, Di ada inuteve ugulamosege di a aiohavomale kebia malevei a veloe heimo otovege ana kosiveabe holinela.’ ");
INSERT INTO kpx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deividi biageu hoto kemo Kelisoho loui avoe, ‘Di Kosive.’ Katealemo oleve kateai Kelisona Deividi valada holisi.” Kateai louge ataeau ke evisi vahaeholahalu. ");
INSERT INTO kpx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesuu tota haivei avoe, “Diue menaka loui haivemale kebiamo la ebika nenigeveve. Keau isivilahale ogoe dua hatui ata moagaeau umale keve olahai tige abu elegevei hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Isi isivilahale dubue uvue vomue dua unahamo uguiavogei. Isi isivilahale iveve baluga vamale kemo ivite kebiahi igaetoagei. ");
INSERT INTO kpx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Keabuna loboe vaveve vai gobuvu lobogevei oeabemo kunaiabe malegei. Abuna katelahaito tiliege atae vudila guliguli egete vagei. Abu kateale vamalemo Dilavana vatehani baluga ovei.” ");
INSERT INTO kpx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesuu kateaito lotiale obeleni otovemale maua ke vavae ugulamoi ataeau obeleni otovemale kebia nibievema. Nibievesege kunaite ata keau moni baluga otovema. ");
INSERT INTO kpx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Isi elehasege gobu molehameu lohoale benie kina abui malei manemenu. ");
INSERT INTO kpx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ige Iesuu ke elehai au esemu hohavei abuho loui avoe, “Seleveta di la namigevema. Gobu keu benie kina abuita unaha otoveale keu ata bahataeau otoveale ke evihanu. ");
INSERT INTO kpx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kosealemo ata degomole keau moni moagau abuemo ualemoike abu degomole otovelu. Isito gobu keu moniu avuemo ualehameike au ke malei otovege avuemo monibehameu tota uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesuu kateaito Diue dubu baluga halei tisege esemuve moleu namihai avoe, “No haivemale ata, dubu ke elehanela. Abu muneta houale keu duave baua.” ");
INSERT INTO kpx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ige Iesuu namihai avoe, “A dubu ke elehale ke ataeabuna loholiege koilahage mune moleu bae mole golomo ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kateai louito lohoi tiale Oliveta tanae golomo ugulamoi dubu ke ninele vama. Isege Bita, Diemisi, Dioni isime Andulu keau abu ehuvela Iesue loholu. ");
INSERT INTO kpx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Lohoaleau belahai avoe, “No namigevenela. A louale kena bae vaesuvela velemai. Isi no haivenela. Ono vadena velemage noeabuna ke elehai hilokage vani keu lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ige Iesuu namigevei avoe, “La ebika nenigeveve. Onoilage ataeau la lobogevege dobuluvima. ");
INSERT INTO kpx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kosealemo ata degomole abuna loholiege di ivimo la lobogevei loui kosea, ‘Dau Keliso.’ Isi kemo ata moaga lobogevei malevei. ");
INSERT INTO kpx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ataeau haeavamole mesoho vuguta tuvalilahage lainaho ke evisi vabulahagelive. Kosealemo vaveve katealena vasohuta lohosege ke iae vanie gabina bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vata mole atae abuna hovedevei vata mole atahi tuvalilahai. Isege ata benahate abuna hovedevei ata benahatehi tuvalilahai. Ige vata degomolemo hamuna hatuge vae balugana lohoi. Vasohuta vaveve katealena lohogeto bae gabie vaveve toela degomole abuna bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Katealemo la ebia nenigeveve. Ataeabuna la malevei kanisolo kebia nimo otovei kotai. Isi dubue uvue lana di hoto loui ata haivege abuna lahavei. Abuna la holoevei kosive baluga kebia nimo otovege nehane di hoto seleve loui kebia haiveve. ");
INSERT INTO kpx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Isito vaveve katealeu lohoholisege lana di hoto ko loui ata bahata haivegeto vaveve toela katealena bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Isi abu la malevei kotalahage lainaho gasigasiai ono vade louveve ke huhulahagelive. Isito vani kela Munana Tumuna bae la hoto ono vade louveve ke mai laovege lana bae ke louve. La hoto louveve keu la hoto holioholinu. Isito Munana Tumue hotoike. ");
INSERT INTO kpx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vani kela ese igae keabuna bae moleho hailahage ataeabuna kebia havei. Ige mamuvuiabe keabuna abu eseho hailahage eseabe kebiata abu mamuvuta neinuvutaho katelahage ataeabuna havei. ");
INSERT INTO kpx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","La di ata holialemo ataeabuna laheho itumulahai huhuihuhuie toela vai. Isito oleuoleu abu evievimo negolahamale keabuna vanie gabila ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Vanie gabila lana bae vaveve nimoleteu au lamioholiale kemo lamige bae elehave. Vaveve keu dubumo uoholioholialeu dubu kemo uge Diudiae umale keabuna vaveve ke elehai detuluvisi tanae visoe tai.” (Iale olemeau hoto ko dodaveliege ihuve kaovai.) ");
INSERT INTO kpx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Vani kela ata oleu au oe dokoe uniege au lako oe vahae au hau maliho talive. ");
INSERT INTO kpx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Isi ata oleu bulue uniege au lako au oe hoilahai au dabae ogo malive. ");
INSERT INTO kpx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Vani kateimalela keate ese tobute kebia nohovu. Isege keate degomole ese gite maleale kebiata nohovu. Abuna vani kela vaveve toela malei. ");
INSERT INTO kpx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Guligulilahage elike vaveve katealeu vanie toelamo loho haleito vanie duamo lohoi. Ige elike vanie duamo detuluvive. ");
INSERT INTO kpx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vaveve toelau lohoveve kena bae balugataho seleveai. Subuta Dilavau vata vamale kela isi nova vaveve katealebeu velemaholinu. Toela ke igaena lohosege iave keve toela katealebeu bae loholivebene. ");
INSERT INTO kpx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vani keu lohoge Dilavana au ata tabageveale kebia huhuevei vani ke mai vuguvugutisi. Auna vani ke mai vuguvugutioholige ata bahataeabuna haluvisi. ");
INSERT INTO kpx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Vani kela mesoho loboe ataeau laheho loui kosea, ‘Kelisoike kove lohonu.’ O mesoho loui kosea, ‘Avuike uoke lohonu.’ Kateai louge lainaho hotoeabe evilive. ");
INSERT INTO kpx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kosealemo loboe Keliso isi loboe beloveta keabuna bae loholiege vaveve degomoleta vikoe vaveve kebiata vaevei isiviai Dilava ata lobogevei malevei. ");
INSERT INTO kpx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Vaveve toela keau lohoveve kemoike di la namigevei isiviale la la ebia nenigevei.” ");
INSERT INTO kpx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Vaveve toela keau lohoi uoholisege vanie nina bae loasege batana bae vavimo halulivebene. ");
INSERT INTO kpx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Isege otogomo umale onobenobe keabuna kibikibiage didi abuna otogomo keiolahai. ");
INSERT INTO kpx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Keu uoholisege Atae Esena au vuvune balugamo isi au atagamo goe golomo dobai lohoge ata bahatae abuna elehai. ");
INSERT INTO kpx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ige auna au anelu hanavege abuna tiliege vatae dei abuita abuita keve Dilava ataeau umale kebia malevei.” ");
INSERT INTO kpx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesuu kateai louito tota au esemu namigevei avoe, “Idi mole vigi ke elehai avuemo lulelelahave. Idi ke numuna keiolahai tota humuige lana ke elehai hilokage vaganau vuguvuguanu. ");
INSERT INTO kpx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iale ke nahate lana vaveve toela kateale elehaliege hilokage di lohoveve vaniu vuguvuguai udahae vavamo ua. ");
INSERT INTO kpx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Seleveta di la namigevema. Nova vata komo uale koeabuna haluviholisege di louale vaveve kebiabuna bahata velehovoi. ");
INSERT INTO kpx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Vani kela otogona vatati vesuai. Isito di hotou bae vesualivebene. ");
INSERT INTO kpx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Di lohoveve vani ke atabeu hilokaholige anelu kebiata hilokaholige data hilokaholinu. Isito di Mama igaeu hilokanu. ");
INSERT INTO kpx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","La di lohoveve ke hilokaholialemo ladeve halevaito hovedevei di lohoveve ke hemei uve. ");
INSERT INTO kpx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Di lohoveve keu koseanu. Ata moleu haeavamoleve taliho igaegaeai au esemu lovi ovege abu o nalisi udaha nalilu. Oe biage keu kateaito au lohoveve vani ke au esemuho louholinu. ");
INSERT INTO kpx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ke nahate laeau di lohoveve vani ke hilokaholilu. Mesoho dana vavimo o vae minamo o kokoluguu hotoisege mesoho vae alamo lohoi. Katealemo ladeve halevai nita uve. ");
INSERT INTO kpx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Onoilage la ladevesege di lohoma. ");
INSERT INTO kpx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Di isiviale hoto ke igae loui lata ata bahata kebiata namigevei. Ladeve halevaito nita uve.” ");
INSERT INTO kpx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Vanie ni abuitana uoholisege Diue vahaeho vani mole Basova kena lohoi. Vani kemo abu bae beikini baudau valavamo uale ke ilivebene. Vani keu lohoholisege dubu nalimale kosivea isi Diue menaka loui haivemale keau loboe vavevemo Iesu hamaveve ke humaha kaovama. ");
INSERT INTO kpx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Abu loui avoe, “Nahi vahaehoe vani kemo ma halevai. Onoilage atae abuna ke elehai itumulahai nahie havei.” ");
INSERT INTO kpx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kateisege Iesuu Betenie subuta lebolasi male Saimoni ke oe lovi ima. Lovi isege keate moleu kibilamo deholo hagote ibina balugate ke mai lohoale alavoi mai Iesu kinamo ehosivanu. ");
INSERT INTO kpx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ige ata degomoleau keve uale keau ke elehai itumulahai mole namigevei avoe, “Osiohoike keate keu ibina balugate ke aiohavoi ehosiva kavanu. ");
INSERT INTO kpx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abege keate keu ke mai voiai kemo moni baluga malei kunaiholimale kebia ovei.” Isi kateai itumue hoto keate keho loulu. ");
INSERT INTO kpx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ige Iesuu abuho loui avoe, “Halevave. Lainaho vaveve ke bamulive. Keu daemo vaveve duaike au ke vanu. ");
INSERT INTO kpx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kunaiholimale keabuna vani bahata lahehi uge lana bae kebia tedaevegei. Isito dau bae vani bahata lahehi ulivebene. ");
INSERT INTO kpx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Keate keu di hatige abu di mai abavuveve ke hilokaike vaime au huhuale ke vai deholota di vava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Seleveta di la namigevege evive. Oleve keve abuna di hoto loui ata namigeveliege abuna keate keu vale keta loui ata namigevege abuna keate keu vale keta huhulahagei.” ");
INSERT INTO kpx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kateige Iesu esemu mole Diudasi Kaliota keu Iesuho haiaho dubu nalimale kosive kebia namigeveho tinu. ");
INSERT INTO kpx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ige dubue kosive keau Diudasiu louale ke evisi vahaeholahai ibinaveho moni omiveve loui namihalu. Ige Diudasiu Iesu maveve ke humaha kaovama. ");
INSERT INTO kpx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Diue vahaeho vani Basova keu lohonu. Vani kemo abu bae beikini baudata valava mahoale ke ilivebene. Isito abuna vani kela mamoe havei kemo Dilava hoesehavogei. Iale vani kemo Iesu esemuiau belahai avoe, “A isiviage noeabuna oleve keve Basova lovi vage nahi isi.” ");
INSERT INTO kpx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kateige Iesuu au esemu abuita hanavei namigeve dua vai loui avoe, “Talive Dielusalema keve malaha mole elehage au e bagu ebamoi tige ke ehovai teve. ");
INSERT INTO kpx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Talive au o oletemo biloige o ke biage belahai kosea, ‘No haivemale atau loui avoe, Dana di esemuhi a dahoe oe uvu olete loualemo Basova lovi isi.’ ");
INSERT INTO kpx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kateige auna bae o ke ehue uvu mole bevuale ke mai la haivege lana keve nahi Basova lovi iveve ke gadehavove.” ");
INSERT INTO kpx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kateige esemu abuita keau halevai tialeau Dielusalemae Iesuu louale ke nahate elehalu. Isi keve Basova lovi iveve ke gadehavolu. ");
INSERT INTO kpx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iniale gutumo Iesuu au esemu degomolehi loholu. ");
INSERT INTO kpx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lohoaleau lovi isege Iesuu abuho loui avoe, “Di la namigevema. La moleu daiti lovi imale kena bae di mai atae toela ovege abuna dahavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kateai louge esemuiabeau ke evisi uvulahai igaegaeai Iesu belahai avoe, “Danike a ke huhuaime hoto ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ige Iesuu namigevei avoe, “La moleu daiti melegi igaemo lovi iale kena bae di mai ata ovei. ");
INSERT INTO kpx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ige Bukae Hotou louale ke nahate dana hatai. Isito oleu dahoe haiale ata ke nohoma. Abege neinaveu mamoholige duave. Isito neinaveu mamoge au di mai ata oveale kemo auna vatehani baluga malei.” ");
INSERT INTO kpx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iniale abu lovi isege Iesuu valava maime hoesehavoito vakoai au esemu ovei namigevei avoe, “Di misilike ko. Iale ko malei ive.” ");
INSERT INTO kpx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Isi tota kabu maime hoesehavoito mai ovege abu uaini ke ilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ige Iesuu namigevei avoe, “Di taholike ko. Di tahou lotige Dilavana ke elehai menakae doga mamoge ataeabuna kemo avuluvuta igaetolahai. ");
INSERT INTO kpx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Seleveta di la namigevema. Di bae tota vata kove e ko i molealivebene. Isito gabie di Mamae matamae doga keve bae igaetolahai tota uainie doga isi.” ");
INSERT INTO kpx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kateai louge abu nogoli louito halevai Oliveta tanae tilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tana keve Iesuu namigevei avoe, “La bahatae abuna di halevai detuluvisi tihatuve. Kosealemo Bukae Hotou loui avoe, ‘Dilavana mamoe nalievemale ke hamage mamoeve abuna detuluvisi igaegaeai.’ ");
INSERT INTO kpx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Isito auna tota di etuvage dana hovelahai vasohuta Galilie tisege lana bae tiliege keve di elehave.” ");
INSERT INTO kpx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ige Bitau namihai avoe, “A esemu degomole koeabuna a halevai. Isito di bae a halelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ige Iesuu avuho loui avoe, “Di louale ko huhuanela. Kokoluguu hoto abuitaholisege ana bae di vovoho abuita igaetai loui kosea, ‘Di ata ke hilokaholinu.’” ");
INSERT INTO kpx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ige Bitau negoai loui avoe, “Di bae a vovohoveve hoto ke loulivebene. Halege a hatige dana data hatai.” Kateai louge esemu kebia bahataeau hoto ke igae loulu. ");
INSERT INTO kpx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Katelahaito halevai lohoale bulu mole Gesemani keve velehovosege Iesuu au esemu namigevei avoe, “Kove usege di talive guliguliai.” ");
INSERT INTO kpx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kateai louito Bita Diemisi isi Dioni kebia malevei abuhi tilu. Tisege uvuve keu ono vadeu avuemo lohoveve ke huhu balugage avuemo isuanu. ");
INSERT INTO kpx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ige au abuho loui avoe, “Di uvu balugage di uvuu di mai hatihatie humahamo tima. Iale komo ulive lainaho ladevelive. Isito daluvuta nita uve.” ");
INSERT INTO kpx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kateai louito tiale iekela au kome bokoai vata bisi holumai Dilava imihai isiviale au vatetumuu avuemo lohoveve ke mai haliohatui. ");
INSERT INTO kpx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Isi loui avoe, “Mamai, vaveve bahata keau aemo toloholilu. Iale vatetumuu daemo lohoveve ke mai evihanela. Isito a isivi unaha. A isiviage dana vatetumu ke malei. Isito a isiviholige di bae ke malelivebene.” ");
INSERT INTO kpx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kateaito hoilahai lohoale au esemu abuita igaeta kebia elegevege ladevema. Ige au Bitaho loui avoe, “Saimoni, lana ladevema. Osialemoike la vanie ni igae komo daluvuta nita uoholima. ");
INSERT INTO kpx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Negobedai nita ui di Mama imihave. Ilive elike vaveve mole toelau laemo lohoge la bae kemo dobuluvilivebene. La uvu keu isiviai nita ui. Isito la vava keu negoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kateaito tota halevei tiale iekela guliguliai au subuta loui au Mama imihale ke igae lounu. ");
INSERT INTO kpx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ke louito hoilahai lohoale tota au esemu elegevege niabeu hani selevealelua ladevelu. Iniale Iesuu lohoale etuvege abu matilahai hoto louholilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ige au tota tiale guliguliaito hoilahai lohoale au esemu elegevege ladevelu. Ige au namigevei avoe, “Lana sohu ladevei uma. Elemua. Malaha neheu di mai atae toela oveveve vaniu lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iale hovedevege nahi tai. Elehave. Daho haiale malaha keike uoke lohonu.” ");
INSERT INTO kpx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kateai lousege esemuve mole Diudasi keu lohonu. Ige ata moagaeau avuluvuta lohoale keau benisi matagevei visuta matagevei loholu. Dubu nalimale kosivea, Diue menaka loui haivemalea isi oe kosive keau louike vage abu Iesu maliho loholu. ");
INSERT INTO kpx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ige Iesuho haiale malaha keu subutaike ata moaga kebia namigevei avoe, “Elehalive di talive malaha ke evudei ulikukuhavoge ke mai nalisi lohove.” ");
INSERT INTO kpx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iniale Diudasiu lohoale velemai inuta tiale Iesu namihai avoe, “Di Kosive.” Isi kateai evudei ulikukuhavonu. ");
INSERT INTO kpx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ige abu ke elehai Iesu evudei malu. ");
INSERT INTO kpx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ige Iesu esemu moleu vavavemo lamiale keu au siga mai dubu nalimale kosive baluga ke esemu mole golema heisi etulenu. ");
INSERT INTO kpx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ige Iesu namigevei avoe, “La huhuige dau vavoloe ata seleve. Ilike vage la di maliho benisita visuta malei loholu. ");
INSERT INTO kpx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Di vani bahata la dubu baluga keve timale la haivema. Isito osialemoike la keve di maholilu. Keta duave. Kateige elike Bukae Hotou la vaveve louale ke mai selevetisi.” ");
INSERT INTO kpx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kateai lousege esemuve bahata keau halevai detuluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Isege malaha moleu ogo unaha holovale keu abu Iesu mai tisege iavela ehomai tige abu ke elehai isiviale evudei mai. ");
INSERT INTO kpx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Katelahai evudege ogoveu lokolahage au kebia ada koievei vava unahata detitinu. ");
INSERT INTO kpx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abu Iesu melavei dubu nalimale kosive baluga ke oe tilu. O keve dubu nalimale kosivea, oe kosivea isi Diue menaka loui haivemale keau bahata keve igaetolahai ua. ");
INSERT INTO kpx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iale abu Iesu mai tisege Bitau kebia ialialigevei tiale keu dubu nalimale kosive baluga ke oe ulidae kosive ke esemuhi venehemo ugumai uma. ");
INSERT INTO kpx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kateisege dubue kosivea isi oe kanisolo kebiau bahata isivilahale Iesu vavamo loboe hoto loui hamage au hatai. Isito hamaveve kemo hotobeu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kosealemo ata degomoleau hovedevei Iesu vavamo loboe hoto louito deiadaeabe keau molehi igaetoholilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Kateilage ata degomoleau hovedevei Iesu vavamo loboe hoto loui loui avoe, “No evige malaha keu loui avoe, ‘Dana ataeau abu adala dubu houale ko koianiege vanie ni abuita igaetaeau uoholisege tota dubu mole ataeau abu adala houvesite houi gabiai.’” ");
INSERT INTO kpx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Isi katelahai igaegaeai hoto ke louge hotoeabe keu molehi igaetoholilu. ");
INSERT INTO kpx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ige dubu nalimale kosive balugau vigoeabemo hovelahai Iesu belahai avoe, “Ana valive hotoeabe abu loumale ke ibina loui namigevei.” ");
INSERT INTO kpx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kateige Iesuu hotoeabe ibina ke louholisito tobekai uge kosive keu tota belahai avoe, “Au ana seleveta Dilava mo Keliso.” ");
INSERT INTO kpx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ige Iesuu namihai avoe, “Ito, ata ke dalike. Iale lana ui tiliege gabie Atae Eseu ehue vuvunete Kosive ke ada inuteve ugulamoito otogo halei goemo dobai lohoge lana elehave.” ");
INSERT INTO kpx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ige dubue kosive baluga keu itumuai au ogo edikohai ata namigevei avoe, “Hotove kemo nahi bae ata degomolemo vaveveve kaovalivebene. ");
INSERT INTO kpx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","La hotove kemo au Dilava ivi aiohavoaleike la ke evilu. Iale la isiviage nahi avuemo osioi.” Ige abu hamaveve hoto loui namihai avoe, “Keu vaveve toela valemo hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kateai louge degomoleau avuemo violahai ogo mai nive bamui hamaito namihai avoe, “A huhuige oleike ahamonu.” Ige kosive kebia esemuiau abuta abu adata visuhavolu. ");
INSERT INTO kpx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Abu kateisege Bitau oe ulidae usege dubue kosive baluga ke esemuve ma moleu heie lohonu. ");
INSERT INTO kpx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Heie lohoale Bita elehasege venehemo uma. Ige au niavai valitisi avuho loui avoe, “A keu Nasaleta ata Iesuti loviamale ata.” ");
INSERT INTO kpx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ige Bitau vovohoi loui avoe, “Ono vadeike a ke louma. Di a hoto louale ke hilokaholinu.” Kateai louito ologoe ivie tisege kokoluguu hotoanu. ");
INSERT INTO kpx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ige ma keu tota hoilahai lohoale Bita elehai lavisi umale kebia namigevei avoe, “Atave moleike uoke.” ");
INSERT INTO kpx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kateige Bitau tota Iesu vovohonu. Iniale lavisi umale keau abuta tota Bita namihai avoe, “A kou Galili ata nahate. Iale no kemo hilokage a keu Iesu esemu mole.” ");
INSERT INTO kpx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ige Bitau Dilava ivi iviloi mai aiohavoi abuho loui avoe, “La malaha ke loumale ke di hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kateai lousege kokoluguu tota hoto moleanu. Ige Bitau Iesuu avuho louale hoto koseale huhuanu. Avoe, “Kokoluguu tota hoto abuitaholisege ana bae di vovoho abuita igaetai loui kosea, ‘Di ata ke hilokaholinu.’” Kateai ke huhuai nina baluganu. ");
INSERT INTO kpx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vau alamoge vavita dubu nalimale kosivea, oe kosivea, Diue menaka loui haivemalea isi kanisolo ata degomole keau hamaveve hoto loui umuvai mai Bailotie tilu. ");
INSERT INTO kpx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ige Bailotiu belahai avoe, “Diue kosive anike ko.” Ige Iesuu namihai avoe, “Avuike a ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kateige dubu nalimale kosive keau Iesu vavevemo loboe hoto loui Bailoti namihalu. ");
INSERT INTO kpx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ige Bailotiu tota Iesu belahai avoe, “Abu a vavamo hoto moaga loumale ke ana valive hotoeabe ibina ke loui.” ");
INSERT INTO kpx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kateai Iesuu hotobe louholiale kemo vikoanu. ");
INSERT INTO kpx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vagana bahatamo abu Basova lovi vamale ke vanila Bailotina atae isivi vai dibulamo ata mole iomage au dibula halei tigei. ");
INSERT INTO kpx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iale vani kemo malaha mole Balabasi keu dibulae ua. Keu ata degomolehi gamanie kosive kebiahi mole havei esemuiabe mole hamage hatiale kemo dibulae ua. ");
INSERT INTO kpx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bailotiu dibulamo ata iovemale kemo Diue ataeau lohoale Bailoti namihai isiviale au au vamale ke nahate vai. ");
INSERT INTO kpx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Isi kateige Bailotiu belagevei avoe, “La isiviage dana laheho Diue kosive baluga Iesu hanavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bailotiu hoto ke loui hilokage dubu nalimale kosive keau Iesu maina mai ilike vaime mai omilu. ");
INSERT INTO kpx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kateige kosive kebiau ata namigevei avoe, “Louge au laheho Balabasi iomage au tai.” ");
INSERT INTO kpx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ige ataeau kateai louge Bailotiu belagevei avoe, “Lana kateige dana la oe nehe ivihai loui kosea, ‘Diue kosive baluga Iesu’ ke osiohavoi.” ");
INSERT INTO kpx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ige abu baita loui avoe, “Mai idie domo hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ige Bailotiu belagevei avoe, “Osiohoike. Au ono vade toela vanu.” Ige abu baita tota loui avoe, “Mai idie domo hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ige Bailotiu isiviabe vai mai vahaehotievei Balabasi hanavoge tinu. Kateaito Iesu mai tuvalie ata ovege abu visuhavoi mai hamaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kateai melavei gamanie o baluga ke uvue tiale tuvalie ata degomole hohavege abu loholu. ");
INSERT INTO kpx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lohoale keau kosiveau ogo mole tahote hatumale ke mai avuemo holovalu. Isi hote bekabekate mai viliai kinave hanubelu. ");
INSERT INTO kpx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Isi kateai abu kosiveho loumale ke nahate vai avuho loui avoe, “Diue kosive baluga, ana duave.” ");
INSERT INTO kpx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Isi bedita kinavemo hamai avuemo violahai abu kome bokoai holuavoi hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Isi hehavoale keu uoholige abu ogo tahote ke avuemo elokohai ogove seleve mai avuemo holovalu. Kateai melavei mai hamaho tilu. ");
INSERT INTO kpx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tiale keau humaha tavae Sailini malaha mole Saimoni keluvuta belehovolu. Keu Alekisandame Luvasime mama. Iale keu botoe tiale oe lohosege abu avuho loui iovage au Iesu idie do ebamonu. ");
INSERT INTO kpx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Katelahai Iesu melavei lohoale vata mole ivi Gologota keve velehovolu. Matama ke ihuu koseanu. Lolokue matama. ");
INSERT INTO kpx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Keve velehovoi e mole toela uainita ebuiehale ke mai omisi isiviale au ke ige vateve tumuu uoholisi. Isito Iesuu ke ioholinu. ");
INSERT INTO kpx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ige abu mai idie domo hamai ogove malei kasilahai isiviale olemeau kasi kemo negolahale abuna igaegaeai ogove malei. ");
INSERT INTO kpx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Vavita vanie niu lohoaleu naini (9) okoloki masege abu mai idie domo hamalu. ");
INSERT INTO kpx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mai hamaito abu ono vademoike hamale ke hisaliai avoe, “Kou Diue atae kosive baluga.” ");
INSERT INTO kpx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Isi kateai vavoloe ata abui malevei idie domo havelu. Moleu Iesu ada inuteatave. Isege moleu adave agiteatave. ");
INSERT INTO kpx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Vaveve keu Bukae Hoto mole mai selevetinu. Hoto keu loui avoe, “Auna vaveve toelate kebia vigomo hatai.” ");
INSERT INTO kpx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Isege ata benahateau evigevei timale keau tuvikivikilahai bituhavoi avuho loui avoe, “A konike loui kosea, ‘Dana dubu baluga koianiege vanie ni abuita igaetaeau uoholisege tota houi gabiai.’ ");
INSERT INTO kpx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","A ke loualemo bato idie do kemo dobai loho.” ");
INSERT INTO kpx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ige dubu nalimale kosivea isi Diue menaka loui haivemale keau hehavoi moleho hoto ke nahate loui loui avoe, “Malaha keu ata degomole tedaevege abu dua vai hovedevelu. Isito osiohoike au au ebika hoesehavoi idie do kemo dobai lohoholinu.” ");
INSERT INTO kpx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Isi moleho loui avoe, “Keu au ebika mai loui avoe, ‘Dau Diue atae kosive baluga Keliso.’ Iale dobai lohoge no bae no uvu mai aemo mavoi.” Ige abu atae toela abuita malei avuluvuta hamale kebiata hotoe toela kateale loui namihalu. ");
INSERT INTO kpx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iniale vanie lilimo vata bahatamo vau loai gidualeu tili (3) okoloki masege vaniu tota halunu. ");
INSERT INTO kpx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Vanie ni ke masege Iesuu au hotomo baita hoai loui avoe, “Eli, Eli, lama sabakatani.” Ke ihuu koseanu. “Di Dilava, di Dilava, osiohoike a di halenu.” ");
INSERT INTO kpx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ige ata degomoleau lavisi uale keau ke evisi loui avoe, “Evive. Mesoho au beloveta mole Ilaidiaike au ke hohavonu.” ");
INSERT INTO kpx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ige malaha moleu ke evisi solekai tiale ono mole ogomu ke nahate mai uainimo manemei bedita kavitisi isiviale mai Iesu omige au isi. Isi loui avoe, “Bato usege nahi elehage Ilaidiau lohoi idie domo tedahoge au dobai lohoi.” ");
INSERT INTO kpx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kateisege Iesuu baita kekoaito hatinu. ");
INSERT INTO kpx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hatige Diue dubu balugamo abu ogo mole mai oe uvu tumute ke bamuale keu ehula dikolahai tiale heila velemai abuita holinu. ");
INSERT INTO kpx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iesuu kateai kekoai hatige tuvalie kosive moleu Iesu valamo lamiale keu ke elehai loui avoe, “Seleveta ata kou Dilava moike.” ");
INSERT INTO kpx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Kateisege keate benahateau Iesuluvuta Dielusalemae lohoale keau iekela lavisi ke elehama. Kebia vigomo Meli Magidaleni, Diemisi mole isi hohove Diosasi kebia neina Meli, isi Salome keau lavisi uma. Keate keau subuta Iesuu Galilie loviage tedahoi avuluvuta lovilahama. ");
INSERT INTO kpx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Iniale bulae ese ke igae gutumo Alimatia malaha mole Dioseba keu vabuoholisito tiale Bailoti namihai isiviale Iesu vava mai guliai. Malaha keu Diue kanisolo ata ivite. Keu Dilavau Iesu hanavoale ke evisi huhuai avoe, “Kona no kosive baluga holige noeabuna vuvunevemo ui.” ");
INSERT INTO kpx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Isi kateai tiale Bailoti namihage au Iesu hatiale ke evisi vikoanu. Isi au tuvalie kosive mole hohavoi belahai isiviale evige Iesuu subuta hatige. ");
INSERT INTO kpx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ige tuvalie kosive keu Iesuu hatiale deiada ke loui namihage Bailotiu louge Diosebau Iesu vava maliho tinu. ");
INSERT INTO kpx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tiale ogo voiai Iesu vava mai viliai mai abu munemo guli lovoale kemo abavunu. Isi mune baluga evovoai mai guli ke ili bamunu. ");
INSERT INTO kpx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kateisege Meli Magidaleni isi Diosasi neina Meli keau au Iesu vava mai abavuale ke elehama. ");
INSERT INTO kpx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bulau uoholisege Meli Magidaleni, Diosasi neina Meli, isi Salome keau senisi hagote voilahai isivilahale Sande vavita talive Iesu vava omisi. ");
INSERT INTO kpx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Isi katelahaliale vavita vavita vae hodohodota malei Iesu vutae tilu. ");
INSERT INTO kpx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tiliale humaha tavae mole namigevei avoe, “Olena nahiho mune baluga ke evovoai.” ");
INSERT INTO kpx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Isi katelahai niai elehage mune keu vovolovai badive ua. ");
INSERT INTO kpx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ige abu ke elehai guli ke uvue tiale elehage anelu moleu ogo taete valeu Iesu lovomo ugulamoi ua. Ige abu ke elehai vabu balugalu. ");
INSERT INTO kpx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ige anelu keu namigevei avoe, “Vabu halevave. Di hilokage abu Nasaleta malaha ke hamale keike la kaovama. Isito Dilavau ke etuvage keu hovelahanu. Iale lohoi lovove elehave.” ");
INSERT INTO kpx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kateaito tota namigevei avoe, “Talive esemuiabeta Bitata namigevei kosea, ‘Iesuu hovelahale auna vasohuta Galilie tisege lana bae tiliege keve elehave.’” ");
INSERT INTO kpx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ige keate keau vabu balugalelua guli kemo bibuluvisi halevai tilu. Keau vabulahalelua atabeho hoto ke louholilu. ");
INSERT INTO kpx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande vavita ke igaemo hovelahaniale Meli Magidaleni au avuemo munanae toela seveni (7) nunuveale kemo velemanu. ");
INSERT INTO kpx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ige au tiale au Iesu elehale ke loui esemuiabeau avuho ninalahamale kebia namigevenu. ");
INSERT INTO kpx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Isi Iesuu hovelahage au elehale ke loui namigevege abu hotove ke maholilu. ");
INSERT INTO kpx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Iniale vani ke igaemo Iesu esemu abuitaeau humahala tisege Iesuu au elehilehi ke nahate vaholisito toana molemo au esemu abuita kebiamo velemanu. ");
INSERT INTO kpx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ige abu hoidevei Dielusalemae velehovoi Iesu esemu degomole namigevege abu hotoeabe ke maholilu. ");
INSERT INTO kpx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iniale gabila Iesu esemu leveni (11) kebiau lovi isege au abuemo velemanu. Isi olemeau Iesu elehai abuho louge abu abu uvu mai avuemo mavoholiale kemo abuho hoto isute lounu. ");
INSERT INTO kpx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kateaito abuho loui avoe, “Talive vata bahatae di hotoe dua ko loui ata bahata haiveve. ");
INSERT INTO kpx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ige olemeau di hoto ke evisi abu uvu mai daemo mavoi babatisolahale kebiabuna ukolikoli malei. Isito olemeau abu uvu mai daemo mavoholiale kebia dana vaveveabe toela ke ibina ovei. ");
INSERT INTO kpx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Olemeau abu uvu mai daemo mavoale kebia dana di vuvune ovege abuna di ivimo munanae toela nunuvei hoto nimoletemo hoto loui. ");
INSERT INTO kpx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ige ute aihaniteau uagevege abu bae haluvilivebene. Isi mesoho haluvimale e toela hilokaholisito iliege abu bae haluvilivebene. Isi vavahanite kebia tatamo abu ada otovege abuna momolelahai.” ");
INSERT INTO kpx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kateai abuho louniale uoholige otogoe veatisi tialeu Dilava ada inuteve ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ige esemuiabe keau vata bahatae tiale ata bahata haivege Iesuu abuhi ui kebia vuvunetievege abu vikoe vaveve vaevege ataeau ke elehai hilokage abu Iesu hoto loumale keu seleve. ");
INSERT INTO kpx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teovilasi, di haoka, ata moagaeau hovedevei Iesu no vigomo vaveve dua vale ke hisalialu. ");
INSERT INTO kpx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Subuta Iesu esemuiau ata degomolehi Iesu vaveve elehai ata kebia namigevege abu ke hisalialu. ");
INSERT INTO kpx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ige data isiviale deiada ko hisaliai aho hanavoi. Au ivi balugate. Katealemo di Iesu deiadae umuka ke bahata neniai kaovai hisaliai aho hanavoma. ");
INSERT INTO kpx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iale au ko dodavei bae ihuve bahata ata degomoleau a haivuale ke bahata hilokanela. ");
INSERT INTO kpx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Vani mole subuta Elodi keu Diudia vata kemo kosive baluga holisege Diue dubu nalimale ata mole Sekalaia keu ua. Abaisa keu subuta Diue dubu nalimale ata baluga. Ige Sekalaia keu lovive ivi vanu. Mahinave ivilike Elisabeti. Keate ke valadae ivilike Eloni. ");
INSERT INTO kpx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Malaha keu abu mahinati Dilava nimo inutolotoloai uime Kosive menaka ke bahata evisi valu. ");
INSERT INTO kpx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isito keateve keu esesia. Ilage abu abu ebia holilu. ");
INSERT INTO kpx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vani mole Sekalaiau dubue loviveve vaniu lohoge au tiale dubue Dilava hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Diue dubu nalimale atae vaveve keu koseanu. Vani igaegae abuna ata igae ebagevage kena deholo hagote mai tiniege dubue uvue batabata golomo ehosivai mahogei. Abu vani kela Sekalaia ebagevage au Kosive dubue uvue tinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tialeu dubue uvue deholo hagote mahosege ata moagaeau heie guligulilahama. ");
INSERT INTO kpx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Guligulilahasege anelu moleu Sekalaiae lohoale deholo mahomale batabatae ada inuteveatae laminu. ");
INSERT INTO kpx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ige Sekalaiau ke elehai vabuage uvuveu kibikibiai ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ige anelu keu namihai loui avoe, “Sekalaia, vabu halenela. Dilavau a imiliale ke eviale a mahinana bae ese mai. Ese keu uge ivihai loui kosea, ‘Dioni.’ ");
INSERT INTO kpx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vani kela lana bae vahaehoave. Ese keu uge ata moagaeabuna bae vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kosealemo kena bae Dilava nimo kosive baluga holisi. Au bae e toela bahata ke ilivebene. Au uale vani kela Munana Tumutena bae uvuvemo holomage auna negoai. ");
INSERT INTO kpx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kena bae Iselala ata moaga malevege abuna tota abu Kosive Dilava ehovai tai. ");
INSERT INTO kpx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kena beloveta Ilaidia vaveve ke nahate vai negoai vuvuneai. Ige hotove kemo eseabuna abu mamuvuhi tota bevuai igaetoai. Kena bae hoto eviholimale ata kebia haivege abuna bae lulele ata holisi vaveve inutolotolote vai. Auna vasohuta tai ata haivege abuna abu vaveve hoesegevege Kosivena lohoi.” ");
INSERT INTO kpx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ige Sekalaiau anelu ke namihai loui avoe, “Kateige dana oleve kateai. Dau koli holige di mahinata mabata holinu.” ");
INSERT INTO kpx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ige anelu keu loui avoe, “Dau di ivilike Geibiliolo. Dau Dilava vudimo umale Dilavau di namihaike vage di hotoe dua ko loui a namihama. ");
INSERT INTO kpx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vani mole di hoto louale kena bae velemai. Isito a di hoto eviholinu. Katealemo a bae hotoalivebene. Ana bae uvute nahate valive di louale vani keu lohoge bae hotoanela.” ");
INSERT INTO kpx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekalaiau dubue uvue usege ataeau heie hemei uma. Isi loui avoe, “E, Sekalaia keu tiale dubue uvue osioime solekai lohoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kateai lousege Sekalaiau heie lohoniale abuhi hotoholige abu huhuige keu dubue uvue tiale vaveve nimolete elehanu. Katealemoike au uvute holisime ada unahata deiada loui haivema. ");
INSERT INTO kpx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iniale Sekalaia dubue loviu uoholige au halei oe tinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Vani degomoleau uoholisege mahinaveu tobuaime oai tiholisito bata ada mole ke uvumo o unahamo ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Isi loui avoe, “Vagana moaga di eseholiale kemo Dilavau di tedahonu. Iale ataeau di elehage di eseholiale mati kena uoholisi.” ");
INSERT INTO kpx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ke iae bata igae uoholisege Dilavau anelu nehe Geibiliolo hanavoge keu Galili vatae tialeu o mole Nasaletae velemanu. ");
INSERT INTO kpx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","O keve velemage ma mole Meli keu ua. Ma ke abu Diosebaho kokovalu. Dioseba keu Deividi valadamo lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ige anelu keu lohoale avuho loui avoe, “Ana duave. Kosiveu aiti ui a hoesehavoge au nivemo duave.” ");
INSERT INTO kpx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kateige Meliu hoto ke evisi vikobaluganu. Isi huhuai avoe, “Hoto oleteike ko.” ");
INSERT INTO kpx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ige anelu keu avuho loui avoe, “Vabu hale. Dilavau a eahalenu. ");
INSERT INTO kpx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ialemo ana bae eseane. Ese keu uge ivihai loui kosea, ‘Iesu.’ ");
INSERT INTO kpx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kena uniege kosi baluga holige Dilava ehue umale kena bae loui kosea, ‘Keu di moike.’ Dilavana ebagemage auna vatae kosive holisi au haoka Deividiu ugulamomale telonamo ugulamoi. ");
INSERT INTO kpx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iale auna bae vani baita Diekobo valada kebia nalievegei. Isi kateige vuvuneveu bae ata kebiamo uoholilivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aneluu hoto kateale louge Meliu namihai loui avoe, “Dau koliaholinu. Iale dana oleve kateai eseai.” ");
INSERT INTO kpx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ige aneluu avuho loui avoe, “Munana Tumutena aemo dobai lohoge Dilava vuvune kena a bamuge ana ese ke manela. Katealemo Dilavana au mo ke ivihai kosea, ‘Di mo tumuteike.’ ");
INSERT INTO kpx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ana a neina mole Elisabeti ke hilokanu. Ataeau loui avoe, ‘Keu eseholisito mabata holisi ua.’ Hoto kateale louito keu tobuta uale aike bata ada mole isi igae uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dolodolo halenela. Dilava kemo onobeu bae anekialivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kateige Meliu loui avoe, “Dau Kosive esemu daliko. A hoto bahata louale kena daemo lohoge keu duave.” Kateai louge aneluu halei tinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Vani kemo Meliu solekai au kunai bevuai malei tanae o moleve Diudia vatae tinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Isime Sekalaia oe tiale mahinave Elisabeti namihai loui avoe, “Ana duave.” ");
INSERT INTO kpx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ige Elisabetiu hoto ke evige unive uvue eseveu kibianu. Ige Dilava Munanae Tumuu avuemo lohoaleu mai vuvunetinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ige Elisabetiu tovuai avuho loui avoe, “Dilavau a ebagemage a keate bahatae vigomo keate baluga. Iale ese kena uge Dilavana ebagemai hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A keu di Kosive neina. Iale a dae deiai lohoale kou duave baua. ");
INSERT INTO kpx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Di a hoto louale ke evisege di ese unita uale keu kibiai vahaehoanu. ");
INSERT INTO kpx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Iale vahaeho baluga. A hilokage Dilavau aho hoto louale kena seleve holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kateige Meliu avoe, “Di di uvumo vahaehoai di Kosive hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Dilavau di tedahomale kemo di vahaeho baluganu. ");
INSERT INTO kpx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dau Dilava nimo iviholinu. Isito keu di huhuanu. Nova komo ata bahataeabuna loui kosea, ‘Dilavau keate ke hoesehavonu.’ ");
INSERT INTO kpx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kosealemo Kosive ivi balugate keu dahoe vaveve baluga vanu. Ivive keu tumute. ");
INSERT INTO kpx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Katealemo oleuoleu Dilava vabuhavoge uvuvena abuemo ui. Ige auna vani bahata kebiata eseabeta tedaevegei. ");
INSERT INTO kpx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ige adave keu vaveve negote vanu. Isime auna oleuoleu abu ebika tabagevaho huhuimale kebia huhuihuhui bahata malei evihai. ");
INSERT INTO kpx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Keu vatae kosive baluga kebia tatolemagevenu. Isito au ata uvevete kebia tabagevenu. ");
INSERT INTO kpx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Keu lovie dua ata vaete kebia ovege uniabeu hanilahalu. Isito ata kunaite kebia iovege abu ada unahala tilu. ");
INSERT INTO kpx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dilavau au ata Iselala tedaevenu. Au kebia haleveholisito kebiaho uvuale kemo au tedaevenu. ");
INSERT INTO kpx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kosealemo Dilavau subuta nahie buluveho lounu. Isi Ebalahamuho loui avoe, ‘A valada isi a ese kebia dana vani bahata huhuevei hoesegevegei.’” ");
INSERT INTO kpx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meliu hoto kateale louime Elisabeti oe uale bata abuita igaetaeau uoholisege au halei au oe tinu. ");
INSERT INTO kpx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Vani mole Elisabeti eseu uveve vaniu lohoge moveu ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Moveu uge valadaeabeau isi haokuvuiabeau ke evisi vahaeho balugalu. Abu hilokage Dilavaike keate ke huhuaime ese ke mai ominu. ");
INSERT INTO kpx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bula igaeu uoholige haokuvuiabeau lohoale mo ke hoesehavoi vudive vate etulei isiviale ataeau kemo hilokage keu Ebalahamu valadae ese. Kebia vaveveu kateanu. Vateve etulege uoholige abu isiviai mamave Sekalaia ivita ivihai. ");
INSERT INTO kpx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Isito neinaveu loui avoe, “Kate halevave. Iviveike Dioni.” ");
INSERT INTO kpx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kateai louge abu keate keho loui avoe, “Au a valada kemo ivi katealebeu uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Isi kateaime abu ada unahata deiada mamave haivuma. Isiviale mamaveu ivi oleteale mo ke ivihai. ");
INSERT INTO kpx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kateige au adamo beba mai omiveve tovetove vanu. Ige abu beba mai omige au hisaliai avoe, “Iviveike Dioni.” Kateige abu ke elehai viko balugalu. ");
INSERT INTO kpx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kateisege solekavesite Dilavau Sekalaia ai alavoge au hotoai Dilava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ige haokuvuiabeau ke elehai vabu balugalu. Ige ataeau Diudia tanae uale keau bahata hoto ke evilu. ");
INSERT INTO kpx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ige ata bahataeau ke evisi huhulahai avoe, “Ese kena bae vadeai.” Isime abu hilokage Kosive adae vuvuneu ese kemo ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dioni mama Sekalaia keu Dilava hoesehavosege Munana Tumuteu uvuvemo holomage au gabie velemaveve hoto lounu. ");
INSERT INTO kpx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isi loui avoe, “Nahi nahie Kosive hoesehavoi. Keu Iselala ata nahie lohoale isiviai nahie vatetumumo nahie tedaevei malevei. ");
INSERT INTO kpx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kosealemo keu nova au esemu Deividi valadamo nahie toelamo nahie maleveveve ata negote ebagemanu. ");
INSERT INTO kpx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Subuta mole Dilavau hoto kateale loui au beloveta tumute kebia namigevenu. ");
INSERT INTO kpx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Au louale auna nahie aiogevemale ata kebia isi nahiho itumulahamale ata kebia adamo nahie tedaevei. ");
INSERT INTO kpx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Au subuta nahie buluveho loui mamoale ke auna huhuai nahiho uvuai nahie tedaevei. ");
INSERT INTO kpx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ke nahate au subuta nahie buluve Ebalahamu keho hoto tumute lounu. ");
INSERT INTO kpx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Au hoto tumute louale kemo auna nahie aiogevemale kebia adamo nahie tedaevei. Auna nahie tedaevege nahiabuna vabuholisito lovive vai. ");
INSERT INTO kpx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Isime ata tumute holisi vani bahata Kosive nimo vaveve inutolotolote vagei. Dilavau hoto loualeu kemo kateai ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iale di mo, ataeabuna ahoe loui kosea, ‘Dilavau ehue umale ke beloveta alike.’ Iale ana vasohuta tai Kosive humaha elulumasege auna bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ana bae Kosiveu toelamo au ata maleveve hoto louge abuna bae abu vaveve toela halevege Dilavana kebia toela ulihai. ");
INSERT INTO kpx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kosealemo nahie Dilava keu uvue Dilava. Keu nahiho uvuai nahie tedaevema. Iale vau alamoale ke nahate Kosive atagana nahiemo halui. ");
INSERT INTO kpx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nahiemo haluge oleuoleu vavie vaveve vamale kemo haluviho vasege Kosivena kebia holoevege abuna uveve duae humahala tai.” Sekalaia hotou kemo kateai ua. ");
INSERT INTO kpx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Igeto moveu balugai kosi holisege uvuveu negoige au o halei botoe tialeu ataeau uvesite keve ua. Keve uniale vani moleu lohoge au lohoaleu Iselala ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dioni uale vani keve Loma kosive baluga Ogasita keu menaka mole mamoi isiviale ata bahataeau gamanie buka baluga kemo abu ivi otovei. ");
INSERT INTO kpx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ogasita keu menaka ke mamosege Kuliniasi keu Silia vata ke kosive. ");
INSERT INTO kpx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Menaka keu loui avoe, “Ata bahataeabuna abu vavivue oe hoidevei talive abu ivi otovei.” ");
INSERT INTO kpx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Menaka keu kateige Nasaleta malaha mole ivi Dioseba keu Galili vata halei lohoale Diudia vatae velemanu. Vata keve valadave Deividi ke ou ua. O ke ivilike Betelihamu. ");
INSERT INTO kpx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Iale Diosebau abu keate kokovale keti tiale o keve velehovolu. Tiale keau au ivita Meli ivita buka balugamo otovelu. ");
INSERT INTO kpx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Keate keu tobuta tiale Betelihamue usege eseveu uveve vaniu lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ige ladeveve ou uoholige abu tiale ovoe oe usege move ovokinaveu ua. Ige au ogo mai viliai mai ovoeau lovi imale batabata ke golomo lahoenu. ");
INSERT INTO kpx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vavi kemo ata degomoleau ovo nalimale keau o ke vavae abu mamoe nibievema. ");
INSERT INTO kpx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Isege Dilava anelu moleu abue lohoge Kosive atagau abuemo halunu. Ige abu vabu balugatahoalu. ");
INSERT INTO kpx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Isito anelu keu namigevei loui avoe, “Vabu halevave. Di hotoe duaike mai laheho lohonu. Iale ata bahataeabuna hoto ke evisi vahaeho balugai. ");
INSERT INTO kpx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hotoe dua keu koseanu. La toelamo la tedaeveve ata, keu nova Betelihamue ua. Keu la Kosive baluga Keliso. ");
INSERT INTO kpx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iale lana oleve kateai di louale ke hilokai. Talive abu ogota ese ke viliai mai batabatae golomo lahoeale ke elehave.” ");
INSERT INTO kpx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hoto keu uoholisege solekavesite anelu moagaeau otogo halevai loholiale anelu keti nogoli loui Dilava hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Abu loui avoe, “Nahi otogoe Dilava ivi balugate ke hoesehavoi ivive ebagevai. Kosealemo auna vata komo uveve dua au isivie ata kebia ovei.” ");
INSERT INTO kpx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneluiau kateai louito halevai ehue tilu. Isege mamoe nalimale keau moleho loui avoe, “Bato lohoge nahi Betelihamue talive Kosive esemuu louale vaveve ke elehai.” ");
INSERT INTO kpx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kateai louito halevai bibuluvisi tilialeau Meliu Diosebati uale ke kaovalu. Isi tialeau elehasege ese neheu iene batabata golomo lahai ua. ");
INSERT INTO kpx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ige mamoe nalimale ata keau lohoale ese ke elehai anelue hoto ke loui ata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ige ata bahata keau mamoe nalimale hotoe deiada ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Isito Meliu tobekai ui hoto ke gaeahavoi ke huhuima. ");
INSERT INTO kpx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ige mamoe nalimale keau hoidevei abu oe tiale keau nogoli loui Dilava hoesehavoma. Kosealemo abu anelu louale ke evisi ke bahata elehalu. ");
INSERT INTO kpx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bula igae uoholige abu vudive vate etuleveve vaniu lohoge abu ivihai loui avoe, “Iesu.” Kosealemo neinaveu tobuholisege aneluu ivive kateale mamonu. ");
INSERT INTO kpx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Vani moleu lohoge Diosebau abu keateti Dielusalemae tilu. Abu isiviale Mosese menakau louale ke vai abu ebika hoesegeveime ese mai Kosive nimo mavoi isiviale au Kosive ata tumute holisi. ");
INSERT INTO kpx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kosive menakamo keu loui avoe, “Oleme ese ovokinau uge abu mai Kosive omige au Kosive ata tumute holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vaveve kateale valiho valiege vasohuta abuna mesoho imutava abuita mesoho kelea abuita malei dubue mahoi abu ebika hoesegevege valive Kosiveu hoesegevei eseabeta hoesehavoi. Kosive menaka keu kateai lounu. ");
INSERT INTO kpx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vani kela malaha mole Dielusalemae uale iviveike Simioni. Malaha keu malahae dua. Dilava vabuhavomale malaha. Keu vani baita Iselala tedaeveve ata ke hemei uma. Ige Munana Tumuteu avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Isime namihai loui avoe, “Ana uniege Dilavau Iselala ata tedaeveve Keliso ke hanavoge elehaito bae hatinela.” ");
INSERT INTO kpx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Katealemo Munana Tumuteu Simioni melamege au Diue dubu balugae tinu. Isege Diosebau Meliti abuta Iesu mai dubue menaka neheu louale ke nahate valiho loholu. ");
INSERT INTO kpx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ige Simioniu Iesu mai evudei Dilava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Au imihai loui avoe, “Di Kosive, dau a esemu. A di namihale ke nahate di a ese ko elehanu. Iale dana nova bae uvue duamo hatai. ");
INSERT INTO kpx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Di di nitela Iselala tedaeveve ata ko elehanu. ");
INSERT INTO kpx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","A ata ko hanavoge lohoale ata bahatae abuna elehai. ");
INSERT INTO kpx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A hanavoge lohoale kou atagae ata. Iale atagavena vatae ataemo atagage abuna humahave elehai. Isi Iselala ata kebiatamo atagage abuna vuvune baluga malei.” ");
INSERT INTO kpx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simioniu hoto kateale louge ese ke mamau neinaveti ke evisi viko balugalu. ");
INSERT INTO kpx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ige Simioniu hoesegevei neinaveho loui avoe, “Dilavau ese ko ebagemage Iselala ata degomole abuna hotove evige auna hoesegevei. Isito Iselala ata degomole abuna hotove eviholige auna aiogevei. Keu Dilava vaveveike. Iale ataeabuna itumuai bae avuho lougei. ");
INSERT INTO kpx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ige Dilavana bae uvuiabeta huhuihuhuiabe keta hilokai. Iale Meli nohoma. Vaveve toela katealeu lohoi a uvu ke bige kibikibiage ana bae ke huhuai uvuige.” ");
INSERT INTO kpx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simioniu hoto kateale loualeu gabiho vasege belovetae keate mole Ana keu lohonu. Ige Mamave ivilike Banuelo. Keu Asa valadamo lohonu. Keate keu koliale abu koliati uale vagana ada mole isi abuitaeau uoholisege koliaveu hatinu. ");
INSERT INTO kpx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Isege au gobu holisi ualeu vagana eiti voa (84) uoholinu. Keu mabata seleve. Iale keu vani baita dubu haleholima. Isito vanimo vavimo auna dubue uvue ui Dilava hoesehavogei. Iniege vani mole guliguliho vaniege au bae lovi ilivebene. Isito auna guliguli unahagei. ");
INSERT INTO kpx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iale keate nehe keu ese ke elehaime Dilava hoesehavonu. Isime Dielusalemae ata namigevei avoe, “Nahie tedaevei nahie maleveve ataike ko.” ");
INSERT INTO kpx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kateai louge Dilava menakau louale ke nahate abu bahata vage uoholige Diosebau abu mahinati halevai hoidevei Galili vatae tiale abu o seleve Nasaletae ua. ");
INSERT INTO kpx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Keve velehovoi usege Iesuu ihunivesite lamisi au ebia holisi negoanu. Ige luleleveu avuemo balugage Dilavau hoesehavoi avuti ua. ");
INSERT INTO kpx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vagana bahata Iesu mamana neinaveti Dielusalemae Basovae lovi iliho tigei. ");
INSERT INTO kpx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kateimalela Iesu vaganau tueloisege (12) abu halevai lovi ke iliho Dielusalemae tilu. ");
INSERT INTO kpx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ke ige uoholige mamaveu neinaveti hoidevei oe tisege Iesuu Dielusalemae ua. Isito mamaveu neinaveti ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ige abu elehaholisime huhuai loui avoe, “Au elemo mesoho ata ko moaga uvue lohoma.” Isi kateai vani kemo halevai tilu. Tiale keau gutumoike abu bae humaha tavae haokuvuiabe belagevelu. ");
INSERT INTO kpx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Belagevege Iesu uoholige abu hoidevei Dielusalemae tota kaovaho tilu. ");
INSERT INTO kpx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kaovalage vani abuita igaeta uoholige abu Diue dubu baluga uvue tiale elehage au Iselala ata haivemale baluga kebia vigomo ugulamoi ui hotoeabe evisi belagevema. ");
INSERT INTO kpx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ige keau namihage au hotoeabe haliko kemo baita luleleage ataeau ke evisi vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kateisege mamaveu neinaveti ke elehai tetelahalu. Ige neinaveu namihai avoe, “Di mo, a vadeulike ko noemo vama. Ige no a mamati a huhuai aho uvulahai a kaovama.” ");
INSERT INTO kpx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ige Iesuu namigevei loui avoe, “La vadeuhoike di kaovama. Lana hilokaholilu. Dau di Mamae oe uvue ui lovive vale keu duave.” ");
INSERT INTO kpx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Isito au abuho louale ke keau ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ige Iesu abuhi hoilahai tota Nasaletae tinu. Tialeu hotoeabe evisi abu louale ke vama. Ige neinaveu vaveveve kateimale au uvumo huhuima. ");
INSERT INTO kpx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ilage Dilavau elehage ataeau abuta elehage Iesuu kosi holige vaveveveu negoige luleleu avuemo baluganu. ");
INSERT INTO kpx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vani moleu lohoge Loma kosive baluga Taibeliosi keu vagana vivtini (15) ke uvumo vatae kosive baluga holinu. Isege Botiasi Bailoti keu Diudia vatae kosive holinu. Isege Elodi keu Galili vatae kosive. Isege hohove Bilibi keu Itulia isi Talekonaita vata kebia nibievema. Isege Lisaniasi keu Abilini vata ke kosive. ");
INSERT INTO kpx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Isege vani kemo dubu nalimale kosive abuitaeau ua. Iviabeike Anasi isi Kaiabasi. Kosive katealeau usege vani kemo Dilavau Sekalaia mo Dioni botoe umale ke namihanu. ");
INSERT INTO kpx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ke namihage au tialeu e mole Diodani ke vavae matama igaegaela ata haivei loui avoe, “La vaveve toela ke halevai hoidevei babatisolahave. Ige Dilavana la vaveve toela ke ulihage auna uoholisi.” ");
INSERT INTO kpx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iale Dioni vaveve keike beloveta mole Aisaiau subuta loui hisaliai avoe, “Ata molena bae ataeau uvesiteve hoai kosea, ‘Kosiveho humaha ke inuta loive. Isi au tiveve humaha ke inuta vave. ");
INSERT INTO kpx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Loho ke omisi vealuvive. Isi hevaha ke lovoi omisi hevaluvive. Isi ke hoesehavoge au inutolotoloai. Humahau keukakeukage ke inutolotolohavove. Isi humahae toela keta hoesehavove. ");
INSERT INTO kpx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Katealemo ata bahataeabuna Dilavau toelamo ata maleveveve ke elehai.’” ");
INSERT INTO kpx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ata moagaeau Dionie lohoi isiviale au babatisogevei. Isito Dioniu namigevei avoe, “La keau ute nahatea. Laeau isiviholilu Dilava itumuu lae loholiho. Isito la hoidevei Dilava ehovaholilu. Katealemoike Dilava itumuu laemo lohoma. ");
INSERT INTO kpx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iale vasohuta la vaveve toela halevai vaveve dua vave. Isi kemo bae babatisolahave. Isi lainaho huhulahai kosea, ‘Noeau Ebalahamu valada noeabuliko. Iale Dilava itumu keu bae noemo loholivebene.’ Di la namigevege evive. Dilavana isivianiege mune kobiamo Ebalahamu valada degomole vaevege abuna la lovomo ui. ");
INSERT INTO kpx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Soeu idie umukamo heiliho hemei ua. Iale idi oletena baioholige auna idi ke heisi mai venemo mihatuge auna lahai.” ");
INSERT INTO kpx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kateai louge ataeau loui avoe, “Iale noeabuna vadeai.” ");
INSERT INTO kpx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ige Dioniu namigevei avoe, “La oleuoleu ogo abuiabuialiege mole mai ogoholiale ke omive. Isime la oleu lovi balugau avuemo uge degomole malei lovioholiale kebia oveve.” ");
INSERT INTO kpx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kateige takesi moni malemale ataeau Dioniu babatisogeveho avue loholu. Isi namihai avoe, “No haivemale ata, noeabuna vadeai.” ");
INSERT INTO kpx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ige au loui avoe, “Lainaho vavolo nahate valive. Gamaniu takesi loumale moni ke unaha maleve.” ");
INSERT INTO kpx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kateige tuvalie ataeau Dioni namihai loui avoe, “Isege noeabuna vadeai.” Ige keu loui avoe, “Lainaho bae ata havei moniabe malelive. Isi lainaho ata molemo loboe hoto loui moniabe malelive. Lainaho la ibina ke elehai kabebilahalive.” ");
INSERT INTO kpx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kateige vani kemo ata bahataeau Dioni hoto maime loui avoe, “Mesoho ata kou nahie ata tedaeveve Kelisoike ko.” Kateai louime ke kaovai molehi hotohotolahama. ");
INSERT INTO kpx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ige Dioniu kebia bahata namigevei loui avoe, “Dana emo la babatisogevei. Isito ata mole baluga di evihale keu aike lohoma. Di baluga holioholialemo tamakave iamoveve keu daemo anekianu. Eu kosive. Isege dau valave. Iale auna Munana Tumuteta veneta la babatisogevei. ");
INSERT INTO kpx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iale ata kena lohoniege au keilota laisue i bisi kitoai hatuge momoluve abuna moleve keiolahasege ive abuna moleve keiolahai. Ige auna laisue i malei au valahumo otoveito momoluve ke malei veneu hodovavesite kemo mahoevei.” ");
INSERT INTO kpx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dioniu hotoe dua moaga kateale loui ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Isi gamanie kosive Elodiho hoto tolote lounu. Kosealemoike Elodiu au hohoe mahina Elodiasi ke etulei melamenu. Isi vaveve toela degomoleta vaevenu. ");
INSERT INTO kpx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Vaveve toela moaga vaeveito ke golomo Dioni mai dibulae hanavonu. ");
INSERT INTO kpx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Au mai dibulae hanavoholisege Dioniu ata degomole babatisogevenu. Isi Iesuta babatisohavonu. Ige Iesu hovelahai lamisi guliguliasege otogou dikolahanu. ");
INSERT INTO kpx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ige Munana Tumuteu imutava ke nahate holisi dobai lohoaleu avuemo ua. Isege hoto moleu otogomo dobai lohoaleu loui avoe, “Au di uvue mo seleve. Iale di a vahaeho va baluganu.” ");
INSERT INTO kpx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu babatisomale vani kela vaganaveu teti (30). Ige ataeau huhulahai avoe, “Iesu keu Dioseba mo.” Isito ke mama seleveike Dilava. Ige Dioseba mamaike Heli. ");
INSERT INTO kpx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ige Heli mamaike Matati. Ige Matati mamaike Livai. Ige Livai mamaike Meliki. Ige Meliki mamaike Dianai. Ige Dianai mamaike Dioseba. ");
INSERT INTO kpx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ige Dioseba mamaike Matataiasi. Ige Matataiasi mamaike Emosi. Ige Emosi mamaike Nahumi. Ige Nahumi mamaike Esili. Ige Esili mamaike Nagai. ");
INSERT INTO kpx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ige Nagai mamaike Meati. Ige Meati mamaike Matataiasi. Ige Matataiasi mamaike Semeni. Ige Semeni mamaike Dioseki. Ige Dioseki mamaike Dioda. ");
INSERT INTO kpx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ige Dioda mamaike Dioanani. Ige Dioanani mamaike Leisa. Ige Leisa mamaike Selubabeli. Ige Selubabeli mamaike Siatieli. Ige Siatieli mamaike Neli. ");
INSERT INTO kpx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ige Neli mamaike Meliki. Ige Meliki mamaike Adi. Ige Adi mamaike Kosami. Ige Kosami mamaike Emadami. Ige Emadami mamaike Eli. ");
INSERT INTO kpx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ige Eli mamaike Diosua. Ige Diosua mamaike Eliesa. Ige Eliesa mamaike Diolimi. Ige Diolimi mamaike Matati. Ige Matati mamaike Livai. ");
INSERT INTO kpx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ige Livai mamaike Simioni. Ige Simioni mamaike Diuda. Ige Diuda mamaike Dioseba. Ige Dioseba mamaike Dionami. Ige Dionami mamaike Eliakimi. ");
INSERT INTO kpx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ige Eliakimi mamaike Melea. Ige Melea mamaike Mena. Ige Mena mamaike Matata. Ige Matata mamaike Natani. Ige Natani mamaike Deividi. ");
INSERT INTO kpx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ige Deividi mamaike Diesi. Ige Diesi mamaike Obedi. Ige Obedi mamaike Boasi. Ige Boasi mamaike Salemoni. Ige Salemoni mamaike Nasoni. ");
INSERT INTO kpx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ige Nasoni mamaike Aminadabu. Ige Aminadabu mamaike Alamu. Ige Alamu mamaike Heseloni. Ige Heseloni mamaike Belesi. Ige Belesi mamaike Diuda. ");
INSERT INTO kpx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ige Diuda mamaike Diekobo. Ige Diekobo mamaike Aisiki. Ige Aisiki mamaike Ebalahamu. Ige Ebalahamu mamaike Tela. Ige Tela mamaike Nahoa. ");
INSERT INTO kpx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ige Nahoa mamaike Seluki. Ige Seluki mamaike Leu. Ige Leu mamaike Beleki. Ige Beleki mamaike Ebeli. Ige Ebeli mamaike Sala. ");
INSERT INTO kpx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ige Sala mamaike Keinani. Ige Keinani mamaike Avasadi. Ige Avasadi mamaike Semu. Ige Semu mamaike Noa. Ige Noa mamaike Lameki. ");
INSERT INTO kpx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ige Lameki mamaike Metusala. Ige Metusala mamaike Inoka. Ige Inoka mamaike Dieleti. Ige Dieleti mamaike Mahalaleli. Ige Mahalaleli mamaike Keinani. ");
INSERT INTO kpx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ige Keinani mamaike Enosi. Ige Enosi mamaike Seti. Ige Seti mamaike Adamu. Ige Adamu mamaike Dilava. ");
INSERT INTO kpx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesuu Diodani e halei tige Munana Tumuteu avuemo baluganu. Avuemo balugai melamei ataeau uvesite keve tinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tiale keu keve usege Seteneu lohoale vani voti (40) ke uvumo lobohavoi isiviale elehage Iesuna kemo dobai o negoai. Keu vani ke ni bahatamo lovi iholialemo vae baluganu. ");
INSERT INTO kpx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ige Seteneu avuho loui avoe, “A Dilava mo holiniege mune ko namihage au beleidi holige inela.” ");
INSERT INTO kpx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ige Iesuu namihai loui avoe, “Bukae Hotou loui avoe, ‘Atabeu bae lovi unaha ke isi kemo negoalivebene.’” ");
INSERT INTO kpx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kateige Seteneu tota melamei tanae tiale solekavesite vata bahata mai haivunu. ");
INSERT INTO kpx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Isi loui avoe, “Dana vata ko bahata mai aoge ana kemo vuvune baluga mai bae kunai moaga malenela. Dilavau louge vata ko bahata di vata. Kunai keta di kunai. Iale dana mai di isivie ata omige auna malei. ");
INSERT INTO kpx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iale ana a kome bokoai vata bisi di hoesehavoge dana ke bahata malei aomai.” ");
INSERT INTO kpx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ige Iesu namihai avoe, “Bukae Hotou loui avoe, ‘A Kosive Dilava ke igae hoesehavoi isivive unaha vanela.’” ");
INSERT INTO kpx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kateige Seteneu tota Iesu melamei Dielusalemae tinu. Tialeu Diue dubu baluga ke kobola lavihovosege Seteneu loui avoe, “A Dilava mo holiniege komo lamisi biloa. ");
INSERT INTO kpx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kosealemo Bukae Hotou loui avoe, ‘Dilavana au anelu hanavege abuna a nibisi a hoesehavoi.’ ");
INSERT INTO kpx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hoto keu tota loui avoe, ‘Anelu abuna a evudei. Ige a bae dobai munemo a ebika hamalivebene.’” ");
INSERT INTO kpx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ige Iesu hotove ibina avuho loui avoe, “Hoto seleveike. Isito Bukae Hotou tota loui avoe, ‘Lainaho heiata la Kosive nego ke kaovalive.’” ");
INSERT INTO kpx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ige Seteneu hoto kateale loui Iesu lobohavoge uoholige au halei tinu. Isiviai talive ukaukaito tota avue lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iale loboe vaveve keu uoholige Iesuu halei Galili vatae tinu. Keve tiale Munana Tumute vuvunemo ua. Ige au vamale ke hotou vata ke bahatae tinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ige au tiale dubuiabemo ata haivege abu bahata hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Vani mole Iesu hoilahai tiale Nasaletae au esebuluta uale keve velemanu. Vani bahata bulau lohoge auna tiniege guliguliagei. Iale bula kemo au tiale dubue lamisi isiviai Bukae Hoto dodavei. ");
INSERT INTO kpx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kateige abu beloveta Aisaia buka mole mai omilu. Ige au buka ke mai vavehai iviganiai dodavei tinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dodavei avoe, “Dilava Munanau daemo ua. Au di ebagemage dana hotove dua loui kunaiholimale kebia haivei. Au di hanavoge dana tiniege vaveveabe toela kemo iovege abuna ke halevai. Au di hanavoge ni kedute keabuna bae nilahai elehai. Au di hanavoge dana olemeau uvu unahamo umale kebiata hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Au di hanavoge dana ataho loui kosea, ‘Kosivena bae aike la hoesegevei la tedaevei.’” ");
INSERT INTO kpx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hoto ke dodavege uoholige au buka mai dubue ata mole omisito ugumanu. Ige ata bahataeau tobekai nibisi ua. ");
INSERT INTO kpx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ige Iesu namigevei abuho loui avoe, “Di hoto dodavege la eviale keu nova velemanu.” ");
INSERT INTO kpx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hoto kateale louge abu hotoe dua ke evige uvuiabeu teteanu. Isi vikolahai loui avoe, “Dioseba monike. Au oleve kateai hoto ke manu.” ");
INSERT INTO kpx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ige Iesu abuho loui avoe, “Di hilokage la hoto kosealeike dahoe louliho. ‘Au vavahanite hoesegevemale ata. Iale a ebika hoesehavonela.’ Mesoho lana tota daho loui kosea, ‘A Kabenumu oe vaveve ni molete vale ke nahate a vata seleve kove kateale vanela.’ La la uvumo hoto kateale huhulahama. ");
INSERT INTO kpx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Isito di la namigevege evive. Beloveta ata kena au vata kemo hoto louge atave seleve keau bae hotove evilivebene. ");
INSERT INTO kpx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dana kemo hoto mole loui. Subuta mole Ilaidiau usege veniu lohoholiale vagana abuita igaeta isi bata ada mole isi igaeu uoholinu. Katealemoike vata ko bahatamo loviu uoholige vae balugau lohonu. Kateimale vanila Iselala gobuvu moagaeau vata kove ua. ");
INSERT INTO kpx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isito kebiaho Dilavau Ilaidia hanavoholinu. Ke hanavoge vata mole Saidoni keve tiale Salebeta oe gobu mole tedahonu. ");
INSERT INTO kpx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Subuta vani kela Iselala ata moagaeau vavahani mole lebolasi ke malu. Isito beloveta Ilaisau kebia tedaeveholinu. Isito Silia kosive mole Neimeni ke igae tedahoge au momoleanu.” ");
INSERT INTO kpx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iesu hoto isute kateale louge ata bahataeau dubue uvue ke evisi avuho itumu balugalu. ");
INSERT INTO kpx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Isi kemo hovedevei Iesu kabitisi isiviale mai oe iae seikamo mihatui. ");
INSERT INTO kpx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Isito Iesuu ata bahatae edekaeabemo velemai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesuu matama ke halei Galili vatae o mole Kabenumue tiale keve bulamo ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ige abu Iesuu louale ke evisi vikolahalu. Kosealemo hoto keu vuvuneanu. ");
INSERT INTO kpx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ige dubu ke uvue tilogoe malaha moleu baita hoai kekoanu. ");
INSERT INTO kpx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Kekoai loui avoe, “Iesu Nasaleta ata, no halevei tenela. Ana no aiogevelihonike kove lohonu. Di hilokage au Dilava mo tumute.” ");
INSERT INTO kpx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ige Iesuu munanae toela ke namihai loui avoe, “Hoto halei malaha ke halei tenela.” Kateige munanae toela keu malaha ke laluvai mai vudiabemo vata hamanu. Isi ata ke halei tige au dua vanu. ");
INSERT INTO kpx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ige ata bahataeau vikolahai moleho loui avoe, “E, hoto onoleiko. Malaha kou au vuvunemo munanae toela kebiaho baita louge abu halevai tima.” ");
INSERT INTO kpx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iale Iesuu vamale hoto keu vata ke bahata sonumai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu hovelahai dubu halei Saimoni oe tinu. Tiale keu Saimoni meau hobe balugale ke abu loui Iesu namihalu. ");
INSERT INTO kpx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ige Iesuu tiale vavavemo lamisi vavahanive ke hotohavoge uoholinu. Ige keate keu solekavesite hovelahai lovi vai ovenu. ");
INSERT INTO kpx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gutumo vaniu dobasege ataeau haokuvuiabeau vavahaniamale kebia malevei Iesue loholu. Ige Iesu au ada mai igaegae kebia golomo mamoge abu bahata momolelahalu. ");
INSERT INTO kpx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Isime munanae toela moaga kebia nunuvege abu kekolahai loui avoe, “Au Dilava mo alike ke.” Kateai lousege Iesu hotoeabe bamunu. Kosealemo abu hilokage Dilavau ke hanavoge keu ata tedaeveve Keliso holinu. ");
INSERT INTO kpx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Vani mole vau alamosege Iesuu o halei ataeau uvesiteve tinu. Ige ataeau kaovalata bae elehalu. Ke elehai namihai loui avoe, “Ti haleito no o komo unela.” ");
INSERT INTO kpx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Isito Iesu namigevei loui avoe, “Dilavau di hanavoalemo dana o benahateve tiniege ataeau Dilava adae vuvunemo uveve hoto ke loui ata haivei.” ");
INSERT INTO kpx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kateai louime halei tiale Diudia vata ke bahatae dubuiabemo ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vani mole Iesuu tiale tabu mole Genesaleti esagae laminu. Keve lamisege ata moagaeau Dilava hoto eviliho lohoale molemo neniholilu. Isi Iesu kabitige au lamiveve humahau uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kateisege huena malemale keau bouti abuita malei esagamo otovei abu ugabi malei totoisege Iesuu kebia elegevenu. ");
INSERT INTO kpx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ige Iesuu ata mole Saimoni ke boutimo biloai Saimoni namihai loui avoe, “Aike esagamo ko hanavoge au e goloe tikatikai.” Kateaito golovemo ugulamoi ata moaga kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ata moaga kebia haivege uoholige au Saimoni namihai loui avoe, “Bouti ko hanavoge au tota e ni seleve tai. Isime la ugabi malei hatui huena moaga maleve.” ");
INSERT INTO kpx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ige Saimoniu loui avoe, “No baluga, no nova vavi ko bahatamo e maholata huenabe maleholilu. Isito a loualemo noeabuna ugabi tota emo hatui.” ");
INSERT INTO kpx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kateai louito abu ugabi malei hatulu. Ige huena moagatahoeau ugabiabemo tobalohoge ugabiu dikolahaho vekeanu. ");
INSERT INTO kpx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kateige keau bouti mole keve abu haokuvu hohavei loui avoe, “Lohoi no tedaeveve.” Kateige abu lohoale huena malei bouti abui ke bilage keau ililohoho vekeanu. ");
INSERT INTO kpx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ige Saimoni Bitau huena moaga elegevei Iesu vudimo au kome bokoai vata bisi namihai avoe, “Kosive, di halei tenela. Kosealemo dau atae toela.” ");
INSERT INTO kpx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kateai louale keu koseanu. Keu au esemuhi huena moaga kebia elegevei vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ige haokuvuiabe Sebedi mo abui Diemisiu Dioniti abuta viko balugalu. Ige Iesuu Saimoni namihai loui avoe, “Vabu halenela. A subuta huena malema. Isito ana aike daho ata malevenela.” ");
INSERT INTO kpx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kateige abu bouti malei lohoale esagamo otovei halevai Iesu ehovai tilu. ");
INSERT INTO kpx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Vani mole Iesuu o moleve tige lebolasite ata moleu lohoaleu Iesu elehai vudivemo kome bokoai vata bisime holumai baita avuho loui avoe, “Di Kosive, a isivianiege di hoesehavonela.” ");
INSERT INTO kpx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ige Iesu au ada hatui malaha kela holisi namihai avoe, “Ito, dana a hoesehavoi.” Ke lousege solekavesite malaha kemo lebolasiu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ige Iesu isuta avuho loui avoe, “Inuta talive a ebika mai dubu nalimale kosive ke haivuge au a vava elehai a namihage Moseseu louale ke nahate vai ono mole mai mahoi Dilava hoesehavoge ataeabuna elehai hilokage a vavau duaveanu. Isito ainaho bae atabeho di a hoesehavoale ko loulive.” ");
INSERT INTO kpx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iesuu kateai louito vaveveve keu o bahatae tai gabianu. Ige ata moagaeau isiviai loholive hotove evisime au vavahaniabe kebia hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Isito Iesuna vani degomole halevei tiniege ataeau uvesite keve guliguliagei. ");
INSERT INTO kpx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vani mole Iesu ata haivesege Balisia ata isi menaka haivemale ata keau Galili vatae, Diudia vatae isi Dielusalema o baluga keve loholu. Lohoale keve uguiavoi hoto ke evisege Dilava vuvuneu Iesuemo uge au vavahaniamale kebia hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Isege ata degomoleau malaha mole ada toelate isi velo toelate ke kaulamo mavoi ebavoi loholu. Isiviale malaha ke mai lohoi oe uvue Iesu vudimo mavoi. ");
INSERT INTO kpx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Isito ata moagaeau molemo nenioholiale kemo abu mai oe vahae lohoveve keu anekiage abu ebavoi mai tiale oe goloe mavoi o ke kobuhai kaula ke umuvai mai vahamo manevege malaha keu kaula kemo dobai tiale ata kebia vigomo Iesu vudimo dobai ua. ");
INSERT INTO kpx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ige Iesuu vaveveabe ke bahata hilokage abu abu evievi Iesuemo mavolu. Iesu malaha keho loui avoe, “Di haoka, di a toela ke bahata ulihage uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kateai lousege Diue menaka loui haivemale ata isi Balisia ata keau huhulahai avoe, “Oleike ko hoto koseale loui Dilava ivi aiohavoma. Atabeu bae vaveve toela ulihalivebene. Isito Dilava igaena kateale vai.” ");
INSERT INTO kpx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kateai lousege Iesuu huhuihuhuiabe ke hilokai namigevei loui avoe, “Vadeuhoike la huhuihuhuie toela kateale huhulahama. ");
INSERT INTO kpx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dana hoto vadeu loui. Dana malaha ke namihai kosea, ‘Di a vaveve toela ke bahata ulihanu.’ Emena dana loui kosea, ‘Hovelahai tenela.’ La huhuige hoto oleteu toloholinu. ");
INSERT INTO kpx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Isito halege dana vavahanite ke hoesehavoge lana kemo hilokage vaveve toela ulihaveve vuvune ketau daemo ua.” Kateai louito vavahanite ke namihai loui avoe, “Hovelahai a ava egumai mai a oe tenela.” ");
INSERT INTO kpx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kateai lousege malaha keu solekavesite vudiabemo hovelahai au avamo lahamale ke egumai mai au oe tiale keu Dilava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ige ata bahataeau ke elehai tetelahai vabulahai Dilava hoesehavoi avoe, “Vaveve oletealeike nahi nova elehale ko.” ");
INSERT INTO kpx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iesuu kateaito halei tialeu takesi malemale ata mole elehanu. Iviveike Livai. Malaha keu takesilahamale oe uvue ugulamoi usege Iesuu namihai loui avoe, “Di ehomanela.” ");
INSERT INTO kpx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ige Livaiu hovelahai au kunai bahata halevei Iesu ehomanu. ");
INSERT INTO kpx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Vani mole Livaiu au omo lovi balugataho Iesuho vai hoage takesi malemale ata isi haokuvuiabe degomole keau lohoale abuhi lovi ima. ");
INSERT INTO kpx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ige Balisia ata isi Diue menaka loui haivemale keau Iesu esemu namigevei loui avoe, “Osiohoike la takesi malemale atae toela kebiahi igaetoai lovi ima. Isime atae toela degomole kebiahi igaetoai lovi ima.” ");
INSERT INTO kpx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kateai louge Iesu namigevei avoe, “Medikolou bae negote kebiaho loholivebene. Isito auna vavahanite kebia unaha hoesegeveliho lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iale dau lohoale kou atae dua kebia hohaveliho lohoholisito vaveve toela vamale kebiahoike di lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iesuu kateige menaka haivemale ata keau tota Iesu namihai avoe, “Dioni esemu keau vani igaegae lovi iholisito guliguli unahama. Ige Balisia esemu kebiata kateale vama. Isito a esemu keau kateale vaholima.” ");
INSERT INTO kpx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ige Iesuu namigevei avoe, “La huhuige mo molena ma mole melamege haokuvuiabe abuna lovi isi. Emena abuna halevai. Ba, abuna lovi isi vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Isito vani mole atae toelaeabuna loholiege mo ke hamage haokuvuiabe abuna bae vani kela uvulahai lovi i halevai.” ");
INSERT INTO kpx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kateaito tota dovudovue hoto mole loui namigevei loui avoe, “Atabeu bae ogoe dogae ivi etulei mai ogoe mamie vaha badivulivebene. Auna kateige ogoe doga kena toelai. Ige mamive ke elehage elehilehivena toelai. ");
INSERT INTO kpx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ke nahate atabeu bae uainie doga mai ovoe vate badivuale mamivemo ehosivalivebene. Auna kateige kena savai dikolahai. Ige uainie e kena hosilahai lotihatui. ");
INSERT INTO kpx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Isito atabena uainie doga mai ovoe vatee dogamo ehosivage keu bae dikolahalivebene. Iale di vaveveu bae vatae vavevehi igaetoalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Isito atabena vani bahata uainie mami ke iniege auna uainie doga keho isiviholisi. Isito auna huhuige uainie mami keu avuemo heanu.” ");
INSERT INTO kpx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vani mole bulamo Iesu au esemuhi oai tiale konee bulu molemo tisege esemuiabeau kone dakoai ke boboai ilu. ");
INSERT INTO kpx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ige Balisia ataeau ke elehai namigevei loui avoe, “La vadeuhoike menaka eguvai bulamo katelahalu.” ");
INSERT INTO kpx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ige Iesu namigevei avoe, “Lana Bukae Hotomo Deividiu au esemuhi vaelahaime vale ke dodaveholilu. ");
INSERT INTO kpx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Isi Dilava dubue uvue tiale beleidi tumute ke mai iale keta lana dodaveholilu. Dubu nalimale unahaeabuna beleidi ke igei. Isito vani kela Deividiu menaka ke egumai beleidi ke isi au esemu ovege kebiata ilu.” ");
INSERT INTO kpx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hoto kateale louito hotoeabe kemo loui avoe, “Atae Ese keu bulae Kosive. Iale auna onole louge abuna ke vai.” ");
INSERT INTO kpx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bula mole vanimo Iesuu tota dubue tiale ata haivesege malaha mole adave inuteu goloale keu keve ua. ");
INSERT INTO kpx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Isege Diue menaka loui haivemale ata isi Balisia ata keau Iesu nibisi isiviai elehage Iesuna bulamo malaha ke hoesehavoge abuna vaveveve kemo kotalahai. ");
INSERT INTO kpx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ige Iesu huhuihuhuiabe ke hilokai ada toelate keho loui avoe, “Hovelahai kove loho.” Ige malaha keu hovelahai laminu. ");
INSERT INTO kpx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ige Iesuu dubue kosive kebiaho loui avoe, “Dana la namigevei. Nahie menaka keu nahie haivege nahiabuna bulamo osioi. Nahiabuna bulamo vaveve dua vai. Emena vaveve toela vai. Nahiabuna bulamo ata hoesegevei. Emena ata aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ige abu hotohotoholige Iesuu elegevei lotinu. Isime malaha nehe ada toelate ke namihai avoe, “A ada hatunela.” Ige malaha keu au ada hatuge adaveu inuanu. ");
INSERT INTO kpx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ige dubue kosiveau ke elehai avuho itumu selevelahalu. Isime hotohotoai Iesu hamaliho humaha kaovama. ");
INSERT INTO kpx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vani mole Iesuu tanae guliguliho tialeu vavi ke bahatamo guliguliai Dilava imihanu. ");
INSERT INTO kpx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ilage vau alamoge au esemu bahata hohavege abu lohoge au kebia bahatamo esemu tuelo (12) tabagevei loui avoe, “Laeau di abostoloea.” ");
INSERT INTO kpx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kebia iviabe abuike koea. Moleike Saimoni. Isito Iesu ivihaleike Bita. Ige hohove Andulu. Ige Diemisi. Ige Dioni. Ige Bilibi. Ige Batolomi. ");
INSERT INTO kpx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ige Matiu. Ige Tomasi. Ige Aloveasi mo Diemisi mole. Ige Saimoni mole keu Selotie ata. ");
INSERT INTO kpx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ige Diemisi mo Diudasi. Ige Iesuho haiaveve malaha mole Diudasi Kaliota. Iesuu esemu kateale tabagevege abu avuluvuta ua. ");
INSERT INTO kpx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesuu abuhi tana ke halevai heie lohoale loho moleve velehovoge esemuve moagaeau loholu. Ige ata moagamoagaeau Iesu hoto eviliho abu o halevai loholu. Kebia degomoleau Diudia vatamo loholu. Isege degomoleau o baluga Dielusalema halevai loholu. Ige tota degomoleau davala vavae o abuita Taea isi Saidoni kebiamo loholu. ");
INSERT INTO kpx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lohoale isiviale Iesu hoto evige au vavahaniabe kemo hoesegevei. Ige degomoleau munanae toelau abuemo umale kebiataeau lohoge au kebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ige ata bahataeau Iesu vuvuneu ata hoesegevemale ke elehai isiviale levei. ");
INSERT INTO kpx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesuu au esemu niavei abuho loui avoe, “Kunai holimalea, vahaeholahave. Dilavana ata la nahate malevege lana adave vuvunemo uve. ");
INSERT INTO kpx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Vaelahamalea, vahaeholahave. Gabie la uniabuna bae hanilahai. “Ninalahamalea, vahaeholahave. Gabie lana bae helahave. ");
INSERT INTO kpx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Di esemuia, ataeabuna bae laheho isiviholisi la hoto hamai la aiogevei laheho loui kosea, ‘La keau atae toelaea.’ Kosealemo laeau di esemuia. Abu kateige vahaeholahave. ");
INSERT INTO kpx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Vani kateimalela hovedevei vahaeholahave. Kosealemo lana bae otogoe ibina baluga maleve. Subuta buluveabeau kateale vai beloveta aiogevelu. Ialemo ataeau la aiogevege vahaeholahave. ");
INSERT INTO kpx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Isito kunai moagatebia la nohovu. La vatae vahaeho unaha vaito otogoe kunai maleholilu. ");
INSERT INTO kpx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Isi uniabeu aike hanilahamale la nohovu. Lana bae gabie vaelahave. “Aike helahamale la nohovu. Lana bae gabie ninalahave. ");
INSERT INTO kpx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ataeau hotoe dua loui la hoesegeveale la nohovu. Kosealemo subuta buluveabeau loboe hoto kateale loui loboe beloveta hoesegevelu.” ");
INSERT INTO kpx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Isito di hoto evimalea, di la namigevege evive. La aiogevemale kebia isivi ovei hoesegeveve. Isi laheho itumuamale kebiata hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Isime laheho hotoe toela loui la aiogeveale kebia hoesegeveve. Isi laheho vaveve toela vamale kebiataho Dilava imihave. ");
INSERT INTO kpx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ata oleu la mono vaki molemo hamage louge au tota vaki moleveatae hamai. Ige ata oleu la dabae ogo mage louge au la sieti keta mai. ");
INSERT INTO kpx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ata oleu onoleho isiviai la namigevege isivive ke mai omive. Isi ata oleu la kunai malege lainaho bae au mai hoilahaveve keho namihalive. ");
INSERT INTO kpx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","La isiviage ataeau la hoesegeveho vage lata ata kebia hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Isito ata oleuoleu laheho isivilahai la hoesegeveale kebia unahaho lana isivilahage Dilavana oleve kateai la hoesegevei. La hilokage atae toela keau vaveve kateale vai abu haokuvu unahaho isivilahama. ");
INSERT INTO kpx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Isito lana oleuoleu laemo vaveve dua vamale kebia unahaemo vaveve dua vage Dilavana oleve kateai la hoesegevei. La hilokage atae toela keau vaveve ke nahate vai abu haokuvu unahamo vaveve dua vama. ");
INSERT INTO kpx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mesoho ata molena lae lohoi laemo moni malege lainaho au gabie ibinave laoveveve ke huhulahalive. Kosealemo atae toela unahaeabuna vaveve kateale vagei. Lana kateai huhulahage Dilavau bae la hoesegevelivebene. ");
INSERT INTO kpx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lainaho vaveve kateale valive. Isito la aiogevemale kebia isivi oveime vaveve dua abuho vai hoesegeveve. Laemo moni malemale ke lainaho huhulahai kosea, ‘No moni kena hoilahai noe lohoi.’ Lana vaveve kateale valiege ibina baluga malei bae ehue umale Kosive baluga ese holieveve. Kosive vaveve keu koseanu. Keu atae toela kebia hoesegevei huhuihuhuie toela huhuimale kebiata hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","La Mamau otogoe vamale ke nahate lata ata huhuevei kebia tedaeveve.” ");
INSERT INTO kpx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Lainaho mole vaveve toela kaovai abuemo loui kosea, ‘Keau vaveve toelate.’ Lana mole vaveve kaovaholige Dilavana avuta bae la vaveve toela kaovalivebene. Isi lainaho mole toelamo hoto loui ibinaeabe ovegelive. Isi lainaho molemo vaveve toela vale ke huhulahagelive. Lana katelahage Dilavana avuta la toela ke huhuoholisito ulihai. ");
INSERT INTO kpx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lana kunaimo isi otogoe hotomo ata tedaevege Dilavana bae kunai laovei la tedaevei. Lana kateale vage kunaina bae laemo balugai. La vaveve oletealemo ata tedaevege Dilavana avuta la tedaevei.” ");
INSERT INTO kpx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesuu hoto kateale louge uoholigeto dovudovue hotomo namigevei avoe, “Malaha mole ni kedute keu bae malaha mole ni kedute ke melamei avui talivebene. Abuna avui katelahaliege abuna abata ke igae vuvegevei. ");
INSERT INTO kpx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Esemue hoto keu bae haivemale atae hoto evihalivebene. Isito esemuiabe keabuna hotove ke kaovai negolahaliege abu kosive nahate holisi. ");
INSERT INTO kpx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“La isiviale la haokae nimo louka mai. Isito la kateisege la nimo louka balugau ua. ");
INSERT INTO kpx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Louka balugau la nimo uale kemo lana oleve kateai la haokaho loui kosea, ‘Lohoge di a nimo loukae esehameu uale ke mai.’ Lainaho katelahai la haoka lobohavolive. Isito vasohuta louka balugau la nimo uale ke maito bae la haokae nimo loukae esehameu uale ke mave.” ");
INSERT INTO kpx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Idie dua keu bae hahuhumie toela valivebene. Ige ke nahate idie toela keu bae hahuhumie dua valivebene. ");
INSERT INTO kpx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Idi bahata hahuhumite ke la hilokalu. Iale la bae laokamo madilini ehalivebene. Isi la bae sesenamo vulutu ehalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Atae dua ke uvumo huhuihuhuie duau uale kemo auna hotoe dua lougei. Isito atae toela ke uvumo huhuihuhuie toelau uale kena kemo hotoe toela lougei. Kosealemo ataeau abu aimo loumale keu abu uvumo huhulahamaleike abu ke louma.” ");
INSERT INTO kpx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“La osiohoike di namihai kosea, ‘No kosive. Isito la di louale ke eviholilu. La kateige toelanu. ");
INSERT INTO kpx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Isito oleuoleu dae lohoi di hoto evisi vamale ata kebia vaveveu koseanu. ");
INSERT INTO kpx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ata moleu oe dua houmale ke nahate. Auna abata lovoi hade malei emee dua vai munee golomo au o houge hanunuu lohoge o keu bae hobelahalivebene. Kosealemo keu au o houe dua vanu. ");
INSERT INTO kpx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Isito ata moleu di hoto evisito vaholimale keu oe toela esagamo houmale ke nahate. Keu neniai abata lovoi hade malei neniai emeholinu. Ialemo hanununa lohoge o kena solekai hobelahai bahata toelai.” ");
INSERT INTO kpx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesuu hoto kateale loui ata namigevege uoholigeto au halei Kabenumue tinu. ");
INSERT INTO kpx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","O kemo Loma tuvalie kosive moleu ua. Uvuve esemu keu vavahaniale hatiho vekeanu. ");
INSERT INTO kpx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ige tuvalie kosiveu Iesu vamale hoto ke evisime Diue kosive hanavei isiviale abu Iesu namihage au loholive esemuve hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kateige abu lohoale Iesu namihai avoe, “Tuvalie kosive moleu isiviale lohoi talive esemuve hoesehavonela. No isiviale ke tedaho. ");
INSERT INTO kpx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kosealemo malaha keu atae dua. Keu no ata bahata hoesegevei noheho dubu mole hounu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Abu hoto kateale loui Iesu namihage au halei abuhi tinu. Tialeau oe vavae tisege tuvalie kosiveu au haokuvu hanavege abu lohoale Iesu namihai avoe, “No kosiveu loui avoe, ‘Di kosive, halege ainaho di oe loholive. Dau bae atae duabene a bae di oe uvue lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Katealemoike di data isiviholinu ae loholiho. Isito ana hoto unaha louge di esemu kena momoleai. ");
INSERT INTO kpx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Di hilokage tuvalie kosive baluga keau vuvune mai daovale kemo dana di tuvalie esemu namigevege abuna di isivi ke vai. Dana mole namihai kosea, ‘Tenela.’ Ige auna tai. O mesoho moleho loui kosea, ‘Loho.’ Ige auna lohoi. O mesoho dana di omo loviamale esemu namihai kosea, ‘Ke vanela.’ Ige auna vai. Iale ana hoto unaha louge di esemu kena momoleai.” ");
INSERT INTO kpx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ige Iesuu hoto ke evisi vikoai hoilahai ata moagaeau ehovai tiale kebiaho loui avoe, “Di la namigevei. Iselala ataemo di evievi kosealebe negote elehaholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kateai louge tuvalie kosive haokuviabe keau tota hoidevei ove tilu. Tiale ove velehovosege esemuveu momoleanu. ");
INSERT INTO kpx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Vani mole Iesuu halei o mole Neinie tinu. Keve tige esemuiabe isi ata moaga keau avuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tiale keau ologoe velehovoho vasege o ke biaeau ata moleu hatiale ke kesita ebavoi mai abuela loholu. Hatiale keu gobu mole mo igaehameike ke hatinu. Ige oe ata moagaeau gobu keluvuta loholu. ");
INSERT INTO kpx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ige Iesuu gobu ke elehai avuho uvu balugai namihai loui avoe, “Nina hale.” ");
INSERT INTO kpx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kateai louito tiale au ada mai kesi kemo mamoge ebavoi lohoale keau lavilu. Ige Iesuu loui avoe, “Moia, di a namihama. Hovelaha.” ");
INSERT INTO kpx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kateige hatiale atau hovelahai hotoanu. Ige Iesuu mai neinave ominu. ");
INSERT INTO kpx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ige ata bahataeau ke elehai vabulahai Dilava hoesehavoi loui avoe, “Beloveta balugau nova noe lohonu. Dilavau au ata tedaeveliho lohonu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ige Iesuu vamale hoto keu Diudia matama keve tinu. Isime Diudia ke iae o degomole ketave tinu. ");
INSERT INTO kpx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kateige Dioni esemuiau ke evisi lohoale namihalu. Ige Dioniu au esemu abuita hohavege abu avue loholu. ");
INSERT INTO kpx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ige au kebia hanavei loui avoe, “Talive Iesu namihai loui kosea, ‘Dioniu subuta loui avoe, No tedaeveve ata kena bae lohoi. Iale ata ke anike ko. Emena noeabuna mole hemei ui.’” ");
INSERT INTO kpx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ige abu Iesue lohoale avuho loui avoe, “Dioni ata babatisogevemale keu no hanaveike vage no a belahaho loholu. Dioniu isiviai hilokai. No tedaeveve ata ke anike ko. Emena noeabuna mole hemei ui.” ");
INSERT INTO kpx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kateai belahasege Iesu niabemo ata moaga vavahaniamale kebia hoesegevema. Ata degomoleau munanae toelau abuemo umale. Isege degomoleau ni kedutea. Iale Iesu kebia hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Isi kemo Dioni esemu namigevei loui avoe, “Hoidevei talive la vadeu elehai eviale ko loui Dioni namihai kosea, ‘Ni kedute keau nilahama. Ige velo golote keau lavisi olahama. Ige lebolasite kebia vavahaniu uoholima. Ige golemate keau hoto evima. Ige haluviale kebiata hovedevema. Isime di hotoe dua loui kunaiholimale kebiata haivema. ");
INSERT INTO kpx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ige oleuoleu dolodoloholisito au evievi daemo mamoale kena vahaeho balugai.’” ");
INSERT INTO kpx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iesuu kateai lougeto Dioni esemuiau halevai hoidevei tisege au bae Dioni deiada loui ata moaga kebia namigevei avoe, “La komo botoe tiale Dioni elehage keu ata oleteale. La huhuige auna au uvu mai Dilavaemo mamoi negobedai laminu. Emena helukau kulumo mamoge kulu kibikibiale ke nahate auna vanu. ");
INSERT INTO kpx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","La keve tiale ata oleteale elehalu. Lana elehage kena ogoe dua vamale atanike ke. Ba, ogoe dua vamale keau bae botoe ulivebene. Isito abuna oe duamo ugei. ");
INSERT INTO kpx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Di tota la namigevei. La keve tiale vadeu elehalu. Lana beloveta elehalu. Seleveta belovetaike la ke elehalu. Isito keu beloveta kebia evigevei baluganu. ");
INSERT INTO kpx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dioni vaveve keike Bukae Hotou loui avoe, ‘Dana di esemu mole hanavoge auna aho uli holisi tiniege ata namigevei kosea, Kosiveu lohoma.’ ");
INSERT INTO kpx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Di hoto mole louge evive. Dioniu ata bahata vata komo uale kebia evigevenu. Isito ivivesiteu di ata holisi Dilava adae vuvunemo uale keu Dioni evihanu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Oe ata moaga isi takesi malemale ata kebiau Iesuu louale hoto ke evilu. Ata kebiau subuta Dioniu haiveale hoto ke huhuai avoe, “Dilava menaka keu noemo duave seleve.” Kebiaike Dioniu babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Isito Balisia ata isi menaka haivemale ata keau Dioniu louale hoto evisito isiviholilu Dilava humahala taliho. Katelahage Dioniu kebia babatisogeveholinu. ");
INSERT INTO kpx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ige Iesuu kebia namigevei avoe, “Dana vadeu tovetove novae atate kobiaho loui. ");
INSERT INTO kpx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Keau esebuluiau ologomo molehi gilulahamale ke nahate. Esebulu abuna moleho loui kosea, ‘Noeau laheho sale hamageto laeau havulahaholilu. Ige noeau ninalahageto laeau nohehi ninalahaholilu.’ Iale novae vani komo uale la vaveve keau esebulue vaveve ke nahate. ");
INSERT INTO kpx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Isi ke nahate ata babatisogevemale Dioni keu lohoale vani degomole lovi ioholisi uaini halege la loui kosea, ‘Keu tilogoe ataike.’ ");
INSERT INTO kpx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iniale Atae Eseu lohoniale uainita lovita ige la loui kosea, ‘Ata ke elehave. Keu lovi ivolovoloimale ataike. Keu uaini isi momaime takesi malemale atae toela kebiahi haokuvuanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","La louale kemo ataeau hilokage la luleleholilu. La hoto keu esebulue hoto nahate.” ");
INSERT INTO kpx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Vani mole Balisia malaha moleu isiviale Iesuu talive ove avuti lovi isi. Ige Iesuu tiale ove avuti ugumai lovi ima. ");
INSERT INTO kpx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Isege o keve keate mole toela seleveu ua. Keu Iesuu o keve uale ke evisi deholo mole hagote mai lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ke mai lohoale Iesu vavamo lamisi ninasege nimetavaveu Iesu velomo dodama. Ige au kome bokoai vata bisi au kinata Iesu velo ulihage uoholige au velove ke ulikukuhavoi deholo hagote ke mai velove ominu. ");
INSERT INTO kpx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ige Balisia malaha nehe Iesuho lovi vale keu ke elehai au uvumo huhuai avoe, “Iesu kou beloveta holivatebe keate keu levege au vaveveve toela hilokanu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Balisia malaha keu huhuihuhui kateale vage Iesuu ke hilokai avuho loui avoe, “Saimoni, dana hoto mole aho loui.” Ige Saimoniu loui avoe, “Di kosive, louge di evisi.” ");
INSERT INTO kpx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kateige Iesuu deiada mole loui namihai avoe, “Vani mole malaha mole abuiau kosive mole monimo bukalu. Moleu vai handele (500) kinamo bukanu. Isege moleu vivti (50) kinamo bukanu. ");
INSERT INTO kpx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Moni ke abu malei biage omiveve vaniu lohonu. Isito moniu abuemo uoholinu. Ige monie biageu namigevei avoe, ‘Lainaho moni daovaveve ke huhulahagelive.’ Iale deiada kemo a huhuige malaha oleteu kosive ke vahaehove va baluganu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ige Saimoniu namihai loui avoe, “Di huhuige moni baluga maleale malaha keu.” Ige Iesuu loui avoe, “Avulike.” ");
INSERT INTO kpx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Isi kateai au ebia ekovehai keate ke niavoime Saimoni namihai loui avoe, “Keate ko eleha. Di a o kove lohoge a e hai di velo totoholinu. Isito keate kou ninage nive eu di velomo dodage au kinata di velo ulihanu. ");
INSERT INTO kpx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Di vasohuta a oe lohoge au di vahaeho vai di ulikukuhavoholinu. Isito di lohoge keate kou di velo bubuhavonu. ");
INSERT INTO kpx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A deholobeta di kina omiholinu. Isito keate kou au deholo hagoteta di velo ominu. ");
INSERT INTO kpx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Di a namihage evi. Di keate ko vaveve toela moaga ulihage uoholinu. Kosealemo keu au isivi bahata mai daemo mamoi di hoesehavo seleveanu. Isito ata olena di huhu eseveage dana vaveveve toela eseve ulihai.” ");
INSERT INTO kpx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kateai louito keate ke namihai loui avoe, “Di a vaveve toela bahata ulihage uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kateige lovi imale ata degomoleau moleho loui avoe, “Hoto oleteale ko. Vaveve toela ulihamale atanike ko.” ");
INSERT INTO kpx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ige Iesuu keate ke namihai avoe, “A a evievi daemo mamoale kemo Dilavau a toelamo a tedahonu. Iale vahaehomo tenela.” ");
INSERT INTO kpx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Vani degomoleau uoholige Iesuu au esemu tuelo (12) ehai abuhi tialeau o moagamoaga keve ataeau Dilava adae vuvunemo uveve hotoe dua ke loui haivelu. ");
INSERT INTO kpx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ige keate degomoleau abuhi tiale kebia degomoleau vavahanitea. Isege kebia degomolemo munana toelau ua. Iale Iesuu kebia hoesegevege keau abuhi tilu. Keate mole Meli Magidaleni Iesuu avuemo munanae toela seveni (7) nunuvenu. ");
INSERT INTO kpx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ige kebiamo koeau abuhi tilu. Kosive mole Elodi ke esemu Tusa. Iale mahinave. Dioana. Ige Susana. Ige emo keate degomole kebiata igaetoai abu monita Iesu isi esemuiabe kebia tedaevegeliho abuhi tilu. ");
INSERT INTO kpx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ata moagaeau o igaegaemo Iesue lohoale mole bevuevei igaemo usege Iesuu dovudovue hoto mole loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Haivei avoe, “Ata moleu au govaea i malei au bulue sesiaho tinu. Au sesievesege degomoleau humahamo keiohovolu. Ige ataeau kemo dasege ugueau degomole ige uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Isege degomoleau munemunemo keiohovoi vakilahai ulisito alumuiabeau dobai tiholige abu gililahalu. ");
INSERT INTO kpx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Isege degomoleau adu bekate ke uvumo keiohovoge adu beikate keau ulisi kebia vavagevelu. ");
INSERT INTO kpx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Isege degomoleau vatae duamo keiohovoale keau ulie dua vai hahuhovoale keu moagataho.” Kateale louge uoholige au namigevei avoe, “La oleteau hoto evimaleau hoto ko evive.” ");
INSERT INTO kpx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ige esemuiabeau belahai avoe, “Dovudovue hoto ke ihuike onole.” ");
INSERT INTO kpx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ige Iesu namigevei avoe, “Di isiviale Dilavau au matamae dogae vamale ke hilokave. Isito ata degomoleau evieviholimale kebiaho di dovudovue hoto louge abu bae ke evisi avuemo lulelelahalivebene. Abuna niavoito bae elehalivebene. Isi evisito bae lulelelahalivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Di dovudovue hoto louale ke ihuu koseanu. Dilava hoto keu govaeae i ke nahate. ");
INSERT INTO kpx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I degomoleau humahamo keiohovoale keau ata degomole nahate. Ata keabuna hotoe dua ke evisege Setenena lohoniege uvuiabemo hotoe dua ke aiohavogei. Ige elike abu hoto ke evi halevalive ukolikoli ma halevai. ");
INSERT INTO kpx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","I degomoleau munemunemo keiohovoale keau ata degomole nahate. Keau hoto ke evisi maleime vahaeholahaito hoto ke ma seleve holioholilu. Iniege vani mole vaveve toelana abuemo lohoge abuna solekavesite hotoe dua ke evioholisi halevai. ");
INSERT INTO kpx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I degomoleau adu bekate uvumo keiolahale keau ata degomole nahate. Ata keau hotoe dua ke evisito vani mole abu vatae vaveve huhulahai kunaita huhulahage vaveve katealeu hotoe dua bamuge evieviabeu negoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Isege i degomoleau vatae duamo keiohovoale keau ata degomole nahate. Ata keau hotoe dua evisi abu uvumo ke huhue dua vai negolahama. Ige evieviabeu balugatahoage abu vaveve dua vama.” ");
INSERT INTO kpx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Atabeu bae lameba hanei mai maua uvumo mamolivebene. Isime mai ladevemale betie valae mamolivebene. Isito auna mai ehanumage ata olemeabuna o keve loholiege abuna atagavemo ui. ");
INSERT INTO kpx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Di hoto louale ke ihuu koseanu. Ataeabuna abu vaveve mahogovage Dilavana bae vaveveabe ke mai umidamo mamoge ataeabuna ke elehai hilokai. Isi vani kela atae vaveve bahatana Dilava atagamo bae velehovoi umidamo ui. ");
INSERT INTO kpx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Iale nenilahai la hoto eviale ke huhulahave. Kosealemo olena di hotomo luleleige Dilavana lulele baluga omisi. Isito ata olena au lulele unahamo hoto ke evisito keho isiviholige Dilavana avuemo luleleve ke mai evihai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu neina isi hohuvuiabe keau isiviai avue lohoi. Isito ataeau moagai nenioholige abu avue lohoveve keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ige ata moleu Iesu namihai avoe, “A neinau a hohuvuhi heie ua. Abu isiviai a elehai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ige Iesuu ata bahata kebia namigevei loui avoe, “Olemeau Dilava hoto evisi vamale keau di neinuvu isi di hohuvu abulike.” ");
INSERT INTO kpx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vani mole Iesuu au esemu ehai boutimo biloluvisege au namigevei avoe, “Lohoge nahi tabu ko houi vaki moleve tai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kateaito halevai tisege Iesuu lahanu. Lahasege heluka balugau lohoge eu boutie uvumo hahosihovoge toelage esemuiabeau loui avoe, “Nahiabuna nova haluvisi.” ");
INSERT INTO kpx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kateai louito lohoale Iesu etuvai loui avoe, “Ei, no Kosive, no aike emo tima.” Ige Iesuu hovelahai eta hanunuta hotogevege hanunuu uoholige eu tolemanu. ");
INSERT INTO kpx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ige Iesuu au esemu namigevei avoe, “Lana la uvu mai daemo mavoholilu.” Kateai abuho louge abu namihaholisito vabulahai tetelahalu. Isi abu moleteho loui avoe, “Malaha oletealeike ko. Kou hanunuta eta hotogevege abu hotove evisi isivive valu.” ");
INSERT INTO kpx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hoto keu uoholige abu boutimo Galili halevai tabu ke vaki mole Gelasene vatae velehovolu. ");
INSERT INTO kpx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Velehovoge Iesuu dobai esagae lamisege tilogoe malaha moleu avue lohonu. Malaha keu vani moaga ogo hatuholisito vava unahata umale malaha. Ata keu oe uoholisito kena vani bahata alue vutae ugei. ");
INSERT INTO kpx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iale malaha keu Iesu elehai baita kekoai lohoale Iesu vudimo holumaime baita namihai avoe, “Iesu, otogoe umale Kosive ke mo, osiohoike a dae lohonu. Di a imihage ainaho bae di aiohavolive.” ");
INSERT INTO kpx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Au louale keu koseanu. Au vasohuta lohoge Iesuu munanae toela keho loui isiviale nunuvage au malaha ke halemai tai. Kosealemo vani moaga munanae toela keu avuemo ui aiohavoma. Auna kateisege ataeabuna adave velove ke seimita umudievei mai omo bamuge auna ke bohisi detitisi botoe tigei. Munanae toelau avuemo uale kemoike au kateale vama. ");
INSERT INTO kpx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ige Iesuu namihai avoe, “A ivilike ole.” Kateige au loui avoe, “Di ivilike Moaga.” Malaha keu louale keu koseanu. Munanae toela moagaeau uvuvemo holoeavolu. ");
INSERT INTO kpx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ilike vage abu Iesu imihai loui avoe, “Ainaho kumoe no hanavegelive.” ");
INSERT INTO kpx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kateaito elehasege ovo degomoleau tanae lovi isi olahama. Ige munanae toela keau Iesu namihai avoe, “No hanavege noeabuna ovoe uvue tai.” Ige Iesuu loui avoe, “Teve.” ");
INSERT INTO kpx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kateai louge munanae toelaeau malaha ke halevai ovoe uvue deluhovolu. Ige ovoeau detuluvisi tialeau seika vuvegevei tabu balugamo biloluvisi e isi haluvilu. ");
INSERT INTO kpx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ige ovo nibievemale keau vaveve ke elehai detuluvisi tialeau humaha tavae ata namigevei tialeau oe ata bahata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ige ata bahataeau vaveve ke elehaho Iesue loholu. Lohoge malaha nehe au munanae toela avuemo nunuveale keu ogoe dua vai tilogoholisito momoleai Iesu veloe heimo ugulamoi ua. Ige abu ke elehai tetelahalu. ");
INSERT INTO kpx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ige vaveve ke elehale keau tilogoe atau momoleale ke deiada loui oe ata haivelu. ");
INSERT INTO kpx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","38","Ige Gelasene ata bahataeau Iesu namihai avoe, “Halei tenela.” Kosealemo keau vabu balugalu. Ige Iesuu boutimo biloai tiho vasege malaha nehe munanae toelau avuemo uoholiale keu Iesu namihai avoe, “Dana aiti tai.” Ige Iesuu keluai loui avoe, “Unela. ");
INSERT INTO kpx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Isi hoilahai talive Dilavau aemo vaveve dua vale ke loui a oe ata bahata haivenela.” Kateige au halei tiale Iesuu vaveve dua avuemo vale ke loui au oe ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ige Iesuu bouti mai e vaki moleve tige ata moagaeau hoesehavoho hemei uma. ");
INSERT INTO kpx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ige Diue dubu nalimale kosive mole Diailosi keu lohoale Iesu veloe heimo kome bokoai vata bisi imihai avoe, “Lohoge nahi di oe tai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Au louale keu koseanu. Mave igaehameu vagana tuelo (12) kemo vavahaniale hatiho vama. Ige Iesuu malaha keti tisege ata moagaeau lohoale evilikahavolu. ");
INSERT INTO kpx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kateisege keate mole vavahanie toela male keu lohoale Iesu ogola holinu. Vavahanive keu koseanu. Vagana tuelo (12) kemo tahoe toelau uvuvemo lohoma. Iale keu dua valiho au moni bahata ata hoesegevemale kebiamo hatuito vavahanive keu sohu avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iale keate keu ata moaga uvumo lohoaleu Iesu iae ogove ivila holinu. Ige solekavesite tahoe toelau avuemo lohomale keu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ige Iesuu loui avoe, “Oleike daela holinu.” Ige ata bahataeau loui avoe, “No hilokaholilu.” Ige esemuve mole Bitau loui avoe, “Kosive, ata moagatahoeau a evilikahavoale kemo nahi oleve kateai bae hilokai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ige Iesuu loui avoe, “Di ata hoesegevemale vuvuneu daemo uoholige di hilokage ata moleu daela holinu.” ");
INSERT INTO kpx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ige keate keu huhuige Iesuu vaveveve ke hilokanu. Isi teteai lohoale Iesu veloe heimo dobai holumai ata bahatae nimo au deiada loui Iesu namihai avoe, “Di lohoale a ogola holige di vavahani keu uoholi seleveanu.” ");
INSERT INTO kpx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kateai louge Iesuu avuho loui avoe, “Di ma, a a uvu bahata mai daemo mamoike vage vavahani keu aemo uoholinu. Iale vahaehomo tenela.” ");
INSERT INTO kpx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kateai lousege Diailosi esemu moleu lohoale Diailosi namihai avoe, “A mau aike hatiale ainaho kosive keho louge au loholive.” ");
INSERT INTO kpx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Isito Iesuu hoto ke evisi Diailosi namihai avoe, “Vabu hale. Ana a uvu mai daemo mamoge a mana bae hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ige abu tialeu oe velehovoge Iesuu louge ataeau oe uvue tioholilu. Isito Iesu, Bita, Dioni, Diemisi isi ma ke neinave isi mamave kebia unahaeau o ke uvue tilu. ");
INSERT INTO kpx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","O ke uvue tisege ata bahataeau o kemo uale keau ma keho ninalahama. Ige Iesuu loui avoe, “Ninalaha halevave. Ma keu hatioholisito lahaike au ke vanu.” ");
INSERT INTO kpx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kateai louge abu bituhavoi hehavolu. Kosealemo abu hilokage ma keu hati seleveanu. ");
INSERT INTO kpx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Isito Iesuu ma ke adala holisi loui avoe, “Maia, hovelahanela.” ");
INSERT INTO kpx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kateai louge ma ke munanau hoilahai lohoge au solekavesite hovelahanu. Ige Iesuu kebia namigevei avoe, “Lovi mai omige au isi.” ");
INSERT INTO kpx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kateige mamave isi neinave keau ke elehai tetelahalu. Ige Iesu abuho loui avoe, “Lainaho di vale ko loui ata namigevelive.” ");
INSERT INTO kpx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Vani mole Iesuu au esemu tuelo (12) hohavege abu lohoale igaetoasege au munanae toela nunuveveve vuvune ovei vavahanitebia hoesegeveveve vuvune keta ovenu. ");
INSERT INTO kpx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Isime hanavei loui avoe, “Talive ataeau Dilava adae vuvunemo uveve hoto ke loui ata haivei vavahaniamale kebia hoesegeveve.” ");
INSERT INTO kpx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Isi tota loui avoe, “La tiliege lainaho onobehame malelive. Mesoho bedoea, mogamoga, lovi, moni, dabae ogo lainaho bae kateale malelive. ");
INSERT INTO kpx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","La o moleve tiliege ata moleu la malevei o hatuevege avuluvuta ovemo uve. Ilive la tiho valiege bae o ke halevai teve. ");
INSERT INTO kpx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Isito ata degomoleau laheho isiviholisi la malevei o hatueveholige o ke halevai anakaeabemo la veloe gogea sesilahave. Ige abuna la vaveve ke elehai kemo huhuai kosea, ‘Dilavana no aiogevei.’” ");
INSERT INTO kpx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kateai hoto ke lougeto esemuiabeau halevai tialeau o igaegaela ata haivei tilu. Tiale hotoe dua loui ata haivei vavahanite kebia hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kateimalela Galilie kosive baluga Elodiu Iesu vaveve ke bahata evisi dolodoloanu. Kosealemo ata degomoleau loui avoe, “Mesoho ata babatisogevemale Dioniu hatiale keike tota hovelahanu.” ");
INSERT INTO kpx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Isege degomoleau loui avoe, “Mesoho Ilaidiau hovelahanu.” Isege degomoleau loui avoe, “Mesoho subuta beloveta moleu hovelahanu.” ");
INSERT INTO kpx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Isito Elodiu loui avoe, “Di louge abu Dioni eno etulelu. Isito ata ole igaeike vaveve ko vama.” Isi katealemo vani baita isiviai ata ke elehai. ");
INSERT INTO kpx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu abostoloeau hoidevei lohoale abu vamale ke bahata loui Iesu namihalu. Ige Iesuu kebia holoevege abu unahaeau o mole Betesaidae tilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Keve tisege ata moagau ke evisi ehovei tilu. Ehovege Iesuu itumuholisito kebia hoesegevei ataeau Dilava adae vuvunemo uveve hoto ke loui haivei vavahanitebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iniale vau dobasege Iesu esemu tuelo (12) keau lohoale Iesu namihai avoe, “Ata kobia iovege abu tai. Loviu uvesite matamaike ko. Iale abu talive bulue lovi malei abu oe ladevei.” ");
INSERT INTO kpx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kateai louge Iesuu namigevei loui avoe, “La biaeau lovi ovege abu isi.” Ige abu namihai avoe, “Noeau valava ada mole isi huena abuita unahahameike ko. Iale a huhuige noeabuna oleve kateai lovi moaga ata kobiaho malei.” ");
INSERT INTO kpx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kosealemoike abu hoto ke loulu. Malaha bahata keve uale keau moagataho vai taoseni (5,000). Ige Iesuu au esemu namigevei avoe, “Bahata namigevege abu vivti (50) vivtiai uguiavoi tai.” ");
INSERT INTO kpx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ige esemuiabeau ke nahate loui ata namigevege ataeau ugulelevai lotilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ige Iesuu valava ada mole isi huena abuita nehe ke malei otogoe niai ke hoesehavoi vakoinata malei au esemu ovege abu malei ata kebia igaegaeai ovei lotilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ige ata ke bahataeau lovi ige uniabeau hanilahalu. Ige Iesu esemuiau lovie sigu ke iuhai malei basiketi tuelomo (12) udage ililoholu. ");
INSERT INTO kpx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vani mole Iesu ahuvela Dilava imihasege esemuiabeau avue lohoge au abuho loui avoe, “Ataeau huhuige dau ole.” ");
INSERT INTO kpx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ige abu loui avoe, “Ata degomoleau a mai loui avoe, ‘Ata babatisogevemale Dioni keike ke.’ Isege degomoleau a mai loui avoe, ‘Ilaidiaike ke.’ Isege degomoleau a mai loui avoe, ‘Subuta beloveta moleu hatiale munanave keike ke.’” ");
INSERT INTO kpx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ige Iesuu loui avoe, “Isege laeau huhuige dau ole.” Ige Bitau avuho loui avoe, “A keu Keliso. Dilavau a hanavoale ke ailike.” ");
INSERT INTO kpx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kateai louge Iesuu isuta namigevei avoe, “Lainaho bae ke loui ata namigevelive. ");
INSERT INTO kpx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atae Esena bae vatetumu baluga malei. Oe kosive, dubu nalimale kosive baluga isi Diue menaka loui haivemale ata keabuna bae kabebihavoi hamage auna hatisito vanie ni abuita igaetaeau uoholisege auna tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesuu namigevei avoe, “La oleu daiti tiho vaniege au lako au isivi va halei au vatehani maleveve ke huhu haleito vani bahata di ehomagei. ");
INSERT INTO kpx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iale olena au ebika unaha huhuaniege au bae ukolikoli malivebene. Isito olena au ebika huhuholisito di ivimo vatehani malei hatiniege auna ukolikoli mai. ");
INSERT INTO kpx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Isi olena vatae onobenobemo kunaite holisito Dilavaemo au uvu mamoholisito hatiniege auna oleve kateai ukolikoli mai. ");
INSERT INTO kpx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Isime oleuoleu di mati vai di hoto ke louliho isiviholige dana bae di lohomale kela di atagamo, di Mamae atagamo, anelu tumute atagamo lohoniege data ata kebia matigevei. ");
INSERT INTO kpx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iale seleveta di la namigevege evive. La degomoleau kove uale keau bae haluvilivebene. Isito ataeau Dilava adae vuvunemo uveve ke elehaito bae haluvisi. ");
INSERT INTO kpx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesuu kateale louito bula igaeu uoholige au Bita, Dioni, isi Diemisi kebia holoevei abuhi tana mole balugae guliguliho tilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Keve tiale guliguliasege Iesu ni keu nimoleanu. Ige ogoveu tae seleveanu. ");
INSERT INTO kpx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ige ihunivesite Moseseu Ilaidiati avuluvuta hotohotoima. ");
INSERT INTO kpx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Keau lohoale vavaeabe keu levolevoai ua. Keau Iesuluvuta au Dielusalemae hativeve hoto ke louma. Isi avoe, “A hativeve keu Dilava isivilike.” ");
INSERT INTO kpx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kateisege Bita isi haokuvuiabe keau ladeveale hovedevei Iesu ataga elehage malaha mole abuitaeau avuluvuta lavisi ua. ");
INSERT INTO kpx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iniale malaha abuita keau Iesu halevai tisege Bitau Iesu namihai avoe, “Kosive, hoeseike no vai kove loholu. Iale noeabuna la nenita oe ese abuita igaeta houevei. Ilive elike moleu ahoe. Moleu Moseseho. Isege moleu Ilaidiaho.” Keu hoto ke louito luleleholinu. ");
INSERT INTO kpx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kateai lousege goeu dobai lohoale bamuevege Iesu esemuiau vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ige goe kemo hoto moleu lohoale loui avoe, “Di moike ke. Dailike ke ebagemanu. Iale hotove evive.” ");
INSERT INTO kpx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hoto keu kateai uoholige Iesu igaeu lamisi ua. Ige Iesu esemuiau vani moaga abu elehale ke loui ata namigeveholilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Vavita abu tana ke halevai lohosege ata moagatahoeau Iesuluvuta belehovolu. ");
INSERT INTO kpx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ige ata moagataho kebia vigomo malaha mole igaeu hovelahai baita Iesu hohavoi avoe, “No haivemale ata, di di mo igae mai lohoge elehanela. ");
INSERT INTO kpx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vani igaegae munanae toelana avuemo lohosege auna dobai kekoai teteisege aivemo sabavena hahosihovogei. Vani moaga munanae toela kena kateai di mo ko aiohavogei. ");
INSERT INTO kpx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ige di a esemu kebia namigevege abu di mo hoesehavoveve keu abuemo anekianu.” ");
INSERT INTO kpx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kateai louge Iesuu abuho loui avoe, “La uvu keau tolobe nimolealemoike la evieviholilu. Iale la huhuige dana vali vani moaga lahehi ui laheho loviai.” Kateai abuho louito malaha ke namihai avoe, “A mo mai kove loho.” ");
INSERT INTO kpx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ige au mo mai lohosege munanae toelau move aiohavoge moveu dobai vatamo tobilakanu. Ige niveu vealuvilu. Kateisege Iesuu munanae toela iomai mo ke hoesehavoge au dua vanu. Ige Iesuu mai mamave ominu. ");
INSERT INTO kpx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ige ata bahataeau Dilava vuvune ke elehai vikolahalu. Isime Iesuu onolenole vamale ke huhulahai Iesu hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Iesuu tota au esemuho loui avoe, “Di aike hoto ko louge evive. Ataeabuna Atae Ese mai ata degomole ovege abuna hamage hatai.” ");
INSERT INTO kpx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kateigeto Iesu esemuiau hoto ke evisito Dilavau huhuihuhuiabe bamualemo ke ihu hilokaholilu. Abu isiviai Iesu belahai. Isito vabulahalemo belahaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iniale abu mole belagevei avoe, “Iesuna nahiemo ole ebagemage auna kosive baluga holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kateisege Iesuu huhuihuhuiabe hilokaime ese mole ese mai lohoale au vavamo mamonu. ");
INSERT INTO kpx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Isi abuho loui avoe, “Olena di ivimo ese ko nahate mai o hatui hoesehavoniege daike au ke hoesehavonu. Isi Dilavau di hanavoale keta hoesehavonu. Iale la oleu au ebika etolemai eseese vaveve nahate vale kena bae kosive baluga holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ige Dioniu loui avoe, “No kosive, no malaha mole elehasege keu a ivimo munanae toela nunuvema. Ige no namihai kosea, ‘Halenela.’ Kosealemo keu a esemu holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ige Iesuu abuho loui avoe, “Lainaho kelualive. Ata oleu kateale vale keu nahie aiogeveholisito nahie tedaeveike au ke vama.” ");
INSERT INTO kpx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesuu ehue tiveve vani keu vuguvuguanu. Ige au tiveve ke huhuaito halei Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isi au esemu degomole hanavege abu ulila tiale Samalia ata namigevege abu Iesu hoesehavoho bevuai hemei uliho. ");
INSERT INTO kpx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Isito o ke biaeau isiviholilu Iesuu loholive abuhi uliho. Kosealemo abu hilokage Iesu keu Dielusalemae tima. ");
INSERT INTO kpx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kateige Diemisi isi Dioni keau ke evisi Iesu namihai avoe, “Kosive, ana isiviage no Dilava imihage au vene hanavoge otogomo dobai lohoi ata kebia aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kateai louge Iesuu hoilahai keluevei namigevei avoe, “Lainaho kateale valive.” ");
INSERT INTO kpx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kateai louito abuhi halevai o moleve tilu. ");
INSERT INTO kpx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Abu tiale humaha tavae tisege malaha moleu lohoale Iesu namihai avoe, “Ana oleve keve tige dana aiti tai.” ");
INSERT INTO kpx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ige Iesuu avuho loui avoe, “Seleveta ana isiviale daiti tai. Ovoeabuna abu aeamamo ladevegei. Ige uguiabuna abu hanidamo ladevegei. Isito Atae Eseu lahaveve o keu uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kateai louito malaha mole namihai avoe, “Di ehomanela.” Isito malaha keu loui avoe, “Kosive, usege di vasohuta talive di mamau hatiale ke mai guliaito bae lohoi a ehomai.” ");
INSERT INTO kpx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ige Iesu loui avoe, “Halege nahi tisege haluviveve keau bae mole malevei gulievei. Isito lohoge nahi talive ataeau Dilava adae vuvunemo uveve hoto ke loui haivei.” ");
INSERT INTO kpx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Isege ata moleu Iesu namihai avoe, “Kosive, dana aiti tai. Iale di isiviai vasohuta talive di ese elegeveito bae lohoi.” ");
INSERT INTO kpx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ige Iesuu avuho loui avoe, “Oleuoleu di lovi kemo inuta tioholisito hoilahai au iae niale keu bae ataeau Dilava adae vuvunemo uveve hoto ke loui ata haivevevemo negoalivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iesuu vaveve kateale vage uoholige ke iae au esemu seveniti (70) malevei isiviale abuibuiai hanavege keau vasohuta talive o bahata keve ata haivesege Iesuu bae gabie ehovei tai. ");
INSERT INTO kpx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Isi namigevei avoe, “Lovi moagaeau baelahalu. Isito lovi ke malei valahumo otoveveve ataeau moagaholilu. Iale bulu ke biageho guliguliage au lovi ke malei otoveveve ata hanavege abu lovive bahata malei otovei.” ");
INSERT INTO kpx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Isi tota loui avoe, “La keau mamoe ese nahate. Tobalu kebia vigomo di la hanavema. ");
INSERT INTO kpx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","La tiho valiege lainaho moni, mogamoga isi tamakata matagevelive. Isi humahala tiliege atahi belehovoi abuhi nona halevave. ");
INSERT INTO kpx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Talive la o oletemo biloluviliege o kebia ata hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ige abu la hoto evige la kebia hoesegeveale hoto abuho louale kena abuemo vuvuneai. Isito mesoho abu la hoto evioholige la kebia hoesegeveale keu bae abuemo vuvunealivebene. ");
INSERT INTO kpx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Abu la hoto mage lainaho bae o degomolebiatala vealuvilive. Isito o ke igae uvumo uve. Isime abu lovi onole laovege ke ive. Kosealemo la di lovi vale ke ibinahoike abu ke lovi laovelu. ");
INSERT INTO kpx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","La o oleve keve tige ataeau la hoesegevei lovi laovege ke ive. ");
INSERT INTO kpx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Isi o kemo ata vavahaniteau uge kebia hoesegeveve. Isi namigevei kosea, ‘Ataeau Dilava adae vuvunemo uveve vaniu aike lohoma.’ ");
INSERT INTO kpx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Isito la o oleve keve tige abu la hoesegeveholige halevai talive o ke ivila lavisi bae abuho louve. ");
INSERT INTO kpx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Namigevei loui kosea, ‘La oe vatau no veloe votomo uale ko noeabuna tota la omo sesilahai. Iale ko elehai huhulahave. Ataeau Dilava adae vuvunemo uveve hoto no mai lohoge la avuho isiviholilu.’ ");
INSERT INTO kpx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iale kemo di la namigevei. Dilava kotae vaniu lohoge au vata ko aiohavomale vanila keabuna bae vatehani malei. Subuta Sodoma ataeau maleale keu eseve. Isito keabuna bae vatehani baluga seleve malei.” ");
INSERT INTO kpx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kolasini ata la nohovu. Isi Betesaida ata la nohovu. Vatehani balugana bae laemo lohoi. Kosealemo di laemo vikoe vaveve moaga vaevege la ke elehaito la vaveve toelamo hoideveholilu. Subuta Taea isi Saidoni keve di vaveve kateale vatebene abu ogo bukate hatui uti hohuvai uvulahai abu vaveve toela halevalu. Isito laeau kateholilu. ");
INSERT INTO kpx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Iale Dilavana au kotae vanila vatehani baluga laoveito Taea isi Saidoni ata kebia vatehani eseve ovei. ");
INSERT INTO kpx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Isi Kabenumu ataea, di laheho louge evive. La keau isiviale la ebia tabagevei malei otogoe otovei. Isito di la namigevei. La keabuna veneu lahai hodovavesite keve tihatuve.” ");
INSERT INTO kpx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kateai louito au esemu namigevei avoe, “Olete abuna la hoto eviliege abuna di hotota evisi. Isito olete abuna la hoto hamaliege abuna di hotota hamai. Isi olete abuna di hoto hamaliege keabuna di hanavoale ke hotota hamai.” ");
INSERT INTO kpx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iniale vani mole ata bahata seveniti (70) keau vahaeho balugata hoidevei lohoale Iesuho loui avoe, “No Kosive, no a ivimo munanae toela kebia namigevege abu no hoto evilu.” ");
INSERT INTO kpx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hoto kateale louge Iesuu namigevei avoe, “La vaveve kateale vage di elehage hatau nivolekale ke nahate Setene vuvuneu solekavesite uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Di hoto evive. Di nego mai laovenu. Iale la bahoe Setene ke vuvuneu bae laemo negoalivebene. Iale la utee toela isi haeho kebiamo dage abu bae la uagevelivebene. Ige vaveve toelabeu bae la aiogevelivebene. ");
INSERT INTO kpx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lainaho munanae toelaeau la hoto eviale kemo vahaehoalive. Isito otogoe la iviu uale kemo bae vahaeholahave.” ");
INSERT INTO kpx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kateimale vanila Munana Tumuteu Iesu mai vahaehotige au vahaeho baluganu. Isi loui avoe, “Di Mama, au otogota vatata Kosive. A a lulele malei luleleholiale kebia ovenu. Isito vatae ataeau abu ebika tabagevei kemo luleleage a lulele malei kebia oveholinu. Di Mama, a kateale vale keu a isivilike. Katealemo di a hoesehavoma.” ");
INSERT INTO kpx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kateai louito ata namigevei avoe, “Di Mamau onobenobe bahata daonu. Ige ataeau Moveta Mamaveta hilokaholilu. Isito Mamave igaeike au Mo hiloka seleveanu. Ige Move igaeike au Mama hiloka seleveai isivive ata tabagevei lulele ovege abu Mamave hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hoto kateale louge uoholige au esemu unahaho loui avoe, “Laeau hoeselahalu. Kosealemo onobenobe bahata di vamale ke la elehalu. ");
INSERT INTO kpx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Isito di la namigevege evive. Subuta beloveta isi vatae kosive keau isiviale la elehale ke nahate elehai. Isito abu elehaholilu. Isi abu isiviale la eviale ke nahate abuta evisi. Isito abu ke eviholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kateige menaka haivemale malaha moleu hovelahai isiviale Iesu lobohavoi. Isi namihai avoe, “No haivemale ata, dana onole vai bae ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ige Iesuu namihai avoe, “Bukae Hotou hisaiale kemo a hoto oleteale dodavenu.” ");
INSERT INTO kpx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ige malaha keu namihai avoe, “A uvu bahata, a isivi bahata, a nego bahata, isi a lulele bahata malei a Kosive baluga Dilava omisi hoesehavonela. Isi a a ebika hoesehavoale ke nahate a haokuvu kebiata isivi ovei hoesegevenela.” ");
INSERT INTO kpx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ige Iesuu avuho loui avoe, “A hoto keu inutolotoloale ke nahate vaime bae ukolikoli manela.” ");
INSERT INTO kpx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ige malaha keu ata tedaeveliho isiviholialelua Iesu hoto ke evisi loui avoe, “Di haokaike ole.” ");
INSERT INTO kpx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ige Iesuu malaha ke namihai loui avoe, “Malaha moleu Dielusalema halei Dielikoe tisege laskoloe ataeau humaha tavae evudei ogove dikohai hamai ehalovage au nibedai lahai ua. ");
INSERT INTO kpx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lahai usege Diue dubu nalimale ata moleu humaha nehe kela tiniale malaha nehe abu hamai mai humaha vavae ehalovale ke elehai aehai halei tinu. ");
INSERT INTO kpx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ige Livai malaha moleu humaha nehe ke igaela tinu. Keve tiniale malaha nehe ke elehaito aehai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ige Samalia ata moleu humaha kela tinu. Malaha keu Diue ata holioholinu. Isito keu tiale malaha nehe ke elehai avuho uvuanu. ");
INSERT INTO kpx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Isime tiale abu hamale ke ohe hoesegevei mulamulai vilianu. Isi malaha ke ebagemai mai au ovoe golomo mamoi avuti tiliale ladevemale o moleve tilu. Isi vavi kemo hoesehavoi avuti ua. ");
INSERT INTO kpx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iniale vavita hovelahai mune bai baluga malei o ke nalimale malaha omisi namihai avoe, ‘Ko mai malaha ke nalisi hoesehavonela. Ilive vani mole di tota hoilahai loholive a avuemo vaesute hatuale ke dana bae tota aoi.’” ");
INSERT INTO kpx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Deiada kateale louge uoholige au malaha ke namihai avoe, “A huhuige malaha abuita igaeta kebia vigomo oleteu abu malaha nehe hamale keti haokanu.” ");
INSERT INTO kpx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ige malaha keu Iesu namihai avoe, “Avuho uvuai hoesehavoale ata ke.” Ige Iesuu avuho loui avoe, “Seleveike. Iale ata talive ke nahate vanela.” ");
INSERT INTO kpx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesuu hoto kateale louge uoholige au esemu holoevei tialeau keate mole ivi Mata ke oe tige au malevei o hatuevenu. ");
INSERT INTO kpx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Isege hohove Meli keu o kemo ua. Iale Iesuu hoto lousege hohoveu velove heimo ugulamoi ui hotove ke gaeahavoma. ");
INSERT INTO kpx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Isege Matau ahuvela lovi vanata Meliho itumuai lohoaleu Iesu namihai avoe, “Kosive, a huhuige di hohou di tedahoholisito keve ugulamoi uge kena duave. Ana vali iomage au loholive di tedahoi.” ");
INSERT INTO kpx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kateai louge Iesuu namihai avoe, “Mata, a keu unie hani huhu baluganu. Isi a kemo huhuihuhuibe ni mole vanu. ");
INSERT INTO kpx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Isito di hotoe dua eviveve keu baluga. Iale Meliu vaveve keho isiviai vanu. Iale atabeu bae vaveve ke avuemo malivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vani mole Iesuu matama moleve tiniale au Mama imihaniale uoholisege esemuve moleu avuho loui avoe, “Kosive, guliguliaveve humaha no haive. Dioniu au esemu haiveale ke nahate ata no haivenela.” ");
INSERT INTO kpx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ige Iesuu abuho loui avoe, “Noinoi ko nahate louve. No Mama, no isiviale ata bahataeau a ivie tumu hoesehavogei. Ilive a matamae dogau lohoge duave. ");
INSERT INTO kpx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Isi vani igaegaela no isivie lovi ke noevegenela. ");
INSERT INTO kpx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ige ata oleteau noemo vaveve toela vage no vaveveabe toela ke huhuoholige ata no vaveve toela ulihai huhuoholi. Isi ainaho no halevesege no Setene lobomo dobuluvilive.” ");
INSERT INTO kpx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Guligulie hoto ke loui haiveito kemo hoto mole abuho lounu. Isi loui avoe, “Mesoho la moleu vavie minamo au haoka oe tiniege namihai kosea, ‘Aemo lovibe abuita igaetaeau uge daonela. ");
INSERT INTO kpx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Di haoka moleu oai lohoale di oe velemanu. Ige daemo lovibehameu uoholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ige mesoho auna aho loui kosea, ‘Ainaho di nita huegelive. Di udaha bamui di ese holoevei abuhi aike ladevema. Iale di bae hovelahai lovibe aolivebene.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A haokana hoto kateale louge ana osioi. Isito di laheho louge evive. A haokave holialemo au bae hovelahai lovi aolivebene. Isito ana matiholisito negobedai udahavemo hamai imihalage auna bae lovi aoi. ");
INSERT INTO kpx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Iale di laheho louge evive. Lana Dilava imihage auna la isivi ke laovei. Isi lana ono mole kaovaliege bae mave. Isi lana udaha hamage auna bae laheho alavoi. ");
INSERT INTO kpx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kosealemo oleuoleu onoleho Dilava imihage auna isiviabe ke ovei. Isi oleuoleu ono mole kaovale ke abuna mai. Isi oleuoleu udaha hamage auna abuho alavoi. ");
INSERT INTO kpx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","La olena eseveu huenaho imihage auna vali ute mai omisi. ");
INSERT INTO kpx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Isi mesoho auna ugue uniho isiviage auna vali haeho mai omisi. Ba, keu anekianu. Lana isiviabe mai oveve. ");
INSERT INTO kpx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Laeau vaveve toela vamale ataea. Isito laeau la ese kebia hoesegevei isiviabe ke oveveve ke hilokalu. Iale ke nahate lana la Mamau otogoe umale ke imihage auna la vaveve evihai Munana Tumute laovei.” ");
INSERT INTO kpx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesuu malaha mole uvute kemo munanae toela nunuvanu. Munanae toela keu avuemo uge keu hotoholinu. Isito munanae toelau uoholige malaha keu bae hotoai hoto louge ataeau ke elehai vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Isito ata degomoleau ke elehai loui avoe, “Munanae toelae kosive Biesabolo ke vuvunemoike Iesuu munanae toela kebia nunuvema.” ");
INSERT INTO kpx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ige ata degomoleau lobohavoi namihai avoe, “Bato, vavevebe negote otogomo vanela. Ige no bae ke elehai hilokai kosea, ‘Dilavaike a hanavonu.’” ");
INSERT INTO kpx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kateai lousege Iesuu huhuihuhuiabe hilokaime abuho loui avoe, “Vata igaemo ataeau mole tasalievei molehi mole haveliege abu bae ui egealivebene. Isi valada igaeau mole tasalievei molehi mole haveliege abu bae ui egealivebene. Abuna katelahaliege solekai uoholisi. ");
INSERT INTO kpx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iale ke nahate Setene ataeabuna mole tasalievei molehi mole haveliege abuna oleve kateai. Keu anekianu. La loui kosea, ‘Seteneike au vuvune daoge di munanae toela kebia nunuvema.’ Isito di ke vuvunemo kebia nunuveholima. ");
INSERT INTO kpx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Dana kateai Setene vuvunemo munanae toela nunuvege la esemu abuna ole vuvunemo munanae toela kebia nunuvei. Iale lana la esemu belagevege abuna loui kosea, ‘Dilava vuvunemoike no kebia nunuvema.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ige data Dilava vuvunemoike munanae toela kebia nunuvema. Kateige lana ke elehai hilokage Dilava matamae doga ke vuvuneu laemo lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ata negotena au soe mai bi mai au o nibige ove kunai keabuna ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Isito ata negote selevena lohoniege ovemo velemai hamai soeveta biveta malei ove kunai malei tai. Dovudovue hoto kemo la hilokage di negoai Setene aiohavoi atave nunuvema. ");
INSERT INTO kpx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Iale ata oleuoleu di tedahoholimale keau di aiohavomale ataeabulike. Isi oleuoleu ata maleveveve kemo di tedahoholiale keau ata kebia nunuvema.” ");
INSERT INTO kpx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Di hoto mole louge evive. Munanae toelana ata mole halei tiniege eu uvesiteve uveve matama kaovai. Isito uveve matamabeu uoholige auna huhuai kosea, ‘Dana hoilahai di subuta uale kemo ui.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kateaime hoilahai lohoniege ata nehe ke elehage au au uvu hoesehavoge onobenobe toelau avuemo uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ige auna tota hoilahai tiniege munanae toela seveniau (7) vuvune balugale kebia holoevei abuhi lohoniege ata nehe kemo deluhovoi. Ige ata kena toela seleveai. Kosealemo subuta munanae toela igaeu avuemo ua. Isito gabie munanae toela eiti (8) keau avuemo ua.” ");
INSERT INTO kpx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesuu kateai louge keate moleu ata moaga kebia vigomo hovelahai Iesuho loui avoe, “A mamoi a amumale keate ke vahaehou baluga.” ");
INSERT INTO kpx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ige Iesuu avuho loui avoe, “Ito. Isito ataeau Dilava hoto evilike vaime vahaeho balugatahoalu.” ");
INSERT INTO kpx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ige ataeau bahata mole bevuevei igaetoai Iesu evilikahavosege Iesuu namigevei avoe, “Novae ata la koeau atae toelaea. La di belahai isiviale di vikoe vaveve vai. Isito di bae la louale ke valivebene. Isito dana beloveta mole Dionau vale ke nahate dana data vai. ");
INSERT INTO kpx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Subuta beloveta Dionau vani abuita igaeta huena baluga uvue uge Niniva ataeau ke elehai hilokage Dilavau Diona hanavonu. Ige novae vani komo Atae Esena ataemo vaveve ke nahate vai. ");
INSERT INTO kpx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Iale Dilava kotae vani kela vata mole kuini Siba kena hovelahai la vaveve toela ke laemo loui. Keate keu haeavamoleve Solomoniu luleleai ata haivemale ke elehaho lohonu. Isito di louge evive. Ata moleu Solomoni ke evihale keike ko la vigomo ua. Isito laeau hotove evioholilu. ");
INSERT INTO kpx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Iale vani kela Niniva ata kebiataeabuna bae hovedevei la vaveve toela ke laemo loui. Kosealemo Dionau kebia haivege abu evisi abu vaveve toela halevalu. Isito di hoto ko louge evive. Ata moleu Diona ke evihale keike ko la vigomo ua. Isito laeau hotove evioholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Atabeu bae lameba hanei mai batabatae valae mahogovalivebene. Isito auna hanei mai batabata golomo mamoge elike ataeau oe uvue loholive atagavemo ui. ");
INSERT INTO kpx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","La ni keau la vavamo lameba nahate. La nina dua vage la uvuna atagai. Isito la niabuna toelage la uvuna loai. ");
INSERT INTO kpx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iale huhutumuave. Onoilage atagau la uvumo uale keu loama. ");
INSERT INTO kpx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Isito la uvu bahatamo atagau uge behameu bae loalivebene. Isito lamebau atagale ke nahate auna ataga seleveai ui.” ");
INSERT INTO kpx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesuu hoto kateale louge uoholige Balisia ata moleu namihai isiviale au avuti lovi isi. Ige Iesuu ove uvue tiniale avuti ugulamoi lovi inu. ");
INSERT INTO kpx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Keu ada totoholisito avuti lovi ige Balisia ata keu ke elehai vikoanu. ");
INSERT INTO kpx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ige Iesuu avuho loui avoe, “Balisia ata la vaveve keau abu melegita kabutae vava totoaito uvuve totoholiale ke nahate. Ataeau la vava elehage keu duave. Isito la uvu kemo huhuihuhuie toela moagaeau uge la mole kunaiho isivilahama. ");
INSERT INTO kpx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","La keau Dilava vaveve kemo luleleholilu. Dilavau isiviale la la uvuta la vavata hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Iale la uvuu duavealemo lana kunaiholimale kebia tedaevege la vavevena duaveai. ");
INSERT INTO kpx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Isito lana kateholige Balisia ata, la nohovu. Laeau la bulue lovi ke bahatamo taidi vaito ata hoesegeveholisi Dilava huhuoholilu. La taidi vale keu duave. Isito ata hoesegeveholisi Dilavata huhuoholiale keu toelanu. ");
INSERT INTO kpx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Iale Balisia ata la nohovu. La keau isivialeike dubue uvue talive vomue duamo uguiavogei. Isi isivialeike talive ata moagaeau umale keve olahai tige abu la elegevei la hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iale la nohovu. La keau alue vuta nahate. Ataeau golovela tai lohoito hilokaholilu. Abu huhuai kosea, ‘Mesoho matama duaike ko.’ Isito vata ke uvue ataeau sakavaleike ua.” ");
INSERT INTO kpx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kateai louge Diue menaka loui haivemale ata moleu lamisi avuho loui avoe, “Kosive, a hoto kateale louale keu notaike a ke aiogevenu.” ");
INSERT INTO kpx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ige Iesuu loui avoe, “Menaka haivemale lata la nohovu. Laeau la menaka moaga loui ata haivema. La kebia haiveito tedaeveholige abu unaha ke vage keu abuemo isuanu. ");
INSERT INTO kpx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iale la nohovu. Subuta la buluveau Dilava beloveta haveale kebia vuta laeau nova kaeagevei huhuai kosea, ‘No beloveta kebia hoesegevema.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","La vaveve kateimalemoike la buluvehi mole nahate. Kosealemo la buluveau beloveta kebia havege haluvilu. Ige la kebia vuta kaeagevei hoesegeveale kemo la la buluvehi huhuihuhui igaealu. ");
INSERT INTO kpx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Katealemo Dilavau subuta au lulelemo hoto mole lounu. Isi avoe, ‘Dana beloveta isi di hoto loumale ata degomole hanavege abuna ata kebia haiveho tige ataeabuna degomole havei degomole aiogevege abuna vatetumu malei.’ ");
INSERT INTO kpx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dilavau hoto kateale loualelua novae atate abuna vatehani malei. Kosealemo Dilavau vata vasege ke iae la buluveau beloveta moagamoaga havelu. Ige laeau la buluvehi vaveve igaealu. ");
INSERT INTO kpx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abu vasohuta Eibolo hamalu. Isi kemo lavisi beloveta havei loholata gabivela Sekalaia hamalu. Ke abu dubuta mune vitaleta vigo hamage au hatinu. Iale di la namigevei. Katealemo Dilavana vatetumu baluga novae atate la kebia ovei. ");
INSERT INTO kpx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Iale menaka haivemale ata la nohovu. La lulele umuka mahogovai ataemo hoto seleve vovoholu. Katealemoike la isiviholilu Dilava hoto eviliho. Isime ata bamuevei isiviholilu abu Dilava hoto eviliho.” ");
INSERT INTO kpx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Kateai louito halei tisege Diue menaka loui haivemale isi Balisia ata keau itumulahai Iesu lobohavoi isiviale au hotoeabe kemo dobage abu mai hamai. ");
INSERT INTO kpx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Abu katelahasege ata moagataho seleve keau lohoale molemo neniholisi molemo dai loholu. Ige Iesuu vasohuta au esemu namigevei avoe, “Balisia ata kebia nibieve dua vave. Kebia vavau duave. Isito uvuiabe keau toelalu. Katealemo kebia nibieve tumuave. ");
INSERT INTO kpx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abu vaveve toela vai mahogovamale keabuna bae umidamo ui. Ige abu hotoe toela loui mahogovamale kebiataeabuna bae umidamo ui. ");
INSERT INTO kpx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iale la onole vavimo mahogovai loumale ke ataeabuna bae vanimo evisi. Isi oe uvue mulumuluamale keta abuna bae ologomo holahai baita louge ata bahataeabuna evisi.” ");
INSERT INTO kpx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Di haokuvuia, di laheho louge evive. Lainaho ata havemale kebia vabugevelive. Keabuna vava unaha haveito abu bae munana havelivebene. ");
INSERT INTO kpx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Isito di la haivei. Dilava igae vabuhavove. Auna au vuvunemo ata havei malevei veneu lahai hodovavesite keve hatuevei. ");
INSERT INTO kpx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Isito au bae laemo kateale valivebene. Laeau Dilava nimo baluga. Abu ugue ese ada mole malevei voievege ibinaeabena benie kina abuita. Keu ibina baluga holioholinu. Isito Dilavau kebia igaegae nibievema. Isi keu la igaegae kinaenumu ke bahata dodavei hilokaevenu. Iale lainaho vabulahagelive. Ugueau Dilava nimo eseve. Isito laeau nivemo baluga.” ");
INSERT INTO kpx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Di la namigevege evive. Oleuoleu atae vigomo loui kosea, ‘Dau Iesu ata dailike ko.’ Ige dana data Dilava anelu kebia vudimo loui kosea, ‘Keu di atalike.’ ");
INSERT INTO kpx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Isito oleuoleu atae vigomo loui kosea, ‘Dau Iesu ke hilokaholinu.’ Ige dana data Dilava anelu kebia vudimo loui kosea, ‘Di ata ke hilokaholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Iale oleuoleu hotoe toela loui di aiohavoge Dilavana toelave ke ulihai. Isito oleuoleu hotoe toela loui Munana Tumute ke aiohavoge Dilavau bae toelave ke ulihalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ige abu la malevei dubue kosive biae kotaho tige lainaho gasigasiai vabulahalive. Isi mesoho abu la malevei gamanie kosivemo kotaho tige lainaho la hoto louveve ke huhulahalive. ");
INSERT INTO kpx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kosealemo vani kela Munana Tumutena bae la hoto louveve ke la haivege bae louve.” ");
INSERT INTO kpx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Au kateai loui au esemu namigevesege ata moaga kebia vigomo ata moleu hoai loui avoe, “Kosive, no mamau hatialelua di nana namihage au di mamae kunai tasaliai degomole daoi.” ");
INSERT INTO kpx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ige Iesuu namihai loui avoe, “Ba, di bae la avutie vaveve ke kaovai kunai ke tasalialivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kateai louito namigevei avoe, “Loboe vaveve vamale kebiamo la ebika nenigeveve. Lainaho kunai kebia huhueve moagalive. Kosealemo lana la kunai moaga huhueveliege bae uveve dua seleve valivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iesuu hoto ke loui kemo dovudovue hoto mole loui haivei avoe, “Malaha mole kunai moagate ke vatau duave. Iale keu kemo lovi haevege lovive bahata keau holoeavo dua valu. ");
INSERT INTO kpx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iale malaha ke valahuu tobalohoge keu huhuai avoe, ‘Dana onole vai. Dana oleve kateai di lovi otovei.’ ");
INSERT INTO kpx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Isi huhuai avoe, ‘Di koseige duave. Di di valahu kobia koievei balugataho unaha houevei. Ilive elike kebiamo di lovi di kunai otovege abu dua vai. ");
INSERT INTO kpx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dana kateale vaniege di ebia hoesehavoi ue dua vai. Ilive vagana moaga kemo teigeve unaha isi vahaehoai ugei.’ ");
INSERT INTO kpx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Malaha keu vaveve kateale huhuisege Dilavau avuho loui avoe, ‘A keu luleleholinu. Iale ana novae vavi komo hatinela. Isege ataeabuna bae a lovi nehe bevuevei otovemale ke bahata malei.’” ");
INSERT INTO kpx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesuu hoto kateale louito ke ihu loui ata namigevei avoe, “Oleuoleu Dilava kunai huhuholisito vatae kunai huhulahai abu omo otovemale keau malaha nehe ke nahate.” ");
INSERT INTO kpx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesuu kateai louito au esemu namigevei avoe, “Katealemoike di laheho loui kosea, ‘Lainaho la iveve isi ogo vaveve kebia huhu balugagelive.’ ");
INSERT INTO kpx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kosealemo nahie uveve keu lovi iveve ke evihanu. Isi la uveve keu ogo hatueveve keta evihanu. ");
INSERT INTO kpx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ugu kebia elegeveve. Keau bululahai valahu houi avuemo lovi lovoi otoveholima. Isito Dilavau kebia nibievei lovi ovema. Iale laeau kebia evigeveale kemo Dilavana la tedaeve dua vai. ");
INSERT INTO kpx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","La oleu au uveve ke huhu moaganiege auna oleve kateai au uveve vagana ke mai egetisi. Katealiveu anekianu. ");
INSERT INTO kpx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Vaveve esehame keu laemo anekiasege la osiohoike onobenobe kebia huhueve moagama. ");
INSERT INTO kpx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Isi botoe valavalaeau ulimale vaveveabe kebia elegeveve. Keau lovilahai ogo vaeveholima. Isito di la namigevege evive. Solomoni keu kunai moagate. Isi keu ogoe dua vama. Isito ogove dua keau valavalae dua kebia evigeveholilu. Iale Dilavau kaeagevei nibieve dua vamale kemo la hilokage auna lata nibieve dua vai. ");
INSERT INTO kpx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Valavala keabuna nova uito nivu tutukai gililahage ataeabuna bevuevei mahoevege keabuna uoholisi. Isito Dilavau gadegevei nalieveale ke nahate auna la nalievei ogo laovei. Seleveta auna laheho kateale vai. Isito la evievi keu esevehameanu. ");
INSERT INTO kpx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Iale lainaho lovita eta iveve kemo huhu moagagelive. ");
INSERT INTO kpx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Evieviholimale ata keabulike vatae onobenobe huhu moagama. Isito la Mamau otogoe umale keu laemo onoleu uoholiale ke hilokanu. Iale auna ke laovei. ");
INSERT INTO kpx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iale lana vasohuta Dilava matamae doga ke humaha kaovai isivive vage auna onobenobe kebia bahata laovei. ");
INSERT INTO kpx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Iale di esea, lainaho vabulahalive. Laeau moaga holioholilu. Isito Dilavau au isivimo la hoesegeveale laeabuna bae adave vuvunemo uve. ");
INSERT INTO kpx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Iale la kunai ke malei voievei moni ke malei kunaiholimale kebia oveve. Lana kateale vage otogoe la mogamogana tobalohoi ui. Ige keve la kunaina balugage ataeau bae vavoloalivebene. Isege segeleu bae bohilivebene. ");
INSERT INTO kpx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iale vani bahata la kunaiu umale keve la uvuna ugei.” ");
INSERT INTO kpx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Di hoto mole louge evive. Esemuiau abu ogo vai abu lameba hanei abu kosive hemei umale ke nahate la vaveve hoesegevei la kosive hemei uve. Kosealemo kosiveabeu abu mole holoeveale keve tiale hoilahai lohoma. Iale auna lohoniege udaha hamage abuna solekavesite avuho udaha alavoi. ");
INSERT INTO kpx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Esemuiabe keau abu vaveve gadehavoi nita hemei ualemo kosiabe kena lohoniege velemai elegevege abuna vahaeholahai. Ige kosiveabena namigevege abuna uguiavosege auna au ogo vukai tiniege abuho vasiai ovege abuna isi. ");
INSERT INTO kpx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mesoho auna vavie vigomo o vae alalamita lohoge esemuiabe keabuna nita uliege elehai vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Katealemo ko huhulahave. Mesoho oe biageu vavoloe atau lohoveve vani ke auna hilokai nita uniege vavoloe ata keu bae ovemo vavoloalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iale lata nita uve. Kosealemo Atae Eseu lohoveve vani ke lana hilokaholisege auna bae lohoi.” ");
INSERT INTO kpx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Au kateai louge Bitau namihai loui avoe, “Kosive, ana no unahahoike ke louma. Emena ata kobiatahoike a ke louma.” ");
INSERT INTO kpx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ige Iesuu avuho loui avoe, “Oleuoleu evievi ata holisi kemo lulelelahale kebiahoike di ke lounu. Iale balugavena abuho louge abuna ove ke nalisi bae esemu degomoleta nalievei lovi ovegei. ");
INSERT INTO kpx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Isege kosivevena tiniege tota hoilahai lohoniege esemuveu lovie dua vale ke elehai vahaehove vai. ");
INSERT INTO kpx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iale seleveta di la namigevema. Kosivevena au esemu ke ebagemage kena kunaive bahata nalievei. ");
INSERT INTO kpx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Isito kosivevena haeavamole tige esemuvena huhuai kosea, ‘Keu bae solekai loholivebene.’ Isi kateai au kosive esemu degomole havei lovi baluga isi e toela ige kinavena luleleholisi. ");
INSERT INTO kpx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Iniege vani mole kosiveveu lohoveve ke hilokaholisege auna lohoniege esemu ke elehai hamai lovive kemo iomage auna tiniege evievi ata holioholiale kebiahi ui. ");
INSERT INTO kpx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Keu kosive ke isivi hilokanu. Isito isiviholinu ke valiho. Katealemo auna bae vatehani baluga malei. ");
INSERT INTO kpx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Isito esemu olena au kosive isivi hilokaholisito vaveve toela vaniege auna vatehani esehame malei. Kosealemo Dilavau lulele isi vuvune baluga ata olete bia oveime isiviale keau abuta kemo lovi baluga vai. Isito lulele isi vuvune eseve ata olete bia oveime isiviale keau kemo lovi eseve vai.” ");
INSERT INTO kpx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesuu tota loui avoe, “Dana lohoniege vata ko mahoi aiohavoi. Isito di isiviale aike vene ke beige au lahai. ");
INSERT INTO kpx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gabie dana babatiso ni molete vai. Iale di isiviale vatehani ke solekai mage au uoholisi. ");
INSERT INTO kpx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Iale la huhuige ataeau molehi ue dua valihonike di vatae lohonu. Ba, di kateho lohoholinu. Isito ataeau mole tasalievehoike di kove lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iale novae vani komo ese bahata ada mole keabuna mole tasalievei. Abuita igaeta keabuna ivi mole. Isege abuita keabuna ivi mole. Moleabuna di ata holisege moleabuna di aiohavoi. ");
INSERT INTO kpx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iale mamuvu abuna abu ese aiogevesege eseabe abuna abuta abu mamuvu aiogevesege neinuvu abuna abu ese aiogevesege eseabe abuna abuta abu neinuvu aiogevei. Isege maivu abuna abu maivu aiogevesege maivuabe abuna abuta abu maivu aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesuu kateai au esemuho louito ata bahata namigevei avoe, “La vaveve keu koseanu. Lana vaniu dobamale keve elehage goeu lohoge lana loui kosea, ‘Venina lohoi.’ Ige auna lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Isi lana elehage helukana seloeatae lohoge lana loui kosea, ‘Vanina vuvuneai.’ Ige auna vuvuneai. ");
INSERT INTO kpx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Isito laeau loboe ataea. La vata elehai otogo elehai lulelelahalu. Isito laeau aike laemo lohoveve ke hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Osiohoike laeau la ebika hoesegevei vaveve dua kaovaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iale mesoho malaha moleu isiviale la malevei kotaho tige vasohuta avuti igaetoai la vaveve ke kaovai hoesehavove. Iale lana kateale vaholige la bahoena la malevei kotamale atae tai. Ige kotae ata kena la malevei bukate ovege abuna la malevei dibulae hanavei. ");
INSERT INTO kpx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iale di la namigevei. Laeabuna dibulae uliege ke ibina vahatugeto abuna bae la iovei.” ");
INSERT INTO kpx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kateimale vanila ata degomoleau deiada mole loui Iesu namihalu. Deiada keu koseanu. Vani mole Galili ata degomoleau ovo havei mahoi Dilava hoesehavosege gamanie kosive Bailoti esemuiau ata kebia havege abu haluvilu. ");
INSERT INTO kpx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ige Iesuu deiada ke evisi namigevei avoe, “La huhuige kosive keu kebia haveale vaveveabe toela kena Galili ata degomole kebia toela evigevenu. ");
INSERT INTO kpx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ba, di la namigevei. La huhuige keau vaveve toela vamale ataea. Isito laeau mole nahate. Lana la vaveve toela halevaholiliege lana lata haluvive. ");
INSERT INTO kpx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ige subuta Dielusalemae o mole egetana ivi Salomu keu bokolahai dobai ata eitini (18) havege abu haluvilu. Iale la huhuige haluviale keau Dielusalema ata degomolebia vaveve toela evigevelu. ");
INSERT INTO kpx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ba, di la namigevei. Mesoho lana la vaveve toela halevaholiliege lana lata haluvive.” ");
INSERT INTO kpx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesuu kateai louito kemo dovudovue hoto mole loui haivei avoe, “Malaha mole bulue uvumo idi mole ivi vigi keu kemo laminu. Iale malaha keu tiale idi ke adamo niage baioholinu. ");
INSERT INTO kpx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ige au bulumo loviamale ke namihai loui avoe, ‘Vagana abuita igaeta di idi ko adamo niage keu baioholinu. Iale heinela. Keu vata komo lamisito hahumaholige keu toelanu. Idi keu uoholige mole duana kove ulisi.’ ");
INSERT INTO kpx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ige esemuve keu namihai avoe, ‘Kosive, halege au vagana ko igaemo ui. Isege di bae vata bisi momoluta bisi malei umukave omisi. ");
INSERT INTO kpx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ige au gabie vaganamo baiage keu duave. Isito au baioholige nahi bae heisi.’” ");
INSERT INTO kpx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iesuu hoto kateale tovetove lounu. Iniale bula molemo tiniale Diue dubue ata haivema. ");
INSERT INTO kpx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Isege dubu ke uvue keate mole munanae toelau avuemo biloale keu keve ua. Vagana eitini (18) ke uvumo munanae toela keu keate keti uale vavahaniage inuveu keukanu. Ige au inuta lamiholisito holumai oima. ");
INSERT INTO kpx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ige Iesuu keate ke elehai hohavoi avoe, “Ei, nova a vavahani keu aemo uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Isi au ada mai tatavemo mamoge solekavesite inuve nehe keu inutolotoloige au inuta lamisi Dilava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Keate keu kateige dubue kosive keu itumuanu. Kosealemo Iesuu bulamo keate ke hoesehavonu. Ige kosive keu ata namigevei loui avoe, “Vanie ni bahata ada mole isi igae ke uvumo nahi lovilahai dubue loholive vavahanite kebia hoesegevegei. Isito bulamo vavahanite kebia hoesegeve halevave.” ");
INSERT INTO kpx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kateai louge Iesuu avuho loui avoe, “Loboe ataea. Ataeau la vaveve elehage duave. Isito la uvu keu toelanu. Iale di louge evive. La keau bulala la ovo vavegevei malei ebavae e oveho timale kemo la ovo kebia hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Isito la isiviholialeike di bulamo Ebalahamu valada ko hoesehavoliho. Setene keu vagana eitini (18) ke uvumo keate ko aiohavoge keu toelai ua. Iale la huhuige dana bulamo hoesehavoge kena duave.” ");
INSERT INTO kpx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kateai louge aiohavomale ataeau matilahalu. Isege ata bahataeau Iesuu vaveve dua vamale ke elehai vahaeholahalu. ");
INSERT INTO kpx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ige Iesuu kebia namigevei avoe, “Ataeau Dilava adae vuvunemo uveve kemo dana dovudovue hoto oleteale louge lana bae kemo lulelelahave. ");
INSERT INTO kpx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ataeau Dilava adae uvumo uveve keu masitae i nahate. Masita ke iu esevehame. Isito lana ke sesilahage kena ulisi balugage uguiabuna loholiege adavemo hasolahai. Iale ataeau Dilava adae vuvunemo ui moagatahoai ue dua vaveve keu kateanu.” ");
INSERT INTO kpx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesuu tota hoto mole abuho lounu. Avoe, “Dana oleve kateai ataeau Dilava adae vuvunemo uveve ke laheho loui. Keu beikini bauda ke nahate. ");
INSERT INTO kpx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Keateabuna beikini bauda ke mai valavamo keiohai ebuehage kena valava ke mai balugatisi. Iale ataeau Dilava adae uvumo ui moagaveve keu ke nahate.” ");
INSERT INTO kpx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesuu kateai louito halevei Dielusalemae tinu. Isi keve timale humaha tavae o igaegaela ata haivei tima. ");
INSERT INTO kpx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ata haivei tisege ata mole igaeu avuho loui avoe, “Kosive, ata moagavesite unahaeabuna otogoe tai.” ");
INSERT INTO kpx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ige Iesuu ata bahata namigevei avoe, “Otogoe udaha keu esevehame. Ialelua negolahalive udaha kela velehovoi teve. Ata moagaeabuna isivilahai o ke uvue tai. Isito kena abuemo anekiai. ");
INSERT INTO kpx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Kosealemo o ke biagena hovelahai udaha ke bamui. Ige lana tiliege iave lavisi udaha hamihamiai loui kosea, ‘Kosive, noheho udaha alavo.’ Ige o ke biagena laheho loui kosea, ‘Di la hilokaeveholinu. La oleve keveike loholu.’ ");
INSERT INTO kpx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ige lana hotove ibina vai loui kosea, ‘Ba, noeau subuta aluvuta lovi isi e imale ata noeabulike ko. Isi no oe a no haivemale ata noeabulike ko.’ ");
INSERT INTO kpx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ige oe biagena tota loui kosea, ‘Di la namigevei. Di la hilokaeveholinu. La oleveike loholu. Laeau atae toela unaha. Iale tai di haliove.’ ");
INSERT INTO kpx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kena kateai laheho louge lana udahae iae ui uvulahai ninalahaime bae monomo hediavogei. Kosealemo Ebalahamu, Diekobo, Aisiki isi beloveta bahata keau Dilava matamae doga keve usegeto laeabuna heie uve. ");
INSERT INTO kpx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Isege vaniu velemai dobamale keve isi vaki mole isi vaki mole keve ataeabuna loholiege Dilava matamae doga keve igaetoai uguiavoi lovi isi. ");
INSERT INTO kpx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ige kateimale vanila uli holiale keabuna gabi holisi. Isege gabi holiale keabuna uli holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iesuu kateale louniale uoholisege Balisia ata degomoleau lohoale avuho loui avoe, “O ko halei matama moleve tenela. Kosealemo gamani kosive Elodiu isiviale ahamoi.” ");
INSERT INTO kpx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ige Iesuu namigevei avoe, “Malaha keu ata lobogevemale mi mole veleki ke nahate. Iale talive ke namihai loui kosea, ‘Dau nova nivu vavahanite kebia hoesegevei degomolemo munanae toelau umale kebia nunuvema. Iale alamege dana Dielusalemae velemasege di lovi kona uoholisi.’ ");
INSERT INTO kpx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iale dana nova tai nivu tai alamege velemai. Kosealemo abu subuta Dielusalemae Dilava ata moaga havemale kemo Dilavau isiviale di talive Dielusalemae abu dahavoge di hatai. ");
INSERT INTO kpx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Iei, Dielusalema ata la nohovu. Dilavau au hoto louveve beloveta laheho hanavege la muneta kebia havege abu haluvilu. Vani moaga di isiviale la malevei di adae uvumo otovei. Kokoluguu au ese bevuevei goloeabemo amuleale ke nahate. Isito laeau daho isiviholilu. ");
INSERT INTO kpx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","La katealemo gabie la o kena samiai uoholisi. Iale di la namigevege evive. La bae tota di elehalivebene. Isito lana la vaveve toelamo hoidevei loui kosea, ‘No Kosiveu Dilava ivimo lohoi no hoesegevenu.’ Lana kateai louliege bae tota di elehave.” ");
INSERT INTO kpx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Bula molemo Iesuu tiniale Balisia kosive mole oe avuti lovi isege malaha mole adaveu veloveti uvu balugaleu Iesue lohosege ataeau nibi tumutumuama. ");
INSERT INTO kpx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ige Iesuu menakae kosive isi Balisiae ata kebia belagevei avoe, “La huhuige nahie menaka kemo nahiabuna valive bulamo vavahanite kebia hoesegevei. Emena osioi.” ");
INSERT INTO kpx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kateai louge abu hotobe louholilu. Ige Iesuu malaha ke mai hoesehavoge vavahaniveu uoholige iomage tinu. ");
INSERT INTO kpx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Isege au bae namigevei avoe, “La esebeu o la ovobeu bulamo abata vuvehage lana vali osioi. Lana solekai ke laluvave.” ");
INSERT INTO kpx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kateai louge kosive keau hotove ibina louveve humahau uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesuu kateaito elehasege lovi iliho lohoale keau isiviale ata ivite kebia nahate vai vomue duamo uguiavoi. Ige Iesuu ke elehai hoto koseale abuho lounu. ");
INSERT INTO kpx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Avoe, “Mesoho malaha moleu au mae ibina vaveve kemo la namigevege lainaho talive vomue duamo uguiavolive. ");
INSERT INTO kpx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Isito mesoho la kemo uguiavosege oe biagena kosive mole baluga melamei lohoniege laheho loui kosea, ‘Evihasege kosive kou a lovomo ugumai.’ Kateige lana matilahai bae heie matamae toelamo uguiavove. ");
INSERT INTO kpx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lainaho katealive. Isito oe biageu laheho ionage talive heie matamae toelamo uguiavove. Isege oe biageu bae laheho loui kosea, ‘Di haoka, hovelahai ehue matamae dua kove uguma.’ Lana vaveve kateale vage ataeabuna la elegevege lana ata baluga holive. ");
INSERT INTO kpx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iale oleu au ebika ebagemale ke Dilavana etolemai. Isito oleu au ebika etolemale ke Dilavana ebagemai.” ");
INSERT INTO kpx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesuu hoto kateale loui ata namigevege uoholige au avuti lovi iale ke namihai loui avoe, “A iveve baluga vaniege ainaho bae a haokuvu, a deholuvu isi kunai moagate kebia hohavelive. Kosealemo ana kateale vage keabuna gabie abuta kateale valiege a hohavoi. ");
INSERT INTO kpx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Isito a iveve baluga vaniege kunaiholimale, velo toelate isi ni kedute kebia hohavenela. ");
INSERT INTO kpx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ana kateai lovi kebia ovege keau bae a lovi ke ibina vai aovalivebene. Ige kemo ana vahaehoanela. Kosealemo gabie Dilava nimo vaveve dua vamale keau hovedevemale vanila Dilavana bae ibinae dua aoi.” ");
INSERT INTO kpx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesuu kateai louge malaha moleu keve ugulamoi lovi iniale hoto ke evisi avuho loui avoe, “Ata olena Dilava matamae dogae tiniege avuti lovi iniege auna vahaehoai.” ");
INSERT INTO kpx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ige Iesuu deiada mole loui namihai avoe, “Malaha moleu lovi baluga vai au haokuvuho ionanu. ");
INSERT INTO kpx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iniale lovi vamale vani kela au esemu namihai avoe, ‘Talive di haokuvu namigevei kosea, Di lovi vage uoholialelua lohove.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ige esemuve keu tiale haokuvuiabe bahata namigevenu. Ige keau bahata isiviholilu loholiho. Moleu namihai avoe, ‘Iei, di vata mole voiale dana tiniege elehai. Iale talive a kosive namihai kosea, Keu katealemoike lohoholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ige moleu esemuve ke namihai loui avoe, ‘Di ovo bahata ada mole isi ada mole voievenu. Iale dana aike tiniege kebia elegevei. Iale talive a kosive namihai kosea, Keu katealemoike lohoholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ige moleu esemuve namihai avoe, ‘Di aike di mahina melamenu. Katealemo di bae talivebene.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ige esemuveu hoilahai tiale hoto ke bahata loui au kosive namihage kosive keu ke evisi itumuai au esemu hanavoi avuho loui avoe, ‘Solekai talive humahae do, humahae ese kebiala velo golote, ni kedute, isi kunaiholimale kebia holoevei lohonela.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ige esemuve keu tiale ata kebia holoevei lohoale kosive ke namihai avoe, ‘Di a louale ke vage uoholinu. Isito a o kou gigioholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ige au tota namihai avoe, ‘Talive botoe ata namigevei holoevei lohonela. Ige di o kou elike tobalohoi. ");
INSERT INTO kpx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Seleveta di a namihai. A vasohuta namigeveale keau bae di lovi ko ilivebene.’” ");
INSERT INTO kpx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Vani mole Iesuu tige ata moagatahoeau ehovai avuluvuta tilu. Ige au hoilahai abuho lounu. ");
INSERT INTO kpx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Isi avoe, “Oleuoleu vasohuta di ehovaho valiege abu lako abu ebia huhuevelive. Isi abu mamuvu, abu neinuvu, abu mahinuvu, abu ese, abu hohuvu, abu mahoho, abu mohoho huhuevelive. ");
INSERT INTO kpx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Oleuoleu di ehovai vatehani maleale keau di esemu selevea. Isito oleuoleu di ehovai vatehani maleho isiviholiale keabuna oleve kateai di ata holisi. ");
INSERT INTO kpx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mesoho malaha moleu isiviai o houliho vaniege auna vasohuta ugumai onobenobe voieveve ke ibina huhuai hisalievei. Isiviai hilokage monive kena vali onobenobe bahata malege au gabiai. ");
INSERT INTO kpx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Isito auna onobenobe ke ibina hilokaholisito vasohuta o houniege auna hade unaha uluvei golovemo ilada unaha detisito o houholige ataeabuna ke elehai hehavoi. ");
INSERT INTO kpx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Abuna loui kosea, ‘Malaha keu au o houito houi gabioholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ke nahate mesoho vatae kosive moleu au esemu teni taoseni (10,000) holoevei vatae kosive mole isi esemuiabe tueniti taoseni (20,000) kebiahi mole haveho vaniege vasohuta auna huhuai kosea, ‘Dana vali negoalive kosive ke isi esemuiabe kebia havei nunuvei.’ ");
INSERT INTO kpx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Isito auna huhuige avuemo anekiage auna au esemu hanavege abu vasohuta tiliege kosive nehe keu haeavamole lohosege abuna namihai kosea, ‘No kosiveu isiviale nahi mole have halevaito igaetoai molehi ue dua vai.’” ");
INSERT INTO kpx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iesuu deiada kateale louito abuho loui avoe, “Ke nahate la di ehovaho valiege vasohuta la onobenobe vaveve ke huhu halevaito bae di ehovave.” ");
INSERT INTO kpx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Madea keu duave. Isito auna toelage hevena uoholige auna oleve kateai bae tota heai. Keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Madea keu toelage lana ke mai mihatuve. Iale ata laeau madea ke nahate. La Dilava hotoe dua evisito la vaveve kena ataemo toelage lana oleve kateai bae tota duave holisi. Iale oleuoleu hoto evimaleau hoto ko evive.” ");
INSERT INTO kpx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vani mole takesi malemale ata moaga isi atae toela degomole keau Iesu hoto eviliho loholu. ");
INSERT INTO kpx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ige Balisia ata isi Diue menaka loui haivemale kosive keau ke elehai loui avoe, “Ata keu vaveve toelaike au vaime atae toela kebiahi igaetoai lovi inu.” ");
INSERT INTO kpx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kateai louge Iesuu abuho hoto koseale lounu. ");
INSERT INTO kpx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Avoe, “Mesoho la moleu mamoe bahata uani handele (100) maleniege igaeu detitisi tebuige auna osioi. Auna mamoe moaga kebia halevei igae ke kaovanata ke elehai. ");
INSERT INTO kpx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Auna ke elehai vahaehoai. Isime ke ebagemai mai au begomo mamoi ebamoi tai. ");
INSERT INTO kpx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Isi auna ke ebamoi hoilahai au oe tiniege au haokuvu namigevei kosea, ‘Di ovo nehe detitiale ke di kaovanata elehai mai lohonu. Iale lohoge nahi igaetoai vahaeholahai.’” ");
INSERT INTO kpx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iesuu deiada kateale louito namigevei avoe, “Iale ke nahate atae dua nainti naini (99) keau detuluviholisito vaveve dua unaha vage otogoe aneluabuna vahaeholahai. Isito ata igaena vaveve toela vaniege kemo hoilahai Dilava ehomage otogoe aneluabuna vahaeho balugalahai. ");
INSERT INTO kpx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Isi mesoho keate moleu kina vahate teni (10) maleale kemo igae ehalomaniege auna ke osiohavoi. Auna lameba hanei atagavemo o hamai vahate ke kaovai. Auna oe uvu bahata kemo kaovae dua vaniege elehai mai. ");
INSERT INTO kpx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ke maniege au haokuvu hohavege abu igaetoai usege auna namigevei kosea, ‘Di vahate ehalomale ke kaovanata elehai vahaehoanu. Iale nahi bahata vahaeholahai.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Di louale ke nahate atabena au vaveve toela halei Dilava ehomage Dilava aneluabuna ke elehai vahaeho balugai.” ");
INSERT INTO kpx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesuu hoto kateale louge uoholige tota au deiada mole loui Balisia ata kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Isi loui avoe, “Malaha mole move abuitaeau uale debukaveu au mama namihai avoe, ‘A kunai tasalievei daho molete daonela.’ Kateai au mama namihage mamaveu kunai ke tasaliai nanaveho mole omisi avuho mole ominu. ");
INSERT INTO kpx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ige hohoveu uniale vani mole au kunai nehe ke ataemo voievei moni malei au mamae o halei haeavamoleve tiale keve vaveve toela moaga vai kemo au moni hatuhatunu. ");
INSERT INTO kpx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Isime keve au moni hatui gabianu. Iniale vata keve vae balugau lohoge mo keu kunai holioholi seleveanu. ");
INSERT INTO kpx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Isi tiale malaha moleu ovo ovemale ke namihage au louge au bae avuemo loviai ovove kebia lovi ovema. ");
INSERT INTO kpx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ataeau lovi omioholige mo keu kemo vaeta loviai isiviale ovoe lovie vate ke isi. ");
INSERT INTO kpx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kateinata bae au uvumo huhuai avoe, ‘Di mamae esemu bahata keabuna abu isiviamale ke ige uniabe abuna hanilahagei. Isito dau kove ui vaeai vaeho hatima. ");
INSERT INTO kpx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iale di hovelahai talive di mama namihai loui kosea, Mamai, dau Dilava nimo vaveve toela vai a ivi keta aiohavonu. ");
INSERT INTO kpx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iale ainaho dahoe loui kosea, Di mo. Isito daho loui kosea, Di esemu.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kateai huhuai bae hoilahai haeavamole au mamae oe tinu. Isege mamaveu moveu tiale humaha kemo niai uniale moveu humaha kela haeavamolela lohosege ke elehage ninanau uvuve hamage au ke elehai bibuai tiale au mo evudei ulikukuhavonu. ");
INSERT INTO kpx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ige moveu loui avoe, ‘Mamai, dau Dilava nimo vaveve toela vai a ivi keta aiohavonu. Iale ainaho bae daho loui kosea, Di mo.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kateai louge mamaveu au esemu namigevei avoe, ‘Solekai ogoe dua mai avuemo holovave. Isi lini mai adavemo hatui tamakata mai velovemo hatuve. ");
INSERT INTO kpx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Isi talive ovo mole batate hamai mai lohove. Ige nahi lovive vai vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kosealemo di mo kou hatiale nahate vanata nova ua. Kou subuta nahehi uoholinu. Isito aike nahi tota elehalu.’ Hoto kateale louge uoholige abu lovive valu. ");
INSERT INTO kpx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Abu ke vasege mo ke nanau bulue uniale hoilahai oe vavae lohoi evisege abu sale hamai havulahama. ");
INSERT INTO kpx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ige au au esemu mole belahai avoe, ‘Abu osioma.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ige esemuve keu namihai avoe, ‘A hohou ue dua vanata nova hoilahai lohoike vage a mamau ke elehaike vaime ovo mole batate hamai lovive vama.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ige au hoto ke evisi itumu balugai oe taliho isiviholinu. Ige mamaveu bae lohoale sovavihai namihai avoe, ‘Lohonela.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ige au au mama namihai avoe, ‘Di hoto louge evinela. Vagana ko moagamo di a tedahoi lovi baluga vanu. Isi di vani bahata a hoto evie dua vama. Isito au vagana ke bahata uvumo vavevebe dua dahoe vaholinu. Isi ovobe ese mai daoge di haokuvuhi lovibe vai ioholinu. ");
INSERT INTO kpx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Isito a mo keu tiale teibae keatehi oai abuemo a moni hatueveniale hoilahai lohoge au ovo batate hamai lovive vanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ige mamaveu avuho loui avoe, ‘Di mo, au vani baita daiti ua. Ige di kunai bahata keau a onoeabulikea. ");
INSERT INTO kpx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Isito nahi vahaeholahage keu duave. Kosealemo a hoho keu tiale hatiale nahate vanata nova nita ua. Keu subuta nahie halevei tinu. Isito aike hoilahai lohoge nahi elehalu.’” ");
INSERT INTO kpx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesuu tota au esemu namigevei avoe, “Malaha mole kunai moagate keu esemu mole mage au avuemo loviai monive ke vavoloima. Ilage ata moleu lohoale kosive ke namihanu. ");
INSERT INTO kpx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ige kosiveveu hohavoge au lohoge au namihai avoe, ‘A osioma. Di evige a di vavohama. Iale a di vavohale ke bahata hisaliai daonela. Kosealemo a bae tota daemo lovialivebene.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ige esemu keu huhuai avoe, ‘Di kosivena di halege dana osioi. Di heie lovi kemo negoholinu. Isi di moniho ata imigeveliho matianu.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Isi kemo huhuai avoe, ‘Di kosivena di halege dana vaveve onole vai atahi haokuvuage abu elike di mai o hatui.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Isi kateai ata degomole hohavege abu loholu. Ata keau subuta kosive kemo kunai baluga malei bukinialu. Iale esemu keu ata igaegae namigevei avoe, ‘A kunai vaesute di kosivemo malenu.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ige moleu loui avoe, ‘Dau olive oele botolo uani handele (100) bukiniai malenu.’ Kateai louge esemu keu namihai avoe, ‘Halege nahi lobohavoi handele (100) haleito vivti (50) loui.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Isi halei malaha mole namihai avoe, ‘Isege a. A vaesute di kosivemo bukiniai malenu.’ Ige au loui avoe, ‘Di laisu baeki uani handele (100) maleito ibinave vaholinu.’ Ige esemu keu loui avoe, ‘Halege nahi lobohavoi handele (100) haleito eiti (80) loui.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kateige kosive keu ke evisi loui avoe, ‘Di esemu keu lulelete ata.’” Iesuu deiada kateale louito ihuve keta lounu. Isi avoe, “Vatae ata keau abu haokuvuhi igaetoai vaveve kemo lulele balugalu. Isito atagae ata keau kemo luleleholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tota namigevei loui avoe, “Evive. La moni la kunai kemo atahi haokuvulahai oveve. Kateige la moniu uoholige kosivena ehue la malevei o hatuevei. ");
INSERT INTO kpx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Olena vaveve ese kemo inutolotoloaniege auna vaveve baluga ketamo inutolotoloai. Isito olena vaveve ese kemo loboaniege auna vaveve baluga ketamo loboai. ");
INSERT INTO kpx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iale lana vatae kunai kemo lobolahaliege oleve kateai bae otogoe kunai seleve malei. ");
INSERT INTO kpx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Isi lana la haokuvu kunai ke neniai hoesehavoholiliege oleve kateai bae la ebiaho kunai malei. ");
INSERT INTO kpx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Esemubeu bae kosive abuiho lovialivebene. Auna kateaniege mole isivi omisi mole kabebihavoi. Isi mesoho moleho neniai loviaito moleho neniai lovialivebene. Iale ke nahate la bae Dilavata monita igaetoai ehovalivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Iesuu kateai louge Balisia ataeau abu uvu mai monimo mavoale keau ke evisi kabebihavoi Iesu hehavolu. ");
INSERT INTO kpx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ige Iesuu abuho loui avoe, “Laeau la ebika tabagevege ataeau la elegevei loui avoe, ‘Keau ata duaea.’ Isito Dilavau la uvu hilokanu. La vaveve kateale vage ataeabuna la hoesegevei. Isito Dilava nimo vaveve katealeu mesiae hisi ke nahate. ");
INSERT INTO kpx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moseseu menaka hisaliage belovetata hisaliale hoto ke ataeau subuta ehovalu. Isito Dioniu lohoaleu ataeau Dilava adae vuvunemo uveve hotoe dua ke loui ata haivege ataeau aike molehi tavala isiviale solekai Kosive adae vuvunemo uliho tai. ");
INSERT INTO kpx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dilavau menaka ke bahata loui mamoge keu ua. Iale vatana otogoti uoholisege menaka ke behameu bae uoholilivebene. ");
INSERT INTO kpx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Malaha molena au mahina halei keate mole melameniege au keate ke vavamoike au ke vavoloanu. Isege malaha molena malaha ke keate melameniege malahave ke vavamoike au ke vavoloanu.” ");
INSERT INTO kpx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesuu hoto kateale louito deiada moleta lounu. Isi avoe, “Vani mole malaha mole kunai moagate keu ogoe dua ibina balugate hatui lovi baluga isi ua. ");
INSERT INTO kpx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Isege malaha mole kunai vesite ivive Lasolo keu ata kubite. Iale abuna ke melavei loholiege kunai moagate ke udahamo mavogei. ");
INSERT INTO kpx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ige kena kemo ugei. Isivialeike kunai moagate ke lovie sigu igei. Kateai kemo usege toeabuna loholiege kubive ke tevegei. ");
INSERT INTO kpx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Iniale malaha keu hatige aneluiau lohoale munanave mai Ebalahamu uale otogo keve tilu. Isege kunai moagate malaha keta hatige ataeau mai abavulu. ");
INSERT INTO kpx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ige malaha ke munanau veneu hodovavesiteve vatehani baluga malenu. Isi hovelahai niai elehage haeavamolela Lasolou Ebalahamu vavamo ua. ");
INSERT INTO kpx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ige au Ebalahamu hohavoi avoe, ‘Di mama, ana valive daho uvuai di tedahoi. Di vene komo uale vatehani baluga malenu. Iale Lasolo hanavoge au loholive au adae viso mai emo manemei mai di nememo mamoge auna seliai.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kateai louge Ebalahamuu namihai avoe, ‘Di mo, ana huhuanu. Au vatae umale vani kemo au kunaie dua unaha malenu. Isege Lasolo eu kunaie dua maleholinu. Isito Lasolou aike vahaehomo usege au vatetumu malema. ");
INSERT INTO kpx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Di hoto mole louge evinela. Seika baluga nahie vigomo uale no bae oleve kateai ae tai. Isege ata oleve kateai bae noe lohoi. Kateaveveu anekianu.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ige kunai moagate keu loui avoe, ‘Di mama, kateaito di isiviai a imihai. Lasolo hanavoge au di mamae oe tai. ");
INSERT INTO kpx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Keve talive di hohuvu ada mole haivege abu vatehani malemale matama kove loho halevai.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ige Ebalahamuu loui avoe, ‘Mosese hoto isi belovetae hoto keau ua. Iale a hohuvu abuna hotoeabe ke eviliege humahae duala tai.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ige malaha keu Ebalahamu namihai avoe, ‘Di mama, abu bae hoto ke evilivebene. Isito ata mole hatiale kena abue tige abuna hotove evisi abu vaveve toelamo hoidevei.’ ");
INSERT INTO kpx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ige Ebalahamuu loui avoe, ‘Abu Mosese hoto isi belovetae hoto eviholiliege abu bae atau hatai hovelahale ke hoto evilivebene.’” ");
INSERT INTO kpx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesuu deiada ke louge uoholige au esemu namigevei loui avoe, “Vani bahata vaveve toelau ataemo velemama. Isito olena louge ataeau vaveve toela vage ata ke nohoma. ");
INSERT INTO kpx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ata olena isiviai di evievi ese molehame aiohavoge au vaveve toela vage abege ataeau mune baluga mai enoveta etunuvai mai davalamo mihatuge keu duave. ");
INSERT INTO kpx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Iale la ebia nibievelive la haoka moleu vaveve toela vage talive namihai vaveve ke bamuve. Ige au kemo hoilahage lainaho toelave ke huhuigelive. ");
INSERT INTO kpx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mesoho vani igae kemo au vaveve toela vai la aiogeve seveniaito (7) tota loholive la namigevei au vaveve toela ke louge lainaho bae toelave ke huhualive.” ");
INSERT INTO kpx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ige esemuiabeau namihai avoe, “No evievi negotige auna balugai.” ");
INSERT INTO kpx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ige au namigevei avoe, “Masitae i keu esevehame. Isito mesoho la evievi keu masitae i ke nahate vage lana idi ko namihai kosea, ‘Galata toholahai tota e nimo laminela. Ige auna la hoto evisi vai. ");
INSERT INTO kpx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Di hoto mole louge evive. La esemu moleu bulumo loviai mesoho ovo nibievenata hoilahai lohoge lana valive avuho loui kosea, ‘Solekai talive lovi inela.’ ");
INSERT INTO kpx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ba, la bae katealivebene. Isito lana louge auna la lovi vai hamai laoveito la halimo usege lana lovi ive. Keu uoholige esemu kena bae lovi isi. ");
INSERT INTO kpx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","La esemu keu vani bahata lovi ke vama. Iale la bae ke hoesehavolivebene. Keu loviveike. ");
INSERT INTO kpx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ke nahate laeau di esemu. Iale lana di laheho louale ke vai gabialiege loui kosea, ‘Noeau esemu unaha. Keu no lovilike.’” ");
INSERT INTO kpx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesuu kateai louito halei Dielusalema humahala tinu. Isi tiale Galilita Samaliata vatae tamagamo tinu. ");
INSERT INTO kpx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Keve tiale o molemo velemasege lebolasite ada mole isi ada mole keau haeavamole lavisi Iesu elehai hohavoi avoe, “No Kosive Iesu, noheho uvuai no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kateai louge Iesuu elegevei abuho loui avoe, “Tige dubu nalimaleau bae la vava elehai hilokage la vavahani keu uoholinu.” Kateige abu tisege humaha tavae vavaeabeu dua vanu. ");
INSERT INTO kpx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ige igaeu au vava elehai hoilahai lohoale baita Dilava imihai hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Isi lohoale Iesu vudimo kome bokoai vata bisi holumai Iesu hoesehavonu. Vaveve kateale vale ata keu Samalia ata. ");
INSERT INTO kpx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ige Iesuu au esemu namigevei avoe, “Dana ata ada mole isi ada molenike hoesegevenu. Iale degomoleau oleve. Isege igae kou hoilahai lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Osiohoike vata mole ata ko igaeu hoilahai lohoale Dilava hoesehavonu. Isege Diue ata naini (9) keau hoidevei lohoholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kateai louito malaha ke namihai avoe, “Di a evievimo a hoesehavoale hovelahai tenela.” ");
INSERT INTO kpx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Vani mole Balisia ata degomoleau Iesu namihai avoe, “Osiomalela Dilava matamae doga kena bae lohoi.” Ige Iesuu loui avoe, “Vani keu lohoveve ataeau bae elehalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Atabeu bae koseale loulivebene. ‘Avuike uoke lohonu.’ O mesoho, ‘Avuiko lohonu.’ Kosealemo la Dilava matama dogae uveve ke hoto evige la uvumo ua.” ");
INSERT INTO kpx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kateai louito au esemu namigevei avoe, “Vanie toela molena bae lohoge lana isiviale Atae Ese elehai. Isito la bae elehalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vani kela ataeabuna laheho loui kosea, ‘Elehave. Avuike uoke.’ O mesoho, ‘Avuike ko.’ Kateai louge lainaho hotoeabe evisi kaovaho talive. ");
INSERT INTO kpx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Atae Eseu lohoveve keu koseanu. Vau nivolekai solekai otogomo atagai kibalai vaki mole velemai vaki mole velemale ke nahate Atae Ese vanina bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Isito vasohuta ataeau vatamo umale koeabuna kabebihavoi aiohavoge auna vatehani baluga malei. ");
INSERT INTO kpx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ataeau subuta Noa vanimo vamale ke nahate Atae Eseu lohoveve vani ketamo abuna katelahai. ");
INSERT INTO kpx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa vani kemo ataeau lovi isi e isi mahinuvulahama. Abu kateilage Noau bouti uvue tisege e balugau lohoale ata bahata havehatunu. ");
INSERT INTO kpx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lota vanimo abu vamale keta kateanu. Vani kemo abu lovi isi e isi molela kunai voilahai bululahai o houevema. ");
INSERT INTO kpx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Isege vani mole Lotau Sodoma o ke halei tisege veneu otogomo dobai lohoale o ke bahata mahoevei gabianu. ");
INSERT INTO kpx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iale Atae Esena tota hoilahai lohoho vasege ataeabuna katelahai. ");
INSERT INTO kpx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Vani keu lohoge ata moleu oe dokoe uale keu bae oe uvue deluai au kunai maleliho talivebene. Isege ata moleu bulue uale keu bae oe hoilahai talivebene. ");
INSERT INTO kpx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Iale Lota mahinae vaveve ke huhulahave. ");
INSERT INTO kpx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Olena au ebika unaha huhuaniege auna uveve dua hosidisi. Isito oleu au ebika huhuholiniege auna uveve dua malei. ");
INSERT INTO kpx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iale di la namigevege evive. Vani kemo ata abui abuna ava igaemo ladevesege Dilavana mole haleito mole mai tai. ");
INSERT INTO kpx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Isege keate abui abuna igaetoai lovi vasege Dilavana mole haleito mole mai tai. ");
INSERT INTO kpx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Isege malaha abui abuna bulue lovilahasege Dilavana mole haleito mole mai tai.” ");
INSERT INTO kpx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesuu kateai louge esemuiabeau namihai avoe, “Kosive, auna oleve keve mai tai.” Ige Iesuu namigevei avoe, “Mesia moleu hatisi hisiage uguiau ke iliho mole bevueveale ke nahate vaveve nimolete keabuna velehovoge lana ke elehai huhuige di lohoveve vaniu vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Vani mole Iesuu dovudovue hoto mole loui au esemu haivei isiviale abu guliguliai kemo kabebi halevai. ");
INSERT INTO kpx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hoto keu koseanu. “O molemo kotae hoto evimale kosive moleu ua. Kosive keu Dilava vabuhavoholisi ata hoesegeveholima. ");
INSERT INTO kpx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iale o kemo gobu moleu ua. Gobu kena vani bahata kosive ke oe lohoniege au deiada loui namihai isivialeike ata moleu aiohavomale kemo au tedahoi. ");
INSERT INTO kpx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Isito vani moaga kotae kosive keu keate ke tedahoholinu. Ige keate keu negobedai namihalage kosive keu bae huhuai avoe, ‘Di Dilava vabuhavoholisi ata hoesegeveholimale kemo di bae keate ke tedaholivebene. ");
INSERT INTO kpx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Isito keate keu lohoi di namihalage di homasiale kemo dana tedahoi. Mesoho dana keate ke tedahoholige keate kena vani baita dae lohoi di namihagei.’” ");
INSERT INTO kpx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iesuu kateai louito tota namigevei avoe, “Lana kosive toelau louale ke evilu. Keu kosive toela. Isito keu keate ke hoto evisi tedahonu. ");
INSERT INTO kpx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iale la huhuige Dilava ata seleve keabuna vanimo vavimo ninalahai namihage Dilavana valive au ata kebia tedaevei. Mena auna vali vesokanata bae tedaevei. ");
INSERT INTO kpx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ba, di la namigevei. Auna solekai kebia tedaevege abuna ue dua vai. Isito Atae Esena valive vatae lohoniege evievi ata moaga elegevei. Emena.” ");
INSERT INTO kpx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesuu tota dovudovue hoto mole loui isiviale ataeau abu ebia malei hatui ata degomoleho isiviholimale kebia haivei. ");
INSERT INTO kpx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Isi loui avoe, “Ata abuiau dubue guliguliho tilu. Moleu Balisia ata. Isege moleu takesi malemale ata. ");
INSERT INTO kpx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ige Balisia ata keu tiale lamisi guliguliai avoe, ‘Dilava, di vahaehoanu. Ata degomoleau vavoloai moni malei keatehi ladevema. Isito dau vaveve toela kateale vaholima. Dau takesi malemale kebia nahate vai moni vavoloholima. ");
INSERT INTO kpx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bula igae uvumo di a hoesehavoliho vani abui lovi ioholisi di taidi aoma.’ ");
INSERT INTO kpx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Isito takesi malemale keu atae iae lamisi ehue nioholisito holumai au ebiamo au ada bisi loui avoe, ‘Dilava, dau atae toela. Iale daho uvuai di tedaho.’” ");
INSERT INTO kpx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesuu deiada ke louito tota namigevei avoe, “Di la namigevege evive. Dilavau takesi malemale ke toelamo hoesehavoge uvue duamo oe tinu. Isito Balisia ata ke vaveve toelau ua. Kosealemo oleu au ebika ebagemale ke Dilavana etolemai. Isito oleu au ebika etolemale ke Dilavana ebagemai.” ");
INSERT INTO kpx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vani kela keate degomoleau abu ese malei lohoi isivialeike Iesuu levevei hoesegevei. Isito Iesu esemuiau kebia elegevei iovei avoe, “Halevai teve.” ");
INSERT INTO kpx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Katelahage Iesuu hohavei avoe, “Lainaho eseese kebia keluevelive. Isege abu dae lohoi. Abu dae lohoale keu duave. Kosealemo eseese kobia uvunahate vamale keabuna Dilava adae vuvunemo ui. ");
INSERT INTO kpx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Seleveta di la namigevege evive. Oleuoleu eseese kobia uvunahate vaholiliege abu bae Dilava adae vuvunemo ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ige Diue kosive moleu Iesu namihai avoe, “No haivemale atae dua, dana onole vai ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ige Iesuu namihai avoe, “A osiohoike daho loui kosea, ‘Atae dua.’ Atabeu duave holioholinu. Isito Dilava igaeu duave. ");
INSERT INTO kpx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Au Dilava menaka hilokanu. Menaka keau loui avoe, ‘Ainaho mole keatehi ladevegelive. Ainaho ata havegelive. Ainaho vavoloagelive. Ainaho mole lobogelive. Isi a mamata a neinatae hoto evisi hoesegevenela.’” ");
INSERT INTO kpx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ige malaha keu Iesu namihai avoe, “Di esebuluta menaka kebia bahata ehovei lohoma.” ");
INSERT INTO kpx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ige Iesuu hoto ke evisi avuho loui avoe, “A louale ke bahata a vanu. Isito a vaveve ko igae vaholiale talive a kunai ke bahata malei voiai monive malei kunai holimale kebia oveito lohoi di ehomanela. Ilive elike otogoe ibinae dua manela.” ");
INSERT INTO kpx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hoto kateale louge malaha keu ke evisi uvu balugai halei tinu. Kosealemo keu kunai balugate ata. ");
INSERT INTO kpx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kateige Iesuu ke elehai loui avoe, “Kunaite keau otogoe tiveve keu tolo seleveanu. ");
INSERT INTO kpx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ovo mole ivi kamela keu nilae vahamo velemaveve keu anekianu. Iale ke nahate kunaite keau otogoe tiveve keu anekianu.” ");
INSERT INTO kpx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ige ataeau ke evisi namihai avoe, “Kunaite keau otogoe tioholige oleme igaeabuna otogoe tai.” ");
INSERT INTO kpx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ige Iesuu namigevei avoe, “Vaveve katealeu ataemo anekianu. Isito Dilavau ke vaveve hiloka.” ");
INSERT INTO kpx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ige Bitau avuho loui avoe, “Di louge evi. Noeau no onobenobe bahata halevai a ehovalu.” ");
INSERT INTO kpx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Kateai louge Iesuu au esemu bahata namigevei avoe, “Seleveike. Iale la olena Dilava adae vuvunemo uveve hoto louliho au o halei au mahina halei au hohuvu halevei au mamata au neinata halevei au ese haleveniege auna vata kove onobenobe moaga malei. Ige gabie Dilavana bae ukolikoli mai omisi.” ");
INSERT INTO kpx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesuu kateaito au esemu tuelo (12) unaha kebia holoevei lilikateve tiale kebia namigevei avoe, “Evive. Nahi Dielusalemae timale kove belovetaeau subuta hisaiale hoto ke bahataeabuna Atae Esemo lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ataeabuna ke mai Diue ata holioholiale kebia ovege abuna hehavoi avuemo violahai visuhavoi. ");
INSERT INTO kpx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Keu uoholige abuna mai hamage auna hatai. Isito vani abuita igaetaeabuna uoholige auna tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kateai louge esemuiabe keau hoto ke evisi dolodololahalu. Abu evisito ihuve ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Abu tiliale Dieliko oe vavae tisege malaha mole ni kedute keu humahamo ugulamoi moniho ata imigevema. ");
INSERT INTO kpx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iale keu usege ata moagaeau lohoi evihai tima. Ige au ke evisi belagevei avoe, “La osioma.” ");
INSERT INTO kpx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ige abu namihai avoe, “Nasaleta ata mole Iesu keike ko nahiela lohoma.” ");
INSERT INTO kpx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ige ni kedute keu baita hoai loui avoe, “Deividi mo Iesu, dahoe uvuai di tedahonela.” ");
INSERT INTO kpx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kateai louge ataeau vavavemo uale keau keluai namihai avoe, “Tobekai unela.” Kateai louge malaha keu hotoeabe ke evioholisito negobedai hoai avoe, “Deividi mo, dahoe uvuai di tedahonela.” ");
INSERT INTO kpx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Kateisege Iesuu lohoale velemai ata namigevei avoe, “Ni kedute ke melavei dae lohove.” Ige abu ke mai avue lohoge au namihai avoe, “A isiviale di ono vade ahoe vai.” Ige keu loui avoe, “Kosive, di isiviale niai.” ");
INSERT INTO kpx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ige Iesu avuho loui avoe, “Duave au a uvu mai daemo mamoalemo a nina duaveai. Iale nianela.” ");
INSERT INTO kpx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kateai lousege keu nianu. Isi Iesu ehomai tiale Dilava hoesehavonu. Ige ataeau ke elehai abuta Dilava hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Iesuu tiale o baluga Dielikoe velemai tisege keve takesi malemale kosive mole ivi Sakiasi keu keve ua. Malaha keu kunai moagate. ");
INSERT INTO kpx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iale keu isiviai Iesu elehai. Isito ata moagaeau bamuge keu elehaveveu anekianu. Kosealemo keu atae vugehame. ");
INSERT INTO kpx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iale keu uli holisi tiale idi luaula viatisi isiviai Iesu elehai. Keu hilokage Iesuna humaha kela tai. ");
INSERT INTO kpx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iale Iesuu kela tiale ehue niai Sakiasi elehai namihai avoe, “Sakiasi, solekai lalamoi loho. Di isiviai nova a oe talive aiti lovi isi.” ");
INSERT INTO kpx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kateai louge Sakiasiu vahaehota solekai lalamoi lohoale Iesu melamei avuti au oe tinu. ");
INSERT INTO kpx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ige ataeau vaveve ke elehai isiviholisi loui avoe, “Keu atae toela ke oe tiale avuti lovi ige keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ige abu lovi isege Sakiasiu hovelahai lamisi Iesu namihai avoe, “Kosive, evinela. Dana di kunai tasaliai vaki mole malei kunai holimale kebia ovei. Isi ata degomole lobogevei abuemo onoeabe malemale ata kebia dana kunai ove abuiabuiai.” ");
INSERT INTO kpx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ige Iesuu avuho loui avoe, “A louale kemo Dilavau a toelamo a maveve vaniu nova aemo lohonu. Iale kemo a nova Ebalahamu valada seleve holinu. ");
INSERT INTO kpx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iale Atae Eseu vaveve toelamo tebulahamale kebia kaovei malevelihoike au lohonu.” ");
INSERT INTO kpx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ataeau Iesu hoto evisege au tota dovudovue hoto mole loui haivenu. Kosealemo ataeau huhulahai avoe, “Iesuu aike Dielusalemae velemage nahiabuna Dilava adae vuvunemo ui.” ");
INSERT INTO kpx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kateisege Iesuu deiada mole loui isiviale abu Dilava adae vuvunemo uveve kemo lulelelahai. Isi loui avoe, “Kosive moleu isiviai tai vata moleve vata ke kosive balugamo vuvune malei tota hoilahai loholive au vata nalisi. ");
INSERT INTO kpx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iale keu au esemu teni (10) hohavege abu lohoge au uani taoseni kina (K1,000) malei igaegaeai ovei namigevei avoe, ‘Di tisege moni ko malei kemo lovilahai elike moni degomole maleve.’ Kateai louito halevei tinu. ");
INSERT INTO kpx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Isi tisege vatave ataeau avuho isiviholisi iave abu esemu hanavege abu tialeau kosiveabeu timale vata ke kosive baluga namihalu. Namihai avoe, ‘No isiviholilu malaha keu balugai no nalieveliho.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kateaito malaha keu vuvune malei tota hoilahai lohoale vata ke nalinu. Isi vasohuta au esemu teni (10) kebia hohavege abu lohoge au belagevei isiviale hilokage au moni oveale kemo abu moni vaesute malelu. ");
INSERT INTO kpx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ige vasohuta omiale keu lohoi loui avoe, ‘Di kosive, a moni daoale kemo di teni taoseni kina (K10,000) malenu.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ige kosiveveu avuho loui avoe, ‘Duave baua, au esemue dua. Vaveve ese kemo a lovie dua vale dana vuvune malei aoge ana o baluga ada mole isi ada mole nalievenela.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kateige iavemo moleu lohoi namihai avoe, ‘Di kosive, a moni daoale kemo di vai taoseni kina (K5,000) malenu.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ige kosiveveu avuho loui avoe, ‘A katealelua o baluga ada mole nalievenela.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kateige iavemo esemuve moleu lohoi namihai avoe, ‘A moni mai daoale keike ko. Di ogota viliai mai mahogovanu. ");
INSERT INTO kpx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kosealemo au malaha tolote. Au a ono holioholiale ke ana malegei. Isi a lovi haholimale ke ana heiata malegei. Ialemoike di a vabuhavoi moni ke mai mahogovanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ige kosiveveu avuho loui avoe, ‘A keu esemue toela. A hoto louale kena a aiohavoi. A loui kosea, Keu ata tolote. Keu au ono holioholiale ke auna malegei. Isi keu loviholisito auna heiata lovi malegei. ");
INSERT INTO kpx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A kateai huhuale kemo a osiohoike di moni ke mai banikamo mamoholinu. Abege a ke malei banikamo otovege keu balugai. Ilive elike moni ke goloe moleta malege duave. Isito a ke vaholinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Au kateai louito au vavamo laviale kebia namigevei avoe, ‘Avuemo moni ke malei teni taoseni kina (K10,000) maleale ke omive.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ige abu ke evisi avuho loui avoe, ‘Ba, kosive, keu moni baluga malege elemua.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ige au loui avoe, ‘Di la namigevege evive. Oleu moaga maleale kena moaga malei. Isito oleu maleholiale keu bae onobe malivebene.’ ");
INSERT INTO kpx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kateai louito tota loui avoe, ‘Ata neheau di aiohavomaleau daho itumulahai di balugaliho isiviholiale kebia malevei loholive di vudimo havege abu haluvisi.’” ");
INSERT INTO kpx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesuu deiada kateale louito halei uli holisi Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tialeu tana mole Oliveta kemo tige o abuitaeau ua. Moleu Betabedi. Ige moleu Beteni. Iale au o ke vavae taito isiviai au esemu abuita hanavege abu uli holisi tai. ");
INSERT INTO kpx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kateai namigevei avoe, “Talive o kela velehovoi o ke ivie elehage doniki mole doga abu avuemo uguiavoholisito umuvai mavoale ke vavehai mai lohove. ");
INSERT INTO kpx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","La ke vavehasege mesoho ata moleu la belagevei loui kosea, ‘La osiohoike ke lulehama.’ Ige namihai kosea, ‘Kosiveu avuho isiviaike vage.’” ");
INSERT INTO kpx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iesuu kateai louge abu halevai tiale au louale ke nahate elehalu. ");
INSERT INTO kpx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Isi doniki ke vavehasege biaeau abuho loui avoe, “La osiohoike ke lulehama.” ");
INSERT INTO kpx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ige abu namigevei avoe, “Kosiveu avuho isiviaike vage.” ");
INSERT INTO kpx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kateai louito mai Iesue tilu. Tialeau abu ogo malei doniki ke inumo bokoai otovege Iesuu biloai golovemo ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Au kemo biloai tisege abu abu ogo malei humahala detisi tilu. ");
INSERT INTO kpx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tiale Oliveta tanamo lagaluvisito hevaluvimale kemo lavisi Dielusalema elehage esemuiabe bahata keau vahaeholahai Dilava hoesehavolu. Isime baita loui avoe, “Ata kou au vuvunemo vikoe vaveve moaga vage no elehalu.” ");
INSERT INTO kpx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Avoe, “Kosive kou Dilava ivimo lohoale ko nahi hoesehavoi. Otogo keu uveve duae matama. Iale nahi Dilava hoesehavoi ivive ebagevai.” ");
INSERT INTO kpx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kateai lousege Balisia ata degomoleau Iesu namihai avoe, “Kosive, a esemu namigevege abu hoto kateale lou halevai.” ");
INSERT INTO kpx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ige au namigevei avoe, “Ata keabuna di hoesehavoholige dana mune kobia namigevege abuna hotolahai di hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Au kateaito lohoi niai Dielusalema elehaime ninanu. ");
INSERT INTO kpx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ninai avoe, “Dielusalema ataea, la uveve duae hoto matahage duave. Isito la ehalovalu. Ialemo la tota ke mavevena anekiai. ");
INSERT INTO kpx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iale vani molena lohoge la aiogeveve ataeabuna bae loholiege o ko evilikahavoi mai molehi dai o ko koiai. ");
INSERT INTO kpx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Isime o ko bahata aiohavoi la bahata havehatui. Ige munebehameu bae mole golomo ulivebene. Kosealemo Dilavau isiviai la malevei. Isito laeau ke huhulahai luleleholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kateaito lohoi tiale Diue dubu balugae tige ataeau ui onobenobe voilahama. Ige Iesuu tiale kebia koievei nunuvenu. ");
INSERT INTO kpx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Isi abuho loui avoe, “Dilavau Bukae Hotomo loui avoe, ‘Di isiviale ataeau di o komo guliguliai di hoesehavogei.’ Isito laeau kateholisito vavoloe vaveve avuemo vama.” ");
INSERT INTO kpx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Isi vani bahata timale dubue ata haivema. Kebia haivesege dubu nalievemale kosive, Diue menaka loui haivemale isi oe kosive keau isiviale hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Isito abu hamaveve ke kaovalage humahau uoholinu. Kosealemo ataeau hotove evisi isiviholilu hotovebehame hosidiliho. ");
INSERT INTO kpx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vani mole Iesuu Diue dubu balugae tiale hotoe dua loui ata haivesege Diue menaka loui haivemalea, Dubu nalimale kosive balugaea isi oe kosive keau loholu. ");
INSERT INTO kpx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lohoale Iesu namihai avoe, “No namigevenela. Oleike vuvune aoi a namihage au vaveve kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ige Iesuu abuho loui avoe, “Usege di hoto mole loui la belagevei. ");
INSERT INTO kpx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ole vuvunemoike Dioniu ata babatisogevenu. Dilava vuvunemo emena atae vuvunemo.” ");
INSERT INTO kpx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kateai belagevege abu hotohotoai moleho loui avoe, “Nahiabuna hoto onole loui. Mesoho nahiabuna loui kosea, ‘Dilava vuvunemo.’ Ige auna loui kosea, ‘Isito osiohoike la Dioni hoto evioholilu.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Isi mesoho nahiabuna loui kosea, ‘Atae vuvunemoike.’ Ige ata bahata koeabuna mune malei nahie havei. Kosealemo keau huhuige Dilavau au vuvune omige Dioniu beloveta holinu.” ");
INSERT INTO kpx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hotoeabeu uoholige abu Iesu namihai loui avoe, “No Dioniu olemo vuvune male ke no hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ige Iesuu namigevei avoe, “La katealemo di bae data ole vuvunemo vaveve kateale vale loui la namigevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesuu kateai loui hilokage keau hotove homasihavolu. Iale keu dovudovue hoto mole loui ata haivei avoe, “Malaha moleu au bulu hai ata degomole namigevege abu bulu ke nalilu. Isito halei tiale vagana moaga matama moleve ua. ");
INSERT INTO kpx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Keve usege loviu baeveve vaniu lohoge au au esemu mole hanavoi isiviale au talive ata nehe kebiamo lovi degomole malei lohoi. Isito ata keau esemu ke hamai iovage ada unahala hoilahai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ige au tota esemu mole hanavoge au lohonu. Ige bulu nalimale keau keta hamai aiohavoi iovage ada unahala hoilahai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ige au tota esemu mole hanavo moleage au lohonu. Ige abu keta hamai nunuvage au vatehani mai tinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ige bulu ke biageu huhuai avoe, ‘Dana onole vai. Mesoho dana di uvue mo hanavoge abu bae ke aiohavolivebene.’ Kateai loui au mo hanavoge au lohonu. ");
INSERT INTO kpx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ige bulu nalimale keau ke elehai mole namigevei avoe, ‘Bulue biage moike ko. Iale nahi hamage au hatige elike bulu kou nahiele holisi.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kateai louito mo ke evudei mai tiale bulue iae hamalu.” Iesuu deiada ke louge uoholige au namigevei avoe, “La huhuige bulue biagena kebiaho osioi. ");
INSERT INTO kpx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Di la namigevei. Auna lohoniege ata kebia havei bulu ke mai ata degomole ovege abuna nalisi.” Ige Diue ataeau ke evisi loui avoe, “Dilavau bae kateale noemo valivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ige Iesuu niavei namigevei avoe, “Isito Bukau louale ko ihuu oleve kateanu. ‘O houmale keau mune moleta o houveve ke kabebihavoale keike nova Dilava o hadebiveve mune holinu.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oleme abuna mune ke vuvehaliege abu ebia havei haluvisi. Ige mune kena dobai ata mole hamage lave unahana ui.” ");
INSERT INTO kpx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iesuu hoto kateale louge Diue menaka loui haivemale isi dubu nalievemale kosive keau hilokage Iesuu deiada ke loualeu vaveveabemoike au ke lounu. Katealemo abu isiviale Iesu mai. Isito abu ata vabugeveale kemo maveve ke halevalu. ");
INSERT INTO kpx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Isito vani bahata nibisi abu esemu degomole bevuevei namigevei avoe, “Talive Iesu namihai lobohavoge au hoto nimolete lousege no bae mai talive gamani vuvunete omige au avuemo kotai.” ");
INSERT INTO kpx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kateai louge esemuiabe keau tiale Iesu namihai avoe, “No haivemale ata, no hilokage a hoto loui ata haivemale keu seleve. Au atae hoto evioholisito Dilava hoto seleve loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iale hoto mole loui no haivenela. No takesiai Loma gamanie kosive baluga Sisa omiale kena duave. Emena toelanu.” ");
INSERT INTO kpx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ige Iesuu loboeabe ke hilokai namigevenu. ");
INSERT INTO kpx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Isi avoe, “Monie luhu mai lohoge di elehai.” Ige abu mai omige au namigevei avoe, “Ole munanata ivivetaike moni ko luhumo ua.” Ige abu namihai avoe, “Loma gamani kosive baluga Sisa.” ");
INSERT INTO kpx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ige au namigevei avoe, “Ito. Iale gamaniele gamani omive. Isi Dilavaele Dilava omive.” ");
INSERT INTO kpx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kateai louge hotoveu inuige abu ke evisi vikolahai tobekai ua. Katealemo abu atae vudimo maveveu anekianu. ");
INSERT INTO kpx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ige Sadukea ata degomoleau Iesue loholu. Ata keabuike loui avoe, “Haluviale keau bae hovedevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Iale ata keau Iesu namihai avoe, “No haivemale ata, Moseseu menaka mole noheho hisaliai avoe, ‘Mesoho malaha moleu mahinaito eseholisi hatige hohovena hovelahai gobu ke melamei au nanaho ese houi.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iale no deiada mole louge evinela. Malaha mole igae mohoho bahata seveni (7) houevenu. Iale ovokinave keu mahinaito esebe mamoholisi hatinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ige valavemo keu hovelahai au nanae gobu melameito avuta esebe mamoholisi hatinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ige valaeabemo keau bahata katelahai gobu ke igae melavei esebe houeveholisito haluvilu. ");
INSERT INTO kpx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Iale keau bahata haluvige keate keta hatinu. ");
INSERT INTO kpx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","No deiada ke loualemo a huhuige ata seveni (7) kebiabuna hovedevege keate kena ole mahina holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ige Iesuu abuho loui avoe, “Aike vata komo malahaeau keatehi mole holoevema. ");
INSERT INTO kpx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Isito oleuoleu evievimo haluviale kebia Dilavana huhuevei tatuvege abuna hovedevei ehue tiliege bae mole holoevelivebene. ");
INSERT INTO kpx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Isi anelu nahate vai haluvilivebene. Kosealemo keau haluvisi hovedeveale kemo abuna Dilava ese holievei. ");
INSERT INTO kpx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moseseu louale kemo nahi hilokage haluviale keabuna hovedevei. Lana Bukae Hoto huhulahalu. Kemo Dilavau veneu idimo lahale keve Moseseho louge au Kosive namihai avoe, ‘Ebalahamu Dilava, Aisiki Dilava isi Diekobo Dilava ailike.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moseseu kateai louale kemo nahi hilokage keu nova nita uale kebia Dilava isi subuta haluviale munanaeabeu uale kebiatae Dilava. Iale kemo Dilava keu haluviale isi nita uale kebia Dilava.” ");
INSERT INTO kpx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iesuu kateai louge uoholige Diue menaka loui haivemale degomoleau loui avoe, “No haivemale ata, a louale keu duave.” ");
INSERT INTO kpx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Abu tota Iesu belahaliho vabulahalemoike hoto kateale loulu. ");
INSERT INTO kpx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ige Iesuu belagevei avoe, “Diue menaka hisaliamale keau loui avoe, ‘Kelisona Deividi valadamo lohoi.’ Isito auna oleve kateai Deividi valada holisi. ");
INSERT INTO kpx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kosealemo Deividi biageu Samusi bukamo hisaliai avoe, ‘Dilavau di Kosive namihai avoe, Di ada inute keveatae ugulamo. ");
INSERT INTO kpx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Isege di a aiohavomale ata kebia malevei a veloe heimo otovege ana Kosiveabe holinela.’ ");
INSERT INTO kpx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Iale subuta hoto kemo Deividiu loui avoe, ‘Di Kosive.’ Au kateai loualemo Keliso kena oleve kateai Deividi valada holisi.” ");
INSERT INTO kpx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ige ata bahataeau hotove evisege Iesuu au esemu namigevenu. ");
INSERT INTO kpx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Isi avoe, “Diue menaka loui haivemale ata kebia aegeveve. Keau isiviale ogoe dua egete hatuevei ata moagaeau umale keve olahai tige ataeau elegevei hoesegevegei. Isi isiviale talive dubue uvue vomue duamo uguiavoge ataeau elegevegei. Isi isiviale iveve baluga vamale kemo ivite kebiahi igaetoagei. ");
INSERT INTO kpx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Isi abuna loboe vaveve vai gobuvu lobogevei oeabemo kunaiabe malegei. Abuna katelahaito tiliege atae vudila guliguli egete vagei. Abu kateimale vamalemo Dilavana vatehani baluga ovei.” ");
INSERT INTO kpx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesuu kateai louito niavevevela kunai moagate kebia elegevesege abu moni malei lohoi dubue uvue obelini otovemalemo manevema. ");
INSERT INTO kpx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ige au elehasege gobu mole kunaivesite keu lohoale benie kina abui mai manemenu. ");
INSERT INTO kpx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ige au ke elehai loui avoe, “Di la namigevei. Gobu keu mai manemeale keu kunai moagate kebia moni evigevenu. ");
INSERT INTO kpx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kosealemo kunai moagate keau abu moni baluga kemo monie esehame malei lohoi manevelu. Isito gobu keu moniu avuemo ualehameike au ke malei otovege avuemo moni behameu tota uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kateigeto Iesu esemu degomoleau Diue dubu baluga ke elehai namihai avoe, “Munee duata abu o ko houale ko eleha. Isi kunai duata malei kaeahavoale kebiata elegeve.” ");
INSERT INTO kpx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ige Iesuu namigevei avoe, “Vani molena lohoge la dubu ko elehale ke ataeabuna loholiege koilahage mune moleu bae mune mole golomo ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iesuu kateai louge abu namihai avoe, “No haivemale ata, vaveve kena osiomalela velemai. Isi vaveve oletena lohoge noeabuna ke elehai hilokage vaniu vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ige Iesuu namigevei avoe, “La ebika nenigeveve. Onoilage ataeau la lobogevege dobuluvima. Kosealemo ata moagaeabuna loholiege di ivimo lobolahai loui kosea, ‘Dau Keliso.’ O mesoho loui kosea, ‘Vaniveu lohonu.’ Abu kateai louge lainaho bae kebia ehovelive. ");
INSERT INTO kpx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ataeau mole havei tuvaliage lainaho hoto ke evisi vabulahalive. Kosealemo vaveve toela katealeabuna vasohuta lohoi. Igeto gabie vanie gabina bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Di hoto mole louge evive. Vani keu lohoho vasege vata mole ataeabuna hovedevei vata mole atahi mole havei. ");
INSERT INTO kpx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Isege vata bahatamo hamu balugana hatui. Ige vae balugana lohoi. Ige vavahanie toelana lohoge ataeabuna kemo haluvisi. Vaveve kateale abuna vatamo lohosege otogomo vaveve nimolete abuna lohoi. Ige ataeabuna ke elehai vabulahai. ");
INSERT INTO kpx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Isito vaveve katealeu lohoholisege ataeabuna la malevei la aiogevei lahavei. Isi abuna la malevei tiliege Diue dubue laemo kotai la malevei dibulae otovei. Isi la di ata holialemo abuna la malevei gamanie kosive kebia vudimo otovege abuna la aiogevei. ");
INSERT INTO kpx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Abu kateisege di hotoe dua loui kebia haiveve. ");
INSERT INTO kpx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Isi lainaho kebia vudimo lavisi hoto louveve ke huhulahagelive. ");
INSERT INTO kpx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kosealemo dana hoto laovei lulele keta laovege la aiogevemale keau bae la hotobe hamalivebene. ");
INSERT INTO kpx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ige la haokuvu, la mamuvu, la neinuvu isi la abuhi ese igaeale keabuna laheho hailahage ataeabuna bae la malevei lahavei. ");
INSERT INTO kpx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","La di ehovamalemo ataeabuna laheho itumulahai huhuihuhuie toela vai. ");
INSERT INTO kpx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Abuna laemo kateale vaito la bae uoholilivebene. Isito Dilavana bae la kinae vomo la vava bahata ke malege lana kemo ue dua vageve. ");
INSERT INTO kpx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lana vaveve kemo negolahaliege ukolikoli maleve. ");
INSERT INTO kpx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Lana vani mole elehasege tuvalie ataeabuna Dielusalema o ko evilikahavoi. Ige lana kemo bae hilokai loui kosea, ‘O ko aiohavoveveu vuguvuguanu. ");
INSERT INTO kpx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iale vani kemo Diudia vatamo umale lana detuluvisi tanae teve. Ige Dielusalemae umale keabuna o ko halevai tai. Ige oleuoleu bulue umale keau bae hoidevei o kove loholivebene. ");
INSERT INTO kpx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vani kela Dilavana o ko vaveve toelae ibina vai. Au kateaniege Bukae Hotou louale ke mai selevetisi. ");
INSERT INTO kpx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Iale vani kela keate ese tobute kebia nohovu. Isege keate degomole ese gite maleale kebiata nohovu. Kosealemo vata komo vatehani balugana lohoge Dilava itumu balugana ata kobiamo lohoi. Ige keate keabuna oleve kateai solekai detuluvisi. ");
INSERT INTO kpx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vatehani baluga keu koseanu. Tuvalie ataeabuna loholiege benisita ata degomole haveime degomole malevei hanavege abuna vata degomoleve tai ata kebiamo lovilahai. Isege Diue ata holioholiale keabuna loholiege Dielusalema mai avuemo ui. Iliege vani mole kebia vani kena uoholige Diue ataeabuna tota hoidevei o ko mai.” ");
INSERT INTO kpx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Vani kela otogomo vaveve nimoletena lohoi. Vanimo, batamo isi didi kebiamo abuna katelahai. Isege heie vata kove davalana vuloai hahosihovoi vatae lohoge ataeabuna ke elehai vabulahai tetelahai. ");
INSERT INTO kpx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vaveve katealena vatamo lohoge otogomo uale keabuna kibikibiai solahai. Ige ataeabuna ke elehai vabulahai lokihovoi. ");
INSERT INTO kpx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vaveve kateimalela ataeabuna elehasege Atae Esena au vuvuneta au atagata goe golomo dobai lohoi. ");
INSERT INTO kpx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vaveve katealeau vasohuta velehovosege hovedevei lavisi ehue nilahave. Kosealemo Dilavau la maleveve vani keu vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesuu hoto ke louge uoholige au hoto mole loui namigevei avoe, “Idie vaveve ke huhulahave. ");
INSERT INTO kpx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Elehalive idie numuiau humulahage huhulahai kosea, ‘Vaganau vuguvuguanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ke nahate elehage otogomo isi vatamo vaveve katealeau velehovoge huhulahai kosea, ‘Dilava matamae dogau lohoveveu vuguvuguanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iale di hoto seleve louge evive. Ataeau aike uale koeabuna haluviholisege vaveve katealeabuna velehovoi. ");
INSERT INTO kpx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ige vatana otogoti uoholisi. Isito di hotou bae uoholilivebene. ");
INSERT INTO kpx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Iale la ebia nenigeveve. Lainaho vani bahata iveve huhu moagai e toelata i moagagelive. Isi lainaho vatae vaveve ke huhu moagagelive. Lana katelahage vani ke vavevena laemo lohoge lana vikolahave. ");
INSERT INTO kpx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vani kela vaveve kena kukoi nahate vai solekai tolemai vatae ata bahata bamuevei. ");
INSERT INTO kpx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ialelua nilahai ui vani bahata guligulialive elike vaveve toela keu lohoge kemo negolahai Atae Esee vudimo lavie dua vave.” ");
INSERT INTO kpx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Iesuna vani bahata vavita Diue dubue balugae lohoniege ata haivegei. Imale ataeabuna vavita vavita igaetoai tiliege hotove evigei. Iniege gutuige Iesuna tiniege tana mole Oliveta keve lahagei. ");
INSERT INTO kpx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iesu kateilage Diue vahaeho vani mole Basova keu vuguvuguanu. Vani kemo abu bae beikini baudata valava mahoale ke ilivebene. Isito abuna vani kela mamoe havei isi Dilava hoesehavogei. ");
INSERT INTO kpx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Isege Diue dubu nalievemale kosive isi Diue menaka loui haivemale keau vabulahai isiviholilu atae vudimo Iesu hamaliho. Isime maveve humaha mole kaovama. ");
INSERT INTO kpx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Isege Seteneu Iesu esemu tuelo (12) ke mole Diudasi Kaliota uvumo deluanu. ");
INSERT INTO kpx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iale keu tiale Iesuho haiai dubu nalimale kosive isi dubue udaha nalimale bukate kebia namigevei avoe, “Dana oleve kateai Iesu mai laovei.” ");
INSERT INTO kpx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ige abu ke evisi vahaeholahai isiviale moni mai omisi. ");
INSERT INTO kpx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kateige Diudasiu loui avoe, “Duave.” Isi tiale Iesu maveve humaha ke kaovama. Isito isiviholiale ataeau ke hilokaliho. ");
INSERT INTO kpx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iniale Diue vahaehoe vani keu lohoge abu isiviai mamoe havei Basovae lovi isi. ");
INSERT INTO kpx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iale vani kela Iesuu Bitata Dionita hanavei loui avoe, “Talive nahie Basova lovi ke gadehavove.” ");
INSERT INTO kpx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ige abu namihai avoe, “A isiviale nona oleve keve talive lovi ke bevuai.” ");
INSERT INTO kpx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ige au loui avoe, “Talive o kemo velehovoi elehage malaha moleu e bagumo e hai tige ke ehovai talive ovela velehovove. ");
INSERT INTO kpx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Isi o ke biage namihai kosea, ‘No haivemaleu aho loui avoe, O olete uvumo dana di esemuhi Basova lovi isi.’ ");
INSERT INTO kpx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lana katelahai namihage auna la holoevei o ke ehue tiniege uvu mole baluga mai la haivei. Ige ke uvumo nahie lovi bevuai gadehavove.” ");
INSERT INTO kpx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kateai louge abu halevai tiale au louale ke nahate elehalu. Isime keve Basova lovi iveve ke gadehavolu. ");
INSERT INTO kpx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lovi iveve vaniu gutuige Iesuu lohoale au abostolo tuelo (12) kebiahi lovi iliho ugulelevalu. ");
INSERT INTO kpx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ige au abuho loui avoe, “Dana bae vatehani malei. Iale di isivi balugale lahehi ugulamoi Basova lovi ko isi. ");
INSERT INTO kpx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Isito di la namigevei. Di bae tota lovi ko ilivebene. Isito Dilava matamae dogau lohoge vani kemo Basova lovi kona bae ihuve seleve holige dana bae isi.” ");
INSERT INTO kpx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hoto ke louito kabu mai hoesehavoi mai au esemu ovei loui avoe, “Ko igaegae mole ovei ive. ");
INSERT INTO kpx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Di la namigevei. Di bae tota uaini koseale ilivebene. Ilage Dilava matamae doga keve dana bae tota isi.” ");
INSERT INTO kpx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kateai louito valava mai hoesehavoi vakoai malei ovei loui avoe, “Di misilike ko di laovenu. Iale ko isi di huhulahave.” ");
INSERT INTO kpx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ige abu lovi ige uoholige au kabu mai ovei loui avoe, “E kou di tahoike ko. Iale di tahona lotige Dilavana di taho kemo laheho menakae doga vai. ");
INSERT INTO kpx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Isito di hoto mole louge evive. Nahi kove uguiavoi lovi ima. Isito la mole igaena bae di mai atae toela ovei. ");
INSERT INTO kpx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ige dana kemo hatai. Kateale keu Dilava isivilike. Isito malaha keu dahoe haiale ke nohoma.” ");
INSERT INTO kpx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kateai louge abu hovedevei abu molete namigevei avoe, “Nahiemo ole igaena vaveve ke vai.” ");
INSERT INTO kpx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Abu katelahaito baita moleho loulage moleu loui avoe, “Dau laemo baluga.” Ige moleu avoe, “Ba, dau baluga.” ");
INSERT INTO kpx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Katelahage Iesuu namigevei avoe, “Vatae kosiveau abu vuvunemo abu ata nibievei isivialeike esemuiabeau iviabe tabagevei loui kosea, ‘Laeau no kosive balugaea.’ ");
INSERT INTO kpx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Isito lainaho vaveve ke nahate vagelive. Di isiviale la vaveve koseale vage keu duave. Lana isiviai kosive holiho valiege vasohuta la ebia halevai mole tedaevei hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vatae kosive abuna uguiavo unahai louge esemuiabe abuna lovi malei ovegei. Katealemo lana hilokage oleteu baluga. Oleteu eseve. Isito dau kateholinu. Dau la baluga. Isito di la hoesegevei la tedaevema. ");
INSERT INTO kpx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Isito vani bahata vaveve toelau daemo lohosege laeau daluvuta ua. ");
INSERT INTO kpx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Iale di Mamau ataeau adave uvumo uveve vuvune mai daoale ke nahate dana vuvune mai laovei. ");
INSERT INTO kpx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ige lata vani kemo daluvuta igaetoai lovi isi telonamo uguiavoi vuvune kemo Iselala valada tuelo (12) kebia nibievei vaveveabe kaoveve.” ");
INSERT INTO kpx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesuu hoto ke louge uoholige au Saimoni Bita namihai loui avoe, “Saimoni, di hoto mole louge evi. Seteneu Dilava namihai isiviale a vaveve bahata kaovai. Keate moleu laisu sesiale ke nahate auna a vaveve bahata kaovai. ");
INSERT INTO kpx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Isito di aho guliguliai isivialeike a evievi keu bae doba selevealivebene. Iniege vani mole a vaveve toela kemo hoilahaniege talive a haokuvue evievi negotievenela.” ");
INSERT INTO kpx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ige Bitau namihai avoe, “Kosive, abuna a mai dibulage dana aiti keve tai. Abu ahavoge dana aiti hatai.” ");
INSERT INTO kpx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ige Iesuu namihai avoe, “Bita, di louge evi. Novae vavimo kokoluguu hotoholisege ana hoto koseale lou abuita igaetai kosea, ‘Di ke hilokaholinu.’” ");
INSERT INTO kpx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesuu tota au esemu bahataho loui avoe, “Di vani mole la hanaveale kemo laeau moni, mogamoga, tamaka maleholilu. Kemo la elemua. Emena la vugeholilu.” Ige abu loui avoe, “Elemua.” ");
INSERT INTO kpx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ige Iesu tota loui avoe, “Isito aike la monita la mogamogata maleve. Isi mesoho la oleu siga maholialeu au dabae ogo mai voiai moni ke mai siga voiai. ");
INSERT INTO kpx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iale di la namigevei. Bukae Hoto molena daemo lohoi. Hoto keu loui avoe, ‘Ataeau huhuige keu atae toela mole.’ Iale abu subuta hisaliale kena nova daemo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ige abu Iesuu namihai avoe, “Kosive, siga abuitaike ko.” Ige au loui avoe, “Elemua.” ");
INSERT INTO kpx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesuna vani bahata Oliveta tanae tiniege keve lahagei. Iale au ke louito Dielusalema halei Olivetae tinu. Ige esemuiabeau ehovalu. ");
INSERT INTO kpx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iale abu keve velehovoge Iesuu namigevei avoe, “Guligulilahalive elike vaveve toelau laemo lohoge la bae kemo dobuluvilivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kateai namigeveito halevei ahuvela tiale iekela kome bokoai guligulianu. ");
INSERT INTO kpx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Isi loui avoe, “Mamai, a isivianiege vatetumu daemo lohoveve ke mai evihanela. Isito a isivi unaha. Ana isiviage dana vatetumu ke malei. Isito a isiviholige di bae ke malelivebene.” ");
INSERT INTO kpx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hoto kateale louge anelu moleu otogomo dobai lohoale mai negotinu. ");
INSERT INTO kpx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ige au tota negobedai guliguliage uvuve keu isu baluganu. Ige vahotoveu taho nahate bidoai vatamo lotinu. ");
INSERT INTO kpx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Au kateinata hovelahai hoilahai tiale au esemu elegevege abu uvulahalata ladevelu. ");
INSERT INTO kpx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ige au namigevei avoe, “La osiohoike ladevema. Hovedevei guligulilahalive elike vaveve toelau lohoge kemo dobuluvi halevave.” ");
INSERT INTO kpx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesuu kateai namigevesege ata moagaeau loholu. Ige Iesu esemu mole Diudasi keu kebiaho uli holisi lohoale Iesu evudei ulikukuhavonu. ");
INSERT INTO kpx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ulikukuhavoge Iesuu namihai avoe, “Diudasi, ana isiviai di ulikukuhavoale kemo di mai atae toela ovei.” ");
INSERT INTO kpx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ige Iesu esemuiau vavavemo laviale keau belahai avoe, “Kosive, noeabuna vali siga malei kebia havei.” ");
INSERT INTO kpx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Isi kateisege moleu siga mai dubue kosive baluga ke esemue golema inute heisi etulenu. ");
INSERT INTO kpx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ige Iesuu loui avoe, “Halevave.” Isi esemu ke golema levege maholilinu. ");
INSERT INTO kpx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ige dubu nalimale kosivea, oe kosivea isi dubue udaha nalievemale bukateau Iesu maliho lohoale avuluvuta ua. Ige Iesuu namigevei avoe, “Lana huhuige dau vavoloamale ata. Ilike vage la benisita visuta malei dahavoho loholu. Emena la osioho. ");
INSERT INTO kpx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dau vani bahata la dubu balugae timale uma. Isege la di elehaito di maholilu. Isito laeau vavie esea. Nova kou la vanilike. Iale la vavi komo lohoale isiviai di male keta duave.” ");
INSERT INTO kpx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iesuu hoto ke louge uoholige abu evudei melavei dubu nalimale kosive baluga ke oe loholu. Isege Bitau ialialihavoi ehomai lohoma. ");
INSERT INTO kpx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ige abu ologomo vene beisi venehemo uguiavosege Bitau lohoale abuhi ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Isege veneu vedodoai nivemo atagage ma moleu nive elehai loui avoe, “Malaha kota avuti umaleike ko.” ");
INSERT INTO kpx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kateai louge Bitau namihai avoe, “Ba, dau ke hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iniale malaha moleu Bita elehai namihai avoe, “A keu Iesu esemu mole ailike.” Ige Bitau namihai avoe, “Ba, dau ke holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Iliale abu ukaukaito tota malaha moleu negobedai loui avoe, “Seleveta kou Galilie ata nahate. Iale no kemo hilokage kou Iesuti ohanoimale ataike.” ");
INSERT INTO kpx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ige Bitau namihai avoe, “Halenela. Di a hoto louale ke hilokaholinu.” Kateai lousege solekavesite kokoluguu hotoanu. ");
INSERT INTO kpx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ige Iesuu hoilahai Bita niavoge Bitau Iesuu subuta louale ke huhuanu. Au loui avoe, “Bita, di louge evi. Novae vavimo kokoluguu hotoholisege ana hoto koseale lou abuita igaetaeai kosea, ‘Di ke hilokaholinu.’” ");
INSERT INTO kpx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ige Bitau ke huhuai uvu balugai halei tiale iekela nina baluganu. ");
INSERT INTO kpx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ige ata degomole Iesu nalimale keau Iesu hehavoi ogo mai nive viliasege ata moleu hamai namihai avoe, “Au beloveta ata. Iale no namigevenela. Oleike ahamonu.” ");
INSERT INTO kpx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kateaito hotoe toela moaga loui aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vau alamoge Diue kosive moagaeau hotohotoho loholu. Oe kosivea, dubu nalimale kosivea, Diue menaka loui haivemale keau mole bevuevei igaetoai Iesu melavei kotaho loholu. ");
INSERT INTO kpx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Isi belahai avoe, “No namigevenela. Ana huhuige Dilavau a hanavoge a Keliso holinu.” Ige Iesu namigevei avoe, “Dana la namigevei loui kosea, ‘Ito. Ige la bae di hoto evilivebene. ");
INSERT INTO kpx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iale mesoho dana hoto mole loui la namigevege la bae ibinave loulivebene. ");
INSERT INTO kpx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Isito di hoto mole louge evive. Atae Eseu Dilava vuvune mai adave inuteve ugulamoi uveve vaniu vuguvuguanu.” ");
INSERT INTO kpx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kateai louge abu bahata namihai avoe, “Iale Dilava mo anike.” Ige au loui avoe, “La louale keu seleveike.” ");
INSERT INTO kpx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ige abu moleho loui avoe, “Nahi bae ata degomolemo ko vaveve kaovalivebene. Nahi hotove evige uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Abu bahata hovedeveime Iesu mai Loma gamani kosive Bailotie tilu. ");
INSERT INTO kpx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Keve tiale kosive ke namihai avoe, “No malaha ko vaveve kaovalata elehaike vaime mai loholu. Kou no ata aiogevei abuho loui avoe, ‘Lainaho takesi moni malei Loma gamani kosive Sisa omilive.’ Isi loui avoe, ‘Dau la kosive baluga Keliso.’” ");
INSERT INTO kpx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kateai louge Bailotiu Iesu namihai avoe, “Diue kosive anike ko.” Ige Iesuu loui avoe, “Ito, avuike a ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kateai louge Bailotiu dubu nalievemale kosive isi ata kebia namigevei avoe, “Di komo vaveveve toela kaovage uoholinu. Iale dana oleve kateai hamai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ige abu negobedai Bailoti namihai avoe, “Keu vasohuta Galili vatae tiale haive toela vai no ata aiogevenu. Iale aike Diudia vata komo ke nahate vama.” ");
INSERT INTO kpx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ige Bailotiu hotoeabe ke evisi namigevei avoe, “Galili ataniko.” ");
INSERT INTO kpx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ige abu loui avoe, “Ito.” Ige Bailotiu namigevei avoe, “Kosive mole Elodi keu Galili vatae kosive. Keu aike lohoale Dielusalemae ua. Iale ko mai avue teve.” ");
INSERT INTO kpx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ige abu mai Elodie tige au Iesu elehai vahaehoanu. Kosealemo ataeau Iesu vaveve vamale ke louge Elodiu vani moaga ke evisi isiviale Iesu elehai. Keu isiviale Iesuu vaveve nimolete vage au elehai. ");
INSERT INTO kpx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Katealemo au Iesu belahai avuemo vaveveve kaovalage Iesuu hotobehame loui namihaholinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ige dubu nalimale kosivea isi Diue menaka loui haivemale keau hovedevei Iesu vavamo lobolahai isuta Elodi namihai avoe, “Keu vaveve toela moaga vamale ataike.” ");
INSERT INTO kpx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ige Elodiu au tuvalie esemuhi Iesu hehavoi aiohavolu. Isime lobolahai kosiveu ogoe dua vamale ke nahate mai avuemo hatulu. Hatuge uoholige abu melavei tota hoidevei Bailotie tilu. ");
INSERT INTO kpx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Katealemoike Elodiu Bailotiti haokanu. Subuta abu moleho isiviholilu. Isito vani kemo abu avui molehi haokuvualu. ");
INSERT INTO kpx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Abu Iesu melavei Bailotie tige Bailotiu hoage dubu nalimale kosiveau, oe kosiveau isi oe ataeau loholu. ");
INSERT INTO kpx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ige au namigevei avoe, “Laeau malaha ko mai dae lohoale di namihai kosea, ‘Malaha kou no ata aiogevema.’ Ige di la hoto ke avuemo kaovaito toelabe elehaholinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ige Elodi keta toelavebe elehaholisi tota hanavoge lohonu. Iale malaha kou vavevebe toela vaholiale kemo di hamaveve humahau uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iale di esemu abuna visuhavoito iovage auna tai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iomaveve hotou koseanu. Vagana bahata Basova vani kena lohoge ataeabuna louge Bailotina dibulae ata igae iomage auna tigei. ");
INSERT INTO kpx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bailotiu hoto ke louge ata bahata keau baita namihai avoe, “Hamage au hatai. Isito no isiviale Balabasi ke iomage au tai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi keu ata havemale ataike. Subuta o kemo keu atae toela holoevei isiviale gamani aiohavoi. Ige abu mai dibulae mavoge ua. ");
INSERT INTO kpx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Isito Bailotiu isiviale Iesu iomage au tai. Iale tota hoai ata namigevei avoe, “Dana ko hanavoge auna tai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kateai abuho louge abuta avuho loui avoe, “Mai idimo hama.” Isi tota loui avoe, “Mai idimo hama.” ");
INSERT INTO kpx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ige au tota namigevei loui avoe, “Osialemo. Vaveve toela onoleu avuemo ua. Di vaveveve kaovanata kemo toelabe elehaholinu. Katealemo dana oleve kateai hamai. Iale di esemu abuna visuhavoime iovage auna tai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kateai lousege abu negobedai baita namihai avoe, “Mai idimo hama.” Ige dubu nalimale keau abuta katelahai negobedai hotove hamalu. ");
INSERT INTO kpx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ige au namigevei avoe, “Duave, dana la isivi unaha vai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kateai louito malaha nehe ata havei gamani aiohavomale ke iomanu. Isi abu abu isivi Iesuemo valiho mai ovenu. ");
INSERT INTO kpx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ige abu mai tialeau Sailini malaha mole ivi Saimoni keluvuta belehovolu. Keu bulue tialeu hoilahai oe lohoma. Iale abu adave butuhai namihai avoe, “Idi ko ebamo.” Ige au idi ke ebamoi Iesu ehomai iavela tinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Isege ata moagaeau ehovai timale kebia vigomo keate degomoleau avuho uvulahai ninalahama. ");
INSERT INTO kpx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kateisege Iesuu abue vudihei namigevei avoe, “Dielusalema keatea, lainaho daho ninalahalive. Isito la ebikaho uvulahai la esetaho uvulahai ninalahave. ");
INSERT INTO kpx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kosealemo vanie toelau lohoma. Iale vani kemo ataeabuna bae loui kosea, ‘Keate oleuoleu ese tobute maleholiale keau duave. Isi ese gite houeveholiale keau duave.’ ");
INSERT INTO kpx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vani kateimalela ataeabuna loui kosea, ‘Tana baluga isi eseve dobai no bamuevege no haluvisi.’ ");
INSERT INTO kpx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Dau idi isahete ke nahate. Isege laeau idi gilite ke nahate. Iale abu vaveve toela koseale daemo valiege vaveve toela baluga seleve abuna laemo vai.” ");
INSERT INTO kpx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Kateai louge tuvalie ataeau Iesu melavei dibulae ata abuita kebiata holoevei tiale ata havemale matamae velehovolu. Matama ke ivilike Lolokue matama. Matama keve abu Iesu mai idie domo hamai dibulae ata kebiata havelu. Moleu adave inuteveatae. Isege moleu agiteveatae. ");
INSERT INTO kpx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ige Iesu noinoiai avoe, “Mamai, vaveveabe toela uliha. Abu vaveve ko vamale ko abu hilokaholilu.” Kateai lousege tuvalie ataeau Iesu ogo maliho kasilahai ogove igaegaeai malelu. ");
INSERT INTO kpx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ige ataeau elehasege Diue kosive keau Iesu hehavoi moleho loui avoe, “Keu ata degomole tedaevenu. Isito Dilavau ke ebagemage keu Keliso holivatebene au ebika tedahoi dobai lohonu.” ");
INSERT INTO kpx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kateai lousege tuvalie ata kebiata hehavoi tiale e toela mai omilu. ");
INSERT INTO kpx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Isi loui avoe, “A Diue atae kosive holiniege a ebika tedahoi dobai lohonela.” ");
INSERT INTO kpx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kateai kinave tatamo hoto mole hisaliai avoe, “Kou Diue kosive balugaike ko.” ");
INSERT INTO kpx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ige abu dibulae ata mai hamale ke moleu hotoe toela loui Iesu belahai avoe, “Seleveta Keliso aniko. A Keliso holiniege a ebika tedahoi nota tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kateai louge moleu avuho loui avoe, “Hoto kateale louhalenela. Ana Dilava vabuhavoholinu. Nahiabuna avuluvuta haluvisi. ");
INSERT INTO kpx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nahiau vaveve toela vamale ataea. Iale ibinavehoike nahi vatehani ko malelu. Isito malaha keu vaveve toela vaholisito vatehani malenu.” ");
INSERT INTO kpx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kateai au haokaho louito Iesu namihai avoe, “Iesu, a Kosive baluga holisi a matamae doga kemo lohoniege di huhuanela.” ");
INSERT INTO kpx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ige Iesuu avuho loui avoe, “Di ahoe louge evinela. Ana nova daiti ukolikolie matama keve unela.” ");
INSERT INTO kpx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iniale vanie lilimo vata bahatamo vau loai gidualeu tili (3) okoloki masege vaniu tota halunu. ");
INSERT INTO kpx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Isege dubu baluga uvue abu ogo mai uvu mole tumute ke bamuale keu ehula dikolahai heila velemai abuita holinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isege Iesuu baita loui avoe, “Mamai, di aike hatima. Di isiviale daemo di munana manela.” Kateai louito hatinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ige tuvalie kosive keu vaveve ke elehai Dilava hoesehavoi loui avoe, “Seleveta ata keu atae dua.” ");
INSERT INTO kpx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Isege ataeau keve igaetoai vaveve ke elehalage uoholige abu halevai uvu balugata hoidevei abu oe tilu. ");
INSERT INTO kpx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Oe tisege Iesu haokuvu isi Galili keate degomole keau Iesu ehovamaleau bahata haeavamole lavisi vaveve ke elehalu. ");
INSERT INTO kpx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Alimatia malaha mole ivi Dioseba keu atae dua isi ata uvevete. Iale keu Dilavau Iesu hanavoale ke evisi huhuai avoe, “Kona no kosive baluga holige noeabuna vuvunevemo ui.” Isi kateai ke nihomai uma. Keu Diue kanisoloe kosive. Iale kanisolo keau Iesuemo vaveve kateale vage keu keho isiviholinu. ");
INSERT INTO kpx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iale keu Iesu vava mai abavuho tiale gamani kosive Bailoti belahanu. Isi loui avoe, “Dana vali Iesu vava mai talive abavui.” ");
INSERT INTO kpx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ige Bailotiu louge au tialeu Iesu vava mai ogoe duata viliai munee vahamo abu subuta kemo atabe mai gulioholiale kemo mai gulianu. ");
INSERT INTO kpx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kateisege bulau loholiho vage vau loai lohoma. ");
INSERT INTO kpx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Isege Galili keate nehe keau Diosebaluvuta tiale au Iesu vava mamoi abavuale ke elehalu. ");
INSERT INTO kpx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Isime halevai oe tialeau mulamulae dua malei Iesu vava hoesehavoliho bevualu. Isege bulau lohoge abu halevai menaka ehovai bulamo ua. ");
INSERT INTO kpx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Iliale Sande vavita vae hodohodota keate keau mulamula nehe bevuale ke malei Iesu vutae tilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tiale keve velehovoge mune balugau Iesu vuta bamuale keu vovolovai badive ua. ");
INSERT INTO kpx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ige abu mune ke vahae tialeau isiviai Iesu vava elehai. Isito abu tiale elehaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Isi keve lavisi ke huhulahai dolodololahasege malaha mole abuita ogo levolevote vale keau solekavesite abue loholu. ");
INSERT INTO kpx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ige keate keau vabulahai kome bokoai vata bisi holuiavolu. Ige malaha keau namigevei avoe, “Kou alue vutae matama. Iale la osiohoike kove atau nita uale ke kaovama. ");
INSERT INTO kpx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Keu komo uoholinu. Dilavau etuvage keu hovelahanu. Au Galilie ui laheho louale ke lana huhulahalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Au loui avoe, ‘Ata molena Atae Eseho haiai mai atae toela ovege abuna mai idie domo hamai. Iniege vanie ni abuita igaetaeabuna uoholige auna tota hovelahai.’” ");
INSERT INTO kpx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kateai louge keate keau Iesu hoto ke huhulahalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Isi vutave halevai hoidevei tiale vaveve ke loui Iesu abostolo leveni (11) kebia haivei esemu bahata kebiata haivelu. ");
INSERT INTO kpx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Keate kebia iviabeike koea. Meli Magidaleni, Dioana, Diemisi neina Meli isi keate degomole. ");
INSERT INTO kpx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ige Iesu esemu keau hoto ke evisi loui avoe, “Lana tilogoike vaime loboe hoto ke louma.” Isi kateai hotoeabe evioholilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Isito Bitau ke evisi hovelahai bibuai tiale vutavela velemanu. Isi holumai ke vahae niai elehage abu viliale ogo ke unahau ua. Ige au hoilahai au oe tiale vaveve ke huhuai avoe, “Vaveve kou oleve kateanu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vani ke igaemo Iesu esemu abuita keau olahai o mole ivi Emeasi keve tilu. Dielusalema halei o keho tiale egeveu haeava sisina ada mole isi abui. ");
INSERT INTO kpx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Abu avui taime humaha tavae abu Iesuemo vaveve vamale ke moleho loui tima. ");
INSERT INTO kpx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Katelahai ke lousege Iesuu iaeabe tialeu abuemo tinu. ");
INSERT INTO kpx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ige abu elehaito ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ige Iesuu namigevei avoe, “La avui ono vadeike moleho loui lohoma.” Kateai louge abu avui lavisi uvulahalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ige malaha mole ivi Keliobasi keu namihai avoe, “Ata bahata Dielusalemae umale keau vaveve moleu aike Dielusalemae velemale ke hilokalu. Isito a igaenike ke hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ige au belagevei avoe, “Vaveve onoleike.” Ige abu loui avoe, “Vaveve kosealeike abu valu. Nasaleta malaha mole Iesu keu belovetae ata. Iale Dilavau vuvune omige au vaveve nimolete vai hoto vuvunete louge ata bahataeau ke elehai vahaeholahai hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Isito no dubu nalimale kosive isi oe kosive keau ke mai gamani ata ovege abu loui avoe, ‘Auna hatai.’ Isime mai idie domo hamalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","No subuta huhulahai kosea, ‘Kena bae kosive holisi Iselala ata tedaevei.’ Isito keu hatiale aike vanie ni abuita igaeta uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ige nova vavita no keate degomoleau hoto mole louge no ke evisi vikolahalu. Abu vae hodohodota tialeau vutave velehovolu. ");
INSERT INTO kpx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Keve velehovoi Iesu vava kaovage uoholinu. Isime hoidevei lohoale no namigevei avoe, ‘No anelu abuita elegevege keau no namigevei avoe, Keu hovelahanu.’ ");
INSERT INTO kpx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Isege no ata degomoleau vutave tiale elehage uoholige abu loui avoe, ‘Keate keau hoto seleveike abu loulu.’” ");
INSERT INTO kpx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Abu deiada ke louge uoholige Iesuu namigevei avoe, “La keau vaveve kemo luleleholilu. Isi belovetaeau louale hoto ke la solekai evisi maholilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Belovetau louale ke nahate Kelisona vatehani malei hatai hovelahai tota au otogoe ataga nehe ke mai. Lana ke hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kateai louito subuta Moseseu hotove hisaliale isi beloveta bahataeau hisaliale ke loui kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Au kateai haivelage abu tiale o nehe abu avue tiveve ke vavae loholu. Isege Iesuu isiviale eve tai. ");
INSERT INTO kpx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Isito abu negobedai kelulahai namihai avoe, “Vau loalelua nohehi unela.” Ige au tiale abuhi ua. ");
INSERT INTO kpx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iniale abuhi lovi iliho uguiavosege au valava mai hoesehavoito vakoai malei ovenu. ");
INSERT INTO kpx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kateai lovi ovesege niabeu alamo seleveage abu bae lulelelahai Iesu hilokalu. Isege au solekavesite uoholinu. ");
INSERT INTO kpx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ige abu mole namigevei avoe, “Keu humaha tavae nahehi hotohotoai Bukae Hoto loui nahi haiveale hotove keu venee nahate vanu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Abu kateai louito solekai hovedevei Dielusalemae hoidevelu. Keve velehovosege Iesu esemu leveni (11) isi esemuve degomole keau igaetoai uliale kebia namigevei avoe, “Seleveta Iesuu hovelahai Saimoni Bitae lohoge au elehanu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ige malaha abuita keau abuta namigevei avoe, “Nota humaha tavae katelahalu. Isito no Kosive ke hilokaholilu. Ige au valava vakoai noevesege no bae hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ata abui keau kateai namigevesege Iesuu solekavesite vigoeabemo lamisi ua. Isi namigevei avoe, “Lana ue dua vama.” ");
INSERT INTO kpx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ige abu ke elehai huhulahai avoe, “Mesoho aluike no ko elehalu.” Isime vabue toela valu. ");
INSERT INTO kpx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Katelahage au namigevei avoe, “Osiohoike la uvuu kibikibianu. Oleve katealemoike la uvuu dolodoloanu. ");
INSERT INTO kpx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Isito di adau di veloti samagulahale ko elegeveve. Dailike ko. Dau alu holioholinu. Alu keau misioholisi itavaholilu. Isito dau kateholinu. Iale daela holisi hilokave.” ");
INSERT INTO kpx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kateai namigeveito au ada isi au velo malei haivenu. ");
INSERT INTO kpx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ige abu ke elehai vahaeholahaito ke huhulahai dolodololahalu. Isege au belagevei avoe, “La ivevebena ua.” ");
INSERT INTO kpx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kateai louge abu huena mole mahoale ivi mai omilu. ");
INSERT INTO kpx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ige au ke mai vudiabemo inu. ");
INSERT INTO kpx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Isi namigevei avoe, “Di subuta lahehi ui hoto koseale loui la namigevenu. ‘Di vaveve bahata Moseseu subuta hisaliale, belovetaeau hisaliale isi Samusimo hisaliale keabuna bahata seleve holisi.’” ");
INSERT INTO kpx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kateai louito uvuiabe alavoge abu bae Bukae Hoto kemo lulelelahalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ige au haivei avoe, “Bukae Hotou louale Kelisona vatehani malei hatiniege vanie ni abuita igaetaeau uoholisege auna tota hovelahai. ");
INSERT INTO kpx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Auna hovelahage ataveabuna ivivemo ata haivei namigevege abuna vaveve toela halevage Dilavana ulihai. Ige abuna vasohuta Dielusalema kove ata haiveito gabie bae vata bahatae tai ata haivei. ");
INSERT INTO kpx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bukae Hotou louale keu seleve holige la vaveve ke bahata elehai hilokalu. ");
INSERT INTO kpx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Isito kove usege di Mamau louale ke di di Munana Tumute hanavoge au la malevei negotievei.” ");
INSERT INTO kpx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iesuu hoto ke louge uoholige au au esemu holoevei Dielusalemae halei Beteni oe tinu. Keve tiale au ada ebagemai kebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hoesegeveito halevei otogoe veatisi tinu. ");
INSERT INTO kpx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Veatisi tisege abu hoesehavoito halevai vahaehota hoidevei Dielusalemae loholu. ");
INSERT INTO kpx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iliale vani bahata Diue dubu baluga keve Dilava hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Vatau uoholisege Hotou ua. Hoto keu Dilavati subuta ua. Iale Hoto keike Dilava. ");
INSERT INTO kpx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vatau uoholisege Hoto keu Dilavati ua. ");
INSERT INTO kpx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Avuemoike Dilavau onobenobe bahata vaevenu. Keu uoholivatege onobenobe bahata keau uoholilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kemoike ukolikoliu ua. Iale keu ataga mai vatae lohoalemo vatae ata bahataeabuna atagave elehai. ");
INSERT INTO kpx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Atagave keu vata kove haluge vavie vaveve keau atagave ke ehodovaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hoto kemoike Dilavau au hoto louveve ata mole ivi Dioni hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ige keu lohoale atagae hoto loui ata haivenu. Ata haivei isivialeike abu hoto ke evisi ehovai. ");
INSERT INTO kpx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dioni keu ataga ke holioholinu. Isito keu lohoale atagae hoto loui ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ataga keu ataga seleve. Iale ataga keu lohoale vatae ata bahatamo halunu. ");
INSERT INTO kpx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Keu lohoale vatae ua. Keike vata vanu. Isito vatae ataeau valitisi hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Keu vatae lohoale au ata haivege keau hotove evioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Isito degomoleau igaegae hotove evisi abu uvu mai avuemo mavolu. Ige au au vuvunemo abuho loui avoe, “Laeau Dilava esea.” ");
INSERT INTO kpx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ataeau ese houeveale kemo abu Dilava ese holioholilu. Isi vavae isivi mesoho atae isivi kemo keau Dilava ese holioholilu. Isito Dilava isivimoike abu eseve holilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hoto nehe keu ata holisi nahehi ua. Ige nahi ke elehage vaveveve keu seleve unaha. Ige keu au uvu mai nahiovei nahi tedaeveale keu duave unaha. Ige nahi atagave ke elehai hilokage Mamaveike au ataga ke mai au mo igae ominu. ");
INSERT INTO kpx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ige Dioniu hotove loui ata namigevei avoe, “Di subuta ata ke deiadaike laheho lounu. Di loui kosea, ‘Ata molena bae di ehomai lohoi. Keu di evihale Kosive. Kosealemo di uoholisege keu subuta ua.’ Iale ata keike.” ");
INSERT INTO kpx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ata keu Kosive baluga. Iale keu au uvu bahata mai nahiovei nahie hoesegevei vani bahata nahi tedaevema. ");
INSERT INTO kpx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dilavau au menaka mai Mosese omiale kemo ataeau vaveve toela vage ke ibina abuna hatihati malei. Isito Iesu Kelisou hatiale kemo Dilavau nahi huhuevei nahie toela ulihai au hotoe dua mai nahiovenu. ");
INSERT INTO kpx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Atabeu Dilava elehaholinu. Isito uvuve mo igae keu lohoale au Mamae hoto loui nahi haivege nahi Dilava vaveve hilokalu. ");
INSERT INTO kpx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Vani mole Diue kosive Dielusalemae umale keau dubu nalimale ata degomole hanavege abu Dioni belahaliho tilu. Abu tiale namihai avoe, “Ole a.” ");
INSERT INTO kpx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ige Dioniu lobogeveholisito inuta namigevei avoe, “Dau ata tedaevemale kosive Keliso ke holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ige abu namihai avoe, “Ana Ilaidianike.” Ige Dioniu namigevei avoe, “Dau beloveta ke holioholinu.” Ige abu tota belahai avoe, “No beloveta mole hemei umale ke aniko.” Ige au loui avoe, “Ba, dau ke holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kateige abu loui avoe, “A ivi a vaveve loui no namigevenela. Ige no hoidevei talive no kosive kebia namigevei.” ");
INSERT INTO kpx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ige Dioniu namigevei avoe, “Subuta beloveta mole Aisaia keu ata mole vaveve lounu. Au loui avoe, ‘Ata molena bae botoe hoai kosea, Kosive humaha ke inuta loive.’ Beloveta keu louale ata ke daliko.” ");
INSERT INTO kpx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Dioniu kateai lousege Balisia ataeau abu ata hanaveale nehe keau tota Dioni belahai avoe, “A loui kosea, ‘Dau ata tedaevemale Keliso ke holioholinu.’ Isi a loui kosea, ‘Dau Ilaidia holioholinu. Isi beloveta ke holioholinu.’ Isito osialemoike a emo ata babatisogevema.” ");
INSERT INTO kpx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kateai louge Dioniu namigevei avoe, “Di e unahamo ata babatisogevema. Isito kosive moleu la vigomo uale ke la hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ata kena gabie lohoniege kosive baluga holisi di evihai. Iale di ivite holialebene bae tamakave tohoai. Isito dau ivite holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dioniu Diodani e ke vaki mole ui hoto ke bahata lounu. O mole ivi Beteni keve ui e kemo ata babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Vani mole Dioniu elehasege Iesuu avue lohonu. Ige au ata namigevei avoe, “Elehave. Dilava mamoe eseike uoke lohonu. Dilavau ke hanavoi isiviale au hatai vatae atae toela ulihai. ");
INSERT INTO kpx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ke hotoike di subuta la namigevei laheho loui kosea, ‘Ata molena bae di ehomai lohoniege di evihai. Kosealemo di uoholisege keu subuta mole ua.’ ");
INSERT INTO kpx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Di subuta ata ke hilokaholinu. Isito di lohoale emo ata babatisogevemale kemo isiviale Iselala ata nahiau ata ke hilokai.” ");
INSERT INTO kpx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hoto ke louito tota abuho loui avoe, “Di vani kela Iesu emohavoito elehasege Munanae Tumuu ugu mole imutava ke nahate holisi otogomo dobai lohoale avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dilavau di namihaholivatege di ke hilokaholinu. Isito Dilavau di namihale kemoike di ke hilokanu. Au daho loui avoe, ‘Ana elehasege Munanae Tumuna lohoniege ata molemo ui. Iale ata kena bae au Munanae Tumu hanavoi ke vuvunemo ata hoesegevei.’ ");
INSERT INTO kpx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dilavau daho louale kemo di ata uoke elehai hilokage keu Dilava mo. Iale di hoto loui la namigeveale ke evive.” ");
INSERT INTO kpx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Vani mole Dioniu au esemu abuitati lavisi usege Iesuu ohanoi tisege Dioniu elehai au esemu namigevei avoe, “E, Dilava mamoe eseu lotiale uoke elehave.” ");
INSERT INTO kpx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ige esemuve abui keau hoto ke evisi Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ige Iesuu hoilahai kebia elegevei abuho loui avoe, “La oleve tima.” Ige abu namihai avoe, “Kosive, a oleve uma.” ");
INSERT INTO kpx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ige Iesuu abuho loui avoe, “Loholive di umale ke elehave.” Ige abu avuluvuta tiliale au umale ke elehalu. Isege vau dobai gutuige abu avuluvuta ua. ");
INSERT INTO kpx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ata abui keau Dioni hoto evisi Iesu ehovai lohoale ke mole ivilike Andulu. Keu Saimoni Bita hoho. ");
INSERT INTO kpx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iale keu halei tiale au nana elehai namihai avoe, “Nahie ata tedaevemale kosive Keliso ke no elehalu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kateai louito au nana melamei Iesue lohonu. Ige Iesu elehai avuho loui avoe, “A ivilike Saimoni. Au Dioni mo. Isito dana a ivie doga ivihai aho loui kosea, ‘Sibasi.’” Iesuu kateai Saimoni Bita ivihale ke ihuike mune. ");
INSERT INTO kpx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vavita Iesuu isiviale Galilie tai. Isi tialeu Bilibi elehai avuho loui avoe, “Lohoge naiti tai.” ");
INSERT INTO kpx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Bilibi keu Betesaida ata. Ige Andulu isi Bita kebiata avuluvuta o igae. ");
INSERT INTO kpx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ige Bilibiu tiale ata mole Nataniela namihai avoe, “Moseseu subuta Bukae Hotomo hoto mole hisaliai avoe, ‘Nahie tedaevemale Kosive molena bae lohoi.’ Ige beloveta kebiata au lohoveve hoto ke igae loulu. Iale no ata ke elehalu. Keu Nasaleta ata mole Dioseba ke mo. Iviveike Iesu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ige Natanielau belahai avoe, “A huhuige Nasaleta o kemo vavevebe duana vali lohoi.” Ige Bilibiu namihai avoe, “Lohoge nahi talive elehai.” ");
INSERT INTO kpx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kateige abu tige Iesuu Nataniela elehai vaveveve lounu. Isi loui avoe, “Ata kou Iselala ata seleve. Kou loboe ata holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ige Natanielau belahai avoe, “A oleve kateike vaime di hilokanu.” Ige Iesuu avuho loui avoe, “Bilibiu a hohavoholisege a idi mole ivi vigi ke umukamo ugulamoi usege di a elehanu.” ");
INSERT INTO kpx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ige Natanielau avuho loui avoe, “Kosive, au Dilava mo. A keu Iselala ata no Kosive baluga.” ");
INSERT INTO kpx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ige Iesuu avuho loui avoe, “A idi ke umukamo ugulamoi uale ke di aho louike vage a uvu mai daemo mamonu. Isito di vaveve degomole abuna di aho louale ke evihage ana bae elegevei vikoa.” ");
INSERT INTO kpx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kateai avuho louito kebia bahataho loui avoe, “Di hoto seleve loui la namigevei. Gabie otogou dailahasege Dilava anelu abuna Atae Ese vavamo dobuluvisi vealuvige lana elehai hilokage Dilava vuvuneu avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Vanie ni abuita uoholisege Galili vata keve Keina ataeau mole holoeveve lovi valu. Ke vamale keve Iesu neinata ua. ");
INSERT INTO kpx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ige abu Iesuta esemuiabetaho louge abu lovi ke iliho loholu. ");
INSERT INTO kpx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Loholiale abuhi lovi ilu. Isi uaini ige uoholige Iesu neinau Iesuho loui avoe, “Uainibeu uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ige Iesuu au neinaho loui avoe, “Ainaho di onole vaveve ke daho loulive. Kosealemo di ke vaveve vaniu lohoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kateai louge neinaveu lovi vamale kebia namigevei avoe, “Au onole laheho louge ke vave.” ");
INSERT INTO kpx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kateisege Diue ataeau tauli debamo vale bahata sigisi(6) abu avuemo e hai ada totoimale keau keve ua. Tauli keau baluga. Isito oteve unaha. ");
INSERT INTO kpx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ige Iesuu lovi vamale kebia namigevei avoe, “E hai tauli kebia ovege abu tobalohoi.” Ige abu e hai tauli kebiamo keohage keau ililoholu. ");
INSERT INTO kpx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ige Iesuu namigevei avoe, “Aike e ke hai mai talive mole holoevevemo hoto louveve ata ke omive.” Kateai namigevege abu e hai tiale omilu. ");
INSERT INTO kpx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ige malaha keu e ke ige heanu. Isito hilokaholinu abu oleveike uaini ke mai loholu. Isito e ke hale esemu keau hilokage Iesulike ke vanu. Ige malaha keu ma melameveve mo ke hohavoge au avue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ige au namihai avoe, “Ataeau mole holoevemale vani kemo abuna vasohuta uainie dua hai ata ovei. Ige ataeabuna e ke ige uniabeau hanilahage abuna deive ke malei ata ovei. Isito au kateholinu. No vasohuta iale keu aike ko he nahate va holioholinu. Isito a uainie dua ko hai noevege no ige keu noemo he seleveanu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesuu vasohuta au vikoe vaveveike au ke vage Keina ataeau Galili vatae uale keau vuvuneve vaveve ke elehalu. Ige esemuiabeta ke elehai kemo bae abu uvu mai avuemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ige ke iae Iesu, neinave, hohuvuiabe isi esemuiabe keau o ke halevai o mole Kabenumu keve ua. ");
INSERT INTO kpx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Abu keve usege vani degomoleau uoholisege Diue atae vahaeho vani baluga Basova keu vuguvuguanu. Ige Iesuu Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tiale keve velemai elehasege Diue ataeau abu dubu baluga ke uvue bolomakau, mamoe, ugu kebia maketilahama. Isege moni senisilahamale keau keve uguiavoi moni senisilahama. ");
INSERT INTO kpx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ige Iesuu kebia elegevei hote kikia mai bolomakau mamoe kebia havei nunuvege abu bahata detuluvisi heie tilu. Isi moni senisiamale kebia teibolo ekovehage moniabe keau keiohovolu. ");
INSERT INTO kpx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Isi ugu maketilahamale kebia namigevei avoe, “Ke malei heie teve. Lainaho di Mamae o komo maketi vaveve vagelive.” ");
INSERT INTO kpx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kateige Iesu esemuiau ke elehai Bukae Hoto mole huhulahalu. Hoto keu loui avoe, “Kosive, abu a o aiohavoale ke di huhuage di uvuu tumuanu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kateige Diue kosiveau belahai avoe, “Ana vikoe vaveve onole igae vage no ke elehai kemo hilokage vuvune kemoike a vaveve kateale vanu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ige Iesuu namigevei avoe, “Dubu ko koiage vani abuita igaeta uoholige dana tota houi.” ");
INSERT INTO kpx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ige abu ke evisi namihai avoe, “A huhuige vanie ni abuita igaeta ke uvumo ana o ko houi gabiai. Ana hilokaholinu. Abu vagana voti sigisi (46) uvumo dubu ko houi gabilahalu. A louale keu anekianu.” ");
INSERT INTO kpx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Abu katelahai loulu. Isito Iesuu dubu ke louholisito au ebikahoike au ke lounu. ");
INSERT INTO kpx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kateai louniale gabie hatai hovelahage esemuiabeau Iesuu louale hoto ke huhulahai avoe, “Bukae Hotou louale isi Iesuu louale hoto keau hoto seleve.” ");
INSERT INTO kpx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesuu Basova vani kemo Dielusalemae usege ata moagaeau abu uvu mai avuemo mavolu. Kosealemo Iesuu vikoe vaveve vaevege abu elehalu. ");
INSERT INTO kpx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Isito Iesuu uvuiabe hilokale kemo au uvu mai abuemo mamoholinu. Kosealemo ata kebiau isiviale vikoe vaveve elehaito bae abu uvu mai Iesuemo mavoi. ");
INSERT INTO kpx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Atabeu vaveveabe ke loui namihaholinu. Isito biageu uvuiabe hilokai gabianu. ");
INSERT INTO kpx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dielusalema o kemo Diue kosive mole Nikodimasi keu ua. Keu Balisia atahi vaveveabe vamale. ");
INSERT INTO kpx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iale keu vavi mole Iesue lohoale namihai avoe, “Kosive, no hilokage Dilavau a hanavoge a keu no haivemale kosive. Atabeu bae vikoe vaveve ke va kavalivebene. Isito Dilavau avuemo u hutevage bae kateale vai.” ");
INSERT INTO kpx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ige Iesuu namihai avoe, “Seleveta di a namihage evinela. Atabeu bae Dilava matamae doga keve talivebene. Isito auna vasohuta u moleaito bae keve tai.” ");
INSERT INTO kpx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ige Nikodimasiu belahai avoe, “Ataeau kosi holiale keabuna oleve kateai tota u moleai. Keau abu neinuvue unie uvue tai tota uveve keu anekianu.” ");
INSERT INTO kpx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ige Iesuu namihai avoe, “Seleveta di a namihai. Ata oleuoleu eta Munana Tumutamo uale kebia unahae abuna Dilava matamae doga keve tai. ");
INSERT INTO kpx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ata oleuoleu abu neinuvumo uale keau ataelea. Isito oleuoleu Munana Tumumo uale keau Munana Tumuelea. ");
INSERT INTO kpx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Katealemoike di aho loui kosea, ‘Tota u moleanela.’ Iale kemo ainaho vikoalive. ");
INSERT INTO kpx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Helukau heiata utuai tai lohoge ana umuve ke evinela. Isito keu oleve tai lohoale ke a hilokaholinu. Iale oleuoleu Munana Tumumo uale keau ke nahate. Iale hoto kemo ainaho vikoalive.” ");
INSERT INTO kpx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kateai louge Nikodimasiu belahai avoe, “Vaveve kena oleve kateai.” ");
INSERT INTO kpx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ige Iesu namihai avoe, “A keu Iselala ata haivemale kosive mole baluga. Isito a di hoto kemo luleleholinu. ");
INSERT INTO kpx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iale seleveta di hoto ko loui a namihage evinela. No onole elehai loui hilokale ke laheho louge la kemo la uvu mavoholilu. ");
INSERT INTO kpx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Di vatae hoto laheho louge la di hoto ke maholilu. Iale dana otogoe hoto laheho louge lana oleve kateai bae di hoto mai. ");
INSERT INTO kpx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atabeu otogoe ui avuemo dobai lohoholinu. Isito Atae Eseu avuemo ui dobai lohoale ke igaena tota veatai tai. ");
INSERT INTO kpx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Subuta Iselala ataeau tomagie tiale vaveve toela vage Moseseu kobamo ute vai mai idimo ehanumage ataeau ke elehai haluviholisito nita ua. Iale ke nahate ataeabuna Atae Ese mai idie domo hamai. ");
INSERT INTO kpx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ige oleuoleu abu uvu mai avuemo mavoale keabuna ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dilavau vatae ataho isivi balugale kemoike au au mo igae mai vatae hanavonu. Ige elike ataeau abu uvu mai avuemo mavoliege abu bae haluvilivebene. Isito abuna ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dilavau au mo hanavoale keu vatae ataemo kotaho lohoholinu. Isito vaveveabe toelamoike au maleveho lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Iale oleuoleu abu uvu mai movemo mavoge au bae kebiamo kotalivebene. Isito ataeau abu uvu mai Dilava mo igaemo mavoholiale kemo Dilavau subuta kotae hoto loui mamoale kena kebia malevei. ");
INSERT INTO kpx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Atagau subuta vatae lohoge ataeau ataga ke kabebihavoi vaviho isivilahale kemo Dilavana malevei hoto balugamo otovei. Kosealemo vaveveabe keu toelanu. ");
INSERT INTO kpx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iale ata oleu vaveve toela vamale keu atagaho isiviholisi bae atagae loholivebene. Kosealemo keu isiviholialeike ataga keu vaveveve toela kemo atagaho. ");
INSERT INTO kpx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Isito ata oleu vaveve dua vamale kena atagae lohoge atagana vaveveve kemo haluge ataeabuna hilokage vaveveve keu Dilavamo lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iesuu hoto ke louito au esemu holoevei Diudia vatae tinu. Iliale vani degomole keve abuhi ui ata babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Isege Dioniu Salimi o ke vavae o mole ivi Anoni keve ata babatisogevema. Kosealemo keve e balugau ua. Kemoike au keve usege ataeau tige au kebia babatisogevenu. ");
INSERT INTO kpx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Abu Dioni mai dibulae mavoholilike vasege au lovi ke vanu. ");
INSERT INTO kpx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Isege Dioni esemu degomoleau babatisoamale vaveve ke loui Diue atahi moleho louma. ");
INSERT INTO kpx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Katelahaito halevai Dionie tilu. Tiliale namihai avoe, “No kosive, malaha moleu Diodani e vaki mole ae lohoale ke ana huhuanu. A ke vaveve noheho lounu. Iale keu aike ata babatisogevege ata bahataeau avue tima.” ");
INSERT INTO kpx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ige Dioniu namigevei avoe, “Isito Dilavau lovi igaegae nahioveale ke nahiabuna vai. ");
INSERT INTO kpx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Laeau di hoto louale ke evilu. Di la namigevei kosea, ‘Dau ata tedaevemale kosive Keliso ke holioholinu. Isito Dilavau di hanavoge di keho uli holinu.’ ");
INSERT INTO kpx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iale kemo di hoto mole louge evive. Ma melameveve mo kena ma melamei. Ige haokaveu vavavemo lamiale kena hotove evisi vahaehoai. Iale ke nahate di Iesuu lohoale hoto ke evisi vahaehoanu. ");
INSERT INTO kpx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ataeau ke ivi ebagevage ke iviu di ivi evihale keu duave. Isege di iviu dobale keta duave.” ");
INSERT INTO kpx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","32","“Iale ata keu otogomo lohoale keu ata bahata evigevei baluganu. Ata oleu vatae ata holiale kena vatae hoto lougei. Isege otogomo lohoale auna ata bahata evigevei au ehue onole elehai eviale ke lougei. Isito ataeau bae hotove evilivebene. ");
INSERT INTO kpx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iale ata olena hotove eviniege kemo hilokage Dilava keu seleve. ");
INSERT INTO kpx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dilavau hanavoale ata kena Dilava hoto lougei. Kosealemo Dilavau au Munanae Tumu mai omige keu avuemo vuvuneanu. ");
INSERT INTO kpx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dilavau isivi au mo omisi onobenobe bahata malei omige au au negomo ke bahata nibievema. ");
INSERT INTO kpx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iale oleuoleu abu uvu mai avuemo mavoliege abuna ukolikoli malei. Isito oleuoleu abu uvu mai Dilava mo kemo mavoholiliege abu bae ukolikoli malelivebene. Ige Dilava itumuna vani bahata kebiamo ugei.” ");
INSERT INTO kpx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Balisia ataeau evige Iesuu ata moaga malevei babatisogeveale keu Dioni evihanu. ");
INSERT INTO kpx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Isito Iesuu atabe babatisogeveholinu. Esemuiabe unaha abuike ata babatisogevelu. ");
INSERT INTO kpx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Ige Iesuu abu hoto louale ke evisi Diudia vata halei Galili vatae taliho Samalia vatae velemai tinu. ");
INSERT INTO kpx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tiale keu Samalia o mole ivi Saika keve velemanu. O ke vavamo Diekobou subuta au vata mole mai au mo Dioseba ominu. ");
INSERT INTO kpx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iale vata kemo Diekobo e abatau ua. Iale Iesuu oai lohoalelua enuai kabebiai e abata ke vavamo ugulamoi uma. ");
INSERT INTO kpx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Keve ugulamoi usege esemuiabeau halevai taunie lovi voilahaho tilu. Isege vanie vigoe Samalia keate moleu e haliho lohonu. Ige Iesuu avuho loui avoe, “E hage di isi.” ");
INSERT INTO kpx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ige keate keu namihai avoe, “Au Diue ata. Isege dau Samalia keate. Iale osialemoike a isiviale di e hai aoge a isi.” Keate keu hoto ke louale keu koseanu. Diue ataeau bae Samalia atahi kabu igaemo e igelivebene. ");
INSERT INTO kpx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ige Iesuu keate ke namihai avoe, “A Dilavau onobenobe ata ovemale ke hilokai aiti hotoimale keta hilokavatebe a di namihage di ukolikoli e mai aonu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ige keate keu avuho loui avoe, “Kosive, e kou heila ua. Iale a e bagu mai lohoholialemo ana oleve kateai ukolikoli e hai daoge di isi. ");
INSERT INTO kpx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","No buluve Diekobo keu subuta abata ko lovoi kemo e isi e hai au eseta au ovota ovenu. Iale ose a ke evihanu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ige Iesuu avuho loui avoe, “Ata oleu e ko iale kena tota enuai. ");
INSERT INTO kpx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Isito di e mai ata oleme ovege abu iale keau bae tota enulahalivebene. Isito ukolikoli e kena uvuiabemo hanage abuna uveve doga malei.” ");
INSERT INTO kpx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ige keate keu avuho loui avoe, “Kosive, avage e ke hai daoge di isi. Ilive elike enuholisi e ko haliho tota loho halei.” ");
INSERT INTO kpx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kateige Iesuu namihai avoe, “Talive a kolia melamei tota kove lohonela.” ");
INSERT INTO kpx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ige keate keu namihai avoe, “Dau koliaholinu.” Ige Iesu namihai avoe, “Seleveike a ke lounu. A aike koliaholinu. ");
INSERT INTO kpx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Isito a subuta malaha ada mole holoeveito kebia halevenu. Isi aike a moleti umale keu a kolia seleve holioholinu. Iale a daho louale keu seleve.” ");
INSERT INTO kpx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kateai avuho louge keate keu namihai avoe, “Kosive, di huhuige au beloveta ata. ");
INSERT INTO kpx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","No buluveau subuta tana komo guligulilahalu. Isito Diue ata la loui kosea, ‘Ataeabuna Dielusalemae Dilava hoesehavogei.’” ");
INSERT INTO kpx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ige Iesuu avuho loui avoe, “E, di hoto louale ko evinela. Vani molena lohoge ataeau bae tana komo mesoho Dielusalema o kemo nahie Mama hoesehavolivebene. ");
INSERT INTO kpx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samalia ata laeau la guligulilahamale ke ihu hilokaholilu. Isito Diue ata noeau no guligulilahamale ke ihu hilokalu. Kosealemo Diue ata noemo Dilavau toelamo ata maleveve kosive hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iale vanive keu aike lohonu. Iale guliguli seleve vamale keabuna abu uvu bahatamo vaveve seleve unahamo nahie Mama hoesehavoi. Ata kateale biahoike Dilavau isiviale keau hoesehavogei. ");
INSERT INTO kpx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dilava keu ata holioholinu. Isito keu munanae tumu. Iale oleuoleu Dilava hoesehavoliho valiege abu uvu bahatamo vaveve seleve unahamo hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kateai louge keate neheu namihai avoe, “Di hilokage abu ata tedaevemale kosive ke ivihai avoe, ‘Keliso.’ Iale di evige kena lohoniege no onole vamale ke bahata noheho loui.” ");
INSERT INTO kpx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ige Iesuu avuho loui avoe, “Ata ke dailiko aho louma.” ");
INSERT INTO kpx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kateai lousege esemuiabeau hoidevei lohoge Iesuu keate keti hotohotoima. Ige abu ke elehai vikolahalu. Isi isiviale keate ke belahai avuho loui kosea, “A onole vama.” Isi isiviale Iesuho loui kosea, “A osiohoike keate keti hotohotoima.” Katelahai huhulahaito abuho hotobe louholilu. ");
INSERT INTO kpx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Abu lohoale velehovosege keate keu au e bagu halei oe tiale ataho hoto ke lounu. ");
INSERT INTO kpx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Isi namigevei avoe, “Lohoge nahi talive malaha mole elehai. Malaha keu di vaveve bahata vamale ke daho lounu. La huhuige nahie ata tedaeveve kosive Keliso kenike.” ");
INSERT INTO kpx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kateai louge ataeau o halevai Iesue loholu. ");
INSERT INTO kpx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Isito abu lohoholisege Iesu esemuiau avuho loui avoe, “Kosive, lovi mai inela.” ");
INSERT INTO kpx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ige Iesuu abuho loui avoe, “Di lovi iale ke la hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ige abu ke evisi abu moleteho loui avoe, “La huhuige ata moleu lovi mai ominu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kateale huhulahasege Iesuu namigevei avoe, “Di lovi keu koseanu. Dana di hanavoale ke isivi vai au lovi daoale ke vai gabiai. ");
INSERT INTO kpx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Isito la loui kosea, ‘Bata abuita abuita uoholisege lovina bae baeai.’ Iale di la namigevege evive. Nenilahai bulu elegeve dua vave. Lovi keau baelahage maleveve vaniu lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ata molena lovi hai. Ige keu baege molena lovi ke lovoi. Iale ke nahate ata molena Dilava hoto loui ata haivei. Ige ata molena lohoniege tota kebia haivei malevege abuna ukolikoli malei. Ige ata abui keabuna abu lovi kemo ibinae dua malei vahaeholahai. ");
INSERT INTO kpx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hoto keu seleve. Ata molena lovi hasege molena bae lovoi. ");
INSERT INTO kpx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Dana ata degomoleau lovilahale keve la hanavege lovi maleliho teve. Isito lana loviabe teige kemo tota lovi degomole maleve.” Iesuu kateai lovie hoto au esemuho lounu. ");
INSERT INTO kpx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Ige Samalia ataeau avue loholiale namihai avoe, “Loholive nohehi unela.” Kosealemo keate keu abuho loui avoe, “Keu di ono vade vamale ke bahata daho lounu.” Ige abu hotove evisi abu uvu mai Iesuemo mavolu. Kateige Iesuu tiale vanie ni abuita abuhi ua. ");
INSERT INTO kpx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abuhi ui haivege ata moagaeau hotove evisi bae abu uvu mai omilu. ");
INSERT INTO kpx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Isi keau bae keate ke namihai avoe, “No a hoto louale ke unahamo no uvu mai avuemo mavoholilu. Isito no biaeau nova hotove evisi hilokage keu vatae ata maleveve kosive. Kemoike no uvu mai avuemo mavolu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Vanie ni abuita keau uoholige Iesuu halevei Galili vatae tinu. ");
INSERT INTO kpx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Keu subuta loui avoe, “Ata olena beloveta holige atave seleve keau bae hoesehavoi hotove malivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Isito au Galilie tiale velemage ataeau elehaime vahaehove vai hoesehavolu. Kosealemo abu Dielusalemae tiliale Diue vahaeho vani Basova kemo Iesuu vikoe vaveve moaga vaevege abu ke elehalu. ");
INSERT INTO kpx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Igeto Iesuu kemo halei tota Keina oe tinu. O keveike au subuta vikoe vaveve vage eu uaini holinu. Iale o kemo gamanie kosive moleu ua. Kosive ke mou o mole Kabenumu keve vavahanianu. ");
INSERT INTO kpx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iale kosive keu Iesuu Diudia halei Galilie lohoale hoto ke evinu. Isi avue tiale namihai avoe, “Ana vali loholive di mo hoesehavoi. Au hativeveu vuguvuguike vage di lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ige Iesuu avuho loui avoe, “La isiviale di vikoe vaveve moaga vage bae di hoto evisi mave.” ");
INSERT INTO kpx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kateai lousege gamani kosive keu avuho loui avoe, “Kosive, lohoge naiti tai. Onoilage di mou hatima.” ");
INSERT INTO kpx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kateai louge Iesuu namihai avoe, “Tenela. A mou momoleanu.” Ige malaha keu Iesu hoto ke evisi halei hoilahai tinu. ");
INSERT INTO kpx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tiale humaha tavae tisege esemuiabeau moveu momoleale hoto mai lohoale avuluvuta belehovolu. Isi namihai avoe, “A mou momoleanu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ige malaha keu belagevei avoe, “Vanie ni vaesutemoike au momoleanu.” Ige abu namihai avoe, “Nivu vaniu uani (1) okolokiasege a moe hobeu uoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ige mamaveu ke evisi hilokage vanie ni igaemoike Iesuu avuho loui avoe, “A mou momoleanu.” Ige kemo kosive keu au ese ehai abuhi abu uvu mai Iesuemo mavoi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesuu Diudia halei lohoale Galili vata kemo vikoe vaveve mole vaito lohoale tota kosive ke mo hoesehavoge momoleanu. ");
INSERT INTO kpx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vani mole Diue vahaeho vani moleu lohoge Iesuu o ke halei Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dielusalema ke vavae hala balugatahou ua. Ige kemo geiti baluga abu ivihai avoe, “Mamoe geiti.” Ige geiti ke vavamo tabu moleu uale Diue ataeau abu hotomo ivihai avoe, “Betesida.” Tabu ke vavamo abu vinaho oe ese ada mole houevelu. ");
INSERT INTO kpx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iale vavahaniteau kebia vinamo ladevei uma. Kebia degomoleau ni kedute. Ige degomoleau velo golote. Ige degomoleau oholisito u unahamalea. Iale keau isivialeike e keu kibiage vavahaniabe keu uoholisi. Iale keau keho tialeau ke hemei uma. ");
INSERT INTO kpx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Keve usege vani igaegaela Dilava aneluna lohoi e kemo tige e keu kibiage oleu ulila emo biloale ke vavahanina uoholisi. ");
INSERT INTO kpx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iale ata kebia vigomo malaha mole igae keu vagana teti eiti (38) ke uvumo vavahaniai u unahanu. ");
INSERT INTO kpx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Isege Iesuu lohoale malaha ke elehage keu keve lahai ua. Ige Iesuu hilokage malaha keu vagana baluga vavahani ke manu. Ige au avuho loui avoe, “Ana isiviai momoleai.” ");
INSERT INTO kpx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ige malaha keu namihai avoe, “Kosive, eu kibiage di mai emo mamoveve ke atau uoholinu. Katealemo di isiviale emo biloai. Isito ataeabuna di evihai solekai tai emo biloluvigei.” ");
INSERT INTO kpx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ige Iesuu avuho loui avoe, “Hovelahai a ava egumai mai lamisi tenela.” ");
INSERT INTO kpx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kateai louge malaha keu solekavesite momoleai hovelahai au ava egumai mai lamisi tinu. Bulamoike Iesuu vaveve ke vanu. ");
INSERT INTO kpx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ige Diue kosiveau malaha nehe momoleale keho loui avoe, “Novae vani kou bulae vani. Iale a bulamo ava ebamoi lohoale kemo a menaka egumanu.” ");
INSERT INTO kpx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ige malaha keu namigevei avoe, “Di hoesehavoale ata keike daho loui avoe, ‘A ava egumai mai lamisi tenela.’” ");
INSERT INTO kpx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ige abu belahai avoe, “Malaha oleike a namihage a ava egumai mai lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ige au namigevei avoe, “Di hoesehavoale ata ke di hilokaholinu.” Malaha keu Iesu hilokaholiale keu koseanu. Iesuu ke hoesehavoito solekai atae uvue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Iniale ke iae Iesuu Diue dubue uvue tiale malaha ke elehai avuho loui avoe, “E, a nova momoleanu. Iale ainaho tota vaveve toela vagelive. Ana kateige vaveve toela balugana aemo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kateai avuho louge au halei tiale Diue kosive namigevei avoe, “Iesu keike di hoesehavoge di momoleanu.” ");
INSERT INTO kpx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ige abu ke evisi Iesuluvuta ugologololahalu. Kosealemo keu bulamo malaha ke hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ige Iesuu abuho loui avoe, “Di Mama keu vani bahata vaveve dua vama. Iale ke nahate dana data vagei.” ");
INSERT INTO kpx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hoto kateale louge Diue kosiveau isivi balugaleike Iesu hamai. Au bula egumale ke unahamo abu kateholilu. Isito au loui avoe, “Di Mamaike Dilava.” Ige abu ke huhulahai avoe, “Kou isivialeike au ebika ebagemai Dilava nahate vai.” Kemoike abu isiviale hamai. ");
INSERT INTO kpx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Abu katelahage Iesuu abuho loui avoe, “Seleveta di la namigevege evive. Dilava mou au isivimo onobe va kavaholima. Isito Mamaveu niveta vale ke unahaike au ke vama. ");
INSERT INTO kpx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mamaveu au moho isivi balugai au vamale ke bahata au mo haivunu. Iale Mamavena isivianiege vaveve balugau vaveve ko evihale ke haivuge auna ke vage lana ke elehai tetelahave. ");
INSERT INTO kpx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mamaveu haluviale kebia tatuvei lu ovege abu hovedeveale ke nahate movena au isivimo ukolikoli oleme ovei. ");
INSERT INTO kpx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mamaveu bae atae vaveve abuemo kaovalivebene. Isito auna au vuvune bahata mai au mo omige movena atae vaveve abuemo kaovai. ");
INSERT INTO kpx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Katealemoike ataeabuna bahata Dilavata moveta ivi ebagevai hoesegevei. Dilavau au mo hanavoge lohonu. Iale oleuoleu move hoesehavoholiale keau bae Mamave keta hoesehavolivebene. ");
INSERT INTO kpx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Seleveta di la namigevege evive. Oleuoleu di hoto evisi di hanavoale ke hotota eviliege abuna ukolikoli malei. Ige Dilavau bae vaveveabe abuemo kaovalivebene. Kosealemo au uveve doga oveale kemo abuna hovedevei ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Seleveta di la namigevema. Vani moleu lohoma. Di tota louge evive. Vani keu aike lohonu. Iale laeau haluviale ke nahate vaike vage Dilavau di hanavoge di la hohaveho lohonu. Iale oleuoleu di ho eviale keabuna uveve doga malei. ");
INSERT INTO kpx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Di Mama keu ukolikolie umuka. Ilike vage au au vuvune mai daoge dau data ukolikolie umuka holinu. ");
INSERT INTO kpx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Di Mamau au vuvune mai daoge di Atae Ese holinu. Iale kemo dana ataemo vaveveabe kaovai. ");
INSERT INTO kpx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Iale lainaho hoto kemo vikolahalive. Kosealemo vani moleu lohoge haluviale keabuna abata uvue di hoto evisi. ");
INSERT INTO kpx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Abuna di hoto evisi abatamo hovedevei. Ige oleuoleu vaveve dua vamale keabuna hovedevei ukolikoli malei. Isege oleuoleu vaveve toela vamale keabuna hovedevegeto Dilavana vaveveabe toela ke ibina ovei.” ");
INSERT INTO kpx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iesuu hoto kateale louito tota hoto mole lounu. Avoe, “Di di isivimo onobe va kavalivebene. Isito Dilavau daho louale ke dana vai atae vaveve kaovage di vaveve kena inutolotoloai. Kosealemo di bae di isivi unaha huhuai valivebene. Isito di hanavoale ke isivi unaha dana vagei. ");
INSERT INTO kpx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Dana di ebika ebagemai loui kosea, ‘Dau baluga.’ Ige la bae di hoto malivebene. ");
INSERT INTO kpx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Isito ata moleu di ebagemai di vaveve louge di hilokage hotove keu seleve. ");
INSERT INTO kpx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Di vaveve louale ata keike Dioni. Ige la la esemu hanavege abu avue tige au abuho di vaveve seleve loui namigevenu. ");
INSERT INTO kpx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Isito ataeau di vaveve loui di ebagevai mesoho di ebagevaholige keta duave. Di Dioni vaveve ke loui isivialeike la ke evige Dilavana la malevei. ");
INSERT INTO kpx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Dioni keu lamebau lahai atagale ke nahate. Keu vasohuta lohoale la haivege la hotove evisi vahaehove vaito halevalu. ");
INSERT INTO kpx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dioniu di vaveve louale keu baluga. Isito di Mamau lovi mai daoge di vamale keu balugataho. Iale lana di vaveve ke elehai hilokage di Mamau di hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iale di hanavoale di Mama keu di vaveve loui di ebagemanu. Isito la ke hoto evisi nive elehaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Isi la di hoto eviholiale kemoike di hanavoale ke hotota la evioholilu. Kosealemo hotove keu la uvumo uoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","La vani bahata Bukae Hoto kaovai huhulahai kosea, ‘Noeabuna komo ukolikoli malei.’ Isito Bukae Hoto kemo di vaveveu ua. ");
INSERT INTO kpx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kateaito la isiviholialeike dae lohoi ukolikoli maleliho. ");
INSERT INTO kpx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iale la di hoesehavoliho isiviholige keta duave. ");
INSERT INTO kpx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kosealemo di hilokage la la uvu mai Dilava omioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dau di Mamae vuvunemoike lohonu. Isito la di hoto mai ehovaholilu. Mesoho ata molena au vuvunemo lohoge lana ke hoto mai ehovave. ");
INSERT INTO kpx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","La mole hoto evisi mole hoesegevema. Isito la isiviholialeike Dilava hoto evisi ke igae hoesehavoliho. Iale lana oleve kateai bae la uvu mai avuemo mavoi. ");
INSERT INTO kpx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lainaho huhulahai kosea, ‘Iesuna au Mamaho no vaveve loui.’ Di bae kateale loulivebene. Isito Mosese ke igaena gabie la vaveve loui Dilava namihai. Kosealemo la huhulahai kosea, ‘Mosese keu no kosive.’ Isi la uvu mai avuemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","La katelahaito la uvu mai avuemo mavo seleve holioholilu. La uvu mai avuemo mavovatege la hotove evisi di hotota evilu. Kosealemo di vaveveike au ke hisalianu. ");
INSERT INTO kpx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Isito la hotove eviholiale kemo lana oleve kateai di hoto evisi.” ");
INSERT INTO kpx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Vani mole Iesuu tota hoilahai Galili tabu ke houi vaki mole lohonu. Tabu ke ivi moleike Taibiliasi. ");
INSERT INTO kpx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iale Iesuu keve lohoge ata moagaeau ehovai avuluvuta loholu. Kosealemo au au vuvune vavevemo vavahanitebia hoesegeveale ke abu elehalu. ");
INSERT INTO kpx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ige Iesuu au esemu holoevei abuhi tiale tanae uguiavoi ua. ");
INSERT INTO kpx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Diue vahaeho vani mole Basova keu kateimalela vuguvuguanu. ");
INSERT INTO kpx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ige Iesuu niavei elehage ata moagamoagaeau avue lohoma. Ige au kebia elegevei au esemu mole Bilibi namihai avoe, “Nahiabuna oleve lovi voilahai ata kobia bahata ovei.” ");
INSERT INTO kpx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kateai loui Bilibi evievi kaovanu. Au kateaito hilokage auna vikoe vaveve vai. ");
INSERT INTO kpx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ige Bilibiu namihai avoe, “Nahiabuna moni baluga tu handele kina (K200) kateale malei lovi voilahage au bae neniabeta ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kateai louge Iesu esemu mole Saimoni Bita hoho Andulu keu abuho lounu. ");
INSERT INTO kpx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Loui avoe, “Ata kebia vigomo mo moleu valava ada mole isi huena abuita kebia malei lohonu. Isito lovi kehameu bae ata kobia bahata nenita ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ige Iesuu au esemuho loui avoe, “Ata kebia namigevege abu uguiavoi.” Ige esemuiabeau ata kebia namigevege abu kulue golomo ugulelevalu. Ata kebia uvumo malaha unaha abu dodaveale keau bahata vai taoseni (5,000) ata. ");
INSERT INTO kpx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Isege Iesuu valava malei Dilava hoesehavoito malei ataeau uguiavoale kebia ovege abu ilu. Isi huena kebia malei emo ke nahate vanu. Kateige abu ke ige uniabeau hanilahalu. ");
INSERT INTO kpx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kebia bahata uniabeu haniage Iesuu au esemu namigevei avoe, “Lainaho lovi kebe sigu halevalive. Isito ke bahata malei bevuave.” ");
INSERT INTO kpx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ige abu lovi ke sigu malei basiketi tuelomo (12) emege tobaloholu. Ataeau valava ada mole iale ke siguiabuike basiketimo ua. ");
INSERT INTO kpx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ige keve uale ata keau Iesuu au vuvune vaveve vale ke elehai loui avoe, “Seleveta nahi beloveta nehe hemei umale keiko lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kateai louge Iesuu hilokage keabuna lohoi evudei vavave tolomo namihage auna kosiveabe holisi. Au vaveveabe hilokale kemo halevei ahuvela botoe tinu. ");
INSERT INTO kpx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gutumo esemuiabeau hevaluvisi tabue loholu. ");
INSERT INTO kpx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lohoaleau isivilahale bouti mai tabu ke houi Kabenumue tai. Isi kateai Iesu inohomo ulage vau loage abu bouti mai tilu. ");
INSERT INTO kpx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tisege heluka balugau utuige eu toelanu. ");
INSERT INTO kpx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eu kateisege abu negolahai tiale e nie tisege Iesuu e adala lamisi abue lohonu. Ige abu ke elehai vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Vabulahage Iesuu abuho loui avoe, “Lainaho vabulahalive. Iesu dalike lohoma.” ");
INSERT INTO kpx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kateai louge abu isivialeike au boutimo biloai. Ige Iesuu boutimo biloige bouti keu solekai tiale abu timale o keve velemanu. ");
INSERT INTO kpx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Vani mole vavita ata nehe keau tiale Iesu kaovalu. Isi hilokage esemuiabe keau subuta bouti mole mai tige Iesuu kebiahi tioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Abu Iesu kaovasege Taibiliasi bouti degomoleau tialeau Iesu lovi hoesehavoge ata neheau iale ke vavae lavilu. ");
INSERT INTO kpx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ige ata keau Iesu kaovalata Iesuta esemuiabeta elegeveholisime bouti kebiamo biloluvisi Kabenumue Iesu kaovaliho tilu. ");
INSERT INTO kpx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tiliale vaki mole velehovoi Iesu elehalu. Isi belahai avoe, “No haivemale ata, a vaesuvela kove lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ige Iesuu avuta namigevei avoe, “Di seleveta la namigevege evive. Di vuvune vaveve vage la elehale kemo la di kaovaholilu. Isito la lovi ige la uniu haniale kemoike la di kaovama. ");
INSERT INTO kpx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lainaho loviu sakavaveve ke lovi vai tubunagelive. Isito vani bahata ukolikoli maleveve ke lovi vai negolahave. Atae Esena lovi ke laovei. Kosealemo Mamaveu lovive ebagemai hanavoge au lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kateai louge abu belahai avoe, “Noeabuna oleve kateai Dilava lovi ke vai.” ");
INSERT INTO kpx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ige Iesuu namigevei avoe, “Dilavau isivialeike la lovi koseale vai. Au hanavoale ata ke hoto evisi la uvu mai avuemo mavove.” ");
INSERT INTO kpx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ige abu tota belahai avoe, “Ana vuvune vaveve onole vage no ke elehai no uvu mai aemo mavoi. ");
INSERT INTO kpx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","No buluveau subuta botoe ui lovi mole mana ke ilu. Bukae Hotomo vaveve ke hotou ua. Au loui avoe, ‘Lovi keu otogomo lohoge Moseseu louge abu ilu.’” ");
INSERT INTO kpx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ige Iesuu abuho loui avoe, “Seleveta di la namigevei. Moseseu otogomo lovi ke malei oveholinu. Isito di Mamaike lovi ke malei la buluve ovenu. Iale auna otogoe lovi seleve mai laovei. ");
INSERT INTO kpx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lovi keike moveu otogomo dobai lohoale uveve doga mai vatae ata ovenu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ige abu belahai avoe, “Kosive, vani bahata lovi ke noevegenela.” ");
INSERT INTO kpx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ige Iesuu namigevei avoe, “Dau ukolikolie lovi. Iale oleuoleu dae lohoale keau bae vaelahalivebene. Isi oleuoleu di hoto evisi di ehovale keau bae enulahalivebene. ");
INSERT INTO kpx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Isito di subuta laheho louale keu nova velemanu. Laeau di vaveve elehaito di hoto evisi ehovaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iale di Mamau ata daoge dae lohoale kebia di bae nunuvelivebene. Isito abuna daluvuta ui. ");
INSERT INTO kpx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kosealemo di otogo halei dobai lohoale kemo di bae di isivi valivebene. Isito di hanavoale ata ke isivi dana vai. ");
INSERT INTO kpx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Di hanavoale ke isivi keu koseanu. Keu isiviholialeike au daoale ata kebia haleveliho. Isito isivialeike vanie gabila di kebia bahata tatuvege abu hovedevei. ");
INSERT INTO kpx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Di Mamau isivialeike ata oleuoleu di elehai di hoto evisi abu uvu mai daemo mavoale kebia dana vanie gabila tatuvege abuna hovedevei ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kateai louge Diue ataeau hotove keho isiviholisi abu moleteho louma. Kosealemo Iesuu loui avoe, “Otogomo lohoale lovi ke daliko.” ");
INSERT INTO kpx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Isi abu moleho loui avoe, “Dioseba mo Iesu kenike. Nahi ke mamata neinaveta hilokalu. Iale keu oleve kateike vaime loui avoe, ‘Dau otogomo dobai lohonu.’” ");
INSERT INTO kpx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ige Iesuu namigevei loui avoe, “La daho itumulahai moleho loumale ke halevave. ");
INSERT INTO kpx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Atabeu bae dae loho kavalivebene. Isito di hanavoale di Mamau au isivi mai uvuvemo mamoge auna dae lohoi. Ige vanie gabila dana ke etuvage auna hovelahai. ");
INSERT INTO kpx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Subuta beloveta moleu hisaliai loui avoe, ‘Dilavana ata bahata haivei.’ Iale oleuoleu di Mamae hoto evisi avuemo lulelelahale keabuna dae lohoi. ");
INSERT INTO kpx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ataeau di Mama elehaholilu. Isito di Mamau hanavoale ata ke igaeu elehanu. ");
INSERT INTO kpx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Iale di la namigevei. Oleuoleu abu uvu mai ata kemo mavoale keabuna ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iale dau ukolikoli lovi daliko. ");
INSERT INTO kpx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","La buluveau subuta tomagie ui lovi mole mana ke isito haluvilu. ");
INSERT INTO kpx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Isito oleuoleu otogomo dobai lohoale lovi ke iale keau bae haluvilivebene. ");
INSERT INTO kpx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ukolikoli loviu otogomo dobai lohoale ke daliko. Iale oleuoleu lovi ke iale keabuna vani bahata ugei. Di lovi mai ata oveale keu di misilike. Iale lovi kemo abuna ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iesuu kateai louge Diue ataeau moleho loui mole belagevei avoe, “Malaha kona oleve kateai au misi mai nahiovege nahi isi.” ");
INSERT INTO kpx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Katelahai moleho lousege Iesuu abuho loui avoe, “Seleveta di la namigevege evive. Mesoho la Atae Ese misi ioholisi tahoveta ioholiliege la bae ukolikoli malelivebene. ");
INSERT INTO kpx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Isito oleuoleu di misi isi di tahota iale keau uveve doga malelu. Iliege vanie gabila dana tatuvege abuna hovedevei ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kosealemo di misi keu lovi seleve. Ige di taho keu e seleve. ");
INSERT INTO kpx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iale oleuoleu di misi isi di tahota iale keau daluvuta uge dana abuhi ui. ");
INSERT INTO kpx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Di Mama keu ukolikoli kosive holialemo data avuemo ukolikoli kosive holinu. Ige keu di hanavoge oleuoleu di misi iale keabuna daemo ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lovi keike otogomo dobai lohonu. Isito la buluveau subuta lovi iale keu ke nahate holioholinu. Keau lovi ke isito haluvilu. Isito oleuoleu lovi ko iale keabuna vani bahata ui tigei.” ");
INSERT INTO kpx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesuu Kabenumu dubue ata haivei hoto kateale abuho lounu. ");
INSERT INTO kpx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kateai louge esemuiabe moagaeau ke evisi moleho loui avoe, “Kou hoto ko louale kou toloanu. Iale olena hotove ko evisi mai.” ");
INSERT INTO kpx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Katelahai lousege atabeu hotoeabe loui Iesu namihaholinu. Isito Iesu biageu hilokage keau hotove kemo vahaehoholilu. Iale kemo au namigevei avoe, “Di hoto louale keu la malevei vahaehotigeveholialemo lana valive di halevai. ");
INSERT INTO kpx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Lana kateige Atae Esena tota ehue hoilahai au lohoale keve tige lana ke elehai osioi. ");
INSERT INTO kpx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iale di louge evive. Ataeau bae atae vaveve kemo ukolikoli malelivebene. Isito Munana Tumu igaemo ataeabuna ukolikoli malei. Di laheho louale keu Munana Tumue hoto. Iale lana ke eviliege ukolikoli maleve. ");
INSERT INTO kpx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Isito la degomoleau mesoho hoto ke maholilu.” Iesu louale keu koseanu. Subuta keu hilokage ata degomoleau bae hotove malivebene. Isi hilokage kebiamo ata mole igaena avuho haiai. ");
INSERT INTO kpx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ige au tota namigevei avoe, “Di subuta laheho loui kosea, ‘Di Mamau ata tabageveholiale keau bae dae loholivebene.’ Katealemoike di laheho ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iesuu hoto kateale louale kemo ata degomoleau ehovale keau halevai hoidevelu. ");
INSERT INTO kpx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ige Iesuu au esemu tuelo (12) kebia belagevei avoe, “Keau katelahalu. Iale lana lata isiviai di halevai tai.” ");
INSERT INTO kpx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ige Saimoni Bitau avuta namihai avoe, “Kosive, noeabuna ata olemo hoto seleve mai. A igaemo ukolikoli hotou ua. ");
INSERT INTO kpx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","No a hoto evisi hilokage au Dilava atae tumu.” ");
INSERT INTO kpx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ige Iesuu kebia bahata namigevei avoe, “Di esemu tuelo (12) la tabagevenu. Isito la molemo munanae toelau ua.” ");
INSERT INTO kpx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesuu hoto ke louale ihuveu koseanu. Saimoni mole mo Diudasi Kaliota keu Iesu esemu tuelo (12) kebiamo keu esemuve mole. Iale keike Iesuho haianu. ");
INSERT INTO kpx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vani mole Iesuu Galili vata keve oai taito isiviholialeike Diudia vatae taliho. Kosealemo keve Diue kosiveau isivialeike hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Au keve ohanoi tisege Diue vahaeho vani moleu vuguvuguanu. Vahaeho vani kemo Diue ataeabuna evavaga houevei kemo ugei. ");
INSERT INTO kpx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iale vani keu vuguvuguige Iesu hohuvuiau avuho loui avoe, “Matama ko halei Diudia vatae tenela. Ige elike a esemuiau keve umale keau a vaveve elehai. ");
INSERT INTO kpx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ata oleu isiviale ataeau ivive hilokage au bae au vaveve mahogovalivebene. Iale talive a vaveve a vamale ke atae nimo vage ata bahataeau valive a vaveve ke elehai a hilokai.” ");
INSERT INTO kpx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hoto ke louale kebiata hotove maholilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ige Iesuu au hohuvuho loui avoe, “La isiviai onole vaho valiege momolelahai vave. Isito ataeau di hilokaveve ke vaniu lohoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vatae ataeau bae la aiogevei lahehi ugologoloalivebene. Isito abuna daluvuta ugologololahai. Kosealemo di negobedai vatae ata namigevei loui kosea, ‘La vaveve keau toelalu.’ ");
INSERT INTO kpx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Iale nena momolelahai vahaeho vani keve teve. Di bae aike talivebene. Kosealemo di vaniu lohoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Avu kateai namigeveito halei Galilie ua. ");
INSERT INTO kpx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Keve usege hohuvuiabeau Dielusalemae tisege au bae gabie ehovei tinu. Tiale ke ataeau hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Isege Diue kosiveau vahaeho vani kemo kaovalata elehaholisi mole belagevei avoe, “Iesu oleve.” ");
INSERT INTO kpx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ige ata bahataeau saiavoi moleho loui tai lohoma. Degomoleau loui avoe, “Keu atae dua.” Isege degomoleau loui avoe, “Ba, keu ata lobogevemale ataike.” ");
INSERT INTO kpx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Abu katelahaito baita atae vudimo nenilahai Iesu vaveve louholilu. Kosealemo abu Diue kosive vabugevelu. ");
INSERT INTO kpx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Abu katelahasege vahaeho vani keu uoholiliho vasege Iesuu tiale Diue dubu baluga keve ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ige Diue kosiveau hotove evisi tetelahalu. Isi moleho loui avoe, “Nahi hilokage ata kou sikuluholinu. Iale au oleve kateai luleleike vaime hoto koseale louma.” ");
INSERT INTO kpx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ige Iesuu namigevei avoe, “Di la haiveale keu di hoto holioholinu. Isito di hanavoale Dilava ke hotoike di loui la haivema. ");
INSERT INTO kpx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iale oleuoleu isiviai Dilava isivi vale keabuna hilokage di louale keu Dilava hoto emena di hoto unaha. ");
INSERT INTO kpx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ata oleu au hoto unaha louale kena kemo au ebika ebagemai. Isito oleu isiviai au hanavoale kosive ke ivi ebagemai isivive vale ata keu loboe ata holioholinu. Isito keu ata seleve. ");
INSERT INTO kpx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Seleveta Moseseu menaka laovenu. Isito labeau menaka ke bahata ehovaholilu. Iale osialemoike la isiviai dahavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kateai louge ataeau namihai avoe, “Oleu isiviai ahamoi. Ataeau ahavoliho isiviholilu. Isito mesoho a kemo munanae toelau ua.” ");
INSERT INTO kpx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ige Iesuu namigevei avoe, “Di bulamo vaveve mole baluga vale keike la elehai vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Isito laeau bulamo lovilahama. Kosealemo la Mosese menaka ke ehovai bulamo la moe ese kebia vudie vate bohievema. Isito Moseseu menaka ke mamoholisito la vavivuiabuike vasohuta vaveve ke valu. ");
INSERT INTO kpx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iale la bulamo la ese vudie vate bohilive elike kemo Mosese menaka ehovave. Iale di bulamo malaha ke hoesehavoge keu hovelahale kemo la osiohoike daho itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lainaho atae vaveve unaha elehai kemo hoto lougelive. Isito nenilahai ihuve seleve elehaito bae kemo hoto lougeve.” ");
INSERT INTO kpx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iesuu kateai lousege Dielusalema ata degomoleau ke evisi moleho loui avoe, “Malaha konike abu isivilahale hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Isito elehave. Au ata moaga kobiaho louge nahie kosiveau avuho louholilu. Mesoho kosive keau hilokage keu nahie tedaevemale kosive Keliso. ");
INSERT INTO kpx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nahi hilokage nahie tedaevemale kosive Keliso keu lohoge ataeau bae au oleve lohoale ke hilokalivebene. Isito malaha kou lohoale ke nahi hilokalu. Iale keu oleve kateike vaime nahie tedaevemale kosive holiho.” ");
INSERT INTO kpx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ataeau katelahai hoto ke lousege Iesuu dubu baluga keve baita hoto loui ata haivei avoe, “Seleveta la di hilokalu. Isi di oleve lohoale keta la hilokalu. Isito dau di vuvunemo lohoholisito di hanavoale ke vuvunemo lohonu. Iale di hanavoale ata seleve ke la hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Isito da igaeu ke hilokanu. Kosealemo di keti ulage keu di hanavoge di lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kateai louge Diue kosiveau ke evisi isiviale mai kotai. Isito vaniveu lohoholiale kemoike abu maholilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ata moaga kebiamo ata degomoleau hotove evisi abu uvu mai avuemo mavoi loui avoe, “Ata tedaevemale kosive Keliso kena lohoniege au vuvune vaveve vage kena ata ko vaveve evihai. Ba, mesoho kosive keike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ata keau kateai saiavoi moleho lousege Balisia ataeau ke evilu. Isi dubu nalimale kosivehi mole bevuevei hotohotoai dubue udaha nalimale bukate hanavege abu Iesu maliho tilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu maliho tisege Iesuu ataho loui avoe, “Di bae lahehi vani moaga ulivebene. Vani degomolena uoholisege dana tota hoilahai di hanavoale ata keve tai. ");
INSERT INTO kpx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ige vani kemo lana di kaovaito la bae di elehalivebene. Kosealemo la bae di tiveve keve talivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kateai louge Diue kosiveau mole belagevei avoe, “Kona oleve tige nahiabuna elehaholisi. Mesoho auna tiniege Diue ataeau Giliki vatae umale keve kebia haivei. ");
INSERT INTO kpx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Au loui avoe, ‘Lana di kaovaito la bae di elehalivebene.’ Isi au tota loui avoe, ‘La bae di tiveve keve talivebene.’ Iale keu ono vadeike au huhuai hoto ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Diue vahaeho vani baluga keu uoholimale vanila Iesuu hovelahai baita abuho loui avoe, “Oleuoleu enulahaliege dae loholive e isi. ");
INSERT INTO kpx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bukae Hotou ke nahate lounu. Avoe, ‘Oleuoleu abu uvu mai daemo mavoale kebia uvumo ukolikoli ena hanai laluvagei.’” ");
INSERT INTO kpx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesuu hoto ke louale keu e seleve holioholinu. Isito Munana Tumuike au ke lounu. Avoe, “Oleuoleu abu uvu mai daemo mavoale keabuna Munanae Tumu malei.” Isito vani kemo keau Munanae Tumu maleholilu. Kosealemo Iesuu hovelahai ehue tioholiale kemoike Kosiveu Munanae Tumu oveholinu. ");
INSERT INTO kpx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iesuu hoto kateale lousege ata degomoleau hotove evisi loui avoe, “Seleveta nahi beloveta nehe hemei umale keike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Isege degomoleau loui avoe, “Nahie tedaevemale kosive Keliso keike ko.” Isito degomoleau loui avoe, “Ba, nahie tedaevemale kosive keu bae Galili vatamo loholivebene. ");
INSERT INTO kpx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bukae Hotou loui avoe, ‘Nahie tedaevemale kosive Keliso kena Deividi valadamo lohoi. Isi Deividiu o mole Betelihamue umale keve auna ui.’” ");
INSERT INTO kpx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Katelahai moleho loui Iesu vaveve kemo mole tasalievelu. ");
INSERT INTO kpx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ige degomoleau tiale isiviai Iesu mai kotai. Isito keau Iesu maveve keu abuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ige dubue udaha nalimale bukate nehe keau tota hoidevei dubu nalimale kosive isi Balisia ata kebiae loholu. Ige kosive keau belagevei avoe, “La osialemoike Iesu mai lohoholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ige bukate keau abuho loui avoe, “Atabeu bae au hoto louale ke nahate loulivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ige Balisia ata keau belagevei avoe, “Auna lata lobogevenu. ");
INSERT INTO kpx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","La huhuige Balisia ata noeabuna no uvu mai avuemo mavolu. Isi la huhuige kosivebiata abu uvu mai avuemo mavolu. Ba, kosiveau kateholilu. ");
INSERT INTO kpx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Isito kove umale ata koeabuike Mosese menaka kemo lulelevatege abu uvu mai avuemo mavoholilu. Iale keabuna Dilava itumue valamo ui.” ");
INSERT INTO kpx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Katelahai louge kebia vigomo kosive mole ivi Nikodimasi keta hovelahanu. Kosive keike vani mole Iesu elehaho tinu. Iale keu hovelahai abuho hoto mole lounu. ");
INSERT INTO kpx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Avoe, “Nahie menaka kemo nahiabuna vasohuta atae vaveve kaovai hotove evisi hilokaito bae avuho loui au onole vale ke ibina omisi.” ");
INSERT INTO kpx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kateai louge abu avuho loui avoe, “Ana ata Galili vatamo lohonu. Ana Bukae Hoto dodaveholinu. Ke dodavei hilokage belovetabeu bae Galili vatamo loholivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kateai louito halevai abu o igaegae tilu. ");
INSERT INTO kpx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iesuu avuta halei tana mole ivi Oliveta keve tinu. ");
INSERT INTO kpx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Iniale vavita vavita Iesuu hovelahai tota Diue dubu balugae tinu. Ige keve ata moagaeau lohoale evilikahavoge Iesuu ugulamoi kebia haivenu. ");
INSERT INTO kpx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Isege Diue menaka loui haivemaleau Balisia atahi keate mole mai loholu. Keate keu malaha moleti lahai hotohotoisege abu elehai mai lohoale ata bahatae vudimo mavoge keu kemo laminu. ");
INSERT INTO kpx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ige kosive keau Iesu namihai avoe, “Kosive, keate kou malaha moleti vaveve toela vasege no elehai mai loholu. ");
INSERT INTO kpx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nahie menakamo Moseseu loui avoe, ‘Keate oleteau abu kolivu vavae vaveve toela vale kebia muneta havege abu haluvisi.’ Iale ana keate ko vaveve kemo hoto vade loui.” ");
INSERT INTO kpx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Abu hoto ke louale keu koseanu. Abu isiviale kateige Iesuu hotoeabe kemo dobage abu mai kotalahai. Isi kateai louge Iesuu hotobe louholisito debekebekeai vatamo au adata hisalianu. ");
INSERT INTO kpx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ige ata keau keve lavisi negobedai belahalage Iesuu hovelahai abuho loui avoe, “La oleu vavevebe toela vaholiale keu vasohuta hovelahai muneta keate ko hamai.” ");
INSERT INTO kpx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kateai louito tota debekebekeai vatamo hisali moleanu. ");
INSERT INTO kpx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ige malahae kosiveau Iesu hoto ke evisi halevai igaegaeai tima. Igaegaeai tilage gabila malahae doga keau tilu. Keau bahata tihatusege Iesuu keate ke igaeti ua. ");
INSERT INTO kpx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ige Iesuu hovelahai keate ke belahai avoe, “A mai lohoale ata keau oleve. Atabena a vaveve toela ke aemo lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ige au loui avoe, “Ba, kosive, beu daho louholinu.” Ige Iesuu avuho loui avoe, “Ige data bae aemo a vavevebe toela loulivebene. Iale tenela. Isito ainaho tota gabie vaveve toela ke va molealive.” ");
INSERT INTO kpx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesuu kateai keate keho louito tota ata namigeve moleanu. Avoe, “Dau vatae ataga. Iale oleuoleu di ehovale keau bae vavila talivebene. Isito abuna uveve doga mai atagala tai.” ");
INSERT INTO kpx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ige Balisia ataeau avuho loui avoe, “A aike louale hoto keu a igae hotoike a ke louma. Iale a hoto keu seleve holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ige Iesuu hotoeabe ibina vai abuho loui avoe, “Di hoto loumale keu seleve unaha. Halege di debikamo hoto louge keta duave. Kosealemo di oleve lohoale di oleve tiveve ke di hilokanu. Isito laeau ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Laeau vatae vaveve kemo di vaveve daemo kaovama. Isito dau laemo la vaveve kaovaholima. ");
INSERT INTO kpx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dana isiviai laemo la vaveve kaovage di hoto kena seleve holisi. Kosealemo da igaeu bae la vaveve kaovalivebene. Isito di hanavoale di Mama kena daiti uge noeabuna avuti la vaveve kaovai. ");
INSERT INTO kpx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","La menakamo abu hisaliai avoe, ‘Ata abui abuna ata mole vaveve elehai kemo hoto louge hotoeabe kena seleve holisi.’ ");
INSERT INTO kpx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Iale di vaveve hilokale ata abuiau ua. Ke mole dailike ko. Ige di hanavoale di Mama keta moleike ke.” ");
INSERT INTO kpx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kateai louge abu belahai avoe, “A Mamau oleve ua.” Ige Iesuu abuho loui avoe, “La di Mama hilokaholisi data hilokaholilu. La di hilokavatebe di Mama keta hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Abu dubu baluga ke uvue obeleni moni mavomale keveike Iesuu lamisi hoto kateale loui ata haivenu. Ige atabeu mai kotaholinu. Kosealemo vaniveu sohu lohoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ige Iesuu tota kosive kebia namigevei avoe, “Dana la halevei tisege lana bae di kaovave. Isito lana la vaveve toela vamale kemo haluvive. La bae di tiveve keve talivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ige Diue kosiveau ke evisi moleho loui avoe, “Malaha kou loui avoe, ‘Di tiveve keve la bae talivebene.’ Iale la huhuige kena au ebika hamai hatilihoike au kateai lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ige Iesuu abuho loui avoe, “Laeau heie umale ataea. Isege dau ehue umale ata. Iale laeau vata komo loholu. Isito dau vata komo lohoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Katealemoike di laheho loui kosea, ‘Lana la vaveve toela vamale kemo haluvive.’ Isi di laheho loui kosea, ‘Ata ke dailiko.’ Ige la ke evisito la uvu mai daemo mavoholiale kemo lana la vaveve toela kemo haluvive.” ");
INSERT INTO kpx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kateai louge abu belahai avoe, “Au ole a.” Ige Iesuu namigevei avoe, “Vani bahata di laheho loumale dau ata ke dailiko. ");
INSERT INTO kpx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Di la vaveve bahata hilokanu. Iale dana isivianiege la vaveve kemo laheho hoto moaga loui. Isito di bae ke bahata loulivebene. Dana di hanavoale ata ke hotove seleve unaha loui ata haivei.” ");
INSERT INTO kpx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesuu kateai au Mamae vaveve kemo hoto louge abu ke evisito kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iale au abuho loui avoe, “Dau Atae Ese. Iale lana gabie ataho louge ataeabuna di mai idie domo hamage lana bae kemo hilokage di laheho louale ata ke dailiko. Ige kemo lana hilokage dau di isivi unaha va holioholinu. Isito di Mamau daho louale ke unahaike di loui la haivenu. ");
INSERT INTO kpx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Di hanavoale keu di haleholisito vani bahata daiti uma. Kosealemo di vani bahata isivive vamale kemo au di vahaeho vama.” ");
INSERT INTO kpx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesuu hoto kateale louge Diue ata moagaeau hotove ke evisi abu uvu mai avuemo mavoi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ige au abuho loui avoe, “Lana di laheho louale ke ehovai ma selevealiege di esemu seleve holieveve. ");
INSERT INTO kpx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Iliege kemo lana hoto seleve hilokai kemo lulelelahage vatae vaveveu bae la malevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ige abu hotove ibina vai avuho loui avoe, “No Ebalahamu valada holialemo vatae vaveveu no maleveholinu. Isi noeau heiata atabeho lovi kavaholilu. Iale osialemoike a loui kosea, ‘Vatae vaveveu bae la malevelivebene.’ A hoto ke louale ihuveike onole.” ");
INSERT INTO kpx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kateai louge Iesuu namigevei avoe, “Seleveta di laheho louge evive. Oleuoleu vaveve toela vamale ata keau lovi kavamale ke nahate vai vatae vaveve toelae isivi unaha vama. ");
INSERT INTO kpx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lovi kavamale ata keu lovie biage ke ese holioholinu. Kemoike au bae vani bahata o kemo ugelivebene. Isito o ke biage esena vani bahata o kemo ugei. ");
INSERT INTO kpx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iale Atae Esena la malevege vatae vaveve keu bae la malevelivebene. Isito lana negolahai ue dua unaha vageve. ");
INSERT INTO kpx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Di hilokage laeau Ebalahamu valada. Isito la di hoto evisi maholiale kemoike la isiviale dahavoi. ");
INSERT INTO kpx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Di Mamau di haivuale keike di loui la haivema. Isito laeau la mamau laheho louale keike la vama.” ");
INSERT INTO kpx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ige abu avuho loui avoe, “No mamaike Ebalahamu.” Ige Iesuu namigevei avoe, “Laeau Ebalahamu ese seleve holioholilu. La Ebalahamu ese holivatebe au vamale ke nahate la valu. ");
INSERT INTO kpx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Isito laeau kateholilu. Dau Dilava hoto seleve eviale ke loui la haivelage la isivialeike dahavoi. Isito Ebalahamu keu la vaveve ke nahate vaholinu. ");
INSERT INTO kpx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iale laeau la mama moleu vamale ke nahate vama.” Ige abu avuho loui avoe, “Noeau Dilava seleve ke igaeike ehovai eseve holilu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ige Iesuu namigevei avoe, “Dilava keu la Mama seleve holivatebe la daho isivilahalu. Kosealemo Dilava kemoike dau lohoale aike kove ua. Dau di isivimo lohoholinu. Isito avuike di hanavoge di lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iale osialemoike la di hoto evisi luleleholilu. Kosealemo la di hoto evisito isiviholialeike ke mai ehovaliho. ");
INSERT INTO kpx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Laeau Setene esea. Isege eu la mama. Iale kemoike la isiviale ehovai isivive vagei. Setene keu subuta mole ata haveveve vaveve ke vai lohoma. Isi loboe hoto loui hoto seleve ke kabitinu. Kosealemo keu loboe hoto loumale biage. Iale kemoike hoto seleve louveve keu avuemo anekianu. Iale kena vani bahata loboe hoto unaha lougei. ");
INSERT INTO kpx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kemoike di hoto seleve louge la la uvu mai daemo mavoholilu. ");
INSERT INTO kpx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Iale bae di namihave. Di vaveve toela onole vasege la di elehalu. Di vavevebe kateale vaholinu. Iale osialemoike di hoto seleve loui la haivege la di hoto maholilu. ");
INSERT INTO kpx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ata oleu Dilava ese holiale kena Dilava hoto evisi mai. Isito laeau Dilava ese holioholiale kemoike la di hoto evisi maholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iesuu kateai louge Diue ata keau avuho loui avoe, “No subuta hoto louale keu seleve. No loui kosea, ‘A keu Samalia ata.’ Iale a kemo munanae toelau ua.” ");
INSERT INTO kpx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ige Iesuu hotoeabe ibina vai abuho loui avoe, “Daemo munanae toelau uoholioholinu. Dau di Mamae ivi ebagemai hoesehavonu. Isito laeau di ivi ebagevaholisito di aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Di isiviholialeike di di ivi ebagemaliho. Isito di Mamau katealeho isivianu. Iale auna di aiohavomale ata kebia vaveve abuemo kaovai. ");
INSERT INTO kpx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Seleveta di la namigevege evive. Oleuoleu di hoto evisi ehovale keau bae haluvilivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ige Diue ata keau avuho loui avoe, “A hoto kemo no hilokage munanae toelau aemo ua. Ebalahamu keu hatinu. Ige beloveta kebiata haluvilu. Isito au loui kosea, Oleuoleu di hoto evisi ehovale keau bae haluvilivebene.’ ");
INSERT INTO kpx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nahie mama Ebalahamu keu hatinu. Iale a hoto louale kemo ose a isiviai Ebalahamu evihai. Ige beloveta kebiata haluvilu. Iale a huhuige ana kebiata evigevei hatiholisito vani bahata ugei.” ");
INSERT INTO kpx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ige Iesuu abuho loui avoe, “Dana di ivi ebagemai di ebika hoesehavoge keu bae duavealivebene. Isito di Mamana di ivi ebagemage kena duaveai. La di Mama keho loui kosea, ‘No Dilava.’ ");
INSERT INTO kpx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","La kateai louito la ke hilokaholilu. Isito dau ke hilokanu. Dana loui kosea, ‘Di ke hilokaholinu.’ Iniege dana la nahate vai loboai. Isito seleveta di ke hilokai hotove evisi ehomanu. ");
INSERT INTO kpx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ige la mama Ebalahamu keu di vaniu lohoveve ko huhuai kemo vahaehoanu. Iale keu ke elehai vahaehoanu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ige Diue ata keau avuho loui avoe, “Ebalahamu keu subuta ata. Isege a ke vaganau baluga seleve holioholinu. Iale a oleve kateike vai Ebalahamu elehanu.” ");
INSERT INTO kpx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ige Iesu namigevei avoe, “Seleveta di la namigevege evive. Subuta Ebalahamu sohu uoholisege dau ua.” ");
INSERT INTO kpx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kateai louge abu evige hotove keu Dilavau valive vaveve nahate. Kateike abu vai itumulahai isiviale muneta hamai. Ige Iesuu hogolahai dubu baluga ke halei tinu. ");
INSERT INTO kpx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Vani mole Iesuu ohanoi tiniale malaha mole elehanu. Malaha ke neinaveu mamoge niveu keduanu. ");
INSERT INTO kpx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ige Iesu esemuiau Iesu belahai avoe, “Kosive, osialemoike malaha kou uge niveu keduanu. A huhuige malaha kou vaveve toela vale ibinaike au ko manu. Mena au mamata neinata toelae ibinaike au ko manu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ige Iesuu namigevei avoe, “Malaha ko niu keduale keu kateholinu. Niveu keduale keu toelave isi mamaveta neinaveta toelae ibina holioholinu. Isito niveu keduale keu koseanu. Dilavau isiviale avuemo au vuvune vaveve vage ataeau vuvuneve elehai. ");
INSERT INTO kpx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vaniu koseisege nahi di hanavoale ke lovi vai. Kosealemo vau giduige nahi bae kemo lovilahalivebene. ");
INSERT INTO kpx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Isito dau sohu vata kove usege vatae ataeabuna di ataga elehai.” ");
INSERT INTO kpx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kateai louito ke iae vatamo vioaito ke emugai mai ni kedute ke nimo ulihanu. ");
INSERT INTO kpx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Isi namihai avoe, “Talive Salomu emo a ni totoanela.” E ke ivie ihuu koseanu. Ioma. Iale Iesu malaha ke iomage keu tiale e kemo au ni totoige niveu dua vage au niai hoilahai lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ige haokuvuiabe isi ata degomole keau ke elehalu. Abu hilokage niveu keduale kemo keu subuta moniho ata imigevema. Iale abu ke elehai mole belagevei avoe, “Ana malaha konike subuta ugulamoi ui moniho ata imigevema.” ");
INSERT INTO kpx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ige degomoleau loui avoe, “Avuike.” Isege degomoleau loui avoe, “Ba, keu avu holioholinu. Isito keu ke elehilehi nahate.” Kateai lousege malaha keu loui avoe, “Dau ata ke dalike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ige abu belahai avoe, “A ni keu oleve kateai dua vage a nianu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ige au namigevei avoe, “Malaha mole ivi Iesu keu tivu mai di nimo ulihai di namihai avoe, ‘Talive Salomu emo a ni totoa.’ Ige solekavesite di tiale di ni totoige di niu dua vage di nianu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ige abu belahai avoe, “Malaha keu oleve” Ige au namigevei avoe, “Keu oleve tiale ke di hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Niveu keduale keu hoto kateai louge abu ke melavei Balisia atae tilu. ");
INSERT INTO kpx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bulamoike Iesuu tivu mai malaha ke nimo ulihai hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iale kemoike Balisia ataeau malaha ke belahai avoe, “A oleve kateike vaime nianu.” Ige malaha keu namigevei avoe, “Iesuu tivu mai di nimo ulihanu. Ige di tiale emo di ni totoale kemoike di niu dua vage di aike niai onobenobe elegevema.” ");
INSERT INTO kpx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ige Balisia ata degomoleau loui avoe, “Vaveve ko vale ata keu Dilavamo lohoholinu. Kosealemo keu bula nalioholinu.” Isege Balisia ata degomoleau loui avoe, “Isito oleve kateike vaime vaveve toela vamale ata keu vuvune vaveve ke vanu.” Abu hoto kateale moleho loui kemo mole tasaligevelu. ");
INSERT INTO kpx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kateaito tota malaha nehe ke belaha moleai avoe, “A loui kosea, ‘Iesuu di ni hoesehavonu.’ Iale a huhuige ata keu ata oleteale.” Ige malaha keu namigevei avoe, “Keu beloveta ata.” ");
INSERT INTO kpx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ige Diue kosive keau hoto ke evisi malaha nehe niveu keduage Iesuu hoesehavoale hotove ke maholilu. Iale kemo abu malaha ke mamata neinaveta hohavege abu loholu. ");
INSERT INTO kpx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ige abu belagevei avoe, “La monike ko. La loui kosea, ‘Kou uge niveu keduanu.’ Iale au oleve kateike vai aike nianu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ige mamaveu neinaveti namigevei avoe, “No hilokage keu no mo. Isi no hilokage keu uge niveu keduanu. ");
INSERT INTO kpx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Isito oleve kateai niveu dua vale ke no hilokaholilu. Isi ata oleu nive hoesehavoale ata keta no hilokaholilu. Keu au ebia holisi kosi holinu. Iale belahage biagena au deiada loui la namigevei.” ");
INSERT INTO kpx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hoto kateai louale keu koseanu. Keau Diue kosive kebia vabugevelu. Kosealemo kosive keau ata namigevei avoe, “Ata olena Iesu ivi ebagemai loui kosea, ‘Keu ata tedaevemale kosive Keliso.’ Ige noeabuna ata ke iovai humahave bamuge au bae tota Diue dubu kemo guligulialivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Katealemoike mamaveu neinaveti loui avoe, “Keu kosi holinu. Iale bato belahage biagena au deiada laheho loui.” ");
INSERT INTO kpx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ige abu tota malaha nehe ni keduale ke hohavo molealu. Ige au lohoge abu avuho loui avoe, “Dilava nimo hoto seleve noheho lounela. No hilokage Iesu keu vaveve toela vamale ata.” ");
INSERT INTO kpx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ige malaha nehe keu hotoeabe ibina vai abuho loui avoe, “Mesoho keu vaveve toela vamale ata mesoho vaveve toela vamale ata holioholinu. Di ke hilokaholisito vaveve koseale igae di hilokanu. Di niu subuta keduanu. Isito di niu nova dua vage di nianu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ige abu belahai avoe, “Keu aemo vaveve onole vanu. Au oleve kateai a ni hoesehavonu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ige au namigevei avoe, “Hotoike di subuta loui la namigevege la evisito maholilu. Iale osialemoike la isiviai tota hoto ke evi moleai. Ose la isivialeike Iesu esemu holisi.” ");
INSERT INTO kpx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kateai louge abu avuho itumulahai hotoe toela loulu. Isi namihai avoe, “Au ata ke esemu. Isege noeau Mosese esemuia. ");
INSERT INTO kpx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","No hilokage Dilavau subuta Moseseho lounu. Isito ata ke no hilokaholilu. Keu oleve keve lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ige ni kedute keu tota namigevei avoe, “Di la hoto ke evisi vikoanu. Kosealemo la loui kosea, ‘Malaha keu oleve keve lohoale ke no hilokaholilu.’ La katelahai loulu. Isito malaha keu di ni hoesehavoge di nianu. ");
INSERT INTO kpx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nahi hilokage Dilavau bae vaveve toela vamale kebia hoto evilivebene. Isito oleuoleu Dilava hoto evisi isivive vamale ata kebia hoto auna evisi. ");
INSERT INTO kpx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Subuta mole ui lohoale kemo atabeu ni kedutebe ni hoesehavo holioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Malaha keu Dilavamo lohoholivatege keu vuvune vavevebe vaholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kateai louge abu hotove ibina vai avuho loui avoe, “A neinau a mamoge a keu vaveve toela unaha vamale ata. Iale kemoike ose a isiviai no haivei.” Abu katelahai loui iovage au dubu halei heie tinu. ");
INSERT INTO kpx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Abu malaha ke iovale hoto ke Iesuu evisi tiale malaha ke elehai avuho loui avoe, “Ana a uvu mai Atae Esemo mamonu.” ");
INSERT INTO kpx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kateai louge malaha keu namihai avoe, “Ata ke ivi daho lounela. Ige di bae kemo di uvu mai avuemo mamoi.” ");
INSERT INTO kpx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ige Iesuu avuho loui avoe, “A subuta ata ke elehanu. Iale keike aike aiti hotoima.” ");
INSERT INTO kpx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ige malaha keu loui avoe, “Kosive, di di uvu mai aemo mamonu.” Kateai louito Iesu vudimo au kome bokoai vata bisi hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kateige Iesuu avuho loui avoe, “Atae vaveveike di kaovaliho vatae lohonu. Iale kemo ni kedute keabuna nilahai. Isege nilahai elehale kebia nina keduai.” ");
INSERT INTO kpx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ige Balisia ata degomoleau keve avuluvuta uale keau ke evisi Iesu belahai avoe, “A hoto louale kemo ose a huhuige noeau ni kedutea.” ");
INSERT INTO kpx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ige Iesuu namigevei avoe, “La ni kedute holiale ke hilokavatege toelau laemo uoholinu. Isito la loui kosea, ‘Noeau nilahai lulelelahalu.’ La kateale loualemo vaveve toelau sohu laemo ua.” ");
INSERT INTO kpx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesuu tota loui avoe, “Seleveta di hoto mole louge evive. Ata oleu ovoe iadi ke udahala velemai tioholisito iadi edolei uvuve tiale keu vavoloe ata. Keu isivialeike mamoe vavoloai. ");
INSERT INTO kpx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Isito ata oleu iadie udaha kela velemai tiale keu mamoe nalievemale ata. ");
INSERT INTO kpx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mamoe nalievemale ata kena tige udaha nalimale kena avuho udaha alavoge auna ke uvue tiniege au mamoe kebia igaegae iviabe ivilovei hohavege abuna hotove evisi lohoge auna holoevei tai. ");
INSERT INTO kpx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Auna kebia holoevei iadi ke halei abuho uli holisi tisege mamoe abuna ehovai tai. Kosealemo keau abu biage hoto ke evisi hilokalu. ");
INSERT INTO kpx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mamoe keau bae ata mole ehovalivebene. Isito abuna ke aehai detuluvisi. Kosealemo keau ke hoto hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesuu dovudovue hoto ke loui namigevege abu ke evisito ihuve hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iesuu tota namigevei avoe, “Seleveta di la namigevege evive. Dau mamoe kebia iadie udaha. ");
INSERT INTO kpx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Di lohoholisege ata degomoleau uli holisi lohoale keau vavoloe ataea. Keau isiviale mamoe malevei. Isito mamoe keau hotoeabe evioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Dau mamoe kebiau tiveve udaha. Iale oleuoleu dae lohoale keabuna udaha kela velehovoge dana kebia malevege abuna ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vavoloe atau lohoale isivialeike mamoe kebia malevei havei aiogevei. Isito dau lohoale isivialeike ukolikoli ovege abu kemo ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Dau mamoe nalievemale atae dua. Iale dana di mamoe kebiaho hatige vavoloe ata keu bae kebia malevelivebene. ");
INSERT INTO kpx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Isito mamoe nalievemale atae toela kena mamoe kebia nalieveniege ovo aihanitena mamoe kebia aiogeveliho lohoge auna kebia halevei detitisi tai. Kosealemo ata keu mamoe kebia nalievemale ata seleve holioholinu. Iale kemo ovo aihanite kena mamoe kebia uagevei aiogevege abuna igaegaeai detuluvisi tai. ");
INSERT INTO kpx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Malaha keu detitiale keu koseanu. Keu mamoe nalievemale biage seleve holioholinu. Iale kemoike ovoe toelau lohoge au mamoe halevei detitinu. ");
INSERT INTO kpx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Dau mamoe nalievemale atae dua. Ige di Mamau di vaveve hilokage data vaveveve hilokanu. Iale ke nahate di di mamoe kebia vaveve hilokaevenu. Ige abuta di vaveve hilokalu. Iale kemo dana di mamoe kebiaho hatai. ");
INSERT INTO kpx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Isito di mamoe degomoleau ua. Keau ovoe iadi mole biaea. Iale dana kebiata malevege abuna di hoto evisi di ehovai. Ige di mamoe keabuna bahata igaetolahai hala igae ke uvumo uge dana kebia nalievei. ");
INSERT INTO kpx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Di di ataho hatiliho negoale kemoike di Mamau daho isivi baluganu. Iale dana hatige di Mamana tota di etuvage dana hovelahai. ");
INSERT INTO kpx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Atabeu bae di lu mage di bae hatilivebene. Isito di biagena di isivimo hatai. Di Mamau daho loui vuvune mai daoale kemo dana hatiniege tota vuvune kemo hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesuu hoto kateale louge Diue kosiveau hoto kemo mole tasalievelu. ");
INSERT INTO kpx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ige degomoleau loui avoe, “Munanae toelau avuemo lohoge keu tilogoanu. Iale osialemoike la hotove evima.” ");
INSERT INTO kpx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Isege degomoleau loui avoe, “Munanae toelau ataemo biloige au bae hoto kateale loulivebene. Munanae toelau avuemo uale kemo au oleve kateike vai ni kedute ke hoesehavonu.” ");
INSERT INTO kpx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Vani mole Diue vahaeho vani moleu lohonu. Subuta mole Diue ataeau vahaeholahai Dielusalemae dubu baluga hoesehavolu. Iale vagana bahata dabae vanila abuna vani ke huhulahai vahaeholahagei. ");
INSERT INTO kpx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iale vani kemo Iesuu Diue dubu baluga ke hedaka mole ivi Solomoni keve lamisi oai tima. ");
INSERT INTO kpx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ige Diue kosiveau lohoale evilikahavoi avuho loui avoe, “No vani moaga a hoto kemo dolodololahalu. Iale ana vadeumalela hoto seleve loui no namigevei. Aike noheho lounela. Au ana no ata tedaevemale kosive Keliso mena.” ");
INSERT INTO kpx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kateai louge Iesuu namigevei avoe, “Avuike di subuta loui la namigevenu. Isito laeau di hoto maholilu. Dau di Mamae vuvunemo vikoe vaveve vaevege la elegevelu. ");
INSERT INTO kpx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Isito la la uvu mai daemo mavoholilu. Kosealemo laeau di mamoe holioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Di mamoe abuna di hoto evisi di ehovage dana kebia hilokaevei. ");
INSERT INTO kpx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Isi ukolikoli ovege abu bae haluvilivebene. Ige atabeu bae di adamo kebia malevelivebene. ");
INSERT INTO kpx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Di Mamau ata kebia malevei daonu. Di Mama keu ata bahata evigevenu. Iale atabeu bae adavemo kebia malevelivebene. ");
INSERT INTO kpx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kosealemo di Mama isi da noeau avuti igae.” ");
INSERT INTO kpx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kateai louge Diue ataeau hovedevei mune malei isiviai hamai. ");
INSERT INTO kpx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Katelahage Iesuu abuho loui avoe, “Di Mamau daho louge di laheho vaveve dua moaga vaevenu. Iale vaveve oletemoike la mune malei isiviai dahavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ige Diue ataeau avuho loui avoe, “A vaveve dua vale kemo no isiviholialeike mune malei ahavoliho. Isito a Dilava ivi aiohavoale kemoike no isiviai ahavoi. Au ata unaha. Isito au a ebika ebagemai loui kosea, ‘Dau Dilava.’ Iale kemoike no isiviai ahavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ige Iesuu namigevei avoe, “La menaka kemo abu subuta hoto koseale hisalilahalu. Avoe, ‘Dilavau loui avoe, Laeau dilavaea.’ ");
INSERT INTO kpx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iale nahi hilokage Bukae Hotomo abu hisaliale hoto keu seleve. Iale kena vani bahata ugei. Hoto kemo Dilavau au ata tabageveale kebia au abuho loui avoe, ‘Laeau dilavaea.’ ");
INSERT INTO kpx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iale di Mamau di ebagemai di hanavoge di vatae lohonu. Iniale laheho loui kosea, ‘Dau Dilava mo.’ Iale osialemoike la daho loui kosea, ‘A Dilava ivi aiohavonu.’ ");
INSERT INTO kpx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mesoho di di Mamae vaveve vaholige kemo bae la uvu mai daemo mavoholive. ");
INSERT INTO kpx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Isito di di Mamae vaveve vage la kemo la uvu mai daemo mavoholilu. Iale di vikoe vaveve vale kemo bae la uvu mavove. Ilive elike kemo di Mamau daiti usege di avuemo uale ke hilokave.” ");
INSERT INTO kpx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kateai louge abu isiviai mai kotai. Isito Iesuu adaeabe kabosevenu. ");
INSERT INTO kpx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Isi tiale Diodani e houi vaki mole tiale Dioniu subuta ata babatisogeveale keve ua. ");
INSERT INTO kpx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ige ata moagatahoeau avue loholu. Avue loholiale moleho loui avoe, “Dioniu vikoe vaveve vaeveholinu. Isito Dioniu ata ko vaveve louale hotove bahata keu seleve unaha.” ");
INSERT INTO kpx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hoto kateale louge ata moagaeau hoto ke evisi abu uvu mai Iesuemo mavoi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Beteni malaha mole ivi Lasolo keu vavahanianu. Iale o kemoike amakinive abuitau ua. Moleike Mata. Ige hohove Meli. ");
INSERT INTO kpx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meli keike deholo hagote mai Iesu velomo ehosivai au kinata Iesu velo ulihanu. Iale ke amakini Lasolo keike vavahanianu. ");
INSERT INTO kpx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ige mahohoeabe keau Iesuho hoto hanavolu. Avoe, “Kosive, a uvue haokau vavahanianu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ige Iesuu hoto ke evisi loui avoe, “Lasolou vavahaniale ke gabiu bae hatihati mai loholivebene. Isito gabive kena Dilava ivi mai duatisi. Ige kemo Dilava moe ivitana balugai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesuu Mata isi hohove isi amakinive Lasolo kebia isivi ovenu. ");
INSERT INTO kpx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Isito keu Lasolo vavahanie hoto ke maito solekai tioholinu. Au hoto ke evisito au uale keve vanie ni abuita ua. ");
INSERT INTO kpx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iniale vanie ni abuita keau uoholige au au esemu namigevei avoe, “Nahi hoidevei tota Diudiae tai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ige esemuiabeau avuho loui avoe, “No kosive, nahi aike Diudia keve usege ata keau isivialeike muneta ahavoi. Iale osialemoike a isiviale nahi tota hoidevei keve tai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ige Iesuu namigevei avoe, “Nahiabuna vanimo olahaliege nahi bae ono molemo vatoi dobuluvilivebene. Kosealemo vanie agamoike nahi olahama. ");
INSERT INTO kpx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Isito nahiabuna vavimo olahaliege ono molemo vatoi dobuluvisi. Kosealemo nahi hati maleholilu. Iale ke nahate nahiabuna Dilava isivi valiege nahi bae atae vaveve toela ke vabuhavolivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kateai louito tota namigevei avoe, “Nahie haoka Lasolo keu lahanu. Isito dana tiniege etuvage auna hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ige esemuiabeau namihai avoe, “Kosive, au lahale kemo auna momoleai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abu katelahai huhulahai avoe, “Lasolou laha unahanu.” Isito Iesu eu hilokage keu hatinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iale kemo Iesuu inuta namigevei avoe, “Lasolou hatinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Di keve uoholisege au hatiale keu duave. Kosealemo dana tiniege la totonamo vaveve mole vage lana ke elehai la uvu mai daemo mavove. Iale lohoge nahi avue tai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ige malaha mole ivi Tomasi (ivive mole Didimasi) keu Iesu esemu degomole namigevei avoe, “Lohoge nahi avuluvuta talive elike abu hamage nahi avuluvuta haluvisi.” ");
INSERT INTO kpx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Abu tiliale velehovoi evige abu Lasolo mai abavuale vanie ni abuita abuita uoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lasolo o Beteni keu Dielusalema o baluga kemo haeavaveu tu (2) maelo. ");
INSERT INTO kpx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iale Matau Meliti abu amakiniho uvulahale kemo Diue ata moagaeau o baluga ke halevai loholiale abuhi uvulahalu. ");
INSERT INTO kpx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ige Matau Iesuu lohoale hoto ke evisi o halei tiale Iesuemo tinu. Isito Meliu oe ua. ");
INSERT INTO kpx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Isi tiale Iesu namihai avoe, “Kosive, a kove ubeto di amakiniu hatioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Isito di hilokage ana nova onole loui Dilava imihage auna a isivi ke vai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ige Iesuu avuho loui avoe, “A hohona tota hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ige keate keu namihai avoe, “Di hilokage auna vanie gabila bae hovelahai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ige Iesuu namihai avoe, “Dau hovelahaveve biage. Isi dau lu maleveve ke biage. Iale oleuoleu abu uvu mai daemo mavoito haluviale keabuna bae ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Isi oleuoleu nita ui abu uvu mai daemo mavoale kebiata abuna ukolikoli malei. Iale ana di hoto ke manu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ige keate keu namihai avoe, “Ito, Kosive, di hilokage au Dilava mo. Dilavau a hanavoge a vatae lohoale no tedaevemale kosive holinu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matau hoto ke louito hoilahai tiale tobekai au hoho Meli namihai avoe, “Kosiveu aike lohonu. Keu di namihai isivialeike a elehai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ige Meliu hoto ke evisi solekai hovelahai tiale Iesue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesuu sohu oe lohoholisito Matau avuemo tiale keve usege Meliu avuemo tinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ige Diue ataeau Meliluvuta uvulahale keau elehage Meliu solekai hovelahai tige abu ehovai tilu. Kosealemo keau huhuige Meliu au amakini vutae ninalihoike au tinu. ");
INSERT INTO kpx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Isi tiale keu Iesu uale kela velemai vudivemo kome bokoai vata bisi avuho loui avoe, “Kosive, a kove ubeto di amakiniu hatioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kateai avuho loui ninage Diue ataeau avuluvuta lohoale kebiata ninalahalu. Ige Iesuu kebia elegevege uvuu hamanu. ");
INSERT INTO kpx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ige Iesuu belagevei avoe, “La oleve abavulu.” Ige abu namihai avoe, “Kosive, loholive elehanela.” ");
INSERT INTO kpx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kateai louge Iesuu ninanu. ");
INSERT INTO kpx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ige Diue ataeau ke elehai moleho loui avoe, “Elehave. Keu avuho uvu baluganu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ige degomoleau loui avoe, “Ose keike ni kedute ke ni hoesehavoge au nianu, e. Iale au osiohoike solekai loholive Lasolo hoesehavoge au vavahanimo momoleholisito unata bae au hatisege iave lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kateisege uvuu tota Iesu hamage au halei vutave tinu. Vutave keu metae vaha nahate. Iale mune moleu vutave ili ke bamunu. ");
INSERT INTO kpx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ige Iesuu ata namigevei avoe, “Mune ke evovoave.” Kateai louge hatiale ke amakini Mata keu Iesu namihai avoe, “Kosive, no ke abavuale vanie ni abuita abuitaeau uoholilu. Iale kena hisiai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ige Iesuu avuho loui avoe, “Di subuta aho loui kosea, ‘Ana a uvu mai daemo mamoniege Dilava vuvune vaveve ke elehanela.’ Dana aho kateai lounu, e.” ");
INSERT INTO kpx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kateai keate keho lousege abu mune ke evovoalu. Ige Iesuu ehue niai loui avoe, “Di Mama, a di hoto eviale kemo di a vahaeho vanu. ");
INSERT INTO kpx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Di hilokage a vani bahata di hoto evima. Isito ata kobiau kove uale kemoike di hoto ko loui isivialeike abu ke evisi hilokage a di hanavonu.” ");
INSERT INTO kpx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kateai louito ke iae baita hoai loui avoe, “Lasolo, velemai loho.” ");
INSERT INTO kpx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kateai hoage hatiale keu velemai lohonu. Velemai lohoge abu subuta ogota viliale keu sohu vavavemo ua. Ige nive viliale keta emo ua. Ige Iesuu ata namigevei avoe, “Vavavemo ogo ke bodiage auna oai tai.” ");
INSERT INTO kpx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kateige Diue ataeau Meliluvuta uvulahaho lohoale kebia degomoleau Iesu vaveve ke elehai abu uvu mai avuemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Isege degomoleau hoidevei tiliale Iesuu vale hoto ke loui Balisia ata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ige Balisia ata keau dubu nalimale kosivebiahi igaetolahai hotohotoai mole namigevei avoe, “Iesu keu vikoe vaveve moaga vaevenu. Iale nahiabuna ono vade igae avuemo vai. ");
INSERT INTO kpx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nahiabuna ke nimo tahoige kena vani bahata katelage ata bahataeabuna ehovai ivive ebagevage Loma gamani kosive abuna loholiege nahie dubu baluga koilahai nahie ata bahata havehatui.” ");
INSERT INTO kpx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kateai louge kebia vigomo dubu nalimale kosive baluga Kaiabasi keu hovelahai namigevei avoe, “La keau luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nahi ata ke igae hamage au hatige keu duave. Onoilage ata ke igaeho Loma ataeau loholiege nahie ata bahata havehatuge uoholima.” ");
INSERT INTO kpx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Keu hoto ke louale keu au isivimo louholinu. Isito keu dubue kosive baluga holiale kemoike au Iesuu Diue ataho hativeve ke hilokai lounu. ");
INSERT INTO kpx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Au hoto ke louale keu Diue ata unahaho au louholinu. Isito Iesuu hatiale kemo Dilava ese bahata oleve uale kebia auna bevuevege abuna igaetolahai ui. ");
INSERT INTO kpx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Iale vani kemoike Diue kosiveau lavisi Iesu hamaveve humaha ke kaovama. ");
INSERT INTO kpx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iale kemo Iesuu Diudia vata keve ohanoi tiveve keu anekianu. Katealemo Iesuu vata ke halei tiale tomagie vavae o mole ivi Ibelemi keve au esemuhi ua. ");
INSERT INTO kpx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Keve usege Diue vahaeho vani mole Basova keu vuguvuguanu. Ige ata moagaeau hovedevei abu o halevei o baluga Dielusalema keve tilu. Keve tiale isivilahai vasohuta abu vaveve toela ulihaito gabie Basova lovi ke isi. ");
INSERT INTO kpx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Isi katelahai tiliale abu dubu baluga keve Iesu kaovalu. Isi mole belagevei avoe, “La huhuige kena valive Basova lovi koho lohoi. Mena au bae loholivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abu hoto ke louale keu koseanu. Dubu nalimale kosivea isi Balisia ata keau isivialeike Iesuu lohoge abu mai kotai. Iale keau ata namigevei avoe, “Iesuu oleve uale ke la hilokaliege no haiveve.” ");
INSERT INTO kpx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Basova vahaeho vani ke bula igaeu usege Iesuu Betenie tinu. O keu Lasolo o. Lasolo keike hatige Iesu etuvage au hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iale Iesuu tiale keve velemage Matau avuho lovi vanu. Matau lovi vasege Lasolou Iesuti uguiavoi molehi sisilama. ");
INSERT INTO kpx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sisilasege Meliu deholo mole hagote mai lohonu. Deholo keu ibina balugate. Iale au ke mai lohoale Iesu velomo ehosivai au kinata velove ulihanu. Ige deholo ke hagou oe uvu bahata hagotinu. ");
INSERT INTO kpx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ige Iesu esemu mole avuho haiaveve Diudasi Kaliota keu ke elehai kemo hoto lounu. ");
INSERT INTO kpx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Avoe, “Keate keu osiohoike ke ehosivanu. Keu kemo moni baluga hatunu. Iale abege au mai voiai kemo tili handele kina (K300) malei kunaiholimale kebia ovei.” ");
INSERT INTO kpx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Au hoto louale keu koseanu. Keu kunaiholimale kebia huhuevei hoto ke louholinu. Isito au ebikaike au huhuai hoto ke lounu. Kosealemo keu vavoloe ata. Isi keu Iesuta esemuiabeta moni nalimale ata. Iale kemoike au moni ke huhuai isivialeike moni ke malei otovelive gabie moni kemo au ebika tedahoi. ");
INSERT INTO kpx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iale Diudasiu kateai louge Iesuu avuho loui avoe, “Halege au ke valeu duave. Di hativeveu vuguvuguike vage au deholo hagote keta di gadehavoma. ");
INSERT INTO kpx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kunaiholimale keabuna vani bahata lahehi uge lana kebia tedaeveve. Isito dau bae vani bahata lahehi ulivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Diue ata moagaeau Iesu Betenie uale ke evisi keve tilu. Keve tiale Iesu igae elehaho tioholilu. Isito isivialeike Lasolou hatige Iesu etuvale keta abu elehai. ");
INSERT INTO kpx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ige kemo dubu nalimale kosiveau isivialeike Lasolota hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kosealemo Lasolou hovelahale kemo Diue ata moagaeau abu kosive halevei abu uvu mai Iesuemo mavoi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iesuu Betenie tisege Diue ata moagaeau Basova vahaeho vani keho lohoale Dielusalemae ua. Iale keau vavita evige Iesuna Dielusalemae lohoi. ");
INSERT INTO kpx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ige ata keau ke evisi idi mole niue vana ke nahate heisi bohisi malei Iesu beiavoi tilu. Beiavoi tai baita loui avoe, “Seloo, Iselalae kosive kou Dilava ivimo lohoale ko nahi hoesehavoi. Ata keu Iselala ata nahie kosive. Iale Dilavana ke hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kateai lousege Iesuu donikimo ugulamoi lohonu. Ugulamoi lohoale keu Bukae Hotou louale ke mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Bukae Hotou loui avoe, “Saioni omo umale ataea, lainaho vabulahalive. La kosiveike donikie dogamo ugulamoi lohoma.” ");
INSERT INTO kpx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iale vani kemo Iesu esemu keau hoto kemo luleleholilu. Isito vani mole Iesuu hovelahai ehue tiale kemoike abu lulelelahai hilokage Iesu vaveve keu Bukae Hoto ke mai selevetinu. Iale keike abu ke avuho valu. ");
INSERT INTO kpx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ata moagaeau Iesu beiavoi tiale kebia degomoleau subuta Iesuu Lasolo etuvale ke abu elehalu. Elehasege Iesuu hoage Lasolou abu abavuale ke gulimo hovelahai lohonu. Iale keau ke elehai tialeau hoto ke loui ata moaga namigevelu. ");
INSERT INTO kpx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ige ata keau Iesu vuvune vaveve ke vale hoto ke eviale kemoike abu Iesu beiavoi tilu. ");
INSERT INTO kpx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Beiavoi tige Balisia ataeau ke elehai moleho loui avoe, “Elehave. Ata bahataeau Iesu ehovalu. Iale nahiabuna oleve kateai humahave bamui.” ");
INSERT INTO kpx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Basova vahaeho vani keho Dielusalemae lohoale ata kebia degomoleau Giliki ataea. ");
INSERT INTO kpx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Iale keau lohoale Iesu esemu mole Bilibi namihalu. Bilibi keu Galili vata kemo o mole ivi Betesaida ke ata. Iale abu ata ke namihai avoe, “Kosive, no isiviai Iesu elehai.” ");
INSERT INTO kpx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Katelahai louge Bilibiu tiale Andulu namihanu. Isi avuti tiliale Iesu namihalu. ");
INSERT INTO kpx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ige Iesuu abuho loui avoe, “Atae Eseu hativeve vaniu lohoale auna hatige Mamavena hoesehavoi tota atagave omisi. ");
INSERT INTO kpx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iale di hoto seleve louge evive. Di vaveve keu konee nie bai nahate. Lana konee nie bai igae mai hatuholige keu bae moagalivebene. Isito lana ke igae mai hatuge nive igae kemo konee luhu abuna moagai. ");
INSERT INTO kpx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Vata kove ata oleu au ebika unaha huhuaniege auna gabie ukolikoli hosidisi. Isito ata oleu au ebika huhuholiale kena ehue tiniege ukolikoli malei ue dua vai. ");
INSERT INTO kpx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iale oleuoleu isivilahai di lovi valiho valiege abu di esemu holisi di ehovai. Ige dana kebia holoevei tige abuna di uale keve daluvuta ui. Ige di Mamana oleuoleu di lovi vale kebia ivi tabagevei.” ");
INSERT INTO kpx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iesuu kateai abuho louito tota hoto mole loui namigevei avoe, “Di uvuu aike hadanu. Iale dana hoto vade loui. Dana vali loui kosea, ‘Mamai, ainaho vani ke halege au daemo loholive. Isito di bae kateale loulivebene. Dana eve negoai vatehani ke malei. Kosealemo vatehani ke malehoike di lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Hoto kateale louito au Mama imihai avoe, “Mamai, di isiviale ataeau di vavevemo a ivi ebagevai.” Kateai louge hoto moleu otogomo lohoi avoe, “Di subuta a vavevemo di ivi ebagemanu. Iale dana tota a vavevemo di ivi ebagema moleai.” ");
INSERT INTO kpx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ige ataeau Iesu vavamo laviale keau hoto ke evisi loui avoe, “Hatau luluanu.” Isege degomoleau loui avoe, “Aneluike avuho hoto lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ige Iesuu abuho loui avoe, “Hoto keu di totonamo lohoholinu. Isito hoto keu la totonamoike lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","32","Iale dana aike ata bahataho idie domo hatige ata oleuoleu abu uvu mai daemo mavoale kebia Dilavana uvuiabe kaovai hilokaevei valive Vatae Kosive ke vuvunemo au ebikaho malevei.” ");
INSERT INTO kpx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesuu hoto kateai loui isivialeike ataeau hilokage auna oleve kateai hatai. ");
INSERT INTO kpx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kateai louge ata moaga keau hotove ibina vai avuho loui avoe, “No menaka kemo no hilokage ata tedaevemale kosive Keliso keu bae hatilivebene. Isito kena vani bahata ui tigei. Iale osialemoike a loui kosea, ‘Abuna Atae Ese mai idie domo hamai.’ Iale Atae Ese keu oleike.” ");
INSERT INTO kpx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kateai louge Iesuu namigevei avoe, “Atagau bae vani moaga lahehi ulivebene. Iale ataga keu lahehi usege nenilahai ataga kela olahai teve. Lana kela tige vaviu bae laemo loholivebene. Isito oleuoleu vavimo timale keau abu oleve timale ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iale ataga keu lahehi usege la uvu mai avuemo mavove. Ilive elike atagae ata holive.” Iesuu kateai louito halevei lilikateve tinu. ");
INSERT INTO kpx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kosealemo au atae nimo vikoe vaveve moaga vaeveale ke abu elehaito abu uvu mai avuemo mavoholilu. ");
INSERT INTO kpx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Vaveveabe keu beloveta mole Aisaia ke hoto mai selevetinu. Beloveta keu subuta loui avoe, “Kosive, di a hoto louge ataeau a hoto ke evisito maholilu. Ige a vuvune vaveve vale keta abu elehaito a ehovaholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Katealemo evievi vaveve keu abuemo anekianu. Iale kemo Aisaiau tota hoto mole lounu. ");
INSERT INTO kpx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Isi avoe, “Dilavau niabe bamui uvuiabeta bamunu. Kosealemo keau isiviholilu Dilavae lohoge au hoesegeveliho. Katealemo au niabeta uvuiabeta bamuge elike abu elehai lulele halevai.” ");
INSERT INTO kpx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiau hoto ke louale keu koseanu. Keu Iesu ataga elehale kemoike au vaveveve ke louge ataeau kemo luleleholilu. ");
INSERT INTO kpx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isito Diue ata kebiamo Diue kosive degomoleau abu uvu mai Iesuemo mavolu. Abu katelahaito isiviholialeike ataeau ke hilokaliho. Kosealemo Balisia ataeabuna ke hilokaliege Diue kosive kebia iovege abu bae tota loholive dubue guligulilahalivebene. ");
INSERT INTO kpx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vaveveabe keu toelanu. Kosealemo abu Dilavau kebia tabageveveve ke huhuoholisito isivialeike ataeau iviabe tabagevei. ");
INSERT INTO kpx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesuu tota ata haivei baita abuho loui avoe, “Ata oleuoleu abu uvu mai daemo mavoale keau abu uvu mai da igaemo mavoholilu. Isito keau abu uvu mai di hanavoale ata ketamo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Isi ata oleuoleu di elehale keau di hanavoale ata ketaike abu elehalu. Kosealemo dau ke vaveve nahate. ");
INSERT INTO kpx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Di vatae lohoaleu ataga nahate vanu. Iale oleuoleu abu uvu mai daemo mavoale keau bae vavimo ulivebene. ");
INSERT INTO kpx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Isi oleuoleu di hoto evisito di ehovaholige di bae kebia vaveve abuemo kaovei abuho hoto loulivebene. Kosealemo dau vatae atae vaveve kaovaliho lohoholinu. Isito dau vatae ata kebiaike maleveliho lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iale oleuoleu di kabebihavoi di hoto maholige olena abuemo vaveveabe kaovai. Atabeu bae vaveveabe kaovalivebene. Isito vanie gabila di louale hoto kena bae vaveveabe abuemo kaovai. ");
INSERT INTO kpx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kosealemo di hoto louale keu da igae hoto holioholinu. Isito di Mamau di hanavoale keike di onole loui ata haiveveve hoto ke loui di namihanu. ");
INSERT INTO kpx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iale di hilokage hotove kemo lana ukolikoli maleve. Kosealemo di hoto louale keu di hoto holioholinu. Isito di Mamau daho louale hoto keike di laheho lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iniale Basova vahaehoe vani keu lohoholisege vanive igaeu usege Iesuu hilokage au vata halei hoilahai au Mamae tiveve ke vaniu lohonu. Ige isiviveu au vatae esemuemo ualemo au isiviale vaveve mole vage abu elehai isivive ke hilokai. ");
INSERT INTO kpx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iale vavi kemo Iesuu au esemuhi ugulamoi lovi isege esemuiabe kebia vigomo Seteneu esemuve mole Saimoni mo Diudasi Kaliota ke uvumo Iesuho haiaveve ke huhuihuhui mai avuemo mamonu. ");
INSERT INTO kpx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isito Iesuu hilokage Mamaveu vuvune bahata ominu. Isi hilokage keu Dilavamo lohoale kemo auna tota hoilahai Dilavae tai. ");
INSERT INTO kpx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Iale abu lovi isege Iesuu hovelahai au ogo iamoi tauvela mai holovanu. ");
INSERT INTO kpx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Isi e hai disimo ehosivai mai tiale au esemue velo totoevei tauvela keta veloeabe ulihanu. ");
INSERT INTO kpx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Isi lohoale Saimoni Bita velo totoaliho vage au avuho loui avoe, “Kosive, seleveta ana di velo totoai.” ");
INSERT INTO kpx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ige Iesuu namihai avoe, “Di aike onole vamale ko a hilokaholinu. Isito gabie ana bae hilokanela.” ");
INSERT INTO kpx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ige Bitau avuho loui avoe, “A bae di velo totoalivebene.” Ige Iesuu avuho loui avoe, “Di a velo totoholige a bae di esemu holilivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ige Bitau loui avoe, “Kosive, a di velo totoaniege di adata di kinata totoanela.” ");
INSERT INTO kpx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ige Iesuu namihai avoe, “Ata oleu baita emoaniege au bae tota au vava bahata emohavolivebene. Isito auna au veloe voto unaha totoai. Iale ke nahate di la uvu hoesegevege duaveanu. Isito la vigomo ata mole igae di ke hoesehavoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesuu hoto ke louale keu koseanu. Keu hilokage ata kena avuho haiai. Kemoike au loui avoe, “Di la bahata hoesegevenu. Isito la vigomo ata mole igaeu di hoesehavoholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesuu kateai loui veloeabe bahata totoai gabiaito tota au ogo mai hatui tota abuhi ugulamoi abuho loui avoe, “Lana di laemo vadeu vale ke ihu hilokalu. ");
INSERT INTO kpx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","La di ivihai daho loui kosea, ‘No haivemale ata.’ Isi daho loui kosea, ‘Kosive.’ La daho kateai louale keu duave. ");
INSERT INTO kpx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kosealemo dau la haivemale ata. Isi dau la Kosive. Iale di la velo totoale ke nahate mole velo totoeveve. ");
INSERT INTO kpx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Di aike la haiveale ke nahate vai mole hoesegeveve. ");
INSERT INTO kpx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Di hoto seleve loui la namigevege evive. Esemubeu bae au kosive evihalivebene. Ige ata oleu au kosive hoto loumale keu bae au kosive ke evihalivebene. ");
INSERT INTO kpx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Di aike vaveve mole vale kemo lana lulelelahai ke valiege lana vahaeholahave. ");
INSERT INTO kpx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Isito di hoto ko loualeu la bahataho louholinu. Di hilokage di la bahata tabagevenu. Isito la mole igaena di aiohavoi. Ige vaveveve kena Bukae Hoto mai selevetisi. Bukae Hotou loui avoe, ‘Ata moleu daiti lovi iale kena dahoe haiai.’ ");
INSERT INTO kpx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iale hoto ke ihuu sohu lohoholisege di isiviale vasohuta la namigevei. Ilive elike gabie vaveve keu lohoge lana kemo di hoto ko mai hilokage dau di louale ata ke da. ");
INSERT INTO kpx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Di seleveta la namigevege evive. Di la hanavege ata olena la tedaevei la hoesegeveniege dataike au ke tedahoi hoesehavonu. Isi olena di tedahoi di hoesehavoniege di hanavoale keike au ke hoesehavonu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesuu hoto ke loui gabiasege uvuu hamanu. Ige kemo au inuta kebia namigevei avoe, “Seleveta di la namigevege evive. La molena bae di mai atae toela ovege abuna dahavoi.” ");
INSERT INTO kpx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kateale louge esemuiabeau hoto ke evisi dolodololahai mole nibievei lotilu. Isi huhulahai avoe, “Kou oleike au huhuai hoto ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isege Iesu uvue esemu mole keu vavavemo ugulamoi ua. ");
INSERT INTO kpx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ige Saimoni Bitau esemu ke sitohavoi namihai avoe, “Iesu belahai kosea, ‘Esemu oleike au huhuai hoto ke lounu.’” ");
INSERT INTO kpx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kateai louge esemu keu valolahai mulumuluai Iesu namihai avoe, “Kosive, ata oleike a ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ige Iesuu namihai avoe, “Elehalive di valavae ivi mai melegimo manemei mai ata mole omige ata ke avuike ke.” Iesuu hoto ke louito valavae ivi mai melegimo manemei mai Saimoni mo Diudasi Kaliota ke ominu. ");
INSERT INTO kpx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ige Diudasiu Iesu adamo lovi ke masege solekavesite Seteneu uvuvemo holomanu. Ige Iesuu Diudasiho loui avoe, “A isiviai onole valiho vaniege solekai vanela.” ");
INSERT INTO kpx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kateai avuho louge esemuiabeau keve uguiavoale keau Iesu hotoe ihu ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ige degomoleau huhulahai avoe, “Diudasiu nahie moni naliale kemoike Iesuu avuho louge auna vahaeho vanie lovi voiai.” Isege degomoleau huhulahai avoe, “Mesoho Iesuu namihage auna moni malei kunaiholimale kebia ovei.” Esemu keau katelahale huhulahalu. ");
INSERT INTO kpx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Isito Diudasiu Iesu adamo valavae ivi male keta solekavesite heie dobai tinu. Keu vavimoike au ke vanu. ");
INSERT INTO kpx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Diudasiu halei tisege Iesuu au esemu namigevei avoe, “Atae Eseu tota au ataga maleveveu vuguvuguanu. Vani kena lohoge Atae Esena hatai hovelahage ataeabuna ke elehai Dilava ivi ebagevai. ");
INSERT INTO kpx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ataeabuna avuemo Dilava ivi ebagevage Dilavana avuta solekai au mo mai tota atagave omisi. ");
INSERT INTO kpx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Di esea, di bae vani moaga lahehi ulivebene. Ige vani mole lana di kaovaito bae di elehalivebene. Iale di Diue ata namigeveale ke nahate di la namigevei. La bae di tiveve matama keve talivebene. ");
INSERT INTO kpx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Di menakae doga laheho louge evive. Moleho isivilahai mole tedaeveve. Di laheho isiviale ke nahate vai moleho isivilahai mole tedaeveve. ");
INSERT INTO kpx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lana moleho isivilahai mole tedaevege kemo ataeabuna hilokage laeau di esemuia.” ");
INSERT INTO kpx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kateai louge Saimoni Bitau belahai avoe, “Kosive, a oleveike taliho lounu.” Ige Iesu namihai avoe, “Di tiveve matama keve a bae aike talivebene. Isito gabie ana bae di ehomai keve tenela.” ");
INSERT INTO kpx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ige Bitau namihai avoe, “Kosive, osialemoike a daho loui kosea, ‘A bae aike daiti talivebene.’ Di isivialeike aiti talive abu ahavoi data hamai.” ");
INSERT INTO kpx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ige Iesuu namihai avoe, “Seleveta ana isiviai daiti talive hatai. Di a namihage evinela. Novae vavimo kokoluguu hotoholisege ana di vovoho abuita igaetai kosea, ‘Di ata ke hilokaholinu.’” ");
INSERT INTO kpx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesuu kateai Bitaho loui gabiaito tota au esemu namigevei avoe, “Lainaho di louale ke evisi uvulahalive. Isito la uvu mai Dilavamo mavoi datamo mavove. ");
INSERT INTO kpx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Di Mamae o keve oe uvu moagamoagaeau ua. Iale dana keve tiniege laheho kebia hoesegevei. Hoto keu loboholivatege di la namigeveholinu. Isito hoto keu seleve. ");
INSERT INTO kpx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iale dana tiniege laheho oe uvu kebia hoesegevei gabiaito tota hoilahai lohoniege la malevege lana daluvuta keve teve. Iliege di uale keve lana daluvuta uve. ");
INSERT INTO kpx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Di tiveve matama ke la hilokalu. Isi matama ke humahata la hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Iesuu kateai louge esemuve mole Tomasiu namihai avoe, “Kosive, a oleve tiveve ke no hilokaholilu. Iale noeabuna oleve kateai humahave ke hilokai.” ");
INSERT INTO kpx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ige Iesuu namihai avoe, “Humaha ke dailiko. Isi dau hoto seleve loumale kosive. Isi dau ukolikoli biage. Iale da igaemo lana di Mamae teve.” ");
INSERT INTO kpx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kateai louito namigevei avoe, “La di hilokavatege di Mama keta hilokalu. Isito la aike di elehale kemo la di Mama elehai hilokalu.” ");
INSERT INTO kpx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ige Iesu esemu mole Bilibi keu Iesuho loui avoe, “Kosive, no isivialeike a Mama mai no haivenela. Ige elike kemo gabie no a belaha halevai.” ");
INSERT INTO kpx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ige Iesuu Bilibi namihai avoe, “Di subuta vani moaga lahehi ui la haivenu. Isito la sohu di hilokaholilu, ani. La oleuoleu di elehale la keau di Mama elehalu. Iale osialemoike a daho loui kosea, ‘A Mama mai no haivenela. ");
INSERT INTO kpx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Di aho loui kosea, ‘Dau di Mamati ua. Ige di Mamau daiti ua.’ Isito mesoho a hoto ke maholinu. Di laheho hoto louale keu da igae hoto holioholinu. Isito di Mamau daiti umale ke hotoike di laheho lounu. Keu daiti ui au lovi vama. ");
INSERT INTO kpx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Iale lana di hoto mai hilokage dau di Mamati ua. Ige di Mamau daiti ua. Isito mesoho hoto keu laemo isuige di vuvune vaveve vage la elegeveale kemo la uvu mai daemo mavove. ");
INSERT INTO kpx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Seleveta di la namigevege evive. Oleuoleu abu uvu mai daemo mavoale keabuna di lovi vale ke nahate abuna vai. Ige loviabe kena di lovi ke evihai balugai. Kosealemo dana tota hoilahai di Mamae tisege loviabe kena kateai. ");
INSERT INTO kpx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ige vani kemo lana di ivimo onoleho di imihage dana la isivi ke vai. Dana vaveve kateale vage kemo di Mamae ivi kena balugai. ");
INSERT INTO kpx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iale lana di ivimo onoleho di imihage dana la isivi ke vai.” ");
INSERT INTO kpx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“La di huhuai la isivi daoliege di menaka ehovave. ");
INSERT INTO kpx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ige dana di Mama namihage auna la hoesegeveveve Munanae Tumu ke laovege auna di hoto seleve mai la haivei vani bahata la uvumo ugei. ");
INSERT INTO kpx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Isito vatae ataeau bae ke malivebene. Kosealemo Munanae Tumu ke elehai hilokaveve keu abuemo anekianu. Isito laeau ke hilokalu. Kosealemo keu aike lahehi ua. Iale auna bae la uvumo ugei. ");
INSERT INTO kpx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Dana la halevei tai. Isito di la halevege la bae la unahahame ulivebene. Isito dana tota hoilahai lae lohoi. ");
INSERT INTO kpx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Di aike hatige vatae ataeau bae di elehalivebene. Isito laeabuna di elehave. Isi di hovelahale kemo lana lata hovedevei ukolikoli maleve. ");
INSERT INTO kpx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ige vani keu lohoge kemo lana hilokage dau di Mamati ua. Isege laeau daluvuta ua. Ige data lahehi ua. ");
INSERT INTO kpx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ata oleuoleu isivi daoale keabulike di hoto evisi ehovai abu uvu daovalu. Iale abu isivi daovai abu uvu daovale kebia di Mamana avuta huhuevei au isivi ovei. Ige dana data kebia huhuevei di vaveve haivege abuna ke hilokai.” ");
INSERT INTO kpx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kateai louge Diudasi Kaliota ke haleito Diudasi mole keu Iesuho loui avoe, “Kosive, osiohoike a vaveve no haiveito vatae ata kebia haiveholisi.” ");
INSERT INTO kpx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ige Iesuu namihai avoe, “Ata oleuoleu di huhuai abu uvu daovale keabuna di hoto evisi ehovai. Ige di Mamana avuta kebia huhuevei au uvu ovei. Ige no Munanae Tumu kemo noeabuna no Mamati kebia isivi ovei loholiege abuhi ui hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Isito oleuoleu daho isiviholiale keau bae di hoto evisi ehovalivebene. La di hoto eviale keu di hoto holioholinu. Isito di hanavoale di Mama ke hotoike. ");
INSERT INTO kpx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Di lahehi ualemoike di hoto ko bahata laheho lounu. ");
INSERT INTO kpx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Iale dana la halevei tisege di Mamana di ivimo la hoesegeveveve Munanae Tumu ke hanavoi. Ige kena vaveve bahata la haivege lana kemo di louale hoto ke bahata huhueveve. ");
INSERT INTO kpx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Lainaho di la halevei tiveve ke huhulahage la uvuu kibikibiai vabualive. Kosealemo di uveve duaike ke mai laovenu. Uveve keu vatae uveve ke nahate holioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","La evige di laheho loui kosea, ‘Dana la halevei tiniege tota hoilahai lohoniege la elegevei.’ Iale la daho isivivatege di di Mamae tiveve ke evisi vahaeholahalu. Kosealemo di Mama keu di evihai kosive baluga holinu. ");
INSERT INTO kpx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Di louale vaveve keabuna bae daemo lohoi. Katealemoike di hoto ko loulive elike gabie vaveve keau lohoge lana elehai la uvu mai daemo mavove. ");
INSERT INTO kpx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Di bae gabie lahehi hotomoagalivebene. Kosealemo Vatae Kosiveu di aiohavoliho lohoma. Isito vuvuneve keu di vuvune nahate holioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Di isivialeike di Mamau daho louale ke bahata vage vatae ataeau ke elehai kemo hilokage di di Mama isivi omisi di uvu bahata ominu. Di hotou kemo kateai ua. Iale lohoge nahi halevai tai.” ");
INSERT INTO kpx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesuu kateai louito abuhi tialeu namigevei avoe, “Seleveta dau hote mole uaini ke nahate. Isege di Mamau hote ke biage. ");
INSERT INTO kpx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iale hote ke atiana hahumaholige auna ke heisi etulei mai mihatui. Isito atiave degomoleau hahumale kebia auna hoesegevege abuna nenilahai baie dua vai. ");
INSERT INTO kpx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iale laeau hote ke atia nahatea. Di hoto laheho louale keu la hoesegevege la kemo ue dua vama. ");
INSERT INTO kpx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Iale negolahai daemo uve. Ige datana lahehi ui. Hotee atia keu bae heiata hahumalivebene. Isito kena hote tava kemo igaetoai uniege auna hahumae dua vai. Ke nahate la daluvuta igaetolahaholiliege la bae vaveve dua valivebene. Isito lana daluvuta igaetolahaliege vaveve dua vave. ");
INSERT INTO kpx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Dau hote mole uaini ke nahate. Isege laeau atiave. Lana daluvuta igaetolahai uge dana lahehi ui. Ige kemo lana vaveve dua vave. Isito la di halevaliege la bae onobe dua valivebene. ");
INSERT INTO kpx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ata oleuoleu daluvuta igaetoholiale keau idie adau giliai bokolahale ke nahate. Ataeabuna idie ada kateale homoi malei venemo mahoi. ");
INSERT INTO kpx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Isito lana daluvuta igaetolahage di hotona laemo negoai ui. Ige la onoleho isiviai di imihage dana ke laovei. ");
INSERT INTO kpx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lana katelahai di esemu seleve holisi idiu hahumale ke nahate vage di Mamae ivina kemo balugai. ");
INSERT INTO kpx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Di Mamau dahoe isiviai au uvu bahata daoale ke nahate di data di uvu bahata laovenu. Iale di isivi kemo negolahai ugeve. ");
INSERT INTO kpx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lana di hoto ke ehovaliege di di Mamae hoto ehomai isivivemo uale ke nahate lata di isivi kemo negolahai uve. ");
INSERT INTO kpx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Di laheho hoto ko loui isivialeike lata di vahaeho ke nahate vave. Ige elike kemo la vahaehona balugai. ");
INSERT INTO kpx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Di hoto keu koseanu. Di laheho isiviai la tedaeveale ke nahate lata moleho isivilahai mole tedaevegeve. ");
INSERT INTO kpx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ata moleho isivi balugatahoale keu koseanu. Ata molena au haokaho isivianiege auna avuho hatai. ");
INSERT INTO kpx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Iale lana di laheho onole louale ke valiege di haokuvu holive. ");
INSERT INTO kpx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Di aike laheho loui kosea, ‘Di esemuia.’ Isito di bae gabie laheho kateale loulivebene. Kosealemo esemuiau abu kosive vaveve bahata hilokaholilu. Isito dana laheho loui kosea, ‘Di haokuvuia.’ Kosealemo di di Mamae vaveve bahata laheho louge la ke evilu. ");
INSERT INTO kpx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Laeau di ebagevaholilu. Isito di la tabagevei isivialeike la talive di lovi vage idiu hahumale ke nahate la lovi keu balugai ui tigei. Katealemo lana onoleho di ivimo di Mama imihage auna la isivi ke laovei. ");
INSERT INTO kpx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Di laheho louale keu koseanu. Di isivialeike moleho isivilahai mole tedaevegeve.” ");
INSERT INTO kpx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mesoho vatae ataeau laheho itumulahai la aiogevege di hoto ko huhulahave. Keau vasohuta daho itumulahai di aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","La vatae ata holivatege vatae ataeau laheho isivilahalu. Isito di vatae ata kebiamo la tabagevei la malevege laeau di ata holievelu. Katealemoike vatae ataeau laheho isiviholisi la aiogevema. ");
INSERT INTO kpx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Iale di subuta laheho louale ke huhulahave. Di la namigevei kosea, ‘Esemubeu bae au kosive evihalivebene.’ Vatae ataeabuna di aiohavoi vatehani daovaliege abuna lata aiogevei vatehani laovei. Isito abuna di hoto evisi ehovaliege abuna la hotota evisi ehovai. ");
INSERT INTO kpx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","La di esemu holiale kemo ataeabuna vaveve toela ke laemo vai. Ata keau di hanavoale ata ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Di lohoi kebia haiveholivatege abu di aiohavoale vaveve toela keu abuemo uoholinu. Isito di lohoi haiveale kemo vaveveabe toela keu abuemo ua. ");
INSERT INTO kpx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iale ata oleuoleu daho isiviholisi di aiohavoale keau di Mamatahoike abu ke isiviholilu. ");
INSERT INTO kpx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Di kebia nimo vikoe vaveve vaholivatege di aiohavoale vaveve toela keu abuemo uoholinu. Isito di vikoe vaveve moaga vaeveale kebia abu elegeveito daho isiviholisi di aiohavoi di Mamata aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Vaveveabe keu Bukae Hoto mole mai selevetinu. Hoto keu loui avoe, ‘Di vavevebe toela vaholisege abu daho isiviholisi di aiohavolu.’” ");
INSERT INTO kpx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Iesuu kateai louito tota namigevei avoe, “Dana Munanae Tumu laheho hanavoge auna di hoto seleve loui la haivei la hoesegevei. Keu aike di Mamati ua. Iale gabie dana hanavoge auna lohoniege di vaveve laheho loui. ");
INSERT INTO kpx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ige kemo latana di vaveve loui ata namigeveve. Kosealemo di vasohuta vata kove di lovi vage laeau daluvuta ui di vaveve elehai lohoma.” ");
INSERT INTO kpx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Di hoto ke laheho louale kemo isiviale la la evievimo dobuluvi halevai. ");
INSERT INTO kpx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kosealemo Diue ataeabuna gabie abu dubumo la nunuvei. Iale vani kemo ata oleuoleu lahaveliege abuna loui kosea, ‘Noeau Dilava lovilike ko vama.’ ");
INSERT INTO kpx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Abuna di Mamata data hilokaholiliege laemo vaveve kateale vai. ");
INSERT INTO kpx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Di hoto ke laheho loui isivialeike gabie vani keu laemo lohoge di laheho louale hoto ke huhulahave. Di subuta lahehi uale kemoike di laheho hoto ko louholinu. Isito di la halevei talihoike hoto ke laheho lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Dana aike hoilahai di hanavoale ata keve tai. Isito labeu hoto kemo di belahaholisi di namihai kosea, ‘A oleveike taliho.’ ");
INSERT INTO kpx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Di hoto ke laheho louale kemoike la uvu balugalu. ");
INSERT INTO kpx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Iale di hoto seleve ko louge evive. Di la halevei tige keu duave. Kosealemo di la halevei tioholige la hoesegeveveve Munanae Tumuu bae lae loholivebene. Isito dana la halevei tiniege laheho hanavoge auna lohoi. ");
INSERT INTO kpx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Auna lohoniege vatae ata haivege abuna abu vaveve toela hilokai Dilava vaveve dua keta hilokai. Isi Dilavau atae vaveve abuemo kaovaveve keta abuna hilokai. ");
INSERT INTO kpx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ataeau vaveve toela vai abu uvu mai daemo mavoholiale ke auna vaveveabe loui. ");
INSERT INTO kpx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Di hatai hovelahai di Mamae tige la bae di elehalivebene. Isito Munanae Tumu kena di vaveve ata haivege abuna hilokage di vaveveu inutolotoloanu. ");
INSERT INTO kpx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dilavau Vatae Kosive vaveve kaovaliho louale kemo Munanae Tumuu nahi haivege nahi hilokage seleveta Dilavau Setene vaveve kaovage vuvunevena bae uoholisi. ");
INSERT INTO kpx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Di isiviai hoto degomoleta loui la haivei. Isito dana hoto keta louge ke vavevena laemo isuai. ");
INSERT INTO kpx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Isito hoto seleve loumale Munanae Tumu kena lohoniege la haivege lana hoto seleve bahata hilokave. Keu bae au kinae hoto loui la haivelivebene. Isito auna au ehue eviale ke loui gabie vaveveu lohoveve keta loui la haivei. ");
INSERT INTO kpx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Munanae Tumu kena di hoto di vaveve ke bahata loui la haivege kemo di ivina balugai. ");
INSERT INTO kpx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Di Mamae onobenobe bahata keau di onoea. Iale kemo di la namigevei kosea, ‘Munanae Tumu kena di vaveve bahata loui la haivei.’” ");
INSERT INTO kpx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Iesuu kateai au esemuho louito tota namigevei avoe, “Dana aike la halevege la bae di elehalivebene. Iniege ke iae vanie ni degomoleau uoholige lana tota bae di elehave. ");
INSERT INTO kpx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kateai louge esemuiabe degomoleau moleho loui avoe, “Keu hoto vadeike au ke lounu. Au loui avoe, ‘Dana aike la halevege la bae di elehalivebene. Iniege ke iae vanie ni degomoleau uoholige lana tota bae di elehave.’ Isi tota loui avoe, ‘Dana hoilahai tota di Mamae tai.’ ");
INSERT INTO kpx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vanie ni degomoleau uoholige nahi tota elehaveve ke ihuike ono vade. Nahi hotove ke evisi kemo daudaulahalu.” ");
INSERT INTO kpx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kateai lousege Iesuu hilokage abu isivialeike belahai. Iale kemo Iesuu namigevei avoe, “Ose di laheho louale keike la ko loui mole belagevema. Di laheho loui kosea, ‘Di aike la halevege la bae tota di elehalivebene. Iniege ke iae vanie ni degomoleau uoholige lana tota bae di elehave.’ Hoto kenike la moleho louma, ani. ");
INSERT INTO kpx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","La katelahalelua di hoto seleve laheho louge evive. Lana bae uvulahai ninalahave. Isege vatae ataeabuna vahaeholahai. Keau katelahasege la uvu kena ekovehage lana lata vahaeholahave. ");
INSERT INTO kpx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Di louale keu koseanu. Keate mole eseu uho vage tumuu hamage auna vatehani malei kemo ue toela vai. Iniege ese kena uge vateve hani keu uoholige keate kena vahaehoai. Kosealemo eseveu ua. ");
INSERT INTO kpx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vaveve ke nahate lana vave. La nova uvulahalu. Isito gabie di hatai hovelahage lana tota di elehai vahaeholahave. Ige ataeau la aiogevege la vahaeho keu bae laemo gabialivebene. ");
INSERT INTO kpx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Iale di Mamae tiveve vani kela la bae onobeho di namihalivebene. Isito di louge evive. Lana di ivimo onoleho isiviai di Mama imihage auna la isivi ke laovei. ");
INSERT INTO kpx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","La subuta di ivimo onobeho di Mama imihaholilu. Isito nova komo lana lavisi di ivimo onoleho imihage auna la isivi ke laovei. Ige kemo la vahaehona balugai.” ");
INSERT INTO kpx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Di subuta laheho dovudovue hotomo la haivenu. Isito vani mole di bae dovudovue hoto loulivebene. Isito dana vani kemo inuta di Mamae hotoe ihu laheho loui. ");
INSERT INTO kpx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Iale vani keu lohoge la biaeabuna di ivimo di Mama imihave. Di louale keu koseanu. Di laheho di Mama imihaveve ke louholinu. Isito la biaeabuna di ivimo imihave. ");
INSERT INTO kpx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ige biagena laheho isiviai la isivi ke vai. Di Mamau laheho isiviale keu koseanu. La daho isivilahai la uvu mai daemo mavoi hilokage dau Dilavamo lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Di seleveta di Mamaemo lohoi vata kove lohonu. Isito dana tota vata halei hoilahai di Mamae tai.” ");
INSERT INTO kpx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iesuu hoto ke louge esemuiabeau avuho loui avoe, “A keu nova dovudovumo louholisito inutaike a ko noheho lounu. ");
INSERT INTO kpx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ige no nova a hoto kemo hilokage a keu onobenobe bahatamo luleleanu. Iale kemo atabeu bae onobe loui a haivulivebene. Kemoike no no uvu mai aemo mavoi hilokage au Dilavamo lohonu.” ");
INSERT INTO kpx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ige Iesuu hotoeabe ibina vai namigevei avoe, “Seleveta lana nova la uvu mai daemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Di louge evive. Di louale vani keu aike lohoma. Iale ataeabuna di maliho lohoge lana di halevai detuluvisi la o igaegae tisege dana dahuvela ui. Isito di bae dahuvela ulivebene. Di Mamana daiti ui. ");
INSERT INTO kpx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Di hoto ke loui isivialeike la la uvu mai daemo mavoime uveve dua vai. Vatae ataeabuna la aiogevege lana kemo vatehani maleve. Isito kemo vabu halevaito negolahave. Kosealemo di vatae vaveve toela vaholisi aehale ke nahate lata ke aehave.” ");
INSERT INTO kpx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesuu hoto ke loui gabiaito otogoe niai au Mama imihai avoe, “Mamai, di hativeve vaniu lohonu. Iale di ivi ebagemanela. Ige dana data a ivi ebagemai. ");
INSERT INTO kpx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A di ebagemai vuvune daoge ata bahata keau di adae valamo ua. Iale dana ukolikoli malei a ata malevei daoale kebia ovei. ");
INSERT INTO kpx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ukolikoli maleveve keu koseanu. Ataeabuna hilokage a igae Dilava seleve. Isi abuna hilokage a di hanavoge di lohonu. Abuna katelahai abu uvu mai daemo mavoliege ukolikoli malei. ");
INSERT INTO kpx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A lovi mai daoale ke bahata di vai gabianu. Ige kemo a iviu vatae ataemo baluganu. ");
INSERT INTO kpx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Subuta mole vatau uoholisege di aiti uge a di ivi ebagemanu. Iale Mamai, tota di ivi ebagemai vuvune kateale mai daonela. ");
INSERT INTO kpx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Di a vaveve loui a vatae ata malevei daoale kebia haivenu. A kebia malevege keau a ataea. Iale di kebia haivege keau a hoto evisi malu. ");
INSERT INTO kpx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Iale keau hilokage di onobenobe bahata maleale keau aemo loholu. ");
INSERT INTO kpx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A daho hoto louale ke di loui kebia namigevege keau ke evisi malu. Iale keau hilokage di seleveta aemo lohonu. Isi keau hilokage ailike di hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iale kebiaho di guliguli ko vama. Di vatae ata bahataho guliguliholima. Isito a malevei daoale kebiahoike di guliguli ko vama. Kosealemo keau a ataea. ");
INSERT INTO kpx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Di ata maleveale keau bahata a ataea. Ige a ata maleveale keau bahata di ataea. Iale nahi ata kebia maleveale keau di ivi ebagevalu. ");
INSERT INTO kpx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iale dana nova vata halei ae tai. Di bae kove ulivebene. Isito di esemuiabuna kove ui. Di Mama, au tumute. Ige a iviu vuvuneanu. Iale a ivie vuvune kemo di esemu kobia nibieve tumutumuanela. Ige elike keau naiti uvu igaeale ke nahate abuta uvu igaeai. ");
INSERT INTO kpx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Keau daluvuta usege di a ivie vuvunemo kebia nibieve tumutumuanu. Di kebia nalievege keau di halevaholilu. Isito kebia vigomo ata mole igae Diudasi keu di halei hatihatie humahamo tima. Ige vaveveve keu Bukae Hoto mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Iale dana nova vata halei ae tai. Isito di kove ui hoto ko loui isivialeike di vahaeho vaveve keu di esemue uvumo ui balugai. ");
INSERT INTO kpx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Di a hoto loui kebia haiveale kemo vatae ataeau aiogevelu. Kosealemo keau vatae ata holioholilu. Ige data vatae ata holioholinu. ");
INSERT INTO kpx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A kobia vatamo maleveliho di a imihaholinu. Isito di a imihai isivialeike koeau vatae usege a neniai kebia nalievege Seteneu kebia maleveholisi. ");
INSERT INTO kpx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Di vatae ata holioholiale ke nahate di esemu kebiata vatae ata holioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Iale a hoto seleve kemo kebia hoesegevege abu atae tumu holievei. ");
INSERT INTO kpx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A di hanavoge di vatae lohoale ke nahate dana kebia hanavege abuna vata bahatae tai a hoto loui ata haivei. ");
INSERT INTO kpx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Di debika mai aoi isivialeike kebiata seleveta abu ebika mai aoge ana kebia hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Di ata kobia unahaho guliguliholima. Isito ata degomoleau di esemu kobia hoto evisi abu uvu mai daemo mavoveve kebiatahoike di guliguliai a imihama. ");
INSERT INTO kpx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mamai, di a imihai isivialeike di esemu koeau isi gabie daemo uvu mavoveve keau bahata uvu igaeai. Di isivialeike a daiti usege di aiti uale ke nahate abu vai nahehi igaetolahai. Ige elike vatae ataeau hilokage a di hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A di ebagemale ke nahate di kebia tabagevenu. Ige elike naiti uvu igaeale ke nahate keau uvu igaeai. ");
INSERT INTO kpx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A daiti uge di kebiahi ua. Iale keabuna seleveta uvu igaelahai. Ige kemo vatae ataeabuna hilokage a di hanavonu. Isi abuna hilokage a daho isiviale ke nahate a kebiaho isivianu. ");
INSERT INTO kpx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mamai, a di esemu kobia malevei daonu. Iale di isivialeike keau di oleve uale keve abu daluvuta ui. Ilive elike a di ivi ebagemale ke abu elehai. A di ivi ebagemale keu koseanu. Subuta vatau uoholisege a daho isivi balugai di ivi ebagemanu. ");
INSERT INTO kpx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Di Mama, au inutolotolote kosive. Vatae ataeau a hilokaholilu. Isito di a hilokanu. Ige esemu koeau hilokage ailike di hanavonu. ");
INSERT INTO kpx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Di a vaveve loui kebia haivenu. Iale dana vani bahata kateigei. Ige elike a daho isiviale ke nahate abuna moleho isivilahai. Abuna katelahage dana abuhi ugei.” ");
INSERT INTO kpx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesuu kateai guliguliai au Mama imihage uoholige ke iae au esemu leveni (11) holoevei abuhi e mole ivi Kidoloni ke houi bulu moleve tiale ua. ");
INSERT INTO kpx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Isege Iesuho haiale Diudasi keu matama ke hilokanu. Kosealemo vani moaga Iesuna matama keve au esemu bevuevei abuhi keve ugei. ");
INSERT INTO kpx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iale keau keve usege Diudasiu tuvali ata holoevei abuhi keve loholu. Ige dubue kosiveau Balisia atahi dubue udaha nalimale bukate hanavege kebiata keve lamebata hatita malei loholu. Isi Iesu hamaveve kudavata malei loholu. ");
INSERT INTO kpx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lohoale matama keve velehovoge Iesuu kebia elegevei vaveve bahata avuemo lohoveve ke hilokanu. Iale keu vabuholisito kebia beiavei tiale abuho loui avoe, “Ata vadeike la kaovama.” ");
INSERT INTO kpx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ige abu namihai avoe, “Nasaleta ata Iesu keike no kaovama.” Ige Iesuu loui avoe, “Ke dailike ko.” Kateai lousege avuho haiale Diudasi keu keve abuhi lamisi ua. ");
INSERT INTO kpx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesuu kateai abuho loui avoe, “Ke dailike, ko.” Ige abu ke evisi vikolahai vatamo dobuluvilu. ");
INSERT INTO kpx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Vatamo dobuluvige Iesuu tota belagevei avoe, “Ata oleike la kaovama.” Ige abu avuho loui avoe, “Nasaleta ata Iesu keike no kaovama.” ");
INSERT INTO kpx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ige Iesu namigevei avoe, “Di subuta laheho loui kosea, ‘Ke dailike ko.’ Iale la da igae kaovaliege di esemu kobia iovege abu tai.” ");
INSERT INTO kpx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kateai loui isivialeike au subuta louale hoto ke mai selevetisi. Au subuta au Mama imihai avoe, “Mamai, a kobia daoveale ke di bebe haleveholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kateai louge Saimoni Bitau au siga mai dubu nalimale kosive baluga ke esemue golema inute heisi etulenu. Esemu ke ivilike Malakasi. ");
INSERT INTO kpx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ige Iesuu Bita namihai avoe, “A siga mai lovovemo mamo. A huhuige di Mamau daho e mole hale ke di bae ilivebene. Ba, dana ke isi kemo vatehani malei.” ");
INSERT INTO kpx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ige tuvali ataeau abu kosivehi isi Diue dubue bukate keau Iesu evudei mai umuvalu. ");
INSERT INTO kpx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Isi vasohuta mai Anasi oe tilu. Dubu nalimale kosive baluga Kaiabasi ke valuike Anasi. Vagana kemo Kaiabasi keu Diue atae kosive baluga holinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iale Kaiabasi keike subuta Diue kosive namigevei avoe, “Nahi ata ke igae hamage au hatige duave. Ige kemo nahi bahata haluvi halevai.” ");
INSERT INTO kpx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Abu Iesu mai Anasi oe tisege Saimoni Bitau Iesu esemu moleti ehovei tilu. Esemu mole ke dubue kosive baluga keu ke hilokanu. Iale esemu keu Iesu ehomai dubue kosive baluga ke oe uvue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Isege Bitau heie lamisi ua. Ige esemu keu tota hoilahai tiale dubue kosive baluga ke udaha nalimale ma ke namihage keu udaha alavoge Bitau oe uvue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oe uvue tisege udaha nalimale ma keu avuho loui avoe, “Ose au Iesu esemu mole ailike ko.” Ige Bitau namihai avoe, “Ba, dau ke esemu holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kateai lousege dabau lohoge dubue kosive baluga ke esemuiau dubue bukate kebiahi vene beisi hevemo lavisi ua. Isege Bitau tiale abuhi vene ke hemo ua. ");
INSERT INTO kpx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Keve usege dubue kosive baluga keu oe uvue Iesu belahama. Keu isivialeike Iesu esemu kebia hilokaevei. Isi isivialeike Iesuu hoto onole loui ata haivemale hoto keta hilokai. ");
INSERT INTO kpx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ige Iesuu namihai avoe, “Di vani bahata ata bahatae vudimo lamisi di hoto loui haivema. Diue dubu baluga kemo isi dubue ese igaegae kela nahie ataeau mole bevuevei igaetoai uale kebia di hogohogomo loui kebia haiveholinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Iale osialemoike a hoto kateale loui di belahama. Ainaho di belahalive. Isito di ata haivesege abu di hoto eviale ata kebia belagevenela. Keau di louale hoto ke hilokalu. Iale ana kebia belagevege keabuna di hoto onole louale ke abuna aho loui.” ");
INSERT INTO kpx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesuu hoto kateale louge dubue bukate moleu vavavemo lamiale keu Iesu golema beisi avuho loui avoe, “Osialemoike a hoto kateale dubue kosive balugaho lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ige Iesuu namihai avoe, “Di hotoe toela onole louge ke daho lounela. Isito di hoto louale keu inutolotoloige osialemoike a daho loui dahamonu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kateai louge Anasiu louge abu Iesu umuvale keta melavei dubue kosive baluga Kaiabasi oe tilu. ");
INSERT INTO kpx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Keau keve tisege Bitau sohu venehemo uma. Ige ata degomoleau avuho loui avoe, “Ani, a keu Iesu esemu mole.” Ige Bitau hotoeabe hamai loui avoe, “Dau ke esemu holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ige dubue kosive baluga ke esemu moleu Bita namihanu. Esemu ke ata mole golemaike Bitau heisi etulenu. Iale esemu keu Bita belahai avuho loui avoe, “Ose a koike Iesuluvuta bulue usege di a elehanu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ige Bitau tota loui avoe, “Ba, dau ke holioholinu.” Kateai lousege solekavesite kokoluguu hotoanu. ");
INSERT INTO kpx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iniale vavita vau alamosege abu tota Iesu melavei Kaiabasi o ke halevai gamani baluga oe tilu. Tialeau velehovoito gamani baluga ke oe uvue tioholilu. Kosealemo vaveve katealemo Diue menakau ua. Menaka keu koseanu. Diue ata keau Diue ata holioholiale ke oe uvue bae talivebene. Abuna o ke uvue tiliege bae Basova lovi ke ilivebene. Katealemoike abu tiale gamani oe uvue tioholisito heie lavisi ua. ");
INSERT INTO kpx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iale kemo gamani baluga Bailoti keu heie lohoale ata kebia belagevei avoe, “Ata kou vaveve vade vaike vage la mai loholu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ige abu namihai avoe, “Malaha kou vaveve toela vaholivatege no ko mai lohoholilu. Isito kou vaveve toela baluga vaike vage no mai loholu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ige Bailotiu namigevei avoe, “La biaeau ke mai talive la menakamo vaveveve avuemo kaovave.” Ige Diue ata keau Bailoti namihai avoe, “No isiviale hamai. Isito a gamaniau menaka mavoale kemo no bae atabe hamalivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Abu hoto kateale louale keu Iesu hoto mole mai selevetinu. Iesuu subuta loui avoe, “Ataeabuna di mai idie domo hamage dana hatai.” Iale abu hoto kateale louale keu Iesu hoto mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ige Bailotiu au o uvue tiale Iesu hohavoge au avue lohonu. Ige Bailotiu belahai avoe, “A Diue kosive anike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ige Iesuu namihai avoe, “A kinamo nike a hoto ke lounu. Mena ata moleu di vaveve aho louike vage a hoto ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ige Bailotiu belahai avoe, “A huhuige dau Diue ata. Dau Diue ata holioholinu. Isito a ata isi a dubue kosive keau a mai dae loholu. Iale a vadeu vale ke daho lounela.” ");
INSERT INTO kpx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ige Iesuu namihai avoe, “Dau vata ko kosive holioholinu. Isito di vata ko kosive holivatege di ata keau di tedahoge Diue ata keau di mai kove lohoholilu. Isito dau vata ko kosive holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ige Bailotiu tota belahai avoe, “A hoto louale kemo seleveta au kosive baluga, e.” Kateai louge Iesuu namihai avoe, “A louale keu seleve. Dau kosive baluga. Isito di vatae lohoi uale ke ihuu koseanu. Di isivialeike hoto seleve loui ata haivei. Ige oleuoleu abuemo hoto seleve umale keabuna di hoto ke evisi mai.” ");
INSERT INTO kpx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ige Bailotiu Iesu belahai avoe, “Hoto seleve keu hoto vade.” Kateai Iesu belahaito halei tota heie tiale Diue ataho loui avoe, “Di vaveveve avuemo kaovage vavevebe toelau avuemo uoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Isito la vaveve keu koseanu. Vagana bahata Basova vani keu lohoge lana louge dana dibulae ata mole iomage auna tigei. Iale lana isiviage di ke nahate vai Diue kosive ke iomage au tai.” ");
INSERT INTO kpx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ige Diue ata keau itumulahai baita avuho loui avoe, “Ke ioma hale. Isito malaha mole Balabasi ke iomanela.” Kateai loui Bailoti namihalu. Isito Balabasi keu vavoloe ata. ");
INSERT INTO kpx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bailotiu au tuvali ata namigevege abu Iesu mai visuhavoi aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Isi kinaveho hote mole beikabeikate mai viliai kinave hanubelu. Isi ogo tahote vatae kosiveau hatumale ke nahate mai avuemo hatulu. ");
INSERT INTO kpx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Isi lohoaleau vudivemo lavisi hehavoi avuho loui avoe, “Diue kosive baluga, ana duave.” Katelahai hehavoi golema beisi aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Katelahasege Bailotiu tota dobai tiale Diue ata namigevei avoe, “Elehave. Dana mai lohoge lana ke elehai hilokage di vaveveve avuemo kaovaito vavevebe toela avuemo elehaholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kateai namigeveito louge Iesuu heie lohonu. Abu hote beikate mai viliai kinave hanubei ogo nehe tahote mai avuemo hatuale keta heie lohonu. Ige Bailotiu Diue ata namigevei avoe, “Elehave. Malaha nehe keike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ige dubu nalimale kosiveau abu bukatehi Iesu elehai baita loui avoe, “Mai idie domo hamave. Mai idie domo hamave.” Ige Bailotiu abuho loui avoe, “La biaeau mai idie domo hamave. Di vaveveve kaovage vavevebe toelau avuemo uoholiale kemo di ke hamaveveu daemo anekianu.” ");
INSERT INTO kpx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ige Diue kosiveau avuho loui avoe, “Ata keu subuta loui avoe, ‘Dau Dilava mo.’ Iale kemo no menakau loui avoe, ‘Ata kateale hamage au hatai.’ Iale keu hoto kateale louale kemo no isivialeike a ke hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Abu hoto kateale louge Bailotiu ke evisi vabu baluganu. ");
INSERT INTO kpx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Isi Iesu melamei au oe uvue tiale Iesu belahai avoe, “A oleve lohonu.” Kateai louge Iesuu hotove ibina louholinu. ");
INSERT INTO kpx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kateige Bailotiu avuho loui avoe, “A daho hoto louliho isiviholinu, ani. A hilokage dau gamani baluga. Iale dana isivianiege a iomage tenela. O dana isivianiege a mai idie domo hamai.” ");
INSERT INTO kpx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ige Iesuu avuho loui avoe, “A vuvune maleale ke Dilavaike aonu. Iale ata moleu di mai aoale ata keu a vaveve ko evihai vaveve toela baluga vanu.” ");
INSERT INTO kpx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kateige Bailotiu Iesu hoto ke evisi humaha kaovai isivialeike iomage au tai. Kateaito halei tiale hoto ke loui Diue ata namigevege abu avuho loui avoe, “Ana ke iomage keu tige a keu Loma kosive baluga Sisa ke haoka holioholinu. Kosealemo ata keu loui avoe, ‘Dau kosive baluga.’ Iale ata oleu isiviai kosive baluga holiale keu Loma kosive baluga ke aiohavonu.” ");
INSERT INTO kpx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kateai louge Bailotiu hotoeabe evisi Iesu melamei heie tiale kotae matama keve ugulamonu. Matama keu abu mune detiale matama. Iale Diue hotomo abu matama ke ivihai avoe, “Gabata.” ");
INSERT INTO kpx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iale bulae esemo abu Basova lovi ke iho vage vani ke lilimo Bailotiu Iesu melamei kotae matamae lohonu. Isi Diue ata namigevei avoe, “La kosive baluga keike ko.” ");
INSERT INTO kpx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ige abu hovedevei baita loui avoe, “Hamage au hatai. Mai idie domo hamave.” Ige Bailotiu belagevei avoe, “Kou la kosive baluga. Iale lana isiviage dana mai idie domo hamai.” Ige dubu nalimale kosiveau namihai avoe, “Ata keu no kosive holioholinu. Isito Loma kosive baluga ke igaeike no kosive baluga.” ");
INSERT INTO kpx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kateai louge Bailotiu hotoeabe evisi Iesu mai hamaliho tuvali ata ovenu. Ige abu Iesu mai tilu. ");
INSERT INTO kpx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mai tiale keau idie do mai omige au ke ebamoge abu tiale keau matama mole ivi Gologota keve velehovolu. Diue hotomo hoto ke ihuu koseanu. Lolokue matama. ");
INSERT INTO kpx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Abu keve velehovoi Iesu mai idie domo hamalu. Isi malaha abuitata malevei avuluvuta igaetolahai havelu. Moleu adave agiteatae. Isege moleu adave inuteatae. ");
INSERT INTO kpx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ige Bailotiu idie vakimo hoto mole hisaliage abu ke mai kinave tatamo hamale keu koseanu. Avoe, “Nasaleta ata Iesu keike ko. Kou Diue atae kosive baluga.” ");
INSERT INTO kpx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iale Diue ata moagaeau hisali ke elehai dodavema. Kosealemo abu Iesu mai hamale matama keu haeava holioholinu. Isito keu Dielusalema vavamo ua. Ige Bailotiu Diue hotomo Loma hotomo isi Giliki hotomo hoto ke igae hisalianu. ");
INSERT INTO kpx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ige Diue dubu nalimale kosiveau Bailoti namihai avoe, “Ainaho hisaliai loui kosea, ‘Kou Diue atae kosive baluga.’ Keu no kosive baluga holioholinu. Isito hisaliai kosea, ‘Kou au ebika ebagemai loui avoe, Dau Diue atae kosive baluga.’” ");
INSERT INTO kpx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ige Bailotiu namigevei avoe, “Di hisaliai gabianu. Iale di bae tota ke ekovehalivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ige ke iae tuvalie ata abuita abuitaeau Iesu mai hamale keau ogove mai dikohai mole ovelu. Isi tota Iesu dabae ogo mai elehage keu ogo egete igae. ");
INSERT INTO kpx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Iale kemo abu moleho loui avoe, “Nahi ko dikoha halevai. Isito nahi ogo ko mai kasilahage oleu kasi kemo negoaniege bae ogo ko mai.” Abu vaveve kateale vale keu Bukae Hoto mai selevetinu. Hoto keu loui avoe, “Keau di ogo dikohai mole ovelu. Isi di dabae ogo keho kasilahalu.” Iale tuvalie ataeau Bukae Hotou louale ke nahate valu. ");
INSERT INTO kpx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Keau katelahasege Iesu neinau abu tatati Iesu valamo lavisi ua. Ige Kolobasi mahina Meli isi keate mole Meli Magidaleni keau abuhi lavisi ua. ");
INSERT INTO kpx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ige Iesuu elehage neinaveu uvuve esemu moleti keve lavisi ua. Ige Iesuu au neinaho loui avoe, “Amia, esemu keu a moike.” ");
INSERT INTO kpx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kateai au neinaho louito esemu ke namihai avoe, “Keu a neinaike.” Hoto ke louge esemu keu vani kemo keate ke melamege au neinave holisi avuti ua. ");
INSERT INTO kpx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesuu hilokage loviveu bahata gabianu. Iale kemo keu isiviale Bukae Hoto mole mai selevetisi. Isi loui avoe, “Di enuanu.” ");
INSERT INTO kpx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kateai louge abu uaini mai baidisimo ehosivale kemo ono mole ogomu ke nahate mai uaini e kemo maneveito ke kavitisi mai aivemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ige Iesuu uaini ke teveito loui avoe, “Elemua.” Kateai louito hatige tuveu dakolahanu. ");
INSERT INTO kpx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iniale gutuige Diue ataeau tiliale Bailoti namihai isivialeike au louge tuvalie ataeau talive idie domo haveale kebia velo havei bokoevege abu haluvisi. Keau isiviholialeike ata keau bulamo idie domo uliho. Kosealemo vani keu vanie tumu seleve. ");
INSERT INTO kpx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ige Bailotiu tuvalie ata namigevege abu tiale keau vasohuta mole velo hamai bokoige keu hatinu. Ige abu halevai mole velo hamai bokoige keta hatinu. ");
INSERT INTO kpx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ige abu halevai lohoale isiviai Iesu velota hamai bokoai. Isito abu elehage keu subuta hatinu. Iale kemo abu velove hamai bokoholilu. ");
INSERT INTO kpx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Isito tuvalie esemu mole igae keu bi mai Iesu etekamo binu. Ige solekavesite kemo tahou eti laluvai loholu. ");
INSERT INTO kpx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kateisege di ke elehanu. Iale kemo di ko hisaliai isivialeike lata ko evisi la uvu mai avuemo mavove. Di louale kou loboe hoto holioholinu. Isito di hilokage di louale hoto kou hoto seleve. ");
INSERT INTO kpx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tuvalie atau vaveve ke vale keu Bukae Hoto mole mai selevetinu. Bukae Hoto keu loui avoe, “Itavavebeu bae bokolahalivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ige Bukae hotou tota loui avoe, “Ataeabuna abu biale ke elehai.” ");
INSERT INTO kpx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Vaveve ke iae Alimatia malaha mole Dioseba keu isiviai Iesu vava mai abavui. Iale keu tiale keho Bailoti belahanu. Dioseba keu Iesu ehomamale ata mole. Isito keu Diue kosive vabugeveale kemo au evievi ke mahogovanu. Iale keu Bailoti belahage Bailotiu avuho loui avoe, “Talive vavave mai abavu.” Ige Diosebau tiale vavave manu. ");
INSERT INTO kpx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Isege malaha moleu subuta vavimo Iesue tiale Nikodimasi keu Diosebati tinu. Tiale mulamula hagote balugataho malei lohonu. ");
INSERT INTO kpx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iale malaha abui keau mulamula ke bahata malei Iesu vavamo keiohai ogota viliai tilu. Diue ataeabuna ata abavueveliho vaveve kateale vagei. ");
INSERT INTO kpx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Abu Iesu mai hamale ke vavae bulu moleu uale keve abata moleu ua. Abu subuta lovoi kemo atabe mai abavuholilu. ");
INSERT INTO kpx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iale abata kemo abu Iesu vava mai mavolu. Bulau lohoveveu vuguvuguike vage abu Iesu vava mai vuguta hamale ke vavamo abavulu. ");
INSERT INTO kpx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande vavita vae alamo Meli Magidaleniu Iesu vutae tinu. Tiale elehage abu mune baluga mai gulive ili bamuale keu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ige keu ke elehai hoilahai bibuai tiale Saimoni Bita namihai Iesu uvue esemu mole keta namihanu. Namigevei avoe, “Ataeau nahie Kosive ke vava vavololahai mai tilu. Mai tiale oleve mavoale ke no hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ige Bitau esemu mole keti hoto ke evisi halevai Iesu vuta elehaliho tilu. ");
INSERT INTO kpx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bibuluvisi tilage esemu mole keu Bita halei uli holisi tiale vasohuta Iesu vutae velemanu. ");
INSERT INTO kpx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Keve velemaito abata ke uvue tioholinu. Isito abu Iesu mai mavoale ke ilimo holumai elehage abu ogota viliale ogo ke unahaeau ua. ");
INSERT INTO kpx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ige ke iae Saimoni Bitau tiale velemai inuta abata ke uvue tinu. Tiale elehage abu ogota viliale keau ua. ");
INSERT INTO kpx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Isege abu kinave viliale ogo keu ogo kebiahi igaetoai uoholinu. Isito ogo keu lilikateve bokoai ua. Iale keta Bitau elehanu. ");
INSERT INTO kpx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ige esemu moleu uli holisi tiale abatae velemale keta bae ke uvue tinu. Tiale ogo elegevei hilokage Iesuu hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bukae Hotou louale Iesuna hatihatimo hovelahai. Iale keau subuta kemo luleleholisito ke elehalemo Bukae Hotou louale kemo lulelelahalu. ");
INSERT INTO kpx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Keau ke elehaito hoidevei abu oe tilu. ");
INSERT INTO kpx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Isege iaeabe Meliu lohoale guli keve lamisi ui ninama. Keve ninanata holumai abu Iesu mai mavoale lovo ke elehanu. ");
INSERT INTO kpx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Elehasege anelu abuiau ogo taete holoevealeta Iesu lovo kemo uguiavoi ua. Moleu kinaveu uale keve ugulamonu. Isege moleu veloveu uale keve ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iale keau Meli belahai avoe, “Osiohoike a ninama.” Ige keu namigevei avoe, “Ataeau di Kosive vava vavoloai mai tilu. Keau mai tiale oleve keve mavoale ke di hilokaholinu.” ");
INSERT INTO kpx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kateai louito hoilahai au iae niai elehage Iesuu lamisi ua. Isito keate keu Iesu hilokaholinu. Keu huhuai avoe, “Mesoho ata moleiko.” ");
INSERT INTO kpx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ige Iesuu belahai avoe, “A osiohoike ninama. Ata vadeike a kaovama.” Ige Meliu huhuai avoe, “Mesoho malaha kou bulu ko biage.” Isi kateai avuho loui avoe, “A Iesu vava mai oleve keve mamoniege daho louge di talive mai.” ");
INSERT INTO kpx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ige Iesuu ivive iviloi loui avoe, “Meli.” Kateai louge Meliu hoilahai valitisi Diue hotomo avuho loui avoe, “Laboni.” Hoto ke ihuu koseanu. Kosive. ");
INSERT INTO kpx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ige Iesuu avuho loui avoe, “Ainaho di levelive. Kosealemo di sohu di Mamae veatisi tioholinu. Iale talive di haokuvu namigevei kosea, ‘Di di Mamae veatisi tima. Keu di Mama isi la Mama. Keu di Dilava isi la Dilava.’” ");
INSERT INTO kpx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kateai Meli Magidaleniho louge au tiale Iesu esemu namigevei avoe, “Di nova Iesu elehanu.” Kateai abuho loui Iesuu avuho louale hoto keta loui namigevenu. ");
INSERT INTO kpx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Vani ke igae gutumo esemuiabeau bahata mole bevuevei oe uvue uito abu inohoho udaha bamulu. Kosealemo keau Diue kosive kebia vabugevelu. Iale keau oe uvue usege Iesuu lohoale vigoeabemo lamisi namigevei avoe, “Lana duave.” ");
INSERT INTO kpx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kateai louito au adae samaguta au etekae samaguta mai haivenu. Ige esemuiabe keau abu Kosive ke elehai vahaeho balugalu. ");
INSERT INTO kpx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ige Iesuu tota abuho loui avoe, “Lana ue dua vama. Di Mamau di hanavoale ke nahate dana aike la hanavei.” ");
INSERT INTO kpx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kateai louito au lu ovei abuho loui avoe, “Lana Munanae Tumu maleve. ");
INSERT INTO kpx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lana ata namigevei kosea, ‘Dilavana la vaveve toela ulihai.’ Ige auna vaveveabe toela ulihai. Isi lana ata namigevei kosea, ‘Dilavau bae la vaveve toela ulihalivebene.’ Ige au bae vaveveabe toela ulihalivebene.” Iesuu kateai louito halevei tinu. ");
INSERT INTO kpx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Esemu tuelo (12) kebia vigomo esemu mole ivilike Tomasi (ivive moleike Didimasi). Iale Iesuu esemu kebiae lohoale vani kemo Tomasiu abuhi uoholinu. ");
INSERT INTO kpx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ige esemu degomoleau namihai avoe, “Noeau Kosive elehalu.” Ige Tomasiu abuho loui avoe, “Dana di ada mai adave samagu levei etekave samaguta leveniege kemo bae la hoto mai hilokage au hovelahanu. Isito di kateholiniege di bae la hoto malivebene.” ");
INSERT INTO kpx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Iniale bula igaeu uoholisege esemu nehe keau mole bevuevei oe uvue uito abu inohoho udaha bamulu. Kateimale kela Tomasiu bae abuhi ua. Keau keve usege Iesuu tota lohoale vigoeabemo lamisi abuho loui avoe, “Lana duave.” ");
INSERT INTO kpx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kateai abuho louito Tomasi namihai avoe, “A ada mai di adae voto ko levei elehanela. Isi di etekata levei elehanela. A kebia elegeveniege ainaho dolodoloalive. Isito a uvu mai daemo mamonela.” ");
INSERT INTO kpx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ige Tomasiu avuho loui avoe, “Di Kosive, au di Dilava.” ");
INSERT INTO kpx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ige Iesuu avuho loui avoe, “A di elehale kemoike a a uvu mai daemo mamonu. Isito ata degomoleau di elehaholisito abu uvu mai daemo mavoale keabuna vahaeholahai.” ");
INSERT INTO kpx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesuu au esemue vudimo vuvune vaveve moaga vaeveale kebia bahata di buka komo hisalieveholinu. ");
INSERT INTO kpx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Isito di kobia hisalievei isivialeike la ko dodavei la uvu mai Iesuemo mavoi hilokage keu ata tedaevemale kosive Keliso. Isi hilokage keu Dilava mo. Iale la evievi kemo negolahalive elike ivivemo ukolikoli maleve. ");
INSERT INTO kpx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Vani mole Iesuu Taibiliasi tabu keve au esemue ti moleanu. Au keve tiale deiadave keu koseanu. ");
INSERT INTO kpx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iesu esemu degomoleau keve mole bevuevei igaetoai uale kebia iviabeike koea. Saimoni Bita. Ige ese nehe Tomasi (ivive mole Didimasi). Ige Galili vatamo umale Keina ata mole ivi Nataniela. Ige Sebedi mo abuita. Ige Iesu esemu mole abuita. Keau keve mole bevuevei ua. ");
INSERT INTO kpx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Isege Saimoni Bitau namigevei avoe, “Dana tiniege e mahoi.” Ige esemu degomoleau avuho loui avoe, “Noeabuna aluvuta tai.” Katelahai avuluvuta vanagi mai tiliale vavi igae kemo e maholata huenabe maleholilu. ");
INSERT INTO kpx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ilage vau alamoge Iesuu lohoale tabu ke esagae lamisi ua. Ige esemuiabe keau ke elehaito valitiholilu. ");
INSERT INTO kpx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ige Iesuu hohavei avoe, “Esemuia, lana huenabe malelu.” Ige abu loui avoe, “No bebe maleholilu.” ");
INSERT INTO kpx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kateai louge Iesuu namigevei avoe, “La ugabi mai ada inuteveatae mihatuliege lana huena moaga maleve.” Ige abu hotove evisi ugabi mai au louale keveatae mihatuge huena moagamoagaeau ugabi kemo uge abu butuhai mai vanagimo mavoveveu abuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ige Iesu uvue esemu keu ke elehai Bita namihai avoe, “Ata keu nahie Kosive.” Ige Saimoni Bitau di hoto ke evisi au ogo elokohale ke mai holovai emo biloai Iesue tinu. ");
INSERT INTO kpx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Isege noeau vanagita ugabi butuhai loholu. No esagamo haeava holioholilu. ");
INSERT INTO kpx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Katealemo no lohoaleau esagae dobuluvisi elehage Iesuu vene beisi kemo huena mahoevei valavata malei otovenu. ");
INSERT INTO kpx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Isi noheho loui avoe, “La huena maleale kebia degomole malei lohove.” ");
INSERT INTO kpx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ige Saimoni Bitau tiale ugabi ke butuhai esagae lohonu. Ige ugabi kemo huena moagamoagaeau ua. Huena keau bahata uani handele vivti tili (153). Ugabi keu ililohoito levelahaholinu. ");
INSERT INTO kpx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ige Iesuu noheho loui avoe, “Lohoi lovi ive.” Ige no vabulahale kemo koseai Iesu belahaholilu, “A ole a.” Kosealemo no hilokage keu no Kosive. ");
INSERT INTO kpx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Katelahage Iesuu tiale valavata huenata malei lohoale noevenu. ");
INSERT INTO kpx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iesuu hatai hovelahale ke iae au ebika mai au esemu haiveale abuita. Isi tota nova kota louge abuita igaeta. ");
INSERT INTO kpx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","No lovi ke isi gabilahasege Iesuu Saimoni Bita namihai avoe, “Dioni mo Saimoni, a daho isiviale a isivi kena esemu koeau daho isiviale ke evihanu. Emena.” Ige Bitau namihai avoe, “Ito, Kosive, a hilokage di aho isivianu.” Ige Iesu avuho loui avoe, “A katealemo di mamoe ese nalievenela.” ");
INSERT INTO kpx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kateai avuho louito tota belahai avoe, “Dioni mo Saimoni, ana seleveta daho isivi baluganu.” Ige Bitau namihai avoe, “Ito, Kosive, a hilokage di aho isivianu.” Ige Iesuu avuho loui avoe, “Di mamoe kebia nalievenela.” ");
INSERT INTO kpx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kateai louito tota belaha moleai avoe, “Dioni mo Saimoni, ana daho isivianu.” Kateai Bita belaha abuita igaetage Bitau hotove kemo isuanu. Iale kemo au Iesu namihai avoe, “Kosive, a vaveve bahata hilokanu. Iale di aho isiviale ke a hilokanu.” Ige Iesuu avuho loui avoe, “Di mamoe kebia nalievenela.” ");
INSERT INTO kpx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kateai avuho louito namihai avoe, “Seleveta di hoto mole louge evinela. A mohohota ui a ogo vai a isivi matama keve ohanoi tinu. Isito gabie ana a ebika holiniege bae kateai a isivi valivebene. Isito ana a ada hatuge ata molena a ada umudievei a melamei a isiviholiale matama keve tai.” ");
INSERT INTO kpx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesuu kateai louale keu Bitau hatai Dilava ivi ebagemaveve hotoike au ke lounu. Au kateai avuho louito namihai avoe, “Di ehomai lohonela.” ");
INSERT INTO kpx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kateige Bitau hoilahai Iesu uvue esemu ke elehanu. Esemu keike subuta Iesu vavamo ugulamoi namihai avoe, “Kosive, ata olena aho haiai.” ");
INSERT INTO kpx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Iale Bitau hoilahai esemu ke elehai Iesu namihai avoe, “Kosive, a di hatihati hoto ke lounu. Isito ata kona oleve kateai avuta hatai.” ");
INSERT INTO kpx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ige Iesuu Bitaho loui avoe, “Dana isiviage kena ulage dana tota lohoi. Iale di ehomai lohonela. Ainaho bae ata mole vaveve ke kaovagelive.” ");
INSERT INTO kpx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iesuu hoto louale kemo hoto mole igaeu evievi ata bahata sonumaevei gabianu. Hoto keu loui avoe, “Esemu keu bae hatilivebene.” Isito Iesuu hoto kateale louholinu. Keu loui avoe, “Dana isiviage kena ulage dana tota lohoi. Iale ainaho ata mole vaveve kaovagelive.” ");
INSERT INTO kpx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iesu uvue esemu seleve keike vaveve ko bahata elehai hisalianu. Iale esemu ke daliko. Iale la hilokage di hoto louale keu hoto seleve. ");
INSERT INTO kpx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isito di buka komo Iesu hoto bahata hisaliholinu. Iesu keu vaveve moagataho vaevenu. Iale dana ke bahata hisaliage di huhuige auna buka moagamoaga holisi. ");
INSERT INTO kpx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Di haoka, Teovilasi. Di isiviai tota deiada mole a haivui. Di subuta Iesuu vatae lohoale ata haivei vale ke hisaliai ahoe hanavonu. ");
INSERT INTO kpx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Iesuu otogoe tioholisito Munanae Tumue vuvunemo au esemu tuelo (12) malevei abu vaveve deiada loui namigevenu. ");
INSERT INTO kpx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Au hatihatimo hovelahaito vanie ni voti (40) ke uvumo au ebika mai au esemu haivege abu kemo hilokage au hatihatimo hovelahanu. Isi vani moaga abue lohoale Dilava matamae dogae uveve deiada loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iniale vani mole abu igaetoai usege au namigevei avoe, “Lainaho Dielusalema halevai tigelive. Isito usege di subuta la namigeveale ke di Mamau bae laovei. ");
INSERT INTO kpx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dioni ata babatisogevemale keu e unahataike ata babatisogevenu. Isito vani degomoleau uoholisege Munana Tumue vuvunena bae laemo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Vani mole Iesuu au esemuhi igaetoasege abu belahai avoe, “Kosive, Iselala ata noeau subuta no vata sisihalu. Isito novae vani komo ata nimoleau lohoale no vata ko sisihama. Iale ana valive no kosive holisi no tedaevege no tota no vata ko mai sisihai.” ");
INSERT INTO kpx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ige Iesuu namigevei avoe, “Di Mamau au vuvunemo vaveve bahata hilokaevenu. Isi isiviholiale la namigevege la ke hilokaliho. ");
INSERT INTO kpx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Isito di hoto mole louge evive. Gabie Dilava Munanae Tumuna bae la vuvunetievege lana bae di hotoe dua loui Dielusalema o kove, Diudia vatae, Samalia vatae isi vata bahatae kebia haiveve.” ");
INSERT INTO kpx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kateai louge uoholige esemuiabeau nibisege au otogoe veatisi tinu. Tigeto goeu bamuge abu elehaholilu. ");
INSERT INTO kpx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Abu otogomo Iesu nibisege malaha abuitaeau ogo taete holovealeta solekavesite vavaebemo lavisi ua. ");
INSERT INTO kpx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Isi namigevei avoe, “Galili ataea, la osiohoike ehue nilahama. Iesuu ehue tige la elehale ke nahate auna bae tota dobai lohoi.” ");
INSERT INTO kpx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kateige abu Oliveta tana ke halevai hevaluvisi Dielusalemae lohoale keu haeava holioholinu. ");
INSERT INTO kpx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kateai lohoale abu subuta o molemo uale kemo ua. Esemu keabulike koea: Bita, Dioni, Diemisi, Andulu, Bilibi, Tomasi, Batolomi, Matiu, Aloveasi mo Diemisi, Selotie ata Saimoni, isi Diemisi mole mo Diudasi. ");
INSERT INTO kpx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Keau bahata negolahaime Dilava imihama. Isege Iesu neina Meli, keate benahate isi Iesu hohuvu kebiau bahata keve Dilava imihama. ");
INSERT INTO kpx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kateimale vanila Bitau hovelahai evievi ata bahata uani handele tuenti (120) haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Haivei avoe, “Di haokuvuia, bahata evive. Subuta mole Dilava Munanae Tumuu Deividi namihage au Diudasiu Iesu maveve deiada ke lounu. Iale hoto keu nova seleve holinu. ");
INSERT INTO kpx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nahi hilokage keu nahehi Iesu lovi vamale ata mole. ");
INSERT INTO kpx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Isito au Iesu male ke ibina malei vata mole voianu. Vata kemoike au dobai hatige gogoveu dikolahage deve holoeau velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ige Dielusalema ataeau evige Diudasiu hatinu. Ige abu matama ke abu hotomo ivihai avoe, ‘Akedama.’ Hoto ke ihuu koseanu. Tahoe matama. ");
INSERT INTO kpx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Deividiu subuta Diudasi deiada Samusi bukamo hisaliai avoe, ‘Valadave kemo atabeu bae ulivebene.’ Isi tota hisaliai avoe, ‘Malaha molena bae lovove mai lovive vai.’ ");
INSERT INTO kpx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Iale nahi malaha mole mage au bae Diudasi lovo mai nahehi igaetoai Iesuu hovelahale hoto ke loui ata haivei. Isito ata ke ebagevaveve keu koseanu. Ata oleu subuta Dioniu Iesu babatisohavoale ke elehai ehomai lohoale Iesuu ehue tiale ke elehai hilokale ata ke nahiabuna ebagevage auna Diudasi lovo mai nahehi ui.” ");
INSERT INTO kpx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bitau deiada kateale louge abu malaha abuita ebagevalu. Malaha mole ivilike Dioseba. Isege mole ivilike Mataiasi. Dioseba ivi moleike Basabasi. Isi ivive moleike Diasitasi. ");
INSERT INTO kpx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ige abu guliguliai loui avoe, “Kosive, a abostolo mole Diudasiu a lovi halei hatige a ibinave ominu. Iale no nova lovove malihoike ata abuita kobia tabagevelu. No Kosive, a ata bahatae uvu hilokaevemale alike. Ialelua no haivege no malaha igae ebagevage au Diudasi lovo mai.” ");
INSERT INTO kpx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kateaito ata abuita kebia ivi munemo hisalievei mai mihatuge ole iviu ehumo uale kena Diudasi lovo mai. Abu vaveve ke vage Mataiasi iviu ehumo ua. Ige abu ke ebagevage keu Iesu abostolo mole holinu. ");
INSERT INTO kpx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iniale vani mole Diue vahaehoe vani mole Bentikosi keu lohonu. Iale vani kemo Iesu esemuiau bahata bevuai o igaemo ua. ");
INSERT INTO kpx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Igaetoai o kemo usege lulu moleu hanunu ke nahate otogomo luluai lohoale oe uvu ke bahatamo lohoge abu evilu. ");
INSERT INTO kpx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Isi nilahai elehage keu venee vedodo ke nahate dobai lohoi igaegaeai kinaeabemo ui lotinu. ");
INSERT INTO kpx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vaveve keu Dilava Munanae Tumuike abuemo ui vuvunetievege abu igaegaeai hoto nimoletemo hoto loui lotilu. ");
INSERT INTO kpx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Vani kemo Dilava hoesehavomale Diue ata moagaeau Dielusalemae ua. Keau Dielusalema ata holioholisito vata bahatamo lohoale eboulahai Dilava hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iale keau luluale ke evisi bibuluvisi o keve lohoaleau o kela velehovoi vikolahalu. Kosealemo keau evige Iesu esemuiau hotoeabe igaegaemo hoto loui lotilu. ");
INSERT INTO kpx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Abu ke evisi vikolahai loui avoe, “Nahi hilokage malaha keau Galili ataeabulike. Keau nahie hoto hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iale oleve kateike abu vai nahie hoto selevemo hoto louma. ");
INSERT INTO kpx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nahiau o igaegaeai matama nimolete kebiamo loholu. Batia, Media, Elama, Mesobotamia, Diudia, Kabadosia, Botasi, Esia vata kebiamo loholu. ");
INSERT INTO kpx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Isi Vilisia, Babilia, Egubito, Keliti, Alebia, Libia (Keu Sailini vavae) vata kebiamo loholu. Isege nahi benahateau Loma o baluga kemo loholu. Nahi degomoleau Diue ata seleve. Isege nahi degomoleau Diue ata holioholisito Diue vaveve ke vama. ");
INSERT INTO kpx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nahiau vata nimolete kebiamo loholu. Isito nahi malaha kebia hoto evige keau nahie hoto selevemo Dilava vaveve nimolete louma.” ");
INSERT INTO kpx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kateai tetelahai mole namigevei avoe, “Osialemoike abu vaveve kateale vama.” ");
INSERT INTO kpx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Isi kateige degomoleau helahai loui avoe, “Ba, keau e toela ilike vaime katelahalu.” ");
INSERT INTO kpx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Abu kateai louge Bitau abostolo degomolehi hoto ke evilu. Ige Bitau hovelahai baita namigevei avoe, “Diue ata bahataeau Dielusalemamo uale evive. Di isiviale vaveve ko deiada loui la namigevei. ");
INSERT INTO kpx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","La huhuige no e toela ilu. Isito keu hoto seleve holioholinu. Elehave. Vau aike alamonu. Iale la huhuige atabena valive vavita vavita e toela isi. Ba. ");
INSERT INTO kpx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Isito beloveta Dioelau subuta mole hisaliale keike esemu koeau aike vama. ");
INSERT INTO kpx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dioelau hisaliale hoto keu koseanu. ‘Dilavau avoe, Dana vanie gabila di Munanae Tumu hanavoge auna dobai lohoi la bahata vuvunetievege la eseabuna ono vadeu gabie lohoveve ke loui ata namigevei. Isege la atae doga keabuna lahoahoai. Isege la malahae kosive keabuna tababu nimolete elegevei. ");
INSERT INTO kpx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ige Munana Tumutena dobai lohoi di esemu bahata negotievege malaha keate bahataeabuna ono vadeu gabie lohoveve hoto ke loui ata namigevei. ");
INSERT INTO kpx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ige dana vaveve nimolete otogomo hanavege vanina loasege batana tahoai. Isege heie vata kove taho, vene isi dio balugana ui. Keau kateisege iave keve Kosive vani balugana bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Vaveve katealeu velemage oleuoleu Kosive ivimo Dilava imihage auna kebia malevei.’ ");
INSERT INTO kpx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Iselala ataea, di hoto evive. Iesu keu Nasaleta omo lohoge Dilavau tedahoge au vuvunevemo vaveve nimolete vai vikoe vaveve nimoleta vaevenu. Iale au vadeu vale ke la elehai hilokalu. ");
INSERT INTO kpx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Isito la isiviale hamage au hatisi. Isi kateai mai atae toela ovege abu mai idie domo hamage au hatinu. Isito subuta mole Dilavau au lulelemo la vaveve ke hilokai loui avoe, Abuna katelahai. Ialeike la ke valu. ");
INSERT INTO kpx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iesuu vatehani mai hatiale kemo Dilavau etuvage au hovelahanu. Kosealemo hatihati ke vuvuneu mage au gulimo uveve keu anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deividiu subuta Samusi bukamo Iesu vaveve koseale hisalianu. Avoe, ‘Di hilokage Kosiveu vani bahata daiti uma. Keu di vavamo umalemo vaveve isutena daemo lohoge di bae kemo dobalivebene. ");
INSERT INTO kpx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ialemo di uvuu vahaeho balugage di Dilava hoesehavoveve hoto louma. Di hilokage dana hatige auna tota di etuvai. ");
INSERT INTO kpx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Iale di hatige au bae di munana halege au bae odavae ulivebene. Isi au bae au esemu tumute ke halege au bae gulimo ui sakavalivebene. ");
INSERT INTO kpx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Au ukolikolie humaha di haivui vani bahata daiti uge di kemo vahaeho baluganu.’ ");
INSERT INTO kpx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Di haokuvuia, di isiviale nahie buluve Deividi ke deiada louge avuemo lulelelahave. Keu subuta mole hatige abu mai abavulu. Iale vutave keu nova avulike ua. ");
INSERT INTO kpx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deividi keu Dilava beloveta holisi hilokage Dilavana au ono vade louale ke vai. Au Deividi namihai avoe, ‘Dana aemo a valada mole mage auna kosive holisi telonamo ugulamoi.’ ");
INSERT INTO kpx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ige Deividiu ke evisi Dilavau gabie vaveve hilokai Kelisou hovelahaveve kemo loui avoe, ‘Au hatige Dilavau bae munanave halege au bae odavae ulivebene. Isi gulimo halege au bae ui sakavalivebene.’ ");
INSERT INTO kpx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hoto kateale loualemo Dilavau etuvage hovelahage no ke elehalu. ");
INSERT INTO kpx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dilavau Iesu ebagamai au ada inuteve mamoi au louale ke nahate au Munana Tumute omige au Munanae Tumu noevege no vuvunevemo hoto ke louge la evilu. ");
INSERT INTO kpx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deividiu Iesuu vale ke nahate vai ehue tioholinu. Isito keu subuta loui avoe, ‘Dilavau di Kosiveho loui avoe, Di ada inuteve ugulamonela. ");
INSERT INTO kpx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Isege di a aiohavomale kebia malevei a veloe heimo otovege Kosiveabe holinela.’ ");
INSERT INTO kpx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Iselala ata bahataea, hoto ko evive. La Iesu mai idie domo hamale keike Dilavau etuvage hovelahai Kosive holisi a tedaeveve ata Keliso holinu.” ");
INSERT INTO kpx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bitau hoto kateale louge abu ke evisi huhube nimole valu. Isi kateai Bitata abostolo degomoleta namigevei avoe, “No haokuvuia, noeabuna vadeu vai.” ");
INSERT INTO kpx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ige Bitau namigevei avoe, “La bahata la vaveve toela vamale ke halevave. Isime Iesu Keliso ivimo babatisoage Dilavana la vaveve toela ke ulihai au Munanae Tumu laovei. ");
INSERT INTO kpx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dilavau isiviale au Munanae Tumu laovei la ese ovei olemeau haeavamole ui Dilava hoto eviale kebiata ovei.” ");
INSERT INTO kpx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bitau hoto ke loui hoto degomoleta loui namigevei avoe, “Nova vata komo ataeau vaveve toela vage Dilavana ibinaeabe ovei. Iale kemo hoidevege Dilavana la malevei.” ");
INSERT INTO kpx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kateai louge vani kemo ata moagaeau deiada ke evisi abu uvu mai avuemo mavoi babatisolahalu. Ata bahata tili taoseni (3,000) keau babatisolahai Iesu esemuhi igaetolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Isi vani bahata abuhi igaetolahai abostoloeau louale ke evisi negolahai guligulilahai aleto isi Dilava hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abostolo ata keau vikoe vaveve isi vaveve nimolete vaevege ataeau ke elehai vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ata oleuoleu abu uvu mai Iesu omiale keau igaetoai lohoi Dilava hoesehavoi abu kunai bahata tasalievei mole ovelu. ");
INSERT INTO kpx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Isi abu vata abu kunai voievei moniabe malei kemo kunaiholimale kebia ovema. ");
INSERT INTO kpx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Abuna vani bahata abu dubu balugae tiliege igaetolahaime guligulilahagei. Isime oe tiliege igaetolahaime lovi isi vahaeholahai mole tedaevegei. ");
INSERT INTO kpx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Keau katelahai Dilava hoesehavoge ata degomoleau ke elehai vahaehoabe vai Kosive hoto evige au kebia malevege abu Iesu esemuhi igaetoalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gutu mole tili (3) okolokimo Bitau Dioniti Diue dubu balugae guliguliho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tiliale keau dubu balugae velehovoi ata mole velo golote elehage au abu dubue udaha mole ivihai avoe Udahae Dua kemo ugulamoi uma. Malaha ke neinaveu mamoge velove keau golohovoalelua ataeabuna ke ebavoi loholiege udaha kemo mavoge olemeau dubu kemo tai lohomale kebiamo auna moniho imigevegei. ");
INSERT INTO kpx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iniale Bitau Dioniti dubu ke uvue tisege malaha keu moniho imigevenu. ");
INSERT INTO kpx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ige abu ke nibitumuage Bitau avuho loui avoe, “No niavenela.” ");
INSERT INTO kpx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ige au niavei huhuai avoe, “Mesoho koeabuna monibe daovai.” ");
INSERT INTO kpx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ige Bitau avuho loui avoe, “Dau monioholinu. Isito dana di mai lohoale ko mai aoi. Nasaleta malaha Iesu Keliso ke ivimo di a namihama. Hovelahai laminela.” ");
INSERT INTO kpx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kateaito adave inutela holisi ebagemage solekavesite malaha ke veloeau negolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ige au hovelahai vitoi lamisi oanu. Isi abuhi iaeabela vitovitoai dubue Dilava hoesehavoliho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Malaha keu kateai Dilava hoesehavoi tige ata bahata keau ke elehalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ke elehai hilokage malaha neheu dubue udahamo ugulamoi moniho ata imigevemale keike. Ke elehai ono vadeu avuemo velemale kemo vikolahai tetelahalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Malaha nehe keu Bitata Dionita vudievei vahaehoabe vasege ata bahataeau igaetoai bibuluvisi tiale dubu ke hedaka abu ivihai avoe Solomoni keve malaha ke elehaho tilu. Keau malaha nehe ke elehai vikolahai tetelahalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ige Bitau ata kebia elegevei abuho loui avoe, “Iselala ataea, osiohoike la vikolahai no nibieve tumuima. La huhuige noeabuna no vuvunemo mesoho no vavevemoike malaha ke hoesehavoge au oai tima. ");
INSERT INTO kpx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dilava keu subuta nahie buluve Ebalahamu, Aisiki isi Diekobo kebia Dilava. Iale keike au esemu Iesu ebagemai vuvune omige no vuvunevemoike vaveve ke valu. Isito la Iesu ke mai gamani kosive Bailoti omige au isiviale iomage au tai. Isito la kabebihavoi avuho isiviholilu. ");
INSERT INTO kpx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Keu ata tumute isi inutolotolote ata. Isito laeau avuho isiviholisi mai Bailoti omilu. Isi namihage au Iesu iomaholisito ata havemale ke iomanu. ");
INSERT INTO kpx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","La vaveve kateale vai gibosoune Kosive ke hamalu. Isito Dilavau hatihatimo etuvage hovelahanu. Iale noeau au hatai hovelahale ke elehale noeabulike koea. ");
INSERT INTO kpx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","No Iesu ivimo velo golote ke namihage au Iesu vuvunemo hovelahanu. No no uvu mai Iesuemo mavoalemoike malaha ke hoesehavoge au hovelahage la elehalu. ");
INSERT INTO kpx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Di haokuvuia, di hilokage la la kosivehi dolodololahalemoike Iesuemo vaveve ke valu. ");
INSERT INTO kpx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dilavau subuta au beloveta namigevege abu hisaliai avoe, ‘Dilavana Keliso hanavoge auna vatehani malei.’ Iale ke nahateike Iesuu mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Katealemo nova la vaveve toela ke halevai hoidevei lohoge Dilavana la vaveve toela ke ulihai la negotievege lana bae vuvunevemo ue dua vave. ");
INSERT INTO kpx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ige auna la tedaevemale kosive Iesu hanavoge auna tota dobai lohoi. ");
INSERT INTO kpx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Isito Iesuu nova otogoe uale auna gabie dobai lohoniege vata ko mai duatige auna subuta uale ke nahate vai. Dilavau hotoe deiada kateale au beloveta tumute kebiaho subuta louale kena bae lohoi. ");
INSERT INTO kpx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Beloveta mole Moseseu subuta loui avoe, ‘Dilavana bae di hanavoale ko nahate laheho beloveta mole hanavoi. Beloveta kena la valadamo lohoi hoto louge hotove bahata evive. ");
INSERT INTO kpx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Iale oleme abuna beloveta ke hoto evioholige Dilavana tasalievei havege abu uoholisi.’ ");
INSERT INTO kpx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Hoto ke igae Samuelau hisaliage beloveta degomoleau iave lohoale kebiata hisaliai novae vanimo velemale ke loulu. ");
INSERT INTO kpx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nahiau beloveta kebia valada. Iale nahiau kebia ese nahate. Subuta Dilavau au beloveta namigeveale hoto keu aike laemo lohonu. Dilavau vasohuta hoto ke loui Ebalahamu namihai avoe, ‘A valada kemo dana ata bahata hoesegevei.’ Dilavau hoto kateale loui mamoale keu aike laemo lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dilavau au mo Iesu hanavoge au vasohuta dobai lae lohoi isiviale la bahata hoesegevege la vaveve toela ke halevai hoidevei avue lohoi.” ");
INSERT INTO kpx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kateai lousege dubue kosive, dubu nalimale bukate igae, isi Sadukea ata degomole keau abue loholu. ");
INSERT INTO kpx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Lohoale itumulahalu. Kosealemo Bitau Dioniti hotoe deiada loui ata haivei avoe, “Iesuu hatai hovelahale kemo nahiabuna hovedevei.” ");
INSERT INTO kpx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hoto katealemo abu malevei dibulae otovelu. Gutumoike abu malevei bamuevege abu vavimo keve ladevelu. ");
INSERT INTO kpx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Isito ata bahata vai taoseni (5,000) keau hotoe dua ke evisi abu uvu malei Iesu omilu. ");
INSERT INTO kpx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iniale vani mole Diue dubue kosivea, oe kosivea isi Diue menaka loui hisaliamale keau Dielusalemae igaetoai loholu. ");
INSERT INTO kpx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Lohoale keau dubue kosive baluga Anasi isi esemuve degomole kebiatamo loholu. Esemuiabe kebia ivilike koea: Kaiabasi, Dioni, Alekisanda. ");
INSERT INTO kpx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Iale keau Bitata Dionita malevei lohoi abu vigomo otovei belagevei avoe, “Ole vuvuneta ole ivitamoike la vaveve ke valu.” ");
INSERT INTO kpx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ige Bitau Munanae Tumue vuvunemo namigevei avoe, “Dubue kosivea isi oe kosivea, di hoto ko evive. ");
INSERT INTO kpx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Lana vaveve dua no velo goloteho vale kehonike no belagevema. Lana isiviai hilokai oleve kateike no vai ke hoesehavolu. ");
INSERT INTO kpx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Keta duave. Di isiviale la namigevege la bahata hilokave. La louike vage abu Nasaleta malaha ke mai idie domo hamage au hatige abu mai gulialu. Isito Dilavau tota etuvage Iesuu tota hovelahanu. Iale vuvunevemoike velo golote keu momoleai lamisi oanu. ");
INSERT INTO kpx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iale di hoto mole louge evive. Bukae Hotou Iesu vaveve ke loui loui avoe, ‘Laeau o mole houmale ata kebia nahate. La o houveve mune ke kabebihavoale keike nova Dilava o hadebiveve munee dua holinu.’ ");
INSERT INTO kpx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iale avu igaemo nehane ukolikoli maleve. Heie vata kove vuvuneve ke nahatebeu uoholinu. Isito vive ke igaemo nahiabuna ukolikoli malei.” ");
INSERT INTO kpx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kateai louge Diue kosive keau ke evisi vikolahai huhuige malaha keau sikuluholialea. Isito luleleabe kemo abu elehage keau Iesu esemuia. ");
INSERT INTO kpx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kateai isiviale abuho hoto loui. Isito abu elehage malaha nehe veloveu duaveale keu Bitame Dionimehi lamisi ua. ");
INSERT INTO kpx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kateige kosive keau Bitata Dionita hanavege abu heie usege abu unaha abu moletehi hotohotolahama. ");
INSERT INTO kpx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Hotohotolahai mole namigevei avoe, “Nahiabuna malaha kebiamo ono vade igae vai. Kosealemo ata bahataeau Dielusalemae umale keau hilokage keau vikoe vaveve balugatahoike abu ke valu. Iale nahi bae kemo hotobe loulivebene. ");
INSERT INTO kpx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Katealelua nahi ata kebia keluevege abu lako tota atabeho Iesu ivimo vuvune vaveve vale ke lougelive.” ");
INSERT INTO kpx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kateai louito Bitata Dionita hohavege abu lohoge keau isuta namigevei avoe, “Lainaho bae tota Iesu ivimo hotobehame loui ata haivegelive.” ");
INSERT INTO kpx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Isito Bitau Dioniti namigevei avoe, “La biaeau Dilava nimo ko huhulahave. Noeabuna la hoto evisi. Emena Dilava hoto evisi. ");
INSERT INTO kpx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Isito no Iesu elehai hotove evialemo no bae ata haiveveve ke halevalivebene.” ");
INSERT INTO kpx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kateai louge Diue kosive keau isiviale banisigevei. Isito abu elehage ataeau velo golotemo vaveve dua ke elehai Dilava hoesehavoma. Katealemo abu banisigeveveve humahau uoholige abu isuta namigevei avoe, “Lainaho bae tota gabie hoto ke lou molealive.” Kateaito iovege abu tilu. ");
INSERT INTO kpx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Malaha nehe abu hoesehavoale ke vaganau mesoho voti (40) ke nahate. ");
INSERT INTO kpx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bitau Dioniti halevai tialeau kosive keau abuho louale ke loui evievi ata namigevelu. ");
INSERT INTO kpx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ige keau ke evisi igaetoai Dilava imihai avoe, “No Kosive, au vuvunete. Au otogo vai vata vai e vai avuemo onobenobe vaevei otovenu. ");
INSERT INTO kpx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Subuta mole a a Munana Tumute hanavoge au tiale no buluve Deividi ke negotige au loui avoe, ‘Osiohoike Dilava hoto evioholimale keau itumulahalu. Isi osiohoike ata keau huhuihuhuie toela ke huhu kavalu. ");
INSERT INTO kpx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vatae kosiveau isiviale hovedevei mole bevuevei igaetoai Dilavau au mo hanavoale ke hamai.’ ");
INSERT INTO kpx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Deividiu subuta louale keu seleve. Iale nova o komo kosive Elodi, kosive mole Botiasi Bailoti, Diue ata holioholialea, isi Diue ata degomole keau bahata mole bevuevei a a esemu tumute Iesu ebagemai hanavoale ke hamage hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Keau mole bevuevei vaveve ke vage a a vuvunemo vasohuta hilokage abuna ke vai. Iale a isivimoike abu ke valu. ");
INSERT INTO kpx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","No Kosive, abu nova noheho isuta louale ke evinela. Noeau a esemu. Iale a nego noevege no vabu halevaito a hoto loui ata namigevei. ");
INSERT INTO kpx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Isime a vuvune hanavoge no a esemu tumute Iesu ke ivimo vavahanite ata hoesegevei vaveve nimoleteta vaevei.” ");
INSERT INTO kpx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Guliguli keu uoholisege abu igaetoai guliguliale o keu hadanu. Ige Munana Tumuteu kebiamo lohoi malevei negotievege abu vabuoholisito tilialeau Dilava hoto loulu. ");
INSERT INTO kpx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vani kemo Iesu esemu bahata keau huhuihuhui igae isi uvu igae. Kunaite keau koseale louholilu. Kunai koeau noele. Isito abu kunai ke igaegaeai mole ovelu. ");
INSERT INTO kpx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ige abostolo ata keau negolahai Iesuu hatisi hovelahale ke loui ata haivege Dilavau kebia bahata hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ige keau bahata kunai maleale mole nahate unaha. Kosealemo ata kebiau abu vata abu o kebia voievei ibinaeabe malei loholu. ");
INSERT INTO kpx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Malei lohoale abostolo kebia ovege abu malei kunaiholimale kebia ovelu. ");
INSERT INTO kpx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ke nahate malaha mole Dioseba keu Livai malaha. Keu Saibalasi vata keve uniale au vata voiai ke ibina malei lohoale abostolo kebia ovenu. Ige abostolo keau ivihai avoe Banabasi. Ivi ke ihuu koseanu. Ata negotievemale ata. ");
INSERT INTO kpx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Malaha mole Ananaiasiu abu keate Sabaelati abu vata voiale ke ibina malelu. ");
INSERT INTO kpx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Isi ke malei mole namigevei avoe, “Nahi ibinave vaki molehame ovei. Isi vaki mole nahie ebikaho otovei.” Kateige Ananaiasiu moni ke vaki mole mai lohoaleu abostolo ovei loboe hoto loui namigevei avoe, “Vatae ibina avuhameike ko.” ");
INSERT INTO kpx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kateai louge Bitau avuho loui avoe, “Ananaiasi, onoleike a ko vanu. Seteneu a uvumo lohoike vage a moni degomole a ebikaho otoveito Munana Tumute lobohavoi loui koseanu. Moni bahataike ko. ");
INSERT INTO kpx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Subuta a vata ke voioholisege vata keu a vata. Isi gabie a ke voiage keu a moni. Iale a osiohoike hoto kateale lounu. A no igae lobogeveholisito Dilavataike a ke lobohavonu.” ");
INSERT INTO kpx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kateisege Ananaiasiu ke evisi lokilahai dobai hatinu. Kateige ata bahataeau ke evisi vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kateige ata degomoleau ogo malei lohoi viliai ebavoi mai tiliale heie gulialu. ");
INSERT INTO kpx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iniale gutumo Ananaiasi keateu lohonu. Isito keate keu onoleu koliavemo velemale ke hilokaholinu. ");
INSERT INTO kpx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ige Bitau keate keho loui avoe, “Lobo haleito di namihanela. La vata ke ibina bahatanike ko.” Ige keate keu namihai avoe, “Ito bahataike ke.” ");
INSERT INTO kpx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ige Bitau avuho loui avoe, “Osiohoike a a koliati isiviale Dilava Munanae Tumu lobohavoi. Evine. Malaha keau a kolia mai guliale abulike aike udahamo lohoma. Iale abuna aike ata ebavoi tai.” ");
INSERT INTO kpx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Isi kateisege solekavesite keate keu velove heimo lokilahai dobai hatinu. Ige malaha nehe keau lohoale keate nehe ke elehage hatige abu ebavoi mai heie tiale koliaveta havaisi gulialu. ");
INSERT INTO kpx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ige ekalesia bahata isi ata degomole keau ke evisime vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vani kateimalela abostolo tuelo (12) keau vikoe vaveve nimolete moaga vaevege ataeau kebia elegevelu. Evievi ata kebiau bahata Diue dubu balugae hedaka Solomoni keve mole bevuevei igaetoai uma. ");
INSERT INTO kpx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Isege evievi ata holioholiale keau evievi ata vabugevei isiviholilu abue loholiho. ");
INSERT INTO kpx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ige ata moagamoagaeau hoto ke evisi abu uvu mai Iesuemo mavoi mole bevuevei igaetoalu. ");
INSERT INTO kpx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ige abostolo keau vikoe vaveve vasege ataeau vavahanite kebia malevei lohoale heie humahamo ava tedisi kemo otovei huhuai avoe, “No kateige Bita munanau haidolevege abu momolelahai.” ");
INSERT INTO kpx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kateige ata moagaeau abu o halevei o baluga Dielusalemae lohoi vavahaniamale ata kebia isi munanae toelau uvuiabe holoeavomale kebiata holoevei loholu. Ige abostolo keau kebia bahata hoesegevelu. ");
INSERT INTO kpx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Abostolo keau kateige dubue kosive baluga keu au haokuvu Sadukeahi ke elehai mainaeabe mai ilu. ");
INSERT INTO kpx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Isi kateai kebia malevei tilialeau dibulae otovelu. ");
INSERT INTO kpx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Isito vavi kemo Dilavau au anelu mole hanavoge au tiale keu dibulae udaha alavoi kebia hanavege abu heie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Isi namigevei avoe, “Talive dubue uvue lavisi ukolikolie hoto loui ata namigeveve.” ");
INSERT INTO kpx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kateai louge abu ke evisi tilu. Tilialeau vavita vau alamoge abu lohoi dubue uvue ata haivesege dubue kosive baluga keu au haokuvuhi Diue kosive bahata hohavege abu lohoale hotohotolahalu. Isi bukate hanavege abu dibulae abostolo maleliho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tiale keau dibulae velehovoi abostolo kaovege uoholige abu hoidevei lohoaleau kosive kebia namigevelu. ");
INSERT INTO kpx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Namigevei avoe, “No velehovoge udaha keu bamusege udaha nalimale keau heie lavisi ua. Isito no udaha alavoi uvuve tige ataeau uoholilu. ");
INSERT INTO kpx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kateige dubue kosive isi bukate kebia kosive keau hoto ke evisi vikolahalu. Isi dolodololahai avoe, “Abostolo keau oleve katelahalu.” ");
INSERT INTO kpx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kateisege malaha moleu lohoale namigevei avoe, “Di la namigevege evive. La malaha nehebia malevei dibulae otoveale kebiau aike dubue uvue ata haivema.” ");
INSERT INTO kpx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Isi kateige bukate kebia balugau au esemu holoevei Iesu esemu maleveliho tilu. Tiliale keau baita abuho louoholisi haveholilu. Kosealemo abu huhulahai avoe, “Noeabuna kobia havege ataeabuna mune malei nohavei.” ");
INSERT INTO kpx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Isi kateai abostolo kebia malevei dubue kosive kebia vudimo otovelu. Ige dubue kosive baluga keu hovelahai belagevenu. ");
INSERT INTO kpx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Belagevei avoe, “Lana no hoto evilu. No subuta la namigevei loui kosea, ‘Lainaho bae tota Iesu ivimo deiada loui ata haivegelive.’ Isito la nova hoto ke loui Dielusalemae ata bahata kebia namigevema. Isi la isiviale no vavamo lobolahai loui kosea, ‘Keabulike Iesu hamalu.’” ");
INSERT INTO kpx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ige Bitau esemu benahatehi abuho loui avoe, “Seleveta no bae atabe hoto evilivebene. Isito noeabuna Dilava hoto unaha evisi. ");
INSERT INTO kpx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","La Iesu mai idie domo hamage au hatige abu mai gulialu. Ige nahie buluvebia Dilava keu etuvage hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isi mai au ada inuteve mamoge Iesuu kosive baluga holisi ata tedaeveveve ata holinu. Iale Iselala ataeabuna abu vaveve toela halevage Kosivena vaveveabe toela ulihai hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keike Munana Tumuteu no haivege no ke hilokai ata haivema. Iale oleuoleu Dilava hoto evige auna au Munanae Tumu ovei.” ");
INSERT INTO kpx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abostolo keau kateai lousege Diue kosiveau ke evisi itumulahai isiviale kebia havei. ");
INSERT INTO kpx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Isito Balisia malaha mole baluga Gameliela keu isiviale hovelahai hoto loui. Malaha keu Diue menaka bahatamo lulele seleveanu. Isi malaha ke ata bahataeau eahalema. Iale keu abostolo kebia hanavege abu heie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Isi Diue kosive kebia namigevei avoe, “Iselala ataea, huhuihuhuie dua vaito bae gabie abostolo kebia aiogeveve. ");
INSERT INTO kpx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","La hilokage subuta vagana mole malahae toela Teodasi keu au ebika ebagemage ata moaga mesoho voa handele (400) keau igaetoai ehovalu. Abu isivialeike gamani aiohavoi. Isito gabie gamaniu Teodasi hamage hatige esemuiabe keau bahata vabulahai detuluvisi igaegaealu. ");
INSERT INTO kpx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Isi vani moleike gamaniu atae ivi dodavemale ke vanila Galili malaha mole Diudasi keu hovelahai ata moaga holoevei isiviale talive gamani aiohavoi. Isito gamaniu ke hamage hatige esemuiabeau detuluvisi igaegaealu. ");
INSERT INTO kpx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iale katealemo di hoto onole louge evive. Lainaho bae malaha kebia havegelive. Isito hanavege abu tai. Kosealemo abuna abu negomo vaveve kateale valiege solekavesite uoholisi. ");
INSERT INTO kpx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Isito abuna Dilava vuvunemo vaveve kateale vage lana bae oleve kateai kebia havei aiogevei. Mesoho lana vaveve kateale valiege bae Dilava aiohavove.” ");
INSERT INTO kpx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Malaha keu kateai louge kebiau hotove ke evisi Iesu esemu kebia hohavege abu lohoge visugevei hanavei loui avoe, “Lainaho bae tota Iesu hoto loui ata haivegelive.” ");
INSERT INTO kpx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kateige esemu kebiau Diue kosive kebia halevei vahaeholahai tilu. Kosealemo kebiau Iesu ivimo vatehani malege Dilavau ke elehai kebia eahalegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Isi kateai vani bahata abu dubue isi oe timale hotoe dua loui ata haivei avoe, “Iesu keu ata tedaevemale kosive Keliso.” ");
INSERT INTO kpx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Vani kateimalela ata moagaeau hoto ke evisi abu uvu mai Iesuemo mavolu. Isege vani mole Gilikie hoto loumale keau Diue hoto loumale kebiahi moleho louma. Giliki ata keau loui avoe, “Vani bahata no gobuvu keabuna loholiege lovie esehame malegei. Isito Diue gobuvu keabuna loholiege lovi baluga malegei.” ");
INSERT INTO kpx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ige abostolo keau hoto ke evisi esemu kebia bahata hohavei abuho loui avoe, “La huhuige noeabuna Dilava hoto ke loui ata haiveveve ke halevai ata oveveve lovi unaha hoesehavoi. Ba, kateale keu toelanu. ");
INSERT INTO kpx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Di haokuvuia, nahie vigomo malaha seveni (7) tabagevege elike keau ata oveveve lovi ko nalisi. Isito malaha lulelete isi Dilava Munanae Tumuu negotievemale kebia tabageveve. ");
INSERT INTO kpx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Isege noeabuna vani bahata guliguliai ata haivegei.” ");
INSERT INTO kpx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kateai louge esemu benahateau loui avoe, “Keu duave.” Isi kateai vasohuta Sitiveni ebagevalu. Keu au evievimo negoige Munanae Tumuu mai negotinu. Isi Bilibi ebagevai Bokolasi, Nikano, Timoni, Bamenasi, tabagevei gabiabela Antioka malaha mole Nikolasi ke ebagevalu. Nikolasi keu Diue ata holioholisito gabieike au vaveveabe manu. ");
INSERT INTO kpx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kateai malaha seveni (7) kebia malevei lohoge abostolo keau abu ada malei tataeabemo otovei abuho guligulilahalu. ");
INSERT INTO kpx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Keau kateige Dilava hotou Dielusalemae tai balugage ata moagaeau hoto ke evisi abu uvu mai Iesuemo mavolu. Ige Diue dubue kosive moagaeau hoto ke evisi abuta Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dilavau malaha nehe Sitiveni hoesehavoi vuvune omige au kemo vaveve nimolete isi vikoe vaveve moaga atae vigomo vaevenu. ");
INSERT INTO kpx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kebia vaevege Diue dubu mole Libetini ata degomole keau hotove hamalu. Abu kateige Salini ata degomole, Alekisandia ata degomole, Silisia ata degomole, isi Esia ata degomole keau bahata igaetoai itumulahai isiviale Sitiveni hoto hamai. ");
INSERT INTO kpx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Isito Munanae Tumuu Sitiveni negotige au lulelevemo hotoe dua unaha loui hotoeabe lobo ke hamanu. ");
INSERT INTO kpx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kateige abu tiale malahae toela kaovei malevei loholu. Ige ata keau lobolahai avoe, “No evige malaha kou vani bahata Mosese menaka isi Dilava ivi aiohavoma.” ");
INSERT INTO kpx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Isi kateai louge Diue ataeau ke evisi itumulahalu. Ige Diue kosive isi Diue menaka loui hisaliamale keau lohoale Sitiveni evudei melavei kotaho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Isi tota malahae toela kebia kaovei holoevei lohoge abu loui avoe, “Malaha keike Sitiveni keu vani bahata nahie dubu isi Mosese menaka kemo hotoe toela louma. ");
INSERT INTO kpx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","No evisege au loui avoe, ‘Nasaleta malaha Iesu kena nahie dubu koiai hatui. Isi Moseseu menakae tumu mai nahie buluve oveale keta aiohavoge auna uoholisi.’” ");
INSERT INTO kpx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abu hoto kateale lousege Diue kosive keau Sitiveni niavosege niveu atagale anelue ni ke nahate. ");
INSERT INTO kpx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ige dubue kosive baluga keu Sitiveni belahai avoe, “Abu a vavamo loumale kena selevenike.” ");
INSERT INTO kpx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ige Sitiveniu namihai avoe, “Usege di hoto mole loui. Di ataea, di haokuvuia, la bahata di hoto gaeahavove. Subuta mole nahie buluve Ebalahamu keu sohu Mesobotamiae ui Halani vatae tioholisege otogoe umale Dilava keu dobai lohoi avuho lounu. ");
INSERT INTO kpx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Avuho loui avoe, ‘A ata, a vata kebia halevei tenela. Dana vata moleve a hanavoge keve te.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kateai louge Ebalahamuu au vata Kalidia ke halei tiale Halani vatamo uniale mamaveu hatige Dilavau louge au Iselala vata kove lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Vani kateimalela Dilavau vatabe mai Ebalahamu omioholinu. Isito au louale auna bae gabie avuho vata ke mai omisi. Iale Dilavau louale Ebalahamu valadaeabuna bae vata ke mai. Isito vani kela Ebalahamuu eseholilike vasege Dilavau avuho hoto ke lounu. ");
INSERT INTO kpx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Isi avuho loui avoe, ‘A valadaeabuna bae vagana voa handele (400) ke uvumo vata nimoleteve uliege ata kebiaho lovilahai vatehani baluga malegei. ");
INSERT INTO kpx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Vagana kateale abuna uoholige oleteau a valada kebiamo vaveve toela vage dana toelaeabe ibina ovege a valada keabuna loholiege kove di hoesehavoi.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dilavau kateai louito vaveve nimolete Ebalahamu haivui isiviale au au moe vudie vate etulelive kemo vani bahata Dilavau avuho hoto loui mamoale ke huhuigei. Iniale gabie move Aisikiu uge bula igaeu uoholisege mamaveu vudive vate etulenu. Ige gabie Aisikiu au mo Diekobomo vaveve kateale vanu. Ige Diekobou au ese tuelo (12) kebiamo avuta vaveve kateale vanu. Iale ese kebiamoike nahie umukau lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Diekobo ese degomole keau abu hoho Dioseba ke maina mai isi maime ata degomolemo voilahage abu mai Egubitoe tilu. Isito Dilavau keve avuti ua. ");
INSERT INTO kpx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ige vaveve toelau avuemo lohoge Dilavau hoesehavoi avuti uniale vani mole Diosebau Belo nimo lamige Dilavau au lulele mai omige au kosive kemo vaveve dua unaha vage au vahaehove vanu. Katealemoike Belou Dioseba mamoge au Egubitoe ata bahata nibievei ovemo atave kebiata nibievema. ");
INSERT INTO kpx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Iniale vani mole Egubito isi Keinani vata kebiamo vae balugatahou lohoge ataeau vaeho ue toela valu. Kateige nahie buluve kebiata vaelahalu. ");
INSERT INTO kpx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ige Diekobou loviu Egubitoe uale ke evisi au ese hanavege abu lovi maleliho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iniale tota vani mole maleliho tige Diosebau bae au ebika mai au nanuvu haivege Belou avuta bae kemo malaha kebia hilokaevenu. ");
INSERT INTO kpx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ige Diosebau au mama Diekoboho hoto hanavoi loui avoe, ‘A ese bahata holoevei kove loho.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kateai louge Diekobou au ata bahata seveniti vai (75) kebia holoevei Egubitoe tiale keve uniale hatige eseabeta keve haluvilu. ");
INSERT INTO kpx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Haluvisege eseabeau kakavei lohoale Ebalahamuu subuta Hamu ese kebiamo vata mole Sekamu ke ibina valemo gulievelu. ");
INSERT INTO kpx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Iniale gabie vagana moagaeau uoholige Dilavau subuta Ebalahamuho hoto loui mamoale ke vaniu lohoge Egubitoe umale ata keau moagataho selevealu. ");
INSERT INTO kpx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Vani kela kosive moleu Dioseba hilokaholiale keu Egubitoe ata kebia nalievema. ");
INSERT INTO kpx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kosive keu nahie buluve lobogevei loui avoe, ‘La eseau uge botoe halevege abu haluvisi.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Vani kela ese mole dua Moseseu ua. Ese keu uge abu mai oe uvue mahogovalu. ");
INSERT INTO kpx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ige bata abuita igaetaeau uoholige mahogovaveve humahau uoholige abu mai botoe meavolu. Isege Belo mau tiale ese ke elehai mai au ebiaho lohoi au ese toanu. ");
INSERT INTO kpx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Isi louge Egubitoe lulelete ata keau Mosese haivuge au vaveveabemo luleleai ata baluga holisi negoe vaveve vanu. ");
INSERT INTO kpx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Iniale vagana votiu uoholige vagana molemo Moseseu isiviale talive au ata seleve elegevei. ");
INSERT INTO kpx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isi tiniale Egubitoe ata mole elehasege keu Iselala ata mole hamai aiohavoma. Ige Moseseu au ata ke tedahoi Egubitoe ata ke hamage hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moseseu kateaito huhuai avoe, ‘Di kateige Iselala ataeabuna hilokage Dilavau di hanavoale dana kebia holoevei Egubito halei tai.’ Isito ata kebiau Moseseu huhuale ke hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iniale vani mole au oai tisege Iselala malaha abuiau mole havema. Ige au tiale elegevei keluevei abuho loui avoe, ‘Di haokuvuia, di hoto evive. La keau avui igaealelua lainaho mole havegelive.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kateai louge malaha neheu au haokamo vaveve toela vale keu Mosese kabitisi avuho loui avoe, ‘Ana no kosive holilike vaniale no keluevei no vavevemo hoto louma. ");
INSERT INTO kpx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ani, a isiviai nivu Egubitoe ata hamale ke nahate dahamolihoike.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kateai louge Moseseu ke evisi Egubito halei detitisi tialeu Midianie ua. Keve uniale mahinai mo abuita houevenu. ");
INSERT INTO kpx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Moseseu vata keve uale vagana votiu uoholige tomagie tiale tana mole baluga Sainai keve velemanu. Keve velemage anelu moleu avue lohoniale keu idiu lahai haetohaetoale kemo ua. ");
INSERT INTO kpx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ige Moseseu ke elehai vikoaime isiviai talive vuguta neniai elehai. Kateai tialeu vavavemo lamisege Dilavau avuho hoto mole lounu. ");
INSERT INTO kpx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Isi loui avoe, ‘Dau a buluve kebia Dilava. Ebalahamu Dilava, Aisiki Dilava, isi Diekobo Dilava dalike ko.’ Kateai lousege Moseseu vabuai teteai isiviholinu ke elehaliho. ");
INSERT INTO kpx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kateige Dilavau avuho loui avoe, ‘A veloe vate ke tohoanela. Kosealemo a matama kemo lamiale keu vatae tumu. ");
INSERT INTO kpx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Di hilokage Egubitoe ata keau di ata aiogevege keau vatetumu malei kekolahage di ke evisi tedaeveho dobai lohonu. Iale lohoge di a hanavoge Egubitoe tenela.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Dilavau kateai louge Moseseu halei tiale Iselala ata namigevege abu keho isiviholisi loui avoe, ‘Ana no kosive holilike vaniale no nibieveho louma.’ Isito Dilavaike Mosese mai negotige au tiale au ata nibievenu. Au kateisege anelu nehe idiu lahale keve uale keike Mosese tedahonu. ");
INSERT INTO kpx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iale kemoike au vikoe vaveve vaevei au ata holoevei Egubito halei tiale E Tahote kemo tota vikoe vaveve moleta vai tota tiale tomagie vikoe vaveve nimolete vaevenu. Kateale valage vagana votiu (40) uoholinu. ");
INSERT INTO kpx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosese keike Iselala ata namigevei avoe, ‘Dilavana di hanavoale ko nahate bae beloveta mole hanavoi. Ige kena bae la vigomo lamisi la tedaevei.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosese keike Iselala ata holoevei abuhi tomagie ua. Isege nahie buluve keau heie usege au Sainai tanae tiale anelue hoto evinu. Anelu keu ukolikolie hoto louge nahie buluve keau ke evisi hisaliage keike nahita nova evilu. ");
INSERT INTO kpx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nahie buluveau isiviholilu hoto ke maliho. Isito isiviale Mosese halevai hoidevei tota Egubitoe tai. ");
INSERT INTO kpx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Isi kateai Eloni namihai avoe, ‘Noheho dilava mole vage auna noheho uli holisi tai. Kosealemo no holoevei lohoale Mosese keu tanae tiale osioi lohoholinu.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kateai louito dilava mole bolomakau nahate vai abu adatela vale keho ovo havei ke hoesehavoi havulahalu. ");
INSERT INTO kpx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Abu vaveve kateale vage Dilavau au ebia abuemo bamui halevege abu didi, vanie ni, bata hoesegevema. Abu vaveve kateale vage beloveta malaha moleu Bukamo ke hisaliai avoe, ‘Iselala ataea, laeau vagana voti (40) kemo tomagie uale lana di hoesehavohonike ovo havei mohoevelu. ");
INSERT INTO kpx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ba, di hilokage laeau loboe dilava Molokoike o eseta ebavoi tiale hoesehavoi loboe dilava mole Levani didi nahate keta ebavoi tilu. Laeau loboe dilava kebia vaevei hoesegevemale kemo dana la iovege lana bae Babulonia ke iae matama moleve teve.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nahie buluveau tomagie valai balugata dubu mole houi Dilavau au menaka mai oveale ke abu mai valai dubu kemo mavolu. Dubu keu Dilavau Mosese haivuale ke nahateike abu houlu. ");
INSERT INTO kpx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vani mole Diosuau nahie buluve kebia ese holoevege abu valai ke ebavoi Keinani vatae tilu. Ata degomoleau subuta vata kemo uge Dilavau kebia nunuvege abu tisege nahie buluveau vata kemo ui valai keta dubu houge uale uale Deividi vani ketala velemanu. ");
INSERT INTO kpx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ige Deividi vanimo Dilavau Deividi hoesehavoge au isiviale Iselala atae Dilava keho dubu seleve houi. ");
INSERT INTO kpx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Isito move Solomoni keike Dilavaho dubu seleve hounu. ");
INSERT INTO kpx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ke houito nahi hilokage Dilava ehue uale keu bae ataeau dubu houale kemo ulivebene. Beloveta moleu kemo hisaliai avoe, ");
INSERT INTO kpx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Dilavau loui avoe, Otogo keu di ugulamomale telona. Isege vata keu di velo mamomale matama. Iale lana o oleteale dahoe houi. Dana oleve kateai keve ui. Keu daemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kosealemo dalike onobenobe bahata vaevenu.’ ");
INSERT INTO kpx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“La uvu keu osiohoike vage la Dilava hoto ke evioholilu. La keau nahie buluve kebia nahate. La vani bahata Dilava Munanae Tumuho isiviholisi kabebihavoma. ");
INSERT INTO kpx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nahie buluveau beloveta bahata havege abu vatehani malelu. Subuta vani kemo beloveta keau Dilava esemu inutolotoloteu lohoveve hoto ke louge nahie buluveau kebia havei hoto ke bamuge novae vani komo la esemu ke mai atae toela ovege abu hamage hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dilavau au menaka mai anelu ovege abu mai la buluve ovege la menaka ke maito keho isiviholisi halevalu.” ");
INSERT INTO kpx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitiveniu abuho kateale louge Diue kosive keau ke evisi avuho itumulahai monogigialu. ");
INSERT INTO kpx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ige Munana Tumuteu Sitivenimo ualemo au ehue niai Dilava ataga elehage kemo Iesuu Dilava ada inuteatave laminu. ");
INSERT INTO kpx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ige au ke elehai loui avoe, “Di elehasege otogou alavoge Atae Eseu Dilava ada inuteve laminu.” ");
INSERT INTO kpx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ige abu hoto ke evisi baita kekolahai abu golema bamui isiviholilu hoto ke eviliho. Isi igaetoai tiale Sitiveni evudelu. ");
INSERT INTO kpx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Evudei mai tiale o ke iae abu dabae ogo bodievei malei malaha mole Solo omisito mune malei Sitiveni hamalu. ");
INSERT INTO kpx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hamage au guliguliai loui avoe, “Di Kosive Iesu, di munana mage di hatai.” ");
INSERT INTO kpx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kateai louito au kome bokoai vata bisi baita hoai loui avoe, “Kosive, ainaho vaveveabe toela kemo ibinae toela ovelive.” Kateai louito halei hatinu. Abu kateai Sitiveni hamasege Bolou ke elehai abuho hotobe louholisito vahaehoanu. ");
INSERT INTO kpx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Vani kateimalela ata keau ekalesiau Dielusalemae umale kebia bahata aiogevege abu vatehani baluga malelu. Vatehani malei Diudia vata isi Samalia vata keve detuluvisi tisege abostolo unahaeau Dielusalemae ua. ");
INSERT INTO kpx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ige vani kela atae dua degomoleau Sitiveniho ninalahai mai abavulu. ");
INSERT INTO kpx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ige Solou isiviale ekalesia aiogevege abu uoholisi. Kateai o igaegae kela evievi ata kebia havei malevei lohoale dibulae otovenu. ");
INSERT INTO kpx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ekalesiau detuluvisi matama bahatae tiale Iesu hoto loui ata haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Isege Bilibiu Samalia oe tiale keve Iesu Kelisoe hoto loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ige ata moagaeau hotove ke evie dua vai au vaveve nimolete vamale keta elehalu. ");
INSERT INTO kpx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Abu ke elehasege Bilibiu munanae toela kebia abuemo nunuvege abu kekolahai ata halevei tilu. Isi vavaeabeu kibioholimale isi velo golote kebiata hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Keu kateige ataeau ke elehai vahaeho balugalu. ");
INSERT INTO kpx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Isege malaha mole Saimoni keu o kemo ui vani moaga au ebia mai mihatui ata lobogevege abu vaveveve ke elehai vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ata bahata kosi esebulu keau hotove evisi loui avoe, “Malaha ke vuvuneu balugatahoai Dilava vuvune nahate.” ");
INSERT INTO kpx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Loboe vaveve vamale keu kateai ata lobogevege ataeau vabuhavoi hotove evima. ");
INSERT INTO kpx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Abu kateisege Bilibiu lohoale ataeau Dilava adae vuvunemo uveve hoto loui Iesu ivimo ata haivege ata bahataeau hotove evisi babatisolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ige Saimoni nehe keta hoto ke evige Bilibiu babatisohavoge au avuti oima. Ige Bilibiu vikoe vaveve vage au ke elehai vikoanu. ");
INSERT INTO kpx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samalia ataeau Dilava hoto evisi male hoto ke abostoloeau Dielusalemae umale keau ke evisi Bitata Dionita hanavege abu tilu. ");
INSERT INTO kpx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tiale keau Samaliae velehovoi kebiaho guliguliai isiviale abu Munanae Tumu malei. ");
INSERT INTO kpx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kosealemo Munana Tumuteu kebiamo lohoholige keau Iesu ivimo babatiso unahalu. ");
INSERT INTO kpx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ige Bitau Dioniti abu ada malei tataeabemo otovege kebiau Munanae Tumu malelu. ");
INSERT INTO kpx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kateisege Saimoniu vaveveabe ke elehai isiviale moni malei Dionita Bitata ovei. ");
INSERT INTO kpx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Isi namigevei avoe, “Moni ko malei vuvune ke mai daovage elike data di ada malei atae tatamo otovege abu Munanae Tumu malei.” ");
INSERT INTO kpx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ige Bitau namihai avoe, “A huhuale ana a moni keta Dilava vuvune ke ibina vai. A katealemo a moni keti matamae toelae tenela. ");
INSERT INTO kpx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A vaveve kateale vaniege a bae no lovi ko valivebene. Kosealemo a uvu keu Dilava nimo inutolotoloholinu. ");
INSERT INTO kpx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Di hilokage vaveve toelau a uvu ke mai aiohavoge a vaveve toelae isivi unaha vama. A huhuihuhuie toela kateale huhuimalemo hoilahai Dilava imihage au a vaveve toela ke ulihai.” ");
INSERT INTO kpx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kateai louge Saimoniu namigevei avoe, “Daho Kosive imihage elike la louale keu daemo loho halei.” ");
INSERT INTO kpx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bitau Dioniti Dilava hoto loui ata haivege uoholige halevai Dielusalemae hoidevei tilu. Tiale humaha tavae hotoe dua loui Samalia ata haivei tilu. ");
INSERT INTO kpx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Vani mole Dilava anelu moleu Bilibi namihai avoe, “Hovelahai valahae talive Dielusalemae velemai humahae eseu Gasa vatae tiale kela tenela.” ");
INSERT INTO kpx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ige Bilibiu hovelahai tiale humaha tavae Itiobia malaha moleti belemanu. Malaha keu Itiobiae gamani kosive baluga holisi Kuini Kadasiu vata ke naliale monive ke bahata nalima. Iale malaha keu Dielusalemae Dilava hoesehavoito halei au kaliotamo hoilahai beloveta Aisaia buka dodavei lohoma. ");
INSERT INTO kpx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ige Munanae Tumuu Bilibi namihai avoe, “Talive kaliota ke vavala tenela.” ");
INSERT INTO kpx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kateige Bilibiu bibuai vavavela tai evisege malaha keu beloveta Aisaia buka ke dodavema. Ige au belahai avoe, “Ana a dodavemale ke ihu hilokanu.” ");
INSERT INTO kpx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ige malaha keu avuho loui avoe, “Dana oleve kateai ke hilokai. Isito ata moleu di haivuhutevage di bae ke hilokai.” Kateaime Bilibi namihage au veatisi kaliotavemo avui ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Malaha keu Aisaia bukamo dodavemale keike ko. “Ata keu mamoe nahate. Ataeabuna melavei tiliege bae hamai. Keu mamoe doga ke nahate. Ataeabuna vomove bohige au bae kekoalivebene. Iale abu mamoemo vale ke nahate abuna ata ke hamage au bae hotobe loulivebene. ");
INSERT INTO kpx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ataeabuna aiohavoi mai kotalahai vaveveve toela elehaholisi hamage au hatige valadavebeu bae uge ataeau bae hilokalivebene.” ");
INSERT INTO kpx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Isi kateige kosive nehe keu Bilibi belahai avoe, “Di namihanela. Beloveta kou ata oleike au huhuai ko hisalianu. Auna au ebikanike au ke huhuaime. Emena ata moleike.” ");
INSERT INTO kpx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ige Bilibiu Bukae Hoto kemo Iesu hotoe dua loui haivunu. ");
INSERT INTO kpx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Isi avuti tiale e mole vavamo velehovoge kosive keu Bilibi namihai avoe, “E ko elehanela. Dana valive e komo babatisoai.” ");
INSERT INTO kpx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ige Bilibiu namihai avoe, “Ana a uvu bahata mai Iesuemo mamoniege bae babatisoanela.” Ige malaha keu loui avoe, “Duave. Di hilokage Iesu Keliso keu Dilava mo.” ");
INSERT INTO kpx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Isi kateai au kaliota ke mamoge Bilibiu avuti dobuluvisi e keve tiale kosive ke babatisohavonu. ");
INSERT INTO kpx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kateaito e kemo hoidevei lohosege Dilava Munanae Tumuu Bilibi mage uoholinu. Ige kosive keu Bilibi kaovai elehaholisi vahaehota tinu. ");
INSERT INTO kpx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Isito Bilibiu solekavesite o mole Asodasi keve velemai halei tiale o kebia bahatala hotoe dua loui ata haivei tiale Sesalia o ketala velemanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Malaha mole Solo keu vani bahata Iesu esemu kebia bahata aiogevei haveveve hoto loui lohoale dubue kosive baluga namihanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Namihai avoe, “Levaleva hisaliai mai daoge di Damasikasie talive Diue dubue kosive ovei elike ata olemeau Iesu ehovamale kebia kaovei umudievei malevei loholive Dielusalemae dibulamo otovei.” ");
INSERT INTO kpx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kateaito halei Damasikasie tiale keu oe vavae tisege ataga mole balugau otogomo lohoale bamunu. ");
INSERT INTO kpx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ige au lokilahai vatamo dobai hoto mole evige hoto keu loui avoe, “Solo, Solo, a osiohoike di aiohavoma.” ");
INSERT INTO kpx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ige Solou loui avoe, “Kosive, ole a.” Ige hoto keu avoe, “Iesu dalike a vani bahata aiohavoma. ");
INSERT INTO kpx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Iale hovelahai o baluga keve talive ata moleu bae a gabie onole vaveve ke ahoe loui.” ");
INSERT INTO kpx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kateai lousege malaha degomoleau Sololuvuta tiale keau lavisi tetelahalu. Kosealemo keau hoto ke evisito atabe elehaholilu. ");
INSERT INTO kpx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ige Solou vatamo hovelahage niveu keduige haokuvuiabeau adavela holisi melavei Damasikasie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ige vanie ni abuita igaeta ke uvumo au lovi ioholisito u unahanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Vani kateimalela Iesu esemu mole Ananaiasi keu o keve usege vani molemo Kosiveu lahoahoamo hohavoi avoe, “Ananaiasi.” Ige au loui avoe, “Ito, Kosive, di a ho evinu.” ");
INSERT INTO kpx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ige Dilavau namihai avoe, “Talive humaha mole ivi Inutolotolote keve Diudasi omo Tasisi malaha mole Solo kaovanela. Keu aike guliguliai di imihama. ");
INSERT INTO kpx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Malaha keu subuta lahoahoasege malaha mole Ananaiasiu lohoale au ada mai nivemo mamoge niveu duaveanu. Iale talive di lahoahoamo a haivuale ke nahate vanela.” ");
INSERT INTO kpx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Isito Ananaiasiu Dilava namihai avoe, “Kosive, ata moagaeau malaha ke vaveve loui di namihai avoe, ‘Malaha keu Dielusalemae Iesu esemu moaga aiogevenu.’ ");
INSERT INTO kpx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Isi keu Dielusalemae dubue kosive kebia namigevege abu vuvune omige au aike lohoale isiviai no umudigevei no malevei tai.” ");
INSERT INTO kpx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ige Dilavau avuho loui avoe, “Halege talive di a namihale ke nahate vanela. Kosealemo di Solo ebagemage auna tiniege di hoto evioholimale kebia, vatae kosive kebia isime Iselala ata kebia bahata auna haivei. ");
INSERT INTO kpx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iale dana ke haivuge auna bae di lovi ke vai vatehani maleveve ke hilokai.” ");
INSERT INTO kpx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dilavau kateale louge Ananaiasiu tiale o keve velemai au ada mai Solo tatamo mamoi loui avoe, “Di haoka, Kosiveu humaha tavae aemo velemale keike louge di kove ae lohonu. Au di hanavoale kemo ana tota nianela. Ige Munanae Tumuna bae aemo ui a negotisi.” ");
INSERT INTO kpx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kateai lousege solekavesite huenae gina ke nahateau Solo nimo keiohovoge niveu keduale keu uoholige au hovelahai babatisoanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Babatisoaito lovi ige vavaveu tota negoanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Solou keve uniale Diue dubue tiale Iesu hoto loui ata haivei avoe, “Iesu keu Dilava mo.” ");
INSERT INTO kpx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ige ata bahataeau ke evisi vikolahai mole namigevei avoe, “Ani, malaha konike Dielusalemae Iesu esemu aiogevei isiviale malevei Diue kosive baluga ovei. Iale malaha kenike ko.” ");
INSERT INTO kpx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Abu kateai louge Solou hovelahai ata haivege hotove keu ataemo vuvuneage Damasikasi Diue ataeau hotove hamaveve keu anekianu. Kosealemo Solou hilokage Iesu keu Diue ata tedaevemale kosive Keliso. ");
INSERT INTO kpx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Vani moagaeau uoholige Diue ataeau mole bevuevei Solo hamaveve humaha kaovama. ");
INSERT INTO kpx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Keau vanimo vavimo o ke balugae udahamo nilahai ui isiviale Solo mai hamai. Isito Solou vaveveabe ke hilokanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iniale vavi molemo Solo haokuvuiau bosea balugamo Solo mai mavoime o ke baluga iae vuindoamo manevege dobai detitinu. ");
INSERT INTO kpx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Detitisi tialeu Dielusalemae velemai isiviale Iesu esemuhi igaetoai ui. Isito keau vabulahai huhuai avoe, “Ata kou no lobogeveike au ko vama. Keu Iesu esemu seleve holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kateige Banabasiu Solo melamei tiale Iesu esemu kebia haivei namigevei avoe, “Malaha kou humaha tavae Kosive elehage au avuho louge au Damasikasie vabuoholisito Iesu hoto loui ata haivenu.” ");
INSERT INTO kpx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabasiu kateai haivege Solou bae abuhi ui timale Dielusalemae Iesu hoto loui vuvunevemo vabuoholisito ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kebia haivesege Diue ata degomoleau Giliki hotomo loumale keau isiviale Solo hamai. ");
INSERT INTO kpx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ige Iesu esemuiau ke evisime Solo melavei tiale Sesaliae velehovoi mai hanavoge au au o seleve Tasisie tinu. ");
INSERT INTO kpx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Isi kateige Diudia, Galili isi Samalia vata kebiamo ekalesia bahata keau bae ue dua vai Kosive hoesehavoge Munanave Tumuu negotievege abu ata moaga holisi ua. ");
INSERT INTO kpx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bitau matama moagae oai tiale vani mole o mole Lida keve Dilava ata elegeveliho lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Keve lohoale malaha mole Aniasi ke elehanu. Malaha ke vavau kibioholige au vagana eiti (8) ke uvumo gedae golo unahamo lahai uma. ");
INSERT INTO kpx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ige Bitau lohoale elehai avuho loui avoe, “Iesu Kelisou a hoesehavoalelua hovelahai a geda mai egumai laminela.” Isi kateige malaha keu solekavesite hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ige Lida ata isi Saloni ata keau bahata malaha ke elehai hoidevei Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kateisege o mole Dioba keve evievi keate mole Tabita ivive mole Dokasi keu vani bahata vaveve dua vai kunaiholimale kebia tedaevei kunai ovema. ");
INSERT INTO kpx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Iale keate keu vavahaniai hatige abu emohavoi ebavoi mai o ke ehue uvu moleve tilu. ");
INSERT INTO kpx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Isi Bitau Lida oe uale hoto ke evisi abu esemu abuita iovege abu avuho louho tilu. Dioba keu Lidati haeava holioholilu. Ialelua abu tiale Bita namihai isiviale au abuhi hoilahai. ");
INSERT INTO kpx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ige Bitau hovelahai abuhi tiale velemage abu melavei o ke uvue tilu. Ige gobuvuiau ninalahai vavavemo lavisi keate keu nita ui ogo vamale ke malei Bita haivulu. ");
INSERT INTO kpx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ige Bitau oe uvue gobuvu kebia iovege abu heie tisege au kome bokoai Dilava imihaito hovelahai keate ke namihai avoe, “Tabita, hovelahanela.” Ige keate keu niai Bita elehai hovelahai ugulamonu. ");
INSERT INTO kpx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ige au adavela holisi ebagemage au hovelahai laminu. Isi gobuvu nehe kebia hohavege abu lohoge au keate neheu hovelahale ke mai haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kateige Dioba ata keau bahata hoto ke evige kebiamo moagaeau Kosive hoto evisi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ige Bitau vani moaga Dioba oe Saimoni mole omo ua. Malaha keu bolomakau vatemo onobenobe vaevemale malaha. ");
INSERT INTO kpx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesalia o kemo malaha mole Lomae ame kosive baluga Koniliasi keu ua. Keu Italiae ame esemu kebia nalievema. ");
INSERT INTO kpx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Keu au ese bahata kebia holoevei abuhi Dilava vabuhavoi hoesehavoma. Keu negoai Diue ataeau kunaiholimale kebia tedaevei vani bahata guliguliai Dilava imihama. ");
INSERT INTO kpx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iale keu gutu mole tili (3) okolokie lahoahoai elehasege Dilava anelu moleu avue lohoale avuho loui avoe, “Koniliasi.” ");
INSERT INTO kpx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ige Koniliasiu ke evisi vabuai namihai avoe, “Kosive, a onoleho isivianu.” Ige anelu keu namihai avoe, “Dilavau a guliguli evisi a vaveve dua hilokai a huhu seleveanu. ");
INSERT INTO kpx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Iale ana a esemu degomole hanavege abu talive Diobae malaha mole ivi Saimoni Bita namihage au lohoi. ");
INSERT INTO kpx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Bita keu Saimoni mole bolomakau vatemo onobenobe vamale ata keti davala vavae ovemo avuti ua.” ");
INSERT INTO kpx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kateai louito halei tisege Koniliasiu au esemu abui ovemo lovilahamale kebia hohavei au ame esemu mole Dilava hoesehavomale ata keta hohavonu. ");
INSERT INTO kpx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hohavege abu lohoge au deiada ke loui namigevei hanavege abu Diobae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ladeveliale vani mole tiliale Dioba oe vavae tisege Bitau vanie vigomo guliguliho oe hovadae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Keve tiniale guliguliaito vaeai isiviai lovi isi. Kateige abu lovi vasege au lahoahoa mole vanu. ");
INSERT INTO kpx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lahoahoa kemo elehasege otogou dikolahage ogo mole baluga omokutialeu dobai lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ogo ke uvumo mesia nimolete moaga kosealeau ua. Ovo, mi, ute, ugu isi degomolea. ");
INSERT INTO kpx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ige hoto moleu avuho loui avoe, “Bita, hovelahai ke havei inela.” ");
INSERT INTO kpx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ige Bitau loui avoe, “Kosive, di bae mesiae toela kebia havei ilivebene. Subuta no menakau kateale louge di kemo menakanu.” ");
INSERT INTO kpx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kateai louge hoto keu tota avuho loui avoe, “Dilavau onobenobe vae dua vale keho ainaho bae loui kosea, ‘Keu toelanu.’” ");
INSERT INTO kpx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Vaveve katealeu velema abuita igaetageto ogo keu veatisi tota otogoe tinu. ");
INSERT INTO kpx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ige Bitau lahoahoale ke huhuai isivialeike ke ihu hilokai. Kateai huhuisege Koniliasi esemuiau Saimoni o kaovai lohoale heie lavisi ua. ");
INSERT INTO kpx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Isi holahai avoe, “Malaha mole ivi Saimoni Bita kena kove ua.” ");
INSERT INTO kpx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Holahasege Bitau negobedai isiviale au lahoahoale ke ihu hilokai. Kateisege Munanae Tumuu avuho loui avoe, “Evinela. Malaha abuita igaetaeau lohoale ahoe nilahai a kaovama. ");
INSERT INTO kpx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Iale hovelahai heie dobai abuhi tenela. Dalike kebia hanaveale ainaho abuhi taliho vabualive.” ");
INSERT INTO kpx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kateai louge Bitau dobai tiale malaha kebia namigevei avoe, “Lana dahonike nilahama. Dalike ko. Iale osiohoike la di kaovama.” ");
INSERT INTO kpx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ige abu loui avoe, “Ame kosive mole Koniliasi keike no hanavenu. No kosive keu atae dua. Keu Dilava hoesehavoge Diue ataeau bahata avuho isivilahalu. Iale Dilavau nivu anelu mole hanavoge tiale no kosive ke namihage no kosive keu kemoike no hanavege no aho loholu. Keu isiviale a talive hoto louge au a hoto evisi.” ");
INSERT INTO kpx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ige Bitau malaha kebia namigevege abu avuluvuta vavi igaemo uliale vavita hovelahai esemu kebiahi tisege Dioba o kemo Diue evievi ata degomoleau bae abuhi tilu. ");
INSERT INTO kpx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tiliale humaha tavae ladeveliale vavita Sesaliae velehovoge Koniliasiu au eseta au haokuvuta holoevei abuhi hemei usege Bitau velemanu. ");
INSERT INTO kpx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Velemaime Koniliasi oe udahamo velemasege Koniliasiu vudivemo kome bokoai vata bisi isiviale hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ige Bitau namihai avoe, “Hovelahai laminela. Dau Dilava holioholisito ata unaha dalike.” ");
INSERT INTO kpx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kateai louge Koniliasiu hovelahai avuti hotohotoaniale uoholige abu oe uvue ata moagaeau igaetoai umale keve tilu. ");
INSERT INTO kpx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tige Bitau namigevei avoe, “La hilokage dau Diue ata. Iale no menaka keu koseanu. Diue ata keau bae Diue ata holioholiale kebiahi igaetoalivebene. Isito Dilavau di haivuale keu koseanu. Ata bahata nahiau mole nahate unaha. Iale dau bae Diue ata holioholiale kebiaho huhu kosealealivebene. Keau atae toela. ");
INSERT INTO kpx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iale la daho hoto hanavoge di dolodoloholisito lohoale isiviai la daho hoto hanavoale ke hilokai.” ");
INSERT INTO kpx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kateige Koniliasiu Bita namihai avoe, “Di vavitege gutumo tili (3) okolokie di oe uvue guliguliasege malaha mole ogo taete seleve holovale keu lohoale di vudimo laminu. ");
INSERT INTO kpx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Isi loui avoe, ‘Koniliasi, Dilavau a guliguli ke evisi a lovie dua vamale kemo a huhuanu. ");
INSERT INTO kpx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Iale ata degomole hanavege abu talive Diobae malaha mole ivi Saimoni Bita ke namihai. Malaha keu Saimoni mole ovoe vatemo onobenobe vaevemale ke oe ua. Malaha ke ou davalae vavamo ua.’ ");
INSERT INTO kpx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aneluu kateai louge di solekavesite aho di esemu hanavege a lohoale keu duave. Iale noeabulike ko bahata a hemei uma. No isiviale Dilavau onole a namihale ke loui no namigevenela.” ");
INSERT INTO kpx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ige Bitau ata kebia namigevei avoe, “Di nova hiloka seleveage Dilavau huhuige ata bahata keau mole nahate unaha. ");
INSERT INTO kpx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Vatae ata oleuoleu Dilava vabuhavoi vaveve inutolotolote vage auna kebia malevei. ");
INSERT INTO kpx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","La hilokage Dilavau au hotoe dua Diue ata noheho hanavonu. Hotoe dua keu Iesu Kelisou ata malevege abu Dilavaluvuta uveve dua malege au ata bahatae Kosive holinu. ");
INSERT INTO kpx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","La hilokage ata babatisogevemale Dioni keu vasohuta hotoe dua loui Galili ata haivegeto kemo hoto keu Diudia vata bahatae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","La hilokage Iesu keu Nasaletae malaha. Ige Dilavau Munanae Tumu omisi vuvuneta omiale kemo au o bahatae tiale vaveve dua vai ata hoesegevei munanae toela abuemo nunuvema. Kosealemo Dilavau avuti ualemoike. ");
INSERT INTO kpx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iale Iesu keu Diudia vata isi Dielusalema o baluga kemo vaveve bahata vamale ke noeau elehai hilokalu. No hilokage abu mai idie domo hamage hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ige vanie ni abuita igaetaeau uoholige Dilavau etuvage hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hovelahaime ata bahatae tioholisito Dilavau no unaha tabageveale kebiae tiale nohehi lovi isi e inu. ");
INSERT INTO kpx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Isi no namigevege no tiale ata bahata haivei hotoe dua loui namigevei kosea, ‘Dilavau Iesu ebagemale auna bae ataeau haluvisi nita umale kebia bahatae vaveve kaovai loui.’ ");
INSERT INTO kpx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iale subuta beloveta bahata keau Iesu vaveve kemo loui avoe, ‘Oleuoleu abu uvu mai omige auna au ivimo vaveveabe toela ulihai.’” ");
INSERT INTO kpx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bitau kateai namigevesege Munanae Tumuu dobai lohoale hotove evimale kebiamo ua. ");
INSERT INTO kpx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ige Diue evievi ataeau Bitaluvuta Diobamo lohoale keau Dilavau au Munanae Tumu mai Diue ata holioholiale kebia oveale ke elehai vikolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Keau vikolahale keu koseanu. Abu evisege ata keau hoto nimoletemo hoto loui Dilava hoesehavoma. ");
INSERT INTO kpx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ige Bitau Diue evievi ata namigevei avoe, “Ata koeau nahi Munanae Tumu maleale ke nahate abuta malelu. Iale nahi bae keau babatisoaveve kemo keluevelivebene.” ");
INSERT INTO kpx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Isi namigevege abu Iesu Keliso ke ivimo babatisolahalu. Isi Bita namihai avoe, “No isiviale vani degomole nohehi unela.” ");
INSERT INTO kpx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iesu abostolo isi esemuiabe bahataeau Diudiae uale keau evige Diue ata holioholiale keau Dilava hoto evisi malu. ");
INSERT INTO kpx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iniale vani mole Bitau veatisi Dielusalemae lohoge esemu degomoleau itumulahai avuho loulu. Kosealemo abu isiviale Diue ata holioholiale keau abu vudie vate bohisito bae Dilava ehovai. ");
INSERT INTO kpx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Esemu keau Bita namihai avoe, “A vudie vate bohioholimale kebiahi igaetoai lovi iale keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kateai louge Bitau ono vadeu avuemo velemale ke deiada bahata loui namigevenu. ");
INSERT INTO kpx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Namigevei avoe, “Di vani mole Diobae guligulianata lahoahoa mole mai elehasege otogomo ogo mole baluga omokutiale keu dobai lohoale di tatamo ua. ");
INSERT INTO kpx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ige di ke uvumo niai elehage ovo, botoe mi, ute isi botoe ugu keau ke uvumo ua. ");
INSERT INTO kpx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ige di evisege hoto moleu lohoale loui avoe, ‘Hovelahai ke havei inela.’ ");
INSERT INTO kpx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ige di loui kosea, ‘Kosive, kateai lou halenela. Subuta mesiae toela katealebiamo no menakau louale di bae ke ilivebene.’ ");
INSERT INTO kpx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ige hoto keu tota otogomo lohoale loui avoe, ‘Dilavau onobenobe vae dua vale keho ainaho bae loui kosea, Keu toelanu.’ ");
INSERT INTO kpx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Vaveve katealeu velema abuita igaetageto ogo keu veatisi tota otogoe tinu. ");
INSERT INTO kpx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kateisege di umale o keve Sesalia malaha abuita igaeta keau di melaveliho loholu. ");
INSERT INTO kpx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ige Munanae Tumuu di namihai avoe, ‘Dolodolo haleito abuhi tenela.’ Ige Diobae evievi malaha sigisi (6) keau daluvuta tiale Sesalia oe velehovoi Koniliasi oe tilu. ");
INSERT INTO kpx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tige Koniliasiu no namigevei avoe, ‘Anelu moleu di vavamo lamisi di namihai avoe, A esemu hanavege abu talive malaha mole ivi Saimoni Bita melavei lohoi. ");
INSERT INTO kpx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Loholive au la haivege a isi a omo umale lana hoto kemo ukolikoli maleve.’ ");
INSERT INTO kpx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kateai louge di lohoale kebia haivesege Munanae Tumuu subuta nahiemo lohoale ke nahateu abuemo lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ige Iesuu louale ke di huhuanu. Au avoe, ‘Dioniu e unahamo la babatisogevenu. Isito Munana Tumutena lohoi au vuvunemo la malevei vuvunetievei.’ ");
INSERT INTO kpx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iale di hilokage keau abu uvu mai Iesu omige Dilavau au Munanae Tumu nahioveale ke nahate kebia ovenu. Iale Dilavau vaveve kateale vasege di bae osioho ke bamui.” ");
INSERT INTO kpx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bitau kateai louge Dielusalemae evievi ata keau ke evisi vahaeholahai Dilava hoesehavoi loui avoe, “No hilokage Dilavau vaveve kateale vage Diue ata holioholiale keabuna abu vaveve toela kemo hoidevege Dilavana ukolikoli ovei.” ");
INSERT INTO kpx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Abu Sitiveni hamamale vani kela abu evievi ata degomole aiogevege keau detuluvisi o igaegae keve tilu. Degomoleau Venisiae tisege degomoleau Saibalasie tisege degomoleau Antiokae tilu. Keve tiale hotoe dua loui Diue ata unaha haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kateisege Saibalasi isi Sailinie evievi malaha degomoleau detuluvisi Antiokae tiale Diue ata holioholiale kebia Iesu hotoe dua loui namigevelu. ");
INSERT INTO kpx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kateimale vanila Kosive vuvuneu abuhi uge ata moagaeau hotoeabe evisi Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Keau Iesu ehovale ke Dielusalemae ekalesiaeau ke evisi Banabasi hanavoge Antiokae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tiale keve velemage Dilavau Diue ata holioholiale kebia huhuevei hoesegevege au ke elehai vahaeho balugai namigevei avoe, “La evievi kemo negolahai la uvu bahata mai Kosivemo mavoi ehovageve.” ");
INSERT INTO kpx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi keu atae dua isi evievie malaha seleve. Au kateige Munanae Tumuu keti uge ata moagamoagaeau Dilava ehovai tilu. ");
INSERT INTO kpx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabasiu kateaito Tasisie Solo kaovaliho tinu. ");
INSERT INTO kpx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tiale kaovai elehaime melamei Antiokae hoilahai lohoale vagana igae ke uvumo ekalesia bahata bevuevei haivei evieviholimale kebiata haivelu. Ige Antioka keve evieviholimale keau vasohuta evievi ata kebiaho loui avoe, “Keliso ehovamale ataea.” ");
INSERT INTO kpx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kateimalela ekalesia beloveta degomoleau Dielusalema halevai Antiokae loholu. ");
INSERT INTO kpx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ige kebiamo beloveta mole Agabasi keu hovelahai Munanae Tumue vuvunemo ata namigevei avoe, “Gabie vae balugana bae vata bahatamo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kateai louge evievi ataeau ke huhulahai isiviale haokuvuiabeau Diudiae umale kebia tedaevei. Isi oleuoleu abuemo moniu uge malei abu haokuvuho hanavei. ");
INSERT INTO kpx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Isime kateai moni malei Banabasita Solota ovege abu malei Diudiae tiale ekalesiae kosive ovelu. Iniale Kalodiasiu Loma gamanie kosive baluga holimale vani kemo vae balugau lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Vani kateimalela vatae kosive baluga Elodi keu ekalesia degomole aiogevenu. ");
INSERT INTO kpx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Isi louge esemuve moleu sigata Dioni nana Diemisi bige hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Elodiu vaveve kateale vage Diue kosiveau ke elehai vahaehoage au tota au esemu namigevege abu Bita umuvai mai loholu. Diue vahaeho vani baluga Basova ke vanilaike abu ke valu. ");
INSERT INTO kpx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kateai Bita mai lohoaleu dibulae bamuge tuvalie ata voa (4) keau Bita nalisi ua. Iliale Basova vaveve keu uoholige Elodiu isiviale Bita mai atae vudimo mamoi kotai. ");
INSERT INTO kpx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kateisege Bitau dibulae usege ekalesia bahataeau negobedai avuho guligulilahama. ");
INSERT INTO kpx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bitau dibulae uniale vavita Elodiu isiviale melamei loholive atae vudimo kotai. Isito vavi kemo vaveve nimoleteu Bitaemo velemanu. Tuvalie ata abuiau seimi abuitala adave umuvai mai abu vigomo mavoge au vigoeabemo lahasege tuvalie ata abuiau udahamo lavilu. ");
INSERT INTO kpx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ige solekavesite Kosive aneluu lohoale o ke uvumo lamige atagaveu oe uvumo halunu. Ige anelu keu Bita hadala holisi etuvai avoe, “Solekai hovelahanela.” Kateai lousege solekavesite seimi abuita keau Bita adamo solahai dobuluvilu. ");
INSERT INTO kpx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ige anelu keu tota Bita namihai avoe, “A beleta mai egigivai a veloe vateta hatu.” Ige Bitau hotove evisi vage au avuho loui avoe, “A dabae ogo mai hatui daiti lohonela.” ");
INSERT INTO kpx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ige Bitau anelu ke ehomai oe ese halei tinu. Bitau vaveve ke vaito kemo luleleholisi huhuai avoe, “Selevenike di ko vama. Emena di tababuima.” ");
INSERT INTO kpx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Isi avui lohoale tuvalie ata abuiau lavimale kebia evigevei loholu. Lohoale keau tota tuvalie ata abuitaeau lavimale kebia evigevei lohoaleau udaha baluga abu aulita vale kemo lohoge udaha ke biageu alavoge abu velehovoi heie humahala tisege anelu keu uoholinu. ");
INSERT INTO kpx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ige Bitau onoleu avuemo velemale kemo bae huhuai avoe, “Di nova huhuige keu seleve. Dilavau au anelu hanavoge lohoale di tedahoge Elodi vuvune keu daemo negoholinu. Katealemo gabie Diue ataeau bae vaveve toela daemo valivebene.” ");
INSERT INTO kpx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kateaito halei Dioni Maka neina Meli ke oe tinu. Tiale heie usege ata moagaeau keve mole bevuevei oe uvue guligulilahama. ");
INSERT INTO kpx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Guligulilahasege Bitau lohoale udaha hamage kemo loviamale ma mole Loda keu lohoale Bita hoto valitinu. ");
INSERT INTO kpx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hotove valitisi vahaeho balugai udaha alavoholisito hoilahai tiale ata bahata namigevei avoe, “Evive. Bitau lohoale heie ua.” ");
INSERT INTO kpx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ige abu namihai avoe, “Ana tilogoanu.” Ige ma keu baita namigevei avoe, “Seleveta Bitau lohonu.” Ige abu avoe, “Ba, munanaveike ke.” ");
INSERT INTO kpx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kateai lousege Bitau negobedai udaha hamalage abu lohoale udaha alavoi elehai vikolahai vahaeho balugalu. ");
INSERT INTO kpx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ige Bitau adata namigevege abu hotohotoholisi tobekai usege au Kosiveu dibulamo hanavoale deiada ke loui ata kebia haivei namigevei avoe, “Talive Diemisita esemu degomole kebiata namigeveve.” Kateai loui namigeveito halei o moleve tinu. ");
INSERT INTO kpx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Iniale vau alamoge tuvalie ata neheau dibulamo lavimale keau hovedevei elehage Bitau uoholige abu dolodololahai mole belagevei avoe, “Bitau oleve kateanu.” ");
INSERT INTO kpx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ige Elodiu louge abu Bita kaovalata elehaholige Elodiu tuvalie ata kebia malevei abuemo kotanu. Kotage uoholige au au esemu namigevege abu tuvalie ata havege haluvilu. Ke iae Elodiu Diudia vata halei tiale Sesalia o keve ua. ");
INSERT INTO kpx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Vani mole Taea isi Saidoni ata keau vaveve mole vage Elodiu abuho itumu baluganu. Ige abu mole bevuevei Elodi elehaliho tilialeau vasohuta Elodi esemu mole Balasita ke sovavihalu. Malaha keu Elodi omo ata baluga. Iale abu sovavihai namihai avoe, “No isivialeike a no tedaevege no Elodiluvuta itumu halevaito ue dua vai. Kosealemo noeau Elodi vatamo lovi malemalemo no isivialeike avuluvuta ue dua vai.” ");
INSERT INTO kpx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kateai louge au abuho vani mole ebagemale kemo Elodiu au ogoe dua vai au ebika ebagemai au telonamo ugulamoi hoto lounu. ");
INSERT INTO kpx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ige abu ke evisi baita holahai avoe, “Dilavaike ke. Keu ata holioholinu.” ");
INSERT INTO kpx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kateai lousege solekavesite Kosive aneluu Elodi hamage vavahanianu. Vavahanive keu koseanu. Utee ese moagaeau uvuvemo ui uvuve ige au vavahanianata hatinu. Kosealemo keu atae hoto evisi ke huhuaito Dilava hoesehavoholinu. ");
INSERT INTO kpx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kateisege Dilava hotou ata bahata sonumaevenu. ");
INSERT INTO kpx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Isege Solou Banabasiti moni malei Dielusalemae tiale ekalesiae kosive oveito halevai Dioni Maka melavei tota hoidevei Antiokae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka ekalesia ata kebiamo kosive degomoleau ua. Degomoleau beloveta ataea. Isege degomoleau ata haivemale ataea. Iale kosive kebia iviabulike koea. Mole ivilike Banabasi. Ige malaha bukate Simioni. Ige Sailini malaha mole Lusiasi. Ige subuta Elodi omo umale ata mole Maniani. Ige Solo. ");
INSERT INTO kpx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kosive keau vani mole lovi ioholisito Kosive hoesehavosege Munanae Tumuu abuho loui avoe, “Di isiviale Banabasita Solota tabagevege abu talive di abuho lovi mole louale ke abu avuti vai.” ");
INSERT INTO kpx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kateai louge abu tota lovi halevai ioholisi Dilava imihai abu ada malei Solota Banabasita tatamo otoveito hanavege abu tilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Munanae Tumuu Solome Banabasime malevei negotievege abu Selusia oe tiale keve bouti mai davalae nie vata mole Saibalasie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tiliale keve velehovoi o mole Salamasi keve dobuluvisi Diue dubue Dilava hoto loui ata haivesege Dioni Makau abuhi tiale keu kebia tedaevenu. ");
INSERT INTO kpx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Isi abuhi heila tilialeau o igaegae kela ata haivei o mole ivi Babosi keve velehovolu. O kemo Diue malaha mole Baliesu keu au vavevemo ata lobogevei au ebika mai loui avoe, “Dau beloveta.” Malaha ke ivi moleike Elimasi. ");
INSERT INTO kpx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iale keu vata kemo kosive mole Segiasi Bolasi keti haokanu. Kosive keu lulelete ata. Iale keu Banabasita Solota hohavege abu avue loholu. Kosealemo keu isivialeike Dilava hoto evisi. ");
INSERT INTO kpx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Isito Elimasiu Solota Banabasita hoto hamanu. Kosealemo keu isiviholinu kosive keu hoto ke evisi Dilava ehomaliho. ");
INSERT INTO kpx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kateisege Munanae Tumuu Solo mai negotinu. (Kateimale vanila abu Solo ivihai avoe Bolo.) Ige au Elimasi nibi tumuai avuho lounu. ");
INSERT INTO kpx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Loui avoe, “A keu Setene vaveve ke nahate vai vaveve dua bahata aiogevemale ata alike. A uvu kemo onobenobe toelau uge a vani bahata loboe hoto loui Dilava hoto seleve ke bamuma. ");
INSERT INTO kpx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iale Dilavana au adae vuvune mai aemo mamoge ana bae ni kedute holisi vanie ataga ke elehalivebene. A ni kena loaniege vani degomoleau uoholisege tota bae duaveai.” Kateai lousege ono mole bukateu dobai lohoale nive bamuge niveu keduage au ada hatui tai loui avoe, “Loholive di adala holisi di melavei teve.” ");
INSERT INTO kpx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ige vatae kosive keu vaveve ke elehai vikoai au uvu mai Dilava ominu. ");
INSERT INTO kpx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Vani mole Bolou au esemu holoevei abuhi bouti mai Babosi halevai vata mole Babiliae tilu. Vata keve o mole Bega keveike abu tiale velehovosege Dioni Makau halevei hoilahai tota Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Isege Bolou Banabasiti Bega halevai abuta Bisidia vatae tilu. Vata keve tota o mole ivi Antioka keve tiale velehovoi keve uliale bulau lohoge abu tiale Diue dubue uvue uguiavoi ua. ");
INSERT INTO kpx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Uguiavosege Diue kosiveau Mosese menaka ke dodavei belovetaeau hisaliale keta dodavei ata haivege uoholisege abu Bolota Banabasita belagevei avoe, “No haokuvuia, laemo hotobeu uge louge no bahataeau evisi.” ");
INSERT INTO kpx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kateai louge Bolou hovelahai loui avoe, “La degomoleau Diue ata. Isege la degomoleau Diue ata holioholilu. Isito la bahataeau Dilava hoesehavomale di hoto evive. ");
INSERT INTO kpx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Subuta Dilavau nahie buluve kebia tabagevege valadaeabeau Egubitoe moagage Dilavau elegevei au vuvunemo vata kemo malevenu. ");
INSERT INTO kpx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ige abu tiale vagana voti (40) ke uvumo tomagie olahasege Dilavau kebia hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Iniale vani mole Dilavau Keinani vata baluga kemo vata seveni (7) kebiamo ata nunuvege uoholige atave seleve keau vata ke mai avuemo ua. ");
INSERT INTO kpx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Nahie valada keau vagana voa handele vivti (450) ke uvumo Egubitoe ui tomagie uale ke halevai Keinani vatae loholu. Iniale ke iaeike Dilavau bae kebia nalieveveve ata moaga oveniale kebia tedaevelage beloveta Samuelau bae kebia iae lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iniale Samuela vani kemo Iselala ataeau kiniho isivilahage Dilavau Kisi mo Solo ebagemanu. Solo keu Benidiameni valadamo lohoniale vagana voti (40) ke uvumo Iselala ata kebia bevuevei nibievenu. ");
INSERT INTO kpx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Iniale vagana degomoleau uoholisege Dilavau Solo halei Deividi ebagemage keu Iselalae kini holinu. Dilavau Deividi huhuai loui avoe, ‘Di ata katealeho isivianu. Di huhuige Diesi mo Deividi kena di onole louale ke vai.’ ");
INSERT INTO kpx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dilavau kateai louito au louale ke nahate vai Deividi valadamo Iesu ebagemage au Iselala ata tedaeveveve kosive holinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Isito Iesuu au lovi vaholisege Dioniu Iselala ata bahata haivei avoe, ‘La vaveve toela halevai babatisolahave.’ ");
INSERT INTO kpx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Iniale vani mole Dioni loviu uoholiho vasege au ata namigevei avoe, ‘La huhuige ole dalike ko. Lana danike hemei uma. Ba, dau ata ke holioholisito ata keu di ehomai lohoma. Keu kosive baluga. Iale di bae velovemo velove voto iamolivebene.’ ");
INSERT INTO kpx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Di haokuvuia, no degomoleau Ebalahamu valadaea. Isege no degomoleau Diue ata holioholisito Dilava hoesehavoma. Isito Dilavau nahie maleveveve hoto ke nahi bahataho lounu. ");
INSERT INTO kpx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Isito ata degomoleau Dielusalemae umale keau abu kosivehi Iesu hilokaito isiviholilu ehovaliho. Isi abu bulamo belovetae hoto dodavemale kemo luleleholilu. Katealemoike abu Iesu hamage vaveveabe keu belovetae hoto mai selevetinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Abu Iesu vaveve toela kaovage avuemo toelabeu uoholinu. Isito abu negolahai isivialeike Bailotiu Iesu mai hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Abu vaveve bahata Bukae Hotou avuemo louale ke nahate vage uoholisege ata degomoleau tiale idie domo mai gulialu. ");
INSERT INTO kpx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Isito Dilavau hatihati kemo etuvage hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hovelahai vani moaga au subuta au abuhi Galili isi Dielusalemae oimale kebiae lohonu. Iale ata keabulike Iselala ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Iale no hotoe dua keike mai la haiveho loholu. ");
INSERT INTO kpx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dilavau Iesu etuvage hovelahage au subuta nahie buluveho louale ke nahateu nova nahiemo velemanu. Deividiu Samusi bukamo hoto ke nahate hisaliai avoe, ‘Dau a Mama seleve. Isege au di mo.’ ");
INSERT INTO kpx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ige Aisaiau au bukamo Dilava hoto hisaliai avoe, ‘Di Deividiho vaveve mole dua loui mamoale ke nahate dana aemo vai.’ Hoto ke ihuu koseanu. Dilavau Iesu etuvage hovelahale au bae tota hatilivebene. ");
INSERT INTO kpx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ige Deividiu tota Samusi bukamo hisaliai avoe, ‘Dilavau bae au esemu tumute ke halege au bae gulimo ulivebene.’ ");
INSERT INTO kpx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nahi hilokage Deividiu Dilava isivimo au esemu kebia tedaevenata hatige abu mai guliage uoholinu. Iale ata tumute keu Deividi holioholinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Isito ata mole igae Dilavau etuvale keu gulimo uoholisito tota hovelahanu. ");
INSERT INTO kpx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Di haokuvuia, Iesu keike la vaveve toela bahata ulihage uoholinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iale lana la uvu mai Iesuemo mavoge auna la vaveve toela la huhulahamale ke ulihai. Kateige Dilavana laheho loui kosea, ‘Laeau di nimo duave.’ Mosese menakau bae laemo kateale valivebene. ");
INSERT INTO kpx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Katealemo huhuihuhuie dua vave. Onoilage belovetaeau subuta louale kou laemo lohoma. ");
INSERT INTO kpx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Beloveta keau Dilava hoto hisaliai avoe, ‘Evive. Ata molena lohoniege di aike laemo vamale ke louge la bae hotove evilivebene. Iale lana di hoto louale ke kabebihavoliege haluvive.’” ");
INSERT INTO kpx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bolou kateai louge uoholisege au Banabasiti halevasege ataeau namigevei avoe, “Gabie bula kemo hoidevei loholive tota hoto degomole loui no haiveve.” ");
INSERT INTO kpx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Keau kateai lougeto Bolou Banabasiti halevai tisege ata degomoleau ehovei tilu. Kebia degomoleau Diue ata seleve. Isege degomoleau Diue ata holioholisito Dilava hoesehavoma. Ige Bolou Banabasiti abuho loui avoe, “Dilavau nahie huhuevei nahie hoesegevemale ke huhulahai la evievimo negolahageve.” ");
INSERT INTO kpx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Iniale bula molemo o ke ataeau bahata lohoale isiviale Bolou Kosive hoto louge abu evisi. ");
INSERT INTO kpx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ige Diue kosiveau ata moagamoaga elegeveime Bolo maina mai isime avuho itumulahai hotove hamai avuho hotoe toela loui aiohavolu. ");
INSERT INTO kpx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kateige Bolou Banabasiti negolahai namigevei avoe, “No isiviale vasohuta Dilava hoto loui Diue ata seleve la haivei. Isito lana hoto ke kabebihavoi ukolikoliho isiviholige noeabuna la halevei Diue ata holioholiale kebia haiveho tai. ");
INSERT INTO kpx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kosiveu hoto ke nahate loui no namigevei avoe, ‘Di la tabagevege laeau atagae ata. Iale talive Diue ata holioholiale kebia haive dua vai ukolikolie hoto mai vatae ata bahata haiveve.’” ");
INSERT INTO kpx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abu hoto kateale louge Diue ata holioholiale keau ke evisi vahaeholahai Kosive hoto keho isivilahalu. Ige ukolikolie hoto keho isivilahale keau evievi ata holilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kateige Kosive hotou vata kemo o bahata sonumaevei tinu. ");
INSERT INTO kpx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Sonumaevei tige Diue ata seleve keau oe kosive isi oe keate ivite lobogevei abuhi Bolome Banabasimeho itumulahai aiogevei nunuvege abu tilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Isi o ke halevai Aikoniomue taliho abu velomo gogea sesiaito halevai tilu. ");
INSERT INTO kpx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Isege Antiokae evievi ataeau Munanae Tumu malealemo vahaeho balugalu. ");
INSERT INTO kpx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Vani mole o kemo Bolou Banabasiti Diue dubue tiale hoto louge hoto keu vuvuneage Diue ata moaga isi Diue ata holioholiale moagaeau hoto ke evisi abu uvu mai Iesuemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ige Diue ataeau hotoe dua evioholiale keau hovedevei Diue ata holioholiale kebia lobogevege keau tota hovedevei hotoe toela loui Bolome Banabasime aiogevelu. ");
INSERT INTO kpx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Isito keau o kemo vani moaga ui Kosive hoto loui Dilavau kebia huhuevei hoesegeveale hoto ke loui haivege ataeau ke evisi hilokage hoto keu Dilava hoto seleve. Kosealemo Dilavau au vuvune abostolo kebia ovege abu vuvunevemo vaveve nimolete vai vikoe vaveve degomoleta vama. ");
INSERT INTO kpx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iale o kemo hoto evimale keau abostoloe hoto evisege hoto evioholimale keau Diue atae hoto evima. ");
INSERT INTO kpx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ige Diue ata holioholiale isi Diue ata seleve kebia degomoleau abu kosivehi isiviale muneta abostolo kebia havei. ");
INSERT INTO kpx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Kateisege Bolou Banabasiti ke evisi detuluvisi Lekonia vata kemo o abuita Lista isi Debi keve velehovoi ata haiveito halevai o degomolemo ata haivei tilu. ");
INSERT INTO kpx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Abu Lista keve usege malaha mole neinaveu mamoge veloveu golohovoale keta o kemo ua. Ige oaveve keu avuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Iale Bolou ata haivesege keu keve ugulamoi hotove ke evima. Ige Bolou ke elehai huhuige malaha keu au uvu mai Dilavamo mamoalemo Dilavana velove ke hoesehavoge au duaveai. ");
INSERT INTO kpx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Bolou kateale huhuaime niavai baita avuho loui avoe, “Hovelahai laminela.” Ige malaha keu solekavesite hovelahai lamisi oanu. ");
INSERT INTO kpx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bolou vaveve kateale vage ata moagataho keau ke elehai abu hotomo baita loui avoe, “Nahie dilavaeabulike ko ata holisi nahie dobuluvisi loholu.” ");
INSERT INTO kpx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Isi abu dilava mole ivita Banabasi ivihai avoe Susi. Isi abu dilava mole ivita Bolo ivihai avoe Hemesi. Abu Bolo ivihale keu koseanu. Bolo keu dilavaeabe nahate hoto loumale ata. ");
INSERT INTO kpx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Abu kateisege dilavaeabe Susi ke dubue kosiveu bolomakau malei valavala malei dubueabeu o ke iae uale ke halei lohoale isiviai ovo havei Bolome Banabasime hoesegevei. ");
INSERT INTO kpx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kateho vasege Bolou Banabasiti ke evisi itumulahai abu ogo dikohai bibuluvisi tiale ata moaga kebia vigoe tilu. ");
INSERT INTO kpx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tiale abuho loui avoe, “La osiohoike katelahama. Noeau ata unaha la nahate. No hotoe duaike loui la haiveho loholu. Isito la keau loboe dilava unaha hoesegevema. Iale no isivialeike ke halevai ukolikolie Dilava seleveu vata vai otogo vai davala vai avuemo onobenobe bahata vaevei otoveale ke hoesehavove. ");
INSERT INTO kpx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Subuta kemo Dilavau ata halevege abu abu isivi unaha vama. ");
INSERT INTO kpx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Isito vani bahata Dilavau laemo vaveve dua vamale ke elehai kemo hilokave. Keu laheho veni hanavoge la lovi hamale keabuna abu bailahamale vanila bailahagei. Ige la lovi ke isi vahaeholahama.” ");
INSERT INTO kpx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kateai lousege ataeau ke evisito negobedai isiviale ovo havei kebia hoesegevei. Isito Bolou Banabasiti isiviholisi vaveve ke bamulu. ");
INSERT INTO kpx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Iniale vani mole Diue ata degomoleau Antioka isi Aikoniomu o baluga kebiamo loholu. Lohoale ata kebia lobogevege abu ke evisi itumulahai muneta Bolo hamai butuhai mai tiale oe iae mihatui huhuai avoe, “Eu hatinu.” ");
INSERT INTO kpx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Isito evievi ataeau lohoale evilikahavoge au hovelahai tota oe tiale vani mole Banabasiti o ke halevai Debie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tiale o keve hotoe dua loui ata haivege ata moagaeau hoto ke evisi Iesu ehovalu. Ige abu tota halevai hoidevei Listae tiale o keve velehovoi uliale vani mole tota hoidevei Aikoniomue tilu. Tiale keve uliale vani mole bae halevai Bisidia vatae tiale Antiokae velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Abu o kebiala ekalesia negotievei namigevei avoe, “La evievi kemo negolahave. Nahiabuna vaveve toela kebia evigeveliege Dilava matamae doga keve tai.” ");
INSERT INTO kpx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kateai loui dubue eloda otovei tilu. Isi vani mole abu lovi ke halevai eloda kebiaho guligulilahai abuho loui avoe, “La la uvu mai Iesuemo mavoale auna la hoesegevei.” ");
INSERT INTO kpx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kateai louito Bisidia vata halevai Babilia vatae velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Isi tiale Bega isi Atalia o kebiala Dilava hoto loui ata haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Isi Atalia o kemo bouti mai abu o seleve Antioka keve velehovolu. O kemoike ekalesiau subuta abuho guliguliai avoe, “Dilavau lovi kemo la hoesegevei la tedaevege lovive ke vave.” Ige abu Kosive lovi ke vage uoholige abu tota halevai abu o keve hoidevelu. ");
INSERT INTO kpx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hoidevei lohoale ekalesia bahata namigevege abu igaetoasege Bolou Banabasiti Dilavau abuhi usege abu lovilahamale deiada ke loui ata haivei avoe, “Dilavau humahada alavoge Diue ata holioholiale keau aike Dilava hoto evisi evievi ata holilu.” ");
INSERT INTO kpx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kateaito vani moaga bae ekalesia kebiahi ua. ");
INSERT INTO kpx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abu abuhi usege Diudia malaha degomoleau Antiokae lohoale evievi ata namigevei avoe, “Mosese menakau louale ke nahate la vudie vate bohisi bae ukolikoli mave.” ");
INSERT INTO kpx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kateai louge Bolou Banabasiti abuhi moleho loui itumulahage ekalesiau Bolome Banabasime namigevei avoe, “Evievi ata degomole holoevei abuhi talive Dielusalemae velehovoi dubue kosive isi abostolo kebiamo hoto ke ihu kaovave.” ");
INSERT INTO kpx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kateai kebia hanavege abu halevai tiale Venisia vatae velehovoi tiale Samalia vatae velehovolu. Vata abui kebiamo o moagaeau ua. Iale o igaegaemo abu evievi ata haivei avoe, “Diue ata holioholiale keau Iesu hoto evisi ehovama.” Ige abu ke evisi vahaeholahalu. ");
INSERT INTO kpx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ige abu Dielusalemae velehovoge abostoloea, dubue kosivea isi ekalesia ataeau vahaehoabe valu. Ige Bolou Banabasiti Kosive lovi vasege au tedaevemale deiada ke loui ekalesia kebia bahata haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ige Balisia ata degomoleau evievi ata holiale keau hovedevei avoe, “No isiviale Diue ata holioholiale keau abu vudie vate bohisi Mosese menaka ehovai.” ");
INSERT INTO kpx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kateai louge abostolo isi dubue kosive keau mole bevuevei isiviale hoto ke kaovai. ");
INSERT INTO kpx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Abu hotohoto ke vai butuhage Bitau hovelahai loui avoe, “Di haokuvuia, la hilokage Dilavau vani mole di ebagemage di tiale Diue ata holioholiale kebia haivege abu Dilava hoto evisi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ige atae uvu hilokamale Dilava keu Diue ata holioholiale keau Dilava nimo duaveage au au Munanae Tumu nahie oveale ke nahate ovenu. ");
INSERT INTO kpx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Diue ata isi Diue ata holioholiale keau Dilava nimo mole nahate unaha. Diue ata holioholiale keau abu uvu mai Dilavaemo mavoge au vaveveabe toela ulihanu. ");
INSERT INTO kpx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Iale osialemoike la isiviale Dilava vaveve kaovai evievi ata kebiamo Moseseu subuta louale ke louge abu vai. Subuta nahie buluveau menaka isute ke ehovaveve keu abuemo anekianu. Ige nahita ke ehovaveve keu nahiemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Isito nahie Kosive Iesuu nahie huhuevei nahi tedaeveale kemo nahiabuna nahie uvu mai avuemo mavoliege ukolikoli malei. Isi Diue ata holioholiale kebiata auna ovei.” ");
INSERT INTO kpx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bitau kateai louge ata bahataeau ke evisi tobekai usege Bolou Banabasiti abu lovilahasege Dilavau tedaevesege abu vikoe vaveve ataemo vamale ke loui haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Abu hoto ke loui gabiasege Diemisiu avuta hovelahai loui avoe, “Di haokuvuia, di hoto evive. ");
INSERT INTO kpx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimoni Bitau la haiveale keu koseanu. Dilavau aike Diue ata holioholiale kebia huhuevei isivialeike kebiamo ata degomole malevege abu atave holisi. ");
INSERT INTO kpx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iale subuta belovetau louale keu nova seleve holinu. ");
INSERT INTO kpx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Au avoe, ‘Kosiveu loui avoe, Gabie vani molena lohoge dana Deividi valadau o nahate koilahale ke ebagemai houge auna tota duave holisi. ");
INSERT INTO kpx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ige elike ata bahataeabuna di kaovage dana Diue ata holioholiale kebia hohavege abuna di ata seleve holisi. ");
INSERT INTO kpx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kosiveu subuta hoto ke hilokaike vaime lounu.’ ");
INSERT INTO kpx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Katealemo di huhuige nahi Diue ata holioholiale kebiamo menaka moaga lou halevai. Keau isiviale Dilava ehovai. ");
INSERT INTO kpx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Iale nahi aiogeve halevaito vaveve koseale vai. Nahi levaleva abuho hisaliai loui kosea, ‘Lainaho bae abu mesia havei loboe dilava hoesegevemale ke igelive. Isi lainaho mole keatehi ladevegelive. Isi lainaho mesia tahoveu lotioholimale ke igelive. Isi lainaho tahove igelive.’ Nahi hoto ke unaha hisaliai abuho hanavoi. ");
INSERT INTO kpx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kosealemo vagana moaga ke uvumo bula igaegae kemo abu Diue dubue Mosese menaka ke dodavelata o bahata haivei tilu.” ");
INSERT INTO kpx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Diemisiu kateai louge abostoloeau, dubue kosiveau ekalesia atahi hotohotolahai ata abuita tabagevei isiviale abu Bolota Banabasita holoevei abu Antiokae ekalesiaho hisaliale keta mai tai. Iale malaha mole ivilike Diudasi. Ivive moleike Basabasi. Isege mole ivilike Sailasi. ");
INSERT INTO kpx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Abu levaleva ke hisaliai avoe, “No haokuvuia, Diue ata holioholialeau Antiokae umale, Silia vatae umale isi Silisia vatae umalebia lahehoike no ko hisaliai hanavolu. Abostoloea, dubue kosivea isi ekalesia ata Dielusalemae umale noeabulike laheho no hoto ko hisaliai hanavolu. ");
INSERT INTO kpx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","No evige no esemu degomoleau keve tiale hoto mole louge la uvuu kemo kibikibianu. Abu vaveve kateale vale ke no hilokaholisi kebia hanaveholilu. ");
INSERT INTO kpx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ilike no vaime mole bevuevei hotohotolahai esemu abui kobia tabagevei hanavege abu no haokuvu Banabasita Bolota holoevei abuhi lae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abostolo abui keau nahie Kosive Iesu Keliso ke lovi valage ataeau isiviale havege abu haluvisi. ");
INSERT INTO kpx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","No Diudasita Sailasita laheho hanaveale kebia lana belagevege abuna no louale ke laheho loui. ");
INSERT INTO kpx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Munanae Tumuu noheho louike vage no laheho loui isiviholiale la no menaka moaga ehovei kemo isulahaliho. Isito no louale ko unaha ehovave. ");
INSERT INTO kpx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lainaho bae abu mesia havei malei loboe dilava hoesegevemale ke igelive. Isi lainaho tahove keta igelive. Isi mesia tahoveu lotioholimale ke igelive. Isi lainaho bae mole keatehi ladevegelive. Lana no louale ko valiege vaveve dua vave. No hotou kemo kateai ua. La nohovu.” ");
INSERT INTO kpx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Abu levaleva ke hisaliai mai esemu kebia ovei hanavege abu mai Antiokae tilu. Tiale ekalesia bahata hohavege abu igaetoasege abu levaleva ke mai ovelu. ");
INSERT INTO kpx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ige Antioka ataeau levaleva kemo abu hotoe dua hisaliale ke dodavei vahaeholahalu. ");
INSERT INTO kpx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ige Diudasiu Sailasiti belovetae ata holialemo Antiokae ekalesia kebia haivelage abu abu evievimo negolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ige keau vani degomole abuhi uliale Antioka ataeau hanavege abu vahaehota hoidevei tota Dielusalemae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Abu tisege Sailasiu isiviai o kemo ui. ");
INSERT INTO kpx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Isege Bolou Banabasiti Antiokae ui ata degomolehi Kosive hoto loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Iniale vani mole Bolou Banabasi namihai avoe, “Naiti hoidevei talive nahi subuta vata bahatae Dilava hoto loui haivemale kebia elegevei. Mesoho keau ue dua vama o ue toela vama.” ");
INSERT INTO kpx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kateai louge Banabasiu namihai avoe, “Nahi Dioni Maka melamege au nahehi tai.” ");
INSERT INTO kpx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Isito Bolou isiviholialeike mo keu abuhi taliho. Kosealemo keu abuhi lovianata Babilia vata keve halevei hoilahai au oe tinu. ");
INSERT INTO kpx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kateai ke loui moleho itumulahai kemo mole tasalievelu. Ige Banabasiu Dioni Maka melamei avui bouti mai Saibalasie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Isege Bolou Sailasi melamei avuti tige ekalesiaeau namigevei avoe, “Dilavana bae la huhuevei au uvu laovei la hoesegevei.” ");
INSERT INTO kpx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ige abu halevai Silia isi Silisia vatae ekalesia haivege abu abu evievimo negolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bolou Sailasiti tiale Debi oe velehovoi tilialeau Listae velehovolu. O kemo evievi ata abuiau ua. Keabulike Timotiu abu neinati. Neinave keu Diue keate. Isege mamave keu Gilikie malaha. ");
INSERT INTO kpx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ige evievi ataeau Lista isi Aikoniomue umale keau Timoti eahalema. ");
INSERT INTO kpx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Katealemo Bolou isiviale melamei avuti tai. Isito Diue ataeau hilokage mamaveu Gilikie ata holialemo Bolou melamei vudive vate etulenu. ");
INSERT INTO kpx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Isi kateai au esemuhi o igaegaela tiliale Dielusalemae abostolo isi dubue kosive keau menaka nehe louale ke loui evievi ata haivei avoe, “Menaka ko evisime ehovave.” ");
INSERT INTO kpx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ige ekalesiaeau ke evisi abu evievimo negolahage ata degomoleau ke elehai Iesu ehovama. ");
INSERT INTO kpx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iniale vani mole Bolou au esemuhi isiviale Esia vatae tai. Isito Munanae Tumuu isiviholinu abu keve taliho. Ige abu halevai Vilisia vatae tiale halevai Galesia vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tiale keau Misia vatae velehovoi isiviale Bitinia vatae tiho vasege Iesu Munanae Tumuu humahaeabe bamunu. ");
INSERT INTO kpx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ige abu inuta Misia vatae tialeau o mole Toloasie velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Keve velehovoale vavi kemo Bolou lahoahoasege Masedonia malaha moleu lamisi hohavoi avoe, “Loholive kove no tedaevenela.” ");
INSERT INTO kpx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bolou lohoahoa ke vageto no isiviale Masedoniae tai. Kosealemo no hilokage Dilavaike lahoahoa kemo no haivei isiviale no talive hotoe dua loui ata kebia havei. ");
INSERT INTO kpx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Katealemoike no Toloasi halevai bouti mai inuta tiale Samotesie velehovolu. Isi vani mole tilialeau Masedonia vata keve o mole Niabolisie velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Velehovoi heila tialeau Masedonia vata kemo o mole baluga Bilibaie velehovolu. Loma ata moagaeau o kemo umale kemoike no tiale vani degomole ua. ");
INSERT INTO kpx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Uliale bulamo huhulahai kosea, “Diue ataeabuna e bavae guligulilahai.” Isi kateai tige keate degomoleau keve mole bevuevei uge no hotoe dua loui kebia haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ige Taiataila keate mole Lidia keu no hoto evima. Keate keu ogoe dua tahote voievemale keate. Keu Diue ata holioholisito Dilava hoesehavomale keate. Ige Dilavau keate ke uvu alavoge au Bolou hoto loumale ke evisi au uvu mai Iesu ominu. ");
INSERT INTO kpx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iniale keate keu ovemo umale kebiahi Iesu ehovai babatisolahalu. Ige keate keu no namigevei avoe, “La huhuige di evievie keate seleve holige loholive di oe nohehi uve.” Isi kateai negoai louge no avuluvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Vani mole no guliguliho tisege ma mole kosiveveau mage au abuemo heiata loviamale keu nohehi belemanu. Ma kemo munanae toelau uale kemo auna gabie ono vadeu lohoveve ke loui ata namigevege abuna ibinave vage kosiveve abuna kemo moni baluga malegei. ");
INSERT INTO kpx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Iale ma keu no ehovei baita hoai loui avoe, “Malaha koeau Dilava esemu abulike koea. Iale keau la oleve kateai ukolikoli maveve ke louma.” ");
INSERT INTO kpx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Vani moaga kateai loulage Bolou avuho itumuai hoilahai munanae toela ke namihai avoe, “Iesu Keliso ivimo di a imihama. Ma ke halei tenela.” Ige solekavesite munanae toela keu ma ke halei tinu. ");
INSERT INTO kpx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Isi kateige ma ke kosiveau ke elehai loui avoe, “Noeabuna bae oleve kateai ma komo moni malegei.” Kateai ke loui Bolota Sailasita malevei kotaho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kebia malevei tialeau Loma kosive kebia vudimo otovei loui avoe, “Ata koeau Diue ataea. Iale abu nahie o komo vaveve toela vama. ");
INSERT INTO kpx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Keau abu vaveve loui o komo Loma ata nahie menaka aiogevema. Iale nahi bae vaveveabe ke ehovai nahie vaveve halevalivebene.” ");
INSERT INTO kpx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kateai louge oe ataeau ke evisi isiviale Bolota Sailasita malevei havei. Ige Loma kosiveau ogoeabe dikohai abu esemu namigevege abu visugevelu. ");
INSERT INTO kpx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kebia visugevelata dibulae hanavei dibulae kosive namihai avoe, “Kobia malevei otovei bamueve dua vanela.” ");
INSERT INTO kpx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ige dibulae kosive keu ke evisi malevei oe uvu seleve otovei abu idi baluga kobugeveale ke uvumo veloeabe malei emei bamuevelu. ");
INSERT INTO kpx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Iniale vavie minamo Bolou Sailasiti nogoli loui Dilava hoesehavosege dibulae uale keau ke evima. ");
INSERT INTO kpx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kateisege hamu balugau hatuge dibulae o keu kibikibiage solekavesite udaha bahataeau solahai alavoge abu seimita umudieveale keau bahata solahalu. ");
INSERT INTO kpx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ige dibulae kosiveu hovelahai elehage udaha bahataeau solahage au huhuai avoe, “Atae abulemo bahata nova detuluvisi tihatulu.” Isime au siga mai isiviale au ebika bisi. ");
INSERT INTO kpx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kateisege Bolou baita hohavoi avoe, “A ebika hama halenela. Noeabulike bahata kove ua.” ");
INSERT INTO kpx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kateai louge dibulae kosiveu au esemu mole namihage au lameba mai omige au mai Bolome Sailasime oe uvue tiale teteai vudiabemo dobai hoesegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Isi holoevei heie lohoale namigevei avoe, “Di kosivea, dana ono vade vai ukolikoli mai.” ");
INSERT INTO kpx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ige abu namihai avoe, “A uvu mai Iesu Kelisomo mamoi bae a esehi ukolikoli mave.” ");
INSERT INTO kpx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kateai louito Kosive hoto loui haivui ovemo umale kebiata haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kateimale vavimo dibulae kosiveu Bolome Sailasime vatee ohe totoai hoesegevenu. Hoesegevege uoholige au au omo umale kebiahi babatisoalu. ");
INSERT INTO kpx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ige kosive keu kebia holoevei au oe tiale lovi ovege abu ilu. Ige malaha keu au ese laluvei abu uvu mai Iesuemo mavoalemo vahaeholahalu. ");
INSERT INTO kpx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Iliale vavita Loma kosiveau abu bukate hanavege abu tiale dibulae kosive ke namihai avoe, “Kebia iovege abu tai.” ");
INSERT INTO kpx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ige dibulae kosiveu ke evisi tiale Bolo namihai avoe, “Loma kosiveau hoto hanavoi isiviale Sailasiti teve. Iale halevai talive ue dua vave.” ");
INSERT INTO kpx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Isito Bolou tiale bukate kebia namigevei avoe, “Keau no malevei kotaholisito ata moaga kebia vudimo no visugevei no malevei dibulamo otovelu. Isi aike isiviale no iovege no hoidevei tai. Iale no bae katelahalivebene. Kosealemo noeau Loma ataea. Iale Loma kosiveau bae loholive no iovege no bae tai.” ");
INSERT INTO kpx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kateai louge bukateau hoidevei tiale Loma kosive namigevei avoe, “La malaha abuita malevei dibulamo otoveale keau Loma atae abulike.” Ige Loma kosiveau ke evisi vabulahalu. ");
INSERT INTO kpx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Isi tialeau Bolota Sailasita sovavigevei loui avoe, “La nohovu. No la aiogeveale keu toelanu. La o ko halevai tige duave.” ");
INSERT INTO kpx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kateige Bolou Sailasiti dibula halevai Lidia oe tialeau keve evievi ata elegevei hoto loui negotieveito halevai tilu. ");
INSERT INTO kpx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Halevai tilialeau Avibolisi isi Abolonia evihai tilialeau Diue dubuu Tesaloniae ualeve velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Keabuna oleve keve tiliege Diue dubuu uale keve guligulilahagei. Iale bula abuita igaeta kebiamo Bolou tiale dubumo guliguliai Bukae Hoto dodavei ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Isi Bukae Hotou Kelisou lohoveve louale ke loui namigevei avoe, “Dilavana Diue ata tedaeveveve kosive ke hanavoge auna lohoniege vatehani maleime hatisi tota hovelahai. Iale di la namigevema. Diue ata tedaeveveve keike Iesu Keliso.” ");
INSERT INTO kpx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kateai louge Diue ata degomole isi Dilava hoesehavomale Gilikie ata moaga isi keate ivite degomole keau hoto ke evisi Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ige Diue ata degomoleau hoto ke evisi itumulahai tilialeau laskolo namigevege abu mole bevuevei igaetoai loholu. Lohoaleau o ke bahata aiohavoito Bolome Sailasimeho nilahai lohoaleau evievie ata mole Diesoni ke omo loholu. Keau isivialeike Bolome Sailasime elegevei havei malevei talive atae nimo otovei. ");
INSERT INTO kpx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Isito nilahage uoholige abu Diesoni mai evievi ata degomoleta malevei tiale oe kosive nimo otovei baita abuho loui avoe, “Ata koeabulike o bahatala vaveve toela vama. Iale keabulike ko nahie oe loholu. ");
INSERT INTO kpx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","8","Keau lohoge Diesoniu malevei o hatuevenu. Iale keau bahata Loma kosive baluga Sisa ke menaka aiohavoma. Kosealemo abu loui avoe, ‘Kosive mole baluga Iesu keu ua.’” Laskoloeau kateai louge Loma kosiveau ata bahatahi hoto ke evisi itumulahalu. ");
INSERT INTO kpx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ige Loma kosiveau louge Diesoniu evievi atahi ke ibina vai moni ovege abu iovege tilu. ");
INSERT INTO kpx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Iniale vau giduige evievi ataeau Bolota Sailasita hanavege abu Beliae tiale velehovoito halevai Diue dubue tilu. ");
INSERT INTO kpx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Keve tige ata kebia vaveveu Tesalonia ata kebia vaveve nahate vaholisito duaveanu. Keau hotoeabe evisi ma seleveai vani bahata Bukae Hoto dodavei isiviale hilokage Bolou loumale kena vali seleve holisi. ");
INSERT INTO kpx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Vaveve katealemoike Diue ata moagaeau hoto ke evisi Iesu ehovage Gilikie ata ivite degomoleta Iesu ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kateige Diue ataeau Tesaloniae umale keau ke evisi hilokage Bolou Beliae tiale Dilava hoto loui ata haivenu. Ige abu ke evisi lohoaleau isiviai ata holoevei abuhi talive Bolo hamai. ");
INSERT INTO kpx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kateige evievi ataeau ke evisi Bolo melavei avuluvuta davala vavae tisege Sailasiu Timotiti oe ua. ");
INSERT INTO kpx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Keau Bolo melavei tiale Atenie velehovoi mavoito hoidevei Beliae lohoho vage Bolou namigevei avoe, “Talive Timotita Sailasita namigevege abu solekai loholive komo daemo lohoi.” ");
INSERT INTO kpx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bolou kateai louito o kemo Sailasime Timotime hemevei uime loboe dilava moagamoaga elegeveime kabebianu. ");
INSERT INTO kpx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Au kebia elegevei tiale Diue dubue Diue ata isi Gilikie ata kebia haivenu. Isi tiale maketie Dilava hoto loui ata kebiata haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kateige lulelete ata degomoleau Ebikulia hoto mai lohoale keau Sitoika hoto male kebiahi Bolo hoto kemo hoto nimolete louma. Kosealemo Bolou Iesuu hatai hovelahale ke loui namigevenu. Ige abu mole namigevei avoe, “Malaha vadeike ko au ebika mai mihatuma. Mesoho malaha keu dilava nimolete deiadaike au ke louma.” ");
INSERT INTO kpx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kateai Bolo melavei kanisolo balugaeau umale keve tilu. Matama ke ivilike Aliobagasi. Abu Bolo mai tiale keve velehovoi avuho loui avoe, “A aike loumale hoto ke ihu loui no namigevenela. ");
INSERT INTO kpx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","A hoto degomole louale keau noemo hotoe doga. Iale no isiviale aike ke ihu loui no namigevenela.” ");
INSERT INTO kpx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kosealemoike abu hoto ke loulu. Ateni ata isi ata degomoleau abuhi umale keabuna vani bahata hoto mole doga loui mole haivei isiviale ke evigei. ");
INSERT INTO kpx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Abu kateai louge Bolou hovelahai namigevei avoe, “Ateni malahaea, di elehage laeau dilava moagamoaga hoesegevema. ");
INSERT INTO kpx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Di la o kola lohoale la loboe dilava hoesegevemale ke elehanu. Isi la batabatae golomo la loboe dilava hoesehavoi hisaliai loui kosea, ‘No hilokaholiale dilava ke no komo hoesehavoma.’ Isito la dilava hilokaholisito hoesehavomale ke dana nova loui la namigevei. ");
INSERT INTO kpx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dilava keu vata vai onobenobe vaevei avuemo otoveale keu otogoe Kosive isi vatae Kosive. Iale keu bae ataeau abu adala dubu houale kemo ulivebene. ");
INSERT INTO kpx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dilava igaeu onobenobe bahata vaevei lu ata ovealemo nahiabuna oleve kateai bae adala vale mai omisi. ");
INSERT INTO kpx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Dilavau subuta ata mole igae vale kemoike ata bahataeau lohoale vata bahatamo igaegaeai ui lotilu. Isito ataeau uoholisege au abu oleve keve uveve isi vani vaesute uveve ke ovenu. ");
INSERT INTO kpx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Au ke vai isiviale ataeau kaovai huhuai elike hoesehavoi. Au ke vaito nahiemo haeava holioholinu. ");
INSERT INTO kpx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Iale nahiabuna vuvunevemo ui tigei. Di hoto ke igaemo la ata moleu loui avoe, ‘Nahita eseabe nahiabulike.’ ");
INSERT INTO kpx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Iale nahi Dilava ese holialemo huhuihuhui nimolete va halevai. Ataeau golo, silivi, mune malei abu lulelemo loboe dilava vaeveale keau Dilava seleve holioholilu. Isito Dilava seleve keu nimolete. ");
INSERT INTO kpx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Subuta ataeau vaveve kateale vage Dilavau kebia elegevei aiogeveholisito aike ata bahata namigevei avoe, ‘La vaveve toela ke halevai di ehovave.’ ");
INSERT INTO kpx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Au louale keu koseanu. Au vani mole ebagemale kela au ata mole ebagemale kena bae ata bahatae vaveve kaovai abu vamale kemo ibinaeabe ovei. Iale ata keike Dilavau etuvage hovelahanu.” ");
INSERT INTO kpx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Atau hatisi hovelahale ke Bolou louge ata degomoleau ke evisi hehavosege degomoleau loui avoe, “Loholive tota hoto ke loumoleage no evisi.” ");
INSERT INTO kpx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kateai louge Bolou halevei tinu. ");
INSERT INTO kpx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Isege ata degomoleau hoto evisi abu uvu mai Iesuemo mavoi Bolo ehovalu. Iale kebiamo ata degomole abulike koea. Daioniasi (Keu Aliobagasie kanisoloe esemu). Ige keate moleike Damalisi. Ige ata degomoleta. ");
INSERT INTO kpx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Iniale vani mole Bolou Ateni halei Kolinitie tinu. ");
INSERT INTO kpx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Keve tiale Diue ata mole Akuila isi mahinave Bisila kebiamo tinu. Malaha ke neinaveu Bontasi vatae mamoge au halei tiale Itali vatae ua. Keve uniale Loma Kosive baluga Kalodiasiu menaka mamoge Diue ata bahataeau vata ke halevai vata degomoleve tilu. Kateige Akuilau abu mahinati Kolinitie lohoge Bolou tiale kebia elegevei abuhi ua. ");
INSERT INTO kpx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Abuhi keve ui loviabe ke nahate vai abu valai houmale ke nahate vai kemo ibina malenu. ");
INSERT INTO kpx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Isi bula bahata kela auna Diue dubue tiniege Diue ata isi. Giliki ata kebia haivei isivialeike abu Iesu hoto evisi ehovai. ");
INSERT INTO kpx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Isege vani mole Sailasiu Timotiti Masedonia halevai Kolinitie loholu. Lohoale velehovoge Bolou au lovi ke halei vani bahata hotoe dua loui Diue ata haivei avoe, “La tedaeveveve kosive keike Iesu.” ");
INSERT INTO kpx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kateai louge abu ke evilata hotove ke bamui avuho hotoe toela louge au abuho itumuai au ogo sesiai abuho loui avoe, “La hoto ko bamualemo vatehani malege keu la isivimoike. Keu di isivi holioholinu. Iale nova komo dana la halevei Diue ata holioholiale kebia haiveho tai.” ");
INSERT INTO kpx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kateai louito halevei tiale Diue ata holioholiale malaha mole Tisiasi Diasitasi ke ou Diue dubue vavamo ualemo biloanu. Malaha keu Dilava hoesehavomale ata. ");
INSERT INTO kpx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Isege Diue dubue kosive Kilisibasiu au uvu mai Iesu omige ovemo umale kebiata abu uvu mai Iesu omilu. Ige Koliniti ata degomoleau hoto ke evisi abu uvu mai Iesuemo mavoi babatisolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Vavi molemo Dilavau lohoahoa nahate Bolo omige au elehasege Kosiveu avuho loui avoe, “Ainaho bae di hoto louveve ke vabuhavoi halegelive. Isito negobedai ata haivegenela. ");
INSERT INTO kpx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Dana aiti uge atabeu bae a aiohavolivebene. Kosealemo di ata moagaeabulike kove ua.” ");
INSERT INTO kpx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ige Bolou vagana igae isi bata sigisi (6) ke uvumo o kemo ui Dilava hoto loui ata haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Vani mole Loma gamaniu kosive mole Galio ebagemage au Giliki vata nalinu. Kateimalela Diue ataeau mole bevuevei Bolo mai kotaho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mai tiale kotae kosive namihai avoe, “Malaha kou isiviale ataeau vaveve nimolete vai Dilava hoesehavoi Lomae menaka ke aiohavoi.” ");
INSERT INTO kpx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kateai louge Bolou isiviai hotoeabe ibina louho vasege Galiou Diue ata namigevei avoe, “Di la namigevege evive. Malaha kou laemo vaveve toela vage dana la hoto evisi la tedaevei. ");
INSERT INTO kpx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Isito di huhuige laeau la menaka kemo atae ivi unaha isi hoto moleike la ko loumalemo di bae malaha kemo vaveveve kaovalivebene. Isito la biaeau bae ke kaovave.” ");
INSERT INTO kpx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Isi kateai loui ata kebia nunuvege abu heie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kosive keu hotoeabe evioholige abu heie tiale abu dubue kosive Soseteni evudei mai lohoale kotae oe ulidamo hamage Galiou ke elehai hotobe louholisi momoleai ua. ");
INSERT INTO kpx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Vaveve keu uoholige Bolou Koliniti atahi uniale vani mole kebia halevei Akuilata Bisilata holoevei abuhi Senikiliae tilu. Keve usege Bolou Dilava ivimo menakale kemo Diue vaveve nahate vai au kina bohinu. Kateaito abuhi bouti mai Siliae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tilialeau humaha tavae Evesasie dobuluvige Bolou avu igae tiale Diue dubue atahi hotohotoanu. ");
INSERT INTO kpx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ige ataeau isiviale Bolou vani degomole abuhi ui. Isito au isiviholinu. ");
INSERT INTO kpx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Isi kebia namigevei avoe, “Dilavana isiviage dana tota lohoniege bae la elegevei.” Kateai louito kebia halevei bouti mai tinu. ");
INSERT INTO kpx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tiale Sesaliae velemai bouti halei Dielusalemae tiale ekalesia kebiahi vahaehoaito halevei Antiokae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Keve velemai vani degomole unahamo uito halei tota Galesia isi Vilisia vatae tiale evievi ata tedaevei negotievenu. ");
INSERT INTO kpx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Bolou kateai oisege Diue malaha mole Abolosiu Alekisandia o balugamo lohoale Evesasie lohonu. Malaha keu hoto loue dua vai Bukae Hoto kaovai kemo lulele baluganu. ");
INSERT INTO kpx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Subuta malaha moleu Dioniu Iesu deiada louale ke loui namihage au negobedai Iesu hoto loue dua vai ata haivenu. Isito keu Iesu vaveve bahata hilokaholisito Dioni ata babatisogevemale ke vaveve unaha hilokanu. ");
INSERT INTO kpx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Au kateai Diue dubumo vabuoholisi Kosive hoto louge Akuilau abu mahinati ke evisi melavei tiale abu oe Dilava deiada degomole neniai loui namihalu. ");
INSERT INTO kpx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Iniale vani mole Abolosiu isiviale Giliki vatae tai. Tige Evesasie ataeau haokuvuiabeau Giliki vatae umale kebiaho levaleva hisaliai isiviale abu Abolosi hoesehavoi mai o hatui. Iniale au keve velemai Dilavau kebia huhuevei hoesegeveale hoto ke loui kebia negotievenu. ");
INSERT INTO kpx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Negotievei ata moaga kebia vudimo lamisi Diue ata kebiaho hoto negote loui hotoeabe hamai Bukae Hoto mai selevetisi abuho loui avoe, “Iesu keu Diue ata tedaeveveve kosive Keliso.” ");
INSERT INTO kpx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Abolosiu Kolinitie usege Bolou lohoale Esia vatae tiale Evesasi oe velemai evievi ata degomole elegevenu. ");
INSERT INTO kpx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Elegevei belagevei avoe, “La subuta evievi ata holige Munana Tumutena laemo lohonu.” Ige abu loui avoe, “Noeau a Munana Tumute loumale ke hilokaholilu.” ");
INSERT INTO kpx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ige Bolou belagevei avoe, “La ole hotoike evisi babatisolahalu.” Ige abu namihai avoe, “Noeau Dioni hotoike evisi babatisolahalu.” ");
INSERT INTO kpx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ige Bolou namigevei avoe, “Dioni ata babatisogevemale keu Diue ata namigevei avoe, ‘La la vaveve toela halevaliege bae babatisolahave. Isi la uvu mai di iae lohomale Kosive Iesu kemo mavoi ehovave.’” ");
INSERT INTO kpx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kateai loui haivege abu ke evisi Kosive Iesu ke ivimo babatisolahalu. ");
INSERT INTO kpx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ige Bolou au ada mai kebia tatamo mamoge Munanae Tumuu abuemo lohoge abu hoto nimolete loui kemo Dilava hotota loulu. ");
INSERT INTO kpx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Vaveve kateale vale keau bahata tuelo (12) unaha. ");
INSERT INTO kpx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ige Bolou ata kebia halevei bata abuita igaeta ke uvumo Diue dubumo ataeau Dilava adae vuvunemo uveve hoto ke loui ata haivenu. Au kateai baita loui isiviale ataeau hoto ke evisi Iesu ehovai. ");
INSERT INTO kpx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Isito ata degomoleau hoto ke evisito isiviholilu ehovaliho. Isi atae uvumo Kosive ehovaveve ke aiohavoi hotoe toela louge Bolou kebia halevei evievi ata unaha holoevei abuhi tiale ebouamale o baluga kemo biloanu. O keu Tailanasi oike. Iale o kemo Bolou vani bahata hotohotoai ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Vagana abuita ke uvumo ata haivelage hoto keu Esia vatamo o kebia bahata sonumai gabiage Diue ata isi Diue ata holioholiale keau bahata hoto ke evilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dilavau au vuvune mai Bolo omige au vaveve nimolete vaevenu. ");
INSERT INTO kpx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Katealemo evievi ataeabuna Bolo muko isi ogove ivi ke unaha malei tiliege vavahanite kebia golomo otovege vavahaniabe kena uoholigei. Isi munanae toela malemale kebia golomo otovege munanae toelana halevei tigei. ");
INSERT INTO kpx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Bolou au esemuhi kateisege Diue ata degomoleau o igaegaela olahai munanae toela nunuvemale keau lohoale Bolou vamale ke nahate vai isiviale Iesu ivimo ata hoesegevei. Diue dubue kosive baluga Sikiva ke ese bahata seveni (7) abulike vaveve kateale vama. Iale vani mole keau tiale munanae toelau malaha molemo uale ke namihai avoe, “Bolou Iesu ivimo ata haivemale ke ivimo no a namihale halei tenela.” ");
INSERT INTO kpx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kateai louge munanae toela keu abuho loui avoe, “Di Iesuta Bolota hilokaevenu. Isito laeau olemea.” ");
INSERT INTO kpx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kateai lousege malaha nehe munanae toelau avuemo uale keu kebia vudievei havei ogoeabe dikohage keau vatetumu malei ove ke halevai vava unahata detuluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Abu kateige ata bahata Evesasie uale keau ke evisi vabulahai Iesu hoesehavoge Kosive Iesu ke iviu abuemo baluganu. ");
INSERT INTO kpx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ige evievi ataeau lohoale ata bahatae vudimo vaveve toela abu vamale ke loui haivelu. ");
INSERT INTO kpx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ige eveimale ata degomoleau abu evee vaveve bukamo hisaliamale kebia malei lohoale ata bahatae vudimo mahoevelu. Buka kebia bahata mahoeveale ibinaeabeu bahata vivti taoseni kina (K50,000). ");
INSERT INTO kpx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Vaveve katealemoike Dilava hotou negoai o bahata sonumai tinu. ");
INSERT INTO kpx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Vaveve ke iae Bolou isiviale o ke halei Masedonia vata, Giliki vata isi Dielusalema o baluga kebiae tai. Kateai huhuai avoe, “Dana o kebiae taito bae halei tota Lomae tai.” ");
INSERT INTO kpx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kateai Esia vatae uito au esemu Timoti isi Elasitasi kebia hanavege abu vasohuta Masedonia vatae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bolou Evesasie usege vaveve toelau evievi ataemo lohoale keu koseanu. ");
INSERT INTO kpx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","O kemo abuna siliva mahoi loboe dilavae munana vaevegei. Loboe dilava ke ivilike Daiana. Iale keabuna lovi ke vai moni baluga malegei. Lovi ke vale malaha mole ivilike Demitiasi. ");
INSERT INTO kpx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iale malaha keu au haokuvu degomole abu avuluvuta lovimale kebia hohavege abu mole bevuevesege malaha keu namigevei avoe, “Di haokuvuia, nahi lovi komoike ibinae dua malema. ");
INSERT INTO kpx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Isito Bolou vamale ke la elehai evige au ata haivei avoe, ‘Ataeau abu adata dilava nahate vaevemale keau Dilava seleve holioholilu.’ Bolou hoto kateale louge Esia vata komo isi o baluga komo ata moagaeau hotove evisi ehovalu. ");
INSERT INTO kpx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Katealemo ataeabuna nahi vamale ko voilahaholige nahiabuna monioholisi. Isi kateale vage nahie dilava Daiana ketana uoholige oleteabuna bae lohoi dubu komo ke hoesehavoi. Aike Esia vatamo umale kebia isi vata degomolemo umale kebiabulike nahie dilava hoesehavoma. Isito ataeabuna Bolo hoto evisi ehovage nahie dilava kena uoholisi.” ");
INSERT INTO kpx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demitiasiu kateai louge kemo mole bevuevei uale keau hoto ke evisi detumulahai baita holahai avoe, “Nahie dilava Daiana keu Evesasi o komo balugataho.” ");
INSERT INTO kpx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kateai baita louge o kemo ata bahataeau ke evisi loui tai lohoma. Kateilata mole bevuevei lohoale Bolo haokuvu Gaiasi isi Alistakasi kebia elegevelu. Masedonia ata abui keau Bololuvuta olahamale ataea. Iale abu kebia elegevei malevei eboue oe tilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ige Bolou ke evisi isiviale talive ata kebia namigevei. Isito evievi ataeau katealeho isiviholisi kelualu. ");
INSERT INTO kpx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ige Bolo haokuvuiau vata kemo gamani baluga holiale keau hoto ke evisime Boloho hoto hanavoi namihai avoe, “Ainaho eboumale o keve talive.” ");
INSERT INTO kpx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kateisege o ke uvue ata bahataeau hoto ke loui daudauasege degomoleau hoto nimolete lousege degomoleau hoto mole louma. Kosealemo abu keve igaetoale ke ihu hilokaholilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ata bahataeau kateisege Diue ataeau Alekisanda kabitisi iovai isiviale au talive atae vudimo lamisi hoto loui. Ige au tiale au adata keluevei isiviale namigevege abu hoto ke hilokai. ");
INSERT INTO kpx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Isito abu ke elehage keu Diue ata. Katealemo abu tota hoto ke baita loui holahai avoe, “Nahie dilava Daiani keu Evesasi o komo dilava baluga.” ");
INSERT INTO kpx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Abu hoto ke unaha loui kateilage oe kosive balugau hovelahai kebia keluevei namigevei avoe, “Evesasi ataea, ata bahataeau hilokage nahie o komo nahie dilava baluga Daiana ke nahiabulike nalima. Isi mune tumuteu otogomo dobai lohoale keta nahiabulike nalima. ");
INSERT INTO kpx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Atabeu bae ke vovoholivebene. Iale la osiohoike vaveve kateale vama. Vaveve kateale halevai tobekai uve. ");
INSERT INTO kpx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","La osiohoike malaha abuita kobia malevei loholu. Keau nahie dilavae dubu kemo onobe vai vavoloholilu. Isi nahie dilava keho hotobe toela louholilu. ");
INSERT INTO kpx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Iale Demitiasiu au esemuhi isiviai kotaho valiege kotae vaniu lohoge bae loholive vaveveabe lousege abuta la vaveve loui. Vani kela kotae kosiveu usege loholive bae ke louve. ");
INSERT INTO kpx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Isi o komo hotobeta uge ke mai talive kanisolo hotohotomo bae louve. ");
INSERT INTO kpx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Lana kateale vaholisito vaveve toela koseale vage Loma gamanina ke evisi nahie o ko aiohavoi. Isi nahie belagevege nahiabuna oleve kateai vaveve ke ihu loui namihai.” ");
INSERT INTO kpx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kateai louito ata kebia iovege tilu. ");
INSERT INTO kpx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Vaveve toela keu uoholisege Bolou evievi ata bahata hohavege abu igaetolahasege au hotoe dua loui kebia negotieveito halevei Masedonia vatae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Keve tiale o igaegaela ata haivei negotievege uoholige au halei Giliki vatae lohonu. ");
INSERT INTO kpx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Keve uale bata abuita igaetaeau uoholige au isiviale bouti mai Silia vatae tai. Isito evige Diue ataeabuna mai hamai. Kateige au kemo au tiveve ke halei hoilahai Masedoniae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Keve tige ata koeau nohehi tilu. Belia malaha mole Bilusi ke mo Sobata. Ige Tesalonia ata abui Alistakasi isi Sekudasi. Ige Debi malaha mole Gaiasi. Ige Esia ata abuita igaeta Timoti, Tikikasi isi Tolovimasi. ");
INSERT INTO kpx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","No kebiahi tige keau tota vasohuta tiale Toloasie no hemevei ua. ");
INSERT INTO kpx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Keau keve usege no Bilibai o kemo uale Diue vahaeho vani mole Basova keu uoholige no bouti mai tiale vanie ni ada moleu uoholisege no Toloasie velehovolu. Keve velehovoi evievi ata nehe kebiahi belehovoi bula igae uvumo abuhi ua. ");
INSERT INTO kpx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Iniale bulae vavimo no lovi iliho bahata mole bevuevei igaetolahasege Bolou vavita halevei taliho namigevelage tiale keu vae mina manu. ");
INSERT INTO kpx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","No hotohotoimale o ke uvue lameba moagaeau ua. ");
INSERT INTO kpx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Iale ehue o ke vuindoamo mo mole ivi Iutikasi keu kemo ugulamoi Bolo hoto evinata niveu haniage au kemo lahanu. Inata o ke egete vuvehai heila dobage abu heie tiale ebagevai elehage hatinu. ");
INSERT INTO kpx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ige Bolou heie tiale mo ke ebagemai evudei loui avoe, “Ninalaha halevave. Mo kou hatioholisito nita ua.” ");
INSERT INTO kpx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Kateige abu mo ke melavei oe tiale mo ke elehage nita uge abu ke elehai vahaeho balugalu. Ige Bolou tiale oe uvue abuhi aleto isi tota haivelage vau alamoge halevei tinu. ");
INSERT INTO kpx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","14","Bolou heila Asosie taito no namigevege no bouti mai tiale keau keve mai bae abuhi Mitilinie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tiale vata mole ivi Kiosi evihai tialeau vani mole Samosie velehovolu. Isi vani mole tialeau Evesasi o kemo lavioholisito inuta tiale Militasie velehovolu. ");
INSERT INTO kpx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bolou Esia vata kemo uliho isiviholilike vage no inuta loholu. Kosealemo au isiviale no solekai talive Dielusamae velehovoi solekaliege Diue vahaeho vani Bentikosi kemo keve ui. ");
INSERT INTO kpx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ialemo Bolou Militasi o kemo uito Evesasi dubue elodaho hoto hanavoi isivialeike keau loholive avuemo lohoi hotohotoai. ");
INSERT INTO kpx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ige eloda keau tiale keve velehovoge Bolou abuho loui avoe, “Vani moaga di Esia vatae lohoale lahehi uale ke la hilokai vaveve bahata di vamale keta la hilokalu. ");
INSERT INTO kpx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","La hilokage di di ebika mai mihatuholisege Diue ataeau isiviale di aiohavoge di vatehani malei. Di vani bahata ninanamoike Kosive lovi ke vai vatehani malema. ");
INSERT INTO kpx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","La hilokage di la o igaegae kela la haivei ologomo ataeau mole bevuevemale ketala la haivei hotobe laemo mahogovaholisito hoto bahata keike di loui la haivelage la kemo lulelelahalu. ");
INSERT INTO kpx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Diue ata isi Diue ata holioholiale kebia di haivei isuta abuho loui kosea, ‘La vaveve toela ke halevai Dilava hoto evisi la uvu mai omisi nahie Kosive Iesu Keliso ke ehovave.’ ");
INSERT INTO kpx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Di hoto kateale loui la haive dua vanu. Iale aike Munanae Tumuu dahoe loualelua dana la halevei Dielusalemae tai. Iale mesoho dana keve tige vaveve oletealena keve daemo velemai. ");
INSERT INTO kpx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Isito di hilokage di o bahata kebiala lohosege Munanae Tumuu abu di mai dibulae mavoi vatehani daovaveve ke loui di haivunu. ");
INSERT INTO kpx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ige di hoto ke evisi di hatihati kemo vabuoholisito isivialeike Kosiveu lovi daoale ke vage au gabiai. Iesu lovi keu koseanu. Dana hotove dua loui ata haivege abu elike Dilavau au uvu ovei hoesegeveale ke hilokai. ");
INSERT INTO kpx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Di subuta lahehi ui la Dilava adae vuvunemo uveve ke deiada loui la haivei hilokage la bae tota gabie di ni elehalivebene. ");
INSERT INTO kpx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Iale di hoto ko louge evive. La di louale ke evisi ukolikoli maholige keu bae di toela holilivebene. Isito keu la toela. ");
INSERT INTO kpx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kosealemo di Dilava hoto loui la haivei laemo ke ihube mahogovaholisito Dilava vaveve bahata keike di loui la haivenu.” ");
INSERT INTO kpx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bolou kateai louito eloda kebia namigevei avoe, “La evievimo nenilahai negolahave. Isi Munanae Tumuu vuvune laoveale kemo evievi ata kebia nalieve dua vave. Kosealemo Dilavau au moe tahomo ata malevege abu atave holilu. ");
INSERT INTO kpx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Isito di hilokage dana la halevei tisege vavoloe ataeabuna loholiege loboe hoto loui la uvu isi aiogevei. ");
INSERT INTO kpx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ige vani moleu lohoge la vigomo la degomole abuna hovedevei loboe hoto louge evievi ata degomole abuna ke evisi ehovei. ");
INSERT INTO kpx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ialelua la ebia nenigeveve. Isi di vagana abuita igaetamo vavita gututa ninanamo la haivemale ke huhulahave. ");
INSERT INTO kpx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Iale dana nova Dilava adae uvumo la halevei tige au au uvu laovei la hoesegeveale hoto kena lahehi ui la negotievege Dilavau au ataho uveve dua louale ke lana maleve. ");
INSERT INTO kpx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","La hilokage di subuta lahehi uale kemo la monita la ogotaho la imigeveholinu. ");
INSERT INTO kpx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Isito di di adatela loviai moni malei kemo di esemuhi lovi isi abuhi uma. ");
INSERT INTO kpx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Iale di vaveve katealeike la haiveale ke nahate vai negolahai lovilahalive elike ata degomoleau negoholimale kebia tedaeveve. Isi Iesuu louale ko huhulahave. Au loui avoe, ‘Nahi onobenobe ata ovemale kemo vahaeho balugana ui. Isito nahi nahie ebika unahaho onobenobe malemale kemo vahaehou bae ulivebene.’” ");
INSERT INTO kpx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bolou kateai louge uoholige abuhi au kome bokoai vata bisi Dilava imihanu. ");
INSERT INTO kpx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Imihai gabiageto abu lohoi Bolo evudei ninahavolu. ");
INSERT INTO kpx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Isi Bolou elegeveholiveve hoto ke abu evisi uvu balugai boutie halevahatuho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tiale no halevehatuevegeto no bouti mai inuta tialeau vata mole Kosi ke evihai tilu. Isi vani mole tilialeau Lodasi vata evihai Batala oe velehovoi keve dobuluvilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Isege bouti moleu Venisia vatae tiho vasege no kemo biloluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Isi lohoaleau davala nie velehovoi Saibalasi elehai ke vavae giloai matama ke inuteatave tiale Silia vatae velehovoi tiale Taeae dobuluvisege abu bouti kemo kako malei heie otovelu. ");
INSERT INTO kpx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Isege no tiale evievi ata kaovei elegevei abuhi bula igae uvumo ua. Ige evievi ata keau Munanae Tumue vuvunemo Bolo namihai avoe, “Ainaho bae Dielusalemae tigei.” ");
INSERT INTO kpx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kateige no keve abuhi uliale bula keu uoholige evievi ata keau abu ese abu mahinuvu kebiahi boutie no halevehatuho tilu. No bahata tialeau esagae velehovoi kome bokoai Dilava imihalu. ");
INSERT INTO kpx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Keu uoholige abu no halevehatueveito hoidevei abu oe tisege no boutimo biloluvisi tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tilialeau Tolomeasi oe velehovoi kemo dobuluvisi tialeau evievi ata kaovei elegevei abuhi ulialeau emo ladevelu. ");
INSERT INTO kpx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Iliale vavita hovedevei kebia halevei tilialeau Sesaliae velehovoi tilialeau Bilibi abu subuta Dielusalemae ata seveni (7) tabagevemale kela keta ebagevale keluvuta ladevelu. ");
INSERT INTO kpx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Iale malaha ke mahoho bahata voa (4) keau kolivuholisito vani bahata abuna belovetae vaveve vai Dilava hoto lougei. ");
INSERT INTO kpx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Iale no vani degomole o keve usege Diudia vatamo beloveta mole Agabasi keu lohoale noe velemanu. ");
INSERT INTO kpx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Velemai Bolo beleta mai au velota au adata umuvai loui avoe, “Munanae Tumuu daho louale nahateike di ko vanu. Iale beleta ko biage Diue ataeabuna Dielusalemae umuvai mai Loma gamani kosive kebia ovei.” ");
INSERT INTO kpx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ige o ke evievi ata isi no bahataeau hoto ke evisi ninalahai isiviholilu Bolou Dielusalemae taliho. ");
INSERT INTO kpx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ige au namigevei avoe, “La osiohoike ninalahai di uvu aiohavoma. Halege di keve tige abu Iesu ivimo di umuvai dahavoi vatetumu daovale keta duave.” ");
INSERT INTO kpx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kateai louge no keluveve ke halevai namihai kosea, “Halege Kosive isivi unaha.” ");
INSERT INTO kpx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kateaito no kunai bevuevei malei o ke halevai heila Dielusalemae tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Keve tige Sesalia evievi ata degomoleau nohehi tiale keau no holoevei Nesoni oe tige no keve avuluvuta ladevelu. Malaha keu subuta Saibalasie evievi ata holisi lohoale Dielusalemae ua. ");
INSERT INTO kpx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","No Dielusalema keve velehovoge evievi ataeau no vahaeho vai no tovu valu. ");
INSERT INTO kpx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Iniale vani mole Bolou no holoevei Diemisi elehaho tilu. No keve tige ekalesiae kosive keau bahata keve ua. ");
INSERT INTO kpx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ige Bolou adaeabe hatuevei hoesegevei Dilavau lovivemo Diue ata holioholiale kebia tedaevemale ke loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kateai haivege abu ke evisi Dilava hoesehavoi namihai avoe, “No haoka, a hilokage nahie Diue ata moagataho keau Iesu ehovaito isiviale Mosese menaka ke ehovai ma tumuai. ");
INSERT INTO kpx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Isito keau a vata degomoleve vamale hoto ke evige a Diue ata haivei namigevei kosea, ‘Lainaho Mosese menaka ke ehovai la esee vudie vate bohisi la buluve vaveve ke nahate vagelive.’ ");
INSERT INTO kpx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","A lohoale hoto ko abu evilu. Iale nahiabuna abuho vaveve vade vai. ");
INSERT INTO kpx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","No isiviale no huhuale ko vanela. No ata abuita abuitaeau Dilava ivimo hoto loui menakale keau kove ua. ");
INSERT INTO kpx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Iale kebia holoevei abuhi talive Diue dubue vaveve mole vai la ebika hoesegevege uoholige abu mesia malei mahoi Dilava hoesehavoveve ke ibina vanela. Igeto ke iae abuna bae abu kina bohige abu Dilava ivimo menakale kena uoholisi. Ana kateige ata bahataeabuna hilokage abu subuta a vaveve eviale keu seleve holioholisito a Mosese menaka ehomama. ");
INSERT INTO kpx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Isito Diue ata holioholiale keau Iesu ehovale kebiaho no levaleva hanavoi namigevei kosea, ‘Lainaho abu lovi malei loboe dilava hoesegevemale ke igelive. Isi lainaho bae taho isi mesia tahota igelive. Isi lainaho bae mole keatehi ladevegelive.’” ");
INSERT INTO kpx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kateai louge Bolou ata kebia holoevei vani mole abuhi tiale Diue menaka ehovai abu ebika hoesegevelu. Ige Bolou Diue dubu baluga ke uvue tiale dubue kosive namihai avoe, “No no ebika hoesegevege uoholiale noeabuna uliege bula igaeu uoholisege hoidevei loholive mesia malei Kosive hoesehavoi.” ");
INSERT INTO kpx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Iniale bula keu uoholiho vasege Diue ata degomoleau Esia vatamo lohoale keau dubue uvue Bolo elehai Diue ata bahata hohavei evudelu. ");
INSERT INTO kpx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Evudei hohavei avoe, “Iselala ataea, loholive no tedaeveve. Malaha koike matama bahatae timale ata haivei nahie ata aiogevema. Isi Mosese menaka aiohavoi dubuta aiohavoma. Katealemoike au tota kove lohoale Diue ata holioholiale kebia holoevei dubue tumu ko aiohavoma.” ");
INSERT INTO kpx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Abu hoto ke louale keu koseanu. Abu elehasege Bolou Evesasi malaha mole Tolovimasi ke melamei avuti o kemo olahama. Katealemo abu ke elehai huhulahai avoe, “Mesoho Bololemo nova malaha ke melamei dubue lohonu.” ");
INSERT INTO kpx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Iale dubumo ataeau hoto ke evisi dolodoloai loui tai lohoma. Ige oe ataeau ke evisi bibuluvisi lohoale keau Bolo evudei dubu halevai mai heie tilu. Isege ata degomoleau dubue udaha bamuevelu. ");
INSERT INTO kpx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ige abu isiviale Bolo hamage au hatai. Kateisege ata moleu Loma ame kosiveho hoto hanavoi loui avoe, “Dielusalemae ata bahataeau mole havema.” ");
INSERT INTO kpx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ige solekavesite ame kosiveu au esemu holoevei ata moaga kebia vigoe tinu. Ige ataeau ame kosiveta esemuveta elegevei Bolo hamale ke halevalu. ");
INSERT INTO kpx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ige ame kosiveu tiale Bolo mai au esemuho louge abu seimi abuitata Bolo umuvage au deiadave eviliho ata belagevenu. ");
INSERT INTO kpx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kateisege ata degomoleau hoto nimolete lousege degomoleau hoto nimolete louge ame kosiveu kemo daudauai au esemu namigevege abu Bolo melavei ame balikie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Melavei tiale anakamo tige ataeau hamaho vage abu bae ehumo ebagevai mai tilu. ");
INSERT INTO kpx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Isege ataeau iaeabela tai baita loui avoe, “Hamave. Hamave.” ");
INSERT INTO kpx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ige abu mai tiale oe uvue tiho vasege Bolou Gilikie hotomo ame kosive ke namihage au vikoai avoe, “Ana Gilikie hoto hilokanu. ");
INSERT INTO kpx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ana subuta Egubitoe malaha moleu lohoale ata bahata voa taoseni (4,000) malevei abuhi gamani aiohavoito ataeau uvesiteve tiale malaha ke anike ko.” ");
INSERT INTO kpx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ige Bolou namihai avoe, “Ba, dau Diue ata dalike. Vata mole Silisia kemo o mole baluga Tasisi kemoike di lohonu. Iale a isiviage di ata kebiaho hoto loui.” ");
INSERT INTO kpx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ige ame kosiveu isiviage Bolou anakamo lamisi ata keluevege abu tobekai usege au Diue hotomo abuho lounu. ");
INSERT INTO kpx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Au loui avoe, “Di haokuvuia, bahata di hoto evisege di di deiada louge evive.” ");
INSERT INTO kpx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Isi kateai hotoeabe selevemo namigevege abu bahata hotohotoholisi ua. ");
INSERT INTO kpx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ige au namigevei avoe, “Dau Diue ata. Iale di neinau vata mole Silisia keve o mole Tasisie di mamoito di esebuluta usege abu di mai hanavoge di Dielusalemae lohoale kove velemage menaka haivemale kosive baluga Gameliela keu di haivunu. Kosive keu nahie buluve vaveve isi menakaeabe ke bahata loui di haivuge di kemo negoai la nahate vai isiviale Dilava hoesehavoi. ");
INSERT INTO kpx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Isime di subuta Iesu evievi ata kebia havei aiogevei keate malaha kebiata havei malei dibulae otovema. ");
INSERT INTO kpx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Iale lana la dubue kosive isi kanisolo baluga kebia namigevege abuna bae di vaveve hilokamale ke loui la namigevei. Diue ataeau Damasikasie umale kebiaho abu levaleva hisaliai malei daovage di ke elehai isiviai talive Iesu evievi ata kebia seimita umudievei malevei loholive kove aiogevei.” ");
INSERT INTO kpx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Di vaveve kateale huhuaito halei lohoale Damasikasi vavae lohosege vanie lilimo ataga mole balugau otogomo dobai lohoale di bamunu. ");
INSERT INTO kpx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ige di vatamo dobai evisege hoto moleu dahoe loui avoe, ‘Solo, Solo, a osiohoike di aiohavoma.’ ");
INSERT INTO kpx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ige di loui kosea, ‘Kosive, ole a.’ Ige au loui avoe, ‘Dau Nasaleta ata Iesu keike a aiohavoma.’ ");
INSERT INTO kpx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Kateai di namihage daluvuta lohoale keau ataga ke elehaito daho loumale hoto ke evioholilu. ");
INSERT INTO kpx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kateige di Kosive namihai kosea, ‘Kosive, dana vadeu vai.’ Ige au daho loui avoe, ‘Hovelahai Damasikasie talive ata moleu bae Dilavau a ono vade vaveve louale ke loui a namihai.’ ");
INSERT INTO kpx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ige ataga balugau daemo lohoge di niu keduige daluvuta tiale keau di melavei Damasikasie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“O kemo malaha mole Ananaiasi keu ui vani baita nahie menaka ehomai Dilava hoesehavoma. Katealemo Diue ata bahataeau Damasikasie umale keau vaveveve ke elehai malaha ke eahalema. ");
INSERT INTO kpx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Iale malaha keu lohoale di vavamo lamisi loui avoe, ‘Di haoka Solo, bato nianela.’ Kateai lousege di niai elehanu. ");
INSERT INTO kpx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ige keu loui avoe, ‘Nahie buluvebia Dilavau a ebagemai isivialeike a isivive ke hilokai esemuve tumute ke elehai biageu au hoto louale ke evisi hilokai. ");
INSERT INTO kpx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Isi isivialeike a vadeu elehai eviale ke loui ata bahata haive. ");
INSERT INTO kpx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Iale a ono vade nalisi uma. Hovelahai Kosive ivimo babatisoage a vaveve toelau uoholisi.’” ");
INSERT INTO kpx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Kateige di o kemo uniale hoilahai Dielusalemae lohoale dubue uvue guligulianata lohoahoai Kosive elehanu. ");
INSERT INTO kpx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Elehage au dahoe loui avoe, ‘Solekai hovelahai o ko halei tenela. Kosealemo ata koeau bae a di hoto louale ke evisi malivebene.’ ");
INSERT INTO kpx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ige di loui kosea, ‘Kosive, keau hilokage di dubuiabe tiniale a ehovamale evievi ata kebia malei havei aiogevenu. ");
INSERT INTO kpx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ige ata degomoleau a hoto loumale esemu mole Sitiveni hamage di kebia kelueveholisito dabaeabe ogo nalievesege abu hamage hatinu.’ ");
INSERT INTO kpx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kateai louge Kosiveu daho loui avoe, ‘Dana a hanavoge haeavamoleve Diue ata holioholiale kebia haiveho tenela.’” ");
INSERT INTO kpx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bolou au deiada ke lounata Diue ata holioholiale kebiae tiveve hoto louge abu ke evisi hovedevei baita loui avoe, “Hamage au hatai uoholisi. Keu nita uale keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kateai loui itumulahai itolahai abu ogo malei hatui gogea mugai malei ehue hatulu. ");
INSERT INTO kpx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kateisege Loma ame kosiveu au esemu namigevei avoe, “Ko mai talive oe uvue visuhavoge au au vamale ke nahiho louge elike nahi Diue ataeau avuemo vamale ko ihu hilokai.” ");
INSERT INTO kpx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kateai louge abu mai tiale oe uvue visuhavoho umuvage au ame esemu moleu vavavemo lamiale ke namihai avoe, “La di toela kaovai hilokaholisito dahavo kavage keu toelanu. Dau Loma ata. Iale lana daemo vaveve kateale valiege Loma menaka ke eguvave.” ");
INSERT INTO kpx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ige ame malaha keu ke evisi tiale au kosive baluga namihai avoe, “Ata keu Loma ataike. Iale nahi hamage keu toelanu.” ");
INSERT INTO kpx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ige ame kosiveu tiale Bolo belahai avoe, “Au ana Loma ata.” Ige Bolou loui avoe, “Ito.” ");
INSERT INTO kpx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ige kosive keu namihai avoe, “Dau Loma ata holiliho ibina baluga vanu.” Ige Bolou loui avoe, “Au kateanu. Isito dau di mamau Loma ata.” ");
INSERT INTO kpx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kateai lousege ame esemu keau visuhavoho vavavemo laviale keau halevalu. Ige ame kosive keu Bolou Loma ata holiale ke evisi vabuanu. Kosealemo au au esemu namigevege abu Bolo umuvalu. ");
INSERT INTO kpx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Iniale vavita ame kosive keu isiviale Bolo mai Diue ataeau avuemo hoto loumale ke kaovai. Isi louge abu dibulae melavei loholu. Isi hoto hanavoge Diue dubue kosive isi kanisolo ata bahata keau lohoale usege au Bolo mai vudiabemo mamonu. ");
INSERT INTO kpx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bolou kanisolo kebia niavei abuho loui avoe, “Di haokuvuia, di uvumo toelabeu uoholige di hilokage di vaveve keau Dilava nimo duave unaha.” ");
INSERT INTO kpx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kateai louge dubue kosive baluga Ananaiasiu au esemu namigevege Bolo vavamo lavisi uale keau aivemo hamalu. ");
INSERT INTO kpx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ige Bolou kosive ke namihai avoe, “Dilavana bae ahamoi. Kosealemo a vaveve keu abu momolue golomo o beniale ke nahate. A keve ugulamoi nahie menakamo di vaveve kaovama. Isito a esemuho louge abu dahavoale kemo a menaka ke egumanu.” ");
INSERT INTO kpx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ige ata degomoleau vavavemo laviale keau avuho loui avoe, “A hoto kateale louale keu Dilava dubue kosive balugaike a ke aiohavonu.” ");
INSERT INTO kpx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ige Bolou abuho loui avoe, “Di hilokage keu dubue kosive baluga holivatebe di kateai avuho louoholinu. Kosealemo Bukae Hotou loui avoe, ‘Lainaho la nalievemale kebiaho hotoe toela lougelive.’” ");
INSERT INTO kpx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kateai louito elehasege kanisolo kebia degomoleau Sadukea ataea. Isege degomoleau Balisia ataea. Ige au baita hoai kebia namigevei avoe, “Di haokuvuia, dau di mamati Balisia ata. Iale la daemo di vaveve kaovale keu koseanu. Di hilokage haluviale keabuna hovedevei.” ");
INSERT INTO kpx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bolou kateai louge Balisia ata isi Sadukea ata keau ke evisi moleho loui itumulahai mole tasalievelu. ");
INSERT INTO kpx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mole tasalievege Sadukea ataeau loui avoe, “Haluviale keau bae hovedevelivebene. Abu haluvige munanaeabe keta uoholinu. Ige anelu kebiata uoholilu.” Keau kateai lousege Balisia ataeau abuho loui avoe, “Ba, la louale keau kateholilu.” ");
INSERT INTO kpx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kateai baita louge hotou kutikutiai ua. Isege Balisia menaka haivemale malaha moleu hovelahai loui avoe, “Malaha kou atae dua. No avuemo vavevebe toela elehaholilu. Iale mesoho alue munanaike avuho lounu. O mesoho anelu moleike avuho lounu.” ");
INSERT INTO kpx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Au kateai louge ataeau moleho itumulahai moleho baita louge ame kosiveu ke evisi huhuai avoe, “Mesoho abuna nova Bolo hamai aiohavoi.” Kateai au esemu hanavege abu lohoale ata kebia vigomo Bolo melavei ame balikie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kateimale vavimo Iesuu Boloe lohoale vavavemo lamisi namihai avoe, “Ainaho vabualive. A Dielusalema kove di hoto louale ke nahate Loma o baluga ketave di hoto lounela.” ");
INSERT INTO kpx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Vavita Diue ata degomoleau mole bevuevei igaetoai hotohotoai hoto isute loui loui avoe, “Nahi lovi i halevai e i halevai Bolo hamaito bae lovita eta isi.” ");
INSERT INTO kpx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ata bahata votiabulike (40) hoto ke huhuai loulu. ");
INSERT INTO kpx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Isime tilialeau dubue kosive isi oe kosive kebia namigevei avoe, “No hoto mole isute louale no bae onobehame ilivebene. Usege no Bolo hamaito bae lovi isi. ");
INSERT INTO kpx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Iale laeau kanisolo ata kebiahi Loma ame kosiveho hoto hanavoge au Bolo hanavoge au lohoi. Ame kosive ke namihai kosea, ‘No isiviale Bolo vaveve ke avuemo kaovai hilokai.’ Ige ame kosiveu hanavoge au lohosege no talive humaha tavae hamage au hatai.” ");
INSERT INTO kpx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kateai lousege Bolo dumuu hoto ke evisi tiale ame oe uvue deluai tiale Bolo namihanu. ");
INSERT INTO kpx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ige Bolou ame esemu mole hohavoi namihai avoe, “Mo ko melamei ame kosive balugae tige au hoto mole loui namihai.” ");
INSERT INTO kpx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ige ame esemu keu mo ke melamei au ame kosive balugae tiale namihai avoe, “Dibulae malaha mole ivi Bolo keike di hohavoi di hanavoge di mo ko melamei lohonu. Kosealemo mo kou isiviale hoto mole loui a namihai.” ");
INSERT INTO kpx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ige ame kosive baluga keu mo ke adala holisi melamei lilikateve tiale belahai avoe, “A onoleike daho louliho lohonu.” ");
INSERT INTO kpx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ige mo keu avuho loui avoe, “Diue kosiveau isivialeike nivu Bolo hanavoge au kanisolo ata kebiae tai. Kanisolo keabuna nivu a lobohavoi loui kosea, ‘No isiviale Bolo hanavoge au lohoge no avuemo vaveve kaovai hilokai.’ ");
INSERT INTO kpx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Abu kateai louge ainaho hotoeabe ke evilive. Kosealemo ata bahata voti (40) keabuna Bolo hamaliho humaha tavae hogodevei ui. Keau hoto mole isute loui loui avoe, ‘No bae onobehame ilivebene. Usege no ulive Bolo hamaito bae lovi isi.’ Keau kateale loui hemei ui isiviale au Bolo hanavoge au tai.” ");
INSERT INTO kpx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ige ame kosive keu mo ke namihai avoe, “Ainaho a loui di namihale ko loui atabe namihalive.” Isi kateai louito mo ke hanavoge tinu. ");
INSERT INTO kpx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ame kosive keu au esemu abuita hohavege abu lohoge au abuho loui avoe, “Talive tuvalie ata bahata tu handele (200) malevei osimo tiveve ata bahata seveniti (70) malevei kebia tedaeveveve ata tu handele (200) kebiata maleveve. Isi hau bahata gadehavolive vavie naini (9) okolokie hovedevei Sesaliae teve. ");
INSERT INTO kpx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Isi osi mole Boloho malive au avuemo tai. Isi avuluvuta tie dua valive gamanie kosive baluga Velisie velehovove.” ");
INSERT INTO kpx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kateai louito levaleva mole hisaliai gamani kosive baluga Velisiho hanavonu. ");
INSERT INTO kpx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Isi loui avoe, “Di kosive baluga, ana duave. Di ivilike Kalodiasi Lisiasi. Di deiada ko louge evinela. ");
INSERT INTO kpx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Diue ataeau isiviale malaha ko mai hamai. Isito di hilokage malaha keu Loma ata. Ige di di esemu holoevei tiale ke melavei ame oe loholu. ");
INSERT INTO kpx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Di ata ke vaveve kaovalihoike melamei Diue kanisolo kebiae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kebiae tiale ke kaovage malaha keu vavevebe toela vaholiale dana oleve kateai ke mai hamai o mesoho mai dibulae hanavoi. Keau Diue menaka ke unahamo hoto mai avuemo mavolu. ");
INSERT INTO kpx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ige ata moleu abu Bolo hamaveve hoto ke loui di namihaike vage di ke hanavoge ae tinu. Iale dana bae Diue ata namigevege abu talive vaveveve hoto loui a namihai.” ");
INSERT INTO kpx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Iniale vavimo tuvalie ataeau levalevave ke mai Bolota melavei tilialeau o mole Atibatasie tisege vau alamonu. ");
INSERT INTO kpx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Isege vavita tuvalie ataeau heila tiale keau hoidevei ame oe lohosege osimo tiale keau Bololuvuta tilu. ");
INSERT INTO kpx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Keau ke melavei tilialeau Sesalia oe velehovoi Bolo melavei gamani kosive baluga oe mavolu. Isi ame kosive levaleva ke mai kosive ke omilu. ");
INSERT INTO kpx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ige au levaleva ke dodavei Bolo belahai avoe, “Au oleve vata ke ata.” Ige Bolou namihai avoe, “Dau Silisia ata.” ");
INSERT INTO kpx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ige kosive keu Bolo namihai avoe, “A vaveve elehai louale keau kove lohogeto di bae a deiada evisi.” Kateai louito au esemu namigevege abu Bolo melavei kosive mole Elodiu o balugataho houale keve mai bamuho tilu. ");
INSERT INTO kpx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iniale vanie ni ada moleu uoholisege dubue kosive baluga Ananaiasiu Diue kosive degomole holoevei kotae hoto hilokamale Tetulasi keta melavei Sesalia oe tilu. Keve tiale velehovoi gamani kosive Velisi ke vudimo Bololuvuta kotalahalu. ");
INSERT INTO kpx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Isi Tetulasi namihage au hovelahai Bolo vaveve ke loui Velisi namihai avoe, “No kosive baluga, au no nibievei no hoesegevei vata komo vaveve dua vage no kemo ue dua vama. ");
INSERT INTO kpx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","A kateige no vani bahata ue dua vai a vahaeho vama. ");
INSERT INTO kpx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Iale no isiviholilu hoto moaga loui butuhaliho. Isito no hoto kohame louge evinela. ");
INSERT INTO kpx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","No malaha ko vaveve elehage malaha kou malahae toela seleve. Kena vani bahata tiniege vata bahata keve Diue ata bahata aiogevei uvuiabe igei. La hilokage Iesu keu Nasaleta ata. Iale ata kou Iesu ehovamale kebiae kosive. ");
INSERT INTO kpx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Vani mole malaha kou isivialeike Diue dubu baluga aiohavoi. Kateike vage no ko mai isiviale no menakamo vaveveve kaovai. ");
INSERT INTO kpx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Isito ame kosive Lisiasiu solekai lohoale noemo malaha ko adala holisi mai tinu. ");
INSERT INTO kpx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Isi no namigevei avoe, ‘Talive bae gamani kosive baluga Velisi kemo ko vaveve toela louve.’ Ilike vage no kove lohoale deiadave ahoe loumale kou seleve. Iale a biageu bae belahage au bae au deiada loui a namihai.” ");
INSERT INTO kpx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kateai louge Diue ataeau hotove ivi ebagevai loui avoe, “Hoto seleveike au ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Abu kateai louge gamani kosiveu Boloho loui avoe, “Hovelahai a deiadate lounela.” Ige Bolou hovelahai loui avoe, “Di hilokage au vagana moaga vata ko nalisi no ata kebiata nibievenu. Iale dana vahaehomo a vudimo lamisi di vale hoto ahoe loui. ");
INSERT INTO kpx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Di lohoale Dielusalemae velemai guliguliale vanie ni tueloau (12) aike uoholilu. Ana ata belagevege abuna seleveta di vale ke loui a namihai. ");
INSERT INTO kpx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Di Diue dubu baluga keve guliguliale vavevebe toela vaholisi kebia aiogevei hotobe toela abuho louholisi ebouamaleve mesoho heie vaveve katealebe vaholinu. ");
INSERT INTO kpx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Iale ata koeau daemo hotoe toela louale abuna oleve kateai hoto ke ihu mai selevetisi. Keu abuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Koeau no buluvebia Dilava hoesehavoi Moseseu hisaliale isi belovetaeau hisaliale ke ehovage dataike kebia ehovema. Isito Iesu humaha seleveike dau ehomai hoesehavoma. Ige abu loui avoe, ‘Iesu humaha keu loboe humaha.’ ");
INSERT INTO kpx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Isito di hilokage ata kobiata hilokage atae toela, atae dua haluviale keabuna bae hovedevei. ");
INSERT INTO kpx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Katealemo di isiviale di uvu hoesehavoi vani bahata Dilava nimo isi atae nitamo negobedai vaveve dua unaha vagei. ");
INSERT INTO kpx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Di vagana moaga Dielusalemae tioholinata tiale keu koseanu. Di moni malei di ata seleve kebia ovege uoholige di halevei dubue tiale mesia havei Dilava hoesehavonu. ");
INSERT INTO kpx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Di keve ui atabe aiohavoholisi vaveve ke vai di ebika hoesehavoniale uoholisege abu di vaveve elehai hilokalu. ");
INSERT INTO kpx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Isito Diue ata degomoleau Esia vatamo lohoale keau abege loholive a vudimo lavisi di vale ke loui a namihai. Isito keau lohoholilu. ");
INSERT INTO kpx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Iale kobia namigevege abu subuta kanisoloe vudimo di vaveve kaovage di vavevebe toelau uoholiale ke loui a namihai. ");
INSERT INTO kpx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Isito kateimalela di kebiaho baita loui kosea, ‘La di mai kove lohoale keu koseanu. Di hilokage haluviale keabuna bae hovedevei.’” ");
INSERT INTO kpx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bolou kateai louge Velisiu abu Iesu vaveve loui namihalemo Boloemo kotaveve ke halei ata namigevei avoe, “Usege ame kosive Lisiasiu lohogeto di bae tota kotaveve deiada loui la namigevei.” ");
INSERT INTO kpx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kateai louito au esemu namigevei avoe, “Bolo melavei talive dibulae bamuito lainaho avuemo dibulae vaveve ke nahate valive. Haokuvuiabeau isiviai tedahoho vage kelueve halevaito isiviabe ke vave.” ");
INSERT INTO kpx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iniale vani degomoleau uoholisege Velisiu abu mahina Dulusilati loholu. Mahinave keu Diue keate. Iale keau lohoale louge abu Bolo melavei tige Bolou Iesuemo evievi mavoveve ke loui haivenu. ");
INSERT INTO kpx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Isi namigevei avoe, “Uveve dua vai la isivi unaha va halevaito Iesu isivi ke vave. Kosealemo Dilavana bae vatae atae vaveve bahata kaovai.” Kateai louge Velisiu vabuai namihai avoe, “Halei talive di vani maniege a hohavoge tota lohonela.” ");
INSERT INTO kpx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kateai loui isiviale Bolou moni omige au iomage au tai. Kateai lohomale vani igaegaela Bololuvuta hotohotoai namihama. Isito Bolou monibe omioholinu. ");
INSERT INTO kpx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kateilage vagana abuitaeau uoholige gamani kosive mole Bosiasi Vesitasi keu Velisi lovo manu. Isege Velisiu Diue atae isivi vai dibulae Bolo halenu. ");
INSERT INTO kpx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Iniale vanie ni abuita igaetaeau uoholige kosive nehe Vesitasiu au o Sesalia halei Dielusalemae tinu. ");
INSERT INTO kpx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tiale keve velemage Diue dubue kosive isi oe kosive degomoleau avue lohoale Bolou vamale deiada ke loui namihalu. ");
INSERT INTO kpx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Namihai avoe, “Ana vali Bolo hanavoge au Dielusalemae lohoi.” Abu hoto ke loui isivialeike Bolou lohosege abu humaha tavae hamai. ");
INSERT INTO kpx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Abu kateai louge kosive keu namigevei avoe, “Bolou aike Sesaliae dibulamo uale di hoilahai tiveveu vuguvuguanu. ");
INSERT INTO kpx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ialelua la oleuoleu vuvune malealeau daluvuta Sesaliae talive keve Boloemo vavevevebe toelau uge kaovave. ");
INSERT INTO kpx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Vesitasiu deiada kateale louge uoholige au abuhi ui bula mole ke vaito bula mole ke uvue halevei Sesaliae tinu. Iniale vavita au kotamale keve ugulamoi louge abu Bolo melavei loholu. ");
INSERT INTO kpx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lohoge Diue ataeau Dielusalemamo lohoale keau Bolo mai evilikahavoi au vaveve degomole vaeveholimale ke loulu. Abu kateai hoto ke mai selevetiveve humahadau uoholinu. ");
INSERT INTO kpx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kateige Bolou hotoeabe hamai loui avoe, “Dau Diue menaka isi dubuiabe aiohavoholisi Loma kosive baluga Sisa keta di aiohavoholinu.” ");
INSERT INTO kpx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kateai louge Vesitasiu isivialeike Diue atae isivi vai. Kateai Bolo namihai avoe, “Ana isiviage naiti Dielusalemae talive keve kotalahai bae hoto ko inutolotolohavoi.” ");
INSERT INTO kpx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ige Bolou avuho loui avoe, “Di bae keve talivebene. Loma gamani balugau kotamale komo dana di vaveve bahata louge au uoholisi. Di hilokage dau vavevebe toela Diue ata kebiamo vaholige ata di vaveve ke hilokanu. ");
INSERT INTO kpx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Iale mesoho di vaveve toela vai menaka aiohavoge a dahamoge di hatige keta duave. Isito di vaveve toela vaholisege a bae di mai ata kobia ovelivebene. Di isiviale Loma gamani kosive baluga Sisa keu di deiada evisi.” ");
INSERT INTO kpx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kateai louge Vesitasiu au esemuhi hotohotoai gabiai Boloho loui avoe, “Duave. A isivialeike Loma kosive balugau a hoto evisi. Iale dana a hanavoge avue tenela.” ");
INSERT INTO kpx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vani mole Kini Agilibau abu amakini Benisiti Sesaliae deiai Vesitasie loholu. ");
INSERT INTO kpx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Lohoale vani degomole avuluvuta usege au Bolo deiada loui Agiliba namihai avoe, “Di Velisi lovo mage au dibulae ata mole halege keu ua. ");
INSERT INTO kpx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ige di vani mole Dielusalemae tige Diue dubue kosive isi oe kosive degomole keau daemo ata ke vaveve kaovai isiviale di ke hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ige di kebia haivei kosea, ‘Keu Loma gamani vaveve holioholinu. Iale vasohuta mole vudimo lavisi mole vaveve kaovai kotalahai ke hilokaito bae hamave.’ ");
INSERT INTO kpx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Iniale abu kove kotaho lohoge di vavita solekai tiale kotamale keve ugulamoi louge abu malaha ke melavei dae loholu. ");
INSERT INTO kpx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Isi lohoge Diue ataeau hovedevei vaveveve toela louge di huhuai kosea, ‘Mesoho abuna malaha ke vaveve toela baluga loui.’ Isito abu kateholilu. ");
INSERT INTO kpx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Isito abu guliguliamale ke hoto unaha louma. Ige Bolou malaha mole Iesuu hatiale kemo loui avoe, ‘Keu hovelahanu.’ ");
INSERT INTO kpx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Abu kateige di dolodoloai huhuai kosea, ‘Dana oleve kateai hoto kobia ihu hilokaevei.’ Isi kateai Bolo namihai kosea, ‘Ana isiviage naiti Dielusalemae talive kotalahai hoto ko ihu kaovai.’ ");
INSERT INTO kpx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ige keu katealiho isiviholisito isiviale tige Loma kosive balugau bae deiadave evisi. Ige di iomage au dibulae usege di au tiveve ke humahada kaovama.” ");
INSERT INTO kpx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Velisiu hoto kateale loulage Agilibau namihai avoe, “Di isivialeike data malaha ke hoto evisi.” Ige au avuho loui avoe, “Duave. Nivu loholive bae hotove evinela.” ");
INSERT INTO kpx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Iniale vavita Agilibau Benisiti Bolo elehaliho lohoge ata moagaeau lohoale isiviale kosive kebia vaveve elegevei. Ige ame kosiveau oe kosivehi bahata igaetoai loholu. Kateisege Vesitasiu hoto hanavoge abu Bolo melavei loholu. ");
INSERT INTO kpx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ige Vesitasiu loui avoe, “Kini Agiliba isi la bahataea, malaha ko elehave. Kove isi Dielusalema keve Diue ataeau malaha ko vaveve toela loui di namihai isivialeike di ata ko hamage au hatai. ");
INSERT INTO kpx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kateige di ata ko vaveve kaovage vavevevebe toelau uoholige di hamaveve ke humahadau uoholinu. Isito biageu isiviale Loma kosive baluga elehai au deiada loualemo dana iomage auna tai. ");
INSERT INTO kpx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Isito dana hanavoniege hoto vade toleai Loma kosive haivui. Kateike di vaime mai lae lohonu. Iale Kini Agiliba, di isiviale neniai ata ko hoto evisi bae tota di haivuge di Loma kosive balugaho levaleva toleai haivui. ");
INSERT INTO kpx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kosealemo di dibulae atae vaveve toela hilokaholisito levaleva hisalikavai hanavoale keu daemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Vesitasiu kateai louge Agilibau Bolo namihai avoe, “Di a namihama. A biageu hovelahai a deiada lounela.” Ige Bolou hovelahai au ada ebagemai loui avoe, “Kini Agiliba, di deiada ko louge evi. ");
INSERT INTO kpx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Di a vudimo lamisi Diue ataeau daemo loumale ke loui a haivui vahaehoanu. ");
INSERT INTO kpx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kosealemo di hilokage au Diue menaka isi vaveveabe ke hilokale di isiviale kabebi haleito di louale ke evinela. ");
INSERT INTO kpx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Di esebuluta ui lohoale ke bahata Diue ataeau hilokalu. Isi di vata seleve uniale kosi holisi halei lohoale Dielusalemae uale ke bahata abu hilokalu. ");
INSERT INTO kpx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Iale abu hilokale ke abuna louge keu duave. Abu hilokage dau Balisia ata. Iale Balisia keau Diue menaka kebia ehovei vaveveabe kemo negoai ke vama. Ige data vaveveabe kemo negoai ke vama. ");
INSERT INTO kpx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Iale di nova lamisi kotamale keu koseanu. Di huhuige Dilavau subuta no buluvebiaho louale keike lohoale nova velemanu. ");
INSERT INTO kpx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iale hoto ke igaeike Diue valada tuelo (12) keau ke kaovai vavita gututa Dilava hoesehavoi isivialeike ke mai. Diue ataeau di mai kotalahale keu di menakaeabe aiohavoholisito hoto nehe ke igae no abuhi ehovamale keike di louge abu di mai kotalahalu. ");
INSERT INTO kpx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Iale Iesuu hatai hovelahale hoto kemo la osiohoike dolodololahalu. Ose la huhuige Dilavau haluviale kebia tatuveveve keu avuemo anekianu. ");
INSERT INTO kpx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Di subuta huhuai kosea, ‘Dana vaveve toela moaga vai Nasaleta ata Iesu ke ivi aiohavoi.’ ");
INSERT INTO kpx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Isi kateai subuta Dielusalemae ui vaveve kateimale vai Diue kosivebiamo vuvune malei Iesu ata kebia aiogevei malei dibulae otovema. Kosealemo kosive keau isiviale evievi ata kebia havege abu haluvisi. Ige data katealeho isivianu. ");
INSERT INTO kpx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Vani degomole di no dubu moagae timale Iesu ata kebia kaovei malevei aiogevei isivialeike abu Iesu ehovamale ke halevai. Isi dana itumu baluganiege tiniege o degomole keve kebia degomoleta aiogevegei.” ");
INSERT INTO kpx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Di kateai vani mole isiviai talive dubue kosivebiamo vuvune malei Damasikasi oe talive ata katealebia aiogevei. ");
INSERT INTO kpx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Isi kateai tiale keu humahada tavae vanie lilimo tisege ataga baluga vanie ni ke evihaleu daemo halui daluvuta tiale kebiatamo halunu. ");
INSERT INTO kpx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ige no bahata vatamo dobuluvisege da igaeu Diue hotomo hoto mole evige au loui avoe, ‘Solo, Solo, a osiohoike di aiohavoma. A di ata aiogevemale kemo onoinata a ebikata aiohavoma.’ ");
INSERT INTO kpx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ige di hoto ke evisi loui kosea, ‘Kosive, ole a.’ Ige au loui avoe, ‘A di aiohavomale Iesu ke dalike. ");
INSERT INTO kpx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Iale hovelahai laminela. Di ae lohoi isiviale au di esemu holisi a nova elehale ko loui ata haivei di gabie onole vaveve a haivuge keta loui ata haivenela. ");
INSERT INTO kpx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isege dana bae Diue ata isi Diue ata holioholiale kebiamo a tedahoi a hanavoge kebiae tenela. ");
INSERT INTO kpx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kebiae tiniege niabe alavoge abuna vavie vaveveta Setene vaveveta halevai atagae vaveve vai Dilava ehovai. Abuna kateale vai abu evievi mai daemo mavoge dana vaveveabe toela ulihage abuna otogoe tai Dilavau au ata maleveale kebiahi ui.’” ");
INSERT INTO kpx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Bolou kateai loui Kini Agiliba namihai tota loui avoe, “Hoto keu otogomo lohoge di ke kabebihavoholisito evinu. ");
INSERT INTO kpx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Di ke evisi vasohuta tiale Damasikasi ata haivei halei tiale Dielusalemae velemai ata haivenu. Isi Diue ata isi Diue ata holioholiale kebia vata bahatae tiale haivei namigevei kosea, ‘La vaveve toela halevai Dilava ehovai vaveve dua vage auna ke elehai huhuige laeau ekalesia seleve.’ ");
INSERT INTO kpx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Katealemoike di vani mole Diue dubu baluga keve usege abu isiviale dahavoge di hatai. ");
INSERT INTO kpx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Isito kateimalela Dilavau di tedahoge di aike uniale hotove loui vatae kosive isi ata bahata kebia haivema. Subuta beloveta degomole isi Mosese keau louale nahateike di loui ata haivema. ");
INSERT INTO kpx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Abu loui avoe, ‘Kelisona hatiniege tota hatihatimo hovelahai ukolikolie hoto loui Diue ata isi Diue ata holioholiale kebia haivege abuna kemo lulelelahai.’ Iale ke nahateike data louma.” ");
INSERT INTO kpx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bolou hoto kateale louge Vesitasiu baita avuho loui avoe, “Bolo, ana tilogoanu. Mesoho a lulele moaga kaovalage a kinau toelanu.” ");
INSERT INTO kpx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ige Bolou avuho loui avoe, “Kosive, di tilogoholisito hoto seleveike di ke lounu.” ");
INSERT INTO kpx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kateai louito Kini Agiliba namihai avoe, “Di huhuige vaveve ko bahataeau hogodeveholige a vaveve bahata kobia hilokaevenu. Iale di vabuoholisito momoleai hoto ko louma. ");
INSERT INTO kpx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Iale Kini Agiliba, ana belovetaeau louale ke evisi manu. Di huhuige a ke evisi manu.” ");
INSERT INTO kpx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kateai louge Agilibau namihai avoe, “Bolo, a huhuige ana valive hotoe esehame kemo di mage di evievi ata holisi Dilava ehomai.” ");
INSERT INTO kpx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ige Bolou namihai avoe, “Hotoe esehame mesoho hoto baluga keta duave. Isito di Dilava imihai isiviale a isi ata bahata komo ualeau da nahate vai evievi ata holisi Dilava ehovai. Di katealeho Dilava imihaito isiviholinu la seimita di ada umuvale ko nahate valiho.” ");
INSERT INTO kpx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Bolou kateai louge gamani kosive Vesitasi, Kini Agilibau abu amakini Benisiti isi esemuiabe bahata keau hovedevei heie tilu. ");
INSERT INTO kpx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Heie tiale mole namigevei avoe, “Malaha kou vavevebe toela vaholiale nahiabuna ol