﻿USE sofia;
DROP TABLE IF EXISTS sofia.kpw_vpl;
CREATE TABLE kpw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kpw_vpl WRITE;
INSERT INTO kpw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais nap nɨhi iƚaŋ nɨpe gau rɨklö rɨk amɨl apɨl göm nɨp yag daula rö hagnɨg gabin. Bɨ kub Ebraham rɨkö rɨk damöm, kiŋ Depid nɨp yag daula. Depid nɨpe rɨkö rɨk damöm, Jisas Krais nɨp yag daula. ");
INSERT INTO kpw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Anɨg gɨla: Ebraham Aisak nɨp yag daua. Aisak Jekop nɨp yag daua. Jekop nɨpe pen, Juda nɨp rɨköm, nɨmam hain magö u agɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda nɨpe nɨbi Dema aip mɨdöm, Peres aip Sera aip kalɨp yag daua. Peres, Hesron nɨp yag daua. Hesron, Ram nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, Aminadap nɨp yag daua. Aminadap, Nason nɨp yag daua. Nason, Salmon nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Boas nɨp yag daua. Boas nɨme nɨpe u Rehap. Boas, Obed nɨp yag daua. Obed, nɨme nɨpe u Rud. Obed, Jesi nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi, kiŋ Depid nɨp yag daua. Depid, Solomon nɨp yag daua. Solomon nɨme nɨpe u, nöd bɨ ne Yuraia nɨp udö umö, hainö Depid nɨp udöm me, Solomon nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, Riaboam nɨp yag daua. Riaboam, Abaija nɨp yag daua. Abaija, Esa nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa, Jihosapad nɨp yag daua. Jihosapad, Joram nɨp yag daua. Joram, Asaia nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia, Jodam nɨp yag daua. Jodam, Ehas nɨp yag daua. Ehas, Hesekaia nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia, Manasa nɨp yag daua. Manasa, Emos nɨp yag daua. Emos, Josaia nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia, Jekonaia nɨp yag dapöm, nɨmam rɨmnap yag daua. Ñɨn anɨbu, daun kub Babilon nɨbi bɨ apöm, Isrel nɨbi bɨ kalɨp nagɨ lɨ dam Babilon ud arla. ");
INSERT INTO kpw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ud areila, Jekonaia anɨb gau mɨdöm, Sialdiel nɨp yag daua. Isrel nɨbi bɨ kale Babilon arö göm ram mɨnöŋ Juda ado gɨ arla u, Sialdiel, Serababel nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel, Abaiad nɨp yag daua. Abaiad, Eliakim nɨp yag daua. Eliakim, Eso nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso, Sedok nɨp yag daua. Sedok, Ekim nɨp yag daua. Ekim, Elaiad nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiad, Eliesa nɨp yag daua. Eliesa, Madan nɨp yag daua. Madan, Jekop nɨp yag daua. ");
INSERT INTO kpw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop, Josep nɨp yag daua. Josep me, nɨbi Maria nɨp ñeila. Maria nɨpe Jisas nɨp yag daua. Jisas nɨp Krais a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Anɨb u me, bac hon Ebraham nɨpe rɨkö rɨklö rɨk dam dapɨl göm unbö sɨduŋ böŋ daŋ ara u, hainö bac kiŋ Depid nɨp yag daula. Yag daulö, Depid nɨpe pen rɨkö rɨklö rɨk dam dapɨl göm u rö nöp sɨduŋ böŋ daŋ areia, hainö Babilon bɨ ke gau nɨbö apöm kalɨp nagɨ lɨ dam ram mɨnöŋ kale u ud arla. Ud areila, hainö pen kauyaŋ rɨk dam dapɨl göm unbö sɨduŋ böŋ daŋ ara u, hainö Krais nɨp yag daula. ");
INSERT INTO kpw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais nɨp yag daula manö u hagnɨg gabin. Jisas nɨme Maria, Josep nɨp ñeila, nɨpe aip ajmil wasö, kale nɨŋla Maria ñɨ mudun mɨdeia. Ana Uɫ nɨpe u ke gö, ñɨ mudun anɨbu mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pen nugmul nɨpe Josep bɨ aij u me, manö kub hagaga; gasɨ u nöp nɨŋöm haga, “Ñɨ mudun mɨdöp anɨbu, nɨbi bɨ gau hag ñɨnabin, nɨp nable gɨnab. Anɨb u, agamɨj hag yuɨn,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep anɨg nɨŋa u pen, sɨbön yaŋ uhön nɨŋa, Bɨ Kub ejol nɨpe ap nɨp haga, “Josep, Depid ñɨ nɨpe! ‘Nɨbi anɨbu, nɨhön gɨnɨg udnam?’ a gɨmön, gasɨ u nɨŋagmön; haƚöwaƚö udmön. Ñɨ mudun mɨdöp u, Ana Uɫ u nöp gö mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hainö ñɨ u rɨk dauö nɨpe kub göm, nɨbi bɨ nɨpe gau nan si nan naij gɨpal prɨ u ƚɨk gɨ yunab u me, hib nɨpe Jisas a gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Anɨg ga anɨbu, Bɨ Kub nɨpe bɨ manö nɨpe hagep bɨ ap nɨp hag ña nɨŋöm nɨpe pen anɨg gɨnab a göm haga. ");
INSERT INTO kpw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nɨpe haga, “Nɨbi praj bɨ ap aip ajöm wasö, ñɨ mudun mɨdöm, ñɨ ap yag daueinab, hib nɨpe u Emanyuel a gɨnaböl,” a ga. Emanyuel manö iƚ u, God hon aip mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pen Josep uhön hanöm uraköm, Bɨ Kub ejol nɨpe manö haga u udöm, nɨbi Maria nɨp udnam, a göm nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nöd Josep Maria aip ajmil wasö, Maria ñɨ u yag dauö, Josep ñɨ anɨbu hib nɨpe Jisas a göm me, Maria nɨp böŋ nöp uda. ");
INSERT INTO kpw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pen Herod Judia Propins kiŋ mɨdmɨdöp ñɨn u, Maria Jisas nɨp yag daua Bedlehem daun, ram mɨnöŋ Judia aŋ au. Yag dauö, bɨ gapɨ kɨd hiɨk nɨŋeb gau, sɨdö auab lau nɨbö Jerusalem apöm, nɨbi bɨ gau hag nɨŋöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda nɨbi bɨ, Kiŋ hon, a gɨpim u nɨp yag daubal! Mɨñi lɨbal mɨdöp gaiŋ Hon ram mɨnöŋ hon sɨdö auab lau nɨbö gau mɨdun nɨŋbun gapɨ u waielöp; nɨŋun me, hib nɨpe hagno adö araŋ a gun aubun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Anɨg hageila, kiŋ Herod manö anɨbu nɨŋöm, nɨbi bɨ gai i kale ñɨ anɨbu nɨp gasɨ nɨŋöm yɨp nɨŋagöl rö löp, a göm, gasɨ iru nɨŋa. Jerusalem nɨbi bɨ gau magöŋhalö u rö nöp gasɨ iru nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pen kiŋ Herod, God nɨp nan sabe gep bɨ kub gau abe, God lo manö hag ñeb bɨ gau abe, kalɨp wɨñ alö aueila haga, “God manö hagep bɨ gau Krais nɨp yag daunaböl ram mɨnöŋ gai, a gɨla?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Anɨg hageia hagla, “Bɨ God manö hagep ap, hadame nöp manö kalɨ kƚiñ rɨköm haga rö, nɨp yag daunaböl Bedlehem daun, ram mɨnöŋ Judia aŋ au. God manö hagep bɨ anɨbu God Manö kalɨ kƚiñ rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ram mɨnöŋ Judia aŋ gau ram mɨnöŋ ke ke iru mɨdöp u me, ram mɨnöŋ Bedlehem nɨŋö pro rö lɨnab u pen Bɨ Kub u ram mɨnöŋ anɨbu nɨbö apöm, nɨbi bɨ yad Isrel nɨbi bɨ kalɨp abad mɨdeinab. Anɨg gɨnab rö, Bedlehem hib kub mɨdeinab,’ a ga,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Anɨg hageila, kiŋ Herod nɨŋöm, am bɨ gasɨ kɨd hiɨk nɨŋeb gau kalɨp agamɨj wɨñ alö aueila haga, “Magö mai rö gapɨ anɨbu waiela?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hageia, nɨp manö anɨbu hag ñeila, kalɨp Bedlehem hag yuöm pir alöm haga, “Kale am ñɨ anɨbu uƚhai nɨŋ aij gɨmim, ado gɨ apim yɨp hagpe, yad abe amem hib nɨpe hagnö adö araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋ Herod anɨg hagö, kale hadlö nɨŋöl gɨ, gapɨ kale sɨdö auab lau nɨŋla u nöd nöd gö nɨŋöl gɨ, kale hain gɨla. Gapɨ u am am, ñɨŋaŋ u ram mɨdeia aŋ au gɨlaŋ nöp pɨdöŋ ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Anɨg gö kale nɨŋlö, aij a gö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ram raul mɨgan yaŋ amöm nɨŋla, ñɨŋaŋ u nɨme Maria aip mɨdailö. Kale am kugom yɨmöm, ñɨŋaŋ u hib haglö adö areia nɨŋöm, wadɨ kale gau aŋa löm, nɨp nan aij rɨmnap ñɨla. Gol rɨmnap, pauda haƚɨŋ aij auep rɨmnap, wel haƚɨŋ aij auep rɨmnap ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pen kale sɨbön aŋ yaŋ hanöm uhön nɨŋla, God haga, “Ado gɨ Herod mɨdöp u aragmim!” a ga. Anɨb u, haga rö nɨŋöm, adan mɨlö ap aramöm, ram kale ado gɨ arla. ");
INSERT INTO kpw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pen bɨ gasɨ kɨd hiɨk nɨŋeb gau kale anɨg göl arla nɨŋöl gɨ, Josep uhön nɨŋa, ejol ap apöm nɨp haga, “Herod ñɨŋaŋ u al pak lɨnam a göm, uƚhai nɨŋnɨg gab. Anɨb u, ñɨŋaŋ amɨl mɨhau yɨŋɨd uɫ gɨ, pɨñɨŋ gɨ ram mɨnöŋ Ijip armön. Aumön a geinam nöp, kauyaŋ ado gɨ aumön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hagö, Josep sɨbön aŋ yaŋ nöp uraköm, ñɨŋaŋ amɨl mɨhau uɫ gɨ ram mɨnöŋ Ijip ara. ");
INSERT INTO kpw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Uɫ gɨ ara anɨbu, Bɨ Kub nɨpe bɨ manö nɨpe hagep ap nɨp hag ña nɨŋöm nɨpe pen kalɨ kƚiñ rɨköm haga, “Ñɨ yad u Ijip nɨbö wɨñ alnö auöp,” a ga. Pen Josep amɨlap am Ijip nöp mɨdlö, Herod umaia me, hainö kauyaŋ ado gɨ aula. ");
INSERT INTO kpw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pen Herod nɨpe nɨŋa, bɨ gasɨ kɨd hiɨk nɨŋeb gau, nɨpe haga rö gageila, nɨp mulu kal yabɨƚ lugö haga, “Yɨp gɨpal anɨbu, ñɨŋaŋ bɨ kub mɨdnɨg gab u yad aigö gɨ gem nɨp al pak lɨnam?” a göm nɨŋa. Pen nɨpe gasɨ ap nɨŋöm haga, “Bɨ gasɨ kɨd hiɨk nɨŋeb gau kalɨp gapɨ u waiela ñɨn u, yɨp hag aij göm arla. Anɨb u yad nɨŋbin, Bedlehem söl au ñɨŋaŋ yag daulö, mɨ mɨhöp lugöp gau abe, ñɨŋaŋ hainö yag daubal gau abe, al pak lɨnaböl u, ñɨ anɨbu abe al pak lɨnaböl,” a ga. Anɨg hagöm me, bɨ nɨpe rɨmnap hag yuö amöm, ñɨŋaŋ Bedlehem söl au mɨdeila magöŋhalö al pak lɨ hakla. ");
INSERT INTO kpw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bedlehem ñɨŋaŋ al pak lɨla anɨbu, bɨ God manö hagep Jeremaia gɨnab a göm kalɨ kƚiñ rɨka rö nöp gɨla. Jeremaia manö anɨbu kalɨ kƚiñ rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama daun au mög gö, manö hauƚ kub göm, mɨɫöŋ kub gɨnaböl. Nɨbi Resel rɨkö, rɨklö rɨk amɨl apɨl gɨnab gau, mög gö mɨɫöŋ gɨnaböl. Ñɨ kale um hakla nɨŋöm nɨbi bɨ rɨmnap kalɨp hag udöl rö lagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pen hainö bɨ kub Herod umö, Josep Ijip gau mɨdöm hanöm uhön nɨŋa, Bɨ Kub ejol nɨpe ap apöm nɨp haga, ");
INSERT INTO kpw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bɨ ñɨŋaŋ al pak lɨnɨg geila gau hadö umbal u me, nabin amɨl mɨhau kalɨp uɫ gɨ, ado gɨ ram mɨnöŋ Isrel armön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hagö, Josep ñɨŋaŋ amɨl mɨhau uɫ gɨ, ado gɨ Isrel ara. ");
INSERT INTO kpw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pen amjakö, manö ap hagla, “Herod umö, ñɨ nɨpe Akeleas Judia Propins nɨbi bɨ kalɨp abad mɨdöp,” a gɨla. Hageila, Josep nɨpe Akeleas mɨdöp ram mɨnöŋ anɨbu nɨhön gɨnɨg arnam a göm, pɨñɨŋ ga u pen, hanöm uhön nɨŋa God nɨp haga, “Ram mɨnöŋ Judia ado gɨ aragmön, ne ram mɨnöŋ Galili armön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hagö, Josep ñɨŋaŋ amɨl mɨhau kalɨp uɫ gɨ Nasared daun aramöm mɨdmɨdal. Arla anɨbu, bɨ God manö hagep gau anɨg gɨnab a göm kalɨ kƚiñ rɨkla rö nöp ga. Kale kalɨ kƚiñ rɨköm hagla, “Nɨp bɨ Nasared nɨbö ap, a gɨnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nasared mɨdeila ñɨn aŋ anɨbu, Jon bɨ ñɨg pak ñeb u apöm, ram mɨnöŋ Judia aŋ au, ram mɨnöŋ nɨbi bɨ iru mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau mɨdö nɨŋöl gɨ, nɨbi bɨ gau aulö, nɨpe kalɨp manö hag ñɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kalɨp hag ñöm hagmɨdöp, “Söl mɨdöp, God nɨbi bɨ udöm abad mɨdeinab. Anɨb u, nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun a gɨmim, arö gɨmim,” a gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon kalɨp manö hag ñɨmɨdöp anɨbu, bɨ God manö hagep Aisaia hadame nöp gɨnab a göm, kalɨ kƚiñ rɨka rö nöp ga. Aisaia manö anɨbu kalɨ kƚiñ rɨköm haga, “Bɨ ap, ram mɨnöŋ nɨbi bɨ iru mɨdagpal, ram mɨnöŋ kabö nöp mɨdöp aŋ au am mɨdöm, wɨñ alöm hagnab, ‘Bɨ Kub u auab! Adan sɨr u gɨlaŋ gɨyaŋ gɨ mɨdainɨm gau, dum goƚ pɨƚu gɨ mɨdainɨm gau, bɨnɨg ral aij gɨ mɨdaimim,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pen Jon waƚɨj nɨpe u, kaj kamel uŋ udöm gɨla waƚɨj ap yɨmöm, kaj kau hañ dip nagɨ aŋ u pɨg lɨmɨdöp. Nan ñɨŋeb nɨpe u, joŋ habƚadɨŋ u abe, bom ñɨg u abe ñɨŋmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ñɨn anɨbu, Jerusalem nɨbi bɨ mɨdeila gau abe, nɨbi bɨ ram mɨnöŋ Judia yöp anɨb gau mɨdeila gau abe, ñɨg Jodan söl gau nɨbi bɨ mɨdeila gau abe, kale magöŋhalö Jon mɨdeia au arla. ");
INSERT INTO kpw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jon mɨdeia au amöm, nan si nan naij gɨla gau waiö hag payɨk pe gɨlö nɨŋöl gɨ, Jon kalɨp ñɨg Jodan aŋ au ñɨg pak ñɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pen bɨ Perisi gau abe, bɨ Sadyusi gau abe iru nöp, Jon hanɨp ñɨg pak ñaŋ a göm aueila, Jon kalɨp sɨƚɨk hag göm haga, “Kale haiŋo ñɨ pai gai i! Gasɨ nɨhön nɨŋmim pɨñɨŋ gɨ aubimŋ ‘Ñɨg pakno, God nɨbi bɨ ke nɨbö gau kalɨp hag gɨnab ñɨn u, hanɨp hag gagnab,’ a gɨmim, pɨñɨŋ gɨ aubim aka? ");
INSERT INTO kpw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kale ñɨg paknɨg gɨnabim u, nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨmim, mɨd aij gɨmim. Anɨg geinabim me, nɨbi bɨ nɨŋnaböl, kale nan si nan naij gɨmɨdim u hadö arö gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pen kale gasɨ ap nɨŋmim, ‘Hon bac iƚaŋ Ebraham ñɨ pai nɨpe mɨdpun nɨŋöm God hanɨp nan naij ap gagnab,’ a gɨmim, gasɨ u nɨŋagmim. Ebraham ñɨ pai nɨpe mɨdpun a gɨpim u nan yɨharɨŋ! God kabö gai i udöm, Ebraham ñɨ pai nɨpe gau gɨ lɨnɨg göm, gɨ lɨböp! Anɨb u, ‘Bɨ aij Ebraham rɨköm rɨk amɨl apɨl göm hon ke rɨk dap lɨbal,’ a gɨpim u, manö u rö hagagmim. ");
INSERT INTO kpw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Nɨŋ aij gɨmim! God mab u iƚ halö rɨb junɨg, ru u mab iƚ yaŋ kɨd gɨ mɨdöp. Mab ap magö ñɨŋeb aij rɨmnap pɨlagnab u, rɨb gɨ dö gɨ ud mab inab yaŋ yunab. ");
INSERT INTO kpw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kale nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun a gɨmim, arö gɨmim me, yad kalöp ñɨg nöp pak ñɨnabin. Pen bɨ yɨp hain aunab u, nɨpe yad rö wasö; nɨpe bɨ kub yabɨƚ, yad bɨ pro. Yad nɨp nɨŋnö nable gɨnab. Ma hañ nɨpe ud ajeinam rö lagöp. Yad kalöp ñɨg nöp pak ñabin, pen bɨ anɨbu nɨpe apöm, kalöp Ana Uɫ u pak ñöm, mab mɨɫaŋ pak ñöm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Nɨpe wid magö po gö, rɨk dap pakpal rö u gɨnɨg gab. Wid magö ñɨŋeb gau ke löm, wid cög naböŋ naböŋ gau ke lɨnab. Anɨg göm, wid magö ñɨŋeb nɨpe gau dam ram raul mɨgan au lɨnab; pen naböŋ naböŋ gau dam mab pör inmɨdöp u launab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñɨn anɨbu, Jisas nɨpe, Jon yɨp ñɨg pak ñaŋ, a göm, ram mɨnöŋ Galili arö göm, ñɨg Jodan aramöm, ");
INSERT INTO kpw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon nɨp haga, “Yɨp ñɨg pak ñɨ,” a ga. Hageia, Jon haga, “Ne nöp me yɨp ñɨg pak ñɨbnap. Pen yad aige gem nöp ñɨg pak ñɨnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hageia, Jisas haga, “Ne hagabön u arö gɨmön, yad hagabin rö nöp gul me, God hagöp hagöp rö nöp gɨnabul,” a ga. Hageia Jon, “Nɨŋö hagpan,” a göm, Jisas nɨp ñɨg pak ña. ");
INSERT INTO kpw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nɨp ñɨg pak ñö nɨŋöl gɨ, Jisas ñɨg goƚ au laŋ apöm nɨŋa, kumi kabö adö laŋ mɨgan pɨral hiɨkö, God Ana u yaur dapo rö u gɨ nɨp aua. ");
INSERT INTO kpw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Anɨg göm auö nɨŋöl gɨ, manö ap kumi kabö adö laŋ nɨbö apöm haga, “Ñɨ aij anɨbi, ñɨ mɨdmagö yad yabɨƚ. Yad nɨp nɨŋnö, yɨp aij yabɨƚ göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ñɨn anɨbu God Ana u, Seden nɨbi bɨ gau kalɨp pör gɨmɨdöp rö, Jisas nɨp u rö nöp gɨnɨm a göm, Jisas nɨp uɫ gɨ, ram mɨnöŋ nɨbi bɨ mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdöp aŋ gau ud arö, Seden nɨpe Jisas nan si nan naij rɨmnap gɨnɨm aka göm ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas ram mɨnöŋ nöp aŋ anɨb gau nan ñɨŋöm wasö, ñɨn unbö ñɨn juöl mɨhöp (40) mailö abe sɨbön abe yɨharɨŋ nöp mɨdeia. Anɨg göm yɨharɨŋ nöp mɨdö, nɨp kɨyö kub yabɨƚ u gö, ");
INSERT INTO kpw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seden Jisas nɨp gasɨ ñɨnö, naij gɨnɨm a göm apöm, Jisas nɨp haga, “Yad God Ñɨ nɨpe mɨdpin a gɨpan u, kabö gai i hagö, bred rö laŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hageia, Jisas pen haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘Nɨbi bɨ gau, bred nöp ñɨŋöm kamɨŋ mɨdageinaböl; God manö hagöp anɨbu magöŋhalö nɨŋ udöm me, kamɨŋ mɨdeinaböl,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas anɨg hagö, kɨjaki Jisas nɨp uɫ gɨ dam daun kub uɫ Jerusalem amöm, God sabe gep ram i adö gɨlaŋ gɨla u löm haga, ");
INSERT INTO kpw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Yad God Ñɨ nɨpe mɨdpin a gɨpan u, ujaŋdi mɨnöŋ yaŋ lɨ. God Manö u kalɨ kƚiñ rɨköm hagla, ‘God ejol nɨpe gau hagö, nöp ñɨmagö kale udeinaböl me, kabö ma nöp u bɨnɨŋ gagnab,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Hageia, Jisas pen haga, “Wasö! God Manö u manö rɨmnap halö kalɨ kƚiñ rɨköm hagla, ‘God Bɨ Kub u, nɨpe bɨ nɨŋö aka bɨ pir alep, a gagmim,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hagö, Seden Jisas nɨp dam dum kub yabɨƚ ap amöm, ram mɨnöŋ aij aij bɨ kub ke ke abadpal gau Jisas nɨp yamöm haga, ");
INSERT INTO kpw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ne kugom yɨmmön, hib yad hagö adö laŋ arö, yad ram mɨnöŋ anɨb gai i magöŋhalö nape nöp ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hageia, Jisas Seden nɨp haga, “Ne ke gau aru! God Manö u kalɨ kƚiñ rɨköm hagla, ‘God Bɨ Kub hib nɨpe u nöp hagpe adö arnɨm; wög nɨp nöp gɨmim,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas anɨg hageia nɨŋöm kɨjaki, Jisas nɨpe nan naij rɨmnap gɨnɨm a göm gɨ gɨ wasö nɨŋöm, nɨp arö göm arö nɨŋöl gɨ, ejol rɨmnap apöm, nɨp ap aɫ ba göm abad mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ñɨn anɨbu Jon bɨ ñɨg pak ñeb u nɨp nagɨ leila, Jisas manö anɨbu apdi nɨŋöm, ram mɨnöŋ Galili ado gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amöm daun nɨpe Nasared am mɨdageia; am mɨdeia daun pro Kapaneam, ram mɨnöŋ Sebyulan Napdalai aŋ au mɨdöp Ñɨg Waŋö Galili goƚ au. ");
INSERT INTO kpw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas ram mɨnöŋ anɨbu amöm, nɨbi bɨ gau kalɨp manö aij u hag ñɨ ajmɨdöp u me, bɨ God manö hagep Aisaia gɨnab a göm kalɨ kƚiñ rɨka rö nöp ga. Nɨpe haga, ");
INSERT INTO kpw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Ram mɨnöŋ Sebyulan abe Napdalai abe, Ñɨg Waŋö Galili goƚ au, Ñɨg Jodan sɨdö wad arab böŋ lau, Juda nɨbi bɨ wasö ram mɨnöŋ Galili au mɨdpal gau kale mailö kub yabɨƚ nɨŋbal. Sɨbön gau mɨdöm umöl rö la u pen mailö kub u hadö nɨŋbal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas ñɨn anɨbu iƚ göm, nɨbi bɨ gau kalɨp God manö aij u hag ñɨ ajöl gɨ haga, “Nan si nan naij gɨpim adö u, nɨhön gɨnɨg anɨg gɨpun a gɨmim, arö gɨmim. Söl mɨdöp, God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab; ñɨn hain pör abad mɨdmɨdim u, mɨñi auöp!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Ñɨg Waŋö Galili goƚ adö au ap lug aramöm nɨŋa, bɨ kabsaƚ udep mamil mɨhau, uben yumil kabsaƚ udailö. Bɨ madöl mɨhau, nɨmam ap hib nɨpe u Saimon, nɨmam ap hib nɨpe u Edru. Saimon nɨp hib ap Pida a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas kalɨp mɨhöŋ nɨŋöm haga, “Yɨp hain gɨmil. Yad kalöp gɨnö, kale mamil mɨhau, kabsaƚ udep bɨ wasö, nɨbi bɨ udep bɨ mɨdeinabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hagö, haga rö nöp nɨŋmil, kabsaƚ udailö uben gau arö gɨmil, Jisas aip ajmɨdil. ");
INSERT INTO kpw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pen magö ap rapɨn amöm nɨŋa, Jems aip Jon aip nap Sebedi aip ñɨg magɨb mɨgan u apɨlap mɨdöl göm, uben ƚuöl udöl gɨ mɨdeila. Jisas nɨŋöm, kalɨp mɨhöŋ wɨñ alö, ");
INSERT INTO kpw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kale nap Sebedi ñɨg magɨb au arö gɨmil, Jisas aip arla. ");
INSERT INTO kpw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ram mɨnöŋ Galili aŋ gau gɨ ajöl göm, Juda magum gep ram gau gau amöm, God nɨbi bɨ udöm abad mɨdeinab manö aij u, nɨbi bɨ gau kalɨp hag ñɨ ajöl gɨ, nan nɨhön nɨhön nɨbi bɨ gau kalɨp ga gau gö kamɨŋ lɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Anɨg gö, ram mɨnöŋ Siria nɨbi bɨ gau magöŋhalö manö anɨbu nɨŋöm, nɨbi bɨ nan nɨhön nɨhön ga gau daulö, Jisas gö kamɨŋ lɨmɨdöp. Nɨbi bɨ anɨb gau, rɨmnap nan ga; rɨmnap hañ romaŋ ilön kub ga; rɨmnap kɨjaki abaŋ ala; rɨmnap amgö mɨmainö auö, ap lug paköm gɨl gɨl gɨmɨdal; rɨmnap ñɨn ma kɨƚa ga; pen nɨbi bɨ nan nɨhön nɨhön ga gau daulö, Jisas gö magöŋhalö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pen Galili nɨbi bɨ löm, Dekapolis nɨbi bɨ löm, Jerusalem nɨbi bɨ löm, Judia nɨbi bɨ löm, ñɨg Jodan nö lödaŋ au nɨbi bɨ löm, iru nöp Jisas arö nɨŋöl gɨ, hain arla. ");
INSERT INTO kpw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas, nɨbi bɨ iru nöp anɨb gau nɨŋöm, am nö ilö laŋ bɨ nɨpe unbö mɨgan laŋ u aip asɨk mɨdöl göm, kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas nɨpe kalɨp hag ñöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nɨbi bɨ gau, hon nɨbi bɨ aij wasö, God nɨpe nöp hanɨp gɨ ñɨnab a göm, God nɨp hag nɨŋnaböl gau, God kalɨp udöm kumi kabö adö laŋ abad mɨdeinab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nɨbi bɨ mɨɫöŋ gɨpal gau, God kalɨp hag udnab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nɨbi bɨ hain agamɨj mɨdpal gau, kale mɨnöŋ naböŋ iƚ i udnaböl u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nɨbi bɨ, God haga rö nöp gɨnabun a göm, nɨŋbal gau, God kalɨp abad mɨdeinab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nɨbi bɨ kale nɨbi bɨ gau kalɨp mög nɨŋöm ud aij gɨnaböl gau, God kalɨp pen u rö nöp mög nɨŋöm ud aij gɨnab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nɨbi bɨ God nɨp gasɨ añɨ nɨŋbal gau, God nɨp nɨŋnaböl u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nɨbi bɨ nɨŋnaböl, nɨbi bɨ rɨmnap pen pen gɨnaböl gau, kale apöm hagnaböl, ‘Kale unbö gagmim, agamɨj mɨdaimim,’ a gɨnaböl gau, God kalɨp ñɨ pai yad a gɨnab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nɨbi bɨ kale God haga rö nöp gɨnabun a gɨ mɨdlö, nɨbi bɨ rɨmnap kalɨp gɨ naij gɨnaböl u, God kalɨp udöm kumi kabö adö laŋ abad mɨdeinab u me, mɨñ mɨñ göl. ");
INSERT INTO kpw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kalöp Jisas nɨbi bɨ nɨpe a göm gɨ naij göm, manö piral hagöm hag juaiöl, kale mɨñ mɨñ yabɨƚ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bɨ God manö hagep hadame nöp gau kalɨp adö anɨbu nöp gɨla. Anɨb u, kalöp u rö nöp geinaböl u, gasɨ kub u nɨŋagmim; God hanɨp kumi kabö adö laŋ ud aij gɨnab a gɨmim, mɨñ mɨñ yabɨƚ gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas manö anɨbu hagöm haga, “Nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau, dö sol rö kale mɨdpim. Pen dö sol kal u am haköm kauyaŋ kal gagnab; böŋ nöp naij göp a göm, abhib jaköm ud yunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Daun kub dum laŋ mɨdöm, pi göl mɨdnɨm rö lagnab; waiö yabɨƚ mɨdeinab. Anɨb u rö, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau kalɨp hapö mailö rö mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nɨbi bɨ gau hapö lauöm rin cög mɨgan gau pi gagnaböl. Adö au gɨlaŋ rɨk lɨlö mailö gö, nɨbi bɨ ram raul mɨgan gau magöŋhalö nɨŋ aij gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anɨb u rö, kale nɨbi bɨ gau kalɨp gɨ aij gɨpe, nɨbi bɨ gau kalöp nɨŋöm, Nap kumi kabö adö laŋ mɨdöp hib nɨpe nöp haglö adö arnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kale hagnabim, Jisas auöp u, God Mosɨs nɨp lo manö haga manö adö u abe, bɨ God manö hagep rɨmnap hagla manö adö u abe, arö gɨmim a gɨnɨg auöp a gɨnabim u pen u wasö! Yad aubin u, bɨ God manö hagep gau gɨnab a gɨla rö magöŋhalö gɨnam a gem aubin. ");
INSERT INTO kpw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yad kalöp nɨŋö yabɨƚ hagabin. Kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe böŋ nöp ur gɨnab u pen God Manö u manö magö rɨmnap ur gagnab; magöŋhalö pör pör nöp mɨdeinab. Manö nɨhön nɨhön haga u, magöŋhalö haga rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Anɨb u, nɨbi bɨ an God lo manö u nɨŋöm, manö pro magö ap arö gɨnam a göm, nɨbi bɨ gau haƚöwaƚö hag ñö arö gɨnaböl u, God nɨbi bɨ udöm abad mɨdeinab ñɨn u, hib kale ap lugnab. Pen nɨbi bɨ an God lo manö nɨŋöm, nɨŋ aij göm, nɨbi bɨ gau kalɨp hag ñɨ aij gɨnaböl u, God nɨbi bɨ udöm abad mɨdeinab ñɨn u, hib kale ap rannab. ");
INSERT INTO kpw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bɨ Perisi gau abe, God lo manö hag ñeb bɨ gau abe, ‘God haga rö nöp gɨpun,’ a gɨpal u pen kale yɨharɨŋ manö hagöm God haga rö gagpal, wasö. Kale ke pen, God manö haga rö nöp nɨŋmim kabö rö nöp hain gɨmim. Anɨg gɨnabim u me, God kalöp udöm kumi kabö adö laŋ au abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hadame nöp napɨs nahai iƚaŋ gau God lo manö hagmɨdal adö u kale nɨŋbim. Kale hagmɨdal, ‘Wip al pakagmim. Nɨbi bɨ ap, nɨbi bɨ ap al pak lɨnab u, manö kub nɨŋnab,’ a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Manö anɨbu nɨŋbim u pen kalöp mɨñi hag aij gɨnam. Nɨbi bɨ ap, nɨbi bɨ ap nɨp nɨŋö mulu lugnab u, manö kub nɨŋnab. Nɨbi bɨ ap, nɨbi bɨ ap hib dap lugnab u, Juda Kansol gau ap magum göm, nɨp manö kub hagnaböl. Nɨbi bɨ ap, nɨbi bɨ ap nɨp hagnab, ‘Ne bɨ hauƚ halö,’ a gɨnab u, ram mɨnöŋ mab ke inab mɨgan yaŋ arnɨm rö löp. ");
INSERT INTO kpw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Anɨb u, ne nan God nɨp sabe gɨ ñeb dam kabö bɨd adö u sabe gɨ ñɨnɨg, añ mam ne nɨp gɨna rö manö mɨdöp a gɨnabön u, ");
INSERT INTO kpw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nan God nɨp sabe gɨ ñeb anɨbu kabö bɨd au arö gɨmön, nɨpe aip manö hag aij gɨmön, uri agamɨj mɨdaiul a gɨmön, ado gɨ ap nan anɨbu God nɨp sabe gɨ ñɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nan nɨhön gɨ naij gɨnabim u, kalöp manö kub hagnɨg, dam adan aŋ gau hain ud arlö nɨŋöl gɨ, kalɨp aip manö anɨbu hag ud asɨkmim, dɨm ñöl mɨdaimim. Wasö u, kalöp dam bɨ kub u nɨp ñeinaböl, nɨpe pen kalöp ud polisman kai kalɨp ñö, kalöp dam nagɨ lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yad kalöp nɨŋö yabɨƚ hagabin, nan naböŋ kale u böŋ nöp naböŋ ral pɨs gɨmim höŋ arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Pen manö ap hagla u, u rö nöp nɨŋbim. Manö anɨbu hagla, ‘Nɨbi si bɨ si gagmim,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pen yad kalöp hagabin, bɨ ap nɨbi ap nɨp nɨŋöm, nɨp gɨbnep a göm gasɨ nɨŋnab u, God nɨŋö, bɨ anɨbu gasɨ nɨpe aŋ yaŋ nɨbi anɨbu si gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Anɨb u, amgö magö yɨjɨg lau nɨŋöm, nan si nan naij gep rö lainɨm u, amgö böŋ anɨbu ud ju yumim. Pen amgö kale u mög nɨŋnabim u, nan si nan naij gɨmim, mab ke inab mɨgan yaŋ armim rö löp. ");
INSERT INTO kpw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pen ñɨmagö yɨjɨg kɨd u u rö nöp, nan si nan naij gɨnɨg gainɨm, rɨb gɨ dö gɨ yumim. Anɨg gɨmim me, ñɨn böŋ lap nöp mɨdö kamɨŋ arnabim. Wasö u, mab ke inab mɨgan yaŋ arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kale nɨŋbim, manö ap hagla, ‘Bɨ ap nɨbin nɨp arö gɨnɨg, nɨbi i böŋ nöp arö gɨnam a göm, kalɨ kƚiñ bad ap rɨköm, nɨbi anɨbu nɨp ñöm me, böŋ nöp arö gɨnab,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pen yad kalöp hagabin: bɨ ap, nɨbin nɨpe bɨ ap si udagnab wasö, pen nugmul nɨpe nɨbin yɨharɨŋ nöp arö gɨnab u, gɨ naij gɨnab. Pen nɨbi u nɨp anɨg göm arö gö, am bɨ hain nɨbö ap udnab u, bɨ u nɨpe nɨbin nɨpe arö gɨnab u me, nɨpe anɨg gö, nɨbin nɨpe bɨ si udep nɨbi lɨnab. Pen bɨ an nɨbi anɨbu udnab u, nɨpe u rö nöp nɨbi si udep bɨ lɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hadame nöp manö ap hagla u, u rö nöp nɨŋbim. Manö anɨbu hagla, ‘Kale Bɨ Kub amgö ilö nɨpe manö nɨŋö yabɨƚ hagnabim u, hagnabim rö nöp gɨmim. God nɨpe nɨŋmɨdöp nɨŋöm hagnabim rö nöp gɨmim,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pen yad kalöp hagabin: manö ap hagnɨg, ‘God amgö ilö adö u nɨŋö hagabin,’ a gɨmim hagagmim. ‘Ram mɨnöŋ kumi kabö adö laŋ au mɨdöp rö, nɨŋö hagabin,’ a gɨmim hagagmim; God nɨpe ram mɨnöŋ anɨb au sea kiŋ adö au asɨk mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Mɨnöŋ naböŋ iƚ i mɨdöp rö nɨŋö hagabin,’ a gɨmim hagagmim; God nɨpe sea kiŋ adö au asɨköm, ram mɨnöŋ iƚ i ma adö au abö gɨ mɨdöp. ‘Jerusalem mɨdöp rö nɨŋö hagabin,’ a gɨmim hagagmim; u Kiŋ Kub yabɨƚ daun kub nɨpe me. ");
INSERT INTO kpw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‘Nabɨc yad mɨdöp rö, nɨŋö hagabin,’ a gɨmim hagagmim. Kale ke gɨpe, nabɨc uŋ kale añɨ ap ule aka pɨr ranagnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Anɨb u, ‘Gɨnabin’ a gɨmim, ‘Gɨnabin’ nöp a gɨmim; pen ‘Gagnabin’ a gɨmim, ‘Gagnabin’ nöp a gɨmim. Manö kuöyaŋ lɨmim hagmim, lɨmim hagmim u, Seden kalöp gasɨ ñö, hagnabim. ");
INSERT INTO kpw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pen manö ap hagla u, u rö nöp nɨŋbim. Manö anɨbu hagla, ‘Amgö magö u bɨg juaiöl, kalɨp pen abe bɨg jumim. Meg magö pa jö gaiöl, kalɨp pen abe pa jö gɨmim,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pen yad kalöp hagabin: bɨ ap kalöp gɨ naij gainɨm, nɨp pen gɨ naij gagmim. Bɨ ap kalöp alaun pak hil gainɨm, ado gɨmim böŋ lap abe paknɨm. ");
INSERT INTO kpw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bɨ ap apöm kalöp manö kub hagöm, ‘Sior ne u yɨp hajɨ gɨ,’ a gainɨm, sior nöp ñagmim, kolsior u abe ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bɨ ap kalöp hag nɨŋöm, ‘Nan wadɨ i dam ka au yumön aumön,’ a geinab u, jɨ nɨŋagmim; ka hagöl au hil gɨmim, dam yɨharɨŋ ka au yumim aumim. ");
INSERT INTO kpw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nɨbi bɨ rɨmnap kalöp, ‘Hanɨp nan rɨmnap ñim,’ a gaiöl, haƚöwaƚö ñɨmim. Pen nɨbi bɨ rɨmnap kalöp, ‘Hanɨp nan rɨmnap yɨharɨŋ ñɨbe, hainö pen kalöp ado gɨ dam ñɨnabun,’ a gaiöl, arö gagmim, haƚöwaƚö ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Manö ap hagla u, u rö nöp nɨŋbim. Manö anɨbu hagla, ‘Mɨdaimam kale gau kalɨp mɨdmagö lɨmim; nɨbi bɨ koƚmaƚ kale gau kalɨp mulu adɨŋ nɨŋmim,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pen yad kalöp hagabin: nɨbi bɨ koƚmaƚ kale gau, kalɨp mɨdmagö lɨmim; nɨbi bɨ kalöp gɨ naij gɨpal gau, God nɨp sabe gɨmim, ‘Kalɨp abad mɨd aij gɨmön,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Kale anɨg gɨnabim u, Nap kumi kabö adö laŋ mɨdöp u, ñɨ pai nɨpe yabɨƚ mɨdeinabim. Nɨpe gö, sɨdö mailö gö, nɨbi bɨ gɨ aij gɨpal gau abe, nɨbi bɨ gɨ naij gɨpal gau abe, mailö gab. Nɨpe gö, möŋ alöm, nɨbi bɨ gɨ aij gɨpal gau nan wög kale gau ranöm, nɨbi bɨ gɨ naij gɨpal gau nan wög kale gau ranöm göp. ");
INSERT INTO kpw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kale nɨbi bɨ kalöp mɨdmagö lɨbal gau nöp ud aij gɨnabim u, bɨ dakɨs udpal gau gɨpal rö nöp gɨnabim. Anɨg geinabim u, God ne aige göm ñɨñɨ löm kalöp nan aij ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kale añ mam kale gau nöp hag wɨhai udnabim u, nɨbi bɨ God nɨp gasɨ nɨŋagpal gau, nɨbi bɨ yɨharɨŋ gau kalɨp gɨpal rö nöp gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Anɨb u, Nap kumi kabö adö laŋ gɨ aij yabɨƚ gab rö, kale u rö nöp gɨ aij yabɨƚ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pen kale, hib kub udun a gɨmim, nɨbi bɨ amgö ilö adö kale u nöp God hagöp rö nöp gun, a gɨmim gɨpe u, Nap kale kumi kabö adö laŋ mɨdöp u nɨpe nɨŋöm kalöp pen nan aij ap ñagnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nɨbi bɨ rɨmnap, God nɨp nɨŋ udpun, a göm, piral nöp gɨpal. Hib kub udun, a göm, kale nɨbi bɨ mög gep rö gau mani nan rɨmnap ñɨnɨg, Juda magum gep ram nɨbi bɨ iru mɨdnaböl raul u aka, adan kub nɨbi bɨ iru nöp ajnaböl gau nöp amöm, nɨbi bɨ amgö ilö adö au ñɨnaböl. Gɨnaböl anɨbu yad kalöp hagabin: hib kub udun a göm, nan kale pen udnaböl anɨbu; Bapi kalɨp nan rɨmnap halö ñagnab. Kale anɨg gɨnaböl u rö gagmim. ");
INSERT INTO kpw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Pen kale nɨbi bɨ mög gep rö gau kalɨp nan ñɨnɨg, waiö ñagmim; ");
INSERT INTO kpw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agamɨj pi gɨmim rö ñɨmim. Nan nɨhön agamɨj gɨpim u, Nap kale magöŋhalö nɨŋöb rö, nɨhön nɨhön gɨnabim nɨŋöm, kalöp pen nan aij ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kale God nɨp sabe gɨnɨg gɨmim u, nɨbi bɨ rɨmnap, God nɨp gasɨ nɨŋbun, a göm, piral nöp gɨpal rö gagmim. Kale nɨbi bɨ rɨmnap hanɨp nɨŋlö, hib kub udnabun a göm, am Juda magum gep ram aŋ u mɨdöm aka, am adan ramö gau mɨdöm, nɨbi bɨ amgö ilö au God nɨp sabe gɨpal. Gɨpal anɨbu yad kalöp hagabin, hib kub udun a göm, nan kale pen udnaböl anɨbu; God nɨpe manö kalɨp u udagnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anɨb u, kale God nɨp sabe gɨnɨg, ram magö raul mɨgan kale u ammim, ajöŋ gɨ ñɨmim, Bapi hon amgö nɨŋagpun nɨp sabe gɨmim. Nan nɨhön agamɨj gɨpim u, Nap kale magöŋhalö nɨŋöb rö, nɨhön nɨhön gɨnabim nɨŋöm, manö kale nɨŋöm, kalöp pen nan aij ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nɨbi bɨ God Manö nɨŋagpal gau, nɨp sabe gɨnɨg, manö mɨlö kub yabɨƚ hagpal. Gasɨ kale nöp nɨŋöm hagpal, ‘Manö mɨlö kub hagno me nɨŋnab,’ a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pen kale anɨbu rö gagmim. Manö nɨhön God nɨp sabe gɨnɨg gabim gau, nɨpe nöd nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Anɨb u, God nɨp sabe gɨnɨg, hagmim, ‘Bapi kub kumi kabö adö laŋ mɨdpan; hib ne i adö laŋ mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne hanɨp udmön abad mɨdaimön. Ne kumi kabö adö laŋ hagpan rö nɨŋbal u, hon aui mɨnöŋ naböŋ iƚ i gɨ ñɨmön nɨŋun hon abe manö nöp nɨŋun. ");
INSERT INTO kpw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hanɨp nan ñɨŋeb rɨmnap nɨme lɨmön; pör pör ñɨban rö u ñɨn añɨ añɨ ñɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nɨbi bɨ rɨmnap hanɨp gɨ naij gɨpal nɨŋun arö gɨpun rö, hon gɨ naij gɨpun u u rö nöp nɨŋmön arö gɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hon gɨ naij gun rö löp u, ne hanɨp abad mɨdö, hon gɨ naij gagun,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nɨbi bɨ rɨmnap kalöp gɨ naij gaiöl nɨŋmim arö gɨnabim u, Nap kale kumi kabö adö laŋ mɨdöp u nan si nan naij kale gɨnabim u u rö nöp nɨŋöm, arö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pen nɨbi bɨ rɨmnap kalöp gɨ naij gaiöl nɨŋmim arö gagnabim u, Nap kale nan si nan naij kale gɨnabim u u rö nöp nɨŋöm arö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kale nan ñɨŋeb arö gɨnɨg, nɨbi bɨ God nɨp gasɨ nɨŋbun, a göm, piral nöp gɨpal rö, gagmim. Kale, ‘Hon mulu halö halö rö mɨdno, nɨbi bɨ nɨŋöm hagnaböl, “God nɨp gasɨ nɨŋöm, nan ñɨŋeb hil göm me, mulu halö halö mɨdpal,” a gɨnaböl,’ a göm, piral anɨg gɨnaböl. Yad kalöp nɨŋö yabɨƚ hagabin: nɨbi bɨ hanɨp nɨŋlaŋ, a göm gɨnaböl anɨb gau, nɨbi bɨ gau nɨŋöm hib kale haglö adö arnab u pen God kalɨp nan aij kumi kabö adö laŋ ñagnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kale pen nan ñɨŋeb gau hil geinabim u, mulu halö halö rö mɨdagaimim. Ñɨg pak aij gɨmim, wel lɨmim, kom gɨmim mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Anɨg geinabim me, kalöp nɨbi bɨ nan magö hil gɨpal gau a göm, nɨŋagnaböl. Nan agamɨj gɨpim u, Nap kale, hon amgö nɨŋagpun Bɨ u, nɨpe magöŋhalö nɨŋöb rö, kalöp pen ñöm nan aij ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pen mɨnöŋ naböŋ iƚ i nan aij aij gau ud magum gun, a gɨmim gasɨ u nɨŋagmim. Nɨhön gɨnɨg: nan anɨb gau ud magum geinabim, sɨpsop ñɨŋöm, hij göm, si udöm gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Anɨb u, nan aij kale rö gau, God ram mɨnöŋ kumi kabö adö laŋ au ud magum gɨpe, sɨpsop ñɨŋagnɨm, hij gagnɨm, si udagöl, mɨdep nöp mɨdainɨm. ");
INSERT INTO kpw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nan aij kale mɨnöŋ naböŋ adö iƚ i ud magum geinabim u, gasɨ kale mɨdeinab mɨnöŋ naböŋ adö iƚ i; nan aij kale God ram mɨnöŋ kumi kabö adö laŋ au ud magum geinabim u, gasɨ kale u arnab anɨb laŋ. ");
INSERT INTO kpw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amgö magö hañ romaŋ hapö mailö rö mɨdöp. Amgö magö kale u aij mɨdö, mailö aij gö nɨŋ aij gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pen amgö magö kale u naij gö, hañ romaŋ kale u sɨbön gɨnab. Mailö gɨböp pen böŋ nöp sɨbön gö, nan ap nɨŋagnabim. Kale mailö nɨŋagpim u, sɨbön göp rö mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bɨ añɨ ap, bɨ kub mɨhöp kalɨp wög gɨ ñɨnɨm rö lagöp. Nɨhön gɨnɨg: bɨ kub ap nɨp nɨŋö aij geinab, ap nɨp arö gɨnab: pen bɨ kub ap nɨp nɨŋö aij geinab, ap nɨp arö gɨnab. Anɨb u, kale mani nan aij mɨnöŋ naböŋ adö iƚ i mɨdöp gau, nɨŋbe aij gö, God nɨp arö gɨnabim rö löp u, nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Adö anɨbu me kalöp hagabin: nan gai nɨbö ñɨŋun mɨdaiun, waƚɨj gai nɨbö rol gun mɨdaiun, a gɨmim, gasɨ kub u nɨŋagmim. Kamɨŋ mɨdep u nan kub; nan ñɨŋeb nan pro. Uri mɨdpun i, hañ romaŋ nan yabɨƚ; hañ romaŋ waƚɨj rol gep nan pro. Anɨg gö nɨŋmim, God kalöp gɨ la u, nɨpe nan ñɨŋeb, waƚɨj hañ romaŋ rol gep, nan pro anɨb gau ñagnab a gɨ nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kale nɨŋbim, yaur gau nan yɨŋ yɨmagal; wid, rais, nan gau rɨk dap magum gagpal. Pen Nap kale kumi kabö adö laŋ u kalɨp abad mɨdö, nan ñɨŋbal. Anɨb u, yaur u nan yɨharɨŋ u pen nɨpe nan ñö ñɨŋbal rö, kalöp u rö nöp ñagnab a gɨ nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aka, gasɨ iru nɨŋun me, rapɨn mɨdun umnabun a gɨ gasɨ nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pen nɨhön gɨnɨg waƚɨj nan gau gasɨ iru nɨŋbimŋ Nan pɨƚpɨƚ be gau ranöb gau, wög gagöm, waƚɨj gagöm, gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pen kiŋ Solomon mani iru mɨdö rɨb adɨk aij yabɨƚ gɨmɨdöp u, nan pɨƚpɨƚ anɨb gau rö rɨb adɨk aij gaga. ");
INSERT INTO kpw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nan pɨƚpɨƚ anɨb gau nan yɨharɨŋ. Pör mɨdöm wasö, mɨñi rö mɨdöm, rol rö laubal. Pen God nan yɨharɨŋ anɨb gau gɨ löm rɨb adɨk aij gɨ ñöb u, nɨhön gɨnɨg hanɨp abad mɨdagnab a gɨmim nɨŋbimŋ Kale anɨg gasɨ nɨŋnabim u, kale God nɨp nɨŋ ud aij gagpim. ");
INSERT INTO kpw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Anɨb u, nan mai ñɨŋun, ñɨg mai ñɨŋun, waƚɨj nɨhön rol gun, a gɨmim, gasɨ kub u nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nɨbi bɨ God Manö nɨŋagpal gau, nan anɨb gau udun a göm, gasɨ kub anɨbu rö nɨŋbal. Pen kale nɨŋbim, Nap kale kumi kabö adö laŋ mɨdöp u, kale nan nɨhön nɨhön mɨdagöp u nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Anɨb u, God nɨbi bɨ rɨmnap udöm abad mɨdeinab u, hanɨp u rö nöp udnab a gɨmim gasɨ añɨ nɨŋmim; God nɨpe haga rö nöp gɨ mɨdaiun a gɨmim, gasɨ añɨ nɨŋmim; kale anɨg gɨpe arö me, nan ñɨŋeb, ñɨg ñɨŋeb, waƚɨj rol gep, nan anɨb gau magöŋhalö kalöp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Anɨb u, rol ruö nɨhön gun mɨdaiun, a gɨmim gasɨ kub u nɨŋagmim. Ñɨn uri u ñɨn uri. Uri ñɨn i nöp nan mɨŋör rɨmnap mɨdöp u, u nöp gasɨ nɨŋmim. ");
INSERT INTO kpw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hon nɨbi bɨ aij a gɨmim, nɨbi bɨ rɨmnap kalɨp gasɨ naij nɨŋnabim u, manö anɨbu ado gɨ kale ke aunab. ");
INSERT INTO kpw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anɨb u, nɨŋ aij gɨmim. Kale nɨbi bɨ rɨmnap kalɨp gɨnabim rö, God kalöp pen gɨnab. Kale nɨbi bɨ rɨmnap nɨŋmim manö kub hag gɨnabim rö, God kalöp u rö nöp manö kub hag gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mab po amgö kale pak harɨ göl mɨdöp u, nɨhön gɨnɨg mab po anɨbu nan yɨharɨŋ a gɨmim, namam nan acɨp amgö nɨpe mɨdöp u nɨŋmim hagpim? ");
INSERT INTO kpw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Ne bɨ manö piral hagep bɨ. Mab po amgö kale pak harɨ göl mɨdöp u nöd ud yumim, amgö nɨŋ aij gɨmim, namam nan acɨp amgö nɨp mɨdöp u nɨp, ‘Ud yuɨn’ a gɨmim hagmim. ");
INSERT INTO kpw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God nan uɫ nɨpe gau, kain hapeb gau kalɨp ñagmim. Kɨbap mɨƚep gau, kaj gau mɨdöp, a gɨmim ud yuagmim. Pen nɨhön gɨnɨg: ud yunabim, kale abö jö ma jö gɨ yuöm, ado gɨ apöm kalöp haunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nan nɨhön mɨdagainɨm u, God nɨp hag nɨŋbe kalöp ñɨnab. Pen nan rɨmnap uƚhai nɨŋnabim u, udnabim. Hanɨp ajöŋ hiɨk, a gɨmim, pak gu gɨpe, kalöp ajöŋ u hiɨknab. ");
INSERT INTO kpw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pen nɨhön gɨnɨg: nɨbi bɨ God nɨp hag nɨŋnaböl u, hag nɨŋnaböl rö nöp gɨnab. Nan uƚhai nɨŋnaböl u kalɨp yamnab. Pen, ajöŋ u hiɨk, a göm, pak gu gu gɨlö, hagnaböl rö nɨŋöm hiɨknab. ");
INSERT INTO kpw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kale bɨ nap gau, ñɨ pai kale ap maj ap ñɨ a gö, kale kabö ñɨnabim? ");
INSERT INTO kpw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aka pen, kabsaƚ ap ñɨ a gö, haiŋo ap ñɨnabimŋ U anɨg gagnabim. ");
INSERT INTO kpw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kale nɨbi bɨ aij wasö u pen ñɨ pai kale gau, nan aij gau nöp ñɨnabim. Nap kale kumi kabö adö laŋ bɨ aij yabɨƚ u, piral gagnab; kale hag nɨŋnabim u, nɨpe kalöp nan aij ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pen kale ke, hanɨp adö u gɨlaŋ, adö u gaglaŋ, a gɨmim nɨŋbim, adö u nöp nɨbi bɨ gau kalɨp gɨmim. Mosɨs God lo manö udöm kalɨ kƚiñ rɨka manö u abe, bɨ God manö hagep kalɨ kƚiñ rɨkla manö u abe, iƚ me anɨbu. ");
INSERT INTO kpw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Mab ke yaŋ adan kub u waiö nɨŋöm am aij gɨpal. Nɨbi bɨ iru nöp mɨgan anɨbu arbal. Anɨb u, kale nɨŋ aij gɨmim, pör mɨdep adan pro u udmim armim. Adan pro anɨbu uɫham arnaböl. Nɨbi bɨ añɨ añɨ nöp, adan pro mɨlö anɨbu kƚö göm uƚhai nɨŋöm arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pen nɨbi bɨ God manö hagabun a göm piral hagpal gau, kaj sipsip hain aij rö halu löm aunaböl u pen apöm mɨdöl gɨ, kain hapeb nɨbi bɨ hau löp rö u kalöp gɨnaböl. Anɨb u, nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nɨbi bɨ mɨd aij gɨpal rö halu löm aunaböl u pen kale nan si nan naij gɨnaböl rö nɨŋmim, kalɨp nɨŋ aij gɨnabim. Kale nɨŋbim, nagɨ yɨharɨŋ kalɨ kalɨ halö gau magö ñɨŋeb u pɨlö gu ñɨŋagnabim. ");
INSERT INTO kpw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Mab gau u rö nöp gɨnab. Mab magö ñɨŋeb ur gau, mab magö ñɨŋagep pɨlagnab. Pen mab magö ñɨŋagep ur gau, magö ñɨŋeb pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pen mab magö aij pɨlagnab gau, rɨb gɨ dö gɨ dam mab inab u yunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Anɨb u, nɨbi bɨ gau nagɨ gɨnaböl adö u nɨŋmim, nɨbi bɨ gau aij, nɨbi bɨ gau naij a gɨmim nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nɨbi bɨ yɨp, ‘Bɨ Kub hon!’ ‘Bɨ Kub hon!’ a gɨpal gau magöŋhalö, God kalɨp udöm abad mɨdeinab, a gɨ gasɨ u nɨŋagmim. Bapi yad kumi kabö adö laŋ mɨdöp u hagöp rö gɨpal nɨbi bɨ gau nöp kalɨp udöm kumi kabö adö laŋ au abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","God nɨbi bɨ manö kub hagnab ñɨn u, nɨbi bɨ iru nöp yɨp hagnaböl, ‘Bɨ Kub, hon nɨbi bɨ ne nöp. Hib ne nöp hagun, manö ne hag ñɨno. Hib ne nöp hagun, nan nɨbi bɨ kɨjaki abaŋ ala gau hag yuno. Hib ne nöp hagun, nan gagep rö gau iru nöp gɨno,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yɨp anɨg hagnaböl u pen yad kalɨp hagnabin, ‘Yad kale nɨŋagmɨdin; kale gɨ naij nöp gɨpim, ke gau arim!’ a gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Bɨ gasɨ nɨŋeb yabɨƚ ap, ram nɨpe u gɨnɨg, kabö adö laŋ gɨnab. Hainö hadal kub apöm, möŋ kub alöm, ñɨg uƚ apöm gɨnab u pen ram nɨpe kabö adö laŋ gɨ pɨdöŋ gɨnab u, pa jö ma jö gɨ ud aragnab. Anɨb u rö me, nɨbi bɨ manö yɨp nɨŋöm, nɨŋ udöm, hagpin rö gɨnaböl gau. ");
INSERT INTO kpw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","“Pen bɨ gasɨ nɨŋ aij gagnab ap, ram nɨpe u gɨnɨg, mɨnöŋ kabö kuƚup adö au gɨnab. Hainö hadal kub apöm, möŋ kub alöm, ñɨg uƚ apöm, ram nɨpe u böŋ nöp pa jö ma jö gɨ ud arnab. Anɨb u rö me, nɨbi bɨ manö yad nɨŋöm hagpin rö gagnaböl gau,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas manö anɨbu hag hakö nɨŋöl gɨ, nɨbi bɨ iru nöp ap mɨdeila gau nɨŋöm hagla, “God lo manö hag ñeb bɨ hon gau manö hagpal rö hagagöp; nɨpe bɨ manö nɨŋ aij yabɨƚ göm hagöp,” a göm, aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas nö ilö laŋ mɨdeia u arö göm, sɨr yaŋ ap lugö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨp hain gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pen bɨ wös hapeb la ap, Jisas mɨdeia söl au amöm, kugom yɨmöm, ubör yɨhöŋ göm haga, “Bɨ Kub. Ne yɨp gö kamɨŋ lɨnɨg, gö kamɨŋ lɨnab. Yɨp kamɨŋ lɨnab u, yad God sabe gep ram raul arnɨg gabin u, yɨp wɨhö gagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Anɨg hagö, Jisas ñɨmagö mɨlöbö löm bɨ anɨbu ud nɨŋöm haga, “Yad gɨnabin; nöp kamɨŋ laŋ,” a gö, magö anɨbu nöp nɨp kamɨŋ lö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas bɨ anɨbu nɨp haga, “Nöp gɨnö kamɨŋ löp anɨbu, nɨbi bɨ rɨmnap kalɨp hag ñagmön wasö. Am bɨ God nɨp nan sabe gep bɨ gau kalɨp nöp yammön hagmön, ‘Yɨp kamɨŋ löp nɨŋim!’ a gɨmön. Anɨg hagmön, Mosɨs haga rö, yaur ap God nɨp pak sabe gɨ ñɨmön. Anɨg geinabön, nɨbi bɨ gau nɨŋöm hagnaböl, ‘Nɨp kamɨŋ löp u me anɨg gab,’ a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas daun pro Kapaneam arö nɨŋöl gɨ, ami bɨ iru nöp abad mɨdmɨdöp bɨ kub ap, Jisas yɨp gɨ ñɨnɨm a göm apöm Jisas nɨp haga, ");
INSERT INTO kpw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bɨ Kub, bɨ wög gɨ ñeb yad u nɨp mɨña kub göm, ilön neb neb gö, aŋa gagöp; ram au um mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hageia, Jisas haga, “Yad am nɨp gɨnö kamɨŋ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Hageia, ami bɨ kub anɨbu haga, “Bɨ Kub, nɨŋö hagpan u pen yad bɨ kub rö ram yad u aumön. Yad nɨŋbin u, ami bɨ kub rɨmnap yɨp abad mɨdlö, yad pen ami bɨ rɨmnap kalɨp abad mɨdem, ‘Arim,’ a gɨnö, arbal halö; ‘Auim,’ a gɨnö, aubal halö. Bɨ yɨp wög göp u nɨp, wög gau anɨg gɨmön anɨg gɨmön a gɨnö, göp. Anɨb u rö, ne yɨharɨŋ, ‘Kamɨŋ laŋ,’ a gɨmön, nɨp kamɨŋ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Anɨg hagö Jisas aiö göm, nɨbi bɨ hain areila gau kalɨp haga, “Bɨ anɨbi mɨlö gau nɨbö u pen, God göp rö nɨŋ aij yabɨƚ göm me, anɨg hagöp. Bɨ hon Isrel nɨbö ap, God nɨp nɨŋ ud pɨdöŋ göm hagöp anɨbu rö hagö, yad nɨŋagpin. ");
INSERT INTO kpw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Anɨb u, hainö nɨbi bɨ mɨlö gau nɨbö gau, God nɨbi bɨ udöm kumi kabö adö laŋ abad mɨdeinab aŋ u amöm, Ebraham, Aisak, Jekop bɨ aip asɨköm, nan ñɨŋeb iru ñɨŋöm, mɨñ mɨñ göl gɨ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kale anɨg göm am mɨdeinaböl, pen nɨbi bɨ hon Isrel nɨbö gau, am aŋ anɨbu mɨdageinaböl rö löp. God kalɨp hag yueinab, am mɨdeinaböl höŋ sɨbön göp adö yaŋ. Kale mɨɫöŋ magö göm meg magö hau jö ma jö gɨ ñɨŋöl gɨ mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Anɨg hagöm, Jisas ami bɨ kub anɨbu nɨp haga, “Ne ado gɨ aru! Hagpan rö nöp gɨnab,” a ga. Jisas anɨg hagö, nɨpe ram aramöm nɨŋa, bɨ nɨpe nan ga u, Jisas haga magö anɨbu nöp kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pen Jisas Pida ram amöm nɨŋa, Pida nɨbor u, hañ romaŋ gau mab rö inö, abañ adö laŋ um mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas nɨŋöm, am Pida nɨbor ñɨmagö nɨpe ud nɨŋö, magö u nöp kamɨŋ lö, nɨpe uraköm, Jisas nɨp nan magö ud lɨ aij ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dugo magö u, nɨbi bɨ kɨjaki abaŋ ala gau abe, nɨbi bɨ nan ga gau abe, dam Jisas mɨdeia u aueila, nɨpe kɨjaki gau hag höŋ yuöm, nɨbi bɨ ñɨ pai nan ga gau gö magöŋhalö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nɨpe ga anɨbu, bɨ God manö hagep Aisaia, hadame nöp gɨnab a göm kalɨ kƚiñ rɨka rö nöp ga. Nɨpe kalɨ kƚiñ rɨköm haga, “Hanɨp nan ga gau gö kamɨŋ la. Nan nɨhön nɨhön hanɨp naij ga gau hag yuö mɨd aij gɨpun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nɨŋa, nɨbi bɨ iru nöp ap nɨp bɨg gɨgabö geila, bɨ nɨpe gau kalɨp haga, “Ñɨg waŋö juun böŋ lödaŋ arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Anɨg hagö nɨŋöl gɨ, God lo manö hag ñeb bɨ ap apöm nɨp haga, “Manö hag ñeb bɨ. Ne ram mɨnöŋ gai gai arnabön u, yad nöp aip arnabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hageia, Jisas haga, “Kain hauƚ gau, kale mɨnöŋ mɨgan gau hanbal. Yaur gau, kau kale haneb u mɨdöp. Pen yad Bɨ Ñɨ nɨpe haneb mɨgan u mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pen bɨ Jisas nɨp nɨŋ uda bɨ ap haga, “Bɨ Kub, yad ne aip arul u pen, yɨp yau a gö, bapi nɨp umö rɨgöl gem, ne aip ajeinabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hageia, Jisas haga, “Nɨbi bɨ yɨp nɨŋ udagpal rɨmnap umaiöl, nɨbi bɨ yɨp nɨŋagpal rɨmnap dam rɨgöl göl; pen ne auö yad aip arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas ñɨg magɨb udöm arnɨg gö, bɨ nɨpe gau aip hadla. ");
INSERT INTO kpw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ñɨg aŋ au arlö nɨŋöl gɨ, adɨŋ yɨgön kub yabɨƚ u udöm, ñɨg ral apöm, ñɨg magɨb u ud ado gɨnɨg rö ga. Pen Jisas nɨpe hon haneia rö, ");
INSERT INTO kpw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","bɨ nɨpe gau nɨp am haglö urakö hagla, “Bɨ Kub! Pɨnöm asad kub u hanɨp ud ado gö, ñɨg ñɨŋun rö löp u, ne hanɨp ud kamɨŋ lɨ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hagaila, kalɨp haga, “Nɨhön gɨnɨg pɨñɨŋ gabimŋ Kale manö yad pro pro rɨmnap nɨŋ udagpim aka?” ga. Anɨg hagöm, uraköm, pɨnöm asad udeia u hagö hir göm, ñɨg ral aueia u ur göm ga. ");
INSERT INTO kpw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anɨg gö, kale aiö göm hagla, “Bɨ kal yabɨƚ i nɨpe bɨ aige rö bɨ gajɨp nɨŋöm pɨnöm asad udeia u hir göm, ñɨg ral auajɨp u ur göm göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ñɨg juöm, ram mɨnöŋ Gadara böŋ lödaŋ amjaka nɨŋöm, bɨ hauƚ kɨjaki abaŋ ala mɨhau wip rɨgöl gɨmɨdal kabö mɨgan gau nɨbö apjaklö. Bɨ anɨb mɨhau kalɨp kɨjaki aiön pi abaŋ alla rö, bɨ hapeb yabɨƚ mɨhau mɨdmɨdil. Adan kalpe mɨdmɨdil au, nɨbi bɨ rɨmnap aragmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pen kalpe mɨhöŋ apjakmil, Jisas nɨp haglö, “God Ñɨ nɨpe. Nɨhön gɨnɨg auabön? Hanɨp ilön kub ñɨnɨg auabön aka nɨhön? Ñɨn ne hanɨp ram mɨnöŋ naij hag yuep u auagöp,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pen magö anɨbu, kaj iru nöp amɨl ñɨŋeila söl goƚ anɨb au me, ");
INSERT INTO kpw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kɨjaki aiön pi bɨ anɨb mɨhau kalɨp abaŋ alla gau, Jisas nɨp neb neb göl gɨ hagla, “Hanɨp hag yunɨg gɨmön u, hagö, amun kaj mɨdpal gɨdaŋ kalɨp yuö hiɨkun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hageila, Jisas “Arim,” a gö, bɨ anɨb mɨhau kalɨp arö göm, am kaj gau kalɨp yuö hiɨkla. Hiɨklö kaj gau pɨñɨŋ gɨ mɨnöŋ rul goƚ au amöm, gɨ dam ñɨg waŋö yaŋ paköm, ñɨg ñɨŋöm, magöŋhalö um hakla. ");
INSERT INTO kpw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pen bɨ kaj mukmɨdal gau, ga anɨbu nɨŋöm, yɨŋɨd daun u amöm, Jisas nɨhön nɨhön ga u, bɨ kɨjaki abaŋ alla mɨhau nɨhön nɨhön ga manö u, nɨbi bɨ gau kalɨp magöŋhalö hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hag ñeila, nɨbi bɨ daun mɨdeila anɨb gau magöŋhalö Jisas nɨp nɨŋun a göm, ap nɨp nɨŋöm, neb neb göl gɨ hagla, “Ram mɨnöŋ hon i arö gɨmön, ke gau aru,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas kauyaŋ ñɨg magɨb udöm, ñɨg waŋö juöm, ram mɨnöŋ nɨpe hanmɨdöp u böŋ lödaŋ ara. ");
INSERT INTO kpw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pen nɨbi bɨ rɨmnap, bɨ ñɨmagö ma kɨƚa ga ap, Jisas gö kamɨŋ lɨnab, a göm, nɨp ilöŋ lɨ dapöm Jisas mɨdeia au daula. Pen, Jisas gö kamɨŋ lɨnab, a göm nɨŋla rö, Jisas bɨ ñɨn ma kɨƚa ga anɨbu nɨp haga, “Ñɨ me! Gasɨ halö mɨdaimön. Nan si nan naij gɨpan gau nɨŋem arö gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisas anɨg hagö, God lo manö hag ñeb bɨ gau rɨmnap hagla, “Bɨ i God nɨp hag juöl gɨ me, anɨg hagab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pen Jisas gasɨ nɨŋla anɨbu ke nɨŋöm haga, “Kale nɨhön gɨnɨg yɨp gasɨ naij nɨŋmim anɨg hagabim? ");
INSERT INTO kpw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yad nɨp, ‘Nan si nan naij gɨpan gau nɨŋem arö gabin,’ a gɨnö, kalöp aij gɨnab, aka ‘Urak aru!’ a gɨnö, kalöp aij gɨnabŋ Aka manö nɨhön hagnö, kalöp aij gɨnab? ");
INSERT INTO kpw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mɨñi kale nɨŋnabim, Bapi God yɨp Bɨ Ñɨ nɨpe hag la nɨŋöm, mɨnöŋ naböŋ iƚ i apem, nan si nan naij gɨpal gau nɨŋem arö gɨnabin,” a ga. Jisas anɨg hagöm, bɨ ñɨn ma kɨƚa ga u nɨp haga, “Urakmön, köp ne u udmön, ram ne aru!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jisas anɨg hagö, bɨ anɨbu uraköm köp bad nɨpe u udöm ram nɨpe ara. ");
INSERT INTO kpw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ram nɨpe arö nɨŋöl gɨ, nɨbi bɨ gau nɨŋöm, God hagö Jisas apöm gab, a göm pɨñɨŋ göm, bɨ ap mɨnöŋ naböŋ iƚ i anɨb unbö rö gö nɨŋagpun a göm, God hib nɨpe haglö adö ara. ");
INSERT INTO kpw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas ram mɨnöŋ anɨbu arö göm, mɨgan ap amöm nɨŋa, bɨ dakɨs udep wög gɨmɨdöp bɨ ap ram raul mɨgan u asɨk mɨdeia. Bɨ anɨbu hib nɨpe Madyu. Jisas nɨp nɨŋöm haga, “Yad aip aue!” gö, uraköm Jisas aip ara. ");
INSERT INTO kpw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas bɨ nɨpe gau aip Madyu ram amöm, nan ñɨŋlö nɨŋöl gɨ, bɨ dakɨs udep gau abe, bɨ nan si nan naij gɨmɨdal bɨ gau abe, iru nöp apöm Jisas bɨ nɨpe gau aip nan ñɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nan ñɨŋeila, bɨ Perisi gau nɨŋöm, Jisas bɨ nɨpe gau kalɨp hagla, “Manö hag ñeb bɨ kale u, nɨpe nɨhön gɨnɨg, bɨ dakɨs udep gau abe, nɨbi bɨ nan si nan naij gɨpal gau abe, aip dɨm ñöl nan ñɨŋab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hageila, Jisas manö anɨbu apdi nɨŋöm haga, “Nɨbi bɨ nan gagöp gau, wös wameb bɨ gau aragpal; nɨbi bɨ nan göp gau nöp wös wameb bɨ gau arbal. ");
INSERT INTO kpw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pen God manö ap haga iƚ u nɨŋ aij gɨmim mɨdaimim. Nɨpe haga, ‘Yɨp nan sabe gɨ ñɨnabim u, yɨp aij gagnab; pen nɨbi bɨ gau kalɨp mög nɨŋmim gɨ aij geinabim u, yɨp aij gɨnab,’ a ga. Pen yad aunö u, nɨbi bɨ, hon nɨbi bɨ aij, mɨd aij gɨpun a gɨ gasɨ nɨŋbal gau, kalɨp uƚhai nɨŋ udnɨg auagnö; yad nɨbi bɨ, hon nan si nan naij gɨpun a gɨ gasɨ nɨŋbal gau, kalɨp uƚhai nɨŋ udnam a gem aunö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ñɨn ap, Jon ñɨg pak ñeb bɨ nɨpe gau, Jisas mɨdeia au apöm hagla, “Hon abe, bɨ Perisi gau abe, ñɨn rɨmnap, God nɨp nöp gasɨ nɨŋun, a gun, nan ñɨŋagpun. Pen bɨ ne gau nɨhön gɨnɨg u rö nöp gagpal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hageila, Jisas kalɨp haga, “Nɨbi bɨ gau, bɨ nɨbi udnɨg gab bɨ u aip mɨdeinaböl ñɨn u, mɨñ mɨñ göl göm nan ñɨŋnaböl; pen bɨ rɨmnap apöm bɨ anɨbu nɨp ud junaböl ñɨn u, mög gö nan hil göm ñɨŋagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pen Jisas nɨpe kalɨp manö ap hod rɨköm haga, “Waƚɨj gɨsön u udöm, waƚɨj papɨƚ gɨ, pa gɨ dö gɨnab ramö u al dör gagnaböl. Pen ai gɨnɨg göm al dör gagnabölŋ Anɨg geinaböl u, waƚɨj ƚuƚö gabin a gɨnɨg gab, mɨgan kub yabɨƚ pa bɨƚɨƚɨ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pen ñɨg wain u, u rö nöp. Wain gɨsön nɨbö u göm, ud kaj meme hañ mɨƚep mɨgan u ral lagnaböl. Pen nɨhön: anɨg geinaböl u, ñɨg wain kamɨŋ u ranöm, bɨŋ yabɨƚ hagöm, kaj meme hañ u pak gɨ dö göm, hoŋ göm arnab. Anɨb u, ñɨg wain kamɨŋ u udöm, kaj meme hañ kamɨŋ nɨbö mɨgan u ud lɨlö nöp me, aij gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas manö anɨbu hagö nɨŋöl gɨ, Juda bɨ kub ap Jisas mɨdeia au apöm, kugom yɨmöm haga, “Pai yad u böŋ nöp umöb u pen ne am nɨp ud nɨŋö, uraknɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hagö, Jisas bɨ nɨpe gau aip uraköm, bɨ anɨbu aip arla. ");
INSERT INTO kpw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pen nɨbi ap, hagape lugöl gɨ lugöl gɨ mɨdeia, mɨ unbö mɨgan laŋ ina. Anɨg gö, gasɨ nɨpe u nöp nɨŋöm, “Jisas waƚɨj nɨpe mɨlö kub goƚ gau nöp ud nɨŋnö, yɨp kamɨŋ lɨnab,” a göm, Jisas arö nɨŋöl gɨ, jöl adö gau amöm, waƚɨj nɨp u ud nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ud nɨŋö, Jisas ado göm nɨbi anɨbu nɨp nɨŋöm haga, “Yɨp nɨŋ udpan u me, nöp kamɨŋ löp. Gasɨ halö mɨdaimön,” a ga. Hagö, nan nɨp gɨmɨdöp u magö anɨbu nöp kamɨŋ löm, hagape aumɨdöp u mɨƚep ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pen Jisas nɨbi bɨ anɨbu arö göm am am, bɨ kub ram u amjaköm nɨŋa, aƚɨŋ magö pu göm, manö hauƚ kub yabɨƚ geila. ");
INSERT INTO kpw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas nɨŋöm kalɨp haga, “Kale ke gau arim! Pai i umagöp; yɨharɨŋ hon hanab,” a ga. Anɨg hagö, nɨp mɨhol gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pen Jisas nɨbi bɨ anɨb gau kalɨp hag höŋ yuöm, ram raul mɨgan yaŋ amöm, pai uma u nɨp, ñɨmagö kɨd u ud nɨŋö, uraka. ");
INSERT INTO kpw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Anɨg gö, manö anɨbu yag dam ram mɨnöŋ anɨb gau magöŋhalö ud arla. ");
INSERT INTO kpw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pen Jisas ram mɨnöŋ anɨbu arö göm arö nɨŋöl gɨ, bɨ amgö magö we ga mɨhau nɨp hain göl gɨmil meg mɨgan dap ranmil, haglö, “Depid Ñɨ nɨpe! Halɨp mɨhöŋ mög nɨŋmön!” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anɨg hagailö, pen Jisas nɨpe ram raul mɨgan u ara. Bɨ anɨb mɨhau hain ammil ram u apjaklö, Jisas kalɨp mɨhöŋ haga, “Kale mɨhöŋ, yad kalöp gɨnö kamɨŋ lɨnab a gɨmil, yɨp ap hagabilŋ Yad yau a gɨnabin, kale gasɨ nɨŋbil amgö kale ñɨl lɨnab aka wasö?” ö ga. Hageia, haglö, “Bɨ Kub, holmɨŋ nɨŋbul, ne halɨp geinabön kamɨŋ lɨnab,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hagailö, Jisas amgö kalɨp mɨhöŋ ud nɨŋöm haga, “Yɨp nɨŋ udpil u me, hagpil rö gɨnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hagö, amgö kalɨp mɨhöŋ kamɨŋ lö, nɨŋlö nɨŋöl gɨ, Jisas kalɨp mɨhöŋ manö kƚö hagöm hag aij göm haga, “Nɨbi bɨ gau, Jisas gajɨp halɨp kamɨŋ löp, a gɨmil hagagmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anɨg haga u pen kalpe mɨhöŋ ammil, nɨbi bɨ ram mɨnöŋ aŋ anɨb gau magöŋhalö hag ñɨlö ara. ");
INSERT INTO kpw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pen kalpe mɨhöŋ arlö nɨŋöl gɨ, nɨbi bɨ rɨmnap, bɨ aiön pi halö aɫab ado ga bɨ ap, dap Jisas mɨdeia au daueila. ");
INSERT INTO kpw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas aiön pi bɨ anɨbu nɨp abaŋ ala u hag yuö, manö hag aij ga. Anɨg gö, nɨbi bɨ gau aiö göm hagla, “Ram mɨnöŋ Isrel i, bɨ ap anɨbu rö gö nɨŋagpun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pen bɨ Perisi gau hagla, “Nɨpe kɨjaki aiön pi nap kale Seden kƚö u udöm me, aiön pi gau hag höŋ yuöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pen Jisas nɨpe daun pro gau abe, daun kub gau abe gɨ ajöl göm, Juda magum gep ram gau amöm, Kiŋ kub ke yabɨƚ u nɨbi bɨ udöm abad mɨdeinab manö aij u hag ñɨmɨdöp. Pen nɨbi bɨ gau kalɨp nan nɨhön nɨhön ga u, u rö nöp gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jisas nɨŋa, nɨbi bɨ anɨb gau kaj sipsip gau bɨ abad mɨdep kale ap mɨdagöp rö u mɨdeila. Gasɨ kub nɨŋöm uɫham mɨdeila u pen kalɨp bɨ gɨ ñeb ap mɨdageia. Anɨb u nɨŋöm, Jisas nɨpe mög yabɨƚ nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","bɨ nɨpe gau kalɨp haga, “Nan magö iru yabɨƚ nöp wög naböŋ au po gɨ mɨdöp u pen nɨbi bɨ ral dauep iru mɨdagpal. ");
INSERT INTO kpw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Anɨb u, kale bɨ wög naböŋ nap nɨbö u nɨp hag nɨŋbe, bɨ ral dauep rɨmnap yuö, ral dap nɨp lau adö dauöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas bɨ nɨpe unbö mɨgan laŋ u wɨñ alö aueila haga, “Yad ke kalöp hagabin u me, kɨjaki aiön pi nan gau hag yunɨg, hag yunabim. Nɨbi bɨ nan nɨhön nɨhön gɨnab gau u rö nöp gɨpe, kamɨŋ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bɨ Jisas manö ud arep unbö mɨgan laŋ Jisas hag yua bɨ gau, hib kale gau me, bɨ ap Saimon, hib nɨpe ap Pida a gɨmɨdal; bɨ ap Edru, Pida nɨmam nɨpe u; bɨ ap Jems, Sebedi ñɨ nɨpe; bɨ ap Jon, Jems nɨmam nɨpe; ");
INSERT INTO kpw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","bɨ ap Pilip; ap Badolomyu; ap Domas; ap Madyu, nɨpe dakɨs udmɨdöp; bɨ ap Jems, Alpias ñɨ nɨpe; bɨ ap Dadias; ");
INSERT INTO kpw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bɨ ap Saimon, hib nɨpe ap Selod a gɨmɨdal; bɨ ap Judas Iskariod, nɨpe me hainö Jisas nɨp mumug nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas bɨ nɨpe anɨb gau kalɨp manö aij wög u göl a göm, hag ke ke yuöl gɨ haga, “Kale Juda nɨbi bɨ wasö aŋ gau abe, Sameria kai mɨdpal aŋ gau abe, aragmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pen kale am nɨbi bɨ hon Isrel, nɨbi bɨ kale God nɨp gasɨ nɨŋagpal gau, kalɨp hag ñöl gɨ hagmim, ");
INSERT INTO kpw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“God nɨbi bɨ udöm abad mɨdeinab ñɨn u, hadö söl auöp,” a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nɨbi bɨ nan gɨnɨm gau gɨpe, kamɨŋ lɨnɨm. Nɨbi bɨ böŋ nöp umöl gau gɨpe, kauyaŋ uraköl. Nɨbi bɨ wös hapeb lɨnɨm gau gɨpe, kamɨŋ lɨnɨm. Nɨbi bɨ kɨjaki aiön pi abaŋ alnɨm gau hag höŋ yube araŋ. Bapi hol apɨl kalöp pör yɨharɨŋ wög gɨpul rö, kale u rö nöp nɨbi bɨ anɨb gau kalɨp yɨharɨŋ wög gɨ ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mani gol, mani silpa, mani aɫɨ rɨmnap ud aragmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wadɨ, waƚɨj rɨmnap halö, ma rɨrup, waƚab adɨŋ, nan gau ud aragmim. Pen nɨhön: nɨbi bɨ wög gɨ ñɨnaböl gau pen nan ñɨlö ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pen daun ap aka ram rɨƚɨg agƚö ap amjakpe, nɨbi bɨ kalöp hag wɨhai udöl rö rɨmnap nɨŋmim, kalɨp aip nöp mɨdmim, ram mɨnöŋ ke ap gau arnɨg gɨnabim ñɨn u nöp, kalɨp arö gɨmim armim. ");
INSERT INTO kpw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","14","Pen ram ap ammim, “Kale mɨdpim!” a gɨpe, “Yau, mɨdpun; aij aubim,” a gaiöl, ram raul mɨgan anɨbu armim. Pen kalöp manö yad hag ñɨmim hag wɨhai ud nɨŋagaiöl u, arɨk arnɨg, acɨp acɨp ma kɨd kale cɨg udöm mɨdainɨm u, ab ƚɨƚɨ gɨ yumim armim. ");
INSERT INTO kpw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yad kalöp nɨŋö yabɨƚ hagabin: manö kub hagep ñɨn u, Sodom Gomora nɨbi bɨ ilön pro pro udnaböl; nɨbi bɨ kalöp udagnaböl anɨb gau, ilön kub yabɨƚ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pen nɨŋim! Yad kalöp kaj sipsip rö u, nɨbi bɨ kain hauƚ rö mɨdpal aŋ gau yuabin. Anɨb u, gasɨ nɨŋ aij göl gɨ, agamɨj kalɨp hag ñöl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Pen nɨbi bɨ rɨmnap kalöp ud sɨsɨ löm, dam Juda magum gep ram gau arlö, kansol kale gau ap manö kub hagöm, kalöp paknaböl. Anɨb u, nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kalöp bɨ yad a göm, ɫɨp gɨ dam gapman bɨ kub aka kiŋ mɨdeinaböl au ud arlö, kale manö aij yad u, bɨ kub gau abe, Juda nɨbi bɨ wasö ram mɨnöŋ mɨlö kub gau nɨbö gau abe, kalɨp hag ñɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Kalöp manö kub hagnaböl anɨbu, manö nɨhön hagun aka manö aige gun hagun a gɨmim pɨñɨŋ gɨmim, gasɨ iru nɨŋagmim. Hagpe nɨŋöl gɨ, Nap God Ana nɨpe kale aip mɨdöp u, gasɨ aij ñeinab, manö kale adö u ke hagagnabim; Nap God Ana nɨpe kalöp hagnab rö nöp hagnabim. ");
INSERT INTO kpw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ñɨn anɨbu, nɨmam gau uraköm, nɨmam kale ke gau al paklaŋ a göm, bɨ kub gau kalɨp mumug gɨnaböl. Nap gau uraköm, ñɨ pai kale ke gau al paklaŋ a göm, bɨ kub gau kalɨp mumug gɨnaböl. Ñɨ pai gau uraköm, nɨme nap kale ke gau jöl ñöm u rö nöp gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yɨp lau adö mɨdeinabim rö, nɨbi bɨ gau magöŋhalö kalöp nɨŋlö, mulu kal alnab. Pen nɨbi bɨ an kƚö göm, yɨp pɨg nöp mɨdeinaböl gau, ñɨn hain u auö, God kalɨp udnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pen mɨgan ap arbe, kalöp gɨ naij gaiöl u, pɨñɨŋ gɨ mɨgan ap armim. Yad kalöp nɨŋö hagabin, Isrel daun gau nɨbi bɨ gau kalɨp hag ñɨbe aragnab adö, yad Bɨ Ñɨ nɨpe aunabin. ");
INSERT INTO kpw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Ñɨ pai skul hagpal gau kub mɨdlö, hag ñeb bɨ kale gau pro mɨdagpal. Pen hag ñeb bɨ mɨdöp rö mɨdaiun a göm me, skul hagpal. Nɨbi bɨ wög gɨ ñɨbal gau kub mɨdlö, nɨbi bɨ kalɨp abad mɨdpal gau pro mɨdagpal. Wög gɨpal u, nɨbi bɨ kub mɨdpal rö mɨdaiun a göm, wög gɨpal. Anɨb u rö, nɨbi bɨ yad gau, yad mɨdpin rö mɨdaiun a göm, gɨpal. Pen nɨbi bɨ gau yɨp hag juöm, Seden hib nɨpe ap löm yɨp Bielsebul a gɨpal rö, kalöp bɨ wög gɨ ñeb yad u rö nöp hag juöm manö naij hagnaböl me. ");
INSERT INTO kpw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nɨbi bɨ gau kalɨp nɨŋmim pɨñɨŋ gagmim. Manö nɨhön mɨñi harɨ göl mɨdöp u, hainö waiö mɨdeinab. Nan nɨhön agamɨj gɨpal gau, hainö waiö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Manö yad kalöp pi gem hagnabin u, kale am kalɨp waiö hag ñɨmim. Manö yad kalöp rɨmɨd iƚ hagnabin u, ram adö laŋ ammim, manö kub hag ñɨbe nɨŋöl. ");
INSERT INTO kpw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kale nɨbi bɨ al pak lɨbal bɨ gau nɨŋmim pɨñɨŋ gagmim. Kale yɨharɨŋ hañ bad u nöp al pak lɨnaböl; ana u halö gɨ naij göl rö lagöp. Pɨñɨŋ gɨnɨg me, Bɨ Kub nɨbi bɨ hañ romaŋ abe ana abe mɨgan mab ke inab yaŋ yunab u nɨp pɨñɨŋ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yaur pro gau, nan yɨharɨŋ. Mani aɫɨ magö añɨ nöp yuöm, mɨhöp udpal. Nan yɨharɨŋ u pen, God kalɨp nɨŋ mɨdöp rö, ap yɨharɨŋ lug pakagnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Umagö kalöp u, God magöŋhalö wö ralöp. ");
INSERT INTO kpw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Anɨb u, pɨñɨŋ gagmim. Yaur gau nan pro yabɨƚ; kale pen nan yabɨƚ mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nɨbi bɨ an yɨp lau adö mɨdöm, nɨbi bɨ gau kalɨp waiö hag ñɨnaböl gau, yad pen Bapi yad kumi kabö adö laŋ mɨdöp u nɨp, yɨp lau adö mɨdpal, a gem, waiö hagnabin. ");
INSERT INTO kpw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pen nɨbi bɨ an, yɨp cɨg aij gagöm, nɨbi bɨ aip mɨdeinaböl aŋ au hagnaböl, bɨ anɨbu yad nɨŋagpin, a gɨnaböl u, yad pen Bapi yad kumi kabö adö laŋ u nɨp, nɨbi bɨ gai i yad nɨŋagpin, a gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yad mɨnöŋ naböŋ iƚ i aunö u, ‘Jisas nɨpe mɨnöŋ naböŋ iƚ i aua rö, agamɨj mɨd aij gɨnabun,’ a gɨmim, gasɨ u nɨŋagmim. Yad aunö u me, nɨbi bɨ gau manö kub hagöm, pen pen gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Anɨg gɨnab: ñɨ gau uraköm, nap aip pen pen gɨnaböl. Pai gau uraköm, nɨme aip pen pen gɨnaböl. Ñɨ nɨbin gau uraköm, nɨpɨs aip pen pen gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anɨg gɨnaböl anɨbu, ram kale añɨ mɨdpal u, kale ke nöp pen pen gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nɨbi bɨ an, nɨme nap aka ñɨ pai gau nöp mɨdmagö löm, yɨp mɨdmagö lagnaböl u, nɨbi bɨ yad mɨdöl rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nɨbi bɨ an yɨp pɨg mɨdnɨg gaböl, pen gasɨ ap nɨŋöm hagnaböl, ‘Nɨbi bɨ rɨmnap hanɨp gɨ naij göl rö löp,’ a göm, yɨp arö gɨnaböl u, nɨbi bɨ yad mɨdöl rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɨbi bɨ an, yad ke nöp mɨdem, mɨd aij gɨnam a gɨnab u, mab ke inab yaŋ u arnab. Nɨbi bɨ an pen hagnab, yad Jisas lau adö mɨdnö, yɨp al pak lɨnɨg al pak löl a gɨnab u, kamɨŋ pör pör mɨdep u udnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kale arbe, nɨbi bɨ rɨmnap kalöp hag wɨhai udaiöl u, yɨp abe hag wɨhai udnaböl. Pen yɨp hag wɨhai udnaböl rö, Bɨ yɨp hag yuö aunö u nɨp abe hag wɨhai udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɨbi bɨ an, God manö hagep bɨ ap nɨŋöm hagnab, ‘Bɨ auöp i, God wög göp u me, nɨp udnabin,’ a göm, udnab u, aij yabɨƚ gɨnab. God manö hagep bɨ anɨbu ud aij gɨnab rö, hainö God nɨp u rö nöp ud aij gɨnab. Nɨbi bɨ an, God nɨbi bɨ kamɨŋ aij nɨpe ap nɨŋöm hagnab, ‘Bɨ auöp i, God bɨ kamɨŋ aij nɨpe u me, nɨp udnabin,’ a göm udnab u, aij yabɨƚ gɨnab. God nɨbi bɨ kamɨŋ aij nɨpe u ud aij gɨnab rö, hainö God nɨp u rö nöp ud aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pen nɨbi bɨ an, bɨ yɨharɨŋ yad ap nɨŋöm, Jisas bɨ nɨpe u a göm, ñɨg mɨl dap ñɨnab u, God nɨŋö, aij gö, pen hauƚ gagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas bɨ nɨpe unbö mɨgan laŋ gau kalɨp anɨg göl anɨg göl gɨmim a göm hag ñɨ aij göm, ram mɨnöŋ anɨbu arö göm, daun yöp söl anɨb gau amöm, nɨbi bɨ gau kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pen Jon bɨ ñɨg pak ñeb u nagɨ mɨdöm, Krais nɨhön nɨhön ga manö u nɨŋöm, bɨ nɨpe rɨmnap hag yuö, Krais mɨdeia au amjaköm, ");
INSERT INTO kpw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nɨp hag nɨŋöm hagla, “Hanɨp hag ñɨmön, ne bɨ ‘Krais’ a gun pör abad mɨdpun u nöp auban, aka hon bɨ hain nɨbö anɨbu ke abad mɨdaiun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hageila, Jisas kalɨp haga, “Kale Jon mɨdöp au ammim hagmim, ‘Hon amun amgö hon ke nɨŋun, rɨmɨd hon ke nɨŋbun, ");
INSERT INTO kpw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bɨ anɨbu nɨbi bɨ amgö we göp gau gajɨp amgö nɨŋbal. Nɨbi bɨ ma naij göp gau gajɨp adan aj aij gɨpal. Nɨbi bɨ wös hapeb löp gau gajɨp mɨƚep göp. Nɨbi bɨ rɨmɨd mɨgan pɨƚ göp gau gajɨp gasɨ wakö nɨŋbal. Nɨbi bɨ umbal gau gajɨp kauyaŋ urakpal. Nɨbi bɨ mög gep rö gau, u rö nöp Krais manö aij u hagö nɨŋbal,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pen manö ap hagmim, ‘Nɨbi bɨ yɨp nɨŋ udöm, gasɨ ap ap nɨŋagnaböl gau, mɨñ mɨñ yabɨƚ gɨnaböl,’ a gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Anɨg hagö, Jon bɨ nɨpe gau arlö nɨŋöl gɨ, Jisas nɨbi bɨ ap mɨdeila gau kalɨp Jon manö adö u hagöm haga, “Kale nöd ram mɨnöŋ kabö nöp mɨdöp aŋ gau arbe ñɨn u, nɨhön nɨŋnɨg arbeŋ Hod mɨlö añɨ ap yɨgön ud daŋ i göp ap nɨŋnɨg arbe? ");
INSERT INTO kpw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aka nɨhön nɨŋnɨg arbeŋ Bɨ waƚɨj aij aij nöp lɨbal bɨ ap nɨŋnɨg arbeŋ Bɨ waƚɨj aij aij udun a göm nɨŋbal gau, bɨ kub ram kƚiñ aij gau hanbal. Kale Jon mɨdmɨdöp ram mɨnöŋ nöp aŋ au han mɨdagmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pen nan nɨhön nɨŋnɨg arbeŋ Yɨharɨŋ aragpe. Jon bɨ God manö hagep, bɨ anɨbu nɨŋnɨg arbe. Bɨ God manö hagep aunab a gɨmim abad mɨdmɨdim me, bɨ anɨbu me u. Pen Jon nɨpe God manö hagep bɨ nöp wasö. ");
INSERT INTO kpw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon nɨp gasɨ nɨŋöm, hadame nöp God nɨpe Ñɨ nɨpe nɨp manö haga manö anɨbu, God Manö yaŋ kalɨ kƚiñ rɨköm hagla, ‘Bɨ manö hagep yad u, hag yunö nöd amöm, nɨbi bɨ gau hag ñɨ aij gö, hainö ne ke arnabön,’ a göm kalɨ kƚiñ rɨkla. ");
INSERT INTO kpw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kalöp hagabin, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau, añɨ ap Jon rö wasö. Pen God nɨbi bɨ yɨharɨŋ yabɨƚ dam kumi kabö adö laŋ au abad mɨdeinab gau, kale Jon rö mɨdageinaböl; God nɨpe nɨbi bɨ yɨharɨŋ yabɨƚ gau ud aij yabɨƚ gö, nɨbi bɨ aij nɨpe yabɨƚ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon bɨ ñɨg pak ñeb bɨ apöm manö aij hag ña ñɨn u rɨköm, nɨbi bɨ gau, God hanɨp udöm kumi kabö adö laŋ au abad mɨdainɨm a göm, manö anɨbu kƚö yabɨƚ gɨ dam dam, mɨñi u rö nöp kƚö yabɨƚ gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Bɨ God manö hagep manö kalɨ kƚiñ rɨkla gau abe, Mosɨs God lo manö kalɨ kƚiñ rɨka u abe, iƚ u me, God Mesaia u nɨp yuö, nɨpe nɨbi bɨ gau kalɨp udöm abad mɨdeinab. Manö anɨbu nöp hag daulö daulö me, Jon aua. ");
INSERT INTO kpw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pen manö hagnɨg gabin u udnabim aka nɨŋagpin. God Jon nɨp hagö, apöm nɨbi bɨ gau kalɨp manö hag ña u, God Manö kalɨ kƚiñ rɨköm, gɨnab a gɨla rö nöp ga. Kalɨ kƚiñ rɨköm hagla, bɨ God manö hagep Ilaija rö bɨ ap aunab, a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nɨbi bɨ mɨñi ñɨn i mɨdpal gau yad nɨŋbin, kale ñɨ paiŋaŋ rɨmnap maker au asɨköm, ñɨ paiŋaŋ rɨmnap meg mɨgan dap ranöm kalɨp hagpal rö u mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kale hagpal, ‘Hon aƚɨŋ pu gɨno, kale nɨhön gɨnɨg kugom ralagpim? Kɨmap mɨɫöŋ gep rö ap hagno, kale nɨhön gɨnɨg mɨɫöŋ gagpim?’ ö gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Anɨb u rö, God Jon nɨp yuö apöm, ñɨn rɨmnap nan magö ñɨŋagöm, ñɨg wain ñɨŋagöm gö, hagla, ‘Bɨ anɨbi nɨp nan nɨhön abaŋ alö anɨg göp?’ ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bɨ Ñɨ nɨpe pen auö hagpal, ‘Bɨ nan kub ñɨŋöm, ñɨg wain ñɨŋöm, bɨ dakɨs udpal gau aip ajöm, bɨ nan naij gɨpal gau aip ajöm göp,’ a gɨpal. Pen nɨbi bɨ God Manö u nɨŋ udöm, gɨ aij göm, mɨd aij gɨnaböl u, nɨbi bɨ gau nɨŋöm hagnaböl, God Manö u manö aij yabɨƚ, a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Jisas daun kub nöd gɨ ajöm, nan gagep iru nöp gö, nɨbi bɨ gau nɨŋla u pen kale, nɨhön gɨnɨg nan si nan naij gɨpun a göm, nan si nan naij gɨmɨdal u arö göm, Jisas nɨp nɨŋ udagla. Anɨg gɨlö, Jisas kalɨp hag göm haga, “Korasin daun nɨbi bɨ gau! Bedsaida daun nɨbi bɨ gau! Nan gagep gau gɨnö, nɨŋbe. Pen nan si nan naij gɨpim u arö gɨmim, yɨp nɨŋ udagpim. Anɨg gɨpim u, kale manö kub yabɨƚ udnabim. Daun kub Daia Juda nɨbi bɨ wasö gau, daun kub Saidon Juda nɨbi bɨ wasö gau, nan gagep anɨb gau kalɨp u rö nöp gaibnep, kale nan si nan naij gɨmɨdal gau arö göm, wadɨ asöl rö rɨmnap yɨmöm, run he löl gɨ löl gɨ mɨdaiblap. ");
INSERT INTO kpw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anɨb u, manö kub hagep ñɨn u, Daia nɨbi bɨ abe, Saidon nɨbi bɨ abe, manö pro rö udnaböl; pen kale Korasin nɨbi bɨ abe, Bedsaida nɨbi bɨ abe, manö kub yabɨƚ udnabim. ");
INSERT INTO kpw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapaneam nɨbi bɨ gau. Ñɨn anɨbu kale kumi kabö adö laŋ au aragnabim; böŋ nöp mab ke inab uƚöm mɨgan yaŋ u arnabim. Nan gagep kale aŋ aui gɨnö u, daun kub Sodom gaibnep, kale nan si nan naij gɨmɨdal gau arö göm, uri kamɨŋ mɨdaiblap. ");
INSERT INTO kpw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Adö anɨbu yad kalöp nɨŋö hagabin, manö kub hagep ñɨn u, Sodom nɨbi bɨ gau manö pro rö udnaböl; kale Kapaneam nɨbi bɨ manö kub yabɨƚ udnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ñɨn anɨbu Jisas Nap nɨp haga, “Bapi, yad hib ne hagnö adö laŋ araŋ. Ne Bɨ Kub, kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe abad mɨdpan u, gasɨ ne ke nɨŋö aij göp rö, nɨbi bɨ gasɨ kɨd hiɨk nɨŋun nɨŋbun a gɨpal gau, kalɨp manö yad hagabin iƚ u hag ñagpan; pen nɨbi bɨ ñɨ paiŋaŋ rö mɨdpal gau kalɨp gasɨ aij ñɨmön, manö yad hagabin iƚ u hag waiö lɨban u, nöp aij a gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas anɨg hagöm haga, “Bapi kƚö nɨpe mɨdöp rö, yɨp ñöb. Nɨbi bɨ rɨmnap yɨp nɨŋ aij gagpal; Bapi nöp yɨp nɨŋöb. Yad nöp Bapi nɨp nɨŋ aij gɨpin. Pen nɨbi bɨ gasɨ aij ñɨnam a gem nɨŋbin gau, kalɨp gasɨ aij ñɨnö, Bapi nɨp nɨŋnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jisas anɨg hagöm haga, “Kale nɨbi bɨ nan wañɨb kub iru maru pör ud ajmim gasɨ iru nɨŋmim mɨdpim gau, yad aumim nɨŋöm nan wañɨb kub iru maru ud ajabim gau yad ke udnö ake lɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yad bɨ hain aij agamɨj mɨdpin; kal gagnabin; anɨb u, yɨp aumim, wög yad gɨ ñɨmim, hibur gasɨ mɨdmagö kalöp aŋ daŋ ake lɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kale yɨp aumim wög yad geinabim u, ud marö ap gagnab; pɨɫa gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juda God nɨp sabe gep ñɨn u, Jisas bɨ nɨpe gau aip wid wög aŋ au amöl gɨ, bɨ nɨpe gau kɨyö lö, wid magö anɨb gau rɨmnap udöm, hañ pak yuöm, ñɨŋöl gɨ ñɨŋöl gɨ areila. ");
INSERT INTO kpw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Anɨg geila, bɨ Perisi gau nɨŋöm, Jisas nɨp hagla, “Lo manö hon hagab, nɨbi bɨ God nɨp sabe gep ñɨn u wög gagnaböl. Pen bɨ ne gau nɨhön gɨnɨg God nɨp sabe gep ñɨn wög gagep i, wid magö hañ pak yuaböl?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Hageila, Jisas kalɨp haga, “Depid hadame nöp bɨ nɨpe gau aip kɨyö lö, God sabe gep ram u amjaköm, bred God amgö ilö adö au löm, bɨ yɨharɨŋ ñɨŋagpal, bɨ God nɨp nan sabe gɨpal gau nöp ñɨŋbal bred u, kalɨp hag nɨŋö nɨp ñɨlö, bɨ nɨpe gau aip ñɨŋla. Pen kɨyö lö gɨla aiud anɨbu, God Manö yaŋ kalɨ kƚiñ rɨkla u kale nɨŋagpim ar? ");
INSERT INTO kpw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Kale Mosɨs God Manö kalɨ kƚiñ rɨka u nɨŋagpim rö löp. Nɨpe kalɨ kƚiñ rɨköm haga, ‘Bɨ God nɨp nan sabe gep bɨ gau, God nɨp sabe gep ñɨn u, God sabe gep ram raul u am mɨdöm, wög gɨpal. Pen God kalɨp manö kub hagagnab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pen yad kalöp hagabin, God sabe gep ram anɨbu nan kub wasö; yad ke pen Bɨ kub yabɨƚ mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pen manö ap God Manö kalɨ kƚiñ rɨkla u, nɨŋ aij gagpim akaŋ Manö anɨbu kalɨ kƚiñ rɨköm hagla, ‘Nɨbi bɨ yɨp nan pak sabe gɨ ñɨnaböl u, yɨp aij gagnab; nɨbi bɨ gau kalɨp mög nɨŋnaböl u, yɨp aij gɨnab,’ a gɨla. Manö anɨbu nɨŋmim gagpim u me, bɨ yad gau gɨ aij gɨlö nɨŋöl gɨ, kalɨp ud sɨƚɨk hagpe. ");
INSERT INTO kpw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","‘God nɨp sabe gep ñɨn! God nɨp sabe gep ñɨn!’ a gɨpim u pen Bɨ Ñɨ nɨpe nöp God nɨp sabe gep ñɨn u abad mɨdöp a gɨmim gasɨ u nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas ram mɨnöŋ anɨbu arö göm, ram mɨnöŋ ap aramöm, Juda magum gep ram raul mɨgan u ara. ");
INSERT INTO kpw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pen ram raul mɨgan anɨbu bɨ ñɨmagö pɨno ga ap mɨdeia. Nɨbi bɨ ap mɨdeila gau, Jisas manö rɨmnap hagö nɨp dam manö kub hagun a göm, nɨp manö pir alöm hagla, “God nɨp sabe gep ñɨn i, nɨbi bɨ kamɨŋ lep aka wasö?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hageila, Jisas kalɨp haga, “Kaj sipsip kale ap God nɨp sabe gep ñɨn i uƚöm mɨgan areinab u, ud yunabim aka wasöŋ Ud yunabim rö löp. ");
INSERT INTO kpw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pen kaj sipsip u nan yɨharɨŋ. Nɨbi bɨ u nan yabɨƚ. God nɨp sabe gep ñɨn i kamɨŋ laŋ a gun gɨnabun u, manö mɨdagöp, gɨnabun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisas anɨg hagöm, bɨ ñɨmagö pɨno ga u nɨp haga, “Ñɨn mɨlöbö lɨ!” a ga. Anɨg hagö, ñɨmagö mɨlöbö labin a ga. Anɨg ga nɨŋöm ñɨmagö pɨno ga u böŋ nöp kamɨŋ löm, ñɨmagö böŋ lau aij mɨdeia u rö la. ");
INSERT INTO kpw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anɨg gö nɨŋöm, bɨ Perisi gau am magum göm, nɨp anɨg anɨg gun al pak lun, a göm, manö hag nɨŋ hag nɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Anɨg geila, Jisas nɨŋöm, ram mɨnöŋ anɨbu arö göm, mɨgan ap arnɨg göm ara. Arö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨp hain gɨla. Anɨg geila, nɨbi bɨ nan ga gau, nɨpe gö magöŋhalö kamɨŋ lö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kalɨp haga, “Bɨ u anɨg anɨg göp a gɨmim, hagagmim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas ga anɨbu, bɨ God manö hagep Aisaia gɨnab a ga rö nöp ga. Nɨpe kalɨ kƚiñ rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bɨ yad böŋ nöp hag lɨbin i, wög yad gɨ ñab. Bɨ yad nɨŋnö, yɨp aij yabɨƚ göp me u. Yad nɨpe mɨdmagö lɨbin. Ana yad u nɨp aɫ ba gö, nɨbi bɨ kale aigöl göm asɨ mɨd aij gɨnaböl manö yad u, nɨbi bɨ gau magöŋhalö hag ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pen nɨpe nɨbi bɨ gau nɨŋö mulu lugö, manö pen pen hagagnab. Nɨbi bɨ mɨdpal gau, yɨp nöp nɨŋöl a göm, meg magö dap ranöm hagagnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nɨbi bɨ nɨŋagpal gau kalɨp agamɨj hag aij gɨnab. Ƚam hoŋ gɨnɨg gö, kaƚasin rɨm lɨlö inmɨdöp rö u kalɨp hagnab. Nɨpe anɨg göl gɨ damöm me, God hagöp rö böŋ u apranö, nan si nan naij gep böŋ u böŋ nöp ap lugnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nɨbi bɨ ram mɨnöŋ gau nɨbö gau u rö nöp, nɨp gasɨ halö abad mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɨ kɨjaki abaŋ alö, amgö we göm, maj hañ pɨƚ göm ga bɨ ap dam Jisas mɨdeia au daueila. Jisas kɨjaki u hag höŋ yuö, amgö yabɨƚ nɨŋöm, manö hagöm ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nɨbi bɨ mɨdeila gau, Jisas ga anɨbu nɨŋöm, aiö göm hagla, “Bɨ anɨbi bac Depid Ñɨ nɨpe pör abad mɨdpun u rö löp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pen bɨ Perisi gau manö anɨbu nɨŋöm, gasɨ kale gau nöp nɨŋöm hagla, “Bɨ anɨbu God kƚö nɨpe udöm hag höŋ yuagöp; nɨpe kɨjaki aiön pi nan gau, nap kale Bielsebul kƚö udöm hag yuöp,” a gɨ gasɨ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Pen gasɨ nɨŋla anɨbu, Jisas ke nɨŋöm, kalɨp haga, “Seden uraköm, nɨbi bɨ nɨpe rɨmnap hag yunab u, aige göm bɨ kub mɨdeinabŋ Ram mɨnöŋ ap, kale ke pen pen hagöm asɨk ke ke lɨnaböl u, ap lug paknaböl. Ram mɨnöŋ kub ap aka nɨbi bɨ iƚ añɨ ap, kale ke pen pen hagöm asɨk ke ke lɨnaböl u, ap lug paknaböl. Kale anɨbu rö hagabim u pen Seden nɨpe yam nɨpe ke gau kalɨp hag yuagnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Yɨp hagpim, ‘Kɨjaki aiön pi nan gau nap kale Bielsebul kƚö u udmön hag höŋ yuban,’ a gɨpim u pen kale yɨp hagpe nɨŋɨn: bɨ kale ke gau Bielsebul kƚö u udöm kɨjaki aiön pi nan gau hag höŋ yubal aka nɨhön? Kale ke hagnaböl, ‘Nɨbi bɨ ap anɨg göl rö lagöp,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Pen God Ana kƚö u udem, kɨjaki aiön pi nan gau hag höŋ yuabin u, nɨhön gɨnɨg God bɨ nɨpe nɨbi bɨ udöm abad mɨdeinab ñɨn u hadö auöp i a gɨmim yɨp udagpim? ");
INSERT INTO kpw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bɨ kƚö yabɨƚ ap mɨdö, nan nɨp gau udnɨg, yɨharɨŋ aragnaböl. Nɨp böŋ nöp nagɨ adɨk löm me, amöm nan nɨp gau udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nɨbi bɨ yad pɨg mɨdpal gau, nɨbi bɨ gau kalɨp yad daunaböl. Pen nɨbi bɨ yad wasö gau, nɨbi bɨ yad aunɨg gaböl gau kalɨp rɨdɨk gɨ yunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anɨb u, kale nɨŋ aij gɨmim. Nɨbi bɨ gau nan si nan naij nɨhön nɨhön geinaböl u, God nɨŋöm arö gɨnab. Nɨbi bɨ God nɨp manö rɨb junaböl u, u rö nöp God nɨŋöm arö gɨnab. Pen God Ana nɨp manö rɨb junaböl u, God nɨŋöm arö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bɨ Ñɨ nɨpe u nɨp manö naij hageinaböl u, God nɨŋöm arö gɨnab. Pen Ana Uɫ nɨp manö naij hageinaböl u, ñɨn i abe, ñɨn hain u abe, God nɨpe nɨŋ nöp mɨdöm arö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kale yɨp nɨhön gɨnɨg hagpim, ‘Seden abaŋ alö, wög aij u göp,’ a gɨpimŋ Mab aij gau magö aij pɨlnab; mab naij gau magö naij pɨlnab. Mab magö pɨlnab magö anɨbu nɨŋöm me, mab u aij mab u naij a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kale haiŋo ñɨ pai yag daubal gau me anɨg hagabim. Kale nɨbi bɨ naij anɨbu rö, aige gɨmim manö aij hagnabimŋ Nɨbi bɨ manö hagpal rö nɨŋnabun me, hibur gasɨ mɨdmagö kalɨp aŋ daŋ nɨhön rö mɨdöp u nɨŋnabun. ");
INSERT INTO kpw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nɨbi bɨ aij gau, hibur gasɨ mɨdmagö aŋ kale daŋ nan aij mɨdöp nɨŋöm gɨ aij gɨpal; nɨbi bɨ naij gau, hibur gasɨ mɨdmagö aŋ kale daŋ nan naij mɨdöp nɨŋöm gɨ naij gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nɨŋ aij gɨmim. Hainö manö kub hagep ñɨn u, God nɨbi bɨ gau kalɨp magöŋhalö, manö haƚöwaƚö hagöm nɨbi bɨ rɨmnap gɨ naij gɨla u, nɨhön gɨnɨg anɨg hagpe a göm, kalɨp hag gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anɨb u me, kale ke manö hagnabim u nöp God nɨŋöm hagnab nɨŋöm, kamɨŋ arnabim aka ilön udnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","God lo manö hag ñeb bɨ rɨmnap abe, bɨ Perisi rɨmnap abe, apöm Jisas nɨp hagla, “Manö hag ñeb bɨ! Nan gagep rö ap gö, hon nɨŋun me, ne God nöp hag yuöp auban a gɨnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hageila, Jisas haga, “Kale nɨbi bɨ nan si nan naij nöp gɨmim, God manö haga u nɨŋagpim. Nan gagep rö ap gö nɨŋun a gɨpim u, pen kalöp nan ap gɨnö nɨŋagnabim. Bɨ God manö hagep Jona nɨp ga adö u nöp yɨp u rö nöp gö, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hadame nöp kabsaƚ kub u Jona nɨp pa bo yuö, hibur aŋ yaŋ ñɨn mɨhau nɨgaŋ mɨdöm, ado gɨ aua. Anɨb u rö, yad, Bɨ Ñɨ nɨpe, u rö nöp ñɨn mɨhau nɨgaŋ mɨnöŋ aŋ gau mɨdem, ado gɨ aunabin. ");
INSERT INTO kpw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hadame nöp Jona amöm, daun kub Ninepa nɨbi bɨ kalɨp hagö, nan si nan naij gɨla gau yɨŋɨd arö göm, God nɨp nɨŋ udla. Jona bɨ yɨharɨŋ u hagö nɨŋla; kale pen Bɨ Kub yabɨƚ mɨñi mɨdöp i, manö hagöp u udagpim. Anɨb u, hainö manö kub hagep ñɨn u, Ninepa bɨ kale uraköm kalöp manö kub haglö, kale manö kub udnabim. ");
INSERT INTO kpw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Nɨbi kwin kub, ram mɨnöŋ Siba nɨbö u, hadame nöp ga rö u nɨŋbim. Ram mɨnöŋ nɨpe mɨlö gau nɨbö u pen, Juda kiŋ kub Solomon gasɨ kɨd hiɨk nɨŋeb bɨ u manö nɨp nɨŋnɨg aua. Solomon bɨ yɨharɨŋ u nɨp anɨg ga; pen nɨhön gɨnɨg Bɨ Kub mɨñi mɨdöp i manö hagöp u nɨŋagpimŋ Hainö manö kub hagep ñɨn u, Siba kwin uraköm kalöp manö kub hagö, kale manö kub udnabim. ");
INSERT INTO kpw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Seden yam nɨpe kɨjaki nan gau ap nɨbi bɨ abaŋ al mɨdöm, höŋ amöm, nɨbi bɨ rɨmnap abaŋ alɨn, a göm, nɨŋ aj wasö nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ado gɨ apöm nɨŋnab, bɨ nöd arɨk arnab kuö u aij aij nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɨpe nɨŋöm, kɨjaki naij nɨpe rö wasö, kɨjaki naij yabɨƚ, unbö mudun jɨŋ u uɫ gɨ dapöm, bɨ anɨbu nɨp yuö hiɨknaböl. Anɨg gö, nöd mɨd naij ga rö wasö; hainö mɨd naij yabɨƚ gɨnab. Kale nɨbi bɨ uri mɨdpim kale nan si nan naij nöd gɨ mɨdmɨdim rö wasö, hainö nan si nan naij yabɨƚ gɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas nɨbi bɨ gau kalɨp manö hagö nɨŋöl gɨ, nɨme nɨmam nɨpe yabɨƚ gau höŋ yaŋ apöm hagla, “Hon Jisas nɨp manö hagnɨg aubun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hageila, bɨ ap ram raul mɨgan amöm, Jisas nɨp haga, “Name namam ne gau, nöp manö hagnɨg ap mɨdpal höŋ yaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Hageia, nɨbi bɨ nɨpe aip ram raul mɨgan yaŋ mɨdeila gau kalɨp nɨŋ gɨgabö göm haga, “Nɨŋö hagpan u pen, nɨbi bɨ ram raul mɨgan mɨdpal gai i, kale ami yad, mam yad mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nɨbi bɨ Bapi yad kumi kabö adö laŋ manö hagöp rö nɨŋöm anɨg unbö rö nöp gɨpal gau, ami yad, añ yad, mam yad gau nöp mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ñɨn añɨ anɨbu nöp, Jisas ram arö göm am Ñɨg Waŋö Galili goƚ au asɨkö, ");
INSERT INTO kpw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","nɨbi bɨ iru yabɨƚ nöp apöm nɨp bɨg gɨgabö geila. Anɨg geila nɨŋöm nɨpe am ñɨg magɨb adö u asɨköm, amöm ñɨg aŋ au daŋ mɨdö nɨŋöl gɨ, nɨbi bɨ ñɨg waŋö goƚ au urak mɨdeila. Jisas nɨbi bɨ gau kalɨp manö hod rɨköm manö iru nöp hag ña. Hag ñöl gɨ haga, “Bɨ ap wid ranaŋ a göm, wid magö u dam wög naböŋ gau yueinab. ");
INSERT INTO kpw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yɨŋ yuö, rɨmnap adan adö au lugö, yaur gau apöm ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Rɨmnap kabö adö mɨnöŋ pro pro mɨdeinab au lugöm, yɨŋɨd marep gɨnab ");
INSERT INTO kpw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pen kɨdɨƚ am pɨdöŋ gagnab rö, sɨdö nɨŋöm mɨƚep gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pen rɨmnap nagɨ kalɨ kalɨ halö aŋ gau lugöm rannab pen nagɨ anɨbu hau göm pak ñɨŋö, mɨƚep gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pen rɨmnap mɨnöŋ aij adö au lugöm, ran aij yabɨƚ göm, magö iru yabɨƚ nöp pɨlnab. Rɨmnap ñɨn juöl mamɨd u (100) rö pɨlnab; rɨmnap ñɨn juöl mɨhau nɨgaŋ (60) rö pɨlnab; rɨmnap ñɨn juöl añɨ ap ado gɨ da unbö wajƚem laŋ (30) rö pɨlnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas anɨg hagö, bɨ nɨpe gau apöm, nɨp hag nɨŋöm hagla, “Nɨbi bɨ gau kalɨp nɨhön gɨnɨg manö hod rɨkmön nöp hagpan?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hageila haga, “God nɨbi bɨ nɨpe udöm abad mɨdeinab manö pi göl mɨdmɨdöp u, kalöp gasɨ ñö nɨŋnabim; pen nɨbi bɨ yɨharɨŋ gau nɨŋagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nɨbi bɨ manö yɨp nɨŋöm udpal gau, manö rɨmnap halö nɨŋöm, iƚ u nɨŋ aij gɨnaböl; pen nɨbi bɨ manö yɨp nɨŋöm udagpal gau, manö pro nɨŋbal u böŋ nöp ur gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kalɨp manö hod rɨkem hagpin u, kale amgö halö, gasɨ rɨmɨd halö u pen, hagöp me u a göm, nɨŋagpal. ");
INSERT INTO kpw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Gɨpal anɨbu, bɨ God manö hagep Aisaia nöd gɨnab a göm kalɨ kƚiñ rɨka rö nöp gɨpal. Manö anɨbu kalɨ kƚiñ rɨköm haga, ‘Manö nɨŋnaböl u pen manö hagöp anɨg a göm nɨŋagnaböl. Amgö nɨŋnaböl u pen nan ap nɨŋagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nɨbi bɨ gai i manö yad hagpin u kalɨp iru gö nɨŋagpal. God Manö nɨŋno, hanɨp gö, nɨbi bɨ nɨpe mɨdaiun rö löp a göm, rɨmɨd pɨƚ göm, amgö ju göm nöp mɨdpal,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Anɨb u, kale nɨŋagpal; pen God kalöp gasɨ aij ñö nɨŋbim u, mɨñ mɨñ gɨmim. Yad kalöp nɨŋö hagabin, God manö hagep bɨ gau abe, nɨbi bɨ God Manö hagöp rö nɨŋöm gɨmɨdal gau abe, iru nöp Mesaia nɨp nɨŋun a gɨmɨdal u pen yɨp amgö nɨŋagöm, manö yɨp nɨŋagla. Pen mɨñi kale yɨp amgö nɨŋmim, manö yɨp apdi nɨŋabim u, mɨñ mɨñ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pen manö hod rɨkem hagajɨn u, bɨ narö u nɨpe wid magö dam wög naböŋ gau yua u, iƚ u hagnö nɨŋim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Wid magö rɨmnap adan adö au lugö, yaur gau apöm ñɨŋnaböl a gɨpin u, nɨbi bɨ gau, God nɨbi bɨ udöm abad mɨdeinab manö aij u nɨŋnaböl u pen iƚ u nɨŋagnaböl nɨŋöm Seden nɨpe gö böŋ nöp hauƚ gɨnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Pen magö rɨmnap kabö adö mɨnöŋ pro pro mɨdeinab au lugöm, yɨŋɨd marep gɨnab pen kɨdɨƚ am pɨdöŋ gagnab rö, sɨdö nɨŋöm mɨƚep gɨnab a gɨpin u, nɨbi bɨ gau manö yɨp gɨsön nɨŋnaböl magö u, mɨñ mɨñ gɨnaböl, pen uri nöp nɨbi bɨ rɨmnap apöm, nɨbi bɨ manö yad nɨŋnaböl gau gasɨ naij nɨŋöm, kauaƚ mauaƚ rö mɨdöm, kalɨp gɨ naij gɨnaböl nɨŋöm nɨbi bɨ manö yad nöd udla gau, uri manö yɨp u hauƚ göm, gasɨ adö rɨmnap nɨŋnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Magö rɨmnap lugnab nagɨ kalɨ kalɨ halö aŋ gau a gɨpin u, nɨbi bɨ gau manö yɨp u nɨŋnaböl u pen wög waryö, ram, kaj, ru mɨŋoƚ, uɫpö kɨƚno kɨbap nan gau nöp gasɨ nɨŋöm, God manö aij u arö gɨnaböl nɨŋöm nan ñɨŋeb rɨmnap pɨlagnab, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pen magö rɨmnap mɨnöŋ aij adö au lugöm, ran aij göm, magö iru pɨlnab a gɨpin u, nɨbi bɨ gau manö yad u nɨŋöm, ud pɨdöŋ yabɨƚ löm, rɨmnap gɨ aij gɨnaböl, rɨmnap gɨ aij yabɨƚ gɨnaböl, rɨmnap gɨ aij adö ke yabɨƚ gɨnaböl, a gem hagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas kalɨp manö ap halö manö hod rɨköm haga, “God nɨbi bɨ udöm abad mɨdeinab u, aiud udabin i rö gɨnab. Bɨ kub ap wid magö gau ranaŋ a göm, dam wög naböŋ nɨpe gau yunab. ");
INSERT INTO kpw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pen sɨbön yaŋ han arnaböl magö u, bɨ naij ap nan yɨŋ naij rɨmnap dapöm, aŋ anɨb gau yuöm arnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Anɨb u, wid yɨŋ aij u rannab, pen nan yɨŋ naij u abe rannab. ");
INSERT INTO kpw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Anɨg gö, bɨ wög gɨ ñeb gau apöm bɨ kub u nɨp hagnaböl, ‘Bɨ kub! Nan yɨŋ aij gau nöp dam wög naböŋ u yuban pen nan yɨŋ naij gau gai nɨbö apöm halö ranab?’ ö gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nɨpe kalɨp pen hagnab, ‘Bɨ koƚmaƚ yad ap dap yuöp,’ a gɨnab. Pen kale hagnaböl, ‘Hon amun nan yɨŋ naij ranab anɨb gau ud ju yuun aka?’ gɨnaböl. Bɨ wög naböŋ nap nɨbö u pen hagöm hagnab, ");
INSERT INTO kpw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Wasö! Ñɨn i, nan yɨŋ naij anɨb gau ud juim a gɨnö, ammim nan yɨŋ aij rɨmnap halö ud jumim rö löp! ");
INSERT INTO kpw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Arö gɨpe mɨhöŋgöl rannɨm. Pen ranöm magö pɨlö, rɨkep ñɨn u bɨ nan rɨkep yad gau hagnabin, “Nan yɨŋ naij anɨb gau ud jumim, dam ugan ugan adɨk lɨbe, mab laulö in habɨk ñɨŋ arnɨm; pen wid magö gau nöp ud magum gɨmim, dam wid magö lep raul mɨgan yad u yumim,” a gɨnabin,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jisas kalɨp manö ap pen manö hod rɨköm haga, “Bɨ ap mab masded magö pro u dam wög naböŋ nɨpe u yueinab, ran kub göm, lö aij u lö, yaur gau apöm, lö ke ke ram gɨnaböl. Anɨb u rö me, God nɨbi bɨ udöm, ram mɨnöŋ aij nɨpe kumi kabö adö laŋ au abad mɨdeinab u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Manö ap pen hod rɨköm haga, “Nɨbi gau nan yɨs a gɨpal u, ud plaua rin kub yaŋ halö ud ado malo gɨlö, nan kub yabɨƚ ranöb. Anɨb u rö me, God nɨbi bɨ udöm, ram mɨnöŋ aij kumi kabö adö laŋ au abad mɨdeinab u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas nɨbi bɨ gau kalɨp manö rɨmnap hag ñɨnɨg göm waiö hagagmɨdöp; manö hod rɨköm nöp kalɨp hag ñɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ga anɨbu, bɨ God manö hagep ap nöd gɨnab a göm kalɨ kƚiñ rɨka rö nöp ga. Nɨpe manö anɨbu kalɨ kƚiñ rɨköm haga, “Ram mɨnöŋ hadame dagol gɨ la ñɨn u rɨköm, mɨd damöm mɨñi mɨdpun ñɨn i, manö nɨŋagla u, manö hod rɨkep manö u nöp kalɨp hag ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas anɨg hagöm, nɨbi bɨ gau kalɨp arö göm, ram raul mɨgan arö nɨŋöl gɨ, bɨ nɨpe unbö mɨgan laŋ u apöm, nɨp hagla, “Nan yɨŋ naij wög naböŋ aŋ gau ranöb a gɨmön, manö hod rɨkmön hagpan u, hanɨp hagö nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hageila, haga, “Bɨ nan yɨŋ aij yuöp a gɨpin u, yad Bɨ Ñɨ nɨpe. ");
INSERT INTO kpw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Wög naböŋ a gɨpin u, mɨnöŋ naböŋ iƚ i magöŋhalö. Nan yɨŋ aij a gɨpin u, nɨbi bɨ God udöm abad mɨdeinab gau. Bɨ nan yɨŋ naij dap yuö ranöb a gɨpin u, bɨ yɨp nɨŋö mulu lugöp Seden nɨp nöp hagpin. Nan yɨŋ naij ranöb a gɨpin u, Seden nɨbi bɨ nɨpe gau kalɨp hagpin. Pen wid magö aɫɨ gɨnab ñɨn a gɨpin u, ñɨn ram mɨnöŋ iƚ i ur gɨnab ñɨn anɨbu hagpin. Bɨ rɨk dauep a gɨpin u, ejol gau kalɨp hagpin. ");
INSERT INTO kpw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nan haƚöwaƚö ranöb gau ud juöm, dam mab inab yaŋ yunaböl a gɨpin u, ñɨn ram mɨnöŋ iƚ i ur gɨnab ñɨn anɨbu me u. ");
INSERT INTO kpw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bɨ Ñɨ nɨpe ejol nɨpe gau kalɨp hag yuö, apöm, nɨbi bɨ nan si naij gɨpal gau abe, nɨbi bɨ nɨbi bɨ rɨmnap kalɨp hagailö, kale nan si nan naij gɨpal gau abe, ejol kale apöm kalɨp udöm ");
INSERT INTO kpw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mab ke inab mɨgan yaŋ u yunaböl, ilön gö nɨŋöl gɨ, meg hau rɨbɨköm mɨɫöŋ gɨnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ñɨn anɨbu, nɨbi bɨ Bap kale udöm kumi kabö adö laŋ abad mɨdeinab gau, kale sɨdö mailö rö paköl gɨ mɨdeinaböl. Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Pen God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö mɨdöp. Bɨ ap amöm nɨŋnab, mani kes hadame nöp pi gɨla ap wög adɨŋ ap mɨdeinab. Nɨpe nɨŋöm, nan rɨmnap ud pa rɨbɨk aij göm, ram arnab. Amöm, ñɨñɨ yabɨƚ löm, nan nɨpe gau magöŋhalö sɨkim göm, mani udöm, mani anɨbu damöm, wög adɨŋ anɨbu rauöm, am mani kes anɨbu udnab. ");
INSERT INTO kpw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Pen God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö mɨdöp. Bɨ sɨkim gep gau kɨbap uƚhai nɨŋ ajöm, kɨbap aij aij yabɨƚ ap nɨŋöm, ram amöm, nan kale gau magöŋhalö sɨkim göm, mani udöm, am kɨbap anɨbu raunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö mɨdöp. Nɨbi bɨ rɨmnap uben damöm, ñɨg waŋö au yulö, kabsaƚ iru nöp apöm mɨgan anɨbu arbal. ");
INSERT INTO kpw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Anɨg gɨlö, uben ɫɨp gɨ dam goƚ gau amöm, kabsaƚ aij gau ƚɨhu kabsaƚ lep rin mɨgan u löm, kabsaƚ naij gau ud yubal. ");
INSERT INTO kpw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ram mɨnöŋ iƚ i ur gɨnab ñɨn u anɨb unbö rö gɨnab. God ejol nɨpe gau apöm, nɨbi bɨ God Manö hagöp rö gɨla gau ke löm, nɨbi bɨ God Manö hagöp rö gagla gau ke löm, ");
INSERT INTO kpw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","dam mab ke inab yaŋ u yunaböl. Yulö ilön gö, meg kale hau rɨb göm, mɨɫöŋ gɨ mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Anɨg hagöm haga, “Yad manö hagajɨn gau nɨŋbim?” ö ga. Hageia, bɨ nɨpe gau hagla, “Yau, nɨŋbun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hageila, haga, “Kale nöd God lo manö u nöp hag mɨdmɨdim u pen uri kale God nɨbi bɨ udöm abad mɨdeinab manö aij hagpin u nɨŋbim. Anɨg nɨŋöm kale uri nɨbi bɨ gau hag ñɨnabim u, kale God Manö aij nöd nɨbö u abe, God Manö aij hain nɨbö u abe hag ñɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Pen Jisas nɨpe manö hod rɨköm manö haga anɨbu hag pɨs göm, daun nɨpe ke Nasared amöm, Juda magum gep ram raul mɨgan u amöm, nɨbi bɨ gau kalɨp hag ñö, kale nɨŋöm aiö yabɨƚ gɨla. Kale pen hagla, ‘Bɨ anɨbi nɨpe aige göm gasɨ kɨd hiɨk nɨŋöm nan gagep unbö rö gab?’ ö gɨla. Hainö pen hagla, ");
INSERT INTO kpw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Bɨ anɨbi nɨme nap, nɨñɨn nɨmam nɨpe gau, hon aip mɨdpal u pen, nɨpe aige göm bɨ kub rö mɨdöm, manö ke hagöm, nan gagep rö gau gabŋ Nap nɨpe u bɨ kapeda; nɨme Maria; nɨmam nɨpe gau Jems u, Josep u, Saimon u, Judas u. Anɨb u, nɨpe aige göm apöm anɨg gab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Anɨg hagöm, kale Jisas nɨp naij nɨŋöm, manö nɨpe haga u, udagla. Pen Jisas kalɨp haga, “Bɨ God manö hagep gau ram mɨnöŋ mɨlö gau amöm haglö, nɨŋö hagpal a göm nɨŋnaböl; pen ram mɨnöŋ kale ke u haglö, piral hagpal rö löp a göm arö gɨpal u rö gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Manö haga u nɨŋagla u me, ram mɨnöŋ anɨbu nan gagep rö iru nöp gaga. ");
INSERT INTO kpw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pen gapman bɨ kub ram mɨnöŋ Galili abad mɨdmɨdöp Herod, Jisas nɨpe nɨhön nɨhön ga manö u nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","am bɨ nɨp wög gɨ ñeb rɨmnap kalɨp haga, “Bɨ Jisas nan gagep rö göp u, nɨpe bɨ ap ke wasö; nɨpe Jon bɨ ñɨg pak ñeb u nöp. Nɨp al pak lɨnö u pen kauyaŋ uraköm ap mɨdöp rö, nan gagep rö anɨb gau gab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Pen Jon nɨp nagɨ löm, al pak la manö iƚ u anɨg göl mɨdöp. Herod nɨpe nɨmam Pilip nɨbin nɨpe u Herodias ud arö, Jon Herod nɨp haga, “Ne unbö gɨpan, gɨ naij gɨpan. Bɨ ap nɨmam nɨpe kamɨŋ mɨdeinab nuwi nɨpe udagnab,” a ga. Jon anɨg hagö, nɨbi anɨbu Herodias nɨpe Herod nɨp manö haga nɨŋöm Herod Jon nɨp dam nagɨ löm, al pak lɨn a göm gasɨ nɨŋa u pen nɨbi bɨ gau, Jon nɨp bɨ God manö hagep hon a gɨla rö, pɨñɨŋ göm arö ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pen hainö Herod nɨme nɨp yag daua ñɨn u nöp, nɨbi bɨ iru nöp ap magum göm, nan magö lau ñɨŋnɨg gɨla. Ñɨn anɨbu, Herodias pai nɨpe u apöm aŋ anɨb au kugom ralö, Herod nɨŋö, aij yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Anɨg gö, nɨpe pai anɨbu nɨp manö hagöm haga, “Yad manö nɨŋö yabɨƚ hagem nöp hagabin, ne nan ap hag nɨŋeinabön, nöp haƚöwaƚö ud ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hageia, pai anɨbu, nɨme haga rö nɨŋöm haga, “Jon bɨ ñɨg pak ñeb nabɨc cög u, kɨnaŋ cög mɨgan yaŋ lɨmön, dap ñɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Anɨg hagö, Herod nɨŋö mög ga, pen nɨbi bɨ gau nɨŋ mɨdlö nɨŋöl gɨ, pai anɨbu nɨp waiö manö nɨŋö hag löm haga, “Ne nan ap hag nɨŋeinabön, nöp haƚöwaƚö ñɨnabin,” a ga rö nɨŋöm, bɨ rɨmnap hag yuö, am Jon nagɨ mɨdeia au amöm, nabɨc cög nɨp u rɨb gɨ dö göm, ");
INSERT INTO kpw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ud kɨnaŋ cög mɨgan yaŋ löm, dap pai anɨbu nɨp ñɨla. Ñeila, nɨpe pen damöm nɨme nɨp ña. ");
INSERT INTO kpw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pen Jon bɨ nɨpe gau apöm, wip dam rɨgöl göm, am Jisas nɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas manö anɨbu nɨŋöm, am ram mɨnöŋ ke mɨgan ap mɨdeinam, a göm, ñɨg magɨb udöm, ram mɨnöŋ anɨbu arö göm, hada. Pen nɨbi bɨ gau, Jisas arab au hain arun, a göm, ram mɨnöŋ kale gau arö göm, iƚ adö aramöm, Jisas arnɨg ga gau arla. ");
INSERT INTO kpw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas nɨpe pen ram mɨnöŋ mɨgan anɨbu apjaköm, ñɨg magɨb u arö göm, goƚ gau apöm nɨŋa, nɨbi bɨ iru nöp mɨdeila. Kalɨp nɨŋö, mög gö, nɨbi bɨ nan ga gau gö, kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pen dugo magö u, bɨ nɨpe gau Jisas mɨdeia au apöm, nɨp hagla, “Söl sɨb gɨnɨg gab. Mɨdö nöp nan magö ñɨŋeb magö u padiöp. Gai i ram mɨnöŋ nöp aŋ au. Nɨbi bɨ iru nöp gai i hagö, ram aŋ gai i amöm, nan magö kale rɨmnap rau ñɨŋlaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Anɨg hageila, Jisas kalɨp haga, “Wasö, kale aragnaböl. Kale ke kalɨp nan magö ñɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hageia, hagla, “Hon nan magö iru mɨdagöp. Yɨharɨŋ bred magö unbö mamɨd kabsaƚ mɨhöp mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hageila, Jisas haga, “Nan anɨb gau ud yɨp dauim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anɨg hagöm, nɨbi bɨ gau kalɨp hagö, nan uɫaŋ adö gau bɨs gɨlö nɨŋöl gɨ, bred kabö u udöm, kabsaƚ mɨhau u udöm, gɨlaŋ gɨ nɨŋöm, God nɨp aij a göm, bred u ud jö göm, bɨ nɨpe gau kalɨp ñö nɨŋöl gɨ, kale udöl gɨ, nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. Kabsaƚ u u rö nöp gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Anɨg göl nɨme lɨ ñeila, ñɨŋlö, ñɨŋlö, mudun gö, ñɨŋ haköl rö laga. Naböŋ naböŋ arö gɨla gau me, Jisas bɨ nɨpe gau wadɨ unbö mɨgan laŋ u ud yaglö, böŋ nöp ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nɨbi bɨ nan ñɨŋla anɨb gau, nɨbi gau wasö, ñɨ pai pro gau wasö, bɨ gau nöp me paip dausan rö ara. ");
INSERT INTO kpw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas, bɨ nɨpe gau kale ñɨg böŋ lödaŋ arlaŋ a göm hagö, ñɨg magɨb udöm arla nɨŋöm nɨpe nɨbi bɨ gau kalɨp hag yuöm, ");
INSERT INTO kpw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","nɨpe ke God nɨp sabe gɨnɨg ram mɨnöŋ dum ap ara. Mɨdö, ram dugnɨg geia pen nɨpe añɨ nöp halö dum anɨb laŋ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pen bɨ nɨpe gau ñɨg magɨb udöm ñɨg waŋö aŋ kub au arlö nɨŋöl gɨ, pɨnöm asad kub yabɨƚ u apöm, ñɨg magɨb u ud ado gɨnɨg rö ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Magö anɨbu ram gɨsön nöp runɨg geia u me, Jisas ñɨg uɫ adö u abö gɨ apöm, bɨ nɨpe gau mɨdeila söl au aueia, ");
INSERT INTO kpw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kale nɨŋöm, “U wip ana ap auab!” a göm, anɨnɨn gö pɨñɨŋ göm, aiö kub bƚaƚö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas pen kalɨp haga, “Pɨñɨŋ gagmim! Yad nöp auabin!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hageia, Pida haga, “Bɨ Kub! Ne nöp auaimön u, yɨp abe hagö, ñɨg uɫ adö au abö gɨ yagol au nɨn,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Hageia, Jisas haga, “Anɨb u, au!” a ga. Hagö, Pida ñɨg magɨb u arö göm, ñɨg uɫ adö u abö gɨ am Jisas mɨdeia au am am aŋ au amöm nɨŋa, yɨgön kub yabɨƚ u apöm, ñɨg u ral auajɨp. Anɨg geia nɨpe pɨñɨŋ göm, ñɨg yaŋ had lugöl gɨ, wɨñ kub alöm haga, “Bɨ Kub! Ne yɨp yɨŋɨd ud yu!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Anɨg hagö, Jisas yɨŋɨd nɨp ud sɨsɨ udöm haga, “Nɨŋ udep magö ne u uƚep yabɨƚ göp. Nɨhön gɨnɨg gasɨ mɨhöp nɨŋajan?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anɨg hagöm, Jisas aip Pida aip ñɨg magɨb mɨgan u arlö nɨŋöl gɨ, pɨnöm asad kub udeia u ur ga. ");
INSERT INTO kpw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anɨg gö nɨŋöm, bɨ nɨpe ñɨg magɨb mɨgan yaŋ asɨk mɨdeila gau, Jisas hib nɨpe haglö adö arö nɨŋöl gɨ hagla, “Nɨŋö! Ne God Ñɨ nɨpe yabɨƚ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pen kale ñɨg waŋö juöm, ram mɨnöŋ Genesared böŋ lödaŋ amjakla. ");
INSERT INTO kpw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amjaklö, nɨbi bɨ mɨdmɨdal gau Jisas nɨp nɨŋöm, Jisas nöp auöp a göm, nɨbi bɨ ram mɨnöŋ söl anɨb gau magöŋhalö wɨñ allö, nɨbi bɨ nan ga gau magöŋhalö daula. ");
INSERT INTO kpw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dapöm, Jisas nɨp neb neb göl gɨ hagla, “Hanɨp yau a gö, nɨbi bɨ nan göp gai i, waƚɨj nöp goƚ au nöp ud nɨŋlö, kamɨŋ laŋ,” a gɨla. Hageila nɨpe yau a gö, nɨbi bɨ waƚɨj nɨpe ud nɨŋla gau kalɨp magöŋhalö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pen ñɨn anɨbu, bɨ Perisi rɨmnap, bɨ lo manö hag ñeb bɨ rɨmnap, Jerusalem nɨbö apöm Jisas nɨp hagla, ");
INSERT INTO kpw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bɨ ne gai i, nɨhön gɨnɨg apɨs bac bɨ manö pör u arö göm, ñɨmagö kale ñɨg lɨ yuöm wasö, yɨharɨŋ nöp nan ñɨŋbal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hageila, Jisas pen haga, “Kale nɨhön gɨnɨg God Manö nɨpe u arö gɨmim, bac bɨ gɨla rö nöp gabim? ");
INSERT INTO kpw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God haga, ‘Name nap kalɨp gɨ aij gɨmim ud aij gɨmim,’ a ga. God manö ap hagöm haga, ‘Bɨ ap nɨme nap kalɨp manö naij rɨmnap hagnab u, kale bɨ anɨbu nɨp al pak löl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","7","Pen kale manö anɨbu kabö göl hag ñagpim. Bɨ ap, ami bapi arö gɨnabin a gɨnab u, kalɨp hagnab, ‘Ami bapi, yad nan aij rɨmnap kalpe mɨhöŋ ñɨbnep pen mani kalpe mɨhöŋ ñeb mani u, uri yad God nɨp ñɨnabin a gɨpin, nɨŋöm mani kalpe mɨhöŋ ñeb ap mɨdagöp,’ a gɨnab. Anɨg gɨlö, kale nɨŋmim hagpim, ‘Kale anɨg gɨpal u, manö mɨdagöp,’ a gɨpim. Anɨg hagpim u, ‘God Manö hagabun,’ a gɨpim u pen kale piral yabɨƚ hagmim, kale ke hagpim rö gagpim. Kale manö anɨbu rö nɨbi bɨ gau kalɨp hag ñɨbim u, God manö hagep bɨ ne Aisaia nɨpe bɨ kalöp rö nöp gasɨ nɨŋöm, manö nɨŋö yabɨƚ ap kalɨ kƚiñ rɨka. Manö anɨbu kalɨ kƚiñ rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Nɨbi bɨ gai i manö pir alöm hagpal, “God Bɨ Kub hon,” a gɨpal u pen yɨharɨŋ manö nöp hagpal; yɨp mɨdmagö lagpal. Yɨp sabe göm, yɨharɨŋ manö nöp hagpal. God Manö nɨbi bɨ gau kalɨp hag ñabun a gɨpal u pen bɨ ram mɨnöŋ iƚ i nɨbö manö kale ke hagmɨdal manö u nöp ud hag ñɨ ajaböl!’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas anɨg hagöm, nɨbi bɨ mɨdeila gau wɨñ alö aueila haga, “Manö hagabin i, nɨŋ aij gɨmim! ");
INSERT INTO kpw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nɨbi bɨ gau nan magö gau haƚöwaƚö ñɨŋlö, hibur aŋ kalɨp yaŋ amöm prɨ gagöp; hibur aŋ kale yaŋ gasɨ naij nɨŋöm hagpal u me, prɨ gac halö mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pen Jisas bɨ nɨpe gau apöm Jisas nɨp hagla, “Bɨ Perisi gau manö hagpan u nɨŋlö, nöp mulu lugöp u, ne nɨŋban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hageila, Jisas haga, “U manö mɨdagöp. Bap yad kumi kabö adö laŋ mɨdöp u, nan yɨŋ nɨpe yɨmagöp gau magöŋhalö iƚ halö bɨg ju ud yunab. ");
INSERT INTO kpw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bɨ anɨb gau kale amgö we. Bɨ amgö we ap, bɨ amgö we ap nɨp uɫ gɨ damöm, mɨhöŋgöl uƚöm mɨgan u ap lug paknabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jisas anɨg hageia, Pida haga, “Manö anɨbu manö hod rɨk hagpan iƚ u hanɨp hag ñö nɨŋun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Hageia, haga, “Kale nɨŋagpal rö, kale u rö nöp nɨŋagpim arŋ Nɨŋim! Nan nɨhön nɨhön haƚöwaƚö ñɨŋbal gau, God nɨŋö, manö mɨdagöp. U yɨharɨŋ ñɨŋöm, hib halö kɨl yubal. ");
INSERT INTO kpw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hibur aŋ kale yaŋ gasɨ naij nɨŋbal u me, prɨ halö mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gasɨ kale ke nɨŋöm, gasɨ naij nɨŋöm, nɨbi bɨ al pak löm, nɨbi si bɨ si göm, nan gau si udöm, manö kub hagnaböl ñɨn u manö piral hagöm, nɨbi bɨ rɨmnap kalɨp hag juöm, gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gɨpal anɨbu me, God nɨŋö gac halö mɨdpal; pen nan ñɨŋnɨg, ñɨmagö ñɨg lɨ yuagöm haƚöwaƚö ñɨŋbal u, God nɨŋö gac gagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas ram mɨnöŋ Genesared anɨbu arö göm, ram mɨnöŋ kub, daun kub mɨhöp Daia Saidon aŋ gau ara. ");
INSERT INTO kpw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amöm anɨb gau ram mɨnöŋ Kenan gau mɨdö, nɨbi ram mɨnöŋ anɨb gau nɨbö ap, Jisas nɨp apöm haga, “Bɨ Kub, Depid Ñɨ nɨpe, yɨp mög nɨŋmön! Pai yad u kɨjaki abaŋ alö, mɨd aij gagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hageia, Jisas pen hagaga. Pen bɨ nɨpe gau apöm, Jisas nɨp hagla, “Nɨbi i hanɨp hain göl gɨ, manö hauƚ nöp gab. Nɨp hag yu gau araŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hageila, Jisas haga, “God yɨp yuö aunö u, Juda nɨbi bɨ God nɨp arö gɨpal gau, kalɨp nöp udnam, a gem, aunö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Anɨg hageia, nɨbi Juda wasö anɨbu apöm, Jisas mɨdeia iƚ au kugom yɨmöm haga, “Bɨ Kub, yɨp gɨ ñɨmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hageia, Jisas haga, “Nan magö ñɨ pai hon ñeb u, nɨhön gɨnɨg ud kain gau mukun?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hageia, nɨbi anɨbu pen haga, “Bɨ Kub, nɨŋö hagpan u pen, bɨ kub gau nan ñɨŋlö, naböŋ naböŋ gau abañ mo gau lugö, kain gau halö ñɨŋnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hageia, Jisas haga, “Nɨbi me, yɨp nɨŋ ud pɨdöŋ gɨpan u me, nan hag nɨŋban u gɨnabin,” a ga. Anɨg hagö nɨŋöl gɨ, kɨjaki u magö anɨbu nöp pai nɨpe u nɨp arö göm höŋ arö, nɨp kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ado gɨ Ñɨg Waŋö Galili goƚ böŋ lödaŋ amöm, sɨr u gɨlaŋ göm, am dum laŋ asɨka. ");
INSERT INTO kpw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Asɨk mɨdö nɨŋöl gɨ, nɨbi bɨ iru nöp, nɨbi bɨ ma naij ga gau, amgö we ga gau, ñɨmagö ma gɨ ga be wa be ga gau, aɫab ado gö manö hagagla gau, nan nɨhön nɨhön ga gau magöŋhalö dapöm, Jisas mɨdeia ma iƚ au lɨlö nɨŋöl gɨ, kalɨp gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Anɨg gö, nɨbi bɨ anɨb gau nɨŋöm, aiö göm hagla, “Hon Isrel nɨbi bɨ God hon u aij yabɨƚ. Nɨbi bɨ aɫab ado ga gau gö, manö hagaböl; nɨbi bɨ ñɨn ma gɨ ga be wa be ga gau gö, kamɨŋ löp; nɨbi bɨ ma naij ga gau gö, aj aij gaböl; nɨbi bɨ amgö we ga gau gö, amgö ñɨl nɨŋaböl,” a göm, hib nɨpe haglö adö ara. ");
INSERT INTO kpw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas bɨ nɨpe unbö mɨgan laŋ kalɨp wɨñ al hagö, aueila, haga, “Nɨbi bɨ gai i kalɨp mög nɨŋabin. Ñɨn mɨhau nɨgaŋ yad aip mɨdajal pen kale nan magö mɨdagöp. Kalɨp yɨharɨŋ hag yunö, amöm adan aŋ au amgö mɨmainö auö, ap lug paköl rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hageia, bɨ nɨpe gau hagla, “Ram mɨnöŋ nɨbi bɨ iru mɨdagpal aŋ anɨb gai i, nan magö gai nɨbö uƚhai nɨŋun dapun, nɨbi bɨ iru nöp anɨb gai i ñɨno ñɨŋnaböl?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hageila, Jisas haga, “Bred magö kale aigöl gɨ rö mɨdöp?” ö ga. Hageia, hagla, “Bred unbö mudun jɨŋ kabsaƚ pro rɨmnap halö mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hageila, Jisas nɨbi bɨ gau kalɨp hagö, mɨnöŋ adö anɨb au asɨkla. ");
INSERT INTO kpw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kale anɨg göm asɨklö nɨŋöl gɨ, nɨpe bred magö unbö mudun jɨŋ u udöm, kabsaƚ pro gau abe udöm, God nɨp aij a göm, ud jö göm, bɨ nɨpe gau kalɨp ñö, kale pen udöm, nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Anɨg göl nɨme lɨ ñeila, ñɨŋlö, ñɨŋlö, mudun gö, ñɨŋ haköl rö laga. Naböŋ naböŋ arö gɨla gau me, Jisas bɨ nɨpe gau wadɨ unbö mudun jɨŋ ud yaglö, böŋ nöp ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nɨbi bɨ nan ñɨŋla anɨb gau, nɨbi gau wasö, ñɨ pai pro gau wasö, bɨ gau nöp me, po dausan rö ara. ");
INSERT INTO kpw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pen anɨg nan ñɨŋöm, Jisas nɨbi bɨ anɨb gau kalɨp hag yuöm, nɨpe ñɨg magɨb udöm, ram mɨnöŋ Magadan böŋ lamɨŋ amöm, ram mɨnöŋ aŋ anɨb gau ara. ");
INSERT INTO kpw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɨ Perisi rɨmnap, bɨ Sadyusi rɨmnap, Jisas nɨhön gainɨm nɨp hag juun a göm, apöm nɨp hagla, “Ne Mesaia u mɨdpin a gɨpan u, nan gagep rö ap kumi kabö adö laŋ nɨbö gaimön, nɨŋö hagpan a gun, nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hag nɨŋeila, Jisas haga, “Sɨdö wad amöm, kumi kabö hagape hagape gö nɨŋöl gɨ hagnabim, ‘Ram rɨk aij gɨnab,’ a gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sɨb halö sɨdö lɨm gɨnɨg göm hagape hagape göm kumi wam ñö nɨŋöl gɨ, hagnabim, ‘Möŋ alnɨg gab,’ a gɨnabim. Anɨg gɨmim nɨŋ aij gɨpim u, pen yad uri nan nɨhön nɨhön gabin i, kale nɨŋabim pen iƚ u nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kale nɨbi bɨ mɨñi mɨdpim gau, mɨd aij gagmim, God nɨp gasɨ u nɨŋagpim. Nan gagep rö ap gö nɨŋun, a gɨpim u, yad gɨnö nɨŋagnabim. Bɨ Jona nɨp ga rö, adö u yɨp gö, nɨŋnabim,” a ga. Jisas anɨg hagöm, kalɨp arö göm mɨgan ap ara. ");
INSERT INTO kpw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas abe, bɨ nɨpe gau abe ñɨg magɨb udöm, ñɨg waŋö böŋ lödaŋ amöm nɨŋla, bred gau hauƚ göm dauagla. ");
INSERT INTO kpw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Anɨg nɨŋöm Jisas bɨ nɨpe gau kalɨp haga, “Bɨ Perisi, bɨ Sadyusi, yɨs kale u, nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jisas anɨg haga nɨŋöm, bɨ nɨpe gau, ke hag nɨŋ hag nɨŋ göm hagla, “Hon bred dauagpun u me, anɨg hagab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Pen Jisas kale hageila anɨbu ke nɨŋöm haga, “Kale nɨhön gɨnɨg bred dauagpun, a gɨmim, hag amɨl apɨl gabimŋ Kale yɨp nɨŋ ud aij gagpim. Bɨ paip dausan rö mɨdeila ñɨn u, bred magö unbö mamɨd u udem, ud jö gɨ ñainö, ñɨŋöm naböŋ naböŋ pɨl pali geila, wadɨ aigegö rö yagpe ajmaŋ raua? ");
INSERT INTO kpw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Pen ñɨn hain u, bred magö unbö mudun jɨŋ udem, bɨ po dausan rö mɨdeila u ñainö, ñɨŋöm naböŋ naböŋ pɨl pali geila, wadɨ aigegö rö yagpe ajmaŋ raua? ");
INSERT INTO kpw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ñɨn anɨbu kale ke mɨdmim, bred wadɨ yagpe u pen mɨñi manö hod rɨk hagajɨn u nɨŋagmim, ‘Bred nan a gɨ hagab,’ a gɨpim. Bred nan a gɨ hagagabin. Bɨ Perisi gau abe, bɨ Sadyusi gau abe, yɨs kale u kalöp udnɨm rö löp u, a gem, hagabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Anɨg hagö, kale nɨŋla nan yɨs bred halö lɨbal u hagaga; bɨ Perisi gau abe, bɨ Sadyusi gau abe, manö hag ñɨbal u nɨŋagmim, a göm, manö hod rɨköm haga. ");
INSERT INTO kpw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hainö Jisas daun kub Sisaria Pilipai aŋ au amjaköm, bɨ nɨpe gau kalɨp hag nɨŋöm haga, “Nɨbi bɨ gau Bɨ Ñɨ nɨpe bɨ an a gɨpal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hageia, bɨ nɨpe gau hagla, “Rɨmnap Jon bɨ ñɨg pak ñeb u, a gɨpal; rɨmnap, Ilaija, a gɨpal; rɨmnap, Jeremaia, a gɨpal; rɨmnap pen bɨ God manö hagep ap, a gɨpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hageila, Jisas kalɨp haga, “Kale ke pen, yɨp an a gɨmim nɨŋbim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hageia, bɨ nɨpe Saimon Pida haga, “Ne Mesaia u, God kamɨŋ u Ñɨ nɨpe yabɨƚ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hageia, Jisas haga, “Jona ñɨ nɨpe Saimon. Manö hagpan anɨbu, aij hagpan. Ne gasɨ kabö rö nɨŋban anɨbu, ke gau nɨbö auagöp; Bap kumi kabö adö laŋ u nöp, nöp gasɨ anɨbu ñö, ne kabö rö nɨŋban. ");
INSERT INTO kpw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Yad nöp hagabin, ne Pida. Gasɨ kabö rö nɨŋban anɨbu, yad nɨbi bɨ yad gau gau uɫ gɨ dapem, cöc yad kabö anɨbu adö u lɨnabin. Umeb magö u cöc yad gö, lug paknɨm rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“God ram mɨnöŋ kumi kabö adö laŋ au, ki rib u nöp ñɨnabin. Ne mɨnöŋ naböŋ iƚ i mɨdmön, nagɨ adö mai nɨŋmön kabö rö gagöp, wasö geinabön u, God kumi kabö adö laŋ au, u rö nöp wasö gɨnab. Pen nagɨ adö mai nɨŋmön kabö rö mɨdöp, yau a geinabön u, God kumi kabö adö laŋ au, u rö nöp yau a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jisas anɨg hagöm, bɨ nɨpe gau kalɨp haga, “Nɨbi bɨ gau kalɨp, yad Mesaia me anɨbu, a gɨmim, hagagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ñɨn aŋ anɨb u, Jisas bɨ nɨpe gau kalɨp, bɨ gau yɨp anɨg anɨg gɨnaböl, a göm, waiö hagöm haga, “Yad hainö Jerusalem arnö, bɨ manö ud asɨkep gau löm, bɨ God nɨp nan sabe gep bɨ kub gau löm, bɨ God lo manö hag ñeb bɨ gau löm, yɨp ilön ñöm al pak lɨnaböl. Pen ñɨn mɨhöp mɨdem, ñɨn mɨhöp nɨgaŋ u kauyaŋ uraknabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Anɨg hageia, Pida, Jisas nɨp dam goƚ au amöm, manö kƚö rö hagöm haga, “Bɨ Kub! Nöp anɨg gagnɨm! Manö anɨbu hag aij gagpan. God nöp abad mɨdö, anɨg gagnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hageia, Jisas ado göm, Pida nɨp haga, “Seden, yɨp arö gɨmön aru! Yɨp nɨhön gɨnɨg wasö gɨmön hagabön? God gasɨ nɨŋöb rö nɨŋagpan; nɨbi bɨ gasɨ nɨŋbal rö nöp nɨŋmön hagabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisas anɨg hagöm, bɨ nɨpe gau kalɨp haga, “Nɨbi bɨ an an yɨp lau adö mɨdun a gaiöl u, nan mɨnöŋ naböŋ iƚ i gasɨ kub nɨŋbal u arö göm, hañ romaŋ kale ke gasɨ kub nɨŋbal u arö göm, mab kros ud kag göm yɨp hain göl. ");
INSERT INTO kpw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nɨbi bɨ an, yad Jisas nɨp udnö aij gagnab, a göm, nɨŋnab u, kamɨŋ mɨdagnab; pen nɨbi bɨ an, yad Jisas nɨp nɨŋ ud mɨdainö yɨp nɨhön gaiöl u, manö mɨdagöp a gɨnab u, pör nöp kamɨŋ nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Nɨbi bɨ an nan mɨnöŋ naböŋ adö iƚ i udnam, a göm, gö arnab u, gasɨ kub nɨpe u adö anɨbu nöp areinab me, kamɨŋ pör mɨdep u udagnab. Aka God nɨp nan anɨb gau rauöm, kamɨŋ pör mɨdep u udnabŋ Wasö yabɨƚ! ");
INSERT INTO kpw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Hainö yad Bɨ Ñɨ nɨpe, Bapi mailö pɨdöŋ udem, ejol gau aip ado gɨ aunabin ñɨn u, manö kub u nɨŋem, nɨbi bɨ gɨ aij gɨpal gau ke lem, nɨbi bɨ gɨ naij gɨpal gau ke lem, pen ñɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Yad kalöp nɨŋö yabɨƚ hagabin, kale nɨbi bɨ mɨdpim gai i, rɨmnap kamɨŋ mɨdeinabim me, Bɨ Ñɨ nɨpe nɨbi bɨ udöm, kumi kabö adö laŋ au abad mɨdeinab ñɨn u, Bɨ Ñɨ nɨpe auö nɨŋöl gɨ, nɨp nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisas manö anɨbu hagöm, ñɨn unbö kagoƚ jɨŋ u mɨdöm, Pida, Jems, Jems nɨmam Jon kalɨp yam uɫ gɨ, dum i gɨlaŋ ap amöm, ke mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Anɨg göm mɨdlö nɨŋöl gɨ, Jisas hañ romaŋ nɨpe u ke yabɨƚ löm, mulu adɨŋ u sɨdö rö nɨŋöm, waƚɨj nɨpe u mɨmailö yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Anɨg gö nɨŋöl gɨ, kale nɨŋla, bɨ God manö hagep nöd umlö, Mosɨs aip Ilaija aip, apil Jisas aip manö hag mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kale nɨŋöm, Pida Jisas nɨp haga, “Bɨ Kub. Hon aui mɨdpun u, aij yabɨƚ mɨdpun. Ne yau a gɨmön, ram bada mɨhau nɨgaŋ gun, nöp ap, Mosɨs nɨp ap, Ilaija nɨp ap,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pida anɨg hagö nɨŋöl gɨ, kumi rud yabɨƚ ap apöm, kalɨp magöŋhalö paƚu gɨ yuö yua. Paƚu gɨ yuö yuö nɨŋöl gɨ, manö ap kumi aŋ anɨbu nɨbö haga, “Ñɨ mɨdmagö yad i, yɨp aij yabɨƚ göp. Manö nɨhön nɨhön hagnɨm u, nɨŋ udmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Manö anɨbu anɨg göl auö nɨŋöm, Jisas bɨ nɨpe gau gasɨ iru nɨŋöm, pɨñɨŋ göm, am mɨnöŋ iƚ au paköm, mulu adɨŋ kale u mɨnöŋ yaŋ lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas apöm, kalɨp ud nɨŋöm haga, “Pɨñɨŋ gagmim. Urakim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hagö, uraköm nɨŋla, Jisas nɨpe nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pen sɨr u gɨyaŋ göl gɨ, Jisas kalɨp haga, “Mɨñi nɨhön nɨhön gajɨp nɨŋbim anɨbu, nɨbi bɨ gau kalɨp hag ñagmim. Hainö Bɨ Ñɨ nɨpe umöm uraknab ñɨn u me, nɨbi bɨ gau kalɨp hag ñɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hageia, nɨp hagla, “Lo manö hag ñeb bɨ gau nɨhön gɨnɨg hagpal, ‘Ilaija nöd aueinab; hainö Mesaia mɨnöŋ naböŋ iƚ i aunab,’ a gɨpal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hageila, haga, “Nɨŋö hagpal. Manö anɨbu mɨdöp: ‘Ilaija nöd apöm, kalɨp hag aij gö, hainö Mesaia u aunab.’ ");
INSERT INTO kpw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pen nɨŋim. Ilaija aua u pen auö nɨp nɨŋagla. Gasɨ kale ke nɨŋla rö, nɨp gɨ naij gɨla. Bɨ Ñɨ nɨpe u nɨp u rö nöp gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas anɨg hagö, bɨ nɨpe gau nɨŋla, Jisas Ilaija hib haga u pen Jon bɨ ñɨg pak ñeb u nɨp nöp haga. ");
INSERT INTO kpw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pen kale ban yaŋ amjaköm nɨŋla, nɨbi bɨ iru nöp mɨdeila. Bɨ ap, nɨbi bɨ mɨdeila aŋ anɨb au apöm, Jisas mɨdeia au kugom yɨmöm haga, ");
INSERT INTO kpw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bɨ Kub. Ñɨ yad u mög nɨŋmön. Nɨp hauƚ alö, mɨd aij gagöp. Pör amöm, mab inöb aŋ gau abe, ñɨg aŋ gau abe gɨ dam pakab. ");
INSERT INTO kpw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɨp dam bɨ ne gau mɨdajal gau ud arnö, gɨ wasö nɨŋöm arö gɨpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hageia, Jisas haga, “Kale nɨbi bɨ mɨñi ñɨn i mɨdpim gau, God nɨp gasɨ nɨŋmim nɨŋ udagpim; God haga rö gagpim. Mañ mai kale nɨŋ udmim ke gɨnabimŋ Ñɨ anɨbu ud yɨp aui dauim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hagö, ñɨ anɨbu daueila, Jisas kɨjaki nɨp abaŋ ala u hag gö, höŋ arö, magö u nöp kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anɨg gö, Jisas bɨ nɨpe gau nɨpe mɨdeia au apöm, ke nöp mɨdöl gɨ, nɨp hag nɨŋöm hagla, “Nɨhön gö, kɨjaki abaŋ ala anɨbu, hag yu wasö nɨŋun arö gɨpun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Hageila, Jisas haga, “Nɨŋ udep magö kale u uƚep göp u me, hag yu wasö nɨŋmim arö gɨpim. Pen nɨŋim! Nɨŋ udep magö kale u mab masded yɨŋ magö pro mɨdöp rö u mɨdeinab u, nan nɨhön nɨhön hageinabim, hagnabim rö gɨnab. Nö ilö i, ‘Ke gɨdaŋ aru,’ a gɨnabim u, arnab. ");
INSERT INTO kpw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pen kɨjaki abaŋ alöp anɨbu, yɨharɨŋ hag yumim rö lagöp. Nan magö arö gɨmim, God nɨp sabe göl gɨ mɨdmim me, hag yunabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas bɨ nɨpe gau aip ram mɨnöŋ Galili apöm magum göm, kalɨp haga, “Söl mɨdöp, Bɨ Ñɨ nɨpe nɨp dam nɨbi bɨ rɨmnap kalɨp ñeinaböl, ");
INSERT INTO kpw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nɨp böŋ nöp al pak lɨlö umnab u pen ñɨn mɨhöp mɨdöm, ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. Jisas anɨg hagö, bɨ nɨpe gau nɨp mög nɨŋöm, gasɨ iru yabɨƚ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pen hainö, Jisas bɨ nɨpe gau aip daun pro Kapaneam amjaklö, bɨ God sabe gep ram dakɨs udep gau kale apöm Pida nɨp hagla, “Manö hag ñeb bɨ kale u dakɨs ñöb halö?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hageila, Pida haga, “Yau, nɨpe dakɨs ñöb halö,” a ga. Pen Pida anɨg hagöm, ram raul arö nɨŋöl gɨ, Jisas nɨpe nöd hagöm, Pida nɨp hag nɨŋöm haga, “Gasɨ ne nɨhön nɨŋban? Gapman bɨ kub gau, dakɨs mani gai nɨbö udpalŋ Nɨbi bɨ kale ke gau nɨbö udpal aka nɨbi bɨ mɨlö gau nɨbö udpal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hageia, Pida haga, “Nɨbi bɨ mɨlö gau nɨbö udpal,” a ga. Hageia, Jisas haga, “Nɨŋö, bɨ kale ke gau dakɨs ñagpal. ");
INSERT INTO kpw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pen hol ñagnabul u, kalɨp mulu lugnɨm rö löp. Anɨb u, ne ñɨg waŋö au ammön, nagɨ huk yumön, kabsaƚ nöd udnabön u, meg mɨgan ud lakmön nɨŋnabön, mani magö añɨ ap meg mɨgan u mɨdeinab. Ud dam dakɨs hol mɨhöŋ u ñɨmön,” a ga. Hageia me, am haga rö nöp ga. ");
INSERT INTO kpw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jisas bɨ nɨpe gau apöm, nɨp hag nɨŋla, “Nɨbi bɨ God udöm, kumi kabö adö laŋ au abad mɨdeinab gau, an nɨbi kub bɨ kub mɨdeinab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hageila, Jisas ñɨ pai pro ap wɨñ alö auö, ud amgö ilö adö kalɨp au urak ñöm, ");
INSERT INTO kpw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","haga, “Yad kalöp nɨŋö yabɨƚ hagabin, kale ñɨ pai pro gau gasɨ nɨŋbal rö nɨŋagnabim u, God ram mɨnöŋ kumi kabö adö laŋ au aragnabim. ");
INSERT INTO kpw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Anɨb u, nɨbi bɨ hon nɨbi bɨ kub mɨdagpun a göm, ñɨ pai pro i rö mɨdeinaböl u me, God nɨbi bɨ nɨpe ke udöm, abad mɨdeinab aŋ au, nɨbi bɨ kub rö mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pen nɨbi bɨ yɨp nɨŋ udöm, ñɨ pai pro i rö ud aij gɨnaböl u, kalɨp nöp wasö, yɨp abe ud aij gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pen nɨbi bɨ rɨmnap apöm, ñɨ pai yɨp gasɨ nɨŋ udpal gau, kalɨp nan si nan naij adö u gɨ yamlö, kale gasɨ yɨp u hauƚ göm, nan si nan naij gɨnaböl. Nɨbi bɨ anɨg gɨnɨg geinaböl u, nöd kabö kub ap uŋam u nagɨ ud lɨ rɨbɨköm, dam ñɨg solwara aŋ au yublap u aij. Kamɨŋ mɨdöm, anɨg gɨ naij yabɨƚ gɨnaböl u, ilön kub yabɨƚ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau marö yabɨƚ gɨnab. Nagɨ naij adö u göm, nɨbi bɨ rɨmnap kalɨp gasɨ ñɨlö, adö anɨbu göm ap lug paknaböl u, naij yabɨƚ gɨnab. Nagɨ adö anɨbu nöd gɨmɨdal, mɨñi gɨpal, hainö u rö nöp gɨnaböl. Anɨg gɨnab pen nɨbi bɨ adö anɨbu gɨ yamnaböl gau, ilön ke yabɨƚ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ñɨmagö ma kale u nɨŋmim, nan si nan naij gɨnɨg gainɨm, ñɨmagö ma u rɨb gɨ dö gɨ yumim. Anɨg gɨmim me, nan si nan naij gep adö u arö gɨmim, God ram mɨnöŋ au ammim, pör mɨdeinabim. Wasö u, ñɨmagö ma halö mɨdmim, pen mɨd aij gagmim, nan si nan naij gep adö u gɨ dammim, ram mɨnöŋ mab ke pör inmɨdöp u arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Pen amgö u nɨŋmim, nan si nan naij gɨnɨg gainɨm, amgö böŋ anɨb lau ud gulu gɨ yumim. Anɨg gɨmim me, nan si nan naij gep adö u arö gɨmim, God ram mɨnöŋ au ammim, pör mɨdeinabim. Wasö u, amgö mɨhöp halö mɨdmim, pen mɨd aij gagmim, nan si nan naij gep adö u gɨ dammim, ram mɨnöŋ mab ke pör inmɨdöp u arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kale nɨŋ aij gɨmim, ñɨ pai pro gau nan yɨharɨŋ, a gɨmim, gasɨ u nɨŋagmim. Yad kalöp hagabin, ñɨ pai pro gau ejol kale gau, Bapi yad amgö ilö adö nɨpe u ram mɨnöŋ kumi kabö adö laŋ au mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Bɨ Ñɨ nɨpe u, nɨbi bɨ ur gɨpal gau, kalɨp udnɨg aua. ");
INSERT INTO kpw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bɨ ap kaj sipsip nɨpe ñɨn juöl unbö mamɨd u rö mɨdeinab. Pen añɨ ap ur geinab u, nɨpe nɨhön gɨnabŋ Sipsip nɨpe rɨmnap kalɨp arö gö, nan uɫaŋ uɫaŋ ñɨŋlö nɨŋöl gɨ, sipsip nɨpe ur gɨnab u nɨp uƚhai nɨŋ arnab. Am uƚhai uƚhai udöm, mɨñ mɨñ yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kalöp nɨŋö hagabin, kaj sipsip nɨpe magöŋhalö mɨñ mɨñ göp, pen kaj sipsip nɨpe ap ur gö, uƚhai nɨŋ dam dam udnab u, sipsip anɨbu nöp mɨñ mɨñ yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anɨb u rö, Bapi kale kumi kabö adö laŋ mɨdöp u, ñɨ pai pro nɨpe ap ur gagnɨm, a göm, nɨŋ nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nɨbi bɨ añ mam, a gɨnabön gau, bɨ ap nöp gɨ naij gainɨm, ne pen ammön, nɨp aip ke mɨdmön, nöp nan nɨhön ga anɨbu waiö hagmön. Anɨg hagö, nɨŋ udö me, nañɨn namam ne yabɨƚ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pen ne anɨg gö, nɨpe nɨŋagnab u, ne ammön, añ mam mɨhöp rö uɫ gɨ dammön, kale nɨŋ mɨdlö nɨŋöl gɨ, ne bɨ anɨbu aip manö hagmil. ");
INSERT INTO kpw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pen ne anɨg gö, nɨpe manö udagainɨm u, nɨbi bɨ cöc aubal rö magöŋhalö nɨŋ mɨdlö nɨŋöl gɨ, manö anɨbu kalɨp hag ñɨmön. Pen ne anɨg gö, nɨŋ udageinab u, ne arö gɨmön. Anɨg ga nɨŋmön hagmön, ‘Bɨ anɨbu nɨbi bɨ God Manö nɨŋagöm, bɨ dakɨs udep rö u me, anɨg göp,’ a gɨmön, nɨp arö gɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Anɨb u, yad kalöp nɨŋö hagabin, mɨnöŋ naböŋ adö iƚ i wasö geinabim u, God nɨpe kumi kabö adö laŋ mɨdöm, u rö nöp wasö gɨnab; pen yau a geinabim u, nɨpe u rö nöp yau a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yad kalöp hagabin, nɨbi bɨ mɨhöp mɨnöŋ naböŋ iƚ i mɨdmil, manö hag adö añɨ lɨmil, Bapi yad kumi kabö adö laŋ mɨdöp u nɨp hag nɨŋeinabil u, hag nɨŋnabil rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pen nɨbi bɨ mɨhöp aka mɨhau nɨgaŋ rö, gasɨ yɨp nɨŋöm, ap magum geinaböl u, yad kalɨp aŋ anɨb au mɨdeinabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pida Jisas mɨdeia söl au apöm haga, “Bɨ Kub. Mam ap yɨp gɨ naij gainɨm u, ñɨn aigegö rö gɨ naij geinab, yad nɨŋem arö gɨnamŋ Ñɨn unbö mudun jɨŋ u rö aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hageia, Jisas haga, “Ñɨn unbö mudun jɨŋ wasö; ne bɨ anɨbu nöp gɨ naij gɨnab u nɨŋmön arö gɨnabön u, ñɨn juöl ñɨn juöl unbö mudun jɨŋ u nɨŋmön arö gɨnabön. ");
INSERT INTO kpw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","God nɨbi bɨ udöm ram mɨnöŋ kumi kabö adö laŋ au abad mɨdeinab u, aiud adö i rö mɨdöp. Kiŋ ap nɨpe bɨ wög gɨ ñeb nɨpe rɨmnap kalɨp mani rɨmnap ñöm, hainö pen ñim a gɨnab. Hainö nɨpe gasɨ nɨŋöm hagnab, ‘Kale naböŋ ñɨlaŋ,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pen mɨdöp u pen ñɨnaböl, a gö, bɨ ap nɨpe mani ilöŋ ñɨn juöl iru yabɨƚ nan naböŋ mɨdnab bɨ u daunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pen bɨ anɨbu pen nɨpe kub yabɨƚ mɨdnab u me, pen ñɨnɨm rö lagnab. Anɨg gö, bɨ kub u nɨŋöm, bɨ wög gep nɨpe rɨmnap kalɨp hagnab, ‘Nɨpe göp anɨbu rö, nɨp udmim, nɨbin ñɨ pai, nan nɨpe nɨhön nɨhön mɨdöp gau magöŋhalö udmim, dam sɨkim gɨpe, rauaiöl nɨŋöl gɨ, mani anɨbu dap yɨp ñɨmim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anɨg hagö, bɨ anɨbu pen, kugom yɨmöm, kiŋ u nɨp hagnab, ‘Ne yɨp mög nɨŋmön, abad mɨdaimön; nan adɨŋ ne anɨb gau magöŋhalö naböŋ ralnabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hagö, kiŋ u nɨp mög nɨŋöm, nan naböŋ nɨpe u, arö gɨmön aru, a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Anɨg göm arö gö nɨŋöl gɨ, bɨ wög gɨ ñeb anɨbu nɨpe pen amöm nɨŋnab, bɨ nɨpe aip wög gɨmɨdil bɨ ap mɨdeinab. Nɨp nɨŋöm, uŋam ud sɨsɨ löm hagnab, ‘Nöp mani ilöŋ añɨ ap ñɨnö u, naböŋ ral!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hagö, bɨ nɨpe aip wög gɨmɨdil anɨbu kugom yɨmöm manö neb neb gɨ hagöm hagnab, ‘Ne yɨp mög nɨŋmön, abad mɨdaimön; nan naböŋ ne anɨbu magöŋhalö naböŋ ralnabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hagö, bɨ anɨbu manö nɨp u nɨŋagöm hagnab, ‘Nöp dam nagɨ leinabin, nan naböŋ anɨbu naböŋ ralmön nöp me, höŋ arnabön,’ a göm, nɨp dam nagɨ lɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Anɨg gö, bɨ nɨpe aip wög gɨmɨdal gau, kalɨp hibur naij gö, amöm kiŋ u nɨp manö anɨbu magöŋhalö hag ñɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hag ñɨlö, bɨ kub u, bɨ nɨpe anɨbu nɨp wɨñ alö aueinab hagnab, ‘Ne wög gɨ ñeb bɨ naij yabɨƚ. Ne yɨp mɨɫöŋ gajan, nöp mög nɨŋem, nan naböŋ yad nöp mɨdöp u arö gɨpin. ");
INSERT INTO kpw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne pen nɨhön gɨnɨg, bɨ ne aip wög gɨpil u nɨp u rö nöp mög nɨŋmön, arö gagpan?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bɨ anɨbu bɨ nɨpe aip wög gɨmɨdil u nɨp mög nɨŋagnab u me, bɨ kub anɨbu kal juöm, wög gɨ ñeb bɨ anɨbu nɨp dam nagɨ lep ka abadep bɨ gau ñöm hagnab, ‘Nɨp nagɨ lö, ilön gö nɨŋöl gɨ mɨdöm, nan naböŋ yɨp u naböŋ magöŋhalö ralöm nöp höŋ arnab,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kale añ mam rɨmnap kalɨp u rö nöp geinabim, Bapi yad kumi kabö adö laŋ au mɨdöp u, kalöp pen u rö nöp gɨnab. Anɨb u, nañɨn namam kale gau kalöp gɨ naij geinaböl u, kalɨp mög nɨŋmim, mɨdmagö lɨmim, arö gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas manö anɨbu hag pɨs göm, ram mɨnöŋ Galili arö göm, ram mɨnöŋ Judia, ñɨg Jodan böŋ lödaŋ adö ara. ");
INSERT INTO kpw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Areia, nɨbi bɨ iru yabɨƚ nɨp hain geila nɨŋöm nɨbi bɨ nan ga gau gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pen bɨ Perisi gau, Jisas nɨp hag nɨŋno, manö naij rɨmnap hagnɨm, a göm, apöm hagla, “God Mosɨs nɨp hag ña lo manö u, nɨbi ap nan pro ap gɨ naij gɨnab u, bɨ nɨpe nɨp hag yunɨg, hag yunab aka wasöŋ Ne nɨhön gasɨ nɨŋban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hageila, Jisas haga, “God Manö kalɨ kƚiñ rɨkla u kale amgö lɨ nɨŋagpim arŋ Ram mɨnöŋ hadame dagol gɨ la ñɨn u, bɨ ap, nɨbi ap, gɨ la. ");
INSERT INTO kpw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God haga, ‘Adö anɨbu me, bɨ gau nɨme nap aip mɨdöm, nɨbi udöl gɨ, nɨme nap arö göm, kale ber mɨhau jɨm ñöl han mɨdlö hañ romaŋ añɨ yabɨƚ lɨnab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Anɨb u me, God hagö hañ romaŋ kale mɨhöp wasö; uri jɨm ñöl añɨ lɨnab anɨbu, bɨ ap apöm, kalɨp hag ud asɨk ke ke lagnab wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jisas anɨg hageia, bɨ Perisi gau nɨp hagla, “Pen nɨhön gɨnɨg Mosɨs manö ap kalɨ kƚiñ rɨköm haga, ‘Nɨbi hag yunɨg, nɨbi i böŋ nöp arö gabin, a gɨmim, köp ap kalɨ kƚiñ rɨk ñɨmim, hag yumim,’ a ga?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hageila, Jisas haga, “Kale nɨbi bɨ manö nɨŋ udagpim u me, Mosɨs anɨg haga. Pen God nɨbi bɨ hadame gau gɨ la ñɨn u, anɨg gagmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pen yad kalöp hagabin, bɨ an, nɨbin u bɨ ap aip ud gɨlö wasö, yɨharɨŋ nöp hag yuöm, nɨbi hain nɨbö udnab u, nɨbi si udnab nɨŋöm God nɨŋö naij yabɨƚ gɨnab; nɨpe nɨbi si udep bɨ me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas anɨg hagö, bɨ nɨpe gau hagla, “Bɨ gau nɨbi kale yɨharɨŋ hag yuagnaböl u, bɨ praj mɨdöm nɨbi udagöl u aij,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hageila, Jisas haga, “Bɨ magöŋhalö yɨharɨŋ mɨdaiöl rö lagöp. God bɨ yɨharɨŋ mɨdaiöl, a göm, hag la gau nöp, yɨharɨŋ mɨdaiöl rö löp. ");
INSERT INTO kpw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bɨ rɨmnap, kale waƚa lagö yag daubal gau, nɨbi udagpal. Bɨ rɨmnap, bɨ rɨmnap waƚa kalɨp rɨb gɨ dö gɨpal gau, nɨbi udagpal. Pen bɨ rɨmnap, God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab wög u gun, a göm, nɨbi udagpal. Kale bɨ praj mɨdun, a gɨmim, bɨ praj mɨdeinabim u aij,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɨbi bɨ gau, “Jisas ñɨmagö ñɨ pai hon nabɨc cög adö laŋ löm, God nɨp sabe gaŋ,” a göm daueila, pen bɨ nɨpe gau kalɨp nɨŋ ij halö löm hag gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Anɨg gɨlö, Jisas pen ñɨ pai anɨb gau wɨñ alö aueila nɨŋöl gɨ, bɨ nɨpe gau kalɨp haga, “Nɨhön gɨnɨg kalɨp anɨg hag gɨpimŋ Ñɨ pai pro anɨb gau arö gɨpe yɨp aulaŋ. God nɨbi bɨ udöm, kumi kabö adö laŋ au abad mɨdeinab u, ñɨ pai pro anɨb gau rö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anɨg hagöm, God ñɨ pai pro anɨb gau kalɨp pɨg mɨdeiaŋ, a göm, Jisas ñɨmagö ara nɨpe u ñɨ pai pro nabɨc cög adö laŋ löm, ram mɨnöŋ mɨgan ap ara. ");
INSERT INTO kpw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɨ ap Jisas mɨdeia au apöm haga, “Manö hag ñeb bɨ. Yad nan nɨhön aij u gem, pör mɨdep u udnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hageia, Jisas haga, “Yɨp nɨhön gɨnɨg, nan aij mai, a gɨmön, hag nɨŋabön? God añɨ me Bɨ aij. Pen pör pör mɨdeinam, a gɨmön u, lo manö hagöm kalɨ kƚiñ rɨkla gau nɨŋmön hagöp rö gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hageia, haga, “Lo adö mai rö hagabön?” ö ga. Hageia, Jisas haga, “Wip al pak gagmön; nɨbi si bɨ si gagmön; nan si udagmön; manö kub hagnaböl u, manö piral hagagmön; ");
INSERT INTO kpw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","name nap manö hagöl adö u nöp nɨŋmön hain gɨmön; ne ke mɨdmagö lɨban rö, nɨbi bɨ rɨmnap kalɨp mɨdmagö lɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Anɨg hageia, bɨ praj anɨbu haga, “Lo manö gau magöŋhalö nɨŋ hakpin. Pen yad nɨhön nan aij u gem, kamɨŋ pör mɨdep u udnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hageia, Jisas haga, “Mɨd aij yabɨƚ gɨnam, a gɨmön u, nan ne gau magöŋhalö yumön, mani udmön, nɨbi bɨ mög gep rö gau kalɨp ñɨmön me, mɨd aij gep ne u mɨdeinab God ram mɨnöŋ kumi kabö adö laŋ au. Pen yad hagpin rö gɨmön, aumön, yad aip ajaiul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hagö, bɨ praj anɨbu nan nɨpe iru mɨdeia rö, manö anɨbu nɨŋöm, gasɨ iru nɨŋöl gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pen nɨpe anɨg göl arö nɨŋöl gɨ, Jisas bɨ nɨpe gau kalɨp haga, “Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ mani nan kale iru mɨdeinab gau, God nɨp uɫham gasɨ nɨŋ udlö, kalɨp udöm kumi kabö adö laŋ au abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kaj kamel gau, kalɨ mauöƚ nagɨ yubal mɨgan u arnɨg arnaböl; pen nɨbi bɨ nan iru mɨdöp gau, God nɨp uɫham gasɨ nɨŋ udlö, kalɨp udöm abad mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisas bɨ nɨpe gau manö anɨbu nɨŋöm, gasɨ kub nɨŋöm hagla, “Pen bɨ aij anɨbu, God ud kumi kabö adö laŋ au ud aragnab, a gɨpan u, nɨbi bɨ an rö ud arnab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hageila, Jisas kalɨp nɨŋöl gɨ haga, “Nɨbi bɨ gau ke göl rö lagöp. God nöp me, nan nɨhön nɨhön gɨnɨg, gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas anɨg hageia, Pida haga, “Nöŋ! Hon nan hon gau magöŋhalö arö gun, ne aip nöp cɨg gun ajpun u, hon pen nan nɨhön udnabun?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hageia, Jisas haga, “Yad kalöp nɨŋö hagabin, ñɨn hain u yad mailö pɨdöŋ halö apem, nɨbi bɨ magöŋhalö abad mɨdeinabin. Ñɨn anɨbu me, kalöp bɨ yɨp hain geinabim gau hagnö, Isrel nɨbi bɨ iƚ ke ke unbö mɨgan laŋ gau, kalɨp abad mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɨbi bɨ yɨp nɨŋ udöm, ram, nɨñɨn nɨmam, nɨme nap, ñɨ pai, wög adɨŋ, nan nɨhön nɨhön gau arö gɨnaböl gau, God kalɨp hauƚ gagnab; nan anɨb gau rö kalɨp pen iru yabɨƚ ñöm, pör mɨdep kalɨp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pen nɨbi bɨ uri nöd araböl gau, hainö iru nöp jöl adö yabɨƚ gau mɨdeinaböl. Pen nɨbi bɨ uri jöl adö yabɨƚ au mɨdpal gau, hainö iru nöp nöd am mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas anɨg hagöm haga, “God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö mɨdöp. Bɨ wain wög nap nɨbö ap, bɨ rɨmnap am daunö, wög yɨp u gɨlaŋ, a göm, ram gɨsön rɨka magö u uraköm, am bɨ rɨmnap uƚhai nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","kalöp mani silpa magö añɨ añɨ raunabin, a göm, kalɨp aip manö hag adö añɨ löm, hag yuö, am wain wög nɨpe u wög geila. ");
INSERT INTO kpw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pen sɨdö yöp aŋ au ap ranab magö u, am maker au amöm nɨŋa, bɨ rɨmnap yɨharɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kalɨp nɨŋöm haga, ‘Kale u rö nöp am wög yad u geinabim, yad kalöp mani kabö rö raunabin,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hagö, am wög nɨpe u geila. Pen sɨdö aŋ kub laŋ magö u abe, sɨdö gamɨŋ gab magö u abe, manö anɨbu nöp hagöm, bɨ rɨmnap halö udö, wög nɨpe u geila. ");
INSERT INTO kpw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sɨdö wad arnɨg gab magö u, kuöyaŋ maker au amöm nɨŋa, bɨ rɨmnap halö ap mɨdep nöp mɨdeila. Kalɨp haga, ‘Kale nɨhön gɨnɨg ñɨn i wög gagmim, yɨharɨŋ yabɨƚ mɨdpim?’ ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hageia, nɨp hagla, ‘Bɨ ap hanɨp wög ap ñagöp,’ a gɨla. Hageila, kalɨp haga, ‘Kale u rö nöp am wain wög yad u gɨmim,’ a gö, am wög geila. ");
INSERT INTO kpw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Duga magö u, wain wög nap u, bɨ abad mɨdep nɨpe u nɨp haga, ‘Ne ammön, bɨ wög yɨp gaböl gau kalɨp hagö, aulö, bɨ hainö hagnö aubal gau, mani kalɨp u nöd ñɨmön; bɨ nöd hagnö aubal gau, mani kalɨp u hainö ñɨmön,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Hagö, bɨ abad mɨdep u, bɨ anɨb gau kalɨp wɨñ alö aueila, bɨ sɨdö wad arö nɨŋöl gɨ, ap wög gɨla gau, ap mani kale u nöd udla. ");
INSERT INTO kpw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pen kale anɨg göl udlö nɨŋöl gɨ, bɨ nöd hagö, ap wög gɨla gau, hag nɨŋla e, ‘Hon mani kub u udnabun,’ a gɨla u, pen hainö udöl gɨ nɨŋla, kale mani añɨ anɨbu nöp udla. ");
INSERT INTO kpw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Udöm, adɨŋ bɨ wain wög nap nɨbö u aip pen pen hagöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Hon nɨhön gɨnɨg, bɨ hain aubal gau mani udpal añɨ u rö nöp udpun? Hon hilɨm halö urakun, sɨdö kal nɨŋö nɨŋöl gɨ, wög gɨno gɨno iru göp u, pen bɨ ap pro magö ap wög gajal mani ñɨban rö nöp hanɨp ñɨban!’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hageila, bɨ wög naböŋ nap nɨbö u nɨŋöm, bɨ kale ap nɨp haga, ‘Mam, nöŋ! Nöp gɨ naij gagpin. Nöp mani ñɨnabin a gɨpin rö ñɨbin. ");
INSERT INTO kpw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Bɨ hain aubal gau, bɨ nöd aubal gau aip adɨp adɨp ñɨnɨg, ñɨnabin. U nan yad. Anɨb u, bɨ rɨmnap ai gɨnɨg göm wasö gɨnabölŋ Kalɨp haƚöwaƚö ñɨbin u, ne ai gɨnɨg gɨmön mulu lugöpŋ Mani ñɨbin u ud ram ne aru!’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas aiud anɨbu hagöm, haga, “Nɨbi bɨ hain mɨdpal gau, nöd mɨdeinaböl; nɨbi bɨ nöd mɨdpal gau, hain mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalem amöl gɨ, adan aŋ au, bɨ nɨpe unbö mɨgan laŋ kalɨp dam goƚ gau amöm, ke mɨdaila nɨŋöl gɨ kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kale nɨŋim! Hon Jerusalem arno, Bɨ Ñɨ nɨpe nɨp mumug göm, nɨp dam God nɨp nan sabe gep bɨ kub gau abe, lo manö hag ñeb bɨ gau abe, ñɨmagö adö kalɨp u leinaböl, kale nɨp manö kub hagöm hagnaböl, ‘Bɨ i nɨp al pak lep,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Anɨg hagöm, Juda bɨ wasö gau kalɨp ñeinaböl, nɨp hag juöm, rapɨn paköm, dam mab ba laŋ al pak lɨlö umnab. Ñɨn mɨhöp mɨdöm, ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi ñɨ nɨpe mɨhöp, nɨme ñɨ anɨb mɨhau uɫ gɨ, Jisas mɨdeia au apöm, ubör yɨhöŋ göm haga, “Yad manö ap mɨdajɨp auabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hageia haga, “Manö anɨbu nɨhön?” ö ga. Hageia, haga, “Yɨp aij gɨnab u, hainö ne kiŋ mɨdmön, nɨbi bɨ abad mɨdeinabön ñɨn u, ñɨ yad mɨhau ba nöp au asɨknabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Anɨg hageia, Jisas haga, “Manö yɨp hag nɨŋbil u, nɨŋ aij gagpil. Ñɨg asɨ yad ñɨŋnɨg gabin u, kale mɨhöŋ u rö nöp ñɨŋnabil?” ö ga. Hageia haglö, “Yau! Ñɨŋnabul!” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hagailö haga, “Nɨŋö hagabil. Ñɨg asɨ ñɨŋnɨg gabin u ñɨŋnabil. Pen bɨ an yɨjɨg böŋ lau, bɨ an sɨdagö böŋ lau asɨk mɨdeinabil u, hagagnabin. Manö u manö yad wasö; Bapi manö nɨpe. Nɨbi bɨ nɨpe ke hag löp gau anɨb rö mɨdeinabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bɨ nɨpe anɨb mɨhau manö anɨbu anɨg hagailö, bɨ nɨpe unbö sɨduŋ laŋ manö u nɨŋlö, mulu lugö, mamil mɨhau kalɨp manö hag gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas pen bɨ nɨpe gau kalɨp magöŋhalö hagö aueila haga, “Kale nɨŋbim, Juda nɨbi bɨ wasö gau, kiŋ kale kƚö göm, abad mɨdpal; bɨ kub kale manö nɨhön nɨhön hagnaböl u nɨŋöm, ana udöm, hain gɨnaböl me. ");
INSERT INTO kpw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pen kale gɨpal rö gagmim. Bɨ an bɨ kub mɨdainɨm u, bɨ pro rö mɨdöm, nɨbi bɨ rɨmnap kalɨp wög gɨ ñeb bɨ rö mɨdainɨm. ");
INSERT INTO kpw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bɨ an bɨ kub yabɨƚ mɨdainɨm u, bɨ pro ramö gau rö mɨdöm, nɨbi bɨ rɨmnap kalɨp nagɨ wög gep bɨ rö mɨdainɨm. ");
INSERT INTO kpw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bɨ Ñɨ nɨpe u, nɨbi bɨ gau kale wög yɨp gɨlaŋ a göm, auaga; wög kalɨp gɨ ñɨ damem, hainö nan si nan naij gɨpal adö u hajɨ gɨ umnö, kale kamɨŋ aröl, a göm, aua,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pen Jisas daun kub Jeriko arö göm arö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨp hain gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bɨ amgö we mɨhau adan goƚ au asɨk mɨdlö nɨŋöl gɨ, “Jisas auab,” a gɨlö nɨŋmil, meg mɨgan dap ranmil haglö, “Depid Ñɨ nɨpe, halɨp mög nɨŋmön!” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hagailö, nɨbi bɨ gau kalɨp mɨhöŋ nɨŋ ij halö hagöm hagla, “Manö hauƚ gagmil!” a gɨla. Anɨg hagla u pen, manö kalɨp u udagöm, meg magö rapɨn dap ranmil haglö, “Depid Ñɨ nɨpe, halɨp mög nɨŋmön!” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Anɨg hagailö, Jisas pɨdöŋ göm, kalɨp mɨhöŋ wɨñ alöm haga, “Halɨp nɨhön gaŋ, a gɨmil, yɨp wɨñ alabil?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hageia haglö, “Bɨ Kub, halɨp amgö we göp u gö ñɨl nɨŋul!” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hagailö, Jisas kalɨp mɨhöŋ mög nɨŋöm, amgö kalɨp u ud nɨŋö, yöp magö u nöp amgö ñɨl nɨŋlö, nɨpe arö nɨŋöl gɨ, hain gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas bɨ nɨpe gau aip Jerusalem sösöl göm, ram mɨnöŋ pro Bedpagi, Olip Dum söl amjakla. Amjaköm, bɨ nɨpe mɨhöp hag yuöm haga, ");
INSERT INTO kpw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Kale mɨhöŋ ram rɨƚɨg agƚö nö lödaŋ ammil nɨŋnabil, kaj donki nɨme pi amɨl mɨhau nagɨ adɨk lɨnaböl mɨdeinabil. Nɨŋmil, nagɨ u hubɨkmil paŋɨd daumil. ");
INSERT INTO kpw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pen nɨbi bɨ ap apöm, nɨhön gɨnɨg kaj donki hon u hubɨk ud arabil a gainɨm u, pen hagmil, ‘Bɨ Kub u wög mɨdö, hagajɨp udnɨg aubul,’ a gɨmil, yɨŋɨd yau a geinab, daunabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pen kalɨp mɨhöŋ hag yuö arlö anɨbu, bɨ God manö hagep ap gɨnaböl, a göm, kalɨ kƚiñ rɨka rö nöp ga. Nɨpe haga, ");
INSERT INTO kpw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem nɨbi bɨ kalɨp hagmim, ‘Kiŋ kale bɨ hain u, kaj donki adö u asɨköm, kalöp auab. Nɨpe kaj donki pi adö u asɨköm auab,’ a gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pen Jisas bɨ nɨpe hag yuö arlö anɨb mɨhau, haga haga rö, ");
INSERT INTO kpw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","kaj donki nɨme abe, pi marep abe paŋɨd dauailö, bɨ nɨpe gau waƚɨj mɨlö ud juöm, kaj donki adö laŋ laila, Jisas adö au asɨka. ");
INSERT INTO kpw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɨbi bɨ iru nöp, Bɨ Kub auab, a göm, waƚɨj mɨlö kale adö laŋ rol lɨmɨdal gau ud juöm, adan majö au lɨla. Rɨmnap am köp uɫaŋ, mab uɫaŋ gau rɨb gɨ dö gɨ dapöm adan majö au lɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɨbi bɨ gau Jisas nɨp bɨg gɨgabö göl amöl gɨ meg magö dap ranöm hagla, “Nɨŋim! Depid rɨkö, rɨk damöm rɨköp u, auöp i. Nɨp aij a gabun! Bɨ Kub nɨp yuö auöp bɨ anɨbi me, nɨp aij a gabun!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jerusalem amjakö nɨŋöl gɨ, nɨbi bɨ gau magöŋhalö hag amɨl apɨl göm hagla, “Bɨ anɨbu an?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hageila, nɨbi bɨ Jisas aip aula gau hagla, “Bɨ i me Jisas, bɨ God manö hagep Nasared, ram mɨnöŋ Galili nɨbö u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas God sabe gep ram raul yaŋ amöm nɨŋa, nɨbi bɨ gau nan sɨkim gɨ mɨdeila. Nɨpe nɨŋöm, kalɨp magöŋhalö rɨdɨk yuöm, abañ bad mani löm, pen pen yɨmjɨk gaila gau ud ado göm, bɨ yaur sɨkim göm, mab po adö asɨk mɨdeila gau, ud ado ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Anɨg göm kalɨp hag göm haga, “God Manö kalɨ kƚiñ rɨkla u, God haga, ‘Ram yad u yɨp sabe gep ram, pen kale gɨpim u, bɨ nan si udep ram ap rö löp,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pen Jisas nɨpe God sabe gep ram raul mɨgan anɨbu mɨdö nɨŋöl gɨ, nɨbi bɨ amgö we ga rɨmnap, nɨbi bɨ ma naij ga rɨmnap aueila, kalɨp gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nɨpe nan gagep rö gö, ñɨ pai pro gau wɨñ alöl gɨ hagla, “Nöp aij a gabun! Depid Ñɨ nɨpe! Use!” gɨla. Pen kale anɨg geila, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe nɨŋlö, kalɨp mulu yabɨƚ luga. ");
INSERT INTO kpw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mulu lugö hagla, “Nöp hagaböl u nɨŋabön?” ö gɨla. Hageila, Jisas kalɨp haga, “Yau! Hagaböl u nɨŋabin u pen kale manö rɨmnap kalɨ kƚiñ rɨköm hagla, ‘God, ne gɨnabön nɨŋöm ñɨ pai pro ñɨ paiŋaŋ gau hib ne haglö adö arnab,’ a gɨla. Kale manö kalɨ kƚiñ rɨkla anɨbu, amgö lɨ nɨŋagim ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anɨg hagöm, kalɨp arö göm, am ram rɨƚɨg agƚö Bedani hana. ");
INSERT INTO kpw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ruö Jisas ado gɨ Jerusalem aramöm adan aŋ gau arö, nɨp kɨyö lö, ");
INSERT INTO kpw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","adan majö goƚ au nɨŋa, mab kia ur ap mɨdeia. Iƚ au amöm nɨŋa, magö ñɨŋeb pɨlaga; uɫaŋ au nöp mɨdeia. Anɨg gö Jisas haga, “Ne hainö magö ap pɨlagnabön!” a ga. Anɨg hagö nɨŋöl gɨ, magö anɨbu nöp kia mab ur u mɨƚep ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Anɨg gö, bɨ nɨpe gau nɨŋöm, aiö göm hagla, “Aige göm mab anɨbi yɨŋɨd mɨƚep göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hageila, Jisas kalɨp haga, “Yad kalöp nɨŋö hagabin, hon hagno God u rö nöp gɨnab, a gɨmim, gasɨ mɨhöp wasö, gasɨ añɨ nöp nɨŋnabim u, gɨnab. Pen mab kia mɨƚep ga u nöp wasö; dum ilö anɨbi ƚɨƚɨ gɨ ñɨg kub aŋ au aru, a gɨnabim u, arnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Pen kale God nɨp nɨŋ ud mɨdmim, nɨp hag nɨŋnabim u, hagnabim rö nöp gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas God sabe gep ram u amöm, nɨbi bɨ gau kalɨp manö hag ñö nɨŋöl gɨ, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe apöm nɨp hagla, “Nöp an ne anɨg gɨmön, a göp, nɨŋmön anɨg gɨ ajabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hageila, Jisas pen haga, “Yad kalöp manö ap hag nɨŋnö, yɨp hag ñɨbe, yad pen an hagö wög gɨpin u, kalöp hag ñɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon nɨbi bɨ gau kalɨp ñɨg pak ña u, nɨpe ke gasɨ nɨŋöm aua aka God hagö, apöm anɨg ga?” ö ga. Jisas anɨg hagö, kale ke hag nɨŋ hag nɨŋ göm hagla, “Hon, ‘God yuö apöm ga,’ a geinabun u, hanɨp hagnab, ‘Anɨb u, Jon hagöp u nɨhön gɨnɨg nɨŋ udagpim?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pen, ‘Jon gasɨ nɨpe ke nɨŋöm apöm ga,’ a geinabun u, nɨbi bɨ gau hanɨp kal gɨnaböl. Gasɨ kale u, Jon nɨpe bɨ God manö hagep bɨ ap aua,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Anɨg hagöm, Jisas nɨp hagla, “Hon nɨŋagpun,” a gɨla. Hageila, Jisas kalɨp haga, “Kale yɨp hag ñagpim rö, yad pen an hagö yad apem gabin u, kalöp u rö nöp hag ñagnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas anɨg hagöm haga, “Pen kale nɨhön gasɨ nɨŋabimŋ Bɨ ap ñɨ nɨpe mɨhöp mɨdeinab. Ñɨ nɨpe nañɨ u nɨp hagnab, ‘Ñɨ me! Mɨñi wain wög u am wög gɨ,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hagö, ñɨ nɨpe hagnab, ‘Yade am gagnam,’ a göm, hainö pen gasɨ adog nɨŋöm, am wain wög u geinab. ");
INSERT INTO kpw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nap pen am ñɨ wañɨg u nɨp u rö nöp hag nɨŋö, hagnab, ‘Yau, gɨnam!’ a gɨnab u pen am gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pen ñɨ anɨb mɨhau, an nap hagnab rö gɨnab?” ö ga. Hageia, Juda bɨ kub anɨb gau hagla, “Ñɨ nɨpe nañɨ u nöp nap hagnab rö gɨnab,” a gɨla. Hageila, Jisas haga, “Yad kalöp nɨŋö hagabin, kale yɨharɨŋ mɨdpe nɨŋöl gɨ, bɨ dakɨs udpal bɨ gau abe, bɨ si udep nɨbi gau abe, God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab ram mɨnöŋ u, kalöp abhak löm arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon bɨ ñɨg pak ñeb u, kale nɨhön nɨhön gɨpe God nɨp aij gɨnab u, kalöp hag ña, pen manö nɨpe u udagpe. Bɨ dakɨs udöm mani piral rɨmnap halö udpal gau abe, bɨ si udep nɨbi gau abe, kale Jon manö haga adö anɨbu nɨŋöm, udla. Udla anɨbu kale hadö nɨŋbe, pen kale ke, Jon manö u udmim, nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun a gɨmim, arö gagpe,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas haga, “Mɨñi manö hod rɨkem ap halö hagnɨg gabin i nɨŋim. Bɨ wög adɨŋ nap nɨbö ap nagɨ wain wög u gɨ yɨmöm, waryö göm, nagɨ wain magö pak hib jakep mɨgan ap geinab. Gɨ löm, nagɨ wain magö ap si ñɨŋnaböl u, nɨŋ mɨdaiun, a göm, ram mɨlö kub ap göm, bɨ rɨmnap kalɨp hagnab, ‘Kale nagɨ wög yɨp u abad mɨdaimim, hainö pɨlöm po gö, yɨp rɨmnap, kale rɨmnap udmim,’ a göm, ram mɨnöŋ mɨlö yabɨƚ gau arnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nagɨ wain magö u po gö nɨŋöl gɨ, bɨ nɨpe gau kalɨp hagnab, ‘Wain wög yad gau ammim, bɨ wög abad mɨdpal gau hagmim, nagɨ wain magö yɨp rɨmnap dauim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kale wain wög gau amjaklö, bɨ wain wög gɨ mɨdeinaböl gau uraköm, bɨ ap nɨp gabi paknaböl, bɨ ap nɨp böŋ nöp al pak lɨlö umnab, bɨ ap nɨp kabö ju paknaböl. ");
INSERT INTO kpw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Anɨg gɨlö, bɨ nagɨ wain wög nap nɨbö anɨbu, bɨ nɨpe rapɨn bad ap pen hag yunab. Hag yuö, areinaböl, bɨ nagɨ wain wög geinaböl gau, kalɨp u rö nöp gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anɨg gɨlö, bɨ wain wög nap nɨbö u hagnab, ‘Ñɨ yad u yunö me, manö nɨp u nɨŋnaböl,’ a göm, hag yuö arnab. ");
INSERT INTO kpw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ñɨ nɨpe u amjakö, bɨ wain wög gɨ mɨdeinaböl gau, nɨp nɨŋöm, kale ke hagnaböl, ‘Bɨ wög nap nɨbö ñɨ nɨpe u auab i. Nap hainö umeinab, nan wög gai i ñɨ nɨpe udnab. Anɨb u, nɨp al pak lɨno umö, hainö nan wög gai i magöŋhalö udnabun,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Anɨg hagöm, nɨp dam wög adɨŋ goƚ gau amöm, böŋ nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Anɨg geinaböl u, hainö bɨ nagɨ wain wög adɨŋ nap nɨbö u apöm, kalɨp nɨhön nɨhön gɨnɨg gab?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hageia hagla, “Bɨ naij gɨnaböl anɨb gau kalɨp geinab, ilön kub yabɨƚ udöm umnaböl; hainö pen nɨbi bɨ rɨmnap halö udöm, kalɨp nagɨ wain wög u lɨnab, wög anɨbu gɨnaböl. Nagɨ wain magö po gɨnab ñɨn u, nɨp rɨk dam ñɨnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hageila, Jisas haga, “God Manö kalɨ kƚiñ rɨkla u nɨŋagpim rö löp. Kale kalɨ kƚiñ rɨköm hagla, ‘Bɨ ram gep gau, kale kabö ram gɨnɨg göm, kabö ap udöm hagla, “Kabö i kabö naij göp gö arö gun,” a gɨla. Pen Bɨ Kub nɨpe geia nɨŋöm kabö anɨbu nöp ram nɨpe au kabö aij ke yabɨƚ mɨdöp. Bɨ Kub nɨpe anɨg gaia, hon nɨŋun aiö yabɨƚ gabun,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kabö aij udagpim anɨbu, God kalöp Juda kai arö göm, nɨbi bɨ ke gau nɨbö, nan nɨp ñeb ñɨnaböl gau, kalɨp udöm abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nɨbi bɨ kabö adö anɨbu ap lug paknaböl gau, kalɨp rapɨn nöp paknab; pen kabö anɨbu ju lugöm, nɨbi bɨ pak rɨbɨknab gau, böŋ nöp pa jö ma jö gɨ arnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ Perisi gau abe, Jisas manö hod rɨköm haga anɨbu, kalɨp nöp haga u nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nɨp nagɨ lun, a göm, gasɨ nɨŋla u pen nɨbi bɨ gau, Jisas nɨp bɨ God manö hagep a gɨla u me, hanɨp kal hagnaböl, a göm, nɨp nan ap göl rö laga. ");
INSERT INTO kpw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas kauyaŋ manö hod rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö: “Bɨ kiŋ ap ñɨ nɨpe u nɨbi udnɨg gö, nan kub ñɨŋnɨg, nan magö dap magum gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Anɨg göm, bɨ nɨpe rɨmnap hag yuöm hagnab, ‘Nɨbi bɨ hag lɨnö gau am hagpe aulö, nan kub ñɨŋun,’ a gɨnab. Anɨg hagö, kale am nɨbi bɨ anɨb gau kalɨp hagnaböl u pen kale arö gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Anɨg gɨlö, bɨ nɨpe rɨmnap pen kauyaŋ hag yuöm hagnab, ‘Kale am nɨbi bɨ anɨb gau kalɨp hagmim, “Kiŋ u, kaj kau kub rɨmnap, kaj kau pi marep rɨmnap pak lauöm, nan gau magöŋhalö gɨ jɨn göm, ‘Auöl,’ a göp,” a gɨmim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Anɨg hagö, kale am hagnaböl u pen manö kalɨp u ud yunaböl. Rɨmnap nan wög kale gau arnaböl; rɨmnap mani wög kale gau geinaböl; ");
INSERT INTO kpw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","pen rɨmnap, kiŋ bɨ nɨpe gau gɨ naij göm, al pak lɨlö umnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Anɨg gɨlö, kiŋ anɨbu nɨŋö, hibur nɨp u naij gö, ami bɨ nɨpe gau hag yuö, am nɨbi bɨ bɨ nɨpe al pak lɨnaböl anɨb gau kalɨp magöŋhalö al pak hak löm, daun kub kale u lau ju yulö arnab. ");
INSERT INTO kpw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pen bɨ nɨp wög gɨ ñeb gau kalɨp hagnab, ‘Nan magö nan gau hadö magum gɨpun, pen nɨbi bɨ nöd wɨñ alnö gau auöl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anɨb u, kale adan ramö gau ammim, nɨbi bɨ nɨŋmim gau, kalɨp magöŋhalö, “Aube nan kub ñɨŋun,” a gɨmim, haƚöwaƚö uɫ gɨ daube, nan kub ñɨŋun,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anɨg hagö, bɨ nɨpe gau am adan ramö ramö gau amöm, nɨbi bɨ aij gau, nɨbi bɨ naij gau kalɨp magöŋhalö, ‘Aube nan kub ñɨŋun,’ a göm haƚöwaƚö uɫ gɨ dapöm, bɨ nɨbi udöm nan kub ñɨŋnaböl ram raul anɨbu amöm, sɨsɨ göl mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kiŋ anɨbu pen, nɨbi bɨ aubal gau nɨŋɨn a göm, ram raul yaŋ amöm nɨŋnab, bɨ ap, nan ñɨŋnɨg waƚɨj lɨbal u löm wasö, yɨharɨŋ nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Anɨg gö, nɨp hagnab, ‘Bɨ me! Nɨhön gɨnɨg, nɨbi udöm nan ñɨŋnɨg waƚɨj lɨbal u lɨmön wasö, yɨharɨŋ nöp auban?’ ö gɨnab. Hagö, bɨ anɨbu pen manö ap hagageinab. ");
INSERT INTO kpw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pen kiŋ u bɨ nɨpe gau kalɨp hagnab, ‘Bɨ i ñɨmagö ma nɨp gau nagɨ lɨmim, dam sɨbön göp aŋ yaŋ ud yube, nɨbi bɨ anɨb gau aip meg magö hau jö göl gɨ, mɨɫöŋ magö göl gɨ mɨdlaŋ,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas aiud anɨbu hag pɨs göm, kalɨp haga, “God nɨbi bɨ iru nöp wɨñ alnab, pen kalɨp magöŋhalö udagnab. Nɨbi bɨ rɨmnap nöp udnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pen bɨ Perisi gau, Jisas nɨp manö nɨhön hagno, pen hagö nɨŋun, nɨp dam nagɨ lun, a göm, manö hag nɨŋ hag nɨŋ göm, ");
INSERT INTO kpw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","bɨ kale ke rɨmnap, Herod bɨ nɨpe rɨmnap yulö, Jisas mɨdeia au amöm hagla, “Manö hag ñeb bɨ. Ne bɨ manö nɨŋö yabɨƚ nöp hagabön. Bɨ rɨmnap nɨŋmön pɨñɨŋ gagpan. God hagöp rö nöp nɨŋmön, nɨbi bɨ hag ñabön. ");
INSERT INTO kpw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anɨb u, ne gasɨ nɨhön nɨŋban? Hon Isrel nɨbi bɨ, Sisa bɨ kub daun kub Rom nɨbö u, nɨp dakɨs ñeb aka ñagep wasö?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hageila, Jisas gasɨ naij kale nɨŋöm haga, “Yɨp nɨhön gɨnɨg neb neb göl gɨ apim, anɨg göl hag nɨŋabim? ");
INSERT INTO kpw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kale dakɨs ñɨbal kabö magö ap ñɨbe, nɨŋɨn!” a ga. Hagö, nɨp kabö magö ap dap ñeila. ");
INSERT INTO kpw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisas kabö magö anɨbu nɨŋöm kalɨp haga, “Kabö magö i, bɨ nabɨc cög i, an nabɨc cög mɨdöpŋ Hib u, an hib mɨdöp?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hageia hagla, “U bɨ kub Sisa,” a gɨla. Hageila, Jisas kalɨp haga, “Anɨb u, Sisa nan nɨpe mɨdainɨm, Sisa nɨp ñɨmim. God nan nɨpe mɨdainɨm, God nɨp ñɨmim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Anɨg hagö, kale gasɨ iru nɨŋöm, nɨp arö göm arla. ");
INSERT INTO kpw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñɨn anɨbu nöp, Sadyusi bɨ rɨmnap Jisas mɨdeia au aula. Sadyusi nɨbi bɨ anɨb gau hagmɨdal, nɨbi bɨ umöm kauyaŋ urakagnaböl, a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kale Jisas mɨdeia au apöm hagla, “Manö hag ñeb bɨ. Mosɨs haga, ‘Bɨ ap nɨbi udöm, ñɨ pai yag dapöm wasö, yɨharɨŋ umeinab, nɨmam nɨpe u, nɨbi anɨbu udöm, ñɨ pai nɨpe gau, a göm, yag daunɨm,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anɨb u, bɨ iƚ halö unbö mudun jɨŋ u mɨdeinaböl. Nɨmam nañɨ u nɨbi udöm, ñɨ pai yag dapöm wasö yɨharɨŋ umnab. Anɨg gö, nɨmam yɨgwö aŋ nɨbö u pen nɨbi anɨbu nöp udnab. ");
INSERT INTO kpw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nɨmam yɨgwö aŋ nɨbö u pen nɨbi anɨbu udöm, u rö nöp ñɨ pai yag dapöm wasö, yɨharɨŋ umnab. Anɨb u, nɨmam yɨgwö nɨgaŋ nɨbö u nɨbi anɨbu udöm, u rö nöp ñɨ pai yag dapöm wasö, yɨharɨŋ umnab. Anɨbu nöp gɨ dam dam, nɨmam unbö mudun jɨŋ u, magöŋhalö ñɨ pai yag dapöm wasö, yɨharɨŋ nöp umnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pen nɨbi u, u rö nöp umnab. ");
INSERT INTO kpw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nɨmam gau kale magöŋhalö nɨbi anɨbu udla. Anɨb u, nɨbi bɨ umbal gau uraknaböl ñɨn u, nɨbi anɨbu an udnab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hageila, Jisas kalɨp pen haga, “Kale God Manö hagöp u abe, God kƚö mɨdöp u abe, nɨŋagpim u me, dui hagmim hagpim, ‘Nɨbi bɨ gau umöm urakagnaböl,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nɨbi bɨ uraknaböl ñɨn u, nɨbi gau bɨ udagnaböl, bɨ gau nɨbi udagnaböl. Ejol kumi kabö adö laŋ mɨdpal rö u mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kale, ‘Nɨbi bɨ umöm urakagnaböl,’ a gɨpim u, God Manö kalɨ kƚiñ rɨkla rɨmnap nɨŋagpim ar? ");
INSERT INTO kpw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God haga, ‘Yad Ebraham, Aisak, Jekop, God kale me yad mɨdpin,’ a ga. Bɨ gau böŋ nöp umblap u, God bɨ nöd umla anɨb gau kalɨp hagöm, ‘God kale yad mɨdpin,’ a gagböp. Bɨ umlö, rɨgöl gɨla anɨb gau kamɨŋ mɨdpal u me, kalɨp haga, ‘God kale yad mɨdpin,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisas manö anɨbu hag ñö, nɨbi bɨ mɨdeila gau nɨŋöm, aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas manö anɨbu hag aij gö, Sadyusi bɨ gau manö ap pen hagöl rö laga. Pen Perisi bɨ rɨmnap, Jisas anɨg ga u nɨŋöm Jisas mɨdeia au aula. ");
INSERT INTO kpw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bɨ kale lo manö nɨŋ aij ga ap, Jisas nɨhön rö hagnɨm, a göm haga, ");
INSERT INTO kpw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Manö hag ñeb bɨ. Lo manö u, manö adö mai manö kub yabɨƚ mɨdöp?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hageia, Jisas haga, “Gasɨ rɨmɨd ne u magöŋhalö God lau adö arö, nɨp mɨdmagö yabɨƚ lɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Manö kub nöd yabɨƚ me u. ");
INSERT INTO kpw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Manö kub yɨgwö aŋ nɨbö u pen anɨgöl mɨdöp: ne ke mɨdmagö lɨban rö, nɨbi bɨ ke nɨbö gau abe mɨdmagö lɨmön. ");
INSERT INTO kpw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Manö mɨhau hagajɨn i, Mosɨs lo manö kalɨ kƚiñ rɨka manö u magöŋhalö abe, God manö hagep bɨ gau kalɨ kƚiñ rɨkla manö u magöŋhalö abe, manö iƚ kub yabɨƚ me manö anɨb mɨhau nöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Perisi kai ap magum göm mɨdlö nɨŋöl gɨ, Jisas kalɨp manö ap hag nɨŋöm haga, ");
INSERT INTO kpw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kale Mesaia u nɨp nɨhön gasɨ nɨŋbimŋ Nɨp bɨ an ñɨ nɨpe a gɨmim nɨŋbim?” ö ga. Hageia hagla, “Depid ñɨ nɨpe,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hageila, Jisas haga, “God Ana u Depid nɨp gasɨ ñö nɨŋöl gɨ, Depid nɨpe Mesaia u nɨp ‘Bɨ Kub yad’ a ga. Depid haga, ");
INSERT INTO kpw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bɨ Kub manö hagöm, Bɨ Kub yad u nɨp hagöp, “Ne ñɨmagö yɨjɨg yad lau adö mɨdmön me, yad gɨnö, kauaƚ mauaƚ ne gau kalɨp ab ƚɨƚɨ gɨ yunabön,” a göp,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depid nap iƚaŋ nɨpe a gɨpim u pen Depid nɨp ‘Bɨ Kub yad’ a ga. Anɨb u, kale nɨhön gasɨ nɨŋbim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas manö nɨpe u hag aij gö, kale nɨp pen hagöl rö lagö me, pɨñɨg gɨ mɨdeila nɨŋöm hainö Jisas nɨp manö rɨmnap halö hag nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hainö ñɨn ap, Jisas bɨ nɨpe gau abe, nɨbi bɨ rɨmnap abe, kalɨp manö hagöm haga, ");
INSERT INTO kpw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, Mosɨs ka nɨpe u udöm, God lo manö Mosɨs hadame nöp kalɨ kƚiñ rɨka rö hag ñɨbal. ");
INSERT INTO kpw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Anɨb u, bɨ anɨb gau kale God lo manö nɨhön hagöl u nɨŋ udmim hain gɨmim; pen nagɨ kale göl adö u nɨŋmim, hain gagmim. God lo manö hag ñɨbal u pen kale ke manö anɨbu hain gagpal. ");
INSERT INTO kpw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nan gau gɨmim, nan gau gagmim a gɨpal u, manö iru yabɨƚ nöp hagpal. Kale hagpal anɨbu, wadɨ marö kub yabɨƚ u rö, nɨbi bɨ gau kalɨp gam ñɨbal u, pen kalɨp mög nɨŋöm, rɨmnap ud asɨk gagpal. ");
INSERT INTO kpw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nɨbi bɨ gau hanɨp nöp nɨŋlaŋ, a göm, God Manö kalɨ kƚiñ rɨkla manö rɨmnap ud nable cög adö laŋ abe, ñɨmagö gau abe lɨ rɨbɨköm ajpal. Hon God bɨ nɨpe me gau, a gɨlaŋ, a göm, waƚɨj mɨlö kub nagɨ adɨŋ halö aij gau rol gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kale nan kub ñɨŋeb aŋ u amöm aka Juda magum gep ram gau amöm, bɨ kub mab po asɨkpal adö u nöp asɨkpal. ");
INSERT INTO kpw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gasɨ kale nɨŋbal u, nɨbi bɨ iru mɨdpal aŋ gau arno, ‘Manö hag ñeb bɨ kub auabön e!’ gɨlö, hanɨp aij gɨnab, a göm, nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pen kale mam iƚ añɨ mɨdpim rö, kalöp, ‘Hag ñeb bɨ kub yad,’ a göm hagagöl. Hag Ñeb Bɨ Kub kale añɨ ap nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mɨnöŋ naböŋ iƚ i bɨ ap, ‘Bapi bɨ kub yad,’ a gɨmim hagagmim. Nap kale añɨ ap nöp mɨdöp ram mɨnöŋ kumi kabö adö laŋ au. ");
INSERT INTO kpw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kale u rö nöp, ‘Bɨ nabɨc bɨ kub yad,’ a göm hagagöl. Bɨ nabɨc bɨ kub kale añɨ ap nöp, Mesaia u nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kale aŋ au, nɨbi bɨ an nɨpe nɨbi bɨ kub rö mɨdainɨm, nɨpe nɨbi bɨ wög gɨ ñeb rö mɨdnab. ");
INSERT INTO kpw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nɨbi bɨ hib kale ke haglö adö arnab gau, hib kale lugnab; pen nɨbi bɨ hib kale ke haglö adö aragnab gau, hainö hib kub yabɨƚ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Kale ke God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab mɨgan u aragmim, nɨbi bɨ arnɨg gɨpal gau kalɨp adan rɨkpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Kale nɨbi paƚpaƚ ram halö si udpim. Anɨbu pen, nɨbi bɨ hanɨp nɨŋöl, a gɨmim, God nɨp manö mɨlö kub piral gau nöp hagpim. Gɨpim anɨbu me, ilön kub yabɨƚ udnabim. ");
INSERT INTO kpw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Nɨbi bɨ gau manö hanɨp u nɨŋöm hain gɨlaŋ, a gɨmim, ram mɨnöŋ mɨlö gau uƚhai nɨŋ ajmim, rɨmnap nɨŋmim hag ñɨbe, kale ke Seden bɨ nɨpe mɨdpim rö wasö, kale Seden nɨbi bɨ nɨpe yɨjɨg göl yabɨƚ lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nɨbi bɨ gau kalɨp God adan la u yam aij gɨpun, a gɨpim u, pen kale bɨ amgö we u me, kale ke nɨŋagpim! Anɨg gɨpim anɨbu, manö kub yabɨƚ mɨdöp. Nɨbi bɨ gau kalɨp manö pir almim hagpim, ‘Hon, “God sabe gep ram mɨdöp rö, nɨŋö hagabun,” a gɨnabun u, hainö arö gun, a gɨnabun u, arö gɨnabun. Pen gol udöm, nan God sabe gep ram raul yaŋ gɨla gau, hib anɨbu hagöl gɨ, “Nɨŋö hagabun,” a gɨnabun u, hagnabun rö nöp gɨnabun me; arö gagnabun,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kale bɨ amgö we, bɨ hauƚ! Kale gasɨ nɨhön nɨŋbim: gol u nan yabɨƚ aka God sabe gep ram uɫ u nan yabɨƚŋ Nan yabɨƚ me, God sabe gep ram uɫ nɨpe u. Ram uɫ mɨdeinab u, nan ram raul mɨdöp abe uɫ mɨdeinab me. ");
INSERT INTO kpw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Manö ap u rö nöp, nɨbi bɨ gau kalɨp manö pir almim hagpim, ‘Hon, “God kabö bɨd nɨpe mɨdöp rö nɨŋö hagabun,” a gɨnabun u, manö nɨŋö hagnabun u nan yɨharɨŋ; hainö gasɨ ap nɨŋun, arö gun, a gɨnabun u, arö gɨnabun. Pen, nan God kabö bɨd adö au God nɨp pak sabe gɨ ñɨbal gau, hib anɨbu hagöl gɨ, “Nɨŋö hagabun,” a gɨnabun u, hainö gasɨ ke ap nɨŋun ke gun rö lagnab; hagnabun rö nöp gɨnabun,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kale bɨ gasɨ rɨmɨd lagöp gau, nan nɨhön u nan kubŋ Nan God nɨp pak sabe gɨ ñɨbal nan u, aka kabö bɨd adö au sabe gɨ ñɨbal uŋ Nan yabɨƚ me, kabö bɨd u. Kabö bɨd adö au mɨdeinab u me, nan anɨbu nan God nɨp ñeb rö lɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pen ‘Kabö bɨd mɨdöp rö, nɨŋö hagabun,’ a gɨnaböl u, bɨd adö anɨbu nan dap laumɨdal halö hagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pen ‘God sabe gep ram mɨdöp rö, nɨŋö hagabun,’ a gɨnaböl u, u God ram nɨpe nɨŋöm God hib nɨpe halö hagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","‘Kumi kabö adö laŋ mɨdöp rö, nɨŋö hagabun,’ a gɨnaböl u, God sea kiŋ asɨk mɨdöp au nɨŋöm sea kiŋ anɨbu abe, God sea kiŋ anɨbu asɨk mɨdöp u abe mɨdöp rö, nɨŋö hagabun a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Manö nɨbi bɨ rɨmnap kalɨp hagpim adö u kale ke gagpim. Kamöŋ asɨ, nan haƚöwaƚö wög adɨŋ ranöb u nɨŋbe, nan yabɨƚ rö lö, wö ralbe, am sɨduŋ laŋ arö, God nɨp añɨ ap ñun, a gɨmim, pör nan kale God nɨp ñɨbim. Nan pro pro anɨbu rö pör anɨg gɨpim, pen nɨhön gɨnɨg manö iƚ yabɨƚ u anɨg gagpimŋ Nɨbi bɨ gau kalɨp naij gɨnɨm nagɨ adö u gagmim; kabö rö gɨnɨm adö u gɨmim. Kalɨp mög nɨŋmim, ud aij gɨmim. Gɨnabun a gɨmim, gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nɨbi bɨ gau kalöp adan yamun, a gɨpim, pen kale ke bɨ amgö we. Nan pro pro gau nɨŋbe, nan yabɨƚ rö löp, pen nan kub nan hib waiö mɨdöp gau nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Pler kap kale gau rö, höŋ adö gau ñɨg lɨ yu aij gɨpim u, pen aŋ yaŋ nan si nan naij prɨ u ajmaŋ rauöm mɨdöp. Hon nan iru udun, a gɨmim, hañ romaŋ hon ke gɨ aij gun, a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kale Perisi bɨ gau gasɨ rɨmɨd lagöp. Pler kap kale aŋ yaŋ ñɨg lɨ yu aij gɨbep, höŋ adö gau u rö nöp mɨd aij gɨböp. ");
INSERT INTO kpw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Wip kabö mɨgan gau rɨgöl göm, ajöŋ pɨƚ göm, ped rud mailö aij gö, nɨbi bɨ gau nɨŋlö, aij göp, pen mɨgan aŋ yaŋ wip le haƚɨŋ naij apöl gɨ mɨdöp; kale unbö rö nöp mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kale unbö rö nöp, höŋ adö hañ romaŋ nɨŋbun u, kale bɨ aij rö löp u, pen kalöp aŋ yaŋ, manö piral gau abe, nan si nan naij gau abe, prɨ u ajmaŋ rauöm mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kale God lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe, kale manö pir alöm gɨ naij gep bɨ. God kalöp gɨ naij gɨnab. Bɨ God manö hagep hadame nöp allö rɨgöl gɨla uƚöm ka adö u rɨb adɨk gɨ aij göl gɨ hagpim, ");
INSERT INTO kpw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Apɨs bac bɨ gɨla rö u, hon God manö hagep bɨ gau kalɨp al pakagbnop,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pen hagpim anɨbu, bɨ God manö hagep gau kalɨp al pak lɨmɨdal iƚ u me, hon mɨdpun, a gɨmim, hagpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Anɨb u, apɨs bac bɨ gɨ naij gɨla u rö, kale u rö nöp gɨnabun, a gɨmim u, u rö nöp gɨmim! ");
INSERT INTO kpw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kale haiŋo ñɨ pai gai i. Hainö God nɨbi bɨ manö kub hagöm, mab ke inab yaŋ yunab ñɨn u, kale aigö gɨmim pɨñɨŋ gɨ ke gau arnabimŋ Wasö yabɨƚ. Adan kale ap mɨdageinab. ");
INSERT INTO kpw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Anɨb u, yad kalöp hagabin, yad bɨ God manö hagep rɨmnap, bɨ gasɨ kɨd hiɨk nɨŋeb rɨmnap, bɨ manö hag ñeb rɨmnap yunö, kalöp aueinaböl, rɨmnap al pak lɨnabim, rɨmnap mab ba laŋ al pak lɨnabim, rɨmnap Juda magum gep ram raul mɨgan kale u paknabim, rɨmnap pɨñɨŋ gɨ arlö nɨŋöl gɨ, ram mɨnöŋ gau gau rɨdɨk gɨ yunabim. ");
INSERT INTO kpw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Anɨb u me, God nɨbi bɨ kamɨŋ aij nɨpe gau, hadame nöp allö auöp i rö, manö marö u udnabim. Adam ñɨ nɨpe, gɨ aij nöp gɨmɨdöp bɨ u, Ebol nɨp nöd iƚ göm al pak löm, al dapöm, al dapöm, hainö Berekaia ñɨ nɨpe Sekaraia nɨp, God nɨp sabe gep ram au daŋ, kabö ud gɨla bɨd au daŋ mɨdö nɨŋöl gɨ, nɨp aŋ au al pak lɨla. ");
INSERT INTO kpw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yad kalöp nɨŋö yabɨƚ hagabin: nan gɨpim anɨbu, manö anɨbu kalöp mɨñi mɨdpim gai i ado gɨ aunab. ");
INSERT INTO kpw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem nɨbi bɨ, nɨbi bɨ mög gep rö yad gai i. Bɨ God manö hagep God kalɨp yua bɨ gau, ram mɨnöŋ kalöp u aulö, kabö jumim pör nöp al pak lɨbim. Yad kalöp kɨƚakɨƚ nɨme pi gau gɨpal rö, dam auan mo yad gau lɨnam a gɨ lɨbin u pen yɨp nɨŋmim arö gɨpim. ");
INSERT INTO kpw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","God nɨpe God sabe gep ram kale u arɨk ara; cög nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Uri yɨp nɨŋagnabim; hainö, ‘God bɨ hanɨp a göm yua bɨ i, aij yabɨƚ auab,’ a gɨmim, ñɨn anɨbu nöp, yad kauyaŋ nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas God sabe gep ram u arö göm, höŋ arö nɨŋöl gɨ, bɨ nɨpe gau nɨp hagla, “God sabe gep ram aij gai i nöŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hageila, kalɨp haga, “Kale nan anɨb gau magöŋhalö nɨŋmim hagabim u pen yad kalöp nɨŋö yabɨƚ hagabin, hainö ram i ud waƚ gɨnaböl u, kabö ap kabö ap adö u rö mɨdageinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas am Olip Dum laŋ asɨk mɨdö nɨŋöl gɨ, bɨ nɨpe gau apöm, kalpe ke nöp ap Jisas nɨp agamɨj hag nɨŋöm hagla, “God sabe gep ram ud waƚ gɨnaböl a gɨpan u, mañ mai rö anɨg gɨnabölŋ Hon nan nɨhön u gö nɨŋun, ne söl aunabön nɨŋöm ram mɨnöŋ naböŋ iƚ i ur gɨnab, a gun nɨŋnabun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hageila, Jisas haga, “Nɨŋ aij yabɨƚ gɨmim. Nɨbi bɨ rɨmnap kalöp piral hagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bɨ iru nöp apöm, nɨbi bɨ gau kalɨp pir alöm, hib yad u udöm hagnaböl, ‘Yad nöp Krais u,’ a gɨnaböl. Nɨbi bɨ iru nöp manö piral kale u nɨŋ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Söl au pen pen gɨlö, gu gö nɨŋnabim; pen mɨlö yabɨƚ gau pen pen gɨnaböl u, manö u nöp auö nɨŋnabim. Anɨg gö nɨŋmim, ñɨn hain u aunɨg gab a gɨmim pɨñɨŋ gagmim. U yɨharɨŋ pen pen alnaböl. Ñɨn hain u hainö aunab. ");
INSERT INTO kpw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nɨbi bɨ mɨgan rɨmnap uraköm, nɨbi bɨ mɨgan rɨmnap aip pen pen gɨnaböl. Kiŋ mɨgan rɨmnap uraköm, kiŋ mɨgan rɨmnap aip pen pen gɨnaböl. Ram mɨnöŋ gau magöŋhalö munmon udöm, kɨyö kub yabɨƚ apöm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Anɨg geinab, kalöp nɨbi ñɨ pai ñɨŋöb rö u gö, söl mɨdöp a gɨmim nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kale nɨbi bɨ yad mɨdeinabim rö, nɨbi bɨ ram mɨnöŋ gau magöŋhalö kalöp iru nɨŋöm, dam nagɨ löm, gɨ naij göm, böŋ nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ñɨn anɨbu, nɨbi bɨ God nɨp nɨŋ udpal gau iru nöp nɨŋ udep magö kale u arö göm, mɨdeimam kale ke gau nɨŋlö mulu lugö, kalɨp ud bɨ kauaƚ mauaƚ ñɨmagö adö u lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pen nɨbi bɨ iru nöp apöm, “Hon God manö hagep bɨ,” a göm, manö piral haglö, nɨbi bɨ iru nöp manö piral kale u udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nɨbi bɨ gau nagɨ naij adö u gɨlö gɨlö, magöŋhalö rö gasɨ adö anɨbu nɨŋöm, mɨdmagö lep adö u hauƚ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pen nɨbi bɨ an God manö aij u nɨŋ ud pɨdöŋ göm, hagöp rö göm, nɨbi bɨ ke nɨbö gau mɨdmagö löm gɨ nöp mɨdeinaböl gau, God nɨbi bɨ anɨb gau kalɨp magöŋhalö ud kamɨŋ yunab. ");
INSERT INTO kpw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pen God nɨbi bɨ udöm abad mɨdeinab manö aij u, ram mɨnöŋ ke gau gau nɨbi bɨ ke ke gau nɨbö gau nɨbö magöŋhalö yabɨƚ haglö haglö am haknɨg gab u me, ñɨn hain anɨbu aunab. ");
INSERT INTO kpw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pen bɨ God manö hagep Daniel hadame nöp haga rö u gɨnab. Nɨpe haga, ‘Kale nɨŋnabim, God sabe gep ram raul mɨgan uɫ u, nan asɨ masɨ naij yabɨƚ gep ap urak mɨdeinab,’ a ga. (Kale nɨbi bɨ manö i uri nöp amgö lɨ nɨŋabim gau, manö anɨbi iƚ u nɨŋ aij gɨmim!) ");
INSERT INTO kpw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kale nɨbi bɨ ram mɨnöŋ Judia mɨdeinabim gau, nan naij anɨbu nɨŋmim, yɨŋɨd pɨñɨŋ gɨ nö ilö gau armim. ");
INSERT INTO kpw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nɨbi bɨ ram adö laŋ mɨdeinabim gau, nan hon rɨmnap udun a gɨmim, ado gɨ ram raul aragmim. ");
INSERT INTO kpw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɨbi bɨ wög naböŋ gau ajeinabim gau, waƚɨj mɨlö ap udun a gɨmim, ado gɨ ram aragmim. ");
INSERT INTO kpw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pen ñɨn anɨbu nɨbi ñɨ mudun halö mɨdeinabim gau abe, nɨbi ñɨ paiŋaŋ ci ñeinabim gau abe, uɫham yabɨƚ arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pen God nɨp sabe gɨmim hagmim, ram yɨgön göp ñɨn u pɨñɨŋ gɨ aragun, a gɨmim; God nɨp sabe gep ñɨn kale u gagnɨm, a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nɨhön gɨnɨg, God hadame dagol gau ram mɨnöŋ gɨ la ñɨn u rɨköm, mɨd damöm mɨñi mɨdpun ñɨn i, nan naij anɨbu rö gaga; hainö anɨbu rö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yɨharɨŋ u, nan naij anɨbu pör gö, nɨbi bɨ magöŋhalö um hakblap. Pen Bɨ Kub u nɨbi bɨ nɨpe udnab gau kalɨp gasɨ nɨŋöm, wasö gö me, nan naij anɨbu yöp magö ap gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ñɨn anɨbu nɨbi bɨ rɨmnap kalöp hagnaböl, ‘Nɨŋim! Krais mɨdöp i! Krais mɨdöp daŋ!’ a gɨnaböl u, pen nɨŋö hagpal a gɨmim, nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nɨbi bɨ rɨmnap, God nɨbi bɨ nɨpe hag la gau, böŋ hanɨp lau aulaŋ a göm, piral hagöm hagnaböl, ‘Yad me Krais; yad me bɨ God manö hagep bɨ ap,’ a göm, nan gagep rö rɨmnap gɨnaböl. Pen God nɨbi bɨ nɨpe hag la gau udagnaböl, wasö. ");
INSERT INTO kpw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Anɨb u, nɨŋ aij gɨmim. Nan nɨhön nɨhön hainö gɨnab u, yad kalöp hadö hagnö nɨŋbim u me, nɨŋ aij göl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Anɨb u, nɨbi bɨ rɨmnap apöm kalöp hagnaböl, ‘Krais apöm mɨdöp ram mɨnöŋ kabö nöp mɨdöp aŋ gau,’ a gaiöl u, anɨb gau aragmim. Rɨmnap pen hagnaböl, ‘Krais apöm pi göl mɨdöp gai i,’ a gaiöl u, nɨŋö hagpal a gɨmim nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yad Bɨ Ñɨ nɨpe aunabin ñɨn u, añɨm añɨm udöm, amdam magö bol u adɨŋ mɨŋ nɨbö adɨŋ jɨŋ aröp rö u gö nɨŋöl gɨ, aunabin. ");
INSERT INTO kpw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wal wayöŋ ap umöl mɨdeinab u, yaur apöm magum geinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pen marö kub anɨbu gɨ dam pɨs gö nɨŋöl gɨ, sɨdö u mailö gagnab; rakɨn u mailö gagnab; gapɨ gau kumi kabö laŋ nɨbö ju lugnab; nan kumi kabö adö laŋ gau, gau nɨbö gau nɨbö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ñɨn anɨbu, Bɨ Ñɨ nɨpe aunɨg gö nɨŋöl gɨ, kumi kabö adö laŋ ke lö, nɨbi bɨ ram mɨnöŋ gau ke ke mɨdpal rö nɨŋöm, mɨɫöŋ gɨnaböl. Bɨ Ñɨ nɨpe Nap pɨdöŋ u udöm, mailö aij unbö ke halö kumi bad adö au auö nɨŋöl gɨ, nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aƚɨŋ magö kub hagö nɨŋöl gɨ, ejol nɨpe gau hag yuö, nɨbi bɨ nɨpe, udnabin, a göm hag la gau udnɨg, ram mɨnöŋ iƚ i mɨdöp mɨdöp rö gau gau amöm, udöm nɨp daunaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kale nɨŋbim, mab rauan uɫaŋ sɨƚɨp löm, söl pɨdöŋ gɨnɨg gab nɨŋöl gɨ, sɨdö lɨnɨg gab a gɨmim nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anɨb u rö, hainö nan hagpin gau gö nɨŋöl gɨ, “Bɨ Ñɨ nɨpe ado gɨ aunab ñɨn u mɨñi söl yabɨƚ mɨdöp; magö pro marap mɨdöm, apjaknab,” a gɨmim, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yad kalöp nɨŋö hagabin, nɨbi bɨ mɨñi mɨdpal gau umagnaböl, kamɨŋ mɨdlö nɨŋöl gɨ, nan anɨb gau magöŋhalö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe ur gɨnab, pen manö magö yad ur gagnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yad magö mai rö, ñɨn mai rö aunabin u, nɨbi bɨ nɨŋagpal; ejol gau nɨŋagpal; yad ke God Ñɨ u pen yad abe nɨŋagpin; Bapi nɨpe ke nöp nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Yad Bɨ Ñɨ nɨpe ado gɨ aunabin ñɨn u, Noa mɨdeia ñɨn u, gɨ mɨdmɨdal rö nöp gɨ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hadame nöp Noa mɨdeia ñɨn anɨbu, ñɨg u nɨbi bɨ gau kalɨp ud yuö yuaga magö u, kale nan ñɨŋöl gɨ, ñɨg ñɨŋöl gɨ, nɨbi bɨ udöl gɨ, gɨ mɨdlö nɨŋöl gɨ, Noa ñɨg magɨb kub mɨgan u arö, ñɨg apöm kalɨp magöŋhalö ud yuö yua. ");
INSERT INTO kpw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pen kale nan ap gɨnab a göm nɨŋagla; ñɨg u kalɨp ud yuö yuö nɨŋöl gɨ nöp nɨŋla. Hainö yad Bɨ Ñɨ nɨpe aunabin mañu, anɨg unbö rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ñɨn anɨbu, bɨ mɨhöp wög adɨŋ gau wög gɨ mɨdeinabil u, bɨ ap udem, ap arö gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pen nɨbi mɨhöp plaua gɨnɨg, wid magö pa jö ma jö ƚugaƚug geinabil u, ap udem, ap arö gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Yad Bɨ Kub aunabin ñɨn u nɨŋagpim u me, nɨŋ aij göl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bɨ ram nap nɨbö u, bɨ nan si udep u magö mai aunab u nɨŋböp, nɨŋ aij gɨböp; ram nɨpe pa jö gɨ raul daŋ am nan nɨpe gau si udagböp. ");
INSERT INTO kpw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Anɨb u rö, kale gɨ jɨn gɨmim mɨdaimim. Wasö u, Bɨ Ñɨ nɨpe auagab a gɨmim, hauƚ padö gɨ mɨdeinabim ñɨn u nöp aunabin. ");
INSERT INTO kpw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bɨ kub ap adan arnɨg göm, bɨ an wög gɨ aij gɨnab u nɨp hag löm hagnab, ‘Bɨ wög yɨp gɨ ñɨbal rɨmnap kalɨp abad mɨdmön, nan magö kalɨp gau nɨme lɨ aij göl gɨ mɨdaimön,’ a göm, arnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hainö ado gɨ apöm nɨŋnab, haga rö nöp geinab. Anɨg nɨŋöm nɨp ud aij yabɨƚ gö nɨŋöl gɨ, bɨ wög gɨ ñeb nɨpe mɨñ mɨñ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yad kalöp nɨŋö hagabin, nɨp hag lö, nan nɨpe gau magöŋhalö abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Pen bɨ nɨpe hag lɨnab anɨbu mɨd damöm, bɨ kub mɨñi auagnab, a göm, ");
INSERT INTO kpw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nɨbi bɨ wög gɨ ñeb rɨmnap kalɨp mɨñu magö paköm, am bɨ ñɨg ñɨŋöm hauƚ lɨbal gau aip aŋ haköm, nan ñɨŋöm, ñɨg ñɨŋöm gɨ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bɨ wög gep anɨbu, bɨ kub yɨŋɨd auagnab, a göm, hauƚ padö göm mɨdeinab ñɨn u nöp, bɨ kub aunab. ");
INSERT INTO kpw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Apöm, nɨp gɨ naij yabɨƚ göm, nɨbi bɨ piral hagöm, “Hon Bɨ Kub nɨbi bɨ nɨpe me,” a göm piral hagpal gau aip hag yunab. Hag yuö, kale am meg hau rɨbɨköm, mɨɫöŋ gɨ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“God nɨbi bɨ udöm abad mɨdeinab ñɨn anɨbu, aiud adö i rö gɨnab. Bɨ ap nɨbi udnɨg gab. Nɨbi praj unbö sɨduŋ laŋ nan kub ñɨŋnɨg arnaböl. Nɨbi praj anɨb gau, bɨ anɨbu nɨp am adan aŋ au nɨŋun uɫ gɨ dam ram aunabun a göm, ƚam ke ke udöm arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pen nɨbi praj anɨb gau, unbö mamɨd u gasɨ nɨŋ aij gɨnaböl; unbö mamɨd u gasɨ nɨŋ aij gagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɨbi praj gasɨ nɨŋ aij gagnaböl gau, ƚam udöm, ƚam lauep wel rɨmnap halö ud aragnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pen nɨbi praj gasɨ nɨŋ aij gɨnaböl anɨb gau, ƚam udöm, ƚam lauep wel rɨmnap ral barol mɨgan u löm, halö halö ud arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pen nɨbi praj anɨb gau kale magöŋhalö amjaköm, abad mɨdlö mɨdlö, bɨ nɨbi udnɨg gɨnab u yɨŋɨd auageinab me, uhön auö hon han arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pen sɨbön aŋ kub yaŋ, nɨbi bɨ rɨmnap wɨñ alöm hagnaböl, ‘Bɨ nɨbi udnɨg gab u auab. Nɨp am adan aŋ u nɨŋmim, uɫ gɨ dauim,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Anɨg hageinaböl, nɨbi ugan unbö sɨduŋ laŋ anɨbu magöŋhalö uraköm, ƚam wik kale gau gɨ aij gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anɨg göm, nɨbi gasɨ nɨŋ aij gagnaböl ugan u, nɨbi gasɨ nɨŋ aij gɨnaböl ugan u kalɨp hagnaböl, ‘Ƚam hon gau hoŋ gɨnɨg gab u, wel köl gau hanɨp rɨmnap ñim,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Anɨg hageinaböl u, pen nɨbi gasɨ nɨŋ aij gɨnaböl ugan u hagnaböl, ‘Wasö! Hon wel hon kölape rɨmnap ñɨnabun u, wel hon uƚep gɨnab. Kale wel rauep ram ap gau ammim, kale ke rauim,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Anɨg hageinaböl, wel rauep ram u arnaböl magö u, bɨ nɨbi udnɨg gɨnab u apjaknab. Nɨbi gasɨ nɨŋ aij gɨnaböl ugan u, bɨ anɨbu aip ram raul mɨgan arlö nɨŋöl gɨ, nɨpe ajöŋ gɨ ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hainö pen nɨbi praj gasɨ nɨŋ aij gagnaböl ugan u apjaköm hagnaböl, ‘Bɨ kub! Bɨ kub! Hanɨp ajöŋ u hiɨk,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hageinaböl, hagnab, ‘Yad kalöp nɨŋö yabɨƚ hagabin, yad kalöp nɨŋagpin,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas manö anɨbu hagöm nɨbi bɨ gau haga, “Anɨb u, kale Bɨ Kub u ñɨn mai aka magö mai aunab u nɨŋagpim rö, nɨŋ aij gɨmim mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pen aiud udnɨg gabin adö i rö gɨnab. Bɨ kub ap ram mɨnöŋ mɨlö kub gau arnɨg, bɨ wög gɨ ñeb nɨpe gau kalɨp wɨñ alö aulö, nan nɨpe gau abad mɨdeilaŋ, a göm, kalɨp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","16","Bɨ nɨpe anɨb gau, wög gɨnaböl gɨnaböl rö nɨŋöm, mani nɨme löm, bɨ ap nɨp paip dausan ñɨnab, ap nɨp du dausan ñɨnab, ap nɨp wan dausan ñɨnab. Ñöm, nɨpe am gau mɨdö nɨŋöl gɨ, bɨ paip dausan udnab u, mani anɨbu udöm, sɨkim gɨ dam amɨl apɨl göm, mani sinɨŋ paip dausan udnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bɨ du dausan udnab u, u rö nöp, mani anɨbu udöm, sɨkim gɨ dam amɨl apɨl göm, mani sinɨŋ du dausan udnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pen bɨ mani wan dausan udnab u, damöm, uƚöm udöm mɨnöŋ ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hainö mɨd damöm, bɨ wög gɨ ñeb anɨb gau bɨ kub kale u ado gɨ apöm, mani ñɨbin anɨbu nɨhön nɨhön gɨpal, a göm, kalɨp hag nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hag nɨŋö, bɨ paip dausan udnab u, mani nɨpe u dap ñöm hagnab, ‘Bɨ kub, nöŋ! Yɨp mani paip dausan nöp ñɨna pen yad mani anɨbu udem, sɨkim gɨ ado malo gɨ damem, paip dausan mani sinɨŋ udpin me i,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hagö, bɨ kub u pen hagnab, ‘Aij göp. Ne wög gɨ ñeb bɨ aij. Ne yɨp wög gɨ aij gɨ ñɨban u me, anɨg gɨpan. Ne nan pro u anɨg gɨ aij gɨpan u, nöp hagnö, nan kub gau abad mɨdeinabön. Ne apön, ram yad u mɨñ mɨñ yabɨƚ göl gɨ mɨdaimön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Bɨ mani du dausan udnab u, u rö nöp mani nɨpe u dap ñöm hagnab, ‘Bɨ kub. Yɨp du dausan nöp ñɨna pen yad mani anɨbu udem, sɨkim gɨ ado malo gɨ damem, du dausan mani sinɨŋ udpin me i,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hagö, bɨ kub u hagnab, ‘Aij göp. Ne wög gɨ ñeb bɨ aij. Ne yɨp wög gɨ aij gɨ ñɨban u me, anɨg gɨpan. Ne nan pro u anɨg gɨ aij gɨpan u, nöp hagnö, nan kub gau abad mɨdeinabön. Ne apön, ram yad u mɨñ mɨñ yabɨƚ göl gɨ mɨdaimön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pen bɨ mani wan dausan udnab u, mani nɨpe u dap ñöm hagnab, ‘Bɨ kub. Yad nöp nɨŋbin; ne bɨ kal yabɨƚ. Nɨbi bɨ ne rɨmnap wög waryö kale gɨpal gau, ne yɨharɨŋ hal dapön ñɨŋban. ");
INSERT INTO kpw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ne anɨg gɨpan rö, yad pɨñɨŋ gem, mani ñɨna u damem, uƚöm udem mɨnöŋ ñɨnö mɨdmɨdöp u, mɨñi mani ne dap ñabin me i,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hagö, bɨ kub u hagnab, ‘Ne bɨ naij wög gagep ap. Nɨbi bɨ yɨp wög waryö gɨpal gau, nan yɨharɨŋ hal dapem ñɨŋbin, a gɨpan ar? ");
INSERT INTO kpw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Anɨb u, ne mani yɨp i dam beg pasbuk lɨbnap, mɨñi yad apem mani sinɨŋ rɨmnap halö yɨharɨŋ udbnep,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Anɨg hagöm, bɨ nɨpe rɨmnap kalɨp hagnab, ‘Anɨg göp u, mani wan dausan anɨbu ju udmim, bɨ den dausan mɨdöp u nɨp ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pör hagpun rö, nɨbi bɨ gep gau, kalɨp rɨmnap halö ñɨlö udöm mɨd aij gɨnaböl; pen nɨbi bɨ gep wasö gau, nan pro kale mɨdöp u pɨƚɨ gɨ udlö, yɨharɨŋ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Anɨb u, bɨ wög gagöp anɨbu nɨp dam sɨbön kub auöp höŋ adö au yaŋ yube, nɨbi bɨ meg hau rɨbɨköm, mɨɫöŋ gɨ mɨdpal gau aip mɨdeiaŋ,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Bɨ Ñɨ nɨpe Kiŋ kub mɨdöm, mailö aij unbö ke halö aunab ñɨn u, ejol gau magöŋhalö aip apöm, sea Kiŋ nɨpe asɨk mɨdep adö u asɨkö, ");
INSERT INTO kpw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","nɨbi bɨ ram mɨnöŋ ke gau gau mɨdpal rö magöŋhalö apöm, amgö ilö nɨp au magum gɨlö nɨŋöl gɨ, kalɨp nɨme lɨ böŋ u ke löm, böŋ u ke löm gɨnab. Bɨ kaj sipsip kaj meme mukep bɨ gau, kaj sipsip gau mɨgan ap ke yuöm, kaj meme gau mɨgan ap ke yuöm gɨpal rö u gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nɨbi bɨ kaj sipsip rö mɨdpal gau nɨŋöm, ñɨmagö yɨjɨg böŋ lau lɨnab; nɨbi bɨ kaj meme rö mɨdpal gau nɨŋöm, ñɨmagö sɨdagö böŋ lau lɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nɨpe Kiŋ kub u me, nɨbi bɨ ñɨmagö yɨjɨg böŋ lau kalɨp hagnab, ‘Bapi kalöp ud aij göp u me, mɨñ mɨñ gɨmim. Nɨpe ram mɨnöŋ hadame dagol gau gɨ la ñɨn u, ka kalöp u gɨ la. Apim, ka aij anɨbu udim. ");
INSERT INTO kpw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pen nɨhön: yɨp kɨyö lö, nan magö ñɨbim. Yɨp ñɨg nan gö, ñɨg ñɨbim. Yad ram mɨnöŋ mɨlö gau nɨbö aunö, yɨp hag udmim, dam ram kale u lɨbim. ");
INSERT INTO kpw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yad waƚɨj mɨdagö, yɨp waƚɨj u ñɨbim. Yad nan gö, yɨp gɨ aij gɨpim. Nagɨ mɨdainö, yɨp am nɨŋbim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Anɨg hageinab, nɨbi bɨ aij gau nɨp pen hagnaböl, ‘Bɨ Kub. Magö mai nöp kɨyö lö nan magö ñɨbun? Magö mai ñɨg nan gö, nöp ñɨg ñɨbun? ");
INSERT INTO kpw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Magö mai ne bɨ mɨlö gau nɨbö rö auö, nöp hag udun dam ram hon u lɨbun? Magö mai waƚɨj u mɨdagö, nöp waƚɨj ñɨbun? ");
INSERT INTO kpw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Magö mai ne nan ga aka ne nagɨ mɨdaina, nöp am nɨŋbun?’ ö gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Hageinaböl, Kiŋ u hagnab, ‘Mam yad yɨharɨŋ ap gɨ aij gɨpim u me, yɨp gɨ aij gɨpim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kalɨp anɨg hagöm, nɨbi bɨ ñɨmagö sɨdagö böŋ lau mɨdeinaböl gau, kalɨp hagnab, ‘God kalöp nɨŋöm gasɨ naij nɨŋab. Nɨpe Seden nɨp abe, Seden ejol nɨpe gau abe, kalɨp ilön gö nɨŋöl gɨ mɨdeilaŋ, a göm, ka mab ke inab ap gɨ la. Kale nɨbi bɨ naij, ilön kub udnabim gau, yɨp arö gɨmim, mab ke inab ka anɨbu arim. ");
INSERT INTO kpw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nɨhön gɨnɨg: yɨp kɨyö lö, nan magö ñagpe. Yɨp ñɨg nan gö, ñɨg ñagpe. ");
INSERT INTO kpw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yad mɨlö gau nɨbö aunö, yɨp hag udmim, dam ram kale u lagpe. Yad waƚɨj mɨdagö, yɨp waƚɨj ñagpe. Yad nan ga ñɨn u, aka nagɨ mɨdainö ñɨn u, yɨp ap nɨŋmim gɨ aij gagpe,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hageinab, nɨp hagnaböl, ‘Bɨ Kub. Ñɨn mai ne kɨyö mɨdaina, nan magö ñagnoŋ Ñɨn mai ne ñɨg nan gö, ñɨg ñagnoŋ Ñɨn mai ne mɨlö gau nɨbö auö, nöp hag udagnoŋ Ñɨn mai ne waƚɨj mɨdagö, nöp ñagnoŋ Ñɨn mai ne nan ga aka nagɨ mɨdaina, nöp am nɨŋun gɨ aij gagno?’ ö gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Anɨg hageinaböl, Kiŋ u hagnab, ‘Yad kale nɨŋö hagabin, kale mam yad yɨharɨŋ ap gɨ aij gagpim u me, yɨp u rö nöp gɨ aij gagpim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Anɨg hagöm, kalɨp hag yuö amöm, pör nöp ilön gö nɨŋöl gɨ mɨdeinaböl ka u arnaböl; pen nɨbi bɨ aij nɨpe gau hagö, kale amöm, pör nöp pör nöp kamɨŋ mɨdep ram mɨnöŋ au arnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas manö anɨbu hagöm, bɨ nɨpe unbö mɨgan laŋ gau kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kale nɨŋbim, ñɨn mɨhöp mɨdöm, Pasopa ñɨn kub u mɨñi, a göm, ap magum göm yɨharɨŋ mɨdeinaböl. Pen kale anɨg göl ap magum göm, yɨp Bɨ Ñɨ nɨpe u, ud gapman bɨ kub gau kalɨp ñöm hagnaböl, ‘Nɨp mab ba laŋ al pak lɨmim,’ a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pen God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe apöm bɨ God nɨp nan sabe gep bɨ kub yabɨƚ Kaiapas ram kub nɨpe u magum göm, ");
INSERT INTO kpw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jisas nɨp ai göl gun, agamɨj ud sɨsɨ lun, al pak lɨnabun, a göm, manö hag lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pen kale hagla, “Pasopa nan ñɨŋeb yɨharɨŋ mɨdep ñɨn i, hon anɨg gɨno, nɨbi bɨ iru nöp mɨdpal gai i pen pen göl rö löp. Anɨb u, mɨñi arö gun, ñɨn ap nɨp al pak lun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jisas ram rɨƚɨg agƚö Bedani am mɨdöm, Saimon bɨ wös hapeb nöd la u ram nɨpe u am nan ñɨŋeila. Nan ñɨŋlö nɨŋöl gɨ, nɨbi ap wel haƚɨŋ aij auep, mani kub raubal u, barol halö dapöm, Jisas nabɨc cög adö u hoŋ ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Hoŋ gö, Jisas bɨ nɨpe gau nɨŋlö, hibur kale u naij gö, hagla, “Wel anɨbu damöm mani kub udöm, nɨbi bɨ nan mɨdagöp gau kalɨp ñeb rö u, pen nɨhön gɨnɨg anɨg göl yɨharɨŋ hoŋ göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Manö anɨbu hageila, Jisas ke nɨŋöm, kalɨp haga, “Nɨbi anɨbi nɨpe yɨp gɨ aij yabɨƚ göp u, nɨhön gɨnɨg anɨg hagabim? ");
INSERT INTO kpw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nɨbi bɨ nan mɨdagöp gau aip pör mɨdeinabim, pen yad aip pör mɨdageinabun. ");
INSERT INTO kpw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nɨbi bɨ umlö, wip rɨgöl gɨnɨg, wel lɨ ñöm dam rɨgöl gɨpal. Yɨp rɨgöl gɨnɨg gaböl u me, nɨpe wel anɨbu hañ romaŋ yɨp lɨ ñöb. ");
INSERT INTO kpw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pen yad kalöp nɨŋö hagabin, hainö ram mɨnöŋ iƚ i ke gau gau magöŋhalö, manö aij yad u hagöl gɨ, nɨbi anɨbi anɨg gajɨp u aiud udöl gɨ, ga anɨbu hauƚ gagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ñɨn anɨbu, Jisas bɨ nɨpe Judas Iskariod, Jisas nɨp kain gɨ dam ñɨnö al pak löl a göm, God nɨp nan sabe gep bɨ kub gau kalɨp hagnɨg ara. Amöm haga, “Yad Jisas nɨp kain gɨ dapem kalöp ñeinabin u, yɨp nan nɨhön ñɨnabim?” ö ga. Hagö, nɨp silpa magö ñɨn juöl añɨ ap ado gɨ da unbö sɨduŋ laŋ (30) ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ñeila, Judas nɨpe, “Yad ai göl gem Jisas nɨp mumug gɨnö, nɨp ud sɨsɨ löm ud aröl,” a göm, gasɨ u nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hainö nan ñɨŋeb kub Bred Yɨs Mɨdagöp a gɨmɨdal ñɨn u iƚ gö, ñɨn wañɨgnɨbö u nöp, bɨ nɨpe gau Jisas mɨdeia u apöm hagla, “Pasopa sipsip pi pak ñɨŋnabun ñɨn u söl mɨdöp. Anɨb u, hon ram mai amun nan ñɨŋnabun gau gɨ lɨ aij gun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hageila, kalɨp haga, “Kale daun kub u ammim, bɨ ap mɨdöp au ram nɨpe ammim nɨp hagmim, ‘Manö hag ñeb bɨ hagöp, “Ñɨn yad u söl mɨdöp u me, bɨ yad gau aip kaj sipsip pi pak lau ñɨŋnabun ram ne u,” a göp,’ a gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisas anɨg hagö, bɨ nɨpe gau haga rö nɨŋöm, amöm kaj sipsip anɨbu ram anɨbu pak lauöm, gɨ lɨ aij geila. ");
INSERT INTO kpw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dugo magö u, bɨ nɨpe unbö mɨgan laŋ gau aip asɨköm, ");
INSERT INTO kpw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","nan ñɨŋöl gɨ haga, “Yad kalöp nɨŋö hagabin, bɨ hon aip nan ñɨŋabun i, ap yɨp kain gɨ dam arnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hageia, bɨ nɨpe gau gasɨ mɨlö löm, añɨ añɨ nɨp hag nɨŋöl gɨ hagla, “Bɨ Kub! Yad hagpan aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hageila haga, “Bɨ yad aip kɨnaŋ mɨgan añɨ ñɨŋabul i, yɨp kain gɨ dam arnab. ");
INSERT INTO kpw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God Manö u hadame nöp kalɨ kƚiñ rɨköm hagla rö, yɨp kain gɨ damöm, al pak lɨlö umnabin u, pen bɨ yɨp kain gɨ dam arnab u, God bɨ anɨbu nɨp gɨ naij gɨnab. Nɨme nɨp yag dauagböp u aij. Pen yag dauö, mɨdöl gɨ anɨg gɨnab u, hainö ilön kub yabɨƚ udnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hageia, bɨ nɨpe Judas, nɨp kain gɨnɨg ga u haga, “Manö hag ñeb bɨ. Yɨp hagagpan aka?” ga. Hageia haga, “Me nöp hagabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nan ñɨŋ mɨdöl gɨ, Jisas bred udöm, God nɨp aij a göm, ud jö göm, bɨ nɨpe gau kalɨp ñöl gɨ haga, “Kale ud ñɨŋim. U hañ romaŋ yad,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Anɨg hagöm, ñɨg wain kap u, u rö nöp udöm, God nɨp aij a göm, kalɨp ñöl gɨ haga, “Kale magöŋhalö ñɨŋim. ");
INSERT INTO kpw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","U hagape yad lugnab u nöp. Lugö, God hadame gau haga manö u pɨdöŋ arnab. Lugö, nɨbi bɨ iru nöp nan si nan naij gɨpal gau, God nɨŋöm arö gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anɨg hagöm haga, “Yad kalöp nɨŋö hagabin, ñɨg wain i mɨñi rɨmnap halö ñɨŋagnabin. Hainö, God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab ñɨn u nöp, yad kauyaŋ kale aip ñɨg wain u ñɨŋnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Anɨg hagöm, bɨ nɨpe gau aip God hib dap raneb kɨmap ap hagöl gɨ, Olip Dum arla. ");
INSERT INTO kpw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘Yad bɨ kaj sipsip mukep u nɨp pak lɨnö, kaj sipsip nɨpe gau magöŋhalö pɨñɨŋ gɨ arnaböl,’ a gɨla. Hagla anɨbu me, mɨdö sɨbön aŋ yaŋ kale magöŋhalö yɨp arö gɨmim, pɨñɨŋ gɨ arnabim. ");
INSERT INTO kpw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pen yad umem urakem, ram mɨnöŋ Galili nöd areinabin, kale hain nɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hageia, Pida haga, “Bɨ magöŋhalö nöp arö göm, jöl ñɨnaböl rö löp, pen yad anɨg gagnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hageia, Jisas haga, “Yad nöp manö nɨŋö hagabin, sɨbön aŋ yaŋ yaur kɨƚakɨƚ wɨñ alagnab magö u, ‘Jisas nɨp nɨŋagpin,’ a gɨmön, magö mɨhau nɨgaŋ hagnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hageia, Pida kƚö yabɨƚ göm haga, “Yɨp al pak lɨnɨg, al pak lɨnaböl u pen, ‘Jisas bɨ yad wasö,’ gem hagagnabin,” a ga. Jisas bɨ nɨpe magöŋhalö u rö nöp Pida haga rö nöp hagla. ");
INSERT INTO kpw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas bɨ nɨpe gau aip mab wög adɨŋ Gedsemani amöm, bɨ nɨpe rɨmnap kalɨp haga, “Kale aui asɨk mɨdaimim. Yad au daŋ amem, Bapi nɨp sabe göl gɨ mɨdeinabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Anɨg hagöm, Pida aip, Sebedi ñɨ nɨpe mɨhöp Jems Jon aip kalɨp uɫ gɨ ara. Amöl gɨ, Jisas nɨpe gasɨ mɨlö löm, ");
INSERT INTO kpw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kalɨp yam haga, “Mɨdmagö yɨp u bɨg ñöl nöp löp u, umnam rö löp. Kale aui mɨdmim, yɨp abad mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Anɨg hagöm, kalɨp anɨb au hag löm, nɨpe yöp söl dagol au amöm, ubör yɨhöŋ göm, mulu adɨŋ u ud mɨnöŋ yaŋ löm, God nɨp sabe göm haga, “Bapi, nan yɨp gɨnɨg gab anɨbu, wasö gɨnɨg, wasö gɨmön. Pen yad gasɨ nɨŋbin adö u gagmön; gasɨ ne ke nɨŋban adö u rö gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anɨg hagöm, ado gɨ apöm nɨŋa, bɨ nɨpe gau hon haneila. Jisas Pida nɨp haga, “Kale magö añɨ ap nöp yɨp abad mɨdagim ar? ");
INSERT INTO kpw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nan naij gun rö löp, a gɨmim, God nɨp sabe göl gɨ mɨdaimim. Gasɨ kale u gɨmim rö löp u pen hañ romaŋ u nöp masös göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas anɨg hagöm, kauyaŋ am Nap nɨp sabe göm haga, “Nan yɨp gɨnɨg gö ilön udnabin u, arö gep rö mɨdagöp u, haƚöwaƚö gaŋ; gasɨ ne ke nɨŋban adö u rö gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Anɨg hagöm, kauyaŋ ado gɨ apöm nɨŋa, bɨ nɨpe gau amgö nɨŋ mɨdageila; hon haneila. ");
INSERT INTO kpw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pen nɨpe ado gɨ amöm, Nap nɨp nöd sabe ga rö nöp, kauyaŋ sabe göm, ");
INSERT INTO kpw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ado gɨ apöm, bɨ nɨpe gau kalɨp haga, “Kale masös gö, han mɨdpim arŋ Bɨ gau me, nɨŋim! Bɨ yɨp kain göm, Bɨ Ñɨ nɨpe, bɨ nan si nan naij gɨpal gau kalɨp ñɨnɨg gab. ");
INSERT INTO kpw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Urakpe arun! Nɨŋim! Bɨ kain göp bɨ auab i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas manö hagö nɨŋöl gɨ, bɨ nɨpe unbö mɨgan laŋ ap, Judas, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, nɨp hagla rö, bɨ kale iru nöp dapöm apjaka. Kale ru mɨlö kɨd rɨmnap, ur pakep rɨmnap udöm, aula. ");
INSERT INTO kpw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas nöd kalɨp hag löm haga, “Yad bɨ ap nɨp am hag wɨhai udem, ud bom haluem, mulu ñɨŋeinam u, bɨ u me, a gɨmim, nɨp ud sɨsɨ lɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pen Judas nɨpe Jisas mɨdeia au yɨŋɨd nöp apjaköm, “Manö hag ñeb bɨ, ne mɨdpan?” a göm, nɨp mulu ñɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Anɨg gö, Jisas haga, “Bɨ me. Nan gɨnɨg gabön u yɨŋɨd gɨ!” a ga. Hagö, bɨ Judas aip aula gau Jisas nɨp ud sɨsɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisas ud sɨsɨ lɨlö nɨŋöl gɨ, Jisas bɨ nɨpe ap ru mɨlö kɨd nɨpe u ud ɫɨp gɨ udöm, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u wög nɨp gɨmɨdöp bɨ u, nɨp rɨmɨd böŋ lap u böŋ nöp rɨb gɨ dö gɨ yua. ");
INSERT INTO kpw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Anɨg gö, Jisas nɨp haga, “Ru mɨlö kɨd udpan u ado gɨ lɨ mɨgan yuö lugaŋ. Nɨbi bɨ ru mɨlö kɨd udöm pen pen gɨnaböl gau, adö anɨbu nöp umnaböl. ");
INSERT INTO kpw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yad ‘Bapi ake!’ gaibnep, nɨpe yɨŋɨd nöp ejol yam ke ke unbö mɨgan laŋ rö hag yuö, apöm yɨp abad mɨdaiblap. ");
INSERT INTO kpw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pen hadame nöp God Manö u kalɨ kƚiñ rɨköm, yɨp anɨg anɨg göm umnab a gɨla u me, anɨg gɨnɨm. Yad adö ap ke geinabin u, kabö rö gagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pen bɨ nɨp udnɨg aula anɨb gau kalɨp haga, “Yad pör am God sabe gep ram u asɨkem, nɨbi bɨ gau kalɨp manö hag ñɨbin u pen yɨp udagpim. Mɨñi pen, ru mɨlö kɨd halö, ur pakep halö dapim, bɨ nan si udep rö u yɨp udnɨg auabim. ");
INSERT INTO kpw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kale gabim anɨbu, God manö hagep bɨ gau God Manö kalɨ kƚiñ rɨköm hagla rö nöp gabim,” a ga. Pen magö anɨbu, Jisas bɨ nɨpe gau magöŋhalö nɨp arö göm pɨñɨŋ gɨ arla. ");
INSERT INTO kpw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pen God lo manö hag ñeb bɨ gau abe, bɨ manö ud asɨkep gau abe, ap magum gɨ mɨdeila bɨ Kaiapas God nɨp nan sabe gep bɨ kub yabɨƚ u ram nɨpe au me, Jisas nɨp ud sɨsɨ löm, dam ram anɨbu arla. ");
INSERT INTO kpw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pen Pida nɨpe hain hain amöm, ram höŋ adö u mɨdöm, God sabe gep ram polisman gau aip asɨköm, nɨhön rö gɨnaböl a göm, nɨŋ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bɨ God nɨp nan sabe gep bɨ kub gau abe, Juda Kansol kub bɨ gau abe hagla, “Hon bɨ manö piral hagep bɨ rɨmnap kalɨp hag nɨŋno, kale manö ap haglö, kabö göl mɨdö, manö iƚ me u, a gun, Jisas nɨp al pak lun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Anɨg hagla u pen manö anɨbu ke ke arö, Jisas nɨp al pak lep iƚ ap mɨdageia. Anɨg ga u pen hainö bɨ mɨhöp apil haglö, ");
INSERT INTO kpw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bɨ anɨbi haga, ‘God sabe gep ram u ud jö gɨ yuem, mɨdö ñɨn mɨhau nɨgaŋ kauyaŋ gɨ lɨnabin,’ a ga,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anɨg hagailö, God nɨp nan sabe gep bɨ kub yabɨƚ u, Jisas nɨp haga, “Manö nöp hagabil u, ne pen ap hagagnabön ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hageia, Jisas pen manö ap hagaga. Anɨg gö, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u haga, “Mɨñi manö kub hagnɨg mɨdpun i, manö piral hagagmön. God pör kamɨŋ mɨdöp u, u rö nöp nɨŋ mɨdöp. Anɨb u, hanɨp kabö göl hagmön: ne Mesaia u, God Ñɨ nɨpe aka wasö?” ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hageia, Jisas haga, “Me hagpan u. Pen kale magöŋhalö nɨŋim! Yad kalöp hagabin, yad Bɨ Kub kƚö ke yabɨƚ u ñɨmagö yɨjɨg böŋ nɨpe lau adö mɨdem, kumi bad adö au amem mɨnöŋ naböŋ iƚ i aueinabin u nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas anɨg hagö, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u, waƚɨj nɨpe gau ke ud bɨƚɨƚɨ göl gɨ haga, “Nɨpe God hib u rɨb juajɨp nɨŋbim! Anɨb u, nɨbi bɨ rɨmnap hag nɨŋagun. Nɨpe gɨ naij göp u waiö hagöp me u. ");
INSERT INTO kpw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aka kale gasɨ nɨhön nɨŋabim?” ö ga. Hageia hagla, “Me hagöp me u; umaŋ añɨ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anɨg hagöm, mulu maj mɨgan nɨp u kɨñu al ñöm, paköl gɨ gɨla. Rɨmnap Jisas amgö magö nɨpe paƚu gɨ ñöm, alaun nɨpe gau paköl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hagla, “Ne Mesaia u, an nöp pakab u, hanɨp hagö nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pen Pida manö kub hagep ram höŋ adö yaŋ asɨk mɨdeia u me, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u nɨp wög gɨmɨdöp pai ap apöm, nɨp haga, “Ne Jisas bɨ Galili nɨbö u aip mɨdajɨl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hagö, Pida nɨbi bɨ gau magöŋhalö nɨŋ mɨdlö nɨŋöl gɨ, haga, “Manö ne hagabön u yad nɨŋagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Anɨg hagöm, uraköm, am ajöŋ iƚ au mɨdö nɨŋöl gɨ, nɨbi ram anɨbu wög gɨmɨdöp ap apöm, Pida nɨp nɨŋöm, nɨbi bɨ mɨdeila gau kalɨp haga, “Nɨpe bɨ Jisas Nasared nɨbö u aip mɨdailö nɨŋbin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hagö, Pida wai ñöm haga, “Yad nɨŋö yabɨƚ hagabin, bɨ hagpim anɨbu yad nɨŋagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pro magö ap mɨdöm, nɨbi bɨ Pida aip urak mɨdeila gau nɨp hagla, “Nɨŋö nöp hagpun. Ne bɨ kale ap. Meg mɨgan kale hagpal rö, ne u rö nöp hagpan,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hageila, Pida bƚaƚö göm haga, “Yad kalöp nɨŋö yabɨƚ hagabin. Wasö u, God yɨp ilön mab ñɨnɨm aij. Bɨ kale hagpim anɨbu yad nɨŋagpin!” a ga. Anɨg hagö nɨŋöl gɨ, adɨŋ yaur kɨƚakɨƚ u wɨñ ala. ");
INSERT INTO kpw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kɨƚakɨƚ u wɨñ alö, Pida Jisas manö nɨp nöd haga anɨbu gasɨ nɨŋöm, gasɨ mɨlö la. Nɨhön gɨnɨg: Jisas haga, “Yaur kɨƚakɨƚ wɨñ alagnab magö u, ‘Jisas nɨp nɨŋagpin,’ a gɨmön, magö mɨhau nɨgaŋ hagnabön,” a ga. Gasɨ anɨbu nɨŋöm me, gasɨ mɨlö löm, höŋ amöm, mɨɫöŋ kub ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ram gɨsön rɨka nɨŋöm, God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, manö hag nɨŋ hag nɨŋ göm, manö hag adö añɨ löm, Jisas nɨp al pak lun, a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Anɨb u, Jisas nɨp nagɨ löm, damöm gapman bɨ kub gapna Pailod nɨp ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pen Jisas nɨp manö kub hagöm, al pak lɨnɨg geila nɨŋöm, Judas, nɨhön gɨnɨg Jisas nɨp mumug nɨŋbin, a göm, mani uda u, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, kalɨp ju dam ñɨnɨg göm, God sabe gep ram u ara. ");
INSERT INTO kpw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amöm, mani anɨb gau kalɨp ñöl gɨ haga, “Jisas naij gagöp u pen yad nɨp mumug nɨŋbin u, mɨdö umnab. Anɨb u, yad nan si nan naij gɨpin,” a ga. Hageia, kale hagla, “U nan hon wasö. Ne ke nöp anɨg gɨpan,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hageila, Judas mani ñɨla anɨbu God sabe gep ram raul u ud yuöm, am nagɨ ñɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɨ God nɨp nan sabe gep bɨ kub gau, mani anɨbu udöm hagla, “Mani anɨbi, bɨ al pak lun, a gun, mumug gɨno u me, God nɨp ñun rö lagöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Anɨg hagöm, manö hag nɨŋ hag nɨŋ göm hagla, “Bɨ mɨlö gau nɨbö apöm umlö, dam rɨgöl gun u, mɨnöŋ naböŋ mɨgan ap rauun,” a göm, am bɨ ap mɨnöŋ udöm rin cög gɨmɨdöp mɨnöŋ naböŋ mɨgan anɨbu raula. ");
INSERT INTO kpw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mɨnöŋ naböŋ mɨgan anɨbu, mumug bɨg ñɨla mani u udöm raula u me, hainö nɨbi bɨ mɨnöŋ naböŋ mɨgan anɨbu, hib “Mɨnöŋ Mɨgan Hagape Halö” a gɨla. Mɨñi u rö nöp mɨnöŋ naböŋ mɨgan anɨbu, hib “Mɨnöŋ Mɨgan Hagape Halö” a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pen kale mɨnöŋ naböŋ raula anɨbu, bɨ God manö hagep Jeremaia nöd hagöm kalɨ kƚiñ rɨka rö nöp gɨla. Nɨpe God Manö u adɨŋ ap kalɨ kƚiñ rɨköm haga, “Kale mani silpa ñɨn juöl añɨ ap ado gɨ da unbö sɨduŋ laŋ (30) u, Juda nɨbi bɨ hagla mani u yag damöm, ");
INSERT INTO kpw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bɨ mɨnöŋ udöm rin cög gɨmɨdöp mɨnöŋ naböŋ mɨgan anɨbu raula. Bɨ Kub yɨp haga rö nöp gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas nɨp damöm, gapman bɨ kub Pailod mɨdeia au arlö nɨŋöl gɨ, Pailod Jisas nɨp haga, “Ne Juda kai kiŋ kub kale mɨdpan aka?” ga. Hageia, Jisas haga, “Me hagpan me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pen bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, nɨp manö rɨmnap hageila, nɨpe pen manö ap hagaga. ");
INSERT INTO kpw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Anɨg gö, gapman bɨ kub Pailod haga, “Manö pen pen hagöm, manö ke ke hagaböl u, nɨŋagan ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hageia, Jisas manö pen ap hagagö, Pailod gasɨ iru yabɨƚ nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Pen Pailod nɨpe bɨ kub manö ud asɨkep sea adö u asɨk mɨdö nɨŋöl gɨ, nɨbin manö ap hagö, auö haga, “Yad mɨdö nöp sɨbön yaŋ uhön nɨŋbin, bɨ manö kub hagabön bɨ u bɨ aij. Nɨp manö kƚö hagagmön. Yad uhön nɨŋbin anɨbu, gasɨ iru yabɨƚ nɨŋabin,” a ga. Pen Pailod gasɨ nɨpe ke gau nöp nɨŋa, Jisas nan ap gaga; bɨ kub gau nöp nɨp nɨŋlö mulu lugöp daubal. Anɨb u, yad aigöl gem, nɨp hag yuö araŋ, a göm, gasɨ u nɨŋa. Pen Rom gapna bɨ kub u pör mɨ u mɨ u Juda kai Pasopa ñɨn kub u, kalɨp bɨ nagɨman kale ke hag nɨŋmɨdal u, yɨharɨŋ hubɨk yumɨdöp. Ñɨn anɨbu, bɨ naij yabɨƚ ap nagɨ mɨdeia; hib nɨpe u Barabas. Nɨbi bɨ iru nöp ap magum geila gau, Pailod kalɨp haga, “Kalöp bɨ mai yɨharɨŋ hag yunamŋ Jisas, Mesaia u a gɨpal u aka Barabas nɨp hag yunam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hagö, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, nɨbi bɨ gau kalɨp hagla, “Kale Pailod nɨp hagmim, Barabas nɨp hubɨk yuöm, Jisas nɨp al pak lɨlaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pen Pailod nɨbi bɨ ap magum gɨ mɨdeila gau kalɨp haga, “Bɨ mɨhai i, bɨ an nɨp hubɨk yunam?” ö ga. Hageia hagla, “Barabas nɨp hubɨk yumön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hageila, Pailod haga, “Anɨg hagpim u, Jisas Mesaia u a gɨpal u, nɨp nɨhön gɨnam?” ö ga. Hageia, kale magöŋhalö hagla, “Nɨp mab ba laŋ al pak lɨlaŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hageila, Pailod haga, “Pen nɨhön? Nɨpe nan nɨhön nan gɨ naij göp?” ö ga. Hagö, manö haga u nɨŋagöm, manö dap ranöm hagla, “Nɨp mab ba laŋ al pak lɨlaŋ! Nɨp mab ba laŋ al pak lɨlaŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hageila, Pailod gasɨ nɨŋa, manö yad udagnaböl; pen manö rɨmnap halö kalɨp hag ñɨnö, pen pen paköl rö löp, a gɨ gasɨ nɨŋa. Anɨg nɨŋöm, nɨbi bɨ gau amgö ilö kale gau, ñɨg udöm ñɨmagö ñɨg lɨ lɨ göm, kalɨp haga, “Bɨ anɨbi nɨp al pak lɨnɨg gabim u, manö anɨbu yɨp auagnab; kale ke ado gɨ aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hageia, nɨbi bɨ gau magöŋhalö hagla, “U wip nabɨc hon ke! Hagape nɨpe hanɨp apöm, ñɨ hon gau arnab! Manö anɨbu, hon abe, ñɨ pai hon gau abe aunab!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anɨg hageila, Pailod kalɨp Barabas nɨp hubɨk yuöm, Jisas nɨp ami bɨ nɨpe gau ña nɨŋöm kale nagɨ ud Jisas pakla. Anɨg gɨlö, Pailod nɨpe Jisas nɨp mab ba laŋ al pak löl, a göm, ami bɨ nɨpe gau kalɨp ña. ");
INSERT INTO kpw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gapna Pailod ami bɨ nɨpe gau, Jisas nɨp udöm, dam ram kub kale u amöm, ami bɨ yɨharɨŋ gau kalɨp magöŋhalö wɨñ allö, ");
INSERT INTO kpw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ap magum göm, waƚɨj nɨp u ud juöm, waƚɨj aɫɨ, bɨ kub yɨmbal rö ap dapöm, nɨp yɨm ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yɨm ñöm, nagɨ kalɨ kalɨ halö gau dapöm, kiŋ kai rol gɨpal rö usajɨl bad ap göm, nɨp rol gɨ ñöm, bɨ kub gau ur udpal, a göm, gamɨƚ mɨlö ap ud Jisas nɨp ñɨmagö yɨjɨg u ñöm, apöm nɨp kugom yɨmöm, hag juöl gɨ hagla, “Bɨ kub ne auban? Juda kai kiŋ kale ne auban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Anɨg hagöm, nɨp kɨñu alöm, gamɨƚ mɨlö anɨbu ju udöm, nɨp nabɨc cög laŋ pakla. ");
INSERT INTO kpw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pen Jisas nɨp anɨg göl hag juöm, waƚɨj aɫɨ nɨp yɨm ñɨla u ud ju yuöm, waƚɨj nɨpe ke yɨm ñöm, nɨp mab ba laŋ al pak lɨnɨg, uɫ gɨ ud arla. ");
INSERT INTO kpw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Adan aŋ gau amöl gɨ nɨŋla, Sairini daun nɨbö bɨ ap aueia. Hib nɨpe u Saimon. Nɨp nable paköm, kƚö göm hagla, “Jisas nɨp al pak lɨnabun mab i ud aru,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Haglö, nɨpe udöl gɨ, ram mɨnöŋ Golgoda dum arla. Golgoda a gɨmɨdal u manö iƚ u, “Wip Nabɨc Cög Ij.” ");
INSERT INTO kpw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pen dum anɨbu amjaköm, ami bɨ gau ñɨg wain udöm, ñɨg asɨ ap udöm, halö ud ado malo göm, Jisas nɨp ñeila, pen nɨpe ñɨŋ nɨŋöm arö ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jisas nɨp mab ba laŋ al pak löm, waƚɨj nɨp gau nɨme lɨ ke ke udnɨg, sadu rö göm udla. ");
INSERT INTO kpw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Anɨg göm, Jisas nɨp mab ba laŋ al pak lɨla iƚ au asɨköm, abad nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisas nɨp al pak löm, mab ba laŋ kalɨ kƚiñ rɨkla: ");
INSERT INTO kpw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pen Jisas nɨp al pak löm, bɨ nan si udep mɨhau, ap böŋ lap, ap böŋ lap, al pak lɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Nɨbi bɨ adan majö ap ran ap lug geila gau, nabɨc cög gor mar göm, nɨp hag juöm hagla, “Ne God Ñɨ nɨpe rö! God sabe gep ram u ud waƚ gɨ yumön, ñɨn mɨhöp nɨgaŋ kauyaŋ gɨ lɨnabön u me, mab ba laŋ arö gɨmön lugö, hon nɨŋun!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɨ God nɨp nan sabe gep bɨ kub gau, bɨ lo manö hag ñeb bɨ gau, bɨ manö ud asɨkep gau, kale u rö nöp nɨp hag juöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nɨbi bɨ rɨmnap kalɨp gajɨp kamɨŋ arbal, pen nɨpe ke anɨg gɨnɨm rö lagöp. Isrel Kiŋ kub hon u, mab ba laŋ arö göm, mɨnöŋ iƚ i lugö, nɨŋö hagöp a gun, nɨp nɨŋ udun. ");
INSERT INTO kpw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nɨpe God nɨp nɨŋ udöm hagöp, ‘Yad God Ñɨ nɨpe,’ a göp. God nɨpe ke u rö nöp gasɨ nɨŋeinab u, mɨñi apöm, nɨp ud kamɨŋ yuaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨ nan si udep Jisas aip al pak lɨla mɨhau, kale u rö nöp, nɨp manö naij anɨbu rö nöp haglö. ");
INSERT INTO kpw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñɨn anɨbu sɨdö aŋ aulɨk magö u, sɨbön apöm, mɨd damöm sɨdö gamɨŋ ga magö u kauyaŋ mailö ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sɨdö gamɨŋ ga magö u, Jisas wɨñ kub al hagöm haga, “Eli, Eli, lama sabakdani,” a ga. Haga anɨbu, “God yad. God yad. Yɨp ai gɨnɨg arö gɨpan?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anɨg hagö, nɨbi bɨ rɨmnap söl anɨb au mɨdeila gau nɨŋöm hagla, “Bɨ anɨbi bɨ God manö hagep Ilaija nɨp wɨñ alab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Anɨg hagöm, bɨ ap am nan adɨŋ us hain rö bad ap ud dapöm, ñɨg wain asɨ u rauöm, gamɨƚ mɨlö ap udöm, abös alöm, ñɨnö ñɨŋaŋ a göm, ña. ");
INSERT INTO kpw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Anɨg göm ñö, bɨ rɨmnap hagla, “Arɨk! Agamɨj nɨŋ mɨdaiun. Ilaija apöm, nɨp ud kamɨŋ yunab aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pen Jisas kauyaŋ wɨñ kub al hagöm, ake bad mɨdeia u ur ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Magö anɨbu nöp, waƚɨj mɨlö kub God sabe gep ram raul mɨgan yaŋ, ajöŋ pak pɨƚ gɨla u, aŋ yaŋ pak bɨƚɨƚɨ göm lap ke lap ke ara. Anɨg gö nɨŋöl gɨ, munmon udöm, kabö gau pa bu göm, ");
INSERT INTO kpw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","wip kabö mɨgan rɨgöl göm pak pɨƚ gɨla gau, mɨgan hiɨköm, God nɨbi bɨ uɫ nɨpe nöd umla rɨgöl gɨla gau, iru nöp gö, kauyaŋ urakla. ");
INSERT INTO kpw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Uraköm, kabö mɨgan gau arɨk höŋ amöm, Jisas uraka ñɨn u kale daun kub uɫ Jerusalem areila, nɨbi bɨ iru nöp kalɨp waiö lɨlö nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pen munmon udöm, nɨhön nɨhön ga u nɨŋöm, ami bɨ kub u abe, bɨ nɨpe gau aip mɨdeila gau abe, kale anɨnɨn gö pɨñɨŋ göm, mɨdmagö kale arö nɨŋöl gɨ, kale hagla, “Yaue! Bɨ i nɨpe God Ñɨ nɨpe nɨŋö yabɨƚ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pen nɨbi iru nöp apöm, ke ke au mɨdöm, nɨŋ mɨdeila. Nɨbi anɨb gau Jisas nɨp gɨ ñɨnɨg Galili nɨbö aula. ");
INSERT INTO kpw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nɨbi mɨdeila anɨb gau ap Maria Magdala u, ap Jems aip Josep aip nɨme Maria u, ap Sebedi ñɨ nɨpe mɨhau nɨme u. ");
INSERT INTO kpw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Bɨ gep yabɨƚ ap, Josep, Arimadia daun nɨbö u, nɨpe Jisas bɨ nɨpe ap mɨdeia. Bɨ anɨbu, Jisas umöb nɨŋöm, dugo dugo magö u apöm, gapna Pailod nɨp, Jisas hañ romaŋ u udnam aka gö, Pailod yau a göm, bɨ nɨpe gau kalɨp hagö, Josep nɨp ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jisas hañ romaŋ nɨpe u Josep nɨp ñɨlö, nɨpe waƚɨj rud aij ap udöm, wip he mɨlö u magöŋhalö wam haluöm, ");
INSERT INTO kpw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","dam kabö mɨgan gɨsön nöp ap, yɨp rɨgöl gɨnaböl, a göm, ju ƚu lɨla mɨgan u rɨgöl göm, kabö haƚai kub ap ud gau ga gɨ dam ajöŋ pɨƚ göm ara. ");
INSERT INTO kpw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nɨbi mɨhöp mɨdailö, nɨbi ap Maria Magdala, nɨbi ap Maria ap. Nɨbi Maria mɨhau apil nɨŋ mɨdlö nɨŋöl gɨ, Josep anɨg göm rɨgöl ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas umö rɨgöl gɨla ñɨn anɨbu, God nɨp nan sabe gep bɨ kub gau abe, bɨ Perisi gau abe, God nɨp sabe gɨnɨg ñɨn u rol, a göm, nan gɨ dap jɨn gɨla. Pen ruö, God nɨp sabe gɨnɨg ñɨn kale u me, gapman bɨ kub Pailod mɨdeia au arla. ");
INSERT INTO kpw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Amöm hagla, “Bɨ kub. Bɨ piral hagep anɨbu haga, ‘Yad umem, ñɨn mɨhau nɨgaŋ u uraknabin,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anɨb u, ne bɨ rɨmnap hagö, ñɨn mɨhöp nɨgaŋ wip rɨgöl u abad mɨdaiöl. Wasö u, bɨ nɨpe gau apöm, wip he mɨlö u si udöm, nɨbi bɨ gau kalɨp piral hagöm hagnaböl, ‘Nɨpe kauyaŋ uraköp,’ a gɨnaböl. Anɨg gɨlö, Jisas nöd manö piral haga u nan pro; kale hainö manö piral hagnaböl u kub yabɨƚ gɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hageila, Pailod kalɨp haga, “Anɨb u, kale ami bɨ bad ap udmim, wip rɨgöl gɨla gau ammim, gasɨ kale ke nɨŋ aij gɨmim, wip rɨgöl kabö lɨ pɨdöŋ gɨpe, ami bɨ abad nɨŋ mɨdaiöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hagö, Juda bɨ kub anɨb gau amöm, ajöŋ pɨƚ gɨla kabö kub u urön rö göm, ami bɨ bad u haglö, anɨb au nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ruö ram rɨk da lö nɨŋöl gɨ, nɨbi mɨhau Maria Magdala abe Maria ap abe kale ammil, Jisas nɨp rɨgöl gɨla u nɨŋnɨg arlö. ");
INSERT INTO kpw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Magö anɨbu munmon kub yabɨƚ udö nɨŋöl gɨ, ejol ap kumi kabö adö laŋ nɨbö apöm, Jisas nɨp rɨgöl göm kabö haƚai pɨƚ gɨla u, ud ju ba u yuöm, adö anɨbu asɨka. ");
INSERT INTO kpw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ejol anɨbu, mulu adɨŋ nɨpe mɨmailö göl gɨ mɨdeia. Waƚɨj nɨpe u, rud aij yabɨƚ u la. ");
INSERT INTO kpw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pen ami bɨ nɨŋ mɨdeila gau, nɨp nɨŋöm, anɨnɨn gö pɨñɨŋ göm, gɨl gɨl göm, umöm rö mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pen ejol u nɨbi mɨhau kalɨp haga, “Pɨñɨŋ gagmil! Yad nɨŋbin, kale mɨhöŋ Jisas mab ba laŋ al pak lɨla u nɨp nɨŋ ajabil. ");
INSERT INTO kpw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nɨpe aui mɨdagöp. Nöd haga rö, mɨdö nöp kauyaŋ uraköm aröp. Pen kale apil, nɨp dam lɨla kuö adö u nɨŋmil, ");
INSERT INTO kpw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","yɨŋɨd ammil, bɨ nɨpe gau kalɨp hagmil, ‘Jisas kauyaŋ uraköm Galili arab. Kale bɨ nɨpe ammim nɨp anɨb gau nɨŋnabim,’ a gɨmil. Manö anɨbu nöp kalöp hag ñɨnɨg aubin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Anɨg hagö nɨŋmil, nɨbi mɨhau pɨñɨŋ gɨlö u pen mɨñ mɨñ göl gɨ, wip rɨgöl anɨbu yɨŋɨd arö göm, bɨ nɨpe gau kalɨp hagnɨg gɨ dö gɨ arlö. ");
INSERT INTO kpw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Adan aŋ gau arlö nɨŋöl gɨ, Jisas kalɨp mɨhöŋ nable paköm haga, “Kale mɨdpil?” a ga. Hagö, kalpe mɨhöŋ ap kugom yɨmmil, ma nɨpe pɨdöŋ udmil, hib nɨpe u haglö adö ara. ");
INSERT INTO kpw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas kalɨp mɨhöŋ haga, “Pɨñɨŋ gagmil! Kale ammil mam yad gau kalɨp hagmil, ‘Galili ammim Jisas nɨp nɨŋnabim,’ a gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɨbi mɨhau, adan aŋ gau arlö nɨŋöl gɨ, ami bɨ nɨŋ mɨdeila gau rɨmnap, daun kub waryö raul aŋ amöm, bɨ God nɨp nan sabe gep bɨ kub gau kalɨp, nɨhön nɨhön ga anɨbu magöŋhalö hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hag ñeila, bɨ God nɨp nan sabe gep bɨ kub gau amöm, bɨ manö ud asɨkep aip manö hag adö añɨ löm, ami bɨ anɨb gau kalɨp mani kub ñöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Kale manö i nöp hagmim, ‘Sɨb aŋ yaŋ hon hanajun magö u, bɨ nɨpe gau apöm, wip he mɨlö u si ud arbal,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Anɨg hagpe, gapna Pailod manö anɨbu nɨŋnab u, hon nɨp aip hagno, kalöp marö rɨmnap ñagnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Anɨg haglö, ami bɨ gau mani anɨbu udöm, amöm Juda bɨ kub anɨb gau hagla rö nöp gɨla. Kale pir alöm, Jisas wip he mɨlö nɨpe u, bɨ nɨpe gau si ud arbal, a geila manö u, mɨñi Juda nɨbi bɨ gau manö piral anɨbu nöp hagöl gɨ nöp mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas bɨ nɨpe unbö agɨp u Galili amöm, Jisas nöd haga dum u arla. ");
INSERT INTO kpw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amöm, Jisas nɨp nɨŋöm, hib nɨpe haglö adö ara. Pen bɨ nɨpe rɨmnap nɨŋöm dui göm hagla, “U Jisas aka bɨ unbö ke?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pen Jisas söl au apöm, kalɨp haga, “Bapi yɨp hagö, ram mɨnöŋ kumi kabö adö laŋ u abe, mɨnöŋ naböŋ iƚ i abe, yad magöŋhalö abadöl mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Anɨb u, kale ram mɨnöŋ gau magöŋhalö rɨgoŋ rɨgoŋ ammim, nɨbi bɨ ke ke gau magöŋhalö manö aij yad hag ñɨbe, kale yɨp nɨŋ udöm nɨbi bɨ yad mɨdöm yɨp hain göl. Anɨg gɨmim, Bap u, Ñɨ u, Ana Uɫ u hib hagmim, kalɨp ñɨg pak ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Anɨg gɨmim, yad kalöp gɨmim, a gem, manö nɨhön nɨhön hag ñɨbin u, kale u rö nöp manö anɨbu magöŋhalö kalɨp hag ñɨ aij gɨpe, magöŋhalö hain göl. Pen yad kalöp nɨŋö yabɨƚ hagabin, yad kalöp aip mɨdem, mɨd damem, mɨd damem, mɨnöŋ naböŋ iƚ i ur gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais, God Ñɨ nɨpe manö aij u hagnɨg gabin. ");
INSERT INTO kpw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God hadame nöp Ñɨ nɨpe Jisas Krais nɨp manö haga rö, bɨ God manö hagep Aisaia, manö anɨbu God Manö kalɨ kƚiñ rɨköm haga, “Nöŋ! Bɨ manö yad ud arep u, nöd hag yunö amöm, adan nöp u ƚɨk gɨ aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bɨ anɨbu, ram mɨnöŋ nɨbi bɨ iru mɨdagpal, ram mɨnöŋ kabö nöp mɨdöp aŋ au am mɨdöm, wɨñ alöm hagnab, ‘Bɨ Kub u auab! Adan sɨr gɨlaŋ gɨyaŋ gɨ mɨdainɨm gau, dum goƚ pɨƚu gɨ mɨdainɨm gau, bɨnɨg ral aij gɨmim,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","God manö hagep bɨ anɨbu nöd anɨg haga rö nöp me, Jon bɨ ñɨg pak ñeb u amöm, ram mɨnöŋ nɨbi bɨ iru mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ au mɨdö nɨŋöl gɨ, nɨbi bɨ gau aulö, kalɨp manö hag ñöm hagmɨdöp, “Nan si nan naij gɨpim gau, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨpe yad kalöp ñɨg pak ñɨnö, God nan si nan naij gɨpim gau nɨŋöm arö gɨnab,” a gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nɨpe anɨg hagö nɨŋöl gɨ, nɨbi bɨ ram mɨnöŋ Judia yöp anɨb gau mɨdeila gau abe, Jerusalem nɨbi bɨ mɨdeila gau abe, kale magöŋhalö manö nɨp u nɨŋnɨg arla. Amöm, nan si nan naij gɨmɨdal gau, hag waiö lɨlö, Jon kalɨp ñɨg Jodan aŋ au ñɨg pak ña. ");
INSERT INTO kpw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pen Jon waƚɨj nɨpe u, kaj kamel uŋ udöm gɨla waƚɨj ap yɨmöm, kaj kau hañ dip nagɨ aŋ u pɨg lɨmɨdöp. Nan ñɨŋeb nɨpe u, joŋ habƚadɨŋ u abe, bom ñɨg u abe ñɨŋmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nɨpe nɨbi bɨ gau kalɨp hagmɨdöp, “Bɨ yɨp hain auab u, nɨpe yad rö wasö; nɨpe bɨ kub yabɨƚ, yad bɨ pro. Yad nɨp nɨŋnö nable gɨnab. Yad am söl au kugom yɨmem ma rɨrup nɨpe u nagɨ hubɨknam rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yad kalöp ñɨg nöp pak ñabin u pen nɨpe apöm, kalöp Ana Uɫ u nöp pak ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pen ñɨn ap, Jisas Nasared daun, ram mɨnöŋ Galili mɨdmɨdöp u arö göm, Jon mɨdeia au auö, Jon Jisas nɨp ñɨg Jodan aŋ au ñɨg pak ña. ");
INSERT INTO kpw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɨp ñɨg pak ñö, Jisas ñɨg goƚ au laŋ amöm nɨŋa, kumi kabö adö laŋ pɨral hiɨkö, God Ana u yaur dapo rö, Jisas nɨp u gɨ aua. ");
INSERT INTO kpw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Anɨg göl u gɨ auö nɨŋöl gɨ, manö ap kumi kabö adö laŋ au nɨbö apöm haga, “Ne Ñɨ mɨdmagö yad yabɨƚ. Nöp nɨŋnö, yɨp aij yabɨƚ göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pen magö anɨbu nöp, God Ana u Jisas nɨp hag yuö, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau amöm, ");
INSERT INTO kpw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ñɨn unbö ñɨn juöl mɨhöp (40) au mɨdeia. Anɨb gau mɨdö nɨŋöl gɨ, Seden, “Jisas nɨp gɨnö, manö yɨp u hain göm, naij gaŋ,” a göm, apöm hagmɨdöp. Ram mɨnöŋ mɨdmɨdöp mɨgan anɨbu ke kain nan gau nöp mɨdmɨdöp. Pen ejol gau apöm, Jisas nɨp abad mɨdmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pen hainö gapman bɨ kub Herod Jon nɨp nagɨ la nɨŋöm Jisas nɨpe ram mɨnöŋ Galili amöm, God manö aij u nɨbi bɨ gau kalɨp hag ñöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab ñɨn hain pör abad mɨdmɨdim u, mɨñi auöp! Nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun a gɨmim arö gɨmim, God manö aij u, nɨŋö hagöp a gɨmim, nɨŋ udmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Ñɨg Waŋö Galili goƚ au padiöl gɨ nɨŋa, bɨ kabsaƚ udep madöl mɨhau, kabsaƚ udul a gɨmil, uben ap ud ñɨg aŋ yaŋ yumil mɨdailö. Bɨ mamil anɨb mɨhau hib kale mɨhöŋ u, Saimon aip Edru aip. ");
INSERT INTO kpw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas kalɨp mɨhöŋ nɨŋöm haga, “Aulö, yad aip ajun, yad kalöp mɨhöŋ hag ñɨ aij gɨnö, nɨbi bɨ udep bɨ mɨhau mɨdeinabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hagö, nɨŋö hagöp, a gɨmil, uben gau arö gɨmil, Jisas aip arlö. ");
INSERT INTO kpw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pen Jisas yöp pro magö ap amöm nɨŋa, Sebedi ñɨ nɨpe Jems aip, Jon aip ñɨg magɨb mɨgan u mɨdöl gɨ, uben pa gɨ dö ga u, al dör göl gɨ mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas kalɨp mɨhöŋ nɨŋöm haga, “Kale mɨhöŋ auɨl e!” ga. Jisas anɨg hagö, kalpe mamil mɨhau nɨŋmil, nap nɨp wög gɨ ñeb bɨ rɨmnap aip kalɨp ñɨg magɨb adö au arö gɨmil, Jisas aip arlö. ");
INSERT INTO kpw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pen kale daun pro Kapaneam amöm, Juda God nɨp sabe gep mañu, Jisas Juda magum gep ram raul mɨgan yaŋ amöm, God Manö u hag ñö, ");
INSERT INTO kpw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","nɨbi bɨ gau nɨŋöm, pa gɨƚɨ göm hagla, “God lo manö hag ñeb bɨ gau hagpal rö hagagöp; nɨpe bɨ kub yabɨƚ nɨŋ aij göm hagpal rö hagöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pen magö anɨbu, bɨ kɨjaki abaŋ ala ap, magum gep ram raul mɨgan anɨbu mɨdeia u bƚaƚö göm haga, ");
INSERT INTO kpw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas bɨ Nasared nɨbö! Ne hanɨp nɨhön gɨnɨg auban? Hanɨp kɨjaki gau al pak lɨnɨg auban aka? Yad nöp nɨŋbin, ne God Ñɨ Uɫ nɨpe u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hagö, Jisas pen kɨjaki bɨ anɨbu abaŋ ala u nɨp manö kƚö hagöm haga, “Manö hagagmön! Bɨ u nɨp arö gɨmön, höŋ aru!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jisas anɨg hagö, kɨjaki anɨbu bɨ u nɨp ud gɨl gɨl göm, wɨñ kub alöm, höŋ ara. ");
INSERT INTO kpw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jisas anɨg gö, nɨbi bɨ mɨdeila gau aiö yabɨƚ göm, manö hag nɨŋ hag nɨŋ göm hagla, “U nɨhön? Bɨ i manö gɨsön nɨbö manö adö ap dauöp aka? Nɨpe bɨ pɨdöŋ halö. Kɨjaki aiön pi gau manö nɨpe udöm hagöp rö gɨpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɨbi bɨ gau anɨg hagöl gɨ, Jisas kɨjaki aiön pi hag höŋ yua manö anɨbu, ram mɨnöŋ Galili gau magöŋhalö hag ñɨlö ara. ");
INSERT INTO kpw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pen Jisas, Jems, Jon, Saimon, Edru, kale Juda magum gep ram u arö göm, höŋ amöm, Saimon aip nɨmam Edru aip ram kale u arla. ");
INSERT INTO kpw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ram amjaklö, Jisas nɨp hagla, “Saimon nɨbor nɨpe hañ romaŋ u mab rö inö, han mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Haglö, Jisas am ñɨmagö kɨd nɨpe u udöm ud urak ñö nɨŋöl gɨ, hañ nɨpe mab rö ineia u kamɨŋ la nɨŋöm adɨŋ nan magö kalɨp ña. ");
INSERT INTO kpw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pen sɨdö wad ara magö u, nɨbi bɨ nan ga gau abe, nɨbi bɨ kɨjaki abaŋ ala gau abe, Jisas gö kamɨŋ laŋ, a göm, Jisas mɨdeia au daula. ");
INSERT INTO kpw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Daun pro Kapaneam nɨbi bɨ gau magöŋhalö apöm ram ajöŋ iƚ höŋ nö löyaŋ adö nɨŋ mɨdeila nɨŋöm ");
INSERT INTO kpw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","nɨbi bɨ iru nöp nan ga gau, Jisas gö, kamɨŋ la. Kɨjaki aiön pi abaŋ ala gau iru nöp hag höŋ yua. Pen kɨjaki aiön pi anɨb gau Jisas nɨpe bɨ an nɨŋ aij gɨla rö, Jisas kalɨp, “Manö gagmim,” a göm, hag höŋ yua. ");
INSERT INTO kpw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ruö, Jisas hilɨm halö yabɨƚ uraköm, ram hana u arö göm, daun anɨbu abe arö göm, am mɨgan ap ke amöm, Nap nɨp sabe göl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pen bɨ nɨpe Saimon, bɨ nɨpe rɨmnap aip, Jisas mai, a göm, nɨp uƚhai nɨŋnɨg arla. ");
INSERT INTO kpw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jisas nɨp uƚhai nɨŋ dam nɨŋöm hagla, “Nɨbi bɨ magöŋhalö nöp mai, a göm, uƚhaiaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Anɨg hageila, Jisas haga, “Hon ram rɨƚɨg agƚö rɨmnap halö söl aui arun. Yad aubin u, nɨbi bɨ ram mɨnöŋ mɨgan gau gau kalɨp manö hag ñɨnam, a gem, aubin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Anɨg hagöm, ram mɨnöŋ Galili aŋ gau gɨ ajöl gɨ, am Juda magum gep ram raul gau amöm, God Manö hag ñöl gɨ, kɨjaki aiön pi nɨbi bɨ kalɨp abaŋ ala gau hag höŋ yua. ");
INSERT INTO kpw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wös hapeb la bɨ ap, Jisas mɨdeia au apöm, kugom yɨmöm, haga, “Ne wös yɨp u kamɨŋ laŋ, a gɨnabön u, kamɨŋ lɨnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Anɨg hagö, Jisas nɨp mög nɨŋöm ñɨmagö mɨlöbö löm bɨ anɨbu nɨp ud nɨŋöm haga, “Yau, gɨnabin. Kamɨŋ lɨ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nɨp ud nɨŋö adɨŋ kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pen Jisas bɨ anɨbu nɨp manö kƚö hagöm haga, “Adan aŋ gau nɨbi bɨ rɨmnap kalɨp nɨŋmön, Jisas yɨp gö kamɨŋ löp, a gɨmön, hagagmön. Kabö rö nöp ammön, bɨ God nɨp nan sabe gep u nɨp hañ romaŋ ne u yammön hagmön, ‘Wös hapeb yad u kamɨŋ löp,’ a gɨmön. Anɨg hagmön, Mosɨs nöd haga rö, nan rɨmnap dam bɨ God nɨp nan sabe gep bɨ u ñɨmön, nɨpe pak God nɨp sabe gɨ ñö me, nɨbi bɨ gau, bɨ u mɨñi kamɨŋ löp, a göm, nɨŋnaböl,” a ga. Jisas manö anɨbu nöp hagöm bɨ u hag yuö ara. ");
INSERT INTO kpw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas anɨg haga u pen bɨ anɨbu nɨpe amöm, nɨbi bɨ gau abönamö hag ñö ara. Anɨg gö, Jisas daun gau waiö ajainɨm rö lagö, nɨpe amöm nɨbi bɨ iru mɨdageila aŋ gau nöp mɨdö nɨŋöl gɨ, nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö nɨp nɨŋnɨg aumɨdal. ");
INSERT INTO kpw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Ñɨn mɨhöp nöp padiö nɨŋöl gɨ Jisas kauyaŋ daun pro Kapaneam auö, Jisas ap mɨdöp ram nɨpe u, a gɨlö, nɨbi bɨ iru nöp apöm gɨlö gɨlö, ram raul manö hag ñeia mɨgan u sɨsɨ göm, ajöŋ iƚ höŋ adö au yaŋ u rö nöp sɨsɨ yöl ga. Pen Jisas kalɨp God Manö hag ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jisas kalɨp hag ñɨ mɨdö nɨŋöl gɨ, bɨ unbö yɨgwo mɨlö u bɨ rɨmnap aip, bɨ ñɨmagö ma kɨƚa ga ap ilöŋ löm, dapöm Jisas mɨdeia au daula. ");
INSERT INTO kpw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Apöm nɨŋla, nɨbi bɨ sɨsɨ göl mɨdeila nɨŋöm bɨ ñɨmagö ma kaƚa ga u nɨp dam ram adö laŋ amöm, ram aŋ au ud mol juöm yulö, Jisas mɨdeia yaŋ luga. ");
INSERT INTO kpw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pen kale Jisas gö kamɨŋ lɨnab, a göm, gasɨ nɨŋ udla u nɨŋöm Jisas haga, “Ñɨ yad. Nan si nan naij gɨpan gau nɨŋem arö gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Anɨg hagö, Juda lo manö hag ñeb bɨ rɨmnap asɨk mɨdeila gau, gasɨ kale gau nöp nɨŋöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bɨ i nɨhön gɨnɨg, God nɨp hag juöm, manö piral hagab? Nɨbi bɨ gau nan si nan naij gɨlö, bɨ ap prɨ kalɨp u ƚɨk gɨ yunɨm rö lagöp; God nöp me anɨg gɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pen gasɨ nɨŋla anɨbu, adɨŋ Jisas ke nɨŋöm haga, “Kale nɨhön gɨnɨg gasɨ anɨbu rö nɨŋabim. ");
INSERT INTO kpw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bɨ ñɨmagö ma kɨƚa göp u nɨp nɨhön hagnö, kalöp aij gɨnab? Nan si nan naij gɨpan u nɨŋem arö gabin, a gɨnö, kalöp aij gɨnab; aka, urakmön köp ne u wɨnɨg ud aru, a gɨnö, kalöp aij gɨnab? ");
INSERT INTO kpw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yad gɨnö, kale nɨŋnabim, Bɨ Ñɨ nɨpe mɨnöŋ naböŋ iƚ i aunö u, gasɨ yad ke nɨŋem auagnö. God hagö aunö u me, nan si nan naij gɨpal u nɨŋem arö gɨnabin, a gɨnabin u, arö gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Anɨg hagöm, bɨ ñɨmagö ma kɨƚa ga u nɨp haga, “Yad nöp hagabin, urakmön, köp ne u wɨnɨg udmön ram aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jisas anɨg hagö, nɨbi bɨ nɨŋ mɨdlö nɨŋöl gɨ, bɨ anɨbu uraköm, köp bad nɨpe u wɨnɨg udöm hada. Anɨg gö nɨŋöm, nɨbi bɨ gau magöŋhalö aiö yabɨƚ göm, God hib nɨpe u haglö adö arö nɨŋöl gɨ, hagla, “Nöd nan anɨbu rö ap gɨlö, hon nɨŋagmɨdun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas kauyaŋ amöm, Ñɨg Waŋö Galili goƚ au ajeia nɨŋöl gɨ, nɨbi bɨ iru nöp nɨŋöm mɨdeia au ap magum geila nɨŋöm Jisas kalɨp God Manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas manö hag ñɨ pɨs göm, adan aŋ au amöl gɨ nɨŋa, Alpias ñɨ nɨpe Lipai, bɨ dakɨs udep bɨ ap, wög gɨmɨdöp ram raul mɨgan u asɨk mɨdeia. Jisas nɨp nɨŋöm haga, “Auö, yad aip arul,” a gö, uraköm Jisas aip arlö. ");
INSERT INTO kpw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas pen, bɨ nɨpe gau aip am Lipai ram u nan ñɨŋlö nɨŋöl gɨ, bɨ dakɨs udep gau abe, bɨ nan si nan naij gɨla gau abe, Jisas aip ajeila rö, am jɨm ñöm nan ñɨŋeila. ");
INSERT INTO kpw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bɨ lo manö hag ñeb bɨ Perisi rɨmnap, Jisas nɨpe bɨ dakɨs udep gau aip, bɨ nan si nan naij gɨmɨdal gau aip mɨdöm nan ñɨŋeia u nɨŋöm, bɨ nɨpe gau kalɨp hagla, “Jisas nɨhön gɨnɨg bɨ dakɨs udpal gau aip, bɨ nan si nan naij gɨpal gau aip asɨk mɨdöm nan ñɨŋab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hageila, Jisas manö anɨbu nɨŋöm haga, “Nɨbi bɨ kamɨŋ mɨdpal gau, wös wameb bɨ nɨŋnɨg aragal; nɨbi bɨ nan göp gau nöp wös wameb bɨ nɨŋnɨg arbal. Anɨb u rö, nɨbi bɨ, gɨ aij gɨpun, a gɨ gasɨ nɨŋbal gau, kalɨp udnɨg auagɨn; nɨbi bɨ, nan si nan naij gɨpun, a gɨ gasɨ nɨŋbal gau, kalɨp udnɨg aubin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon bɨ nɨpe gau abe, Perisi kai bɨ kale gau abe, ñɨn rɨmnap God nɨp sabe göl gɨ nöp mɨdaiun, a göm, nan ñɨŋagmɨdal. Ñɨn ap kale anɨg geila u nɨŋöm nɨbi bɨ rɨmnap apöm Jisas nɨp hagla, “Jon bɨ nɨpe gau abe, Perisi kai bɨ kale gau abe, ñɨn añɨ añɨ nan ñɨŋagpal. Pen bɨ ne gau, nɨhön gɨnɨg anɨg gagpal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hageila, Jisas manö hod rɨköm haga, “Bɨ nɨbi udnɨg gɨnab bɨ ap, nɨmdamam nɨpe gau aip mɨdöm, aij gö nɨŋöl gɨ mɨdeinaböl u me, nan magö arö gagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pen hainö, nɨbi bɨ rɨmnap apöm, bɨ kale anɨbu nɨp ud areinaböl u, mög gö, ñɨn anɨbu nan ñɨŋagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pen waƚɨj gɨsön nɨbö bad ap udöm, waƚɨj asöl göm pa gɨ dö gɨnab ramö u al udlö, waƚɨj gɨsön u kƚö mɨdöl gɨ, waƚɨj asöl gɨnab u pak gɨ dö göm, waƚɨj kale u rapɨn nöp pa gɨ dö gö arnab. ");
INSERT INTO kpw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ñɨg wain u, u rö nöp. Ñɨg wain kamɨŋ u udöm, kaj meme hañ nöd nɨbö mɨgan u hoŋ gɨ lagpal. Pen nɨhön: hoŋ gɨ löm mame ñɨlö, kaj meme hañ u bɨŋ hagöm, pak gɨ dö göm hoŋ gɨ am haknab. Anɨb u me, ñɨg wain kamɨŋ u, kaj meme hañ kamɨŋ mɨgan u nöp hoŋ gɨ lep,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Hainö Juda God nɨp sabe gep ñɨn kale ap, Jisas bɨ nɨpe gau aip wid wög aŋ au padiöl gɨ, bɨ nɨpe gau wid magö rɨmnap rɨköl gɨ areila. ");
INSERT INTO kpw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Anɨg gɨlö, Perisi bɨ gau nɨŋöm, Jisas nɨp hagla, “Mɨñi God nɨp sabe gep ñɨn hon wög gagep u, bɨ ne gau anɨg göl wög göm lo hon rɨb juaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hageila, Jisas haga, “Bac Depid hadame nöp kɨyö lö ga aiud kalɨ kƚiñ rɨkla u, kale nɨŋagpim ar? ");
INSERT INTO kpw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hadame nöp bɨ ne Abiada God nɨp nan sabe gep bɨ kub yabɨƚ mɨdmɨdöp ñɨn u, Depid bɨ nɨpe gau aip kalɨp kɨyö lö, God sabe gep ram u amöm, bred nɨbi bɨ yɨharɨŋ gau ñɨŋagpal, bɨ God nɨp nan sabe gep bɨ gau nöp ñɨŋbal u udöm, bɨ nɨpe gau kalɨp ñö ñɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“God nɨpe ñɨn yɨharɨŋ mɨdep manö u nöd hagöm, hainö nɨbi bɨ gɨ laga; nɨbi bɨ gɨ löm, ake löm mɨd aij gɨlaŋ, a göm, ñɨn ap yɨharɨŋ mɨdaiöl, a ga. ");
INSERT INTO kpw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Anɨb u, hon nɨŋbun, Bɨ Ñɨ nɨpe God nɨp sabe gep ñɨn u abe Bɨ Kub mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ñɨn ap pen, Jisas kauyaŋ Juda magum gep ram u amöm nɨŋa, bɨ ñɨmagö kɨƚa ga ap ram raul mɨgan anɨbu ap mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nɨbi bɨ mɨdeila gau rɨmnap, Jisas nɨhön rö gö, nɨp dam manö kub hagun, a göm, bɨ anɨbu God nɨp sabe gep ñɨn i gö kamɨŋ lɨnab aka göm, agamɨj nɨŋ ij halö lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas pen bɨ ñɨmagö kɨƚa ga u nɨp haga, “Urakmön, aui au,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hagö, nɨpe mɨdeia au gɨlaŋ auö, Jisas nɨbi bɨ anɨb gau kalɨp haga, “God nɨp sabe gep ñɨn u nɨhön gep? Aij gep aka naij gep? Nɨbi bɨ gau kalɨp mög nɨŋun gɨno kamɨŋ aröl, aka gasɨ naij nɨŋun arö gɨno, umöl?” ö ga. Hageia, kale nɨp pen manö ap hagagla. ");
INSERT INTO kpw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas manö udagun, a göm, nɨŋla bɨ anɨb gau, Jisas kalɨp nɨŋö, mulu luga. Jisas kalɨp gau gau nɨŋ damöm sɨƚɨk la. Anɨg göm, bɨ ñɨmagö kɨƚa ga u nɨp haga, “Ñɨmagö ne mɨlöbö lɨ!” a ga. Hageia, ñɨmagö mɨlöbö lö nɨŋöl gɨ, kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Anɨg ga nɨŋöm, bɨ Perisi Juda magum gep ram u arö göm, Herod bɨ nɨpe gau mɨdeila au amöm, manö hag nɨŋ hag nɨŋ göm, “Jisas nɨp aige gun al pak lun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas pen bɨ nɨpe gau udöm, amöm Ñɨg Waŋö Galili goƚ au am mɨdeila. Pen nɨbi bɨ Galili nɨbö iru nöp nɨp hain göm aula. Nɨpe nan nɨhön nɨhön gɨmɨdöp adö u haglö gau arö nɨŋöl gɨ, Judia nɨbi bɨ rɨmnap, Jerusalem nɨbi bɨ rɨmnap, ram mɨnöŋ Idumia nɨbi bɨ rɨmnap, ñɨg Jodan böŋ lödaŋ nɨbi bɨ rɨmnap, daun kub mɨhöp Daia Saidon nɨbi bɨ rɨmnap, nɨbi bɨ iru yabɨƚ Jisas nɨp nɨŋnɨg aula. ");
INSERT INTO kpw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jisas nɨbi bɨ iru nöp gö, kamɨŋ la u me, nɨp ud nɨŋno kamɨŋ lɨnɨm, a göm, nɨbi bɨ iru nɨbanö yabɨƚ apöm, nɨp cɨro cɨro ñöl gɨ auö, bɨ nɨpe gau kalɨp hagö, ñɨg magɨb ap ud lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pen nɨbi bɨ kɨjaki aiön pi nan nɨhön abaŋ ala gau, Jisas nɨp nɨŋöm, mɨnöŋ yaŋ lug paköm, manö kub hagöm, “Ne God Ñɨ nɨpe!” a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisas pen kɨjaki aiön pi gau kalɨp manö kƚö hagöm haga, “Yad Bɨ an mɨdpin u waiö hagagmim wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pen Jisas ram mɨnöŋ nö ap amöm, bɨ nɨpe udnɨg ga gau hagö aueila haga, ");
INSERT INTO kpw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","“Yad kalöp bɨ unbö mɨgan laŋ udpin u, kale yad aip ajmim, bɨ manö yad ud arep gau mɨdmim, kalöp hag yunö, ammim nɨbi bɨ gau kalɨp God Manö aij u hag ñɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yad kalöp hagabin u me, kɨjaki aiön pi nan gau u rö nöp hag yunabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisas bɨ nɨpe uda anɨb gau hib kale me, ap Saimon, hainö Jisas hib nɨpe ap Pida a ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ap Jems, nɨmam ap Jon, nap kalpe mɨhöŋ hib u Sebedi. Jisas kalɨp mɨhöŋ Boanerges a ga. Hib anɨbu iƚ u “Rɨmu Bɨ”. ");
INSERT INTO kpw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bɨ nɨpe ap Edru; ap Pilip; ap Badolomyu; ap Madyu; ap Domas; ap Jems, Alpias ñɨ nɨpe; ap Padias; ap Saimon, nɨp Saimon Selod a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Pen ap Judas Iskariod. Nɨpe me hainö Jisas nɨp mumug ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pen Jisas ram ap arö, kauyaŋ nɨbi bɨ iru nöp ap magum gɨ mɨdeila nɨŋöm, bɨ nɨpe gau aip nan ñɨŋöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Anɨg gö, nɨbi bɨ rɨmnap Jisas hauƚ alöp a gɨlö nɨŋöm, nɨme, nɨmam bɨ nɨp uɫ gɨnɨg aula. ");
INSERT INTO kpw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pen lo manö hag ñeb bɨ Jerusalem nɨbö aula gau hagla, “Kɨjaki aiön pi nan gau nap kale Bielsebul Jisas nɨp abaŋ alöp rö, aiön pi nan gau hag yuab,” a gɨla. Manö piral anɨbu hageila, ");
INSERT INTO kpw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas nɨpe nɨŋöm, nɨbi bɨ gau kalɨp hagö aueila, manö adö anɨbu manö hod rɨköm haga, “Seden aige göl göm Seden nɨp hag yunab? ");
INSERT INTO kpw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nɨbi bɨ ram mɨnöŋ añɨ ap kale ke nöp pen pen gɨnaböl u, mɨgan anɨbu asɨk ke ke lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pen amɨlap apɨlap gau u rö nöp pen pen gɨnaböl u, asɨk ke ke lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anɨb u rö, Seden nɨpe ke kɨjaki aiön pi nan nɨpe gau hag yueinab u, asɨk ke ke löm böŋ nöp lug paknab. ");
INSERT INTO kpw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bɨ kal yabɨƚ ap ram nɨpe au mɨdö nɨŋöl gɨ, bɨ ap apöm, nan nɨpe gau ud aragnab; nöd bɨ kal anɨbu nɨp nagɨ adɨk löm me, am nan ram nɨpe gau mɨdöp u ud arnab. ");
INSERT INTO kpw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pen nɨŋ aij gɨmim! Nɨbi bɨ gau nan si nan naij nɨhön nɨhön gɨnaböl u, God nɨŋöm arö gɨnab. God nɨp hag junaböl u, nɨpe nɨŋöm arö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pen Ana Uɫ u nɨp hag junaböl u, God nɨŋöm arö gagnab. Nan si nan naij gɨnab anɨbu pör nöp mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas nɨp, “Kɨjaki aiön pi nan gau nɨp abaŋ alöp,” a geila u me, anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pen Jisas nɨme nɨmam bɨ apöm, höŋ löyaŋ mɨdöm, bɨ ap nɨp, “Ne am Jisas nɨp hagö auaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Anɨb u, nɨbi bɨ ram raul mɨgan yaŋ Jisas nɨp bɨg gɨgabö gɨ asɨk mɨdeila gau nɨp hagla, “Name nañɨn namam bɨ gau höŋ yaŋ am mɨdöm, ‘Ne aue,’ gaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Anɨg hageila, Jisas haga, “Ami yad, mam yad bɨ an?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anɨg hagöm, Jisas nɨbi bɨ mɨdeila gau nɨŋ padiöl gɨ haga, “Kale me ami yad, mam yad mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nɨbi bɨ God hagöp rö gɨpal gau me, mam yad, añ yad, ami yad mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas Ñɨg Waŋö Galili goƚ au amöm, nɨbi bɨ gau kalɨp kauyaŋ manö hag ñɨ mɨdö nɨŋöl gɨ, nɨbi bɨ iru yabɨƚ nöp ap magum gɨla. Anɨg geila, Jisas ñɨg magɨb ap adö u asɨköm, am ñɨg aŋ söl au mɨdöl gɨ, nɨbi bɨ ñɨg goƚ gau urak mɨdeila gau kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Manö anɨb gau manö hod rɨköm adö ke ke iru nöp hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Manö adö ap manö hod rɨköm haga, “Manö hagnɨg gabin i nɨŋim! Bɨ ap wög adɨŋ nɨpe u wid yɨŋ ranaŋ, a göm, ud yuö arö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","rɨmnap adan arep adö au lugö, yaur gau apöm ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Rɨmnap kabö adö mɨnöŋ pro pro lɨnab au lugöm rannab u pen ");
INSERT INTO kpw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kɨdɨƚ yuö aragnab rö, sɨdö nɨŋöm, mɨƚep gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Rɨmnap gɨƚɨkasɨ mɨdeinab aŋ au lugöm, rannab u pen gɨƚɨkasɨ gau pɨmamu gɨ pak ñɨŋö, magö pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pen yɨŋ rɨmnap mɨnöŋ aij adö u lugöm, ran aij göm, magö pɨl aij gɨnab. Rɨmnap magö ñɨn juöl ado gɨ da sɨduŋ laŋ (30) rö pɨlnab, rɨmnap magö ñɨn juöl mɨhau nɨgaŋ (60) rö pɨlnab, rɨmnap ñɨn juöl unbö mamɨd u (100) rö pɨlnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas manö anɨbu hag pɨs göl gɨ haga, “Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas manö hagö nɨŋöl gɨ, nɨbi bɨ nɨŋ mɨdeila anɨb gau ke ke arla nɨŋöm bɨ nɨpe unbö mɨgan laŋ gau abe, nɨbi bɨ nɨpe rɨmnap halö abe, Jisas nɨp hagla, “Manö hod rɨkmön hagpan iƚ u nɨhön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hageila haga, “God nɨbi bɨ udöm abad mɨdeinab manö u, God gö kale nɨŋbim u pen nɨbi bɨ gau kalɨp hod rɨkem nöp hag ñabin. ");
INSERT INTO kpw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anɨg gɨnö, bɨ God manö hagep ap God Manö kalɨ kƚiñ rɨköm haga rö nöp gɨnab. Nɨpe haga, ‘Amgö nɨŋnaböl u pen nan rɨmnap nɨŋagnaböl. Manö nɨŋnaböl u pen manö iƚ hagöp anɨg rö göm nɨŋagnaböl. Nɨŋ aij gɨblap, God nɨp hag nɨŋaiblap, nan si nan naij gɨpal gau nɨŋöm arö gɨböp,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas anɨg hagöm kalɨp haga, “Manö hod rɨkem hagpin anɨbu nɨŋagpim u, hainö manö rɨmnap halö hod rɨk hageinabin u, aigöl gɨmim nɨŋnabim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wid yɨŋ u, God Manö nɨpe u, a gem, hagpin. ");
INSERT INTO kpw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yɨŋ rɨmnap adan arep adö au lugnab, a gɨpin u, nɨbi bɨ gau God Manö nɨŋnaböl u pen magö anɨbu nöp Seden apöm manö anɨbu ju ud arnab, a gem, hagpin. ");
INSERT INTO kpw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Pen yɨŋ rɨmnap kabö adö mɨnöŋ pro pro lɨnab au lugöm, rannab u pen kɨdɨƚ yuö aramöm pɨdöŋ gagö, sɨdö nɨŋöm mɨƚep gɨnab, a gɨpin u, nɨbi bɨ gau God Manö u gɨsön magö u nɨŋlö aij gö nɨŋöl gɨ, udnaböl u pen yöp pro pro magö u mɨdlö nɨŋöl gɨ, mɨŋör rɨmnap aunab aka bɨ gau kalɨp gɨ naij gɨnaböl nɨŋöm manö anɨbu arö gɨnaböl, a gem, hagpin. ");
INSERT INTO kpw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yɨŋ rɨmnap gɨƚɨkasɨ aŋ au lugöm rannab, a gɨpin u, nɨbi bɨ God Manö nɨŋnaböl u pen ");
INSERT INTO kpw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wög waryö, ram köp haneb, kaj nan gau gasɨ iru nɨŋöm, ru kɨbap, uɫpö mani nan gau gasɨ iru nɨŋöm, nan gau gau nöp gasɨ nɨŋnaböl u me, God Manö u pɨmamu gɨ pak ñɨŋö, magö pɨlagnab, a gem, hagpin. ");
INSERT INTO kpw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wid yɨŋ mɨnöŋ aij adö au lugnab a gɨpin u, nɨbi bɨ God Manö nɨŋöm, nɨŋ udeinaböl nɨŋöm magö ñɨn juöl ado gɨ da sɨduŋ laŋ (30), aka ñɨn juöl mɨhau nɨgaŋ (60), aka ñɨn juöl unbö mamɨd u (100) rö pɨlnab; gasɨ anɨbu nɨŋem hagpin me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas pen kauyaŋ manö ap hod rɨköm haga, “Nɨbi bɨ gau hapö lauöm rin cög mɨgan gau aka abañ adö hanbal mo gayɨk gau pi gagnaböl; adö aulɨk lɨlö mailö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anɨb u rö, nɨhön nɨhön mɨñi pi göl mɨdöp u, hainö waiö lö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kalɨp manö ap haga, “Manö nɨŋabim u, rɨk dam nɨŋ aij gɨmim. Kale nɨbi bɨ gau kalɨp manö kub hagmim, pen aige rö ñɨmim a gɨnabim u, God nɨpe nɨŋöm kalöp ke u rö nöp manö kub hagöm, pen u rö nöp unbö rö ñɨmim a gɨnab. Pen nɨpe kalöp pen rɨmnap halö adö laŋ abe ñɨmim a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nɨbi bɨ nan rɨmnap mɨdöp gau rɨmnap halö udnaböl; pen nɨbi bɨ nan rɨmnap mɨdagöp gau, nan rɨmnap pro pro mɨdöp u halö ud arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas manö ap manö hod rɨköm haga, “God nɨbi bɨ udöm abad mɨdeinab u, aiud adö i rö mɨdöp. Bɨ wög nap ap wid yɨŋ ranaŋ, a göm, dam wög naböŋ nɨpe gau yunab. ");
INSERT INTO kpw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wid yɨŋ wög naböŋ au yuöm, han ajö nɨŋöl gɨ, marep göm, rannɨg gab. Aigegö göm ranöb, a göm, nɨŋagnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mɨnöŋ u ke gö, sɨƚɨp hañauöm, ranöm, magö pɨlöm, po gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pen wög naböŋ nap nɨbö u po gö nɨŋöm, rɨk dam lep ñɨn u auöp, a göm, ru agƚame u damöm, rɨk daunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas anɨg hagöm haga, “God nɨbi bɨ udöm abad mɨdeinab u, aiud nɨhön rö udem hagnö nɨŋnabim? ");
INSERT INTO kpw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Me, mab masded yɨŋ rö u, a gɨnam. Nan yɨŋ rɨmnap kub yɨmbal gau pro ranöb, pen masded yɨŋ u pro yabɨƚ yɨmlö, ran kub göm, ramö alö, yaur gau apöm hai anɨb gau lɨ mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas nɨbi bɨ gau kalɨp manö hod rɨkep anɨb gau rö iru nöp hag ñɨmɨdöp; anɨg göm, manö aij u kalɨp hag ñɨmɨdöp. Kale manö nɨŋ aij gɨnaböl manö u nöp kalɨp hag ñɨmɨdöp; manö nɨŋ aij gagnaböl manö u hag ñaga. ");
INSERT INTO kpw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nɨpe kalɨp manö hod rɨköm nöp hag ñɨmɨdöp. Hainö bɨ nɨpe gau aip ke mɨdöl göm, manö iƚ magöŋhalö hag ñɨ aij gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ñɨn anɨbu nöp ram dugöp magö u, Jisas bɨ nɨpe gau kalɨp haga, “Ñɨg waŋö böŋ lödaŋ arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Anɨg hagö, bɨ nɨpe gau nɨbi bɨ iru nöp ap mɨdeila gau kalɨp arö göm, ñɨg magɨb Jisas mɨdeia mɨgan u ranöm, hadla. Ñɨg magɨb rɨmnap halö aip arla. ");
INSERT INTO kpw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aŋ arlö nɨŋöl gɨ, adɨŋ pɨnöm asad apöm, ñɨg si ral ñɨg magɨb mɨgan u amöm, am lugnɨg rö ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas nɨpe pen ñɨg magɨb mɨgan adɨŋ lajɨŋ adö, nabɨc ilöŋ löm haneia nɨŋöl gɨ, bɨ nɨpe gau nɨp am aŋa göm hagla, “Manö hag ñeb bɨ, hon magöŋhalö umnɨg gabun gasɨ u nɨŋagpan ar?” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hageila, Jisas uraköm, pɨnöm asad udeia u abe, ñɨg si ral aueia u abe, agamɨj mɨd a gö, pɨnöm asad udeia u hir göm, ñɨg si ral aueia u böŋ nöp ur göm ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pen Jisas bɨ nɨpe gau kalɨp haga, “Kale nɨhön gɨnɨg pɨñɨŋ gabim? Kale nɨŋ udep magö kale pro ap mɨdöp nɨŋöm pɨñɨŋ gabim aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hagö, kale aiö göm, pen hag nɨŋö pen hag nɨŋö göm hagla, “Bɨ anɨbi an? Aige gö göm hagajɨp, pɨnöm asad udajɨp u abe, ñɨg si ral auajɨp u abe, manö nɨp u nɨŋöm, hagöp rö göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas bɨ nɨpe gau aip ñɨg magɨb udöm, Ñɨg Waŋö Galili juöm, ram mɨnöŋ Gerasa nɨbi bɨ mɨdeila böŋ lödaŋ adö amjaköm, ");
INSERT INTO kpw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ñɨg magɨb u arö göm, ujaŋɨd lugö nɨŋöl gɨ, magö anɨbu nöp, kɨjaki abaŋ al mɨdeia bɨ ap, wip rɨgöl mɨgan gau nɨbö apöm, Jisas mɨdeia au aua. ");
INSERT INTO kpw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Bɨ anɨbu wip rɨgöl gɨla kabö mɨgan gau han ajmɨdöp. Nɨp pör sen udöm, ñɨmagö ma nɨpe gau lɨ rɨbɨkmɨdal u pen sen gau gö, pa gɨ dö gö, armɨdöp. Nɨpe kƚö yabɨƚ gɨmɨdöp u me, nɨp gɨlö gasɨ nɨŋnɨm rö laga. ");
INSERT INTO kpw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sɨdö aŋ, sɨbön yaŋ, wip rɨgöl gɨmɨdal kabö mɨgan gau abe, nö ilö gau abe, gauƚ göl göm, kabö udöm, hañ romaŋ nɨpe ke rɨbmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pen ñɨn anɨbu, nɨpe Jisas nɨp yɨjɨg nɨŋöm, gɨ dö gɨ amöm, Jisas mɨdeia au kugom yɨmö, ");
INSERT INTO kpw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisas kɨjaki bɨ anɨbu nɨp abaŋ al mɨdeia u nɨp haga, “Ne kɨjaki aiön pi, bɨ i nɨp arö gɨmön höŋ aru!” a ga. Hageia haga, “Jisas, God kƚö unbö ke yabɨƚ Ñɨ nɨpe. Yɨp nɨhön gɨnɨg auban? Manö nɨŋö hagmön, ‘God nɨŋ mɨdöp rö, yad nöp ilön mab rö ñagnabin,’ a gɨmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Anɨg hagö, Jisas bɨ anɨbu nɨp haga, “Hib ne nɨhön?” ö ga. Hageia haga, “Yɨp kɨjaki iru nöp abaŋ alöp rö, hib yad ‘Iru Nöp,’” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nɨpe Jisas nɨp, kɨjaki aiön pi gau ram mɨnöŋ ke mɨlö gau hag yuagmön, a göm, hag nɨŋöl gɨ nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pen magö anɨbu, kaj iru yabɨƚ amɨl ñɨŋeila sɨnaŋ ba anɨb gau. ");
INSERT INTO kpw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Anɨb u, kɨjaki gau Jisas nɨp neb neb göm hagla, “Hanɨp hagö, amun kaj gɨlaŋ kalɨp yuö hiɨkun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Anɨg haglö, Jisas yau a gö, kɨjaki gau bɨ anɨbu nɨp arö göm, amöm kaj gau kalɨp yuö hiɨklö, magöŋhalö du dausan rö pɨg ju rul yaŋ amöm, gɨ dam ñɨg waŋö yaŋ paköm, magöŋhalö ñɨg ñɨŋöm um hakla. ");
INSERT INTO kpw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pen bɨ kaj mukmɨdal gau, ga anɨbu nɨŋöm, am daun anɨbu abe, ram mɨnöŋ gau abe, manö anɨbu hag ñɨlö nɨŋöl gɨ, nɨbi bɨ gau am nɨŋun, a göm, Jisas mɨdeia au aula. ");
INSERT INTO kpw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Apöm nɨŋla, bɨ nöd kɨjaki iru nöp abaŋ ala anɨbu, waƚɨj yɨmöm, mɨd aij göm, asɨk mɨdeia. Nɨŋlö, anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nɨbi bɨ nöd mɨdeila gau, nɨbi bɨ hain aula gau kalɨp, bɨ kɨjaki abaŋ al mɨdeia bɨ u nɨp Jisas nɨhön nɨhön ga u hag ñɨla. Pen kaj gau kalɨp nɨhön nɨhön ga u abe hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pen nɨbi bɨ anɨb gau, manö hagla anɨbu nɨŋöm, Jisas nɨp manö neb neb göm hagla, “Ram mɨnöŋ hon i arö gɨmön aru!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hageila, Jisas ñɨg magɨb udöm arnɨg gö, bɨ gö kamɨŋ la u nɨp neb neb göm haga, “Yad aip arul aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hageia, Jisas bɨ u nɨp wɨhö göm, haga, “Ram ne arammön, nɨbi bɨ ne gau kalɨp, Bɨ Kub nöp mög yabɨƚ nɨŋöm, nɨhön nɨhön göp manö u magöŋhalö hag ñɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hagö, bɨ anɨbu ram mɨnöŋ Dekapolis aŋ au, daun gau gɨ ajöl gɨ, Jisas nɨp nɨhön nɨhön ga u, nɨbi bɨ gau kalɨp hag ñö, kale magöŋhalö aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas pen ñɨg magɨb udöm, kauyaŋ ado gɨ am Ñɨg Waŋö Galili böŋ lödaŋ goƚ au mɨdö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨp aula. ");
INSERT INTO kpw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Bɨ ap hib nɨpe Jairas. Nɨpe Juda magum gep ram ap abad mɨdmɨdöp. Jairas Jisas nɨp nɨŋöm, ap mɨdeia au kugom yɨmöm haga, “Pai pro mɨdmagö yad u umnɨg gab. Ne yad aip aumön nɨp ud nɨŋö, urak araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hagö, Jisas uraköm Jairas aip arlö nɨŋöl gɨ, nɨbi bɨ iru nöp amöm, Jisas nɨp cɨro cɨro ñöm aŋ aŋ löm ud areila. ");
INSERT INTO kpw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pen nɨbi ap, nɨpe nɨbi adan ajmɨdöp mɨ unbö mɨgan laŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nɨbi anɨbu wös wameb bɨ gau kalɨp, yɨp gɨlö kamɨŋ laŋ, a göm, mani nɨpe magöŋhalö hadö raua u pen nɨp gɨlö kamɨŋ lagöm, rapɨn kub yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pen nɨpe Jisas gɨmɨdöp manö u haglö nɨŋa rö, am waƚɨj bad nɨp u ud nɨŋnö kamɨŋ lɨnab, a göm, nɨbi bɨ iru mɨdeila aŋ au jöl adö apöm, waƚɨj nɨp u ud nɨŋö, ");
INSERT INTO kpw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","magö anɨbu nöp hagape lugmɨdöp u mɨƚep gö, aŋ nɨpe au yaŋ nɨŋa, nɨp nan ga u kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pen Jisas ke nɨŋa, kƚö nɨpe rɨmnap ara nɨŋöm, ado göm, nɨbi bɨ iru mɨdeila gau kalɨp haga, “Waƚɨj yad u ban ud nɨŋöb?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hageia, bɨ nɨpe gau hagla, “Nɨbi bɨ iru nöp nöp cɨro ñaböl u, nɨhön gɨnɨg yɨp bɨ an ud nɨŋöb, a gɨmön, hagabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pen Jisas manö kale hagla u udagöm, yɨp bɨ an ud nɨŋöb, a göm, uƚhai nɨŋöl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pen nɨbi anɨbu, nɨp nɨhön nɨhön ga u nɨŋöm, pɨñɨŋ göm gɨl gɨl göl gɨ apöm Jisas mɨdeia ma iƚ nɨpe au kugom yɨmöm, nɨp kamɨŋ la manö u magöŋhalö waiö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas pen nɨp haga, “Pai yad. Jisas yɨp gö kamɨŋ lɨnab, a gɨmön, nɨŋ udpan rö, nöp gɨnö kamɨŋ löp me u. Ne arammön mɨd aij gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas manö anɨbu hagö nɨŋöl gɨ, Jairas bɨ nɨpe rɨmnap, ram nɨpe au nɨbö apöm hagla, “Pai ne u hadö umöb; hag ñeb bɨ i hagö, ma ilön auagnɨm, ado gɨ arnɨm,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Anɨg hagla u pen Jisas manö kalɨp u udagöm, Jairas nɨp haga, “Pɨñɨŋ gagmön; gasɨ kƚö gɨ nɨŋmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas anɨg hagöm, nɨbi bɨ gau aip aragnabun, a göm, kalɨp anɨb gau hag löm, Pida u, Jems u, Jems nɨmam Jon u, kalpe yam nöp uɫ gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kale Jairas ram u amjaköm Jisas nɨŋa, nɨbi bɨ manö pɨg hagöm, mɨɫöŋ magö göl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ram raul mɨgan yaŋ amöm haga, “Nɨhön gɨnɨg manö hauƚ gɨmim, mɨɫöŋ gabim? Pai u umagöp; yɨharɨŋ hon hanab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anɨg hagö, nɨp mɨhol gɨlö, kalɨp hag höŋ yuöm, pai nɨme nap ber u udöm, bɨ nɨpe kabö u udöm, uɫ gɨ pai u um mɨdeia ram raul mɨgan yaŋ ara. ");
INSERT INTO kpw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amöm, pai anɨbu ñɨmagö kɨd nɨp u udöm, Arameik manö löm haga, “Dalida kom!” a ga. Manö haga anɨbu iƚ me, “Pai pro! Nöp hagabin, urak!” ");
INSERT INTO kpw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas nɨp manö hagö, magö anɨbu nöp uraköm, ap ran ap lugö nɨŋöl gɨ, nɨbi bɨ gau aiö yabɨƚ gɨla. Pai anɨbu mɨ nɨpe unbö mɨgan laŋ ara. ");
INSERT INTO kpw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nɨbi bɨ mɨdeila gau aiö gɨlö nɨŋöl gɨ, Jisas manö kƚö hagöm haga, “Gɨpin anɨbu nɨbi bɨ gau kalɨp waiö hag ñagmim,” a ga. Anɨg hagöl gɨ kalɨp haga, “Pai u nɨp nan magö rɨmnap ñɨbe ñɨŋaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas bɨ nɨpe gau uɫ gɨ ram mɨnöŋ anɨbu arö göm, daun nɨpe ke Nasared ara. ");
INSERT INTO kpw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Am mɨdöm, Juda God nɨp sabe gep ñɨn u, magum gep ram u amöm, nɨbi bɨ iru nöp ap mɨdeila gau kalɨp manö hag ñö nɨŋöl gɨ, aiö göm hagla, “Bɨ anɨbi kapeda ram mɨnöŋ i nɨbö bɨ, Maria ñɨ nɨpe ap. Nɨmam nɨpe u Jems, Josep, Judas, Saimon me. Nɨñɨn bɨ nɨpe gau aip mɨdpun i. Pen manö aij anɨbu gai nɨbö nɨŋöm hagöp? Nan gagep rö aigöl göm göp?” ö gɨla. Anɨg hagöm, nɨp udagla. ");
INSERT INTO kpw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pen Jisas kalɨp haga, “Bɨ God manö hagep gau, ram mɨnöŋ mɨgan rɨmnap gɨ ajlö, bɨ kub hon, a göm, udnaböl u pen ram mɨnöŋ kale ke gau, manö kalpe u udagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nɨp nɨŋ udagla u me, nan gagep rö rɨmnap gɨnɨm rö laga; nɨbi bɨ nan ga gau mɨhöp nöp ud nɨŋö, kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pen Nasared nɨbi bɨ nɨp nɨŋ udagla u nɨŋöm Jisas aiö yabɨƚ ga. Jisas pen ram rɨƚɨg agƚö ram mɨnöŋ anɨb gau gɨ ajöl gɨ, nɨbi bɨ gau kalɨp God Manö u hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ñɨn ap bɨ nɨpe unbö mɨgan laŋ gau wɨñ alö aueila haga, “Bɨ mɨhöp ke, bɨ mɨhöp ke ram mɨnöŋ gau ke ke ammim, manö aij yad u hag ñɨmim. Yad kalöp hag yuabin rö, manö hag ñɨ ajöl gɨ, kɨjaki aiön pi nan gau hag yunɨg, hag höŋ yunabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Manö ap pen haga, “Arnɨg gɨmim u, nan ñɨŋeb, wañɨb, mani ud aragmim; ilöŋ naböŋ u nöp ud armim. ");
INSERT INTO kpw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ma rɨrup lɨmim pen sior mɨlö añɨ nöp lɨmim armim; sior rɨmnap halö ud aragmim. ");
INSERT INTO kpw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ram ap arbe kalöp hag udaiöl, ram anɨbu nöp mɨdmim, wög gɨ pɨs gɨmim, daun anɨbu arɨk arnɨg gɨmim ñɨn u nöp armim. ");
INSERT INTO kpw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pen ram mɨnöŋ ap amjakpe kalöp hag udöm, manö kalöp u nɨŋagaiöl, ram mɨnöŋ anɨbu arɨk arnɨg, nɨŋlaŋ, a gɨmim, ma haƚpɨƚ pakpe lugö armim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas anɨg hagö, bɨ nɨpe unbö mɨgan laŋ gau, kale ram mɨnöŋ gau gau amöm, nɨbi bɨ gau kalɨp manö hag ñöl gɨ hagla, “Nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨmim,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Anɨg hagöm, kɨjaki aiön pi nɨbi bɨ abaŋ al mɨdeia gau hag höŋ yuöm, nɨbi bɨ nan ga gau wel lɨ ñɨlö, kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pen Jisas ga rö manö u, ram mɨnöŋ rɨgoŋ rɨgoŋ gau arö, kiŋ Herod u rö nöp nɨŋa. Nɨbi bɨ gau, manö anɨbu hag amɨl apɨl göl gɨ, rɨmnap hagla, “Jon bɨ ñɨg pak ñeb umö rɨgöl gɨla u, kauyaŋ uraköm me, apöm nan gagep rö anɨb gau gab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Rɨmnap hagla, “Bɨ anɨbu bɨ ne Ilaija,” a gɨla. Pen bɨ rɨmnap hagla, “Bɨ God manö hagep hadame nöp mɨdmɨdal rö bɨ ap apöm mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pen kiŋ Herod nɨpe nɨŋöm haga, “U Jon bɨ ñɨg pak ñeb nöd uŋam rɨb gɨ dö gɨnö u nöp uraköm, apöm anɨg gab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Pen nɨhön: nöd Herod, nɨmam Pilip nɨbin Herodias nɨp uda. Udö, Jon “Gɨpan anɨbu, gɨ naij gɨpan. Bɨ nuwöɫ nɨpe udagnab,” a ga. Pen Jon anɨg hagö, Herodias Jon nɨp nɨŋö mulu lugö hagö, Herod bɨ nɨpe gau rɨmnap hag yuö, amöm Jon nɨp nagɨ lɨla. Nɨbi Herodias, Jon nɨp aigö göl gem al pak lɨnam, a göm, gasɨ u nöp nɨŋmɨdöp u pen ");
INSERT INTO kpw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jon nan naij ap gagmɨdöp. Nɨpe manö nɨhön nɨhön haga u, Herod nɨŋöm manö aij yɨdun göl nöp hagöp, a göm, ñɨñɨ löm, Jon nɨpe bɨ aij ap bɨ uɫ ap mɨdöp, a göm, pɨñɨŋ göm, nɨp gɨ naij gɨnaböl, a göm, nɨp abad mɨd aij gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nɨbi Herodias, Jon nɨp al pak lɨn, a gɨ nɨŋ mɨd mɨd mañ ap, Herod nɨme nɨp yag daua pɨŋan rɨkep ñɨn u nöp, nan kub ñɨŋnɨg, gapman bɨ kub gau, ami bɨ kub gau, ram mɨnöŋ Galili bɨ kub gau wɨñ alö, nan kub ñɨŋnɨg aula. ");
INSERT INTO kpw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Apöm nan ñɨŋlö nɨŋöl gɨ, Herodias pai nɨpe u raul mɨgan anɨbu apöm kugom ralö, Herod abe, bɨ kub ap mɨdeila gau abe nɨŋlö, kalɨp aij gö, kiŋ Herod pai anɨbu nɨp haga, “Gɨpan anɨbu, nan nɨhön hag nɨŋeinabön nöp ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pen manö kƚö manö nɨŋö nöp hagöm haga, “Yad nöp manö nɨŋö yabɨƚ hagabin. Ram mɨnöŋ kub abad mɨdpin i hag nɨŋö, nöp naböŋ u hagnö abad mɨdeinabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Anɨg hagö, pai u amöm nɨme Herodias nɨp, nan nɨhön u hag nɨŋnam, a gɨ nɨŋö, nɨme pen haga, “Jon bɨ ñɨg pak ñeb nabɨc cög magö nɨpe u hagmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nɨme anɨg hagö, adɨŋ pai nɨpe yɨŋɨd kiŋ Herod mɨdeia au amöm haga, “Uri magö i nöp, Jon bɨ ñɨg pak ñeb nabɨc cög magö nɨpe u ud kɨnaŋ cög mɨgan ap lɨmön, yɨp dap ñɨ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Anɨg hagö, kiŋ Herod Jon nɨp gasɨ nɨŋö, mög yabɨƚ ga. Pen nɨpe bɨ kub gau nɨŋ mɨdlö nɨŋlö gɨ, manö kƚö manö nɨŋö pai u nɨp haga u nöp gasɨ nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","magö anɨbu nöp ami bɨ nɨpe ap, “Am Jon nabɨc cög magö u daumön,” a göm hag yuö, am Jon nɨp nabɨc cög magö u rɨb gɨ dö göm, ");
INSERT INTO kpw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ud kɨnaŋ cög mɨgan ap löm, dapöm pai anɨbu nɨp ñö, nɨpe pen damöm nɨme nɨp ña. ");
INSERT INTO kpw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pen Jon bɨ nɨpe gau, Jon nɨp uŋam rɨb gɨ dö gɨla manö u nɨŋöm, kale am wip damöm, kabö mɨgan au rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas manö ud arep bɨ gau, kale gau gau wög gɨ ajöl göm, ado gɨ apöm, nɨbi bɨ gau kalɨp manö nɨhön nɨhön hag ñöm, nan nɨhön nɨhön gɨla gau, magöŋhalö Jisas nɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pen nɨbi bɨ iru yabɨƚ nöp amɨl apɨl geila u me, Jisas bɨ nɨpe gau aip nan ñɨŋöl rö lagö, nɨpe kalɨp haga, “Hon, nɨbi bɨ mɨdagpal aŋ au amun, yɨharɨŋ mɨdaiun, kale magö ap ake lɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Anɨg hagöm, bɨ nɨpe gau aip ñɨg magɨb udöm, ram mɨnöŋ nɨbi bɨ mɨdagmɨdal au arla. ");
INSERT INTO kpw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pen kale ñɨg magɨb ud arlö nɨŋöl gɨ, nɨbi bɨ iru nöp, Jisas bɨ nɨpe gau aip gau araböl a göm, daun gau nɨbö gau nɨbö dip gɨ dö gɨ aramöm, ñɨg goƚ adö adan mɨlö u nöd amöm, Jisas bɨ nɨpe gau aip arnɨg geila gau, nöd am mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas bɨ nɨpe gau aip ñɨg goƚ au amjak pɨdöŋ göm, ñɨg magɨb arö göm, nɨbi bɨ iru mɨdeila gau kalɨp nɨŋöm gasɨ nɨpe ke gasɨ nɨŋöm nɨŋa, kale kaj sipsip bɨ abad mɨdep ap mɨdagöp rö u mɨdeila. Anɨbu nɨŋö, mög gö, nɨpe iƚ göm kalɨp manö rɨmnap rapɨn hag ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sɨdö hadö wad ara nɨŋöm bɨ nɨpe gau apöm nɨp hagla, “Sɨdö hadö wad aröp. Aui ram mɨnöŋ nöp aŋ aui. ");
INSERT INTO kpw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Anɨb u, nɨbi bɨ gai i hag yuö, kale am ram rɨƚɨg agƚö ram mɨnöŋ yöp söl gai i aramöm, nan magö kale rɨmnap rau ñɨŋlaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hageila, Jisas haga, “Kale ke kalɨp nan magö rɨmnap ñɨmim,” a ga. Hageia hagla, “Anɨg hagpan u, bɨ rakɨn unbö raleb jɨŋ wög göm mani udpal rö udun nan magö rau dapun, kalɨp ñun aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hageila, Jisas haga, “Bred magö kale aigöl gɨ rö mɨdöp? Am nɨŋim!” a ga. Hageia, am nɨŋöm hagla, “Hon bred magö unbö mamɨd u, kabsaƚ mɨhöp halö mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anɨg hageila, Jisas haga, “Nɨbi bɨ gai i hagpe, asɨk balu ke ke löm, nan uɫaŋ adö gai i asɨk mɨdlö araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hagö, nɨbi bɨ gau kalɨp haglö, rɨmnap ñɨn juöl mɨhau ado gɨ da sɨduŋ laŋ (50) rö magum balu löm, rɨmnap ugan nɨbi bɨ ñɨn juöl unbö mamɨd u (100) rö balu lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pen Jisas nɨpe bred magö unbö mamɨd u abe, kabsaƚ mɨhau abe udöm, kumi kabö adö laŋ au nɨŋöm, God nɨp, aij a göm, bred u ud jö göm, bɨ nɨpe gau kalɨp ñö, kale pen nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. Kabsaƚ mɨhau u, u rö nöp bɨ nɨpe gau ñö, nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ñeila, ñɨŋlö ñɨŋlö, kalɨp mudun ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nan adɨŋ adɨŋ arö gɨla gau, Jisas bɨ nɨpe gau wadɨ udöm yaglö yaglö, wadɨ unbö mɨgan laŋ ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nan ñɨŋla ñɨn anɨbu, bɨ gau nöp me, paip dausan ara. ");
INSERT INTO kpw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pen magö anɨbu nöp Jisas bɨ nɨpe gau kalɨp hagö, ñɨg magɨb udöm Bedsaida daun nö lödaŋ arlö nɨŋöl gɨ, Jisas au mɨdöm nɨbi bɨ gau kalɨp hag yuö arla. ");
INSERT INTO kpw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hag yuöm, dum nö ilö ap gɨlaŋ gɨ amöm, God nɨp sabe gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Sɨbön gɨnɨg ga magö u, Jisas nöp mɨdöm nɨŋa, bɨ nɨpe gau kale ñɨg magɨb udöm, ñɨg aŋ au daŋ arlö nɨŋöl gɨ, hadal u areila lau adö auö, uɫham ñɨg uɫ adö laŋ pɨrɨk göl gɨ areila. Ram jɨn parɨka magö u, Jisas ñɨg uɫ ado laŋ au amöm, kalɨp abhak löm, arnɨg gö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","nɨp ñɨg uɫ adö laŋ au areia u nɨŋöm, u wip ana ap a göm, anɨnɨn gö pɨñɨŋ göm aiö gauƚ gɨla. Adɨŋ Jisas kalɨp haga, “Pɨñɨŋ gagmim! Yad nöp auabin! Gasɨ iru nɨŋagmim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hagöm, ñɨg magɨb mɨgan arö, hadal udeia u ur ga. Anɨg gö, Jisas nɨpe aigöl göm anɨg göp, a göm, gasɨ iru yabɨƚ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nɨpe bred udöm nɨbi bɨ iru nöp nɨme lɨ ña u nɨŋla u pen ñɨn anɨbu Jisas nɨp nɨŋ ud aij gagla. ");
INSERT INTO kpw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pen ñɨg aŋ u am am ram mɨnöŋ Genesared amjaköm, ñɨg magɨb u nagɨ adɨk lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ñɨg magɨb au arɨk arlö nɨŋöl gɨ, nɨbi bɨ anɨb gau Jisas auöp, a gɨlö nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","yɨŋɨd ram mɨnöŋ gau gau kɨd kɨd amöm, nɨbi bɨ nan ga gau kalɨp dam Jisas am mɨdeia au areila. ");
INSERT INTO kpw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ñɨn anɨb gau, Jisas ram rɨƚɨg agƚö gau aka daun gau aka ram mɨnöŋ yɨharɨŋ gau amjakö, nɨbi bɨ nan ga gau kalɨp dap maker aŋ au löm, Jisas nɨp neb neb göm hagla, “Ne mɨdö, nɨbi bɨ nan göp gau, waƚɨj adɨŋ nöp u ud nɨŋlö, kalɨp kamɨŋ laŋ,” a gɨla. Jisas yau a ga nɨŋöm nɨbi bɨ nɨp ud nɨŋla gau kalɨp magöŋhalö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bɨ Perisi rɨmnap, bɨ lo manö hag ñeb rɨmnap, Jerusalem nɨbö apöm, Jisas mɨdeia au nɨŋ mɨdöm nɨŋla, ");
INSERT INTO kpw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jisas bɨ nɨpe rɨmnap, nɨpɨs nɨhi bɨ asɨ masɨ gɨ aij göm, nan ñɨŋmɨdal rö, gagla. ");
INSERT INTO kpw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Perisi bɨ gau abe, Juda nɨbi bɨ gau magöŋhalö abe, nɨpɨs nɨhi bɨ hagmɨdal rö nɨŋöm, ñɨmagö ñɨg lɨ yuöm nöp, nan ñɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maker aŋ au am mɨdöm, ram ado gɨ apöm, u rö nöp ñɨg lɨ yuöm nöp, nan ñɨŋbal. Pen kap, rin cög, kapa nan gau u rö nöp ñɨg lɨ yuöm nöp, nan ñɨŋbal. Nan anɨbu rö magöŋhalö kƚiñ aij gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anɨb u, Jisas bɨ nɨpe gau nan yɨharɨŋ ñɨŋla u nɨŋöm, bɨ Perisi gau abe, bɨ lo manö hag ñeb gau abe Jisas nɨp hagla, “Bɨ ne gau nɨhön gɨnɨg, apɨs bac bɨ hagla rö, ñɨmagö kale u ñɨg lɨ yuöm wasö, yɨharɨŋ nöp nan ñɨŋaböl?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hageila, Jisas haga, “Kale manö piral hagpim u, Aisaia manö nɨŋö yabɨƚ hagöm, God Manö u kalɨ kƚiñ rɨköm haga, ‘Nɨbi bɨ gai i, God hib hagno adö arab a gɨpal u pen yɨharɨŋ manö nöp hagal; yɨp mɨdmagö lagpal. ");
INSERT INTO kpw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","God lo manö u hag ñabun, a gɨpal u pen nɨbi bɨ manö kale ke hagpal manö u nöp hag ñaböl. Anɨb u, yɨp sabe göm hib yad haglö adö aragab. Yɨharɨŋ manö nöp hagaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anɨb u rö, kale God manö hag la u arö gɨmim, nɨbi bɨ manö kale ke hagpal u udmim, nap nahai bɨ hagmɨdal adö u hain gɨmim gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas kalɨp kauyaŋ hagöm haga, “Kale gasɨ kɨd hiɨk nɨŋmim, God manö hag la u ud ke gau yumim, gasɨ magö kalpe ke u nöp nɨŋ udmim hain gabim. ");
INSERT INTO kpw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosɨs God Manö adɨŋ ap kalɨ kƚiñ rɨköm haga, ‘Name nap hagmil rö nɨŋ udmim, kalɨp ud aij gɨmim; pen ñɨ pai rɨmnap nɨme nap kalɨp manö mulu kal lugö hagaiöl, al pak lɨbe umöl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pen kale manö adö anɨbu kabö göl hag ñagpim. Bɨ ap, ami bapi arö gɨnabin, a gɨnab u, kalɨp hagnab, ‘Ami bapi, yad nan aij rɨmnap kalpe mɨhöŋ ñɨbnep pen mani kalpe mɨhöŋ ñeb mani u, uri yad God nɨp ñɨnabin, a gɨpin u me, mani kalpe mɨhöŋ ñeb ap mɨdagöp,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Anɨg gɨlö, kale nɨŋmim hagnabim, ‘Kale anɨg gɨpal u, manö mɨdagöp,’ a gɨnabim. Anɨg hagpe, kale God manö haga u arö göm, nan aij rɨmnap nɨme nap kalɨp ñagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anɨb u, gasɨ magö kalpe ke u nöp nɨŋmim, hain gɨmim, bɨ hain nɨbö rɨmnap halö hag ñɨbe, kale pen u rö nöp bɨ hain nɨbö rɨmnap hag ñɨlö, hag ñɨ dam dapɨl gɨlö nɨŋöl gɨ, God Manö nan yɨharɨŋ rö ud ke gau yubal. Pen nɨme nap manö hagajɨn u nöp wasö; kale nan iru nöp anɨg unbö rö nöp gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas anɨg hagöm, nɨbi bɨ iru nöp mɨdeila gau kalɨp hagö, nɨpe mɨdeia iƚ au aueila haga, “Manö hagnɨg gabin i kale magöŋhalö nɨŋmim, manö iƚ rɨk nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kale nan ñɨŋbe aŋ yaŋ arnab u prɨ mɨdageinab; nan hibur mɨdmagö aŋ kale daŋ nɨbö höŋ aunab u nöp gö, kale gac halö mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas anɨg hagöm, nɨbi bɨ gau kalɨp arö göm, ram raul mɨgan arö, bɨ nɨpe gau nɨp hag nɨŋla, “Manö hod rɨkmön hagpan anɨbu, iƚ u nɨhön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hageila, haga, “Nɨbi bɨ gau kale nɨŋagpal rö, kale u rö nöp nɨŋagpim ar? Nan asɨ masɨ gɨpal gau, haƚöwaƚö ñɨŋlö, hibur aŋ yaŋ arö, God nɨŋö prɨ mɨdageinab. ");
INSERT INTO kpw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pen nɨhön: nan ñɨŋbal anɨb gau, mɨdmagö aŋ yaŋ aragnab; hibur aŋ yaŋ nöp arö, hib halö kɨl yunaböl,” a ga. Jisas manö haga anɨbu, nan gau magöŋhalö ñɨŋeb nöp, asɨ masɨ gep rɨmnap mɨdagöp, a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pen Jisas anɨg hagöm haga, “Gasɨ naij aŋ kale yaŋ nɨbö aunab u me, nɨbi bɨ gac halö mɨdnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nɨbi bɨ gau aŋ kalɨp yaŋ gasɨ naij auö nɨŋöl gɨ, kale gɨ naij göm, nan si udöm, wip alöm, nɨbi si bɨ si göm, ");
INSERT INTO kpw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nan gau hon rö laŋ, a göm, nɨbi bɨ rɨmnap gasɨ naij nɨŋöm, manö piral hagöm, manö naij hagöm, nan gau yad rö lagöp, a gö, mulu lugö, nɨbi bɨ hag juöm, hib kale ke dap ranöm, haƚöwaƚö göm, naij gep gasɨ añɨ nɨŋöm gɨpal. ");
INSERT INTO kpw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nan naij gɨpal anɨb gau gasɨ ke gau nɨbö auagöp, gasɨ naij aŋ kale yaŋ nɨbö aunab u me, nɨbi bɨ gac halö mɨdnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas ram mɨnöŋ anɨbu arö göm, am ram mɨnöŋ daun kub Daia söl anɨb au ara. Amöm, nɨbi bɨ gau yɨp mɨñi nɨŋagöl, a göm, ram raul mɨgan ap amöm pi göl mɨdeia u pen pi göl mɨdainɨm rö laga. ");
INSERT INTO kpw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nɨbi ap, pai nɨpe nɨp kɨjaki abaŋ ala u me, Jisas auöp, a gɨlö, nɨpe amöm Jisas mɨdeia au ma iƚ nɨp au kugom yɨmöm, ");
INSERT INTO kpw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jisas nɨp neb neb göl gɨ haga, “Pai yad kɨjaki abaŋ alöp u, hag höŋ yu araŋ,” a ga. Nɨbi anɨbu nɨpe Juda nɨbi wasö. Nɨpe yag daula ram mɨnöŋ Pönisia, bɨ ram mɨnöŋ Siria nɨbö abad mɨdmɨdal u. ");
INSERT INTO kpw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pen anɨg hageia, Jisas nɨp haga, “Nöd ñɨ pai nan ñɨŋlö, mudun gɨnab, aij. Nan magö ñɨ pai ñeb u udun, kain yunabun u aij gagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hageia, nɨbi u pen haga, “Bɨ Kub! U aij hagpan u pen ñɨ pai gau nan ñɨŋlö, naböŋ naböŋ gau abañ mo gau lugö, kain gau halö ñɨŋnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hageia, Jisas manö anɨbu nɨŋöm haga, “Ne anɨg hagpan u, pai ne kɨjaki yuö hiɨköm mɨdajɨp u hadö höŋ aröp; ne aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jisas anɨg hagö, nɨbi anɨbu ado gɨ amöm nɨŋa, kɨjaki arɨk höŋ arö, pai nɨpe köp adö au agamɨj han mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ram mɨnöŋ daun kub Daia söl anɨb au arö göm, am ram mɨnöŋ daun kub Saidon söl anɨb au paköm, ram mɨnöŋ Dekapolis aŋ gau amöm, Ñɨg Waŋö Galili ara. ");
INSERT INTO kpw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amjakö nɨŋöl gɨ, nɨbi bɨ gau bɨ rɨmɨd pɨƚ ga manö hag aij gagmɨdöp bɨ ap dapöm, Jisas nɨp neb neb göm hagla, “Bɨ i nɨp ud nɨŋö, kamɨŋ laŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hageila, Jisas bɨ anɨbu nɨp uɫ gɨ ke ke au amöm, ñɨmagö mɨlö nɨpe u rɨmɨd mɨgan nɨp u yuöm, ñɨmagö kɨñu alöm, aɫab nɨp u ud nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kumi kabö laŋ nɨŋöm, ake löl göm, “Epada!” a ga. Manö yöl hagöm, “Epada,” a ga u, manö iƚ u “Hiɨk,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Anɨg hagö nɨŋöl gɨ, bɨ anɨbu rɨmɨd mɨgan u pɨral hiɨköm, maj mɨgan pɨɫa gö nɨŋöl gɨ, manö kabö göl haga. ");
INSERT INTO kpw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas pen nɨbi bɨ gau kalɨp haga, “Manö anɨbu nɨbi bɨ rɨmnap kalɨp hag ñagmim,” a ga. Manö anɨbu manö kƚö göm haga u pen kale am kƚö göm nɨbi bɨ iru nöp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Manö anɨbu hag ñeila nɨbi bɨ nɨŋöm aiö göm hagla, “Jisas nan gau magöŋhalö gajɨp aij yabɨƚ göp. Nɨpe nɨbi bɨ rɨmɨd pɨƚ göp gau gö, pɨral hiɨköm, nɨbi bɨ aɫab mɨŋör göp gau gö manö hag aij gɨpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñɨn aŋ anɨb au nöp, nɨbi bɨ iru nöp ap mɨdlö, nan magö mɨdagö, Jisas bɨ nɨpe gau wɨñ alö aueila haga, ");
INSERT INTO kpw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yad nɨbi bɨ gai i kalɨp mög nɨŋabin. Ñɨn mɨhau nɨgaŋ yad aip mɨdöm, yɨharɨŋ mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kalɨp kɨyö nöp hag yunö, rɨmnap mɨlö gau nɨbö aubal rö, adan aŋ gau amöm, amgö mɨmainö udö, lug paknaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hageia, bɨ nɨpe gau hagla, “Ram mɨnöŋ nöp aŋ anɨb gai i, nan magö gai nɨbö udun ñun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hageila, Jisas haga, “Bred magö kale aigöl gɨ rö mɨdöp?” ö ga. Hageia hagla, “Unbö mudun jɨŋ u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anɨg haglö, Jisas nɨbi bɨ gau kalɨp hagö, asɨklö nɨŋöl gɨ, bred magö unbö mudun jɨŋ anɨbu udöm, God nɨp aij, a göm, ud jö göm, bɨ nɨpe gau kalɨp ñö, kale pen udöl gɨ, nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kabsaƚ pro bad ap ud mɨdeila u, u rö nöp udöm, God nɨp aij a göm, bɨ nɨpe gau kalɨp ñö, nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ñɨlö, ñɨŋlö ñɨŋlö kalɨp mudun gö, naböŋ naböŋ pali pali gɨla gau, Jisas bɨ nɨpe gau wadɨ unbö mudun jɨŋ u yaglö ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bɨ nan ñɨŋla anɨb gau, po dausan rö. Jisas pen, nɨbi bɨ anɨb gau kalɨp hag yuöm, ");
INSERT INTO kpw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bɨ nɨpe gau aip ñɨg magɨb udöm, ram mɨnöŋ Dalmanuda arla. ");
INSERT INTO kpw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɨ Perisi rɨmnap Jisas nɨp neb neb gɨno, nɨhön rö hagnɨm, a göm, apöm nɨp aip manö hag amɨl apɨl göm hagla, “Nan gagep rö ap kumi kabö adö laŋ au gö, nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Anɨg haglö, Jisas ake löl göm haga, “Nɨbi bɨ mɨñi mɨdpal ñɨn i, nɨhön gɨnɨg hagpal, ‘Nan gagep rö ap gö nɨŋun,’ a gɨpal? Yad kalöp nɨŋö yabɨƚ hagabin, kalöp nan gagep rö ap gɨnö, nɨŋagnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anɨg hagöm, kalɨp arö göm, bɨ nɨpe gau aip ñɨg magɨb udöm, ñɨg waŋö böŋ lödaŋ arla. ");
INSERT INTO kpw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pen bɨ nɨpe gau hauƚ göm, bred iru wasö, magö añɨ ap nöp ud ñɨg magɨb löm, ud arla. ");
INSERT INTO kpw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aŋ gau amöl gɨ, Jisas kalɨp haga, “Perisi yɨs kale u abe, Herod yɨs nɨpe u abe, nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anɨg hagö, bɨ nɨpe gau kale ke hag nɨŋ hag nɨŋ göm hagla, “Bred magö rɨmnap halö dauagpun rö hagab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas pen kale hagla anɨbu ke nɨŋöm haga, “Nɨhön gɨnɨg bred magö dauagpun, a gɨmim, hagabim? Kale manö nɨŋmim, iƚ u nɨŋagpim ar? ");
INSERT INTO kpw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amgö la u nɨŋagpim? Rɨmɨd la u nɨŋagpim? Aka nɨŋmim hauƚ gɨpim? ");
INSERT INTO kpw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bɨ paip dausan mɨdeila ñɨn u, bred magö unbö mamɨd u ud jö gɨ ñɨnö, ñɨŋöm naböŋ naböŋ arö gɨla gau, wadɨ aigöl gɨ rö yagpe?” ö ga. Hageia hagla, “Wadɨ unbö mɨgan laŋ yagno,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Anɨg hageila haga, “Pen bɨ po dausan mɨdeila ñɨn u, bred magö unbö mudun jɨŋ u ud jö gɨ ñɨnö, ñɨŋöm naböŋ naböŋ arö gɨla gau, wadɨ aigöl gɨ rö yagpe?” ö ga. Hageia hagla, “Wadɨ unbö mudun jɨŋ u yagno,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hageila haga, “Pen kale nɨŋmim, nɨŋ aij gagpim ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pen kale Bedsaida daun amjaklö nɨŋöl gɨ, nɨbi bɨ rɨmnap bɨ amgö we ga ap dapöm, Jisas nɨp neb neb göm hagla, “Nɨp ud nöŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hageila, Jisas bɨ amgö we anɨbu nɨp ñɨmagö kɨd u udöm, uɫ gɨ ram rɨƚɨg agƚö goƚ au amöm, amgö nɨp u kɨñu alöm, nɨp ud nɨŋöm, haga, “Amgö ne nan rɨmnap nɨŋabön aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hageia haga, “Yau. Nɨbi bɨ gau nɨŋabin u, pen mab ur rö gau gɨ ajaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hagö, Jisas kauyaŋ amgö magö nɨpe ud nɨŋö, adɨŋ nan gau magöŋhalö nɨŋ aij yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pen Jisas bɨ anɨbu nɨp haga, “Kauyaŋ ado gɨ ram rɨƚɨg agƚö nɨbi bɨ mɨdpal lödaŋ aragmön; ram ne yɨdun göl aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas bɨ nɨpe gau aip ram rɨƚɨg agƚö daun kub Sisaria Pilipai söl au arla. Adan aŋ au amöl gɨ kalɨp haga, “Nɨbi bɨ gau, yɨp an a göm nɨŋbal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hageia hagla, “Nɨbi bɨ rɨmnap nöp Jon bɨ ñɨg pak ñeb u, a gɨpal; rɨmnap Ilaija, a gɨpal; rɨmnap bɨ God manö hagep ap, a gɨpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hageila, Jisas kalɨp haga, “Kale ke pen yɨp an, a gɨmim, nɨŋbim?” ö ga. Hageia, Pida haga, “Ne nöp me Mesaia u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hageia, Jisas haga, “Nɨbi bɨ gau kalɨp manö anɨbu hagagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas pen bɨ nɨpe gau kalɨp manö hag ñöl gɨ haga, “Bɨ Ñɨ nɨpe ilön kub yabɨƚ udnab. Bɨ kub manö ud asɨkep gau abe, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb gau abe, nɨp nɨŋlö, mulu lugö, al pak lɨlö, nɨpe umöm, ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas manö anɨbu waiö hagö, Pida nɨŋö, aij gagö, Jisas nɨp dam goƚ au amöm, nɨp hag göl gɨ haga, “Manö anɨbu rö hagagmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pen Jisas ado göm, bɨ nɨpe gau kalɨp nɨŋöm, Pida nɨp haga, “Seden! Ke gau aru! God gasɨ ñöb rö hagagabön; nɨbi bɨ gau gasɨ nɨŋbal rö nöp nɨŋmön hagabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Anɨg hagöm, bɨ nɨpe gau abe, nɨbi bɨ iru nöp mɨdeila gau abe, wɨñ alö, iƚ au aueila haga, “Nɨbi bɨ an an yɨp pɨg mɨdnɨg göl gau, nan nɨhön mɨnöŋ naböŋ adö iƚ i gasɨ kub nɨŋbal u arö göm, hañ romaŋ kale ke gasɨ kub nɨŋbal u arö göm, mab kros ud kag göm yɨp hain göl. ");
INSERT INTO kpw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nɨbi bɨ, Jisas nɨp nɨŋ ud mɨdno, aij gagnab a göm nɨŋnaböl gau, böŋ nöp ap lug paknaböl. Pen nɨbi bɨ, Jisas nɨp udun, manö aij nɨpe nɨŋ ud mɨdno, hanɨp gɨ naij gɨnaböl u, manö mɨdagöp a göm gɨlö arnab gau, God gö pör nöp pör nöp mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Pen nɨbi bɨ, nan aij mɨnöŋ naböŋ adö iƚ i iru nöp udun a göm gɨlö arö, ram mɨnöŋ iƚ i mɨdöp nan gau magöŋhalö udnaböl u pen pör mɨdep u udagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nan aij gau magöŋhalö dam sɨkim göm, pör mɨdep u rauöl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Anɨb u, nɨbi bɨ an, nɨbi bɨ nan si nan naij gɨpal aŋ au mɨdöl gɨ, nable gɨnɨm rö lö, ‘Jisas nɨp nɨŋagpun,’ a gɨnaböl gau, hainö Bɨ Ñɨ nɨpe Nap mailö aij unbö ke udöm, ejol uɫ gau halö aunab ñɨn u, nɨpe kalɨp u rö nöp nable gö, ‘Nɨbi bɨ gau kalɨp nɨŋagpin,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pen Jisas anɨg hagöm, manö ap haga, “Yad kalöp manö nɨŋö hagabin, kale nɨbi bɨ mɨdpim gai i rɨmnap kamɨŋ mɨdpe nɨŋöl gɨ, God nɨbi bɨ udöm abad mɨdeinab ñɨn u, kƚö kub halö auö nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pen hainö ñɨn unbö kagoƚ jɨŋ u mɨdöm, Jisas nɨpe Pida Jems Jon kalɨp yam uɫ gɨ, ram mɨnöŋ nɨbi bɨ mɨdageila dum ilö laŋ ap gɨlaŋ gɨ arla. Amöm, Jisas nɨp nɨŋlö nɨŋöl gɨ, hañ romaŋ nɨpe u ke yabɨƚ la. ");
INSERT INTO kpw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Waƚɨj nɨpe u rud aij ke yabɨƚ löm, mɨmailö yabɨƚ ga. Pen nɨbi bɨ mɨnöŋ naböŋ adö iƚ i ap waƚɨj rɨmnap ñɨg löm uɫ maɫɨ gɨlö, rud anɨbu rö lɨnɨm rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pen magö anɨbu nɨŋla, Ilaija aip Mosɨs aip apil Jisas aip manö hagailö. ");
INSERT INTO kpw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kale nɨŋöm, Pida Jisas nɨp haga, “Manö hag ñeb bɨ, hon aij yabɨƚ ap aui mɨdpun! Anɨb u, hon ram bada bad mɨhau nɨgaŋ gun; nöp ap, Mosɨs nɨp ap, Ilaija nɨp ap,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kale pɨñɨŋ geila rö me, Pida gasɨ nɨŋ aij göm wasö, haƚöwaƚö anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pen kumi bad ap apöm, kalɨp ud yuö yuö nɨŋöl gɨ, manö ap kumi aŋ anɨb au haga, “U Ñɨ mɨdmagö yad yabɨƚ. Manö hagnab rö nɨŋim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anɨg hagö nɨŋöl gɨ, kale nɨŋ gɨgabö göm nɨŋla, bɨ anɨb mɨhau mɨdagailö; Jisas nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pen kale dum laŋ arö göm, ap lugöl gɨ, Jisas haga, “Dum i auajun nan gajɨp nɨŋbim u, mɨñi nɨbi bɨ rɨmnap kalɨp hag ñagmim. Hainö Bɨ Ñɨ nɨpe umöm urakainɨm u, waiö hag ñɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hagö, bɨ nɨpe gau nɨbi bɨ rɨmnap kalɨp hag ñagla; kale ke nöp hag nɨŋ hag nɨŋ göm hagla, “Umem uraknabin, a göp u, manö iƚ u nɨhön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Anɨg hagöm, Jisas nɨp hag nɨŋöm hagla, “Bɨ lo manö hag ñeb bɨ gau nɨhön gɨnɨg hagpal, ‘Ilaija nöd aunab,’ a gɨpal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hageila, Jisas haga, “Nɨŋö hagpal. God Manö u kalɨ kƚiñ rɨköm hagla, ‘Bɨ Ilaija nöd apöm nan gau gɨ jɨn geinab,’ a gɨla. Pen God Manö u manö ap kalɨ kƚiñ rɨköm hagla, ‘Nɨbi bɨ gau Bɨ Ñɨ nɨpe nɨp udagöm, nɨp ilön kub ñɨnaböl,’ a gɨla manö u, nɨhön gɨnɨg anɨg hagla, a gɨmim, nɨŋbim? ");
INSERT INTO kpw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pen Ilaija hagla anɨbu, hainö aunab, a gɨmim, gasɨ u nɨŋagmim. Nɨp nöd yag daulö, kub göm, manö hag ñö nɨŋöl gɨ, gasɨ kale ke nɨŋöm nɨp abönamö gɨ naij yabɨƚ gɨla. Anɨb u, God Manö u kalɨ kƚiñ rɨköm, nɨp gɨnaböl, a gɨla rö nöp gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pen kale ban yaŋ amöm nɨŋla, bɨ lo manö hag ñeb bɨ rɨmnap, Jisas bɨ nɨpe unbö ajɨp gau aip pen pen hag mɨdlö nɨŋöl gɨ, nɨbi bɨ iru nöp apöm, kalɨp ud yuö yuöm nɨŋöl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Anɨg gɨ nɨŋmɨdlö nɨŋöl gɨ, Jisas apjakaiö, nɨbi bɨ ap mɨdeila gau, aiö göm, am nɨp hag wɨhai udla. ");
INSERT INTO kpw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas bɨ nɨpe gau kalɨp hag nɨŋöm haga, “Nɨhön gɨnɨg pen hagö pen hagö gajim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Anɨg hagö nɨŋöl gɨ, bɨ ap nɨbi bɨ mɨdeila aŋ anɨb au haga, “Manö hag ñeb bɨ. Ñɨ yad u, kɨjaki abaŋ alö, manö gagöp. ");
INSERT INTO kpw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ñɨn rɨmnap nɨp rapɨn gö, ap lug paköm, kɨñu habkob gaɫ goɫ apöm, meg hip yɨmöm, ñɨmagö ma hañ romaŋ iñ göm göp. Pör anɨg gö gö me, daubin u pen bɨ ne gau kalɨp hagnö, kɨjaki u hag yu wasö nɨŋöm arö gɨpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Anɨg hageia, Jisas kalɨp haga, “Kale nɨbi bɨ mɨñi mɨdpim i God nɨp nɨŋ ud pɨdöŋ gagpim. Ñɨn mai nɨp nɨŋ udmim, nan anɨb gau ke gɨnabim? Manö pör hagnö nɨŋbim u, aige göl gem manö kƚiñ halö hagnö nɨŋnabim? Ñɨ anɨbu ud mɨdpin i dauim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hagö, dam Jisas mɨdeia iƚ au daulö, kɨjaki ñɨ anɨbu nɨp abaŋ ala u, Jisas nɨp nɨŋöm, ñɨ u nɨp gö, ap lug paköm, ado malo göl gɨ, kɨñu habkob gaɫ goɫ apöm luga. ");
INSERT INTO kpw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Anɨg gö, Jisas ñɨ anɨbu nap nɨp hag nɨŋöm haga, “Nan anɨbu ñɨn mai rö ga?” ö ga. Hageia haga, “Hadame nöp ñɨ pro magö u nöp ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kɨjaki anɨbu, nɨp pör al pak lɨn, a göm, mab inab aŋ gau abe, ñɨg aŋ gau abe ud yuöp. Anɨb u, halɨp apɨl mög nɨŋmön, nan anɨbu hag yuep rö lainɨm u, hag yu,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hageia, Jisas haga, “Yɨp nɨhön gɨnɨg, ‘Hag yuep rö lainɨm u, hag yu,’ a gɨmön hagabön? Hag nɨŋnabin rö gɨnab, a gɨ gasɨ nɨŋnabön u, hag nɨŋnabön u rö gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hageia, ñɨ nap u yɨŋɨd nöp haga, “Nöp nɨŋ udpin; anɨg gɨnabön, a gem, gasɨ u nɨŋbin u pen gasɨ mɨhöp nɨŋnam rö löp u, yɨp gasɨ aij ñɨmön nɨŋem yad böŋ nöp nɨŋ udnam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pen nɨbi bɨ iru nöp, apil mɨhau Jisas aip mɨdeila au, gɨ dö gɨ aueila nɨŋöm Jisas kɨjaki u nɨp haga, “Ne kɨjaki, nɨbi bɨ gö rɨmɨd hauƚ alö manö hagagnaböl u, nöp hagabin, ñɨ u nɨp arö gɨmön, böŋ nöp armön, hainö kauyaŋ ado gɨ auagmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hagö, kɨjaki anɨbu gauƚ göm, ñɨ u nɨp gö, ap lug paköm, gɨl gɨl gɨ, gɨ pɨdöŋ gö, nɨbi bɨ iru nöp hagla, “Hadö umöb,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Anɨg hagla u pen Jisas ñɨmagö ur nɨpe u udöm, nɨp ud urak ña. ");
INSERT INTO kpw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hainö Jisas ram raul mɨgan amöm, bɨ nɨpe gau aip kale nöp mɨdöl gɨ, nɨp hagla, “Nɨhön gɨnɨg hon kɨjaki anɨbu nɨp hag yu wasö nɨŋbun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hageila, Jisas haga, “Kɨjaki anɨbu rö yɨharɨŋ hag yuagnaböl; God nɨp sabe gɨlö me, höŋ arnaböl. Wasö u höŋ aragnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jisas bɨ nɨpe gau uɫ gɨ, ram mɨnöŋ anɨbu arö göm, ram mɨnöŋ Galili aŋ au amöl gɨ, bɨ yad gau kalɨp manö hag ñɨ aij gɨnam, a göm, agamɨj pi göl mɨdöl gɨ, kalɨp hag ñɨmɨdöp. Kalɨp hag ñöm haga, “Bɨ Ñɨ nɨpe nɨp mumug göm bɨ rɨmnap kalɨp ñö, nɨp al pak lɨlö, umöm, ñɨn mɨhöp mɨdöm, ñɨn mɨhöp nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nɨpe anɨg hagö nɨŋöl gɨ, manö iƚ anɨbu nɨhön, a göm, nɨp hag nɨŋblap u pen pɨrɨköm, hag nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Pen adan aŋ au amöl gɨ, Jisas bɨ nɨpe gau, “Yad nöp bɨ kub, ne bɨ kub wasö,” a göl gɨ, pen pen haglö ara. Am Kapaneam amjaköm, ram raul u amöm, Jisas kalɨp hag nɨŋöm, haga, “Adan aŋ au apöl gɨ, manö nɨhön hagpe auajɨp?” ö ga. Hagö, bɨ nɨpe gau manö anɨbu hag nɨŋöl göm aula u nɨŋöm, nable gö, pen hag ñagla. ");
INSERT INTO kpw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hag ñageila, Jisas am asɨköm, bɨ nɨpe unbö mɨgan laŋ gau kalɨp hagö aueila haga, “Nɨbi bɨ kub mɨdnɨg göl gau, nɨbi bɨ yɨharɨŋ wög gɨ ñɨbal rö mɨdöm, nɨbi bɨ rɨmnap kalɨp magöŋhalö wög gɨ ñöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Anɨg hagöm, ñɨ pai pro ap dapöm mɨdeila aŋ au löm, wabi göl gɨ, haga, ");
INSERT INTO kpw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nɨbi bɨ yɨp nɨŋ udöm, ñɨ pai pro i rö añɨ ap ud aij gɨnaböl u, ñɨ u nɨp nöp wasö, yad abe udnaböl. Pen yɨp udnaböl u, yɨp nöp wasö, Bapi yɨp hag yuö aunö u nɨp abe udnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pen Jon Jisas nɨp haga, “Manö hag ñeb bɨ. Bɨ ap hib ne hagöm, kɨjaki aiön pi hag höŋ yuö nɨŋun nɨp hagno, ‘Ne bɨ hon aip jɨm ñöl ajagpun u, anɨg gagmön,’ a gɨno,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hageia, Jisas nɨp pen haga, “Nɨp nɨhön gɨnɨg wasö gɨpe? Nɨbi bɨ yɨp gasɨ nɨŋöm, hib yad hagöm, nan gagep rö rɨmnap gɨnaböl gau, hainö ado göm yɨp manö naij hagagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɨbi bɨ koƚmaƚ hon gagnaböl gau, kale nɨbi bɨ nɨŋeb hon. ");
INSERT INTO kpw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pen nɨŋim! Nɨbi bɨ an, kalöp Jisas bɨ nɨpe, a göm, ñɨg mɨl ñɨlö ñɨŋnabim u, God kalɨp ud aij gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pen nɨbi bɨ rɨmnap apöm, ñɨ pai yɨp nɨŋ udpal gau, kalɨp nan si nan naij adö u gɨ yamlö, kale gasɨ yɨp u hauƚ göm, nan si nan naij gɨnaböl. Nɨbi bɨ anɨg gɨnɨg geinaböl u, nöd kabö kub ap uŋam u nagɨ ud lɨ rɨbɨköm, dam ñɨg solwara aŋ au yublap u aij. Pen kamɨŋ mɨdöm, anɨg gɨ naij gɨnaböl u, ilön kub yabɨƚ udnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jisas anɨg hagöm haga, “Ñɨmagö ap gö, kale nan si nan naij gɨnɨg gabim u, ñɨmagö böŋ anɨb lau rɨb gɨ dö gɨ yube, böŋ lau u nöp mɨdainɨm. Anɨg gɨmim, nan si nan naij anɨbu gagnabim rö, kamɨŋ arnabim. Pen ñɨmagö mɨhöŋgöl mɨdö, gɨ naij gɨmim, ram mɨnöŋ Hel, mab pör nöp inmɨdöp au arnabim. ");
INSERT INTO kpw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ram mɨnöŋ anɨbu, ‘kalɨp gɨse pör nöp lɨ mɨdöl gɨ, mab in nöp mɨdeinab.’ ");
INSERT INTO kpw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ma kɨd u, u rö nöp. Ma kɨd ap gö, kale nan si nan naij gɨnɨg gabim u, ma kɨd böŋ anɨb lau rɨb gɨ dö gɨ yube, böŋ lau u nöp mɨdainɨm. Anɨg gɨmim, nan si nan naij anɨbu gagnabim rö, kamɨŋ arnabim. Pen ma mɨhöŋgöl mɨdö, gɨ naij gɨpe, kalöp ram mɨnöŋ Hel, mab ke inab u yuö, ilön kub udnabim. ");
INSERT INTO kpw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ram mɨnöŋ anɨbu, ‘kalɨp gɨse pör nöp lɨ mɨdöl gɨ, mab in nöp mɨdeinab.’ ");
INSERT INTO kpw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Amgö magö u, u rö nöp. Amgö magö ap gö, kale nan si nan naij gɨnɨg gabim u, amgö magö böŋ anɨb lau ud gulu gɨ yube, böŋ lau u nöp mɨdainɨm. Anɨg gɨmim, nan si nan naij anɨbu gagnabim rö, God ram mɨnöŋ nɨpe au arnabim. Pen amgö magö mɨhöŋgöl mɨdö, gɨ naij gɨpe, kalöp ram mɨnöŋ Hel, mab ke inab u yuö, ilön kub udnabim. ");
INSERT INTO kpw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ram mɨnöŋ anɨbu, ‘kalɨp gɨse pör nöp lɨ mɨdöl gɨ, mab in nöp mɨdeinab.’ ");
INSERT INTO kpw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Bɨɫ hañ run laulö in dö aij lɨnab u rö, God nɨpe nɨbi bɨ magöŋhalö kalɨp anɨg unbö rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Dö sol nan dö kal aij yabɨƚ u pen dö kal nɨpe u arö, aige göl gɨmim gɨpe, kauyaŋ dö kal gɨnab? Anɨb u, kale nɨbi bɨ dö kal rö mɨdmim, nɨbi bɨ rɨmnap mɨdmagö lɨmim, aip agamɨj mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas Kapaneam arö göm, ram mɨnöŋ Judia aŋ gau amöm, am ñɨg Jodan juöm, böŋ lödaŋ ara. Nɨbi bɨ gau nɨŋöm, ap magum geila nɨŋöm nɨpe pör gɨmɨdöp rö kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɨ Perisi rɨmnap, Jisas nɨhön rö hagnab, a göm, apöm, nɨp hag nɨŋöm hagla, “Bɨ gau nɨbi udöm, hag yunɨg, hag yunaböl aka ne nɨhön gasɨ nɨŋban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hageila, Jisas haga, “Mosɨs God Manö kalɨ kƚiñ rɨköm, kalöp manö nɨhön haga?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hageia hagla, “Mosɨs haga, ‘Nɨbi hag yunɨg, “Nöp hag yuabin,” a göm, köp bad ap kalɨ kƚiñ rɨköm nɨp ñöm, hag yunɨm,’ a ga,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hageila, Jisas haga, “Kalöp manö hag ñö, nɨŋmim, yɨŋɨd udagpim u me, Mosɨs lo manö anɨbu kalɨ kƚiñ rɨka. ");
INSERT INTO kpw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pen God ram mɨnöŋ hadame dagol gɨ la ñɨn u, bɨ gɨ löm, nɨbi gɨ löm, ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adö anɨbu me, bɨ gau nɨme nap bɨ aip mɨdöm, am nɨbi udöl gɨ, kalɨp arö göm, ");
INSERT INTO kpw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kale ber mɨhau jɨm ñöl hanlö hañ romaŋ añɨ lɨnab. Hainö ke ke wasö, jɨm ñöl nöp mɨdeinabil. ");
INSERT INTO kpw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God hagö, bɨ nɨbi udöm hañ romaŋ añɨ lɨnab anɨbu, bɨ rɨmnap am kalɨp hag pak asɨk ke ke lagöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anɨg hagöm, bɨ nɨpe gau aip kauyaŋ ram raul mɨgan yaŋ amöm, Jisas nɨp manö adö anɨbu kauyaŋ hag nɨŋeila. ");
INSERT INTO kpw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas haga, “Bɨ ap nɨbi udöm, hag yuöm, am nɨbi hain nɨbö udnab u, nɨpe nɨbi si udep bɨ. ");
INSERT INTO kpw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nɨbi u, u rö nöp, bɨ udöm, arö göm, am bɨ hain nɨbö udnab u, nɨpe bɨ si udep nɨbi,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nɨbi bɨ rɨmnap, Jisas ñɨ pai hon gau ud nɨŋaŋ, a göm, daueila, pen bɨ nɨpe gau kalɨp hag geila. ");
INSERT INTO kpw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Anɨg hageila, Jisas nɨŋö, mulu lugö, haga, “Ñɨ pai pro gau arö gɨpe, yad aulaŋ. God ram mɨnöŋ u ñɨ pai pro anɨb gau rö mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ gau, ñɨ pai pro gau God ram mɨnöŋ adö laŋ manö u nɨŋ udpal rö nɨŋ udagnaböl u, God ram mɨnöŋ nɨpe au aragnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Anɨg hagöm, ñɨ pai pro gau kalɨp ud wabi göm, ñɨmagö nɨpe nabɨc kalɨp adö laŋ löm haga, “God kalöp abad mɨdainɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pen Jisas arö nɨŋöl gɨ, bɨ ap gɨ dö gɨ apöm, Jisas mɨdeia iƚ au kugom yɨmöm, haga, “Manö hag ñeb bɨ aij yabɨƚ! Yad nɨhön gem pör mɨdep u udnabin?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hageia, Jisas haga, “Yɨp nɨhön gɨnɨg, ‘Bɨ aij yabɨƚ,’ a gɨpan? Nɨbi bɨ ap aij mɨdagpal; God añɨ me aij mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pen ne God lo manö u nɨŋban: ‘Wip alagmim; nɨbi si bɨ si gagmim; nan si udagmim; manö kub hagmim piral hagagmim; manö piral hagmim nɨbi bɨ rɨmnap nan kale gau pɨƚɨ gɨ udagmim; name nap hagmil adö u rö nöp nɨŋmim, hain gɨmim,’” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisas anɨg hagö, bɨ anɨbu Jisas nɨp haga, “Manö hag ñeb bɨ. Yad ñɨ pro nöp mɨdem, lo manö anɨb gau magöŋhalö nɨŋöl gɨ mɨdpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hagö, Jisas nɨp nɨŋöm, mɨdmagö löm, haga, “Ne nan añɨ ap nöp gagpan. Ne ammön, nan ne nɨhön nɨhön mɨdöp gau sɨkim gɨ, mani udmön, nɨbi bɨ nan mɨdagöp gau kalɨp ñɨmön. Anɨg gɨmön me, nan aij ne u mɨdeinab God ram mɨnöŋ kumi kabö adö laŋ au. Hagpin rö gɨmön, aumön, yad aip ajaiul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Anɨg hagö, bɨ anɨbu nan nɨpe iru mɨdeia rö, mög gö, gasɨ mɨlö yabɨƚ löl gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas bɨ nɨpe gau kalɨp nɨŋ gɨgabö göm haga, “Nɨbi bɨ nan iru mɨdeinab gau uɫham yabɨƚ God nɨbi bɨ nɨpe mɨdlö, kalɨp udöm ram nɨpe au abad mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anɨg hagö, bɨ nɨpe gau manö anɨbu nɨŋöm, gasɨ iru nöp nɨŋlö nɨŋöl göm, Jisas kalɨp kauyaŋ haga, “Ñɨ pai yad gai i, manö hagabin i nɨŋim. God ram mɨnöŋ u uɫham arep rö mɨdöp! ");
INSERT INTO kpw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kaj kamel gau kalɨ mauöƚ nagɨ yubal mɨgan u arnɨg, uɫham arnaböl u pen nɨbi bɨ uɫpö kɨƚno mani nan gau iru mɨdöp gau, God ram mɨnöŋ nɨpe au uɫham yabɨƚ arnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jisas anɨg hagö, bɨ nɨpe gau aiö yabɨƚ göm, pen hag nɨŋöl hag nɨŋöl göm hagla, “Anɨb u, an rö pör mɨdep u udnab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hageila, Jisas kalɨp nɨŋöl gɨ haga, “Nɨbi bɨ gau ke göl rö lagöp; God nöp me nɨhön nɨhön gɨnɨg, gɨnɨm rö nöp mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pen Pida Jisas nɨp haga, “Nöŋ! Hon ne aip ajöl gɨ, nan hon gau magöŋhalö arö gɨpun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Hageia, Jisas haga, “Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ yɨp gasɨ nɨŋöm, manö aij yad wög u gɨnɨg, ram mɨnöŋ kale arö göm aka, nɨñɨn nɨmam kale gau arö göm aka, nɨme nap kale gau arö göm aka, ñɨ pai kale gau arö göm aka, wög adɨŋ kale gau arö göm, wög yɨp geinaböl u, ");
INSERT INTO kpw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","God kalɨp ud aij gɨnab. Kalɨp abad mɨdö, mɨnöŋ naböŋ adö iƚ i mɨdeinaböl ñɨn u, ram, nɨñɨn nɨmam, nɨme nap, ñɨ pai, wög adɨŋ kale iru yabɨƚ mɨdeinab. Pen ñɨn rɨmnap nɨbi bɨ rɨmnap gau, kalɨp nɨbi bɨ yad pɨg mɨdpal u nɨŋöm, kalɨp gɨ naij gɨnaböl. Hainö pen God kalɨp dam ram mɨnöŋ nɨpe au ud arö, nɨpe aip pör nöp mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pen nɨbi bɨ uri nöd araböl gau, hainö iru nöp jöl adö yabɨƚ gau mɨdeinaböl. Pen nɨbi bɨ uri jöl adö yabɨƚ gau mɨdpal gau, hainö iru nöp nöd am mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pen kale Jerusalem amöl gɨ, Jisas nöd ga; bɨ nɨpe gau hain göm, gasɨ mɨlö mɨlö nɨŋöl gɨ areila nɨŋöm nɨbi bɨ hain aueila gau nɨŋöm pɨñɨŋ gɨla. Jisas pen bɨ nɨpe unbö mɨgan laŋ gau kalɨp nöp uɫ gɨ, goƚ au amöm, nan nɨhön nɨp gɨnɨg ga u kalɨp hag ña. ");
INSERT INTO kpw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jisas haga, “Hon Jerusalem arno nɨŋöl gɨ, bɨ ap Bɨ Ñɨ nɨpe nɨp kain gɨ dam, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe ñɨmagö kalɨp ñö, nɨp manö kub hagöm, ‘Bɨ anɨbi nɨp al pak lep,’ a göm, ud bɨ Juda wasö gau kalɨp ñɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñɨlö, nɨp hag juöm, kɨñu alöm, nagɨ ud paköm, dam böŋ nöp al pak lɨlö umnab. Pen ñɨn mɨhöp mɨdöm, ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ñɨ nɨpe mɨhau, Jems aip Jon aip apil Jisas nɨp haglö, “Manö hag ñeb bɨ, hol mɨhöŋ nöp manö ap hag nɨŋlo, ne yau a gɨmön gɨnabön u aij,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Anɨg hagailö, Jisas kalɨp haga, “Kale yɨp hag nɨŋnɨg gabil anɨbu, yad kalöp nɨhön gɨnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hageia haglö, “Hainö ne mailö aij ke halö mɨdmön, ram mɨnöŋ magöŋhalö kiŋ rö abad mɨdeinabön ñɨn u, halɨp mɨhöŋ, bɨ ap ud ñɨmagö yɨjɨg böŋ lau adö lɨmön, bɨ ap ud ñɨmagö sɨdagö böŋ lau adö lö, asɨk mɨdaiul,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Anɨg haglö, Jisas haga, “Kale mɨhöŋ nɨŋ aij gɨmil hagagabil. Ñɨg asɨ yad ñɨŋnabin u kale mɨhöŋ u rö nöp ñɨŋnabil? Yad ñɨg paknabin u, kale mɨhöŋ u rö nöp paknabil?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hageia, “Yau, anɨg gɨnabul,” a gɨlö. Hagailö, Jisas haga, “Nɨŋö hagabil. Ñɨg yad ñɨŋnabin u, kale mɨhöŋ u rö nöp ñɨŋnabil; ñɨg paknabin u, kale mɨhöŋ u rö nöp paknabil u pen ");
INSERT INTO kpw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ñɨmagö yɨjɨg yad böŋ lau an mɨdeinab, ñɨmagö sɨdagö yad böŋ lau an mɨdeinab u yad hagagnabin; u bapi nan nɨpe; nɨpe ke nɨŋöb rö gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pen Jisas bɨ nɨpe unbö sɨduŋ laŋ manö anɨbu nɨŋlö, kalɨp mulu lugö, Jems Jon bɨ mɨhau kalɨp hag gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Anɨg gɨlö, Jisas kalɨp magöŋhalö hagö aueila haga, “Kale nɨŋbim, Juda nɨbi bɨ wasö gau, kiŋ kale kƚö göm abad mɨdpal; bɨ kub kale manö nɨhön nɨhön hagnaböl u nɨŋöm ana udöm hain gɨnaböl me. ");
INSERT INTO kpw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pen kale gɨpal rö gagmim. Bɨ an bɨ kub mɨdainɨm u, bɨ pro rö mɨdöm, nɨbi bɨ rɨmnap kalɨp wög gɨ ñeb bɨ rö mɨdainɨm. ");
INSERT INTO kpw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bɨ an bɨ kub yabɨƚ mɨdainɨm u, bɨ pro ramö gau rö mɨdöm, nɨbi bɨ rɨmnap kalɨp magöŋhalö nagɨ wög gep bɨ ap rö mɨdainɨm. ");
INSERT INTO kpw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɨ Ñɨ nɨpe u, nɨbi bɨ gau kale wög yɨp gɨlaŋ, a göm, auaga; wög kalɨp gɨ ñɨ damem, hainö nan si nan naij gɨpal adö u hajɨ gɨ umnö, nɨbi bɨ iru nöp kamɨŋ aröl, a göm, aua,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas bɨ nɨpe gau aip daun kub Jeriko amjakla. Kale Jeriko arɨk arnɨg, nɨbi bɨ iru yabɨƚ nöp aip arla. Bɨ Dimeas ñɨ nɨpe Badimeas amgö we ga u, mani ñim, a göm, asɨb hagöl gɨ, adan goƚ au asɨk mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Asɨk mɨdö nɨŋöl gɨ, “Jisas bɨ Nasared nɨbö u auab,” a gɨlö nɨŋöm, nɨpe wɨñ alöm haga, “Jisas, Depid Ñɨ nɨpe, yɨp mög nɨŋmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hageia, nɨbi bɨ gau nɨp hag göm hagla, “Manö hagagmön! Agamɨj mɨd!” a gɨla. Anɨg hagla u pen nɨpe agamɨj mɨdöm wasö, meg magö dap ranöm wɨñ kub alöm haga, “Depid Ñɨ nɨpe, yɨp mög nɨŋmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hageia, Jisas söl anɨb au pɨdöŋ göm haga, “Nɨp wɨñ albe, aui auaŋ,” a ga. Hagö, nɨbi bɨ gau bɨ amgö we u nɨp hagla, “Jisas nöp wɨñ alab. Urakmön gasɨ halö aumön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hageila, waƚɨj mɨlöbö nɨpe u ud ju yuöm, yɨŋɨd nöp uraköm, Jisas mɨdeia au ara. ");
INSERT INTO kpw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Areia, Jisas nɨp haga, “Yɨp nɨhön gaŋ, a gɨmön, auabön?” ö ga. Hageia haga, “Manö hag ñeb bɨ. Amgö u kauyaŋ nɨŋnam, a gem, auabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hageia, Jisas haga, “Jisas yɨp gö kamɨŋ lɨnab, a gɨmön, nɨŋ udpan u rö, me ne kamɨŋ löp, gö ne aru,” a ga. Anɨg hagö nɨŋöl gɨ, magö anɨbu nöp amgö ñɨl nɨŋöm Jisas aip ara. ");
INSERT INTO kpw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas bɨ nɨpe gau aip am am Jerusalem söl söl göl gɨ, Olip Dum, ram rɨƚɨg agƚö Bedpagi Bedani a gal u amjaköm, Jisas bɨ nɨpe mɨhöp hagöm haga, ");
INSERT INTO kpw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ram mɨnöŋ mɨgan lödaŋ ammil nɨŋnabil, kaj donki marep nɨbi bɨ ud ajagpal ap adɨk lɨlö mɨdeinab. Nɨŋmil, hubɨk daumil. ");
INSERT INTO kpw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɨbi bɨ rɨmnap kalöp nɨhön gɨnɨg anɨg gabil, a gaiöl, hagmil, ‘Bɨ Kub wög ap göm, kauyaŋ yuö, aunab,’ a gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Anɨg hagö, ammil nɨŋlö, kaj donki marep ap adan au ram ajöŋ iƚ goƚ au nagɨ adɨk lɨlö mɨdeia. Hubɨk gɨlö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nɨbi bɨ yöp söl anɨb au mɨdeila gau hagla, “Nɨhön gɨnɨg kaj donki marep anɨbu hubɨk gabil?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hageila, Jisas haga rö nöp hagailö, yau a gɨlö, ");
INSERT INTO kpw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","kaj donki marep anɨbu dam Jisas mɨdeia au apil, waƚɨj mɨlö kub kale ud jumil, kaj donki adö laŋ lailö, Jisas adö anɨbu asɨka. ");
INSERT INTO kpw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nɨbi bɨ gau iru nöp, waƚɨj mɨlöbö kale gau ud juöm, adan majö adö au lɨla; rɨmnap mab uɫaŋ gau ud hak dap lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Anɨg göm, nɨbi bɨ nɨp nöd gɨla gau abe, nɨp hain gɨla gau abe, wɨñ alöl gɨ hagla, “God hib nɨpe hagno adö araŋ! Bɨ Kub bɨ nɨpe yuö auab i; God nɨp abad aij gɨnɨm. ");
INSERT INTO kpw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bac Depid kiŋ mɨdöm nɨbi bɨ abad mɨdmɨdöp rö, nɨpe hanɨp gɨnab! God hib nɨpe hagno adö araŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas anɨg göm, Jerusalem aramöm, God sabe gep ram raul u amöm, nan gau nɨŋ ajö nɨŋöl gɨ, sɨdö wad arö nɨŋöl gɨ, bɨ nɨpe unbö mɨgan laŋ gau aip ram rɨƚɨg agƚö Bedani arla. ");
INSERT INTO kpw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ruö pen, Bedani nɨbö ado gɨ adan aŋ au apöl gɨ, Jisas nɨp kɨyö la. ");
INSERT INTO kpw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kɨyö lö, mɨlö yɨjɨg nɨŋa mab uɫem ap mɨdeia. Magö rɨmnap pɨlöm mɨdöp aka göm, amöm nɨŋa, magö pɨlaga; mab uɫaŋ nöp mɨdeia. Pen nɨhön: magö pɨlep ñɨn u auaga. ");
INSERT INTO kpw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Anɨg gö, Jisas mab anɨbu haga, “Hainö nɨbi bɨ rɨmnap mab magö ne u ñɨŋagnaböl,” a ga. Bɨ nɨpe gau manö haga anɨbu nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas bɨ nɨpe gau uɫ gɨ, Jerusalem amöm, God sabe gep ram raul amöm nɨŋa, nɨbi bɨ gau sɨkim göl gɨ, mani yɨmjɨköl gɨ mɨdeila. Anɨg geila, mani yɨmjɨk geila abañ bad gau ud ado göm, yaur dap lɨlö rauöl gɨ mɨdeila mab po gau ud ado göm, nɨbi bɨ sɨkim göl gɨ, nan rauöl gɨ, ram raul anɨbu mɨdeila gau, kalɨp rɨdɨk gɨ höŋ yua. ");
INSERT INTO kpw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rɨdɨk gɨ höŋ yuöm haga, “Nan rɨmnap dap God sabe gep ram kabö waryö gɨgabö göl mɨdöp aŋ i padiagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Anɨg hagöm haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘God hagöp, “Ram yad u, nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö apöm, yɨp sabe gɨnaböl,” a göp,’ a gɨla. Pen kale anɨg gajim, bɨ nan si ud pi göl mɨdpal ram ap rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Anɨg hagö, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, manö anɨbu nɨŋöm, nɨp al pak lun, a gɨla. Pen nɨbi bɨ gau magöŋhalö manö nɨp u nɨŋöm aiö gɨla rö me, Jisas nɨp pɨñɨŋ göm, aigöl gun nɨp al pak lun, a göm, gasɨ u uƚhai nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ram duga magö u, Jisas bɨ nɨpe gau aip Jerusalem arö göm arla. ");
INSERT INTO kpw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ruö sɨb halö adan aŋ au amöl gɨ nɨŋla, mab uɫem Jisas hag ga u iƚ halö böŋ nöp mɨƚep gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Anɨg ga nɨŋöm Pida haga, “Manö hag ñeb bɨ, nöŋ! Uɫem mab rol hag gaina i mɨƚep gɨ lugöp!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hageia, Jisas haga, “God nɨp nɨŋ udmim. ");
INSERT INTO kpw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yad kalöp nɨŋö hagabin, hon hagno God u rö nöp gɨnɨm, a gɨmim, gasɨ mɨhöp wasö gasɨ añɨ nɨŋmim, dum ilö anɨbi ‘Ñɨg solwara aŋ au daŋ gɨ dam pak,’ a gɨnabim u, hagnabim rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anɨb u me, God nɨp hagnabun rö gɨnab, a gɨmim, gasɨ añɨ nɨŋmim hag nɨŋbe, hagnabim rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pen God nɨp sabe gɨnɨg gɨmim, nɨbi bɨ rɨmnap kalöp gɨ naij gɨpal gau nɨŋmim arö gɨmim nɨŋöm Nap kale kumi kabö adö laŋ mɨdöp u, nan si nan naij kale gɨpim gau nɨŋöm arö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pen nɨbi bɨ rɨmnap kalöp gɨ naij gɨpal gau nɨŋmim arö gagnabim u, Nap kale kumi kabö adö laŋ mɨdöp u, nan si nan naij kale gɨpim gau u rö nöp nɨŋöm arö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pen Jisas bɨ nɨpe gau aip kauyaŋ Jerusalem apjaköm, nɨpe God sabe gep ram raul gau gɨ ajö nɨŋöl gɨ, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb gau abe, bɨ manö ud asɨkep gau abe, Jisas mɨdeia au apöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Nöp an, anɨg gɨmön, a gö, gɨ ajabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hageila, Jisas pen haga, “Yad kalöp manö ap hag nɨŋnö, yɨp hag ñeinabim u, yad pen yad an hagö gɨ ajabin u, kalöp hag ñɨnabin. ");
INSERT INTO kpw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon nɨbi bɨ gau kalɨp ñɨg pak ña u, God hagö ñɨg pak ña aka gasɨ nɨpe ke nɨŋöm ñɨg pak ña? Yɨp hag ñɨbe, nɨŋɨn!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Anɨg hagö, kale ke hag nɨŋ hag nɨŋ göm hagla, “Hon hagnabun, ‘God hagö, Jon nɨbi bɨ gau kalɨp ñɨg pak ña,’ a gɨnabun u, hanɨp hagnab, ‘Anɨb u, nɨhön gɨnɨg Jon manö nɨpe u nɨŋ udagpim?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pen hon hagnabun, ‘Jon gasɨ nɨpe ke nɨŋöm kalɨp ñɨg pak ña,’ a gɨnabun u, hanɨp nɨhön gɨnab?” ö gɨla. Pen nɨhön: nɨbi bɨ gau magöŋhalö, God hagö, Jon wög nɨpe gɨmɨdöp a göm nɨŋmɨdal u me, Juda bɨ kub anɨb gau pɨñɨŋ göm manö ke ap hagagla. ");
INSERT INTO kpw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gasɨ anɨbu nɨŋöm hagla, “Hon nɨŋagpun,” a gɨla. Anɨg hageila, Jisas kalɨp pen haga, “Kale yɨp pen hag ñagpim rö, yɨp an hagö gɨ ajabin u, kalöp u rö nöp pen hag ñagnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas pen kalɨp manö adö ap hod rɨköm haga, “Bɨ ap waryö göm, nagɨ wain wög u gɨ yɨmöm, wain magö pak hib jakep, a göm, mɨgan ap gɨ lɨ aij gɨnab. Nɨbi bɨ apöm nagɨ magö si udnaböl u nɨŋ mɨdaiun, a göm, ram gɨlaŋ gɨ mɨlö kub ap göm, bɨ rɨmnap kalɨp hagnab, ‘Kale nagɨ wain wög yɨp u abad mɨdmim, hainö pɨlöm po gö, yɨp rɨmnap, kale rɨmnap udmim,’ a göm, ram mɨnöŋ mɨlö gau arnab. ");
INSERT INTO kpw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain magö po gɨnab magö u, bɨ nɨpe ap hag yuöm, hagnab, ‘Wain magö yɨp rɨmnap ñɨlö daumön!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hagö, amjakö, bɨ wög gɨnaböl gau, nɨp ud pak pak löm, yɨharɨŋ nöp hag yunaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Anɨg gɨlö, bɨ wain wög nap nɨbö u bɨ ap pen hag yunab. Amjakö, nɨp nabɨc laŋ paköm, gɨ naij yabɨƚ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anɨg gɨlö, bɨ wain wög nap nɨbö u, bɨ ap pen yuö arö, nɨp böŋ nöp al pak lɨnaböl. Bɨ rɨmnap iru nöp yuö, anɨb unbö nöp göl gɨ, rɨmnap mɨñu magö paknaböl, rɨmnap böŋ nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Anɨg gɨlö gɨlö me, bɨ wain wög nap nɨbö u bɨ nɨpe ap mɨdageinab; ñɨ mɨdmagö nɨpe añɨ mɨdeinab u, manö nɨpe u udnaböl, a göm, yuö arnab. ");
INSERT INTO kpw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pen amjakö, nɨbi bɨ wain wög gɨ mɨdeinaböl gau nɨŋöm hagnaböl, ‘Ñɨ auöp i, bɨ wain wög nap nɨbö u ñɨ nɨpe auöp. Anɨb u, nɨp al pak lun me, nan nɨpe udnɨm rö gau hon udnabun,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Anɨg hagöm, ñɨ anɨbu nɨp böŋ nöp al pak löm, dam höŋ gau ud yunaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Anɨg geinaböl, bɨ wain wög nap nɨbö u apöm, nɨhön gɨnab? Nɨpe apöm, nɨbi bɨ wain wög geinaböl anɨb gau kalɨp al pak löm, nɨbi bɨ rɨmnap kalɨp hagö, wain wög anɨbu abad mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anɨg hagöm kalɨp haga, “God Manö kalɨ kƚiñ rɨköm hagla, ‘Bɨ ram gep gau kabö mɨlö arö gɨla u, kabö anɨbu nöp mɨñi ram padö aŋ yaŋ u bɨnɨg ñöl mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bɨ Kub anɨg ga u, hon nɨŋun aij a gabun,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas anɨg hagö, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb gau abe, bɨ manö ud asɨkep gau abe, hanɨp nöp hagab, a göm, nɨp sɨsɨ udun, a gɨ nɨŋla u pen nɨbi bɨ gau kalɨp pɨñɨŋ göm, arö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pen hainö Juda bɨ kub anɨb gau, bɨ Perisi rɨmnap aip, Herod bɨ nɨpe rɨmnap aip kalɨp hagla, “Kale Jisas mɨdöp au ammim, nɨp manö rɨmnap hag nɨŋbe, nɨpe nɨhön dui manö hageinab, nɨp dam nagɨ lɨnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Anɨg hageila, Jisas mɨdeia au amöm, hagla, “Manö hag ñeb bɨ. Hon nɨŋbun ne bɨ nɨŋö yabɨƚ nöp hagpan. Bɨ kub gau abe, nɨbi bɨ yɨharɨŋ gau abe, kalɨp nɨŋmön pɨñɨŋ gagpan. God hagöp rö nöp nɨŋmön, nɨbi bɨ gau kalɨp yɨjɨg göl nöp hag ñɨban. Anɨb u, hanɨp hag ñɨ! Hon Juda nɨbi bɨ lo gau aigöl gɨ mɨdöp? Gapman bɨ kub Sisa u nɨp dakɨs ñeb aka ñagep?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Anɨg haglö, Jisas manö piral hageila u nɨŋöm haga, “Nɨhön gɨnɨg, manö dui hagaŋ a gɨmim, yɨp manö piral anɨbu hagabim? Mani magö ap daube, yad nɨŋɨn,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hagö, dap ñɨlö nɨŋöm haga, “Mani ba u, bɨ an mulu adɨŋ u mɨdöm, an hib u mɨdöp?” ö ga. Hageia hagla, “Bɨ kub Sisa u nöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hageila, Jisas haga, “Sisa nan nɨpe mɨdainɨm u Sisa nɨp ñɨmim; God nan nɨpe mɨdainɨm u God nɨp ñɨmim,” a ga. Anɨg hagöm, manö piral kale u dauba gɨ aij ga anɨbu nɨŋöm, aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi nɨbi bɨ gau, nɨbi bɨ umöm, urakagnaböl, a göm, nɨŋmɨdal rö, rɨmnap Jisas mɨdeia au apöm hagla, ");
INSERT INTO kpw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Manö hag ñeb bɨ. Bɨ God manö hagep Mosɨs, manö ap hanɨp kalɨ kƚiñ rɨköm haga, ‘Bɨ ap nɨbi udöm, ñɨ pai rɨköm wasö, yɨharɨŋ umeinab u, nɨmam nɨpe ap pen nɨbi kaŋɨƚ anɨbu udöm, mam uma u ñɨ pai nɨpe u, a göm, rɨknab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Anɨb u, bɨ iƚ halö unbö mɨdun jɨŋ u mɨdeinaböl. Nɨmam nöd nɨbi udöm, ñɨ pai rɨköm wasö, yɨharɨŋ umnab. ");
INSERT INTO kpw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Umö, nɨmam yɨgwö aŋ nɨbö u pen nɨbi anɨbu nɨp udöm, u rö nöp ñɨ pai rɨköm wasö, yɨharɨŋ umnab. Anɨg gö, nɨmam yɨgwö nɨgaŋ nɨbö u pen nɨbi anɨbu nɨp udöm, u rö nöp ñɨ pai rɨköm wasö, yɨharɨŋ umnab. ");
INSERT INTO kpw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anɨg gɨ dam dam, nɨmam unbö mudun jɨŋ u ñɨ pai rɨköm wasö, magöŋhalö yɨharɨŋ umnaböl. Hainö nɨbi u u rö nöp umnab. Pen nɨbi bɨ umöm uraknaböl, a gɨpan u, ");
INSERT INTO kpw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","nɨbi añɨ ap bɨ nɨpe unbö mudun jɨŋ lɨnab anɨbu, hainö nɨmam mai aip nɨbi nɨpe mɨdeinab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hageila, Jisas haga, “Kale God Manö kalɨ kƚiñ rɨkla u abe, God kƚö nɨpe u abe nɨŋagpim rö, gasɨ nɨŋö nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nɨbi bɨ umbal gau uraknaböl ñɨn u, God ejol nɨpe gau mɨdpal rö mɨdöm, bɨ gau nɨbi udagnaböl; nɨbi gau bɨ udagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pen nɨbi bɨ kauyaŋ urakagnaböl, a gɨpim u, Mosɨs mab pro in nöp mɨdeia aiud kalɨ kƚiñ rɨka u nɨŋagpim rö löp. God, mab ineia aŋ au mɨdöm, Mosɨs nɨp haga, ‘Ebraham, Aisak, Jekop, God kale me, yad mɨdpin,’ a ga. Anɨb u, bac bɨ nöd umla gau kalɨp hagöm, ‘God kale mɨdpin,’ a ga. Pen kale hagpim rö, nɨbi bɨ gau umöm, böŋ nöp umblap u, God nɨpe, ‘Ebraham, Aisak, Jekop, God kale mɨdpin,’ a gagböp. ");
INSERT INTO kpw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nɨbi bɨ kamɨŋ mɨdpal aka umbal u, God nɨŋöb kale magöŋhalö kamɨŋ mɨdpal. Kale nɨŋ aij gagpim me, böŋ nöp umbal, a gɨmim, nɨŋbim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bɨ lo manö hag ñeb bɨ ap, Jisas Sadyusi nɨbi bɨ gau kalɨp hag aij ga u nɨŋöm, apöm nɨp hag nɨŋöm haga, “Lo adö mai kub yabɨƚ?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hageia, Jisas haga, “Lo kub yabɨƚ u, God Manö u kalɨ kƚiñ rɨköm hagla, ‘Isrel nɨbi bɨ nɨŋim! Bɨ Kub hon God, nɨpe añɨ nöp Bɨ Kub mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mɨdmagö ne u magöŋhalö, gasɨ rɨmɨd ne u magöŋhalö, kƚö ne u magöŋhalö udmön, God Bɨ Kub ne u nɨp mɨdmagö lɨmön,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Manö kub yabɨƚ ap, God Manö u kalɨ kƚiñ rɨköm hagla, ‘Ne ke mɨdmagö lɨban rö, nɨbi bɨ gau kalɨp u rö nöp mɨdmagö lɨmön,’ a gɨla. Lo manö gau magöŋhalö, lo anɨb mɨhau me lo kub yabɨƚ mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hageia, bɨ lo manö hag ñeb bɨ u haga, “Manö hag ñeb bɨ. Ne nɨŋö yabɨƚ hagpan, God añɨ me Bɨ Kub yabɨƚ mɨdöp; nɨpe rö rɨmnap mɨdagpal. ");
INSERT INTO kpw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hon God nɨp nan pak sabe gɨ ñɨnabun aka nan pak sabe gɨ ñɨ böŋ nöp launabun u nan kub wasö. Nan kub yabɨƚ me, mɨdmagö hon u magöŋhalö, gasɨ rɨmɨd hon u magöŋhalö, kƚö hon u magöŋhalö udun, God Bɨ Kub u nɨp mɨdmagö lun; hon ke mɨdmagö lɨbun rö, nɨbi bɨ gau kalɨp u rö nöp mɨdmagö lun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Anɨg hageia, Jisas bɨ u, nɨpe gasɨ nɨŋ aij yabɨƚ göm hagöp, a göm, nɨp haga, “Ne God bɨ nɨpe ap mɨdmön rö löp,” a ga. Jisas pen manö nɨŋö yabɨƚ gau nöp hageia u nɨŋöm, nɨbi bɨ nɨŋmɨdeila gau pɨñɨŋ göm, hainö manö piral gau nɨbö nɨp neb neb göm hagmɨdal rö, rɨmnap halö nɨp hag nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas God sabe gep ram au nɨbi bɨ gau kalɨp manö hag ñɨ mɨdöl gɨ, nɨbi bɨ gau kalɨp haga, “Bɨ lo manö hag ñeb bɨ gau nɨhön gɨnɨg hagpal, ‘Krais u nɨpe Depid ñɨ nɨpe nöp,’ a gɨpal? ");
INSERT INTO kpw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ana Uɫ u, Depid nɨp gasɨ ñö, Depid nɨpe ke kalɨ kƚiñ rɨköm haga, ‘Bɨ Kub nɨpe Bɨ Kub yad u nɨp haga, “Ne ñɨmagö yɨjɨg yad lau adö mɨdmön, yad nɨbi bɨ koƚmaƚ ne gau kalɨp ma mo ne gau lɨnabin,” a ga,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Anɨb u, Depid nɨpe ke Krais nɨp ‘Bɨ Kub yad’ a ga. Pen Krais Depid ñɨ nɨpe mɨdböp, nɨp ‘Bɨ Kub yad’ a gagböp,” a ga. Jisas manö iƚ anɨgöl nɨŋöm hag aij ga rö, nɨbi bɨ iru yabɨƚ mɨdeila gau manö nɨp u ñɨñɨ löl gɨ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas nɨbi bɨ gau kalɨp manö hag ñöl gɨ haga, “Bɨ lo manö hag ñeb bɨ gau kalɨp nɨŋ aij gɨmim. Kale gɨpal adö u, waƚɨj mɨlö kub gau löm, maker gau arno, nɨbi bɨ gau, auabim e, gɨlö, hib hane i adö laŋ mɨdeiaŋ, a göm, gasɨ u nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pen Juda magum gep ram u arno, hanɨp ka adö aij aij bɨ kub asɨkpal adö u asɨkmön, a gɨnaböl, a göm, gasɨ u nɨŋbal. Nɨbi bɨ nan kub ñɨŋbal aŋ u, u rö nöp, nɨbi bɨ amgö ilö adö au asɨkno, hanɨp nɨŋöm, hon bɨ gep hib mɨdöp, a gɨnaböl, a göm, gasɨ u nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɨ lo manö hag ñeb bɨ gau, nɨbi paƚpaƚ ram nan kale gau nan hon rö laŋ, a göm, pɨƚɨ gɨ udpal. God nɨp sabe gɨnabun u, nɨbi bɨ nɨŋöl, a göm, manö mɨlö kub piral piral adö rɨmnap nöp gau hagpal. Anɨg gɨpal u, hainö God kalpe ilön kub unbö ke yabɨƚ ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas God sabe gep ram mani dap ñɨmɨdal mɨgan söl au asɨk mɨdöm nɨŋa, nɨbi bɨ gep gau, mani iru nöp dap yula. ");
INSERT INTO kpw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pen nɨbi kaŋɨƚ mani mɨdageia ap, mani aɫɨ magö pro mɨhöp dap yua. ");
INSERT INTO kpw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Anɨg ga nɨŋöm, Jisas nɨpe bɨ nɨpe gau hagö aueila haga, “Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ gau kale mani pro ñɨbal, pen nɨbi kaŋɨƚ i mani kub yabɨƚ ñöb. ");
INSERT INTO kpw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nɨbi bɨ mani iru mɨdöp gau, mani kale rɨmnap halö iru nöp mɨdö nɨŋöl gɨ, mani kale God nɨp rɨmnap nöp dap ñɨbal; pen nɨbi kaŋɨƚ i, mani nɨpe magö mɨhöp mɨdajɨp u magöŋhalö dap ñöb. Nɨpe nan rau ñɨŋeb mani ap mɨdagöp. Anɨg göp u, God nɨŋö, nɨbi bɨ rɨmnap pro ñɨbal u pen nɨbi kaŋɨƚ i kub yabɨƚ ñöb,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas God sabe gep ram u arö göm höŋ arö nɨŋöl gɨ, bɨ nɨpe ap nɨp haga, “Manö hag ñeb bɨ. Kabö aij udöm, ram aij gɨla i nöŋ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hageia, Jisas haga, “Ne kabö ram kub anɨbu nɨŋö, aij gö hagabön ar? Hainö ram anɨb i pa jö ma jö gɨ yulö, kabö ap, kabö ap adö au mɨdageinab; böŋ nöp pɨral yunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas anɨg hagöm, God sabe gep ram u arö göm, Olip Dum ara. God sabe gep ram u nö lau mɨdöp, Olip Dum nö lai mɨdöp. Jisas Olip Dum au asɨk mɨdö nɨŋöl göm, Pida, Jon, Jems, Edru kale yam apöm nɨp hagla, ");
INSERT INTO kpw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nan hagajan u, ñɨn mai rö gɨnab? Pen nan nɨhön rö gö nɨŋun hagnabun, ‘Nan anɨb gau mɨñi gɨnɨg gab,’ a gɨnabun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hageila, Jisas kalɨp haga, “Nɨŋ aij gɨmim, manö piral haglö udagmim! ");
INSERT INTO kpw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nɨbi bɨ iru nöp apöm, pir alöm, hib yad u udöl gɨ, hagnaböl, ‘Yad Jisas nöp auabin,’ a gɨnaböl. Anɨg haglö, nɨŋö hagaböl, a gɨmim, nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Ram mɨnöŋ gai i pen pen gaböl, ram mɨnöŋ gau pen pen gaböl,’ a gaiöl, gasɨ iru nɨŋagmim. Nan anɨb gau gɨnab u pen uri ram mɨnöŋ iƚ i nan gau magöŋhalö pɨs gɨnab, a gɨmim, gasɨ u nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nɨbi bɨ mɨgan rɨmnap uraköm, nɨbi bɨ mɨgan rɨmnap aip pen pen gɨnaböl. Kiŋ mɨgan rɨmnap uraköm, kiŋ mɨgan rɨmnap aip pen pen gɨnaböl. Ram mɨnöŋ gau magöŋhalö munmon udöm, kɨyö kub yabɨƚ apöm gɨnab. Nan gɨnab anɨb gau, nɨbi gau kalɨp nöd ñɨ pai ñɨŋajɨp, hainö ñɨ pai rɨkpal rö u gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pen kale nɨŋ aij gɨmim mɨdaimim. Ñɨn rɨmnap kalöp dam Juda kansol bɨ gau kalɨp ñɨlö, manö kub hagnaböl. Ñɨn rɨmnap, Juda magum gep ram raul gau, ur udöm, kalöp paknaböl. Ñɨn rɨmnap, Jisas bɨ nɨpe, a göm, kalöp dam gapman bɨ kub abe kiŋ abe mɨdeinaböl au amöm, manö kub hagnaböl. Pen anɨg ud araiöl u, manö aij yad u gapman bɨ kub gau abe, kiŋ gau abe kalɨp hag ñɨnabim. ");
INSERT INTO kpw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pen nöd manö aij yad u, nɨbi bɨ ram mɨnöŋ ke gau gau magöŋhalö hag ñɨlö arnab nɨŋöm ñɨn hain hagpin u aunab. ");
INSERT INTO kpw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Pen kalöp manö kub hagnɨg ud araiöl u, manö pen aigöl gɨ hagun, a gɨmim, gasɨ iru nɨŋagmim. Hagnɨg gɨpe nɨŋöl gɨ, Ana Uɫ kalöp gasɨ aij ñö, hagnabim. Manö anɨbu kale ke hagagnabim; Ana Uɫ nɨpe ke hagnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ñɨn anɨbu, mam bɨ gau uraköm, mam rɨmnap kalɨp al paklaŋ, a göm, kain gɨ dam bɨ manö nɨŋeb bɨ gau ñɨmagö adö kalɨp ñɨlö, al pak lɨnaböl. Nap bɨ gau uraköm, ñɨ pai kale ke gau kalɨp al pak lɨlaŋ, a göm, kain gɨ dam bɨ manö nɨŋeb bɨ gau ñɨmagö adö kalɨp ñɨlö, al pak lɨnaböl. Ñɨ pai gau uraköm, nɨme nap bɨ kalɨp nɨŋlö, mulu lugö, kalɨp al pak lɨlaŋ, a göm, kain gɨ dam bɨ manö nɨŋeb bɨ gau ñɨmagö adö kalɨp ñɨlö, al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yad lau adö mɨdeinabim u nɨŋöm kalɨp mulu kal nɨŋnaböl u pen kale nɨbi bɨ an an, kƚö gɨmim yɨp arö gagmim, cɨg gɨmim nöp mɨdeinabim gau, ñɨn hain hagpin u aueinab, God kalöp ud kamɨŋ yunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pen nan hil asɨ masɨ gep u, ka nɨpe aragep au am uraköl mɨdeinab, nɨŋnabim u, kale nɨbi bɨ ram mɨnöŋ Judia mɨdeinabim gau, yɨŋɨd pɨñɨŋ gɨ nö ilö gau armim. (Kale nɨbi bɨ manö i uri nöp amgö lɨ nɨŋabim gau, manö iƚ u rɨk nɨŋ aij gɨmim.) ");
INSERT INTO kpw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nɨbi bɨ ram adö laŋ mɨdeinabim gau, nan yad rɨmnap udnam, a gɨmim, ado gɨ ram raul aragmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɨbi bɨ wög naböŋ gau ajeinabim gau, waƚɨj mɨlö yad ap udnam, a gɨmim, ado gɨ ram aragmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pen ñɨn anɨbu, nɨbi ñɨ mudun halö mɨdeinaböl gau abe, nɨbi ñɨ paiŋaŋ ci ñeinaböl gau abe, uɫham yabɨƚ pɨñɨŋ gɨ arnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nan gɨnab anɨbu, God nɨp sabe gɨmim, ram yɨgön göp ñɨn u gagnɨm, a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nɨhön gɨnɨg: God hadame dagol gau ram mɨnöŋ gɨ la ñɨn u rɨköm, mɨd damöm mɨñi mɨdpun ñɨn i, nan naij anɨbu rö ap gaga; hainö gau u rö nöp nan naij anɨbu rö ap gagnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nan naij anɨbu pör gɨböp, nɨbi bɨ magöŋhalö um hakblap. Pen Bɨ Kub nɨpe nɨbi bɨ nɨpe udnab gau kalɨp gasɨ nɨŋöm, wasö gö me, nan naij anɨbu yöp magö ap gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ñɨn anɨbu nɨbi bɨ rɨmnap kalöp hagnaböl, ‘Nɨŋim! Krais mɨdöp i! Krais mɨdöp daŋ!’ a gɨnaböl u pen nɨŋö hagaböl, a gɨmim, nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nɨbi bɨ rɨmnap, God nɨbi bɨ nɨpe ke hag la gau kalɨp udun, a göm, piral hagöm hagnaböl, ‘Yad me Krais; yad me bɨ God manö hagep ap,’ a göm, nan gagep rö rɨmnap gɨnaböl. Pen God nɨbi bɨ nɨpe ke hag la gau udagnaböl, wasö. ");
INSERT INTO kpw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Anɨb u, nɨŋ aij gɨmim. Nan nɨhön nɨhön hainö gɨnab u, yad kalöp hagnö nɨŋbim u me, nɨŋ aij göl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pen mɨŋör kub anɨb gau gɨ hakö nɨŋöl gɨ, sɨdö u sɨb göm, rakɨn u mailö gagnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gapɨ gau kumi kabö adö laŋ nɨbö pɨg ju lug auö nɨŋöl gɨ, nan kumi kabö adö laŋ mɨdöp gau, gɨdaŋ nɨbö gai nɨbö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ñɨn anɨbu, Bɨ Ñɨ nɨpe pɨdöŋ ke yabɨƚ udöm, mailö aij unbö ke halö kumi bad aŋ au auö nɨŋöl gɨ, nɨbi bɨ nɨp nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pen ejol nɨpe gau hag yuö ram mɨnöŋ ke gau gau magöŋhalö rɨgoŋ rɨgoŋ gau amöm, nɨbi bɨ nɨpe ke hag la gau uɫ göm nɨp daunaböl. ");
INSERT INTO kpw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas haga, “Kale mab rauan gau nɨŋnabim u, manö hagabin i nɨŋ aij gɨnabim. Mab rauan gau sɨƚɨp löm, pɨdöŋ gö nɨŋöl gɨ, mɨñi sɨdö lɨnɨg gab, a gɨmim nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Anɨb u rö, hainö nan hagpin gau gö nɨŋöl gɨ, ‘Mɨñi söl mɨdöp, Jisas haga rö gɨnɨg gab,’ a gɨmim nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yad hagabin u gasɨ nɨŋöl gɨ mɨdaimim. Nɨbi bɨ mɨñi mɨdpal gau rɨmnap mɨdlö nɨŋöl gɨ, nan anɨb gau gɨ hakö, hainö umnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe ur gɨnab; pen manö magö yad gau ur gagnab; pör pör nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ñɨn mai aka magö mai aunabin u, nɨbi bɨ rɨmnap nɨŋagpal, ejol gau nɨŋagpal, yad u rö nöp nɨŋagpin; Bapi nöp nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Anɨb u me, ñɨn mai aunabin u nɨŋagpim rö, pör pör nɨŋ aij yabɨƚ göl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Aunabin ñɨn anɨbu, aiud hagnɨg gabin i rö. Bɨ kub ap ram nɨpe u arö göm mɨgan ap arnɨg göm, bɨ wög gep nɨpe gau kalɨp wög adö ke ke hag löm, ‘Wög anɨg anɨg gɨmim,’ a göm, bɨ nɨpe ajöŋ iƚ abad mɨdeinab u nɨp hagnab, ‘Nɨŋ aij yabɨƚ gɨmön mɨdaimön,’ a göm, arnab. ");
INSERT INTO kpw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kale u rö nöp, magö mai bɨ ram nap nɨbö u aunab u nɨŋagpim rö, nɨŋ aij gɨmim mɨdaimim. Dugo magö u aunab aka, sɨbön aŋ kub yaŋ aunab aka, kɨƚakɨƚ wɨñ alnab magö u aunab aka, hilɨm halö aunab, a gɨmim, nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kale hanbe nɨŋöl gɨ, yɨŋɨd aunɨm rö löp u me, nɨŋ aij gɨmim mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pen kalöp nöp hagagabin; nɨbi bɨ gau magöŋhalö u rö nöp hagabin, nɨŋ aij gɨmim mɨdaimim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pen Juda kai Pasopa ñɨn kub u abe, Bred Yɨs Halö Ñɨŋagep ñɨn kub u abe yöp ñɨn mɨhöp nöp mɨdö nɨŋöl gɨ, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, Jisas nɨp aigöl gun, agamɨj ud sɨsɨ lun, dam al pak lun, a göm, anɨg gɨ gasɨ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pen gasɨ ap nɨŋöm hagla, “Pasopa ñɨn i anɨg gɨno, nɨbi bɨ iru nöp gai i uraköm, pen pen göm, hanɨp gɨ naij gɨnaböl,” a göm, arö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas ram rɨƚɨg agƚö Bedani amöm, Saimon ram u am asɨköm, nan ñɨŋeila. Bɨ Saimon anɨbu, nöd wös hapeb la u, Jisas gö, kamɨŋ la. Pen nan ñɨŋlö nɨŋöl gɨ, nɨbi ap wel haƚɨŋ aij auep mani kub raubal u, barol halö dapöm, aŋ au pa jö göm, Jisas nɨp nabɨc adö laŋ hoŋ ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Hoŋ gö, bɨ mɨdeila anɨb gau, rɨmnap nɨŋlö, hibur kalɨp u naij gö, kale ke hagla, “Wel anɨbu sɨkim göm, mɨ añɨ ap bɨ ap wög göm mani udnab rö u udöm me, nɨbi bɨ nan mɨdagöp gau kalɨp ñeb u pen nɨhön gɨnɨg anɨg göl yɨharɨŋ hoŋ göp?” ö gɨla. Anɨg hagöm, nɨbi anɨbu nɨp hag jula. ");
INSERT INTO kpw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Anɨg hageila, Jisas kalɨp haga, “Nɨhön gɨnɨg anɨg hagabim? Nɨp arö gim! Yɨp göp anɨbu, gɨ aij yabɨƚ göp. ");
INSERT INTO kpw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nɨbi bɨ nan mɨdagöp gau, kale aip pör nöp mɨdeinabim rö, ñɨn rɨmnap kalɨp nan ñɨnɨg, ñɨnabim. Pen yad aip pör mɨdageinabun. ");
INSERT INTO kpw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nɨbi anɨbi, nan nɨpe gep rö u, göp. Umnö, wel haƚɨŋ aij auep u lɨ ñöm rɨgöl gɨnaböl rö, yɨp nöd lɨ ñab. ");
INSERT INTO kpw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Anɨb u, yad kalöp nɨŋö hagabin, hainö manö aij yad u ram mɨnöŋ gau gau magöŋhalö hag ñɨlö arö nɨŋöl gɨ, nɨpe göp anɨbu halö haglö, kale nɨbi anɨbi nɨp gasɨ hauƚ gagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pen Jisas bɨ nɨpe ap Judas Iskariod, Jisas nɨp mumug gɨnam a göm, bɨ God nɨp nan sabe gep bɨ kub gau ara. ");
INSERT INTO kpw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bɨ God nɨp nan sabe gep bɨ kub anɨb gau, mumug ga anɨbu nɨŋöm, aij gö, hagla, “Nöp mani rɨmnap ñɨnabun,” a gɨla. Hageila me, Judas, “Aigöl gem hagnö, kale apöm Jisas nɨp ud aröl,” a göm, gasɨ u uƚhai nɨŋ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bred Yɨs Halö Ñɨŋagep ñɨn kub u auö, Pasopa kaj sipsip pi pak sabe gɨ ñɨŋeb ñɨn u, Jisas bɨ nɨpe gau nɨp hag nɨŋöm hagla, “Nan hon ñɨŋnabun u, mɨgan mai gɨ jɨn gun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hageila, Jisas bɨ nɨpe mɨhöp hag yuöm haga, “Kale daun kub u ammil nɨŋnabil, bɨ ap ñɨg mɨl dap areinab; nɨp nable pakmil aip armil. ");
INSERT INTO kpw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bɨ anɨbu amöm ram raul arainɨm, kale mɨhöŋ bɨ ram anɨbu nap nɨbö u nɨp hag nɨŋmil hagmil, ‘Manö hag ñeb bɨ hagöp, “Bɨ yad gau aip Pasopa nan ñɨŋnabun raul mɨgan mai?” ö göp,’ a gɨmil. ");
INSERT INTO kpw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kale hag nɨŋlö, nɨpe kale dam ram adö laŋ, nan gau magöŋhalö mɨdöp raul mɨgan kub u yamnab. Yamö, nan ñɨŋnabun u raul mɨgan anɨbu gɨ jɨn gaimil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jisas kalɨp mɨhöŋ anɨg hag yuö, daun kub u ammil nɨŋlö, Jisas haga rö nöp mɨdeia. Nɨŋmil, Pasopa nan ñɨŋnɨg gɨla u, gɨ jɨn gɨlö. ");
INSERT INTO kpw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dugo magö u, Jisas bɨ nɨpe rɨmnap aip amjaköm, ");
INSERT INTO kpw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","nan ñɨŋöl gɨ haga, “Yad kalöp nɨŋö hagabin, bɨ yad aip nan jɨm ñöl ñɨŋabun aui nöp, bɨ ap, yɨp al pak lɨlaŋ, a göm, yɨp mumug gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Anɨg hagö, bɨ nɨpe gau mög gö, gasɨ mɨŋör nɨŋöl göm, nɨp añɨ añɨ hag nɨŋöl gɨ hagla, “Ne yɨp hagabön aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hageila, Jisas haga, “Kale bɨ yad unbö mɨgan laŋ mɨdpim u, bɨ ap anɨg gɨnab. Bɨ anɨbu me, yad aip nan kɨnaŋ añɨ jɨm ñöl ñɨŋabul i. ");
INSERT INTO kpw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yad Bɨ Ñɨ nɨpe, God Manö kalɨ kƚiñ rɨköm hagla rö nöp umnabin u pen bɨ yɨp al pak lɨlaŋ, a göm, mumug gɨnab u, nɨp mög nɨŋabin. Nɨpe ilön kub udnab u me, nɨp yag dauagblap u aij,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nan ñɨŋöl gɨ, Jisas bred u udöm, God nɨp aij, a göm, ud jö göm, bɨ nɨpe gau kalɨp ñöl gɨ haga, “Ud ñɨŋim! U hañ romaŋ yad,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pen ñɨg wain kap u, u rö nöp udöm, God nɨp aij, a göm, bɨ nɨpe gau kalɨp ñö, magöŋhalö ñɨŋlö nɨŋöl gɨ, haga, ");
INSERT INTO kpw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Ñɨg i, hagape yad. Hagape yad hoŋ gɨ lugnab u me, God manö nɨŋö hag la rö, nɨbi bɨ iru nöp nɨpe aip ud dɨm ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anɨg hagöm haga, “Yad kalöp nɨŋö hagabin, mɨñi ñɨn i rɨköm ñɨg wain ñɨŋagnabin. Yɨharɨŋ nöp mɨdnö mɨdnö, God nɨbi bɨ udöm kumi kabö adö laŋ au abad mɨdeinab ñɨn u nöp, ñɨg wain kauyaŋ ñɨŋnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anɨg hagöm, bɨ nɨpe gau aip God nɨp sabe gep kɨmap ap hagöm, Olip Dum arla. ");
INSERT INTO kpw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas bɨ nɨpe gau kalɨp haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘God nɨpe haga, “Yad bɨ kaj sipsip mukep u nɨp pak lɨnö, kaj sipsip gau pɨñɨŋ gɨ ke ke arnaböl,” a ga,’ a gɨla. Anɨb u rö, mɨdö mɨdö kale magöŋhalö yɨp arö gɨmim, pɨñɨŋ gɨ arnabim. ");
INSERT INTO kpw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pen yad umem, urakem ram mɨnöŋ Galili arnö, kale hain nɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Anɨg hageia, Pida haga, “Bɨ rɨmnap nöp arö göl rö löp u pen yad nöp arö gagnabin, wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hageia, Jisas haga, “Yad nöp nɨŋö hagabin, mɨñi ñɨn i nöp, sɨbön aŋ yaŋ kɨƚakɨƚ wɨñ mɨhöp alagnab magö u, ‘Yad Jisas nɨp nɨŋagpin,’ a gɨmön, ij mɨhau nɨgaŋ wai ñɨnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hageia, Pida manö kƚö yabɨƚ hagöm haga, “Yɨp nöp aip al pak lɨnɨg, al pak löl u pen yad Jisas nɨp nɨŋagpin, a gem, hagagnabin,” a ga. Jisas bɨ nɨpe gau magöŋhalö, Pida haga rö nöp hagla. ");
INSERT INTO kpw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas bɨ nɨpe gau aip mab wög adɨŋ Gedsemani amöm kalɨp haga, “Kale aui asɨk mɨdaimim; yad am sabe gɨnɨg arabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anɨg hagöm, Pida, Jems, Jon kalɨp uɫ gɨ damöm, gasɨ mɨlö löl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Mɨdmagö yad u ilön gɨ dam lugöp u, umnam rö löp. Kale iƚ i mɨdmim, nɨŋ mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Anɨg hagöm, kalɨp au hag löm, nɨpe yöp söl anɨb au amöm, mɨnöŋ naböŋ yaŋ lug paköm, ilön kub udnɨg geia anɨbu, Nap nɨpe wasö gɨnɨm aka wasö gagnɨm, a göm, sabe göl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nap nɨp sabe göm haga, “Bapi, ne nan gau magöŋhalö gep u nöp mɨdöp. Nan yɨp gɨnɨg gab u, yad mɨŋör kub mɨdöp. Ne yau a gɨmön, yɨp unbö gagnɨm. Pen nan yɨp nɨhön gɨnɨg gainɨm u, gasɨ yad nɨŋnam rö gagmön, gasɨ ne ke nɨŋban adö u nöp yɨp gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hagöm, ado gɨ bɨ nɨpe mɨhau nɨgaŋ mɨdeila au apöm nɨŋa, kale böŋ nöp hon han arla. Anɨb u, nɨpe Pida nɨp haga, “Saimon, ai gɨnɨg gɨmön hon hanabön? Yöp magö ap nɨŋ mɨdaimön rö lagöp ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Anɨg hagöm, bɨ nɨpe gau kalɨp haga, “Hon nan naij gun rö löp, a gɨmim, nɨŋ aij gɨmim, God nɨp sabe göl gɨ mɨdaimim. Gasɨ kale u gɨmim rö löp u pen hañ romaŋ kale iru maru göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anɨg hagöm, kauyaŋ ado gɨ amöm, Nap nɨp nöd sabe ga rö, kauyaŋ sabe ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pen kauyaŋ ado gɨ apöm nɨŋa, bɨ nɨpe gau böŋ nöp hon kal auö han arla. Nɨŋöm, kalɨp haga, “Kale hon hanabim ar?” a ga. Hagö, ana udöm, pen hagöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pen Jisas gɨsön amöm, ado gɨ apöm kauyaŋ hon haneila u nɨŋöm haga, “Kale yɨharɨŋ han mɨdpim ar? Me aij! Bɨ game, nɨŋim! Bɨ ap apöm, Bɨ Ñɨ nɨpe kain göm, bɨ nan si nan naij gɨpal gau kalɨp ñɨnɨg gab. ");
INSERT INTO kpw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Urakpe arun! Nɨŋim! Bɨ yɨp kain göp auab i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas kalɨp manö anɨbu hagö nɨŋöl gɨ, magö anɨbu nöp, bɨ nɨpe unbö mɨgan laŋ ap, Judas, bɨ iru nöp dapöm apjaka. Bɨ anɨb gau, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb gau abe, bɨ manö ud asɨkep gau abe, hag yulö aula. Kale ru mɨlö kɨd rɨmnap udöm, ur pakep rɨmnap udöm, aula. ");
INSERT INTO kpw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nöd kalɨp hag löm haga, “Yad bɨ ap nɨp am hag wɨhai udem, ud bom haluem, mulu ñɨŋeinam u, bɨ u me, a gɨmim, nɨp ud sɨsɨ lɨmim, ud arim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas anɨg hagöm, Jisas mɨdeia au amjaköm, “Manö hag ñeb bɨ,” a göm, nɨp ud bom haluö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","bɨ rɨmnap apöm, Jisas nɨp ud sɨsɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jisas ud sɨsɨ lɨlö nɨŋöl gɨ, Jisas bɨ nɨpe ap uraköm, ru mɨlö kɨd nɨpe u ud ɫɨp gɨ udöm, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u wög nɨp gɨ ñɨmɨdöp bɨ u, nɨp rɨmɨd böŋ lap u böŋ nöp rɨb ajaŋ al yua. ");
INSERT INTO kpw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pen Jisas bɨ nɨp ud sɨsɨ lɨla gau kalɨp haga, “Ru mɨlö kɨd udmim, ur pakep udmim, yɨp nan si udep bɨ ap a gɨmim auabim aka? ");
INSERT INTO kpw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yad pör pör God sabe gep ram u amem, kale aip mɨdem, nɨbi bɨ gau kalɨp manö hag ñɨmɨdin u pen yɨp ud sɨsɨ lagpe. Pen uri kale God Manö u kalɨ kƚiñ rɨköm hagla rö nöp gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pen magö anɨbu nöp, Jisas bɨ nɨpe gau magöŋhalö nɨp arö göm pɨñɨŋ gɨ aram hakla. ");
INSERT INTO kpw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bɨ praj ap, waƚɨj mɨlöbö ap nöp yɨmöm, Jisas nɨp ud areila u hain arö, nɨp abe ud sɨsɨ lun, a gɨlö, ");
INSERT INTO kpw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pɨrɨk areia, waƚɨj bad nɨpe u ud ju udlö, nɨpe magö nöp pɨrɨk ara. ");
INSERT INTO kpw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisas nɨp dam, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ ram u arla. Ud areila, bɨ God nɨp nan sabe gep bɨ kub gau löm, bɨ manö ud asɨkep gau löm, bɨ lo manö hag ñeb bɨ gau löm, ap ram anɨbu magum gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pida pen hapi hapi nɨŋ damöm, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ ram nɨpe u amjaköm, bɨ ram anɨbu wög gɨmɨdal gau aip asɨköm, mab mali mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɨ God nɨp nan sabe gep bɨ kub gau abe, Juda Kansol kub bɨ gau magöŋhalö abe, Jisas gɨ ajmɨdöp manö iƚ ap udun, nɨp al pak lun, a gɨ nɨŋ wasö nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɨbi bɨ iru nöp daulö, Jisas nɨp manö piral adö rɨmnap hagla u pen manö hagla u adɨp adɨp hagagla. Ke ke haglö, manö iƚ rɨmnap nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pen rɨmnap uraköm, piral hagöm, hagla, ");
INSERT INTO kpw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hon nɨŋ mɨdno, nɨpe haga, ‘God sabe gep ram, ñɨmagö udöm gɨla i, rɨb waƚ gɨ yuem, ñɨn mɨhau nɨgaŋ u, kauyaŋ gɨnabin. Ñɨmagö udöm gɨpal rö u gagnabin; ram anɨbu ke yabɨƚ ap gɨnabin,’ a göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Manö hagla anɨbu u rö nöp adɨp adɨp hagagla; ke ke hagla. ");
INSERT INTO kpw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u uraköm, Jisas nɨp haga, “Manö nöp hagaböl u, ne manö pen ap hagagnabön ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hagö, Jisas manö ap pen hagagö, kauyaŋ hag nɨŋöm haga, “Ne me Mesaia u, Bɨ Kub aij u Ñɨ nɨpe aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hageia, Jisas haga, “Yau me. Me yad nöp. Yad, Bɨ Ñɨ nɨpe, Bɨ Kub kƚö ke yabɨƚ ñɨmagö yɨjɨg kɨd lau adö asɨk mɨd arö gem, kumi kabö adö laŋ au nɨbö kumi bad aŋ aŋ lem aueinabin, nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Jisas anɨg hagö, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u, waƚɨj nɨpe gau ke ud bɨƚɨƚɨ göl gɨ haga, “Nɨpe God hib nɨpe u rɨb juajɨp u nɨŋbim! Anɨb u, nɨbi bɨ rɨmnap hag nɨŋagun. Nɨpe gɨ naij göp u waiö hagöp me u. Anɨb u, kale nɨhön gasɨ nɨŋabim?” ö ga. Hagö, bɨ kub gau magöŋhalö uraköm, hagla, “Bɨ anɨg göl hagöp anɨbu, nɨp al pak lep,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Anɨg hagöm, bɨ rɨmnap Jisas nɨp kɨñu alöm, waƚɨj bad ap ud amgö nɨp u paƚu gɨ ñöm, nɨp paköl gɨ hagla, “Ne ke nɨŋmön, hanɨp hagö, nɨŋun, nöp an pakab?” ö gɨla. God sabe gep ram bɨ polisman gau, u rö nöp nɨp mɨñu magö nöp pakla. ");
INSERT INTO kpw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pida am asɨka au nöp mɨdö nɨŋöl gɨ, nɨbi praj ap, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u nɨp wög gɨ ñɨmɨdöp ap apjaköm, ");
INSERT INTO kpw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pida mab run naböŋ mɨdeia au nɨŋöm, haga, “Ne u rö nöp Jisas bɨ Nasared nɨbö u aip ajmɨdan,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hageia, Pida haga, “Ne nɨhön hagabön? Manö hagabön u yad nɨŋagpin,” a ga. Anɨg hagöm, höŋ yaŋ arö nɨŋöl gɨ, kɨƚakɨƚ wɨñ ala. ");
INSERT INTO kpw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nɨbi praj anɨbu nöp, Pida nɨp kauyaŋ nɨŋöm, nɨbi bɨ mɨdeila gau kalɨp haga, “Bɨ i bɨ nɨpe ap,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hageia, Pida kauyaŋ wasö ga. Yöp magö ap mɨdöm, nɨbi bɨ urak mɨdeila anɨb gau, Pida nɨp kauyaŋ hagla, “Ne u rö nöp ram mɨnöŋ Galili nɨbö u me, hon nɨŋbun ne abe bɨ nɨpe ap,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hageila, Pida haga, “Bɨ Kub nɨŋ mɨdöp; piral hagnö, yɨp al pak lɨnɨm. Pen nɨŋö yabɨƚ hagabin! Bɨ anɨg hagabim u yad nɨŋagpin yabɨƚ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anɨg hagö nɨŋöl gɨ, kɨƚakɨƚ u kauyaŋ wɨñ ala. Wɨñ alö, Pida Jisas nöd haga, “Kɨƚakɨƚ wɨñ mɨhöp alagnab magö u, ‘Yad Jisas nɨp nɨŋagpin,’ a gɨmön, ij mɨhau nɨgaŋ wai ñɨnabön,” a ga manö u nɨŋö, mög gö, mɨɫöŋ kub ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hilɨm halö, bɨ God nɨp nan sabe gep bɨ kub gau löm, bɨ lo manö hag ñeb bɨ gau löm, bɨ manö ud asɨkep gau löm, Juda Kansol bɨ kub gau magöŋhalö löm, magöŋhalö manö hag gum göm, Jisas nɨp nagɨ löm, dam gapman bɨ kub Pailod mɨdeia u ud arla. ");
INSERT INTO kpw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dam arlö, Pailod Jisas nɨp haga, “Ne Juda nɨbi bɨ kiŋ kale u aka?” ga. Hageia, Jisas haga, “Me ne hagpan me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bɨ God nɨp nan sabe gep bɨ kub gau Jisas manö kub hagöm manö ke ke iru nöp hagla. ");
INSERT INTO kpw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Anɨg gö, Pailod Jisas nɨp haga, “Nöp manö iru hagaböl u, ne pen manö rɨmnap hagagnabön ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hagö, Jisas pen manö hagagö, Pailod gasɨ iru yabɨƚ nöp nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pen Juda kai Pasopa ñɨn kub u auö, pör am Rom gapman bɨ kub Pailod nɨp hag nɨŋlö, kalɨp bɨ nagɨman kale hag nɨŋmɨdal bɨ u nöp yɨharɨŋ hag höŋ yumɨdöp. ");
INSERT INTO kpw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pen ñɨn anɨbu, bɨ ap hib nɨpe Barabas nɨbi bɨ rɨmnap ugalöm, Rom gapman aip pen pen göm, wip al pak lɨla rö, kalɨp nagɨ lɨlö mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nɨbi bɨ gau ap magum göm, Pailod nɨp bɨ nagɨman pör hag nɨŋmɨdal rö hag nɨŋlö, ");
INSERT INTO kpw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailod kalɨp haga, “Juda kiŋ kub kale u, kalöp hubɨk yunam aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nɨhön gɨnɨg: Pailod nɨpe ke nɨŋa, bɨ God nɨp nan sabe gep bɨ kub gau, Jisas nɨp yɨharɨŋ mulu kal nɨŋla rö, nɨp dap ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pen bɨ God nɨp nan sabe gep bɨ kub gau, nɨbi bɨ gau kalɨp hagla, “Pailod nɨp hagpe, Jisas wasö, Barabas nɨp hubɨk yunɨm,” a gɨla. Anɨg gɨlö, nɨbi bɨ gau Pailod nɨp hagla, “Barabas nɨp hanɨp hubɨk yumön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Anɨg hageila, Pailod haga, “Anɨg hagpim u, pen bɨ anɨbi kale Juda kiŋ hon a gɨpim u, nɨp nɨhön gɨnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hagö, kale manö bƚaƚö göm hagla, “Nɨp mab ba laŋ al pak lɨmön!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hageila, Pailod haga, “Nɨpe nɨhön gɨ naij gö, anɨg gɨnam?” ö ga. Anɨg hageia pen kale bƚaƚö yabɨƚ göm hagla, “Mab ba laŋ al pak lɨmön! Mab ba laŋ al pak lɨmön!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pen Pailod, manö kƚö hagla anɨbu udöm, nɨbi bɨ gau kalɨp aij gaŋ, a göm, Barabas nɨp yɨharɨŋ hag yuöm, bɨ nɨpe rɨmnap kalɨp hagö, Jisas nɨp nagɨ löm, mɨñu magö pakla. Jisas nɨp pak pɨs gɨlö nɨŋöl gɨ, Pailod haga, “Nɨp dam mab ba laŋ al pak lɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami bɨ gau, Jisas nɨp dam gapna Pailod ram kub nɨpe u amöm, bɨ yam kale rɨmnap kalɨp wɨñ allö aueila, ");
INSERT INTO kpw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","waƚɨj aɫɨ mɨlöbö ap, gapman bɨ kub gau rol gɨ mɨdmɨdal rö Jisas nɨp rɨm ñöm, nan kalɨ kalɨ halö rɨmnap rɨk dapöm, kiŋ rol gɨpal usajɨl bad rö ap göm, nɨp nabɨc cög adö laŋ rol gɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rol gɨ ñöm, Jisas nɨp aƚeb aƚeb ñöl göm hagla, “Ne Juda kiŋ kub pör nöp mɨdmön!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Anɨg hagöm, ur udöm, nabɨc nɨpe paköm, nɨp kɨñu al ñɨla. Mɨdeia söl au kugom yɨmöm, kale kiŋ nɨp gɨmɨdal rö, nɨp ubör yɨhöŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nɨp anɨg göl hag juöm, waƚɨj aɫɨ mɨlöbö nɨp rɨm ñɨla u ud ju yuöm, waƚɨj nɨpe ke u yɨm ñöm, mab ba laŋ al pak lɨnɨg ud arla. ");
INSERT INTO kpw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kale aŋ au amöl gɨ, Aleksada Rupas madöl mɨhau nap kale Saimon, Sairini daun nɨbö bɨ u, gau gɨ ajöm, apöm Jerusalem arnɨg areia u, nɨp nable paköm, kƚö göm, hagla, “Jisas mab kros u ud kag gɨmön ud aru!” a gɨlö, udöm kalɨp aip ara. ");
INSERT INTO kpw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anɨg göl amöm, Jisas nɨp dam ram mɨnöŋ au manö yöl hib Golgoda a gɨmɨdal ka au amjakla. Golgoda manö iƚ u “Wip Nabɨc Cög Ij.” ");
INSERT INTO kpw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amjaköm, nɨp ñɨg wain ap udöm, marasɨn mö a gɨmɨdal rɨmnap ud bɨg ado malo göm, Jisas nɨp ñɨla pen ñɨŋaga. ");
INSERT INTO kpw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jisas nɨp mab ba laŋ al pak löm, waƚɨj nɨp gau udöm, nɨme lɨ ke ke udnɨg, sadu rö göl göm udla. ");
INSERT INTO kpw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sɨdö hilɨm halö lɨm gɨ yuöm yöp audɨk galɨk aua magö u, Jisas nɨp mab ba laŋ cɨpɨƚ pak lɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cɨpɨƚ pak löm, nɨhön gɨnɨg al pak lɨla manö u, mab kros ba adö laŋ kalɨ kƚiñ rɨkla: ");
INSERT INTO kpw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mañ anɨbu, bɨ nan si udep mɨhöp u rö nöp al pak lɨla, ap mab böŋ lap, ap mab böŋ lap. ");
INSERT INTO kpw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gɨla anɨbu, God Manö u kalɨ kƚiñ rɨköm, gɨnaböl a gɨla rö nöp gɨla. Manö anɨbu kalɨ kƚiñ rɨköm hagla, “Nɨp nɨŋlö, bɨ nan naij gep ap rö lɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nɨbi bɨ gau ap ran ap lugöl gɨ, Jisas nɨp nɨŋöm, nabɨc gor mar göm, nɨp hag juöm hagla, “Ne, ‘God sabe gep ram u rɨb waƚ gem, ñɨn mɨhöp nɨgaŋ kauyaŋ gɨ lɨnabin,’ a gɨna u, ");
INSERT INTO kpw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mɨñi ne ke gɨmön, kamɨŋ arö, hon nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, Jisas nɨp u rö nöp hag juöm, kalɨp ke nöp pen hagö pen hagö göm hagla, “Nɨbi bɨ rɨmnap kalɨp gajɨp kamɨŋ arbal u pen uri nɨp ke gö kamɨŋ arnɨm rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nɨpe pör hagöp, ‘Isrel nɨbi bɨ Mesaia mɨdpin, Isrel Kiŋ mɨdpin,’ a göp rö, mɨñi nɨp au laŋ cɨpɨƚ pak lɨbal u, nɨpe ke u rö nöp urak aui auö nɨŋun nɨŋö hagöp, a gun, nɨp nɨŋ udnabun,” a gɨla. Pen bɨ Jisas aip al pak lɨla mɨhau Jisas nɨp u rö nöp hag julö. ");
INSERT INTO kpw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sɨdö aŋ aulɨk aua magö u, sɨbön göm, mɨd damöm, sɨdö gamɨŋ ga magö u kauyaŋ mailö ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mailö gö nɨŋöl gɨ, Jisas meg mɨgan dap ranöm, wɨñ al hagöm haga, “Eloi, Eloi, lama sabakdani?” ö ga. Hibru manö haga anɨbu manö iƚ u, “God yad. God yad. Yɨp ai gɨnɨg arö gɨpan?” ");
INSERT INTO kpw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hagö, nɨbi bɨ söl anɨb au mɨdeila gau nɨŋöm hagla, “Nɨŋim! Ilaija nɨp wɨñ alab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pen bɨ ap nan hain auebö rö bad ap udöm, ñɨg wain mani pro raubal mɨgan yaŋ rauöm, Jisas nɨp ñɨnö ñɨŋaŋ, a göm, gamɨƚ mɨlö ap ud abös alöm, mɨdeia adö laŋ ñöl gɨ, haga, “Hon nɨŋ mɨdno, Ilaija apöm, nɨp ud asɨk dam mɨnöŋ iƚ yaŋ lɨnab aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Anɨg hagöm, nɨŋ mɨdlö nɨŋöl gɨ, Jisas wɨñ kub alöm, uma. ");
INSERT INTO kpw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Magö anɨbu nöp, waƚɨj mɨlö kub God sabe gep ram magö raul mɨgan yaŋ ajöŋ pɨƚ gɨla u, aŋ u pa bɨƚɨƚɨ göm, ke ke lap lap aram mɨgan hiɨk mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bɨ ami gau abad mɨdmɨdöp bɨ kub u, mab kros ba aŋ aui adö au gɨlaŋ mɨdeia u, Jisas anɨg hagöm uma u nɨŋöm, nan nɨhön nɨhön ga gau nɨŋöm, haga, “Nɨŋö hagpal! Bɨ anɨbi God Ñɨ nɨpe yabɨƚ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Nɨbi iru nöp Jisas aip Jerusalem aula gau, apöm goƚ au mɨdeila. Aŋ anɨbu, nɨbi mɨhau nɨgaŋ Jisas nɨp wög pro pro rɨmnap gɨ ñɨmɨdal ram mɨnöŋ Galili. Nɨbi Maria mɨhöp mɨdailö; nɨbi hib aƚog anɨb mɨhau, ap Magdala daun nɨbö, ap Jems Josep madöl mɨhau nɨme kale u. Nɨbi ap hib nɨpe Salomi. Nɨbi anɨb gau magöŋhalö nɨŋ mɨdlö nɨŋöl gɨ, Jisas uma. ");
INSERT INTO kpw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Josep bɨ Arimadia daun nɨbö, Juda Kansol kub bɨ gep ap, God nɨbi bɨ udöm abad mɨdeinab ñɨn anɨbu abad mɨdmɨdöp. Bɨ anɨbu, rol God nɨp sabe gep ñɨn u, a göm, nan gɨ jɨn geia. Jisas uma u nɨŋöm, ram söl dugnɨg gab, a göm, mɨñi wip he ud asɨk dam rɨgöl gɨnam, a göm, pɨñɨŋ gaga; Pailod mɨdeia u amöm, hag nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hag nɨŋö, Pailod, Jisas hadö uma manö u nɨŋöm, pa gɨƚɨ göm, bɨ ami bɨ abad mɨdmɨdöp bɨ kub u nɨp wɨñ alö, aueia, hag nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hag nɨŋeia haga, “Mɨdönöp umöb,” a ga. Anɨg hagö, Pailod Josep nɨp haga, “Yau. Wip dam rɨgöl gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hagö, Josep waƚɨj rud kub ap rauöm, am wip he ud asɨk dap lugöm, waƚɨj u ud magöŋhalö wam wam göm, dam kabö mɨgan gɨsön nɨbö nöp ƚu lɨla kabö mɨgan u rɨgöl ga. Rɨgöl göm, kabö haƚai kub ap ud gau ga gɨ damöm, wip rɨgöl ajöŋ u pɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdala aip, Maria Josep nɨme u aip, nɨŋ mɨdlö nɨŋöl gɨ, wip rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda God nɨp sabe gep ñɨn kale u ap padiö, Maria Magdala u, Maria Jems nɨme u, nɨbi Salomi u, wip he u wel lɨ ñun, a göm, am wel haƚɨŋ aij auep rɨmnap rau dap lɨlö hana. ");
INSERT INTO kpw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ruö Sade ñɨn u, sɨb halö uraköm, wip rɨgöl gɨla u areila. ");
INSERT INTO kpw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Adan aŋ au aramöl gɨ hagla, “Kabö kub wip rɨgöl ajöŋ pak pɨƚ gɨla u, an ud kɨƚɨƚɨ gɨ goƚ gau yunab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Anɨg hagöm, amjaköm, nɨŋla, kabö kub wip rɨgöl ajöŋ pak pɨƚ gɨla anɨbu, hadö ƚɨƚɨ gɨ am goƚ au mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɨŋöm, mɨgan anɨbu hiɨkɨd amöm nɨŋla, bɨ praj waƚɨj rud mɨlöbö yɨma ap, ñɨmagö yɨjɨg lau adö asɨk mɨdeia. Nɨp nɨŋöm pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pɨñɨŋ geila, kalɨp haga, “Pɨñɨŋ gagmim. Yad nɨŋbin, kale Jisas bɨ Nasared nɨbö, mab ba laŋ al pak lɨla u nɨp nɨŋnɨg auabim. Pen nɨŋim! Nɨpe aui mɨdagöp. Nɨpe mɨdö nöp uraköm aröp. Nɨp rɨgöl gɨla ka u nöp mɨdöp aui ap nɨŋim. ");
INSERT INTO kpw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pen yɨŋɨd ammil, bɨ nɨpe gau Pida aip hagmil, ‘Jisas nɨpe nöd amöm Galili mɨdeinab. Nɨpe ke kalöp nöd haga rö, kale am nɨpe nɨŋnabim anɨb gau,’ a gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Anɨg hagö, nɨbi gau anɨnɨn gö, ñɨn ma gɨl gɨl göm, wip rɨgöl höŋ amöm arö göm, gɨ dö gɨ arla. Pɨñɨŋ gɨla nɨŋöm nɨbi bɨ rɨmnap kalɨp manö anɨbu hag ñagla. ");
INSERT INTO kpw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas umöm, ñɨn wañɨgnɨbö u uraköm, nöd yabɨƚ amöm, Maria Magdala mɨdeia au waiö lö, nɨp nɨŋa. Pen nɨbi anɨbu nɨp nöd kɨjaki aiön pi unbö mudun jɨŋ u abaŋ al mɨdeia nɨŋöm Jisas hag höŋ yua. ");
INSERT INTO kpw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Nɨpe Jisas nɨp nɨŋöm, am bɨ nɨpe gau mɨɫöŋ gɨ mɨdeila aŋ au amöm, Jisas kamɨŋ mɨdöp nɨp nɨŋbin, a gö, kale böŋ nöp umöb, a göm, manö nɨp u udagla. ");
INSERT INTO kpw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hainö pen, Jisas bɨ nɨpe mɨhöp ram mɨnöŋ mɨgan ap gɨ ajailö, Jisas bɨ unbö ke rö löm apöm, adan aŋ au waiö lö, nɨp nɨŋmil, ");
INSERT INTO kpw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","am bɨ nɨpe rɨmnap kalɨp hag ñɨlö u pen, nɨŋö hagabil, a göm, manö kale udagla. ");
INSERT INTO kpw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hainö mañ ap me, Jisas bɨ nɨpe unbö agɨp laŋ u nan ñɨŋeila aŋ au waiö löm, kalɨp hag göl gɨ haga, “Yad uraknö, nɨbi bɨ rɨmnap yɨp waiö nɨŋöm, apöm kalöp hag ñɨlö, nɨhön gɨnɨg piral hagpal, urakagöp, a gɨmim, nɨŋbim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Anɨg hagöm, kalɨp haga, “Kale manö aij yad u dam ram mɨnöŋ gau gau magöŋhalö ammim, nɨbi bɨ gau magöŋhalö hag ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nɨbi bɨ an an, manö aij yad anɨbu nɨŋ udöm, ñɨg paknaböl gau, kamɨŋ arnaböl. Pen nɨbi bɨ an an nɨŋ udagnaböl gau, God kalɨp manö kub hagö ilön udnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Nɨbi bɨ manö yɨp nɨŋöm, ‘Nɨŋö hagöp,’ a göm, nɨŋ udnaböl gau, nan gagep rö gɨnaböl. Kɨjaki aiön pi nan gau nɨbi bɨ kalɨp abaŋ alnab gau, hib yad u hagöm, hag höŋ yunaböl. Manö yabɨƚ kale u arö göm, manö gɨsön nɨbö adö ap ke hagnaböl. ");
INSERT INTO kpw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Re gadgoƚ nɨbi bɨ hauöp gau ud nɨŋlö, nan ap gö umagnaböl. Nan naij nɨbi bɨ ñɨŋöm umbal gau rɨmnap ñɨŋlö, nan ap gö umagnaböl. Pen nɨbi bɨ nan gɨnab gau, kalɨp ñɨmagö lɨlö, kamɨŋ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bɨ Kub Jisas manö anɨbu kalɨp hag pɨs gö nɨŋöl gɨ, God nɨp udöm, ram mɨnöŋ nɨpe kumi kabö adö laŋ au ud ara. Ud arö, God ñɨmagö yɨjɨg nɨp lau adö asɨka. ");
INSERT INTO kpw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pen bɨ nɨpe gau amöm, Krais manö aij u ram mɨnöŋ gau gau magöŋhalö hag ñɨlö arö nɨŋöl gɨ, Bɨ Kub, manö aij yad nɨŋö lɨnɨm, a göm, kalɨp aip mɨdöm, kƚö ñö, nan gagep rö gau gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jisas Krais aŋ hanɨp i yag daulö kub göm ga ga rö, bɨ rɨmnap amgö magö kale ke nɨŋöm, manö aij anɨbu hag ñɨ ajöm, yɨp abe, nɨbi bɨ gau rɨmnap halö kalɨp abe, hag ñɨla. Hag ñeila bɨ iru rö manö anɨbu nɨŋ aij göm kalɨ kƚiñ rɨkla. ");
INSERT INTO kpw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pen bɨ majö Diopilas, yad u rö nöp manö yɨp hag ñɨla anɨbu iƚ u magöŋhalö uƚhai nɨŋ aij gɨpin u me, yad u rö nöp manö anɨbu magöŋhalö gasɨ nɨŋ aij gem, nöp kalɨ kƚiñ rɨknɨg gabin. ");
INSERT INTO kpw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Anɨg gɨnö me, manö nöp hagla nɨŋban u, nɨŋö hagla a gɨmön nɨŋnabön. ");
INSERT INTO kpw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nöd Kiŋ Herod Judia Propins abad mɨdmɨdöp ñɨn u, bɨ ne Sekaraia, God nɨp nan sabe gep bɨ ap mɨdmɨdöp. Bɨ yam nɨpe aip wög jɨm ñöl gɨmɨdal gau kalɨp Abaija Yam a gɨmɨdal. Sekaraia nɨbin nɨpe Ilisabed. Ilisabed u rö nöp God nɨp nan sabe gep bɨ Eron iƚ u rɨk dam dapɨl göm rɨkla. ");
INSERT INTO kpw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kalpe ber mɨhau God lo manö adö u magöŋhalö hain göl gɨ mɨdlö, God nɨŋö, manö ap mɨdageia. ");
INSERT INTO kpw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pen Sekaraia nɨbin nɨpe Ilisabed ñɨ pai wem u me, ñɨ pai ap yag dapöm wasö, böŋ nöp nɨbi mɨƚep bɨ mɨƚep lɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ñɨn ap Sekaraia bɨ nɨpe aip wög jɨm ñöl gɨmɨdal gau apöm, God nɨp sabe gep wög u geila. ");
INSERT INTO kpw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pen wög kale u göl gɨ, bɨ God nɨp nan sabe gep bɨ gau pör gɨmɨdal rö, bɨ hon an rö God sabe gep ram raul mɨgan yaŋ amöm nan haƚɨŋ aij auep u launab a göm, ilöŋ cal ud gulu gɨ udla. Udlö, Sekaraia nɨpe ilöŋ cal ke ud gulu gɨ udöm, God sabe gep ram raul mɨgan yaŋ arnɨg ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nɨbi bɨ iru nöp God sabe gep ram höŋ adö au God nɨp sabe göl gɨ mɨdailö nɨŋöl gɨ, Sekaraias nɨpe raul mɨgan yaŋ aramöm nan haƚɨŋ aij auep anɨbu laua. ");
INSERT INTO kpw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pen Bɨ Kub ejol nɨpe ap apöm, nan haƚɨŋ aij lep kabö kɨnaŋ u ñɨmagö yɨjɨg adö lau waiö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ejol anɨbu nɨŋöm pa gɨƚɨ ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pen ejol anɨbu nɨp haga, “Ne pɨñɨŋ gagmön. God nɨp sabe gɨpan u, nɨpe nɨŋöb. Nabin ne Ilisabed ñɨ ne ap yag daunab. Yag dauö, hib nɨpe Jon a gɨmön. ");
INSERT INTO kpw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɨme ñɨ u yag daunab u, ne mɨñ mɨñ gɨnabön; nɨbi bɨ iru nöp gau u rö nöp mɨñ mɨñ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bɨ Kub amgö ilö adö nɨpe u, Jon bɨ kub rö mɨdeinab. Nɨpe ñɨg wain aka ñɨg kƚö rɨmnap ñɨŋagnɨm. Nɨme ñɨ mɨdun mɨdeinab ñɨn anɨbu nöp, Ana Uɫ nɨpe ñɨ anɨbu nɨp aŋ daŋ amöm ajmaŋ raunab. ");
INSERT INTO kpw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hainö nɨpe Isrel nɨbi bɨ God nɨp arö gɨpal gau iru nöp manö aij hag ñö, God nɨp, Bɨ Kub hon, a göm, nɨŋ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pen ñɨ ne anɨbu nɨpe bɨ God manö hagep Ilaija hadame ram God pɨdöŋ udöm gɨmɨdöp rö gɨnab. Nap bɨ kalɨp udöm, ñɨ pai kale gau udöm, kalɨp ud jɨm ñöl lɨnab. Nɨbi bɨ God nɨp aƚeb aƚeb ñɨbal gau, kalɨp manö aij hag ñö, nɨbi bɨ kamɨŋ aij nɨpe gasɨ nɨŋbal rö nɨŋöm, gɨ aij göm, Bɨ Kub aunab, a göm, abad mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ejol u anɨg hagö, Sekaraia haga, “Hol ber mɨhau mɨƚep yabɨƚ lɨbul. Anɨb u, yad aigöl gem, ne nɨŋö hagpan, a gɨ nɨŋnabin?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hagö, ejol u Sekaraia nɨp haga, “Yad Gebriel. Yad God amgö ilö adö u mɨdem, yɨp hag yuö apem manö aij anɨbi nöp hag ñɨnɨg aubin. ");
INSERT INTO kpw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ne manö yad u, nɨŋö hagöp a gɨmön nɨŋagpan rö, aɫab nöp u marö gö, manö hagöl gɨ mɨdageinabön. Yɨharɨŋ nöp mɨd mɨd, ñɨ u yag daunabil mañu nöp kauyaŋ manö hagnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pen Sekaraia God sabe gep ram aŋ raul yaŋ mɨlö padö mɨdeia nɨŋöm, nɨbi bɨ höŋ yaŋ mɨdeila gau gasɨ iru nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hainö nɨpe höŋ apöm, manö rɨmnap hagnɨm rö laga. Anɨb u, yɨp anɨg anɨg göp, a göm, ñɨmagö nöp yamaia. Kale nɨŋöm hagla, nɨpe ram raul mɨgan yaŋ am mɨdöm, nan ap ke nɨŋöm auöp, a göm, nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pen Sekaraia God sabe gep ram wög u gɨ mɨdö, ñɨn nɨpe u pɨs gö, bɨ rɨmnap apöm ka nɨpe u udlö nɨŋöl gɨ, nɨpe ado gɨ ram nɨpe ara. ");
INSERT INTO kpw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Hainö mɨd damöm, nɨbin nɨpe Ilisabed ñɨ mudun mɨdöm haga, “Nöd yad nɨbi ñɨ pai wem mɨdmɨdin u me, yɨp nable ga, jɨ mɨñi Bɨ Kub yɨp mög nɨŋöm yɨp abad mɨdö, ñɨ mudun mɨdpin u yɨp aij göp, nable gagnab, wasö,” ga. Anɨg hagöm, rakɨn unbö mamɨd agamɨj ram raul mɨgan gau nöp pi göl mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabed rakɨn unbö kagoƚ jɨŋ ñɨ mudun mɨdö nɨŋöl gɨ, God ejol Gebriel nɨp hag yuö ara Nasared daun, ram mɨnöŋ Galili au. ");
INSERT INTO kpw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nasared au nɨbi praj ap mɨdmɨdöp, hib nɨpe Maria. Nɨbi praj anɨbu bɨ ap aip gɨ gö wasö. Nɨbi praj anɨbu, bɨ ne Josep udnab, a göm manö hagla. Bɨ Josep anɨbu, nɨp kiŋ Depid bɨ rɨdɨg anɨbu ap rɨk dam lɨla u me. ");
INSERT INTO kpw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","God ejol Gebriel hag yuö, nɨbi praj Maria mɨdeia au amjaköm haga, “Nɨbi praj, ne mɨdpan? Bɨ Kub nöp ud aij göp. Nɨpe aip mɨdpil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anɨg hagö, Maria manö anɨbu nɨŋöm, yɨp ai gɨnɨg anɨg hagab, a göm, gasɨ iru nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nɨpe gasɨ iru nɨŋö nɨŋöl gɨ, ejol nɨp haga, “Maria, ne pɨñɨŋ gagmön. God nöp ud aij yabɨƚ göp. ");
INSERT INTO kpw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hainö ne ñɨ mudun mɨdmön, ñɨ ap yag daunabön. Yag daumön, hib nɨpe Jisas, a gɨmön. ");
INSERT INTO kpw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pen nɨpe bɨ kub yabɨƚ mɨdeinab. Nɨbi bɨ nɨp hagnaböl, Bɨ Kub yabɨƚ adö i gɨlaŋ mɨdöp Ñɨ nɨpe, a gɨnaböl. God Bɨ Kub geinab nɨŋöm nɨpe nɨhi iƚaŋ Depid, kiŋ kub mɨdmɨdöp rö mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jekop rɨkö rɨk amɨl apɨl gɨlö mɨdeinaböl gau kalɨp magöŋhalö pör nöp pör nöp kiŋ kale mɨdöm abadöl mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ejol anɨg hagö, Maria nɨp haga, “Yad bɨ ap aip mɨdagpul u, aigöl gem ñɨ anɨbu yag daunabin?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hageia, ejol nɨp haga, “Ana Uɫ u nöp apöm, Bɨ Kub yabɨƚ adö i gɨlaŋ mɨdöp pɨdöŋ nɨpe nöp ralu ñɨnab. Anɨg gö, ñɨ uɫ yag daunabön u, nɨbi bɨ nɨŋöm hagnaböl, nɨpe God Ñɨ nɨpe, a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nöŋ! Naubi ne Ilisabed nɨpe nɨbi mɨƚep löp. Kale nɨp nɨbi ñɨ pai wem a gɨmɨdal u pen mɨñi nɨpe ñɨ mudun mɨdö, rakɨn unbö kagoƚ jɨŋ hadö ara. ");
INSERT INTO kpw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God nan gagnɨm rö ap mɨdagöp; nan gau magöŋhalö gɨnɨm rö nöp mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anɨg hagö, Maria haga, “Yad God nɨp wög gɨ ñeb pai. Hagabön rö nöp yɨp gɨnɨm,” a ga. Anɨg hagö nɨŋöl gɨ, ejol nɨp arö göm ara. ");
INSERT INTO kpw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Pen Maria yɨŋɨd amnam, a göm, ram mɨnöŋ anɨbu arö göm ram mɨnöŋ Judia no ilö gau adan mɨlö u am am, Sekaraia Ilisabed ber mɨhau mɨdmɨdil daun u ara. Ram kale amjaköm, nubi Ilisabed nɨp haga, “Ne mɨdpan?” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","“Ne mɨdpan?” a gö, nubi Ilisabed manö anɨbu nɨŋö, ñɨ mudun mɨdeia u pɨraŋɨd la. Pen magö anɨbu nöp Ana Uɫ u nɨpe Ilisabed aŋ daŋ aramöm nɨp ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","God Ana ajmaŋ rauö, Ilisabed nɨpe meg mɨgan dap ranöm Maria nɨp haga, “God nɨbi rɨmnap kalɨp abad mɨdöp u pen nöp ud aij yabɨƚ göp. Ñɨ mudun ne mɨdpan yagol ñɨ u abe ud aij yabɨƚ göp. ");
INSERT INTO kpw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yad nɨbi aij wasö jɨ ne Bɨ Kub yad nɨme nɨpe u yɨp nɨŋnɨg auban u yad aiö gem God nɨp aij a gabin. ");
INSERT INTO kpw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne apön yɨp, ‘Mɨdpan?’ a gajan magö u, ñɨ mudun mɨdpin i ñɨñɨ yabɨƚ löm pɨraŋɨd löp. ");
INSERT INTO kpw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne, ‘Yɨp God hagöp rö gɨnab,’ a gɨmön nɨŋ mɨdpan u me, ne mɨñ mɨñ gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ilisabed anɨg hagö, Maria God nɨp gasɨ nɨŋöl gɨ, ñɨñɨ yabɨƚ löl gɨ haga, “Yad Bɨ Kub nɨp gasɨ nɨŋem, hib nɨpe hagnö, i adö laŋ arnab. ");
INSERT INTO kpw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Yad böŋ nöp umeb rö mɨdainö, God yɨp mög nɨŋöm ud kamɨŋ yua u, nɨp gasɨ nɨŋem ñɨñɨ yabɨƚ lɨbin. Yad yɨharɨŋ pai nɨp wög gɨ ñeb mɨdpin u pen yɨp hauƚ gagöp. Anɨg göp u, mɨñi rɨköm, hainö rɨköm, rɨk dam lɨnaböl gau, nɨbi bɨ magöŋhalö yɨp gasɨ nɨŋöm hagnaböl, ‘God nɨbi anɨbu ud aij yabɨƚ ga,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nɨpe pɨdöŋ magöŋhalö mɨdöp u, nɨpe nan kƚö yabɨƚ yɨp göp. Yad nɨŋbin nɨpe añɨ nöp Bɨ Uɫ mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nɨbi bɨ manö nɨpe nɨŋöm, ana udöm, hain gɨnaböl gau, kalɨp mög nɨŋöm ud aij gɨnab. Kale ñɨ pai rɨköm, rɨk damöm, rɨk lɨnaböl gau, kalɨp u rö nöp mög nɨŋöm ud aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nɨpe Bɨ ñɨmagö mɨlö kub yabɨƚ; nɨpe nan kƚö kƚö iru nöp göp. Nɨbi bɨ, hon ke nɨbi kub bɨ kub mɨdpun, a gɨpal gau, God kalɨp yu gɨ yuöp. ");
INSERT INTO kpw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anɨb u, kiŋ bɨ kub ram mɨnöŋ kub abad mɨdlö hib kub mɨdmɨdöp gau, God gö ke ke arlö, nɨbi bɨ hib mɨdagmɨdöp gau, God kalɨp udöm ud adö adö göp. ");
INSERT INTO kpw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nɨbi bɨ kɨyö löp gau, God kalɨp nan nɨme lö ñɨŋlö mudun göp. Pen nɨbi bɨ nan iru mɨdöp gau kalɨp yɨharɨŋ hag yuö arbal. ");
INSERT INTO kpw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God nɨpe apɨs bac iƚaŋ hon gau kalɨp manö haga u hauƚ gagöm, hanɨp Isrel nɨbi bɨ pör mög nɨŋöm abad mɨd aij göp. ");
INSERT INTO kpw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bac Ebraham abe, bac hon rɨmnap abe ñɨ pai kale rɨköm rɨklö arnab gau, God kalɨp abad mɨdeinabin, a göm, haga rö nöp hanɨp göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria manö anɨbu hagöm, nubi Ilisabed aip rakɨn mɨhau nɨgaŋ mɨdöm, hainö ado gɨ ram nɨpe ara. ");
INSERT INTO kpw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mɨd damöm, Ilisabed ñɨ ap yag daua. ");
INSERT INTO kpw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","God nɨp mög nɨŋöm abad mɨdö, nɨpe mɨƚep yabɨƚ löm ñɨ yag daua anɨbu, nɨbi bɨ nɨñɨn nubi nɨmam nuö bɨ nɨpe gau nɨŋöm, nɨpe aip mɨñ mɨñ yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ñɨ u yag dapöm, ñɨn unbö mudun jɨŋ mɨdöm, raleb jɨŋ mañu waŋ hañ nɨpe rɨb gɨ dö gɨnɨg göm magum gɨla. Magum göm, kale ñɨ u hib ñɨnɨg göm hagla, “Ñɨ anɨbi, nap Sekaraia hib u la ij gep,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hageila, nɨme haga, “Wasö, hib nɨpe Jon a gɨnabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Anɨg hagö, nɨbi bɨ nɨpe gau hagla, “Hon unbö anɨg gagun. Bac baid buö ne gau hib ap Jon mɨdagöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Anɨg hagöm, nap Sekaraia nɨp ñɨmagö u nöp yamöm hag nɨŋla, “Ñɨ hib nɨhön ñɨnabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hag nɨŋlö, nap ñɨmagö u nöp yamöm haga, “Yɨp köp kalɨ kƚiñ rɨkep ap dauim,” a ga. Hagö daueila, adö anɨbu manö kalɨ kƚiñ rɨköm, “Hib nɨpe Jon,” a ga. Anɨg göl hib kalɨ kƚiñ rɨkö, kale nɨŋöm magöŋhalö aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pen magö anɨbu nöp Sekaraia aɫab marö ga u pɨɫa gö nɨŋöl gɨ, nöd manö hagmɨdöp rö hagöl gɨ, God hib nɨpe hagö adö ara. ");
INSERT INTO kpw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɨbi bɨ söl au han mɨdeila gau, ga anɨbu nɨŋöm pɨñɨŋ göm, manö anɨbu yag dam ram mɨnöŋ Judia ilö gau magöŋhalö yabɨƚ nɨbi bɨ gau kalɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hageila, nɨbi bɨ manö anɨbu nɨŋla gau, kale magöŋhalö gasɨ iru nɨŋöm hagla, “God gö, ñɨ anɨbu anɨg göl yag dauöp u me, hainö bɨ aigale bɨ rö mɨdeinab?” ö gɨla. God pɨdöŋ ñɨ anɨbu pɨg mɨdeia u nɨŋla u me, anɨg hagla. ");
INSERT INTO kpw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ana Uɫ nɨpe ñɨŋaŋ nap Sekaraia aŋ nɨpe daŋ apöm ajmaŋ raua nɨŋöm God hib nɨpe u dap ranöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hon Isrel nɨbi bɨ, God Bɨ Kub hon hib nɨpe dap ranun hagno adö arnɨm. Nɨpe ke ram mɨnöŋ iƚ i apöm, nɨbi bɨ nɨpe rau adog udöp. ");
INSERT INTO kpw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God Bɨ Kub nɨpe gö, Depid rɨkö, rɨklö, rɨk amɨl apɨl gɨlö, ñɨŋaŋ ap yag dauö hanɨp ud kamɨŋ yunab. ");
INSERT INTO kpw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hadame nöp, manö yad nɨbi bɨ gau hagnɨg gabin, a göm, God nɨpe bɨ rɨmnap wög anɨbu hag la. God manö hagep bɨ uɫ nɨpe gau kale God manö haga u nɨŋöm, nɨbi bɨ gau kalɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bɨ al ñɨŋeb hon gau apöm, hanɨp al pak lɨnɨg gaböl pen nɨpe apöm hanɨp ud kamɨŋ yunab; bɨ hanɨp mulu lugö nɨŋbal gau hanɨp gɨ naij gɨnɨg gaböl u pen nɨpe hanɨp abad mɨdö kamɨŋ arnabun. ");
INSERT INTO kpw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","God hadame nöp bac iƚaŋ hon mög nɨŋöm ud aij gɨnabin, a göm, manö kƚö nɨŋö rɨmnap hag la. God nɨpe manö bac hon Ebraham nɨp hag la u hauƚ gagöp; manö uɫ anɨbu haga rö nöp göp. ");
INSERT INTO kpw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Bɨ Kub hanɨp abad mɨdö, koƚmaƚ gau hanɨp gɨ naij göl rö lagnab. Anɨb u, hon bɨ al ñɨŋeb gau pɨñɨŋ gagun, kamɨŋ mɨdeinabun rö, pör pör nöp Bɨ Kub nöp gasɨ nɨŋun, nan si nan naij arö gun, Bɨ Kub nɨbi bɨ uɫ nɨpe mɨdun, wög nɨp göl gɨ, gɨ mɨdeinabun. ");
INSERT INTO kpw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pen ñɨ yad, ne God Bɨ Kub nɨp wög gö, nɨbi bɨ gau kale nɨŋöm hagnaböl, ‘God Bɨ Kub yabɨƚ adö i gɨlaŋ mɨdöp u, bɨ manö nɨpe hagep me u,’ a gɨnaböl. Nɨhön gɨnɨg: ne nöd ammön, nɨbi bɨ gau kalɨp hag aij gö, Bɨ Kub u nɨp abad mɨdlö nɨŋöl gɨ, nɨpe aunab. ");
INSERT INTO kpw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ne nɨbi bɨ nɨpe gau kalɨp manö aij nɨpe u hag ñɨ aij gö, Bɨ Kub kale u apöm, nan si nan naij gɨpal prɨ u ƚɨk gɨ yuöm kalɨp udnab, manö aij u nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God Bɨ hain agamɨj rɨköm, nɨpe nɨbi bɨ mög nɨŋöm, mailö aij nɨpe sɨdö mailö rö kumi kabö adö laŋ nɨbö apöm, hanɨp mailö pak ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hon nɨbi bɨ an an sɨbön gau mɨdun umnɨg gɨnabun gau, nɨpe gö mailö magö anɨbu hanɨp mɨdmagö aŋ daŋ mailö pak ñɨnab nɨŋun, hon hibur hain hain mɨdep adan aij u uƚhai nɨŋun, adö anɨbu nöp ajeinabun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pen ñɨŋaŋ anɨbu, Jon, majö gö nɨŋöl gɨ, ana nɨpe halö halö pɨdöŋ ga. Nɨpe ram mɨnöŋ nɨbi bɨ mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau mɨd mɨd, böŋ nöp kub göm auö, Isrel nɨbi bɨ nɨp nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pen ñɨn aŋ anɨbu, gapman bɨ kub Sisa Ogasdas nɨpe lo löm haga, “Nɨbi bɨ yad abad mɨdpin gau, kale magöŋhalö hib kale udöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nöd api iƚ göm nɨbi bɨ hib udla ñɨn u, gapman bɨ kub Kwairinias Siria Propins nɨbi bɨ kalɨp abad mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anɨb u, nɨbi bɨ ram mɨnöŋ mɨlö kub gau ke nɨbö ke nɨbö ap yɨharɨŋ mɨdeila gau, ado gɨ ram mɨnöŋ kale ke hib udnɨg arla. ");
INSERT INTO kpw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep nɨpe kiŋ Depid kɨgɨn rɨk damöm rɨkla rö, nɨpe Depid daun nɨpe Bedlehem arnɨg ga. Nɨbi praj Maria nɨp uɫ gɨ, Nasared daun, ram mɨnöŋ Galili au arö gɨmil, aram aram ram mɨnöŋ Judia amöm, kiŋ Depid nɨp rɨklö mɨdmɨdöp daun nɨpe Bedlehem arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pen nɨbi praj Maria, Josep udnab a gɨla u me, ñɨ mudun halö mɨdö nɨŋöl gɨ, Josep Maria nɨp uɫ gɨ hib udnɨg arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kale Bedlehem arlö, Maria ñɨŋaŋ yag dauep ñɨn u söl ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pen Bedlehem gau amjakmil nɨŋlö, mani rauöm hanmɨdal ram u böŋ nöp sɨsɨ ga. Anɨb u me, kaj kau mukmɨdal ram ap am mɨdöm, Maria ñɨŋaŋ nöd añɨ u yag daua. Yag dapöm ñɨŋaŋ laplap wam wam göm, ud kaj sipsip nan haɫɨ habadö pɨñ u rɨk dap lɨlö ñɨŋmɨdal mab ij mɨgan u la. ");
INSERT INTO kpw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maria Jisas nɨp yag daua ñɨn anɨbu, kaj sipsip mukep bɨ gau rɨmnap sɨbön yaŋ kaj sipsip abad mɨdeila ram mɨnöŋ söl anɨb au. ");
INSERT INTO kpw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bɨ Kub ejol nɨpe ap yuö, Bɨ Kub mailö aij magö nɨpe apöm kalɨp pak nɨŋö, anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kale pɨñɨŋ gɨlö nɨŋöl gɨ, ejol u kalɨp haga, “Kale pɨñɨŋ gagmim. Yad kalöp abe nɨbi bɨ gau magöŋhalö kalɨp abe, manö aij ñɨñɨ lep ap dauabin. ");
INSERT INTO kpw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨñi nöp nɨbi ap ñɨ unbö ke ap yag dauöp Depid daun nɨpe au. Ñɨ anɨbu kalöp ud kamɨŋ yunab. Nɨpe Krais Bɨ Kub u me. ");
INSERT INTO kpw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nɨp am uƚhai nɨŋmim nɨŋnabim, nɨme nɨp waƚɨj wam wam göm, ud kaj sipsip nan haɫɨ habadö pɨñ u rɨk dap lɨlö ñɨŋmɨdal mab ij mɨgan u lö mɨdeinab. Kale am nɨŋmim, hagpin rö gɨnab u, nɨŋö hagöp, a gɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ejol anɨbu anɨg hagö nɨŋöl gɨ, adɨŋ ejol kumi kabö adö laŋ au nɨbö iru yabɨƚ nöp ap ejol nöd nɨbö u aip mɨdöm, God hib nɨpe u dap ranöl gɨ hagla, ");
INSERT INTO kpw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God hib nɨpe i adö laŋol mɨdöp; nɨpe nɨbi bɨ an an mög nɨŋöm ud aij gɨnab gau, hibur hain hain gasɨ mɨdmagö añɨ lep magö u kale aip mɨdnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ejol gau ado gɨ kumi kabö adö laŋ arlö nɨŋöl gɨ, bɨ kaj sipsip mukep gau manö hag nɨŋ hag nɨŋ göm hagla, “Bɨ Kub hanɨp manö hagajɨp u, uri Bedlehem am nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Anɨg hagöm yɨŋɨd amöm nɨŋla, Josep aip Maria aip ñɨŋaŋ hagla anɨbu, waƚɨj wam wam gɨmil, kaj sipsip nan haɫɨ habadö pɨñ u dap lɨlö ñɨŋmɨdal mab ij mɨgan u lɨlö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kale ñɨŋaŋ anɨbu nɨŋöm, amöm, ejol kalɨp nɨhön nɨhön hagla manö u, nɨbi bɨ gau gau kalɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bɨ kaj sipsip mukep gau nɨbi bɨ gau manö anɨbu hag ñɨlö, kale nɨŋöm magöŋhalö aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pen Maria nɨp nan ke yabɨƚ anɨbu ga rö, aij a gö, gasɨ aij nöp nɨŋmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɨ kaj sipsip mukep gau, God ejol nɨpe gau hagla rö nöp gö amgö kale ke nɨŋla u me, God hib nɨpe u dap ranöl göm, aula gau ado gɨ arla. ");
INSERT INTO kpw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maria ñɨŋaŋ u yag dapöm ñɨn unbö mudun jɨŋ mɨdöm, ruö raleb ñɨn u waŋ hañ nɨpe rɨb gɨ dö gɨla. Nöd ejol u nɨme Maria nɨp, ñɨ yag daumön hib nɨpe u anɨg göl lɨmön a ga rö, hib nɨpe u Jisas, a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Pen nöd Mosɨs nɨpe lo manö kalɨ kƚiñ rɨköm, ñɨ nöd yag daunaböl gau God nɨp ñɨnaböl a ga. Anɨb u me, Maria ñɨŋaŋ u yag dapöm, Juda nɨbi bɨ gɨmɨdal rö, God sabe gep ram u asɨ masɨ gɨ, ram nɨpe ke gau nöp mɨdö, kamɨŋ lö nɨŋöl gɨ, Josep aip, Jisas nɨp dam Bɨ Kub nɨp ñɨnɨg, God sabe gep ram Jerusalem au arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pen Bɨ Kub lo manö ap halö hagöp, “Nɨbi ñɨ pai yag daunaböl gau kamɨŋ lö, yaur maƚɨg aka yaur dapo mɨhöp dam God sabe gep ram höŋ yaŋ amöm, pak God nɨp sabe gɨ ñöm me, böŋ nöp kamɨŋ löp, a göm, God sabe gep ram raul mɨgan u arnaböl,” a gɨla. Gasɨ anɨbu u rö nöp nɨŋmil me, yaur mɨhöp halö ud arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pen Jerusalem au bɨ aij yöl ap mɨdmɨdöp, hib nɨpe Simion. Bɨ anɨbu nɨpe God Manö u nɨŋöm, hagöp rö nöp gɨmɨdöp. Ana Uɫ nɨpe Simion aip mɨdmɨdöp; nɨpe Krais u Isrel nɨbi bɨ ud kamɨŋ yunab, a göm, abad mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ana Uɫ nɨpe Simion nɨp nöd haga, “Bɨ Kub nɨpe Krais nɨp yuö aunab u, ne amgö nɨŋmön hainö umnabön,” a ga nɨŋöm nɨpe nɨŋöl mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pen ñɨn anɨbu, Ana nɨpe Simion nɨp gasɨ ñö, God sabe gep ram u amöm nɨŋa, Josep ber mɨhau Jisas nɨp dammil, lo manö haga rö gul a gɨmil ap mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion kalɨp mɨhöŋ nɨŋöm, Jisas nɨp ud wabi göm, God hib nɨpe u dap ranöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ne añɨ nöp Bɨ Kub. Ñɨŋaŋ i kub göm, hanɨp nɨbi bɨ ud kamɨŋ yunab u, nöd yɨp hagna rö, uri amgö magö yad ke nɨŋabin. Anɨb u, uri yɨp paliö aij gö nɨŋöl gɨ umnam. ");
INSERT INTO kpw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ñɨŋaŋ anɨbi, nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö ud nöp aip jɨm ñöl lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nɨpe mailö aij rö apöm, Juda nɨbi bɨ wasö gau kalɨp pak ñö, God bɨ aigale bɨ rö mɨdöp u nɨŋnaböl. Nɨpe mailö aij unbö ke ne dapöm, Isrel nɨbi bɨ ne gau kalɨp pak ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion Jisas nɨp manö anɨbu hageia u nɨŋmil, Josep ber mɨhau aiö yabɨƚ gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pen Simion nɨpe Josep Maria Jisas amlɨ bɨ kalɨp, “God kalöp abad mɨdeiaŋ,” a göm, Jisas nɨme Maria nɨp haga, “Ñɨ anɨbi mɨdö nɨŋöl gɨ, Isrel nɨbi bɨ iru nöp aŋ u ud asɨk ke ke löm, adan naij udöm arnaböl gau, ap lug paknaböl; pen adan aij udöm arnaböl gau, God lau adö arnaböl. God Isrel nɨbi bɨ nɨŋlaŋ, a göm, ñɨ i yua pen nɨbi bɨ rɨmnap nɨp udagöm hag junaböl. ");
INSERT INTO kpw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anɨg göl me, nɨbi bɨ iru nöp nɨhön nɨhön gasɨ nɨŋöm nɨŋ mɨdpal rö, nɨbi bɨ gau waiö nɨŋnaböl. Pen ru mɨlö kɨd ap mɨdmagö aŋ ne ke daŋ bɨnɨŋ gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pen ñɨn anɨbu nöp, God manö hagep nɨbi ap ap mɨdeia. Hib nɨpe u Ana; nap hib u Panuel. Panuel u, Asa rɨkö rɨk dapöm rɨkla. Nɨpe nɨbi mɨƚep yabɨƚ. Nöd nɨbi praj bɨ udöm, nugmul aip mɨdailö mɨ unbö mudun jɨŋ ina. ");
INSERT INTO kpw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nugmul uma pen Ana mɨ nɨpe ñɨnjuöl mɨhau mɨhau unbö yɨgwö mɨlö laŋ (84) ina. Nɨpe God nɨp nöp gasɨ nɨŋöm ñɨn rɨmnap nan magö ñɨŋöm wasö, God sabe gep ram u am mɨdöm, sɨdö aŋ sɨbön yaŋ God nɨp sabe göl gɨ mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pen nɨbi Ana u, magö anɨbu nöp Jisas nɨp ud mɨdeila söl au apöm, God nɨp aij a göm, nɨbi bɨ kale, Bɨ Kub apöm Jerusalem nɨbi bɨ nagɨ mɨdeila u hubɨknɨm, a göm abad mɨdmɨdal nɨbi bɨ gau kalɨp hagöm, ñɨŋaŋ anɨbu nɨhön nɨhön rö gɨnab u, manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep ber mɨhau Bɨ Kub lo manö haga rö magöŋhalö gɨ hakmil, kale ado gɨ ram mɨnöŋ Galili ammil, daun kale Nasared arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Am mɨdöm Jisas kub göm, God nɨp abad mɨd aij gö nɨŋöl gɨ, gasɨ aij yabɨƚ nɨŋöm, mɨd aij ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pasopa ñɨn kub u söl auö, Jisas nɨme nap mɨ u mɨ u, Pasopa ñɨn kub u mɨñi a göm, am Jerusalem armɨdil. ");
INSERT INTO kpw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Anɨg göl me, Jisas mɨ nɨpe in mɨgan laŋ lö, Juda kai gɨmɨdal rö, nɨme nap nɨp uɫ gɨ Pasopa nan ñɨŋnɨg Jerusalem am mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ñɨn kub anɨbu ap padiö nɨŋöl gɨ, ram arabun a göm, ado gɨ am adan aŋ au ammil nɨŋlö, Jisas aip auageila. Nɨpe Jerusalem nöp mɨdeia pen kale nɨŋagmil, ");
INSERT INTO kpw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","nɨpe nɨbi bɨ rɨmnap aip auab a gɨmil, gasɨ nɨŋlö. Pen adan aŋ au hannɨg gɨmil, am nɨmdaŋ nɨmam nɨbi bɨ rɨmnap aip mɨdöp, a gɨmil, nɨp uƚhai nɨŋailö. ");
INSERT INTO kpw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Uƚhai nɨŋ dam wasö nɨŋmil, ado gɨ Jerusalem nɨp uƚhai nɨŋnɨg arlö. ");
INSERT INTO kpw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ammil ñɨn mɨhöp nɨgaŋ mañu nɨŋlö, nɨpe amöm God sabe gep ram u mɨdöm, bɨ lo manö hag ñeb bɨ gau aip asɨk mɨdöm, manö hagaila u nɨŋöm, manö rɨmnap hag nɨŋmɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nɨbi bɨ nɨŋ mɨdeila gau, Jisas haga rö nɨŋöm, ñɨ anɨbu gasɨ nɨŋ kɨd hiɨköm manö aij hagab u, a göm, aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pen nɨme nap ber Jisas nɨp nɨŋmil kale u rö nöp aiö gɨlö. Nɨme pen Jisas nɨp haga, “Ne nap halɨp nɨhön gɨnɨg anɨg gɨpan? Mɨdmagö hol ilön gö nɨŋöl gul nöp uƚhai nɨŋ ajabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɨme anɨg hagö, Jisas haga, “Kale nɨhön gɨnɨg yɨp uƚhai nɨŋ ajabilŋ Bapi ram am mɨdpin u kale nɨŋagɨl aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jisas anɨg haga u pen kale manö hagab u, a gɨmil, rɨk nɨŋaglö. ");
INSERT INTO kpw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jisas nɨp uɫ gɨ ram kale Nasared ado gɨ arla. Jisas anɨb gau nöp mɨdöm, nɨme nap hagmɨdil rö nöp nɨŋöm hain gɨmɨdöp. Pen nɨme Jisas nɨhön nɨhön ga u gasɨ nɨŋöl gɨ nöp mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas nɨme nap aip mɨdöm, majö göm gasɨ nɨŋ aij yabɨƚ gö nɨŋöl gɨ, God abe, nɨbi bɨ gau abe nɨp nɨŋlö aij ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom gapman bɨ kub yabɨƚ Sisa Daibirias ram mɨnöŋ gau gau abad mɨdmɨdöp, mɨ in la unbö ajɨp böŋ daŋ. Pen nɨpe mɨlö gau mɨdöm, bɨ abad mɨdep aŋ yagol nɨpe rɨmnap hag lö, am ram mɨnöŋ rɨmnap abad mɨdmɨdal. Bɨ nɨpe Podias Pailod ram mɨnöŋ Judia nɨbi bɨ gau kalɨp abad mɨdmɨdöp. Bɨ nɨpe Herod ram mɨnöŋ Galili nɨbi bɨ gau kalɨp abad mɨdmɨdöp. Herod nɨmam nɨpe Pilip ram mɨnöŋ Iduria nɨbi bɨ gau abe, ram mɨnöŋ Drakonaidis nɨbi bɨ gau abe kalɨp abad mɨdmɨdöp. Bɨ nɨpe Laisenias ram mɨnöŋ Abilini nɨbi bɨ gau kalɨp abad mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pen magö anɨbu, bɨ ne Anas aip, Kaiapas aip, God nɨp nan sabe gep bɨ kub yabɨƚ mɨhau Jerusalem mɨdailö. Pen ñɨn aŋ anɨbu, Sekaraia ñɨ nɨpe Jon, nɨbi bɨ iru mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau han mɨdmɨdöp. Aŋ gau han mɨdö nɨŋöl gɨ, God nɨpe Jon nɨp gasɨ ñö, ");
INSERT INTO kpw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ram mɨnöŋ ñɨg Jodan goƚ gau gau ajmɨdöp nɨŋöm nɨbi bɨ gau aulö, kalɨp manö hag ñɨmɨdöp, “Nan si nan naij gɨpim gau, nɨhön gɨnɨg anɨg gɨpun a gɨmim arö gɨmim yɨp aube yad kalöp ñɨg pak ñɨnö, God nan si nan naij gɨpim gau nɨŋöm arö gɨnab,” a gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon kalɨp manö hag ñɨmɨdöp anɨbu, bɨ God manö hagep Aisaia hadame nöp gɨnab a göm, kalɨ kƚiñ rɨka rö nöp ga. Aisaia manö anɨbu kalɨ kƚiñ rɨköm haga, “Bɨ ap, ram mɨnöŋ nɨbi bɨ iru mɨdagpal, ram mɨnöŋ kabö nöp mɨdöp aŋ au am mɨdöm, wɨñ alöm hagnab, ‘Bɨ Kub u auab a gɨmim, nɨp abad mɨdaimim! Anɨb u, adan sɨr gɨlaŋ gɨyaŋ gɨnɨm gau, dum goƚ pɨƚu gɨnɨm gau, bɨnɨg ral aij gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anɨb u, mɨnöŋ ban göp gau bɨnɨg ral aij gɨmim, dum gau bɨnɨg ral aij gɨmim, adan dudu badu gɨnɨm gau, kabö göl gɨmim, kabö gau ud yu aij gɨmim mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anɨg göl me, nɨbi bɨ gau magöŋhalö nɨŋnaböl, God nɨpe aigöl göm kalɨp ud kamɨŋ yunab,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon nɨpe Aisaia manö kalɨ kƚiñ rɨka anɨbu rö hag ñö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨpe mɨdeia au apöm hagla, “Hanɨp ñɨg pak ñɨmön,” a gɨla. Jon kalɨp sɨƚɨk hag göm haga, “Kale haiŋo ñɨ pai gai i! Gasɨ nɨhön nɨŋmim pɨñɨŋ gɨ aubimŋ ‘Ñɨg pakno, God nɨbi bɨ rɨmnap kalɨp hag gɨnab ñɨn u, hanɨp hag gagnab,’ a gɨmim, pɨñɨŋ gɨ aubim ar? ");
INSERT INTO kpw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kale ñɨg paknɨg gɨnabim u, nan si nan naij gɨpim gau nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨmim, mɨd aij gɨmim. Anɨg gɨpe me, nɨbi bɨ nɨŋnaböl, kale nan si nan naij gɨmɨdim gau arö gɨpim. Pen kale gasɨ ap nɨŋmim, ‘Hon bac iƚaŋ Ebraham ñɨ pai nɨpe mɨdpun,’ a gɨmim, gasɨ u nɨŋagmim. Hon Ebraham ñɨ pai nɨpe a gɨpim u nan yɨharɨŋ! God kabö gai i udöm, Ebraham ñɨ pai nɨpe gau gɨ lɨnɨg göm, gɨ lɨböp! ");
INSERT INTO kpw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɨŋ aij gɨmim! God mab u iƚ halö rɨb junɨg, ru u mab iƚ yaŋ kɨd gɨ mɨdöp. Mab au, magö ñɨŋeb aij rɨmnap pɨlagnab u, rɨb gɨ dö gɨ ud mab inab yaŋ yunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon manö anɨbu rö hagö, kale nɨp pen hag nɨŋöm hagla, “Hon nɨhön gun, a gɨmön, anɨg hagpan?” ö gɨla. Haglö, Jon kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Nɨbi bɨ sior mɨhöp mɨdainɨm u, ap nɨbi bɨ sior mɨdagainɨm gau kalɨp ñöl. Pen nɨbi bɨ nan magö mɨdainɨm u, nɨbi bɨ nan magö mɨdagainɨm gau kalɨp rɨmnap ñöl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pen bɨ dakɨs udep gau, Jon hanɨp ñɨg pak ñaŋ a göm, apöm nɨp hag nɨŋöm hagla, “Manö hag ñeb bɨ, hon nɨhön gun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hageila, kalɨp haga, “Dakɨs u udnɨg gɨmim, gapman hagpal rö nöp udmim. Yɨharɨŋ rɨmnap udagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pen ami bɨ rɨmnap Jon nɨp manö anɨbu rö nöp hag nɨŋöm hagla, “Hon nɨhön gun?” ö gɨla. Hageila, kalɨp haga, “Kale manö piral hagmim nɨbi bɨ gau mani kalɨp si udagmim. Manö piral hagmim nɨbi bɨ gau manö kub hagagmim. Wög pe udnabim u ap halö udun, a gɨmim, gasɨ u nɨŋagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pen anɨg göm mɨd damöm nɨbi bɨ gau gasɨ adö ap nɨŋöm hagla, “Bɨ anɨbi Krais pör abad mɨdpun u rö löp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hageila, nɨpe manö anɨbu nɨŋöm kalɨp pen haga, “Wasö! Yad kalöp yɨharɨŋ ñɨg nöp pak ñabin, pen yɨp hain aunab bɨ u, nɨpe yad rö wasö; nɨpe bɨ kub yabɨƚ, yad bɨ pro. Yad nɨp nɨŋnö nable gɨnab. Ma rɨrup nɨpe u nagɨ ud hubɨknam rö lagöp,” a ga. Bɨ anɨbu nɨpe apöm, kalöp Ana Uɫ u nöp pak ñöm, mab mɨɫaŋ pak ñöm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Nɨpe wid magö po gö, rɨk dap pakpal rö u gɨnɨg gab. Wid magö ñɨŋeb gau ke löm, wid cög naböŋ naböŋ gau ke löm gɨnab. Anɨg göm, wid magö ñɨŋeb gau dam ram raul mɨgan nɨpe lɨnab; pen naböŋ naböŋ gau dam mab pör inmɨdöp u launab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon, nɨbi bɨ gau kalɨp God manö aij u rɨmnap halö hag ñɨnö nɨŋ aij gɨlaŋ, a göm, kalɨp manö aij anɨbu rö pro hagagmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pen gapman bɨ kub Herod, nan si nan naij gau gɨ damöm, hainö nɨmam Pilip nɨbin nɨpe Herodias nɨp ud gö, Jon u aij gagöp, a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jon manö anɨg hagö, Herod nɨŋöm, naij ga adö ap halö göm, Jon nɨp dam nagɨ la. ");
INSERT INTO kpw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Pen Herod Jon nɨp nagɨ laga magö u, nɨpe nɨbi bɨ gau kalɨp ñɨg pak ñɨmɨdöp. Jisas nɨp abe ñɨg pak ña. Jisas nɨp ñɨg pak ñö, nɨpe Nap God nɨp sabe gɨ mɨdö nɨŋöl gɨ, kumi kabö adö laŋ au ƚɨƚɨ gɨ gau gau arö, ajöŋ hiɨkö, Ana Uɫ u yaur dapo rö halu löm, Jisas nɨp u gɨ aua. Anɨg göl auö nɨŋöl gɨ, manö ap kumi kabö adö laŋ au nɨbö apöm haga, “Ne Ñɨ mɨdmagö yad yabɨƚ. Nöp nɨŋnö, yɨp aij yabɨƚ göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pen Jisas mɨ nɨpe unbö ñɨnjuöl añɨ ap ado gɨ da unbö sɨduŋ laŋ (30) arö nɨŋöl gɨ, nɨpe iƚ göm nɨbi bɨ gau kalɨp God Manö hag ña. Nɨbi bɨ gau Jisas nɨp, nap nɨpe u bɨ ne Josep, a gɨ gasɨ nɨŋla. Josep nap nɨpe u Heli. ");
INSERT INTO kpw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nap nɨpe u Madad. Madad nap nɨpe u Lipai. Lipai nap nɨpe u Melkai. Melkai nap nɨpe u Janai. Janai nap nɨpe u Josep. ");
INSERT INTO kpw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nap nɨpe u Madadaias. Madadaias nap nɨpe u Emos. Emos nap nɨpe u Neham. Neham nap nɨpe u Esli. Esli nap nɨpe u Nagai. ");
INSERT INTO kpw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nap nɨpe u Mead. Mead nap nɨpe u Madadaias. Madadaias nap nɨpe u Semein. Semein nap nɨpe u Josek. Josek nap nɨpe u Joda. ");
INSERT INTO kpw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nap nɨpe u Joanan. Joanan nap nɨpe u Resa. Resa nap nɨpe u Serababel. Serababel nap nɨpe u Sialdiel. Sialdiel nap nɨpe u Nerai. ");
INSERT INTO kpw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai nap nɨpe u Melkai. Melkai nap nɨpe u Adai. Adai nap nɨpe u Kosam. Kosam nap nɨpe u Elmadam. Elmadam nap nɨpe u Er. ");
INSERT INTO kpw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nap nɨpe u Josua. Josua nap nɨpe u Eliesa. Eliesa nap nɨpe u Jorim. Jorim nap nɨpe u Madad. Madad nap nɨpe u Lipai. ");
INSERT INTO kpw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai nap nɨpe u Simion. Simion nap nɨpe u Juda. Juda nap nɨpe u Josep. Josep nap nɨpe u Jonam. Jonam nap nɨpe u Eliakim. ");
INSERT INTO kpw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nap nɨpe u Melea. Melea nap nɨpe u Mena. Mena nap nɨpe u Madada. Madada nap nɨpe u Nadam. Nadam nap nɨpe u Depid. ");
INSERT INTO kpw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depid nap nɨpe u Jesi. Jesi nap nɨpe u Obed. Obed nap nɨpe u Boas. Boas nap nɨpe u Salmon. Salmon nap nɨpe u Nason. ");
INSERT INTO kpw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nap nɨpe u Aminadap. Aminadap nap nɨpe u Admin. Admin nap nɨpe u Arni. Arni nap nɨpe u Hesron. Hesron nap nɨpe u Peres. Peres nap nɨpe u Juda. ");
INSERT INTO kpw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nap nɨpe u Jekop. Jekop nap nɨpe u Aisak. Aisak nap nɨpe u Ebraham. Ebraham nap nɨpe u Dera. Dera nap nɨpe u Nahor. Nahor nap nɨpe u Seruk. ");
INSERT INTO kpw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk nap nɨpe u Rehu. Rehu nap nɨpe u Pelek. Pelek nap nɨpe u Eber. Eber nap nɨpe u Sela. ");
INSERT INTO kpw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nap nɨpe u Kenam. Kenam nap nɨpe u Apaksad. Apaksad nap nɨpe u Sem. Sem nap nɨpe u Noa. Noa nap nɨpe u Lemek. ");
INSERT INTO kpw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek nap nɨpe u Medusela. Medusela nap nɨpe u Inok. Inok nap nɨpe u Jared. Jared nap nɨpe u Malelael. Malelael nap nɨpe u Kenan. ");
INSERT INTO kpw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nap nɨpe u Inos. Inos nap nɨpe u Sed. Sed nap nɨpe u Adam. Adam nap nɨpe u God. ");
INSERT INTO kpw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Ana Uɫ u Jisas nɨp ajmaŋ rauöm, nɨp uɫ gɨ ñɨg Jodan gau nɨbö ud arö, Jisas ram mɨnöŋ nɨbi bɨ mɨdagmɨdal, ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau mɨdeia. Seden nɨpe Jisas nan si nan naij rɨmnap gɨnɨm aka wasö gɨ nɨŋöl göm gɨ gɨ gö, ñɨn unbö ñɨn juöl mɨhöp (40) ara. Jisas nan magö ñɨŋöm wasö, nɨp kɨyö majö la. ");
INSERT INTO kpw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɨp kɨyö majö lö, Seden haga, “Ne ‘God Ñɨ nɨpe mɨdpin,’ a gɨpan u, kabö gai i hagö, bred rö laŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hageia, Jisas pen haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘Nɨbi bɨ gau, bred nöp ñɨŋöm kamɨŋ mɨdageinaböl,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hagö, Seden Jisas nɨp dam dum kub laŋ ap amöm, ram mɨnöŋ aij aij kiŋ ke ke abadpal gau magöŋhalö, magö anɨbu nöp, Jisas nɨp yamöm haga, ");
INSERT INTO kpw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Ram mɨnöŋ aij aij gai i nöŋ! Nɨbi bɨ ke ke abad mɨdpal. Yad me ram mɨnöŋ anɨb gau magöŋhalö abad mɨdpin rö, bɨ ap nɨp hagnɨg gem hagnabin. Anɨb u, ne yɨp kugom yɨmmön sabe geinabön u, ram mɨnöŋ anɨb gai i magöŋhalö nape hagnö, ne abad mɨdeinabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hageia Jisas pen haga, “God Manö u kalɨ kƚiñ rɨköm hagla, ‘God Bɨ Kub kale u hagöp rö gɨmim hib nɨpe nöp hagpe adö araŋ,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas anɨg hageia, Seden nɨpe Jisas nɨp uɫ gɨ Jerusalem amöm, dam God sabe gep ram i adö laŋ gɨ lɨla adö u amöm haga, “Ne, ‘God Ñɨ nɨpe mɨdpin,’ a gɨpan u, pɨraŋɨd mɨnöŋ iƚ yaŋ lug. ");
INSERT INTO kpw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","God Manö u kalɨ kƚiñ rɨköm hagla, ‘God ejol nɨpe gau hagö, nöp abad mɨdeinaböl. Ap lug paknɨg geinabön u, nöp ñɨmagö kale udnaböl nɨŋöm kabö ma ne u bɨnɨŋ gagnab,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Seden anɨg hageia, Jisas pen haga, “God Manö u manö rɨmnap halö kalɨ kƚiñ rɨköm hagla, ‘God Bɨ Kub u, nɨpe bɨ nɨŋö hagep aka bɨ pir alep, a gɨmim hagagmim,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɨjaki Jisas nɨp manö piral hag wasö nɨŋöm, arɨk arɨn a göm, gasɨ nɨpe gau nöp nɨŋa, “Uri wasö pen hainö ñɨn rɨmnap apem manö rɨmnap halö pir alem hag nɨŋnam,” a göm arɨk ara. ");
INSERT INTO kpw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pen God Ana Jisas nɨp kƚö ñö, Jisas nɨpe ado gɨ apöm ram mɨnöŋ Galili mɨdö nɨŋöl gɨ, nɨbi bɨ gau, manö nɨpe u nɨŋöm, dam ram mɨnöŋ Galili aŋ gau magöŋhalö ud arla. ");
INSERT INTO kpw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nɨpe Juda magum gep ram gau amöm, manö hag ñɨ aij gö, nɨbi bɨ gau nɨpe bɨ aij yabɨƚ a göm, mɨñ mɨñ yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pen Jisas nɨpe ram mɨnöŋ Galili aŋ gau gɨ aj pɨs göm, Nasared am mɨdeia. Daun anɨbu nɨpe nöd mɨdöm majö ga. Juda God nɨp sabe gep ñɨn kale u auö, nɨpe pör gɨmɨdöp rö, magum gep ram u amöm, uraköm God Manö u amgö lɨ nɨŋöm hagnɨg ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bɨ God manö hagep Aisaia kalɨ kƚiñ rɨka köp u nɨp dap ñɨlö, ud pɨƚaiöm, manö hagnɨg ga adɨŋ u amgö lɨ nɨŋöm kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bɨ Kub u yɨp, wög yad gɨmön, a göm, Ana nɨpe yuö yad aip mɨdöp. Anɨb u, nɨbi bɨ mög gep rö mɨdpal gau kalɨp manö aij u hag ñɨnö, nɨŋ aij gɨnaböl. Nɨbi bɨ nagɨman rö mɨdpal gau kalɨp hubɨk yunö, arnaböl. Nɨbi bɨ amgö we göp rö mɨdpal gau kalɨp gɨnö, amgö ñɨl nɨŋnaböl. Nɨbi bɨ uɫham mɨdpal gau kalɨp ud aij gɨnö, mɨd aij gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pen, Bɨ Kub nɨbi bɨ udnab ñɨn aij u mɨñi auöp, a gem, nɨbi bɨ gau kalɨp hag ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas manö kƚiñ anɨbu amgö lɨ nɨŋ hag pɨs göm, köp bad u ud wam wam göm, bɨ köp abad mɨdmɨdöp u nɨp adog ñöm asɨkö nɨŋöl gɨ, nɨbi bɨ magum gep ram raul mɨdeila gau magöŋhalö amgö juöm nɨp nɨŋ ij halö lɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Anɨg nɨŋeila, Jisas kalɨp haga, “God Manö adɨŋ anɨbu ud amgö lɨ nɨŋ kalöp hagnö nɨŋajim anɨbu, uri anɨg unbö rö nöp göp. ");
INSERT INTO kpw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Anɨg hagö, manö aij yabɨƚ haga u nɨŋöm, nɨbi bɨ nɨp ñɨñɨ löm, aiö gɨla. Pen gasɨ ap nɨŋöm, “Bɨ anɨbi Josep ñɨ nɨpe nöp aka?” göm, aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Anɨg haglö, Jisas kalɨp haga, “Pen yad nɨŋbin, yɨp hagnabim, ‘Ne wös wameb bɨ, ne ke gɨmön nan ne ke göp u kamɨŋ lɨnab. Ne daun pro Kapaneam am mɨdmön, nan gagep rö gaina, yɨd acmal ajajɨp nɨŋbun u rö, mɨñi ram mɨnöŋ ne ke aui abe gö yɨd acmal ajö nɨŋun,’ a gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pen kalöp nɨŋö hagabin, bɨ God manö hagep gau, ram mɨnöŋ ke gau amöm, manö aij u haglö, nɨŋö hagaböl a göm udnaböl. Pen ram mɨnöŋ kale ke u apöm haglö, bɨ hon gau ke hagaböl a göm, manö kalɨp udagnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pen nɨŋim! Bɨ God manö hagep Ilaija mɨdeia ñɨn u, nɨbi yadu iru nöp Isrel au mɨdmɨdal. Mɨ mɨhau nɨgaŋ rakɨn unbö kagoƚ jɨŋ u, möŋ alagö, nan magö ranagö, kɨyö kub yabɨƚ la. ");
INSERT INTO kpw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isrel nɨbi yadu rɨmnap kɨyö la gau iru yabɨƚ nöp mɨdeila au, pen God Ilaija nɨp yuö, am daun pro Sarepad ram mɨnöŋ daun kub Saidon söl au amöm, nan gagep rö gö, nɨbi yadu ap nan magö nɨpe iru nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pen adö anɨbu rö, hainö bɨ God manö hagep Ilaisa mɨdeia ñɨn u, Isrel nɨbi bɨ rɨmnap wös gɨsa la gau iru yabɨƚ nöp mɨdeila au, pen kalɨp rɨmnap gö kamɨŋ laga; Ilaisa bɨ Neman ram mɨnöŋ mɨlö kub Siria nɨbö u nɨp nöp gö, kamɨŋ la,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas anɨg hagö, Juda nɨbi bɨ magum gep ram raul mɨdeila gau nɨŋlö mulu kal yabɨƚ lugö, ");
INSERT INTO kpw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","nɨp rɨdɨk gɨ yu gɨ dam rul gau yuno umaŋ a göm, rɨdɨk gɨ ud arla jɨ Jisas nɨpe ado göm aŋ kale au amöm ara. ");
INSERT INTO kpw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas daun pro Kapaneam, ram mɨnöŋ Galili au am mɨdöm, Juda kai God nɨp sabe gep ñɨn u nɨbi bɨ kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","God Manö u, Jisas kƚö naij göm kabö göl nöp hagö, kale aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pen Juda magum gep ram raul aŋ anɨb au, bɨ kɨjaki abaŋ ala ap mɨdeia. Nɨpe meg mɨgan dap ranöm wɨñ kub alöm haga, ");
INSERT INTO kpw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Bɨ Jisas Nasared nɨbö! Ne nɨhön gɨnɨg auban? Hanɨp gɨ naij gɨnɨg auban akaŋ Yad nöp nɨŋbin. God Bɨ Uɫ nɨpe u nöp auban,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pen Jisas kɨjaki abaŋ al mɨdeia anɨbu nɨp hag göm haga, “Manö hagagmön! Bɨ u arö gɨmön höŋ aru!” a ga. Jisas hagö, kɨjaki aiön pi höŋ aröl gɨ bɨ anɨbu nɨp, nɨbi bɨ mɨdeila aŋ au ud yuöm ara. Pen nɨp mɨñu magö pakaga; kamɨŋ ara. ");
INSERT INTO kpw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Anɨg gö, nɨbi bɨ nɨŋ mɨdeila gau kale ke hag nɨŋ hag nɨŋ göm hagla, “Bɨ kƚö yabɨƚ anɨbi, manö anɨbu gai nɨbö dapöm hagö, kɨjaki gau höŋ arbal?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pen Jisas ga manö anɨbu ram mɨnöŋ anɨb gau magöŋhalö ud arla. ");
INSERT INTO kpw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pen Jisas Juda magum gep ram u arö göm Saimon ram u ara. Saimon nɨbor nɨpe u nan gö, hañ romaŋ nɨpe gau magöŋhalö mab rö inö me, nɨbi bɨ gau apöm Jisas nɨp hagla, “Aumön, ne Saimon nɨbor nɨp gö urak araŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hageila, nɨpe nɨbi nan gö um mɨdeia söl au apöm, nan geia anɨbu hag gö nɨŋöl gɨ, magö anɨbu nöp nɨp arö göm ara. Nɨp kamɨŋ lö, uraköm, nɨbi bɨ ap mɨdeila gau kalɨp nan magö ña. ");
INSERT INTO kpw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nɨbi bɨ anɨb au mɨdeila gau, manö anɨbu nɨŋöm, sɨdö wad ara magö u, nɨbi bɨ kale mɨña ga gau magöŋhalö dap Jisas mɨdeia au daula. Daueila, Jisas kalɨp añɨ añɨ ud nɨŋö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pen nɨbi bɨ kɨjaki aiön pi nan gau abaŋ al mɨdeia gau hag yuö, höŋ amöl gɨ wɨñ kub alöm hagla, “Ne God Ñɨ nɨpe!” a gɨla. Kale Jisas nɨpe Krais u nɨŋöm anɨg hageila nɨŋöm Jisas nɨpe kalɨp hag göm haga, “Manö ap hagagmim,” a gö, haga rö nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ruö sɨb halö, Jisas ram mɨnöŋ anɨbu arö göm, ke am mɨdaiɨn, a göm, ram mɨnöŋ nöp aŋ gau ara. Ara pen nɨbi bɨ gau hain amöm, nɨp uƚhai nɨŋöm hagla, “Gau aragmön; hon aip mɨdaiun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Anɨg hageila Jisas haga, “God yɨp hag yuö aunö u, amem nɨbi bɨ ke mɨgan rɨmnap halö kalɨp u rö nöp God nɨbi bɨ udöm abad mɨdeinab manö aij u hag ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Anɨg hagöm, Jisas Juda nɨbi bɨ ram mɨnöŋ kale gau magöŋhalö gɨ ajöl gɨ, am Juda magum gep ram gau amöm, manö aij anɨbu kalɨp hag ñɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisas ñɨn ap am Ñɨg Waŋö Genesared goƚ au mɨdöm, God Manö u hag ñö nɨŋöl gɨ, nɨbi bɨ iru yabɨƚ, manö aij anɨbu nɨŋun a göm, cɨro maƚo ñöl gɨ aula. ");
INSERT INTO kpw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anɨg göl aulö nɨŋöl gɨ, Jisas nɨŋa, bɨ kabsaƚ udep gau ñɨg magɨb mɨhöp dap ñɨg waŋö goƚ anɨb au löm, kabsaƚ udep uben gau uɫ gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas nɨpe Saimon ñɨg magɨb adö u ujaŋɨd löm haga, “Yɨp ud neb neb gö, ñɨg waŋö aŋ söl au daŋ arɨn,” a ga. Hagö, Saimon ñɨg magɨb u ud neb neb gö, Jisas ñɨg waŋö aŋ söl au amöm ñɨg magɨb adö anɨbu asɨk mɨdöl gɨ, nɨbi bɨ gau kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Manö hag pɨs göm, Jisas Saimon nɨp haga, “Ñɨg magɨb i ñɨg uɫaŋ pɨrɨk gɨ dam ñɨg waŋö aŋ kub au daŋ ammim, uben yumim kabsaƚ udim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hageia, Saimon pen haga, “Bɨ Kub, mɨñi sɨbön yaŋ nöp hon kabsaƚ nɨŋ aj aj aj, ram halö ru dam löp pen hon kabsaƚ rɨmnap udagpun. Pe ne anɨg hagpan rö, uben u haƚöwaƚö yu nɨŋun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Anɨg hagöl göm uben yulö nɨŋöl gɨ, kabsaƚ iru nöp ap uben mɨgan u arlö, uben gau ajmaŋ rauöm, pak gɨ dö gɨnɨg rö ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Anɨg ga nɨŋöm, nɨmam bɨ ñɨg magɨb adö ap mɨdeila gau kalɨp ñɨn aiaŋ gɨlö, kale apöm kabsaƚ anɨb gau udöm, ñɨg magɨb anɨb mɨhau lɨlö, böŋ nöp ajmaŋ rauöm, ñɨg magɨb mɨhau pɨg lugnɨg rö ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Anɨg ga nɨŋöm, Saimon Pida bɨ nɨpe aip ñɨg magɨb adö mɨdeila gau, kabsaƚ iru yabɨƚ udla gau nɨŋöm, gasɨ iru nöp nɨŋla. Pen Sebedi ñɨ nɨpe Jems aip Jon aip, ñɨg magɨb ap udmil Saimon aip wög jɨm ñöl gɨmɨdil bɨ mɨhau, u rö nöp gasɨ iru nɨŋlö. Pen Saimon am Jisas mɨdeia söl au kugom yɨmöm haga, “Bɨ Kub, yad bɨ nan si nan naij gɨpin u, ne ke gau aru,” a ga. Hageia Jisas haga, “Ne pɨñɨŋ gagmön. Mɨñi ñɨn i rɨköm, bɨ kabsaƚ udep u arö gɨmön, nɨbi bɨ ud God nɨp dauep bɨ mɨdeinabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jisas anɨg hagö, ñɨg magɨb mɨhau dam ñɨg goƚ au löm, kabsaƚ nan gau arö göm, Jisas aip amöm ajmɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pen hainö Jisas am daun ap mɨdö, bɨ wös hapeb hañ romaŋ gau magöŋhalö la bɨ ap apöm, Jisas mɨdeia söl au kugom yɨmöm nabɨc yɨhöŋ göm, haga, “Ne yɨp gö kamɨŋ lɨnɨg, gö kamɨŋ lɨnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Anɨg hagö, Jisas haga, “Yau, yad gɨnö, nöp kamɨŋ lɨnɨm,” a ga. Anɨg hagöm, Jisas ñɨmagö nɨpe mɨlöbö löm bɨ anɨbu ud nɨŋö, magö anɨbu nöp wös hapeb gau böŋ nöp hir ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wös hapeb gau hir gö, Jisas bɨ anɨbu nɨp haga, “Yad nöp ud nɨŋnö kamɨŋ löp u nɨbi bɨ gau hagagmön. Pen bɨ Mosɨs hadame nöp kalɨ kƚiñ rɨköm haga rö, wös hapeb yɨp u kamɨŋ löp a gɨmön, am bɨ God nɨp nan sabe gɨpal gau kalɨp yamön, nan sabe gep u kalɨp ñɨmön hagmön, ‘Yɨp kamɨŋ löp rö, nan i God nɨp sabe gim,’ a gɨmön. Ne anɨg gɨmön, nɨbi bɨ nɨŋöm hagnaböl, ‘Nɨpe kamɨŋ löp rö anɨg göp,’ a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pen Jisas manö nɨpe u, ram mɨnöŋ gau magöŋhalö rɨgoŋ rɨgoŋ arö, nɨbi bɨ iru nöp, nɨp nɨŋun a göm, cɨro maƚo ñöm aumɨdal. Nɨbi bɨ anɨb gau, rɨmnap manö aij nɨpe u nɨŋnɨg aumɨdal; rɨmnap hanɨp gö kamɨŋ laŋ a göm aumɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pen ñɨn rɨmnap Jisas am ke mɨgan ap mɨdöm, Nap nɨp sabe gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñɨn ap Jisas nɨbi bɨ gau kalɨp manö hag ñɨ mɨdeia. Perisi bɨ rɨmnap abe, lo manö hag ñeb bɨ rɨmnap abe, ram mɨnöŋ Galili aŋ au ram rɨƚɨg agƚö magöŋhalö gau nɨbö abe, ram mɨnöŋ Judia aŋ au ram rɨƚɨg agƚö magöŋhalö gau nɨbö abe, Jerusalem nɨbö abe apöm, Jisas manö hag ñɨmɨdeia au asɨk mɨdeila. Pen Bɨ Kub kƚö nɨpe aip mɨdeia u me, Jisas nɨbi bɨ nan ga gau kalɨp gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pen bɨ rɨmnap, bɨ ñɨmagö ma kɨƚa ga ap ilöŋ lɨ dapöm, Jisas nɨp gö kamɨŋ laŋ a göm, nɨp Jisas mɨdöp ram raul mɨgan u ud arun a gɨ gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pen Jisas mɨdeia ram u nɨŋla, nɨbi bɨ gau ram raul mɨgan anɨbu böŋ nöp sɨsɨ ga. Anɨg gö, wip ilöŋ lɨ daula anɨbu, dam ram adö laŋ amöm, ram u ud mɨgan hiɨköm, nagɨ löm, Jisas mɨdeia aŋ au gɨyaŋ yula. ");
INSERT INTO kpw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kale gasɨ nɨŋla, Jisas gö kamɨŋ lɨnɨm rö löp, a göm nɨŋeila rö, Jisas gasɨ kale u nɨŋöm, bɨ ñɨmagö ma kɨƚa ga u nɨp haga, “Bɨ nɨŋeb yad, nan si nan naij gɨpan gau nɨŋem arö gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas anɨg hagö, bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe, gasɨ aŋ kale gau nöp ke nɨŋöm hagla, “Bɨ anɨbi ban? Nɨpe God nɨp hag juöl gɨ hagab. God nɨpe añɨ nöp me nan si nan naij gɨpal gau nɨŋöm arö gɨnɨm rö löp,” a göm, gasɨ kale u nöp nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pen gasɨ nɨŋeila anɨbu, Jisas ke rɨk nɨŋöm haga, “Kale nɨhön gɨnɨg yɨp gasɨ naij nɨŋabim? ");
INSERT INTO kpw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bɨ ap bɨ ap nɨp hagnab, ‘Nan si nan naij gɨpan gau nɨŋem arö gabin,’ a gɨnab u, kale aigöl gɨmim nɨŋnabim nɨpe manö nɨŋö hagab aka manö pir alabŋ Pen bɨ ñɨmagö ma kɨƚa göp ap mɨdeinab, bɨ ap nɨp hagnab, ‘Ne mɨñi nöp urak aru,’ a gɨnab u, kale aigöl gɨmim nɨŋnabim nɨpe manö nɨŋö hagab aka manö pir alab? ");
INSERT INTO kpw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bɨ Ñɨ nɨpe nɨbi bɨ mɨnöŋ naböŋ iƚ i nan si nan naij gɨpal gau nɨŋöm arö gɨnɨm rö löp u, kale manö anɨbu manö nɨŋö a gɨmim nɨŋ udmim a gem, manö anɨg göl hagnɨg gabin,” a ga. Anɨg hagöm, Jisas bɨ ñɨmagö ma kɨƚa ga u nɨp haga, “Ne mɨñi nöp urakmön, nöp ilöŋ lɨ daubal abañ bad u udmön, ado gɨ ram ne aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Anɨg hagö, nɨbi bɨ gau nɨŋmɨdlö nɨŋöl gɨ, magö anɨbu nöp uraköm, nɨp ilöŋ lɨ daula abañ bad anɨbu udöm, God nɨp aij a göl gɨ, ram nɨpe ara. ");
INSERT INTO kpw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Anɨg gö, nɨbi bɨ nɨŋmɨdeila gau magöŋhalö pa gɨƚɨ göm, God hib u dap ranöl gɨ hagla, “Mɨñi nan ke nɨbö yabɨƚ gajɨp nɨŋbun,” a göm, aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pen hainö Jisas amöm nɨŋa, bɨ dakɨs udep ap dakɨs ñeb ram raul mɨgan u asɨk mɨdeia. Hib nɨpe u Lipai. Jisas nɨp nɨŋöm haga, “Ne aumön, yad aip arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hageia, Lipai uraköm, wög gɨmɨdöp u arö göm, nan nɨpe gau magöŋhalö arö göm, Jisas aip arlö. ");
INSERT INTO kpw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pen Lipai ñɨñɨ löm, Jisas nɨp nan magö kub ram nɨpe u lau löm, bɨ dakɨs udep rɨmnap, nɨbi bɨ rɨmnap iru nöp wɨñ alö apöm, Jisas aip asɨköm nan magö ñɨŋeila. ");
INSERT INTO kpw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pen Jisas kale aip nan magö ñɨŋaia u nɨŋöm, bɨ Perisi rɨmnap abe, bɨ lo manö hag ñeb kale rɨmnap abe apöm, Jisas bɨ nɨpe gau kalɨp hagla, “Kale nɨhön gɨnɨg nɨbi bɨ nan si nan naij gɨpal gau abe, bɨ dakɨs udep gau abe aip asɨkmim nan ñɨŋabim?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Anɨg haglö, Jisas manö anɨbu nɨŋöm kalɨp pen hagöm haga, “Nɨbi bɨ kamɨŋ mɨdpun a gɨpal gau, wös wameb bɨ wɨñ alagpal; nɨbi bɨ nan göp gau nöp, hanɨp gö kamɨŋ laŋ a göm, wös wameb bɨ wɨñ albal. ");
INSERT INTO kpw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anɨb unbö rö nöp, yad nɨbi bɨ, mɨd aij gɨpun a göm gasɨ nɨŋbal gau, kalɨp hagnɨg auagpin; nɨbi bɨ, hon nan si nan naij gun, mɨd aij gagpun, a göm gasɨ nɨŋbal gau, kalɨp hagnɨg aubin. Yad kalɨp manö aij hag ñɨnö, kale manö yad u nɨŋ udöm, nan naij gɨpal gau, nɨhön gɨnɨg anɨg gɨpun a göm, arö göm, God hagöp rö nöp göl,” a gem aubin. ");
INSERT INTO kpw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pen kale rɨmnap Jisas nɨp hagla, “Jon bɨ nɨpe gau abe, Perisi bɨ kale gau abe ñɨn rɨmnap, God nɨp nöp gasɨ añɨ nɨŋun, a göm, nan magö ñɨŋagöm kɨyö nöp mɨdöm, God nɨp sabe gɨpal. Pen bɨ ne gau nan magö ñɨŋöl gɨ, ñɨg ñɨŋöl gɨ nöp mɨdpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Anɨg hageila, Jisas kalɨp pen haga, “Bɨ ap nɨbi udöm, nɨbi bɨ nɨpe gau aip nan kub ñɨŋnaböl u, bɨ rɨmnap uraköm, nɨhön gɨnɨg anɨg gabim a göm hagagnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pen hainö bɨ rɨmnap apöm bɨ anɨbu ud arlö, ñɨn anɨbu nɨbi bɨ nɨpe gau mög gö, nan magö ñɨŋagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pen Jisas manö hod rɨköm kalɨp haga, “Waƚɨj nöd nɨbö ap gɨ dö geinab u, waƚɨj gɨsön nɨbö ap ud gɨ dö göm, dap al dör gɨlö, adɨp adɨp lagnab. Ke ke yabɨƚ löm, mɨhöŋgöl naij yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pen ñɨg wain u, u rö nöp. Ñɨg wain kamɨŋ u udöm, kaj meme hañ mɨƚep mɨgan yaŋ hoŋ gagpal. Nɨhön gɨnɨg: hoŋ göm mame ñɨlö, ran ap ranöm, bɨŋ naij yabɨƚ hagöm pak gɨ dö göm hoŋ gö, kaj meme hañ u abe naij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gasɨ anɨbu nɨŋöm me, ñɨg wain kamɨŋ udöm, kaj meme hañ kamɨŋ mɨgan u nöp hoŋ lep. ");
INSERT INTO kpw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pen nɨbi bɨ ñɨg wain nöd nɨbö hadö ñɨŋbal gau, hainö ñɨg wain kamɨŋ gɨsön nɨbö u ñɨŋlö kalɨp aij gagnab; ‘Ñɨg wain nöd nɨbö u aij,’ a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hainö Juda God nɨp sabe gep ñɨn ap, Jisas bɨ nɨpe gau aip wid wög adɨŋ aŋ au amöl gɨ, bɨ nɨpe gau wid magö anɨb gau rɨmnap rɨk ñɨmagö adö kale au löm, hañ pak yuöm ñɨŋöl gɨ arla. ");
INSERT INTO kpw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anɨg geila, bɨ Perisi rɨmnap nɨŋöm hagla, “Kale nɨhön gɨnɨg God nɨp sabe gep ñɨn wög gagep i, wid magö hañ pak yumim wög gabim?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Hageila, Jisas bɨ nɨpe gau gɨla anɨbu naij gagla u nɨŋöm, bɨ Perisi gau kalɨp haga, “Depid hadame nöp bɨ nɨpe gau aip kɨyö lö, God sabe gep ram u amjaköm, bred God amgö ilö adö u löm, bɨ yɨharɨŋ ñɨŋagpal, bɨ God nɨp nan sabe gɨpal gau nöp ñɨŋbal bred u, Depid hag nɨŋö, nɨp ñɨlö, bɨ nɨpe gau aip ñɨŋla. Kalɨp kɨyö lö gɨla aiud anɨbu God Manö kalɨ kƚiñ rɨkla u, kale nɨŋagpim ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas manö ap halö hagöm haga, “Bɨ Ñɨ nɨpe Bɨ Kub mɨdöm, ñɨn yɨharɨŋ mɨdep ñɨn u, nɨhön gɨnam a gɨnab u, gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","7","Pen Juda God nɨp sabe gep ñɨn hain ap, Jisas Juda magum gep ram u amöm, kalɨp God Manö u hag ñöl gɨ mɨdeia. Ram raul mɨgan anɨbu, bɨ ñɨmagö pɨno ga ap ap mɨdeia. Bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe, bɨ anɨbu nɨp nɨŋla rö, Jisas nɨpe God nɨp sabe gep ñɨn i nɨp gö kamɨŋ lɨnab aka nɨhön gö, nɨp hag gun a göm, nɨp nɨŋ ij halö lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pen gasɨ nɨŋla anɨbu, Jisas ke nɨŋöm, bɨ ñɨmagö pɨno ga anɨbu nɨp haga, “Ne urakmön aŋ aui au,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hageia, urak auö nɨŋöl gɨ, Jisas bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe kalɨp haga, “Yɨharɨŋ mɨdep ñɨn i rö, nɨbi bɨ gau kalɨp ud aij gɨnabun aka, yɨharɨŋ mɨdep ñɨn uri a gun, kalɨp arö gɨnabun? Kalɨp gɨno urak aröl aka kalɨp arö gɨno umöl?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Anɨg hagöm, kalɨp nɨŋ gus gus göm, bɨ ñɨmagö pɨno ga u nɨp haga, “Ñɨmagö ne u mɨlöbö lɨ!” a ga. Hagö, ñɨmagö nɨpe mɨlöbö lö nɨŋöl gɨ, adɨŋ kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jisas bɨ anɨbu nɨp gö kamɨŋ la u nɨŋöm, bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe, mulu kal yabɨƚ nɨŋöm, Jisas nɨp nɨhön gun a göm, hag nɨŋ hag nɨŋ gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pen ñɨn aŋ anɨb au, Jisas Nap nɨp hagnabin, a göm, dum ilö laŋ amöm, Nap nɨp sabe gɨ mɨdö mɨdö, ram rua. ");
INSERT INTO kpw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pen ruö sɨdö aua magö u, bɨ nɨpe gau magöŋhalö hagö aueila, bɨ nɨpe unbö mɨgan laŋ kalɨp ud asɨk ke löm, kale bɨ manö yad ud arep gau mɨdeinabim, a göm hag la. ");
INSERT INTO kpw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Bɨ nɨpe hag la anɨb gau hib kale me: ap Saimon, hainö Jisas hib nɨpe ap löm Pida a ga; ap Edru, Saimon nɨmam nɨpe u; ap Jems; ap Jon; ap Pilip; ap Badolomyu; ap Madyu; ap Domas; ap Jems, Alpias ñɨ nɨpe u; ap Saimon hib aƚog Saimon Selod a gɨmɨdal u; ");
INSERT INTO kpw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ap Judas, Jems ñɨ nɨpe u; ap Judas Iskariod. Nɨpe nöp me hainö Jisas al pak lɨlaŋ a göm, nɨp mumug nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pen Jisas bɨ nɨpe anɨb gau aip dum ilö laŋ arö göm, au gɨyaŋ gɨ am ban aij yaŋ mɨdlö nɨŋöl gɨ, nɨbi bɨ iru nöp, nɨp nɨŋun a göm, ap magum gɨla. Nɨbi bɨ anɨb gau, rɨmnap Jerusalem nɨbö, rɨmnap ram mɨnöŋ Judia gau nɨbö gau nɨbö, rɨmnap ram mɨnöŋ nabis daun kub mɨhöp Daia Saidon nɨbö, ");
INSERT INTO kpw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jisas manö nɨpe nɨŋun, hanɨp nan göp gö kamɨŋ lɨnɨm a göm aueila. Nɨbi bɨ kɨjaki aiön pi nan gau abaŋ alö mɨd aij gagla gau, Jisas gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pɨdöŋ nɨp nɨbö apöm, kalɨp nan nɨhön nɨhön ga gau gö, magöŋhalö kamɨŋ lajɨp u nɨŋöm, nɨbi bɨ anɨb gau magöŋhalö apöm, hon abe Jisas nɨp ud nɨŋun a göm, nɨp cɨro maƚo ñöm aula. ");
INSERT INTO kpw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas bɨ nɨpe gau kalɨp amgö nɨŋöl gɨ haga, “Kale nɨbi bɨ mög gep rö mɨdpim gau, God kalɨp ud aij göm abad mɨdeinab. Gasɨ anɨbu nɨŋmim mɨñ mɨñ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kale mɨñi kɨyö kub löp gau, hainö kɨyö lagnab. Gasɨ anɨbu nɨŋmim mɨñ mɨñ gɨmim. Kale mög gö, mɨɫöŋ magö gabim gau, hainö aij gö nɨŋöl gɨ, mɨhol gɨnabim. Gasɨ anɨbu nɨŋmim mɨñ mɨñ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bɨ Ñɨ nɨpe nɨp cɨg mɨdpe, nɨbi bɨ gau kalöp mulu kal nɨŋöm, jɨ nɨŋöm, nɨbi bɨ naij anɨb gai i, bɨ an aip mɨdeinaböl, a göm, kalöp hib gasɨ naij nɨŋöm manö udöm hag jueinaböl u, kale mɨñ mɨñ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gɨnaböl anɨbu, nɨhi iƚaŋ kale gau, bɨ God manö hagep gau kalɨp gɨmɨdal rö nöp kalöp gɨnaböl. Anɨb u nɨŋmim, God hanɨp ud aij yabɨƚ gɨnab ram mɨnöŋ nɨpe adö laŋ au, a gɨmim, aij a gö nɨŋöl gɨ, ñɨn ma ju adö adö gɨ uraköl gɨ, mɨñ mɨñ göl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pen kale nɨbi bɨ mani nan iru mɨdöp gau nɨŋ aij gɨmim. Nan kale udep rö u, mɨnöŋ naböŋ adö iƚ i hadö udpim. ");
INSERT INTO kpw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pen kale mɨñi nan magö rö ñɨŋ gɨpe gɨpe mudun göp gau, hainö kɨyö lɨnab u nɨŋ aij gɨmim. Pen kale mɨñi manö mɨhol uƚɨb gɨ mɨdpim gau, hainö mög gö mɨɫöŋ magö gɨ mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pen kalöp hib dap ranöl gɨ nöp mɨdeinaböl u, kale nɨŋ aij yabɨƚ gɨmim. Nɨhi iƚaŋ kale gau, bɨ God Manö piral hagmɨdal gau, kalɨp unbö rö gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pen nɨbi bɨ manö yad nɨŋabim gai i. Koƚmaƚ kale gau kalɨp mɨdmagö lɨmim. Nɨbi bɨ kalöp mulu lugö nɨŋbal gau kalɨp ud aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nɨbi bɨ kalöp hag juaiöl, God kalɨp abad mɨdeiaŋ a gɨmim, nɨp sabe gɨmim. Nɨbi bɨ kalöp gɨ naij gaiöl, kalɨp God nɨp sabe gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pen nɨbi bɨ rɨmnap kalöp alaun böŋ lap pakaiöl, ado gɨmim, böŋ lap u rö nöp paköl. Pen nɨbi bɨ rɨmnap kolsior kale u udaiöl, sior u rö abe udim a gɨmim, haƚöwaƚö ñɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nɨbi bɨ rɨmnap nan mɨdagainɨm asɨb hagaiöl, kalɨp ñɨmim. Pen nan kale ap nɨŋöm udaiöl, hanɨp adog ñɨmim, a gɨmim hagagmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hanɨp gɨlaŋ a gɨmim gasɨ nɨŋbim rö u, kale ke nɨbi bɨ rɨmnap gau kalɨp u rö nöp gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nɨbi bɨ kalöp mɨdmagö lɨbal gau nöp mɨdmagö lɨnabim u, God kalöp aigöl göm nɨŋö, aij gɨnabŋ Nɨbi bɨ nan si nan naij gɨpal gau, nɨbi bɨ kale ke gau u rö nöp pen pen mɨdmagö lɨbal. ");
INSERT INTO kpw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pen nɨbi bɨ kalöp ud aij gɨpal gau nöp kalɨp gɨ aij gɨnabim u, God kalöp aigöl göm nɨŋö, aij gɨnabŋ Gɨnabim anɨbu, nɨbi bɨ nan si nan naij gɨpal gau gɨpal rö nöp gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nan ñɨno pen ñɨnaböl a gɨmim, gasɨ u nöp nɨŋmim nan ñɨnabim u, God kalöp aigöl göm nɨŋö, aij gɨnabŋ Gɨnabim anɨbu, nɨbi bɨ nan si nan naij gɨpal gau gɨpal rö nöp gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anɨb u, koƚmaƚ kale gau mɨdmagö lɨmim, kalɨp gɨ aij gɨmim, nan haƚöwaƚö ñɨmim. Hanɨp pen ñɨnaböl a gɨmim, gasɨ u nɨŋagmim. Anɨg geinabim u, God kƚö yabɨƚ adö laŋol mɨdöp u, ñɨ pai nɨpe mɨdeinabim. Nɨpe göp rö geinabim u me, kalöp hauƚ gagöm, pen aij ñɨnab. God nɨpe nɨbi bɨ nan si nan naij gɨpal gau abe, nɨbi bɨ nɨp, aij a göp, a gagpal gau abe, kalɨp u rö nöp gɨ aij gab. ");
INSERT INTO kpw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nap kale nɨbi bɨ mög nɨŋöm ud aij göp rö, kale u rö nöp nɨbi bɨ mög nɨŋmim ud aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kale nɨbi bɨ rɨmnap, ‘Anɨg anɨg gɨpim rö, kale nɨbi bɨ naij mɨdpim,’ a gagnabim u, God kalöp pen u rö nöp, ‘Anɨg anɨg gɨpim rö, kale nɨbi bɨ naij mɨdpim,’ a gagnab. Kale nɨbi bɨ rɨmnap manö kub hagmim, ‘Kale nɨbi bɨ naij, pen udnabim,’ a gagnabim u, God kalöp pen u rö nöp manö kub hagöm, ‘Kale nɨbi bɨ naij, pen udnabim,’ a gagnab. Nɨbi bɨ gau kalöp gɨ naij geinaböl u nɨŋmim arö geinabim u, God nan naij kale gɨpim u, u rö nöp nɨŋöm arö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nan kale gau nɨbi bɨ gau kalɨp haƚöwaƚö ñeinabim u, God kalöp pen u rö nöp haƚöwaƚö yabɨƚ ñɨnab. Kale skel nɨhön rö udmim nɨbi bɨ gau kalɨp nan nɨme lɨ ñɨnabim u rö, God skel anɨbu nöp ud kalöp u rö nöp nan nɨme lɨ ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pen Jisas manö ap hod rɨköm haga, “Bɨ amgö we gɨnab ap, bɨ amgö we ap nɨp, adan anɨg anɨg mɨdöp a göm yamagnab. Nɨhön gɨnɨg: nɨpe anɨg gö, mɨhöŋgöl uƚöm mɨgan yaŋ ap lug paknabil. ");
INSERT INTO kpw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nɨbi bɨ skul hagpal gau, am skul hagpal magö u, hag ñeb bɨ kale gau kalɨp adö laŋ mɨdagpal. Pen hainö skul u hag pɨs gɨ aij göm me, hag ñeb bɨ kale gau aip adɨp adɨp mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pen nɨhön gɨnɨg mab po amgö kalöp ke pak paƚu gɨ mɨdöp u nɨŋ hagmim wasö, namam nan acɨp amgö nɨpe mɨdöp u nöp nɨŋ hagpim? ");
INSERT INTO kpw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mab po kub amgö kalöp pak paƚu gɨ mɨdöp u nöd ud yube, amgö kale amgö yabɨƚ lö, hainö namam nan acɨp pro amgö nɨpe mɨdöp u, ud yuun a gɨmim hagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pen mab aij ap magö naij ap pɨlagnab; pen mab naij ap magö aij ap pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anɨb u, mab gau magö pɨlnab u nɨŋöm, mab u aij, mab u naij a göm nɨŋnaböl. Nagɨ mɨgañɨb u kia magö pɨlagnab. Nagɨ gabƚog u papo magö pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nɨbi bɨ aij gau, hibur gasɨ mɨdmagö aŋ kale daŋ aij mɨdöp rö, gɨ aij gɨpal. Nɨbi bɨ naij gau, hibur gasɨ mɨdmagö aŋ kale daŋ naij mɨdöp rö, gɨ naij gɨpal. Pen nɨbi bɨ aigale nɨbi bɨ rö mɨdpal u, manö hagnaböl u nöp apdi nɨŋun, nɨbi bɨ gau aij, nɨbi bɨ gau naij a gun nɨŋnabun. ");
INSERT INTO kpw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Yɨp Bɨ Kub hon, Bɨ Kub hon, a gɨpim u pen nɨhön gɨnɨg manö hagpin u hain gagpim? ");
INSERT INTO kpw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nɨbi bɨ manö yad u nɨŋöm, hagpin rö gɨpal gau, manö hagnɨg gabin i rö mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nɨbi bɨ manö yad u nɨŋöm, hagpin rö gɨnaböl gau, bɨ ram gɨ lɨnɨg geinab, uƚöm mɨlö udöm, ram padö kabö adö au lɨ aij göm, ram adö anɨbu nöp gɨ lɨnab rö mɨdnaböl. Anɨg gö, ñɨg uƚ apöm, ram halö pa jö ma jö gɨ ud arnam a gɨ wasö nɨŋöm, ram gɨ aij gɨnab anɨbu pɨdöŋ nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pen nɨbi bɨ manö yad u nɨŋöm, hagpin rö gagnaböl gau, bɨ ram gɨ lɨnɨg geinab, uƚöm mɨlö udagöm, ram padö lagöm, yɨharɨŋ ram mɨnöŋ adö adö au gɨ lɨnab rö mɨdnaböl. Anɨg gö, ñɨg uƚ apöm, ram halö pa jö ma jö gɨ ud arnam a göm, magö anɨbu nöp ram halö böŋ nöp ud arö, mɨnöŋ cög nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas nɨbi bɨ anɨb gau kalɨp manö anɨbu hag ñɨ pɨs göm daun pro Kapaneam ara. ");
INSERT INTO kpw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Pen daun anɨbu, bɨ kub ami bɨ iru nöp abad mɨdmɨdöp bɨ ap mɨdeia. Bɨ rɨmnap Jisas ap Kapaneam mɨdöp a gɨlö, manö anɨbu nɨŋöm, Rom ami bɨ kub Juda bɨ manö ud asɨkep rɨmnap hag yuöm haga, “Bɨ nagɨ wög gɨ ñeb aij yabɨƚ yad ap nan göp umnɨg gab nɨŋöm kale am Jisas nɨp hag nɨŋmim uɫ gɨ daube, nɨp gö kamɨŋ laŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Hagö, kale Jisas mɨdeia au amöm, nɨp manö kƚö neb neb göm hagla, “Ami bɨ abad mɨdep bɨ kub ap, bɨ aij yabɨƚ. Hanɨp Juda nɨbi bɨ gau mɨdmagö löm pör abad mɨd aij göp. Magum gep ram hanɨp ap gɨ la. Anɨb u, ne ammön bɨ nagɨ wög gɨ ñeb nɨpe u gö kamɨŋ lɨnɨm,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kale hageila nɨŋöm Jisas kalɨp aip am am ram au söl au amöl gɨlö nɨŋöl gɨ, ami bɨ abad mɨdep anɨbu bɨ nɨŋeb nɨpe rɨmnap hag yuö, am Jisas nɨp nable paköm hagla, “Bɨ ami abad mɨdep bɨ hon u nöp hagöp, ‘Bɨ Kub, yad bɨ aij wasö, ram yad u ma ilön auagmön. ");
INSERT INTO kpw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yad bɨ aij rö nöp nɨnam, pen yad nɨŋbin, God nöp aip mɨdöp rö, “Kamɨŋ laŋ,” manö u nöp hagaimön, bɨ yad nan göp anɨbu kamɨŋ lɨnɨm. ");
INSERT INTO kpw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bɨ kub yabɨƚ ap yɨp abad mɨdöp; yad ke pen ami bɨ gau kalɨp abad mɨdem, “Arim!” a gɨnö arbal; “Auim!” a gɨnö aubal; “Wög anɨbu gim!” a gɨnö gɨpal,’ a göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Anɨg haglö, Jisas, bɨ anɨbu gasɨ nɨpe ke nɨŋöm anɨg hagöp a göm, aiö göm, nɨbi bɨ nɨp hain göm aueila gau kalɨp haga, “Ami bɨ Rom nɨbö u, yɨp nɨŋ ud pɨdöŋ göp. Nɨpe göp anɨbu, Isrel bɨ ap unbö rö göp yad nɨŋagpin yabɨƚ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pen ami bɨ abad mɨdep bɨ u, bɨ nɨpe gau ado gɨ amöm nɨŋla, bɨ nan ga anɨbu hadö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ñɨn aŋ anɨbu nöp, Jisas aip bɨ nɨpe gau aip Nen daun arla. Nɨbi bɨ gau iru yabɨƚ nöp aip arla. ");
INSERT INTO kpw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Daun ajöŋ iƚ söl au amjaklö nɨŋöl gɨ, nɨbi adu ap ñɨ añɨ nɨpe yag daua uma u, wip ilöŋ löm daueila. Nɨbi bɨ iru nöp daun anɨbu nɨbö apöm nɨbi anɨbu aip aueila. ");
INSERT INTO kpw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas nɨbi adu anɨbu nɨp nɨŋö, mög gö haga, “Mɨɫöŋ gagmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Anɨg hagöm, nɨpe amöm wip ilöŋ lɨ daueila mab u ud nɨŋö nɨŋöl gɨ, bɨ ilöŋ daueila gau pɨdöŋ gɨla. Jisas bɨ praj uma u nɨp haga, “Ñɨ me, nöp hagabin, urak!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Anɨg hagö, ñɨ urak asɨköm manö hagö nɨŋöl gɨ, Jisas nɨme nɨp, ñɨ ne u, a göm ud ña. ");
INSERT INTO kpw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pen nɨbi bɨ nɨŋ mɨdeila gau magöŋhalö pa gɨƚɨ göm, God hib nɨpe u dap ranöl gɨ hagla, “God manö hagep bɨ kub yabɨƚ hanɨp auöp. God hanɨp gɨ ñɨnɨg auöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisas ga anɨbu nɨŋöm, aiud udlö, manö anɨbu Juda nɨbi bɨ ram mɨnöŋ kale gau gau amöm, ram mɨnöŋ ke gau gau magöŋhalö ara. ");
INSERT INTO kpw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon bɨ nɨpe gau, Jisas ga rö magöŋhalö nɨŋöm, am Jon nɨp hag ñɨlö, bɨ nɨpe mɨhöp hagö aueilö haga, ");
INSERT INTO kpw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Kale mɨhöŋ ammil Bɨ Kub nɨp hag nɨŋmil, ‘Ne Mesaia pör abad mɨdpun u nöp auban aka bɨ ke nɨbö ap halö abad mɨdaiun?’ ö gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hageia, bɨ mɨhau Jisas mɨdeia au ammil haglö, “Jon bɨ ñɨg pak ñeb u halɨp bɨ mɨhöŋ hagöp, ‘Kale mɨhöŋ ammil Bɨ Kub hag nɨŋmil, “Ne Mesaia pör abad mɨdpun u nöp auban aka bɨ ke nɨbö ap halö abad mɨdaiun,” a gɨmil,’ a göm, hol mɨhöŋ hag yuö, nöp hag nɨŋnɨg aubul i,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pen kale mɨhöŋ anɨg hagmil nɨŋ mɨdlö nɨŋöl gɨ, Jisas nɨbi bɨ iru nöp nan adö ke ke ga gau gö kamɨŋ la; nɨbi bɨ iru nöp mɨña ga gau gö kamɨŋ la; nɨbi bɨ iru nöp kɨjaki aiön pi abaŋ al mɨdeia gau gö kamɨŋ la; nɨbi bɨ iru nöp amgö we ga gau gö amgö ñɨl nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Anɨg göm, Jisas bɨ anɨb mɨhau kalɨp haga, “Kale mɨhöŋ ado gɨ ammil Jon nɨp hagmil, ‘Hol am nɨŋbul, bɨ anɨbu nɨbi bɨ amgö we ga gau gö amgö ñɨl nɨŋbal; nɨbi bɨ ma böŋ nöp naij ga gau gö kauyaŋ ajaböl; nɨbi bɨ hañ romaŋ wös hapeb la gau gö mɨƚep göp; nɨbi bɨ rɨmɨd mɨgan pɨƚ göp gau gö manö apdi nɨŋaböl; nɨbi bɨ umbal gau gö kamɨŋ mɨdpal; nɨbi bɨ mög gep rö gau manö aij u hagab nɨŋaböl. ");
INSERT INTO kpw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nɨbi bɨ yɨp gasɨ nɨŋöm cɨg göl gɨ nöp mɨdeinaböl gau, mɨñ mɨñ yabɨƚ gɨnaböl,’ a gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Anɨg hagö, bɨ Jon manö daulö mɨhau ado gɨ arlö nɨŋöl gɨ, Jisas nɨpe, Jon nɨp manö adö u hagöm nɨbi bɨ mɨdeila gau kalɨp haga, “Kale nöd ram mɨnöŋ kabö nöp mɨdöp aŋ au arbe ñɨn u, nɨhön nɨŋnɨg arbeŋ Kale hod mɨlö añɨ ap yɨgön ud aŋa gɨ daŋ i göp ap nɨŋnɨg arbe? ");
INSERT INTO kpw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kale nɨhön nɨŋnɨg arbeŋ Bɨ waƚɨj aij yabɨƚ yɨmöb ap nɨŋnɨg arbeŋ Anɨbu wasö. Bɨ waƚɨj aij yabɨƚ udöm, nan aij aij udun a göm gasɨ nɨŋbal gau, bɨ kub ram gau nöp hanbal. ");
INSERT INTO kpw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pen kale nɨhön nɨŋnɨg arbeŋ God manö hagep bɨ ap nɨp nɨŋnɨg arbe akaŋ Nɨŋö me, God manö hagep bɨ ap nɨp nɨŋnɨg arbe, pen bɨ Jon nɨŋbe u nɨpe wög adö ke nɨbö gɨnɨg aua. ");
INSERT INTO kpw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bɨ Jon u me, hadame ram God Manö u kalɨ kƚiñ rɨköm hagla, ‘Bɨ manö hagep yad u hag yunö, nöd amöm, nɨbi bɨ gau kalɨp hag ñɨ aij gɨnab; hainö ne ke hag yunö nɨnabön,’ a göm kalɨ kƚiñ rɨkla. ");
INSERT INTO kpw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kalöp hagabin, nɨbi bɨ nöd mɨdmɨdal gau abe, nɨbi bɨ mɨñi mɨdpal gau abe magöŋhalö nɨbi bɨ yɨharɨŋ, Jon bɨ kub. Pen God nɨbi bɨ yɨharɨŋ gau udöm ram mɨnöŋ nɨpe kumi kabö adö laŋ au abad mɨdeinab gau, kale Jon rö mɨdageinaböl; kale nɨbi bɨ kub mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɨbi bɨ gau, bɨ dakɨs udep gau halö, nöd Jon nɨp aula, kalɨp magöŋhalö ñɨg pak ña. Anɨg gö, Jisas manö haga u nɨŋöm hagla, “God adan nɨpe nöp kabö rö mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pen bɨ Perisi abe, bɨ lo manö hag ñeb bɨ kub gau abe kale, God kalɨp nɨhön nɨhön gɨlaŋ a ga u gasɨ kale ke nɨŋöm pa jö nɨŋöm, Jon hanɨp ñɨg pak ñaŋ a göm auagla. ");
INSERT INTO kpw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Pen Jisas nɨbi bɨ anɨb gau kalɨp manö ap hagöm haga, “Nɨbi bɨ mɨñi ñɨn i mɨdpim gau yad nɨŋbin, kale ñɨ pai pro gau, nɨbi bɨ magum gep ka au asɨköm, ñɨ pai pro rɨmnap meg mɨgan dap ranöm hag amɨl apɨl göm hagpal, ‘Hon aƚɨŋ pu gɨno, kale nɨhön gɨnɨg kugom ralagpimŋ Pen kɨmap mɨɫöŋ gep rö ap hagno, kale nɨhön gɨnɨg mɨɫöŋ gagpim?’ ö gɨpal rö u, kale gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nɨhön gɨnɨg: Jon bɨ ñɨg pak ñeb u apöm, nan magö ñɨŋagöm, ñɨg wain ñɨŋagöm gö, kale nɨp hag jumim hagpim, ‘Bɨ kɨjaki aiön pi abaŋ alöp mɨdöp u,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pen mɨñi yad Bɨ Ñɨ nɨpe apem, nan ñɨŋem, ñɨg wain ñɨŋem gɨnö, yɨp hag jumim hagpim, ‘Nan iru ñɨŋöm, ñɨg wain ñɨŋöm göp u me, nɨpe nɨbi bɨ nan si nan naij gɨpal bɨ gau, bɨ dakɨs udep bɨ gau, bɨ kale ap mɨdöp u,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pen nɨbi bɨ God Manö aij u nɨŋ udöm, hain göm, gɨ aij göm, mɨd aij geinaböl u, nɨbi bɨ gau kalɨp nɨŋöm hagnaböl, God Manö u manö nɨŋö yabɨƚ, a gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bɨ Perisi ap hib nɨpe Saimon. Nɨpe Jisas nɨp haga, “Ne aumön ram yad u nan magö ñɨŋul,” a ga. Hagö, Jisas ram nɨpe u amöm nan magö ñɨŋlö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","nɨbi daun anɨbu mɨdöm nan si nan naij gɨmɨdöp manö ap nɨŋa, Jisas bɨ Perisi ram amöm aip nan ñɨŋailö. Anɨb u nɨŋöm, ñɨg haƚɨŋ aij auep kabö barol ud rɨm lɨla ap dapöm, ");
INSERT INTO kpw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisas mɨdeia jöl adö gau apöm, ma iƚ au mɨɫöŋ gɨ mɨdeia. Anɨg göl mɨɫöŋ gö nɨŋöl gɨ, amgö ñɨg u gɨ dö gɨ Jisas ma adö yaŋ lugö, umagö nɨpe u ud ƚɨƚɨ gɨ yuöl gɨ, ma kɨd nɨpe u bom haluöm, mulu ñɨŋöm, ñɨg haƚɨŋ aij auep anɨbu ma kɨd nɨpe adö au lɨ ña. ");
INSERT INTO kpw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Anɨg geia, bɨ Perisi Saimon u, gasɨ magö nɨpe u nöp gasɨ nɨŋöm nɨp ke haga, “Bɨ anɨbi bɨ God manö hagep kabö göl mɨdaiböp, nɨbi anɨbi nɨpe nan si nan naij gɨmɨdöp nɨbi naij ap apöm nɨp ud nɨŋab u rɨk nɨŋböp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas pen, bɨ Perisi gasɨ nɨŋa anɨbu nɨŋöm, nɨp haga, “Saimon, manö yad añɨ ap mɨdöp nöp hag ñɨnɨg gabin,” a ga. Hageia, Saimon haga, “Manö hag ñeb bɨ yad, manö anɨbu hag,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hageia, Jisas manö hod rɨköm haga, “Bɨ ap uraköm, bɨ mɨhöp kalɨp bɨ ap paip hadred (500) denariai ñöm, ap pipdi denariai (50) ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pen hainö bɨ anɨb mɨhau pen ñeb rö lagö, bɨ mani ñɨnab anɨbu kalɨp mɨhöŋ hagnab, ‘Arö gɨmil. Mani kalöp mɨhöŋ ñɨbin u, pen ñul a gɨmil gasɨ u nɨŋagmil,’ a gɨnab. Anɨg hagö, bɨ an bɨ anɨbu nɨp mɨdmagö yabɨƚ lɨnab, bɨ nan naböŋ kub mɨdeinab u aka bɨ nan naböŋ pro mɨdeinab u?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hageia, Saimon haga, “Gasɨ yad nɨŋbin u, bɨ nan naböŋ kub mɨdeinab u,” a ga. Hageia, Jisas haga, “Nɨŋö yabɨƚ hagpan,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Anɨg hagöm, Jisas ado gɨ, nɨbi u nɨp nɨŋöm, Saimon nɨp haga, “Nɨbi i nɨp nöŋ. Yad ram raul mɨgan nöp i auajɨn, ne ñɨg ap udmön ma yɨp ƚɨk gɨ yuep rɨmnap ñagpan, jɨ nɨbi anɨbi, amgö ñɨg nɨpe u gɨ dö gɨ lugöm ma yad ñɨg lö, umagö nɨpe udöm ƚɨƚɨ gɨ yuöp. ");
INSERT INTO kpw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne yɨp bom haluagpan, jɨ nɨbi i, yad ram raul mɨgan nöp apjakajɨn magö u rɨkö, nɨpe ma kɨd yad bom haluöl gɨ nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yɨp wel nabɨc cög laŋ lɨ ñagpan, jɨ nɨbi i nɨpe ma kɨd yad ñɨg haƚɨŋ aij auep u lɨ ñöb. ");
INSERT INTO kpw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anɨb u, nöp hagabin, nɨbi anɨbi nan si nan naij iru nöp göp u nɨŋem arö gɨpin. Anɨb u, yɨp pen mɨdmagö yabɨƚ löp. Pen nɨbi bɨ nan si nan naij pro pro gɨpal gau nɨŋem arö gɨnö, yɨp pen mɨdmagö pro pro lɨbal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pen Jisas anɨg hagöm nɨbi anɨbu nɨp haga, “Nan si nan naij gɨpan gau nɨŋem arö gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Anɨg hagö, bɨ nɨpe aip nan ñɨŋeila gau, kale ke hag nɨŋ hag nɨŋ göm hagla, “Bɨ anɨbi nɨhön gɨnɨg göm, ‘Nan si nan naij gɨpan gau nɨŋem arö gabin,’ a gab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Anɨg hageila u pen Jisas nɨbi anɨbu nɨp haga, “Gasɨ ne ke u nöp nɨŋ udmön, nan si nan naij gɨpin rö Jisas nɨŋöm arö gaŋ, a gɨmön auban rö, nan si nan naij gɨpan gau nɨŋem arö gɨpin. Ne ammön, God ñɨmagö ara adö u mɨdaimön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pen hainö ñɨn aŋ anɨb au, Jisas bɨ nɨpe unbö mɨgan laŋ aip daun gau abe, ram rɨƚɨg agƚö gau abe amöm, God nɨbi bɨ nɨpe udöm abad mɨdeinab manö aij u, nɨbi bɨ gau kalɨp hag ña. ");
INSERT INTO kpw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pen ñɨn anɨbu, nɨbi rɨmnap kɨjaki aiön pi halö mɨdeila gau Jisas gö kamɨŋ la, rɨmnap nan ga gau gö kamɨŋ la, nɨŋöm nɨbi anɨb gau rɨmnap Jisas aip ajmɨdal. Nɨbi anɨb gau hib kale me, ap Maria Magdala a gɨmɨdal. Kɨjaki aiön pi unbö mudun jɨŋ nɨbi anɨbu aŋ daŋ mɨdöm höŋ arla. ");
INSERT INTO kpw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nɨbi ap Joana. Nugmul nɨpe hib u Kuja. Nɨpe kiŋ Herod ram nan nɨpe gau abad mɨdmɨdöp. Nɨbi ap Susana. Pen nɨbi rɨmnap halö iru rö aip ajmɨdal. Nɨbi anɨb gau kale magöŋhalö mani kale ke udöm, nan magö rau dapöm, Jisas bɨ nɨpe gau aip nan magö jɨm ñöl ñɨŋ ajmɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nɨbi bɨ daun ke ke, yam ugan kub yöl gau nɨbö gau nɨbö Jisas nɨp nɨŋnɨg aulö nɨŋöl gɨ, nɨbi bɨ nöd aula gau kalɨp manö ap hod rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bɨ ap, gɨñbɨƚ magö ranaŋ a göm, gɨñbɨƚ magö u dam wög adɨŋ gau yunab. Rɨmnap wög adɨŋ arep adan gau lugö, nɨbi bɨ ƚaƚa gɨ amɨl apɨl gɨlö, yaur gau pen ap nɨŋöm ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pen yɨŋ rɨmnap kabö adö mɨnöŋ pro pro mɨdeinab gau lugöm, marep gɨnab u pen kabö mɨnöŋ au ñɨg ñɨg halö mɨdageinab u me, böŋ nöp mɨƚep gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pen yɨŋ rɨmnap nagɨ gɨƚɨkasɨ aŋ gau lugö, nagɨ anɨbu hararo gɨ paƚu gö, ran aij gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pen yɨŋ rɨmnap mɨnöŋ aij gau lugöm, ran aij göm, magö iru yabɨƚ nöp pɨlnab. Añɨ añɨ magö ñɨn juöl unbö mamɨd pɨlnab,” a ga. Jisas kalɨp anɨg hagöm haga, “Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas manö hod rɨköm aiud anɨbu hagö, bɨ nɨpe gau nɨp hag nɨŋöm hagla, “Manö hod rɨkmön hagajan anɨbu, manö iƚ u aigöl gö rö mɨdöp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hageila, Jisas kalɨp haga, “God nɨbi bɨ nɨpe udöm abad mɨdeinab manö pi göl mɨdmɨdöp u, God kalöp gasɨ ñö nɨŋbim, pen nɨbi bɨ rɨmnap gau, yad kalɨp manö hod rɨkem nöp hagnö, ‘kale nɨŋöm nɨŋagöl, manö magö apdi nɨŋöm manö iƚ nɨŋ udagöl.’ ");
INSERT INTO kpw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pen manö hod rɨkem nan yɨŋ rö hagpin u, God Manö adö u hagpin. ");
INSERT INTO kpw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yɨŋ rɨmnap lugnab wög adɨŋ arep adan adö au a gɨpin u, nɨbi bɨ gau God Manö u nɨŋnaböl pen Seden gasɨ naij nɨŋöm, kale God Manö u nɨŋ udlö, God kalɨp ud kamɨŋ yunab u naij göp a göm, apöm God Manö gasɨ kalɨp aŋ daŋ mɨdöp u ju udö, hauƚ gɨnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pen yɨŋ rɨmnap lugnab kabö adö mɨnöŋ pro pro mɨdeinab gau a gɨpin u, nɨbi bɨ gau God Manö u nɨŋöm, ñɨñɨ löm, aij a gö nɨŋöl gɨ, manö anɨbu nɨŋ udnaböl u pen nɨŋ ud pɨdöŋ gagnaböl rö, mɨŋör rɨmnap auö hauƚ göm arö gɨnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pen yɨŋ rɨmnap lugnab nagɨ gɨƚɨkasɨ aŋ gau a gɨpin u, nɨbi bɨ gau God Manö u nɨŋnaböl u pen hainö manö marö aka mani kub nan gau aka mɨñ mɨñ gep adö u nöp gasɨ nɨŋöm, God Manö nɨŋ ud pɨdöŋ gagnaböl, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pen yɨŋ rɨmnap mɨnöŋ aij adö au lugöm, ran aij göm, magö iru yabɨƚ nöp pɨlnab a gɨpin u, nɨbi bɨ gau God Manö u nɨŋöm, nɨŋ ud pɨdöŋ yabɨƚ göm, gɨ dam dam, nan magö aij pɨlnab, a gem hagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas anɨg hagöm haga, “Nɨbi bɨ gau hapö lauöm rin cög mɨgan aka abañ adö hanbal u mo gayɨk gau pi gagnaböl. Adö au gɨlaŋ rɨk lɨlö mailö gö, nɨbi bɨ gau ram raul mɨgan anɨbu apöm mailö anɨbu nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“U rö nöp me, nan nɨhön nɨhön pi göl mɨdöp gau, magöŋhalö waiö lɨnab; nan nɨhön nɨhön paƚu gɨ mɨdöp gau, magöŋhalö ud mailö göp au lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Anɨb u, manö hagabin u nɨŋ aij gɨmim. Nɨbi bɨ manö nɨŋöm, nɨŋ udnaböl gau, manö aij rɨmnap halö nɨŋnaböl; pen nɨbi bɨ manö nɨŋöm nɨŋ udagnaböl gau, pro pro nɨŋun a göm nɨŋbal u halö böŋ nöp ur gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pen ñɨn anɨbu nöp, Jisas nɨme aip, nɨmam hain nɨpe gau aip Jisas nɨp nɨŋnɨg aula. Apöm nɨŋla, ram raul mɨgan anɨb yaŋ Jisas nɨbi bɨ sɨsɨ göl mɨdeila nɨŋöm höŋ yaŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Anɨg gɨlö, nɨbi bɨ ap ram raul mɨdeila gau nɨŋöm, Jisas nɨp hagla, “Name namam ne gau nöp nɨŋnɨg ap mɨdpal höŋ yaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Haglö, Jisas kalɨp haga, “Nɨbi bɨ an an God Manö u nɨŋöm hain gɨpal gau me, ami yad, mam yad mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pen ñɨn ap, Jisas bɨ nɨpe gau kalɨp hagöm haga, “Ñɨg Waŋö Galili juun böŋ lödaŋ arun,” a göm, ñɨg magɨb udöm arla. ");
INSERT INTO kpw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pen aŋ gau arlö nɨŋöl gɨ, Jisas nɨpe hon han ara. Hon haneia magö u, yɨgön asad kub yabɨƚ ap ñɨg aŋ anɨbu udöm, ñɨg ral ñɨg magɨb mɨgan u auö, umöl rö nöp la. ");
INSERT INTO kpw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Anɨg gö, bɨ nɨpe gau apöm, Jisas nɨp aŋa gɨlö uraka hagla, “Bɨ Kub! Hon magöŋhalö umnɨg gabun!” a gɨla. Hageila, Jisas yɨgön udaia u abe, ñɨg ral auaia u abe hag gö, magö anɨbu nöp yɨgön u ur göm, ñɨg u haluöm, nöd mɨdeia rö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pen Jisas bɨ nɨpe gau kalɨp haga, “Kale ai gɨmim yɨp nɨŋ udagpim?” ö ga. Hageia, kale pɨñɨŋ göm aiö waiö göm, kale ke hag nɨŋ hag nɨŋ göm hagla, “Bɨ anɨbi bɨ an? Nɨpe hagö, yɨgön abe, ñɨg kub abe manö nɨpe hagöp rö nöp göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ñɨg magɨb udöm, amöm Ñɨg Waŋö Galili aŋ u am am, ram mɨnöŋ Gerasa nɨbi bɨ mɨdmɨdal böŋ lödaŋ arla. ");
INSERT INTO kpw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pen Jisas ñɨg magɨb u arö gɨ, ñɨg waŋö goƚ au kabö kuƚup adö au ma abö gö nɨŋöl gɨ, magö anɨbu nöp, kɨjaki aiön pi abaŋ al mɨdeila bɨ ap, daun anɨbu nɨbö apöm, Jisas nɨp nable paka. Bɨ anɨbu nɨpe magö nöp mɨdöm, ram yabɨƚ raul mɨgan u hanagmɨdöp; wip rɨgöl gɨmɨdal kabö mɨgan gau nöp han ajmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bɨ nɨpe abad mɨdep gau, sen udöm ñɨmagö ma nɨpe gau adɨk lɨ pɨdöŋ gɨmɨdal u pen kɨjaki nan gau apöm kƚö gɨlö, sen lɨmɨdal anɨb gau pak gɨ dö gö, ram mɨnöŋ nöp aŋ gau pör pör armɨdöp. Pen bɨ anɨbu, Jisas nɨp nɨŋöm aiö göm, apöm ma iƚ au lug paka. Jisas kɨjaki aiön pi nɨp abaŋ alla anɨb gau kalɨp haga, “Bɨ anɨbi nɨp arö gɨmim höŋ arim!” a ga. Jisas anɨg hagö, kɨjaki aiön pi nɨp abaŋ alla bɨ u, kakö göm, manö kub hagöm haga, “Ne Jisas, God Bɨ Kub adö i gɨlaŋ mɨdöp Ñɨ nɨpe u, yɨp nɨhön gɨnɨg gabön? Yɨp ilön kub ñagmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hageia, Jisas haga, “Hib ne u hag!” a ga. Jisas hageia, nɨpe pen haga, “Hib yad u Iru Nöp,” a ga. Kɨjaki aiön pi nan gau iru yabɨƚ nöp nɨp yuö hiɨköm mɨdeila rö u me, anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pen kɨjaki aiön pi gau Jisas nɨp neb neb göm hagla, “Hanɨp hagmön, mab ke yaŋ uƚöm mɨgan mauɨñ juaga u yuagmön!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Anɨg hagöm, kaj iru yabɨƚ nöp amɨl geila yöp ba anɨb gau nɨŋöm, Jisas nɨp neb neb göm hagla, “Ne hanɨp hagö, am kaj mɨdpal gɨdaŋ kalɨp yuö hiɨkun,” a gɨlö, Jisas yau a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jisas yau a gö, kɨjaki aiön pi nan gau, bɨ u nɨp arö göm, am kaj anɨb gau kalɨp yuö hiɨklö, kaj gau pɨg ju sɨr ba yaŋ amöm, gɨ dam ñɨg waŋö aŋ yaŋ paköm, ñɨg ñɨŋöm magöŋhalö um hakla. ");
INSERT INTO kpw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pen bɨ kaj mukmɨdal gau, ga anɨbu nɨŋöm, gɨ dö gɨ am nɨbi bɨ daun mɨdeila gau kalɨp hag ñöm, am nɨbi bɨ ram mɨnöŋ daun söl au mɨdeila gau kalɨp hag ñöm, gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hag ñɨlö, nan anɨbu nɨhön gö hagaböl a göm, apöm nɨŋla, bɨ kɨjaki yuö hiɨköm mɨdmɨdöp u, kamɨŋ lö, waƚɨj yɨmöm, Jisas ma iƚ söl au asɨk mɨdeia. Kale anɨbu nɨŋöm anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pen nɨbi bɨ nɨŋ mɨdlö nɨŋöl gɨ, Jisas kɨjaki hag höŋ yua, nɨbi bɨ gau, nɨbi bɨ hain aula gau kalɨp, anɨg anɨg göp, a göm, hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pen Gerasa nɨbi bɨ magöŋhalö anɨnɨn gö pɨñɨŋ göm, Jisas nɨp, ne ado gɨ aru a gɨlö, ñɨg magɨb udöm hada. ");
INSERT INTO kpw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jisas arɨk arnɨg geia nɨŋöm, nɨpe gö kɨjaki aiön pi höŋ arla bɨ anɨbu, nɨp manö neb neb hagöm haga, “Yad ne aip arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Anɨg hageia, Jisas nɨp pen haga, “Wasö. God nöp nan aij yabɨƚ nɨhön nɨhön göp u, ne ram ne ammön nɨbi bɨ ne gau kalɨp hag ñɨmön,” a ga. Anɨb u, nɨpe daun nɨpe ado gɨ amöm, nɨbi bɨ gau kalɨp magöŋhalö, Jisas yɨp anɨg anɨg göp a göm, hag ña. ");
INSERT INTO kpw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pen nɨbi bɨ Jisas auab a göm, abad mɨdeila gau, Jisas ñɨg magɨb udöm amjakö, aij yabɨƚ auabön e gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Pen bɨ kub Juda magum gep ram abad mɨdmɨdöp bɨ ap hib nɨpe Jairas. Pai nɨpe añɨ yabɨƚ mɨ in la mɨgan laŋ u umnɨg gö, Jairas nɨpe apöm, Jisas mɨdeia söl au kugom yɨmöm haga, “Ram yad arul. Pai yad añɨ u umnɨg gab,” a ga. Hageia, Jisas nɨŋnɨg arö nɨŋöl gɨ, nɨbi bɨ iru yabɨƚ nöp apöm, nɨp böŋ böŋ cɨro cɨro ñöl gɨ arla. ");
INSERT INTO kpw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pen nɨbi ap pör pör nɨpe nɨbi adan armɨdöp mɨ unbö mɨgan laŋ la. Nɨbi anɨbu, wös wameb bɨ gau yɨp gɨlö, yɨp kamɨŋ laŋ a göm, kalɨp mani ñɨmɨdöp u pen nɨp gɨlö mɨƚep gɨnɨm rö laga. ");
INSERT INTO kpw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nɨpe Jisas araia jöl adö lau apöm, waƚɨj mɨlö kub la u ud nɨŋö nɨŋöl gɨ, magö anɨbu nöp nɨp mɨƚep ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pen Jisas kalɨp haga, “Yɨp bɨ an ud nɨŋöb?” ö ga. Hageia, nɨbi bɨ gau hagla, “Hon ud nɨŋagun,” a gɨla. Pen Pida haga, “Bɨ Kub, nɨbi bɨ iru nöp gai i apöm, nöp cɨro cɨro ñaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hageia, Jisas haga, “Nɨbi bɨ ap yɨp ud nɨŋöb. Pɨdöŋ yad u aröp nɨŋem hagabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pen nɨbi Jisas ud nɨŋa anɨbu, nɨpe pi gɨnɨm rö laga u nɨŋöm, gɨl gɨl göl gɨ, Jisas mɨdeia söl au ap kugom yɨma. Nɨbi bɨ anɨb gau nɨŋ mɨdeila aŋ gau, Jisas nɨp hagöm, nɨpe nan gö, Jisas ud nɨŋö, magö anɨbu nöp kamɨŋ löp aiud u magöŋhalö waiö haga. ");
INSERT INTO kpw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hageia, Jisas nɨp haga, “Pai yad. Ne yɨp ud nɨŋnö kamɨŋ laŋ a gɨmön nɨŋ udpan u, yɨp ud nɨŋö kamɨŋ löp me u. Manö mɨdagöp. Ne ammön, God ñɨmagö ara adö u mɨdaimön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas anɨg hagö nɨŋöl gɨ, bɨ Jairas nɨp wög gɨmɨdöp bɨ ap apöm, Jairas nɨp haga, “Pai ne böŋ nöp umöb; hag ñeb bɨ nɨp hagö ma ilön auagnɨm; ado gɨ arnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hagö, Jisas manö anɨbu nɨŋöm, Jairas nɨp haga, “Pai yad u umöb a gɨmön, gasɨ u nɨŋagmön. Nɨŋ udeinabön u, nɨp kamɨŋ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Anɨg hagöm, Jairas ram nɨpe u amjaköm, nɨbi bɨ gau kalɨp magöŋhalö hag höŋ au yaŋ löm, pai nɨme nap mɨhau, Pida u, Jon u, Jems u kalɨp uɫ göm, pai u nɨp nɨŋnɨg ram raul mɨgan yaŋ arla. ");
INSERT INTO kpw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pen nɨbi bɨ, pai anɨbu umöb a göm mɨɫöŋ gɨ mɨdeila gau, Jisas kalɨp haga, “Kale mɨɫöŋ gagim. Pai u umagöp; yɨharɨŋ hon hanab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jisas anɨg hageia, nɨbi bɨ gau, pai anɨbu böŋ nöp umöb u nɨŋöm, nɨp mɨhol gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pen Jisas pai u ñɨmagö kɨd nɨpe u udöm haga, “Pai yad, urak!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anɨg hagö, ana nɨpe u ap kuöyaŋ kuöbö gö uraka. Uraka, Jisas haga, “Nan rɨmnap ñɨbe ñɨŋaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pai nɨme nap kale aiö waiö gɨlö. Pen Jisas kalɨp ber mɨhau haga, “Nɨbi bɨ rɨmnap kalɨp manö anɨbu hag ñagmil, wasö!” ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jisas bɨ nɨpe unbö mɨgan laŋ kalɨp hagö aueila haga, “Yad kalöp bɨ yad, kƚö yad ke ñem, yunɨg gabin. Anɨb u, kale gau ammim, kɨjaki aiön pi nɨbi bɨ yuö hiɨköm mɨdpal gau hagpe höŋ aröl; nɨbi bɨ nan göp gau gɨpe kamɨŋ lɨnɨm; nɨbi bɨ mɨña göp gau gɨpe hir gɨnɨm; God nɨbi bɨ udöm abad mɨdeinab manö aij u hag ñɨbe nɨŋöl. ");
INSERT INTO kpw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pen arnɨg gɨmim, waƚab adɨŋ, wadɨ, nan ñɨŋeb, mani, waƚɨj, nan gau halö ud aragmim; yɨharɨŋ armim. ");
INSERT INTO kpw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Daun ap ammim ram ap amjakmim, kalöp hag udaiöl, kalɨp aip han mɨdmim, daun anɨbu arɨk arun a gɨnabim u, magö u nöp arɨk armim. ");
INSERT INTO kpw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pen ram mɨnöŋ mɨgan ap arbe, kalöp hag udagaiöl, daun anɨbu arɨk arun a gɨnabim u, kalɨp hagmim, ‘Manö aij u dauajun udagpim rö, mɨnöŋ naböŋ kalöp i auajun, nan acɨp acɨp ma hanɨp udöp u ƚɨk gɨ yuun arabun,’ a gɨmim, ƚɨk gɨ yumim armim. Anɨg gɨnabim, kale gɨ naij gɨpal u nɨŋnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Anɨg hagö, kale ram rɨƚɨg agƚö magöŋhalö gau gau am am manö aij u hag ñöl gɨ, nɨbi bɨ mɨña ga gau gɨlö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pen nɨbi bɨ gau, Jisas nɨhön nɨhön ga manö u hag amɨl apɨl gɨlö nɨŋöl gɨ, gapman bɨ kub Herod nɨŋöm, gasɨ iru yabɨƚ nɨŋa. Nɨbi bɨ rɨmnap hagla, “Jon bɨ ñɨg pak ñeb uŋam rɨb gɨ dö gɨla uma u, kauyaŋ uraköp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Rɨmnap hagla, “Bɨ nöd nɨbö God manö hagep bɨ u Ilaija nɨpe auöp,” a gɨla. Rɨmnap hagla, “Bɨ hadame dagol gau God manö hag ñɨmɨdöp bɨ ap kauyaŋ kamɨŋ löm auöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Anɨg haglö, bɨ kub Herod haga, “Jon nɨp uŋam rɨb gɨ dö gɨnö hadö uma rö, bɨ anɨbu bɨ an ap mɨdö nɨŋöl gɨ hagaböl u am nɨŋnam,” a göm, gasɨ u nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pen Jisas bɨ nɨpe unbö mɨgan laŋ ado gɨ apöm, ram mɨnöŋ gau ajöm nan nɨhön nɨhön gɨla manö u, Jisas nɨp hag ñɨla. Hag ñɨlö, am ram mɨnöŋ mɨgan ap ke am mɨdaiun a göm, Jisas kalɨp uɫ göm Bedsaida daun au arla. ");
INSERT INTO kpw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pen adan aŋ gau arlö nɨŋöl gɨ, nɨbi bɨ rɨmnap hagla, “Jisas bɨ nɨpe gau aip apöm padiaböl,” a gɨla. Anɨg haglö, nɨbi bɨ iru nöp nɨp nɨŋnɨg hain gɨla. Aueila, nɨpe aij auabim e göm, God nɨbi bɨ udöm abad mɨdeinab manö u kalɨp hag ñöl gɨ, nɨbi bɨ nan ga gau gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pen dugo sɨdö wad arnɨg geia magö u, bɨ nɨpe unbö mɨgan laŋ apöm, Jisas nɨp hagla, “Ram mɨnöŋ gai i, nɨbi bɨ mɨdagpal, ram mɨnöŋ nöp aŋ aui mɨdpun rö u, nɨbi bɨ gai i kalɨp hag yuö, ram nɨbi bɨ mɨdpal gau ke ke amöm, nan ñɨŋeb kale gau ke uƚhai nɨŋöm, haneb mɨgan gau uƚhai nɨŋlaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Anɨg hageila, Jisas pen haga, “Kale ke nan magö kalɨp ñɨmim,” a ga. Hageia, kale hagla, “Hon nan ñɨŋeb iru mɨdagöp. Yɨharɨŋ bred magö unbö mamɨd u mɨdöm, kabsaƚ mɨhöp mɨdöp. Ne nɨhön gasɨ nɨŋban? Nɨbi bɨ gai i iru nöp mɨdpal u, hon am nan ñɨŋeb kalɨp rɨmnap rau dapun aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ñɨn anɨbu, nɨbi bɨ apöm magum gɨla gau, nɨbi ñɨ pai gau wasö, bɨ gau nöp me wö ralla paip dausan (5000) rö ara. Pen Jisas bɨ nɨpe gau kalɨp haga, “Nɨbi bɨ iru nöp ap mɨdpal gai i hagpe, nɨbi bɨ unbö ñɨnjuöl mɨhöp ado gɨ da unbö sɨduŋ laŋ (50) ugan ke ke asɨklaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hageia, bɨ nɨpe gau nɨpe haga rö nöp gɨlö, nɨbi bɨ gau magöŋhalö au asɨkla. ");
INSERT INTO kpw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nɨpe bred magö unbö mamɨd u udöm, kabsaƚ mɨhau halö udöm, gɨlaŋ gɨ kumi kabö adö laŋ au nɨŋöm, God nɨp aij a göm, nan ñɨŋeb anɨbu ud jö göm, bɨ nɨpe gau kalɨp ñö, kale pen udöm, nɨbi bɨ gau kalɨp nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ñeila, kale magöŋhalö ñɨŋ damöm, ñɨŋ haköl rö lagö, naböŋ naböŋ pali pali gɨla gau, bɨ nɨpe gau ud wadɨ unbö mɨgan laŋ yaglö ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pen ñɨn ap, Jisas am ke halö God nɨp sabe göl gɨ mɨdöm, bɨ nɨpe gau kalɨp hag nɨŋöm haga, “Nɨbi bɨ gau yɨp bɨ an a gɨ gasɨ nɨŋbal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hageia hagla, “Nɨbi bɨ rɨmnap nöp Jon bɨ ñɨg pak ñeb u a gɨ gasɨ nɨŋbal; rɨmnap nöp bɨ nöd nɨbö God manö hagep bɨ u Ilaija a gɨ gasɨ nɨŋbal; rɨmnap nöp bɨ hadame dagol gau God manö hag ñɨmɨdöp bɨ ap kauyaŋ kamɨŋ löm auöp a gɨ gasɨ nɨŋbal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hageila, Jisas kalɨp pen hag nɨŋa, “Pen kale ke yɨp bɨ an a gɨmim, gasɨ nɨŋbim?” ö ga. Hageia, Pida pen haga, “Ne God Krais nɨpe u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Anɨg hageia, Jisas kalɨp haga, “Manö anɨbu nɨbi bɨ rɨmnap kalɨp hag ñagmim, wasö yabɨƚ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jisas anɨg hagöm, manö ap hagöm haga, “Bɨ Ñɨ nɨpe nɨp ilön kub yabɨƚ ñɨnaböl. Bɨ manö ud asɨkep gau, bɨ God nɨp nan sabe gep bɨ kub gau, bɨ lo manö hag ñeb bɨ gau, nɨp nɨŋlö mulu lugö al pak lɨlö, umnab u pen ñɨn mɨhöp mɨdöm ruö ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pen Jisas bɨ nɨpe gau abe, nɨbi bɨ mɨdeila gau abe, kalɨp magöŋhalö hagöm haga, “Nɨbi bɨ yɨp hain gun a göm, gasɨ nɨŋeinaböl gau, nan mɨnöŋ naböŋ adö iƚ i gasɨ kub nɨŋbal u arö göm, hañ romaŋ kale ke gasɨ kub nɨŋbal u arö göm, ñɨn añɨ añɨ mab kros ud kag göm yɨp hain göl. ");
INSERT INTO kpw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nɨbi bɨ an, hañ romaŋ, kamɨŋ mɨdep magö hon ke gasɨ nɨŋun mɨd aij gɨnabun a göm, gasɨ nɨŋnaböl gau, böŋ nöp ap lug paknaböl. Pen nɨbi bɨ an, Jisas nɨp nɨŋ udun, hañ romaŋ, kamɨŋ mɨdep magö hon nɨhön nɨhön gɨnab u manö mɨdagöp a göm, gasɨ nɨŋnaböl gau, kamɨŋ mɨdep magö u udnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nɨbi bɨ nan mɨnöŋ naböŋ adö iƚ i udun a göm, gɨlö arnab gau, nan aij aij gau udöm, mɨnöŋ naböŋ adö iƚ i mɨd aij gɨnaböl, pen hainö umöm mɨnöŋ naböŋ adö iƚ i arö göm, God aip pör pör mɨdaiöl rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɨbi bɨ an yɨp nable gö, yad Jisas nɨp nɨŋagpin, a göm, manö yad nɨŋ udagnab u, hainö Bapi hol apɨl mailö aij ke u udem, ejol uɫ mailö aij halö gau aip aunabin ñɨn u, bɨ anɨbu nɨp nable gö, nɨŋagpin a gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pen kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ mɨñi mɨdpim gai i rɨmnap umagnabim; kamɨŋ nöp mɨdmim, God nɨbi bɨ udöm abad mɨdeinab ñɨn u nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas anɨg hagöm, ñɨn unbö raleb jɨŋ rö mɨdöm, Jon, Jems, Pida kalɨp uɫ göm, God nɨp sabe gɨnɨg göm yöp dum anɨb au ara. ");
INSERT INTO kpw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Amöm, God sabe gɨ mɨdö nɨŋöl gɨ, mulu adɨŋ nɨpe ke yabɨƚ löm, waƚɨj nɨpe rud yabɨƚ löm, mailö unbö ke yabɨƚ ga nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Anɨg gö nɨŋöl gɨ, bɨ hadame nöp umlö, Mosɨs aip, Ilaija aip, God mailö aij unbö ke magö u udmil apil, Jisas Jerusalem amöm umöm wög nɨpe gɨ haknɨg geia manö u hag mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pen Pida, Jems, Jon kalɨp yam hon auö, amgö ju ju göl gɨ mɨdeila, pen mɨdö kale amgö ñɨl nɨŋöm, Jisas mailö aij nɨpe u abe, bɨ anɨb mɨhau Jisas aip urak mɨdailö gau abe, nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bɨ anɨb mɨhau arnɨg gɨlö nɨŋöl gɨ, Pida gasɨ nɨŋ aij göm wasö, Jisas nɨp haga, “Bɨ Kub, hon aui mɨdpun u, aij yabɨƚ mɨdpun. Ne hanɨp yau a gö, ram bada yɨharɨŋ mɨhau nɨgaŋ, nöp ap, Mosɨs nɨp ap, Ilaija nɨp ap gun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Anɨg hagö nɨŋöl gɨ, magö anɨbu nöp, kumi rud kub ap apöm kalɨp magöŋhalö ralu ñö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pen manö ap kumi aŋ au nɨbö apöm haga, “Bɨ i Ñɨ yad; yad nɨp hag lɨnö. Kale manö nɨpe hagnɨm rö nɨŋmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Manö hag pɨs gö, magö anɨbu nöp nɨŋla, bɨ anɨb mɨhau mɨdagailö; Jisas nöp mɨdeia. Pen dum ilö laŋ mɨdöm, nan ga u nɨŋeila u, ñɨn aŋ anɨb au nɨbi bɨ rɨmnap kalɨp hag ñagla. ");
INSERT INTO kpw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pen ruö, dum ilö laŋ anɨbu arö göm, adan au gɨyaŋ ap luglö nɨŋöl gɨ, nɨbi bɨ iru nöp ap kalɨp nable pakla. ");
INSERT INTO kpw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bɨ ap nɨbi bɨ aŋ anɨbu wɨñ kub alöm haga, “Manö hag ñeb bɨ. Ñɨ yad añɨ i, ne mög nɨŋmön a gem dauabin. ");
INSERT INTO kpw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kɨjaki aiön pi pör nɨp abaŋ al mɨdöm nɨp gö, wɨñ kub yabɨƚ alöm gɨ dam paköm, kɨñu habkob gaɫ goɫ apöm, um dam aŋ löl gɨ auöp. Nɨp anɨg göm, pör pör nöp gö gö me, nɨpe ilön mab udöl gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bɨ ne gau kalɨp, kɨjaki mɨdöp anɨbu hag yuim, a gɨpin u pen kale hag yu wasö nɨŋöm arö gɨpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Anɨg hageia, Jisas haga, “Nɨbi bɨ mɨñi mɨdpim mɨnöŋ naböŋ iƚ i, ñɨn mai manö nɨŋ udnabimŋ Yad hadame nöp mɨŋör kale ud ajpin; pen hainö ñɨn aige gem mɨŋör kale ud arnam?” ö ga. Anɨg hagöm, bɨ anɨbu nɨp haga, “Ñɨ ne anɨbu söl aui dau,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jisas anɨg hageia, ñɨ anɨbu dap auö nɨŋöl gɨ, kɨjaki aiön pi ñɨ u nɨp kƚö yabɨƚ göm, pa jö gɨ yuö gɨ dam pɨɫab paka. Jisas pen kɨjaki aiön pi u nɨp hag gö, ke arö nɨŋöl gɨ, ñɨ anɨbu kamɨŋ lö, Jisas dam nap nɨp ña. ");
INSERT INTO kpw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɨbi bɨ ap mɨdeila gau, God kƚö nɨpe unbö ke anɨbu nɨŋöm, ñaul udla. Jisas nan nɨhön nɨhön ga u gasɨ nɨŋöm, kale ñaul udöm nɨŋmɨdlö nɨŋöl gɨ, Jisas bɨ nɨpe gau kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Manö hagnɨg gabin anɨbi, kale rɨmɨd lɨ nɨŋ aij yabɨƚ gɨmim mɨdaimim. Söl mɨdöp, Bɨ Ñɨ nɨpe nɨp mumug nɨŋöm, bɨ rɨmnap kalɨp ñɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pen manö haga anɨbu, kale rɨk nɨŋöl rö laga. Pen pɨñɨŋ göm Jisas nɨp hag nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas bɨ nɨpe anɨb gau kale ke hag amɨl apɨl göm, bɨ ap haga, “Yad bɨ kub mɨdeinam,” a ga. Pen bɨ ap pen haga, “Ne wasö, yad bɨ kub mɨdeinam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas bɨ nɨpe gau gasɨ nɨŋla anɨbu ke nɨŋöm, ñɨ pro ap dap nɨpe mɨdeia ba au löm haga, ");
INSERT INTO kpw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Nɨbi bɨ an yɨp gasɨ nɨŋöm, ñɨ pai pro inbö rö udnab u, yɨp abe udnab. Pen nɨbi bɨ an yɨp udnab u, Bɨ yɨp yuö aunö nɨp abe udnab. Pen bɨ an aŋ kale au bɨ yɨharɨŋ yabɨƚ rö mɨdöp, bɨ anɨbu nöp nɨpe bɨ kub yabɨƚ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas anɨg hageia, Jon haga, “Bɨ Kub, hon nɨŋbun, bɨ ap hib ne hagöm, kɨjaki aiön pi nan gau hag yua. Pen bɨ anɨbu hon aip ajagpun rö, ‘Ne anɨg gagmön,’ a gɨno,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hageia, Jisas haga, “Nɨhön gɨnɨg nɨp anɨg hag gɨpeŋ Nɨbi bɨ kalöp nɨŋlö mulu lugagnab gau, bɨ nɨŋeb hon a gɨmim nɨŋmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pen Nap nɨpe Jisas nɨp dam ram mɨnöŋ nɨpe kumi kabö adö laŋ ud arep ñɨn u söl ga nɨŋöm Jisas, Jerusalem arnam a göm, gasɨ kƚö gɨ nɨŋöm me ara. ");
INSERT INTO kpw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nɨpe bɨ nɨpe rɨmnap nöd hag yua. Kale amöm nan nɨp gɨ jɨn gɨnɨg, ram mɨnöŋ Sameria aŋ au ram rɨƚɨg agƚö ap arla. ");
INSERT INTO kpw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pen Sameria nɨbi bɨ ram rɨƚɨg agƚö anɨbu hanmɨdal gau, Jisas Jerusalem arnɨg geia manö u nɨŋöm, nɨp hag wɨhai udagla. ");
INSERT INTO kpw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Anɨg gailö, Jisas bɨ nɨpe Jems aip Jon aip nɨŋmil, Jisas nɨp haglö, “Bɨ Kub, kumi kabö adö laŋ nɨbö mab mɨɫaŋ haglo, apöm nɨbi bɨ anɨg gɨpal gau kalɨp innɨm aka?” gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Anɨg hagailö, Jisas ado göm kalɨp mɨhöŋ nɨŋöm, anɨg gagnabun a göm, kalɨp mɨhöŋ hag ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nɨbi bɨ anɨb gau Jisas nɨp udagnaböl u nɨŋöm, ram rɨƚɨg agƚö anɨbu arö göm, ram rɨƚɨg agƚö ke nɨbö ap arla. ");
INSERT INTO kpw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pen adan aŋ gau arlö nɨŋöl gɨ, bɨ ap apöm, Jisas nɨp haga, “Ram mɨnöŋ gai gai arnabön gau, yad aip ajeinabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Anɨg hageia, Jisas nɨp haga, “Yad aip uɫham ajeinabön. Kain hapeb gau ram haneb kale mɨnöŋ mɨgan gau mɨdöp; yaur gau rin kale u ke mɨdöp; pen Bɨ Ñɨ nɨpe, ka haneb nɨpe ap mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pen Jisas bɨ ap nɨp haga, “Ne yad aip ajaiul,” a ga. Anɨg hageia, bɨ anɨbu pen pe haga, “Bɨ Kub, yɨp yau a gö, yad am bap yad rɨgöl gem aunam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hageia, Jisas nɨp pen haga, “Nɨbi bɨ yɨp nɨŋ udagpal rɨmnap umaiöl, nɨbi bɨ yɨp nɨŋagpal rɨmnap dam rɨgöl göl. Ne pen ammön, God nɨbi bɨ udöm abad mɨdeinab manö u hag ñö araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pen bɨ ap haga, “Yad ne aip ajeinabul u pen yɨp yau a gö, am ami bapi, añ mam yad gau kalɨp manö hag ñɨ aij gem, ñɨmagö pakem, aunam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hageia, Jisas pen haga, “Nɨbi bɨ an wög adɨŋ iƚ göm, gasɨ iru nɨŋöm, nab au arö gɨnab gau, God nɨbi bɨ udöm abad mɨdeinab manö aij u hag ñeb bɨ wög u gɨnɨm rö lagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hainö Jisas bɨ nɨpe ñɨnjuöl mɨhau nɨgaŋ ado gɨ da mɨgan laŋ (72) udöm, kalɨp baluöm mɨhau ke, mɨhau ke, ram mɨnöŋ gau ke ke yunɨg göm haga, “Kale nöd ammim, manö yad u hag ñɨbe, yad hainö nɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pen kalɨp manö ap haga, “Nan wög kub yabɨƚ mɨdöp u pen nɨbi bɨ nan magö ral dauep gau iru mɨdagpal. Anɨb u, Bɨ Kub wög adɨŋ nap nɨbö u nɨp hag nɨŋbe, nɨbi bɨ nan magö ral dauep rɨmnap halö hagö, am ral dauöl. ");
INSERT INTO kpw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kale arim! Pen kalöp kaj sipsip pi rö kain hapeb mɨdpal aŋ au hag yuabin. ");
INSERT INTO kpw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kale mani rin, wadɨ, ma rɨrɨp gau halö ud aragmim. Nɨbi bɨ rɨmnap aip adan aŋ au manö hag mɨlö mɨdagaimim. ");
INSERT INTO kpw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pen ram ap amjakmim, ram raul mɨgan amöl gɨ, kalɨp manö aij hag ñɨmim hagmim, ‘God kalöp abad mɨdeiaŋ,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anɨg hageinabim, nɨbi bɨ God manö hain aij nɨpe udep rö ap mɨdeinab u, manö hain kale anɨbu udnab. Wasö u, manö hain hagnabim u kalöp ke ado gɨ aunab. ");
INSERT INTO kpw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pen ram anɨbu nöp mɨdaimim, nan magö dap ñɨnaböl u ñɨŋöl gɨ mɨdaimim. Bɨ wög gɨpal gau pen hajɨ udpal. Anɨbu rö, kalɨp manö aij u hag ñɨnabim rö, kale pen nan magö dap ñɨnaböl. Pen kale ram ram gagmim. ");
INSERT INTO kpw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pen daun ap araimim, kalöp hag wɨhai udöm, nan magö ñɨnaböl u, haƚöwaƚö ñɨŋmim. ");
INSERT INTO kpw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ram mɨnöŋ anɨbu, nɨbi bɨ nan gɨnɨm gau kalɨp gɨpe, kamɨŋ lɨnɨm. Nɨbi bɨ gau magöŋhalö kalɨp hag aij gɨmim hagmim, ‘God nɨbi bɨ udöm abad mɨdeinab u, ma iƚ kalöp u auöp,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pen daun ap araimim, kalöp hag wɨhai udagaiöl, adan aŋ au ammim hagmim, ");
INSERT INTO kpw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ram mɨnöŋ kalöp i auajun u, haƚpɨƚ acɨp acɨp ma hon udöp gau kale ke ƚɨk gɨ yu arabun. Pen nɨŋ aij gim! God nɨbi bɨ udöm abad mɨdeinab u, ma iƚ kalöp u auöp,’ a gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yad kalöp hagabin, hainö manö kub nɨŋnaböl ñɨn u, daun kub Sodom nɨbi bɨ nan si nan naij nöp gɨlö gɨlö in habɨk ñɨŋ ara u, manö kub nɨŋöm ilön pro rö udnaböl; pen nɨbi bɨ manö kale am hagpe udagnaböl gau, manö kub nɨŋöm ilön kub yabɨƚ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin nɨbi bɨ gau abe, Bedsaida nɨbi bɨ gau abe, nan gagep rö u gɨnö, nɨŋmim arö gɨpim rö, ilön kub yabɨƚ udnabim. Pen daun kub mɨhöp Daia Saidon nɨbi bɨ gau kalɨp, nan gagep anɨbu rö rɨmnap gɨnö nɨŋblap u, kale waƚɨj gɨ dö gɨ lugöp rɨmnap yɨmöm asɨköm, run he ud yuöl gɨ ud yuöl gɨ mɨdöm, nan naij gɨmɨdal anɨbu arö gɨblap. ");
INSERT INTO kpw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Manö kub nɨŋnaböl ñɨn u, Daia Saidon nɨbi bɨ gau ilön pro rö udnaböl; pen kale Korasin nɨbi bɨ gau abe, kale Bedsaida nɨbi bɨ gau abe ilön kub yabɨƚ udnabim. ");
INSERT INTO kpw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pen ñɨn anɨbu, kale Kapaneam nɨbi bɨ gau u rö nöp, kumi kabö adö laŋ au aragnabim; böŋ nöp uƚöm mɨgan kub yaŋ arnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas bɨ nɨpe gau kalɨp haga, “Nɨbi bɨ manö kale udnaböl gau, manö kalöp nöp wasö, manö yad u u rö nöp udnaböl. Pen kalöp udagnaböl gau, kalöp nöp wasö, yɨp u rö nöp udagnaböl. Pen yɨp udagnaböl gau, yɨp nöp wasö, Bɨ yɨp hag yuö aunö u nɨp u rö nöp udagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pen hainö bɨ nɨpe ñɨnjuöl mɨhau nɨgaŋ ado gɨ da mɨgan laŋ (72) anɨb gau, ram mɨnöŋ gau aj arö göm apöm, aij a göl gɨ Jisas nɨp hagla, “Bɨ Kub! Kɨjaki aiön pi nɨbi bɨ abaŋ albal gau, hib ne hagun, ‘Jisas mɨdöp rö arim!’ a gɨno, hagpun rö nɨŋöm arbal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hageila, Jisas kalɨp haga, “Yad nɨŋ mɨdnö nɨŋöl gɨ, kɨjaki aiön pi nap kale Seden, añɨm añɨm rö udöm kumi kabö adö laŋ nɨbö ap lug paka. ");
INSERT INTO kpw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kalöp hag lɨbin u me, re haiŋo sara, gaiwadö, hauaɫ, nan hapeb anɨb gau abe, Bɨ Koƚmaƚ kƚö nɨpe u abe, kalöp gɨ naij göl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pen kɨjaki aiön pi nan gau hagpun rö nɨŋöm höŋ arbal a gɨmim, mɨñ mɨñ gagmim; God nɨpe hib hon kumi kabö adö laŋ au kalɨ kƚiñ rɨköp, a gɨmim, mɨñ mɨñ gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Magö anɨbu, Ana Uɫ u Jisas nɨp ajmaŋ rau mɨdö nɨŋöl gɨ, nɨpe mɨñ mɨñ göl gɨ, Nap nɨpe nɨp haga, “Bapi, ne Bɨ Kub kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe abad mɨdpan u, gasɨ ne ke nɨŋö aij göp adö u nöp gɨpan. Hon nɨbi bɨ kub gasɨ nɨŋ kɨd hiɨkun ke nɨŋbun, a gɨpal gau, kalɨp manö aij iƚ u yamagpan pen ñɨ pai pro gau, ne kalɨp gasɨ aij ñö, manö aij iƚ u nɨŋbal u me, nöp aij a gabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas anɨg hagöm haga, “Nɨbi bɨ rɨmnap yad bɨ aigale bɨ rö mɨdpin u nɨŋagpal; Bapi nɨpe nöp yɨp nɨŋöb. Pen Bapi nɨpe bɨ aigale bɨ rö mɨdöp u, nɨbi bɨ rɨmnap nɨŋagpal; yad ke nöp nɨŋbin. Nɨpe yɨp pɨdöŋ nan nɨpe gau magöŋhalö ñöb rö, nɨbi bɨ kalɨp yamnam a gɨnabin gau nöp, Bapi kalɨp yamnö nɨp nɨŋnaböl. Nɨbi bɨ rɨmnap halö Bapi nɨp nɨŋagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas anɨg hagöm, ado göm, bɨ nɨpe gau nöp kalɨp hagöm haga, “Nan anɨbi nɨŋabim u, mɨñ mɨñ gɨmim. God kalöp nöp me ud aij yabɨƚ gö nɨŋabim. ");
INSERT INTO kpw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","God manö hagep bɨ gau iru nöp abe, kiŋ gau iru nöp abe, nan amgö nɨŋabim anɨbi nɨŋun a göm, abad mɨdmɨdal u pen kale nɨŋagla; manö apdi nɨŋabim anɨbi nɨŋun a göm, abad mɨdmɨdal u pen kale nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ñɨn ap aŋ au, bɨ lo manö hag ñeb bɨ ap, Jisas yɨp nɨhön manö hagnɨm a göm, apöm nɨp hag nɨŋöm haga, “Manö hag ñeb bɨ, yad nɨhön nɨhön gem, pör mɨdep magö u udnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hageia, Jisas nɨp haga, “Lo manö u kalɨ kƚiñ rɨköm, nɨhön hagla?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hageia, bɨ lo manö hag ñeb bɨ anɨbu haga, “Lo manö u nɨŋbin, Mosɨs kalɨ kƚiñ rɨköm haga, ‘God Bɨ Kub ne u nɨp mɨñ mɨñ gɨmön, gasɨ rɨmɨd ne u nɨp ñɨmön, kƚö ne u magöŋhalö nɨp ñɨmön, nɨp mɨdmagö yabɨƚ lɨmön. Ne ke mɨdmagö lɨban rö, nɨbi bɨ rɨmnap kalɨp u rö nöp mɨdmagö lɨmön,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Anɨg hageia, Jisas bɨ anɨbu nɨp haga, “Ne kabö göl hagpan; adö anɨbu nöp hain gɨmön, pör mɨdep magö u udnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas anɨg hageia, bɨ lo manö hag ñeb bɨ anɨbu, hib yad u pro gɨnab a göm, Jisas nɨp kauyaŋ hag nɨŋöm haga, “Lo manö kalɨ kƚiñ rɨka u, nɨbi bɨ rɨmnap kalɨp mɨdmagö lɨmim a göm, kalɨ kƚiñ rɨka. Anɨb u, nɨbi bɨ mai kalɨp mɨdmagö lɨmim a göm, kalɨ kƚiñ rɨka?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hageia, Jisas bɨ lo manö hag ñeb bɨ anɨbu nɨp, manö pen hagöl gɨ, aiud udöm haga, “Bɨ ap Jerusalem arö göm, daun kub Jeriko amnam a göm, adan aŋ au araia nɨŋöm, bɨ nan si udep rɨmnap apöm, nɨp mɨñu magö paköm, waƚɨj nan nɨpe gau pɨƚɨ gɨ ud arlö nɨŋöl gɨ, nɨpe adan aŋ au umnɨg göm gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɨ God nɨp nan sabe gep bɨ ap, adan adö anɨbu amöm bɨ anɨbu umnɨg göm gɨ mɨdeia au nɨŋöm, böŋ lau nöp adan löm ara. ");
INSERT INTO kpw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pen bɨ Lipai iƚ bɨ ap, adan adö anɨbu nöp amöm, bɨ anɨbu umnɨg göm gɨ mɨdeia au nɨŋöm, mɨdeia söl au amöm nɨŋ aij göm, böŋ lau nöp adan löm ara. ");
INSERT INTO kpw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pen bɨ Juda wasö, ram mɨnöŋ Sameria nɨbö bɨ ap, adan mɨlö añɨ anɨbu nöp amöm, bɨ anɨbu umnɨg göm gɨ mɨdeia au nɨŋöm, nɨp mög yabɨƚ nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nɨp mög yabɨƚ nɨŋöm, mɨdeia söl au amöm, wös nɨp gau wel rɨmnap löm, ñɨg wain rɨmnap löm, wös nɨp gau wama. Wös wamöm, ud donki adö nɨpe u löm, ram mani rauöm hanmɨdal u dam löm, abad mɨd aij yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ruö arnɨg göm, bɨ ram abad mɨdmɨdöp anɨbu nɨp silpa kɨd mɨhöp ñöm haga, ‘Ne bɨ anɨbi nɨp abad mɨd aij gɨmön. Pen mani aigeg hagnabön u, ado gɨ apem nöp ñɨnabin,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas aiud anɨbu udöm, nɨpe bɨ lo manö hag ñeb bɨ anɨbu nɨp hag nɨŋa, “Bɨ adan aŋ pak lɨla u, bɨ mɨhau nɨgaŋ padiöl göm arla gau, bɨ an nɨpe ke mɨdmagö la rö, nɨp mɨdmagö la?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hageia, bɨ lo manö hag ñeb bɨ u haga, “Bɨ nɨp mög nɨŋöm gɨ aij ga u,” a ga. Hageia, Jisas nɨp haga, “Nɨŋö nöp hagpan. Me ne arammön, adö anɨbu nöp gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pen Jisas bɨ nɨpe gau aip ram mɨnöŋ ap amjakeila, nɨbi ram mɨnöŋ anɨbu mɨdeia ap apöm, kalɨp uɫ gɨ dam ram nɨpe u ara. Nɨbi anɨbu hib nɨpe Mada. ");
INSERT INTO kpw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ram nɨpe u nɨñɨn ap mɨdeia. Hib nɨpe u Maria. Maria nɨpe Jisas mɨdeia söl au ap asɨköm, Jisas manö hageia u nɨŋmɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mada nɨpe ke nöp nan magö lauöm, gasɨ iru nɨŋöm, ap Jisas nɨp haga, “Bɨ Kub, Maria yɨp arö gö, yad ke nöp nan magö hon lauabin u aij gagöp. Nɨp hagö apöm yad aip nan magö lauul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hageia, Jisas haga, “Mada, Mada, ne nan iru nöp gasɨ iru nɨŋban u aij wasö. ");
INSERT INTO kpw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria manö aij yad nɨŋnam a göm, gasɨ añɨ u nöp nɨŋöm, ap manö yad nɨŋmɨdöp. Nɨbi bɨ ap nan aij udöp anɨbu pɨƚɨ gɨ udnɨm rö lagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñɨn ap, Jisas ram mɨnöŋ ke mɨgan ap mɨdöm, Nap God nɨp sabe göl gɨ mɨdeia. Sabe gɨ pɨs gö nɨŋöl gɨ, bɨ nɨpe ap apöm nɨp haga, “Bɨ Kub, God nɨp aigöl gun sabe gun? Jon bɨ nɨpe gau kalɨp hag ñö nɨŋbal rö, ne hanɨp u rö nöp hag ñö nɨŋun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hageia, Jisas kalɨp haga, “God nɨp sabe gɨnɨg gɨmim, anɨgöl hagmim, ‘Bapi, nɨbi bɨ gau hib ne haglö adö araŋ. Ne nɨbi bɨ udmön abad mɨdeinabön ñɨn u yɨŋɨd aunɨm. ");
INSERT INTO kpw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nan magö hanɨp ñɨn añɨ añɨ pör pör ñɨban rö u ñɨmön. ");
INSERT INTO kpw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nɨbi bɨ rɨmnap hanɨp gɨ naij gɨlö, kalɨp pen nɨŋno mulu lugö gɨ naij gagpun rö, hon nan si nan naij gɨpun gau nɨŋmön arö gɨmön. Hanɨp abad mɨdaimön, gasɨ ap wakainɨm, gɨ naij gagun,’ a gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jisas manö anɨbu hagöm, bɨ nɨpe gau kalɨp manö hod rɨköm haga, “Kale bɨ ap, sɨbön aŋ kub yaŋ, bɨ nɨŋeb nɨpe ram amöm hagnab, ‘Mɨdaimam, bɨ nɨŋeb yad ap mɨlö gau nɨbö apöm ram yad u apjakajɨp. Pen nan nɨp ñɨnö ñɨŋnɨm u mɨdagöp u me, nöp auabin. Yɨp bred magö mɨhau nɨgaŋ ñɨ,’ a gɨnab. Hageinab, bɨ nɨŋeb nɨpe anɨbu manö pen hagnab, ");
INSERT INTO kpw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Sɨbön aŋ kub i yɨp ap unbö hagagmön! Yad ñɨ pai yad gau aip ajöŋ gɨñun hanabun. Anɨb u, yad aigöl gem urakem, nöp nan hagabön anɨb gau ud ñɨnam?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pen kalöp hagabin, bɨ ram nap nɨbö u, bɨ nɨŋeb yad a göm yɨŋɨd ud ñagnab, jɨ nɨp ñɨ a göm abad mɨdöl gɨ, kƚö gɨ mɨdö mɨdö, hagnab rö ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Anɨb u, kalöp hagabin, nan nɨhön mɨdagainɨm, God nɨp hag nɨŋbe, kalöp ñɨnab. Nan nɨhön uƚhai nɨŋnabim u, udnabim. Hanɨp ajöŋ u hiɨkaŋ a gɨmim, pak gu gu gɨpe, hiɨknab. ");
INSERT INTO kpw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nɨhön gɨnɨg: nɨbi bɨ God nɨp hag nɨŋnaböl gau, udnaböl. Nɨbi bɨ nan uƚhai nɨŋnaböl gau, udnaböl. Nɨbi bɨ hanɨp ajöŋ hiɨkaŋ a göm, pak gu gu gɨlö, kalɨp ajöŋ hiɨknab. ");
INSERT INTO kpw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kale ñɨ pai nap gau, ñɨ kale ap kabsaƚ nan a geinab, re ap ñɨnabön aka? ");
INSERT INTO kpw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aka jɨ, yaur magö nan a geinab, hauaɫ ap ñɨnabön akaŋ U rö nöp anɨg gagnabön. ");
INSERT INTO kpw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kale nɨbi bɨ aij wasö u pen ñɨ pai kale gau nan aij gau nöp ñɨnabim. Bapi kumi kabö adö laŋ au mɨdöp u Bɨ aij yabɨƚ. Nɨpe nan naij ap ñagnab. Ana Uɫ u hanɨp ñɨmön a geinabim u, Bapi kalöp ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pen bɨ ap nɨp kɨjaki abaŋ alö, manö hagöm wasö, yɨharɨŋ nöp mɨdeia. Jisas kɨjaki anɨbu hag yuö, bɨ abaŋ almɨdeia u manö hagö nɨŋöl gɨ, nɨbi bɨ nɨŋmɨdeila gau aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pen nɨbi bɨ anɨb gau rɨmnap hagla, “Nɨpe kɨjaki aiön pi nap kale Bielsebul kƚö nɨpe u udöm, kɨjaki aiön pi gau hag yuab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pen nɨbi bɨ anɨb gau rɨmnap, Jisas nɨhön gɨnab a göm, hagla, “Nan nɨŋagep ap ke kumi kabö adö aulɨk gö nɨŋun me, God nöp hag yuö auna u, nɨŋnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pen Jisas gasɨ piral kale ke nɨŋla u ke nɨŋöm haga, “Ram mɨnöŋ kub añɨ ap, ud asɨk ke ke löm, nɨbi bɨ kale ke aip pen pen geinaböl u, ram mɨnöŋ anɨbu lug paknab. Nɨbi bɨ iƚ añɨ ap, u rö nöp ud asɨk ke ke löm, nɨbi bɨ kale ke aip pen pen aleinaböl u, nɨbi bɨ iƚ añɨ anɨbu lug paknab. ");
INSERT INTO kpw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anɨb unbö rö nöp, Seden iƚ u ud asɨk ke ke leinab u, aigegö göm mɨd aij gɨnɨmŋ Pen kale yɨp hagpim, ‘Bielsebul kƚö u udöm, kɨjaki aiön pi hag yuö höŋ araböl,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anɨg hagpim u, yam kale ke gau kɨjaki aiön pi gau aigegö göm hag höŋ yubalŋ Yam kale ke hagnaböl, nɨbi bɨ anɨg göl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pen yad God kƚö nɨpe udem, kɨjaki aiön pi nan gau hag höŋ yubin rö, kale nɨŋnabim, God nɨbi bɨ udöm abad mɨdep ñɨn u hanɨp hadö auöp i, a gɨmim nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pen bɨ kƚö ap, wim po nɨpe lɨ aij göm, ram nɨpe u nɨŋ mɨdeinab, nɨbi bɨ rɨmnap nan nɨpe ap pɨƚɨ gɨ udöl rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pen bɨ kƚö yabɨƚ ap ke apöm, nɨp aip pen pen göm pakeinab u, wim po ram au lɨ aij ga u halö pɨƚɨ gɨ udöm, nan si udnab gau dam nɨme lɨ ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nɨbi bɨ yɨp pɨg mɨdagpal gau, wög yad gɨpin u rɨb waƚ gɨpal. Nɨbi bɨ kale nɨbi bɨ rɨmnap yɨp dauageinaböl gau, nɨbi bɨ yɨp aunɨg gaböl gau kalɨp rɨdɨk dam yubal. ");
INSERT INTO kpw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kɨjaki aiön pi ap, nɨbi bɨ abaŋ lɨ mɨdö, hag höŋ yuö arnab u, am ram mɨnöŋ nöp aŋ gau aramöm, ka ap uƚhai nɨŋem mɨdeinam, a göm, am aŋ anɨb gau aj aj wasö nɨŋöm, ‘Ram raul mɨgan nöd mɨdem aubin u arnam,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hagöm, amöm nɨŋnab, ram anɨbu ƚɨk gɨ aij gɨ, kuö aij nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nɨpe nɨŋöm gau amöm, nɨpe rö wasö, kɨjaki aiön pi naij yabɨƚ unbö mudun jɨŋ u halö uɫ gɨ dapöm, mɨgan anɨbu am mɨdeinaböl. Anɨg gö, bɨ anɨbu nöd aij pro rö mɨdmɨdöp rö wasö; uri nɨpe böŋ nöp naij yabɨƚ mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas manö anɨbu hagö, nɨbi bɨ iru mɨdeila aŋ anɨb au nɨbi ap uraköm, wɨñ al hagöm haga, “Name nöp yag dap ci ña u, mɨñ mɨñ yabɨƚ gɨnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hageia, Jisas pen pe haga, “Anɨg hagpan u pen nɨbi bɨ an an God Manö u nɨŋöm hagöp rö gɨnaböl gau, kale mɨñ mɨñ gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pen nɨbi bɨ iru yabɨƚ nöp ap magum gɨlö nɨŋöl gɨ, Jisas kalɨp haga, “Nɨbi bɨ mɨñi mɨdpim aŋ aui, nan si nan naij göl gɨ mɨdmim hagpim, ‘Nan gagep rö ap kumi kabö adö laŋ gö nɨŋun,’ a gɨpim. Pen yad kalöp hagabin, nan ap ke gɨnö nɨŋagnabim. Bɨ God manö hagep Jona nɨp ga adö u nöp yɨp gö, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Daun kub Ninepa nɨbi bɨ gau, God manö hagep bɨ Jona apöm ga rö nɨŋöm God nɨp nɨŋ udla rö, nɨbi bɨ uri mɨdpim gau, yad Bɨ Ñɨ nɨpe gɨnabin rö nɨŋmim, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pen hadame nöp nɨbi kwin ram mɨnöŋ mɨlö mɨdeia gau nɨbö apöm, Kiŋ Solomon manö aij hagab u nɨŋɨn a göm aua. Pen kale nɨbi bɨ mɨñi mɨdpim gau, bɨ kub Solomon rö wasö, yad Bɨ Kub yabɨƚ apem aŋ kalöp aui mɨdem, kalöp manö aij yabɨƚ hag ñɨnö udagpim. Anɨb u, manö kub hagep ñɨn u, kwin anɨbu uraköm kalöp nɨbi bɨ mɨñi mɨdpim gau manö kub hagnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hadame nöp Jona am Ninepa nɨbi bɨ gau kalɨp hagö, nan si nan naij gɨmɨdal gau, nɨhön gɨnɨg anɨg gɨpun a göm arö göm, God nɨp nɨŋ udla. Jona nɨpe hagö nɨŋ udla u pen mɨñi yad Bɨ Kub yabɨƚ apem aŋ kalöp aui mɨdem, manö aij yabɨƚ hag ñɨnö, nan si nan naij gɨpim gau arö gagpim. Anɨb u, manö kub hagep ñɨn u, Jona nɨpe uraköm kalöp nɨbi bɨ mɨñi mɨdpim gau manö kub hagnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nɨbi bɨ gau hapö lauöm rin cög mɨgan gau pi gagnaböl; adö au gɨlaŋ rɨk lɨlö mailö gö, nɨbi bɨ gau ram raul mɨgan anɨbu apöm waiö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pen amgö magö u hapö mailö rö mɨdöp. Amgö magö u mɨd aij gɨnab u, hañ romaŋ aŋ daŋ mailö göm mɨd aij gɨnab, pen amgö magö mɨd aij gagnab u, hañ romaŋ aŋ daŋ sɨb göp u rö mɨdnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kale nɨŋ aij gɨmim, aŋ kalöp daŋ mailö mɨdöp aka sɨbön mɨdöpŋ Kale gasɨ nɨŋbim, aŋ hon daŋ mailö mɨdöp a gɨ gasɨ nɨŋbim u pen sɨbön aunɨm rö löp rö, kale ke nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hañ romaŋ kale aŋ daŋ magöŋhalö mailö gɨ mɨdöl gɨ, mɨgan pro marap sɨbön mɨdageinab u, hapö mailö gö kalöp mailö pak ñɨnab unbö rö lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pen Jisas manö hag juö nɨŋöl gɨ, bɨ Perisi ap nɨp haga, “Auö ram yad amul nan ñɨŋul,” a ga. Hageia, Jisas ram nɨpe amöm, raul mɨgan yaŋ nan ñɨŋnɨg asɨka. ");
INSERT INTO kpw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Asɨköm, nan ñɨŋö nɨŋöl gɨ, bɨ Perisi anɨbu, gasɨ nɨpe ke aŋ gau nöp nɨŋöm, bɨ anɨbi nɨhön gɨnɨg hon Juda kai pör gɨpun rö, ñɨmagö nɨpe u ñɨg lɨ yuöm wasö, yɨharɨŋ nöp nan ñɨŋab a göm, gasɨ u nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisas gasɨ nɨŋa anɨbu ke nɨŋöm nɨp haga, “Kale Perisi kai, pler kap gau höŋ adö gau ñɨg pak aij gɨpal rö u gɨpim u pen aŋ kale yaŋ nan si nan naij gɨpim prɨ u ajmaŋ rauöm mɨdöp. Kale nɨbi bɨ nan aij kale gau udun a gɨmim, gɨ naij yabɨƚ nöp gɨmɨdim. ");
INSERT INTO kpw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kale hauƚ halö yabɨƚ. God kalöp hañ u nöp gɨ laga; aŋ yaŋ abe gɨ la. ");
INSERT INTO kpw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Anɨb u, nan pler kap mɨgan yaŋ mɨdöp u, nɨbi bɨ mög gep rö gau kalɨp ñɨmim. Anɨg gɨnabim u, nan kale magöŋhalö uɫ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pen kale Perisi kai, nɨŋ aij yabɨƚ gɨmim: kale marö kub yabɨƚ udnabim. Kamöŋ, dil, nan yɨharɨŋ haƚɨŋ aij auep wög adɨŋ ranab gau nɨŋbe, nan kub rö lö, wö ral nɨŋ dammim, sɨduŋ laŋ arö, nɨme lun God nɨp añɨ ap ñun a gɨmim, pör nɨŋbim. Nan pro pro gau pör anɨg gɨmim gɨpim u aij, pen nɨhön gɨnɨg manö iƚ yabɨƚ u nɨŋmim hain gagpimŋ Nɨbi bɨ gau kalɨp kabö rö gɨnɨm adö u gagpim; kalɨp naij gɨnɨm adö u nöp gɨpim. God nɨp mɨdmagö lagpim. Anɨg gɨmim, gɨ naij gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pen kale Perisi kai, nɨŋ aij yabɨƚ gɨmim: kale marö kub yabɨƚ udnabim. Kale Juda magum gep ram gau ammim, bɨ kub mab po asɨkpal adö u nöp asɨkpim. Gasɨ kale nɨŋbim u, nɨbi bɨ iru mɨdpal aŋ gau arno, ‘Manö hag ñeb bɨ auabön e!’ gɨlö, hanɨp aij gɨnab a gɨmim, nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pen kale Perisi kai, nɨŋ aij yabɨƚ gɨmim: kale marö kub yabɨƚ udnabim. Nɨbi bɨ rɨmnap nɨŋöm, kalöp bɨ aij yabɨƚ a gɨpal u pen wip rɨgöl gɨpal hij naij mɨdöp mɨgan gau nɨbi bɨ nɨŋagöm adö laŋ ajpal rö mɨdpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas anɨg hagö, lo manö hag ñeb bɨ ap nɨp haga, “Manö hag ñeb bɨ, manö kƚö yabɨƚ lɨ hagpan anɨbu, hanɨp u rö nöp hag juban,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hageia, Jisas haga, “Pen kale lo manö hag ñeb bɨ gau, nɨŋ aij yabɨƚ gɨmim. Kale marö kub yabɨƚ udnabim. Manö kƚiñ aij hagpim u, wadɨ marö kub gau rö, nɨbi bɨ gau kalɨp gam ñɨbim u pen kalɨp mög nɨŋmim hag rau udagpim. ");
INSERT INTO kpw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pen kale lo manö hag ñeb bɨ gau, nɨŋ aij yabɨƚ gɨmim. Kale marö kub yabɨƚ udnabim. Nahai iƚaŋ kale gau hadame nöp bɨ God manö hagep bɨ gau kalɨp al pak lɨla. Pen kale God manö hagep bɨ gau wip rɨgöl kale gɨ lɨbim. ");
INSERT INTO kpw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gɨpim anɨbu, aij nöp pakla a gɨmim gɨpim. Nahai iƚaŋ God manö hagep bɨ gau al pak lɨla; kale pen wip rɨgöl kalɨp gɨ lɨbim. ");
INSERT INTO kpw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anɨb u, God gasɨ aij ke nɨŋöb u haga, ‘Bɨ manö yad hagep gau, bɨ manö aij yad ud arep gau kalɨp yunabin, pen kalɨp jɨ nɨŋöm, rɨmnap gɨ naij göm, rɨmnap böŋ nöp al pak lɨnaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pen hadame nöp, God mɨnöŋ naböŋ iƚ i gɨ lɨnɨg ga ñɨn u rɨköm, bɨ God manö hagep gau kalɨp pör paklö auöp rö, nɨbi bɨ mɨñi mɨdpim gai i, nan naböŋ anɨbu pen udnabim. ");
INSERT INTO kpw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Marö anɨbu me, bɨ Ebol nɨp nöd iƚ göm al paköm, al pak dapöm, al pak dapöm, hainö Sekaraia nɨp, ka nan sabe gɨ ñeb ram raul mɨgan u lödaŋ, kabö kaƚum ud gɨla bɨd adö au i, aŋ au al pak lɨla. Kalöp nɨŋö yabɨƚ hagabin, manö marö anɨbu magöŋhalö, nɨbi bɨ mɨñi mɨdpim gau udnabim. ");
INSERT INTO kpw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pen kale lo manö hag ñeb bɨ gau, nɨŋ aij yabɨƚ gɨmim. Kale marö kub yabɨƚ udnabim. Manö aij u, gasɨ aij nɨŋeb ram raul mɨgan ajöŋ ki u kale udmim, gau pi gɨpim. Gau pi gɨpim u, nɨbi bɨ ram raul mɨgan am nɨŋun a göm gasɨ nɨŋbal gau, kalɨp pör adan magrem hag rɨkpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas kalɨp anɨg hagöm höŋ arö nɨŋöl gɨ, lo manö hag ñeb bɨ gau abe, bɨ Perisi gau abe nɨp jɨ nɨŋöl hagla, “Manö nɨhön u hagno, pen hagö nɨŋun, nɨp dam manö kub hagun,” a göm, Jisas nɨp manö piral piral adö rɨmnap haglö ara. ");
INSERT INTO kpw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pen ñɨn ap, nɨbi bɨ iru yabɨƚ nöp ap magum göm, pen pen cɨro cɨro ñöm nɨbi bɨ rɨmnap ma abö jö ma jö gɨlö nɨŋöl gɨ, Jisas bɨ nɨpe gau kalɨp haga, “Perisi kai pör gɨ naij gɨpal u pi göm, mɨd aij gɨpun, a gɨ gasɨ nɨŋbal. Kale anɨb unbö rö gɨmim rö löp u, kale yɨs kale u nɨŋ aij yabɨƚ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nan pi gɨmim gɨpim gau, hainö waiö lö nɨŋnaböl. Manö agamɨj hag pi gɨpim gau, u rö nöp waiö lö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pen manö sɨbön yaŋ hagpim u, mailö halö haglö nɨŋnaböl. Manö agamɨj raul mɨgan yaŋ hagpim u, meg magö dap ranöm ram adö laŋ haglö, yag dam ram mɨnöŋ gau ud arnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nɨbi bɨ yad gai i, kalöp hagabin, God nɨp cɨg gɨno, hanɨp al paknaböl a gɨmim, pɨñɨŋ gagmim. U yɨharɨŋ hañ romaŋ adö u nöp gɨ naij gɨlö, hij gɨnab. Hainö kale nan ap kalöp göl rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anɨb u, yad kalöp hagabin, kale pɨñɨŋ gɨnɨg, Bɨ kalöp hañ romaŋ al pak löm, hainö kalöp mab ke inab mɨgan yaŋ ud yunɨm rö löp, Bɨ anɨbu nöp pɨñɨŋ gɨmim. Nɨpe nöp Bɨ pɨñɨŋ gep me; nɨp nöp pɨñɨŋ gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kale nɨŋbim, nɨbi bɨ yaur pro unbö mamɨd u sɨkim göm, mani aɫɨ pro mɨhöp nöp udpal. Yaur pro anɨb gau, God añɨ ap nɨŋagnɨm rö lagöp; magöŋhalö nɨŋöb u nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pen kale nɨbi bɨ gau nan yabɨƚ; yaur gau kale aip adɨp adɨp rö wasö. God nabɨc cög umagö kale u magöŋhalö wö ralöp u me, kale pɨñɨŋ gagmim, gasɨ halö mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kalöp manö nɨŋö hagabin, nɨbi bɨ Jisas lau adö mɨdpun a göm, nɨbi bɨ mɨdpal aŋ au waiö hag hiɨkeinaböl gau, yad kalɨp pen abe nɨbi bɨ gai i yɨp lau adö mɨdpal a gem, God ejol nɨpe mɨdpal aŋ au waiö hag hiɨknabin. ");
INSERT INTO kpw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pen nɨbi bɨ Jisas lau adö mɨdagpun a göm, nɨbi bɨ mɨdpal aŋ au waiö hageinaböl u, yad kalɨp pen abe nɨbi bɨ gai i yɨp lau adö mɨdagpal a gem, God ejol nɨpe mɨdpal aŋ au waiö hagnabin. ");
INSERT INTO kpw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bɨ Ñɨ nɨpe nɨp hag jueinaböl u, God nɨŋöm arö gɨnɨg arö gɨnab; pen Ana Uɫ u nɨp hag jueinaböl u, God nɨpe nɨŋöm arö gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pen kalöp manö kub hagnɨg göm, ud Juda magum gep ram au, aka gapman bɨ kub mɨdpal aŋ au, aka kiŋ mɨdpal aŋ au, daueinaböl u, pen manö nɨhön u udun hagun a gɨmim, gasɨ iru nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Urak hagpe nɨŋöl gɨ, magö anɨbu nöp Ana Uɫ nɨpe kalöp gasɨ ñö nɨŋöl gɨ, nɨŋmim hagnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nɨbi bɨ iru mɨdeila aŋ anɨb au, bɨ ap Jisas nɨp haga, “Manö hag ñeb bɨ, ne mam yad u nɨp hagö, bapi nan nɨpe ud löm uma gau, nɨme lɨ yɨp böŋ lau ke ñaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hageia, Jisas nɨp pen haga, “Yɨp an hagöp, ‘Bɨ nan ud asɨk ñeb u mɨdaimön,’ a ga nɨŋem nan kalöp gau ud nɨme lɨ ñɨnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jisas anɨg hagöm, nɨbi bɨ mɨdeila gau kalɨp haga, “Nɨŋ aij yabɨƚ gɨmim. Nan iru nöp udun a gɨmim, gasɨ u nɨŋagmim. Nan iru udun a gɨmim, gasɨ nɨŋnabim u, mɨd aij gɨmim rö lagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pen Jisas manö ap kalɨp manö hod rɨköm haga, “Bɨ mani iru mɨdeinab ap, wög adɨŋ nɨpe u, wid magö nan gau iru yabɨƚ nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gasɨ nɨpe gau nöp ke nɨŋ damöm, ‘Nan ñɨŋeb yad iru nöp mɨdöp gau, ram raul mɨgan mai dap lem, ñɨŋ mɨdeinam?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pen gasɨ ap nɨŋöm, ‘Ram pro gau rɨb waƚ gɨ yuem, ram kub kub gau nöp gɨ lem, wid magö yad abe, nan yad gau abe magöŋhalö ud ram raul mɨgan anɨb gau dam lɨnabin. ");
INSERT INTO kpw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yad anɨg gem, yɨp ke hagnabin, “Bɨ me. Ne nan aij iru yabɨƚ mɨdöp u mɨ iru yabɨƚ nöp mɨdöm pɨs gagnab. Anɨb u, wög ne u arö gɨmön, nan ne anɨb gau nöp ñɨŋöl gɨ, ñɨg ñɨŋöl gɨ, mɨñ mɨñ göl gɨ, gɨ mɨdaimön,” a gɨnabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anɨg hagöm gasɨ nɨŋnab, pen God nɨp hagnab, ‘Ne bɨ hauƚ halö yabɨƚ! Mɨñi sɨb aŋ yaŋ nöp umnabön. Nan ne iru nöp gɨ jɨn gɨ lö mɨdöp anɨb gau, an rö ud ñɨŋ mɨdeinab?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Anɨbu rö me, nɨbi bɨ nan aij gau iru nöp ud magum göm mɨñ mɨñ gɨpal u, pen God amgö ilö nɨpe au kale nɨbi bɨ mög gep rö mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas anɨg hagöm, bɨ nɨpe gau kalɨp haga, “Anɨb u, ‘Nan magö gai nɨbö udun ñɨŋ mɨdaiun, waƚɨj gai nɨbö udun yɨm mɨdaiun,’ a gɨmim, gasɨ kub u nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nan ñɨŋeb u nan kub wasö. Kamɨŋ mɨdep magö u nan yabɨƚ. Waƚɨj nan gau nan kub wasö. Hañ romaŋ u nan yabɨƚ. ");
INSERT INTO kpw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yaur mɨdpal gau nɨŋim. Yaur gau, nɨbi bɨ gɨpal rö, wid wög gɨ yɨmlö, po gö rɨk dauagpal. Wid magö rɨk dap magum gep ram kale ap mɨdagöp. God nöp me nan ñɨŋeb kalɨp ñöb. Nɨpe nan pro gau gasɨ nɨŋöm anɨg göp u, kale nɨhön gɨnɨg hanɨp nɨbi bɨ abad mɨdageinab a gɨmim, gasɨ iru nɨŋbimŋ Yaur gau nan pro; kale nan pro wasö. ");
INSERT INTO kpw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pen kale gasɨ iru nɨŋeinabim u, umnɨg gɨnabim ñɨn u arö gɨmim, magö ap halö mɨdeinabim aka? ");
INSERT INTO kpw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","U nan pro, pen kale ke nan pro anɨbu gɨmim rö lagöp. Anɨb u, kale nɨhön gɨnɨg nan yɨharɨŋ adö rɨmnap gasɨ iru nɨŋbim? ");
INSERT INTO kpw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nan be gau ranöm, magö pɨlöm pɨpɨƚ yuöp u pen ke waƚɨj göm rɨb adɨk gɨnɨm rö lagöp. God nöp gö, rɨb adɨk aij yabɨƚ gɨmɨdöp. Pen Kiŋ Solomon rɨb adɨk aij yabɨƚ gɨmɨdöp u, gausɨƚ gau rɨb adɨk aij gɨmɨdöp u rö gagmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nan be gau ranöb anɨb gau nan yɨharɨŋ; pör mɨdageinab. Mɨñi rö mɨdöm, rol ruö rɨb gɨ dö gɨ mab laulö innab. God nɨpe nan yɨharɨŋ gau gasɨ nɨŋöm anɨg göp u, kale nɨhön gɨnɨg hanɨp waƚɨj ñagnab a gɨmim, gasɨ iru nɨŋbimŋ Nɨŋ udep magö kale u mɨlö mɨdagöp. ");
INSERT INTO kpw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hon nan magö, ñɨg, nan gau gai nɨbö udun ñɨŋun a gɨmim, gasɨ marö u nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nɨbi bɨ God nɨp nɨŋagpal gau, gasɨ anɨbu rö nɨŋbal. Pen Nap kale u kalöp hauƚ gagöp; nan kalöp mɨdagöp gau nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Anɨb u pen, God nɨbi bɨ udöm abad mɨdeinab u, hanɨp halö udnɨm a gɨmim, gasɨ añɨ nɨŋmim gɨpe arö me, kalöp abad mɨdöl gɨ, nan anɨb gau kalöp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaj sipsip bad pro yad gai i, Nap kale u, kalöp udem abad mɨdeinabin a göm nɨŋöb u me, kale pɨñɨŋ gagmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nan kale mɨdöp rö gau, sɨkim gɨ mani udmim, nɨbi bɨ nan mɨdagöp gau kalɨp ñɨmim. Anɨg gɨnabim u, mani rin kale papɨƚ gagöm pör pör nöp mɨdeinab; nan aij aij kale kumi kabö adö laŋ au mɨdöm ur gagnab; bɨ si udep apöm si udagnab; sɨpsop nan gau ñɨŋagnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pen nan aij kale gau mɨnöŋ naböŋ adö iƚ i ud magum geinabim u, hibur gasɨ mɨdmagö kale u u rö nöp mɨnöŋ naböŋ adö iƚ i mɨdeinab. Pen nan aij kale kumi kabö adö laŋ au ud magum geinabim u, hibur gasɨ mɨdmagö kale u u rö nöp anɨb laŋ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Anɨb u, waƚɨj kale u söl söl pa jö gɨmim, dip nagɨ pɨg lɨ aij gɨmim, hapö lau lɨmim nɨŋöl gɨ mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bɨ wög gɨ ñeb gau hagnaböl, ‘Bɨ kub hon u, bɨ nɨŋeb nɨpe nɨbi udöm aip nan kub ñɨŋ mɨdlö nɨŋöl gɨ, söl ado gɨ aunab,’ a göm, nɨŋ nöp mɨdeinaböl. Bɨ kub kale u ado gɨ apöm, ajöŋ pak gu gu gö, yɨŋɨd hiɨknaböl. Anɨb unbö rö kale anɨg gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pen nɨpe ado gɨ apöm, kale nɨŋ mɨdeinaböl u nɨŋöm, kalɨp ud aij yabɨƚ gɨnab. Bɨ kub anɨbu nɨpe ke, waƚɨj nɨpe u söl söl pa jö göm, dip nagɨ pɨg lɨ aij göm, kalɨp hagö, ap nan ñɨŋeb lɨ ñɨŋbal ka u asɨk gɨgabö gɨlö, nɨpe ke nan ñɨŋeb gau dam kalɨp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pen bɨ kub sɨbön aŋ kub yaŋ aka kɨƚakɨƚ hagnab magö u apöm nɨŋnab, bɨ nɨpe gau uhön hanageinaböl, kalɨp ud aij yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anɨb u, nɨŋim. Nɨbi bɨ ram nap nɨbö gau, bɨ nan si udep bɨ aunab ñɨn u a göm, nɨŋ mɨdaiblap u, ram kalɨp pɨlaköm, nan kale gau si udagböp. ");
INSERT INTO kpw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anɨb unbö rö, Bɨ Ñɨ nɨpe aunab a gɨmim, abad mɨdaimim. Auagnab a gɨmim gasɨ nɨŋabim magö anɨbu nöp aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas anɨg hagö, Pida haga, “Bɨ Kub, manö hod rɨkmön hagabön anɨbu, hanɨp nöp hagabön aka nɨbi bɨ magöŋhalö hagabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hageia, Bɨ Kub pen haga, “Bɨ an gasɨ aij mɨdö, wög gɨ aij gɨnab u, bɨ kub nɨpe ram nɨpe u arnɨg göm nɨp hagnab, ‘Bɨ wög yɨp gɨpal rɨmnap kalɨp abad mɨdmön, nan ñɨŋeb kalɨp gau nɨme lɨ ñöl gɨ mɨdaimön,’ a göm, arnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Anɨb u, hainö ado gɨ apöm, hagnab rö nöp gɨnab u nɨŋöm, nɨp ud aij yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yad kalöp hagabin, bɨ kub anɨbu hagö, bɨ nɨpe gɨ aij gɨnab anɨbu nan nɨpe gau magöŋhalö abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pen bɨ wög gɨ ñeb nɨpe u, bɨ kub yad u yɨŋɨd auagöp a göm, nɨbi bɨ wög gɨ ñeb rɨmnap kalɨp mɨñu magö paköm, nan kub ñɨŋöm, ñɨg wain iru ñɨŋöm, hauƚ alöm, gɨ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pen bɨ kub nɨpe auagnab a göm nɨŋnab ñɨn u nöp apöm, nɨp rɨb gɨ dö mɨ dö göm, nɨbi bɨ manö nɨp nɨŋagpal aŋ kalɨp au hag yunab. ");
INSERT INTO kpw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Bɨ wög gɨ ñeb bɨ ap, bɨ kub nɨpe manö hagnab u nɨŋ aij gɨnab, pen manö nɨp u rɨb juöm, hagnab rö gagnab u, bɨ kub hagö, kale nɨp rapɨn paknaböl. ");
INSERT INTO kpw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pen bɨ wög gɨ ñeb bɨ ap, bɨ kub nɨpe manö hagnab u nɨŋagöm, manö hagnab rö gagnab u, bɨ kub hagö, kale nɨp paköm ilön pro rö ñɨnaböl. God nɨbi bɨ kalɨp nan iru ñɨnab gau, yɨp pen nan iru ñɨmim, a gɨnab; pen nɨbi bɨ kalɨp nan iru yabɨƚ ñɨnab gau, yɨp pen nan iru yabɨƚ ñɨmim, a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yad aubin u, mɨnöŋ naböŋ adö iƚ i hapö pɨg yunɨg aubin. Ram mɨnöŋ gau magöŋhalö hadö inböp u aij! ");
INSERT INTO kpw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yɨp ilön pak ñɨnɨg gaböl u, yɨp marö kub yabɨƚ göp. Marö kub anɨbu mɨd dam dam, yɨp ilön pak pɨs gɨnaböl ñɨn u nöp pɨɫa gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kale yɨp hagnabim, nɨbi bɨ ud jɨm ñɨnɨg auub a gɨnabim u, pen u wasö. Yad aubin rö, nɨbi bɨ gau gasɨ adö ke ke nɨŋöm asɨk ke ke lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mɨñi ñɨn i rɨköm, amɨlap apɨlap unbö mamɨd rö mɨdeinaböl u, mɨhau nɨgaŋ yɨp udlö, mɨhöp yɨp udagmil, asɨk ke ke lɨnabil. Pen wasö u, mɨhöp yɨp udlö, mɨhau nɨgaŋ yɨp udagöm, asɨk ke ke lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɨ apil mɨhau, ñɨ nɨpe aka nap yɨp udagö me, asɨk ke ke lɨnabil. Nɨbi amɨl mɨhau, pai nɨpe aka nɨme yɨp udagö me, asɨk ke ke lɨnabil. Nɨme aip ñɨ nɨpe nɨbin u aip, u rö nöp gɨnabil; nɨme aka ñɨ nɨpe nɨbin u yɨp udagö, asɨk ke ke lɨnabil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pen Jisas manö ap halö kalɨp haga, “Sɨdö wad arab lau adö kumi wamöb nɨŋmim, mɨñi möŋ alnɨg gab a gɨmim nɨŋ mɨdpe, mɨdö mɨdö hagpim rö nöp möŋ alnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɨgön kub gamɨŋ nɨbö gai i gɨ auöp nɨŋmim, mɨñi sɨdö kub lɨnɨg gab a gɨmim nɨŋ mɨdpe, mɨdö mɨdö hagpim rö nöp sɨdö kub lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kale bɨ pir alep! Nan mɨnöŋ naböŋ iƚ i nɨŋ aij gɨmim, nan kumi kabö adö laŋ nɨŋ aij gɨmim gɨpim u, pen nɨhön gɨnɨg ñɨn kub pör abad mɨdmɨdim u, mɨñi hadö auöp a gɨmim nɨŋagpim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kale ai gɨnɨg, adan anɨbu aij, adan anɨbu naij, a gɨmim nɨŋagpim? ");
INSERT INTO kpw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pen bɨ ap nöp manö kub hagnɨg dam arabin a gainɨm, manö kub anɨbu nɨhön gɨnɨg arabul a gɨmön, adan aŋ au amöl gɨ, nɨp aip manö hag ud asɨk aij gɨmil. Wasö u, nöp dam bɨ kub manö nɨŋeb ñɨmagö adö nɨpe u yuö, nɨpe pen nöp dam polisman ñɨmagö adö kalɨp gau lö, nöp böŋ nöp dam nagɨ lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Anɨb u, yad nöp hagabin, ne nagɨman nöp mɨdmön, nan naböŋ ne gau böŋ nöp naböŋ ral pɨs gɨmön me, höŋ arnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Magö anɨbu, nɨbi bɨ rɨmnap apöm, Jisas nɨp hagöm hagla, “Galili nɨbi bɨ rɨmnap apöm, God sabe gep ram u nan sabe gɨ ñɨlö nɨŋöl gɨ, magö anɨbu nöp gapman bɨ kub Pailod kalɨp böŋ nöp al pak la,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hageila, Jisas kalɨp haga, “Galili nɨbi bɨ anɨb gau nöp, nan si nan naij unbö ke gɨlö anɨg göp, pen Galili nɨbi bɨ rɨmnap nan si nan naij pro pro gɨpal rö anɨg gagöp, a gɨmim, nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","U wasö! Yad kalöp hagabin, nan si nan naij gɨpim gau nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gagnabim u, nɨbi bɨ anɨb gau umla rö nöp, kale magöŋhalö u rö nöp umnabim. ");
INSERT INTO kpw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pen Siloam waŋö söl au, ram mɨlö kub pa jö göm nɨbi bɨ unbö kagoƚ böŋ daŋ (18) kalɨp pak la u, nan si nan naij unbö ke gɨlö anɨg göp, pen nɨbi bɨ Jerusalem mɨdmɨdal rɨmnap nan si nan naij pro pro gɨpal rö anɨg gagöp, a gɨmim, nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","U wasö! Yad kalöp hagabin, nan si nan naij gɨpim gau nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gagnabim u, nɨbi bɨ anɨb gau umla rö nöp, kale magöŋhalö u rö nöp umnabim. ");
INSERT INTO kpw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pen Jisas manö hod rɨköm kalɨp haga, “Bɨ ap uɫhem magö ap pɨlaŋ, a göm, yɨŋ u ju dapöm, nagɨ wain wög nɨpe au yɨmnab. Hainö ado gɨ apöm nɨŋnab magö ap pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bɨ wög gep nɨpe u nɨp hagnab, ‘Mɨ mɨhau nɨgaŋ mɨ añɨ añɨ inö nɨŋöl gɨ, pör apem nɨŋbin uɫhem yɨmnö u magö ñɨŋeb ap pɨlagöp. Anɨb u, wög adɨŋ yad aŋ au mɨdöp u aij gagöp. Rɨb yu!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hageinab, bɨ wög gɨ ñeb nɨpe hagnab, ‘Bɨ kub, uɫhem iƚ anɨbu mɨñi rɨb yuagep. Yad uɫhem iƚ anɨbu kɨpɨƚ gɨ aij gem, nan uɫaŋ uɫaŋ rɨmnap dap lɨnö, ");
INSERT INTO kpw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","mɨ hainbö u magö pɨlnɨm u arö gɨmön; pen magö pɨlagnɨm u rɨb yumön,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pen Juda God nɨp sabe gep ñɨn ap, Jisas Juda magum gep ram ap amöm, kalɨp manö hag ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ram raul mɨgan anɨbu nɨbi ap ap mɨdeia. Nɨbi anɨbu nɨp kɨjaki aiön pi gö, jöl magö nɨpe u dudu badu göl nöp ajmɨdöp mɨ unbö kagoƚ böŋ daŋ (18) ina. ");
INSERT INTO kpw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas nɨbi anɨbu nɨp hagö auaia haga, “Nan nöp göp u kamɨŋ löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Anɨg hagöm, nɨp ud nɨŋö nɨŋöl gɨ, magö anɨbu nöp jöl magö u yɨjɨg gö, God hib nɨpe u hagö adö ara. ");
INSERT INTO kpw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pen Jisas God nɨp sabe gep ñɨn u gö kamɨŋ la u nɨŋöm, bɨ kub Juda magum gep ram anɨbu abad mɨdmɨdöp u, Jisas nɨp nɨŋö mulu lugö, nɨbi bɨ ap mɨdeila gau kalɨp haga, “Kale nɨbi bɨ nan göp gau, wög gep ñɨn unbö kagoƚ jɨŋ nöp aube kamɨŋ lɨnɨm. Mɨñi God nɨp sabe gep ñɨn i anɨg gagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Anɨg hagö, Bɨ Kub nɨp pen haga, “Kale bɨ pir alep! Kaj kau, kaj donki kale gau adɨk lɨbe mɨdeinab au, God nɨp sabe gep ñɨn u ñɨg nan gö, kalɨp nagɨ hubɨkmim, dam arbe ñɨg ñɨŋnaböl aka wasö? ");
INSERT INTO kpw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pen bac iƚaŋ hon Ebraham rɨköm, rɨk dap lɨla pai i, Seden nɨp hadame nöp adɨk lö, mɨ in kagoƚ böŋ daŋ mɨdöp u, nɨp mög nɨŋagpim arŋ Mɨñi God nɨp sabe gep ñɨn i, nagɨ nɨpe hubɨk yuajɨn, manö kub hagabim ar? ");
INSERT INTO kpw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas anɨg hagö, bɨ nɨp nɨŋlö mulu luga gau nable yabɨƚ ga. Pen nɨbi bɨ rɨmnap gau, Jisas nan gagep rö gɨmɨdöp gau nɨŋöm, mɨñ mɨñ yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas manö ap halö hagöm haga, “God nɨbi bɨ udöm abad mɨdeinab manö u kalöp hag ñɨnɨg gabin u, aige gem hagnö, kale nɨŋ aij gɨnabim? ");
INSERT INTO kpw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Me manö adö hagnɨg gabin inbö rö mɨdöp. Bɨ ap mab masded magö u dam wög naböŋ nɨpe u yɨmö, ran kub göm ramö löm gau gau arnab, yaur gau apöm lö lö gau gau mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Manö ap pen kauyaŋ haga, “God nɨbi bɨ udöm abad mɨdeinab manö u, aige gem hagnö, kale nɨŋ aij gɨnabim? ");
INSERT INTO kpw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Adö anɨbu rö, nɨbi ap yɨs bad pro pro ap udöm, plaua rin kub yaŋ halö ud ado malo gö mɨdöl gɨ, kub yabɨƚ rannab rö u gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pen Jisas Jerusalem arnɨg göm, yɨjɨg göl araga. Nɨpe daun gau abe, nɨbi bɨ ram rɨƚɨg agƚö mɨdeila gau abe, aŋ aŋ hanöl gɨ, manö hag ñöl gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɨbi bɨ mɨdeila anɨb gau, bɨ ap Jisas nɨp haga, “Bɨ Kub, God yöp nɨbi bɨ mɨhöp nöp ud kamɨŋ yunab aka?” ga. Hageia, Jisas kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Anɨb u, kale kƚö gɨmim nöp, ajöŋ iƚ pro ramö anɨbu arnabim. Nɨbi bɨ iru yabɨƚ nöp, adan ramö pro anɨbu arun, a göm, am rua rɨk wasö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nɨhön gɨnɨg, bɨ ram nap nɨbö u adan gɨñnab, kale höŋ gau nöp mɨdmim, pak gu gu gɨmim hagnabim, ‘Bɨ kub, adan hiɨk!’ a gɨpe, nɨpe pen pe hagnab, ‘Kale gai nɨböŋ Yad kalöp nɨŋagpin!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hageinab, kale pen hagnabim, ‘Ne nöd ram mɨnöŋ hon u apön, nöp aip nan ñɨŋun ñɨg ñɨŋun gɨmɨdun; ne hanɨp manö hag ñɨmɨdan,’ a gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kalöp pen hagnab, ‘Yad kale nɨŋagmɨdin. Kale gai nɨbö yad nɨŋagpin. Kale nɨbi bɨ nan si nan naij gɨpim u me, kalöp ajöŋ hiɨkagnabin. Arim!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hainö kale nɨŋnabim, Ebraham, Aisak, Jekop, bɨ God manö hagep bɨ gau, God ram mɨnöŋ pör mɨdep u God aip mɨdeinaböl, pen kalöp hag höŋ yuö, mɨɫöŋ kub göl gɨ, meg magö hau rɨbɨköl gɨ nöp mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pen nɨbi bɨ mɨlö gau nɨbö, sɨdö auab lau adö nɨbö, sɨdö wad arab lau adö nɨbö, gamɨŋ gau nɨbö, gajɨŋ gau nɨbö, God ram mɨnöŋ pör mɨdep nɨpe u apöm, asɨköm jɨm ñöl nan kub ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pen nɨbi bɨ uri jöl adö yabɨƚ au mɨdpal gau, hainö rɨmnap nöd am mɨdeinaböl. Pen nɨbi bɨ uri nöd araböl gau, hainö rɨmnap jöl adö yabɨƚ gau mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Magö anɨbu nöp, bɨ Perisi rɨmnap apöm Jisas nɨp hagla, “Gapman bɨ kub Herod nöp al pak lɨnɨg gab. Anɨb u, ne ram mɨnöŋ i arö gɨmön, ram mɨnöŋ ke ap aru,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hageila, Jisas haga, “Kale am kain hapeb anɨbu nɨp hagpe, nɨŋ mɨdainɨm. Mɨñi abe, rol abe, nɨbi bɨ kɨjaki aiön pi abaŋ alöp gau gɨnö kamɨŋ löm, nɨbi bɨ nan göp gau gɨnö kamɨŋ löm, gɨnab. Ruö pen, ñɨn mɨhau nɨgaŋ u me, wög yad u gɨ haknabin. ");
INSERT INTO kpw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pen mɨñi, rol, ruö yad adan arɨn a gabin u arnɨg gabin. Bɨ God manö hagep gau kalɨp Jerusalem nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem! Jerusalem! God nɨpe manö hagep bɨ nɨpe kalöp a göm yua gau, nɨhön gɨnɨg pör kabö ud pak lɨbimŋ Kɨƚakɨƚ pi ud auan mo gau löp rö u, yad pör ñɨ pai ne gau ud aij gɨnam, a gem, nɨŋbin u pen yɨp iru nɨŋmim wɨhö gɨpim. ");
INSERT INTO kpw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Anɨb u, nɨŋim. Ram kale u kuö nöp mɨdöp. Mɨdö, kale yɨp nɨŋagnabim; hainö gau, ‘Bɨ anɨbi Bɨ Kub hag yuöp auab i, God gö, hib nɨpe adö laŋ araŋ,’ a gɨnabim ñɨn u me, yɨp kauyaŋ nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juda God nɨp sabe gep ñɨn ap, Jisas am Perisi bɨ kub ap ram nɨpe u nan ñɨŋö nɨŋöl gɨ, nɨbi bɨ mɨdeila gau, nɨpe nɨhön rö gɨnɨm, a göm, nɨŋ ij halö lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nɨhön gɨnɨg: ñɨn anɨbu, bɨ ñɨmagö ma hu ga ap ap mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas, bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe, kalɨp haga, “God nɨp sabe gep ñɨn i, bɨ nan göp ap gɨno kamɨŋ lɨnab u aij aka wasöŋ Lo manö nɨhön hagöp?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hageia, manö ap pen hagagla. Anɨb u, Jisas bɨ ñɨmagö ma hu ga u nɨp ud nɨŋö kamɨŋ la. Kamɨŋ lö, Jisas bɨ anɨbu nɨp hag yuö ara. ");
INSERT INTO kpw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jisas bɨ anɨbu hag yuöm, bɨ anɨb gau kalɨp haga, “Ñɨ pai kale ap aka kaj kau kale ap, God nɨp sabe gep ñɨn u ñɨg mɨlbim uƚöm mɨgan yaŋ lugeinab u, kale yɨŋɨd am ud yunabim aka wasö?” ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hageia, kale pen manö ap hagöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pen nɨbi bɨ anɨb gau nan magö ñɨŋnɨg apöm, ka asɨkep aij aij gau nöp nɨŋun asɨkun, a göm asɨkla u, Jisas nɨŋöm, manö ap manö hod rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bɨ ap nɨbi udnɨg göm, nan kub ñɨŋnɨg kalöp wɨñ alö ammim, ka asɨkep aij lɨnɨm adö u asɨkagmim. Nɨhön gɨnɨg: nɨbi bɨ kub rɨmnap auöl rö löp. ");
INSERT INTO kpw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anɨb u, kale ka asɨkep aij adö anɨbu asɨk geinabim, bɨ kalöp wɨñ alnab u apöm hagnab, ‘Ne ke gau aru, bɨ kub i adö anɨb au asɨkaŋ,’ a gö, nöp nable gö nɨŋöl gɨ, am ƚɨƚɨ gɨ am ba gau asɨknabön. ");
INSERT INTO kpw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pen kalöp, nan ñɨŋun, a göm, wɨñ alaiöl, am goƚ gau asɨk mɨdpe me, bɨ kalöp wɨñ alnab u apöm hagnab, ‘Bɨ mɨdeimam. Ne aumön ka adö aij i asɨk gɨ,’ a gö, nɨbi bɨ nan ñɨŋnɨg ap mɨdeinaböl gau nöp nɨŋöm, bɨ u aŋ i bɨ kub nöp mɨdöp, a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anɨb unbö rö, nɨbi bɨ hon hib kub mɨdöp, a göm, nɨŋbal gau, God hib kalpe gö ap lugnab. Pen nɨbi bɨ ana udöm mɨdpal gau, God hib kalpe gö ap rannab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas manö anɨbu hagöm, bɨ nan kub ñɨŋnɨg nɨbi bɨ wɨñ ala u nɨp haga, “Ne nan kub ñɨŋnɨg, bɨ nɨŋeb ne gau, nañɨn namam yam ne gau, nɨbi bɨ ram mɨnöŋ aƚog ne mani iru mɨdöp gau, kalɨp wɨñ alagmön. Nɨbi bɨ anɨb gau, naböŋ ñun, a göm, nöp pen nan ñɨŋnɨg wɨñ alöl rö löp. ");
INSERT INTO kpw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ne nan kub ñɨŋnɨg, nɨbi bɨ mög gep rö gau, nɨbi bɨ ñɨmagö ma kɨƚa göp gau, nɨbi bɨ ma naij göp gau, nɨbi bɨ amgö we göp gau, kalɨp wɨñ albe, aueinaböl, nan ñɨŋmim. ");
INSERT INTO kpw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nɨbi bɨ mög gep rö anɨb gau, nöp pen ñöl rö lagnab u me, hainö God nɨbi bɨ kamɨŋ aij nɨpe gau gö uraknaböl ñɨn u, nɨpe ke nöp pen ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pen manö anɨbu nɨŋöm, bɨ kale aip nan ñɨŋeila ap Jisas nɨp haga, “God nɨbi bɨ nɨpe udöm abad mɨdeinab u, nɨpe aip jɨm ñöl nan kub ñɨŋnaböl gau, mɨñ mɨñ yabɨƚ gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hageia, Jisas haga, “Bɨ ap nan kub ñɨŋnɨg göm, nɨbi bɨ iru nöp wɨñ alnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pen nan kub ñɨŋeb ñɨn anɨbu aueinab, bɨ wög gɨ ñeb nɨpe u nɨp hagnab, ‘Mɨñi am nɨbi bɨ nöd hag lɨbin gau kalɨp am paŋɨd dau,’ a gɨnab. Bɨ wög gɨ ñeb nɨpe pen amöm hagnab, ‘Nan magöŋhalö dap gɨjɨn gɨpun; aube arun!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hageinab, nɨbi bɨ anɨb gau ap hagnab, ‘Yad arnam u pen mɨnöŋ naböŋ ap raubin u nɨŋnɨg arabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pen ap hagnab, ‘Yad arnam u pen kaj kau unbö sɨduŋ laŋ raubin u, wög gɨ aij göl aka gem, am nɨŋnabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ap hagnab, ‘Yad arnam u pen nɨbi yad gɨsön nöp udpin u me, aunam rö lagöp,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Anɨg hageinaböl, bɨ anɨbu ado gɨ amöm, nɨbi bɨ gau kale nɨhön nɨhön hagnaböl u, bɨ kub nɨpe u nɨp hagnab. Hageinab, bɨ kub u hibur nɨpe u naij gö, bɨ nɨpe u nɨp kauyaŋ hag yuöm hagnab, ‘Ne yɨŋɨd am adan kub gau abe, adan pro gau abe ammön, nɨbi bɨ mög gep rö gau, nɨbi bɨ ñɨmagö ma kɨƚa göp gau, nɨbi bɨ amgö we göp gau, nɨbi bɨ ma naij göp gau, kalɨp paŋɨd dau,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hageinab, hagnab rö göm, hainö bɨ wög gɨ ñeb anɨbu hagnab, ‘Bɨ kub, hagpan rö gɨpin u pen mɨgan rɨmnap kau nöp mɨdöp,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hageinab, bɨ kub u bɨ wög gɨ ñeb nɨpe nɨp hagnab, ‘Ne adan kub gau abe, adan pro gau abe ammön, nɨbi bɨ manö kƚö gɨmön hagö, kale aulö, ram raul mɨgan yad u böŋ nöp rɨb udnɨm. ");
INSERT INTO kpw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pen nɨbi bɨ nöd wɨñ alnö auagpal gau, nɨbi bɨ ap nan yad pro pro rɨmnap ñɨŋagnab, wasö yabɨƚ,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jisas adan araia u, nɨbi bɨ iru yabɨƚ nɨp hain gɨla. Nɨpe ado göm kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nɨbi bɨ gau yɨp lau adö arun a gɨnaböl u pen gasɨ kub kale areinab nɨme nap, nɨbi ñɨ pai, nɨñɨn nɨmam kale, aka hañ romaŋ kale ke u, yad nɨŋnö nɨbi bɨ yad mɨdaiöl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nɨbi bɨ rɨmnap hagnaböl, Jisas nɨbi bɨ nɨpe mɨdaiun u pen anɨg gɨno, nɨbi bɨ rɨmnap hanɨp gɨ naij göl rö löp, a göm, hañ romaŋ kale ke nöp gasɨ nɨŋöl gɨ mɨdeinaböl u, nɨbi bɨ yad mɨdaiöl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pen bɨ kale ap, ram mɨlö kub i adö laŋ ap gɨnɨg, nöd mani aige gö rö udem gɨnam, a göm, gasɨ nɨŋ aij göm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pen, gɨnam gɨnam, a göm, kabö nöd nöp gɨnab u pen hainö mani uƚep gö, ram uƚep gö, nɨbi bɨ gau nɨp hag juöm hagnaböl, ");
INSERT INTO kpw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ake! Bɨ mɨlö i ram gɨnɨg göm rö gɨ damöm, ram adɨŋ arö göp,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pen anɨbu rö, bɨ kiŋ ap, bɨ kiŋ ap aip pen pen gɨnɨg, nöd gasɨ nɨŋ aij göm arnab. Pen nɨpe gasɨ nɨŋ damöm, ami bɨ yad u den dausan nöp mɨdöp; pen kiŋ anɨbu ami bɨ nɨpe dwedi dausan mɨdöp; pen pen gun, nɨpe ami bɨ yad al pak lɨnɨm rö löp, a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gasɨ anɨbu nɨŋöm, kiŋ ap mɨlö gau hain auö nɨŋöl gɨ, manö yuöm hagnab, ‘Hol aige gul, manö hag jɨm ñul?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Anɨb u, nɨŋ aij gɨmim. Nan kale gau magöŋhalö arö gɨmim, yɨp aip auagnabim u, nɨbi bɨ yad mɨdaimim rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Dö nan aij yabɨƚ u pen dö kal nɨpe arnab u, kale nɨhön gɨlö kauyaŋ dö gɨnab? ");
INSERT INTO kpw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dö anɨbu rö, ud wög adɨŋ aka kɨƚakɨƚ hib au yulö nan magö ran aij gagnab. Dö anɨbu rö wög ap mɨdagöp; ud yuep rö nöp löp. Kale nɨbi bɨ gasɨ rɨmɨd mɨdainɨm gau, manö hagabin i rɨmɨd lɨ nɨŋ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pen bɨ dakɨs udep gau abe, nɨbi bɨ nan si nan naij gɨla gau abe, Jisas manö hagab u nɨŋun, a göm, ap nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pen bɨ Perisi gau abe, bɨ lo manö hag ñeb bɨ gau abe, Jisas nɨp hag juöm hagla, “Nɨpe nɨhön gɨnɨg bɨ nan si nan naij gɨpal gau udöm, aip nan magö jɨm ñöl ñɨŋab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Anɨg hageila, Jisas manö ap hod rɨköm kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bɨ kale ap, kaj sipsip ñɨnjuöl unbö mamɨd u (100) muk mɨdeinab. Pen añɨ nɨbö ap ur geinab u, rɨmnap dam mɨnöŋ haƚɨn haƚɨn mɨdöp gau löm, am kaj sipsip nɨpe ur gɨnab u uƚhai nɨŋ aj aj aj, nɨp uƚhai nɨŋ dam dam nɨŋ udnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kaj sipsip nɨpe anɨbu uƚhai nɨŋ udöm, aij a gö nɨŋöl gɨ, ud sɨduŋ nɨpe u adö laŋ lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sɨduŋ laŋ dap ram amöm, nɨbi bɨ nɨŋeb nɨpe gau, nɨbi bɨ ram mɨnöŋ aƚog nɨpe gau, kalɨp wɨñ alöm, ap magum gɨnaböl hagnab, ‘Kaj sipsip yad ur göp u, uƚhai nɨŋ adog udpin u, köl yad aip mɨñ mɨñ gun,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Anɨg unbö rö me, nɨbi bɨ iru nöp gau, hon gɨ aij gun nan si nan naij gagpun, a göm, gasɨ nɨŋbal gau, kumi kabö adö laŋ au mɨdpal gau nɨŋöm mɨñ mɨñ gagnaböl; pen nɨbi bɨ añɨ ap, nan si nan naij gɨpin gau nɨhön gɨnɨg anɨg gɨpin, a göm, arö geinab u, kumi kabö adö laŋ au nɨŋöm mɨñ mɨñ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aka pen, nɨbi ap mani silpa magö nɨpe unbö sɨduŋ laŋ mɨdeinab. Pen magö ap, ram raul mɨgan gau agamɨj ap lugeinab u, nɨpe nɨhön gɨnabŋ Nɨpe hapö lau adö aulɨk löm, uƚhai nɨŋ nɨŋ ka acɨp acɨp ƚɨk ƚɨk, kabö magö nɨpe anɨbu udnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mani silpa magö nɨpe anɨbu uƚhai nɨŋ udöm, aij a gö nɨŋöl gɨ, nɨbi bɨ nɨŋeb nɨpe gau, nɨbi bɨ ram mɨnöŋ aƚog nɨpe gau, kalɨp wɨñ alöm, ap magum gɨnaböl hagnab, ‘Kabö magö yad lugöp magö añɨ anɨbu, uƚhai nɨŋ adog udpin u, köl yad aip mɨñ mɨñ gun,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Anɨbu rö me, nɨbi bɨ añɨ ap, nan si nan naij gɨpin gau nɨhön gɨnɨg anɨg gɨpin, a göm, arö geinab u, kumi kabö adö laŋ au God ejol nɨpe gau nɨŋöm mɨñ mɨñ gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas manö anɨbu hagöm haga, “Bɨ ap ñɨ nɨpe mɨhöp mɨdeinab u. ");
INSERT INTO kpw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ñɨ nɨpe hain u, ap nap nɨp hagnab, ‘Bapi, nan halɨp mɨhöŋ hagpan gau, ud asɨk yɨp gau ke ñɨ,’ a gö, nap nan kalpe mɨhöŋ gau ud asɨk ke ke ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ñö, ñɨ nɨpe hain u magö uƚep magö ap mɨdöm, nap nan nɨp ud asɨk ña gau magöŋhalö sɨkim göm, mani udöm, dam ram mɨnöŋ mɨlö gau arnab. Am anɨb gau mɨdöm, nɨbi si nan naij gau göl gɨ, mani nan nɨpe ud arnab gau, haƚöwaƚö nɨbi bɨ gau ñɨ pɨs gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Anɨg gö, mani nɨpe pɨs gö, ram mɨnöŋ anɨbu kɨyö kub yabɨƚ lɨnab. Pen nan magö rau ñɨŋnɨm mani ap mɨdageinab. ");
INSERT INTO kpw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anɨg gö, nɨpe amöm, bɨ ram mɨnöŋ anɨbu nɨbö nap kale ap hag nɨŋö, nɨp kaj mukep wög u hag lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pen nɨp kɨyö kub yabɨƚ u lö gɨ mɨdö mɨdö, kaj mukmɨdal womai hañ gau rɨmnap ñɨŋnam a gɨnab u pen nɨbi bɨ rɨmnap nɨp nan magö ñagnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pen gasɨ magö nɨpe nɨŋ ud arö gasɨ aij magö u auö hagnab, ‘Bapi yad bɨ nɨp wög gaböl gau, nan magö iru mɨdöp. Yad aui mɨdpin, yɨp kɨyö kub yabɨƚ löp. ");
INSERT INTO kpw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Anɨb u, yad ram mɨnöŋ i arö gem, bapi mɨdöp au kauyaŋ ado gɨ amem, nɨp hagnabin, “God amgö ilö adö nɨpe u gɨ naij gem, amgö ilö adö ne u gɨ naij gem, gɨpin rö, ");
INSERT INTO kpw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ne yɨp ñɨ yad a gɨ hagagmön. Yɨp bɨ wög gɨ ñeb ne ap rö hag lɨmön gɨnabin,” a gɨnabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gasɨ anɨbu nɨŋöm, bapi ram ado gɨ arnabin, a göm, hadnab. Am am am, nap nɨpe mɨlö gau nɨbö ñɨ nɨpe anɨbu nɨp yɨjɨg nɨŋnab. Nap ñɨ nɨpe nɨŋöm, nɨp mög yabɨƚ gɨnab. Nɨpe dip gɨ dö gɨ am nɨp ud wabi göm, ud bom haluöm mulu ñɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nap anɨg gö, ñɨ hagnab, ‘Bapi, God amgö ilö adö nɨpe u gɨ naij gem, amgö ilö adö ne u gɨ naij gem, gɨpin rö, ne yɨp ñɨ yad a gɨ hagagmön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nap pen, bɨ wög gɨ ñeb nɨpe gau kalɨp hagnab, ‘Kale yɨŋɨd nöp am waƚɨj mɨlö kub yad u dap nɨp yɨm ñɨmim, ñɨmagö nɨpe u riŋ lɨ ñɨmim, ma rɨrup lɨ ñɨmim, gim. ");
INSERT INTO kpw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Anɨg gɨmim, am kaj kau pi marep haƚɨn aij yabɨƚ u pak dam laube, mɨñ mɨñ göl gɨ nan kub ñɨŋun. ");
INSERT INTO kpw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ñɨ yad u böŋ nöp uma rö la u, pen mɨñi nɨpe kauyaŋ kamɨŋ mɨdöp. Nöd nɨpe böŋ nöp hir ga u, pen mɨñi nɨp adog udpin,’ a gɨnab. Nap hagö, kale am kaj kau pi pak dapöm, nan magö laulö, mɨñ mɨñ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pen ñɨ nɨpe nöd u, wög adɨŋ gau gɨ aj arö göm, ado gɨ yöp ram söl au apöm nɨŋnab, cacɨŋ, mab ij paköm, kugom ralöm, mɨñ mɨñ göl gɨ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Anɨg geinaböl, nap bɨ wög gɨ ñeb nɨpe ap nɨp hag nɨŋöm hagnab, ‘Nɨhön gaböl?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hageinab, hagnab, ‘Namam hain ne umöb a göm nɨŋöb u pen mɨñi ado gɨ auö, nap kaj kau pi marep haƚɨn aij u pak lau ñɨŋöl gɨ mɨñ mɨñ gaböl,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hageinab, nɨp mulu kal yabɨƚ lugö, ram raul mɨgan aragnab; höŋ au yaŋ nöp mɨdeinab. Nap pen höŋ amöm, auö ram raul mɨgan arul, a göm, nɨp manö hain hain hagöm hagnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nap nɨpe manö hain hain hageinab pen ñɨ nöd nɨpe hagnab, ‘Yad manö ne hagpan rö pör nöp hain gem, bɨ nagɨ wög gep ne rö mɨdem, wög nöp pör pör gɨnö gɨnö mɨ iru yabɨƚ nöp lugöp. Pen yɨp kaj meme pi ap ñö, mɨdeimam yad gau aip pak lau ñɨŋun mɨñ mɨñ gagpun. ");
INSERT INTO kpw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pen ñɨ ne anɨbu, nan nɨme lɨ ñɨna gau damöm, nɨbi si nan gau göm gɨ ñɨŋ yu haköm auub, nɨp mög nɨŋmön, kaj kau pi marep haƚɨn aij yabɨƚ u pakpan!’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Anɨg hageinab, nap ñɨ nɨpe nöd nɨp hagnab, ‘Hol apɨl pör mɨdpul rö, nan yad gau magöŋhalö ne udnabön. ");
INSERT INTO kpw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Namam hain ne u böŋ nöp uma rö la u, pen mɨñi nɨpe kauyaŋ kamɨŋ mɨdöp. Nɨpe böŋ nöp hir ga u, pen mɨñi nɨp uƚhai nɨŋ adog udpin. Anɨb u me, hon mɨñ mɨñ gun,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas bɨ nɨpe gau kalɨp haga, “Bɨ kub nan iru mɨdnab ap, bɨ nan nɨpe abad mɨdep bɨ ap hag lö, nan nɨpe gau abad mɨdeinab. Pen bɨ kub u, manö ap nɨŋnab, bɨ nan nɨpe abad mɨdnab anɨbu, nan nɨpe gau haƚöwaƚö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bɨ kub manö anɨbu nɨŋöm, nɨp wɨñ alö aueinab hagnab, ‘Nan yad gau abad mɨd aij gagpan u, yɨp hag ñɨlö nɨŋbin. Anɨb u, ne ammön, nan yad aigeg mɨdöp gau magöŋhalö wö ral nɨŋ aij gɨmön, nɨbi bɨ gau kalɨp nan naböŋ yad aigeg mɨdöp gau magöŋhalö wö ral nɨŋ aij gɨmön, ap yɨp hag ñɨmön, wög yɨp gɨpan u hainö gagnabön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hageinab, bɨ nan nɨpe abad mɨdep anɨbu, aŋ nɨpe gau nöp gasɨ iru nɨŋöm hagnab, ‘Bɨ kub u yɨp hag yunɨg gab u pen yad nɨhön gɨnamŋ Yad bɨ pɨdöŋ mɨdagpin rö, mɨnöŋ bɨnɨg jö gɨnam rö lagöp. Nɨbi bɨ rɨmnap nan kale u asɨb hag gɨ ñɨŋeinabin u, yɨp nable gɨnab,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pen hainö gasɨ nɨŋ aij göm hagnab, ‘Yad nɨhön gɨnam u uri nɨŋbin. Adö anɨbu gɨnö, hainö bɨ kub yad yɨp hag yunab ñɨn u, nɨbi bɨ rɨmnap yɨp udlö, ram kale au han mɨdeinabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Anɨg hagöm, nɨbi bɨ rɨmnap kalɨp bɨ kub nɨpe nan naböŋ mɨdeinab gau wɨñ alnab. Wɨñ alö, bɨ nöd aunab u nɨp hagnab, ‘Ne bɨ kub yad nan naböŋ aigeg mɨdöp?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hageinab hagnab, ‘Wel ñɨŋeb dɨƚam ñɨnjuöl añɨ ap,’ a gɨnab. Hageinab hagnab, ‘Diker i ud, yɨŋɨd asɨkmön dɨƚam unbö sɨduŋ laŋ kalɨ kƚiñ rɨk,’ a gɨnab. Hageinab, hagnab rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hainö bɨ ap aueinab, hagnab, ‘Ne bɨ kub yad nan naböŋ aigeg mɨdöp?’ ö gɨnab. Hageinab hagnab, ‘Wid beg ñɨnjuöl unbö mamɨd u,’ a gɨnab. Hageinab hagnab, ‘Diker i ud, yɨŋɨd asɨkmön beg ñɨnjuöl mɨhau mɨhau kalɨ kƚiñ rɨk,’ a gɨnab. Hageinab, hagnab rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Anɨg geinab, hainö bɨ kub nɨpe u nɨŋöm hagnab, ‘Bɨ nan yad abad mɨdep bɨ anɨbu, gasɨ nɨŋ aij göm, nɨhön nɨhön gem mɨd aij gɨnabin a göp u, nɨpe gɨ aij göp,’ a gɨnab. Anɨb u nɨŋim. Nɨbi bɨ mɨnöŋ naböŋ adö iƚ i gasɨ nɨŋbal gau hagpal, ‘Mɨñi aigöl gun hainö asɨk mɨdep hon u mɨd aij gɨnɨm?’ ö göm, gasɨ u nɨŋöl gɨ gɨlö arab. Pen mailö aij nɨŋbal nɨbi bɨ gau, anɨg unbö rö nöp gɨlö arböp u aij. ");
INSERT INTO kpw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Mani nan mɨnöŋ naböŋ iƚ i mɨdöp gau, nɨbi bɨ rɨmnap gau ñɨbe me, hainö nan anɨb gau böŋ nöp pɨs gɨnab ñɨn u, God ram mɨnöŋ pör mɨdep nɨpe au kalöp hag wɨhai udnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mani nan pro ap, nɨbi bɨ ap ñɨmagö adö u lɨlö, abad mɨd aij gɨnab u, nan kub gau ñɨlö, u rö nöp gɨnab. Pen mani nan pro ap, nɨbi bɨ ap ñɨmagö adö u lɨlö, abad mɨd aij gagnab u, nan kub gau ñɨlö, u rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pen kale mani nan mɨnöŋ naböŋ adö iƚ i mɨdöp u udmim, pir almim, abad mɨd aij gagnabim u, bɨ an kalöp nan aij yabɨƚ adö laŋ nɨbö ñɨnab? ");
INSERT INTO kpw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɨ ap mani nan nɨpe ud ñɨmagö adö kalöp lɨnab u, kale pir almim, abad mɨd aij gagnabim u, bɨ an mani nan kalöp ke ñɨnab? ");
INSERT INTO kpw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bɨ añɨ ap, bɨ kub mɨhöp kalɨp wög gɨnɨm rö lagöp. Bɨ mɨhöŋgöl kalɨp wög gɨnab u pen nɨpe bɨ kub ap nɨp mɨdmagö löm, bɨ ap nɨp mɨdmagö lagnab. Aka bɨ kub ap nɨp mɨdmagö löm, bɨ ap nɨp mɨdmagö lagnab. Unbö rö, kale mani nan gau nan aij yabɨƚ a gɨmim nɨŋeinabim u, God nɨp wög gɨpim u arö gɨmim rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bɨ Perisi gau, gasɨ kub kale mani adö u nöp nɨŋmɨdal u me, Jisas manö haga u nɨŋöm mɨhol göm hag jula. ");
INSERT INTO kpw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hag jueila, kalɨp haga, “Kale nɨbi bɨ amgö ilö adö u, hon nɨbi bɨ aij mɨdpun, a gɨpim u, pen God hibur gasɨ mɨdmagö aŋ kalöp daŋ nɨŋöb. Nan nɨbi bɨ nɨŋlö aij göp gau, God nɨŋö nan naij rö löp. ");
INSERT INTO kpw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Jon bɨ ñɨg pak ñeb auaga ñɨn u, lo manö kalɨ kƚiñ rɨkla u abe, bɨ God manö hagep manö kalɨ kƚiñ rɨkla u abe haglö, nɨbi bɨ nɨŋöm, adö anɨbu gɨlö armɨdöp. Pen Jon aua ñɨn u rɨkö, God nɨbi bɨ udöm abad mɨdeinab manö aij u haglö, nɨbi bɨ nɨŋöm kale magöŋhalö adö anɨbu nöp arun, a göm, kƚö göm gɨlö arab. ");
INSERT INTO kpw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kumi kabö adö laŋ abe mɨnöŋ naböŋ iƚ i abe ur gɨnɨm rö löp, pen lo manö u adɨŋ pro ap ur gɨnɨm rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pen, bɨ ap nɨbi udöm arö göm, am nɨbi hain nɨbö ap udnab u, nɨbi si udnab. Pen bɨ ap uraköm, nɨbi u, bɨ udöm arö gɨnab nɨbi anɨbu, udnab u, nɨpe u rö nöp nɨbi si udnab. ");
INSERT INTO kpw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bɨ ap mani nan nɨpe iru yabɨƚ mɨdmɨdöp. Nɨpe waƚɨj aij aij nöp yɨmöm, nan ñɨŋeb aij aij nöp ñɨŋmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pen ram ajöŋ iƚ goƚ nɨpe au, bɨ use use halö nan mɨdagmɨdöp bɨ ap dap lɨlö mɨdmɨdöp. Hib nɨpe Lasaras. ");
INSERT INTO kpw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gasɨ nɨpe u nöp nɨŋöm, ‘Bɨ nan iru mɨdöp i nan ñɨŋö, nan naböŋ naböŋ abañ mo gai i lugnab u, yad ñɨŋnabin kɨyö lagnab,’ a göm, nɨŋmɨdöp. Pen kain gau apöm, wös nɨpe gau baɫö gɨ ñɨŋmɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hainö bɨ yɨgön anɨbu uma. Nɨpe umö, ejol gau apöm, nɨp dam ram mɨnöŋ adö laŋ au amöm, Ebraham böŋ nɨpe lau lö nan kub ñɨŋa. Pen bɨ gep anɨbu abe umö, rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bɨ gep anɨbu umöm, am mab ke inab yaŋ au, nɨp ilön kub yabɨƚ gö nɨŋöl gɨ mɨdmɨdöp. Pen mɨdöm gɨlaŋ gɨ nɨŋa, Ebraham Lasaras aip ke ke au laŋ mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nɨŋöm, wɨñ al hagöm haga, ‘Bapi Ebraham, yɨp mög nɨŋmön, Lasaras nɨp hagö, ñɨmagö mɨlö nɨpe ap ñɨg ap rauöm, dap aɫab yɨp u ud nɨŋö, yɨp hain gaŋ. Mab u inöm, yɨp ilön kub yabɨƚ göp,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hageia, Ebraham haga, ‘Ñɨ nöŋ! Mɨnöŋ naböŋ adö iƚ yaŋ mɨdmɨdan ñɨn u, ne nan aij aij ne udmɨdan, pen Lasaras nan naij naij nöp udmɨdöp. Pen mɨñi ram mɨnöŋ i, nɨpe hain aij mɨdö nɨŋöl gɨ, nöp ilön kub gab. ");
INSERT INTO kpw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","God nɨpe moƚ kub yabɨƚ aŋ i gɨ la u me, hon nɨbi bɨ böŋ lai raƚa gun böŋ lau nun rö lagöp; pen kale böŋ lau raƚa gɨmim böŋ lai aumim rö lagöp,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hageia, bɨ anɨbu haga, ‘Anɨg hagpan rö, Lasaras nɨp hagmön, nɨpe bapi yad ram amöm, ");
INSERT INTO kpw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mam yad unbö mamɨd u kalɨp manö kƚö yabɨƚ hagö, ram mɨnöŋ ilön ke naij pör nöp göp aui auagöl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hageia, Ebraham haga, ‘Mosɨs abe, bɨ God manö hagep bɨ gau abe, manö kalɨ kƚiñ rɨkla u nɨŋöl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hageia, haga, ‘Bapi, anɨg gagnaböl; pen nɨbi bɨ ap umöm uraköm, am hageinab me, nɨŋö hagöp, a göm, nan si nan naij gɨpal adö u, nɨhön gɨnɨg anɨg gɨpun, a göm, arö gɨnaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hageia, Ebraham haga, ‘Kale Mosɨs abe, bɨ God manö hagep bɨ gau abe, manö kalɨ kƚiñ rɨkla manö anɨbu nɨŋagpal rö, bɨ ap umöm uraknab u, kale u rö nöp nɨŋagnaböl,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas bɨ nɨpe gau kalɨp haga, “Bɨ ap aka nɨbi ap nagɨ naij adö u göm, nɨbi bɨ rɨmnap kalɨp gasɨ ñö, kale abe nagɨ naij adö anɨbu göm ap lug paknaböl. Nagɨ adö anɨbu nöd gɨmɨdal, mɨñi gɨpal, hainö u rö nöp gɨnaböl. Pen nɨbi bɨ kale gasɨ naij ñɨnaböl gau, kale ilön unbö ke yabɨƚ udnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pen bɨ ap aka nɨbi ap, ñɨ pai gau añɨ ap anɨg gɨnɨg gɨnab u, nɨp kabö kub wid paib jakep kabö ap, uŋam u halö nagɨ lɨ rɨbɨköm, dam ñɨg solwara yublap u aij. Nɨhön gɨnɨg: nɨpe kamɨŋ mɨdöm, ñɨ pai ap nɨp gö ap lug paknab u, ilön kub yabɨƚ udnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anɨb u, kale ke gasɨ nɨŋ aij gɨmim gɨmim. “Nañɨn namam ne ap nan si nan naij gainɨm, nɨp sɨƚɨk hagpe, nɨhön gɨnɨg anɨg gɨpin, a göm, gasɨ nɨŋeinab u, gɨ naij ga anɨbu nɨŋmim arö gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nan kalöp rö rɨmnap gɨ naij göm, hainö apöm, nɨhön gɨnɨg anɨg gɨpin, a göm, hageinab u, nan naij ga anɨbu nɨŋmim arö gɨmim. Pen ñɨn añɨ ap, anɨg gö gö unbö mudun jɨŋ u gɨnɨm u, u rö nöp nɨŋmim arö gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas anɨg hageia, bɨ manö nɨpe ud arep gau hagla, “Ne hanɨp gö, nɨŋ udep magö hon kub gɨnɨm,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hageila, Jisas kalɨp haga, “Nɨŋ udep magö kub wasö, nɨŋ udep magö kale mab masded magö pro yabɨƚ u rö nöp mɨdeinab u, kale mab anɨbi, iƚ halö ju ñɨg solwara aŋ au daŋ ran mɨdai, a gɨmim hagpe, hagnabim rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kale gasɨ nɨhön nɨŋbimŋ Bɨ wög gɨ ñeb bɨ ap mɨnöŋ naböŋ bɨnɨg ral pɨs göm, aka kaj sipsip muk pɨs göm, ado gɨ ram auö, bɨ nap nɨpe u nɨp manö nɨhön hagnabŋ ‘Nöp kɨyö löp u, ne aui asɨkmön nan magö ñöŋ,’ a gɨnab aka? ");
INSERT INTO kpw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wasö. Anɨg hagagnab. Nɨpe hagnab, ‘Waƚɨj udö auö, dip nagɨ u pɨg lɨmön, ñɨg nan yad gau dap ñö ñɨŋnam, hainö ñɨg nan ne gau ñöŋ,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kale gasɨ nɨhön nɨŋbimŋ Bɨ wög gɨ ñeb anɨbu, bɨ kub hagnab rö geinab u, bɨ kub manö aij rɨmnap nɨp hagnab akaŋ Wasö. Bɨ wög gɨ ñeb nɨpe mɨdöp u me, hagnab rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anɨg unbö rö me kale. God kalöp wög hag lɨnab rö, gɨ pɨs gɨmim, hagnabim, ‘Hon nɨbi bɨ wög gɨ ñeb aij wasö. Nan adö ap ke gagpun; wög hon ke gep u rö nöp gɨpun,’ a gɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalem arnam a göm, ram mɨnöŋ Sameria i, ram mɨnöŋ Galili lödaŋ aŋ au gɨdaŋ am am, ");
INSERT INTO kpw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ram rɨƚɨg agƚö ap ajö nɨŋöl gɨ, bɨ wös gɨsa la unbö sɨduŋ laŋ, nɨp nable paköm, ke ke au daŋ mɨdöm, ");
INSERT INTO kpw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","meg magö dap ranöm hagla, “Jisas, Bɨ Kub, hanɨp mög nɨŋmön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hageila, kalɨp haga, “Kale ammim, bɨ God nɨp nan sabe gep gau kalɨp hañ kale gau yammim,” a ga. Anɨg hagö, kale amöm, adan aŋ au arlö nɨŋöl gɨ, kalɨp kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pen kalɨp anɨg göl kamɨŋ lö, bɨ Sameria nɨbö ap, nɨp kamɨŋ la u nɨŋöm, manö kub hagöl gɨ, God hib u hagö adö arö nɨŋöl göm, ");
INSERT INTO kpw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ado gɨ apöm, Jisas mɨdeia söl ma iƚ au lug paköm, mulu adɨŋ nɨpe gɨyaŋ gɨ mɨnöŋ yaŋ nɨŋöm, Jisas nɨp aij a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nɨpe anɨg gö, Jisas haga, “Yad gasɨ nɨŋbin e, bɨ unbö sɨduŋ laŋ kamɨŋ löp u, pen bɨ unbö ajɨp laŋ gau mai? ");
INSERT INTO kpw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɨ rɨmnap nɨhön gɨnɨg auagpalŋ Bɨ mɨlö gau nɨbö, bɨ Juda wasö u nöp apöm God nɨp aij a göp ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas anɨg hagöm bɨ anɨbu nɨp haga, “Jisas yɨp gö kamɨŋ lɨnab, a gɨmön, nɨŋ udpan rö, nöp kamɨŋ löp aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pen ñɨn ap bɨ Perisi gau Jisas nɨp hag nɨŋöm, “God nɨbi bɨ udöm abad mɨdeinab ñɨn anɨbu ñɨn mai aunab?” ö gɨla. Hageila, Jisas haga, “God nɨbi bɨ udöm abad mɨdeinab, a gɨpim anɨbu, kiŋ rɨmnap gau, nɨbi bɨ abad mɨd mɨd, nɨŋ aij gɨlö gɨlö, hainö kiŋ kale auö, nɨbi bɨ nɨp amgö nɨŋöm, uri auöp, a gɨpal, unbö rö gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Mɨdöp i,’ aka ‘Mɨdöp daŋ,’ hagagnaböl. Nɨhön gɨnɨg: nɨpe agamɨj apöm, aŋ kalöp aui hadö mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Anɨg hagöm, bɨ nɨpe gau kalɨp haga, “Hainö gau, Bɨ Ñɨ nɨpe auö nɨp nɨŋun, a gɨmim, mɨdmagö kalöp bɨg ñöl nöp mɨdnab, pen nɨp nɨŋagnabim. ");
INSERT INTO kpw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nɨbi bɨ rɨmnap kalöp hagnaböl, ‘Mɨdöp i,’ aka ‘Mɨdöp daŋ,’ a gɨnaböl u pen manö anɨbu nɨŋö hagpal, a gɨmim, gɨ dö gɨ ammim, kalɨp aip aragmim. ");
INSERT INTO kpw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nɨhön gɨnɨg: Bɨ Ñɨ nɨpe aunab ñɨn u, añɨm añɨm udöm, mailö mɨlöbö aröp nɨŋbal u rö aunab. ");
INSERT INTO kpw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pen kale nɨbi bɨ mɨñi mɨdpim gai i, Bɨ Ñɨ nɨpe nɨp iru nɨŋmim, nɨp udagmim, nɨp marö kub yabɨƚ ñɨnabim. ");
INSERT INTO kpw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bɨ Ñɨ nɨpe aunab ñɨn anɨbu, hadame nöp Noa mɨdeia ñɨn u ga rö, gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa mɨdeia ñɨn u, nɨbi bɨ gau nan magö ñɨŋöl gɨ, ñɨg ñɨŋöl gɨ, nɨbi pen pen ñöl gɨ, gɨ mɨdlö nɨŋöl gɨ, Noa amɨlap apɨlap ñɨg magɨb kub raul mɨgan arlö nɨŋöl gɨ, möŋ asad kub yabɨƚ alabin, a gö, ñɨg uƚ apöm nɨbi bɨ gau kalɨp magöŋhalö ud yuö yuö umhakla. ");
INSERT INTO kpw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pen bɨ Lod mɨdeia ñɨn u, Sodom nɨbi bɨ gau u rö nöp nan ñɨŋöl gɨ, ñɨg ñɨŋöl gɨ, nan gau sɨkim göl gɨ, nan wög adɨŋ gau göl gɨ, ram göl gɨ, gɨ mɨdlö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lod ram mɨnöŋ anɨbu arö göm, ram mɨnöŋ mɨgan ap ke arö nɨŋöl gɨ, magö anɨbu nöp, mab mɨɫaŋ kub kumi kabö adö laŋ nɨbö apöm, Sodom nɨbi bɨ kalɨp magöŋhalö in habɨk ñɨŋ ara. ");
INSERT INTO kpw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bɨ Ñɨ nɨpe aunab ñɨn u, anɨg unbö rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ñɨn anɨbu, nɨbi bɨ ram adö laŋ mɨdaiöl u, nan kale ram raul mɨgan yaŋ mɨdöp u udnɨg ram raul yaŋ aragnaböl. Pen nɨbi bɨ wög adɨŋ gau ajaiöl gau, nan rɨmnap udnɨg ado gɨ ram aragnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lod nɨbin nɨp ga adö u nöp gasɨ nɨŋmim, nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nɨbi bɨ an, yad ke nɨŋ aij gem kamɨŋ mɨdeinabin a göm nɨŋnab u, umnab; pen nɨbi bɨ an, Krais manö aij hagöp rö wög nɨp gɨ damem umnabin a göm nɨŋnab u, kamɨŋ mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kalöp hagabin, ñɨn anɨbu sɨbön yaŋ bɨ mɨhöp abañ adö añɨ ap haneinabil u, ap udem, ap arö gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pen nɨbi mɨhöp wid magö pa jö ma jö ƚugaƚug geinabil u, ap udem, ap arö gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bɨ mɨhöp wög adɨŋ gau wög gɨ mɨdeinabil u, ap udem, ap arö gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas anɨg hageia, kale hagla, “Bɨ Kub, manö hagabön anɨbu, ram mɨnöŋ mai anɨg gɨnab?” ö gɨla. Hageila, Jisas haga, “Wal wayöŋ ap umöl mɨdeinab au, yaur gɨlgalö nɨŋöm ap sɨbaibai gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas, bɨ yad gau gasɨ iru nɨŋagöl, God nɨp sabe göl gɨ nöp mɨdaiöl, a göm, kalɨp manö ap manö hod rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ram mɨnöŋ ap, bɨ kub manö ud asɨkep bɨ ap mɨdeinab. Pen bɨ anɨbu, God nɨp gasɨ u nɨŋagöm, nɨbi bɨ gau kalɨp mög nɨŋagnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pen nɨbi adu ram mɨnöŋ anɨbu nɨbö ap, pör nöp apöm nɨp hagnab, ‘Bɨ koƚmaƚ yad ap manö halɨp u nɨŋmön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Anɨg hagnab u pen bɨ manö ud asɨkep bɨ kub anɨbu manö nɨpe u udagnab. Pen nɨbi adu anɨbu, nɨpe pör pör apöm hag nɨŋ gö gö, hainö bɨ kub anɨbu hagnab, ‘Yad God nɨp pɨñɨŋ gagpin; nɨbi bɨ gau kalɨp mög nɨŋagpin; ");
INSERT INTO kpw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pen nɨbi kaŋɨƚ i yɨp pör pör apöm hag nɨŋ gö gö yɨp iru göp u me, yad am manö kub anɨbu nɨŋnam,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bɨ Kub anɨg hagöm haga, “Bɨ manö ud asɨkep anɨbu nɨbi bɨ mög gaga, pen nɨpe manö nɨhön haga u nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kale gasɨ nɨhön nɨŋbimŋ God nɨpe nɨbi bɨ nɨpe ke hag löp gau, sɨdö aŋ sɨbön yaŋ nɨp sabe geinaböl u, manö kalɨp nɨŋöm mög nɨŋagnab, a gɨmim, nɨŋbimŋ Kale mɨlö padö abadnaböl, a gɨmim, nɨŋbim? ");
INSERT INTO kpw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yad kalöp hagabin, nɨpe manö hagnaböl anɨbu nɨŋöm, kalɨp mög nɨŋöm, yɨŋɨd nöp bɨ koƚmaƚ kale gɨ naij gɨnaböl gau adan pɨƚ gɨnab. Pen Bɨ Ñɨ nɨpe mɨnöŋ naböŋ iƚ i ado gɨ aunab ñɨn u, nɨbi bɨ rɨmnap nɨp nɨŋ udöl gɨ mɨdeinaböl aka wasö?” ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nɨbi bɨ rɨmnap, hon nɨbi bɨ aij, nɨbi bɨ rɨmnap gau nɨbi bɨ naij, a göm, nɨŋla rö, Jisas kalɨp manö ap manö hod rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bɨ Perisi ap, bɨ dakɨs udep ap, God nɨp sabe gɨnɨg, God sabe gep ram u arnabil. ");
INSERT INTO kpw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bɨ Perisi anɨbu, aŋ nɨpe gau nöp God nɨp sabe göm hagnab, ‘Nöp aij yabɨƚ a gabin. Yad bɨ rɨmnap gɨpal rö, nan aij iru nöp udem, nan si udem, nɨbi si udem, gagpin. Yad bɨ dakɨs udep inbö i rö wasö. ");
INSERT INTO kpw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wik pör pör, ñɨn mɨhöp nan magö ñɨŋagpin halö. Pör nan yad unbö sɨduŋ laŋ udem, nöp añɨ nɨbö ap ñɨbin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pen bɨ dakɨs udep anɨbu, nɨp nable gö, kumi kabö adö laŋ nɨŋagöm, ke ke au daŋ ubör yɨhöŋ göm, pabɨƚ nɨpe ke paköm, gasɨ iru nɨŋöm hagnab, ‘God, yad bɨ nan si nan naij gɨpin u, yɨp mög nɨŋmön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kalöp hagabin, bɨ dakɨs udep u anɨg hagö, God nɨp, nan si nan naij gɨpan u nɨŋem arö gɨnabin, a gɨnab. Pen bɨ Perisi u nɨp God anɨg hagagnab. Nɨhön gɨnɨg: nɨbi bɨ hib kale ke dap rannaböl gau, God gö ap lug paknaböl. Pen nɨbi bɨ ana udnaböl gau, God gö kale hib mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nɨbi bɨ gau, Jisas ñɨ pai pro hanɨp gai i ud nɨŋaŋ a göm, daueila. Jisas kalɨp ud nɨŋö nɨŋöl gɨ, bɨ nɨpe gau anɨg gajal u nɨŋöm, nɨbi bɨ anɨb gau kalɨp sɨƚɨk hagöm hagla, “Kale unbö gagmim,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisas pen ñɨ pai anɨb gau wɨñ alö aueila, bɨ nɨpe gau kalɨp haga, “Nɨhön gɨnɨg kalɨp anɨg hag gabimŋ Ñɨ pai pro anɨb gau arö gɨpe yɨp aulaŋ. God nɨbi bɨ udöm kumi kabö adö laŋ abad mɨdeinab u, ñɨ pai pro anɨb gau rö mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","God Manö hag ñöm anɨg göl mɨdöp a geinaböl u, ñɨ pai pro gau God Manö anɨbu nɨŋöm, yɨŋɨd nɨŋ udnaböl. Anɨb u, yad kalöp nɨŋö hagabin, nɨbi bɨ ñɨ pai pro yɨp nɨŋ udpal rö, nɨŋ udeinaböl gau, God kalɨp udöm abad mɨdeinab. Pen nɨbi bɨ ñɨ pai pro yɨp nɨŋ udpal rö, nɨŋ udageinaböl gau, God ram mɨnöŋ nɨpe au aragnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda bɨ kub ap Jisas mɨdeia au apöm haga, “Bɨ manö hag ñeb bɨ aij yad. Yad nɨhön gem, pör mɨdep u udnam?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Hageia, Jisas haga, “Yɨp nɨhön gɨnɨg, ‘Bɨ aij,’ a gɨpan? Nɨbi bɨ ap aij mɨdagöp; God añɨ me Bɨ aij mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pen ne God lo manö u nɨŋban: ‘Nɨbi si bɨ si gagmim; wip alagmim; nan si udagmim; manö kub hagnaböl gau am manö piral hagagmim; name nap hagmil adö u nöp nɨŋmim, hain gɨmim,’” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Anɨg hageia, bɨ anɨbu haga, “Yad ñɨ pro nöp rɨkem, lo manö adö anɨb gau magöŋhalö gɨ dap dap, mɨñi ñɨn i u rö nöp gɨ mɨdpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas manö anɨbu nɨŋöm haga, “Nan añɨ ap nöp gagpan. Nan ne gau magöŋhalö sɨkim gɨmön, mani udmön, nɨbi bɨ mög gep rö gau kalɨp ñɨmön me, mɨd aij gep ne u mɨdeinab God ram mɨnöŋ kumi kabö adö laŋ au. Hagpin rö gɨmön, aumön, yad aip ajaiul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Juda bɨ kub anɨbu, mani nan nɨpe gau iru nöp mɨdeia rö, Jisas manö anɨbu hagö, nan nɨpe hib gö, gasɨ mɨlö la. ");
INSERT INTO kpw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gasɨ mɨlö leia u, Jisas nɨp nɨŋöm haga, “Nɨbi bɨ nan iru mɨdeinab gau, uɫham yabɨƚ God nɨbi bɨ nɨpe mɨdlö, kalɨp udöm, ram nɨpe au abad mɨdnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kaj kamel gau kalɨ mauöƚ nagɨ yubal mɨgan u arnɨg, uɫham arnaböl u pen nɨbi bɨ uɫpö kɨƚno nan gau iru nöp mɨdöp gau, God ram mɨnöŋ nɨpe u uɫham yabɨƚ arnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Anɨg hageia, nɨbi bɨ mɨdeila gau hagla, “Manö hagabön anɨbu, God nɨpe nɨbi bɨ ap ud kamɨŋ yunɨm rö lagöp aka nɨhön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hageila, Jisas haga, “Adö rɨmnap nɨbi bɨ göl rö lagöp u pen God nɨpe gɨnɨg, gɨnɨm rö nöp löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anɨg hageia, Pida haga, “Nöŋ! Ram nan hon gau magöŋhalö arö gun, nöp aip nöp se gɨ ajmɨdun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hageia, Jisas kalɨp haga, “Kalöp nɨŋö hagabin, nɨbi bɨ, God manö aij nɨpe u ud ajaiun, a göm, ram, nɨbin, nɨmam, nɨme nap, ñɨ pai kale gau arö gɨnaböl gau, God kalɨp hauƚ gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mɨñi mɨdpun ñɨn aŋ i, God nɨpe kalɨp abad mɨd aij gö, nan kale gau, nɨbi bɨ kale gau iru nöp mɨdeinab. Pen ñɨn hain u, nɨpe aip pör pör nöp mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas bɨ nɨpe unbö mɨgan laŋ kalɨp dam goƚ gau amöm haga, “Nɨŋim. Mɨñi Jerusalem arabun. Amjaknabun u, Bɨ Ñɨ nɨpe nɨp, God manö hagep bɨ gau hadame nöp God Manö u kalɨ kƚiñ rɨköm hagla rö nöp gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nɨp udöm, bɨ Juda wasö gau ñɨmagö adö kalɨp lɨlö, nɨp hag juöm, ñɨƚoŋ löl göm, kɨñu alöm, nagɨ ud paköm, böŋ nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pen ñɨn mɨhöp mɨdöm, ruö ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pen Jisas anɨg hageia, bɨ nɨpe gau gasɨ pɨral hiɨknɨm rö lagö, manö hagab adö u, a göm, nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pen hain, Jisas am Jeriko amjakö nɨŋöl gɨ, bɨ amgö we ap mɨdeia. Bɨ anɨbu nɨpe adan goƚ au asɨk mɨdöm, mani nan ñim, a göm, asɨb gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nɨbi bɨ iru nöp manö hag padilö nɨŋöl gɨ, nɨbi bɨ rɨmnap kalɨp hag nɨŋöm haga, “Nɨhön gaböl?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hageia hagla, “Jisas bɨ Nasared nɨbö u apöm padiab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Anɨg hageila, nɨpe wɨñ kub alöm haga, “Jisas, Depid Ñɨ nɨpe, yɨp mög nɨŋmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hageia, nɨbi bɨ padieila gau nɨp hag göm hagla, “Nɨhön gɨnɨg ap ranabön? Agamɨj mɨd!” a gɨla. Anɨg hagla u pen nɨpe agamɨj mɨdageia. Wɨñ kub yabɨƚ alöl gɨ haga, “Jisas, Depid Ñɨ nɨpe, yɨp mög nɨŋmön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hageia, Jisas nɨŋöm pɨdöŋ göm, nɨbi bɨ gau kalɨp haga, “Paŋɨd söl aui dauim,” a ga. Hagö, paŋɨd daueila haga, ");
INSERT INTO kpw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nöp nɨhön gɨnam?” ö ga. Hageia haga, “Bɨ Kub, yɨp gö amgö magö u kauyaŋ nɨŋɨn,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hageia, Jisas nɨp haga, “Jisas yɨp gö, amgö magö ñɨl nɨŋnabin, a gɨmön, gasɨ nɨŋ udpan rö, amgö magö ñɨl nöŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hagö, magö anɨbu nöp amgö ñɨl nɨŋöm, God hib nɨpe u hagö adö arö nɨŋöl göm, Jisas areia au hain ga. Nɨbi bɨ magöŋhalö Jisas ga anɨbu nɨŋöm, God hib nɨpe u haglö adö ara. ");
INSERT INTO kpw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jeriko amöm, aŋ anɨb au ap padia. ");
INSERT INTO kpw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pen Jeriko au, bɨ mani nan gau iru mɨdmɨdöp ap, bɨ dakɨs bɨ udmɨdal gau kalɨp magöŋhalö abad mɨdmɨdöp. Hib nɨpe Sakias. ");
INSERT INTO kpw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas daun aŋ au padiö nɨŋöl gɨ, nɨbi bɨ iru nöp ap nɨŋnɨg geila. Sakias nɨpe bɨ uƚep magö u me, Jisas bɨ aigale bɨ rö mɨdöp u nɨŋɨn, a göm, nɨŋa u pen nɨŋaga. ");
INSERT INTO kpw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Anɨg gö, nɨpe nöd gɨ dö gɨ am mab ur ap ran adö laŋ amöm, Jisas auaia padö jɨŋ nɨŋöl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas pen mab ran mɨdeia iƚ anɨb au apöm, gɨlaŋ gɨ nɨŋöm, Sakias nɨp haga, “Sakias, ne yɨŋɨd iƚ i lug! Mɨñi am ram ne u aip mɨdeinabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hageia, Sakias iƚ yaŋ lugöm, mɨñ mɨñ göl gɨ, Jisas nɨp uɫ gɨ dam ram nɨpe ud ara. ");
INSERT INTO kpw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nɨbi bɨ gau ga anɨbu nɨŋlö mulu lugö hagla, “Bɨ anɨbu am bɨ nan si nan naij göp ram u hannɨg arab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pen Sakias uraköm, Jisas nɨp haga, “Bɨ Kub, ne nöŋ! Mɨñi nan yad gau nɨme lɨ böŋ u lem, böŋ u nɨbi bɨ mög gep rö gau kalɨp ñɨnabin. Pen yad nöd pir alem, nɨbi bɨ rɨmnap nan kale si udnö rö löp gau pen ñɨnabin, a gem, nan añɨ ap si udnö rö, pen mɨhau mɨhau ñɨnabin; pen nan mɨhöp si udnö rö, pen unbö raleb jɨŋ u ñɨnabin. Anɨg gɨ dam dam magöŋhalö naböŋ ral pɨs gem, arö gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hageia, Jisas haga, “Bɨ i Ebraham ñɨ nɨpe ap. Uri God nɨpe yam ram aui hanbal nan si nan naij gɨpal gau nɨŋöm arö göm ud kamɨŋ yuöp. ");
INSERT INTO kpw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bɨ Ñɨ nɨpe aua u, nɨbi bɨ hir gɨpal gau, kalɨp uƚhai nɨŋem ud kamɨŋ yunam, a göm, aua,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pen nɨbi bɨ anɨb gau, Jisas me, Bɨ Kub pör abad mɨdpun u, Jerusalem arö, nɨp kiŋ hag lɨno, hanɨp abad mɨdö, mɨd aij yabɨƚ gɨnabun, a göm gasɨ u nɨŋla. Jisas, gasɨ kalpe nɨŋla anɨbu, ke nɨŋöm, kalɨp manö ap halö hod rɨköm haga. ");
INSERT INTO kpw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jisas manö hod rɨköm haga, “Bɨ kub ap, bɨ kub abad mɨdep yad mɨdöp au arnö, yɨp kiŋ hag lö, ado gɨ apem, nɨbi bɨ ram mɨnöŋ yad gai i kalɨp kiŋ abad mɨdeinam, a göm, ram mɨnöŋ mɨlö kub gau arnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pen nöd bɨ wög gep nɨpe unbö sɨduŋ laŋ kalɨp wɨñ alö aueinaböl, bɨ kub nɨpe kabö magö gol añɨ añɨ ke ke nɨme löm hagnab, ‘Mani ñabin i udmim, sɨkim gɨ ado malo gɨmim, iru ud lɨmim; hainö yad kauyaŋ aunabin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Anɨg hagöm arnab u, pen nɨbi bɨ ram mɨnöŋ nɨpe abad mɨdeia gau, nɨp mulu lugö nɨŋöl göm, bɨ rɨmnap hag yulö, hain amöm, bɨ kub yabɨƚ u nɨp hagnaböl, ‘Bɨ anɨbi nɨpe kiŋ hon mɨdagnab,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pen bɨ kub yabɨƚ u manö kale u udagöm, bɨ kub anɨbu nɨp kiŋ kale hag lɨnab. Anɨg gö, nɨpe kauyaŋ ado gɨ apöm, bɨ wög gɨ ñeb nɨpe gau kalɨp wɨñ alö aueinaböl, kiŋ kale u hagnab, ‘Kabö magö gol ñɨbin gau, kale ud sɨkim gɨ ado malo gɨmim, pen aigöl gɨ udpim?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hagö, bɨ nöd u apöm hagnab, ‘Bɨ kub, kabö magö gol añɨ yɨp ñɨna u, sɨkim gɨ ado malo gem, pen unbö sɨduŋ laŋ kabö magö gol udpin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hageinab, bɨ kub nɨpe u hagnab, ‘Ne gɨ aij gɨpan. Nan pro u ñɨnö wög gɨ aij gɨpan rö, mɨñi daun kub unbö sɨduŋ laŋ nöp hagnö, abad mɨdeinabön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pen bɨ ap apöm hagnab, ‘Bɨ kub, kabö magö gol añɨ yɨp ñɨna u, sɨkim gɨ ado malo gem, pen unbö mamɨd u kabö magö gol udpin,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hageinab, bɨ kub nɨpe u hagnab, ‘Gɨpan anɨbu rö, mɨñi daun kub unbö mamɨd u nöp hagnö, abad mɨdeinabön,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pen bɨ wög gep nɨpe ap apöm hagnab, ‘Bɨ kub, yad nöp nɨŋbin. Ne bɨ kal yabɨƚ. Nɨbi bɨ rɨmnap nan kale gau, ne sɨkim gɨ aij gɨmön wasö, rau pɨƚɨ gɨmön rö udpan. Nan wög uɫham gɨ yɨmbal gau, ne kƚö gɨmön nöp ñɨŋban. Anɨb u, yad nöp pɨñɨŋ gem me, kabö magö gol añɨ yɨp ñɨna u, dam apo rin ugan gɨ lɨnö mɨdeia. Magö gol añɨ ne u mɨñi daubin i,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hageinab, bɨ kub nɨpe u hagnab, ‘Manö ne hagpan u ud ado gem, manö kub ne aip hagnabin. “Ne bɨ kal yabɨƚ, nɨbi bɨ rɨmnap nan kale gau, ne sɨkim gɨ aij gɨmön wasö, rau pɨƚɨ gɨmön rö udpan; nan wög uɫham gɨ yɨmbal gau, ne kƚö gɨmön nöp ñɨŋban,” a gɨpan ar? ");
INSERT INTO kpw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Anɨb u, nɨhön gɨnɨg kabö magö yad u dam beg pasbuk lö, ado gɨ apem sinɨŋ rɨmnap halö udagpin?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anɨg hagöm, bɨ söl au mɨdeinaböl gau kalɨp hagnab, ‘Kabö magö gol yad u pɨƚɨ gɨ udmim, bɨ au kabö magö gol sɨduŋ laŋ mɨdöp u nɨp ñim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hageinab hagnaböl, ‘Bɨ kub. Nɨpe kabö magö gol sɨduŋ laŋ hadö mɨdöp!’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hageinaböl hagnab, ‘Kalöp hagabin, pör nɨbi bɨ nan kale iru mɨdeinab gau rɨmnap halö udnaböl, pen nɨbi bɨ nan kale pro pro mɨdeinab gau gɨlö, nan pro anɨbu böŋ nöp lug lɨ arnab. ");
INSERT INTO kpw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pen nɨbi bɨ yɨp nɨŋlö mulu lugö, bɨ anɨbu nɨpe kiŋ hon mɨdageinab, a gɨla gau, kalɨp am dapim, amgö ilö adö yad aui al pak lim,’ a gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas kalɨp manö anɨbu hagöm, bɨ nɨpe gau aip Jerusalem arun, a göm, nɨpe nöd ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Am am Olip Dum au, ram rɨƚɨg agƚö Bedpagi Bedani goƚ au söl amjaköm, bɨ nɨpe mɨhöp kalɨp nöd hag yuöm haga, ");
INSERT INTO kpw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ram rɨƚɨg agƚö mɨgan lödaŋ ammil nɨŋnabil, kaj donki marep nɨbi bɨ ud ajagpal ap, nagɨ adɨk lɨlö mɨdeinab u, hubɨk daumil. ");
INSERT INTO kpw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pen nɨbi bɨ rɨmnap apöm, ‘Kaj donki u nɨhön gɨnɨg hubɨk ud arabil,’ a gaiöl u, hagmil, ‘Bɨ Kub u wög mɨdö halɨp hag yuajɨp, udnɨg aubul,’ a gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Anɨg hagö, ammil nɨŋlö, haga rö nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am nagɨ hubɨk gɨlö nɨŋöl gɨ, bɨ kaj donki nap nɨbö gau apöm hagla, “Kaj donki marep u nɨhön gɨnɨg gɨmil nagɨ hubɨkabil?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hageila haglö, “Bɨ Kub u wög mɨdö halɨp hag yuajɨp, apul nagɨ hubɨkabul,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Anɨg hagmil, kaj donki marep anɨbu nagɨ hubɨkmil, uɫ gɨ dam Jisas mɨdeia au amjakmil, waƚɨj kale bad rɨmnap ud jumil, ud kaj donki adö u lɨmil, Jisas nɨp ud kaj donki adö anɨb laŋ lɨla. ");
INSERT INTO kpw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas donki adö laŋ asɨköm, adan adö u arö nɨŋöl gɨ, nɨbi bɨ gau waƚɨj nan kale rɨmnap dap adan adö anɨbu lɨlö nɨŋöl gɨ, kaj donki Jisas asɨk mɨdeia anɨbu waƚɨj nan kale adö anɨbu abö göl gɨ abö göl gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am am Jerusalem sösöl gɨlö nɨŋöl gɨ, Olip Dum adan ramö gɨyaŋ gep ka au, nɨbi bɨ nɨpe gau iru yabɨƚ nöp, magöŋhalö nɨp mɨñ mɨñ yabɨƚ göl gɨ, nan nɨhön nɨhön ga gau gasɨ u nɨŋöl gɨ, wɨñ kub alöl gɨ, God hib nɨpe dap ranöm hagla, ");
INSERT INTO kpw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bɨ Kub nɨpe Kiŋ hanɨp hag yuö auöp i, God nɨp ud aij gɨnɨm! God ram mɨnöŋ kumi kabö adö laŋ au, hibur hain hain magö u nöp mɨdöp. God nɨpe adö i gɨlaŋ mɨdöm, nɨpe mailö aij unbö ke halö mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Anɨg haglö nɨŋöl gɨ, bɨ Perisi rɨmnap aŋ anɨb au mɨdeila gau, Jisas nɨp hagla, “Manö hag ñeb bɨ. Nɨbi bɨ ne gau kalɨp hag gö, anɨg unbö rö hagaglaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hageila, Jisas pen haga, “Kalöp hagabin, kale manö anɨbu rö hagageinaböl u, kabö gau ke wɨñ alnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem sösöl göl gɨ, daun kub anɨbu nɨŋöm, amgö ñɨg lugö nɨŋöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ram mɨnöŋ Jerusalem i, kalöp mög yabɨƚ nɨŋabin. Yad kalöp ud God aip jɨm ñem, hibur hain hain magö u kalɨp ñɨnɨg aunö u nɨŋbep u, aij yabɨƚ gɨböp. Pen mɨñi kale nɨŋagmim, amgö we rö mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hainö bɨ koƚmaƚ kale apöm, daun kub kale i, uƚɨŋɨn lɨ gɨgabö gɨ mɨdöm, ");
INSERT INTO kpw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","apöm gɨ naij yabɨƚ gɨlö, wög waryö, ram gau magöŋhalö, kabö ap kabö ap adö laŋ waköm mɨdageinab; nɨbi bɨ, ñɨ pai, kabö waryö raul aŋ yaŋ mɨdeinaböl gau ram halö pa jö ma jö gɨ yunaböl. God kalöp udnɨg auöp ñɨn i nɨŋagpim u me, anɨg gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas anɨg hagöm, God sabe gep ram u amöm, nɨbi bɨ sɨkim geila gau kalɨp hag höŋ yuöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“God Manö u kalɨ kƚiñ rɨköm hagla, ‘Ram yad u, yɨp sabe gep ram mɨdeinab,’ a gɨla u pen kale sɨkim gɨ gɨpe gɨpe, nɨbi bɨ nan si udöm, dap pi göl hanbal ram ap rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pen Jisas nɨpe pör pör, ñɨn añɨ añɨ am God sabe gep ram raul mɨgan u, nɨbi bɨ gau kalɨp manö hag ñɨmɨdöp. Bɨ God nɨp nan sabe gep bɨ kub gau, bɨ lo manö hag ñeb bɨ gau, bɨ manö ud asɨkep gau, nɨp al pak lun, a göm, gasɨ añɨ u nɨŋeila. ");
INSERT INTO kpw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Anɨg gasɨ nɨŋla u pen nɨbi bɨ magöŋhalö, manö aij nɨpe nɨŋun, a göm, nɨp ñɨñɨ lɨlö nɨŋöl gɨ, kale Jisas nɨp al pak löl rö laga. ");
INSERT INTO kpw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pen ñɨn aŋ anɨb au, Jisas nɨpe God sabe gep ram raul mɨgan u amöm, nɨpe nɨbi bɨ ud God aip jɨm ñöl lɨnab manö aij u hag ñɨ mɨdeia nɨŋöm bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, bɨ manö ud asɨkep gau abe aula. ");
INSERT INTO kpw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Apöm nɨp hagla, “An nöp hagö, ne apön anɨg gɨ ajabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Hageila haga, “Yad kalöp pen hag nɨŋeb ap hag nɨŋnɨg gabin. ");
INSERT INTO kpw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon nɨbi bɨ gau kalɨp ñɨg pak ñɨmɨdöp u, God nɨp hagö anɨg ga aka gasɨ nɨpe ke nɨŋöm ga?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hageia, kale ke hag nɨŋ hag nɨŋ göm hagla, “‘God hagö, Jon nɨbi bɨ gau kalɨp ñɨg pak ña,’ a gɨnabun u, nɨpe hagnab, ‘Anɨb u, manö nɨpe u nɨhön gɨnɨg udagpim?’ ö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pen, ‘Jon gasɨ nɨpe ke nöp nɨŋöm, nɨbi bɨ gau kalɨp ñɨg pak ña,’ a geinabun u, nɨbi bɨ gai i, God nɨpe Jon manö hagep bɨ nɨpe rö hag lö apöm gaia a göm nɨŋbal rö, kal juöm hanɨp kabö ju pak lɨnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pen kale gasɨ anɨbu nɨŋöm, Jisas nɨp pen hagla, “Jon apöm nɨbi bɨ gau kalɨp manö hag ñöm, ñɨg pak ñöm ga u, hon nɨŋagpun, God hagö ga aka gasɨ nɨpe ke ga u nɨŋagpun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Anɨg hageila, Jisas kalɨp haga, “Kale yɨp pen hag ñagpim rö, yad pen an hagö apem gabin u, kalöp u rö nöp hag ñagnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas nɨbi bɨ gau kalɨp manö hod rɨköm haga, “Bɨ ap wain wög adɨŋ ap gɨ yɨmöm, nɨbi bɨ rɨmnap hag löm, am ram mɨnöŋ mɨlö gau mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pen wain magö po gɨnab magö u, bɨ nɨpe ap hag yuöm hagnab, ‘Am nɨbi bɨ wain wög gɨ mɨdpal gau kalɨp hagö, wain magö yɨp rɨmnap ñɨlö daumön,’ a gɨnab. Hagö amjakö, nɨbi bɨ wain wög gɨ mɨdeinaböl gau nɨp pak pak löm, yɨharɨŋ hag yulö ado gɨ aunab. ");
INSERT INTO kpw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Anɨg gɨlö, bɨ wain wög nap nɨbö u, bɨ ap pen hag yuö arnab. Areinab nɨp u rö nöp pak pak löm, yɨharɨŋ hag yulö ado gɨ aunab. ");
INSERT INTO kpw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Anɨg gɨlö, bɨ hainbö ap hag yuö amjakö, nɨp mɨñu magö paköm, ɫɨp gɨ dam höŋ au yaŋ yunaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Anɨg gɨlö, bɨ wög adɨŋ nap nɨbö u hagnab, ‘Yad ai gɨnamŋ Ñɨ mɨdmagö yad u yunabin u, manö nɨpe hageinab rö nɨŋöl rö löp,’ a göm yunab. ");
INSERT INTO kpw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yuö amjakö, nɨbi bɨ wain wög gɨ mɨdeinaböl anɨb gau hagnaböl, ‘Ñɨ auöp i, nap wain wög u nɨpe udnɨm rö löp. Nɨp böŋ nöp al pak lun, hon udun,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Anɨg hagöm, nɨp ɫɨp ɫɨp gɨ dam höŋ gau amöm, böŋ nöp al pak lɨlö umnab. “Pen anɨg geinaböl u, bɨ wög adɨŋ nap nɨbö u kalɨp nɨhön gɨnab? ");
INSERT INTO kpw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nɨpe apöm, nɨbi bɨ anɨb gau kalɨp al pak löm, wög adɨŋ anɨbu nɨbi bɨ rɨmnap kalɨp pen hagö abad mɨdeinaböl,” a ga. Jisas anɨg hageia, nɨbi bɨ nɨŋ mɨdeila gau hagla, “Hagpan anɨbu rö gagnɨm!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hageila, Jisas kalɨp nɨŋ gusgus göm haga, “Anɨg hagpim u pen anɨb u, God Manö kalɨ kƚiñ rɨkla adɨŋ ap rɨk nɨŋmim iƚ u yɨp hag ñɨmim. Adɨŋ hagabin anɨbu anɨg göl mɨdöp, ‘Bɨ ram gep gau, kabö ap aij gagnɨm a göm arö gɨla u pen mɨñi ram padö aŋ yaŋ u bɨnɨg ñöl mɨdöp,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Nɨbi bɨ an an ap lug kabö adö anɨbu paknaböl gau, kalɨp böŋ nöp pa jö ma jö gɨ lɨnab. Pen kabö anɨbu pɨg ju ap lug nɨbi bɨ pak rɨbɨknab u, kalɨp böŋ nöp paib waib jö gɨ lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas anɨg hageia, hanɨp nöp hagab a göm, bɨ lo manö hag ñeb bɨ gau abe, bɨ God nɨp nan sabe gep bɨ kub gau abe, uri nöp nɨp manö kub hagun a göm nɨŋla u pen nɨbi bɨ iru nöp nɨŋ mɨdeila gau nɨŋöm, pɨñɨŋ göm arö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pen Jisas nɨp aige göl gun dam manö kub hagnɨg arun a göm, am nɨbi bɨ rɨmnap kalɨp mumug göm hagla, “Kale nɨbi bɨ aij rö halu lɨmim, am manö pir pir almim, nɨp manö rɨmnap hagpe, pen nɨhön hagainɨm nɨŋun, nɨp dam gapman bɨ manö kub ud asɨkep u ud arnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anɨg haglö, amöm nɨp manö rɨmnap piral hagöm hagla, “Manö hag ñeb bɨ, hon nɨŋbun ne böŋ lap nöp aragpan; kabö göl nöp hagpan. God Manö u nɨbi bɨ gau kalɨp hag ñɨban u, u rö nöp kabö göl nöp hagpan. ");
INSERT INTO kpw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Anɨb u, hon nɨhön gun? Rom gapman bɨ kub Sisa nɨp dakɨs ñun aka wasö?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kale manö pir pir hagla anɨbu nɨŋöm, Jisas kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mani dakɨs ñɨbal anɨbu ap yɨp ud yambe nɨŋɨn,” a ga. Hageia, ud yamla nɨŋöm haga, “Mani ba u, ana an rö mɨdöpŋ Hib kalɨ kƚiñ rɨkla anɨbu, an hib rö mɨdöp?” ö ga. Hageia hagla, “Sisa ana nɨpe u mɨdöm, hib nɨpe u mɨdöm göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hageila, kalɨp haga, “Anɨb u, Sisa nan nɨpe mɨdainɨm, Sisa nɨp ñɨmim. God nan nɨpe mɨdainɨm, God nɨp ñɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas nɨpe nɨbi bɨ mɨdeila aŋ anɨb au anɨg hageia, manö nɨpe rɨb juöl rö lagö, gasɨ iru nɨŋöm manö ap hagagla. ");
INSERT INTO kpw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi gau, nɨbi bɨ umöm urakagnaböl a göm, gasɨ u nɨŋmɨdal. Pen Sadyusi bɨ rɨmnap Jisas mɨdeia au apöm, nɨp hag nɨŋeb ap hag nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hag nɨŋöm hagla, “Manö hag ñeb bɨ. Mosɨs manö ap hanɨp kalɨ kƚiñ rɨköm haga, ‘Bɨ ap nɨbi udöm, ñɨ pai yag dapöm wasö yɨharɨŋ umnab u, nɨmam nɨpe ap pen nɨbi anɨbu udöm, ñɨ pai nɨpe u, a göm, yag daunɨm,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Anɨb u, bɨ iƚ halö unbö mudun jɨŋ u mɨdeinaböl. Nɨmam nöd u nɨbi udöm, ñɨ pai yag dapöm wasö yɨharɨŋ umnab. ");
INSERT INTO kpw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Umö, nɨmam yɨgwö aŋ nɨbö u pen nɨbi anɨbu udöm, u rö nöp ñɨ pai yag dapöm wasö, yɨharɨŋ umnab. ");
INSERT INTO kpw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Anɨg gö, nɨmam yɨgwö nɨgaŋ nɨbö u pen nɨbi anɨbu udöm, u rö nöp ñɨ pai yag dapöm wasö, yɨharɨŋ umnab. Anɨg gɨ dam dam, nɨmam unbö mudun jɨŋ magöŋhalö ñɨ pai yag dapöm wasö yɨharɨŋ umnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hainö nɨbi anɨbu u rö nöp umnab. ");
INSERT INTO kpw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pen umöm uraknaböl a gɨpan u, nɨbi añɨ anɨbu bɨ nɨpe unbö ud mudun jɨŋ lɨnab u, hainö bɨ an nɨbi mɨdeinab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hageila, Jisas kalɨp haga, “Mɨñi mɨdpun ñɨn i, nɨbi gau bɨ udpal, bɨ gau nɨbi udpal. ");
INSERT INTO kpw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pen nɨbi bɨ God gö uraköm, ram nɨpe kumi kabö adö laŋ au arnaböl gau, nɨbi gau bɨ udagnaböl, bɨ gau nɨbi udagnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pen kale kauyaŋ umagnaböl; ejol gau rö pör pör nöp kamɨŋ mɨdeinaböl. Kale uraknaböl u me, God ñɨ pai nɨpe mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nɨbi bɨ umöm urakpal manö u, Mosɨs u rö nöp mab ineia aiud u hagöm kalɨ kƚiñ rɨka. Mosɨs manö anɨbu kalɨ kƚiñ rɨköm haga, ‘Bɨ Kub nɨpe Ebraham, Aisak, Jekop, God kale mɨdöp,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nɨbi bɨ nöd umla gau, ‘God kale mɨdöp,’ a ga rö, hon nɨŋbun, nɨbi bɨ nöd umla gau uri kamɨŋ mɨdpal. God nɨŋöb, nɨbi bɨ nɨpe magöŋhalö kamɨŋ mɨdpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas anɨg hageia, bɨ lo manö hag ñeb bɨ rɨmnap hagla, “Manö hag ñeb bɨ, manö kabö göl nöp hagpan!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Manö hag aij ga anɨbu nɨŋöm, pɨñɨŋ göm, hainö manö rɨmnap nɨp hag nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pen Jisas kalɨp haga, “Nɨbi bɨ gau nɨhön gɨnɨg, Mesaia u Depid ñɨ nɨpe u nöp mɨdöp, a gɨpal? ");
INSERT INTO kpw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Depid nɨpe ke God Manö adɨŋ Sam a gɨpal u kalɨ kƚiñ rɨköm haga, ‘Bɨ Kub nɨpe Bɨ Kub yad nɨp haga, “Ne ñɨmagö yɨjɨg yad lau adö asɨk mɨdmön; ");
INSERT INTO kpw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mɨd damöm yad koƚmaƚ ne gau kalɨp gɨnö, ma mo ne gau kalɨp abö gɨ rɨbɨknabön,”’ a ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pen Depid nɨpe Mesaia u nɨp, ‘Bɨ Kub yad,’ a ga rö, nɨhön gɨnɨg, Mesaia u Depid ñɨ nɨpe u nöp mɨdöp, a gɨpal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nɨbi bɨ gau nɨŋmɨdlö nɨŋöl gɨ, Jisas bɨ nɨpe gau kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kale lo manö hag ñeb bɨ gau gɨpal rö gɨmim rö löp u, nɨŋ aij gɨmim. Kale gɨpal adö u, hon gau ajno hib hon u nöp ñɨlaŋ a göm, waƚɨj mɨlö rol göm, nɨbi bɨ gau aip magum gɨlö, nɨbi bɨ gau kalɨp nɨŋöm, ‘Bɨ kub auabim e!’ gɨnaböl u, mɨñ mɨñ gɨnaböl; Juda magum gep ram gau amöm, bɨ kub asɨkpal sea adö u asɨkpal; pen nan kub ñɨŋnaböl ñɨn u, am bɨ kub asɨkpal ka u nöp asɨknaböl. ");
INSERT INTO kpw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɨ lo manö hag ñeb bɨ gau, nɨbi paƚpaƚ ram nan kale gau si udöm, God nɨp sabe gɨnabun u, nɨbi bɨ nɨŋöl, a göm, manö mɨlö kub pir pir adö rɨmnap hagpal. Anɨg gɨpal u, hainö ilön kub ke yabɨƚ udnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas God sabe gep ram raul mɨgan am mɨdöm nɨŋa, nɨbi bɨ mani halö gau mani rɨmnap dap mab ij mɨgan u yueila. ");
INSERT INTO kpw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pen nɨbi adu mög gep rö ap mani aɫɨ pro magö mɨhöp dap yua. ");
INSERT INTO kpw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Anɨg ga nɨŋöm Jisas haga, “Yad kalöp nɨŋö hagabin, nɨbi bɨ rɨmnap mani pro yubal; pen nɨbi adu mög gep rö i mani nɨpe kub yabɨƚ yuöp. ");
INSERT INTO kpw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pen nɨbi bɨ rɨmnap mani kale iru nöp mɨdö nɨŋöl gɨ mani yubal; jɨ nɨbi adu mög gep rö i mani nɨpe mɨdöp rö magöŋhalö yuöp. Nan rau ñɨŋeb ap mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pen bɨ nɨpe rɨmnap hagla, “God sabe gep ram i kabö aij aij, nan aij aij dap God nɨp ñöm rɨb adɨk ñɨla u, aij yabɨƚ mɨdöp,” a gɨla. Anɨg hageila, Jisas kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Anɨg hagpim u pen hainö nan aij nɨŋabim anɨb gau mɨdageinab. Magöŋhalö ud waƚ gɨ yulö, kabö ap kabö ap adö u mɨdageinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hageia, nɨp hag nɨŋöm hagla, “Manö hag ñeb bɨ. Nan anɨbu ñɨn mai rö anɨg gɨnabŋ Pen nan nɨhön rö gö nɨŋun, mɨñi gɨnɨg gab a gɨnabun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hageila, Jisas kalɨp haga, “Nɨŋ aij gɨmim! Nɨbi bɨ iru nöp apöm pir alöm, hib yad u udöm hagnaböl, ‘Yad nöp auabin. Ñɨn kub u auöp,’ a gɨnaböl. Anɨg hageinaböl u, nɨŋö hagaböl a gɨmim kalɨp hain gagmim. ");
INSERT INTO kpw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pen ram mɨnöŋ mɨgan rɨmnap uraköm, ram mɨnöŋ mɨgan rɨmnap aip pen pen gɨnaböl. Ram mɨnöŋ mɨgan rɨmnap kale ke nöp pen pen gɨnaböl. Anɨg geinaböl u nɨŋmim, ñɨn kub hagpal u aunɨg gab nɨŋöm anɨg gaböl a gɨmim, pɨñɨŋ gagmim. Ñɨn kub anɨbu hainö aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Anɨg hagöm kalɨp haga, “Ram mɨnöŋ mɨgan rɨmnap uraköm, ram mɨnöŋ mɨgan rɨmnap aip pen pen gɨnaböl. Kiŋ rɨmnap yam kale uraköm, kiŋ rɨmnap yam kale aip pen pen gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ram mɨnöŋ gau iru nöp munmon kub yabɨƚ udöm, kɨyö kub alöm, mɨña kub yabɨƚ göm gɨnab. Nan kumi kabö adö laŋ au ke hain nɨbö löm, nan unbö ke pɨñɨŋ gep rö adö laŋ au lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nan anɨb gau hainö anɨg gɨnab jɨ nöd yɨp pɨg aip mɨdpim rö, kalöp gɨ naij gɨnaböl. Kalöp manö kub hagnɨg, dam Juda magum gep ram gau amöm, manö kub hagöm, kalöp nagɨ löm, dam kiŋ gapman bɨ kub gau ud arnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kalöp gɨnaböl anɨbu, manö aij yad u kalɨp waiö hag ñɨmim rö lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pen kalöp manö kub hagaiöl u, manö nɨhön rö pen hagun a gɨmim, nöd uƚhai nɨŋagmim. ");
INSERT INTO kpw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yad ke kalöp gasɨ aij ñem manö magö ñɨnö, kale manö anɨbu nöp hag ñɨbe, kale pen hagöm ud yuep rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pen name nap, namam bɨ, bɨ rɨdɨk nɨŋeb, bɨ nɨŋeb kale ke rɨmnap kalöp mumug göm, ud koƚmaƚ ñɨmagö adö lɨlö, kalöp rɨmnap böŋ nöp al pak lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yɨp nɨŋ udpim rö, nɨbi bɨ gau magöŋhalö kalöp mulu kal nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pen nabɨc umagö kale añɨ ap ur gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pen yɨp cɨg pɨdöŋ gɨ mɨdeinabim u, kamɨŋ mɨdep magö u udmim, pör pör nöp mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pen ami bɨ gau apöm, Jerusalem bɨnöm yu gɨgabö gɨnaböl ñɨn u, mɨñi söl mɨdöp Jerusalem gɨ naij gɨnaböl, a gɨmim nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nɨbi bɨ ram mɨnöŋ Judia mɨdaiöl gau, pɨñɨŋ gɨ no ilö gau aröl. Nɨbi bɨ Jerusalem mɨdaiöl gau, pɨñɨŋ gɨ höŋ adö aröl. Pen nɨbi bɨ höŋ adö mɨdaiöl gau, Jerusalem waryö raul aragöl. ");
INSERT INTO kpw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nɨhön gɨnɨg: ñɨn anɨbu me, kale God nɨp arö gɨpal rö, God manö hagep bɨ gau magöŋhalö God Manö kalɨ kƚiñ rɨköm hagla rö nöp gɨnab nɨŋöm kale pen ilön kub udnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pen ñɨn anɨbu, nɨbi ñɨ mudun mɨdeinaböl gau abe, nɨbi ñɨ paiŋaŋ ci ñeinaböl gau abe, kalɨp mɨŋör kub yöl gɨnab. God Juda nɨbi bɨ kalɨp mɨŋör kub yabɨƚ gɨnam a göm, nɨbi bɨ ram mɨnöŋ anɨbi mɨdpal kalɨp gɨ naij yabɨƚ gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɨ mɨlö gau nɨbö apöm, nɨbi bɨ rɨmnap kalɨp ru mɨlö kɨd udöm rɨb lɨnaböl, nɨbi bɨ rɨmnap kalɨp nagɨ löm dam ram mɨnöŋ ke gau gau magöŋhalö ud arnaböl. Pen Juda nɨbi bɨ wasö gau apöm, Jerusalem gɨ naij gɨlö gɨlö, God ñɨn nɨpe haga u ap auö, arö gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pen hainö, sɨdö rakɨn gapɨ nan ke ap waiö löm, ñɨg si ral apöm gu kub geinab. Pen ram mɨnöŋ iƚ i nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö gasɨ iru nɨŋöm, nɨhön gab a göm, gasɨ mɨlö löm pɨñɨŋ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nan kumi kabö adö laŋ mɨdöp gau, daŋ nɨbö i nɨbö gö, mɨnöŋ naböŋ i nɨhön gɨnɨg göm gab, a göm, pɨñɨŋ göm, gasɨ magö rɨk auö umeb rö lɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Anɨg gɨnab ñɨn u, Bɨ Ñɨ nɨpe kumi aŋ au auö nɨŋöl gɨ, nɨbi bɨ kale pɨdöŋ nɨpe u abe, mailö aij unbö ke yabɨƚ nɨpe u abe nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nan hagabin i geinab u, Bɨ Kub hanɨp ud kamɨŋ yunab ñɨn u söl mɨdöp, a gɨmim, amgö gɨlaŋ gɨmim nɨŋöl gɨ mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas anɨg hagöm, kalɨp manö hod rɨköm haga, “Mab wasɨŋad abe, mab rɨmnap abe, ");
INSERT INTO kpw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","sɨƚɨp lö, mɨñi sɨdö lɨnɨg göm gab a gɨmim, nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Anɨb u rö, nan hagpin gau gö, God nɨbi bɨ udöm abad mɨdeinab ñɨn u söl auub a gɨmim, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yad kalöp nɨŋö hagabin, nɨbi bɨ uri mɨdpal gai i magöŋhalö umagnaböl; rɨmnap kamɨŋ mɨdlö nɨŋöl gɨ, nan hagabin i magöŋhalö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe ur gɨnab, jɨ manö magö yad gau ur gagnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pen nɨŋ aij gɨmim. Kale ñɨg wain ñɨg kƚö iru ñɨŋmim hauƚ lɨmim, nan mɨnöŋ naböŋ adö iƚ i nöp gasɨ nɨŋ mɨdeinabim ñɨn anɨbu nöp, yaur kaj wal wayöŋ hel lɨlö yɨŋɨd nöp udöp rö u gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gai i nöp gagnab; nɨbi bɨ ram mɨnöŋ iƚ kɨgɨn yɨma magöŋhalö mɨdpal rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anɨb u, kale pör pör nɨŋ aij gɨmim, God nɨp sabe göl gɨ nöp mɨdmim hagmim, ‘Nan anɨb gau hanɨp al pak lagnɨm; ne hanɨp abad mɨdö kamɨŋ arun, am Bɨ Ñɨ nɨpe amgö ilö adö nɨpe u mɨdaiun,’ a gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ñɨn pro bad anɨbu, Jisas pör am God sabe gep ram raul mɨgan u am mɨdöm, nɨbi bɨ gau kalɨp manö hag ñɨmɨdöp. Pen sɨbön gö nɨŋöl göm, Jisas nɨpe am ram mɨnöŋ ap Olip Dum a gal u hanmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nɨbi bɨ gau magöŋhalö, manö nɨp u nɨŋun, a göm, hilɨm halö yabɨƚ uraköm, God sabe gep ram u armɨdal. ");
INSERT INTO kpw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Juda kai Bred Yɨs Halö Ñɨŋagep ñɨn kub kale u, Pasopa a gɨpal ñɨn kub kale u, sösöl ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, Jisas nɨp alun a gɨla u pen nɨbi bɨ gau kalɨp pɨñɨŋ göm, aigöl gun alun a göm, hag nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hag nɨŋ mɨdlö nɨŋöl gɨ, Seden nɨpe apöm, Judas hib nɨpe ap Iskariod a gɨmɨdal u, nɨp yuö hiɨka. Bɨ anɨbu Jisas bɨ nɨpe unbö mɨgan laŋ gau bɨ ap. ");
INSERT INTO kpw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuö hiɨkö, nɨpe am God nɨp nan sabe gep bɨ kub gau abe, God sabe gep ram abad mɨdmɨdal polisman bɨ kub kale gau abe mɨdeila gau amöm, Jisas nɨp aigöl gem mumug gɨ dam ñɨnö nɨp al pak löl, a göm, manö anɨbu kalɨp aip hag nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hagö, kalɨp aij a gö nɨŋöl gɨ hagla, “Nöp mani ñɨnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hageila, Judas nɨpe, magö mai rö Jisas nɨbi bɨ gau aip mɨdageinab u, nɨp mumug gɨ dam bɨ kub gau kalɨp ñɨnabin, a göm, abad nɨŋ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pen Bred Yɨs Halö Ñɨŋagep ñɨn anɨbu auö, Pasopa kaj sipsip pi pak sabe gep ñɨn uri, a göm, ");
INSERT INTO kpw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas nɨpe Pida aip Jon aip kalɨp mɨhöŋ hag yuöm haga, “Kale mɨhöŋ am Pasopa nan ñɨŋnabun u gɨ lɨ aij gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hageia haglö, “Gai anɨg gul?” ö gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hageila, Jisas haga, “Kale mɨhöŋ daun kub u ammil nɨŋnabil, bɨ ap ñɨg mɨl daueinab. Nɨp nable pakmil, arnɨm ram u ammil, ");
INSERT INTO kpw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bɨ ram nap nɨbö anɨbu nɨp hagmil, ‘Manö Hag Ñeb Bɨ nöp hag nɨŋöb, “Ram raul mɨgan mai bɨ yad gau aip Pasopa nan ñɨŋnabun?” ö göp,’ a gɨmil. ");
INSERT INTO kpw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Anɨg hageinabil, kalöp mɨhöŋ dam ram raul mɨgan kub debol nan gau halö mɨdeinab adö laŋ u hageinab u, Pasopa nan ñɨŋnabun gau raul mɨgan anɨbu gɨ jɨn gɨmil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hagö ammil nɨŋlö, haga haga rö nöp mɨdeia. Anɨb u, Pasopa nan ñɨŋnɨg gɨla gau gɨ lɨ aij gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pen ram dugöp magö u nan ñɨŋnɨg göm, bɨ manö nɨpe ud arep gau aip debol u asɨk gɨgabö göm, ");
INSERT INTO kpw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kalɨp haga, “Gasɨ yad pör nɨŋbin u, kalöp aip Pasopa nan ñɨŋnɨg gabun i ñɨŋun me, hainö ilön kub udnam, a gem, gasɨ u nɨŋbin. ");
INSERT INTO kpw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pen yad kalöp hagabin, Pasopa nan u hainö kauyaŋ ñɨŋagnabin; hainö Pasopa kaj sipsip pi pör pak ñɨŋbun iƚ anɨbu waiö lɨnab nɨŋöm God nɨbi bɨ nɨpe udöm abad mɨdeinab ñɨn u nöp nan kub ñɨŋnabun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas anɨg hagöm, ñɨg wain kap udöm, God nɨp aij a göm, bɨ nɨpe gau kalɨp ñöl gɨ haga, “Ñɨg ñabin i kale ke ud ñɨŋim. ");
INSERT INTO kpw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pen kalöp hagabin, mɨñi ñɨn i rɨkö, ñɨg wain kauyaŋ ñɨŋagnabin; God nɨbi bɨ nɨpe udöm abad mɨdeinab ñɨn u nöp ñɨg wain kauyaŋ ñɨŋnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Anɨg hagöm, bred ap udöm, God nɨp aij a göm, ud jö göm kalɨp ñöl gɨ haga, “Hañ romaŋ yad i kalöp ñabin. Kale udmim gasɨ yɨp nöp nɨŋöl gɨmim ñɨŋim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kale nan ñɨŋ haköm, Jisas ñɨg wain kap u udöm, kalɨp ñöl gɨ haga, “Hagape yad lugö umnö me, God kalöp nɨbi bɨ yad, a göm, udnabin a ga manö adö u am pɨdöŋ gɨnab u me, kalöp ñɨg wain i ñabin. ");
INSERT INTO kpw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pen bɨ yɨp kain gɨ dam arnab u aip asɨk mɨdpun. ");
INSERT INTO kpw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bɨ Ñɨ nɨpe, God hadame ram haga adan adö u nöp hain göm umnab u pen bɨ nɨp kain gɨ dam arnab u nɨp mög nɨŋabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisas anɨg hageia, bɨ nɨpe gau kale ke nöp, an rö anɨg gɨnab, a göm, pen pen hag nɨŋöl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisas bɨ nɨpe gau, kale wasö, yad nöp bɨ kub mɨdpin, a göm, kale ke nöp pen pen hageila. ");
INSERT INTO kpw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Anɨg hageila, Jisas kalɨp haga, “Kiŋ gau Juda nɨbi bɨ wasö gau kƚö göm abad mɨdöl gɨ hagpal, ‘Kalɨp ud aij yabɨƚ gɨpun,’ a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pen kale unbö rö gagmim. Bɨ kub kale gau, ñɨ praj rö mɨdaiöl; bɨ kub yabɨƚ gau, bɨ wög gɨ ñeb rö mɨdaiöl. ");
INSERT INTO kpw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mɨnöŋ naböŋ iƚ i gɨpal nagɨ adö u, bɨ kub am asɨklö, bɨ wög gɨ ñeb gau nan magö nan kalpe gau pɨɫa pɨɫa gɨpal. Pen yad aŋ kalöp bɨ wög gɨ ñeb rö nöp mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yɨp marö yabɨƚ gɨmɨdöp u nɨŋmim yɨp arö gagpim; yɨp abad mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Anɨg gɨpim u, God yɨp hagöp, ‘Ne Kiŋ mɨdmön, nɨbi bɨ gau kalɨp abad mɨdeinabön,’ a göp rö, yad pen u rö nöp kalöp hagabin, kale kiŋ rö mɨdmim nɨbi bɨ gau kalɨp abad mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ñɨn anɨbu kale ram mɨnöŋ yad u ammim, yad aip asɨkmim nan magö ñɨŋmim ñɨg ñɨŋmim gɨnabim; kale kiŋ asɨkpal sea adö u asɨkmim, Isrel iƚ ke ke unbö mɨgan laŋ kalɨp manö kub nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas nɨpe Pida nɨp haga, “Saimon, Saimon, nöŋ. God nɨpe Seden nɨp yau a gö, kalöp bɨ, wid magö hoŋ gɨlö hoŋ gɨlö, magö yabɨƚ u ke löm, adɨŋ adɨŋ u ke löm gɨpal rö u göm, kale gɨ naij gɨnabim aka wasö gɨ nɨŋnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pen yad God nɨp sabe gɨpin rö, yɨp böŋ nöp arö gagnabön. Pen nan si nan naij gɨnabön u, nɨhön gɨnɨg anɨg gɨpin, a gɨmön, yɨp kauyaŋ ado gɨ aunabön. Pen anɨg gɨmön, hainö apön namdamam ne rɨmnap kalɨp manö hag ñɨ aij gö, kale kƚö göm yɨp hain göl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jisas anɨg hageia Pida haga, “Bɨ Kub, yad nöp arö gagnabin. Mɨhöŋgöl nöp ajeinabul, nöp nagɨ löm, yɨp abe nagɨ löl. Pen nöp al pak löm, yɨp abe al pak löl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hageia, Jisas haga, “Pida, yad nöp hagabin, mɨñi sɨbön yaŋ kɨƚakɨƚ wɨñ alagnab magö u, Jisas nɨp nɨŋagpin a gɨmön, ij mɨhau nɨgaŋ wai ñɨnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas anɨg hagöm kalɨp haga, “Nöd kalöp hag yuem hagnö, ‘Mani rin, wadɨ, ma rɨrup gau udmim ud aragmim; yɨharɨŋ armim,’ a gɨnö. Hagnö arbe ñɨn anɨbu, nan kale rɨmnap mɨdeia aka mɨdageia?” ö ga. Hageia hagla, “Wasö, nan hon uƚep laga; mɨdeia nöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hageila, Jisas haga, “Pen mɨñi kale mani rin, wadɨ mɨdainɨm u, halö ud armim. Bɨ an ru mɨlö kɨd mɨdagainɨm u, kolsior nɨpe u bɨ rɨmnap kalɨp sɨkim göm mani udöm ru mɨlö kɨd ap raunɨm. ");
INSERT INTO kpw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pen nɨŋim! Nöd God manö hagep bɨ Aisaia God Manö adɨŋ ap kalɨ kƚiñ rɨköm haga, ‘ “Nɨpe bɨ nan si nan naij gep bɨ ap,” a gɨnaböl,’ a ga. Haga anɨbu yɨp nöp haga. Manö hagöm kalɨ kƚiñ rɨka anɨbu mɨñi gɨnɨg gab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jisas anɨg hageia, kale hagla, “Bɨ Kub, ru mɨlö kɨd hon mɨhöp mɨdöp,” a gɨla. Hageila haga, “U anɨg hagagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas anɨg hagöl göm Jerusalem höŋ amöm, pör Nap nɨp sabe gɨmɨdöp Olip Dum au ara; bɨ nɨpe gau hain gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ram mɨnöŋ anɨbu amjaköm kalɨp haga, “Gasɨ naij auö gɨ naij gɨmim rö löp u, God nɨp sabe göl gɨ mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Anɨg hagöm, kalɨp arö göm, nɨpe ke ke au amöm, kugom yɨmöm God nɨp sabe göm haga, ");
INSERT INTO kpw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapi, gasɨ yad nɨŋbin u ñɨg asɨ kap yɨp ñɨnɨg gabön u ñagmön. Pen yad gasɨ nɨŋbin adö u gagmön; gasɨ ne ke nɨŋban adö u nöp gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jisas anɨg hagö, ejol ap kumi kabö adö laŋ au nɨbö apöm nɨp pɨdöŋ ña. ");
INSERT INTO kpw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nɨp marö yabɨƚ gö, Jisas nɨpe Nap nɨp kƚö yabɨƚ göm sabe göl gɨ mɨdö nɨŋöl gɨ, hapɨl u hagape rö pa gɨ dö gɨ iƚ yaŋ luga. ");
INSERT INTO kpw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nap nɨp sabe gɨ mɨd juöm amöm nɨŋa, bɨ nɨpe gau mɨŋör lugö nɨŋöl gɨ, hon haneila. ");
INSERT INTO kpw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Anɨg geila u nɨŋöm kalɨp haga, “Nɨhön gɨnɨg hon hanabimŋ Seden nɨpe gasɨ ñö kale gɨ naij gɨmim rö löp u, urakmim, sabe göl gɨ mɨdaiim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas manö anɨbu hag mɨdö nɨŋöl gɨ, bɨ nɨpe Judas bɨ ugan kub ap uɫ gɨ dap apjaköm, Jisas nɨp ud bom halunam a geia. ");
INSERT INTO kpw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Anɨg geia, Jisas nɨp haga, “Judas, ‘Bɨ me i al pak lɨmim,’ a gɨmön, yɨp Bɨ Ñɨ nɨpe ud bom halunɨg gabön ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Anɨg hagö nɨŋöl gɨ, bɨ nɨpe gau nan nɨhön gɨnɨg geila anɨbu nɨŋöm hagla, “Bɨ Kub, hon kalɨp ru mɨlö kɨd ud rɨbun aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Anɨg hagöl göm, bɨ ap ru mɨlö kɨd nɨpe u udöm, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ bɨ wög gɨ ñeb nɨpe u, nɨp rɨmɨd yɨjɨg lau böŋ nöp rɨb gɨ dö gɨ yua. ");
INSERT INTO kpw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Anɨg geia, Jisas nɨŋöm haga, “Anɨg gagmim! Me aij,” a ga. Anɨg hagöm, rɨmɨd u ud nɨŋö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pen God nɨp nan sabe gep bɨ kub gau abe, God sabe gep ram abad mɨdmɨdal polisman bɨ kub kale gau abe, bɨ manö ud asɨkep gau abe, ap nɨp udnɨg geila gau, kalɨp haga, “Kale ru mɨlö kɨd udmim, ur pakep udmim daubim u, yɨp bɨ pen pen alep bɨ ap rö a gɨ gasɨ nɨŋmim, ud sɨsɨ lɨnɨg aubim ar? ");
INSERT INTO kpw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yad kale aip pör pör God sabe gep ram u mɨdainö yɨp udagpe. Pen mɨñi Seden, bɨ sɨbön lau adö mɨdöp u, ñɨn nɨpe u me, anɨg gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas anɨg hagö nɨŋöl gɨ, nɨp ud sɨsɨ löm, dam God nɨp nan sabe gep bɨ kub yabɨƚ ram u ud arla. Pida pen hain hain nɨŋ ara. ");
INSERT INTO kpw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ram anɨbu apjaköm, ram goƚ au mab lauöm asɨk mɨdeila. Pida hain apjaköm kalɨp aip asɨka. ");
INSERT INTO kpw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pida aip asɨk mɨdö nɨŋöl gɨ, pai ram anɨbu wög gɨ ñɨmɨdöp ap nɨp nɨŋ dap ran lugöl gɨ haga, “Bɨ i abe Jisas aip mɨdmɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hageia, Pida haga, “Pai, bɨ anɨbu yad nɨŋagpin!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Anɨg hagöm, yöp pro magö ap mɨdö nɨŋöl gɨ, bɨ ap pen apöm Pida nɨp nɨŋöm haga, “Ne u rö nöp Jisas bɨ nɨpe ap,” a ga. Hageia, Pida haga, “Bɨ me, yad wasö!” ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pen hainö pro pro magö ap mɨdö, bɨ ap pen apöm, kƚö göm haga, “Bɨ i Jisas aip mɨdmɨdöp me. Nɨpe abe ram mɨnöŋ Galili nɨbö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hageia, Pida haga, “Bɨ me, manö hagabön u yad nɨŋagɨn me!” a ga. Anɨg hagö nɨŋöl gɨ, adɨŋ kɨƚakɨƚ wɨñ ala. ");
INSERT INTO kpw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Anɨg gö, Jisas ado göm, Pida nɨp nɨŋ ij halö lö, Pida pen Jisas, “Mɨñi sɨbön yaŋ kɨƚakɨƚ wɨñ alagnab magö u, Jisas nɨp nɨŋagpin a gɨmön, ij mɨhau nɨgaŋ wai ñɨnabön,” a ga manö u gasɨ nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Anɨg nɨŋöm, rugu mɨƚep gö, maƚuƚ ral auö, höŋ amöm mɨɫöŋ ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɨ Jisas nɨp ud mɨdeila gau nɨp hag juöl gɨ, paköl gɨ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kale waƚɨj bad ap ud amgö nɨp u paƚu gɨ ñöm, nɨp paköm hagla, “Ne bɨ ke nɨŋban u, nöp an pakab u hanɨp hag ñɨ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pen manö naij anɨbu rö, nɨp rapɨn iru nöp hagla. ");
INSERT INTO kpw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hilɨm halö, Juda bɨ manö ud asɨkep gau löm, God nɨp nan sabe gep bɨ kub gau löm, bɨ lo manö hag ñeb gau löm, ap magum gɨlö, Jisas nɨp uɫ gɨ Kansol kub anɨbu mɨdeila aŋ au ud daula. ");
INSERT INTO kpw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pen Kansol bɨ gau kale Jisas nɨp hagla, “Pen ne ke hagmön, ne Mesaia u aka wasö,” gɨla. Hageila, Jisas kalɨp haga, “Pen yad kalöp hageinabin u, nɨŋö hagöp a gɨmim, nɨŋagnabim. ");
INSERT INTO kpw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pen hag nɨŋeb yad mɨdöp u kalöp hag nɨŋeinabin u, yɨp pen hagagnabim. ");
INSERT INTO kpw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pen mɨñi rɨköl mɨd damöm hainö gau, Bɨ Ñɨ nɨpe God Bɨ kƚö unbö ke halö mɨdöp u, ñɨmagö yɨjɨg adö nɨpe au asɨk mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Anɨg hageia, bɨ kansol gau magöŋhalö nɨp hagla, “Anɨb u, ne ke God Ñɨ nɨpe u aka?” gɨla. Hageila, Jisas haga, “Me kale ke hagpim me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hageia hagla, “Nɨhön gɨnɨg manö kub rapɨn hag mɨdun, bɨ rɨmnap hag nɨŋno, Jisas anɨg göp anɨg göp a gaiölŋ Maj mɨgan nɨpe ke hagöp nɨŋbun u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Anɨg hagöm, magöŋhalö uraköm, Jisas nɨp dam gapman bɨ kub Pailod mɨdeia au arla. ");
INSERT INTO kpw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Damöm, nɨp manö kub hagnɨg, manö gau nɨbö gau nɨbö dapöm hagla, “Hon uƚhai nɨŋun nɨŋbun, bɨ anɨbi nɨbi bɨ hon gau manö piral hagöm hagöp, ‘Bɨ kub Sisa nɨp dakɨs ñagmim, gapman kai manö u u rö nöp nɨŋagmim,’ a göp. Pen manö ap hagöp, ‘Yad ke Mesaia u, yad ke kiŋ anɨbu,’ a göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hageila, Pailod Jisas nɨp hag nɨŋöm haga, “Ne Juda kai kiŋ kale u aka?” ga. Hageia haga, “Me ne ke hagpan me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hageia, Pailod pen bɨ God nɨp nan sabe gep bɨ kub gau abe, nɨbi bɨ yɨharɨŋ ap mɨdeila gau abe kalɨp haga, “Yad nɨŋbin, bɨ i nɨp manö kub hagep iƚ ap mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Anɨg haga u pen kale manö kƚö hagöm hagla, “Gapman manö nɨŋagöl, a göm, manö hag ñɨ ajöm, Juda nɨbi bɨ ram mɨnöŋ hon gau magöŋhalö hag ñɨ ajmɨdöp. Ram mɨnöŋ Galili rɨköm, hag ñɨ aj dam dam mɨñi Jerusalem aui auöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hageila, Pailod kalɨp hag nɨŋöm haga, “Bɨ anɨbi Galili nɨbö aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hageia, yau a gɨla. Pen kiŋ Herod ram mɨnöŋ Galili abad mɨdmɨdöp u, ñɨn aŋ u apöm Jerusalem mɨdmɨdöp. Anɨb u, Jisas nɨpe Galili nɨbö bɨ ap a gɨla u nɨŋöm, nɨp Herod ñɨmagö adö yunö manö kub i nɨŋnɨm, a göm, Pailod kalɨp hagö, Jisas nɨp dam Herod mɨdeia au ud arla. ");
INSERT INTO kpw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod, Jisas nan nɨhön nɨhön gɨmɨdöp u pör manö nöp nɨŋöm, ñɨn mai rö nan gagep rö ap gö nɨŋnabin, a göm, gasɨ u nöp nɨŋ mɨdmɨdöp rö, ñɨn anɨbu Jisas nɨp uɫ gɨ dapjaklö, nɨpe mɨñ mɨñ yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pen Herod nɨpe Jisas nɨp manö iru nöp hag yɨgɨn wagɨn ga, pen Jisas manö ap pen hagaga. ");
INSERT INTO kpw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pen bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ lo manö hag ñeb bɨ gau abe, manö kƚö göm, bɨ iru nöp dagol dagol hagla. ");
INSERT INTO kpw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod abe, ami bɨ nɨpe gau abe, Jisas nɨp gɨ naij göl göm, ñɨñɨƚoŋ löl göm, gapman bɨ kub rol gɨpal waƚɨj aij ap rol gɨ ñöm, kauyaŋ Pailod mɨdeia au yula. ");
INSERT INTO kpw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nöd Herod aip Pailod aip koƚmaƚ mɨdmɨdil pen ñɨn anɨbu manö nɨŋ jɨm ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pen Pailod, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep bɨ kub gau abe, nɨbi bɨ yɨharɨŋ gau abe kalɨp hagö ap magum gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kale ap magum geila, nɨpe kalɨp haga, “‘Bɨ i manö aŋ ral hagöm, nɨbi bɨ gau kalɨp anɨg anɨg hagöp,’ a gɨpim u pen mɨñi amgö ilö adö kalöp i manö nɨŋbin u, nɨpe nan naij göp manö iƚ ap nɨŋagpin. ");
INSERT INTO kpw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod u rö nöp manö iƚ ap uƚhai nɨŋagöp u me, adog hanpe ke ñöb. Yad nɨŋbin, nan naij ap gagöp; anɨb u nɨp al pak lep rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anɨb u, ami bɨ yad gau hagnö, nɨp yɨharɨŋ paköm, hag yulö araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pen Juda kai ñɨn kub kale Pasopa u auö, Pailod pör mɨ añɨ añɨ nagɨman kale añɨ ap yɨharɨŋ hag yumɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pen ñɨn anɨbu kale magöŋhalö maj mɨgan bƚaƚö gɨ wɨñ kƚö alöm hagla, “Bɨ anɨbu al pak lɨmim! Barabas nɨp hag yube hanɨp auaŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bɨ Barabas anɨbu nɨpe daun kub anɨbu nɨbi bɨ rɨmnap udöm, ram mɨnöŋ anɨbu abad mɨdmɨdöp bɨ kub anɨbu aip pen pen göm, wip ap böŋ nöp al pak la rö, nɨp manö kub hagöm nagɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pen Pailod Jisas yɨharɨŋ hag yunö araŋ a gɨ nɨŋöm, kalɨp kauyaŋ hagöm anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hageia, kale kauyaŋ maj mɨgan bƚaƚö gɨ wɨñ alöm hagla, “Nɨp mab ba laŋ al pak lɨmim! Nɨp mab ba laŋ al pak lɨmim!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hageila, Pailod kalɨp kauyaŋ hagöm haga, “Bɨ anɨbi nan nɨhön gɨ naij göpŋ Yad nɨŋbin, nan naij ap gagöp rö, nɨp al pak lun rö lagöp. Anɨb u, ami bɨ yad hagnö, nɨp yɨharɨŋ paköm, hag yulö araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hageia, kale kƚö yabɨƚ göm, Jisas nɨp al pak lɨlö umaŋ, a göm, meg mɨgan kale bƚaƚö gɨ dap ranöm, hag gɨlö gɨlö, ");
INSERT INTO kpw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailod manö kalɨp u udöm, ");
INSERT INTO kpw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","bɨ ap, nɨbi bɨ rɨmnap udöm ram mɨnöŋ abad mɨdmɨdöp bɨ kub u aip pen pen göm, wip ap böŋ nöp al pak la bɨ anɨbu nɨp hag yuö kamɨŋ ara; pen ami bɨ nɨpe gau kalɨp haga, “Kale Jisas nɨhön gɨnɨg gun a göm hagaböl u nöp gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisas nɨp al pak lɨnɨg ud arla. Aŋ au amöl göm, Sairini daun nɨbö bɨ ap Jerusalem aueia. Bɨ anɨbu hib nɨpe Saimon. Nɨp nable paköm, ud sɨsɨ löm, mab kros ud ka gɨ ñöm hagla, “Jisas arab u hain aru,” a gɨlö, ud hain ara. ");
INSERT INTO kpw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pen Jisas nɨp ud arlö nɨŋöl gɨ, nɨbi bɨ iru nöp hain gɨla. Nɨbi bɨ areila aŋ anɨbu nɨbi rɨmnap Jisas nɨp mög nɨŋöm ham geila. ");
INSERT INTO kpw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Anɨg gɨlö, Jisas ado gɨ nɨŋöm kalɨp haga, “Kale Jerusalem nɨbi, yɨp gɨnɨg gab u ham gagmim. Kalöp gɨ naij göm, ñɨ pai kale gau gɨ naij göm geinab anɨbu ham gɨmim. ");
INSERT INTO kpw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hainö marö kub u auö, hagnaböl, ‘Nɨbi ñɨ pai yag dauagpal gau abe, nɨbi ñɨ pai ci ñagpal gau abe, kale nöp mɨñ mɨñ göl,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ñɨn anɨbu, nɨhön gɨnɨg mɨdaiun, a göm, böŋ nöp umun, a göm, hagnaböl ‘Nö ilö gau pa jö gɨ apöm, hanɨp al pak lɨnɨm aka kɨdip udöm hanɨp mɨnöŋ ñɨnɨm u aij,’ a gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yad mab kamɨŋ rö mɨdpin pen yɨp anɨg göm gɨ naij gaböl. Pen kale mab mɨƚep rö mɨdpim rö, kalöp nɨhön rö gɨ naij gɨnaböl?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pen bɨ gapman lo manö rɨb julö bɨ mɨhau, mab ba laŋ al pak lɨnɨg göm, udöm halö ud arla. ");
INSERT INTO kpw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dam ram mɨnöŋ Wip Nabɨc Cög Ij a gɨpal u amjaköm, Jisas nɨp dam mab ba laŋ cɨpɨƚ pakla, bɨ gapman lo rɨb julö bɨ mɨhau kalɨp mɨhöŋ dam mab lap lap cɨpɨƚ pakla. ");
INSERT INTO kpw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Anɨg gɨlö, Jisas haga, “Bapi, yɨp gaböl u, ai gɨnɨg anɨg gabun, a göm, nɨŋ aij göm gagaböl. Anɨb u, kale gɨ naij gaböl u nɨŋmön arö gɨmön,” a ga. Pen ami bɨ gau, Jisas waƚɨj nɨpe ud ju lɨlö mɨdeia gau, kale ke sadu gɨpal rö u göm udla. ");
INSERT INTO kpw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nɨbi bɨ iru nöp nɨŋmɨdlö nɨŋöl gɨ, Juda bɨ kub gau Jisas nɨp paj hagöm hagla, “Nɨpe, ‘Yad Mesaia u; God yɨp udajɨp nɨpe aip mɨdpul,’ a göm, nɨbi bɨ rɨmnap umbal gajɨp urakpal. Göp anɨbu rö, nɨpe ke u rö nöp anɨg göm kamɨŋ arö nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pen ami bɨ gau u rö nöp, Jisas mɨdeia söl au apöm nɨp paj hagöm, ñɨg wain asɨ ñöl göm hagla, ");
INSERT INTO kpw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ne, ‘Juda Kiŋ kale mɨdpin,’ a gɨpan u, ne ke gɨmön kamɨŋ aru!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pen Jisas nɨp cɨpɨƚ pak lɨla mab ba au gɨlaŋ, mab po bad ap adö u manö kalɨ kƚiñ rɨkla: ");
INSERT INTO kpw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bɨ gapman lo manö rɨb julö, mab ba laŋ al pak lɨla mɨhau, bɨ ap Jisas nɨp hag juöm haga, “Ne Mesaia mɨdpan u, ne ke gɨmön kamɨŋ ammön, hol mɨhöŋ u rö nöp gö, kamɨŋ arul!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hageia, bɨ ap pen nɨp hag göm haga, “Bɨ anɨbi ilön kub udöm umnɨg gab; hol mɨhöŋ u rö nöp ilön kub udul umnɨg gabul u, a gɨmön, God nɨp pɨñɨŋ gagpan ar? ");
INSERT INTO kpw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hol mɨhöŋ naij gɨpul rö ilön udabul, pen bɨ anɨbi nan naij ap gagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nɨpe anɨg hagöm, Jisas nɨp haga, “Ne ram mɨnöŋ ne au am kiŋ mɨdmön, yɨp gasɨ nɨŋmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Anɨg hageia, Jisas nɨp pen pe haga, “Yad nöp nɨŋö yabɨƚ hagabin, mɨñi ñɨn i nöp ne yad aip am ram mɨnöŋ aij u mɨdeinabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Magö anɨbu, sɨdö aŋ aulɨk magö u sɨbön göm, mɨd damöm sɨdö aumɨŋ gai ga magö u kauyaŋ mailö ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Pen Jisas umnɨg göm haga, “Bapi, ana magö yad u ñɨmagö adö ne u labin,” a ga. Anɨg hagöm uma. Jisas uma, magö anɨbu nöp, God sabe gep ram magö raul agamɨj mɨgan yaŋ, waƚɨj ud ajöŋ pɨƚ gɨla u, aŋ yaŋ pa bu göm, ƚɨƚɨ gɨ lap lap arö, ajöŋ hiɨköl mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pen ami bɨ abad mɨdep bɨ kub u, gaia anɨbu nɨŋöm, God hib nɨpe u dap ranöl gɨ haga, “Nɨŋö yabɨƚ! Bɨ anɨbi bɨ aij nöp!” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nɨbi bɨ ap nɨŋ mɨdeila gau, nan ga anɨbu nɨŋöm, maƚuƚ ral auö pabɨƚ paköl gɨ, ado göm ram kale arla. ");
INSERT INTO kpw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pen Jisas nɨbi bɨ nɨŋeb nɨpe gau abe, nɨbi Galili nɨbö nɨp hain gɨla gau abe, kale ke ke au daŋ mɨdöm, nan ga anɨbu nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pen Juda Kansol kub bɨ ap, hib nɨpe Josep. Nɨpe bɨ aij, manö ud asɨk gɨ aij gɨmɨdöp. Nɨpe Arimadia daun, ram mɨnöŋ Judia aŋ au nɨbö. Nɨpe Juda Kansol bɨ rɨmnap, Jisas nɨp al pak lun, a göm, gasɨ nɨŋla rö nɨŋaga. Nɨpe, God nɨbi bɨ udöm abad mɨdeinab ñɨn u aunab, a göm, abad mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nɨpe Jisas uma, wip he dam rɨgöl gɨnɨg göm, Pailod mɨdeia u amöm, hag nɨŋö yau a ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Anɨb u, Josep nɨpe am wip he ud asɨk dap lugöm, waƚɨj rud aij ap ud wam wam göm, dam kabö mɨgan gɨsön nöp ƚu löm wip rɨgöl gagla mɨgan u rɨgöl ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pen Juda God nɨp sabe gep ñɨn u söl auub, a göm, Praide dugo dugo magö u wip rɨgöl ga. ");
INSERT INTO kpw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pen nɨbi ugan, Jisas aip Galili nɨbö aula gau, Josep arö nɨŋöl gɨ hain gɨ damöm wip rɨgöl amjaköm, wip he aigegö rɨgöl ga u nɨŋ aij göm, ado gɨ ram kale arla. ");
INSERT INTO kpw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ram kale amöm, agnoŋ ñɨg haƚɨŋ aij auep rɨmnap wip he lɨ ñɨnɨg göm, gɨ lɨ aij gɨla. Ruö mañu nöp daublap u pen Sarere ñɨn kub kale yɨharɨŋ mɨdep u nɨŋöm me, yɨharɨŋ mɨd mɨd hanla. ");
INSERT INTO kpw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ruö Sade ñɨn u, ram gɨsön rua magö u, nɨbi ugan anɨbu agnoŋ ñɨg haƚɨŋ aij auep u udöm, wip he hañ romaŋ anöŋ lɨ ñun, a göm, dam wip rɨgöl gɨla u arla. ");
INSERT INTO kpw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amöm nɨŋla, kabö haƚai kub wip rɨgöl mɨgan pɨƚ gɨla u, ƚɨƚɨ gɨ am ba lau mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pen kale mɨgan anɨbu amöm nɨŋla, Bɨ Kub Jisas hañ romaŋ nɨpe mɨdageia. ");
INSERT INTO kpw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ai göp, a göm, hag mɨdlö nɨŋöl gɨ, adɨŋ bɨ mɨhau goƚ anɨb au uraköl mɨdailö. Bɨ mɨhau waƚɨj kale rud mailö halö unbö ke mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nɨbi gau kale nɨŋöm, anɨnɨn gö pɨñɨŋ göm, kugom yɨmöm yɨhöŋ gɨlö nɨŋöl gɨmil, bɨ anɨb mɨhau haglö, “Nɨhön gɨnɨg bɨ kamɨŋ mɨdöp u nɨp wip rɨgöl gɨpal aŋ gai i uƚhai nɨŋ ajabim? ");
INSERT INTO kpw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nɨpe aui mɨdagöp; mɨdö nöp uraköp. Pen kalöp aip Galili mɨdöm manö haga u gasɨ nɨŋim. ");
INSERT INTO kpw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nɨpe kalöp haga, ‘Bɨ Ñɨ nɨpe u nɨp, ud nɨbi bɨ nan si nan naij gɨpal ñɨmagö adö kale lɨlö, nɨp mab ba laŋ al pak lɨlö, umöm ñɨn mɨhöp mɨdöm, ruö ñɨn mɨhau nɨgaŋ u kauyaŋ uraknab,’ a ga,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Anɨg haglö nɨŋöl gɨ, gasɨ magö kale u pɨral hiɨkö, Jisas nöd Galili mɨdöm, manö haga anɨbu gasɨ nɨŋ dam nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nɨbi gau kale wip rɨgöl u arö göm, kauyaŋ adö gɨ amöm, nan ga nɨŋla anɨbu, Jisas bɨ nɨpe unbö agɨp laŋ gau abe, nɨbi bɨ nɨpe rɨmnap gau abe hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nɨbi ugan manö hag ñɨla anɨbu, Maria Magdala u, Joana u, Jems nɨme Maria u, nɨbi rɨmnap halö. ");
INSERT INTO kpw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pen kale manö hag ñɨla anɨbu apdi nɨŋöm, nɨŋö hagaböl, a göm, nɨŋagla. Ñɨñɨƚoŋ löm rö hagaböl a göm gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pen Pida manö anɨbu nɨŋöm, gɨ dö gɨ amöm, rɨgöl gɨla kabö mɨgan u sɨpsɨp nɨŋa, wip waƚɨj wam wam gɨla bad u nöp mɨdeia. Anɨbu nɨŋöm, nɨhön göp, a göm, gasɨ mɨlö yabɨƚ löl göm, wip rɨgöl u arö göm kauyaŋ ado gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ñɨn anɨbu nöp, bɨ mɨhöp ram rɨƚɨg agƚö Emeas, yöp Jerusalem söl anɨb au arul, a gɨmil, adan amöl gɨmil, ");
INSERT INTO kpw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","nan nɨhön nɨhön geia nɨŋlö manö u agamɨj hag nɨŋöl gɨ arailö. ");
INSERT INTO kpw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Arailö nɨŋöl göm, Jisas jöl adö apöm, kalɨp mɨhöŋ uɫ göm ara. ");
INSERT INTO kpw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pen bɨ anɨb mɨhau Jisas nɨp nɨŋblep u pen God gasɨ magö kalɨp mɨhöŋ u geia nɨŋöm gasɨ hauƚ alö, Jisas nɨp nɨŋlö bɨ unbö ke rö la. ");
INSERT INTO kpw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nɨpe kalɨp mɨhöŋ hag nɨŋöm haga, “Manö u nɨhön manö haglö arab?” ö ga. Anɨg hageia, kale yɨm gep rö pɨdöŋ gɨ urak mɨdöl gɨmil, ");
INSERT INTO kpw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","bɨ Kliopas haga, “Ne nöp me, mɨñi ñɨn pro bad i Jerusalem aui am mɨdmön nan nɨhön nɨhön gab u nɨŋagpan ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hageia, Jisas haga, “Nan anɨbu nɨhön gö hagabil?” ö ga. Hageia haglö, “Jisas Nasared nɨbö ga u me. Bɨ God manö hagep u, manö hag ñɨ aij göm, nan gagep rö gau gɨmɨdöp u me, God nɨp aij a göm, nɨbi bɨ gau kalɨp aij a göm ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Nɨpe anɨg gɨmɨdöp u, gasɨ hon nɨŋun hagno, ‘God nɨp yuö hanɨp Isrel nɨbi bɨ udöm, abad mɨd aij gɨnab,’ a gun nɨŋno u pen God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep bɨ kub gau abe, nɨp manö hag göm, dam Rom gapman bɨ kub u nɨp ñɨlö, nɨpe manö kub hagöm, nɨp ami bɨ nɨpe gau kalɨp ñö, dam mab ba laŋ al pak lɨlö uma. Pen nan ga anɨbu ñɨn mɨhöp nöp ap ara me. ");
INSERT INTO kpw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mɨñi sɨb halö magö u, nɨbi ugan hon ap, am nɨp rɨgöl gɨla uƚöm mɨgan ka u nɨŋöm, ap hanɨp nan nɨhön nɨhön göp u hag ñɨlö nɨŋun pa gɨƚɨ gɨpun. ");
INSERT INTO kpw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nɨbi gau kale hagpal, ‘Wip he mɨlö u mɨdagajɨp, pen ejol mɨhau apil hagpil, “Nɨpe uraköm kamɨŋ mɨdöp,” a gɨpil,’ a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anɨg haglö, bɨ hon rɨmnap nɨp rɨgöl gɨla uƚöm mɨgan ka u amöm nɨŋbal, nɨbi gau hagajal rö nöp mɨdajɨp. Pen Jisas nɨp nɨŋagpal,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Anɨg hagailö, Jisas haga, “Kale mɨhöŋ gasɨ nɨŋ aij gagpil. Bɨ God manö hagep gau manö hagla u magöŋhalö, nɨhön gɨnɨg manö nɨŋö hagpal a gɨmil nɨŋagpil? ");
INSERT INTO kpw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","God haga rö, Mesaia u nöd ilön kub yabɨƚ udnab me, pen hainö mailö aij ke halö mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Anɨg hagöm, Mosɨs abe, bɨ God manö hagep bɨ gau magöŋhalö abe, Krais nɨp God Manö kalɨ kƚiñ rɨkla mɨdöp manö anɨbu magöŋhalö kalɨp hag ñɨ aij gö ara. ");
INSERT INTO kpw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ram mɨnöŋ areila söl anɨb au amjaköm, Jisas kalɨp mɨhöŋ abhak löm, arnɨg rö ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pen kalpe mɨhöŋ nɨp manö kƚö gɨmil haglö, “Dugöp i aubun. Sɨbön gɨnɨg gab nɨŋöm ne auö hol mɨhöŋ aip hanun,” a gɨlö. Haglö, kalpe mɨhöŋ aip ram arla. ");
INSERT INTO kpw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ram am mɨdöm, nan ñɨŋnɨg, nɨpe bred udöm, God nɨp aij, a göm, ud jö göm kalɨp mɨhöŋ ñö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","gasɨ magö kalpe mɨhöŋ u gasɨ wakö, u Jisas nöp, a gɨmil nɨŋlö nɨŋöl göm, agamɨj ur ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Anɨg ga u nɨŋmil haglö, “Adan aŋ au apöl gun, manö rɨmnap hag ñöl gɨ, God Manö kalɨ kƚiñ rɨkla manö iƚ u rɨmnap hag ñöl gajɨp u, mɨdmagö halɨp u mab rö inöm pɨƚu gɨ ñöb,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Anɨg hagmil, magö anɨbu nöp kauyaŋ ado gɨ Jerusalem ammil nɨŋlö, Jisas bɨ nɨpe unbö agɨp laŋ, nɨbi bɨ nɨŋeb kale rɨmnap halö aip ap magum göm mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Amjakmil kale nɨŋlö, nɨbi bɨ gau kale ke Jisas nɨp manö hagmɨdeila. “Nɨŋö nöp! Jisas uma u pen kauyaŋ uraköm, ap Saimon mɨdajɨp au waiö lajɨp nɨŋöb,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Manö hageila anɨbu nɨŋmil, bɨ mɨhau haglö, “Hol mɨhöŋ adan aŋ au arajul, Jisas halɨp nable pakajɨp, dam ram hol mɨhöŋ u amun, nan ñɨŋnɨg gun, nɨpe bred udöm, God nɨp aij a gajɨp u, u Jisas nöp a gul nɨŋbul,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pen manö anɨbu hag mɨdailö nɨŋöl göm, Jisas nɨpe ke mɨdeila aŋ au waiö lɨ aŋ au gɨlaŋ urak mɨdöm haga, “God kalöp abad mɨdeiaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hageia, kale wip ana, a göm, anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pɨñɨŋ geila, Jisas kalɨp haga, “Nɨhön gɨnɨg pɨñɨŋ gabimŋ Amgö kale ke nɨŋbim u pen nɨhön gɨnɨg gasɨ mɨhöp nɨŋabim? ");
INSERT INTO kpw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñɨmagö ma yad gau nɨŋim. Yad nöp me! Yɨp ud po nɨŋmim nɨŋnabim. Wip ana hañ romaŋ le halö mɨdagöp. Pen yad yuö abe, le abe mɨdpin u, amgö kale ke hadö nɨŋabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Anɨg hagöl göm, ñɨmagö ma nɨpe gau kalɨp yama. ");
INSERT INTO kpw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Anɨg gö, kale mɨñ mɨñ göl gɨ, gasɨ mɨlö löl gɨ, u Jisas nöp aka göm, gasɨ mɨhöp nɨŋlö nɨŋöl göm, Jisas kalɨp haga, “Nan ñɨŋeb kale rɨmnap aui mɨdöp aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hageia, nɨp kabsaƚ lau lɨla ap ñɨla. ");
INSERT INTO kpw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kale nɨŋmɨdlö nɨŋöl gɨ, nɨpe kabsaƚ anɨbu ud ñɨŋa. ");
INSERT INTO kpw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pen Jisas kalɨp haga, “Nöd yad kale aip mɨdem, mɨñi yɨp göp unbö rö u gɨnab, a gem, kalöp hag ñɨmɨdin. Mosɨs yɨp manö kalɨ kƚiñ rɨka u, bɨ God manö hagep yɨp manö kalɨ kƚiñ rɨkla u, God Manö adɨŋ Sam a gɨpal u yɨp manö kalɨ kƚiñ rɨka u, yɨp kalɨ kƚiñ rɨkla rö nöp magöŋhalö unbö rö nöp gɨnab, a gem, kalöp hag ñɨ aij gɨnö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anɨg hagöm, God Manö kalɨ kƚiñ rɨkla u nɨŋ aij gɨlaŋ, a göm, gasɨ aij yabɨƚ u kalɨp ña. ");
INSERT INTO kpw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nɨpe anɨg göm, kalɨp haga, “Nöd gau kalɨ kƚiñ rɨköm hagla, ‘Mesaia u ilön kub udöm umö, rɨgöl gɨlö, ñɨn mɨhöp mɨdöm, ñɨn mɨhöp nɨgaŋ u kauyaŋ uraknab. ");
INSERT INTO kpw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Anɨb u, manö aij nɨpe u ram mɨnöŋ Jerusalem iƚ gɨ hag ñöm, hag ñɨ damöm, nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö hag ñɨlö arö nɨŋöl göm, nɨbi bɨ nan si nan naij gɨpal gau, nɨhön gɨnɨg anɨg gɨpun, a göm, arö göm, Krais nɨp cɨg gɨlö nɨŋöl göm, nan naij prɨ kale u ƚɨk gɨ yunab,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pen yɨp ga anɨbu amgö magö kale ke nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pen Bapi yad manö nöd hag la rö, yad kalöp ñɨnabin. Anɨb u, kale daun kub aui nöp mɨdmim, abad mɨdaimim. Kumi kabö adö laŋ au nɨbö pɨdöŋ ke apöm kalöp goŋ leinab u nɨŋmim arnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Anɨg hagöm, kalɨp paŋɨd damöm, Jerusalem arö göm, ram rɨƚɨg agƚö Bedani söl au amöm, God kalɨp abad mɨdeiaŋ, a göm, ñɨmagö nɨpe dap ranöm, God nɨp sabe ga. ");
INSERT INTO kpw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisas anɨg gö nɨŋöl göm, God nɨp dam ap ran jak ram mɨnöŋ kumi kabö adö laŋ au ud ara. ");
INSERT INTO kpw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Anɨg gö, kalɨp aij a gö nɨŋöl gɨ, hib nɨpe u haglö adö arö nɨŋöl göm, ado gɨ Jerusalem arla. ");
INSERT INTO kpw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amöm, pör pör nöp God nɨp sabe gep ram raul mɨgan u amöm, God hib nɨpe haglö adö armɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ram mɨnöŋ hadame dagol gau gɨ laga ñɨn u, God Manö mɨdeia. God Manö nɨpe God aip mɨdeia. God Manö nɨpe u rö nöp God me. ");
INSERT INTO kpw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ram mɨnöŋ hainö gɨ la; nöd yabɨƚ God Manö nɨpe God aip mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God nɨpe gö, God Manö nɨpe nan gau magöŋhalö gɨ la. Nan ap ke laga; nɨpe ke gɨ la nan gau nöp mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","God Manö nɨpe kamɨŋ mɨdep iƚ u. Kamɨŋ mɨdep magö anɨbu nɨbi bɨ kalɨp mailö ña. ");
INSERT INTO kpw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mailö anɨbu amöm nɨbi bɨ sɨbön göp aŋ au mɨdpal gau ñɨ lab nɨŋöm sɨbön mailö anɨbu paƚog göl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Nɨbi bɨ gau magöŋhalö Mailö anɨbu nɨp nɨŋ udöl, a göm, God bɨ ap nɨp hag lö, nɨpe apöm Bɨ Mailö halö anɨbu manö hag ñɨmɨdöp. Bɨ manö hag ñɨmɨdöp bɨ anɨbu hib nɨpe Jon. ");
INSERT INTO kpw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon nɨpe Mailö anɨbu wasö. Nɨpe yɨharɨŋ bɨ an Mailö mɨdöp manö u nɨbi bɨ gau kalɨp hag ñɨnɨg aua. ");
INSERT INTO kpw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mailö nɨŋö yabɨƚ anɨbu nɨpe ram mɨnöŋ iƚ i apöm nɨbi bɨ gau magöŋhalö kalɨp mailö ñöl gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","God Manö nɨpe ram mɨnöŋ iƚ i apöm mɨdmɨdöp. God nɨpe gö, God Manö nɨpe ke mɨnöŋ naböŋ iƚ i gɨ löm, nɨbi bɨ gau gɨ löm ga. Pen nɨpe ke ram mɨnöŋ iƚ i ap mɨdeia u, nɨbi bɨ nɨp amgö nɨŋöm Bɨ Kub u a göm nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nɨpe ram mɨnöŋ nɨpe ke aua u pen nɨbi bɨ nɨpe ke nɨp udagla. ");
INSERT INTO kpw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pen nɨbi bɨ au, Krais manö aij nɨpe u nɨŋ udöm, nɨp Bɨ Kub hon, a göm, udla gau, kalɨp geia God ñɨ pai nɨpe mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God ñɨ pai nɨpe mɨdpal u, bɨ ber gau udöm, ñɨ pai yag daulö mɨdpal rö mɨdagpal. God nɨpe ke gö ñɨ pai nɨpe mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pen Manö anɨbu, nɨpe apöm bɨ hañ romaŋ löm, hanɨp aip han mɨdmɨdöp. Anɨb u, hon mailö magö aij nɨpe hadö nɨŋbun. Nɨpe Bap Ñɨ nɨpe añɨ yabɨƚ u me, Bap nɨpe ke mailö magö aij ke halö mɨdöp rö, Ñɨ nɨpe u rö nöp mɨdöp. Pen nɨpe hañ romaŋ löm bɨ rö apöm, hanɨp magöŋhalö mög nɨŋöm mɨdmagö yabɨƚ löm, God Manö nɨŋö u magöŋhalö hag ñɨ aij gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","God Manö nɨpe aua u, Jon nɨpe nɨŋöm, wɨñ alöm nɨbi bɨ gau kalɨp haga, “Bɨ mɨñi auöp i nöp me, yad kalöp nöd hagnö, ‘Bɨ ap nɨpe yad hain aunab u pen yɨp yag dauagep adö u, nɨpe hadame dagol gau mɨdmɨdöp. Anɨb u, nɨpe yad rö wasö; nɨpe Bɨ Kub yabɨƚ,’ a gɨnö u, bɨ anɨbu me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nɨpe hanɨp nɨbi bɨ magöŋhalö mög yabɨƚ nɨŋöm, ud aij göm, nan aij aij iru nöp ñöb. ");
INSERT INTO kpw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Apiabö u lo manö adö u, God Mosɨs nɨp ñö, Mosɨs hanɨp ña u pen God nɨbi bɨ mög nɨŋöm ud aij gab manö nɨŋö anɨbu, Jisas Krais aua u me, mɨñi waiö nɨŋabun. ");
INSERT INTO kpw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nɨbi bɨ rɨmnap God nɨp nɨŋagal. Ñɨ añɨ nɨpe u nöp nɨpe ke God. Nɨpe Nap aip mɨdpil. Nɨpe Nap nɨpe hag waiö la nɨŋöm mɨñi hon Bap God hadö nɨŋbun. ");
INSERT INTO kpw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda bɨ kub Jerusalem nɨbö gau kale bɨ God nɨp nan sabe gep bɨ rɨmnap abe, bɨ God sabe gep ram wög gɨ ñɨmɨdal bɨ rɨmnap abe hag yuöm hagla, “Kale Jon mɨdöp ammim, ‘Ne an?’ ö gɨmim hag nɨŋmim,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kale Jon mɨdeia u amjaköm, nɨp hag nɨŋöm hagla, “Ne bɨ an?” ö gɨla. Hag nɨŋeila, nɨpe wai ñaga. Kalpe waiö hagöm haga, “Yad Krais u wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Anɨg hageia, kale pen hagla, “Anɨg hagpan u, ne an? Ne Ilaija aka?” gɨla. Anɨg hageila, Jon haga, “Yad Ilaija wasö,” ga. Anɨg hageia, kale pen hagla, “Ne bɨ God manö hagep pör abad mɨdpun u aka?” gɨla. Hageila, Jon wasö ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Anɨg hageia, bɨ anɨb gau pen hagla, “Anɨb u, ne an? Pen yad bɨ an a gɨmön hagnabön, hon amun bɨ kub hanɨp hag yubal gau kalɨp hag ñɨnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hageila, Jon kalɨp haga, “Yad mɨñi gabin i, bɨ God manö hagep Aisaia nöd haga rö nöp gabin. Nɨpe haga, ‘Yad bɨ ap ram mɨnöŋ nɨbi bɨ iru mɨdagpal, ram mɨnöŋ kabö nöp mɨdöp aŋ au mɨdem, wɨñ kub alem hagabin, “Pör Bɨ Kub auab a gɨmim, adan ƚɨk gɨ aij gɨmim,” a gabin,’ a ga. Yad Jon mɨñi gabin me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pen bɨ Jon nɨp hag nɨŋnɨg aula anɨb gau, bɨ Perisi rɨmnap aip aula. ");
INSERT INTO kpw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kale Jon nɨp hag nɨŋöm hagla, “Ne hagpan, yad Krais wasö, Ilaija wasö, bɨ God manö hagep abad mɨdpun u wasö gɨpan gö jɨ nɨhön gɨnɨg nɨbi bɨ gau kalɨp ñɨg pak ñabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hageila, Jon haga, “Yad kalɨp yɨharɨŋ ñɨg pak ñabin. Pen bɨ ap aŋ kalöp aui mɨdöp, nɨpe aigale bɨ rö mɨdöp a gɨmim nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bɨ anɨbu nɨpe yad hain aunab pen nɨpe yad rö wasö; nɨpe bɨ kub yabɨƚ, yad bɨ pro. Yad ma rɨrup nɨpe u nagɨ hubɨknam rö lagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon nɨbi bɨ gau kalɨp ñɨg pak ñɨmɨdöp ram rɨƚɨg agƚö Bedani, ñɨg Jodan goƚ böŋ nö lödaŋ nɨŋöm bɨ anɨb gau apöm nɨp manö anɨbu hag nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ruö Jisas auö nɨŋöl göm, Jon Jisas nɨŋöm nɨbi bɨ gau kalɨp haga, “Nɨŋim! God Sipsip Pi nɨpe hanɨp hag yuöp me u. Nɨpe me nɨbi bɨ mɨnöŋ naböŋ iƚ i gau gau magöŋhalö nan si nan naij gɨpal gac u ƚɨk gɨ yunab. ");
INSERT INTO kpw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Bɨ anɨbu me, yad hagnö, ‘Bɨ ap nɨpe yad hain aunab u pen yɨp yag dauagep adö u, nɨpe hadame dagol gau mɨdmɨdöp. Anɨb u, nɨpe yad rö wasö; nɨpe Bɨ Kub yabɨƚ,’ a gɨnö. ");
INSERT INTO kpw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bɨ kub anɨbu bɨ an a gem nɨŋagmɨdin. Pen Isrel nɨbi bɨ, bɨ kub anɨbu bɨ aigale bɨ rö mɨdöp u nɨŋöl a gem, kalɨp ñɨg pak ñɨnɨg aunö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pen Jon Jisas manö adö anɨbu nöp hagöm haga, “Bɨ anɨbi bɨ an, a gem, yad ke nɨŋagbnep; pen bɨ yɨp hag yuö apem nɨbi bɨ kalɨp ñɨg pak ñabin u haga, ‘Ne nɨŋnabön, Ana nɨpe bɨ an apöm, aip mɨdeinab, bɨ anɨbu nöp nɨbi bɨ gau kalɨp Ana Uɫ pak ñɨnab,’ a ga. Haga anɨbu me, mɨñi Ana u kumi kabö adö laŋ nɨbö yaur dapo rö u gɨ nɨp auajɨp ");
INSERT INTO kpw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","nɨŋem yad nɨŋ aij gem kalɨp manö nɨŋö hagabin, bɨ anɨbi nɨpe God Ñɨ nɨpe u nöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ruö pen, Jon bɨ nɨpe mɨhau aip, kauyaŋ ap ñɨg pak ñɨmɨdöp ka u mɨdlö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisas ap padiö, Jon nɨpe Jisas nɨŋöm nɨbi bɨ gau kalɨp haga, “Bɨ anɨbi God Sipsip Pi nɨpe me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anɨg hagö, Jon bɨ nɨpe mɨhau, manö anɨbu nɨŋmil, Jisas areia mɨgan u hain arlö. ");
INSERT INTO kpw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pen Jisas ado göm kalɨp mɨhöŋ nɨŋöm haga, “Nɨhön gɨnɨg auabil?” ö ga. Hageia haglö, “Rabai! Ne hanban gai?” ö gɨlö. Hibru manö hagöm “Rabai” a gɨlö manö anɨbu iƚ u “Manö Hag Ñeb Bɨ.” ");
INSERT INTO kpw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pen kale anɨg gɨmil hag nɨŋlö, Jisas haga, “Anɨb u, yad aip ammil nɨŋnabil,” a ga. Haga ñɨn anɨbu nöp dugo magö u ammil, nɨpe aip mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon bɨ nɨpe anɨb mɨhau, bɨ ap hib nɨpe Edru. Edru nɨmam nɨpe me Saimon Pida. ");
INSERT INTO kpw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Edru magö anɨbu nöp am nɨmam Saimon nɨp uƚhai nɨŋöm haga, “Mesaia u aunab a gun pör abad mɨdpun u mɨñi nɨŋbul,” a ga. “Mesaia” a ga manö magö u, Grik manö hagöm “Krais” a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Edru anɨg hagöm, nɨmam Saimon nɨp uɫ göm Jisas mɨdeia u arö, Jisas Saimon nɨp nɨŋöm haga, “Jon ñɨ nɨpe Saimon. Nöp Sipas a göl,” a ga. Arameik manö hagöm, hib Sipas a ga manö magö anɨbu, Grik manö hagöm Pida a gɨpal. Sipas abe Pida abe iƚ añɨ anɨbu “kabö.” ");
INSERT INTO kpw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ruö, Jisas ram mɨnöŋ Galili arnɨg, am Pilip nɨp nɨŋöm haga, “Yad aip arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip, Edru, Pida, ram mɨnöŋ kale Bedsaida nɨbö. ");
INSERT INTO kpw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pen Pilip am Nadanyel nɨp nɨŋöm haga, “Hon bɨ u, Mosɨs abe, bɨ God manö hagep rɨmnap abe kalɨ kƚiñ rɨköm hagla u, nɨp mɨñi nɨŋbun. Nɨpe me Jisas, Josep ñɨ nɨpe. Ram mɨnöŋ nɨpe Nasared nɨbö,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pilip anɨg hageia, Nadanyel haga, “Bɨ aij ap ram mɨnöŋ naij anɨbu nɨbö auagnab,” a ga. Hageia, Pilip haga, “Anɨg hagpan u, auö am nɨŋul!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Anɨg hagöm, kale bɨ mɨhau ammil söl söl gɨlö nɨŋöl gɨ, Jisas Nadanyel nɨp nɨŋöm haga, “Bɨ anɨbu bɨ Isrel yɨjɨg göl u me, nɨpe piral adö u hagagnab; nɨpe nɨŋö nöp waiö hagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Anɨg hagö, Nadanyel haga, “Ne aige gɨmön yɨp nɨŋban?” ö ga. Hageia, Jisas haga, “Pilip nöp hainö uɫ gɨnɨg nöb; yad nöp nöd nɨŋbin, ne asɨk mɨdajan rauan iƚ au,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Anɨg hagö, Nadanyel haga, “Manö hag ñeb bɨ. Nöp nɨŋbin! Ne God Ñɨ nɨpe, Isrel nɨbi bɨ Kiŋ hon,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Anɨg hageia, Jisas haga, “Nöp yɨharɨŋ rauan iƚ au nɨŋbin a gɨpin u me, yɨp nɨŋ udpan? Hainö nan ke nɨbö rɨmnap nɨŋnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisas anɨg hagöm haga, “Kalöp magöŋhalö nɨŋö hagabin, kumi kabö adö laŋ au pɨral hiɨkö, ejol gau apöm, yɨp Bɨ Ñɨ nɨpe nɨŋ amɨl apɨl, nɨŋ amɨl apɨl geinaböl nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ñɨn mɨhöp mɨdöm, bɨ ap nɨbi udnɨg göm, nɨbi bɨ wɨñ alö amöm, nan ñɨŋla Kena daun, ram mɨnöŋ Galili aŋ au. Ñɨn anɨbu, Jisas abe, bɨ nɨpe gau abe, kalɨp u rö nöp wɨñ alla arla. Pen Jisas nɨme abe am ram anɨbu mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ñɨg wain u ñɨŋ hakeila, Jisas nɨme apöm Jisas nɨp haga, “Wain u ñɨŋ hakpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Anɨg hageia, Jisas haga, “Yɨp anɨg gɨ anɨg gɨ, a gɨmön, yɨp hagagmön. Ñɨn yad u auagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hageia, nɨme nɨpe am bɨ wög gɨ ñeb gau kalɨp haga, “Jisas manö ap hagainɨm, hagnɨm rö nöp gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pen Juda nɨbi bɨ kabö udöm gɨpal rin kub yabɨƚ unbö kagoƚ jɨŋ u ud lɨlö mɨdeia. Rin kub añɨ añɨ ñɨg lida unbö ñɨnjuöl mamɨd u mɨl dap lep. Pen Juda nɨbi bɨ nagɨ adö kale gɨmɨdal rö, God amgö ilö nɨbi bɨ uɫ aij mɨdaiun, a göm, rin anɨb gau ñɨg mɨl dap hoŋ göm, ñɨn ma lɨ yumɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas pen, bɨ wög gɨ ñeb gau kalɨp haga, “Kabö rin gai i, ñɨg mɨl dapim hoŋ gɨpe, ajmaŋ raunɨm,” a ga. Hageia, haga rö geila haga, ");
INSERT INTO kpw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Mɨñi ñɨg mɨl dap lɨbim u, mɨl dammim, bɨ nan ñɨŋabun i abad mɨdöp u nɨp ñɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hageia, ñɨg yabɨƚ anɨbu mɨl dam bɨ kub u nɨp ñeila, nɨpe udöm ñɨŋ nɨŋa, ñɨg wain aij u mɨdeia. Pen nɨpe ñɨg wain anɨbu gai nɨbö göm nɨŋaga; bɨ wög gɨ ñeb gau kale nöp nɨŋla. Pen nɨpe nɨŋaga rö me, bɨ nɨbi udnɨg ga anɨbu nɨp wɨñ alö aueia haga, ");
INSERT INTO kpw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Pör nöp, ñɨg wain aij u nöd dap ñɨlö ñɨŋ haklö me, hainö ñɨg wain naij u ñɨlö ñɨŋbal. Pen ne ñɨg wain aij u dap lö mɨdajɨp, mɨñi nöp dap ñabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas nan gagep nöd nɨbö ga anɨbu, nɨpe Kena daun, ram mɨnöŋ Galili aŋ au mɨdöm ga. Nan gagep anɨbu göm, nɨpe aige bɨ rö mɨdeia u yamö bɨ nɨpe gau nɨŋöm, nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pen Kena daun arö göm, Jisas nɨpe ke, nɨme, nɨmam hain, bɨ nɨpe gau aip daun pro Kapaneam amöm, yöp ñɨn bad ap anɨb au mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda kai Pasopa ñɨn kub kale u söl ga nɨŋöm Jisas Jerusalem ara. ");
INSERT INTO kpw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas Jerusalem amöm, God sabe gep ram raul u nɨŋa, bɨ rɨmnap kale kaj kau, kaj sipsip, yaur dapo gau dap sɨkim göm, bɨ rɨmnap abañ bad gau löm, mab po adö asɨköm, mani yɨmjɨköm geila. ");
INSERT INTO kpw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas nɨŋöm, nagɨ ap udöm malɨköm, kaj sipsip kaj kau gau rɨdɨk gɨ höŋ yaŋ yuöm, mani dap pen pen yɨmjɨköm geila abañ bad gau mani halö ud hoŋ gɨ yua. ");
INSERT INTO kpw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Anɨg göm, nɨbi bɨ yaur dapo dap sɨkim geila gau kalɨp haga, “Nan anɨb gau ud arim. Bapi yad ram nɨpe u gɨpe sɨkim ram rö lagnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas anɨg geia, bɨ nɨpe gau gasɨ kale ara God Manö kalɨ kƚiñ rɨkla manö ap adö u. Manö anɨbu kalɨ kƚiñ rɨköm hagla, “Sabe gep ram ne u mɨdmagö yabɨƚ lem umnabin,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pen Juda bɨ kub rɨmnap apöm, Jisas nɨp hag nɨŋöm hagla, “Nöp an hagajɨp apön anɨg gabön? God nöp hagö apem gabin a gɨmön, nan gagep rö ap gö nɨŋun, ‘Nɨŋö hagpan,’ a gun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Anɨg hageila, Jisas kalɨp pen haga, “Kale God sabe gep ram anɨbi rɨb waƚ geinabim, ñɨn mɨhau nɨgaŋ kauyaŋ gɨ lɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Anɨg hageia hagla, “God sabe gep ram anɨbi, mɨ ñɨnjuöl mɨhöp ado gɨ da unbö kagoƚ jɨŋ (46) gɨ hakla u pen ne ñɨn mɨhau nɨgaŋ kauyaŋ gɨ lɨnabin a gan ar?” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pen Jisas nɨpe sabe gep ram manö haga anɨbu, hañ romaŋ nɨpe ke nöp haga. ");
INSERT INTO kpw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anɨb u me, hainö Jisas nɨpe umöm uraka u, bɨ nɨp hain gɨmɨdal gau God Manö u abe, Jisas nɨpe ke manö haga anɨbu abe gasɨ nɨŋöm, “Nɨŋö hagöp,” a göm nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas, Juda kai Pasopa ñɨn kub kale u Jerusalem mɨdöm, nan gagep rö rɨmnap geia u nɨŋöm, nɨbi bɨ gau, “Nɨpe nöp Mesaia u,” a göm nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Pen Jisas nɨbi bɨ gɨpal adö u ke nɨŋ aij göp rö, nɨbi bɨ anɨb gau gasɨ kale adö mai araia u nɨŋ aij ga u me, nɨpe kalɨp nɨbi bɨ nɨŋeb yad gau a göm udaga. ");
INSERT INTO kpw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bɨ Juda Kansol kub u bɨ ap mɨdmɨdöp, hib nɨpe u Nikodimas. Nɨpe Perisi bɨ ap. ");
INSERT INTO kpw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nɨpe sɨb yaŋ, Jisas nɨp nɨŋnɨg, mɨdeia u apöm haga, “Manö hag ñeb bɨ. Hon nɨŋbun, nan gagep rö gɨpan gau, ne ke gagbnap; God nɨpe ke nöp nöp aip mɨdöp u me, nan gagep rö anɨb gau gɨpan. Anɨb u, hon nɨŋbun, God nɨpe nöp nöp yuö apön hanɨp manö hag ñɨmɨdan,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hageia, Jisas haga, “Yad nöp nɨŋö yabɨƚ hagabin, nɨbi bɨ ke kamɨŋ hain nɨbö lɨnaböl gau nöp, God kalɨp udöm, ‘Nɨbi bɨ yad’ a göm, abad mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Anɨg hageia, Nikodimas aiö göm gasɨ iru nɨŋöm haga, “Nɨbi bɨ rɨk lɨlö kub gɨpal gau, kauyaŋ nɨme mudun aŋ au arlö, kauyaŋ yag daulö, nɨbi bɨ ke kamɨŋ hain nɨbö lɨlaŋ a gɨmön hagabön aka nɨhön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Hageia, Jisas haga, “Nöp nɨŋö yabɨƚ hagabin, nɨbi bɨ au, ñɨg u abe, God Ana u abe udöm ke kamɨŋ hain nɨbö lɨnaböl gau nöp, God kalɨp udöm, ‘Nɨbi bɨ yad’ a göm, abad mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nɨbi bɨ yag daubal rö yag daulö mɨdpal, pen God Ana nɨpe apöm ana magö kale aŋ daŋ gö kamɨŋ mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anɨb u, “Kale nɨbi bɨ magöŋhalö ke kamɨŋ hain nɨbö lɨmim,” manö hagajɨn anɨbu, ne aiö gɨmön gasɨ iru nɨŋagmön. ");
INSERT INTO kpw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yɨgön u gasɨ nɨpe ke apöm arab. Yɨgön udajɨp nɨŋbim u pen auöp lau halö, aröp lau halö, kale nɨŋagim. Anɨb u rö me, nɨbi bɨ God Ana ba lö, ke kamɨŋ hain nɨbö lɨbal gau,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Anɨg hageia, Nikodimas haga, “Ne hagabön adö anɨbu, aigegö gɨnɨm?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hageia, Jisas haga, “Ne Isrel nɨbi bɨ manö hag ñeb bɨ kub kale ap, pen ne nɨŋagpan ar? ");
INSERT INTO kpw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nöp nɨŋö yabɨƚ hagabin, hon ke nan nɨhön nɨŋ aij gun, nan nɨhön amgö ke nɨŋun, nɨŋbun anɨbu nöp kalöp hag ñɨbun u pen manö hagpun anɨbu nɨŋ udagpim. ");
INSERT INTO kpw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yad kalöp mɨnöŋ naböŋ iƚ i göp rö hagnö, nɨŋ udagpim rö, aige gɨmim God ram mɨnöŋ kumi kabö adö laŋ au göp rö hagnö, nɨŋ udnabim? ");
INSERT INTO kpw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pen nɨbi bɨ ap God ram mɨnöŋ kumi kabö adö laŋ au ajöm nɨŋaga; yad ke Bɨ Ñɨ nɨpe nöp anɨb laŋ mɨdem aunö. ");
INSERT INTO kpw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Pen hadame nöp haiŋo naij gau Isrel nɨbi bɨ kalɨp haulö umla, nɨŋöm Mosɨs haiŋo naij anɨb gau rö ap mab ba au laŋ lö, nɨbi bɨ an an haiŋo anɨb laŋ nɨŋla gau, kalɨp kamɨŋ la. Anɨb u rö me, Bɨ Ñɨ nɨpe nɨp mab ba laŋ al pak lɨlö, ");
INSERT INTO kpw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nɨbi bɨ an an nɨp nɨŋ udnaböl gau, kamɨŋ pör mɨdep u udnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God nɨbi bɨ ram mɨnöŋ iƚ i mɨdpal gau kalɨp mɨdmagö yabɨƚ löm, Ñɨ nɨpe añɨ yabɨƚ u kalɨp nan a göm ña. Anɨb u, nɨbi bɨ an an Ñɨ nɨpe anɨbu nɨp nɨŋ udnaböl gau, kalɨp kamɨŋ pör mɨdep u ñö, umöm ur gagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God Ñɨ nɨpe yua u, nɨbi bɨ gau kalɨp manö kub hagnɨm, a göm yuaga; nɨbi bɨ gau ud kamɨŋ yunɨm, a göm yua. ");
INSERT INTO kpw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Nɨbi bɨ an an Ñɨ nɨpe nɨp nɨŋ udnaböl gau, God kalɨp manö kub hagöm pen ilön ñagnab. Pen nɨbi bɨ nɨp nɨŋ udagnaböl gau, God Ñɨ nɨpe añɨ yabɨƚ anɨbu nɨp nɨŋ udagnaböl rö, God kalɨp hadö manö kub hagöm, pen ilön udnaböl a ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God nɨbi bɨ gau kalɨp manö kub hagöm pen ilön ñɨnab, iƚ anɨbu anɨg göl mɨdöp: Mailö mɨnöŋ naböŋ adö iƚ i auöp u pen nɨbi bɨ gau, mailö mɨdöp au arun, a gɨ gasɨ u nɨŋagal. Kale nan si nan naij gɨ mɨdpal rö, sɨb göp gau nöp mɨdaiun a gɨ gasɨ u nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mailö anɨbu nɨŋlö mulu lugö, ‘Naij gɨpun u, waiö nɨŋagöl,’ a göm, mailö mɨdöp au auagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pen nɨbi bɨ kabö rö gɨnaböl gau hagnaböl, ‘God hagöp rö nöp gabun u, waiö nɨŋlaŋ,’ a göm, mailö mɨdöp au aubal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hainö Jisas bɨ nɨpe gau aip am ram mɨnöŋ Judia aŋ gau am mɨdöl gɨ, nɨbi bɨ gau kalɨp ñɨg pak ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ainon ram mɨnöŋ Salim söl anɨb au mɨdeia. Pen ram mɨnöŋ Ainon au ñɨg iru mɨdeia. Anɨb u, ñɨn aŋ anɨb au, Jon nɨpe Ainon au mɨdöm, nɨbi bɨ gau iru nöp aueila nɨŋöm nɨpe kalɨp ñɨg pak ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ñɨn anɨbu kale Jon bɨ ñɨg pak ñeb nɨp nagɨ lagla. ");
INSERT INTO kpw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pen Juda bɨ ap apöm, Juda nagɨ adö kale, ñɨg lɨ yuun God amgö ilö mɨd aij gun a gɨmɨdal manö adö u hagöm, Jon bɨ nɨpe rɨmnap aip pen pen hagla. ");
INSERT INTO kpw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pen pen hagöm, Jon bɨ nɨpe gau apöm nɨp hagla, “Manö hag ñeb bɨ. Bɨ au ñɨg Jodan goƚ böŋ lödaŋ mɨdö, nɨp Bɨ Kub a gaina u, mɨñi ap nɨbi bɨ kalɨp ñɨg pak ñab nɨŋöm nɨbi bɨ magöŋhalö nɨp araböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Anɨg hageila, Jon haga, “God gasɨ nɨpe ke nɨŋöb rö, hanɨp wög adö ke ke hag löp. ");
INSERT INTO kpw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kale ke nɨŋbim yad kalöp hagnö, ‘Yad Krais wasö; God hagö yad yɨharɨŋ adan nɨpe u ƚɨk gabin,’ a gɨnö. ");
INSERT INTO kpw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bɨ ap nɨbi udnab ñɨn u, nɨpe nɨbi nɨpe udnab. Nɨbi anɨbu nɨbi nɨpe me u. Bɨ nɨbi udnab bɨ u, bɨ nɨŋeb nɨpe ap apöm nɨp gɨ ñɨnab. Mañ mai nɨbi nɨpe udnɨg aunab a göm, nɨp abad mɨdeinab. Pen nɨpe nɨbi udnɨg apöm ‘Aubin’ a gɨnab u, bɨ nɨŋeb nɨpe mɨñ mɨñ gɨnab. Yad me anɨbu rö. Jisas nɨpe nɨbi bɨ gau kalɨp anɨg göm gab u, yɨp aij göp. Uri yad mɨñ mɨñ yabɨƚ gabin. ");
INSERT INTO kpw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hib nɨpe ap ranö nɨŋöl gɨ, hib yad ap lugnab u aij. ");
INSERT INTO kpw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Bɨ kumi kabö adö laŋ au nɨbö auöp u, nɨpe nɨbi bɨ gau magöŋhalö adö laŋol mɨdöp. Bɨ mɨnöŋ naböŋ iƚ i nɨbö bɨ u, nɨpe mɨnöŋ naböŋ iƚ i nɨbö u me, mɨnöŋ naböŋ iƚ i gasɨ nɨŋöm manö hagpal rö hagab. Pen bɨ kumi kabö adö laŋ au nɨbö auöp u, nɨpe nɨbi bɨ gau magöŋhalö adö laŋol mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nɨpe kumi kabö adö laŋ au mɨdöm nan nɨhön amgö nɨŋöb u, manö nɨhön apdi nɨŋöb u, nɨbi bɨ gau kalɨp hag ñab, pen manö nɨpe u udagaböl. ");
INSERT INTO kpw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pen nɨbi bɨ manö nɨpe nɨŋ udpal gau, God manö nɨŋö u nöp hagöp a göm nɨŋ udpal. ");
INSERT INTO kpw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God nɨpe Jisas yua u, Ana nɨpe u nɨp ñö ajmaŋ rauö, God manö magö nɨpe nöp hag ñab. ");
INSERT INTO kpw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nap Ñɨ nɨpe nɨp mɨdmagö löm, ‘Nan gau magöŋhalö abad mɨdaimön,’ a göm, ud ñɨmagö adö nɨpe u löp. ");
INSERT INTO kpw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nɨbi bɨ an an Ñɨ nɨpe nɨp nɨŋ udpal gau, pör mɨdep magö u hadö udpal. Pen nɨbi bɨ an an Ñɨ nɨpe nɨp nɨŋ udagnaböl gau, kale pör mɨdep magö u udagnaböl; God nɨbi bɨ anɨb gau kalɨp hadö manö kub hagö, marö udöl gɨ nöp mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pen bɨ Perisi gau manö rɨmnap apdi nɨŋla, nɨbi bɨ iru nöp, Jisas pɨg mɨdaiun, a göm, nɨp aueila kalɨp ñɨg pak ña; pen nɨbi bɨ iru nöp Jon nɨp auagla. ");
INSERT INTO kpw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pen Jisas nɨpe ke nɨbi bɨ gau kalɨp ñɨg pak ñaga; bɨ nɨpe gau nöp kalɨp ñɨg pak ñɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pen Perisi kai manö anɨbu rö hageila nɨŋöm Jisas ram mɨnöŋ Judia arö göm, ado gɨ ram mɨnöŋ Galili ara. ");
INSERT INTO kpw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pen adan aŋ au aramöm nɨpe ram mɨnöŋ Sameria amjaka. ");
INSERT INTO kpw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pen ram mɨnöŋ Sameria aŋ au aramöm, Sikar daun amjaka. Sikar söl anɨb au me, hadame nöp Jekop ñɨ nɨpe Josep nɨp mɨnöŋ naböŋ ap haga. ");
INSERT INTO kpw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pen Jekop ñɨg uƚöm uda u mɨdeia u me, Jisas auö auö, sɨdö aŋ laŋ magö u iru ga rö, am ñɨg uƚöm goƚ söl anɨb au asɨka. ");
INSERT INTO kpw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pen bɨ nɨpe gau nan magö raunɨg, Sikar daun anɨbu arla. Jisas ñɨg uƚöm söl au asɨk mɨdeia nɨŋöm nɨbi Sameria nɨbö ap ñɨg mɨlnɨg aua. Aueia, Jisas nɨŋöm haga, “Yɨp ñɨg mɨl ñö ñɨŋɨn,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hageia, nɨbi anɨbu haga, “Kale Juda nɨbi bɨ, hanɨp Sameria nɨbi bɨ nɨŋmim, asɨ masɨ gɨ aij gɨpim rö, nɨhön gɨnɨg, ‘Yɨp ñɨg mɨl ñö ñɨŋɨn,’ a gɨmön hagabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Anɨg hageia, Jisas pen haga, “God nan aij nɨbi bɨ ñɨnɨg gab u nɨŋmön, yad nöp ñɨg mɨl dap lɨmön a gabin yad bɨ an rö mɨdpin nɨŋbnap u, ne yɨp hagbnap, yad nöp ñɨg kamɨŋ magö ñeb ñɨbnep. ");
INSERT INTO kpw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hageia, nɨbi anɨbu haga, “Bɨ kub. Ñɨg mɨlep rin ne ap mɨdagöp; ñɨg uƚöm u rö nöp i gɨyaŋ mɨdöp. Anɨb u, ñɨg kamɨŋ magö ñeb anɨbu gai nɨbö udnabön? ");
INSERT INTO kpw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bac iƚaŋ hon Jekop ñɨg uƚöm anɨbi hanɨp ña. Ñɨg anɨbi nöp, nɨpe ke abe, ñɨ nɨpe bɨ abe ñɨŋöm, kaj sipsip nan nɨpe gau ñɨŋöm gɨmɨdal. Anɨb u, yad bɨ kub, Jekop bɨ pro, a gɨ gasɨ nɨŋban ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hageia, Jisas haga, “Nɨbi bɨ ñɨg i ñɨŋnaböl gau, kalɨp kauyaŋ ñɨg nan gɨnɨg gab; ");
INSERT INTO kpw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pen nɨbi bɨ ñɨg yad ñɨnö ñɨŋnaböl gau, kalɨp kauyaŋ ñɨg nan gagnab. Pen ñɨg yad ñɨnabin anɨbu ñɨŋlö, kalɨp aŋ daŋ ñɨg ilam ajöŋ rö juöl gɨ, kalɨp pör mɨdep u ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jisas anɨg hageia, nɨbi anɨbu pen haga, “Bɨ kub. Yɨp ñɨg anɨbu ñö ñɨŋnö, hainö yɨp ñɨg nan gagnɨm; apem ñɨg i mɨlagnam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Anɨg hageia, Jisas haga, “Am nagamul ne paŋɨd dau,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hageia haga, “Yad bɨ halö wasö,” ga. Hageia, Jisas haga, “Manö anɨbu nɨŋö hagabön. ");
INSERT INTO kpw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bɨ unbö mamɨd u udna u pen bɨ mɨñi aip mɨdpil u, nagamul ne wasö. Anɨb u, nɨŋö hagabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Anɨg hageia, nɨbi anɨbu haga, “Bɨ kub. Yad nɨŋbin, ne bɨ God manö hagep bɨ ap. ");
INSERT INTO kpw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Apɨs bac hon hadame nöp gau dum i God nɨp sabe gɨmɨdal rö, hon u rö nöp sabe gɨ mɨdpun u pen kale Juda kai hagpim, ‘Jerusalem nöp God nɨp sabe göl,’ a gɨpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Anɨg hageia, Jisas haga, “Yad manö nɨŋö hagabin anɨbi nöŋ. Hainö dum anɨbi abe Jerusalem abe Bapi nɨp sabe gagnabim. ");
INSERT INTO kpw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kale Sameria nɨbi bɨ sabe gɨpim pen bɨ aigale bɨ rö nɨp sabe gɨpim u nɨŋagpim; pen hon Juda nɨbi bɨ, Bɨ sabe gɨmɨdun Bɨ u nɨŋbun. Nɨhön gɨnɨg: God nɨpe aige göm nɨbi bɨ ud kamɨŋ yunab u, hanɨp Juda nɨbi bɨ haga. ");
INSERT INTO kpw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ñɨn söl auub, pen mɨñi hadö auöp i, God Ana nɨpe nɨbi bɨ gasɨ ñö nɨŋöl gɨ, kale Bapi nɨp kabö rö sabe gɨnaböl; anɨg gɨnaböl u, nɨp aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God nɨpe Ana mɨdöp u me, nɨbi bɨ God nɨp sabe göm, ana kalɨp aŋ daŋ nɨŋö nöp sabe göl. ");
INSERT INTO kpw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jisas anɨg hageia, nɨbi anɨbu pen haga, “Yad nɨŋbin, hainö Mesaia u apöm, hanɨp nan magöŋhalö hag ñɨ aij gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hageia, Jisas haga, “Bɨ anɨbu me yad mɨdpin. Ne aip manö hagabul i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas anɨg hageia nɨŋöm magö anɨbu bɨ nɨpe gau apjaköm nɨŋla, Jisas nɨbi ap aip manö gɨ mɨdailö, nɨŋöm kale pa gɨƚɨ gɨla. Pen bɨ kale ap uraköm, nɨbi u nɨp “Ne manö nɨhön mɨdöp?” a göm hagagla. Jisas nɨp u rö nöp, “Nɨhön gɨnɨg nɨbi anɨbu aip manö adɨŋ adɨŋ gajɨl?” a göm hagagla. ");
INSERT INTO kpw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pen nɨbi anɨbu, ñɨg rin u arö göm, kauyaŋ ado gɨ daun anɨbu amöm, nɨbi bɨ mɨdeila anɨb gau kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Apim, nan gau magöŋhalö gɨpin rö hag ñöb bɨ u nɨŋim! Nɨpe Mesaia u aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Anɨg hageia, nɨbi bɨ anɨb gau daun anɨbu arö göm, Jisas nɨp nɨŋun a göm aueila. ");
INSERT INTO kpw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pen Jisas bɨ nɨpe gau Jisas nɨp neb neb göm hagla, “Manö hag ñeb bɨ. Nan ñöŋ!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hageila, nɨpe pen haga, “Nan ñɨŋeb yad mɨdöp u kale nɨŋagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Anɨg hageia, bɨ nɨpe gau kale ke nöp hag nɨŋ hag nɨŋ göm hagla, “Nɨbi bɨ rɨmnap nɨp nan magö dap ñɨbal aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pen Jisas kalɨp haga, “Kalöp nan magö anɨb gau nan göp; yɨp pen nan magö anɨb gau nan gagöp. Bapi manö haga u nöp gasɨ lajɨp me, gasɨ anɨbu nɨŋem, wög hagöp u gɨ junam a gɨ gasɨ nɨŋbin. Nan ñɨŋeb yad me u. ");
INSERT INTO kpw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pen kale manö ap hagpim, ‘Rakɨn mɨhau mɨhau mɨdöl, wid magö po gö am rɨk daunabun,’ a gɨpim u pen mɨñi anɨg hagagmim. Amgö kale u nɨŋ padimim nɨŋim! Wid wög gau po göm rɨk dauep rö mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pen uri nöp, nɨbi bɨ wid po rɨk dauaböl nɨbi bɨ gau, mɨñ mɨñ göl gɨ wid po göp anɨbu rɨk dam kamɨŋ pör mɨdep mɨgan u löm, pe kale udaböl me u. Anɨb u me, nɨbɨ bɨ wid magö ranaŋ a göm dam yubal gau abe, nɨbi bɨ wid po göp rɨk dauaböl gau abe jɨm ñöm, wid po u kamɨŋ pör mɨdep mɨgan u mɨdnab u nɨŋöm, mɨñ mɨñ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hon manö ap hagpun, ‘Nɨbi bɨ rɨmnap wid magö yulö rannab, nɨbi bɨ rɨmnap am rɨk daunaböl,’ a gɨpun u, nɨŋö yabɨƚ hagpun. ");
INSERT INTO kpw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yad kalöp hag yunö, am wid rɨk daubim. Wid wög anɨbu kale wög kƚö gɨmim gagpe; nɨbi bɨ rɨmnap kƚö kale u gɨlö ranöb. Kale yɨharɨŋ am rɨk daumim nan aij udpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nɨbi Sameria nɨbö anɨbu am nɨbi bɨ nɨpe gau kalɨp haga, “Bɨ anɨbu nan gɨpin gɨpin gau magöŋhalö yɨp hag ñöb,” a ga u me, nɨbi bɨ Sameria nɨbö daun anɨbu mɨdeila gau iru nöp Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pen Sameria nɨbi bɨ, kale Jisas mɨdeia au apöm, Jisas manö neb neb göm hagla, hon aip am mɨdaiun a gɨlö, Jisas ñɨn mɨhöp am kale aip mɨdöm, ");
INSERT INTO kpw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","manö hag ñö, nɨbi bɨ rɨmnap halö iru nöp manö anɨbu nɨŋöm nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pen kale anɨg göm nɨŋ udöm, nɨbi anɨbu nɨp hagla, “Mɨñi manö ne u nöp hagö nɨŋ udagpun; Jisas manö nɨpe u ke hagö nɨŋun nɨŋbun, nɨpe nöp nɨbi bɨ ram mɨnöŋ iƚ i mɨdpal gau gau magöŋhalö kalɨp ud kamɨŋ yunɨg aua. ");
INSERT INTO kpw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas ñɨn anɨb mɨhau ram mɨnöŋ anɨbu mɨdöm, ruö ram mɨnöŋ Galili ara. ");
INSERT INTO kpw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nɨpe nöd manö ap hagöm haga, “Bɨ God manö hagep bɨ gau, ram mɨnöŋ kale ke au mɨdöm manö hagnaböl u, manö kalɨp udagnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pen Pasopa ñɨn u, Galili nɨbi bɨ rɨmnap am Jerusalem mɨdeila. Kale Jerusalem mɨdeila nɨŋöl gɨ, Jisas nan gagep rö gau gö nɨŋla u me, Jisas uri ram mɨnöŋ Galili amjakö, kale nan gagep rö Jerusalem ga u gasɨ nɨŋöm, nɨp mɨñ mɨñ gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pen Jisas am Galili mɨdöm, kauyaŋ Kena daun ara. Kena daun anɨbu me, nöd ñɨg yabɨƚ u gö ñɨg wain la. Pen daun pro Kapaneam au, bɨ kub ap ñɨ nɨpe nan ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bɨ kub anɨbu manö ap nɨŋa, Jisas ram mɨnöŋ Judia arö göm, ap ram mɨnöŋ Galili mɨdeia. Anɨb u, Jisas mɨdeia u apöm, nɨp neb neb göl gɨ haga, “Ñɨ yad u nan gö umnɨg gab. Ne yɨŋɨd am nɨp gö kamɨŋ laŋ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Anɨg hageia, Jisas haga, “Kale yɨharɨŋ yɨp nɨŋ udagnabim; nan gagep rö rɨmnap gɨnö nɨŋmim nöp, yɨp nɨŋ udnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pen bɨ kub anɨbu haga, “Bɨ Kub! Auö arul! Wasö u, ñɨ yad u umnab!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hageia, Jisas haga, “Aru! Ñɨ ne u mɨdeinab,” a ga. Anɨg hageia, Jisas nɨŋö hagöp, a göm, hada. ");
INSERT INTO kpw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Adan aŋ au arö nɨŋöl gɨ, bɨ wög gɨ ñeb nɨpe rɨmnap ap nɨp nable paköm hagla, “Ñɨ ne u umagöp; mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anɨg hageila, ñɨ yad u magö mai rö kamɨŋ löp, a göm, kalɨp hag nɨŋö hagla, “Rol sɨdö gamɨŋ ga magö u, hañ pɨböŋ ga u kamɨŋ la,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Anɨg hageila ñɨ nap nɨpe nɨŋa, Jisas, “Ñɨ ne u mɨdeinab,” a ga magö u nöp kamɨŋ la. Anɨb u me, nɨbi bɨ nɨpe gau aip magöŋhalö Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pen Jisas nɨpe nöd Kena apöm, nan gagep nöd nɨbö göm, ñɨg yabɨƚ u gö ñɨg wain la; hainö pen nan gagep yɨgwö aŋ nɨbö u göm bɨ kub u ñɨ nɨpe nɨp gö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hainö pen Juda kai nan kub ñɨŋeb ñɨn u uri a göm, Jisas Jerusalem ara. ");
INSERT INTO kpw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ram mɨnöŋ Jerusalem anɨbu, kaj sipsip dap amɨl apɨl gɨmɨdal adan ramö goƚ au ñɨg waŋö kub ap mɨdeia. Ñɨg waŋö anɨbu Arameik manö löm, Bedesda a gɨmɨdal. Pen ñɨg goƚ mɨhau mɨhau abe ñɨg ubɨŋ aŋ au mɨdeia adö u abe, ram badö mɨlö unbö mamɨd mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pen nɨbi bɨ nan ga gau iru nöp ap ram bada anɨb gau han mɨdeila. Nɨbi bɨ anɨb gau, rɨmnap amgö we ga, rɨmnap ma naij ga nɨŋöm ajagmɨdal, rɨmnap hañ romaŋ kale böŋ nöp kaƚa ga. Pen ñɨg waŋö u aŋa gɨnab aka göm apöm han mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ñɨn rɨmnap God ejol ap apöm, ñɨg waŋö u aŋa gö, nɨbi bɨ an nöd ujaŋɨd ñɨg waŋö anɨb yaŋ lugnab u, nɨpe nan nɨhön gɨnab u kamɨŋ lɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pen bɨ ap nan gö, pör nöp um mɨdö, mɨ in ñɨn juöl ado gɨ da kagoƚ böŋ daŋ (38) la, ñɨg waŋö goƚ au dam lɨla mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas bɨ anɨbu nɨŋöm, mɨlö padö anɨgöl mɨdmɨdöp u nɨŋöm, nɨp haga, “Nöp kamɨŋ lɨnɨm, a gɨmön, nɨŋban?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hageia, bɨ nan ga anɨbu haga, “Bɨ kub. Ñɨg u aŋa gö nɨŋöl gɨ, yɨp ud ñɨg waŋö aŋ yaŋ löl nɨbi bɨ ap mɨdagpal. Yad ñɨg aŋ yaŋ nöd arnam a gɨpin u pen nɨbi bɨ rɨmnap yɨŋɨd nöp nöd arbal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Anɨg hageia, Jisas pen nɨp haga, “Urakmön, köp ne u wɨnɨg ud aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hageia, magö anɨbu nöp nɨp kamɨŋ lö nɨŋöl gɨ, uraköm köp nɨpe u wɨnɨg udöm, ud ara. Pen Jisas bɨ anɨbu nɨp gö kamɨŋ la ñɨn anɨbu, Juda kai God nɨp sabe gep ñɨn kale u me, ");
INSERT INTO kpw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda bɨ kub gau, bɨ kamɨŋ la anɨbu nɨp hagla, “Ñɨn i God nɨp sabe gep ñɨn hon. Pen ne köp bad ne u ud ajabön u, lo manö hon u wɨhö göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hageila, haga, “Bɨ yɨp gajɨp kamɨŋ löp u hagöp, ‘Urakmön, köp bad ne u wɨnɨg ud aru,’ a gajɨp u me, ud ajabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hageia, hagla, “Bɨ nöp hagö, köp bad wɨnɨg ud ajabön bɨ anɨbu bɨ an?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pen Jisas nɨpe nɨbi bɨ iru mɨdeila aŋ anɨb au agamɨj ara rö, bɨ kamɨŋ la anɨbu, “Bɨ yɨp gajɨp kamɨŋ löp me i,” a göm, hagnɨm rö laga. ");
INSERT INTO kpw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hainö pen, Jisas bɨ anɨbu nɨp God sabe gep ram raul u nɨŋöm haga, “Nöŋ! Nöp kamɨŋ löp. Anɨb u, nan si nan naij gɨmɨdan u arö gɨmön. Wasö u, nöp nan kub yabɨƚ gɨnɨm rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pen bɨ anɨbu nɨpe ado gɨ amöm, Juda bɨ kub gau kalɨp haga, “Jisas nöp yɨp gajɨp kamɨŋ löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Anɨg hageia nɨŋöm, God nɨp sabe gep ñɨn u gö kamɨŋ la, a göm, Juda bɨ gau Jisas nɨp mulu kal nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas pen kalɨp haga, “Bapi yad u pör nöp wög göl gɨ nöp mɨdöp rö, yad u rö nöp gɨnam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Anɨg hagö, Juda bɨ kub gau, nöd nɨp alun, a göm gasɨ nɨŋla u, uri kƚö yabɨƚ göm nɨŋla. Kale hagla, “Nɨpe God nɨp sabe gep ñɨn hon u rɨb rɨköm, ‘Yad God Ñɨ nɨpe,’ a göp. Anɨb u, God nɨpe mɨdöp rö, yad anɨb unbö rö nöp mɨdpin, a göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas pen kalɨp haga, “Kalöp nɨŋö hagabin, Ñɨ u nɨpe ke nan ap gɨnɨm rö lagöp; Nap nan gɨnab gau nöp nɨŋöm gɨnab. Anɨb u, Nap gɨnab rö, Ñɨ nɨpe u rö nöp gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nap Ñɨ nɨpe nɨp mɨdmagö löm, nan nɨpe göp göp gau magöŋhalö yamöb. Rɨmnap yamö me, nan ke yabɨƚ gau gö nɨŋmim, kale magöŋhalö aiö gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pen Nap nɨbi bɨ umbal gau gö urakpal rö, Ñɨ nɨpe u rö nöp, nɨbi bɨ rɨmnap, kalɨp gɨnö uraklaŋ, a gɨnab u, gö uraknaböl. ");
INSERT INTO kpw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nɨbi bɨ nɨhön nɨhön gɨpal, gasɨ nɨhön nɨhön nɨŋbal u, Nap nɨŋöm kalɨp manö kub hagagnab; Ñɨ nɨpe nɨp hagö, nɨpe kalɨp magöŋhalö manö kub hagnab. ");
INSERT INTO kpw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Anɨb u me, nɨbi bɨ kale Nap hib nɨpe haglö adö arnab u rö, Ñɨ nɨpe hib u abe u rö nöp haglö adö arnab. Pen nɨbi bɨ God Ñɨ nɨpe u nɨp nɨŋöm, hib nɨpe haglö adö aragnab gau, Nap Ñɨ nɨpe hag yua u abe u rö nöp hib haglö adö aragnab. ");
INSERT INTO kpw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kalöp nɨŋö hagabin, nɨbi bɨ an manö yad u nɨŋöm, Bɨ yɨp hag yuö aunö u nɨp nɨŋ udpal gau, manö kub hag ilön udep adö u nɨŋagnaböl; kale pör mɨdep u hadö udpal. Anɨb u, kale umeb adö u arö göm, pör mɨdep adö u hadö mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kalöp nɨŋö yabɨƚ hagabin, ñɨn hain pör abad mɨdpim u söl auab — pen mɨñi hadö auöp i — nɨbi bɨ umöl rö mɨdpal gau, God Ñɨ nɨpe manö hagö, manö anɨbu nɨŋöm nɨŋ udnaböl gau, kamɨŋ lɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bapi nan gau magöŋhalö kamɨŋ mɨdep iƚ u mɨdöp rö, yad Ñɨ nɨpe u rö nöp kamɨŋ mɨdep iƚ u mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yad Ñɨ nɨpe pen, Bɨ Ñɨ nɨpe mɨdpin rö, yɨp hagö, nɨbi bɨ gau kalɨp manö kub hagem nɨme lɨnabin. ");
INSERT INTO kpw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Manö hagabin anɨbu nɨŋmim aiö gagmim: hainö yad hagnö, nɨbi bɨ umlö rɨgöl gɨla gau, ");
INSERT INTO kpw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","magöŋhalö manö yad nɨŋöm, uraköm, nɨbi bɨ gɨ aij gɨla gau, am yad aip kamɨŋ mɨdeinaböl; pen nɨbi bɨ gɨ naij gɨla gau, uraköm manö kub nɨŋöm pen ilön kub udnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Pen yad nan nɨhön nɨhön gɨnabin gau, ke nɨŋem gagnabin; Bapi yɨp hagnab rö nöp gɨnabin. Anɨb u, nɨbi bɨ manö kub hagem nɨme lɨnabin u, Bapi hagnab rö nɨŋem, kabö göl nöp nɨme lɨnabin. Nɨhön gɨnɨg: yɨp aij gɨnab adö u manö kub hagagnabin. Bɨ yɨp hag yuö aunö Bɨ anɨbu nɨp aij gɨnab adö u nöp gasɨ nɨŋem, manö kub hagem nɨme lɨnabin. ");
INSERT INTO kpw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yad ke, ‘God yɨp yuö aunö,’ a gɨbnep u, manö anɨbu kabö rö gagöp a gɨbep. ");
INSERT INTO kpw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pen Bɨ ap halö yad bɨ aigale bɨ rö mɨdpin u hagöp. Yad nɨŋbin, manö hagöp anɨbu nɨŋö nöp hagöp. ");
INSERT INTO kpw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kale Juda kai bɨ kale rɨmnap hag yube, kale Jon nɨp amöm, yad bɨ aigale bɨ rö mɨdpin, a göm hag nɨŋla u, nɨpe manö nɨŋö nöp kalɨp haga me u. ");
INSERT INTO kpw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jon aka bɨ ram mɨnöŋ iƚ i bɨ ap yad bɨ aigale bɨ rö mɨdpin u hagnab u, yɨp nan kub wasö. Pen kale Jon manö haga u nɨŋmim, manö nɨŋö yabɨƚ a gɨmim nɨŋ udmim, kamɨŋ arnabim a gem, Jon manö yɨp anɨg göl haga, a gɨpin. ");
INSERT INTO kpw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon manö haga u, nɨpe hapö mɨɫaŋ mailö ñab rö mɨdö, kale manö haga anɨbu mailö rö nɨŋmim, magö pro uƚep magö ap nöp mɨñ mɨñ gɨpe. ");
INSERT INTO kpw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon kalöp hag aij ga pen u yɨharɨŋ manö nöp haga. Yad mɨnöŋ naböŋ iƚ i apem, Bapi yɨp gɨmön a ga rö, nan ke yabɨƚ gau gɨpin u me, kale Bapi nɨpe nöp yɨp hag yua u, a gɨmim, waiö yabɨƚ nɨŋbep. ");
INSERT INTO kpw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bapi yɨp hag yua u, nɨpe ke, yad bɨ aigale bɨ rö mɨdpin u, kalöp manö nɨŋö hagab. Pen kale meg magö nɨpe u apdi nɨŋagpim. Nɨpe bɨ aigale bɨ rö mɨdöp u, a gɨmim nɨŋagpim. ");
INSERT INTO kpw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kale yad bɨ nɨpe hag yua manö yad u nɨŋ udagpim rö, God Manö mɨdmagö kalöp aŋ daŋ mɨdagöp. ");
INSERT INTO kpw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Kale, pör mɨdep udun, a gɨmim, God Manö u amgö lɨ nɨŋ aij gɨpim u pen manö anɨbu, yɨp a göm kalɨ kƚiñ rɨkla rö nɨŋmim, pör mɨdep udun, a gɨmim, yɨp auagpim. ");
INSERT INTO kpw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nɨbi bɨ gau hib yad haglö adö araŋ a gem hagagabin. ");
INSERT INTO kpw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pen kale nɨbi bɨ aigale bɨ rö mɨdpim u hadö nɨŋbin. Kale God nɨp mɨdmagö lagpim u nɨŋem hagabin. ");
INSERT INTO kpw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bapi nɨpe ke yɨp hag yuö aunö u pen yɨp udagpim. Pen bɨ yɨharɨŋ ap gasɨ nɨpe ke nɨŋöm aueinab u, nɨp udnabim. ");
INSERT INTO kpw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɨbi bɨ rɨmnap gau hib kale haglö adö areinab u, kalöp aij gɨnab. Pen Bɨ God añɨ nöp mɨdöp u hanɨp nɨŋö, aij gɨnɨm, a gɨmim, gasɨ u nɨŋagpim. Anɨb u, kale ai gɨmim yɨp nɨŋ udnabim? ");
INSERT INTO kpw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Pen Bapi manö yad udöm, kalöp manö kub hagnab, a gɨmim, gasɨ u nɨŋagmim, wasö. Mosɨs hanɨp gɨ ñɨnab a gɨpim u pen Bapi nɨpe Mosɨs manö nɨpe haga manö anɨbu udöm kalöp manö kub hagnab. ");
INSERT INTO kpw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosɨs nɨpe God Manö kalɨ kƚiñ rɨköm manö rɨmnap yad bɨ aigale bɨ rö mɨdpin manö u kalɨ kƚiñ rɨka. Pen Mosɨs manö kalɨ kƚiñ rɨka manö anɨbu udagpe rö, manö yad hagabin u rö nöp udagnabim. ");
INSERT INTO kpw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mosɨs manö kalɨ kƚiñ rɨka udagpim rö, kale ai gɨmim manö yad hagabin u udnabim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pen Jisas anɨg gɨ mɨdöm, hainö ñɨg magɨb udöm, Ñɨg Waŋö Galili juöm, böŋ lödaŋ ara. Ñɨg Waŋö Galili anɨbu nöp me, hib ap Ñɨg Waŋö Daibirias a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pen Jisas nɨpe nɨbi bɨ nan ga gau gö kamɨŋ la u nɨŋmɨdal rö, nɨbi bɨ iru nöp nɨp hain gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pen Jisas bɨ nɨpe gau aip am dum au gɨlaŋ amöm, asɨk mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ñɨn aŋ anɨb au Juda kai Pasopa ñɨn kub kale u söl söl ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Jisas bɨ nɨpe aip dum au asɨk mɨdöm, amgö gɨlaŋ göm nɨŋa, nɨbi bɨ iru yabɨƚ nöp nɨp aueila. Jisas nɨŋöm, nɨpe nɨhön nɨhön gɨnab u ke nɨŋa u pen bɨ nɨpe Pilip nɨhön hagnab, a göm, nɨp haga, “Hon nan magö gai nɨbö udun, nɨbi bɨ iru nöp gai i kalɨp ñɨno ñɨŋnaböl?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hageia, Pilip haga, “Mani silpa magö unbö ñɨn juöl sɨduŋ laŋ (200) rö yuun, bred rau dapun, ud jö gɨ pro pro gun, nɨbi bɨ anɨb gai i ñeinabun, magöŋhalö nan pro pro ñɨŋöl rö lɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Anɨg hagö, bɨ nɨpe Edru, Saimon Pida nɨmam u haga, ");
INSERT INTO kpw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ñɨ pro ap bred bali plaua ud laubal bred magö unbö mamɨd, kabsaƚ mɨhöp halö ud mɨdöp i, pen nan anɨbu nɨbi bɨ iru yabɨƚ gai i nan kub wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hageia, Jisas haga, “Nɨbi bɨ gau hagpe, asɨklaŋ,” a ga. Hageia, bɨ nɨpe gau nɨbi bɨ gau kalɨp hageila, nan uɫaŋ iru nöp ran aij ga gau adö anɨb gau magöŋhalö asɨkla. Bɨ gau nöp me, paip dausan (5000) rö ara. ");
INSERT INTO kpw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kale anɨg göm asɨkla nɨŋöm, Jisas bred magö anɨb gau udöm, God nɨp aij a göm, kalɨp nɨme la. Kabsaƚ u, u rö nöp ga. Kalɨp anɨg göm nɨme lö, nɨbi bɨ gau kale magöŋhalö bred kabsaƚ aigeg rö udun a gɨ gasɨ nɨŋla rö nöp udla. ");
INSERT INTO kpw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Anɨg göl ñɨŋlö ñɨŋlö mudun ga arö gɨla. Jisas bɨ nɨpe gau kalɨp haga, “Nɨbi bɨ nan ñɨŋöm arö gɨpal gau, ud daŋ i gagep,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hageia, bɨ nɨpe gau bred adɨŋ adɨŋ gau ƚɨhu wadɨ yaglö yaglö, wadɨ unbö mɨgan laŋ u ajmaŋ raua. ");
INSERT INTO kpw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nɨbi bɨ gau Jisas nan gagep rö ga anɨbu nɨŋöm hagla, “Hon mɨñi nɨŋbun, bɨ i me, Bɨ God Manö Hagep mɨnöŋ naböŋ iƚ i aunab a gun pör hagabun bɨ me u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pen Jisas nɨŋa, nɨbi bɨ gau, yɨp kiŋ bɨ kub kale mɨdeinam a göm apöm yɨp kƚö göm ud arnaböl, a gɨ nɨŋöm nɨpe kauyaŋ aramöm dum gau nɨpe ke halö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pen dugo magö u, Jisas bɨ nɨpe gau am Ñɨg Waŋö Galili yaŋ amöm, ");
INSERT INTO kpw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jisas auaga rö, sɨbön gö, kale nöp ñɨg magɨb udöm kauyaŋ daun pro Kapaneam arnɨg hadla. ");
INSERT INTO kpw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Areila nɨŋöl gɨ, yɨgön kub udöm, ñɨg u rala. ");
INSERT INTO kpw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pen kale rapɨn ñɨg magɨb ñɨg uɫ pɨrɨk aŋ au kilomida unbö mamɨd aka kagoƚ jɨŋ amöm nɨŋla, Jisas ñɨg adö u rauɨd aueia. Kale nɨŋöm mɨdmagö kub ara nɨŋöm pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pen Jisas haga, “Kale pɨñɨŋ gagmim. Yad nöp auabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Anɨg hagö, kale pɨñɨŋ gagöm, nɨp ud ñɨg magɨb mɨgan u lɨlö nɨŋöl gɨ, ñɨg magɨb u uri nöp ram mɨnöŋ arnɨg gɨla mɨgan u amjak ara. ");
INSERT INTO kpw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ruö nɨbi bɨ Ñɨg Waŋö Galili böŋ lödaŋ hanla gau gasɨ nɨŋöm nɨŋla, rol dugo ñɨg magɨb añɨ ap nöp mɨdeia nɨŋöm Jisas bɨ nɨpe gau nöp ñɨg magɨb anɨbu arla; Jisas nɨpe ke ñɨg magɨb anɨbu araga. ");
INSERT INTO kpw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mɨdlö nɨŋöl gɨ, ñɨg magɨb rɨmnap nɨbi bɨ rɨmnap daun kub Daibirias nɨbö apöm, Bɨ Kub nɨpe God nɨp aij a göm nan ñö ñɨŋla ka u ñɨg goƚ au pɨdöŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pen nɨbi bɨ mɨdeila gau nɨŋla, Jisas abe bɨ nɨpe gau abe mɨdageila; anɨbu Jisas nɨp uƚhai nɨŋun a göm, kale ñɨg magɨb anɨb gau amöm Kapaneam arla. ");
INSERT INTO kpw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ñɨg Waŋö Galili am am böŋ lödaŋ amjaköm, Jisas nɨp nɨŋöm hagla, “Manö hag ñeb bɨ. Ne magö mai i auban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hageila haga, “Kalöp manö nɨŋö hagabin, bred ñɨnö ñɨŋbe mudun ga rö, yɨp uƚhai nɨŋ ajabim; pen nan gagep rö gɨpin gau manö iƚ u nɨŋmim yɨp uɫhai nɨŋ ajagabim. ");
INSERT INTO kpw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nan magö hij gɨnɨg gab u udun, a gɨmim wög kƚö gagmim; God nɨpe Bɨ Ñɨ nɨpe nɨŋebir hagö aua rö, nan magö pör mɨdep nɨpe ñɨnab u udun, a gɨmim, wög kƚö gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Anɨg hageia hagla, “Hon wög nɨhön gɨno, God nɨp aij gɨnab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hageila, Jisas haga, “God nɨpe Bɨ yuö aua u, Bɨ anɨbu nɨp nɨŋ udeinabim u, God nɨp aij gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Anɨg hageia hagla, “Hon nan gagep rö ap nɨŋeinabun u, hagnabun, ‘God nöp nöp yuöp,’ a gun, nöp nɨŋ udnabun. Anɨb u, hanɨp nan gagep nɨhön rö gɨnabön? ");
INSERT INTO kpw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hadame nöp apɨs bac bɨ ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau mɨdöm, nan mana a gɨmɨdal u ñɨŋmɨdal. God Manö kalɨ kƚiñ rɨköm hagla, ‘Nɨpe bred kumi kabö adö laŋ au nɨbö rɨmnap kalɨp ñö ñɨŋmɨdal,’ a gɨla,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Anɨg hagla u pen Jisas kalɨp pen haga, “Kalöp manö nɨŋö yabɨƚ hagabin, Mosɨs hadame gau bred kalɨp ñö ñɨŋla bred anɨbu, bred kumi kabö adö laŋ au nɨbö wasö. Bred kumi kabö adö laŋ au nɨbö bred nɨŋö anɨbu, Bapi yad kalöp ñab. ");
INSERT INTO kpw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God bred nɨpe u, God hag yuö, kumi kabö adö laŋ au nɨbö mɨnöŋ naböŋ iƚ i apöm, nɨbi bɨ gau kalɨp kamɨŋ mɨdep magö u ñab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jisas anɨg hageia hagla, “Bɨ Kub. Uri bred anɨbu hanɨp pör nöp ñöl gɨ nöp mɨdaimön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hageila, Jisas haga, “Yad nöp me bred kamɨŋ mɨdep bred anɨbu. Nɨbi bɨ yɨp aunaböl gau, kalɨp kauyaŋ kɨyö lagnab. Nɨbi bɨ yɨp nɨŋ udnaböl gau, kalɨp kauyaŋ ñɨg nan gagnab. ");
INSERT INTO kpw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pen kalöp mɨdö nöp hagajɨn, yɨp amgö nɨŋbim u pen yɨp nɨŋ udagpim. ");
INSERT INTO kpw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bapi yɨp hagöp nɨbi bɨ gau kale magöŋhalö yad aunaböl. Nɨbi bɨ yad aunaböl gau, hag yuagnabin, wasö yabɨƚ. ");
INSERT INTO kpw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pen nɨhön: yad kumi kabö adö laŋ au nɨbö aubin u, gasɨ yad nɨŋbin adö u gɨnam a gem auagpin; Bapi yɨp yuöp u, gasɨ nɨpe nɨŋöm hagöp rö gɨnam a gem aubin. ");
INSERT INTO kpw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bapi nɨbi bɨ yɨp hagöp gau kalɨp nɨŋ mɨdnö, ap ur gagnɨm; manö kub hagep ñɨn u, yad gɨnö, kale magöŋhalö uraköl. Anɨg gɨnab u, Bapi yɨp yua u, nɨp aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bapi yad nɨp aij gɨnab u, nɨbi bɨ an an yɨp nɨŋöm nɨŋ udnaböl gau, kale magöŋhalö pör pör nöp kamɨŋ mɨdeinaböl. Pen manö kub hagep ñɨn u, yad ke gɨnö kale magöŋhalö uraknaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pen Jisas, “Yad me, bred kumi kabö adö laŋ au nɨbö aubin u,” a ga u me, Juda nɨbi bɨ gau manö aƚi gu gu geila. ");
INSERT INTO kpw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Juda nɨbi bɨ gau aƚi gu gu göm hagla, “Bɨ i, nɨme nap nɨpe u hon ke nɨŋbun. Nɨpe Josep ñɨ nɨpe Jisas nöp. Anɨb u, nɨpe aigöl gɨ hagöp, ‘Yad kumi kabö adö laŋ au nɨbö aubin,’ a göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Anɨg hageila, Jisas pen haga, “Aƚi gu gu gagmim. ");
INSERT INTO kpw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɨbi bɨ ap nɨpe ke yɨp nɨŋ udagnab. God nɨp gasɨ aij ñö nöp me, yɨp auö, manö kub hagep ñɨn hain u yad gɨnö nɨpe kauyaŋ uraknab. ");
INSERT INTO kpw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bɨ God manö hagep bɨ gau kale God Manö kalɨ kƚiñ rɨköm hagla, ‘God nɨpe nɨbi bɨ anɨb gau magöŋhalö kalɨp hag ñɨnab,’ a gɨla. Nɨbi bɨ Bap kalɨp manö hag ñö nɨŋ udnaböl gau, kale magöŋhalö yɨp aunaböl. ");
INSERT INTO kpw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nɨbi bɨ rɨmnap kale God nɨp amgö nɨŋagpal; yad Bɨ nɨpe yuö aunö u nöp Bapi nɨp amgö nɨŋbin. ");
INSERT INTO kpw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Pen yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ yɨp nɨŋ udnaböl gau, pör mɨdep magö anɨbu hadö udöm, pör pör nöp mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bred ñɨŋöm kamɨŋ mɨdeinaböl u, yad me bred anɨbu. ");
INSERT INTO kpw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nahai iƚaŋ bɨ hadame gau ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ gau mɨdöm, nan mana u ñɨŋla u pen mɨd damöm umla. ");
INSERT INTO kpw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pen bred Bap hag yuö kumi kabö adö laŋ nɨbö auöp bred anɨbu, nɨbi bɨ ñɨŋöm, kamɨŋ pör pör nöp mɨdöm umagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Yad ke bred kamɨŋ kumi kabö adö laŋ au nɨbö aubin u. Nɨbi bɨ an an bred anɨbi ñɨŋ aŋ yaŋ lɨnaböl u, pör nöp pör nöp kamɨŋ mɨdeinaböl. Bred hagabin anɨbi hañ romaŋ yad u me. Nɨbi bɨ ram mɨnöŋ iƚ i pör nöp pör nöp kamɨŋ mɨdaiöl, a gem, hañ romaŋ yad u ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas anɨg hageia, Juda nɨbi bɨ anɨb gau kale ke nöp manö pen pen hagöm, rɨmnap hagla, “Bɨ i aigöl göm, hanɨp hañ romaŋ nɨpe u ñö ñɨŋnabun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hageila, Jisas kalɨp haga, “Yad kalöp nɨŋö yabɨƚ hagabin, kale Bɨ Ñɨ nɨpe hañ romaŋ nɨpe, hagape nɨpe ñɨŋagnabim u, kamɨŋ mɨdep magö u kalöp aŋ daŋ mɨdagnab. ");
INSERT INTO kpw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nɨbi bɨ an hañ romaŋ yad, hagape yad ñɨŋnab u, nɨpe kamɨŋ pör mɨdep magö u hadö udöp nɨŋöm manö kub hagep ñɨn u yad gɨnö nɨpe kauyaŋ uraknab. ");
INSERT INTO kpw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Pen nɨhön: hañ romaŋ yad u nan ñɨŋeb yabɨƚ; hagape yad u ñɨg ñɨŋeb yabɨƚ. ");
INSERT INTO kpw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nɨbi bɨ an an hañ romaŋ hagape yad ñɨŋnaböl gau, yad aŋ daŋ mɨdeinaböl; yad kalɨp aŋ daŋ mɨdeinabin. ");
INSERT INTO kpw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bapi pör pör nöp kamɨŋ mɨdöp u, nɨpe yɨp yua u, yɨp gö kamɨŋ mɨdpin u me, nɨbi bɨ yɨp ud aŋ kalɨp daŋ lɨnaböl gau, kalɨp u rö nöp gö, kamɨŋ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Manö adö anɨbu me, bred kumi kabö adö laŋ au nɨbö auöp, a gɨpin. Bred anɨbu, apɨs bac bɨ nan mana a gɨpal u ñɨŋöm mɨd damöm umla rö wasö; nɨbi bɨ bred yad hagajɨn u ñɨŋ aŋ yaŋ lɨnaböl u, kamɨŋ pör nöp pör nöp mɨdeinaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas Juda magum gep ram Kapaneam au mɨdöm, manö anɨbu hagö, ");
INSERT INTO kpw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","nɨbi bɨ nɨpe gau iru nöp nɨŋöm hagla, “Jisas manö hagab anɨbu manö kƚö yabɨƚ. Manö nɨpe nɨŋ udun rö lagöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kale aƚi gu gu göm hageila, Jisas ke nɨŋöm haga, “Manö hagpin anɨbu nɨŋmim gasɨ iru nɨŋmim arö gun a gɨpim ar? ");
INSERT INTO kpw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pen Bɨ Ñɨ nɨpe kumi kabö adö laŋ au mɨdöm aua u, nɨpe ka anɨb adö au laŋ kauyaŋ ado gɨ areinab u, kale gasɨ nɨhön nɨŋnabim? ");
INSERT INTO kpw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Ana kamɨŋ mɨdep magö u ñö, nɨbi bɨ kamɨŋ lɨnaböl; nɨbi bɨ kƚö kale ke kamɨŋ lagnaböl, wasö yabɨƚ. Yad manö kalöp hagpin u, manö anɨbu gö, God Ana kalöp apöm, kamɨŋ mɨdep magö u kalöp ñɨnab nɨŋöm kale kamɨŋ lɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pen Jisas nɨpe nöd nöp, nɨbi bɨ an nɨp nɨŋ udagnab, an nɨp mumug nɨŋnab u nɨŋa u me, nɨpe haga, “Kale rɨmnap yɨp nɨŋ udagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pen manö rɨmnap halö hagöm haga, “Adö anɨbu nöp kalöp hagpin, nɨbi bɨ ap gasɨ nɨpe ke nöp nɨŋöm yɨp nɨŋ udagnab; Bapi nöp geinab u me, nɨbi bɨ ap yɨp apöm yɨp nɨŋ udnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas manö anɨbu hag juö nɨŋöl gɨ, nɨbi bɨ apöm manö nɨp nɨŋmɨdal gau, iru nöp nɨp arö göm, ke ke arla. ");
INSERT INTO kpw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Anɨg göm arlö nɨŋöl gɨ, Jisas bɨ nɨpe unbö mɨgan laŋ u kalɨp hag nɨŋöm haga, “Kale u rö nöp yɨp arɨk arnabim aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hageia, Saimon Pida haga, “Bɨ Kub. An nɨp arun? Manö ne hagabön u nɨŋun me, pör pör nöp mɨdeinabun. ");
INSERT INTO kpw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hon nöp nɨŋ udpun rö, hon nɨŋbun, God nɨpe Bɨ Uɫ hanɨp yuöp u, ne Bɨ anɨbu me u, a gɨ nɨŋbun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","71","Saimon Pida anɨg hageia, Jisas pen Saimon Iskariod ñɨ nɨpe Judas u, hainö nɨp mumug nɨŋnab u nɨŋöm, kalɨp haga, “Yad kalöp bɨ unbö mɨgan laŋ udpin u pen bɨ kale añɨ ap kɨjaki bɨ nɨpe,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hainö pen Juda bɨ kub gau Jisas nɨp alnɨg geila nɨŋöm Jisas ram mɨnöŋ Judia gau ajagmɨdöp; ram mɨnöŋ Galili gau nöp ajmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pen Juda ñɨn kub kale, ram bada pro göm ñɨn rɨmnap hanbal ñɨn u söl söl ga nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas nɨmam hain gau mɨdeia u apöm nɨp hagla, “Ne mɨgan anɨbi arö gɨmön ram mɨnöŋ Judia ammön, nɨbi bɨ manö nöp nɨŋbal gau kalɨp nan gagep rö gɨpan u gö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bɨ kale bɨ kub mɨdnɨg gɨnaböl gau, nan kale gau pi göm gagnaböl; waiö yabɨƚ gɨnaböl. Anɨb u, ne nan ke yabɨƚ gɨpan rö, nɨbi bɨ iru mɨdpal aŋ au nan gagep rɨmnap gö, nɨbi bɨ magöŋhalö nɨŋnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pen Jisas nɨmam nɨpe ke gau nɨp nɨŋ udagla. ");
INSERT INTO kpw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Anɨg hageila, Jisas pen kalɨp haga, “Kale ñɨn mai arun a gɨnabim u arnɨg arnabim; pen ñɨn yad arep u auagöp nɨŋöm yade uri aragnabin. ");
INSERT INTO kpw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nɨbi bɨ mɨnöŋ naböŋ iƚ i gau, kalöp bɨ mulu kal nɨŋöl iƚ ap mɨdagöp. Pen yad nɨbi bɨ mɨnöŋ naböŋ iƚ i gau, nan si nan naij gɨpal u hag waiö lɨnö yɨp mulu kal nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anɨb u, Ram Bada ñɨn kub söl auab rö, kale Jerusalem armim; pen yad ñɨn arep u auagöp rö, yad aip aragnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anɨg hagöm, nɨpe ram mɨnöŋ Galili mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pen Jisas nɨmam bɨ gau Jerusalem arla nɨŋöm Jisas nɨpe agamɨj hain ara. ");
INSERT INTO kpw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda bɨ kub gau, “Jisas mai?” ö göm, nɨbi bɨ iru nöp ap mɨdeila gau kalɨp hag nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pen nɨbi bɨ yɨharɨŋ gau, Jisas manö u kale ke hag nɨŋ hag nɨŋ göm, rɨmnap hagla, “Nɨpe bɨ aij ap,” a gɨla; rɨmnap pen hagla, “Wasö, nɨpe nɨbi bɨ gau kalɨp wai ñöb bɨ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pen nɨbi bɨ yɨharɨŋ gau, Juda bɨ kub anɨb gau kalɨp pɨñɨŋ gɨla rö, kale manö rɨmnap waiö hagagla. ");
INSERT INTO kpw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ram Bada ñɨn kub kale anɨbu ñɨn rɨmnap padia. Yöp ñɨn bad ap nöp mɨdö, Jisas apjaköm, God sabe gep ram u amöm, nɨbi bɨ gau kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jisas manö hag ñɨ mɨdö nɨŋöl gɨ, Juda bɨ kub gau aiö göm hagla, “Bɨ i skul hagaga u pen aigöl göm manö gau magöŋhalö nɨŋöb?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Anɨg hageila, Jisas haga, “Manö yad hag ñabin u, gasɨ yad ke nɨŋem hag ñagabin; Bɨ yɨp hag yuö aunö u nöp yɨp gasɨ ñö hag ñabin. ");
INSERT INTO kpw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nɨbi bɨ an, God hagöp rö gɨnam, a göm, gɨ ud arnab u, God nɨpe manö yɨp ñab hagabin aka manö yad ke hagabin u, nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kale nɨŋbim, nɨbi bɨ an manö nɨpe ke hagnab u, hib yad ap rannɨm, a göm, manö gau nɨbö gau nɨbö udöm hagnab. Pen bɨ an nɨpe bɨ nɨpe hag yua hib nɨpe nöp ap rannɨm, a gɨ gasɨ nɨŋnab u, bɨ anɨbu bɨ kabö göl manö nɨŋö nöp hagab; nɨpe manö piral rɨmnap hagagnab. ");
INSERT INTO kpw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosɨs, God haga haga rö kalɨp lo manö hag ña u pen lo adö anɨb gau kale bɨ ap gagpim. Pen yad manö ap mɨdöp wasö, yɨp yɨharɨŋ alnɨg gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jisas anɨg hagö, nɨbi bɨ ap mɨdeila gau hagla, “Nöp an alnɨg gab? Nöp kɨjaki abaŋ lajɨp hagabön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hageila, Jisas haga, “Yad nan gagep añɨ ap gɨnö, kale magöŋhalö pa gɨƚɨ gɨpe. ");
INSERT INTO kpw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Kale Mosɨs God lo manö haga rö, ñɨ kale gau yag daumim, ñɨn unbö mudun jɨŋ u mɨdmim, ruö raleb ñɨn u waŋ hañ rɨkpim. Gɨpim anɨbu, Mosɨs nɨpe wasö, nahai iƚaŋ bɨ nöd iƚ göm gɨmɨdal nagɨ adö u me anɨg gɨpim. Pen hañ rɨkep ñɨn raleb anɨbu, ñɨn rɨmnap God nɨp sabe gep ñɨn u nöp lɨnab, pen mɨñi God nɨp sabe gep ñɨn u, a gɨmim, arö gagpim; haƚöwaƚö hañ rɨkpim. Gɨpim anɨbu rö, yad God nɨp sabe gep ñɨn u bɨ ap nɨp gɨnö, hañ romaŋ magöŋhalö kamɨŋ löp u, kale ai gɨnɨg yɨp nɨŋbe mulu lugöp? ");
INSERT INTO kpw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Anɨb u, hainö manö adö adö nöp nɨŋmim hagagmim; kabö rö gɨnab adö u nɨŋ aij gɨmim hagmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem nɨbi bɨ rɨmnap hagla, “Juda bɨ kub gau bɨ alnɨg gaböl bɨ me i aka? ");
INSERT INTO kpw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pen nɨŋim! Nɨpe nɨbi bɨ aŋ kub i manö hagö nɨŋöl gɨ, pen manö ap hagagaböl. Anɨb u, kale ke nɨŋbal nɨpe Krais u yɨjɨg göl rö löp! ");
INSERT INTO kpw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pen nɨpe Krais u auböp u, hon nɨpe ram mɨnöŋ gai nɨbö auöp u nɨŋagbnop; pen bɨ i nɨpe ram mɨnöŋ gai nɨbö auöp u hon magöŋhalö nɨŋbun. Anɨb u, nɨpe Krais u wasö,” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Pen Jisas nɨpe God sabe gep ram raul yaŋ manö hag ñöl gɨ nöp mɨdöm, meg magö dap ranöm haga, “Kale gasɨ nɨŋbim, kale yɨp nɨŋ aij yabɨƚ gɨmim, gai nɨbö aunö u nɨŋbim. Pen wasö. Gasɨ yad ke nöp auagnö. Bɨ yɨp hag yuö aunö u, nɨpe Bɨ kabö göl, Bɨ manö nɨŋö nöp hagab. Yad nɨpe aip mɨdem, yɨp hag yuö aunö rö, nɨp nɨŋbin; pen kale nɨp nɨŋagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Anɨg hagö, nɨp ud sɨsɨ lun a göm nɨŋla u pen ñɨn nɨpe auaga rö, bɨ ap nɨp ud sɨsɨ laga. ");
INSERT INTO kpw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pen nɨbi bɨ anɨb gau, nɨbi bɨ iru nöp Jisas nan gagep gau ga nɨŋöm hagla, “Krais u hain aunab a gɨpal u, pen nan gagep iru yabɨƚ göm, bɨ anɨbi gab rö gɨnɨm rö lagnab,” a gɨla. Gasɨ anɨbu nɨŋöm kale hagla, “Jisas nɨpe Krais u nöp,” a göm, nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pen nɨbi bɨ gau Krais manö anɨbu agamɨj hageila nɨŋöm, Perisi bɨ kub gau abe, bɨ God nɨp nan sabe gep bɨ kub gau abe, Jisas nɨp am ud sɨsɨ lɨmim daumim, a göm, God sabe gep ram abad mɨdmɨdal polisman rɨmnap hag yula. ");
INSERT INTO kpw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas pen haga, “Yad rapɨn magö ap mɨdem, Bɨ yɨp yuö aunö u ado gɨ arnabin. ");
INSERT INTO kpw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yɨp gai aröp a gɨmim uƚhainabim u pen nɨŋagnabim. Yad arnabin adö u, kale hain gɨmim rö lagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Anɨg hageia, Juda bɨ kub gau kale ke nöp hagla, “Nɨpe gai arnab, nɨp nɨŋagnabun? Nɨpe am Juda nɨbi bɨ ju am Grik nɨbi bɨ aip mɨdpal gau amöm, nɨbi bɨ anɨb gau kalɨp manö hag ñöl gɨ mɨdeinab aka nɨhön? ");
INSERT INTO kpw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pen nɨpe ai gɨnɨg hagöp, ‘Yɨp gai aröp a gɨmim uƚhainabim u pen nɨŋagnabim. Yad arnabin adö u, kale hain gɨmim rö lagnab,’ a göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juda Ram Bada ñɨn kub kale anɨbu, ñɨn hain, ñɨn kub yabɨƚ u, Jisas uraköm, meg magö dap ranöm haga, “Nɨbi bɨ an rugu mɨƚep gɨnɨm u, yad apöm ñɨg ñɨŋöl. ");
INSERT INTO kpw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nɨbi bɨ yɨp nɨŋ udnaböl gau, God Manö hagöp rö, ñɨg kamɨŋ mɨdep u aŋ kalɨp daŋ nɨbö ilam juöm aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ñɨn anɨbu Jisas umöm uraköm Nap nɨp araga adö u me, Jisas nɨpe Ana u nɨbi bɨ gau kalɨp ñaga. Pen ñɨg ilam juöm aunab manö haga anɨbu iƚ anɨgöl mɨdöp: nɨbi bɨ Jisas nɨp nɨŋ udnaböl gau, Jisas nɨpe Ana u kalɨp ñɨnab, a göm haga. ");
INSERT INTO kpw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas anɨg hagö, nɨbi bɨ iru nöp mɨdeila anɨb gau, rɨmnap manö haga anɨbu nɨŋöm hagla, “Bɨ i, nɨpe bɨ God Manö hagep aunab a gun abad mɨdmɨdun u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Rɨmnap hagla, “Wasö, nɨpe Krais u!” a gɨla. Anɨg hageila, rɨmnap pen hagla, “Wasö, Jisas nɨpe Galili nɨbö; Krais u nɨpe Galili nɨbö auagnab! ");
INSERT INTO kpw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God Manö u hagöp rö, Krais u, Depid rɨkö rɨklö rɨk dam dapɨl göm, Krais u Depid daun nɨpe Bedlehem au yag daunaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jisas manö anɨbu hageia nɨŋöm, nɨbi bɨ iru mɨdeila anɨb gau asɨk ke ke lɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Rɨmnap nɨp ud sɨsɨ lun dam manö kub hagnɨg ud arun a gɨla u pen bɨ añɨ ap nɨp udaga. ");
INSERT INTO kpw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pen God sabe gep ram polisman gau ado gɨ arlö nɨŋöl gɨ, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ Perisi gau abe kalɨp hagla, “Bɨ anɨbu nɨp nɨhön gɨnɨg dauagpim?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hageila, God sabe gep ram polisman anɨb gau hagla, “Nɨbi bɨ rɨmnap gau bɨ anɨbu manö aij yabɨƚ hagöp rö hagagpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Anɨg hageila, pen bɨ Perisi gau pen hagla, “Bɨ pir alöp anɨbu, nɨbi bɨ rɨmnap nɨpe nɨŋö hagöp a göm nɨŋbal rö, kale u rö nöp nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hon bɨ kub bɨ ap aka bɨ Perisi bɨ ap Jisas nɨp nɨŋ udagpun. ");
INSERT INTO kpw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nɨbi bɨ gai i kale lo manö u nɨŋagpal rö, God kalɨp mulu kal nɨŋöm gɨ naij yabɨƚ gɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pen bɨ kale Nikodimas, bɨ au nöd sɨbön yaŋ amöm, Jisas nɨp manö rɨmnap hag nɨŋa bɨ anɨbu me, kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hon Juda lo adö u, bɨ ap nɨp yɨharɨŋ pen ilön ñun gɨ naij gagnabun; manö kub hagun manö iƚ ap nɨŋun nöp me, anɨg gɨnabun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Anɨg hageia hagla, “Ne u rö nöp Galili nɨbö rö? God Manö u amgö lɨ nɨŋ dammön nɨŋnabön, bɨ God manö hagep ap Galili nɨbö auagnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Anɨg hageila kale ke ram kale arla. ");
INSERT INTO kpw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pen Jisas Olip Dum ara. ");
INSERT INTO kpw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ruö ram ru dam la nɨŋöm, kauyaŋ ado gɨ God sabe gep ram u auö, nɨbi bɨ iru nöp apöm nɨp bɨnɨg gɨgabö geila nɨŋöm nɨpe asɨk mɨdöm, kalɨp manö hag ñɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jisas anɨg göl manö hag ñɨ mɨdö nɨŋöl gɨ, bɨ lo manö hag ñeb bɨ gau rɨmnap abe, bɨ Perisi rɨmnap abe, kale nɨbi ap am bɨ ap aip udajɨp, nɨbi u nɨp dap nɨbi bɨ mɨdeila amgö ilö adö au urak ñöm, ");
INSERT INTO kpw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jisas nɨp hagla, “Manö hag ñeb bɨ. Nɨbi i bɨ halö u pen bɨ ap aip udajɨl nɨŋun daubun me i. ");
INSERT INTO kpw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosɨs lo hanɨp ña u haga, ‘Nɨbi anɨb gau rö, kabö ju pak lɨlö umöl,’ a ga. Pen ne nɨhön hagnabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kale manö piral hagla anɨbu, anɨg hagno, Jisas nɨhön hagö, nɨp manö kub hagun a göm hagla. Pen Jisas nɨpe ubör yɨhöŋ göm, haƚpɨƚ adö u ñɨmagö manö magö rɨmnap kalɨ kƚiñ rɨköl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pen kale Jisas nɨp manö anɨbu rö hag nɨŋöl gɨ mɨdeila, nɨpe jöl yɨjɨg göm kalɨp haga, “Bɨ nan si nan naij gagöp ap mɨdainɨm u, kabö ud nɨbi anɨbi nöd paknɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Anɨg hagöm kauyaŋ gɨyaŋ göm, mɨnöŋ yaŋ manö magö rɨmnap kalɨ kƚiñ rɨk mɨdö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","bɨ Jisas nɨp manö kub hagun a gɨla anɨb gau, Jisas manö haga anɨbu nɨŋöm, bɨ majö majö arɨk arla nɨŋöm bɨ gau magöŋhalö añɨ añɨ arö göm ke ke am hakla; Jisas aip nɨbi u aip nöp mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nɨpe jöl yɨjɨg göm, nɨbi anɨbu nɨp haga, “Bɨ gau mai? Bɨ nöp manö kub hagnɨm ap mɨdagöp ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hageia, nɨbi u haga, “Bɨ Kub. Bɨ yɨp manö kub hagnɨm ap mɨdagöp,” a ga. Hageia, Jisas haga, “Yad u rö nöp nöp manö kub hagagnabin. Pen nan si nan naij gɨmɨdan u hainö gagmön; uri ne aru,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas manö ap nɨbi bɨ gau kalɨp kauyaŋ hagöm haga, “Nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau, yad mailö kale mɨdpin. Nɨbi bɨ an yɨp hain göm ajeinab u, sɨbön aŋ gau rö ajageinab; pör mɨdep mailö aij u udöm ajeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jisas anɨg hageia, bɨ Perisi gau nɨp pen hagla, “Manö ne ke hag ñɨban u, hon nɨŋbun manö anɨbu udun rö lagöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Anɨg hageila, Jisas haga, “Manö anɨbu yad ke hagabin u pen manö nɨŋö hagabin. Pen nɨhön: yad aubin gau nɨŋem, arnabin gau abe nɨŋem gɨpin. Pen kale, yad aubin gau nɨŋagmim, arnabin gau abe nɨŋagmim gɨpim. ");
INSERT INTO kpw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kale manö ud asɨk göl gɨ, ‘Adö u gɨ aij gɨpim; adö u gɨ naij gɨpim,’ a gabim u, nɨbi bɨ mɨnöŋ naböŋ iƚ i gasɨ nɨŋöm hagpal rö nöp hagabim. Pen yad bɨ ap nɨp manö kub hagagabin. ");
INSERT INTO kpw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bapi yɨp yuö aunö u, nɨpe yad aip mɨdpul rö, yad manö ud asɨk gɨnɨg, nɨŋö nöp hagem manö ud asɨk gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo manö kale adö u hagpim, ‘Nɨbi bɨ mɨhöp manö adö añɨ nöp hagnabil u me, nɨbi bɨ nɨŋöm hagnaböl, u nɨŋö hagpil, a gɨnaböl,’ a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lo kale hagöp anɨbu rö, yad aigale bɨ rö mɨdpin u, yad ke manö hadö hagpin; pen Bapi yɨp yuöp u abe yad aigale bɨ rö mɨdpin manö u hadö hagöp. Manö hol apɨl manö añɨ nöp hagpul u me, nɨŋö hagpil a gɨbep,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Anɨg hageia, nɨp hagla, “Nap ne mai?” ö gɨla. Hageila, Jisas pen haga, “Kale yɨp nɨŋagpim rö, Bapi yad nɨp u rö nöp nɨŋagpim. Yɨp nɨŋbep, Bapi yad u rö nöp nɨŋbep,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas God sabe gep ram raul, mani kale God nɨp ñeb dap yubal mɨgan u, manö anɨbu hag ñɨ mɨdeia pen ñɨn nɨpe auaga rö, bɨ ap nɨp ud sɨsɨ laga. ");
INSERT INTO kpw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas kalɨp kauyaŋ haga, “Yad arɨk areinabin; yɨp uƚhai nɨŋnabim u pen kale nan si nan naij göl gɨ nöp mɨdmim umnabim rö, yad arnabin gau kale aragnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Anɨg hageia, Juda bɨ kub gau hagla, “Nɨpe hagöp, ‘Yad arnabin gau kale aragnabim,’ a göp u, nɨhön gɨnɨg anɨg hagöp? Nɨpe ke al pak lɨnɨg göm anɨg hagöp aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anɨg hagla u pen Jisas kalɨp haga, “Kale yaŋ nɨbö; yad laŋ nɨbö. Kale mɨnöŋ naböŋ iƚ i nɨbö; yad mɨnöŋ naböŋ iƚ i nɨbö wasö. ");
INSERT INTO kpw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Anɨb u nɨŋem me hagpin, ‘Kale nan si nan naij göl gɨ nöp mɨdmim umnabim,’ a gɨpin. Pen yɨp, Yad Mɨdpin Rö Mɨdpin, nɨŋ udageinabim u, nan si nan naij gac halö mɨdpim rö mɨdmim, umnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Anɨg hageia, nɨp hag nɨŋöm hagla, “Ne an?” ö gɨla. Hageila, Jisas haga, “Yad kalöp pör nöp hag ñabin rö nöp mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kalöp manö kub hag gɨnam adö u, manö iru nöp mɨdöp. Bɨ yɨp hag yuö aunö u, magöŋhalö nɨŋ aij göp rö, yɨp gasɨ ñö nɨŋöl gɨ, yad pen nɨbi bɨ gau kalɨp hag ñabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas nɨpe Nap manö hag ña anɨbu nɨŋagla rö, kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Bɨ Ñɨ nɨpe nɨp ud gɨlaŋ lɨnabim ñɨn u, gɨnab gɨnab rö nɨŋmim ñɨn añɨbu nɨŋnabim, Yad Mɨdpin Rö Mɨdpin me. Yad nan ap ke nöp nɨŋem gagpin; Bap manö yɨp hagöp rö nöp hag ñabin u, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bɨ yɨp yuö aunö u, yad aip mɨdöp. Nɨp aij göp adö u nöp pör pör gɨpin rö, yɨp arö gagöp; yad aip nöp mɨdöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas manö anɨbu hagö nɨŋöl gɨ, nɨbi bɨ iru nöp nɨp Krais u a göm, nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pen Jisas nɨpe Juda nɨbi bɨ nɨp Krais u a göm nɨŋla anɨb gau kalɨp haga, “Kale manö yad böŋ nöp nɨŋ udmim, hagpin rö nöp geinabim u me, nɨŋö nöp nɨbi bɨ yad mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Anɨg geinabim u, God nɨpe aigale Bɨ rö mɨdöp u nɨŋmim, nagɨ wög rö gɨpim u arö gɨmim, mɨd aij gɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Anɨg hageia hagla, “Manö hagpan anɨbu nɨhön? Hon bac Ebraham ñɨ pai nɨpe mɨdpun u, hon nɨbi bɨ rɨmnap kalɨp nagɨ wög rö gagpun. Anɨb u, hanɨp nɨhön gɨnɨg, ‘Nagɨ wög rö gɨpim u arö gɨmim, mɨd aij gɨnabim,’ a gɨpan?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hageila, Jisas haga, “Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ nan si nan naij gɨpal gau, nan si nan naij gep magö u nöp nagɨ wög gep nɨbi bɨ rö mɨdpal. ");
INSERT INTO kpw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nagɨ wög gep bɨ ap, nap nɨpe ram u pör mɨdagnab; hainö bɨ ke nɨbö mani yuöm nɨp rauö, nap nöd nɨbö ram nɨpe u arö göm, ram ke aramöm nap hain nɨbö u nɨp nagɨ wög gɨnab. Pen ñɨ ap nap ram au kuö nɨpe pör pör nöp mɨdnab. ");
INSERT INTO kpw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","God Ñɨ nɨpe kalöp nɨbi bɨ rauöm nagɨ mɨdpim u hubɨk yueinab u, kale nagɨ wög gɨmɨdim u böŋ nöp arö gɨmim, mɨd aij yabɨƚ gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kalöp Ebraham rɨkö rɨklö rɨk dam dapɨl göm auö mɨdpim u nɨŋbin u pen manö hagpin u udagmim, yɨp al pak lɨnɨg gabim. ");
INSERT INTO kpw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yad Bapi aip mɨdem nɨŋbin rö kalöp hag ñabin; pen kale, nap kale u manö hagöp adö u nöp gabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hageia hagla, “Bapi hon me Ebraham,” a gɨla. Hageila, Jisas haga, “Kale Ebraham ñɨ pai nɨpe mɨdaibep rö, nɨpe gɨmɨdöp rö gɨbep. ");
INSERT INTO kpw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yad God manö hagöp rö nɨŋem, manö nɨŋö yabɨƚ u kalöp hag ñɨbin u pen yɨp alnɨg gabim. Pen kale gɨnɨg gabim anɨbu rö, Ebraham nɨpe gaga. ");
INSERT INTO kpw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Anɨb u, nap kale ke u göp rö, kale ke anɨb unbö rö nöp gabim,” a ga. Anɨg hageia hagla, “Hanɨp bi si udöm rɨkagpal; God añɨ me Bapi hon yabɨƚ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Anɨg hageila, Jisas pen haga, “‘God añɨ me Bapi hon yabɨƚ,’ a gɨpim u pen God nɨpe Bapi kale mɨdböp, yad God nɨbö apem, uri aui mɨdpin u nɨŋmim, yɨp mɨdmagö lɨbep. Yad gau mɨdem, gasɨ yad ke nɨŋem auagnö; God aip mɨdul, yɨp nɨŋebir hag yua, aui aunö. ");
INSERT INTO kpw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Anɨb u, manö yad u nɨhön gɨnɨg nɨŋ aij gagpimŋ Gɨpim anɨbu, hon nɨŋagun a gɨmim gɨpim. ");
INSERT INTO kpw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kale nap kale kɨjaki ñɨ pai nɨpe mɨdpim u me, nɨp aij göp adö u nöp gun a gɨmim nɨŋbim. Nɨpe nöd iƚ göm, nɨbi bɨ gau kalɨp al pak lɨmɨdöp rö, nagɨ adö nɨpe anɨbu anɨg göl nöp mɨdöp. Gasɨ aij rɨmnap, gasɨ nɨŋö rɨmnap nɨŋagöp yabɨƚ; nɨpe manö nɨŋö rɨmnap nɨŋagöp. Manö piral hagab u, manö yöl nɨpe me u. Nɨpe pör nöp manö pir alab; pir alep iƚ u kɨjaki me u. ");
INSERT INTO kpw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pen yad kalöp manö nɨŋö nöp hagabin u me, kale nɨŋmim udagpim. ");
INSERT INTO kpw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pen yad gɨpin u nɨŋmim, adö u nan si nan naij gɨpan, a gɨmim hagmim rö lagöp. Anɨb u, yad manö nɨŋö nöp hagpin u nɨŋmim, kale nɨhön gɨnɨg manö yad nɨŋ udagpim? ");
INSERT INTO kpw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nɨbi bɨ God pɨg mɨdpal gau, manö nɨpe u udpal. Pen kale nɨp pɨg mɨdagpim rö, manö nɨpe u udagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda bɨ kub gau Jisas nɨp hagla, “Ne bɨ Sameria nɨbö, nöp kɨjaki abaŋ alöp, a gɨpun u, nɨŋö hagpun aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hageila, Jisas haga, “Yɨp kɨjaki abaŋ alagöp. Yad Bapi hib nɨpe u hagnö adö arab pen kale hib yad u hagpe au gɨyaŋ ap lugab. ");
INSERT INTO kpw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hib yad u ke hagnö adö arnɨm a gɨ gasɨ u nɨŋagpin; pen God nɨpe nɨbi bɨ nɨhön nɨhön gajal nɨŋ aij göp u, nɨbi bɨ hib yad haglö adö araŋ a gɨ gasɨ u nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kalöp nɨŋö hagabin, nɨbi bɨ an manö yad u nɨŋöm, hagpin rö gɨnab u, nɨpe umagnab; nɨpe pör nöp pör nöp kamɨŋ mɨdeinab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas anɨg hageia, kale hagla, “Ne manö hagpan anɨbu nɨŋun nɨŋbun, nöp kɨjaki abaŋ alöp hagabön. Ebraham abe, bɨ God manö hagep gau magöŋhalö abe umla, pen ne nɨhön gɨmön hagpan, ‘Nɨbi bɨ an manö yad u nɨŋöm, hagpin rö gɨnab u, umagnab; nɨpe pör nöp pör nöp kamɨŋ mɨdeinab,’ a gɨpan? ");
INSERT INTO kpw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bac hon Ebraham abe, bɨ God manö hagep gau magöŋhalö abe umla rö, bɨ anɨb gau bɨ pro, yad bɨ kub a gɨ gasɨ u nɨŋban aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hageila, Jisas haga, “Hib yad ke hagnö adö arböp, nan yɨharɨŋ rö lɨböp. Pen bɨ hib yad hagö adö arab bɨ anɨbu Bapi yad. Kale bɨ añɨ anɨbu nöp nɨp, God hon, a gɨpim. ");
INSERT INTO kpw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","God hon, a gɨpim u pen nɨp nɨŋagpim; pen yad nɨp nɨŋbin. ‘Nɨp nɨŋagpin,’ a gɨbnep, kale manö piral hagpim rö hagbnep. Anɨb u, yad nɨp nɨŋbin u me, manö hagöp rö gɨpin. ");
INSERT INTO kpw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","God hadame nöp nap Ebraham nɨp hagöm, yad Jisas mɨñi apem mɨdpin ñɨn i nöp hagöm, ‘Ñɨn hain u aunab,’ a ga. Pen nap Ebraham God manö haga u nɨŋöm, manö anɨbu God nɨŋö hagöp, a göm, gasɨ halö mɨdöm ñɨñɨ löl gɨ mɨdeia; ñɨn anɨbu nɨŋöm mɨñ mɨñ ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Anɨg hageia, Juda bɨ gau hagla, “Mɨ ne ñɨn juöl mɨhöp ado gɨ da unbö sɨduŋ laŋ rö mɨdagpan u pen ne nɨhön gɨmön, Ebraham hadame dagol gau ga u nɨŋnö, a gɨpan?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hageila, Jisas kalɨp haga, “Kalöp nɨŋö yabɨƚ hagabin, Ebraham nɨp yag dauagep adö u, Yad Mɨdpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas anɨg hageia, nɨp kabö ju al pak lɨnɨg geila, pen God sabe gep ram raul mɨdeia u hil gɨ löm höŋ amöm ara. ");
INSERT INTO kpw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pen Jisas bɨ nɨpe gau aip amöl gɨ nɨŋla, bɨ yag daula ñɨn u nöp amgö we ga ap mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas bɨ nɨpe gau bɨ anɨbu nɨŋöm Jisas nɨp hagla, “Manö hag ñeb bɨ. Bɨ an nan si nan naij gajɨp, bɨ anɨbi yag daula ñɨn u amgö nɨpe u we ga? Nɨpe ke aka nɨme nap gajɨl göp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hageila, Jisas haga, “Amgö nɨpe we ga u, nɨpe ke aka nɨme nap nan si nan naij gajɨl gagöp. Pen amgö nɨpe we ga u, nɨbi bɨ gau God nɨpe Bɨ kƚö unbö ke a göm nɨŋ aij gɨlaŋ a göm ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mɨñi sɨdö aŋ magö i, Bɨ yɨp yuö aunö u, wög nɨp u gun. Sɨb gɨnɨg gab nɨŋöm hon wög gun rö lagnab. ");
INSERT INTO kpw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yad mɨnöŋ naböŋ iƚ i mɨdpin magö i, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau mailö kale u yad mɨdpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas manö anɨbu hagöm, mɨnöŋ yaŋ kɨñu alöm, gö kɨɫɨp lö, udöm bɨ amgö we ga u nɨp amgö nɨpe au löm, ");
INSERT INTO kpw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","haga, “Siloam waŋö ammön, amgö ne u ñɨg lɨmön,” a ga. Anɨg göm hag yuö, am ñɨg löm, amgö u ñɨl nɨŋöm, ram nɨpe ara. Siloam manö iƚ u “Yuö Ara” a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pen nɨbi bɨ ram yam nɨpe aip jɨm ñöl gau abe, nöd nɨpe nan asɨb gɨmɨdöp nɨŋmɨdal nɨbi bɨ gau abe hagla, “Bɨ i, bɨ au asɨk mɨdöl gɨ, nan asɨb gɨmɨdöp u rö löp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hageila, rɨmnap hagla, “Yau me, bɨ anɨbu nöp,” a gɨla. Rɨmnap pen hagla, “Wasö. Bɨ anɨbu rö löp u pen bɨ i bɨ ke nɨbö,” a gɨla. Anɨg hageila, bɨ anɨbu nɨpe ke haga, “Yad me bɨ anɨbu,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hageia, nɨp hagla, “Amgö nöp u aige göm kamɨŋ löp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hageila haga, “Bɨ Jisas a gɨpal u, mɨnöŋ yaŋ kɨñu alöm, gö kɨɫɨp lö, udöm amgö yad u löm hagöp, ‘Siloam waŋö ammön, amgö ne u ñɨg lɨmön,’ a gö, am amgö yad u ñɨg lem, adɨŋ amgö ñɨl nɨŋbin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hageia hagla, “Bɨ anɨbu mɨñi gai?” ö gɨla. Hageila haga, “Yad nɨŋagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Pen Jisas gö amgö ñɨl nɨŋa bɨ anɨbu, Juda kai God nɨp sabe gep ñɨn kale u anɨg ga u me, nɨbi bɨ rɨmnap bɨ anɨbu nɨp dam bɨ Perisi mɨdeila au aula. ");
INSERT INTO kpw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bɨ Perisi bɨ anɨbu nɨp hagla, “Ne aigöl gɨmön amgö ñɨl nɨŋban?” ö gɨla. Hageila haga, “Jisas mɨnöŋ kɨɫɨp ap udöm, amgö yad u lajɨp, yad am amgö yad u ñɨg lem, uri amgö ñɨl nɨŋbin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Anɨg hageia, bɨ Perisi rɨmnap hagla, “God nɨp sabe gep ñɨn u anɨg ga rö, nɨpe God nɨp sabe gep ñɨn lo u rɨb jua. Anɨb u, hon nɨŋbun, God nɨp yuö auagöp,” a gɨla. Anɨg hageila, bɨ kale rɨmnap pen hagla, “Bɨ nan si nan naij gep ap mɨdaiböp, nɨpe aigöl göm nan gagep anɨbu gɨböp?” ö gɨla. Anɨg hagöm kale ke nöp asɨk ke ke lɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bɨ Perisi gau, bɨ anɨbu nɨp kauyaŋ hag nɨŋöm hagla, “‘Bɨ amgö yad gö amgö ñɨl nɨŋbin,’ a gɨpan u, ne bɨ anɨbu bɨ nɨhön, a gɨ gasɨ nɨŋban?” ö gɨla. Hageila haga, “Yad nɨŋbin nɨpe bɨ God manö hagep bɨ ap,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pen Juda bɨ kub gau, bɨ amgö we ga kamɨŋ la manö anɨbu udagöm, nɨme nap hanɨp auɨl, a gɨlö, ber mɨhau aueilö, ");
INSERT INTO kpw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","hagla, “Ñɨ i ñɨ kale aka?” gɨla. Hageila haglö, “Yau, ñɨ u ñɨ hol,” a gɨlö. Hageilö hagla, “Kale nɨp amgö we halö yag daulö aka?” gɨla. Hageila haglö, “Yau, nɨp amgö we halö yag daulo,” a gɨlö. Anɨg hageilö hagla, “Anɨb u, uri aigöl göm amgö ñɨl nɨŋab?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Hageila, kale ber pen hadö nɨŋlö, Juda bɨ kub anɨb gau nöd manö kƚö adö ap hagöm hagla, “Nɨbi bɨ an an Jisas nɨpe Krais u a göm waiö hagnaböl gau, Juda magum gep ram anɨbu kauyaŋ auagnaböl,” a gɨla. Manö hagla anɨbu hadö nɨŋmil me, pɨrɨkmil, haglö, “Ñɨ u, ñɨ hol mɨdöp u, nɨŋbul; ñɨ hol anɨbu amgö we halö yag daulo u abe nɨŋbul; pen mɨñi aigöl göm amgö ñɨl nɨŋab u nɨŋagpul; bɨ an nɨpe gajɨp amgö nɨŋab u abe hol nɨŋagpul. Pen nɨpe ñɨ pro wasö; nɨpe ke hag nɨŋeinabim u, hagnab,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Anɨg hagailö, bɨ kub gau bɨ anɨbu nɨp kauyaŋ wɨñ allö aueia hagla, “Nöp kamɨŋ löp anɨbu, God amgö ilö nɨpe u manö nɨŋö nöp hag. Hon nɨŋbun, bɨ hagajun u, bɨ anɨbu bɨ nan si nan naij gep bɨ ap,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Anɨg hageila, bɨ anɨbu pen haga, “Nɨpe bɨ nan si nan naij gep bɨ ap aka wasö, yad nɨŋagpin. Yad nan añɨ ap nöp nɨŋbin. Nöd amgö we gɨ mɨdainö pen mɨñi amgö ñɨl nɨŋbin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hageia hagla, “Nöp aigege göm gajɨp, amgö nɨŋban?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hageila haga, “Yad kalöp mɨdö nöp hag ñɨbin u pen kale manö yad u udagpim. Nɨhön gɨnɨg manö mɨdö nöp hagajɨn manö u kauyaŋ hag a gɨmim hagabim? Kale ke u rö nöp bɨ nɨpe ap mɨdun a gɨmim hag nɨŋabim aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Anɨg hageia, nɨp mulu kal nɨŋöm, nɨp manö naij hagöm hagla, “Hon Mosɨs bɨ nɨpe me, pen ne bɨ yɨharɨŋ u bɨ nɨpe ap! ");
INSERT INTO kpw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God Mosɨs nɨp manö hag ñö hagmɨdöp u nɨŋbun, pen bɨ i gai nɨbö auöp u nɨŋagpun!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hageila haga, “Ake! Bɨ game! Nɨpe amgö yɨp u gö kamɨŋ löp, pen nɨpe gai nɨbö u kale nɨŋagpim me! ");
INSERT INTO kpw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pen hon nɨŋbun, nan si nan naij göl gɨ, God nɨp sabe gaiöl u, nɨpe manö kale udagnab; nɨbi bɨ God nɨp nɨŋ udöm, manö hagöp rö göl gɨ, nɨp sabe gaiöl u, nɨpe manö kale nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mɨnöŋ naböŋ gɨ la ñɨn u rɨköl, mɨd dap mɨñi mɨdpun ñɨn i, nɨbi bɨ amgö we halö yag daula ap gö kamɨŋ laga. ");
INSERT INTO kpw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bɨ anɨbu God yuö auagböp, nɨpe nan ap gɨnɨm rö lagböp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Anɨg hageia, kale pen hagla, “Name nöp yag daua ñɨn u, bɨ nan si nan naij gep u yag daula pen ne hanɨp manö hag ñɨnɨg gabön ar? Anɨg hagmön, Juda magum gep ram i kauyaŋ auagnabön,” a göm, nɨp ud mamo gɨ dam höŋ yaŋ yula. ");
INSERT INTO kpw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pen bɨ anɨbu nɨp ud höŋ yula, Jisas manö anɨbu nɨŋöm, am nɨp uƚhai nɨŋöm haga, “Ne Bɨ Ñɨ nɨpe nɨp nɨŋ udpan?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hageia haga, “Bɨ Ñɨ nɨpe bɨ an? Bɨ anɨbu me u, a gö, yad nɨp nɨŋ udnam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Anɨg hageia, Jisas haga, “Bɨ anɨbu mɨdö nöp nɨŋban. Me ne aip manö hagabul i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Anɨg hageia, bɨ anɨbu Jisas mɨdeia iƚ au kugom yɨmöm haga, “Bɨ Kub! Yad nöp nɨŋ udabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hageia, Jisas haga, “Yad mɨnöŋ naböŋ iƚ i aubin u, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau kalɨp nɨme lɨnɨg aubin. Nɨbi bɨ amgö we ga gau mailö apöm nɨŋnaböl; pen nɨbi bɨ hon hadö nɨŋ aij gɨpun a göm, mailö arö göm, sɨb yaŋ aramöm nɨŋagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Anɨg hageia, bɨ Perisi söl anɨb au mɨdeila rɨmnap, manö anɨbu nɨŋöm hagla, “Anɨg hagpan u, hon abe amgö we göp, a gɨmön hagabön ar?” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hageila, Jisas haga, “Kale amgö we mɨdaibep rö, nan si nan naij gɨpim u manö kub udagbep; pen nɨŋ aij gɨpun, a gɨpim u me, kale gac halö mɨdmim manö kub udnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas manö ap hod rɨköm haga, “Yad kalöp nɨŋö yabɨƚ hagabin, kaj sipsip mɨdpal waryö raul u arnɨg, ajöŋ iƚ yɨjɨg göl mɨgan u mɨdö nɨŋöl gɨ, yɨharɨŋ ramö au raƚa göm arnaböl gau, kale nan si udep nɨbi bɨ. ");
INSERT INTO kpw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bɨ sipsip mukep u, yɨharɨŋ ramö u raƚa göm aragnab; ajöŋ iƚ yɨjɨg göl mɨgan u nöp amöm, waryö raul mɨgan yaŋ arnab. ");
INSERT INTO kpw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Pen bɨ sipsip mukep u amjakö, bɨ ajöŋ iƚ abad mɨdöp u nɨp nɨŋ aij gɨnab rö, adan u hiɨknab. Pen sipsip gau u rö nöp, bɨ anɨbu maj mɨgan nɨp u nɨŋnaböl rö, sipsip nɨpe ke gau hib ñöl gɨ paŋɨd höŋ arnab. ");
INSERT INTO kpw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sipsip nɨpe paŋɨd höŋ aramöm, nɨpe nöd gö nɨŋöl gɨ, kale maj mɨgan nɨpe u nɨŋnaböl rö, nɨp hain gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pen bɨ ke nɨbö ap ap hagö, nɨp hain gagnaböl; maj mɨgan nɨpe nɨŋagnaböl rö, pɨrɨk arnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas anɨgöl manö hod rɨköm haga pen manö hagab adö u a göm rɨk nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas manö rɨk nɨŋagla rö, nɨpe kauyaŋ haga, “Yad kalöp nɨŋö yabɨƚ hagabin, yad ke sipsip gau ajöŋ arep mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pen, ‘Hon kaj sipsip mukep bɨ,’ a göm, nöd aula bɨ gau, kale magöŋhalö nan si udep bɨ mɨdmɨdal. Sipsip gau manö kale u nɨŋagmɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Pen yad ke sipsip gau ajöŋ arep rö mɨdpin. Nɨbi bɨ yɨp apöm waryö raul mɨgan arnaböl gau, kamɨŋ nöp mɨdeinaböl. Ajöŋ amɨl apɨl göl gɨ, nan uɫaŋ uɫaŋ ñɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bɨ si udep gau, nan si udnɨg, wip alnɨg, gɨ naij gɨnɨg nöp aubal. Pen yad aunö u, kalöp gɨnö, kale kamɨŋ pör mɨdep magö anɨbu udmim, kamɨŋ mɨd aij gep adö u nöp mɨdpe araŋ a gem aunö. ");
INSERT INTO kpw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yad Sipsip Mukep Bɨ Aij. Sipsip Mukep Bɨ Aij u, kaj sipsip gau a göm umnab. ");
INSERT INTO kpw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bɨ au mani udnɨg kaj sipsip abad mɨdeinab u, bɨ kaj sipsip mukep yɨjɨg göl wasö; sipsip gau sipsip nɨpe wasö u me, kain hauƚ gau auaiöl u nɨŋöm pɨñɨŋ gɨ arnab. Anɨb u me, kain hauƚ anɨb gau sipsip gau kalɨp yu gɨ dam ke gau gau yunaböl. ");
INSERT INTO kpw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bɨ anɨbu mani udnɨg kaj sipsip abad mɨdöm, sipsip gau kalɨp gasɨ nɨŋagnab u me, pɨñɨŋ gɨ arnab. ");
INSERT INTO kpw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Yad Sipsip Mukep Bɨ Aij. Bapi hol apɨl pen pen nɨŋ aij gɨpul rö, yad sipsip gau aip pen pen nɨŋ aij gɨpun. Anɨb u, yad kalɨp a gem umnabin. ");
INSERT INTO kpw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipsip waryö raul mɨgan i mɨdpal nöp wasö, sipsip rɨmnap halö mɨdpal. Sipsip anɨb gau u rö nöp udnabin. Kale u rö nöp manö yad u nɨŋnaböl. Sipsip raul mɨgan añɨ ap magum gɨ mɨdöm, bɨ mukep kale añɨ ap nöp mɨdöm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Yad kalɨp nan a gem umem uraknabin rö, Bapi yɨp mɨdmagö löp. ");
INSERT INTO kpw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nɨbi bɨ rɨmnap gasɨ kale nɨŋöm gɨlö umagnabin; yad ke umnam a gem umnabin. Yad ke umnam a gem umnabin; yad ke uraknam a gem uraknabin. Anɨb u, Bapi yad, ne unbö gɨmön a ga manö nɨpe u udem, haga rö nöp gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas manö anɨbu hagö, Juda kai kauyaŋ asɨk böŋ u ke, böŋ u ke löm, ");
INSERT INTO kpw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","rɨmnap hagla, “Nɨpe kɨjaki abaŋ alö, manö piral hagab u, nɨhön gɨnɨg manö nɨpe u nɨŋabim?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anɨg hageila, rɨmnap pen hagla, “Nɨpe kɨjaki abaŋ alböp u, anɨg hag aij gagböp. Pen kɨjaki abaŋ alö, aigöl göm nɨbi bɨ amgö we ga gau gö kauyaŋ nɨŋblap?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pen hainö Juda nɨbi bɨ, God sabe gep ram uɫ aij mɨdöp u mɨñ mɨñ gep ñɨn kub u mɨñi, a göm, Jerusalem am magum gɨla. Pen ñɨn kub anɨbu, ram yɨgön ñɨn u me, ");
INSERT INTO kpw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas nɨpe God sabe gep ram höŋ adö “Solomon Ram Bada” a gɨmɨdal u ajeia nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda nɨbi bɨ gau Jisas mɨdeia au apöm hagla, “Hanɨp gö pör nöp abad mɨdagaiun; ne Krais u mɨdaimön u, waiö hagö nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hageila, Jisas haga, “Yad kalöp hadö hagnö pen manö yad u manö nɨŋö a gɨmim nɨŋ udagpe. Bapi yad kƚö nɨpe udem nan gagep gau gɨpin u nɨŋmim, manö yad u manö nɨŋö a gɨmim nɨŋ udbep. ");
INSERT INTO kpw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pen sipsip yad mɨdagpim rö, manö yad u manö nɨŋö a gɨmim nɨŋ udagpe. ");
INSERT INTO kpw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip yad gau manö yad hagabin nɨŋbal; yad kalɨp nɨŋbin nɨŋöm kale yɨp hain gɨpal. ");
INSERT INTO kpw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yɨp hain gɨpal gau, kalɨp kamɨŋ pör mɨdep magö u ñabin u me, kale umagnaböl. Ñɨmagö adö yad mɨdpal rö, nɨbi bɨ rɨmnap apöm kalɨp ɫɨp gɨ ud aröl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapi yad kalɨp ud yɨp ñöb u, nɨpe Bɨ kƚö unbö ke yabɨƚ mɨdöp me. Ñɨmagö adö nɨpe mɨdpal rö, nɨbi bɨ rɨmnap apöm kalɨp ɫɨp gɨ ud aröl rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapi ke, yad ke, wasö; hol apɨl añɨ yabɨƚ mɨdpul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisas anɨg hageia, Juda kai nɨp kauyaŋ kabö ju paknɨg geila. ");
INSERT INTO kpw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Anɨg geila, Jisas kalɨp pen haga, “Bapi yɨp hagö, kale mɨdaibe nɨŋöl gɨ, nan aij ke ke iru nöp gɨnö. Pen nan aij gɨnö anɨb gau, adö mai gɨ naij gɨnö nɨŋmim, yɨp al pak lɨnɨg gabim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hageia hagla, “Nan aij adö anɨb gau nɨŋun, nöp al pak lɨnɨg gagabun; ne bɨ yabɨƚ pen, yad God rö mɨdpin, a gɨmön, God hib nɨpe dap lug gɨpan u me, nape al pak lɨnɨg gabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Anɨg hageila, Jisas haga, “Lo kale ke adɨŋ ap kalɨ kƚiñ rɨköm hagla, ‘God nɨpe haga, “Kale ke god rö mɨdpim,” a ga,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God Manö u manö ap piral hagagnab; pör nöp pör nöp nɨŋö nöp mɨdeinab. God nɨpe nɨbi bɨ yɨharɨŋ gau manö hagajɨn anɨbi ñöm, ‘Kale god rö mɨdpim,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pen yad, yad mɨnöŋ naböŋ iƚ i aubin u, Bapi yɨp wög nɨpe hag löm hag yuö aubin. Pen yad God Ñɨ nɨpe mɨdpin a gɨnö manö anɨbu nɨŋmim, kale nɨhön gɨnɨg, God hib nɨpe hag pro gab, a gɨmim, yɨp al pak lɨnɨg gabim? ");
INSERT INTO kpw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yad God wög nɨpe geinabin u, manö yad nɨŋ udmim. Wasö u, wasö. ");
INSERT INTO kpw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pen manö yad nɨŋ udagun, a gɨnabim u, yad nan gagep rö gɨpin gau nɨŋmim, nɨŋ udmim. Kale anɨg göl nɨŋ udmim me, yad Bapi aip mɨdpin Bapi yad aip mɨdöp u nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jisas nɨp kauyaŋ ud sɨsɨ lun a gɨla u pen agamɨj hil gɨ löm ara. ");
INSERT INTO kpw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas anɨg hil gɨ amöm, kauyaŋ ñɨg Jodan juöm böŋ lödaŋ amöm, Jon nöd mɨdöm nɨbi bɨ ñɨg pak ñɨmɨdöp ram mɨnöŋ rɨgoŋ gau am mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nɨbi bɨ iru nöp mɨdeia u apöm hagla, “Jon nan gagep rö rɨmnap gagmɨdöp, pen nɨpe bɨ i nɨp a göm, manö nɨhön nɨhön hagmɨdöp u, magöŋhalö manö nɨŋö nöp hagmɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Anɨg hagöm, nɨbi bɨ mɨgan anɨbu mɨdeila gau iru nöp Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ram rɨƚɨg agƚö Bedani nɨbö bɨ ap nan ga; hib nɨpe u Lasaras. Bɨ anɨbu, nɨñɨn nɨpe mɨhöp mɨdmɨdil; ap Maria, ap Mada. ");
INSERT INTO kpw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria me, Jisas nɨp ma kɨd nɨpe u wel hoŋ gɨ ñöm, umagö nɨpe ud ƚɨk gɨ yua nɨbi anɨbu. Nɨmam nɨpe Lasaras nan ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaras nɨñɨn mɨhau Jisas nɨp manö bɨg yumil haglö, “Bɨ Kub! Bɨ mɨdmagö ne u nan göp,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pen Jisas manö hag yulö anɨbu nɨŋöm haga, “Nɨpe nan göp pen böŋ nöp umagnab. Pen God nɨpe ke nɨŋöb rö, nɨpe kƚö ke nɨpe gö, nɨbi bɨ gau God hib nɨpe u abe, God Ñɨ hib nɨpe u abe haglö adö arnab, a göm ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas nɨpe Mada, nɨñɨn nɨpe Maria, nɨmam kale Lasaras kalɨp yam mɨdmagö lɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pen Lasaras nan ga manö anɨbu nɨŋöm, Jisas nɨp nɨŋnɨg yɨŋɨd araga; ram mɨnöŋ mɨdeia au ñɨn mɨhöp halö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ñɨn mɨhöp lugö, bɨ nɨpe gau kalɨp haga, “Ram mɨnöŋ Judia ado gɨ arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anɨg hageia, bɨ nɨpe gau hagla, “Manö hag ñeb bɨ. Rol magö u nöp, bɨ Juda gau nöp kabö ju paknɨg geila u pen ne kuöyaŋ ram mɨnöŋ anɨbu ado gɨ arnɨg gabön aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hageila, Jisas haga, “Kale nɨŋbim, ñɨn añɨ ap, aua unbö mɨgan laŋ nöp mɨdöp. Nɨbi bɨ mailö halö ajeinaböl gau, mɨnöŋ naböŋ mailö anɨbu mailö ñö, nan rɨmnap kalpe li ludö arö ap lug pakagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pen nɨbi bɨ sɨbön yaŋ ajeinaböl gau, mailö kale mɨdagö, nan rɨmnap kalpe li ludö arö ap lug paknaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas anɨg hagöm, manö ap halö kalɨp hagöm haga, “Bɨ nɨŋeb hon Lasaras hon hanab; pen yad amem nɨp hagnö urak aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Hageia, bɨ nɨpe gau pen hagla, “Bɨ Kub. Nɨpe hanab a gɨpan rö, kamɨŋ lɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas nɨpe Lasaras hadö umöb u nɨŋöm, “Lasaras hon hanab,” a ga. Pen bɨ nɨpe gau Jisas manö nɨpe nɨŋöm, Lasaras yɨharɨŋ hon hanab a gɨ gasɨ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bɨ nɨpe gau nɨŋagep adö mɨdeila nɨŋöm Jisas kalɨp waiö hagöm haga, “Lasaras hadö umöb. ");
INSERT INTO kpw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pen yad Lasaras aip mɨdagainö umöb u, kalöp nan a gem mɨñ mɨñ gɨpin. Anɨg göp u me, kale manö yad nɨŋ udmim rö löp. Pen Lasaras mɨdöp au arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hageia, Domas Didimas nɨpe Jisas bɨ nɨpe rɨmnap gau kalɨp haga, “Hon magöŋhalö manö hag ñeb bɨ hon aip ram mɨnöŋ Judia arno, nɨp al pak löm, hanɨp abe al pak löl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pen kale ram rɨƚɨg agƚö Bedani amjakeila, nɨbi bɨ gau Jisas nɨp hagla, “Lasaras uma rɨgöl gɨno, ñɨn mɨhau mɨhau padiöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pen ram rɨƚɨg agƚö Bedani anɨbu, Jerusalem söl au, kilomida unbö mɨhau nɨgaŋ rö nöp mɨdmɨdöp rö me, ");
INSERT INTO kpw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lasaras umö, Juda nɨbi bɨ iru nöp apöm, Mada Maria añɨl mɨhau mög nɨŋöm mɨɫöŋ magö gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pen Jisas auab, a gɨlö, Mada nɨŋöm, nɨñɨn Maria nɨp ram u arö göm, am Jisas nɨp nɨŋnɨg ara. ");
INSERT INTO kpw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mada nɨpe am Jisas nɨp nɨŋöm haga, “Bɨ Kub. Ne i mɨdaibnap, mam yad Lasaras umagböp. ");
INSERT INTO kpw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pen yad nɨŋbin, mɨñi God nɨp nan nɨhön hag nɨŋeinabön, hagnabön rö gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Hageia, Jisas haga, “Namam kuöyaŋ uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hageia, Mada haga, “Yad nɨŋbin manö kub hagep ñɨn u uraknab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Hageia, Jisas haga, “Yad ke gɨnö nɨbi bɨ uraknaböl; yad ke gɨnö nɨbi bɨ kamɨŋ mɨdeinaböl. Nɨbi bɨ yɨp nɨŋ udöm umnaböl gau, kamɨŋ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɨbi bɨ kamɨŋ mɨdöm yɨp nɨŋ udnaböl gau, umagnaböl; pör nöp pör nöp kamɨŋ mɨdeinaböl. Manö hagabin anɨbi nɨŋ udpan aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jisas anɨg hageia, Mada haga, “Bɨ Kub. Yaue, yad nɨŋbin, ne me Krais u, God Ñɨ nɨpe mɨnöŋ naböŋ i aunab, a gɨmɨdal u nöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mada manö anɨbu hagöm, ram ado gɨ amöm, nɨñɨn nɨpe Maria nɨp rɨmɨd iƚ gau mumug rɨköm haga, “Manö hag ñeb bɨ hadö auub; nöp mai a göm hag nɨŋab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria manö anɨbu nɨŋöm yɨŋɨd uraköm, Jisas nɨp nɨŋnɨg ara. ");
INSERT INTO kpw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pen Jisas ram rɨƚɨg agƚö Bedani hadö auaga; Mada nɨp nɨŋa mɨgan anɨb au nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria nɨpe anɨg yɨŋɨd arö, Juda nɨbi bɨ nɨp aip ram raul mɨdeila gau hag nɨŋla e, wip rɨgöl daŋ mɨɫöŋ gɨnɨg arab, a göm, arö nɨŋöl gɨ hain arla. ");
INSERT INTO kpw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria am Jisas nɨp nɨŋöm, mɨdeia ma iƚ au maben yɨmöm haga, “Bɨ Kub, ne aui mɨdaibnap, mam yad umagböp!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pen Maria abe, Juda nɨbi bɨ nɨpe aip aula gau abe mɨɫöŋ geila u nɨŋöm, Jisas gasɨ hibur mɨdmagö nɨpe mög kub yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Anɨg gö, Jisas haga, “Nɨp rɨgöl gɨpim gai?” ö ga. Hageia hagla, “Auö am nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas amgö ñɨg luga. ");
INSERT INTO kpw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jisas amgö ñɨg lugeia u nɨŋöm, Juda nɨbi bɨ gau nɨŋöm hagla, “Nɨŋim! Lasaras nɨp mɨdmagö yabɨƚ löp!” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Rɨmnap pen hagla, “Nɨpe bɨ amgö we ga u nɨp gö amgö ñɨl nɨŋa rö, nɨhön gɨnɨg nan bɨ anɨbi nɨp ga u gö kamɨŋ laga?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pen Jisas kuöyaŋ gasɨ hibur mɨdmagö nɨpe mög kub yabɨƚ nɨŋöm, Lasaras nɨp rɨgöl gɨla mɨgan u amjaka. Wip rɨgöl gɨla anɨbu, kabö mɨgan ap rɨgöl gɨla; pen kabö kub ap ud ajöŋ pɨƚ gɨlö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pen Jisas bɨ gau haga, “Kabö u ud yuim,” a ga. Jisas anɨg hageia, bɨ Lasaras uma anɨbu nɨñɨn nɨpe Mada haga, “Bɨ Kub, wip u umö rɨgöl gɨno, ñɨn mɨhau mɨhau padiöp u, haƚɨŋ naij yabɨƚ aunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Hageia, Jisas pen haga, “Nöp nɨhön hagajɨn? Nöp hagpin, ‘Yɨp nɨŋ ud mɨdmön me, God kƚö nɨpe ke nɨŋnabön,’ a gɨpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Anɨg hageia, kabö u ud yulö, Jisas gɨlaŋ gɨ nɨŋöm haga, “Bapi, yad nöp hag nɨŋnö yɨp nɨŋban u, nöp aij a gabin. ");
INSERT INTO kpw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yad nöp hag nɨŋnö yɨp pör nɨŋban u hadö nɨŋbin, pen manö hagabin anɨbi, nɨbi bɨ aui urak mɨdpal gai, ne nöp yɨp yuö aunö u nɨŋ udöl, a gem hagabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas anɨg hagöm, meg mɨgan dap ranöm haga, “Lasaras, ne höŋ aui au!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hageia, waƚɨj ñɨn ma nɨp wam wam haluöm, nabɨc maj mɨgan waƚɨj wam wam göm, dam rɨgöl gɨla waƚɨj gau, anɨg göl mɨdö nɨŋöl gɨ, wip he mɨlö u urak waƚɨj halö wam wam göm höŋ aua. Auö, Jisas bɨ gau kalɨp haga, “Waƚɨj nɨp wam halubim gau hubɨk yube araŋ,” a ga. Hageia, haga rö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda nɨbi bɨ Maria nɨp nɨŋnɨg aula anɨb gau, Jisas Lasaras nɨp gö uraka u nɨŋöm, nɨbi bɨ iru nöp Jisas nɨpe Krais u a göm, nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pen rɨmnap ado gɨ bɨ Perisi mɨdeila au amöm, Jisas ga anɨbu kalɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hag ñeila, bɨ Perisi gau abe, bɨ God nɨp nan sabe gep bɨ kub gau abe, kale Juda Kansol manö ud asɨk lɨmɨdal bɨ kub gau kalɨp wɨñ allö, am magum geila, kalɨp hagla, “Bɨ anɨbu nan gagep iru nöp gab u, hon nɨhön gɨnabun? ");
INSERT INTO kpw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hon nɨŋun arö gɨno, nɨpe anɨbu nöp gö arö, nɨbi bɨ magöŋhalö nɨp nɨŋ udöm, kiŋ kub hon a geinaböl u, Rom bɨ kub gau apöm, God sabe gep ram hon u gɨ naij göm, hanɨp Juda nɨbi bɨ gɨ naij göm, gɨnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pen mɨ anɨbu nöp, bɨ ap nɨp hag lɨlö, nɨpe bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u mɨdeia. Bɨ anɨbu hib nɨpe Kaiapas. Nɨpe magum geila aŋ u manö hagöm haga, “Kalöp gasɨ lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yad kalöp hagabin, bɨ añɨ ap umö hon magöŋhalö kamɨŋ arnabun u aij; hon magöŋhalö umnabun u naij,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas nɨpe manö haga anɨbu, nɨpe ke hagaga; nɨpe bɨ God nɨp nan sabe gep bɨ kub yabɨƚ mɨ anɨbu mɨdeia rö, nɨpe nan nɨhön nɨhön hainö gɨnab gau gasɨ nɨŋöm, Jisas nɨpe Juda nɨbi bɨ gau kalɨp a göm umnab, a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pen Juda kai kalɨp nöp wasö; nɨbi bɨ God ñɨ pai nɨpe udnɨg gab gau magöŋhalö ud jɨm ñöm lö, iƚ nɨpe añɨ yabɨƚ mɨdeinaböl, a göm umnab, a ga. ");
INSERT INTO kpw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Anɨb u, ñɨn anɨbu iƚ göm, Juda bɨ kub anɨb gau Jisas nɨp aige gun alun, a göm, pör nöp manö anɨbu nöp hag amɨl apɨl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Juda bɨ kub gau Jisas nɨp alnɨg geila u nɨŋöm, Jisas nɨpe ram mɨnöŋ kale ram mɨnöŋ Judia waiö ajagmɨdöp; nɨpe bɨ nɨpe gau aip ram mɨnöŋ Judia au ju am Epraim daun amjaköm, mɨnöŋ naböŋ kabö nöp mɨdmɨdöp goƚ au mɨdmɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pen Juda kai Pasopa ñɨn kub kale u söl söl ga nɨŋöm, nɨbi bɨ iru nöp ram mɨnöŋ kale ke gau arö göm, hon God amgö ilö nɨbi bɨ uɫ aij mɨdun, Pasopa nan ñɨŋun, a göm, wög adö kale hadame gau gɨmɨdal rö gɨnɨg Jerusalem arla. ");
INSERT INTO kpw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kale Jerusalem apjaköm, Jisas nɨp uƚhai nɨŋ mɨdeila. Kale amöm God sabe gep ram raul mɨgan u mɨdöm, Jisas mai, a göm, pen hag nɨŋö pen hag nɨŋö göm hagla, “Kale nɨhön gasɨ nɨŋbim? Nɨpe Pasopa ñɨn i aunab aka wasö?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pen God nɨp nan sabe gep bɨ kub gau abe, bɨ Perisi gau abe, manö ap hagla, “Nɨbi bɨ ap Jisas nɨp nɨŋainɨm u, nɨpe ap hanɨp hageinab, hon am nɨp ud sɨsɨ lun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa nan ñɨŋnɨg gɨla u, ñɨn unbö kagoƚ jɨŋ u nöp mɨdö nɨŋöl gɨ, Jisas Lasaras uma nɨp gö uraka ram nɨpe u ara. Ram rɨƚɨg agƚö anɨbu hib Bedani. ");
INSERT INTO kpw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bedani amöm, nan ñɨŋun, a göm, Jisas u, Lasaras u, nɨbi bɨ rɨmnap abe, asɨk mɨdeila nɨŋöm, Mada nan magö gau nɨme la. ");
INSERT INTO kpw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nɨñɨn Maria pen, wel haƚɨŋ aij mani kub yabɨƚ raubal barol ap dapöm, Jisas ma adö u hoŋ gɨ ñöm, umagö nɨpe u udöm ma nɨpe ƚɨƚɨ ga. Anɨg geia, wel haƚɨŋ aij anɨbu, ram raul anɨbu magöŋhalö haƚɨŋ ara. ");
INSERT INTO kpw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anɨg geia, Judas Iskariod, Jisas bɨ nɨpe au nɨp hainö mumug nɨŋa bɨ anɨbu, haƚɨŋ aij anɨbu nɨŋöm haga, ");
INSERT INTO kpw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mani kub yabɨƚ raubal wel anɨbi rö yuöm, mani udöm, nɨbi bɨ nan mɨdagöp gau kalɨp ñɨböp u aij. Bɨ wel anɨb rö raunɨg gab u, nɨpe rakɨn unbö sɨduŋ laŋ wög göm mani udöm amöm wel anɨbi raunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nɨpe anɨg haga u, nɨbi bɨ nan mɨdagöp gau mög nɨŋöm hagaga; nɨpe mani wadɨ u ud ajöm, rɨmnap agamɨj si udmɨdöp u me anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pen Jisas haga, “Nɨp hag gagmön. Yɨp rɨgöl gɨnaböl ñɨn u lɨ ñɨnɨg dap löp u, uri dap lɨ ñöb. ");
INSERT INTO kpw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nɨbi bɨ mani mɨdagöp gau aip pör mɨdeinabim; pen yad aip pör mɨdageinabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas Bedani ap mɨdöp a gɨla manö anɨbu nɨŋöm, Juda nɨbi bɨ iru nöp gau nɨp nɨŋnɨg arla. Pen Jisas nɨp nöp nɨŋnɨg aragla; Lasaras bɨ uma Jisas gö uraka bɨ anɨbu nɨp abe nɨŋnɨg arla. ");
INSERT INTO kpw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pen Lasaras uma Jisas nɨp gö uraka rö, Juda nɨbi bɨ iru nöp nagɨ adö kale gɨ mɨdmɨdal u arö göm, Jisas nɨp nɨŋ udla. Anɨg geila, bɨ God nɨp nan sabe gep bɨ kub gau, Lasaras nɨp abe alnabun, a göm gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ruö, nɨbi bɨ iru yabɨƚ Pasopa nan ñɨŋnɨg aula gau, Jisas Jerusalem auab a gɨla manö anɨbu nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nɨp am nɨŋun, a göm, galon uɫaŋ rɨk dap löl gɨ, wɨñ kub alöl gɨ hagla, “Bɨ Kub hib nɨpe u hagno adö araŋ!” “Bɨ Kub nɨpe Bɨ nɨpe anɨbi yuö auöp me i!” “Nɨpe Bɨ aij. Hib nɨpe hagno adö araŋ!” “Nɨpe Isrel Kiŋ auab me i! Hib nɨpe hagno adö araŋ!” ");
INSERT INTO kpw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas kaj donki marep ap udöm, adö anɨbu asɨköm areia. Anɨg ga u, God Manö u kalɨ kƚiñ rɨköm hagla rö nöp ga. God Manö adɨŋ anɨbu kalɨ kƚiñ rɨköm hagla, ");
INSERT INTO kpw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion pai, ne pɨñɨŋ gagmön. Kiŋ ne u kaj donki marep adö u asɨköm auab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ga ñɨn anɨbu, Jisas bɨ nɨpe gau, God nɨpe anɨg gɨnab a ga rö nöp gab u a göm nɨŋagla; pen hainö Jisas umöm uraköm, God ram mɨnöŋ kumi kabö adö laŋ au hadö ara ñɨn anɨbu nöp, Jisas bɨ nɨpe gau gasɨ nɨŋ aij göm nɨŋla, Jisas Jerusalem araia ñɨn anɨbu nan nɨhön nɨhön nɨp gɨla gau, nöd God manö hagep bɨ gau God Manö kalɨ kƚiñ rɨköm hagla rö nöp gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisas Lasaras uma nɨp gö uraka u, nɨbi bɨ nɨŋöl mɨdeila gau manö anɨbu hag amɨl apɨl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Anɨb u, nɨbi bɨ iru nöp nan gagep ga anɨbu nɨŋöm, Jerusalem arö göm, nɨp adan aŋ au nɨŋnɨg arla. ");
INSERT INTO kpw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kale anɨg gɨla rö, bɨ Perisi gau nɨŋöm, kale ke nöp manö hagöm hagla, “Nɨŋim! Hon nan ap gun rö lagöp. Nɨbi bɨ mɨnöŋ naböŋ iƚ i magöŋhalö bɨ anɨbu nɨp hain gaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pen Pasopa ñɨn u auab, a göm, God nɨp sabe gɨnɨg Jerusalem arla ñɨn anɨbu, Grik nɨbi bɨ rɨmnap aip arla. ");
INSERT INTO kpw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik nɨbi bɨ anɨb gau apöm, Pilip ram mɨnöŋ Galili au Bedsaida daun nɨbö bɨ u nɨp hagla, “Bɨ kub nɨŋeb, hon Jisas nɨp nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Anɨg hageila, Pilip am Edru nɨp hag ñöm, Edru aip mɨhöŋgöl ammil Jisas nɨp hag ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hag ñailö, Jisas haga, “Mɨñi God gö, Bɨ Ñɨ nɨpe Bɨ mailö aij ke halö mɨdöp u nɨŋnaböl ñɨn u hadö auöp. ");
INSERT INTO kpw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yad kalöp nɨŋö yabɨƚ hagabin, wid magö ap mɨnöŋ yaŋ lugöm umagnab u, yɨharɨŋ wid magö añɨ ap nöp mɨdeinab. Pen wid magö anɨbu mɨnöŋ yaŋ lugöm umeinab u, hainö ranöm magö iru nöp pɨlnab. ");
INSERT INTO kpw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nɨbi bɨ an, ‘Mɨnöŋ naböŋ iƚ i kamɨŋ mɨdep magö yad ke nöp gasɨ nɨŋem mɨd aij gɨnam,’ a göm gö arnab u, nɨpe umöm böŋ nöp umnab; pen nɨbi bɨ an, ‘Mɨnöŋ naböŋ iƚ i kamɨŋ mɨdep magö yad ke gasɨ iru nɨŋagnam; mɨd aij gɨnabin aka mɨd aij gagnabin u nan kub wasö,’ a göm gö arnab u kamɨŋ mɨdep magö nɨpe u pör nöp pör nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pen nɨbi bɨ an yɨp wög gɨnɨg gɨnabin a gɨnab u, nɨpe yɨp hain gɨnɨm; yad gai mɨdeinabin u, nɨbi bɨ wög gɨ ñeb yad aip mɨdeinab. Nɨbi bɨ an wög yad gɨ ñɨnab, Bapi yad nɨbi bɨ anɨbu hib nɨpe u dap rannab. ");
INSERT INTO kpw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Mɨñi yɨp marö gab u nɨhön hagnam? ‘Bapi yɨp rarö rauö, yɨp nan nɨhön gɨnɨg gab u gagnɨm,’ a gem hagnam aka? Wasö! Marö anɨbu udnɨg aunö. ");
INSERT INTO kpw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pen Bapi, ne gö nɨbi bɨ gau nɨŋnaböl, ne Bɨ mailö aij ke halö mɨdpan,” a ga. Jisas anɨg hagö nɨŋöl gɨ, manö ap kumi kabö adö laŋ nɨbö apöm haga, “Yad gɨnö, nɨbi bɨ gau hadö nɨŋbal yad Bɨ mailö aij ke halö mɨdpin. Pen yad kauyaŋ gɨnö, nɨbi bɨ gau kauyaŋ nɨŋnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pen nɨbi bɨ mɨdeila gau, God manö haga anɨbu nɨŋöm, rɨmnap hagla, “Rɨmu hagajɨp,” a gɨla; rɨmnap pen hagla, “Ejol ap Jisas nɨp manö rɨmnap hagajɨp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Anɨg hagla u pen Jisas kalɨp haga, “Manö hagajɨp anɨbu yɨp nan a göm hagagöp; kalöp nan a göm hagajɨp. ");
INSERT INTO kpw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pen nɨhön: mɨñi nɨbi bɨ mɨnöŋ naböŋ iƚ i gau, kale nɨhön nɨhön gɨpal u, God nɨpe ke nɨŋöm, pen ñöm, kale balu ke ke lɨnab. Nɨbi bɨ mɨnöŋ naböŋ iƚ i yɨp nɨŋ udagpal gau kalɨp kiŋ rö abad mɨdöp bɨ naij anɨbu, God nɨp rɨdɨk gɨ yunab. ");
INSERT INTO kpw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yɨp ud adö au laŋ leinaböl u, yad nɨbi bɨ ram mɨnöŋ ke gau nɨbö magöŋhalö ɫɨp gɨ dam udnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas manö haga anɨbu, yɨp aige göl gɨlö umnabin, a göm, haga. ");
INSERT INTO kpw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pen nɨbi bɨ iru nöp ap mɨdeila anɨb gau Jisas nɨp pen hagla, “Lo manö hon u hagöp, ‘Krais u pör pör nöp kamɨŋ mɨdeinab,’ a göp u pen ne ai gɨnɨg gɨmön hagabön, ‘Bɨ Ñɨ nɨpe nɨp ud adö au laŋ lɨnaböl,’ a gabön? Pen Bɨ Ñɨ nɨpe a gɨ hagabön u, an nɨp hagabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Hageila, Jisas haga, “Mailö u pro marap halö kalöp aip mɨdeinab. Anɨb u, mailö kalöp aip mɨdöp magö i, adan aj aij gɨmim; wasö u, sɨb apöm kalöp paƚu gɨnab. Nɨbi bɨ an sɨb au ajeinab, gai arnabin a göm nɨŋagnab. ");
INSERT INTO kpw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mailö kalöp aip mɨdöp magö i, mailö u nɨŋ udmim. Mailö u nɨŋ udeinabim u, mailö ñɨ pai nɨpe lɨnabim,” a ga. Jisas anɨg hagöm, nɨbi bɨ anɨb gau arö göm ke gau aramöm pi göl mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas nɨpe nan gagep iru nöp nɨbi bɨ gau amgö ilö adö kale ga nɨŋla pen nɨp nɨŋ udagla. ");
INSERT INTO kpw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nɨbi bɨ Jisas nɨp nɨŋ udagla u, bɨ God manö hagep Aisaia hadame nöp God Manö adɨŋ ap kalɨ kƚiñ rɨköm haga rö nöp gɨla. Nɨpe manö anɨbu kalɨ kƚiñ rɨköm haga, “Bɨ Kub, manö aij ne kalɨp hag ñɨbun pen kale manö anɨbu manö aij a göm udagpal; ne kƚö ke yabɨƚ ne ke gɨmön gaina u nɨŋbal u pen nöp Bɨ Kub a göm nɨŋ udagpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Anɨb u, kale Jisas nɨp nɨŋ udagla. Anɨg gɨla u, Aisaia God Manö adɨŋ ap kalɨ kƚiñ rɨköm haga rö nöp gɨla. Nɨpe manö anɨbu kalɨ kƚiñ rɨköm haga, “God nɨpe nɨbi bɨ gau kalɨp gö kale amgö we rö mɨdpal; God nɨpe gö kale gasɨ rɨmɨd aij mɨdagöp. God nɨpe kalɨp ga anɨbu, kale amgö magö nɨŋ aij göm, gasɨ rɨmɨd nɨŋ aij göm, yɨp aublap, yad gɨnö kalɨp kamɨŋ lɨböp, a göm ga,” a ga. Adö anɨbu nöp kale Jisas nɨp nɨŋ udöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia hadame nöp manö haga anɨbu, nɨpe Jisas mailö aij nɨpe u nɨŋöm anɨg haga. ");
INSERT INTO kpw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pen Juda bɨ kub gau kale magöŋhalö Jisas nɨp arö gagla; bɨ kub iru nɨbanö nɨp nɨŋ udla. Pen, bɨ Perisi hanɨp hag yulö hon Juda magum gep ram raul mɨgan u kuöyaŋ arep rö lagnab, a göm me, Jisas nɨŋ udla u waiö hagagla. ");
INSERT INTO kpw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jisas nɨŋ udla u waiö hagagla anɨbu, nɨbi bɨ gau hib hon haglö adö araŋ, a gɨ gasɨ nɨŋöm, anɨg gɨla. Pen nan nɨhön gɨno God nɨŋö, nɨp aij gɨnab a göm, gasɨ anɨbu nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pen Jisas meg magö dap ranöm haga, “Nɨbi bɨ an yɨp nɨŋ udnab u, yɨp nöp wasö, bɨ yɨp hag yuö aunö nɨp abe nɨŋ udnab. ");
INSERT INTO kpw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nɨbi bɨ an yɨp amgö nɨŋnab u, yɨp nöp wasö, bɨ yɨp hag yuö aunö nɨp abe amgö nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yad mɨnöŋ naböŋ iƚ i apem nɨbi bɨ gau kalɨp mailö ñabin. Anɨb u, nɨbi bɨ yɨp nɨŋ udnaböl gau, sɨbön aŋ gau mɨdageinaböl. ");
INSERT INTO kpw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nɨbi bɨ manö yad u nɨŋöm hagabin rö gagnaböl gau, kalɨp manö kub hagagnabin. Pen nɨhön: yad nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal kalɨp manö kub hagnɨg auagnö; kalɨp ud kamɨŋ yunɨg aunö. ");
INSERT INTO kpw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pen nɨbi bɨ yɨp udagöm, manö yad udagnaböl gau, manö kub hagep ñɨn u, manö yad hagpin u nöp kalɨp manö kub hagnab. ");
INSERT INTO kpw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nɨhön gɨnɨg: manö yad hagpin u, ke nɨŋem hagagpin; Bapi yɨp hag yua u, anɨg anɨg hagmön, a göp rö nöp hagpin. ");
INSERT INTO kpw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yad nɨŋbin, manö nɨpe u nɨŋ udeinaböl u, kalɨp pör mɨdep u ñɨnab. Anɨb u, manö yad hagabin u, Bapi manö anɨg anɨg rö hagmön, a göp rö nöp hagabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ñɨn kub Pasopa ñɨŋeb ñɨn u rol a göm, Jisas nɨŋa, Nap nɨp mɨnöŋ naböŋ iƚ i hag la ñɨn u padi ara nɨŋöm nɨpe ado gɨ Nap arep ñɨn u söl aua. Pen nɨbi bɨ nɨpe ke mɨnöŋ naböŋ iƚ i mɨdmagö lɨ mɨdöm, mɨd damöm, nɨp al pak lɨlö, umöm Nap ara. ");
INSERT INTO kpw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɨjaki pen Saimon Iskariod ñɨ nɨpe Judas nɨp gasɨ ñö, Jisas nɨp aige gem damem bɨ kub gau kalɨp ñɨnabin a göm, gasɨ u nöd nöp nɨŋ pi gɨ löm, hainö hon Jisas bɨ nɨpe gau Jisas aip Pasopa nan ñɨŋnɨg asɨkno. ");
INSERT INTO kpw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas nɨpe nɨŋöb, God nɨpe nan gau magöŋhalö ud ñɨmagö adö nɨpe la. Jisas nɨŋöb, nɨpe Nap God aip mɨdöm mɨnöŋ naböŋ iƚ i apöm, mɨdöm, hainö umöm, ado gɨ Nap mɨdöp arnɨg ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Anɨb u, Jisas uraköm, waƚɨj mɨlö kub nɨpe u ud juöm, raul ap aŋ au gɨdaŋ pɨralöm, ");
INSERT INTO kpw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ñɨg rɨmnap ud cög mɨgan ap hoŋ göm, hanɨp bɨ nɨpe gau ma hon u ñɨg löl gɨ, raul pɨrala anɨbu ud ƚɨk gɨ yuöl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas anɨg gɨ dam dam, Saimon Pida ma nɨpe ñɨg lɨnam, a gö, Pida nɨp haga, “Bɨ Kub. Ne ke ma yɨp u ñɨg ƚɨk gɨ yunɨg gabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hageia, Jisas haga, “Mɨñi gabin i, ne uri nɨŋagan, pen mɨdmön hainö nɨŋnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jisas anɨg hageia, Pida haga, “Uri aka hainö gau, ma yɨp u ñɨg ƚɨk gɨ yuagnabön, wasö yabɨƚ!” a ga. Hageia, Jisas pen haga, “Ma nöp ñɨg ƚɨk gɨ yuagnabin u; bɨ yad mɨdageinabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jisas anɨg hageia, Saimon Pida haga, “Bɨ Kub! Anɨg hagpan u, ma yɨp u nöp ñɨg ƚɨk gɨ yuagmön; ñɨmagö kɨd, nabɨc yad abe ñɨg ƚɨk gɨ yumön!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Anɨg haga pen Jisas haga, “Nɨbi bɨ an ñɨg hadö paköp, bɨ anɨbu hañ romaŋ nɨpe magöŋhalö uɫ aij mɨdöp. Kuöyaŋ ñɨg pakagnab; ma kɨd u nöp ñɨg ƚɨk gɨ yunab. Kale uɫ aij mɨdpim; pen kale añɨ ap nöp uɫ aij mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas haga u, nɨp mumug nɨŋnɨg geia bɨ anɨbu nɨp hadö nɨŋa u me, nɨpe haga, “Kale añɨ ap nöp uɫ aij mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pen Jisas ma hanɨp u ñɨg ƚɨk gɨ yu haköm, waƚɨj ud ju la u ud rol göm, am ka nɨpe au asɨköm haga, “Kalöp ma ñɨg ƚɨk gɨ yubin manö iƚ u, nɨŋbim aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Anɨg hagöm Jisas haga, “Yɨp Manö Hag Ñeb Bɨ aka Bɨ Kub hagpim u, nɨŋö hagpim. Yad Manö Hag Ñeb Bɨ kale abe Bɨ Kub kale abe mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anɨb u, yad Manö Hag Ñeb Bɨ kale, Bɨ Kub kale ma kalöp ñɨg ƚɨk gɨ yubin rö, kale u rö nöp pen pen ma ñɨg ƚɨk gɨ yumim, ma ñɨg ƚɨk gɨ yumim, gɨmim. ");
INSERT INTO kpw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yad kalöp gɨpin rö u nɨŋmim, kale pen am nɨbi bɨ rɨmnap kalɨp anɨg unbö rö nöp gɨmim a gem, kalöp adan aij anɨbi yambin. ");
INSERT INTO kpw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kalöp nɨŋö yabɨƚ hagabin, bɨ wög gɨ ñeb bɨ u bɨ kub, bɨ nɨp abadöp bɨ u bɨ pro, mɨdagöp; u rö nöp bɨ manö ud arep bɨ u bɨ kub, bɨ nɨp yua u bɨ pro, mɨdagöp. ");
INSERT INTO kpw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nagɨ aij hagajɨn nɨŋbim adö anɨbu gɨpe arö, kale mɨñ mɨñ gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“‘Kale añɨ ap nöp uɫ aij mɨdagöp,’ a gajɨn u, kalöp magöŋhalö a gem hagagɨn. Pen yad kalöp bɨ yad udpin gau nɨŋ aij gɨpin. Bɨ ap yɨp mumug gɨnɨg gɨnab u, God Manö u kalɨ kƚiñ rɨköm hagla rö nöp gɨnab. Manö anɨbu kalɨ kƚiñ rɨköm hagla, ‘Bɨ yad aip nan jɨm ñöl ñɨŋailo u, bɨ koƚmaƚ rö löm yɨp gɨ naij ga,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kalöp nöd, anɨg göl anɨg göl gɨnab a gem hagabin rö, hainö anɨg unbö rö nöp geinab u, ‘Yad Mɨdpin Rö Mɨdpin’ hagpin manö anɨbu manö nɨŋö, a gɨmim nɨŋ udnabim, a gem hagabin. ");
INSERT INTO kpw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ yad hag yunabin gau, nɨbi bɨ an an kalɨp udnaböl gau, kalɨp nöp udagnaböl; yɨp abe udnaböl. Pen nɨbi bɨ an yɨp udnaböl gau, yɨp nöp udagnaböl; Bɨ yɨp hag yuö aunö u abe udnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas manö anɨbu hagö, gasɨ hibur mɨdmagö nɨpe marö yabɨƚ gö, haga, “Kalöp nɨŋö yabɨƚ hagabin, kale bɨ ap yɨp mumug gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Anɨg hageia, hon bɨ nɨpe gau, an nɨp hagab, a gun, gasɨ mɨlö lun amgö pen pen nɨŋno. ");
INSERT INTO kpw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pen Jisas bɨ nɨpe mɨdmagö yabɨƚ lɨmɨdöp bɨ anɨbu, Jisas mɨdeia söl au asɨk mɨdeia u me, ");
INSERT INTO kpw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pida bɨ anɨbu nɨp amgö juju göm haga, “An nɨp hagab u hag nöŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hageia, nɨpe Jisas mɨdeia söl au ƚɨƚɨ gɨ amöm haga, “Bɨ Kub. Bɨ anɨbu bɨ an hagajan,” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Hageia, Jisas haga, “Yad bred kɨd i ud ñɨg kɨnaŋ yaŋ rauem nɨp ñɨnabin bɨ me u,” a ga. Anɨg hagöm, bred kɨd udöl mɨdajɨp u ñɨg acab yaŋ rauöm, ud Saimon Iskariod ñɨ nɨpe Judas nɨp ña. ");
INSERT INTO kpw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bred kɨd u udöp magö anɨbu nöp Seden nɨpe Judas yuö aŋ nɨpe yaŋ hiɨka. Jisas Judas nɨp haga, “Nɨhön gɨnɨg gabön u, yɨŋɨd gɨ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pen hon Jisas bɨ nɨpe, nɨhön gɨnɨg Judas nɨp anɨg hagab, a gun nɨŋagno. ");
INSERT INTO kpw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas nɨpe mani wadɨ u abad mɨdmɨdöp rö, hon Jisas bɨ nɨpe rɨmnap gasɨ nɨŋno, “Ne ammön Pasopa nan ñɨŋnabun rɨmnap raumön,” a göm hag yuab, a gɨ gasɨ nɨŋno; hon rɨmnap pen gasɨ nɨŋno, “Ne ammön nɨbi bɨ mani mɨdagöp gau kalɨp mani rɨmnap ñɨmön,” a göm hag yuab, a gɨ gasɨ nɨŋno. ");
INSERT INTO kpw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pen Judas bred kɨd anɨbu udöm höŋ ara. Ram hadö sɨb ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas höŋ ara nɨŋöm Jisas haga, “Söl mɨdöp God nɨpe gö nɨbi bɨ gau nɨŋnaböl, Bɨ Ñɨ nɨpe mailö aij ke halö mɨdöp. Pen Bɨ Ñɨ nɨpe mailö aij ke halö mɨdöp u nɨŋöm, God mailö aij nɨpe abe nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pen nɨbi bɨ kale Bɨ Ñɨ nɨpe nɨŋ udeinaböl u, God mailö aij unbö ke halö mɨdöp u nɨŋnaböl. Anɨb u, adɨŋ God gö nɨbi bɨ gau Bɨ Ñɨ nɨpe mailö aij unbö ke halö mɨdöp u waiö nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ñɨ mɨdmagö yad gai i! Yad kalöp aip rapɨn mɨdageinabin. Yad areinabin, yɨp aröp gai a gɨmim yɨp uƚhai wasö nɨŋnabim. Pen Juda bɨ kub gau kalɨp hagpin rö, uri kalöp u rö nöp hagabin: yad arnabin u, kale armim rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Pen mɨñi kalöp lo hain nɨbö ap ñabin: pen pen mɨdmagö lɨmim. Yad kalöp mɨdmagö lɨbin rö u, kale u rö nöp pen pen mɨdmagö lɨmim. ");
INSERT INTO kpw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pen pen mɨdmagö leinabim u, nɨbi bɨ gau magöŋhalö waiö nɨŋnaböl, kale bɨ yad mɨdpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Anɨg hageia, Saimon Pida haga, “Bɨ Kub. Gai arnɨg gabön?” ö ga. Hageia, Jisas haga, “Yad arnabin gau ne mɨñi hain nɨmön rö lagöp; pen hainö me, yɨp hain gɨnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Hageia, Pida haga, “Nɨhön gɨnɨg mɨñi nöp hain gagnam? Nöp abadnabin; yɨp al pak lɨnaböl u, manö mɨdagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hageia, Jisas pen haga, “Aip umnabin a gajan manö anɨbu manö nɨŋö hagan aka? Nöp nɨŋö yabɨƚ hagabin, kɨƚakɨƚ hainö wɨñ alnab; nöd nöp ij mɨhau nɨgaŋ hagnabön, ‘Yad Jisas nɨp nɨŋagpin,’ a gɨnabön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pen Jisas haga, “Kale gasɨ mɨŋör nɨŋmim pɨñɨŋ gagmim. Bapi nɨp nɨŋ udpim rö, yɨp u rö nöp nɨŋ udmim. ");
INSERT INTO kpw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bapi yad ram nɨpe u raul mɨgan iru nöp mɨdöp. Yad amem kau kalöp gɨ jɨn gɨnabin. Wasö u, anɨg hagagbnep. ");
INSERT INTO kpw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yad am kau kalöp gɨ jɨn gem, apem kalöp uɫ gɨ dam, yad mɨdeinabin au kale aip seg mɨdeinabun. ");
INSERT INTO kpw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yad arnɨg gabin adan u kale nɨŋbim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jisas anɨg hageia, Domas haga, “Bɨ Kub! Ne gai arnabön u hon nɨŋagpun. Anɨb u, hon aige gun adan arep nɨŋun?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Hageia, Jisas haga, “Yad nöp adan; yad nöp manö nɨŋö; yad nöp kamɨŋ mɨdep iƚ u. Nɨbi bɨ yɨp aunaböl gau nöp, Bapi aunaböl. Nɨbi bɨ yɨp auagnaböl gau, Bapi auagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yɨp nɨŋ aij gɨbep, Bapi yad u rö nöp nɨŋ aij gɨbep. Pen uri kale Bapi hadö nɨŋbim; amgö magö kale ke Bapi hadö nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Anɨg hageia, Pilip haga, “Bɨ Kub! Ne Bapi hanɨp yammön, nɨŋun, hainö nan ap nöp hag nɨŋagnabun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Hageia, Jisas haga, “Pilip. Yad kalöp aip mɨlö padö mɨdainö u, yɨp nɨŋagmön anɨg hagabön ar? Nɨbi bɨ yɨp amgö nɨŋbal gau, Bapi abe hadö amgö nɨŋbal. Anɨb u, ne nɨhön gɨnɨg hagabön, ‘Bapi hanɨp yamö nɨŋun,’ a gabön? ");
INSERT INTO kpw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yad Bapi aŋ nɨpe daŋ mɨdpin, Bapi aŋ yad daŋ mɨdöp manö u nɨŋ udagpan ar? Manö kalöp hagabin u manö yad ke wasö. Pen Bapi nɨpe aŋ yad daŋ mɨdöm gö hol apil mɨhau wög nɨpe nöp gabul me u. ");
INSERT INTO kpw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Anɨb u, yad Bapi aŋ nɨpe daŋ mɨdpin, Bapi aŋ yad daŋ mɨdöp manö u, manö nɨŋö a gɨmim nɨŋ udbep. Pen manö hagpin u nɨŋ udagnabim u, Bapi gö hol apil mɨhau nan gagep gau gabul u gasɨ nɨŋmim, ‘Ñɨ u Bapi aŋ nɨpe daŋ mɨdöp, Bapi Ñɨ nɨpe aŋ daŋ mɨdöp u me, anɨg gabil,’ a gɨmim nɨŋ udmim. ");
INSERT INTO kpw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ yɨp nɨŋ udnaböl gau, yad nan gagep gɨpin gau, kale abe u rö nöp gɨnaböl. Pen yad Bapi arnabin rö, kale unbö rö nöp gagnaböl; kale ke yabɨƚ gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pen kale bɨ yad mɨdpim rö, hib yad u hagmim, nan nɨhön nɨhön hag nɨŋnabim u, Bapi mailö aij ke halö mɨdöp u nɨŋöl, a gem, hagnabim rö gɨnabin. ");
INSERT INTO kpw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anɨb u me, nan nɨhön nɨhön hib yad u hagmim hag nɨŋnabim u, hagnabim rö gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kale yɨp mɨdmagö leinabim u, kalöp hagpin rö nöp gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kale anɨg geinabim u, yad pen Bapi nɨp hagnö, nɨpe kalöp Bɨ Aɫ Ba Gep u yuö apöm, kalöp aip pör pör nöp mɨdöm, yad kalöp gɨ ñɨmɨdin rö, nɨpe kalöp u rö nöp gɨ ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bɨ Aɫ Ba Gep nɨpe Ana manö nɨŋö nöp hag ñab u. Nɨpe God nɨpe bɨ aigale bɨ rö mɨdöp manö nɨŋö anɨbu hag ñab. Nɨbi bɨ mɨnöŋ naböŋ iƚ i gau Bɨ Aɫ Ba Gep nɨp amgö nɨŋagpal; nɨpe bɨ aigale bɨ rö mɨdöp u nɨŋagpal. Anɨb u, nɨp nɨŋ udöl rö lagöp. Pen mɨñi Bɨ Aɫ Ba Gep nɨpe kalöp aip mɨdöp; pen hainö aŋ kale daŋ mɨdeinab. Anɨb u, kale nɨp hadö nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yad umem, kalöp ñɨ nap mɨdagöp rö böŋ nöp arö gagnabin; yad kalöp ado gɨ aunabin. ");
INSERT INTO kpw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Söl mɨdöp, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau yɨp nɨŋagnaböl pen kale yɨp nɨŋnabim. Yad kamɨŋ mɨdeinabin rö, kale u rö nöp kamɨŋ mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ñɨn anɨbu yad Bapi yad aŋ nɨpe daŋ mɨdpin manö hagnö iƚ u nɨŋ aij gɨnabim. Pen kale yɨp aŋ daŋ mɨdpim, yad kalöp aŋ daŋ mɨdpin iƚ u u rö nöp nɨŋ aij gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nɨbi bɨ manö yad hagpin u nɨŋ udöm, hagpin rö nöp hain gɨpal gau, yɨp mɨdmagö löm me, anɨg gɨpal. Pen nɨbi bɨ yɨp mɨdmagö lɨbal gau, Bapi yad kalɨp u rö nöp mɨdmagö lɨnab; yad u rö nöp kalɨp mɨdmagö lem, yad bɨ aigale bɨ rö mɨdpin kalɨp yamnö, kale yɨp nɨŋ aij gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas anɨg hageia, Judas (Judas nɨp mumug nɨŋa u wasö, Judas ke ap) nɨpe Jisas nɨp haga, “Bɨ Kub. Nɨhön gɨnɨg ne bɨ aigale bɨ rö mɨdpan u hanɨp bɨ nöp yamnabön, pen nɨbi bɨ mɨnöŋ naböŋ ke ke gau nöp nɨŋ udagpal gau kalɨp yamagnabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Hageia, Jisas haga, “Nɨbi bɨ an yɨp mɨdmagö lɨnab u, manö hagpin u udöm hagpin rö nöp gɨnab. Bapi yad nɨp mɨdmagö löm, hol apɨl nɨp apul, nɨp aip mɨdeinabun. ");
INSERT INTO kpw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nɨbi bɨ an yɨp mɨdmagö lagnab u, manö hagpin u udöm hagpin rö gagnab. Pen yad manö hagnö nɨŋbim u manö yad ke wasö; Bapi yɨp hag yuö aunö u, manö nɨpe me. ");
INSERT INTO kpw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yad kalöp aip mɨdpin ñɨn i me, manö anɨbi hag ñajɨn. ");
INSERT INTO kpw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yad arnabin pen Bapi nɨpe Bɨ Aɫ Ba Gep u, Ana Uɫ u, yuö apöm wög yad gɨpin rö gɨnab. Ana Uɫ u nɨpe kalöp aip mɨdöm manö aij u magöŋhalö hag ñɨ aij göm, kalöp gasɨ aij ñö, kale yad manö nɨhön nɨhön hagpin gau magöŋhalö gasɨ nɨŋöl gɨ mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yad arnabin pen kale agamɨj mɨd aij gɨmim mɨdaimim. Manö anɨbu nɨbi bɨ mɨnöŋ naböŋ iƚ i gau yɨharɨŋ hagpal rö hagagabin. Yad ke apem gɨnö, nɨbi bɨ agamɨj mɨd aij göl rö löp. Anɨb u nɨŋem yad kalöp hagabin, agamɨj mɨd aij gɨmim mɨdaimim. Anɨb u, hibur gasɨ mɨdmagö mɨŋör nɨŋmim pɨñɨŋ gagmim. ");
INSERT INTO kpw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yad amem ado gɨ aunabin, a gajɨn u nɨŋmim, kale ai gɨnɨg hibur gasɨ mɨdmagö mɨŋör nɨŋöl gɨ mɨdpim? Kale yɨp mɨdmagö lɨbep u, Jisas amöm Nap God aip mɨdnɨg gab, a gɨmim, mɨñ mɨñ göl gɨ mɨdaibep. Ai gɨnɨg: nɨpe yad rö wasö; Bapi nɨpe Bɨ kub. ");
INSERT INTO kpw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Anɨb u, kalöp arɨk aragɨn magö i, kalöp nöd hagabin me u; hainö areinabin, gasɨ gau uƚhai nɨŋagnabim; manö hagpin u nɨŋ udnabim. ");
INSERT INTO kpw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nɨbi bɨ mɨnöŋ naböŋ iƚ i yɨp nɨŋ udagpal gau kalɨp kiŋ rö abad mɨdöp bɨ naij anɨbu auab u me, yad kalöp aip manö mɨlö kub hag mɨdeinam rö lagöp. Pen bɨ naij anɨbu yɨp gɨ naij gɨnabin a gab u, kƚö nɨpe mɨdagöp. ");
INSERT INTO kpw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yad Bapi yad mɨdmagö lɨbin u, nɨbi bɨ gau nɨŋöl a gem, Bapi yɨp hagöp rö nöp magöŋhalö gabin. “Pen uri aube hadö arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas manö hagöm haga, “Yad me nagɨ wain u; Bapi yad me bɨ wög naböŋ nap nɨbö u. ");
INSERT INTO kpw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lö kɨd yad ap magö pɨlagnab u, Bapi nɨpe lö kɨd anɨbu rɨb yunab. Pen lö kɨd pɨlnab u, hainö magö iru nöp pɨlnab a göm, nɨpe rɨb gɨ dö gɨ aij gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Yad kalöp manö aij hag ñɨnö nɨŋbim rö, kale hadö uɫ aij rö mɨdpim. ");
INSERT INTO kpw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yɨp aŋ daŋ mɨdaimim; yad kalöp aŋ daŋ mɨdeinabin. Lö kɨd gau, iƚ halö jɨm ñöl mɨdöm nöp, magö pɨlnab; ke nöp mɨdöm magö pɨlagnab. Anɨb unbö rö nöp, kale yɨp jɨm ñöl mɨdageinabim u, magö rɨmnap pɨlagnab. ");
INSERT INTO kpw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yad me nagɨ wain u, kale me pɨñ lö gau. Nɨbi bɨ an an yad aip jɨm ñöl mɨdeinaböl gau, magö iru nöp pɨlnaböl; pen kale ke halö nöp mɨdeinabim u, nan ap gagnabim. ");
INSERT INTO kpw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Anɨb u, nɨbi bɨ an yɨp aŋ daŋ mɨdageinab u, nagɨ lö rɨb gɨ dö gɨlö iƚ yaŋ lugöm mɨƚep gɨnab rö u mɨdeinab; nagɨ lö anɨb gau ud dam laulö innab. ");
INSERT INTO kpw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pen kale yɨp aŋ daŋ mɨdmim, manö magö yad aŋ kalöp daŋ nɨŋ udöl gɨ mɨdeinabim u, nan nɨhön nɨhön hag nɨŋnabim u, Bapi hagnabim rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kale nan magö iru nɨbanö pɨlnab u, nɨbi bɨ yad nɨŋö yabɨƚ mɨdeinabim. Anɨb u, nɨbi bɨ gau kale nɨŋöm, Bapi yad Bɨ mailö aij ke halö mɨdöp u nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bapi yɨp mɨdmagö yabɨƚ löp rö, yad kalöp u rö nöp mɨdmagö yabɨƚ lɨbin. Anɨb u, kale yɨp cɨg göl gɨ nöp mɨdaimim, nɨŋem yad kalöp mɨdmagö löl gɨ mɨdeinabin. ");
INSERT INTO kpw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yad Bapi manö nɨpe u hain gɨnö, yɨp mɨdmagö löl gɨ nöp mɨdöp. Anɨb unbö rö nöp, kale manö yad u hain geinabim u, yad kalöp mɨdmagö löl gɨ nöp mɨdeinabin. ");
INSERT INTO kpw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Manö kalöp hagabin anɨbi, yad ai gɨnɨg gem hagabin? Yad mɨñ mɨñ yabɨƚ gɨpin rö, kale u rö nöp mɨñ mɨñ yabɨƚ gɨmim, a gem, manö anɨbi hagabin. ");
INSERT INTO kpw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yad pen kalöp manö kƚö ap hagnabin: yad kalöp mɨdmagö yabɨƚ lɨbin rö u, kale abe u rö nöp pen pen mɨdmagö yabɨƚ lɨmim. ");
INSERT INTO kpw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bɨ ap nɨpe bɨ nɨŋeb nɨpe gau gasɨ nɨŋöm kalɨp a göm umnab u, bɨ anɨbu bɨ nɨŋeb nɨpe mɨdmagö yabɨƚ löm me, anɨg gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yad hagnabin rö gɨnabim u, kale bɨ nɨŋeb yad mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pen uri yad kalöp bɨ wög gɨ ñeb yad hagagabin; kalöp bɨ nɨŋeb yad hagabin. Bɨ wög gɨ ñeb gau, bɨ abad mɨdep kale, nan kale adö u nɨŋagpal. Pen yad Bapi manö nɨhön nɨhön yɨp hag ñöb u, kalöp waiö hag ñɨbin rö, kalöp bɨ nɨŋeb yad hagabin. ");
INSERT INTO kpw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kale yɨp udun a gɨmim gagpe; yad me kalöp udnam a gem kalöp udnö. Kale arammim, nan magö iru nöp, nan magö pör pör nöp mɨdeinab u pɨlnɨm a gem, kalöp wög anɨbu hag lɨbin. Kale anɨg geinabim u, Bapi nɨp hib yad hagmim, nan nɨhön nɨhön hag nɨŋnabim u, hagnabim rö kalöp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Yad kalöp manö kƚö hagem hagabin, pen pen mɨdmagö lɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas bɨ nɨpe gau kalɨp manö rɨmnap halö hagöm haga, “Nɨbi bɨ mɨnöŋ naböŋ iƚ i kalöp mulu kal nɨŋnaböl u, gasɨ kub anɨbu nɨŋagmim; Jisas nɨp nöd mulu kal nɨŋla rö, hanɨp gaböl, a gɨmim gasɨ u nɨŋmim. ");
INSERT INTO kpw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kale nɨbi bɨ mɨnöŋ naböŋ iƚ i yɨp nɨŋ udagpal gau rö mɨdaibep u, kalöp, nɨbi bɨ hon a göm, ud mɨdmagö lɨblap. Kalöp udagnö ñɨn u, mɨnöŋ naböŋ iƚ i gasɨ nɨŋbal rö gasɨ nɨŋmɨdim u pen kalöp udnabin a gem udnö bɨ yad mɨdpim. Anɨb u me, nɨbi bɨ mɨnöŋ naböŋ iƚ i kalöp mulu kal nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pen nöd kalöp manö hagnö u hauƚ gagmim: ‘Bɨ wög gɨ ñeb bɨ u bɨ kub, bɨ nɨp abad mɨdöp bɨ u bɨ pro, mɨdagöp.’ Anɨb u, nɨbi bɨ gau rɨmnap yɨp gɨ naij gɨpal rö, nɨbi bɨ gau rɨmnap kalöp u rö nöp gɨ naij gɨnaböl; pen nɨbi bɨ gau rɨmnap manö yad nɨŋ udöm hain gɨpal gau rö, nɨbi bɨ gau rɨmnap manö kale hag ñɨnabim u u rö nöp udöm hain gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kale bɨ yɨp yuö aunö u nɨp nɨŋagpal rö, kale bɨ yad mɨdpim u nɨŋöm, kalöp gɨ naij gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Yad apem kalɨp manö aij hagagbnep u, nan si nan naij göm manö kub yabɨƚ udagblap. Pen yad apem kalɨp hag ñɨ aij gɨnö rö, adan kale arep ap mɨdagöp; kale nan si nan naij gɨpal u hadö nɨŋbal, pen uri kale u rö nöp nan si nan naij nɨŋebir gaböl. ");
INSERT INTO kpw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pen yɨp mulu kal nɨŋbal rö, yɨp nöp wasö, Bapi nɨp abe mulu kal nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yad kalɨp aip mɨdem, nan gagep gau gagbnep u, nan si nan naij göm manö kub yabɨƚ udagblap. Pen yad apem nan gagep gau gɨnö yɨp mulu kal nɨŋbal rö, Bapi yad abe nɨp mulu kal nɨŋbal u me, manö kub anɨbu udnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Gɨpal anɨbu, Depid nɨpe God Manö au Juda kai lo hon a gɨpal manö rɨmnap kalɨ kƚiñ rɨköm haga rö nöp gɨpal. Nɨpe manö anɨbu kalɨ kƚiñ rɨköm haga, ‘Manö iƚ mɨdö wasö, yɨp yɨharɨŋ nöp mulu kal nɨŋbal,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pen yad am Bapi nɨp hagnö, nɨpe pen Bɨ Aɫ Ba Gep u nɨp yuö, apöm kalöp abad mɨdeinab. Ana manö nɨŋö nöp hag ñab u, yad bɨ aigale bɨ rö mɨdpin u, kalöp gasɨ ñö, nɨŋnabim. ");
INSERT INTO kpw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pen kale yad aip pör ajmɨdim u rö, kale abe arammim nɨbi bɨ gau kalɨp, yad aigale bɨ rö mɨdpin manö u hag ñɨbe araŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas manö hagöm haga, “Yad kalöp manö hagpin anɨbi, nɨŋ aij gɨmim me, hainö nɨhön gö, yɨp arö gɨmim ap lug pakagnabim, a gem hagpin. ");
INSERT INTO kpw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pen kalöp Juda magum gep ram gau hag höŋ yuöm, ‘Kuöyaŋ auagmim,’ a gɨnaböl. Pen anɨbu nöp wasö; hainö kalöp al pak lɨnɨg gɨnaböl u, anɨg gɨnabun God nɨp aij gɨnab a gɨ gasɨ nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Anɨg gɨnaböl u, Bapi hol apil nɨŋagpal rö, anɨg gɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yad kalöp nöd, anɨg göl anɨg göl gɨnab a gem manö hagajɨn anɨbu, hainö anɨg unbö rö nöp geinab u, Jisas hanɨp anɨg gɨnab a ga rö nöp gab a gɨmim nɨŋnabim a gem, kalöp manö anɨbi hagabin. “Pen nöd yad kale aip mɨdmɨdin rö, kalöp manö anɨbu nöd hagagnö. ");
INSERT INTO kpw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mɨñi Bɨ yɨp yuö aunö u ado gɨ arabin pen kale bɨ ap yɨp, ‘Gai arabön?’ ö göm, hag nɨŋagab. ");
INSERT INTO kpw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Manö yad anɨbi nɨŋmim, mɨdmagö kalöp u bɨg ñö, gasɨ mɨlö nɨŋabim. ");
INSERT INTO kpw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pen kalöp nɨŋö hagabin, yad areinabin u, kalöp aij gɨnab. Pen nɨhön: yad aragnabin u, Bɨ Aɫ Ba Gep u kalöp auagnab; pen yad areinabin u, yad nɨp hag yunö, kalöp aunab. ");
INSERT INTO kpw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nɨpe apöm, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau kalɨp gasɨ kƚö ñö, kale nan si nan naij göm gac halö mɨdpal iƚ u nɨŋöm, kale aige göm kamɨŋ aij mɨdeinaböl iƚ u nɨŋöm, God kalɨp manö kub hagnab iƚ u nɨŋöm, nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Anɨb u, yɨp nɨŋ udagpal rö, Bɨ Aɫ Ba Gep u kalɨp nan si nan naij gep iƚ u yɨjɨg göl hag ñöm, ‘Gac halö mɨdpim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yad am Bapi aip mɨdeinabin nɨŋöm kale yɨp nɨŋagnaböl rö, Bɨ Aɫ Ba Gep u nɨbi bɨ gau kalɨp kamɨŋ aij mɨdep iƚ u yɨjɨg göl hag ñöm, ‘Gac halö mɨdpim,’ a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pen nɨbi bɨ mɨnöŋ naböŋ iƚ i yɨp nɨŋ udagpal gau kalɨp kiŋ rö abad mɨdöp bɨ naij anɨbu, God nɨpe nɨp manö kub hadö haga rö, Bɨ Aɫ Ba Gep u, Seden nɨbi bɨ nɨpe gau u rö nöp manö kub nɨŋnaböl, a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Manö yad iru nöp mɨdöp pen manö anɨb gau mɨñi udmim rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pen Ana nɨpe aueinab u, God nɨpe bɨ aigale bɨ rö mɨdöp manö nɨŋö anɨbu magöŋhalö kalöp hag ñɨ aij gɨnab. Manö nɨpe adö rɨmnap ke udöm hagagnab; manö apdi nɨŋnab manö anɨbu nöp hag ñöl gɨ, hainö gɨnab manö adö u kalöp hag ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Manö yad u udöm, kalöp hag ñɨnab. Nɨpe anɨg gö, nɨbi bɨ gau mailö aij ke yad u nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pen Bapi nan nɨpe nɨhön nɨhön mɨdöp gau, magöŋhalö nan yad mɨdöp. Anɨb u me hagpin, ‘Ana nɨpe manö yad u udöm, kalöp hag ñɨnab,’ a gɨpin. ");
INSERT INTO kpw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Yöp magö ap mɨdöp, yɨp nɨŋagnabim; pen hainö yöp magö ap mɨdmim, yɨp kauyaŋ nɨŋnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas anɨg hageia, bɨ nɨpe gau kale ke nöp hagla, “Manö au hagöp, ‘Yöp magö ap mɨdöp, yɨp nɨŋagnabim; pen hainö yöp magö ap mɨdmim, yɨp kauyaŋ nɨŋnabim,’ a göp u, manö anɨbu iƚ nɨhön mɨdöp? Pen manö ap hagöp, ‘Yad Bapi arnabin,’ a göp u, nɨhön manö hagöp?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anɨg hagöm, kale pen hag nɨŋ pen hag nɨŋ göm hagla, “Manö au hagöp, ‘Yöp magö ap’ a göp u, nɨhön gɨnɨg göm hagöp? Hagöp u hon iƚ ap nɨŋagpun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Anɨg hagöm, Jisas nɨp hag nɨŋnɨg geila, nɨpe ke nɨŋöm haga, “‘Yöp magö ap mɨdöp, yɨp nɨŋagnabim; pen hainö yöp magö ap mɨdmim, yɨp kauyaŋ nɨŋnabim,’ a gɨpin manö u nɨŋmim me, pen pen hag nɨŋabim ar? ");
INSERT INTO kpw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yad kalöp nɨŋö yabɨƚ hagabin, nɨbi bɨ mɨnöŋ naböŋ iƚ i yɨp nɨŋ udagpal gau, nan kale ke gau nöp gasɨ nɨŋöm mɨñ mɨñ gɨnaböl; pen kale mög gö mɨɫöŋ göl gɨ mɨdeinabim. Mɨɫöŋ gɨ mɨdeinabim pen hainö kale kauyaŋ mɨñ mɨñ yabɨƚ gɨ mɨdeinabim. ");
INSERT INTO kpw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nɨbi ap ñɨ pai ñɨŋö nɨŋöl gɨ, ilön kub udöp, pen hainö ñɨ pai rɨk dap löm, magö u nöp nɨpe ñɨŋaŋ gɨsön ram mɨnöŋ aui auub u nɨŋöm, ilön mab u hauƚ göm, mɨñ mɨñ göl gɨ nöp mɨdeinab. ");
INSERT INTO kpw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kale unbö rö, mɨñi mɨdmagö ilön kale abe bɨg ñöl mɨdöp pen yɨp kauyaŋ nɨŋmim, mɨñ mɨñ yabɨƚ gɨnabim. Nɨbi bɨ rɨmnap apöm mɨñ mɨñ gep kale u udagnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ñɨn hain anɨbu, kale nan ap yɨp hag nɨŋagnabim. Kalöp nɨŋö yabɨƚ hagabin, Bapi nɨp hib yad hagmim hag nɨŋeinabim u, hagnabim rö gɨnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kale nöd Bapi nɨp hagmim, hib yad hagmim, nan ap hag nɨŋagpim. Pen mɨñi, hib yad hagmim hag nɨŋbe, hag nɨŋnabim rö nöp gɨnab nɨŋöm kale mɨñ mɨñ yabɨƚ gɨnabim. ");
INSERT INTO kpw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Bapi manö nɨpe adö u hagem, pör manö ba gau lem hagpin u pen mɨñi söl mɨdöp, manö anɨbu rö hagagnabin; waiö nöp hagnabin. ");
INSERT INTO kpw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ñɨn anɨbu auö, Bapi nɨp hag nɨŋnabim u, hib yad hagmim hag nɨŋnabim. Pen hib yad hag nɨŋnabim u, yad ke Bapi hag nɨŋnabim adö u hagagnabin, wasö; kale ke hib yad hagmim Bapi hag nɨŋnabim u, nɨŋnab. ");
INSERT INTO kpw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pen nɨhön: Bapi nöp yɨp yuö aunö u nɨŋ udmim, yɨp mɨdmagö lɨbim u me, nɨpe ke kalöp mɨdmagö löp. ");
INSERT INTO kpw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bapi aip mɨdul arö gem mɨnöŋ naböŋ iƚ i aunö; mɨñi mɨnöŋ naböŋ iƚ i arö gem kauyaŋ Bapi mɨdöp u amem aip mɨdeinabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jisas anɨg hageia, bɨ nɨpe gau hagla, “Mɨñi manö ba gau lɨmön hagagabön; waiö yabɨƚ hagabön. ");
INSERT INTO kpw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uri hon nɨŋbun, ne manö gau magöŋhalö hadö nɨŋban. Nɨbi bɨ rɨmnap manö hag nɨŋeb kale mɨdeinab u, nöp hag nɨŋagpal magö u, ne ke nɨŋmön kalɨp hag ñɨnabön. Gɨpan anɨbu hon nɨŋbun, ne God aip mɨdmön auna,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Anɨg hageila, Jisas haga, “Anɨb u, ‘Hon uri nɨŋ udpun,’ a gɨ gasɨ nɨŋbim ar? ");
INSERT INTO kpw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Söl auab — pen mɨñi hadö auöp I — yɨp arö gɨmim kale ram ke ke arbe, yad ke halö mɨdeinabin. Pen yad ke halö mɨdageinabin; Bapi mɨdöp rö, aip mɨdeinabul. ");
INSERT INTO kpw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Pen kalöp manö hag ñajɨn anɨbi, yad aŋ daŋ nöp mɨdmim, agamɨj mɨd aij gɨmim a gem hag ñajɨn. Mɨnöŋ naböŋ iƚ i mɨdpim rö, kalöp mɨŋör ñɨnaböl. Pen gasɨ halö mɨdaimim, nan nɨhön nɨhön mɨnöŋ naböŋ iƚ i kalöp gɨnab u, yad kƚö anɨbu magöŋhalö ud raƚa mɨgan yad u hadö lɨbin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas manö anɨbu hag pɨs göm, kumi kabö laŋ nɨŋöm haga, “Bapi. Ñɨn yɨp hagna u mɨñi auöp. Anɨb u, ne gɨmön, nɨbi bɨ gau nɨŋnaböl, yad Ñɨ ne mailö aij unbö ke halö mɨdpin; pen yad Ñɨ ne gɨnö, kale nɨŋnaböl, ne Bapi mailö aij unbö ke halö mɨdpan. ");
INSERT INTO kpw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nɨhön gɨnɨg: yɨp ke hagna rö, nɨbi bɨ gau gau magöŋhalö abad mɨdem, nɨbi bɨ yɨp hag lɨna gau kalɨp udem, kamɨŋ pör mɨdep magö u kalöp ñɨnabin. ");
INSERT INTO kpw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nɨbi bɨ kale, ne God nɨŋö añɨ nöp mɨdpan u nɨŋöm, yɨp Jisas Krais yuna u nɨŋnaböl nɨbi bɨ gau, pör pör nöp kamɨŋ mɨdeinaböl. ");
INSERT INTO kpw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wög yɨp ram mɨnöŋ iƚ i hagna u, gɨ damem gɨ hakpin u me, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau kale nɨŋbal, ne Bɨ mailö aij unbö ke mɨdpan. ");
INSERT INTO kpw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pen Bapi. Mɨñi ne gɨmön, nöd ram mɨnöŋ gɨ laglo ñɨn u, hol apɨl mailö aij unbö ke halö mɨdailo u rö, uri kuöyaŋ anɨb unbö rö nöp mɨdeinabul. ");
INSERT INTO kpw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nɨbi bɨ mɨnöŋ naböŋ iƚ i gau rɨmnap yɨp ñɨna. Nɨbi bɨ anɨb gau, kale nɨbi bɨ ne mɨdeila u pen yɨp ñɨna. Ne aigale bɨ rö mɨdpan u kalɨp hag ñɨnö. Yad manö aij ne kalɨp hag ñɨnö, kale nɨŋ udöm, hagöp rö nöp gɨpal. ");
INSERT INTO kpw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Uri kale hadö nɨŋbal, yad nan nɨhön gɨpin gau, yad ke gagpin. Kale nɨŋbal nan nɨhön ne yɨp ñɨban u nöp udem kalɨp ñɨbin. ");
INSERT INTO kpw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Manö nɨhön nɨhön yɨp hagna u, kalɨp hag ñɨnö nɨŋ udpal. Anɨb u, yad nöd ne aip mɨdmɨdul, ne yɨp hag yuö mɨnöŋ naböŋ iƚ i aunö manö u, nɨŋ udpal. ");
INSERT INTO kpw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Kalɨp nöp sabe gabin. Nɨbi bɨ mɨnöŋ naböŋ iƚ i nöp nɨŋlö mulu lugöp gau sabe gagabin. Nɨbi bɨ yɨp hagna gau nöp, nɨbi bɨ ne mɨdpal rö, nöp sabe gabin. ");
INSERT INTO kpw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nɨbi bɨ yad gau ke, nɨbi bɨ ne gau ke wasö, nɨbi bɨ hol apɨl aipen mɨdpal me. Kale gɨpal anɨbu nɨŋöm, nɨbi bɨ rɨmnap gau nɨŋbal, yad bɨ mailö aij ke halö mɨdpin. ");
INSERT INTO kpw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pen uri yad mɨdpan u nɨnabin rö, kale ke halö mɨdeinaböl. Bapi Uɫ! Ne kƚö ke halö mɨdpan rö, yɨp hagaina yad u rö nöp mɨdpin. Hib kƚö ke yabɨƚ ne u udmön, kalɨp rarö raumön, hol apɨl jɨm ñöl mɨdpul rö, kale anɨb unbö rö nöp jɨm ñöl mɨdaiöl. ");
INSERT INTO kpw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yad kalɨp aip mɨdem, hib ne kƚö anɨbu yɨp ñɨna u udem, kalɨp rarö rauem abad mɨd aij gɨpin. Bɨ ap ur gagöp. God Manö kalɨ kƚiñ rɨköm, bɨ ap böŋ nöp ap lug paköm ilön kub udnab a gɨla rö, bɨ anɨbu nöp ur ga. Ga anɨbu, God Manö nöd kalɨ kƚiñ rɨkla rö nöp ga. ");
INSERT INTO kpw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Pen ne mɨdpan au nɨnɨg gabin rö, mɨñi uƚep magö ap mɨnöŋ naböŋ iƚ i mɨdnabin u, kale nɨŋ mɨdlö nɨŋöl gɨ, nöp manö anɨbi hagabin. Anɨb u, yad mɨñ mɨñ yabɨƚ gabin rö, kale u rö nöp mɨñ mɨñ yabɨƚ göl. ");
INSERT INTO kpw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Manö aij ne u kalɨp hag ñɨnö nɨŋ udpal rö, nɨbi bɨ mɨnöŋ naböŋ iƚ i gau kalɨp mulu kal nɨŋbal. Yad nɨbi bɨ mɨnöŋ naböŋ iƚ i gasɨ nɨŋbal rö gasɨ nɨŋagpin rö, kale u rö nöp nɨbi bɨ mɨnöŋ naböŋ iƚ i gasɨ nɨŋbal rö gasɨ nɨŋagpal. Anɨb u me, nɨbi bɨ mɨnöŋ naböŋ iƚ i kalɨp mulu kal nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pen kalɨp mɨnöŋ naböŋ iƚ i nɨbö dam ne mɨdpan au ud aru, a gem hagagabin; kalɨp mɨnöŋ naböŋ iƚ i abad mɨdaimön, Seden kalɨp gɨ naij gagaŋ, a gem hagabin. ");
INSERT INTO kpw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yad nɨbi bɨ mɨnöŋ naböŋ iƚ i gasɨ nɨŋbal rö gasɨ nɨŋagpin; kale u rö nöp nɨbi bɨ mɨnöŋ naböŋ iƚ i gasɨ nɨŋbal rö gasɨ nɨŋagpal. ");
INSERT INTO kpw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Manö ne u, manö nɨŋö nöp anɨbu, kalɨp hag ñɨmön, kale uɫ mɨdnaböl. ");
INSERT INTO kpw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne yɨp nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal aŋ gau yuna rö, yad kalɨp u rö nöp nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal aŋ gau yubin. ");
INSERT INTO kpw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wög nɨhön nɨhön yɨp ñɨban u, yad gɨ haknabin. Yad anɨg gabin u, bɨ yad gau kale yɨp nɨŋöm, wög kale nɨhön nɨhön mɨdeinab u, kale u rö nöp gɨ haklaŋ a gem, gabin. ");
INSERT INTO kpw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Yad nöp sabe gabin i, bɨ uri hagajɨn kalɨp nöp sabe gagabin; kale manö hag ñɨlö, nɨbi bɨ gau manö kale nɨŋ udöm, yɨp nɨŋ udnaböl gau, kalɨp abe sabe gabin. ");
INSERT INTO kpw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bapi, ne yad aŋ daŋ mɨdpan, yad nöp aŋ daŋ mɨdpin. Hol apɨl jɨm ñöl mɨdpul rö, kale magöŋhalö anɨb unbö rö nöp hol apɨl aip jɨm ñöl mɨdaiöl. Anɨg gɨnab u, ne nöp yɨp hag yuö aunö u, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal gau nɨŋ udöl. ");
INSERT INTO kpw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hol apɨl jɨm ñöl mɨdpul rö, kale u rö nöp jɨm ñöl mɨdaiöl, a gem, ne mailö aij unbö ke yɨp ñɨna u, yad pen kalɨp abe u rö nöp ñɨbin. ");
INSERT INTO kpw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Anɨb u, ne yad aŋ daŋ mɨdpan rö, yad kalɨp aŋ daŋ mɨdnö me, kale jɨm ñöl yabɨƚ mɨdaiöl. Anɨg gö me, nɨbi bɨ mɨnöŋ naböŋ iƚ i gau nɨŋnaböl, ne nöp yɨp yuö aunö nɨŋöm ne yɨp mɨdmagö lɨban rö, kalɨp u rö nöp mɨdmagö lɨban. ");
INSERT INTO kpw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bapi! Yɨp aij göp u, nɨbi bɨ yɨp ñɨban gau, am yad mɨdeinabin au aip mɨdöm, mɨnöŋ naböŋ gɨ laglo ñɨn u, yɨp mɨdmagö lɨmön mailö aij unbö ke yɨp ñɨna u nɨŋöl. ");
INSERT INTO kpw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Bapi! Ne me bɨ asɨŋ mɨdagöp! Nɨbi bɨ mɨnöŋ naböŋ iƚ i gau kale nöp nɨŋagpal. Pen yad nöp nɨŋbin. Nɨbi bɨ yad gai i ne nöp yɨp yuö aunö u, nɨŋbal. ");
INSERT INTO kpw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne aigale bɨ rö mɨdpan u, yad kalɨp hag ñɨnö. Pen hainö u rö nöp, ne aigale bɨ rö mɨdpan u yad kalɨp hag ñɨ aij gɨnabin. Anɨg gem, yad ke kalɨp aŋ daŋ mɨdnö, ne yɨp mɨdmagö lɨban rö nɨŋ aij göm, kale u rö nöp pen pen mɨdmagö löl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas Nap nɨp sabe gɨ pɨs göm, bɨ nɨpe gau aip ñɨg pro Kidron juöm, böŋ lödaŋ amöm, mab olip wög adɨŋ u arla. ");
INSERT INTO kpw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mab olip wög adɨŋ anɨbu Jisas bɨ nɨpe gau aip pör am magum gɨmɨdal rö, Judas bɨ Jisas nɨp mumug nɨŋnɨg geia u, mɨgan anɨbu nɨŋ aij ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Perisi bɨ gau abe, bɨ God nɨp nan sabe gep bɨ kub gau abe, Judas nɨp hageila, nɨpe am ami bɨ rɨmnap uɫ göm, God sabe gep ram polisman rɨmnap uɫ göm, dam Jisas mɨdeia au amjaka. Kale pen pen alep nan rɨmnap udöm, hapö rɨmnap ƚam rɨmnap lau udöm, aueila. ");
INSERT INTO kpw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas nɨp nan nɨhön gɨnɨg ga u nɨŋa u me, aueila u amöm haga, “An nɨp uƚhai nɨŋ ajabim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hageia hagla, “Jisas, bɨ Nasared nɨbö u,” a gɨla. Hageila, Jisas haga, “Bɨ anɨbu me yad i,” a ga. Pen magö anɨbu, bɨ nɨp mumug nɨŋa u, Judas, kale aip anɨb au mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pen Jisas, “Bɨ anɨbu me yad i,” a gö, kale jöl adö ƚɨƚɨ gɨ amöm gɨ dam pak la. ");
INSERT INTO kpw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisas pen kalɨp kauyaŋ haga, “An nɨp uƚhai nɨŋ ajabim?” ö ga. Hageia hagla, “Jisas, bɨ Nasared nɨbö u,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hageila, Jisas haga, “Kalöp mɨdö nöp hagpin, ‘Bɨ anɨbu me yad i.’ Yɨp uƚhai nɨŋ ajpim rö, bɨ gai i kalɨp arö gɨpe aröl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ga anɨbu, Jisas nöd Nap nɨp haga rö nöp ga. Nɨpe Nap nɨp haga, “Bapi. Bɨ yɨp ñɨna gau, añɨ ap ur gagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pen magö anɨbu nöp, Saimon Pida ru mɨlö kɨd daua u ɫɨp gɨ udöm, bɨ ap nɨp rɨmɨd yɨjɨg lau böŋ nöp rɨb gɨ dö gɨ yua. Bɨ anɨbu hib nɨpe Malkas. Nɨpe God nɨp nan sabe gep bɨ kub yabɨƚ u nɨp bɨ wög gɨ ñeb nɨpe u mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pida anɨg geia, Jisas haga, “Ru mɨlö kɨd udpan kuöyaŋ lö araŋ! Ne Bapi ñɨg asɨ yɨp ñöb u ñɨŋagnabin a gɨmön nɨŋban ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas anɨg hagö nɨŋöl gɨ, ami bɨ gau abe, God sabe gep ram polisman gau abe, Jisas nɨp ud sɨsɨ löm, nagɨ lɨ pɨdöŋ göm, ");
INSERT INTO kpw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","kale nöd Jisas dam Anas mɨdeia au arla. Bɨ Anas anɨbu, Kaiapas nɨma nɨpe. Kaiapas me, mɨ añɨ anɨbu, God nɨp nan sabe gep bɨ kub yabɨƚ wög u hag lɨlö, wög gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas nɨpe me nöd Juda bɨ manö ud asɨkep kalɨp haga, “Bɨ añɨ ap umö hon magöŋhalö kamɨŋ arnabun u aij,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pen Jisas nɨp anɨg göm, dam Anas ram u areila nɨŋöm, Saimon Pida aip, yad Jon aip, holmɨŋ hain hain arlo. Bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u yɨp nɨŋ aij ga rö, yad amem böŋ nöp ram nɨpe manö kub hagmɨdal waryö raul yaŋ arnö; ");
INSERT INTO kpw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pen Pida nɨpe höŋ löyaŋ adö mɨdeia. Yad pen ado gɨ apem, nɨbi ajöŋ iƚ abad mɨdeia u nɨp hagem, Pida nɨp uɫ gɨ waryö raul yaŋ arlo. ");
INSERT INTO kpw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pen nɨbi ajöŋ iƚ abad mɨdeia u, Pida nɨp haga, “Ne u rö nöp Jisas bɨ nɨpe ap ar?” a ga. Hageia, Pida haga, “Yad wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pen Kaiapas nɨp wög gɨ ñeila bɨ gau abe, God sabe gep ram polisman gau abe, kalɨp yɨgön gö, mab bɨc run magö aŋ anɨb au pɨböŋ mɨdeia, uraköl mali mɨdeila. Pida nɨp u rö nöp yɨgön gö, ap aŋ anɨb au se göl, kalɨp aip mab mali mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pen Anas, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ nöd mɨdmɨdöp u, Jisas nɨp hag nɨŋa, “Nɨbi bɨ ne nɨbi bɨ an? Ne manö nɨhön nɨhön nɨbi bɨ ne hag ñɨban?” a gɨ nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hageia, Jisas pen haga, “Yad manö rɨmnap pi gem hag ñagnö; bɨ kale gau nɨŋ mɨdlö nɨŋöl gɨ, Juda magum gep ram gau abe, God sabe gep ram u abe, pör waiö hag ñɨbin. ");
INSERT INTO kpw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Anɨb u, nɨhön gɨnɨg yɨp manö hag nɨŋabön? Nɨbi bɨ manö hagnö nɨŋ mɨdeila rɨmnap daumim hag nɨŋmim. Manö nɨhön nɨhön hagnö u nɨŋbal me,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas anɨg hageia, God sabe gep ram abad mɨdmɨdöp polisman ap, nɨp alaun u paköm haga, “Nɨhön gɨnɨg bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u nɨp manö anɨbu rö hagabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hageia, Jisas haga, “Yad manö piral ap hagpin a gɨmön, manö piral hagpin anɨbu nɨbi bɨ gai i kalɨp waiö hag ñɨmön. Pen manö nɨŋö hagpin u, ne nɨhön gɨnɨg yɨp pakajan?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jisas nɨp nagɨ lɨ rɨbɨk gɨla rö mɨdö nɨŋöl gɨ, Anas hagö kale Jisas nɨp dam, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ hain nɨbö u, Kaiapas, ud arla. ");
INSERT INTO kpw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pen Pida nɨpe anɨg uraköl gɨ mɨdöm mab mali mɨdö nɨŋöl gɨ, bɨ rɨmnap nɨp hagla, “Bɨ anɨbu bɨ ap me ne i ar?” a gɨla. Hageila, Pida hag haluöm haga, “Yad wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pen bɨ au Pida rɨmɨd rɨb gɨ dö ga u, bɨ rɨdɨk lö lö nɨpe ap God nɨp nan sabe gep bɨ kub u nɨp wög gɨ mɨdeia. Nɨpe apöm, Pida nɨp haga, “Yad nöp nɨŋbin, ne bɨ anɨbu aip mab olip wög adɨŋ au mɨdajan ar?” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Hageia Pida kauyaŋ hag haluöm haga, “Yad wasö,” ga. Anɨg hagö nɨŋöl gɨ, adɨŋ kɨƚakɨƚ wɨñ ala. ");
INSERT INTO kpw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ram rɨk dam lö nɨŋöl gɨ, Juda kai kale Jisas nɨp Kaiapas ram anɨbu nɨbö dam Rom gapman bɨ kub Pailod ram kub u arla. Juda kai hagla, “Hon Rom bɨ ram raul i arno, hanɨp asɨŋ uɫ gɨnab nɨŋöm hon Pasopa nan ñɨŋun rö lagnab,” a göm, höŋ gɨyaŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Anɨb u, Pailod höŋ amöm haga, “Bɨ i nɨp nɨhön manö nɨŋmim daubim?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hageia, kale hagla, “Nɨpe nan naij ap gagböp, nöp anɨg dauagbnop,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hageila, Pailod haga, “Kale dam lo kale adö u ke hagöp rö nɨŋmim, manö kub hagim,” a ga. Hageia, Juda kai pen hagla, “Hon nɨbi bɨ gau kalɨp manö kub hagun, al pak lɨno umöl, lo adö u mɨdagöp. Rom gapman gau hanɨp wasö gɨpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juda kai anɨg gɨla u, Jisas yɨp aigöl gɨlö umnabin, a göm, haga rö nöp gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pen Juda kai anɨg hageila, Pailod kauyaŋ ado gɨ ram raul yaŋ amöm, Jisas auaŋ a gö, aueia nɨp haga, “Ne Juda kai kiŋ kale u aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hageia, Jisas haga, “Manö yɨp hag nɨŋabön u, maj mɨgan ne u ke hagabön aka nɨbi bɨ rɨmnap maj mɨgan kale u udmön hagabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hageia, Pailod haga, “Yad Juda bɨ wasö. Juda kai ne gau nöp, bɨ God nɨp nan sabe gep bɨ kub ne gau nöp me, nöp dapöm ñɨmagö yad ñɨbal. Ne nan nɨhön gaina anɨg gɨpal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hageia, Jisas haga, “Yad nɨbi bɨ udem abad mɨdeinabin u, kiŋ mɨnöŋ naböŋ iƚ i mɨdpal rö, mɨdageinabin. Yad mɨnöŋ naböŋ iƚ i kiŋ mɨdnɨg gaibnep, Juda nɨbi bɨ gau yɨp nagɨ lun, a gɨlö, nɨbi bɨ yad gau uraköm kale aip pen pen alblap. Pen yad nɨbi bɨ udem abad mɨdeinabin nagɨ u ke mɨdöp; mɨnöŋ naböŋ iƚ i rö wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Anɨg hageia, Pailod haga, “Anɨb u, ne kiŋ ap aka?” ga. Hageia, Jisas haga, “Me ne hagpan me u. Adö anɨbu nöp me, Bapi God gö, yɨp mɨnöŋ naböŋ iƚ i yag daulö, majö gem, manö nɨŋö yuö yabɨƚ u hag ñɨbin. Nɨbi bɨ manö nɨŋö yabɨƚ udun, a gɨ gasɨ nɨŋbal gau, manö yad u udpal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Anɨg hageia, Pailod haga, “Pen manö gau nɨbö gau nɨbö ke ke iru nöp mɨdöp u, hon aigöl gun manö nɨŋö yabɨƚ me u, a gun nɨŋun?” ö ga. Pailod manö anɨbu hagöm, kauyaŋ höŋ amöm, Juda kai kalɨp haga, “Yad nɨpe nan naij ap gajɨp nɨŋagpin. ");
INSERT INTO kpw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pen hon Rom gapman, mɨ u mɨ u, Pasopa ñɨn kub u auajɨp, bɨ nagɨman kale ap yɨharɨŋ hubɨk yubun. Anɨb u, Juda kai kiŋ kale u, yɨharɨŋ hubɨk yunö arnɨm aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hageia, meg mɨgan dap ranöm hagla, “Nɨp wasö! Hon Barabas nɨp hubɨk yumön!” a gɨla. Bɨ Barabas anɨbu, nɨbi bɨ gau wañ wañ gö gapman kai kalɨp aip pen pen alla. ");
INSERT INTO kpw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Anɨg hageila, Pailod ami bɨ nɨpe gau hagö, Jisas nɨp nagɨ udöm pak ado malo gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Anɨg göl paköm, nan kalɨ kalɨ halö rɨmnap udöm, kiŋ lɨbal rö usajɨl bad ap göm, Jisas nɨp rol gɨ ñöm, waƚɨj mu mɨlö bö ap lɨ ñöm, ");
INSERT INTO kpw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nɨp kuöyaŋ amöm kuöyaŋ amöm hagla, “Ne Juda kai kiŋ kale, ne pör nöp mɨdaimön!” a gɨla. Anɨg hagöl gɨ, nɨp mulu maj mɨgan pakla. ");
INSERT INTO kpw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pen Pailod kuöyaŋ höŋ amöm, Juda nɨbi bɨ kalɨp haga, “Nɨŋim! Yad Jisas nɨp höŋ i daunabin nɨŋöm kale nɨŋnabim, yad nɨpe nan naij göp iƚ ap uƚhai nɨŋagpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pen Jisas nɨp usajɨl kalɨ kalɨ halö bad u rol gɨ ñöm, waƚɨj mu mɨlö bö adö lɨ ñɨla u halö auö nɨŋöl gɨ, Pailod kalɨp haga, “Nɨp nɨŋim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Anɨg hageia, bɨ God nɨp nan sabe gep bɨ kub gau abe, God sabe gep ram polisman gau abe, Jisas nɨp nɨŋöm manö bƚaƚö göm hagla, “Nɨp mab ba laŋ al pak lɨmim! Nɨp mab ba laŋ al pak lɨmim!” a gɨla. Anɨg hageila, Pailod haga, “Kale ke nɨp dammim, mab ba laŋ al pak lɨmim. Yad nan naij göp iƚ ap uƚhai nɨŋagpin!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hageia, Juda kai hagla, “Nɨpe, ‘Yad God Ñɨ nɨpe,’ a ga u, lo hon ap hagöp, ‘Umnɨm,’ a göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Anɨg hageila, Pailod nɨŋöm, rapɨn pɨñɨŋ göm, ");
INSERT INTO kpw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kuöyaŋ ram raul yaŋ amöm, Jisas nɨp hag nɨŋöm haga, “Ne ram mɨnöŋ gai nɨbö?” ö ga. Hageia, Jisas manö ap pen hagaga. ");
INSERT INTO kpw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailod haga, “Ne yɨp manö hagagnabön ar? Ne nɨŋban. Yad nöp abad mɨdpin. Anɨb u, nöp hubɨk yunɨg hubɨk yunabin; pen nöp mab ba laŋ al pak löl, a gɨnö, al pak lɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hageia, Jisas haga, “Pen ne yɨp abad mɨdpan u, ne ke wasö, God nöp hagö abad mɨdpan. Anɨb u, yɨp gɨ naij gabön marö u, ne nöp udagnabön; bɨ yɨp udöm nöp ñöb u, marö kub yabɨƚ u udnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jisas anɨg hageia, Pailod nɨp yɨharɨŋ hag yuɨn, a göm, gasɨ nɨŋa u pen Juda kai nɨp bƚaƚö gɨ hagöm hagla, “Ne Jisas nɨp hubɨk yunabön u, Rom bɨ kub Sisa bɨ nɨŋeb nɨpe mɨdageinabön. Bɨ, yad kiŋ mɨdpin, a gɨpal gau, Sisa aip pen pen al lun, a göm me, manö anɨbu rö hagpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Anɨg hageila, Pailod manö anɨbu nɨŋöm, am Jisas nɨp uɫ gɨ höŋ amöm, nɨpe am bɨ manö ud asɨkep sea adö au laŋ gɨla adö u asɨka. Ka asɨka anɨbu, “Kabö Adan” a gɨmɨdal. Pen Arameik manö löm, “Gabada” a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pen ñɨn anɨbu, Juda nɨbi bɨ Pasopa nan kale magum gep ñɨn. Sɨdö aŋ kub laŋ magö u, Pailod kalɨp haga, “Kiŋ kale me i!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hageia, meg magö dap ranöm hagla, “Nɨp al pak lɨ! Nɨp mab ba laŋ al pak lɨ!” a gɨla. Hageila, Pailod haga, “Kiŋ kale anɨbi mab ba laŋ al pak lɨnam?” ö ga. Hageia, bɨ God nɨp nan sabe gep bɨ kub gau hagla, “Kiŋ hon ap mɨdagöp; Rom bɨ kub Sisa nöp mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pen anɨg gɨ hag damöm, Pailod manö kalɨp u udöm, ami bɨ gau kalɨp haga, “Jisas nɨp dam mab ba laŋ al pak lɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pen nɨp al pak lɨnɨg gɨla mab u, Jisas nɨp ñɨlö, nɨpe dam “Wip Nabɨc Cög Ij” a gɨpal dum u apjaka. Dum anɨbu, Arameik manö löm “Golgoda” a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jisas nɨp mab kros cɨpɨƚ pak löm, bɨ mɨhöp, ap böŋ lap, ap böŋ lap, al pak lɨla. Jisas aŋ au mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pen Pailod hagö, bɨ nɨpe gau mab po ap udöm kalɨ kƚiñ rɨköm, Jisas nɨp al pak lɨla mab ba nabɨc au gɨdaŋ dɨƚam gɨla. Kalɨ kƚiñ rɨkla manö u: ");
INSERT INTO kpw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Manö añɨ adö anɨbu nöp, Arameik manö kalɨ kƚiñ rɨköm, Ladin manö kalɨ kƚiñ rɨköm, Grik manö kalɨ kƚiñ rɨköm gɨla me, Jerusalem söl anɨb au mɨdeia rö, Juda nɨbi bɨ iru nöp amgö lɨ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pen God nɨp nan sabe gep bɨ kub gau am Pailod nɨp hagla, “Manö kalɨ kƚiñ rɨkpan u kabö rö gagöp. ‘Juda kai kiŋ kale’ manö u mɨdagainɨm; yɨharɨŋ hagmön, ‘Nɨpe hagöp, “Yad Juda kai kiŋ kale mɨdpin,” a göp,’ a gɨmön, manö anɨbu nöp kalɨ kƚiñ rɨkmön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Anɨg hageila pen Pailod pen haga, “Yad manö nɨhön kalɨ kƚiñ rɨkpin u, anɨg göl nöp mɨdnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pen Jisas nɨp mab ba laŋ al pak löm, ami bɨ mɨhau mɨhau Jisas waƚɨj nɨpe gau balu ke ke udöm, waƚɨj mɨlö bö göm al dör gagla u, u rö nöp balu udnɨg hagla, ");
INSERT INTO kpw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Pabu gagun! Yɨharɨŋ sadu rö gun, bɨ an udnɨm u, nɨpe udnab,” a gɨla. Gɨla anɨbu, God hadame nöp nɨbi bɨ gau kalɨp gasɨ ñö, God Manö u kalɨ kƚiñ rɨköm, hainö anɨg gɨnaböl, a gɨla u me, hainö anɨg unbö rö nöp gɨla. Manö anɨbu kalɨ kƚiñ rɨköm hagla, “Waƚɨj yad u balu ke ke udöm, waƚɨj mɨlö bö yad u, sadu rö gun udun, a gɨla,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pen ñɨn anɨbu, Jisas nɨme u, nɨmañ u, Klopas nɨbin Maria u, Maria Magdala u, ap Jisas nɨp al pak lɨla goƚ söl anɨb au mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yad Jon, Jisas yɨp mɨdmagö lɨmɨdöp bɨ u, u rö nöp ap söl anɨb au mɨdainö u me, Jisas yɨp nɨŋöm, nɨme Maria nɨp haga, “Nɨbi me, ñɨ ne me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Anɨg hagöm, nɨpe pen nɨme Maria nɨŋöm yɨp haga, “Name ne me u,” a ga. Anɨg hagö nɨŋöl gɨ, ñɨn anɨbu, Jisas nɨme nɨp uɫ gɨ ram yad u damem, aip mɨdmɨdul. ");
INSERT INTO kpw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas nɨŋa, wög adö nɨpe u magöŋhalö gɨ haka u me, God Manö haga u nɨŋö lɨnɨm a göm haga, “Yɨp rugu mɨƚep göp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pen ñɨg wain asɨ barol ap dap anɨb au lɨlö mɨdeia u me, ami bɨ ap, nan hain bad ap udöm, wain asɨ anɨbu löm, ud mab hisop lö adɨŋ u abös alöm, dap ranöm Jisas maj hañ adö nɨp u la. ");
INSERT INTO kpw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas ñɨg wain asɨ anɨbu ñɨŋöm haga, “Naböŋ juöp,” a göm, ubör yɨhöŋ göm, ana nɨpe ña. ");
INSERT INTO kpw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pen Juda bɨ kub gau, kagoƚ ñɨn u dugo magö u hadö auajɨp nɨŋöm hagla, “Rol God nɨp sabe gep ñɨn hon u, wip gau mab ba laŋ mɨdagaiöl,” a göm, am Pailod nɨp hagla, “Bɨ mab ba laŋ al pak lɨbal gau, ami bɨ gau ma kalɨp gau pa jö gɨlö, yɨŋɨd umlö, ud mɨnöŋ yaŋ löl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hageila, Pailod ami bɨ gau kalɨp hagö, am bɨ Jisas aip al pak lɨla mɨhau, ma kalɨp gau pa jö gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pen Jisas ma nɨp u pa jö gun a göm nɨŋla, nɨpe hadö uma. Anɨg ga u me, ma nɨpe u pa jö gagla. ");
INSERT INTO kpw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pen ami bɨ ap, waƚab ap udöm, Jisas nɨp rɨglöm adɨŋ au bɨnɨŋ gö, adɨŋ hagape halö, ñɨg halö luga. ");
INSERT INTO kpw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Anɨb u, kale nɨbi bɨ manö kalɨ kƚiñ rɨkabin anɨbi nɨŋnabim gau abe Jisas nɨp nɨŋ udmim, a gem, yad Jon, Jisas nɨp ga u amgö yad ke nɨŋbin rö, kalöp manö nɨŋö yabɨƚ anɨbi hagem kalɨ kƚiñ rɨkabin. ");
INSERT INTO kpw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pen ga anɨbu, God hadame nöp nɨbi bɨ gau kalɨp gasɨ ñö, God Manö u kalɨ kƚiñ rɨköm, hainö anɨg gɨnaböl, a gɨla u me, hainö anɨg unbö rö nöp gɨla. God Manö u kalɨ kƚiñ rɨköm hagla, “Le nɨpe u, ap pa jö gagnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pen manö ap hagla, “Bɨ nɨp bɨnɨŋ gajal u nɨp nɨŋnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bɨ Arimadia daun nɨbö ap, Jisas manö nɨpe nɨŋ uda u pen, Juda bɨ kub kalɨp pɨñɨŋ göm, Jisas nɨp nɨŋ udpin, a göm, waiö hagagmɨdöp. Bɨ anɨbu hib nɨpe Josep. Nɨpe Jisas nɨp dam rɨgöl gɨnam, a göm, am Pailod nɨp hag nɨŋö, yau a gö, ud ara. ");
INSERT INTO kpw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas nɨpe Josep aip arlö. Nikodimas, bɨ au nöd am Jisas nɨp sɨbön yaŋ nɨŋa bɨ u. Nikodimas nan haƚɨŋ aij auep iru nöp, kilo unbö ñɨnjuöl ado gɨ da unbö ajɨp böŋ daŋ (35) rö, udöm ara. Nan haƚɨŋ aij auep anɨbu, mab mö cɨl u abe, mab alos cɨl u abe udöm gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pen kale mɨhöp am wip he u ud asɨk dap lugmil, Juda nɨbi bɨ gɨmɨdal rö, mab cɨl ud ara u, wip he gau anöŋ lɨ ñɨmil, linɨn ud waƚɨj rud gɨla pro mɨlö u udmil, wam wam gɨlö. ");
INSERT INTO kpw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas mab ba laŋ al pak lɨla ka anɨb söl au wög adɨŋ ap mɨdeia. Wög adɨŋ anɨbu aŋ au kabö mɨgan gɨsön nöp ƚuöm, wip rɨgöl gagla ap mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juda kai God nɨp sabe gep ñɨn kale u söl söl ga rö, yɨŋɨd rɨgöl gul a gɨmil, kabö mɨgan yöp söl anɨb au rɨgöl gɨlö. ");
INSERT INTO kpw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sade ñɨn u, ram rɨknɨg gö nɨŋöl gɨ, Maria Magdala wip rɨgöl gɨla mɨgan amöm nɨŋa, kabö kub wip rɨgöl pɨƚ gɨla u, ƚɨƚɨ gɨ am goƚ au mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nɨpe nɨŋöm, kauyaŋ gɨ dö gɨ ap Saimon Pida hol mɨhöŋ mɨdailo u apöm haga, “Bɨ Kub u nɨp agamɨj ud arbal; pen dap lɨbal au nɨŋagpun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Anɨg hageia, Pida hol mɨhöŋ nɨŋnɨg gɨ dö yabɨƚ gul hadlo. Yad nöd amjakem, ");
INSERT INTO kpw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","höŋ adö löyaŋ nöp mɨdem, kabö mɨgan jɨŋ sɨpsɨp nɨŋnö waƚɨj bad gau nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Pen Saimon Pida nɨpe hain apöm, kabö mɨgan u hiɨkɨd amöm nɨŋa, Jisas nɨp waƚɨj wam halö yula gau hubɨk gaga; rɨgöl gɨla rö nöp mɨdeia. Pen waƚɨj nabɨc jɨŋ pɨral wam gɨgabö gɨla u, u rö nöp hubɨkaga; pɨral gɨgabö gɨla rö nöp asɨk gɨ ke au mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yad nöd wip rɨgöl gɨla au apjaknö pen uri yad u rö nöp kabö mɨgan hiɨkɨd amem nɨŋnö, waƚɨj gau wam halula rö mɨdeia u me, anɨbu Jisas uraköp, a gem nɨŋ udnö. ");
INSERT INTO kpw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pen ñɨn anɨbu, God Manö kalɨ kƚiñ rɨköm, Jisas umöm uraknɨm, a gɨla manö u, hol nɨŋ aij gaglo. ");
INSERT INTO kpw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Anɨg nɨŋul ado gɨ ram arlo. ");
INSERT INTO kpw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Pen Maria wip rɨgöl gɨla rɨgöl mɨgan anɨbu höŋ adö au uraköl mɨdöm mɨɫöŋ göl gɨ mɨdeia. Mɨɫöŋ göl gɨ mɨdöl gɨ, jöl magö dudu gɨ kabö mɨgan jɨŋ sɨpsɨp nɨŋa, ejol waƚɨj rud lɨlö mɨhau, Jisas wip he nöd mɨdeia ka anɨbu asɨk mɨdöl gɨ, ap nabɨc adɨŋ jɨŋ, ap ma adɨŋ mɨŋ, mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ejol anɨb mɨhau Maria nɨp haglö, “Nɨhön gɨnɨg mɨɫöŋ gabön?” ö gɨlö. Hagailö haga, “Bɨ Kub yad u nɨp damöm gai dam lɨbal u nɨŋagpin!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Anɨg hagöm, ado göm nɨŋa, Jisas urak mɨdeia. Pen nɨp nɨŋö, bɨ unbö ke rö la. Jisas nɨŋa u pen u Jisas nöp a göm nɨŋaga. ");
INSERT INTO kpw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas pen Maria nɨp haga, “Nɨbi me. Nɨhön gɨnɨg mɨɫöŋ gabön? An nɨp uƚhai nɨŋabön?” ö ga. Hageia, Maria haga e, bɨ wög adɨŋ nap nɨbö u nöp yɨp hagab, a göm haga, “Bɨ kub nɨŋeb. Wip u ud arbin, a gɨmön, gai dam lɨban u yɨp hagaimön, yad ud arnam,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hageia, Jisas haga, “Maria!” a ga. Hageia, Maria, Arameik manö löm, “Rabonai!” a ga. Manö haga anɨbu, “Manö Hag Ñeb Bɨ.” ");
INSERT INTO kpw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hageia, Jisas haga, “Yad ram mɨnöŋ iƚ i arö gem, Bapi ado gɨ au laŋ aragɨn rö, yɨp ud mɨdagaimön. Pen ne arammön, mam bɨ kalɨp hagmön, ‘Jisas hagöp, “Yad Bapi yad, Bapi kale, God yad, God kale mɨdöp u ado gɨ arabin,” a göp,’ a gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jisas anɨg hageia, Maria Magdala am Jisas bɨ nɨpe gau kalɨp haga, “Yad Bɨ Kub u nɨp nɨŋem auabin,” a ga. Anɨg hagöm, Jisas manö nɨhön nɨhön nɨp haga u, Maria nɨpe Jisas bɨ nɨpe kalɨp manö anɨbu haga. ");
INSERT INTO kpw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pen Sade ñɨn u, sɨdö wad ara nɨŋöm, bɨ nɨpe gau Juda bɨ kub gau kalɨp pɨñɨŋ göm, ram raul amöm ajöŋ u gɨñ pɨdöŋ göm, agamɨj mɨdeila nɨŋöm, Jisas ap aŋ anɨb au waiö löm haga, “God kalöp abad mɨdeiaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Anɨg hagöm, ñɨmagö ur nɨpe gau kalɨp yamöm, rɨglöm böŋ lau yamöm ga. Bɨ nɨpe gau nɨŋöm, u Bɨ Kub nöp, a göm, mɨñ mɨñ yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas pen kalɨp kuöyaŋ haga, “God kalöp abad mɨdeiaŋ. Bapi yɨp hag yuö apem wög nɨpe gɨpin rö, kalöp pen abe hag yuabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Anɨg hagöm, kalɨp pu göl gɨ haga, “Ana Uɫ u udmim. ");
INSERT INTO kpw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɨbi bɨ rɨmnap nan si nan naij gɨpal gau nɨŋmim arö gɨnabim u, God u rö nöp nɨŋöm arö gɨnab. Pen nɨŋmim arö gagnabim u, God u rö nöp nɨŋöm arö gagnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pen Jisas ap waiö löm kalɨp manö haga ñɨn anɨbu, bɨ nɨpe Domas, hib ap Ñɨ Ramö a gɨmɨdal u, kalɨp aip mɨdageia. ");
INSERT INTO kpw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Anɨb u, hainö Jisas bɨ nɨpe Domas nɨp hagla, “Bɨ Kub u nɨŋbun,” a gɨla. Hageila, nɨpe pen haga, “Anɨg hagabim u pen ñɨmagö nɨpe cɨpɨƚ pakla u abe, rɨglöm bɨnɨŋ gɨla u abe, amgö yad ke nɨŋem ñɨmagö yad ud nɨŋnabin u me, manö anɨbu nɨŋ udem, uraköp, a gem nɨŋ udnabin; wasö u wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Anɨg hagöm, pen wik añɨ ap mɨdöm, Jisas bɨ nɨpe gau Domas aip kuöyaŋ ram raul u mɨdeila. Ajöŋ gɨñ pɨdöŋ gɨla u pen Jisas nɨpe ap aŋ anɨb au waiö löm haga, “God kalöp abad mɨdeiaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jisas anɨg hagöm, Domas nɨp haga, “Ñɨmagö ne u, yɨp cɨpɨƚ pakla u ud nöŋ. Ñɨmagö yad nöŋ. Rɨglöm böŋ yad bɨnɨŋ gɨla aui abe ud nöŋ. Gasɨ mɨlö lagmön, yɨp nɨŋ udmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hageia, Domas haga, “Bɨ Kub yad, God yad!” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pen Jisas Domas nɨp haga, “Yɨp waiö nɨŋmön me, yɨp nɨŋ udpan. Pen nɨbi bɨ yɨp waiö nɨŋagöm, yɨp nɨŋ udnaböl gau, mɨñ mɨñ yabɨƚ gɨnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pen manö kalɨ kƚiñ rɨkabin anɨbi, hon Jisas bɨ nɨpe gau nɨŋ mɨdno nɨŋöl gɨ, Jisas nan gagep ke ke iru nöp gɨmɨdöp rö, magöŋhalö kalɨ kƚiñ rɨkagpin. ");
INSERT INTO kpw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pen kale, Jisas nöp me, Krais u, God Ñɨ nɨpe yabɨƚ u nöp, a gɨmim, nɨp nɨŋ udpe, kalöp udö, nɨp aip kamɨŋ mɨdeinabim, a gem, manö anɨbi kalɨ kƚiñ rɨkpin. ");
INSERT INTO kpw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pen hainö hon Jisas bɨ nɨpe gau Ñɨg Waŋö Daibirias au mɨdaino nɨŋöm Jisas nɨpe waiö lö nɨŋno. Nɨhön ga u hagnɨg gabin. ");
INSERT INTO kpw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pida u, Domas u (hib ap Ñɨ Ramö a gal u), Nadanyel Kena daun, ram mɨnöŋ Galili au nɨbö u, Sebedi ñɨ Jems hol mamil mɨhau, Jisas bɨ nɨpe mɨhöp halö aip, jɨm ñöl am Ñɨg Waŋö Daibirias au mɨdaino. ");
INSERT INTO kpw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pida hanɨp haga, “Yad kabsaƚ nan arabin,” a ga. Hageia, “Hon aip arnabun,” a gun, am nɨp aip ñɨg magɨb udun, gɨ ajno ajno ram rua pen kabsaƚ rɨmnap udagno. ");
INSERT INTO kpw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pen sɨdö lɨm gö nɨŋöl gɨ, Jisas ap ñɨg waŋö goƚ au mɨdeia. Nɨp nɨŋno pen u Jisas nöp a gun nɨŋagno. ");
INSERT INTO kpw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nɨpe hanɨp haga, “Ñɨ game. Kale kabsaƚ nan gɨ aj wasö nɨŋbim ar?” a ga. Hageia, hon yau a gɨno. ");
INSERT INTO kpw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Anɨg hagaino, hanɨp haga, “Uben u ud ñɨg magɨb ñɨmagö yɨjɨg kɨd lau adö yumim me, kabsaƚ rɨmnap udnabim!” a ga. Hageia, uben u ud ñɨg aŋ yaŋ yuun, kabsaƚ iru yabɨƚ nöp udun, ɫɨp gɨno aunɨm rö laga. ");
INSERT INTO kpw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anɨg geia, yad Jon, Pida nɨp hagnö, “Bɨ anɨbu Bɨ Kub u nöp,” a gɨnö. Anɨg hagainö, Pida nɨŋöm, waƚɨj nɨpe au la u ud hib nab aŋ au gɨdaŋ pɨralöm, ujaŋɨd ñɨg aŋ yaŋ la. ");
INSERT INTO kpw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Hon bɨ rɨmnap ñɨg magɨb adö u mɨdun, uben kabsaƚ halö ap ran jaköm mɨdeia u, ɫɨp gɨ dap, mɨlö gau wasö, mida unbö ñɨnjuöl mamɨd (100) rö nöp, ñɨg goƚ au auno. ");
INSERT INTO kpw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Goƚ anɨb au apun nɨŋno, mab in bɨc ara adö u, kabsaƚ rɨmnap in mɨdeia. Bred rɨmnap u rö nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pen Jisas hanɨp haga, “Kabsaƚ mɨñi udpim gau, rɨmnap dauim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hageia, Saimon Pida ñɨg magɨb adö u amöm, nɨpe aip uben kabsaƚ iru nöp (153) mɨdeia anɨbu kabö kuƚup adö au ɫɨp gɨ dauno. Uben u marö ga pen pa gɨ dö gaga. ");
INSERT INTO kpw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas pen hanɨp haga, “Apim, nan ñɨŋim,” a ga. Hon pen nable gö, ne bɨ an ammön mɨdpan a gun nɨp hag nɨŋagno; u Bɨ Kub u nöp a gun, nɨŋun arö gɨno. ");
INSERT INTO kpw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas nɨpe am bred u udöm, hanɨp nɨme löm, kabsaƚ abe ud hanɨp nɨme löm gö, ñɨŋno. ");
INSERT INTO kpw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pen Jisas umöm uraköm, hanɨp bɨ nɨpe gau ij mɨhau nɨgaŋ waiö lö nɨp nɨŋno. ");
INSERT INTO kpw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pen hon nan ñɨŋ pɨs gun, Jisas Saimon Pida nɨp hag nɨŋa, “Saimon Jon ñɨ nɨpe. Bɨ gai i rö wasö; ne yɨp nɨŋö nöp mɨdmagö lɨban aka?” ga. Hageia, Pida haga, “Bɨ Kub. Yad nöp mɨdmagö lɨbin u, ne nɨŋban me,” a ga. Anɨg hageia, Jisas haga, “Sipsip pi yad gau, abad mɨdaimön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas anɨg hagöm, kauyaŋ hag nɨŋa, “Saimon Jon ñɨ nɨpe. Ne yɨp nɨŋö nöp mɨdmagö lɨban aka?” ga. Hageia, Pida haga, “Bɨ Kub. Yad nöp mɨdmagö lɨbin u, ne nɨŋban me,” a ga. Anɨg hageia, Jisas haga, “Sipsip yad gau abad mɨdaimön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas kauyaŋ pen hag nɨŋa, “Saimon Jon ñɨ nɨpe. Ne yɨp mɨdmagö lɨban aka?” ga. Pen Jisas anɨg göm, manö adö añɨ anɨbu nöp, “Ne yɨp mɨdmagö lɨban aka?” hag nɨŋöm hag nɨŋöm gö me, Pida gasɨ iru nɨŋöl gɨ haga, “Bɨ Kub. Ne nan gau magöŋhalö nɨŋban. Anɨb u, yad nöp mɨdmagö lɨbin u, ne hadö nɨŋban me,” a ga. Hageia, Jisas haga, “Anɨb u, sipsip yad gau abad mɨdaimön. ");
INSERT INTO kpw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yad nöp nɨŋö yabɨƚ hagabin, ne bɨ praj rö mɨdaina ñɨn u, waƚɨj gasɨ ne ke nɨŋna rö ud lɨmön ajmɨdan. Pen ne hainö bɨ mɨƚep lɨnabön ñɨn u, ne ñɨmagö ne gɨlaŋ gɨ mɨdö nɨŋöl gɨ, bɨ ke nɨbö ap nöp nagɨ adɨköm, aragnabön mol u uɫ gɨ ud arnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas manö haga anɨbu, nɨbi bɨ rɨmnap hainö Pida al pak lɨnaböl u, Jisas nöd nɨŋa me u. Nɨbi bɨ hain nɨbö gau, Pida nɨp nan nɨhön gɨnaböl umnab u nɨŋöm, God nɨpe mailö aij unbö ke halö mɨdöp u nɨŋnaböl. Pen Jisas Pida nɨp haga, “Yɨp hain gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas manö anɨbu haga nɨŋöm Pida ado göm nɨŋa, yad bɨ Jisas mɨdmagö lɨmɨdöp u mɨdainö. Yad bɨ anɨbu me, nöd Jisas Pasopa nan ñɨŋ mɨdeia iƚ au asɨk mɨdem hag nɨŋnö, “Bɨ Kub. An nöp mumug gɨnab?” ö gɨnö. ");
INSERT INTO kpw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pida yɨp nɨŋöm Jisas nɨp haga, “Bɨ Kub. Bɨ i nɨp nɨhön gɨnab?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Hageia, Jisas haga, “U gasɨ yad. Yad hagnö nɨpe mɨdep nöp mɨdö nɨŋöl gɨ, ado gɨ aunabin u, manö ne wasö. Pen ne yɨp hain gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jisas manö haga anɨbu, nɨbi bɨ nɨp nɨŋ udla rɨmnap hagla, “Jisas bɨ nɨpe anɨbu umagnab,” a gɨla. Pen Jisas bɨ nɨpe anɨbu umagnab a göm manö anɨbu hagaga; nɨpe yɨharɨŋ haga, “Yad hagnö, nɨpe mɨdep nöp mɨdö nɨŋöl gɨ, ado gɨ aunabin u, manö ne wasö,” ga. ");
INSERT INTO kpw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jisas bɨ nɨpe anɨbu me, nɨpe ke manö anɨbi kalɨ kƚiñ rɨköm, magöŋhalö manö nɨŋö yabɨƚ nöp mɨdöp u nɨŋöm, kalɨ kƚiñ rɨköp me u. ");
INSERT INTO kpw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas nan adö ke ke iru nöp ga u pen manö anɨbu yöp rɨmnap nöp aŋ aui kalɨ kƚiñ rɨköp. Yad nɨŋnö, manö anɨb gau magöŋhalö kalɨ kƚiñ rɨk buk iru nöp yaŋ lɨblap, mɨnöŋ naböŋ i pro gö, dam lep ka u mɨdagaiböp. ");
INSERT INTO kpw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mam Diopilas. Yad nöp manö nöd kalɨ kƚiñ rɨknö u, Jisas nɨp yag daulö majö göm, wög iƚ göm mɨd damöm, nan nɨhön nɨhön göm, manö nɨhön nɨhön hag ñöm ga u, nöp köp nöd u kalɨ kƚiñ rɨknö. ");
INSERT INTO kpw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hainö, God Jisas nɨp dam ap ran jak kumi kabö laŋ au ud ara. Pen nɨpe kumi kabö adö laŋ au arnɨg ga magö u, nɨpe gö Ana Uɫ nɨpe manö nɨpe ud arep hag la bɨ gau kalɨp hag ñɨ aij ga. Manö anɨbu magöŋhalö nöd kalɨ kƚiñ rɨkem nöp ñɨnö u. ");
INSERT INTO kpw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas uma pen kauyaŋ uraköm, ñɨn unbö ñɨnjuöl mɨhöp (40) aŋ u ñɨn iru nöp waiö löm, manö nɨpe ud arep bɨ nɨpe gau aip mɨdöm, God nɨbi bɨ udöm abad mɨdeinab manö u kalɨp hag ñɨmɨdöp. Anɨg gö, kale amgö magö kale ke nɨŋla nɨpe kamɨŋ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pen umöm uraköm, mɨnöŋ naböŋ adö iƚ i mɨdmɨdöp ñɨn aŋ anɨb au, ñɨn ap bɨ nɨpe anɨb gau aip nan magö ñɨŋöm haga, “Yad kalöp nöd hagnö rö, Bapi yad nan nɨhön kalöp ñɨnabin a ga u, Jerusalem aui nöp mɨdmim, abad mɨdaimim. ");
INSERT INTO kpw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ñɨg pak ñeb bɨ u nɨbi bɨ kalɨp ñɨg u nöp pak ña, pen ñɨn mɨhöp nöp ap arö, Ana Uɫ u apöm kalöp pak ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pen ñɨn ap Jisas nɨpe bɨ nɨpe anɨb gau mɨdeila aŋ au waiö lö, nɨp hagla, “Bɨ Kub, ne mɨñi kiŋ hon mɨdö, hon Isrel nɨbi bɨ ram mɨnöŋ hon i kauyaŋ ke abad mɨdun, ram mɨnöŋ rɨmnap abad mɨdun gɨnabun aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hageila, kalɨp haga, “Ñɨn mai gɨnab u, Bapi gasɨ nɨpe ke nɨŋöm hag la; nan kale wasö. ");
INSERT INTO kpw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pen Ana Uɫ nɨpe kalöp auö, kale pɨdöŋ udmim ammim, Jerusalem nɨbi bɨ, Judia nɨbi bɨ, Sameria nɨbi bɨ, nɨbi bɨ ram mɨnöŋ gau gau magöŋhalö gau, yad nɨhön nɨhön gɨpin u kalɨp hag ñɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Anɨg hagöm, bɨ nɨpe gau nɨŋmɨdlö nɨŋöl gɨ, God nɨp dam ap ran jak kumi kabö adö laŋ au ud arö nɨŋöl gɨ, kumi bad ap apöm nɨp harɨka. ");
INSERT INTO kpw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pen nɨpe areia, kale kumi kabö laŋ nɨŋ mɨdlö nɨŋöl gɨ, magö anɨbu nöp bɨ waƚɨj rud yɨmlö mɨhau ap kalɨp pɨg urak mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bɨ anɨb mɨhau haglö, “Bɨ Galili nɨbö gai i, kale nɨhön gɨnɨg kumi kabö laŋ nɨŋ mɨdpim? Kale nɨŋöl gɨ mɨdpe nɨŋöl gɨ, God nɨpe gö, Jisas ap ran jak kumi kabö adö laŋ au ud aröp u, hainö nɨpe ke unbö rö nöp ado gɨ aunab,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olip Dum laŋ mɨdeila u arö göm, Jerusalem ado gɨ arla. Adan mɨlö wasö, Olip Dum Jerusalem nɨbö söl; Juda God nɨp sabe gep ñɨn u kale ajmɨdal rö nöp. ");
INSERT INTO kpw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem amöm, ram haneb kale amjaköm, ram raul adö laŋ mɨgan u arla. Bɨ mɨdeila gau: Pida, Jon, Jems, Edru, Pilip, Domas, Badolomyu, Madyu, Alpias ñɨ nɨpe Jems u, Saimon Selod u, Jems ñɨ nɨpe Judas u. ");
INSERT INTO kpw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kale pör pör magum göm, God nɨp sabe gɨmɨdal. Jisas nɨme Maria u, Jisas nɨmam bɨ gau, nɨbi rɨmnap halö pör anɨg gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pen ñɨn aŋ anɨb au, nɨbi bɨ ñɨnjuöl unbö kagoƚ jɨŋ (120) rö ap magum gɨlö nɨŋöl gɨ, Pida uraköm kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Añ mam bɨ nɨŋim. Ana Uɫ nɨpe hadame nöp Depid nɨp gasɨ ñö, Judas Jisas nɨp mumug nɨŋa bɨ u gɨnab rö nɨŋöm kalɨ kƚiñ rɨkö, haga haga rö nöp ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jisas bɨ Judas anɨbu udö, hon aip mɨdöm, wög nɨpe u jɨm ñöl gɨmɨdun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pen hainö nɨpe Jisas nɨp mumug nɨŋöm, mani uda u damöm, mɨnöŋ naböŋ ap rauöm, mɨd damöm, ñɨn añɨ ap ap lug paköm, mudun nɨpe u pabu göm, hibur magöŋhalö lɨm gɨ höŋ hañauö uma. ");
INSERT INTO kpw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Anɨg göl umö, Jerusalem nɨbi bɨ magöŋhalö nɨŋöm, mɨnöŋ naböŋ rauöm uma anɨbu, hib Akeldama a gɨla. Akeldama hagla manö iƚ u, “Hagape Luga Mɨnöŋ Nabö?,” a göm hagla. ");
INSERT INTO kpw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pida haga, “Depid hadame nöp God Manö adɨŋ Sam a gɨpal u kalɨ kƚiñ rɨköm haga, ‘Ram nɨpe cög nöp mɨdainɨm; Nɨbi bɨ rɨmnap ram nɨpe am mɨdagaiöl,’ a ga. Depid manö ap pen haga, ‘Wög nɨpe u bɨ ap udnɨm,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Haga anɨbu, bɨ hon ke ap nɨŋun udnabun. Hon Bɨ Kub Jisas aip ajmɨdun u, bɨ hon aip pör ajmɨdöp bɨ ap nɨŋun udnabun. ");
INSERT INTO kpw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bɨ hon aip pör ajöm, Jon Jisas nɨp ñɨg pak ña u nɨŋöm, mɨd damöm, Jisas umöm uraköm kumi kabö adö laŋ ara nɨŋa bɨ ap nɨŋun udnabun. Bɨ anɨbu rö udno me, Bɨ Kub Jisas umöm uraka manö u hag ñɨ aij gɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pida anɨg hagö, bɨ ne Madaias aip Josep aip kalɨp mɨhöŋ hag lɨla. Pen Josep ñɨn rɨmnap hib nɨpe ap Basabas, ap Jasdas, a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Bɨ anɨb mɨhau kalɨp anɨg göl hag löm, God nɨp sabe göm hagla, “Bɨ Kub, Judas nöd gɨ naij göm umöm, ram nɨpe mɨdainɨm au ara u, kuö nɨpe u an udnɨm, a gun, bɨ mɨhöp i hag lɨbun. Anɨb u, ne nɨbi bɨ magöŋhalö gasɨ nɨŋöm gɨpal rö nɨŋban u me, nöp hag nɨŋabun, ne ke bɨ u a gö, hon nɨŋun udnabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anɨg hagöm, bɨ anɨb mɨhau ilöŋ cal ud gulu gɨ udlö, Madaias hib apranö, Jisas manö ud arep unbö agɨp laŋ aip jɨm ñöm, kauyaŋ bɨ unbö mɨgan laŋ la. ");
INSERT INTO kpw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nɨbi bɨ Jisas nɨp nɨŋ udla gau, Pedikos ñɨn kub u mɨñi, a göm, ap ram raul mɨgan añɨ ap mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Anɨg göl mɨdlö nɨŋöl gɨ, adɨŋ gu kub kumi kabö adö laŋ nɨbö hagöm, yɨgön rö udöm, ram raul mɨgan asɨk mɨdeila au yaŋ aua. ");
INSERT INTO kpw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pen magö anɨbu nöp nɨŋla, mab mɨɫaŋ ugan rö u apöm, pɨlajɨk ke ke pa gɨ dö gɨ amöm, nɨbi bɨ nabɨc cög adö laŋ añɨ añɨ am mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Am mɨdö nɨŋöl gɨ, Ana Uɫ apöm, ana kalɨp aŋ daŋ ajmaŋ raua nɨŋöm kale manö yabɨƚ adö ke ke hagla. ");
INSERT INTO kpw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pen ñɨn anɨbu, Juda nɨbi bɨ gau, kale mɨgan ke ke, ram mɨnöŋ gau nɨbö gau nɨbö apöm, Jerusalem magum gɨ mɨdeila. Nɨbi bɨ anɨb gau kale God Manö haga rö nɨŋöm gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gu kub anɨbu hageia nɨŋöm, nɨhön gab a göm, nɨbi bɨ iru nöp yɨŋɨd ram anɨbu apöm nɨŋla, manö yabɨƚ adö ke ke kabö göl nöp hageila. ");
INSERT INTO kpw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kale nɨŋöm, aiö waiö göm hagla, “Nɨbi bɨ gai i magöŋhalö Galili nɨbö. ");
INSERT INTO kpw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pen aige göm manö yabɨƚ hon ke ke hagpun rö kabö göl hagaböl nɨŋabun? ");
INSERT INTO kpw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Hon rɨmnap Padia nɨbö, rɨmnap Midia nɨbö, rɨmnap Ilam nɨbö, rɨmnap Mesopodemia nɨbö, rɨmnap Judia nɨbö, rɨmnap Kapasodia nɨbö, rɨmnap Podas nɨbö, rɨmnap Esia nɨbö, ");
INSERT INTO kpw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","rɨmnap Prijia nɨbö, rɨmnap Pampilia nɨbö, rɨmnap Ijip nɨbö, rɨmnap ram mɨnöŋ Libia, Sairini daun goƚ gau nɨbö, rɨmnap Rom nɨbö auno. ");
INSERT INTO kpw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nɨbi bɨ Rom nɨbö aula u, rɨmnap Juda nɨbi bɨ yɨjɨg göl, rɨmnap Juda nɨbi bɨ wasö pen uri Juda nɨbi bɨ gɨpal rö adö u gɨpal. Rɨmnap Krir nɨbö, rɨmnap Arebia nɨbö auno. Pen hon nɨŋ mɨdno nɨŋöl gɨ, manö yabɨƚ hon ke ke hagpun rö kabö göl hagöm, God nɨpe nan unbö ke yabɨƚ göp, a göm, hib nɨpe haglö adö arab, nɨŋabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anɨg hagöm, gasɨ iru nɨŋöl gɨ, pen hag nɨŋö, pen hag nɨŋö göm hagla, “Ke yabɨƚ gab anɨbu nɨhön gɨnɨg gab,” a göm, gasɨ iru yabɨƚ nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nɨbi bɨ rɨmnap pen kale ñɨñɨƚoŋ lɨ hagla, “U ñɨg wain iru nöp ñɨŋöm, hauƚ alöp hagaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pen Pida bɨ Jisas manö ud arep bɨ unbö agɨp laŋ aip uraköm, meg mɨgan dap ranöm, nɨbi bɨ iru nöp mɨdeila gau kalɨp haga, “Kale Juda nɨbi bɨ hon abe, kale nɨbi bɨ Jerusalem aui hanmɨdim abe, aui nɨhön gajɨp u yad kalöp manö hagnɨg gabin i nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kale rɨmnap hagpim, ‘Bɨ gai i ñɨg wain iru nöp ñɨŋöm, hauƚ alöp hagaböl,’ a gɨpim u, pen kale ñɨg wain ñɨŋlö hauƚ alagöp. Mɨñi sɨdö gɨsön nöp auöp magö u nöp me. ");
INSERT INTO kpw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pen manö yabɨƚ ke ke hagaböl nɨŋabim anɨbi, bɨ God manö hagep Joel hadame nöp hagöm kalɨ kƚiñ rɨka rö nöp gab me u. Nɨpe manö anɨbu kalɨ kƚiñ rɨköm haga, ");
INSERT INTO kpw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God hagöp, “Ñɨn hain u, nɨbi bɨ magöŋhalö gau kalɨp Ana yad yunabin. Ñɨ pai kale gau God Manö nɨbi bɨ kalɨp hag ñɨnaböl. Bɨ praj kale gau naböŋ nɨŋnaböl. Bɨ majö kale gau hon nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ñɨn anɨbu, nɨbi bɨ yɨp wög gɨ ñɨbal gau, nɨbi gau abe bɨ gau abe, kalɨp Ana yad yunö, manö aij yad u nɨbi bɨ gau kalɨp hag ñɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pen kumi kabö adö laŋ nan ke gagep rö rɨmnap gem, mɨnöŋ naböŋ adö iƚ i nan nɨŋeb nɨŋagep ke nɨbö rɨmnap gɨnabin. Hagape göm, mab inöm, hadu adpɨƚ kub göm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sɨdö mailö gagnab; rakɨn hagape bö lɨnab. Anɨg geinab, hainö ñɨn unbö ke nɨbö waiö lɨnab. Bɨ Kub mailö aij unbö ke halö aunab. ");
INSERT INTO kpw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pen nɨbi bɨ an an, Bɨ Kub yɨp ud kamɨŋ yuaŋ, a göm, hag nɨŋnaböl gau, kalɨp ud kamɨŋ yunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pida nɨpe Joel kalɨ kƚiñ rɨka manö anɨbu hag pɨs göm haga, “Kale Isrel nɨbi bɨ, manö hagnɨg gabin i nɨŋ aij gɨmim. Jisas bɨ Nasared nɨbö u bɨ yɨharɨŋ wasö; God nɨpe ke nɨp yuö aua. Ñɨ yad u yunö, nan gagep rö iru nöp göm, nan nɨŋeb nɨŋagep iru nöp göm gɨnab aŋ kalɨp au nɨŋöm, bɨ anɨbu God nɨpe ke hag yuö aua u nɨŋlaŋ, a göm, nɨp yuö aua. Jisas nɨpe nan gagep rö aŋ kale ga u, kale ke hadö nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God kale gɨnabim rö nöd nɨŋöm, Jisas nɨp ud ñɨmagö adö kalöp u lö, kale dam nɨbi bɨ nan si nan naij gɨpal gau kalɨp ñɨbe, nɨp mab ba laŋ al pak lɨlö uma. ");
INSERT INTO kpw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nɨpe ilön kub yabɨƚ udöm uma u pen böŋ nöp wip rɨgöl au mɨdöm, hij gɨ lug lɨ arnɨm rö laga. God gö kauyaŋ uraka. ");
INSERT INTO kpw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Depid pen hadame nöp Jisas nɨp manö kalɨ kƚiñ rɨköm haga, ‘Yad nɨŋbin, Bɨ Kub yad aip pör pör mɨdöp. Nɨpe ñɨmagö yɨjɨg yad lau adö mɨdöp u me, yad pɨñɨŋ gagnabin. ");
INSERT INTO kpw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Anɨg göp u, hibur mɨdmagö yad pɨƚaiöp; yad ñɨñɨ lem hagabin. Hañ romaŋ yad umnɨg gab pen gasɨ halö mɨdem pɨñɨŋ gagnabin. ");
INSERT INTO kpw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ai gɨnɨg? Ne yɨp wip rɨgöl mɨgan arö gagnabön. Ne Bɨ Uɫ ne arö gö, hañ romaŋ nɨpe hij gɨ lug lɨ aragnab. ");
INSERT INTO kpw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ne yɨp kamɨŋ mɨdep adan u yamna. Yad ne aip mɨdem, mɨñ mɨñ yabɨƚ gɨnabin,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pida Depid haga manö anɨbu hag pɨs göm haga, “Añ mam bɨ, yad kalöp manö kabö göl hagnö, nɨŋ aij gɨnabim. Bac iƚaŋ Depid umö rɨgöl gɨla uƚöm mɨgan u mɨdöp; uƚöm mɨgan anɨbu mɨñi hon u rö nöp nɨŋbun. ");
INSERT INTO kpw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pen Depid nɨpe God manö hag ñeb bɨ mɨdmɨdöp u me, nɨpe nɨŋa, God hadame nöp manö hag löm haga, ‘Ne ñɨ rɨknabön rɨk damöm rɨk lɨnaböl ñɨ ap nɨpe ka ne udöm, kiŋ mɨdeinab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Depid nan hainö gɨnab u nɨŋöm, Mesaia u nɨpe umöm uraknab, a göm, haga, ‘Nɨp wip rɨgöl mɨgan arö gaga. Hañ romaŋ nɨpe hij gɨ lug lɨ araga,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Mɨñi God gö, Jisas nɨpe uraköm kamɨŋ mɨdöp. Nɨpe kamɨŋ mɨdöp u hon magöŋhalö amgö magö hon ke nɨŋbun. ");
INSERT INTO kpw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God Jisas nɨp dam ñɨmagö yɨjɨg adö nɨpe lau la. Löm nɨpe Ana Uɫ ñɨnabin a göm haga u, Jisas nɨp ñö, nɨpe pen hanɨp ñö, apöm gu kub hagö, hon manö ke ke hagabun i nɨŋabim. ");
INSERT INTO kpw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pen Depid manö haga anɨbu, nɨpe ke hagaga. Depid nɨpe mɨnöŋ naböŋ iƚ i mɨdöm, kumi kabö adö laŋ araga. Pen nɨpe haga, ‘Bɨ Kub nɨpe Bɨ Kub yad u nɨp haga, “Ñɨmagö yɨjɨg yad lau adö asɨk mɨdaimön me; ");
INSERT INTO kpw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yad gɨnö kauaƚ mauaƚ ne gau, raƚa mɨgan ne gau mɨdeinaböl,” a ga,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Anɨb u, kale Isrel nɨbi bɨ magöŋhalö nɨŋ aij gɨmim: Jisas bɨ mab ba laŋ al pak lɨbe uma bɨ anɨbu nöp, God gö Bɨ Kub yabɨƚ mɨdöp. Nɨpe nöp Mesaia pör abad mɨdmɨdun me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pida manö anɨbu hagö, nɨbi bɨ mɨdeila gau nɨŋöm ñaul ara. Anɨg gö, kale Pida abe, Jisas manö ud arep bɨ gau abe, hag nɨŋöm hagla, “Anɨb u, mam bɨ, hon mɨñi nɨhön gun?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hageila, Pida haga, “Kale añɨ añɨ magöŋhalö mɨdpim rö, nan si nan naij gɨpim adö u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨmim, Jisas Krais nɨp nɨŋ udmim, ñɨg pakmim. Anɨg geinabim, God nan si nan naij gɨpim u nɨŋöm arö göm, Ana Uɫ nɨpe u kalöp ñɨnab. ");
INSERT INTO kpw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God hadame nöp haga, ‘Ana yad kalöp Isrel nɨbi bɨ ñem, ñɨ pai kale yag daunabim gau kalɨp ñem, nɨbi bɨ mɨlö gau kalɨp abe ñem gɨnabin,’ a ga. Anɨb u, hon nɨŋbun, God nɨbi bɨ an an aulaŋ a gɨnab gau, kalɨp magöŋhalö Ana Uɫ u ñɨnab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pida kalɨp mög nɨŋöm, manö iru nöp hagöm hagöm haga, “Nɨbi bɨ uri mɨdpal rɨmnap haƚöwaƚö gɨ naij gɨpal rö arö gɨmim, mɨd aij gɨmim. Wasö u, ilön kub udnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɨbi bɨ iru nöp Pida manö haga u nɨŋöm, Jisas Krais nɨp nɨŋ udöm, ñɨg pakla. Ñɨn anɨbu nöp, nɨbi bɨ dri dausan (3000) rö Jisas Krais nɨp nɨŋ udöm, Jisas nɨbi bɨ nɨpe aip jɨm ñöl mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Anɨb u, kale pör pör apöm, bɨ Jisas manö ud arep bɨ gau aip se göl mɨdöm, God Manö hag ñeila u nɨŋ aij gun, a göm, hag amɨl apɨl göl gɨ, bred ud jö göm se göl ñɨŋöl gɨ, God nɨp sabe göl gɨ mɨdmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God bɨ Jisas manö ud arep bɨ gau kalɨp pɨdöŋ ñö, nan gagep rö iru nöp göm, nan nɨŋeb nɨŋagep iru nöp göm gɨlö, nɨbi bɨ gau nɨŋöm, aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nɨbi bɨ Jisas nɨp nɨŋ udla gau, se gɨ mɨdöm, nɨbi bɨ nan mɨdageia gau, nɨbi bɨ rɨmnap kalɨp nan haƚöwaƚö ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mɨnöŋ nabö?, nan gau u rö nöp sɨkim göm, mani udöm, nɨbi bɨ nan mɨdageia gau kalɨp nɨme lɨ ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kale pör pör, ñɨn añɨ añɨ, God sabe gep ram u am magum gɨmɨdal. Pen ram kale gau u rö nöp am magum göm, bred ud jö göm, mɨdmagö apen löl gɨ, ñɨñɨ löl gɨ, nan se göl ñɨŋmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pen nɨbi bɨ mɨdeila gau magöŋhalö, Jisas nɨŋ udla nɨbi bɨ kalɨp nɨŋlö, aij a ga. Pör pör, ñɨn añɨ añɨ, Bɨ Kub nɨpe nɨbi bɨ rɨmnap halö ud kamɨŋ yuö, kale Jisas nɨp nɨŋ udöm, ap Jisas nɨbi bɨ nɨpe nöd nɨbö gau aip mɨdmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","3","Bɨ nɨme yag daua ñɨn u nöp ma naij ga ap, nɨp ñɨn añɨ añɨ pör pör dapöm, God sabe gep ram ajöŋ iƚ, Ajö? Kƚiñ Aij, a gɨmɨdal u, goƚ au lɨlö asɨk mɨdmɨdöp. Mɨdöl gɨ, nɨbi bɨ God sabe gep ram raul mɨgan ap armɨdal gau, kale mani nan yɨp ap ñim, a gɨ asɨb gɨmɨdöp. Pen mañ ap, Pida aip, Jon aip sɨdö gamɨŋ ga dugo magö u, God nɨp sabe gep magö u, God nɨp sabe gɨnɨg, ap padilö nɨŋöl gɨ, bɨ ma naij ga anɨbu kalɨp mɨhöŋ nɨŋöm haga, “Yɨp mani rɨmnap ñɨl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hageia, kalpe mɨhöŋ nɨp nɨŋ ij halö lɨ mɨdmil, Pida haga, “Halɨp mɨhöŋ nöŋ!” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Haga, yɨp nan ap ñɨnɨg gabil, a göm, kalɨp mɨhöŋ nɨŋ mɨdö nɨŋöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pida haga, “Mani silpa, mani gol, yad mɨdagöp u pen nan yad añɨ ap mɨdöp u nöp ñɨnabin. Jisas Krais Nasared nɨbö u, hib nɨpe hagem nöp hagabin, ‘Urak aru!’” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pida anɨg hagöm, ñɨmagö yɨjɨg lau nɨp udöm, ud urak ñö nɨŋöl gɨ, magö anɨbu nöp ma abe, ma goƚ abe aij la. ");
INSERT INTO kpw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Aij gö, yɨŋɨd urak amöl gɨ, raƚa raƚa göl gɨ, God nɨp aij a göl gɨ, kalɨp mɨhöŋ aip God sabe gep ram raul mɨgan u ara. ");
INSERT INTO kpw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","God nɨp aij, a göm, abö göl göm ajeia u, nɨbi bɨ mɨdeila gau nɨŋöm, ");
INSERT INTO kpw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bɨ ma naij pör apöm, God sabe gep ram ajöŋ iƚ, Ajö? Kƚiñ Aij, a gɨmɨdal u, goƚ au asɨk mɨdöm, mani nan gau asɨb gɨmɨdöp bɨ anɨbu, aigöl göm ma yabɨƚ abö gɨ auab, a göm, gasɨ iru nɨŋöm aiö waiö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bɨ anɨbu nɨpe, God sabe gep ram höŋ adö, Solomon Ram Bada, a gɨmɨdal, mɨgan u mɨdöm, Pida aip, Jon aip kalɨp mɨhöŋ aŋ aŋ lɨ ud mɨdö nɨŋöl gɨ, nɨbi bɨ magöŋhalö aiö waiö göl gɨ, gɨ dö gɨ aula. ");
INSERT INTO kpw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nɨbi bɨ aueila, Pida nɨpe nɨŋöm haga, “Isrel nɨbi bɨ gai i, kale nɨhön gɨnɨg gasɨ iru nɨŋmim halɨp bɨ mɨhöŋ nɨŋ ij halö gabim? ‘Kale mɨhöŋ bɨ kƚö, bɨ kamɨŋ aij mɨdmil gajɨl, bɨ anɨbi adan aj aij gab,’ a gɨmim, gasɨ u nɨŋabim ar? U wasö. ");
INSERT INTO kpw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraham, Aisak, Jekop, bac iƚaŋ hon bɨ gau sabe gɨmɨdal God anɨbu nöp nɨpe ke gö, bɨ wög gɨ ñeb nɨpe Jisas urakö, nɨbi bɨ gau nɨŋöm, nɨpe mailö aij unbö ke halö mɨdöp a göm, nɨŋbal. Kale pen Jisas nɨp udagpe. Pailod, Jisas nɨp hubɨk yuɨn a ga u pen kale ke, nɨp dam mab ba laŋ al pak lɨlaŋ, a gɨpe. ");
INSERT INTO kpw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas nɨpe Bɨ Uɫ; nɨpe Bɨ Kamɨŋ Aij pör nöp God hagöp rö nöp göp. Pen kale hagpe, Jisas nɨpe bɨ nɨŋeb hon wasö; bɨ wip almɨdöp u hanɨp hubɨk yu, a gɨpe. ");
INSERT INTO kpw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Anɨg gɨmim, Bɨ kamɨŋ mɨdep magö ñöb u nɨp al pak lɨbe. Pen God gö, nɨpe uraka u, hon amgö magö hon ke nɨŋul hagabul. ");
INSERT INTO kpw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bɨ ma naij pör nɨŋbim i, mɨñi kamɨŋ lajɨp nɨŋbim. Jisas kƚö nɨpe gö me, kamɨŋ löp. Jisas nɨŋ udul, hib nɨpe haglo, nɨpe gö böŋ nöp kamɨŋ löp. ");
INSERT INTO kpw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pen mɨdeimam yad gai. Kale ke abe, bɨ kub kale gau abe, hauƚ halö mɨdmim, Jisas nɨp anɨg gɨpe. ");
INSERT INTO kpw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pen God nɨpe bɨ manö nɨpe hagep gau kalɨp hadame nöp gasɨ ñö hagla, ‘Hainö God Mesaia nɨpe ilön kub yabɨƚ udöm umnab,’ a gɨla u me, hagla rö nöp gɨpe. ");
INSERT INTO kpw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Anɨb u, nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨmim, God nɨp ado gɨ aube, nɨpe nan si nan naij gɨpim prɨ u ƚɨk gɨ yunab. ");
INSERT INTO kpw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anɨg gɨpe, Bɨ Kub nɨpe ana kalöp aŋ daŋ kƚö nɨpe ñöm, Krais u kalöp hadame nöp hag la u hag yunab. Krais u Jisas me. ");
INSERT INTO kpw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","God nɨpe hadame nöp hagö, bɨ manö hagep uɫ nɨpe gau hagla rö, Jisas nɨpe ram mɨnöŋ kumi kabö adö laŋ au mɨdöp rö mɨdö nɨŋöl gɨ, God nan magöŋhalö kauyaŋ gɨ lɨ aij gɨnab ñɨn u aunab. ");
INSERT INTO kpw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosɨs haga, ‘Hainö Bɨ Kub God kale, nɨpe bɨ manö hagep yad rö, bɨ iƚ kale ke ap, hag yunab. Nɨpe apöm, manö hagnab u magöŋhalö nɨŋ aij gɨmim. ");
INSERT INTO kpw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nɨbi bɨ manö nɨpe udagnaböl gau, nɨbi bɨ nɨpe mɨdageinaböl; kale böŋ nöp höŋ adö yaŋ amöm, umnaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bɨ God manö hagep Samyuel abe, bɨ God manö hagep hain aula gau abe magöŋhalö nan uri waiö lab nɨŋabun u hadö hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God hadame nöp nahai iƚaŋ kale manö hag la u, kale ke nan ame udabim me u. God bac Ebraham nɨp gɨnabin, a göm, manö hag la. Manö hag löm haga, ‘Ñɨ pai ne rɨkö, kale rɨk dam dapɨl göm rɨknaböl gau, bɨ ap mɨdöm me, nɨpe gö nɨbi bɨ gau magöŋhalö mɨñ mɨñ gɨnaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pen God Bɨ Wög Gɨ Ñeb nɨpe Jisas ram mɨnöŋ iƚ i yua u, kalöp nöp a göm, nöd yuö aua. Isrel nɨbi bɨ nan si naij naij gɨpal u, nɨhön gɨnɨg anɨg gɨpun, a göm, adö anɨbu arö göm, mɨd aij gɨlaŋ, a göm, kalöp Isrel nɨbi bɨ gai i nöd yuö aua,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pida aip, Jon aip nɨbi bɨ kalɨp manö hag ñɨlö nɨŋöl gɨ, bɨ God nɨp nan sabe gep bɨ gau abe, God sabe gep ram polisman bɨ nabɨc kale u abe, bɨ Sadyusi gau abe, amöm manö hagailö anɨbu apdi nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jisas umöm uraka rö, nɨbi bɨ Jisas nɨp nɨŋ udnaböl gau u rö nöp umöm uraknaböl manö u, nɨhön gɨnɨg hag ñabil, a gɨlö, mulu luga. ");
INSERT INTO kpw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Anɨb u, kale Pida aip Jon aip ud sɨsɨ göm, uri dugöp magö i wasö, rol manö kub hagnabun, a göm, kalɨp bɨ mɨhöŋ dam nagɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pen Pida Jon bɨ mɨhau manö aij anɨbu hag ñailö, nɨbi bɨ nɨŋöm, iru yabɨƚ nɨŋ udla. Anɨb u, nɨbi bɨ Jisas nɨŋ udla gau unbö paip dausan (5000) rö ara. ");
INSERT INTO kpw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pen ruö, Juda bɨ kub ram mɨnöŋ anɨbu abad mɨdmɨdal abe, bɨ manö ud asɨkep gau abe, bɨ lo manö hag ñeb bɨ gau abe, Jerusalem gau ap magum gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","God nɨp nan sabe gep bɨ kub yabɨƚ Anas aip, Kaiapas aip, yam kale bɨ Jon u, Aleksada u, bɨ yam kale rɨmnap halö apöm, aŋ anɨb au mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kale magum göm haglö, Pida Jon kalɨp mɨhöŋ uɫ gɨ dap aŋ au lɨlö, kalɨp mɨhöŋ hag nɨŋöm hagla, “Bɨ ma naij ga u aigöl gɨ gajɨl kamɨŋ löp? Pɨdöŋ gai nɨbö udmil, hib nɨhön hagmil, anɨg gɨpil?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hageila, Ana Uɫ nɨpe am Pida aŋ daŋ ajmaŋ rauö nɨŋöl gɨ, Pida haga, “Kale Juda bɨ kub abe, bɨ manö ud asɨkep abe, manö hagabin i nɨŋim. ");
INSERT INTO kpw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bɨ mög gep ma naij ga u gailo kamɨŋ la u nɨŋmim, ‘Kale aigöl gɨ gajɨl kamɨŋ löp?’ ö gɨmim, halɨp manö kub hagabim ar? ");
INSERT INTO kpw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Anɨb u, kale manö hagnɨg gabin i nɨŋ aij gɨmim. Isrel nɨbi bɨ gau magöŋhalö u rö nöp nɨŋ aij göl. Jisas Krais bɨ Nasared nɨbö hib nɨpe u nöp nɨŋ udul, hib nɨpe haglo, nɨpe gö, bɨ anɨbi nɨp böŋ nöp kamɨŋ lö, aj aij gab nɨŋabim. Kale Jisas Krais nɨp mab ba laŋ al pak lɨbe u pen God gö kauyaŋ uraka. ");
INSERT INTO kpw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bɨ Jisas anɨbu nɨp me, God Manö kalɨ kƚiñ rɨköm hagla, ‘Kale bɨ ram gep gau, kabö mɨlö ap, u kabö naij, a gɨmim, arö gɨpe u, uri ram padö aŋ yaŋ bɨnɨg ñöl mɨdöp,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God nɨpe Jisas hib nɨpe nöp hanɨp haga nɨŋöm Jisas nɨpe nöp hanɨp ud kamɨŋ yunɨm rö löp. Mɨnöŋ naböŋ iƚ i bɨ ke nɨbö ap hanɨp ud kamɨŋ yunɨm rö lagöp wasö yabɨƚ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pida Jon kale bɨ mɨhau urakmil, pɨñɨŋ gagmil, haƚöwaƚö kabö göl nöp haglö u, bɨ kub anɨb gau nɨŋöm, aiö waiö göm hagla, “Bɨ mɨhai i kale skul hagaglö u pen kale Jisas aip mɨdmil anɨg gɨmil gɨpil,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bɨ ma naij ga kamɨŋ la u aŋ kale au mɨdö nɨŋöl gɨ, kalɨp mɨhöŋ manö hag göl rö laga. ");
INSERT INTO kpw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Anɨb u me, kale hagla, “Kansol ram i höŋ yaŋ am mɨdaiɨl,” a gɨla. Höŋ yaŋ am mɨdlö nɨŋöl gɨ, kale ke hag nɨŋ hag nɨŋ göm hagla, ");
INSERT INTO kpw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Bɨ mɨhai i hon nɨhön gun? Kale nan gagep rö u gɨlö, Jerusalem nɨbi bɨ magöŋhalö hadö nɨŋbal. Anɨb u, kale mɨhöŋ nan gagep rö ap gagpil a gun rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pen kale ammil, manö anɨbu nɨbi bɨ rɨgoŋ rɨmnap haglö, kale u rö nöp nɨŋöl rö löp. Anɨg göp u, hon kalɨp mɨhöŋ manö kƚö hagun hagun, ‘Jisas hib nɨpe u hainö nɨbi bɨ rɨmnap hagagmil, wasö yabɨƚ,’ a gun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anɨg hagöm, kalɨp mɨhöŋ haglö auailö hagla, “Jisas hib u hainö hagagmil; nɨbi bɨ rɨmnap Jisas manö u hag ñagmil, wasö yabɨƚ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Anɨg hageila, Pida Jon kale pen pe haglö, “Hol God manö nɨp u arö gul, manö kalöp u udlo, God nɨp aij gɨnab aka wasö? Kale ke nɨŋim. ");
INSERT INTO kpw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pen Jisas nɨhön nɨhön ga, manö nɨhön nɨhön haga u, hol nɨbi bɨ gau kalɨp hag ñɨ arö gul rö lagöp,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Anɨg hagailö, Kansol bɨ kub gau gasɨ kale ke nɨŋöm, ‘Bɨ i mɨ ñɨnjuöl mɨhöp (40) mɨdöm, uri kamɨŋ löp i, nɨbi bɨ gau nɨŋöm magöŋhalö God nɨp aij a gaböl. Hon bɨ anɨb mɨhai i kalɨp nan ap geinabun u, nɨbi bɨ gai i kal aunaböl,’ a göm, kalɨp mɨhöŋ yɨharɨŋ manö kƚö hagöm, hag höŋ yula. ");
INSERT INTO kpw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pida Jon kalɨp mɨhöŋ anɨg göl hag höŋ yulö, kale am Jisas nɨbi bɨ nɨpe gau kalɨp nɨŋmil, bɨ God nɨp nan sabe gep bɨ kub gau abe, bɨ manö ud asɨkep gau abe, manö nɨhön nɨhön hagla u kalɨp hag ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hag ñeilö, kale nɨŋöm magöŋhalö God nɨp sabe göm hagla, “Ne Bɨ Kub añɨ nɨbö mɨdpan. Ne kumi kabö adö laŋ gɨ lɨmön, mɨnöŋ naböŋ iƚ i gɨ lɨmön, ñɨg solwara gɨ lɨmön, nan nɨhön nɨhön mɨdöp gau magöŋhalö gɨ lɨmön, gɨ lɨna. ");
INSERT INTO kpw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hadame nöp ne gö, Ana Uɫ nɨpe bac hon Depid nɨp gasɨ ñö, manö nöp u hagöm haga, ‘Juda nɨbi bɨ wasö gau kale nɨhön gɨnɨg kal jubal? Nɨbi bɨ gau nɨhön gɨnɨg gasɨ nɨŋ aij göm wasö, manö adö añɨ hag löm mumug manö hagpal? ");
INSERT INTO kpw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kiŋ ram mɨnöŋ ke ke abad mɨdpal gau abe, gapman bɨ kub ram mɨnöŋ ke ke abad mɨdpal gau abe, manö adö añɨ hag löm hagla, “God Bɨ Kub aip, Mesaia nɨpe aip, kalɨp aip pen pen gun,” a gɨla,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kiŋ Herod abe, gapman bɨ kub Podias Pailod abe, Juda nɨbi bɨ wasö gau rɨmnap abe, Isrel nɨbi bɨ gai i nɨbö rɨmnap abe, Jerusalem i apöm, Bɨ Wög Gɨ Ñeb uɫ ne u Jisas, Mesaia hag lɨna u nöp, manö hag adö añɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pen ne Bɨ kƚö nöd gasɨ ne ke nɨŋmön hagna, Krais nɨp anɨg anɨg gɨnaböl a gɨna u me, kalɨp göl rö la; yɨharɨŋ u kƚö kale mɨdagaiböp. ");
INSERT INTO kpw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bɨ Kub, mɨñi hanɨp manö kƚö naij yabɨƚ hagaböl u ne gasɨ nɨŋmön. Hanɨp nɨbi bɨ wög gɨ ñeb ne abad mɨdmön, pɨdöŋ ne hanɨp ñö, hon pɨrɨkagun, kƚö yabɨƚ gun manö ne nɨbi bɨ gau kalɨp waiö hag ñun. ");
INSERT INTO kpw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nɨbi bɨ nan göp gau, ne gö, hon Bɨ Wög Gɨ Ñeb uɫ ne Jisas hib nɨpe hagno, kalɨp kamɨŋ lɨnɨm. Ne gö, hon Jisas hib nɨpe hagno, nan gagep rö rɨmnap, nan nɨŋeb nɨŋagep rö rɨmnap gun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pen kale God nɨp anɨg gɨ sabe göl gɨ mɨdlö nɨŋöl gɨ, ram mɨdeila u munmon rö udöm, Ana Uɫ nɨpe ap aŋ kalɨp daŋ ajmaŋ rauö, pɨñɨŋ gagöm, God Manö u kƚö yabɨƚ göm hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pen nɨbi bɨ Jisas nɨp nɨŋ udla anɨb gau, manö adö añɨ hagöm, gasɨ adö añɨ nɨŋöm, nan kale nan nɨhön mɨdeia gau, nan kale jɨm ñöl nöp mɨdö, nan hon halö a göm nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bɨ Jisas manö ud arep gau, nɨbi bɨ gau kalɨp manö kƚö gɨ hagöm hagmɨdal, “Jisas nɨp al pak lɨlö, umöm uraka, nɨp amgö nɨŋno,” a gɨmɨdal nɨŋöm God kalɨp magöŋhalö mög yabɨƚ nɨŋöm ud aij yabɨƚ gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kale bɨ nan lugep mɨdageia; magöŋhalö nan mɨdeia. Nɨbi bɨ mɨnöŋ naböŋ aka ram rɨmnap mɨdeia gau, sɨkim gɨ mani udöm, ");
INSERT INTO kpw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bɨ Jisas manö ud arep gau kalɨp ñɨmɨdal. Kale pen udöm, nɨbi bɨ nan mɨdageia gau kalɨp nɨme lɨ ñɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pen bɨ Lipai iƚ rɨk damöm rɨkla bɨ ap hib nɨpe Josep. Ram mɨnöŋ nɨpe Saipras nɨbö. Bɨ anɨbu nɨpe nɨbi bɨ rɨmnap kalɨp manö hain hagöm hag ñɨ aij gö, kale nɨŋöm gasɨ halö mɨdmɨdal rö, bɨ Jisas manö ud arep gau nɨp Banabas a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josep mɨnöŋ naböŋ nɨpe ap hagö, nɨbi bɨ rɨmnap raula nɨŋöm mani anɨbu dap bɨ Jisas manö ud arep gau kalɨp ña. ");
INSERT INTO kpw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pen bɨ ber ap mɨdailö. Nugmul hib u Ananaias, nɨbin nɨpe hib u Sapaira. Ber mɨhau kale mɨnöŋ naböŋ kale ap haglö raula. ");
INSERT INTO kpw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Raulö, Ananaias nɨpe mani anɨbu böŋ lau kale ke nɨme löm, böŋ lau dam Jisas manö ud arep bɨ gau kalɨp ña. Nɨbin abe nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pen Ananaias mani anɨbu anɨg göl dap ñö, Pida haga, “Ananaias, Seden nöp gasɨ ñö, ne pir almön hagpan, ‘Mɨnöŋ raubal mani magöŋhalö daubin i,’ a gɨpan. Manö pir alban anɨbu, Ana Uɫ nɨp u rö nöp pir alban. Mani mɨnöŋ naböŋ raubal anɨbu böŋ lap pi gɨmön auban. ");
INSERT INTO kpw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mɨnöŋ naböŋ anɨbu, mɨnöŋ naböŋ ne. Sɨkim gɨnɨg, sɨkim gɨbnap; arö gɨnɨg, arö gɨbnap. Pen mɨnöŋ sɨkim gö, mani raula anɨbu, magöŋhalö daunɨg, magöŋhalö daubnap; rɨmnap nöp daunɨg, rɨmnap nöp daubnap; magöŋhalö ram ne au arɨk aunɨg, arɨk aubnap. Manö mɨdagböp. Pen ne manö pir alban u, hanɨp bɨ nöp manö pir alagpan; God nɨp u rö nöp manö pir alban. Ne ai gɨnɨg anɨg gɨpan?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pida anɨg hagö, Ananaias nɨŋöm, magö anɨbu nöp ap lug mɨnöŋ yaŋ paköm böŋ nöp uma. Anɨg gö nɨŋöl gɨ, nɨbi bɨ gau ga anɨbu nɨŋöm, anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pen bɨ praj gau apöm, wip he mɨlö u waƚɨj wam wam göm, dam rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Pen nɨbin, nugmul nɨpe umö dam rɨgöl gɨla u nɨŋaga. Nɨpe yöp söl magö ap mɨdöm apjakö, Pida nɨp haga, “Mɨnöŋ naböŋ kale ber u sɨkim gɨlö, mani anɨg unbö rö nöp raubal aka?” ga. Hageia, nɨbin haga, “Raubal u dauub me u,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hageia, Pida nɨp haga, “Kale ber nɨhön gɨnɨg hag nɨŋmil anɨg gɨpil? Bɨ Kub Ana nɨpe manö pir anɨbu nɨŋagnab a gɨmil anɨg gɨpil? Nö?! Nagamul umajɨp, dam rɨgöl gɨpal bɨ gau mɨdpal ajöŋ iƚ aui. Nöp u rö nöp ud arnɨg gaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Anɨg hagö nɨŋöl gɨ, magö anɨbu nöp, Pida ma iƚ au ap lug mɨnöŋ yaŋ paköm uma. Bɨ praj ugan nugmul nɨp dam rɨgöl gɨla anɨbu apöm, nɨbin u rö nöp hadö böŋ nöp uma u nɨŋöm, nɨp dam nugmul nɨp rɨgöl gɨla böŋ lau rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Krais nɨp nɨŋ udla nɨbi bɨ gau abe, nɨbi bɨ rɨmnap gau abe, nan ga anɨbu nɨŋöm, magöŋhalö anɨnɨn gö pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɨ Jisas manö ud arep unbö mɨgan laŋ nan gagep rö iru nöp nɨbi bɨ mɨdeila aŋ au gɨ mɨdeila. Pen nɨbi bɨ God Manö nɨŋöm Krais nɨp nɨŋ udla gau, magöŋhalö ap magum gɨmɨdal God sabe gep ram höŋ adö “Solomon Ram Bada” a gɨmɨdal u. ");
INSERT INTO kpw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nɨbi bɨ rɨmnap gau, Krais nɨp nɨŋ udla nɨbi bɨ gau kalɨp nɨŋlö aij a ga u pen, Krais nɨbi bɨ nɨpe mɨdpal anɨbu, hon aige gun am kalɨp aip magum gun, a göm, pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pen pör pör nɨbi bɨ hain nɨbö iru yabɨƚ nöp, Bɨ Kub nɨp nɨŋ udöm, nɨbi bɨ nöd nɨbö gau aip ap magum gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jerusalem nɨbi bɨ, bɨ Jisas manö ud arep gau gɨla rö nɨŋöm, nɨbi bɨ mɨña ga gau dap adan majö goƚ au löm, köp yad mɨgan mɨgan löm hagla, “Pida padiö, sɨdö mɨmɫaŋ nɨpe u kalɨp pak ñö, kamɨŋ lɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nɨbi bɨ yöp ram mɨnöŋ Jerusalem söl au mɨdeila gau, u rö nöp nɨbi bɨ nan ga gau udöm, nɨbi bɨ kɨjaki aiön pi halö mɨdeila gau udöm, daula. Daueila, kalɨp gɨlö, magöŋhalö kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Anɨg geila, bɨ God nɨp nan sabe gep bɨ kub yabɨƚ u abe, bɨ nɨŋeb nɨpe bɨ Sadyusi gau abe, kale nan gagep rö anɨg gɨlö hib hon lugnab, a göm, bɨ Jisas manö ud arep gau kalɨp nɨŋlö mulu luga. ");
INSERT INTO kpw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kalɨp mulu lugö, bɨ Jisas manö ud arep gau kalɨp ud sɨsɨ löm, dam gapman kai kalɨp ñɨlö, nagɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nagɨ lɨla u, pen ñɨn anɨbu nöp sɨbön yaŋ, Bɨ Kub hagö, ejol ap apöm, ajöŋ u hiɨköm, kalɨp uɫ gɨ dam höŋ arla. ");
INSERT INTO kpw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Höŋ arlö, ejol haga, “Kale God sabe gep ram u ammim, nɨbi bɨ gau kalɨp, God gö pör pör mɨdeinaböl manö aij u magöŋhalö hag ñɨ aij gɨmim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hagö, ram rua nɨŋöl gɨ, God sabe gep ram u amöm, ejol u haga rö, nɨbi bɨ gau kalɨp iƚ göm manö hag ñɨla. Anɨg göl hag ñɨlö nɨŋöl gɨ, God nɨp nan sabe gep bɨ kub yabɨƚ u abe, bɨ nɨŋeb nɨpe gau abe apjaköm, bɨ manö ud asɨkep gau kalɨp magöŋhalö wɨñ allö, ap Kansol kub u magum gɨlö, bɨ God sabe gep ram abad mɨdep bɨ gau hag yuöm hagla, “Bɨ Jisas manö ud arep gau nagɨ lɨbun u mɨñi am uɫ gɨ dauim,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Hageila, bɨ God sabe gep ram abad mɨdeila bɨ gau nagɨ lep ram u amöm nɨŋla, bɨ Jisas manö ud arep gau mɨdageila. Kale ado gɨ apöm hagla, ");
INSERT INTO kpw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hon am nɨŋbun, ajöŋ u gɨñɨbal rö mɨdajɨp, bɨ abad mɨdep bɨ gau u rö nöp ajöŋ iƚ u nɨŋ mɨdajal u pen hon ajöŋ hiɨkun, ram raul mɨgan yaŋ amun nɨŋbun, bɨ ap mɨdagajɨp yabɨƚ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anɨg hageila, bɨ God sabe gep ram abad mɨdeila bɨ kub kale u abe, God nɨp nan sabe gep bɨ kub gau abe, manö anɨbu nɨŋöm, anɨg göp nɨhön gɨnab, a göm, gasɨ iru nöp nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Anɨg göl gasɨ iru nɨŋ mɨdlö nɨŋöl gɨ, bɨ ap apöm kalɨp haga, “Bɨ nagɨ lɨbe gau, kale am God sabe gep ram u mɨdöl göm, nɨbi bɨ gau kalɨp manö hag ñaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Anɨg hageia, bɨ God sabe gep ram abad mɨdeila bɨ kub kale u, bɨ nɨpe rɨmnap kalɨp uɫ göm, bɨ Jisas manö ud arep anɨb gau kalɨp udnɨg arla. Amöm, Jerusalem nɨbi bɨ gai i hanɨp kabö ju paknaböl, a göm, kalɨp hag gagla; agamɨj uɫ gɨ daula. ");
INSERT INTO kpw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jisas manö ud arep bɨ gau kalɨp agamɨj uɫ gɨ Kansol ap magum gɨ mɨdeila aŋ au daulö, God nɨp nan sabe gep bɨ kub yabɨƚ u kalɨp haga, ");
INSERT INTO kpw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kalöp, Jisas manö u hagagmim, a gun, manö kƚö gɨ hagun hagpun u pen hag wasö nɨŋun arö gɨpun. Kale pen am Jerusalem nɨbi bɨ kalɨp magöŋhalö Jisas manö u hag ñöl gɨ, hanɨp hagpim, ‘Kale nöp Jisas nɨp al pak lɨbal,’ a gɨpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Anɨg hageia, Pida bɨ Jisas manö ud arep rɨmnap aip hagla, “Nɨbi bɨ manö hagpal u udagnabun; God manö nɨpe u nöp udnabun! ");
INSERT INTO kpw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jisas nɨp mab ba laŋ al pak lɨbe uma u pen, apɨs bac bɨ sabe gɨmɨdal God u nöp gö, kauyaŋ uraka. ");
INSERT INTO kpw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uraköm, God nɨpe gö, am ram mɨnöŋ kumi kabö adö laŋ au amöm, God ñɨmagö yɨjɨg lau adö mɨdöp. Anɨb u hon nɨŋbun, nɨpe nöp Kiŋ mɨdöm, hanɨp ud kamɨŋ yunab. Nɨpe hanɨp Isrel nɨbi bɨ mög nɨŋöm, nan si nan naij gɨpun u, nɨhön gɨnɨg anɨg gɨpun, a gun, arö gɨno, nɨpe nɨŋöm nan naij gɨpun u arö göm, hanɨp ud kamɨŋ yunab. ");
INSERT INTO kpw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God göp anɨbu, hon amgö magö rɨmɨd mɨgan hon ke nɨŋun, nɨbi bɨ gau kalɨp hag ñabun. Nɨbi bɨ manö nɨpe nɨŋ udöm hagöp rö nöp gɨnaböl gau, God nɨpe Ana Uɫ u kalɨp ñö, nɨpe kalɨp u rö nöp manö aij anɨbu hag ñɨ aij gö nɨŋnaböl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bɨ Jisas manö ud arep gau anɨg hageila, bɨ manö ud asɨkep ap magum gɨ mɨdeila anɨb gau kal juöm hagla, “Kalɨp böŋ nöp al pak lun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Anɨg hagla u pen, aŋ anɨb au bɨ ap mɨdeia, hib nɨpe u Gameliel. Nɨpe bɨ Perisi, lo manö hag ñeb bɨ kale ap. Juda nɨbi bɨ magöŋhalö nɨp nɨŋlö aij a gɨmɨdöp. Bɨ Gameliel anɨbu uraköm haga, “Bɨ ugan anɨbi kalɨp hagpe höŋ aröl. Yad kalöp manö ap hag ñɨn,” a ga. Anɨg hagö, bɨ anɨb gau hag höŋ yula. ");
INSERT INTO kpw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bɨ anɨb gau hag höŋ yulö nɨŋöl gɨ, Gameliel nɨpe bɨ Kansol gau kalɨp haga, “Isrel bɨ gai i, kale bɨ gai i kalɨp nɨhön gɨnɨg gabim u, gasɨ nɨŋ aij gɨmim gɨmim. ");
INSERT INTO kpw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kale nɨŋbim, nöd bɨ Dudas, yad bɨ kub a göm hagö, manö nɨpe hagmɨdöp u nɨbi bɨ iru nöp, po hadred rö, nɨŋ udmɨdal. Pen hainö bɨ rɨmnap nɨp al pak lɨlö, nɨbi bɨ manö nɨp nɨŋ udmɨdal gau ke ke arla pɨs ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pen hainö, hib hon udla ñɨn u, u rö nöp bɨ Judas Galili nɨbö u haga, ‘Hon gapman gau aip pen pen gun, kalɨp rɨdɨk gɨ yunabun,’ a ga. Anɨg hagö, nɨbi bɨ iru nöp manö nɨp udöm, urak gapman aip pen pen gɨla. Pen mɨd damöm, bɨ anɨbu nɨp u rö nöp al pak lɨlö, nɨbi bɨ manö nɨp nɨŋ udmɨdal gau ke ke arla pɨs ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anɨb u me, yad kalöp hagabin, bɨ manö kub hagabun gai i kalɨp gɨ naij gagmim. Kalɨp yɨharɨŋ hag yube aröl. Manö kale ke nöp hagnaböl u, kub gɨnɨm a gɨ wasö nɨŋöm ap lugnab. ");
INSERT INTO kpw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pen God nɨpe ke hagö gɨnaböl u, kale ke nöp nan ap gɨmim rö lagnab. Kalɨp gɨ naij gun, a gɨnabim u, kalɨp aip pen pen gagnabim; God aip pen pen gɨnabim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gameliel anɨg hagö, bɨ gau haga rö nɨŋöm, bɨ Jisas manö ud arep gau kalɨp haglö aueila, kalɨp nagɨ ud rapɨn pakus paköm, “Jisas manö u hainö hagagmim, wasö yabɨƚ,” a göm, kalɨp hag yulö arla. ");
INSERT INTO kpw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pen bɨ Jisas manö ud arep gau, hanɨp nɨhön gɨnɨg anɨg gɨpal, a göm, nɨŋagla. God hanɨp Jisas bɨ nɨpe kabö göl a göm gö, hanɨp anɨg gaböl, a göm, aij a gö nɨŋöl gɨ, Kansol kub anɨbu arö göm arla. ");
INSERT INTO kpw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amöm, pör pör God sabe gep ram höŋ adö au amöm, ram ram gau amöm, Jisas nɨpe Krais u manö aij u hag ñɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pen mɨd damöm, nɨbi bɨ Jisas nɨp nɨŋ udla gau iru yabɨƚ mɨdeila. Pen Juda nɨbi bɨ Grik manö nöp nɨŋla gau, Juda nɨbi bɨ Aremeik manö yɨdun göl nɨŋla gau, kalɨp hag göm hagla, “Nɨbi adu kale gau kalɨp mani nan magö nan gau nɨme lɨ ñɨ aij gɨpal pen nɨbi adu hon gau kalɨp nɨme lɨ aij gagpal,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anɨg hageila, bɨ Jisas manö ud arep unbö mɨgan laŋ gau nɨŋöm, nɨbi bɨ Jisas nɨŋ udla gau magöŋhalö wɨñ allö aueila hagla, “Añ mam bɨ. Hon God Manö hag ñɨbun u arö gun, nɨbi bɨ gau kalɨp nan nɨme lɨ ñɨnabun u, kabö rö gagnab. ");
INSERT INTO kpw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Anɨb u, kale bɨ unbö mudun jɨŋ nɨŋmim hag lɨbe, kalɨp wög anɨbu hag lɨno, wög anɨbu gɨnaböl. Pen God Ana kalɨp ajmaŋ rauöm gasɨ aij ñöb bɨ gau nöp nɨŋmim hag lɨmim. ");
INSERT INTO kpw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hon pen God nɨp sabe göl gɨ, nɨbi bɨ gau kalɨp God Manö u hag ñöl gɨ, gɨ mɨdeinabun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Manö hageila anɨbu nɨŋlö, kalɨp magöŋhalö aij a gö, bɨ unbö mudun jɨŋ hag lɨla. Bɨ anɨb gau me: ap Sɨdipen u. Sɨdipen nɨpe God nɨp nɨŋ ud pɨdöŋ yabɨƚ gɨmɨdöp. Ana Uɫ nɨp ajmaŋ rau mɨdmɨdöp. Ap Pilip u, ap Prokoras u, ap Naikena u, ap Dimon u, ap Pamenas u, ap Nikolas u. Nikolas nɨpe daun kub Adiok nɨbö. Nɨpe nöd bɨ Juda wasö u pen hainö Juda nɨbi bɨ gasɨ nɨŋla rö nɨŋ uda. Pen hainö nɨpe Jisas nɨp nɨŋ uda. ");
INSERT INTO kpw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɨ unbö mudun jɨŋ anɨb gau hag löm, kalɨp dam bɨ Jisas manö ud arep bɨ gau mɨdeila au daulö, kale God nɨp sabe göm, ñɨmagö nabɨc kalɨp adö laŋ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pen kale God Manö hag ñɨlö, arö nɨŋöl gɨ, Jerusalem nɨbi bɨ iru yabɨƚ nöp Jisas nɨp nɨŋ udla. Pen bɨ God nɨp nan sabe gep bɨ gau iru yabɨƚ nöp Jisas manö aij u nɨŋöm nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God nɨpe Sɨdipen nɨp ud aij yabɨƚ göm, pɨdöŋ nɨpe nɨp ñö, Sɨdipen nɨpe nan gagep rö gau, nan nɨŋeb nɨŋagep gau, iru nöp nɨbi bɨ mɨdeila aŋ gau gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pen Juda nɨbi bɨ ram mɨnöŋ ke ke gau nɨbö rɨmnap apöm Juda magum gep ram ap apöm God nɨp sabe gɨmɨdal; Juda magum gep ram anɨbu, “Mɨñi Nagɨ Mɨdagpun Ram” a gɨmɨdal. Bɨ Juda anɨb gau, rɨmnap Sairini daun nɨbö, rɨmnap daun kub Aleksadria nɨbö, rɨmnap Silisia Propins nɨbö, rɨmnap Esia Propins nɨbö. Kale Sɨdipen ga rö nɨŋöm, kƚö yabɨƚ göm nɨp manö pen pen hagla u pen, ");
INSERT INTO kpw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God Ana nɨpe Sɨdipen nɨp gasɨ aij yabɨƚ ñö nɨŋöl gɨ, bɨ Juda gau nɨp manö nɨhön hagla u, gasɨ nɨŋ aij göm pen u rö nöp manö aij yabɨƚ hagö, nɨp pen hagöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pen kale Sɨdipen nɨp hag wasö nɨŋöm, am bɨ manö pir alep rɨmnap kalɨp agamɨj hag aij gɨlö, kale apöm hagla, “Hon nɨŋbun, bɨ i nɨpe Mosɨs manö kalɨ kƚiñ rɨka u hag juöm, God nɨp hag juöm göp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kale manö piral anɨbu hageila, nɨbi bɨ yɨharɨŋ gau löm, bɨ manö ud asɨkep gau löm, bɨ lo manö hag ñeb bɨ gau löm, hibur kalɨp u naij gö, Sɨdipen nɨp manö kub hagnɨg dam Juda Kansol kub mɨdeila gau ud arla. ");
INSERT INTO kpw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Damöm, bɨ manö pir alep rɨmnap halö daulö, kale hagla, “Hon nɨŋbun, bɨ anɨbi pör nöp God sabe gep ram uɫ i hag juöm, Mosɨs lo manö kalɨ kƚiñ rɨka u hag juöm göp. ");
INSERT INTO kpw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pen nɨpe manö ap pen haga nɨŋno u, haga, ‘Jisas bɨ Nasared nɨbö u, hainö God sabe gep ram i gɨ naij göm, geinab, Mosɨs manö hanɨp hag ña gɨpun u arö gun, manö hain nɨbö udun hain gɨnabun,’ a ga,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pen Juda Kansol kub mɨdeila bɨ gau, Sɨdipen nɨp nɨŋ ij halö löm nɨŋla, mulu adɨŋ nɨpe u ejol mulu adɨŋ rö la. ");
INSERT INTO kpw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kale manö piral anɨg haglö, God nɨp nan sabe gep bɨ kub yabɨƚ u Sɨdipen nɨp haga, “Manö nöp hagpal anɨbu nɨŋö hagpal aka pir albal?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Hageia, Sɨdipen haga, “Bapi mam bɨ, nɨŋim! Bac iƚaŋ hon Ebraham hadame nöp daun kub Haran araga adö u, ram mɨnöŋ Mesopodemia mɨdeia magö u, God mailö aij ke halö mɨdöp u nɨp haga, ");
INSERT INTO kpw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ram mɨnöŋ ne i arö gɨmön, nɨbi bɨ ne gau arö gɨmön, ram mɨnöŋ ke yad nöp yamnabin u armön,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Hageia, Ebraham ram mɨnöŋ kub Kaldia mɨdmɨdöp u arö göm, daun kub Haran am mɨdmɨdöp. Hainö Ebraham nap umö, God hagö, ap ram mɨnöŋ kale mɨdpim aui mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñɨn anɨbu God Ebraham nɨp mɨnöŋ naböŋ mɨgan ap hagaga. Apöm yɨharɨŋ nöp mɨdmɨdöp. Ñɨn anɨbu Ebraham ñɨ pai ap rɨkaga; yɨharɨŋ nöp mɨdmɨdöp. Pen God Ebraham nɨp haga, ‘Hainö mɨnöŋ naböŋ anɨbi, ne udnabön. Ñɨ pai ne yag daunabön yag daulö arnab gau, mɨnöŋ naböŋ anɨbi u rö nöp udöm mɨdeinaböl,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pen God manö ap hagöm haga, ‘Ñɨ pai ne yag daunabön yag daulö arnab gau, am nɨbi bɨ rɨmnap ram mɨnöŋ gau mɨdlö, kalɨp magöŋhalö nagɨ löm, gɨ naij yabɨƚ göm, nagɨ wög rö hag lɨlö, gɨlö nɨŋöl gɨ, mɨ unbö po hadred (400) innab. ");
INSERT INTO kpw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pen nɨbi bɨ kalɨp anɨg geinaböl gau, yad pen pe kalɨp gɨ naij gɨnabin. Nɨbi bɨ ne gau, ram mɨnöŋ anɨbu arö göm, ap yɨp sabe göl gɨ mɨdeinaböl ram mɨnöŋ i,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pen God Ebraham nɨp manö ap hag löm haga, ‘Ñɨ pai ne yag daunabön yag daulö arnab gau, kalöp abad mɨdeinabin u me, ñɨŋaŋ hagape bɨ waŋ hañ rɨb gɨ dö gɨmim,’ a ga. Hagö, hainö Ebraham ñɨ nɨpe Aisak nɨp yag dapöm, ñɨn unbö mudun jɨŋ mɨdöm, ñɨn raleb u ñɨ u nɨp waŋ hañ rɨb gɨ dö ga. Aisak pen Jekop nɨp yag daua. Jekop nɨpe pen ñɨ unbö mɨgan laŋ gau kalɨp yag dauö me, hon Isrel nɨbi bɨ iƚ ke ke mɨdpun. ");
INSERT INTO kpw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bac iƚaŋ hon anɨb gau, nɨmam nañɨ bɨ gau nɨmam hain Josep nɨp gasɨ naij nɨŋlö, mulu lugö, bɨ rɨmnap ñɨlö, nɨp rau dam ram mɨnöŋ Ijip ud arla. Ud arlö, mɨd aij gaga u pen God nɨp hauƚ gaga. ");
INSERT INTO kpw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nan mɨŋör Josep nɨp auaia u, God nɨpe nɨŋöm Josep nɨp abad mɨd aij gɨmɨdöp. God nɨpe Josep nɨp gasɨ aij ñöm gö, Ijip Kiŋ Pero, bɨ Josep i gasɨ nɨŋ aij yabɨƚ göp, a göm, nɨp hagö, mɨnöŋ naböŋ Ijip abe, ram nan nɨpe gau magöŋhalö abe abad mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Hainö ñɨn ap kɨyö kub yabɨƚ u, ram mɨnöŋ Ijip abe, ram mɨnöŋ hon Kenan i abe auö, bac hon ram mɨnöŋ Kenan i mɨdeila gau nan magö uƚhai nɨŋöm, nan ñɨŋeb ap mɨdageia, gasɨ mɨlö yabɨƚ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pen nap kale Jekop manö ap nɨŋa, nan magö iru nöp ram mɨnöŋ Ijip mɨdeia. Anɨb u nɨŋöm ñɨ nɨpe gau kalɨp hagö, nan magö raunɨg Ijip arla. ");
INSERT INTO kpw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Am rau dapöm, ñɨŋ pɨs göm, kauyaŋ pen raunɨg arla. Arlö, nɨmam Josep kalɨp haga, ‘Mam bɨ, kale yɨp ban a gɨmim nɨŋbim? Yad namam kale Josep nöp,’ a ga. Hageia, Ijip Kiŋ Pero manö anɨbu nɨŋöm haga, ‘U Josep nɨmam bɨ nɨpe gau e!’ ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep pen, bap yad Jekop, nɨbi bɨ nɨpe gau aip yɨŋɨd auöl, a göm, manö hag yuö, nap Jekop nɨbi bɨ ñɨnjuöl mɨhau nɨgaŋ ado gɨ da ajɨp böŋ daŋ (75) rö udöm, aip arla. ");
INSERT INTO kpw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nap Jekop anɨg göm, ram mɨnöŋ Ijip am mɨdöm, uma. Mɨd damöm, bac bɨ anɨb gau magöŋhalö um hakla. ");
INSERT INTO kpw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pen hainö ñɨ kale gau nap le damöm, daun kub Sekem rɨgöl gɨla. Wip rɨgöl anɨbu, bac iƚaŋ Ebraham, Hemor ñɨ nɨpe gau kalɨp mani ap ñöm raua. ");
INSERT INTO kpw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pen God Ebraham nɨp nöd gɨnabin, a göm, manö hag la rö gɨnɨg göm ga u me, nɨbi bɨ hon Isrel ram mɨnöŋ Ijip mɨdeila gau, ñɨ pai rɨk damöm rɨk dam dapɨl göm, iru yabɨƚ nöp mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nɨbi bɨ hon Isrel iru nöp mɨdeila ñɨn anɨbu, ram mɨnöŋ Ijip u kiŋ hain nɨbö waiö la. Kiŋ hain nɨbö anɨbu bac Josep nɨp nɨŋaga u me, ");
INSERT INTO kpw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","nɨbi bɨ hon gau gɨ naij yabɨƚ göm, manö kƚö hagö, ñɨ pai kale gau yag dapöm, höŋ adö gau yulö, ke mɨdöm ummɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Anɨg gɨla u pen, ñɨn aŋ anɨb au, ber mɨhöp ñɨ hañ aij ke nɨbö ap yag dapil, hib nɨpe Mosɨs a gɨlö. Ñɨ anɨbu nɨp rakɨn mɨhau nɨgaŋ ram raul mɨgan gau nöp pi gɨlö mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hainö ñɨŋaŋ anɨbu nɨp dam höŋ au yaŋ lɨlö, Pero pai nɨpe u apöm, nɨp nɨŋöm, dam ñɨ yad, a göm, kabö laumɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nɨpe anɨg göm kabö lauö, kub gö, Ijip nɨbi bɨ kale nɨhön nɨhön gɨmɨdal u, nɨp hag ñɨ aij gɨla. Nɨpe bɨ manö kƚö gɨ hagöm, wög kƚö göm gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pen Mosɨs mɨ nɨpe unbö ñɨnjuöl mɨhöp (40) inö, nɨbi bɨ yad Isrel kalɨp am nɨŋem auɨn a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pen amöm nɨŋa, Ijip bɨ ap Isrel bɨ ap nɨp mɨñu magö pakaia. Mosɨs nɨŋöm, bɨ Isrel nɨp ud kamɨŋ yuöm, Ijip bɨ u nɨp böŋ nöp al pak lö uma. ");
INSERT INTO kpw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pen Mosɨs gasɨ nɨpe nɨŋa u, ‘Nɨbi bɨ yad Isrel hagnaböl, “God Mosɨs nɨp gasɨ ñö, apöm hanɨp ud asɨk yuö, mɨd aij gɨnabun,” a gɨnaböl,’ a gɨ nɨŋa u pen kale gasɨ anɨbu nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pen ruö Mosɨs amöm nɨŋa, Isrel bɨ mɨhöp pen pen gailö. Anɨg gɨlö nɨŋöm haga, ‘Bɨ me, kale mamil mɨhau mɨdpil; pen pen gabil u arö gɨl!’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Hageia, bɨ ap bɨ ap nɨp pakaia u, Mosɨs nɨp ud gɨdaŋ yuöm haga, ‘Ne an hagö, bɨ kub mɨdmön, halɨp bɨ manö ud asɨkep rö abad mɨdpan? ");
INSERT INTO kpw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ne rol Ijip bɨ u al pak lɨna u, mɨñi yɨp pen al pak lɨnɨg hagabön aka?’ ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Anɨg hagö, Mosɨs bɨ al pak lɨbin anɨbu nɨŋbal, a göm, pɨñɨŋ gɨ am ram mɨnöŋ Midian amöm, bɨ yɨharɨŋ ap rö mɨdmɨdöp. Ñɨn aŋ anɨb au, nɨpe nɨbi udöm, ñɨ mɨhöp yag daua. ");
INSERT INTO kpw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Anɨg göm yɨharɨŋ nöp mɨdö mɨ ñɨnjuöl mɨhöp (40) ina. Hainö ñɨn ap ram mɨnöŋ kabö nöp mɨdöp Sainai Dum söl au mɨdöm nɨŋa, ejol ap apöm, mab ur añɨ ap mɨɫaŋ geia aŋ au waiö lö nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Anɨg geia Mosɨs nɨŋöm, nan anɨbu nɨhön göp, a göm, am söl au apöm nɨŋö nɨŋöl gɨ, Bɨ Kub haga, ");
INSERT INTO kpw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nahai iƚaŋ Ebraham, Aisak, Jekop, God kale yad mɨdpin,’ a ga. Anɨg hageia, Mosɨs, u Bɨ Kub nöp hagab, a göm, pɨñɨŋ göm gɨl gɨl göm, he göm amgö nɨŋaga. ");
INSERT INTO kpw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Pen Bɨ Kub Mosɨs nɨp haga, ‘Mɨnöŋ naböŋ uɫ i am mɨdpan rö, ma rɨrup ne u ud asɨk. ");
INSERT INTO kpw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ijip nɨbi bɨ gau nɨbi bɨ yad Isrel kalɨp gɨ naij yabɨƚ gɨpal, yad nɨŋbin. Kale mɨɫöŋ gaböl u apdi nɨŋem, apem kalɨp ud asɨk yunɨg aubin. Anɨb u, ne ado gɨ Ijip armön,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Isrel nɨbi bɨ nöd Mosɨs nɨp hagla, ‘Ne an hagö, bɨ kub mɨdmön, halɨp bɨ manö ud asɨkep rö abad mɨdpan?’ ö gɨla. Pen hainö, God ejol nɨpe hag yuö apöm, mab bɨd mɨɫaŋ geia aŋ au Mosɨs nɨp waiö lö, God nɨpe ke Mosɨs nɨp nɨbi bɨ kub kale mɨdöm kalɨp ud asɨk yuaŋ a göm, hag yua. ");
INSERT INTO kpw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pen Mosɨs Ijip aramöm, nan gagep rö rɨmnap gau göm, nɨbi bɨ nɨpe Isrel kalɨp udöm ñɨg solwara ‘Aɫɨ’ a gɨpal u amöm, nan gagep rö rɨmnap gau göm, hainö Isrel nɨbi bɨ uɫ gɨ dam ram mɨnöŋ aipɨƚ nöp aŋ gau aramöm, nan gagep rö rɨmnap gau göl gɨ mɨdmɨdöp. Anɨg gɨ mɨdö mɨdö, mɨ ñɨnjuöl mɨhöp (40) ina. ");
INSERT INTO kpw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosɨs nɨpe nöp me nɨbi bɨ Isrel kalɨp haga, ‘God nɨpe bɨ manö nɨpe hagep ap, ñɨ kale ke bɨ yad rö ap, hag yuö, kalöp aunab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosɨs nɨpe ram mɨnöŋ aipɨƚ nöp aŋ gau mɨdeia; nɨpe apɨs bac hon aip mɨdeia; Sainai Dum gau ejol ap apöm Mosɨs nɨp manö hag ña. Mosɨs manö anɨbu udöm hon Isrel nɨbi bɨ hag ñɨnab, a göm, God nɨpe manö kamɨŋ anɨbu Mosɨs nɨp ña. ");
INSERT INTO kpw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mosɨs manö kamɨŋ anɨbu hag ña u pen bac hon gau manö anɨbu udagla. Kale Mosɨs nɨp hag juöm, ado gɨ Ijip arun, a göm, gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mosɨs nɨmam Eron nɨp hagla, ‘Bɨ ne Mosɨs hanɨp Ijip nɨbö dauub u, nɨp nɨhön göp u nɨŋagpun. Anɨb u, ne hanɨp nan god rö rɨmnap gö, bɨ hon rɨmnap god gɨnabön anɨb gau ud nöd arlö, hon hain arun,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ñɨn anɨbu nöp, god piral kaj kau pi rö ap gɨ löm, yaur nan gau pak dap sabe gɨ ñɨla. Kale ñɨmagö kale gɨla u nɨŋöm, u god hon a göm, mɨñ mɨñ göl gɨ nan kub lau ñɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Anɨg geila, God kalɨp arö göm haga, ‘Anɨg gɨpal u, sɨdö, rakɨn, gapɨ gau haƚöwaƚö sabe gɨlaŋ,’ a ga. Ñɨn anɨbu kale nan anɨb gau nöp sabe gɨla u me, bɨ God manö hagep ap God Manö u kalɨ kƚiñ rɨköm haga, ‘Isrel nɨbi bɨ. Kale nöd mɨ ñɨnjuöl mɨhöp ram mɨnöŋ aipɨƚ nöp aŋ gau ajmɨdim ñɨn u, kaj kau kaj sipsip nan gau pak yɨp sabe gɨ ñagmɨdim. ");
INSERT INTO kpw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kale nan yɨharɨŋ piral mɨhöp kale ke gɨpe u nɨp nan pak sabe gɨ ñɨ mɨdöl gɨ, gɨ mɨdmɨdim. Nan anɨbu, ap Molok a gɨmɨdim, ap gapɨ rö gɨ lɨmim, Repan a gɨmɨdim. Nan god piral anɨb mɨhau nöp, sel ram gɨ ud ajöl gɨ, sabe göl gɨ mɨdmɨdim. Gɨ mɨdmɨdim anɨbu, yad kalöp hag yunö, am nagɨ mɨdeinabim daun kub Babilon ba lau,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bac bɨ hon gau ram mɨnöŋ aipɨƚ gau mɨdeila ñɨn u sel ram ud ajmɨdal. Sel ram anɨbu mɨdeia u nɨŋöm, God hon aip mɨdöp a göm nɨŋmɨdal. Sel ram anɨbu, God manö haga rö nöp gɨ lɨlö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hainö Josua bac bɨ hon aip sel ram anɨbu nap bɨ kale nɨbö udla. Hainö, kale sel ram anɨbu daueilö nɨŋöl gɨ, God nɨpe nɨbi bɨ ram mɨnöŋ aui mɨdeila gau yu gɨ yua. Sel ram anɨbu mɨdöm, mɨd damöm, hainö Depid yag daula. ");
INSERT INTO kpw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Bac Depid, bɨ God nɨŋö aij ga bɨ u, nɨpe God nɨp hag nɨŋöm haga, ‘Ne yau a gö, yad ram nöp aij ap gɨ lɨnö, ne God Jekop nöd sabe gɨmɨdöp u, ram anɨbu mɨdeinabön,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hageia pen God nɨpe yau a gaga. Hainö Solomon nɨpe God sabe gep ram anɨbu gɨ la. ");
INSERT INTO kpw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pen God adö i gɨlaŋ mɨdöp u, nɨbi bɨ ñɨmagö udöm gɨ lɨnaböl ram gau mɨdageinab. Bɨ God manö hagep ap manö anɨbu hagöm haga, ");
INSERT INTO kpw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bɨ Kub u haga, “Ram mɨnöŋ kumi kabö adö laŋ au sea kiŋ yad rö adö au asɨk mɨdem, mɨnöŋ naböŋ iƚ i ma yad abö gɨ löl gɨ mɨdpin. Yɨp nɨhön ram gɨ lɨbe, yad han mɨdeinam? Yad ram auai ake lɨnam? ");
INSERT INTO kpw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nan gau magöŋhalö ñɨmagö yad ke gɨ lagpin aka?” ga,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Hon ke nɨŋ aij gɨpun a gɨmim, nan si nan naij nöp gɨmim, God Manö nɨŋagpim. Nahai bɨ gɨmɨdal rö nöp gɨpim. Ana Uɫ nɨpe kalöp gasɨ aij ñö nɨŋbep, pen pör wasö gɨpim. ");
INSERT INTO kpw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nahai bɨ gau, bɨ God manö hagep gau kalɨp magöŋhalö gɨ naij gɨla. Bɨ God manö hagep hadame gau, ‘God Bɨ Wög Gɨ Ñeb aij yöl u aunab,’ a gɨla. Pen nahai bɨ gau kale bɨ anɨb gau u rö nöp al pak lɨla. Pen mɨñi God Bɨ Wög Gɨ Ñeb aij yöl anɨbu auö me, kale nɨp mumug nɨŋmim al pak lɨbe. ");
INSERT INTO kpw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pen God lo manö nɨpe u, ejol nɨpe gau kalɨp hag yuö daulö udpe, pen hagöp rö nɨŋmim gagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sɨdipen manö anɨbu hagö nɨŋöl gɨ, kalɨp mulu kal yabɨƚ lugö, meg magö hau rɨbɨköm kal jula. ");
INSERT INTO kpw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pen Ana Uɫ nɨpe Sɨdipen ajmaŋ rau mɨdö nɨŋöl gɨ, nɨpe gɨlaŋ gɨ nɨŋöm kumi kabö adö laŋ au nɨŋa, God mailö aij unbö ke yabɨƚ nɨpe mɨdeia nɨŋöm Jisas nɨpe God ñɨmagö yɨjɨg kɨd lau adö urak mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sɨdipen nɨŋöm haga, “Nɨŋim! Yad nɨŋabin, kumi kabö adö laŋ au ajöŋ hiɨk mɨdöp. Bɨ Ñɨ nɨpe u God ñɨmagö yɨjɨg kɨd lau adö urak mɨdöp!” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sɨdipen anɨg hagö, rɨmɨd kale u ñɨmagö ud pɨƚ göm, adɨŋ magöŋhalö uraköm, manö bƚaƚö göm manö kub yabɨƚ hagöm, gɨ dö gɨ am nɨpe mɨdeia arla. ");
INSERT INTO kpw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nɨp ud sɨsɨ löm, dam dam daun kub anɨbu höŋ adö yaŋ ud arla. Bɨ nɨp manö pir alla gau kal juöm, waƚɨj mɨlö kale gau ud juöm, bɨ praj Sol mɨdeia söl au yulö, nɨpe abad mɨdö nɨŋöl gɨ, kale Sɨdipen nɨp kabö ju pakla. ");
INSERT INTO kpw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nɨp anɨg göl paklö nɨŋöl gɨ, Sɨdipen Bɨ Kub nɨp wɨñ al hagöm haga, “Bɨ Kub Jisas, ana magö yad ud,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Anɨg hagöm, kugom yɨmöm, wɨñ kub al hagöm haga, “Bɨ Kub! Yɨp al pak laböl i, nan si nan naij gaböl u nɨŋmön arö gɨmön,” a ga. Anɨg hagöl göm uma. ");
INSERT INTO kpw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɨdipen nɨp kabö ju pak lɨla ñɨn u, Sol söl au mɨdöm, paj hagöm obi oƚeƚe ga. Ñɨn anɨbu nöp, Jerusalem kai iƚ göm, nɨbi bɨ Jisas nɨŋ udla gau kalɨp gɨ naij yabɨƚ gɨla. Anɨg gɨlö, nɨbi bɨ Jisas nɨp nɨŋ udla gau kale magöŋhalö pɨñɨŋ gɨ, ram mɨnöŋ Judia gau abe, ram mɨnöŋ Sameria gau abe, ke ke arla. Pen bɨ Jisas manö ud arep unbö mɨgan laŋ gau kale nöp Jerusalem mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pen God Manö hagöp rö nöp gɨmɨdal bɨ rɨmnap, Sɨdipen nɨp mög yabɨƚ gö, mɨɫöŋ kub yabɨƚ göl gɨ, wip dam rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol pen, nɨbi bɨ Jisas nɨŋ udpal gau gɨ naij yabɨƚ gɨnabin, a göm, ram ram göl gɨ, nɨbi bɨ anɨb gau kalɨp haƚöwaƚö ɫɨp gɨ dam nagɨ lɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nɨbi bɨ Jisas nɨp nɨŋ ud mɨdeila gau pɨñɨŋ gɨ am ram mɨnöŋ ke gau gau mɨdeila. Pen anɨb gau am mɨdöm, Jisas manö aij u dam nɨbi bɨ anɨb gau kalɨp hag ñɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Bɨ ne Pilip u rö nöp am daun kub ap ram mɨnöŋ Sameria au mɨdöm, nɨbi bɨ gau kalɨp, Mesaia aua manö aij u hag ña. Pilip manö haga u abe, nan gagep rö ga u abe nɨŋöm, manö nɨpe nɨhön nɨhön haga u, rɨmɨd lɨ nɨŋ aij yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nɨpe nɨbi bɨ kɨjaki aiön pi halö mɨdeila gau iru nöp gö, nan anɨb gau aiö göm höŋ arla. Nɨpe nɨbi bɨ ñɨmagö ma pɨno gö kɨƚa ga gau iru nöp abe, nɨbi bɨ ma gɨ ga be wa be ga gau iru nöp abe kalɨp gö, kamɨŋ la. ");
INSERT INTO kpw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Anɨg gö nɨŋöl gɨ, nɨbi bɨ daun anɨbu hanmɨdeila gau magöŋhalö mɨñ mɨñ yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pen daun kub anɨbu bɨ ap hanmɨdöp, hib nɨpe u Saimon. Nɨpe kuj göm, nan gagep rö rɨmnap gö, Sameria nɨbi bɨ gau magöŋhalö gasɨ iru yabɨƚ nɨŋmɨdal. Yad bɨ kub yabɨƚ mɨdpin, a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Saimon nɨpe anɨg geia, nɨbi bɨ hib mɨdeia gau abe, nɨbi bɨ hib mɨdageia gau abe, Saimon manö haga rö nöp nɨŋöm hagla, “Bɨ anɨbi nɨpe god ‘Kƚö Kub’ a gɨpun u nöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nan gagep rö gau pör gɨmɨdöp nɨŋöm nɨbi bɨ gau gasɨ iru nɨŋöm, manö haga rö nöp nɨŋmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pen hainö Pilip apöm, God nɨbi bɨ udöm ram nɨpe kumi kabö laŋ au abad mɨdeinab manö aij u abe, Jisas Krais manö aij nɨpe u abe, hag ñö, nɨbi bɨ gau kale manö nɨpe nɨŋ udöm, ñɨg pakla. ");
INSERT INTO kpw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon nɨpe ke u rö nöp, Jisas nɨp nɨŋ udöm ñɨg paka. Pilip arö, Saimon nɨp hain gö nɨŋöl gɨ, Pilip nan gagep unbö ke rö gaia u nɨŋöm, Saimon nɨpe aiö waiö ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bɨ Jisas manö ud arep gau Jerusalem mɨdlö nɨŋöl gɨ, kalɨp manö ap hagla, “Sameria nɨbi bɨ God Manö nɨŋ udpal,” a gɨla. Kale manö anɨbu nɨŋöm, Pida Jon kalɨp mɨhöŋ hag yulö, ram mɨnöŋ Sameria arlö. ");
INSERT INTO kpw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Ammil nɨŋlö, nɨbi bɨ gau Jisas nɨp nɨŋ udlö, Bɨ Kub Jisas hib hagöm kalɨp ñɨg pak ñɨla u pen Ana Uɫ nɨpe kalɨp auaga. Anɨb u, Pida Jon bɨ mɨhöŋ, Ana Uɫ nɨpe kalɨp auaŋ, a gɨmil, sabe gɨmil, ñɨmagö nabɨc cög kalɨp adö laŋ lɨlö, Ana Uɫ nɨpe kalɨp añɨ añɨ aua. ");
INSERT INTO kpw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kalpe mɨhöŋ ñɨmagö nabɨc cög adö laŋ lɨlö, God nɨpe Ana Uɫ nɨbi bɨ gau kalɨp ña u, Saimon nɨŋöm, yad u rö nöp gɨnam, a göm, kalɨp mɨhöŋ mani yamöm haga, ");
INSERT INTO kpw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mani i udmil, yɨp pɨdöŋ anɨbu ñɨlö, yad nɨbi bɨ an an ñɨmagö yad nabɨc cög adö laŋ lɨnö, kale u rö nöp Ana Uɫ udnaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Anɨg hageia, Pida haga, “God nan aij nɨpe yɨharɨŋ ñöb anɨbu, nɨhön gɨnɨg mani raunɨg gabön? Mani anɨbu ne ke pɨg hij gɨ lugnab! ");
INSERT INTO kpw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wög hol gɨpul u ne aip wasö. Hibur gasɨ mɨdmagö ne nɨŋ ud mɨdpan u, God nɨŋö aij gagöp. ");
INSERT INTO kpw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nan si nan naij gɨnam, a gɨmön, gasɨ nɨŋban u arö gɨmön, God nɨp sabe geinabön u, gasɨ naij yabɨƚ nɨŋban anɨbu nɨŋöm arö gɨnɨm rö löp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yad nɨŋbin, nan aij kale au nan yad rö mɨdböp a gɨmön, nɨŋmön, gasɨ naij nɨŋmön, nan si nan naij gɨ mɨdpan. Anɨb u, ne nan si nan naij gep magö u, nagɨ wög gep bɨ rö mɨdpan. ");
INSERT INTO kpw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hageia, Saimon haga, “Köl mɨhöŋ Bɨ Kub u nɨp sabe gɨlö, nan yɨp gɨnɨm rö löp, a gɨmil hagabil anɨbu gagnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pen Pida aip Jon aip, Jisas kalɨp mɨhöŋ nɨhön nɨhön ga manö u abe, Bɨ Kub manö aij u abe, nɨbi bɨ gau kalɨp hag ñɨ pɨs göm, ado gɨ Jerusalem arnɨg, adan nab gau amöl gɨ, ram mɨnöŋ Sameria aŋ au ram rɨƚɨg agƚö iru nöp nɨbi bɨ gau kalɨp Jisas manö aij u hag ñöl gɨ arlö. ");
INSERT INTO kpw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pen Bɨ Kub ejol ap apöm Pilip nɨp haga, “Jerusalem nɨbö daun kub Gasa arbal adan mɨlö u arammön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hagö, Pilip adan haga mɨlö anɨbu amöm nɨŋa, bɨ kub ap, kaj hos ɫɨp gɨ dam ajöp nan bad adö laŋ asɨköm, adan mɨlö anɨbu areia. Bɨ anɨbu nɨpe nɨbi kwin Kadaki, ram mɨnöŋ kub Idiopia abad mɨdeia nɨbi u nɨp wög göl gɨ, mani nɨpe u abad mɨdmɨdöp. Pen nɨpe Jerusalem God sabe gep ram u amöm sabe göl gɨ mɨd pɨs göm, ");
INSERT INTO kpw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ado gɨ ram mɨnöŋ Idiopia aramöm, God Manö adɨŋ Aisaia kalɨ kƚiñ rɨka u udöm, amgö lɨ nɨŋöl gɨ areia. ");
INSERT INTO kpw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pen God Ana Pilip nɨp haga, “Hos nan bad ɫɨp gɨ dam arab daŋ am söl ba au ammön, bɨ anɨbu aip armil,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","God Ana haga rö nöp, Pilip gɨ dö gɨ söl ba au amöm nɨŋa, bɨ Idiopia nɨbö anɨbu, bɨ God manö hagep Aisaia God Manö adɨŋ kalɨ kƚiñ rɨka u, amgö lɨ nɨŋöl gɨ areia. Pilip nɨŋöm haga, “Ne köp amgö lɨ nɨŋöl gɨ arabön yagol u, manö iƚ u anɨg hagöp a gɨmön nɨŋabön aka wasö?” ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hageia, nɨpe haga, “Nɨbi bɨ rɨmnap rö yɨp hag ñɨlö nɨŋem rö hagnam,” a ga. Anɨg hagöm Pilip nɨp haga, “Ap adö aui asɨkö hol aip arul,” a ga. Hagaiö, Pilip am adö anɨbu asɨka. ");
INSERT INTO kpw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bɨ anɨbu God Manö adɨŋ Aisaia kalɨ kƚiñ rɨka anɨbu amgö lɨ nɨŋeia. Manö anɨbu anɨgöl mɨdöp: “Nɨpe kaj sipsip uɫ gɨ dam al pak lɨbal rö nöp mɨdeia. Kaj sipsip pi uŋ rɨklö, aiö gɨ gagöp rö, nɨpe u rö nöp manö ap hagaga. ");
INSERT INTO kpw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nan naij ap gaga u pen nɨp manö pir alöm, gɨ naij gɨla. Nɨp böŋ nöp al pak lɨlö uma u me, hainö bɨ an rö mɨdöm, ‘Anɨg anɨg gɨmɨdöp,’ a gɨnab?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bɨ kub Idiopia nɨbö u manö anɨbu nɨŋöm, Pilip nɨp haga, “Manö hagab anɨbi, God manö hagep bɨ u nɨpe ke hagab aka bɨ ke nɨbö ap nɨp hagab?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hagö, Pilip God Manö adɨŋ amgö lɨ nɨŋajɨl u nöp iƚ gɨ hag dam dam, Jisas manö aij u hag ñɨ aij ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pen anɨg göl manö gɨ damöl gɨmil nɨŋlö ñɨg ap mɨdeia. Bɨ anɨbu Pilip nɨp haga, “Ñɨg mɨdöp i yɨp ñɨg pak ñɨnabön aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Hageia, Pilip haga, “Ne Krais nɨp hibur gasɨ mɨdmagö yad nɨŋö nöp nɨŋ udpin a geinabön u, yad nöp ñɨg pak ñɨnabin,” a ga. Hageia, bɨ anɨbu pen haga, “Jisas Krais nɨpe God Ñɨ nɨpe mɨdöp u, yad nɨŋ udpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hagö, kaj hos nan ɫɨp gɨ dam ajep adö asɨk aueilö u, hos u halö anɨb au lɨmil, ñɨg yaŋ ammil, Pilip bɨ anɨbu nɨp ñɨg pak ña. ");
INSERT INTO kpw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Anɨg göl ñɨg pak ñöm, goƚ au aulö nɨŋöl gɨ, adɨŋ Bɨ Kub Ana nɨpe Pilip nɨp udöm, ke mɨgan ap ud arö nɨŋöl gɨ, bɨ kub anɨbu nɨp nɨŋaga. Nɨpe pen mɨñ mɨñ yabɨƚ göl gɨ adan ara. ");
INSERT INTO kpw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pen Bɨ Kub Ana nɨpe Pilip nɨp dam ram mɨnöŋ Asodas lö, nɨbi bɨ ram mɨnöŋ anɨb gau daun ke ke mɨdeila gau kalɨp magöŋhalö Jisas manö aij u hag ñɨ dam dam, daun kub Sisaria amjaka. ");
INSERT INTO kpw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pen Sol nɨpe Bɨ Kub manö aij nɨŋ udöm hain gɨmɨdal nɨbi bɨ gau kalɨp al pak lɨn, a göm, pör kƚö yabɨƚ gɨmɨdöp. Mañ ap nɨpe am God nɨp nan sabe gep bɨ kub yabɨƚ u nɨp haga, ");
INSERT INTO kpw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Yɨp köp rɨmnap kalɨ kƚiñ rɨk ñaimön, yad dam Juda magum gep ram ke ke mɨdöp daun kub Damaskas amem, kalɨp ñɨnabin. Köp anɨbu kalɨ kƚiñ rɨkmön hagmön, ‘Daun kub Damaskas au, kale nɨbi bɨ Jisas nɨp nɨŋ udpal rɨmnap Juda magum gep ram gau mɨdaiöl u, Sol nɨp hagpe, kalɨp nagɨ löm, Jerusalem daunɨm,’ a gɨmön, kalɨ kƚiñ rɨkmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol köp anɨbu udöm, Damaskas söl söl gö nɨŋöl gɨ, adɨŋ mailö kumi kabö adö laŋ nɨbö ap lugöm nɨp nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol kaj hos adö laŋ nɨbö ap lug mɨnöŋ yaŋ pakö nɨŋöl gɨ, manö ap nɨp haga, “Sol, Sol, yɨp nɨhön gɨnɨg gɨmön pör gɨ naij gabön?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hageia, Sol haga, “Bɨ Kub, ne an?” ö ga. Hageia, haga, “Yad Jisas, yɨp pör gɨ naij gabön u nöp hagabin. ");
INSERT INTO kpw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pen ne urakmön, Damaskas ammön, bɨ ap apöm nöp manö hagnɨm rö nɨŋmön gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pen bɨ Sol aip aula gau manö magö u nöp nɨŋöm, bɨ nɨme u nɨŋagöm, gasɨ mɨlö löm, manö rɨmnap hagagla. ");
INSERT INTO kpw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol pen uraköm amgö hiɨköm nɨŋa, amgö nɨpe u böŋ nöp we ga. Anɨg gö, bɨ nɨpe aip aula gau ñɨmagö kɨd nɨpe u udöm, uɫ gɨ Damaskas arla. ");
INSERT INTO kpw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nɨp anɨg göl amgö we gö, ñɨg, nan magö nan gau ñɨŋagöm, ñɨn mɨhau nɨgaŋ yɨharɨŋ nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pen Jisas nɨp nɨŋ uda bɨ ap Damaskas mɨdeia, hib nɨpe u Ananaias. Bɨ anɨbu nɨpe naböŋ nɨŋa, Jisas nɨp haga, “Ananaias!” a ga. Hageia haga, “Bɨ Kub, yad mɨdpin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Hageia, Jisas haga, “Sol bɨ daun kub Dasas nɨbö u, God nɨp sabe göl gɨ, naböŋ nɨŋöb, bɨ Ananaias a gɨpal u nɨp am ud nɨŋajɨp, amgö nɨpe we ga u ñɨl nɨŋöb. Nɨpe mɨñi yɨp sabe göl gɨ mɨdöp Judas ram u. Anɨb u, ne adan ‘Yɨjɨg’ a gɨpal u ammön, Judas ram u amjakmön kalɨp hagmön, ‘Sol nɨp nɨŋnɨg auabin,’ a gɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jisas nɨpe anɨg hageia, Ananaias haga, “Bɨ Kub. Yad nɨŋbin nɨbi bɨ iru yabɨƚ nöp hagpal, ‘Bɨ Sol anɨbu nɨbi bɨ nöp lau adö mɨdpal Jerusalem gau kalɨp pör gɨ naij yabɨƚ göp,’ a gɨpal. ");
INSERT INTO kpw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nɨpe mɨñi Damaskas i auöp u, bɨ God nan sabe gep bɨ kub gau köp rɨmnap nɨp ñɨlö, nɨbi bɨ an an hib ne haglö adö arnab gau, kalɨp nagɨ lɨn, a göm, auöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananaias anɨg hageia, Bɨ Kub nɨp haga, “Aru! Bɨ anɨbu wög rɨmnap yad ke nɨp hag lɨbin. Nɨpe manö aij yad u Isrel nɨbi bɨ kalɨp hag ñöm, Isrel nɨbi bɨ wasö gau kalɨp hag ñöm, kiŋ gau kalɨp hag ñöm gɨnab. ");
INSERT INTO kpw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pen nɨpe ake ranö, iru marö gö nɨŋöl gɨ, wög anɨbu gɨnab. Anɨg gɨnab u yad ke nɨp hag ñɨ aij gɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bɨ Kub anɨg hageia, Ananaias aramöm, Sol mɨdeia ram u apjaköm, raul yaŋ amöm, Sol nɨp nabɨc cög adö laŋ ñɨmagö löm haga, “Mam Sol. Bɨ Kub Jisas nöp adan aŋ au ap lugöm waiö la nɨŋna u, yɨp hag yuöp auabin i. Ne amgö ne kauyaŋ ñɨl nɨŋmön, Ana Uɫ nɨpe nöp am ajmaŋ raunɨm, a göm, yɨp hag yuö aubin i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias anɨg hagö nɨŋöl gɨ, nan hag gaɫ bad rö Sol amgö nɨp harɨköl mɨdeia u, waƚ gɨ lugö nɨŋöl gɨ, adɨŋ amgö ñɨl nɨŋa. Amgö nɨŋöm, urak aramöm, ñɨg paka. ");
INSERT INTO kpw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol nan ñɨŋöm kƚö uda. Pen Sol nɨpe ñɨn rɨmnap nɨbi bɨ Jisas nɨp nɨŋ udla gau aip Damaskas mɨdöl gɨ, ");
INSERT INTO kpw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Juda magum gep ram gau ajöm, Jisas nɨpe God Ñɨ nɨpe mɨdöp manö aij u nɨbi bɨ gau kalɨp hag ña. ");
INSERT INTO kpw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nɨpe anɨg göl hag ñɨ mɨdö nɨŋöl gɨ, kale nɨŋöm pa gɨl gɨl göm hagla, “Bɨ i me, Jerusalem nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp gɨ naij gɨmɨdöp me! Mɨñi rɨmnap halö nagɨ lɨ dam, bɨ God sabe gep bɨ kub gau kalɨp ñɨnam a göm auöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pen Sol Jisas manö aij u hag ñɨ damöm, Jisas nɨpe nöp Mesaia u manö kabö göl yabɨƚ hagö, bɨ Juda Damaskas han mɨdeila gau manö ap pen hagöl rö laga. ");
INSERT INTO kpw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pen hainö mɨd damöm, Juda kai ap magum göm, manö hag adö añɨ löm hagla, “Sol nɨp al pak lun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pen manö hagla anɨbu, bɨ ap nɨŋöm Sol hag ña. Daun kub anɨbu, hadame nöp kabö waryö gɨ gɨgabö gɨla u me, adan ramö ajmɨdal gau, Sol nɨp alun, a göm, sɨdö aŋ sɨbön yaŋ uƚɨŋɨn lɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Anɨg geila nɨŋöm Sol bɨ nɨpe gau sɨbön aŋ yaŋ nɨp wadɨ mɨgan kub ap yagöm, nagɨ adɨköm, ɫɨp gɨ waryö anɨbu mɨgan ap höŋ adö adö laŋ nɨbö mɨnöŋ yaŋ yulö, pɨñɨŋ gɨ ara. ");
INSERT INTO kpw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem amöm, nɨbi bɨ Jisas lau adö mɨdeila gau aip mɨdeinam, a geia pen kale nɨŋöm, bɨ i Jisas bɨ nɨpe ap wasö, hanɨp al pak lɨnɨg auöp, a göm, pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Anɨg geila, Banabas nɨpe Sol nɨp dam bɨ Jisas manö ud arep gau mɨdeila au amöm, kalɨp haga, “Bɨ anɨbi nɨp nɨŋmim pɨñɨŋ gagmim. Mañ ap daun kub Damaskas amöl gɨ, adan aŋ au amöm, Bɨ Kub nɨp nɨŋö, nɨp manö rɨmnap haga. Hainö am Damaskas nɨbi bɨ kalɨp pɨñɨŋ gagöm, Jisas manö aij u haƚöwaƚö nöp hag ña,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas anɨg hagö, Sol nɨp udlö, kalɨp aip Jerusalem mɨdöm, daun kub anɨbu mɨgan mɨgan gau amöm, Jisas manö aij u haƚöwaƚö yabɨƚ nöp hag ña. ");
INSERT INTO kpw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pen bɨ Juda Grik manö nɨŋla gau nɨp aip manö pen pen hag amɨl apɨl göm, nɨp al pak lun, a göm, gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pen bɨ Jisas nɨp nɨŋ udla rɨmnap manö anɨbu nɨŋöm, nɨp uɫ gɨ dam daun kub Sisaria amöm yulö, daun kub Dasas ara. ");
INSERT INTO kpw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ñɨn aŋ anɨb au, ram mɨnöŋ Judia, Galili, Sameria gau, nɨbi bɨ Jisas nɨp nɨŋ udla gau mɨd aij gɨla. Ana Uɫ nɨpe kalɨp abad mɨd aij göm, pɨdöŋ ñö nɨŋöl gɨ, kale kƚö göm, Bɨ Kub nɨp gasɨ nɨŋöl gɨ mɨdöm, nɨbi bɨ rɨmnap halö Jisas manö aij u hag ñɨlö, kale u rö nöp Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pida ram mɨnöŋ ke ke gau gɨ ajöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp nɨŋ ajmɨdöp. Anɨg göl nɨŋ ajöm, mañ ap, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp nɨŋɨn, a göm, ram rɨƚɨg agƚö Lida ara. ");
INSERT INTO kpw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ram mɨnöŋ anɨbu bɨ ap mɨdeia, hib nɨpe u Inias. Pen ñɨmagö ma nɨpe gau kɨƚa gö, kuö adö nɨpe u nöp han mɨdmɨdöp mɨ unbö raleb jɨŋ ina. ");
INSERT INTO kpw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pida bɨ anɨbu nɨp haga, “Inias. Nan nöp göp u Jisas gö kamɨŋ lɨnab. Urakmön, kuö ne u yad aij gɨ,” a ga. Anɨg hagö nɨŋöl gɨ, magö anɨbu nöp Inias nɨp kamɨŋ lö uraka. ");
INSERT INTO kpw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Inias uraköm gɨ ajö nɨŋöl gɨ, ram rɨƚɨg agƚö Lida nɨbi bɨ gau abe, ram mɨnöŋ Seron nɨbi bɨ gau abe nɨp nɨŋöm, Bɨ Kub nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pen Pida ram rɨƚɨg agƚö Lida anɨbu mɨdö nɨŋöl gɨ, nɨbi Jisas nɨp nɨŋ uda ap uma yöp daun kub Jopa au. Nɨbi anɨbu hib nɨpe Dabida. Pen Grik manö hagöm nɨp Dokas a gɨmɨdal. Nɨpe nɨbi bɨ gau kalɨp abad mɨd aij göm, nɨbi bɨ mög gep rö gau kalɨp wög gɨ ñɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nɨbi anɨbu nɨp nan gö hadö umö, nɨp ñɨg pak ñöm wip he dam ram raul mɨgan adö laŋ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jisas nɨbi bɨ nɨpe Jopa mɨdeila gau manö ap nɨŋla, Pida ap mɨdeia ram rɨƚɨg agƚö Lida au. Lida daun kub Jopa söl au mɨdöp, nɨŋöm kale bɨ mɨhöp kalɨp hag yulö, Pida mɨdeia au ammil manö kƚö hagmil haglö, “Ne hol aip yɨŋɨd auö arun,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hagailö, Pida kalɨp mɨhöŋ aip Jopa amöm amjaklö nɨŋöl gɨ, nɨp uɫ gɨ dam Dabida uma dam lɨla ram raul adö laŋ arla. Uɫ gɨ ud areilö nɨŋöl gɨ, nɨbi paƚpaƚ ap mɨdeila gau, nɨbi uma anɨbu nöd kamɨŋ mɨdmɨdöp u, waƚɨj mɨlö waƚɨj rɨmnap kalɨp yɨharɨŋ ñɨmɨdöp gau, Pida nɨp yamöl gɨ, mɨɫöŋ gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pida pen nɨbi bɨ ap mɨdeila anɨb gau kalɨp hag höŋ yaŋ yuöm, kugom yɨmöm, God nɨp sabe göl gɨ, ado göm, wip he nɨŋöl gɨ haga, “Dabida, urak!” a ga. Hagö, Dabida amgö ñɨl Pida nɨp nɨŋöm, urak asɨka. ");
INSERT INTO kpw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pida pen ñɨmagö kɨd nɨpe u udöm, ud urak ñöm, nɨbi paƚpaƚ gau abe, nɨbi bɨ Jisas nɨp nɨŋ udla gau abe, kalɨp magöŋhalö wɨñ alö aueila haga, “Dabida i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pen Pida anɨg geia, manö anɨbu Jopa nɨbi bɨ magöŋhalö nɨŋöm, nɨbi bɨ iru nöp Bɨ Kub nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pen Pida nɨpe daun kub Jopa anɨbu, bɨ kaj kau hañ wög gɨmɨdöp bɨ ap aip ñɨn rɨmnap rapɨn mɨdmɨdil. Bɨ anɨbu hib nɨpe Saimon. ");
INSERT INTO kpw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pen ami bɨ gau kalɨp abad mɨdmɨdöp bɨ kub ap daun kub Sisaria mɨdmɨdöp. Hib nɨpe u Konilias. Ami bɨ nɨpe abad mɨdmɨdöp anɨb gau kalɨp “Idali Ami Bɨ” a gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bɨ kub Konilias anɨbu aip, nɨbi bɨ ram nɨpe gau aip, God nɨp nɨŋ udla. Juda nɨbi bɨ nan kale rɨmnap mɨdagmɨdöp u, Konilias nɨpe mani nan gau haƚöwaƚö ñɨmɨdöp. Pen nɨpe God nɨp pör sabe gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mañ ap sɨdö gamɨŋ ga magö u, Konilias nɨpe naböŋ nɨŋa, God ejol ap apöm haga, “Konilias!” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hageia, Konilias pɨñɨŋ göm nɨp nɨŋ ij halö löm haga, “Bɨ kub, yɨp nɨhön hagabön?” ö ga. Hageia, ejol u nɨp haga, “Ne God nɨp sabe gɨmön, nɨbi bɨ mög gep gau kalɨp nan haƚöwaƚö ñɨmön gɨpan u, God nöp aij göm nöp hauƚ gagöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ne bɨ rɨmnap hagö, kale am daun kub Jopa amöm, bɨ Saimon Pida a gɨpal u nɨp haglö aunɨm. ");
INSERT INTO kpw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nɨpe Saimon, bɨ kaj kau hañ wög göp u aip mɨdpil ñɨg solwara goƚ au,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pen ejol manö anɨbu hagöm arö nɨŋöl gɨ, Konilias bɨ wög nɨp gɨ ñɨmɨdil mɨhau abe, ami bɨ God nɨp nɨŋ uda ap abe hagö aueila, ");
INSERT INTO kpw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kalɨp ejol u manö nɨhön nɨhön haga u hag ñɨ aij göm hag yuö, Jopa arnɨg hadla. ");
INSERT INTO kpw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kale am am adan aŋ au hanla. Ruö am am, sɨdö aŋ aulɨk magö u, Jopa söl söl gɨla. Magö anɨbu Pida God nɨp sabe gɨnɨg ara ram adö laŋ mɨgan u. ");
INSERT INTO kpw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nɨpe amöm, God nɨp sabe gɨ mɨdö nɨŋöl gɨ, nɨp kɨyö kub yabɨƚ la. Pen nɨbi bɨ nɨpe gau nan magö lau gɨlö nɨŋöl gɨ, nɨpe naböŋ ap nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pida nɨpe naböŋ nɨŋöm nɨŋa, kumi kabö adö laŋ mɨgan hiɨköm, wadɨ kub ap ñon mɨlö mɨhau mɨhau goƚ lap lap adɨköl mɨdeia aŋ au lug lug mɨnöŋ iƚ yaŋ luga. ");
INSERT INTO kpw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wadɨ mɨgan anɨb yaŋ kaj, wal wayöŋ, re, yaur ke ke gau magöŋhalö nöp mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Manö ap pen nɨp haga, “Pida, urakmön nan ñɨŋeb anɨb yagol gau pak ñö?,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Hageia, Pida pen haga, “Bɨ Kub. Wasö yabɨƚ! Nɨhön gɨnɨg ñö? a gɨmön hagpan? Hon Juda nɨbi bɨ nan hil gep anɨb gau nan rɨmnap ñɨŋagpin yabɨƚ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hageia, manö anɨbu kauyaŋ haga, “Nan nɨhön nɨhön God nan ñɨŋeb a ga gau, hil gep a gɨmön hagagmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ga anɨbu, ij mɨhau nɨgaŋ ga. Hainö me, nan wadɨ kub anɨbu ado gɨ kumi kabö adö laŋ ara. ");
INSERT INTO kpw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anɨg gö, Pida naböŋ nɨŋbin anɨbu nɨhön gɨnab, a göm, gasɨ iru nɨŋ mɨdö nɨŋöl gɨ, Konilias bɨ hag yuö nɨp hagnɨg aula bɨ kabö u adan iƚ au apjakla. ");
INSERT INTO kpw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Apjaköm hagla, “Bɨ Saimon Pida au mɨdöp aka?” gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pida naböŋ nɨŋajɨp anɨbu gasɨ nɨŋöl gɨ mɨdö nɨŋöl gɨ, God Ana nɨp haga, “Ne nö?! Bɨ mɨhau nɨgaŋ nöp uƚhai nɨŋ auaböl. ");
INSERT INTO kpw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Anɨb u, urakmön ram au gɨyaŋ arammön. Yad ke kalɨp hag yunö auaböl. Anɨb u, auö aip arun a gaiöl u, gasɨ iru nɨŋagmön aip armön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","God Ana anɨg hagö, Pida au yaŋ amöm bɨ anɨb gau kalɨp haga, “Bɨ uƚhai nɨŋabim bɨ u, yad me i. Yɨp manö ap hagnɨg aubim aka?” ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hageia, hagla, “Bɨ kub Konilias, ami bɨ gau kalɨp abad mɨdöp bɨ kub u hanɨp hag yuö auabun. Nɨpe God nɨp nɨŋ udöm, God Manö hagöp rö göp; Juda kai nɨp nɨŋlö kalɨp magöŋhalö aij göp. Pen nɨpe naböŋ nɨŋa, God ejol ap apöm nɨp haga, ‘Ne bɨ rɨmnap yuö, am Saimon Pida nɨp uɫ gɨ daulö, manö hagainɨm u nɨŋmön,’ a ga,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Anɨg hagailö, Pida kalɨp hagö ram raul mɨgan amöm hanla. Ruö Pida, bɨ Jopa nɨbö Jisas nɨp nɨŋ udla rɨmnap udöm, Konilias yua bɨ ugan anɨbu aip am am adan aŋ au hanla. ");
INSERT INTO kpw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ruö u, Sisaria amjaköm, Konilias ram u amjakla. Pen Konilias nɨpe Pida auab, a göm, nɨbi bɨ nɨpe gau abe, mɨdeimam nɨpe gau abe, kalɨp wɨñ alö ap magum gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pida nɨpe amöm ram raul arnɨg gö nɨŋöl gɨ, Konilias nɨp nable paköm, nɨp bɨ kub a göm, am ma iƚ nɨpe au kugom yɨma. ");
INSERT INTO kpw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Anɨg gö nɨŋöl göm, Pida pen nɨp ud urak ñöm haga, “Ne urak! Yad u rö nöp bɨ ap me,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Hagö, urakö nɨŋöl gɨ, manö hagöl gɨ, ram raul mɨgan yaŋ arlö. Ammil Pida nɨŋa, nɨbi bɨ iru nöp ap magum gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pida kalɨp haga, “Kale ke nɨŋbim, hon Juda nɨbi bɨ asɨ masɨ gɨ aij gɨpun. Juda nɨbi bɨ wasö gau aip ajagpun; ram kale aragpun. Pen yad naböŋ nɨŋnö, God yɨp manö ap haga. Nɨpe manö haga anɨbu, yad nɨbi bɨ rɨmnap asɨ masɨ mɨdpal, a gem, kalɨp asɨ masɨ gɨnam rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Anɨb u nɨŋem me, Konilias manö hagöp u nɨŋem arö gagpin; hagöp rö nɨŋem aubin. Anɨb u, yɨp nɨhön gɨnɨg hagpe aubin?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pida anɨg hageia, Konilias haga, “Yad ruö nöp me, mɨñi sɨdö gamɨŋ göp magö u rö, ram raul mɨgan yaŋ God nɨp sabe gɨ mɨdöl gɨ nɨŋnö, bɨ waƚɨj rud yabɨƚ yɨma ap apöm, mɨdainö ba au uraköl mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nɨpe yɨp haga, ‘Konilias, ne God nɨp sabe gɨmön, mani nan gau nɨbi bɨ nan mɨdagöp gau kalɨp haƚöwaƚö ñɨmön gɨpan u, God nɨŋöb. ");
INSERT INTO kpw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Anɨb u me, bɨ rɨmnap hag yuö, daun kub Jopa amöm, Saimon hib nɨpe ap Pida a gɨpal u, nɨp uɫ gɨ dauöl. Nɨpe Saimon bɨ kaj kau hañ wög göp u aip mɨdpil ñɨg solwara goƚ au,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ejol u yɨp anɨg hagö, yad yɨŋɨd nöp bɨ yad rɨmnap hagnö, nöp am uɫ gɨ dauajal, yɨp aij göp. Hon nɨbi bɨ aui God pɨg mɨdpun rö, Bɨ Kub manö kalɨp hag ñɨmön, a göm, nöp hag yuö auban u, mɨñi hanɨp hag ñö nɨŋun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konilias anɨg hageia, Pida haga, “Yad mɨñi nɨŋbin, God nɨpe, bɨ söl aui nɨbö nöp bɨ aij, bɨ mɨlö gau nɨbö bɨ naij, a göm, nɨŋagöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ram mɨnöŋ ke ke gau nɨbö, iƚ ke ke gau nɨbö, nɨbi bɨ an an God nɨp nɨŋöm ana udöm, manö nɨpe nɨŋöm hagöp rö gɨnaböl gau, kalɨp magöŋhalö udnab. ");
INSERT INTO kpw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pen God nɨpe hanɨp Isrel nɨbi bɨ manö aij yua u nɨŋbim. Yad ke aip jɨm ñöl mɨdlaŋ, a göm, God nɨpe Jisas Krais nɨp hag yua. Jisas Krais nɨpe nöp me, nɨbi bɨ gau magöŋhalö Bɨ Kub kale mɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kale ke nɨŋbim, Jon bɨ ñɨg pak ñeb u, ñɨg pak ñöl gɨ, manö aij anɨbu iƚ göm, ram mɨnöŋ Galili hag ña. Anɨg göl hagö, hag damöm, hag damöm, nɨbi bɨ ram mɨnöŋ Isrel mɨdpal gau magöŋhalö nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pen kale nɨŋbim, Jisas Nasared nɨbö u God aip mɨdöm, Ana Uɫ u nɨp ñö, abad mɨdö nɨŋöl gɨ, kƚö nɨpe nöp udöm, ram mɨnöŋ ke ke gau magöŋhalö ajöl göm, nɨbi bɨ gau gɨ aij göl gɨ, nɨbi bɨ Seden kalɨp gö uɫham mɨdeila gau kalɨp gö, kamɨŋ lɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Pen Jisas Juda nɨbi bɨ ram mɨnöŋ kale gau gɨ ajöl göm, Jerusalem gɨ ajöl göm, ga ga rö hon amgö hon ke nɨŋno u hagabin. Pen hainö nɨp mab ba laŋ al pak lɨlö uma. ");
INSERT INTO kpw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Uma u pen ñɨn mɨhöp mɨdöm, God gö, ñɨn mɨhau nɨgaŋ u kauyaŋ uraköm, am waiö lö amgö nɨŋno. ");
INSERT INTO kpw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nɨbi bɨ magöŋhalö nɨp amgö nɨŋagla. God hanɨp nɨbi bɨ hag la gau nöp Jisas nɨp amgö nɨŋno. Nɨpe umöm urakö nɨŋöl gɨ, aip mɨdun jɨm ñöl nan ñɨŋun ñɨg ñɨŋno. ");
INSERT INTO kpw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jisas hanɨp haga, ‘Manö aij yad u nɨbi bɨ gau kalɨp hag ñɨmim hagmim, “God haga rö me, hainö Jisas nɨbi bɨ kamɨŋ mɨdeinaböl gau abe, nɨbi bɨ umnaböl gau abe, kalɨp magöŋhalö manö kub hagnab,” a gɨmim,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pen adö anɨbu, bɨ God manö hagep gau magöŋhalö Jisas Krais nɨp hagöm hagla, ‘Nɨbi bɨ an an Krais hib kƚö yabɨƚ nɨpe u udnaböl gau, nan si nan naij gɨpal u, God nɨŋöm arö gɨnab,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pen Pida anɨg göl manö hag mɨdö nɨŋöl gɨ, Ana Uɫ nɨpe nɨbi bɨ nɨŋ mɨdeila gau kalɨp magöŋhalö aua. ");
INSERT INTO kpw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Ana Uɫ kalɨp auö, kale manö ke nöp, haŋ ke nöp hagöl gɨ, God hib nɨpe haglö adö arö, Juda nɨbi bɨ Jisas nɨp nɨŋ udla Pida aip Jopa nɨbö aula gau, God Juda nɨbi bɨ wasö gau kalɨp Ana Uɫ ña me u, a göm, aiö waiö gɨla. Pida pen haga, ");
INSERT INTO kpw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“God nɨpe Ana Uɫ hanɨp ña rö u, mɨñi nɨbi bɨ gai i kalɨp u rö nöp ñöb. Anɨb u, kale ñɨg paknabun, a gɨlö, nɨbi bɨ rɨmnap kalɨp wasö göl rö lagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pida anɨg hagöm bɨ nɨpe rɨmnap kalɨp haga, “Nɨbi bɨ gai i kalɨp Jisas Krais hib nɨpe hagmim ñɨg pak ñɨmim,” a ga. Ñɨg pak ñɨlö nɨŋöl gɨ, kale hagla, “Pida, ne hon aip ñɨn pro magö ap aui mɨdaimön,” a gɨla. Haglö, ñɨn pro magö ap kalɨp pɨg mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pen Jisas manö ud arep bɨ gau abe, ram mɨnöŋ Judia nɨbi bɨ Jisas nɨp nɨŋ udla gau abe nɨŋla, Juda nɨbi bɨ wasö gau rɨmnap God Manö nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Anɨb u, hainö Pida Jerusalem arö, Juda bɨ wasö gau u rö nöp hañ rɨb gɨ dö göl, a gɨmɨdal bɨ gau, Pida nɨp kal göm hagla, ");
INSERT INTO kpw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ne nɨhön gɨnɨg bɨ hañ rɨb gɨ dö gagpal gau ram kale ammön, kalɨp aip nan jɨm ñöl ñɨŋabön?” ö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Anɨg hagaila, Pida daun kub Jopa mɨdöm naböŋ nɨŋa aiud u kalɨp hag ñöl gɨ haga, ");
INSERT INTO kpw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yad daun kub Jopa mɨdem, God nɨp sabe gɨ mɨdem, naböŋ nɨŋnö, kumi kabö adö laŋ nɨbö, wadɨ kub ap rö ñon mɨlö mɨhau mɨhau goƚ lap lap adɨköl mɨdeia lug lug iƚ yad mɨdainö au ap luga. ");
INSERT INTO kpw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Auö, yad wadɨ anɨbu mɨdeia söl au amem nɨŋnö, kaj, wal wayöŋ, re, yaur gau gau magöŋhalö mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pen manö ap yɨp haga, ‘Pida, ne urakmön nan anɨb yagol gau pak ñöŋ,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Hageia, yad pen hagnö, ‘Bɨ Kub. Wasö yabɨƚ! Nɨhön gɨnɨg ñöŋ a gɨmön hagpan? Hon Juda nɨbi bɨ nan hil gep anɨb gau nan rɨmnap ñɨŋagpin yabɨƚ,’ a gɨnö. ");
INSERT INTO kpw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Anɨg hagainö, manö anɨbu kauyaŋ haga, ‘Nan nɨhön God nan ñɨŋeb a ga gau, hil gep a gɨmön hagagmön,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ga anɨbu, ij mɨhau nɨgaŋ ga. Pen hainö nan wadɨ kub anɨbu ado gɨ kumi kabö adö laŋ ara. ");
INSERT INTO kpw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Pen magö anɨbu nöp, bɨ mɨhau nɨgaŋ ram han mɨdainö u apjakla. Bɨ anɨb gau bɨ kub Konilias, Sisaria nɨbö hag yuö, yɨp uɫ gɨnɨg aula. ");
INSERT INTO kpw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","God Ana yɨp haga, ‘Gasɨ iru nɨŋagmön, kalɨp aip haƚöwaƚö armön,’ a ga. Anɨg hageia, yad mam Jisas manö nɨŋ udpal unbö kagoƚ jɨŋ udem, kalɨp aip Konilias ram u arno. ");
INSERT INTO kpw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amjakno, Konilias haga, ‘Ejol ap apöm yɨp haga, “Bɨ rɨmnap hagaimön, daun kub Jopa amöm, bɨ ap Saimon Pida a gɨpal u nɨp uɫ gɨ dauöl. ");
INSERT INTO kpw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Uɫ gɨ daulö, nɨpe nöp manö rɨmnap hag ñö, nɨbi bɨ ram ne aip mɨdpim gau, God kalöp magöŋhalö ud kamɨŋ yuö, nɨbi bɨ nɨpe mɨdeinabim,” a ga,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Konilias yɨp anɨg hagö, yad iƚ gem manö hag ñɨnö nɨŋöl gɨ, Ana Uɫ nɨpe hanɨp nöd aua rö, nɨbi bɨ anɨb gau kalɨp u rö nöp aua. ");
INSERT INTO kpw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Anɨg gö, Bɨ Kub hanɨp nöd haga manö u gasɨ nɨŋnö. Nɨpe haga, ‘Jon kalɨp ñɨg pak ña u pen söl mɨdöp God nɨpe kalöp Ana Uɫ u pak ñɨnab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pen hon Bɨ Kub Jisas Krais nɨp nɨŋ udno ñɨn u, God nan aij yabɨƚ hanɨp ña rö, kalɨp u rö nöp ña. Anɨb u, yad aigöl gem God nɨp, ‘Anɨg gagmön,’ a gɨbnep?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pida anɨg hageia, bɨ nɨp manö kal hag gɨla gau manö haga u nɨŋöm, manö kal rɨmnap halö hag gagla. God hib haglö adö arö nɨŋöl gɨ hagla, “Hanɨp nöp wasö; Juda nɨbi bɨ wasö gau u rö nöp, nan si nan naij gɨpal u, nɨhön gɨnɨg anɨg gɨpun, a göm, nɨp sabe geinaböl u, nɨpe nɨŋöm, nan si nan naij gɨpal gau arö göm, kamɨŋ pör mɨdep magö u kalɨp ñɨnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pen Sɨdipen nɨp kabö ju pak lɨla ñɨn aŋ au, bɨ Juda Jerusalem mɨdeila gau, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp gɨ naij yabɨƚ gɨlö, kale pɨñɨŋ gɨ ke ke arla. Rɨmnap pɨñɨŋ gɨ ram mɨnöŋ Pönisia arla, rɨmnap pɨñɨŋ gɨ ram mɨnöŋ ñɨg rɨb gus ga airan Saipras arla, rɨmnap pɨñɨŋ gɨ daun kub Adiok arla. Amöm, Jisas manö aij u Juda nɨbi bɨ wasö gau kalɨp hag ñagla, nɨbi bɨ kale ke Juda kai ju am anɨb gau mɨdmɨdal gau kalɨp nöp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pen nɨbi bɨ Jisas manö aij u nɨŋ udla rɨmnap Saipras nɨbö, rɨmnap Sairini daun nɨbö, pɨñɨŋ gɨ Adiok amöm, Bɨ Kub Jisas manö aij u Juda nɨbi bɨ wasö gau kalɨp hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bɨ Kub kƚö nɨpe u kalɨp aip mɨdeia u me, nɨbi bɨ gau kalɨp Jisas manö aij u hag ñɨlö, nɨbi bɨ iru nöp Bɨ Kub nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pen Jerusalem nɨbi bɨ Jisas nɨp nɨŋ udla gau, manö anɨbu nɨŋöm, bɨ kale Banabas nɨp haglö, Adiok ara. ");
INSERT INTO kpw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas nɨpe Adiok amjaköm nɨŋa, God nɨpe nɨbi bɨ anɨb gau mög nɨŋöm gö, Jisas manö aij u nɨŋ udla. Anɨb u me, nɨpe ñɨñɨ löm, kalɨp manö rɨmnap halö hag ñöl gɨ haga, “Bɨ Kub nɨp nɨŋ udpim u arö gagmim; nɨp añɨ nöp hibur gasɨ mɨdmagö kale aŋ daŋ nɨŋ ud pɨdöŋ gɨmim, cɨg göl gɨ mɨdaimim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas nɨpe bɨ aij yöl. Ana Uɫ nɨpe Banabas apöm ajmaŋ raumɨdöp. Nɨpe Jisas manö aij u böŋ nöp nɨŋ uda. Nɨpe Jisas manö aij u nɨbi bɨ gau hag ñö, nɨbi bɨ iru nöp Bɨ Kub nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas pen bɨ Sol nɨp am daunam, a göm, daun kub Dasas ara. ");
INSERT INTO kpw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Banabas Dasas amjaköm, Sol nɨp uƚhai nɨŋöm, uɫ gɨ ado gɨ am Adiok amöm, mɨ añɨ anɨbu nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp Jisas manö aij u hag ñöl gɨ mɨdailö. Adiok nɨbi bɨ Jisas Krais nɨp nɨŋ udla gau, nöd hib ñöm Krais Nɨbi Bɨ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ñɨn aŋ anɨb au, bɨ God manö hagep rɨmnap Jerusalem nɨbö Adiok arla. ");
INSERT INTO kpw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Amöm, God Ana nɨpe bɨ kale ap Agabas nɨp gasɨ ñö haga, “Kɨyö kub yabɨƚ ram mɨnöŋ magöŋhalö lɨnɨg gab,” a ga. Hagö, haga rö kɨyö kub yabɨƚ u, gapman bɨ kub Klodias abad mɨdmɨdöp ñɨn u aua. ");
INSERT INTO kpw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Anɨg göl kɨyö kub la nɨŋöm Adiok nɨbi bɨ Jisas nɨp nɨŋ udla gau hagla, “Nɨbi bɨ Jisas manö aij u nɨŋ udpal rɨmnap ram mɨnöŋ Judia gau mɨdlö nɨŋöl gɨ, kalɨp kɨyö kub yabɨƚ löp u, hon añɨ añɨ kalɨp mani rɨmnap magum gun ñun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Anɨg hagöm, mani lɨ magum göm, Banabas aip Sol aip kalɨp ñöm hagla, “Kale bɨ mɨhöŋ mani i dammil, Krais nɨbi bɨ nɨpe abad mɨdpal bɨ kub gau kalɨp ñɨl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ñɨn aŋ anɨb au, gapman bɨ kub Herod, nɨbi bɨ Jisas nɨŋ udla gau rɨmnap kalɨp gɨ naij göl gɨ, dam nagɨ löl gɨ ga. ");
INSERT INTO kpw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ami bɨ nɨpe gau rɨmnap hagö, Jon nɨmam Jems nɨp ru mɨlö kɨd udöm böŋ nöp al pak lɨlö uma. ");
INSERT INTO kpw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod hagö anɨg geila, Juda nɨbi bɨ gau nɨŋöm ñɨñɨ lɨla. Ñɨñɨ lɨla u, Herod nɨŋöm, Pida nɨp u rö nöp hagö, dam nagɨ lɨla. Gɨla anɨbu, Juda nɨbi bɨ Bred Yɨs Halö Ñɨŋagep ñɨn aŋ au gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod Pida nɨp anɨg göl dam nagɨ löm, ami bɨ unbö raleb böŋ daŋ (16) kalɨp nɨme lɨ yɨgwo mɨlö yɨgwo mɨlö löm haga, “Sɨdö aŋ sɨbön yaŋ bɨ mɨhau mɨhau abad nöp mɨdaimim,” a ga. Herod gasɨ nɨpe u ke nɨŋöm haga, “Pasopa ñɨn u ap arainɨm me, hainö Pida nɨp dam nɨbi bɨ mɨdeinaböl aŋ au amun manö kub hagnabun,” a göm nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pida nɨpe anɨg göl nagɨ mɨdö nɨŋöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla gau Pida nɨp gasɨ nɨŋöm, kƚö göm God nɨp sabe göl gɨ nöp mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pen gapman bɨ kub Herod Pida nɨp manö kub hagnam, a göm, nɨŋa ñɨn anɨbu nöp sɨbön au yaŋ, Pida nɨp sen mɨhöp adɨköm, ami bɨ mɨhau böŋ lap lap nɨŋ mɨdlö nɨŋöl gɨ, Pida aŋ yaŋ haneia. Ami bɨ rɨmnap u rö nöp adan iƚ u nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pen adɨŋ Bɨ Kub ejol nɨpe ap urak mɨdö nɨŋöl gɨ, mab mɨɫaŋ rö am nagɨ lep ram raul mɨgan u ara. Ejol anɨbu am Pida nɨp rɨglöm pak nɨŋöm haga, “Yɨŋɨd urak!” a ga. Hagö, Pida urakö nɨŋöl gɨ, sen nɨp adɨkla u hubɨka. ");
INSERT INTO kpw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ejol Pida nɨp haga, “Dip nagɨ ne u pɨg lɨmön, ma rɨrup ne u gɨmön gɨ,” a ga. Hagö, Pida ejol haga rö nöp gö, ejol u pen haga, “Waƚɨj mɨlö kub ne u yɨmö, yad aip arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Hagö, waƚɨj mɨlö kub nɨpe u yɨmöm, ram raul mɨgan mɨdeia u arö göm, ejol u aip hadlö. Ejol ga anɨbu, Pida nɨpe hag nɨŋa e, u naböŋ nɨŋabin a göm nɨŋa. ");
INSERT INTO kpw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pen ami bɨ nɨŋ mɨdeila ajöŋ iƚ mɨhau hil gɨmil, ajöŋ kƚö yabɨƚ ain udöm gɨla ajöŋ höŋ yaŋ u ke hiɨkö nɨŋöl gɨ, höŋ arlö. Ammil, adan aŋ gau amöl gɨ Pida nɨŋa, ejol u mɨdageia. ");
INSERT INTO kpw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Anɨg ga nɨŋöm Pida haga, “Mɨñi nɨŋ aij gɨpin. U Bɨ Kub nöp, ejol nɨpe u hag yuö, ap gapman bɨ kub Herod yɨp nagɨ pɨdöŋ löp u hubɨk yuöp. Gapman bɨ kub Herod abe, Juda nɨbi bɨ gau abe, nan naij yɨp gɨnɨg gɨpal u, göl rö lagöp,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Anɨg hagöm, gasɨ nɨŋ aij göm, bɨ ne Jon Mak nɨme Maria ram u ara. Ram anɨbu nɨbi bɨ iru nöp apöm, God nɨp sabe gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pida apöm, ajöŋ u pa gu gu gö, pai Roda, ram anɨbu wög gɨmɨdöp u ajöŋ u hiɨknɨg aua. ");
INSERT INTO kpw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pai anɨbu ajöŋ apöm nɨŋa, Pida maj mɨgan u nöp hageia. Nɨpe anɨg nɨŋöm, ñɨñɨ yabɨƚ löm, hauƚ padö ajöŋ hiɨkaga; am nɨbi bɨ gau kalɨp haga, “Pida ap mɨdöp höŋ yaŋ,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hageia, kale hagla, “Ne hauƚ alajɨp hagabön,” a gɨla. Anɨg hageila, nɨpe kƚö yabɨƚ göm haga, “Piral hagagɨn; nɨŋö yabɨƚ hagabin. Pida mɨdöp höŋ yaŋ,” a ga. Hageia hagla, “U ana nɨpe u rö löp ap mɨdöp,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pen Pida nɨpe ajöŋ u kauyaŋ pak gu gu gö gö gö, am ajöŋ u hiɨköm nɨŋla, Pida nöp mɨdeia nɨŋöm aiö yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Aiö gɨlö nɨŋöl gɨ, Pida kalɨp ñɨn mɨƚɨc gɨ ñöm haga, “Manö hagagmim!” a ga. Anɨg hagöm, nagɨ lep ram mɨdö nɨŋöl gɨ, God ejol ap yuö apöm, nɨp nɨhön nɨhön göm daua manö u kalɨp hag ñöm haga, “Manö anɨbi Jems abe, nɨbi bɨ Jisas nɨp nɨŋ udpal gau abe, kalɨp hag ñɨmim,” a göm, ke mɨgan ap ara. ");
INSERT INTO kpw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ruö ram ruö nɨŋöl gɨ, ami bɨ gau Pida mɨdageia u nɨŋöm, nɨhön göp, a göm, hag ap ran ap lugöl gɨ mɨdeila. Pɨñɨŋ göm, “Mai,” a göm, uƚhaila u pen nɨŋagla. ");
INSERT INTO kpw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ami bɨ anɨb gau kalɨp, Pida nɨp yɨŋɨd uƚhai nɨŋmim dauim, a gö, uƚhai wasö nɨŋlö, kalɨp manö kub hagöm, manö hagö ami bɨ nɨpe rɨmnap ami bɨ anɨb gau böŋ nöp al pak lɨla. Hainö Herod ram mɨnöŋ Judia arö göm, am daun kub Sisaria mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod am Sisaria mɨdöm, daun kub mɨhöp Daia Saidon nɨbi bɨ gau kalɨp nɨŋö mulu luga. Pen Daia Saidon nɨbi bɨ apöm, bɨ Herod ram nɨpe abada bɨ Blasdas nɨp mɨɫöŋ gɨ ñöm hagla, “Hanɨp pör kɨyö lö, apun Herod ram mɨnöŋ nɨpe i nan magö rau ud arbun halö. Anɨb u, hanɨp kal kal juagmim; agamɨj jɨm ñöl mɨdaiun,” a gɨla. Hageila, Blasdas nɨpe pen haga, “U nɨŋö hagpim,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pen Herod manö anɨbu nɨŋöm, ñɨn ap manö hagnabin, a göm, hag la. Hainö hag la ñɨn anɨbu auö, nɨpe kiŋ kai yɨmbal rö waƚɨj aij aij yabɨƚ gau yɨmöm, sea kiŋ kub nɨpe adö u asɨköm, nɨbi bɨ gau kalɨp manö hag ña. ");
INSERT INTO kpw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herod manö anɨbu hag ñö nɨŋöl gɨ hagla, “U bɨ ap rö hagagab; god ap rö hagab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pen Herod manö anɨbu nɨŋöm, “Yɨp manö anɨbu rö hagagmim; God hib nɨpe nöp hagpe adö araŋ,” a gaga. Anɨb u, Bɨ Kub ejol nɨpe ap hag yuö, apöm Herod nɨp gö, mɨña kub göm, gɨse lö böŋ nöp uma. ");
INSERT INTO kpw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pen God Manö u hag ñɨlö arö nɨŋöl gɨ, ram mɨnöŋ gau kɨd kɨd ara. ");
INSERT INTO kpw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pen Banabas aip Sol aip Jerusalem mɨdmil, gɨnɨg aulo u hadö gɨpul, a gɨmil, Jon Mak nɨp uɫ gɨ ado gɨ Adiok arla. ");
INSERT INTO kpw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Daun kub Adiok anɨb au bɨ God manö hagep bɨ rɨmnap, bɨ God manö hag ñeb bɨ rɨmnap mɨdeila. Bɨ anɨb gau me, ap Banabas; ap Simion. Bɨ Simion anɨbu nɨp Bɨ Pɨr a gɨmɨdal. Bɨ ap Lusias, nɨpe Sairini daun nɨbö. Bɨ ap Maneyen, nɨpe Kiŋ Herod bɨ nɨŋeb nɨpe ap. Pen bɨ ap Sol. ");
INSERT INTO kpw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pen ñɨn ap kale nan magö ñɨŋagöm, Bɨ Kub nɨp nöp sabe gɨ mɨdlö nɨŋöl gɨ, Ana Uɫ nɨpe kalɨp haga, “Kale Banabas aip Sol aip hagaimim, wög kalɨp hag lɨnö u gɨlö arnɨm,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anɨg hagö, kale nan magö ñɨŋagöm, God nɨp sabe göm, Banabas aip Sol aip kalɨp ñɨmagö adö laŋ löm, God kalɨp mɨhöŋ abad mɨdeiaŋ, a göm, kalɨp hag yula. ");
INSERT INTO kpw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Ana Uɫ nɨpe kalɨp abad mɨdö nɨŋöl gɨ, bɨ nɨ Jon Mak, wög halɨp pro pro rɨmnap gɨ ñaŋ, a gɨmil, nɨp uɫ gɨ Selusia daun ñɨg goƚ yaŋ amöm, ñɨg magɨb udöm, ram mɨnöŋ ñɨg rɨb gus ga airan Saipras arla. Amöm, daun kub Salamis amöm, Sol aip Banabas aip Juda magum gep ram gau amöm, nɨbi bɨ gau kalɨp God Manö hag ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pen nɨbi bɨ Saipras mɨdeila anɨb gau kalɨp God Manö hag ñɨ dam dam, daun kub Pepos amjaköm, Juda bɨ ap kuj cage aimö gep bɨ ap nable paklö. Bɨ anɨbu hib nɨpe Ba-Jisas. Nɨpe manö piral hagöm haga, “Yad God manö hagep bɨ ap,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Daun kub Pepos au, Saipras gapman bɨ kub yabɨƚ hanmɨdöp, hib nɨpe Segias Polas. Bɨ anɨbu nɨpe bɨ gasɨ nɨŋ kɨd yabɨƚ hiɨköm nɨŋmɨdöp. Nɨpe Banabas aip Sol aip, God Manö yɨp haglö nɨŋɨn, a göm, kalɨp hagö apil, nɨp God Manö hag ñɨlö. Pen bɨ kuj cage aimö gep bɨ u nɨpe bɨ kub anɨbu bɨ nɨŋeb nɨpe ap. ");
INSERT INTO kpw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bɨ Ba-Jisas anɨbu, Grik manö hagöm nɨp Elimas a gɨmɨdal. Banabas aip Pol aip kale Segias Polas nɨp God Manö aij u hag ñɨlö, nɨpe rɨmɨd lɨ apdi nɨŋ aij ga u pen, bɨ kuj aimö gep bɨ u nɨŋöm, Banabas Pol manö naij kek hagöm, Segias Polas Jisas manö u nɨŋ udagnɨm, a göm, nɨp haga, “Bɨ anɨb mɨhau manö pir alabil u nɨŋagmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol hib nɨpe ap me Pol a gɨmɨdal. Ana Uɫ nɨpe Pol nɨp ajmaŋ rauöm gasɨ aij ñö nɨŋöl gɨ, bɨ kuj aimö gep bɨ u nɨp nɨŋ ij halö lɨ mɨdöm haga, ");
INSERT INTO kpw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ne kɨjaki pi yag daua; naij nöp gɨpan. Nan nɨhön nɨhön aij mɨdöp u arö gɨmön, nɨbi bɨ gau kalɨp piral nöp gabön. Ne pör pör Bɨ Kub manö nɨŋö nɨpe u udmön manö piral rö labön. Ne ñɨn mai gɨ naij gabön u arö gɨnabön? ");
INSERT INTO kpw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Anɨg gabön u, God gö, ñɨn bad ap amgö ne we gö sɨdö mailö nɨŋagnabön,” a ga. Pol manö anɨbu hagö, adɨŋ Ba-Jisas nɨŋa, kumi pɨr rö bad ap amgö nɨpe harɨkö böŋ nöp sɨb ga. Anɨg gö, bɨ ap yɨp ñɨmagö ud adan yamaŋ, a göm, ud rɨrɨkoƚ göl gɨ mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Banabas Pol kale bɨ mɨhöŋ Bɨ Kub manö u nɨp hag ñailö u nɨŋöm, Segias Polas nɨpe aiö ga. Anɨb u, Ba-Jisas ga u nɨŋöm, nɨpe Jisas nɨp nɨŋ uda. ");
INSERT INTO kpw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pen Pol bɨ nɨpe gau aip ñɨg magɨb udöm, Pepos arö göm, Pega daun, ram mɨnöŋ Pampilia au arla. Am mɨdöm, Jon Mak nɨpe kalɨp mɨhöŋ au arö göm, ado gɨ Jerusalem ara. ");
INSERT INTO kpw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kale pen Pega daun arö gɨmil, daun kub Adiok, ram mɨnöŋ Pisidia au arlö. Am mɨdöm, Juda God nɨp sabe gep ñɨn u, Juda magum gep ram u ammil, asɨk mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Juda magum ram abad mɨdmɨdal bɨ gau uraköm, Mosɨs lo manö kalɨ kƚiñ rɨka adɨŋ rɨmnap abe, bɨ God manö hagep gau kalɨ kƚiñ rɨkla adɨŋ rɨmnap abe, amgö lɨ nɨŋ nɨbi bɨ mɨdeila gau kalɨp hagla. Kale manö hag pɨs göm, bɨ ap hag yulö Banabas Pol asɨk mɨdailö au amöm haga, “Mamil mɨhöŋ. Nɨbi bɨ gai i nɨŋ udep manö rɨmnap mɨdainɨm u, hanɨp hag ñɨlö nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hagailö, Pol uraköm manö hagnɨg ñɨmagö dap ranöm haga, “Kale Juda nɨbi bɨ gau abe, Juda nɨbi bɨ wasö God nɨp sabe gɨmɨdim gau abe, manö hagnɨg gabin i rɨmɨd lɨ nɨŋim. ");
INSERT INTO kpw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God nɨpe hadame nöp apɨs bac bɨ hon gau uda. God anɨbu nɨpe Isrel nɨbi bɨ God hon me. Hainö kale ram mɨnöŋ Ijip am mɨdeila, God kalɨp abad mɨd aij gö, ñɨ pai yag dapöm, iru yabɨƚ nöp mɨdeila. Bɨ kub Pero kalɨp, aragnabim, a ga u pen God kƚö ke yabɨƚ nɨpe u göm, kalɨp uɫ gɨ dam Ijip höŋ adö aula. ");
INSERT INTO kpw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kale mɨ ñɨnjuöl mɨhöp (40) ram mɨnöŋ kabö nöp mɨdmɨdöp aŋ au mɨdöm, God nɨp manö iru nɨbanö sasɨm lɨ gɨmɨdal u pen God kalɨp abad mɨd aij ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pen nöd ram mɨnöŋ Kenan nɨbi bɨ rɨgoŋ ke ke unbö mudun jɨŋ mɨdeila, pen God nɨbi bɨ nɨpe kalɨp abad mɨd aij göm pɨdöŋ nɨpe ñö, nɨbi bɨ rɨgoŋ ke ke unbö mudun jɨŋ nöd mɨdeila gau kalɨp aip pen pen göm, rɨdɨk gɨ yu al pak löm, ram mɨnöŋ anɨbu ram mɨnöŋ kale ke rö udla. ");
INSERT INTO kpw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kale Ijip mɨdlö mɨ ina u wö ralöm, ram mɨnöŋ aipɨƚ nöp aŋ gau mɨdlö mɨ ina u wö ralöm, nɨbi bɨ rɨdɨk gɨ yuöm, ram mɨnöŋ kale udla mɨ ina u abe wö ralöm gɨlö me, mɨ unbö po hadred pipdi (450) ina. “Pen God kalɨp dam ram mɨnöŋ Kenan aui löm, bɨ manö ud asɨkep rɨmnap hag lö, kalɨp abad mɨdmɨdal. Hainö bɨ God manö hagep Samyuel mɨdeia ñɨn u, ");
INSERT INTO kpw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","nɨbi bɨ Isrel gau kale Samyuel nɨp hagla, ‘Ne kiŋ ap hag lö, hanɨp nɨbi bɨ magöŋhalö abad mɨdeinab,’ a gɨla. Hageila, God bɨ ne Kis ñɨ nɨpe Sol nɨp hag lö, kiŋ kale mɨdmɨdöp. Bɨ anɨbu Benjamin kɨgɨn rɨk damöm rɨk damöm rɨk lɨla. Sol kiŋ kale mɨdö, mɨ ñɨnjuöl mɨhöp (40) ina. ");
INSERT INTO kpw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pen hainö God nɨpe gö Sol kiŋ mɨdageia. God nɨpe Depid kiŋ kale hag la. God nɨpe Depid manö hagöm haga, ‘Hibur gasɨ mɨdmagö yad ke gasɨ göp rö u, Jesi ñɨ nɨpe Depid hibur gasɨ mɨdmagö nɨpe abe unbö rö nöp gasɨ göp; nan nɨhön nɨhön gaŋ a gɨ nɨŋnabin u, nɨpe anɨg unbö rö nöp gɨnab,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Pen God nɨpe gö, Depid ñɨ pai rɨkö, rɨk dam dapɨl göm, Jisas nɨp yag daula. Anɨb u, God nöd manö kƚö hag la rö, nɨpe Isrel nɨbi bɨ kalɨp Ud Kamɨŋ Yuep Bɨ ap yua. ");
INSERT INTO kpw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pen Jisas iƚ göm wög gaga magö u, Jon nɨpe apöm, Isrel nɨbi bɨ kalɨp haga, ‘Nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gɨpe, kalöp ñɨg pak ñɨnabin,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon wög nɨpe gɨ pɨs gɨnɨg geia ñɨn aŋ u, nɨbi bɨ gau kalɨp haga, ‘Kale yɨp bɨ an, a gɨmim, gasɨ nɨŋbim? Bɨ Kub pör abad mɨdpim bɨ u, yad wasö. Bɨ anɨbu hainö aunab. Ma rɨrup nɨpe u ud hubɨknam rö lagöp,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Añ mam yad, kale rɨmnap Ebraham ñɨ pai nɨpe mɨdpim; kale rɨmnap Juda nɨbi bɨ wasö pen God nɨp sabe gɨmɨdim. Krais nɨbi bɨ ud kamɨŋ yuep manö Jon hag ñɨ mɨdmɨdöp anɨbu, God nɨpe hanɨp nan a göm haga. ");
INSERT INTO kpw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem nɨbi bɨ gau abe, bɨ kub kale gau abe, Jisas nɨpe Krais u auub a göm nɨŋagla. Jisas nɨp al pak lɨlö umaŋ a gɨla u, God manö hagep manö kalɨ kƚiñ rɨkla rö nöp gɨla. Pen God nɨp sabe gɨnɨg Juda magum gep ram pör aumɨdal u, kale manö kalɨ kƚiñ rɨkla anɨbu pör pör nöp nɨŋmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nɨpe nan naij ap göp aka göm uƚhai wasö nɨŋöm gapman bɨ kub Pailod nɨp hagla, ‘Ne hagö nɨp al pak lɨlaŋ,’ a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pen God Manö haga rö, magöŋhalö nöp Jisas nɨp gɨla. Hainö nɨbi bɨ nɨpe gau apöm, wip he ud asɨk dam kabö mɨgan rɨgöl gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Rɨgöl gɨla u pen God gö kauyaŋ uraka. ");
INSERT INTO kpw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nɨpe uraköm, kamɨŋ mɨdö nɨŋöl gɨ, nɨbi bɨ nɨpe aip Galili nɨbö Jerusalem aula gau, nɨp ñɨn iru nöp nɨŋla rö, uri Isrel nɨbi bɨ kalɨp Jisas manö aij u hag ñaböl. ");
INSERT INTO kpw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Pen hol bɨ mɨhöŋ aubul i, kalöp Krais manö aij u hagnɨg aubul. God hadame nöp apɨs bac bɨ hon kalɨp manö kƚö hag löm gɨnabin a ga manö anɨbu nöp ");
INSERT INTO kpw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","gasɨ nɨŋ mɨdöm, God nɨpe Jisas nɨp ud urak ña. Ga anɨbu apɨs bac bɨ gau nɨŋagla u pen ñɨ pai rɨk lep kale gau mɨñi hon nɨŋbun. Depid nɨpe God Manö adɨŋ Sam a gɨpal au Kɨmap yɨgwö aŋ nɨbö kalɨ kƚiñ rɨköm haga, ‘Ne Ñɨ yad. Yad mɨñi Nap ne mɨdpin,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God nɨpe gö, Jisas uraka u me, hainö umöm hañ romaŋ hij gɨ lug lɨ arnɨm rö lagöp. Manö anɨbu God Manö adɨŋ ap anɨgöl mɨdöp: ‘Yad Depid nɨp manö uɫ kƚö nɨŋö hag lɨnö u kalöp nöp ñɨnabin,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pen God Manö adɨŋ ap anɨgöl mɨdöp: “‘Ne Bɨ Uɫ ne arö gö, hañ romaŋ nɨpe hij gɨ lug lɨ aragnɨm,’ a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Pen Depid nɨpe God wög nɨp hag la u, nɨbi bɨ nɨpe mɨdmɨdal ñɨn anɨbu gɨ damöm uma. Pen Depid nɨpe umö, nap nɨhi bɨ kalɨp rɨgöl gɨmɨdal gau dam rɨgöl gɨlö, hañ romaŋ nɨpe hij gɨ lug lɨ ara. ");
INSERT INTO kpw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pen God nɨpe gö uraka Bɨ anɨbu, hañ romaŋ nɨpe hij gɨ lug lɨ araga. ");
INSERT INTO kpw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Anɨb u, mɨdeimam nɨŋim. Jisas nɨpe umöm uraka u me, God nan si nan naij gɨpim u nɨŋöm arö gɨnab manö aij u kalöp hagabul. ");
INSERT INTO kpw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Hon Juda lo manö adö u nöp nɨŋun geinabun u, God nan si nan naij gɨpun u nɨŋ nöp mɨdeinab. Pen Jisas mab ba laŋ al pak lɨlö uma u me, hon Jisas nɨp nɨŋ udeinabun u, God nan si nan naij gɨpun u nɨŋöm, arö göm, hanɨp nɨbi bɨ aij yad, a gɨnab. ");
INSERT INTO kpw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pen bɨ God manö hagep gau hadame nöp hagla rö hanɨp gagnɨm, a gɨmim gasɨ u nɨŋ aij gɨmim. Kale hagla, ");
INSERT INTO kpw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kale nɨbi bɨ yɨp aɫab aɫab ñɨbim gau nɨŋim! Kale mɨdpim magö i, nan ke nɨbö ap gɨnabin. Nan gɨnabin anɨbu kalöp nöd hageinaböl u, ñɨƚoŋ lɨ hagaböl, a gɨ nɨŋnabim. Anɨb u, kale pa gɨl gɨl gɨmim böŋ nöp um hir gɨmim!’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol aip Banabas aip manö anɨbu hagmil, Juda magum gep ram anɨbu höŋ arlö nɨŋöl gɨ, nɨbi bɨ gau hagla, “God nɨp sabe gep ñɨn hain u kauyaŋ apil, hanɨp manö anɨbu rɨmnap halö hag ñɨmil,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nɨbi bɨ gau magum gɨ mɨdeila gau ram u arö göm, ke ke arlö nɨŋöl gɨ, Juda nɨbi bɨ kabö göl rɨmnap abe, nɨbi bɨ gau nɨbö Juda kai nɨŋmɨdal rö nɨŋ udla rɨmnap abe, Pol aip Banabas aip kalɨp hain göm arla. Adan aŋ au amöl gɨ, bɨ mɨhau kalɨp haglö, “‘God hanɨp mög nɨŋöm ud aij göp,’ a gɨmim, gasɨ u nɨŋöl gɨ nöp mɨdaimim,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pen Juda God nɨp sabe gep ñɨn hain u, nɨbi bɨ daun kub anɨbu mɨdeila gau magöŋhalö rö, Bɨ Kub manö nɨŋnɨg ap magum gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pen Juda bɨ kub gau nɨbi bɨ iru nɨbanö aula u nɨŋlö, mulu lugö, Pol Banabas kalɨp bɨ mɨhau kalɨp nɨŋöm gasɨ naij nɨŋla. Pol manö nɨhön nɨhön nɨbi bɨ gau kalɨp haga u hag juöm, hib nɨpe u hag pro gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Juda bɨ gau anɨg gailö, Pol aip Banabas aip pɨñɨŋ gagmil, manö pen kƚö hagmil haglö, “God Manö aij u kalöp Juda nɨbi bɨ nöd hagul a gɨpul u pen kale manö aij anɨbu udagmim, hon pör mɨdep magö u nɨŋ udun rö lagöp, a gɨpim u me, mɨñi Juda nɨbi bɨ wasö gau kalɨp hag ñɨnabul. ");
INSERT INTO kpw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nɨhön gɨnɨg: Bɨ Kub hanɨp hagöm manö anɨg göl haga, ‘Yad hagnö, kale Juda nɨbi bɨ wasö gau kalɨp mailö kale mɨdmim, ram mɨnöŋ ke ke gau ammim, nɨbi bɨ gau magöŋhalö mailö anɨbu nɨŋlö nɨŋöl gɨ, yad kalɨp ud kamɨŋ yunabin,’ a ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Juda nɨbi bɨ wasö gau manö anɨbu nɨŋöm, mɨñ mɨñ göm, Bɨ Kub manö u, manö aij unbö ke yabɨƚ, a gɨla. Anɨb u, nɨbi bɨ God, pör pör mɨdaiöl, a göm, hag la gau magöŋhalö manö aij anɨbu nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pen Bɨ Kub manö u, ram mɨnöŋ anɨb gau magöŋhalö haglö ara. ");
INSERT INTO kpw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Anɨg ga u, Juda nɨbi bɨ gau nɨŋlö mulu lugö, am Adiok nɨbi kub God nɨp nɨŋ udla rɨmnap abe, bɨ kub ram mɨnöŋ anɨbu abad mɨdmɨdal gau rɨmnap abe, kalɨp haglö, kale am nɨbi bɨ iru nöp dapöm, Pol aip Banabas aip kalɨp gɨ naij göm, ram mɨnöŋ kale gau hag höŋ yula. ");
INSERT INTO kpw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Anɨg gɨ hag höŋ yulö, bɨ mɨhau kale Adiok arɨk amöl gɨ, manö aij dam hag ñajul udagpim, a gɨmil, ma kale acɨp acɨp gau ƚɨk gɨ yumil ammil, daun kub Aikoniam arlö. ");
INSERT INTO kpw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pen Ana Uɫ nɨpe nɨbi bɨ Jisas nɨp nɨŋ udla gau ajmaŋ rauö, kale mɨñ mɨñ yabɨƚ göl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol aip Banabas aip am daun kub Aikoniam mɨdmil, Juda magum gep ram u ammil, manö hag ñɨ aij gɨlö nɨŋöl gɨ, Juda nɨbi bɨ gau löm, Juda nɨbi bɨ wasö gau löm, iru nöp Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pen Juda nɨbi bɨ rɨmnap, Jisas manö hagabil u nɨŋ udagnabun, a göm, amöm Juda nɨbi bɨ wasö gau kalɨp manö nɨŋeb nɨŋagep piral hageila nɨŋöm kale nɨbi bɨ Jisas nɨŋ udla gau kalɨp nɨŋlö mulu kal luga. ");
INSERT INTO kpw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pen Pol aip Banabas aip, manö anɨbu nɨŋmil, ram mɨnöŋ anɨbu arɨk araglö. Kale au nöp mɨdmil, Bɨ Kub manö u kƚö göm waiö nöp hag ñɨmɨdil. Bɨ Kub kalɨp mɨhöŋ aip abad mɨdö nɨŋöl gɨ, nan gagep rö rɨmnap, nan nɨŋeb nɨŋagep rö rɨmnap gailö, nɨbi bɨ rɨmnap nɨŋöm hagla, “Anɨb u, manö hagabil anɨbi nɨŋö nöp hagabil,” a göm, nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pen Aikoniam nɨbi bɨ anɨb gau asɨk ke ke löm, böŋ u Juda nɨbi bɨ gau manö hagla rö nɨŋla, böŋ u bɨ Jisas manö ud arep bɨ gau hagla u nöp nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pen Juda nɨbi bɨ rɨmnap gau löm, Juda nɨbi bɨ wasö rɨmnap gau löm, bɨ kub kale gau abe, Pol aip Banabas aip kalɨp gɨ naij gun, kabö ju pak lun, a göm, gasɨ u nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kalpe mɨhöŋ pen manö anɨbu nɨŋmil, pɨñɨŋ gɨ am daun kub mɨhau Lisdra Debi, ram mɨnöŋ Likonia au arlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ammil, anɨb gau gɨ ajöl gɨ, Krais manö aij u hag ñɨmɨdil. ");
INSERT INTO kpw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pen daun kub Lisdra anɨbu, bɨ ap nɨme nɨp yag daua ñɨn u nöp ma naij gö, adan ajagmɨdöp bɨ ap mɨdmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Bɨ anɨbu nɨpe ap asɨk mɨdöm, Pol manö hageia u nɨŋ mɨdeia. Pol bɨ anɨbu nɨp nɨŋ ij halö löm gasɨ nɨŋa, bɨ anɨbi, God yɨp gö kamɨŋ lɨnɨm rö löp, a gɨ gasɨ nɨŋmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Anɨb u, Pol nɨp nɨŋöm, meg mɨgan dap ranöm haga, “Urak!” a ga. Hagö, bɨ anɨbu yɨŋɨd uraköm, ma abö göm ara. ");
INSERT INTO kpw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pol anɨg gö, nɨbi bɨ nɨŋ mɨdeila gau manö yabɨƚ kale Likonia manö u hagöm hagla, “Bɨ kumi kabö adö laŋ nɨbö gau, god mɨhöp nɨbi bɨ rö lɨmil ap hagabil i,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Anɨg hagöm, Banabas nɨp, god Sus, a gɨla. Pen Pol nɨpe manö iru nöp hagmɨdöp rö, nɨp, god Hemis, a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","God piral Sus sabe gɨmɨdal anɨbu, sabe gep ram u yöp gɨ lɨla daun goƚ anɨb au me, god piral Sus sabe gep bɨ kub u abe, nɨbi bɨ au mɨdeila gau abe, god Sus pör sabe gɨpun u mɨñi auöp i, a göm, kaj kau nɨbar rɨmnap udöm, mab pɨƚpɨƚ aij aij rɨmnap ud dauö, nɨbi bɨ iru yabɨƚ aula. ");
INSERT INTO kpw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pen Pol aip Banabas aip, geila anɨbu nɨŋmil, waƚɨj kale gau ud bɨƚɨƚɨ gɨmil, nɨbi bɨ iru nöp mɨdeila aŋ anɨb au ammil haglö, ");
INSERT INTO kpw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kale nɨhön gɨnɨg anɨg gabim? Hol mɨhöŋ god wasö! Kale nɨbi bɨ yabɨƚ mɨdpim rö, hol u rö nöp unbö rö mɨdpun. Hol Jisas Krais manö aij nɨpe u kalöp hag ñɨnɨg aubul. God nɨpe kumi kabö laŋ gɨ löm, mɨnöŋ naböŋ iƚ i gɨ löm, ñɨg solwara u gɨ löm, nan nɨhön nɨhön mɨdöp gau magöŋhalö gɨ löm, ga. Hol kalöp Krais manö aij u haglo, nan yɨharɨŋ piral sabe gabim gau arö gɨmim, God kamɨŋ mɨdöp u nöp sabe gɨ mɨdaimim, a gul, kalöp hagabul. ");
INSERT INTO kpw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pen nöd nɨbi bɨ ram mɨnöŋ ke ke gau mɨdöm, gasɨ kale ke nɨŋöm nan yɨharɨŋ sabe gɨla u, God nɨŋöm kalɨp gɨ naij gaga. ");
INSERT INTO kpw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pen kale yɨharɨŋ mɨdagpim; nɨp nɨŋnɨg, nɨŋnabim. Nɨpe pör pör kalöp ud aij göp. Nɨpe nöp gö, möŋ alöm, nan magö iru nöp mɨdö nɨŋöl gɨ, mɨñ mɨñ göl gɨ nan ñɨŋbim. Anɨb u, nɨpe anɨg gab u nɨŋmim, nɨŋö nöp God hon mɨdöp u hadö nɨŋbep,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Anɨg haglö u pen, nɨbi bɨ anɨb gau, bɨ anɨb mɨhai i kumi kabö adö laŋ nɨbö aubil, a göm, kaj kau nɨbar rɨmnap pak sabe gɨ ñɨnɨg geila, uɫham yabɨƚ hag hag wasö gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pen kalpe mɨhöŋ daun kub Lisdra anɨbu nöp mɨdlö nɨŋöl gɨ, Juda kai daun kub Adiok, ram mɨnöŋ Pisidia au mɨdmɨdal nɨbi bɨ rɨmnap abe, daun kub Aikoniam mɨdmɨdal nɨbi bɨ rɨmnap abe apöm, nɨbi bɨ anɨb gau kalɨp piral hagöm hagla, “Bɨ mɨhau manö aij hagagabil; piral hagabil,” a gɨla. Anɨg hageila, nɨbi bɨ anɨb gau nɨŋöm, Pol nɨp kabö ju pak löm, böŋ nöp umöb, a göm, ɫɨp gɨ dam kabö waryö gɨgabö gɨla u höŋ adö löyaŋ yula. ");
INSERT INTO kpw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Anɨg gɨla nɨŋöm nɨbi bɨ Jisas nɨp nɨŋ udla gau ap bɨnɨg gɨgabö gɨlö nɨŋöl gɨ, Pol uraköm daun kub aŋ anɨbu ado gɨ ara. Pen ruö Pol aip Banabas aip Lisdra arö gɨmil Debi arlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","22","Pol aip Banabas aip Debi ammil, Jisas manö aij u nɨbi bɨ gau kalɨp hag ñailö, nɨbi bɨ iru nöp Jisas nɨp nɨŋ udla. Pen kalpe mɨhöŋ nöd aubul adö u nöp arul, a gɨmil, ado gɨ Lisdra, Aikoniam, Adiok ram mɨnöŋ Pisidia au amöl gɨ, nɨbi bɨ Jisas manö aij u haglö nɨŋ udla gau kalɨp kauyaŋ hag ñɨ aij göl gɨ arlö. Kalɨp hag ñɨ aij göl gɨ haglö, “Jisas manö aij u arö gagmim; nɨŋ udpim rö nöp nɨŋ ud mɨdaimim. Anɨg gɨpe, kalöp mɨŋör iru ñɨnaböl pen gasɨ u nɨŋagmim; God hanɨp udöm abad mɨdeinab, a gɨmim, kƚö gɨmim u nöp nɨŋbe arnɨm,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Anɨg hagmil, cöc ke ke anɨb gau, nɨbi bɨ Jisas nɨŋ udla gau bɨ nabɨc mɨdaiöl, a gɨmil, bɨ rɨmnap wög anɨbu hag lɨlö. Anɨg gɨmil, kalpe mɨhöŋ nan magö ñɨŋagmil, God nɨp sabe göl gɨ haglö, “Bɨ Kub, bɨ gai i nöp nɨŋ udpal rö, kalɨp abad mɨdaimön,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Anɨg göl ram mɨnöŋ Pisidia gau ajmil, ram mɨnöŋ Pampilia arlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pampilia ammil, Jisas manö aij u nɨbi bɨ Pega daun gau kalɨp hag ñɨmil, daun kub Adalia arlö. ");
INSERT INTO kpw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Adalia ammil, ñɨg magɨb udmil, daun kub Adiok, Siria Propins au, nöd mɨdmil aulö u ado gɨ arlö. Kale nöd arnɨg gailö, Adiok nɨbi bɨ Jisas nɨp nɨŋ udla gau, God nɨp sabe göm hagla, “Manö aij ne u nɨbi bɨ gau kalɨp hag ñɨnɨg arabil rö, kalɨp mɨhöŋ abad mɨd aij gɨmön,” a göm, kalɨp mɨhöŋ hag yulö, ammil, manö anɨbu hag ñɨ ajmɨdil. ");
INSERT INTO kpw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anɨb u, ado gɨ Adiok apil, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp wɨñ allö aueila, God nɨpe gö kale nɨhön nɨhön gɨla gau magöŋhalö hag ñɨ aij gɨla. Juda nɨbi bɨ wasö gau iru nöp Jisas manö aij u nɨŋ udla aiud u abe hag ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kalɨp anɨg göl hag ñɨmil, kalɨp aip ñɨn bad ap rapɨn mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pen bɨ rɨmnap ram mɨnöŋ Judia nɨbö Adiok apöm, bɨ Juda wasö Jisas nɨp nɨŋ udla gau kalɨp hag ñɨla, “Mosɨs hadame nöp hanɨp Juda nɨbi bɨ haga, ‘Ñɨŋaŋ gɨsön yag dapim, waŋ hañ kale rɨb gɨ dö gɨmim,’ a ga. Anɨb u, kale u rö nöp hañ rɨb gɨ dö gagnabim u, God kalöp ud kamɨŋ yuagnab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Anɨg hageila, Pol aip Banabas aip manö u kabö rö hagagaböl, a gɨmil, kalɨp aip manö pen pen haglö ara. Anɨg geila, Adiok nɨbi bɨ Jisas nɨp nɨŋ udla gau, nɨbi bɨ kale ke rɨmnap abe, Pol Banabas bɨ mɨhau abe hag löm hagla, “Kale Jerusalem ammim, manö anɨbi dam, bɨ Jisas manö ud arep bɨ gau abe, Jisas nɨbi bɨ nɨpe gau kalɨp abad mɨdpal bɨ gau abe kalɨp hag ñɨmim, kale pen hag amɨl apɨl göm gasɨ nɨhön nɨŋnaböl u nɨŋmim, ap hagpe nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anɨg hagöm, kalɨp hag yulö, kale am ram mɨnöŋ Pönisia aŋ au amöl gɨ, Juda nɨbi bɨ wasö gau Jisas nɨp nɨŋ udla manö anɨbu hag ñɨlö nɨŋöl gɨ, añ mam nɨŋöm magöŋhalö ñɨñɨ lɨla. Ram mɨnöŋ Pönisia anɨbu arö göm, kale amöm ram mɨnöŋ Sameria aŋ au amöl gɨ, manö u rö nöp hag ñɨlö nɨŋöl gɨ, añɨ mam gau u rö nöp nɨŋöm ñɨñɨ lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pen kale ram mɨnöŋ Sameria arö göm, amöm Jerusalem amjakeilö, nɨbi bɨ Jisas nɨp nɨŋ udla gau abe, bɨ Jisas manö ud arep gau abe, Jisas nɨbi bɨ nɨpe gau kalɨp abad mɨdeila bɨ gau abe, kalɨp hag wɨhai udöm aij auabim a gɨla. Hageila, Pol aip Banabas aip, God nɨpe gö nan nɨhön nɨhön gɨla u magöŋhalö kalɨp hag ñɨ aij gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Anɨg hagailö, Perisi bɨ Jisas nɨp nɨŋ udla gau rɨmnap uraköm hagla, “Juda nɨbi bɨ wasö gau Jisas nɨp nɨŋ udnaböl u, hañ rɨb gɨ dö göm, Mosɨs lo u hagab hagab rö nöp gɨlaŋ,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Anɨg hageila, bɨ Jisas manö ud arep gau abe, Jisas nɨbi bɨ nɨpe abad mɨdeila bɨ gau abe, manö anɨbu hag aij gun, a göm, ap magum gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ap magum göm, manö anɨbu hag amɨl apɨl gɨ mɨdlö nɨŋöl gɨ, Pida uraköm haga, “Mam bɨ. Kale nɨŋbim, nöd God hanɨp nɨme löm, Juda nɨbi bɨ wasö gau Jisas manö aij u nɨŋ udöl, a göm, yɨp hag lö, yad am kalɨp Krais manö aij u hag ñɨ ajmɨdin. ");
INSERT INTO kpw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God gasɨ rɨmɨd mɨdmagö hon magöŋhalö nɨŋöb u, Ana Uɫ hanɨp ña rö, Juda nɨbi bɨ wasö gau kalɨp u rö nöp ña. Anɨg ga u hon nɨŋbun, nɨpe kalɨp abe ud aij göp. ");
INSERT INTO kpw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hanɨp Juda kai manö ap ke hagöm, Juda nɨbi bɨ wasö gau kalɨp manö ap ke hagöm gagöp. Krais manö aij u nɨŋ udla u me, God nɨpe nan si nan naij gɨla gac mɨdmagö kalɨp aŋ daŋ mɨdeia u ƚɨk gɨ yua. ");
INSERT INTO kpw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","God Juda nɨbi bɨ wasö gau böŋ nöp uda rö, kale nɨhön gɨnɨg, neb neb göl gɨ hagpim, ‘Mosɨs lo manö kalɨ kƚiñ rɨköm haga haga rö nöp lo pro ap gagnabim u, God kalöp ud kamɨŋ yuagnab,’ a gɨpim? Asɨ masɨ gɨ aij gɨmim, a gɨpim u, apɨs bac bɨ gɨ wasö nɨŋla. Hon u rö nöp gɨ wasö nɨŋbun u, pen uri Juda nɨbi bɨ wasö Jisas nɨp nɨŋ udla gau kalɨp, mɨŋör anɨbu udöl, a gɨmim, hagabim ar? ");
INSERT INTO kpw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","U aij wasö. Bɨ Kub Jisas hanɨp Juda kai mög nɨŋöb u, iƚ añɨ anɨbu nöp me, Bɨ Kub Jisas nɨpe ke gö, hon nɨp nɨŋ udno, hanɨp ud kamɨŋ yunab. Anɨb unbö rö nöp, Bɨ Kub Jisas Juda nɨbi bɨ wasö gau kalɨp mög nɨŋöb u, iƚ añɨ anɨbu nöp me, Bɨ Kub Jisas nɨpe ke gö, kale nɨp nɨŋ udlö, kalɨp u rö nöp ud kamɨŋ yunab,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pen nɨbi bɨ ap mɨdeila gau magöŋhalö, manö ap hagöm wasö, agamɨj mɨdailö nɨŋöl gɨ, Banabas aip Pol aip kalɨp aiud udöm, kalpe mɨhöŋ ram mɨnöŋ ke gau gau amöl gɨ, Juda nɨbi bɨ wasö gau Jisas manö aij u hag ñɨ ajailö nɨŋöl gɨ, God nɨpe nan gagep rö gau, nan nɨŋeb nɨŋagep gau ga u, aiud u magöŋhalö kalɨp hag ñɨ aij gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pen bɨ mɨhau manö hag pɨs gɨlö nɨŋöl gɨ, Jems uraköm haga, “Mam bɨ. Manö hagnɨg gabin i nɨŋim! ");
INSERT INTO kpw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","God Juda nɨbi bɨ wasö gau kalɨp mög nɨŋöm ud aij göm, nɨbi bɨ yad ke mɨdeinaböl, a göm, hadö uda u, Saimon uri nöp manö hagöp u nɨŋbun. ");
INSERT INTO kpw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","God ga anɨbu, God manö hagep gau hadame nöp hagöm kalɨ kƚiñ rɨkla rö nöp ga. Manö anɨbu kalɨ kƚiñ rɨköm hagla, ");
INSERT INTO kpw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bɨ Kub nɨpe hagöp, “Hainö yad ado gɨ apem, Depid ram pa ƚuƚö gɨ pa jö gɨ luga u, yad ke kauyaŋ gɨ aij gɨnö, pɨdöŋ yabɨƚ mɨdnab. ");
INSERT INTO kpw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Anɨb u, Juda nɨbi bɨ wasö ram mɨnöŋ ke gau nɨbö gau nɨbö, rɨmnap nɨbi bɨ yad mɨdeinaböl a gɨpin gau, yɨp uƚhai nɨŋnaböl. ");
INSERT INTO kpw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nan nɨhön nɨhön hainö gɨnab u, yad Bɨ Kub hadame dagol gau hag lɨnö u me, anɨg hagabin,” a ga,’ a gɨla,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems manö anɨbu hagöm haga, “Gasɨ yad nɨŋbin u, Juda nɨbi bɨ wasö Jisas nɨp nɨŋ udnaböl gau, kalɨp mɨŋör rɨmnap ñagun. ");
INSERT INTO kpw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pen kalɨp köp kalɨ kƚiñ rɨk yuun hagun, ‘Nɨbi bɨ rɨmnap god piral gau nɨp nan sabe gɨ ñɨnɨg, wal kaj nan gau dam pakaiöl, kale ñɨŋagmim. Nɨbi si bɨ si gagmim. Wal kaj nan gau, hagape u ñɨŋagmim. Wal kaj nan gau rugu ud bu gɨlö umnɨm u ñɨŋagmim,’ a gun. Manö gau rö hagagun. ");
INSERT INTO kpw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pen ai gɨnɨg: bac bɨ hadame nöp gɨla rö, mɨñi u rö nöp daun gau gau magöŋhalö, God nɨp sabe gep ñɨn u Juda magum gep ram u am magum göm, pör pör manö Mosɨs hagöm kalɨ kƚiñ rɨka u amgö lɨ nɨŋmɨdal,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jems anɨg hagö, bɨ Jisas manö ud arep gau löm, bɨ Jisas nɨbi bɨ nɨpe gau kalɨp abad mɨdeila bɨ gau löm, nɨbi bɨ Jisas nɨp nɨŋ udla gau magöŋhalö löm, hagla, “Hon bɨ hon rɨmnap hag lɨno, Pol Banabas bɨ mɨhau aip Adiok arlaŋ,” a gɨla. Anɨg hagöm, bɨ Jisas nɨbi bɨ nɨpe gau abad mɨdeila bɨ mɨhöŋ Judas Basabas aip, Sailas aip, kalɨp hag lɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Köp ap kalɨ kƚiñ rɨköm, Pol Banabas bɨ gau ñɨla. Köp anɨg göl kalɨ kƚiñ rɨkla: Mam bɨ, kale mɨdpim? Hon namam kale, Jisas manö ud arep bɨ gau abe, Jisas nɨbi bɨ nɨpe gau kalɨp abad mɨdpil bɨ mɨhau abe, kalöp Juda nɨbi bɨ wasö daun kub Adiok abe, Siria Propins abe, Silisia Propins abe mɨdmim Jisas nɨp nɨŋ udpim gau, köp kalɨ kƚiñ rɨk yuabun. ");
INSERT INTO kpw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ai gɨnɨg: manö ap auub nɨŋbun, nɨbi bɨ hon gai i rɨmnap, hanɨp hag nɨŋöm wasö, gasɨ kale ke u nöp nɨŋöm, am manö kub kalöp gasɨ mɨlö lɨmim rö manö rɨmnap kalöp hag ñeila. ");
INSERT INTO kpw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Anɨb u, hon bɨ rɨmnap hon ke hag lɨno, bɨ mɨdmagö hon aij yabɨƚ Pol Banabas bɨ mɨhau seg nɨnaböl. ");
INSERT INTO kpw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol Banabas bɨ mɨhau gau ajmil, halɨp al pak lɨnaböl, a gɨmil, gasɨ u nɨŋagpil. Bɨ Kub Jisas Krais manö aij nɨpe u nɨbi bɨ gau kalɨp hag ñul, a gɨmil, gasɨ añɨ anɨbu nöp nɨŋmil, haƚöwaƚö hag ñɨ aij göl gɨ ajmɨdil. ");
INSERT INTO kpw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judas Sailas bɨ mɨhau yunɨg gabun. Kale ammil köp kalɨ kƚiñ rɨkabun i manö adö u nöp kalöp hag ñɨ aij gɨnabil. ");
INSERT INTO kpw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hon magum gun, manö anɨbu hag amɨl apɨl gɨno nɨŋöl gɨ, Ana Uɫ nɨpe hanɨp gasɨ aij ñö, köp kalɨ kƚiñ rɨkun mɨŋör rɨmnap kalöp ñagnabun, a gɨno. Yɨharɨ? manö mɨhöp nöp hagnabun a gun hagno. ");
INSERT INTO kpw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nɨbi bɨ rɨmnap god piral gau sabe gɨnɨg, wal kaj nan gau dam pakaiöl, kale ñɨŋagmim. Wal kaj nan gau, hagape u ñɨŋagmim. Wal kaj nan gau rugu ud bu gɨlö umnɨm u ñɨŋagmim. Nɨbi si bɨ si gagmim. Nan hagabun i arö gɨnabim u, gɨ aij gɨnabim. Manö hagpun me u. Kale mɨd aij gɨmim. Köp kalɨ kƚiñ rɨkla u me u. ");
INSERT INTO kpw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Köp anɨbu kalɨ kƚiñ rɨköm bɨ gau ñɨlö, kale Jerusalem arö göm, daun kub Adiok, Siria Propins gau ado gɨ arla. Amjaköm, nɨbi bɨ Jisas nɨp nɨŋ udla gau haglö, magöŋhalö ap magum gɨla nɨŋöm köp daula u ñɨla. ");
INSERT INTO kpw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Köp ñɨlö, nɨbi bɨ kale manö anɨbu amgö lɨ nɨŋlö, kalɨp aij yabɨƚ gö, gasɨ halö mɨdöm hibur kalɨp ñɨñɨ yabɨƚ la. ");
INSERT INTO kpw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Sailas bɨ God manö hagep bɨ mɨhau mɨdmɨdil me, ñɨn bad ap Adiok mɨdmil, Jisas nɨbi bɨ nɨpe gau kalɨp manö iru nöp hag ñɨ aij gɨlö nɨŋöl gɨ, kale Jisas manö aij nɨpe nɨŋ ud pɨdöŋ göm gasɨ halö mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Anɨg gɨmil hag ñɨ pɨs gɨmil, arnɨg gɨlö nɨŋöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla anɨb gau ap magum göm, sabe göm, Bɨ Kub kalpe mɨhöŋ abad mɨd aij gö, kale agamɨj mɨd aij gɨl, a göm, kalɨp mɨhöŋ hag yula. ");
INSERT INTO kpw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pen Pol aip Banabas aip Adiok au mɨdmil, bɨ anɨb gau nɨbö rɨmnap aip, Bɨ Kub manö aij u nɨbi bɨ gau kalɨp hag ñöl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pen mɨd damöm, Pol nɨpe Banabas nɨp haga, “Hol mɨhöŋ nöd ajul Bɨ Kub manö haglo ara ram mɨnöŋ gau, nɨŋ ud pɨdöŋ göl gɨ nöp mɨdpal aka gul, am nɨŋul auul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Hageia, Banabas haga, “Anɨb u, Jon Mak nɨp abe uɫ gɨ ud arul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Hageia, Pol haga, “Ñɨ anɨbu nöd uɫ gɨ ud arlo, wög gɨ haköm auaga; nɨpe Pampilia nöp amöm arɨk ara. Anɨb u, mɨñi nɨp uɫ gɨ ud aragnabul,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol anɨg hageia, kalpe mɨhöŋ ke nöp pen pen hagmil, Banabas nɨpe Jon Mak aip ñɨg magɨb udmil, ram mɨnöŋ ñɨg rɨb gus ga airan Saipras arlö. ");
INSERT INTO kpw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol nɨpe pen Sailas nɨp uda. Nɨbi bɨ Jisas nɨp nɨŋ udla gau, sabe göm, Bɨ Kub nɨpe Pol Sailas kalɨp mɨhöŋ abad mɨdeiaŋ, a göm, bɨ mɨhau hag yula. ");
INSERT INTO kpw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol nɨpe Siria Propins gau abe, Silisia Propins gau abe gɨ ajöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp God Manö rɨmnap halö hag ñɨ aij gö, kale nɨŋöm nɨŋ ud pɨdöŋ gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol Sailas kalpe mɨhöŋ aj aj lɨmil, Debi ammil, Lisdra amjaklö. Ram mɨnöŋ anɨb gau Jisas nɨp nɨŋ uda bɨ ap mɨdeia; hib nɨpe u Dimodi. Bɨ anɨbu nɨme nɨpe u Juda nɨbö nɨbi ap pen Jisas nɨp nɨŋ uda. Nap nɨpe u Grik nɨbö bɨ ap. ");
INSERT INTO kpw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lisdra nɨbi bɨ Jisas nɨp nɨŋ udla gau abe, Aikoniam nɨbi bɨ Jisas nɨp nɨŋ udla gau abe, Dimodi bɨ aij a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol pen, Dimodi yad aip Jisas manö u hag ñɨ ajaiul, a göm nɨŋa u pen, Juda nɨbi bɨ gau hagnaböl, “Dimodi nap nɨpe u Grik bɨ ap rö, ñɨ nɨpe hañ rɨb gɨ dö gaga rö, manö nɨpe u udagun,” a gɨnaböl, a gɨ gasɨ nɨŋöm, Dimodi nɨp dam arö hañ rɨb gɨ dö gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pol Sailas Dimodi kalpe daun daun gau gɨ ajöl gɨ, bɨ Jisas manö ud arep gau abe, bɨ Jisas nɨbi bɨ nɨpe gau kalɨp abad mɨdeila bɨ gau abe, Jerusalem gau magum göm manö nɨhön nɨhön hagla u, nɨbi bɨ Jisas nɨp nɨŋ udla gau kalɨp hag ñöm, anɨg anɨg gɨmim, a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Anɨg göl gau gau gɨ ajöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla gau, kalɨp Jisas manö aij u hag ñɨ aij gɨlö, kale manö anɨbu nɨŋ udöm, kƚö göm, nɨpe haga rö nöp gɨ mɨdeila. Ñɨn añɨ añɨ pör pör nɨbi bɨ rɨmnap halö Jisas manö aij u nɨŋöm, Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol bɨ nɨpe gau aip Esia Propins mɨdpal nɨbi bɨ gau kalɨp Krais manö aij hag ñun a göm, arnɨg geila u pen Ana Uɫ nɨpe, aragmim, a ga. Anɨb u, ram mɨnöŋ Prijia aŋ gau ajöm, Galesia Propins aŋ gau ajöm geila. ");
INSERT INTO kpw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kale am am, ram mɨnöŋ Misia sösöl apöl gɨ, Bidinia Propins arun a geila u pen Jisas Ana nɨpe kalɨp, aragmim, a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jisas Ana nɨpe anɨg hagö, kale Bidinia Propins aragla; ram mɨnöŋ Misia aŋ au aramöm daun kub Droas arla. ");
INSERT INTO kpw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Droas amöm, sɨbön aŋ yaŋ Pol naböŋ nɨŋa, bɨ Masedonia Propins nɨbö ap uraköl mɨdöm, nɨp manö neb neb gɨ hagöm haga, “Ne ñɨg ju böŋ i Masedonia aumön, hanɨp gɨ ñɨmön,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol anɨg gɨ naböŋ nɨŋaia, hon hagno, “U God nöp, Masedonia nɨbi bɨ kalɨp Jisas manö aij u am hag ñim, a göp,” a gun, magö anɨbu nöp Masedonia arnɨg gun nan gɨ jɨn gɨno. ");
INSERT INTO kpw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Am ñɨg magɨb udun, Droas arö gun, ram mɨnöŋ ñɨg rɨb gus ga airan Samodres arno. Ruö pen Samodres arö gun, Niapolis daun amjakno. ");
INSERT INTO kpw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ñɨg magɨb udun, Pilipai, Masedonia Propins aŋ au amjakno. Rom gapman nɨbi bɨ iru nöp aram Pilipai mɨdöm abad mɨdmɨdal. Anɨb u, ram mɨnöŋ aŋ au Pilipai daun kub yabɨƚ mɨdeia. Hon ñɨn bad ap Pilipai gau mɨdaino. ");
INSERT INTO kpw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Juda God nɨp sabe gep ñɨn u, God nɨp sabe gep ka ap mɨdeinab, a gun, daun ajöŋ arö gun, ñɨg goƚ gamɨŋ arno. Amun nɨŋno, nɨbi rɨmnap ap mɨdeila. Anɨb au asɨkun, kalɨp manö hag ñɨno. ");
INSERT INTO kpw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nɨbi nɨŋ mɨdeila anɨb gau, nɨbi ap daun kub Daiadaira nɨbö, hib nɨpe u Lidia. Nɨpe waƚɨj mu gau gɨ lö, raumɨdal. Nɨpe God nɨp sabe gɨmɨdöp. Bɨ Kub nɨpe nɨbi anɨbu nɨp gasɨ aij ñö, Pol manö aij haga u, nɨŋö hagab, a göm, nɨŋ uda. ");
INSERT INTO kpw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pen Lidia abe, nɨbi bɨ ram nɨpe aip hanla gau abe, kalɨp ñɨg pak ñɨno, Lidia haga, “Yad Bɨ Kub kabö göl nɨŋ udpin, a gɨmim nɨŋbim u, kale ap ram yad han mɨdaimim,” a ga. Hanɨp anɨg hagö, manö nɨpe udun, am ram nɨpe u hanno. ");
INSERT INTO kpw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Hon mañ ap God nɨp sabe gep ka u amun, pai nagɨ wög gep ap nɨp nable pakno. Pai anɨbu nɨp kɨjaki abaŋ alö, nan nɨhön nɨhön hainö gɨnab u, nɨbi bɨ gau kalɨp hag ñö, nɨp mani ñɨmɨdal. Nɨpe anɨg gö, bɨ nɨp rau daulö, nagɨ wög kalɨp gɨmɨdöp gau, mani kub udmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hon araino nɨŋöl gɨ, pai anɨbu hanɨp hain göl gɨ haga, “Bɨ gai i, God adö i gɨlaŋ mɨdöp u nɨp wög gɨpal. Kale nan nɨhön nɨhön geinabim, God kalöp ud kamɨŋ yunab, manö u nöp hagaböl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pen pai u manö anɨbu rö pör pör hag hag hag, ñɨn ap Pol iru yabɨƚ gö, ado göm kɨjaki pai abaŋ ala u nɨp haga, “Jisas Krais hib nɨpe u nɨŋmön, pai anɨbi nɨp arö gɨmön aru!” a ga. Adɨ? kɨjaki nɨp abaŋ ala u höŋ ara. ");
INSERT INTO kpw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pen pai anɨbu nɨp mani raulö, kalɨp nagɨ wög gɨmɨdöp bɨ gau, Pol kɨjaki hag yua manö u nɨŋöm, mani kub udpun u hainö udagnabun, a göm, Pol Sailas kalɨp mɨhöŋ ud sɨsɨ udöm Rom bɨ kub mɨdeila gau manö kub hagnɨg, ɫɨp gɨ dam manö hagep kuö u arla. ");
INSERT INTO kpw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rom bɨ manö ud asɨkep bɨ kub gau manö kub hagöm hagla, “Bɨ mɨhöŋ i bɨ Juda nɨbö. Daun kub hon i apil gɨlö, hon nɨbi bɨ ram mɨnöŋ hon nuö nɨbö i gɨlö yuö kal lugöp. ");
INSERT INTO kpw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hon Rom nɨbi bɨ manö nöd nɨbö adö u ke mɨdöp pen kale manö gɨsön nɨbö manö hon nɨŋagep u, nɨŋmim gɨmim, a gɨmil, hag ajabil,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nɨbi bɨ nɨŋ mɨdeila gau u rö nöp, manö adö anɨbu nöp hagöm, Pol Sailas kalɨp mɨhöŋ manö kub haglö, bɨ manö ud asɨkep bɨ kub gau hagla, “Waƚɨj kalɨp mɨhöŋ gau ud jumim, ur ud pakim,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Haglö, ur ud pak ado malo göm, dam nagɨ lep ram raul mɨgan u yuöm, bɨ nagɨ lep ram abad mɨdeia u nɨp hagla, “Kalɨp mɨhöŋ nɨŋ aij gɨ mɨdaimön,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Haglö, bɨ nagɨ lep ram abad mɨdmɨdöp u, kalɨp mɨhöŋ uɫ gɨ dam ram raul mɨgan yabɨƚ au yaŋ löm, ma kɨd kalɨp mɨhau ud mab kub mɨgan u yulö arö, pa rɨbɨk pɨdöŋ ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pen sɨbön aŋ kub yaŋ, Pol Sailas kalpe mɨhöŋ God nɨp sabe göl gɨ, kɨmap rɨmnap hag mɨdlö nɨŋöl gɨ, bɨ nagɨman rɨmnap kale apdi nɨŋ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Anɨg gailö nɨŋöl gɨ, naböŋ munmon kub yabɨƚ u udöm, nagɨ lep ram u halö ud daŋ i göm, ajöŋ gau ke hiɨköm, bɨ nagɨman gau kalɨp sen adɨkla gau magöŋhalö hubɨka. ");
INSERT INTO kpw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Anɨg gö, bɨ nagɨman gau kalɨp abad mɨdeia bɨ u uraköm nɨŋa, ajöŋ gau magöŋhalö hiɨköl mɨdeia. Nɨpe nɨŋöm, “Bɨ nagɨman gau, ajöŋ hiɨkö, pɨñɨŋ gɨ amhakpal rö, bɨ kub yad u yɨp al pak lɨnab,” a göm, ru mɨlö kɨd nɨpe ke u ud ɫɨp gɨ udöm, nɨpe ke bɨg lɨnɨg geia. ");
INSERT INTO kpw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol pen nɨp wɨñ kub al hagöm haga, “Nɨhön gɨnɨg ne ke bɨg lɨnɨg gabön? Hon pɨñɨŋ gɨ aragpun. Magöŋhalö mɨdpun i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pol anɨg hagö, nagɨman abad mɨdeia bɨ u wɨñ alöm haga, “Hapö yɨŋɨd dauim,” a ga. Hagö, hapö daulö, nɨpe dam gɨ dö gɨ ram raul mɨgan yaŋ amöm, anɨnɨn gö, gɨl gɨl göl gɨ, am Pol Sailas mɨdailö iƚ au kugom yɨma. ");
INSERT INTO kpw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pen anɨg göl kugom yɨmöm, uraköm, kalɨp mɨhöŋ uɫ gɨ höŋ yaŋ amöm haga, “Bɨ kub aij yad mɨhai, yad nɨhön geinam, God yɨp ud kamɨŋ yunab?” ö ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hageia, nɨp haglö, “Bɨ Kub Jisas nɨp nɨŋ udeinabön u, ne ke abe, nɨbi bɨ ne aip hanban gau abe, kalöp ud kamɨŋ yunab,” a gɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Anɨg hagmil, bɨ anɨbu nɨp abe, nɨbi bɨ nɨpe aip hana gau magöŋhalö abe, kalɨp Bɨ Kub manö aij u hag ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Anɨg hag ñɨlö, kalɨp mɨhöŋ sɨbön aŋ kub yaŋ nöp damöm, hañ romaŋ pakla gau ñɨg lɨ yua. Anɨg gö, magö anɨbu nöp nɨp abe, nɨbi bɨ nɨpe gau abe, kalɨp magöŋhalö ñɨg pak ñɨlö. ");
INSERT INTO kpw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kalɨp magöŋhalö ñɨg pak ñɨlö, bɨ nagɨman gau kalɨp abad mɨdeia bɨ u, kalɨp mɨhöŋ uɫ gɨ dam ram nɨpe damöm, nan magö ñö, ñɨŋlö. Bɨ anɨbu nɨpe ke abe, nɨbin ñɨ pai nɨpe gau abe, mɨñi hon God nɨp nɨŋ udpun, a göm, mɨñ mɨñ yabɨƚ göl gɨ mɨdeila. ");
INSERT INTO kpw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ruö pen, Rom bɨ kub gau polisman gau kalɨp hagla, “Bɨ nagɨ mɨdpil mɨhau kalɨp hubɨk yube, arɨl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Haglö, bɨ nagɨman gau kalɨp abad mɨdeia bɨ anɨbu, manö anɨbu dam Pol Sailas mɨdailö u amöm haga, “Manö ud asɨkep bɨ kub gau kalöp hagpal, ‘Hubɨk yube arɨl,’ a gɨpal. Anɨb u, kale mɨhöŋ arɨl. Bɨ Kub kalpe abad mɨd aij gö, agamɨj mɨd aij gɨ mɨdaimim!” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Hageia, Pol haga, “Hol mɨhöŋ u rö nöp bɨ Rom nɨbö mɨhau pen manö kub nɨŋöm wasö, nɨbi bɨ aŋ au halɨp mɨhöŋ ur ud pak ado malo göm, dam nagɨ lɨbal u, aij gagöp. Anɨb u, halɨp mɨhöŋ agamɨj pi göl hag yuun, a göm, hagaböl ar? Bɨ kub gau kale ke nagɨ lep ram i apöm, halɨp bɨ mɨhöŋ uɫ gɨ damöm, seg höŋ yaŋ arun,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pol anɨg hagö, polisman gau manö anɨbu nɨŋöm, ado gɨ am manö ud asɨkep bɨ kub gau kalɨp hag ñɨlö, Pol Sailas kale Rom nɨbö bɨ mɨhau manö u nɨŋöm, pɨñɨŋ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pɨñɨŋ göm, kale am Pol Sailas kalɨp bɨ mɨhöŋ uɫ gɨ damöm, seg höŋ yaŋ amöm, manö hain hain göm hagla, “Kalɨp mɨhöŋ aij geinab u, daun kub anɨbi arö gɨmil armil,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol Sailas nagɨ lep ram u arö gɨmil, nɨbi Lidia ram u am mɨdmil, nɨbi bɨ Jisas nɨp nɨŋ udla gau aip magum göm, Bɨ Kub manö aij kalɨp hag ñɨlö kale nɨŋöm, manö aij anɨbu udöm gasɨ halö mɨdöm mɨñ mɨñ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pen Pol Sailas kalpe mɨhöŋ daun kub Pilipai arö gɨmil, ammil daun kub Ampipolis amjaklö. Ampipolis arö gɨmil, am daun kub Apolonia amjaklö. Pen Apolonia arö gɨmil, am daun kub Desalonaika amjakmil nɨŋlö, Juda magum gep ram ap mɨdeia. ");
INSERT INTO kpw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nɨŋmil, Pol pör gɨmɨdöp rö, Juda God nɨp sabe gep ñɨn mɨhau nɨgaŋ, nɨbi bɨ gau aip Juda magum gep ram raul mɨgan u amöm, kalɨp aip manö hag amɨl apɨl ga. ");
INSERT INTO kpw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","God Manö iƚ u kalɨp hag ñɨ aij göm, God manö hagep bɨ gau hadame gau, Mesaia u ilön kub udöm umöm kauyaŋ uraknab a gɨla manö anɨbu hag ñɨ aij göm, “Mesaia u Jisas, bɨ kalöp hagabin i,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pol anɨg hagö, nɨbi bɨ rɨmnap nɨŋö hagöp, a göm, manö haga rö nöp nɨŋ udöm, Pol Sailas kɨd u arla. Nɨbi hib halö iru nöp abe, Grik nɨbi bɨ God nɨp nɨŋ udla iru nöp abe, Pol haga manö anɨbu nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pol Sailas manö haglö nɨbi bɨ iru nöp nɨŋ udeila u, Juda bɨ gau rɨmnap nɨŋlö, mulu lugö, bɨ naij yɨharɨŋ daun adan aŋ au mɨdeila gau rɨmnap udlö, kale pen am nɨbi bɨ iru nöp dap löm, manö pi pug kub yabɨƚ gɨla. “Pol Sailas kalɨp mɨhöŋ uƚhai nɨŋun, nɨbi bɨ gai i kalɨp ñɨno, bɨ mɨhau al pak lɨlaŋ,” a göm, am Jeson ram u urön gɨgabö göm uƚhai wasö nɨŋla. ");
INSERT INTO kpw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Uƚhai wasö nɨŋöm, Jeson nɨp udöm, nɨbi bɨ Jisas nɨp nɨŋ udla rɨmnap halö udöm, dam gapman bɨ kub mɨdeila au amöm, manö kub hagla. Manö kub hagöm hagla, “Pol Sailas bɨ mɨhau ram mɨnöŋ ke gau gau magöŋhalö ajmil haglö, nɨbi bɨ gau magöŋhalö manö pen pen manö hauƚ gɨpal. Pen mɨñi ap mɨdpil ram mɨnöŋ hon i. ");
INSERT INTO kpw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kale gapman bɨ kub hon Sisa manö nɨpe rɨb juöm, kiŋ hon ke ap mɨdöp, a göm, bɨ Kiŋ anɨbu Jisas a gɨpal. Pen bɨ Jeson i, bɨ anɨb mɨhau kalɨp dam ram nɨpe u lö han mɨdajɨl,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anɨg hageila, nɨbi bɨ iru nöp ap mɨdeila gau abe, daun gapman bɨ kub gau abe nɨŋöm, manö hauƚ kub yabɨƚ gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Manö hauƚ kub yabɨƚ göm, Jeson nɨp mani rɨmnap udöm, nɨbi bɨ nɨp aip daula gau mani rɨmnap udöm, hagla, “Hainö manö anɨbu kuöyaŋ gɨnabim u, mani kale anɨbi böŋ nöp udnabun,” a gɨla. Anɨg hagöm, kalɨp hag höŋ yula. ");
INSERT INTO kpw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sɨbön ga magö u nöp, nɨbi bɨ Krais nɨp nɨŋ udla gau Pol Sailas kalɨp mɨhöŋ dam yulö, daun kub Beria arlö. Beria amjakmil, Juda magum gep ram u arlö. ");
INSERT INTO kpw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ammil, Jisas manö aij u hag ñɨlö, Juda nɨbi bɨ Beria mɨdeila gau, nɨbi bɨ Desalonaika mɨdeila gau rö wasö; manö kalɨp mɨhöŋ u nɨŋlö, aij gö nɨŋöl gɨ, “Pol nɨŋö hagab aka?” göm, God Manö u ñɨn añɨ añɨ pör pör amgö lɨ nɨŋ aij gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pen Juda magum gep ram anɨbu nɨbi bɨ aula gau iru nöp Jisas nɨp nɨŋ udla. Grik nɨbi hib mɨdeia gau u rö nöp, iru nöp Jisas nɨp nɨŋ udla. Grik bɨ u rö nöp, iru nöp Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pen Pol am Beria nɨbi bɨ kalɨp God Manö hag ñab, a gɨlö, Juda nɨbi bɨ Desalonaika mɨdmɨdal gau manö anɨbu nɨŋlö, mulu lugö, apöm, Beria nɨbi bɨ kalɨp manö neb neb gɨlö, kal junɨg geila. ");
INSERT INTO kpw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Anɨg gö nɨŋöl gɨ, nɨbi bɨ Jisas nɨp nɨŋ udla gau, Pol nɨp dam yulö, ñɨg solwara goƚ gau ara. Pen Sailas Dimodi bɨ mɨhau Beria au mɨdailö. ");
INSERT INTO kpw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pen bɨ rɨmnap Pol nɨp dam daun kub Adens yuöm, ado gɨ arnɨg geila nɨŋöm Pol kalɨp haga, “Sailas Dimodi kalɨp mɨhöŋ hagpe, yɨŋɨd auɨl,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol nɨpe Sailas Dimodi kalɨp mɨhöŋ daun kub Adens au abad mɨdöl gɨ nɨŋa, nɨbi bɨ anɨb gau god piral kale sabe gɨmɨdal nan gau, iru yabɨƚ nöp mɨdeia. Nɨpe nɨŋö, hibur nɨp u naij yabɨƚ ga. ");
INSERT INTO kpw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Anɨg gö, Juda magum gep ram u amöm, Juda nɨbi bɨ gau rɨmnap abe, Grik nɨbi bɨ God nɨp nɨŋ udla rɨmnap abe, kalɨp aip manö hag amɨl apɨl gɨmɨdöp. Pen ñɨn añɨ añɨ pör pör manö hagep kuö au amöm, nɨbi bɨ ap mɨdeila gau, kalɨp aip u rö nöp manö hag amɨl apɨl gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Daun kub Adens anɨbu, nɨbi bɨ gasɨ adö ke ke nɨŋla gau, hib ke ke hagöm, rɨmnap Epikorian nɨbi bɨ a gɨla, rɨmnap Sɨdowɨk nɨbi bɨ a gɨla. Ñɨn ap, Pol nɨbi bɨ anɨb gau kalɨp Jisas umöm uraka manö aij u hagö, Epikorian bɨ gasɨ aij nɨŋeb rɨmnap, Sɨdowɨk bɨ gasɨ aij nɨŋeb rɨmnap, Pol manö haga u nɨŋöm, nɨp aip hag amɨl apɨl göm, rɨmnap hagla, “Bɨ manö hib ñɨg löp manö u nɨhön manö hagnɨg gab?” ö gɨla. Pen rɨmnap hagla, “Nɨbi bɨ mɨlö gau sabe gɨpal god kale gau rö nöp hagab,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Pen Pol nɨp dam kansol kai mɨdeila u amöm hagla, “Ne manö gɨsön ke nɨbö nɨbi bɨ gau kalɨp hagabön u, mɨñi hanɨp u rö nöp hag ñɨ aij gö, hon abe manö iƚ anɨbu nɨŋ aij gun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pen nɨbi bɨ Adens nɨbö gau abe, nɨbi bɨ ke gau nɨbö apöm Adens mɨdeila gau abe, manö gɨsön nɨbö rɨmnap nɨŋun hag mɨdaiun, a göm, gasɨ u nöp nɨŋmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol pen nɨpe kansol kai mɨdeila aŋ au uraköm haga, “Kale Adens nɨbi bɨ. Yad nɨŋbin kale kƚö yabɨƚ gɨmim, nan rɨmnap sabe gun, a gɨmim, gasɨ u nɨŋbim. ");
INSERT INTO kpw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Yad gai i ajem nɨŋbin, kale kabö ana ke ke gɨ lɨmim, nan ke ke sabe gɨpim rö, hib u adö anɨbu kalɨ kƚiñ rɨkpe. Pen kabö bɨd nan sabe gɨ ñeb ap gɨ lɨbe u, hib u kalɨ kƚiñ rɨkpe, ‘Bɨ sabe gɨpal nɨŋagpun u, kabö ana nɨpe me i,’ a gɨpe. Manö nɨŋagpun, a gɨmim, kalɨ kƚiñ rɨkpe anɨbu, mɨñi kalöp manö iƚ u hagnɨg gabin. ");
INSERT INTO kpw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“God mɨnöŋ naböŋ iƚ i gɨ löm, nan mɨnöŋ naböŋ iƚ i mɨdöp gau magöŋhalö gɨ löm ga u, nɨpe Bɨ Kub yabɨƚ. Kumi kabö adö laŋ abe, mɨnöŋ naböŋ iƚ i abe, Bɨ Kub mɨdöm abad mɨdöp. Nɨbi bɨ gau God sabe gep ram ñɨmagö kale gɨ lɨlö, nɨpe ap ram aŋ anɨb gau mɨdagnab, wasö. ");
INSERT INTO kpw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nɨpe hanɨp gɨ löm, ake bad u yuö, ake löl gɨ mɨdpun. Nan hon gau magöŋhalö nɨpe nöp ñöb. Nɨpe Bɨ kƚö naij anɨbu, hon ñɨmagö hon nan aij ap gun nɨp ñun rö lagöp. ");
INSERT INTO kpw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nɨpe bɨ añɨ ap nöp, Adam nɨp gɨ lö, Adam nɨpe pen rɨk damöm, rɨk dam dapɨl gɨlö, mɨñi nɨbi bɨ ke ke gau mɨnöŋ naböŋ iƚ i rɨgoŋ rɨgoŋ magöŋhalö gau mɨdpun. Pen God nɨpe nöp nöd gasɨ nɨŋöm gaia me, nɨbi bɨ rɨmnap ram mɨnöŋ ap ap mɨdöm, mɨd damöm, hainö nɨpe ke haga ñɨn u, nɨbi bɨ gau nɨbö rɨmnap ap ka kale anɨbu udpal. ");
INSERT INTO kpw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God nɨpe ke gasɨ nɨŋöm gab u, ñɨn rɨmnap uɫham mɨdöm, yɨp uƚhai nɨŋöm, ud rɨrɨkoƚ göl gɨ gɨ, yɨp uƚhai nɨŋ udöl, a göm, gab. Pen nɨp nɨŋ udnɨg geinaböl u, nɨpe hon magöŋhalö mɨlö gau mɨdagöp. Hon aip mɨdöp i. ");
INSERT INTO kpw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ñɨmagö adö nɨpe u me, hon mɨdpun. Pen bɨ manö kalɨ kƚiñ rɨkep kale ke rɨmnap, ‘Hon abe ñɨ pai nɨpe mɨdpun,’ a gɨpal u, nɨŋö hagpal. ");
INSERT INTO kpw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Pen hon God ñɨ pai nɨpe mɨdpun rö, gol, silpa, kabö gau udun, gasɨ hon ke nɨŋun, ñɨmagö hon ke nan rɨmnap ana gɨ lun, sabe gagun. ");
INSERT INTO kpw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nöd God manö aij nɨpe nɨŋagmɨdal rö, kalɨp manö kub hagaga. Pen uri nɨbi bɨ ram mɨnöŋ ke gau gau magöŋhalö kalɨp hagab, ‘Nan si nan naij gɨpim u, nɨhön gɨnɨg anɨg gɨpun, a gɨmim, arö gim,’ a gab. ");
INSERT INTO kpw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Hainö nɨpe ke nöp nɨŋöb ñɨn u, Bɨ nɨpe hag la u nɨp yuö apöm, nɨbi bɨ mɨnöŋ naböŋ iƚ i mɨdpal magöŋhalö manö kub hagöm, nɨme lɨnab. Hon nɨŋbun, Bɨ manö kub hagnab anɨbu, nɨp al pak lɨlö umö, God gö kauyaŋ uraka. Anɨg ga u, nɨbi bɨ gau magöŋhalö nɨŋöm, manö kub hagnab haga u, waiö nöp haga u nɨŋlaŋ a göm ga,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pol, bɨ ap umöm uraköp manö hagajɨp u nɨŋöm, nɨbi bɨ mɨdeila gau rɨmnap hag mɨhol gɨla; pen rɨmnap hagla, “Ñɨn rɨmnap halö manö anɨbu kauyaŋ hagaimön nɨŋun,” a gɨla. ");
INSERT INTO kpw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Anɨg haglö nɨŋöl gɨ, Pol kansol kai mɨdeila gau kalɨp arɨk ara. ");
INSERT INTO kpw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pen daun kub Adens anɨbu, nɨbi bɨ rɨmnap Pol manö nɨp u udöm, Jisas nɨp nɨŋ udla. Nɨbi bɨ anɨb gau me, bɨ ap hib nɨpe u Dionisias. Nɨpe bɨ kub kansol kub kale ram mɨnöŋ anɨbu nɨbö bɨ ap. Nɨbi ap hib nɨpe u Damaris. Pen nɨbi bɨ rɨmnap halö abe Jisas nɨp nɨŋ udla. ");
INSERT INTO kpw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol daun kub Adens arö göm, daun kub Korid gau ara. ");
INSERT INTO kpw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pol Korid amöm nɨŋa, bɨ Juda ber mɨhau mɨdailö. Nugmul hib u Akwila; nɨp ram mɨnöŋ Podas yag daulö, kub göm nɨpe ju dam ram mɨnöŋ Idali, daun kub Rom söl au, mɨdmɨdöp. Pen hainö gapman bɨ kub Klodias, Juda nɨbi bɨ rɨmnap Rom mɨdagaiöl, a gö, Akwila aip nɨbin nɨpe Prisila aip, Idali arö gɨmil, am Korid au mɨdailö. Pen Pol, ber anɨb mɨhau am nɨŋnɨg göm, ram kalpe ara. ");
INSERT INTO kpw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bɨ ber anɨbu, kale sel ram gɨmɨdil. Pen Pol u rö nöp wög anɨbu rö gɨmɨdöp u me, am kalɨp aip han mɨdöm, sel gau gɨmɨdal. ");
INSERT INTO kpw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pol nɨpe pen, Juda nɨbi bɨ gau abe, Grik nɨbi bɨ gau abe, kale magöŋhalö Jisas manö aij u nɨŋ udlaŋ, a göm, Juda God nɨp sabe gep ñɨn u, nɨpe pör pör Juda magum gep ram u amöm, kƚö göm kalɨp aip manö hag amɨl apɨl gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pen hainö Sailas aip Dimodi aip Masedonia Propins arö gɨmil, Pol Korid mɨdeia au aulö, Pol nɨpe pör pör Jisas manö aij u hag ñɨ dam dam, Juda nɨbi bɨ gau kalɨp manö hag ñöm, Mesaia pör abad mɨdmɨdun u me Jisas nöp, a gɨmɨdöp. ");
INSERT INTO kpw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pol anɨg hageia, Juda nɨbi bɨ gau manö nɨpe u nɨŋagöm, nɨp hag juöm, manö naij haglö nɨŋöl gɨ, Pol nɨpe, Jisas manö aij u nɨhön gɨnɨg arö gɨpal, a göm, waƚɨj nɨpe u pɨpal paköl gɨ haga, “Yad kalöp Jisas manö aij u hag ñɨnö nɨŋagpim rö, God kalöp ud kamɨŋ yuagnab u, nan kale ke. Mɨñi kalöp Juda nɨbi bɨ arö gem, Juda nɨbi bɨ wasö gau kalɨp am hag ñɨnabin,” a ga. ");
INSERT INTO kpw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pol anɨg hagöm, kalɨp arö göm, bɨ Juda wasö ap ram u ara. Bɨ anɨbu hib nɨpe Didias Jasdas. Nɨpe God nɨp sabe gɨmɨdöp. Ram nɨpe u Juda magum gep ram goƚ söl au. ");
INSERT INTO kpw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pen Krispas, bɨ Juda magum gep ram abad mɨdmɨdöp bɨ u, nɨbi bɨ nɨpe aip han mɨdeila gau aip Jisas nɨp nɨŋ udla. Daun kub Korid gau, nɨbi bɨ rɨmnap iru nöp, Pol Jisas manö aij hag